﻿USE sofia;
DROP TABLE IF EXISTS sofia.hvn_vpl;
CREATE TABLE hvn_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES hvn_vpl WRITE;
INSERT INTO hvn_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Na dꞌee ke, lii hagꞌa dꞌara. Lii pedꞌèii jꞌara lua Ana Deo. Ne ngara Noo, Yesus Kristus, do pejꞌèuꞌe rai uru ri Deo. Mi nahee ne kepue lii pedꞌèii ène: ");
INSERT INTO hvn_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Uru ngadꞌo jꞌèga dae Yesus, pepue uru ri Deo he dèu, ne ngara noo Johani. Johani peꞌure ta la pemoko rujꞌara tuu lua dèka Yesus. Rai uru rai telora, do pake ke ri Deo, he dèu, ne ngara noo Yesaya, ta mone ubꞌa unu Noo. Do bꞌuke ke ri noo, mihe ane: “Dꞌèno nga woie! Pejue ri Yaa ne dèu Yaa, la pemoke rujꞌara natuu Èu. ");
INSERT INTO hvn_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Noo hine do ta kako la era do kehii-kejidꞌo, jꞌe lango ri noo: ‘Hari-hari dèu pemoke nga woie rujꞌara, mijꞌe ta hapo lua dèka Muri. Pemira rujꞌara tuu ta hème Noo.’ ” ");
INSERT INTO hvn_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","6","Johani do tima ta pale ri dèu he, mone peherani dèu. Ne era pee noo, pa era do kehii-kejidꞌo. Ne bꞌara pake noo ngati rèu bꞌada unta. Dari wake noo ngati kuri bꞌada. Ne ngaꞌa-nginu noo, kebꞌara nga donahu oni. (Muri mada Johani, helaꞌu nga Elia uru he). Pa awe na ène, dèu ti kota Yerusalem, nga ti propensi Yudea harièle, dèka la peꞌabu nga Johani la era pee noo. Ne dèka roo dꞌèi ta la ngède Johani, nga dꞌèi ta dꞌèno ne lii ajꞌa noo. Ta lii ke Johani, mihe ane, “Kelolo mola we ne hala-ludèumuu, jꞌe hani ri muu ne muri mada muu dodꞌo mèdꞌèipa Deo, mijꞌe lonye pemèu ri Deo ne lubꞌu-hèro nga menyilu muu harièle. Jꞌe herani muu, ta he èhi rutada ta do èla ke muu pe peꞌie nga Deo.” Nadèu do kelolo ne hala-ludèuroo, peherani ri Johani pa loko Yarden. ");
INSERT INTO hvn_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Pedae lema ri noo, “Bꞌole pengee yaa ri muu ta do nga kuaha. Do ta dèka leto ngati yaa he dèu do rihi mone ae kuaha ngati yaa. Jꞌèma ledꞌo yaa ta dèu pejuu Noo. ");
INSERT INTO hvn_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Peherani muu ri yaa, ri èi we, tapulara nengaa ne do ta tao ri Noo hine, rihi ri ko ngaa do tao ri yaa. Noo ke do ta wie ne Hengaa Megala Deo la dꞌara ade muu.” ");
INSERT INTO hvn_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Pa dꞌara awe do na ène, ta dèka ke Yesus ti rae Nasare pa propensi Galilea la peꞌabu nga Johani. Ta peherani ke Noo ri Johani pa loko Yarden. ");
INSERT INTO hvn_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Mi nahère Yesus ne mèhu èni ti dꞌara èi nee, ta ngède ke ne liru-bèla ta boka èni. Ta puru ke ne Hengaa Deo la Yesus, mi koro jꞌawa. ");
INSERT INTO hvn_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Jꞌe rènge ne lii pedai Deo ti liru-bèla, mihe ane, “Èu ke dꞌee, Ana dꞌèi Yaa. Èu ke ne do pemengèlu dꞌara Yaa.” ");
INSERT INTO hvn_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ta èla pe mi nahère, ta pereda ke pa Yesus ri Hengaa Deo, ta kako la era do kehii-kejidꞌo. ");
INSERT INTO hvn_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Pee Noo pa nii èpa nguru lodꞌo ne tui, helaꞌu nga bꞌada èdèuhe. Pa era na ène, dèka ne Kètu wango la hèko Noo mijꞌe ta pedèue noo, tapulara nara dꞌo. Dèka ne dèu pejuu Deo ti liru-bèla la pemoke Noo. ");
INSERT INTO hvn_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ta èla Johani, mone peherani dèu, pe pemaho la èmu bꞌèdo, ta kako ke Yesus la propensi Galilea, la pedae pe peke ne Lii Hagꞌa Dꞌara ngati Deo pa nii. ");
INSERT INTO hvn_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ta pedai ke Noo, mihe ane, “Dꞌèno ri muu! Dꞌai ke ne awe pa Deo! Na dꞌee, toi ke ri harièle dèu ta Deo ne do pereda! Ri mi nahère ke, hani ko ne hala-ludèumuu! Jꞌe pedèue ne Lii Hagꞌa Dꞌara ngati Deo.” ");
INSERT INTO hvn_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Pa dꞌara he lodꞌo, ta nèru ke Yesus oro ngidi èi lobo Galilea. Ta ngède ke ri Noo he dèu, ne ngara noo Himo, nga ari noo Anderia. Hari do dꞌue roo, pa dꞌara jꞌala nadèuu. Na nee ke, ne jꞌèga roo helodꞌo-helodꞌo. ");
INSERT INTO hvn_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Moko ke Yesus ta pedoa roo, mihe ane, “Ama ee! Mai we ma pedèue Yaa. Do tima ke muu ta kale nadèuu. Na dꞌee ta pejadꞌèi muu ri Yaa ta la kale dèu ta pedèue Yaa.” ");
INSERT INTO hvn_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ta rèngi mi nahère, ta hani dꞌènge ke ne jꞌala roo, jꞌe la pedèue Noo. ");
INSERT INTO hvn_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Nèru hudi ngati ène, ta ngèdi ke ri Noo, ana ri Sabadeu. Mone aꞌa, ne Jꞌako. Johani, mone ari. Hari do dꞌue roo pa dꞌara pemoko ne pèku pa dꞌara kowa roo. ");
INSERT INTO hvn_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ta pedoa ke roo dꞌue ri Yesus, mihe ane, “Ama ee! Mai we muu ma pedèue Yaa.” Ta kèdꞌèidꞌènge ke roo, hani ama roo nga harièle dèu do jꞌèga helaꞌu nga roo pa dꞌara kowa nee. Roo dꞌue la pedèue Yesus. ");
INSERT INTO hvn_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ta dꞌai ke Yesus nga do èpa dèu do pedèue Noo he la kota Kapernaum. Pa lodꞌo hebꞌajꞌa do Jahudi, ta maho ke Yesus la èmu hebꞌajꞌa nee, jꞌe wie ne lii ajꞌa pa ène. ");
INSERT INTO hvn_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Madalae tèra harièle ne dèu do dꞌèno lii ajꞌa Noo, ri do toi woie rowi Noo ne ihi lii ajꞌa Noo. Ne lii ajꞌa Noo do wala ngati lii ajꞌa guru agama Jahudi he. ");
INSERT INTO hvn_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Pa awe do na ène, era he dèu do maho ri wango. Ta maho le ke noo, la dꞌara èmu hebꞌajꞌa nee, jꞌe pekaa ne wango do pa dꞌara noo, mihe ane, ");
INSERT INTO hvn_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Wo! Yesus, do Nasare! Ta ma ngaa ke jꞌii ri Èu? Ta ma peꞌapa jꞌii ri Èu? Tade Èu ri jꞌii. Ta Èu ke ne do dèka pedèuu nga lii jaji Deo. Èu dꞌee, Dèu do dꞌo iꞌa tao hala-ludèu.” ");
INSERT INTO hvn_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ta jꞌege ke noo ri Yesus, mihe ane, “Petèmo ne ubꞌa èu! Mèhu èni ti dꞌara dèu do na dꞌee!” ");
INSERT INTO hvn_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ta kedꞌèji ke ne dèu na ène, ri kuaha wango do era pa dꞌara ngiꞌu noo. Ta mèhu èni ne wango nee, nga pekaa do mèdèu ");
INSERT INTO hvn_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Harièle ne dèu do pa dꞌara èmu hebꞌajꞌa ne ta hengodo ke. Jꞌe pedai roo he dèu nga he dèu, mihe ane, “Lai ngaa na dꞌee? Pereda ri Noo wango ta mèhu èni, ta pedèuu we. Lii ajꞌa do wiu? Tèra-tèra ne kuaha Dokepai dꞌee!” ");
INSERT INTO hvn_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ta jꞌari ke dèu he, ta pedai he dèu nga he dèu, menyèla la harièle rae-kowa pa propensi Galilea. ");
INSERT INTO hvn_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ta mèhu èni ke roo ngati èmu hebꞌaja nee, jꞌe hare Yesus la èmu Himo nga Anderia. Mi nahère lema Jꞌako nga Johani do penau helaꞌu nga roo. ");
INSERT INTO hvn_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ne ina matu ri Himo do bèjꞌi ta emo. Ta dꞌai roo ne maho la dꞌara èmu nee, ta pika ke dèu pa Yesus ta, “Nèi do emo jꞌe rena weka nee.” ");
INSERT INTO hvn_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ta maho ke Yesus la pehodꞌe rena weka nee. Ta pèro ri Noo ne wolaèba rena weka nee, jꞌe pekèdꞌe. Ta ie dꞌènge ke ne emo noo. Jꞌe kèdꞌèila pemoko ngaꞌa-nginu natuu roo. ");
INSERT INTO hvn_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ta jèna ne lodꞌo, dèka ke ne dèu lowe he nga ègu dèu do pèdꞌa, nga do maho ri wango. Ami roo ta la peꞌie ri Yesus. ");
INSERT INTO hvn_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Harièle dèu pa dꞌara rae na ène, dèka la peteni pa hedꞌapa èmu do na ène. ");
INSERT INTO hvn_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ae keraꞌa pèdꞌa ne dèu he, peꞌie harièle ri Yesus. Ae ne wango do hudꞌèiri Noo ti dꞌara dèu he. Lara ri Yesus ne wango he ta bꞌole pedai lii, ri do tade ke Noo ri roo. ");
INSERT INTO hvn_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Pa dꞌara perèmo mèu rai, ta kèdꞌèike Yesus ti èmu do na ène. Kako Noo la era do kehii la hebꞌajꞌa, la pedai lii nga Deo. ");
INSERT INTO hvn_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Dꞌai ne kebꞌèdi Himo nga ihianga noo, peꞌee dꞌoke Yesus. Ta la kale ke ri roo Yesus. ");
INSERT INTO hvn_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ta dꞌai roo ne pehapo nga Yesus, ta lii ke roo, “Wo Ama. Ae ne dèu do la kale Ama.” ");
INSERT INTO hvn_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ta lii ke Noo, mihe ane, “Ie lema. Tapulara rihi ie dii ta pekèdꞌèila rae-rae do wala do peꞌumu pa dꞌee. Ne dꞌèi Yaa, la pedae leko pa roo ne Lii Hagꞌa Dꞌara ngati Deo. Ri ne dèka Yaa tuu lai na dꞌee ke.” ");
INSERT INTO hvn_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ta kako ke Yesus pehero hari hewue propensi Galilea, jꞌe pedae ne Lii Hagꞌa Dꞌara ngati Deo pa dꞌara harièle èmu hebꞌajꞌa roo. Hudꞌèilema ri Noo ne wango ngati dèu he. ");
INSERT INTO hvn_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Pa awe na ène, ta dèka ke he dèu do pèdꞌa kusta nga Yesus. Ta dꞌai noo la hedꞌapa Yesus ta lèku rutuu ke noo, jꞌe ami, mihe ane, “Muri yae! Ruba kowe ne dꞌara Èu, ta peꞌie ne pèdꞌa yaa! Mijꞌi dodꞌo bꞌege dꞌara loro ne dèu he nga yaa. Kido dꞌèi tèra, Muri nga yaa.” ");
INSERT INTO hvn_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ta meloro ke ne ade Yesus nga noo. Ta jꞌole ri Yesus ne wolaèba Noo jꞌe bꞌuje ne dèu na ène, jꞌe lii Noo, “Ne dꞌèi Yaa, ie we èu.” ");
INSERT INTO hvn_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Pa dꞌara awe do na ène, ele dꞌènge ne pèdꞌa noo. Bꞌale ne ngiꞌu noo mi patima. ");
INSERT INTO hvn_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ta lii ke Yesus pa noo, ta bꞌale la èmu nga jaji made-made pa noo, mihe ane, ");
INSERT INTO hvn_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Henge pe woie! Ie ke èu. Bꞌole la pedꞌèii pa nadèu we! Petobe we ri èu ne lua petèka Musa rai uru he. Kako uru la pengèdi èni pa kètu agama, mijꞌe ta pereha ri noo ne ngiꞌu èu, ta do ie tèra ke, we adꞌo. Jꞌe èba èu ne bꞌara jꞌola ta he èhi rutada terima kasi, mijꞌe toi ri dèu do lowe he ta do ie tèra ke èu.” ");
INSERT INTO hvn_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Tapulara, ta dꞌai noo ne mèhu èni, ta kako ke noo la pedꞌèii pa mii-pa mii. Pelai ti mi nahère, ae tèra ne dèu do la kale ta peꞌabu nga Yesus, tade dodꞌo wae ke Yesus ta pengèdi èni pa roo pa dꞌara rae. Ta la pee ke Noo pa era-era do kehii. Maji lema ta mi nahère, pee ma ne dèu he ta pejila nga Yesus ti harièle kebꞌihu rai. ");
INSERT INTO hvn_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ta ludèupèri lodꞌo, ta bꞌale rike Yesus la Kapernaum. Ta menyèla ke ne lii pa rai na ène, ta nèi ke Noo pa èmu. ");
INSERT INTO hvn_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ta dèka ke ne dèu do rihi ae ti mii-mii. Bèra huke-huke ne dꞌara èmu ne hape la tele. Ta pika ke ri Yesus pa roo ne lua do dꞌèi Deo. ");
INSERT INTO hvn_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Pa dꞌara nga pedai lii ko Yesus, ta dèka ke do èpa dèu nga meree he dèu do redꞌo ta èbe nga Yesus. ");
INSERT INTO hvn_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ri do bèra huke-huke ke ne dèu, dꞌai dꞌo ke roo ta ègo ne dèu ne nga Yesus. Ta haꞌe ke roo la dèni èmu, jꞌe lebo ne dèni èmu pemira nga Yesus. Ta boo ne dèni èmu nee, pedꞌule ke ri roo ne do redꞌo ne pa dꞌara dèpi merèi noo. ");
INSERT INTO hvn_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ta ngède ri Yesus ne jꞌèga roo, ta toi ke ta do parahajꞌa tèra roo pa Noo. Ta lii ke Yesus pa do redꞌo nee, mihe ane, “Ana Yaa ee! Èla ke ri Yaa pe pehuba ne hala-ludèuèu.” ");
INSERT INTO hvn_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Pa ène era lema do mejèdꞌèido pèri dèu guru agama Jahudi. Ta dꞌai ri roo ne rènge ne lii pedai Yesus, mèdꞌèidꞌo pa dꞌara ade roo. ");
INSERT INTO hvn_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Ta pedai ke roo, mihe ane, “Bꞌani tèra Noo ta pedai mi nahii! Deo we miha do nara ta pehuba hala-ludèudèu. Lii pedai Noo dꞌee, ta paha èni Noo ta helaꞌu nga Deo. Èla ke ri Noo pekare Deo!” ");
INSERT INTO hvn_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Tapulara toi ri Yesus nengaa ne do pa dꞌara pengee roo. Ta lii ke Noo pa roo, “Ta ngaa ke muu ne pengee mi nahère? ");
INSERT INTO hvn_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","10","Na mii do rihi memudꞌe pedèue pengee muu? Ki pali Yaa, pa do redꞌo na ène, ‘Èla ke ri Yaa pe pehuba ne hala-ludèuèu, ‘toi dꞌo ri muu ta do tajadꞌèi we adꞌo. Tapulara ki pali Yaa, ‘Kèdꞌèiwe! Lule ne dèpi èu, jꞌe bꞌale.’ Ki kèdꞌèidꞌènge noo, toi tèra ke ri muu, ta Yaa do nga kuaha nga higa ta pehuba hala-ludèudèu. Ri Yaa dꞌee, Dèu Rai-wawa do Petuu-Petuu.” Ta lii ke Yesus pa dèu do redꞌo nee, mihe ane, ");
INSERT INTO hvn_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Dꞌèno ee! Ie ke èu! Kèdꞌèiwe, lule ne dèpi èu, jꞌe bꞌale.” ");
INSERT INTO hvn_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ta rènge ri noo ne lii Yesus, ta kèdꞌèidꞌènge ke noo. Èbe ne dèpi noo, jꞌe pekèdꞌe. Ngède ri namada hari-hari dèu do era pa ène. Ta madalae ke roo harièle. Jꞌe lii, “Wee! Ngèdi dedꞌo di ta pehapo nga lai do mi nahee. Tèra-tèra ne kuaha Deo!” ");
INSERT INTO hvn_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Èla pe mi nahère, ta bꞌale rike Yesus la ngidi èi lobo Galilea. Ae ne dèu do dèka la peꞌabu nga Noo, jꞌe pepeke ri Noo ne lua dꞌèi Deo pa roo. ");
INSERT INTO hvn_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Pa ène, era he dèu ne ngara noo Lewi, ana ri Alpeu. Noo, do jꞌèga pa era maꞌi bꞌea unu do pereda Roma. Pa dꞌara nga nèru Yesus jꞌara ène, ta ngède ke ri Noo Lewi. Ta lii ke Yesus pa noo, “Ama ee! Mai ma pedèue Yaa!” Ta rènge ne lii pedoa Yesus, ta kèdꞌèidꞌènge ke Lewi, jꞌe pedèue Noo. ");
INSERT INTO hvn_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Èla pe na ène, Yesus he mejèdꞌèita ngaꞌa pa èmu Lewi, helaꞌu nga ihianga Lewi do mone hèmi doi bꞌea he. Pedèuu petèka pengee do Jahudi, ae keraꞌa dèu do muri mada pa dꞌara apa, do mejèdꞌèita ngaꞌa helaꞌu nga Yesus. Ae ti telora roo do mejèdꞌèita ngaꞌa helaꞌu, do dꞌèi ta dꞌèno ne lii pedai Yesus. ");
INSERT INTO hvn_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Pa awe na ène, era do pèri dèu guru agama ti kejie Parisi he, do ngède Yesus mejèdꞌèita ngaꞌa helaꞌu nga mone hèmi doi bꞌea, nga dèu do muri mada pa dꞌara apa he. Ta kebꞌali ke roo pa ana ajꞌa Yesus, mihe ane, “Ta ngaa Guru muu ne ngaꞌa helaꞌu nga mone hèmi doi bꞌea he, nga dèu do muri mada pa dꞌara apa he?” ");
INSERT INTO hvn_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Do rènge ri Yesus ne lii kebꞌali roo, ta bꞌale ke ri Noo, mihe ane, “Dèu do pèdꞌa do paraluu dote, tapulara dèu do kehèdèu adꞌo do paraluu. Ne dèka Yaa ta ma hewewe ne dèu do muri mada pa dꞌara apa he. Adꞌo dèka ta ma hewewe dèu do pengee ne muri mada noo ta do petuu.” ");
INSERT INTO hvn_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Pa dꞌara he wari, dèu ti kejie agama Parisi pa dꞌara puasa. Ngèdi ri roo, ana ajꞌa Johani, mone peherani dèu, do puasa lema. Tapulara ngèdi dꞌo ri roo ne ana ajꞌa Yesus he ta do puasa mi roo le. Ta kako ke roo la peꞌabu nga Yesus, jꞌe kebꞌali, mihe ane, “Ama. Jꞌii he pa dꞌara puasa. Mi nahère lema, ana ajꞌa Johani he. Ta ngaa ke ne ana ajꞌa Èu ku dodꞌo puasa?” ");
INSERT INTO hvn_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ta bꞌale ke ri Yesus pa roo, mihe ane, “Toi ri muu, ki era rame peloko ngaꞌa, do pedoa he puasa dꞌo, tapulara ngaꞌa tade bꞌèhu. Kiri mone peloko ngaꞌa ne do era ko, ngaꞌa-nginu mengèlu dꞌara helaꞌu roo harièle. ");
INSERT INTO hvn_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ki jadꞌèi he ne lai, ne mone peloko ngaꞌa nee, mahido ri dèu, jꞌe èbe perai, pa awe na ène ke, ne ihianga noo ne hedèu pengee, jꞌeꞌitu puasa.” ");
INSERT INTO hvn_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ta wie rike ri Yesus he èhi ne lii pehèku, mihe ane, “Bꞌule dꞌo dèu do kelapu bꞌara do mèje ri bꞌèla do wiu. Ki dꞌai ne bꞌahe, kepudꞌu ne bꞌèla do wiu nee, juu mehiu ne bꞌara na ène. ");
INSERT INTO hvn_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Mi nahère lema, bꞌule dꞌo dèu do hali dèu la dꞌara haba wo mèje. Tatu ta boo ne haba nee, jꞌe huti harièle ne dèu la rai. Hèku, dèu do wiu, do tatu ta hali pa dꞌara haba do wiu.” (Mi nahère ke, lii ajꞌa Yesus do wowiu, bꞌole pekiwo nga lii ajꞌa do dèu do unu do Parisi). ");
INSERT INTO hvn_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Pa dꞌara he wari, pa lodꞌo hebꞌajꞌa do Jahudi, ta lake ke Yesus jꞌara ngidi maa gandèu. Ta gꞌètu hidèuke ne wuri gandèu ri ana ajꞌa Noo, jꞌe ngaꞌa. ");
INSERT INTO hvn_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Do ngèdi ne tao roo ri do Parisi he, moko ta lii ke roo pa Yesus, mihe ane, “Ta ngaa ne ana ajꞌa Èu ne pèga lua petèka pa dꞌara agama dii? Roo he, do gꞌètu are-gandèu pa lodꞌo pengaha ihi. Adꞌo muu do jꞌèma ta tao mi nahère!” ");
INSERT INTO hvn_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Ta bꞌale ke ri Yesus, mihe ane, “Mi na mii, we? Hewina dꞌoke muu nengaa ne do tao ri Dau? Pa awe na ène, Abyata ne do jadꞌèi Kètu Mone Ae agama. Ta dꞌai Dau nga harièle dèu lere noo, hèpo èle ri menganga. Ta maho ke roo la dꞌara Leo Hebꞌajꞌa pa Deo, la èbe ne roti do èla pe petale ri kètu agama he tuu Deo, jꞌe ngaꞌe ri roo. Ne petuu he, roti na ène, ngaꞌe ri kètu agama he we, ie dꞌo ta ngaꞌe ri dèu do hewala. Maji lema ta ngaꞌe ri Dau he, bꞌule dꞌo he dèu he do lii ta do hala.” ");
INSERT INTO hvn_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ta lii rike Yesus pa roo, “Bꞌole bèlo ri muu, ne peꞌera ri Deo ne lodꞌo pengaha ihi natuu ta wie ne mèngi pa dii, dèu rai-wawa. Tao dꞌo dii dèu rai-wawa ri Deo, tuu ta ma pedèue lua petèka-kewèhu lodꞌo pengaha ihi we. ");
INSERT INTO hvn_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Yaa ke na dꞌee, Dèu Rai-wawa do Petuu-Petuu. Yaa ke na dꞌee, do nga higa ta lii pa dèu ta jꞌèga, ki adꞌo bꞌole jꞌèga, pa lodꞌo pengaha ihi.” ");
INSERT INTO hvn_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Èla pe na ène, ta maho rike Yesus la dꞌara èmu hebꞌajꞌa. Pa ène, ta ngède ke ri Noo, he dèu do made ne kae-ngaꞌa helaa. ");
INSERT INTO hvn_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Pa ène lema, era do pèri dèu do kale lai ta pehale Yesus. Ta pehodꞌe hudi-hudi ke Noo ri roo, ngee-ngee ta peꞌie ri Noo ne dèu do pèdꞌa na ène pa lodꞌo pengaha ihi nee. ");
INSERT INTO hvn_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ta pedoe ke ri Yesus ne dèu do made ne kae-ngaꞌa helaa nee, jꞌe lii, mihe ane, “Mai ma titu ma hedꞌapa dꞌee.” ");
INSERT INTO hvn_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ta kebꞌali ke Yesus pa roo harièle, ane Noo, “Ki pedèuu lua petèka agama dii, nengaa leke do ie ta tao pa lodꞌo pengaha ihi? Tao ie, we tao apa? Ta peꞌie dèu dii, we ta pemade dèu?” Bꞌule dꞌo he dèu he do boka ubꞌa. ");
INSERT INTO hvn_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Pèdꞌa ne ade Yesus, heleo roo do rihi pekebꞌue lua petèka agama, nga dèu do made ne kae-ngaꞌa helaa. Ta bubu dꞌara ke Yesus, jꞌe kewèle ela heleo roo hari-hari. Ta lii ke Noo pa dèu do pèdꞌa nee, “Pemole ne kae-ngaꞌa èu do made ne!” Ta pemole ke ne kae noo, ta ie dꞌènge ke. ");
INSERT INTO hvn_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ta mèhu èni ke harièle ne do Parisi he ti dꞌara èmu hebꞌajꞌa nee. Ta la pelii ke roo nga dèu ti paratei Herode, ta kale rujꞌara ta pemade Yesus. ");
INSERT INTO hvn_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Pa dꞌara hewari, ta lari èni ke Yesus nga ana ajꞌa Noo la ngidi èi lobo Galilea. Pelai ta do toi ke, ri dèu lowe nengaa ne do èla petao ri Noo, ri mi nahère ae ne dèu do dèka ngati harièle rae-kowa, la pedèue Noo. Era do dèka ti propensi Galilea, propensi Yudea, nga ti propensi Idèuea. Era lema hadꞌe do dèka ngati kota Yerusalem, kota Sidon, nga ti kota Tirus. Era lema do wala, do dèka ti bara dimu loko Yarden. Harièle roo dèka ta la peꞌabu nga Noo. ");
INSERT INTO hvn_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Pelai ta rihi ae ne dèu, ta lii ke Noo pa ana ajꞌa Noo, ta pemoke hewue kowa natuu Noo. Ne dꞌèi Noo ta pedai lii ti ra kowa, mijꞌe ta rèngi roo, lema mijꞌe ta ngèdꞌe Noo ri harièle dèu. ");
INSERT INTO hvn_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Do uru, ae dèu pèdꞌa do peꞌie ri Noo. Ri mi nahère ke, ae ne dèu pèdꞌa do dèka la perubꞌi ta tade dꞌae ta bꞌuje Noo. ");
INSERT INTO hvn_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ta ngède Yesus ri dèu do maho ri wango he, ta dèka ke roo la mejura pa hedꞌapa Yesus. Jꞌe pekaa roo, mihe ane, “Tèra-tèra Èu ke, ne Ana Deo nee!” ");
INSERT INTO hvn_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Tapulara ta lara made ke ri Noo pa roo, mihe ane, “Bꞌole pedai muu nga dèu, ta nadèu Yaa na dꞌee!” ");
INSERT INTO hvn_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ta èla pe na ène, ta haꞌe ke Yesus la hewue lede. Ta pedoa ri Noo do pèri dèu do mèdꞌèipa Noo. Ta dèka ke roo nga Noo. ");
INSERT INTO hvn_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ta pidꞌèike ri Noo, do henguru do dꞌue. Jꞌe lii Noo pa roo, “Ne pidꞌèimuu, mijꞌe ta pedèue loro-loro Yaa. Ta pejuu muu ri Yaa, ta la pepeke ne Lii Hagꞌa Dꞌara ngati Deo pa hari-hari dèu. ");
INSERT INTO hvn_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ta wie ri Yaa pa muu ne kuaha, ta hudꞌèiwango ti dꞌara dèu he.” ");
INSERT INTO hvn_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","19","Ne do henguru do dꞌue he, ne ngara roo nahee: Himo (do pehune ne ngara ri Yesus, ta Petu), Jꞌako, Johani, (Jꞌako nga ari noo Johani, helaꞌu ta ana ri Sebedeu. Ne ngara roo dꞌue do pehune ri Yesus, ‘Boanerge’, pa dꞌara lii rai dii ‘mi dꞌoro’.) Anderia, Pelipu, Bartolomeo, Mateo, Toma, Jꞌako (ana ri Alpiu), Tadiu, Himo (ti paratei Selot), nga Juda Iskario (do mone pewie Yesus). ");
INSERT INTO hvn_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ta èla pe na ène, ta puru ke Yesus nga ana ajꞌa Noo ti lede nee. Jꞌe bꞌale la dꞌara èmu. Ta dèka rike ne dèu do rihi ae la pewore Noo, tade dodꞌo bꞌule Yesus he nga awe kehoo ta ngaꞌa. ");
INSERT INTO hvn_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ta toi ri roo mi nahère, ta lii ke roo, “Heleo ko ri muu Yesus. Toi tala dꞌoke ne ngiꞌu Noo.” Ta rèngi ri tuèhu Noo ta do mi nahère, ta dèka ke roo la èbe Noo. ");
INSERT INTO hvn_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Pa ène, era lema guru agama do dèka ti Yerusalem, la pedai nga dèu pa ène, mihe ane, “We! Muu he bꞌole pedèue Yesus. Ne iꞌa Noo hudꞌèiwango, ri èla penara kuaha ti kètu wango, do tima ta pale ta Balsebuu.” ");
INSERT INTO hvn_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ta rèngi ri Yesus ne lii pedai roo, ta pedoa ke roo hari-hari, jꞌe lii, “Maho dꞌo la dꞌara pengee dèu! Mi namii ne jadꞌèi kètu wango ne hudꞌe ngiꞌu noo miha! ");
INSERT INTO hvn_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Kiri pa dꞌara hewue rai pereda, dèu rai do pana ta pemuhu, mi namii rai pereda na ène ne nara ta kako nga woie! ");
INSERT INTO hvn_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Mi nahère lema pa dꞌara hewue èmu, kiri harièle dèu pa dꞌara èmu ne petadi ta pehala, mi namii dꞌara èmu na ène ne nara ta titu nga woie. ");
INSERT INTO hvn_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Mi nahère lema ke wango, kiri pemuhu roo nga roo, tatu ta menyèla kebali-bali! ");
INSERT INTO hvn_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Kiri era dèu do la boka èmu he dèu do rui, ujꞌe uru ko ne dèu na ène. Èla pe mi nahère, memudꞌe ke noo ne èba bꞌara dèu nee. ");
INSERT INTO hvn_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ta pika dꞌènge Yaa pa muu: Deo do moko ke ta lonye ne hala-ludèudèu. Ki lua peꞌapa ngara dèu he, Deo do ta pehuba ko ma ne hala-ludèuroo. ");
INSERT INTO hvn_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Tapulara ki era dèu do bꞌani ta pedai woapa jꞌara lua Hengaa Megala Deo, nara dꞌo ta pehuba ri Deo ne hala noo, hape la lodꞌo namii-mii.” ");
INSERT INTO hvn_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ne pedai Yesus mi nahère, ri èla ke roo pelii ta Yesus do èla pemaho ri wango. ");
INSERT INTO hvn_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ta dèka ke ina ri Yesus nga ari Noo he la èmu na ène, ta la peꞌabu nga Noo. Ta titu ke roo pa tele, jꞌe pejuu dèu la pedoe Noo. ");
INSERT INTO hvn_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Pa awe na ène, Yesus do mejèdꞌèipedai lii nga dèu lowe he. Ta la pika ke ne dèu pa Noo, mihe ane, “Ama ee. Ina Èu nga ari Èu he, hei pa tele nee. Ne dèka roo ta ma pehapo nga Ama.” ");
INSERT INTO hvn_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Tapulara ta bꞌale ke ri Yesus, mihe ane, “Nadèu ke, ne ina Yaa nga tuèhu Yaa do petuu ne?” ");
INSERT INTO hvn_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ta heleo ke ri Noo ne dèu do mejèdꞌèipehero Noo, jꞌe lii, “Muu ke harièle nahee, ne ina nga tuèhu Yaa do petuu. ");
INSERT INTO hvn_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Nadèu we ne do jꞌège ne lua do dꞌèi Deo, roo tèra ke ne tuèhu Yaa.” ");
INSERT INTO hvn_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Pa dꞌara hewari, ta kako rike Yesus la èi lobo Galilea. Ta dèka rike ne dèu do rihi ae la peworle Noo. Ta haꞌe ke Noo la dꞌara hewue kowa do penawo pa ène, jꞌe wie ri Noo lii ajꞌa pa roo. Harièle ne dèu do pa kolo lede dꞌèno ne lii ajꞌa Noo. ");
INSERT INTO hvn_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ae ne lii ajꞌa do wie ri Noo pa dꞌara lii pehèku, mihe ane, ");
INSERT INTO hvn_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Dꞌèno ri muu nga woie! Era he dèu do kako la liba wini pa dꞌoka noo. ");
INSERT INTO hvn_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ta dꞌai ne liba ri noo ne wini he, era do bui la dꞌara rujꞌara. Dèka ne dolila he, la tutu pe èla. ");
INSERT INTO hvn_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Era wini do bui la wurai wowadèu Mèriai ne muri nga woie. Pelai ta do menii ne wurai, ");
INSERT INTO hvn_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","ta dꞌèia lodꞌo, ta merajꞌu dꞌènge ke, jꞌe made. Ri adꞌo do nara ta merèma ne dꞌulu amo. ");
INSERT INTO hvn_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Era lema hadꞌe ne wini do bui la roꞌa jꞌuꞌu ae. Tapulara hengèpe ri jꞌuꞌu he, jꞌe lara podꞌo-podꞌo iꞌa dꞌo wue-wila. ");
INSERT INTO hvn_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Tapulara era lema wini do bui pa wurai do woie. Muri roo nga woie, mengèru-merede tade era nga wue-wila. Ne wue roo, era do tèlu nguru wari lipa, era do èna nguru wari lipa, era lema do hengahu wari lipa. ");
INSERT INTO hvn_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Nadèu do nga dꞌèi ta dꞌèno, tenae pe woie, mijꞌe tada muu!” ");
INSERT INTO hvn_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Pa dꞌara nga kiha miha Yesus, ta dèka ke ne do henguru do dꞌue ana ajꞌa Noo, nga do pèri dèu do èla pe rèngi ne lii pehèku Noo. Ta ami roo ta peteleo ne ihi lii pehèku Noo. ");
INSERT INTO hvn_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ta bꞌale ke ri Yesus pa roo, mihe ane, “Ri do dꞌèi tèra muu ta toi ne lua pereda Deo, ta peteleo ke ri Yaa pa muu ne ihi lii pehèku na ène. Tapulara pa dèu do hewala he, wie ri Yaa pa dꞌara lii pehèku. ");
INSERT INTO hvn_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Tuu roo ke, ne lua do èla pebꞌuke ri mone ubꞌa Deo, mihe ane, ‘Ngèdi ma ri roo, tapulara wae dꞌo ta tada. Rèngi ma ri roo, tapulara wae dꞌo ta oha. Hani we roo mijꞌe ta dꞌo parahajꞌa nga Deo, mi dꞌo nara ta pehuba ne hala-ludèuroo ri Deo.’ ” ");
INSERT INTO hvn_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Èla pe mi nahère, ta peteleo ri Yesus ne pejꞌara lii pehèku nee, mihe ane, “Ki dꞌo tada ke muu pejꞌara lii pehèku na ène, mi namii muu ne tada pejꞌara lii pehèku do wala? ");
INSERT INTO hvn_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ne pejꞌara noo, mi nahee: dèu do liba wini nee, helaꞌu mi dèu do pedae-pepeke ne Lii Hagꞌa Dꞌara ngati Deo. ");
INSERT INTO hvn_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Wini do bui pa dꞌara rujꞌara, jꞌe tutu èle ri dolila, helaꞌu mi dèu do dꞌèno ne lii pedai Deo. Tapulara tui dꞌo, dèka ne kètu wango la èbe peꞌèle lii pedai ne ti dꞌara ade dèu na ène. ");
INSERT INTO hvn_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Wini do bui pa wurai do wowadèu helaꞌu mi dèu do dꞌèno, jꞌe hème nga mengèlu dꞌara ne lii pedai Deo. ");
INSERT INTO hvn_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Tapulara, muri dꞌo nga woie, ri adꞌo do dꞌulu amo. Ri mi nahère ke, lii pedai na ène eta dꞌo pa dꞌara ade dèu na ène. Ki nara noo hedèu ri dèu do hewala, taga ri hème lii pedai na ène, ta hore dꞌènge ke ri noo. ");
INSERT INTO hvn_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Wini do bui pa roꞌa jꞌuꞌu ae, helaꞌu mi dèu do dꞌèno lii pedai Deo. ");
INSERT INTO hvn_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Tapulara, ri rihi noo ne petadi kale muri mada do gaa do keleꞌe pa rai-wawa na dꞌee. Ri lai na ène ke, ne nyèke lii pedai Deo ti dꞌara ade noo, ku bꞌule dꞌo nga guna nengaa pa muri mada noo. ");
INSERT INTO hvn_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Wini do bui la wurai do woie, helaꞌu mi dèu do dꞌèno woie, jꞌe hème ne lii pedai Deo, jꞌe jꞌège pedèue ne do dꞌèi Deo. Ta jꞌège ri noo harièle lai do ie, mi wini do muri nga woie tade wue tobo kolo. Ne wue noo, era do tèlu nguru wari lipa, era do èna nguru wari lipa, era lema do hengahu wari lipa.” ");
INSERT INTO hvn_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ta petuwe ri Yesus ngati dꞌara kowa nee. Ta wie rike ri Noo hewue ne lii pehèku, mihe ane, “Mi namii! Ngèdi muu, we adꞌo? Dèu do tunu lapu, jꞌe henèbꞌe ri hope. Ki adꞌo tèke pa dꞌaꞌi era bèjꞌi. Adꞌo, to? Ki mi nahère, teleo dꞌo. Ne tima dèu ta pejèdꞌèilapu pa era do dꞌèia, mijꞌe ta teleo. ");
INSERT INTO hvn_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Lai do dꞌo teleo dae, do ta peteleo ma hine. Lai do dꞌo toi dae ri dèu do na ène, do ta toi ma hine. ");
INSERT INTO hvn_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Nadèu do nga dꞌèi ta dꞌèno, tenae pe woie, mijꞌe tada muu!” ");
INSERT INTO hvn_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ta pelore rike ri Yesus, “Pengee ko ri muu pe woie! Ruluji do pake ri muu, ta luji wue ai muri mada dèu do hewala, do ta pake ri dèu ta luji muu. Deo do ta luji lema muu mi nahère. Tapulara ruluji Deo do rihi mejèni. ");
INSERT INTO hvn_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Hèku nadèu do nga lua dꞌèi tèra ta kale ne lua do dꞌèi Deo, juu mèu dꞌara noo. Tapulara, dèu dodꞌo wae nga lua do dꞌèi Deo, juu bꞌodꞌo.” ");
INSERT INTO hvn_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Èla pe mi nahère, ta lii rike Yesus, mihe ane, “Rai pereda Deo juu worena, unupala mi wini do lebe ri dèu pa dꞌara dꞌoka noo. ");
INSERT INTO hvn_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ta èla pe lebe, ta bꞌale ke ne dèu do oha ne la èmu la bèjꞌi nga dꞌo henge wari ne wini do lebe ri noo. Tapulara muri ne wini nee, juu kepai. ");
INSERT INTO hvn_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ne wini na ène, muri nga miha unu, jꞌe era nga rèu, ke hèbꞌa, tade wue-wila. ");
INSERT INTO hvn_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Kiri ihi ke, dèka ne do oha ne la gꞌèto noo. Mi nahère lema rai pereda Deo. Harièle nahère, do tao ri Deo.” ");
INSERT INTO hvn_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ta lii rike Yesus, mihe ane, “Ne riko hewue lii pehèku jꞌara lua dèu do unu Deo he. Petari rai, hudi we roo, tapulara juu tui, juu ae roo. ");
INSERT INTO hvn_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Helaꞌu mi lamuhi woajꞌu do rihi wo naiki. ");
INSERT INTO hvn_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Kiri bui la wurai, muri noo nga woie, jadꞌèi ajꞌu ae. Ae dolila do dèka, la pehuri èni pa roꞌa rame. Era lema do tao nyèbꞌu pa ène.” ");
INSERT INTO hvn_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Mi nahère ke ne rujꞌara do ajꞌa ri Yesus pa dèu he, pedèuu nga lai tada roo. ");
INSERT INTO hvn_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ne tima Noo, ajꞌa dèu nga pake lii pehèku. Tapulara pa ana ajꞌa Noo, do pika mola ne pejꞌara harièle lii pehèku. ");
INSERT INTO hvn_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Jèna lodꞌo he, Yesus pa dꞌara kowa ne ko. Ta lii ke Noo pa ana ajꞌa Noo, “Mai we dii ma pekèdꞌèila hebꞌèka rai.” ");
INSERT INTO hvn_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ta haꞌe ke roo la ra kowa nee, helaꞌu nga Yesus. Jꞌe pekèdꞌèiroo, hani ne dèu do lowe he pa lahalae. Era lema do haꞌe kowa do wala. ");
INSERT INTO hvn_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","38","Awe na ène, ta èba ke Yesus nèlu, jꞌe bèjꞌi bilu pa wui kowa nee. Tui dedꞌo ne pekèdꞌèi dèka ne raga-opo. Wèbe ne kowa roo ri nawa, lale ri èi dae ta tobo. Hèku made ri medaꞌu, ne ana ajꞌa Noo he. Ta la peree ke Yesus ri roo, jꞌe lii, mihe ane, “Ama, ee! Made ke dii! Kèdꞌèiwe! Hengee dꞌo ke jꞌii ri Ama ki made jꞌii.” ");
INSERT INTO hvn_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ta kèdꞌèike Noo, jꞌe jꞌege ne raga-opo, “Pehèngo èni!” Ta pereda rike ri Noo pa èi lobo nee, “Ketèna we!” Ta milu dꞌènge ke ne ngèlu. Ketèna ne èi lobo nee. ");
INSERT INTO hvn_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ta bꞌani ke Yesus nga ana ajꞌa Noo he, “Ta ngaa muu harièle ku rihi medaꞌu? Parahajꞌa dꞌo muu nga Yaa?” ");
INSERT INTO hvn_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Harièle roo ta hengodo ke, jꞌe medaꞌu, pedai roo, “Nadèu ke Noo na dꞌee? Hèku ne ngèlu nga nawa pedꞌèno nga lii pereda Noo!” ");
INSERT INTO hvn_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ta dꞌai ke Yesus nga ana ajꞌa Noo la hebꞌèka èi lobo Galilea, la he èhi era, ne ngara noo Gerasa. ");
INSERT INTO hvn_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","6","Pa ène, era he dèu momone do maho ri wango tade wujꞌu. Ne era pee noo pa rai dare-rai dare. Mèdꞌa-nilodꞌo noo pekemale èni nga dꞌo bꞌule bꞌara pa ihi, pa kolo-kolo bꞌojo pa ène, jꞌe pekaa-pekèra. Lema dede-wuhe ne ngiꞌu noo miha ri wowadèutade noꞌe. Dꞌai tèra noo ne rui, hèku bꞌule dꞌo he dèu he do nara ta èke noo, maji lema ri rate bꞌèhi. Jꞌajꞌi wari ke ne ujꞌe ne kae-ngaꞌa nga kae-jꞌèla noo. Tapulara pehèpo ne rate ri noo, lema pepade ri noo ne tuki bꞌèhi do pa bꞌebꞌo noo. Mi nahère Yesus he ne puru ngati dꞌara kowa, ta ngèdi ke roo ngati jꞌèu rowi do wujꞌu na ène. Ta mèhu èni ke noo ti rai dare-rai dare nee, jꞌe perai la lèku rutuu pa hedꞌapa Yesus. ");
INSERT INTO hvn_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Mi nahère Yesus ne pehapo tangamada nga dèu na ène, ta lii ke Noo, “Wango apa! Mèhu èni ti dꞌara dèu na dꞌee!” Ta pekaa ke ne dèu ne pemèdèumèdèu “Ne dèka Èu na dꞌee, ta ma tao ngaa ke pa yaa? Tade ma Èu ri yaa, ta Èu ke Yesus, Ana Deo do wiki higa nga kuaha. Ne huba yaa, bꞌole ma wole yaa ri Èu!” ");
INSERT INTO hvn_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ta kebꞌali ke Yesus pa noo, “Nadèu ne ngara èu?” Ta bꞌale ke ri noo, “Ngara yaa Legion, rowi jꞌii na he do rihi ae, mi tèbꞌa dèu horodꞌadꞌu he!” ");
INSERT INTO hvn_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ta pedide ke noo ri wango do pa dꞌara noo he, mijꞌe ta ami pa Yesus ta bꞌole hudꞌèiroo ngati era na ène! ");
INSERT INTO hvn_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Jꞌèu dꞌo ti ène, era ke ne dèu do nga bꞌata wawi do rihi ae. Era ma dꞌue tèbꞌa ngiꞌu he. Ne wawi na hère pa dꞌara nga kale ngaꞌa pa keraha lede. ");
INSERT INTO hvn_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ta ami ke ne wango he pa Yesus, “Pejuu we jꞌii ta maho la dꞌara wawi na hii.” ");
INSERT INTO hvn_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ta rèngi ne lii ami roo, ta wae ke Yesus. Moko ne wango he ta mèhu èni ti dèu na ène, jꞌe maho la dꞌara wawi do na hère. Ta wujꞌu ke ne wawi he jꞌe perai pebꞌigo-gale ti keraha lede nee, jꞌe maho la dꞌara èi lobo, moko ta made bolo èi harièle. ");
INSERT INTO hvn_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ta ngède ne lai na ène, dꞌai medaꞌu ke hari-hari ne dèu do bꞌata wawi he. Ta perai ke roo la pepika pa dꞌara rae dꞌara kowa pa ène, jꞌara lai do èla pejadꞌèi do lake ri roo. Ta dèka ke ne dèu do lowe he la heleo nengaa ne do èla pejadꞌèi ");
INSERT INTO hvn_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ta kako ke roo la pehapo nga Yesus, era ke ne do wujꞌu ne do mejèdꞌèipa ène. Do nga bꞌara pa ihi ke, jꞌe do mèu dꞌara ke noo. Ta ngède mi nahère, muri ne lua medaꞌu roo harièle, ri toi ke ri roo nadèu ne do nara ta hudꞌèiwango ti dèu do wujꞌu nee, tèra-tèra ne mone ae kuaha Noo. ");
INSERT INTO hvn_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ta pedꞌèii ke roo he dèu nga he dèu nengaa ne do èla pe ngèdi ri namada roo miha, jꞌara lua dèu do èla peꞌie ngati wujꞌu nee, nga jꞌara lua wawi do made bolo èi he. ");
INSERT INTO hvn_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ta dèka ke ne dèu-dèu ti rae-rae pa ène la ami pa Yesus ta pekèdꞌe ti rai roo. ");
INSERT INTO hvn_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ta dꞌai Yesus ne haꞌe la dꞌara kowa, moko ne dèu do ie ngati wujꞌu nee, ta ami pa Yesus mijꞌe ta pedèuu roo lema. ");
INSERT INTO hvn_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Tapulara wae dꞌo Yesus. Jꞌe lii Noo, mihe ane, “Bꞌale we èu la pedꞌèii pa aꞌa-ari èu harièle, nengaa ne do èla petao ri Deo tuu èu. Lema mi namii ne mone ae ruba Deo pa èu.” ");
INSERT INTO hvn_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ta bꞌale ke noo, jꞌe la pedai-pepika la rai henguru bꞌue kota, do tima lema ta pale ‘Dekapolis’. Pa rai na hère, ta pepika ke ri noo mi namii ne ruba Deo do tao ri Yesus pa ngiꞌu noo. Ta madalae ke harièle dèu do rènge lai na ène. ");
INSERT INTO hvn_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ta haꞌe kowa rike Yesus nga ana ajꞌa Noo, jꞌe bꞌale la hebꞌèka èi lobo nee. Ta dꞌai roo ta puru ti dꞌara kowa nee, ta dèka ke ne dèu lowe he la pewore Noo. ");
INSERT INTO hvn_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Pa ène, era he dèu ne ngara noo Yairu. Noo, he dèu kètu èmu hebꞌajꞌa pa rae na ène. Ta dꞌai ta ngède ri noo Yesus, ta kako ke noo la lèku rutuu pa hedꞌapa Yesus, ");
INSERT INTO hvn_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","nga lii huba, mihe ane, “Ruba ko we ne dꞌara Muri Mone, rowi ne ana yaa do mobèni do pemuri henguru dꞌue bꞌue tèu, nèi do pèdꞌa ta mate ne hengaa neke. Tulu ko we Ama ta la peꞌie noo.” ");
INSERT INTO hvn_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ta kako ke Yesus penau nga Yairu la èmu noo. Ta dꞌai roo ne pekèdꞌèi ae tèra ne dèu do pedèue Noo, hèku pebꞌèra-pewingi roo nga Noo ti hebꞌèka-hebꞌèka. ");
INSERT INTO hvn_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ti telora dèu do ae do na hère, era he dèu mobèni do dꞌo pengaha nara do raꞌi helama henguru dꞌue bꞌue tèu. ");
INSERT INTO hvn_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Èla èle ke ne bꞌara nga doi noo, ne pake ta maꞌi pa dote-dote do la peꞌie noo. Tapulara bꞌule dꞌo do nara ta peꞌie noo. Laꞌa ta juu mejèni we ne pèdꞌa noo. ");
INSERT INTO hvn_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","29","Ne mobèni na ène, ae ke ne rèngi jꞌara lua Yesus. Ta perubꞌi ke noo nga dèu do lowe he mijꞌe ta tade dꞌae Yesus ti kejꞌunga. Ane pa dꞌara pengee mobèni na ène, mihe ane, “Hadꞌèita dꞌae we ri yaa ta bꞌuje ne bꞌara pa ihi Noo, ta ie ma ne pèdꞌa yaa.” Mi nahère ri noo ne dꞌae ta bꞌuje ne bꞌara pa ihi Yesus, pengaha dꞌènge noo ne nara do raꞌi. Ta toi dꞌènge ke ri noo ta do ie ke. ");
INSERT INTO hvn_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Pa dꞌara awe do na ène lema, toi ri Yesus ta do era kuaha do mèhu èni ti dꞌara ngiꞌu Noo. Ta bꞌari èni ke Noo la kejꞌunga, jꞌe kebꞌali pa dèu lowe he, mihe ane, “Nadèu muu do bꞌuje ne bꞌara pa ihi Yaa?” ");
INSERT INTO hvn_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ta lii ke ne ana ajꞌa Noo, mihe ane, “Heleo we ri Ama miha. Mi nahee ma ke ne ae dèu do pewingi. Ta kebꞌali ri ko Ama ta, ‘Nadèu do bꞌuje ne bꞌara Yaa?’ ” ");
INSERT INTO hvn_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Tapulara pee ma Yesus nga heleo peheru ta kale toi ta nadèu ne do èla pebꞌuje ne bꞌara Noo. ");
INSERT INTO hvn_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ta rènge ne lii Yesus mi nahère, kerijꞌi-kerègu ne mobèni na ène ri medaꞌu. Moko ke noo ta la lèku rutuu pa hedꞌapa Yesus, jꞌe kelolo nengaa ne do tao ri noo, mihe ane, “Ama! Yaa ne do bꞌuje bꞌara Ama ngine.” ");
INSERT INTO hvn_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ta lii ke Yesus pa mobèni do na ène, “Pelai ti parahajꞌa tèra ina pa Yaa, hèku ie ke ne pèdꞌa èu. Bꞌale we èu nga tunge-mengèlu dꞌara.” ");
INSERT INTO hvn_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Pa dꞌara nga pedai lii ko Yesus, ta dèka ke ne dèu pejuu ti èmu Yairu la pika pa Yairu, mihe ane, “Èla ke ne ana èu pehèpo hengaa. Bꞌole pehedèu Ama Guru. Tenge dꞌoke Dokepai ne ta kako la nii.” ");
INSERT INTO hvn_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Pedꞌèno dꞌo Yesus nga lii pedai dèu do na ène. Ta lii ke Noo pa Yairu, “Bꞌole hedèu ne pengee èu! Parahajꞌa we èu pa Deo.” ");
INSERT INTO hvn_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ta peꞌuru èni ke Yesus ti ana ajꞌa Noo do wala he. Tituwata Petu, Jꞌako nga ari noo Johani we, ne do èba pedèue Noo. ");
INSERT INTO hvn_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ta dꞌai roo la èmu Yairu, era ke ne dèu he do wiho-waho, era lema do tangi peloro èni do mèdèu ");
INSERT INTO hvn_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ta maho ke Yesus la dꞌara nee, jꞌe la lii, mihe ane, “Ta ngaa ke muu ne pewiho-waho, nga tangi peloro èni mi hee? Naiki na èneadꞌo do made. Ne ta bèjꞌi hewe noo.” ");
INSERT INTO hvn_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ta rènge ne lii pedai Yesus mi nahère, ta mare ta dꞌole ke ri roo harièle. Ta pereda ke Yesus pa roo hari-hari ta mèhu èni la tele. Ta pedoa ke ri Yesus ne ina-ama naiki ne nga do tèlu ana ajꞌa Noo, jꞌe maho roo la kama naiki do made nee. ");
INSERT INTO hvn_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ta pèro ke ri Yesus ne wolaèba naiki nee, jꞌe pedai Noo pa dꞌara lii rai Aram do pake pa ène, mihe ane, “Talita kum!” Ki pa dꞌara lii rai di, “Ana mobèni! Kèdꞌèiwe!” ");
INSERT INTO hvn_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","43","Ta kèdꞌèidꞌènge ke, ne naiki nee, jꞌe kako. Ta lii ke Yesus pa ina naiki nee, “Wie ko noo ngaꞌa!” Harièle dèu do ngède ne lai do èla pe jadꞌèi na ène, ta madalae ke roo. Tapulara, ta lara made ke ri Yesus pa roo, mihe ane, “Bꞌole la pedai jꞌe muu nga nadèu-nadèu ta do èla ke ri Yaa pe pemure wari noo!” ");
INSERT INTO hvn_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ta bꞌale ke Yesus nga ana ajꞌa Noo la rae Noo, Nasare. ");
INSERT INTO hvn_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Huru-hapo lodꞌo na ène lodꞌo hebꞌajꞌa do Jahudi. Ta maho ke Yesus la èmu hebꞌajꞌa, jꞌe wie ne lii ajꞌa pa ène. Ae ne dèu do dèka la hebꞌajꞌa pa lodꞌo na ène. Madalae harièle dèu do dꞌèno ne lii ajꞌa Noo. Pedai roo he dèu nga he dèu, mihe ane, “Mèu dꞌara ti mii ke ne nara Dèu na dꞌee? Lua pejꞌara ti mii ne nara Noo? Mi namii Noo ne nara ta tao madalae? ");
INSERT INTO hvn_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Tuka ajꞌu we Noo. Do tade ri dii, ina Noo, Maria; ne ari Noo he, Jꞌako, Jose, Juda nga Himo. Lema ne nawèni Noo. Harièle roo do rae dii!” Ri do mi nahère, wae dꞌo roo ta hème Noo. ");
INSERT INTO hvn_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ta pedai lii ke Yesus, “Do petuu ke! Bꞌale dii dèu, rihi pekebꞌue dèu pejuu Deo ti rai do wala, tapulara dèu pejuu Deo do pa dꞌara rae miha, pekebꞌue dꞌo.” ");
INSERT INTO hvn_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","6a","Tapulara dꞌai tèra ne adèuade dèu pa nii, hèku wae dꞌo roo ta parahajꞌa pa Yesus. Ri mi nahère ke madalae Yesus ne adèuade roo, ku pedꞌelo dꞌo ri Yesus ne kuaha Noo pa nii, wala ti peꞌie do pèri dèu do pèdꞌa. ");
INSERT INTO hvn_vpl VALUES ("MK6_6b","071_6_6b","MRK","6","6b","6b","Ta pekèdꞌe ke Yesus la rae-rae do umu pa ène, la ajꞌa ne dèu he jꞌara lua do dꞌèi Deo. ");
INSERT INTO hvn_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ta pedoa ke ri Noo do henguru do dꞌue ana ajꞌa Noo, jꞌe pejuu do dꞌue-do dꞌue ta la pepeke ne Lii Hagꞌa Dꞌara ngati Deo. Wie lema ri Noo pa roo ne kuaha ta hudꞌèiwango. ");
INSERT INTO hvn_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","Ta pereda ke ri Noo pa roo, “Bꞌole teo ta ègu pe ae nengaa tuu lai kako muu. Tenge dꞌo ta ègu ngaꞌa-nginu, doi, nga taa. Èba we muu kèji, pake helapa, nga bꞌajꞌu pa ihi, jꞌe kako. ");
INSERT INTO hvn_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Kiri era dèu do hèmi muu pa èmu roo, pee we muu pa ène tade ta pekèdꞌèiwari muu. ");
INSERT INTO hvn_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Tapulara, kiri dꞌai muu la hewue rae, jꞌe dodꞌo wae ne dèu he ta hèmi muu, lema wae dꞌo ta pedꞌèno nga muu, kèdꞌèiti ène. Jꞌe lii pa roo, ‘Pelai ta dodꞌo wae muu ta pedꞌèno, hape miha ri muu ne lai apa ne!’ ” ");
INSERT INTO hvn_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ta kako ke roo la pepeke ne Lii Haꞌga Dꞌara ti Deo. La pika ri roo pa dèu he lii ta hani ne muri mada do dꞌo mèdꞌèipa Deo, jꞌe muri mada pa rujꞌara do dꞌèi Deo. ");
INSERT INTO hvn_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Hudꞌèilema ri roo ne wango he. Jꞌe pehuti ri èi mènyi pa dèu do pèdꞌa he, jꞌe hebꞌajꞌa roo mijꞌe ta ie. Ta ie ke ne pèdꞌa roo. ");
INSERT INTO hvn_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Pa dꞌara awe do na ène, rèngi ke harièle dèu jꞌara lua Yesus. Rèngi lema ke dèue Herode, jꞌara lua kuaha Yesus. Era dèu do lii, “Ta kuaha hengaa Johani mone peherani dèu, do muri wari pa dꞌara Yesus. Pelai ri mi nahère ke Noo, ne nara ta tao harièle lua madalae.” ");
INSERT INTO hvn_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Tapulara era lema dèu hadꞌe do lii, “Adꞌo! Elia ke noo! Ki adꞌo, hala he dèu mone ubꞌa ngati Deo rai uru he.” ");
INSERT INTO hvn_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ta rènge ri dèue Herode ne pedai roo jꞌara lua Yesus mi nahère, moko ta lii ke noo, mihe ane, “Ne toi ri yaa, Johani mone peherani dèu, do hewari nee, èle ke ri yaa pepereda ta ète ne kètu noo. Jꞌe nee ke noo, do muri wari!” ");
INSERT INTO hvn_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Ta ngaa dèue Herode ne lii mi nahère, rowi pa awe do ludèu do èla pe jadꞌèi lai mone ae nga Johani. Mi nahee ne lii pedꞌèii ne: Moko ke dèue Herode ta peloje ihi-èmu ari noo, Pelipu, ne ngara noo Herodia. Tapulara pa awe na ène, adꞌo dae Herodia do pehègꞌi nga Pelipu. Taga rowi lai na ène ke, ne pekebꞌède loro-loro Herode ri Johani, mihe ane, “Ama dèue, bꞌole peloje ihi-èmu ari èu nee. Rowi ne wue ai èu na dꞌee adꞌo do pelèka nga hadꞌa rai dii do Jahudi!” Tapulara pedꞌèno dꞌo Herode, hèku banga èmu noo nga Herodia. Pelai ti mi nahère ke, ku pejuu noo dèu la kèpe Johani, jꞌe pemaho la èmu bꞌèdo. ");
INSERT INTO hvn_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Pelai ti pekebꞌède loro-loro ri Johani, ta tèka nui ke Herodia, jꞌe kale rujꞌara ta pemade Johani. Tapulara jadꞌèi dedꞌo, ri Johani do pa dꞌara èmu bꞌèdo ko. ");
INSERT INTO hvn_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Pereda lema ri Herode pa horodꞌadꞌu he ta jage Johani pe woie. Herode lema do dꞌai megꞌigꞌi ri Johani. Do toi ri noo ta Johani nee, dèu pejuu Deo. Lema he dèu do woie ade nga pengee. Mengèlu dꞌara lema noo ne dꞌèno lii pedai Johani, maji lema ne lii pedai Johani ta pereja ne pengee noo. ");
INSERT INTO hvn_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Pedèka, pa dꞌara he lodꞌo, ta nara ke Herodia ne awe kehoo do rihi woie, ta petobe ne lua pana ade noo pa Johani. Pa lodꞌo na ène, awe hari jadꞌèi dèue Herode. Ta pedoa ke ne dèu-dèu do mone ae pa propensi Galilea, ie ngati do pereda, kètu-kètu horodꞌadꞌu, nga kètu-kètu rai. ");
INSERT INTO hvn_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Pa dꞌara rame mengèlu dꞌara do na ène, ta maho ke ne ana do mobèni ri Herodia la ledo. Dꞌai woie tèra ne ledo noo, hèku tobo ri mengèlu dꞌara Herode nga harièle dèu do pedoa ri noo. Ta èla pe ledo, ta pedoe ke ne ana mobèni ne ri dèue Herode, jꞌe lii noo, “Pika we èu pa yaa, ami nengaa èu. Ta wie ma ri yaa! ");
INSERT INTO hvn_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ta ame hebꞌèka rai pereda yaa, ta wie ma. Hupa yaa nga ngara Deo!” ");
INSERT INTO hvn_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ta kako ke ne ana mobèni ne la kebꞌali pa ina noo, mihe ane, “Wo mama! Ami nengaa ke dii pa papa, ne do rihi woie?” Ane mama noo, “Naaa! Ame ne kètu Johani, bꞌoke ina tana ee!” ");
INSERT INTO hvn_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ta la pedai ke ne ana mobèni ne nga Herode, mihe ane, “Papa, ee! Ame kètu Johani ri yaa mèdꞌa dꞌee. Pèlo pa dꞌara dꞌula.” ");
INSERT INTO hvn_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ta rènge ne lii ami na ène, lila nèdꞌa Herode. Tapulara iꞌa dꞌo ke noo, ta nyèke ne lii ami na ène, rowi èla ke noo pe hupa pa hedꞌapa dokepai do pedoa ri noo he. ");
INSERT INTO hvn_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ta pereda ke Herode pa kètu horodꞌadꞌu ta la ète ne kètu Johani pa dꞌara èmu bꞌèdo. ");
INSERT INTO hvn_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ta la ète ke ri roo ne kètu Johani, jꞌe ihe pa dꞌara dꞌula, jꞌe la wie pa ana mobèni nee. Hème rowi noo, jꞌe dꞌede la wie pa ina noo. ");
INSERT INTO hvn_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ta rèngi ne ana ajꞌa Johani ta do èla ke peꞌète ne kètu noo, ta kako ke roo la ègo ne ngiꞌu noo jꞌe la pedane. Mi nahère ke ne lii pedꞌèii jꞌara lua made Johani. ");
INSERT INTO hvn_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Pa dꞌara he lodꞌo, ta bꞌale ke ne ana ajꞌa do pejuu ri Yesus he, la peteni wari helaꞌu nga Noo. Ta pedꞌèii ke ri roo hari-hari ne do èla pe tao, nga do ajꞌa ri roo. ");
INSERT INTO hvn_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Tapulara pa awe do na ène, ae tèra ne dèu do pe holi-hoo la kale Yesus, hèku bꞌule dꞌoke roo nga awe kehoo ta pengaha ta ngaꞌa. Ta lii ke Yesus pa ana ajꞌa he, mihe ane, “Mai we dii la kale era do kehii mijꞌe nara ko dii ta pengaha ihi hudi he.” ");
INSERT INTO hvn_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ta pekèdꞌèike roo jꞌara kowa la kale era do kehii, do jꞌèu ngati dꞌara rae. ");
INSERT INTO hvn_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Tapulara do ngèdi ri dèu lowe he ne kowa do haꞌe Yesus he, do ore ne ngidi èi lobo nee. Ta mèhu èni ke roo ti dꞌara rae, jꞌe kako peꞌuru èni la era do ta penawu kowa Yesus he. ");
INSERT INTO hvn_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Mi nahère Yesus ne puru ngati dꞌara kowa, ta ngèdi ke ri Noo ne dèu lowe he do mate Noo. Ta ruba ke ne dꞌara Noo nga roo, rowi ne dèu lowe he era mi kiꞌi-jꞌawa do dꞌo bꞌule nga mone bꞌata he ke, hèku toi dꞌo ke nengaa ne do madae ta tao ri roo. Moko ke Yesus ta ajꞌa roo jꞌara lua do dꞌèi Deo, ");
INSERT INTO hvn_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","36","rai ti nètu lodꞌo hape la mèdꞌa lodꞌo. Ta lii ke ne ana ajꞌa he pa Noo, mihe ane, “Ama! Umu ke ta jèna ne lodꞌo. Ne era na dꞌee do kehii, lema do jꞌèu ngati rae-kowa. Bꞌule dꞌo ngaꞌa-nginu pa dꞌee. Pejuu kowe ne dèu lowe he la wèli ngaꞌa pa rae-kowa do umu pa dꞌee.” ");
INSERT INTO hvn_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ane Yesus pa roo, “Bꞌole teo ta pejuu ne dèu he! Ta pengaꞌa ri muu we ne dèu he!” Ta kebꞌali ri ke roo, mihe ane, “Ama ee! Kiri pengaꞌa ri jꞌii ne dèu do mi nahee ne worèwu ae, dꞌai ae doi ne do ta pake ri jꞌii! Helaꞌu nga gaji tuka natuu he wue tèu! Mi namii ke jꞌii ne nara doi do mi nahère ne ae!” ");
INSERT INTO hvn_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ta lii rike Yesus pa roo, “La kale toi ko ri muu, nadèu do nga èba ngaꞌa.” Ta èla ri roo pe kale toi, ta bꞌale ke roo la pika pa Yesus, mihe ane, “Era lèmi bꞌue roti, nga dꞌue ngiꞌu nadèuu we.” ");
INSERT INTO hvn_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ta lii ke Yesus pa dèu he harièle ta mejèdꞌèipa kolo jꞌuꞌu he, hekewolo-hekewolo. ");
INSERT INTO hvn_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Moko roo ta mejèdꞌèipedèue ne lii Yesus. Pa dꞌara he kewolo, era do hengahu, era lema do lèmi nguru dèu. ");
INSERT INTO hvn_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ta èba ke ri Yesus ne roti do lèmi bꞌue, nga nadèuu dꞌue ngiꞌu he. Jꞌe tengara Noo la liru ta pehaꞌe lii ie ae pa Deo. Èla pe mi nahère ta pipe ke ri Noo ne roti he, jꞌe wie pa ana ajꞌa he ta pebꞌagi pa dèu he hari-hari. Mi nahère lema ne nadèuu he. ");
INSERT INTO hvn_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ta ngaꞌa ke roo harièle tade bꞌèhu. ");
INSERT INTO hvn_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Dꞌai roo ne èla pe ngaꞌa, ta pekupu ke ri ana ajꞌa he ne ngaꞌa do rihi he. Tobo henguru dꞌue hope ne ae. ");
INSERT INTO hvn_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ne dèu do ngaꞌa he, ne peꞌira era ma do lèmi tèbꞌa dèu momone; reke dꞌo mobèni nga naiki. ");
INSERT INTO hvn_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ta moko harièle ne lai na hère, ta pejuu ke ri Yesus ne ana ajꞌa Noo la haꞌe kowa, mijꞌe ta uru la hebꞌèka èi lobo, la rae Betsaida. Pe leto èni ko Yesus mijꞌe ta pejuu ne dèu do lowe he ta bꞌale. ");
INSERT INTO hvn_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ta bꞌale harièle dèu, ta haꞌe ke Noo la hewue lede jꞌe la hebꞌajꞌa pa ène. ");
INSERT INTO hvn_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","50","Dꞌai ta mèdꞌa, ta puru ke Yesus. Ngèdi ri Noo ne kowa ana ajꞌa he, do dꞌai ke la telora èi lobo nee. Era ke roo nga tuku hetenga made ne kowa nee, rowi awe na ène do rihi mèdèungèlu dꞌuru. Umu ta mèu rai, ta kako ke Yesus nèru pa kolo èi, la dèuu ne ana ajꞌa he. Ta dꞌai Noo ne umu ta hihu ne kowa roo, moko ta ngède ke Noo ri roo. Gꞌigꞌa tèra roo. Ta pekebꞌali ke roo he dèu nga he dèu, mihe ane, “Heleo ko ri muu! Nengaa ke na nii? Wango ke na nii, we nengaa?” Tapulara ta lii dꞌènge ke Yesus, “Bꞌole medaꞌu muu! Yaa ma na dꞌe rii!” ");
INSERT INTO hvn_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ta dꞌai Yesus ne haꞌe la dꞌara kowa nee, milu dꞌènge ne ngèlu. Madalae tèra ne ana ajꞌa he harièle. ");
INSERT INTO hvn_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Maji lema ri roo ta èla pengède ne kuaha Yesus ne pengaꞌa do rihi ngati lèmi tèbꞌa dèu, tapulara tade dedꞌo ri roo nga petuu ne kuaha Noo, pelai ta do adèuade-pengee roo. ");
INSERT INTO hvn_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ta dꞌai roo la hebꞌèka èi lobo, ta penawu ke ne kowa roo pa ngidi èi lobo pa rae Genesare. ");
INSERT INTO hvn_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Mi nahère roo ne puru ti dꞌara kowa, ae ne dèu pa ène do ngèdi roo. Ta petoda ke roo, “Nee ke Yesus, ó!” ");
INSERT INTO hvn_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","56","Ta perai ke roo la pepika pa hari hewue rai na ène. Ta dèka ke ne dèu lowe he, nga merèi ne dèu-dèu do pèdꞌa he. Hadꞌèita rèngi we ri roo ta Yesus do era pa he èhi era, ta ègu ke ri roo ne dèu do pèdꞌa he jꞌe la pebèjꞌi pa kebꞌèla. Ane pa dꞌara lai pengee roo, “Hadꞌèita dꞌai we ta bꞌuje ne bꞌara pa ihi Noo ri do pèdꞌa he, do ta ie ma roo.” Harièle dèu do nara ta bꞌuje ne bꞌara pa ihi Noo, ie dꞌènge ne pèdꞌa roo. ");
INSERT INTO hvn_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Era he kejie do Parisi nga do pèri dèu guru agama ngati Yerusalem, dèka la pehapo nga Yesus. ");
INSERT INTO hvn_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","5","Ne do Parisi he do dꞌai tèra roo ne henèru ta pekako hadꞌa rai Jahudi do petèka ri ama-èpu roo. Unupala, uru nga do dꞌo ngaꞌa, jꞌamu uru èi pedèuu nga hadꞌa rai. Mi nahère lema ki bꞌale ti paha, do jꞌèma ta jꞌiu èi. Rihi ti na ène, ne bꞌara-bꞌara do pa dꞌara èmu leo hogo ngaꞌa roo, mi èru hogo, pai-kabꞌa, kabꞌa nginu, lonye uru ko hari-hari pedèuu nga hadꞌa rai, jꞌeꞌitu pake. Ki era do Jahudi do wala he, do dꞌo pedèuu ne hadꞌa rai na ène, bubu dꞌara ne do Parisi he. Pelai ti mi nahère ke roo ne bubu dꞌara, ta dꞌai ne ngèdi ne ana ajꞌa Yesus he do ngaꞌa uru nga do dꞌo jꞌamu èi pedèuu nga hadꞌa rai. Ta dèka ke roo la pehale Yesus, mihe ane, “Ta ngaa ne ana ajꞌa Èu ku ngaꞌa uru nga dꞌo jꞌamu èi? Lai na ène, do jꞌèle ne hadꞌa rai, do petèke ri ama-èpu dii!” ");
INSERT INTO hvn_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","7","Tapulara bꞌale ri Yesus, mihe ane, “Muu he, dèu do peworèwu èni ta dèu do mèu! Petuu nengaa ne do bꞌuke ri Yesaya rai uru, jꞌara lua muu, mihe ane, ‘Ne dèu nahee do pekelode Yaa, ri ubꞌa we, adꞌo do rai ngati dꞌara ade. Parahuma we roo ne tao mi nahère. Wae dꞌo roo ta pekebꞌue ne do dꞌèi Yaa, tituwata rihi pekebꞌue lua petèka dèu rai-wawa we.’ Mi nahère lema ke muu. ");
INSERT INTO hvn_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","9","Jꞌèle ri muu ne lii pereda Deo mijꞌe ta nara ri muu ta pekako ne lua petèka dèu rai-wawa we. Dꞌai tèra muu ne iꞌa peheru èni! ");
INSERT INTO hvn_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Rai uru he do èla ke pepeke ri Musa ne lii pedai Deo, mihe ane, ‘Pekebꞌue ina-ama muu.’ Nga lii pereda do wala wari, ‘Nadèu do wègi-menihi ina ki adꞌo ama noo, wole noo pemade.’ ");
INSERT INTO hvn_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Mi nahère ke ne lii pereda Deo, tapulara ajꞌa muu do wala. Ajꞌa muu dèu, mihe ane, ‘Kiri era dèu do jaji ta jꞌola he èhi bꞌara natuu Deo, ie dꞌoke ta wie pa ina-ama noo, maji lema roo ta do pa dꞌara hedèu-herui. Ne bꞌara na ène nara dꞌo ta pake ta rabꞌa roo, rowi do èla ke pejaje mijꞌe ta jꞌole pa Deo.’ ");
INSERT INTO hvn_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Rowi mi nahère ke ne lii Yaa pa muu ngine, èla ke ri muu pe jꞌèle ne lii pereda Deo, jꞌe pehure ri muu ri lua petèka do wiu. Ae ko ne lua petèka muu do tebèli ti lua do dꞌèi Deo.” ");
INSERT INTO hvn_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ta pedoa ke ri Yesus ne dèu lowe pa ène, jꞌe lii, “Dꞌèno we pe woie, mijꞌe tada muu. ");
INSERT INTO hvn_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Nengaa we ne do maho la dꞌèlu dèu, bꞌule dꞌo do peraꞌi dèu. Tapulara nengaa do dèka ti dꞌara dèu, na ène ne do nara ta peꞌapa dèu. ");
INSERT INTO hvn_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Nadèu do nga dꞌèi ta dꞌèno, tenae pe woie, mijꞌe tada muu!” ");
INSERT INTO hvn_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ta pebꞌagi ke Yesus nga ana ajꞌa Noo nga dèu do lowe he jꞌe maho la dꞌara hewue èmu. Ta kebꞌali ke ne ana ajꞌa Noo mi namii ne pedèbꞌo lii pehèku do èla pe pedai nga dèu do lowe he. ");
INSERT INTO hvn_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Ta bꞌale ke ri Yesus, mihe ane, “Pee ko ma muu nga dꞌo tada? Mi nahee ne lua pedèbꞌo ne: nengaa ne do ngaꞌa ri dèu, do ie. Tapulara, nengaa ne do mèhu èni ti dèu nee, adꞌo do woie. Nengaa we ne do ngaꞌa ri dèu, maho la dꞌèlu, jꞌe mèhu èni wari. (Ne pedèbꞌo lii Yesus, ie ma dèu ta ngaꞌa nengaa we. Bꞌule dꞌo do petaru.) ");
INSERT INTO hvn_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Tapulara, nengaa ne do mèhu èni ngati dꞌara ade dèu, na ène ke ne do peꞌapa dèu, hèku Deo wae dꞌo ta peꞌumu èni nga roo. ");
INSERT INTO hvn_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","Rowi ae lai do apa do kepue ti dꞌara ade dèu. Mii: lai pengee do apa, kenyoo nga dèu do adꞌo ihi-èmu noo, menaꞌo, pemade dèu, mengaꞌa, tao apa, pote-èpi, lala-hopa, mèta dꞌara, wègi-menihi dèu, wue èni, bꞌule dꞌo nga hadꞌa, nga paja kètu. ");
INSERT INTO hvn_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Naa. Harièle lai do apa na hère do kepue pa dꞌara ade dèu, do ma peꞌapa dèu. Lai do apa na hère ke, do bꞌege Deo.” ");
INSERT INTO hvn_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ta pekèdꞌèirike Yesus he la hewue kota ne ngara noo Tirus. Ta dꞌai la ène, maho roo la dꞌara hewue èmu, mijꞌe ta dodꞌo toi ri dèu ta do era ke Noo pa nii. Maji mi nahère, pee ma ta toi ri dèu he ne lua dèka Noo. ");
INSERT INTO hvn_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Pa ène era he dèu mobèni, adꞌo do Jahudi. Ngati rai Penesia ihi propensi Siria. Ta toi ri noo ne lua dèka Yesus, ta kako ke noo la huba pa Yesus, mijꞌe ta la hudꞌe ne wango ti dꞌara ana noo do mobèni. ");
INSERT INTO hvn_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ta wie ke ri Yesus ne lii pepèhi, mihe ane, “Ngaꞌa pebꞌèhu uru ko naiki he, jꞌe wie ne do rihi pa ngaka.” (Ne pedèbꞌo Yesus, ta pemoko uru ri Noo dèu Noo do Jahudi, jꞌe le to dèu do hewala he). ");
INSERT INTO hvn_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ta bꞌale ke ri mobèni na ène, “Petuu ke ne lii pedai Ama! Ngaka lema do era pa daꞌi meja ngaꞌa, ta ngaꞌe ne ngaꞌa do bui ti dꞌèia meja naiki he.” (Ne pedèbꞌo nee, pa dꞌara awe ngaꞌa naiki, era ngaꞌa do bui, jꞌe ngaꞌe ri ngaka. Maji lema Yesus ta pemoko uru dèu Noo do Jahudi, do jꞌèma lema Noo ta heleo dèu do hewala.) ");
INSERT INTO hvn_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ta rènge ri Yesus ne lii mobèni nee, ta lii ke Yesus, “Do petuu ne lii èu ina, ó! Bꞌale we ina la èmu, ie ke ne ana èu, rowi èla ke ne wango ne pemèhu èni ti dꞌara noo.” ");
INSERT INTO hvn_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ta bꞌale ke noo la èmu. Ta dꞌai la èmu, era ke ne ana noo do bèjꞌi bilu, rowi èla ke ne wango ne pemèhu èni. ");
INSERT INTO hvn_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ta pekèdꞌèirike Yesus he ti kota Tirus, jꞌara lahalae lake kota Sidon. Nèru roo teruu la èi lobo Galilea. Ngati ène, kako wari roo teruu la rai henguru bꞌue kota, do tima ta pale, ta, ‘Dekapolis’. ");
INSERT INTO hvn_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Pa nii, era he dèu do bènga riko do hoe. Ta ègo ke noo ri ihianga noo nga Yesus. Jꞌe ame ri roo Yesus ta tèka ruai pa wukolo noo, mijꞌe ta peꞌie noo. ");
INSERT INTO hvn_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ta petala èni ke Yesus nga dèu na ène ti dèu do lowe he. Ta pemaho ne kolo kuꞌu Noo la roꞌa wodilu dèu ne hari dꞌue bꞌue. Pebobꞌe ri ne kehui ai Yesus ri ilu Noo, jꞌe tèke pa weꞌo dèu do na ène. ");
INSERT INTO hvn_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ta tengara ke Yesus la dꞌèia, jꞌe tule hengaa, jꞌe pali Noo, “Epata” (ki pa dꞌara lii rai dii, “Boka èni we!”) ");
INSERT INTO hvn_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Mi nahère we ne lii Yesus, rèngi dꞌènge noo. Ne weꞌo noo do hekoto, lumu dꞌènge, iꞌa dꞌènge pedai lii nga woie. ");
INSERT INTO hvn_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Èla pe mi nahère ta bꞌale ke roo nga dèu lowe he. Ta pereda ke Yesus pa dèu pa ène, “Dꞌèno ie ri muu! Bꞌole pedꞌèii muu pa dèu ta Yaa do peꞌie dèu na dꞌee.” Maji ta lara ri Noo, pee ma ne dèu he ta pedai ne lai na ène pa mii-pa mii. ");
INSERT INTO hvn_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Madalae tèra ne dèu do rèngi ne lai do na ène. Pedai roo, mihe ane, “Dꞌai tèra Dèu na ène! Pejadꞌèi ri Noo harièle lai peꞌie. Do hoe jadꞌèi ita rèngi. Do bꞌènga iꞌa pedai lii.” ");
INSERT INTO hvn_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","3","Hewari, ae ne dèu do peteni la dꞌèno ne lii ajꞌa Yesus. Tèlu lodꞌo ke roo ne pedèue Noo, hèku bꞌule dꞌoke roo nga ngaꞌa-nginu. Ta pedoa ke ri Yesus ne ana ajꞌa Noo, jꞌe lii, “Ruba dꞌara ke Yaa nga dèu do lowe he. Era do dèka ngati rae do jꞌèu, jꞌe tèlu lodꞌo lema ke roo ne pedèu, tade ta èla ke ne ngaꞌa unu roo. Jꞌe ma dꞌoke ta pebꞌale roo nga dꞌèlu wue. Ngee ta melanu pa telora rujꞌara.” ");
INSERT INTO hvn_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ta bꞌale ke ri ana ajꞌa Noo, mihe ane, “Wo Ama. Ne era na ène jꞌèu ti rae-kowa. Hèku nara dꞌo dii ta pengaꞌa dèu do mi nahee ne ae!” ");
INSERT INTO hvn_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ta kebꞌali ke Yesus pa roo, mihe ane, “Henga ne roti do era pa muu?” Ta bꞌale ke ri roo, mihe ane, “He pidèu bꞌue roti we.” ");
INSERT INTO hvn_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ta lii ke Yesus pa dèu lowe he, ta mejèdꞌèipa wurai. Èla pe mi nahère, ta èba ke ri Noo ne roti do pidèu bꞌue he, jꞌe hebꞌajꞌa ta pehaꞌe lii ie ae pa Deo. Ta pipe ke ri Noo ne roti he, jꞌe wie pa ana ajꞌa Noo he. Jꞌe la pebꞌagi pa dèu lowe he. ");
INSERT INTO hvn_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Nara lema roo pèri ngiꞌu nadèu. Hebajꞌa wari Yesus ta ami terima kasi pa Deo tuu nadèu he. Ta lii ke pa ana ajꞌa Noo, ta la pebꞌagi pa dèu lowe he. ");
INSERT INTO hvn_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Era ma roo harièle do èpa tèbꞌa dèu. Ngaꞌa roo tade bꞌèhu. Ta èla roo pe ngaꞌa, ta pekupu ke ri ana ajꞌa Noo, ne do rihi he, tobo pidèu hope worena. Ta lii ke Yesus pa roo ta bꞌale. ");
INSERT INTO hvn_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ta ludèuroo, ta haꞌe ke Yesus nga ana ajꞌa Noo la dꞌara kowa, jꞌe pekèdꞌèila hewue era, ne ngara noo Dalmanuta. ");
INSERT INTO hvn_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Mi nahère Yesus he ne puru pa Dalmanuta, dèka ke do pèri dèu ti kejie Parisi la pehapo nga Noo. Ne dèka roo ta la pekerèi-kebꞌali nga Yesus ta kale lai ta hie Noo. Ta ami roo pa Noo, mihe ane, “Ama! Pedꞌelo ko pa jꞌii ne lai madalae ta he èhi rutada, ta kuaha do era pa Èu, ngati Deo.” ");
INSERT INTO hvn_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ta hèpi hengaa ke Yesus pemèdèu jꞌe lii pa roo, “Menyaha ne ade Yaa ne rèngi lii ami muu. Ta ngaa ke muu ne ami rutada madalae? Bꞌole mi nahère. Era ma pa Yaa ne lua madalae nee, tapulara pengède dꞌo pa muu.” ");
INSERT INTO hvn_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ta hani ke roo ri Yesus, jꞌe haꞌe bꞌale la dꞌara kowa nga ana ajꞌa Noo he. Jꞌe pekèdꞌèiroo la hebꞌèka èi lobo. ");
INSERT INTO hvn_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ta dꞌai Yesus he la telora èi lobo, ta henge ri ana ajꞌa Noo he, taa dꞌo do èba ngaꞌa-nginu. Hewue we ne roti èba roo. ");
INSERT INTO hvn_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ta rèngi roo nga pedai roti, ta lii ke Yesus, “Meniga pe woie muu! Bꞌole luu muu ri lai apa do dèka ti dèue Herode nga do Parisi he. Ne lai apa roo do jꞌala mi ragi do pekiwu pa terigu ta pehaꞌe roti.” ");
INSERT INTO hvn_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ta rènge ne lii pedai Noo mi nahère, bꞌingu ana ajꞌa Noo. Ta pedai ke roo, mihe ane, “Tada dꞌo dii lii pedai Noo ne! Maga-maga dii ta dꞌo èba roti ku pedai Noo mi nahii.” ");
INSERT INTO hvn_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Toi ri Yesus ne lua pengee roo. Ta lii ke Noo, mihe ane, “Ta ngaa muu hèku pedai jꞌara dodꞌo bꞌule nga èba roti? Tada dedꞌo muu ne pedèbꞌo lii Yaa? Dꞌai rèpo ne kewadèukètu muu! ");
INSERT INTO hvn_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ngèdi ke ri namada muu miha, tapulara pee ma muu nga dꞌo tada. Mi do bꞌèdèuhe muu. Rèngi ke ri wodilu muu miha, tapulara pee ma muu nga dꞌo tada nengaa-ngaa. Mi do hoe he muu. Bèlu ke muu ");
INSERT INTO hvn_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","ne roti do lèmi bꞌue do pipe ri Yaa, jꞌe pengaꞌa do lèmi tèbꞌa dèu he? Pekupu ri muu do hewari nee, ne do rihi pèri hope?” Bꞌale ri roo, “Henguru dꞌue hope.” ");
INSERT INTO hvn_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Kebꞌali wari Yesus, “Hewina ko ri muu ne roti do pidèu bꞌue do pipe ri Yaa, jꞌe pengaꞌa do èpa tèbꞌa dèu he? Pekupu ri muu do rihi pèri hope?” Bꞌale ri roo, “Pidèuhope worena, Ama ee.” ");
INSERT INTO hvn_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ane Yesus, “Do petuu! Ngèdi ke ri namada muu miha, tapulara ta ngaa muu ku pee nga dꞌo tada, ta dèka ti mii ne kuaha do pa Yaa?” ");
INSERT INTO hvn_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ta dꞌai rike Yesus nga ana ajꞌa Noo la rae Betsaida. Ta dèka ke ne dèu nga ègo he dèu do bꞌèdèunga Yesus. Ne ami roo pa Yesus, mijꞌe ta peꞌie ne namada dèu na ène. ");
INSERT INTO hvn_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ta peraꞌo ke ri Yesus ne do bꞌèdèune la tele rae. Ta hebue ke ne ilu Noo pa namada dèu na ène, jꞌe bꞌuje ri Noo. Kebꞌali Noo, mihe ane, “Mi namii? Ngèdi ke èu?” ");
INSERT INTO hvn_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ta dꞌede ke ne tangamada noo, jꞌe heleo ke la keriu-kegꞌana, ta bꞌale ke ri noo, “Wa! Ngèdi ke yaa dèu do kako. Tapulara era mi ajꞌu do kako!” ");
INSERT INTO hvn_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ta tèke rike ne wolaèba Yesus pa namada dèu nee. Ta hèku rike noo ta heleo, ngèdi woie ke. ");
INSERT INTO hvn_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ta pejue ke noo ri Yesus ta bꞌale la èmu, jꞌe tèka lii, mihe ane, “Bꞌale we èu lake rujꞌara do wala! Bꞌole lake ri jꞌara Betsaida.” ");
INSERT INTO hvn_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Èla pe na ène, ta nèru ke Yesus nga ana ajꞌa Noo he la rae-kowa pa Kaisarea-Filipi. Pa telora rujꞌara, ta kebꞌali ke Yesus pa roo, mihe ane, “Pedèuu nga lii pedai dèu, nadèu ke Yaa na dꞌee?” ");
INSERT INTO hvn_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ane roo, mihe ane, “Era do lii, ta ‘Johani, mone peherani dèu’. Era do lii ta ‘Elia’, mone ubꞌa Deo do uru he. Era lema do lii, ta hala he dèu ngati mone ubꞌa Deo do wala he pa awe do uru.” ");
INSERT INTO hvn_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ta kebꞌali rike Yesus pa roo, “Pedèuu tade ri muu miha, nadèu ke Yaa na dꞌee?” Ta bꞌale ke ri Petu, mihe ane, “Èu ke Kristus! Do èla pe pejꞌèuꞌe ri Deo rai uru.” ");
INSERT INTO hvn_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ta lara ke ri Yesus, ta “Bꞌole pedai nga nadèu-nadèu!” ");
INSERT INTO hvn_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ta jꞌari ke Yesus ta pika pa ana ajꞌa Noo, mihe ane, “Yaa dꞌee, Dèu Rai-wawa do Petuu-Petuu. Hine do ta lake ri Yaa ae lua hedèu, ri do ta nyèke Yaa ri dokepai rae he, ketèu ngati kètu agama he, nga guru agama he. Do ta pemade Yaa ri roo, tapulara muri wari Yaa nèli.” ");
INSERT INTO hvn_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ta rèngi ne lii pika Yesus, ta la peraꞌo ke Yesus ri Petu la keraha. Jꞌe tèka lii noo, mihe ane, “Bꞌole pedai mi nahère, Ama ee! Wie dꞌo ri yaa ta dꞌai ai roo pa Ama!” ");
INSERT INTO hvn_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Tapulara ne lii pedai Petu adꞌo do helaꞌu nga dꞌèi Deo. Ta bꞌale hedꞌapa ke Yesus nga ana ajꞌa do wala he. Jꞌe jꞌege ri Noo Petu, “Lii pedai kètu wango he na ène! Lènga ti dꞌee! Adꞌo èu do pengee ne lua do dꞌèi Deo, pengee ne lua do dꞌèi dèu rai-wawa we!” ");
INSERT INTO hvn_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ta pedoa ke ri Yesus ne dèu lowe he la peꞌobo nga ana ajꞌa Noo he. Jꞌe ajꞌa roo ri Noo, “Nadèu do dꞌèi ta pedèue Yaa, mèka tee noo ta pedèue helodꞌo-helodꞌo. Hore ne lua do dꞌèi miha, jꞌe pedèue ne lua do dꞌèi Deo we. Maji lema ta era dèu do ta pemade noo, pee ma nga pedèuu teruu, mi dèu do nga hape ajꞌu ketoe ta la pemade. ");
INSERT INTO hvn_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Dèu do dꞌèi ta muri mada tuu ngiꞌu miha, do ta ele ne muri mada noo nga mi nahère we! Tapulara nadèu do moko ta la made taga pedèue Yaa, nga pepeke ne rujꞌara muri mada do dꞌèi Deo, do ta muri loro noo helaꞌu nga Deo. ");
INSERT INTO hvn_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Dꞌèno we! Kiri babꞌo ri èu harièle ihi hewue rai-wawa dꞌee, tapulara nyèke èu ri Deo, ngaa ne nara èu? ");
INSERT INTO hvn_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Maji lema ta èbe ri èu hari ihi hewue rai-wawa na dꞌee, nara dꞌo ta pehure nga muri mada do peloro nga Deo! ");
INSERT INTO hvn_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Henge ie ri muu! Dèu rai-wawa pa dꞌara awe na dꞌee, muri mada pa dꞌara ae keraꞌa apa-kerewe. Pedꞌuli dꞌo ke roo ta pedèue Deo. Hèku nadèu do mekae dꞌara ta pedèue Yaa, ki adꞌo mekae dꞌara ta pèro lii pedai Yaa, mekae dꞌara lema Yaa ta hème noo pa hedꞌapa Deo. Rowi Yaa, Dèu Rai-wawa do Petuu-Petuu na dꞌee, hine do ta dèka wari ti liru-bèla. Nga dèu pejuu Deo he, dèka helaꞌu nga Yaa. Ne puru jꞌii ti liru-bèla nga kuaha Deo do mèu-megala, itu toi Yaa ri dèu, nadèu Yaa na dꞌee. ");
INSERT INTO hvn_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Bꞌole bèlo ri muu ne lii pedai Yaa na dꞌee. Era ti telora muu na hee, dodꞌo made, do ta ngède Deo do pereda nga kuaha Noo do kerihi.” ");
INSERT INTO hvn_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Èna lodꞌo èla pe na ène, ta ègu ke Petu, Jꞌako nga Johani ri Yesus, la hewue lede do dꞌèia, do kehii. Ta dꞌai roo la kolo lede nee, ngède ri roo ne Yesus èla ke pe rihu èni. ");
INSERT INTO hvn_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ne bꞌara pake Noo do pudi kewaꞌa, do weo do kana. Bꞌule dꞌo bꞌara pa rai-wawa na ène do wo pudi kelala mi bꞌara pake Noo. ");
INSERT INTO hvn_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Pa dꞌara awe na ène dꞌènge, ta ngède ke ri roo Yesus era do pedai lii nga Elia nga Musa. ");
INSERT INTO hvn_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Petu he made ri medaꞌu. Bꞌale Petu ta bꞌingu ke, tade pedai wala. Ta lii ke noo pa Yesus, mihe ane, “Ama. Rihi woie dii pa dꞌee! Rihi ie jꞌii ta petitu tèlu bꞌue leo. Hewue tuu Ama, hewue tuu Musa, nga hewue tuu Elia.” ");
INSERT INTO hvn_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ta dèka ke ne merèmu la herimu roo. Jꞌe rènge ri roo ne lii pedai ti dꞌara merèmu nee, mihe ane, “Dꞌèno we. Yesus na dꞌee, Ana dꞌèi Yaa. Pedꞌèno ie we muu nga Noo!” ");
INSERT INTO hvn_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ta rènge ri Petu he ne lii pedai na ène, heleo pehero ke ri roo pa era na ène. Bꞌule dꞌo dèu do hewala pa ène, wala ngati Yesus miha. ");
INSERT INTO hvn_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Èla pa mi nahère, ta puru ke Yesus nga ana ajꞌa Noo he ti kolo lede na ène. Pa dꞌara puru roo, ta tèka lii ke Yesus pa roo, “Bꞌole pedꞌèii muu pa nadèu we, nengaa ne do ngèdi ri muu ngine. Yaa dꞌee, Dèu Rai-wawa do Petuu-Petuu, made uru ko. Kiri muri wari Yaa, jꞌeꞌitu pepeke ri muu pa dèu lowe.” ");
INSERT INTO hvn_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Pedèuu tèra roo nga lii tèka Yesus, bꞌule dꞌo roo nga pedai nga he dèu tèra he. Ta pekebꞌali ke roo tèlu, “Nengaa ke ne pedèbꞌo lii pedai Noo, ta ‘Muri wari ki èla pemade? Mi namii?’ ” ");
INSERT INTO hvn_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ta kebꞌali ke roo pa Yesus, “Ane guru agama he, ‘Elia ta dèka uru, jꞌeꞌitu dèka Kristus.’ Pedèuu lii Ama, mi namii?” ");
INSERT INTO hvn_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ta bꞌale ke ri Yesus, “Tèra, do petuu! Dèka uru ko Elia, ma pemoke rujꞌara tuu Kristus, do pejꞌèuꞌe ri Deo rai uru he. Mi namii? Pee ko ma muu nga dodꞌo tada nengaa ne do hure do bꞌuke jꞌara lua Dèu Rai-wawa do Petuu-Petuu ne? Do lore ke pe bꞌuke ki ri dèka Noo, do ta pehedèu Noo ri dèu, jꞌe pemade. ");
INSERT INTO hvn_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Dꞌèno peꞌie ri muu. Elia, èla ke pedèka. Tapulara, pehedèu noo ri dèu, pedèuu nga dꞌèi roo. Harièle na hère petobe ne lai do bꞌuke ri mone ubꞌa Deo rai uru he.” ");
INSERT INTO hvn_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ta dꞌai Yesus nga do tèlu ana ajꞌa Noo he, la pekupu wari nga ana ajꞌa do hadꞌe he, era rike ne dèu lowe he do pekupu. Ne lua dèka dèu lowe he, ta la heleo ne ana ajꞌa Yesus he pa dꞌara pebꞌajꞌa nga guru agama Jahudi he. ");
INSERT INTO hvn_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Mi nahère ne ngède Yesus ri dèu lowe he, ta kebꞌèdi hala ke roo, rowi pa dꞌara peira roo, Yesus do pa kolo lede ne ko. Moko ke roo ta perai la pehapo nga Noo. ");
INSERT INTO hvn_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ta kebꞌali ke Yesus pa roo, mihe ane, “Pebꞌajꞌa nengaa muu pa dꞌee?” ");
INSERT INTO hvn_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Dèka he dèu la pika, “Ama. Dꞌèno ko ri Ama! Yaa ne èba ana yaa do momone, peꞌie ko we noo, ri Ama. Do bꞌènga noo, iꞌa do pedai lii, pelai ti maho ri wango. ");
INSERT INTO hvn_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kiri maho ke ne wango ne la dꞌara noo, ta wèbe bꞌure-bꞌure ke ri noo pa rai. Tade woro ne ubꞌa, pekiho ne ngutu. Jꞌe hekoto noo mi ajꞌu made he. Èla ke ri yaa peꞌami ne ana ajꞌa Èu he, ta hudꞌe ne wango nee, tapulara jadꞌèi dꞌo.” ");
INSERT INTO hvn_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ta jꞌaga ke ri Yesus ne ana ajꞌa he, mihe ane, “Rihi tèra muu! Ajꞌa loro-loro muu ri Yaa, pe ma muu ngadꞌo tada. Adꞌo muu dꞌo parahajꞌa petuu nga Yaa. Hape la mii ke Yaa ne mèka-wènge pehedꞌapa nga muu? Èbe ko ma dꞌee, naiki ne!” ");
INSERT INTO hvn_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ta heroꞌe ke ri roo ne naiki ne nga Yesus. Ta ngède Yesus ri wango nee, ta hore ke ri noo naiki ne la wurai, pebꞌare-gore pa ène. Woro ne ubꞌa noo. ");
INSERT INTO hvn_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ta kebꞌali ke Yesus pa ama naiki nee, “Rai pèri ke nee, naiki ne pèdꞌa do mi nahee?” Bꞌale ri ama noo, “Rai tana iki. ");
INSERT INTO hvn_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Tui ke ne wango nee, ne dꞌèi ta pemade noo. Jꞌajꞌi wari ke noo, ne bui la dꞌara rao ai, ki adꞌo pebole pa dꞌara èi. Ruba ko we, ne dꞌara Ama. Ki jadꞌèi he, peꞌie ko ri Ama ne naiki na dꞌee.” ");
INSERT INTO hvn_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ta bꞌale ke ri Yesus, “Ta ngaa ku lii, ‘ki jadꞌèi? Jadꞌèiri Yaa harièle, hadꞌèita parahajꞌa we nga Yaa!” ");
INSERT INTO hvn_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ta bꞌale ke ri ama naiki nee, nga he mèri ta tangi, mihe ane, “Ama! Do parahajꞌa ma ke yaa. Ruba we ne dꞌara perue riko ne parahajꞌa yaa!” ");
INSERT INTO hvn_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Pa awe na ène, ngèdi ri Yesus ae ke ne dèu do dèka la peworo la ène. Ta pereda ke ri Noo pa wango nee, mihe ane, “Wango apa! Mèhu èni we èu ti dꞌara naiki na dꞌee, mijꞌe nara ta rèngi, iꞌa noo pedai lii. Bꞌole bꞌale wari èu la dꞌara noo!” ");
INSERT INTO hvn_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ta rènge ne lii pereda Yesus ri wango nee, ta pekaa ke noo pemèdèumèdèu Ta pekelole ke ri noo ne naiki nee, jꞌe kedꞌèji-dꞌèji, jꞌe mèhu èni noo ti dꞌara naiki nee. Hekoto ne naiki, mi do made he. Ane ne lii dèu pa ène, “Made ke naiki ne!” ");
INSERT INTO hvn_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ta pèro ke ri Yesus ne naiki nee, jꞌe pekèdꞌe noo. Ta kèdꞌèidꞌènge ke noo. ");
INSERT INTO hvn_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ta pekèdꞌèike Yesus nga ana ajꞌa Noo ti ène, jꞌe maho roo la dꞌara hewue èmu. Roo ke miha, pa dꞌara èmu nee, ta kebꞌali ke ne ana ajꞌa he pa Yesus, “Ama! Ta ngaa jꞌii ku dꞌo nara ta hudꞌe ne wango ne?” ");
INSERT INTO hvn_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ta lii ke Yesus pa roo, “Dꞌèno ko ri muu pe woie! Wango he do apa. Ki dꞌo hebꞌajꞌa muu ta ami kuaha ngati Deo, nara dꞌo muu ta hudꞌèiwango do mi nahii.” ");
INSERT INTO hvn_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ta pekèdꞌèirike Yesus nga ana ajꞌa Noo he ngati ène, la propensi Galilea. Ne dꞌèi Noo, bꞌole era do toi ri dèu ne lua dèka roo la nii, ");
INSERT INTO hvn_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ri ne dꞌèi Noo ta ajꞌa ne ana ajꞌa Noo he we. Ta lii ke Noo nga roo, mihe ane, “Tui dꞌoke, jꞌe pewie Yaa ri he dèu pa dèu do wola. Jꞌe pemade Yaa ri roo, do Dèu Rai-wawa do Petuu-Petuu dꞌee. Tèra Yaa ta made, tapulara pa nèli, ta muri wari.” ");
INSERT INTO hvn_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ta pika Yesus mi nahère, ta bꞌingu ke roo pelai ta dꞌo tada roo. Bꞌani dꞌo ke roo ta kebꞌali ne lua pedèbꞌo Yesus. ");
INSERT INTO hvn_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ta nèru rike Yesus he la Kapernaum. Ta dꞌai roo ne maho la dꞌara èmu, ta kebꞌali ke Yesus pa ana ajꞌa he, mihe ane, “Pebꞌatꞌa nengaa ke muu pa rujꞌara he ngine?” ");
INSERT INTO hvn_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Bꞌule dꞌo he dèu he do bꞌani ta bꞌale, ri pa rujꞌara he ngine do pebꞌata roo ta nadèu ne do rihi pa telora roo. ");
INSERT INTO hvn_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ta mejèdꞌèike Yesus, jꞌe ajꞌa roo, mihe ane, “Nadèu do dꞌèi ta dèu do ke rihi, muri mada noo petuu-petuu mi do ènu do pemoko dèu lowe.” ");
INSERT INTO hvn_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ta heroꞌe ke ri Yesus he dèu naiki, jꞌe bꞌale pa telora roo. Jꞌe lii Noo, ");
INSERT INTO hvn_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Nadèu do pedèue Yaa, jꞌe pemoko dèu mi naiki na dꞌee, ne pedèbꞌo nee, dèu na ène lema do pemoke Yaa. Lai na ène lema, pemoke Ama do pejue Yaa ma rai-wawa dꞌee.” ");
INSERT INTO hvn_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Moko ta kelaa ke Johani, ana ajꞌa Yesus, ane noo, “Ama. Hewari, era he dèu do hudꞌèiwango nga pake ngara Èu. Tapulara ta lara ke noo ri jꞌii, ri adꞌo noo kejie dii.” ");
INSERT INTO hvn_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ta bꞌale ke ri Yesus, “Bꞌole lara noo. Ri nadèu do pake ngara Yaa, ta tao madalae, adꞌo noo ta peꞌape ngara Yaa. ");
INSERT INTO hvn_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ki adꞌo noo do pelawa nga dii, tatu noo lema kejie dii. ");
INSERT INTO hvn_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Henge peꞌie ri muu! Kiri era dèu do tada muu ta dèu do pedèue Kristus, jꞌe rabꞌa-dꞌèru muu, tatu ta dꞌo bèlo ri Deo ne lua lobꞌo noo. Maji lema muu ta penginu èi loko wue he we, bèlo dꞌo ri Deo ne lua woie noo.” ");
INSERT INTO hvn_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ta pika rike Yesus pa roo, mihe ane, “Ki era dèu do èbe he dèu naiki la rujꞌara do hala, moko ne naiki ne ta dodꞌo parahajꞌa pa Yaa, jaga ie ó! Rihi ie dèu na ène, ta perète pa lakoko ri wowadu worena, jꞌe hore la lèu ae. ");
INSERT INTO hvn_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ki pake kae-ngaꞌa èu ta tao hala-ludu, ète jꞌe hore! Rihi ie èu ta maho la muri mada nga Deo nga he laa kae, ngata hore èu la dꞌara ai naraka nga dꞌue laa kae. ");
INSERT INTO hvn_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Ne naraka nee, era hedui-herui. Ne ai pa nii, do peloro-loro. Lema ne ètu pa ène, ngaꞌa pewèu pebꞌèku loro-loro ne dèu do maho la ène. ");
INSERT INTO hvn_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ki pake kae-jꞌèla èu ta tao hala-ludu, ète jꞌe hore! Rihi ie èu ta maho la muri mada nga Deo nga he laa kae, ngata hore èu la dꞌara ai naraka nga dꞌue laa kae. ");
INSERT INTO hvn_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ne naraka nee, era hedui-herui. Ne ai pa nii, do peloro-loro. Lema ne ètu pa ène, ngaꞌa pewèu pebꞌèku loro-loro ne dèu do maho la ène. ");
INSERT INTO hvn_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ki pake namada èu ta tao hala-ludu, ruke jꞌe hore! Rihi ie èu ta maho la muri mada nga Deo nga hewue namada, ngata hore èu la dꞌara ai naraka nga dꞌue bꞌue namada. ");
INSERT INTO hvn_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","‘Ne naraka nee, era hedui-herui. Ne ai pa nii, do peloro-loro. Lema ne ètu pa ène, ngaꞌa pewèu pebꞌèku loro-loro ne dèu do maho la ène.’ ");
INSERT INTO hvn_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Ne lii ajꞌa Yaa nee, do rihi ne mejèni. Naduu do dꞌèi ta pedute Yaa, do paraluu noo ta mèka tee ta pedute loro-loro Yaa, mi hedꞌai do tao ri mengèhi jꞌe noe pa lodꞌo, mijꞌe ta dꞌo wèu, maji lema ta tèke petui. ");
INSERT INTO hvn_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Mengèhi do ie. Do nara ta pe woie ngaꞌa. Tapulara ki ele ne hèro noo, bꞌule dꞌoke noo nga guna. Ta hore heke. Hèku muu he, do ie ta jadꞌèi mi mengèhi he, tuu muri mada pehajꞌa-pedꞌèi nga harièle dèu. Naa! Pengaha we muu ne pelule jꞌara lua naduu do rihi!” ");
INSERT INTO hvn_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ta pekèdꞌèike Yesus he la propensi Yudea, nga era do hewala pa hebꞌèka bara dimu loko Yarden. Pa mii-pa mii we Noo ne era, dèka la pewore ri dèu lowe. Ajꞌa roo ri Yesus, mi pa tima. ");
INSERT INTO hvn_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Era do pèri dèu do Parisi ne dèka la kale lai ta pebue Yesus. Ta kebꞌali roo, “Pedutu lua petèka agama dii, momone do èla pebanga èmu, ie ta peꞌela-pehegꞌi, we adꞌo?” ");
INSERT INTO hvn_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ta bꞌale ke ri Yesus, “Henge ko ri muu! Lua petèka Musa jꞌara lua banga-èmu, mi namii?” ");
INSERT INTO hvn_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ta bꞌale ke ri roo, “Lua petèka Musa, ie ma dèu ta peꞌela-pehegꞌi, hadꞌèita wie ne huri peꞌela-pehegꞌi pa ihi-èmu noo do mobèni.” ");
INSERT INTO hvn_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Bꞌale ri Yesus, “Dꞌèno ri muu! Ta rihi paja kètu muu, ku bꞌuke ri Musa mi nahère! ");
INSERT INTO hvn_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Bꞌole bèlo ri muu lii pedꞌèii petari rai awe tao ri Deo liru nga rai-wawa. Do bꞌuke, mihe ane, ‘Woro dèu rai-wawa ri Deo, momone nga mobèni. ");
INSERT INTO hvn_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ri mi nahère ke, ku momone do ta kèdꞌèiti dꞌara kadꞌo ina-ama noo, la muri mada hewue ade-pengee nga ihi-èmu noo, ");
INSERT INTO hvn_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ku hari do dꞌue roo jadꞌèi he èhi.’ ");
INSERT INTO hvn_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ki èla ke roo dꞌue pe pejadꞌèi èhi ri Deo, ie dꞌo ta peꞌela wari ri dèu rai-wawa!” ");
INSERT INTO hvn_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Èla pe mi nahère, ta maho ke Yesus nga ana ajꞌa Noo he la dꞌara hewue èmu. Ta kebꞌali ke ri roo ne ihi lii ajꞌa do ngine nee. ");
INSERT INTO hvn_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ta peteleo ke ri Yesus, mihe ane, “Naduu do peꞌela nga ihi-èmu noo, jꞌe banga èmu wari nga mobèni do wala, èla ke noo petao lai kenyoo! ");
INSERT INTO hvn_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Mi nahère lema he dèu mobèni! Naduu do peꞌela nga ihi-èmu noo, jꞌe banga èmu wari nga momone do wala, èla lema ke noo petao lai kenyoo!” ");
INSERT INTO hvn_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Hewari, ta dèka ke ne dèu nga èba ana roo nga Yesus, mijꞌe ta tèka ruai, jꞌe mengao ne mèngi tuu naiki. Ta bꞌani ke ne ana ajꞌa Yesus nga roo. ");
INSERT INTO hvn_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ta ngèdi ri Yesus mi nahère, ta bubu dꞌara ke Noo nga ana ajꞌa he, jꞌe lii, “Hani we ne naiki na hère, pe dèka nga Yaa! Bꞌole bꞌata roo! Ri dèu do mi nahère ke, ne dèu do unu Deo. ");
INSERT INTO hvn_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Henge ri muu pe woie! Naduu do ta dèka nga Deo, paraluu ne lua dꞌèi noo nga Deo, mi dꞌèi naiki na hee nga ina-ama noo. Ki adꞌo mi nahère, jꞌèma dꞌo roo ta jadꞌèi dèu do unu Deo.” ");
INSERT INTO hvn_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ta èla Yesus pe lii mi nahère, ta kedꞌaka ke ri Noo ne naiki he, jꞌe tèka ruai, mengao ne mèngi tuu roo hedèu-hedèu. ");
INSERT INTO hvn_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ta dꞌai Yesus he dꞌèi ta pekèdꞌèiti ène, dèka ke he dèu do kaja nga perai la pehapo nga Yesus. Ta lèku rutuu ke noo pa hedꞌapa Yesus, jꞌe kebꞌali, “Ama Guru do woie. Ne ta kebꞌali ko yaa hudi. Mi nahee, Ama. Nengaa ke ne do ta tao ri yaa, mijꞌe toi tèra ri yaa, ta do maho yaa la liru-bèla ta muri mada helaꞌu nga Deo?” ");
INSERT INTO hvn_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ta bꞌale ke Yesus, “Ta ngaa èu ku lii pa Yaa, ta ‘do woie’!? Bꞌule dꞌo he dèu he do woie, tituwata Deo we. ");
INSERT INTO hvn_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Toi ma ri èu ne lii pereda Deo, rai uru: “Bꞌole pemade dèu; Bꞌole kenyoo; Bꞌole manaꞌo; Bꞌole jadꞌèi hakahii pote; Bꞌole èba unu dèu nga rujꞌara pepote; Pekebꞌue ina-ama èu!’ ” ");
INSERT INTO hvn_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ta bꞌale ke ri dèu na ène, “Do petuu, Ama Guru, ee! Rai nga ngèru, harièle na hère, èla ke ri yaa petao.” ");
INSERT INTO hvn_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Bui ne ade Yesus nga dèu na ène. Ta lii ke Noo, mihe ane, “Petuu! Tapulara ne ko he èhi lai. Awe na dꞌee, bꞌale we èu la pewie peꞌèla ne puhaka èu. Ne doi he, la pebꞌagi pa do kehia. Jꞌe mai èu ma pedute Yaa. Do ta wie pa èu ri Deo, ne puhaka do wala pa liru-bèla.” ");
INSERT INTO hvn_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ta rènge ri noo ne lii pedai Yesus, mèje ne ade noo. Bꞌale noo nga hedui pengee, ri do kaja tèra noo. ");
INSERT INTO hvn_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ta heleo peheru ke Yesus, jꞌe pedai lii nga ana ajꞌa Noo he, “Dꞌèno ri muu! Dꞌai hedui do kaja ta maho la dꞌara liru-bèla.” ");
INSERT INTO hvn_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ta rènge ne lii pedai Noo, ta hengodo ke ne ana ajꞌa. Ta petabe rike ri Yesus, “Dꞌèno peꞌie! Dꞌei ta jadꞌèi dèu do unu Deo, rihi hedui! Bꞌole pengee ta do memudꞌe. ");
INSERT INTO hvn_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Tuu do kaja maho la liru-bèla ta jadꞌèi dèu unu Deo, helaꞌu hedui nga bꞌada unta do mone ae, maho la dꞌara bèdo jꞌara roꞌa wui-wohe jꞌejꞌau.” ");
INSERT INTO hvn_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ri lii pedai Yesus, buwu bꞌingu roo. Ta pekebꞌali rike roo, “Ki do petuu ke mi nahère, naduu ke ne do ta nara helama?” ");
INSERT INTO hvn_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ta heleo ke roo hedèu-hedèu ri Yesus, jꞌe lii, “Tu dèu rai-wawa, era lai dodꞌo jadꞌèi Tapulara tu Deo, hari-hari lai do jadꞌèi we!” ");
INSERT INTO hvn_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ta lii ke Petu, “Ama. Èla ke pehani ri jꞌii, harièle ne oha-unu jꞌii, tuu ta ma pedꞌute Ama. Nengaa ke ne nara jꞌii?” ");
INSERT INTO hvn_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Ane Yesus, “Ne lii Yaa pa muu mi nahee: Naduu do pedute Yaa, nga rujꞌara hani ina-ama noo, ꞌaꞌa-ari noo, ana-ana noo, lau-dꞌoka noo, lua jꞌèga noo, nga harièle ihi èmu-kemali, tuu ta la pika pa dèu pa mii-pa mii jꞌara Lii Hagꞌa Dꞌara ngati Deo, do ta hème wari ri noo hengahu wari lipa. Harièle nengaa do èla pehani ri noo, do ta hème wari nga do rihi. Do ta nara lema noo, hedui-herui taga pedute Yaa. Tapulara, pa awe pedèka rahi rai-wawa dꞌee, do ta muri mada noo peloro-loro helaꞌu nga Deo. Na ène ke ne pala noo! ");
INSERT INTO hvn_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Henge ri muu! Pedutu nga pengee Deo, naduu do pedꞌèia èni, do ta jadꞌèi noo ta rihi naiki. Tapulara naduu do pewawa èni, pedutu nga pengee Deo, do ta jadꞌèi noo ta dèu do nga kebꞌue. ");
INSERT INTO hvn_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Hewari, ta kako ke Yesus he la Yerusalem. Yesus ne do leko jꞌara. Jꞌe lere ri ana ajꞌa Noo nga dèu do hewala he. Henge ri roo ne lii pedai Yesus ta do era dèu ta pemade Noo pa Yerusalem. Ri mi nahère ke, megꞌigꞌi ne lai pengee roo medaꞌu ri lai na ène. Ta rèngi ke ri Yesus ne lii pedai ana ajꞌa Noo he, ta pedoa wala ke roo, jꞌe la pika ri ne lai do wala do ta tao ri dèu pa Noo pa Yerusalem. ");
INSERT INTO hvn_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Lii ri Noo, “Dꞌèno ri muu! He ke dii ta la Yerusalem. Yaa na dꞌee, Dèu Rai-wawa do Petuu-Petuu. Tapulara dꞌai nii, do ta pewie Yaa pa mone ketèu pa kètu agama he, nga guru agama he. Ta hèpo ke ri roo, ta pemade Yaa. Jꞌe jꞌole ri roo Yaa pa dèu do hewala do dꞌo tade Deo. ");
INSERT INTO hvn_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Jꞌe pedai roo mijꞌe ta mekae dꞌara Yaa pa hedꞌapa dèu lowe. Hebue Yaa ri ilu roo. Wuhe dꞌabe-dꞌabe, tade mae èle ne ihi Yaa. Itu pemade Yaa ri roo. Made tèra Yaa, tapulara nèli do ta muri wari Yaa.” ");
INSERT INTO hvn_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Èla pa na ène, dèka ke nga Yesus, Jꞌako nga Johani, ana Sabadeu. Ami roo, “Ama Guru! Ne nga paraluu ko jꞌii.” ");
INSERT INTO hvn_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ta kebꞌali ke Yesus, “Paraluu nengaa muu?” ");
INSERT INTO hvn_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Bꞌale ri roo, “Ama, ee. Mi nahee. Ki dꞌai Ama ne mejèdꞌèita pèru pereda, ne ami jꞌii, pejèdꞌèiwe jꞌii he dèu pa kedꞌanga, nga he dèu pa keriu Ama, ta pereda helaꞌu nga Ama.” ");
INSERT INTO hvn_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ta bꞌale ke ri Yesus, “Tada dꞌo muu dꞌue nengaa ne do ami muu. Yaa ne hine, do ta nara hedui do rihi ae. Ku mi namii? Ne pengee ri muu, mèka muu ta hape ne hedui helaꞌu nga Yaa tade made?” ");
INSERT INTO hvn_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Bꞌale ri roo, “Mèka, Ama, ee!” Ta lii rike Yesus pa roo, “Tèra. Hine do ta hape lema ri muu ne lua hedui mi do hape ri Yaa. ");
INSERT INTO hvn_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Tapulara naduu do ta mejèdꞌèipa kedꞌanga nga pa keriu Yaa, adꞌo lai petèka Yaa. Na ène lai hèpo Deo. Do èla pehèpo ke ri Noo ta naduu do mejèdꞌèipa era na ène.” ");
INSERT INTO hvn_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ta rèngi ri ana ajꞌa do wala he ne lii ami Jꞌako nga Johani, ta bubu dꞌara ke roo. ");
INSERT INTO hvn_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ta pedoa ke harièle roo ri Yesus, jꞌe pedai nga roo, “Mi nahee! Toi ri muu. Do pereda do tima ta jꞌèli kerupu dèu rai tade dodꞌo iꞌa kemuki. Nga kètu rai dèu dodꞌo tade Deo, eꞌe ne dꞌèi roo we ne tao pehedui ana rai, tade dodꞌo nara roo ta pekèdꞌèikètu. ");
INSERT INTO hvn_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Muu he bꞌole jꞌèga mi nahère! Naduu ti telora muu do dꞌèi ta pemone ae èni, paraluu noo ta jadꞌèi mi jongo do pemoko dèu do hewala. ");
INSERT INTO hvn_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Nga naduu do dꞌèi ta jadꞌèi kètu, paraluu noo ta jadꞌèi mi do ènu. ");
INSERT INTO hvn_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Yaa dꞌee, Dèu Rai-wawa do Petuu-Petuu. Ne dèka Yaa, adꞌo mijꞌe ta ma pemoke Yaa ri dèu. Tapulara ne dèka Yaa, ta ma pemoko dèu lowe. Ne dèka Yaa, ta ma wie bolo-bolo ne muri mada Yaa ta ma pehèu dèu lowe ngati hala-ludu roo.” ");
INSERT INTO hvn_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yesus nga ana ajꞌa Noo he nga dèu lowe he dꞌai la kota Yeriko. Ta dꞌai roo ne mèhu èni ti nii, era ke he dèu do bꞌèdu do mejèdꞌèipa ngidi rujꞌara, nga henata ai ta ami nengaa pa dèu do lake. Ne ngara noo Bartimeo, ana ri Timeo. ");
INSERT INTO hvn_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ta rènge ri noo, ta Yesus do Nasare do lake jꞌara ène, ta pekaa ke noo pemèdu-mèdu, “Yesus! Kolo-loro Dau ee! Tui ke Èu ne mate ri jꞌii do Jahudi! Ruba kowe ne dꞌara nga yaa!” ");
INSERT INTO hvn_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ta rènge ne lii pekaa noo, ta bꞌani ke ne dèu he, “He! Bꞌole toli!” Tapulara, juu mèdu ne lii pekaa noo, “Wo Yesus! Kolo-loro Dau ee! Ruba kowe ne dꞌara nga yaa!” ");
INSERT INTO hvn_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ta titu ke Yesus. Jꞌe lii Noo, “Èbe ko noo ma dꞌee ri muu!” Ta kako ke roo nga noo, jꞌe lii, “Pehèngo èni we! Pedoe èu ri Ama Guru. Mai we!” ");
INSERT INTO hvn_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ta rèngi mi nahère, ta hore ke ne hijꞌi noo, jꞌe kèdꞌèimèri ai la pehapo nga Yesus. ");
INSERT INTO hvn_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Kebꞌali ke Yesus pa noo, mihe ane, “Ami nengaa èu?” Ta bꞌale ke ri noo, “Muri, ee! Ami ta ngèdi ne namada yaa.” ");
INSERT INTO hvn_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ta lii rike Yesus pa noo, “Ri parahajꞌa èu, ta do iꞌa Yaa peꞌie èu, ie tèra ke èu! Bꞌale we.” Ta ngèdi dꞌènge ke, ne namada noo. Pedutu le noo la pengèdo Yesus. ");
INSERT INTO hvn_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ta umu roo nga kota Yerusalem, ta dꞌai ke roo la rae Betfage nga Betania, pa keraha bꞌojo Saitun. Ta pengaha ke Yesus he, he melila pa ène. Ta pejuu uru ke ri Yesus do dꞌue ne ana ajꞌa Noo. ");
INSERT INTO hvn_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Nga lii, mihe ane, “Kako uru ko muu la rae na nii. Dꞌai muu ne maho la dꞌara rae nee, do tangède ri muu he ngiꞌu ana keledei do èke. Adꞌo dae do ngèdi ta menyaꞌe ri dèu. Maꞌe ri muu jꞌe peraꞌo ma dꞌee. ");
INSERT INTO hvn_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Kiri era dèu do kebꞌali pa muu, ‘Peraꞌo ta ngaa ri muu ana keledei nee?’ Pika ri muu, ‘Ta paraluu Muri dii. Kiri moko ne pake, ta pebꞌale dꞌènge ma.’ ” ");
INSERT INTO hvn_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ta pekèdꞌèike roo dꞌue la nii. Era tèra ke, ne ana keledei ne do èke pa hedꞌapa èmu pa ngidi rujꞌara. Ta maꞌe ri roo, jꞌe peraꞌo. ");
INSERT INTO hvn_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ta kebꞌali ke ne dèu do titu pa ène, mihe ane, “Ta ngaa! Ku peraꞌo ri muu ne ana keledei ne?” ");
INSERT INTO hvn_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ta bꞌale ke ri roo, mihe ane, “Ta paraluu Muri dii. Kiri moko ne pake, do ta pebꞌale dꞌènge ma ri jꞌii ma dꞌee.” Ta hani ke ri dèu he, ta peraꞌo ri roo ne ana keledei nee. ");
INSERT INTO hvn_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ta peraꞌo ke ri roo la wie pa Yesus. Ta wèle ke ri roo ri hijꞌi pa dèni ana keledei nee, jꞌe jꞌole pa Yesus ta menyaꞌe. ");
INSERT INTO hvn_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ta dꞌai roo ta umu dꞌara kota, hèga ne dèu he la wèla ne bꞌara pake roo pa dꞌara rujꞌara. Era lema hadꞌe do la para ruajꞌu do mii runyiu he pa ngidi rujꞌara, jꞌe la wèla pa rujꞌara, do ta lake ri Yesus. Ne tao roo mi nahère, he èhi pekebꞌue Yesus ta mihe dèu duae. ");
INSERT INTO hvn_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Era hadꞌe do peꞌuru èni nga Yesus, era hadꞌe do lere Yesus. Ta hodꞌa-kejꞌeka ke roo, mihe ane, “Hosana! Pekelode ne ngara Deo! Ta wie ri Deo ne mèngi pa dèu do dèka nga ngara Deo, ri Noo ke do pejue ri Deo. ");
INSERT INTO hvn_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Hosana! Pekelode ne ngara Deo! Ri Deo miha do tama pekèdꞌe wari kuaha pereda duae Dau! Hosana! Pekelode ne ngara Deo! Ri Deo ke do mejèdꞌèita pereda ti liru-bèla do ketutu!” ");
INSERT INTO hvn_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ta dꞌai Yesus he la dꞌara kota, ta maho ke roo la kebꞌèla rae Èmu Kepue Hebꞌajꞌa pa Deo. Pereha ri Noo hari hewue ne dꞌara kebꞌèla rae Èmu Hebꞌajꞌa nee. Tapulara ri umu ke ta jèna lodꞌo, nara dꞌo ke roo tatao nengaa wari pa ène, ta bꞌale ke roo la rae Betania. ");
INSERT INTO hvn_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ta jꞌèmi ae do bꞌèli rai nee, ta pekèdꞌèike roo ti Betania bꞌale la kota Yerusalem. Pa telora rujꞌara, ta menganga ke Yesus. ");
INSERT INTO hvn_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ta ngède ke ri Noo he kepue ajꞌu pa ngidi rujꞌara. Do tima tangaꞌe ri dèu ne wue noo. Ta kako ke Yesus la peꞌumu-èni, la heleo ngee ta do era nga wue. Ta dꞌai Noo la kepue ajꞌu nee, heleo ri Noo bꞌule dꞌo nga wue, rèu ne we do bibu. Pa dꞌara awe do na ène, adꞌo tèra ma do awe wue. ");
INSERT INTO hvn_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ta lii ke Yesus pa ajꞌu na ène, “Pelai ti dodꞌo bꞌule èu nga wue tu Yaa, jꞌari ngati awe na dꞌee, bꞌole era wari èu nga wue ta wie pa dèu do hewala!” Rèngi lema ri ana ajꞌa Noo ne hekoto lii pedai Yesus pa ajꞌu nee. ");
INSERT INTO hvn_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ta èla pe mi nahère ta nèru ke roo teruu la Yerusalem. Maho ke Yesus la dꞌara Èmu Kepue Hebꞌajꞌa pa Deo. Pa kebꞌèla rae Èmu Hebꞌajꞌa na ène, do tao mi paha he ri dèu ta pewie koro jꞌawa, ta bꞌara jꞌola wie Deo. Ta ngèdi ri Noo mi nahère ta hudꞌèila tele ke ri Noo. Nyèka ri Noo pekebꞌèla ne meja-meja pehuru doi, lema bꞌagu-bꞌagu ihi dꞌaga koro jꞌawa he. ");
INSERT INTO hvn_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Lara ri Noo harièle dèu, ta bꞌole lake nga èba nengaa we, jꞌara dꞌara rae Èmu Hebꞌajꞌa ène. ");
INSERT INTO hvn_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ajꞌa ri Noo dèu, ane Noo, “Do toi ke ri muu, nengaa ne do hure do bꞌuke, mihe ane, ‘Ne peꞌera ri Yaa ne Èmu na dꞌee, tuu harièle kejie dèu, ta maa hebꞌajꞌa pa dꞌee.’ Tapulara lare ri muu ne Èmu na ène, ta era pekupu do peraba dèu!” ");
INSERT INTO hvn_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ta rèngi ri mone ketèu pa kètu agama he nga guru agama he ne lii pedai jꞌara lua tao Yesus do mi nahère, bubu dꞌara tèra roo. Moko ke roo ta kale rujꞌara ta pemade Noo. Tapulara megꞌigꞌi roo, ri ae tèra ke ne dèu do dꞌèi nga lii ajꞌa Noo. ");
INSERT INTO hvn_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ta umu ta jèna lodꞌo, ta pekèdꞌèike roo ti kota Yerusalem, la bèjꞌi la Betania. ");
INSERT INTO hvn_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","21","Ta jꞌèmi ae do bꞌèli rai ène, ta bꞌale rike roo la Yerusalem. Dꞌai le telora rujꞌara, ta lake ke roo jꞌara ajꞌu do midꞌa nee, do pedai lii Yesus nga noo nee. Ta ngède ne ajꞌu na ène, ta madalae ke ne ana ajꞌa Noo he harièle, ri made ke hari nga amo nee, ne ajꞌu na ène. Ta henge ke ri Petu ne lii pedai Yesus pa ajꞌu na ène. Ta lii ke noo, “Ama! Heleo ko ri Ama ne ajꞌu do midꞌa nee, do wole ri Ama nee, made ke!” ");
INSERT INTO hvn_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ta bꞌale ke ri Yesus, “Do tèra! Hadꞌèita parahajꞌa lema muu pa Deo mi nahère. ");
INSERT INTO hvn_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Kiri parahajꞌa tèra muu, nara lema muu ta lii pa hewue lede, ta bꞌita èni jꞌe lari èni la dꞌara dahi ae. Do ta lare ma ri Deo ne lede na ène, ki parahajꞌa muu nga petuu. Parahajꞌa we muu nga ketèra pa Deo. ");
INSERT INTO hvn_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Naa, bꞌole bèlu, oo! Hadꞌèita parahajꞌa tèra muu ta Deo do nara ta wie nengaa we ne do ami muu, do ta wie tèra ma ri Deo pa muu! ");
INSERT INTO hvn_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Tapulara ki hebꞌajꞌa muu, jꞌe era nga pengee do apa nga dèu do wala, la peꞌie uru ko nga dèu na ène. Mi nahère lema Ama muu pa liru-bèla do ta lonye-pemèu uru lema ne hala muu. ");
INSERT INTO hvn_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Kiri era do petèka pengee do apa, nga dꞌo wae ta pehuba hala dèu do wala, tatu Ama muu pa liru-bèla bèlu le dꞌo maa ne hala-ludu muu.” ");
INSERT INTO hvn_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ta nèru teruu ke roo. Ta dꞌai le Yerusalem, ta maho ke roo la dꞌara Èmu Kepue Hebꞌajꞌa pa Deo. Ta dꞌai roo la dꞌara rae nee, ta dèka ke ne mone ketèu pa kètu agama he nga guru agama he. ");
INSERT INTO hvn_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ta kebꞌali ke roo pa Yesus, “Naduu do pepue Èu ma tao kenyaꞌu pa dꞌee midꞌa dꞌee? Naduu ne do wie higa pa Èu?” ");
INSERT INTO hvn_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Do toi ri Yesus ne lua pedèbꞌo roo ta kale rujꞌara ta pebue Noo. Ta bꞌale ri Yesus pa roo, “Ta kebꞌali lema Yaa pa muu. Bꞌale uru ri muu ne lii kebꞌali Yaa, jꞌeꞌitu wie muu ri Yaa ne lii bꞌale! ");
INSERT INTO hvn_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ne lii kebꞌali Yaa mi nahee: tade ri muu Johani, mone peherani dèu. Naduu do pejue noo la peherani dèu? Deo, we dèu rai-wawa?” ");
INSERT INTO hvn_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ta pengee bꞌale-bꞌale ke ri roo, jꞌe pelii roo, “Wee! Apa ke dii! Ki bꞌale ri dii, ‘ta pereda ri Deo’, lii Noo nèbꞌo, ‘kiri mi nahère ta ngaa muu ne dꞌo parahajꞌa pa Johani!’ ");
INSERT INTO hvn_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Jadꞌèidꞌo ke dii ta lii ‘ta ti dèu rai-wawa’. Ta kenyaꞌu ke dèu lowe he nga dii. Ri do parahajꞌa tèra ke roo, ta Johani, mone ubꞌa ngati Deo.” ");
INSERT INTO hvn_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ta lii ke roo pa Yesus, mihe ane, “Toi do ri jꞌii!” Moko ta lii ke Yesus pa roo, “Kiri mi nahère, wae ledꞌo ma Yaa ta bꞌale ne lii kebꞌali muu, ta naduu ne do wie higa pa Yaa.” ");
INSERT INTO hvn_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ta jꞌari ke Yesus ta pedai lii nga mone ketèu pa kètu agama Jahudi he, guru agama he, nga dokepai-dokepai do Jahudi he. Ta pake ke Noo lii pehèku, mihe ane, “Era he dèu ta jꞌari doka ago pa rai noo miha. Ta wue ke ri noo ri pudi. Ta tao ke ri noo ne bꞌaa ta pengèhi èi ago. Lema tatao ke ri noo ne leo do dꞌèia ta meniga dꞌoka. Èla pe mi nahère, pehabꞌe ri noo ne dꞌoka ne pa dèu do hewala, tuu ta pebꞌagi ihi rai nga noo. Jꞌe pekèdꞌe noo la tele rai. ");
INSERT INTO hvn_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ta dꞌai ne awe puu wo ago, ta pejue ke ri noo he dèu ne ènu noo la hèmi ihi rai pa dèu habꞌa ago he. ");
INSERT INTO hvn_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ta dꞌai ne dèka ènu do pejue ri noo, hème dꞌènge ri dèu habꞌa he ta kèpe, jꞌe merèho. Èla pe mi nahère, jꞌe pebꞌale noo nga ai wue. ");
INSERT INTO hvn_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ta pejue rike ri mone oha dꞌoka ne he dèu ne ènu noo la hèmi ihi rai. Hème wari ri dèu habꞌa he ta merèho, tade boo kètu. Lema pemekae dꞌara noo, jꞌe hudꞌe-perage. ");
INSERT INTO hvn_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ta pejue rike ri mone oha dꞌoka ne he dèu ènu do wala. Tapulara pemade ri roo. Maji ta mi na mii le ne tao roo, ta pejue teruu ma ne ènu noo he. Tapulara ri dèu habꞌa he, era do hèmi ta merèhu, era hadꞌe do pemade. ");
INSERT INTO hvn_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Hiha ana noo ke do mone miha, ana dꞌèi noo. Ri dꞌo bꞌule ke rujꞌara do wala, ta pepue ke ri noo ne ana dꞌèi noo. Pa dꞌara pengee noo, mihe ane, ‘Kiri pepue ri yaa ne ana metana yaa, do ta hème nga woie, jꞌe dꞌèno ri roo ne lii pedai noo.’ ");
INSERT INTO hvn_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ta pejue ke ne ana noo la nii. Ta ngède ri roo ne ana noo ta dèka ta pelii ke roo, mihe ane, ‘Heleo ko ri muu! Nène ke ri ama noo do pejue ne ana noo miha! Ki made ama noo, noo ke nee do hèmi puhaka. Mai ri dii ma pemade, mijꞌe bui pa dii ne puhaka noo!’ ");
INSERT INTO hvn_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ta kèpe ke ri roo ne ana do na ène, jꞌe pemade. Èla pe mi nahère hore noo la tele dꞌoka ago nee. Mi nahère ke ne lii pehèku dꞌee.” ");
INSERT INTO hvn_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ta kebꞌali ke Yesus pa dokepai he, “Pa dꞌara pengee muu, nengaa ke ne do ta tao ri mone oha dꞌoka ne pehedꞌapa nga dèu habꞌa he? Pedutu pengee Yaa, do bꞌara tatu ke noo, ta dèka la pemade harièle dèu habꞌa he. Hème ne dꞌoka nee, jꞌe pehabꞌe pa dèu do hewala. ");
INSERT INTO hvn_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Do ajꞌe ke ri dii, ne lii pedai Deo do era do hure dꞌo bꞌuke, miha ane, ‘Era hewue wowadu do hore ri tuka wowadu he. Tapulara, ne wowadu na ène, èla ke pejadꞌèi ita wowadu kepue gerii. ");
INSERT INTO hvn_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Deo miha ne do èla pe pidꞌe, jꞌe pejèdꞌe ne wowadu ène. Ri mi nahère ke, dꞌai gaa ne heleo ri dii!’ ” ");
INSERT INTO hvn_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Toi dꞌènge ma ri mone kepai-mone kepai he, ta ne lii pehèku Yesus do lèka pa roo. Roo ke ne do pehèko nga dèu habꞌa ago he. Ta jꞌari ke roo ta kale rujꞌara ta kèpe Noo. Tapulara medaꞌu roo ri dèu lowe he, do dꞌèi nga lii ajꞌa Noo. Ta pehègꞌa ke roo ti ène, jꞌe hane Yesus. ");
INSERT INTO hvn_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Èla pe na ène, ta pejuu ke ri mone kepai do Jahudi he, do pèri dèu, do Parisi nga ti paratei Herode, la kebꞌali pa Yesus, ta kale ne hala lii pedai Noo. ");
INSERT INTO hvn_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ta dèka ke roo, jꞌe kebꞌali pa Noo, mihe ane, “Wo Ama Guru! Toi ri jꞌii ta Ama mone mola ngee, adꞌo do pote-èpi. Do tère lohe ade dèu. Do pedai nga woie ri Ama, ne dꞌèi Deo, nga dꞌo heleo worèwu dèu. Nga na dꞌee ta kebꞌali jꞌii he èhi lai. Pedutu lua petèka agama dii do Jahudi, ie ko ma ke dii ta maꞌi bꞌea pa Kehe, Duae Mone Ae Roma, we adꞌo?” ");
INSERT INTO hvn_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Do toi ri Yesus ne lua huni pengee roo, mijꞌe ta pedai Noo ta pelawa nga duae Roma. Ta bꞌale ke ri Yesus nga kèri, “Ta ngaa ke muu ku pehero Yaa nga lii kebꞌali na dꞌee? Wie ko pa Yaa ri muu ne he mada doi melaa-pudi!” ");
INSERT INTO hvn_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ta jꞌole ke ri roo he mada ne doi melaa-pudi. Ta hème ke ri Yesus, jꞌe pereha ne doi na ène. Ta kebꞌali ke Noo pa roo, “Gaba na dꞌee, worèwu naduu? Jꞌe ngara naduu na dꞌee?” Ane roo, “Na dꞌee, unu Duae do pereda Roma!” ");
INSERT INTO hvn_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ta lii ke Yesus, “Kiri mi nahère, wie pa do pereda ne do unu do pereda, jꞌe wie pa Deo ne do unu Deo.” Ta rènge ne lii bꞌale Yesus mi nahère, ta madalae ke roo hari-hari, ri ne lii pedai Noo do petuu. Hèku nara dꞌo roo kewèhu ta kèpe Yesus. ");
INSERT INTO hvn_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Era èhi paratei agama do wala, ne ngara paratei Saduki. Ne lii ajꞌa roo, do made nara dꞌoke ta muri wari. Pa dꞌara he wari, dèka do pèri dèu ngati paratei Saduki la pehero Yesus. ");
INSERT INTO hvn_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Pedai roo nga Yesus, mihe ane, “Ama Guru! Lua petèka ama-èpu dii Musa, do hure dꞌo bꞌuke wie dii, mihe ane: ki era he dèu momone do banga-èmu, jꞌe made nga dꞌo bꞌule ana, ne mone ari ri noo ta banga-èmu nga mobèni ihi-èmu aꞌa nee, mijꞌe ta era kolo-loro natuu aꞌa noo do made nee. ");
INSERT INTO hvn_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Mi nahère ke ne lii ajꞌa Musa. Ne kebꞌali jꞌii mi nahee: Era mone pidu. Mone aꞌa nee, ta banga-èmu ke. Moko ta made, nga dꞌo bꞌule nga ana. ");
INSERT INTO hvn_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Moko ne mone ari do penanuhi nga noo, ta banga-èmu ke nga ihi-èmu aꞌa noo. Tui dꞌo, ta made ke ne momone, nga dꞌo bꞌule nga ana. Mi nahère lema nga ari do ketèlu; bènga-èmu nga mobèni na ène. Made, nga dꞌo bꞌule nga ana ri ma. ");
INSERT INTO hvn_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Mi nahère ke teruu, tade mone ari tèka. Made, nga dꞌo bꞌule nga ana lema. Ta made leke ne mobèni nee. ");
INSERT INTO hvn_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Naa! Ne kebꞌali jꞌii mi nahee: ne mobèni na ène do èla ke banga-èmu nga hari do pidu dèu. Kiri dꞌai ne pedèka rai rai-wawa, jꞌe pemuri wari ri Deo ne do made he, na mii ke ne ihi-èmu mobèni na ène, ti telora do pidu dèu he?” ");
INSERT INTO hvn_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ta bꞌale ke ri Yesus, “Pa dꞌara lii kebꞌali muu na ène, tada dꞌo muu ne ihi do hure dꞌo bꞌuke. Lema tada dꞌo muu ne kuaha Deo. Hèku, rihi hala ke ne pengee muu! ");
INSERT INTO hvn_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Dꞌèno we mi nahee! Pa liru-bèla bꞌule dꞌo ke lua pebanga-èmu. Harièle do made do pemuri wari ri Deo, adꞌo ke do ta banga-èmu. Mi nahère lema mi dèu pejuu Deo he, adꞌo do ta banga-èmu. ");
INSERT INTO hvn_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ngine nee, kebꞌali muu ne dèu do made he, do ta muri wari roo, we adꞌo? Ta pika Yaa pa muu do hure do bꞌuke ri Musa, era ne lii pedꞌèii jꞌara lua he kepue na ajꞌu, do weo ri ai, tapulara kèpu dꞌo. He wina ko ma ke ri muu ne lii pedꞌèii na ène, we adꞌo? Ta dꞌai ne weo ai pa ajꞌu do na ène, ta pika ke Deo pa Musa, mihe ane, ‘Yaa ke na dꞌee, Deo Muri ri ama-èpu èu, Abraham, Isak nga Jꞌako. Harièle roo mejura teruu pa Yaa hape ma awe do na dꞌee.’ ");
INSERT INTO hvn_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Toi ri dii, ta ne ama-èpu dii nahère, tui ke ne made. Ku dèu do muri do mejura pa Deo, adꞌo do made, to? Tapulara, ri do pedai ke Deo, ta Noo ke ne Deo Muri roo, ku do pedai dii ta do muri wari ke roo. Hèku dèu do made, do muri wari. Hèku, ki pèro teruu ri muu ne lii ajꞌa ta do made adꞌo do muri wari, rihi hala ke muu!” ");
INSERT INTO hvn_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Pa dꞌara awe na ène, era he dèu guru agama, do rènge ne lii pebꞌale Yesus nga paratei do Saduki he. Pa dꞌara pengee noo, ne lii pedai Yesus do pelèka woie. Ta kebꞌali ke noo pa Yesus, mihe ane, “Ama! Ta kebꞌali yaa, mi nahee: ne petèka hadꞌa rai dii, nga lii pereda agama dii, do rihi ae! Ti harièle lii pereda do petèka Musa he, namii ke do kerihi?” ");
INSERT INTO hvn_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ta bꞌale ke ri Yesus, “Ne lii pereda do kerihi do hure dꞌo bꞌuke, mi nahee: ‘Harièle dèu pa Israꞌel, dꞌèno nga woie! Ne Deo nee, Noo ke ne Deo Muri dii, nga Muri Mone dii! Bꞌule do ke do wala, ngati Noo! ");
INSERT INTO hvn_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Hèku, dꞌèi tèra muu nga Deo Muri muu perihe ngati harièle lai. Ri mi nahère ke, hengee tèra we ne ade-pengee muu nga Muri, tade kehème we Noo nga woie, nga jꞌège petadi ne lua dꞌèi Noo.’ ");
INSERT INTO hvn_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Nga lii pereda kedꞌue nee, mi nahee: ‘Dꞌèi nga dèu do hewala, mi dꞌèi nga ngiꞌu èu miha.’ Dꞌue nahee ke ne lii pereda do kerihi. Bꞌule dꞌoke ne lii pereda do wala, do rihi ngati dꞌue lii pereda do na dꞌee.” ");
INSERT INTO hvn_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ta lii rike ne guru agama ne pa Yesus, mihe ane, “Tèra! Ne do lii Papa nee, do petuu. Deo Muri ke ne do Muri Mone ri dii, bꞌule dꞌoke Deo do hewala. ");
INSERT INTO hvn_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Dꞌèi tèra we dii nga Noo perihe ngati harièle lai, jꞌe hengee petone ne ade-pengee dii nga Noo, tade kehème we Noo nga woie, nga jꞌège petadi ne lua dꞌèi Noo. Nga dꞌèi dii nga dèu do hewala, mi dꞌèi nga ngiꞌu dii miha. Rihi mengèlu dꞌara ke Deo, ne jꞌèga mi nahère, ngata hadꞌèita pedute lua petèka agama he we. Na ène, rihi woie ri ko noo, ngati bꞌada tunu menahu, nga wie bꞌara do wala pa Deo.” ");
INSERT INTO hvn_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Pedutu lii bꞌale guru agama na ène, pengee ri Yesus do tada woie ke noo. Ta lii ke Yesus pa noo, “Dae hudi ke èu ta jadꞌèi dèu Deo.” Èla pe na ène, bꞌule dꞌoke he dèu he, do bꞌani ta kebꞌali nengaa we pa Yesus, ri bꞌule dꞌoke dèu do mèka pa Noo. ");
INSERT INTO hvn_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Èla pe na ène, pe ko ma Yesus ta wie lii ajꞌa pa dèu do pa dꞌara Èmu Kepue Hebꞌajꞌa pa Deo. Ta kebꞌali ke Noo pa roo, mihe ane, “Mi namii pengee muu? Ne lua ajꞌa guru agama he, Kristus nee, Noo ke do pejꞌèuꞌe ri Deo rai uru he. Pedutu lii roo, Kristus ne kolo-loro duae Dau we. Na ène, adꞌo do petuu. ");
INSERT INTO hvn_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ri do uru, do pake Dau ri Hengaa Megala Deo ta bꞌuke, mihe ane: ‘Èla ke Deo pelii pa mone pereda pa yaa, mihe ane, “Mai we ma mejꞌèdꞌèipa era do rihi dꞌèia kebꞌue pa ai dꞌanga Yaa. Do ta tao ri Yaa hari-hari ihi muhu Èu, ta pewawa èni pa Èu.’ ” ");
INSERT INTO hvn_vpl VALUES ("MK12_37a","071_12_37a","MRK","12","37a","37a","Pelai ti mi nahère ke ne toi ri dii, ta duae Dau miha pale Kristus ta ‘mone pereda’ pa noo. Hèku, mi nahère ke kiri lii dèu ta Kristus ne kolo-loro Dau we, keteme dedꞌo! Rowi Noo miha do jadꞌèi ita mone pereda pa duae Dau.” ");
INSERT INTO hvn_vpl VALUES ("MK12_37b","071_12_37b","MRK","12","37b","37b","Ta pedai Yesus mi nahère, ae dèu do mengèlu dꞌara ne dꞌèno lii pedai Noo. ");
INSERT INTO hvn_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ta pika rike Noo pa roo, mihe ane, “Jaga-meniga ie muu pehedꞌapa nga guru agama he. Roo he do dꞌèi talèpa nga pake bꞌajꞌu do peraꞌu pa wurai, la telora dèu lowe, mijꞌe ta ngèdi roo ri dèu, jꞌe lii, ‘Mone kepai he ke jꞌe nahii!’ ");
INSERT INTO hvn_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Kiri maho roo la dꞌara èmu hebꞌajꞌa, la era lai tao, kale ri roo ne era mejèdꞌèido rihi woie, mijꞌe ta ngèdi ri dèu lowe he. ");
INSERT INTO hvn_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Jaga-meniga, oo! Roo he do rihi dꞌèi la peluu ne mobèni wue he, raba ne èmu-kemali roo harièle. Dꞌai iꞌa pewuni roo ne woapa hadꞌa roo, pa namada dèu lowe, nga hebꞌajꞌa titu do rihi tui. Ane roo mijꞌe ta lii dèu ke ta dèu do mèu ade-pengee. Do ta wie roo ri Deo ne ruwolo do rihi mejèni.” ");
INSERT INTO hvn_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Èla pe na ène, ta la mejèdꞌèike Yesus pehedꞌapa nga pèti bꞌara jꞌola pa Èmu Kepue Hebꞌajꞌa pa Deo. Heleo ri Noo ne dèu-dèu do dèka la pulu doi kolekte la dꞌara pèti bꞌara jꞌola. Ngèdi ri Noo ne do kaja he pulu doi rihi ae. ");
INSERT INTO hvn_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Dèka lema he dèu bèni bꞌalu do kehia, la hebꞌajꞌa. Pulu noo la dꞌara pèti nee, dꞌue doi wo naiki. ");
INSERT INTO hvn_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ta kewuꞌe ke ri Yesus ne ana ajꞌa Noo, jꞌe lii, mihe ane, “Heleo ko ri muu peꞌie ne bèni bꞌalu na nii. Ne pulu noo dꞌue doi we, tapulara rihi ae ke ne pulu noo ngati pulu harièle dèu. ");
INSERT INTO hvn_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ne dèu do hewala he harièle, pulu roo kolekte ti doi rihi pake. Tapulara bèni bꞌalu dꞌee, harièle ke ne doi noo ne wie pa Deo.” ");
INSERT INTO hvn_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Èla pe na ène, ta pekèdꞌèike Yesus nga ana ajꞌa Noo he ti Èmu Kepue Hebꞌajꞌa pa Deo. Ta dꞌai roo ne mèhu èni, ta lii ke he dèu ana ajꞌa Noo, mihe ane, “Ama, ee! Heleo ko ri Ama! Ne gaa-keleꞌe Èmu dꞌee. Dꞌai woie peraꞌa ne wowadu worena he!” ");
INSERT INTO hvn_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ta bꞌale ke ri Yesus, “Petuu! Dꞌai gaa tèra ma ne Èmu na dꞌee! Tui dꞌoke, jꞌe pekelole ne Èmu dꞌee, pemenyèla ne wowadu he.” ");
INSERT INTO hvn_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ta kako ke Yesus he la bꞌojo Saitun, jꞌe mejèdꞌèipa era do pehedꞌapa nga Èmu Kepue Hebꞌajꞌa pa Deo. Ta dèka ke do èpa dèu ana ajꞌa Noo la pedai nga Noo miha: Petu, Jꞌako, Johani, nga Anderia. ");
INSERT INTO hvn_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Ta kebꞌali ke roo, mihe ane, “Ama! Peteleo ri ko ri Ama ne lii pedai do ngine nee. Pèri ke ne jadꞌèi lai na ène? Jꞌe mi namii ne telia he?” ");
INSERT INTO hvn_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ta bꞌale ke ri Yesus pa roo, mihe ane, “Hadꞌèita jaga ie muu! Bꞌole luu muu. ");
INSERT INTO hvn_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ae hine ne dèu do ta dèka nga tèbꞌa kodo, jꞌe lii, mihe ane, ‘Yaa ke na dꞌee, Kristus, do jaje ri Deo rai uru he.’ Ae ne dèu do luu ri roo. ");
INSERT INTO hvn_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Kiri ngèdi muu dèu do pemuhu, ki rèngi lii pedꞌèii ta do era muhu pa mii-pa mii, bꞌole kebaꞌa ne pengee muu. Ne lai do mi nahère do ta jadꞌèi uru, tapulara dꞌai dedꞌo ne awe pedèka rai-wawa dꞌee. ");
INSERT INTO hvn_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Do ta pemuhu kejie dèu nga kejie dèu. Pemuhu hewue rai nga hewue rai. Era dꞌai ie pa mii-pa mii. Do ta era ne awe rihi menganga rai pa mii-pa mii. Harièle telia nahère, helaꞌu mi hedui mi mobèni do ta metana ana. ");
INSERT INTO hvn_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Hèku, jaga ie we muu! Do ta dèka roo ma kèpa muu, jꞌe nuni muu la hedꞌapa do hèpo kewèlu agama. Wuhu-dꞌaba muu ri dèu pa dꞌara èmu hebꞌajꞌa he. Ujꞌu ai muu, jꞌe ègu la hedꞌapa do pereda, pelai ti pedute Yaa. Awe tuu muu ta pedꞌèie jꞌara lua Yaa pa roo. ");
INSERT INTO hvn_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ne dèu unu Deo he ta la pika uru ko ne Lii Hagꞌa Dꞌara jꞌara lua Yaa pa hari-hari kejie dèu pa harièle kebꞌihu rai-wawa, jꞌeꞌitu dꞌai lalodꞌo pedèka rai-wawa. ");
INSERT INTO hvn_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Henge ie, oo! Kiri ujꞌu ne ai muu jꞌe peraꞌu la hedꞌapa dèu do hèpo kewèlu, bꞌole medaꞌu muu, jꞌe pengee, ‘Ta nengaa do ta pedai ri yaa pa nii?’ jꞌe, ‘Mi namii ke ne lii bꞌale yaa?’ Kiri dꞌai ne awe na ène, palii we muu pedutu nengaa do palii Hengaa Megala Deo pa muu pa awe na ène. ");
INSERT INTO hvn_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Pa dꞌara hewue èmu, kiri era dèu do parahajꞌa pa Yaa, tuèhu noo miha ta kale rujꞌara ta pemade noo. Kiri ana ne do parahajꞌa, ama noo miha do ta pemade noo. Kiri ina-ama noo do parahajꞌa pa Yaa, ana roo do ta pemade roo. ");
INSERT INTO hvn_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Hèku, dèu do ta bubu made nga muu, pelai ti parahajꞌa nga Yaa. Tapulara naduu do mèka wènge tade pedèka, do ta wie ne helama pa noo ri Deo.” ");
INSERT INTO hvn_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Ta pedai teruu rike Yesus, mihe ane, “Do ta dèka he dèu do rihi tao apa. Maho noo la titu pa era do mèu do megala pa dꞌara Èmu Kepue Hebꞌajꞌa pa Deo, dodꞌo jèma tuu noo pa ène, ta peraꞌe ne era na ène. Ri mi nahère ke, ta bꞌale kejꞌunga ke Deo nga era na ène. Kiri nga ngèdi ri muu ne lai do mi nahère, jaga ie muu! (Naduu do ajꞌe ne lii na dꞌee, jaga ie lema). Lai jadꞌèi do mi nahère he èhi rutada, ne lodꞌo apa-kerewe nee, pa kelae ke. Kiri ngèdi ne lai do mi nahère, dèu do pee pa propensi Yudea, kèdꞌèijꞌe perai la lede la bojꞌo. ");
INSERT INTO hvn_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Mèriai roo ne perai, mijꞌe ta dꞌo abu roo ihilaka. Ki era do mèhu èni ti dꞌara èmu, bꞌole bꞌale rii la èba bꞌara nengaa we. ");
INSERT INTO hvn_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Dèu do era pa dꞌoka, bꞌole bꞌale rii la èmu la èba hijꞌi. Perai teruu we! ");
INSERT INTO hvn_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ne do rihi hedui, mobèni do tèni ae, nga rena iki ana. Rowi laha dꞌo roo ne perai. ");
INSERT INTO hvn_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Rihi ie muu ta hebꞌajꞌa, mijꞌe dodꞌo jadꞌèi ne lai na ène pa awe èjꞌi liru. ");
INSERT INTO hvn_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ri ne awe na ène, dꞌai tèra ne hedui! Rai peꞌera ri Deo rai-wawa dꞌee, tade awe na dꞌee ngèdi dedꞌo dèu ta lake ne lai hedui-herui do mi nahère. Èla pe na ène, bꞌule dꞌo ke ne lai hedui-herui do mi nahère do ta lake wari ri dèu. ");
INSERT INTO hvn_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ki dꞌo peheꞌète ke ri Deo ne awe hedui do mi nahère, bꞌule dꞌoke he dèu he do nara ta muri mada. Tapulara, pelai ti rihi dꞌèi Deo nga dèu do èla pepili ri Noo he, ri mi nahère ke ku peheꞌète ri Noo ne lai hedui-herui na ène. ");
INSERT INTO hvn_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ki dꞌai la lodꞌo-lodꞌo do mi nahère, rèngi ri muu ne lii pedai dèu, mihe ane, ‘Heleo we! Kristus ne pa dꞌee!’ Lii hadꞌe, ‘Kristus nèi pa nii!’ Bꞌole dꞌèno muu! ");
INSERT INTO hvn_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Era dèu do dèka, nga tèba kodo, nga lii, ‘Yaa ke na dꞌee, Kristus!’ Era lema do lii, ‘Yaa ke na dꞌee, dèu ubꞌa ngati Deo.’ Ae ne madalae do ta tao ri roo pake kuaha wango ta peluu dèu. La hèku-hèku ri roo ta peluu ne dèu Deo. ");
INSERT INTO hvn_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Jaga-meniga ie muu! Uru nga dodꞌo dèka dae ne awe hedui-herui nee, èla ke muu pe pehewina uru ri Yaa.” ");
INSERT INTO hvn_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ta pedai teruu ke Yesus nga ana ajꞌa Noo, mihe ane, “Kiri moko ne awe hedui-herui nee, ‘Do ta kerèba ne mada lodꞌo, Weo dꞌoke wèru. ");
INSERT INTO hvn_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Moto he keloro ti liru-bèla, nga harièle kuaha do era pa liru-bèla, kenyawu-nyela.’ ");
INSERT INTO hvn_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Èla pe mi nahère, jꞌeꞌitu ngède ri dèu, ta Yaa dꞌee, Dèu Rai-wawa do Petuu-Petuu. Do ta puru Yaa pa dꞌara merèmu ti liru-bèla. Do ta ngède ri harièle dèu ne kuaha nga mèu-megala Yaa! ");
INSERT INTO hvn_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Do ta pereda ri Yaa pa dèu pejuu Deo pa liru-bèla, ta la pekupu harièle dèu do èla pepili ri Yaa, ti èpa kebꞌihu rai-wawa.” ");
INSERT INTO hvn_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Ta pedai teruu ke Yesus, mihe ane, “Èbe ri Yaa ne lii pehèku pa ajꞌu do muri. Kiri lara ke ne rèu, rutada hedèka ke wèru wadu. ");
INSERT INTO hvn_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Mi nahère lema, kiri ngèdi ke ri muu ne lodꞌo hedui-herui do dèka nee, mii do èla pepika ri Yaa pa muu ngine, rutada ta ne awe dèka Yaa umu ke. ");
INSERT INTO hvn_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Dꞌèno pe woie! Ti harièle dèu do muri mada pa awe na dꞌee, era ko dodꞌo made, pa awe dèka ne lodꞌo hedui-herui ène. ");
INSERT INTO hvn_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Maji liru-bèla nga rai-wawa ta ele ta mèra, tapulara lii pedai Yaa na dꞌee, peloro hape la lodꞌo namii-mii.” ");
INSERT INTO hvn_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Ta pedai rike Yesus, mihe ane, “Bꞌule dꞌo he dèu he do toi ne lodꞌo nga jaa dèka wari Yaa. Dèu-dèu pejuu Deo pa liru-bèla lema, toi dꞌo. Ri Yaa le miha, toi dꞌo. Tituwata Ama Yaa we, ne do toi. ");
INSERT INTO hvn_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ri mi nahère ke, jaga ie muu, ri dodꞌo toi ri muu pèri ne awe dèka Yaa. ");
INSERT INTO hvn_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Tui dꞌo ke ne awe, jꞌe lènga Yaa ti telora muu, do ta dèka ri ma Yaa wari. Mii dèu do lènga ti èmu, la rai do jꞌèu. Pereda ri noo pa dèu pee nga noo, lita pemoke peꞌie ne èmu-kemali noo. Pebꞌage roo ne jꞌèga he dèu-he dèu. Tèka lii noo pa mone jaga toka, ta jaga-meniga peꞌie, tade bꞌale noo. ");
INSERT INTO hvn_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Jaga muu nimèdꞌa-nilodꞌo, ri dodꞌo toi ri muu pèri ne awe dèka do muri èmu nee. Bꞌale mèdꞌa lodꞌo we, telora mèdꞌa we, nilodꞌo we, awe hèu lodꞌo we, toi dꞌo ri muu ta pèri ne awe. ");
INSERT INTO hvn_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ngita dèka noo nga hewèka, jꞌe abu muu nga bꞌèjꞌi pegoo-koko. ");
INSERT INTO hvn_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Hèku, mi namii ne lii pedai Yaa pa muu, do ta pedai lema Yaa nga dèu do hewala he, lii ta, ‘Jaga peꞌie muu, ta mate ne lodꞌo dèka Yaa.’ ” (Mi nahère we, ne lii pedai Yesus nga ana ajꞌa Noo pa bꞌojo Saitun.) ");
INSERT INTO hvn_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","2","Èla pe mi nahère, ne mone ketèu pa kètu agama Jahudi he pee nga kale pengee ta kèpe menaꞌo Yesus. Ne dꞌèi roo ta pemade ke Noo. Tapulara pelii roo, mihe ane, “Taha ko! Bꞌole mèriai dii ne kèpe Noo, ri lodꞌo ngaꞌa-kewèhu he dèka ke. Ngita kèdꞌèilila ne dèu lowe he, ta pehala nga dii.” Ne pedai roo mi nahère ri dae dꞌue lodꞌo ke, ne lodꞌo ngaꞌa-kewèhu unu do Jahudi, do tima ta pale ta ‘Lodꞌo Paska’ nga ‘Lai Tao Ngaꞌa Roti Dodꞌo Pake Ragi’. Pa dꞌara lodꞌo ngaꞌa-kewèhu na ène, pehenge awe do uru he, ama-èpu roo mèhu èni ti ihi rai Masir. ");
INSERT INTO hvn_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Pa rae Betania, era he dèu ne ngara Himo, do ie ti pèda kusta. Awe do na ène, dꞌai dedꞌo la lodꞌo ngaꞌa-kewèhu, Yesus he kako la ngaꞌa pa èmu Himo. Pa dꞌara ngaꞌa roo, dèka ke he dèu mobèni la pehapo nga Yesus. Dèka noo nga pèru hewue wobꞌuri do tao ti wowadu. Ne ihi noo, èi loko wumèngi do rihi maha kebꞌue. Ta pèko ke ri noo ne lakoko wobꞌuri nee. Jꞌe pehute ne èi wumèngi ne ri noo la wukolo Yesus, rutada pekebꞌue ri noo Yesus. ");
INSERT INTO hvn_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Era lema pa ène do pèri dèu do ngaꞌa helaꞌu nga roo. Ta ngède ne jꞌèga mobèni na ène, kura pa dꞌara ke roo, jꞌe pedai lii roo, mihe ane, “Hmm! Mobèni do mi namii mèra, pehore ele èi loko wumèngi do rihi maha na nii! ");
INSERT INTO hvn_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Rihi ie ta pewie we ne èi wumèngi dꞌee, jꞌe pepale ne doi do ae ne pa dèu do kehia-gahara! Rowi ne kebꞌue èi wumèngi dꞌee, helaꞌu nga gaji he dèu pa dꞌara hewue tèu.” ");
INSERT INTO hvn_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ta lii ke Yesus pa roo, “Bꞌole pehedue ri muu mobèni na dꞌee! Hane we noo. Mengèlu dꞌara Yaa ne tao noo, ri èla ke ri noo pe pehute ne èi wumèngi dꞌee pa ngiꞌu Yaa. ");
INSERT INTO hvn_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Do kehia he, do era loro helaꞌu nga muu. Hèku, nara muu ta pedꞌelo ruba dꞌara nga roo helodꞌo-helodꞌo. Tapulara Yaa, tui dꞌoke ne era helaꞌu nga muu. ");
INSERT INTO hvn_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Umu ke Yaa ta made. Èi wumèngi do pehute ri mobèni na dꞌee pa ngiꞌu Yaa, helaꞌu le ke ta lua pemoke Yaa dꞌai ne made, mii pemoko rape ta lebe pa ngiꞌu Yaa. ");
INSERT INTO hvn_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Henge peꞌie, oo! Pa mii we ne Lii Hagꞌa Dꞌara Deo ne pepeke pa hari hewue rai-wawa dꞌee, do ta pedae lema ne woie mobèni na dꞌee. Mijꞌi ta toi ri harièle dèu.” ");
INSERT INTO hvn_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Èla pe na ène, era he dèu ti do henguru do dꞌue ana ajꞌa Yesus, ne ngara Juda Iskariot. Ta mèhu èni ke noo la kale ne mone ketèu pa kètu agama Jahudi he, mijꞌe ta la wie Yesus pa roo. Ta dꞌai noo nga roo, ta pika ke ne lua dèka noo. ");
INSERT INTO hvn_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Rihi mengèlu dꞌara roo, ta rènge ri roo ne lii pedai Juda. Ta pejaji ke roo, “Ki kewie ri èu Yesus pa jꞌii, ta maꞌe ma ri jꞌii pa èu.” Ta mèhu èni ke Juda, jꞌe kale uku mi namii ne jꞌole Yesus pa roo. ");
INSERT INTO hvn_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ne lodꞌo na ène, lèka pa lodꞌo petari ti lodꞌo ngaꞌa-kewèhu unu do Jahudi. Hèku, pa lodꞌo na ène, patima roo ta wobꞌo roti dodꞌo pake ragi, nga tèbꞌu kiꞌi-jꞌawa. Ta dèka ke ana ajꞌa Noo he la kebꞌali pa Yesus, mihe ane, “Ama. Lodꞌo dꞌee, lodꞌo ngaꞌa-kewèhu Paska. Hèku, ne dꞌèi Ama, pa mii ke jꞌii ne era pemoko ta ngaꞌa-kewèhu Paska tuu dii?” ");
INSERT INTO hvn_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ta pejuu ke ri Yesus do dꞌue ana ajꞌa Noo, mihe ane, “Uru ko muu la dꞌara kota. Pa nii, ta pehapo muu nga he dèu momone do nga hape èi pa dꞌara guhi wo naiki. Pedute we noo ri muu. ");
INSERT INTO hvn_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","La èmu na mii noo ne maho, pedute ri muu. Pika muu pa muri èmu nee, mi nahee: ‘Ama! Ama Guru unu jꞌii ta ami era pa Ama, ta pake ta ngaꞌa-kewèhu Paska nga ana ajꞌa Noo he.’ ");
INSERT INTO hvn_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Do ta peke ri noo hewue kama do bèla pa dꞌèia ène. Do èla ke pe pemoke ri noo ne kama ène. Hèku muu dꞌue la pemoko ngaꞌa we!” ");
INSERT INTO hvn_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ta pekèdꞌèike roo dꞌue la dꞌara kota. Pa nii, ta pehapo ke roo nga harièle lai do pedai Yesus. Ta la pemoko ke ri roo harièle, mijꞌe ta nara Yesus ta ngaꞌa-kewèhu Paska pa ène. Ta la pedoa ke ri roo Yesus he. ");
INSERT INTO hvn_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ta jèna lodꞌo, ta maho ke Yesus nga do henguru do dꞌue ana ajꞌa Noo la nii. ");
INSERT INTO hvn_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Mejèdꞌèiroo ta ngaꞌa helaꞌu-laꞌu. Pa dꞌara ngaꞌa roo, ta lii ke Yesus, “Dꞌèno ri muu, ee! He dèu ti telora muu do ta la pewie Yaa pa dèu do hewala.” ");
INSERT INTO hvn_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ta rènge ne lii na ène, ta hedui pengee ke roo. He dèu-he dèu roo ne kebꞌali pa Yesus, mihe ane, “Mage ta yaa, ne dèu do ane Ama nee?” ");
INSERT INTO hvn_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Bꞌale ri Yesus, “Dèu do pehèbꞌu roti la dꞌara mago helaꞌu nga Yaa, noo ke, ne do ta pewie Yaa. ");
INSERT INTO hvn_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Henge, ee! Yaa dꞌee, Dèu Rai-wawa do Petuu-Petuu, do ta made tèra pedutu do hure dꞌo bꞌuke. Jaga! Ne dèu do pewie Yaa dꞌee, do ta hape ri noo ne hoe ihilaka! Rihi ie noo ta bꞌole metana ri ina noo!” ");
INSERT INTO hvn_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Pa dꞌara ngaꞌa roo, ta dꞌede ke ri Yesus ne hewue roti, jꞌe pehaꞌe lii ie ae pa Deo. Jꞌe pipe ri Noo pemae ne roti nee, jꞌe jꞌole pa ana ajꞌa Noo he. Ta lii ke Noo, “Ne roti na dꞌee, ngiꞌu Yaa ke. Hème we, jꞌe ngaꞌe.” ");
INSERT INTO hvn_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Èla pe na ène, ta èbe ke ri Noo ne galaa do ihe ri èi ago. Pehaꞌe lema Noo lii ie ae pa Deo. Ta jꞌole ri Noo ne galaa ne pa ana ajꞌa he, ta nginu. ");
INSERT INTO hvn_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ta lii ke Noo, “Èi ago na dꞌee, raa Yaa ke. Raa do dꞌute ta wie helama pa dèu do ae. Raa na dꞌee, jadꞌèi hakahii ta do tobo ke ne lii jaji Deo. Hème we, jꞌe ngino. ");
INSERT INTO hvn_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Dꞌèno peꞌie ko ri muu! Jꞌari mèdꞌa dꞌee, adꞌo ke Yaa do ta nginu wari èi ago. Hape la awe Ama Yaa mejèdꞌèita pereda pa liru-bèla, jꞌeꞌitu ngino wari Yaa.” ");
INSERT INTO hvn_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Èla pe mi nahère, ta jꞌuka ke roo hewue lii lodꞌo ta pekelode ngara Deo. Ta mèhu èni ke roo mèdꞌa na ène la bꞌojo Saitun. ");
INSERT INTO hvn_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Pa dꞌara nga nèru roo, ta lii ke Yesus, mihe ane, “Mèdꞌa nèbꞌo, harièle muu do ta perai jꞌe hane Yaa. Ri do era ke do hure dꞌo bꞌuke, mihe ane, ‘Do ta pemade ri Deo ne mone bꞌata nee, ne kiꞌi-jꞌawa noo menyèla kebali-bali.’ ");
INSERT INTO hvn_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Tèra do ta made Yaa. Tapulara do ta muri wari Yaa. Ki muri wari Yaa, do ta uru Yaa nga muu la propensi Galilea.” ");
INSERT INTO hvn_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ta pelawa ke Petu, mihe ane, “Ama! Maji le harièle dèu ta perai, jꞌe hane Ama, tapulara adꞌo yaa!” ");
INSERT INTO hvn_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ta bꞌale ke ri Yesus pa noo, “Petu! Henge ie, ee! Mèdꞌa dꞌe dꞌènge, uru nga dꞌo dꞌue awe manu ne tutuꞌoo, tèlu wari ke èu ne pehile Yaa.” ");
INSERT INTO hvn_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ta perui èni ke Petu, jꞌe lii noo, mihe ane, “Adꞌo, Ama, ee! Ki made Ama, ta made helaꞌu ke yaa, nga Ama. Perai dꞌoke yaa ti nga Ama, nga pehile dꞌo Ama ri yaa.” Ihianga Petu he dèu-he dèu palii mi nahère lema. ");
INSERT INTO hvn_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Èla pe na ène, ta kako teruu ke Yesus he tade dꞌai la hewue dꞌoka pa bꞌojo Saitun, ne ngara ‘Getsemani’. Ta lii ke Yesus pa roo, mihe ane, “Mejèdꞌèiko muu ta mate Yaa pa dꞌee. Ta la hebꞌajꞌa pa nii ko Yaa.” ");
INSERT INTO hvn_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ta pedoa ke, ta penau helaꞌu nga Noo, Petu, Jꞌako, nga Johani. Jꞌari ti awe na ène, noho ne ade-pengee Noo ketèna dꞌoke. ");
INSERT INTO hvn_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ta pedai ke Noo, mihe ane, “Dꞌai hedui ne ade Yaa. Mii do ta hèpo hengaa ke. Mejèdꞌèike muu ta jaga pa dꞌee.” ");
INSERT INTO hvn_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","Ta nèru ke Noo hudi, jꞌe lèku rutuu Noo pa wurai, jꞌe hebꞌajꞌa, mihe ane, “Ama tana! Ki do mèdꞌèihe pa dꞌara Ama, bꞌole made Yaa nga hape lua hedui-herui do mi nahee. Toi tèra ri Yaa, hari-hari lai do nara ta tao ri Ama. Kiri mèdꞌèihe pa dꞌara Ama hore we pejꞌèu, ne hedui-herui na dꞌee ti Yaa. Bꞌole jadꞌèi pedutu nga do dꞌèi Yaa, jadꞌèi we pedutu nga lua dꞌèi Ama.” ");
INSERT INTO hvn_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ta èla pe hebꞌajꞌa, ta bꞌale ke Noo nga do tèlu dèu ana ajꞌa Noo he, tapulara era do bꞌèjꞌi luu. Ta perei ke ri Noo, jꞌe lii Noo pa Petu, mihe ane, “He, Petu! Do luu ta bèjꞌi èu? He melila he we Yaa pa nii, taha le dꞌo ma hudi he muu ta jaga helaꞌu nga Yaa! ");
INSERT INTO hvn_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Lure ko peweo ne namada èu. Kèdꞌèi jꞌe jaga helaꞌu nga Yaa! Dꞌèi tèra ne ade muu ta jꞌège lai do ie, tapulara rui dꞌo ne ngiꞌu muu. Rihi ie muu ta hebꞌajꞌa, ngita jꞌera dꞌo muu, ki lèka ri ruhèku.” ");
INSERT INTO hvn_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ta bꞌale rike Yesus la hebꞌajꞌa. Ta ami wari ke Noo pa Deo, ta bꞌole hane Noo pehape hedui-herui na ène. ");
INSERT INTO hvn_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ta bꞌale rike Noo nga ana ajꞌa Noo do tèlu dèu he. Era ke roo do luu ta bèjꞌi wari, ri rihi ke roo ne mengètu namada. Ta perei ke ri Noo, iꞌa dꞌoke roo ne bꞌale lii Yesus. ");
INSERT INTO hvn_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ta hani ke roo ri Yesus, jꞌe bꞌale la hebꞌajꞌa ketèlu wari. Èla pe hebꞌajꞌa, ta bꞌale ke Noo la perei ne ana ajꞌa Noo. Ane Noo, “He do bèjꞌi ko ma muu! Pengaha we ne bꞌèjꞌi. Kèdꞌèi Ne dèu do ta pewie Yaa, Dèu Rai-wawa do Petuu-petuu, hère ke. Awe na dꞌee, ta ma kèpe ke Yaa ri roo, jꞌe la jꞌole pa dèu do tao apa he. ");
INSERT INTO hvn_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Kèdꞌèiwe! Heleo muu la nii! Na hii ke ne dèu do ta pewie Yaa. Mai we dii la pehapo nga roo.” ");
INSERT INTO hvn_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Pa dꞌara pedai lii Yesus, hèra dꞌènge Juda nga dèu do rihi ae. Dèka roo nga pèru wela nga tubu, ta la kèpe Yesus. Dèka roo nga mi nahère, pedutu lii pereda mone ketèu pa kètu agama Jahudi he, guru agama he, nga dokepai-dokepai rae he. ");
INSERT INTO hvn_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Do pika uru ke Jꞌuda pa roo, mihe ane, “Heleo peꞌie ri muu! Naduu do hengèdꞌo ri yaa, kèpe ri muu! Noo ke ne dèu do kale ri muu.” ");
INSERT INTO hvn_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ta dꞌai Juda la ène, mola noo nga Yesus, pelango ri noo, “Ama Guru!” Kedꞌake ri noo, jꞌe hengèdꞌo. ");
INSERT INTO hvn_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ta dèka ke ne dèu do ae he la kèpe Yesus. ");
INSERT INTO hvn_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","He dèu ti dèu Yesus he ta rèda wela ke, jꞌe pare pehèpo ne wodilu he dèu. Ne dèu na ène, ènu ri kètu mone ae agama Jahudi. ");
INSERT INTO hvn_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ta pedai ke Yesus nga dèu do la kèpe Noo he, mihe ane, “Mi namii? Pengee ri muu, Yaa ne mone bꞌani? Ku dèka muu ma kèpe Yaa nga wela nga tubu? ");
INSERT INTO hvn_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Helodꞌo-helodꞌo era ma Yaa nga muu pa Èmu Kepue Hebꞌajꞌa pa Deo, bꞌule dꞌo he dèu he do dèka la kèpe Yaa. Mai we, ma kèpe Yaa. Na dꞌee, do lore do hure dꞌo bꞌuke ke.” ");
INSERT INTO hvn_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Made ri medaꞌu ne ana ajꞌa Noo he. Ta hane ke Yesus, jꞌe perai roo. ");
INSERT INTO hvn_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Pa ène lema, era he dèu ana do ngèru, do pedute Yesus ti kejꞌunga. Era nga robo hijꞌi noo. Ta kèpe ke noo ri dèu he, ");
INSERT INTO hvn_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","tapulara abo pa hijꞌi noo we. Pelai ti rihi medaꞌu, ta perai ke noo nga ihi wue, bꞌule dꞌo nga bꞌara pa ihi. ");
INSERT INTO hvn_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Èla pe na ène, ta èbe ke Yesus ri roo la èmu Kètu Mone Ae Agama Jahudi. Pa ène, era ke do peteni ne dokepai-dokepai he. Harièle mone ketèu pa kètu agama he, guru agama he, nga dokepai-dokepai rae. ");
INSERT INTO hvn_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ta dꞌai ne èbe ri roo Yesus, Petu lema do pedutu menaꞌo ti kejꞌunga, tade dꞌai la èmu Kètu Mone Ae Agama Jahudi. Maho noo hape la dꞌara rae nee, la mejèdꞌèihelaꞌu nga dèu do jaga do menyiru ai pa ène. ");
INSERT INTO hvn_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Pa dꞌara èmu dꞌee, mone ketèu pa kètu agama he pedai lii nga dèu do majèdꞌèita hèpo kewèlu agama he. Harièle roo kale hakahii ta pehale Yesus, ri dꞌèi ke roo ta wole pemade Noo. Tapulara nara dꞌo lai nengaa ta mii hakahii. ");
INSERT INTO hvn_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ta pedoa ke ri roo ne dèu do ae, ta hakahii ta pebue Yesus. Tapulara ne lii lolo roo peꞌabu dꞌo he dèu nga he dèu. ");
INSERT INTO hvn_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Era hadꞌe ne hakahii do kèdꞌèita titu ta pedꞌèii pote, mihe ane, ");
INSERT INTO hvn_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Rèngi ri jꞌii ne lii pedai dèu na dꞌee, mihe ane, ‘Do ta pekelole ri Yaa ne Èmu Kepue Hebꞌajꞌa pa Deo do jꞌège ri ruai dèu rai-wawa. Èla pe tèlu lodꞌo, do ta pekèdꞌe wari ri Yaa ne Èmu na ène, nga dodꞌo pake ruai dèu rai-wawa.’ ” ");
INSERT INTO hvn_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Tapulara peꞌabu dꞌo ne lii lolo roo he dèu nga he dèu. ");
INSERT INTO hvn_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ta titu ke Kètu Mone Ae Agama Jahudi nee, pa hedꞌapa harièle dèu do mejèdꞌèipa ène. Jꞌe kebꞌali pa Yesus, mihe ane, “Ae ke dèu do kelaa pehedꞌapa nga Èu. Ta ngaa Èu ku pehèngo èni we?” ");
INSERT INTO hvn_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Bꞌale dꞌo ri Yesus he ubꞌa he. Ta kebꞌali rike ne Kètu Mone Ae Agama Jahudi pa Noo, mihe ane, “Hèku ko Èu ta pika mola! Èu tèra ke na dꞌee Kristus, Ana Deo do jaje rai uru ne?” ");
INSERT INTO hvn_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ta bꞌale ke ri Yesus, “Do petuu! Yaa ke na dꞌee. Do ta ngède ri muu harièle ta Yaa, Dèu Rai-wawa do Petuu-Petuu, do mejèdꞌèipa liru-bèla pa kedꞌanga Deo. Rihi mone ae ne kuaha Noo! Do ta pèru pereda Yaa helaꞌu nga Noo. Èla pe na ène, do ta puru Yaa ti liru-bèla nga merèmu.” ");
INSERT INTO hvn_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ta rènge ne lii bꞌale Yesus do mi nahère, made ri bubu dꞌara ne Kètu Mone Ae Agama Jahudi ène, tade hio ke ri noo ne bꞌajꞌu do womerai do pake ri noo. Ta pekaa ke noo pika pa dèu lowe do mejèdꞌèipa ène, mihe ane, “Teo dꞌoke dii ta pake hakahii wari! ");
INSERT INTO hvn_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Rèngi ke ri wodilu muu miha, Noo ma do pika wari èni mi nahère. Èla ke Noo pepai èni ta Ana ri Deo. Lii Noo dꞌee, ta peꞌape ngara Deo! Pedutu petèka agama dii, ki era dèu do pale wari èni ta helaꞌu nga Deo, dèu na ène ta pemade! Ku, mi namii ne lai hèpo muu?” Hèpo ri roo hari-hari, “Hala tèra ke dèu na dꞌee! Hèku, ta wole made!” ");
INSERT INTO hvn_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Èla pe mi nahère, ta kèdꞌèike do pèri dèu la hebue Yesus ri ilu. Wute ne namada Noo, jꞌe merèho. Jꞌe lii roo, mihe ane, “Kiri Èu tèra ke mone ubꞌa Deo, hèku ko Èu ta pale ne ngara dèu do kudꞌe Èu!” Ta pereda ke roo pa dèu do jaga Èmu Kepue Hebꞌajꞌa pa Deo, ta ma èbe Yesus. Ta èbe ke ri roo, jꞌe tèbꞌe bꞌale-bꞌale. ");
INSERT INTO hvn_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","67","Pa awe do na ène, Petu do mejèdꞌèita menyiru ai pa dꞌara rae ène. Ta dèka ke he dèu mobèni, ènu ri Kètu Mone Ae Agama Jahudi, ngède noo ta menyiru ai. Pehodꞌe ri mobèni na ène, ne worèwu Petu, jꞌe kabꞌali noo, “Ngine dꞌee, èu era helaꞌu-laꞌu nga Yesus, do Nasare ène, we adꞌo?” ");
INSERT INTO hvn_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ta bꞌale ke ri Petu, “Adꞌo! Ta ngaa èu ku lii mi nahère! Tade dꞌo Noo ri yaa.” Èla pe na ène, ta kako ke Petu la titu pa toka rae nee. Pa dꞌara awe na ène, ta tutuꞌoo ke ne manu. ");
INSERT INTO hvn_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ta ngède rike Petu ri mobèni na ène. Ta pika ke noo pa harièle dèu do era pa ène, mihe ane, “Noo ke he dèu ti kejie Yesus!” ");
INSERT INTO hvn_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ta pehihi èni ke Petu, jꞌe lii, mihe ane, “Adꞌo èu ta wujꞌu! Tade dꞌo ri yaa dèu na nii!” Tui dꞌo, era ri he dèu do hewala pa ène, lii la Petu, mihe ane, “Bꞌole pote èu ta adꞌo do helaꞌu nga dèu na nii! Muu he, do Galilea, to?” ");
INSERT INTO hvn_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ta pelawa rike Petu, mihe ane, “Bꞌani yaa ta hupa! Tade dꞌo ri yaa dèu na nii!” ");
INSERT INTO hvn_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Tatuu ne lii pedai noo, ta tutuꞌoo ke ne manu ta dꞌue awe. Ta henge ke ri Petu ne lii pedai Yesus ngine, mihe ane, “Uru nga dꞌo dꞌue awe manu ne tutuꞌoo, tèlu wari ke èu ne pehile Yaa.” Dꞌai ne henge ri noo ne lai na ène, ta tangi oga-oga ke Petu. ");
INSERT INTO hvn_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Rai jꞌami ae, harièle roo do era pa era hèpo kewèlu helaꞌu lii ta pemade Yesus. Ta ujꞌe ke ne ai Noo, jꞌe èbe la nga Gubernur Pilatus. ");
INSERT INTO hvn_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ta dꞌai nga gubernur, ta kebꞌali ke pa Yesus, mihe ane, “Mi namii? Petuu tèra ke Èu ta duae do Jahudi?” Ta bꞌale ke ri Yesus, “Tèra. Petuu ke ne lii pali Ama Gubernur.” ");
INSERT INTO hvn_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ta pedae ke ri mone ketèu pa kètu agama he nga gubernur, mihe ane, “Adꞌo ke ta hudi we ne hala dèu na dꞌee!” Ta nèjꞌi ke ri roo harièle ne hala Yesus. ");
INSERT INTO hvn_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ta kebꞌali wari ke gubernur pa Yesus, mihe ane, “Rènge dꞌo ri Èu ne lii pedai roo? Ae ke ne hala Èu, ne pika roo. Bꞌale ko ri Èu ta!” ");
INSERT INTO hvn_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Bꞌale dꞌo ri Yesus he ubꞌa he, tade madalae gubernur. ");
INSERT INTO hvn_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Pa tima hewue tèu-hewue tèu, pa lodꞌo ngaꞌa-kewèhu Paska Jahudi, dèu lowe ami pa gubernur ta gole he dèu ti dꞌara èmu bꞌèdo, pedutu lii ami roo. ");
INSERT INTO hvn_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Pa awe do na ène, era he dèu do bꞌèdo, ne ngara Barabas. Ne kèpe noo do uru he, pelai ta pelawa nga do pereda Roma, nga pemade dèu. ");
INSERT INTO hvn_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ri umu ke ne lodꞌo ngaꞌa-kewèhu Paska, ku ae ke ne dèu do kako nga gubernur, la pekaa, ane roo, “Ama gubernor! Dꞌai ke pa lodꞌo kewèhu Paska. Ki ie he, gole wie jꞌii he dèu ti dꞌara bꞌèdo, pedutu tima.” ");
INSERT INTO hvn_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ta kebꞌali ke gubernur, “Naduu ke do ta gole ri yaa? Mi namii ki gole ri yaa ne duae do Jahudi dꞌee? Hèmi muu, we adꞌo?” ");
INSERT INTO hvn_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pedai gubernur mi nahère, ne petuu he, do toi tèra ke ri noo, ta mone ketèu pa kètu agama he ne èbe Yesus nga noo, pelai ti rihi bubu dꞌara nga Yesus. ");
INSERT INTO hvn_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ri mone ketèu pa kètu agama he, ubu made ne dèu lowe he, lii ta ami pa gubernur, mihe ane, “Wae dꞌo jꞌii nga Noo! Gole we Barabas!” ");
INSERT INTO hvn_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ta kebꞌali rike gubernur, mihe ane, “Ki mi nahère, ta tao mi namii ke ri yaa pa Yesus, do pale ta ‘duae do Jahudi’ na dꞌee?” ");
INSERT INTO hvn_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ta pekaa ke roo hari-hari, mihe ane, “Pemade we Noo! Raje Noo pa ajꞌu ketoe!” ");
INSERT INTO hvn_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ta kebꞌali ke gubernur, “Nengaa ke ne hala Noo? Pereha ri yaa, bꞌule dꞌo Noo nga hala!” Juu mèdu ne lii pekaa roo, “Pemade we Noo! Raje Noo pa ajꞌu ketoe!” ");
INSERT INTO hvn_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Mijꞌi mengèlu dꞌara dèu lowe, ta gole ke Barabas ri gubernur, pedutu lai dꞌèi roo. Ta pereda ke ri noo pa dèu jaga he, ta la wèbe Yesus ri gui. Ta èla pewèbe, ta èbe ke Yesus ri horodꞌadꞌu, ta la raje mijꞌe ta made pa ajꞌu ketoe. ");
INSERT INTO hvn_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Pa awe do na ène, ta nune ke Yesus ri horodꞌadꞌu he la kebꞌèla kato roo. Ta pedoa ke ne ihianga roo he batalion. ");
INSERT INTO hvn_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ta pepake ke ri roo Yesus hewue bꞌajꞌu merai do wo kelere mea, do tima ta pake ri duae he. Jꞌe ènyo ri roo ne tèdꞌu ngati kelai ajꞌu do dudu. Petèdꞌo, jꞌe ènye pebꞌère pa kètu Yesus. Ne tao roo mi nahère, ta mare-dꞌole Yesus, ta mii dꞌede he dèu duae do wiu, pepake tèdꞌu duae. ");
INSERT INTO hvn_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ta mare-dꞌole rike Yesus ri roo, ta petabꞌe nga Noo, mihe ane, “Helama pereda, Muri Mone, duae Jahudi!” ");
INSERT INTO hvn_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Hengaja roo ta peruꞌu èni pa hedꞌapa Yesus. Jꞌe hebue-hebue ri ilu roo pa tanga mada Yesus. Jꞌe wuhe dꞌabe ri ajꞌu pa kètu Yesus ri roo. ");
INSERT INTO hvn_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ta bꞌenya roo ne tao pa Noo, ta boke ke ne bꞌajꞌu do womerai nee. Jꞌe pepake wari ri roo ne bꞌara pake Noo. Ta èbe ke Noo ri roo la tele kota Yerusalem, mijꞌe ta la raje ketoe Noo tade made. ");
INSERT INTO hvn_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Pa telora rujꞌara ti Yerusalem, pehapo roo nga he dèu do dèka ngati kota Kirene. Ne ngara noo, Himo, ama ri Aleksander nga Rufus. Ta maho kowe noo la kota Yerusalem, moko ta kèpe ri horodꞌadꞌu he, jꞌe pehèhe noo ta pehape ne ajꞌu ketoe Yesus. ");
INSERT INTO hvn_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ta nune-hèpe ke ri roo Yesus, tade dꞌai la hewue era, ne ngara Golgota, ne helaꞌu mi ‘era rui kètu’. ");
INSERT INTO hvn_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Pa nii, do ta pengino ri roo nèbꞌo èi ago do menyilu do pehiwe ri ruajꞌu, mijꞌe ta dꞌo rihi noho pèda. Tapulara wae dꞌo Yesus ta ngino. ");
INSERT INTO hvn_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","25","Ta èla pe mi nahère, ta raje ke Yesus pebꞌarèpa pa ajꞌu ketoe ri roo. Jꞌe petito ri roo ne ajꞌu ketoe nee, era wèba heo jꞌami ae he. Ta pepili ode ke ne horodꞌadꞌu he, mijꞌe ta toi ta nara naduu ne bꞌara pake Yesus. ");
INSERT INTO hvn_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ta bꞌuke ke roo pa bèla papa, jꞌe raje pa huu ajꞌu ketoe, pemira wukolo Yesus, mihe ane: “Na dꞌee ke, Duae do Jahudi” Na ène ke ne kepue hala ta wole Yesus. ");
INSERT INTO hvn_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Pa ène lema, ketoe pemade ri roo do dꞌue mone tao kenyaꞌu nga apa-kerewe. He dèu pa hebꞌèka kedꞌanga, nga he dèu pa hebꞌèka keriu Yesus. ");
INSERT INTO hvn_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Nahère, do lore do hure do bꞌuke ke, “Ne tao roo pa Noo, mii pa dèu do tao apa-kerewe.” ");
INSERT INTO hvn_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Harièle dèu do lake jꞌara ène, ngède Yesus do ketoe. Ta piku-piku kètu ke roo, jꞌe mare pemekae dꞌara Noo ri roo, mihe ane, “Eeh! Adꞌo Èu ke do lii, ta bꞌage pemenyèle ri Èu Èmu Kepue Hebꞌajꞌa pa Deo, jꞌe pekèdꞌe wari pa dꞌara tèlu lodꞌo, we adꞌo? ");
INSERT INTO hvn_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Hèku ko Èu ta puru ti kolo ajꞌu ketoe nee, mijꞌe bèla kètu Èu. Ki mi nahère, jꞌeꞌitu parahajꞌa jꞌii ta Èu tèra ke ne Ana Deo.” ");
INSERT INTO hvn_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Mi nahère lema, ne mone ketèu pa kètu agama he nga guru agama he, ne mare-dꞌole Yesus, mihe ane, “Pehelama ri Noo dèu do hewala, tapulara nara dꞌo ta pehelama ne ngiꞌu Noo miha! ");
INSERT INTO hvn_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Do pika wari èni Noo, ta Noo ke ne ‘Kristus’, dèu do jaje ri Deo rai uru. Lii dèu do hewala, Noo ne Duae do Israꞌel. Ki do petuu ke mi nahère, hèku ko Noo ta puru ti ajꞌu ketoe dꞌee, mijꞌe ngède ri dii. Ki mi nahère, parahajꞌa ke dii nga Noo.” Hari do dꞌue dèu do ketoe helaꞌu nga Yesus he, pedutu lema ta mare-dꞌole Noo. ");
INSERT INTO hvn_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Pa awe do na ène, ta kerèba guru rai ke ne era na ène, rai nètu lodꞌo tade wèba tèlu mako lodꞌo. ");
INSERT INTO hvn_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Pa dꞌara wèba tèlu, ta pekaa ke Yesus pa dꞌara lii Aram, mihe ane, “Eloi! Eloi! Lama sabaktani?” (Ki pebꞌale pa dꞌara lii rai dii, “Wo Muri Yaa! Deo Yaa! Ta ngaa ke Ama ku naja kejꞌunga, jꞌe hane Yaa mi nahee?”) ");
INSERT INTO hvn_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Era do pèri dèu do umu pa ène, do rènge ne lii pekaa Yesus. Ta lii ke roo, “Weh! Dꞌèno ko ri muu. Nèi ke ri Noo ta pedoe Elia, mone ubꞌa ngati Deo do uru ne!” ");
INSERT INTO hvn_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Mèri-mèriai he dèu la èba boroo la pehèbꞌo pa èi ago do menyilu. Tèbꞌo ri kèji ne boroo nee, jꞌe pejꞌole la kuri ubꞌa Yesus, mijꞌe ta hemuhe ri Noo, jꞌe lii, “Mata ko! Heleo ko ri dii! Ngita dèka tèra Elia ma pepure Noo ti ajꞌu ketoe dꞌee.” ");
INSERT INTO hvn_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Moko ta pekaa wari ke Yesus, jꞌe made. ");
INSERT INTO hvn_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Pa dꞌara Èmu Kepue Hebꞌajꞌa pa Deo, era ne bꞌèla do perète ta pewate Kama do Mèu do Megala. Pa awe hèpo hengaa Yesus, ne bꞌèla mehèri pedꞌue rai ti dꞌèia, hape la dꞌaꞌi. ");
INSERT INTO hvn_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Pa Golgota, era he dèu kètu horodꞌadꞌu do jaga, do titu peꞌumu nga ajꞌu ketoe Yesus. Ta ngède ri noo ne lua made Yesus, ta kebꞌèdi ke noo. Jꞌe lii, mihe ane, “Wii! Tèra-tèra, Dèu na dꞌee, Ana Deo!” ");
INSERT INTO hvn_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","41","Pa ène, era lema do pèri dèu mobèni, do titu ti jꞌèu, do ngède ne lua made Yesus. Mobèni nahère, do tima ta pemoke Yesus he pa Galilea. Ne ngara mobèni he, Salome, Maria ti rae Magdala, nga Maria do wala (ri ina ri Jꞌako do ngèru, nga Yoses), nga era ri ko mobèni do wala, do dèka pedutu Yesus hape la Yerusalem. ");
INSERT INTO hvn_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Èla pe na ène, era he dèu do kale pengee ta dꞌèi ta pepure ngiꞌu Yesus ti ajꞌu ketoe. Ne ngara noo Yusuf, ti rae Arimatea. Noo lema he dèu ti telora mone hèpo kewèlu pa dꞌara agama Jahudi. Noo he dèu, mone mola ngee. Noo lema pa dꞌara ta mata ne dèka lua pereda Deo. Made Yesus, lèka pa hari lèmi. Bꞌèli rai nee, lodꞌo hebꞌajꞌa do Jahudi. Ri harièle mii ke, ku dꞌèi ke Yusuf ta la pepure mèriai ne ngiꞌu Yesus. Ta pebꞌani dꞌèlu ke noo, ta la ame ne ngiꞌu Yesus pa gubernur Pilatus. ");
INSERT INTO hvn_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ta rènge ne lii ami Yusuf mi nahère, ta hengodo ke noo, jꞌe lii, “Weh! Made dꞌènge ke Noo? Ne pengee ri yaa, adꞌo mi nahère.” Ta pejuu ke ri noo dèu la pedoe ne kètu horodꞌadꞌu do jaga. Jꞌe kebꞌali noo, “Mi namii we? Do made tèra ke Yesus, we adꞌo?” ");
INSERT INTO hvn_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ta bꞌale ke ri kètu horodꞌadꞌu nee, mihe ane, “Made rai ngine heke, Ama, ee.” Ta rèngi ri gubernur ta do mi nahère, ta lii ke noo pa Yusuf, ta la èbe ne ngiꞌu Yesus. ");
INSERT INTO hvn_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ta pekèdꞌe ke Yusuf la Golgota. La pepure ri noo ne ngꞌiu Yesus ti ajꞌu ketoe. Ta wute ke ri noo ne ngiꞌu Yesus pe woꞌie-ie, ri bꞌèla do wiu, do maha kebꞌue. Pa awe do na ène, ta èla kowe roo, pe kei hewue roꞌa naba ta tuu rae dare pa bꞌojo wowadu. Ta heroꞌe ke ri roo ne ngiꞌu Yesus la dꞌara roꞌa ène. Jꞌe riho ri roo hewue ne wowadu kebꞌèla do worena, la henèbꞌe ne ubꞌa roꞌa ène. Ta bꞌale ke Yusuf he. ");
INSERT INTO hvn_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Pa awe na ène lema, Maria ti rae Magdala, nga Maria do wala (do ina ri Yoses ne), do pedutu hape la nii. Do toi woie ke ri roo dꞌue, ne era pebꞌèjꞌe Yesus. ");
INSERT INTO hvn_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Bèli rai, hari èna, lodꞌo hebꞌajꞌa do Jahudi. Ta èla pejèna lodꞌo, ta pekèdꞌèike Maria ti rae Magdala, Maria do wala (do ina ri Jꞌako), nga Salome, la wèli èi loko wumèngi, do ta èbe roo bèli rai, la pihe ngiꞌu Yesus, pedutu hadꞌa Jahudi. ");
INSERT INTO hvn_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Rai jꞌami ae lodꞌo Migu, ta pekèdꞌèike roo tèlu la rai dare Yesus. ");
INSERT INTO hvn_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","4","Pa telora rujꞌara, ta pedai ke roo, mihe ane, “Weh! Naduu ke do ta ami ri dii, ta riho ne wowadu worena do henèbꞌe ubꞌa roꞌa nee? Mèka dꞌo dii tèlu, ta riho ne wowadu ène!” Ta dꞌai roo la nii, ngède ri roo ne wowadu ne èla ke periho. ");
INSERT INTO hvn_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ta maho ke roo la dꞌara roꞌa ène. Ta kebꞌèdꞌèiane ke roo, ri ngède ri roo he dèu do ngèru do mejèdꞌèipa hebꞌèka kedꞌanga roo, nga pake bꞌara wo pudi kewaꞌa. ");
INSERT INTO hvn_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ta lii ke ne do ngèru na ène pa roo, “Bꞌole medaꞌu muu! Toi ri yaa, ta muu he ma kale Yesus ti Nasare, do èla pe pemade ri roo pa ajꞌu ketoe. Peꞌee dꞌo pa dꞌee, èla ke Noo pemuri wari. Mai ma heleo miha ri muu, ne era pebꞌèjꞌe ngiꞌu Noo. Peꞌee dꞌoke. ");
INSERT INTO hvn_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Bꞌale we muu mèriai! La pika pa Petu he, ta èla ke Yesus pemuri wari. Nèi ke Noo do uru la Galilea. Do ta pehapo muu nga Yesus pa nii, mi namii ne lii pika uru Noo pa muu. Naa, bꞌale we muu!” ");
INSERT INTO hvn_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ta dꞌai ne ngède ri mobèni he, ta dꞌo peꞌee tèra ke ne ngiꞌu Yesus, ta hengodo ke roo. Ta perai ke roo la tele. Bꞌale roo mèri-mèriai. Pedai dꞌo roo pa naduu-naduu pa rujꞌara, ri rihi medaꞌu roo. ");
INSERT INTO hvn_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Rai jꞌami ae lodꞌo Migu, Yesus pengèdi èni pa Maria ti Magdala, do ngèdi ta hudꞌèiti dꞌara noo ri Yesus, pidu ngiꞌu wango. ");
INSERT INTO hvn_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ta èla noo pe pengèdi nga Yesus, ta bꞌale ke noo la pika pa harièle dèu do ngèdi ta pedute Yesus. Do pee ko roo pa dꞌara pekupu, nga hedui pengee he, nga pewewi èi namada ta henge ne lua made Yesus. ");
INSERT INTO hvn_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ta lii ke Maria pa roo, “Ta ngaa muu ku pee ko nga hedui? Bꞌole hedui ri ne pengee, èla ke Yesus pemuri wari! Do na dꞌee kowe, pehapo ko nga yaa!” Tapulara bꞌale ri roo, mihe ane, “Weh! Bꞌole peluu jꞌii ri èu!” ");
INSERT INTO hvn_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Èla pe na ène, era do dꞌue ana ajꞌa Yesus do kako la hewue rae. Pa telora rujꞌara, ta dèka ke Yesus la pengèdi èni pa roo dꞌue. Rowi do wala ke ne hia Noo, hèku ue ta tui hudi ne tade ri roo. ");
INSERT INTO hvn_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ta bꞌale ke roo dꞌue, la pika pa ihianga roo, “Weh! Dꞌèno ko ri muu! Ngine dꞌee, pehapo Yesus nga jꞌii pa rujꞌara!” Tapulara ne lii ihianga roo harièle, “Weh! Bꞌole peluu jꞌii ri muu!” ");
INSERT INTO hvn_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Èla pe na ène, pengèdi èni rike Yesus pa do henguru he dèu ana ajꞌa Noo, pa dꞌara mejèdꞌèita ngaꞌa roo. Ta bꞌani ke ri Noo, mihe ane, “Weh! Rihi kètu wowadu muu! Dèu ta pika pa muu, ta do ngède ke Yaa ri namada roo miha, parahajꞌa dꞌo muu! Ane muu, ta peluu muu. Na dꞌee, ne ke Yaa ma hedꞌapa muu. Èla tèra ke Yaa pemade, tapulara do na dꞌee, ne ke Yaa do muri wari! Naa, heleo ri namada muu miha. ");
INSERT INTO hvn_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Hèku, na dꞌee, kako we muu la èpa kebꞌihu rai-wawa dꞌee, la pepeke pa harièle dèu ne Lii Hagꞌa Dꞌara ngati Yaa. ");
INSERT INTO hvn_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Naduu do parahajꞌa nga Yaa, jꞌe do herani ke, do ta wie ri Deo ne helama pa noo, mijꞌe nara noo ta muri loro helaꞌu nga Deo pa liru-bèla. Tapulara naduu dodꞌo parahajꞌa, do ta nara ruwolo noo, ta hane loro noo ri Deo pa tele. ");
INSERT INTO hvn_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ne dèu do parahajꞌa pa Yaa, do ta tao ri roo, ae keraꞌa rutada madalae, mijꞌe ta toi ri harièle dèu, ta kuaha do era pa roo dèka ngati Deo. Unupala he roo, do ta nara roo ta hudꞌèiwango nga ngara Yaa. Do ta wie ri Deo, ta iꞌa pedai lii pedai do wala, dodꞌo toi ri roo. ");
INSERT INTO hvn_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Kiri ta hibꞌi ri dobꞌoho do nga raho, kiadꞌo lèka ta nginu raho roo, ihilaka dꞌo roo. Ki tèka roo wolaèba pa wukolo dèu do pèda, ta ie ma ne dèu ène.” ");
INSERT INTO hvn_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ta èla Yesus pepedai lii nga ana ajꞌa Noo he, ta dꞌede ke Noo ri Deo la liru-bèla. Pa nii, jadꞌèi Noo ta ai dꞌanga Deo, mejèdꞌèi Roo helaꞌu ta pereda. ");
INSERT INTO hvn_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ta èla pe mi nahère, ana ajꞌa Noo he, pedute ne lii pereda Noo. Pekèdꞌèiroo la harièle kebꞌihu rai la pepika Lii Hagꞌa Dꞌara ngati Yesus pa harièle dèu. Ta wie ke ri Deo pa roo, ne kuaha ta tao ae keraꞌa rutada madalae do èla pewie ri Yesus. Ae tèra ne dèu do parahajꞌa pa Yesus, ri ne Lii Haga Dꞌara na dꞌee, do petuu. Ta dꞌai ne do tèlu mobèni he ta peꞌabu nga Petu he, ta pedꞌèii ke roo harièle jꞌara lua do ngèru do pedai lii nga roo pa rai dare ne ngine. Moko ke Yesus miha pereda pa ana ajꞌa Noo he, lita kako la pepeke ne Lii Hagꞌa Dꞌara ti Noo la hari-hari era, hape la èpa kebꞌihu rai-wawa. Lii Hagꞌa Dꞌara na dꞌee, do pika rujꞌara ta Deo do ta wie helama pa harièle dèu ti hala-ludu roo, mijꞌe ta nara roo ta muri mada peloro nga Noo. Lii Hagꞌa Dꞌara na dꞌee, do petuu tèra. Ri do mi nahère ke, ku pee noo ta era loro, hape la lodꞌo na mii-mii. ");
ALTER TABLE hvn_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
