﻿USE sofia;
DROP TABLE IF EXISTS sofia.huvNT_vpl;
CREATE TABLE huvNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES huvNT_vpl WRITE;
INSERT INTO huvNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Aaga nawiig cam apiüng wüx acualajtsüw mixejchiw mixeech Teat Jesucristo. Nop mixeech nej aag ayaj nenüt David aaga natang nenajiüt; aaga David quiaj Abraham mixeech nej. ");
INSERT INTO huvNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Aaga Abraham quiaj tacualüw a Isaac, Isaac tacualüw a Jacob, Jacob tacualüw a Judá, y alacas micoj nej michiig nej. ");
INSERT INTO huvNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá tacualüw a Fares, at a Zara, Tamar mimümüw nejiw. Fares tacualüw a Esrom, Esrom tacualüw a Aram. ");
INSERT INTO huvNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Condom Aram tacualüw a Aminadab, Aminadab tacualüw a Naasón, Naasón tacualüw a Salmón. ");
INSERT INTO huvNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón tacualüw a Booz, mimüm Booz aag ayaj Rahab. Booz tacualüw a Obed, mimüm Obed aag ayaj Rut. Obed tacualüw a Isaí. ");
INSERT INTO huvNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí tacualüw a David, áag tarang minatang nenajiüt. David tacualüw a Salomón, acual aweaag mintaj a Urías. ");
INSERT INTO huvNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón tacualüw a Roboam, Roboam tacualüw a Abías, Abías tacualüw a Asa. ");
INSERT INTO huvNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa tacualüw a Josafat, Josafat tacualüw a Joram, Joram tacualüw a Uzías. ");
INSERT INTO huvNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzías tacualüw a Jotam, Jotam tacualüw a Acaz, Acaz tacualüw a Ezequías. ");
INSERT INTO huvNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequías tacualüw a Manasés, Manasés tacualüw a Amón, Amón tacualüw a Josías. ");
INSERT INTO huvNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josías tacualüw a Jeconías y alacas micual nej. Aag ayaj wüx nüt ndeajtoj maquiiürajpüw nipilan judío andüyiw tiül iüt Babilonia. ");
INSERT INTO huvNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Wüx landoj aquiiübaranüw andüyiw Babilonia, Jeconías tacualüw a Salatiel, condom Salatiel tacualüw a Zorobabel. ");
INSERT INTO huvNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel tacualüw a Abiud, Abiud tacualüw a Eliaquim, Eliaquim tacualüw a Azor. ");
INSERT INTO huvNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor tacualüw a Sadoc, Sadoc tacualüw a Aquim, Aquim tacualüw a Eliud. ");
INSERT INTO huvNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud tacualüw a Eleazar, Eleazar tacualüw a Matán, Matán tacualüw a Jacob. ");
INSERT INTO huvNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob tacualüw a José minoj María. Aaga María quiaj tacual Teat Jesús nasoic a Cristo. ");
INSERT INTO huvNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Atquiaj tajlüy gajpopeic (14) nacualaran ajan wüx Abraham matüch a David. At tajlüy algajpopeic nacualaran ajan wüx David matüch wüx taquiürajpüw nipilan judío andüy tiül Babilonia. Nde wüx tajlüyiw tiül Babilonia wüx tatüch wijquiam Teat Cristo tajlüy algajpopeic nacualaran. ");
INSERT INTO huvNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Wüx wijquiat Teat Jesucristo atcüy tajlüy: María mimüm nej altiüt mipoch aweaag José. Pero naleaing nganaw mequiiübayej, María tajiür teomeaats nej nop nine; tüüch nej aag ayaj Nangaj Espíritu ocueaj Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Aaga José minench nej a María nop nej nerang najneaj. Xeyay andiüm minüx nej, áag ngo mandiüm majüiquich lacual manguiayeran; tandiüm macueat atánan quiaj. ");
INSERT INTO huvNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Naleaing José xeyay tamb wüx omeaats. Ndoj, wüx tameay, quiaj taǘm majaw nop ángel ocueaj Teat Dios. Tasaj nej: ―José acualaats David, nde meyac imeaats wüx aaga naél quiaj, iquiiüb marang mintaj a María, cos aaga nine apmawiquiach quiaj Nangaj Espíritu ocueaj Teat Dios neech nej. ");
INSERT INTO huvNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Nej apmawiquiach nop nine nench apmeaach manüt Jesús, cos nej apmawün asoet minipilan nej ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Atquiaj tajlüy meáwan atnej lamapiüng nop nendeac andeac Teat Dios, cos tapiüng: ");
INSERT INTO huvNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Nop leawa naleaing nüx nej apmecual mawiquiach nop nine nench. Aaga nine quiaj apmasoic Emanuel, ajow. Aaga poch Emanuel quiaj, apiüng: Dios almaquiiüb icoots. ");
INSERT INTO huvNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ndoj quiaj tapac ameay a José. Condom tarang atnej tasaj nej aaga ángel; taquiiüb a María marang mintaj nej. ");
INSERT INTO huvNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Naleaing nómban ngo majlüy aweaag, tacüliw wijquiam micual a María. Aaga nine tüünd manüt JESS. ");
INSERT INTO huvNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Teat Jesús wijquiat tiül cambaj Belén tiül iüt Judea wüx Herodes tarang minatang nenajiüt tiül aaga iüt quiaj. Tajlüy acas monxey mondüy wüx ocas tambüw andüyiw Jerusalén imiünüw nonüt iüt. ");
INSERT INTO huvNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Tatüniw manguiayiw: ―¿Nguiane almajlüy aaga nine wijquian leaw apmarang minatang nenajiüt tiül nipilan israele? Cos jayats majüic miocas nej; tajawasan wüx saliünan nonüt tiül xeiütan. Nganüy sajngoton naquiejliün xecosan teombas aaga nine ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Wüx tanguiay aag ayaj a Rey Herodes, ngo majneaj mayaag, aton meáwan moncül Jerusalén lango majawüw cuane apmarangüw. ");
INSERT INTO huvNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Quiaj tatün mapeayiw meáwan montangtang miteaats, aton meáwan mondüy wüx aaga poch tüünd Moisés ocueaj nipilan judío. Tatün manguiay nguiane netam wijquiam a Cristo. ");
INSERT INTO huvNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Quiaj tasajüw nej: ―Tiül cambaj Belén tiül iüt Judea, cos atquiaj tapiüng tanomb nop nendeac andeac Teat Dios wüx tapiüng: ");
INSERT INTO huvNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Cambaj Belén tiül iüt Judá, masey nine cambaj ic ajüic, naleaing xeyay nertam; cos naw tiül ique apmaw nop apmatüch marang natang nenajiüt, nej apmambeol xecambaj Israel―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ndoj aaga Herodes quiaj tapaj ajcüwa mondüy, axotǘyan tatün manguiay nejiw naleaing naleaing cuane minüt amelich majawüw aaga ocas. ");
INSERT INTO huvNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Condom tasaj nejiw mambüw Belén, tapiüng: ―Nganüy quiüran, nguineayantanej itüniün menguiayiün wüx a nine. Wüx lamexoman, ndoj tewiünan mesajan xic, quiaj sanamb a xique aton naquieel xecos teombas nej ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Wüx landoj masaj nejiw a Herodes, quiaj tambüw. Aaga ocas leawa tajawüw wüx aliw nonüt tiül miiütüw nejiw tamb ombas nej. Tayac nejiw alareng niüng ajlüy a nine; quiaj tacǘlan cawüx, ngo majüy. ");
INSERT INTO huvNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Nejiw wüx tajawüw aag ayaj xeyay tapac omeajtsüw. ");
INSERT INTO huvNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Almajmeliw tiül iüm, quiaj majawüw a nine almaquiiüb mimüm nej. Tajmiücüw tiüt maquiejliw micosüw nejiw manguejriw omalüw niüng ajlüy aaga nine. Condom taleaijquiw iquialayej mawüniw müjchiw oro, pom, at najmboc angan soex nasoic mirra. ");
INSERT INTO huvNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Condom wüx tameayiw, quiaj taümiw majawüw asaj nejiw Teat Dios nde mandilileaw majawüw a Herodes. Quiaj tandilileaw tiül miiütüw nejiw, ambüw tiül alinots tiiüd. ");
INSERT INTO huvNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Wüx laambüw a mondüy wüx ocas, quiaj José taǘm majaw nop ángel tasaj nej: ―Witiür, quiür, iquiiüb mintaj, iquiüjpan a nine, icuiürran indüyiün tiül iüt Egipto. Icülíünan quiaj, nde mewiünan leaw sasaj icon, cos alinoic nüt Herodes apmayamb a nine mambiy ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Wüx tapac ameay a José, quiaj taxainguiw a nine, taquiüjpüw mamb andüy Egipto aaga ongwiiüts quiaj. ");
INSERT INTO huvNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Tacülíwan quiaj. Tiünüw mandilileaw wüx landeow Herodes. Quiaj tajlüy atnej lamapiüng Teat Dios wüx tapiüng nop nendeac andeac nej, cos tapiüng: “Imiün Egipto tatüniüs xecual mandilil”, aw. ");
INSERT INTO huvNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Wüx aliün mapac a Herodes, tajaw lamawaijchaw nej ajcüwa mondüy wüx ocas, xeyay tajcüy. Tapiüng mambiyaranüw meáwan namix nine monench naw wüx iüm mineat, ndoj wüx naliw, meáwan monlüy tiül Belén, at tiül namix cambaj monlüy quiájan. Cos landoj matün manguiay ajcüwa mondüy, ngüt tajawüw aaga ocas. ");
INSERT INTO huvNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Atquiaj tajlüy leaw lamapiüng nomb Teat Dios masaj Jeremías aaga nendeac andeac nej, wüx tapiüng: ");
INSERT INTO huvNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Apmanguiayaran tiül cambaj Ramá, xeyay monpaj, xeyay monjiünts; cos Raquel xeyay ajiünts wüx micual nej. Nejinguind ngondom müüch nej majneaj omeaats, cos lango majlüyiw a namix nine. ");
INSERT INTO huvNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Condom wüx landeow Herodes, quiaj teümeay a José tiül Egipto, taǘm majaw nop ángel tasaj nej: ");
INSERT INTO huvNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","―Nganüy quiür, iquiiüb a nine at mimüm nej, indililean indüyiün tiül miiütan Israel, cos landeowüw mondiüm mambiyaw a nine ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Quiaj tamb andüy tiül miiüt Israel, taquiiüb a nine, at mimüm nej. ");
INSERT INTO huvNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Wüx José tanguiay Arquelao lamayar minajiüt miteat nej Herodes tiül Judea, quiaj timbol mambüw quiaj. Taǘm majaw tasoic mambüw andüyiw tiül iüt Galilea. ");
INSERT INTO huvNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Wüx tatüchiw tiül miiütüw nejiw, quiaj tambüw macüliw tiül noic cambaj nenüt Nazaret. Atquiaj tajlüy cos lamapiüngüw tanomb mondeac andeac Teat Dios. Tapiüngüw Jesús apmasoic Nazareno cos naw quiaj. ");
INSERT INTO huvNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Wüx aaga nüt quiaj, Juan, aaga neech yow nipilan, tamb mandeac andeac Teat Dios tiül iüt Judea niüng ngo majlüy cambaj. ");
INSERT INTO huvNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Quiaj taquiaach nipilan, tapiüng: ―Ich leaam imeajtsan mecueatiün leaw ngo majneaj irangan, cos aaga nüt wüx Teat Dios apmajlüy wüx micambaj nej laliüc matüch ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Cos aaga Juan quiaj, tandeac wüx nej Isaías, aaga nendeac andeac Teat Dios, wüx tapiüng: Apmanguiayaran aljane tenguial andeac tiül wajchiüc: “Itajcan majneaj mitiiüd a Teat Naxey; ileainguijchan a tiiüd cos nej aliüc.” ");
INSERT INTO huvNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Aaga Juan quiaj asooig apix nej najüyeran miyeed camello, aóel teomeaats nej taag. Tatsamb mow, tanganeow micün xiül. ");
INSERT INTO huvNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Tambüw manguiayiw aquiaach nej nipilan monaw tiül cambaj Jerusalén, monaw tiül iüt Judea, at monaw tiül namix nine cambaj monlüy mbeay lam Jordán. ");
INSERT INTO huvNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Wüx tapiüngüw lango mandiümüw marangüw aaga ngo majneaj tarangüw, quiaj Juan tüüch nejiw yow tiül lam Jordán. ");
INSERT INTO huvNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Wüx Juan tajaw lapeayiw quiaj xeyay fariseos at saduceos mayariw yow aton, quiaj tasaj nejiw: ―¿Jowa icona ponong ndiüc, jane nesaj icon mercuiürran meriowan tiül aaga xeyay ngo majneaj aliüc miün apmajlüye? ");
INSERT INTO huvNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Sitiül naleaing laleaaw imeajtsan nguineay temerangan, ijüiquichan nómban irangan najneaj. ");
INSERT INTO huvNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Nde merangrangayon wüx mepiüngan tíülan icona: “Abraham xeteatiün”; cos xique sasaj icon Teat Dios alndom müüch majlüy micual Abraham masey a piedra quiaj, ndot mandiüm. ");
INSERT INTO huvNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Nganüy üech alwüx apmandooig mioxijchaw xiül; atquiaj meáwan xiül leaw ngo mayac najneaj aóng nej, apndojquiüm majlos tiül biümb. ");
INSERT INTO huvNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Xique süüch icon yow jane naleaing lamacueat arang ngo majneaj. Pero aliüc miün nop andǘüban xic miün, nej xeyay netam ajlüy, ngo mat xic. Xique sayaag nicuajind xic niüng ajlüy nej; sayaag ngo natüch nandeaand tiüt apaj nej. Nej apmüüch icon mejiüran Nangaj Espíritu ocueaj Teat Dios. Apmawün wüx imbasan meáwan ngo majneaj atnej biümb ambel nendeajndeaj. ");
INSERT INTO huvNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Aag ayaj atnej arang nop nerang najiüt, cos alteowix nej minipüch nej, apmaxaing osaab trigo matendeay, condom apmaxaing mayac tiül troj. Ndoj aaga opang trigo apmambelich tiül biümb ngondom xejquem ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Teat Jesús imiün Galilea tamb majaw a Juan mbeay lam Jordán, müüch nej yow. ");
INSERT INTO huvNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Juan ngo mandiüm, tapiüng: ―Ngwüy Teat, ique netam meaach xic yow; ¿neol tewiün mejaw xic nüüch ic yowa? ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Quiaj Teat Jesús tasaj nej: ―Nganüy netam merang, cos netam marangar leaw lamapiüng Teat Dios ―aw. Quiaj lango mapiüng nicuajind a Juan. ");
INSERT INTO huvNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Wüx landoj ayar yow Teat Jesús, almaw tiül yow, quiaj tajaw lejquiat a cielo, tiün Nangaj Espíritu ocueaj Teat Dios imiün tiül cielo atnej noic palom andüy wüx ombas nej. ");
INSERT INTO huvNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Condom tanguiayaran noic nanderac imiün cielo, apiüng: ―Aag ayaj xecual xowüy sandiüm, apac ximeaats najaw ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Condom Nangaj Espíritu ocueaj Teat Dios taquiiüb mamb Teat Jesús andüy tiül wajchiüc müüch mayac nej wüx naél minatang nimeech. ");
INSERT INTO huvNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Teat Jesús taíünd ngo met ic miow (40) nüt, ic miow ongwiiüts, condom xeyay tind üet. ");
INSERT INTO huvNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Quiaj tapeay niüng ajlüy nej nimeech, tandiüm mayac nej wüx naél, tasaj: ―Sitiül naleaing ique Micual Dios ic, isaj aaga piedra quiaj marang pan ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Quiaj Teat Jesús tasaj nej: ―Tiül Mipoch Teat Dios apiüng: “Ngome áagan nüeteran ipacüy nipilan, leaw nembeat aag ayaj meáwan poch andeac Teat Dios” ―aj. ");
INSERT INTO huvNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Condom quiaj minatang nimeech taquiiüb nej mamb andüy tiül nangaj cambaj Jerusalén, mayac wüx omal nadam nangaj iüm. ");
INSERT INTO huvNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Quiaj tasaj nej: ―Sitiül ique Micual Dios ic, ijchic tiüt cos ajlüy tiül Mipoch Teat Dios, apiüng: Teat Dios apmüüch mamb miángeles nej mambeolüw ic. Apmangochiw ic naag owixaw nejiw ngana maleamb ileaj piedra, aw ―aj nej minatang nimeech. ");
INSERT INTO huvNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Quiaj Teat Jesús tasaj nej: ―Aton ajlüy tiül Mipoch Teat Dios, apiüng: “Nde mendiüm mitsoj leaw apiüng Teat Naxey Midios” ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Aaga minatang nimeech taquiiüb nej mamb alinomb. Nganüy taquiiüb nej andüy wüx nop najal oleaj tiüc. Quiaj tüüch nej majaw meáwan cambaj leaw ajlüy wüx iüt at meáwan leaw najneaj almajiürüw. ");
INSERT INTO huvNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Quiaj tasaj Teat Jesús: ―Meáwan aag ayaj sanüüch ic meneay sitiül ique apmequieel micos tiximbas meyar sandeac ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Quiaj tasaj nej Teat Jesús: ―Iriow ningüy niüng sajlüy, Satanás, cos tiül Mipoch Teat Dios apiüng: “Áagan Teat Dios netam mequieel micos teombas nej meyar andeac” ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Quiaj taw minatang nimeech. Condom tapeayiw miángeles Teat Dios mambeolüw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Wüx Teat Jesús tanguiay Juan lajmel tiül manchiüc, quiaj tandilil andüy tiül iüt Galilea. ");
INSERT INTO huvNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nej taton ngome tacül tiül Nazaret, tamb macül tiül Capernaum, noic cambaj mbeay nadam yow nenüt Galilea, tiül miiütüw Zabulón y Neftalí, monlüy tanomb. ");
INSERT INTO huvNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Atquiaj tajlüy atnej tanomb tapiüng Isaías nendeac andeac Teat Dios, cos tapiüng: ");
INSERT INTO huvNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Icona monaw tiül miiütüw Zabulón y Neftalí, najlüyiw mbeay tiiüd amb mbeay ndec, nonüt necamb lam Jordán; aag ayaj tiül iüt Galilea, niüng xeyay acüliw nipilan ngome judío. ");
INSERT INTO huvNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ajcüwa nipilan quiaj arangüw ngo majneaj, ajlüyiw atnej majlüyiw tiül pojniün, nejiw apmajawüw noic nadam ran. Leaw ajlüyiw tiül xeyay pojniün, apmachech nejiw a ran quiaj. ");
INSERT INTO huvNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ajan quiaj tapots maquiaach nejiw Teat Jesús, tapiüng: ―Icueatiün aaga ngo majneaj irangan, cos Teat Dios laliüc miün majlüy wüx micambaj nej ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Noic nüt wüx Teat Jesús tamong amb mbeay aaga nadam yow nenüt Galilea, quiaj tajaw ijpüw monxey nop necual nejiw, nop Simón nasoic Pedro, alinop Andrés michiig nej. Nejiw tenguial andocoj cos mondoc nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Quiaj tasaj nejiw Teat Jesús: ―Macaron tabaats, sanaquiaach icon nguineay alndom meyamban nipilan mesajan mayariw sandeac. Langome apmeyamban cüet mendocon, apmeyamban nipilan ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Tacueatíwan quiaj mindocoj nejiw, tandüjpiw mamb Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Condom quiríwan iün majüyiw, quiaj Teat Jesús taxom alijpüw, nop necual nejiw, nop Jacobo, alinop Juan, micual nejiw Zebedeo. Aliw tiül müx maquiüjpüw miteatiw nejiw, tenguial axequiw ndoc. Quiaj tasaj nejiw Teat Jesús mambüw maquiüjpüw. ");
INSERT INTO huvNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Nejiw tacueatíwan tiül müx miteatiw nejiw, tambüw mandüjpiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Teat Jesús tajüy meáwan tiül iüt Galilea. Taquiaach tiül meáwan sinagoga ocueajiw a nipilan quiaj. Tandeac nguineay apmajlüy wüx Teat Dios apmajlüy wüx micambaj nej. Aton tamongoch iün andeowüw cuajantanej monandeow leaw axom nejiw nipilan tiül ajcüwa cambaj quiaj. ");
INSERT INTO huvNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Wüx tanguiayaran tiül iüt Siria meáwan leawa nej arang, quiaj taquiüjpüw niüng ajlüy nej xeyay moniün andeow. Altiül xeyay teamamongochiw, lamix omeajtsüw; altiül nechach, üüch nejiw michachiw nimeech; altiül ndron ombas, nawaag owix oleaj. Teat Jesús tüüch majneaj meáwan. ");
INSERT INTO huvNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Quiaj tandüjpiw nej xeyay nipilan monaw Galilea, monaw Decápolis, monaw Jerusalén, monaw Judea, monaw nonüt necamb lam Jordán. ");
INSERT INTO huvNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Wüx Teat Jesús tajaw xeyay nipilan lapeayiw niüng ajlüy, quiaj tajtep andüy wüx noic tiüc chetet. Tapeayiw niüng ajlüy nej minipilan nej. ");
INSERT INTO huvNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Quiaj tapots maquiaach nejiw Teat Jesús, tapiüng: ");
INSERT INTO huvNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","―Najneajay ajlüyiw leaw ayaag netam nejiw Nangaj Espíritu ocueaj Teat Dios, cos apmajlüyiw tiül micambaj Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Najneajay ajlüyiw leaw amix omeajtsüw nganüy, cos apmüjndiw mapac omeajtsüw alinoic nüt. ");
INSERT INTO huvNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Najneajay ajlüyiw leaw ngo merangrangayej; nejiw apmüjndiw a iüt cam leaw tasoiquiw apmüjndiw. ");
INSERT INTO huvNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Najneajay ajlüyiw leaw xowüy andiümüw marangüw leaw andiüm Teat Dios, nej apmambeol nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Najneajay ajlüyiw leaw ajiürüw lasta nop alinop, cos aton Teat Dios apmajiür nejiw lasta. ");
INSERT INTO huvNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Najneajay ajlüyiw leaw nómban lamawüniw wüx omeajtsüw ngo majneaj; nejiw alinoic nüt apmajlüyiw niüng ajlüy Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Najneajay ajlüyiw leaw monyamb majlüy monajneaj, ngo majlüy moncüy, nejiw apmasoiquiw micual nejiw Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Najneajay ajlüyiw leaw amongochiw ngo majneaj masey arangüw najneaj; nejiw apmajlüyiw tiül micambaj Teat Dios tiül cielo. ");
INSERT INTO huvNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Najneajay ijlüyiün wüx itsojaranan memongochiün ngo majneaj. Aton awüníwan wüx omeajtsüw mandeacüw wüx imbasan xeyay ngo majneaj cos iyariün sandeac. ");
INSERT INTO huvNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Tanomb atquiaj tamongochiw ajcüwa mondeac andeac Teat Dios. Nganüy icona, ich mapac imeajtsan xeyay cos ajlüy noic najneajay tiül cielo leaw apmeajndiün. ");
INSERT INTO huvNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","’Icona ijlüyiün wüx a iüt cam at icon najneaj quiniüc najtix. Pero sitiül quiniüc mamong ajtix, ¿nguineay alndom majtix alinomba? Lango metam, netam majwich ninguiün macuüüch nej tiüt nipilan. ");
INSERT INTO huvNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Icona ningüy wüx aaga iüt cam ijlüyiün at icon ran. Ajawaats sitiül noic cambaj ajlüy wüx tiüc ngondom mexotüy. ");
INSERT INTO huvNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ngondom mechen nots candeal condom cas tepal omal tiül nop xor. Ngwüy, netam meyac cawüx marraj meáwan leaw almajlüy tiül iüm. ");
INSERT INTO huvNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Atquiaj icona aton, irangan najneaj tiül nipilan para mejlüyiün atnej aaga ran quiaj; cos wüx nipilan apmajawüw irangan najneaj, nejiw aton apmarangüw leaw andiüm Teat Dios najlüy tiül cielo. ");
INSERT INTO huvNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","’Nde mepiüngan xique xiün nandrooch aaga poch leawa tüünd Moisés, tengwüy leaw tandeacüw mondeac andeac Teat Dios. Ngwüy, xique ngo niün nandrooch nicuajind. Xique xiün najüiquich wüx nguineay ajlüy, narang atnej apiüng. ");
INSERT INTO huvNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Naleaing sasaj icon, wǘxan almajlüy a cielo maquiiüb a iüt, nómban ngome apmamong masey noic nine punto, noic nine letra tiül aaga poch leawa tüünd Moisés, cos meáwan leaw Mipoch Teat Dios apiüng netam majlüy. ");
INSERT INTO huvNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Atquiaj sitiül aljane mapiüng ngo membeat masey noic nine poch leaw Teat Dios lamapiüng netam marangüch, ndot atquiaj maquiaach wüx nipilan, nej apmajlüy at nej nop chingüy, leaw ngo membeat tiül minipilan Teat Dios. Pero sitiül aljane arang meáwan leaw Teat Dios lamapiüng marangüch, aton maquiaach wüx alinop marang atnej; nej apmarang nop natang tiül cielo niüng apmajlüyiw minipilan Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Sasaj icon netam merangan atnej apiüng Teat Dios, ngo matnej arangüw ajcüwa mondüy wüx aaga poch tüünd Moisés, at leaw arangüw fariseos; cos sitiül ngo merangan atnej netam ngondom mejmeliün tiül micambaj Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","’Lamenguiayiün nguineay tasoiquiw tanomb mixejchiün, cos tasoiquiw: “Nde membiyan nejinguind, sitiül aljane apmambiy alinop netam mangüy aaga nisoet”, ajowiw. ");
INSERT INTO huvNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Aag ayaj naleaing, xique nganüy sasaj icon, jane ajcüycüy majaw alinop netam mangüy aaga nisoet. Aton jangantanej leaw apmasaj chach aljane, netam mayacüw nej asoet montangtang tiül nadam nangaj iüm. At jangantanej leaw apmapaiich alinop, aag ayaj alndom mamb tiül necoy tiül biümb. ");
INSERT INTO huvNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Sitiül leriümb apmeyac erchech, quiaj leaaw imeaats aljane ajcüy majaw ic, ");
INSERT INTO huvNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ich majlüy, nde meyac. Quiür indeac anaag aaga najcüy majaw ic quiaj, para majneaj imeajtsan mamong ijcüyiün, cas tendilil meyac erchech. ");
INSERT INTO huvNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’At sitiül aljane aleaic iriow anaag wüx, andiüm mayac ic teombasüw monajiüt, indeac anaag, ijaw cuane iriowan wüx, ijneajiün wǘxan nganaw mepeay anaag teowixaw monajiüt, cos teat xan alndom masaj mimongot nej mayacüw ic tiül manchiüc. ");
INSERT INTO huvNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Naleaing sasaj ic, wüx lerpeay tiül manchiüc langondom meriow najen, apmeriow wüx lamembich mengüy leaw apmatüniw icueaj. ");
INSERT INTO huvNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","’Lamenguiayiün nguineay tasoiquiw tanomb, cos asoiquiw: “Nde mejiüran minajtajan, nde mejiüran minaxeyiün”, ajowiw. ");
INSERT INTO huvNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Aag ayaj naleaing. Pero nganüy xique sasaj icon jangantanej leaw apmajaw nop najtaj mandiümdiüm, aag ayaj atanej lamarang aweaag nisoet. ");
INSERT INTO huvNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Sitiül miác iniiüg laliüc mayac ic wüx merang ngo majneaj, isoond, ndoj telox ninguiün; cos más najneaj masey noic iniiüg, ngome atnej mejlos tiül xeyay necoy tiül biümb. ");
INSERT INTO huvNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","At sitiül miác iwix apmayac ic wüx merang ngo majneaj, ich ndojquiüm majlos ninguiün; cos más najneaj masey nots iwix, ngome atnej mejlos tiül xeyay necoy tiül biümb. ");
INSERT INTO huvNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","’Aton tanomb tasoiquiw: “Jangantanej macueat mintaj nej, netam marang noic nawiig mecueatayej”, ajowiw. ");
INSERT INTO huvNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Nganüy xique sasaj icon sitiül nop naxey macueat mintaj nej, acueátan, ngome nejiür naxey a najtaj; nej a naxey quiaj ajiür nisoet, cos tenguial mayac wüx majiür naxey mintaj nej. Aton jane apmaquiiüb aaga najcueat najtaj quiaj, apmajiür nisoet, cos apmajlüy atnej minajtaj nej. ");
INSERT INTO huvNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’Aton lamenguiayiün nguineay tasoiquiw tanomb mixejchiün: “Nde aleaic mendeacan mepajan minüt Teat Dios sitiül ndoj ngo merangan leaw lamepiüngan apmerangan”, ajowiw. ");
INSERT INTO huvNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Aag ayaj naleaing. Pero nganüy xique sasaj icon nde mendeacan aleaic mepajan wüx minüt cielo cos aag ayaj niüng chetej Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Nde mepajan wüx minüt iüt, cos aag ayaj niüng acuüüch oleaj Teat Dios. Aton nde mepajan wüx minüt Jerusalén cos aag ayaj micambaj aaga Teat natang tiül meáwan monajiüt. ");
INSERT INTO huvNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Aton nde mepajan wüx imalan, cos cuane icon, ngondom meajchiün mambeor masey nots miondeats imalan, aton ngondom meajchiün marang ngweal. ");
INSERT INTO huvNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Xique sasaj icon netam mendeacan “naleaing” sitiül naleaing, at netam mepiüngan “ngo maleaing” sitiül ngwüy. Cos sitiül apmepajan minüt aljane, aag ayaj ngo majneaj, ocueaj nimeech. ");
INSERT INTO huvNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’Lamenguiayiün nguineay tasoiquiw tanomb, cos atcüy tasoiquiw: “Jangantanej macuiaach oniiüg alinop, atanej netam macuiajchich oniiüg nej. Aton jangantanej leaw apmapol olüic alinop, atanej netam mapolich olüic nej”, aw. ");
INSERT INTO huvNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Pero xique sasaj icon, nde mepalüchiün ombas leawa nerang ngo majneaj wüx imbasan. Ingow aag ayaj sitiül aljane lamaleamb imbeay, iich maleamb ic alinots. ");
INSERT INTO huvNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","At sitiül aljane andiüm mayac ic tiül moncüy, mandiüm manood tarrang micamix, iich alinoic majoy aton. ");
INSERT INTO huvNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Sitiül aljane müüch ic memal tiüt alngün naǘm, nde mepiüng wüx masey memal alatownej. ");
INSERT INTO huvNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Sitiül aljane apmatün icueaj alcuane, iich leaw alndom. Aton sitiül aljane andiüm majüch ic, iich sitiül alndom. ");
INSERT INTO huvNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’Aton lamenguiayiün nguineay tasoiquiw nomb, cos asoiquiw: “Netam mejiüran lasta alinop, pero leaw ajcüy majaw icon ijcüyiün mejawan aton”, ajowiw. ");
INSERT INTO huvNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Pero xique sasaj icon netam mejiüran lasta moncüy majaw icon. Indeacan najneaj wüx ombas leaw apaiich icon; irangan najneaj wüx ombasüw leaw ngo mind majaw icon. Itüniün Teat Dios mambeol nejiw leaw arangüw wüx imbasan ngo majneaj. ");
INSERT INTO huvNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Atquiaj apmajüic icona micual icon Teat Dios najlüy tiül cielo. Cos Teat Dios tenguial müüch majntsop a nüt marraj meáwan nipilan; aton üüch majoet nguiajantanej masey niüng ajlüy nerang najneaj, masey niüng ajlüy nerang ngo majneaj. ");
INSERT INTO huvNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Sitiül icona apmejiüran lasta áagan a nipilan leaw andiümüw icon, ¿cuane najneaj aag ayaja? ¿Neol ngwüy atquiaj arangüw ajcüwa monsap mitomiün cambaja, ajcüwa monrang xeyay ngo majneaja? ");
INSERT INTO huvNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Sitiül áagan micoj michiig ertepeay anaag, ¿cuane alwüx ajneaj irangana? ¿Neol ngwüy, atquiaj aton arangüw nipilan leaw ngo mayamb Teat Dios? ");
INSERT INTO huvNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Icona netam merangan leaw najneaj, palan, atnej arang Miteatiiüts Dios najlüy tiül cielo, cos nej nerang najneaj, palan. ");
INSERT INTO huvNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","’Leaw najneaj irangan, nde merangrangayon wüx; cos sitiül irangan najneaj majaw icon nipilan, Miteatiiüts Dios najlüy tiül cielo ngome apmüüch icon mejiüran leawa nej andiüm müüch. ");
INSERT INTO huvNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Icona wüx imbeolan aljane leaw ngo majiür, nde mendeacndeacan wüx manguiay nipilan matnej arangüw monrangrangüy tiül sinagogas, at tiül calle aton. Cos nejiw arangüw malombaranüw wüx. Naleaing sasaj icon, nejiw landoj lamajiürüw leaw ayambüw wüx aaga alomboochayej quiaj. ");
INSERT INTO huvNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Icona wüx aleaic meajchiün aljane leaw ngo majiür, ijchan nejinguind ngo majaw, masey miquiamb iwix ngo majaw leaw arang miác iwix. ");
INSERT INTO huvNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ijchan leaw indiüman, nejenguind ngo majaw. Quiaj Miteatiiüts Dios apmüüch icon xeyay monajneaj majawüw nipilan, cos nej ajaw masey ixotǘyan terang. ");
INSERT INTO huvNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","’Wüx aleaic apmesajan Teat Dios nde merangan matnej arangüw ajcüwa monrángan ayamb Teat Dios, cos nejiw xowüy andiümüw mapajüw minüt Teat Dios tiül sinagoga lombojówan. At ambüw mapajüw minüt Teat Dios niüng tenguial among monjüy, majaw nejiw nipilan. Naleaing sasaj icon áagan ayaj apmaxomüw wüx aaga alomboochayej quiaj. ");
INSERT INTO huvNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Pero xique sasaj icon, wüx apmetajcan orar ijmeliün tiül iüm, ipalan imbiüman, indeacan mequiüjpan, cos nej alniüng ijlüyiün; néjan quiaj apmanguiay. Alinoic nüt apmeajndiün leaw itüniün. ");
INSERT INTO huvNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Wüx apmetajcan orar mesajan Teat Dios nde mepiüngpiüngánan matnej arangüw nipilan leaw ngo mayariw andeac Teat Dios, cos nejiw apiüngüw wüx apmandeacndeacüw xeyay, Teat Dios apmanguiay. ");
INSERT INTO huvNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Icona nde merangan atnej arangüw nejiw, cos Teat Dios lamajaw cuane netam icon wǘxan nganaw metüniün. ");
INSERT INTO huvNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Icona wüx apmesajan Teat Dios, atcüy ipiüngan: Xeteatiün Dios najlüy tiül cielo, ique nangaj minüt. ");
INSERT INTO huvNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Sandiüman mejlüy wüx meáwan nipilan nguiajantanej almajlüyiw. Atnej iyambüch ninguiün tiül nangaj cielo, atquiaj aton netam meyambüch ningüy wüx aaga iüt cam, marangüch leaw ique indiüm. ");
INSERT INTO huvNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Teat, iich xicon nüeteran nganüy nüt cam, atnej ique ijaw netam. ");
INSERT INTO huvNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Iwün wüx imeaats aaga ngo majneaj tarangasan Teat, cos xicona aton lanawüniün wüx ximeajtsan aaga ngo majneaj nipilan arangüw wüx ximbasan. ");
INSERT INTO huvNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Imbeol xicon nde narangan ngo majneaj Teat. Iwün ninguiün meáwan ngo majneaj, nde matüch xicon nimeech. Cos ique natang nenajiüt wüx meáwan cambajiüt; ique alndom merang cuajantanej. Ique najneajay ijlüy meáwan nüt, ngo majiür ümb. Amén. ");
INSERT INTO huvNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Sitiül icona iwüniün wüx imeajtsan leaw ngo majneaj arangüch wüx imbasan, Miteatiiüts Dios najlüy tiül cielo atquiaj apmarang wüx imbasan aton. ");
INSERT INTO huvNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Pero sitiül icona ngo mewüniün wüx imeajtsan leaw ngo majneaj arangüch wüx imbasan, átan quiaj Miteatiiüts Dios ngome apmawün wüx omeaats isoetiün leaw ijiüran. ");
INSERT INTO huvNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","’Wüx icona iiündan lop para manguiay icon Teat Dios, nde merangan atnej xowüy amix imeajtsan atnej arangüw monrangrangüy, cos nejiw arangüw atnej niün andeowüw para majaw nejiw nipilan mapiüngüw nejiw tenguial aiündüw. Naleaing sasaj icon nejiw áagan ayaj apmaxomüw wüx aag arangüw atquiay quiaj. ");
INSERT INTO huvNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Pero icona wüx apmeiündan metajcan orar, ertaagayon majneaj, ijonchiün imalan najneaj, ipejiün iniüjcan aton. ");
INSERT INTO huvNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Atquiaj nipilan ngome apmateotsüw wüx sitiül icona tenguial iiündan manguiay icon Teat Dios. Meáwan leawa tenguial merangan masey ixotayon, Teat Dios ajaw, ndoj nej apmüüch icon xeyay monajneaj majaw icon nipilan. ");
INSERT INTO huvNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","’At aton sasaj icon nde mendiümdiümánan cuajantanej nembeatmbeat ningüy wüx iüt, cos alndom majtep miíüt pandiüm. Cuajantanej leaw ijiüran alndom memoen, aton need alndom majmel maneed. ");
INSERT INTO huvNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ngwüy icona irangan leaw andiüm Miteatiiüts Dios cos aag ayaj atnej mejiüran xeyay nembeatmbeat tiül cielo niüng nicuajind ngondom majtep miiüt, ngondom memoen, ngondom majteor. ");
INSERT INTO huvNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Cos niüng ijiüran cuajantanej nembeatmbeat, quiaj iyacan imeajtsan aton. ");
INSERT INTO huvNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","’Oniiügaran aag ayaj nerraj icoots. Sitiül iyacan iniüjcan wüx mejawan najneaj, apmambeol icon merangan najneaj. Wüx icona irangan najneaj aag ayaj atnej mejlüyiün tiül ran. ");
INSERT INTO huvNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Pero sitiül icona indiüman meyacan iniüjcan wüx mejawan leaw ngo majneaj, quiaj apmerangan xeyay ngo majneaj; aag ayaj atnej ijlüyiün tiül pojniün. Sitiül icona irangan ngo majneaj, andüy quiaj apmexeyay ngo majneaj temerangan quiaj. ");
INSERT INTO huvNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’Nejinguind ngondom marang minajiüt ijpüw monxey nóiquian, cos ndot apmandiüm marang leaw apiüng nop, ngome apmarang leaw apiüng alinop. Tengwüy xeyay mandiüm mandüüb nop, quiaj ngome apmarang leaw apiüng alinop. Atquiaj ajlüy, nómban ngondom mendüüb Teat Dios sitiül meyac imeaats wüx mendiümdiüm tomiün. ");
INSERT INTO huvNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’Xique sasaj icon nde mamb wüx imeajtsan mepiüngan cuane apmeatiün, cuane apmenganeowan, at wüx ipixan mepiüngan cuane apmesoijquiün. ¿Neol ngwa, icona alwüx itaman ngo matnej nüeteran; aton micuerpojan alwüx atam ngo matnej napixeran? ");
INSERT INTO huvNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ijawan nguineay ajlüyiw a quiec, nejiw ngo mepiürüw maxainguiw omeaats corrül, ngo mapalüw leaw apmüetiw alinoic nüt; cos Miteatiiüts Dios najlüy tiül cielo awiül nejiw. ¿Neol, ngome alwüx imbeatiün a icona ngo mat nejiw a quieque? ");
INSERT INTO huvNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿Ngwüy jane tiül icona cos xowüy amb wüx omeaats alcuane, alndom matang wüx alpinawan metro? ");
INSERT INTO huvNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’¿Neol tapots amb imeajtsan wüx ipixana? Ijawan nguineay ajlüy a mbaj tiül xiül. Nejiw atangüw ngo marangüw najiüt nicuajind, ngo mendileaw aton. ");
INSERT INTO huvNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Nganüy sasaj icon, aaga minatang nenajiüt nenüt Salomón najlüy tanomb, masey tajiür xeyay najneajay apix nej cos nej tajiür xeyay tomiün, ngo matüch matnej ajneajiw ajcüwa mbaj. ");
INSERT INTO huvNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Sitiül Teat Dios ayac aaga mbaj soex najlüy tiül xiül leaw nganüy almajlüy, oxep lamarang asap andaab pow, cuane wüx ngo müüch icon meáwan leawa netam. ¿Neol ngo meyacan imeajtsan wüx neje? ");
INSERT INTO huvNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Icona nde meyacan imeajtsan wüx mepiüngan: “¿Cuane apmetiiüts manganeowaats, cuane apmasoijquiiüts?” merawan. ");
INSERT INTO huvNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Cos nipilan leaw ngo mayambüw Teat Dios, xeyay ayacüw omeajtsüw wüx aag ayaj. Miteatiiüts Dios najlüy tiül cielo, nej alwüx; nej ajaw meáwan leaw tenguial atam icon. ");
INSERT INTO huvNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Netam meyamban ombas mejlüyiün tiül minipilan Teat Dios, merangan meáwan leawa nej andiüm. Quiaj apmüüch icon meáwan leawa netam. ");
INSERT INTO huvNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Atquiaj icona nde mamb wüx imeajtsan mepiüngan cuane apmajlüy oxep, cos aaga oxep quiaj apmaquiiüb miün alinoic cuane mamb wüx imeajtsan. Meáwan nüt ajlüy palpálwüx naél. ");
INSERT INTO huvNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","’Nde meyambyamban asoet alinop, quiaj nejinguind ngome apmayamb isoetiün. ");
INSERT INTO huvNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Cos atnej icona iyacan asoet alinop, atnej apmajmel isoetiün. Atnej icona irangan wüx alinop, atnej apmarangüch wüx imbasan aton. ");
INSERT INTO huvNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Neol nguineay ixom mejaw a najmel altiül oniiüg alinop, nganüy a ique ngo mexom mejaw aaga xiül alatsam tiül iniiüga? ");
INSERT INTO huvNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿Cuane wüx alndom mesaj alinop: “Chiün nawün aaga najmel altiül iniiüg quiaj”, meraj, sitiül nganaw mewün a xiül alatsam tiül iniiüga? ");
INSERT INTO huvNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Ndeac mbeay! Sasaj ic menguiay, iwün ombas aaga xiül alatsam tiül iniiüg quiaj, ndoj quiaj apmejaw najneaj para alndom mewün aaga najmel altiül oniiüg alinop. ");
INSERT INTO huvNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Nde meajchiün a pet leaw nangaj cos alndom majchic matsamb machiüt icon tiüt. Aton nde meloxiün nembeatmbeat perlas teombas sow, cos alndom macuüüchcuüüch tiüt. Aag ayaj atnej mewijchan meajchiün pet leaw xeyay nembeat. Cos sitiül pet ngo majaw jane ic, alndom matsamb iwix, masey tendiüm meaach leaw najneaj. Tengwüy apmarangüw atnej arang sow, cos sow apmacuüüchcuüüch tiüt leaw ngo mandiüm müet, masey xeyay najneaj üünd. ");
INSERT INTO huvNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","’Sitiül apmetüniün apmeajndiün; sitiül apmeyamban apmexoman; sitiül apmerndeacan apmengocharanan. ");
INSERT INTO huvNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Cos jangantanej leaw apmatün apmüünd; leaw apmayamb apmaxom; at leaw apmendeac apmangocharan. ");
INSERT INTO huvNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’¿Ngwüy aljane tiül icona sitiül micual nej matün pan, ingow üüch pan apmüüch noic piedra? ");
INSERT INTO huvNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","¿Jondot matün cüet, ingow üüch cüet apmüüch nop ndiüca? ");
INSERT INTO huvNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Sitiül icona nerangan ngo majneaj, ijawan nguineay meajchiün micualan noic najneaj, cuantemas Miteatiiüts Dios najlüy tiül cielo apmüüch najneajneaj cuajantanej jane apmatün nej ocueaj. ");
INSERT INTO huvNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Icona netam merangan wüx alinop atnej temendiüman marangüch najneaj wüx imbasan, cos atquiaj apiüng tiül aaga poch leawa tüünd Moisés. Aton atquiaj ajlüy tiül minawijquiaw mondeac andeac Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","’Ijmeliün iriümban tiül quicheech puerta niüng ajmeleran. Cos ajlüy alinoic nadam niüng ajmeleran, nadam a tiiüd aton, ambüw tiül ajmeliw xeyay nipilan. Aaga nadam tiiüd quiaj amb andüy tiül castigo. ");
INSERT INTO huvNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Aaga alinoic puerta niüng ajmeleran, aag ayaj quicheech, at a tiiüd aton narix. Aag ayaj amb andüy tiül cielo niüng apmapacaran meáwan nüt, pero naleaing napateay monxom nej. ");
INSERT INTO huvNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’Ijawan wüx ajcüwa monwaiich, cos aliücüw mapiüngüw nejiw andeacüw andeac Teat Dios. Nejiw apmajüic at nejiw sap ngome napatüw; naleaing tiül omeajtsüw nejiw at nejiw napat sampüy. ");
INSERT INTO huvNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Icona alndom mejawan jane nejiw wüx leaw arangüw. ¿Ngwa alndom mepejtiün uvas wüx noic owil sats, ngwa alndom mepejtiün toc wüx patiürra? ");
INSERT INTO huvNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Meáwan leaw najneaj xiül aóng najneaj, leaw xiül lango majneaj ngondom mayac najneaj aóng. ");
INSERT INTO huvNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Noic owil najneaj xiül ngondom maóng ngo majneaj, at noic owil xiül leaw ngo majneaj, ngondom maóng najneaj. ");
INSERT INTO huvNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Leaw xiül ngo mayac najneaj aóng nej, apmandoijquich majlos tiül biümb. ");
INSERT INTO huvNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Atnej xiül wüx aóng alndom majaraw sitiül najneaj, atquiaj nipilan aton ajaraw jane nej wüx ajaraw leaw arang. ");
INSERT INTO huvNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","’Ngome meáwan monpiüng: “Teat Naxey, Teat Naxey”, mawüw, apmajmeliw tiül micambaj Teat Dios. Áagan leaw monrang atnej andiüm Xeteat najlüy tiül cielo, nejiw apmajmeliw. ");
INSERT INTO huvNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Wüx aaga nüt quiaj xeyay nipilan apmasajüw xic: “Teat Naxey, Teat Naxey, taquiaachasan nipilan wüx minüt, aton wüx minüt tawünasan nimeech wüx ombasüw nipilan. At tarangasan xeyay ateócan wüx minüt”, apmawüw. ");
INSERT INTO huvNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Pero xique quiaj sanasajüw: “Ngo najaw jane icon. Iriowan ningüy niüng sajlüy monrang ngo majneaj”, sanajüw. ");
INSERT INTO huvNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’Jangantanej leaw apmanguiay xepoch cam marang atnej sapiüng, apmajlüy atnej nop naxey nexom omeaats, tawitich ombiüm nej wüx piedra. ");
INSERT INTO huvNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Camüm majoet maw nadam lam, mapac nadam iünd, ngo marang nej nicuajind aaga iüm quiaj, cos wüx piedra witiow. ");
INSERT INTO huvNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Nganüy jangantanej leaw apmanguiay xepoch cam ndoj ngo marang atnej, apmajlüy atnej nop naxey nechach, tawitich ombiüm nej teomeaats lam tíülan wiiüd. ");
INSERT INTO huvNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Camüm majoet maw nadam lam, mapac nadam iünd, quiaj ajmiüc a iüm. ¡Nómban ndroj ombas! ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Wüx landoj mandeac meáwan aaga poch quiaj Teat Jesús, mbayajow nipilan manguiayiw leaw landoj mandeac. ");
INSERT INTO huvNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Cos taquiaach nejiw atnej andeac nop nendüy nejiür nadam najiüt, ngo matnej aquiajchiw mondüy wüx aaga poch tüünd Moisés. ");
INSERT INTO huvNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Wüx taw tiüt Teat Jesús imiün wüx tiüc, tandüjpiw nej xeyay nipilan. ");
INSERT INTO huvNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Condom quiaj ajngot majaw nej nop naxey axom nej napat monandeow nasoic lepra atextexíichan ombas nej. Quiaj taquieel micos nej tiüt teombas Teat Jesús, tasaj: ―Teat Naxey, sitiül ique indiüm, sajaw alndom memongoch iün sandeow ―aj. ");
INSERT INTO huvNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Quiaj Teat Jesús taxaing owix marreeg, tasaj: ―Xecual sandiüm, sanamongoch iün indeow ―aj. Wǘxan ndoj masoic aag ayaj, andǘüban ndej minecoy nej aaga niün andeow quiaj. ");
INSERT INTO huvNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Condom quiaj tasaj nej Teat Jesús: ―Nde mesaj nejinguind, quiür, iich majaw ic miteaats, iyac erchech atnej tapiüng Moisés marangüch. Quiaj apmajawüw ique lerneaj ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Almajmel tiül cambaj Capernaum Teat Jesús, quiaj tiün majaw nej nop minatang soldado matün nej ocueaj. ");
INSERT INTO huvNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Tasaj: ―Teat Naxey, nop nerang xenajiüt alwüx mats saniüng, lamalox nej tiüt noic monandeow. Nómban asol nej, xeyay necoy tenguial mamongoch ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Quiaj tapiüng Teat Jesús: ―Saleamb quiaj namongoch iün andeow ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Quiaj tapiüng a natang soldado romano: ―Teat Naxey, cuane xic, xique ngo nembeat nicuajind para meamb saniüng. Xique sapiüng teat, mepiüng noic poch, quiaj apmajneaj a nembeol xic. ");
INSERT INTO huvNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Cos xique aton sajiür nesaj xic cuane narang, at a xique sajiür xesoldado leaw sasajüw cuane netam marangüw. Sitiül xique sanasaj nop: “Quiür”, naj; nej apmamb. Sitiül sanasaj alinop: “Mac”, naj; nej aliüc. Tengwüy sanasaj nerang xenajiüt: “Irang aag agüy”, naj; nej apmarang ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Wüx tanguiay aag ayaj Teat Jesús mbayaw manguiay, quiaj tasaj leaw almaquiiüb, tapiüng: ―Naleaing sasaj icon ngo naxom masey anop tiül nipilan judío leaw ayar sandeac matnej aaga naxey cam. ");
INSERT INTO huvNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Aton sasaj icon, alinoic nüt aliüc xeyay palpálwüx nipilan imiün nonüt, imiün noleat, apchetemoj maquiüjpüw teat Abraham, teat Isaac, teat Jacob tiül cielo tiül micambaj Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Pero altiül nipilan judío leaw apiüngüw apmajlüyiw tiül micambaj Teat Dios, apmajlosüw tiül pojniün, quiaj apmajiüntsüw, apmenchicnchic olüiquiw nejiw ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Condom quiaj Teat Jesús tasaj aaga natang soldado: ―Quiür ijtsor, cos teyar sandeac atquiaj apmajlüy ―aw. Aaga nerang minajiüt nej a soldado tíülan aaga ores quiaj tajneaj. ");
INSERT INTO huvNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Condom quiaj tamb Teat Jesús andüy aniüng Pedro. Quiaj tajaw niün andeow najtaj miocuats Pedro, alwüx mats, tenguial müüch nej nerraar. ");
INSERT INTO huvNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Quiaj Teat Jesús tamb marreeg owix aaga najtaj, ajneaj wüx üüch nej nerraar. Quiaj witiüt tarang nej üetiw. ");
INSERT INTO huvNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Wüx langwiiüts taquiüjpüw mamb niüng ajlüy Teat Jesús xeyay nipilan leaw alwüx ombasüw nejiw nimeech. Quiaj tawün nimeech wüx ombasüw nipilan wüx mipoch nej, at aton tataag majneaj meáwan moniün andeow. ");
INSERT INTO huvNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Atquiaj tarang para alndom majlüy atnej tarang nomb tiül minawiig nej teat Isaías, aaga nendeac andeac Teat Dios, cos tapiüng: “Nejáyan quiaj tawün iün andeowaats, aton tajoy wüx ombas nej meáwan necoy ocueajiiüts”, aw. ");
INSERT INTO huvNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Wüx tajaw Teat Jesús laxeyay nipilan alniüng ajlüy nej, quiaj tasaj minipilan nej: ―Tabaats amongoots andüy necamb a nadam yow quiaj ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Quiaj ajngot nop naxey nendüy wüx aaga poch tüünd Moisés. Tasaj Teat Jesús: ―Teat Naxey, xique sanandüüb ic mamb leaw niüng apmeamb ―aj. ");
INSERT INTO huvNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Quiaj tasaj nej Teat Jesús: ―Wiül ajiür ombiüm nej, at a quiec aton; nganüy a Teat Naxey ngo majiür nguiane mapiib omal ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Nop minipilan nej tasaj nej: ―Teat, sandiüm nacül leaw ndoj andeow xeteat namiüt; quiaj sanandüüb ic ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Quiaj tasaj nej Teat Jesús: ―Tabar nganüy indüüb xic, icueat, ich majlüy mondeow memiütayej nejeyéjan quiaj ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Condom quiaj tajtep tiül müx Teat Jesús, tambüw maquiüjpüw nej minipilan nej. ");
INSERT INTO huvNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Aleambüw tiül ndec, quiaj taw noic nadam iünd, anmachaachaach tiül müx omal yow, pero Teat Jesús almameay. ");
INSERT INTO huvNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Quiaj tambüw minipilan nej mapacüjchiw nej, tasajüw: ―¡Teat, imbeol xicon; laliüc tsoyomoots tiüt! ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Quiaj tasaj nejiw: ―¿Neol termbolana? ¿Neol tapateay iyacan imeajtsan wüx xique? ―aj nejiw. Condom quiaj witiüt. Talic a iünd lombom, at a yow majlǘyan. Quiaj lambat. ");
INSERT INTO huvNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ajcüwa monxey mbayatoj, tapiüngüw: ―¿Cuame nipilan nej aaga naxey quiaja? Cos iünd at a yow ayariw nej andeac ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Wüx tajtepiw necamb aaga nadam yow quiaj tiül iüt Gadara, quiaj tajngotoj ijpüw monxey imiünüw tiül niüng amiüraad mondeow. Alwüx ombasüw nimeech, lamüüch nejiw michachiw. Nejiw xowüy lapatüw, nejinguind ngondom mamong amb tiül aaga tiiüd quiaj. ");
INSERT INTO huvNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Wüx tajngotoj, tendeacüw napac, tapiüngüw: ―¿Cuane indiüm merang wüx ximbasan a ique Jesús micual Teat Dios? ¿Neol tewiün meaach xicon namongochiün ngo majneaja, sitiül nganaw matüch a nüte? ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Alquiaj noic ajlüy sow tenguial üetiw, miünquiájan tam niüng ajlüyiw nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Quiaj a nimeech tatüniw nej ocueaj, tasajüw nej: ―Sitiül apmewün xicon, iich xicon namban najmeliün tiül a sow quiün ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Quiaj tasaj nejiw Teat Jesús: ―Quiüran ―aw. Quiaj tambüw tandüyiw tiül a sow. Almajmeliw tiül, quiaj tecuiürrüw a sow, ambüw wüx tiüc tajmiücüw tiül yow, tümb mandeowüw. ");
INSERT INTO huvNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Condom ajcüwa monjiür sow mbayajow; quiaj tecuiürrüw andüyiw tiül cambaj. Tapots masajüw nipilan cuane tajlüy; at tapiüngüw nguineay tarangüch wüx ombasüw ajcüw leawa üüch nejiw michachiw nimeech. ");
INSERT INTO huvNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Quiaj tambüw majawüw Teat Jesús meáwan nipilan imiünüw tiül a cambaj quiaj. Wüx tapeayiw quiaj, tatüniw ocueaj maw quiaj tiül miiütüw nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Condom quiaj tandilil alinomb Teat Jesús majtep tiül müx, tamongoj andüyiw necamb, tandüyiw tiül micambaj nej Capernaum. ");
INSERT INTO huvNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Almapeayiw quiaj, quiaj taquiüraab niüng ajlüy nej nop naxey ndron ombas, amb wüx mats. Teat Jesús tajaw nguineay ayacüw omeajtsüw wüx nej, quiaj tasaj a niün andeow: ―Ich mapac imeaats, xecual, cos lanawün isoet ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Wüx tanguiayiw aag ayaj, acas mondüy wüx aaga poch tüünd Moisés tandeacüw nejíwan quiaj, tapiüngüw: “Aaga naxey quiaj xeyay ngo majneaj andeac, cos andeac atnej nej Dios nej”, awüw. ");
INSERT INTO huvNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Teat Jesús tajaw cuane tenguial mapiüngüw tiül omeajtsüw, quiaj tasaj nejiw: ―¿Neol tendeacan atquiaj tiül imeajtsana? ");
INSERT INTO huvNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Cuane ngo maél iyajcan nasaj, nasaja: “Isoet lanawün”, ngwüy nasaja: “Witiür, ijüy”, naja? ");
INSERT INTO huvNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Nganüy apmejawan a Teat Naxey naleaing alndom mawün nisoet ningüy wüx iüt ―aw. Quiaj tasaj a niün andeow: ―Witiür, ixaing mimats, quiür ijtsor ―aj. ");
INSERT INTO huvNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Quiaj witiüt tajtsor. ");
INSERT INTO huvNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Nipilan wüx tajawüw aag ayaj mbayatoj. Tandeacüw xeyay najneaj wüx Teat Dios, cos lamambeol nop nipilan ndoj ombas marang aag ayaj. ");
INSERT INTO huvNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Almaw quiaj Teat Jesús, quiaj tajaw nop naxey nenüt Mateo, alchetem wüx bang niüng angüyeran mitomiün cambaj. Quiaj tasaj: ―Mac tabar ―aj. Quiaj witiüt a naxey quiaj, tamb maquiiüb nej. ");
INSERT INTO huvNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Alinoic nüt Teat Jesús alchetem tiül nden, tenguial üetiw maquiiüb minipilan nej. Aliw quiaj xeyay monsap mitomiün cambaj; at aliw quiaj aton xeyay nipilan monrang ngo majneaj. Nóiquian tenguial üetiw maquiüjpüw. ");
INSERT INTO huvNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Wüx tajawüw aag ayaj a fariseos, quiaj tasajüw minipilan nej Teat Jesús: ―¿Neol minatangan nequiaach icon tapots üet aweaag monsap mitomiün cambaj, at aldemás nipilan leaw ngo mayambüw Teat Dios? ―ajüw. ");
INSERT INTO huvNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Wüx tanguiay aag ayaj Teat Jesús, quiaj tasaj nejiw: ―Leaw ayaag najneaj ajlüy ngo metam mayamb nejaw nej, áagan nipilan leaw ayaag niün andeow mbich netam mayamb nejaw nej. ");
INSERT INTO huvNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Quiüran iyamban imeajtsan cuane amb apiüng aaga poch cam: “Xique sandiüm merjiürayon lasta, ngome áagan iyacan erchechiün”, aw. Xique ngo niün nayamb leaw ayaag najneaj arang, xique xiün nayamb leaw monrang ngo majneaj, nüüch leaam omeajtsüw nguineay tenguial marangüw, para marangüw leaw andiüm Teat Dios ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Condom quiaj tapeayiw niüng ajlüy nej minipilan Juan aaga neech yow nipilan, tasajüw nej: ―Teat, xicona saiündan xeyay, at nipilan fariseos aton. Jow nganüy minipilan, ¿neol ngo maiündüwa? ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Teat Jesús quiaj tasaj nejiw. Tapiüng: ―¿Alndom nop nengoch owixe mamix omeajtsüw miamigo neje sitiül nej alquiaj almaquiüjpüwa? Alinoic nüt wüx lango majlüy a nench, aaga nüt quiaj mbich apmaiündüw. ");
INSERT INTO huvNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","’Nejinguind ngondom macancham tiül noic nguirich napixeran quiripite jayats jael, cos aag ayaj sitiül apmacanchamaran tiül, wüx aptsontsocom, quiaj apmachiüt alquiriw aaga nguirich jael quiaj. ");
INSERT INTO huvNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","At aton ngondom mayacaran jayats vin tiül nguirich taag iquial vin, cos sitiül apmajmel tiül, apchiütam a taag, condom quiaj apmajünch tiüt a vin, at a taag aton apndrom ombas. Ngwüy, jayats vin netam majmel tiül jayats taag; quiaj ngome apndrom ombasüw, apmaiücüw noic miün ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Teat Jesús tenguialeámban mandeac aag ayaj masaj nejiw, quiaj ajngot nop naxey, natang nenajiüt tiül nipilan judío, maquieel micos nej tiüt teombas nej, tapiüng: ―Teat, xecual les tandeow. Tabar teat, meyac iwix wüx ombas nej mepacüüch ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Quiaj witiüt Teat Jesús, tandüüb mamb a naxey quiaj, at minipilan nej tandüjpiw nej mamb aton. ");
INSERT INTO huvNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Quiaj ajngot nop najtaj niün andeow, lamajiür gajpic (12) neat tatow majiür, xeyay atsambiich nej miquiej nej. Quiaj tatüch niüng ajlüy Teat Jesús amb wanopech marreeg apix. ");
INSERT INTO huvNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Cos tapiüng tiül omeaats: “Sitiül narreeg masey apix nej, quiaj sanajneaj”, aw. ");
INSERT INTO huvNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Teat Jesús ndiliteay majaw, tasaj nej: ―Xecual, ich mapac imeaats, nganüy lerneaj cos teyac imeaats wüx xic ―aw. Quiájan tajneaj a najtaj nómban. ");
INSERT INTO huvNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Wüx Teat Jesús tapeay aniüng aaga natang nenajiüt quiaj, tajaw aliw quiaj monind at xeyay nipilan ancayajyaj. ");
INSERT INTO huvNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Quiaj tasaj a nipilan: ―Iriowan ningüy, aaga nüx cam ngome landeow, nej almameay ―aj nejiw. Nipilan quiaj titsojow nej. ");
INSERT INTO huvNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Wüx laawüw meáwan nipilan, quiaj Teat Jesús tajmel tiül iüm. Condom tasap owix a nüx mawitich. Quiaj witiüt a nüx. ");
INSERT INTO huvNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Meáwan cambaj najlüy quiaj tanguiayiw nguineay lamarang Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Teat Jesús almaw quiaj, tandüjpiw nej mamb ijpüw monxey nesombüw. Tenguial apajüw masajüw nej: ―¡Teat naxey micual David, ijiür xicon lasta! ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Wüx tapeay tiül nden, tapeayiw niüng ajlüy nej ajcüwa monxey nesombüw quiaj. Quiaj Teat Jesús tasaj nejiw: ―¿Ipiüngana naleaing xique alndom narang aag ayaja? ―aj nejiw. Quiaj tapiüngüw: ―Ajaj teat, sapiüngan alndom ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Quiaj Teat Jesús tayac owix wüx oniüjcüw nejiw, tasaj: ―Sitiül atquiaj iyajcan tiül imeajtsan, atquiaj apmajlüy ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Quiaj rat oniüjcüw. Condom Teat Jesús tasaj nejiw, tapiüng: ―Ijawan, nde mesajan nejinguind ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Pero nejiw almawüw quiaj, tapots mandeacndeacüw wüx aag ayaj meáwan tiül aaga iüt quiaj, manguiayeran nguineay tarang Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Almawüw quiaj ajcüwa monxey quiaj, quiaj ajngot maquiüraab miün nop naxey alwüx ombas nej nimeech, lamüüch nej mejew. ");
INSERT INTO huvNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Quiaj Teat Jesús tawün nimeech wüx ombas a naxey quiaj, tajneaj mendeac. Meáwan nipilan mbayatoj majawüw, tapiüngüw: ―Ngomeaag ajlüy tiül micambajaats Israel atquiay quiaj ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Pero ajcüwa fariseos tapiüngüw: ―Aaga naxey quiaj alndom mawün nimeech cos minatang nimeech tenguial mambeol nej ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Teat Jesús tajüy tiül meáwan cambaj, tiül rünch aton, maquiaach nipilan tiül palpálwüx sinagoga. Tandeac xeyay najneaj poch manguiayeran nguineay alndom majlüyeran tiül micambaj Teat Dios. Aton tamongoch palpálwüx monandeow, at meáwan necoy tandendiich. ");
INSERT INTO huvNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Wüx tajaw nguineay ajlüyiw meáwan nipilan, tajiür nejiw lasta, cos ajcueatíwan, ngo majlüyiw nóiquian, at nejiw sap ngo majlüy wüx nop nejiür nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Quiaj tasaj minipilan nej, tapiüng: ―Naleaing sasaj icon, najiüt ajlüy xeyay, pero monrang najiüt napateay. ");
INSERT INTO huvNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Itüniün ocueaj a teat neneay najiüt müüch miün xeyay monrang najiüt ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Condom quiaj Teat Jesús tawün gajpiüp (12) naw tiül minipilan nej, tüüch nejiw ndoj ombasüw mawüniw nimeech wüx ombas nipilan, at aton mamongochiw cuajantanej monandeow at necoy. ");
INSERT INTO huvNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ajcüwa gajpiüp (12) apóstoles atcüy minütiw nejiw: nop Simón aaga nasoic Pedro, aquiiüb Andrés michiig nej; alinop Jacobo, at a Juan michiig nej, micual nejiw Zebedeo. ");
INSERT INTO huvNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Aton Felipe, Bartolomé, Tomás; at Mateo aaga tarang nesap mitomiün cambaj; Jacobo micual Alfeo; Lebeo aaga nasoic Tadeo; ");
INSERT INTO huvNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","aton Simón naw tiül noic ajlüy nipilan nasoiquiw Cananista; at a Judas Iscariote aton, aaga ndoj tayac Teat Jesús teowixaw monajiüt. ");
INSERT INTO huvNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ndoj quiaj Teat Jesús tüüch mambüw ajcüwa gajpiüp (12) minipilan nej, tasaj nejiw: ―Nde meamban tiül miiütüw nipilan ngome Israel, aton nde mejmeliün tiül nicuajind cambaj tiül iüt Samaria. ");
INSERT INTO huvNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Quiüran ombas, imbeolan ajcüwa nipilan judío, cos nejiw ajlüyíwan at nejiw najcueat sap. ");
INSERT INTO huvNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Quiüran isajan nipilan laliüc matüch a nüt majlüy wüx micambaj nej Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Aton itajcan majneaj leaw axom nejiw napat monandeow nasoic lepra, at cuajantanej monandeow. Ipacüjchiün leaw landeow, iwüniün nimeech wüx ombas leaw alwüx ombas nej nimeech. Xique sǘüchan icon ndoj imbasan merangan meáwan aag ayaj, ata icona nganüy imbeolan nipilan, nde metüniün nicuajind. ");
INSERT INTO huvNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Nde mejoyiün tomiün, nde mejoyiün oro, nde mejoyiün plata, tengwüy bronce. ");
INSERT INTO huvNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Nde mejoyiün minchiüjtsan tiül tiiüd, aton nde mejoyiün ijquiaw camix. Átan nde mesoijquiün napüic, nde mejoyiün ingotan. Cos leaw nerang najiüt netam mawiülaran. ");
INSERT INTO huvNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Wüx apmepeayiün tiül noic cambaj, tengwüy tiül noic rünch, iyamban jane apmexoman quiaj leaw ajneaj omeaats majaw icon. Ixojtan aniüng nej; naw quiaj apmeriowan wüx lamatüch a nüt meriowan. ");
INSERT INTO huvNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Wüx apmejmeliün tiül noic nden ertepeayiün, itüniün monapacüy. ");
INSERT INTO huvNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Sitiül apac omeajtsüw majawüw icon, itüniün monapacüy; sitiül ndot ngo mandiümüw icon nde metüniün. ");
INSERT INTO huvNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Sitiül ngo mandiümüw mangochiw icon, ngo mandiümüw manguiayiw leaw apmesajan, iriowan tiül aaga nden quiaj, tengwüy tiül aaga cambaj quiaj. Itajtan quiaj minajndot ileajiün. ");
INSERT INTO huvNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Naleaing sasaj icon, wüx nüt apmajaraw wüx asoeteran, alwüx quiriw apateay ngo majneaj apmamongochiw monaw cambaj Sodoma maquiiüb Gomorra, ngo mat nejiw ajcüwa nipilan quiaj. ");
INSERT INTO huvNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","’Nganüy xique süüch icon meamban at icon sap indüyiün tiül tegüy sampüy. Netam mejlüyiün at icon ndiüc leawa necuiür nexotüy, ngo majlǘyan ndeaam. Aton irangan atnej arang palom, cos palom ngo marangüw ngo majneaj wüx ombas alinop. ");
INSERT INTO huvNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ijawan wüx ajcüwa nipilan quiaj, cos apmayacüw icon teombasüw monajiüt, apmawüjchiw icon tiül sinagogas. ");
INSERT INTO huvNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Aton apmaquiüjpüw icon teombasüw montangtang monajiüt cos iyariün sandeac. Atquiaj alndom mendeacan xic wüx manguiayiw ajcüwa montangtang monajiüt, at palpálwüx nipilan leaw ngome judío. ");
INSERT INTO huvNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Naleaing wüx apmayacüw icon teombasüw monajiüt, nde meyambyamban imeajtsan mepiüngan cuane apmepiüngan, nguineay apmendeacan, cos wüx apmerndeacan, quiaj Teat Dios apmüüch icon poch cuane apmepiüngan. ");
INSERT INTO huvNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Cos ngome icona apmerndeacan, Nangaj Miespíritu Miteatiiüts Dios apmendeac tiül icon. ");
INSERT INTO huvNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Nachiigueran apmayac teowixaw monajiüt micoj nej mandeow. At nateateran apmayacüw teowixaw monajiüt micual nej mandeow. Nacualaran aton apmayacüw teowixaw monajiüt miteatiw nejiw mandeow. ");
INSERT INTO huvNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Meáwan nipilan apmajcüyiw majawüw icon cos iyariün sandeac. Jane ngo macueat xic, jane apmaíüc wüx mamongoch meáwan aag ayaj leawa ndoj, apmaw wüx. ");
INSERT INTO huvNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Wüx ayambüw imbasan tiül noic cambaj alndom mercuiürran indüyiün tiül alinoic cambaj. Naleaing sasaj icon, nganaw membichan mejüyiün tiül meáwan cambaj tiül iüt Israel, quiaj apmandilil Teat Naxey. ");
INSERT INTO huvNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Nop nequiajchay ngome alwüx ajaw, napateay ajaw; nganüy nequiaach nej alwüx ajaw. Aton nop nerang najiüt ngome alwüx atam, napateay atam; nganüy aaga neneay najiüt alwüx atam. ");
INSERT INTO huvNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Nop nequiajchay ich mapac omeaats sitiül lamatüch ajaw nequiaach nej, nde matün wüx alquiriw; at nop nerang najiüt aton netam mapac omeaats sitiül lamüünd marang leawa netam, atnej neneay najiüt, nde mandiüm mamong wüx. Sitiül nateateran tasoic nimeech nej, nenüt Beelzebú, ¿jowa nganüy a micual neje, cuane ngome apmasoiquiwe? ");
INSERT INTO huvNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","’Nde mermbolan mendüyiün ajcüwa nipilan, cos leaw ngo majüic nganüy apmajüic alinoic nüt; aton leaw nganüy ngo majüic alinoic nüt apmajaraw. ");
INSERT INTO huvNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Leaw tenguial nasaj icon nganüy wüx icóotsan quiaj cam, alinoic nüt netam mesajan meáwan nipilan. Leaw tenguial nandex tiül ilajcan nganüy, alinoic nüt netam mendeacan napac manguiay meáwan nipilan. ");
INSERT INTO huvNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Nde mermbolan mendüyiün leaw alndom mambiy icon, cos espíritu ngondom mandeow. Leaw naleaing netam mermbolan mendüyiün, aag ayaj leaw alndom mandrooch imbasan, at miespíritujan tiül biümb. ");
INSERT INTO huvNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’¿Neol, ngome noic tomiün ombeat ijquiaw nine quiec ajnapa? Naleaing sapiüng ngo majmiüc masey noic tiül nejiw mandeow sitiül Teat Dios ngo mandiüm. ");
INSERT INTO huvNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Aton meáwan miondeats omalaran nateoraw. ");
INSERT INTO huvNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Pares sapiüng nde mermbolan cos icona alwüx ermbeatiün ngo mat icon ajcüwa nine quiec quiaj. ");
INSERT INTO huvNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’Jangantanej leaw ngo mexotüy wüx ayar sandeac masaj nipilan, xique aton sanasaj Xeteat najlüy tiül cielo xenipilan nej. ");
INSERT INTO huvNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Aton jangantanej leaw apmarang atnej ngo metam nej xic, ata xique aton sanasaj Xeteat najlüy tiül cielo ngome xenipilan nej. ");
INSERT INTO huvNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","’Nde mepiüngan xique xiün nüüch majlüy monajneaj wüx aaga iüt cam. Ngwüy, xique ngo niün nayac monajneaj wüx iüt, xique xiün nayac moncüy. ");
INSERT INTO huvNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Cos áag tiünas, altiül naxey apmajcüy aweaag miteat nej, ata nüx apmajcüy aweaag mimüm nej; at altiül mintaj nacualaran apmajcüy aweaag mimümüw nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Nop naxey tiül nden miün apmajiür moncüy majaw nej. ");
INSERT INTO huvNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Jane alwüx andiüm miteat nej mimüm nej, pero napateay andiüm xic, aag ayaj ngo membeat marang xenipilan. At aton leaw alwüx andiüm micual nej, napateay andiüm xic, aton ngo membeat marang xenipilan. ");
INSERT INTO huvNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","At jane ngo mandiüm mamongoch meáwan naél masey mambiyaran wüx cruz cos ayar sandeac, aag ayaj ngo membeat marang xenipilan. ");
INSERT INTO huvNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Sitiül aljane ngo mayar sandeac cos imbol mandeow, nej wüx apmandeow apmamongoch xeyay ngo majneaj tiül biümb meáwan nüt. Pero sitiül aljane ngo mapiüng wüx, masey mandeow cos ayar sandeac, nej alinoic nüt apmajlüy xeyay najneaj tiül cielo. ");
INSERT INTO huvNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","’Jane apmayar indeacan, sandeac ayar aton. Jane ayar sandeac, ayar andeac neech xic niün. ");
INSERT INTO huvNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Jane apmayar andeac nop nendeac andeac Teat Dios cos ajaw Teat Dios neech nej miün, nej apmüünd atnej leaw apmüünd aaga nendeac andeac Teat Dios quiaj. Aton sitiül aljane apmayar andeac nop nerang minajiüt Teat Dios cos ajaw tenguial marang najneaj, nej aton apmüünd atnej apmüünd aaga nerang minajiüt Teat Dios quiaj. ");
INSERT INTO huvNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Aton jangantanej leaw apmüüch masey tegüy yow manganeowüw ajcüwa namix nine quiaj, cos ajaw xenipilan nejiw; naleaing sasaj icon, nej ngome apmajnot ocueaj leaw apmüünd ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Wüx Teat Jesús landoj masaj nejiw cuane netam marangüw ajcüwa gajpiüp (12) minipilan nej, quiaj taw quiaj, tamb maquiaach nipilan tiül meáwan cambaj tiül aaga iüt quiaj. ");
INSERT INTO huvNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Juan, aaga neech yow nipilan, altiül manchiüc. Wüx tanguiay nguineay tenguial marang Teat Cristo, quiaj tüüch mambüw ijpüw minipilan nej majawüw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Tatüniw nej manguiayiw, tasajüw: ―¿Teat, ique aaga Cristo leaw aliüc miüna, ngwüy netam nacüliün alinopa? ―ajüw. ");
INSERT INTO huvNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Quiaj Teat Jesús tasaj nejiw: ―Quiüran isajan teat Juan meáwan leawa temejawan at leawa temenguiayiün. ");
INSERT INTO huvNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Isajan nguineay larraw oniüjcüw leaw nesomb, leaw necoex lajüy, leaw nexom nej napat monandeow nasoic lepra lajneaj, leaw nelaag lamanguiay, at aton leaw tandeow nganüy lapac, at ajcüwa nipilan ngo majiürüw tenguial manguiayiw nguineay alndom maw asoetiw nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Najneajay ajlüy leaw ngo machiw omeaats wüx xique ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Wüx laambüw minipilan Juan, quiaj Teat Jesús tapots mandeac masaj nipilan wüx Juan, tapiüng: ―¿Cuane teamban mejawan tiül wajchiüca? ¿Ngwüy tejawan nots najchowa tenguial majowjow nej iünda? ");
INSERT INTO huvNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Ngwüy, cuane teamban mejawana? ¿Tejawan nop naxey asooig najneajay apix neje? Icona ijawan leaw asooig najneaj apix nej aag ayaj najlüy aniüng nop natang nenajiüt. ");
INSERT INTO huvNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Ngwüy, cuane teamban mejawana? ¿Teamban mejawan nop nendeac andeac Teat Diosa? Ajaj áag, naleaing nej alwüx atam ngo matnej nop nendeac andeac Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Cos wüx aaga Juan quiaj, andeac aaga poch narangüch tiül minawiig Teat Dios, niüng apiüng: Xecual, sanüüch mamb nop nejoy xepoch mamong ombas, teoj iliüc. Nej apmataag majneaj mitiiüd apmemong tiül. ");
INSERT INTO huvNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Naleaing sasaj icon, tiül meáwan nipilan ngo maw tiül nop majntsop wüx atam ajlüy matnej atam a Juan. Pero naleaing tiül minipilan Teat Dios, leawa chingüy aag ayaj alwüx atam ngo matnej a Juan. ");
INSERT INTO huvNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Ajan wüx tiün a Juan andüy miün cam, xeyay nipilan tenguial apacüw wüx majmeliw tiül micambaj Teat Dios. Pero leaw ngo mimboloj, ajcüw ayaj alndom majmeliw. ");
INSERT INTO huvNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Cos meáwan mondeac andeac Teat Dios, at a poch tüünd Moisés tandeacüw wüx leaw aliüc miün apmajlüy aleaw niüng tapeay a Juan. ");
INSERT INTO huvNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Nganüy sitiül icona indiüman meyariün, apmejawan nej aaga Juan quiaj tiün atnej Elías leaw lapiürang aliüc. ");
INSERT INTO huvNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Netam menguiayiün at mexoman imeajtsan wüx leaw sandeac quiaj. ");
INSERT INTO huvNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’¿Cuane at nejiw sanapiüng wüx ajcüwa nipilan monlüy nganüy cama? Cos at nejiw namix monguich montsoj tiül plas, tenguial masajüw aquiüjpüw nejiw, ");
INSERT INTO huvNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","apiüngüw: “Xicona tenguial saindean pero icona ngo mejiüngan; átan sajiüntsan pero icona ngo merangan amix imeajtsan”, awüw. ");
INSERT INTO huvNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Cos tiün a Juan, nej nguiaj ngo met ngo manganeow, icona tepiüngan nej alwüx ombas nej nimeech. ");
INSERT INTO huvNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Nganüy tiün a Teat Naxey, nej üet aweaag jangantanej, at anganeow aweaag. Icona ipiüngan nej nerrombüy nangüngün; ajlüyay maquiiüb nipilan leaw ngo mayamb Teat Dios, at monsap mitomiün cambaj. Alinoic nüt apmajüic sitiül najneaj sandeac, sitiül sajiür fis, at apmajüic sitiül najneaj sarang tengwangwüy ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Condom quiaj Teat Jesús tapots mandeac wüx ajcüwa cambaj niüng lamarang xeyay ateócan, cos ajcüwa nipilan quiaj ngo macueatiw marangüw ngo majneaj, ngo mayariw andeac nej. Tapiüng: ");
INSERT INTO huvNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","―¡Jaa, icona monaw tiül cambaj Corazín! ¡Jaa, icona monaw tiül cambaj Betsaida! Cos jondot tiül cambaj Tiro y Sidón tarangüch meáwan ateócan leaw tarangüch tiül icona, catsats tsotojow tiül ngwiat masoijquiw nambeor apixaw nejiw majüiquichaw leaaw omeajtsüw wüx meáwan ngo majneaj tenguial marangüw. ");
INSERT INTO huvNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Áag sasaj icon, alinoic nüt wüx apmajaraw wüx asoeteran, napateay quiriw ngo majneaj apmamongochiw monaw Tiro y Sidón, ngo matnej icona. ");
INSERT INTO huvNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ata icona monaw cambaj Capernaum, ¿iyajcan icona apmeamban tiül cielo? ¡Niquimas! Aleáingan apmejlosan tiül aaga xeyay ngo majneaj, tiül mondeow. Cos sitiül ndot tiül cambaj Sodoma marangüch ateócan atnej tarangüch tiül icona, Sodoma aliün majlüy nganüy. ");
INSERT INTO huvNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Áag sasaj icon nganüy, alinoic nüt wüx Teat Dios apmajaw wüx asoeteran, napateay quiriw ngo majneaj apmamongochiw nipilan monaw Sodoma, ngo matnej icona ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Tiül aaga nüt quiaj Teat Jesús tasaj Teat Dios, tapiüng: ―Xeyay najneajay irang Teat, ique natang nenajiüt tiül cielo at wüx iüt. Cos meáwan leawa lajlüy quiaj, texot ngo meaach majawüw leaw mondüy, leaw monxomxom omeaats. Nganüy lameaach majawüw ajcüwa atnej nine monguich quiaj. ");
INSERT INTO huvNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Najneaj Teat, cos atquiaj indiüm ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Condom tapiüng: ―Meáwan cuajantanej leaw almajlüy, xeteat lamayac tiül xiwix. Nejinguind ngo majaw jane xic, áagan xeteat ajaw. Aton nejinguind ngo majaw jane xeteat, xíquian quiaj sajaw, ata nejiw leawa xique sandiüm nüjchiw majawüw. ");
INSERT INTO huvNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Macaron niüng sajlüy leawa laǘmb apac marang cuajantanej, leaw ajiür xeyay naél. Xique sanüüch maxood. ");
INSERT INTO huvNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Iyariün sandeac, irangan leaw sanaquiaach icon, cos xique xeyay ajneaj ximeaats ngo nerangrangüy. Quiaj apmajneaj imeajtsan, apmexojtan. ");
INSERT INTO huvNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Cos leawa xique sandiüm merangan, aag ayaj ngo maél; ngome apaxiüm merangan leawa sapiüng ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Tiül aaga nüt quiaj wüx noic nüt axoodaran, Teat Jesús tamong amb tiül noic corrül. Minipilan nej tind üetiw, quiaj tapots majeliw natang aól trigo matajtüw müetiw. ");
INSERT INTO huvNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ajcüwa fariseos wüx tajawüw aag ayaj, quiaj tasajüw Teat Jesús, tapiüngüw: ―Ijaw minipilan nguineay tenguial marangüw wüx nüt axoodaran, aag ayaj ngondom marangüw ―ajüw. ");
INSERT INTO huvNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Nej tasaj nejiw: ―¿Neol ngomeaag meteowana tiül Mipoch Teat Dios mejawan nguineay tarang mixejchiiüts David wüx nej tind üete, at leaw almaquiüjpüw nej atona? ");
INSERT INTO huvNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Nejiw tajmeliw tiül nangaj iüm, tüetiw pan leawa najmel marang nichech ocueaj Teat Dios; aag ayaj nejinguind ngondom müet, áagan miteaats alndom müetiw. ");
INSERT INTO huvNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Neol ngomeaag meteowan tiül a poch tüünd Moisés nguineay arangüw miteaats tiül nadam nangaj iüma? Cos masey nüt axoodaran nejiw netam marangüw najiüt, aag ayaj ngome nisoet. ");
INSERT INTO huvNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Xique sasaj icon nganüy ajlüy ningüy nop alwüx atam, ngo matnej aaga nadam nangaj iüm. ");
INSERT INTO huvNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Icona ngo mejawan cuane amb apiüng Mipoch Teat Dios niüng apiüng: “Xique sandiüm mejiürayon lasta, ngome áagan iyacan erchechiün”, aw. Sitiül icona tejawan aag ayaj, ngome apmeyacan asoet jane ngo marang nicuajind. ");
INSERT INTO huvNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Aaga Teat Naxey alwüx atam, ngo matnej aaga nüt axoodaran quiaj ―aw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Condom Teat Jesús taw quiaj, tamb andüy tiül sinagoga ocueaj nipilan judío. ");
INSERT INTO huvNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Alquiaj nop naxey ndron ombas, nechey nots owix. Quiaj tatüniw manguiayiw Teat Jesús, tasajüw: ―¿Alndom mamongocharan iün andeow nipilan wüx nüt axoodarana? ―ajüw nej. Tapiüngüw aag ayaj cos andiümüw maxomüw cuane wüx alndom mayacüw asoet. ");
INSERT INTO huvNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Teat Jesús tasaj nejiw: ―Jondot nop tiül icona almajiür nop sap, ndot majmiüc ocueaj nej tiül noic lol wüx nüt axoodaran, ¿quia ngondom majmele maxaingue? ");
INSERT INTO huvNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Sitiül sap alndom majwan, jow nipilan, cuane wüx ngondom mambeolaran. ¿Neol ngwa alwüx atama? Naleaing alndom marangüch noic najneaj wüx nüt axoodaran ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Condom quiaj tasaj aaga ndron ombas quiaj: ―Ileainguiich iwix ―aj. Camüm maleainguiich, lajneaj nómban atanej alinots owix nej. ");
INSERT INTO huvNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Quiaj tawüw quiaj ajcüwa fariseos. Tapots mayambüw nguineay alndom mambiyaw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Teat Jesús tajaw nguineay tenguial mandiümüw marangüw. Quiaj taw quiaj, tandüjpiw nej mamb xeyay nipilan. Tamongoch iün andeow meáwan moniün andeow. ");
INSERT INTO huvNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Tasaj nejiw nde majüiquichaw jane nej. ");
INSERT INTO huvNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Atquiaj tarang para majlüy atnej lamarang wüx nawiig tanomb teat Isaías, áag nendeac andeac Teat Dios, cos tapiüng: ");
INSERT INTO huvNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Jogüy nerang xenajiüt, áag leawa lanarriiüd, xeyay sajiür nej lasta, nej üüch mapac ximeaats. Sanayac wüx ombas nej xeespíritu; nej apmasaj palpálwüx nipilan nguineay sandiüm marangüw. ");
INSERT INTO huvNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Nej ngome apmajcüy aweaag aljane, ngome apmepaj. Nejinguind ngome apmanguiay andeac nej tiül calle. ");
INSERT INTO huvNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Nej ngome apmapol masey nots tongoy najchow, ngome apmaxejquen leaw aliün mayac quiriw nasop; apmacül leaw ajlüy teowix nej micambaj nej. ");
INSERT INTO huvNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Nipilan tiül palpálwüx nación apmayacüw omeajtsüw wüx nej. ");
INSERT INTO huvNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Condom quiaj taquiüraab niüng ajlüy nej nop naxey nesomb, aton nejew, ngondom mendeac, alwüx ombas nej nimeech. Quiaj Teat Jesús tüüch majneaj a naxey quiaj, rat oniiüg at tendeac. ");
INSERT INTO huvNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Meáwan nipilan mbayatoj, tapiüngüw: ―¿Quia aag ayaj micual mixejchiiüts Davida? ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Wüx tanguiayiw aag ayaj ajcüwa fariseos, quiaj tapiüngüw: ―Aaga naxey quiaj awün nimeech cos ambeol nej Beelzebú, aaga minatang nimeech ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Teat Jesús tajaw nguineay tenguial mapiüngüw tiül omeajtsüw, quiaj tasaj nejiw: ―Meáwan montangtang monajiüt tiül noic iüt, sitiül apmbajcamoj majcüyiw nejeyéjan quiaj, apmendroochayej ombasüw. At meáwan cambaj, tengwüy tiül noic nden, sitiül mbajcamoj ngo majlüyiw nóiquian, ngome apmaiücüw, apndajrriümoj. ");
INSERT INTO huvNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Atquiaj aton sitiül nimeech apmawün alinop nimeech wüx ombasaran, ¿nguineay apmajlüyiwe? Sitiül ngo majlüyiw nóiquian, ¿nguineay alndom marangüw cuajantanej ngo majneaja? ");
INSERT INTO huvNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Sitiül naleaing Beelzebú nembeol xic nawün nimeech, isajan xic, jow minipilanan, ¿jane nembeol nejiw mawüniw nimeeche? Nejiw minipilanan apmajüiquichaw ngo maleaing ipiüngan. ");
INSERT INTO huvNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Pero sitiül Nangaj Espíritu ocueaj Teat Dios nembeol xic nawün nimeech wüx ombas nipilan, naleaing sasaj icon lamatüch icon mejmeliün tiül micambaj Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’¿Cos nguineay alndom aljane majmel aniüng nop napac naxey maneed leaw andiüm, sitiül ngome ombas maóel owix aaga naxey quiaj, cas tawün majoy leaw andiüma? ");
INSERT INTO huvNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’Jangantanej leaw ngo mandüüb xic, ajcüy majaw xic. Jangantanej leaw ngo mambeol xic wüx leaw teanaxejneng, aag ayaj teamawiich ninguiün. ");
INSERT INTO huvNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Pares sasaj icon, meáwan nisoet leaw arangüw nipilan, Teat Dios alndom mawün wüx omeaats. At cuajantanej ngo majneaj poch anderac aton alndom mawün wüx omeaats nej. Pero jane apmandeac ngo majneaj wüx Nangaj Espíritu ocueaj Teat Dios, aag ayaj mbich nómban ngondom mawün wüx omeaats nej Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Jangantanej apmandeac ngo majneaj poch wüx Teat Naxey, alndom maw aaga nisoet quiaj; pero jane apmandeac ngo majneaj wüx Nangaj Espíritu ocueaj Teat Dios, aaga nisoet quiaj mbich ngondom maw wüx ombas nej wüx aliün ningüy wüx aaga iüt cam, at alinoic nüt ngondom. ");
INSERT INTO huvNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","’Leaw xiül nüeteran aóng, sitiül najneaj atang, apmayac najneaj aóng. At noic owil xiül sitiül ngo majneaj atang apmayac ngo majneaj aóng aton. Cos noic owil xiül ajüic nguineay ajlüy wüx apmayac aóng nej. ");
INSERT INTO huvNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Cuane icona, at icon ndiüc! ¿Nguineay alndom mepiüngan cuane najneaj, sitiül icona xeyay ngo majneaj irangana? Cos leaw anderac, aag ayaj ajlüy tiül omeaatsaran. ");
INSERT INTO huvNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Nop nipilan leaw andeac najneaj ajüiquich nej xeyay najneaj altiül omeaats. Pero nop nipilan leaw andeac ngo majneaj, aag ayaj ajüiquich nej xeyay ngo majneaj altiül omeaats. ");
INSERT INTO huvNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Xique sasaj icon, alinoic nüt wüx apmajaraw wüx asoeteran, meáwan nipilan apmasajüw Teat Dios neol tapiüngüw meáwan ngo majneaj poch leaw tsajmbiüt ombeayiw mapiüngüw. ");
INSERT INTO huvNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Cos wüx mipoch apmajaraw sitiül apmajmel isoet tengwüy apmaw ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Altiül fariseos, at mondüy wüx aaga poch tayac Moisés tasajüw Teat Jesús, tapiüngüw: ―Teat, sandiüman najawan merang noic nadam ateócan ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Quiaj tasaj nejiw Teat Jesús: ―Ajcüwa nipilan monlüy nganüy monrang xeyay ngo majneaj, ngo mandüjpiw Mipoch Teat Dios, andiümüw majawüw ateócan. Naleaing nicuajind ngome apmüjndiw majawüw, áagan ateócan tajlüy wüx Jonás aaga nendeac andeac Teat Dios tajlüy nomb. ");
INSERT INTO huvNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Cos atnej Jonás tacül teomeaats nadam cüet er nüt er ongwiiüts, atquiaj Teat Naxey aton apmacül tiül loliüt er nüt er ongwiiüts. ");
INSERT INTO huvNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Alinoic nüt wüx Teat Dios apmajaw wüx asoeteran, ajcüwa nipilan monaw Nínive leaw tajlüyiw tanomb, apmayacüw isoetiün. Cos ajcüwa nipilan quiaj tayambüw Teat Dios wüx a Jonás tapaj nej ocueajiw. Nganüy ajlüy tiül icona nop alwüx xeyay atam ngo matnej a Jonás. ");
INSERT INTO huvNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Nop najtaj najlüy tanomb, natang nenajiüt nej naw cawac. Aaga najtaj quiaj wüx apmajaraw wüx asoeteran apwitiüm mayac isoetiün; cos nej imiün xeyay miünquiaj tamb manguiay najneajay mipoch aaga minatang nenajiüt nenüt Salomón. Nganüy ajlüy ningüy tiül icona nop alwüx xeyay atam ngo matnej Salomón. ");
INSERT INTO huvNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","’Nop nimeech wüx apmaw wüx ombas aljane, apmajüyjüy tiül wajchiüc mayamb nguiane apmaxood. Wüx lapaxiow ajüyjüy, ngo maxom, quiaj apmapiüng: ");
INSERT INTO huvNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“Sanandilil, sandüy tiül niüng tawas”, apmaw. Camüm mapeay quiaj, apmaxom aaga nipilan atnej nop iüm najneajay najirimb najmel mimbaj, ngo majlüy tiül nejinguind. ");
INSERT INTO huvNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Almajaw atquiaj, quiaj apmamb majan alayaíw aquiiüb nej alwüx apatüw, ngo matnej. Quiaj apmambüw andüyiw wüx ombas a nipilan quiaj. Ndójwüx aaga nipilan quiaj xeyay ngo majneaj apmajlüy, ngo matnej tajlüy nomb. Atquiaj apmajlüy wüx ajcüwa nipilan monrang ngo majneaj cam ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Teat Jesús tealeámban andeac masaj nipilan, quiaj ajngot mimüm nej y michiig nej, pero ngo majmeliw. Tapiüngüw andiümüw mandeacüw maquiüjpüw. ");
INSERT INTO huvNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Aljane tasaj nej: ―Aliw ninguiaj mimüm y michiig. Andiümüw mendeacüw chüc mequiüjpüw ―ajow. ");
INSERT INTO huvNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Quiaj tasaj aaga nesaj nej, tapiüng: ―¿Jane ipiüng xemüma, jane ipiüng xechiigue? ―aj. ");
INSERT INTO huvNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Quiaj tandic owix andüy niüng ajlüyiw minipilan nej, tapiüng: ―Jogüy ajcüw agüy xemüm, xechiig. ");
INSERT INTO huvNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Cos meáwan leawa nerang atnej andiüm Xeteat najlüy tiül cielo, ajcüw ayaj xemüm, xecoj, at xechiig aton ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Tiül aaga nüt quiaj taw tiül iüm Teat Jesús, tamb andüy mbeay nadam yow nenüt Galilea, chetem quiaj. ");
INSERT INTO huvNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Canchiütoj niüng ajlüy nej xeyay nipilan. Quiaj tajtep tiül nop müx tiül yow, chetem. Ajcüwa nipilan tacülíwan wüx iüt mbeay yow. ");
INSERT INTO huvNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Quiaj tapots mandeac masaj nejiw xeyay najneaj poch, pero ngome aleaing miün, tapiüng: ―Tajlüy nop naxey tamb apiür. ");
INSERT INTO huvNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Wüx tenguial mawiich leawa teamapiür, quiaj tajmiüc tigüy mbeay tiiüd, ndoj wüx tajngotoj quiec tambichaw mamileaw. ");
INSERT INTO huvNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Tigüy tajmiüc wüx piedra niüng ngo majlüy omeaats iüt. Tajntsop najen. ");
INSERT INTO huvNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Wüx tajntsop nüt terraar, quiaj tambel nej. Cos ngo majiür mioxiich nej, quiaj tawaag a nine soex quiaj. ");
INSERT INTO huvNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Altigüy tajmiüc tiül sats, condom tajntsop. Naleaing cos sats najen atangüw, áag taxotüw tiüt a nine soex quiaj. ");
INSERT INTO huvNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Altigüy tajmiüc tiül najneaj iüt, najneajay terangüy. Tigüy napateay taóng, altigüy tayac wüx quiriw, altigüy tayac wüx xeyay aóng. ");
INSERT INTO huvNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Netam meajchiün ilajcan, mexoman imeajtsan wüx aaga sandeac quiaj ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Condom minipilan nej tatüchiw niüng ajlüy nej masajüw: ―Teat, ¿neol tendeac atquiaj, ngome aleaíngan mesajüw nipilana? ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Quiaj Teat Jesús tasaj nejiw: ―Icona tenguial meajndiün mejawan leaw nomb ngo majüiquicharan, nguineay alndom majmeleran tiül micambaj Teat Dios najlüy tiül cielo. Pero nejiw ngome apmasoiquiw aleaing miün. ");
INSERT INTO huvNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Cos sitiül aljane ayac wüx omeaats xepoch, apmüünd manguiay maxom xeyay. Pero sitiül nop ngo mayac wüx omeaats, aaga quiriw anguiay quiaj apndrom omeaats. ");
INSERT INTO huvNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Áag tandeacas atquiaj ngome aleáingan, cos sajaw masey ajawüw ngome apmajawüw cuane, at masey anguiayiw ngome apmajawüw cuane wüx amb apiüng. ");
INSERT INTO huvNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Atquiaj alndom majlüy wüx ombasüw ajcüwa nipilan quiaj, atnej nomb tarang tiül minawiig nej teat Isaías, aaga nendeac andeac Teat Dios, niüng apiüng: Apmenguiayiün naag ilajcan, pero ngome apmejawan cuane; apmejawan naag iniüjcan, pero ngome apmejawan cuane wüx andeac. ");
INSERT INTO huvNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Cos icona xeyay adam imeajtsan; imontsotsan iniüjcan cos ngo mendiüman mejawan. Ipalan ilajcan cos ngo mendiüman menguiayiün. Ngo mendiüman meyacan imeajtsan wüx, mejawan cuane wüx amb apiüng; cos ngo mendiüman meyariün. Ngo mendiüman namongoch iün indeowan. ");
INSERT INTO huvNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Xique sasaj icon, najneajay ijlüyiün, apac imeajtsan cos icona lameajndiün mejawan, at lameajndiün menguiayiün. ");
INSERT INTO huvNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Naleaing sasaj icon, xeyay mondeac andeac Teat Dios at xeyay monyamb Teat Dios tandiümüw majawüw leaw nganüy lamejawan, pero taton ngo majawüw; tandiümüw manguiayiw leaw lamenguiayiün nganüy, pero taton ngo manguiayiw. ");
INSERT INTO huvNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","’Nganüy inguiayiün cuane wüx amb apiüng aaga sandeac wüx nepiür. ");
INSERT INTO huvNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Leaw lamanguiay anderac nguineay alndom majmeleran tiül micambaj Teat Dios, ndoj ngo mayac wüx omeaats, andǘüban ajngot a nimeech mawün wüx omeaats nej leaw lamanguiay. Aag ayaj ajlüy atnej aaga osaab soex najmiüc mbeay tiiüd. ");
INSERT INTO huvNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Nganüy aaga osaab soex najmiüc tiül piedra, aag ayaj apiüng wüx nipilan leawa anguiay Mipoch Teat Dios, andǘüban mayar, apac omeaats. ");
INSERT INTO huvNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Naleaing aaga nipilan quiaj ajlüy atnej nine soex napateay mioxiich nej. Áag ngo maíüc, camüm majlüy quiriw naél ajcan ayar Mipoch Teat Dios; andǘüban machiw omeaats. ");
INSERT INTO huvNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","At aaga osaab soex najmiüc tiül sats, aag ayaj apiüng wüx nipilan leaw anguiay Mipoch Teat Dios, pero xeyay ayac omeaats wüx mandiümndiüm cuajantanej leaw alndom maxom wüx aaga iüt cam. Quiaj lango leaam omeaats wüx Mipoch Teat Dios, lango müüch nej marang leaw Teat Dios andiüm. Aag ayaj atnej ngo mayac aóng. ");
INSERT INTO huvNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Pero aaga osaab soex leaw napiürüch tiül najneaj iüt, aag ayaj apiüng wüx nipilan leaw anguiay Mipoch Teat Dios, ayac wüx omeaats, condom aaga poch ambeol nej marang leaw andiüm Teat Dios. Aag ayaj atnej mayac xeyay aóng. Altiül taóng napateay, altigüy tayac wüx quiriw, altigüy tayac wüx xeyay aóng ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Átan tandeac Teat Jesús andüy wüx ngo majneaj soex, tapiüng: ―Micambaj Teat Dios najlüy tiül cielo ajlüy atnej tajlüy wüx nop naxey tapiür osaab trigo tiül micorrül nej. ");
INSERT INTO huvNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Naleaing aaga ongwiiüts quiaj wüx lameayiw, quiaj tamb nop najcüy majaw aaga neneay iüt quiaj, tapots mawiich tiül aaga iüt quiaj osaab ngo majneaj soex niüng lapiürüch trigo, condom cas tamb. ");
INSERT INTO huvNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Camüm matang matüch a nüt maól, quiaj lajüic ajcüwa ngo majneaj soex aliw tiül. ");
INSERT INTO huvNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Almajawüw aag ayaj monrang minajiüt aaga neneay corrül, quiaj tambüw masajüw nej: “Teat Xan, ¿neol ngwa, najneaj osaab trigo ipiüre? ¿Jow nganüy, nguia naw tajntsop ajcüwa ngo majneaj soexe?” ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Quiaj tapiüng aaga neneay corrül: “Nop ajcüy majaw xic nerang aag ayaj”, aw. Quiaj tasajüw nej monrang minajiüt nej: “¿Masey nambana nalojquiün aaga ngo majneaj soexe?” ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Quiaj nej tasaj nejiw: “Ngwüy, ich majlüy, cos sitiül apmelojquiün aaga ngo majneaj soex quiaj, alndom lojquiüm a trigo aton. ");
INSERT INTO huvNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ich majlüy matangüw nóiquian, ndoj apmawüniiüts wüx apmacojchich. Cos wüx apmacojchich, xique sanasajüw moncooch maxainguiw ombas aaga ngo majneaj soex, masojnongon noic noic ponong, maoeliw, müjchiw mandaab. Condom cas taxainguiw a trigo mayacüw tiül xetroj, sanajüw” ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Teat Jesús tandeac alinoic andeac andüy wüx mostaza, tapiüng: ―Micambaj Teat Dios najlüy tiül cielo ajlüy atnej osaab mostaza wüx nop naxey mapiür tiül micorrül nej. ");
INSERT INTO huvNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Naleaing tiül meáwan osaab soex leaw napiürüch, aaga osaab mostaza quiaj xowüy minine. Ndoj wüx apmatang apmajal oleaj, alwüx ajal oleaj tiül meáwan soex, apmatüch atnej noic owil xiül. Quiec alndom marang ombiüm wüx mipüüig nej ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Átan tandeac alinoic andeac ngome aleáingan, tandeac andüy wüx levadura, tapiüng: ―Micambaj Teat Dios najlüy tiül cielo ajlüy atnej arang levadura. Wüx nop najtaj ayac levadura tiül arej nepeax arin, aaga levadura apmüüch maxip aaga ajtsaj marang pan ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Teat Jesús atquiaj tandeac ngome aleáingan masaj nipilan. Nicuajind ngo mandeac aleáingan. ");
INSERT INTO huvNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Tandeac atquiaj para majlüy atnej lamapiüng nop nendeac andeac Teat Dios, cos tarang wüx nawiig: Xique ngome sanandeac aleáingan; sanapiüng wüx cuajantanej leaw ngo majaraw nde ajan wüx Teat Dios tarang aaga iüt cam. ");
INSERT INTO huvNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Wüx Teat Jesús landoj andeac masaj nipilan, condom tajmel tiül iüm. Quiaj minipilan nej tambüw masajüw nej: ―Isaj xicon teat, cuane wüx amb apiüng aaga leaw tendeac wüx ajcüwa ngo majneaj soex tiül corrül ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Quiaj tasaj nejiw Teat Jesús: ―Aaga nepiür najneaj osaab soex, aag ayaj Teat Naxey. ");
INSERT INTO huvNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Nganüy aaga corrül, aag ayaj andeac wüx a iüt cam. Aaga najneaj osaab soex, aag ayaj apiüng wüx minipilan Teat Dios. Pero aaga osaab ngo majneaj soex quiaj apiüng wüx minipilan nimeech. ");
INSERT INTO huvNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Aaga najcüy majaw neneay corrül nepiür ngo majneaj osaab soex, aag ayaj nejay nimeech. Aaga wüx apxaijnguiam omeaats corrül aag ayaj apiüng wüx alinoic nüt wüx apmümb minüt a iüt cam. At ajcüwa monxaing omeaats corrül, aag ayaj apiüng wüx ángeles. ");
INSERT INTO huvNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Atnej tarriüjtüch ajcüwa ngo majneaj soex majwich tiül biümb, atquiaj apmajlüy alinoic nüt wüx apmümb minüt a iüt cam. ");
INSERT INTO huvNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Aaga nüt quiaj Teat Naxey apmüüch miün miángeles nej marriüjtüw mawüniw ajcüw leaw monrang ngo majneaj, at leaw monyac wüx alinop marang ngo majneaj, mawüniw tiül minipilan nej. ");
INSERT INTO huvNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Apmajlosüw tiül biümb niüng apmajiüntsüw xeyay, apmeporros olüiquiw. ");
INSERT INTO huvNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Quiaj ajcüwa monyamb Teat Dios apmajlüyiw najneajay tiül micambaj Teat Dios, ancalitlit at nejiw achech nüt. Netam menguiayiün, mexoman imeajtsan wüx leaw sandeac quiaj. ");
INSERT INTO huvNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","’Aton micambaj Teat Dios najlüy tiül cielo ajlüy atnej nembeat tomiün naxoraad tiül corrül. Ndoj nop naxey wüx taxom aaga tomiün taton ngo mapiüng, taxot majneaj, apac omeaats, quiaj tamb manüüb meáwan leaw almajiür para alndom mangal aaga iüt quiaj maneay. ");
INSERT INTO huvNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","’Aton micambaj Teat Dios najlüy tiül cielo ajlüy atnej nop nengalüy neyamb nembeat perla. ");
INSERT INTO huvNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Cos wüx apmaxom noic perla leaw xeyay nembeat, quiaj apmamb manüüb meáwan leaw almajiür mangal aaga najneajay perla quiaj. ");
INSERT INTO huvNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","’Aton micambaj Teat Dios najlüy tiül cielo ajlüy atnej arang nots chinch wüx ajwich tiül ndec, cos apmasap cuajantanej cüet. ");
INSERT INTO huvNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Wüx lachipiow a ndoc, quiaj ajcüwa mondoc apmanotoj andüy wüx iüt. Condom apchetemoj marriüjtüw. Leaw najneaj cüet apmayacüw tiül nchep, leaw ngwüy apmawijchaw ninguiün. ");
INSERT INTO huvNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Atquiaj apmajlüy alinoic nüt wüx apmümb minüt a iüt cam. Quiaj ajcüwa ángeles apmawüniw leaw monrang ngo majneaj tiül monrang najneaj. ");
INSERT INTO huvNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Leaw monrang ngo majneaj apmajlosüw tiül biümb niüng apmajiüntsüw xeyay, at apmeporros olüiquiw ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Condom tasaj nejiw Teat Jesús: ―¿Canüy lamejawan cuane wüx sandeaca? ―aj nejiw. Quiaj tapiüngüw: ―Lanajawan teat ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Quiaj tapiüng: ―Nop nendüy wüx aaga poch tüünd Moisés, wüx laquiajchay wüx nguineay alndom majlüyeran tiül micambaj Teat Dios najlüy tiül cielo, ajlüy atnej nop nateateran tiül noic nden. Cos meáwan leaw almajiür tiül nden atam nej, altiül jayats, altiül najlüy tanomb ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Teat Jesús taw quiaj wüx landoj mapiüng wüx meáwan leawa tandeac quiaj. ");
INSERT INTO huvNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Tamb andüy tiül micambaj nej. Condom tapots maquiaach nipilan quiaj tiül a sinagoga ocueajiw nejiw. Ajcüwa nipilan wüx tanguiayiw aag ayaj mbayajow, tapiüngüw: ―¿Nguineay tendüy aaga naxey quiaja? ¿Nguiane aquiajchay ndoj ombas marang ateócan? ");
INSERT INTO huvNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Neol ngome nej micual aaga naxey nerang xiüla? Aton ngwa, ¿María minüt mimüm neje? ¿Jow Jacobo, José, Simón, Judas, ngwa michiig neje? ");
INSERT INTO huvNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Meáwan michiig montaj nej aliw ningüy maquiüjpaats. ¿Neol, jow nej nguineay ndot ombas meáwan aag ayaja? ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Pares ngome tayariw nej andeac. Quiaj tasaj nejiw Teat Jesús: ―Nop nendeac andeac Teat Dios ayarich andeac nej nguiajantanej; pero áagan tiül micambaj nej ngo mayarich andeac, at micoj nej michiig nej ngo mayariw nej andeac ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Áag ngo marang quiaj xeyay cuajantanej ateócan tiül a cambaj quiaj, cos ngo mayariw nej andeac. ");
INSERT INTO huvNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Tiül aaga nüt quiaj, aaga Herodes natang nenajiüt tiül iüt Galilea, tanguiay nguineay tenguial marang Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Quiaj tasaj monbeol nej: ―Aag ayaj a Juan neech yow nipilan lapac tiül mondeow. Áag ndot ombas marang cuajantanej ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Atquiaj tapiüng a Herodes cos alwüx omeaats nej leaw tarang. Nej tüüch mamb ndeaam a Juan, majmel tiül manchiüc, maoelich naag galen. Aag ayaj tarang cos atquiaj tandiüm a Herodías mintaj Felipe, michiig a Herodes. ");
INSERT INTO huvNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Cos Juan wüx aliün mapac tasaj a Herodes: ―Ngo majneaj mequiiüb mintaj michiig ―aj. ");
INSERT INTO huvNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Quiaj a Herodes tandiüm mambiy a Juan, pero naleaing timbol mandüy nipilan, cos meáwan nipilan apiüngüw aaga Juan quiaj nop nej nendeac andeac Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Noic nüt aaga Herodes tayac nangos nüt, arang atüch mineat nej. Nop nüx micual aaga Herodías tejiüng niüng ajlüyaran. Aaga Herodes xowüy tajneaj majaw. ");
INSERT INTO huvNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Quiaj tapiüng apmüüch aaga nüx quiaj cuajantanej leaw apmatün, aton tapaj minüt midios nej majaraw naleaing apmüüch. ");
INSERT INTO huvNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Condom aaga nüx tamb matün manguiay mimüm nej cuane netam matün. Wüx landoj manguiay, quiaj tamb masaj a Herodes: ―Teat, sandiüm membiy aaga Juan neech yow nipilan meaach xic omal nej, amb tiül noic polat ―aj. ");
INSERT INTO huvNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Masey aaga Herodes tamix omeaats, naleaing cuane apmarang cos lamapaj minüt midios nej, aton nipilan tanguiayiw. Quiaj tapiüng müünd. ");
INSERT INTO huvNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Tüüch mamb mandojquich onic a Juan tiül manchiüc. ");
INSERT INTO huvNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Quiaj tajoyiw omal a Juan amb tiül noic polat, tüjchiw a nüx, ndoj a nüx amongóchan tüüch mimüm nej. ");
INSERT INTO huvNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Condom wüx tapeayiw quiaj minipilan Juan, taxainguiw micuerpo nej maquiüjpüw mamb mamiütüw. Wüx landoj, quiaj tambüw masajüw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Wüx Teat Jesús tanguiay aag ayaj, taw quiaj, tamb amb tiül müx andüy niüng ngo majlüy nipilan. Wüx tanguiayaran laámb, quiaj tambüw mandüjpiw nej xeyay nipilan ambüw wüx iüt imiünüw tiül palpálwüx cambaj. ");
INSERT INTO huvNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Wüx Teat Jesús taw tiüt imiün tiül müx, quiaj tajaw lapeayiw quiaj xeyay nipilan. Wüx tajaw nejiw, quiaj tajmiüc omal omeaats, condom tamongoch iün andeow xeyay nipilan leaw taquiüraab niüng ajlüy nej. ");
INSERT INTO huvNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Wüx langwiiüts, quiaj tasajüw nej minipilan nej: ―Teat, lamitiüt a nüt, aton ngo macüleran ningüy. Isajüw a nipilan quiaj majtsoriw, mambüw mangalüw üetiw tiül rünch ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Quiaj tasaj nejiw Teat Jesús: ―Ngo metam mambüw, icona netam meajchiün üetiw ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Quiaj tapiüngüw: ―¿Cuane sanüjchiün? Cos áagan acoquiaw pan alijpüw nine cüet sajiüran ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Quiaj tasaj nejiw Teat Jesús: ―Ijamiünan, chiün najaw ―aj. ");
INSERT INTO huvNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Condom quiaj Teat Jesús tasaj nipilan chetemoj tiüt tiül nine soex. Quiaj tayar aaga acoquiaw pan alijpüw nine cüet, taxaing omal majaw cawüx, tüüch gracias Teat Dios. Wüx tambaag, quiaj texeyay. Condom tüüch minipilan nej majineaw müjchiw meáwan nipilan. ");
INSERT INTO huvNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Meáwan nejiw tetiw paxiün. Condom taxainguiw leaw nenaw, chipiüt gajpiüp (12) nchep. ");
INSERT INTO huvNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ajcüwa nipilan leaw tetiw atüch acoquiaw mil monxey, pálwüx montaj at namix monguich aton. ");
INSERT INTO huvNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Condom quiaj Teat Jesús tasaj minipilan nej majtepiw tiül müx mambüw ombas nejiw, nej teoj apmamb, mamongoj andüyiw necamb a nadam yow quiaj. Cos nej apmacül quiaj alquiriw metepeay aweaag nipilan leaw ümb majtsoriw, cas taw quiaj. ");
INSERT INTO huvNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Wüx laǘmb majtsoriw nipilan, quiaj tamb andüy wüx nop tiüc mandeac aweaag Teat Dios. Wüx lapojniow, Teat Jesús aliün quiaj. ");
INSERT INTO huvNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Nganüy aaga müx namb lamatüch pinawan aaga nadam yow quiaj, tenguial mapijpijliüt nej omal yow, cos xowüy lapac a iünd angochiw. ");
INSERT INTO huvNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Condom wüx landüy wüx arraw, quiaj Teat Jesús tamb matüch nejiw, ajüy amb teomal yow atnej majüy wüx iüt. ");
INSERT INTO huvNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Wüx tajawüw nej minipilan nej tenguial ajüy amb teomal yow, mbayajow tepajüw cos timboloj xeyay, tapiüngüw: ―¡Aag ayaj nembolooch! ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Teat Jesús tasaj nejiw: ―¡Nde mbayameron, cos xique, ngome aljane! ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Quiaj tendeac a Pedro masaj nej: ―Teat Naxey, ata naleaing ique, iich xic namb najüy teomal yow aton natüch ic ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Quiaj tasaj nej Teat Jesús: ―Mac, teat ―aj nej. Almanguiay aag ayaj a Pedro ajchíquian tiüt, tajüy amb teomal yow mamb matüch Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Naleaing wüx tajaw nguineay apac a iünd, timbol, tanaámb tsoyoj tiüt. Quiaj tepaj: ―¡Teat Naxey, imbeol xic! ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Quiaj Teat Jesús tandic owix nej najénan masap nej, tapiüng: ―¿Neol techiw imeaatsa; neol nganaw mejaw jane xique? ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Condom wüx tajtepiw tiül müx, quiaj lambat nómban. ");
INSERT INTO huvNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Quiaj ajcüw monlüy tiül müx taquiejliw micosüw nejiw tiüt teombas Teat Jesús, tapiüngüw: ―¡Naleaing, ique Micual Teat Dios! ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Condom andojquíwan a nadam yow, tapeayiw necamb, tiül iüt Genesaret. ");
INSERT INTO huvNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Wüx ajcüwa nipilan quiaj tajawüw nejay Teat Jesús napeay, najénan tüjchiw manguiayiw meáwan nipilan tiül a iüt quiaj. Quiaj taquiüjpüw niüng ajlüy nej meáwan moniün andeow. ");
INSERT INTO huvNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Tatüniw ocueaj Teat Jesús sitiül alndom müüch nejiw masambüw masey apix nej. Meáwan nejiw leaw tasambüw nej tajneajiw nómban. ");
INSERT INTO huvNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Noic nüt acas fariseos tambüw majawüw Teat Jesús, maquiüjpüw ajcüw mondüy wüx aaga poch tüünd Moisés, napeayiw imiünüw Jerusalén. Tatüniw manguiayiw nej: ");
INSERT INTO huvNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―¿Neol minipilan ngo mandüjpiw leaw tayacüw tanomb mixejchiiüts marangüche? ¿Neol wüx üetiw ngo majantsüw owixaw xeyay atnej ajlüyay marangaatsa? ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Quiaj tasaj nejiw Teat Jesús: ―Jow icona, ¿neol ngo merangan atnej apiüng Teat Diosa? ¿Neol tengowüjchiün para alndom mendüjpiün opech leaw tayacüw mixejchiüna? ");
INSERT INTO huvNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Cos Teat Dios tapiüng: “Iyar andeacüw miteat, mimüm, indiümüw”, aw. Aton tapiüng: “Leawa nendeac ngo majneaj wüx ombas miteat nej, mimüm nej, ich mambiyaran”, aw. ");
INSERT INTO huvNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Pero nganüy icona ipiüngan nop naxey alndom masaj miteat nej mimüm nej, mapiüng: “Leawa sajiür langondom nüüch icon, cos meáwan aag ayaj sanüüch Teat Dios”, maj. ");
INSERT INTO huvNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ipiüngan wüx aljane apmapiüng aag ayaj, lango metam mambeol miteat nej mimüm nej. Quiaj temengowüjchiün leaw andiüm Teat Dios para mendüjpiün opech leaw tayacüw mixejchiün. ");
INSERT INTO huvNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Ndeac mbeay! Naleaing leaw tarang teat Isaías tiül minawiig nej leaw Teat Dios tasaj nej, cos tandeac wüx icona wüx tapiüng: ");
INSERT INTO huvNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Ajcüwa nipilan quiaj apiüngǘwan ayariw sandeac, ngome wüx omeajtsüw, ombeayíwan. ");
INSERT INTO huvNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ngo membeat leaw arangüw wüx ayambüw xic, cos meáwan leaw aquiajchiw, aag ayaj mipochiw nejiw ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Condom Teat Jesús tapaj nipilan masaj: ―Inguiayiün, iyacan wüx imeajtsan leaw teanasaj icon: ");
INSERT INTO huvNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Cuajantanej leaw ajmel tiül ombeayaran müeteran, aag ayaj ngome nisoet; leaw ngo majneaj poch aw teombeayaran aag ayaj mbich nisoet ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Quiaj tambüw masajüw nej minipilan nej, tapiüngüw: ―¿Tejaw Teat, nguineay tajcüyiw ajcüwa fariseos wüx tanguiayiw indeaca? ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Nej tasaj nejiw: ―Cuajantanej napiürüch leaw Xeteat najlüy tiül cielo ngo mapiür, apmalojquich nómban. ");
INSERT INTO huvNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ich majlüyiw cos nejiw ajlüyiw atnej arang nop somb wüx teamanetet owix alinop somb. Cos sitiül nop somb apmanetet owix alinop somb, mijpüéj apmajmiücüw tiül loliüt ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Quiaj tasaj nej a Pedro: ―Teat, isaj xicon cuane wüx amb apiüng aaga tendeac quiaj ―aj. ");
INSERT INTO huvNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Quiaj tasaj nej Teat Jesús: ―¿Neol, at a icona aton nganaw mejawana cuane amb apiünga? ");
INSERT INTO huvNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Ngo mejawan nguineay ajlüy wüx nüeterana? Cos aag ayaj ajmel tiül ombeayaran, among teomeaatsaran, ndoj apmaw. ");
INSERT INTO huvNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Nganüy leaw ngo majneaj poch aw teombeayaran, aag ayaj mbich nisoet cos naw wüx omeaatsaran. ");
INSERT INTO huvNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Imiün tiül omeaatsaran aw cuajantanej ngo majneaj alwüx omeaatsaran. Aton altiül ambiyaw nipilan. Altiül ajiürüw minaxeyiw nejiw, minajtajüw nejiw, at altiül monüx ajlüyiw maquiüjpüw monench, at monench ajlüyiw maquiüjpüw monüx masey ngo mengoch owixaw. Aton moneed, monwaiich, at mondeac ngo majneaj wüx ombas alinop, tengwüy wüx ombas Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Meáwan aag ayaj üüch majiür nisoet nipilan. Nganüy, wüx üeteran masey ngo marangüch aaga leaw ajlüyay merangan wüx ajantsüch owixaran, cos aag ayaj mbich ngome nisoet ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Condom Teat Jesús taw quiaj, tamb andüy tiül iüt ocueaj cambaj Tiro maquiiüb Sidón. ");
INSERT INTO huvNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Quiaj tajngot majaw nej nop najtaj naw tiül iüt Canaán, nganüy acül tiül aaga iüt quiaj. Tapots apaj, tapiüng: ―¡Teat Naxey, micual David, ich majmiüc imal imeaats mejaw xic! Xecual xeyay ngo majneaj teamamongoch, alwüx ombas nej nop nimeech ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Teat Jesús ngo masaj nej nicuajind. Quiaj tatüchiw nej minipilan nej, tasajüw: ―Teat, isaj ich maw ningüy, cos aliüc almandüüb opechiiüts teapaj ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Condom quiaj Teat Jesús tapiüng: ―Xique tüjndiüs niün nambeol áagan nipilan judío, cos nejiw ajlüyiw at nejiw najcueat sap ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Quiaj aaga najtaj tamb taquieel micos nej tiüt, tapiüng: ―Teat Naxey, imbeol xic ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Quiaj tasaj nej Teat Jesús: ―Xenipilan judío ajlüyiw atnej xecual, netam nambeolüw ombas. Sitiül ngo narang atquiaj, sanarang atnej nop naxey anood mipan micual nej müüch nine pet müetiw ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Aaga najtaj tasaj nej: ―Teat, naleaing aag ipiüng quiaj, masey apmetiw ombas micual, pero aton masey nine pet alndom mamilmil leaw najmiüc tiüt minaw üet neneay nej ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Quiaj tasaj nej Teat Jesús: ―¡Naleaing müm, xeyay iyac imeaats wüx xique! Nganüy apmajlüy atnej indiüm ―aj nej. Quiaj tajneaj micual nej ajan wüx aaga ores quiaj. ");
INSERT INTO huvNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Condom Teat Jesús taw quiaj, tamong amb mbeay nadam yow Galilea, tamb andüy wüx nop tiüc, quiaj chetet. ");
INSERT INTO huvNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Tapeayiw niüng ajlüy nej xeyay nipilan, aquiüjpüw mamb xeyay moniün andeow; altiül necoex, nesomb, nejew, at leaw ndron ombas. Tayacüw tiüt niüng ajlüy Teat Jesús, condom nej meáwan tataag majneaj. ");
INSERT INTO huvNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Meáwan nipilan mbayatoj wüx tajawüw landeac leaw nejew, at leaw ndron ombas lajneaj, leaw necoex lajüy, átan leaw nesomb larraw oniiüg. Tandeacüw xeyay najneaj wüx Midios Israel. ");
INSERT INTO huvNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Condom Teat Jesús tapaj minipilan nej, tasaj: ―Sajiürüw lasta a nipilan cam, cos lamatüch er nüt tatow acüliw ningüy maquiüjpaats, lango majiürüw cuane apmetiw. Aton ngo nandiüm nüjchiw majtsoriw sitiül nganaw metiw, cos alndom masap nejiw lop tiül tiiüd ―aj. ");
INSERT INTO huvNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Quiaj tasajüw nej minipilan nej: ―¿Teat, nguiane alndom naxoman nüeteran ningüy tiül wajchiüc metiw meáwan aaga nipilan quiaja? ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Quiaj tasaj nejiw Teat Jesús: ―¿Cas pan aliün mejiürana? ―aj nejiw. Quiaj tapiüngüw: ―Áagan ayaíw pan alacas nine cüet ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Quiaj tapiüng Teat Jesús chetemoj tiüt nipilan. ");
INSERT INTO huvNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Condom tayar aaga ayaíw pan at a nine cüet; tüüch gracias Teat Dios. Ndoj tambaag müüch minipilan nej majineaw müjchiw meáwan nipilan. ");
INSERT INTO huvNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Meáwan nejiw tetiw paxiün. Condom leaw nenaw ocueajiw taxainguiw chipiüt ayaíw nchep. ");
INSERT INTO huvNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Leaw monxey tetiw, atüch apiquiw mil, pálwüx montaj, pálwüx namix monguich. ");
INSERT INTO huvNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Wüx landoj aag ayaj, quiaj tetepeayayej maquiüjpüw nipilan, condom taw quiaj, amb tiül müx. Tamb andüy tiül iüt Magdala. ");
INSERT INTO huvNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Altiül fariseos y saduceos tambüw majawüw Teat Jesús cos andiümüw masapüw nej wüx naél. Tasajüw marang nadam ateócan majawüw naleaing Teat Dios tiül cielo ambeol nej. ");
INSERT INTO huvNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Nej tasaj nejiw: ―Wüx langwiiüts, tenguial ajmel nüt, icona ipiüngan: “Nganüy apmarang najneaj cos ayac nacants oic”, irawan. ");
INSERT INTO huvNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Aton wüx ümb arraw ipiüngan: “Nganüy ngome apmarang najneaj cos xowüy amococ, ayac nacants oic”, irawan. ¡Ndeac mbeay icon! Cos icona ipiüngan ijawan cuajantanej wüx oic, wüx caaw, ¿neol a nganüy ngo mejawan nicuajind wüx meáwan leawa tenguial ajlüye? ");
INSERT INTO huvNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Nipilan monlüy nganüy cam monrang ngo majneaj atüniw ateócan majawüw. Naleaing sasaj icon ngome apmüjndiw majawüw. Apmüjndiw áagan ateócan leaw tajlüy wüx Jonás, aaga nendeac andeac Teat Dios ―aj nejiw Teat Jesús. Ndoj quiaj tacueat nejiw, tamb. ");
INSERT INTO huvNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Wüx tapeayiw necamb aaga nadam yow, quiaj minipilan nej leaad omeajtsüw ngo majoyiw pan. ");
INSERT INTO huvNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Condom tasaj nejiw Teat Jesús: ―Inguiayiün, sanasaj icon, netam mejawan wüx aaga levadura ocueaj fariseos y saduceos ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Quiaj minipilan nej tandeacüw nejeyéjan quiaj, tapiüngüw: ―¿Neol tandeac atquiaja? Aag ayaj tandeac cos ngo majamiünaats pan ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Teat Jesús tajaw cuane alwüx omeajtsüw. Quiaj tasaj nejiw: ―¿Neol tapots indeacndeacan wüx pan tíülan icona? ¿Neol tapateay iyacan imeajtsan wüx xique? ");
INSERT INTO huvNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Neol nganaw mejawan, ngo leaam imeajtsan nguineay tarangas wüx tajineas acoquiaw pan müetiw acoquiaw mil monxey? Jow leaw tenaw, ¿cas nchep tatücha? ");
INSERT INTO huvNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Neol ngo leaam imeajtsana? Jow, wüx tajineas ayaíw pan müetiw apiquiw mil nipilan, ¿jow leaw tenaw, cas nchep chipiüta? ");
INSERT INTO huvNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Neol cuane nerang icon ngondom mejawana? Cos xique ngome teanasaj icon wüx pan wüx tasajas icon mejawan wüx levadura ocueajiw fariseos at saduceos ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Quiaj tajawüw naleaing ngome teamasaj nejiw majawüw wüx levadura ocueaj pan, asaj nejiw majawüw wüx leaw aquiajchiw ajcüwa fariseos y saduceos. ");
INSERT INTO huvNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Wüx tambüw andüyiw tiül iüt ocueaj Cesarea de Filipo, quiaj Teat Jesús tatün manguiay minipilan nej, tasaj: ―¿Cuane apiüngüw nipilan jane nej a Teat Naxey? ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Quiaj tasajüw nej: ―Altiül apiüngüw nej aaga Juan neech yow nipilan. Altiül apiüngüw aaga Elías, altiül apiüngüw Jeremías, tengwüy alinop nendeac andeac Teat Dios ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Quiaj Teat Jesús tasaj nejiw: ―Jow icona, ¿jane xic ipiüngana? ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Quiaj tasaj nej Simón Pedro: ―Ique aaga Cristo leaw tapiürang aliüc, Micual ic Teat Dios almapac ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Quiaj tapiüng Teat Jesús, tasaj Pedro: ―Ich mapac imeaats, Simón micual Jonás, cos aaga poch indeac quiaj ngome aljane tasaj ic, nejay Xeteat Dios najlüy tiül cielo tüüch ic mejaw. ");
INSERT INTO huvNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Aton xique sasaj ic, ique tenüt Pedro, aag ayaj apiüng wüx nine piedra. Pero wüx aaga nadam piedra cam sanawitich majlüy xeyay xenipilan. Nicuajind ngondom manood nejiw masey nimeech marang leaw andiüm. ");
INSERT INTO huvNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Xique sanüüch ic llave meleaaig micambaj Teat Dios majmeleran tiül. Leaw apmeóel ningüy wüx iüt apmaoeleran tiül cielo; at leaw apmecheed ningüy wüx iüt apchejtiüm tiül cielo aton ―aj. ");
INSERT INTO huvNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Condom quiaj tasaj minipilan nej: ―Nde mesajan nejinguind xique aaga Cristo leaw lapiürang aliüc ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Teat Jesús naw wüx aaga nüt quiaj tapots masaj minipilan nej netam mamb Jerusalén. Quiaj apmamongoch xeyay ngo majneaj teowixaw montangtang tiül a nadam nangaj iüm, teowixaw montangtang miteaats, at mondüy wüx aaga poch tüünd Moisés. Aton netam mandeow mambiyaran, ndoj wüx er nüt apmapac alinomb. ");
INSERT INTO huvNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Condom quiaj a Pedro tawün nej ninguiün quiriw, tasaj: ―¡Teat, aag ayaj ngo mandiüm Teat Dios; ique ngondom memongoch aag ayaj! ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Teat Jesús ndiliteay majaw a Pedro, tasaj: ―Icueat xic, nde mendiüm mepal leaw netam narang. Nde mendeac atnej andiüm Satanás. Cos aaga indeac quiaj ocueaj nipilan, ngome ocueaj Teat Dios ―aj. ");
INSERT INTO huvNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Condom Teat Jesús tasaj minipilan nej, tapiüng: ―Sitiül aljane andiüm mayar sandeac majlüy xenipilan, ich mawün wüx omeaats meáwan naél leaw alndom mamongoch, ich mandüüb wüx leawa sarang masey mamongoch xeyay ngo majneaj, masey mandeow wüx cruz cos andüüb xic. ");
INSERT INTO huvNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Sitiül aljane ngo mayar sandeac ajcan imbol mambiyaw nej nipilan, alinoic nüt nej apmamongoch xeyay ngo majneaj. Pero sitiül aljane masey mandeow ajcan andüüb xic ayar sandeac, alinoic nüt najneajay apmajlüy. ");
INSERT INTO huvNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","¿Jondot sitiül aljane alndom maneay meáwan cuajantanej leaw ajlüy wüx aaga iüt cam, cuane ajpar sitiül apndrom ombas lango mamb tiül cielo? ¿Nguineay alndom nop mangüy asoet nej maw wüxe? ");
INSERT INTO huvNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Cos alinoic nüt wüx aaga Teat Naxey aliüc alinomb xeyay najneajay apmajlüy, xeyay nelitlit atnej ajlüy Teat Dios, almaquiüjpüw nej a ángeles. Quiaj apmangüy meáwan anopnop wüx leaw tarang. ");
INSERT INTO huvNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Naleaing nganüy sasaj icon altiül icona nganaw mandeow, quiaj apmejawan nguineay ajlüy a Teat Naxey wüx apmajlüy wüx micambaj nej ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Wüx lamatüch anaíw nüt tatow ndoj mapiüng aag ayaj, quiaj Teat Jesús taquiiüb Pedro, Jacobo, at a Juan michiig Jacobo. Tambüw wüx nop nadam tiüc nejíwan quiaj. ");
INSERT INTO huvNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Condom Teat Jesús tewüneay majawüw nej. Quiaj tajawüw teombas nej xowüy lalitlit atnej achech nüt; apix nej tajlüy rajnüy atnej ran. ");
INSERT INTO huvNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Camüm quiaj majawüw mixejchiw nejiw tajlüyiw tanomb, ajcüwa Moisés maquiiüb Elías, tenguial andeacüw maquiüjpüw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Condom quiaj a Pedro tasaj Teat Jesús: ―Teat, najneajay macüliiüts ningüy nóiquian. Sitiül mendiüm sanarangan ningüy arej nden, noic ineay, alinoic aneay teat Moisés, at alinoic aneay teat Elías ―aj. ");
INSERT INTO huvNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pedro tealeámban mandeac aag ayaj, quiaj ajngot noic rajnüy oic taxot nejiw. Imiün tiül aaga oic quiaj tanguiayiw noic nanderac, apiüng: ―Aaga ayaj xecual, xeyay sandiüm, apac ximeaats najaw. Inguiayiün meáwan leawa nej asaj icon ―aj nejiw aaga nendeac quiaj. ");
INSERT INTO huvNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Almanguiayiw aag ayaj minipilan nej, tanaámb mojcojow tiüt mbayatoj xeyay. ");
INSERT INTO huvNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Quiaj Teat Jesús tamb marreeg nejiw, tapiüng: ―Witiüron, nde mbayameron ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Almaxainguiw omalüw, quiaj majawüw ngo majlüy quiaj nejinguind, áagan Teat Jesús almaquiüjpüw. ");
INSERT INTO huvNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Condom wüx teawüw tiüt imiünüw wüx tiüc, quiaj tasaj nejiw Teat Jesús: ―Nde mesajan nejinguind wüx aaga leaw Teat Dios tüüch icon mejawan quiaj. Wüx Teat Naxey landoj lapac tiül mondeow, quiaj alndom mendeacan wüx ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Quiaj tatüniw nej manguiayiw minipilan nej, tasajüw: ―Teat, ¿neol ajcüwa mondüy wüx aaga poch leawa tüünd Moisés apiüngüw netam miün aaga Elías ombas nej, teoj aliüc aaga Cristo? ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Quiaj tasaj nejiw Teat Jesús: ―Naleaing leaw apiüngüw, Elías netam miün ombas masaj nipilan leaam omeajtsüw wüx Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Nganüy sasaj icon Elías laíün ningüy. Naleaing ngome tajawüw jane nej. Tarangüw wüx ombas nej cuajantanej ngo majneaj leaw andiümüw. Atquiaj Teat Naxey aton apmamongoch xeyay ngo majneaj teowixaw nejiw ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Quiaj minipilan nej leaad omeajtsüw, teamandeac wüx ombas aaga Juan neech yow nipilan. ");
INSERT INTO huvNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Wüx tapeayiw niüng ajlüyiw nipilan, quiaj tajngot nop naxey maquieel micos nej tiüt teombas Teat Jesús, tasaj: ");
INSERT INTO huvNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","―Teat Naxey, ijiür lasta xecual cos nimeech alox nej tiüt, teamamongoch xeyay ngo majneaj. Nguiaj lamalox nej tiül biümb tengwüy tiül yow. ");
INSERT INTO huvNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Saquiiüb miün nüüch majawüw nej minipilan sitiül alndom matajcüw nej majneaj. Naleaing ngondom ombasüw ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Quiaj Teat Jesús tasaj nipilan: ―¡Jaa, icona nipilan ngo meyariün sandeac, monrang ngo majneaj icon! ¿Cas nüt ipiüngan sanajlüy ningüy naquiiüb icona? ¿Cas nüt ipiüngan sanaíüc wüx leaw irangana? Iquiüjpan miün aaga nench najaw ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Condom quiaj talic aaga nimeech najlüy wüx ombas a nench; tasaj macueat. Quiaj tacueat, tajneaj a nench tíülan aaga ores quiaj. ");
INSERT INTO huvNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Condom minipilan nej wüx nejíwan quiaj maquiüjpüw nej, quiaj tasajüw: ―¿Neol xicona ngondom nawüniün aaga nimeech quiaja? ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Quiaj tasaj nejiw Teat Jesús: ―Cos ajcan apateay iyacan imeajtsan wüx xique. Naleaing sasaj icon sitiül icona meyacan imeajtsan wüx xic, masey atonej apateay osaab mostaza, apndom mesajan aaga tiüc quiaj: “Iriow ninguiaj, quiür indüy ninguiün”, merajan, y aaga tiüc apmaw. Ngo majlüy nicuajind leaw ngondom merangan sitiül naleaing iyacan imeajtsan wüx xique. ");
INSERT INTO huvNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Pero aaga nimeech quiaj ngondom maw sitiül ngo matajcüch orar y maiündüch xeyay ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Wüx tajlüyiw nóiquian tiül iüt Galilea, quiaj Teat Jesús tapots masaj nejiw wüx nguineay Teat Naxey apmayacüch teowixaw nipilan, ");
INSERT INTO huvNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","apmambiyaw nej; ndoj, wüx er nüt apmapac alinomb. Wüx tanguiayiw aag ayaj tamix omeajtsüw xeyay. ");
INSERT INTO huvNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Wüx Teat Jesús tapeay tiül cambaj Capernaum maquiiüb minipilan nej, quiaj ajcüwa monxaing tomiün andüy tiül nadam nangaj iüm tambüw majawüw teat Pedro. Tatüniw manguiayiw nej, tasajüw: ―Jow aaga teat nequiaach icon, ¿ngo mawün tomiüna andüy tiül a nadam nangaj iüm ocueajiiütsa? ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Quiaj teat Pedro tasaj nejiw: ―Ajaj awün ―aw. Wüx tajmel tiül iüm a Pedro, andüüb masaj nej Teat Jesús, tapiüng: ―¿Nguineay ipiüng teat Simón? Jow monajiüt tiül noic cambaj, ¿jane ocueaj atüniw tomiüna, micual miiütüw nejiwe, ngwüy napeay miün nipilana? ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Quiaj tapiüng a Pedro: ―Atüniw ocueaj napeay miün nipilan ―aw. Teat Jesús tapiüng: ―Nganüy micual iüt ngo metam mangüy. ");
INSERT INTO huvNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Naleaing, pero ngana mandeacndeacüw wüx; quiür mbeay ndec, erlech. Leaw apmelech ombas, apmexom teombeay nej tomiün. Aag ayaj ngochan meajchiw ajcüwa monsap tomiün, aag ayaj ayacar icore ―aj nej Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Tiül aaga nüt quiaj, tatüniw nej manguiayiw minipilan nej, tasajüw: ―¿Jane alwüx atam ajlüy tiül micambaj Teat Dios najlüy tiül cielo? ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Quiaj Teat Jesús tapaj miün nop nine, malembech pinawan nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Condom tapiüng: ―Naleaing sasaj icon sitiül ngo mendüyiün wüx merangan atnej arang nop nine, ngondom mejmeliün tiül micambaj Teat Dios najlüy tiül cielo. ");
INSERT INTO huvNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Atquiaj jangantanej leaw apmarang atnej aaga nine cam, ngo merangrangüy nicuajind, aag ayaj alwüx atam ajlüy tiül micambaj Teat Dios najlüy tiül cielo. ");
INSERT INTO huvNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Aton jangantanej apmajiür lasta nop nine atnej aaga nine cam, aag ayaj atnej xique tenguial majiür xic lasta. ");
INSERT INTO huvNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","’Jangantanej apmandiüm mayac wüx marang ngo majneaj masey nop tiül ajcüwa namix nine monyar sandeac, najneaj wǘxan nganaw marang aaga ngo majneaj quiaj, maoelich teonic nej nop cow majlos tiül ndec tsoyom tiüt nómban. ");
INSERT INTO huvNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡Xeyay ngo majneaj ajlüy wüx iüt, cos ajlüy leaw alndom müüch majmiücaran tiül nisoet! Aag ayaj meáwan nüt ajlüy, pero ¡xeyay ngo majneaj apmamongoch leaw apmayac wüx nisoet alinop! ");
INSERT INTO huvNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Atquiaj sitiül aljane ayaag owix nej tengwüy oleaj nej andiüm mayac nej wüx marang ngo majneaj, ich mandooig malox ninguiün. Cos más najneaj majmel niüng apmapacaran meáwan nüt masey ngo majiür nots owix tengwüy nots oleaj, cos cuane ambeol nej majlüy palan, ndoj majlos tiül biümb niüng ngondom xejquem nómban. ");
INSERT INTO huvNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Aton sitiül aljane ayaag oniiüg nej andiüm majaw leaw ngo majneaj, ich masoond malox ninguiün. Cos najneaj majmel niüng apmapacaran meáwan nüt masey noic oniiüg nej, cos cuane ambeol nej majiür palan oniiüg, ndoj majlos tiül biümb tiül necoy. ");
INSERT INTO huvNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","’Nde mepiüngan jangantanej tiül ajcüwa namix nine quiaj ngo membeat, cos sasaj icon ajcüwa ángeles tiül cielo leaw tenguial mambeol nejiw, meáwan nüt teamajawüw mitey Xeteat Dios najlüy tiül cielo. ");
INSERT INTO huvNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Cos Teat Naxey tiün mawün wüx meáwan nipilan leawa landoj apndrom ombasüw. ");
INSERT INTO huvNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’¿Cuane ipiüngan? Jondot nop naxey almajiür coic miow (100) sap, camüm ndrot ocueaj nop. ¿Neol ngome apmacueat aaga peic miow gajpoquey (99) quiaja, mamb mayamb aaga nop leaw ndrona? ");
INSERT INTO huvNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Sitiül ndot maxom, naleaing sasaj icon apmapac omeaats xeyay majaw aaga axom quiaj, ngo matnej meáwan leaw ngo ndrom. ");
INSERT INTO huvNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Atquiaj aton Miteatiiüts Dios najlüy tiül cielo ngo mandiüm majaw ndrom ombasüw nop tiül ajcüwa namix nine quiaj. ");
INSERT INTO huvNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","’Sitiül aljane aleaic marang wüx imbas, quiür indeac anaag najneaj icónan quiaj, meaach leaam omeaats leaw tarang. Sitiül tayar leaw ipiüng, lamembeol, lameaach majneaj omeaats. ");
INSERT INTO huvNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Nganüy sitiül ngo mayar leaw isaj, iyamb nop ijpüw mequiiüb, meamban mejawan majlüyiw quiaj manguiayiw. ");
INSERT INTO huvNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Sitiül nej ngo mayar leaw isajan, isajan montangtang tiül moncanchiün mandeacüw maquiüjpüw. Ndot átan ngo mayar leaw asajüw nej, iyacan atnej nop ngo mayar andeac Teat Dios, tengwüy atnej nop nesap mitomiün cambaj leaw xeyay ngo majneaj arang. ");
INSERT INTO huvNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Naleaing sasaj icon, meáwan leaw apmeoeliün wüx aaga iüt cam apmaoelich tiül cielo. Aton meáwan leaw apmechejtiün wüx aaga iüt cam, apmachejtich tiül cielo aton. ");
INSERT INTO huvNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Sasaj icon alinomb, masey sitiül ijpüw icona ningüy wüx iüt aleaic metüniün, noic nej imeajtsan, Xeteat Dios najlüy tiül cielo apmüüch. ");
INSERT INTO huvNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Cos nguiajantanej niüng xenenguejow masey ijpüw arojpüw monyar sandeac, xique sajlüy quiaj pinawan nejiw ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Condom quiaj teat Pedro tamb matün manguiay Teat Jesús, tasaj: ―Teat, ¿jondot nop aleaic marang wüx ximbas, cas ombas netam nawün wüx ximeaats leawa taranga, leaw atüch ayaíwe? ―aj. ");
INSERT INTO huvNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Quiaj tasaj nej Teat Jesús: ―Ngo nasaj ic áagan ayaíw; alndom mewün wüx imeaats masey ayaíw ermiow gajpowüw (77) ―aj. ");
INSERT INTO huvNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","’Tiül micambaj Teat Dios najlüy tiül cielo ajlüy atnej tarang nop minatang nenajiüt wüx tandiüm majaw nguitow ajüchiw nej anopnopoj mimonbeol nej. ");
INSERT INTO huvNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Tapots majaw wüx nguitow ajüch, quiaj apeay quiaj maquiüraab niüng ajlüy nej nop leaw ajüch nej xeyay tomiün. ");
INSERT INTO huvNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Aaga naxey quiaj ngondom mangüy leaw ajüch. Quiaj tapiüng aaga minatang nenajiüt majnapüw, majlüyiw ocueaj alinop maquiiüb mintaj nej micual nej. At majnap meáwan leaw almajiürüw para mawün mitomiün nej. ");
INSERT INTO huvNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Condom aaga naxey quiaj taquieel micos nej tiüt teoleaj minatang nenajiüt matün ocueaj. Tasaj: “Teat, satün icueaj, ngwa mecül xic alquiripite, ndoj sanangüy meáwan leaw salnajüch ic”, aj. ");
INSERT INTO huvNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Quiaj aaga natang nenajiüt tajmiüc omal omeaats majaw nej. Tawün wüx omeaats nej nómban leaw lamajüch aaga naxey quiaj, tapiüng tsajmbiüm mamb. ");
INSERT INTO huvNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Almaw quiaj aaga naxey nejüchay, quiaj mangoch nop aquiiüb nej arang aweaag najiüt, almajüch nej quiriw tomiün. Quiaj tasap mapats onic, landüy wüx apmambiy. Quiaj tasaj: “Nganüy nganüy ingüy xetomiün”, aj. ");
INSERT INTO huvNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Quiaj aaga naxey taquieel micos nej tiüt, matün ocueaj, tasaj: “Satün icueaj teat, ngwa mecül xic alquiripite, ndoj sanangüy meáwan leaw sajüch ic”, aj. ");
INSERT INTO huvNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Aaga naxey quiaj ngome tandiüm macül nej, andǘüban tamb mayac tiül manchiüc leaw ambich mangüy mitomiün nej. ");
INSERT INTO huvNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Wüx tajawüw aag ayaj alacas monrang najiüt, xeyay ngo majneaj mayajcüw. Quiaj tambüw masajüw aaga minatang nenajiüt manguiay meáwan leaw lamarang aag naxey quiaj. ");
INSERT INTO huvNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Quiaj tapaj nej miün alinomb aaga minatang nenajiüt, tasaj nej: “¡Ique nop ic ngo majneaj nerang xenajiüt! Ique meáwan leaw tejüch xic, aag ayaj tawüniüs wüx ximeaats nómban, cos tetün xicueaj. ");
INSERT INTO huvNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Jow nganüy ique, ¿neol ngo mejiür lasta alinop atnej tajiüras ic lasta?” aj nej. ");
INSERT INTO huvNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Tajcüy xeyay aaga natang nenajiüt, quiaj tüüch mamb tiül manchiüc macǘlan quiaj leaw ambich mangüy meáwan ajüch. ");
INSERT INTO huvNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","’Atquiaj apmarang wüx imbasan Xeteat Dios najlüy tiül cielo sitiül ngo mewüniün wüx imeajtsan meáwan leaw arang wüx imbasan alinop ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Condom wüx Teat Jesús landoj masaj nejiw meáwan aaga poch quiaj, quiaj taw Galilea tamb andüy tiül iüt Judea, najlüy nonüt necamb lam Jordán. ");
INSERT INTO huvNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Tandüjpiw nej mamb xeyay nipilan. Meáwan tamongoch iün andeowüw. ");
INSERT INTO huvNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Condom acas fariseos tambüw majawüw Teat Jesús matüntüniw manguiayiw majawüw cuane apmapiüng. Quiaj tasajüw: ―¿Alndom nop naxey macueat mintaj nej cos tarang cuajantanej leawa nej ngo mandiüm? ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Quiaj tasaj nejiw: ―¿Ngomeaag meteowan tiül Mipoch Teat Dios, niüng apiüng nej nerang nipilan, cos apiüng: “Tarang naxey at tarang najtaj”? ");
INSERT INTO huvNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Aton tapiüng: “Nop naxey netam macueat miteat nej mimüm nej, maquiiüb mintaj nej. Quiaj apmajlüyiw nóiquian, atnej nop nipilan nejiw.” ");
INSERT INTO huvNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Atquiaj langome apmajlüyiw ijpüéj, apmajlüyiw nop nejiw cos noic omeajtsüw. Pares nejinguind ngondom müüch mecueatayej leaw Teat Dios lamüüch majlüy nóiquian ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Quiaj tasajüw nej: ―¿Neol a Moisés tapiüng alndom nop naxey macueat mintaj nej sitiül marangüch minawijquiaw nejiw müjndiw mecueatayej nómban? ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Quiaj tasaj nejiw Teat Jesús: ―Moisés tapiüng alndom mecueatiün mintajan cos tajaw nadam imeajtsan. Naleaing nomb ngome atquiaj ajlüy. ");
INSERT INTO huvNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Pero nganüy xique sasaj icon sitiül nop naxey macueat mintaj nej, acueátan, ngome nejiür naxey mintaj nej, condom aaga naxey quiaj apmaquiiüb alinop, nej a naxey quiaj ajiür xeyay nisoet cos lamajiür minajtaj nej. Aton jane apmaquiiüb nop najcueat najtaj ajiür xeyay nisoet cos atnej majiür minajtaj nej aton ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Quiaj tapiüngüw minipilan nej: ―Sitiül atquiaj ajlüy naél wüx aljane macueat mintaj nej, nómban ngo majneaj majiüraran mintajaran ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Quiaj tasaj nejiw Teat Jesús: ―Ngome meáwan nipilan alndom maiücüw wüx aaga ipiüngan quiaj. Áagan leaw Teat Dios lamambeol müüch majlüyiw atánan quiaj. ");
INSERT INTO huvNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ajlüy monxey ajiür cuane wüx ngo mengoch owixaw: altiül atquiaj ajlüy nde wijquiaw; altiül aljane tarang nej wüx ombas nej; at altiül ngo mengoch owix cos xeyay andiüm marang minajiüt micambaj Teat Dios. Leaw ayaag alndom majlüy atánan quiaj, ngo mengoch owix, pues najneaj ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Condom taquiüraab niüng ajlüy nej acas namix nine matepeayiw Teat Jesús, mayac owix nej wüx omalüw nejiw, matün monajneaj ocueaj Teat Dios müüch nejiw. Minipilan nej taliquiaw ajcüw monquiiüb namix nine. ");
INSERT INTO huvNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Quiaj Teat Jesús tapiüng: ―Ijchan miünüw a namix nine niüng sajlüy, nde mepalan. Cos ocueajiw nejiw micambaj Teat Dios najlüy tiül cielo ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Quiaj tajend omalüw namix nine, ndoj taw quiaj. ");
INSERT INTO huvNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Condom tajngot nop majaw Teat Jesús, tatün nej manguiay, tasaj: ―Teat, sajaw ique najneaj irang. Nganüy isaj xic Teat, ¿cuane najneaj netam naranga para namb tiül cielo nacül quiaj meáwan nüte? ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Quiaj tasaj nej Teat Jesús: ―¿Neol tepiüng xique nerangas najneaja? Nejinguind nipilan ngo marang najneaj. Áagan Teat Dios arang najneaj. Nganüy sitiül indiüm meamb tiül cielo, netam merang meáwan leaw tapiüng Teat Dios marangüch ―aj. ");
INSERT INTO huvNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Quiaj tasaj nej aaga naxey quiaj: ―¿Ngün? ―aj. Teat Jesús tasaj nej: ―Nde membiy nejinguind; nde mejiür pálwüx najtaj; nde merneed; nde mendeac ngo maleaing wüx ombas alinop; ");
INSERT INTO huvNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","iyar andeac miteat mimüm; aton ijiür lasta alinop atnej ijiürüy lasta iquiáyan quiaj ―aj nej Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Quiaj tasaj nej aaga naxey quiaj: ―Teat, meáwan aag ayaj sayac wüx ximeaats narang nde quich xic. ¿Cuane alinoic netam naranga? ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Quiaj tasaj nej Teat Jesús: ―Sitiül indiüm merang leaw palan, quiür inüüb meáwan leaw almejiür, condom imbaag ombeat meaach leaw nipilan ngo majiür. Ndoj tewiün mendüüb xic merang xenajiüt. Atquiaj apcanchiüm meáwan nembeatmbeat leaw apmeaand alinoic nüt tiül cielo ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Wüx tanguiay aag ayaj, quiaj tamix omeaats, taw quiaj, cos nej ajiür xeyay cuajantanej, ngo mandiüm mandrooch ombas. ");
INSERT INTO huvNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Quiaj Teat Jesús tasaj minipilan nej: ―Naleaing sasaj icon xeyay naél ocueajiw ajcüwa monjiür xeyay cuajantanej majmeliw tiül micambaj Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Sanandüy wüx nasaj icon alinomb, ngo maél mamong teowil nots ndiüc nop camello, ngo matnej aél ocueaj nop nejiür xeyay, majlüy tiül micambaj Teat Dios ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Wüx tanguiayiw aag ayaj minipilan nej xeyay mbayatoj, tetünayej menguiayayej: ―Sitiül atquiaj ajlüy, ¿jane alndom maw wüx asoet neje? ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Quiaj Teat Jesús tajaw teombasüw nejiw, tapiüng: ―Nipilan ngondom mawün wüx asoet nejinguind; pero Teat Dios ngo maél majaw aag ayaj cos nej alndom marang cuajantanej ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Condom Pedro quiaj tasaj nej: ―Teat, xicona lanacueatiün meáwan leaw tajiürasan para nandüjpiün ic. Jow nganüy, ¿cuane sanaxoman wüx? ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Quiaj tasaj nejiw Teat Jesús: ―Naleaing sasaj icon, alinoic nüt wüx Teat Dios apmüüch marang jayats meáwan cuajantanej leaw ajlüy wüx iüt, wüx Teat Naxey apmasap najneajay niüng chetej marang natang nenajiüt, apmajlüy quiaj gajpiüp (12) niüng chetejow montangtang monajiüt, niüng icona leaw mondüüb xic apchetemeron mejawan wüx asoetiw ajcüwa gajpiüp (12) ajlüy nipilan acualaats Israel. ");
INSERT INTO huvNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","At aton jangantanej monyar sandeac leaw acueat aniüng nej, acueat miteat nej, mimüm nej, micoj nej, michiig nej, mintaj nej, micual nej, tengwüy macueat miíüt nej para mandüüb xic, apmajlüy najneaj. Apmüjndiw xeyay, ngo matnej leaw tacueatiw wüx a iüt cam, aton apmapacüw tiül cielo meáwan nüt. ");
INSERT INTO huvNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Naleaing jane ayaag atnej alwüx atam ajlüy nganüy, alinoic nüt apmajlüy chingüy; at jane ayaag chingüy nej nganüy, alinoic nüt apmajlüy natang tiül micambaj Teat Dios ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Aton tasaj nejiw Teat Jesús: ―Cos tiül micambaj Teat Dios najlüy tiül cielo, ajlüy atnej tarang nop nateateran nejiür iüt. Cos nej taw ǘmban arraw mayamb monrang najiüt macojchiw najün uva. ");
INSERT INTO huvNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Wüx taxom monrang najiüt, tasoiquiw apmangüyaranüw noic nüt noicnoic tomiün nasoic denario. Quiaj tüüch mambüw marangüw minajiüt nej. ");
INSERT INTO huvNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Condom taw alinomb wüx lapeay pinawan ajüy nüt. Quiaj taxom tiül plas alacas monxey tenguial ayambüw najiüt. ");
INSERT INTO huvNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Quiaj tasaj nejiw: “¿Ngwüy tabaatsa, merangan najiüt tiül xecorrül mecojchiün xeúva? Ndoj sanangüy icon atnej netam”, aj nejiw. Quiaj tambüw. ");
INSERT INTO huvNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Camüm taw alinomb aaga neneay najiüt laámb aplembem nüt, at wüx lanchejliow nüt aton. Átan taxom monrang najiüt atnej tilüy quiaj. ");
INSERT INTO huvNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Condom taw alinomb lamitiüt nüt, níüngan taxom alacas aliw tiül plas, ngo maxomüw najiüt. Quiaj tasaj nejiw: “¿Neol tejlüyíünan ningüy pal nüte; ngo mexoman najiüta?”, aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Quiaj tapiüngüw: “Cos nejinguind ngo miün mayamb xicon”, awüw. Quiaj aaga neneay najiüt tasaj nejiw: “Quiüran irangan najiüt tiül xecorrül aton, ndoj sanangüy icon atnej netam”, aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Wüx laǘmb tiüt aaga nüt, quiaj aaga neneay najiüt tasaj aaga naxey leaw tayac majlüy wüx majaw monrang najiüt: “Iwüniw tiül najiüt, ingüy minajiütüw nejiw. Ingüy ajan wüx teoj mapeay, ndójwüx leaw mbas mapeay”, aj. ");
INSERT INTO huvNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Wüx tapeayiw ajcüw monrang najiüt leaw tajmeliw lamitiüt nüt, tangüyeranüw palan noicnoic denario anopnopoj. ");
INSERT INTO huvNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Condom wüx tatüch nejiw leaw mbas majmeliw tiül najiüt, apiüngüw a nejiw apmüjndiw wüx alquiriw; naleaing tüjndiw atówan nej aton noic denario. ");
INSERT INTO huvNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Tayariw, pero naleaing tajcüyiw, tandeacndeacüw wüx ombas aaga neneay najiüt. ");
INSERT INTO huvNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Tasajüw: “Ajcüwa teoj majmeliw tiül najiüt, ¿wül arangüw najiüta? Áagan noic ores tarangüw, pero ique tengüy atow nej ingüy xicon. Nganüy xicona tarangasan xeyay najiüt, sandeowan tiül nerraar mbich nüt”, ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Quiaj tapiüng aaga neneay najiüt, tasaj nop nerang najiüt: “Amigo, xique ngo narang nicuajind ngo majneaj wüx imbasan. ¿Neol ngwa, landoj lamandeacaatsa sanangüy icon noic denario? ");
INSERT INTO huvNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Iyar leaw sangüy ic quiaj, quiür. Xique sandiüm nüüch aaga teoj mapeay atow nej süüch ic. ");
INSERT INTO huvNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Neol, ngome alndom narang leawa xic sandiüm wüx xetomiüna? ¿Ngwüy, ngo majneaj mejaw xic ajcan sandiüm nambeol nejiw aton?” aj. ");
INSERT INTO huvNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Aton tapiüng Teat Jesús: ―Altiül leawa mbas nejiw, apmajlüyiw teoj, at leawa teoj nejiw apmajlüyiw mbas. Cos xeyayiw leaw najpajüw, pero napateayiw leaw narriüjtüch ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Wüx Teat Jesús aliw tiül tiiüd laambüw andüyiw Jerusalén, quiaj tawün nejiw mbiüjlatoj mbeay tiiüd ajcüwa gajpiüp (12) minipilan nej, tasaj: ");
INSERT INTO huvNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―Nganüy laambaats andüyiiüts Jerusalén niüng Teat Naxey apmayacüch teowixaw montangtang miteaats at ajcüwa mondüy wüx aaga poch tüünd Moisés. Quiaj apmapiüngüw mandeow. ");
INSERT INTO huvNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Aton apmayacüw nej teowixaw napeay miün nipilan, apmitsojow nej, apmawüjchiw, ndoj apmambiyaw wüx cruz. Pero naleaing wüx er nüt apmapac alinomb ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Condom nop najtaj mimümüw a Jacobo at a Juan, micual nejiw Zebedeo, tamb nóiquian maquiüjpüw majawüw Teat Jesús. Taquieel tiüt micos nej teombas cos andiüm matün alcuane. ");
INSERT INTO huvNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Quiaj tasaj nej Teat Jesús: ―¿Cuane indiüm, müm? ―aj nej. Quiaj tapiüng aaga najtaj: ―Teat, wüx nüt apchetemear merang natang nenajiüt tiül micambaj, ijchaw chetemoj ajcüwa xecual cam aton, nop amb wüx miác iwix alinop amb wüx miquiamb ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Quiaj tasaj nejiw Teat Jesús: ―Ngo mejawan leaw itüniün. ¿Ngwüy alndom memongochiün xeyay necoye atnej xique sanamongoche? ¿Ngwüy alndom mendeowana atnej xique sanandeowa? ―aj nejiw. Quiaj tapiüngüw: ―Alndom ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Quiaj tasaj nejiw Teat Jesús: ―Naleaing, netam memongochiün xeyay necoy atnej xique sanamongoch, aton apmembiyaranan; pero aaga ipiüngan chetemeron wüx xeác y wüx xequiamb, mbich aag ayaj ngome xique alndom nüüch aljane, néjan quiaj Xeteat ajlüy wüx müüch leaw lamateots müüch ―aj. ");
INSERT INTO huvNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Wüx tanguiayiw aag ayaj ajcüw algajpowüw (10) minipilan nej, quiaj tajcüyiw; ngo majneaj majawüw ajcüw alijpüw nechiigayej quiaj. ");
INSERT INTO huvNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Condom Teat Jesús tapaj masaj nejiw, tapiüng: ―Lamejawan nguineay arangüw monajiüt tiül meáwan cambaj, cos arangüw apatüw atnej lamaneayiw nómban meáwan nipilan leaw ajlüyiw wüx; átan minatangüw nejiw ngo majiürüw lasta nejinguind. ");
INSERT INTO huvNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Pero tiül icona ngondom merangan atquiaj. Cos jane andiüm marang natang tiül icona netam mambeol icon. ");
INSERT INTO huvNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Aton sitiül aljane tiül icona andiüm marang más netam ajlüy, netam marang atnej nop nembeol. ");
INSERT INTO huvNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Atquiaj ajlüy wüx a Teat Naxey cos nej ngo miün mambeolaran, nej tiün mambeol meáwan nipilan, at mandeow mangüy asoet xeyay nipilan ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Wüx tawüw tiül cambaj Jericó xeyay nipilan almandüjpiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Aliw quiaj ijpüw monxey nesomb, alchetemoj mbeay tiiüd. Wüx tanguiayiw Teat Jesús namong, quiaj tepajüw, tapiüngüw: ―¡Teat Naxey, micual teat David, ijiür xicon lasta! ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ajcüwa nipilan taliquiaw nejiw mapalüw ombeayiw, naleaing nejiw tepajüw napac, tapiüngüw: ―¡Teat Naxey, micual teat David, ijiür xicon lasta! ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Quiaj lembet Teat Jesús, tapaj ajcüwa somb quiaj, tatün manguiay nejiw, tapiüng: ―¿Cuane indiüman metüniün wüx ximbasa? ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Quiaj tasajüw nej: ―Teat, sandiüman ram xeniüjcan ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Quiaj Teat Jesús tajmiüc omal omeaats majaw nejiw, tayac owix wüx oniüjcüw nejiw. Andǘüban ajneajiw, nómban rat oniüjcüw. Condom tambüw mandüjpiw Teat Jesús aton. ");
INSERT INTO huvNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Wüx laliüc matüchiw Jerusalén, tapeayiw tiül cambaj Betfagé niüng ajlüy mitiüc Olivos. Quiaj Teat Jesús tüüch mamb ijpüw minipilan nej. ");
INSERT INTO huvNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Tasaj: ―Quiüran tiül aaga cambaj najlüy alareng niüng ajlüyiiüts. Quiaj apmexoman nop bur neóel, almaquiiüb nop quicheech bur micual nej. Ichejtiün, iquiüjpan miün. ");
INSERT INTO huvNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Sitiül aljane aleaic masaj icon, isajan: “Teat Naxey apmetam nej, ndoj apmatsoriich alinomb”, irajan ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Atquiaj tajlüy para majlüy atnej tapiüng nop nendeac andeac Teat Dios, cos tapiüng: ");
INSERT INTO huvNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Isajan a cambaj Jerusalén: “Ijawan, jogüy minatang nenajiüt icueajiün, aliüc majaw icon, Nej ngome nerangrangüy, najneaj omeaats; ajtep nop quicheech bur, micual nej nop bur nemalmal naǘm”, aw. ");
INSERT INTO huvNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Quiaj tambüw minipilan nej. Tarangüw meáwan atnej lamasaj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Taquiüjpüw miün a bur maquiiüb micual nej. Quiaj tapojchiw teopechiw a bur apixaw nejiw. Condom Teat Jesús tajtep chetem wüx. ");
INSERT INTO huvNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Meáwan nipilan, tapüjchiw tiüt apixaw nejiw tiül tiiüd, altiül tapoliw omal xiül mayacüw tiüt tiül tiiüd. ");
INSERT INTO huvNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ajcüwa nipilan quiaj teapajüw napac, átan namong ombas, átan aliüc tamiün, tenguial mapiüngüw: ―¡Najneajay arang micual teat David! ¡Nangaj ajlüy aaga niün, üüch nej miün Teat Dios! ¡Najneajay ajlüy Teat Dios tiül cielo! ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Condom wüx Teat Jesús tajmel tiül cambaj Jerusalén meáwan nipilan tendeacndeacüw wüx, tatüniw manguiayiw: ―¿Jane aag ayaja? ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Altiül nipilan tapiüngüw: ―Aag ayaj aaga Jesús naw tiül cambaj Nazaret tiül Galilea. Nej nop nendeac andeac Teat Dios ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Condom Teat Jesús tajmel tiül aaga nadam nangaj iüm ocueaj Teat Dios. Quiaj tapots mawün meáwan monüjpeay at mongalüy leaw aliw tiül. Aton tatech ninguiün mimesüw mongowüüch tomiün, at mibangüw monüüb palom. ");
INSERT INTO huvNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Tasaj nejiw: ―Tiül Nangaj Mipoch Teat Dios apiüng: “Saniüng ajlüy niüng apmatajcüch orar”, aw Teat Dios. Pero icona lamerangan aaga nangaj iüm cam atnej niüng axotüy moneed ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Tambüw majawüw nej tiül nadam nangaj iüm leaw nesomb at leaw necoex, nej tataag nejiw majneaj. ");
INSERT INTO huvNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ajcüwa montangtang miteaats at mondüy wüx aaga poch tüünd Moisés tajcüyiw wüx tajawüw meáwan najneajay ateócan leaw teamarang Teat Jesús; at wüx tanguiayiw nguineay a namix monguich teapajüw tiül nadam nangaj iüm, cos teamapiüngüw: “¡Najneajay arang micual mixejchiiüts David!” awüw. ");
INSERT INTO huvNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Tasajüw Teat Jesús: ―¿Quia ngo menguiay cuane teamapiüngüw wüx ique ajcüw ayaja? ―ajüw nej. Quiaj tasaj nejiw: ―Ajaj, teananguiay. ¿Jowa icona ngomeaag meteowan tiül Mipoch Teat Dios? niüng apiüng atcüy: Xique lanayac teombeayiw namix monguich at namix nine aaga poch mapiüngüw najneajay irang ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Condom taw quiaj tacueat nejiw, tamb andüy tiül cambaj Betania. Quiaj tacül aaga ongwiiüts quiaj. ");
INSERT INTO huvNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Wüx rat tiüt, quiaj tamb Teat Jesús andüy Jerusalén alinomb. Wüx aleamb tiül tiiüd tind üet. ");
INSERT INTO huvNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Tajaw noic owil toc almbeay tiiüd. Quiaj tamb majaw, naleaing ngo maxom wüx nicuajind, áagan aóp majlüy wüx. Quiaj Teat Jesús tasaj aaga toc: ―¡Aleaw atogüy ümb minüt, lango mejiür ióng nómban! ―aj. Quiaj tawaag a toc. ");
INSERT INTO huvNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Wüx tajawüw aag ayaj minipilan nej mbayajow. Tasajüw Teat Jesús: ―¿Neol nguineay ajen awaag a toc quiaja? ―ajüw. ");
INSERT INTO huvNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Quiaj tasaj nejiw Teat Jesús: ―Naleaing sasaj icon, sitiül naleaing iyacan imeajtsan wüx xique, ngo mechiwean imeajtsan, alndom merangan cuajantanej. Ngome áagan wüx toc quiaj alndom merangan, alndom mesajan aaga tiüc quiaj: “Iriow ningüy, quiür indüy tiül ndec”, merajan, y atquiaj apmajlüy. ");
INSERT INTO huvNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Meáwan leaw apmetüniün wüx apmetajcan orar, apmeajndiün sitiül ipiüngan tiül imeajtsan alndom majlüy ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Condom Teat Jesús tajmel tiül nadam nangaj iüm. Wüx tenguial aquiaach nipilan, quiaj tambüw majawüw nej montangtang miteaats at montangtang monajiüt tiül nipilan israel. Tatüniw nej manguiayiw, tapiüngüw: ―¿Nguiane iyar minajiüt merang aag ayaja? ¿Jane neech ique? ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Quiaj tasaj nejiw Teat Jesús: ―At a xique aton sanatün nanguiay icon noic poch. Sitiül apmesajan xic, at a xique aton sanasaj icon nguiane nayar xenajiüt narang aag agüy. ");
INSERT INTO huvNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Jow a Juan, wüx tüüch yow nipilan, ¿jane tasaj nej marang aag ayaja? ¿Diosa, ngwüy nipilana? ―aj nejiw. Quiaj tendeacndeacüw nejeyéjan quiaj, tapiüngüw: ―Sitiül apmapiüngaats Teat Dios neech nej miün, quiaj apmasaj icoots: “¿Neol ngo meyariün andeac neje?” apmaw. ");
INSERT INTO huvNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Sitiül apmapiüngaats nipilan, pues imbolaats mandüyiiüts cambaj, cos meáwan nipilan apiüngüw aaga Juan quiaj nop nendeac andeac Teat Dios nej ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Áag tasajüw Teat Jesús: ―Ngo najawan ―awüw. Quiaj tasaj nejiw Teat Jesús: ―At a xique aton ngo nasaj icon jane neech xic niün narang leaw teanarang cam ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Aton tasaj nejiw: ―¿Cuane ajiür meyajcan aaga sanandeac cama? Tajlüy nop naxey ajiür ijpüw micual nej. Condom tamb matüch niüng ajlüy nop, tasaj: “Nganüy xecual, quiür irang najiüt tiül micorrül xeúva”, aj. ");
INSERT INTO huvNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Quiaj tasaj nej micual nej: “Ngo mind”, aw. Ndoj leaad omeaats ngo majneaj arang, quiaj tamb marang najiüt. ");
INSERT INTO huvNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Condom aaga naxey tamb majaw alinop micual nej. Tasaj níüngan atnej landoj masaj a nop. Quiaj tapiüng micual nej: “Najneaj teat, sanamb”, aw. Ndoj ngo mamb. ");
INSERT INTO huvNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Jow nganüy, ngün tiül nejiw tarang leaw andiüm miteatiw nejiw? ―aj nejiw Teat Jesús. Quiaj tapiüngüw: ―Aaga nasoic ombas ―awüw. Quiaj tasaj nejiw Teat Jesús: ―Naleaing sasaj icon, ajcüwa monsap mitomiün cambaj at monjüyjüy montaj apmajmeliw ombas tiül micambaj Teat Dios, ngo mat icona. ");
INSERT INTO huvNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Cos aaga Juan neech yow tiün masaj icon nguineay merangan najneaj, pero icona ngome teyariün andeac nej. Pero altiül ajcüwa monsap mitomiün cambaj, aton altiül monjüyjüy montaj tayariw nej andeac. Icona masey tejawan aag ayaj, ngo leaam imeajtsan mecueatiün irangan ngo majneaj, meyariün andeac nej. ");
INSERT INTO huvNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","’Inguiayiün alinoic leaw sanasaj icon: Tajlüy nop nateateran tapiür xeyay owil uva tiül micorrül nej, tarang najneaj owil corrül. Condom tarang noic pil tiüt tiül piedra niüng apmacuüücharan najün uva maw miyow nej. Aton tarang nop najal oleaj iüm nasoic torre niüng alndom macüleran cawüx majiürüch a corrül. ’Ndoj tayac teowix nipilan aaga corrül quiaj, cas tamb andüy alinoic iüt. ");
INSERT INTO huvNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Wüx lamatüch a nüt mapeederan najün uva, quiaj aaga neneay corrül tüüch mamb acas monbeol nej majawüw monrang najiüt, mayariw leaw netam müünd neneay iüt. ");
INSERT INTO huvNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Naleaing ajcüwa monrang najiüt tasapüw ajcüwa monbeol. Nop tatoliw, alinop nómban tambiyaw, alinop taloxiw. ");
INSERT INTO huvNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Aaga neneay iüt quiaj tandüy wüx müüch mamb alacas monbeol nej. Atanej tarangüch wüx ombasüw aton. ");
INSERT INTO huvNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Ndójwüx quiaj tüüch mamb micual nej, cos tapiüng: “Netam mayariw andeac xecual”, aw. ");
INSERT INTO huvNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Naleaing ajcüwa monrang najiüt, wüx tajawüw micual neneay iüt, quiaj tapiüngüw nejíwan quiaj: “Nej aag ayaj apmeneay aaga corrül cam. Tabaats mambiyaats, ndoj icoots apmaneayiiüts a iüt cam”, awüw. ");
INSERT INTO huvNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Quiaj tasapüw mawüniw tiül corrül, ndoj tambiyaw nómban. ");
INSERT INTO huvNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","’Jow, wüx apmapeay aaga naxey neneay iüt, ¿cuane apmarang wüx ombasüw ajcüwa monrang najiüt quiaja? ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Quiaj tapiüngüw: ―Aaga neneay iüt apmambiy ajcüwa ngo majneaj monrang najiüt quiaj, ngome apmajiür nejiw lasta. Condom aaga iüt apmayac teowix alinoic ajlüy monrang najiüt para alndom müjchiw nej leaw netam müünd wüx apmatüch a nüt mapejtich najün uva ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Condom tasaj nejiw Teat Jesús: ―¿Neol, ngo meteowan nguineay apiüng tiül Mipoch Teat Dios? cos apiüng: Aaga piedra leaw taloxiw ninguiün monrang iüm, nganüy laíün marang xeyay netam piedra tiül oxing iüm. Teat Dios nerang aag ayaj, ajawaats aag ayaj xeyay najneaj, aw. ");
INSERT INTO huvNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","’Pares sasaj icon langome apmejlüyiün tiül micambaj Teat Dios. Apmüünd palpálwüx nipilan leaw apmarang atnej andiüm Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Jane apmajmiüc wüx aaga piedra quiaj apmapol nej. Pero sitiül aaga piedra quiaj apmajmiüc wüx ombas aljane, nómban apmacuiaach nej tiüt ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ajcüwa montangtang miteaats y fariseos, wüx tanguiayiw leaw teamandeac Teat Jesús, quiaj leaad omeajtsüw aag ayaj andüy wüx ombasüw nejiw amb apiüng. ");
INSERT INTO huvNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Quiájan tandiümüw masapüw nej; pero naleaing timboloj mandüyiw cambaj, cos meáwan nipilan apiüngüw Teat Jesús nop nej nendeac andeac Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Teat Jesús tandüy wüx alinomb masaj nejiw acas poch ngome aleaing miün, tapiüng: ");
INSERT INTO huvNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―Tiül micambaj Teat Dios ajlüy atnej arang nop minatang nenajiüt, tayac nangos nüt wüx angoch owix micual nej. ");
INSERT INTO huvNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Tüüch mambüw mimonbeol nej majanüw leaw najpajüw niüng aaga nengoch owix. Naleaing ajcüwa najpajüw quiaj, ngo mandiümüw mambüw. ");
INSERT INTO huvNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Tandüy wüx müüch mamb alacas mimonbeol nej, tasaj: “Isajan ajcüwa landoj iün majpajüw: Landoj lajlüy leaw apmüeteran, lanambiy xeboy, at leaw naxipxip xenimal. Meáwan lajlüy, isajan miünüw niüng nengoch owix”, aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ajcüwa iün majpajüw quiaj, ngo mandiümüw. Nop tamb tiül corrül, alinop tamb menüjpeay. ");
INSERT INTO huvNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Alacas tasapüw ajcüwa monbeol, quiaj tapots matoliw, ndoj tambiyaw nómban. ");
INSERT INTO huvNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Wüx tanguiay aag ayaj a minatang nenajiüt tajcüy xeyay, tüüch mambüw misoldados nej mandrojchiw ombas ajcüwa ngo majneaj nipilan quiaj, mambel micambajüw nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Condom quiaj tasaj mimonbeol nej: “Meáwan lajlüy, pero ajcüwa najpajüw ngo metamüw nicuajind. ");
INSERT INTO huvNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Nganüy quiüran meáwan tiül tiiüd, isajan nipilan leaw apmexoman ich miünüw ningüy niüng nengoch owix”, aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Quiaj tambüw tiül tiiüd ajcüwa monbeol quiaj, tapots masojnongoj meáwan nipilan leaw axomüw, masey monrang najneaj, masey monrang ngo majneaj. Condom chipiow a nden niüng nengoch owix. ");
INSERT INTO huvNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Condom aaga minatang nenajiüt quiaj tajmel majaw meáwan monlüy quiaj. Quiaj tajaw altiül nop ngo masooig apix nej atnej netam majiür monamb niüng nengoch owix. ");
INSERT INTO huvNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Quiaj tasaj: “Amigo, ¿neol nguineay tejmel ningüy sitiül ngo mesooig leaw asoijquiw monamb niüng nengoch owixe?” aj. Aaga naxey quiaj lombójan, ngo mendeac. ");
INSERT INTO huvNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Quiaj aaga minatang nenajiüt tasaj mimonbeol nej: “Isapan, itsajcan oleaj owix, iloxiün ninguiün tiül ngo majneaj tiül pojniün niüng ajlüy monjiünts, niüng aporros olüiqueran”, aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Cos xeyay najpajüw, pero napateay narriüjtüch ―aw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Condom tawüw quiaj ajcüwa fariseos, tapots mandeacndeacüw nguineay alndom masapüw Teat Jesús wüx leaw apmandeac. ");
INSERT INTO huvNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Quiaj tüjchiw mamb minipilanüw nejiw at alacas minipilan Herodes masajüw Teat Jesús, tapiüngüw: ―Teat, sajawan ique xeyay indiüm mejaw manderac leaw naleaing, aton iquiaach leaw apiüng Teat Dios atnej netam. Ique ngo mepiüng wüx leaw andeac nipilan. Aton ique ngo meamb wüx mejaw jane netam jane ngwüy. ");
INSERT INTO huvNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Sandiüman nanguiayiün leaw apmepiüng Teat. ¿Naleaingue netam majwan tomiün müünd a minatang nenajiüt nenüt César, ngwüy ngo metama? ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Naleaing Teat Jesús cos lamajaw neol tatüniw manguiayiw, quiaj tasaj nejiw: ―¡Icona monwüyay arang najneaj! ¿Neol tendiüman mesapan xic wüx leawa sanapiünga? ");
INSERT INTO huvNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Chiün najaw aaga tomiün leaw apmüünd minatang nenajiüt ―aj nejiw. Quiaj tüjchiw nej majaw noic tomiün nasoic denario. ");
INSERT INTO huvNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Almajaw, quiaj tasaj nejiw Teat Jesús: ―¿Jane mitey, jane minüt alwüx a tomiün cama? ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Quiaj tasajüw nej: ―César ―awüw. Quiaj tasaj nejiw Teat Jesús: ―Ijchan a César leaw ocueaj nej, at aton ijchan Teat Dios leaw ocueaj nej ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Wüx tanguiayiw aag ayaj mbayajow manguiayiw, acueatíwan nej, tawüw quiaj. ");
INSERT INTO huvNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Tíülan aaga nüt quiaj tapeayiw majawüw Teat Jesús acas saduceos. Ajcüw ayaj apiüngüw mondeow langome apmapacüw alinomb. Tatüniw manguiayiw: ");
INSERT INTO huvNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","―Maestro, teat Moisés apiüng sitiül nop naxey mandeow, nganaw majiürüw micualüw nejiw, michiig nej netam mengoch owix aweaag aaga lemben omal najtaj quiaj, majiürüw micualüw nejiw atnej majlüy micual micoj nej. ");
INSERT INTO huvNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Atquiaj tajlüy tiül xicona, cos tajlüy ayaíw monxey nop necual nejiw. Aaga natang tiül nacojaran tengoch owix, ndoj tandeow nganaw majiürüw micualüw nejiw. Condom michiig nej tengoch owix aweaag aaga lemben omal quiaj. ");
INSERT INTO huvNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Atanej tajlüy wüx michiig nej, tandeow aton. Condom átan amb alinop michiig nej. Atquiaj tengoch owixaw maquiüjpüw aaga najtaj meáwan ajcüwa ayaíw monxey. ");
INSERT INTO huvNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ndójwüx, nejay a najtaj tandeow. ");
INSERT INTO huvNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Jow alinoic nüt wüx apmapacaran tiül mondeow, ¿ngün tiül nejiw ajcüwa ayaíw monxey apmaquiüjpüw aaga najtaj quiaja, cos meáwan tengoch owixaw maquiüjpüw? ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Quiaj tasaj nejiw Teat Jesús: ―¡Ngo mejawan cuane teamendeacan quiaj, cos ngo mejawan cuane ajlüy tiül Mipoch Teat Dios; aton ngo mejawan cuane alndom marang Teat Dios! ");
INSERT INTO huvNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Cos wüx apmapacaran alinomb ngome apmequiiübayej, cos apmajlüyeran nóiquian atnej ángeles ocueaj Teat Dios najlüyiw tiül cielo. ");
INSERT INTO huvNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Nganüy wüx aaga ipiüngan apacaran tiül mondeow, ¿neol, nómban ngomeaag meteowana nguineay apiüng Teat Diosa? Cos apiüng: ");
INSERT INTO huvNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Xique Midios Abraham, Midios Isaac, Midios Jacob, ajcüw tajlüyiw tanomb”, aw. Cos Teat Dios ngome Midiosüw mondeow, nej Midiosüw leaw almapac ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Nipilan wüx tanguiayiw aag ayaj mbayajow manguiayiw aquiaach. ");
INSERT INTO huvNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Wüx ajcüwa fariseos tanguiayiw nguineay Teat Jesús lamüüch mapalüw ombeayiw a saduceos, quiaj canchiütoj. ");
INSERT INTO huvNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Condom nop tiül nejiw, nop nendüy wüx minawiig Moisés, tatün manguiay Teat Jesús majaw cuane apmapiüng, tasaj: ");
INSERT INTO huvNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―Maestro, ¿ngün tiül aaga poch tüünd Moisés más xeyay netam marangüche? ―aj. ");
INSERT INTO huvNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Quiaj tasaj nej Teat Jesús: ―“Netam mendiüm Teat Dios con imeaats, con miespíritu, con mifis aton.” ");
INSERT INTO huvNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Aag ayaj alwüx atam, ombas netam marangüch. ");
INSERT INTO huvNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Alinoic andǘüban landiüm atnej, apiüng: “Ijiür lasta jangantanej atnej ijiürüy lasta iquiáyan quiaj”. ");
INSERT INTO huvNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Naw wüx aaga ijquiaw poch andeac Teat Dios quiaj, ajlüy meáwan poch leawa Moisés tayac, at leaw taquiajchiw mondeac andeac Teat Dios ―aj nej Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Wǘxan canchiüjow quiaj a fariseos, quiaj tatün manguiay nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Tapiüng: ―¿Cuane ipiüngan wüx aaga Cristo, aag lapiürang aliüca? ¿Jane mixeech neje? ―aj nejiw. Quiaj tapiüngüw: ―David ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Condom Teat Jesús tasaj nejiw: ―Neol, nguineay a David tasaj: “Teat Naxey”, maj, wüx tandeac leaw tasaj nej Nangaj Espíritu ocueaj Teat Dios, cos tapiüng: ");
INSERT INTO huvNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Teat Dios tasaj a Teat Naxey, aaga Cristo: “Cheter ningüy amb wüx xeác, leaw ndoj nayac moncüy majaw ic maquiejliw micosüw nejiw timbas”, aw. ");
INSERT INTO huvNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","¿Nguineay alndom mapiürang David mixeech aaga Cristo, sitiül nejay David tasaj: “Teat Naxey”, maja? ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Quiaj nejinguind ngondom mangoch nej andeac. Ajan wüx aaga nüt quiaj nejinguind ngome tandüy wüx matün manguiay nej nicuajind. ");
INSERT INTO huvNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Condom Teat Jesús tasaj minipilan nej, at altigüy nipilan aton, tapiüng: ");
INSERT INTO huvNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","―Ajcüwa mondüy wüx aaga poch tüünd Moisés, at ajcüwa fariseos chetetoj niüng chetet a Moisés maquiajchiw wüx leawa nej tapiüng. ");
INSERT INTO huvNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Icona netam meyariün leaw aquiajchiw, netam merangan leaw apiüngüw; pero naleaing, nde merangan atnej arangüw nejiw, cos nejiw aquiajchiw najneaj, pero ngo marangüw atnej. ");
INSERT INTO huvNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Nejiw üjchiw nipilan mamalüw leaw xeyay naǘm ngondom mamalüw; pero nejiw ngo mandiümüw marrejquiw aag ayaj masey naag nots micual owixaw. ");
INSERT INTO huvNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Meáwan leaw arangüw, arangǘwan majaw nejiw nipilan. Xeyay andiümüw maoeliw teombas omalüw at wüx owixaw nejiw aaga nine iquial acas Mipoch Teat Dios atnej ajlüyay marangüw. Naleaing nejiw xowüy andiümüw mayacüw leaw nadamdam. Aton apixaw nejiw leaw asoijquiw ajiür najaljal misoots nej ngo matnej leaw asoijquiw meáwan nipilan. ");
INSERT INTO huvNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Aton wüx ajlüy monet xowüy ayambüw chetemoj niüng ajlüy natangtang monajiüt. Átan ayambüw chetemoj niüng alndom malombaranüw tiül sinagogas. ");
INSERT INTO huvNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Aton xowüy andiümüw matepeay nejiw nipilan tiül plas, xowüy andiümüw masoiquiw Rabí, Rabí, majowiw. ");
INSERT INTO huvNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Icona nde meyambyamban mesoiquiün Rabí, cos meáwan icona ijlüyiün atnej nerchiigayon, nercojayon itowtowíün ijlüyiün. Áagan nop nequiaach icon ajlüy, aag ayaj a Cristo leaw lapiürang aliüc. ");
INSERT INTO huvNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Nde mepiüngan wüx nejinguind ningüy wüx a iüt cam: miteatiiüts, merawan, cos áagan Teat Dios najlüy tiül cielo alndom mepiüngan wüx miteatiiüts. ");
INSERT INTO huvNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Nde mendiüman mesoiquiün minatang icon, cos áagan a Cristo leaw lapiürang aliüc, nejay minatangan. ");
INSERT INTO huvNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Jane ayamb nguineay mambeol jangantanej tiül icona, aag ayaj ajlüy atnej natang tiül icona. ");
INSERT INTO huvNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Cos jane ayaag nej natang, apmüünd marang nop ngo membeat nicuajind; aton jane ayaag nej ngo membeat, nej apmarang natang. ");
INSERT INTO huvNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’¡Pobre icona, mondüy wüx aaga poch tüünd Moisés, at aton icona fariseos, ndeac mbeay! ¿Neol ipalan a nipilan, ngo meajchiün majmeliw tiül micambaj Teat Diosa? Icona ngo mendiüman mejlüyiün tiül, aton ngo meajchiün majmeliw leaw andiümüw majmeliw. ");
INSERT INTO huvNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’¡Pobre icona, mondüy wüx aaga poch tüünd Moisés, at icona fariseos, ndeac mbeay! Cos inojtiün aniüngüw monlemben omal montaj at meáwan almajiürüw; ndoj itajcan orar xeyay para majaw icon nipilan, nguineay alndom mexotan irangan ngo majneaj, aag ayaj imbeayíünan. Cos temerangan atquiaj, apmajmel xeyay isoetiün. ");
INSERT INTO huvNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’¡Pobre icona, mondüy wüx a poch tüünd Moisés, at icona fariseos, ndeac mbeay! Cos ijüyjüyiün nguiajantanej wüx iüt, aton tiül ndec, meyamban nipilan mandüjpiw wüx nguineay irangan. Wüx lamandüjpiw leaw irangan, quiaj lameajchiün marangüw xeyay ngo majneaj, alwüx quiriw ngo matnej leaw irangan. ");
INSERT INTO huvNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’¡Pobre icona, at icon somb montiib mitiiüd alinop! Neol ipiüngan: “Sitiül aljane mapaj wüx minüt aaga nadam nangaj iüm cam, aag ayaj ngo membeat; pero jane apmapaj minüt a oro najlüy tiül nadam nangaj iüm, aag ayaj mbich nembeat, netam marang leaw tapiüng”, merawan. ");
INSERT INTO huvNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Icona nerchachiün, nersomban! ¿Neol, ngün alwüx atam, aaga oro, ngwüy nadam nangaj iüma, aaga neech marang nangaj a oro? ");
INSERT INTO huvNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Aton ipiüngan: “Jangantanej leaw apmapaj minüt aaga artül aag ayaj ngo membeat; pero jane apmapaj minüt nichech najmel wüx artül, aag ayaj mbich nembeat, netam marang leaw tapiüng”, irawan. ");
INSERT INTO huvNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Icona nerchachiün, nersomban! ¿Ngün alwüx atama, aaga nichech, ngwüy aaga artül leawa neech mangaj aaga nicheche? ");
INSERT INTO huvNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Leaw apaj minüt artül, aton apaj minüt meáwan leaw najmel wüx. ");
INSERT INTO huvNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","At leaw apaj minüt a nadam nangaj iüm, ngome áagan minüt nadam nangaj iüm quiaj apaj, at apaj Teat Dios aton cos nej acül quiaj. ");
INSERT INTO huvNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Aton jane apaj minüt cielo, apaj minüt niüng chetej Teat Dios. Ngome áagan aton apaj minüt Teat Dios cos nej quiaj chetej. ");
INSERT INTO huvNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’¡Pobre icona, mondüy wüx a poch tüünd Moisés, at icona fariseos, ndeac mbeay! Icona iyacan diezmo naw tiül ajcüwa najmboc angan soex nenüt menta, inix, comino; pero naleaing icueatíünan ngo merangan leaw alwüx atam naw tiül aaga poch tüünd Moisés. Aag ayaj, merangan leaw najneaj, netam mejiüran lasta jangantanej, aton netam meyacan imeajtsan wüx Teat Dios. Ajcüw ayaj xeyay netam meyacan imeajtsan wüx merangan. Aton ngondom mecueatiün meyacan midiezmojan. ");
INSERT INTO huvNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Icona at icon somb montiib mitiiüd alinop, cos ilalan leaw apmenganeowan ngana melajan tiül xix, pero ngo meyajcan sitiül melajan tiül nop camello! ");
INSERT INTO huvNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’¡Pobre icona mondüy wüx poch tüünd a Moisés, at icona fariseos, ndeac mbeay! Ijantsan ombas a tas, at a polat, pero ngo meyamban imeajtsan nguineay texoman leaw apmeyacan tiül, cos meáwan ixomxománan wüx inejtiün. Aton ngondom mersapayon wüx mecueatiün merangan ngo majneaj. ");
INSERT INTO huvNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡Icona fariseos somb! Netam ombas mejantsan amb tiül a tas at a polat, quiaj mbich apmerixix amb wüx ombasüw. ");
INSERT INTO huvNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’¡Pobre icona mondüy wüx poch tüünd a Moisés, at icona fariseos, ndeac mbeay! Cos ijlüyiün at icon mioxiüt mondeow. Ajüic rajnüy ombas; pero amb tiül chipiow olaats, najmboc. ");
INSERT INTO huvNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Atquiaj ijlüyiün icona aton, cos ajüic najneaj irangan, pero naleaing irangánan majaw icon nipilan. Tíülan icona xeyay ngo majneaj amb wüx imeajtsan, at irangrangayon wüx merangan cuajantanej ngo majneaj. ");
INSERT INTO huvNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’¡Pobre icona mondüy wüx poch tüünd Moisés, at icona fariseos, ndeac mbeay! Neol a icona itajcan majneaj mioxiütüw ajcüwa mondeac andeac Teat Dios. At inchoman irangan mimbaj nej ajcüwa nine iüm tarangüch wüx oxiüt. ");
INSERT INTO huvNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ndoj ipiüngan: “Jondot sitiül xicona salnajlüyiün wüx aaga nüt apacüw xexejchiün, nómban ngo naquiüjpan wüx, wüx tambiyaw mondeac andeac Teat Dios”, irawan. ");
INSERT INTO huvNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Icónan quiaj tenguial mejüiquichan naleaing icona micual icon monbiy mondeac andeac Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","¡Nganüy neol jane nepal icon ngo merangan atnej tarangüw mixejchiün! ");
INSERT INTO huvNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’¡At icon ndiüc, micual icon ndiüc! ¿Nguineay apmeriowan wüx, ngo meamban tiül biümba? ");
INSERT INTO huvNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Nganüy sanüüch miün xeyay mondeac andeac Teat Dios, at mondüy, at monquiaach wüx xique. Icona apmembiyan, altiül apmeyacan wüx cruz, altiül apmewüjchiün tiül nangaj iüm. Aton apmeyamban ombasüw tiül tiül cambaj. ");
INSERT INTO huvNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Quiaj apmejiüran xeyay isoetiün, meáwan quiej leaw tajünch tiüt naw wüx tambiyeran Abel, nop nerang najneaj, ndoj wüx a Zacarías micual Berequías, áag tembiyan tiül asapüy nadam nangaj iüm maquiiüb artül. ");
INSERT INTO huvNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Naleaing sasaj icon, meáwan aag ayaj apmamb wüx imbasan. ");
INSERT INTO huvNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","’¡Jerusalén, monaw tiül cambaj Jerusalén! ¿Neol tenguial membiymbiyan ajcüwa mondeac andeac Teat Diosa? ¿Neol teloxiün leawa Teat Dios üüch miün masajüw icon wüx neje? ¡Xique xeyay tandiümas naxejneng icon atnej arang noic quit maxejneng micual nej teombas miolümb nej; pero naleaing icona ngo mendiüman! ");
INSERT INTO huvNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Nganüy apmejawan nguineay apmajcueat aaga nadam nangaj iüm icueajiün. ");
INSERT INTO huvNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Cos sasaj icon langome apmexoman mejawan xic. Apmejawan xic alinomb wüx apmatüch a nüt, quiaj apmepiüngan: “Najneajay ajlüy aaga üüch nej miün Teat Dios”, apmerawan ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Wüx Teat Jesús taw tiül a nadam nangaj iüm laámb apmamb, quiaj minipilan nej tapots masajsajüw nej wüx najneajay ajlüy aaga nadam nangaj iüm maquiiüb ajcüwa nadamdam iüm andüüch aweaag nadam nangaj iüm. ");
INSERT INTO huvNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Quiaj tasaj nejiw Teat Jesús: ―¿Ijawan meáwan aag ayaj? Naleaing sasaj icon, alinoic nüt ngome apmajlüy noic piedra mesapüy maquiiüb alinoic, cos meáwan apmümb majarricharan ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Condom tambüw andüyiw wüx mitiüc Olivos. Wüx Teat Jesús alchetem, quiaj tatüniw manguiayiw nej minipilan nej wüx tajlüyiw nejíwan quiaj, tasajüw: ―Teat, sandiüman mesaj xicon, ¿ngow apmajlüy meáwan aag ipiüng quiaja? ¿Cuane apmajüic majaraw wüx iliüc alinomb, wüx apmümb minüt a iüt cama? ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Quiaj tasaj nejiw Teat Jesús: ―Ijawan, nde mawaiich icon nejinguind. ");
INSERT INTO huvNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Cos xeyay nipilan aliücüw miün, apmayariw xenüt, apmapiüngüw: “Xique aaga Cristo”, apmawüw; quiaj apmawaijchaw xeyay nipilan. ");
INSERT INTO huvNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Aton apmenguiayiün apmanderac wüx montsoj mapiüngüw lajlüy, tengwüy laliüc majlüy. Masey, nde mbayameron, cos atquiaj netam majlüy; pero nganaw matüch mümb minüt a iüt cam. ");
INSERT INTO huvNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Cos monaw tiül noic iüt apmembiyayej maquiüjpüw monaw tiül alinoic iüt, at monaw tiül noic cambaj maquiiüb monaw alinoic cambaj. Aton apmajlüy lop, monandeow, at aton apmajlang nadamdam ateam tiül palpálwüx iüt. ");
INSERT INTO huvNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Meáwan aag ayaj les tamelich ajlüy xeyay ngo majneaj, xeyay necoy. ");
INSERT INTO huvNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Apmayacüw icon teowixaw monajiüt müjchiw icon memongochiün necoy, aton apmembiyaranan. Apmajcüyiw majawüw icon meáwan nipilan ajcan iyariün sandeac. ");
INSERT INTO huvNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Wüx aaga nüt quiaj xeyay leaw tapiüngüw ayariw sandeac apmacueatiw. Altiül apmajcüyiw majawüw icon, altiül apmayacüw icon teowixaw monajiüt. ");
INSERT INTO huvNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Apmajlüy xeyay monwaiich. Apmapiüngüw mondeac andeac Teat Dios nejiw. Quiaj apmawaijchaw xeyay nipilan. ");
INSERT INTO huvNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Cos apmajlüy xeyay ngo majneaj, langome apmajiürüw lasta alinop. ");
INSERT INTO huvNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Jane ngo macueat, pero apmaíüc wüx meáwan aag ayaj leawa ümb mamong, Teat Dios apmawün nej wüx. ");
INSERT INTO huvNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Aaga najneaj nanderac cam leaw apiüng wüx nguineay Teat Dios andiüm meáwan nipilan majlüyiw tiül micambaj nej, netam manguiayiw meáwan palpálwüx nipilan wüx iüt. Quiaj ndoj apmümb minüt aaga iüt cam. ");
INSERT INTO huvNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’Tanomb teat Daniel, nop nendeac andeac Teat Dios, tarang wüx nawiig, tapiüng wüx aaga xeyay ngo majneaj leaw apmüüch ndrom ombas cambaj. Wüx apmejawan aag ayaj lajlüy lapeay tiül aaga nadam nangaj iüm ―jane teamateow ich mayamb omeaats majaw cuane wüx apiüng. ");
INSERT INTO huvNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Quiaj leaw altiül Judea ich mecuiür andüy tiül tiüc. ");
INSERT INTO huvNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Sitiül aaga nüt quiaj aljane ngome altiül iüm, nde majmel mawün leaw ajiür. ");
INSERT INTO huvNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Aton sitiül aljane altiül corrül, aton nde mandilil andüy aniüng nej maxaing apix nej. ");
INSERT INTO huvNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Pobre nejiw ajcüwa müm montaj leaw alteomeajtsüw micualüw nejiw, at leawa tenguial achech micualüw nejiw wüx aaga nüt quiaj! ");
INSERT INTO huvNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Itüniün ocueaj Teat Dios nde müüch icon mercuiürran wüx ajlüy naquind, tengwüy wüx nüt axoodaran. ");
INSERT INTO huvNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Cos apmamongocharan xeyay ngo majneaj, leaw nómban ngomeaag ajaraw nde wüx Teat Dios tarang aaga iüt, aton ngome apmajaraw alinomb. ");
INSERT INTO huvNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Wüx aaga nüt quiaj, sitiül Teat Dios apmüüch majlüy aaga ngo majneaj quiaj xeyay nüt, nejinguind ngondom mapac. Naleaing Teat Dios apmandondoch najen aag nüt quiaj, cos xeyay ajiür lasta minipilan nej leawa lamarriiüd. ");
INSERT INTO huvNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Sitiül aljane apmasaj icon: “Jogüy a Cristo”, maw, tengwüy mapiüng: “Joyaj a Cristo”, maw, nde meyariün andeac nej. ");
INSERT INTO huvNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Cos aliücüw xeyay monwaiich, altiül apmapiüngüw Cristo nejiw, altiül apmapiüngüw mondeac andeac Teat Dios nejiw. Apmarangüw ateócan mambaijchaw nipilan, apmawaijchaw xenipilan leaw lanarriiüd jondot alndom. ");
INSERT INTO huvNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Nganüy lanasaj icon aag ayaj wǘxan nganaw majlüy. ");
INSERT INTO huvNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Atquiaj sitiül apmasajüw icon: “Ijawan, alninguiün aaga Cristo tiül wajchiüc”, majüw icon, nde meamban mejawan. Tengwüy apmasajüw icon: “Joíün altiül iüm”, majüw icon, nde meyariün andeacüw nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Cos Teat Naxey, wüx aliüc aag ayaj apmajlüy najen, atnej noic ajlip nómban alipiich naw nonüt andüy noleat. ");
INSERT INTO huvNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Nquiajantanej niüng ajlüy mondeow, quiaj alponongom potwit. ");
INSERT INTO huvNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","’Wüx landoj ajlüy aaga xeyay ngo majneaj quiaj, nüt lango merraj, at a caaw aton; at ocas apmajmiüc imiün tiül cielo. Meáwan leaw ajlüy cawüx apmajüyjüy apmelanglangüy. ");
INSERT INTO huvNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Condom apmajaraw tiül cielo aliüc a Teat Naxey. Quiaj apmajiüntsüw meáwan nipilan wüx a iüt cam; apmajawüw a Teat Naxey laliüc amb tiül oic xeyay najneajay ajlüy, nelitlit. Nop nej minatang nenajiüt. ");
INSERT INTO huvNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Quiaj apmasaj ángeles maindeaw trompet napac, masojnongoj meáwan minipilan nej wüx iüt, imiünüw nonüt, noleat, calüy, cawac. ");
INSERT INTO huvNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Ijawan nguineay arang a toc: Cos wüx latsatsaw mipüüig nej mayac aóp, quiaj ajüic laliüc matüch a nüt merraar. ");
INSERT INTO huvNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","At icona aton wüx apmejawan lajlüy aag lanasaj icon quiaj, quiaj netam mejawan laliüc matüch a nüt mapeay aaga nüünd miün. ");
INSERT INTO huvNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Naleaing sasaj icon meáwan aag ayaj apmajlüy wǘxan aliün majlüyiw ajcüwa nipilan quiaj. ");
INSERT INTO huvNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Masey a iüt, at a cielo apndrom ombasüw, xepoch nómban ngo ndrom ombas. ");
INSERT INTO huvNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Wüx aaga nüt, at wüx aaga ores wüx apmajlüy aag ayaj, nejinguind ngo majaw. Ángeles tiül cielo ngo majawüw aton. Néjan quiaj Xeteat Dios ajaw. ");
INSERT INTO huvNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Wüx aliüc Teat Naxey, apmajlüy atnej tajlüy tanomb wüx almapac Noé. ");
INSERT INTO huvNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Cos atnej tajlüy wüx nganaw ndilimeay a iüt cam tiül yow, nipilan ngo mapiüngüw wüx, netiw, nanganeowüw, angoch owixaw atnej mbójan marangüw. Atquiaj tatüch a nüt majmel tiül nadam müx a Noé. ");
INSERT INTO huvNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Nejiw ngo meteotsüw nicuajind. Wüx tajngot a napac ijchiür, tajal a yow anmambich mandrooch nej ombasüw meáwan nipilan. Atquiaj apmajlüy aton wüx aliüc Teat Naxey. ");
INSERT INTO huvNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Wüx aaga nüt quiaj apmajlüy ijpüw monxey tenguial arangüw najiüt tiül corrül. Nop apxaijnguiam, alinop apmacǘlan. ");
INSERT INTO huvNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Aton apmajlüy ijpüw montaj teanchiülüw, nop apxaijnguiam, alinop apmacǘlan. ");
INSERT INTO huvNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Icona netam mecüliün ipacüjchiün iniüjcan cos ngo mejawan cojores aliüc a Teat Naxey. ");
INSERT INTO huvNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ijawan, jondot nop nateateran majaw cuame ores apmajmel aniüng nej need, ngome apmameay, ngo müüch majmel tiül nden maneed. ");
INSERT INTO huvNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Atquiaj icona aton netam mecüliün nej, cos Teat Naxey apmandilil wüx ngome teateotsaran. ");
INSERT INTO huvNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","’Tajlüy nop neneay najiüt tajiür nop nembeol nej, xeyay axom omeaats, najneaj arang. Aaga neneay najiüt tayac teowix nembeol nej aniüng nej majaw nej ocueaj, mawiül monlüy quiaj, müüch nejiw leaw netam; ndoj tamb. ");
INSERT INTO huvNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Najneajay apmajlüy aaga nembeol quiaj wüx apmandilil aaga neneay najiüt sitiül apmaxom nej teamarang meáwan leaw lamasaj. ");
INSERT INTO huvNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Naleaing sasaj icon, aaga neneay najiüt quiaj ndójwüx apmayac teowix aaga nembeol quiaj meáwan leaw almajiür majaw nej ocueaj. ");
INSERT INTO huvNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Nganüy sitiül ndot aaga nembeol quiaj marang ngo majneaj, mapiüng neneay najiüt nequiy apmapeay; ");
INSERT INTO huvNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ndoj tapots mawüüch aquiüjpüw nej, at üetǘetan, angüngǘnan maquiiüb mongün. ");
INSERT INTO huvNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ndot tealeámban aag ayaj, quiaj apeay aaga neneay najiüt wüx nüt ngo leaam omeaats a nembeol macül nej. ");
INSERT INTO huvNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Quiaj apmüüch majwüch mamongoch xeyay necoy, ndoj apmayac maquiiüb tiül ajcüwa monrang ngo majneaj, niüng ajlüy monjiünts niüng apmeporros olüiqueran. ");
INSERT INTO huvNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","’Micambaj Teat Dios najlüy tiül cielo apmajlüy atnej tajlüy wüx gajpowüw monüx leaw tambüw mangochiw nengoch owix, ajoyiw candil. ");
INSERT INTO huvNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Acoquiaw nejiw ajcüwa monüx quiaj leaad omeajtsüw majoyiw leaw netam, alacoquiaw ngo leaam omeajtsüw nicuajind. ");
INSERT INTO huvNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Nejiw masey ajoyiw candil, naleaing ngo majoyiw aceite. ");
INSERT INTO huvNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Pero ajcüw leaw leaad omeajtsüw leaw netam, ngome áagan candil ajoyiw, aton tajoyiw altegüy aceite amb tiül limet. ");
INSERT INTO huvNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Cos nengoch owix tequiy mapeay, quiaj tind ameayiw, ndoj tameayiw. ");
INSERT INTO huvNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Wüx tatüch pinawan ongwiiüts, quiaj tanguiayiw noic nanderac, tapiüng: “¡Jogüy lapeay a nengoch owix; witiüron ingochiün!” aw. ");
INSERT INTO huvNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Quiaj witiütoj a monüx macheniw micandileaw nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ajcüwa ngo majoyiw leaw netam tasajüw aquiüjpüw nejiw: “Ijchan xicon noic pite miaceitejan cos teapiniow xecandilean”, ajüw. ");
INSERT INTO huvNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ajcüwa monüx leawa tajoyiw leaw netam tapiüngüw: “Ngwüy cos condom langome apmatüch xicueajiün, aton ngome apmatüch icon. Neol ngo meriümban niüng ajnap mengalan”, awüw. ");
INSERT INTO huvNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ajcüwa acoquiaw monüx leaw ngo majoyiw leaw netam, wüx laambüw angalüw aceite, quiaj apeay a nengoch owix. Leaw monüx tajoyiw leaw netam tajmeliw tiül nden maquiüjpüw nengoch owix. Quiaj tapalüch ombeay nden. ");
INSERT INTO huvNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Condom quiaj tapeayiw ajcüw alacoquiaw monüx, tapiüngüw: “¡Teat, teat, ileaaig ombeay nden najmeliün!” awüw. ");
INSERT INTO huvNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Quiaj tasoiquiw: “Naleaing sapiüng, ngo najaw jane icon”, ajowiw ―aw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Condom Teat Jesús tasaj nejiw: ―Icona netam mecüliün ipacüjchiün iniüjcan, cos ngo mejawan ngün nüt, cuame ores apmandilil a Teat Naxey. ");
INSERT INTO huvNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","’Micambaj Teat Dios ajlüy atnej tarang nop naxey, cos wüx laliüc mamb tiül alanoic iüt, quiaj tapaj mimonbeol nej, tayac teowixaw mitomiün nej. ");
INSERT INTO huvNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","’Nop tiül nejiw tüüch acoquiaw mil tomiün, alinop ijquiaw mil, at alinop noic mil. Tüüch nejiw anopnopoj leaw ajaw alndom maxaing tiüt marangayej najiüt naw wüx aaga tomiün quiaj. Condom tamb. ");
INSERT INTO huvNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Aaga nembeol leaw tüünd acoquiaw mil tomiün tangal cuajantanej manüüb. Quiaj taxom wüx alacoquiaw mil. ");
INSERT INTO huvNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Atanquiaj tarang alinop leaw tüünd ijquiaw mil; taxom wüx alijquiaw mil. ");
INSERT INTO huvNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Pero nganüy aaga leaw tüünd noic mil tamb maxot, taood iüt mamiüt tiül. ");
INSERT INTO huvNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Lamajiür xeyay nüt, quiaj tapeay aaga naxey majaw mimonbeol nej, mateow a tomiün majaw nguitow taxomüw wüx. ");
INSERT INTO huvNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Quiaj tajngot aaga nüünd acoquiaw mil tomiün, ajamiün wüx alacoquiaw leaw axom wüx, tapiüng: “Teaach xic acoquiaw mil tomiün; jogüy alacoquiaw leawa taxomas wüx”, aw. ");
INSERT INTO huvNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Quiaj tasaj nej aaga naxey: “Najneajay terang teat, cos masey napateay süüch ic, ique teyamb nguineay mexom wüx alquiriw. Nganüy sanüüch ic mejiür nadam najiüt. Ich mapac imeaats, apmecül ningüy niüng sacül”, aj nej. ");
INSERT INTO huvNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Condom tajngot alinop leaw tüünd ijquiaw mil tomiün, tapiüng: “Teat, teaach xic ijquiaw mil. Nganüy jogüy mitomiün, alwüx alijquiaw leaw taxomas wüx”, aw. ");
INSERT INTO huvNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Quiaj tasaj nej aaga neneay najiüt: “Najneajay terang teat, cos masey napateay süüch ic, ique teyamb nguineay mexom wüx alquiriw. Nganüy sanüüch ic mejiür nadam najiüt. Ich mapac imeaats, apmecül ningüy niüng sacül”, aj nej. ");
INSERT INTO huvNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Wüx tajngot alinop leaw tüünd noic mil, quiaj tapiüng: “Teat, xique sapiüng xowüy apmejcüy. Sajaw ique ixaing omeaats corrül masey ngome iquiay ipiür, aton iwit masey ngome iquiay itendeay. ");
INSERT INTO huvNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Áag timbolas, quiaj tambas naxot mitomiün tiül loliüt. Nganüy jogüy mitomiün, aliün majlüy leaw ineay”, aw. ");
INSERT INTO huvNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Quiaj tasaj nej aaga neneay najiüt: “Ique ngo majneaj irang, neranch. Sitiül ipiüng saxaing masey ngome xique sapiür, at sawit leaw ngome xique satendeay; ");
INSERT INTO huvNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","neol ngo meajchiw xetomiün leaw ijaw alndom maxomüw wüx alquiriw, condom wüx sanapeay sanayar xetomiün alwüx quiriw”, aj nej. ");
INSERT INTO huvNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Condom quiaj tapiüng: “Inojtiün ocueaj a noic mil tomiün quiaj, ijchan leaw ajiür gajpowüw mil. ");
INSERT INTO huvNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Cos leaw almajiür apmüünd, ndoj apmajiür xeyay; pero leaw ngo majiür apmajnot ocueaj aaga quiriw leaw ajiür. ");
INSERT INTO huvNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Nganüy aaga neánch quiaj, iloxiün ninguiün tiül pojniün, niüng apmajiünts, apmenchicnchic olüic”, aj nejiw a neneay najiüt. ");
INSERT INTO huvNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","’Wüx apmandilil a Teat Naxey, xeyay najneajay apmajlüy; ancalitlit, ayeyiw nej tiüt meáwan miángeles nej. Quiaj apchetem wüx najneajay niüng chetej minatang nenajiüt. ");
INSERT INTO huvNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Condom apcanchiümoj niüng ajlüy nej meáwan nipilan wüx iüt. Quiaj nej apmarriiüd nejiw atnej arang nop nejiür sap, awün pálwüx sap, pálwüx teants. ");
INSERT INTO huvNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ndoj apmayac ajcüwa sap amb wüx miác nej, nganüy a teants amb wüx miquiamb nej. ");
INSERT INTO huvNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Condom aaga minatang nenajiüt apmasaj ajcüw ajlüyiw amb wüx miác nej: “Macaron, cos najneajay lamambeol icon Xeteat. Nganüy ijmeliün tiül aaga najneajay cambaj tarangüch meneayiün wüx Xeteat Dios tarang a iüt cam. ");
INSERT INTO huvNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Cos wüx telopas, icona teajchiün xic süet; wüx tind sanganeow yow, icona teajchiün xic yow nanganeow. Tajlüyiüs atnej nop napeay miün nipilan, icona teajchiün xic niüng saxood. ");
INSERT INTO huvNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Wüx ngo najiür sapix icona teajchiün xic; tiün sandeow, icona teamban mejawan xic. Tajlüyiüs tiül manchiüc icona temongon mejawan xic”, apmaj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Condom ajcüwa monrang najneaj quiaj apmapiüngüw: “¡Teat! ¿Ngüt sajawan ic iíünd, xicona tüüchasan ic ite? ¿Ngüt tind inganeow yow, xicona tüüchasan ic menganeowa? ");
INSERT INTO huvNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Ngüt sajawan ic ipeay, quiaj tüüchasan ic niüng ixooda? ¿Ngüt ngo mejiür ipix, quiaj tüüchasan ique? ");
INSERT INTO huvNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Aton ngüt sajawan ic niün indeow, aton ngüt ijmel tiül manchiüc, quiaj tambasan najawan ique?” apmawüw. ");
INSERT INTO huvNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Quiaj apmasaj nejiw aaga minatang monajiüt: “Naleaing sasaj icon, cuajantanej leaw terangan membeolan alinop xenipilan, aag ayaj sayac atnej xique temembeolan”, apmaj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Condom quiaj apmasaj ajcüwa najlüyiw amb wüx miquiamb nej: “Iriowan ningüy niüng sajlüy, icona monrang ngo majneaj. Apmeamban tiül biümb niüng ngondom xejquem, leaw tarangüch niüng apmamb nimeech maquiiüb monbeol nej. ");
INSERT INTO huvNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Cos wüx telopas, icona ngo meajchiün xic süet, wüx tind sanganeow yow, icona ngo meajchiün xic yow nanganeow. ");
INSERT INTO huvNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Tajlüyiüs atnej nop napeay miün nipilan, icona ngo meajchiün xic niüng saxood. Wüx ngo najiür sapix icona ngo meajchiün xic. Tiün sandeow, aton tajlüyiüs tiül manchiüc, icona ngo memongon mejawan xic”, apmaj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Condom quiaj nejiw apmapiüngüw aton: “Teat, ¿ngüt tajawasan ic tenguial indeow lop, tind inganeow, ngo nüjchiün ique? ¿Ngüt iyamb niüng ixood xicona ngo nüjchiün ique? ¿Ngüt ngo nüjchiün ic ipixe? ¿Ngüt tiün indeow, teamb tiül manchiüc, xicona ngo nambeolan ique? ¿Ngüt aag ayaja?” apmawüw. ");
INSERT INTO huvNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Quiaj apmasaj nejiw aaga minatang nenajiüt: “Naleaing sasaj icon, cuajantanej ngo mendiüman merangan para membeolan alinop, masey nop ajüic más ngo metam tiül, pues atnej xique temerangan wüx ximbas”, apmaj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ndoj ajcüw ayaj apmambüw tiül castigo meáwan nüt, pero leaw monrang najneaj apmambüw macüliw tiül cielo meáwan nüt ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Wüx Teat Jesús landoj mapiüng meáwan aag ayaj, quiaj tasaj minipilan nej: ");
INSERT INTO huvNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―Icona lamejawan aliün ic nüt apmajlüy a nangos nüt pascua. Quiaj a Teat Naxey, apmayacüw nej teowixaw monajiüt mambiyaw nej wüx cruz ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Condom quiaj ajcüwa montangtang miteaats, at mondüy wüx aaga poch tüünd Moisés, aton monajiüt tiül nipilan judío canchiütoj tiül nden aniüng Caifás, aaga minatang miteaats. ");
INSERT INTO huvNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Tapots mayambüw nguineay apmawaijchaw para masapüw Teat Jesús mambiyaw. ");
INSERT INTO huvNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ndoj tapiüngüw: ―Ngondom marangaats aag ayaj wüx nangos nüt cos nipilan apmajcüyiw, apmajlüy xeyay monyaingyaing ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Teat Jesús altiül cambaj Betania alaniüng Simón, nop laíün wüx axom nej noic ngo majneaj necoy nasoic lepra. ");
INSERT INTO huvNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Quiaj tajngot nop najtaj ajamiün najmboc angan aceite xeyay nembeat, chipiow nop nine iquial narangüch najneaj piedra nenüt alabastro. Wüx aliw wüx mes tenguial üetiw, quiaj aaga najtaj tateng wüx omal Teat Jesús aaga najmboc angan aceite. ");
INSERT INTO huvNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Minipilan nej wüx tajawüw aag ayaj altiül tajcüyiw, tapots mapiüngüw: ―¿Neol tandrooch ombas aaga najmboc angan aceite quiaja? ");
INSERT INTO huvNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Cos sitiül majnap apmambeat xeyay, mambeolaran nipilan ngo majiür ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Teat Jesús tayaag leaw teamandeacüw, quiaj tasaj nejiw: ―¿Neol tapots mesajsajan a müm najtaj cama? Icueatiün; nej lamarang noic xeyay najneaj wüx ximbas. ");
INSERT INTO huvNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Cos leaw nipilan ngo majiür aliw ningüy mequiüjpan meáwan nüt, alndom membeolan wüx indiüman; xique ngome meáwan nüt sanajlüy ningüy naquiiüb icon. ");
INSERT INTO huvNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Leaw lamarang a müm najtaj quiaj, wüx tateng najmboc angan aceite wüx ximbas, aag ayaj lamarang nómban atnej apmarangüch wüx ximbas wüx sanamiüraad. ");
INSERT INTO huvNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Naleaing sasaj icon, nguiajantanej wüx aaga iüt cam niüng apmanderac wüx aaga najneajay nanderac nguineay alndom nawün wüx asoeteran, quiaj apmanderac wüx aaga müm najtaj cam nguineay tarang, para leaam omeaatsaran wüx nej ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Condom nop nenüt Judas Iscariote, nop naw tiül ajcüwa gajpiüp (12) tamb mandeac aweaag montangtang miteaats. ");
INSERT INTO huvNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Tasaj nejiw: ―¿Nguitow apmeajchiün xic sitiül ndot nayac tiül iwixan aaga Jesús? ―aj nejiw. Quiaj tüjchiw nej nimiow gajpowüw (30) tomiün plata. ");
INSERT INTO huvNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Naw quiaj aaga Judas tapots mayamb nguineay mayac Teat Jesús teowixaw monajiüt. ");
INSERT INTO huvNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Wüx amelich aaga nangos nüt üeteran pan ngo majmel levadura, quiaj minipilan Teat Jesús tambüw matüniw manguiayiw nej, tasajüw: ―¿Nguiane indiüm teat, namban natajcan majneaj niüng apmetiiüts wüx pascua? ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Quiaj tasaj nejiw: ―Quiüran tiül cambaj, indüyiün aniüng nop naxey, isajan: “Teat Xan apiüng: Laliüc mümb xenüt, sandiüm narang nangos nüt pascua iniüng, naquiiüb xenipilan, aw”, irajan ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Minipilan nej tarangüw atnej tasoiquiw, tayambüw meáwan leaw apmüetiw wüx pascua. ");
INSERT INTO huvNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Wüx langwiiüts Teat Jesús chetet wüx mes maquiiüb gajpiüp (12) minipilan nej. ");
INSERT INTO huvNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Wüx tenguial üetiw, quiaj tasaj nejiw: ―Naleaing sasaj icon, nop tiül icona apmayac xic teowixaw monajiüt ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Quiaj tamix omeajtsüw xeyay, tapots matüniw manguiayiw anopnopoj, tapiüngüw: ―¿Jane, ngwüy xique? ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Quiaj tasaj nejiw Teat Jesús: ―Nop teasüet anaag nóiquian tiül polat, aag ayaj apmayac xic teowixaw monajiüt. ");
INSERT INTO huvNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Teat Naxey apmamongoch atnej apiüng tiül Mipoch Teat Dios; pero xeyay ngo majneaj apmamongoch aaga naxey leaw apmayac teowixaw monajiüt a Teat Naxey. Najneajay sitiül nej ngo wijquiam ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Quiaj tendeac a Judas, áag teamandiüm mayac nej teowixaw monajiüt, tasaj nej: ―Teat, ¿jane, ngwüy xique? ―aw. Quiaj tasaj nej Teat Jesús: ―Ique lamepiüng ―aj. ");
INSERT INTO huvNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Tenguial ámban üetiw, quiaj Teat Jesús taxaing a pan, tataag orar, ndoj tambaag, quiaj tüüch nejiw, tapiüng: ―Ixainguiün itean, cos aag ayaj xecuerpo ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Condom tayar noic vas, tataag orar, ndoj tamongoch manganeowüw, tapiüng: ―Inganeowan. ");
INSERT INTO huvNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Cos aag agüy xequiej, ajüiquich wüx aaga jayats poch leaw lamarang Teat Dios müüch icon; cos xequiej apmajünch tiüt mawün wüx asoet xeyay nipilan. ");
INSERT INTO huvNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Aton sasaj icon xique lango nanganeow miyow uva ningüy; alinoic nüt sananganeow jayats miyow uva nóiquian naquiiüb icon tiül micambaj Teat Dios ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Condom wüx landoj matajcüw cantar noic himno, quiaj tambüw andüyiw wüx mitiüc Olivos. ");
INSERT INTO huvNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Quiaj tasaj nejiw Teat Jesús: ―Meáwan icona apmecueatiün xic aaga ongwiiüts cam, atnej apiüng tiül Mipoch Teat Dios: “Sanambiy aaga nejiür sap, quiaj apndajrriüm meáwan misap nej.” ");
INSERT INTO huvNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Naleaing wüx sanapac tiül mondeow, quiaj sanamb tiül Galilea ombas xic, ndoj iliücan tamiün ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Quiaj tasaj nej a Pedro: ―Teat, masey meáwan macueatiw ic, xique ngome sanacueat ic ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Quiaj Teat Jesús tasaj nej: ―Naleaing sasaj ic Pedro, aaga ongwiiüts cam wüx nganaw mepaj a gallo, ique lamepiüng arojmbüw ipiüng ngo mejaw jane xic ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Quiaj a Pedro tapiüng: ―Teat, xique ngome sanapiüng ngo najaw jane ic masey nandeow nóiquian naquiiüb ic ―aw. Atanquiaj tapiüngüw meáwan minipilan nej. ");
INSERT INTO huvNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Condom Teat Jesús tapeay tiül niüng nasoic Getsemaní maquiiüb minipilan nej. Tasaj nejiw: ―Cheteron ningüy, cos xique sanamb ninguiün nataag orar ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Condom taquiiüb mamb a Pedro at alijpüw micual Zebedeo, ndoj tayaag xeyay amix omeaats. ");
INSERT INTO huvNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Tasaj nejiw: ―Xowüy amix ximeaats, sayaag atnej teasandeow. Nganüy icüliün xic ningüy, nde memeayiün ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Condom Teat Jesús tamb quiríwan iün majüy, quiaj mejquiet tiüt, tatün ocueaj Teat Dios, tapiüng: ―Xeteat Dios, sitiül ique indiüm, alndom mewün xic wüx meáwan naél leaw sanamongoch. Naleaing Teat, nde merang leaw xic sandiüm, irang atnej ique indiüm ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Condom tandilil majaw ajcüw arojpüw minipilan nej, tajaw lameayiw. Quiaj tasaj a Pedro: ―¿Neol, ngondom mepacana mequiüjpan xic masey noic ores? ");
INSERT INTO huvNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Nde memeayiün, itüniün ocueaj Teat Dios, nde matüch icon nimeech. Masey tiül imeajtsan indiüman meyamban Teat Dios, icona ngo meiücan wüx ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Condom tandüy quiaj amb ijmbüw mataag orar masaj Teat Dios, tapiüng: ―Xeteat Dios, sitiül naleaing netam namongoch aaga naél cam, ngondom mamóngan, irang atnej ique indiüm ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Tandilil alinomb niüng ajlüyiw ajcüw arojpüw quiaj. Taxom nejiw lameayiw alinomb, cos xeyay ind ameayiw, langondom maleaijquiw oniüjcüw. ");
INSERT INTO huvNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Condom tacueat nejiw, tandüy quiaj amb arojmbüw mataag orar, matün ocueaj Teat Dios, tatün atnej landoj matün. ");
INSERT INTO huvNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Condom tandüy niüng ajlüy minipilan nej, quiaj tasaj nejiw: ―¿Neol, aliün memeayiüna, tenguial ixojtana? Canüy landoj, lamatüch a ores. Apmayacüch a Teat Naxey teowixaw nipilan monrang ngo majneaj. ");
INSERT INTO huvNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Witiüron, tabaats, ijawan lapeay aaga apmayac xic teowixaw nipilan ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Tenguialeámban andeac Teat Jesús, quiaj ajngot a Judas, aaga naw tiül gajpiüp minipilan nej, aquiiüb miün xeyay nipilan, ajamiünüw machat, aton xiül. Üüch nejiw miünüw montangtang miteaats at montangtang monajiüt tiül nipilan judío. ");
INSERT INTO huvNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Aaga Judas lamasaj nejiw nguineay apmajüiquich ngün masapüw. Cos lamapiüng: ―Áag leaw sanacheech mimboy nej, aag ayaj isapan ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Condom wüx tajngot, quiaj tamb majaw Teat Jesús, tasaj: ―Ndic Teat, tamtámban ijlüy teat ―aj. Andüüb macheech mimboy nej. ");
INSERT INTO huvNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Quiaj tasaj nej Teat Jesús: ―Amigo, ¿cuane tewiün meranga? ―aj. Quiaj tajngotoj, tajmeliw masapüw nej, taquiüjpüw nej mamb. ");
INSERT INTO huvNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Naleaing nop tiül minipilan Teat Jesús tasoond mimachat nej, tandooig nop olaag nembeol minatang miteaats. ");
INSERT INTO huvNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Quiaj tasaj nej Teat Jesús: ―Isoc alinomb tiül ombiüm mimachat, teat, cos meáwan jane andiüm matsoj wüx machat, naag machat apmendeowüy. ");
INSERT INTO huvNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Neol, cuane ipiüng, ngondom natün ocueaj Xeteat Diosa, müüch miün peic miow mil (80,000) miángeles nej mambeolüw xique? ");
INSERT INTO huvNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Pero jondot narang atquiaj, ¿nguineay apmajlüy leaw lamapiüng tiül Mipoch Teat Dios netam majlüy? ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Condom quiaj Teat Jesús tasaj ajcüwa nipilan quiaj: ―¿Cuane imbichan machat, ata xiül wüx isapan xique? ¿Jow a xique, need xique? Meáwan nüt tajlüyiüs niüng ijlüyiün naquiaach icon tiül a nadam nangaj iüm, pero icona ngo mesapan xic. ");
INSERT INTO huvNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Naleaing atcüy netam majlüy, para majlüy atnej nomb tapiüngüw tiül nawiig mondeac andeac Teat Dios ―aj nejiw. Quiájan tacueatiw nej minipilan nej, tecuiürrüw. ");
INSERT INTO huvNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Wüx landoj masapüw Teat Jesús, quiaj taquiüjpüw nej mamb andüy niüng ajlüy Caifás, aaga minatang miteaats, niüng canchiüjow ajcüwa mondüy wüx aaga poch tüünd Moisés, aton ajcüwa montangtang monajiüt tiül nipilan judío. ");
INSERT INTO huvNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pedro tandüüb mamb miünquiájan ajngot, tatüch mbeay minden minatang miteaats. Condom tajmel chetet maquiüjpüw monjiür iüm, mambich majaw nguineay apmajlüy. ");
INSERT INTO huvNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ajcüwa montangtang miteaats, montangtang monajiüt, aton meáwan monajiüt tiül nipilan judío tayambüw jane matepich asoet Teat Jesús masey awaiich, para müjchiw mamb mandeow. ");
INSERT INTO huvNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Pero ngo maxomüw, masey ajlüy xeyay monwaiich wüx nej. Ndójwüx, tajngotoj ijpüw monwaiich. ");
INSERT INTO huvNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Nejiw tapiüngüw: ―Aaga naxey quiaj tapiüng: “Xique alndom najarrich aag nadam nangaj iüm ocueaj Teat Dios, ndoj wüx er nüt alndom nawitich alinomb”, aw ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Condom aaga minatang miteaats witiüt matün manguiay Teat Jesús, tasaj: ―¿Neol ngo merndeaca? ¿Cuane teamandeacüw wüx imbas quiaja? ―aj. ");
INSERT INTO huvNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Teat Jesús ndijchiówan, ngo masaj nej nicuajind. Quiaj a minatang miteaats tasaj nej: ―Por minüt Teat Dios leaw almapac, isaj xicon sitiül naleaing ique aaga Cristo lapiürang aliüc, aag Micual Teat Dios ―aj. ");
INSERT INTO huvNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Quiaj tasaj nej Teat Jesús: ―Ajaj xique teat, atnej lamepiüng quiaj; y sasaj icon alinoic nüt apmejawan a Teat Naxey alchetem amb wüx miác Teat Dios; aton apmejawan wüx aliüc imiün tiül cielo, amb tiül oic ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Quiaj aaga minatang miteaats tachiüt apix nej cos xeyay ajcüy, tapiüng: ―Aaga naxey cam lamandeac ngo majneaj, ayac atnej Dios nej. ¿Cuane tenguialeámban macüliiüts manguiayiiütsa? Icona lamenguiayiün nguineay tandeac xeyay ngo majneaj. ");
INSERT INTO huvNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Ngwüy, cuane ajiür meyajcana? ―aw. Quiaj tapiüngüw: ―¡Nej ajiür xeyay nisoet, ich mandeow! ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Quiaj tapots mateontsüw teombas nej onts ombeayiw nejiw, tatoliw, altiül taleambüw nej. ");
INSERT INTO huvNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Tasajüw nej: ―¡Sitiül ique aaga Cristo, isüet jane teamatol ic! ―ajüw. ");
INSERT INTO huvNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Teat Pedro aliün chetem quiaj tiül nden, quiaj ajngot nop nüx nerang najiüt quiaj, tasaj nej: ―Ique aton almequiiüb aaga Jesús naw Galilea ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Quiaj a Pedro tawaiich niüng ajlüyaran, tapiüng: ―Ngo najaw cuane ipiüng quiaj ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Pedro wüx laámb apmamong tiül ombeay nden, quiaj majaw nej alinop, aton tasaj monlüy quiaj: ―Aaga naxey quiaj taquiiüb aaga Jesús naw Nazaret ―aj. ");
INSERT INTO huvNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Quiaj a Pedro tandüy wüx alinomb mawaiich, tapaj minüt Dios, tapiüng: ―¡Deda nej dios, ngo najaw jane aaga naxey quiaj! ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ajóyan alquiriw ores, quiaj ajcüwa monlüy quiaj tatüchiw a Pedro, tasajüw: ―Naleaing ique aton nop nejiw, cos ajüiquich ic indeac ―ajüw. ");
INSERT INTO huvNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Quiaj a Pedro tapots mandeac ngo majneaj, tapaiich, tapiüng: ―Sitiül ngo maleaing sandeac, alinoic nüt sanangüy. ¡Naleaing ngo najaw jane aaga naxey temepiüngan quiaj! ―aw. Andǘüban tepaj a gallo. ");
INSERT INTO huvNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Quiaj a Pedro leaad omeaats leawa lamasaj nej Teat Jesús, cos tasaj nej: “Wüx nganaw mepaj a gallo, ique lamepiüng arojmbüw ipiüng ngo mejaw jane xic”, aj nej. Quiaj taw quiaj a Pedro, tajiünts xeyay. ");
INSERT INTO huvNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Wüx lachiüjmbaw, quiaj canchiütoj alinomb meáwan montangtang miteaats at montangtang monajiüt tiül nipilan judío. Tandeacüw nóiquian nguineay alndom mambiyaran Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Quiaj taquiüjpüw mamb a Teat Jesús neóel, tayacüw teowix Poncio Pilato, aaga natang nenajiüt. ");
INSERT INTO huvNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Condom a Judas, aaga neyac Teat Jesús teowixaw monajiüt, wüx tajaw Teat Jesús landoj apmandeow, quiaj leaad omeaats ngo majneaj lamarang. Tatsoriich alinomb aaga nimiow gajpowüw (30) tomiün plata, tüüch montangtang miteaats at monajiüt. ");
INSERT INTO huvNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Tasaj: ―Xique lanarang nadam nisoet, cos lanayac tiül iwixan nop naxey ngo majiür nicuajind nisoet ―aw. Quiaj tasajüw nej: ―Ic coen mejaw, jowa xicona cuane sambichan ic ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Condom quiaj a Judas tawiich quiaj a tomiün tiül nadam nangaj iüm, taw quiaj, tamb merrondüy onic. ");
INSERT INTO huvNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ajcüwa montangtang miteaats taxainguiw aaga tomiün quiaj, ndoj tapiüngüw: ―Aag agüy ngo majneaj macanchichaats tiül iquial nichech, cos aag agüy ombeat miquiej nop apmandeow ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ndoj andeacndeacüw wüx, tapiüngüw con aaga tomiün quiaj apmangalüw noic iüt niüng arangüch xor, niüng alndom mamiüraad napeay miün nipilan. ");
INSERT INTO huvNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Naw quiaj, aaga iüt quiaj tanüt miíüt quiej. Nganüy nüt cam aliün manüt atquiaj. ");
INSERT INTO huvNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Atquiaj tajlüy para majlüy atnej tapiüng nomb Teat Jeremías, nop nendeac andeac Teat Dios, cos nej tapiüng: “Apmayariw aaga nimiow gajpowüw (30) tomiün plata leaw nipilan judío lamayacüw ombeat nej, ");
INSERT INTO huvNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","mengalayej noic iüt niüng tarangüch xor, atnej tasaj xic Teat Dios”, aw. ");
INSERT INTO huvNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Teat Jesús wüx alteombas Pilato aaga natang nenajiüt, quiaj tatün nej manguiay: ―¿Naleaingue, ique aaga minatang nenajiüt ocueajiw nipilan israele? ―aj. Quiaj tasaj nej Teat Jesús: ―Naleaing, atnej ipiüng quiaj ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Masey tenguial mayacüw nej asoet ajcüwa montangtang miteaats at monajiüt, nej ngo mapiüng nicuajind. ");
INSERT INTO huvNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Condom quiaj tasaj nej a Pilato: ―¿Neol, ngo menguiay leaw tenguial mandeacüw wüx imbas quiaja? ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Nej Teat Jesús ngo mandeac nicuajind. Quiaj aaga natang nenajiüt quiaj mbayat majaw, lango majaw cuane apmarang. ");
INSERT INTO huvNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Wüx aaga nangos nüt quiaj, aaga natang nenajiüt alndom matsambiich nop najlüy tiül manchiüc leaw cambaj apmatün. ");
INSERT INTO huvNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Aaga nüt quiaj altiül manchiüc nop naxey xowüy anderac wüx nej, nenüt Barrabás. ");
INSERT INTO huvNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Wüx nipilan alcanchiümoj, quiaj tatün manguiay nejiw a Pilato: ―¿Ngün indiüman natsambiich, Barrabása, ngwüy Jesúsa, aaga nasoic Cristo? ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Tapiüng aag ayaj cos lamajaw ajcüyíwan majawüw Teat Jesús, áag tayacüw teowix nej. ");
INSERT INTO huvNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Wüx Pilato alchetem niüng ajaw wüx asoeteran, quiaj mintaj nej tüüch mamb masoic: “Nde aleaic merang wüx a naxey nerang najneaj quiaj, cos tepood xeyay mbayatos tiül sameay, taümiüs najaw wüx nej”, aw. ");
INSERT INTO huvNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Pero naleaing ajcüwa montangtang miteaats, at monajiüt tiül cambaj tapots mawüywüyiw nipilan matüniw tsajmbiüm aaga Barrabás, nganüy a Teat Jesús ich mandeow. ");
INSERT INTO huvNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Quiaj tatün manguiay nejiw alinomb aaga natang nenajiüt, tasaj nejiw: ―¿Ngün tiül ajcüwa ijpüw cam indiüman natsambiiche? ―aj nejiw. Quiaj tapiüngüw: ―¡Aaga Barrabás! ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Condom Pilato tasaj nejiw: ―¿Cuane ipiüngan, cuane sanarang wüx aaga Jesús nasoic Cristo? ―aj nejiw. Quiaj tapiüngüw nóiquian: ―¡Ich mandeow wüx cruz! ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Quiaj tasaj nejiw a Pilato: ―¿Mbich cuane nisoet ajiüre? ―aj nejiw. Nejiw tayacüw wüx apajüw, tapiüngüw: ―¡Ich mandeow wüx cruz! ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilato wüx tajaw ngondom marang nicuajind, cos nipilan tenguial ajcüyiw, quiaj tatün mamb mayarich yow. Ndoj tapots müüch majants owix nej niüng ajlüy meáwan nipilan. Tapiüng: ―Aag agüy sarang mejawan, xique ngo najlüy tiül wüx apmajünch tiüt miquiej aaga naxey nerang najneaj cam, ijawan coen ninguiaj icona ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Yajnguiat tiüt a nipilan apajüw, tapiüngüw: ―Xicona masey sanaquiüjpan wüx xecualan sanengüyiün miquiej nej leaw apmajünch tiüt ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Quiaj a Pilato tatsambiich a Barrabás, ndoj, wüx landoj ajwüch Teat Jesús, quiaj tayac teowixaw nipilan mandeow wüx cruz. ");
INSERT INTO huvNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Condom quiaj misoldados nej taquiüjpüw Teat Jesús andüy tiül noic püjchiün nasoic pretorio, canchiütoj meáwan soldado, ayeyiw nej tiüt. ");
INSERT INTO huvNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Quiaj tasojndiw nej tiül apix, condom tasoijquiw nej tiül noic najal napixeran morada. ");
INSERT INTO huvNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ndoj tayacüw wüx omal nej noic corona nepeat sats, aton tasocoj tiül miác owix nej nots najchow, aag ayaj nangoraad apiüngüw. Quiaj taquiejliw micosüw nejiw tiüt teombas nej mitsojow nej. Tapiüngüw: ―¡Najneajay ijlüy, mbich ique minatang nenajiüt ocueajiw nipilan judío! ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Tapots mateontsüw wüx ombas nej onts ombeayiw nejiw, aton tayariw aaga najchow mawüjchiw wüx omal nej. ");
INSERT INTO huvNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Wüx lapaxiow mitsojow nej, quiaj tasojndiw nej tiül aaga morada napixeran, ndoj tasoijquiw nej tiül apix nej. Condom quiaj taquiüjpüw nej mamb mayacüw nej wüx cruz. ");
INSERT INTO huvNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Almawüw quiaj, quiaj mangochiw nop naxey naw Cirene, nenüt Simón. Tasapüw nej mambitic micruz Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Quiaj tapeayiw tiül niüng nasoic Gólgota, aag ayaj amb apiüng omal mondeow. ");
INSERT INTO huvNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Quiaj tüjchiw vin manganeow aolüw tiül nangaag, wüx tapeay teombeay nej taton ngo manganeow. ");
INSERT INTO huvNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Wüx landoj mayacüw nej wüx cruz, quiaj tembaagayej wüx apix nej, asüetiw wüx majawüw jane apmajoy. Atquiaj tajlüy atnej tanomb tapiüng nop nendeac andeac Teat Dios wüx tapiüng: “Apmembaagayej wüx sapix, apmasüetiw wüx majawüw jane apmeneay”, aw. ");
INSERT INTO huvNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ndoj tsototójan quiaj majiürüw nej. ");
INSERT INTO huvNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ndoj tayacüw wüx omal cruz acas poch niüng apiüng cuane asoet nej, apiüng: “Aag agüy Jesús, minatang nenajiüt ocueajiw nipilan judío”, aw. ");
INSERT INTO huvNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Aton tajmeliw wüx cruz maquiiüb ijpüw moneed, nop amb wüx miác Teat Jesús, alinop amb wüx miquiamb nej. ");
INSERT INTO huvNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Leaw tamongoj ambüw quiaj titsojow nej, talanglangüw omalüw müjchiw majüiquichaw ajcüyiw. ");
INSERT INTO huvNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Tapiüngüw: ―¡Joow, ngwüy ique nepiüng apmejarrich aaga nadam nangaj iüm, ndoj wüx er nüt apmelomboch alinomb! ¡Nganüy erwüneay wüx iquiáyan quiaj; iriow tiüt wüx cruz sitiül ique Micual ic Teat Dios! ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Átan titsojow nej montangtang miteaats, mondüy wüx aaga poch tüünd Moisés, at ajcüwa fariseos, aton montangtang monajiüt tiül cambaj Israel. Tandeacüw nejeyéjan quiaj, tapiüngüw: ");
INSERT INTO huvNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―Nej mbich tawün wüx alinop, nganüy nej ngondom mewüneay wüx nejáyan quiaj. Sitiül naleaing nej natang nenajiüt tiül nipilan judío, ich maw tiüt imiün wüx cruz nganüy, mbich apmayariiüts andeac nej. ");
INSERT INTO huvNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Nej tayac omeaats wüx Teat Dios, ich mawün nej wüx a nganüy sitiül Teat Dios ajiür nej lasta. Cos nej tapiüng: “Micual xic Teat Dios”, aw, ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ajcüwa moneed leaw tajlüyiw wüx cruz maquiüjpüw titsojow nej aton. ");
INSERT INTO huvNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Condom wüx lalembej nüt, quiaj pojniüt wüx iüt tamong lanchejliow nüt. ");
INSERT INTO huvNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Wüx nchejliüt nüt quiaj Teat Jesús tepaj napac, tapiüng: ―Elí, Elí, ¿lama sabactani? Aag ayaj apiüng: Xeteat Dios, Xeteat Dios, ¿neol tecueat xic? ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Altiül leaw alquiaj tanguiayiw, tapiüngüw: ―Aaga naxey quiaj tenguial mapaj teat Elías ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Quiaj tamb nop acuiür mayar noic walang sap. Wüx landoj macachiich, masoc tiül vinagre, quiaj tayac wüx omal nots najchow. Condom tayac wüx ombeay Teat Jesús machey. ");
INSERT INTO huvNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Alacas tapiüngüw: ―Ich majlüy, cawül majawaats sitiül aliüc a Elías mawün nej wüx ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Condom Teat Jesús tandüy wüx alinomb mepaj napac, quiaj tandeow. ");
INSERT INTO huvNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Quiaj aaga nadam jael nepal teomeaats a nadam nangaj iüm nómban chiütaw pinawan, naw cawüx andüy tiüt. Nómban ajlang a iüt, at a nadamdam piedra tajpoet. ");
INSERT INTO huvNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","At xeyay oxiüt aton lejquiat; xeyay monyar andeac Teat Dios tapacüw tiül mondeow. ");
INSERT INTO huvNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Tawüw tiül oxiüt, wüx Teat Jesús landoj apac tiül mondeow, quiaj tajmeliw tiül nangaj cambaj Jerusalén. Tajarawüw, tajaw nejiw xeyay nipilan. ");
INSERT INTO huvNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Aaga minatang ocueajiw soldados, at leaw almaquiiüb nej majiürüw Teat Jesús, wüx tayajcüw ajlang ateam, at wüx tajawüw meáwan leawa tajlüy, quiaj mbayatoj xeyay, tapiüngüw: ―Naleaing aaga naxey quiaj Micual nej Teat Dios ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Aton aliw quiaj tigüy müm montaj, miünquiájan alembemoj tenguial majawüw. Ajcüw ayaj tandüjpiw miün a Teat Jesús imiünüw Galilea, tambeolüw nej. ");
INSERT INTO huvNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Tiül ajcüw ayaj altiül a María Magdalena, María mimüm Jacobo maquiiüb José, at mimümüw micual Zebedeo. ");
INSERT INTO huvNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Wüx langwiiüts tiül aaga nüt quiaj, tapeay quiaj nop naxey nejiür xeyay, nenüt José, naw tiül cambaj Arimatea. Nej aton tajlüy tiül minipilan Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Nej tamb majaw Pilato matün micuerpo Teat Jesús. Quiaj Pilato tapiüng müünd. ");
INSERT INTO huvNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Condom quiaj aaga José tamb maxaing micuerpo Teat Jesús, tawinch tiül noic najneaj püy nerixix. ");
INSERT INTO huvNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ndoj taquiiüb mamb mayac tiül noic jayats oxiüt leaw nej landoj marang tiül otüeng tiüc. Condom quiaj tapal wüx noic nadam piedra, cas tamb. ");
INSERT INTO huvNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Aliw quiaj a María Magdalena maquiiüb alinop María, alchetemoj quiaj mbeay oxiüt. ");
INSERT INTO huvNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Wüx lamatüch nüt axoodaran, aag ayaj amb alinoic nüt ndoj ayambyambüw meáwan leaw apmetam nejiw wüx pascua, quiaj montangtang miteaats at fariseos tambüw majawüw Pilato. ");
INSERT INTO huvNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Tapiüngüw: ―Teat Xan, nganüy les leaad ximeajtsan leaw tapiüng aaga naxey newaiich quiaj. Cos wüx aliün mapac tapiüng nej apmapac tiül mondeow wüx er nüt. ");
INSERT INTO huvNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Nganüy teat, sandiüman meaach mamb majiürüch aag oxiüt quiaj leaw among er nüt, ngana majmeliw ongwiiüts minipilan nej mawüniw nej, ndoj apmasajüw nipilan: “Nganüy lapac tiül mondeow”, mawüw. Quiaj apmawaijchaw xeyay nipilan más xeyay, ngo matnej wüx aliün mapac ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Quiaj tasaj nejiw Pilato: ―Joyaj noic ajlüy soldados, quiüran ipalan nandand nandand aaga oxiüt quiaj leaw niüng alndom ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Condom quiaj tambüw mapalüw nandand a oxiüt. Tayacüw noic sello wüx aaga piedra apal nej, ndoj tacueatiw quiaj soldados majiürüw. ");
INSERT INTO huvNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Wüx lamong aaga nüt axoodaran, larraw tiüt amb alinoic nüt, aag ayaj amelich seman; quiaj tambüw majawüw oxiüt a María Magdalena maquiiüb alinop María. ");
INSERT INTO huvNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Condom quiaj tajlang noic nadam ateam, cos nop ángel ocueaj Teat Dios tiün imiün cielo. Almapeay, quiaj tawün a piedra nepal oxiüt, chetet wüx. ");
INSERT INTO huvNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ombas nej xowüy larraw atnej noic najlip, at apix nej rajnüy atnej nieve. ");
INSERT INTO huvNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ajcüwa soldados almajawüw aag ayaj mbayajow, anmambeapmbeap nejiw, tajmiücüw nómban atnej landeowüw. ");
INSERT INTO huvNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Quiaj aaga ángel tasaj ajcüwa montaj: ―Nde mbayameron, cos sajaw icon iwiünan meyamban Teat Jesús, áag tayacüw wüx cruz. ");
INSERT INTO huvNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Lango majlüy ningüy cos nej lapac tiül mondeow atnej lamapiüng. Macaron ijawan niüng tapiiberan a Teat Naxey. ");
INSERT INTO huvNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Nganüy quiüran najenjénan, isajan minipilan nej: “Nej lapac tiül mondeow, laámb andüy Galilea ombas nej, quiaj apmexoman”, irajan. Áagan ayaj sajngot nasaj icon ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Condom ajcüwa montaj mbayatoj, tawüw quiaj tiül oxiüt najénan; ndoj xeyay tapac omeajtsüw. Tambüw acuiürrüw masajüw minipilan Teat Jesús meáwan leaw tasoiquiw. ");
INSERT INTO huvNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Aliünüw tiül tiiüd, quiaj tangoch nejiw Teat Jesús, tatepeay nejiw. Quiaj tambüw mangochiw, taquiejliw micosüw nejiw, tapequiequiw nej oleaj. ");
INSERT INTO huvNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Quiaj tasaj nejiw: ―Nde mbayameron. Quiüran isajan xecojow xechijquiaw mambüw andüyiw Galilea, quiaj sanexomayon ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ajcüwa montaj tealeámban aliünüw tiül tiiüd, quiaj tawüw niüng ajlüy oxiüt acas soldados. Tambüw tiül cambaj aton masajüw ajcüwa montangtang miteaats meáwan leaw tajlüy. ");
INSERT INTO huvNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Condom ajcüwa miteaats sonongotoj maquiüjpüw montangtang monajiüt tiül judíos. Wüx landoj mandeacüw nguineay apmarangüw, quiaj tüjchiw soldados xeyay tomiün. ");
INSERT INTO huvNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Tasajüw: ―Atcüy ipiüngan: “Aaga Jesús, tambüw mawüniw nej minipilan nej ongwiiüts wüx salnameayiün”, irawan. ");
INSERT INTO huvNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Sitiül ndot aaga natang nenajiüt apmanguiay, xicona sanawüniün icon wüx, quiaj ngome apmemongochiün nicuajind naél ―ajüw nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Condom ajcüwa soldados, wüx landoj mayariw a tomiün, quiaj tarangüw atnej tasoiquiw. Meáwan aag ayaj aliün manderac wüx tiül nipilan judío nganüy nüt cam. ");
INSERT INTO huvNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ajcüwa gajpanop (11) minipilan nej tambüw andüyiw Galilea wüx nop tiüc niüng lamasaj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Wüx tajawüw nej taquiejliw micosüw nejiw teombas nej; pero naleaing altiül tachiweaw omeajtsüw. ");
INSERT INTO huvNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Condom Teat Jesús tatüch nejiw, tapiüng: ―Lanüünd najlüy wüx meáwan leaw almajlüy ninguiün tiül cielo, at ningüy wüx iüt. ");
INSERT INTO huvNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Nganüy quiüran isajan palpálwüx nipilan wüx aaga iüt cam mandüjpiw xic aton. Ijchan mayariw yow wüx minüt Teat Dios, wüx minüt Micual nej, at wüx minüt Nangaj Espíritu ocueaj Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Iquiajchiün mayacüw wüx omeajtsüw marangüw meáwan leaw lanasaj icon; xique sanaquiiüb icona meáwan nüt, leaw ümb minüt a iüt cam ―aj nejiw. Amén.");
INSERT INTO huvNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Aaga najneaj nanderac wüx Teat Jesucristo, aag Micual Teat Dios, tiün majlüy atnej larangüch wüx nawiig tanomb. ");
INSERT INTO huvNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Tanomb atcüy tarang tiül minawiig nej a Isaías, nendeac andeac Teat Dios. Tarang wüx nawiig leawa Teat Dios tasaj nej, tapiüng: Sanüüch mamb nop naxey nerang xenajiüt mamong ombas, ique teoj apmeamb. Nej apmamb mataag majneaj a tiiüd niüng apmemong. ");
INSERT INTO huvNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Apmanguiayaran andeac nop naxey tiül wajchiüc niüng ngo majlüy cambaj. Nej apmapiüng: “Itajcan majneaj a tiiüd, ileainguijchan, cos aliüc Miteatiiüts”, apmaj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Condom atquiaj tajlüy, tiün a Juan, aaga neech yow nipilan. Tamb maquiaach nipilan niüng ngo majlüy cambaj, masaj leaam omeajtsüw wüx asoetiw nejiw, macueatiw. Atquiaj alndom maw asoetiw, y netam mayariw yow aton. ");
INSERT INTO huvNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Tambüw majawüw nej xeyay nipilan monaw tiül meáwan cambaj tiül Judea, at monaw Jerusalén aton. Wüx tapiüngüw lango mandiümüw marangüw aaga ngo majneaj teamarangüw quiaj, y apmacueatiw, quiaj Juan tüüch nejiw yow tiül lam Jordán. ");
INSERT INTO huvNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Aaga Juan quiaj asooig apix nej najüyaran miyeed camello, aton aóel teomeaats nej taag. Tatsamb mow, tanganeow micün xiül. ");
INSERT INTO huvNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Condom Juan taquiaach nejiw, tapiüng: ―Aliüc miün andǘüban xic apmajlüy nop teat naxey natang, xeyay netam ajlüy; nganüy xique nicuajind xic teombas nej. Sayaag xique ngondom natüch mejquien nacheed aonts apaj nej. ");
INSERT INTO huvNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Xique áagan yow süüch icon, nganüy a nej apmüüch icon Nangaj Espíritu ocueaj Teat Dios ―aj nejiw a Juan. ");
INSERT INTO huvNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Tíülan aaga acas nüt, quiaj tapeay Teat Jesús imiün tiül cambaj Nazaret tiül iüt Galilea. Quiaj tamb majaw a Juan. Condom Juan tüüch nej yow tiül lam Jordán. ");
INSERT INTO huvNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Wüx taw tiül yow, quiaj Teat Jesús tajaw leajquiat a cielo, tiün Nangaj Espíritu ocueaj Teat Dios atnej noic palom andüy wüx ombas nej. ");
INSERT INTO huvNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Condom tanguiayaran noic nanderac imiün tiül cielo, tapiüng: ―Naleaing ique xecual ic, sandiüm ic xeyay, apac ximeaats najaw ic ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Condom aaga Nangaj Espíritu ocueaj Teat Dios tüüch mamb Teat Jesús andüy tiül wajchiüc. ");
INSERT INTO huvNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Teat Jesús tacül quiaj ic miow (40) nüt niüng ajlüy cuajantanej napat nimal. Quiaj tandiüm mayac nej wüx naél minatang nimeech nenüt Satanás. Ndoj ángeles tajlüyiw quiaj mambeolüw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Condom alinoic nüt wüx monajiüt tayacüw tiül manchiüc a Juan, quiaj tamb Teat Jesús andüy tiül Galilea mandeac aaga najneaj nanderac wüx Teat Dios, mapiüng nguineay apmajlüy wüx Teat Dios apmajlüy wüx meáwan cambaj. ");
INSERT INTO huvNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Teat Jesús tapiüng: ―Lamatüch a nüt wüx Teat Dios apmajlüy wüx meáwan leaw almajlüy. Nganüy ijchan imeajtsan, iyariün aaga najneaj nanderac wüx Teat Dios ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Noic nüt wüx Teat Jesús tamong amb mbeay aaga nadam yow nenüt Galilea, quiaj tajaw Simón maquiiüb Andrés michiig nej. Nejiw teandocoj cos mondoc nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Quiaj tasaj nejiw Teat Jesús: ―Macaron tabaats, sanaquiaach icon nguineay alndom meyamban nipilan mesajan mayariw sandeac. Langome apmeyamban cüet mendocon, apmeyamban nipilan ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Acueatíwan mindocoj nejiw, tandüjpiw mamb Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Condom quiríwan iün majüyiw, quiaj tajawüw a Jacobo maquiiüb a Juan, micual nejiw Zebedeo. Nejiw aton aliw tiül mimüxiw nejiw, tenguial axequiw ndoc. ");
INSERT INTO huvNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","At aton tapaj nejiw miün Teat Jesús. Quiaj tacueatiw tiül müx miteatiw nejiw Zebedeo maquiiüb mimosüw nejiw. Tambüw maquiüjpüw mamb Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Condom tandüyiw tiül cambaj Capernaum. Quiaj Teat Jesús tajmel tiül a sinagoga maquiaach, cos aaga nüt quiaj nüt axoodaran. ");
INSERT INTO huvNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Mbayatoj manguiayiw aquiaach, cos taquiaach nejiw atnej nop natang nenajiüt nendüy, ngo matnej aquiajchiw ajcüwa mondüy wüx aaga poch tüünd Moisés. ");
INSERT INTO huvNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Alquiaj tiül sinagoga nop naxey alwüx ombas nej nimeech, üüch nej michach, tepaj napac. ");
INSERT INTO huvNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Tapiüng: ―Jow ique Jesús naw Nazaret, ¿cuane indiüm merang wüx ximbasana? ¿Tewiün mendrooch ximbasana? Xique sajaw jane ic, ique aaga Nangaj Micual Teat Dios ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Quiaj Teat Jesús talic nej, tasaj: ―¡Tapots ipaj, iriow wüx ombas a naxey quiaj! ―aj. ");
INSERT INTO huvNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Condom aaga nimeech tepaj, tambeapmbeap a naxey quiaj, ndoj quiaj tacueat nej. ");
INSERT INTO huvNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Xeyay mbayatoj nipilan majawüw, tetünayej menguiayayej nejeyéjan quiaj, tapiüngüw: ―¿Cuane aag ayaja? ¿Cuane aaga jayats aquiaach quiaja? ¿Nguineay alndom malic aaga nimeech quiaj maw? ¡Quiaj aaga nimeech tayar andeac nej, taw! ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Meáwan nipilan monaw tiül palpálwüx cambaj tiül iüt Galilea tandeacndeacüw wüx leaw tarang Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Condom Teat Jesús taw tiül a sinagoga, tambüw andüyiw aniüngüw Simón maquiiüb Andrés, at a Jacobo maquiiüb a Juan tambüw maquiüjpüw. ");
INSERT INTO huvNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Aaga müm najtaj miocuats Simón niün andeow, alwüx mats, xeyay üüch nej nerraar. Quiaj tasajüw Teat Jesús wüx aaga niün andeow quiaj. ");
INSERT INTO huvNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Teat Jesús tamb matüch niüng ajlüy a niün andeow quiaj, tasap owix mawitich; among wüx iün andeow. Condom aaga najtaj quiaj tarang nejiw üetiw. ");
INSERT INTO huvNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Wüx langwiiüts, lajmel nüt, quiaj taquiüjpüw niüng ajlüy Teat Jesús xeyay moniün andeow, at nipilan alwüx ombasüw nimeech. ");
INSERT INTO huvNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Condom meáwan nipilan monaw tiül aaga cambaj quiaj, sonongotoj teombeay iüm niüng ajlüy Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Nej tamongoch iün andeow xeyay nipilan leaw axom nejiw cuajantanej monandeow. At aton tataag majneaj xeyay nipilan alwüx ombasüw nimeech. Teat Jesús ngome tüüch mendeacüw nimeech wüx nej, cos lamajawüw jane nej. ");
INSERT INTO huvNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Amb alinoic nüt Teat Jesús witiüt aliün pojniüm. Tamb néjan quiaj andüy tiül wajchiüc mataag orar. ");
INSERT INTO huvNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Condom Teat Simón y leaw almaquiüjpüw tambüw mayambüw nej. ");
INSERT INTO huvNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Wüx taxomüw, tasajüw: ―Teat, meáwan nipilan teamayambüw ic ―ajüw. ");
INSERT INTO huvNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Quiaj tasaj nejiw Teat Jesús: ―Masey, nganüy tabaats tiül meáwan cambaj najlüy ninguiájan naquiaach quiaj aton, cos áag tiünas narang ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Quiaj tambüw tiül meáwan cambaj tiül iüt Galilea. Teat Jesús tapots aquiaach tiül palpálwüx sinagogas; aton tataag majneaj xeyay nipilan leaw alwüx ombasüw nimeech. ");
INSERT INTO huvNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Condom quiaj tamb majaw nej nop naxey axom nej napat monandeow nasoic lepra, ngo majiür misüüig, atextexíichan ombas nej. Quiaj taquieel micos nej, tasaj Teat Jesús: ―Teat, sitiül ique indiüm sajaw alndom memongoch iün sandeow ―aj. ");
INSERT INTO huvNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Teat Jesús quiaj tajmiüc omal omeaats, taxaing owix marreeg nej, tasaj: ―Neol ngo nandiüm xecual, sandiüm, sanamongoch iün indeow ―aj. ");
INSERT INTO huvNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Wǘxan ndoj mapiüng aag ayaj Teat Jesús, aaga niün andeow quiaj andǘüban ndet minecoy nej, tajneaj nómban. ");
INSERT INTO huvNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Condom Teat Jesús tasaj nej acas poch cuane netam marang, ndoj tasaj majtsor. Tapiüng: ");
INSERT INTO huvNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","―Nde mesaj nejinguind nguineay tejneaj. Nganüy quiür, iich majaw miteaats ique lerjneaj; irang atnej apiüng tiül aaga poch tüünd Moisés. Iyac ichech para majawüw meáwan nipilan ique lerjneaj ―aj nej Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Áwan quiaj a naxey tapots mandeac masaj meáwan nipilan nguineay tajneaj iün andeow. Ndoj quiaj Teat Jesús ngondom majmel tiül ngünantanej cambaj, cos xeyay nipilan teamacüliw nej. At masey nej tacǘlan tiül wajchiüc, xeyay nipilan tambüw majawüw nej quiaj. ");
INSERT INTO huvNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Camüm aw alacas nüt tandilil alinomb Teat Jesús andüy tiül cambaj Capernaum; tanguiayaran al aniüng nej. ");
INSERT INTO huvNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Najénan canchiütoj quiaj xeyay nipilan, lango majoy a iüm; at teombeay iüm lapatsayej quiaj. Teat Jesús tenguial maquiaach nejiw wüx Mipoch Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Condom tapeayiw quiaj apiquiw monxey aquiüjpüw mamb nop naxey ndron ombas, ambitiquiaw nej tiüt amb wüx mats. ");
INSERT INTO huvNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Pero naleaing ngondom matüchiw Teat Jesús cos laxowüy nipilan. Quiaj tajtepiw cawüx machaijquiw omal iüm alareng niüng ajlüy Teat Jesús, amb tiül tamongochiw mimats nej aaga ndron ombas quiaj. ");
INSERT INTO huvNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Wüx Teat Jesús tajaw nejiw naleaing ayariw leawa nej aquiaach, quiaj tasaj aaga ndron ombas: ―Xecual, landoj laáw isoet ―aj. ");
INSERT INTO huvNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Altsotomoj quiaj acas mondüy wüx aaga poch tüünd Moisés tanomb, tapiüngüw tíülan omeajtsüw nejiw: ");
INSERT INTO huvNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Neol tandeac atquiaj aaga naxey quiaja, neol tawaiiche? Cos tandeac atnej Dios nej. ¿Jane alndom mawün nisoete? Néjan quiaj Teat Dios”, awüw. ");
INSERT INTO huvNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Teat Jesús tajaw nguineay tenguial mateotsüw tiül omeajtsüw nejiw, quiaj tasaj nejiw: ―¿Neol teteotsan atquiaj tiül imeajtsana? ");
INSERT INTO huvNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Cuane iyajcan ngo maél nasaj aaga naxey cama: “Landoj laáw isoete”, ngwüy nasaja: “Witiür, ixaing mimats, ijüy”, naja? ");
INSERT INTO huvNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Nganüy apmejawan aaga Teat Naxey alndom mawün nisoet ningüy wüx iüt. Ijawan ―aj nejiw. Quiaj tasaj aaga ndron ombas: ");
INSERT INTO huvNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","―Ique sasaj ic teat, witiür ixaing mimats, quiür ijtsor ―aj. ");
INSERT INTO huvNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Condom aaga ndron ombas quiaj witiüt, taxaing mimats nej, najénan tamb, teamajawüw nej meáwan nipilan. Mbayajow majawüw, tapiüngüw: ―Teat Dios nerang aag ayaj, nómban ngomeaag majawaats ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Teat Jesús tamb alinomb andüy mbeay nadam yow nenüt Galilea. Xeyay nipilan tambüw majawüw nej, quiaj tapots maquiaach nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Wüx taw quiaj, al mamong niüng angüyaran tomiün ocueaj cambaj, quiaj tajaw a Leví micual Alfeo alchetem quiaj. Tasaj: ―Mac indüüb xic, tabar ―aj. Quiaj witiüt, tamb mandüüb nej mamb. ");
INSERT INTO huvNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Noic nüt Teat Jesús alaniüng Leví maquiiüb minipilan nej, teaüetiw maquiüjpüw xeyay monsap tomiün ocueaj cambaj. Aliw quiaj xeyay monrang ngo majneaj aton, cos xeyay nipilan almandüjpiw nej. ");
INSERT INTO huvNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Condom ajcüwa mondüy wüx aaga poch tüünd Moisés, at ajcüwa fariseos, wüx tajawüw nej teaǘet maquiüjpüw a nipilan quiaj, quiaj tasajüw minipilan nej: ―¿Cuane ayaj, neol a Jesús teaǘet aweaag, teanganeow aweaag monsap tomiün, at nipilan monrang ngo majneaj quiaja? ―ajüw nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Wüx Teat Jesús tanguiay aag ayaj, tasaj nejiw: ―Jane ayaag napacüy ngo metam nop nejaw nej; pero jane ayaag niün andeow mbich netam nej. Xique ngo niün nayamb nipilan leawa ayaag najneaj arang; xique tiünas nayamb leaw ayaag ngo majneaj arang, aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Noic nüt wüx minipilan Juan maquiiüb minipilan fariseos tenguial aiündüw, tapeayiw quiaj acas nipilan matüniw manguiayiw Teat Jesús, tasajüw: ―¿Neol taiündüw minipilan Juan maquiiüb minipilan fariseos? Jow nganüy minipilan, ¿neol ngo maiündüw? ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Quiaj Teat Jesús tasaj nejiw, tandeac atnej nej nop nengoch owix. Tapiüng: ―¿Alndom miamigos nop nengoch owix maiündüw wüx nej alquiaj maquiüjpüw? Sitiül almaquiüjpüw a nench, ngondom maiündüw. ");
INSERT INTO huvNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Alinoic nüt wüx lango majlüy a nench, quiaj mbich apmaiündüw ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Aton tasaj nejiw: ―Nejinguind ngondom macancham tiül noic nguirich napixeran quiripite jayats jael, cos sitiül apmacanchamaran tiül, wüx aptsontsocom, quiaj apmachiüt a nguirich jael. ");
INSERT INTO huvNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","At aton nejinguind ngondom mayac jayats vin tiül nguirich taag iquial vin, cos apmajpoet a nguirich iquial vin quiaj, quiaj apndrom ombas a vin, at a taag aton. Aaga jayats vin netam majmel tiül jayats taag ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Condom wüx noic nüt axoodaran ocueaj judíos, quiaj Teat Jesús tamong tiül noic corrül aquiiüb minipilan nej. Minipilan nej tajeliw müetiw aong trigo leaw napiürüch quiaj. ");
INSERT INTO huvNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Quiaj ajcüwa fariseos tasajüw Teat Jesús: ―¡Ijaw! ¿Neol arangüw minipilan atquiaj wüx nüt axoodaran leaw ngondom marangüche? ―ajüw. ");
INSERT INTO huvNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Teat Jesús, quiaj tasaj nejiw: ―¿Neol ngo meteowan nguineay tarang mixejchiiüts David wüx nej tind üet, at leaw almaquiüjpüw nej aton? ");
INSERT INTO huvNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Cos wüx Abiatar tarang natang miteaats, quiaj David tajmel tiül a nangaj iüm ocueaj Teat Dios, tüet pan leaw najmel marang nichech para Teat Dios. Aag ayaj nejinguind ngondom müet, áagan miteaats alndom müetiw. Pero nej tüet, átan leaw almaquiüjpüw nej tüetiw aton ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","At tasaj nejiw: ―Aaga nüt axoodaran quiaj tarangüch mambeol nipilan müüch nejiw maxojtüw noic nüt; ngome nipilan tarangüch mandüjpiw opech aaga nüt quiaj. ");
INSERT INTO huvNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Nganüy inguiayiün, aaga Teat Naxey al wüx atam xeyay, ngo matnej aaga nüt axoodaran quiaj ―aw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Teat Jesús tajmel alinomb tiül a sinagoga. Al quiaj nop naxey ndron ombas, nechey owix. ");
INSERT INTO huvNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ajcüwa fariseos teamacüliw majawüw cuane apmarang Teat Jesús, sitiül nej apmataag majneaj owix a naxey quiaj wüx nüt axoodaran, para mayacüw asoet. ");
INSERT INTO huvNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ndoj Teat Jesús tasaj a naxey nechey owix quiaj: ―Witiür, lember ningüy pinawan ―aj. ");
INSERT INTO huvNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Condom tatün manguiay nejiw: ―¿Cuane ipiüngan, alndom marangüch najneaj wüx nüt axoodaran, ngwüy ngo majneaja? ¿Alndom mawünaran wüx nop, ngwüy apmambiyarana? ―aj nejiw. Nejiw ngo mendeacüw. ");
INSERT INTO huvNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Quiaj tajcüy Teat Jesús, tajaw nejiw, tamix omeaats cos arangüw adam omeajtsüw. Ndoj tasaj a naxey quiaj: ―Ileainguiich iwix ―aj. Quiaj aaga naxey taleainguiich owix nej, nómban ajneaj. ");
INSERT INTO huvNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Condom quiaj tawüw ajcüwa fariseos najénan mayambüw minipilan Herodes, matüniw manguiayiw nguineay alndom mambiyaw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Teat Jesús taw quiaj maquiiüb minipilan nej, andüyiw mbeay aaga nadam yow. Átan tandüjpiw nej xeyay nipilan monaw Galilea, at monaw Judea. ");
INSERT INTO huvNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Aton tambüw majawüw nej xeyay nipilan monaw Jerusalén, monaw Idumea, monaw necamb lam Jordán, at monaw tiül ajcüwa cambaj ayey tiüt Tiro y Sidón. Tapeayiw quiaj xeyay nipilan cos tanguiayiw wüx meáwan najneaj leaw arang. ");
INSERT INTO huvNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Quiaj Teat Jesús tasaj minipilan nej mayambüw nop müx mayacüw quiaj mbeay yow, para alndom majtep tiül sitiül apmacharrüw nej. ");
INSERT INTO huvNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Cos lamamongoch iün andeow xeyay nipilan, áag meáwan moniün andeow tiünüw acharrayej wüx ombas nej, marrejquiw. ");
INSERT INTO huvNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Wüx tajawüw nej ajcüwa nipilan leaw alwüx ombasüw nimeech, quiaj taquiejliw micosüw nejiw teombas nej, tepajüw, tapiüngüw: ―¡Ique Micual Teat Dios ic! ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Teat Jesús talic nejiw xeyay cos nganaw mandiüm majaraw jane nej. ");
INSERT INTO huvNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Condom Teat Jesús tamb andüy wüx nop tiüc, tandüjpiw nej mamb xeyay nipilan. Quiaj tasaj nejiw leaw lamandiüm marriiüd mambüw majawüw nej nejíwan quiaj. ");
INSERT INTO huvNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Tarriiüd gajpiüp (12) monxey maquiüjpüw nej, müüch nejiw mambüw masajüw nipilan nguineay alndom maw asoetiw nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Tüüch ndoj ombasüw mamongochiw iün andeow nipilan, at matajcüw majneaj leaw alwüx ombasüw nimeech. ");
INSERT INTO huvNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ajcüwa gajpiüp monxey quiaj tajlüyiw: nop Simón aaga tüünd manüt Pedro. ");
INSERT INTO huvNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Átan a Jacobo maqiiüb michiig nej Juan, micual nejiw Zebedeo, leaw Teat Jesús tüüch nejiw manütiw Boanerges; aaga poch quiaj amb apiüng: micual atearriür monteoc. ");
INSERT INTO huvNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Aton tajlüyiw tiül aaga gajpiüp: Andrés, Felipe, Bartolomé, Mateo, Tomás, Jacobo micual Alfeo, Tadeo, at Simón naw tiül noic ajlüy nipilan nasoiquiw Cananista. ");
INSERT INTO huvNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","At aton talüy tiül a Judas Iscariote, aaga ndoj tayac teowixaw monajiüt Teat Jesús. Ndoj tajmeliw tiül nop iüm. ");
INSERT INTO huvNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Quiaj canchiütoj alinomb niüng ajlüyiw nejiw xeyay nipilan, ngo müjchiw nejiw metiw. ");
INSERT INTO huvNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Wüx tanguiayiw acualaats nej Teat Jesús nguineay teamarang, quiaj tambüw majanüw nej, cos lapiürang nej lamichach. ");
INSERT INTO huvNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","At aton wüx tapeayiw quiaj mondüy wüx aaga poch tüünd Moisés, imiünüw Jerusalén, tapiüngüw: ―Aaga Jesús quiaj, alwüx ombas nej minatang nimeech nenüt Beelzebú; aaga nimeech quiaj ambeol nej mataag majneaj leaw alwüx ombas nej nimeech ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Quiaj tapaj nejiw Teat Jesús, tasaj nejiw acas poch, pero ngome aleáingan. Tapiüng: ―¿Nguineay alndom a Satanás mawün nejay a Satanás wüx ombas nipilana? ");
INSERT INTO huvNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Jondot monajiüt tiül noic cambaj majcüyiw nejeyéjan quiaj mbajcamoj, aaga cambaj quiaj ngondom majlüy najneaj, apndrom ombas. ");
INSERT INTO huvNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","At aton sitiül nacualaran tiül noic nden majcüyiw nejeyéjan quiaj, apndajrriümoj. ");
INSERT INTO huvNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Pero sitiül Satanás ajcüy majaw aquiiüb nej, ngo majlüyiw nóiquian, quiaj langondom marangüw nicuajind. ");
INSERT INTO huvNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Nejinguind ngondom maneed aniüng nop napac naxey sitiül ngome ombas maóel owix, cas tajmel maneed leaw andiüm. ");
INSERT INTO huvNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Naleaing sasaj icon, meáwan nisoet leaw arangüw nipilan, Teat Dios alndom mawün wüx omeaats. At cuajantanej ngo majneaj poch andeacüw alndom mawün wüx omeaats aton. ");
INSERT INTO huvNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Pero jangantanej leaw apmandeac ngo majneaj wüx Nangaj Espíritu ocueaj Teat Dios, aag ayaj mbich ngondom mawün wüx omeaats nej Teat Dios. Cos aaga nisoet quiaj nómban ngondom maw ―aw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Atquiaj tasaj nejiw Teat Jesús cos nejiw tapiüngüw alwüx ombas nej nimeech. ");
INSERT INTO huvNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Condom tapeayiw quiaj mimüm Teat Jesús maquiiüb michiig nej majawüw nej, pero ngome tajmeliw. Quiaj tapiüngüw mamb majpaj. ");
INSERT INTO huvNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ajcüwa nipilan alchetemoj quiaj ayeyiw nej tiüt, tasajüw nej: ―Joyaj mimüm aquiiüb michiig teamayambüw ic ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Quiaj tasaj nejiw Teat Jesús: ―¿Jane ipiüngan xemüm, jane ipiüngan xechiig? ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Quiaj taxaing omal majaw leaw alchetemoj quiaj niüng ajlüy nej, tapiüng: ―Icona ijlüyiün atnej xemüm, xechiig. ");
INSERT INTO huvNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Cos jangantanej sitiül arang leaw andiüm Teat Dios, aag ayaj sayaag ajlüy atnej xemüm, xechiig aton ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Noic nüt Teat Jesús tamelich aquiaach nipilan mbeay nadam yow Galilea. Cos canchiütoj niüng ajlüy nej xeyay nipilan; áag Teat Jesús tajmel tiül yow, tajtep tiül nop müx chetem. Meáwan nipilan tacüliw wüx iüt mbeay yow. ");
INSERT INTO huvNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ndoj quiaj tasaj nejiw acas poch ngome aleáingan, tandeac andüy wüx cuajantanej maquiaach nejiw. Tapiüng: ");
INSERT INTO huvNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―Inguiayiün leawa sanandeac: Tajlüy nop naxey tamb apiür. ");
INSERT INTO huvNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Wüx teamawiich osaab soex, quiaj tajmiüc tigüy mbeay tiiüd. Condom tajngotoj a quiec, tüetiw. ");
INSERT INTO huvNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Altigüy tajmiüc tiül piedra niüng ngo majlüy xeyay iüt. Tajntsop najen cos ngo majlüy xeyay iüt. ");
INSERT INTO huvNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Wüx tajntsop nüt terraar, quiaj tambel nej. Cos ngo majiür mioxiich nej, quiaj tawaag a nine soex quiaj. ");
INSERT INTO huvNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Altigüy tajmiüc tiül sats. Wüx tajntsop, cos sats najen atangüw, quiaj taxotüw tiüt a nine soex quiaj. Atquiaj taton ngondom meongoj. ");
INSERT INTO huvNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Altigüy tajmiüc tiül najneaj iüt, tatang najneaj, tayac aóng. Tigüy taóng napateay, altigüy tayac wüx quiriw, altigüy tayac wüx xeyay aóng ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Andǘüban Teat Jesús tasaj nejiw: ―Netam menguiayiün, mexoman imeajtsan wüx leaw sandeac quiaj ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Wüx lango majlüyiw quiaj xeyay nipilan, quiaj leawa tajlüyiw niüng ajlüy Teat Jesús maquiüjpüw ajcüwa gajpiüp (12) minipilan nej, tatüniw manguiayiw nej cuane wüx amb apiüng aaga andeac quiaj. ");
INSERT INTO huvNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Quiaj Teat Jesús tasaj nejiw: ―Icona tenguial meajndiün mejawan leawa nomb ngo majüiquicharan, nguineay alndom majmelaran tiül minipilan Teat Dios. Pero pálwüx nipilan ngome apmasoiquiw aleáingan. ");
INSERT INTO huvNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Atquiaj sarang para majawǘwan, manguiayíwan, pero naleaing ngome apmajawüw cuane wüx amb apiüng. Cos sitiül apmajawüw, alndom mayariw, maw asoetiw nejiw ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Condom Teat Jesús tatün manguiay nejiw: ―¿Ngo mejawana cuane wüx amb apiüng leawa sandeac quiaja? ¿Nguineay apmejawan meáwan leawa sanandeaca? ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Quiaj tapiüng: ―Aaga nepiür quiaj apiüng wüx nop nendeac Mipoch Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ajcüwa osaab soex najmiücüw mbeay tiiüd, aag ayaj nipilan leaw asoiquiw wüx Mipoch Teat Dios. Ndoj manguiayiw, andǘüban ajngot nimeech mawün wüx omeajtsüw nejiw aaga Mipoch Teat Dios leawa tanguiayiw. ");
INSERT INTO huvNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Aton ajlüy nipilan atnej aaga osaab soex leawa tajmiüc tiül piedra. Cos wǘxan asoiquiw wüx Mipoch Teat Dios, apac omeajtsüw ayariw. ");
INSERT INTO huvNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Naleaing nejiw, cos ajlüyiw atnej aaga soex najntsop tiül piedra, ngo majiür mioxiich nej; áag ngo maíüc. Cos wüx apmajlüy naél, majcüy majaw nejiw nipilan ajcan andüjpiw Mipoch Teat Dios, quiaj machiweaw omeajtsüw. ");
INSERT INTO huvNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","At aton almajlüy nipilan atnej aaga osaab soex napiürüch tiül sats. Aaga nipilan quiaj anguiayiw Mipoch Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Pero xeyay amb wüx omeajtsüw leaw alndom maxomüw wüx aaga iüt cam. Cos andiümüw majiürüw xeyay tomiün, andiümdiümǘwan cuajantanej. Meáwan aag ayaj üüch nejiw ndrom omeajtsüw Mipoch Teat Dios; ngo müüch nejiw marangüw leawa Teat Dios apiüng. ");
INSERT INTO huvNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Aton altiül nipilan leaw anguiayiw Mipoch Teat Dios, ayariw mipoch nej, ayacüw wüx omeajtsüw. Nejiw ajlüyiw atnej aaga osaab soex napiürüch tiül najneaj iüt cos teongoj. Tegüy taóng napateay, altegüy tayac wüx quiriw, altegüy tayac wüx xeyay aóng ―aw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Condom tandeac alinoic tasaj nejiw: ―Sitiül aljane andiüm marraj tiül iüm jondot apmapal omal noic candil tiül nop xor, tengwüy apmayac tiüt teoleaj mats, ¿nguineay aprram tiül iüma? Cos netam mayacüch cawüx, quiaj apmarraj najneaj tiül iüm. ");
INSERT INTO huvNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Atquiaj sasaj icon, cos meáwan leaw ngo majaraw nganüy, naleaing alinoic nüt apmajaraw nguineay. Ngo majlüy noic nanderac mexotüy nganüy leaw ngome apmajüic alinoic nüt ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Condom tapiüng: ―Meáwan icona lamenguiayiün aaga poch cam, nganüy iyacan wüx imeajtsan ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Aton tasaj nejiw: ―Iyacan wüx imeajtsan xepoch leawa temenguiayiün, iyariün. Cos sitiül apmeyacan wüx imeajtsan leawa lamenguiayiün, teamteáman apmeajndiün mejawan alquiriw. ");
INSERT INTO huvNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Cos sitiül aljane apmayar xepoch, nej apmüünd manguiay altegüy. Pero sitiül ngo mayar xepoch, masey lamanguiay quiripite apndrom omeaats ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Condom Teat Jesús tapiüng: ―Sanasaj icon nguineay arang wüx micambaj nej Teat Dios. Cos ajlüy atnej arang osaab soex lapiürüch. ");
INSERT INTO huvNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Quiaj aaga nepiür apmaxood mameay, ndoj apmapac. Atquiaj apmamong acas nüt acas ongwiiüts. Aaga osaab soex napiürüch quiaj apmajntsop, masey aaga nepiür quiaj ngondom majaw nguineay teajntsop, nguineay teatang. ");
INSERT INTO huvNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Cos aaga iüt teamatangüch aaga soex quiaj. Apmawün mbas onic nej, ndoj apmaól, ndoj quiaj apmatang osaab nej. ");
INSERT INTO huvNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Condom wüx latang, quiaj apmandojquich cos lamatüch a nüt xaijnguiam matajtüch ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Aton tasaj nejiw Teat Jesús: ―¿Nguineay alndom nasaj icon cuane atnej ajlüy micambaj Teat Dios, ngwüy cuane wüx alndom nandeac mejawan? ");
INSERT INTO huvNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ajlüy atnej noic nine osaab soex nenüt mostaza. Aag ayaj noic osaab soex leawa napiürüch xowüy minine. ");
INSERT INTO huvNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ndoj apiürüch, apmajntsop, apmarang noic najal oleaj soex, alwüx ajal oleaj tiül meáwan soex. Apmayac nadam mipüüig nej niüng quiec alndom marangüw ombiümüw nejiw maxojtüw ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Atquiaj taquiaach nejiw Teat Jesús wüx Mipoch Teat Dios, ngome aleáingan, leaw tayaag alndom manguiayiw. ");
INSERT INTO huvNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ngo maquiaach nicuajind aleáingan manguiayiw nipilan. Wüx laawüw quiaj nipilan, quiaj tasaj minipilan nej cuane wüx tandeac. ");
INSERT INTO huvNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Aaga nüt quiaj wüx langwiiüts, quiaj tasaj minipilan nej: ―Tabaats andüyiiüts necamb aaga nadam yow cam ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Tacueatíwan quiaj meáwan nipilan. Quiaj tambüw nejíwan quiaj maquiüjpüw Teat Jesús amb tiül aaga müx alchetem tiül. Aton tambüw alacas müx maquiüjpüw nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Wüx aleambüw tiül najal, quiaj taw noic napac iünd, tayac nadamdam omal yow anmachaachaach tiül müx, tenguial chipiow a müx. ");
INSERT INTO huvNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Teat Jesús al wil müx almameay, ayac aliig omal. Quiaj tapacüjchiw tiül ameay, tasajüw: ―¡Teat! ¿Neol ngo mejaw, laliüc tsoyomoots tiüt? ¡Apmandeowaats! ―ajüw. ");
INSERT INTO huvNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Quiaj witiüt Teat Jesús, tasaj a iünd lombom, at a yow majlǘyan. Quiaj lombot a iünd, at a yow tajlǘyan. ");
INSERT INTO huvNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Condom tasaj nejiw: ―¿Neol termbolana, neol ngome teyacan imeajtsan wüx leawa xique alndom naranga? ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Mbayatoj xeyay, tesajayej nejeyéjan quiaj, tapiüngüw: ―¿Cuaane nej aaga naxey cama? ¿Nguineay alndom mayar nej andeac a iünd at a yow? ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Condom Teat Jesús maquiiüb minipilan nej tapeayiw necamb aaga nadam yow quiaj, tiül miiütüw monaw Gadara. ");
INSERT INTO huvNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Almawüw tiüt imiünüw tiül müx, quiaj tapeay niüng ajlüy Teat Jesús nop naxey imiün tiül niüng amiüraad mondeow, alwüx ombas nej nimeech, üüch nej mechach ");
INSERT INTO huvNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Aaga naxey quiaj acül tiül niüng amiüraad mondeow. Nejinguind ngondom maóel nej, masey naag galen. ");
INSERT INTO huvNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Cos mbójan maoeliw owix nej oleaj nej naag galen. Nej ngo mapiüng wüx, andooigndooig miün, nómban acolot. Nejinguind ngondom masap nej. ");
INSERT INTO huvNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Aaga naxey quiaj, nüt ongwiiüts apaj tiül tiüc, at niüng amiüraad mondeow. Aton achiüt ombas nej naag piedra. ");
INSERT INTO huvNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Alíücan miünquiaj tajaw Teat Jesús, tecuiür tamb mangoch, taquieel micos nej tiüt teombas Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Quiaj tendeac napac, tapiüng: ―¿Cuane indiüm merang wüx ximbas Teat Jesús? Ique Micual Teat Dios najlüy tiül cielo. Satün icueaj wüx minüt Teat Dios, nde merang wüx ximbas nicuajind ngo majneaj ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Atquiaj tapiüng cos Teat Jesús lamasaj nej: ―¡Ique nimeech, sasaj ic, iriow wüx ombas a naxey cam, icueat! ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ndoj Teat Jesús tatün manguiay: ―¿Cuane minüt? ―aj. Quiaj tapiüng: ―Legión xenüt cos sajlüyiün xeyay ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Quiaj tatün xeyay ocueaj Teat Jesús nde mawün nejiw tiül aaga iüt quiaj. ");
INSERT INTO huvNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Tajlüy quiaj wüx nop tiüc noic ajlüy xeyay sow, teaüetiw. ");
INSERT INTO huvNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ajcüwa nimeech tatüniw ocueaj Teat Jesús, tapiüngüw: ―Iich xicon namban najmeliün tiül ajcüwa sow quiün ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Quiaj Teat Jesús tasaj nejiw mambüw. Tacueatiw a naxey quiaj, tajmeliw tiül sow. Ajcüwa sow ajlüyiw xeyay, atüch ijquiaw mil, tecuiürrüw ambüw wüx tiüc tajchiquiaw tiüt tajmiücüw tiül aaga nadam yow quiaj, tsoyotoj tiüt, tandeowüw tiül yow. ");
INSERT INTO huvNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Condom ajcüwa monjiür sow quiaj, tambüw acuiürrüw masajüw nipilan tiül cambaj, tiül rünch aton. Quiaj tambüw nipilan majawüw cuane najlüy. ");
INSERT INTO huvNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Wüx tapeayiw niüng ajlüy Teat Jesús, quiaj tajawüw aaga naxey tajlüy wüx ombas nej xeyay nimeech alchetem quiaj, lamasooig apix nej, lamajiür mifis nej. Mbayatoj xeyay majawüw. ");
INSERT INTO huvNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Condom nipilan leawa tajawüw aag ayaj, tapots mapiüngüw nguineay tawüw nimeech wüx ombas aaga naxey quiaj, nguineay tandeowüw tiül yow meáwan sow. ");
INSERT INTO huvNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ndoj tapots masajüw Teat Jesús maw tiül miiütüw nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Teat Jesús almajtep tiül müx, laámb apmaw quiaj, quiaj aaga naxey tajlüy wüx ombas nej nimeech tatün ocueaj xeyay sitiül alndom maquiiüb nej mamb. ");
INSERT INTO huvNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Pero Teat Jesús tasaj nej: ―Quiür ijtsor teat, isaj icualaats nguineay tejneaj. Isajüw meáwan aaga najneaj leaw Teat Dios lamarang wüx imbas, nguineay tajiür ic lasta ―aj. ");
INSERT INTO huvNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Quiaj tamb a naxey mandeac, masaj nipilan tiül meáwan cambaj tiül Decápolis. Tasaj nejiw nguineay tataag nej majneaj Teat Jesús. Meáwan nipilan mbayatoj manguiayiw. ");
INSERT INTO huvNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Condom Teat Jesús tandilil alinomb maquiiüb minipilan nej, ambüw tiül müx, andüyiw necamb aaga nadam yow quiaj. Almapeayiw necamb, quiájan tacül Teat Jesús mbeay yow, cos tapeayiw niüng ajlüy nej xeyay nipilan. ");
INSERT INTO huvNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Condom tapeay quiaj nop naxey nenüt Jairo, nop natang nenajiüt tiül a sinagoga; wüx tajaw Teat Jesús, quiaj taquieel micos nej tiüt. ");
INSERT INTO huvNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Tatün xeyay, tapiüng: ―Teat, xecual nüx laxeyay iün andeow, laliüc mandeow. Mac Teat, tabar meyac iwix wüx ombas nej para majneaj ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Quiaj Teat Jesús tamb maquiiüb nej. Xeyay nipilan tandüjpiw, lacharrayej wüx ombas nej. ");
INSERT INTO huvNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Tiül a nipilan quiaj tajlüy nop najtaj lamajiür gajpic (12) neat iün andeow, atsambiich nej miquiej nej. ");
INSERT INTO huvNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Lamamongoch xeyay wüx aaga monandeow quiaj. Masey lamong teombas xeyay mondüy, lamandrooch meáwan leaw ajiür, pero ngo mambeol nej nicuajind, teaxeyay marang nej. ");
INSERT INTO huvNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Aaga najtaj quiaj wüx tanguiay nguineay andeacüw wüx Teat Jesús, quiaj tamb matüch, amb wanopech Teat Jesús tarreeg apix nej. ");
INSERT INTO huvNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Atquiaj tarang, cos lamapiüng tiül omeaats nej: “Sitiül narreeg masey apix nej, quiaj sanajneaj”. ");
INSERT INTO huvNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Andǘüban tayaag lajneaj, nómban lamong a monandeow quiaj. ");
INSERT INTO huvNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Teat Jesús tayaag nej lamataag majneaj aljane, quiaj wantsat majaw tiül nipilan, tatün manguiay: ―¿Jane tarreeg sapixe? ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Quiaj minipilan nej tasajüw nej: ―¿Neol ngo mejaw Teat, xeyay nipilan teamatechtechiw ic? Neol tepiüng: “¿Jane tarreeg xic?” ―ajüw. ");
INSERT INTO huvNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Teat Jesús tayamb tiül nipilan majaw jane tarreeg nej. ");
INSERT INTO huvNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Aaga najtaj mbayat cos tajaw teamayamb nej, tambeapmbeap nej. Pero cos tayaag lajneaj, quiaj tamb maquieel micos nej tiüt teombas Teat Jesús, tasaj nguineay tarang nej. ");
INSERT INTO huvNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Quiaj tasaj nej Teat Jesús: ―Xecual, lerjneaj cos teyac imeaats wüx xic. Nganüy quiür, ich mapac imeaats, lerjneaj nómban ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Teat Jesús tenguialeámban andeac aweaag a najtaj, quiaj tapeayiw masajüw a Jairo, aaga nenajiüt tiül sinagoga, tapiüngüw: ―Teat, micual landeow, icueat mesajsaj aaga Teat Naxey quiaj ―ajüw. ");
INSERT INTO huvNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Naleaing Teat Jesús, masey tanguiay andeacüw ajcüwa monxey quiaj, nej tasaj aaga nenajiüt: ―Nde mbayamear teat, iyac imeaats wüx xique ―aj. ");
INSERT INTO huvNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ndoj ngome tüüch mambüw maquiiüb nejiw meáwan minipilan nej, áagan a Pedro maquiiüb Jacobo, at a Juan michiig Jacobo taquiiüb mamb. ");
INSERT INTO huvNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Wüx tapeayiw aniüng aaga nenajiüt tiül sinagoga, Teat Jesús tajaw alquiaj xeyay nipilan teajiüntsüw napac, y altiül teapajüw. ");
INSERT INTO huvNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Wüx tajmel tiül iüm, quiaj tasaj nejiw: ―¿Neol tapots ijiüntsana? Aaga nüx cam ngome landeow, almameay ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Quiaj titsojow nej, cos ajawüw naleaing landeow a nüx quiaj. Condom Teat Jesús tawün nejiw tiül iüm, taquiiüb áagan miteat nej mimüm nej a nüx, at leaw almaquiüjpüw nej. Tajmeliw matüchiw niüng ajlüy a nüx. ");
INSERT INTO huvNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Quiaj Teat Jesús tasap owix a nüx, tasaj wüx ombeayiw nejiw: ―Talita cumi ―aj. Aag ayaj amb apiüng: Xecual sasaj ic, witiür. ");
INSERT INTO huvNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Quiaj witiüt a nüx, tajüy. Meáwan nipilan xeyay mbayatoj majawüw. Aaga nüx quiaj lamajiür gajpic (12) mineat nej. ");
INSERT INTO huvNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Condom Teat Jesús tasaj nejiw nde mandeacüw manguiayaran leawa tarang. Tasaj nejiw aton mayambüw üet a nüx quiaj. ");
INSERT INTO huvNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Condom Teat Jesús taw quiaj, tandilil alinomb andüy tiül miíüt nej, minipilan nej aton tandüjpiw nej. ");
INSERT INTO huvNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Wüx tatüch a nüt axoodaran, quiaj tapots aquiaach tiül a sinagoga. Xeyay nipilan wüx tanguiayiw andeac nej mbayatoj. Tapiüngüw: ―¿Nguiaane tequiajchay aaga naxey quiaja? ¿Nguineay tendüye? ¿Nguineay ndot ombas marang cuajantanej ateócan? ");
INSERT INTO huvNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Neol ngome nop icoots aaga naxey quiaja? ¿Ngome nej nerang xiül, micual nej María? Aton alningüy tiül micambajaats acüliw michiig nej Jacobo, José, Judas, Simón, at michiig monüx nej aton aliw ningüy ―awüw. Taton ngome tandiümüw mayariw andeac nej. ");
INSERT INTO huvNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Quiaj Teat Jesús tasaj nejiw: ―Xique samongoch atnej amongoch nop nendeac andeac Teat Dios cos ayarich andeac nej nguiajantanej, áagan tiül miíüt nej ngo mandiüram. Átan acualaats nej, micoj nej, michiig nej, ngo mayariw nej andeac ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Tiül a cambaj quiaj ngome tarang nadam ateócan. Áagan acas moniün andeow tataag majneaj, tayac owix wüx nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Nej ayaag xeyay ngo majneaj cos ngo mayariw nej andeac. Ndoj taw quiaj, tamb andüy tiül namix nine cambaj quiájan, maquiaach. ");
INSERT INTO huvNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Condom quiaj tapaj miünüw niüng ajlüy nej ajcüwa gajpiüp (12) minipilan nej. Quiaj tapots masaj nejiw mambüw ijpüwpüw. Aton tüüch nejiw ndoj ombasüw matajcüw majneaj nipilan alwüx ombasüw nimeech. ");
INSERT INTO huvNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","At aton tasaj nejiw nde majoyiw nicuajind tiül tiiüd. Alndom majoyiw áagan notsnots angotoj, mambeol nejiw. Ngondom majoyiw nchiiüts, pemb, nüeteran; aton tomiün ngondom majoyiw. ");
INSERT INTO huvNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Netam masoijquiw napüic, pero ngondom majoyiw ijquiaw najal camix. ");
INSERT INTO huvNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Aton tasaj nejiw: ―Wüx apmepeayiün tiül noic cambaj, apmexojtan quiaj tíülan noic nden. Nde membiülüjchiün niüng ixojtan. Apmeriowan quiaj wüx apmeamban tiül alinoic cambaj. ");
INSERT INTO huvNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Sitiül noic cambaj ngo mangochiw icon, ngo mandiümüw manguiayiw indeacan, icueatiün, iriowan quiaj. Wüx apmeriowan quiaj, itajtan minajndot ileajiün majüic nejiw ngo majneaj arangüw cos ngo müjchiw icon mendeacan quiaj xepoch. Naleaing sasaj icon, alinoic nüt wüx Teat Dios apmajaw wüx asoeteran, nejiw xeyay ngo majneaj apmamongochiw cos ngo mandiümüw manguiayiw indeacan. Alwüx apmamongochiw, ngo matnej leaw apmamongochiw nipilan tandeowüw nomb, ajcüwa monaw tiül cambaj Sodoma maquiiüb Gomorra ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Quiaj tawüw ajcüwa gajpiüp minipilan nej, tambüw masajüw nipilan leaam omeajtsüw wüx aaga ngo majneaj teamarangüw, macueatiw. ");
INSERT INTO huvNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","At aton wüx minüt Teat Jesús tatajcüw majneaj nipilan alwüx ombasüw nimeech, üüch nejiw michachiw. At tajendiw aceite wüx omal moniün andeow, quiaj tajneajiw. ");
INSERT INTO huvNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Condom aaga rey Herodes tanguiay nguineay teamarang Teat Jesús, cos meáwan nipilan teamandeacüw wüx nej. Quiaj Herodes tapiüng: ―¿Ngwüy naleaingue, Juan, aaga neech yow nipilan lapac tiül mondeowa? ¿Pares ndot ombas marang xeyay cuajantanej ateócan aaga naxey quiaja? ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Altiül tapiüngüw: ―Ngwüy, aag ayaj mixejchiiüts Elías, awüw. Altiül tapiüngüw: Aag ayaj alinop nendeac andeac Teat Dios tajlüy tanomb ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Pero wüx Herodes tanguiay aaga andeacüw quiaj, tapiüng: ―Ngwüy, aag ayaj sapiüng Juan, aaga tüjchiüs mamb ndojquiüm onic nej, nganüy lapac tiül mondeow ―aw a Herodes. ");
INSERT INTO huvNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Atquiaj tapiüng Herodes cos alwüx omeaats leawa tarang, cos nej tüüch mamb ndeaam a Juan, majmel tiül manchiüc, naoelich naag galen. Aag ayaj tarang Herodes cos atquiaj tandiüm minajtaj nej nenüt Herodías. Aaga Herodías quiaj mintaj Felipe, michiig Herodes, nganüy Herodes lamaquiiüb. ");
INSERT INTO huvNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Cos Juan wüx aliün mapac tasaj Herodes: ―Ngo majneaj mequiiüb mintaj michiig ―aj. ");
INSERT INTO huvNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Quiaj Herodías xeyay tajcüy majaw a Juan. Tandiüm mambiy; pero ngome taxom nguineay marang. ");
INSERT INTO huvNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Cos Herodes lamajaw Juan arang leaw andiüm Teat Dios, aton andeac leaw naleaing, pares tembol mandüy, ngo müüch a Herodías marang ngo majneaj wüx ombas a Juan. Herodes masey ngo maxom omeaats wüx leaw tandeac a Juan, nej xeyay tandiüm manguiay. ");
INSERT INTO huvNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Noic nüt wüx Herodes tarang noic nangos nüt ajcan lamatüch alinoic mineat nej, quiaj aaga najtaj Herodías taxom nguineay marang. Cos Herodes tapaj meáwan monajiüt, at nipilan monjiür tomiün tiül aaga iüt Galilea, marang noic nadam nangos nüt. ");
INSERT INTO huvNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Quiaj tamb nop nüx, micual aaga najtaj Herodías, tajmel niüng ajlüy monet mejiüng. Herodes y leaw aliw quiaj tandiümüw majawüw ajiüng a nüx quiaj. Condom a rey Herodes tasaj a nüx: ―Itün xicueaj leaw indiüm, xique sanüüch ic ―aj. ");
INSERT INTO huvNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Nej tapaj minüt dios mapiüng naleaing apmüüch, ngo mawaiich, tapiüng: ―Cuajantanej apmetün, xique sanüüch ic, masey pinawan leaw alnajiür ―aw a Herodes. ");
INSERT INTO huvNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Quiaj taw a nüx, tamb matün manguiay mimüm nej. Tasaj: ―Müm, ¿cuane indiüm mejaw natüna? ―aj. Quiaj mimüm nej tapiüng: ―Itün omal aaga Juan, áag neech yow nipilan ―aj. ");
INSERT INTO huvNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Andilílan tiüt a nüx, tamb andüy niüng ajlüy Herodes, tapiüng: ―Teat, sandiüm nganüy nganüy meaach xic omal aaga Juan amb tiül noic polat ―aj. ");
INSERT INTO huvNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Quiaj Herodes tamix omeaats xeyay; pero cos nej lamapaj minüt dios, aton tandeac manguiayiw nipilan. Nganüy netam marang, müüch leaw atün a nüx quiaj. ");
INSERT INTO huvNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Najénan tüüch mamb nop soldado, tasaj mandooig onic a Juan majamiün omal. ");
INSERT INTO huvNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Quiaj tamb a soldado majaw tiül manchiüc mandooig onic a Juan. Condom tajoy omal a Juan amb tiül noic polat, tüüch a nüx. Quiaj a nüx tamb müüch mimüm nej. ");
INSERT INTO huvNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Wüx minipilan Juan tanguiayiw nej landeow, quiaj tambüw maxainguiw, tajoyiw mamiütüw. Atquiaj tarang Herodes wüx tambiy aaga Juan. ");
INSERT INTO huvNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Condom wüx tapeayiw ajcüwa gajpiüp (12) monamb ijpüwpüw, tapots masajüw Teat Jesús nguineay tarangüw, nguineay taquiajchiw nipilan. ");
INSERT INTO huvNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Quiaj tasaj nejiw Teat Jesús: ―Nganüy macaron, tabaats maxojtaats quiripite niüng ngo majlüy nipilan ―aj nejiw. Cos xeyay nipilan tenguial apeayiw quiaj niüng ajlüy nej, pálwüx teawüw. Ngo müjchiw nejiw matüch metiw. ");
INSERT INTO huvNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ndoj quiaj tajtepiw tiül nop müx, tambüw nejíwan quiaj, andüyiw niüng ngo majlüy nipilan. ");
INSERT INTO huvNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Pero xeyay nipilan tajawüw nejiw ambüw, aton tajawüw jane nejiw; quiaj tambüw acuiürrüw imiünüw tiül micambajüw nejiw. Ombas mapeayiw quiaj, teoj mapeay Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Wüx Teat Jesús taw tiüt imiün tiül müx maquiiüb minipilan nej, tajaw xeyay nipilan teamacüliw nej. Quiaj tajmiüc omal omeaats, cos tajaw ajlüyiw atnej tigüy najcueat sap, ngo majlüy wüx nejiür nejiw. Quiaj tapots maquiaach nejiw xeyay cuajantanej. ");
INSERT INTO huvNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Wüx langwiiüts laliüc majmel nüt, quiaj minipilan nej tambüw masajüw nej: ―Teat, langwiiüts ¿nguineay apmarangaats? Cos nejinguind ngo macül ningüy. ");
INSERT INTO huvNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Isajüw mambüw tiül cambaj y tiül rünch mangalüw üetiw, cos ngo majiürüw üetiw nejiw ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Quiaj Teat Jesús tasaj nejiw: ―Icona iyamban üetiw ―aj nejiw. Quiaj tapiüngüw: ―¿Teat, nguineaye? ¿Ngwüy sanamban nangalan ijquiaw acoic miow (200) denario pan müjchiiüts müetiwe? ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Teat Jesús tasaj nejiw: ―Quiüran ijawan cas pan ijiüran ningüy ―aj nejiw. Wüx tajawüw cas pan ajlüy, quiaj tasajüw nej: ―Ajlüy acoquiaw pan alijpüw cüet ―ajüw. ");
INSERT INTO huvNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Quiaj Teat Jesús tasaj nejiw masajüw nipilan chetemoj noicnoic ajlüy tiül nine nateaic soex. ");
INSERT INTO huvNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Quiaj chetetoj; al tiül atüch coic miow (100), al tiül ic miow gajpowüw (50) noicnoic ajlüy. ");
INSERT INTO huvNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Condom Teat Jesús taxaing aaga acoquiaw pan al ijpüw cüet. Taxaing omal majaw cawüx, tüüch gracias Teat Dios. Condom wüx tambaag aaga pan texeyay. Quiaj tüüch minipilan nej majineaw müjchiw meáwan nipilan. At aaga ijpüw cüet aton tambaag müüch nejiw majineaw. ");
INSERT INTO huvNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Condom tatüch müetiw meáwan nipilan paxiünüy üetiw. ");
INSERT INTO huvNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Wüx landoj, quiaj taxainguiw leawa minaw a pan, at a cüet, chipiüt gajpiüp (12) nchep. ");
INSERT INTO huvNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ajcüwa tetiw quiaj atüch acoquiaw mil monxey. ");
INSERT INTO huvNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Quiaj Teat Jesús tasaj minipilan nej majtepiw tiül müx mamongoj andüyiw necamb a nadam yow quiaj. Tasaj nejiw mambüw ombas nejiw mandüyiw tiül cambaj Betsaida. Cos nej apmacül quiaj leawa ümb majtsor nipilan, quiaj apmaw quiaj. ");
INSERT INTO huvNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Wüx laǘmb majtsor nipilan, quiaj tamb andüy wüx nop tiüc mataag orar, mandeac aweaag Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Wüx lapojniow, aaga müx namb lamatüch pinawan aaga nadam yow quiaj, nganüy Teat Jesús néjan quiaj aliün wüx iüt. ");
INSERT INTO huvNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Nej tajaw laǘmb apacüw majombüw a yow majüyichaw a müx, cos angochiw a iünd. Wüx landüy wüx arraw, quiaj Teat Jesús tamb matüch nejiw, ajüy amb teomal yow. Tarang atnej apmamóngan. ");
INSERT INTO huvNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Wüx tajawüw nop najüy amb teomal yow, quiaj tepajüw: ―¡Aag ayaj nembolooch! ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Meáwan nejiw tajawüw, xeyay mbayatoj. Quiaj Teat Jesús tasaj nejiw: ―Nde mbayameron, ich mapac imeajtsan cos xique, ngome aljane ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Condom tajtep tiül müx maquiiüb nejiw; quiaj lomboj a iünd. Mbayatoj majawüw, ndoj tapac omeajtsüw ");
INSERT INTO huvNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Nejiw nganaw majawüw nguineay tarang wüx tüüch mexeyay a pan, aliün mapac omalüw. ");
INSERT INTO huvNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Tapeayiw necamb a yow tiül iüt Genesaret. Quiaj tawüw tiüt, taoeliw mimüxiw nejiw mbeay yow. ");
INSERT INTO huvNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Wǘxan tajtepiw wüx iüt, quiaj nipilan tajawüw nejay Teat Jesús napeay. ");
INSERT INTO huvNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Condom quiaj tambüw acuiürrüw masajüw meáwan nipilan tiül aaga iüt quiaj. Quiaj tapots apeayiw nipilan maquiüjpüw miün moniün andeow amb wüx mats, andüy niüng tanguiayiw alquiaj Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Nguiajantanej leaw niüng tamb, masey tiül cambaj, masey tiül rünch, tacüliw nej xeyay nipilan. Tayacüw ajcüwa moniün andeow mbeay plas pinawan cambaj, at tiül tiiüd aton. Tatüniw xeyay ocueaj Teat Jesús sitiül alndom ajcüwa moniün andeow masambüw nej masey apix nej. Meáwan leaw tasambüw nej tajneajiw nómban. ");
INSERT INTO huvNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Noic nüt acas fariseos tambüw majawüw Teat Jesús, maquiüjpüw ajcüwa mondüy wüx aaga poch tüünd Moisés, napeayiw imiünüw Jerusalén. ");
INSERT INTO huvNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Quiaj tajawüw altiül minipilan Teat Jesús teaüetiw; pero ngo marangüw atnej ajlüyay marangüw meáwan nipilan judío wüx ajantsüw owixaw. Áag tandeacndeacüw ngo majneaj wüx ombasüw nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Cos ajcüwa fariseos at meáwan judíos ajlüyayej wüx marangüw atnej arangüw mixejchiw nejiw, cos ngo metiw sitiül ngo majantsüw owixaw nejiw xeyay atnej apiüngüw netam. ");
INSERT INTO huvNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Wüx nejiw apeayiw ajüyiw tiül plas angalayej, ngondom müetiw nicuajind sitiül ngo majantsüw owixaw atnej apiüngüw netam marangüw. Aton ajiürüw palpálwüx arangüw wüx ajantsüw inganeowayej, xar iüt, xar manchiüc, at mimatsüw nejiw aton.) ");
INSERT INTO huvNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Quiaj ajcüwa fariseos at mondüy wüx aaga poch tüünd Moisés, tatüniw manguiayiw Teat Jesús. Tasajüw: ―¿Neol minipilan ngo mandüjpiw leaw tarangüw mixejchiiütsa? ¿Neol ngo majantsüw owixaw wüx üetiw atnej ajlüyay marangaatsa? ―ajüw. ");
INSERT INTO huvNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Quiaj Teat Jesús tasaj nejiw: ―Icona monwaiich, iwüyayon wüx irangan najneaj, naleaing tarang Isaías tiül minawiig nej aaga poch niüng Teat Dios tapiüng: Ajcüwa nipilan quiaj apiüngǘwan ayariw sandeac, ngome con omeajtsüw, ombeayíwan. ");
INSERT INTO huvNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ngo membeat marangüw atnej arangüw xic casa, cos meáwan leaw aquiajchiw, aag ayaj mipochíwan nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Pero icona landroj imeajtsan leaw Teat Dios apiüng netam merangan, cos tenguial ipacan wüx leaw ngo metam, leaw mixejchiün tarangüw. Atnej wüx ijantsan ajcüwa xar, tas, at teamendüjpiün cuajantanej leawa tayacüw mixejchiün, aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Tasaj nejiw aton: ―Icona tewüniün ninguiün meáwan leawa tasaj icon Teat Dios merangan, cas tendüjpiün opech leawa tayacüw mixejchiün. ");
INSERT INTO huvNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Teat Moisés tarang tiül minawiig nej, tapiüng: “Iyar andeacüw miteat, mimüm, indiümüw”, aw. Aton tapiüng: “Jane apmapaiich mandeac ngo majneaj wüx ombas miteat nej, mimüm nej, ich mambiyaran”, aw a Moisés. ");
INSERT INTO huvNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Pero icona xeyay ngo majneaj irangan, cos ipiüngan aljane alndom masaj miteat nej, mimüm nej, mapiüng: “Leawa alnajiür langondom nüüch icon, cos aag ayaj Corbán”. (Amb apiüng meáwan leaw ajiür lamüüch Teat Dios.) ");
INSERT INTO huvNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Wüx apmapiüng aag ayaj, quiaj lango metam mambeol miteat nej mimüm nej cos icona iquiajchiün ombeay. ");
INSERT INTO huvNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Wüx irangan aag ayaj, quiaj temewüniün ninguiün Mipoch Teat Dios, teyacan ingow leawa tayacüw mixejchiün marangüch. Ajlüy xeyay cuajantanej atnej aag ayaj leaw icona teyacan marangüch ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Quiaj Teat Jesús tapaj nipilan alinomb masaj: ―Inguiayiün, iyacan wüx imeajtsan leaw sanasaj icon. ");
INSERT INTO huvNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Cuajantanej leaw alndom müeteran, manganeowaran ngo müüch nop majiür nisoet; pero leawa alwüx omeaats mandeac mbich alndom mayac nej asoet. ");
INSERT INTO huvNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Jane andiüm manguiay, ich manguiay mayac wüx omeaats ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Condom wüx Teat Jesús taw niüng ajlüy meáwan nipilan, quiaj tajmel tiül iüm. Ndoj minipilan nej quiaj tapots matüniw manguiayiw nej, tasajüw: ―¿Cuane wüx tendeac aaga les ndot mendeac quiaja? ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Quiaj tasaj nejiw: ―¿Neol, ata icona aton ngo mejawan leawa tandeacas? ¿Neol ngo mejawana, meáwan leaw alndom müeteran ngo müüch majiür nisoet nipilan? ");
INSERT INTO huvNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Cos nüeteran andǘyan teomeaatsaran apmamb, ndoj apmaw. Aaga nüeteran quiaj ngo müüch majiür nisoet nipilan ―aj nejiw Teat Jesús. Nej tandeac wüx aag ayaj majüiquich meáwan cuajantanej nüeteran alndom müeteran, ngome nisoet. ");
INSERT INTO huvNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Aton tapiüng: ―Leawa nop apmandeac wüx omeaats, mbich aag ayaj alndom müüch nej majiür nisoet. ");
INSERT INTO huvNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Cos imiün wüx omeaatsaran aw leaw ngo majneaj arangüch. Áag altiül nipilan ajiürüw minajtajüw nejiw, minaxeyiw nejiw, at altiül monench ajlüyiw maquiüjpüw monüx, átan monüx maquiüjpüw monench, at monbiy nipilan aton. ");
INSERT INTO huvNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","At ajlüy moneed, ajlüy reech, ajlüy monrang xeyay ngo majneaj, at monwaiich, ajlüy monjüyjüy, ajlüy mondiüm ocueaj alinop. Aton ajlüy monpaiich, monrangrangüy, ajlüy nerangrang michach. ");
INSERT INTO huvNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Meáwan aaga ngo majneaj arangüch quiaj, imiün tiül omeaatsaran. Aag ayaj mbich üüch majiüraran nisoet ―aw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Condom Teat Jesús taw quiaj tamb andüy niüng ajlüy cambaj Tiro y Sidón. Tandüy tiül noic naniüngaran, maxood quiaj, cos nej ngo mandiüm majawüw nej nipilan. Pero naleaing ngondom mexotüy. ");
INSERT INTO huvNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Nop najtaj najénan tanguiay Teat Jesús lapeay quiaj. Aaga najtaj quiaj ajiür nop micual nej nüx, alwüx ombas nej nimeech, üüch nej michach. Quiaj tamb maquieel micos nej tiüt teombas Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Aaga najtaj quiaj ngome micual iüt Israel, nej nop sirofeniciana. Nej tatün xeyay ocueaj Teat Jesús mamb mawün nimeech wüx ombas micual nej. ");
INSERT INTO huvNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Quiaj Teat Jesús tasaj nej: ―Icül, cos ombas netam metiw nacualaran, cos ngo majneaj majnot üetiw nejiw majlos müjndiw a namix nine pet müetiw ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Aaga najtaj tasaj nej: ―Teat, naleaing aag ipiüng quiaj, masey ombas apmetiw a nacualaran, pero aton nine pet alndom mamilmil leawa najmiüc tiüt minaw üet nacualaran ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Quiaj tasaj nej Teat Jesús: ―Xecual, najneajay indeac quiaj. Nganüy quiür ijaw micual, cos lanüüch majneaj, lamacueat nej nimeech ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Naleaing tasoic, cos wüx tapeay aniüng nej, quiaj tajaw micual nej alpiiüm wüx mats, lajneaj, lamacueat nej nimeech. ");
INSERT INTO huvNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Condom Teat Jesús taw quiaj tiül miíüt monaw Tiro, tamong amb tiül Sidón, at tamong amb tiül miíüt Decápolis, tatüch mbeay aaga nadam yow Galilea. ");
INSERT INTO huvNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Taquiiübaran mamb quiaj majaw nej Teat Jesús nop naxey nelaag, aton ngondom mendeac. Quiaj tatüniw ocueaj Teat Jesús sitiül alndom mayac owix wüx aaga naxey quiaj müüch majneaj. ");
INSERT INTO huvNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Quiaj Teat Jesús tawün ninguiün quiriw aaga naxey quiaj nejeweáagan quiaj. Condom Teat Jesús taxec micual owix nej teolaag a naxey quiaj, ndoj tateonts onts ombeay nej cas tarreeg oniw a naxey quiaj. ");
INSERT INTO huvNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Condom quiaj taxaing omal majaw andüy cawüx, tawün miíünd nej, tapiüng: ―¡Efata! ―aw. Aaga poch quiaj amb apiüng: ¡Lejquiar! ");
INSERT INTO huvNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Quiaj lejquiat olaag a naxey y oniw nej taley, lajneaj. Quiaj tajneaj mendeac. ");
INSERT INTO huvNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ndoj tasaj nejiw Teat Jesús nde masajüw nejinguind. Pero masey atquiaj tasoiquiw, nejiw xeyay tandeacndeacüw wüx. ");
INSERT INTO huvNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Mbayajow wüx, xeyay tapac omeajtsüw majawüw leaw Teat Jesús tarang, tapiüngüw: ―Nej arang cuajantanej najneaj, cos üüch manguiay nelaag nipilan, at üüch mendeac jane ngondom mendeac ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Tiül aaga nüt quiaj, canchiütoj xeyay nipilan niüng ajlüy nej. Wüx tind üetiw ngo majiürüw cuane apmüetiw. Quiaj Teat Jesús tapaj minipilan nej, tasaj: ");
INSERT INTO huvNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―Sajiürüw lasta ajcüwa nipilan quiaj, cos lamajiür er nüt ajlüyiw ningüy maquiüjpaats, lango majiürüw üetiw. ");
INSERT INTO huvNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Sitiül sanasajüw majtsoriw wǘxan nganaw metiw, ngondom maiücüw, apmajmiücüw tiül tiiüd cos altiül imiünüw miünquiaj ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Quiaj tasajüw nej minipilan nej: ―¿Nguineay alndom maxoram cuane apmüetiw ningüy tiül a wajchiüc cam? Cos ngo macüleran ningüy ―ajüw. ");
INSERT INTO huvNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Quiaj Teat Jesús tatün manguiay nejiw: ―¿Cas pan aliün mejiürana? ―aj nejiw. Nejiw tapiüngüw: ―Alíünan ayaíw pan ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Quiaj tasaj ajcüwa nipilan chetemoj tiüt, taxaing aaga ayaíw pan quiaj. Tüüch gracias Teat Dios, cas tambaag a pan, tüüch minipilan nej majineaw. ");
INSERT INTO huvNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","At aliün majiürüw acas nine cüet aton. Quiaj Teat Jesús tüüch gracias Teat Dios alinomb. Condom tüüch nejiw majineaw. ");
INSERT INTO huvNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Meáwan nipilan tetiw paxiün. Wüx landoj üetiw, quiaj taxainguiw chipiüt ayaíw nchep minaw üetiw. ");
INSERT INTO huvNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ajcüwa monet quiaj tatüch maseyme apiquiw mil nipilan. Wüx landoj üetiw, quiaj Teat Jesús tüüch nejiw majtsoriw. ");
INSERT INTO huvNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Condom nej tajtep tiül müx maquiiüb minipilan nej. Tambüw andüyiw tiül iüt Dalmanuta. ");
INSERT INTO huvNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Wüx tapeayiw quiaj, altiül fariseos tambüw majawüw nej, tasajsajüw cuajantanej, majawüw cuane apmapiüng. Tasajüw: ―Irang noic nadam ateócan najawan, quiaj alndom napiüngan naleaing Teat Dios najlüy tiül cielo teamambeol ic ―ajüw. ");
INSERT INTO huvNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Quiaj Teat Jesús tamix omeaats, tawün miíünd nej, tapiüng: ―¿Cuane nerang icon? ¿Neol tendiüman mejawan nadam ateócan? Naleaing sasaj icon ngome sanarang nicuajind ateócan mejawan ―aw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Condom quiaj taw niüng ajlüyiw a nipilan quiaj maquiiüb minipilan nej, tajtepiw tiül müx, tambüw tandüyiw necamb a nadam yow. ");
INSERT INTO huvNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Minipilan nej ngo leaam omeajtsüw majoyiw üetiw nejiw, áagan noic pan tajiürüw tiül müx. ");
INSERT INTO huvNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Quiaj tasaj nejiw Teat Jesús: ―Inguiayiün sanasaj icon. Netam mejawan wüx leaw irangan. Nde meyariün andeacüw Fariseos, at andeac Herodes. Cos aag ayaj arang atnej arang levadura ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Quiaj minipilan nej tandeacüw nejeyéjan quiaj, tapiüngüw: ―¿Neol tandeac atquiaja? ¿Ngwüy ajcan ngo majamiünaats pana? ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Teat Jesús tajaw cuane teamandeacüw. Quiaj tasaj nejiw: ―¿Neol tapots indeacndeacan wüx pana? ¿Neol nganaw mejawana, meyacan wüx imeajtsana? ¿Aliün palam imalana? ");
INSERT INTO huvNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿Neol ngome tejawan con iniüjcan? ¿Neol ngome tenguiayiün con ilajcan? ¿Neol ngo leaam imeajtsan? ");
INSERT INTO huvNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Jow, wüx tajineas acoquiaw pan müetiw acoquiaw mil monxey, jow leaw tenaw, ¿cas nchep techipichana? ―aj nejiw Teat Jesús. Quiaj tapiüngüw: ―Gajpiüp (12) nchep ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Condom tandüy wüx matün manguiay, tapiüng: ―Jow wüx tajineas ayaíw pan müetiw apiquiw mil nipilan, leawa tenaw, ¿cas nchep texainguiüna? ―aj nejiw Teat Jesús. Quiaj tapiüngüw: ―Ayaíw nchep ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Quiaj Teat Jesús tapiüng: ―¿Neol nganaw mejawana jane xic? ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Wüx tapeayiw tiül cambaj Betsaida, quiaj acas nipilan taquiüjpüw mamb niüng ajlüy Teat Jesús nop naxey nesomb. Tasajüw nej mayac owix nej wüx a naxey quiaj para majneaj. ");
INSERT INTO huvNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Quiaj Teat Jesús tasap owix a nesomb quiaj, tanetet owix maquiiüb mamb andüy mbeay cambaj. Ndoj tajendjend wüx oniiüg a naxey quiaj aonts ombeay nej, tayac owix nej wüx a naxey quiaj. Cas tatün manguiay sitiül larraw oniiüg lamaxom majaw quiripite. ");
INSERT INTO huvNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Aaga nesomb quiaj taxaing omal, tapiüng: ―Nganüy saxom najaw quiripite, sajaw nipilan atnej xiül, pero nejiw teajüyiw ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Condom Teat Jesús tayac owix nej alinomb wüx oniiüg a naxey quiaj. Quiaj aaga naxey tajaw teáman, tajneaj oniiüg nej, tajaw ranüy masey miünquiaj. ");
INSERT INTO huvNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Quiaj tasaj nej Teat Jesús: ―Quiür ijtsor, nde memong iriümb tiül cambaj, nde mesaj nejinguind nguineay tejneaj ―aj. ");
INSERT INTO huvNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Condom quiaj tamb Teat Jesús maquiiüb minipilan nej, tamongoj ambüw tiül namix nine cambaj ocueaj Cesarea de Filipo. Wüx aliw tiül tiiüd, quiaj Teat Jesús tasaj minipilan nej: ―¿Jane xic apiüngüw nipilana? ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Quiaj tasajüw nej: ―Altiül apiüngüw ique aaga Juan lapac alinomb. Altiül apiüngüw ique aaga Elías tajlüy tanomb. Aton altiül apiüngüw ique alinop nendeac andeac Teat Dios ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Quiaj Teat Jesús tatün manguiay nejiw: ―Jow icona, ¿cuane ipiüngan, jane xic? ―aj nejiw. Quiaj tapiüng a Pedro: ―Iquiay aaga Cristo, aaga lapiürang aliüc ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Teat Jesús quiaj tasaj nejiw nde masajüw nejinguind jane nej. ");
INSERT INTO huvNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Condom quiaj tapots masaj nejiw, tapiüng aaga Teat Naxey netam mamongoch xeyay ngo majneaj. Ngome apmayariw nej andeac montangtang monajiüt, at montangtang miteaats, at mondüy wüx aaga poch leaw tüünd a Moisés aton. Tapiüng alinoic nüt nej apmandeow, apmambiyaw nej ajcüwa nipilan quiaj. Condom wüx er nüt apmapac alinomb. ");
INSERT INTO huvNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Tasaj nejiw atquiaj ranüy. Quiaj a Pedro tawün nej ninguiün quiriw, tapots malic. ");
INSERT INTO huvNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Pero Teat Jesús ndiliteay majaw niüng ajlüy alacas minipilan nej, quiaj talic a Pedro, tasaj: ―¡Icueat xic, nde mendeac atnej andiüm Satanás! Cos aaga indeac quiaj ocueaj nipilan, ngome ocueaj Teat Dios ―aj nej Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Quiaj Teat Jesús tapaj meáwan nipilan miünüw canchiümoj maquiüjpüw minipilan nej. Tasaj nejiw: ―Sitiül aljane andiüm mayar sandeac, ich mawün wüx omeaats meáwan naél leaw alndom mamongoch, ich mandüüb wüx leawa sarang, masey mamongoch xeyay ngo majneaj, masey mandeow wüx cruz ajcan andüüb xic. ");
INSERT INTO huvNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Sitiül aljane ngo mayar sandeac cos imbol mambiy nej nipilan, alinoic nüt nej apmamongoch xeyay ngo majneaj, y ngome apmamb tiül cielo. Pero sitiül aljane masey mandeow ajcan andüüb xic ayar sandeac, nej apmamb tiül cielo alinoic nüt ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Aton tapiüng: ―Jondot aljane alndom maneay meáwan cuajantanej leaw ajlüy wüx a iüt cam, ¿cuane ambich sitiül nej ngo mamb tiül cielo? ");
INSERT INTO huvNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","¿Mbich nguineay alndom nop nipilan mangüy asoet nej, nguineay alndom maw wüx para ngo mamb tiül aaga xeyay ngo majneaja? ");
INSERT INTO huvNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Sitiül aljane ngo mayar sandeac cos axing wüx xepoch, ngo mind mitsoj nej ajcüwa nipilan monrang xeyay ngo majneaj, ajcüw mondüüb narangüch dios, pues ata Teat Naxey apmaxing majaw nej wüx apmandilil. Cos aliüc alinomb imiün niüng ajlüy Teat Dios. Apmaquiiüb miün xeyay ángeles, xeyay najneajay apmajlüy ―aw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Condom tasaj nejiw Teat Jesús: ―Naleaing sasaj icon, altiül icona leaw alningüy nganüy cam, nganaw mendeowan apmejawan noic nadam ateócan, apmejawan aliüc Teat Naxey marang natang nenajiüt tiül micambaj nej ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Wüx lamatüch anaíw nüt tatow ndoj mapiüng aag ayaj, quiaj Teat Jesús taquiiüb Pedro, Jacobo, y Juan, tambüw wüx nop nadam tiüc nejíwan quiaj. Condom quiaj Teat Jesús tewüneay majawüw nej. ");
INSERT INTO huvNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Xeyay nelitlit apix nej, rajnüy. Nejinguind wüx a iüt cam ngondom majants noic raan jael müüch merixix matnej. ");
INSERT INTO huvNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Quiaj tajawüw mixejchiw nejiw tajlüyiw tanomb, aaga Elías maquiiüb Moisés, teandeacüw maquiüjpüw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Condom quiaj Pedro tasaj Teat Jesús: ―Teat, ¡najneajay macüliiüts ningüy, marangaats arej nden! Noic ineay, alinoic apmaneay teat Moisés, alinoic apmaneay teat Elías ―aj nej a Pedro. ");
INSERT INTO huvNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Atquiaj tapiüng a Pedro cos ngo majaw cuane apmandeac, mbayatoj xeyay majawüw. ");
INSERT INTO huvNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Condom quiaj tajlüy oic cawüx alareng niüng ajlüyiw, tanden nejiw. Imiün tiül aaga oic quiaj tanguiayiw noic nanderac, tapiüng: ―Aaga Teat Naxey quiaj nejay xecual, xeyay sandiüm. Inguiayiün leaw nej apmasaj icon ―aj nejiw aaga nendeac quiaj. ");
INSERT INTO huvNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Wǘxan ndoj manguiayiw aaga nanderac quiaj, quiaj tajawüw lango majlüy nejinguind, néjan Teat Jesús almaquiüjpüw. ");
INSERT INTO huvNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Condom wüx teawüw tiüt imiünüw wüx tiüc, quiaj Teat Jesús tasaj nejiw nde masajüw nejinguind leawa Teat Dios tüüch nejiw majawüw. Leawa ndoj apac tiül mondeow aaga Teat Naxey, quiaj alndom mandeacüw wüx aag ayaj. ");
INSERT INTO huvNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Atquiaj nejiw ngo masajüw nejinguind, pero tíülan nejiw tetünayej menguiayayej nguineay amb aaga apiüng quiaj wüx tapiüng apmapac tiül mondeow. ");
INSERT INTO huvNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Condom quiaj tatüniw manguiayiw Teat Jesús, tapiüngüw: ―¿Neol tapiüngüw ajcüw mondüy wüx aaga poch tüünd Moisés netam miün ombas nej aaga Elías, ndoj aliüc aaga Cristo? ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Quiaj tasaj nejiw Teat Jesús: ―Naleaing Elías netam miün ombas nej masaj nipilan leaam omeajtsüw wüx Teat Dios. ¿Neol ngo mejawana, nguineay apiüng Teat Dios tiül Mipoch nej wüx Teat Naxey, aaga tüünd miün imiün tiül cielo? Cos apiüng nej apmamongoch xeyay ngo majneaj, ngome apmayarich andeac nej. ");
INSERT INTO huvNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Nganüy sanasaj icon wüx Elías, cos nop atnej Elías tiün. Tarangüw xeyay ngo majneaj wüx ombas nej, tarangüw leawa tandiümüw. Atnej landoj lamapiüng tiül Mipoch Teat Dios wüx nej, atquiaj tajlüy ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Wüx tapeayiw niüng ajlüyiw alacas minipilan Teat Jesús, quiaj tajawüw aliw quiaj xeyay nipilan ayey nejiw tiüt. Aton aliw quiaj mondüy wüx aaga poch tüünd a Moisés, tenguial asajsajayej maquiüjpüw minipilan Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Wüx tajawüw lapeay niüng ajlüyiw nejiw Teat Jesús, mbayatoj majawüw, acuiürrüw tambüw mangochiw matepeayiw. ");
INSERT INTO huvNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Quiaj Teat Jesús tatün manguiay nejiw: ―¿Cuane wüx tenguial indeacndeacana? ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Quiaj taw nop tiül a nipilan quiaj, tapiüng: ―Teat, jogüy saquiiüb miün nop xecual mejaw, cos alwüx ombas nej nimeech, ngondom mendeac. ");
INSERT INTO huvNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Wüx apeay mimonandeow nej, alox nej tiüt, atepich teombeay nej popox, ancaporros olüic nej. Tenguial amb arix, lango majiür apac. Landoj nasajüw minipilan sitiül alndom mawüniw wüx ombas xecual aaga nimeech quiaj, pero ngondom ombasüw ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Quiaj Teat Jesús tasaj nejiw: ―¡Jaa, icona nipilan! ¿Neol ngo meyariün sandeaca? ¿Cas nüt ipiüngan sanajlüy ningüy naquiiüb icona? ¿Ngow apmeyariün sandeaca? ―aj nejiw. Condom tapiüng: ―Iquiüjpan miün aaga nench quiaj ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Quiaj taquiüjpüw mamb. Wüx aaga nimeech najlüy wüx ombas a nench quiaj tajaw Teat Jesús, quiaj tambeapmbeap a nench napac, tajmiüc ambiülmbiülüy tiüt, tatepich teombeay nej popox. ");
INSERT INTO huvNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Quiaj Teat Jesús tatün manguiay miteat a nench: ―¿Nde ngüt tapots marang nej atquiaja? ―aj. Quiaj tapiüng a naxey: ―Wüx nine nej. ");
INSERT INTO huvNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Mbójan malox nej tiül biümb, at tiül yow, andiüm mambiy nej. Nganüy Teat, sitiül alndom membeol xicon, sitiül majmiüc imal imeaats, Teat, imbeol xicon ―aw miteat a nench. ");
INSERT INTO huvNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Quiaj tasaj nej Teat Jesús: ―¿Neol tepiüng sitiül alndom nambeola? Cos jane ayar sandeac, cuajantanej leaw apmatün xicueaj, xique sanarang ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Condom quiaj tapiüng miteat a nench: ―¡Sayar indeac teat, imbeol xic nde nachiw ximeaats! ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Teat Jesús tajaw teapeayiw xeyay nipilan acuiürrüw sonongomoj niüng ajlüy nej. Quiaj talic a nimeech najlüy wüx ombas a nench. Tasaj: ―Ique nimeech, neech ngo mendeac a nench cam, at neech melaag aton, iriow wüx ombas nej, icueat nómban. ¡Nde mendüy wüx alinomb! ―aj nej Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Quiaj aaga nimeech tepaj, tandüy wüx malanglang alinomb aaga nench. Quiaj taw, tacueat nej. Ndoj aaga nench píiüdan tiüt atnej landeow. Xeyay nipilan tapiüngüw landeow. ");
INSERT INTO huvNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Teat Jesús tasap owix a nench mawitich. Quiaj witiüt a nench. ");
INSERT INTO huvNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Condom wüx Teat Jesús tajmel tiül nop iüm, quiaj minipilan nej tatüniw manguiayiw nej nejíwan quiaj, tasajüw: ―¿Neol xicona ngondom nawüniün aaga nimeech quiaj? ―ajüw. ");
INSERT INTO huvNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Quiaj Teat Jesús tasaj nejiw: ―Ajcüwa nimeech quiaj ngo mawüw sitiül ngo metüniün ocueaj Teat Dios, meiündan lop aton ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Condom tawüw quiaj, tajüyiw ambüw tiül iüt Galilea. Pero Teat Jesús ngo mandiüm majaw nejiw nipilan, ");
INSERT INTO huvNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","cos nej tealeámban maquiaach minipilan nej. Tasaj nejiw nguineay apmarangüch wüx Teat Naxey. Aton tapiüng aljane apmayac nej teowixaw nipilan, apmambiyaw nej, ndoj wüx er nüt apmapac alinomb. ");
INSERT INTO huvNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Nejiw ngo majawüw cuane wüx teamasaj nejiw, pero imboloj matüniw manguiayiw. ");
INSERT INTO huvNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Condom tapeayiw tiül cambaj Capernaum. Wüx aliw tiül iüm, quiaj Teat Jesús tatün manguiay nejiw: ―¿Cuane tendeacndeacan wüx aliiüts tiül tiiüda? ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Nejiw ngo mendeacüw, ndijchiüjówan, cos wüx aliw tiül tiiüd tandeacüw wüx jane tiül nejiw apmarang natang. ");
INSERT INTO huvNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Condom quiaj Teat Jesús chetet, tasaj ajcüwa gajpiüp (12) minipilan nej, tapiüng: ―Sitiül aljane andiüm marang natang, netam marang chingüy tiül meáwan nipilan, marang cuajantanej mambeol meáwan ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Alquiaj nop nine. Condom Teat Jesús tayac pinawan nejiw a nine. Quiaj taxaing mapeic, tasaj nejiw: ");
INSERT INTO huvNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―Sitiül aljane apmajiür lasta masey nop nine atnej aaga nine cam, aag ayaj atnej xique teamajiür lasta. At sitiül aljane ajiür xic lasta, aag ayaj ngome xíquian quiaj ajiür xic lasta, at Xeteat aton, cos nej tüüch xic niün ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Condom quiaj tasaj nej a Juan: ―Teat, tajawasan nop naxey tawün nimeech wüx ombas nipilan, apaj wüx minüt. Tapajasan ocueaj cos ngo maquiiüb icoots ―aj nej a Juan. ");
INSERT INTO huvNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Quiaj tasaj nejiw Teat Jesús: ―Ich majlüy, nde mepalan. Cos nejinguind ngondom marang ateócan wüx xenüt, ndoj andǘüban mandeac ngo majneaj wüx ximbas. ");
INSERT INTO huvNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Cos sitiül nop ngo majcüy majaw icoots, aag ayaj najneaj majaw icoots. ");
INSERT INTO huvNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Sitiül aljane apmüüch icon masey noic pite yow, cos ajaw xenipilan icon, naleaing sasaj icon aag ayaj apmajiür cuane najneaj apmüünd alinoic nüt. ");
INSERT INTO huvNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","’Sitiül aljane mayac wüx nisoet nop tiül ajcüwa jayats monyar sandeac, najneaj wǘxan nganaw marang aaga ngo majneaj quiaj maoelich teonic nej nop cow majlos tiül ndec. ");
INSERT INTO huvNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Aton sitiül aljane ayaag owix nej alndom mayac nej tiül nisoet, ich mandooig. Cos más najneaj mapac ningüy masey ngo majiür nots owix nej, ingow ajiür miijtsüw owix, ndoj alinoic nüt mamb tiül biümb niüng ngondom xejquem, mandaab meáwan nüt. ");
INSERT INTO huvNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Cos ninguiün ajcüwa ndiüc apmajlüy wüx ombas nej ngome apmandeowüw, at a biümb ngondom xejquem. ");
INSERT INTO huvNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Sitiül aljane ayaag oleaj nej alndom mayac nej tiül nisoet, ich mandooig nots oleaj nej. Cos más najneaj majlüy atquiaj ingow ajiür miijtsüw oleaj nej, ndoj alinoic nüt mamb tiül biümb niüng ngondom xejquem. ");
INSERT INTO huvNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Cos ninguiün ajcüwa ndiüc leaw apmajlüy wüx ombas nej ngome apmandeowüw, at a biümb ngondom xejquem. ");
INSERT INTO huvNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","At sitiül aljane ayaag oniiüg nej alndom mayac nej tiül nisoet, ich masoond noic oniiüg nej. Cos más najneaj majlüy tiül minipilan Teat Dios noic oniiüg, ingow ajiür ijquiaw oniiüg ndoj majlos tiül biümb; ");
INSERT INTO huvNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","cos ninguiün tiül a castigo ajcüwa ndiüc apmajlüy wüx ombas nej ngome apmandeowüw, at a biümb ngondom xejquem. ");
INSERT INTO huvNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Cos meáwan apmatajcüch majneaj naag biümb, y meáwan nichech apmüünd majtix naag quiniüc. ");
INSERT INTO huvNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Najneaj quiniüc aag ayaj najtix; pero jondot lango majtix, ¿cuane ajpar? ¿Nguineay apmajtix alinomb? At icona aton netam merangan atnej quiniüc cos üüch maxix nüeteran; irangan najneaj, nde mejcüyiün mejawan nop alinop ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Condom Teat Jesús taw tiül cambaj Capernaum maquiiüb minipilan nej, tambüw andüyiw tiül iüt Judea. At tambüw aton tiül a iüt nonüt necamb lam Jordán. Sonongotoj quiaj xeyay nipilan majawüw nej. Quiaj taquiaach nejiw atnej mbójan marang. ");
INSERT INTO huvNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ndoj quiaj acas fariseos tambüw majawüw Teat Jesús matüntüniw manguiayiw nej majawüw cuane apmapiüng. Tasajüw sitiül nop naxey alndom macueat mintaj nej nómban. ");
INSERT INTO huvNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Quiaj tasaj nejiw Teat Jesús: ―Jow mixejchiiüts a Moisés, ¿nguineay tapiünga? ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Quiaj tapiüngüw: ―Teat Moisés tapiüng nop naxey alndom macueat mintaj nej, pero naleaing netam marangüch minawijquiaw nejiw müjndiw para mecueatayej nómban ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Quiaj Teat Jesús tasaj nejiw: ―Teat Moisés tasaj icon merangan atquiaj cos tajaw icona nadam imeajtsan. ");
INSERT INTO huvNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Pero tanomb wüx Teat Dios tarang meáwan cuajantanej, “quiaj tarang nipilan nop naxey nop najtaj”. ");
INSERT INTO huvNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","“Wüx aag ayaj nop naxey apmacueat miteat nej mimüm nej, apmaquiiüb mintaj nej. ");
INSERT INTO huvNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Quiaj apmajlüyiw nóiquian, atnej majlüyiw nop nejiw ngome ijpüw, noic omeajtsüw.” ");
INSERT INTO huvNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Pares leawa Teat Dios lamüüch mequiiübayej nejinguind ngondom müüch nejiw mecueatayej ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Condom wüx tapeayiw tiül nden, quiaj minipilan nej tatüniw manguiayiw nej aton wüx aaga les ndot mandeac quiaj. ");
INSERT INTO huvNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Quiaj Teat Jesús tasaj nejiw: ―Sitiül nop naxey apmacueat mintaj nej, ndoj apmaquiiüb alinop najtaj, aag ayaj lamajiür nisoet, cos atnej lamajiür minajtaj nej. ");
INSERT INTO huvNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","At sitiül nop najtaj apmacueat minoj nej ndoj apmaquiiüb alinop naxey, nej aton ajiür nisoet cos ajlüy atnej majiür minaxey nej ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Condom taquiiübaran niüng ajlüy nej tegüy namix nine matepeayiw Teat Jesús, majend nej omalüw. Minipilan nej taliquiaw monquiiüb namix nine, ngo mandiümüw. ");
INSERT INTO huvNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Pero wüx Teat Jesús tajaw nguineay teamarangüw, quiaj tajcüy, tasaj nejiw: ―Ijchan miünüw a namix nine niüng sajlüy, nde mepalan. Cos sitiül aljane andiüm majmel tiül micambaj Teat Dios netam marang atnej nop nine. ");
INSERT INTO huvNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Naleaing sasaj icon sitiül aljane ngo mayar sandeac atnej nop nine ayar cuajantanej masoic, ngondom majmel tiül micambaj Teat Dios ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Quiaj taxaing mapeic namix nine, tajend omalüw, tasaj nejiw: ―Mambeol icon Teat Dios ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Wüx Teat Jesús taw quiaj, quiaj ajngot nop naxey acuiür, maquieel micos nej teombas Teat Jesús, tatün manguiay: ―Teat Naxey, sajaw ique najneaj irang. Nganüy isaj xic cuane netam narang, nguineay alndom napac meáwan nüt tiül cielo ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Condom Teat Jesús tasaj nej: ―¿Neol tepiüng xique sarang najneaja? Nejinguind nipilan ngo marang najneaj, néjan quiaj Teat Dios arang najneaj. ");
INSERT INTO huvNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ique lamenguiay leaw apiüng tiül Mipoch Teat Dios niüng apiüng: “Nde mejiür minajtaj, at najtaj nde mejiür naxey; nde membiy nipilan; nde merneed; nde merndeac ngo maleaing; nde mewaiich nejinguind; netam meyar andeac miteat, mimüm” ―aj nej Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Quiaj tasaj nej aaga naxey: ―Teat, meáwan aag ayaj sayac wüx ximeaats narang nde wüx sarang quich ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Quiaj Teat Jesús tajaw nej, tajmiüc omal omeaats, tajiür nej lasta, tasaj: ―Alíünan alcuane nganaw merang. Quiür inüüb meáwan leaw almejiür. Condom imbaag ombeat iich nipilan ngo majiür; quiaj apmejlüy najneajay tiül cielo. Ndoj tewiün mendüüb xic, masey mambiyaw ic wüx cruz ―aj. ");
INSERT INTO huvNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Wüx tanguiay aag ayaj tayaag ngo majneaj, taw quiaj amix omeaats; cos ngo mandiüm mandrooch ombas meáwan leaw almajiür, cos nop nej nejiür xeyay. ");
INSERT INTO huvNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Condom Teat Jesús ndiliteay majaw minipilan nej, tasaj nejiw: ―Xowüy laél ocueajiw monjiür xeyay cuajantanej majmeliw tiül micambaj Teat Dios ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Minipilan nej mbayatoj manguiayiw andeac Teat Jesús. Quiaj nej tasaj nejiw alinomb: ―Xecualüw, xowüy laél majmeliw tiül micambaj Teat Dios leawa xowüy ayacüw omeajtsüw wüx leaw almajiürüw. ");
INSERT INTO huvNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Sapiüng más ngo maél mamong nop camello teowil nots ndiüc, ngo matnej aél ocueaj nop nejiür xeyay majmel tiül micambaj Teat Dios ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Wüx tanguiayiw aag ayaj, quiaj mbayatoj xeyay, tetünayej menguiayayej: ―Sitiül atquiaj ajlüy teat, ¿jane alndom maw asoet nej? ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Quiaj Teat Jesús tajaw nejiw, tapiüng: ―Nejinguind nipilan ngondom mawün asoet alinop, néjan Teat Dios alndom marang. Cos Teat Dios alndom marang cuajantanej ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Condom Pedro quiaj tendeac masaj Teat Jesús: ―Teat, xicona lanacueatiün meáwan leawa tajiürasan nandüjpiün ic ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Quiaj Teat Jesús tapiüng: ―Naleaing sasaj icon, ngo majlüy nejinguind jane lamacueat aniüng nej, micoj nej, michiig nej, miteat nej, mimüm nej, mintaj nej, micual nej, tengwüy miíüt nej, cos áag iün mandüüb xic mandeac xepoch; ");
INSERT INTO huvNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","jane ngo müünd majiür xeyay ningüy wǘxan aliün mapac, apmajiür aniüng nej, micoj nej, michiig nej, mimüm nej, micual nej, átan miíüt nej. Masey apmamongoch xeyay moncüy nganüy, cos alinoic nüt apmajlüy najneajay meáwan nüt tiül cielo. ");
INSERT INTO huvNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Aton altiül leaw ayaag natang nej nganüy, alinoic nüt apmarang chingüy; at altiül leaw ayaag chingüy nej nganüy, alinoic nüt apmarang natang ―aw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Wüx aliw tiül tiiüd ambüw andüyiw Jerusalén, Teat Jesús ombas nej, almandüjpiw nej minipilan nej mbayajówan, imboloj aton. Quiaj Teat Jesús tawün ninguiün quiriw ajcüwa gajpiüp (12), tapots masaj nejiw wüx nguineay apmamongoch. ");
INSERT INTO huvNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Tapiüng: ―Inguiayiün, sanasaj icon, nganüy andüyiiüts Jerusalén niüng Teat Naxey apmayacüch teowixaw montangtang miteaats maquiiüb mondüy wüx aaga poch tüünd Moisés. Quiaj apmapiüngüw mandeow, apmayacüw nej teowixaw napeay miün nipilan. ");
INSERT INTO huvNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Quiaj apmitsojow nej, apmawüjchiw nej, apmateontsüw onts ombeayiw wüx ombas nej, ndoj apmambiyaw nej. Condom wüx er nüt apmapac alinomb ―aw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Condom Jacobo maquiiüb a Juan, micual nejiw Zebedeo, tatüchiw nej masajüw: ―Teat, sandiüman merang leawa sanatüniün icueaj ―ajüw. ");
INSERT INTO huvNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Quiaj Teat Jesús tatün manguiay nejiw: ―¿Cuane indiüman naranga? ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Tasajüw nej: ―Teat, wüx lacheter merang natang nenajiüt, iich xicon chetenon niüng ijlüy, nop wüx miác, alinop wüx miquiamb ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Quiaj tasaj nejiw Teat Jesús: ―Teat, ngo mejawan cuane teametüniün. ¿Alndom icona memongochiün meáwan naél atnej xique sanamongoche? ¿Alndom icona mendeowan atnej xique sanandeowa? ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Tapiüngüw: ―Alndom ―awüw. Quiaj tasaj nejiw Teat Jesús: ―Naleaing, netam memongochiün naél atnej xique sanamongoch, netam memongochiün xeyay ngo majneaj atnej xique. ");
INSERT INTO huvNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Pero aaga ipiüngan chetemeron wüx xeác xequiamb, aag ayaj ngondom nüüch icon, cos lajlüy aljane apmüünd aag ayaj ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Wüx tanguiayiw aag ayaj algajpowüw (10) tajcüyiw majawüw Jacobo y Juan. ");
INSERT INTO huvNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Quiaj Teat Jesús tapaj nejiw miün, tasaj nejiw: ―Lamejawan nguineay arangüw monajiüt tiül meáwan cambaj. Cos arangüw apatüw atnej lamaneayiw a nipilan ajlüyiw wüx. At aton montangtang tiül nejiw ngo majiürüw lasta nejinguind. ");
INSERT INTO huvNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Pero tiül icona ngome apmajlüy atquiaj. Cos jane andiüm majiür nadam najiüt tiül icona netam marang nop nembeol icon. ");
INSERT INTO huvNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Sitiül aljane tiül icona andiüm marang natang, netam marang atnej najon mos. ");
INSERT INTO huvNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Cos Teat Naxey ngo miün mambeol nej nipilan, nej tiün mambeol nipilan, mandeow para mangüy asoet meáwan nipilan ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Condom tapeayiw Jericó. Almawüw tiül aaga cambaj quiaj Teat Jesús maquiiüb minipilan nej maquiüjpüw altegüy nipilan, quiaj nop nesomb alchetem mbeay tiiüd teatüneay, nenüt Bartimeo, micual nej Timeo. ");
INSERT INTO huvNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Wüx tanguiay aaga nesomb quiaj Teat Jesús naw tiül cambaj Nazaret, áag namong niüng ajlüy nej. Quiaj tepaj: ―¡Teat Jesús, Micual David, ijiür xic lasta! ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Xeyay nipilan taliquiaw nej mapal ombeay, pero nej tayac wüx alquiriw apaj: ―¡Teat, Micual David, ich majmiüc imal imeaats mejaw xic! ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Quiaj lembet Teat Jesús, tapiüng: ―Isajan miün ningüy ―aw. Quiaj tambüw masajüw a nesomb: ―Ich mapac imeaats, witiür, teamapaj ic ―ajüw. ");
INSERT INTO huvNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Quiaj awíichan tiüt apix nej witiówan tiüt tamb matüch niüng ajlüy Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Condom Teat Jesús tatün manguiay nej: ―¿Teat, cuane indiüm narang wüx imbasa? ―aj. Quiaj tasaj nej aaga nesomb: ―Teat, sandiüm ram xiniiüg naxom najaw ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Quiaj Teat Jesús tasaj nej: ―Nganüy quiür ijtsor, lerjneaj cos teyac imeaats wüx xic ―aj nej. Quiaj rat oniiüg nej, condom tandüüb mamb Teat Jesús tiül tiiüd. ");
INSERT INTO huvNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Wüx laliüc mapeayiw tiül Jerusalén, aliw niüng ajlüyiw cambaj Betfagé y Betania, lareng mitiüc Olivos, quiaj Teat Jesús tüüch mamb ijpüw minipilan nej, ");
INSERT INTO huvNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","tasaj: ―Quiüran tiül a nine cambaj quiün. Wüx apmepeayiün quiaj, apmexoman nop quicheech bur netsaag, nganaw müünd memas. Ichejtiün, iquiüjpan miün. ");
INSERT INTO huvNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Sitiül aljane matün manguiay icon neol terangan atquiaj, isajan cos Teat Naxey apmetam nej, ndoj apmatsoriich alinomb ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Quiaj tambüw. Wüx tapeayiw quiaj, taxomüw nop quicheech bur netsaag mbeay nden, tachejtiw. ");
INSERT INTO huvNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Altiül nipilan aliw quiaj tapiüngüw: ―¿Cua temerangana? ¿Neol techejtiün a bur quiaja? ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Condom nejiw tapiüngüw atnej landoj masaj nejiw Teat Jesús. Quiaj tüjndiw machejtiw. ");
INSERT INTO huvNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Taquiüjpüw mamb a bur niüng ajlüy Teat Jesús. Tapojchiw teopech bur apixaw nejiw. Condom quiaj Teat Jesús tajtep chetem wüx. ");
INSERT INTO huvNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Xeyay nipilan tapüjchiw tiüt apixaw nejiw tiül tiiüd, altiül tapoliw omal xiül mayacüw tiüt aton. ");
INSERT INTO huvNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Meáwan monmong ombas átan aliüc tamiün teapajüw napac: ―¡Najneajay! ¡Ich mapac omeajtsaats, cos lapeay nop niün wüx minüt Teat Dios! ");
INSERT INTO huvNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Najneajay! ¡Lapeay nop natang nenajiüt marang atnej tarang mixejchiiüts David! ¡Najneajay ajlüy Teat Dios! ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Wüx tatüchiw Jerusalén, quiaj Teat Jesús tajmel tiül aaga nadam nangaj iüm ocueajiw. Wüx landoj majaw meáwan leaw ajlüy quiaj, quiaj taw cos langwiiüts. Tamb andüy tiül cambaj Betania, aquiiüb ajcüwa gajpiüp (12) minipilan nej. ");
INSERT INTO huvNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Aw alinoic nüt tawüw tiül Betania, tandilileaw alinomb andüyiw Jerusalén. Wüx aliw tiül tiiüd, Teat Jesús tind üet. ");
INSERT INTO huvNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Miünquiájan tajaw noic owil toc neóp xeyay. Quiaj tamb majaw sitiül neóng, pero ngo maxom nicuajind, aópan alwüx, cos ngome nüt ajiür aóng toc. ");
INSERT INTO huvNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Condom Teat Jesús talic a toc: ―Nejinguind langome apmüet ióng nómban ―aj. Minipilan nej tanguiayiw aag ayaj. ");
INSERT INTO huvNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Condom wüx tapeayiw Jerusalén, quiaj Teat Jesús tajmel tiül nadam nangaj iüm mawün quiaj meáwan monüjpeay, mongalüy. Aton tapaag ninguiün mimesiw mongowüüch tomiün, at mibangüw monüüb palom. ");
INSERT INTO huvNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ngo müüch mamong nejinguind monjoy cuajantanej tiül a nadam nangaj iüm. ");
INSERT INTO huvNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Condom quiaj tapots maquiaach nejiw, tapiüng: ―¿Neol ngo leaam imeajtsan leaw apiüng tiül Mipoch Teat Dios? Apiüng: “Saniüng ajlüy niüng alndom matajcüw orar meáwan nipilan monaw palpálwüx cambaj wüx iüt”. Nganüy icona lameajchiün marang aaga nangaj iüm cam atnej niüng axotayej moneed ―aw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ajcüwa montangtang miteaats, at mondüy wüx aaga poch tüünd Moisés, wüx tanguiayiw aag ayaj tayambüw nguineay mambiyaw Teat Jesús. Laimboloj mandüyiw, cos meáwan nipilan najneaj majawüw leawa nej teamaquiaach. ");
INSERT INTO huvNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Wüx laquinüt, quiaj Teat Jesús taw tiül Jerusalén maquiiüb minipilan nej, tandüyiw Betania alinomb. ");
INSERT INTO huvNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Amb alinoic nüt wüx lajwic nüt, tamongoj alinomb niüng ajlüy aaga toc. Quiaj tajawüw nómban lawaag naw wüx mioxiich nej. ");
INSERT INTO huvNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pedro quiaj leaad omeaats nguineay Teat Jesús tasaj a toc. Quiaj tapiüng: ―Teat, ijaw a toc quiaj, áag telic, nganüy lawaag ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Condom Teat Jesús tasaj nejiw: ―Iyacan imeajtsan wüx Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Naleaing sasaj icon, jangantanej apmasaj aaga tiüc quiaj: “Iriow, indüy tiül ndec”, maj, sitiül nej ngo machiw omeaats, nej mapiüng naleaing apmarangüch leawa atün, quiaj apmarangüch leaw atün. ");
INSERT INTO huvNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Nganüy sasaj icon, wüx isajan Teat Dios meáwan leaw itüniün, sitiül ipiüngan naleaing apmeajndiün, atquiaj apmajlüy. ");
INSERT INTO huvNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Sitiül iyajcan ijcüyiün mejawan aljane, wüx itajcan orar netam mewüniün aag ayaj wüx imeajtsan nómban. Cos sitiül atquiaj apmerangan, Miteatiiüts Dios najlüy tiül cielo ngome apmayac wüx omeaats isoetiün. ");
INSERT INTO huvNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Pero sitiül icona iyacan wüx imeajtsan ijcüyiün, Miteatiiüts Dios najlüy tiül cielo, ngome apmawün wüx omeaats isoetiün ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Condom tapeayiw alinomb tiül Jerusalén. Wüx Teat Jesús teajüy tiül aaga nadam nangaj iüm, quiaj tiünüw majawüw nej montang miteaats, mondüy wüx aaga poch tüünd Moisés, at montangtang monajiüt. ");
INSERT INTO huvNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Tatüniw nej manguiayiw: ―¿Jane tüüch ic mewiün merang leawa lamerang quiaja, nguiane teyar minajiüta? ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Quiaj tasaj nejiw Teat Jesús: ―Xique aton sanatün nanguiay icon noic poch, sitiül apmesajan xic, quiaj xique aton sanasaj icon jane tüüch xic niün narang leawa teanarang. ");
INSERT INTO huvNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Jow, wüx tüüch yow nipilan aaga Juan, ¿jane tüüch nej maranga? ¿Teat Diosa, ngwüy nipilana? Nganüy isajan xic ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Quiaj tesajsajayej nejeyéjan quiaj, tapiüngüw: ―¿Cuane apmasajaatsa? Cos sitiül apmapiüngaats Teat Dios tiül cielo, quiaj apmasaj icoots: “¿Neol ngo meyariün andeaca?” ");
INSERT INTO huvNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Aton sitiül apmasajaats imiün tiül nipilan, meáwan nipilan apmajcüyiw majawüw icoots ―awüw. Imboloj mandüyiw nipilan, cos ajawüw meáwan nipilan apiüngüw aaga Juan nop nej nendeac andeac Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Quiaj tasajüw Teat Jesús: ―Ngo najawan ―awüw. Quiaj Teat Jesús tasaj nejiw: ―Ata xique ngo nasaj icon jane tüüch xic niün narang leaw teanarang ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Condom Teat Jesús tapots masaj nejiw, ngome aleaing miün. Tapiüng: ―Tajlüy nop naxey tapiür xeyay owil uva tiül micorrül nej. Tarang najneaj otüeng corrül. Condom taood tiüt tiül piedra marang niüng apmacuüücharan najün uva maw miyow. Aton tarang nop najal oleaj nine iüm nasoic torre niüng alndom macüleran cawüx majiürüch corrül. Ndoj tayac teowix nipilan a corrül quiaj. Condom nej taw, tamb andüy miünquiaj iüt. ");
INSERT INTO huvNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Wüx lamatüch a nüt mapeederan aóng uva, quiaj neneay corrül tüüch mamb mimos nej mamb majaw monrang najiüt quiaj, mayar leaw atüch nej neneay corrül. ");
INSERT INTO huvNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Nejiw tasapüw a mos quiaj, tatoliw, tüjchiw mandilil owíxan. ");
INSERT INTO huvNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Condom neneay iüt tandüy wüx müüch mamb alinop mimos nej. Átan taloxiw, talojtiw omal nej, taliquiaw nej. ");
INSERT INTO huvNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Tandüy wüx müüch mamb alinop, aag ayaj mbich tambiyaw. Ndoj tüüch mamb altigüy, átan altiül tatoliw, altiül tambiyaw nómban. ");
INSERT INTO huvNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Aag miün micual nej aliün majlüy, leaw xeyay ajiür lasta. Ndójwüx tüüch mamb micual nej. Cos apiüng a nej: “Xecual mbich ngome apmarangüw wüx nicuajind”, aw. ");
INSERT INTO huvNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Pero ajcüwa monrang najiüt quiaj wüx tajawüw aliüc aaga micual neneay iüt quiaj, tandeacüw nejeyéjan quiaj, tapiüngüw: “Aag ayaj micual neneay iüt, nej apmeneay a corrül cam. Tabaats mambiyaats, ndoj icoots apmaneayiiüts a corrül cam”, awüw. ");
INSERT INTO huvNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Quiaj tasapüw mambiyaw. Condom taxainguiw maloxiw ninguiün. ");
INSERT INTO huvNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","’¿Cuane apmarang aaga naxey neneay iüt quiaja? Apmamb mambiy ajcüwa monrang najiüt quiaj. Condom apmayamb alinoic ajlüy monrang najiüt, mayac teowixaw aaga corrül. ");
INSERT INTO huvNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","’¿Neol, nganaw meteowan leaw apiüng tiül Mipoch Teat Dios? Apiüng: Aaga piedra leaw taloxiw ninguiün monrang iüm, nganüy laíün marang xeyay netam piedra tiül oxing iüm. ");
INSERT INTO huvNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Teat Dios nerang aag ayaj, ajawaats aag ayaj xeyay najneaj ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Condom ajcüwa monajiüt tandiümüw masapüw Teat Jesús, cos tayajcüw aaga tandeac quiaj tandeac andüy wüx ombasüw. Pero naleaing cos timboloj mandüyiw nipilan, quiaj tacueatiw nej, tawüw quiaj. ");
INSERT INTO huvNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Condom tüjchiw mamb acas fariseos at aton acas minipilan Herodes niüng ajlüy Teat Jesús, mayambüw nguineay masapüw nej wüx aleaic mandeac. ");
INSERT INTO huvNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Quiaj tiünüw masajüw nej: ―Teat, sajawan ique indeac naleaing, ngo mewaiich, ngo mermbol mendüy nejinguind. At aton ngo mepiüng wüx jane netam, jane ngo metam. Ique iquiaach naleaing wüx Teat Dios. Nganüy isaj xicon, ¿naleaingue netam mangüyaran leaw atün a César, ngwangwüy ngo metama? ¿Mangüyiiütsa, ngwüy ngo mangüyiiütsa? ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Pero Teat Jesús lamajaw nguineay mindeac ombeayiw ajcüwa nipilan quiaj, quiaj tasaj nejiw: ―¿Neol tendiüman mejawan majüic cuane sanandeaca? Ich miün noic tomiün najaw ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Quiaj tüjchiw. Almajaw, quiaj Teat Jesús tatün manguiay nejiw: ―¿Jane mitey alwüx a tomiün cama, jane minüt alwüxe? ―aj nejiw. Quiaj tasajüw nej: ―César ―ajüw. ");
INSERT INTO huvNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Teat Jesús tasaj nejiw: ―Ijchan a César ocueaj César, aton ijchan Teat Dios ocueaj Teat Dios ―aj nejiw. Quiaj mbayatoj manguiayiw andeac nej. ");
INSERT INTO huvNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Condom tapeayiw acas saduceos niüng ajlüy Teat Jesús. Ajcüw ayaj noic ajlüy nipilan apiüngüw mondeow langome apmapacüw alinomb. Tatüniw nej manguiayiw: ");
INSERT INTO huvNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―Teat, Moisés tarang tiül minawiig nej, tapiüng sitiül nop naxey mandeow, macül mintaj nej lemben omal, pero ngo majiürüw micualüw nejiw, quiaj michiig nej netam mengoch owix aweaag aaga lemben omal quiaj, para alndom majlüy micual micoj nej. ");
INSERT INTO huvNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Pues tajlüy ayaíw monxey nop necual nejiw. Aaga natang nacojaran tengoch owix, ndoj tandeow, nganaw majiürüw micualüw nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Condom quiaj michiig nej tangoch owix aweaag aaga najtaj lemben omal quiaj. Aton tandeow a naxey wüx nganaw majiürüw micualüw nejiw. Atquiaj tajlüy aton amb arojpüw. ");
INSERT INTO huvNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Atquiaj tengoch owixaw maquiüjpüw aaga najtaj quiaj meáwan aaga ayaíw monxey quiaj. Nejinguind tiül nejiw ngo majiürüw micualüw nejiw. Ndójwüx nejay a najtaj tandeow. ");
INSERT INTO huvNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","¿Jow wüx apmapacaran alinomb, jane tiül nejiw apmaquiiüb a najtaj quiaja? Cos ajcüwa ayaíw monxey quiaj tengoch owixaw maquiüjpüw ―ajüw. ");
INSERT INTO huvNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Quiaj tasaj nejiw Teat Jesús: ―Icona ngo mejawan cuane wüx teamendeacan quiaj, cos ngo mejawan cuane ajlüy tiül Mipoch Teat Dios. Aton ngo mejawan cuane alndom marang Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Pues wüx apmapacaran alinomb ngome apmajlüy mongoch owix, cos apmajlüyaran noic miün atnej ajcüw ángel najlüy tiül cielo. ");
INSERT INTO huvNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Nganüy aaga itüniün menguiayiün wüx apacaran tiül mondeow, ¿neol ngo meteowan tiül aaga poch tüünd Moisés nguineay tapiüng Teat Dios wüx tandeac imiün tiül noic owil nine xiül teandaab? Cos tapiüng: “Xique Teat Dios, Midios Abraham, Midios Isaac, at Midios Jacob, ajcüw tajlüyiw tanomb”. ");
INSERT INTO huvNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Teat Dios ngome Midiosüw mondeow, nej Midiosüw jane almapac. Icona xeyay ngo mejawan cuane teamepiüngan ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Tiün niüng ajlüy nej nop naw tiül ajcüwa mondüy wüx aaga poch tüünd Moisés cos tanguiay wüx teandeacndeacüw. Tajaw Teat Jesús tangoch masaj nejiw najneaj. Quiaj nej aton tatün manguiay noic, tasaj: ―¿Ngün tiül aaga poch tüünd Moisés más xeyay nembeate? ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Quiaj Teat Jesús tasaj nej: ―Aaga leaw najntsop wüx atam apiüng: “Inguiayiün cambaj Israel, áagan nop Dios ajlüy aag ayaj Teat Dios Midiosaats. ");
INSERT INTO huvNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Netam mendiüman Teat Dios con imeajtsan, con miespiritujan, con mifisan; aton netam mendiüman con meáwan ipacan ijiüran”, aw. Aag ayaj a poch leaw alwüx atam. ");
INSERT INTO huvNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Alinoic aton landiüm matnej, apiüng: “Netam mejiüran lasta nop alinop atnej ijiürayon lasta icoyónan quiaj”, aw. Ngo majlüy alinoic poch majntsop wüx ajcüw ayaj ―aj nej Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Quiaj aaga naxey nendüy wüx aaga poch tüünd Moisés tasaj nej: ―Teat, naleaing ipiüng. Cos aag ipiüng quiaj naleaing áagan nop Dios almajlüy, ngo majlüy alinop. ");
INSERT INTO huvNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","At aag ipiüng quiaj nguineay netam mandiümaats Teat Dios con omeajtsaats, con mifisaats, con miespiritujaats, aton con meáwan apacaats ajiüraats. At aton netam majiüraats lasta nop alinop atnej ajiürayoots lasta icoyóotsan quiaj. Meáwan aag ayaj xeyay nembeat ngo matnej meáwan nichech najmel müünd Teat Dios, ngo matnej meáwan nichech nambelaran wüx artül ―aj. ");
INSERT INTO huvNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Wüx Teat Jesús tajaw aaga naxey tandeac naleaing najneajay, quiaj tasaj: ―Laliüc metüch mejmel tiül micambaj Teat Dios ―aj nej. Ndoj nejinguind ngome aleaic tandiüm matün manguiay nej. ");
INSERT INTO huvNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Teat Jesús aliün tiül nadam nangaj iüm, tenguial aquiaach, tapiüng: ―¿Neol ajcüwa mondüy wüx aaga poch tüünd Moisés tapiüngüw wüx aaga Cristo, David mixeech neje? ");
INSERT INTO huvNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Cos aaga Nangaj Espíritu ocueaj Teat Dios tayac wüx omeaats David mapiüng: Teat Dios tasaj a Teat Naxey: “Cheter ningüy amb wüx xeác leaw ndoj nayac moncüy majaw ic maquiejliw micosüw nejiw timbas.” ");
INSERT INTO huvNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","¿Nguineay alndom mapiüngüw David mixeech aaga Cristo? Cos nejay David tapiüng “Teat Naxey” ―aw Teat Jesús. Ajcüwa xeyay nipilan leaw tajlüyiw quiaj, tapac omeajtsüw manguiayiw aquiaach. ");
INSERT INTO huvNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Teat Jesús tasaj nejiw tíülan aquiaach, tapiüng: ―Ijawan wüx ajcüwa mondüy wüx aaga poch tüünd Moisés, cos xowüy andiümüw majüyjüyiw tiül cambaj asoijquiw najal apixaw para matepeayaranüw cos áag teamayambüw. ");
INSERT INTO huvNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Aton xowüy andiümüw chetemoj niüng alndom malombaranüw tiül sinagoga. At aton wüx ajlüy monet ayambüw chetemoj niüng ajlüy aaga nerang nangos nüt. ");
INSERT INTO huvNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Nejiw anojtiw aniüngüw monlemben omal montaj, ndoj andiümüw maxotüw aaga ngo majneaj arangüw quiaj, atajcüw orar xeyay majaw nejiw nipilan, pero ombeayíwan. Nejiw xeyay ngo majneaj apmamongochiw alinoic nüt ―aw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Noic nüt Teat Jesús alchetem tiül aaga nadam nangaj iüm niüng ajlüy iquial nichech, teamajaw nipilan nguineay teamayacüw tomiün tiül. Tajaw xeyay nipilan monjiür, teamayacüw xeyay tomiün. ");
INSERT INTO huvNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ndoj tapeay quiaj nop lemben omal najtaj ngo majiür, mayac ijquiaw nine tomiün ichech nej, aag ayaj ngo membeat. ");
INSERT INTO huvNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Quiaj Teat Jesús tapaj minipilan nej masaj: ―Naleaing sasaj icon aaga lemben omal najtaj quiaj alwüx ayac, ngo matnej meáwan leaw lamayacüw ichechiw nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Cos meáwan lamayacüw nenaw ocueajiw, pero aaga pobre lemben omal najtaj quiaj, lamayac meáwan leaw almajiür, masey ndoj ngo majiür ombeat üet nej ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Wüx Teat Jesús taw tiül aaga nadam nangaj iüm, quiaj nop minipilan nej tasaj nej: ―¡Teat, ijaw ajcüwa nadamdam piedra quiaj! ¡Najneajay tarangüch marang nadamdam iüm quiaj! ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Quiaj Teat Jesús tasaj nej: ―Nganüy teamejaw ajcüwa nadamdam iüm quiaj, pero alinoic nüt ngome apmajlüy noic piedra wüx alinoic, cos meáwan ayaj apmümb jarriüm ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ndoj tambüw andüyiw wüx mitiüc Olivos najlüy lareng nadam nangaj iüm. Teat Jesús lachetej; quiaj Pedro, Jacobo, Juan, at Andrés tatüniw manguiayiw nej wüx tajlüyiw nejíwan quiaj, tasajüw: ");
INSERT INTO huvNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―Teat, isaj xicon ngow apmajlüy aag ipiüng wüx apjarriüm nadamdam iüm quiaj. ¿Cuane apmajlüy sanajawan wüx laliüc majlüy meáwan leawa ipiüng quiaja? ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Quiaj tasaj nejiw Teat Jesús: ―Ijawan wüx, nde mawaiich icon nejinguind. ");
INSERT INTO huvNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Cos xeyay nipilan aliücüw miün, apmandeacüw wüx xique, apmapiüngüw: “Xique aaga Cristo”, apmawüw. Quiaj apmawaijchaw xeyay nipilan. ");
INSERT INTO huvNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Aton masey wüx apmenguiayiün anderac wüx moncüy, at apmapiüngüw laliüc majlüy monbiyay, nde mbayameron cos atquiaj netam majlüy, pero nganaw mümb minüt a iüt cam. ");
INSERT INTO huvNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Cos monaw tiül noic iüt apmembiyayej maquiüjpüw monaw tiül alinoic iüt. At monaw tiül noic cambaj apmembiyayej maquiiüjpüw monaw alinoic cambaj. Aton apmajlang nadamdam ateam nguiajantanej. Apmajlüy xeyay lop, xeyay moncüy. Meáwan aaga ayaj les tamelich ajlüy ngo majneaj, ajlüy necoy. ");
INSERT INTO huvNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Icona netam mejawan wüx aag ayaj, cos apmayacüw icon teowixaw monajiüt, apmejwüchiün tiül sinagogas. Aton apmejpajan niüng ajlüyiw natang monajiüt cos iyariün sandeac. Quiaj alndom mesajan nejiw wüx xique manguiayiw aton. ");
INSERT INTO huvNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Wüx nganaw mümb minüt a iüt cam netam masoic meáwan nipilan wüx iüt wüx aaga najneajay nanderac cam, manguiayiw nguineay alndom maw nisoet. ");
INSERT INTO huvNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Wüx apmaquiüjpüw icon mayacüw icon teowixaw monajiüt, nde meyamyamban imeajtsan wüx cuane apmepiüngan, cos apmeajndiün leaw apmepiüngan quiájan. Nangaj Espíritu ocueaj Teat Dios apmambeol icon mendeacan. ");
INSERT INTO huvNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Nacojaran apmayac teowixaw monajiüt nachiigueran; at nachiigueran apmayac teowixaw monajiüt nacojaran mandeow. Aton nateataran apmayac teowixaw monajiüt nacualaran, at nacualaran apmayac teowixaw monajiüt nateataran, namümaran, mandeowüw. ");
INSERT INTO huvNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Meáwan nipilan apmajcüyiw majawüw icon ajcan iyariün sandeac. Pero naleaing jane apmaíüc wüx meáwan aag ayaj, apmaw tiül naél. ");
INSERT INTO huvNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Tanomb aaga nendeac andeac Teat Dios nenüt Daniel tarang wüx nawiig, tapiüng wüx aaga xeyay ngo majneaj leaw apmüüch ndrom ombas cambaj. Wüx ijawan aag ayaj lajlüy niüng ngo metam majlüy (jane teamateow ich mayamb omeaats majaw cuane wüx apiüng aag ayaj), quiaj jane ajlüy tiül iüt Judea ich mecuiür andüy wüx tiüc. ");
INSERT INTO huvNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Tiül aaga nüt quiaj jane ngo majlüy tiül iüm, nde majmel tiül iüm mawün leaw ajiür quiaj. ");
INSERT INTO huvNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Sitiül aljane altiül corrül, aton nde mandilil andüy aniüng nej mayar apix nej. ");
INSERT INTO huvNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Apmaél ocueajiw a montaj alteomeajtsüw micualüw nejiw, at leawa nejiür nine teachech wüx aaga nüt quiaj! ");
INSERT INTO huvNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Itüniün ocueaj Teat Dios nde müüch icon mercuiürran wüx nüt ajlüy naquind, ");
INSERT INTO huvNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Cos aaga nüt quiaj apmamongocharan xeyay ngo majneaj, leawa nómban ngomeaag ajlüy ajan wüx Teat Dios tarang a iüt cam, aton ngome apmajlüy alinomb. ");
INSERT INTO huvNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Sitiül Teat Dios ngo mapal aaga ngo majneaj quiaj, nejinguind ngome apmapac. Cos Teat Dios xeyay ajiür lasta minipilan nej leaw nej lamarriiüd, áag tandondoch najen aaga nüt ajlüy ngo majneaj quiaj. ");
INSERT INTO huvNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Sitiül aljane apmasaj icon: “Jogüy a Cristo”, maw; tengwüy mapiüng: “Joyaj a Cristo”, maw, nde meyariün andeac nej. ");
INSERT INTO huvNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Cos aliücüw xeyay monwaiich; altiül apmapiüngüw cristo nejiw. Altiül apmapiüngüw mondeac andeac Teat Dios nejiw; apmarangüw ateócan mambaijchaw nipilan, mawaijchaw para mayarich andeacüw nejiw. At altiül minipilan Teat Dios leawa nej lamarriiüd apmawaiicharanüw aton sitiül ndot alndom. ");
INSERT INTO huvNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Pero ich leaam imeajtsan, xique lanasaj icon nde nganüy para alndom mejawan nguineay apmajlüy alinoic nüt. ");
INSERT INTO huvNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","’Wüx aaga nüt quiaj, wüx apmamong meáwan aaga xeyay ngo majneaj quiaj, nüt lango merraj átan a caaw lango merraj. ");
INSERT INTO huvNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","At ocas apmajmiücüw imiün tiül cielo, meáwan leaw almajlüy cawüx apmajüyjüy. ");
INSERT INTO huvNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Condom quiaj apmajaraw aaga Teat Naxey aliüc amb tiül oic xeyay najneajay ajlüy, nelitlit ombas. ");
INSERT INTO huvNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Quiaj apmüüch mambüw miángeles nej macanchichaw meáwan minipilan nej wüx iüt, imiün nonüt, noleat, calüy, cawac. ");
INSERT INTO huvNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Inguiayiün leaw sanasaj icon wüx nguineay arang a toc: Cos wüx latsatsaw mipüüig nej mayac aóp, quiaj ajüic laliüc matüch a nüt arraar. ");
INSERT INTO huvNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Atquiaj icona wüx apmejawan lajlüy aaga lanasaj icon quiaj, quiaj apmejawan laliüc matüch a nüt mapeay Teat Naxey. ");
INSERT INTO huvNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Naleaing sasaj icon, meáwan aag ayaj apmajlüy wǘxan aliün mapac nipilan ningüy wüx iüt. ");
INSERT INTO huvNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Masey iüt, at a cielo apndrom ombas, xepoch nómban ngondom ndrom ombas. ");
INSERT INTO huvNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Wüx aaga nüt, aaga ores quiaj, nejinguind ngo majaw, at ajcüwa ángel najlüy tiül cielo, at Micual Teat Dios ngo majaw ngow. Néjan quiaj Teat Dios ajaw. ");
INSERT INTO huvNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Netam mepacan nde memeayiün, icüliün, itajcan orar cos ngo mejawan ngow apmajlüy aag ayaj. ");
INSERT INTO huvNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Cos aag ayaj atnej arang nop naxey wüx amb majüy miünquiaj. Wǘxan nganaw maw aniüng nej apmapaj miünüw mimos nej, müüch minajiütüw anopnopoj. Aton nejiür ombeay nden apmasaj nde mameay. ");
INSERT INTO huvNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","At icona, icüliün, nde memeayiün, cos ngo mejawan ngow apmapeay neneay nden; sitiül apmapeay andüy wüx quinüt, sitiül pinawan ongwiiüts, sitiül andüy wüx arraw, tengwüy ümb arraw; ");
INSERT INTO huvNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","nganandot maxom icon almemeayiün wüx nej apmapeay. ");
INSERT INTO huvNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Leaw lanasaj icon, aton sasaj meáwan nipilan: Icüliün xic, nde memeayiün ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Alíünan ic nüt wüx nganaw matüch nangos nüt pascua wüx üeteran pan ngo majmel levadura. Ajcüwa montangtang miteaats, at mondüy wüx aaga poch tüünd Moisés, tayambüw nguineay mawaijchaw para masapüw Teat Jesús mambiyaw. ");
INSERT INTO huvNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Pero tapiüngüw: ―Ngondom marangaats aag ayaj wüx nangos nüt, cos nipilan apmajcüyiw, apmajlüy xeyay monyaingyaing ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Wüx Teat Jesús altiül cambaj Betania, teaüetiw al aniüng Simón, aag laíün wüx axom nej noic ngo majneaj necoy nasoic lepra. Quiaj tajngot nop najtaj ajamiün najmboc angan aceite, nenüt nardo nembeat xeyay, chipiow nop nine iquial narangüch atnej limet nenüt alabastro. Quiaj tajmbaj apal, tateng wüx omal Teat Jesús aaga najmboc angan aceite quiaj. ");
INSERT INTO huvNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Altiül leaw aliw quiaj tajcüyiw, nejeyéjan quiaj tapiüngüw: ―¿Neol tandrooch ombas aaga najmboc angan aceite quiaja? ");
INSERT INTO huvNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Jondot majnap apmambeat arej acoic miow (300) tomiün nenüt denario, mambeolaran nipilan leaw ngo majiür ―awüw. Tandeacndeacüw wüx ombas a najtaj. ");
INSERT INTO huvNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Quiaj Teat Jesús tasaj nejiw: ―Icueatiün, ¿neol tapots mesajsajana? Cos nej tarang najneaj wüx ximbas. ");
INSERT INTO huvNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Nipilan leaw ngo majiür aliw ningüy mequiüjpan, alndom membeolan wüx indiüman; nganüy a xique ngome sanajlüy ningüy naquiiüb icon meáwan nüt. ");
INSERT INTO huvNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Aaga najtaj cam lamarang leaw alndom marang; cos wüx nganaw nandeow lamayac aag ayaj wüx ximbas atnej arangüch wüx amiüraad mondeow. ");
INSERT INTO huvNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Naleaing sasaj icon, nguiajantanej wüx aaga iüt cam niüng apmanderac xepoch, quiaj apmanderac wüx aaga najtaj cam nguineay tarang, para alndom leaam omeaatsaran wüx nej ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Condom Judas Iscariote, nop tiül ajcüwa gajpiüp (12) minipilan Teat Jesús, tamb majaw ajcüw montangtang miteaats mandeacüw nguineay apmayac Teat Jesús teowixaw nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Camüm manguiayiw aag ayaj, quiaj tapac omeajtsüw, tasajüw apmüjchiw nej tomiün. Quiaj tapots mayamb nguineay alndom mayac teowixaw nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Wüx lamatüch aaga nangos nüt wüx üeteran pan ngo majmel levadura, wüx ambiyaran sap marang nichech wüx pascua, quiaj minipilan Teat Jesús tatüniw manguiayiw nej: ―¿Nguiane indiüm, Teat, namban natajcan majneaj niüng apmatsambaats a sap wüx pascua? ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Quiaj Teat Jesús tüüch mambüw ijpüw minipilan nej, tasaj: ―Quiüran tiül cambaj. Quiaj apmexoman nop naxey ajoy nop ngan yow, indüjpiün mamb. ");
INSERT INTO huvNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Niüng apmajmel a naxey, quiaj apmesajan neneay iüm: “Atcüy apiüng Teat Naxey: ¿Nguiane ajlüy niüng sanetiün wüx pascua naquiiüb xenipilana?” apmerajan. ");
INSERT INTO huvNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Quiaj apmatiib icueajiün noic nadam teomeaats iüm cawüx amb ijpüw iüm, latajcüch majneaj. Andüy quiaj apmeyacan üetiiüts ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Quiaj tambüw ijpüw. Wüx tapeayiw tiül cambaj Jerusalén, quiaj taxomüw meáwan atnej Teat Jesús lamasaj nejiw. Quiaj tayacüw leawa apmüetiw wüx nangos nüt pascua. ");
INSERT INTO huvNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Wüx langwiiüts, quiaj tapeay Teat Jesús maquiiüb gajpiüp (12) minipilan nej. ");
INSERT INTO huvNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Wüx alchetemoj teaüetiw, quiaj tapiüng Teat Jesús: ―Naleaing sasaj icon, nop tiül icona leawa teasüet anaag apmayac xic teowixaw monajiüt ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Quiaj tamix omeajtsüw, tatüniw manguiayiw Teat Jesús anopnopoj. Nop tapiüng: ―¿Jane, ngwa xique? ―aw. Alinop tapiüng: ―¿Ngwa xique? ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Quiaj tasaj nejiw Teat Jesús: ―Aag ayaj nop naw tiül aaga gajpiüp ijlüyiün, áag tenguial macheniiüts pan tiül polat nóiquian maquiüjpaats. ");
INSERT INTO huvNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Naleaing Teat Naxey apmamongoch atnej apiüng tiül Mipoch Teat Dios, ¡pero aaga naxey apmeyac nej teowixaw monajiüt xeyay ngo majneaj apmamongoch, más najneaj ngo wijquiam! ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Wüx tenguialeámban üetiw, quiaj Teat Jesús taxaing a pan, tüüch gracias Teat Dios, ndoj tambaag müüch nejiw, tapiüng: ―Ixainguiün itean, cos aag agüy xecuerpo ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Condom tachipich noic vas miyow uva, tüüch gracias Teat Dios. Ndoj tüüch nejiw manganeowüw. ");
INSERT INTO huvNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Tapiüng: ―Aag agüy xequiej, ajüiquich wüx aaga jayats poch lamayac Teat Dios, cos xequiej apmajünch tiüt mawün wüx asoet xeyay nipilan. ");
INSERT INTO huvNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Naleaing sasaj icon xique lango nanganeow miyow uva; pero alinoic nüt sananganeow jayats miyow uva tiül micambaj Teat Dios ―aw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Wüx landoj matajcüw cantar noic himno, quiaj tambüw andüyiw wüx mitiüc Olivos. ");
INSERT INTO huvNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Almambüw, quiaj Teat Jesús tasaj nejiw: ―Meáwan icona apmecueatiün xic aaga ongwiiüts cam, atnej apiüng tiül Mipoch Teat Dios: “Sanambiy a nejiür sap, quiaj apndajrriüm meáwan misap nej”, aw. ");
INSERT INTO huvNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Wüx sanapac tiül mondeow, quiaj sanamb tiül Galilea ombas xic, teoj icon ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Quiaj tasaj nej a Pedro: ―Teat, masey meáwan macueatiw ic, xique ngwüy ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Quiaj tasaj nej Teat Jesús: ―Naleaing sasaj ic Pedro, aaga ongwiiüts cam, wüx nganaw mepaj ijquiaw ombeay a gallo, ique lamepiüng arojmbüw ngo mejaw jane xic ―aj nej Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pedro tandeac napac, tapiüng: ―Masey sanandeow naquiiüb ic, xique ngome sanapiüng ngo najaw jane ic ―aw. Aton atquiaj tapiüngüw meáwan minipilan nej. ");
INSERT INTO huvNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Condom tapeayiw tiül Getsemaní. Quiaj Teat Jesús tasaj minipilan nej: ―Cheteron ningüy; xique sanamb nataag orar ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Taquiiüb mamb a Pedro, Jacobo, at a Juan. Quiaj tapots amix omeaats, tayaag xeyay ngo majneaj. ");
INSERT INTO huvNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Tasaj nejiw: ―Xeyay amix ximeaats, sayaag atnej teasandeow. Icüliün xic ningüy, nde memeayiün ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Condom Teat Jesús tamb quiríwan iün majüy, quiaj mejquiet tiüt ataag orar. Tatün ocueaj Teat Dios sitiül alndom mawün nej wüx meáwan leawa apmamongoch. ");
INSERT INTO huvNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Tapiüng: ―Teat, ngo majlüy nicuajind leawa ique ngondom merang. Sandiüm mewün xic wüx aaga nangaag naél leawa laliüc namongoch. Pero naleaing Teat, nde merang sandíüman xique, irang atnej ique indiüm ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Condom tandilil majaw nejiw. Almapeay quiaj tajaw lameayiw. Quiaj tasaj a Pedro: ―Simón, ¿lermeaya? ¿Neol ngondom meíüc noic ores? ");
INSERT INTO huvNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Nde memeayiün, iyamban Teat Dios, nde matüch icon nimeech. Masey tiül imeajtsan indiüman mendüjpiün Teat Dios, pero naleaing icona ngo meiücan wüx, nind imeayiün ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Condom tandüy quiaj alinomb masaj Teat Dios atnej landoj mandeac. ");
INSERT INTO huvNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Wüx tandilil alinomb niüng ajlüyiw nejiw, taxom nejiw alinomb almameayiw, cos xeyay laínd ameayiw. Quiaj lango majawüw cuane apmasajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Wüx tapeay amb arojmbüw, quiaj tasaj nejiw: ―¿Neol aliün memeayiüna, tenguial ixojtana? Landoj, lamatüch a ores. Nganüy apmayacüch a Teat Naxey teowixaw monrang ngo majneaj. ");
INSERT INTO huvNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Witiüron, tabaats, lapeay aaga apmetiib xic ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Tenguialeámban andeac Teat Jesús, quiaj ajngot a Judas, áag tajlüy tiül a gajpiüp (12). Aquiiüb miün xeyay nipilan, ajamiünüw espada, at xiül; üüch nejiw mambüw ajcüwa montangtang miteaats, mondüy wüx aaga poch tüünd Moisés, at montangtang monajiüt tiül nadam nangaj iüm. ");
INSERT INTO huvNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Aaga Judas lamasaj nejiw nguineay apmatiib majüiquich ngün apmasapüw, cos lamapiüng: ―Áag sanacheech mimboy nej, aag ayaj isapan, iquiüjpan nde mecuiür ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Wǘxan apeay aleáingan niüng ajlüy Teat Jesús, tapiüng: ―Teat ―aw. Andǘüban macheech mimboy nej. ");
INSERT INTO huvNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Quiaj tasapüw Teat Jesús, taquiüjpüw mamb. ");
INSERT INTO huvNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Naleaing nop minipilan Teat Jesús tasoond miespada nej, quiaj tandooig nop olaag mimos minatang miteaats. ");
INSERT INTO huvNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Teat Jesús tasaj ajcüwa nipilan: ―¿Cuane ijmbichan espadas y xiül wüx isapan xique? ¿Jowa xique, need xic, ngwüy neola? ");
INSERT INTO huvNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Meáwan nüt tajlüyiüs niüng ijluyiün naquiaach icon tiül nadam nangaj iüm, icona ngo mesapan xic. Pero naleaing atcüy apmajlüy, cos netam majlüy atnej lamapiüng tiül Mipoch Teat Dios ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Quiaj tacueatiw nej meáwan minipilan nej, tecuiürrüw. ");
INSERT INTO huvNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Nop nench tandüüb mamb Teat Jesús, awinchay tiül noic püy, tasapüw nej. ");
INSERT INTO huvNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Quiaj nej sojndiüt tiül apix nej, tecuiür miotáagan. ");
INSERT INTO huvNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Condom taquiüjpüw mamb Teat Jesús niüng ajlüy minatang miteaats. Quiaj canchiütoj meáwan montangtang miteaats, at montangtang monajiüt tiül nadam nangaj iüm, aton mondüy wüx aaga poch tüünd Moisés. ");
INSERT INTO huvNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ata Pedro aton tandüüb Teat Jesús miünquiájan ajngot. Tamb tatüch tiül püjchiün mbeay ombiüm minatang miteaats. Quiaj tsotot maquiüjpüw monjiür aniüng miteaats, metsantsayej mbeay biümb. ");
INSERT INTO huvNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ajcüwa montangtang miteaats at meáwan monajiüt tiül judíos tayambüw acas nipilan mapiüngüw nóiquian cuane ngo majneaj tandeac Teat Jesús, para mayacüw asoet mandeow, pero ngo maxomüw. ");
INSERT INTO huvNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Cos xeyayiw tandeacüw ngo maleaing wüx ombas nej, palpálwüx andeacüw, ngome nóiquian. ");
INSERT INTO huvNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Altiül witiütoj tewüyayej wüx mawaijchaw, tapiüngüw: ");
INSERT INTO huvNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―Xicona tanguiayasan wüx tandeac mapiüng nej apmajarrich aaga nadam nangaj iüm leaw nipilan tarangüw, ndoj wüx er nüt apmawitich alinop nangaj iüm, ngome narangüch naag owixaran. Atquiaj tandeac aaga naxey quiaj ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Pero ngome nóiquian tandeacüw mayacüw asoet. ");
INSERT INTO huvNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Condom aaga minatang miteaats witiüt lombom pinawan, matün manguiay Teat Jesús. Tasaj: ―¿Neol ngo merndeaca? ¿Cuane aag teamandeacüw wüx imbas quiaja? ―aj. ");
INSERT INTO huvNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Teat Jesús ndijchiówan, ngo masaj nej nicuajind. Quiaj tatün manguiay alinomb, tasaj: ―¿Ique aaga Cristo, micual ic Teat Diosa? ―aj. ");
INSERT INTO huvNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Quiaj tasaj nej Teat Jesús: ―Xícam aag ipiüng quiaj. Apmejawan xic salcheten amb wüx miác Teat Dios. Cos xique aaga Teat Naxey, apmejawan wüx saliüc ximiün tiül cielo samb tiül oic ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Quiaj minatang miteaats tachiüt apix nej, xeyay tajcüy, tapiüng: ―¿Cuane tenguialeámban macüliiüts manguiayiiütsa? ");
INSERT INTO huvNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Nganüy icona lamenguiayiün meáwan aaga ngo majneaj lamandeac quiaj, cos andeac atnej Teat Dios nej. ¿Cuane ajiür menguiayiüna? ―aw. Quiaj meáwan nejiw tapiüngüw netam mandeow. ");
INSERT INTO huvNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Altiül tapots mateontsüw onts ombeayiw nejiw wüx ombas nej. Aton tatsajcüw oniiüg nej, tatoliw. Condom tasajüw: ―¡Nganüy isüet jane netol ic! ―ajüw. At ajcüwa monajiüt quiaj taleambüw nej aton. ");
INSERT INTO huvNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pedro aliün quiaj tiül püjchiün, quiaj apeay niüng ajlüy nej nop nüx nerang minajiüt minatang miteaats. ");
INSERT INTO huvNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Wüx tajaw a Pedro teatsantsüy mbeay biümb, quiaj lombot mapiür majaw, tasaj: ―Ique aton tequiiüb aaga Jesús naw Nazaret ―aj. ");
INSERT INTO huvNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Quiaj a Pedro tapiüng: ―Ngwüy, ngo najaw jane, ngo najaw cuane leaw ipiüng quiaj ―aw. Ndoj taw quiaj andüy mbeay nden, quiaj tepaj a gallo. ");
INSERT INTO huvNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Aaga nüx tajaw nej alinomb. Ndoj tapots masaj nipilan alquiaj, tapiüng: ―Aaga naxey quiaj nop naw tiül nejiw ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pedro quiaj tawaiich alinomb. Ndoj ajoy miün quiriw ores, ajcüwa nipilan aliw quiaj tasajüw nej alinomb: ―Naleaing ique nop naw tiül nejiw, cos indeac atnej andeacüw monaw Galilea ―ajüw. ");
INSERT INTO huvNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Quiaj a Pedro tapots mapiüng ngo maleaing aag ayaj, tapaj minüt Teat Dios, tapiüng: ―¡Por dios, ngo najaw jane aaga naxey temepiüngan quiaj! ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Aaga gallo tepaj amb ijmbüw apaj. Quiaj a Pedro leaad omeaats leaw Teat Jesús lamasaj nej. Cos tasaj nej: “Wǘxan nganaw mepaj ijmbüw apaj a gallo, ique lamepiüng arojmbüw ngo mejaw jane xic”, aj nej. Wüx leaad omeaats aag ayaj, quiaj tapots ajiünts. ");
INSERT INTO huvNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Wüx lachiüjmbaw, quiaj ajcüwa montangtang miteaats canchiütoj maquiüjpüw montangtang monajiüt tiül nadam nangaj iüm, at mondüy wüx aaga poch tüünd Moisés, maquiüjpüw alacas monajiüt. Quiaj taquiüjpüw mamb Teat Jesús netsaag, mayacüw teowix Pilato. ");
INSERT INTO huvNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Aaga Pilato tatün nej manguiay: ―¿Naleaingue, ique aaga minatang nenajiüt ocueaj cambaj Israele? ―aj. Quiaj tasaj nej Teat Jesús: ―Atnej ipiüng quiaj ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ajcüwa montangtang miteaats tayacüw nej xeyay asoet. ");
INSERT INTO huvNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Condom Pilato tatün nej manguiay alinomb, tasaj: ―¿Neol ngo merndeaca? Ijaw nguineay teamayacüw isoet xeyay ―aj. ");
INSERT INTO huvNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Teat Jesús ngo masaj nej nicuajind, quiaj a Pilato mbayat majaw nej. ");
INSERT INTO huvNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Aaga Pilato quiaj ajlüyay wüx matsambiich nop najlüy tiül manchiüc wüx nangos nüt, leaw nipilan apmatüniw tsajmbiüm. ");
INSERT INTO huvNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Aliw tiül manchiüc acas nipilan cos tambiyaw nipilan wüx tajcüyiw maquiüjpüw monajiüt. Altiül nop nenüt Barrabás. ");
INSERT INTO huvNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Xeyay nipilan tambüw majawüw a Pilato. Tapots matüniw marang atnej mbójan marang. ");
INSERT INTO huvNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Quiaj tasaj nejiw a Pilato: ―¿Cuane indiümana? ¿Ngwüy, sanatsambiich minatang nenajiüt icueajiüna? ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Cos lamajaw ajcüwa montangtang miteaats tayacüw teowix nej a Teat Jesús, ajcan ngo mandiümüw majawüw mandüüb nej xeyay nipilan. ");
INSERT INTO huvNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ajcüwa montangtang miteaats taquiajchiw ombeay nipilan mapiüngüw tsajmbiüm Barrabás. ");
INSERT INTO huvNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Quiaj a Pilato tatün manguiay alinomb: ―¿Cuane indiüman mejawan narang wüx aag ipiüngan minatang nenajiüt icueajiüna? ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Nejiw tepajüw napac: ―¡Ich mandeow wüx cruz! ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Quiaj tasaj nejiw a Pilato: ―¿Cuane asoet ajiür? ―aj nejiw. Meáwan nipilan tepajüw alinomb: ―¡Ich mandeow wüx cruz! ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Cos aaga Pilato tandiüm majneaj aweaag meáwan nipilan, quiaj tatsambiich a Barrabás. Ndoj tapiüng majwüch Teat Jesús, quiaj tüüch mamb mayacüw wüx cruz. ");
INSERT INTO huvNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Condom ajcüwa soldados taquiüjpüw Teat Jesús andüy tiül noic püjchiün niüng acül Pilato, nenüt pretorio. Quiaj canchiütoj meáwan soldados. ");
INSERT INTO huvNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Condom quiaj tasoijquiw tiül noic napixeran morada, ndoj tayacüw wüx omal nej noic corona nepeat sats. ");
INSERT INTO huvNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Quiaj tapots mitsojow nej, tasajüw: ―¡Mbich ique minatang nenajiüt ocueaj judíos! ―ajüw. ");
INSERT INTO huvNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Tawüjchiw omal nej naag xiül, aton tateontsüw onts ombeayiw nejiw wüx ombas nej. Ndoj taquiejliw micosüw nejiw teombas nej, atnej teayambüw monajneaj. ");
INSERT INTO huvNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Wüx lapaxiow mitsojow, quiaj tasojndiw aaga morada napixeran, cas tasoijquiw tiül apix nej alinomb. Ndoj quiaj taquiüjpüw mamb mayacüw wüx cruz. ");
INSERT INTO huvNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Nop naxey naw tiül cambaj Cirene, nenüt Simón, miteatiw Alejandro maquiiüb a Rufo, les tajngot imiün tiül wajchiüc. Wüx tamong amb quiaj, tasapüw nej müjchiw mambitic micruz Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Quiaj taquiüjpüw mamb a Teat Jesús andüy tiül niüng nasoic Gólgota, aag ayaj amb apiüng: Omal Mondeow. ");
INSERT INTO huvNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Condom tüjchiw nej vin aolüw tiül noic süüig nenüt mirra, pero nej ngo mayar manganeow. ");
INSERT INTO huvNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Wüx landoj mayacüw wüx cruz, quiaj tembaagayej wüx apix nej. Tasüetiw wüx majawüw ngün apmajoyiw anopnopoj. ");
INSERT INTO huvNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Aleamb pinawan ajüy nüt tayacüw nej wüx cruz. ");
INSERT INTO huvNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Condom tarangüw acas poch mayacüw wüx omal cruz niüng apiüng cuane asoet nej. Apiüng: “Aag agüy minatang nenajiüt ocueajiw nipilan judío”, aw. ");
INSERT INTO huvNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Aton tajmeliw wüx cruz ijpüw moneed, nop amb wüx miác Teat Jesús, alinop amb wüx miquiamb nej. ");
INSERT INTO huvNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Atquiaj tajlüy leaw landoj lamapiüng tiül Mipoch Teat Dios, cos apiüng: “Tayacüch atnej nop nerang ngo majneaj”, aw. ");
INSERT INTO huvNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Leaw tamongoj quiaj titsojow nej, talanglangüw omalüw müjchiw majüiquichaw ajcüyiw. Tapiüngüw: ―¡Jaa, ngwüy ique nepiüng apmejarrich aag nadam nangaj iüm, ndoj wüx er nüt apmelomboch alinomb! ");
INSERT INTO huvNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","¡Nganüy erwüneay wüx cruz iquiáyan quiaj, iriow tiüt! ―ajüw. ");
INSERT INTO huvNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","At aton ajcüwa montangtang miteaats at mondüy wüx aaga poch tüünd Moisés titsojow nej, tapiüngüw nejeyéjan quiaj: ―Nej tawün wüx alinop, pero nganüy a nej ngondom mewüneay wüx nejáyan quiaj. ");
INSERT INTO huvNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Nganüy apmajawaats sitiül naleaing nej aaga Cristo, minatang nenajiüt ocueaj cambaj Israel, cos sitiül apmaw tiüt imiün wüx cruz, mbich apmayariiüts andeac nej ―awüw. At monlüy wüx cruz aton titsojow nej. ");
INSERT INTO huvNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Wüx lalimnüt, quiaj pojniüt wüx iüt, tiün ram wüx lanchejliow nüt. ");
INSERT INTO huvNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Wüx lanchejliow nüt, quiaj Teat Jesús tepaj napac, tapiüng: ―Eloi, Eloi, ¿lama sabactani? ―aw. Aag ayaj apiüng: Teat Dios, Teat Dios, ¿neol tecueat xic? ");
INSERT INTO huvNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Altiül leaw alquiaj tanguiayiw aag ayaj, tapiüngüw: ―Inguiayiün, teamapaj a Elías ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Quiaj tamb nop, acuiür macachiich tiül vinagre noic esponja, aag ayaj atnej walang sap. Tayac wüx nots xiül. Quiaj tüüch machey. Tapiüng: ―Cawül majawaats sitiül aliüc Elías mawün nej tiüt ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Quiaj Teat Jesús tepaj napac, ndoj tandeow. ");
INSERT INTO huvNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Wüx tandeow Teat Jesús, quiaj aaga nadam jael nepal teomeaats nadam nangaj iüm chiütat naw cawüx andüy tiüt, nómban mbajcaw pinawan. ");
INSERT INTO huvNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Alombom quiaj niüng ajlüy micruz Teat Jesús nop minatang tiül soldados, teamajaw. Wüx nej tanguiay tepaj, ndoj tajaw nguineay tandeow, quiaj tapiüng: ―¡Naleaing aaga naxey quiaj Micual nej Teat Dios! ―aw. ");
INSERT INTO huvNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Aton aliw quiaj acas montaj, miünquiájan alembemiw teamajawüw. Altiül María Magdalena, Salomé, at a María mimümuw José maquiiüb Jacobo aag chingüy. ");
INSERT INTO huvNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ajcüwa montaj quiaj, tandüjpiw Teat Jesús wüx tajüy tiül Galilea, tambeolüw nej. Aton aliw quiaj altigüy montaj, ajcüw tiünüw mandüjpiw nej matüchiw Jerusalén. ");
INSERT INTO huvNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Wüx lamitiüt nüt, langwiiüts, cos aaga nüt quiaj tenguial ayambüch leaw apmetam wüx nüt axoodaran, cos oxep quiaj nüt axoodaran. ");
INSERT INTO huvNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","José naw tiül cambaj Arimatea, nej nop nej natang tiül monajiüt ocueaj judíos. Nej ngo mimbol, tamb niüng ajlüy a Pilato matün micuerpo Teat Jesús mamiüt. Cos nej aton teamacül majlüy tiül micambaj Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilato mbayat wüx tanguiay najénan landeow Teat Jesús. Quiaj tapaj a minatang tiül soldados matün manguiay sitiül naleaing landeow. ");
INSERT INTO huvNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Wüx minatang soldado tapiüng naleaing landeow, quiaj a Pilato tasaj a José alndom maquiiüb mamb mamiüt. ");
INSERT INTO huvNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Condom quiaj José tamb mangal noic najneaj püy. Ndoj tawün tiüt Teat Jesús, tawinch tiül a püy, taxaing maquiiüb mamb mayac tiül noic jayats oxiüt narangüch tüeng tiüc tiül piedra. Ndoj tayacüw noic nadam piedra mapal. ");
INSERT INTO huvNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","María Magdalena, at María mimüm José, tajawüw nguiane tayacüch. ");
INSERT INTO huvNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Wüx lamong a nüt axoodaran, quiaj María Magdalena, Salomé, at María mimüm Jacobo tangalüw najmboc angan aceite majoyiw mayacüw wüx ombas Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ǘmban arraw doming almajnchep nüt, quiaj tambüw andüyiw niüng ajlüy oxiüt. ");
INSERT INTO huvNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Tandeacüw nejeyéjan quiaj, tapiüngüw: ―¿Jane apmawün ocueajiiüts a piedra nepal ombeay aaga oxiüt? ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Wüx tatüchiw quiaj, quiaj tajawüw aaga nadam piedra nepal oxiüt laáw. ");
INSERT INTO huvNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Wüx tajmeliw tiül oxiüt, quiaj tajawüw nop nench, asooig najal apix nej raan. Alchetem wüx miác niüng tayacüch a Teat Jesús. Quiaj mbayatoj. ");
INSERT INTO huvNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Pero nej tasaj nejiw: ―Nde mbayameron, cos sajaw icona teameyamban Teat Jesús naw Nazaret, áag tambiyaw wüx cruz. Nganüy lapac, ngo majlüy ningüy. Jogüy ijawan niüng tayacüw. ");
INSERT INTO huvNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Nganüy quiüran isajan a Pedro at meáwan minipilan nej. Isajan: “Teat Jesús laámb ombas nej andüy tiül Galilea. Quiaj apmejawan, atnej lamasaj icon” ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Quiaj tawüw tiül oxiüt acuiürrüw, cos xeyay mbayatoj, tambeapmbeap nejiw, ngo masajüw nejinguind cos xeyay mbayatoj. ");
INSERT INTO huvNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Wüx Teat Jesús tapac tiül mondeow ǘmban arraw doming, quiaj tejüiquichay ombas majaw nej a María Magdalena, aag landoj mawün wüx ombas ayaíw nimeech. ");
INSERT INTO huvNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Condom quiaj María tamb masaj minipilan Teat Jesús, cos xeyay amix omeajtsüw, tenguial ajiüntsüw. ");
INSERT INTO huvNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Masey lamanguiayiw Teat Jesús lapac, aton a María landoj majaw nej, nejiw ngo mayariw andeac nej. ");
INSERT INTO huvNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Wüx ndoj ayaj, quiaj Teat Jesús tejüiquichay alinomb majawüw nej ijpüw minipilan nej wüx aliw tiül tiiüd andüyiw tiül wajchiüc, pero naleaing lango majüic matnej. ");
INSERT INTO huvNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Nejiw aton tambüw masajüw alacas minipilan nej, átan ngo mayariw nejiw andeacüw. ");
INSERT INTO huvNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Condom Teat Jesús tejüiquichay majawüw nej ajcüwa gajpanop (11) minipilan nej wüx aliw wüx mes teaüetiw. Quiaj talic nejiw ajcan ngo mayariw leaw tasoiquiw, aton cos adam omeajtsüw, ngo mayariw andeacüw monjaw nej lapac. ");
INSERT INTO huvNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ndoj tasaj nejiw: ―Quiüran tiül meáwan cambaj wüx iüt, isajan meáwan nipilan wüx aaga najneajay nanderac nguineay alndom maw asoeteran. ");
INSERT INTO huvNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Jane apmayar xepoch, mayar yow aton, apmaw asoet nej. Pero sitiül aljane ngo mayar xepoch, aag ayaj apmamongoch xeyay ngo majneaj tiül biümb alinoic nüt. ");
INSERT INTO huvNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Jane ayar xepoch apndom ombasüw marangüw ateócan. Wüx xenüt apmatajcüw majneaj nipilan leaw alwüx ombasüw nimeech; at apmandeacüw alinoic ombeayiün. ");
INSERT INTO huvNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Masey masapüw ndiüc; at sitiül tüjndiw manganeowüw leaw alndom mambiy nejiw, ngome apmarang nejiw nicuajind. Aton wüx apmayacüw owixaw wüx moniün andeow apmajneajiw ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Landoj masaj nejiw aag ayaj, quiaj tamb Teat Jesús andüy cawüx tiül cielo. Quiaj chetet amb wüx miác Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ndoj minipilan nej tambüw tiül meáwan cambaj mandeacüw aaga najneajay nanderac leaw apiüng wüx nguineay Teat Dios alndom mawün asoeteran. Nejay Teat Cristo tambeol nejiw, tajüiquich majaraw leaw tandeacüw, aag ayaj naleaing, cos tarang ateócan wüx tandeacüw mipoch nej. Atquiaj tajlüy. Amén.");
INSERT INTO huvNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Xeyay lamarangüw wüx nawiig nguineay andüübndüjpeay meáwan leawa tajaraw naleaing tajlüy, ");
INSERT INTO huvNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","atnej taquiajchiw icoots ajcüw leawa tajawüw tanomb con oniüjcüw; aton tambeolüw wüx mandeacüw meáwan poch leaw tanguiayiw. ");
INSERT INTO huvNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Nganüy xique laǘmb natüntün nanguiay meáwan, nguineay alndom najaw naleaing cuane tajlüy. Áag tapiüngas sanarang nasaj ic palan Teat Teófilo, nguineay andüübndüjpeay, ");
INSERT INTO huvNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","mejaw naleaing meáwan leaw lerquiaacharan wüx. ");
INSERT INTO huvNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Tiül mineat Herodes wüx nej tarang minatang monajiüt tiül iüt Judea, tajlüy nop miteaats tiül nipilan judío nenüt Zacarías, ajlüy tiül noic ajlüy miteaats ocueaj Abías. Mintaj nej teat Zacarías nenüt müm Elisabet, naw tiül acualaats teat Aarón, áag tajlüy tanomb. ");
INSERT INTO huvNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Miijpüéj ayariw andeac Teat Dios, arangüw atnej lamapiüng Teat Dios. Nejinguind ngondom mapiüng nejiw alcuane ngo majneaj arangüw. ");
INSERT INTO huvNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Naleaing nejiw ngo majiürüw micualüw nejiw cos müm Elisabet ngondom majiür micual nej; aton cos miijpüéj xeyay latang ombasüw. ");
INSERT INTO huvNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Condom wüx tatüch nejiw aaga noic ajlüy miteaats marangüw najiüt tiül nadam nangaj iüm, teat Zacarías tajlüy tiül. ");
INSERT INTO huvNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Cos miteaats ajlüyayej wüx masüetiw majawüw cuane najiüt apmarangüw anopnopoj. Teat Zacarías tatüch nej majmel tiül nadam nangaj iüm ocueaj Teat Dios mayac pom. ");
INSERT INTO huvNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Meáwan nipilan monaw tiül cambaj acülíwan mbeay nadam nangaj iüm teatajcüw orar wüx teajmel pom. ");
INSERT INTO huvNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Teat Zacarías altiül nadam nangaj iüm, quiaj tajaw nop ángel ocueaj Teat Dios alembem amb wüx miác artül niüng ajmel pom. ");
INSERT INTO huvNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Wüx teat Zacarías tajaw aaga ángel, mbayat xeyay, lango majaw cuane apmarang. ");
INSERT INTO huvNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Quiaj tasaj nej a ángel: ―Teat Zacarías, nde mbayamear, cos Teat Dios lamanguiay leaw itün ocueaj nej. Nganüy müm Elisabet mintaj apmajiür nop micual nej. Apmeaach manüt Juan. ");
INSERT INTO huvNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ique apmapac imeaats xeyay. Aton xeyay nipilan apmapac omeajtsüw wüx apwijquiam, ");
INSERT INTO huvNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","cos nej xeyay najneaj apmarang majaw Teat Dios. Ngome apmanganeow vin, aton ngome apmanganeow alinoic yow leaw alndom müüch mangün nipilan. Teat Dios apmüüch nej majiür Nangaj Miespíritu Nej wüx aliün teomeaats mimüm nej. ");
INSERT INTO huvNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Nej apmüüch leaam omeajtsüw alinomb xeyay nipilan tiül israel wüx Teat Dios, midiosüw nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Nej apmamong ombas marang minajiüt nej, teoj aliüc aaga lapiürang aliüc. Apmarang atnej tarang tanomb teat Elías, müüch majneaj omeajtsüw nateateran majawüw micualüw nejiw. Aton müüch marangüw najneaj leaw ngo mandiümüw mayariw leaw asoiquiw. Atquiaj alndom müüch majlüy noic ajlüy nipilan mayariw andeac aaga Cristo leaw lapiürang aliüc ―aj nej aaga ángel. ");
INSERT INTO huvNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Quiaj tapiüng teat Zacarías, tasaj a ángel: ―¿Nguineay alndom najaw naleaing aag ayaja? Cos xique xeyay lasataxey, at xantaj latang ombas aton ―aw. ");
INSERT INTO huvNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Quiaj tasaj nej a ángel: ―Xique nenütiüs Gabriel nerangas minajiüt Teat Dios. Nej tüüch xic niün nasaj ic aaga najneaj poch quiaj. ");
INSERT INTO huvNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Nganüy cos ngo meyar sandeac, langome apmerndeac leaw atüch a nüt majlüy aaga lanasaj ic quiaj, ndoj apmerndeac alinomb ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ajcüwa nipilan leaw ngo majmeliw, teamacüliw teat Zacarías, lambayajow ngo majawüw cua nerang nej, neol tequiy tiül nadam nangaj iüm. ");
INSERT INTO huvNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Wüx taw tiül nadam nangaj iüm teat Zacarías langondom mendeac masaj nejiw nicuajind. Quiaj tapiüngüw: ―Aleaic tüünd majaw tiül nadam nangaj iüm ―awüw. Nej tüüch nejiw majawüw cuane apiüng naag owix nej, cos lamejew, langondom mendeac. ");
INSERT INTO huvNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Wüx tatüch a nüt ndom minajiüt nej tiül nadam nangaj iüm, quiaj tajtsor. ");
INSERT INTO huvNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Naleaing ajiür miün acas nüt lacual müm Elisabet mintaj nej. Quiaj tacǘlan aniüng nej acoquiaw caaw, ngo maw majüy. Tapiüng: ");
INSERT INTO huvNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Teat Dios lamajiür xic lasta, lamüüch xic namongoch xemonxing teombas nipilan”, aw. ");
INSERT INTO huvNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Wüx lamajiür anaíw caaw, quiaj aaga ángel Gabriel tüüch nej mamb Teat Dios andüy tiül iüt Galilea, tiül noic cambaj nenüt Nazaret, ");
INSERT INTO huvNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","majaw nop nüx nenüt María. Aaga nüx quiaj altiüt mipoch aweaag nop nench nenüt José, naw tiül acualaats a Rey David tajlüy tanomb. ");
INSERT INTO huvNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Aaga ángel wüx tapeay niüng ajlüy a nüx, tasaj: ―¡Jow müm, satepeay ic! Sasoic nasaj ic lamexom xeyay monajneaj, cos Teat Dios lamambeol ic. Xeyay najneajay apmanderac wüx imbas tiül meáwan montaj ―aj. ");
INSERT INTO huvNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Nej a nüx wüx tajaw aaga ángel, mbayaw manguiay andeac, tapiüng tiül omeaats nej: “¿Neol tatepeay xic atquiaja?” aw. ");
INSERT INTO huvNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Quiaj tasaj nej aaga ángel: ―María, nde mbayamear, cos Teat Dios apmambeol ic xeyay. ");
INSERT INTO huvNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Nganüy apmejiür micual, apmewiquiach nop nine nench, apmeaach manüt JESS. ");
INSERT INTO huvNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Nej apmajlüy xeyay netam ajlüy. Apmanderac wüx nej apmapiürang micual nej Teat Dios najlüy tiül cielo. Teat Dios apmüüch nej marang nop minatang nenajiüt atnej tarang wüx a Rey David, mixeech nej najlüy tanomb. ");
INSERT INTO huvNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Nej apmajlüy wüx meáwan nipilan judío micual teat Jacob, apmarang natang meáwan nüt, aag ayaj ngo majiür ndoj ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","María tasaj a ángel: ―¿Nguineay alndom majlüy aaga ipiüng quiaja, cos xique nganaw najiür xenoj? ―aj. ");
INSERT INTO huvNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Quiaj tasaj nej a ángel: ―Aag ayaj Nangaj Espíritu ocueaj Teat Dios apmerang. Nej Teat Dios apmajiür ic mewiquiach aaga nine, cos aaga nine quiaj nangaj nej Micual Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","At icualaats müm Elisabet apmajiür nop nine. Masey xeyay latang ombas, anderac nómban ngondom majiür micual nej. Nganüy lacual lamajiür anaíw micaaw a nine teomeaats nej. ");
INSERT INTO huvNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Cos para Teat Dios ngo majlüy nicuajind naél ngondom marang ―aj nej a ángel. ");
INSERT INTO huvNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Quiaj tapiüng a María: ―Xique nganüy sajlüy tiül owix Teat Dios, ich marang wüx ximbas atnej lamepiüng apmarang ―aw. Quiaj tamb a ángel. ");
INSERT INTO huvNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Tíülan aaga nüt quiaj María tamb najen andüy tiül tiüc tiül noic cambaj tiül iüt Judea. ");
INSERT INTO huvNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Wüx tapeay quiaj tajmel aniüng teat Zacarías, quiaj tatepeay müm Elisabet. ");
INSERT INTO huvNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Wüx Elisabet tanguiay atepeay nej María, quiaj ajwicwic teomeaats nej aaga nine. Quiaj Nangaj Espíritu ocueaj Teat Dios tiün andüy wüx nej. ");
INSERT INTO huvNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Quiaj tandeac napac, tapiüng: ―Xeyay najneajay apmanderac wüx imbas tiül meáwan montaj, aton xeyay najneajay apmanderac wüx ombas aaga nine alteomeaats quiaj. ");
INSERT INTO huvNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Jow a xique, cuane xic, miün majaw xic mimüm Micual Xeteat Diosa? ");
INSERT INTO huvNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Cos wǘxan sanguiay itepeay xic, quiaj xecual apac omeaats, ajwic tiül ximeaats. ");
INSERT INTO huvNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Najneajay apmapac imeaats cos teyar meáwan leaw lamasaj ic Teat Dios nguineay apmarang ―aw. ");
INSERT INTO huvNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Condom quiaj tapiüng a María: Sayaag tiül ximeaats xeyay najneajay arang Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Apac ximeaats wüx Teat Dios, cos nej newün xic wüx. ");
INSERT INTO huvNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Teat Dios najneaj majaw xic masey xique ngo nembeat nicuajind tiül nipilan. Naw wüx nganüy meáwan nipilan aliüc miün, apmandeacüw xeyay najneaj wüx ximbas. ");
INSERT INTO huvNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Cos lamarang xeyay najneaj wüx ximbas Teat Dios; nej cuajantanej alndom marang, Xeyay nangaj minüt Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Nej andiüm meáwan nipilan leawa lajlüy nganüy, aton ajiür lasta leaw aliüc miün apmajlüy, meáwan leaw apmayariw nej andeac. ");
INSERT INTO huvNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Naag owix nej lamarang xeyay nadamdam cuajantanej, aton tandrooch ombasüw monpiüng nejiw alwüx atamüw. ");
INSERT INTO huvNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Tawün niüng tsotojow montangtang monajiüt, tayac quiaj leaw ayajcüw ngo membeatiw. ");
INSERT INTO huvNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Nipilan leawa ngo majiür üetiw, nej tüüch meáwan najneaj; nganüy nipilan monjiür xeyay, tüüch mambüw owixáwan, nicuajind ngo maxomüw. ");
INSERT INTO huvNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Tambeol cambaj Israel, ajcüw monrang minajiüt nej; ngo ndrom omeaats nejiw, tajiür nejiw lasta xeyay, ");
INSERT INTO huvNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","cos atquiaj tasaj mixejchiiüts Abraham wüx micual micual nej; tapiüng tanaámb apmajiür nejiw lasta meáwan nüt ―aw a María. ");
INSERT INTO huvNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ndoj María tacül quiaj maquiiüb müm Elisabet arej caaw, condom tandilil tajtsor alinomb. ");
INSERT INTO huvNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Wüx tatüch a nüt wijquiam micual nej müm Elisabet, quiaj wijquiat nop nine nench. ");
INSERT INTO huvNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Wüx tanguiayiw acualaats nej, at moncül quiájan niüng acül nej, nguineay Teat Dios lamajiür nej xeyay lasta, quiaj tapac omeajtsüw aton maquiüjpüw. ");
INSERT INTO huvNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Condom wüx tatüch ojpeacüw nüt, quiaj taquiüjpüw a nine matajcüch circuncidar atnej mbójan arangüw judíos. Tandiümüw müjchiw manüt Zacarías atnej minüt miteat nej. ");
INSERT INTO huvNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Quiaj mimüm nej a nine tapiüng: ―Ngwüy, Juan apmanüt ―aw. ");
INSERT INTO huvNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Quiaj tasajüw nej: ―¿Neol ayaja? Cos ngo majlüy tiül icualaats nejinguind manüt atquiaj ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Quiaj tatüniw manguiayiw miteat a nine, arangüw owixaw majaw, majüic nguineay andiüm müüch manüt a nine. ");
INSERT INTO huvNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Teat Zacarías quiaj tatün quiriw nine tirip xiül, condom tarang wüx, tapiüng: “Juan minüt nej”, aw. Meáwan monlüy quiaj mbayatoj majawüw. ");
INSERT INTO huvNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Quiaj taley oniw nej a teat Zacarías, tajneaj mendeac, andǘüban tasaj Teat Dios najneajay arang. ");
INSERT INTO huvNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Meáwan moncül quiájan niüng acüliw nejiw mbayatoj, aton meáwan cambaj najlüy tiül tiüc tiül iüt Judea tümb manguiayiw wüx aag ayaj. ");
INSERT INTO huvNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Meáwan nejiw leawa tanguiayiw tayacüw wüx omeajtsüw, tapiüngüw: ―¿Jane aaga nine quiaja? ¿Cuane apmarang alinoic nüte? ―awüw. Atquiaj tapiüngüw nipilan cos Teat Dios teamambeol a nine, ngo macueat. ");
INSERT INTO huvNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Teat Zacarías miteat a nine, tambeol nej Nangaj Espíritu ocueaj Teat Dios, tüüch nej poch cuane mandeac, tapiüng: ");
INSERT INTO huvNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Xeyay najneaj ajlüy Teat Dios ocueaj Israel, cos nej laíün ningüy tiül icootsa mawün asoet micambaj nej. ");
INSERT INTO huvNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Lamüüch icoots nop leaw alndom mawün icoots wüx, aag ayaj imiün tiül acualaats mixejchiiüts David, aaga nerang minajiüt nej. ");
INSERT INTO huvNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Atnej lamandeac Teat Dios wüx tasaj nangaj mondeac andeac nej, ajcüwa tajlüyiw tanomb, cos tapiüng: ");
INSERT INTO huvNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Nej apmawün icoots teowixaw leaw andiümüw mambiyaw icoots, at apmawün icoots teowixaw meáwan ajcüy majaw icoots. ");
INSERT INTO huvNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ajiür lasta meáwan mixejchiiüts, aton apleaam omeaats wüx meáwan leawa lamapiüng apmarang. ");
INSERT INTO huvNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Cos aag agüy Teat Dios tasaj miteatiiüts Abraham apmarang: ");
INSERT INTO huvNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Apmawün icoots teowixaw moncüy majaw icoots, marangaats leawa nej andiüm, ngo mimbolaats. ");
INSERT INTO huvNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Majlüyiiüts najneajay, ngo majiüraats nicuajind nisoet, marangaats leawa nej andiüm meáwan nüt wüx aliün mapacaats. ");
INSERT INTO huvNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Aton ique xecual, apmenderac wüx apmapiürang ique nop ic nendeac andeac Teat Dios najlüy tiül cielo, cos ique apmemong ombas, Teat Naxey teoj, apmetaag majneaj mitiiüd nej. ");
INSERT INTO huvNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Apmesajüw minipilan nej nguineay Teat Dios alndom mawün wüx omeaats meáwan asoetiw nejiw, quiaj alndom mawüw wüx. ");
INSERT INTO huvNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Cos xeyay ajiür icoots lasta Miteatiiüts Dios, áag tüüch icoots noic najneaj atnej ran, aag ayaj Micual nej imiün tiül cielo. ");
INSERT INTO huvNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Nej apmüüch majlüyiw tiül ran leaw ajlüyiw atnej aliw tiül pojniün, tenguial andeowüw tiül asoetiw nejiw. Nej apmayac icoots wüx marangaats najneaj, lango majlüy moncüy, aw a Zacarías. ");
INSERT INTO huvNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Aaga nine micual Zacarías quiaj tatang najneaj, xeyay tayamb Teat Dios. Tamb macül tiül wajchiüc niüng ngo majlüy cambaj, leaw atüch a nüt mejüiquichay majaw nej cambaj israel. ");
INSERT INTO huvNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Wüx aaga nüt quiaj minatang monajiüt tiül Roma nenüt Augusto César tapiüng meáwan nipilan netam mambüw mayacüw mineatüw nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ninguiaj amelich ajmel mineataran wüx Cerenio tarang nenajiüt tiül iüt Siria. ");
INSERT INTO huvNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Quiaj tambüw meáwan nipilan mayacüw mineatüw nejiw tiül micambajüw nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","At a José tamb aton imiün tiül cambaj Nazaret tiül Galilea andüy Belén tiül Judea. Aag ayaj micambaj David, cos José micual nej acualaats David. ");
INSERT INTO huvNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Quiaj tamb mayacüw mineatüw nejiw aquiiüb María minüx nej. Aaga minüx nej laliüc wijquiam micual nej. ");
INSERT INTO huvNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Wüx aliw tiül Belén, quiaj tatüch a nüt wijquiam micual a María. ");
INSERT INTO huvNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Quiaj wijquiat micual nej, nop nine nench; aag ayaj ombas macual. Condom taxaing mawinch ombas tiül noic püy, tapiib tiül üeteay nimal, cos lango matüchiw tiül a iüm niüng axoodaran. ");
INSERT INTO huvNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Alíwan quiaj acas monjiür sap, acüliw tiül wajchiüc ongwiiüts majiürüw misapüw nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Tapeay niüng ajlüyiw nejiw nop ángel ocueaj Teat Dios. Xowüy larraj, nómban arraj nejiw ran ocueaj Teat Dios. Nejiw xeyay mbayatoj majawüw. ");
INSERT INTO huvNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Quiaj tasaj nejiw a ángel: ―Nde mbayameron, cos sanasaj icon noic jayats majlüy leaw ngome aag anguiayeran. Xeyay apmüüch mapac omeaats meáwan nipilan. ");
INSERT INTO huvNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Nganüy nganüy cam tiül micambaj David lawijquiaw nop newün icon wüx. Aag ayaj a CRISTO Micual Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Sanasaj icon nguineay alndom mexoman aaga nine. Apmexoman alpiiüm tiül üeteay nimal, newinch ombas tiül püy ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ndójan mapiüng aag ayaj, quiaj tapeayiw xeyay ángeles imiün tiül cielo maquiüjpüw aaga ángel quiaj. Condom tapots mandeacüw wüx Teat Dios, tapiüngüw: ");
INSERT INTO huvNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Najneajay lamarang Teat Dios najlüy tiül cielo, najneajay apmajlüy wüx iüt, najneajay apmajlüyiw meáwan nipilan leaw apmandüjpiw Teat Dios!, awüw. ");
INSERT INTO huvNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Condom wüx tandilileaw ajcüwa ángeles andüyiw tiül cielo, lamacueat nejiw, quiaj tesajayej monjiür sap nop alinop, tapiüngüw: ―Tabaats matüchiiüts Belén majawaats aaga apiüngüw lajlüy quiaj, cos Teat Dios lamüüch icoots manguiayiiüts ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Quiaj tambüw najénan. Wüx tapeayiw quiaj, naleaing taxomüw a María maquiiüb a José, átan a nine alpiiüm tiül üeteay nimal. ");
INSERT INTO huvNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Wüx landoj majawüw aag ayaj monjiür sap, quiaj tandeacüw manguiay meáwan nipilan nguineay tasoiquiw wüx aaga nine quiaj. ");
INSERT INTO huvNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Meáwan nipilan leawa tanguiayiw andeacüw monjiür sap ajchiquiaw cawüx manguiayiw, apac omeajtsüw. ");
INSERT INTO huvNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Nej a María meáwan leawa tanguiay tayac wüx omeaats. ");
INSERT INTO huvNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Condom monjiür sap wüx tandilileaw xeyay tapac omeajtsüw masajüw Teat Dios. Aton tandeacüw wüx meáwan leawa Teat Dios lamüüch nejiw manguiayiw, at leaw lamüjndiw majawüw atnej tasoiquiw. ");
INSERT INTO huvNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Wüx tatüch ojpeacüw nüt, quiaj tarangüch wüx ombas a nine atnej ajlüyay marangüw judíos matajcüw circuncidar monench; tüjchiw manüt JESS, atnej aaga ángel lamasaj María wüx nganaw majlüy teomeaats nej a nine. ");
INSERT INTO huvNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Condom tatüch a nüt mambüw tiül nadam nangaj iüm tiül Jerusalén mayacüw ichech mimüm nine atnej ajlüyay marangüw judíos, cos atquiaj apiüng tiül aaga poch tüünd Moisés. Quiaj tambüw José maquiiüb María maquiüjpüw a nine, majüiquichaw tiül nangaj iüm, müjchiw Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Tarangüw aag ayaj cos atquiaj apiüng tiül Mipoch Teat Dios, cos apiüng: “Meáwan monench mbas macualaran apmajlüyiw ocueaj nejiw Teat Dios”, aw. ");
INSERT INTO huvNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Quiaj tambüw mayacüw ichechiw nejiw atnej apiüng tiül Mipoch Teat Dios, cos apiüng majmel ijquiaw nguex tengwüy ijquiaw palom. ");
INSERT INTO huvNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Tiül aaga nüt quiaj alquiaj tiül Jerusalén nop teat naxey nenüt Simeón. Aaga naxey quiaj xeyay najneaj arang, cos ayar andeac Teat Dios; nej teamacül aaga nüt wüx Teat Dios apmawün wüx cambaj Israel. Nangaj Espíritu ocueaj Teat Dios alwüx ombas nej. ");
INSERT INTO huvNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Aton landoj lamasaj nej Nangaj Espíritu ocueaj Teat Dios ngome apmandeow, netam ombas majaw aaga Cristo leaw apmüüch nej miün Teat Dios, ndoj tandeow. ");
INSERT INTO huvNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Aaga naxey quiaj tamb andüy tiül nadam nangaj iüm cos Nangaj Espíritu neech nej mamb. Wüx tapeayiw tiül nadam nangaj iüm a José maquiiüb María maquiüjpüw a nine Jesús marangüw atnej apiüng tiül aaga poch tüünd Moisés. ");
INSERT INTO huvNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Quiaj Teat Simeón angóchan a nine, tasap mapeic. Tandeac najneajay masaj Teat Dios, tapiüng: ");
INSERT INTO huvNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Nganüy Teat Dios, najneájan sanandeow cos lameaach xic najaw aaga leaw tesaj xic. ");
INSERT INTO huvNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Lanajaw con xiniiüg aag leaw lameaach miün mawün wüx nipilan; ");
INSERT INTO huvNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","cos aaga leaw lamejüiquich quiaj, apmambeol meáwan nipilan. ");
INSERT INTO huvNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Nej ajlüy atnej noic ran leaw apmarraj mambeol meáwan nipilan monaw tiül palpálwüx cambaj; aton apmarang xeyay najneajay tiül micambaj Israel, aw teat Simeón. ");
INSERT INTO huvNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Condom quiaj teat José at mimüm a nine Jesús mbayatoj manguiayiw andeac a teat Simeón wüx a nine quiaj. ");
INSERT INTO huvNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Quiaj teat Simeón tandeac masaj nejiw, tapiüng: ―Teat Dios mambeol icon ―aw. Condom tasaj a María mimüm a nine, tapiüng: ―Por nej aaga nine cam apmajmiücüw tiül ngo majneaj xeyay nipilan tiül Israel. At altiül apmawün wüx meáwan ngo majneaj. At aton xeyay nipilan ngome apmandiümüw nej, ngome apmayariw nej andeac. ");
INSERT INTO huvNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Atquiaj apmajüiquich altiül omeaats meáwan anopnop nipilan. Nganüy ique müm, xeyay apmamix imeaats; apmeyaag atnej matsoel ic nots espada ―aw. ");
INSERT INTO huvNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Aton alquiaj tiül nadam nangaj iüm nop müm najtaj nenüt Ana. Nej nop nendeac andeac Teat Dios, micual nej Fanuel, nawüw tiül acualaats Aser. Nej xeyay latang ombas. Tajiür minoj nej wüx monguich nej, tacül aweaag ayaíw neat, quiaj tandeow minoj nej. ");
INSERT INTO huvNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Lacül peic miow apiquiw (84) neat tatow lembej omal. Nej ngo macueat amb tiül nadam nangaj iüm marang najiüt nüt ongwiiüts, xeyay ayamb Teat Dios, xeyay aiünd. ");
INSERT INTO huvNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Aaga müm natajtaj quiaj andǘüban iün majaw nejiw, tüüch gracias Teat Dios. Aton tandeac wüx aag nine Jesús quiaj, masaj meáwan nipilan tiül Jerusalén leawa teamacüliw nop newün nejiw wüx. ");
INSERT INTO huvNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Wüx landoj marangüw meáwan atnej ajlüy tiül mipoch Teat Dios, quiaj tandilileaw andüyiw tiül iüt Galilea, tiül Nazaret micambajüw nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Aaga nine tatang najneajay napac, taxom omeaats, Teat Dios tambeol nej xeyay. ");
INSERT INTO huvNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Miteat nej mimüm nej neatneátan ambüw Jerusalén majawüw nangos nüt pascua. ");
INSERT INTO huvNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Wüx lamajiür gajpic (12) mineat nej a Teat Jesús, tambüw Jerusalén atnej mbójan marangüw majawüw nangos nüt. ");
INSERT INTO huvNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Condom wüx landoj nangos nüt nejiw tajtsoriw; nganüy a nench tacǘlan Jerusalén. Naleaing José maquiiüb mimüm a nench ngo majawüw. ");
INSERT INTO huvNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Lamajüyiw noic nüt, apiüngüw nejiw álan tiül acualajtsüw nejiw. Quiaj tapots mayambüw pal nüt. Tayambyambüw meáwan tiül acualajtsüw nejiw, at niüng leaw xowüy andeacüw maquiüjpüw. ");
INSERT INTO huvNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Wüx ngo maxomüw, quiaj tandilileaw alinomb andüyiw Jerusalén mayambüw. ");
INSERT INTO huvNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Wüx er nüt quiaj taxomüw; altiül nadam nangaj iüm, alchetem pinawan mondüy wüx poch leawa tüünd Moisés tanomb. Teamanguiay andeacüw, aton teamatün manguiay nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Meáwan leawa teamanguiay nej andeac mbayajow manguiayiw, cos xeyay axom omeaats mangoch masaj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Wüx taxomüw nej miteat nej mbayajow majawüw. Condom tasaj nej mimüm nej: ―Xecual, ¿neol terang atquiay quiaja? Jogüy miteat ata xique xeyay lanayamban ic, lanateowan ximeajtsan wüx imbas ―aj. ");
INSERT INTO huvNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Quiaj tasaj nejiw a nench: ―¿Neol teyamban xic, müm, ngo mejawana netam narang minajiüt Xeteate? ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Naleaing nejiw ngo maxomüw omeajtsüw wüx leawa tasaj nejiw quiaj. ");
INSERT INTO huvNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Condom taquiüjpüw mamb, tandilileaw andüyiw Nazaret. Tanaámb tarang leaw asoic. Mimüm nej tayac wüx omeaats meáwan leawa tajaw leawa tanguiay. ");
INSERT INTO huvNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Teat Jesús tanaámb tatang najneaj, aton taxom omeaats xeyay. Teat Dios tambeol nej, at nipilan najneájan majawüw nej aton. ");
INSERT INTO huvNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Lamajiür gajpocoic (15) neat tatow arang natang nenajiüt Tiberio César tiül Roma. Poncio Pilato nenajiüt nej tiül Judea; nganüy a Herodes nenajiüt nej tiül Galilea. At michiig nej Felipe nenajiüt nej tiül Iturea, at tiül iüt Traconite. Aaga Lisanias nenajiüt nej tiül Abilinia. ");
INSERT INTO huvNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Teat Anás at Teat Caifás natang miteaats nejiw tiül nipilan israel. Wüx aaga nüt quiaj aaga Juan micual teat xan Zacarías, tacül tiül wajchiüc niüng ngo majlüy cambaj. Quiaj Teat Dios tüüch nej poch leawa netam mandeac. ");
INSERT INTO huvNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Quiaj a Juan tapots mandeac Mipoch Teat Dios tiül meáwan cambaj ajlüyiw mbeay lam Jordán. Tasaj nipilan leaw laleaaw omeaats wüx Teat Dios mayariw yow, majüiquichaw naleaing lamacueatiw arangüw ngo majneaj. Quiaj Teat Dios apmawün wüx omeaats nej asoetiw nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Atquiaj tajlüy atnej nomb tarang tiül minawiig nej Isaías, aaga nendeac andeac Teat Dios, cos tapiüng: Apmanguiayaran aljane teandeac tiül wajchiüc niüng ngo majlüy cambaj, teamapiüng: “Xique xiün nüüch leaam imeajtsan mecueatiün merangan ngo majneaj, cos aliüc Teat Naxey, netam meleainguijchan mitiiüd nej. ");
INSERT INTO huvNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Meáwan nesojcolüy tiüc apmiütam, meáwan tiüc apndajrriüm tiüt matotow; meáwan netojngoyay tiiüd apmaleaing, at leawa tiiüd nendojropüy apmatotow. ");
INSERT INTO huvNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Quiaj meáwan nipilan apmajawüw nguineay Teat Dios alndom mawün asoeteran.” ");
INSERT INTO huvNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Wüx tambüw majawüw a Juan müüch nejiw yow, quiaj tasaj nejiw: ―¿Neol cua iyamban ningüy icona micual ndiüc? ¿Jane nesaj icon mercuiürran meriowan tiül aaga xeyay ngo majneaj leaw aliüc miün apmajlüye? ");
INSERT INTO huvNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Sitiül naleaing laleaaw imeajtsan nguineay temerangan, ijüiquichan nómban irangan najneaj. Nde merangrangayon wüx mepiüngan: “Abraham xeteatiün”, merawan; cos naleaing sasaj icon, Teat Dios alndom müüch majlüy micual Abraham masey a piedra quiaj, ndot mandiüm. ");
INSERT INTO huvNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Aton nganüy aaga üech alwüx mioxijchaw xiül; atquiaj meáwan xiül leawa ngo mayac najneaj aóng, apndojquiüm majlos tiül biümb ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Condom quiaj nipilan tatüniw nej manguiayiw: ―¿Nguineay netam narangana? ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Quiaj tasaj nejiw a Juan: ―Leawa nejiür ijquiaw apix nej ich müüch noic leaw ngo majiür, at leaw nejiür üet, ich müet aweaag leaw ngo majiür ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Átan tambüw majawüw a Juan acas monxaing tomiün, cos andiümüw mayariw yow. Tasajüw nej: ―Teat, ¿jow xicona, cuane netam narangana? ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Quiaj tasaj nejiw: ―Itüniün aleaw wüx atow nej isoiquiün, nde meyacan wüx nicuajind ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Aton acas soldado tatüniw manguiayiw nej: ―Jow xicona, ¿cuane netam narangana? ―awüw. Quiaj tasaj nejiw a Juan: ―Nde mewaijchan aljane mewüniün leaw almajiür, aton nde meyacan asoet leaw ngo marang nicuajind. Ich mapac imeajtsan wüx leaw ingüyaranan ―ajowiw. ");
INSERT INTO huvNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Meáwan nipilan acülíwan, ngo majawüw jane aaga Juan sitiül nej ngwüy aaga Cristo, leawa lapiürang aliüc mawün nejiw wüx. ");
INSERT INTO huvNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Quiaj tasaj nejiw a Juan: ―Xique naleaing süüch icon yow, pero aliüc miün nop teat naxey xeyay netam ajlüy ngo mat xic. Xique sayaag nicuajind xic, ngondom natüch nacheed aónts apaj nej. Nej apmüüch icon Nangaj Espíritu ocueaj Teat Dios, apmawün wüx imbasan meáwan ngo majneaj atnej biümb ambel nendeajndeaj. ");
INSERT INTO huvNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Aag ayaj atnej arang nop nerang najiüt, cos alteowix nej minipüch nej, apmaxaing osaab trigo matendeay, condom apmaxaing mayac tiül troj. Ndoj aaga opang trigo apmambel niüng ngondom xejquem ―aw. ");
INSERT INTO huvNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Atquiaj tapaj nej ocueajiw, tasaj meáwan nipilan wüx aaga najneaj leaw aliüc miün apmajlüy, nguineay alndom maw asoeteran. ");
INSERT INTO huvNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","At aton a Juan talic a Herodes, aaga natang nenajiüt, cos ngo majneaj arang, lamaquiiüb Herodías, aag ayaj mintaj Felipe michiig nej. Aton tapaj ocueaj wüx meáwan ngo majneaj arang. ");
INSERT INTO huvNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Naleaing Herodes ngo mayar leaw asoic, tarang alinoic xeyay ngo majneaj, tayac tiül manchiüc a Juan. ");
INSERT INTO huvNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Wüx tenguial ayariw yow nipilan, at Teat Jesús aton tayar yow. Ndoj wüx tenguial andeac masaj Teat Dios, quiaj tajüic tiül cielo, ");
INSERT INTO huvNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","tiün wüx ombas nej Nangaj Espíritu ocueaj Teat Dios, ajüic atnej noic palom. Quiaj tanguiayaran noic nanderac imiün tiül cielo, tapiüng: ―Ique xecual, xowüy sajiür ic lasta, apac ximeaats najaw ic ―aw. ");
INSERT INTO huvNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Wüx Teat Jesús tamelich aquiaach lamajiür nimiow gajpowüw (30) mineat nej. Ajaraw nej micual nej José; aaga José micual nej Elí. ");
INSERT INTO huvNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Aaga Elí micual nej Matat, Matat micual nej Leví, Leví micual nej Melqui, Melqui micual nej Jana, Jana micual nej José. ");
INSERT INTO huvNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José micual nej Matatías, Matatías micual nej Amós. Amós micual nej Nahum. Nahum micual nej Esli, Esli micual nej Nagai. ");
INSERT INTO huvNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Aaga Nagai micual nej Maat. Maat micual nej Matatías, Matatías micual nej Semei, Semei micual nej José. José micual nej Judá. ");
INSERT INTO huvNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá micual nej Joana, Joana micual nej Resa, Resa micual nej Zorobabel, Zorobabel micual nej Salatiel, Salatiel micual nej Neri. ");
INSERT INTO huvNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri micual nej Melqui, Melqui micual nej Adi, Adi micual nej Cosam, Cosam micual nej Elmodam, Elmodam micual nej Er. ");
INSERT INTO huvNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er micual nej Josué, Josué micual nej Eliezer, Eliezer micual nej Jorim, Jorim micual nej Matat. ");
INSERT INTO huvNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matat micual nej Leví, Leví micual nej Simeón, Simeón micual nej Judá, Judá micual nej José, José micual nej Jonán, Jonán micual nej Eliaquim. ");
INSERT INTO huvNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim micual nej Melea, Melea micual nej Mainán, Mainán micual nej Matata, Matata micual nej Natán. ");
INSERT INTO huvNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natán micual nej David, David micual nej Isaí. Isaí micual nej Obed, Obed micual nej Booz, Booz micual nej Salmón, Salmón micual nej Naasón. ");
INSERT INTO huvNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasón quiaj micual nej Aminadab, Aminadab micual nej Aram, Aram micual nej Esrom, Esrom micual nej Fares, Fares micual nej Judá. ");
INSERT INTO huvNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá micual nej Jacob, Jacob micual nej Isaac, Isaac micual nej Abraham, Abraham micual nej Taré, Taré micual nej Nacor. ");
INSERT INTO huvNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor micual nej Serug, Serug micual nej Ragau, Ragau micual nej Peleg, Peleg micual nej Heber, Heber micual nej Sala. ");
INSERT INTO huvNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala micual nej Cainán, Cainán micual nej Arfaxad, Arfaxad micual nej Sem, Sem micual nej Noé, Noé micual nej Lamec. ");
INSERT INTO huvNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamec micual nej Matusalén, Matusalén micual nej Enoc, Enoc micual nej Jared, Jared micual nej Mahalaleel, Mahalaleel micual nej Cainán. ");
INSERT INTO huvNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainán micual nej Enós, Enós micual nej Set, Set micual nej Adán, Adán micual nej Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Wüx ndoj ayar yow Teat Jesús tiül lam Jordán, xeyay tambeol nej Nangaj Espíritu ocueaj Teat Dios. Condom wüx tandilil imiün tiül lam Jordán, quiaj Nangaj Espíritu tüüch nej mamb andüy tiül wajchiüc niüng ngo majlüy cambaj. ");
INSERT INTO huvNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Tacül quiaj ic miow (40) nüt, quiaj tandiüm mayac nej wüx naél minatang nimeech. Teat Jesús taíünd ngo met meáwan tiül aaga nüt quiaj, condom xeyay tind üet. ");
INSERT INTO huvNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Quiaj tasaj nej a nimeech: ―Sitiül ique Micual Dios ic, ¿neol ngo mesaj aaga piedra quiaj marang pana? ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Quiaj Teat Jesús tasaj nej: ―Tiül Mipoch Teat Dios apiüng: “Ngome áagan nüeteran ipacüy nipilan; leawa nembeat, aag ayaj meáwan poch leaw andeac Teat Dios”, aw ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Condom quiaj nimeech taquiiüb nej mamb andüy wüx nop najal oleaj tiüc. Quiaj tüüch nej majaw najen meáwan cambaj leaw almajlüy wüx iüt. ");
INSERT INTO huvNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Quiaj tasaj nej a nimeech: ―Sanüüch ic meyar mejlüy wüx meáwan aaga najneajay cambaj quiaj, cos xique süünd, alndom nüüch jane xic sandiüm nüüch. ");
INSERT INTO huvNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Sitiül ique apmequieel micos tiximbas meyar sandeac, meáwan aag ayaj sanüüch ic meneay ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Quiaj nganüy tasaj nej Teat Jesús: ―Iriow niüng sajlüy nimeech, cos ajlüy tiül Mipoch Teat Dios, apiüng: “Aag miün Teat Dios netam mequieel micos teombas nej meyar andeac”, aw ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Condom nimeech taquiiüb nej mamb andüy tiül cambaj Jerusalén, tambüw andüyiw mal aaga nadam nangaj iüm. Quiaj tasaj nej: ―Sitiül naleaing ique Micual Dios ic, nguiam ijchic tiüt; ");
INSERT INTO huvNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","cos ajlüy tiül Mipoch Dios, apiüng: Teat Dios apmüüch miün miángeles nej mambeolüw ic. ");
INSERT INTO huvNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Apmangochiw ic tiül owixaw nejiw, ngana maleamb ileaj piedra, aw ―aj nej nimeech. ");
INSERT INTO huvNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Quiaj tasaj nej Teat Jesús: ―Aton ajlüy tiül Mipoch Teat Dios, apiüng: “Nde mendiüm mertsoj leaw apiüng Teat Naxey Midios”, aw ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Quiaj nimeech lango maxom cuane naél mayac wüx Teat Jesús; tacueat nej acas nüt, tamb. ");
INSERT INTO huvNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Teat Jesús tandilil alinomb andüy Galilea, xeyay tambeol nej Nangaj Espíritu. Tanderac wüx nej tiül meáwan cambaj najlüy quiaj. ");
INSERT INTO huvNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Nej taquiaach tiül ajcüwa sinagogas tiül meáwan cambaj; meáwan nipilan xeyay najneaj tandeacüw wüx nej. ");
INSERT INTO huvNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Condom tandilil Teat Jesús andüy Nazaret, tiül cambaj niüng tatang. Wüx noic nüt axoodaran tamb tiül sinagoga atnej mbójan marang, witiüt, lembem mateow Mipoch Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Quiaj tüünd aaga nawiig leawa tarang Isaías, aaga nendeac andeac Teat Dios. Andǘüban maleaaig niüng apiüng atcüy: ");
INSERT INTO huvNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Aaga Espíritu ocueaj Teat Dios almaquiiüb xic, cos nej lamarriiüd xic nasajüw meáwan nipilan leaw ngo majiür, nasajüw wüx aaga najneajay nanderac. Lamüüch xic niün nüüch mapac omeajtsüw leawa xeyay amix omeajtsüw. Aton nasajüw apmawüw wüx leaw ayajcüw atnej aliw tiül manchiüc. At nüüch ram oniüjcüw leawa nesomb, aton nawüniw wüx leaw amongochiw xeyay ngo majneaj. ");
INSERT INTO huvNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Tüüch xic niün nandeac wüx aaga najneajay neat leaw apmarang Teat Dios alinoic nüt. ");
INSERT INTO huvNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Condom quiaj tapal a nawiig, tüüch aaga nembeol tiül nangaj iüm, ndoj chetet. Meáwan nipilan leaw aliw tiül a sinagoga ngo macueatiw majawüw nej. ");
INSERT INTO huvNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Quiaj tasaj nejiw: ―Nganüy cam lajlüy aaga leaw apiüng tiül a nawiig quiaj ningüy niüng ijlüyiün ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Meáwan nipilan tandeacüw najneaj wüx ombas Teat Jesús, mbayajow manguiayiw aaga najneaj poch leawa tandeac. Quiaj tandeacüw nejeyéjan quiaj: ―¿Neol, ngome aag ayaj micual José? ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Condom Teat Jesús tasaj nejiw: ―Lanayaag apmesajan xic aaga poch cam: “Nendüy, ertajquiay majneaj iquiáyan quiaj; cos lananguiayiün xeyay cuajantanej lamerang tiül Capernaum, irang atquiaj ningüy tiül micambaj aton”, apmerawan ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Condom tasaj nejiw alquiriw: ―Naleaing sasaj icon, nop nendeac andeac Teat Dios ngo mayarich andeac nej tiül miíüt nej. ");
INSERT INTO huvNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","At sasaj icon, tajlüy xeyay monlemben omal montaj tiül Israel wüx aliün mapac teat Elías, wüx ngo majoet aroom neat al anaíw caaw. Quiaj tajlüy xeyay lop meáwan wüx iüt. ");
INSERT INTO huvNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Naleaing Teat Dios ngo müüch mamb a Elías mambeol meáwan monlemben omal montaj tiül Israel, tüüch mamb mambeol nop lemben omal najtaj tiül Sarepta niüng ajlüy cambaj Sidón. ");
INSERT INTO huvNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","At wüx aliün mapac teat Eliseo, aaga nendeac andeac Teat Dios, tajlüy xeyay moniün andeow tiül Israel, axom nejiw napat monandeow nasoic lepra. Naleaing nejinguind tiül nejiw mamongoch iün andeowüw, áagan nop naw Siria nenüt Naamán ―aw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Almanguiayiw ayaj, meáwan nipilan leaw aliw quiaj tiül a sinagoga tajcüyiw xeyay. ");
INSERT INTO huvNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Quiaj witiütoj, taquiüjpüw mamb Teat Jesús andüy mbeay cambaj. Condom naw quiaj taquiüjpüw andüy cawüx wüx omal tiüc niüng ajlüy micambajüw nejiw, apmatechiw nej tiüt. ");
INSERT INTO huvNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Teat Jesús ámban pinawan nejiw tamong tamb, ngo maxomüw majawüw. ");
INSERT INTO huvNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Condom Teat Jesús tamb tiül cambaj Capernaum tiül iüt Galilea. Tamb tiül a sinagoga wüx noic nüt axoodaran, tapots maquiaach nipilan. ");
INSERT INTO huvNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Mbayajow manguiayiw nguineay aquiaach, cos aquiaach nejiw atnej nop natang nenajiüt. ");
INSERT INTO huvNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Tiül aaga sinagoga quiaj, alquiaj nop naxey alwüx ombas nej nimeech, üüch nej michach. Aaga naxey quiaj tandeac napac, tasaj Teat Jesús: ");
INSERT INTO huvNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","―¡Icueat xicon Jesús naw Nazaret! ¿Cuane indiüm merang wüx ximbasana? ¿Tewiün mendrooch ximbasana? Xique sajaw jane ic. Ique Nangaj Micual Teat Dios ―aj. ");
INSERT INTO huvNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Quiaj Teat Jesús talic nej, tasaj: ―¡Tapots ipaj, iriow wüx ombas a naxey quiaj! ―aj. Quiaj a nimeech talox tiüt a naxey niüng ajlüy nipilan, ndoj quiaj taw wüx ombas nej. Tajneaj a naxey, ngo marang nej nicuajind. ");
INSERT INTO huvNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Meáwan nipilan mbayajow majawüw, tesajayej nejeyéjan quiaj, tapiüngüw: ―¿Cuane aag andeac quiaja? cos ayar nej andeac nej a nimeech wüx talic maw ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Meáwan nipilan tandeacndeacüw wüx Teat Jesús tiül meáwan cambaj. ");
INSERT INTO huvNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Condom Teat Jesús witiüt taw tiül a sinagoga, tamb andüy aniüng teat Simón. Müm najtaj miocuats Simón niün andeow, xeyay üüch nej nerraar. Tatüniw Teat Jesús mamongoch nej iün andeow. ");
INSERT INTO huvNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Quiaj Teat Jesús tatüch aaga niün andeow, tasaj a monandeow maw; quiaj taw, tamong üüch nej nerraar a müm najtaj. Andǘüban witiüt, tamb marang nejiw üetiw. ");
INSERT INTO huvNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Wüx lajmel nüt meáwan leaw ajiürüw monandeow, cuajantanej monandeow, taquiüjpüw mamb niüng ajlüy Teat Jesús. Nej tayac owix wüx ombasüw moniün andeow, quiaj tajneajiw. ");
INSERT INTO huvNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Altiül moniün andeow leaw alwüx ombas nimeech, tawün wüx ombasüw nejiw. Tepajüw tasajüw Teat Jesús: ―¡Ique Micual Dios! ―awüw. Nej talic nejiw, ngo müüch nejiw mendeacüw, cos nejiw lamajawüw naleaing nej aaga Cristo lapiürang aliüc. ");
INSERT INTO huvNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Wüx larraw tiüt alinoic nüt Teat Jesús taw tiül a cambaj, tamb andüy tiül wajchiüc. Nipilan tayambüw nej. Wüx taxomüw, quiaj tandiümüw mapalüw nej, ngo müjchiw mamb macueat nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Quiaj tasaj nejiw: ―Netam namb tiül palpálwüx cambaj aton nandeac nasaj nipilan wüx aaga najneajay nanderac andüy wüx micambaj Teat Dios, cos áag tasoiquiüs niün ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Quiaj tamb Teat Jesús maquiaach tiül meáwan sinagoga leaw ajlüy tiül iüt Galilea. ");
INSERT INTO huvNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Noic nüt Teat Jesús almbeay nadam yow nenüt Genesaret. Xeyay nipilan tapeayiw quiaj, acharrayej niüng ajlüy nej, cos andiümüw manguiayiw Mipoch Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Quiaj Teat Jesús tajaw alquiaj ijpüw müx mbeay yow. Ajcüwa mondoc laawüw tiüt, teajantsüw ndoc. ");
INSERT INTO huvNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Condom Teat Jesús tajtep tiül nop müx, aaga müx ocueaj teat Simón. Quiaj tasaj matech tiül yow alquiriw macueat mbeay iüt. Chetet tiül müx, tapots maquiaach nipilan. ");
INSERT INTO huvNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Wüx landoj andeac, quiaj tasaj teat Simón: ―Itech a müx andüy tiül najal, iyacan mindocon mesapan cüet ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Quiaj tasaj nej teat Simón: ―Teat, pal ongwiiüts sandocon sapacüjchiün xiniüjcan ngo nasapan nicuajind. Pero nganüy sitiül atquiaj ipiüng Teat, sanayacan ndoc cos lamesaj xicon ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Wüx tayacüw ndoc xeyay cüet tapalüw, ndoc tenguial chiütaw. ");
INSERT INTO huvNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Condom tarangüw owixaw mapajüw aquiüjpüw nejiw monlüy tiül alinop müx, mambeolüw nejiw. Quiaj tiünüw, tayacüw amal miijpüw a müx. Tajlüy tsoyomoj tiüt cos xeyay a cüet. ");
INSERT INTO huvNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Wüx tajaw aag ayaj teat Simón Pedro, quiaj taquieel micos nej tiüt niüng ajlüy Teat Jesús, tasaj: ―Xique Teat, sayaag ngo nembeat nicuajind, najneaj mecueat xic cos nop xic nipilan nejiüras nisoet ―aj. ");
INSERT INTO huvNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Tandeac atquiaj cos mbayat majaw andocoj xeyay cüet; at meáwan leawa tajlüyiw quiaj mbayatoj. ");
INSERT INTO huvNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","At teat Jacobo maquiiüb teat Juan, micual nejiw teat Zebedeo, ajcüw ayaj aquiüjpüw teat Simón, mbayatoj aton. Quiaj Teat Jesús tasaj Simón: ―Nde mbayamear teat, cos ajan wüx nganüy langome apmeyamb cüet mendoc, apmeyamb nipilan mesajüw mandüjpiw xic ―aj. ");
INSERT INTO huvNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Condom wüx tapeayiw mbeay iüt maquiüjpüw a müx, acueatíwan quiaj meáwan, tandüjpiw mamb Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Noic nüt Teat Jesús altiül noic cambaj, tapeay niüng ajlüy nej nop naxey, axom nej napat monandeow nasoic lepra. Aaga naxey quiaj wüx tajaw Teat Jesús taquieel micos nej tiüt, mejquiet tiüt nómban, tatün ocueaj, tasaj: ―Teat, sitiül ique indiüm, sajaw alndom memongoch iün sandeow ―aj. ");
INSERT INTO huvNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Condom quiaj tandic owix Teat Jesús marreeg nej, tasaj: ―Xecual sandiüm, sanamongoch iün indeow ―aj. Wǘxan ndoj mapiüng aag ayaj, andǘüban tajneaj aaga naxey quiaj. ");
INSERT INTO huvNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Quiaj Teat Jesús tasaj nej nde masaj nejinguind. Aton tasaj: ―Quiür ijchaw majawüw ic miteaats, iyac erchech atnej nomb tapiüng teat Moisés netam marangüch. Quiaj apmajawüw nipilan ique lerneaj ―aj. ");
INSERT INTO huvNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Xeyay tenguial anguiayeran, tenguial ajüic nguineay teamarang Teat Jesús. Quiaj tapeayiw nipilan manguiayiw nej andeac, aton mamongoch nej iün andeowüw. ");
INSERT INTO huvNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Naleaing Teat Jesús tamb andüy tiül wajchiüc niüng ngo majlüy nipilan, mataag orar, mandeac aweaag Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Noic nüt wüx Teat Jesús tenguial aquiaach, altsotomoj quiaj acas fariseos at aton ajcüwa mondüy wüx poch tüünd Moisés. Ajcüw ayaj napeayiw imiünüw tiül nguiajantanej cambaj tiül iüt Galilea, tiül iüt Judea, at monaw tiül cambaj Jerusalén. Quiaj Teat Dios xeyay tambeol Teat Jesús mamongoch monandeow. ");
INSERT INTO huvNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Condom tapeayiw quiaj acas monxey aquiüjpüw mamb nop ndron ombas, amb wüx mats. Tandiümüw mamelichaw mayacüw niüng ajlüy Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Naleaing ngo maxomüw nguineay mamelichaw cos xeyay nipilan alquiaj. Quiaj tajtepiw mal iüm, tajarrichaw quiriw. Cas tamongochiw a ndron ombas amb tiül, alwüx mimats nej. Tayacüw pinawan niüng ajlüy Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Wüx Teat Jesús tajaw nguineay nejiw ayacüw wüx omeajtsüw andeac nej, quiaj tasaj a ndron ombas: ―Laáw isoet teat ―aj. ");
INSERT INTO huvNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Quiaj ajcüwa mondüy wüx aaga poch tüünd Moisés, at ajcüwa fariseos tapots andeacndeacüw wüx nejeyéjan quiaj, tapiüngüw: “¿Jane nej aaga naxey quiaj, neol tapots andeac ngo majneaj wüx Teat Dios? Cos nejinguind nipilan ngondom mawün nisoet, néjan quiaj Teat Dios alndom”, awüw. ");
INSERT INTO huvNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Naleaing Teat Jesús tajaw cuane teamandeacndeacüw wüx, quiaj tasaj nejiw: ―¿Cuane wüx ipiüngpiüngan tiül imeajtsana? ");
INSERT INTO huvNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Cuane ngo maél iyajcan napiüng: “Laáw isoete”, ngwüy napiüng: “Witiür ijüy, naja”? ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Condom tasaj nejiw níüngan: ―Nganüy apmejawan naleaing Teat Naxey alndom mawün nisoet ningüy wüx aaga iüt cam ―aj nejiw. Quiaj tasaj a ndron ombas: ―Witiür, ixaing mimats teat, quiür ijtsor ―aj. ");
INSERT INTO huvNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Andǘüban ajneaj, witiüt taxaing mimats nej piiow wüx, teamajawüw nej nipilan, tajtsor apac omeaats, tandeac xeyay najneaj wüx Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Meáwan nipilan mbayajow majawüw, tandeacüw xeyay najneaj wüx Teat Dios, at xeyay timboloj, tapiüngüw: ―Nganüy landoj majawaats noic xeyay najneaj leaw ngome aag ajaraw ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Condom Teat Jesús taw quiaj, taxom nop nesap mitomiün cambaj, nenüt Leví, alchetem wüx bang niüng angüyeran tomiün. Quiaj tasaj: ―Mac, indüüb xic ―aj. ");
INSERT INTO huvNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Quiaj witiüt a naxey, acueátan quiaj meáwan, tandüüb mamb Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Condom teat Leví tarang noic nadam monet aniüng nej. Alquiaj xeyay monsap tomiün, at aliw quiaj xeyay nipilan alwüx mes maquiüjpüw. ");
INSERT INTO huvNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ajcüwa mondüy wüx aaga poch tüünd Moisés, at ajcüwa fariseos tandeacndeacüw masajüw minipilan Teat Jesús: ―¿Neol teretiün tenganeowan mequiüjpan monsap mitomiün cambaj, at nipilan monrang nisoete? ―ajüw. ");
INSERT INTO huvNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Quiaj tasaj nejiw Teat Jesús: ―Jane ayaag napac najneaj, ngo metam mayamb nop nendüy; pero jane ayaag niün andeow ich mayamb nop nendüy. ");
INSERT INTO huvNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Xique ngo niün nayamb nipilan leaw ayaag najneaj arang; xique tiünas nayamb leaw ngo mayamb Teat Dios, cos sandiüm nüüch leaam omeajtsüw wüx Teat Dios, marangüw leawa nej andiüm ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Nejiw tasajüw Teat Jesús: ―¿Neol minipilan teat Juan aiündüw xeyay, at atajcüw orar, átan ajcüwa fariseos? Jow nganüy minipilan, ¿neol tetíwan, anganeowǘwan? ―ajüw. ");
INSERT INTO huvNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Quiaj tasaj nejiw Teat Jesús: ―¿Alndom monamb niüng nengoch owixe maiündüwa wüx nej a nench alquiaj almaquiüjpüwa? ");
INSERT INTO huvNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Alinoic nüt wüx lango majlüy a nench, wüx aaga nüt quiaj mbich apmaiündüw ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","At aton tandeac alacas poch ngome aleáingan, andiüm maquiaach nejiw, tapiüng: ―Nejinguind ngo mandooig quiriw jayats jael macancham tiül noic nguirich napixeran, cos sitiül apmarang atquiaj, apsojndiüm alinomb aaga jayats jael. Ngome áagan, aton aaga jayats jael quiaj ngome apmayar maquiiüb aaga nguirich jael. ");
INSERT INTO huvNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","At aton nejinguind ngo mayac jayats vin tiül nguirich taag iquial vin, cos sitiül apmayac tiül, apmapotiich nej, apmajünch tiüt a vin, apndrom ombas, at a taag aton. ");
INSERT INTO huvNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Leaw jayats vin netam majmel tiül jayats taag, quiaj mbich ngo ndrom ombasüw, apmaiücüw. ");
INSERT INTO huvNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Nejinguind nenganeow ajlüyay vin ngome apmandiüm manganeow jayats vin, cos anderac ajlüyay vin alwüx ajneaj, ngo matnej jayats vin ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Wüx noic nüt axoodaran, Teat Jesús tamongoj ambüw tiül corrül. Minipilan nej wǘxan amongoj tandojquiw aól trigo, ndoj tapots maliündüw teowixaw nejiw maw osaab müetiw. ");
INSERT INTO huvNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Quiaj acas fariseos teamajawüw aag ayaj, tasajüw: ―¿Neol terangan leaw ngo metam merangan wüx nüt axoodarana? ―ajüw. ");
INSERT INTO huvNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Quiaj Teat Jesús tasaj nejiw: ―¿Neol, jow icona ngomeaag meteowana mejawana nguineay tarang mixejchiiüts David wüx tind üet maquiiüb minipilan neje? ");
INSERT INTO huvNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Cos tajmel tiül nine nangaj iüm ocueaj Teat Dios, tawün aaga pan najmel wüx artül, tüetiw. Aag ayaj nejinguind ngondom müet, ajcǘwan miteaats alndom müetiw ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","At tasaj nejiw: ―Teat Naxey alwüx atam, ngo matnej aaga nüt axoodaran quiaj ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","At aton alinoic nüt wüx nüt axoodaran Teat Jesús tamb tiül sinagoga maquiaach. Tiül aaga nangaj iüm quiaj alquiaj nop naxey ndron ombas, nandeow miác owix nej. ");
INSERT INTO huvNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Mondüy wüx aaga poch tüünd Moisés at ajcüwa fariseos teamacüliw majawüw majüic sitiül Teat Jesús apmüüch majneaj owix aaga naxey quiaj wüx nüt axoodaran, para alndom masapüw wüx, mayacüw asoet. ");
INSERT INTO huvNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Nej lamajaw cuane alwüx omeajtsüw. Quiaj tasaj aaga naxey nandeow owix: ―Witiür lember pinawan ―aj. Quiaj witiüt a naxey lembem. ");
INSERT INTO huvNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Condom Teat Jesús tasaj nejiw: ―Sanatün nanguiay icon: ¿Jow wüx nüt axoodaran, alndom marangüch najneaja, ngwüy ngondoma? ¿Alndom mambeolaran jangantaneje, ngwüy ich majlüye mandeowa? ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Condom tajaw nej teombasüw meáwan monlüy quiaj niüng ajlüy nej, quiaj tasaj a naxey: ―Ileainguiich iwix ―aj. Quiaj tarang a naxey atnej asoic; nómban ajneaj owix nej. ");
INSERT INTO huvNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Altiül tajcüyiw, tandeacüw nejeyéjan quiaj nguineay apmarangüw wüx Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Tiül aaga nüt quiaj tamb Teat Jesús andüy wüx tiüc mataag orar, tacül quiaj aaga ongwiiüts matün ocueaj Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Wüx larraw tiüt alinoic nüt, quiaj tapaj minipilan nej xenenguemoj; tarriiüd gajpiüp (12) tiül nejiw. Ajcüw ayaj tüjndiw manütiw apóstoles. ");
INSERT INTO huvNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ajcüw ayaj: nop Simón, aag ayaj nasoic Pedro, at Andrés michiig nej. Alinop Jacobo, alinop Juan, alinop Felipe, alinop Bartolomé, ");
INSERT INTO huvNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","alinop Mateo, alinop Tomás, alinop Jacobo micual Alfeo, alinop Simón nasoic Zelote, ");
INSERT INTO huvNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","alinop Judas michiig Jacobo. Ata Judas Iscariote, aaga ndoj tayac teowixaw monajiüt a Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Condom taw tiüt alinomb Teat Jesús imiün wüx tiüc aquiiüb minipilan nej. Wüx tatüchiw noic nadam püjchiün tacülíwan quiaj. Aliw quiaj aton xeyay nipilan imiün tiül iüt Judea, imiün tiül Jerusalén, at monaw mbeay ndec niüng ajlüy cambaj Tiro maquiiüb Sidón. Ajcüw ayaj tambüw niüng ajlüy Teat Jesús manguiayiw andeac nej; at mamongoch nej iün andeowüw. ");
INSERT INTO huvNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Aton tajneajiw leaw alwüx ombasüw nimeech, üüch nejiw michachiw. ");
INSERT INTO huvNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Meáwan nipilan tandiümüw marrejquiw nej, cos ajawüw sitiül apmarrejquiw apmajneaj iün andeowüw. ");
INSERT INTO huvNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Condom Teat Jesús taxaing omal majaw minipilan nej, tasaj: ―Najneajay ijlüyiün icona leaw ngo mejiüran xeyay, pero ijlüyiün tiül minipilan Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Najneajay ijlüyiün icona leaw nganüy indeowan lop, cos alinoic nüt apaxiüm iretiün. ’Najneajay ijlüyiün icona leaw nganüy ngo majneaj imongochiün, ijiüntsan, cos alinoic nüt apmapac imeajtsan, apmecuiquian. ");
INSERT INTO huvNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Najneajay ich mapac imeajtsan wüx apmajcüyiw majawüw icon nipilan, mawüniw icon ninguiün mandeacüw ngo majneaj wüx imbasan. At wüx apmandeacüw wüx minütiün atnej monrang ngo majneaj cos iyariün andeac Teat Naxey. ");
INSERT INTO huvNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ich majneaj imeajtsan wüx aaga nüt quiaj, ich mapac imeajtsan, cos xeyay najneaj leaw apmeajndiün tiül cielo. Atquiaj tamongochiw mondeac andeac Teat Dios tanomb; cos aton tajcüy majaw nejiw mixejchiün. ");
INSERT INTO huvNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’¡Jaa! Nganüy a icona monjiür cuajantanej, landoj lamejiüran apac imeajtsan ningüy wüx a iüt cam. ");
INSERT INTO huvNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’¡Jaa! Ata icona leaw nganüy ayaag paxiünüy üet cos alinoic nüt apmendeowan lop. ’¡Jaa! Aton icona leaw nganüy tenguial icuiquian, cos alinoic nüt apmamix imeajtsan, apmejiüntsan. ");
INSERT INTO huvNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’¡Jaa! Icona ngo majneaj apmejlüyiün wüx nipilan apmandeacüw najneaj wüx imbasan, cos atquiaj aton tandeacüw mixejchiün wüx ombasüw monwüyay andeacüw andeac Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","’Icona leaw ilean ningüy nganüy sasaj icon: Ijiüran lasta leaw ajcüy majaw icon; irangan najneaj wüx ombasüw. ");
INSERT INTO huvNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Indeacan najneaj wüx ombas jane andeac ngo majneaj wüx imbasan. At itüniün Teat Dios mambeol nejiw leaw andeacüw wüx imbasan ngo majneaj. ");
INSERT INTO huvNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Sitiül aljane maleamb imbeay, masey, ich maleamb necamb, nde merang wüx nicuajind. Sitiül aljane masoond ic tiül miquieed manood icueaj, iich micamix aton majoy. ");
INSERT INTO huvNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Aton sitiül jangantanej apmatün icueaj cuajantanej ndot ngo majiür, iich sitiül ijiür. Leaw lamanood icueaj cuajantanej nde metüntün mandilil müüch ic. ");
INSERT INTO huvNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Atnej indiüman marangüch najneaj wüx imbasan, irangan atnej wüx ombas alinop. ");
INSERT INTO huvNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Cos sitiül najneaj mejawan áagan nipilan leaw najneaj majaw icon, ¿nguineay ajüic irangan najneaja? Atquiaj arangüw nipilan leaw ngo mayamb Teat Dios, ajneaj majawüw leaw najneaj majaw nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Aton sitiül merangan najneaj wüx ombas nipilan leaw nerang najneaj wüx imbasan, ¿nguineay ajüic irangan najneaja? Cos atquiaj arangüw monrang ngo majneaj aton. ");
INSERT INTO huvNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","At sitiül ijchan ajüchay áagan nipilan leaw ijawan alndom mangüy, mayac wüx alquiriw, ¿nguineay ajüic irangan najneaja? Cos atquiaj arangüw monrang ngo majneaj aton, üjchiw ajüchay leaw ajawüw alndom müüch nejiw alquiriw. ");
INSERT INTO huvNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Icona netam mejiüran lasta leaw ajcüy majaw icon, irangan najneaj wüx ombasüw, ijchan ajüchiw, nde mecüliün mayacüw wüx alquiriw. Atquiaj apmeajndiün xeyay najneaj tiül cielo, aton apmejlüyiün micual icon Teat Dios. Cos nej aton ajiür lasta jangantanej, masey aljane ngo mambeol nejinguind, tengwüy masey arang ngo majneaj. ");
INSERT INTO huvNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Netam mendiüman jangantanej atnej arang Miteatiiüts Dios, cos nej ajiür lasta jangantanej. ");
INSERT INTO huvNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’Nde meyambyamban cuane asoet alinop, quiaj nejinguind ngome apmayamb isoetiün. Nde meyacan asoet alinop, quiaj nejinguind ngome apmayac isoetiün. Aton iwüniün wüx imeajtsan leaw arangüch wüx imbasan, quiaj apmajwan wüx omeaatsaran leawa icona irangan aton. ");
INSERT INTO huvNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Nde merangan reech, imbeolan jangantanej, cos sitiül atquiaj merangan, Teat Dios apmambeol icon xeyay. Irangan atnej nop nenüjpeay leaw najneaj arang; apmapeax palan ipeaxay. Cos atnej imbeolan alinop, atnej apmambeol icon Teat Dios aton ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Condom tasaj nejiw acas poch ngome aleáingan, tandeac andüy wüx nop somb, tapiüng: ―Jow nop somb ¿alndom manetet owix alinop somba? ¿Ngo majmiüc aweaag tiül ndorropa maquiiüba? ");
INSERT INTO huvNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Nop nequiajchay ngondom majntsop wüx ajaw matnej ajaw nequiaach nej. Naleaing wüx landoj laquiajchay xeyay, nej alndom matüch ajaw nequiaach nej. ");
INSERT INTO huvNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’¿Neol nguineay ixom mejaw cuane nine najmel tiül oniiüg alinop, nganüy a ique ngo mexom mejaw aaga xiül alatsam tiül iniiüga? ");
INSERT INTO huvNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","¿Cuane wüx alndom mesaj alinop: “Coj, chiün nawün aaga nine najmel tiül iniiüg quiaj”, meraj, sitiül ique ngo mejaw aaga xiül alatsam tiül iniiüga? ¡Ndeac mbeay! Sasaj ic menguiay, iwün aaga xiül alatsam tiül iniiüg quiaj, ndoj quiaj apmejaw najneaj para mewün aaga nine najmel altiül oniiüg alinop. ");
INSERT INTO huvNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","’Ngo majlüy noic owil najneaj xiül maóng ngo majneaj, at noic owil ngo majneaj xiül maóng najneaj. ");
INSERT INTO huvNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Cos xiül wüx aóng ajaraw sitiül najneaj tengwüy ngo majneaj. Ngondom mapejtich toc wüx noic owil sats; at ngondom mapejtich uva wüx wajtsats. ");
INSERT INTO huvNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Nop nipilan andeac najneaj, aag ayaj ajüiquich nej najneaj altiül omeaats. Nganüy nop nipilan andeac ngo majneaj; aag ayaj ajüiquich nej xeyay ngo majneaj altiül omeaats nej. Cos leawa ajlüy tiül omeaatsaran, aag ayaj neech mendeacaran. ");
INSERT INTO huvNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","’¿Neol tesajan xic: “Teat Naxey, Teat Naxey”, merawan, sitiül ngo merangan atnej sasaj icon? ");
INSERT INTO huvNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Sanasaj icon jane atnej. Wüx nop aliüc manguiay sandeac ndoj apmarang atnej anguiay, ");
INSERT INTO huvNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","aag ayaj atnej nop naxey tawitich nop iüm, taood tiüt xeyay, condom talomboch wüx piedra, lombom nandand. Ndoj, wüx taw noic nadam lam xeyay napac tamong amb wüx a iüm quiaj. Naleaing ngo marang nej nicuajind cos imiün wüx piedra witiow. ");
INSERT INTO huvNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Nganüy leawa nenguiay xepoch ndoj ngo marang atnej, aag ayaj atnej nop naxey tawitich ombiüm nej tíülan wiiüd, ngo majiür cuane masap nej tiüt. Camüm majngot nadam lam napac xeyay, ámban majarrich aaga iüm quiaj, aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Teat Jesús wüx landoj mandeac aag ayaj manguiayiw nipilan, quiaj tamb andüy tiül cambaj Capernaum. ");
INSERT INTO huvNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Tiül Capernaum alquiaj nop minatang soldado naw Roma, ajiür nop nerang minajiüt nej xowüy ajiür lasta; pero laxeyay iün andeow, laliüc mandeow. ");
INSERT INTO huvNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Aaga soldado quiaj wüx tanguiay anderac wüx Teat Jesús, quiaj tüüch mambüw acas montangtang monajiüt tiül judíos masajüw Teat Jesús mamb mamongoch iün andeow aaga nerang minajiüt nej. ");
INSERT INTO huvNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Quiaj tambüw ajcüwa monxey quiaj majawüw Teat Jesús. Tapots masajüw matüniw ocueaj, tapiüngüw: ―Teat, najneaj membeol aaga soldado quiaj; ");
INSERT INTO huvNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","cos nej xeyay najneaj omeaats majaw icoots, tapiüng marangüch nop sinagoga ningüy tiül micambajaats ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Quiaj tamb Teat Jesús maquiiüb nejiw. Wüx laliüc mapeayiw aniüng nej, aaga minatang soldado tüüch mamb acas minipilan nej mambüw mangochiw Teat Jesús, masajüw: ―Teat, nde mermbichay ipac. Xique ngo nembeat nicuajind, para mewiün saniüng. ");
INSERT INTO huvNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ngo nembeat, pares ngo namb natüch niüng ijlüy. Xique sandiüm teat, mepiüng apmajneaj, quiaj apmajneaj aaga nembeol xic. ");
INSERT INTO huvNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Cos xique aton sajiür nesaj xic cuane narang, aton sajiür xesoldado sasajüw cuane netam marangüw. Sitiül xique sanasaj nop: “Quiür”, naj; nej apmamb. Sitiül sanasaj alinop: “Mac”, naj, pues nej aliüc. Tengwüy sanasaj nembeol xic: “Irang aag agüy”, naj, pues nej apmarang ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Teat Jesús wüx tanguiay aag ayaj mbayaw manguiay nguineay andeac aaga minatang soldado quiaj. Condom ndiliteay majaw nipilan mondüüb nej, tapiüng: ―Naleaing sasaj icon, ngo naxom nop tiül nipilan israel leawa neyar sandeac matnej aaga naxey quiaj ―aw. ");
INSERT INTO huvNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Wüx tapeayiw tiül nden alinomb ajcüwa monamb quiaj, quiaj tajawüw aaga niün andeow lajneaj. ");
INSERT INTO huvNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Condom alinoic nüt tamb Teat Jesús andüy tiül noic cambaj nenüt Naín, aquiiüb minipilan nej, at xeyay jangantanej nipilan aton. ");
INSERT INTO huvNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Wüx lapeay quiaj mbeay cambaj, quiaj tajaw laámb apmamiüraad nop nandeow, aag ayaj micual nop lemben omal najtaj ajcánan ajiür. Almaquiüjpüw nej mamb xeyay nipilan monaw quiaj. ");
INSERT INTO huvNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Teat Jesús wüx tajaw aaga najtaj tajiür lasta, tasaj: ―Nde mejiünts müm ―aj. ");
INSERT INTO huvNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Condom tatüch quiaj marreeg a nandeow, ndoj quiaj monbitic nej lombotoj. Andüüb miün Teat Jesús tasaj a nandeow: ―¡Witiür xecual! ―aj. ");
INSERT INTO huvNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Quiaj witiüt chetem aaga nench nandeow quiaj, tendeac. Condom quiaj Teat Jesús tasaj mimüm a nench: ―Iquiiüb ijtsoriün müm ―aj. ");
INSERT INTO huvNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Almajawüw aag ayaj a nipilan mbayajow, tapiüngüw: ―Xeyay najneaj arang Teat Dios. Lajlüy tiül icoots nop nendeac andeac nej. Naleaing Teat Dios laíün majaw micambaj nej ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Quiaj tanguiayaran nguineay arang Teat Jesús meáwan tiül iüt Judea, at tiül meáwan cambaj nacül quiaj niüng ajlüy Judea. ");
INSERT INTO huvNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Condom minipilan teat Juan tambüw masajüw nej meáwan aaga jayats majlüy quiaj, leawa tarang Teat Jesús. Quiaj a Juan tapaj ijpüw minipilan nej. ");
INSERT INTO huvNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Tüüch mambüw matüniw manguiayiw Teat Jesús sitiül nej aaga leaw lapiürang aliüc, ngwüy apmacüliw alinop. ");
INSERT INTO huvNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Wüx tapeayiw niüng ajlüy Teat Jesús ajcüw a monxey quiaj, tasajüw: ―Asaj xicon teat Juan, aaga neech yow nipilan, niünan natüniün nanguiayiün ic sitiül ique aaga Cristo leaw lapiürang aliüc, ngwüy sanacüliün alinop ―ajüw. ");
INSERT INTO huvNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Tiül aaga ores quiaj Teat Jesús tamongoch iün andeow xeyay moniün andeow, nexom nejiw cuajantanej necoy. Tawün wüx ombasüw leaw alwüx ombasüw nimeech. Aton xeyay nesomb tüüch maxomüw majawüw. ");
INSERT INTO huvNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Quiaj Teat Jesús tasaj nejiw: ―Quiüran isajan a teat Juan meáwan leaw temejawan temenguiayiün. Isajan nguineay larraw oniüjcüw leaw nesomb, leaw necoex lajüy, leaw nexom nej napat monandeow nasoic lepra lajneaj, leaw nelaag lamanguiay, aton leaw tandeow nganüy lapac. At leaw nipilan ngo majiür, temanguiayiw aaga najneaj nanderac aton. ");
INSERT INTO huvNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Najneajay ajlüy leaw ngo machiw omeaats wüx xique ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Wüx laambüw minipilan Juan, quiaj Teat Jesús tapots mandeac masaj nipilan wüx a Juan, tapiüng: ―¿Cuane teamban mejawan tiül wajchiüca? ¿Teamban mejawan nots najchowa tenguial majowjow nej iünda? ");
INSERT INTO huvNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Ngwüy, cuane teamban mejawana? ¿Teamban mejawan nop naxey asooig najneajay apix neje? Cos icona ijawan leaw asooig najneajay apix nej najneaj ajlüy, ngo metam nej nicuajind, aag ayaj leaw almajlüy aniüng nop natang nenajiüt. ");
INSERT INTO huvNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Ngwüy, cuane teamban mejawana? ¿Teamban mejawan nop nendeac andeac Teat Diosa? Ajaj áag, naleaing nej nop nej nendeac andeac Teat Dios leaw alwüx atam. ");
INSERT INTO huvNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Cos andeac wüx a Juan aaga poch narangüch tiül Mipoch Teat Dios, niüng apiüng: Sanüüch mamb nop nendeac xepoch mamong ombas, teoj iliüc. Nej apmataag majneaj mitiiüd niüng apmemong. ");
INSERT INTO huvNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Naleaing sasaj icon, meáwan nipilan ngo maw tiül ni anop nendeac andeac Teat Dios majntsop wüx atam atnej atam aaga Juan neech yow nipilan. Pero naleaing, leawa más chingüy tiül micambaj Teat Dios, aag ayaj alwüx atam ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Meáwan nipilan, at monsap tomiün ocueaj cambaj, ajcüw ayaj leaw lamüüch nejiw yow a Juan, wüx tanguiayiw aag ayaj tandeacüw naleaing Teat Dios najneaj lamarang. ");
INSERT INTO huvNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Nganüy ajcüwa fariseos at mondüy wüx aaga poch tüünd Moisés ngo mayariw leaw Teat Dios tandiüm müüch nejiw, ngo mambüw müüch nejiw yow a Juan. ");
INSERT INTO huvNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Condom tapiüng Teat Jesús: ―¿Cuane at nejiw sanapiüng wüx ajcüwa nipilan monlüy nganüy cama? ");
INSERT INTO huvNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Aag ayaj at nejiw namix monguich montsoton tiül plas matsojow, tenguial masajüw aquiüjpüw nejiw: “Xicona tenguial saindean, icona ngo mejiüngan; nganüy tenguial sajiüntsan, icona ngo merangan amix imeajtsan mejiüntsan aton”, awüw. ");
INSERT INTO huvNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Tandeacas atquiaj cos wüx tiün a Juan neech yow nipilan, ngo müet pan ngo manganeow vin, icona tepiüngan nej alwüx ombas nej nimeech. ");
INSERT INTO huvNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Nganüy lapeay a Teat Naxey; nej net, anganeow aweaag jangantanej. Icona ipiüngan nej nerrombüy, nangüngün, ajlüyay maquiiüb monrang xeyay ngo majneaj, altiül monsap tomiün. ");
INSERT INTO huvNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Nganüy nipilan leaw Teat Dios üüch nejiw maxomüw omeajtsüw, ajcüw ayaj ajüic ajiürüw fis, ajawüw naleaing Teat Dios najneaj arang ―aw. ");
INSERT INTO huvNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Nop fariseo tasaj Teat Jesús mamb met aniüng nej, quiaj tamb. Alquiaj wüx mes teaüetiw. ");
INSERT INTO huvNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Quiaj ajngot nop najtaj nejiürjiür naxey, naw tiül aaga cambaj quiaj. Wüx nej tanguiay Teat Jesús alaniüng aaga fariseo, quiaj tapeay ajoy najmboc angan aceite, amb tiül noic iquial arangüch alabastro. ");
INSERT INTO huvNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Aaga najtaj tajiünts, tamb matüch oleaj Teat Jesús imiün wanopech. Condom tajants oleaj Teat Jesús naag miyow oniiüg nej, ndoj tajond naag miondeats omal nej, tacheecheech oleaj, cas tateng wüx najmboc angan aceite. ");
INSERT INTO huvNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Aaga fariseo nequiiüb Teat Jesús met aniüng nej, wüx tajaw aag ayaj tapiüng tiül omeaats nej: “Aag ayaj sitiül naleaing nop nendeac andeac Teat Dios, nej apmajaw jane aaga najtaj nesamb nej quiaj nguineay arang, cos nerang xeyay ngo majneaj”, aw. ");
INSERT INTO huvNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Condom Teat Jesús tasaj aaga fariseo: ―Teat Simón, sanasaj ic noic poch ―aj. Quiaj tapiüng a fariseo: ―Ipiüng teat ―aw. ");
INSERT INTO huvNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Quiaj tasaj nej Teat Jesús: ―Tajlüy nop naxey ajüchiw nej ijpüw monxey. Nop ajüch acoquiaw acoic miow (500) tomiün nasoic denario; alinop ajüch ic miow gajpowüw (50). ");
INSERT INTO huvNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ajcüwa monxey quiaj ngo majiürüw cuane mengüyayej ajüchiw. Quiaj tasaj nejiw aaga naxey ich majlüy, cos landoj lamawün wüx omeaats nej. Nganüy ipiüng ¿ngün tiül nejiw alwüx apmajneaj majaw aaga naxey quiaja? ―aj. ");
INSERT INTO huvNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Quiaj tapiüng a Simón: ―Xique sapiüng aaga nejüch nej xeyay ―aw. Quiaj tasaj nej Teat Jesús: ―Áag, naleaing ipiüng ―ajow. ");
INSERT INTO huvNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Quiaj ndiliteay Teat Jesús, wantsat majaw a najtaj, condom tasaj a Simón: ―¿Lamejaw aaga najtaj quiaja? Wüx tajmeliüs ningüy iniüng, ique ngome teaach xic yow nejantsüy xileaj; pero aaga najtaj cam naag miyow oniiüg nej tajants xileaj, ndoj tajond naag miondeats omal nej. ");
INSERT INTO huvNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ique ngo mecheech ximboy, pero aaga najtaj cam wǘxan tajmeliüs ningüy ngo macueat macheech xileaj. ");
INSERT INTO huvNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ique ngo mejend wüx ximal najmboc angan aceite, pero aaga najtaj cam lamajend wüx xileaj najmboc angan aceite. ");
INSERT INTO huvNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Pares sasaj ic, nganüy lanawün wüx ximeaats meáwan xeyay ngo majneaj tarang, cos xeyay ajiür xic lasta. Nganüy nop leaw apiüng napateay asoet nej najwan, aag ayaj ngo mandiüm xic xeyay ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Condom tasaj a najtaj: ―Isoet lanawün wüx ximeaats müm ―aj. ");
INSERT INTO huvNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Meáwan leaw alquiaj teaüetiw maquiüjpüw tapots andeacndeacüw wüx nejeyéjan quiaj, tapiüngüw: ―¿Jane aaga naxey quiaja? ¿Nguineay apiüng alndom mawün nisoete? ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Pero Teat Jesús tasaj a najtaj: ―Isoet lanawün wüx ximeaats. Quiür, ich mapac imeaats cos lameyar sandeac ―aj. ");
INSERT INTO huvNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Condom quiaj tamb Teat Jesús andüy tiül meáwan nadam cambaj at namix cambaj, aquiiüb ajcüw gajpiüp (12) minipilan nej, maquiaach wüx aaga najneaj nanderac wüx micambaj Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Aquiüjpüw acas montaj, ajcüw ayaj tamongoch nej iün andeowüw Teat Jesús, cuajantanej monandeow leaw taxom nejiw. Altiül nop María nasoic Magdalena, nej tajwan wüx ombas nej ayaíw nimeech. ");
INSERT INTO huvNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Alinop Juana mintaj Chuza najlüy wüx minajiüt Herodes; alinop Susana, at alacas montaj. Ajcüw ayaj tayacüw leaw alndom mayacüw mambeolüw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Noic nüt canchiütoj niüng ajlüy Teat Jesús xeyay nipilan, tapeayiw imiünüw nguiajantanej cambaj. Quiaj tasaj nejiw acas poch andüy wüx nepiür, tapiüng: ");
INSERT INTO huvNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―Tajlüy nop naxey tamb apiür. Wüx tenguial maripip osaab soex, acas tajmiüc andüy tiül tiiüd, tacuüüch nej tiüt nipilan, camüm majngotoj a quiec, taxomüw tüetiw. ");
INSERT INTO huvNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Altigüy tajmiüc tiül piedra, tajntsop, condom tawaag cos ngo masap acats a iüt. ");
INSERT INTO huvNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Altigüy tajmiüc tiül sats, tajntsop aweaag. Ndoj taxotüw tiüt a nine soex quiaj, tandeow. ");
INSERT INTO huvNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Altigüy tajmiüc tiül najneaj iüt, tajntsopiw, terangüy najneajay ―aw. Ndoj mapiüng ayaj, tasaj nejiw napac manguiayiw meáwan: ―Netam menguiayiün mexoman imeajtsan wüx leaw sandeac quiaj ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Minipilan nej tatüniw manguiayiw, tapiüngüw: ―¿Cuane wüx apiüng aaga indeac quiaja? ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Nej tasaj nejiw: ―Icona ijndean menguiayiün nguineay alndom majlüyeran tiül minipilan Teat Dios, pero pálwüx nipilan ngome apmasoiquiw aleáingan; atquiaj masey majawüw, atnej ngo majawüw. Masey manguiayiw, naleaing ngo majawüw cuane wüx andeac ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Condom quiaj tasaj nejiw: ―Sanasaj icon cuane wüx apiüng aaga nanderac quiaj: Osaab soex, aag ayaj Mipoch Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ajcüwa osaab soex leawa najmiüc tiül tiiüd, ajcüw ayaj atnej nipilan leaw anguiay Mipoch Teat Dios; condom aliüc minatang nimeech mawün tiül omeajtsüw nejiw. Atquiaj lango mayariw leawa tanguiayiw, lango mawüw wüx asoetiw nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Nganüy aaga osaab soex najmiüc tiül piedra, aag ayaj apiüng wüx nipilan leaw anguiay Mipoch Teat Dios, ajüic xeyay tapac omeaats tayariw. Naleaing aaga nipilan quiaj ajlüy atnej nine soex napateay mioxiich nej, ngome apmaíüc; cos acásan nüt apmanguiayiw Mipoch Teat Dios, camüm majlüy alngün naél, quiaj macueatiw. ");
INSERT INTO huvNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Átan aaga osaab soex najmiüc tiül sats, aag ayaj apiüng wüx nipilan anguiay Mipoch Teat Dios; nejiw ayacüw omeajtsüw wüx andiümdiümüw cuajantanej leaw najlüy wüx aaga iüt cam. Wüx aag ayaj ngo müüch nejiw mandüjpiw leaw lamanguiayiw. Ngo mambeol nejiw nicuajind, lacüliw miün. ");
INSERT INTO huvNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Nganüy aaga osaab soex leaw najmiüc tiül najneaj iüt, aag ayaj apiüng wüx nipilan anguiay Mipoch Teat Dios, ayacüw wüx omeajtsüw. Aaga poch ambeol nejiw marangüw leaw andiüm Teat Dios, tanaámb ngo macueatiw ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Condom tasaj nejiw alinoic: ―Nejinguind ngo machen noic candil ndójan lamapal omal, at ngo matool tiüt teoleaj mats; netam mayac cawüx marraj, atquiaj jangantanej apmajmel alndom maxom majaw. ");
INSERT INTO huvNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Cos meáwan leaw naxotaran apmajüic, at meáwan leaw nexotüy apmajaraw, apmajüic ranüy. ");
INSERT INTO huvNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’Nganüy ijchan ilajcan inguiayiün, sitiül aljane ayac wüx omeaats xepoch, apmüünd manguiay altigüy. Pero sitiül nop ngome ayac wüx omeaats, aaga quiriw anguiay quiaj apndrom omeaats, ngome apmambeol nej nicuajind ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Condom tapeay mimüm nej Teat Jesús, at michiig nej; naleaing ngondom matüchiw niüng ajlüy nej cos xeyay nipilan. ");
INSERT INTO huvNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Quiaj tasoic Teat Jesús: ―Teat, mimüm at michiig aliw ninguiaj, andiümüw mendeacüw mequiüjpüw ―ajow. ");
INSERT INTO huvNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Quiaj tasaj nejiw Teat Jesús, tapiüng: ―Meáwan leaw nenguiay Mipoch Teat Dios, sitiül marang atnej anguiay, aag ayaj sayaag atnej xemüm, atnej xechiig ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Alinoic nüt Teat Jesús tajtep tiül müx maquiiüb minipilan nej, tasaj nejiw: ―Tabaats andüyiiüts necamb aaga nadam yow cam ―aj nejiw. Quiaj tambüw. ");
INSERT INTO huvNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Wǘxan tenguial ajüy a müx Teat Jesús tameay. Quiaj taw noic nadam iünd anasop a ndec maxaing. Aaga müx laliüc tsoyom tiüt cos tamelich yow. Nejiw lamapiüngüw apmandeowüw. ");
INSERT INTO huvNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Quiaj tapacüjchiw a Teat Jesús, tasajüw: ―¡Teat! ¡Teat! ¡Laliüc tsoyomoots tiüt! ―awüw. Quiaj witiüt Teat Jesús, tasaj a iünd lombom, at omal yow majlǘyan. Quiaj lambat, ayac ndar a yow. ");
INSERT INTO huvNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Condom tasaj nejiw: ―¿Neol, wül ipiüngan lamejawan nguineay xique alndom narang cuajantaneje? ―aj nejiw. Nejiw mbayajow majawüw leawa lamarang Teat Jesús. Tesajayej nop alinop, tapiüngüw: ―¿Jane aaga teat naxey quiaja? cos wüx tasaj a iünd maquiiüb a yow majlüyiw miün, quiaj tajlüyiw miün ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Condom tajtepiw wüx iüt tiül Gadara, necamb aaga nadam yow alareng Galilea. ");
INSERT INTO huvNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Wüx taw tiüt imiün tiül müx Teat Jesús, quiaj ajngot nop naxey miotáagan mangoch nej, naw quiaj tiül aaga cambaj quiaj. Lamajiür nüt acüliw wüx ombas nej nimeech. Aton ngo macül aniüng nej, acǘlan tiül niüng amiüraad mondeow. ");
INSERT INTO huvNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Aaga naxey quiaj wüx tajaw Teat Jesús tepaj napac, ndoj tamb maquieel micos nej niüng ajlüy, tendeac napac: ―¿Cuane indiüm merang wüx ximbas a ique, Jesús Micual Teat Dios najlüy tiül cielo? Satün icueaj, nde merang wüx ximbas nicuajind ―aw. ");
INSERT INTO huvNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Cos Teat Jesús lamasaj nimeech maw wüx ombas aaga naxey quiaj. Aaga naxey quiaj lamajiür xeyay nüt acül wüx ombas nej aaga nimeech. Masey landeaaw maoelich naag galen, ayacüw tiül oleaj nej aton. Nej andooigndóoigan, ndoj lamacuarreech nej nimeech andüy tiül wajchiüc. ");
INSERT INTO huvNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Quiaj tatün nej manguiay Teat Jesús: ―¿Cuane minüt? ―aj. Nej tapiüng: ―Legión xenüt ―aw. Tapiüng atquiaj cos xeyay nimeech alwüx ombas nej. ");
INSERT INTO huvNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Condom nimeech tatüniw ocueaj nej nde mayac nejiw tiül biümb. ");
INSERT INTO huvNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Aleambüw quiaj tüeng tiüc noic ajlüy sow teayambüw üetiw. Quiaj a nimeech tasajüw Teat Jesús müüch nejiw mambüw andüyiw tiül sow. Quiaj tüüch nejiw mambüw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Tacueatiw aaga naxey, tambüw majmeliw tiül a sow. Quiaj tecuiürrüw a sow ambüw wüx tiüc, tajmiücüw tiül yow, tümb mandeowüw. ");
INSERT INTO huvNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ajcüwa monjiür sow wüx tajawüw aag ayaj mbayajow acuiürrüw tambüw mapiüngüw tiül cambaj masajüw nipilan nguiajantanej. ");
INSERT INTO huvNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Quiaj tambüw meáwan nipilan majawüw cuane najlüy. Wüx tapeayiw niüng ajlüy Teat Jesús, quiaj tajawüw aaga naxey laáw wüx ombas nej nimeech alchetem niüng ajlüy Teat Jesús. Almasooig apix, lajneaj, lamajiür fis. Mbayajow majawüw. ");
INSERT INTO huvNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Leaw alquiaj tajawüw nguineay tajlüy. Nejiw tasajüw nipilan nguineay tajneaj aaga naxey alwüx ombas nimeech. ");
INSERT INTO huvNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ajcüwa nipilan monaw tiül aaga iüt Gadara tasajüw Teat Jesús maw quiaj, cos xeyay imboloj mandüyiw. Quiaj Teat Jesús tajtep tiül müx alinomb, tawüw quiaj. ");
INSERT INTO huvNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Aaga naxey laáw wüx ombas nej nimeech quiaj, tapots masaj Teat Jesús maquiiüb nej mamb. Quiaj Teat Jesús tasaj nej macül, tasaj: ");
INSERT INTO huvNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―Indilil, ijtsor indeac meáwan najneaj leaw lamarang wüx imbas Teat Dios ―aj. Quiaj tajtsor aaga naxey. Tapots mandeac meáwan tiül a cambaj nguineay najneaj lamarang wüx ombas nej Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Wüx Teat Jesús tandilil andüy necamb aaga nadam yow, xeyay nipilan tangochiw nej. Apac omeajtsüw majawüw cos teamacüliw nej. ");
INSERT INTO huvNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Condom tamb majaw nej nop naxey nenüt Jairo; nej nop natang tiül sinagoga. Taquieel micos nej niüng ajlüy Teat Jesús, tatün ocueaj mamb aniüng nej. ");
INSERT INTO huvNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Cos xeyay iün andeow micual nej, laliüc mandeow. Ajcánan nop nüx ajiür, lamajiür maseyme gajpic (12) mineat nej. Condom wüx tamb Teat Jesús, xeyay nipilan acharrayej wüx ombas nej. ");
INSERT INTO huvNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Altiül nop müm najtaj lamajiür gajpic neat iün andeow, atsambiich nej miquiej nej. Lamandrooch wüx xeyay tomiün mangüy mondüy. Laímb meáwan leaw almajiür, pero nejinguind ngondom mamongoch nej iün andeow. ");
INSERT INTO huvNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Aaga najtaj quiaj tamb amb wanopech Teat Jesús marreeg apix. Andǘüban lomboj atsambiich nej miquiej nej. ");
INSERT INTO huvNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Quiaj tapiüng Teat Jesús: ―¿Jane nerreeg xic? ―aw. Meáwan nipilan tapiüngüw ngome nejiw. Quiaj teat Pedro y leaw almaquiiüb tapiüngüw: ―Teat, nipilan teamacharrüw ic, teamapatsüw ic, nganüy ipiüng: “¿Jane nerreeg xic?” meraw ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Teat Jesús tapiüng: ―Aljane tarreeg xic, cos sayaag aljane lajneaj iün andeow ―aw. ");
INSERT INTO huvNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Aaga müm najtaj wüx tajaw ngondom maxot aag ayaj, quiaj tiün anmambeapmbeap nej, taquieel micos nej niüng ajlüy Teat Jesús. Quiaj tapots mapiüng manguiay meáwan nipilan neol tarreeg Teat Jesús, at nguineay tajneaj iün andeow nej. ");
INSERT INTO huvNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Quiaj tasaj nej Teat Jesús: ―Quiür xecual, ich mapac imeaats, nganüy lerneaj cos teyar sandeac ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Teat Jesús tealeámban mandeac aag ayaj, quiaj ajngot nop imiün aniüng Jairo, aaga natang tiül sinagoga, tasaj a Jairo: ―Teat, landeow micual, icueat mesajsaj mamb a Teat Naxey ―aw. ");
INSERT INTO huvNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Teat Jesús wüx tanguiay aag ayaj, quiaj tasaj aaga naxey: ―Nde mbayamear, iyar sandeac, apmajneaj micual ―aj. ");
INSERT INTO huvNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Wüx tapeay aniüng aaga naxey quiaj, ngo müüch majmel nejinguind, áagan a Pedro, Jacobo, Juan; at miteat nej, mimüm nej aaga nüx landeow quiaj tajmeliw. ");
INSERT INTO huvNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Meáwan nipilan teajiüntsüw wüx, teapajüw wüx aaga nandeow quiaj. Quiaj tasaj nejiw Teat Jesús: ―Nde mejiüntsan cos ngome landeow, almameay ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Nejiw itsojayéjan cos ajawüw naleaing landeow. ");
INSERT INTO huvNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Quiaj Teat Jesús tasap owix a nüx, tasaj napac: ―Xecual, witiür ―aj. ");
INSERT INTO huvNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Quiaj tapac alinomb. Najénan witiüt. Condom Teat Jesús tasaj nejiw mayambüw üet a nüx quiaj. ");
INSERT INTO huvNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Miteat nej mimüm nej a nüx lambayajow. Teat Jesús tasaj nejiw nde masajüw nejinguind wüx aag ayaj. ");
INSERT INTO huvNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Condom Teat Jesús taxejneng a gajpiüp (12) minipilan nej. Tüüch nejiw ndom ombasüw masajüw nimeech maw wüx ombas nipilan, aton matajcüw majneaj moniün andeow. ");
INSERT INTO huvNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Tasaj nejiw mambüw mandeacüw nguineay ajlüy tiül micambaj Teat Dios; aton tüüch ndom ombasüw mamongochiw iün andeow nipilan. ");
INSERT INTO huvNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Condom tasaj nejiw: ―Nde mejoyiün nicuajind leaw netam icon tiül tiiüd, nde mejoyiün nangoraad, morral, peats, tomiün. Aton nde mejoyiün ijquiaw camix. ");
INSERT INTO huvNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Aton jangantanej aniüng mejmeliün icülíünan quiaj, naw quiaj apmeriowan. ");
INSERT INTO huvNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ngünantanej cambaj niüng ngo mandiümüw icon, iriowan quiaj tiül aaga cambaj quiaj. Itajtan minajndot ileajiün majüic nejiw ngo majneaj arangüw ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Quiaj tambüw tamongoj tiül meáwan nine cambaj mandeacüw wüx aaga najneaj nanderac, nguineay apmaw asoeteran; aton tajtajcüw majneaj moniün andeow nguiajantanej tamongoj. ");
INSERT INTO huvNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Aaga natang nenajiüt tiül aaga iüt quiaj nenüt Herodes, wüx tanguiay meáwan nguineay arang Teat Jesús, lango majaw ngün naleaing, cos altiül apiüngüw aaga Juan neech yow nipilan lapac laáw tiül mondeow. ");
INSERT INTO huvNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Altiül tapiüngüw mixejchiiüts Elías landilil. Altiül tapiüngüw aag ayaj alinop nendeac andeac Teat Dios leawa tajlüy tanomb lapac, awüw. ");
INSERT INTO huvNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Pero Herodes tapiüng: ―Aaga Juan xique tüjchiüs mamb ndojquiüm onic nej. ¿Jane nganüy teananguiay arang xeyay cuajantanej quiaja? ―aw. Tandiüm majaw jane. ");
INSERT INTO huvNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Wüx tandilileaw miapóstoles nej tapots masajüw Teat Jesús meáwan nguineay tarangüw. Condom taquiiüb nejiw mamb tiül wajchiüc niüng ngo majlüy nejinguind, tiül iüt ocueaj noic cambaj nenüt Betsaida. ");
INSERT INTO huvNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Nipilan wüx tajawüw laámb tandüjpiw mamb. Wüx tapeayiw niüng ajlüy Teat Jesús nej tajiür nejiw lasta. Condom tapots mandeac masaj nejiw nguineay alndom majlüyiw tiül minipilan Teat Dios. Aton tamongoch iün andeow leaw niün andeow. ");
INSERT INTO huvNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Wüx laquinüt aaga nüt quiaj, ajcüw minipilan nej tambüw matüchiw Teat Jesús, tasajüw: ―Teat, isajüw a nipilan mambüw andüyiw tiül cambaj, tiül rünch mayambüw nguiane apmaxojtüw, aton mayambüw cuane apmüetiw, cos tiül wajchiüc almajlüyiiüts cam ―ajüw. ");
INSERT INTO huvNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Quiaj Teat Jesús tasaj nejiw: ―Ngwüy, icona netam meyamban üetiw ―aj nejiw. Nejiw tapiüngüw: ―Teat, ngo najiüran cuane sanüjchiün, ajcánan acoquiaw pan alijpüw cüet alningüy. ¿Ngwüy sanambana nangalan nüeteran müetiw meáwan nipilan quiaja? ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Cos atüch maseyme acoquiaw mil monxey. Condom Teat Jesús tasaj minipilan nej: ―Isajan a nipilan chetemoj, ic miow gajpowüw (50) noicnoic ajlüy ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Atquiaj tarangüw, tasajüw nipilan chetemoj. ");
INSERT INTO huvNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Condom Teat Jesús tayar acoquiaw pan alijpüw cüet. Ndoj taxaing omal majaw cawüx, tüüch gracias Teat Dios, ndoj tambaag, tüüch minipilan nej majineaw müjchiw meáwan nipilan. ");
INSERT INTO huvNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Meáwan nipilan tetiw paxiün, condom leaw tenaw taxainguiw gajpiüp nchep. ");
INSERT INTO huvNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Noic nüt Teat Jesús teandeac aweaag Teat Dios, ataag orar néjan quiaj; minipilan nej alíwan quiaj maquiüjpüw. Condom nej tatün manguiay nejiw: ―¿Cuane apiüngüw nipilan jane xic? ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Nejiw tasajüw: ―Altiül nipilan apiüngüw Juan, aaga neech yow nipilan. Altiül apiüngüw Teat Elías; altiül apiüngüw alngün nendeac andeac Teat Dios najlüy tanomb lapac. Atquiaj apiüngüw ―ajüw. ");
INSERT INTO huvNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Condom tatün manguiay nejiw alinomb: ―¿Jow icona, cuane ipiüngan jane xic? ―aj nejiw. Quiaj tapiüng a Pedro: ―Ique aaga Cristo ocueaj Teat Dios ―aw. ");
INSERT INTO huvNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Teat Jesús tasaj nejiw nde masajüw nejinguind jane nej. ");
INSERT INTO huvNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","At aton tasaj nejiw: ―Aaga Teat Naxey netam mamongoch xeyay ngo majneaj. Apmajcüy majaw nej montangtang tiül judíos, at montangtang miteaats, at ajcüw mondüy wüx aaga poch tüünd Moisés aton. Ndójwüx apmambiyaw nej. Pero naleaing wüx er nüt nej apmapac alinomb ―aw. ");
INSERT INTO huvNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Condom tasaj meáwan leaw aliw quiaj: ―Sitiül aljane andiüm mandüüb xic mayar sandeac, ich mawün wüx omeaats leawa nej andiüm marang. Ich mandüüb wüx leaw sarang masey mamongoch xeyay naél meáwan nüt; masey mambiyaw nej wüx cruz cos ayar sandeac. ");
INSERT INTO huvNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Sitiül aljane ngo mayar sandeac ajcan imbol mambiyaw nej nipilan, alinoic nüt nej ngome apmamb tiül cielo. Pero sitiül aljane ngo mapiüng wüx masey mandeow cos ayar sandeac, alinoic nüt najneajay apmajlüy tiül cielo. ");
INSERT INTO huvNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","¿Jondot sitiül aljane maneay meáwan cuajantanej leaw almajlüy wüx iüt cam, cuane ambich sitiül nej apndrom ombas, lango mamb tiül cielo? ");
INSERT INTO huvNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Cos sitiül aljane ngo mayar sandeac, axing mitsoj nej nipilan wüx xique, at wüx xepoch; atquiaj a Teat Naxey aton apmaxing majaw nej wüx aliüc imiün tiül cielo, aquiiüb miün xeyay nelitlit, ranüy, najneajay ocueaj Teat Dios, at ocueaj nangaj miángeles nej. ");
INSERT INTO huvNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Naleaing sasaj icon alningüy acas tiül icona aliün mapacüw apmajawüw a Teat Naxey niüng arang natang nenajiüt ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Condom ajíüran ojpeacüw nüt tatow ndoj mandeac aaga poch quiaj, quiaj taquiiüb a Pedro, Juan, at a Jacobo, tajtepiw wüx nop tiüc, tamb mataag orar. ");
INSERT INTO huvNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Wüx teataag orar Teat Jesús, quiaj tajawüw mitey nej langome atnej, at apix nej rajnüy, xowüy lalitlit. ");
INSERT INTO huvNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Camüm majawüw, alquiaj mixejchiw nejiw leaw monlüy tanomb, ajcüw ayaj teat Moisés maquiiüb a teat Elías, teandeacüw maquiüjpüw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Niüng alembemoj xowüy lajneaj, ayey nejiw tiüt a ran. Teamandeacüw wüx leaw apmamongoch Teat Jesús wüx apmandeow tiül Jerusalén. ");
INSERT INTO huvNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Teat Pedro, at aquiüjpüw nej xeyay laínd ameayiw, pero tapacüw wüx tajawüw aaga ran xowüy lajneaj niüng ajlüy Teat Jesús maquiiüb ajcüwa ijpüw monxey quiaj. ");
INSERT INTO huvNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Moisés ata Elías laámb apmawüw niüng ajlüy Teat Jesús, quiaj tapiüng a Pedro: ―Teat, najneaj macüliiüts ningüy narangan arej nden, noic ineay, noic aneay teat Moisés, alinoic aneay teat Elías ―aw. Atquiaj tapiüng a Pedro cos lango majaw cuane apmapiüng. ");
INSERT INTO huvNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Tenguialeámban mandeac aag ayaj, quiaj pojniüt, taxot nejiw noic oic. Xeyay timboloj wüx tajawüw aliw tiül oic. ");
INSERT INTO huvNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Condom quiaj tanguiayiw noic nanderac imiün tiül oic, tapiüng: ―Aag ayaj xecual xeyay sandiüm; inguiayiün, iyacan wüx imeajtsan leaw andeac nej ―aw. ");
INSERT INTO huvNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Wüx landoj andeac a nendeac, quiaj tajawüw a Teat Jesús néjan. Nejiw ngo mapiüngüw nicuajind. Tacül acas nüt nejinguind ngo mandeacüw wüx leaw tajawüw. ");
INSERT INTO huvNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Raw tiüt alinoic nüt wüx tawüw tiüt imiünüw wüx tiüc, xeyay nipilan tambüw mangochiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Nop naxey naw tiül aaga xeyay nipilan quiaj tendeac napac, tapiüng: ―Teat, satün icueaj meamb mejaw xecual ajcánan sajiür. ");
INSERT INTO huvNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Alwüx ombas nej nimeech. Nguiaj aaga nimeech xeyay üüch nej mepajpaj, ambeapmbeap nej, awün nej teombeay popox. Xeyay ngo majneaj lamarang nej, nómban ngo macueat nej. ");
INSERT INTO huvNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Xique tasajasüw minipilan mawüniw a nimeech wüx ombas nej, pero ngondom ombasüw ―aw a naxey. ");
INSERT INTO huvNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Quiaj tapiüng Teat Jesús: ―¡Neol icona nipilan ngo meyariün sandeac, icona monrang ngo majneaj! ¿Cas nüt ipiüngan sanacül naquiiüb icon, naíüc wüx leaw irangan quiaj? ―aw. Condom tasaj a naxey: ―Iquiiüb miün micual, teat ―aj. ");
INSERT INTO huvNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Wüx tenguial ajüy aaga nench quiaj matüch niüng ajlüy Teat Jesús, quiaj tambeapmbeap nej alinomb. Aaga nimeech alwüx ombas nej talox nej tiüt. Teat Jesús talic a nimeech quiaj, maw macueat; quiaj tajneaj aaga nench. Condom tüüch mamb maquiiüb miteat nej alinomb. ");
INSERT INTO huvNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Meáwan nipilan leaw alquiaj mbayatoj majawüw nguineay xeyay najneaj lamarang Teat Dios. Tealeámban mbayajow nipilan majawüw meáwan leaw lamarang Teat Jesús, quiaj tasaj minipilan nej: ");
INSERT INTO huvNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―Iyacan wüx imeajtsan aaga poch sanasaj icon cam, cos Teat Naxey apmayacüch teowixaw nipilan ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Naleaing minipilan nej ngo majawüw cuane wüx asoiquiw quiaj, cos ngo müjndiw majawüw, aton cos nejiw axinguiaw matüniw manguiayiw wüx aaga poch quiaj. ");
INSERT INTO huvNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Condom minipilan nej tapots andeacndeacüw wüx mapiüngüw jane apmarang natang. ");
INSERT INTO huvNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Naleaing Teat Jesús tajaw cuane teamapiüngüw tiül omeajtsüw nejiw. Quiaj taxaing nop nine mayac niüng ajlüy nej. ");
INSERT INTO huvNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Condom tasaj nejiw: ―Jangantanej leaw apmajiür lasta aaga nine cam, aag ayaj atnej teamajiür xic lasta; jangantanej leaw ajiür xic lasta, aag ayaj ajiür lasta neech xic niün. Cos jane chingüy tiül icona, aag ayaj natang ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Condom quiaj tasaj nej a Juan: ―Teat, tajawasan nop naxey teamapaj minüt wüx tawün nimeech wüx ombas nipilan, lanasajan macueat cos ngome aquiüjpaats ―aj. ");
INSERT INTO huvNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Quiaj tasaj nej Teat Jesús: ―Ich majlüy, nde mepalan cos sitiül nop ngo majcüy majaw icoots, najneaj majaw icoots ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Wüx lamatüch a nüt mamb Teat Jesús andüy tiül cielo, quiaj tapiüng netam mamb Jerusalén. ");
INSERT INTO huvNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Quiaj tüüch mamb acas mambüw ombas nejiw. Ajcüw ayaj tambüw tatüchiw tiül noic nine cambaj tiül iüt Samaria mayambüw niüng apmaxojtüw. ");
INSERT INTO huvNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Naleaing ajcüwa nipilan monaw quiaj ngome tandiümüw müjchiw maxojtüw quiaj Teat Jesús cos tajawüw andüyiw Jerusalén apmambüw. ");
INSERT INTO huvNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Minipilan nej, aaga Jacobo maquiiüb a Juan wüx tajawüw aag ayaj, quiaj tasajüw Teat Jesús: ―Teat, ¿indiüm natüniün biümb imiün tiül cielo atnej nomb tarang mixejchiiüts Elíasa, mandajpüw ajcüwa nipilan quiaja? ―ajüw. ");
INSERT INTO huvNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Quiaj ndiliteay Teat Jesús majaw nejiw, talic nejiw, tapiüng: ―Icona ngo mejawan cuane teamendeacan. ");
INSERT INTO huvNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Cos Teat Naxey ngo miün mandrooch ombasüw nipilan, nej tiün mawün wüx nipilan ―aw. Quiaj tambüw tandüyiw tiül alinoic cambaj. ");
INSERT INTO huvNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Condom wüx aleambüw tiül tiiüd tajngot nop naxey masaj Teat Jesús: ―Teat, sanamb nguiajantanej niüng apmeamb ―aj. ");
INSERT INTO huvNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Quiaj tasaj nej Teat Jesús: ―Wiül ajiürüw ombiümüw, at a quiec ajiürüw; nganüy a Teat Naxey ngo majiür nguiane alndom maxood ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Condom tasaj alinop: ―Mac, indüüb xic, tabar ―aj. Aaga nasoic quiaj tapiüng: ―Teat, sanamb nacül leaw andeow xeteat, namiüt; ndoj sanandüüb ic narang leaw ipiüng ―aw. ");
INSERT INTO huvNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Teat Jesús tasaj nej: ―Icueat, ich majlüy ich memiütayej. Ique quiür indeac wüx nguineay alndom majlüyeran tiül micambaj Teat Dios ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Condom tapiüng alinop: ―Sanamb teat, nguiajantanej niüng apmeamb, pero netam namb saniüng nasajüw manguiayiw ―aw. ");
INSERT INTO huvNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Quiaj tasaj nej Teat Jesús: ―¿Sitiül nop nechiüt iüt almasap owix arada, andüy wanopech teamajaw, nguineay apmarang najneaja? Aag ayaj ngondom majmel tiül micambaj Teat Dios ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Wüx landoj aag ayaj, Teat Jesús tawün er miow gajpowüw (70) minipilan nej. Ajcüw ayaj tüüch mambüw ijpüwpüw ombas nejiw tiül meáwan cambaj leaw niüng nej apmamb. ");
INSERT INTO huvNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ndoj tasaj nejiw: ―Xeyay najiüt ajlüy, pero monrang najiüt napateay. Itüniün ocueaj a Teat Naxey neneay najiüt, müüch miün monrang najiüt. ");
INSERT INTO huvNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Quiüran; xique süüch icon meamban at icon sap indüyiün tiül tegüy sampüy. ");
INSERT INTO huvNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Nde mejoyiün morral, iquial tomiün, at napüic; nde lomblombomeron metepeayiün jangantanej tiül tiiüd. ");
INSERT INTO huvNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ngünantanej nden niüng apmejmeliün, ombas mertepeayiün, itüniün monapacüy. ");
INSERT INTO huvNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Sitiül alquiaj aljane ajüic najneaj omeaats majaw icon, indeacan najneaj mequiüjpan; pero sitiül ngwüy, nde mendeacan mequiüjpan xeyay. ");
INSERT INTO huvNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Icüliün tiül aaga nden quiaj, itean, inganeowan leaw apmeajndiün quiaj, cos nop nerang najiüt netam müünd üet nej. Nde meamban mejüyjüyiün tiül ngünantanej nden. ");
INSERT INTO huvNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Nguiajantanej cambaj niüng apmejmeliün sitiül apmangochiw icon najneájan, itean leaw apmeajndiün meatiün. ");
INSERT INTO huvNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Aton imongochiün iün andeow moniün andeow leaw almajlüy tiül aaga cambaj quiaj, at isajan nipilan: “Nganüy laliüc ndom mejmeliün tiül micambaj Teat Dios”, irajan. ");
INSERT INTO huvNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Pero nguiajantanej cambaj niüng apmejmeliün, sitiül ngo mangochiw icon najneaj, wüx apmeriowan ilean tiül calle, isajan nipilan: ");
INSERT INTO huvNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Leaw najndot najlüy ningüy tiül micambajan ngo nandiüman macül wüx xileajiün nicuajind; satajtan majüic ngo majneaj irangan. Pero ich leaam imeajtsan teajndiün mejmeliün tiül micambaj Teat Dios”, irajan. ");
INSERT INTO huvNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Xique sasaj icon, wüx apmajaraw wüx asoet nipilan, napateay quiriw ngo majneaj leaw apmamongochiw nipilan tajlüyiw tiül cambaj Sodoma, ngo matnej aaga cambaj niüng ngo mangochiw icon najneaj. ");
INSERT INTO huvNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","’¡Jaa, icona monaw tiül cambaj Corazín! ¡Jaa, icona monaw tiül cambaj Betsaida! ¿Neol ngo meyariün sandeaca? Cos jondot tiül cambaj Tiro y Sidón tarangüch meáwan ateócan leaw tarangüch tiül icona mejawan, catsats tsotojow tiül ngwiat masoijquiw nambeor apixaw nejiw, majüiquichaw leaam omeajtsüw wüx meáwan ngo majneaj tarangüw. ");
INSERT INTO huvNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Áag sasaj icon, alinoic nüt wüx Teat Dios apmajaw wüx asoeteran, napateay ngo majneaj apmamongochiw monaw Tiro maquiiüb Sidón, ngo mat icona. ");
INSERT INTO huvNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","At icona monaw tiül cambaj Capernaum, ¿iyajcan icona apmeamban tiül cielo? ¡Niquimas! Cos aleáingan apmejlosan tiül aaga xeyay ngo majneaj tiül Hades ―aw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ndoj tasaj minipilan nej: ―Nganüy sasaj icon, leaw apmanguiay indeacan, aag ayaj atnej anguiay sandeac; leaw ngo mandiümüw manguiayiw indeacan, ngo mandiümüw xic aton. Leaw ngo mandiüm xic, ngo mandiüm aaga neech xic niün aton ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Wüx tandilileaw ajcüwa er miow gajpowüw (70) quiaj, apac omeajtsüw, tasajüw Teat Jesús: ―Teat, wüx minüt ique ajcüwa nimeech ayariw sandeacan ―ajüw. ");
INSERT INTO huvNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Quiaj tasaj nejiw Teat Jesús: ―Xique tajawas ajmiüc a Satanás atnej ajlip imiün tiül cielo. ");
INSERT INTO huvNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Xique nganüy lanüüch icon mecuüjchiün tiüt ndiüc tengwüy napüp. Masey moncüy majaw icoots apmarangüw leaw andiümüw, icona ngome apmarang icon nicuajind. ");
INSERT INTO huvNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Naleaing nde mapac imeajtsan ajcan imboloj mandüyiw icon nimeech ayariw indeacan; ngwüy, ich mapac imeajtsan cos minütiün lajlüy tiül cielo ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ores quiaj aaga Nangaj Espíritu tüüch Teat Jesús mapac omeaats. Teat Jesús tapiüng: ―Xique sasaj ic apac ximeaats wüx ique Teat, ique natang nenajiüt tiül cielo at wüx iüt, cos meáwan leaw lajlüy texot, ngo meaach majawüw mondüy monxom omeaats. Nganüy lameaach majawüw ajcüwa atnej nine monguich quiaj. Atquiaj ajlüy, Teat, cos atquiaj indiüm ―aw. ");
INSERT INTO huvNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Condom tapiüng: ―Meáwan cuajantanej tüjndiüs, üüch xic Xeteat; nejinguind ngo majaw jane aaga micual nej, áagan Xeteat Dios nejaw. Aton nejinguind ngo majaw jane nej Xeteat Dios, áagan micual nej ajaw; at leaw andiüm müüch nej majaw ―aw. ");
INSERT INTO huvNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Condom Teat Jesús wantsat majaw minipilan nej, quiaj tasaj nejiw: ―Najneajay ajlüy jangantanej leaw axom majaw leaw icona ixoman mejawan nganüy. ");
INSERT INTO huvNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Cos naleaing sasaj icon, xeyay mondeac andeac Teat Dios at montangtang monajiüt tandiümüw majawüw leaw lamejawan; naleaing taton ngo majawüw. Tandiümüw manguiayiw leaw lamenguiayiün; naleaing taton ngo manguiayiw ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Alquiaj nop nequiaach wüx aaga poch tüünd Moisés, witiüt matün manguiay majaw cuane apmapiüng Teat Jesús, tasaj: ―Teat ¿cuane netam naranga, nguineay alndom namb tiül cielo napac meáwan nüte? ―aj. ");
INSERT INTO huvNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Teat Jesús tasaj nej: ―¿Cuane apiüng tiül aaga poch tüünd Moisésa? ¿Nguineay iyaag? ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Aaga naxey tasaj nej: ―Netam mendiüm Teat Dios con imeaats, con ipacüy, con mifis; aton netam mejiür lasta jangantanej atnej ijiürüy lasta iquiáyan quiaj ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Quiaj tasaj nej Teat Jesús: ―Najneaj aag ipiüng quiaj. Sitiül atquiaj apmerang apmeamb tiül cielo niüng apmepac meáwan nüt ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Nej aaga naxey tandiüm majüiquich arang meáwan aag ayaj, quiaj tasaj Teat Jesús: ―¿Jane alinop apiüng netam majiürüch lasta quiaja? ―aj. ");
INSERT INTO huvNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Quiaj tasaj nej Teat Jesús: ―Nop naxey imiün Jerusalén andüy Jericó taxom nej need tiül tiiüd, tanejtiw nej ocueaj meáwan leaw almajoy, tawüjchiw nej, laliüc mandeow tacueatiw. ");
INSERT INTO huvNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Condom tamong quiaj nop miteaats amb tiül a tiiüd quiaj. Wüx tajaw alpiiüm aaga naxey quiaj, tayey tiüt tamong. ");
INSERT INTO huvNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Camüm tamong quiaj nop nembeol miteaats ajcüw nasoic levita. Átan wüx tatüch quiaj majaw alpiiüm a naxey, tamóngan aton. ");
INSERT INTO huvNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ndoj tajngot nop naxey naw Samaria aleamb tiül aaga tiiüd quiaj. Wüx tajaw a naxey, xeyay tajiür lasta. ");
INSERT INTO huvNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Quiaj tamb matüch, tayac aceite, tayac a vin wüx aaga necoy quiaj. Condom taóel, cas taxaing mayac wüx mibur nej. Taquiiüb mamb andüy niüng axoodaran; tacül quiaj majaw. ");
INSERT INTO huvNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Aw alinoic nüt wüx taw quiaj, tawün ijquiaw tomiün nenüt denario, tüüch neneay nden niüng axoodaran. Ndoj tasaj: “Ijaw ningüy xicueaj, sitiül aleaic tetam, iyamb ocueaj nej. Xique sanangüy icueaj leaw sapeay”, aj. ");
INSERT INTO huvNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Tiül aaga arojpüw quiaj, ¿jane ajüic tajiür lasta aaga naxey tajlüy mambiy nej need quiaja? ―aj nej Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Condom aaga nequiaach wüx aaga poch tüünd Moisés tapiüng: ―Pues aaga tambeol nej ―aw. Quiaj tasaj nej Teat Jesús: ―Quiür a ique irang atnej aton ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Teat Jesús wüx tatüch tiül noic cambaj, alquiaj nop najtaj nenüt Marta. Tüüch nejiw maxojtüw aniüng nej. ");
INSERT INTO huvNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Aaga Marta quiaj, almajiür nop michiig nej nenüt María. María tamb chetem niüng ajlüy Teat Jesús manguiay andeac. ");
INSERT INTO huvNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Naleaing Marta tenguial amb wüx omeaats meáwan leaw teamarang tinden. Condom tamb matüch Teat Jesús masaj: ―Teat, ¿najneaj mejaw arang xechiig quiaja? Cos acueátan xic wüx narang xenajiütan. Isaj mambeol xic, Teat ―aj. ");
INSERT INTO huvNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Quiaj tasaj nej Teat Jesús: ―Marta, Marta, xeyay apal ic, xeyay amb wüx imeaats cuajantanej irang quiaj. ");
INSERT INTO huvNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ajlüy noic leaw alwüx atam, María teamayac wüx omeaats aaga leaw netam quiaj, nejinguind ngome apmanood nej ocueaj ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Noic nüt Teat Jesús teataag orar, y wüx landoj, quiaj tapiüng nop minipilan nej: ―Teat, iquiaach xicon nguineay natajcan orar atnej tarang teat Juan wüx taquiaach minipilan nej ―aw. ");
INSERT INTO huvNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Quiaj tapiüng Teat Jesús: ―Icona, wüx apmetajcan orar atcüy ipiüngan: Xeteatiün Dios najlüy tiül cielo, ique nangaj minüt. Sandiüman mejlüy wüx meáwan nipilan nguiajantanej. Atnej iyambüch ninguiün tiül nangaj cielo, atquiaj aton netam meyambüch ningüy wüx aaga iüt cam, marangüch leaw ique indiüm. ");
INSERT INTO huvNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Iich xicon nüeteran nganüy nüt cam atnej mbójan irang. ");
INSERT INTO huvNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Iwün wüx imeaats aaga ngo majneaj tarangasan Teat, cos xicona aton lanawüniün wüx ximeajtsan meáwan ngo majneaj tarangüch wüx ximbasan. Imbeol xicon nde narangan ngo majneaj, Teat, Iwün ninguiün meáwan ngo majneaj, nde matüch xicon, irawan ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Aton tasaj nejiw: ―Jondot nop icona almajiür nop miamigo nej pinawan ongwiiüts mapeay masaj nej: “Amigo, najüch icueaj arojpüw pan. ");
INSERT INTO huvNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Cos napeay nop xeamigo, imiün miünquiaj ajngot, naleaing ngo najiür cuane sanüüch”, maj. ");
INSERT INTO huvNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Pero aaga naxey altiül iüm, apmasaj nej: “Tapots indeac, lanapal a iüm. Xecual lameayiw naquiüjpüw, ngondom witiün nawün nüüch ic”, maj nej. ");
INSERT INTO huvNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Naleaing sasaj icon, masey ngo mind witiow, nej apwitiüm mawün müüch leaw netam, ngome ajcan ajaw miamigo nej, apmarang cos ngo mandiüm manguiay mapajpaj nej. ");
INSERT INTO huvNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Nganüy sasaj icon: Sitiül apmetüniün apmeajndiün; sitiül apmeyamban monajneaj ocueaj nej apmexoman; sitiül apmerndeacan apmengocheranan. ");
INSERT INTO huvNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Cos meáwan leaw netün apmüünd; leaw neyamb apmaxom; leaw nendeac apmangocharan. ");
INSERT INTO huvNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’¿Mbich alndom nop nateateran wüx matün nej ocueaj pan micual nej, apmüüch noic piedra ingow üüch pana? ¿Tengwüy wüx matün cüet, ingow üüch cüet apmüüch nop ndiüca? ");
INSERT INTO huvNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","¿Jondot matün omb quit, ingow üüch omb quit apmüüch nop napüpa? ");
INSERT INTO huvNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Sitiül icona monrang ngo majneaj icon, ijawan cuane najneaj meajchiün micualan; cuantemas Miteatiiüts Dios najlüy tiül cielo apmüüch Nangaj Espíritu jane apmatün nej ocueaj ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Teat Jesús tawün nimeech wüx ombas nop naxey nejew. Wüx taw aaga nimeech quiaj, quiaj tendeac aaga naxey. Meáwan nipilan mbayajow majawüw. ");
INSERT INTO huvNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Naleaing altiül tapiüngüw: ―Aaga naxey quiaj awün nimeech cos ambeol nej aaga minatang nimeech nenüt Beelzebú ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Altiül tandiümüw majawüw cuane apmarang, tasajüw marang noic ateócan majawüw sitiül naleaing Teat Dios ambeol nej. ");
INSERT INTO huvNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Teat Jesús tajaw nguineay teamapiüngüw tiül omeajtsüw nejiw, áag tasaj nejiw: ―Tiül meáwan cambaj sitiül monajiüt apmajcüyiw mbajcamoj, apmembiyayej apndrom ombasüw. Sitiül moncül tiül noic nden majcüyiw, ngo majlüyiw nóiquian, apndajrriümoj. ");
INSERT INTO huvNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Atánan quiaj sitiül minatang nimeech ngo majlüy nóiquian maquiiüb mimonbeol nej, ¿nguineay alndom marangüw cuajantanej ngo majneaja? Aag ayaj sasaj icon cos ipiüngan xique sawün nimeech, ambeol xic Beelzebú. ");
INSERT INTO huvNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Sitiül naleaing Beelzebú nembeol xic nawün nimeech, isajan xic, jow minipilanan, ¿jane ambeol nejiw mawüniw nimeech? ¿Ngwüy nimeech ambeol nejiwe? Ninguiaj ajüic ngo mejawan cuane temepiüngan. ");
INSERT INTO huvNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Nganüy sitiül Teat Dios nembeol xic nawün nimeech wüx ombas nipilan, naleaing sasaj icon lamatüch mejmeliün tiül minipilan Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Sitiül nop naxey natang nenajiüt almajiür xeyay monjiür nej aniüng, meáwan leaw almajiür aniüng nej najneaj ajlüy. ");
INSERT INTO huvNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Nganüy sitiül aliüc alinop xeyay minipilan nej aquiiüb miün, apmanojtiw aaga iüm quiaj, apmasapüw leaw monjiür, apmümb mayariw membaagayej wüx leaw taxomüw. ");
INSERT INTO huvNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","’At sasaj icon, leaw ngo mandiüm xic, ajcüy majaw xic. Jane ngo mambeol xic wüx leaw teanaxaing, aag ayaj awíichan quiün. ");
INSERT INTO huvNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","’Nop nimeech wüx apmacueat aljane, apmajüyjüy tiül wajchiüc mayamb nguiane apmaxood. Wüx lapaxiow ajüyjüy ngo maxom, quiaj apmapiüng: “Sanandilil sandüy tiül niüng tawas”, apmaw. ");
INSERT INTO huvNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Camüm mapeay quiaj, apmaxom aaga naxey atnej nop iüm najneajay najirimb najmel mimbaj. ");
INSERT INTO huvNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Almajaw atquiaj, quiaj apmamb majan alayaíw aquiiüb nej alwüx apatüw, ngo matnej. Quiaj apmambüw andüyiw wüx ombas a naxey quiaj. Ndójwüx aaga naxey quiaj xeyay ngo majneaj apmajlüy, ngo matnej tajlüy nomb ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Teat Jesús wǘxan tealeámban mandeac aag ayaj, quiaj tendeac nop najtaj tiül nipilan, tapiüng: ―Najneajay ajlüy a müm najtaj newiquiach ic, neech ic ichech ―aw. ");
INSERT INTO huvNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Quiaj tapiüng Teat Jesús: ―¡Najneajay aton ajlüyiw meáwan leaw anguiayiw Mipoch Teat Dios ndoj ayacüw wüx omeajtsüw! ―aw. ");
INSERT INTO huvNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Wüx laxeyay nipilan mayeyiw nej tiüt, quiaj tapots masaj nejiw: ―Nipilan nganüy cam ngo majneaj arangüw, atüniw ateócan majawüw. Naleaing ngome apmüjndiw majawüw; apmüjndiw áagan leaam omeajtsüw leaw tajlüy wüx Jonás. ");
INSERT INTO huvNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Atnej Jonás tajlüy tanomb, wüx nej tatiib ocueajiw nipilan monaw Níneve leaw ngo majneaj teamarangüw, atquiaj ajlüy nganüy a Teat Naxey, teamatiib icueajiün leaw ngo majneaj teamerangan. ");
INSERT INTO huvNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Alinoic nüt wüx apmajaraw wüx asoet nipilan, quiaj nop najtaj najlüy tanomb, natang nenajiüt imiün cawac, nej apmajüiquich ajcüwa nipilan aaga nüt cam alwüx axeyay ngo majneaj teamarangüw; cos nej imiün xeyay miünquiaj tamb manguiay andeac Salomón. Nganüy ajlüy ningüy tiül icona nop alwüx xeyay ajaw ngo matnej Salomón, icona ngo meyariün andeac nej. ");
INSERT INTO huvNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","At alinoic nüt wüx Teat Dios apmajaw wüx asoeteran, ajcüwa nipilan monaw Níneve leaw tajlüyiw tanomb apmayacüw isoetiün. Cos ajcüwa nipilan quiaj tayambüw Teat Dios wüx Jonás tapaj nej ocueajiw. Nganüy ajlüy tiül icona nop alwüx xeyay atam ngo matnej Jonás, pero icona ngo merangan leaw asaj icon. ");
INSERT INTO huvNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","’Nejinguind ngome apmachen ran ndoj maxot, tengwüy mamoog omal tiül nop nchep. Ngwüy netam mayac cawüx marraj, maxom majaw jane apmajmel tiül iüm. ");
INSERT INTO huvNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Oniiügaran aag ayaj nerraj icoots. Sitiül iyac iniiüg wüx mejaw leaw najneaj, apmambeol ic merang najneaj. Wüx irang najneaj, aag ayaj atnej mejlüy tiül ran. Nganüy sitiül indiüm meyac iniiüg wüx mejaw leaw ngo majneaj, quiaj apmerang xeyay ngo majneaj; aag ayaj atnej ijlüy tiül pojniün. ");
INSERT INTO huvNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Netam mejaw wüx aaga ran ijiür quiaj, nde marang pojniün. ");
INSERT INTO huvNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Sitiül ique ijlüy tiül aaga ran quiaj, ngo mejlüy tiül pojniün, ranüy apmajlüy niüng ijlüy atnej wüx marraj ic noic nadam ran ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Wüx landoj andeac Teat Jesús, quiaj tasaj nej nop fariseo mamb metiw aniüng nej maquiiüb. Quiaj tamb Teat Jesús. Nganüy wüx chetet met, ");
INSERT INTO huvNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","aaga fariseo wüx tajaw nguineay Teat Jesús ngo marang atnej ajlüyay arangüw nejiw wüx ajantsüw owixaw, quiaj mbayat. ");
INSERT INTO huvNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Quiaj Teat Jesús tasaj nej: ―Icona fariseos ijantsan ombas a tas, polat, pero amb tiül tan ajlüy ngo majneaj. Icona atquiaj ijlüyiün, masey ajüic irangan najneaj, tiül imeajtsan xeyay ngo majneaj ajlüy, cos inojtiün meyariün ocueaj alinop, at irangan cuajantanej ngo majneaj. ");
INSERT INTO huvNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Nerchachiün! ¿Neol ngo mejawana, aag nerang amb wüx ombas, nej nerang amb tiül aton? ");
INSERT INTO huvNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Leaw almejiüran ijchan ajcüwa nipilan ngo majiür. Quiaj apmejlüyiün nerixixay najneaj. ");
INSERT INTO huvNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’¡Jaa, icona fariseos! Iyacan erchechiün naw tiül menta, ruda, at naw tiül cuajantanej soex napiürüch; pero icona ngo merangan leaw najneaj, ngo mejiüran lasta alinop atnej andiüm Teat Dios. Netam merangan meáwan aag ayaj, aton nde mecueatiün meyacan erchechiün. ");
INSERT INTO huvNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’¡Jaa, icona fariseos! Wüx iriümban tiül sinagogas iyamban nguiane chetemeron, nguineay alndom mejarawan. Aton iyambyamban merangüchiün casa niüng ajlüy xeyay nipilan. ");
INSERT INTO huvNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’¡Jaa, icona mondüy wüx aaga poch tüünd Moisés, aton icona fariseos! ¡Monlombojchay icon! At icon oxiüt wüx lajarriow, lango majüic, nipilan namong amb wüx ngo majaw sitiül aag ayaj oxiüt ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Condom tapiüng nop naxey nendüy wüx aaga poch tüünd Moisés, tasaj Teat Jesús: ―Teat, wüx indeac aag ayaj ajüic atnej andüy wüx ximbasan temendeac ―aj. ");
INSERT INTO huvNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Quiaj tapiüng Teat Jesús: ―¡Jaa, icona aton mondüy wüx aaga poch tüünd Moisés! Cos ijchan nipilan mamalüw leaw ngondom mamalüw; pero icona ngo mendiüman merrejquiün aag ayaj masey con nots micual iwixan. ");
INSERT INTO huvNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’¡Jaa icona! Cos teametajcan majneaj mioxiütüw mondeac andeac Teat Dios leaw tajlüyiw tanomb, leaw tandeowüw ambiy nejiw mixejchiün. ");
INSERT INTO huvNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Aag ayaj ajüic icona najneaj mejawan leaw tarangüw mixejchiün; nejiw monbiy, nganüy icona teamerangan mioxiütüw. ");
INSERT INTO huvNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Cos Teat Dios meáwan aag ayaj lamajaw, áag tapiüng: “Sanüjchiw mambüw niüng ijlüyiün mandeacüw sandeac, at sanüjchiw mambüw apóstoles aton. Altiül apmambiyaranüw, alacas apmayambüch ombasüw”, aw. ");
INSERT INTO huvNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Aag ayaj tandeac Teat Dios cos ajcüwa nipilan najlüy nganüy cam, apmengüyiw leaw tarangüchiw wüx ombasüw mondeac andeac nej tanomb, ajan wüx tarang iüt cam. ");
INSERT INTO huvNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Aag ayaj ajan wüx miquiej Abel, ndójwüx wüx miquiej Zacarías, áag tambiyaw tiül nadam nangaj iüm niüng ajlüy artül. Nganüy sasaj icon, Teat Dios apmüüch icon mengüyiün leaw tambiyaranüw quiaj. ");
INSERT INTO huvNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’¡Jaa, icona mondüy wüx aaga poch tüünd Moisés! Cos ijawan leawa netam, pero ngo merangan. At lamepálan alinop, ngo meajchiün majaw, marang ―aw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Wüx teamandeac masaj nejiw aag ayaj, meáwan mondüy wüx aaga poch tüünd Moisés, at a fariseos xeyay tajcüyiw. Condom quiaj tapots masajsajüw nej cuajantanej. ");
INSERT INTO huvNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Tayambüw nguineay masapüw wüx alngün poch leaw apmandeac, mayacüw asoet. ");
INSERT INTO huvNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Wüx aaga nüt tapeay quiaj xeyay nipilan, canchiütoj acas mil, lacharrayej. Quiaj Teat Jesús ombas masaj minipilan nej, tapiüng: ―Ijawan nguineay arangüw a fariseos, nde mitsojow icon. Aag ayaj alndom marang icon atnej arang levadura wüx ajmel tiül ajtsaj marang pan, cos andüy quiaj apmaxip mexeyay. Nejiw ajüic atnej arangüw najneaj; aag ayaj ngo maleaing, arangǘwan. ");
INSERT INTO huvNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Cos meáwan leaw naxotaran apmajüic, at meáwan leaw nexotüy apmajaraw alinoic nüt. ");
INSERT INTO huvNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Atquiaj leaw indeacan icónan quiaj masey tiül pojniün, alinoic nüt apmanguiayaran. Átan leaw tendeacan wüx indexeyon tiül ilajcan, alinoic nüt apmanderac napac manguiay cambaj. ");
INSERT INTO huvNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","’Xique sasaj icon xeamigojüw, nde mermbolan mendüyiün leaw alndom mambiy icon, cos áagan alndom marangüw. ");
INSERT INTO huvNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Nganüy sanasaj icon jane netam mermbolan mendüyiün: ermbolan mendüyiün aaga leaw alndom mambiy icon, ndoj alndom mayac icon tiül xeyay ngo majneaj, tiül biümb. Nej netam mermbolan mendüyiün. ");
INSERT INTO huvNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’¿Neol ngo mejawana, acoquiaw nine quiec ijquiaw tomiün ombeat? Naleaing Teat Dios ngo ndrom omeaats masey noic tiül nejiw, cos meáwan ajaw. ");
INSERT INTO huvNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","At miondeats omalaran lateoraw. Nde mermbolan nicuajind, cos icona alwüx imbeatiün, ngo mat nejiw a nine quiec quiaj. ");
INSERT INTO huvNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","’Aton sasaj icon, jangantanej ngo mexotüy wüx masaj nipilan ayar sandeac, xique aton sanandeac nasajüw miángeles Xeteat Dios xenipilan nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Nganüy jangantanej leaw apmapiüng xique ngome micual xic Teat Dios, at a xique aton sanasaj miángeles Xeteat Dios ngome xenipilan nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Aton sasaj icon, jangantanej leaw apmandeac alngün ngo majneaj wüx ombas Teat Naxey, nej alndom nawün wüx ximeaats. Nganüy leawa nendeac ngo majneaj wüx ombas Nangaj Espíritu ocueaj Teat Dios, aaga nisoet quiaj mbich ngondom maw wüx ombas nej. ");
INSERT INTO huvNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’Sitiül alngün nüt apmequiürajpan mayacüw icon teombas montangtang tiül ajcüwa sinagoga, tengwüy niüng ajlüy montangtang monajiüt, nde meyamban imeajtsan wüx cuane apmepiüngan; ");
INSERT INTO huvNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","cos wüx apmerndeacan, aaga Nangaj Espíritu ocueaj Teat Dios apmüüch icon poch leaw netam mepiüngan ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Condom nop naxey náwan tiül nipilan tasaj nej: ―Teat, isaj xecoj mambaag pinawan aaga najcueat cam nüjndiün, müüch xic leaw saneay ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Quiaj Teat Jesús tasaj nej: ―Teat ¿jane neyac xic najaw wüx leaw ijndean, nambaag icueajiün? ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Condom tasaj meáwan nipilan: ―Ijawan wüx, nde mendiümdiüman ocueaj alinop; cos ngome wüx lamejiüran cuajantanej alndom mambeol icon mepacan ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Quiaj tasaj nejiw acas poch andüy wüx corrül, tapiüng: ―Tajlüy nop naxey nejiür, meáwan omeaats micorrül nej tümb merangüy. ");
INSERT INTO huvNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Condom aaga naxey quiaj tapiüng tiül omeaats nej: “¿Nguineay sanarang cos ngo najiür nguiane sanayac omeaats xecorrül?”, aw. ");
INSERT INTO huvNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Quiaj tapiüng: “Atcüy sanarang, sanambich najarrich xetroj, ndoj sanarang alacas nadamdam, nayac tiül meáwan sanaxaing, at meáwan salnajiür. ");
INSERT INTO huvNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Quiaj sanapiüng xiquiáyan quiaj: Canüy najneajay ijlüy cos almejiür meáwan leaw netam, apmaíüc ic xeyay neat. Canüy ixood, iret, inganeow, ich mapac imeaats, sanaj ximeaats”, aw a naxey. ");
INSERT INTO huvNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Quiaj Teat Dios tasaj nej: “¡Chach! Aaga ongwiiüts cam apmendeow. Jow, leaw teamecanchich quiaj, ¿cuane ajpare? ¿jane apmaneaye?” aj nej. ");
INSERT INTO huvNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","’Atquiaj leaw necancanchich cuajantanej néjan quiaj wüx, ngo majiür nicuajind niüng ajlüy Teat Dios ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Condom Teat Jesús tasaj minipilan nej: ―Sasaj icon, nde mamb wüx imeajtsan mepiüngan cuane apmeatiün, cuane apmesojquiün. ");
INSERT INTO huvNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","¿Neol ngwa, icona alwüx itaman, ngo matnej nüeteran; aton micuerpojan alwüx atam, ngo matnej napixerana? ");
INSERT INTO huvNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ijawan nguineay ajlüyiw mimüm wiür, cos nejiw ngo mepiürüw maxainguiw omeaats corrül, ngo macanchichaw leaw apmüetiw alinoic nüt, cos Teat Dios üüch nejiw. ¿Neol ngome alwüx imbeatiüna, ngo matnej quieque? ");
INSERT INTO huvNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","¿Ngwüy jane tiül icona wüx xeyay ayambyamb omeaats alndom matang wüx alquiriwe? ");
INSERT INTO huvNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Sitiül ngondom merangan leaw ngo maél, ¿neol tapots iyacan imeajtsan wüx cuajantanej leawa naéle? ");
INSERT INTO huvNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Ijawan nguineay ajlüyiw a mbaj, nguineay atangüw. Cos ngo marangüw najiüt nicuajind, at ngo mendileaw. Nganüy sasaj icon, aaga minatang nenajiüt leaw tajlüy nomb nenüt Salomón, nej tajiür xeyay tomiün. Masey tajiür xeyay najneajay apix nej; ngo matüch matnej ajneajiw a mbaj. ");
INSERT INTO huvNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Sitiül Teat Dios ayac mimbaj a soex leaw almajlüy nganüy, oxep lamarang asap andaab pow, cuane wüx ngo mambeol icon. ¿Neol ngo meyacan imeajtsan wüx neje? ");
INSERT INTO huvNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Icona nde meyacan imeajtsan wüx leaw apmeatiün menganeowan. ");
INSERT INTO huvNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Cos nipilan leaw ngo mayambüw Teat Dios, xeyay ayacüw omeajtsüw wüx aag ayaj. Icona ijawan Miteatiiüts Dios, nej alwüx, nej ajaw meáwan leawa teatam icon. ");
INSERT INTO huvNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Netam meyamban merangan meáwan leaw andiüm Teat Dios; quiaj nej apmüüch icon meáwan leawa netam. ");
INSERT INTO huvNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","’Nde mermbolan xecualüw, masey nepateayiün, cos Miteatiiüts Dios xeyay ajneaj omeaats, andiüm müüch icon mejlüyiün tiül micambaj nej. ");
INSERT INTO huvNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Inüjpiün leaw almejiüran, condom imbeolan leaw nipilan ngo majiür. Aag ayaj atnej mejiüran xeyay tiül iquial tomiün tiül cielo niüng mitomiünan ngo mümb, ngondom pandiüm, ngondom majmel quiaj need maneed, átan a ndeoog ngondom majlüy mandrooch ombas. ");
INSERT INTO huvNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Cos niüng ijiüran cuajantanej nembeatmbeat, quiaj almajlüy imeajtsan. ");
INSERT INTO huvNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","’Ersooigayon, icüliün, icheniün a ran. ");
INSERT INTO huvNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Irangan atnej arangüw monrang najiüt tiül noic nden wüx teamacüliw neneay nden. Cos wüx apmapeay imiün niüng nengoch owix, camüm majngot mapaj nejiw, najénan maleaijquiw a iüm majmel. ");
INSERT INTO huvNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Najneajay apmajlüyiw ajcüw monrang najiüt quiaj wüx apmapeay neneay nden maxom nejiw teamacüliw nej, ngo mameayiw. Naleaing sasaj icon, ndójwüx nejay a neneay nden apmayac mes, at nüeteran, masaj nejiw chetemoj metiw. ");
INSERT INTO huvNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Masey mapeay pinawan ongwiiüts, masey andüy wüx arraw, sitiül apmaxom nejiw teamacüliw nej ngo mameayiw, najneajay apmajlüyiw ajcüw leawa teamacüliw nej quiaj. ");
INSERT INTO huvNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Aton sanasaj icon, jondot nop nateateran majaw cuame ores apmajmel aniüng nej need, nej ngome apmameay, ngome apmüüch majmel tinden maneed leaw ajiür. ");
INSERT INTO huvNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ata icona aton netam mecüliün mepacan, cos Teat Naxey apmandilil wüx ngome teateotsaran ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Quiaj Pedro tasaj Teat Jesús: ―Teat, ¿indeac aag ayaj nanguiayiün xicona, ngwüy tendeac manguiayiw meáwan nipilan atona? ―aj. ");
INSERT INTO huvNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Quiaj tasaj nej Teat Jesús: ―¿Jane aaga nerang najiüt, nerang najneaj, nexom omeaats, leaw neneay nden tayac teowix nej aniüng nej majaw nej ocueaj, mawiül monlüy quiaj marang leaw netama? ");
INSERT INTO huvNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Najneajay apmajlüy aaga nerang najiüt quiaj wüx apmandilil neneay nden, cos apmaxom nej teamarang meáwan leaw lamasaj. ");
INSERT INTO huvNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Naleaing sasaj icon, aaga neneay nden quiaj ndójwüx apmayac teowix nej meáwan leaw almajiür majaw nej ocueaj. ");
INSERT INTO huvNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Nganüy sitiül aaga nerang najiüt quiaj mapiüng neneay najiüt nequiy apmapeay, maw, ndoj tapots mawüüch meáwan monrang najiüt quiaj, monxey, montaj. At a nej ngo marang nicuajind, metmétan, angüngǘnan. ");
INSERT INTO huvNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ndot tealeámban aag ayaj, quiaj apeay aaga neneay najiüt wüx a nüt lango leaam omeaats nerang najiüt macül nej. Quiaj apmüüch mamongoch xeyay ngo majneaj, ndoj apmüüch maquiiüb tiül meáwan leaw ngo mayariw nej andeac. ");
INSERT INTO huvNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Sasaj icon, leaw nerang najiüt nejaw cuane andiüm neneay najiüt, ndoj ngo marang atnej, apmajwüch xeyay. ");
INSERT INTO huvNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Nganüy nop leaw ngo majaw cuane andiüm neneay najiüt, ndoj tarang leaw ngo metam marang, apmajwüch napateay quiriw. Cos meáwan leawa nüünd xeyay, apmajtan ocueaj nej xeyay aton, leaw nüünd xeyay leaw ajaraw alndom marang, nej netam marang xeyay aton. ");
INSERT INTO huvNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","’Xique tiünas ningüy wüx aaga iüt cam, nganüy apmajlüy xeyay moncüy, atnej xique tiünas nayac biümb. ¡Malüy lajlüy aag ayaj! ");
INSERT INTO huvNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Xique netam namongoch xeyay necoy. Xeyay ngo majneaj ximeaats ¡Malüy sapiüng landoj lajlüy! ");
INSERT INTO huvNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Ngwüy ipiüngana xique xiün ningüy nayac majlüy monajneaj wüx iüt cama? Ngwüy, xique xiün nüüch majlüy xeyay moncüy, mbajcan palpálwüx. ");
INSERT INTO huvNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Cos naw wüx nganüy alndom majlüy acoquiaw nipilan tiül noic nden ngo majlüyiw nóiquian. Arojpüw apmajcüyiw majawüw ijpüw, tengwüy ijpüw apmajcüyiw majawüw arojpüw. ");
INSERT INTO huvNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Nateateran apmajcüy majaw nacualaran, tengwüy nacualaran apmajcüy majaw nateateran. Namümaran apmajcüy majaw nacualaran, nacualaran apmajcüy majaw namümaran. Aton namümaran apmajcüy majaw mintaj nacualaran, mintaj nacualaran apmajcüy majaw napeweran ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","At tasaj meáwan nipilan: ―Icona wüx ijawan lamawitich oic noleat lamepiüngan: Apmajoet, irawan. Naleaing atquiaj apmajlüy. ");
INSERT INTO huvNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","At wüx apmapep tiüt ncherrec lamepiüngan: Apmerraar, irawan. Naleaing atquiaj apmajlüy. ");
INSERT INTO huvNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Sasaj icon ndeac mbeay! Icona ipiüngan ijawan wüx oic, wüx caaw, at wüx iüt. ¿Neol a nganüy ngo mejawan nicuajind wüx meáwan leaw tenguial ajlüy tiül aaga nüt cama? ");
INSERT INTO huvNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","’¿Neol ngo mejawan icónan quiaj nguineay netam merangan najneaja? ");
INSERT INTO huvNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Cos sitiül aljane aleaic iriow anaag wüx, apmayac ic teombas monajiüt, pues indeac anaag, ijaw cuane ngo majneaj irang, isaj apmeyac ingow wǘxan nganaw mepeay anaag teombasüw monajiüt. Cos teat xan alndom masaj mongot mayacüw ic tiül manchiüc. ");
INSERT INTO huvNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Naleaing sasaj ic, wüx lerpeay tiül manchiüc langondom meriow najen, apmeriow leaw imbich mengüy leaw apmatüniw icueaj ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Wüx aaga nüt quiaj acas nipilan tasajüw Teat Jesús nguineay a Pilato tapiüng mambiyaranüw acas nipilan monaw Galilea, ndoj taól miquiejiw nejiw tiül miquiej nimal leaw teamambiyaw ajcüw monaw Galilea, marang ichechiw nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Quiaj tasaj nejiw Teat Jesús: ―Cuane ipiüngan ¿jow ajcüwa monxey tandeowüw quiaj, más xeyay asoetiw ajiürüwa, ngo mat nejiw meáwan nipilan monaw Galilea, áag tamongochiw atquiaja? ");
INSERT INTO huvNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Xique sasaj icon ngwüy, cos sitiül icona ngo leaam imeajtsan meyamban Teat Dios, meáwan icona apmandrojchich imbasan aton. ");
INSERT INTO huvNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ngwüy, cuane ipiüngan ¿jow ajcüwa gajpopeac (18) nipilan tandeowüw achar nejiw tiüt mitorre Siloé, alwüx ngo majneaj arangüwa, ngo matnejiw meáwan nipilan monlüy tiül Jerusaléne? ");
INSERT INTO huvNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Xique sasaj icon ngwüy, cos sitiül icona ngo leaam imeajtsan meyamban Teat Dios, meáwan icona apmandrojchich imbasan aton ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Condom Teat Jesús tandeac masaj nejiw, tapiüng: ―Tajlüy nop naxey ajiür noic corrül, altiül noic owil toc. Tamb majaw sitiül alwüx aóng, pero ngo maxom wüx nicuajind. ");
INSERT INTO huvNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Quiaj tasaj aaga naxey nejiür micorrül nej: “Aaga toc cam aroomb neat wüx aag agüy xiün ningüy nayamb aóng nej, ngo naxom wüx nicuajind. Indooig, cuane ajpar, cos teapalpálan iüt”, aj. ");
INSERT INTO huvNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Aaga nejiür corrül tasaj nej: “Teat, ich macül áagan a neat cam; sanataag majneaj, sanatoxtox mapench a iüt wüx owil, ndoj sanayac omeaats iüt. ");
INSERT INTO huvNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Sapiüng apmeóng, tengwüy sitiül ngo meóng, mbich quiaj sanandooig”, aw ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Noic nüt axoodaran Teat Jesús altiül sinagoga teaquiaach. ");
INSERT INTO huvNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Alquiaj nop müm najtaj ajiür noic monandeow ayac nimeech, lamatüch gajpopeac (18) neat tatow maxom nej. Lamandrooch nej ombas, apejnguéxan ajüy, ngondom maleaing. ");
INSERT INTO huvNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Teat Jesús wüx tajaw nej, quiaj tasaj: ―Müm najtaj, canüy lerneaj, laáw mimonandeow ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Quiaj tayac owix wüx omal a müm najtaj, andǘüban ajneaj, nómban taleaing. Quiaj tapots masaj Teat Dios najneaj arang. ");
INSERT INTO huvNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Nganüy aaga natang tiül a sinagoga tajcüy cos Teat Jesús lamataag majneaj monandeow wüx nüt axoodaran. Quiaj tasaj nipilan: ―Ajlüy anaíw nüt leaw alndom marangüch najiüt. Tiül aaga nüt quiaj netam merwiünan matajcüch majneaj iün indeowan, ngome wüx nüt axoodaran ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Quiaj Teat Jesús tapiüng: ―¡Ndeac mbeay! ¿Neol, jowa icona ngo mechejtiün miboyiüna miburrana mequiüjpan meajchiün yow wüx nüt axoodarana? ");
INSERT INTO huvNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Aaga müm najtaj cam, nej nop naw tiül acualaats Abraham aton. Nimeech lamüüch nej mamongoch xeyay ngo majneaj lamatüch gajpopeac (18) neat. ¿Neol ngondom matajcüch majneaj wüx nüt axoodarana? ―aw. ");
INSERT INTO huvNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Wüx Teat Jesús tandeac aag ayaj taxinguiaw meáwan leaw teajcüyiw majawüw nej. Pero altigüy nipilan tapac omeajtsüw xeyay majawüw meáwan najneajay tarang Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Condom Teat Jesús tasaj nejiw: ―¿Nguineay alndom nasaj icon cuane atnej ajlüy micambaj Teat Dios, ngwüy cuane wüx alndom nandeac naquiaach icon wüx, mejawana? ");
INSERT INTO huvNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ajlüy atnej arang osaab mostaza wüx nop naxey apmapiür tiül micorrül nej. Cos apmadam apmatnej nadam xiül; quiec alndom marangüw ombiümüw wüx mipüüig nej ―aw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Teat Jesús tapiüng alinomb: ―¿Cua wüx alndom nandeac naquiaach icon mejawan nguineay ajlüy micambaj Teat Diosa? ");
INSERT INTO huvNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ajlüy atnej arang levadura, cos wüx nop najtaj apmayac tiül arej nepeax arin, aaga levadura apmüüch maxip ajtsaj marang pan ―aw. ");
INSERT INTO huvNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Teat Jesús tanaámb amb andüy Jerusalén. Tamong tiül nadamdam cambaj, tiül namix cambaj, tanaámb teaquiaach nipilan. ");
INSERT INTO huvNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Aljane tatün manguiay nej: ―Teat ¿ngwa naleaingue, napateay nipilan apmawüw wüx asoetiw? ―aj. Quiaj tapiüng Teat Jesús: ");
INSERT INTO huvNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―Ipacan wüx, ijmeliün iriümban tiül quicheech niüng ajmeleran. Cos xeyay nipilan apmandiümüw majmeliw, pero ngome apmajmeliw. ");
INSERT INTO huvNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Sitiül nateateran lawitiow mapal a iüm, nganüy icona ngome tejmeliün, condom tapots ipajan mepiüngan: “Teat, teat, ileaaig a iüm najmeliün”, merajan. Nej apmasaj icon: “Ngo najaw jane icon, nguiane neriowan”, apmaj icon. ");
INSERT INTO huvNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Icona quiaj apmesajan: “Xicona tetesan, tanganeowasan naquiüjpan ic; aton ique tequiaach tiül xecambajan”, apmerajan. ");
INSERT INTO huvNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Nej apmapiüng: “Lanasaj icon ngo najaw jane icon, nguiane neriowan. Iriowan ningüy niüng sajlüy monrang ngo majneaj”, apmaj icon. ");
INSERT INTO huvNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Quiaj apmejiüntsan xeyay, apmenchicnchiquian ilüiquiün wüx apmejawan teat Abraham, teat Isaac, teat Jacob, at meáwan mondeac andeac Teat Dios aliw tiül micambaj Teat Dios; pero icona ngondom mejmeliün. ");
INSERT INTO huvNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Cos aliücüw imiün nonüt, imiün noleat, imiün calüy, imiün cawac; apchetemoj wüx mes tiül micambaj Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Altiül leaw ayaag chingüy nej nganüy, tiül aaga nüt quiaj apmarang natang; aton altiül leaw ayaag atnej natang nganüy, tiül aaga nüt quiaj apmarang chingüy ―aw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Tíülan aaga nüt quiaj tapeayiw quiaj acas fariseos, tasajüw nej: ―Iriow ningüy, quiür ijaw nguiane apmendüy cos Herodes teamandiüm mambiy ic ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Nej tasaj nejiw: ―Quiüran isajan aaga atnej wiül quiaj: “Xique nganüy teanawün nimeech wüx ombas nipilan, teanamongoch monandeow nganüy at oxep; nawiür landoj xenajiüt”, irajan. ");
INSERT INTO huvNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Xique tanaámb netam nandüüb xetiiüd nganüy, oxep, at nawiür, cos nop nendeac andeac Teat Dios ngondom mandeow nguiajantanej, netam matüch Jerusalén. ");
INSERT INTO huvNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","’¡Jerusalén, Jerusalén! ¿Neol tembiy ajcüwa mondeac andeac Teat Dios? ¿Neol teloxiw leaw Teat Dios üüch mamb masajüw ic wüx nej? ¡Xique xeyay tandiümas naxejneng micual, atnej arang noic quit maxejneng micual nej teombas miolümb nej, pero ngo mendiüm! ");
INSERT INTO huvNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Nganüy apmejawan nguineay apmajcueat imbiüman. Aton sasaj icon langome apmexoman mejawan xic; naleaing apmejawan xic wüx apmatüch a nüt mepiüngan: “Najneajay ajlüy aaga niün, üüch nej miün Teat Dios”, merawan ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Noic nüt axoodaran, Teat Jesús tamb met aniüng nop natang nenajiüt ocueajiw fariseos. Nejiw teamandacüwiw Teat Jesús sitiül aleaic apmarang. ");
INSERT INTO huvNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Alquiaj niüng ajlüy Teat Jesús nop naxey niün andeow, apep nej. ");
INSERT INTO huvNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Quiaj Teat Jesús tasaj mondüy wüx aaga poch tüünd Moisés, at ajcüwa fariseos: ―¿Cuane ipiüngan, najneaj matajcüch majneaj nop niün andeow wüx noic nüt axoodarana? ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Nejiw ndijchijówan. Condom quiaj Teat Jesús tasap owix a niün andeow, tüüch majneaj, ndoj tasaj mamb. ");
INSERT INTO huvNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Condom tandüy wüx masaj nejiw: ―Jow icona, jondot mejawan miburran, miboyiün lajmiüc tiül lol ¿ngo mewüniünan najénan masey wüx nüt axoodarana? ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Nejiw ngondom mangochiw masajüw nej nicuajind. ");
INSERT INTO huvNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Wüx Teat Jesús tajaw ajcüwa nipilan nguineay ayambyambüw chetemoj niüng chetejow netamtamüw nipilan, quiaj tasaj nejiw nguineay netam marangüw, tapiüng: ");
INSERT INTO huvNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―Wüx apmejpajan aniüng nop nengoch owix, nde memongon ombas chetemeron quiaj, jondot aliüc alinop aton najpaj quiaj, alwüx atam ngo mat icona. ");
INSERT INTO huvNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Condom aliüc aaga nepaj icon masaj icon: “Witiüron ninguiaj cos apchetem aaga alinop cam”, apmaj icon. Quiaj apmexinguian meamban chetemeron niüng ajlüyiw ümb wüx moncheten. ");
INSERT INTO huvNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Más najneaj, wüx apmejpajan niüng nengoch owix, quiüran cheteron mequiüjpan ümb wüx moncheten. Mbich wüx aliüc aaga nepaj icon apmapiüng: “Xeamigo, imongon ombas”, apmaj icon. Quiaj apmapac imeajtsan, apmemongon mequiüjpan tiül leaw namongoj ombas. ");
INSERT INTO huvNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Cos jangantanej leaw nerangrang adam apmüünd monxing. Pero leaw ayaag nicuajind nej, apmandiüram ―aw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Condom tasaj aaga naxey nepaj nej mamb met aniüng nej: ―Wüx apmerang noic nüeteran nde mepajüw miamigo, micoj, michiig, icualaats, mivecin leaw nejiür. Cos nejiw alndom mandilileaw mapajüw ic alinoic nüt, quiaj apmatotow. ");
INSERT INTO huvNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ngwüy, wüx apmeyac nüeteran ipaj leaw nipilan ngo majiür, at leaw necoex, leaw nesomb. ");
INSERT INTO huvNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Quiaj apmapac imeaats cos nejiw ngondom mapajüw ic matotow. Nganüy a ique, Teat Dios apmangüy ic alinoic nüt wüx nej apmapacüüch leaw monrang najneaj ―aj nej Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Nop tiül ajcüw alchetemoj wüx mes maquiüjpüw Teat Jesús, tasaj nej: ―Najneajay apmajlüy leaw apmajlüy tiül monet alinoic nüt tiül micambaj Teat Dios ―aj. ");
INSERT INTO huvNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Quiaj Teat Jesús tapiüng: ―Nop naxey tarang noic nadam nüeteran, tapaj xeyay nipilan. ");
INSERT INTO huvNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Wüx lamatüch majlüy monet, quiaj tasaj mamb aaga nembeol nej masaj leaw lamapaj: “Tabaats, landoj lajmel a nüeteran”, maw. ");
INSERT INTO huvNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Quiaj meáwan nejiw tayambüw nguineay ngo mambüw. Nop tapiüng: “Sangal noic corrül, nganüy netam namb najaw; nde mejcüy teat, naleaing ngondom namb”, aw. ");
INSERT INTO huvNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Alinop tapiüng: “Sangal acoquiaw mancuerna boy, netam namb najawüw; nde mejcüy teat, naleaing ngondom namb”, aw. ");
INSERT INTO huvNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Alinop tapiüng: “Lesndot angoch xiwix; naleaing teat, ngondom namb”, aw. ");
INSERT INTO huvNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Quiaj tandilil aaga nembeol quiaj masaj neneay nden meáwan leawa tasoic. Quiaj tajcüy aaga neneay nden quiaj, tasaj nej: “Nganüy nganüy quiür tiül cambaj, ipajüw miünüw meáwan nipilan leaw ngo majiür, leaw necoex, leaw ngo majiür owix, leaw nesomb; isajüw miünüw”, aj. ");
INSERT INTO huvNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ndoj marang aag ayaj, quiaj tasaj neneay nden: “Teat, lanarang atnej ipiüng, pero naleaing aliün majlüy nüeteran”, aw. ");
INSERT INTO huvNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Tandüy wüx masaj nej a neneay nden: “Quiür tiül meáwan tiiüd, tiül rünch, inetet owixaw miünüw leaw apmexom, para alndom chipiüm saniüng. ");
INSERT INTO huvNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Cos naleaing sasaj ic, nejinguind leaw sapaj ombas ngome apmiünüw saniüng chetemoj metiw”, aj ―aw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Xeyay nipilan tandüjpiw Teat Jesús; condom nej ndiliteay majaw nejiw, tapiüng: ");
INSERT INTO huvNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―Sitiül aljane andiüm majlüy tiül xenipilan, netam mayac omeaats wüx xic. Nde mayac omeaats wüx miteat nej, mimüm nej, mintaj nej, micual nej, micoj nej, michiig nej. At ngondom mayac omeaats wüx leaw apmamongoch. Sitiül ngo marang atquiaj ngondom majlüy tiül xenipilan. ");
INSERT INTO huvNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","At sitiül aljane ngo mandiüm mamongoch naél, masey mambiyaran wüx cruz ajcan ayar sandeac, ngondom majlüy tiül xenipilan. ");
INSERT INTO huvNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","¿Cos jane tiül icona sitiül mandiüm marang nop torre, ngo chetem mayamb omeaats majaw nguitow apmetam nej mandondoche? ");
INSERT INTO huvNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Jondot lamawitich tiüt marang, condom langondom mandondoch; quiaj nipilan apmajawüw, apmitsojow nej. ");
INSERT INTO huvNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Apmapiüngüw: “Aaga naxey quiaj íünan mawitich, nganüy lango majiür cuane naag mandondochay”, apmawüw. ");
INSERT INTO huvNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ndot nop natang nenajiüt wüx apmajaw apmajlüy montsoj, aliüc alinop natang nenajiüt aquiiüb miün nimiow mil (20,000) soldados, nej ajcánan gajpowüw mil (10,000) ajiür, ¿quia, ngome ombas apchetem mayamb omeaats sitiül alndom mangoch aaga nimiow mil quiaja? ");
INSERT INTO huvNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Sitiül ajaw ngondom mengoch aweaag, wǘxan aliün miünquiaj ajngotoj ajcüwa alinoic ajlüy quiaj, nej apmüüch mamb minipilan nej mayambüw monajneaj. ");
INSERT INTO huvNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Atquiaj icon sitiül ngo mendiüman mecueatiün leaw almejiüran, ngondom mejlüyiün tiül xenipilan. ");
INSERT INTO huvNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","’Najneaj quiniüc aag ayaj najtix, pero quiniüc lango majtix ¿cuane ajpar, cos nguineay apmajtix alinomb? ");
INSERT INTO huvNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ngondom mamb tiül iüt, ngondom ponongom pandiüm marang omeaats iüt, netam majwich ninguiün. Jane apmanguiay aag ayaj, ich mayamb omeaats majaw cuane wüx amb apiüng ―aw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Tatüchiw niüng ajlüy Teat Jesús xeyay monrang ngo majneaj; aliw tiül aton monsap tomiün ocueaj cambaj. Tambüw niüng ajlüy Teat Jesús manguiayiw aquiaach nej. ");
INSERT INTO huvNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ajcüwa fariseos, at mondüy wüx aaga poch tüünd Moisés tendeacndeacüw, tapiüngüw: ―Aaga naxey quiaj aquiiüb tiül monrang ngo majneaj, üet aweaag ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Quiaj Teat Jesús tandeac acas poch andüy wüx nejiw, tapiüng: ");
INSERT INTO huvNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―¿Jondot aljane tiül icona ajiür acoic miow (100) sap, camüm ndrot ocueaj nop, nguineay apmaranga? Apmacueat tiül wajchiüc ajcüwa peic miow gajpoquiy (99) quiaj, cas tamb mayamb aaga ndron ocueaj leaw axom. ");
INSERT INTO huvNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Wüx apmaxom apmaxaing mapiib wüx onic, apac omeaats. ");
INSERT INTO huvNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ndoj, wüx apmapeay aniüng nej apmaxejneng leaw xowüy ajneaj aweaag, at moncǘlan quiaj niüng acül nej, apmasaj: “Ndrot xesap, nganüy lanaxom. Ich mapac imeajtsan, mapac omeajtsaats”, apmaj. ");
INSERT INTO huvNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Naleaing sasaj icon atquiaj apac omeaatsaran xeyay tiül cielo wüx nop nerang ngo majneaj laleaaw omeaats wüx Teat Dios matün ocueaj, ngo matnej peic miow gajpoquiy (99) nipilan leaw ayajcüw ngo majiürüw nisoet, apiüngüw ngo metam majpaj ocueajiw ―aw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Condom tandeac alinoic, tapiüng: ―Jondot nop najtaj ajiür gajpowüw tomiün, ndrot ocueaj noic, ¿nguineay apmaranga? Apmachen ran majimb tiül iüm leaw axom. ");
INSERT INTO huvNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Wüx apmaxom apmaxejneng leaw xowüy ajneaj aweaag, at moncǘlan quiaj niüng acül nej, apmasaj: “Ndrot noic xetomiün, nganüy lanaxom. Ich mapac imeajtsan, mapac omeajtsaats”, apmaj. ");
INSERT INTO huvNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Naleaing sasaj icon, atquiaj xeyay apac omeajtsüw miángeles Teat Dios wüx nop nerang ngo majneaj laleaaw omeaats matün ocueaj Teat Dios mawün asoet nej ―aw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Aton Teat Jesús tandeac alinoic, tapiüng: ―Tajlüy nop naxey ajiür ijpüw micual nej. ");
INSERT INTO huvNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Aaga chingüy nacualaran tasaj miteat nej: “Teat, imbaag nómban, iich xic leaw apmeaach xic”, aj. Miteat nej quiaj tambaag, tüüch nejiw mianopnopoj. ");
INSERT INTO huvNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ngome xeyay nüt aaga chingüy quiaj taxaing meáwan leawa tüünd. Tamb andüy alinoic iüt ninguiün miünquiaj. Quiaj tambich mandrooch meáwan leaw ajoy mamb wüx cuajantanej ngo majneaj. ");
INSERT INTO huvNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Condom wüx laǘmb mandrooch meáwan leaw almajiür, tajlüy noic nadam lop tiül aaga cambaj quiaj; nej xeyay tind üet pero ngo majiür cuane apmayar. ");
INSERT INTO huvNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Quiaj mbiüjlat wüx ayamb arang najiüt. Tamb majaw nop naxey tiül aaga iüt quiaj; tüüch nej mamb tiül mirrünch nej mejiür sow. ");
INSERT INTO huvNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Quiaj tind müet üet sow, cos nejinguind ngo müüch nej üet. ");
INSERT INTO huvNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Quiaj leaad omeaats, tapiüng nejáyan quiaj: “¡Xeteat almajiür xeyay monrang najiüt, nenaw ocueajiw nejiw nüeteran; nganüy a xique teasandeow lop ningüy! ");
INSERT INTO huvNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Leaw sanarang, sanandilil alinomb sandüy niüng ajlüy xeteat. Sanasaj: Teat, lanarang xeyay ngo majneaj leaw ngo mandiüm Teat Dios, at ique ngo mendiüm. ");
INSERT INTO huvNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Nde meyac xic tiül mepiüng micual xic. Ngwüy, iyac xic atnej nop nerang minajiüt, sanaj”, aw. ");
INSERT INTO huvNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Condom quiaj taw quiaj, tandilil andüy aniüng miteat nej. ’Alíücan ninguiün majaw nej miteat nej, xeyay tapac omeaats majaw nej. Acuiür tamb mangoch nej mapeiquiec nej onic, majend nej omal. ");
INSERT INTO huvNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Andüüb miün tasaj miteat nej: “Teat, lanarang xeyay ngo majneaj leaw ngo mandiüm Teat Dios, ata ique ngo mendiüm. Nganüy nde meyac xic tiül mepiüng micual xic”, aj. ");
INSERT INTO huvNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Quiaj miteat nej tasaj monrang minajiüt nej: “Iyamban leaw najneaj napixeran ijchan masooig, aton noic iquial owixeran, at ijchan masooig najneaj napajaran. ");
INSERT INTO huvNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","¡Quiüran ijanan miün aaga naxip quicheech wacüx; imbiyan matsambaats marangaats nangos nüt! ");
INSERT INTO huvNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Cos aaga xecual cam landoj lanapiüng landeow, nganüy lanaxom almapac. Tapiüngas landoj laámb, nganüy lapeay”, aj nejiw. Quiaj tapots apac omeajtsüw ajlüy nangos nüt. ");
INSERT INTO huvNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Aaga alinop natang micual nej altiül corrül nganaw mapeay. Wüx nganaw matüch aniüng nej, tanguiay tenguial ajlüy nangos nüt, at monjiüng. ");
INSERT INTO huvNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Quiaj tapaj nop nerang minajiüt miteat nej, tatün manguiay cuane najlüy. ");
INSERT INTO huvNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Quiaj tasaj nej: “Michiig lapeay, miteat tapiüng mandeow aaga quicheech wacüx naxip tiül, cos apac omeaats lapeay michiig napac najneájan”, aj nej aaga nerang najiüt. ");
INSERT INTO huvNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Quiaj tajcüy aaga natang quiaj, ngo mandiüm majmel tinden. Quiaj taw miteat nej mawüywüy nej majmel. ");
INSERT INTO huvNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ndoj nej quiaj tasaj miteat nej: “Xique xeyay neat lanarang minajiüt, ngome áag narang adam ximeaats. Wül meaach xic masey nop nine teants nambiy natsamb anaag xeamigos. ");
INSERT INTO huvNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Nganüy wüx apeay aaga micual quiaj, nej lamambich mandrooch wüx montaj meáwan leawa teaach; pero ique lamembiy aaga naxip wacüx mengoch ombas”, aj nej. ");
INSERT INTO huvNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Quiaj tasaj nej miteat nej: “Xecual, ique meáwan nüt ilningüy mequiiüb xic. Meáwan leawa alnajiür, aag ayaj landoj ineay. ");
INSERT INTO huvNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Nganüy netam marangaats nangos nüt mapac omeajtsaats, cos aaga michiig cam landoj lanapiüng landeow, nganüy lanaxom almapac. Tapiüngas landoj laámb, nganüy lapeay”, aj nej miteat nej ―aw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Condom Teat Jesús tasaj minipilan nej aton: ―Tajlüy nop naxey nejiür xeyay, ajiür nop minatang nerang minajiüt nej. Aaga nerang najiüt quiaj tajmel asoet; tapiüngüw nej androochndróochan ocueaj neneay najiüt. ");
INSERT INTO huvNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Condom neneay najiüt tapaj masaj nej: “Lananguiay tenguial irang ngo majneaj. Nganüy apmeaach xic meáwan leaw altiül iwix, cos ninguiaj ndoj süüch ic najiüt”, aj nej. ");
INSERT INTO huvNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Condom aaga naxey quiaj tapiüng nejáyan quiaj: “Jow nganüy nguineay sanarang, cos neneay najiüt langome apmüüch xic najiüt. Xique ngondom ximbas satox iüt; at saxing namb satüneay. ");
INSERT INTO huvNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Lanajaw nguineay sanarang para alndom najiür amigo niüng alndom namb wüx lasajwan tiül xenajiüt”, aw. ");
INSERT INTO huvNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Condom quiaj tapaj anopnopoj leawa nejüch neneay najiüt. Tatün manguiay nop: “¿Nguitow ijüch neneay najiüta?”, aj. ");
INSERT INTO huvNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Quiaj tapiüng: “Coic miow (100) ngan aceite”, aw. Quiaj tasaj: “Cheter, jogüy minawiig, irang alinoic, iyac áagan ic miow gajpowüw (50)”, aj. ");
INSERT INTO huvNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Condom tasaj alinop: “¿Jow ique, nguitow ijüch?” aj. Quiaj tasaj nej: “Coic miow (100) nepeax trigo”, aj nej. Quiaj tasaj: “Jogüy minawiig, irang alinoic, iyac áagan peic miow (80)”, aj. ");
INSERT INTO huvNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Condom quiaj aaga neneay najiüt talomb aaga naxey nerang ngo majneaj quiaj cos taxom omeaats mayamb nguineay apmajlüy alinoic nüt. Nipilan tiül aaga nüt cam xeyay axomüw omeajtsüw marangüw cuajantanej. Pero ajcüw monyamb Teat Dios ngo mayacüw omeajtsüw wüx maxomüw xeyay cuajantanej ningüy wüx iüt. ");
INSERT INTO huvNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","’Nganüy sasaj icon: Netam mexoman imeajtsan wüx nguineay apmerangan wüx cuajantanej leaw ijiüran wüx aliün mepacan ningüy wüx aaga ngo majneaj iüt cam, pero ngome atnej tarang aaga naxey quiaj. Pues netam mejiüran amigos leaw apmambeolüw icon wüx laǘmb meáwan leaw ijiüran. Ndoj apmejlüyiün najneaj tiül cielo meáwan nüt. ");
INSERT INTO huvNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’Cos leaw nerang najneaj wüx cuajantanej, masey wüx noic nine najiüt, atanquiaj apmarang wüx noic nadam najiüt aton. Leaw arang ngo majneaj wüx noic nine najiüt, wüx noic nadam najiüt aton ngo majneaj apmarang. ");
INSERT INTO huvNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Sitiül icona ngo merangan najneaj wüx leaw almejiüran ningüy wüx iüt, ¿nguineay apmerangan najneaj wüx leawa más xeyay netam, aag ayaj wüx minajiüt Teat Dios? ");
INSERT INTO huvNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Sitiül ngo merangan najneaj wüx ocueaj alinop, ¿jane apmeech icon mejiüran ineayiüna? ");
INSERT INTO huvNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’Nejinguind nerang najiüt ngondom marang minajiüt ijpüw monxey nóiquian, cos ndot apmandiüm marang leaw apiüng nop, ngome apmarang leaw apiüng alinop. Tengwüy xeyay mandiüm mandüüb nop, quiaj ngome apmandüüb wüx leaw apiüng alinop. Atquiaj ajlüy, nómban ngondom mendüüb Teat Dios sitiül meyac imeaats wüx xeyay tomiün aton ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ajcüwa fariseos wüx tanguiayiw aag ayaj, itsojayéjan Teat Jesús cos nejiw xowüy andiümdiümüw tomiün. ");
INSERT INTO huvNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Quiaj tasaj nejiw Teat Jesús: ―Icona ipiüngan najneaj irangan, pero irangánan majaw icon nipilan. Nganüy Teat Dios lamajaw nguineay imeajtsan. Cos meáwan leawa nipilan ayajcüw más netam, Teat Dios ngo mind majaw aag ayaj. ");
INSERT INTO huvNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","’Aaga poch tüünd Moisés, at leawa tandeacüw mondeac andeac Teat Dios ajlüyiw leaw tapeay aaga Juan neech yow nipilan. Naw quiaj ajmel anderac wüx aaga najneajay cambaj ocueaj Teat Dios. Nganüy meáwan nipilan tenguial mayambüw nguineay majmeliw tiül. ");
INSERT INTO huvNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","’Ngo maél ndrom ombas a cielo ndrom ombas a iüt, ngo matnej aél majcueat noic nine letra tiül Mipoch Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","’Sitiül nop naxey macueat mintaj nej maquiiüb alinop, aaga naxey quiaj ajiür xeyay nisoet. At jane apmaquiiüb nop najcueat najtaj ajiür xeyay nisoet ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Condom Teat Jesús tapiüng alinoic: ―Tajlüy nop naxey ajiür xeyay tomiün, asooig najneajay apix nej. Meáwan nüt ajlüy monet, ajlüy atnej nadam nangos nüt aniüng nej. ");
INSERT INTO huvNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","At aton tajlüy nop naxey netüneay nenüt Lázaro. Xeyay necoy axom nej, lamambich nej ombas. Nej mbójan amb mayacüch chetem mbeay minden a naxey nejiür quiaj. ");
INSERT INTO huvNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Aaga netüneay quiaj malüy apiüng alndom mamilmil müet leawa najmiüc tiüt teoleaj mimes a naxey nejiür quiaj. Pet ambüw malüpiw minecoy nej. ");
INSERT INTO huvNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Noic nüt aaga pobre Lázaro tandeow. Quiaj ángeles taquiüjpüw nej mamb andüy niüng ajlüy teat Abraham. Condom aaga nejiür quiaj, tandeow aton, ndoj tamiüraad. ");
INSERT INTO huvNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Aaga naxey nejiür quiaj tapeay tiül Hades niüng ambüw mondeow, teamamongoch xeyay ngo majneaj. Condom quiaj taxaing omal majaw miünquiaj; quiaj tajaw a Lázaro najneajay ajlüy almaquiiüb Teat Xan Abraham. ");
INSERT INTO huvNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Quiaj tendeac napac tapiüng: “¡Teat Abraham, ijiür xic lasta teat! Isaj a Lázaro maxec tiül yow micual owix nej, miün matequeech wüx xeniw mendeyndey, cos langondom, xeyay necoy teanamongoch tiül aaga biümb cam”, aw. ");
INSERT INTO huvNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Quiaj Abraham tasaj nej: “Xecual, ich leaam imeaats nguineay tajneaj ijlüy wüx iüt, tejiür meáwan leawa tendiüm; pero a Lázaro ngo majneaj tamongoch. Nganüy nej najneajay ajlüy ningüy, ique atüch ic memongoch aaga ngo majneaj quiaj. ");
INSERT INTO huvNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","At ajiür noic niüng angochay najal andüy tiüt naw ningüy andüy quiaj, ngondom mamongaran andüy niüng ijlüyiün; at imiün ninguiaj ngondom mamongaran andüy ningüy”, aj nej. ");
INSERT INTO huvNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Quiaj tasaj nej a naxey: “Teat Abraham, satün icueaj teat, isaj a Lázaro mamb aniüng xeteat. ");
INSERT INTO huvNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Cos alnajiür acoquiaw xechiig, sandiüm mamb masaj mayambüw Teat Dios; quiaj nejiw ngome aliücüw ningüy alinoic nüt tiül aaga biümb cam”, aj nej. ");
INSERT INTO huvNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Condom tasaj nej teat Abraham: “Alquiaj almajiürüw aaga poch tüünd teat Moisés, at leawa tarangüw mondeac andeac Teat Dios. Áag ich manguiayiw”, aj nej. ");
INSERT INTO huvNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Quiaj tapiüng a naxey: “Ngwüy Teat Abraham, ngome apmanguiayiw. Pero sitiül aljane mamb niüng ajlüyiw nejiw imiün tiül mondeow, quiaj nejiw apleaam omeajtsüw wüx Teat Dios”, aw. ");
INSERT INTO huvNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Teat Abraham tasaj nej: “Sitiül ngo marangüw leawa tapiüng teat Moisés, tengwüy ngo mayariw leawa tandeacüw ajcüwa mondeac andeac Teat Dios, masey mamb nop imiün tiül mondeow ngome apmayariw andeac”, aj nej ―aw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Condom Teat Jesús tasaj minipilan nej: ―Meáwan nüt apmajlüy leaw andiüm mayac icon wüx merangan ngo majneaj. Pero, ¡xeyay ngo majneaj apmamongoch leaw apmayac wüx alinop marang ngo majneaj! ");
INSERT INTO huvNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Najneaj maoelich teonic nej nop cow majlos tiül ndec, wǘxan nganaw mayac wüx marang ngo majneaj nop leaw jayats mayar sandeac. ");
INSERT INTO huvNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Netam mejawan nguineay apmerangan tiül icona. ’Sitiül aljane apmarang ngo majneaj wüx imbas, ipaj ocueaj. Sitiül nej leaad omeaats wüx aaga ngo majneaj tarang quiaj, matün perdon, pues iwün wüx imeaats leawa tarang. ");
INSERT INTO huvNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Jondot nop apmandeac wüx imbas ngo majneaj ayaíw andeac tiül noic nüt, ndoj tatün icueaj ayaíw atün mewün wüx imeaats aaga ngo majneaj lamandeac wüx imbas, ique netam mewün wüx imeaats nguitówan quiaj ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Condom miapóstoles nej Teat Jesús tasajüw nej: ―Teat, imbeol xicon naleaing nayacan ximeajtsan más wüx Teat Dios ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Quiaj tasaj nejiw Teat Jesús: ―Sitiül icona iyacan imeajtsan wüx Teat Dios masey iyajcan nepateayiün alndom merangan, atnej apateay osaab mostaza, apndom mesajan aaga xiül sicómoro quiaj: “Lojquiür, quiür piürar tiül ndec”, merajan, atquiaj apmajlüy ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Aton tasaj nejiw Teat Jesús: ―Jane nop tiül icona ajiür minerang najiüt nej nechiüt iüt, tengwüy nejiür wacüx, wüx apmapeay arang najiüt aaga nerang najiüt quiaj, apmasaj: “Imong, cheter, iret”, maj. ");
INSERT INTO huvNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Sapiüng ngwüy, ingow asaj aag ayaj apmasaj: “Irang süet, iyac mes. Leaw ndoj süet sanganeow ndoj teret a ique”, apmaj. ");
INSERT INTO huvNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ngwüy ¿netam masaja: “Dios mangüy ic”, apmaj, ajcan arang leaw netam maranga? ¡Ngwüy! ");
INSERT INTO huvNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Atquiaj wüx icona aton, wüx lamerangan leawa Teat Dios lamapiüng merangan, netam meyajcan ngome alngün xeyay najneaj terangan, cos terangan áagan leaw atüch icon merangan ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Teat Jesús tanaámb amb andüy Jerusalén, tamong niüng angochay iüt ocueaj Samaria maquiiüb Galilea. ");
INSERT INTO huvNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Wüx tapeay tiül noic nine cambaj, quiaj tambüw mangochiw nej gajpowüw monxey axom nejiw napat monandeow nenüt lepra. Miünquiájan lombojow ngo matüchiw nej. ");
INSERT INTO huvNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Tepajüw napac, tapiüngüw: ―¡Teat Jesús, Teat Naxey! ¡Ijiür xicon lasta! ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Wüx Teat Jesús tajaw nejiw, quiaj tasaj: ―Quiüran, ijchan majaw icon miteaats ocueajiiüts ―aj nejiw. Quiaj tambüw, condom wǘxan tenguial ajüyiw, quiaj tayajcüw lajneajiw, nómban ndroj a necoy. ");
INSERT INTO huvNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Condom nop nejiw wüx tajaw lajneaj, andilílan tiüt tamb, apac omeaats, teamandeac wüx leawa lamarang Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Taquieel micos nej mejquiet tiüt niüng ajlüy Teat Jesús masaj Dios mangüy nej. Aaga naxey quiaj naw Samaria. ");
INSERT INTO huvNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Condom Teat Jesús tapiüng: ―Neol, sayaag gajpowüw lajneaj iün andeowüw. ¿Jow al ojquiyej, wüliwe? ");
INSERT INTO huvNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Neol ngo majlüy alinop tiül nejiw miün müüch gracias Teat Diosa; neol áagan a napeay miün naxey cama? ―aw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Condom quiaj tasaj aaga naxey: ―Witiür quiür, nganüy lerneaj cos teyar sandeac ―aj nej Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Condom fariseos tatüniw manguiayiw Teat Jesús, tasajüw: ―¿Ngow ipiüng apmajlüy ningüy micambaj Teat Dios, aaga nüt wüx nejay Teat Dios apmajlüy wüx minipilan neje? ―ajüw nej. Quiaj tasaj nejiw: ―Wüx Teat Dios apmayac ningüy micambaj nej, aag ayaj ngondom maxoram majaraw. ");
INSERT INTO huvNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ngondom mapiürang wüx: “Jogüy”, tengwüy mapiürang: “Joíün”, cos micambaj Teat Dios lajlüy tiül icona ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Condom tasaj minipilan nej: ―Aliüc miün nüt apmendiüman mejawan masey noic nüt tiül aaga nüt wüx Teat Naxey lajlüy wüx micambaj nej; pero ngome apmejawan. ");
INSERT INTO huvNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Apmawaijchaw icon mapiüngüw: “Jogüy a Teat Naxey”, tengwüy: “Joíün.” Icona nde meamban mendüjpiün. ");
INSERT INTO huvNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Alinoic nüt wüx Teat Naxey aliüc apmajüic, cos apmajlüy atnej noic najlip wüx ajlipiich ngondom mexotüy, nómban arraj nguiajantanej. ");
INSERT INTO huvNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pero naleaing ombas netam mamongoch xeyay ngo majneaj, majcüy majaw nej nipilan najlüy nganüy cam. ");
INSERT INTO huvNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Aaga nüt wüx aliüc Teat Naxey apmajlüy atnej tajlüy tanomb wüx almapac Noé. ");
INSERT INTO huvNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Nipilan ngo meteotsüw wüx; netiw nanganeowüw, angoch owixaw atnej ajlüyay marangüw. Wüx tatüch aaga nüt wüx Noé tajmel tiül nadam müx; quiaj tajngot a yow, tandrooch nej ombasüw meáwan. ");
INSERT INTO huvNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Aton atnej tajlüy tanomb wüx almapac a Lot, nipilan aton ngo meteotsüw wüx; cos netiw, nanganeowüw, nengalayej, nenüübayej, nepiürüw, arangüw ombiümüw. ");
INSERT INTO huvNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Wüx taw quiaj a Lot tiül cambaj Sodoma tajmiüc biümb, at azufre imiün tiül cielo atnej ajoet. Quiaj tandrooch ombas meáwan leaw almajlüy tiül aaga cambaj quiaj. ");
INSERT INTO huvNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Atnej wüx aaga nüt quiaj ngome teateotsaran wüx nicuajind, atquiaj apmajlüy wüx a nüt aliüc Teat Naxey. ");
INSERT INTO huvNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’Wüx aaga nüt quiaj sitiül aljane ngo majlüy aniüng nej, nde majmel mawün leaw almajiür tiül iüm. Sitiül aljane altiül corrül, nde mandilil andüy aniüng nej. ");
INSERT INTO huvNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ich leaam imeajtsan nguineay tarang mintaj a Lot. ");
INSERT INTO huvNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Sitiül aljane ngo mayar sandeac cos imbol mambiyaw nej nipilan, wüx apmandeow apmamongoch xeyay ngo majneaj, ngome apmamb tiül cielo. Nganüy sitiül aljane ngo mapiüng wüx masey mandeow cos ayar sandeac, nej alinoic nüt apmajlüy xeyay najneaj tiül cielo. ");
INSERT INTO huvNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Aton sasaj icon, wüx aaga ongwiiüts quiaj ijpüw almameayiw wüx noic mats, nop apxaijnguiam, alinop apmajcueátan. ");
INSERT INTO huvNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Átan apmajlüy ijpüw montaj teanchiülüw nóiquian, nop apxaijnguiam, alinop apmajcueátan. ");
INSERT INTO huvNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ijpüw monxey tearangüw najiüt tiül corrül, nop apxaijnguiam, alinop apmajcueátan ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Wüx tanguiayiw aag ayaj minipilan nej, quiaj tasajüw nej: ―Teat ¿nguiane apmajlüy aag ayaja? ―ajüw nej. Quiaj tasaj nejiw: ―Niüng ajlüy nop nandeow, quiaj apsonongom a potwit ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Condom Teat Jesús tasaj nejiw alacas poch ngome aleaing miün, cos tandiüm müüch leaam omeajtsüw nguineay netam mandeacüw maquiüjpüw Teat Dios, matajcüw orar meáwan nüt nde paxiüm. ");
INSERT INTO huvNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Quiaj tapiüng: ―Tajlüy noic cambaj, ajlüy quiaj nop nejaw wüx asoeteran, ngo majiür lasta nipilan, at ngo mimbol mandüy Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Tiül aaga cambaj quiaj alquiaj nop najtaj lemben omal, lambójan amb quiaj masaj aaga naxey mandondoch noic moncüy. ");
INSERT INTO huvNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Pero aaga naxey quiaj ngo mandiüm. Ndójwüx tapiüng nejáyan quiaj: “Masey ngo najiür lasta nipilan, aton ngo nimbol nandüy Teat Dios; ");
INSERT INTO huvNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","nganüy sanarang leaw netam wüx mimoncüy aaga lemben omal najtaj quiaj, wǘxan nganaw müüch xic najcüy cos oleajleájan ningüy”, ―aw. ");
INSERT INTO huvNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Quiaj tapiüng Teat Jesús: ―Inguiayiün nguineay tapiüng aaga ngo majneaj nejaw wüx asoeteran quiaj. ");
INSERT INTO huvNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","¿Jow icona cuane ipiüngana? ¿Jow Teat Dios ngondom mambeol leaw monyamb neje, montün nej ocueaj nüt ongwiiütsa? ¿Ngwüy ipiüngana nequiy mambeol nejiwe? ");
INSERT INTO huvNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Xique sasaj icon, nej ngome apmequiy mambeol nejiw. Jow wüx aliüc Teat Naxey, ¿quia apmaxom wüx iüt nipilan leaw aliün mayacüw omeajtsüw wüx neje? ―aw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Condom tandeac alinoic poch Teat Jesús manguiayiw leaw apiüngüw nejiw xeyay najneaj arangüw, ngo matnejiw jangantanej nipilan. Tapiüng: ");
INSERT INTO huvNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","―Tajlüy ijpüw monxey, nop fariseo, alinop nesap mitomiün cambaj. Tambüw tiül nadam nangaj iüm metajcüw orar. ");
INSERT INTO huvNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Aaga fariseo wüx tataag orar, lombójan, atcüy tapiüng: “Süüch ic gracias Teat Dios, cos xique ngo mat xic jangantanej nipilan leaw moneed, monrang ngo majneaj, monjiür pálwüx montaj; aton ngo mat xic aaga nesap mitomiün cambaj quiaj. ");
INSERT INTO huvNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Xique saíünd ijmbüw tiül noic seman; aton sayac xechech aaga diezmo naw tiül meáwan leawa saxom”, aw. ");
INSERT INTO huvNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Nganüy aaga nesap mitomiün cambaj miünquiájan lembej, ngo mandiüm maxaing omal majaw cawüx, atoltol mal miíünd nej, tapiüng: “¡Teat Dios, xique nerangas ngo majneaj, ijiür xic lasta Teat!” aw. ");
INSERT INTO huvNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Xique sasaj icon aaga naxey nesap mitomiün cambaj quiaj, apmajtsor najneajay omeaats cos Teat Dios tanguiay nej andeac. Nganüy aaga fariseo ngwüy. Atquiaj ajlüy cos jane nelombojchay, nicuajind nej, apmamongoch monxing. Nganüy jane ayaag nicuajind nej, Teat Dios apmapiüng, najneajay arang ―aw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Condom taquiüraab niüng ajlüy Teat Jesús tegüy namix nine matepeayiw nej majend nej omalüw. Minipilan nej wüx tajawüw aag ayaj, tapots maliquiaw monquiiüb namix nine. ");
INSERT INTO huvNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Quiaj Teat Jesús tapaj minipilan nej masaj: ―Ijchan miünüw a namix nine niüng sajlüy, nde mepalan. Jangantanej apmajmel tiül micambaj Teat Dios netam majlüy atnej ajcüwa namix nine cam. ");
INSERT INTO huvNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Naleaing sasaj icon jane andiüm majmel tiül micambaj Teat Dios, sitiül ngo mandiüm marang atnej nop nine, nómban ngondom majlüy tiül ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Nop nenajiüt tiül judíos tatün manguiay Teat Jesús, tasaj: ―Teat, sajaw ique najneaj irang. Nganüy isaj xic Teat, ¿cuane netam narang, nguineay alndom napac meáwan nüt tiül cielo? ―aj. ");
INSERT INTO huvNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Quiaj tasaj nej Teat Jesús: ―¿Neol tepiüng xique nerangas najneaja? Nejinguind nipilan ngo marang najneaj; áagan Teat Dios arang najneaj. ");
INSERT INTO huvNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ique lamenguiay leaw andiüm Teat Dios, cos apiüng: “Nde mejiür minajtaj; nde membiy nipilan; nde merneed; nde merwaiich; iyar andeac miteat, mimüm” ―aj nej Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Quiaj tasaj nej aaga naxey quiaj: ―Teat, meáwan aag ayaj sayac wüx ximeaats nde sajngot miün ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Wüx tanguiay aag ayaj Teat Jesús, quiaj tasaj: ―Alíünan alinoic nganaw merang. Quiür inüüb leaw almejiür, condom imbaag ombeat meaach leawa nipilan ngo majiür, quiaj apmejiür tiül cielo xeyay nembeatmbeat, ndoj tewiün mendüüb xic ―aj. ");
INSERT INTO huvNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Aaga naxey wüx tanguiay aag ayaj ngo majneaj mayaag, tamix omeaats, ngo mandiüm mandrooch ombas leaw ajiür, cos nop nej nejiür xeyay. ");
INSERT INTO huvNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Wüx Teat Jesús tajaw amix omeaats aaga naxey, quiaj tapiüng: ―¡Xowüy laél majmeliw tiül micambaj Teat Dios ajcüwa monjiür xeyay! ");
INSERT INTO huvNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Más ngo maél nop camello mamong amb tiül owil nots ndiüc, ngo matnej aél ocueajiw a nipilan monjiür majmeliw tiül micambaj Teat Dios ―aw. ");
INSERT INTO huvNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Meáwan leawa tanguiayiw aag ayaj tapiüngüw: ―Sitiül atquiaj ajlüy, ¿jane alndom maw wüx asoet neje? ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Quiaj tasaj nejiw Teat Jesús: ―Leaw nipilan nómban ngondom marang, Teat Dios alndom marang ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Condom tasaj nej teat Pedro: ―Teat, xicona tacueatasan meáwan leaw tajiürasan para nandüjpiün ic ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Quiaj tasaj nejiw Teat Jesús: ―Naleaing sasaj icon, ngo majlüy nejinguind macueat aniüng nej, miteat nej, mimüm nej, micoj nej, michiig nej, mintaj nej, micual nej, para majlüy tiül micambaj Teat Dios, ");
INSERT INTO huvNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","leaw ngome apmüünd majiür alinomb meáwan leawa tacueat ningüy wüx aaga iüt cam, at alinoic nüt apmüünd mapac meáwan nüt tiül cielo ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Condom Teat Jesús tawün ninguiün quiriw ajcüwa gajpiüp minipilan nej, tasaj: ―Nganüy tabaats matüchiiüts Jerusalén. Quiaj apmajlüy atnej lamapiüngüw mondeac andeac Teat Dios nguineay apmarangüch wüx ombas a Teat Naxey. ");
INSERT INTO huvNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Cos apmayacüch teowixaw napeay miün nipilan; apmitsojow nej mandeacüw ngo majneaj wüx ombas; apmateontsüw wüx ombas nej onts ombeayiw nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Apmatoliw, condom apmambiyaw nej nómban. Ndoj, wüx er nüt apmapac alinomb ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Pero nejiw ngo maxomüw omeajtsüw wüx aag ayaj, ngo majawüw cuane wüx amb apiüng; cos ngo müjndiw majawüw. ");
INSERT INTO huvNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Teat Jesús wüx laliüc mapeay tiül cambaj Jericó, alquiaj nop naxey nesomb alchetem mbeay tiiüd teatüneay. ");
INSERT INTO huvNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Aaga naxey quiaj wüx tanguiay xeyay nipilan teamong, quiaj tatün manguiay cuane najlüy. ");
INSERT INTO huvNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Quiaj tasoic Teat Jesús naw Nazaret namong amb quiaj. ");
INSERT INTO huvNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Condom tepaj napac: ―¡Teat Jesús, micual David, ijiür xic lasta! ―aw. ");
INSERT INTO huvNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Quiaj taliquiaw nej leaw monmong ombas, macueat apaj. Pero nej tayac wüx alquiriw apaj, tapiüng: ―¡Micual David, ijiür xic lasta! ―aw. ");
INSERT INTO huvNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Quiaj Teat Jesús lembet, tapiüng mamb majanüch aaga naxey quiaj. Wüx tapeay niüng ajlüy nej, tatün manguiay, tasaj: ");
INSERT INTO huvNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―¿Cuane ipiüng, teat? ―aj. Quiaj tasaj nej aaga naxey: ―Teat, sandiüm meaach majneaj xiniiüg, sandiüm naxom najaw ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Quiaj tasaj nej Teat Jesús: ―Nganüy apmexom mejaw; lerneaj cos teyac imeaats wüx xique ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Andǘüban rat oniiüg, condom tandüüb mamb Teat Jesús, tüüch gracias Teat Dios. At meáwan nipilan wüx tajawüw aag ayaj tandeacüw najneaj wüx Teat Dios aton. ");
INSERT INTO huvNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Condom Teat Jesús tapeay Jericó, tamong amb tiül cambaj. ");
INSERT INTO huvNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Alquiaj nop naxey nejiür xeyay tomiün, nenüt Zaqueo, minatang ocueajiw monsap mitomiün cambaj. ");
INSERT INTO huvNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Aaga Zaqueo quiaj andiüm matüch niüng ajlüy Teat Jesús majaw. Pero ngondom cos tequech oleaj, aton cos xeyay nipilan alquiaj. ");
INSERT INTO huvNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Leawa tarang, tecuiür tamong ombas, tajtep noic owil xiül nenüt sicómoro para maxom majaw, cos Teat Jesús netam mamong amb quiaj. ");
INSERT INTO huvNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Wüx tatüch quiaj Teat Jesús, taxaing omal majaw cawüx. Tajaw a Zaqueo, quiaj tasaj: ―¡Zaqueo! ¡Ernguialeateay, iriow tiüt! Cos nganüy netam naxood iniüng ―aj. ");
INSERT INTO huvNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Almanguiay aag ayaj a Zaqueo, ajchícan tiüt tamb mangoch Teat Jesús, apac omeaats. ");
INSERT INTO huvNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Meáwan nipilan wüx tajawüw aag ayaj tapots andeacndeacüw wüx. Tapiüngüw Teat Jesús laámb maxood aniüng nop nerang xeyay ngo majneaj. ");
INSERT INTO huvNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Pero Zaqueo witiüt lembem masaj Teat Jesús: ―Nganüy Teat, leaw alnajiür sanawün pinawan nüüch leawa ngo majiür; at sitiül aljane aleaic lanayar ocueaj wüx sawaiich, nganüy sanandilil nüüch alapiquiw atow nej sayar ―aj. ");
INSERT INTO huvNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Quiaj tapiüng Teat Jesús: ―Wüx aag ayaj ajüiquich nej laáw wüx asoet, cos aaga naxey cam aton nop micual mixejchiiüts Abraham. ");
INSERT INTO huvNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Teat Naxey iün mayamb meáwan nipilan mawün wüx asoetiw leawa landrojow tiül arangüw ngo majneaj ―aw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Wüx laliüc mapeayiw Jerusalén, quiaj Teat Jesús tandeac alinoic poch masaj ajcüwa nipilan quiaj müüch nejiw majawüw ngome laliüc matüch aaga nüt wüx Teat Dios apmajlüy wüx micambaj nej. ");
INSERT INTO huvNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Condom tasaj nejiw: ―Tajlüy nop naxey netamtam ajlüy nipilan, tamb tiül noic cambaj miünquiaj mayar minajiüt nej marang natang nenajiüt, cas tandilil. ");
INSERT INTO huvNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Wǘxan nganaw mamb, tapaj gajpowüw monrang minajiüt nej. Tüüch anopnopoj noic tomiün xeyay nembeat, ndoj tasaj nejiw: “Iyamban nguineay alndom mexoman wüx alquiriw aaga tomiün cam, ndoj apmeajchiün xic leaw sapeay”, aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ajcüwa nipilan micual miíüt nej ngo mandiümüw, ajcüyiw majawüw nej. Áag tüjchiw mamb noic ajlüy nipilan mapiüngüw ngo mandiümüw aaga naxey quiaj marang natang nenajiüt tiül nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Masey atquiaj tarangüw, aaga naxey tayar minajiüt nej. Ndoj tandilil andüy tiül miíüt nej. Wüx lapeay, quiaj tapaj monrang minajiüt nej leawa tüüch tomiün, majaw nguitow lamaxomüw wüx anopnopoj. ");
INSERT INTO huvNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Aaga ombas mapeay tasaj nej: “Teat, jogüy mitomiün, lanaxom wüx algajpowüw”, aj nej. ");
INSERT INTO huvNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Quiaj tasaj nej aaga natang nenajiüt: “Najneajay terang cos terang leaw sapiüng; masey napateay süüch ic, ique teyamb nguineay mexom wüx alquiriw. Nganüy sanüüch ic mejlüy wüx gajpowüw cambaj”, aj nej. ");
INSERT INTO huvNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Condom wüx tapeay alinop tasaj nej: “Teat, jogüy mitomiün, lanaxom wüx alacoquiaw”, aj nej. ");
INSERT INTO huvNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","At tasaj nej aaga natang nenajiüt: “Nganüy sanüüch ic mejlüy wüx acoquiaw cambaj”, aj nej. ");
INSERT INTO huvNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Quiaj tapeay alinop masaj nej: “Jogüy mitomiün, teat. Tayacas tiül noic nine püy. ");
INSERT INTO huvNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Cos ximbol nandüy ic teat, sayaag xowüy apmejcüy. Cos sajaw ique ixaing omeaats corrül masey ngome ique ipiür, at ique iwit masey ngome ique itendeay”, aj nej. ");
INSERT INTO huvNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Quiaj tasaj nej aaga natang nenajiüt: “Ngo majneaj irang, aaga poch leaw indeac quiaj ayac isoet. Sitiül lamejaw xique napatas, sawit leaw ngo nayac, at sitiül ipiüng saxaing masey ngome xique sapiür; ");
INSERT INTO huvNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿neol ngo meyac tiül banco xetomiün? Quiaj wüx sanapeay nayar, lamaxom wüx alquiriw”, aj nej. ");
INSERT INTO huvNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Condom tasaj leaw aliw quiaj: “Inojtiün ocueaj a tomiün; ijchan aaga nejiür gajpowüw”, aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Quiaj tasajüw nej: “¡Teat, aag ayaj lamajiür gajpowüw!”, ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Quiaj tasaj nejiw aaga natang nenajiüt quiaj: “Naleaing sasaj icon, leawa tayamb nguineay mayac wüx alquiriw, apmüünd xeyay; nganüy jane ngo mayamb nguineay maxom wüx alquiriw, apmajnot ocueaj aaga leawa tüünd”, aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","At tapiüng: “Iquiüjpan miün ningüy niüng sajlüy; imbiyan ajcüwa moncüy majaw xic leaw ngo mandiümüw narang minatangüw nejiw”, aw a natang nenajiüt ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ndoj mapiüng aag ayaj, Teat Jesús tanaámb tamb andüy Jerusalén. ");
INSERT INTO huvNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Wüx laliüc matüchiw mal cambaj Betfagé, at Betania, niüng ajlüy aaga tiüc nasoic mitiüc Olivos, quiaj tüüch mamb ijpüw minipilan nej. ");
INSERT INTO huvNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Tasaj: ―Quiüran tiül aaga cambaj quiün. Wüx apmepeayiün quiaj, apmexoman nop quicheech bur netsaag quiaj, nganaw müünd memas. Ichejtiün iquiüjpan miün. ");
INSERT INTO huvNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Sitiül aljane matün manguiay icon neol techejtiün, isajan: “Cos Teat Naxey neech xicon niünan najanan apmetam nej”, irajan ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Condom ajcüwa minipilan nej tambüw, taxomüw a bur atnej lamasaj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Naleaing wüx teamachejtiw, quiaj tasaj nejiw moneay nej: ―¿Neol techejtiün a bur quiaja? ―ajüw nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Quiaj tasajüw: ―Cos Teat Naxey nesaj xicon niünan najanan, apmetam nej ―ajüw. ");
INSERT INTO huvNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Quiaj taquiüjpüw mamb a bur andüy niüng ajlüy Teat Jesús. Condom tayacüw wüx opech a bur apixaw nejiw, cas tatepichaw wüx Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Quiaj nipilan tapots mapojchiw tiüt tiül tiiüd apixaw nejiw niüng apmamong Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Wüx laliüc matüchiw niüng amiücüch tiüt mitiüc Olivos, quiaj meáwan nipilan leaw almandüjpiw nej, ajcüwa monyar nej aquiaach, tepajüw apac omeajtsüw, tandeacüw najneaj wüx Teat Dios cos tajawüw meáwan najneaj leawa tarang Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Tapiüngüw: ―¡Apac omeajtsaats cos lapeay nop leaw iün wüx minüt Teat Dios! ¡Nej natang nenajiüt! ¡Najneajay ajlüy tiül cielo; najneajay ajlüy Teat Dios! ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Altiül nipilan acas fariseos, tasajüw Teat Jesús: ―Teat, iliquiaw mapalüw ombeayiw ajcüwa minipilan quiaj ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Quiaj Teat Jesús tasaj nejiw: ―Xique sasaj icon sitiül ajcüwa nipilan cam ndijchiümoj, piedra apmangochiw apmendeacüw ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Wüx laliüc matüchiw cambaj Jerusalén, Teat Jesús taxom majaw a cambaj, quiaj tamix omeaats, tajiünts majaw. ");
INSERT INTO huvNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Tapiüng: ―¡Malüy ram iniüjcan mejawan nganüy nüt cam, ajlüy leaw alndom müüch icon mejiüran monajneaj! Nganüy naél mejawan, nexotüy, ngondom mejawan. ");
INSERT INTO huvNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Aliüc miün nüt apmajlüy xeyay ngo majneaj apmatüch icon. Cos ajcüwa ijcüyiün mequiüjpan apmayeyiw icon tiüt; apmapalüw icon mayacüw icon pinawan. ");
INSERT INTO huvNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Apndajrriüm tiüt meáwan imbiüman, ngome apmacül noic piedra mesapüy maquiiüb alinoic. At icona nóiquian mequiüjpan micualan apmümb ndrom imbasan, cos ngome teyariün wüx Teat Dios tiün mawün icon wüx ―aw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Condom Teat Jesús tajmel tiül nadam nangaj iüm, quiaj tapots mawün meáwan monüjpeay, mongalüy leaw aliw tiül. ");
INSERT INTO huvNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Tasaj nejiw: ―¿Neol ngo leaam imeajtsana nguineay apiüng tiül Mipoch Teat Diosa? Cos apiüng: “Saniüng ajlüy niüng alndom matajcüch orar”; pero icona lamerangan aaga nadam nangaj iüm cam atnej niüng axotüy moneed ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Teat Jesús nütnǘtan aquiaach nipilan tiül nadam nangaj iüm. Ajcüwa montangtang miteaats, at mondüy wüx aaga poch tüünd Moisés, at monajiüt ocueaj nipilan judío, tapots mayambüw nguineay alndom mambiyaw nej. ");
INSERT INTO huvNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Naleaing ngo maxomüw cuane wüx masapüw nej, cos meáwan nipilan xeyay andiümüw manguiayiw andeac nej. ");
INSERT INTO huvNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Noic nüt Teat Jesús teaquiaach nipilan tiül aaga nadam nangaj iüm tiül Jerusalén, teamapiüng nguineay alndom mawaran wüx nisoet. Quiaj tapeayiw niüng ajlüy nej montangtang miteaats, mondüy wüx aaga poch tüünd Moisés, at natangtang monajiüt tiül judíos. ");
INSERT INTO huvNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Quiaj tasajüw nej: ―Isaj xicon nguiane teyar minajiüt merang aag ayaj. ¿Jane neech ic? ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Quiaj tasaj nejiw Teat Jesús: ―Ata xique aton sanatün nanguiay icon noic poch. Isajan xic: ");
INSERT INTO huvNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Jow aaga Juan, wüx tüüch yow nipilan, ¿jane ipiüngan nesaj nej marang aag ayaja? ¿Diosa, ngwüy nipilana? ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Quiaj tendeacndeacüw nejeyéjan quiaj, tapiüngüw: ―¿Cuane apmapiüngaatsa? Cos sitiül apmapiüngaats Teat Dios neech nej miün, quiaj apmasaj icoots: “¿Neol ngo meyariün andeac neje?” apmaw. ");
INSERT INTO huvNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Sitiül apmapiüngaats nipilan, apmambiyaw icoots cambaj, apmaloxiw icoots, cos meáwan nipilan apiüngüw aaga Juan nop nendeac andeac Teat Dios nej ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Tapiüngüw ngo majawüw jane neech nej miün a Juan. ");
INSERT INTO huvNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Quiaj tasaj nejiw Teat Jesús: ―Ata xique aton ngo nasaj icon jane neech xic niün narang aaga teanarang cam ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Condom quiaj Teat Jesús tapots masaj nipilan acas poch andüy wüx napiürüch, tapiüng: ―Tajlüy nop naxey tapiür xeyay owil uva tiül micorrül nej, condom nej taw quiaj tamb xeyay nüt. Tayac teowix nipilan a corrül quiaj. ");
INSERT INTO huvNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Wüx tatüch a nüt mapeederan a uva, quiaj aaga neneay corrül tüüch mamb nop nerang minajiüt nej mamb majaw monrang najiüt mayar leaw aneay nej neneay iüt. Pero tatoliw nej, ndoj tüjchiw mandilil owíxan, ngo müjchiw nicuajind. ");
INSERT INTO huvNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Condom aaga neneay iüt tandüy wüx müüch mamb alinop nerang minajiüt nej. Átan wüx tapeay quiaj angochiw miün nej, tapots matoliw. Condom tandilil aton owíxan, ngo müjchiw nicuajind. ");
INSERT INTO huvNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Aaga neneay corrül tandüy wüx müüch mamb alinop nerang minajiüt nej. Átan wüx tapeay quiaj, angochíwan mawüjchiw nej, landüy wüx apmambiyaw. Tawüniw maloxiw ninguiün. ");
INSERT INTO huvNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Ndójwüx quiaj tapiüng aaga naxey neneay corrül: “Jow nganüy, ¿nguineay sanaranga? Sanüüch mamb xecual, aag xowüy sajiür lasta. Sapiüng wüx apmajawüw nej apmarangüw leawa nej apiüng”, aw. ");
INSERT INTO huvNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Pero ajcüwa monrang najiüt tiül corrül wüx tajawüw micual neneay iüt, quiaj tapiüngüw nejíwan quiaj: “Nej aag ayaj apmaneay aaga corrül cam. Tabaats mambiyaats, ndoj icoots apmaneayiiüts a iüt cam”, awüw. ");
INSERT INTO huvNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Quiaj tasapüw, tawüniw tiül corrül, tambiyaw. ¿Cuane ipiüngan apmarang a neneay iüt wüx ombasüw ajcüwa monrang najiüt quiaja? ");
INSERT INTO huvNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Pues apmamb mambiy nejiw, condom apmayamb alinoic ajlüy monrang najiüt mayac teowixaw aaga corrül quiaj ―aj nejiw Teat Jesús. Ajcüwa nipilan wüx tanguiayiw aag ayaj, tapiüngüw: ―¡Malüy Dios ngo marang atquiaj! ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Teat Jesús tajaw teombasüw nejiw, quiaj tapiüng: ―¿Neol, cuane wüx amb apiüng tiül Mipoch Teat Dios? niüng apiüng: Aaga piedra leawa taloxiw ninguiün monrang iüm, nganüy laíün marang xeyay netam piedra tiül oxing iüm. ");
INSERT INTO huvNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Jane apmajmiüc wüx aaga piedra quiaj, apmapol nej; pero sitiül aaga piedra quiaj apmajmiüc wüx ombas aljane, nómban apmacuiaach tiüt ―aw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ajcüwa montangtang miteaats at mondüy wüx aaga poch tüünd Moisés quiájan tandiümüw masapüw nej, cos tayajcüw aaga andeac quiaj andüy wüx ombasüw nejiw amb apiüng. Pero timboloj mandüyiw nipilan, áag taton ngo marangüw nicuajind. ");
INSERT INTO huvNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ndoj tüjchiw mamb acas monxey mandacüwiw. Ajcüw ayaj ajüic atnej najneaj arangüw, pero ambüw mayambüw nguineay alndom mandacüwiw, masapüw wüx, mayambüw leaw andeac Teat Jesús, mayacüw nej teowix natang nenajiüt. ");
INSERT INTO huvNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Quiaj tiünüw masajüw nej: ―Teat, sajawan ique indeac iquiaach leaw naleaing, ngo mewaiich. At aton ique ngo mepiüng wüx jane tiül nipilan netam, jane ngo metam. Ique iquiaach Mipoch Teat Dios atnej netam. ");
INSERT INTO huvNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Nganüy isaj xicon ¿naleaing netam majwan tomiün müünd aaga César, ngwüy ngo metama? ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Teat Jesús tajaw neol tatüniw nej manguiayiw aag ayaj, quiaj tasaj nejiw: ―¿Neol tendiüman meyacan xic wüx naéle? ");
INSERT INTO huvNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Ich miün noic tomiün majawaats. ¿Jane mitey alwüxe, aton jane minüt alwüx a tomiün cama? ―aj nejiw. Quiaj tasajüw nej: ―César ―ajüw. ");
INSERT INTO huvNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Quiaj tasaj nejiw: ―Ijchan a César leaw aneay nej, aton ijchan Teat Dios leaw aneay Teat Dios ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ngo maxomüw alngün poch leaw alndom masapüw wüx, áag leawa tandeac niüng teamanguiayiw nipilan. Leawa tarang, nejiw mbayatoj manguiayiw leaw asaj nejiw, ndijchiütójan. ");
INSERT INTO huvNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Condom acas saduceos tambüw majawüw Teat Jesús. Ajcüwa saduceos quiaj apiüngüw mondeow langome apmapacüw alinomb. ");
INSERT INTO huvNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Tasajüw Teat Jesús: ―Teat, Moisés tarang tiül minawiig nej, tapiüng: Sitiül nop naxey mandeow, macül mintaj nej lemben omal, ngome tajiürüw micualüw nejiw, quiaj michiig nej netam mengoch owix aweaag aaga lemben omal quiaj, majiürüw micualüw majüic atnej micoj nej tajiür micual nej. ");
INSERT INTO huvNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Tajlüy ayaíw monxey nop necual nejiw. Aaga natang nacualaran tengoch owix, ndoj tandeow wüx nganaw majiürüw micualüw nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Condom quiaj michiig nej tengoch owix aweaag aaga najtaj lemben omal quiaj. Átan tandeow aaga naxey, nganaw majiürüw micualüw nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Atanquiaj tarang amb arojpüw. Ajcüw ayaíw monxey quiaj, tengoch owix maquiiüb aaga najtaj, pero ngome tajiürüw micualüw nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ndójwüx nejay aaga najtaj tandeow. ");
INSERT INTO huvNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","¿Jow alinoic nüt wüx apmapacaran tiül mondeow, ngün tiül ajcüwa monxey apmaquiüjpüw aaga najtaja? Cos miayaíw tengoch owixaw maquiüjpüw ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Quiaj tasaj nejiw Teat Jesús: ―Nipilan tiül aaga nüt cam angoch owixaw. ");
INSERT INTO huvNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Pero jane apmapac tiül mondeow mamb tiül cielo, ngome apmajlüy atquiaj, ngome apmajlüy angoch owixeran. ");
INSERT INTO huvNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Langondom mandeowüw alinomb, apmajlüyiw at nejiw ángeles, apmajlüyiw micual nejiw Teat Dios aton, cos nej lamapacüüch nejiw tiül mondeow. ");
INSERT INTO huvNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Nganüy wüx aaga apacaran tiül mondeow quiaj, nejay teat Moisés taquiaach wüx tiül minawiig nej niüng tapiüng tajaw noic owil nine xiül leaw teandaab. Tiül aaga nawiig quiaj apiüng: Teat Dios Midios Abraham, Midios Isaac, Midios Jacob. ");
INSERT INTO huvNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Cos Teat Dios ajaw meáwan nipilan almapac, ngo majlüy leaw landeow nómban. Teat Dios ngome midiosüw mondeow, nej midiosüw leaw almapac ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Condom acas mondüy wüx aaga poch tüünd Moisés tasajüw Teat Jesús: ―Najneajay aaga ipiüng quiaj Teat ―ajüw. ");
INSERT INTO huvNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Quiaj lango matüntüniw manguiayiw nej. ");
INSERT INTO huvNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Condom quiaj tasaj nejiw Teat Jesús: ―¿Neol tapiürang wüx aaga Cristo, teat David mixeech neje? ");
INSERT INTO huvNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Nejay a David tapiüng tiül aaga nawiig nenüt Salmo: Teat Dios tasaj a Teat Naxey: “Cheter ningüy wüx xeác, ");
INSERT INTO huvNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","leaw ndoj nayac ajcüwa moncüy majaw ic maquiejliw micosüw nejiw timbas.” ");
INSERT INTO huvNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","¿Nguineay alndom mapiürang David mixeech aaga Cristo sitiül nejay David tasaj: Teat Naxey? maj, ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Meáwan nipilan teamanguiayiw, quiaj Teat Jesús tasaj minipilan nej, tapiüng: ");
INSERT INTO huvNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―Nde merangan mat nejiw ajcüwa mondüy wüx aaga poch tüünd Moisés, cos nejiw xowüy andiümüw majüyjüyiw niüng ajlüy xeyay nipilan, asoijquiw najaljal apixaw nejiw. Aton xowüy andiümüw matepeayaranüw. Ayambüw leaw najneaj bang tiül sinagoga chetemoj quiaj. At aton xowüy ayambüw chetemoj niüng chetejow netamtam nipilan niüng ajlüy monet. ");
INSERT INTO huvNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","At anojtiw aniüngüw monlemben omal montaj, at meáwan leaw almajiürüw. Ndoj andiümüw maxotüw arangüw aaga ngo majneaj quiaj, atajcüw orar xeyay majaw nejiw nipilan. Ajcüw ayaj ombeayíwan, nejiw apmüjndiw mamongochiw xeyay ngo majneaj alinoic nüt ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Wüx Teat Jesús altiül nadam nangaj iüm tajaw nipilan monjiür xeyay tomiün nguineay teamayacüw ichechiw nejiw tiül iquial nichech. ");
INSERT INTO huvNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Átan tajaw nop lemben omal müm najtaj tayac ichech nej ijquiaw nine tomiün. ");
INSERT INTO huvNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ndoj quiaj tapiüng: ―Naleaing sasaj icon, aaga müm najtaj lemben omal quiaj, nej teyac xeyay, ngo mat nejiw ajcüwa nipilan quiaj. ");
INSERT INTO huvNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Cos meáwan lamayacüw leaw nenaw ocueajiw. Nganüy aaga müm najtaj quiaj tayac meáwan leaw tajiür, masey lango majiür ombeat üet nej ―aw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Altiül teandeacndeacüw wüx aaga nadam nangaj iüm nguineay ajneaj, nguineay atsajüy ombas aaga piedra, at cuajantanej najneajneaj nichech leaw tayacüch tiül nangaj iüm. Wǘxan teamandeacüw wüx meáwan aag ayaj, quiaj tasaj nejiw Teat Jesús: ");
INSERT INTO huvNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","―Meáwan aag leawa temejawan nganüy cam, alinoic nüt apndrom ombas. Ngome apmajlüy masey anoic piedra nesapüy maquiiüb alinoic, cos meáwan apmateajquich ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Condom quiaj tatüniw nej manguiayiw, tasajüw: ―Teat ¿ngow apmajlüy aag ayaja? ¿Cuane apmajlüy majaraw ngow apmajlüy aag ipiüng quiaja? ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Quiaj tasaj nejiw Teat Jesús: ―Ijawan, nde mawaiich icon nejinguind. Cos xeyay nipilan aliücüw miün, apmandeacüw wüx xique. Altiül apmapiüngüw: “Xique aaga Cristo, nganüy lamatüch a nüt”, apmawüw. Xique sasaj icon nde meyariün andeacüw ajcüwa nipilan quiaj. ");
INSERT INTO huvNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Wüx apmenguiayiün lajlüy montsoj, lajlüy moncüy, nde mbayameron cos atquiaj netam majlüy ombas; naleaing nganaw matüch a nüt ndrom ombas a iüt cam ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Condom tandüy wüx masaj nejiw: ―Noic iüt apmajcüyiw majawüw monaw tiül alinoic iüt. ");
INSERT INTO huvNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Aton apmajlüy xeyay nadam ateam, apmajlüy lop, apmajlüy monandeow tiül palpálwüx cambaj; aton apmajlüy xeyay monbayan. Átan apmajaraw xeyay cuajantanej cawüx tiül cielo. ");
INSERT INTO huvNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’Naleaing wüx nganaw majlüy meáwan aag ayaj, apmayambüch imbasan, apndeaameron mayacüw icon teombasüw monajiüt tiül sinagoga. Apmejmeliün tiül manchiüc; apmequiürajpan niüng ajlüyiw montangtang monajiüt. Apmemongochiün aag ayaj ajcan iyariün sandeac. ");
INSERT INTO huvNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Atquiaj icona alndom mendeacan wüx xic nguiajantanej. ");
INSERT INTO huvNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Nde meyamban imeajtsan cuane apmepiüngan, nguineay alndom meriowan wüx. ");
INSERT INTO huvNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Cos xique sanüüch icon poch cuane apmepiüngan; sanüüch icon mexoman imeajtsan. Quiaj meáwan leawa teajcüyiw majawüw icon ngondom maxomüw cuane apmapiüngüw mangochiw indeacan. ");
INSERT INTO huvNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Aton miteatiün, micojon, michijquian, icualajtsan, miamigojan, apmayacüw icon teowixaw monajiüt. Altiül icon apmembiyaranan. ");
INSERT INTO huvNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Meáwan nipilan apmajcüyiw majawüw icon ajcan iyariün sandeac. ");
INSERT INTO huvNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Naleaing ngome apndrom ombas masey nots miondeats imalan, cos teamajiür icon Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Sitiül icona apmeiücan wüx meáwan aag ayaj, najneajay apmejlüyiün alinoic nüt, cos apmepacan meáwan nüt tiül cielo. ");
INSERT INTO huvNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Wüx apmejawan a cambaj Jerusalén laímb mayey nej tiüt soldados, quiaj alndom mepiüngan lamatüch a nüt mandrojchich ombas. ");
INSERT INTO huvNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Pues leaw altiül Judea ich mecuiür andüy wüx tiüc; leaw altiül cambaj Jerusalén ich maw quiaj; at leaw altiül corrül nde mandilil andüy tiül cambaj. ");
INSERT INTO huvNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Cos aaga nüt quiaj apmamongocharan xeyay ngo majneaj. Netam majlüy meáwan leawa lajlüy tiül Mipoch Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Pobre nejiw ajcüwa montaj leaw alteomeajtsüw micualüw nejiw, at leaw ajiür nine tealeámban achech wüx aaga nüt quiaj! Apmajlüy xeyay necoy wüx aaga iüt cam, cos Teat Dios apmüüch mamongochiw ngo majneaj ajcüwa nipilan cam. ");
INSERT INTO huvNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Altiül apmandeowüw tiül montsoj; altiül apmambüw pres andüy tiül palpálwüx iüt; pálwüx nipilan apmarangüw leaw andiümüw marangüw wüx cambaj Jerusalén, leaw palaw a nüt ocueajiw pálwüx nipilan ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Condom Teat Jesús tandüy wüx masaj nejiw, tapiüng: ―Apmajaraw xeyay cuajantanej wüx ocas, wüx nüt, wüx caaw, at ningüy wüx iüt aton. Nipilan xeyay apmbayamoj, lango majawüw cuane apmarangüw, cos apmeterriür napac a nadam ndec, apmajlüy nadamdam ajponch aton. ");
INSERT INTO huvNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Altiül nipilan apojniüm teombasüw cos xeyay apmbayamoj wüx apmajawüw leawa apmajlüy, cos meáwan leaw almajlüy cawüx tiül cielo apmajüyjüy. ");
INSERT INTO huvNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Quiaj apmajaraw aaga Teat Naxey aliüc amb tiül oic xeyay najneajay ajlüy, ayey nej tiüt nelitlit, cos lamarang minatang nenajiüt. ");
INSERT INTO huvNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Wüx ijawan lawitiow majlüy meáwan aag ayaj, ich mapac imeajtsan xeyay, cos laliüc meriowan tiül meáwan ngo majneaj ―aw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Condom tasaj nejiw alacas poch andüy wüx xiül, tapiüng: ―Ijawan nguineay arang a toc, tengwüy cuajantanej alinoic xiül. ");
INSERT INTO huvNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Cos wüx aptsatsam, quiaj ajüic laliüc matüch nüt wüx apmerraar. ");
INSERT INTO huvNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","At a nganüy wüx apmejawan lajlüy aag lanasaj icon quiaj, quiaj apmejawan laliüc matüch a nüt wüx Teat Dios apmajlüy wüx micambaj nej. ");
INSERT INTO huvNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Naleaing sasaj icon, meáwan aag ayaj apmajlüy wüx aliün majlüyiw ajcüwa nipilan quiaj. ");
INSERT INTO huvNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Masey a iüt at a cielo apndrom ombasüw, xepoch apmajlüy meáwan nüt, ngome apndrom ombas. ");
INSERT INTO huvNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Ijawan wüx, nde meatmeatíünan memongochiün wüx iretiün, nde mengüniün, nde meyacan imeajtsan wüx leaw alndom mexoman wüx aaga iüt cam, ndot quiaj matüch a nüt. ");
INSERT INTO huvNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Cos wüx aaga nüt aliüc, ngome teamateotsüw wüx meáwan nipilan ningüy wüx iüt. ");
INSERT INTO huvNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Wüx aag ayaj netam mepacan, meáwan ores meáwan nüt netam metajcan orar, metüniün ocueaj Teat Dios meriowan tiül meáwan aaga ngo majneaj leaw apmajlüy quiaj, mejlüyiün najneajay niüng ajlüy Teat Naxey ―aw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Teat Jesús, noic nüt teaquiaach tiül nadam nangaj iüm. Wüx langwiiüts taw quiaj; tamb andüy wüx aaga tiüc nasoic mitiüc Olivos. ");
INSERT INTO huvNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Xeyay nipilan tiül cambaj rawrráwan tiüt ambüw tiül nadam nangaj iüm manguiayiw aquiaach nej. ");
INSERT INTO huvNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Laliüc matüch nangos nüt ocueajiw nipilan judío, aaga nasoic pascua, aaga nüt wüx üeteran pan ngo majmel levadura. ");
INSERT INTO huvNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ajcüwa natangtang miteaats at mondüy wüx aaga poch tüünd Moisés tayambüw nguineay alndom mambiyaw Teat Jesús, pero timboloj mandüyiw nipilan. ");
INSERT INTO huvNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Quiaj a natang nimeech Satanás tajmel tiül omeaats a Judas Iscariote, nej nop tiül ajcüwa gajpiüp (12) minipilan Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Aaga Judas quiaj tamb masaj natangtang miteaats, at montang monajiüt tiül nadam nangaj iüm, tasaj nejiw nguineay alndom mayac teowixaw nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Nejiw quiaj tapac omeajtsüw, tasajüw apmüjchiw nej tomiün. ");
INSERT INTO huvNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Condom nej tapiüng apmayac teowixaw nejiw; quiaj tapots mayamb nguineay marang aag ayaj wǘxan ngo majlüy quiaj nipilan. ");
INSERT INTO huvNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Condom tatüch a nangos nüt wüx üeteran pan ngo majmel levadura. Aaga nüt quiaj netam mandeow sap majmel marang nichech wüx pascua. ");
INSERT INTO huvNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Quiaj Teat Jesús tüüch mamb a Pedro maquiiüb a Juan, tasaj: ―Quiüran ijawan cuane apmetam icoots wüx apmetiiüts wüx nangos nüt pascua ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Nejiw quiaj tasajüw Teat Jesús: ―¿Nguiane ijac indiüm, Teat, namban narangan aag ayaja? ―ajüw. ");
INSERT INTO huvNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Teat Jesús tasaj nejiw: ―Wüx apmejmeliün tiül cambaj, quiaj apmexoman nop naxey ajoy nop ngan yow. Indüjpiün mamb aaga najüy quiaj, apmayac icon tinden niüng andüy quiaj. ");
INSERT INTO huvNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Condom quiaj apmesajan neneay iüm: “Apiüng Teat Naxey: ¿Nguiane ajlüy niüng saxejnenguenon netiün wüx pascua naquiiüb xenipilana? aw”, apmerajan. ");
INSERT INTO huvNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Quiaj apmatiib icueajiün nop nadam teomeaats iüm cawüx amb ijpüw iüm, landoj lamatajcüw majneaj. Andüy quiaj apmeyacan üetiiüts ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Condom quiaj tambüw. Taxomüw meáwan atnej lamasaj nejiw Teat Jesús. Quiaj tambüw mayacüw leaw apmüeteran wüx nangos nüt pascua. ");
INSERT INTO huvNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Wüx tatüch metiw, quiaj tapeay quiaj Teat Jesús maquiiüb altigüy miapóstoles nej. Quiaj chetetoj. ");
INSERT INTO huvNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Wüx alchetemoj wüx mes, quiaj tasaj nejiw: ―¡Xeyay teanandiüm net naquiiüb icon wüx aaga pascua cam, wǘxan nganaw namongoch xeyay ngo majneaj! ");
INSERT INTO huvNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Cos ningüy ndoj, lango net naquiiüb icon alinomb wüx pascua, leaw apmajlüyiiüts nóiquian niüng apmajlüyiiüts maquiüjpaats Teat Dios ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Condom quiaj taxaing noic vas, tüüch gracias Teat Dios, ndoj tapiüng: ―Jogüy isapan inganeowan noicnoic pite. ");
INSERT INTO huvNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Nganüy sasaj icon, xique landoj langome sananganeow miyow uva naquiiüb icon; apndom wüx apmatüch alinoic nüt niüng apmajlüyiiüts maquiüjpaats Teat Dios ―aw. ");
INSERT INTO huvNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Condom quiaj taxaing a pan, tüüch gracias Teat Dios. Quiaj tambaag müüch nejiw, tapiüng: ―Aag agüy xecuerpo, apmayacüch mandeow mawün isoetiün. Atcüy netam merangan para leaam imeajtsan xic wüx ―aw. ");
INSERT INTO huvNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Atanquiaj tarang wüx landoj üetiw. Taxaing a vas, tapiüng: ―Aag agüy xequiej, ajüiquich wüx jayats poch lamarang Teat Dios müüch icon, cos xequiej apmajünch tiüt mawün isoetiün. ");
INSERT INTO huvNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","’Aaga naxey leaw apmayac xic teowixaw moncüy majaw xic, nganüy teasüet anaag nóiquian wüx mes. ");
INSERT INTO huvNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Naleaing apmarangüch wüx ombas Teat Naxey atnej tanderac tanomb wüx nej. ¡Nganüy aaga naxey leaw apmayac nej teowixaw monajiüt xeyay ngo majneaj apmamongoch! ―aw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Condom minipilan nej atünayej menguiayayej wüx jane tiül nejiw apmayac nej teowixaw monajiüt. ");
INSERT INTO huvNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Condom minipilan Teat Jesús tandeacndeacüw tíülan nejiw, tapiüngüw wüx jane tiül nejiw alwüx atam ajlüy, jane apmarang natang. ");
INSERT INTO huvNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Quiaj Teat Jesús tasaj nejiw: ―Meáwan natangtang monajiüt tiül meáwan iüt arangüw apatüw atnej lamaneayiw meáwan nipilan leaw ajlüyiw wüx. Átan ayambyambüw nguineay manderacüw wüx nejiw majüic najneaj arangüw. ");
INSERT INTO huvNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Icona nde merangan atquiaj. Tiül icona jane natang netam mayaag atnej chingüy. Leaw najmel marang natang tiül icona netam mambeol jangantanej. ");
INSERT INTO huvNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ngwüy, cuane ipiüngan, ¿ngün más netam ajlüye? Sapiüng aaga apchetem mayambüch üet nej; ngome aaga neyac nüeteran wüx mes. Nganüy xique sajlüy naquiiüb icon atnej nop neyac nüeteran wüx mes, atnej nop nerang minajiütan. ");
INSERT INTO huvNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Icona ijlüyiün mequiüjpan xic meáwan nüt wüx samongoch cuajantanej naél. ");
INSERT INTO huvNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Cos atnej Xeteat Dios lamüüch xic narang natang nenajiüt, ata xique sanüüch icon merangan natang nóiquian mequiüjpan xic, ");
INSERT INTO huvNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","para metiiüts manganeowaats nóiquian wüx xemes ninguiün niüng sanarang natang. Átan apchetemeron niüng chetejow montangtang monajiüt, mejawan wüx asoetiw ajcüwa gajpic ajlüy nipilan monaw tiül micual micualüw Israel ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Condom Teat Jesús tasaj a Pedro: ―Simón, Simón inguiay, cos Satanás minatang nimeech teamatün icon, teamandiüm mayac icon tiül naél, atnej ajwüch trigo maw osaab. ");
INSERT INTO huvNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Xique lanatün ocueaj Teat Dios mambeol ic ngo mecueat iyac imeaats wüx nej, atquiaj wüx apmendilil apmembeolüw micojow michijquiaw ―aj. ");
INSERT INTO huvNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Quiaj tasaj nej a Simón: ―Xique teat, sajlüy namb naquiiüb ic nguiajantanej, masey majmeliür tiül manchiüc, masey mambiyaw icor ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Quiaj tasaj nej Teat Jesús: ―Naleaing sasaj ic, Pedro, gallo apmepaj nganüy leaw ndoj mepiüng arojmbüw ipiüng ngo mejaw jane xic ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Condom Teat Jesús tatün manguiay nejiw: ―Jow wüx tüjchiüs icon meamban ngo mejoyiün morral, ngo mejoyiün iquial tomiün, ngo mesoijquiün napüic, ¿tetam icon aleaic leaw nómban ngome tejiürana? ―aj nejiw. Quiaj tapiüngüw: ―Nicuajind, Teat ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Condom quiaj tasaj nejiw: ―Nganüy, leaw ajiür morral ich majoy, at iquial tomiün. Sitiül nop ngo majiür espada, ich manüüb micamix nej mangal nots. ");
INSERT INTO huvNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Cos sasaj icon xique netam marangüch wüx ximbas atnej lasanderac wüx tiül Mipoch Teat Dios, cos apiüng: “Tayacüch atnej nop nerang ngo majneaj”, aw. Meáwan leawa lasanderac wüx quiaj, netam majlüy atnej ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Quiaj tasajüw nej: ―Teat, alningüy ijtsüw espada ―ajüw. Quiaj tasaj nejiw: ―¡Lajlüy, atówan ayaj! ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Condom Teat Jesús taw quiaj maquiiüb minipilan nej, tamb andüy wüx mitiüc Olivos atnej mbójan marang. ");
INSERT INTO huvNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Wüx tapeayiw quiaj, tasaj minipilan nej: ―Itüniün ocueaj Teat Dios, ngana aleaic marang wüx imbasan nimeech ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Condom quiaj tacueat nejiw Teat Jesús, tamb tajüy atow nej atüch niüng alndom majlos noic piedra. Quiaj taquieel tiüt micos nej masaj Teat Dios, ");
INSERT INTO huvNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","tapiüng: ―Teat, ngwüy alndom mamóngan wüx ximbas meáwan naél leaw aliüc miün; ique ijaw Teat, ngome leawa xique sandiüm, cos leaw ique ijaw netam ―aw. ");
INSERT INTO huvNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Condom quiaj tapeay nop ángel imiün tiül cielo mambeol nej, müüch nej apac. ");
INSERT INTO huvNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Cos Teat Jesús xeyay tamix omeaats, ngo macueat matün ocueaj Teat Dios; taw xeyay minalil nej, ancatectec tiüt atnej quiej. ");
INSERT INTO huvNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Wüx ndot mataag orar, quiaj witiüt tamb majaw minipilan nej. Almajngot majaw almameayiw, cos laǘmb apacüw, xeyay amix omeajtsüw. ");
INSERT INTO huvNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Quiaj tasaj nejiw: ―¿Neol tapots imeayiüna? ¡Ipacan, itüniün ocueaj Teat Dios, quiaj ngondom marang nicuajind wüx imbasan nimeech! ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Tenguialeámban andeac Teat Jesús, quiaj ajngot noic ajlüy nipilan, aaga Judas ombas nej; nej nop nej tiül ajcüwa gajpiüp (12) apóstoles. Wüx tajngot, nómban atüch Teat Jesús macheech mimboy nej. ");
INSERT INTO huvNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Condom Teat Jesús tasaj a Judas: ―¿Atquiaj lameteots metiib ndeaam Teat Naxeye, wüx apmecheech mimboy neje? ―aj. ");
INSERT INTO huvNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Minipilan nej wüx tajawüw aag ayaj, quiaj tapiüngüw: ―Teat, ¿natsojon naquiüjpan naag espada? ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Condom nop minipilan Teat Jesús tamb mangoch nop nerang minajiüt natang miteaats, tandooig miác olaag. ");
INSERT INTO huvNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Quiaj Teat Jesús tasaj nej: ―¡Ijlǘyan, icueat, ich majlüy! ―aj. Condom quiaj tarreeg olaag aaga naxey quiaj, tataag majneaj nómban. ");
INSERT INTO huvNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Quiaj tasaj ajcüwa montangtang miteaats, at monlüy wüx nadam nangaj iüm, at montangtang teat xeech monajiüt tiül nejiw, leawa tiünüw masapüw nej: ―¿Cuane imbichan espada maquiiüb a tocots xiül quiaj, tewiünana mesapan xique? ¿Neol, jowa xique need xique? ");
INSERT INTO huvNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Meáwan nüt samb tiül nadam nangaj iüm. ¿Neol ngo mesapan xique? Nganüy cos lamatüch a nüt merangan aag ayaj, at nimeech lamüünd marang atquiaj ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Condom quiaj ndeaad Teat Jesús, taquiüraab mamb andüy aniüng minatang miteaats. Teat Pedro tandüüb nej mamb, miünquiájan ajngot. ");
INSERT INTO huvNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ajcüwa nipilan ajalüw biümb quiaj tiül püjchiün mbeay ombiüm minatang miteaats metsantsayej; alchetemoj ayeyiw tiüt biümb. At a Pedro aton tamb tsotom quiaj maquiüjpüw. ");
INSERT INTO huvNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Alquiaj nop nüx nerang najiüt quiaj, wüx tajaw altsotom mbeay biümb a Pedro, tajaw majneaj, quiaj tapiüng: ―At aaga naxey quiaj aton taquiiüb aaga Jesús ―aw. ");
INSERT INTO huvNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Aaga Pedro ngo mandiüm mapiüng naleaing, quiaj tapiüng: ―Ngwüy müm, ngo najaw jane aag ipiüng quiaj ―aw. ");
INSERT INTO huvNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ajóyan quiripite ores, quiaj tajaw nej alinop, tasaj nej: ―Ique aton nop tiül aquiüjpüw nejiw ―aj nej. Quiaj tapiüng a Pedro: ―Naxey, ngwüy ngome xique ―aw. ");
INSERT INTO huvNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ǘüchan ores tatow ndoj masaj nej aaga nop, quiaj tapiüng alinop: ―Naleaing, aaga naxey quiaj aton aquiiüb nej, cos naw Galilea ―aw. ");
INSERT INTO huvNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Aaga Pedro tandüy wüx mapiüng: ―Naxey, ngo najaw cuane ipiüng quiaj ―aw. Tenguialeámban mandeac aag ayaj a Pedro, quiaj tepaj a gallo. ");
INSERT INTO huvNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Teat Jesús ndiliteay majaw a Pedro. Quiaj leaad omeaats aaga tapiüng Teat Jesús: “Sasaj ic Pedro, aaga gallo apmepaj nganüy leaw ndoj mepiüng arojmbüw ipiüng ngo mejaw jane xic”, maj nej. ");
INSERT INTO huvNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Wüx leaad omeaats aag ayaj a Pedro, taw quiaj, tapots müüch ajiünts. ");
INSERT INTO huvNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ajcüwa monxey monjiür Teat Jesús itsojayéjan nej, tatoliw nej. ");
INSERT INTO huvNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Quiaj taoeliw oniiüg nej, cas tapots maleambüw mitey. Tasajüw: ―¡Isüet jane neleamb ic! ―ajüw. ");
INSERT INTO huvNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","At tasajüw nej cuajantanej ngo majneaj. ");
INSERT INTO huvNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Wüx larraw tiüt, quiaj canchiütoj montangtang monajiüt tiül judíos, montangtang miteaats, átan mondüy wüx aaga poch tüünd Moisés. Taquiüjpüw mamb Teat Jesús andüy niüng alcanchiümoj altegüy montang monajiüt. Quiaj tatüniw nej manguiayiw: ");
INSERT INTO huvNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","―Isaj xicon, ¿cuane ipiüng, ngwüy ique aaga Cristo tapiürang aliüca? ―ajüw nej. Quiaj tasaj nejiw: ―Masey nasaj icon, icona ngome apmeyariün sandeac. ");
INSERT INTO huvNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Aton sitiül aleaic natün nanguiay icon, ngome apmesajan xic, ngome apmetsambijchan xic. ");
INSERT INTO huvNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Naleaing, naw wüx nganüy Teat Naxey apchetem amb wüx miác Teat Dios, aag nerang cuajantanej leaw almajlüy ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Condom yajnguiat tiüt masajüw nej: ―¿Cuane ipiüng, ique micual ic Teat Diosa? ―ajüw nej. Quiaj tasaj nejiw: ―Xique, atnej ipiüngan quiaj ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Condom quiaj tapiüngüw: ―¡Cuane tenguialeámban macüliiüts manguiayiiüts, cos anguiayayoots nguineay andeac! ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Condom quiaj tambüw meáwan nejiw maquiüjpüw mamb Teat Jesús andüy niüng ajlüy a Pilato. ");
INSERT INTO huvNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Wüx tapeayiw quiaj tapots mayacüw asoet, tapiüngüw: ―Aaga naxey cam taxomasan teamaquiaach nipilan nde marangüch leaw netam marangüch. Apiüng ngo metam majwan tomiün müünd a César. Ngome áagan ayaj, aton apiüng nej aaga Cristo leaw lapiürang aliüc, nop minatang nenajiüt ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Quiaj tatün manguiay nej a Pilato: ―¿Naleaingue, ique aaga minatang nenajiüt tiül cambaj Israele? ―aj. Quiaj tasaj nej Teat Jesús: ―Naleaing teat, atnej lamepiüng quiaj ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Condom Pilato quiaj tasaj natangtang miteaats at meáwan nipilan: ―Nicuajind nisoet ngo naxom wüx ombas aaga naxey cam ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Quiaj nejiw tayambyambüw xeyay nguineay mawaijchaw, tapiüngüw: ―Lamüüch majcüy nipilan, lamaquiaach ngo majneaj meáwan tiül Judea, tamelich tiül Galilea, nganüy lapeay ningüy ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Wǘxan tanguiay aag ayaj a Pilato, quiaj tatün manguiay sitiül aaga naxey quiaj naw Galilea. ");
INSERT INTO huvNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Wüx tapiüngüw naleaing, quiaj tüüch mamb andüy niüng ajlüy a Herodes, cos nej natang nenajiüt tiül Galilea. Aton aaga nüt quiaj Herodes ajlüy tiül Jerusalén. ");
INSERT INTO huvNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Condom Herodes wüx tajaw Teat Jesús, quiaj tapac omeaats xeyay, cos lamajiür nüt tenguial mandiüm majaw. Xeyay lamanguiay anderac wüx Teat Jesús nguineay arang. Nej aton tenguial mandiüm majaw marang noic ateócan. ");
INSERT INTO huvNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ndoj quiaj tapots müüch matüntün manguiay; pero Teat Jesús ngo mendeac nómban. ");
INSERT INTO huvNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ajcüwa montangtang miteaats, at mondüy wüx aaga poch leaw nomb tarang a Moisés, aliw quiaj aton; tatepichaw asoet nej xeyay. ");
INSERT INTO huvNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Aaga Herodes maquiiüb misoldados nej atsojayéjan majawüw Teat Jesús. Tasoijquiw nej tiül noic najneajay napixeran majüic atnej nop minatang nenajiüt. Aag ayaj itsojow nej. Condom tüüch nej mamb alinomb andüy niüng ajlüy a Pilato. ");
INSERT INTO huvNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ninguinüt nej a Pilato najcüy aweaag a Herodes; nganüy wüx aaga nüt quiaj nómban ajneajiw. ");
INSERT INTO huvNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Condom Pilato tapaj canchiümoj meáwan micual cambaj, at montangtang miteaats maquiiüb monajiüt. ");
INSERT INTO huvNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Quiaj tasaj nejiw: ―Icona tequiüjpan miün aaga naxey cam. Tepiüngan nej teamaquiaach nipilan wüx ngo majneaj. Nganüy lamenguiayiün laímb natüntün nanguiay, ngo naxom wüx ombas nej nicuajind nisoet leaw ipiüngan. ");
INSERT INTO huvNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Átan a Herodes aton ngo maxom nicuajind, áag tüüch mandilil alinomb. Nganüy lamejawan ngo majiür nicuajind nisoet aaga naxey cam mandeow wüx. ");
INSERT INTO huvNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Leaw sanarang wüx nganüy, sanüüch majwüch, condom sanatsambiich ―aj nejiw a Pilato. ");
INSERT INTO huvNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Tapiüng aag ayaj Pilato cos alndom tsajmbiüm nop najlüy tiül manchiüc wüx nangos nüt, leawa cambaj atün. ");
INSERT INTO huvNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Quiaj nipilan anyajnguian tiüt apajüw, tapiüngüw: ―¡Ngwüy nde metsambiich aag ayaj! ¡Itsambiich a Barrabás! ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Aaga Barrabás quiaj, tajmel tiül manchiüc cos tasojnong nipilan majcüyiw majawüw monajiüt; aton nej nop nembiy nipilan. ");
INSERT INTO huvNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Quiaj Pilato tandüy wüx masaj nejiw alinomb, cos xeyay tandiüm matsambiich Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Quiaj a nganüy nipilan tepajüw xeyay napac, tapiüngüw: ―¡Ich mandeow wüx cruz, ich mandeow wüx cruz! ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilato quiaj tasaj nejiw amb arojmbüw: ―Xique ngo naxom cuane ngo majneaj arang aaga naxey cam. Ngo naxom wüx ombas nej nicuajind nisoet mandeow wüx. Sǘpan nüüch majwüch, ndoj sanatsambiich ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Nejiw tepajüw napac, tapiüngüw majmel wüx cruz. Ajcan laxeyay ayajyajiw a nipilan maquiüjpüw montangtang miteaats, quiaj tajlüy atnej andiümüw. ");
INSERT INTO huvNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Quiaj Pilato tapiüng apmarang leawa nejiw apiüngüw. ");
INSERT INTO huvNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Condom quiaj tatsambiich aaga naxey nembiy nipilan leaw tatüniw tsajmbiüm, áag leaw tajlüy tiül manchiüc cos tasojnong nipilan majcüyiw majawüw monajiüt. Ndoj tayac teowixaw nejiw a Teat Jesús marangüw wüx leaw andiümüw. ");
INSERT INTO huvNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Condom quiaj taquiüjpüw mamb Teat Jesús mayacüw wüx cruz. Tenguiálan ajüyiw, quiaj mangochiw nop naxey nenüt Simón, naw tiül cambaj Cirene, les tajngot imiün tiül corrül. Quiaj tüjchiw mambitic a cruz, mandüüb mamb Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Tandüjpiw nej mamb xeyay nipilan. Altiül xeyay montaj teajiüntsüw teapajüw cos xeyay amix omeajtsüw. ");
INSERT INTO huvNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Quiaj Teat Jesús wantsat majaw nejiw, tapiüng: ―Müm montaj monaw Jerusalén, nde mejiüntsan wüx ximbas, ijiüntsan wǘxan icona, at wüx micualan. ");
INSERT INTO huvNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Cos aliüc miün nüt apmapiürang: “Najneajay ajlüy leaw ngondom majiür micual nej, at leaw ngo majiür nine tenguial achech.” ");
INSERT INTO huvNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Aaga nüt quiaj nipilan apmasajüw a tiüc: “Ijmiüc wüx ximbasan, ixot xicon”, apmajüw a lom. ");
INSERT INTO huvNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Cos sitiül alndom marangüw aag agüy wüx nüt aliün majlüy nateaic xiül, ¿cuane apmarangüw wüx nawaag nüt? ―aw. ");
INSERT INTO huvNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Wüx taquiüjpüw mamb Teat Jesús, aquiüjpüw mamb ijpüw monxey leaw xeyay ngo majneaj tarangüw; apmayacaranüw wüx cruz nóiquian maquiiüb. ");
INSERT INTO huvNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Condom tapeayiw wüx Calvario, nasoic Omal Mondeow, quiaj tayacüw wüx cruz Teat Jesús maquiiüb ajcüw ijpüw monrang xeyay ngo majneaj quiaj. Nop tayacüw amb wüx miác nej, alinop amb wüx miquiamb nej. ");
INSERT INTO huvNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Quiaj Teat Jesús tapiüng: ―Teat Dios, nde meyac wüx imeaats aaga ngo majneaj teamarangüw cam, cos ngo majawüw cuane teamarangüw ―aw. Condom ajcüwa soldados tasuetiw wüx apix nej, membaagayej wüx. ");
INSERT INTO huvNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Meáwan nipilan aliw quiaj teamajawüw. Monajiüt aton titsojow nej, tapiüngüw: ―Alinop mbich awün wüx; nganüy ich mewüneay wüx nejáyan quiaj, majüic sitiül naleaing nej aaga Cristo lapiürang aliüc ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Átan ajcüwa soldados aton titsojow nej, tatüchiw nej müjchiw nachich vin. ");
INSERT INTO huvNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Tasajüw: ―Sitiül ique minatang nenajiüt tiül judíos, nganüy erwüneay wüx iquiáyan quiaj ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Tarangüch acas poch wüx omal cruz. Aag ayaj tarangüch wüx ombeayiw griego, wüx ombeay latín, at wüx ombeay hebreo. Apiüng: “Aag agüy minatang nenajiüt ocueajiw judíos.” ");
INSERT INTO huvNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Camüm nop tiül nejiw ajcüwa monrang xeyay ngo majneaj najlüyiw wüx cruz, itsojǘyan Teat Jesús, tasaj: ―Sitiül ique aaga Cristo lapiürang aliüc, ¿neol nganüy ngo merwüneay wüx iquiáyan quiaj, mewün xicon aton? ―aj. ");
INSERT INTO huvNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Pero aag aquiiüb nej talic nej, tasaj: ―¿Ngo mermbol mendüy Teat Diosa? Cos icora aton ajlüyiür tiül aaga naél cam. ");
INSERT INTO huvNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Icora naleaing netam mamongochiür atcüy, cos tarangar xeyay ngo majneaj. Nganüy aaga teat naxey cam ngo marang nicuajind ngo majneaj ―aj. ");
INSERT INTO huvNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Condom aaga naxey tasaj Teat Jesús: ―Teat Jesús, ich leaam imeaats xic wüx apmejlüy niüng irang natang nenajiüt ―aj. ");
INSERT INTO huvNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Quiaj tasaj nej Teat Jesús: ―Naleaing sasaj ic xecual, nganüy apmajlüyiür tiül noic najneajay cambaj nasoic paraíso ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Wüx lamatüch limnüt, quiaj pojniüt nómban meáwan wüx iüt. Tiün ram lapeay tiül pinawan nchejliow nüt. ");
INSERT INTO huvNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Nüt nómban ngo merraj, at aaga tarrang jael nepal teomeaats nadam nangaj iüm nómban chiütaw pinawan. ");
INSERT INTO huvNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Condom Teat Jesús tepaj napac, tapiüng: ―Teat, sayac tiül iwix xeespíritu ―aw. Wüx landoj mapiüng aag ayaj, quiaj tandeow. ");
INSERT INTO huvNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Condom aaga natang tiül soldados, wüx tajaw meáwan leawa tajlüy quiaj, tandeac najneaj wüx Teat Dios, tapiüng: ―Naleaing, aaga naxey quiaj ngo majiür nicuajind nisoet ―aw. ");
INSERT INTO huvNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ajcüwa nipilan leaw tajlüyiw quiaj, wüx tajawüw meáwan nguineay tajlüy, tandilileaw atoltoliw mal miiündüw nejiw; xeyay ngo majneaj mayajcüw. ");
INSERT INTO huvNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Nganüy meáwan leaw xowüy andeacüw maquiüjpüw Teat Jesús aliw quiaj, átan montaj leawa tiünüw imiünüw Galilea mandüjpiw nej. Naleaing miünquiájan almajlüyiw, teamajawüw nguineay teajlüy. ");
INSERT INTO huvNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Tajlüy nop naxey nenüt José, naw tiül cambaj Arimatea tiül iüt Judea, xowüy ajneaj omeaats, arang najneaj. Nej nop tiül natang monajiüt tiül judíos. ");
INSERT INTO huvNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Aaga José quiaj teamacül majlüy tiül micambaj Teat Dios. Nej ngo majneaj majaw meáwan leawa ngo majneaj lamarangüw montangtang monajiüt. ");
INSERT INTO huvNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Tamb majaw a Pilato matün Teat Jesús mamiüt. ");
INSERT INTO huvNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Wüx landoj mawün wüx cruz Teat Jesús, quiaj tawinch tiül noic napixeran. Condom tamb mayac tiül noic oxiüt larangüch noic warraj tüeng tiüc. Tiül aaga oxiüt quiaj nganaw mamelichaw tiül nicuajind mondeow. ");
INSERT INTO huvNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Tiül aaga nüt quiaj tenguial ayambüch leaw apmetam wüx nangos nüt, aton laliüc majmel nüt, quiaj amelich a nüt axoodaran. ");
INSERT INTO huvNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ajcüwa montaj mondüüb miün Teat Jesús imiünüw Galilea, tambüw majawüw oxiüt. Tajawüw nguineay tapiiberan tiül a Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Condom tawüw quiaj, tambüw mayambüw najmboc angan soex, at najmboc angan aceite. Condom taxojtüw wüx nüt axoodaran atnej apiüng tiül aaga poch leawa Teat Dios tüüch a Moisés tanomb. ");
INSERT INTO huvNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ǘmban arraw domingo wüx amelich seman, ajcüwa montaj tambüw niüng ajlüy oxiüt; ajoyiw mamb najmboc angan soex leawa landoj lamayambüw. At aquiüjpüw mamb alacas montaj aton. ");
INSERT INTO huvNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Camüm mapeayiw, quiaj tajawüw aaga piedra napalaran wüx oxiüt lango majlüy niüng tayacüch. ");
INSERT INTO huvNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Quiaj tajmeliw majawüw. Teat Jesús ngo majlüy quiaj niüng tapiiberan. ");
INSERT INTO huvNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Nejiw nómban mbayajow, ngo majawüw cuane apmarangüw. Quiaj majawüw ijpüw monxey alembemoj niüng ajlüyiw nejiw, xowüy lalitlit apixaw nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Quiaj mbayatoj xeyay, taxequiw tiüt omalüw. Condom ajcüwa monxey tasajüw nejiw: ―¿Neol, cuane temeyamban ningüy niüng amiüraad mondeow? cos aaga Teat Naxey almapac. ");
INSERT INTO huvNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Nej ngo majlüy ningüy cos lapac alinomb. Ich leaam imeajtsan leaw tasaj icon wüx altiül Galilea. ");
INSERT INTO huvNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Cos tapiüng, aaga Teat Naxey apmajmel teowixaw nipilan monrang ngo majneaj, apmambiyaw nej wüx cruz. Condom wüx er nüt apmapac alinomb, aw ―ajüw nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Nejiw quiaj leaad omeajtsüw wüx aaga poch tasaj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Wüx tandilileaw imiünüw niüng ajlüy oxiüt, quiaj tambüw masajüw ajcüwa gajpanop (11) miapóstoles Teat Jesús, maquiiüb alacas leaw andüüb nej. ");
INSERT INTO huvNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ajcüwa monamb monsaj miapóstoles Teat Jesús, ajcüw ayaj nop María Magdalena, alinop Juana, alinop María mimüm Jacobo, at alacas montaj. ");
INSERT INTO huvNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Nejiw apóstoles tapiüngüw atnej nechachiw montaj tandeacüw a poch quiaj; ngome tapiüngüw aag ayaj naleaing. ");
INSERT INTO huvNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Condom teat Pedro witiüt tamb acuiür andüy niüng ajlüy oxiüt. Almapeay quiaj talech onic majaw tiül oxiüt, tajaw ngo majlüy nicuajind, áagan apix Teat Jesús nawincharan tiül alquiaj. Quiaj a nganüy tandilil mbayánan, ngo majaw cuane najlüy. ");
INSERT INTO huvNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Aaga nüt quiaj ijpüw minipilan Teat Jesús aleambüw tiül tiiüd, laambüw andüyiw tiül noic cambaj nenüt Emaús. Ajiür coen gajpanoic (11) kilómetros naw Jerusalén. ");
INSERT INTO huvNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ajcüwa nipilan quiaj tenguial mandeacüw wüx meáwan leawa tajlüy. ");
INSERT INTO huvNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Nejiw tenguial mandeacüw wüx aag ayaj, quiaj tatüch nejiw Teat Jesús, tajüyiw nóiquian maquiüjpüw. ");
INSERT INTO huvNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Naleaing atnej aleaic nexot nej oniüjcüw, ngo majawüw jane. ");
INSERT INTO huvNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Condom quiaj tatün manguiay nejiw Teat Jesús: ―¿Cuane wüx temendeacan tenguial ijüyiün tiül tiiüda? ¿Neol xeyay amix imeajtsana? ―aw. ");
INSERT INTO huvNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Quiaj tasaj nej nop nenüt Cleofas, tapiüng: ―¿Neol ngwüy, íquian quiaj iltiül Jerusalén aaga nüt cam, pero ngo mejaw cuane tajlüy quiaja? ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Quiaj tasaj nejiw: ―¿Neol, cuane najlüy quiaja? ―aj nejiw. Quiaj tasajüw nej: ―¿Ngo menguiay leaw tajlüy wüx Teat Jesús naw Nazarete? Nej nop nendeac andeac Teat Dios, cuajantanej alndom marang, aton najneajay andeac wüx Teat Dios manguiay nipilan. ");
INSERT INTO huvNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Naleaing montangtang miteaats, aton monajiüt tiül xecambajan tayacüw nej teowixaw nipilan mayacüw wüx cruz, mandeow. ");
INSERT INTO huvNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Xicona tapiüngasan nej apmawün xicon wüx aaga naél leawa meáwan nipilan judío teanamongochiün. Nganüy lamatüch er nüt tatow ndoj marangüw atquiaj. ");
INSERT INTO huvNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Nganüy acas montaj tiül xicona teamambolojchiw xicon; cos wüx tambüw majawüw oxiüt ǘmban arraw, ");
INSERT INTO huvNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","quiaj tajawüw lango majlüy quiaj Teat Jesús niüng tapiiberan. Ndoj tandilileaw masajüw xicon aag ayaj. Aton apiüngüw tajawüw ijpüw ángeles, tasajüw nejiw aaga Teat Jesús lapac. ");
INSERT INTO huvNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Condom quiaj tambüw acas saquiüjpan majawüw oxiüt. Tajawüw naleaing atnej tapiüngüw ajcüwa montaj, cos ngo majlüy quiaj Teat Jesús ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Quiaj tasaj nejiw Teat Jesús: ―¡Nguitow apac imalan! ¡Ngow apmepiüngan naleaing meáwan leawa tapiüngüw mondeac andeac Teat Dios! ");
INSERT INTO huvNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Neol cuane ipiüngan, ngo metam mamongoch atquiaj aaga Cristo leaw lapiürang aliüca, wüx nganaw mamb andüy tiül cielo? ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Condom tapots müüch masaj nejiw wüx meáwan leaw apiüng tiül Mipoch Teat Dios, ajan wüx aaga poch leawa tüünd a Moisés, tandüüb meáwan leaw tandeacüw wüx nej mondeac andeac Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Condom wüx lapeayiw tiül a cambaj niüng andüyiw quiaj, quiaj Teat Jesús tajüic atnej apmamóngan. ");
INSERT INTO huvNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Pero xeyay tasajsajüw: ―Icül teat, macüliiüts, langwiiüts agüy, laliüc majmel nüt ―ajüw. Quiaj tacül Teat Jesús maquiiüb nejiw, taquiüjpüw andüy niüng acüliw. ");
INSERT INTO huvNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Condom wüx alchetemoj maquiüjpüw nóiquian wüx mes, quiaj Teat Jesús taxaing a pan, condom tataag orar, ndoj tambaag müüch nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Quiaj rat oniüjcüw, leaad omeajtsüw majawüw jane nej. Naleaing Teat Jesús quiaj ndrot, lango maxomüw majawüw. ");
INSERT INTO huvNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Condom quiaj tendeacndeacüw, tapiüngüw: ―¿Naleaing ngwüy, áag tapots apac omeajtsar wüx aleambaats tiül tiiüd, wüx teamasaj icor wüx Mipoch Teat Dios? ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Condom aag ayaj, andilileawan tiüt, tandüyiw Jerusalén alinomb. Taxomüw ajcüwa gajpanop (11) miapóstoles Teat Jesús, at meáwan minipilan nej alcanchiümoj maquiüjpüw nóiquian. ");
INSERT INTO huvNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Andǘüban masoiquiw: ―Naleaing Teat Jesús lapac tiül mondeow, cos landoj axomayej maquiiüb teat Simón ―ajüw nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Condom ajcüwa ijpüw quiaj tapiüngüw aton nguineay tandeacüw maquiüjpüw Teat Jesús wüx aliw tiül tiiüd, at cos naleaing tajawüw ranüy wüx tambaag a pan. ");
INSERT INTO huvNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Tealeámban mandeacüw aag ayaj, quiaj majawüw Teat Jesús alembem pinawan niüng ajlüyiw nejiw. Tatepeay nejiw, tapiüng: ―Tamtámban ijlüyiüna ―aw. ");
INSERT INTO huvNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Nejiw mbayatoj xeyay, apiüngüw nejiw nembolooch. ");
INSERT INTO huvNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Quiaj tasaj nejiw Teat Jesús: ―¿Neol mbayaterona? ¿Neol teteotsan atquiaja? ");
INSERT INTO huvNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Jogüy ijawan xiwix, xileaj. Xique tan sajlüy. Isamban xic mejawan, cos noic espíritu ngo majiür onij olaats matnej nganüy teamejawan sajlüy cam ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Wüx tasaj nejiw aag ayaj, quiaj tüüch nejiw majawüw owix nej oleaj nej. ");
INSERT INTO huvNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Nejiw ngo majawüw cuane marangüw, mbayajówan, pero apac omeajtsüw majawüw nej. Quiaj tasaj nejiw Teat Jesús: ―¿Ijiüran ningüy nüeterana? ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Quiaj tüjchiw nej quiriw nechench cüet, alquiriw micün xiül. ");
INSERT INTO huvNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Tasap, tüet quiájan niüng ajlüyiw nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Condom tasaj nejiw: ―Aaga leaw teajlüy cam tasajas icon ninguinüt wüx saliün naquiiüb icon. Tapiüngas netam majlüy atnej lasanderac wüx tiül aaga poch leawa tüünd a Moisés nomb, at leaw tapiüngüw mondeac andeac Teat Dios, at tiül salmos aton ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Quiaj tüüch nejiw majawüw ranüy nguineay lamapiüng wüx nej tiül Mipoch Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Tasaj nejiw: ―Atquiaj lajlüy larangüch wüx nawiig, cos aaga Cristo leaw lapiürang aliüc netam mambiyeran. Condom wüx er nüt apmapac alinomb naw tiül mondeow. ");
INSERT INTO huvNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Netam manderac wüx nej manguiayiw meáwan cambaj wüx aaga iüt cam, masoiquiw netam mayambüw Teat Dios, matüniw ocueaj, para mawüw wüx asoetiw. Netam memelichan mendeacan wüx nej naw tiül Jerusalén andüy quiaj. ");
INSERT INTO huvNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Nganüy icona netam mejlüyiün wüx, mepiüngan meáwan aag ayaj cos ijawan naleaing. ");
INSERT INTO huvNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Xique sanüüch miün leawa lamapiüng Xeteat Dios apmüüch icon. Icülíünan ningüy tiül cambaj Jerusalén leaw ndoj meajndiün aag ayaj imiün tiül cielo. Nej apmüüch icon merangan cuajantanej ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Condom quiaj tawüw tiül cambaj, taquiiüb nejiw mamb andüy Betania. Quiaj tandic cawüx owix nej, tatün monajneaj müüch nejiw Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Tenguialeámban atün monajneaj, quiaj tacueat nejiw, tanaámb amb andüy cawüx tiül cielo. ");
INSERT INTO huvNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Minipilan nej wüx landoj maquiejliw micosüw nejiw mandeacüw najneajay wüx Teat Jesús, quiaj tandilileaw andüyiw Jerusalén, najneajay apac omeajtsüw. ");
INSERT INTO huvNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Tanaámb ngo macueatiw ambüw tiül nadam nangaj iüm mandeacüw najneajay arang Teat Dios.");
INSERT INTO huvNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Tanomb wüx nganaw majlüy iüt, nganaw majlüy nicuajind, pero aaga Nanderac quiaj almajlüy. Aaga Nanderac quiaj almajlüy maquiiüb Teat Dios; nej Dios nej. ");
INSERT INTO huvNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Nej ajlüy nóiquian maquiiüb Teat Dios nde ajlüy. ");
INSERT INTO huvNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Meáwan leaw almajlüy, tajlüy arang nej. Nicuajind ngondom majlüy leawa almajlüy nganüy, sitiül nej ngo marang. ");
INSERT INTO huvNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Nej üüch mapac meáwan cuajantanej leaw almajlüy. Aaga neech mapacaran quiaj, arraj nipilan atnej ran arraj cuajantanej. ");
INSERT INTO huvNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Aaga ran quiaj arraj tiül pojniün; pojniün ngondom mapeniich aaga ran quiaj. ");
INSERT INTO huvNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Tajlüy nop naxey nenüt Juan, aaga neech yow nipilan; nej tiün üüch nej miün Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Aaga naxey quiaj tiün mandeac wüx aaga almajlüy atnej ran quiaj, para mayariw andeac nej meáwan nipilan. ");
INSERT INTO huvNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Juan ngome nej aaga ran quiaj. Nej tiün majüiquich cuane amb apiüng aaga ran quiaj, jane wüx andeac. ");
INSERT INTO huvNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Nej aaga ran quiaj naleaing, tenguial marraj meáwan nipilan; nej tiün wüx aaga iüt cam. ");
INSERT INTO huvNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Aaga ran quiaj tajlüy wüx iüt cam, pero nipilan ngo majawüw jane nej masey nej tarang meáwan leaw almajlüy. ");
INSERT INTO huvNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Nej tiün tiül micambaj nej; pero micambaj nej ngo mandiümüw nej. ");
INSERT INTO huvNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Nganüy meáwan monyar andeac nej, ajcüw ayaj tüjndiw majlüyiw micual nejiw Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Cos ngome wijquiatoj awiquiach nejiw nipilan, átan ngome aljane tandiüm majaw wijquiamoj. Aton ngome nop naxey tandiüm majiür micual nej. Ngwüy, nejiw micual nejiw Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Aaga Nanderac quiaj tiün wijquiam marang nipilan atnej icoots; at tacül ningüy maquiüjpaats. Tajawaats nej tarang xeyay cuajantanej najneaj. Nej arang leaw naleaing, cos naleaing nej anopǘyan micual Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Juan tiün mandeac wüx nej, tapiüng: ―Tandeacas wüx aaga Teat Naxey cam wüx tapiüngas aliüc miün nop natang, xeyay netam ajlüy, ngo mat xic; cos wüx nganaw najlüy, nej almajlüy ―aw. ");
INSERT INTO huvNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Xeyay ajüiquich mimonajneaj nej tiül meáwan icoots, cos nej üüch icoots meáwan leaw netam, ǘüchan. ");
INSERT INTO huvNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Aaga ajlüyay poch tüünd teat Moisés tajlüy, para ndom majawaats nguineay netam marangaats. Nganüy aaga jayats poch Teat Jesucristo tüüch icoots para alndom majawaats cuane naleaing, at para mayariiüts mimonajneaj nej. ");
INSERT INTO huvNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Naleaing nejinguind ngo maxom majaw nejay Teat Dios. Áagan anopǘyan micual nej lamajaw cos almaquiiüb, nej ajüiquichay majaw nguineay ajlüy. ");
INSERT INTO huvNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Atcüy tapiüng a Juan wüx ajcüwa monajiüt ocueaj nipilan judío tiül Jerusalén tüjchiw mamb acas miteaats ata levitas, matüniw manguiayiw wüx aaga teamandeac quiaj. Tasajüw: ―¿Jowa ique jan ic? ―ajüw. ");
INSERT INTO huvNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Nej ngo mawaiich, aleáingan tapiüng: ―Xique ngome aaga Cristo lapiürang aliüc ―aw. ");
INSERT INTO huvNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Tandüyiw wüx matüniw nej manguiayiw: ―¿Jane ic? ¿Ngwüy ique Elíasa? ―awüw. Juan tandüy wüx mapiüng: ―Ngwüy, ngome xique ―aw. Condom tandüyiw wüx masajüw nej: ―¿Ngwüy ique alinop nendeac andeac Teat Diosa? ―ajüw nej. ―Ngwüy ―aw. ");
INSERT INTO huvNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Condom tasajüw nej alinomb: ―Ngwüy naleaing sapiüngan, ipiüng jane ic, isaj xicon. Cos netam napiüngan wüx sanapeayiün niüng ajlüyiw moneech xicon niünan. Ipiüng jan ic ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Quiaj tasaj nejiw a Juan: ―Xique aaga nendeac tiül wajchiüc atnej tapiüng Isaías wüx tapiüng: “Ileainguijchan mitiiüd Teat Naxey cos aliüc” ―aw. ");
INSERT INTO huvNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ajcüwa nasoiquiw mambüw majawüw a Juan quiaj, üüch nejiw mambüw fariseos. ");
INSERT INTO huvNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Condom tasajüw a Juan: ―Sitiül ngome ique a Cristo, at ngome aaga Elías, at ngome alinop nendeac andeac Teat Dios, ¿neol tapots meaach yow nipilan? ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Quiaj tasaj nejiw a Juan: ―Naleaing ipiüngan xique süüch yow. Nganüy almajlüy nop tíülan nipilan, icona ngo mejawan jane nej. ");
INSERT INTO huvNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Xique tapiüngas aliüc miün nop natang netam ajlüy, ngo mat xic, cos wüx nganaw najlüy, nej lajlüy. Sayaag ngondom nacheed aonts apaj nej, cos sayaag nicuajind xic ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Atquiaj tajlüy tiül cambaj Betábara nonüt necamb lam Jordán niüng tenguial üüch yow nipilan a Juan. ");
INSERT INTO huvNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Aw alinoic nüt, Juan tajaw Teat Jesús aliüc andüy niüng ajlüy nej. Quiaj tapiüng: ―Ijawan aaga naxey aliüc quiaj. Aag ayaj Teat Dios neech nej miün. Apmarangüch wüx nej atnej arangüch wüx quicheech sap nambiyaran wüx pascua, cos nej apmangüy asoet nipilan. ");
INSERT INTO huvNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Aag ayaj lanapiüng wüx, cos tapiüngas: “Aliüc miün nop teat naxey xeyay netam ajlüy, ngo mat xic. Nej ombas majlüy, xique teoj; cos wüx nganaw najlüy, nej almajlüy”, saw. ");
INSERT INTO huvNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Xique ngo najaw jane nej, nguineay apmajawüw nipilan judío. Áag tiünas nüjchiw mayariw yow ―aw. ");
INSERT INTO huvNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","At tapiüng a Juan: ―Xiquiay sajaw Nangaj Espíritu ocueaj Teat Dios tiün imiün cielo atnej noic palom mejquiem wüx ombas nej. ");
INSERT INTO huvNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Xique nganaw najaw jane nej. Pero cos aaga nesaj xic niün nüüch yow nipilan lamasaj xic: “Wüx apmejaw Nangaj Espíritu miün andüy wüx ombas nop teat naxey macül wüx nej, aag ayaj apmüüch nipilan Nangaj Espíritu ocueaj Teat Dios.” ");
INSERT INTO huvNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Naleaing, nganüy lanajaw Micual Teat Dios nej, cos xiquiay tajawas atquiaj tajlüy ―aw a Juan. ");
INSERT INTO huvNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Aw alinoic nüt Juan alembem quiaj almaquiiüb ijpüw minipilan nej. ");
INSERT INTO huvNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Quiaj majaw aleamb quiaj Teat Jesús, tapiüng: ―Ijawan, jogüy lapeay aaga nasoic Misap Teat Dios ―aw. ");
INSERT INTO huvNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ajcüwa ijpüw minipilan Juan wüx tanguiayiw aag ayaj, quiaj tambüw mandüjpiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Teat Jesús wantsat majaw almandüjpiw nej, tasaj nejiw: ―¿Cuane iyamban, teat? ―aj nejiw. Quiaj tapiüngüw: ―Rabí (amb apiüng nequiaach), ¿nguiane icül? ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Tasaj nejiw Teat Jesús: ―Tabaatsaron mejawan ―aj nejiw. Quiaj tambüw majawüw nguiane acül. Condom tacülíwan quiaj maquiüjpüw, cos langwiiüts. ");
INSERT INTO huvNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Nop tiül aaga ijpüw quiaj leaw tanguiayiw andeac teat Juan, condom tandüjpiw Teat Jesús, aag ayaj teat Andrés, michiig teat Simón Pedro. ");
INSERT INTO huvNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Condom aaga Andrés quiaj tsajmbiüt mayamb Simón micoj nej, tasaj: ―Lanaxoman aaga Mesías nasoic a Cristo, aag lapiürang aliüc ―aj. ");
INSERT INTO huvNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Condom teat Andrés taquiiüb mamb teat Simón majaw Teat Jesús. Wüx Teat Jesús tajaw a Simón, quiaj tasaj: ―Ique Simón micual teat Jonás, nde nganüy apmenüt Cefas, aag ayaj nasoic Pedro ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Aw alinoic nüt Teat Jesús tind amb andüy tiül iüt Galilea, quiaj taxom Felipe, tasaj: ―Mac, tabar ―aj. ");
INSERT INTO huvNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Aaga Felipe quiaj naw Betsaida tiül micambajüw Andrés y Pedro. ");
INSERT INTO huvNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Condom aaga Felipe tamb mayamb Natanael. Wüx taxom tasaj: ―Lanaxoman aaga teat naxey leaw tanomb lamandeac wüx nej tiül aaga nawiig tarang Moisés. At ajcüwa mondeac andeac Teat Dios tandeacüw wüx nej. Aag ayaj nenüt Jesús, micual José, naw cambaj Nazaret ―aj. ");
INSERT INTO huvNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Quiaj tapiüng Natanael: ―Jow aaga cambaj Nazaret quiaj, ¿mbich cuane najneaj alndom maw quiaja? ―aw. Quiaj tapiüng a Felipe: ―Tabar mejaw ―aw. ");
INSERT INTO huvNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Wüx Teat Jesús tajaw ajngot a Natanael, quiaj tapiüng: ―Jogüy aliüc nop nipilan judío leaw ngome áag awaiich ―aw. ");
INSERT INTO huvNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Quiaj tasaj nej Natanael: ―¿Neol teat, nguiane meyaag ximbas? ―aj. Quiaj tasaj nej Teat Jesús: ―Xique tajawas ic wüx nganaw mapaj ic Felipe, wüx alchetemear teowil toc ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Condom quiaj tasaj nej Natanael: ―Rabí, ique aaga Micual Teat Dios, ique minatang nenajiüt tiül nipilan judío ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Quiaj tasaj nej Teat Jesús: ―¿Neol, aag sasaj ic tajawas ic teowil toc teyar sandeaca? Naleaing apmejaw aliüc miün apmajlüy xeyay najneajneaj, ngome áagan ayaj ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","At tasaj nejiw Teat Jesús: ―Naleaing naleaing sasaj icon, nde nganüy andüy quiaj apmejawan lejquiaw nangaj cielo, apmejawan ajcüwa ángeles ocueaj Teat Dios iünüw at andilileaw niüng ajlüy Teat Naxey ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Wüx er nüt tajlüy nop nengoch owix tiül cambaj Caná tiül iüt Galilea. Alquiaj mimüm Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Teat Jesús maquiiüb minipilan nej tasoiquiw mambüw quiaj aton. ");
INSERT INTO huvNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Camüm wüx tümb a vin, quiaj tasaj nej mimüm nej Teat Jesús: ―Lango majlüy vin manganeowaran ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Quiaj Teat Jesús tapiüng: ―Müm, ¿neol tesaj xic atquiaja? Cos xique nganaw matüch a nüt narang cuajantanej ―aw. ");
INSERT INTO huvNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Quiaj tasoiquiw monbeol, asaj nejiw mimüm Teat Jesús: ―Irangan leaw apmasaj icon ―aj. ");
INSERT INTO huvNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ajlüy quiaj anaíw xor iquial yow narangüch piedra. Ajcüw ayaj atam nejiw a nipilan judío wüx arangüw leawa lambójan marangüw para majlüyiw nerixix alinomb teombas Teat Dios. Ajcüwa xor quiaj ajoy ojpeacüw tengwüy gajpowüw ngan yow. ");
INSERT INTO huvNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Condom Teat Jesús tasaj monbeol: ―Ichipichan yow a xor quiaj ―aj nejiw. Quiaj tachipichaw. ");
INSERT INTO huvNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ndoj tasaj nejiw Teat Jesús: ―Nganüy itembiün noic pite, ijoyiün mamb, ijchan aaga najlüy wüx nengoch owix ―aj nejiw. Condom atquiaj tarangüw. ");
INSERT INTO huvNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Wüx ndoj manganeow aaga yow narangüch marang vin, aaga najlüy wüx nengoch owix quiaj, nej ngo majaw nguia naw. Pero ajcüwa monbeol lamajawüw cos nejiw monpiow yow. Condom aaga najlüy wüx nengoch owix quiaj, tapaj aaga nench, ");
INSERT INTO huvNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","tasaj: ―Meáwan nipilan ombas mayacüw najneajay vin. Wüx laxeyay anganeowaran, quiaj apmayacüw ngo majneajay vin. Nganüy a ique tepal aaga najneajay vin, ndójwüx tewün ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ninguiaj amelich arang ateócan Teat Jesús tiül aaga cambaj Caná tiül Galilea. Tüüch majaraw nguineay nej alndom marang cuajantanej. Quiaj minipilan nej tayariw nej andeac. ");
INSERT INTO huvNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Wüx ndoj ayaj, quiaj Teat Jesús tamb andüy tiül cambaj Capernaum, taquiiüb mimüm nej, michiig nej, minipilan nej. Tacüliw quiaj acas nüt. ");
INSERT INTO huvNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Laliüc matüch a nüt majlüy aaga nangos nüt pascua ocueajiw nipilan judío. Quiaj tamb Teat Jesús andüy tiül cambaj Jerusalén. ");
INSERT INTO huvNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Wüx tajmel tiül nadam nangaj iüm, taxom quiaj monüüb boy, monüüb sap, monüüb palom, at mongowüüch tomiün altsotomoj quiaj. ");
INSERT INTO huvNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Wüx tajaw aag ayaj, quiaj tarang nots newüjchay para mewüjchay. Condom tawün meáwan tiül nadam nangaj iüm maquiüjpüw misapüw nejiw, at miboyiw nejiw. Tawiich ninguiün mitomiünüw mongowüüch tomiün; tatech ninguiün mimesüw nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Tasaj monüüb palom: ―¡Iwüniün ningüy aag ayaj! Nde merangan ombiüm Xeteat marang plas ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Minipilan nej quiaj leaad omeajtsüw naleaing tarangüch tanomb niüng apiüng: “Xeyay sanajcüy, cos ngo mind najaw marangüw ngo majneaj tiül ombiüm Xeteat”, aw. ");
INSERT INTO huvNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Condom ajcüwa nipilan judío tatüniw manguiayiw nej: ―¿Neol terang atquiaja, cuane apmejüiquich merang najawan, majüic nguiane iyar minajiüt merang atquiaja? ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Quiaj tasaj nejiw Teat Jesús: ―Indrojchiün ombas aaga nangaj iüm cam, ndoj xique wüx er nüt sanawitich alinomb ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Quiaj titsojow nej, tapiüngüw: ―Aaga nadam nangaj iüm cam tarangüch wüx ic miow anaíw (46) neat; ¿nguineay ipiüng ique apmewitich wüx er nüte? ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Pero Teat Jesús ngo mandeac wüx aaga nadam nangaj iüm quiaj. Nej tandeac andüy wüx ombas nej. ");
INSERT INTO huvNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Wüx Teat Jesús tapac alinomb imiün tiül mondeow, quiaj minipilan nej leaad omeajtsüw aaga poch leaw tandeac quiaj. Aton tayariw tayacüw wüx omeajtsüw leawa nomb tarangüw mondeac andeac Teat Dios, at aaga poch tasaj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Wüx Teat Jesús altiül Jerusalén tiül nangos nüt pascua, xeyay nipilan tayariw leaw nej aquiaach cos tajawüw meáwan ateócan leaw nej tarang. ");
INSERT INTO huvNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Naleaing Teat Jesús ngo masap ombas majaw nejiw, cos ajaw nguineay ajlüyiw meáwan. ");
INSERT INTO huvNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Nej ngo metam nejinguind masaj nej nguineay omeaats nipilan, cos nej lamajaw nguineay omeaats meáwan nipilan. ");
INSERT INTO huvNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Tajlüy nop naxey tiül fariseos nenüt Nicodemo. Nej nop nenajiüt tiül nipilan judío. ");
INSERT INTO huvNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Aaga naxey quiaj tamb majaw Teat Jesús noic ongwiiüts. Tasaj: ―Rabí, sajawan Teat Dios tüüch ic mewiün mequiaach xicon; cos nejinguind ngondom marang ateócan atnej ique irang sitiül ngome Teat Dios ambeol nej ―aj. ");
INSERT INTO huvNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Quiaj tasaj nej Teat Jesús: ―Naleaing naleaing sasaj ic, sitiül aljane ngo wijquiam alinomb, ngome apmajlüy tiül xenipilan majaw micambaj Teat Dios ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Quiaj Nicodemo tatün nej manguiay: ―¿Nguineay alndom nop natang nipilan mandilil wijquiam alinomba? ¿Mbich alndom majmel teomeaats mimüm nej alinomb wijquiama? ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Quiaj tasaj nej Teat Jesús: ―Naleaing naleaing sasaj ic, sitiül nop nipilan ngo wijquiam alinomb naag yow y Nangaj Espíritu ocueaj Teat Dios, aag ayaj ngondom majmel tiül micambaj Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Leaw micual cambajiüt, cambajiüt nej; nganüy jane apwijquiam alinomb naag Nangaj Espíritu ocueaj Teat Dios ajlüy atnej jayats wijquiam, awiquiach nej Nangaj Espíritu. ");
INSERT INTO huvNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Nde mbayamear menguiay sasaj ic quiaj: “Netam wijquiamaran alinomb”, naj ic. ");
INSERT INTO huvNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Cos iünd apep nguiajantanej imiün, alndom menguiay aterriür, pero ngo mejaw nguiane imiün, at ngo mejaw nguiane andüy. Atquiaj ajlüy wüx nop jayats wijquiam, awiquiach nej Nangaj Espíritu ocueaj Teat Dios ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nicodemo tandüy wüx matün manguiay: ―¿Nguineay alndom marangüch atnej ipiüng quiaja? ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Quiaj tasaj nej Teat Jesús: ―Ique nop ic natang nequiaach tiül nipilan judío. ¿Neol ngo mejaw wüx aag ayaja? ");
INSERT INTO huvNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Naleaing naleaing sasaj ic, xicona sandeacan wüx leaw sajawan naleaing, at leaw sajawan naag xiniüjcan sandeacan manguiayaran. Pero icona ngo mendiüman meyariün sandeacan. ");
INSERT INTO huvNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Sitiül ngo meyariün sandeac wüx leaw almajlüy ningüy wüx aaga iüt cam, ¿nguineay apmeyariün sitiül sanandeac wüx leaw almajlüy tiül cielo? ");
INSERT INTO huvNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","’Nejinguind nganaw mamb andüy cawüx tiül cielo, áag miün tiün imiün cawüx tiül cielo, aag ayaj Teat Naxey, cos imiün quiaj tiün. ");
INSERT INTO huvNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Atnej tanomb tarang Moisés tiül wajchiüc wüx taxaing nop narangüch ndiüc mayac cawüx wüx nots xiül, atanquiaj apxaijnguiam Teat Naxey mayacüch wüx cruz. ");
INSERT INTO huvNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Pares meáwan jangantanej leaw apmayar nej andeac, apmapac meáwan nüt niüng ajlüy Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","’Cos Teat Dios xeyay andiüm meáwan nipilan wüx aaga iüt cam, áag tüüch miün anopǘyan Micual Nej mawün wüx asoet jangantanej leaw apmayar nej andeac. Atquiaj ngondom ndrom mamb tiül aaga xeyay ngo majneaj; pero apmapac meáwan nüt niüng ajlüy Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Teat Dios ngo müüch miün anopǘyan Micual nej wüx aaga iüt cam mayac asoet nipilan. Ngwüy, nej tiün mawün wüx asoetiw meáwan nipilan wüx aaga iüt cam. ");
INSERT INTO huvNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Jane apmayar andeac Micual Teat Dios, Teat Dios lango mayac nej asoet; pero jane ngo mayar andeac nej, mbich landoj lamayac nej asoet Teat Dios, cos ngo mayar andeac anopǘyan Micual Nej. ");
INSERT INTO huvNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Nej tiün wüx aaga iüt cam majlüy atnej ran, cos aquiaach leaw naleaing. Pero altiül ngo mandiümüw aaga ran quiaj, cos xeyay tandiümüw aaga pojniün niüng alndom mexotayej marangüw ngo majneaj. Ajcüw ayaj lamayac nejiw asoetiw Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Meáwan ajcüw leaw andiümüw marangüw ngo majneaj ngo mandiümüw aaga ran quiaj, ajcüyiw majawüw, ngo matüchiw. Cos sitiül apmambüw quiaj, aaga ran quiaj apmajüiquich ngo majneaj teamarangüw. ");
INSERT INTO huvNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Nganüy monrang najneaj, nejiw mbich ambüw niüng ajlüy aaga ran. Quiaj ajüiquichaw nguineay arangüw najneaj atnej andiüm Teat Dios ―aj nej Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ndoj Teat Jesús taw Jerusalén tamb andüy tiül iüt Judea aquiiüb minipilan nej. Tacüliw quiaj acas nüt, tüjchiw yow nipilan. ");
INSERT INTO huvNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Aton Juan tenguial üüch yow nipilan tiül Enon, quiájan niüng ajlüy Salim cos ajlüy quiaj xeyay yow. Xeyay nipilan apeayiw quiaj müjndiw yow. ");
INSERT INTO huvNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Aag ayaj tajlüy wüx nganaw mayacüch tiül manchiüc a Juan. ");
INSERT INTO huvNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Condom tajlüy noic mondeac tiül nipilan judío maquiüjpüw minipilan Juan nguineay alndom najneajay majlüyiw majaw nejiw Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ndoj ajcüw aaga nipilan quiaj, tambüw masajüw a Juan: ―Rabí, ijaw nguineay teamarang aaga naxey leaw tequiiüb nonüt necamb lam Jordán, áag tesaj xicon wüx. Nganüy nej aton tenguial üüch yow nipilan, meáwan laambüw mandüjpiw nej ―ajüw. ");
INSERT INTO huvNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Quiaj tasaj nejiw a Juan: ―Nejinguind ngondom marang aag ayaj sitiül Teat Dios najlüy tiül cielo ngo müüch nej marang. ");
INSERT INTO huvNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Icona tenguiayiün wüx tapiüngas, xique ngome aaga Cristo lapiürang aliüc. Xique tüjndiüs niün ombas xic, nej aliüc tamiün. ");
INSERT INTO huvNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Pues wüx nop nench apmaquiiüb nop nüx, aaga nench quiaj almajiür miamigo nej alquiaj almaquiiüb nej. Wüx anguiay nej andeac xeyay apac omeaats manguiay. Ata xique nganüy wüx sanguiay nguineay Teat Jesús xeyay andüjpiw nej, xeyay apac ximeaats nanguiay, cos leaw ninguiaj netam narang. ");
INSERT INTO huvNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Nej netam marang natang, nganüy xique apmapateay satam. ");
INSERT INTO huvNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","’Aaga niün imiün tiül cielo, nej ajlüy wüx meáwan leaw almajlüy. Nganüy nop najlüy wüx iüt, aag ayaj naw wüx iüt; nej andeac wüx leaw ajlüy wüx aaga iüt cam. Nganüy aaga niün imiün tiül cielo, nej ajlüy wüx meáwan almajlüy. ");
INSERT INTO huvNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Nej andeac wüx leaw ajaw, at andeac wüx leaw anguiay; pero nejinguind ngo mayar andeac nej. ");
INSERT INTO huvNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Jane apmayar andeac nej, aag ayaj apmajaw naleaing andeac Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Cos jane Teat Dios üüch miün, nej andeac leaw andeac Teat Dios, cos Teat Dios üüch nej Nangaj Miespíritu nej palanüy, ngo metam mapeax. ");
INSERT INTO huvNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Teat Dios xeyay andiüm Micual Nej; meáwan leaw almajlüy lamayac tiül owix nej. ");
INSERT INTO huvNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Jane ayar andeac Micual Teat Dios apmapac meáwan nüt niüng ajlüy Teat Dios. Nganüy jane ngo mandiüm mayar andeac Micual Teat Dios, ngome apmajaw aaga apacaran quiaj cos xeyay ajcüy majaw nej Teat Dios ―aj nejiw a Juan. ");
INSERT INTO huvNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Wüx Teat Jesús tajaw nguineay ajcüwa fariseos tandeacndeacüw wüx nej cos teaxeyay minipilan nej, aton xeyay teamüüch yow nipilan ngo matnej Juan; ");
INSERT INTO huvNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","masey ngome nejay Teat Jesús neech yow, minipilan nej arangüw. ");
INSERT INTO huvNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Wüx Teat Jesús tajaw aag ayaj, quiaj taw quiaj tiül Judea, tandilil andüy Galilea alinomb. ");
INSERT INTO huvNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Pero netam mamong amb tiül iüt Samaria. ");
INSERT INTO huvNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Condom tatüch tiül noic nine cambaj nenüt Sicar tiül iüt Samaria. Quiájan mbeay cambaj ajlüy miíüt aaga Jacob najlüy tanomb. Aaga iüt quiaj nej tüüch José micual nej. ");
INSERT INTO huvNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Alquiaj aaga lol pil tarang teat Jacob tanomb. Teat Jesús cos laǘmb apac ajüy, chetet quiaj mbeay lol, laliüc lembem nüt. ");
INSERT INTO huvNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Quiaj tapeay nop najtaj naw Samaria mepiow yow. Teat Jesús tasaj nej: ―Nachej tigüy miyow müm, nanganeow ―aj. ");
INSERT INTO huvNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Minipilan nej laambüw tiül cambaj mangalüw nüeteran. ");
INSERT INTO huvNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Aaga najtaj naw Samaria tasaj Teat Jesús: ―¿Neol techej xicueaj yow, teat? Cos ique nop ic nipilan judío, nganüy xique nop najtaj nawas Samaria. Ique ijaw nipilan judío ngome áag andeacüw maquiüjpüw monaw Samaria ―aj. ");
INSERT INTO huvNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Quiaj tasaj nej Teat Jesús: ―Sitiül mejaw leaw Teat Dios alndom müüch, aton mejaw jane nechej icueaj yow, sayaag apmetün xicueaj, condom sanüüch ic yow leaw üüch mapacaran meáwan nüt ―aj. ");
INSERT INTO huvNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Quiaj tasaj nej a najtaj: ―Teat, ique ngo mejiür cuane merwüneay yow, nganüy aaga lol cam xeyay nequiliüt. ¿Nguia naw apmeyar aaga yow ipiüng quiaja? ");
INSERT INTO huvNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Cos xexejchiün teat Jacob tacueat müüch xicon aaga lol cam. Nej tanganeow aaga yow, at micual nej, minimal nej. ¿Jow nganüy ique, alwüx itama, ngo matneje? ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Quiaj tasaj nej Teat Jesús: ―Jangantanej apmanganeow a yow cam apmind anganeow yow alinomb. ");
INSERT INTO huvNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Pero jane apmanganeow aaga yow xique sanüüch, langome apmind anganeow yow alinomb. Cos aaga yow xique sanüüch, apmajlüy tiül nej atnej noic lol teapacaw müüch nej mapac meáwan nüt ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Condom tasaj nej aaga najtaj: ―Teat, iich xic aaga yow ipiüng quiaj, quiaj langome apmind sanganeow yow alinomb, atquiaj ngo metam niün ningüy nayar yow ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Quiaj tasaj nej Teat Jesús: ―Quiür ipaj minoj, iquiiüb miün ―aj. ");
INSERT INTO huvNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Quiaj tapiüng a najtaj: ―Ngo najiür xenoj ―aw. Quiaj tasaj nej Teat Jesús: ―Naleaing ipiüng ngo mejiür minoj; ");
INSERT INTO huvNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","cos lamejiür acoquiaw. Nganüy aag almequiiüb, aag ayaj ngome minoj. Naleaing tepiüng ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Camüm manguiay aag ayaj a najtaj, quiaj tapiüng: ―Teat, sapiüng ique nop nendeac andeac Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Isaj xic neol xexejchiün tarangüw casa Teat Dios cawüx wüx aaga tiüc quiaj, nganüy icona nipilan judío ipiüngan áagan tiül Jerusalén alndom marangüch casa Teat Dios ―aw. ");
INSERT INTO huvNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Quiaj tasaj nej Teat Jesús: ―Netam meyar sandeac, müm, cos aliüc miün nüt wüx ngome apmetam meamban wüx aaga tiüc quiaj, átan ngome apmetam meamban Jerusalén merangan casa Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Icona monaw Samaria ngo mejawan jane teamerangan casa; xicona mbich sajawan jane sarangan casa, cos naw tiül nipilan judío ajlüy jane apmawün wüx asoeteran. ");
INSERT INTO huvNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Aliüc apmatüch a nüt, aag ayaj nganüy, cos jane naleaing ayamb Teat Dios wüx omeaats, apmajüiquich naleaing wüx omeaats arang, ngo mitsoj. Cos Teat Dios aton atquiaj andiüm marangüch casa. ");
INSERT INTO huvNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Teat Dios Espíritu nej; jane apmayamb nej netam marang con omeaats, masey ngondom maxom majaw ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Quiaj tasaj nej a najtaj: ―Lanajaw aliüc Mesías, aaga nasoic Cristo. Wüx nej apmapeay apmasaj icoots nguineay ajlüy meáwan cuajantanej ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Teat Jesús tapiüng: ―Xique aag ipiüng quiaj, tenguial andeacar ―aw. ");
INSERT INTO huvNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Aliünüw wüx andeacüw, quiaj ajngotoj minipilan Teat Jesús. Nejiw mbayajow wüx tajawüw Teat Jesús teandeac maquiiüb nop najtaj. Pero taton ngo matüniw nej manguiayiw cuane andiüm a najtaj, cuane wüx teamandeacüw. ");
INSERT INTO huvNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Condom quiaj taw quiaj a najtaj, acueátan quiaj mingan nej; tamb andüy tiül cambaj, tasaj nipilan: ");
INSERT INTO huvNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―Macaron, ijawan nop naxey lamasaj xic meáwan leaw lanarang. ¿Ngwüy ijaca, aaga Cristo neje? ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Quiaj tawüw tiül cambaj, tambüw majawüw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Wüx nipilan nganaw mapeayiw quiaj, minipilan nej teamasajüw nej: ―Teat, mac iret ―ajüw. ");
INSERT INTO huvNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Nej tasaj nejiw: ―Xique sajiür süet, icona ngo mejawan cuane ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Condom minipilan nej tapots atünayej menguiayayej: ―¿Ngwüy, aljane tajamiün üet neje? ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Quiaj Teat Jesús tasaj nejiw: ―Icona apac imeajtsan wüx landoj iretiün, xique apac ximeaats wüx sarang leaw Xeteat Dios tüüch xic niün narang, cos sandiüm nandondoch minajiüt nej. ");
INSERT INTO huvNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Icona wüx lapiürüch corrül ipiüngan: “Wüx lamatüch apiquiw caaw, quiaj apxaijnguiam omeaats corrül”, irawan. Nganüy xique sasaj icon: Netam mejawan a corrül, cos nganüy lajneaj xaijnguiam omeaats corrül. ");
INSERT INTO huvNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Jane arang xenajiüt maxaing sapiür, sanangüy alinoic nüt, cos aaga arang quiaj apmajlüy meáwan nüt. Aaga nepiür, maquiiüb nexaing omeaats corrül, apmapac omeajtsüw nóiquian. ");
INSERT INTO huvNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ningüy ajüic naleaing leaw apiürang: “Pálwüx nepiür, pálwüx nexaing”. ");
INSERT INTO huvNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Xique lanüüch icon meamban merangan xenajiüt. Aag ayaj apmajlüy atnej wüx nop mayambüch mamb maxaing omeaats corrül, masey ngome nej nepiür; cos pálwüx nesaj nipilan wüx xique, nganüy icona ipeánan mesajüw mayambüw xic ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Xeyay nipilan monaw tiül aaga cambaj tiül iüt Samaria tayariw andeac Teat Jesús wüx tanguiayiw andeac aaga najtaj, cos tapiüng: “Tasaj xic meáwan leaw lanarang”, maw. ");
INSERT INTO huvNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Wüx tapeayiw quiaj monaw tiül aaga cambaj quiaj, tapots masajüw Teat Jesús macül quiaj maquiüjpüw. Quiaj tacül quiaj ic nüt. ");
INSERT INTO huvNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Xeyay nipilan tayariw nej andeac wüx tanguiayiw nejay Teat Jesús tenguial aquiaach. ");
INSERT INTO huvNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Condom tasajüw a najtaj: ―Nganüy mbich lanayariün andeac nej cos nejay tanguiayasan andeac, ngome áagan leaw tesaj xicon wüx nej. Nganüy sajawan naleaing nej aaga Cristo leaw lapiürang aliüc mawün wüx asoet nipilan meáwan wüx iüt ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Wüx tamong ic nüt quiaj, Teat Jesús taw Samaria, tamb andüy Galilea. ");
INSERT INTO huvNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Masey nejay Teat Jesús tandeac nguineay nop nendeac andeac Teat Dios ngome andiüram tiül miíüt nej, nganüy nej apmandilil mandüy quiaj alinomb. ");
INSERT INTO huvNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Wüx tapeay tiül Galilea, apac omeajtsüw majawüw nej monaw quiaj, cos nejiw laiünüw Jerusalén aton majawüw nangos nüt pascua. Tajawüw quiaj meáwan leaw nej tarang wüx nangos nüt. ");
INSERT INTO huvNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Condom Teat Jesús tandilil alinomb andüy cambaj Caná tiül Galilea, niüng ninguinüt tangowüüch yow marang vin. Ajlüy tiül cambaj Capernaum nop natang nenajiüt ocueaj cambaj, xeyay iün andeow micual nej. ");
INSERT INTO huvNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Aaga naxey quiaj wüx tanguiay Teat Jesús lapeay Galilea imiün Judea, tamb matüch quiaj majaw. Tapots matün ocueaj Teat Jesús mamb aniüng nej mamongoch iün andeow micual nej, cos laxeyay, laliüc mandeow. ");
INSERT INTO huvNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Quiaj tasaj nej Teat Jesús: ―Icona sitiül ngo mejawan ateócan ngome apmeyariün sandeac ―aj. ");
INSERT INTO huvNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Naleaing aaga nenajiüt xeyay tatün ocueaj Teat Jesús, tasaj: ―Teat, ich majmiüc imal imeaats, tabar wǘxan nganaw mandeow xecual ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Condom quiaj tasaj nej Teat Jesús: ―Quiür ijtsor, micual lajneaj ―aj. Aaga naxey tayar andeac Teat Jesús, quiaj tajtsor. ");
INSERT INTO huvNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Wüx laámb apmapeay aniüng nej, tambüw mangochiw nej mimos nej, tapiüngüw: ―Micual lajneaj ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Condom quiaj tatün manguiay nejiw cuame ores tajneaj micual nej. Quiaj tapiüngüw: ―Tim lanchejliow nüt tacueat müüch nej nerraar, quiaj tajneaj ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Quiaj leaad omeaats aaga naxey, naleaing aaga ores wüx tasaj nej Teat Jesús: “Micual lajneaj”, maj nej. Quiaj aaga naxey tayar andeac Teat Jesús maquiiüb meáwan leaw alaniüng nej. ");
INSERT INTO huvNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Aaga leaw tarang Teat Jesús wüx tandilil andüy Galilea imiün Judea, aag ayaj amb ijmbüw ateócan lamarang quiaj. ");
INSERT INTO huvNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Wüx ndoj ayaj lamatüch a nüt wüx nipilan judío ajiürüw noic nangos nüt. Quiaj Teat Jesús tamb alinomb andüy Jerusalén. ");
INSERT INTO huvNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ajlüy quiaj tiül Jerusalén noic apal ombeay cambaj niüng among sap. Alquiaj noic nadam oniiüg yow, minüt nej Betesda tiül ombeayiw nipilan judío. Ayey nej tiüt acoquiaw iüm ngo majiür owil. ");
INSERT INTO huvNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ajlüyiw quiaj xeyay moniün andeow: altiül nesomb, altiül necoex, altiül ndron ombas ngondom majüy. Teamacüliw ngow, cojores apmendalalüy a yow quiaj. ");
INSERT INTO huvNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Cos nguiajnguiaj iün nop ángel ocueaj Teat Dios maól a yow, ndoj jane ombas apmajmel tiül a yow quiaj apmajneaj iün andeow. ");
INSERT INTO huvNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Alquiaj nop naxey lamajiür nimiow gajpopeac (38) neat iün andeow. ");
INSERT INTO huvNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Teat Jesús tajaw alpiiüm quiaj, lamajaw lamajiür xeyay neat iün andeow a naxey quiaj, quiaj tasaj: ―¿Ngwüy indiüm mejneaja? ―aj. ");
INSERT INTO huvNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Quiaj tasaj nej aaga niün andeow: ―Teat, ngo najiür jane mayac xic tiül yow wüx apmendalalüy. Cos wüx lasamb sanajmel, quiaj lajmel alinop ombas nej ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Quiaj tasaj nej Teat Jesús: ―Witiür, ixaing mitec ijüy ―aj. ");
INSERT INTO huvNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Andǘüban ajneaj a naxey quiaj, taxaing mitec nej, tajüy. Pero cos aaga nüt quiaj, noic nüt axoodaran, ");
INSERT INTO huvNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","quiaj ajcüwa monajiüt tiül judíos tasajüw aaga naxey lajneaj quiaj: ―Nganüy nüt axoodaran, ngondom mexaing mejoy mitec ―ajüw. ");
INSERT INTO huvNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Quiaj tasaj nejiw aaga naxey: ―Aaga neech xic najneaj, nej nesaj xic: “Ixaing mitec, ijüy” ―aj xic. ");
INSERT INTO huvNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Quiaj tatüniw nej manguiayiw: ―¿Jane aaga nesaj ic: “Ixaing mitec, ijüye”? ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Naleaing aaga naxey quiaj ngo majaw jane netaag nej majneaj, cos tajlüyiw quiaj xeyay nipilan, nganüy Teat Jesús laáw quiaj. ");
INSERT INTO huvNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Condom Teat Jesús taxom nej tiül nadam nangaj iüm. Tasaj: ―Ijaw nganüy lerneaj, nde mendüy wüx merang nisoet, ngana maxom ic alinoic xeyay ngo majneaj ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Condom tamb a naxey quiaj masaj ajcüwa monajiüt tiül judíos Teat Jesús netaag nej majneaj. ");
INSERT INTO huvNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Quiaj ajcüwa monajiüt tajcüyiw majawüw Teat Jesús, tayambüw ombas mambiyaw cos arang cuajantanej wüx nüt netam maxoodaran. ");
INSERT INTO huvNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Condom Teat Jesús tasaj nejiw: ―Xeteat meáwan nüt arang najiüt, ata xique aton ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Quiájan ajcüwa monajiüt tandiümüw mambiyaw nej cos ngome áagan arang wüx nüt axoodaran, pero cos tayac atnej Dios nej wüx tapiüng miteat nej Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Condom quiaj tasaj nejiw Teat Jesús: ―Naleaing naleaing sasaj icon, Micual Teat Dios ngondom marang nicuajind arángan; nej arang leaw ajaw arang miteat nej. Cos meáwan leaw arang miteat nej, átan micual nej alndom marang aton. ");
INSERT INTO huvNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Teat Dios xeyay andiüm Micual Nej, üüch nej majaw meáwan leawa nej teamarang; aliüc miün apmüüch majaw alngün xeyay najneaj leawa icona apmbayameron mejawan. ");
INSERT INTO huvNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Cos Teat Dios apacüüch mondeow, atquiaj Micual Nej aton apmapacüüch jane nej andiüm. ");
INSERT INTO huvNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ngome nejay Teat Dios apmayac asoeteran, meáwan ayaj lamayac teowix Micual Nej. ");
INSERT INTO huvNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Atquiaj meáwan nipilan netam marangüw casa Micual Nej atnej arangüw casa Teat Dios. Jane ngo mandiüm Micual Teat Dios, átan ngo mandiüm Teat Dios, cos Teat Dios neech nej miün. ");
INSERT INTO huvNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Naleaing sasaj icon: Jane apmayac omeaats wüx manguiay sandeac, aton mayar andeac aaga neech xic niün, nej apmapac meáwan nüt, lango majmel asoet. Apmapac meáwan nüt niüng ajlüy Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Naleaing sasaj icon, aliüc apmatüch a nüt, aag ayaj nganüy, wüx mondeow apmanguiayiw andeac Micual Teat Dios. Jane apmanguiay mayar andeac apmapac. ");
INSERT INTO huvNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Teat Dios üüch mapacaran, atquiaj Micual Nej aton alndom müüch mapacaran, cos atquiaj üüch nej Teat Dios marang. ");
INSERT INTO huvNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","At lamüüch majaw wüx asoeteran cos nej Teat Naxey. ");
INSERT INTO huvNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Nde mbayameron menguiayiün aaga sasaj icon cam, cos aliüc miün nüt wüx meáwan mondeow apmanguiayiw nej andeac. ");
INSERT INTO huvNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Jane tarangüw najneaj apmawüw tiül mondeow mapacüw meawan nüt tiül cielo; nganüy monarang ngo majneaj apmapacüw aton majmel asoetiw nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","’Xique ngondom narang nicuajind sandíüman xique, sarang leawa sasoic. Wüx xique sayac asoet aljane, sayac leaw naleaing nej tarang. Xique ngo nateots narang sandíüman xique, sarang leaw andiüm Xeteat Dios, cos nej tüüch xic niün. ");
INSERT INTO huvNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Sitiül xiquiáyan quiaj teanandeac wüx leaw alndom narang, alndom mapiürang aag ayaj ngo membeat. ");
INSERT INTO huvNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ajlüy nop nendeac naleaing wüx xique nguineay alndom narang. Xique sajaw leaw nej andeac wüx xique, aag ayaj xeyay nembeat. ");
INSERT INTO huvNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Icona teajchiün mambaran niüng ajlüy Juan matüniw manguiayiw nej. Leaw nej tapiüng wüx xique aag ayaj naleaing. ");
INSERT INTO huvNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Xique ngo metam xic aljane mapiüng jane xic. Aag ayaj sasaj icon cos sitiül apmeyariün sandeac apmeriowan wüx isoetiün. ");
INSERT INTO huvNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Aaga teat Juan tajlüy atnej nots najquiol teatitit andaab marraj nipilan. At icona tapac imeajtsan acas nüt wüx tarraj icon cos tenguiayiün aquiaach nej. ");
INSERT INTO huvNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Xique sajiür cuane nejüiquich jane xic; aag ayaj alwüx ambeat, ngome áagan leaw tapiüng a Juan. Meáwan leawa xic sarang, leaw tüjndiüs niün narang, ajüiquich majaw naleaing Teat Dios neech xic niün. ");
INSERT INTO huvNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Aaga Teat neech xic niün quiaj, aton lamandeac wüx xique; masey icona ngo menguiayiün andeac nej, ngo mexoman mejawan. ");
INSERT INTO huvNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Meáwan andeac nej ngo macül wüx imeajtsan, cos ngo mendiüman meyariün andeac aaga leawa Teat Dios tüüch miün. ");
INSERT INTO huvNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Icona xeyay ipacan wüx meteowan Mipoch Teat Dios cos ipiüngan quiaj alndom mepacan meáwan nüt tiül cielo. ¿Neol ngo mejawana, tiül Mipoch Teat Dios andeac wüx xique? ");
INSERT INTO huvNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Naleaing icona ngo mendiüman meyariün sandeac nüüch icon mepacan meáwan nüt tiül cielo. ");
INSERT INTO huvNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Xique ngo nayamb nipilan marangüw xic casa ombeayíwan. ");
INSERT INTO huvNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Xique sayaag imbasan, sajaw icona ngo mendiüman Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Jogüy xique tiünas, tüüch xic niün Xeteat Dios, pero icona ngo meyariün sandeac. Jondot miün nop nejáyan quiaj, aag ayaj mbich apmeyariün andeac nej. ");
INSERT INTO huvNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿Nguineay icona apmeyariün andeac Teat Dios sitiül mbich meaw ilombochayon icoyónan quiaj? Cos ngo meyacan wüx imeajtsan meyamban mandeac najneaj wüx imbasan Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Nde mepiüngan xique sanayac isoetiün niüng ajlüy Xeteat Dios; cos leaw arang atquiaj, aag ayaj a poch tüünd Moisés leaw ipiüngan indüjpiün. Aag ayaj ajüiquich nguineay irangan. ");
INSERT INTO huvNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Jondot naleaing iyariün andeac Moisés, apmeyariün sandeac aton, cos Moisés tapiüng wüx xique. ");
INSERT INTO huvNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","¿Nguineay apmeyariün sandeaca, sitiül andeac teat Moisés ngo meyariün? ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Noic nüt Teat Jesús tamb andüy necamb nadam yow Galilea, aaga nasoic Tiberias aton. ");
INSERT INTO huvNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Xeyay nipilan tandüjpiw nej mamb cos lamajawüw tarang xeyay ateócan, tamongoch iün andeow xeyay moniün andeow. ");
INSERT INTO huvNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Condom Teat Jesús tamb andüy wüx nop tiüc chetet quiaj maquiiüb minipilan nej. ");
INSERT INTO huvNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Laliüc matüch aaga nangos nüt pascua ocueajiw nipilan judío. ");
INSERT INTO huvNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Wüx Teat Jesús taxaing omal majaw aliücüw xeyay nipilan, quiaj tasaj a Felipe: ―¿Nguiane apmangalaats nüeteran müjchiiüts metiw meáwan ajcüwa nipilan quiaja? ―aj. ");
INSERT INTO huvNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Aag ayaj tandeac cos andiüm majaw cuane apmapiüng a Felipe, cos Teat Jesús lamajaw cuane apmarang. ");
INSERT INTO huvNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Quiaj tasaj nej a Felipe: ―Teat, masey majlüy ijquiaw coic miow (200) tomiün denario majon pan, ngome apmatüch nejiw nequirquiriw ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Condom quiaj alinop minipilan nej Teat Jesús, aaga Andrés michiig a Simón Pedro, tapiüng: ");
INSERT INTO huvNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―Alningüy nop nench ajiür acoquiaw pan cebada alijpüw nine cüet. Pero ¿nguitow apmawiül aaga atoyay nipilan quiaja? ―aw. ");
INSERT INTO huvNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Condom quiaj tasaj nejiw Teat Jesús: ―Isajan meáwan chetemoj ―aj nejiw. Cos niüng almajlüyiw ajlüy xeyay nine nateaic soex, quiaj chetetoj tiüt, atüch tam acoquiaw mil monxey. ");
INSERT INTO huvNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Quiaj Teat Jesús taxaing aaga acoquiaw pan; condom wüx landoj müüch gracias Teat Dios, quiaj tambaag müüch minipilan nej. Condom minipilan nej tajineaw müjchiw meáwan ajcüwa nipilan. Atanquiaj tarang wüx aaga cüet aton, tüüch nejiw leaw tandiümüw. ");
INSERT INTO huvNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Condom wüx lapaxiow üetiw, quiaj tasaj minipilan nej: ―Ixainguiün meáwan leawa nenaw, ngondom majcueat tiüt nicuajind ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Almümb maxainguiw, leaw nenaw üetiw tiül aaga acoquiaw pan cebada leaw tajlüy, chipiüt gajpiüp (12) nchep. ");
INSERT INTO huvNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ajcüwa nipilan almajawüw aaga ateócan lamarang Teat Jesús quiaj, tapiüngüw: ―Naleaing, nejay aaga nendeac andeac Teat Dios leaw netam miün ningüy wüx iüt cam ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Nej a Teat Jesús wüx tajaw andiümüw masapüw nej mayacüw marang minatang nenajiüt ocueajiw nejiw, quiaj taw quiaj anopǘyan. Tamb andüy miünquiaj tiül tiüc. ");
INSERT INTO huvNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Wüx langwiiüts, quiaj minipilan nej Teat Jesús tawüw tiüt tambüw andüyiw mbeay aaga nadam yow. ");
INSERT INTO huvNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Lapojniowüy, nganaw mapeay quiaj Teat Jesús, quiaj tajtepiw tiül nop müx mamongoj a yow quiaj andüyiw cambaj Capernaum. ");
INSERT INTO huvNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Condom quiaj taw noic nadam iünd xowüy lapac, tayac nadamdam omal yow. ");
INSERT INTO huvNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Wüx lamiünquiaj ambüw, quiaj tajawüw Teat Jesús laliüc matüch nejiw, teajüy amb teomal yow. Quiaj mbayatoj. ");
INSERT INTO huvNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Nej tasaj nejiw: ―Nde mbayameron, xique, ngome aljane ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Nejiw apac omeajtsüw, quiaj tatepichaw nej tiül müx, camüm mayajcüw lapeayiw niüng andüyiw quiaj. ");
INSERT INTO huvNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ajcüwa nipilan tacülíwan necamb yow aaga ongwiiüts quiaj. Wüx rat tiüt tealeámban mayambüw quiaj Teat Jesús; cos tajawüw ambüw tiül müx minipilan nej nejíwan quiaj, pero Teat Jesús ngo mamb; aton cos áagan a müx tajlüy quiaj. ");
INSERT INTO huvNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Aliünüw quiaj niüng Teat Jesús tatün ocueaj Teat Dios metiw ajcüwa nipilan quiaj; quiaj apeayiw quiaj acas müx imiünüw tiül cambaj Tiberias. ");
INSERT INTO huvNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Wüx tajawüw naleaing ngo majlüy quiaj Teat Jesús átan minipilan nej, quiaj tajtepiw tiül ajcüwa müx quiaj, tambüw andüyiw Capernaum mayambüw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Wüx tapeayiw necamb aaga nadam yow quiaj, quiaj taxomüw Teat Jesús, tasajüw: ―Rabí ¿ngüt tepeay ningüye? ―ajüw. ");
INSERT INTO huvNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Quiaj tasaj nejiw Teat Jesús: ―Naleaing sasaj icon, sajaw tenguial meyamban xic cos paxiüt iretiün, ngome teameyamban xic cos ijawan neol alndom narang cuajantanej. ");
INSERT INTO huvNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Netam merangan najiüt meyamban cuane meatiün. Pero nde meyacan imeajtsan wüx leaw alndom mexoman ningüy wüx iüt cos ngome apmaíüc, apmamong najen. Netam meyamban leawa ngome apmamong: aaga neech mapacaran meáwan nüt niüng ajlüy Teat Dios. Aag ayaj Teat Naxey apmüüch icon, cos Teat Dios lamayac teowix nej marang aag ayaj ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Condom quiaj tatüniw manguiayiw nej: ―¿Cuane netam narangana? ¿Nguineay alndom narangan leaw Teat Dios andiüma? ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Quiaj tasaj nejiw Teat Jesús: ―Leaw andiüm Teat Dios majaw merangan, aag ayaj meyariün andeac jane üüch miün ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Condom quiaj tasajüw nej: ―¿Cuane alndom merang najawan para nayariün indeaca? Jow nganüy, ¿cuane apmeranga? ");
INSERT INTO huvNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Cos xexejchiün tüjndiw nüeteran wüx tajlüyiw tiül wajchiüc, atnej apiüng tiül Mipoch Teat Dios: “Tüjndiw nüeteran imiün cielo” ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Quiaj tasaj nejiw Teat Jesús: ―Naleaing sasaj icon, ngome mixejchiün Moisés neech nejiw a nüeteran quiaj; nejay Xeteat Dios neech nejiw. Nganüy nej lamüüch icon leaw najneajay nüeteran imiün tiül cielo. ");
INSERT INTO huvNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Cos nüeteran leawa Teat Dios üüch nganüy, aag ayaj tüüch miün imiün tiül cielo, para meáwan nipilan wüx iüt mapacüw meáwan nüt ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Condom tasajüw nej: ―Teat, iich xicon aaga nüeteran ipiüng quiaj ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Quiaj tasaj nejiw Teat Jesús: ―Xique aaga nüeteran alndom müüch mapacaran meáwan nüt. Cos jane aliüc niüng sajlüy langome apmind üet; jane apmayar sandeac langome apmind anganeow yow alinomb. ");
INSERT INTO huvNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Naleaing landoj nasaj icon, pero cos icona ngo meyariün sandeac masey lamejawan xic. ");
INSERT INTO huvNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Meáwan leaw Xeteat Dios üüch xic majlüy xenipilan nejiw, nejiw aliücüw niüng sajlüy, xique ngome sanawüniw. ");
INSERT INTO huvNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Xique tiünas ximiün cielo narang leaw andiüm aaga neech xic niün, ngome xiün narang leaw xique sandiüm. ");
INSERT INTO huvNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Xeteat Dios, aag neech xic niün, nej ngo mandiüm majaw ndrom nop tiül nejiw leaw nej lamüüch xic; leawa nej andiüm, aag ayaj napacüjchiw alinoic nüt. ");
INSERT INTO huvNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Leaw Xeteat Dios andiüm, aag ayaj meáwan jane apmajaw Micual nej mayar andeac, apmapac meáwan nüt; xique sanapacüjchiw alinoic nüt ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Quiaj ajcüwa monajiüt tiül nipilan judío tapots andeacndeacüw ngo majneaj wüx Teat Jesús cos apiüng: “Xique aaga nüeteran tiün imiün cielo”, maw. ");
INSERT INTO huvNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","At tapiüngüw: ―¿Neol, ngome aag ayaj Jesús micual José? Icoots ajawaats jane miteat nej mimüm nej. Jow nganüy, ¿neol tapiüng nej imiün tiül cielo tiüna? ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Condom quiaj tasaj nejiw Teat Jesús: ―Icueatiün indeacndeacan quiaj. ");
INSERT INTO huvNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Nejinguind ngondom miün niüng sajlüy sitiül Xeteat Dios neech xic niün ngo mambeol nej miün. Aton xique sanapacüüch alinoic nüt majlüy niüng sajlüy. ");
INSERT INTO huvNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Tiül minawijquiaw mondeac andeac Teat Dios apiüng: “Teat Dios apmaquiaach meáwan nipilan.” Atquiaj a nganüy jane ayar andeac Teat Dios mayac wüx omeaats aliüc niüng sajlüy. ");
INSERT INTO huvNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’Nejinguind alinop ngo maxom majaw Xeteat Dios, aag miün leaw tiün imiün niüng ajlüy nej, nej ajaw. ");
INSERT INTO huvNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Naleaing naleaing sasaj icon, jane ayar sandeac aag ayaj lamajiür mapacaran nganüy, at apmajiür mapacaran meáwan nüt tiül cielo. ");
INSERT INTO huvNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Xique aaga nüeteran neech mapacaran meáwan nüt. ");
INSERT INTO huvNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Mixejchiün tanomb tüjndiw nüeteran imiün cielo wüx tajlüyiw tiül wajchiüc, pero tandeowüw. ");
INSERT INTO huvNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Nganüy xique teanasaj icon wüx leaw nüeteran tiün imiün tiül cielo, cos jane apmüet aag ayaj langome apmandeow. ");
INSERT INTO huvNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Xique aaga nüeteran almapac, tiün imiün cielo. Jane apmüet aaga nüeteran cam apmapac meáwan nüt. Aaga nüeteran leaw xique sanüüch, aag ayaj xecuerpo. Cos sanandeow ingow andeow meáwan nipilan wüx iüt ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Condom ajcüwa nipilan judío quiaj, tapots andeacndeacüw tíülan nejiw, tapiüngüw: ―¿Nguineay apiüng aag ayaj nej nüeterana? ¡Mbich icoots apmatsambaats nej! ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Quiaj tasaj nejiw Teat Jesús: ―Naleaing sasaj icon, sitiül ngo metsamban a Teat Naxey, ngo menganeowan miquiej nej, ngondom mepacan meáwan nüt. ");
INSERT INTO huvNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Jane apmatsamb xic manganeow xequiej apmapac meáwan nüt; cos xique sanapacüüch alinoic nüt. ");
INSERT INTO huvNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Xique aaga naleaing nüeteran, at xequiej aton aaga naleaing nanganeowaran. ");
INSERT INTO huvNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Jane apmatsamb xic manganeow xequiej apmaw wüx asoet nej; quiaj apmajlüy nóiquian maquiiüb xic, ata xique sanajlüy nóiquian naquiiüb. ");
INSERT INTO huvNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Xeteat Dios neech xic niün almapac, ata xique aton salnapac cos nej almapac. Atanquiaj jane apmatsamb xic sanüüch mapac meáwan nüt. ");
INSERT INTO huvNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Xique aaga atnej nüeteran tiün imiün tiül cielo. Aaga nüeteran quiaj ngome atnej Teat Dios tüüch mixejchiiüts müetiw wüx tajlüyiw tiül wajchiüc. Masey tüetiw, pero tandeowüw. Jane apmüet aaga nüeteran sasaj icon quiaj, apmapac meáwan nüt ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Atquiaj taquiaach Teat Jesús tiül noic sinagoga tiül Capernaum niüng xenenguejow nipilan judío. ");
INSERT INTO huvNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Wüx tanguiayiw aag ayaj, altiül minipilan nej tapiüngüw: ―Aag ayaj xeyay naél. ¿Mbich jane alndom manguiay mayac wüx omeaats aag ayaja? ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Condom Teat Jesús wüx tajaw teandeacndeacüw wüx aag ayaj, quiaj tatün manguiay nejiw: ―¿Ngo majneaj meyajcan aag ayaja? ");
INSERT INTO huvNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Cuane apmepiüngan ndot mejawan landilil Teat Naxey andüy tiül cielo niüng tajlüy nomba? ");
INSERT INTO huvNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Áagan Nangaj Espíritu ocueaj Teat Dios alndom müüch mapacaran; nganüy aaga cuerpo ngondom mambeol nicuajind. Meáwan poch leaw lanasaj icon quiaj Nangaj Espíritu üüch xic nendeac, ajcüw ayaj üüch mapacaran. ");
INSERT INTO huvNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Xique sajaw ngome meáwan icona iyariün sandeac ―aj nejiw. Tandeac atquiaj Teat Jesús cos lamajaw jane ngo mayar nej andeac, at lamajaw jane apmayac nej teowix monajiüt. ");
INSERT INTO huvNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Aton tasaj nejiw: ―Lanasaj icon, nejinguind ngondom miün niüng sajlüy mayar xepoch sitiül Xeteat Dios ngo mambeol nej miün ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ajan quiaj xeyayiw tiül minipilan nej tanotoj tiüt, lango mandüjpiw nej. ");
INSERT INTO huvNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Condom quiaj Teat Jesús tatün manguiay ajcüwa gajpiüp (12) minipilan nej: ―¿Jow icona, ngwüy indiüman meriümban mecueatiün xic atona? ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Quiaj tasaj nej Simón Pedro: ―Teat ¿jane alinop alndom nandüjpiün? Cos íquian quiaj indeac a poch leaw alndom müüch mapacaran meáwan nüt. ");
INSERT INTO huvNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Xicona lanayariün indeac, aton sajawan naleaing ique a Cristo lapiürang aliüc, aaga Nangaj Micual Teat Dios almapac ―aw. ");
INSERT INTO huvNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Quiaj tasaj nejiw Teat Jesús: ―¿Neol ngwüy, lanarriiüd icon gajpiüp (12) xenipilan? Pero naleaing sajaw nop tiül icona minipilan nej nimeech ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Teat Jesús tandeac aag ayaj wüx ombas Judas, aaga micual Simón Iscariote, cos lamajaw aaga Judas quiaj apmayac nej teowixaw monajiüt, masey nej naw tiül a gajpiüp (12) minipilan nej. ");
INSERT INTO huvNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Wüx ndoj aag ayaj, Teat Jesús tajüy maquiaach tíülan iüt Galilea; ngo mandiüm mamb tiül iüt Judea, cos ajcüwa monajiüt tiül judíos andiümüw mambiyaw nej. ");
INSERT INTO huvNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Laliüc matüch nangos nüt wüx nipilan judío arangüw namix nine nden leaaw omeajtsüw wüx tajlüyiw tiül wajchiüc mixejchiw nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Quiaj michiig nej Teat Jesús tasajüw nej: ―¿Neol tecǘlan ningüye? Quiür indüy tiül iüt Judea; atquiaj minipilan monlüyiw quiaj apndom majawüw leawa teamerang. ");
INSERT INTO huvNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Cos sitiül nop andiüm majaraw, ngondom marang leaw arang axotǘyan. Nganüy ique sitiül temendiüm mejaraw, ijüiquichay nómban majawüw meáwan nipilan leaw alndom merang ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ninguiaj ajüiquich nejiw michiig nej ngo mayariw nej andeac. ");
INSERT INTO huvNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Condom quiaj Teat Jesús tasaj nejiw: ―Xique nganaw matüch a nüt namb quiaj, icona ngünantanej nüt alndom meamban. ");
INSERT INTO huvNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Cos ngome apmajcüyiw majawüw icon nipilan; pero ajcüyiw majawüw xic, cos aleáingan sapaj ocueajiw wüx arangüw ngo majneaj. ");
INSERT INTO huvNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Quiüran icona ijawan a nangos nüt quiaj; xique ngo namb cos nganaw matüch namb ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ndoj masaj nejiw aag ayaj tacǘlan tiül iüt Galilea. ");
INSERT INTO huvNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Condom wüx laambüw michiig nej, ndoj Teat Jesús aton tamb Jerusalén tiül iüt Judea majaw aaga nangos nüt quiaj, axotǘyan cos ngo mandiüm majawüw nej nipilan. ");
INSERT INTO huvNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ajcüwa monajiüt tiül judíos tayambüw nej quiaj, tapiüngüw: ―¿Wül aaga naxey? ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","At tiül a nipilan aton tandeacndeacüw wüx nej. Altiül tapiüngüw: “Aaga naxey najneaj arang”; altiül tapiüngüw: “Ngo majneaj arang, xowüy awaiich nipilan”, awüw. ");
INSERT INTO huvNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Pero nejinguind ngo mandeac wüx ombas nej manguiayaran, cos imboloj mandüyiw monajiüt. ");
INSERT INTO huvNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Lapeay pinawan ajlüy a nangos nüt, quiaj Teat Jesús tajmel tiül nadam nangaj iüm, tapots aquiaach nipilan. ");
INSERT INTO huvNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Quiaj mbayatoj ajcüwa monajiüt, tapiüngüw: ―¿Nguineay tendüy aag ayaja, sitiül nej ngo mequiajchaya? ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Quiaj tasaj nejiw Teat Jesús: ―Leawa xique saquiaach, aag ayaj ngome xepoch; xique saquiaach leaw asaj xic aaga neech xic niün. ");
INSERT INTO huvNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Sitiül aljane naleaing andiüm marang leaw andiüm Teat Dios, nej apmajaw sitiül meáwan saquiaach quiaj naleaing ocueaj Teat Dios, tengwangwüy sandeácan. ");
INSERT INTO huvNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Jangantanej leaw andeac awǘnan tiül omeaats, aag ayaj teamayamb malomboocharan; nganüy jane ayamb nguineay alndom manderac najneaj wüx aaga neech nej miün, aag ayaj andeac naleaing, ngo mawaiich. ");
INSERT INTO huvNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’¿Neol ngwa, teat Moisés tüüch icon aaga poch netam merangana? Naleaing nejinguind tiül icona ngo marang atnej tapiüng. Jow nganüy, ¿neol tendiüman membiyan xique? ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Quiaj tasajüw nej nipilan: ―¡Lamaxom ic nimeech! ¿Neol, jane teamandiüm mambiy ique? ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Quiaj tasaj nejiw Teat Jesús: ―Xeyay tamb wüx imeajtsan wüx tarangas noic najneaj wüx nüt axoodaran. ");
INSERT INTO huvNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ipiüngan teat Moisés tüüch icon leaw ajlüyay arangüch, aaga circuncisión, masey ngome nejay tayac, cos nde tanomb lamarangüw mixejchiün. Nganüy icona itajcan circuncidar nop masey wüx nüt axoodaran. ");
INSERT INTO huvNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Atquiaj ajlüyay merangan masey wüx nüt axoodaran, cos ipiüngan netam merangan aaga poch tayac teat Moisés. Jow nganüy, ¿neol tejcüyiün mejawan xic cos samongoch iün andeow nop naxey wüx nüt axoodarana? ");
INSERT INTO huvNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Netam mejawan nop cuane arang, ndoj cas teyacan asoet. Nde meyacyacánan asoet jangantanej sitiül ngo mejawan naleaing cuane arang ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Condom acas nejiw leaw monaw quiaj tiül Jerusalén tapots andeacndeacüw wüx Teat Jesús, tapiüngüw: ―¿Neol ngome aag ayaj leaw teamayambüw mambiyawa? ");
INSERT INTO huvNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Nganüy joyaj tenguial aquiaach nipilan, nejinguind ngo mapal nej. ¿Ngwüy ijaca monajiüt lamapiüngüw naleaing aaga naxey quiaj, nej aaga lapiürang netam miüna? ");
INSERT INTO huvNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Icootsa ajawaats nguia naw aaga naxey quiaj, pero wüx aliüc a Cristo lapiürang aliüc nejinguind ngome apmajaw nguia naw ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Teat Jesús alquiaj teaquiaach nipilan tiül nadam nangaj iüm; tandeac napac, tapiüng: ―Icona ijawan jane xic; ijawan nguiane nawas. Naleaing xique ngo niün narang leaw sandíüman xique, tiünas cos Xeteat tüüch xic niün. Icona ngo mejawan jane nej, pero naleaing nej Teat Dios nej. ");
INSERT INTO huvNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Xique sajaw jane nej, cos nej tüüch xic niün ―aw. ");
INSERT INTO huvNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Quiaj tandiümüw masapüw nej; pero nejinguind ngo majntsop masap cos nganaw matüch a nüt ndeaam. ");
INSERT INTO huvNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Xeyay nipilan tayariw nej andeac, tapiüngüw: ―Aaga naxey quiaj naleaing nej áag lapiürang netam miün. ¿Mbich alndom majlüy alinop marang ateócan atnej nej lamaranga? ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Wüx ajcüwa fariseos tanguiayiw nipilan teandeacüw najneaj wüx Teat Jesús, quiaj nejiw maquiüjpüw ajcüwa montangtang miteaats tasajüw mongot monjiür aaga nadam nangaj iüm masapüw nej. ");
INSERT INTO huvNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Tenguialeámban aag ayaj, Teat Jesús tasaj nipilan: ―Áagan acas nüt sanacül ningüy naquiiüb icon, condom sanandilil sandüy niüng ajlüy aaga neech xic niün. ");
INSERT INTO huvNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Icona masey apmeyamban xic, naleaing ngome apmexoman, cos ngondom meamban niüng sanamb ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Quiaj ajcüwa monajiüt tapots andeacndeacüw nejeyéjan quiaj, tapiüngüw: ―¿Nguiane apiüng apmamba niüng ngondom maxomaatsa? ¿Ngwüy ijaca, apmamb maquiaach ajcüwa icootsa leaw tambüw tiül iüt Grecia, ngwüy tiül alinoic iüta; ngwüy naleaingue apmamb maquiaach pálwüx nipilana? ");
INSERT INTO huvNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Nguineay amb aag apiüng quiaj wüx tapiüng: “Apmeyamban xic pero ngome apmexoman xic, cos ngondom meamban niüng sanajlüy”? ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Aaga nüt wüx ndojndojay nangos nüt, wüxay chipiowaran quiaj, quiaj Teat Jesús witiüt, tandeac napac, tapiüng: ―Sitiül aljane nind anganeow yow, ich miün niüng sajlüy manganeow. ");
INSERT INTO huvNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Cos apiüng tiül Mipoch Teat Dios, jane ayar sandeac apmajlüy atnej teapacaw tiül omeaats nej aaga yow leaw üüch mapacaran ―aw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Pues aaga yow quiaj apiüng wüx Nangaj Espíritu ocueaj Teat Dios leaw apmüjndiw meáwan monyar andeac Teat Jesús. Aaga Nangaj Espíritu quiaj nganaw miün cos Teat Jesús nganaw mandilil andüy tiül cielo. ");
INSERT INTO huvNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Altiül nipilan wüx tanguiayiw aag ayaj tapiüngüw: ―Naleaing aaga naxey quiaj nejay aaga nendeac andeac Teat Dios leaw netam miün ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Altiül tapiüngüw: ―Aag ayaj a Cristo leawa Teat Dios tapiüng apmüüch miün mawün asoet nipilan ―awüw. Altiül tapiüngüw: ―¿Mbich tiül Galilea alndom maw quiaj aaga Cristo? ");
INSERT INTO huvNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Cos Mipoch Teat Dios apiüng aaga Cristo netam majlüy nop naw tiül acualaats mixejchiiüts David. Aton netam maw tiül cambaj Belén niüng tanomb wijquiat David ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Atquiaj tajlüy, palpálwüx tandeacüw wüx Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Altiül tandiümüw masapüw nej mamb tiül manchiüc, pero nejinguind ngo majntsop masap. ");
INSERT INTO huvNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Wüx ajcüwa mongot monjiür nadam nangaj iüm tandilileaw niüng ajlüyiw fariseos maquiiüb montangtang miteaats, quiaj tatüneran manguiayaranüw: ―¿Wül, neol ngo mequiüjpan miün a naxeye? ―ajowiw. ");
INSERT INTO huvNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Quiaj tapiüngüw a mongot monjiür nadam nangaj iüm: ―Nejinguind ngome áag mandeac atnej teamandeac aaga naxey ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Quiaj tasajüw nejiw a fariseos: ―¿Ngwüy, at icona aton lamawaiich icon? ");
INSERT INTO huvNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Neol, cuane ijawan, mbich aljane monajiüt tiül icootsa, ngwüy aljane tiül fariseos lamayariw andeac neje? ");
INSERT INTO huvNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ajcǘwan a nipilan leaw ngo majawüw wüx aaga poch tüünd Moisés, nejiw monyar andeac nej. Nejiw cuajparüw, apmambüw tiül ngo majneaj ―ajüw nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Alquiaj aaga Nicodemo, áag tamb majaw Teat Jesús noic ongwiiüts, cos nop nej fariseo aton. Quiaj tasaj nejiw: ");
INSERT INTO huvNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―¿Neol, nguiane tenguiayiün aag ayaja? Sajaw ngondom mayacaats asoet nop naxey sitiül ngome ombas mapajaats manguiayiiüts andeac, majawaats cuane arang ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Quiaj tasajüw nej: ―¿Ngwüy ique aton neriow Galilea? Iyamb, iteow tiül Mipoch Teat Dios, quiaj apmejaw ngome áag ajlüy nop nendeac andeac Teat Dios naw Galilea ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Condom quiaj tacueatiw, tajtsoriw anopnopoj. ");
INSERT INTO huvNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Condom Teat Jesús tamb andüy wüx mitiüc Olivos. ");
INSERT INTO huvNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Raw miün tiüt, quiaj tandilil andüy tiül nadam nangaj iüm. Xeyay nipilan tambüw majawüw nej; quiaj chetet tapots maquiaach nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Camüm tapeayiw quiaj mondüy wüx aaga poch tüünd Moisés, at ajcüwa fariseos. Aquiüjpüw mamb nop najtaj asapüw wüx naxey, mayacüw pinawan nipilan niüng ajlüy Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Quiaj tasajüw Teat Jesús: ―Teat, aaga najtaj cam ndeaan wüx naxey. ");
INSERT INTO huvNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Tiül aaga poch tüünd Moisés apiüng netam majlos mandeow ajcüwa montaj monrang atquiaj. Jowa ique, ¿cuane ipiünga? ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Aag ayaj asajǘwan majawüw cuane apmapiüng, nguineay maxomüw cuane wüx mayacüw nej asoet. Quiaj Teat Jesús mejquiet tiüt, tapots majenchjench tiüt owix nej. ");
INSERT INTO huvNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Cos tanaámb matüniw manguiayiw nej, quiaj lembet, tasaj nejiw: ―Jangantanej tiül icona ayaag ngo majiür nisoet, nej ich malox ombas aaga najtaj cam ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ndoj mejquiet tiüt alinomb, tandüy wüx majenchjench tiüt owix nej. ");
INSERT INTO huvNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Quiaj ajcüwa monajiüt wüx tanguiayiw aag ayaj tayajcüw ngo majneaj, taxinguiaw; tawüw quiaj nopnópan, ajan wüx leaw natang, ndójwüx meáwan nejiw tawüw quiaj. Néjan quiaj Teat Jesús tacül quiaj niüng ajlüy aaga najtaj. ");
INSERT INTO huvNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Quiaj Teat Jesús witiüt alinomb. Wüx tajaw néjan a najtaj aliün quiaj, quiaj tasaj: ―Müm najtaj, ¿wüliwe? ¿Neol, nejinguind lango mayacüw isoete? ―aj. ");
INSERT INTO huvNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Quiaj tasaj nej a najtaj: ―Ngwüy teat, nejinguind ―aj nej. Quiaj tasaj nej Teat Jesús: ―Ata xique aton ngo nayac isoet. Quiür, nde mendüy wüx merang nisoet ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Teat Jesús tandüy wüx maquiaach nipilan, tapiüng: ―Xique sajlüy ningüy wüx aaga iüt cam atnej ran. Jane andüüb xic ngome apmajüy tiül pojniün; cos xique sanarraj mitiüjtüw nejiw, aton apmapacüw meáwan nüt ―aw. ");
INSERT INTO huvNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Quiaj tasajüw nej ajcüwa fariseos: ―Ique indeácan aag ayaj; nguineay sanajawan sitiül naleaing, cos wüx nop andeac wǘxan ombas nej, aag ayaj ngo membeat ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Quiaj tasaj nejiw Teat Jesús: ―Masey sandeac wǘxan xique, naleaing leaw sandeac aag ayaj nembeat; cos sajaw nguiane ximiün tiünas, at sajaw nguiane sandüy sanamb. Pero icona ngo mejawan nguiane ximiün tiünas, átan ngo mejawan nguiane sandüy sanamb. ");
INSERT INTO huvNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Icona iyacan asoet atnej ajlüyay merangan ningüy wüx iüt. Xique ngo niün nayac asoet nejinguind. ");
INSERT INTO huvNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ndot xique nayac asoet aljane, sanarang naleaing atnej netam; cos ngome xíquian quiaj wüx sarang, saquiiüb wüx Xeteat, aaga neech xic niün. ");
INSERT INTO huvNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Tiül minawijquian apiüng sitiül ajlüy ijpüw monjaw mandeacüw nóiquian leawa tajawüw, netam mayarich andeacüw nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Nganüy sasaj icon xique nop nendeac leawa sajaw wüx xique, alinop nejay Xeteat aaga neech xic niün, nej aton apiüng wüx jane xique ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Condom quiaj tatüniw manguiayiw nej: ―¿Nguiane almajlüy miteate? ―ajüw nej. Quiaj tasaj nejiw Teat Jesús: ―Icona ngo mejawan jane xic, átan Xeteat ngo mejawan jane nej. Sitiül icona mejawan jane xic, at Xeteat aton apmejawan jane nej ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Atquiaj tapiüng Teat Jesús wüx tenguial aquiaach nipilan tiül nadam nangaj iüm niüng ajlüy iquial nichech. Nejinguind ngo masap nej cos nganaw matüch minüt nej ndeaam. ");
INSERT INTO huvNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Condom tasaj nejiw alinomb Teat Jesús: ―Xique sanamb, icona apmeyamban xic. Naleaing icona apmendeowan tiül isoetiün. Niüng sanamb icona ngondom meamban quiaj ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Quiaj ajcüwa monajiüt tiül judíos tandeacndeacüw wüx, tapiüngüw: ―¿Ngwüy, apmembiyay nejáyan quiaja, áag tapiüng ngondom mambaats niüng apmamba? ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Quiaj tasaj nejiw Teat Jesús: ―Icona neriowan wüx iüt; xique nawas cawüx tiül cielo. Icona ijiüran iniüngan ningüy; xique tiül cielo saniüng. ");
INSERT INTO huvNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Áag tasajas icon apmendeowan wüx isoetiün, cos ngo meyariün mepiüngan naleaing xiquiay aaga teanasaj icon wüx quiaj ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Condom quiaj tatüniw nej manguiayiw: ―¿Neol, jane ique? ―ajüw nej. Quiaj tasaj nejiw Teat Jesús: ―Landoj lanasaj icon jane xic. ");
INSERT INTO huvNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Alndom nasaj icon xeyay cuajantanej, at alndom najüiquich nguineay irangan; pero ngo metam narang, cos sandeac leaw asaj xic aaga neech xic niün. Aag ayaj sasaj meáwan nipilan cos sajaw aag ayaj naleaing ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Naleaing nejiw nómban ngo maxomüw omeajtsüw nguineay Teat Jesús teamasaj nejiw wüx Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Áag tasaj nejiw Teat Jesús: ―Wüx landoj mexainguiün meyacan cawüx aaga Teat Naxey, quiaj apmejawan xique. Ngo narang nicuajind xiquiáyan quiaj, xique sandeac leaw Teat Dios asaj xic nandeac. ");
INSERT INTO huvNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Aaga neech xic niün tanaámb aquiiüb xic; nej nómban ngo macueat xic cos xique meáwan nüt sarang leaw nej andiüm ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Wüx tandeac atquiaj xeyay nipilan tayariw nej andeac. ");
INSERT INTO huvNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Condom quiaj Teat Jesús tasaj ajcüwa nipilan judío leawa lamayariw andeac nej: ―Sitiül icona tanaámb meyacan wüx imeajtsan leaw sasaj icon, apmejlüyiün tiül xenipilan. ");
INSERT INTO huvNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Quiaj apmejawan cuane naleaing; ndoj aaga naleaing quiaj apmawün icon wüx isotiün ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Quiaj tasajüw nej: ―Xicona áagan Abraham xexejchiün, ngome áag sarangan mimos aljane. Jow nganüy ¿neol tepiüng apmewün xicon wüxe? ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Quiaj tasaj nejiw Teat Jesús: ―Naleaing naleaing sasaj icon, meáwan nipilan leaw arang nisoet ajlüy atnej mos ocueaj nisoet. ");
INSERT INTO huvNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Nop mos ngondom mateoraw tiül nacualaran cos aag ayaj acas nüt acül quiaj. Nganüy nop nacualaran meáwan nüt acül quiaj. ");
INSERT INTO huvNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Sitiül Micual Teat Dios apmawün icon wüx, naleaing apmeriowan wüx nómban. ");
INSERT INTO huvNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Xique lanajaw icona mixejchiün Abraham; pero altiül indiüman membiyan xic cos ngo mind meyariün leawa sasaj icon. ");
INSERT INTO huvNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Xique sandeac leawa sajaw niüng ajlüy Xeteat; nganüy icona irangan leawa inguiayiün asaj icon miteatiün ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Quiaj tasajüw nej: ―Néjan quiaj Abraham xeteatiün ―awüw. Quiaj tasaj nejiw Teat Jesús: ―Sitiülme naleaing micual icon Abraham, neol ngo merangan atnej tarang. ");
INSERT INTO huvNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Nganüy icona indiüman membiyan xic masey teanasaj icon naleaing leaw Teat Dios asaj xic. Mixejchiün Abraham ngome atquiaj tarang. ");
INSERT INTO huvNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Icona indüjpiün wüx atnej tarangüw miteatiün ―aj nejiw. Quiaj tasajüw nej: ―Xicona ngo macual xicon pálwüx; sajiüran nop xeteatiün, aag ayaj Teat Dios ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Quiaj tasaj nejiw Teat Jesús: ―Sitiül naleaing Teat Dios miteatiün, apmendiüman xic, cos xique ximiün niüng ajlüy Teat Dios tiünas. Xique ngo níünan, nej tüüch xic niün. ");
INSERT INTO huvNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Neol ngondom mexoman imeajtsan wüx leawa sandeaca? Cos ngo mendiüman menguiayiün meyariün leawa teanasaj icon. ");
INSERT INTO huvNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Icona lamiteatiün nimeech cos ajlüyay indiüman merangan leaw andiüm nej. Aaga nimeech quiaj nop nej nembiy nipilan ajlüyay. Nómban ngo marang leaw naleaing, átan ngo mapiüng leaw naleaing. Meáwan andeac awaiich, cos nej minatang newaiich, aton nej miteat monwaiich. ");
INSERT INTO huvNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Nganüy a xique sandeac leaw naleaing, áag ngo meyariün. ");
INSERT INTO huvNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Jane tiül icona alndom majüiquich sitiül xique sajiür nisoete? Sitiül xique teanasaj icon leaw naleaing, ¿neol ngo meyariün sandeaca? ");
INSERT INTO huvNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Jane altiül minipilan Teat Dios, Mipoch Teat Dios andiüm manguiay. Nganüy icona cos ngome ocueaj icon Teat Dios, áag ngo mendiüman menguiayiün andeac nej ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Condom quiaj ajcüwa monajiüt tiül nipilan judío tasajüw nej: ―¿Neol ngwa, naleaing tapiüngasan, ique irang atnej nop naw Samaria? ¡Aton lamaxom ic nimeech! ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Quiaj tasaj nejiw Teat Jesús: ―Xique ngo majlüy wüx ximbas nimeech. Sarang leaw andiüm Xeteat, nganüy icona indeacan ngo majneaj wüx ximbas. ");
INSERT INTO huvNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Xique ngo nayamb nerangrangüy wüx majaw xic nipilan. Ajlüy nop andiüm majaw narangüch casa. Nej apmajüiquich asoeteran. ");
INSERT INTO huvNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Naleaing sasaj icon, jane apmayar sandeac mayac wüx omeaats ngome apmandeow nómban ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Condom quiaj tasajüw nej ajcüwa nipilan: ―Nganüy mbich lanajawan alwüx imbas nimeech. Cos teat Abraham at meáwan mondeac andeac Teat Dios tandeowüw; nganüy ique ipiüng: “Jane ayar sandeac leaw xic sapiüng, nej nómban ngome apmandeow”, iraw. ");
INSERT INTO huvNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Neol, jowa ique, alwüx itam ijlüy, ngo matnej xexejchiün teat Abrahama? Cos nej tandeow, aton meáwan mondeac andeac Teat Dios tandeowüw. ¿Jowa ique, jane ic? ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Quiaj tasaj nejiw Teat Jesús: ―Sitiül ndot xiquiáyan quiaj teasalombojchay, aag ayaj ngo membeat nicuajind. Pero cos Xeteat Dios, áaga ipiüngan Midiosan, nej teamandeac najneaj wüx xique. ");
INSERT INTO huvNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Icona ngo mejawan jane nej; xique sajaw jane. Sitiül napiüng ngo najaw, aag ayaj tenguial sawaiich atnej icona teamerangan. Nganüy xique naleaing sajaw jane nej, aton sarang leaw apiüng. ");
INSERT INTO huvNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Mixejchiün Abraham tapac omeaats wüx tajaw saliüc ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Condom quiaj tasajüw nej ajcüwa monajiüt tiül judíos: ―Ique nganaw mejiür ic miow gajpowüw (50) mineat, ¿nguineay ipiüng tejaw teat Abrahama? ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Quiaj tasaj nejiw Teat Jesús: ―Naleaing naleaing sasaj icon, wüx nganaw majlüy Abraham, xique salnajlüy ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Quiaj taxainguiw piedra maloxiw nej; pero nej texotüy, taw tiül nadam nangaj iüm, tamong amb pinawan nejiw, quiaj tamb. ");
INSERT INTO huvNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Teat Jesús wüx tamong tiül tiiüd, tajaw nop naxey nesomb nde wijquiaw. ");
INSERT INTO huvNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Quiaj minipilan nej Teat Jesús tatüniw nej manguiayiw: ―Rabí ¿neol wijquiat nesomb aaga naxey quiaja? ¿Jane tajiür nisoete, miteat neje ngwüy mimüm neje, ngwüy nejay ajiür nisoete? ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Teat Jesús tasaj nejiw: ―Ngome cos nej nerang nisoet, taton ngome miteat nej mimüm nej. Tajlüy atquiaj cos Teat Dios atquiaj apmajüiquich leaw alndom marang. ");
INSERT INTO huvNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Wǘxan aliün tiüt nüt netam narang minajiüt aaga neech xic niün, cos aliüc apojniüm, quiaj nejinguind langondom marang najiüt. ");
INSERT INTO huvNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Wǘxan saliün ningüy wüx iüt, sajlüy atnej ran ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ndójan mapiüng aag ayaj, quiaj tateonts tiüt onts ombeay nej, tarang ndeor. Condom tayac wüx oniiüg aaga nesomb quiaj. ");
INSERT INTO huvNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Quiaj tasaj: ―Quiür ijants iniiüg tiül oniiüg yow nenüt Siloé ―aj. Aaga poch Siloé quiaj apiüng wüx leaw üünd mamb. Quiaj aaga nesomb tamb mapej oniiüg; camüm mandilil lajneaj, larraw oniiüg. ");
INSERT INTO huvNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Condom quiaj meáwan monlüy niüng ajlüy aniüng nej, at meáwan leaw tajawüw nej nesomb tapiüngüw: ―¿Neol, ngome aag ayaj ajlüyay chetem, metüneaye? ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Altiül tapiüngüw: ―Nejay ―awüw. Altiül tapiüngüw: ―Ngome áag, masey ajüic atnej ―awüw. Quiaj tasaj nejiw aaga naxey: ―Xiquiay ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Condom tatüniw nej manguiayiw: ―¿Nguineay tejneaja, rat iniiüga? ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Quiaj tasaj nejiw: ―Aaga naxey nenüt Jesús tarang ndeor mayac wüx xiniiüg, condom tasaj xic: “Quiür tiül Siloé, ipej iniiüg quiaj”, aj xic. Quiaj tambas. Wüx tapejiüs xiniiüg, quiaj rat sajaw ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Quiaj tatüniw nej manguiayiw: ―¿Nguiane almajlüy aaga naxey quiaja? ―awüw. Quiaj tapiüng: ―Ngo najaw ―aw. ");
INSERT INTO huvNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Condom quiaj taquiüjpüw mamb aaga naxey lamong misomb andüy niüng ajlüyiw a fariseos. ");
INSERT INTO huvNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Aaga nüt wüx Teat Jesús tarang ndeor müüch majneaj aaga somb, aag ayaj wüx nüt axoodaran. ");
INSERT INTO huvNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Quiaj ajcüwa fariseos tandüyiw wüx matüniw manguiayiw aaga naxey nguineay tajneaj oniiüg. Quiaj tasaj nejiw: ―Tayac wüx xiniiüg ndeor. Condom tapejiüs xiniiüg, nganüy saxom najaw ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Altiül fariseos tapiüngüw: ―Aaga naxey quiaj ngome ocueaj Teat Dios, cos arang cuajantanej wüx nüt axoodaran ―awüw. Altiül tapiüngüw: ―Aaga naxey ngome nop nerang ngo majneaj, cos nop nerang ngo majneaj ngondom marang meáwan najneaj leaw nej arang quiaj ―awüw. Atquiaj nejiw ngo mandeacüw nóiquian. ");
INSERT INTO huvNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Condom tandüyiw wüx matüniw manguiayiw aaga naxey lamong misomb quiaj, tasajüw: ―Jowa ique ¿cuane ipiüng, jane nej aaga naxey ipiüng netaag majneaj iniiüga? ―ajüw. Quiaj tasaj nejiw: ―Xique sapiüng nej nop nendeac andeac Teat Dios ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Naleaing ajcüwa monajiüt tiül judíos ngo mandiümüw mayariw andeac aaga naxey quiaj; apiüngüw ngome naleaing tesomb, nganüy lajneaj. Quiaj tapajüw miteat nej, ");
INSERT INTO huvNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","tatüniw manguiayiw: ―¿Aag agüy micualana, ipiüngan nesomb wijquiata? Jow nganüy, ¿nguineay rat oniiüga? ―ajüw. ");
INSERT INTO huvNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Quiaj miteat nej tapiüngüw: ―Naleaing nej xecualan nde wijquiaw nesomb. ");
INSERT INTO huvNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Pero ngo najawan nguineay tajneaj, jane neech nej ram oniiüg. Itüniün menguiayiün nejay; nej latang, alndom masaj icon nguineay tajlüy ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Atquiaj tapiüngüw miteat nej cos timboloj mandüyiw ajcüwa monajiüt, cos ajcüwa monajiüt lamandeacüw sitiül aljane mapiüng naleaing Teat Jesús nej aaga Cristo lapiürang aliüc, nómban apmajwan tiül a sinagoga. ");
INSERT INTO huvNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Áag tapiüngüw miteat nej: “Itüniün menguiayiün nejay cos nej latang”, awüw. ");
INSERT INTO huvNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Condom monajiüt tandüyiw wüx mapajüw masajüw aaga naxey lamong misomb quiaj, tasajüw: ―Nganüy mbich isaj xicon naleaing, nde mewaiich; cos xicona sajawan Teat Dios netaag ic majneaj; aaga naxey quiaj nop nejiür nisoet, ngondom mataag ic majneaj ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Quiaj tasaj nejiw: ―Xique ngo najaw sitiül nej nop nejiür nisoet. Leaw xique sajaw tajlüyiüs nesombas, nganüy larraw xiniiüg ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Tandüyiw wüx matüniw manguiayiw: ―¿Nguineay tarang wüx imbasa? ¿Nguineay tüüch ram iniiüga? ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Quiaj tasaj nejiw: ―Lanasaj icon, pero naleaing icona ngo mendiüman menguiayiün. ¿Neol nganüy tendiüman napiüng alinomba? ¿Ngwüy, icona aton indiüman mendüjpiüna? ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Quiaj tajcüyiw, taliquiaw nej, tasajüw: ―Ique minipilan aaga naxey quiaj, nganüy xicona mbich minipilan xicon teat Moisés. ");
INSERT INTO huvNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Xicona sajawan Teat Dios tandeac aweaag teat Moisés; nganüy aaga naxey quiaj ngo najawan nguia naw ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Quiaj tasaj nejiw aaga naxey: ―¿Nguineay aag ayaja? Icona ngo mejawan nguia naw, nganüy a xique sajaw lamüüch ram xiniiüg, aag ayaj xeyay najneajay. ");
INSERT INTO huvNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ajawaats Teat Dios ngo manguiay andeac nop nejiür nisoet; nej ambeol leaw monyamb nej, monrang leaw nej andiüm. ");
INSERT INTO huvNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ngome áag ajlüy aljane müüch ram oniiüg nop nesomb nde wijquiaw. ");
INSERT INTO huvNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Sitiül aaga naxey quiaj ngome Teat Dios neech nej miün, ngondom marang nicuajind ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Quiaj tasajüw nej: ―Cuane ique, cos ique wüx wijquiatear lamejiür xeyay nisoet. Jow nganüy indiüm mequiaach xicon ―ajüw nej. Quiaj tawüniw nej tiül a sinagoga. ");
INSERT INTO huvNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Teat Jesús tanguiay lajwan tiül sinagoga aaga naxey quiaj. Condom wüx taxom, quiaj tasaj: ―¿Jowa ique, iyar andeac Micual Teat Diosa? ―aj. ");
INSERT INTO huvNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Quiaj tasaj nej aaga naxey: ―Teat, isaj xic jane, para alndom nayar andeac nej ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Quiaj tasaj nej Teat Jesús: ―Lamejaw, cos nganüy nejay tenguial indeac anaag ―aj. ");
INSERT INTO huvNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Condom quiaj aaga naxey taquieel micos nej tiüt teombas Teat Jesús, tasaj: ―Sayar indeac Teat ―aj. ");
INSERT INTO huvNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Quiaj Teat Jesús tapiüng: ―Xique tiünas wüx aaga iüt cam najaw wüx asoeteran. Jane nesomb apndom maxom majaw; pero jane apíüngan ajaw apmajlüy atnej nesomb ―aw. ");
INSERT INTO huvNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Condom altiül fariseos leaw aliw niüng ajlüy nej, wüx tanguiayiw aag ayaj, quiaj tasajüw nej: ―¿Ngwüy ipiüng xicona nesombasan atona? ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Quiaj tasaj nejiw Teat Jesús: ―Sitiül ndot icona nersomban, ngome apmejiüran nisoet. Pero cos ipiüngan ijawan meáwan, atquiaj apmecülíünan tiül isoetiün ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Aton Teat Jesús tapiüng: ―Naleaing naleaing sasaj icon, jane ngo majmel amb teombeay micorrül sap, pero apmajmel amb wüx otüeng corrül, aag ayaj nop need, nop nerang ngo majneaj. ");
INSERT INTO huvNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Nganüy nop nejiür sap ajmel amb teombeay corrül. ");
INSERT INTO huvNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Aaga najlüy wüx micorrül sap apmaleaaig ombeay corrül majmel nejiür sap mawün misap nej. Ajcüwa sap anguiayiw nej andeac, aton apaj minüt misap nej mawün tiül corrül. ");
INSERT INTO huvNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Wüx lamawün misap nej, condom apmamong ombas, misap nej apmandüjpiw nej, cos anguiayiw nej andeac. ");
INSERT INTO huvNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Nejiw ngome apmandüjpiw nop pálwüx, apmecuiürrüw cos ngo manguiayiw andeac pálwüx nipilan ―aw. ");
INSERT INTO huvNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Aaga poch quiaj tasaj nejiw Teat Jesús, pero nejiw ngo majawüw cuane wüx apiüng. ");
INSERT INTO huvNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Condom Teat Jesús tandüy wüx masaj nejiw, tapiüng: ―Naleaing naleaing sasaj icon: Xique aaga ombeay micorrül sap. ");
INSERT INTO huvNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Meáwan leawa ombas miünüw, moneed nejiw, monrang ngo majneaj. Naleaing ajcüwa sap ngo manguiayiw andeacüw, ngo mandüjpiw nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Xique atnej ombeay corrül; jane apmajmel amb niüng sajlüy apmaw wüx asoet nej. Nej apmajmel tiül micorrül nej, aton apmaw maxom nateaic soex. ");
INSERT INTO huvNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’Nop need aliüc ǘpan maneed, mambiy, mandrooch ombas. Nganüy xique xiün nawün icon wüx isoetiün para mapac imeajtsan meáwan nüt. ");
INSERT INTO huvNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Xique sarang atnej nop najneaj nejiür sap, cos nop najneaj nejiür sap apmandeow mawün misap nej wüx naél. ");
INSERT INTO huvNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Nganüy nop nangüyaran ngo maneay nej a sap, wüx apmajaw aliüc sampüy acueátan a sap apmecuiür, cos ngo maneay a sap. Condom aaga sampüy apmatsamb a sap, apmüüch sajrriüm. ");
INSERT INTO huvNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Aaga naxey quiaj acuiür cos nangüyaran, ngo mapiüng wüx leaw alndom marang nejiw a sap. ");
INSERT INTO huvNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","’Xique aaga najneaj nejiür sap. Sajaw jane nejiw xesap, ata nejiw ajawüw jane xic. ");
INSERT INTO huvNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Atquiaj Teat Dios ajaw jane xic, aton xique sajaw jane nej. Xique sanandeow para nawün wüx xesap. ");
INSERT INTO huvNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Átan salnajiür alinoic ajlüy sap tiül alinoic corrül, netam naquiüjpüw miün aton. Nejiw apmanguiayiw sandeac; condom apcanchiümoj majlüyiw noic ajlüy, nop nejiür nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’Xeteat Dios xeyay andiüm xic, cos saneyacüy teowix nipilan mambiyaw xic. Condom sanapac alinomb xiquiáyan quiaj. ");
INSERT INTO huvNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Nejinguind ngondom mambiy xic sitiül ngo nandiüm, cos xique alndom nandeow, aton alndom napac alinomb xiquiáyan quiaj, nicuajind ngondom mapal xic. Cos aag ayaj asaj xic Xeteat Dios narang ―aw. ");
INSERT INTO huvNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Camüm manguiayiw aag ayaj ajcüwa monajiüt tiül nipilan judío, quiaj tapots andeacndeacüw wüx alinomb. ");
INSERT INTO huvNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Xeyay tiül nejiw tapiüngüw: ―Alwüx ombas nej nimeech, lamichach. ¿Neol tapots menguiayiün andeaca? ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Nganüy altiül tapiüngüw: ―Aaga poch quiaj ngondom mandeac nop naxey alwüx ombas nej nimeech. ¿Mbich alndom nop nimeech müüch ram oniiüg nop somba? ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Wüx nüt aquind tearangüw nangos nüt tiül nadam nangaj iüm tiül Jerusalén. Aaga nangos nüt quiaj arangüw cos leaaw omeajtsüw wüx tatajcüch majneaj alinomb aaga nadam nangaj iüm quiaj. ");
INSERT INTO huvNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Tiül aaga nüt quiaj Teat Jesús alquiaj tiül nadam nangaj iüm; aleamb quiaj tiül noic nden apiürang wüx Portal de Salomón. ");
INSERT INTO huvNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Quiaj ajcüwa monajiüt tiül nipilan judío tayeyiw nej tiüt, tasajüw nej: ―¿Ngow sanajawan naleaing jane ique? Sitiül ique aaga Cristo lapiürang aliüc, isaj xicon aleáingan ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Quiaj tasaj nejiw Teat Jesús: ―Landoj lanasaj icon, pero icona ngo meyariün sandeac. Meáwan leaw asaj xic Xeteat Dios, aag ayaj teanarang. Meáwan leaw sarang quiaj, ajüiquich aleáingan jane xic. ");
INSERT INTO huvNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Naleaing icona ngo meyariün sandeac cos ngo mejlüyiün tiül xesap, atnej lanasaj icon. ");
INSERT INTO huvNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Xesap anguiayiw sandeac, andüjpiw xic; xique sajaw jane nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Xique süjchiw mapacüw meáwan nüt, ngome apndrom ombasüw; nejinguind ngondom mawün nejiw tiül xiwix. ");
INSERT INTO huvNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Xeteat Dios neech xic, nej natang wüx meáwan leaw almajlüy; pares nejinguind ngondom mawün nejiw teowix nej. ");
INSERT INTO huvNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Xique saquiiüb Xeteat Dios, nop nej sajlüyiün ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Condom quiaj ajcüwa monajiüt tandüyiw wüx maxainguiw piedras maloxiw nej. ");
INSERT INTO huvNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Quiaj tasaj nejiw Teat Jesús: ―Xeteat Dios lamambeol xic narang xeyay cuajantanej najneaj mejawan. Jow nganüy ¿ngün tiül aaga najneaj sarang quiaj indiüman meloxiün xic wüxe? ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Quiaj tasajüw nej: ―Ngome sanaloxiün ic cos alngün najneaj irang, sanaloxiün cos ertsoj minüt Teat Dios. Ique nipilánan ic, nganüy temepiüng Dios ic ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Condom quiaj tasaj nejiw Teat Jesús: ―¿Neol ngo meteowan tiül Mipoch Teat Dios? niüng apiüng: “Icona ijlüyiün at icon dios”, aw. ");
INSERT INTO huvNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ajawaats meáwan leaw apiüng tiül Mipoch Teat Dios ngondom mapiürang ngo maleaing andeac. Naleaing Teat Dios apiüng atnej dios nejiw leaw arangüw minajiüt nej masajüw nipilan leaw nej asaj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","¿Nguineay alndom mepiüngan lanatsoj minüt Teat Dios aag tapiüngas xique Micual Teat Dios xic, sitiül nejay Teat Dios tawün xic müüch xic niün narang minajiüt neje? ");
INSERT INTO huvNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Sitiül ngome teanarang cuajantanej najneaj leaw Xeteat üüch xic narang, nde meyariün sandeac. ");
INSERT INTO huvNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Pares ngo nacueat narang, masey icona ngo meyariün sandeac, pero sandiüm meyariün leawa teanarang. Quiaj alndom mejawan naleaing Xeteat Dios ambeol xic, cos ajlüy tiül xique, ata xique sajlüy tiül nej ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Quiaj tandiümüw alinomb masapüw nej; pero Teat Jesús tsajmbiüt teowixaw nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Condom Teat Jesús tandüy nonüt necamb lam Jordán niüng Juan ninguinüt tüüch yow nipilan. Tacül quiaj. ");
INSERT INTO huvNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Tambüw majawüw nej quiaj xeyay nipilan, tapiüngüw: ―Naleaing, masey teat Juan ngo marang nicuajind ateócan majaraw, pero nganüy ajüic meáwan leaw tapiüng wüx aaga naxey cam naleaing ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Quiájan xeyay nipilan tayariw andeac Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Tajlüy nop naxey niün andeow, nenüt Lázaro, michiig Marta maquiiüb María, nawüw tiül cambaj Betania. ");
INSERT INTO huvNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Aaga María micoj Lázaro quiaj, nej apmateng najmboc angan aceite wüx oleaj Teat Jesús alinoic nüt, condom apmajond naag miondeats omal nej. ");
INSERT INTO huvNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Nganüy ajcüwa micoj Lázaro quiaj, wüx tajawüw michijquiaw nejiw laxeyay iün andeow, quiaj tüjchiw mamb masoic Teat Jesús: ―Teat, aaga teat naxey xowüy ijneaj anaag laxeyay iün andeow ―ajow. ");
INSERT INTO huvNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Wüx tanguiay aag ayaj Teat Jesús, quiaj tapiüng: ―Aaga monandeow quiaj ngome apmambiy nej nómban. Taxom nej cos atquiaj alndom majüiquicharan mimonajneaj Teat Dios; aton cos atquiaj alndom majüiquich najneajay arang Micual Teat Dios ―aw. ");
INSERT INTO huvNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Masey Teat Jesús xeyay ajneaj aweaag müm Marta, aton müm María michiig nej, at teat Lázaro; ");
INSERT INTO huvNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","pero wüx tanguiay iün andeow a Lázaro, ngo mamb majaw, tacǘlan mamong ic nüt. ");
INSERT INTO huvNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Condom wüx lamong ic nüt, quiaj tasaj minipilan nej: ―Tabaats alinomb andüyiiüts tiül Judea ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Quiaj tasajüw nej minipilan nej: ―Rabí, ngome lamajiür xeyay nüt wüx ajcüwa nipilan moncül quiaj tandiümüw maloxiw ic, nganüy ¿indiüm meamb quiaj alinomba? ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Quiaj tasaj nejiw Teat Jesús: ―Ajawaats arraj nüt ajiür gajpic (12) ores. Sitiül nop apmajüy tiül arraj nüt ngome apmajtoch, cos aaga ran quiaj ambeol nej maxom majaw. ");
INSERT INTO huvNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Pero sitiül nop ajüy ongwiiüts, alndom majtoch, cos nej ngo majiür ran ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Condom tasaj nejiw: ―Miamigojaats Lázaro lameay, nganüy sanamb napacüüch ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Quiaj tasajüw nej minipilan nej: ―Teat, sitiül lameay, aag ayaj ajüic teaámb ajneaj ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Teat Jesús tandeac atquiaj cos ajaw Lázaro landeow; pero minipilan nej apiüngüw naleaing almameay. ");
INSERT INTO huvNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Condom quiaj Teat Jesús tasaj nejiw aleáingan: ―Lázaro landeow. ");
INSERT INTO huvNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Najneaj ngo najlüy quiaj wüx tandeow, cos nganüy icona apmejawan leawa sanarang, quiaj alndom meyariün sandeac. Nganüy tabaats majawaats ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Condom quiaj teat Tomás, aaga nasoic Cuüch, tasaj alacas minipilan Teat Jesús: ―Tabaats icoots aton mandeowaats maquiüjpaats Teat Jesús ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Wüx tapeay quiaj Teat Jesús, Lázaro lamiüraad lamatüch peic nüt. ");
INSERT INTO huvNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Aaga cambaj Betania ngome miünquiaj, ajlüy ijquiaw kilómetro alwüx pinawan naw Jerusalén. ");
INSERT INTO huvNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Xeyay nipilan monaw Jerusalén lapeayiw quiaj majawüw müm Marta maquiiüb müm María, para mawüywüyiw nejiw majneaj omeajtsüw, cos tandeow michijquiaw nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Müm Marta wüx tanguiay aliüc Teat Jesús, quiaj tamb mangoch; nganüy müm María tacǘlan tinden. ");
INSERT INTO huvNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Quiaj müm Marta tasaj Teat Jesús: ―Teat, sitiül ique mejlüy ningüy sapiüng xechiig ngo mandeow. ");
INSERT INTO huvNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","At nganüy aton sajaw Teat Dios apmarang cuajantanej leaw apmetün ocueaj ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Quiaj tasaj nej Teat Jesús: ―Michiig apmapac alinomb müm ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Quiaj müm Marta tasaj nej: ―Naleaing teat, sajaw apmapac alinoic nüt wüx Teat Dios apmapacüüch meáwan mondeow ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Condom quiaj tasaj nej Teat Jesús: ―Xique nepacüüch mondeow, xique neech mapacaran. Jane ayar sandeac masey mandeow apmapac alinomb. ");
INSERT INTO huvNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Meáwan leaw almapac nganüy, sitiül ayar sandeac ngome apmandeow nómban. ¿Cuane ipiüng müm, naleaingue aag ayaja? ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Quiaj tasaj nej müm Marta: ―Sajaw naleaing ipiüng Teat, ique aaga Cristo leaw lapiürang aliüc, Micual Teat Dios ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ndoj mapiüng aag ayaj müm Marta, quiaj tamb mapaj müm María, tandex teolaag: ―Lapeay a Maestro, atün ic meamb mejaw ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Müm María camüm manguiay ayaj, quiaj tamb najen majaw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Teat Jesús nganaw majmel tiül cambaj, alíünan niüng tangoch nej müm Marta. ");
INSERT INTO huvNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ajcüwa nipilan leaw aliw tiül nden maquiüjpüw müm María mawüywüyiw nej müjchiw mapac omeaats, wüx tajawüw amb acuiür tandüjpiw mamb cos apiüngüw nej laámb apmajiünts niüng ajlüy oxiüt. ");
INSERT INTO huvNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Müm María camüm mapeay niüng ajlüy Teat Jesús, quiaj taquieel tiüt micos nej, tapiüng: ―Teat, sitiül ndot mejlüy ningüy ngo mandeow xechiig ―aw. ");
INSERT INTO huvNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Wüx Teat Jesús tajaw ajiünts müm María, at ajcüwa mondüüb nej mamb aton, quiaj tajngot amix omeaats. ");
INSERT INTO huvNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Tatün manguiay nejiw: ―¿Nguiane temiütana? ―aj nejiw. Quiaj tasajüw: ―Teat, tabaats mejaw ―ajüw. ");
INSERT INTO huvNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Teat Jesús tajiünts. ");
INSERT INTO huvNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Quiaj tapiüngüw ajcüwa nipilan quiaj: ―Ijawan, xeyay andiüm a Lázaro ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Altiül tapiüngüw: ―Neol ngwüy, tüüch ram oniiüg a somb, jow nganüy, ¿neol ngo mambeol a Lázaro mapac, ngo mandeowa? ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Teat Jesús tamix omeaats alinomb, quiaj tamb matüch aaga oxiüt. Aaga oxiüt quiaj noic warraj tiüc narangüch, nepal wüx noic nadam piedra. ");
INSERT INTO huvNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Quiaj tasaj nejiw Teat Jesús: ―Iwüniün a piedra apal oxiüt quiaj ―aj nejiw. Quiaj tasaj nej müm Marta, micoj aaga nandeow quiaj: ―Teat, nganüy lango majneaj, lajmboc, cos lamajiür peic nüt tatow andeow ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Teat Jesús tasaj nej: ―¿Neol, ngome tasajas ic sitiül apmeyar sandeac apmejaw noic najneajay leaw Teat Dios apmaranga? ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Condom quiaj tawüniw a piedra. Quiaj Teat Jesús taxaing omal majaw cawüx, tasaj Teat Dios: ―Teat, süüch ic gracias Teat, cos sajaw inguiay sandeac. ");
INSERT INTO huvNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Xique sajaw meáwan nüt teamenguiay sandeac. Nganüy sasaj ic aag ayaj manguiayiw ajcüwa nipilan cam, majawüw naleaing ique teaach xic niün ―aj. ");
INSERT INTO huvNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ndoj mapiüng aag ayaj, quiaj tendeac napac: ―¡Lázaro, mac, iriow ninguiaj! ―aj. ");
INSERT INTO huvNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Quiaj aaga nandeow quiaj taw, tan ajlüy awincharan ombas, naw wüx omal andüy wüx oleaj. Quiaj tasaj nejiw Teat Jesús: ―Ipüjliün ombas nej para majneaj majüy ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ndoj aag ayaj, xeyayiw nipilan judío leaw tambüw maniüngüw müm María tayariw andeac Teat Jesús, cos ajawayej nguineay tarang. ");
INSERT INTO huvNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Pero altiül aleáingan tambüw majawüw ajcüwa fariseos. Tapots masajüw meáwan nguineay lamarang Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Condom quiaj ajcüwa fariseos, at montangtang miteaats, tapajüw monajiüt tiül nipilan judío canchiütoj mandeacüw, tapiüngüw: ―¿Cuane apmarangaatsa? Cos aaga naxey quiaj xeyay cuajantanej teamarang. ");
INSERT INTO huvNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Sitiül müjchiiüts majlǘyan marang leaw andiüm, meáwan nipilan apmayariw andeac nej; ndoj ajcüwa monajiüt monaw Roma apmandrojchiw ombas aaga nadam nangaj iüm ocueajiiüts; apmanojtiw miiütaats aton ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Nop nejiw nenüt Caifás, minatang miteaats nej tiül aaga neat quiaj, tasaj nejiw: ―Icona ngo mejawan nicuajind. ");
INSERT INTO huvNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Neol ngo leaam imeajtsan mepiüngan más najneaj mandeow nop naxey ingow ndroj ombas cambaj Israel ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Aaga Caifás tandeac aag ayaj ngome wüx omeaats. Nej minatang miteaats tiül aaga neat quiaj, pares Teat Dios tüüch nej mapiüng nguineay Teat Jesús apmandeow mawün wüx cambaj Israel. ");
INSERT INTO huvNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Y ngome áagan nipilan judío, at apmawün wüx asoetiw meáwan micual Teat Dios leaw ajlüyiw wüx aaga iüt cam. Atquiaj alndom majlüyiw nóiquian. ");
INSERT INTO huvNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ajan wüx aaga nüt quiaj ajcüwa monajiüt tiül judíos tapots mayambüw nguineay mambiyaw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Nde quiaj Teat Jesús lango mejüiquichay niüng ajlüy ajcüwa monajiüt tiül nipilan judío; taw tiül Judea, tamb andüy tiül cambaj Efraín, noic cambaj niüng ajlüy wajchiüc. Quiaj tacül aquiiüb minipilan nej. ");
INSERT INTO huvNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Laliüc matüch nangos nüt pascua, aaga nadam nangos nüt ocueajiw nipilan judío. Xeyay nipilan monaw tiültiül nine cambaj laambüw Jerusalén marangüw leaw mbójan marangüw wüx ajantsaranüw majlüyiw nerixixay teombas Teat Dios. Cos andiümüw marangüw aag ayaj wǘxan nganaw matüch nangos nüt. ");
INSERT INTO huvNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Nipilan tayambyambüw Teat Jesús. Wǘxan aliw tiül nadam nangaj iüm tetünayej menguiayayej: ―¿Cuane ipiüngana? ¿Quia aliüc ajaw nangos nüt, ngwüy ngo miüna? ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Cos ajcüwa montangtang miteaats, átan ajcüwa fariseos lamayacüw mipochiw nejiw sitiül aljane majaw nguiane almajlüy Teat Jesús, ich mapiüng nguineay alndom masapüw. ");
INSERT INTO huvNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Alíünan anaíw nüt nganaw matüch pascua, quiaj Teat Jesús tamb Betania aniüng teat Lázaro, áag tapacüüch tiül mondeow. ");
INSERT INTO huvNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Quiaj tarangüw noic nüeteran metiw maquiüjpüw Teat Jesús. Müm Marta tenguial ayac nüeteran, nganüy teat Lázaro alchetem nóiquian maquiiüb Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Condom quiaj müm María tayar pinawan litro najmboc angan aceite nenüt nardo, aag ayaj nembeat xeyay. Tateng wüx oleaj Teat Jesús, condom tajend naag miondeats omal nej. Ndoj xowüy tajmboc angan meáwan tiül aaga iüm quiaj. ");
INSERT INTO huvNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Quiaj micual Simón Iscariote, aaga Judas, nop minipilan Teat Jesús leaw apmayac nej teowixaw monajiüt, tapiüng: ");
INSERT INTO huvNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","―Aaga najmboc angan aceite quiaj xeyay nembeat. ¿Neol ngo majnapa, majineran ombeat müjndiw nipilan ngo majiüre? ―aw. ");
INSERT INTO huvNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Aaga Judas quiaj andeácan, ngome naleaing andiüm mambeolaran nipilan ngo majiür, pero cos need nej. Alteowix nej iquial tomiün, nguiajnguiaj awün maxot tomiün leaw ayacüw tiül. ");
INSERT INTO huvNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Condom quiaj Teat Jesús tasaj nej: ―Icueat, ich majlüy. Aag ayaj lamarang wǘxan nganaw namiüraad. ");
INSERT INTO huvNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Nipilan leaw ngo majiür, meáwan nüt aliw ningüy mequiüjpan; nganüy xique ngome sanajlüy ningüy tiül icona meáwan nüt ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Xeyay nipilan judío wüx tanguiayiw al Betania Teat Jesús, quiaj tambüw majawüw. Naleaing ngome néjan tambüw majawüw; aton tambüw cos andiümüw majawüw a Lázaro, aaga naxey leaw Teat Jesús tapacüüch tiül mondeow. ");
INSERT INTO huvNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Condom quiaj ajcüwa montangtang miteaats tapiüngüw netam mandeow a Lázaro aton; ");
INSERT INTO huvNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","cos wüx tajawüw Lázaro almapac, xeyay nipilan tiül cambaj Israel lamacueatiw nejiw, lamayariw andeac Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Xeyay nipilan aliw Jerusalén majawüw nangos nüt pascua. Ráwan tiüt tanguiayiw aliüc Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Condom quiaj tacojchiw op nit, andeaandeajndiw tiüt tambüw mangochiw nej. Teapajüw teamapiüngüw: ―¡Najneajay arang Teat Dios! ¡Najneajay leaw Teat Dios üüch miün marang Minatang Nenajiüt tiül icoots! ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Teat Jesús taxom nop quicheech bur; tajtep wüx opech atnej lamapiüng tiül Mipoch Teat Dios, cos apiüng: ");
INSERT INTO huvNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Nde mermbolan cambaj Israel; ijawan, aliüc Minatang Nenajiüt icueajiün, alchetem wüx opech nop quicheech bur. ");
INSERT INTO huvNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Wǘxan tenguial ajlüy aag ayaj minipilan nej ngo majawüw neol. Ndoj, wüx Teat Jesús landilil andüy tiül cielo, quiaj leaad omeajtsüw naleaing meáwan leaw tajlüy quiaj; aag ayaj landoj lamarangüch wüx nawiig nde tanomb. ");
INSERT INTO huvNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ajcüwa nipilan leaw tajlüyiw niüng ajlüy Teat Jesús wüx tapacüüch teat Lázaro, lamandeacüw manguiayaran leaw tajawüw arang Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Pares meáwan nipilan tambüw mangochiw nej cos lamanguiayiw nguineay arang. ");
INSERT INTO huvNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Condom ajcüwa fariseos tandeacüw nejeyéjan quiaj, tapiüngüw: ―Nganüy lamajawaats ngondom marangaats nicuajind cos meáwan nipilan almandüjpiw nej ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Tiül ajcüwa monjaw nangos nüt quiaj, ajlüyiw tiül acas nipilan griego. ");
INSERT INTO huvNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Tambüw majawüw teat Felipe, aaga naw cambaj Betsaida tiül Galilea. Tasajüw: ―Teat, xicona xiünan cos sandiüman najawan aaga Jesús ―ajüw. ");
INSERT INTO huvNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Quiaj tamb teat Felipe masaj teat Andrés, ndoj tambüw nóiquian masajüw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Condom quiaj Teat Jesús tasaj nejiw: ―Lamatüch a nüt wüx Teat Naxey netam mandilil andüy tiül cielo, niüng apmajlüy najneajay. ");
INSERT INTO huvNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Naleaing naleaing sasaj icon, sitiül noic osaab trigo ngo majmiüc tiül iüt ndrom ombas, ngome apmajntsop, apmajlǘyan noic nej. Nganüy sitiül apmapiürüch, apndrom ombas, mbich apmajntsop, ndoj apmayac altegüy. ");
INSERT INTO huvNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Jane xeyay andiüm leaw alndom maxom wüx iüt cam, ngome apmaxom leaw andiüm. Pero jane apmayamb Teat Dios, ngo mayac omeaats wüx leaw alndom maxom wüx iüt cam, nej teamacül mapac meáwan nüt maquiiüb Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Sitiül aljane andiüm marang xenajiüt, ich mandüüb xic. Niüng xique sanajlüy, nej apmajlüy aton. Jane arang xenajiüt, Xeteat Dios apmapiüng nej najneaj arang. ");
INSERT INTO huvNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","’Nganüy xeyay ngo majneaj ximeaats. ¿Cuane sanapiüng? ¿Quia napiüng: “Teat, iwün xic wüx, nde namongoch aaga xeyay ngo majneaj leaw aliüc”, nawa? Ngwüy, cos xiün namongoch aag ayaj. ");
INSERT INTO huvNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Teat, ijüiquich mimonajneaj majaraw ―aw. Condom tanguiayaran noic nanderac imiün tiül cielo, tapiüng: ―Lanajüiquich, pero nganüy sanajüiquich alinomb ―aw. ");
INSERT INTO huvNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Meáwan nipilan leaw aliw quiaj teamanguiayiw, tapiüngüw monteoc teaterriür; altiül tapiüngüw: ―Ngwüy, nop ángel ocueaj Teat Dios tendeac ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Condom quiaj tasaj nejiw Teat Jesús: ―Teat Dios tandeac aag ayaj ngome cos netam nanguiay xique; tandeac para menguiayiün icona. ");
INSERT INTO huvNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Lamatüch a nüt majaraw wüx asoetiw monlüy wüx iüt cam; nganüy minatang nimeech leaw ajlüy teowix nej aaga iüt cam apmajwan teowix nej. ");
INSERT INTO huvNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Wüx xique saxaijnguian nayacüch cawüx, ndoj sanüjchiw miünüw niüng sajlüy meáwan nipilan ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Aag ayaj tandeac manguiayaran nguineay apmandeow. ");
INSERT INTO huvNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Quiaj tasajüw nej nipilan: ―Teat, xicona lananguiayiün nguineay apiüng tiül Mipoch Teat Dios, cos apiüng aaga Cristo leaw netam miün apmapac meáwan nüt. Jow nganüy, ¿neol tepiüng Teat Naxey netam xaijnguiam mayacüch cawüxe? ¿Jane aaga Teat Naxey ipiüng quiaja? ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Condom quiaj Teat Jesús tapiüng: ―Nganüy acásan nüt sajlüy ningüy naquiiüb icon. Netam mendüjpiün xic wǘxan nganüy, cos xique sajlüy atnej ran. Sanambeol icon ngana mejlüyiün tiül aaga ngo majneaj atnej pojniün; cos jane ajüy tiül pojniün ngo majaw cuane teamarang, ngo majaw nguiane apmandüy. ");
INSERT INTO huvNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Wǘxan alningüy aaga ran quiaj, netam meyariün andeac nej para mejlüyiün tiül micual aaga ran ―aw. Ndoj mapiüng aag ayaj Teat Jesús, texotüy taw quiaj. ");
INSERT INTO huvNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Masey Teat Jesús lamarang xeyay cuajantanej majawüw, aliün majlüy xeyay nipilan leaw ngo mayariw andeac nej; ");
INSERT INTO huvNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","cos netam majlüy atnej nomb tarang tiül minawiig nej Isaías, aaga nendeac andeac Teat Dios, cos apiüng: Teat, ¿jane lamayar leaw teaach xic nandeaca? ¿Jane lamayac wüx omeaats meáwan leaw iwix tarang majawüwa? aw. ");
INSERT INTO huvNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Pares ngo mayariw, cos aaga Isaías aton lamapiüng: ");
INSERT INTO huvNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Teat Dios tüüch majlüyiw at nejiw somb. Aton tüüch madam omeajtsüw. Atquiaj ngondom majawüw. Ngondom leaam omeajtsüw wüx xic, miünüw niüng sajlüy nawüniw wüx asoetiw nejiw, aw. ");
INSERT INTO huvNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Atquiaj tanomb tandeac Isaías wüx Teat Dios tüüch nej majaw nguineay ajneaj ajlüy Teat Jesús, at leawa nej apmarang. ");
INSERT INTO huvNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Masey atquiaj tajlüy, naleaing altiül monajiüt tiül nipilan judío tayariw andeac Teat Jesús. Pero imboloj mandüyiw ajcüwa fariseos, ngo majüiquichaw nómban, cos ajawüw alndom majwanüw tiül sinagoga. ");
INSERT INTO huvNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Xeyay andiümüw malomb nejiw nipilan ingow ayambüw Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ndoj Teat Jesús tasaj nipilan, tandeac napac: ―Jane ayar sandeac ngome sandeácan xique ayar, aton ayar andeac Xeteat Dios, aaga neech xic niün. ");
INSERT INTO huvNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Jane ajaw xique, ajaw jane neech xic niün aton. ");
INSERT INTO huvNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Xique, aag atnej ran quiaj, laxiün wüx iüt; jane apmayar sandeac langome apmacül tiül pojniün. ");
INSERT INTO huvNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Sitiül aljane apmanguiay sandeac, ndoj ngo mayac wüx omeaats marang atnej, xique ngome sanayac asoet nej, cos ngo niün nayac asoet nipilan; tiünas nawüniw wüx asoetiw. ");
INSERT INTO huvNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Jane ngo mind majaw xic, ngo mayar xepoch, lajlüy neyac nej asoet alinoic nüt, cos aaga poch leawa lanandeac apmayac nej asoet. ");
INSERT INTO huvNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Xique ngo nandeac leaw sandíüman xique. Xeteat Dios neech xic niün lamasaj xic cuane netam nandeac, cuane netam naquiaach. ");
INSERT INTO huvNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Sajaw leaw Xeteat asaj xic napiüng, aag ayaj üüch mapacaran meáwan nüt. Xique áagan sandeac, leaw asaj xic Xeteat Dios ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Raw tiüt nangos nüt pascua, quiaj Teat Jesús ajaw laliüc matüch a nüt maw ningüy wüx aaga iüt cam, mamb niüng ajlüy Teat Dios. Nej tanaámb xeyay andiüm minipilan nej leaw aliw ningüy wüx iüt, pero nganüy apmajüiquich nguineay andiüm nejiw mas xeyay. ");
INSERT INTO huvNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Aaga ongwiiüts quiaj wüx teaüetiw, alquiaj Judas Iscariote micual Simón. Nimeech lamayac tiül omeaats nej mandiüm mayac Teat Jesús teowixaw monajiüt. ");
INSERT INTO huvNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Teat Jesús ajaw Teat Dios lamüüch nej marang cuajantanej. Aton ajaw nej tiün imiün niüng ajlüy Teat Dios; nganüy laliüc mandilil alinomb andüy niüng ajlüy Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Wüx alchetemoj teaüetiw, quiaj witiüt Teat Jesús, taxeend najal apix mapeech quiaj, tayar noic püy tatsaag teomeaats. ");
INSERT INTO huvNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Quiaj tayar tigüy yow mateng tiül palangan, tapots majants oleaj minipilan nej. Condom tajond naag aaga püy leaw almatsaag teomeaats nej. ");
INSERT INTO huvNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Wüx laámb apmajants oleaj teat Simón Pedro, quiaj tasaj nej: ―Teat, ¿ique apmerjants xileaja? ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Quiaj tasaj nej Teat Jesús: ―Nganüy ngo mejaw neol tarangas, pero alinoic nüt apmejaw ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Quiaj tasaj nej teat Pedro: ―Ngwüy teat, ngome apmejants xileaj ―aj nej. Teat Jesús tasaj nej: ―Sitiül ngo meaach xic narang aag ayaj, ngome apmejlüy tiül xenipilan ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Quiaj tasaj nej teat Simón Pedro: ―Sitiül atquiaj ajlüy Teat, ngome áagan xileaj ijants, at xiwix, ximal aton ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Teat Jesús tasaj nej: ―Jan les ndot axeeb lango metam maxeeb alinomb cos nerixix ombas, áagan oleaj nej netam majants. Icona ijlüyiün nerixixan, pero naleaing ngome meáwan ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Cos Teat Jesús lamajaw jane apmayac nej teowixaw monajiüt, áag tapiüng: “Ngome meáwan icona nerixixan ijlüyiün”, maw. ");
INSERT INTO huvNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Wüx landoj majants nej oleajiw, quiaj tasooig apix nej chetet alinomb. Tasaj nejiw: ―¿Ijawana neol tarangas aaga yaja? ");
INSERT INTO huvNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Icona isajan xic Maestro, at isajan xic Teat Xan. Najneaj, atquiaj netam cos xique minatangan, aton xique nequiaach icon. ");
INSERT INTO huvNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Sitiül xique minatangan, aton xique nequiaach icon, nganüy lanajants ileajiün, atquiaj icona aton netam mejantsayon ileajiün. ");
INSERT INTO huvNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Xique lanüüch icon mejawan aag ayaj alndom merangan atnej xique lanarang wüx icona. ");
INSERT INTO huvNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Naleaing naleaing sasaj icon, nop mos ngondom marang natang teombas neneay nej. Aton nop nüünd miün ngondom marang natang teombas neech nej miün. ");
INSERT INTO huvNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Sitiül ijawan aag ayaj, merangan atnej, najneajay apmejlüyiün. ");
INSERT INTO huvNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’Ngome teanandeac aag ayaj wüx meáwan icona, cos xique nerriüjtas icon, sajaw imeajtsan. Pero naleaing netam majlüy atnej apiüng tiül Mipoch Teat Dios: “Nop leaw teasüet anaag apmarroob xileaj najmiüc”, aw. ");
INSERT INTO huvNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Xique lanasaj icon aag ayaj wǘxan nganaw majlüy, cos wüx apmajlüy, quiaj apmejawan xique aaga naxey leaw lanasaj icon wüx. ");
INSERT INTO huvNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Naleaing naleaing sasaj icon, jane apmangoch mayar andeac nop leawa xique süüch mamb, aag ayaj atnej mangoch xic; jane apmangoch xic apmangoch Xeteat aton, cos nej neech xic niün ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Wüx ndoj mapiüng aag ayaj Teat Jesús, quiaj xeyay tamix omeaats. Condom ranüy tandeac masaj nejiw: ―Naleaing sasaj icon, nop tiül icona apmayac xic teowixaw monajiüt ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Minipilan nej wüx tanguiayiw aag ayaj, quiaj tejawayej teombasüw, ngo majawüw jane. ");
INSERT INTO huvNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Tajlüy nop tiül nejiw leawa Teat Jesús xeyay tandiüm, alchetem aweaag nóiquian teaüetiw. ");
INSERT INTO huvNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Quiaj teat Simón Pedro tarang owix müüch nej matün manguiay jane wüx ombas teamandeac. ");
INSERT INTO huvNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Condom aaga nasoic quiaj tatüch alquiriw Teat Jesús, matün manguiay: ―Teat, ¿jane aag ipiüng quiaja? ―aw. ");
INSERT INTO huvNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Teat Jesús tasaj nej: ―Jane sanüüch lopon pan ―aw. Quiaj talop a pan, tüüch a Judas, micual Simón Iscariote. ");
INSERT INTO huvNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Wüx Judas landoj müet a pan, quiaj tajmel tiül omeaats nej aaga natang nimeech nenüt Satanás. Condom tasaj nej Teat Jesús: ―Leaw apmerang, quiür irang najen ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Nejinguind tiül leaw teaǘet aweaag ngo maxomüw omeajtsüw neol tasaj atquiaj. ");
INSERT INTO huvNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Cos aaga Judas nesap iquial tomiün, altiül tapiüngüw Teat Jesús tasaj nej mamb mangal leaw netam nejiw wüx nangos nüt. Altiül tapiüngüw tasoic mamb mambeol nipilan ngo majiür. ");
INSERT INTO huvNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judas wüx landoj müet a pan, quiaj taw quiaj, langwiiüts. ");
INSERT INTO huvNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Wüx laáw quiaj a Judas, quiaj tapiüng Teat Jesús: ―Nganüy apmajüic najneajay ajlüy Teat Naxey; aton nej apmajüiquich nguineay ajneaj ajlüy Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Teat Naxey teamajüiquich nguineay ajneaj ajlüy Teat Dios, at Teat Dios aton apmajüiquich nguineay ajneaj ajlüy Teat Naxey; aag ayaj laliüc majlüy. ");
INSERT INTO huvNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Xecualüw, langome sanajlüy ningüy naquiiüb icon alacas nüt. Icona apmeyamban xic; pero sasaj icon atnej tasajasüw monajiüt ninguinüt: Ngondom meamban niüng sanamb. ");
INSERT INTO huvNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Netam mendiüman nop alinop atnej xique sandiüm icon. Aag ayaj jayats poch leaw sasaj icon merangan. ");
INSERT INTO huvNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Sitiül icona mendiüman nop alinop, quiaj nipilan apmajawüw xenipilan icon ―aw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Teat Simón Pedro quiaj tatün manguiay Teat Jesús: ―Teat, ¿nguiane apmeamba? ―aj. Teat Jesús tasaj nej: ―Niüng sanamb, ngondom mendüüb xic mamb nganüy; alinoic nüt alndom mendüüb xic mamb ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Condom quiaj teat Pedro tasaj nej: ―Teat, ¿neol ngondom nandüüb ic mamb nganüye? Xique sajlüy masey nandeow ingow indeow ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Quiaj tasaj nej Teat Jesús: ―¿Neol tepiüng ique apmendeow ingow sandeowa? Naleaing naleaing sasaj ic menguiay Pedro, wüx nganaw mepaj a gallo, ique lamepiüng arojmbüw ngo mejaw jane xic ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Aton tasaj nejiw Teat Jesús: ―Nde mechiwean imeajtsan wüx inguiayiün sanamb. Iyacan imeajtsan wüx Teat Dios; iyacan imeajtsan wüx xique aton. ");
INSERT INTO huvNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Aniüng Xeteat tiül cielo ajlüy quiaj xeyay najneajneaj iüm niüng alndom macüleran. Sitiül ngo maleaing, xique ngome sanasaj icon atquiaj. Nganüy sanamb nataag majneaj niüng apmecüliün. ");
INSERT INTO huvNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Wüx landoj nataag majneaj niüng apmecüliün, quiaj sanandilil najan icon, apmajlüyiiüts nóiquian niüng sanajlüy. ");
INSERT INTO huvNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Icona lamejawan nguiane sanamb; aton iyajcan a tiiüd ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Quiaj tasaj nej teat Tomás: ―Teat, ngo najawan nguiane apmeamb, ¿nguineay sanayajcan a tiiüd? ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Teat Jesús tapiüng: ―Xique aaga tiiüd, xique nequiajchiüs palan leawa naleaing, at xique nejchiüs mapacaran. Nejinguind ngondom mamb niüng ajlüy Xeteat Dios sitiül ngo mayar sandeac. ");
INSERT INTO huvNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Sitiül naleaing lamejawan jane xic, aton apmejawan jane Xeteat. Nde nganüy lamejawan jane nej ―aw. ");
INSERT INTO huvNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Quiaj tasaj nej teat Felipe: ―Teat, iich xicon najawan miteat, quiaj apmajneaj ximeajtsan ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Tasaj nej Teat Jesús: ―Felipe, ijaw cas nüt sajlüy naquiiüb icon, ¿neol nganaw mejaw jane xique? Cos jane ajaw xic, atanej majaw Teat Dios aton. ¿Neol tepiüng nüüch icon mejawan Teat Dios? ");
INSERT INTO huvNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Neol ngo meyar sandeac mepiüng naleaing xique sajlüy tiül Xeteat, at Xeteat aton ajlüy tiül xique? Meáwan leaw sasaj icon, aag ayaj ngome sapíüngan xique. Xeteat najlüy tiül xic, nej arang minajiüt nej. ");
INSERT INTO huvNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Netam mepiüngan naleaing xique sajlüy tiül Xeteat, at Xeteat ajlüy tiül xique. Sitiül ngwüy netam meyariün mepiüngan naleaing leawa sarang. ");
INSERT INTO huvNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Naleaing naleaing sasaj icon, jane ayar sandeac, aton apmarang leaw sarang. Nej apmantsopiich wüx leawa xique tarangas, cos xique sanamb niüng ajlüy Xeteat Dios. ");
INSERT INTO huvNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Meáwan leaw apmetüniün ocueaj Teat Dios wüx xenüt, xique sanarang, cos atquiaj sanajüiquich mimonajneaj Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Xique sanarang cuajantanej leaw apmetüniün xicueaj wüx xenüt. ");
INSERT INTO huvNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","’Sitiül icona indiüman xic, apmerangan meáwan leaw lanasaj icon. ");
INSERT INTO huvNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Quiaj sanatün ocueaj Xeteat müüch miün alinop nembeol icon müüch mapac imeajtsan. Aag ayaj Nangaj Espíritu ocueaj Teat Dios. Nej apmacül maquiiüb icon meáwan nüt. ");
INSERT INTO huvNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Nipilan leaw ngo mayambüw Teat Dios ngondom mayariw aag ayaj, cos nejinguind ngondom maxom majaw aaga Nangaj Espíritu ocueaj Teat Dios. Icona lamejawan, nej arang leaw naleaing, cos nej almaquiiüb icon, ndoj meáwan nüt apmacül tiül imeajtsan. ");
INSERT INTO huvNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ngome sanacueat icon nómban mejlüyiün atnej ndeoj; saliüc alinomb. ");
INSERT INTO huvNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Nipilan wüx aaga iüt cam acásan nüt ajawüw xic, ndoj langome apmaxomüw majawüw xic; pero icona apmejawan xic alinomb cos sanapac. Atquiaj icona aton apmepacan meáwan nüt niüng sajlüy. ");
INSERT INTO huvNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Wüx aaga nüt quiaj apmejawan naleaing xique sajlüy tiül Xeteat Dios; at icona ijlüyiün tiül xique, y xique sajlüy tiül icona. ");
INSERT INTO huvNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Jane anguiay leawa xic sapiüng, sitiül apmayac wüx omeaats marang atnej, quiaj ajüic naleaing andiüm xic. Xeteat aton andiüm jane andiüm xic, ata xique aton sanandiüm, sanüüch maxom omeaats majaw wüx xique, ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Quiaj teat Judas, ngome aaga Iscariote, tasaj: ―Teat ¿neol tepiüng xicónan quiaj apmeaach xicon najawan ic, jow meáwan nipilan wüx iüt, neol ngondoma? ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Quiaj Teat Jesús tasaj nej: ―Leaw nendiüm xic apmarang leawa sapiüng. At Xeteat aton apmandiüm nej, quiaj saliücan najlüyiün nóiquian naquiüjpan. ");
INSERT INTO huvNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Nganüy leaw ngo mandiüm xic ngome apmarang leawa sapiüng. Aaga poch leawa teanasaj icon quiaj, ngome sandeácan xique, Xeteat áaga neech xic niün nesaj xic. ");
INSERT INTO huvNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Teanasaj icon meáwan aag ayaj wǘxan saliün ningüy naquiiüb icon. ");
INSERT INTO huvNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Nganüy Nangaj Espíritu, aaga Nembeol, leawa Xeteat apmüüch miün wüx xenüt, nej apmaquiaach icon wüx meáwan leaw netam. Nej apmüüch leaam imeajtsan meáwan leaw lanasaj icon. ");
INSERT INTO huvNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’Nganüy sanacueat ningüy xemonajneaj nüüch icon, müüch mapac imeajtsan; aag ayaj ngome nóiquian among atnej apac omeajtsüw nipilan monrang ngo majneaj. Ngo metam mechiwean imeajtsan, ngo metam mermbolan. ");
INSERT INTO huvNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Lamenguiayiün lanasaj icon xique sanamb, condom saliüc alinomb najan icon. Sitiül naleaing indiüman xic, apmapac imeajtsan wüx inguiayiün sanamb niüng ajlüy Xeteat Dios, cos nej xenatang. ");
INSERT INTO huvNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Nganüy lanasaj icon nguineay apmajlüy; atquiaj wüx apmajlüy meáwan aag ayaj, quiaj apmepiüngan naleaing leaw tandeacas. ");
INSERT INTO huvNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","’Lango matüch nendeac naquiiüb icon alquiriw, cos laliüc majngot minatang nerang ngo majneaj wüx aaga iüt cam. Nej nicuajind ngondom marang wüx ximbas. ");
INSERT INTO huvNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Nganüy cos netam majawüw meáwan nipilan wüx iüt nguineay sandiüm Teat Dios, sanarang leawa nej lamapiüng. Nganüy witiüron, tabaats. ");
INSERT INTO huvNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","’Xique sajlüy atnej noic owil uva leawa Teat Dios tapiür; nej ajlüy wüx, teamajiür. ");
INSERT INTO huvNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Meáwan xepüüig leaw ngo mayac aóng apmandojquiüm; nganüy meáwan leaw neóng apmajorrǘchan omal para tsatsam mayac altegüy aóng. ");
INSERT INTO huvNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","At icona aton, Teat Dios lamawün wüx imbasan meáwan ngo majneaj, cos lameyariün xepoch. ");
INSERT INTO huvNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Netam tanaámb mejlüyiün nóiquian mequiüjpan xic; ata xique aton sanajlüy nóiquian naquiiüb icon. Sitiül ngo mejlüyiün nóiquian mequiüjpan xic, ngondom merangan nicuajind. Cos atnej arang mipüüig xiül sitiül landojquiow, langondom mayac aóng. ");
INSERT INTO huvNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’Xique sajlüy atnej noic owil uva; icona ijlüyiün atnej mipüüig aaga uva quiaj. Jane tanaámb ajlüy nóiquian maquiiüb xic, xique sanaquiiüb; nej apmarang xeyay xenajiüt. Icona ngondom merangan nicuajind sitiül ngo majlüyiiüts nóiquian. ");
INSERT INTO huvNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Jane ngo macül nóiquian naquiiüb, apmajwan majlos ninguiün atnej arangüch wüx mipüüig uva leaw ngo mayac aong. Quiaj apmawaag, ndoj apxaijnguiam majwich tiül biümb mandaab. ");
INSERT INTO huvNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Sitiül tanaámb mejlüyiün nóiquian mequiüjpan xic, ngo ndrom imeajtsan leaw lanaquiaach icon, alndom metüniün xicueaj leaw indiüman, quiaj apmeajndiün. ");
INSERT INTO huvNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Wüx icona irangan xeyay xenajiüt, quiaj apmanderac najneajay wüx ombas Xeteat Dios; aton atquiaj ijüiquichan naleaing xenipilan icon. ");
INSERT INTO huvNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Xique sandiüm icon atnej Xeteat Dios andiüm xic. Tanaámb ich leaam imeajtsan nguineay xique sandiüm icon. ");
INSERT INTO huvNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Xeteat Dios andiüm xic cos sarang leawa nej apiüng. Sitiül atquiaj icona tanaámb merangan leaw lanapiüng, ata xique aton tanaámb sanandiüm icon. ");
INSERT INTO huvNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Aag ayaj sasaj icon para mapac imeajtsan xeyay meáwan nüt atnej apac ximeaats. ");
INSERT INTO huvNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Leawa xic sasaj icon merangan: Aag ayaj mendiüman nop alinop atnej xique sandiüm icon. ");
INSERT INTO huvNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Wüx nop naleaing andiüm aljane, ngo mapiüng wüx, masey mandeow ingow andeow aaga xeyay ajneaj aweaag. ");
INSERT INTO huvNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Icona, sitiül apmerangan leawa sasaj icon, apmajlüyiiüts xeyay najneaj. ");
INSERT INTO huvNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ngo napiüng icona ijlüyiün atnej mos, cos nop mos ngo majaw cuane arang neneay najiüt. Xique lanasaj icon mejlüyiün xeyay ajneajiiüts, cos lanüüch icon menguiayiün meáwan leaw lamasaj xic Xeteat Dios. ");
INSERT INTO huvNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ngome icona teyamban xic, xique tayambas icon mejlüyiün xenipilan. Lanüüch icon meamban merangan xenajiüt mesajan meáwan nipilan mayariw sandeac, para nejiw aton tanaámb marangüw leaw sapiüng. Atquiaj Teat Dios apmüüch icon meáwan leaw apmetüniün wüx xenüt. ");
INSERT INTO huvNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Inguiayiün, sanasaj icon alinomb: Netam mendiüman nop alinop. ");
INSERT INTO huvNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","’Sitiül meáwan nipilan ajcüyiw majawüw icon, ich leaam imeajtsan nejiw landoj lajcüyiw majawüw xic aton. ");
INSERT INTO huvNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Sitiül ndot icona apmerangan atnej arangüw meáwan nipilan, nejiw apmajneaj majawüw icon atnej ajneaj mejawayej nejeyéjan quiaj. Nganüy cos xique lanawün icon tiül nejiw, áag ajcüyiw majawüw icon, cos lango merangan meáwan ngo majneaj leaw nejiw arangüw. ");
INSERT INTO huvNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ich leaam imeajtsan leaw lanasaj icon wüx tapiüngas: “Nop najon mos ngome alwüx atam minajiüt nej; ajaraw alwüx atam minajiüt neneay najiüt.” Sitiül ayambüw ximbas, ata icona aton apmayambüw imbasan xeyay. Sitiül nipilan lamayacüw wüx omeajtsüw leawa sandeac, atquiaj apmayacüw wüx omeajtsüw leaw indeacan. ");
INSERT INTO huvNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Meáwan aag ayaj apmarangüw wüx imbasan cos iyariün sandeac. Ngo majawüw jane neech xic niün. ");
INSERT INTO huvNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Sitiül xique ngo niün nasajüw wüx asoetiw nejiw, ngome apmayajcüw ajiürüw nisoet. Nganüy cos tiünas nasajüw, áag ngo majiürüw cuane mewüyayej wüx. ");
INSERT INTO huvNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Jane ajcüy majaw xic, ajcüy majaw Xeteat aton. ");
INSERT INTO huvNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Sitiül ndot ngo narang xeyay cuajantanej najneaj tiül nejiw, leaw nejinguind ngondom marang, ngome apmayajcüw ajiürüw nisoet. Nganüy masey tajawüw leawa tarangas, tanaámb ajcüyiw majawüw xic, átan Xeteat aton ajcüyiw majawüw. ");
INSERT INTO huvNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Atquiaj netam majlüy atnej tapiüngüw mondeac andeac Teat Dios wüx tapiüngüw: “Ngo majlüy cuaneol tajcüyiw majawüw xic”, awüw. ");
INSERT INTO huvNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’Sanüüch miün nop nembeol icon, aaga Nangaj Espíritu ocueaj Teat Dios. Aliüc imiün niüng ajlüy Teat Dios. Nej aton apmajüiquich wüx xic. ");
INSERT INTO huvNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","At icona aton apmejüiquichan naleaing wüx xique, cos nde wüx tamelichas saquiaach, icona almequiüjpan xic. ");
INSERT INTO huvNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","’Nganüy lanasaj icon meáwan aag ayaj, nganandot mepiüngan alinoic nüt xique ngo nasaj icon. ");
INSERT INTO huvNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Cos apmejwanaranan tiül sinagoga. Aton aliüc miün nüt wüx apmambiyaw icon. Ajcüwa monbiy quiaj apmapiüngüw tearangüw minajiüt Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Atquiaj apmarangüw cos ngo majawüw jane nej Xeteat, átan ngo majawüw jan xic. ");
INSERT INTO huvNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Nganüy lanasaj icon aag ayaj cos wüx apmajlüy atnej lanapiüng quiaj, quiaj apleaam imeajtsan nguineay xique landoj lanapiüng wüx aag ayaj. ’Xique nganaw nasaj icon wüx aag ayaj cos saliün naquiiüb icon. ");
INSERT INTO huvNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Nganüy sanandilil, sandüy niüng ajlüy aaga neech xic niün; icona ngo metüniün menguiayiün nguiaj süp. ");
INSERT INTO huvNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Cos lanasaj icon meáwan aag ayaj, nganüy xeyay lamix imeajtsan. ");
INSERT INTO huvNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Naleaing sasaj icon, najneaj sitiül xique sanamb; cos ndot ngo namb, aaga Nembeol müüch mapac imeajtsan ngome aliüc macül mequiüjpan. Nganüy sitiül sanamb, xique sanüüch miün aaga Nembeol quiaj. ");
INSERT INTO huvNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Wüx nej aliüc, apmüüch leaam omeaats meáwan nipilan mayajcüw ajiürüw nisoet; aton apmüüch mayajcüw netam marangüw leawa najneaj. Apmüüch leaam omeajtsüw nguineay Teat Dios apmajaw wüx asoeteran alinoic nüt. ");
INSERT INTO huvNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ajiürüw nisoet cos ngo mayariw sandeac. ");
INSERT INTO huvNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Nej apmajüiquich leaw naleaing, leaw najneaj marangüch, cos xique sanamb niüng ajlüy Xeteat Dios, langome apmexoman mejawan xic. ");
INSERT INTO huvNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Nej apmüüch leaam omeaats nipilan nguineay Teat Dios apmajaw wüx asoeteran; cos Satanás, aaga minatang nerang ngo majneaj wüx aaga iüt cam landoj layacüch asoet. ");
INSERT INTO huvNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Aliün najiür cuane sanasaj icon; pero icona nganüy ngondom mejawan cuane wüx sandeac. ");
INSERT INTO huvNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Wüx aliüc Nangaj Espíritu ocueaj Teat Dios, nej apmüüch icon mejawan meáwan leaw naleaing; cos nej ngo mandeácan leawa andíüman nej, apmandeac leaw anguiay, aton apmüüch icon mejawan leaw aliüc miün apmajlüy. ");
INSERT INTO huvNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Nej apmandeac najneaj wüx xique. Apmayar meáwan leawa sapiüng, apmüüch icon mejawan cuane wüx apiüng. ");
INSERT INTO huvNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Meáwan leaw ocueaj Xeteat, aag ayaj xicueaj aton. Áag tapiüngas leaw Nangaj Espíritu apmandeac masaj icon, aag ayaj ajngot imiün wüx xique. ");
INSERT INTO huvNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","’Alacas nüt langome apmexoman mejawan xic, cos sanamb sandüy niüng ajlüy Xeteat. Condom alinoic nüt apmejawan xic alinomb ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Altiül minipilan nej tatünayej menguiayayej, tapiüngüw: ―¿Quia nguineay amb aag apiüng quiaja? Cos asaj icoots: “Alquiriw nüt alíünan wüx icona langome apmexoman mejawan xic, cos sanamb sandüy niüng ajlüy Xeteat. Condom alinoic nüt apmejawan xic alinomb”, maw. ");
INSERT INTO huvNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Cuane aag apiüng: “Alíünan alquiriw nüt quiaja”? Ngondom majawaats cuane wüx amb apiüng ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Teat Jesús tajaw teamandiümüw matüniw nej manguiayiw. Quiaj tasaj nejiw: ―¿Tenguial ertünayon menguiayayon wüx áag sasaj icon quiaja, alacas nüt langome apmexoman mejawan xic, condom alinoic nüt apmejawan xic alinomba? ");
INSERT INTO huvNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Naleaing naleaing sasaj icon, apmejiüntsan apmamix imeajtsan, pero altegüy nipilan apmapac omeajtsüw. Masey icona apmamix imeajtsan, ndójwüx apmapac imeajtsan xeyay. ");
INSERT INTO huvNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Atnej arang nop najtaj wüx apwijquiam micual nej, apmecoy omeaats cos lamatüch a ores. Ndoj, wüx lawijquiaw a nine, lango leaam omeaats aaga necoy tamongoch quiaj, cos xeyay apac omeaats majaw lawijquiaw nop nine. ");
INSERT INTO huvNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","At icona, nganüy amix imeajtsan; pero wüx saliüc alinomb najaw icon, quiaj apmapac imeajtsan xeyay; nejinguind ngome apndom mawün aaga apac imeajtsan quiaj. ");
INSERT INTO huvNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","’Wüx aaga nüt quiaj nicuajind langome apmetam metüniün menguiayiün xic. Naleaing naleaing sasaj icon meáwan leaw apmetüniün ocueaj Xeteat wüx xenüt, nej apmüüch icon. ");
INSERT INTO huvNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Nganüy nicuajind nganaw metüniün ocueaj Xeteat wüx xenüt; pero sitiül icona apmetüniün apmeajndiün, quiaj apmapac imeajtsan xeyay. ");
INSERT INTO huvNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","’Meáwan leawa lanasaj icon ngo najüiquich aleaing miün cuane wüx sandeac. Laliüc matüch a nüt wüx xique langome sanandeac atquiaj, sanandeac aleáingan wüx Xeteat. ");
INSERT INTO huvNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Wüx aaga nüt quiaj icona apmetüniün leaw indiüman wüx xenüt, ngome apmetam natün ocueaj Xeteat Dios müüch icon. ");
INSERT INTO huvNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Xeteat Dios andiüm icon cos indiüman xic. Aton cos lameyariün mepiüngan naleaing tiünas ximiün niüng ajlüy nej. ");
INSERT INTO huvNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Xique tiünas ningüy wüx iüt ximiün niüng ajlüy Xeteat Dios. Nganüy sanaw ningüy, sanamb alinomb sandüy niüng ajlüy nej ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Quiaj tasajüw nej minipilan nej: ―¡Ajaj teat, nganüy mbich lamejüiquich aleáingan leaw indeac! ");
INSERT INTO huvNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Nganüy lanajawan ique ijaw meáwan cuajantanej. Nejinguind ngo metam masaj ic cuane andiüm, cos ique lamejaw. Atquiaj sajawan naleaing Teat Dios neech ic mewiün ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Quiaj tasaj nejiw Teat Jesús: ―¿Lameyariün sandeac nganüye? ");
INSERT INTO huvNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Nganüy lamatüch a nüt ndajrriümeron, mejawan nguiane apmendüyiün inopnopon, cos apmecueatiün xic. Naleaing ngome sanajlüy xíquian quiaj cos Xeteat almaquiiüb xic. ");
INSERT INTO huvNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Lanasaj icon meáwan aag ayaj para mapac imeajtsan wüx xic. Masey wüx aaga iüt cam apmemongochiün xeyay ngo majneaj, pero alndom meiücan wüx sitiül apmeyacan imeajtsan wüx xique, cos najntsopiüs wüx aaga iüt cam ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Wüx ndoj mapiüng aag ayaj Teat Jesús, quiaj taxaing omal majaw cawüx, tataag orar, tapiüng: ―Xeteat Dios, nganüy lamatüch a nüt, ijüiquich mimonajneaj wüx Micual, para nej majüiquich mimonajneaj aton. ");
INSERT INTO huvNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Atnej ique lameaach nej majlüy wüx meáwan nipilan, atanquiaj aton iich mapacüw meáwan nüt ajcüwa nipilan leawa ique lameaach nej. ");
INSERT INTO huvNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Apmapacüw meáwan nüt cos ajawüw naleaing ique inopǘyan Teat Dios, at apiüngüw ique teaach miün Jesucristo. ");
INSERT INTO huvNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","’Xique lanandeac najneajay wüx ique ningüy tiül nipilan. Lanambich narang meáwan leawa teaach xic niün narang. ");
INSERT INTO huvNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Nganüy Teat, sanandilil sandüy niüng ijlüy, majlüyiür najneajay atnej tajlüyiür wüx nganaw majlüy aaga iüt cam. ");
INSERT INTO huvNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Ajcüwa nipilan leawa terriüjtüw meajchiw xic, lanüjchiw majawüw jane ic. Ajcüw ayaj minipilanüw, nganüy ique lameajchiw xic. Nejiw lamayacüw wüx omeajtsüw Mipoch, Teat. ");
INSERT INTO huvNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Nganüy lamajawüw naleaing ique tesaj xic meáwan leawa tandeacas. ");
INSERT INTO huvNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Aaga poch leawa teaach xic lanasajüw, nejiw lamayariw. Lamajawüw aag ayaj naleaing cos ique teaach xic niün, ximiün niüng ijlüy sajngot. ");
INSERT INTO huvNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Satün icueaj Teat, membeolüw ajcüwa leaw teajchiw xic, cos icueajiw. Xique ngo natün membeol meáwan nipilan leaw ngo mayamb ic. ");
INSERT INTO huvNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Meáwan xenipilan ajcüw ayaj ineay; aton meáwan leaw ijiür, ajcüw ayaj saneay. Nejiw teamajüiquichaw xemonajneaj. ");
INSERT INTO huvNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’Nganüy Teat, xique laliüc naw ningüy wüx iüt cam, sanamb sandüy niüng ijlüy; nejiw apmacülíwan ningüy. Xeteat Dios, nangaj ic, imbeolüw meáwan nüt ajcüwa leaw lameajchiw xic, para alndom majlüyiw nóiquian atnej ajlüyiür. ");
INSERT INTO huvNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Cos wüx xique sajlüy ningüy naquiüjpüw, ique teamembeol xic nayacüw tiül iwix meáwan leawa teajchiw xic. Nejinguind tiül nejiw ngo ndromoj tiül aaga xeyay ngo majneaj, áagan anop minipilan nimeech; cos netam majlüy atnej lajlüy tiül Nangaj Mipoch. ");
INSERT INTO huvNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Nganüy Teat, sanamb sandüy niüng ijlüy. Wǘxan saliün ningüy wüx aaga iüt cam, teanandeac aag ayaj manguiayiw, mapac omeajtsüw xeyay atnej apac ximeaats. ");
INSERT INTO huvNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Xique lanasajüw wüx mipoch. Naleaing nipilan ajcüyiw majawüw nejiw, cos lango marangüw ngo majneaj atnej arang jangantanej nipilan, Xique aton ngo narang leaw arang jangantanej nipilan. ");
INSERT INTO huvNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Teat, ngo natün mewün nejiw ningüy wüx aaga iüt cam; satün icueaj membeolüw nganandot matüch nejiw nimeech. ");
INSERT INTO huvNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Cos xique ngo narang atnej jangantanej nipilan wüx iüt, atanquiaj nejiw aton lango marangüw ngo majneaj atnej arangüw jangantanej nipilan. ");
INSERT INTO huvNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Iwüniw pálwüx, majlüyiw icueaj, cos atquiaj alndom marangüw najneaj. Nangaj Mipoch apmambeol nejiw cos andeac naleaing. ");
INSERT INTO huvNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Atnej ique teaach xic niün wüx iüt, atanquiaj xique aton lanasajüw mambüw meáwan wüx aaga iüt cam. ");
INSERT INTO huvNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Xique lanüüch ximeaats namongoch leaw netam namongoch. Atanquiaj aton nejiw netam müjchiw omeajtsüw marangüw leaw ique indiüm, cos aag ayaj naleaing. ");
INSERT INTO huvNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’Aton Teat, ngo natün wǘxan nejiw; satün membeol meáwan leaw aliüc miün apmayariw sandeac wüx nejiw apmandeacüw masajüw nipilan wüx xic. ");
INSERT INTO huvNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Satün majlüyiw nóiquian omeajtsüw atnej icora ajlüyiür nóiquian Teat, atanquiaj majlüyiw aton; cos atquiaj jangantanej nipilan alndom majawüw naleaing ique teaach xic niün. ");
INSERT INTO huvNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Atnej xique sajüiquich wüx ique Teat, nguineay ajneaj ijlüy, atanquiaj aton lanüjchiw majüiquichaw xemonajneaj. Wüx aag ayaj alndom majlüyiw nóiquian atnej icora ajlüyiür. ");
INSERT INTO huvNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Xique sajlüy tiül nejiw, ata ique Teat, ijlüy tiül xique. Atanquiaj aton alndom majlüyiw nóiquian omeajtsüw, para meáwan nipilan majawüw naleaing ique teaach xic niün. Aton indiümüw xeyay atnej indiüm xic. ");
INSERT INTO huvNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’Teat, ajcüwa leawa teaach xic, sandiüm majlüyiw niüng sajlüy, majawüw nguineay ajneaj sajlüy. Cos ique Teat, indiüm xic tanaámb atnej wüx nganaw majlüy aaga iüt cam. ");
INSERT INTO huvNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Xeteat Dios, najneajay irang. Masey nipilan ngo majawüw jane ic, xique naleaing sajaw jane ic. At ajcüwa xenipilan lamajawüw ique teaach xic niün. ");
INSERT INTO huvNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Xique lanüjchiw majawüw jane ic Teat; tanaámb teanasajüw nguineay ijlüy. Atnej indiüm xic Teat, atanquiaj nganüy sandiüm mendiümüw. Xique sanajlüy naquiüjpüw aton ―aw. ");
INSERT INTO huvNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Wüx landoj mapiüng aag ayaj Teat Jesús, tawüw quiaj. Tambüw andüyiw necamb nine lam nasoic Cedrón. Tandüyiw quiaj niüng ajlüy acas owil nateaic xiül, maquiiüb minipilan nej. ");
INSERT INTO huvNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Aaga Judas, leaw apmayac nej teowixaw monajiüt, ayaag quiaj cos ajlüyay canchiüjow quiaj maquiüjpüw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Quiaj tapeay aaga Judas, aquiiüb mamb noic ajlüy soldados, at acas monjiür nadam nangaj iüm, üüch nejiw mambüw montangtang miteaats maquiiüb fariseos. Ajoyiw linternas, at najquiol irrajayej; aton ajoyiw espadas. ");
INSERT INTO huvNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Teat Jesús cos lamajaw cuane aliüc miün apmamongoch, quiaj witiüt tamb mangoch nejiw. Tapiüng: ―¿Jane iyambana? ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Quiaj tasajüw nej: ―Aaga Jesús naw Nazaret ―ajüw nej. Teat Jesús tasaj nejiw: ―Jogüy xic ―aj nejiw. Aaga Judas, leaw apmayac nej teowixaw monajiüt, altiül nipilan aton. ");
INSERT INTO huvNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Wüx tasaj nejiw Teat Jesús: “Jogüy xic”, maj nejiw, tanaámb tanotoj opechiw, ajmiücüw pajcajow tiüt. ");
INSERT INTO huvNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Condom Teat Jesús tandüy wüx matün manguiay nejiw: ―¿Jane iyambana? ―aj nejiw. Quiaj tasajüw nej alinomb: ―Aaga Jesús naw Nazaret ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Quiaj tasaj nejiw Teat Jesús: ―Lanasaj icon jogüy xic. Sitiül xique temeyamban, ijchan mambüw xenipilan ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Atquiaj tajlüy atnej lamapiüng Teat Jesús wüx tapiüng: “Meáwan leawa teaach xic, nejinguind tiül nejiw ngome apndrom”, aw. ");
INSERT INTO huvNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simón Pedro almajoy nots espada, tasoond tiül ombiüm, tandooig miác olaag nop naxey nenüt Malco, mimos minatang miteaats. ");
INSERT INTO huvNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Quiaj Teat Jesús tasaj a Pedro: ―¡Pedro, isoc alinomb tiül ombiüm nej miespada! ¿Neol, iyaag a ique ngo metam namongoch aaga naél leaw lamapiüng Xeteat netam namongoche? ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ajcüwa soldados maquiüjpüw minatangüw nejiw, at monjiür nadam nangaj iüm ocueajiw nipilan judío, tasapüw Teat Jesús maoeliw. ");
INSERT INTO huvNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Condom taquiüjpüw mamb andüy aniüng Anás, miocuats Caifás. Aaga Caifás quiaj, nej minatang miteaats tiül aaga neat quiaj. ");
INSERT INTO huvNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Nej aaga Caifás quiaj, nejay nesaj monajiüt najneaj mandeow nop naxey ingow ndroj ombas aaga cambaj Israel, maw. ");
INSERT INTO huvNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simón Pedro aquiiüb alinop minipilan Teat Jesús, tambüw mandüjpiw mamb Teat Jesús. Aaga alinop quiaj, ayaag nej ombas minatang miteaats. Áag tüünd majmel tinden maquiiüb Teat Jesús; ");
INSERT INTO huvNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","pero Pedro tacǘlan mbeay nden. Quiaj aaga naxey neyaag nej ombas minatang miteaats taw, tamb mandeac aweaag nejiür ombeay nden mamelich a Pedro aton. ");
INSERT INTO huvNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Condom aaga nüx nejiür ombeay nden tatün manguiay a Pedro: ―¿Neol ngome ique nop minipilan aaga Jesús quiaja? ―aj. Pedro quiaj tapiüng: ―Ngwüy ngome xique ―aw. ");
INSERT INTO huvNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ores quiaj naquind, pares tajalüw biümb ajcüwa mos maquiüjpüw monjiür nangaj iüm, alombomoj teatsantsayej. At a Pedro aton alembem quiaj teatsantsüy mbeay biümb. ");
INSERT INTO huvNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Condom minatang miteaats tatün manguiay Teat Jesús jane minipilan nej, at cuane wüx teamaquiaach. ");
INSERT INTO huvNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Quiaj tasaj nej Teat Jesús: ―Xique ngo naxot, sandeac niüng ajlüy nipilan; samb tiül tiül ajcüw a sinagogas, aton samb tiül aaga nadam nangaj iüm, niüng canchiüjow meáwan micual miiütaats. Xique ngo nexotüy wüx sandeac. ");
INSERT INTO huvNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Jow nganüy, neol tetün menguiay xique? Itün menguiayiw ajcüwa tanguiayiw sandeac. Nejiw ich mapiüngüw cuane wüx tandeacas, cos lamajawüw ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Wüx ndoj mapiüng aag ayaj Teat Jesús, nop nejiür nadam nangaj iüm taleamb nej, tapiüng: ―¿Neol tesaj atquiaj minatang miteaatsa? ―aw. ");
INSERT INTO huvNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Quiaj tasaj nej Teat Jesús: ―Sitiül ngo majneaj sasaj, ipiüng cuane ngo majneaj sasaj; sitiül najneaj, ¿neol teleamb xique? ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Condom quiaj aaga Anás tüüch mamb Teat Jesús neóel, andüy niüng ajlüy alinop minatang miteaats, aaga Caifás. ");
INSERT INTO huvNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Teat Pedro tealeámban aliün lembem quiaj, teatsantsüy. Quiaj tasajüw nej: ―¿Ngome ique nop minipilan neje aaga naxey quiaja? ―ajüw nej. Quiaj tapiüng teat Pedro: ―Ngwüy, ngome xique ―aw. ");
INSERT INTO huvNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Condom nop mimos minatang miteaats, acualaats aaga naxey nandooigaran olaag, andooig nej teat Pedro, tasaj nej: ―¿Ngome ique sajaw almequiiüb nej niüng ajlüy acas owil nateaic xiüla? ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Teat Pedro quiaj tandüy wüx alinomb mawaiich, tapiüng ngome nej. Quiaj apaj a gallo. ");
INSERT INTO huvNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ǘmban arraw taquiüjpüw mamb Teat Jesús imiün aniüng a Caifás andüy awan niüng ajlüy a gobernador romano. Nejiw ngo majmeliw cos tiül aaga ajlüyay netam marangüw quiaj, sitiül majmeliw aniüng nop ngome nipilan judío wüx aaga nüt quiaj, apmajlüyiw ngo merixix, langondom metiw tiül nangos nüt pascua. ");
INSERT INTO huvNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Quiaj taw a Pilato mandeacüw maquiüjpüw, tasaj nejiw: ―¿Cuane ngo majneaj arang aaga naxey cama? ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Quiaj tasajüw nej: ―Sitiül nej ngome aleaic arang ngo naquiüjpan miün niüng ijlüy ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Quiaj tapiüng a Pilato: ―Icona iquiüjpan mamb, ijawan wüx asoet nej atnej apiüng tiül minawijquian ―aw. Quiaj tasajüw nej ajcüwa nipilan: ―Xicona ngondom nambiyan nejinguind ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Atquiaj tajlüy para majlüy atnej lamapiüng Teat Jesús nguineay apmandeow. ");
INSERT INTO huvNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Condom a Pilato tandilil alinomb tajmel tiül awan, tapaj Teat Jesús matün manguiay, tasaj: ―¿Ique minatangüw nipilan israele? ―aj. ");
INSERT INTO huvNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Teat Jesús tasaj nej: ―¿Aag ayaj itün menguiay cos indiüm mejawa, ngwüy aljane tasaj ic wüx xique? ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Quiaj tapiüng a Pilato: ―¿Neol jow xique mbich nop icona xique? Cos micual miíüt at montangtang miteaats monquiiüb ic miün niüng sajlüy. ¿Neol, cuane iranga? ―aw. ");
INSERT INTO huvNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Condom tasaj nej Teat Jesús: ―Ngome ningüy wüx aaga iüt cam sarang natang. Jondot wüx aaga iüt cam sarang natang xenipilan apmatsojow; ngome apmüjchiw ndeaan najmel teowixaw monajiüt tiül judíos. Nganüy cos ngwüy, ngome ningüy sarang natang ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilato tasaj nej: ―¿Naleaingue, ique nop minatang nenajiüt tiül nejiw ipiünga? ―aj nej. Quiaj tasaj nej Teat Jesús: ―Xique natang atnej lamepiüng quiaj. Áag wijquiatos tiünas wüx aaga iüt cam najüiquich cuane naleaing. Meáwan leawa andiümüw marangüw leawa naleaing, ajcüw ayaj apmandiümüw manguiayiw sandeac ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Quiaj tasaj nej a Pilato: ―¡Mbich jane ajaw cuane naleaing! ―aj nej. Ndoj mapiüng aag ayaj a Pilato, quiaj taw alinomb masaj nipilan, tapiüng: ―Xique sapiüng aaga naxey cam ngo majiür asoet. ");
INSERT INTO huvNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Icona ipiüngan alndom natsambiich nop najlüy tiül manchiüc wüx nangos nüt pascua. ¿Jow nganüy, indiüman natsambiich aaga naxey minatangana? ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Quiaj tepajüw tapiüngüw: ―¡Ngwüy, nde metsambiich aag ayaj! ¡Barrabás aptsajmbiüm! ―awüw. Pues aaga Barrabás quiaj, need nej. ");
INSERT INTO huvNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Condom a Pilato tapiüng majwüch Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ajcüwa soldados tapeatiw sats masoijquiw wüx omal Teat Jesús. At tasoijquiw nej tiül noic napixeran morada. ");
INSERT INTO huvNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Quiaj tapots mitsojow, tasajüw: ―¡Nganüy mbich ique minatang nenajiüt ocueaj nipilan judío! ―ajüw. Quiaj tapots maleambüw nej. ");
INSERT INTO huvNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Condom a Pilato taw alinomb, tasaj a nipilan: ―Jogüy lanawün miün mejawan, naleaing sasaj icon xique ngo naxom nicuajind nisoet wüx ombas nej ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Quiaj taw Teat Jesús, alwüx omal nej aaga nepeat sats, at almasooig morada napixeran. Quiaj tasaj nejiw a Pilato: ―¡Jogüy aaga naxey! ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Quiaj montangtang miteaats maquiüjpüw monjiür nadam nangaj iüm camüm majawüw ajntsop Teat Jesús, yajnguiatoj tiüt apajüw, tapiüngüw: ―¡Ich mandeow wüx cruz! ¡Ich mandeow wüx cruz! ―awüw. Pilato tasaj nejiw: ―Iquiüjpan, icona iyacan wüx cruz, cos xique ngo naxom cuane asoet aaga naxey cam ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ajcüwa nipilan judío tapiüngüw: ―Xicona salnajiüran poch tiül xenawijquian niüng apiüng netam mandeow cos awaiich, apiüng Micual nej Teat Dios ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Wüx a Pilato tanguiay aag ayaj, mbayat xeyay. ");
INSERT INTO huvNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Condom tajmel awan alinomb, tatün manguiay Teat Jesús: ―¿Nguiane neriowa? ―aj. Teat Jesús ngome tasaj nej nicuajind. ");
INSERT INTO huvNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Quiaj tasaj nej a Pilato: ―¿Neol ngo merndeaca? ¿Neol ngo mejaw xique alndom nayac ic wüx cruz, aton alndom natsambiich ique? ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Quiaj tasaj nej Teat Jesús: ―Ngwüy, nicuajind ngondom merang wüx ximbas sitiül Xeteat Dios ngo müüch ic merang. Naleaing sasaj ic, najntsop asoet aaga neyac xic tiül iwix ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ajan quiaj a Pilato tayamb nguineay alndom matsambiich Teat Jesús, pero ajcüwa monajiüt tiül judíos tepajüw napac, tapiüngüw: ―¡Sitiül apmetsambiich, ngo majüic ijneaj aweaag a César; cos jangantanej nendiüm marang minatangüy nenajiüt, aag ayaj ngo majneaj aweaag a César! ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Wüx tanguiay aag ayaj a Pilato tawün tiül iüm Teat Jesús. Condom nej tsotot niüng ajaw wüx asoeteran, tiül noic nden nenüt Gabata tiül ombeayiw nipilan judío. Aag ayaj amb apiüng niüng nequiand tiüt piedra. ");
INSERT INTO huvNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Wüx laliüc lembem nüt aaga nüt quiaj, oxep quiaj pascua, quiaj a Pilato tasaj ajcüwa nipilan judío: ―¡Jogüy minatang nenajiüt! ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Nejiw tepajüw napac, tapiüngüw: ―¡Iwün, iwün, ich mandeow wüx cruz! ―awüw. Quiaj tasaj nejiw a Pilato: ―¿Quia netam nayac wüx cruz aaga natang nenajiüt icueajiüna? ―aj nejiw. Quiaj montangtang miteaats tasajüw nej: ―¡Xicona ngo najiüran alinop minatang nenajiüt, áagan a César! ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Quiaj a Pilato tayac teowixaw nejiw Teat Jesús mayacüw wüx cruz, taquiüjpüw mamb. ");
INSERT INTO huvNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Teat Jesús tamb, tüjchiw mambitic a cruz. Taquiüjpüw mamb andüy tiül niüng nasoic omal mondeow. Tiül ombeayiw nejiw apiüngüw Gólgota. ");
INSERT INTO huvNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Quiaj tayacüw wüx cruz Teat Jesús maquiiüb alijpüw. Nop amb wüx miác nej, alinop amb wüx miquiamb nej; nganüy Teat Jesús amb pinawan. ");
INSERT INTO huvNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Condom a Pilato tarang acas poch mayacüch wüx omal a cruz. Aaga poch quiaj apiüng: “Jesús naw Nazaret, minatang nenajiüt ocueaj judíos.” ");
INSERT INTO huvNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Xeyay nipilan judío tateowüw aaga poch quiaj, cos niüng tayacüch wüx cruz Teat Jesús ngome miünquiaj, aton cos aaga poch tarangüch wüx ombeayaran hebreo, griego, at wüx latín. ");
INSERT INTO huvNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Pero ajcüwa montangtang miteaats tasajüw a Pilato: ―Nde meyac: “Minatang nenajiüt ocueaj judíos.” Leaw netam meyac: “Nej nepiüng minatang nenajiüt ocueaj judíos,” ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Quiaj tasaj nejiw a Pilato: ―Leaw lanarang landoj lanarang ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ajcüwa soldados wüx landoj mayacüw wüx cruz Teat Jesús, quiaj tayariw apix nej, tambajcüw apiquiw quiriw mayariw noicnoic quiriw. Condom tayariw a najal micamix nej, aag ayaj ngo majiür niüng ambeteay, najüyeran naw cawüx andüy tiüt. ");
INSERT INTO huvNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Quiaj tandeacüw nejeyéjan quiaj, tapiüngüw: ―Ngome apmambajcaats micamix nej, apmasüetiiüts wüx, majüic jane apmayar ―awüw. Atquiaj tajlüy cos landoj lamapiüng tiül Mipoch Teat Dios, niüng apiüng: “Tambajcüw sapix mayariw, tasüetiw majawüw jane apmayar xecamix”, aw. Atquiaj tarangüw soldados. ");
INSERT INTO huvNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Aliw quiaj niüng ajlüy a cruz mimüm nej Teat Jesús, at michiig mimüm nej; at müm María mintaj teat Cleofas, at müm María Magdalena. ");
INSERT INTO huvNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Teat Jesús wüx tajaw mimüm nej, at nop minipilan nej, aaga xeyay tandiüm alquiaj aton, quiaj tasaj mimüm nej: ―Müm, joyaj nganüy apmajlüy atnej micual ―aj. ");
INSERT INTO huvNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Condom quiaj tasaj aaga nop minipilan nej: ―Joyaj teat, nganüy apmajlüy atnej mimüm ―aj. Naw quiaj aaga nop minipilan nej taquiiüb mamb mimüm Teat Jesús andüy aniüng nej atnej majiür mimüm nej. ");
INSERT INTO huvNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Wüx landoj aag ayaj, nej lamajaw meáwan lamapalüch marang. Cos netam majlüy atnej apiüng wüx nej tiül Mipoch Teat Dios, quiaj tapiüng: ―Nind sanganeow yow ―aw. ");
INSERT INTO huvNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ajlüy quiaj nop xar chipiow nachich vino, quiaj tasocoj tiül noic esponja, aag ayaj atnej walang sap. Ndoj cas tayacüw wüx omal nots narix xiül mipüüig hisopo. Quiaj tayacüw wüx ombeay Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Teat Jesús wüx landoj machey aaga nachich vino, quiaj tapiüng: ―Canüy lanambich narang meáwan leawa tiünas narang ―aw. Quiaj manguieer omal nej; tayac miespíritu nej teowix Teat Dios; tanaámb andeow. ");
INSERT INTO huvNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Oxep quiaj pascua, y nipilan judío ngo mandiümüw macǘlan wüx cruz mondeow, cos aaga nüt axoodaran quiaj xeyay nangaj. Quiaj tatüniw ocueaj a Pilato majmbajüch oleajiw leaw monlüy wüx cruz para alndom mawüniw tiüt najen. ");
INSERT INTO huvNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Quiaj tambüw a soldados tajmbajüw oleajiw ajcüw tajmeliw wüx cruz maquiüjpüw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Pero wüx tapeayiw niüng ajlüy Teat Jesús, quiaj tajawüw landeow, taton ngo majmbajüw oleaj nej. ");
INSERT INTO huvNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Condom nop soldado tatil teombas micostil Teat Jesús naag nots lanza, quiaj taw quiej maquiiüb tiül yow. ");
INSERT INTO huvNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Jan tajaw meáwan aag ayaj teamandeac wüx; leawa andeac aag ayaj ajaw naleaing. Alndom mepiüngan icona aton naleaing. ");
INSERT INTO huvNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Meáwan aag ayaj tajlüy atnej lamapiüng tiül Mipoch Teat Dios wüx tapiüng: “Miolaats nej ngo majmbajaran”, maw. ");
INSERT INTO huvNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Aton apiüng tiül Mipoch Teat Dios: “Apmajawjawüw aaga naxey tatileran quiaj”, aw. ");
INSERT INTO huvNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Wüx landoj meáwan aag ayaj, quiaj teat José naw tiül cambaj Arimatea tamb majaw a Pilato matün ocueaj, müüch nej maquiiüb mamb Teat Jesús mamiüt. Pilato taneam, quiaj tawün maquiiüb mamb. Aaga José quiaj nop nej minipilan Teat Jesús, pero naleaing axotǘyan cos imbol mandüy monajiüt tiül judíos. ");
INSERT INTO huvNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","At teat Nicodemo, aaga tamb mandeac aweaag Teat Jesús noic ongwiiüts, nej tamb quiaj aton, ajoy mamb maseyme nimiow gajpowüw (30) kilo najmboc angan süüig naolüch omal tiül mirra maquiiüb áloes. ");
INSERT INTO huvNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Quiaj teat José maquiiüb teat Nicodemo taxainguiw, tawinchaw tiül noic püy najneajay, ayacüw wüx aaga najmboc angan süüig, cos atquiaj arangüw nipilan judío wüx apmamiütüw nop nandeow. ");
INSERT INTO huvNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Niüng tayacüw wüx cruz Teat Jesús, quiájan ajlüy acas owil nateaic xiül. Alquiaj noic oxiüt jayatsüy, nganaw mamiütaran quiaj nejinguind. ");
INSERT INTO huvNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Quiájan tayacüw Teat Jesús, cos aaga oxiüt quiaj ngome miünquiaj ajlüy, aton ajcan lami nangos nüt pascua ocueajiw judíos. ");
INSERT INTO huvNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ǘmban arraw domingo wüx aliün mexemem, quiaj tamb niüng ajlüy oxiüt müm María Magdalena, tajaw aaga piedra nayacüch mapal oxiüt ngo majlüy niüng tayacüch. ");
INSERT INTO huvNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Andilílan tiüt tamb majaw teat Simón Pedro maquiiüb alinop aaga xowüy andiüm nej Teat Jesús. Quiaj tasaj nejiw: ―Lamawüniw tiül oxiüt Teat Naxey, ngo majawaats nguiane tambüw mayacüw ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Camüm manguiayiw aag ayaj, quiaj tamb teat Pedro maquiiüb alinop minipilan Teat Jesús andüyiw niüng ajlüy oxiüt. ");
INSERT INTO huvNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ijpüéj tambüw acuiürrüw nóiquian, pero aaga alinop quiaj alwüx acuiür, tamong wüx ombas teat Pedro, ombas mapeay niüng ajlüy oxiüt. ");
INSERT INTO huvNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Quiaj tapiür majaw tiül. Tajaw aaga püy tan ajlüy quiaj; nej taton ngo majmel. ");
INSERT INTO huvNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Condom quiaj tapeay teat Simón Pedro andǘüban nej. Nej mbich nómban tajmel tiül oxiüt, tajaw aaga püy alquiaj. ");
INSERT INTO huvNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","At aaga püy nawincheran wüx omal Teat Jesús ngo majlüy nóiquian maquiiüb aaga alinoic püy; alpejchiüm pálwüx, tan ajlüy awinchay. ");
INSERT INTO huvNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Condom quiaj alinop minipilan Teat Jesús, aaga napeay ombas, tajmel tiül oxiüt aton. Wüx tajaw aag ayaj, aleáingan tajaw naleaing lapac. ");
INSERT INTO huvNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Cos ores quiaj nganaw majawüw leawa lamapiüng tiül Mipoch Teat Dios niüng apiüng Teat Jesús apmapac tiül mondeow. ");
INSERT INTO huvNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Condom ajcüwa ijpüw minipilan Teat Jesús quiaj, tandilileaw alinomb andüyiw aniüngüw nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Müm María wüx tapeay alinomb, tacǘlan mbeay oxiüt, tenguial ajiünts, tapiür majaw tiül oxiüt. ");
INSERT INTO huvNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Quiaj tajaw ijpüw ángeles alchetemoj niüng tayacüch Teat Jesús; nop amb wüx omal, alinop amb wüx oleaj, apixaw nejiw rajnüy. ");
INSERT INTO huvNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Quiaj tatüniw nej manguiayiw, tasajüw: ―Müm najtaj, ¿Neol tapots ijiüntsa? ―ajüw nej. Quiaj tasaj nejiw aaga najtaj: ―Cos lajwan aaga Teat Naxey, ngo najaw nguiane tamb mayacüch ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Wǘxan ndoj mapiüng aag ayaj, wantsat majaw wanopech nej. Quiaj majaw alembem quiaj Teat Jesús, pero nej ngo majaw majneaj sitiül aag ayaj Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Condom quiaj tasaj nej Teat Jesús: ―Müm najtaj ¿neol tapots ijiüntsa, jane teameyamba? ―aj nej. Müm María apiüng nej aag ayaj nop nerang najiüt quiaj. Quiaj tasaj: ―Teat, sitiül ique nerwün, isaj xic nguiane almeyac para namb naxaing ―aj. ");
INSERT INTO huvNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Quiaj tasaj nej Teat Jesús: ―¡María! ―aj nej. Müm María quiaj wantsat majaw nej, tasaj nej wüx ombeayiw nejiw, tiül hebreo: ―¡Raboni! ―aj. Aag ayaj wüx ombeayiw nejiw apiüng Nequiaach. ");
INSERT INTO huvNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Teat Jesús tasaj nej: ―Nde mesamb xic müm, cos nganaw namb sandüy niüng ajlüy Xeteat Dios. Quiür isajüw xenipilan, xique sanamb sandüy niüng ajlüy Xeteat, aag ayaj Miteatiün aton; niüng ajlüy Xedios, aag ayaj Midiosan aton ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Quiaj tamb müm María Magdalena masaj minipilan Teat Jesús nej landoj majaw Teat Jesús. Aton tapiüng meáwan leawa tasaj nej. ");
INSERT INTO huvNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Tíülan aaga nüt domingo quiaj, wüx langwiiüts, minipilan nej aliw tiül iüm canchiünoj; apalüw ombeay iüm cos imboloj mandüyiw monajiüt ocueaj judíos. Camüm majawüw Teat Jesús alembem pinawan nejiw. Quiaj tatepeay nejiw, tapiüng: ―Tamtámban ijlüyiüna ―aw. ");
INSERT INTO huvNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Wüx ndoj mapiüng aag ayaj, quiaj tüüch nejiw majawüw owix nej at micostil nej. Xeyay tapac omeajtsüw wüx tajawüw nej. ");
INSERT INTO huvNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Condom tandüy wüx matepeay nejiw alinomb. Tapiüng: ―Tamtámban ijlüyiün. Atnej Xeteat Dios tüüch xic niün, atanquiaj nganüy xique süüch icon meamban meáwan wüx aaga iüt cam ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Wüx ndoj mapiüng aag ayaj, quiaj tapep miíünd nej wüx ombasüw nejiw. Tasaj nejiw: ―Iyariün Nangaj Espíritu ocueaj Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Nganüy jangantanej leaw icona apmeajchiün macueat arang ngo majneaj, mewüniün wüx imeajtsan asoet nej, at Teat Dios aton apmawün wüx omeaats. Sitiül aljane ngo mandiüm macueat arang ngo majneaj, Teat Dios aton ngome apmawün wüx omeaats asoet nej ―aj nejiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tomás, aaga nasoic Cuüch, nej nop tiül ajcüwa gajpiüp (12) minipilan Teat Jesús, ngome tajlüy quiaj wüx tapeay Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Alacas minipilan Teat Jesús tasajüw nej: ―¡Landoj najawan Teat Naxey! ―ajüw nej. Quiaj tasaj nejiw a Tomás: ―Sitiül ngo najaw aóp owix nej niüng tapaparan clavos, sitiül ngo naxec tiül nots micual xiwix niüng tapaparan clavos; aton sitiül ngo naxec xiwix teombas micostil nej, nómban ngo nayar indeacan ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Wüx lamajiür ojpeacüw (8) nüt tatow ndoj aag ayaj, minipilan Teat Jesús canchiütoj alinomb tiül iüm; alquiaj a Tomás maquiüjpüw. Tan ajlüy palaw ombeay iüm, camüm majawüw Teat Jesús alembem pinawan nejiw, tatepeay nejiw, tapiüng: ―Tamtámban ijlüyiüna ―aw. ");
INSERT INTO huvNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Condom quiaj Teat Jesús tasaj a Tomás: ―Ijaw aop xiwix teat, ixec ningüy nots micual iwix, condom iwind iwix andüy ningüy, ixec teombas xecostil. Ipiüng naleaing, nde mechiw imeaats ―aj. ");
INSERT INTO huvNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Quiaj tapiüng a Tomás: ―¡Teat Naxey, Xeteat Dios! ―aw. ");
INSERT INTO huvNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Quiaj tasaj nej Teat Jesús: ―Tomás ¿neol, ajcan lamejaw xic tepiüng naleaing lasapaca? Najneajay apmajlüyiw jane apmapiüngüw naleaing lasapac masey ngo majawüw xic naag oniüjcüw ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Teat Jesús tarang xeyay cuajantanej ngome aag ajaraw, müüch majaw minipilan nej; pero aton ngome meáwan tarangüch tiül aaga nawiig cam. ");
INSERT INTO huvNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Nganüy meáwan leawa tarangüch tiül aaga nawiig cam, tarangüch para alndom mepiüngan naleaing Teat Jesús Micual Teat Dios nej; aton mepiüngan nej aaga Cristo lapiürang aliüc. Cos jangantanej leaw apmayar mapiüng naleaing aag ayaj, apmapac meáwan nüt. ");
INSERT INTO huvNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Wüx landoj aag ayaj, tejüiquichay alinomb Teat Jesús majawüw nej minipilan nej. Atcüy tajlüy wüx tajlüyiw mbeay nadam yow Tiberias. ");
INSERT INTO huvNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Cos acas minipilan nej ajlüyiw quiaj nóiquian, nop teat Simón Pedro, nop teat Tomás aaga nasoic Cuüch, alinop teat Natanael naw tiül cambaj Caná tiül iüt Galilea, at ijpüw micual teat Zebedeo, maquiüjpüw alijpüw minipilan nej. ");
INSERT INTO huvNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Condom tasaj nejiw teat Simón Pedro: ―Sanamb sandoc ―aj nejiw. Quiaj tasajüw nej: ―Ata xicona sanamban, tabaats ―ajüw nej. Quiaj tambüw, ambüw tiül nop müx. Aaga ongwiiüts quiaj ngo mandocoj nicuajind. ");
INSERT INTO huvNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Wüx ümb chiüjmbaw raw, quiaj majawüw Teat Jesús alembem mbeay yow. Naleaing nejiw ngo mateotsüw wüx sitiül aag ayaj Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Condom quiaj tasaj nejiw Teat Jesús: ―Xecualüw ¿tesapan indocona? ―aj nejiw. Quiaj tasajüw: ―Ngo nasapan ―ajüw. ");
INSERT INTO huvNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Quiaj tasaj nejiw Teat Jesús: ―Iyacan mindocon amb wüx miác otüeng müx, mbich apmesapan ―aj nejiw. Tarangüw atnej tasoiquiw. Ndoj ngondom maxainguiw mindocoj nejiw cos chipiow a cüet. ");
INSERT INTO huvNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Quiaj nop tiül nejiw, aaga xowüy andiüm nej Teat Jesús, tasaj teat Pedro: ―¡Aaga iün Teat Naxey! ―aj. Teat Pedro camüm manguiay aag ayaj, quiaj masooig micamix nej cos tasoond, tanaámb ajchic tiül yow. ");
INSERT INTO huvNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Condom ajcüwa aquiüjpüw nej taquiüjpüw mamb aaga müx andüy wüx iüt. Átan ndoc tanototoj mamb chipiow a cüet, cos ngome miünquiaj wüx iüt, ajiür maseyme coic miow (100) metros. ");
INSERT INTO huvNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Wüx tajtepiw wüx iüt, tajawüw olüic biümb quiaj. Alpiiüm wüx nop cüet, aton alquiaj pan. ");
INSERT INTO huvNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Quiaj tasaj nejiw Teat Jesús: ―Ijamiünan acas cüet leawa les ndot mesapan quiaj ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Quiaj teat Simón Pedro tajtep tiül müx macheed a ndoc manot andüy wüx iüt. Aaga ndoc ngo chiütam masey chipiüt tiül nadamdam cüet. Atüch coic miow ic miow gajparoob (153) cüet. ");
INSERT INTO huvNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Condom tasaj nejiw Teat Jesús: ―Macaron metiiüts ―aj nejiw. Nejinguind tiül nejiw ngo majntsop matüniw nej manguiayiw jane nej, cos lamajawüw nejay Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Quiaj tatüch nejiw Teat Jesús, tayar a pan müüch nejiw, at a cüet. ");
INSERT INTO huvNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Aag ayaj arojmbüw wüx ajüiquichay majaw nej minipilan nej, wüx landoj apac tiül mondeow. ");
INSERT INTO huvNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Wüx landoj üetiw, quiaj Teat Jesús tasaj teat Simón Pedro: ―Simón, micual teat Jonás ¿cuane ipiüng, indiüm xic, ngwüy ajntsop wüx indiüm meáwan aag ayaja? ―aj. Quiaj tapiüng teat Pedro: ―Teat, ique ijaw xique sandiüm ic ―aw. Quiaj Teat Jesús tasaj nej: ―Ijiürüw quicheech xesapüw ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Condom tandüy wüx masaj nej amb ijmbüw: ―Simón, micual teat Jonás ¿naleaing indiüm xic? ―aj nej. Quiaj teat Pedro tasaj nej: ―Teat, ique ijaw xique sandiüm ic ―aj nej. Quiaj tasaj nej Teat Jesús: ―Ijiürüw xesap ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Condom quiaj tasaj nej amb arojmbüw: ―Simón, micual teat Jonás ¿naleaingue indiüm xique? ―aj nej. Teat Pedro quiaj tamix omeaats ajcan lamasaj nej amb arojmbüw sitiül andiüm nej, quiaj tapiüng: ―Teat, ique ijaw meáwan cuajantanej; ique ijaw naleaing sandiüm ic ―aj. Tasaj nej Teat Jesús alinomb: ―Ijiürüw xesap. ");
INSERT INTO huvNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Naleaing naleaing sasaj ic, wüx aliün mermonguich, iquiáyan quiaj isooig ipix, iriümb leaw niüng indiüm; pero wüx apmertaxey pálwüx apmasooig ic tiül ipix, apmendic iwix, apmequiüraab niüng ngo mendiüm meamb ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Tasaj nej aag ayaj majüiquich nguineay netam mandeow teat Pedro, cos apmandeow wüx arang minajiüt Teat Dios. Ndoj mandeac aag ayaj, tapiüng: ―Indüüb xic tanaámb ―aj. ");
INSERT INTO huvNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Wüx wantsat teat Pedro, quiaj tajaw almandüüb nejiw aaga xeyay andiüm nej Teat Jesús, aaga leaw chetet aweaag nóiquian maquiiüb Teat Jesús wüx tetiw, wüx tatün manguiay: “Teat ¿jane apmayac ic teowixaw monajiüt?” maw. ");
INSERT INTO huvNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Teat Pedro wüx tajaw almandüüb nejiw aaga alinop quiaj, quiaj tasaj Teat Jesús: ―Teat ¿jowa neje aaga alinop quiaja? ―aj. ");
INSERT INTO huvNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Quiaj tasaj nej Teat Jesús: ―Sitiül xique nandiüm ngo mandeow, aliün mapac wüx sanandilil alinomb, ¿neol, cuane imbiche? Ique tanaámb indüüb xic ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Condom aaga poch quiaj tejüiquichay manguiayiw meáwan monyar andeac Teat Jesús, tapiürang aaga nop minipilan nej ngome apmandeow. Pero naleaing Teat Jesús ngo mapiüng lango mandeow. Nej tapiüng: “Sitiül xique nandiüm ngo mandeow, aliün mapac wüx sanandilil alinomb, ¿neol, cuane imbich?”, aw. ");
INSERT INTO huvNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Nej aaga nop tiül minipilan Teat Jesús teamarang aaga nawiig cam. Meáwan aag agüy tajaw, tanguiay. Atquiaj alndom majawaats meáwan leaw tarang, aag ayaj naleaing. ");
INSERT INTO huvNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Aliün majlüy xeyay leaw tarang Teat Jesús. Naleaing sapiüng sitiül apmarangüch wüx nawiig meáwan leawa tarang, ngome apmajoy aaga iüt cam. Atanquiaj tajlüy. Amén.");
INSERT INTO huvNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teat Teófilo, tiül aaga nawiig tarangas ninguinüt tasajas ic meáwan leaw tarang Teat Jesús, at leaw tapots maquiaach. ");
INSERT INTO huvNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Ndójwüx tasajas ic nguineay tamb andüy cawüx tiül cielo. Naleaing wüx nganaw mamb andüy tiül cielo tarriiüd miapóstoles nej. Condom tasaj nejiw nguineay netam marangüw, atnej tasaj nej Nangaj Espíritu ocueaj Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Condom tandeow, pero naleaing wüx tapac alinomb tejüiquichay majawüw nej minipilan nej tiül ic miow (40) nüt. Atquiaj tarang majaraw naleaing nej almapac. At tasaj nejiw nguineay ajlüy tiül micambaj Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Wüx Teat Jesús aliün maquiiüb nejiw, tasaj nejiw nde mawüw tiül Jerusalén, tapiüng: ―Icüliün aag leaw lamapiüng Teat Dios aliüc miün apmajlüy. Aag ayaj landoj lanasaj icon ninguinüt. ");
INSERT INTO huvNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Naleaing Juan tüüch yow nipilan, pero aag ayaj náagan yow. Nganüy icona alningüy alacas nüt apmeyariün Nangaj Espíritu ocueaj Teat Dios ―aw. ");
INSERT INTO huvNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Condom alinoic nüt wüx aliün maquiüjpüw Teat Jesús, tatüniw manguiayiw: ―Teat, ¿nganüy nüt cam apmeaach majlüyiiüts wüx micambajaats Israel alinomba? ―ajüw. ");
INSERT INTO huvNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Teat Jesús tasaj nejiw: ―Icona ngo metam mejawan ngow, ngün nüt apmajlüy aag ayaj. Cos néjan quiaj Teat Dios ajaw ngow apmüüch majlüy aag ayaj. ");
INSERT INTO huvNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Icona apmeajndiün Nangaj Espíritu ocueaj Teat Dios majlüy wüx imbasan, quiaj alndom merangan cuajantanej. Apmemelichan mendeacan wüx xique naw ningüy tiül cambaj Jerusalén. At apmeamban tiül meáwan cambaj tiül Judea, at meáwan tiül Samaria. At apmeamban meáwan tiül palpálwüx cambaj wüx iüt ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Condom wüx Teat Jesús landoj mapiüng aag ayaj, tanaámb amb andüy cawüx tiül cielo, teamajawüw nej. Ndoj tajngot noic oic taxot nej, lango maxomüw majawüw. ");
INSERT INTO huvNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Nejiw tealeámban majawüw andüy cawüx niüng amb Teat Jesús, quiaj tajawüw ijpüw teat monxey alembemoj niüng ajlüyiw nejiw, xowüy larraw apixaw nejiw. ");
INSERT INTO huvNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Condom tendeacüw masajüw nejiw, tapiüngüw: ―Teat monxey monaw Galilea ¿neol teleámban lembemeron ningüy mejawan andüy cawüxe? Cos aaga Teat Jesús les ndot mejawan aw niüng ijlüyiün amb andüy cawüx tiül oic quiaj, atquiaj aliüc alinomb wüx aliüc imiün tiül cielo ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Condom quiaj tandilileaw andüyiw Jerusalén imiünüw wüx tiüc nasoic mitiüc Olivos. Aaga tiüc quiaj ngome miünquiaj ajlüy naw Jerusalén; ajiür atonej alndom majüyiw wüx noic nüt axoodaran. ");
INSERT INTO huvNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Nejiw wüx tapeayiw tiül cambaj Jerusalén, quiaj tajtepiw andüyiw cawüx tiül amb ijpüw iüm niüng axojtüw Pedro, Jacobo, Juan, Andrés, Felipe, Tomás, Bartolomé, Mateo, Jacobo micual Alfeo, Simón nasoic Zelote, at a Judas michiig Jacobo. ");
INSERT INTO huvNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Meáwan nejiw noic nej omeajtsüw tanaámb canchiüjow quiaj matajcüw orar, aquiüjpüw michiig Teat Jesús, at a María mimüm nej, aton alacas montaj. ");
INSERT INTO huvNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Noic nüt wüx tajlüyiw quiaj, atüch maseyme acoic miow nimiow (120) nipilan, quiaj witiüt a teat Pedro masaj nejiw, tapiüng: ");
INSERT INTO huvNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","―Xecojow xechijquiaw, naleaing tajlüy meáwan atnej apiüng tiül Mipoch Teat Dios tarang teat David, wüx Nangaj Espíritu tambeol nej mapiüng nguineay apmarang a Judas, aaga nequiiüb monsap Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Cos Judas tateoraw tiül naquiüjpan, at tajlüy tiül marang aaga najiüt sarangan. ");
INSERT INTO huvNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Aaga Judas quiaj, tamb mangal noic iüt naag mitomiün nej, aag tangüyeran wüx tarang aaga xeyay ngo majneaj quiaj. Condom tamb terrondüy onic, tandeow. Ndoj tajmiüc mojcoj tiüt, tajpoet otüeng nej, taw meáwan mixiüt aonts nej. ");
INSERT INTO huvNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Meáwan nipilan moncül Jerusalén tanguiayiw nguineay tajlüy. Áag tüjchiw manüt aaga iüt quiaj Acéldama. Aaga poch Acéldama quiaj, apiüng Miíüt Quiej. ");
INSERT INTO huvNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","’Cos larangüch tiül Mipoch Teat Dios tiül Salmo, apiüng: Ich majlǘyan aaga iüt niüng acül nej, nde macül quiaj nejinguind, aw. At aton tiül alinoic Salmo apiüng: Ich majmel alinop marang ingow nej, aw. ");
INSERT INTO huvNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","’Nganüy netam mayacaats nop naxey leaw almaquiiüb icoots meáwan nüt wüx Teat Jesús almaquiiüb icoots, ");
INSERT INTO huvNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","ajan wüx a nüt Juan tüüch yow Teat Jesús, ndójwüx quiaj Teat Jesús tamb andüy tiül cielo. Cos netam maquiüjpaats alinop leaw naleaing tajaw Teat Jesús nguineay tapac alinomb ―aw a Pedro. ");
INSERT INTO huvNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Quiaj tayacüw ijpüw monxey náwan tiül nejiw, nop José nasoic Barsabás, at ajiür alinoic minüt nej nasoic Justo. At tayacüw alinop nenüt Matías. ");
INSERT INTO huvNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ndoj, quiaj tatajcüw orar, tapiüngüw: ―Xeteatiün Dios, ique ijaw tiül omeaats meáwan nipilan, nganüy iich majüic najawan ngün lamerriiüd tiül ajcüwa ijpüw cam. ");
INSERT INTO huvNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Netam alinop majmel marang apóstol, cos aaga Judas tacueat aaga najiüt quiaj wüx tarang aaga nadam nisoet, ndoj tamb tiül aaga xeyay ngo majneaj niüng atüch nej mamb ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ndoj, quiaj tasüetiw jane nop tiül nejiw, quiaj tajawüw Matías netam marang. Quiaj tateoraw tiül ajcüwa gajpanop (11) apóstoles. ");
INSERT INTO huvNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Wüx tatüch a nüt, nangos nüt nasoic Pentecostés, meáwan minipilan Teat Jesús alxenenguemoj nóiquian. ");
INSERT INTO huvNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Camüm manguiayiw aliüc noic neterriür napac imiün tiül cielo, atnej aterriür napac iünd. Aaga neterriür quiaj tajmel tiül iüm niüng alchetemoj. Meáwan monlüy quiaj tanguiayiw. ");
INSERT INTO huvNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Quiaj tajawüw atnej xeyay oniw biümb, ajcüw ayaj tajmiüc wüx ombasüw anopnopoj. ");
INSERT INTO huvNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Meáwan monlüy quiaj tajlüy wüx ombasüw nejiw Nangaj Espíritu ocueaj Teat Dios. Ndoj tapots andeacüw pálwüx ombeayaran leaw tüüch nejiw Nangaj Espíritu mandeacüw. ");
INSERT INTO huvNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Tiül aaga nüt quiaj, aliw tiül Jerusalén xeyay nipilan judío, monyamb Teat Dios monaw tiül palpálwüx cambaj wüx iüt. ");
INSERT INTO huvNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Wüx tanguiayaran aaga neterriür quiaj, quiaj sonongotoj quiaj xeyay nipilan. Mbayatoj xeyay wüx tanguiayiw andeacüw ombeayiw nejiw meáwan anopnop minipilan Teat Cristo. ");
INSERT INTO huvNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Xeyay mbayatoj majawüw aag ayaj, quiaj tesajayej, tapiüngüw: ―¿Neol, ngome monaw Galilea nejiw ajcüwa teandeacüw quiaja? ");
INSERT INTO huvNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Neol, nguineay andeacüw ombeayiiütsa, leaw andeacaats nde ajngotoots miüna? ");
INSERT INTO huvNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Cos alningüy palpálwüx nipilan, altiül monaw Partia, monaw Media, monaw Elam, monaw Mesopotamia, monaw Judea, monaw Capadocia, monaw Ponto, monaw Asia, ");
INSERT INTO huvNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","monaw Frigia, monaw Panfilia, monaw Egipto, at monaw tiül Africa niüng ajlüy cambaj Cirene. Alningüy monjüy miün nipilan naw Roma. Altiül nejiw wijquian ningüy judíos nejiw; altiül aton nipilan ngome judío leaw lamayambüw Teat Dios aton. ");
INSERT INTO huvNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","At alningüy monaw Creta, at monaw Arabia. Pero nganüy meáwan icoots ranüy manguiayiiüts teamandeacüw ombeayiiüts, nguineay Teat Dios lamarang xeyay najneaj leaw ngome áag ajaraw ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Cos xeyay mbayajow, ngo majawüw cuane najlüy, áag tesajayej nejeyéjan quiaj, apiüngüw: ―¿Cuane aag ayaja? ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Nganüy altiül itsojayéjan, tapiüngüw: ―Nangüniw, amongochiw wüx anganeowüw vin ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ndoj Pedro, quiaj tamong maquiiüb ajcüwa gajpanop (11) minipilan Teat Jesús, lembemoj niüng ajlüy nipilan. Condom tendeac napac manguiayiw, tasaj nejiw: ―Teat cambaj Israel, at meáwan leawa jayats mapeay tiül Jerusalén, nganüy inguiayiün leaw sanasaj icon: ");
INSERT INTO huvNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ajcüwa monxey teamenguiayiün andeacüw cam ngome nangüniw atnej icona ipiüngan. Cos nganüy les tatüch pinawan ajüy nüt. ");
INSERT INTO huvNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Aaga leaw tenguial mejawan quiaj, aag ayaj lamapiüng tiül Mipoch Teat Dios, tiül nawiig tarang Joel, aaga nendeac andeac Teat Dios, cos apiüng: ");
INSERT INTO huvNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Teat Dios apiüng: Alningüy alinoic nüt, sanüjchiw mayariw Nangaj Xeespíritu meáwan nipilan; quiaj micualan monench at monüx apmandeacüw sandeac, monguich sanüüch maxomüw omeajtsüw leaw ajawüw atnej aümiw, y montangtang ombas nipilan sanüjchiw maxomüw omeajtsüw wüx aümiw. ");
INSERT INTO huvNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Wüx aaga nüt quiaj, sanüüch mayariw Nangaj Xeespíritu meáwan monrang xenajiüt, monxey at montaj; condom nejiw aton apmandeacüw sandeac. ");
INSERT INTO huvNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Sanarang ateócan cawüx tiül cielo majaraw, tiüt wüx iüt sanarang cuajantanej leaw ngomeaag ajaraw. Apmajlüy xeyay quiej, apmajlüy xeyay biümb, at apmajlüy xeyay nasop. ");
INSERT INTO huvNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Quiaj a nüt lango merraj, apmajlüy pojniün, at a caaw apmacants atnej quiej. Aag ayaj apmajlüy wüx laliüc matüch a najneajay nüt wüx apmandilil Teat Naxey. ");
INSERT INTO huvNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Meáwan nipilan leaw apmayambüw Teat Dios, matüniw Teat Dios mawün nejiw wüx asoetiw, apmawüw wüx, aw. ");
INSERT INTO huvNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","’Teat cambaj Israel, inguiayiün leaw sanasaj icon: Icona tejawan aaga Teat Jesús naw Nazaret tarang xeyay ateócan wüx tajlüy ningüy maquiüjpaats. Tajüic naleaing Teat Dios neech nej miün, cos tambeol nej marang xeyay cuajantanej, leaw icona tejawan aton. ");
INSERT INTO huvNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Condom tayacüch tiül iwixan merangan wüx leaw tendiüman. Atquiaj netam majlüy, para majlüy atnej lamapiüng Teat Dios. Icona teyacan teowixaw nipilan monrang ngo majneaj, tesajanüw mayacüw wüx cruz mandeow. ");
INSERT INTO huvNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Naleaing Teat Dios tapacüüch nej alinomb, tawün nej tiül mondeow, cos nej ngondom macül niüng acül mondeow. ");
INSERT INTO huvNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Teat David tanomb tandeac wüx nej tiül minawiig nej, tapiüng: Xique tajawas Teat Dios tanaámb almaquiiüb xic; cos nej alwüx xeác, ngo nimbol nandüy nicuajind. ");
INSERT INTO huvNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Xeyay apac ximeaats, ngo paxiüm nandeac wüx aag ayaj. At ngo napiüng wüx masey nandeow, cos sanapac alinomb. ");
INSERT INTO huvNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Ique ngome apmecueat xic tiül niüng acüliw mondeow, apmepacüüch xic alinomb. Ngome apmeaach majmboc xecuerpo, cos nangaj micual xic. ");
INSERT INTO huvNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ique Teat, teaach xic najaw ngün a tiiüd amb andüy niüng apacaran meáwan nüt. Apmeaach mapac ximeaats cos sanajlüy niüng ijlüy, aw. ");
INSERT INTO huvNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","’Teat monxey micual iüt, inguiayiün. Aaga miteatiiüts David naleaing tandeow tamiüraad; mioxiüt nej alningüy ajawaats nganüy nüt cam aliün majlüy. ");
INSERT INTO huvNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Naleaing cos nej nop nej nendeac andeac Teat Dios tajaw naleaing apmajlüy leaw tasaj nej Teat Dios, nguineay Teat Cristo aliüc miün apmajlüy naw tiül micual micual nej. Aag ayaj apchetem niüng chetej nej, apmarang natang nenajiüt. ");
INSERT INTO huvNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Teat David, cos tajaw aag ayaj, áag tandeac wüx nguineay apmapac alinomb Teat Cristo, ngo macül tiül niüng acüliw mondeow, at micuerpo nej ngome apmajmboc. ");
INSERT INTO huvNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Nej aaga Jesús quiaj, Teat Dios tapacüüch nej alinomb. Meáwan xicona tajawasan naleaing aag ayaj. ");
INSERT INTO huvNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Teat Dios taquiiüb nej mamb andüy tiül cielo marang natang quiaj. Nej lamüünd aaga Nangaj Espíritu ocueaj Teat Dios leawa tasoic apmüünd. Nganüy lamüüch miün. Meáwan aaga leaw ijawan quiaj, leaw inguiayiün nganüy cam, aag ayaj Nangaj Espíritu ocueaj Teat Dios nerang. ");
INSERT INTO huvNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Teat David ngo mapac alinomb mamb tiül cielo, pero nej tapiüng: Teat Dios tasaj a Teat Naxey: “Cheter ningüy amb wüx xeác, ");
INSERT INTO huvNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","leaw ndoj nayac moncüy majaw ic, melembech wüx ileaj”. ");
INSERT INTO huvNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","’Nganüy ich manguiay meáwan micual iüt Israel, aaga Teat Jesús tembiyan wüx cruz, Teat Dios lamayac nej nganüy marang natang, cos nejay aaga Cristo ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Wüx tanguiayiw aag ayaj ajcüwa nipilan quiaj, tayajcüw tiül omeajtsüw nejiw xeyay ngo majneaj arangüw. Quiaj tasajüw a Pedro y alacas apóstoles: ―Teat monxey, jow nganüy ¿cuane sanarangana? ―ajüw. ");
INSERT INTO huvNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Quiaj tasaj nejiw a Pedro: ―Ich leaam imeajtsan xeyay ngo majneaj irangan, nde nganüy irangan najneaj. Ndoj iyariün yow meáwan inopnopon wüx minüt Teat Jesucristo, majüic laáw isoetiün. Quiaj Teat Dios apmüüch meyariün Nangaj Miespíritu nej. ");
INSERT INTO huvNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Cos Teat Dios lamapiüng apmüüch miün Nangaj Miespíritu nej müüch icon, müüch micualan, at meáwan leaw apmayamb Teat Dios alinoic nüt. Cos aag ayaj apmüjndiw meáwan nipilan leaw Miteatiiüts Dios apmapaj miünüw ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Condom tasaj nejiw xeyay wüx aag ayaj, tapaj nej ocueajiw, tapiüng: ―Iyamban Teat Dios, isajan mawün isoetiün, cos atquiaj alndom meriowan tiül ajcüwa nipilan monrang ngo majneaj quiaj ―aw. ");
INSERT INTO huvNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Condom meáwan leawa tayariw, at leawa tayacüw wüx omeajtsüw andeac teat Pedro tayariw yow. Aaga nüt quiaj tajlüyiw xeyay jayats monyar andeac Teat Dios, atüch maseyme arej mil nipilan. ");
INSERT INTO huvNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Nejiw tanaámb arangüw atnej taquiajchiw nejiw miapóstoles Teat Jesús. Tajlüyiw nóiquian maquiüjpüw meáwan monyar andeac Teat Dios, tatajcüw orar, at tajineaw a pan müetiw nóiquian para leaam omeajtsüw wüx neol tandeow Teat Cristo. ");
INSERT INTO huvNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Meáwan nipilan xeyay mbayatoj, cos minipilan Teat Jesús tarangüw xeyay ateócan, xeyay cuajantanej leaw ngome aag ajaraw. ");
INSERT INTO huvNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Meáwan leaw tayariw andeac Teat Jesús tajlüyiw nóiquian. At meáwan leaw almajiürüw tacanchichaw nóiquian. ");
INSERT INTO huvNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Wüx anüjpiw iüt, iüm, tengwüy cuajantanej leaw ajiürüw, ajineaw ombeat müjchiw anopnop leaw netam nejiw. ");
INSERT INTO huvNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Nejiw ngo macueatiw ambüw canchiümoj tiül nadam nangaj iüm. At tanaámb canchiüjow nóiquian müetiw pan aniüngüw nejiw. Ajlüyay apac omeajtsüw, xeyay ajneaj omeajtsüw. ");
INSERT INTO huvNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Nejiw palǘyan tandeacüw najneaj wüx Teat Dios, at meáwan nipilan ajneaj majaw nejiw. Meáwan nüt Teat Dios teamayac wüx majlüy xeyay monyar andeac nej. ");
INSERT INTO huvNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Noic nüt teat Pedro maquiiüb teat Juan tambüw nóiquian andüyiw tiül nadam nangaj iüm, andüy wüx nchejliow nüt, ores atajcüch orar. ");
INSERT INTO huvNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Alquiaj nop naxey necoex nde wijquiaw. Meáwan nüt aquiüraab mamb machetecharan mbeay nadam nangaj iüm metüneay, matün ocueaj jane apmajmel tiül a nadam nangaj iüm. Aaga ombeay nangaj iüm quiaj nasoic Natsajüy Ombas. ");
INSERT INTO huvNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Aaga necoex quiaj, wüx tajaw a Pedro y Juan laambüw apmajmeliw tiül nadam nangaj iüm, quiaj tatün nej ocueajiw. ");
INSERT INTO huvNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Quiaj lembetoj majawüw nej. Condom tasaj nej a Pedro: ―Ijaw xicon ―aj. ");
INSERT INTO huvNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Quiaj tajaw nejiw apac omeaats, teamacül cuane apmüjchiw. ");
INSERT INTO huvNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Quiaj a Pedro tasaj nej: ―Ngo najiür plata, ngo najiür oro; pero naleaing leawa sajiür sanüüch ic: wüx minüt Teat Jesucristo naw Nazaret, sasaj ic witiür ijüy ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Quiaj teat Pedro tasap miác owix nej mawitich. Andǘüban tajneaj oleaj nej, at nic oleaj nej. ");
INSERT INTO huvNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Condom ajchic cawüx witiow lombom, quiaj tajüy. Ndoj tajmel tiül nadam nangaj iüm maquiiüb nejiw, teajüy, teajchic, teamapiüng najneajay lamarang Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Meáwan nipilan tajawüw nej lajüy, at teamapiüng najneajay lamarang Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Tajawüw nejay aaga naxey quiaj lambójan chetej metüneay mbeay nadam nangaj iüm nasoic Natsajüy Ombas, áag mbayatoj xeyay wüx tajawüw lajneaj. ");
INSERT INTO huvNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Aaga naxey lajneaj micoex quiaj, ngo matsambiich a Pedro y Juan. Condom meáwan nipilan mbayatoj, tambüw acuiürrüw majawüw nejiw tiül minden iüm nasoic ocueaj Salomón. ");
INSERT INTO huvNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pedro wüx tajaw ajcüwa nipilan quiaj, tapiüng: ―Teat cambaj Israel, ¿Neol mbayateron wüx aag ayaja? ¿Neol tejawjawan xicona? Atnej ajüic ipiüngan xicona süjchiün majneaj aaga naxey quiaj, atnej xicona süjchiün majüy nde ajneaj ximeajtsan. ");
INSERT INTO huvNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ngwüy, xicona ngondom narangan aag ayaj. Teat Dios nerang aag ayaj, Midios miteatiiüts Abraham, Midios teat Isaac, Midios teat Jacob, at Midiosüw mixejchiiüts monlüy tanomb. Nejay aaga Teat Dios quiaj tataag majneaj aaga naxey cam, para alndom mayarich andeac Teat Jesús, aaga Micual Nej. Aag ayaj icona teyacan teowix monajiüt mandeow. Wüx tandiüm a Pilato matsambiich, icona ngome tendiüman, tepiüngan ich mandeow. ");
INSERT INTO huvNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Icona ingow itüniün tsajmbiüm aaga nangaj nerang najneaj quiaj, tetüniün maw wüx aaga nerang ngo majneaj nembiy nipilan. ");
INSERT INTO huvNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Atquiaj terangan, tembiyan aaga tenguial mepacüüch meáwan leaw almajlüy. Pero naleaing Teat Dios tapacüüch nej alinomb. Aag ayaj xicona tajawasan naleaing. ");
INSERT INTO huvNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Nganüy aaga naxey cam leaw ijawan, Teat Dios tataag nej majneaj, cos sayacan ximeajtsan wüx Teat Jesús, ngo nachiwean ximeajtsan. Áag nganüy ijawan nej lajneaj nómban. ");
INSERT INTO huvNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","’Teat monxey, xique sajaw naleaing icona wüx tembiyan Teat Jesús mequiüjpan minatangan monajiüt, terangan aag ayaj cos ngo mejawan nicuajind; ipiüngan najneaj temerangan. ");
INSERT INTO huvNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Quiaj tajlüy atnej tanomb lamapiüng Teat Dios. Cos meáwan mondeac andeac nej tapiüngüw aaga Cristo, Micual Teat Dios, apmamongoch xeyay ngo majneaj. ");
INSERT INTO huvNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Nganüy ich leaam imeajtsan naleaing xeyay ngo majneaj temerangan. Indililean iyamban Teat Dios cos nej alndom mawün isoetiün. Quiaj Teat Dios apmüüch icon mapac imeajtsan, ");
INSERT INTO huvNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","wüx apmüüch miün Teat Jesucristo, aaga lamapiüng apmüüch miün mambeol icon. ");
INSERT INTO huvNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Nganüy naleaing nej netam macül tiül cielo, leaw atüch a nüt wüx Teat Dios apmataag majneaj meáwan ngo majneaj, atnej lamapiüngüw mondeac andeac nej najlüyiw tanomb. ");
INSERT INTO huvNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Teat Moisés aton tasaj mixejchiiüts, tapiüng: “Teat Dios apmayac nop nendeac andeac nej imiün tiül icona, atnej tayac xic. Netam menguiayiün meáwan leaw apmasaj icon. ");
INSERT INTO huvNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Cos meáwan nipilan leaw ngo mayar andeac aaga nendeac andeac Teat Dios quiaj, apmajwan nómban, ngondom macül tiül micambaj nej.” ");
INSERT INTO huvNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","’Meáwan mondeac andeac Teat Dios leaw tajlüyiw tanomb ajan wüx Samuel tapiüngüw wüx aaga leaw almajlüy nganüy cam. ");
INSERT INTO huvNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Icona micual icon Israel, atnej tajlüyiw mondeac andeac Teat Dios. At ijlüyiün tiül aaga poch Teat Dios tüüch mixejchiiüts, cos tasaj Abraham: “Meáwan nipilan wüx iüt apmaxomüw monajneaj wüx ombas micual leaw aliüc miün apmajlüy.” ");
INSERT INTO huvNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Teat Dios wüx tapacüüch alinomb Micual Nej, mbas tüüch miün mambeol icon, müüch icon mejiüran monajneaj; aton müüch icon inopnopon mecueatiün irangan ngo majneaj ―aj nejiw a Pedro. ");
INSERT INTO huvNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pedro y Juan tenguialeámban mandeacüw aag ayaj masajüw nipilan, quiaj ajngotoj miteaats aquiüjpüw minatang monjiür nadam nangaj iüm, aton aquiüjpüw saduceos. ");
INSERT INTO huvNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Quiaj tajcüyiw xeyay, cos Pedro y Juan tenguial maquiajchiw nipilan, teamasajüw mondeow apmapacüw alinomb cos Teat Jesús tapac alinomb. ");
INSERT INTO huvNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Quiaj tasaparanüw maquiibaranüw mamb mayacaranüw tiül manchiüc cos langwiiüts. Tawüniw amb alinoic nüt. ");
INSERT INTO huvNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Pero naleaing xeyay nipilan leaw tanguiayiw andeacüw Pedro y Juan tayariw Mipoch Teat Dios. Ajcüw ayaj atüch maseyme acoquiaw mil monxey. ");
INSERT INTO huvNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Larraw tiüt amb alinoic nüt, quiaj sonongotoj tiül Jerusalén meáwan monajiüt ocueajiw judíos, aquiüjpüw montangtang monajiüt tiül nejiw, at mondüy wüx aaga poch tüünd Moisés. ");
INSERT INTO huvNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Aquiüjpüw aton aaga minatang miteaats nenüt Anás, aquiüjpüw Caifás, Juan, Alejandro, at meáwan acualajtsüw natangtang miteaats. ");
INSERT INTO huvNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Quiaj tapiüngüw majanüw a Pedro y Juan. Wüx lapeayiw, quiaj tamongochiw lembemoj pinawan. Ndoj cas tatüniw manguiayiw, tasajüw: ―¿Nguiane meyariün minajiütan merangan aag ayaja? ¿Ngwüy jane nesaj icon merangana? ―ajüw. ");
INSERT INTO huvNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Teat Pedro, ambeol nej Nangaj Espíritu ocueaj Teat Dios, quiaj tasaj nejiw: ―Teat Xan monajiüt, montangtang monajiüt tiül Israel: ");
INSERT INTO huvNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Icona lametüniün menguiayiün xicon wüx aaga najneaj larangüch wüx ombas nop naxey lajneaj micoex, nguineay tajneaj. Najneaj, sanapiüngan. ");
INSERT INTO huvNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Nganüy meáwan icona inguiayiün, ich manguiay aton meáwan cambaj Israel. Aaga naxey alningüy timbasan cam, tajneaj wüx minüt Teat Jesús naw Nazaret, áag icona teyacan wüx cruz, ndoj Teat Dios tapacüüch alinomb. ");
INSERT INTO huvNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Aaga Teat Jesús quiaj, nejay aaga piedra icona monrang iüm teloxiün ninguiün, nganüy laíün marang xeyay netam piedra tiül oxing iüm. ");
INSERT INTO huvNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Nejinguind alinop ngondom mawün asoeteran; cos Teat Dios ngo mayac alinop ningüy wüx aaga iüt cam leaw alndom mawün asoetiiüts, áagan Teat Jesús alndom ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Monajiüt wüx tajawüw a Pedro y Juan nómban ngo mimboloj wüx andeacüw, at tajawüw nejiw ngome nequiaachayej, ajlüyiw at nejiw jangantanej, quiaj mbayatoj. At tajawüw ajcüw ayaj taquiüjpüw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Cos aaga naxey lajneaj micoex nej alembem niüng ajlüyiw nejiw, quiaj lango majiürüw cuane mapiüngüw. ");
INSERT INTO huvNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Quiaj tasoiquiw a Pedro y Juan mawüw tiül moncanchiün para alndom mandeacüw wüx nguineay apmarangüw. ");
INSERT INTO huvNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Quiaj tapiüngüw: ―¿Cuane apmarangaats wüx ombasüw ajcüwa monxey quiaja? Cos naleaing nadam ateócan lamarangüw, aag ayaj lajüic, lamanguiayiw meáwan nipilan moncül tiül Jerusalén. Icootsa ngondom mapiüngaats ngo maleaing. ");
INSERT INTO huvNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Nganüy, ngana majüy aag ayaj manguiay cambajiüt, netam maliquiajtsüw mambolojchiiüts, masajaats nde mandüyiw wüx alinomb mandeacüw wüx minüt aaga Jesús quiaj ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ndoj, quiaj tapajüw a Pedro y Juan maliquiaw, tasajüw nómban ngondom mandeacüw, aton ngondom maquiajchiw nipilan wüx Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Quiaj tapiüngüw a Pedro y Juan: ―Nganüy ipiüngan teat, ¿quia najneaj majaw Teat Dios nayariün indeacana, ngwüy nayariün andeac neje? ");
INSERT INTO huvNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Naleaing xicona ngondom nacueatiün nandeacan leaw lanajawan, leawa lananguiayiün ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Quiaj tandüyiw wüx maliquiaw alinomb, tasajüw apmamongochiw xeyay ngo majneaj sitiül mandilileaw marangüw alinomb. Ndoj tatsambijchaw, cos ngo maxomüw nguineay müjchiw mamongochiw ngo majneaj. At imboloj mandüyiw nipilan, cos meáwan nipilan tapiüngüw Teat Dios netaag majneaj aaga necoex quiaj. ");
INSERT INTO huvNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Pues aaga naxey lajneaj micoex quiaj, lamong ic miow (40) mineat nej. ");
INSERT INTO huvNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Pedro y Juan, wüx landoj tsajmbiüjow, quiaj tambüw majawüw aquiüjpüw nejiw. Tapiüngüw meáwan leaw tasajüw nejiw montangtang miteaats at montangtang monajiüt tiül nangaj iüm. ");
INSERT INTO huvNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Wüx landoj manguiayiw aag ayaj, quiaj tatajcüw orar, tasajüw Teat Dios noic nej omeajtsüw, tapiüngüw: ―Xeteatiün Dios, ique terang cielo, terang iüt, terang ndec, at terang meáwan leaw almajlüy. ");
INSERT INTO huvNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Naleaing nde tanomb tapiüng a teat David, aag nerang minajiüt, cos timbeol nej marang wüx nawiig nguineay ipiüng. Nej tapiüng: ¿Neol tapots ajcüyiw meáwan nipilan tiül meáwan cambaja? ¿Neol tamb wüx omeajtsüw leaw nómban ngondom marangüwa? ");
INSERT INTO huvNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Meáwan monajiüt monaw tiül palpálwüx cambaj sonongotoj, at montangtang tiül cambaj canchiütoj nóiquian, majcüyiw majawüw Teat Dios, aton majcüyiw majawüw Teat Cristo, aw. ");
INSERT INTO huvNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","’Cos naleaing canchiütoj tiül aaga cambaj cam a Herodes maquiiüb a Poncio Pilato maquiüjpüw nipilan judío, at pálwüx nipilan ngome judíos, majcüyiw majawüw nangaj micual, aaga Teat Jesús, leaw lameyac marang minajiüt. ");
INSERT INTO huvNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Atquiaj tarangüw para majlüy atnej lamepiüng nomb atquiaj apmajlüy. ");
INSERT INTO huvNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Nganüy Teat, ijaw nguineay tandeacüw wüx ximbasan ajcüwa monajiüt. Aag satüniün meaach xicon narangan minajiüt, nandeacan mipoch nde nimbolan. ");
INSERT INTO huvNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","At tanaámb Teat, iyac iwix wüx xicona, para alndom namongochiün iün andeow nipilan, narangan ateócan, at cuajantanej ngomeaag ajaraw, wüx nangaj minüt micual Teat Jesús, ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ndoj matüniw ocueaj Teat Dios, quiaj tajlang atnej noic ateam niüng canchiüjow. Quiaj tiün wüx ombasüw nejiw meáwan anopnopoj aaga Nangaj Espíritu ocueaj Teat Dios; ndoj ngo mimboloj mandeacüw Mipoch Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Meáwan nejiw leaw lamayariw mipoch Teat Cristo tajlüyiw noic nej omeajtsüw, noic nej ayajcüw. Atquiaj nejinguind ngo mapiüng aneáyan nej leaw ajiür, tajlüy ocueajiw nejiw meáwan. ");
INSERT INTO huvNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Miapóstoles Teat Jesús tanaámb mandeacüw, ngo memboloj masajüw wüx nipilan nguineay tapac alinomb Teat Jesús, cos Teat Dios xeyay ambeol nejiw. ");
INSERT INTO huvNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Atquiaj ngo majlüy tiül nejiw nejinguind leaw ngo majiür leaw netam. Cos meáwan leaw ajiür iüt tengwüy iüm, wüx ndoj manüüb lamajoy ombeat ");
INSERT INTO huvNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","mayacüw teowixaw miapóstoles Teat Jesús. Condom nejiw lamajineaw müjchiw anopnop leaw netam nej. ");
INSERT INTO huvNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Tajlüy nop tiül nejiw nenüt José, leaw ajcüw apóstoles tüjchiw manüt Bernabé. Aaga poch quiaj amb apiüng micual neech mapac omeaatsaran. Nej levita nej naw Chipre. ");
INSERT INTO huvNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Tajiür noic miíüt nej, tanüüb. Condom tajoy ombeat tayac teowixaw miapóstoles Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","At aton nop naxey nenüt Ananías y mintaj nej nenüt Safira, nej tanüüb noic miíüt nej. ");
INSERT INTO huvNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Aaga naxey quiaj ngo mambich majoy ombeat iüt anüüb, tawün quiriw, taxot aweaag mintaj nej. Condom tajoy alquiriw mayac teowixaw apóstoles. Tawaiich, tapiüng áagan ayaj ombeat. ");
INSERT INTO huvNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Quiaj tasaj nej teat Pedro: ―Ananías ¿neol nguineay nimeech tayac tiül imeaats mewaiich Nangaj Espíritu, mexot ombeat miíüta? ");
INSERT INTO huvNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","¿Neol jondot majlüy ngo menüüba, neol ngome ineaye? Aton wüx lamenüüb, ¿neol ngome ineay a tomiün ombeate? ¿Neol tendiüm merang aaga ngo majneaj quiaja? Aag ayaj Teat Dios iwaiich, ngome nipilan ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananías wǘxan tanguiay aaga poch quiaj, quiaj ajmiüc andeow wüx. Condom meáwan leawa tanguiayiw aag ayaj mbayatoj. ");
INSERT INTO huvNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Quiaj tawüw acas monguich monxey, tambüw mawinchaw ombas, taxainguiw, taquiüjpüw mamiütüw. ");
INSERT INTO huvNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Lamajoy maseyme arej ores tatow ndoj aag ayaj, quiaj tapeay quiaj mintaj nej. Nej ngo majaw cuane landoj ajlüy. ");
INSERT INTO huvNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Quiaj tasaj nej a Pedro: ―Isaj xic ¿naleaingue, atogüy tenüjpiün miiütana? ―aj nej. Nej tapiüng: ―Naleaing atoyaj ―aw. ");
INSERT INTO huvNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Pedro tasaj nej: ―¿Neol tendeacan nóiquian mewaijchan Nangaj Espíritu? Nganüy, joyaj lapeayiw teombeay iüm monmiüt minoj. At a ique aton apmaxainguiw ic ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Quiaj ajmiüc aaga najtaj quiaj niüng ajlüy a Pedro, andeow wüx. Wüx tajngotoj ajcüwa monguich monxey majawüw landeow níüngan, quiaj taxainguiw aton, taquiüjpüw mamiütüw niüng ajlüy minoj nej. ");
INSERT INTO huvNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Condom xeyay mbayatoj meáwan monyar andeac Teat Cristo, at meáwan leaw tanguiayiw aag ayaj. ");
INSERT INTO huvNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Ajcüw apóstoles tarangüw xeyay ateócan tiül nipilan, at cuajantanej ngome aag ajaraw. Cos noic nej omeajtsüw, canchiütoj nóiquian tiül minden nadam nangaj iüm, niüng nasoic ocueaj Salomón. ");
INSERT INTO huvNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Meáwan nipilan apac omeajtsüw majawüw nejiw, pero altiül imboloj, ngo mandiümüw mambüw maquiüjpüw wüx canchiüjow. ");
INSERT INTO huvNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Xeyay nipilan, monxey at montaj, tayariw mipoch Teat Cristo. ");
INSERT INTO huvNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Altiül nipilan tawüniw moniün andeow mayacüw tiül calle; altiül napeaaberan wüx mats, altiül wǘxan tec, cos atquiaj wüx apmamong a Pedro, masey mindiw nej mamong wüx ombasüw apmajneajiw. ");
INSERT INTO huvNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","At xeyay nipilan monaw tiültiül cambaj najlǘyan quiaj, tambüw Jerusalén maquiüjpüw mamb moniün andeow, at leaw alwüx ombasüw nimeech, lamüüch nej michachiw. Meáwan tümb majneajiw. ");
INSERT INTO huvNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Quiaj tajcüy aaga minatang miteaats maquiiüb meáwan minipilan nej. Ajcüw ayaj noic ajlüy nipilan nasoic saduceos. Nejiw xeyay ngo majneaj majawüw aag ayaj. ");
INSERT INTO huvNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Tasapüw ajcüw apóstoles mayacüw tiül manchiüc. ");
INSERT INTO huvNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Naleaing aaga ongwiiüts quiaj, nop ángel ocueaj Teat Dios taleaaig ombeay manchiüc, tawün nejiw. Condom tasaj nejiw: ");
INSERT INTO huvNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","―Quiüran indüyiün tiül nadam nangaj iüm, isajan meáwan nipilan wüx aaga najneajay poch neech mapacaran ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Nejiw wüx landoj manguiayiw aag ayaj, ǘmban arraw tajmeliw tiül nadam nangaj iüm maquiajchiw nipilan. Tíülan aaga ores quiaj minatang miteaats canchiütoj maquiiüb minipilan nej. Condom tapajüw meáwan montangtang ombas tiül cambaj Israel mandeacüw. Ndoj cas tüjchiw mamb majanaranüw miün ajcüwa apóstoles imiün tiül manchiüc. ");
INSERT INTO huvNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Naleaing wüx monjiür nangaj iüm tapeayiw mbeay manchiüc maleaijquiw, tajawüw ngo majlüyiw tiül manchiüc. Quiaj tandilileaw mapiüngüw. ");
INSERT INTO huvNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Wüx tajngotoj tapiüngüw: ―Naleaing wüx tapeayasan quiaj, manchiüc tan palaw nandand; at ajcüwa monjiür aliün lombomoj quiaj mbeay manchiüc. Pero wüx taleaaigasan, quiaj tajawasan nejinguind ngo majlüy tiül ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Wüx tanguiay aag ayaj aaga minatang miteaats, at a minatang ocueajiw monjiür nadam nangaj iüm, at alacas montangtang miteaats, quiaj titsoj nej omalüw, ngo majawüw nguineay apndom aaga tenguial ajlüy quiaj. ");
INSERT INTO huvNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Quiaj tajngot nop naxey masaj nejiw: ―Joyajiw, aliw ninguiaj tiül nadam nangaj iüm ajcüwa monxey teyacan tiül manchiüc, tenguial aquiajchiw nipilan ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Quiaj tamb a minatang monjiür nadam nangaj iüm, aquiiüb minipilan nej majanüw miün. Ngo majcüyiw nicuajind, taquiüjpüw miün najneájan, cos imboloj mandüyiw nipilan, ngana maloxiw nejiw. ");
INSERT INTO huvNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Wüx tapeayiw quiaj maquiüjpüw, quiaj tamelichaw tiül moncanchiün. Condom aaga minatang miteaats tatün manguiay nejiw, tapiüng: ");
INSERT INTO huvNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","―Xicona lanasajan icon ngondom mequiajchiün nipilan wüx aaga Jesús quiaj. ¿Neol ngo mecueatiüna? Nganüy laǘmb meajchiün manguiay meáwan nipilan tiül Jerusalén wüx aaga indeacan quiaj. Nganüy indiüman meyacan sasoetiün mepiüngan xicona nembiyasan aaga naxey quiaj ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Quiaj tendeac a Pedro maquiiüb alacas apóstoles, tapiüngüw: ―Xicona netam narangan leaw asaj xicon Teat Dios, ngome leaw asaj xicon nipilan. ");
INSERT INTO huvNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Aaga Teat Dios quiaj Midiosüw mixejchiiüts, nej nepacüüch alinomb a Teat Jesús, leaw icona teyacan wüx cruz, tembiyan. ");
INSERT INTO huvNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Nganüy Teat Dios lamayac nej marang natang, mawün wüx asoet nipilan. Atquiaj tarang Teat Dios müüch leaam omeajtsüw nipilan israel wüx meáwan ngo majneaj teamarangüw, macueatiw, para marangüw leaw najneaj. Atquiaj nej apmawün wüx omeaats asoetiw nejiw. ");
INSERT INTO huvNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Meáwan aag ayaj xicona tajawasan. At a Nangaj Espíritu leaw Teat Dios lamüüch ajcüw monyar andeac nej üüch nejiw majawüw aag ayaj naleaing ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Wüx tanguiayiw aag ayaj ajcüwa nipilan tiül moncanchiün, quiaj tajcüyiw, tandiümüw mambiyaw nejiw nómban. ");
INSERT INTO huvNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Altiül nejiw nop fariseo nenüt Gamaliel. Nej nop nequiaach wüx aaga poch tüünd Moisés. Meáwan nipilan ayariw nej andeac. Aaga naxey quiaj witiüt, tasaj nejiw mawüniw quiaj noic ores ajcüw apóstoles. ");
INSERT INTO huvNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Condom tapiüng: ―Teat cambaj Israel, ijawan majneaj leaw apmerangan wüx ombasüw ajcüwa monxey quiaj. ");
INSERT INTO huvNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Cos atquiaj nomb tajlüy nop naxey nenüt Teúdas. Nej apiüng nop nej xeyay atam ajlüy. Aaga naxey quiaj tandüjpiw nej xeyay nipilan; atüch maseyme piquiw acoic miow (400) nipilan. Ndoj, wüx tandeow, meáwan leawa tandüjpiw nej tümb ndajrriümoj, ngo majlüy nicuajind. ");
INSERT INTO huvNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ndoj aag ayaj tajlüy alinop naxey nenüt Judas naw Galilea. At tandüjpiw nej xeyay cambaj wüx nüt ajmel mineataran. Aaga naxey quiaj tandeow aton. Condom meáwan leaw tandüjpiw nej tümb ndajrriümoj. ");
INSERT INTO huvNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Nganüy sasaj icon, icueatiün ajcüwa teat monxey quiaj, ijchan mambüw. Cos sitiül aaga aquiajchiw quiaj, aaga najiüt arangüw quiaj, ocueájan nipilan apndrom ombas. ");
INSERT INTO huvNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Nganüy sitiül aaga arangüw quiaj ocueaj Teat Dios, icona ngondom mendarrijchan. Netam mejawan, jondot Teat Dios tenguial ijcüyiün mequiüjpan ―aw. ");
INSERT INTO huvNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Quiaj tayariw andeac nej. Ndoj tapajüw alinomb ajcüwa apóstoles, tapots mawüjchiw. Condom tasajüw macueatiw nómban andeacüw wüx Teat Jesús. Ndoj cas tatsambijchaw. ");
INSERT INTO huvNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ajcüwa apóstoles wüx tawüw tiül moncanchiün, tapac omeajtsüw xeyay, cos Teat Dios lamüüch nejiw mamongochiw aaga monxing quiaj teowix monajiüt, cos lamayariw andeac Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Nejiw ngo macueatiw maquiajchiw nipilan, mandeacüw wüx leaw tarang Teat Jesucristo. Atquiaj tarangüw meáwan nüt, átan tiül nadam nangaj iüm, átan tiül aniüng nipilan. ");
INSERT INTO huvNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Tiül aaga nüt quiaj, teaxeyayiw monyar andeac Teat Cristo. Noic nüt ajcüwa judíos tiül nejiw leaw mondeac griego ngo majneaj majawüw ajcüwa judíos mondeac hebreo. Cos leawa mondeac griego apiüngüw ajcüwa monlemben omal montaj tiül nejiw ngo müjndiw palan wüx ajineran cuajantanej meáwan nüt. ");
INSERT INTO huvNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Quiaj ajcüwa gajpiüp (12) apóstoles tapajüw canchiümoj meáwan monyar andeac Teat Cristo. Tasajüw: ―Ngo majneaj sitiül xicona nacueatiün saquiajchiün Mipoch Teat Dios najinean nüeteran. ");
INSERT INTO huvNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Pares nganüy xecojow xechijquiaw, irriüjtan tiül icona ayaíw monxey leaw ijawan arangüw najneaj, jane xeyay ambeol nejiw Nangaj Espíritu, at jane xowüy axomüw omeajtsüw wüx cuajantanej. Ajcüw ayaj apmüjchiiüts marangüw aaga najiüt quiaj. ");
INSERT INTO huvNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Nganüy a xicona tanaámb saquiajchiün Mipoch Teat Dios, at satajcan orar tanaámb ―ajüw. ");
INSERT INTO huvNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Meáwan monyar andeac Teat Cristo tandiümüw marangüw leaw apiüngüw apóstoles. Quiaj tayacüw a Esteban. Aaga naxey quiaj, xeyay ayac omeaats wüx Teat Dios, aton xeyay ambeol nej Nangaj Espíritu ocueaj Teat Dios. Tayacüw alacas, nop Felipe, nop Prócoro, nop Nicanor, nop Timón, nop Parmenas, alinop Nicolás naw Antioquía. Aaga Nicolás quiaj ngome judío nej, pero lamandüüb Teat Dios, Midios Israel. ");
INSERT INTO huvNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ajcüwa nipilan quiaj taquiiübaranüw niüng ajlüyiw apóstoles. Ndoj, wüx ajcüw apóstoles tatüniw ocueaj Teat Dios mambeol nejiw, tayacüw owixaw wüx omalüw nejiw anopnopoj. ");
INSERT INTO huvNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Atquiaj tajüy Mipoch Teat Dios, nguiajantanej tanguiayaran. Quiaj texeyay monyar andeac Teat Cristo tiül Jerusalén, at xeyay miteaats ocueaj israel tandüjpiw Teat Cristo aton. ");
INSERT INTO huvNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Aaga Esteban quiaj, xeyay tambeol nej Teat Dios. Áag ndot ombas marang cuajantanej ateócan tiül cambaj leaw ngome aag ajaraw. ");
INSERT INTO huvNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Quiaj acas monxey monaw tiül a sinagoga nenüt Esclavos Libertados, ajcüw ayaj altiül monaw Cirene, monaw Alejandría, monaw tiül Cilicia, at monaw tiül Asia. Ajcüw ayaj witiütoj majcüyiw wüx leaw taquiaach Esteban. Tambüw tapots asajayej maquiüjpüw. ");
INSERT INTO huvNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Naleaing ngondom mangochiw andeac, cos Esteban xeyay axom omeaats, tandeac atnej netam, cos ambeol nej Nangaj Espíritu. ");
INSERT INTO huvNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Condom ajcüwa monxey quiaj, tayambüw acas nipilan, tangüyiw para mawaijchaw mapiüngüw nejiw tanguiayiw nguineay andeac aaga Esteban, cos andeac xeyay ngo majneaj wüx ombas Moisés at wüx ombas Teat Dios aton. ");
INSERT INTO huvNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ajcüwa monxey quiaj, tambüw tapots masajüw meáwan nipilan, at montangtang monajiüt tiül cambaj, at ajcüwa mondüy wüx aaga poch tüünd Moisés, müüch majcüyiw majawüw Esteban. Condom, quiaj tambüw masapüw a Esteban, tanototoj mamb taquiüjpüw andüy teombasüw monajiüt ocueajiw Israel. ");
INSERT INTO huvNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Condom tayambüw acas monxey mawaijchaw. Ajcüw ayaj tapiüngüw: ―Aaga naxey quiaj ngo paxiüm ocueaj andeac ngo majneaj wüx aaga nangaj iüm cam at wüx aaga poch tüünd Moisés. ");
INSERT INTO huvNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Xicona tanguiayasan andeac, apiüng aaga Jesús naw Nazaret apmandrooch ombas aaga nadam nangaj iüm cam, at apmambiülüüch meáwan leaw arangaats, leawa tüüch icoots teat Moisés ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Quiaj meáwan monajiüt ajlüyiw tiül moncanchiün taxainguiw omalüw majawüw teombas teat Esteban. Quiaj tajawüw atnej teombas nop ángel. ");
INSERT INTO huvNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Condom aaga minatang miteaats tasaj a Esteban: ―¿Naleaingue meáwan leaw apiüngüw quiaja? ―aj. ");
INSERT INTO huvNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Quiaj tapiüng a Esteban: ―Teat cambaj micual iüt Israel, inguiayiün sanasaj icon. Naleaing aaga Teat Dios xeyay najneajay ajlüy, tejüiquichay majaw nej mixejchiiüts Abraham. Aag ayaj wüx Abraham aliün tiül iüt Mesopotamia, nganaw mamb macül tiül Harán. ");
INSERT INTO huvNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Teat Dios quiaj tasaj nej: “Iriow tiül miíüt, icueat icualaats, quiür indüy tiül aaga iüt niüng sanüüch ic mejaw”, aj nej. ");
INSERT INTO huvNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Quiaj Abraham taw tiül aaga iüt niüng acüliw nipilan Caldeos, tiün macül tiül Harán. Naw quiaj, wüx tandeow miteat nej, tawün nej quiaj Teat Dios; tayac nej tiül aaga iüt cam niüng acüliiüts nganüy. ");
INSERT INTO huvNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Naleaing Teat Dios ngo müüch nej noic iüt maneay tiül aaga iüt cam, masey quiripite atonej niüng acuüüch oleaj. Teat Dios tasaj nej apmüüch nej meáwan aaga iüt cam maneayiw micual nej alinoic nüt wüx nej landeow. Aag ayaj tasoic wüx nganaw majiür micual nej. ");
INSERT INTO huvNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Aton Teat Dios tasaj nej: “Micual apmarangüw napeay miün nipilan tiül miíüt pálwüx nipilan, ngome miiütüw nejiw, apmarangüw najon monrang najiüt ocueaj pálwüx nipilan, apmüjndiw mamongochiw xeyay ngo majneaj apiquiw acoic miow (400) neat. ");
INSERT INTO huvNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ndoj xique sanüjchiw mamongochiw xeyay ngo majneaj ajcüwa nipilan niüng apmarangüw najon monrang najiüt. Wüx landoj aag ayaj, nejiw apmawüw quiaj, aliücüw mayambüw xic tiül aaga iüt cam”, aj nej. ");
INSERT INTO huvNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Teat Dios tayac noic poch müüch a Abraham nguineay apmarang aweaag. Tasaj mataag circuncidar micual nej majüic naleaing teamandüüb aaga poch leawa layacaranüw wüx marangüw. Atquiaj wüx wijquiat Isaac micualüw nejiw, tataag circuncidar wüx tajiür ojpeacüw nüt tatow wijquiaw. Condom Isaac aton atquiaj tarang wüx Jacob micual nej, at a Jacob atnej tarang wüx ajcüwa gajpiüp (12) micual nej. Ajcüw ayaj mixejchiiüts tanomb. ");
INSERT INTO huvNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","’Ajcüwa mixejchiiüts quiaj, tanüjpiw José michijquiaw nejiw, cos ngo majneaj majawüw. Condom mongalüy taquiüjpüw manüjpiw tiül Egipto. Pero naleaing Teat Dios ngo macueat a José. ");
INSERT INTO huvNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Meáwan ngo majneaj leaw tamongoch José, Teat Dios tawün nej tiül. At tüüch nej mendüy xeyay, majneaj majaw nej a Faraón minatang nenajiüt tiül Egipto. Condom aaga Faraón tayac nej majiür najiüt majlüy wüx meáwan cambaj tiül Egipto, at tiül aniüng a Faraón aton tarang natang. ");
INSERT INTO huvNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","’Condom tajlüy nadam montiün andüy tiül meáwan cambaj tiül Egipto. At tiül meáwan cambaj tiül iüt Canaán ngo majlüy nüeteran. Quiaj mixejchiiüts aton ngo maxomüw nüeteran. ");
INSERT INTO huvNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Wüx Jacob tanguiay aliün majlüy trigo tiül Egipto, quiaj tüüch mambüw micual nej tiül Egipto. Ajcüw ayaj mixejchiiüts tajlüyiw nomb. Quiaj tambüw nomb oleajiw. ");
INSERT INTO huvNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Wüx tambüw amb iwic oleajiw, quiaj José tüüch majawüw micoj nej jane nej. At a Faraón aton quiaj tanguiay nguia naw, ngün minipilan a José. ");
INSERT INTO huvNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Condom José tatün mapeay miteat nej Jacob, maquiiüb miün meáwan micual nej macüliw tiül Egipto. Ajcüw ayaj ajlüyiw er miow gajpocoic (75) nipilan. ");
INSERT INTO huvNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Naw quiaj tamb a Jacob macül tiül Egipto. Tiül aaga iüt quiaj tandeow. At ajcüwa gajpiüp mixejchiiüts tandeowüw quiaj aton. ");
INSERT INTO huvNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Condom ajcüw ayaj, tajoyaran miolajtsüw nejiw mamiüraad tiül cambaj Siquem. Tamiürajtüw tiül aaga oxiüt tangal Abraham tanomb, angal ocueajiw micual Hamor tiül Siquem. ");
INSERT INTO huvNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","’Wüx laliüc matüch aaga nüt lamapiüng Teat Dios wüx tasaj Abraham nguineay apmambeol nejiw, quiaj micual Jacob laxeyayiw tiül Egipto. ");
INSERT INTO huvNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Tiül aaga nüt quiaj, tajmel alinop minatang nenajiüt tiül Egipto, leaw ngo majaw jane nej a José. ");
INSERT INTO huvNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Aaga nenajiüt quiaj, xeyay ngo majneaj arang, tawaiich ajcüwa nipilan acualajtsaats tanomb. Tüüch nejiw mamongochiw xeyay ngo majneaj. Tapiüng netam maloxiw ninguiün micualüw nejiw ajcüw namix nine monench jayats wijquiam, mandeowüw, cos ngo mandiüm majaw mexeyayiw. ");
INSERT INTO huvNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Tiül aaga nüt quiaj, wijquiat a Moisés. Teat Dios tandiüm nej, tatangüjchiw nej miteat nej mimüm nej arej caaw. ");
INSERT INTO huvNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Wüx langondom maxotüw nej, netam macueatiw; quiaj taxom nej nop nüx micual a Faraón, taxaing maquiiüb. Condom tatangüüch atnej majiür micual nej. ");
INSERT INTO huvNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Atquiaj Moisés wüx latang taquiajchich wüx meáwan leaw ajawüw mondüy tiül Egipto, áag tayarich meáwan leaw tandeac at leaw tarang. ");
INSERT INTO huvNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","’Wüx lamajiür ic miow (40) mineat nej, quiaj tateots mamb majaw micual miíüt nej, ajcüw micual Israel, quiaj tamb. ");
INSERT INTO huvNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Naleaing wüx tajaw nguineay nop tiül micual Israel, teamambiy nej nop naw Egipto, quiaj tamb mawün. Condom Moisés tambiy aaga naxey naw Egipto mapalüch ombas. ");
INSERT INTO huvNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Cos nej apiüng tiül omeaats nej micual Israel apmajawüw Teat Dios apmambeol nej mawün nejiw quiaj. Naleaing nejiw ngo mapiüngüw atquiaj. ");
INSERT INTO huvNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Wüx rat tiüt amb alinoic nüt tamb quiaj alinomb a Moisés. Quiaj tajaw teajcüyiw ijpüw micual Israel. Quiaj tasaj nejiw macueatiw, tapiüng: “Teat, icona nercualaatsayon; ¿neol tapots ermbiyayona?” aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Quiaj aaga naxey tenguial ambiy quiaj, tatech nej ninguiün, tasaj: “¿Jow a ique cuane minajiüta, jan neyac ic merang xenatangana, mejaw wüx sasoetiüna? ");
INSERT INTO huvNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Ngwüy, indiüm membiy xic aton, atnej tembiy tim aaga naxey naw Egipto?” aj nej. ");
INSERT INTO huvNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Moisés wüx tanguiay aag ayaj, quiaj tawün oleaj, tamb macül tiül iüt Madián. Condom quiaj tajiürüw micualüw nejiw ijpüw monench. ");
INSERT INTO huvNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","’Condom wüx lamajiür ic miow (40) neat tatow acül quiaj, noic nüt altiül wajchiüc niüng ajlüy nop tiüc nenüt Sinaí. Quiaj tajaw teandaab noic owil sats. Tajaw nop ángel tiül aaga biümb quiaj. ");
INSERT INTO huvNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moisés mbayat wüx tajaw aag ayaj, tatüch quiaj alquiriw majaw majneaj. Quiaj tanguiay andeac Teat Dios, tasaj nej: ");
INSERT INTO huvNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Xique Teat Dios xic, Midiosüw miteatiün, Midios Abraham, Midios Isaac, Midios Jacob”, aj nej. Moisés quiaj tambeapmbeap nej, timbol majaw. ");
INSERT INTO huvNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Quiaj tasaj nej Teat Dios: “Isoond a napüic altiül ileaj quiaj, cos aaga niüng alembemear quiaj nangaj. ");
INSERT INTO huvNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Xique sajaw nguineay amongochiw tiül Egipto xenipilan, lananguiay nguineay aiümüw, ümb apacüw. Pares nganüy sajngot nawüniw quiaj. Nganüy mac, sanüüch ic meamb indüy Egipto”, aj nej. ");
INSERT INTO huvNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","’Aaga Moisés quiaj, ngome tandiüram, tasoic: “¿Jan neyac ic merang xenatangan mejaw wüx sasoetiüna?” ajow. Pero nganüy Teat Dios tayac nej marang natang tiül nejiw, mawün nejiw tiül Egipto. Aaga ángel tajaw tiül biümb wüx tandaab aaga sats, aag ayaj tembeol nej. ");
INSERT INTO huvNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Aaga Moisés quiaj tawün nejiw tiül Egipto wüx landoj marang xeyay cuajantanej ateócan leaw ngome aag ajaraw tiül aaga iüt quiaj. At tarang ateócan tiül a ndec nasoic Nacants Ndec, at wüx tacüliw tiül wajchiüc ic miow (40) neat. ");
INSERT INTO huvNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Nej aaga Moisés quiaj, tasaj micual Israel, tapiüng: “Alningüy alinoic nüt Midiosaats apmayac nop nendeac andeac nej tiül icona, atnej tayac xic. Aag ayaj apmaw tiül icona. Netam menguiayiün leaw nej apmasaj icon”, aw. ");
INSERT INTO huvNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Nej aaga Moisés quiaj, tajlüy tiül nipilan wüx tacüliw tiül wajchiüc. Aton nej tandeac aweaag nop ángel wüx tajlüy wüx aaga tiüc Sinaí. Condom nej tandeac masaj ajcüwa miteatiiüts leawa tasaj nej a ángel. Nej tüünd Mipoch Teat Dios, leaw alndom müüch mapacüw nipilan. Aag ayaj atüch icootsa aton. ");
INSERT INTO huvNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","’Naleaing nejiw mixejchiiüts ngome tandiümüw mayariw aag ayaj; tandiümüw mandilileaw alinomb andüyiw Egipto. ");
INSERT INTO huvNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Áag tasajüw Aarón: “Xicona sandiüman merang nop midiosaats maquiiüb icoots. Cos aaga Moisés newün icoots tiül Egipto, nganüy ngo majawaats nguia tandüy”, ajüw. ");
INSERT INTO huvNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Quiaj tarangüw nop dios atnej nop nine wacüx. Condom tambiyaw nimal mayacüw teombas aaga narangüch dios quiaj, marang ichechiw nejiw. Tapac omeajtsüw majawüw aaga narangüch naag owixan quiaj. ");
INSERT INTO huvNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Quiaj tacueat nejiw Teat Dios marangüw leaw andiümüw. Tayambüw ocas najlüy cawüx, atnej apiüng tiül Mipoch Teat Dios leaw tarangüw mondeac andeac nej, cos apiüng: Inguiayiün cambaj Israel: ¿jow wüx tejlüyiün tiül wajchiüc ic miow (40) neat, mbich tembiyan nimal meyacan erchechiün meajchiün xique? ");
INSERT INTO huvNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ingow aag ayaj, icona tejoyiün ombiüm midiosan Moloc nguiajantanej niüng teamban. Aton tejoyiün aaga irangan atnej ocas, ipiüngan aag ayaj midiosan Renfán. Ajcüw ayaj terangan, tequiejliün micosan teombasüw nejiw. Ajcan irangan aag ayaj sanawün icon ningüy tiül miiütan, sanayac icon miünquiaj necamb a cambaj Babilonia. ");
INSERT INTO huvNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","’Mixejchiiüts, wüx tajüyiw tiül wajchiüc tajiürüw nop nine nangaj iüm narangüch taag. Tiül aaga nine nangaj iüm quiaj tacül aaga piedra alwüx ajcüw gajpowüw poch tayac Teat Dios. Aaga nine nangaj iüm quiaj tarangüch atnej Teat Dios lamapiüng wüx tasaj a Moisés marang atnej lamüüch majaw. ");
INSERT INTO huvNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Aaga nine nangaj iüm taag quiaj tamong teowixaw ajcüwa mixejchiiüts tajlüyiw tanomb. Wüx taquiiüb nejiw miün Josué, at a nine nangaj iüm taquiüjpüw miün aton. Aag ayaj wüx tasapüw aaga iüt cam niüng tacüliw pálwüx nipilan. Teat Dios tandrooch ombas ajcüwa pálwüx nipilan quiaj, para macüliw ningüy mixejchiiüts. Aaga nangaj iüm quiaj, aliün majlüy ningüy wüx tajlüy David. ");
INSERT INTO huvNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","David xeyay tambeol nej Teat Dios, nej tandiüm marang nop jayats nangaj iüm nadam, macül tiül Teat Dios, aaga midios Jacob. ");
INSERT INTO huvNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Taton ngo marang, Salomón tarang aaga nadam nangaj iüm ocueaj Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Pero naleaing Teat Dios najlüy tiül cielo, ngo macül tiül nangaj iüm narangüch naag owixan, atnej tapiüng wüx nawiig nop nendeac andeac Teat Dios: ");
INSERT INTO huvNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Nangaj cielo aag ayaj niüng chetejos, aaga iüt niüng sacuüüch xileaj. ¿Nguineay ajlüy a iüm apmerangan meajchiün xique? ¿Ngwüy nguiane alndom naxooda? ");
INSERT INTO huvNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿Neol, ngome xique nerangas meáwan leaw almajlüye naag xiwixe?, aw. ");
INSERT INTO huvNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","’Nganüy icona xeyay adam imeajtsan, ngo meyacan wüx imeajtsan andeac Teat Dios, ngo meajchiün ilajcan menguiayiün. At icon nipilan ngo mayamb Teat Dios; ngome áag merangan atnej andiüm a Nangaj Espíritu ocueaj Teat Dios. Icona irangan leaw indiüman, atnej tarangüw mixejchiün. ");
INSERT INTO huvNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","¿Cas mondeac andeac Teat Dios ngo majcüyiw majawüw nejiw mixejchiüna? Nejiw tambiyaw mondeac andeac Teat Dios tajlüyiw tanomb, cos nejiw tandeacüw naleaing wüx aliüc nop nerang najneaj. Aaga nerang najneaj quiaj, icona teyacan teowixaw nipilan monrang ngo majneaj, mandeow; atquiaj tembiyan. ");
INSERT INTO huvNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Masey nangaj ángeles tüüch icon aaga Mipoch Teat Dios mejiüran, naleaing icona ngo meyacan wüx imeajtsan, aj nejiw a teat Esteban. ");
INSERT INTO huvNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Nejiw wüx tanguiayiw aag ayaj, quiaj tajcüyiw xeyay, ancaporros olüiquiw majawüw a Esteban. ");
INSERT INTO huvNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Naleaing Esteban, cos altiül nej Nangaj Espíritu ocueaj Teat Dios, wüx taxaing omal majaw cawüx tiül cielo, quiaj taxom majaw nguineay ajneaj ajlüy Teat Dios; aton tajaw a Teat Jesús alembem amb wüx miác Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Quiaj tapiüng: ―¡Joyaj lanaxom najaw tiül cielo! Saxom najaw a Teat Naxey alembem amb wüx miác Teat Dios ―aw. ");
INSERT INTO huvNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Quiaj nipilan tepajüw napac, tapalüw olajcüw ngana manguiayiw. Quiaj tajmeliw masapüw a Esteban. ");
INSERT INTO huvNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ndoj taquiüjpüw andüy mbeay cambaj, tapots maloxiw. Ajcüwa monlox quiaj, tasojndiw micamixaw nejiw mayacüw niüng ajlüy nop naxey nenüt Saulo. ");
INSERT INTO huvNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Wüx tenguial maloxiw, Esteban tasaj Teat Dios, tapiüng: ―Teat Jesús, ingoch xic ―aw. ");
INSERT INTO huvNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Condom taquieel micos nej tiüt, tendeac napac, tapiüng: ―Teat Dios, nde meyac wüx ombasüw nejiw aaga nisoet teamarangüw cam ―aw. Landoj mapiüng aag ayaj, quiaj tandeow. ");
INSERT INTO huvNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Aaga naxey nenüt Saulo quiaj, aton tajneaj majaw mandeow a Esteban. Tiül aaga nüt quiaj, witiüt noic nadam moncüy wüx ombasüw monyar andeac Teat Jesús monlüy tiül Jerusalén. Ndoj meáwan tümb mawüniw oleajiw, tambüw andüyiw tiül iüt Judea, at tiül iüt Samaria. Áagan ajcüw apóstoles ngo mawüw quiaj. ");
INSERT INTO huvNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Ndoj acas monxey monyamb Teat Dios taxainguiw a Esteban, taquiüjpüw mamiütüw, xeyay tajiüntsüw wüx ombas. ");
INSERT INTO huvNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Condom aaga naxey nenüt Saulo quiaj, tapots mayamb ombasüw monyar andeac Teat Jesús. Tajmel tiültiül nden masap mayac tiül manchiüc monxey at montaj. ");
INSERT INTO huvNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Meáwan monwün oleaj tasajüw nipilan leaw niüng tambüw wüx aaga najneajay nanderac. ");
INSERT INTO huvNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Felipe aton tamb andüy tiül noic cambaj tiül Samaria, tapots masaj nipilan wüx Teat Cristo. ");
INSERT INTO huvNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Meáwan nipilan tüjchiw olajcüw manguiayiw leaw apiüng Felipe, aton tajawüw xeyay ateócan leaw tarang. ");
INSERT INTO huvNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Xeyay nipilan leaw alwüx ombasüw nimeech, tajneajiw. Wüx tawüw aaga nimeech quiaj, tepajüw napac. At xeyay nipilan axom nejiw napat monandeow, altiül landeow owix landeow oleaj, altiül necoex, pero tümb majneajiw. ");
INSERT INTO huvNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Quiaj xeyay tapac omeajtsüw ajcüwa nipilan tiül aaga cambaj quiaj. ");
INSERT INTO huvNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Alquiaj nop naxey nenüt Simón. Nej aton arang quiripite ateócan tiül aaga cambaj quiaj. Naleaing nej axot oniiügaran mawaiich nipilan tiül Samaria. Apiüng nej nop naxey xeyay netam ajlüy. ");
INSERT INTO huvNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Aaga naxey quiaj, anguiayiw andeac nej namix monguich at natangtang nipilan, apiüngüw: ―Aaga naxey quiaj, naleaing xeyay ambeol nej Teat Dios ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Xeyay ayariw nej andeac, cos nej axot oniiügaran arang quiripite ateócan. Lamawaiich nejiw xeyay nüt wüx aag ayaj. ");
INSERT INTO huvNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Nganüy wüx tanguiayiw nguineay andeac a Felipe cos tasaj nejiw nguineay alndom majlüyeran tiül micambaj Teat Dios; y tasaj nejiw aton wüx Teat Jesucristo, quiaj tayariw. Condom tayariw yow, monxey at montaj. ");
INSERT INTO huvNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Quiaj aaga Simón tapiüng lamayar Mipoch Teat Dios, ndoj tayar yow. Condom tamb maquiiüb a Felipe nguiajantanej. Nej xeyay mbayaw wüx ajaw nguineay a Felipe arang cuajantanej nadam ateócan leaw ngomeaag ajaraw. ");
INSERT INTO huvNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Ajcüwa apóstoles monlüy Jerusalén, wüx tanguiayiw nipilan monaw Samaria lamayariw Mipoch Teat Dios, quiaj tüjchiw mamb a Pedro maquiiüb a Juan mambüw quiaj, mambeolüw a Felipe. ");
INSERT INTO huvNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Nejiw wüx tapeayiw quiaj, tatüniw ocueaj Teat Dios müüch Nangaj Espíritu ajcüwa nipilan quiaj. ");
INSERT INTO huvNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Cos nejinguind tiül nejiw nganaw mayariw Nangaj Espíritu ocueaj Teat Dios. Nejiw tayariw áagan yow wüx minüt Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Quiaj a Pedro y Juan tayacüw owixaw wüx omalüw ajcüwa nipilan quiaj, quiaj tiün wüx ombasüw nejiw Nangaj Espíritu ocueaj Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Aaga Simón wüx tajaw nguineay ajcüwa apóstoles ayacüw owixaw wüx omalüw nipilan, quiaj apeay wüx ombasüw nejiw aaga Nangaj Espíritu ocueaj Teat Dios. Quiaj tandiüm müüch nejiw tomiün. ");
INSERT INTO huvNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Tasaj nejiw: ―Ijchan xic aton narang aag ayaj, nüjchiw mayariw Nangaj Espíritu ocueaj Teat Dios jangantanej nipilan leaw sanayac xiwix wüx omal nej ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Quiaj tasaj nej a Pedro: ―Ijoy ninguiün aaga tomiün quiaj, ich ndrom imbas anaag, cos ique tendiüm mengal aaga leaw Teat Dios üüch, ǘüchan. ");
INSERT INTO huvNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ique ngo matüch ic meaand aag ayaj, ngome minajiüt, cos Teat Dios ajaw imeaats ngome najneaj. ");
INSERT INTO huvNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Nganüy icueat aaga xeyay ngo majneaj temerang quiaj, itün ocueaj Teat Dios sitiül alndom mawün wüx omeaats aaga xeyay ngo majneaj ipiüng tiül imeaats quiaj. ");
INSERT INTO huvNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Xique sajaw ique xeyay ngo majneaj alwüx imeaats. Ijlüyay wüx irang ngo majneaj ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Quiaj tasaj nejiw a Simón: ―Itüniün ocueaj Teat Dios mambeol xic, ngana namongoch aaga ipiüngan quiaj ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Condom a Pedro y Juan, wüx landoj majüiquichaw wüx Teat Jesús, at wüx landoj mandeacüw Mipoch Teat Dios, quiaj tandilileaw alinomb andüyiw Jerusalén. Xeyay cambaj tiül Samaria leaw niüng tamongoj, tasajüw nipilan wüx Mipoch Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Condom nop ángel ocueaj Teat Dios tasaj a Felipe, tapiüng: ―Ernguialeateay, quiür indüy cawac, ingoch aaga tiiüd imiün Jerusalén andüy Gaza. Aaga tiiüd quiaj, amb tiül wajchiüc among ―aw. ");
INSERT INTO huvNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Quiaj tamb a Felipe. Ndoj tangoch nop naxey naw tiül iüt Etiopía, eunuco nej, pero ajiür nadam najiüt ocueaj nop najtaj nenüt Candace. Aaga najtaj quiaj minatang nenajiüt nej tiül iüt Etiopía. Aaga naxey quiaj, acül teowix nej meáwan tomiün. Nej tamb Jerusalén marang casa Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Wüx tajtsor alchetem tiül micarret nej, tenguial mateow Mipoch Teat Dios tiül aaga nawiig tarang Isaías, nendeac andeac Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Quiaj Nangaj Espíritu ocueaj Teat Dios tasaj a Felipe: ―Quiür itüch aaga carret quiün, indüüb mamb ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Quiaj tamb a Felipe matüch a carret. Tanguiay aaga naxey quiaj tenguial mateow Mipoch Teat Dios leaw tarang Isaías. Tatün manguiay, tasaj: ―¿Teat, ixom imeaats wüx aag temeteow quiaja? ―aj. ");
INSERT INTO huvNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Quiaj tapiüng aaga naxey: ―¿Nguineay sanaxom ximeaats sitiül ngo majlüy aljane maquiaach xic? ―aw. Ndoj quiaj tasaj a Felipe majtep tiül a carret chetem aweaag. ");
INSERT INTO huvNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Aaga Mipoch Teat Dios niüng tenguial mateow, apiüng: Wüx taquiüraab mamb mandeow, ajlǘyan ngo menojteay, atnej nop sap. Atnej nop quicheech sap wüx ajerep milan nej, ngo mepaj. Atquiaj a nej aton wüx tandeow, ngo majcüy majaw monbiy nej. ");
INSERT INTO huvNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Nej tüünd mamongoch monxing, ndoj ngome tajaraw cuane asoet. ¿Jane alndom mapiüng meáwan ngo majneaj tarangüw wüx ombas nej ajcüwa nipilan quiaja? Cos tambiyaw nej ningüy wüx iüt. ");
INSERT INTO huvNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Quiaj tatün manguiay aaga naxey quiaj, tasaj a Felipe: ―Isaj xic teat, ¿jane wüx ombas apiüng aaga nendeac andeac Teat Dios quiaja? ¿Apiüng wüx nejáyan quiaja, ngwüy apiüng wüx alinop aljane? ―aj. ");
INSERT INTO huvNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Condom Felipe tapots maquiaach nej ajan wüx aaga poch quiaj. Tapots masaj nej wüx Mipoch Teat Dios leaw tandeac Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Condom wüx tatüchiw niüng ajlüy yow, quiaj tapiüng aaga naxey quiaj: ―Joyaj yow ¿quia ngondom nayar yowa? ―aw. ");
INSERT INTO huvNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Quiaj tapiüng a Felipe, tasaj nej: ―Alndom sitiül iyaag naleaing lajmel tiül imeaats Mipoch Teat Dios ―aj nej. Quiaj tapiüng aaga naxey quiaj: ―Nganüy lanapiüng naleaing aaga Teat Jesucristo quiaj Micual nej Teat Dios ―aw. ");
INSERT INTO huvNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Quiaj tapiüng lombom a carret. Condom tawüw tiüt ijpüéj, tambüw tajmeliw tiül yow, Felipe maquiiüb aaga naxey quiaj. Quiaj tüüch nej yow a Felipe. ");
INSERT INTO huvNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Condom wüx tawüw imiün tiül yow, quiaj a Nangaj Espíritu ocueaj Teat Dios tawün quiaj a Felipe. Aaga naxey quiaj, ngo maxom majaw nguia tandüy a Felipe. Condom tamb maquiiüb mitiiüd nej apac omeaats. ");
INSERT INTO huvNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Felipe camüm mayaag altiül cambaj Azoto. Quiaj tamb tapots mandeac Mipoch Teat Dios tiültiül meáwan cambaj niüng tamong, atánan quiaj tatüch tiül cambaj Cesarea. ");
INSERT INTO huvNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Pues aaga Saulo ngo mamong ajcüy majaw minipilan Teat Jesús, andiüm mambich mambiy meáwan. Quiaj tamb majaw natang miteaats. ");
INSERT INTO huvNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Tatün nawiig majoy majüiquich tiül nangaj iüm tiül Damasco, alndom masap matsaag meáwan mondüüb Teat Jesús leaw apmaxom, masey monxey masey montaj. Ndoj apmaquiiüb mamb andüy Jerusalén. ");
INSERT INTO huvNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Naleaing wüx aleamb tiül tiiüd laliüc matüch Damasco, quiaj tajaw noic ran imiün cielo, anmarraj nej, ayey nej tiüt. ");
INSERT INTO huvNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Quiaj tajmiüc a Saulo. Condom tanguiay andeac nop nendeac, tapiüng: ―Saulo, Saulo ¿neol tapots meyamb ximbas mejcüy mejaw xique? ―aw. ");
INSERT INTO huvNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Nej, quiaj tapiüng: ―¿Jan ic teat? ―aw. Quiaj tasaj nej aaga nendeac quiaj: ―Xique aaga Jesús, leaw ique tenguial meyamb ombas mejcüy mejaw. Ngo majneaj mejcüy, cos andüy miün wüx imbas irang memongoch ngo majneaj, atnej nop jayats wacüx wüx atoel, quiaj atileran ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Quiaj mbayaw, ancambeapmbeapeay. Tapiüng: ―Jow nganüy Teat ¿cuane indiüm mejaw naranga? ―aw. Quiaj tasaj nej Teat Jesús: ―Witiür, quiür itüch tiül aaga cambaj quiün. Quiaj apmesoic cuane netam merang ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ajcüwa monxey monquiiüb Saulo alombomoj quiaj, xeyay lambayajow aton. Cos anguiayayej andeac aaga nendeac, pero naleaing ngo maxomüw majawüw nejinguind. ");
INSERT INTO huvNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Quiaj witiüt tiüt a Saulo; pero wüx taleaaig oniiüg ngo maxom majaw nicuajind. Quiaj taquiüraab mamb, naneteteran owix, tamb andüy Damasco. ");
INSERT INTO huvNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Tajlüy quiaj er nüt ngo maxom majaw nicuajind nicuajind, ngo met, ngo manganeow. ");
INSERT INTO huvNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Tiül aaga nüt quiaj altiül Damasco nop minipilan Teat Jesús nenüt Ananías. Aaga naxey quiaj aleaic tajaw atnej aǘm, cos Teat Jesús tejüiquichay majaw nej. Tasaj: ―¡Ananías! ―aj. Ananías tapiüng: ―Sal ningüy Teat ―aw. ");
INSERT INTO huvNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Quiaj tasaj nej Teat Jesús: ―Ernguialeateay, quiür iquiiüb aaga calle nasoic Naleainguiay, itün menguiay aniüng Judas. Alquiaj nop naxey nenüt Saulo naw Tarso, nej nganüy nganüy cam tenguial ataag orar. ");
INSERT INTO huvNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Nej aton lanüüch majaw atnej aǘm, nop naxey nenüt Ananías lajmel niüng nej axood, apmayac owix nej wüx omal nej, quiaj aprram oniiüg nej alinomb ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananías wüx tanguiay aag ayaj, tapiüng: ―Teat, xique lananguiay xeyay nipilan andeacüw wüx aaga naxey quiaj, apiüngüw nej xeyay ngo majneaj teamarang wüx ombasüw minipilan tiül Jerusalén. ");
INSERT INTO huvNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Nganüy lapeay ningüy, ajamiün nawiig ocueajiw montangtang miteaats, quiaj alndom masap matsaag meáwan mondüüb ic ―aw. ");
INSERT INTO huvNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Quiaj tasaj nej Teat Jesús: ―Quiür, cos aaga naxey quiaj lanarriiüd marang xenajiüt. Nej apmamb mandeac xic wüx tiül palpálwüx nipilan, at niüng ajlüyiw minatangüw monajiüt, at tiül micual iüt Israel aton. ");
INSERT INTO huvNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Cos xique sanüüch majaw nguineay apmamongoch xeyay ngo majneaj áag andüüb xic ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Quiaj tamb a Ananías andüy tiül aaga nden niüng axood Saulo. Wüx tapeay quiaj, tayac owix wüx omal a Saulo. Tasaj: ―Teat Saulo, aaga Teat Jesús tejüiquichay mejaw tiül tiiüd wüx tewiün, nej nesaj xic niün nüüch ram iniiüg alinomb. Aton aliüc Nangaj Espíritu ocueaj Teat Dios majlüy wüx imbas ―aj. ");
INSERT INTO huvNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Andǘüban ajmiüc imiün teoniiüg nej atnej milil cüet. Quiaj rat oniiüg nej a Saulo. Condom quiaj witiüt, tamb mayar yow. ");
INSERT INTO huvNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Saulo wüx landoj üet, landoj anganeow, quiaj tayar apac alinomb. Condom tacül quiaj acas nüt maquiiüb minipilan Teat Jesús monlüy tiül Damasco. ");
INSERT INTO huvNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Quiájan tamb meáwan tiül ajcüwa sinagogas tiül Damasco mandeac masaj nipilan, naleaing aaga Teat Jesús Micual Teat Dios nej. ");
INSERT INTO huvNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Quiaj mbayatoj meáwan jane tanguiayiw andeac nej, tapiüngüw: ―¿Neol, ngome nej aag ayaj tasap xeyay minipilan Teat Jesús tiül Jerusalén? ¿Neol ngome áag iün marang ningüy, masap matsaag minipilan Teat Jesús maquiiüb andüy teombasüw montangtang miteaatsa? ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Naleaing aaga Saulo taxom omeaats xeyay masaj nipilan, áag ngondom mangochiw nej andeac ajcüwa judíos moncül tiül Damasco, cos tasaj nejiw naleaing Teat Jesús aag ayaj a Cristo leaw netam miün. ");
INSERT INTO huvNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Wüx lamajiür xeyay nüt acül quiaj, quiaj ajcüwa judíos tandeacüw nóiquian apmambiyaw nej. ");
INSERT INTO huvNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Pero Saulo tanguiay aag ayaj. Masey tajiürüw mbeay mbeay cambaj nüt ongwiiüts cos andiümüw masapüw mambiyaw, pero ngondom mambiyaw. ");
INSERT INTO huvNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Condom minipilan Teat Jesús tawüniw nej ongwiiüts; tayacüw nej tiül nop nadam nchep, tamongochiw nej amb nic coet neyey tiüt cambaj. Aaga coet quiaj, najtep oleaj xeyay, narangüch piedra. Atquiaj taw wüx. ");
INSERT INTO huvNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Wüx tapeay tiül Jerusalén a Saulo, tandiüm maquiüjpüw tiül minipilan Teat Jesús; pero naleaing nejiw timboloj mandüyiw nej; ayajcüw ngome naleaing minipilan nej Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Quiaj a Bernabé tambeol nej, taquiiüb nej mamb andüy niüng ajlüyiw apóstoles. Condom tapots masaj nejiw wüx a Saulo nguineay tajaw Teat Jesús tiül tiiüd. At tasaj nejiw cuane tasaj nej Teat Jesús, aton tasaj nejiw nguineay tandeac wüx Teat Jesús tiül Damasco, ngo mimbol. ");
INSERT INTO huvNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Condom quiaj tacül tiül Jerusalén a Saulo maquiiüb nejiw, ambüw nguiajantanej maquiüjpüw. ");
INSERT INTO huvNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Nej ngo mimbol mandeac wüx Teat Jesús. At aton tasajsaj ajcüwa mondeac griego; pero nejiw ngo mayariw nej andeac; tayambüw nguineay mambiyaw. ");
INSERT INTO huvNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Wüx minipilan Teat Jesús tanguiayiw aag ayaj, quiaj taquiüjpüw nej mamb andüy Cesarea. Condom naw quiaj tüjchiw nej mamb andüy Tarso. ");
INSERT INTO huvNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Tiül aaga nüt quiaj tajlüy najneájan tiül meáwan niüng canchiüjow minipilan Teat Jesús. Lango majcüyaran majarawüw tiül meáwan cambaj tiül Judea, tiül Galilea, at tiül Samaria. Tayacüw wüx omeajtsüw mandüjpiw leawa tandeac Teat Jesús, tarangüw leaw andiüm Teat Dios. Quiaj texeyayiw, cos tambeol nejiw Nangaj Espíritu ocueaj Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Condom alinoic nüt wüx tamb a Pedro mamong tiül tiül cambaj niüng ajlüyiw minipilan Teat Jesús majaw cuane arangüw, quiaj tamb aton tiül cambaj Lida. ");
INSERT INTO huvNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Taxom quiaj nop naxey nenüt Eneas. Aaga naxey quiaj lamajiür ojpeacüw neat acül wüx mats, androoch nej ombas monandeow. ");
INSERT INTO huvNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Quiaj tasaj nej a Pedro: ―Teat Eneas, Teat Jesucristo lamataag ic majneaj, witiür, ixaing mimats ―aj. Andǘüban ajneaj aaga naxey quiaj, witiüt. ");
INSERT INTO huvNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Wüx tajawüw nej lajneaj, meáwan nipilan tiül Lida, at monaw tiül cambaj Sarón aton tandüjpiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Tiül aaga nüt quiaj, altiül cambaj Jope nop najtaj minipilan Teat Jesús nej aton, nenüt Tabita. Aag ayaj nasoic Dorcas tiül ombeay griego. Nej xeyay najneaj arang, at ambeol nipilan ngo majiür. ");
INSERT INTO huvNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Wüx aaga nüt quiaj, tiün andeow a Dorcas, tandeow. Condom wüx landoj axejmbeacharan, taquiüraab majmel cawüx tiül amb ijpüw iüm. ");
INSERT INTO huvNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Pues aaga cambaj Jope ngome xeyay miünquiaj ajlüy aweaag cambaj Lida, niüng ajlüy Pedro. Wüx minipilan Teat Jesús monaw Jope tanguiayiw Pedro altiül cambaj Lida, quiaj tüjchiw mamb ijpüw monxey masajüw: ―Teat, irang favor, mac najen mejaw xicon ningüy tiül Jope ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Quiaj tamb a Pedro maquiiüb nejiw. Wüx tapeay quiaj, taquiüjpüw nej mamb andüy cawüx tiül amb ijpüw iüm. Camüm mapeay quiaj, andǘüban mayeyiw nej tiüt monlemben omal montaj, ajiüntsüw. Tüjchiw nej majaw apixaw nejiw arang Dorcas wüx almapac. ");
INSERT INTO huvNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Condom Pedro tawün nejiw quiaj meáwan, ndoj taquieel tiüt micos nej mataag orar Teat Dios. Condom ndiliteay majaw aaga nandeow quiaj, tasaj: ―Tabita, witiür ―aj. Quiaj taleaaig oniiüg aaga najtaj quiaj, wüx tajaw a Pedro quiaj witiüt chetem. ");
INSERT INTO huvNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pedro, quiaj tandic owix nej masap owix a najtaj, tawitich lembem. Condom, quiaj tapaj miünüw minipilan Teat Jesús at monlemben omal montaj. Wüx tajngotoj majawüw, quiaj tajawüw lapac. ");
INSERT INTO huvNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Aag ayaj tanguiayaran meáwan tiül cambaj Jope, ndoj xeyay nipilan tandüjpiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Condom Pedro tacül tiül cambaj Jope xeyay nüt, aniüng nop naxey nenüt Simón, nop nerang najiüt wüx taag. ");
INSERT INTO huvNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Altiül cambaj Cesarea nop naxey nenüt Cornelio, minatang noic ajlüy soldados nasoic Italiana. ");
INSERT INTO huvNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Aaga naxey quiaj, xeyay ayamb Teat Dios, xeyay andiüm marang leaw andiüm Teat Dios, nóiquian maquiiüb meáwan leaw al aniüng nej. At aton xeyay ambeol nipilan tiül aaga cambaj quiaj. Nej ajlüyay matün ocueaj Teat Dios mambeol nej. ");
INSERT INTO huvNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Aaga naxey quiaj, ranüy tüünd majaw atnej aǘm, tajaw nop ángel ocueaj Teat Dios andüy wüx nchejliow nüt. Tajaw aaga ángel quiaj tajmel niüng ajlüy nej. Condom tasaj nej: ―¡Teat Cornelio! ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Cornelio mbayat xeyay wüx tajaw a ángel. Quiaj tapiüng: ―¿Cuane Teat? ―aw. Quiaj tasaj nej a ángel: ―Teat Dios teamanguiay aag itün ocueaj, teamajaw nguineay imbeol nipilan ngo majiür. ");
INSERT INTO huvNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Nganüy iich mambüw acas monxey tiül cambaj Jope, majanüw miün nop naxey nenüt Simón, aag ayaj nasoic Pedro. ");
INSERT INTO huvNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Nej acül aniüng nop naxey nenüt Simón, aaga nerang najiüt wüx taag. Aaga nden quiaj ajlüy mbeay ndec. Nej a Pedro quiaj, apmasaj ic cuane netam merang ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Wüx laámb aaga ángel tenguial andeac aweaag, quiaj Cornelio tapaj ijpüw monrang minajiüt nej, at alinop soldado neyamb Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Condom Cornelio wüx landoj masaj nejiw meáwan cuane tajaw, quiaj tüüch nejiw mambüw tiül cambaj Jope majanüw miün a Pedro. ");
INSERT INTO huvNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Amb alinoic nüt nejiw aliw tiül tiiüd, laliüc mapeayiw Jope. Aag ayaj laliüc lembem nüt. Pedro tajtep andüy cawüx mal iüm mataag orar. ");
INSERT INTO huvNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Condom tind üet a Pedro. Tenguialeámban arangüch üet nej, aleaic tajaw atnej aǘm. ");
INSERT INTO huvNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Quiaj taxom majaw atnej lejquiat a cielo. Tajaw aliüc imiün tiül cielo andüy wüx iüt atnej noic nadam püy, naoeloeleran oxing, tenguial aw tiüt. ");
INSERT INTO huvNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Tiül aaga püy quiaj, altiül cuajantanej nimal. Altiül nimal nejiür apiquiw oleaj; altiül nimal nesatatüy tiüt ajüy; altiül quiec aton. ");
INSERT INTO huvNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Quiaj tanguiay a Pedro andeac nop nendeac, tasaj nej: ―Pedro, witiür imbiy aag ayaj, itsamb ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Quiaj tapiüng a Pedro: ―Ngwüy Teat, cos xique nómban ngome aag natsamb ajcüwa ngo majneaj nimal quiaj leaw xicona ngondom natsamban ―aw. ");
INSERT INTO huvNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Quiaj tendeac amb ijmbüw aaga nendeac quiaj, tasaj nej: ―Leaw lamapiüng Teat Dios najneaj matsaramb, ique ngondom mepiüng ngo majneaj ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Aag ayaj tajaw arojmbüw. Condom, quiaj xaijnguiat alinomb aaga püy quiaj, andüy tiül cielo. ");
INSERT INTO huvNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pedro aliün wüx aag ayaj, tenguialeámban mayamb omeaats nguineay amb aaga landoj majaw quiaj. Quiaj apeayiw mbeay nden ajcüwa monxey üüch nejiw mambüw a Cornelio, cos landoj matüniw manguiayiw nguiane acül a Simón. ");
INSERT INTO huvNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Quiaj tendeacüw, tatüniw manguiayiw, sitiül quiaj axood nop naxey nenüt Simón nasoic Pedro. ");
INSERT INTO huvNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pedro tenguialeámban mayamb omeaats wüx aaga landoj majaw quiaj, quiaj tasaj nej Nangaj Espíritu ocueaj Teat Dios: ―Joyaj arojpüw monxey lapeayiw mayambüw ic. ");
INSERT INTO huvNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Nganüy iriow tiüt quiür ijawüw, iquiüjpüw mamb nde mechiw imeaats. Cos xique nejchiüs miünüw ningüy ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Quiaj taw tiüt a Pedro majaw ajcüwa monxey neech nejiw miünüw a Cornelio. Condom tasaj nejiw: ―Jogüy xic, teat. ¿Aleaic iyamban xic wüx tewiünan ningüye? ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Nejiw quiaj tapiüngüw: ―Nop minatang soldado nenüt Cornelio nesaj xicon niünan. Aaga naxey quiaj xeyay najneaj arang, ayamb Teat Dios. Aton meáwan nipilan judío apiüngüw nej xeyay najneaj arang. Nop ángel ocueaj Teat Dios landoj masaj nej miün mejanüch meamb aniüng nej manguiay leaw ique apmesaj ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Quiaj tamelich nejiw a Pedro, tüüch nejiw nguiane maxojtüw. Wüx larraw tiüt amb alinoic nüt, quiaj tamb a Pedro maquiiüb nejiw. At aton tambüw alacas minipilan Teat Jesús moncül tiül Jope. ");
INSERT INTO huvNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Larraw tiüt amb alinoic nüt, quiaj tatüchiw tiül cambaj Cesarea. Cornelio tenguial macül nejiw; laǘmb mapaj meáwan acualaats nej, at meáwan leaw xowüy andeac aweaag. ");
INSERT INTO huvNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Wüx tajmel tiül nden a Pedro, quiaj tamb a Cornelio mangoch nej, taquieel tiüt micos nej teombas a Pedro. ");
INSERT INTO huvNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Quiaj a Pedro tawitich nej, tasaj: ―Witiür teat, cos xique aton nipilan xic sat ic ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Tenguial andeac aweaag tajmeliw tiül iüm. Quiaj tajaw xeyay nipilan lacanchiüjow quiaj. ");
INSERT INTO huvNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Condom quiaj tasaj nejiw a Pedro: ―Icona lamejawan nguineay nop nipilan judío ngondom maquiiüb tiül pálwüx nipilan; at ngondom majmel aniüngüw nejiw. Pero Teat Dios lamüüch xic najaw, nejinguind nipilan ngondom mapiürang ngo majneaj, ngo metam nej. ");
INSERT INTO huvNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Pares wüx tasoiquiüs niün, quiaj tiünas, ngo napiüng nicuajind. Nganüy sandiüm nanguiay ¿neol tepajan xic niün? ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Quiaj tapiüng a Cornelio, tasaj nej: ―Xique lamajiür apeic nüt, aaga ores cam andüy wüx nchejliow nüt taiündas, tenguial sataag orar ningüy saniüng. Quiaj tajawas nop naxey alembem niüng sajlüy, xowüy lalitlit apix nej. ");
INSERT INTO huvNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Condom tasaj xic aaga naxey quiaj, tapiüng: “Cornelio, Teat Dios teamanguiay leaw itün ocueaj, aton teamajaw nguineay imbeol nipilan ngo majiür. ");
INSERT INTO huvNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Nganüy iich mamb majanüch miün nop naxey altiül cambaj Jope, nenüt Simón nasoic Pedro. Aaga naxey quiaj axood aniüng Simón aaga nerang najiüt wüx taag, acül mbeay ndec. Wüx apmapeay aaga naxey quiaj, nej apmasaj ic cuane netam merang”, aw. ");
INSERT INTO huvNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Quiaj tüjchiüs mamb mejanüch. Nganüy ique najneaj irang cos lerpeay. Meáwan xicona sajlüyiün ningüy narangan leaw Teat Dios andiüm, nanguiayiün meáwan leaw nej lamasaj ic mesaj xicon ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Quiaj a Pedro tendeac masaj nejiw, tapiüng: ―Nganüy lanajaw Teat Dios andiüm jangantanej nipilan, ngo mapiüng wüx jane netam, jane ngwüy. ");
INSERT INTO huvNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Nej najneaj majaw meáwan nipilan tiül meáwan cambaj wüx iüt jane apmayamb nej, jane apmarang najneaj. ");
INSERT INTO huvNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Teat Dios tüüch manguiayiw mipoch nej aaga cambaj Israel, pero tapiüng nej najneájan majaw meáwan nipilan leaw apmayar andeac Teat Jesucristo. Aaga Teat Jesús quiaj, minatang ocueaj meáwan nipilan. ");
INSERT INTO huvNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Icona lamenguiayiün cuane tajlüy meáwan tiül iüt Judea. Aag ayaj tamelich tiül Galilea, wüx Juan landoj maquiaach nipilan cuane netam marangüw para alndom mayariw yow. ");
INSERT INTO huvNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Lamejawan aton nguineay Teat Dios tayac Nangaj Miespíritu nej wüx ombas Teat Jesús naw Nazaret para marang cuajantanej. At lamejawan nguineay Teat Jesús tarang xeyay najneaj cos Teat Dios almaquiiüb nej. Nej aton tüüch majneaj meáwan nipilan leaw üüch nejiw michachiw nimeech. ");
INSERT INTO huvNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Xicona tajawasan naleaing meáwan leaw tarang Teat Jesús tiül iüt Judea, at tiül Jerusalén. Condom tayacüw nej wüx cruz mandeow. ");
INSERT INTO huvNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Aaga Jesús quiaj Teat Dios tapacüüch nej wüx er nüt; tüüch nej mejüiquichay najawan. ");
INSERT INTO huvNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Ngome meáwan nipilan tajawüw nej, áagan xicona leaw lasarriiüdaranan nandeacan wüx nej cuane tarang. Xicona tajawasan, cos tetesan, tanganeowasan naquiüjpan wüx landoj apac alinomb. ");
INSERT INTO huvNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Nej tasaj xicon namban nasajan nipilan, napiüngan naleaing Teat Dios lamayac nej majaw wüx asoet meáwan nipilan, leaw aliün mapac at leaw landeow. ");
INSERT INTO huvNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Meáwan mondeac andeac Teat Dios lamapiüngüw wüx nej tanomb. Tapiüngüw meáwan leaw apmayar andeac Teat Jesús, Teat Dios apmawün wüx omeaats nej asoetiw nejiw ―aw. ");
INSERT INTO huvNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Tenguialeámban mandeac a Pedro wüx aag ayaj, quiaj tiün Nangaj Espíritu ocueaj Teat Dios, tajmiüc wüx ombasüw meáwan nipilan leaw teamanguiayiw andeac nej. ");
INSERT INTO huvNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Quiaj mbayatoj ajcüwa judíos monyar andeac Teat Jesús leaw tambüw maquiüjpüw teat Pedro, cos tajawüw nguineay ajcüwa nipilan ngome judío lamayariw Nangaj Espíritu aton. ");
INSERT INTO huvNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Cos teamanguiayiw lamandeacüw alinoic ombeayiün, teamapiüngüw najneajay lamarang Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Condom tasaj nejiw a Pedro: ―¿Alndom aljane mapal, ngo mayariw yow ajcüwa nipilan quiaja? Cos nejiw aton lamayariw Nangaj Espíritu atnej icootsa ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Quiaj a Pedro tapiüng müüch nejiw mayariw yow wüx minüt Teat Jesús. Condom tasajüw a Pedro macül quiaj alacas nüt maquiiüb nejiw. ");
INSERT INTO huvNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Condom ajcüw apóstoles y aldemas minipilan Teat Jesús monlüy tiül Judea tanguiayiw nguineay ajcüwa nipilan ngome judíos aton lamayariw Mipoch Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Wüx tapeay Jerusalén a Pedro, quiaj taliquiaw nej ajcüwa judíos leaw lamandüjpiw Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Tasajüw: ―¿Neol teamb aniüngüw nipilan ngome icootsa meretiün mequiüjpana? ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Quiaj tapots masaj nejiw a teat Pedro andüübndüjpeay nguineay tajlüy, tapiüng: ");
INSERT INTO huvNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","―Xique sal tiül cambaj Jope, tenguial sataag orar. Quiaj tajawas aleaic atnej saǘm. Tajawas aliüc imiün tiül cielo atnej noic nadam püy, ndeaan oxingxing; aag ayaj tiün andüy niüng sajlüy. ");
INSERT INTO huvNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Tajawas majneaj tiül aag ayaj. Quiaj tajawas altiül cuajantanej nimal nejiür apiquiw oleaj; altiül napat nimal, altiül nimal nesatatüy tiüt ajüy, altiül quiec aton. ");
INSERT INTO huvNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Quiaj tanguiayiüs andeac nop nendeac, tasaj xic: “Pedro, witiür imbiy cuajantanej aag ayaj, itsamb”, aj xic. ");
INSERT INTO huvNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Quiaj a xique tasajas: “Ngwüy Teat, cos xique nómban ngomeaag natsamb ajcüwa ngo majneaj nimal quiaj, leaw xicona ngondom natsamban”, saj. ");
INSERT INTO huvNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Quiaj tasaj xic amb ijmbüw aaga nendeac imiün tiül cielo: “Leaw lamapiüng Teat Dios najneaj matsaramb, ique ngondom mepiüng ngo majneaj”, aj xic. ");
INSERT INTO huvNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Aag ayaj tajawas arojmbüw. Condom, quiaj xaijnguiat alinomb andüy tiül cielo. ");
INSERT INTO huvNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Condom, quiaj tapeayiw quiaj arojpüw monxey niüng saxood mayambüw xic, müjndiw miünüw imiün Cesarea. ");
INSERT INTO huvNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Quiaj tasaj xic a Nangaj Espíritu ocueaj Teat Dios namb naquiüjpüw nde nachiw ximeaats. Tambüw aton maquiüjpüw xic ajcüwa anaíw monyar andeac Teat Jesús cam. Tajmelasan aniüng nop teat naxey. ");
INSERT INTO huvNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Aaga teat naxey quiaj tasaj xicon nguineay tajaw nop ángel aniüng nej, lembet niüng ajlüy nej, tasaj nej: “Ijchaw mambüw acas monxey andüyiw Jope, majanüw miün nop naxey nenüt Simón, nasoic Pedro. ");
INSERT INTO huvNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Aaga naxey quiaj apmasaj ic nguineay alndom maw isoetiün, mequiiüb meáwan leaw al iniüng”, aj nej. ");
INSERT INTO huvNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Wüx tandeacas nasajüw, quiaj tayariw Nangaj Espíritu ocueaj Teat Dios atnej tayariiüts nomb. ");
INSERT INTO huvNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Quiaj leaad ximeaats nguineay tasaj icoots Teat Jesús wüx tapiüng: “Juan naleaing tüüch yow nipilan, aag ayaj náagan yow. Nganüy a icona apmeajndiün Nangaj Espíritu”, aw. ");
INSERT INTO huvNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Sitiül Teat Dios lamüüch nejiw Nangaj Espíritu aton, atnej tüüch icoots wüx tayariiüts andeac Teat Jesucristo ¿jow nganüy a xique, jane xic napiüng napal leaw andiüm Teat Dios? ―aj nejiw a Pedro. ");
INSERT INTO huvNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Wüx ndot manguiayiw aag ayaj, quiaj ndijchiütoj, apac omeajtsüw, tapiüngüw: ―¡Najneajay lamarang Teat Dios! Nganüy naleaing Teat Dios lamüüch nipilan ngome judíos leaam omeajtsüw ngo majneaj teamarangüw y macueatiw, cos atquiaj nejiw aton alndom mapacüw meáwan nüt tiül cielo ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Nganüy ajcüwa minipilan Teat Jesús leawa tawüniw oleajiw ajan wüx tajlüy nadam moncüy wüx tambiyaran Esteban, altiül tatüchiw tiül iüt Fenicia; altiül tambüw Chipre; altiül tatüchiw tiül cambaj Antioquía. Nejiw ngo masajüw meáwan nipilan wüx aaga najneaj nanderac wüx Teat Jesús, áagan nipilan judío tasajüw. ");
INSERT INTO huvNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Condom acas monyar andeac Teat Jesús monaw tiül Chipre, at monaw tiül cambaj Cirene, tambüw tiül cambaj Antioquía. Wüx tapeayiw quiaj, tasajüw nipilan griegos wüx aaga najneaj nanderac wüx Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Teat Dios xeyay tambeol nejiw; quiaj xeyay nipilan tayariw Mipoch Teat Dios, tacueatiw meáwan ngo majneaj leawa tarangüw. ");
INSERT INTO huvNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Minipilan Teat Jesús monlüy tiül Jerusalén wüx tanguiayiw aag ayaj, quiaj tüjchiw mamb andüy Antioquía a teat Bernabé mamb mambeol nejiw. ");
INSERT INTO huvNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Wüx tapeay quiaj a teat Bernabé, xeyay tapac omeaats wüx tajaw nguineay lamambeol nejiw Teat Dios. Quiaj tasaj nejiw mayacüw wüx omeajtsüw Mipoch Teat Dios tanaámb, nde macueatiw. ");
INSERT INTO huvNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Teat Bernabé najneaj omeaats, nómban ngo machiw omeaats wüx Teat Dios. At cos xeyay ambeol nej Nangaj Espíritu, xeyay nipilan tayariw Mipoch Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Ndoj tamb a Bernabé andüy tiül cambaj Tarso mayamb a Saulo. Wüx taxom, quiaj taquiiüb mamb andüy Antioquía. ");
INSERT INTO huvNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Quiaj tacüliw maquiüjpüw monyar andeac Teat Jesús nomb neat; taquiajchiw xeyay nipilan wüx Mipoch Teat Dios. Tiül Antioquía tamelich masoiquiw Cristiano nejiw leaw monyar andeac Teat Cristo. ");
INSERT INTO huvNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Tiül aaga nüt quiaj, tapeayiw Antioquía acas mondeac andeac Teat Dios monaw Jerusalén. ");
INSERT INTO huvNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Nop tiül nejiw nenüt Agabo. Aaga naxey quiaj tasaj nej Nangaj Espíritu ocueaj Teat Dios nguineay apmajlüy alinoic nüt. Quiaj witiüt masaj monyar andeac Teat Jesús wüx alcanchiümoj; tapiüng laliüc majlüy montiün andüy tiül meáwan cambaj, ngome apmajlüy nüeteran. Aag ayaj naleaing tajlüy wüx Claudio tarang natang nenajiüt tiül Roma. ");
INSERT INTO huvNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Quiaj minipilan Teat Jesús monlüy tiül Antioquía tapiüngüw anopnopoj apmambeolüw monyar andeac Teat Jesús monlüy tiül Judea; apmüjchiw leaw alndom. ");
INSERT INTO huvNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Naleaing atquiaj tarangüw, tüjchiw mamb aaga leaw üjchiw quiaj majoyiw mamb a Bernabé maquiiüb a Saulo, müjchiw montangtang tiül monyar andeac Teat Jesús monlüy tiül Judea. ");
INSERT INTO huvNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Wüx aaga nüt quiaj, aaga Herodes minatang nenajiüt tayamb ombas minipilan Teat Jesús. Tasap acas müüch mamongochiw xeyay ngo majneaj. ");
INSERT INTO huvNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ndoj tapiüng mambiyaran a Jacobo (Santiago minüt nej aton) micoj a Juan, tambiyaw naag espada. ");
INSERT INTO huvNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Condom Herodes wüx tajaw ajcüwa judíos najneájan majawüw aaga arang quiaj, quiaj tasap teat Pedro mayac tiül manchiüc aton. Naleaing tiül aaga nüt quiaj arangüw nangos nüt wüx üetiw pan ngo majmel levadura. ");
INSERT INTO huvNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Wüx lamasap a Pedro mayac tiül manchiüc, quiaj tayac teowixaw apiquiw ajlüy soldados monjiür manchiüc, majiürüw. Aag ayaj ajlüy apiquiw soldados tiül noicnoic ajlüy. Cos Herodes apiüng wüx landoj pascua, quiaj apmawün a Pedro mayac teowix cambaj. ");
INSERT INTO huvNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Pedro tajiürüch majneaj tiül manchiüc. Nganüy ajcüwa minipilan Teat Jesús xeyay tatajcüw orar Teat Dios mambeol nej. ");
INSERT INTO huvNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Tiül aaga ongwiiüts quiaj, wüx Herodes apmawün a Pedro müüch cambaj ráwan tiüt, Pedro almameay pinawan niüng ajlüyiw ijpüw soldados. Netsaag naag ijtsüw galen; aliw tiül ombeay manchiüc alijpüw soldados tenguial majiürüw nej. ");
INSERT INTO huvNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Quiaj tapeay niüng ajlüy nej nop ángel ocueaj Teat Dios, anmarraj tiül manchiüc, tareeg teombaj a Pedro mapacüüch, tasaj: ―Witiür najénan ―aj. Tanaámb sojndiow aaga galen netsajcüy owix nej. ");
INSERT INTO huvNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Quiaj tasaj nej a ángel: ―Ersoijquiay, aton isooig ipaj ―aj nej. Pedro atquiaj tarang. Condom aaga ángel tasaj nej alinomb: ―Isooig najal micamix, mac tabar ―aj nej. ");
INSERT INTO huvNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Quiaj taw a Pedro tandüüb mamb a ángel. Naleaing ngo majaw sitiül naleaing meáwan leaw lamarang aaga ángel quiaj, tengwüy ajáwan. Nej apiüng aag ayaj ajáwan atnej maǘm. ");
INSERT INTO huvNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Condom tamongoj noic ombeay manchiüc niüng ajlüy nop soldado nejiür manchiüc. Condom tamongoj amb ijquiaw ombeay manchiüc niüng ajlüy alinop soldado. Wüx tatüchiw aaga nadam ombeay manchiüc niüng awaran andüy tiül cambaj, aag ayaj narangüch manchiüc, lejquiat nejáyan quiaj. Quiaj tambüw. Condom wüx tatüchiw nots calle, quiaj tacueat nej a ángel. ");
INSERT INTO huvNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Quiaj rat andüy a Pedro, tapiüng: ―Nganüy sajaw naleaing Teat Dios tüüch miün miángel nej mawün xic teowix Herodes, ngana majlüy atnej andiümüw marangüw ajcüwa nipilan judío quiaj ―aw. ");
INSERT INTO huvNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Atquiaj tapiüng tiül omeaats, condom tamb andüy aniüng María mimüm a Juan, aaga nasoic Marcos aton. Quiaj alcanchiümoj xeyay minipilan Teat Jesús tenguial atajcüw orar. ");
INSERT INTO huvNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Wüx tapeay mbeay nden, quiaj tendeac. Quiaj tiün nop nüx nenüt Rode majaw jane. ");
INSERT INTO huvNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Aaga nüx quiaj wüx tanguiay andeac a Pedro, xeyay apac omeaats, ngo maleaaig ombeay nden, andilílan tiüt andüy tiül nden masaj nejiw lapeay a Pedro, al mbeay nden. ");
INSERT INTO huvNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Quiaj tasajüw nej monlüy quiaj: ―¡Nerchach! ―ajüw nej. Nej nomb apiüng naleaing. Quiaj tapiüngüw: ―Ngome nej, aag ayaj miángel nej ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Pedro nde asap andeac mbeay nden. Wüx tambüw maleajquiw, quiaj tajawüw naleaing. Quiaj mbayatoj xeyay. ");
INSERT INTO huvNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Pedro tarang owix ndijchiümoj. Quiaj tapots masaj nejiw nguineay tawün nej tiül manchiüc Teat Dios. At tasaj nejiw: ―Ijchan manguiay a Jacobo, at meáwan minipilan Teat Jesús ―aj nejiw. Condom taw quiaj, tamb. ");
INSERT INTO huvNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Camüm ram tiüt mbayajow a soldados. Xeyay tendeacndeacüw wüx, cos ngo majawüw nguineay taw a Pedro. ");
INSERT INTO huvNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Condom Herodes tüüch mamb mayambüch a Pedro. Wüx laímb mayamb ngo maxom, quiaj tandüy wüx matüntün manguiay ajcüwa soldados monjiür manchiüc. Condom tüüch mamb maquiürajpüw mandeowüw. Ndoj Herodes taw Judea, tamb macül tiül cambaj Cesarea. ");
INSERT INTO huvNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herodes xeyay tajcüy majaw nipilan monaw tiül cambaj Tiro at monaw tiül cambaj Sidón. Pero nipilan monaw Tiro maquiiüb Sidón tandeacüw nóiquian, mambüw majawüw aaga nenajiüt quiaj. Tandeacüw maquiüjpüw a Blasto mambeol nejiw. Aaga naxey quiaj, natang nejiür najiüt ocueaj Herodes. Quiaj tatüniw ocueaj a Herodes nde majcüyaran majarawüw. Cos nejiw teamaxomüw nüeteran naw tiül meáwan cambaj leaw Herodes ajlüy wüx. ");
INSERT INTO huvNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Herodes tayac noic nüt sonongom nipilan manguiayiw andeac nej. Condom wüx tatüch a nüt, tasooig najneaj apix nej, apix minatang nenajiüt. Ndoj tsotot tiül apal nej. Quiaj tapots andeac masaj nipilan. ");
INSERT INTO huvNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Quiaj tepajüw nipilan napac. Tapiüngüw: ―¡Nop dios teandeac quiaj, ngome nipilan! ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Quiaj ajngot iün andeow a Herodes, tüüch nej miün andeow nop ángel ocueaj Teat Dios, cos tayaag nej xeyay atam ajlüy; nganüy Teat Dios ngo metam. Quiaj tandeow, tendiüc. ");
INSERT INTO huvNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Naleaing Mipoch Teat Dios tajüy xeyay, tanguiayaran nguiajantanej. ");
INSERT INTO huvNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Bernabé maquiiüb a Saulo wüx landoj marangüw minajiütüw nejiw tiül Jerusalén, quiaj tandilileaw alinomb andüyiw Antioquía, taquiüjpüw mamb a Juan nasoic Marcos. ");
INSERT INTO huvNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Tiül nipilan monyar andeac Teat Jesús monlüy tiül Antioquía altiül acas mondeac andeac Teat Dios, aton altiül monquiaach wüx Mipoch Teat Dios. Ajcüw ayaj nop Bernabé, alinop Simón nasoic Niger, alinop Lucio naw Cirene, alinop Manaén, alinop Saulo. Aaga naxey nenüt Manaén quiaj, tatang aweaag a Herodes, aaga nenajiüt tiül Galilea. ");
INSERT INTO huvNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Noic nüt wüx alxenenguemoj tenguial anderac Mipoch Teat Dios aton wüx teaiündüw, quiaj tasaj nejiw Nangaj Espíritu ocueaj Teat Dios, tapiüng: ―Iwüniün xicueaj a Bernabé maquiiüb a Saulo marangüw xenajiüt leawa lanateots nüjchiw ―aw. ");
INSERT INTO huvNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Quiaj wüx landoj aiündüw, landoj matüniw ocueaj Teat Dios, tayacüw owixaw wüx omalüw a Bernabé maquiiüb a Saulo. Condom tetepeayayej maquiüjpüw, quiaj tawüw quiaj. ");
INSERT INTO huvNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Condom tambüw niüng Nangaj Espíritu ocueaj Teat Dios lamüüch nejiw mayajcüw netam mambüw. Quiaj tambüw andüyiw tiül cambaj Seleucia. Condom nawüw quiaj tajtepiw tiül nadam müx, tandüyiw wüx noic iüt tiül ndec nasoic Chipre. ");
INSERT INTO huvNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Wüx tajtepiw wüx iüt tiül cambaj Salamina, quiaj tandeacüw Mipoch Teat Dios tiül meáwan sinagogas. At almaquiüjpüw a Juan mambeol nejiw. ");
INSERT INTO huvNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Wüx laǘmb majüyiw tiül aaga nine iüt tiül ndec, quiaj tatüchiw tiül cambaj Pafos. Taxomüw quiaj nop naxey nenüt Barjesús, nop judío nej. Aaga naxey quiaj nop nesüet, y apiüng nej nop nendeac andeac Teat Dios, pero aag ayaj ngo maleaing. ");
INSERT INTO huvNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Aaga naxey mbich meaw maquiiüb nop nenajiüt nenüt Sergio Paulo, nenajiüt nej tiül aaga iüt quiaj. Aaga nenajiüt quiaj, xeyay fis ajiür. Nej tüüch mamb majpajüw miün a Bernabé y Saulo, cos andiüm manguiay Mipoch Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Pero aaga newüyay asüet aton nasoic Elimas tiül ombeayiw Griegos; nej tandiüm mapal nejiw, cos ngo mandiüm majaw mayar Mipoch Teat Dios aaga nenajiüt quiaj. ");
INSERT INTO huvNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Quiaj a Saulo nasoic Pablo aton, tayaag tiül omeaats nej a Nangaj Espíritu ocueaj Teat Dios, quiaj tajaw teombas aaga naxey quiaj. ");
INSERT INTO huvNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Tasaj: ―¡Ique minaj ic newaiich, nerang xeyay ngo majneaj, micual ic minatang nimeech, cos ijcüy mejaw monrang najneaj! ¿Neol tapots iwaiich nipilan nde mayariw Mipoch Teat Dios? ");
INSERT INTO huvNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Nganüy Teat Dios apmüüch ic memongoch xeyay ngo majneaj, apmersomb, ngome apmexom mejaw a nüt acas nüt ―aj. Quiaj pojniüt oniiüg aaga naxey quiaj, nómban ngo maxom majaw nicuajind. Ndoj tapots ajüyjüy, amb ninguiün amb ninguiün mayamb jane manetet nej owix. ");
INSERT INTO huvNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Aaga naxey nenajiüt quiaj wüx tajaw aag ayaj, quiaj tayar Mipoch Teat Dios, mbayat manguiay leaw aquiajchiw wüx Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Condom tawüw Pafos a Pablo maquiiüb leaw aquiiüb mamb, tambüw ambüw tiül müx, tandüyiw tiül cambaj Perge tiül Panfilia. Condom wüx tapeayiw quiaj, quiaj tacueat nejiw a Juan, tandilil alinomb andüy Jerusalén. ");
INSERT INTO huvNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Condom nejiw tawüw Perge, tandüyiw tiül cambaj Antioquía tiül Pisidia. Wüx tapeayiw quiaj, tambüw tajmeliw tiül nangaj iüm wüx nüt axoodaran, chetemoj. ");
INSERT INTO huvNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Wüx landoj ateoraw tiül Mipoch Teat Dios leaw tüünd a Moisés, at leaw tarangüw mondeac andeac Teat Dios, quiaj montangtang tiül a sinagoga, tüjchiw mamb masoiquiw a Pablo y a Bernabé sitiül ajiürüw noic poch mapiüngüw. Tasoiquiw: ―Teat monxey, sitiül almejiüran alngün poch mepiüngan manguiayiw nipilan, alndom mepiüngan ―ajowiw. ");
INSERT INTO huvNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Quiaj witiüt a Pablo lembem, tarang owix nej ndijchiümójan. Condom tasaj nejiw: ―Teat monxey micual iüt Israel, at icona monyar andeac Teat Dios, inguiayiün sanasaj icon: ");
INSERT INTO huvNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Aaga Teat Dios Midiosüw cambaj Israel, nej tarriiüd ajcüwa mixejchiiüts monlüy tanomb. Condom tüüch nejiw mexeyayiw wüx tacüliw tiül Egipto, tiül miíüt pálwüx nipilan. Ndoj tawün nejiw quiaj. ");
INSERT INTO huvNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Condom wüx tacüliw tiül wajchiüc ic miow (40) neat, taíüc wüx meáwan leaw tarangüw. ");
INSERT INTO huvNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Wüx tajmeliw tiül iüt Canaán, nej tandrooch ombas ayaíw nadamdam cambaj tiül aaga iüt quiaj, müüch mixejchiiüts maneayiw aaga iüt quiaj. ");
INSERT INTO huvNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Condom tatüch apiquiw acoic miow ic miow gajpowüw (450) neat, meáwan tiül aaga neat quiaj, Teat Dios tayac jueces majawüw wüx asoetiw nipilan. Tiün mandondoch wüx tajlüy aaga Samuel, nop nendeac andeac Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Condom tatüniw ocueaj Teat Dios mayac nop natang nenajiüt tiül nejiw, aaga nasoic rey. Quiaj Teat Dios tayac a Saúl, micual Cis, marang natang nenajiüt tiül nejiw ic miow neat. Aaga naxey quiaj naw tiül acualaats Benjamín. ");
INSERT INTO huvNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Ndoj, wüx Teat Dios tawün a Saúl, tayac a David mingow. Cos Teat Dios lamapiüng aag ayaj tanomb wüx tapiüng: “Lanaxom a David micual Isaí. Aaga naxey quiaj xeyay apac ximeaats najaw, nej apmarang meáwan leaw xique sandiüm”, aw. ");
INSERT INTO huvNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Naw tiül micual nej aaga rey David quiaj, wüx lamong xeyay neat, quiaj tiün majlüy Teat Jesús. Teat Dios tayac nej mawün asoetiw cambaj Israel, atnej lamapiüng apmarang. ");
INSERT INTO huvNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Pero nganaw mapeay a Teat Jesús, quiaj aaga Juan neech yow nipilan tasaj a cambaj Israel leaam omeajtsüw wüx aaga xeyay ngo majneaj teamarangüw, macueatiw, cas tayariw yow. ");
INSERT INTO huvNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Juan wüx laliüc ndom minajiüt nej, tasaj nipilan: “¿Jane xic ipiüngan? Ngome xique leawa temepiüngan quiaj. Aliüc miün nop, aag ayaj xeyay netam ajlüy, xique ngo nembeat nicuajind, ngondom natüch nasoond apaj nej”, aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","’Nganüy xique sasaj icon menguiayiün Teat monxey, micual acualaats Abraham, at icona monyamb Teat Dios: Aaga poch nepiüng wüx nguineay Teat Dios alndom mawün asoet nipilan, icona netam menguiayiün, meyariün. ");
INSERT INTO huvNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Cos ajcüwa micual miiütaats moncül tiül Jerusalén, at monajiüt tiül nejiw ngome tajawüw jane nej Teat Jesús. Cos ngo maxomüw omeajtsüw wüx Mipoch Teat Dios leaw tarangüw mondeac andeac Teat Dios, nateoraw wüx nüt axoodaran. Áag nejiw tayacüw asoet Teat Jesús mandeow. Quiaj tajlüy atnej landoj lajlüy tiül Mipoch Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Masey ngo maxomüw wüx ombas Teat Jesús nicuajind nisoet para mandeow, nejiw tasajüw a Pilato mapiüng mandeow. ");
INSERT INTO huvNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Nejiw ngo leaam omeajtsüw, tarangüw meáwan leaw larangüch tiül Mipoch Teat Dios nguineay apmajlüy wüx ombas Teat Jesús. Wüx landeow, quiaj tajwan tiüt imiün wüx cruz. Condom tamiüraad. ");
INSERT INTO huvNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Pero naleaing Teat Dios tapacüüch nej alinomb. ");
INSERT INTO huvNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Ndoj tejüiquichay xeyay nüt majawüw nej ajcüw leawa taquiüjpüw nej naw tiül Galilea, andüy Jerusalén. Nganüy nejiw tenguial masajüw nipilan leaw tajawüw. ");
INSERT INTO huvNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","’Nganüy xicona aton teanasajan icon wüx aaga najneajay majlüy, cos aag ayaj Teat Dios lamasaj mixejchiiüts. ");
INSERT INTO huvNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Nganüy lajlüy atnej Teat Dios lamapiüng apmajlüy tiül micualüw nejiw mixejchiiüts; ajcüw ayaj icootsa. Teat Dios tapacüüch alinomb Teat Jesús atnej larangüch tiül amb ijquiaw Salmo, cos apiüng: “Ique Xecual ic, nganüy lanüüch ic wijquiamear”, aw. ");
INSERT INTO huvNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Teat Dios tapacüüch nej alinomb, ngo müüch nej majmboc, cos atquiaj lajlüy tiül Mipoch Teat Dios, niüng Teat Dios apiüng: “Xique naleaing sanajiür icon lasta, cos sanarang atnej tasajas a David”, aw. ");
INSERT INTO huvNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Áag Teat Dios tapiüng tiül alinoic Salmo, wüx David tarang wüx nawiig, tapiüng: “Nde meaach majmboc aaga nangaj micual”, aw. ");
INSERT INTO huvNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Cos naleaing David wüx landoj arang natang tiül nipilan atnej lamasaj nej Teat Dios, quiaj tandeow. Condom tamiüraad niüng tamiürajtüw montangtang tajlüyiw tanomb, micuerpo nej tajmboc. ");
INSERT INTO huvNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Nganüy micuerpo Teat Jesús ngo majmboc, cos Teat Dios tapacüüch nej alinomb. ");
INSERT INTO huvNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Teat monxey micual xeíüt, netam mejawan, nganüy tenguial nasajan icon áagan wüx Teat Jesús alndom meriowan wüx isoetiün. ");
INSERT INTO huvNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Meáwan nisoet leaw aaga poch tüünd Moisés apiüng ngondom maw, aaga nisoet quiaj alndom maw ocueaj jane apmayar andeac Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Nganüy netam mejawan, nde memongochiün atnej lamapiüng tiül Mipoch Teat Dios leaw tarangüw mondeac andeac Teat Dios, apiüng: ");
INSERT INTO huvNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Icona mondam omeaats, ijawan wüx, cos apmbayameron apndromeron. Cos xique aleaic sanarang wüx aliün mepacan. Aag ayaj icona apmepiüngan ngo maleaing, masey aljane apmasaj icon, aw ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Wüx tawüw imiünüw tiül a sinagoga ocueajiw judíos, quiaj tatüniw nej ocueajiw nipilan ngome judío, sitiül apmandüyiw quiaj alinomb wüx apmatüch alinoic nüt maxoodaran masajüw nejiw alquiriw wüx aaga poch quiaj. ");
INSERT INTO huvNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Wüx landajrriüjow imiünüw tiül a sinagoga, quiaj tandüjpiw a Pablo y Bernabé xeyay nipilan judío, at nipilan ngome judío leaw lamayambüw Teat Dios. Condom Pablo y Bernabé tasajüw nejiw mayacüw wüx omeajtsüw Mipoch Teat Dios y mimonajneaj nej. ");
INSERT INTO huvNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Wüx tatüch alinoic nüt axoodaran, tajlüy mümb mamb meáwan nipilan monaw tiül cambaj manguiayiw Mipoch Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Pero wüx ajcüwa judíos tajawüw laxeyay nipilan, quiaj tajcüyiw, ngo majneaj majawüw. Xeyay ngo majneaj tandeacüw wüx leaw Pablo taquiaach, tapiüngüw aag ayaj ngo maleaing. ");
INSERT INTO huvNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Quiaj tandeacüw a Pablo y Bernabé, ngo mimboloj, tasajüw nejiw: ―Naleaing icona ombas nasajan icon wüx Mipoch Teat Dios cos judíos icon. Pero icona ngo meyariün, pares ngome apmeajndiün mepacan meáwan nüt niüng ajlüy Teat Dios. Nganüy sanamban nasajan nipilan ngome judío. ");
INSERT INTO huvNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Cos atquiaj lamasaj xicon Teat Dios narangan, atnej lamapiüng tiül Mipoch nej: Lanayac ic mejlüy atnej ran ocueajiw palpálwüx nipilan ngome judío, meamb mesajüw meáwan nipilan wüx iüt nguineay alndom maw asoetiw nejiw ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ajcüwa nipilan ngome judíos, wüx tanguiayiw aag ayaj, xeyay tapac omeajtsüw, najneajay majawüw Mipoch Teat Dios. Tüjchiw omeajtsüw Teat Dios meáwan leaw landoj lamapaj nejiw Teat Dios majlüyiw najneajay, mapacüw meáwan nüt tiül cielo. ");
INSERT INTO huvNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Quiaj tanguiayaran Mipoch Teat Dios meáwan tiül aaga iüt quiaj. ");
INSERT INTO huvNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Pero ajcüwa judíos leawa ngo mayariw mipoch Teat Dios tasajüw montangtang ombas montaj leaw andüjpiw Mipoch Teat Dios, at montangtang ombas monxey tiül aaga cambaj quiaj, majcüyiw majawüw a Pablo y Bernabé. Quiaj witiüt noic nadam moncüy wüx ombasüw Pablo y Bernabé, tawüniw nejiw nómban tiül aaga iüt quiaj. ");
INSERT INTO huvNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Nejiw quiaj tatajtüw minajndot oleajiw nejiw, cas tambüw tandüyiw tiül cambaj Iconio. ");
INSERT INTO huvNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Meáwan leaw lamayariw andeac Teat Jesús xeyay tapac omeajtsüw, tajlüy wüx ombasüw nejiw Nangaj Espíritu ocueaj Teat Dios, tambeol nejiw. ");
INSERT INTO huvNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Pablo y Bernabé tapeayiw tiül cambaj Iconio; tambüw tiül a sinagoga ocueajiw nipilan judío. Wüx tandeacüw wüx Teat Jesús, tayariw aag ayaj xeyay nipilan judío, at xeyay nipilan griego aton. ");
INSERT INTO huvNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Pero ajcüwa judíos leaw ngo mayariw aaga poch quiaj, tambüw tapots mawaijchaw ajcüw pálwüx nipilan, mapiüngüw nipilan monyar andeac Teat Jesús ngo majneaj teamarangüw. ");
INSERT INTO huvNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Pares tacüliw quiaj a Pablo y Bernabé xeyay nüt. Nejiw tandeacüw wüx Teat Jesús ngo mimboloj cos ayacüw omeajtsüw wüx nej. Aton nej tüüch nejiw ndoj ombasüw marangüw cuajantanej ateócan leawa ngome aag ajaraw. Atquiaj tarang majüiquich naleaing meáwan leaw andeacüw quiaj. ");
INSERT INTO huvNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Nipilan tiül aaga cambaj quiaj, ngo majlüyiw nóiquian; altiül tambeolüw ajcüwa judíos, altiül tambeolüw apóstoles. ");
INSERT INTO huvNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Condom ajcüwa judíos maquiüjpüw nipilan ngome judíos, witiütoj nóiquian maquiüjpüw monajiüt majcüyiw majawüw apóstoles, andiümüw maloxiw naag piedra, mambiyaw. ");
INSERT INTO huvNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Nejiw a Pablo y Bernabé, wüx tanguiayiw aag ayaj, quiaj tawüniw oleajiw, tandüyiw tiül ajcüwa cambaj Listra y Derbe tiül iüt Licaonia, at tambüw tiül meáwan nine cambaj quiájan. ");
INSERT INTO huvNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Meáwan tiül niüng tambüw tasajüw nipilan aaga najneajay poch wüx Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Tiül cambaj Listra, alquiaj nop naxey chetéjan ngondom majüy, necoex nde wijquiaw, ngome aag ajüy. ");
INSERT INTO huvNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Aaga naxey quiaj teamanguiay meáwan leaw teamandeac a Pablo. Wüx Pablo tajaw nej majneaj, quiaj tajaw aaga naxey quiaj ajüic ayaag tiül omeaats naleaing Teat Dios alndom mataag nej majneaj. ");
INSERT INTO huvNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Quiaj tendeac a Pablo, tasaj nej napac: ―Witiür lember ―aj. Aaga naxey quiaj, ajchic lembem, quiaj tajüy. ");
INSERT INTO huvNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Nipilan wüx tajawüw nguineay lamarang a Pablo, quiaj tepajüw napac, tandeacüw wüx ombeayiw nejiw, tapiüngüw: ―¡Lapeayiw a dios imiünüw cawüx, at nejiw nipilan! ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Condom tüjchiw manüt a Bernabé, Júpiter, atnej minüt nop midiosüw nejiw, nganüy a Pablo tüjchiw manüt Mercurio, atnej minüt alinop midiosüw nejiw, cos Pablo nendeac. ");
INSERT INTO huvNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Condom nop miteaats ocueaj aaga dios Júpiter, taquiiüb mamb acas boy, aton ajoy mbaj nembet mandiig a boy, laámb andüy mbeay cambaj niüng ajlüy ombiüm aaga dios Júpiter. Xeyay nipilan taquiüjpüw nej mamb; apmambiyaw a boy mayacüw ichechiw nejiw. ");
INSERT INTO huvNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Ajcüw apóstoles Bernabé y Pablo wüx tanguiayiw aag ayaj, quiaj tachiütüw apixaw nejiw, tajmeliw tiül a xeyay nipilan mapalüw teombas, tendeacüw napac, tapiüngüw: ");
INSERT INTO huvNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","―¡Monxey! ¿Neol tepiüngan merangan aag ayaja? Xicona aton nipilan xicon atnej ijlüyiün. Xicona xiünan nasajan icon mecueatiün iyamban cuajantanej narangüch dios, mendüjpiün áagan Teat Dios almapac, aag nerang cielo, nerang iüt, nerang ndec, nerang meáwan leaw almajlüy. ");
INSERT INTO huvNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Naleaing tanomb nej tüüch majlüyíwan meáwan nipilan, marangüw leaw andiümüw. ");
INSERT INTO huvNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Pero naleaing Teat Dios ngo macueat nejiw nómban, cos tenguial majüiquich jane nej wüx arang meáwan najneaj; nej üüch majoet, üüch mayac aóng meáwan cuajantanej napiürüch. Aton üüch icoots nüeteran, üüch mapac omeajtsaats ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Masey atquiaj tapiüngüw a Pablo y Bernabé, pero xeyay taél ocueajiw para mapalüw teombas a nipilan, ngana mambiyaw a nimal mayacüw ichechiw, müjndiw. ");
INSERT INTO huvNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Condom tapeayiw quiaj acas judíos monaw Antioquía at monaw Iconio. Ajcüw ayaj taquiajchiw ombeay nipilan majcüyiw majawüw a Pablo, mambiyaw. Quiaj tajcüyiw a nipilan, tapots maloxiw a Pablo naag piedra. Condom tanototoj tiüt, taquiüjpüw mamb maloxiw mbeay cambaj, apiüngüw landeow nómban. ");
INSERT INTO huvNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ndoj, wüx xenenguetoj monyar andeac Teat Dios niüng ajlüy nej, quiaj tapac witiüt. Condom tandüy tiül cambaj alinomb maquiiüb nejiw. Wüx rat tiüt amb alinoic nüt, quiaj taw quiaj maquiiüb Bernabé, tandüyiw Derbe. ");
INSERT INTO huvNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Wüx landoj mandeacüw aaga najneajay poch tiül cambaj Derbe, y wüx lajlüy xeyay monyar andeac Teat Jesús, quiaj tandilileaw alinomb andüyiw Listra. Condom tandüyiw Iconio, naw quiaj tandüyiw Antioquía. ");
INSERT INTO huvNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Meáwan leaw niüng tamongoj, tüjchiw mapac omeajtsüw leaw monyar andeac Teat Jesús, tasajüw nde machiweaw omeajtsüw wüx Teat Dios, tasajüw: ―Netam mamongochiiüts xeyay ngo majneaj, cos atquiaj alndom majmeliiüts tiül micambaj Teat Dios ―ajüw. ");
INSERT INTO huvNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","At aton tayacüw acas montangtang tiül monyar andeac Teat Jesús leaw niüng tamongoj. Aag ayaj wüx ndoj aiündüw matüniw ocueaj Teat Dios, quiaj lamayacüw teowix Teat Dios ajcüwa nipilan lamayariw nej andeac, mambeol nejiw. ");
INSERT INTO huvNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Condom nawüw Antioquía tambüw tamongoj tiül Pisidia, quiaj tatüchiw Panfilia. ");
INSERT INTO huvNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Ndoj mandeacüw Mipoch Teat Dios tiül cambaj Perge, quiaj tambüw andüyiw tiül cambaj Atalia. ");
INSERT INTO huvNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Condom nawüw quiaj, tajtepiw tiül müx, tandüyiw Antioquía tiül Siria niüng tayacüchiw teowix Teat Dios, mambeol nejiw wüx aaga najiüt leaw landoj marangüw quiaj. ");
INSERT INTO huvNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Wüx tapeayiw Antioquía, taxejnenguiw meáwan monyar andeac Teat Dios. Condom tapots masajüw nguineay tambeol nejiw Teat Dios, nguineay lamayariw Mipoch Teat Dios xeyay nipilan leaw ngome israel. ");
INSERT INTO huvNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Ndoj Pablo y Bernabé tacüliw quiaj xeyay nüt maquiüjpüw monyar andeac Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Condom tapeayiw tiül Antioquía acas monquiaach imiünüw tiül Judea. Ajcüw ayaj taquiajchiw monyar andeac Teat Cristo monlüy quiaj; tasajüw sitiül ngo majlüyiw circuncidado atnej apiüng Moisés marangüch, Teat Dios ngome apmawün asoetiw nejiw. ");
INSERT INTO huvNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Quiaj tajlüy noic nadam mondeacndeac, cos Pablo y Bernabé ngo majneaj majawüw aag ayaj. Quiaj tasoiquiw a Pablo y Bernabé mambüw Jerusalén maquiüjpüw alacas monaw quiaj, majawüw ajcüw apóstoles at montangtang monajiüt tiül mondüüb Teat Cristo, majawüw wüx aaga mondeac quiaj. ");
INSERT INTO huvNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Condom ajcüw minipilan Teat Jesús tambeolüw nejiw mambüw. Quiaj tambüw. Wüx tamongoj tiül Fenicia at tiül Samaria tandeacüw masajüw minipilan Teat Jesús nguineay lamayariw Mipoch Teat Dios xeyay palpálwüx nipilan ngome judíos. Wüx tanguiayiw aag ayaj, xeyay tapac omeajtsüw. ");
INSERT INTO huvNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Wüx tapeayiw Jerusalén, apac omeajtsüw majawüw nejiw meáwan minipilan Teat Jesús, átan apóstoles, átan montangtang. Quiaj nejiw a Pablo y Bernabé tapots masajüw nejiw nguineay tambeol nejiw Teat Dios marangüw minajiüt nej. ");
INSERT INTO huvNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Condom acas monxey monaw tiül fariseos, leaw lamayariw andeac Teat Jesús, witiütoj tapiüngüw: ―Netam matajcüchiw circuncidar ajcüwa nipilan ngome judíos, aton masoiquiw marangüw meáwan atnej apiüng tiül aaga poch tüünd Moisés ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Quiaj xenenguetoj ajcüw apóstoles at montangtang majawüw nguineay apmajlüy wüx aaga mondeac quiaj. ");
INSERT INTO huvNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Wüx laxeyay mandeacüw wüx aag ayaj, quiaj witiüt a Pedro masaj nejiw: ―Xecojow xechijquiaw, lamajiür nüt icona tejawan nguineay tarriiüd xic Teat Dios namb nasajüw aaga najneajay poch nguineay Teat Cristo awün asoeteran, manguiayiw ajcüwa nipilan ngome judíos y mayariw aag ayaj aton. ");
INSERT INTO huvNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Teat Dios nejaw tiül omeaatsaran, tajüiquich majaraw naleaing lamayar nejiw cos tiün wüx nejiw Nangaj Espíritu ocueaj Teat Dios atnej tiün wüx icoots. ");
INSERT INTO huvNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Teat Dios ngo marang pálwüx tiül icootsa, pálwüx tiül nejiw, cos nej tawün asoetiw nejiw aton, wüx tayacüw omeajtsüw wüx nej. ");
INSERT INTO huvNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Jow nganüy, ¿neol tendiüman meajchiün majcüy Teat Dios? ¿Neol icona tendiüman meajchiün marangüw monyar andeac Teat Jesús leaw mixejchiiüts átan icootsa ngome tarangaats palan atnej netama? ");
INSERT INTO huvNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Masey nganüy icootsa ajawaats Teat Jesús nde ajneaj omeaats lamawün asoetiiüts, ngome cos aleaic arangaats; atquiaj arang wüx nejiw aton ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Quiaj ndijchiütoj meáwan, condom tanguiayiw meáwan tandeacüw Bernabé y Pablo cos tasajüw nguineay tambeol nejiw Teat Dios marangüw tiül palpálwüx nipilan cuajantanej ateócan leaw ngome aag ajaraw. ");
INSERT INTO huvNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Wüx landoj andeacüw a Pablo maquiiüb a Bernabé, quiaj tapiüng a Jacobo: ―Xecojow xechijquiaw, inguiayiün sanasaj icon: ");
INSERT INTO huvNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Teat Simón Pedro landoj mandeac nguineay tajlüy wüx Teat Dios tamelich mambeol ajcüwa nipilan ngome judíos mayariw nej andeac marangüw minipilan nej aton. ");
INSERT INTO huvNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Aag ayaj lamapiüng tiül Mipoch Teat Dios leaw tarangüw mondeac andeac nej niüng apiüng: ");
INSERT INTO huvNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Ndoj aag ayaj sanandilil alinomb, sanawitich alinomb aniüng David cos lajmiüc; sanataag majneaj leaw ndrot ombas, sanalomboch alinomb. ");
INSERT INTO huvNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Atquiaj sanarang para mayariw andeac Teat Naxey meáwan nipilan leaw alíünan. Aton meáwan nipilan monaw palpálwüx iüt apmarangüw xenipilan, aw. ");
INSERT INTO huvNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Atquiaj tapiüng Teat Dios, cos nej lamüüch majaraw wüx aag ayaj nde tanomb. ");
INSERT INTO huvNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","’Nganüy xique sapiüng nde maxolaats ajcüwa nipilan ngome judíos sitiül lamacueatiw arangüw ngo majneaj y lamandüjpiw Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Ǘpan marangaats noic nawiig masajajtsüw macueatiw üetiw cuajantanej najmel teombas dioses, aton nde majlüyiw maquiüjpüw pálwüx naxey pálwüx najtaj, aton nde matsambüw mionij nimal napatsüch onic andeow, nde matsambüw quiej. ");
INSERT INTO huvNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Cos tiül ngünantanej cambaj ajlüy jane mequiaach wüx aaga poch tüünd Moisés. Nde tanomb ajlüyay ateoraw aag ayaj tiül meáwan sinagogas wüx nüt axoodaran ―aw. ");
INSERT INTO huvNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Condom ajcüwa apóstoles at montangtang at meáwan monyar andeac Teat Dios, wüx ndot manguiayiw aag ayaj, najneájan majawüw. Condom quiaj tarriüjtüw acas monxey tiül nejiw müjchiw mamb andüy Antioquía maquiüjpüw a Pablo y Bernabé. Quiaj tayacüw a Judas nasoic Barsabás, alinop Silas. Ajcüwa monxey quiaj, natang nejiw tiül minipilan Teat Jesús. ");
INSERT INTO huvNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Quiaj tarangüw noic nawiig majoyiw mamb ajcüwa monxey quiaj. Tiül aaga nawiig quiaj apiüng: “Xicona micojon michijquian, xicona apóstoles y montangtang tiül monyar andeac Teat Jesucristo, satepeayiün icon leaw ngome judíos moncül tiül Antioquía, tiül Siria, at tiül Cilicia. Tambtámban ijlüyiün. ");
INSERT INTO huvNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Xicona lananguiayiün nguineay acas monxey monáwan tiül xicona tambüw masajüw icon merangan leaw ngo metam merangan. Cos sanguiayiün tasajüw icon netam mejlüyiün circuncidado, y aton merangan meáwan atnej apiüng tiül aaga poch tüünd Moisés. Ajcüwa monxey quiaj, xicona ngome sasajan mambüw. ");
INSERT INTO huvNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Wüx canchiütason tandeacasan nóiquian, quiaj tapiüngasan najneaj narriüjtan acas monxey nüjchiün mambüw niüng ijlüyiün maquiüjpüw teat Bernabé y teat Pablo. ");
INSERT INTO huvNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Nejiw xeyay lamamongochiw cos aag andeacüw wüx Miteatiiüts Jesucristo. ");
INSERT INTO huvNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Aag nganüy süjchiün mambüw a Judas y Silas mambüw maquiüjpüw. Nejiw aton apmasajüw icon wüx meáwan aag ayaj. ");
INSERT INTO huvNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Cos Nangaj Espíritu ocueaj Teat Dios, átan xicona aton, najneaj najawan sitiül ngo nüjchiün icon merangan leaw naél. Áagan acas poch cam mbich netam merangan: ");
INSERT INTO huvNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Nde meatiün alngün nüeteran leawa landoj ajmel teombas dioses marang nichech. Nde metsamban quiej, nde metsamban mionij nimal napatsüch onic andeow, aton nde mejlüyiün mequiüjpan pálwüx naxey pálwüx najtaj. Sitiül apmecueatiün meáwan aag ayaj, najneajay irangan. Áagan sasajan icon, tamtámban ajlüyiiüts”, aw. ");
INSERT INTO huvNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Condom quiaj tambüw, ajcüwa nüjndiw mambüw quiaj andüyiw Antioquía. Wüx tapeayiw quiaj, tapajüw canchiümoj meáwan monyar andeac Teat Cristo müjchiw a nawiig. ");
INSERT INTO huvNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Meáwan monyar andeac Teat Cristo wüx ndot manguiayiw ateoraw aaga nawiig quiaj, xeyay tapac omeajtsüw manguiayiw nguineay tasoiquiw tiül a nawiig. ");
INSERT INTO huvNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Condom Judas maquiiüb a Silas aton, cos nejiw mondeac andeac Teat Dios nejiw áag tendeacüw masajüw monyar andeac Teat Cristo, tüjchiw mapac omeajtsüw xeyay, tasajüw nde mimboloj. ");
INSERT INTO huvNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Condom wüx lamacüliw quiaj acas nüt, quiaj tandilileaw alinomb andüyiw niüng ajngotoj, tayacüchiw teowix Teat Dios mambeol nejiw. ");
INSERT INTO huvNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Naleaing Silas tapiüng apmacül quiaj, ngo majtsor. ");
INSERT INTO huvNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pablo y Bernabé aton tacülíwan tiül Antioquía. Tanaámb aquiajchiw aaga poch wüx Teat Cristo. At tambeolüw nejiw xeyay monaw quiaj, cos taquiajchiw aton. ");
INSERT INTO huvNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Wüx lamacüliw quiaj acas nüt, quiaj a Pablo tasaj a Bernabé: ―Tabar andililear majawar monyar andeac Teat Jesús tiül meáwan cambaj niüng lamasajarüw wüx Mipoch Teat Dios, majawar cuane tarangüw ―aj. ");
INSERT INTO huvNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Quiaj a Bernabé tapiüng maquiüjpüw mamb alinomb a Juan, nasoic Marcos. ");
INSERT INTO huvNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Naleaing Pablo ngo majneaj majaw maquiüjpüw mamb alinomb, cos landoj macueat nejiw tiül Panfilia nomb, ngo mamb maquiiüb nejiw wüx aaga najiüt tarangüw. ");
INSERT INTO huvNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Ndoj ajcan ngo meyarayej andeacüw, quiaj tecueatayej. Bernabé taquiiüb a Marcos, tandüyiw Chipre ambüw tiül müx. ");
INSERT INTO huvNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Condom Pablo tasaj a Silas maquiiüb mamb. Wüx tatüch a nüt mambüw, ajcüwa monyar andeac Teat Cristo tayacüw nejiw teowix Teat Dios mambeol nejiw. Ndoj quiaj tambüw. ");
INSERT INTO huvNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Condom nejiw tambüw tamongoj tiül Siria at tiül Cilicia, tasajüw monyar andeac Teat Cristo monlüy quiaj, nde macueatiw ayambüw Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Condom tambüw tandüyiw Derbe, naw quiaj tandüyiw Listra. Quiaj taxomüw nop neyar andeac Teat Jesús nenüt Timoteo, micual nop najtaj judía nendüüb Teat Jesús, pero miteat nej a Timoteo griego nej. ");
INSERT INTO huvNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Meáwan minipilan Teat Jesús monaw Listra at monaw Iconio apiüngüw aaga Timoteo quiaj xeyay najneaj arang. ");
INSERT INTO huvNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Quiaj a Pablo tandiüm maquiiüb mamb a Timoteo mambeol nej. Ndoj taquiiüb mataag circuncidar ngana müjchiw majcüyiw ajcüwa judíos monlüy tiül aaga iüt niüng apmambüw, cos meáwan ajawüw aaga Timoteo quiaj, griego miteat nej. ");
INSERT INTO huvNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Condom meáwan cambaj niüng tamongoj, tüjchiw hermanos majawüw aaga nawiig leaw tarangüw apóstoles y montangtang minipilan Teat Jesús monlüy tiül Jerusalén. ");
INSERT INTO huvNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Atquiaj meáwan noic noic ajlüy minipilan Teat Cristo leaw niüng tamongoj tüjndiw mapac omeajtsüw, y nütnǘtan tenguial axeyayiw aton. ");
INSERT INTO huvNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Condom tambüw tamongoj tiültiül cambaj tiül Frigia at tiültiül cambaj tiül Galacia. Tatüchiw tiül Asia, pero tamongójan, ngo mandeacüw quiaj aaga najneajay poch quiaj; cos Nangaj Espíritu ocueaj Teat Dios ngo müüch nejiw mandeacüw. ");
INSERT INTO huvNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Wüx tapeayiw tiül niüng angochay iüt ocueajiw monaw Misia, tapiüngüw apmambüw andüyiw Bitinia, pero naleaing aaga Nangaj Espíritu ngo müüch nejiw mambüw quiaj. ");
INSERT INTO huvNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Quiaj tamongójan ambüw tiül Misia, tandüyiw cambaj Troas mbeay ndec. ");
INSERT INTO huvNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Noic ongwiiüts, Pablo aleaic tajaw atnej aǘm, tajaw nop naxey naw Macedonia alembem niüng ajlüy nej. Aaga naxey quiaj, teamatün nej ocueaj, tasaj: “Imong indüy Macedonia membeol xicon”, aj nej. ");
INSERT INTO huvNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Wüx landoj majaw aag ayaj a Pablo, quiaj najénan tambasan sandüyiün Macedonia, cos sajawan naleaing Teat Dios nepaj xicon namban nasajanüw wüx aaga najneajay poch wüx Teat Jesucristo. ");
INSERT INTO huvNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Condom tawasan Troas samban tiül nadam müx, saleainguíünan sandüyiün wüx noic iüt tiül ndec nenüt Samotracia. Amb alinoic nüt, quiaj tambasan sandüyiün tiül cambaj Neápolis. ");
INSERT INTO huvNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Condom nawasan quiaj, tandüyasan Filipos. Tiül aaga cambaj quiaj acüliw xeyay nipilan Romanos; aton aag ayaj más xeyay nembeat cambaj tiül Macedonia. Tacülasan quiaj acas nüt. ");
INSERT INTO huvNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Wüx noic nüt axoodaran tawasan tiül cambaj, tambasan sandüyiün mbeay lam niüng mbójan ambüw matajcüw orar. Quiaj chetetason. Condom tasajasanüw wüx Mipoch Teat Dios meáwan montaj leaw lapeayiw quiaj. ");
INSERT INTO huvNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Alquiaj nop najtaj nenüt Lidia, naw tiül cambaj Tiatira, nenüüb najneaj nacants jael. Aaga jael quiaj xeyay nembeat. Nej xeyay ayamb Teat Dios, teamanguiay meáwan cuane teanderac. Cos Teat Dios tambeol nej mayac wüx omeaats manguiay y mayar leaw teamandeac a Pablo. ");
INSERT INTO huvNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Wüx landoj ayar yow maquiiüb micual nej, quiaj tasaj xicon namban aniüng nej naxojtan quiaj, tapiüng: ―Sitiül icona ipiüngan naleaing xique sayar andeac Teat Dios, nganüy tabaats saniüng mexojtan ―aj xicon. Tatün xicon namban, quiaj tambasan. ");
INSERT INTO huvNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Condom alinoic nüt wüx tambasan sandüyiün niüng atajcüch orar, tangochasan nop nüx nesüet, cos alwüx ombas nej nimeech. Aaga nüx quiaj almajiür moneay nej, axomüw wüx ombas nej xeyay tomiün wüx aaga asüet quiaj. ");
INSERT INTO huvNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Aaga nüx quiaj tapots mandüüb xicon, teandeac napac manguiay nipilan, apiüng: ―Ajcüwa monxey quiaj, monrang minajiüt Teat Dios najlüy tiül cielo. Nejiw teamasajüw icon nguineay alndom maw isoetiün ―aw. ");
INSERT INTO huvNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Palüy atquiaj tarang xeyay nüt. Ndoj Teat Pablo lapaxiow manguiay, quiaj ndiliteay majaw. Condom tasaj aaga nimeech najlüy wüx ombas a nüx: ―Sasaj ic menguiay wüx minüt Teat Jesucristo, iriow wüx ombas aaga nüx quiaj ―aj. Quiaj taw aaga nimeech, tacueat nej najénan. ");
INSERT INTO huvNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Ajcüwa moneay nej, wüx tajawüw langome apmaxomüw tomiün wüx ombas aaga nüx quiaj, quiaj tasapüw a Pablo maquiiüb a Silas. Condom taquiüjpüw mamb andüy awan niüng ajlüyiw monajiüt. ");
INSERT INTO huvNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Wüx tapeayiw niüng ajlüy monajiüt, quiaj tapiüngüw: ―Ajcüwa monxey cam judíos nejiw, nganüy xeyay moncüy teamayacüw tiül micambajaats. ");
INSERT INTO huvNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Nejiw tenguial maquiajchiw nipilan wüx midiosüw nejiw leaw icootsa ngondom mayariiüts marangaats, cos icootsa romanos icoots ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Quiaj a cambaj tajcüyiw majawüw a Pablo y Silas wüx tanguiayiw aag ayaj. Condom monajiüt tapiüngüw masojndich tiül apixaw; ndoj tapots awüjchiw. ");
INSERT INTO huvNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Wüx landoj mawüjchiw xeyay, quiaj tayacüw tiül manchiüc. Condom tasajüw aaga nejiür manchiüc majiür nejiw majneaj. ");
INSERT INTO huvNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Aaga naxey quiaj, wüx ndoj manguiay nguineay netam marang, quiaj tayac nejiw tiül manchiüc, tiül ümb wüx palaw teomeaats iüm. Condom tapünaran oleajiw nejiw tiül xiül. ");
INSERT INTO huvNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Lapeay pinawan ongwiiüts, Pablo y Silas tenguial atajcüw orar matüniw ocueaj Teat Dios, y tenguial atajcüw cantar himnos müjchiw Teat Dios. Meáwan leaw aliw tiül manchiüc tenguial manguiayiw. ");
INSERT INTO huvNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Condom, quiaj tajlang noic nadam ateam, nómban alangüüch oleaj a manchiüc. Quiaj lejquiat meáwan apal ombeay manchiüc. Aton sojndiüt meáwan galen netsajcüy monlüy tiül manchiüc. ");
INSERT INTO huvNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Camüm mapac a nejiür manchiüc majaw laímb lejquiam meáwan apal manchiüc, quiaj tasoond micochil nej membiyay nejáyan quiaj. Cos apiüng a nej laǘmb mecuiürrüw meáwan monlüy tiül manchiüc. ");
INSERT INTO huvNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Quiaj a Pablo tendeac napac, tapiüng: ―Nde mermbiyay, jogüy meáwan xicon saliün ningüy ―aw. ");
INSERT INTO huvNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Quiaj tatün ran aaga naxey quiaj. Condom tajmel tiül manchiüc acuiür ancambeapmbeapeay. Quiaj taquieel micos nej teombasüw a Pablo y Silas. ");
INSERT INTO huvNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Condom quiaj tawün nejiw, tatün manguiay nejiw: ―Teat monxey ¿cuane netam narang para naw wüx sasoete? ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Nejiw quiaj tasajüw nej: ―Iyar andeac Miteatiiüts Jesucristo, quiaj apmeriow wüx isoet, at meáwan leaw monlüy iniüng ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Condom tasajüw nej wüx Mipoch Teat Dios, at meáwan monlüy aniüng nej. ");
INSERT INTO huvNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Tíülan aaga ongwiiüts quiaj, aaga naxey quiaj tajants minecoy ombasüw nejiw. Ndoj tayar yow maquiiüb meáwan monlüy aniüng nej. ");
INSERT INTO huvNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Condom tamelich nejiw tiül iüm, tayac nüeteran metiw. Xeyay tapac omeaats aaga naxey quiaj maquiiüb meáwan monlüy aniüng nej, cos lamayariw Mipoch Teat Dios. ");
INSERT INTO huvNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Ajcüwa monajiüt wüx larraw tiüt, quiaj tüjchiw mamb mongot masajüw a nejiür manchiüc matsambiich a Pablo y Silas. ");
INSERT INTO huvNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Quiaj aaga nejiür manchiüc tasaj a Pablo: ―Monajiüt lamüjchiw miün nasoic natsambiich icon. Nganüy alndom meriowan, quiüran ngo majlüy nicuajind naél ―aj. ");
INSERT INTO huvNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Quiaj a Pablo tasaj a mongot: ―Xicona nipilan romano xicon, nejiw tawüjchiw xicon majawüw meáwan nipilan. Taton ngome tajawüw wüx sasoetiün, ndoj tayacüw xicon tiül manchiüc. ¿Neol nganüy tapiüngüw mawüniw xicon axotayéjan? ¡Ngwüy ngo mat! Ich miünüw nejeyej mawüniw xicon ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Quiaj tambüw a mongot müjchiw manguiay monajiüt aaga poch quiaj. Ajcüwa monajiüt xeyay mbayatoj wüx tanguiayiw aaga Pablo y Silas romanos nejiw. ");
INSERT INTO huvNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Quiaj tambüw matüniw monajneaj teombasüw a Pablo y Silas; tawüniw tiül manchiüc, pero tatüniw ocueajiw mawüw tiül aaga cambaj quiaj. ");
INSERT INTO huvNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Wüx tawüw tiül manchiüc, tandüyiw aniüng Lidia. Condom wüx landoj andeacüw maquiüjpüw minipilan Teat Cristo monlüy quiaj, masajüw tanaámb mapac omeajtsüw mayambüw Teat Dios, quiaj tambüw. ");
INSERT INTO huvNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pablo maquiiüb a Silas wüx tambüw, tamongoj ambüw tiül cambaj Anfípolis, ambüw tiül cambaj Apolonia, ndoj tatüchiw Tesalónica. Alquiaj nop sinagoga ocueaj nipilan judío. ");
INSERT INTO huvNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pablo tamb tiül aaga sinagoga atnej mbójan marang nguiajantanej niüng amb. Nej tamb tiül aaga nangaj iüm miarojmbüw nüt axoodaran, tandeac maquiüjpüw nipilan. ");
INSERT INTO huvNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Tasaj nejiw majawüw leaw apiüng tiül Mipoch Teat Dios, niüng apiüng aaga Cristo netam mamongoch xeyay ngo majneaj, netam mandeow. Condom netam mapac alinomb. Aton tasaj nejiw: ―Aaga Teat Jesús teanasaj icon wüx quiaj, aag ayaj a Cristo temecüliün ―aj nejiw. ");
INSERT INTO huvNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Altiül nejiw tayariw, tüjchiw omeajtsüw Teat Dios; condom taquiüjpüw a Pablo y Silas. Aton xeyay nipilan griego monyamb Teat Dios tayariw mipoch Teat Jesús aton, at xeyay montangtang ombas montaj monaw quiaj. ");
INSERT INTO huvNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Pero ajcüwa judíos leaw ngo mayariw andeac Teat Jesús, xeyay ngo majneaj majawüw aag ayaj. Quiaj tayambüw acas monjüyjüy nipilan leaw ngo majiür cuane marang, mambeolüw nejiw. Condom tambüw masajüw nipilan tiül a cambaj, mawitichaw noic nadam moncüy. Condom tajmeliw aniüng Jasón mayambüw a Pablo y Silas mawüniw mayacüw teowix cambaj. ");
INSERT INTO huvNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Pero ngo maxomüw a Pablo y Silas, quiaj tasapüw a Jasón, at alacas monyar andeac Teat Jesús, tanototoj mamb andüy teombasüw monajiüt tiül aaga cambaj quiaj. Wüx tapeayiw quiaj, tepajüw napac, tapiüngüw: ―Ajcüwa monxey tenguial awitichaw moncüy tiül meáwan cambaj, nganüy lamatüchiw ningüy tiül micambajaats. ");
INSERT INTO huvNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Aaga Jasón cam lamayac aniüng nej ajcüwa monxey quiaj. Ajcüwa nipilan quiaj, arangüw leaw ngo mandiüm a César minatang nenajiüt ocueajiiüts. Cos apiüngüw almajlüy alinop natang nenajiüt, aag ayaj aaga Jesús ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Xeyay nipilan at monajiüt wüx tanguiayiw aag ayaj, quiaj tajcüyiw xeyay. ");
INSERT INTO huvNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Quiaj a Jasón at alacas monyar andeac Teat Dios leaw almaquiiüb, wüx landoj mayacüw mipochiw nejiw mapiüngüw Pablo apmaw quiaj, langome apmüüch majcüy nipilan, quiaj tsajmbiütoj. ");
INSERT INTO huvNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Condom meáwan monyar andeac Teat Cristo najénan tüjchiw mamb a Pablo maquiiüb a Silas andüyiw tiül cambaj Berea ores ongwiiüts. Nejiw wüx tapeayiw Berea, tambüw tiül a sinagoga ocueajiw nipilan judío. ");
INSERT INTO huvNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Ajcüwa judíos monlüy quiaj, alwüx ajneaj omeajtsüw ngo mat nejiw monlüy Tesalónica, cos ayacüw wüx omeajtsüw manguiayiw Mipoch Teat Dios. Meáwan nüt tateowüw Mipoch Teat Dios majawüw sitiül naleaing leaw apiüngüw a Pablo y a Silas. ");
INSERT INTO huvNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Atquiaj xeyayiw tayariw Mipoch Teat Dios, at xeyay nipilan griego tayariw Mipoch Teat Dios aton; átan natangtang ombas montaj tiül cambaj, átan monxey. ");
INSERT INTO huvNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Wüx ajcüwa judíos monlüy Tesalónica, tanguiayiw nguineay a Pablo lamayac Mipoch Teat Dios tiül Berea aton, quiaj tambüw matüchiw quiaj. Condom tapots maquiajchiw ombeay nipilan majcüyiw majawüw a Pablo. ");
INSERT INTO huvNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Quiaj ajcüwa monyar andeac Teat Jesús najénan tüjchiw mamb a Pablo andüy mbeay ndec. Nganüy a Silas maquiiüb a Timoteo tacülíwan Berea. ");
INSERT INTO huvNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Ajcüwa monquiiüb mamb Pablo, taquiüjpüw mamb andüy tiül cambaj Atenas. Condom wüx tandilileaw, tasaj nejiw a Pablo masajüw a Silas y Timoteo, mambüw najénan majawüw nej quiaj. ");
INSERT INTO huvNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Pablo altiül cambaj Atenas tealeámban macül a Silas y Timoteo, pero almajaw xeyay narangüch dios ajlüy tiül aaga cambaj quiaj, xeyay ngo majneaj mayaag. ");
INSERT INTO huvNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Nej tamb tiül a sinagoga, tandeac masaj nipilan judío at pálwüx nipilan monyamb Teat Dios monlüy quiaj. At meáwan nüt tamb mbeay plas aton mandeac Mipoch Teat Dios manguiayiw nipilan leaw axom quiaj. ");
INSERT INTO huvNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Tapeayiw quiaj acas monxey mondüy wüx minawijquiaw nasoic epicúreos at ajcüwa nasoic estoicos. Ajcüw ayaj tapots andeacüw maquiüjpüw a Pablo, altiül tapiüngüw: ―¿Cuane andiüm mapiüng aaga naxey ngo majaw ndijchiow ombeay quiaja? ―awüw. Altiül tapiüngüw: ―Ajüic atnej teamandeac wüx pálwüx dioses ―awüw. Atquiaj tapiüngüw, cos Pablo tandeac wüx Teat Jesús, aton tandeac nguineay tapac alinomb. ");
INSERT INTO huvNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Condom quiaj taquiüjpüw nej andüy tiül nop nadam iüm nasoic Areópago. Wüx tapeayiw quiaj, tasajüw nej: ―¿Alndom nanguiayiüna cuane aaga jayats iquiaach quiaja? ");
INSERT INTO huvNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Cos ique sanguiayiün temendeac xeyay cuajantanej ngome aag nanguiayiün. Nganüy sandiüman nanguiayiün cuane amb apiüng aag ayaj ―awüw. ");
INSERT INTO huvNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Cos meáwan nipilan micual iüt tiül Atenas at monaw alinoic iüt moncǘlan quiaj, ngo majlüy alinoic cuajantanej marangüw, sitiül ngo mandeacüw tengwüy manguiayiw alngün jayats manderac wüx. ");
INSERT INTO huvNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Quiaj lembet pinawan nejiw a Pablo tiül Areópago. Condom tapiüng: ―Teat monxey micual iüt Atenas, sajaw icona irangan casa xeyay palpálwüx dioses. ");
INSERT INTO huvNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Cos wüx tajüyiüs ningüy tiül micambajan, tajawas xeyay artül niüng irangan casa midiosan. Ndoj tamongos niüng ajlüy noic artül narangüch wüx poch apiüng: “Ocueaj aaga dios ngo majaraw jane nej”. Pues aaga dios quiaj, leawa icona ngo mejawan jane masey irangan nej casa, aag Dios quiaj xique nganüy xiün nasaj icon wüx. ");
INSERT INTO huvNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","’Aag ayaj Teat Dios nerang iüt, nerang meáwan cuajantanej najlüy ningüy wüx iüt, cos nej natang tiül cielo at wüx iüt. Nej ngo macül tiül cuajantanej nangaj iüm narangüch naag owixaran. ");
INSERT INTO huvNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Nej ngo metam nej nicuajind, ngondom aljane mambeol nej müüch nej aleaic, cos nej üüch icoots miiündaats, y teamepacüüch majlüy meáwan leaw almajlüy. ");
INSERT INTO huvNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","’Nej nerang meáwan nipilan ajan wüx nop. Condom naw wüx aaga nop quiaj tajlüy palpálwüx nipilan macüliw wüx aaga iüt cam, pero noic miquiejiw. Nej lamajaw ngow apmajlüyiw anopnopoj, aton lamüüch iüt niüng apmacüliw. ");
INSERT INTO huvNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Nej andiüm mayambüw nej, müjchiw nej omeajtsüw. Nej ngome miünquiaj almajlüy, álan niüng ajlüyiiüts anopnopoots. ");
INSERT INTO huvNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Cos nej neech icoots mapacaats, nej nerang icoots. Sitiül nej ngo marang icoots, ngo majlüyiiüts. Atnej lamarangüw wüx nawiig aton altiül monáwan tiül icona leaw monxom omeaats, apiüngüw: “Icootsa micual icoots Dios.” ");
INSERT INTO huvNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Sitiül naleaing micual icoots Dios, ngondom mapiüngaats Teat Dios ajlüy atnej alngün cuajantanej narangüch oro, tengwüy plat, tengwüy piedra. Meáwan ajcüw ayaj nipilan tarangüw, cos nejiw ayajcüw atquiaj ajlüy Dios. ");
INSERT INTO huvNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Aag ayaj arangrangǘwan, cos ngo majawüw nguineay ajlüy Teat Dios. Pares Teat Dios ngome apmateow tiül leaw ngo majneaj tarangüw; pero nganüy nej apiüng netam manguiayiw wüx nej meáwan nipilan wüx iüt y macueatiw meáwan ngo majneaj arangüw. ");
INSERT INTO huvNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Cos Teat Dios lamayac noic nüt apmajaraw wüx asoet meáwan nipilan wüx iüt. Aag ayaj apmajlüy cos nej lamayac nop Teat Naxey majaw wüx asoeteran. Aag ayaj tajüiquich majaraw wüx tapacüüch nej alinomb maw tiül mondeow ―aw a Pablo. ");
INSERT INTO huvNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Ajcüwa nipilan wüx tanguiayiw aaga poch apacaran alinomb, altiül titsojówan nej, altiül tasajüw: ―Alinoic nüt ndoj sananguiayiün indeac ―ajüw nej. ");
INSERT INTO huvNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Condom quiaj tacueat nejiw, taw quiaj a Pablo. ");
INSERT INTO huvNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Pero altiül tandüjpiw mamb a Pablo, tüjchiw omeajtsüw Teat Dios. Tiül ajcüw ayaj, altiül nop naxey nenüt Dionisio. Aaga naxey quiaj, ajiür najiüt tiül Areópago. At altiül nop najtaj nenüt Dámaris. Ngome áagan, aton tajlüyiw alacas. ");
INSERT INTO huvNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Ndoj aag ayaj, quiaj taw tiül Atenas a Pablo, tamb andüy tiül cambaj Corinto. ");
INSERT INTO huvNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Wüx tapeay Corinto, q