﻿USE sofia;
DROP TABLE IF EXISTS sofia.huuNT_vpl;
CREATE TABLE huuNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES huuNT_vpl WRITE;
INSERT INTO huuNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jesucristo rafuena omoɨmo cue lloiacana jira, naimɨe comɨnɨna nano lloitɨcue. Jesucristo usumatɨaɨ mɨcorɨaɨ mamecɨaɨna omoɨmo lloitɨcue. Naimɨe usumadɨ David mɨcorɨ. Jɨaɨe usuma Abraham mɨcorɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham mɨcorɨ jitodɨ Isaac mɨcorɨ. Isaac mɨcorɨ jitodɨ Jacob mɨcorɨ. Jacob mɨcorɨ jitodɨ Judá mɨcorɨ. Judá mɨcorɨ amatɨaɨ mɨcorɨaɨ moo jɨaɨ Jacob mɨcorɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá mɨcorɨ jitodɨ Fares mɨcorɨ. Jɨaɨe jitodɨ Zara mɨcorɨ. Iaɨmaiaɨ mɨcorɨ eidɨ Tamar mɨcorɨ. Fares mɨcorɨ jitodɨ Esrom mɨcorɨ. Esrom mɨcorɨ jitodɨ Aram mɨcorɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram mɨcorɨ jitodɨ Aminadab mɨcorɨ. Aminadab mɨcorɨ jitodɨ Naasón mɨcorɨ. Naasón mɨcorɨ jitodɨ Salmón. ");
INSERT INTO huuNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón mɨcorɨ jitodɨ Booz mɨcorɨ. Booz mɨcorɨ eidɨ Rahab mɨcorɨ. Booz mɨcorɨ jitodɨ Obed mɨcorɨ. Obed mɨcorɨ eidɨ Rut mɨcorɨ. Obed mɨcorɨ jitodɨ Isaí mɨcorɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí mɨcorɨ caɨ illaɨma David mɨcorɨ moo. David mɨcorɨ jitodɨ Salomón mɨcorɨ. Salomón mɨcorɨ eidɨ Urías mɨcorɨ aɨ. Naiñaiñona ollena, David mɨcorɨ Urías mɨcorɨna jobaimemo orede. Jobaimemo naimɨe fiodailla mei, naiñaiñona ote. ");
INSERT INTO huuNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón mɨcorɨ jitodɨ Roboam mɨcorɨ. Roboam mɨcorɨ jitodɨ Abías mɨcorɨ. Abías mɨcorɨ jitodɨ Asa mɨcorɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa mɨcorɨ jitodɨ Josafat mɨcorɨ. Josafat mɨcorɨ jitodɨ Joram mɨcorɨ. Joram mɨcorɨ jitodɨ Uzías mɨcorɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzías mɨcorɨ jitodɨ Jotam. Jotam mɨcorɨ jitodɨ Acaz. Acaz mɨcorɨ jitodɨ Ezequías mɨcorɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequías mɨcorɨ jitodɨ Manasés. Manasés mɨcorɨ jitodɨ Amón. Amón mɨcorɨ jitodɨ Josías. ");
INSERT INTO huuNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josías mɨcorɨ jitodɨ Jeconías mɨcorɨ. Jeconías mɨcorɨ amatɨaɨ mɨcorɨaɨ jɨaɨ itɨmacɨ. Naie facaiseconi Babilonia railla naɨraɨ dɨne naie naɨraɨ soldaduaɨ caɨ comɨnɨna uitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Naie meinomo Jeconías mɨcorɨ Salatiel mɨcorɨna comuitate. Salatiel mɨcorɨ jitodɨ Zorobabel mɨcorɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel mɨcorɨ jitodɨ Abiud mɨcorɨ. Abiud mɨcorɨ jitodɨ Eliaquim mɨcorɨ. Eliaquim mɨcorɨ jitodɨ Azor mɨcorɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor mɨcorɨ jitodɨ Sadoc mɨcorɨ. Sadoc mɨcorɨ jitodɨ Aquim mɨcorɨ. Aquim mɨcorɨ jitodɨ Eliud mɨcorɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud mɨcorɨ jitodɨ Eleazar mɨcorɨ. Eleazar mɨcorɨ jitodɨ Matán. Matán mɨcorɨ jitodɨ Jacob mɨcorɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob mɨcorɨ jitodɨ José mɨcorɨ. José mɨcorɨdɨ María ɨni. Naiñaiñodɨ Jesús ei. Naimɨe mamecɨ jɨaɨcɨdɨ Cristo. ");
INSERT INTO huuNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Abraham mɨcorɨ illa facaisemona David mɨcorɨ jeicɨa facaisemo Jesús ie catorce nanoramacɨ mamecɨ jai ite. David mɨcorɨ facaisemona Babiloniamo ite naɨraɨ anamo caɨ jaiagaɨ illa facaisemo catorce nanoramacɨ mamecɨ jɨaɨ ite. Babiloniamo ite naɨraɨ anamo caɨ jaiagaɨ illa facaisemona Jesús jeicɨa facaisemo catorce nanoramacɨ mamecɨ jɨaɨ ite. ");
INSERT INTO huuNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jesucristo comuilla rafuena lloitɨcue. Jesús eidɨ María. Naiñaiñona jɨcanotɨmɨedɨ José mɨcorɨ. Naimɨe mɨcorɨ dɨga naiñaiño nia iñenia, Jesiñamui Joreño ie uaido naiñaiñona uruesitate. ");
INSERT INTO huuNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","José mɨcorɨ maremɨe. María jai uruesillana naimɨe mɨcorɨ fɨdɨanona, naiñaiñona meidaitañellena jira, naiñaiñona bainino dotaacade. Jɨaɨmɨe dɨga illamona urueside raillanona comecɨna facajanona, naiñaiñona dotaacade. ");
INSERT INTO huuNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Naimɨe mɨcorɨ comecɨna iemo facaia, naimɨe mɨcorɨ nɨcaɨrillanona, naimɨe mɨcorɨmo Jusiñamui jaɨenicɨ bairiano raite: —José, David mɨcorɨ jito, Maríana jacɨruiñeno ono, o aɨna illena. Jusiñamui Joreño naiñaiñona jai uruesitate. ");
INSERT INTO huuNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ɨimana jocoite. Ie comɨnɨ naimacɨ jeacɨnomona naimɨe jilloitajaɨbilla jira, Jesúna o jɨtalle naimɨe mamecɨdɨ —raite. ");
INSERT INTO huuNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Bie rafue suide, Jusiñamuidɨ ie lloraɨma mɨcorɨ jaie llotataga uaina suillena. ");
INSERT INTO huuNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Jaie llotatate: Ɨimana uiñoñedɨñaiñomo comuite uruedɨ. Ɨimana jocoite. Emanuel ie mamecɨ jɨtalle. Bie mamecɨ oni dobaiñuamona raite: “Jusiñamui caɨ dɨga ite”. ");
INSERT INTO huuNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","José mɨcorɨ casidemo, Jusiñamui jaɨenicɨ lloga uaina fɨnode. Maríana ote, ie aɨna illena; ");
INSERT INTO huuNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","iadedɨ nai jitona naiñaiño nia jocoñenia, naiñaiño dɨga naimɨe mɨcorɨ nia ɨnɨñede. Naiñaiño jito jeicɨa mei, José mɨcorɨ jɨtade naimɨe mamecɨna Jesúna. ");
INSERT INTO huuNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Judea railla enɨruemo Jesús jeicɨga. Naimɨe jeicɨanodɨ Belén. Naie facaiseconi ite illaɨmadɨ Herodes mɨcorɨ. Monamo ite ramo comecɨaɨna facauidɨno naie facaiseconi Jerusalémo jitoma billafo dɨnena bitɨmacɨ. Jerusalémo itɨnomo jɨcanotɨmacɨ: ");
INSERT INTO huuNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","—¿Nɨnomo como jeicɨga omoɨ judíuaɨ illaɨmadɨ? Jitoma bisoillafomo como bairede ucuduna cɨodɨcaɨ. Naiemona naimɨe jeicɨana jai uiñotɨcaɨ. Naimɨemo iobillacɨnona fecallena bitɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Herodes mɨcorɨdɨ naicɨnona cacajanona, ie comecɨ jarire ite. Jɨaɨmɨe naimɨe meifomo illana jitaiñede. Jerusalémo itɨnodɨ jɨaɨ jarire itɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ie facaise Herodes mɨcorɨ judíuaɨ illaɨcomɨnɨna uaiduanona, naimacɨmo Cristo raillamɨe jeicɨana jɨcanote. ");
INSERT INTO huuNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Uai otɨmacɨ: —Judea railla enɨruemo. Belémo. Iena Jusiñamui facaina mɨcorɨdɨ jaie cuega: ");
INSERT INTO huuNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Judea enɨruemo Belén naɨraɨ ite; ia naie naɨraɨ eo janorede. Naie naɨraɨmona damɨe jeicɨamona, omoɨ illaɨmana jaite. Naimɨedɨ cue Israel railla comɨnɨna sedaite. Iemona Belén naɨraɨ Judea illaɨcomɨnɨ baɨfemo faɨte cuega. ");
INSERT INTO huuNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Iena cacaja mei, Herodes mɨcorɨdɨ monamo ite ramo comecɨaɨ facauidɨno bainino uaidote. Naie ucudu bairia facaise raise uiñollena jɨcanote. ");
INSERT INTO huuNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Naimacɨna Belémo orede. Llote: —Naie uruena raise jeno. Naimɨena omoɨ cɨua mei, cuemo lluaɨbi, naimɨe dɨne cue jaillesa. Naimɨemo iobillacɨnona jɨaɨ fecaacadɨcue —llote. —Jɨɨ —faɨriotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Iena naimɨe mɨcorɨ llua mei, jaidɨmacɨ. Ucuduna naimacɨ dane cɨuamona, eo iobidɨmacɨ. Naimacɨ cɨua ucududɨ naimacɨna ɨfuanona, monamo naie urue afemo ride. ");
INSERT INTO huuNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Fo jaillano uruena, ie ei María dɨga, cɨodɨmacɨ. Naimɨemo iobillacɨnona fecallena, caiñɨcɨ ɨfodo ana raɨnadatɨmacɨ. Naimacɨ bolsas sebiñuanona, naimɨemo rana jamai fecadɨmacɨ. Oro fecadɨmacɨ. Caɨmare sorirede rana jɨaɨ fecadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Naimacɨ ɨnɨa anamo naimacɨ nɨcaɨrillanona, Jusiñamui llote: —Herodes dɨne abɨdo jaiñeno —llote. Ie jira Jerusalémo jaiñeno abɨdo naimacɨ enɨruemo jaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Naimacɨ jailla mei, José mɨcorɨ ɨnɨa anamo nɨcaɨrite. Nɨcaɨrillanona, Jusiñamui jaɨenicɨdɨ naimɨemo bairiano raite: —Egiptomo nai o urue dɨga, ie ei dɨga, mai jai. Omo cue llua dɨnori nainomo i. O abɨdo billɨrui lloitɨcue. Herodedɨ nai uruena jenoite, naimɨena meinellena —raite. ");
INSERT INTO huuNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","José mɨcorɨ raɨre casillano, nai urue dɨga, Jesús ei dɨga, Egiptomo naɨona jaide. ");
INSERT INTO huuNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Herodes mɨcorɨ fiodaille dɨnori nainomo ite. Ie muidona Jusiñamui ie facaina lloraɨma mɨcorɨ llotataga uai jai suide. Jaie lloga: “Egiptomona cue Jitona jai uaidotɨcue”. ");
INSERT INTO huuNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Egiptomo Jesús jaillana Herodes mɨcorɨ fɨdɨñede. Monamo ite ramo comecɨaɨna facauidɨno naimacɨ enɨruemo abɨdo jaillana naimɨe mɨcorɨ jɨaɨ fɨdɨñede. Naimɨe mɨcorɨ dɨne naimacɨ abɨdo biñena jira, naimɨe mɨcorɨna naimacɨ jɨfuia jira, naimɨe mɨcorɨ eo icɨrite. Ie jira mena años itɨsaɨaɨ dɨerisedena faetate. Nana Belémo ite ɨisaɨaɨ dɨese faetate. Belén ecɨmo itɨno uruiaɨna jɨaɨ faetate. Naie ucudu mena años jaie nano bairena jira, mena años itɨsaɨaɨ dɨerisedena faetate. ");
INSERT INTO huuNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Raquel mɨcorɨ jaie eia isoi, Belén itɨno birui eedɨmacɨ. Jeremías mɨcorɨ iena jaie cuega: ");
INSERT INTO huuNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Ramá railla naɨraɨ dɨnena Raquel mɨcorɨ eo eiana cacadɨcue. Caɨ usuño Raquel mɨcorɨ eede. Naiñaiño mɨcorɨ uruiaɨ mɨcorɨaɨ facaina eede. Jɨaɨe comɨnɨmona fɨraduacɨnona jitaiñede, naiñaiño uruiaɨ mɨcorɨaɨ jai fiodailla jira. ");
INSERT INTO huuNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Dɨgarui illanona, Herodes mɨcorɨ fiodailla mei, Egiptomo José mɨcorɨ dane nɨcaɨrillanona, Jusiñamui jaɨenicɨ naimɨemo bairede. ");
INSERT INTO huuNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Llote: —O comɨnɨ enɨruemo na o urue dɨga, ie ei dɨga, abɨdo mai jai. Nai o uruena meineiacadɨmɨe jai fiodaite. ");
INSERT INTO huuNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ie jira ie enɨruemo naie urue dɨga, ie ei dɨga, abɨdo jaide. ");
INSERT INTO huuNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Herodes mɨcorɨ jitodɨ ie moo ifomo jai illana José mɨcorɨ fɨdɨano, jacɨruite. Herodes mɨcorɨ jito mamecɨdɨ Arquelao. Nainomo José jaiacaiñede. José mɨcorɨ dane nɨcaɨrillanona, Jusiñamuidɨ Galilea railla enɨruemo naimɨe jaillena naimɨemo llote. ");
INSERT INTO huuNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Nazaret railla naɨraɨ dɨne jaide, nainomo illena. Iemona Jusiñamui facaina lloraɨnɨ mɨcorɨaɨ jaie cuegafuiaɨ jai suide. Cristona jaie cuetɨmacɨ: “Naimɨedɨ Nazaret imɨe”. ");
INSERT INTO huuNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Dɨga años illanona, Juan Bautista raillamɨe mɨcorɨdɨ jofue iñenanomo illanona, comɨnɨna dafaɨfia, Jusiñamui rafuena naimacɨna llofueuide. ");
INSERT INTO huuNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Comɨnɨ naimɨe mɨcorɨ dɨne billanona, naimacɨmo llote: —Omoɨ jeacɨnona faɨnonocaida, omoɨ comecɨaɨ iuaillaɨ meido. Jusiñamui dɨbeimo omoɨ i. Naimɨe anamo omoɨ illana naimɨe jitailla jira, omoɨmo iena lloitɨcue —llote. ");
INSERT INTO huuNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Isaías mɨcorɨdɨ Jusiñamui facaina lloraɨma. Juan Bautista mɨcorɨ nia iñenia, Isaías mɨcorɨdɨ naimɨe mɨcorɨna jaie cuete: Jofue iñenanomo damɨe jɨdai-jɨdaillana cacadɨcue. Naimɨe llote: “Caɨ Nama biite. Naimɨe naɨso atona raise fɨno” llote. Iese llote; iadedɨ naimɨe uaina naimacɨ feiñollena, naimacɨ comecɨaɨ marena fɨnuana ñaɨte. ");
INSERT INTO huuNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Juan mɨcorɨdɨ camello itɨraɨaɨ ie nilla ɨniroina jɨtade. Igoɨ iena ie moilligaɨna jɨtade. Fioduaɨna rɨte. Cɨifona mete. Jamai rana guite. ");
INSERT INTO huuNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Dɨga comɨnɨ naimɨe mɨcorɨ dɨne jai jaisoidɨmacɨ. Jerusalémona, nana Judeamona, nana Jordán fuemona jai jaisoidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Jusiñamuimo naimacɨ jeacɨnona naimacɨ llua meino, naimacɨdɨ Juan mɨcorɨ bautizaga. ");
INSERT INTO huuNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Bautizallena, dɨga fariseuaɨ, dɨga saduceuaɨ, naimɨe mɨcorɨ dɨne bitɨmacɨ; iadedɨ naimacɨ billana naimɨe mɨcorɨ cɨuano llote: —Maraiñede rafuena fɨnocana omoɨ jailla jira, jaio naɨraɨ isoidomoɨ. ¿Nɨese Jusiñamui rɨicaillɨfuemona jilloitomoɨ? Cue dɨne omoɨ billena, ¿bu omoɨmo llua? ");
INSERT INTO huuNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Omoɨ comecɨaɨ iuaillaɨ meido. Omoɨ jeacɨnona faɨnonocai. Iemona Jusiñamui jitaillacɨnona fɨno. Mare rafuena fɨnocana jai. Naiemona omoɨ comecɨaɨ iuaillaɨ meiduana uiñoitɨcaɨ. Ie mei omoɨ bautizallomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Omoɨ comecɨaɨna facañeno: “¿Bue ñellena o llua isoi fɨnoitɨcaɨ? Jusiñamui Abraham mɨcorɨna jaie eo raise nabaide. Abraham mɨcorɨ caɨ moo illamona, Jusiñamui rɨicaillɨfuemona jilloitɨcaɨ”. Ero, omoɨmo lloitɨcue: Cue llua isoi omoɨ fɨnoñenia, naimɨe rɨicaillɨfuemona jilloñeitomoɨ. Abraham mɨcorɨ uruiaɨdomoɨ; iadedɨ Jusiñamui jitaillacɨnodo jaiacaiñedomoɨ. Naimɨe jitaia, naimɨe jitaillacɨnona naimacɨ fɨnollena, bene ite nofɨcɨmona naimɨedɨ Abraham mɨcorɨ facaina uruiaɨna comuitarede. ");
INSERT INTO huuNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ero, llɨsiñede riara tɨedomoɨ. Tɨia mei, maraiñena jira, iena jobaidomoɨ. Ie isoidomoɨ. Omoɨ maraiñena jira, Jusiñamui omoɨna jai duere fɨnoacade. Ie rɨicaillafue anamo jai itomoɨ. Omoɨ comecɨaɨ iuai omoɨ meidoñenia, omoɨna duere fɨnoite. ");
INSERT INTO huuNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Jusiñamui dɨbeimo omoɨ comecɨaɨ iuai omoɨ meidoia, jɨnui dɨga omoɨna bautizaitɨcue. Cue baɨfemo faɨtɨmɨe bie facaise biite. Naimɨe cue ifo meidoite. Jamai bue cue isoilla jira, naimɨena cue canuana uiñoñedɨcue. Naimɨe bia, naimɨe dɨbeimo omoɨ jaillamona, Jusiñamui Joreño omoɨmo itataite. Omoɨ comecɨaɨ iuai omoɨ meidoñenia, omoɨna duere fɨnoite. ");
INSERT INTO huuNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Trigona omoɨ betaia, mare trigona eenotomoɨ. Maraiñede ra oni dotajanona, iena jobaitomoɨ. Ie isoide. Naimɨe rafuena lluanona, comecɨaɨ iuaillaɨ meidotɨnona ie moo illanomo naimɨedɨ ofitaite; iadedɨ jɨaɨe comɨnɨna duere fɨnoite. Iraimo dotaite. Naie irai jaca duiñede —llote. ");
INSERT INTO huuNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Juan mɨcorɨ Jordán dɨne nia ia, Galileamona Jesús bite. Naimɨena bautizallena, Juan mɨcorɨ dɨne bite. ");
INSERT INTO huuNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Juan dɨnena naimɨemo llote: —Bautizallena cuemo bitɨo; ia dama ite. Cuena o bautizaia, cuemona mare. ");
INSERT INTO huuNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jesús uai ote: —Cuena mai o bautiza. Nana Jusiñamui jitailla rafue coco fɨnoia, mare. Juan: —Jee —raite. Ie facaise naimɨena bautizade. ");
INSERT INTO huuNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jesús bautizaja mei, jɨnuimona bite. Mona bojodena cɨode. Jusiñamui Joreño, ucugɨ isoi, naimɨe emodomo ana billana cɨode. ");
INSERT INTO huuNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ie facaise monamona Jusiñamui llote: —Bimɨe cue eo isiruiga Jito. Naimɨeri iobidɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Naie facaise nainomo naimɨena ramo Taɨfe faɨllena, jofue iñenanomo Jusiñamui Joreño Jesúna uite. ");
INSERT INTO huuNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Cuarenta dɨgarui Jesús guiñede. Naie facaise fuilla mei, guiñeno illamona, aimetaite. ");
INSERT INTO huuNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ie facaise Taɨfe naimɨe dɨne bite. Jesús aimetaillana naimɨe uiñuamona llote: —Jusiñamui Jitodɨodena, naimɨemo llono: “Ore Moo, cue guillesa, bie nofɨcɨ llomenicona jaita”. ");
INSERT INTO huuNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jesús uai ote: —Dama ite. O lluana fɨnoñeitɨcue. Jusiñamui facaina lloraɨma mɨcorɨ iena jaie cuega: “Jɨaɨe rafuedɨ llomenico guilla baɨfemo faɨte. Dama guillemo comecɨna facañeno; iadedɨ Jusiñamui lloga uaimo caɨ comecɨ facajamona, ie uaido caɨ jailla” cuega. ");
INSERT INTO huuNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ie mei Jerusalémo Jusiñamui jofo muidomo Taɨfe Jesúna uite. ");
INSERT INTO huuNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Raite: —Jusiñamui Jitodɨodena, enɨruemo mai ana uai. David mɨcorɨ ona jaie cuega: Ona eenollena, Jusiñamuidɨ ie jaɨenisaɨmo lloite. Enɨruemo o uaiñellena, o abɨ bofedaiñellena, ona feiñoitɨmacɨ cuega. Naie lloga uai suillena, bie jofo muidomona mai ana uai. Naimɨe ie lloga uaina fɨnorede; ia iena cue uiñollena, mai ana uai. ");
INSERT INTO huuNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesús uai ote: —Dama ite. Ana uaiñeitɨcue. Ero, ie comɨnɨmo Moisés mɨcorɨ jaie cuega: “Caɨ Nama Jusiñamuina facacɨñeno”. Naimɨe cuena raise eenuana jai uiñotɨcue. Jamai ebena naimɨena facacɨñeitɨcue. O lluana fɨnoñeitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ie mei a ite anedumo Taɨfe naimɨena uite, naie anedumona nana naɨraɨaɨna cɨoillena. Naie naɨraɨaɨ eo ebire eruaɨde. ");
INSERT INTO huuNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Naimɨemo llote: —Nana bie naɨraɨaɨ cue anamo birui illamona, cuena o sedaia, nana bie naɨraɨaɨ omo iitɨcue. O caiñɨcɨ ɨfodo ana raɨnada, cuemo iobillacɨno o fecallena. ");
INSERT INTO huuNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jesús uai ote: —Dama ite. Ona sedañeitɨcue. Ie comɨnɨmo Moisés mɨcorɨ jaie cuega: “Caɨ Nama Jusiñamuina seda. Dama naimɨemo iobillacɨnona feca”. Taɨfe, mai cuemona oni jai. ");
INSERT INTO huuNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","—Ie facaise naimɨemona Taɨfe jaide. Naimɨe jailla mei, Jusiñamui jaɨenisaɨ Jesús dɨne bitɨmacɨ. Naimɨena ecallena bitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Naie facaise Juan Bautista mɨcorɨna Herodes gaɨtajana naimɨe fɨdɨano, Galilea railla enɨruemo Nazaretmo Jesús jaide. ");
INSERT INTO huuNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nainomo rilla mei, Capernaumo jaide. Capernaum naɨraɨ jorai fuemo ite. Nainomo Zabulón railla enɨrue ite. Neftalí railla enɨrue jɨaɨ ite. ");
INSERT INTO huuNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Nainomo Jesús jailla jira, Isaías mɨcorɨ jaie cuegafuiaɨ jai suide. ");
INSERT INTO huuNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Naimɨe mɨcorɨ naie comɨnɨna jaie cuega: Bie enɨruemo dɨga naɨraɨ ite. Zabulón ite. Neftalí ite. Monaillai fuemo naɨraɨ ite. Jordán ruicafebeimo naɨraɨ ite. Galileamo naɨraɨ jɨaɨ ite. Nainomo judíuaɨñedɨno jai itɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Jeacɨno anamo naimacɨ illamona, naga naie enɨruemo ite comɨnɨ jitɨredɨnomo itɨmacɨ isoidɨmacɨ Jusiñamuina uiñoñeno fiodaicana jaidɨmacɨ; iadedɨ eo mare rafue birui cacaitɨmacɨ. Naie rafue naimacɨ comecɨaɨna llɨgaiñoite. Naie rafuena uitɨmɨe bairenite cuega. Jusiñamuina naimacɨ uiñoñena jira, naimacɨna iese cuega. Jesús nainomo birui llofuia jira, mare rafuena jai cacadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Galileamo rilla mei, Jesús llocana jaide. Llofuete: —Jusiñamui dɨbeimo illena, omoɨ jeacɨnona faɨnonocaida, omoɨ comecɨaɨ iuaina meido. Ie comɨnɨna omoɨ jaillena birui jitaide. ");
INSERT INTO huuNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jɨaɨruido Galilea railla jorai fuemo Jesús macaritemo, menamɨena cɨode. Naga ie ama iaɨmaiaɨ. Damɨe Simón. Jɨaɨcɨ naimɨe mamecɨdɨ Pedro. Ie ama Andrés dɨga ite. Lloijina faɨraɨma iaɨmaiaɨ. Iese jaca naie iaɨmaiaɨdɨ maɨjɨuidɨiaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Iaɨmaiaɨmo llote: —Cue dɨga omɨco jaioicaillena, cue dɨga mai bi. Cue llofueganona omɨco jaillena jitaidɨcue. Llɨcɨaɨna birui ocabitomɨco; iadedɨ comɨnɨna oitomɨco, cue dɨbeimo naimacɨ illena. ");
INSERT INTO huuNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Iena cacajanona, ieconi iaɨmaiaɨ lloijina faɨnonocaida, naimɨe dɨga jaidɨiaɨmaiaɨ. Ie llofueganona jaillena, jaidɨiaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Llɨaɨ baɨ Jesús jaidemo, jɨaɨe menamɨena cɨode. Naga ie ama iaɨmaiaɨ. Damɨe Jacobo. Jɨaɨmɨe Juan Iaɨmaiaɨ moodɨ Zebedeo. Naimɨe dɨga botemo itɨiaɨmaiaɨ. Lloijina sɨgaɨdɨmacɨ. Jesús iaɨmaiaɨna uaidote, naimɨe llofueganona jaillena. ");
INSERT INTO huuNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ieconi iaɨmaiaɨ moona faɨnonocaida, botemona arɨ billanona, Jesús dɨga jaidɨiaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Nana Galileamo Jesús jaide. Judíuaɨ ofiracuaɨmo llofueuide. Naimɨe anamo comɨnɨ illana Jusiñamui jitailla jira, Jesúdɨ Jusiñamui dɨbeimo naimacɨ comecɨaɨ iuaina meiduana llofuete. Ie comɨnɨna naimacɨ illena llofuete. Naga isoide duicona duidɨnona jillotate. ");
INSERT INTO huuNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Iemona nana Siria railla enɨruemo naimɨe mamecɨ soride. Naie comɨnɨ naga isoide duicona duidɨnona naimɨe dɨne atɨdɨmacɨ. Abɨ isiredɨnona atɨdɨmacɨ. Jananɨaɨ anamo illa comɨnɨna atɨdɨmacɨ. Naɨllidɨnona atɨdɨmacɨ. Niraɨdanidɨnona atɨdɨmacɨ. Nana naimacɨna jillotate. ");
INSERT INTO huuNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ailluena comɨnɨ naimɨena racadɨmacɨ. Galileamona, Decápolimona, Jerusalémona, Judeamona, Jordán ruica dɨbeimona comɨnɨ bitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","2","Ailluena comɨnɨna Jesúna racadɨmacɨ. Naimacɨna Jesús cɨuanona, anedu muidomo jaide. Ie llofueoicaigano naimɨe dɨga jaidɨmacɨ. Nainomo ana raɨta, Jesús naimacɨmo llote: —Omoɨna Jusiñamui ie comɨnɨna sedaacana rafuena ja llofueitɨcue. Naimɨe anamo naimacɨ illena llofueitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Ero, Jusiñamui naimɨena jitaidɨnona sedaite. Comecɨaɨna facadɨmacɨ: “Naimɨe jitaillacɨnona danɨ fɨnonidɨcaɨ; ia naimɨe caɨna canuanona, iena fɨnoitɨcaɨ”. Naimɨe comɨnɨna naie isoidɨno illamona, naimɨe naimacɨna canoite. Iemona caɨmare iitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Jusiñamui sunaitɨnona sedaite. Ailluena comɨnɨ jeacɨno fɨnocana jaidɨmacɨ. Iena uiñuamona, damɨerie sunaitɨmacɨ. Naimɨe comɨnɨna naie isoidɨno illamona, Jusiñamui naimacɨ comecɨaɨna ocuiñotaite. Iemona caɨmare iitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Jusiñamui abɨna ɨedoñedɨnona sedaite. Naimɨe comɨnɨna naie isoidɨno illamona, Jusiñamui nana enɨrue naimacɨmo iite. Enɨruemo comɨnɨna ɨco cue sedaia, iese iite. Iemona caɨmare iitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Jusiñamui naimɨe jitaillacɨno fɨnodɨnona sedaite. Jusiñamui mare rafuena naimacɨ fɨnuana canoite. Iemona caɨmare iitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Jusiñamui comɨnɨna duenaitɨnona sedaite. Naimacɨna naimɨe duenaillamona, Jusiñamui naimacɨna ɨco duere fɨnoñeite. Iemona caɨmare iitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Jusiñamui jeanide comecɨredɨnona sedaite. Naimɨe comɨnɨna naie isoidɨno illamona, naimɨe dɨga jaca iitɨmacɨ. Iemona caɨmare iitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Jusiñamui naimɨe dɨga uri itɨnona sedaite. Naimɨe comɨnɨna naie isoidɨno illamona, jɨaɨe comɨnɨna uri itataitɨmacɨ. Naie isoidɨno naimɨe comɨnɨna jaca mamecɨrenitɨmacɨ. Iemona caɨmare iitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Jusiñamui jitaillacɨnona fɨnuamona, damɨerie duere sefuitɨmacɨ. Jusiñamui naie isoidɨnona sedaite. Naimɨe comɨnɨna naimacɨ illamona, naimɨe sedajanomo jaca jaɨnaɨaɨtɨmacɨ. Iemona caɨmare iitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Cuemo omoɨ duia, duere sefuitomoɨ. Jɨaɨe comɨnɨ omoɨna jeare ñaɨtɨmacɨ. Omoɨna duere fɨnoitɨmacɨ. Omoɨ joreñona taɨnona lloitɨmacɨ. Duere sefuitomoɨ; iadedɨ Jusiñamui omoɨna caɨmare itataite. ");
INSERT INTO huuNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Omoɨ isoi omoɨ jaiagaɨmona Jusiñamui facaina lloraɨnɨ mɨcorɨaɨ jaie duere sefuidɨmacɨ. Iena omoɨ uiñuamona, monamo Jusiñamuimona ailluena ɨbana ɨco omoɨ feiñua jira, birui omoɨ duere sefuia, iocɨre omoɨ jai. ");
INSERT INTO huuNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Jesús llote: —Jusiñamui ie comɨnɨna sedaacalle rafue nia llofueitɨcue. Llɨcɨsi rɨfaia, jai maraiñede. Iena rɨfaiñellena, llɨcɨsimo sal jonetɨcaɨ. Sal isoidomoɨ. Jusiñamui jitailla isoi omoɨ illamona, jɨaɨe comɨnɨ maraiñede rafuena eo fɨnoñedɨmacɨ. Sal ie caɨmano jai iñenia, ¿nɨese dane nɨbaɨamona caɨmarenite? Jai maraiñede. Jitaiñena jira, iena oni faɨga. Ie isoide. Jusiñamui jitailla isoi omoɨ iñenia, naimɨe omoɨna duere fɨnoite. ");
INSERT INTO huuNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Cuemo omoɨ duilla jira, jɨaɨe comɨnɨna Jusiñamuina omoɨ uiñotajamona, llɨgaiñora isoidomoɨ. Anedumo ite naɨraɨ jaca bairede. Ie illanona jaca uiñotɨcaɨ. Jusiñamui jitailla isoi omoɨ illamona, jɨaɨe comɨnɨ naimɨena uiñoitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Lamparín unia mei, cɨrɨgaɨ anamo buna raɨnañega. Jaca ie raɨnarafomo raɨnaca, nana jofo jeraina llɨgaiñollena. ");
INSERT INTO huuNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ie isoide. Cue rafuena jamaiñeno; iadedɨ omoɨ marena illamona, comɨnɨna Jusiñamuina uiñota. Omoɨ marena illamona, comɨnɨ omoɨ mare fɨnoca rafuena uiñoitɨmacɨ. Iemona: “Juiñamui maremɨena” raitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Jesús llote: —Jusiñamui ie comɨnɨna sedaacalle rafue nia llofueitɨcue. Iena cue llofuia jira, omoɨmona damɨerie comecɨna facade: “Bimɨe Moisés mɨcorɨ lloga rafuedo jaiñede”. Ero: “Moisés mɨcorɨ llogacɨnuaɨ maraiñede” raiñedɨcue. “Jusiñamui facaina lloraɨnɨ mɨcorɨaɨ jaie llogacɨnuaɨ maraiñede” jɨaɨ raiñedɨcue; iadedɨ omoɨna naie llogacɨnaɨna raise uiñotaacadɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Biemo omoɨ comecɨaɨna faca. Mona, enɨrue dɨga, nia ia, nana naie llogacɨnuaɨ jaca suite. ");
INSERT INTO huuNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Omoɨ einamacɨ raitɨmacɨ: “Dajerie llogacɨno jɨaɨe llogacɨno baɨfemo faɨte”. Cue raitɨcue: Naga llogacɨno omoɨ ɨɨnoñenia, naga omoɨ llofueñenia, nana Jusiñamui jitaillacɨnona fɨnoñedomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ero, Jusiñamui jitailla rafuedo judíuaɨ illaɨcomɨnɨ baɨfemo omoɨ jaiñenia, Jusiñamui sedajanomo jaca iñeitomoɨ. Naimacɨ naie jaie llogacɨnuaɨ uiñotɨmacɨ; iadedɨ naimacɨ comecɨaɨ Jusiñamui dɨbeimo iñedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Jesús llote: —Omoɨ llofueraɨnɨmona bie jai cacadomoɨ. Moisés mɨcorɨ omoɨ jaiagaɨmo llote: “Comena meineñeno. Comena bu meineia, jeacɨno jai fɨnode. Naimɨe fiodaillena juez llua”. ");
INSERT INTO huuNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Naie llogacɨnodo jai jaicabidomoɨ. Omoɨmo birui jɨaɨe rafue lloitɨcue. Jɨaɨmɨe dɨga bu icɨria, jeacɨno jai fɨnode. Naimɨe duere sefuillena, juez dɨne naimɨe uiga. Jɨaɨmɨena bu jeare ñaɨa, jeacɨno jai fɨnode. Naimɨe duere sefuillena, illaɨcomɨnɨ dɨne naimɨe uiga. Jɨaɨmɨena bu faidoia, jeacɨno jai fɨnode. Jusiñamui naimɨena duere fɨnoite. Iraimo jaite. ");
INSERT INTO huuNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","’Jerusalémo Jusiñamui jofomo omoɨ jeacɨno facaina naimɨemo ra fecallena omoɨ jaia, omoɨ comɨnɨ dɨga uri nano i. Jɨaɨmɨe omoɨ dɨga icɨrillana omoɨ uibiñoia, omoɨ ra faɨnonocaida, naimɨe dɨne nano mai jai. Naie rafue raise fɨnollena, naimɨe dɨne jai. Ie mei Jusiñamuimo omoɨ rana feca. ");
INSERT INTO huuNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Omoɨna bu llogɨdoia, juez dɨne nia omoɨ riñenia, omoɨna llogɨdotɨmɨe dɨga naie rafuena raise fɨno. Iena raise fɨnoñenia, juez dɨne omoɨ ria, nainomo duere sefuitomoɨ. Calabozomo omoɨna oretaite. ");
INSERT INTO huuNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nana raise ɨbañenia, juez llua isoi, jino jaiñeitomoɨ. Iese omoɨmo suiñellena, jɨaɨmɨe dɨga rafuena comuitañeno. Jeacɨno fɨnoñellena, jɨaɨmɨe dɨga icɨriñeno. ");
INSERT INTO huuNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Jesús llote: —Omoɨ llofueraɨnɨmona bie jai cacadomoɨ. Moisés mɨcorɨ jaie llote: “Omoɨ aɨñede rɨñonɨaɨ dɨga iñeno. Omoɨ ɨniñede ɨiñɨaɨ dɨga iñeno”. “Iena bu fɨnoia, jeacɨno jai fɨnode” raitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Jɨaɨe rafue birui lloitɨcue. Ie aɨñede rɨñomo eruaɨllamona naiñaiñona bu nɨcɨdoia, naiñaiño dɨga jamai ɨnɨacananona naimɨe comecɨ facajamona, jeacɨno jai fɨnode. Naiñaiño dɨga iñede; ia naiñaiño dɨga jamai ɨnɨacananona naimɨe comecɨ facajamona, jeacɨno jai fɨnode. ");
INSERT INTO huuNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","30","Biena ñaɨtɨcue. Nɨe isoide rafue omoɨna jeacɨno fɨnotaia, iemo eruaɨñeno. Iena llɨnoñeno. Iemo comecɨna facañeno. Omoɨ cɨua rana jira, omoɨ jitaillamona jeacɨno fɨnodomoɨ. Rana omoɨ jetaja jira, omoɨ jitaillamona jeacɨno fɨnodomoɨ. Omoɨ abɨna omoɨ namatañenia, omoɨ uisɨna juicono. Omoɨ onollɨ jaita. Omoɨ comecɨna ñaɨtɨcue. Omoɨ abɨna omoɨ raise namatallena, omoɨ comecɨ nano raise fɨno. Jeacɨno omoɨ fɨnoia, iraimo jaitomoɨ. Nana omoɨ abɨ dɨga iraimo jaitomoɨ. Iraimo omoɨ jaiñellena, jeacɨno fɨnoñeno. ");
INSERT INTO huuNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Jesús llote: —Omoɨ llofueraɨnɨmona bie jai cacadomoɨ. Moisés mɨcorɨ jaie llote: “Ie aɨna bu dotaacania, naiñaiñomo dotajacanabena fecaja”. Iedo jai jaicabidomoɨ. Iena bu fɨnoia, omoɨmona mare. ");
INSERT INTO huuNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Jɨaɨe rafue birui lloitɨcue. Jɨaɨmɨe dɨga naiñaiño iñenia, ie aɨna bu dotajia, maraiñede. Jɨaɨruido jɨaɨmɨe dɨga naiñaiño ia, nanodɨ ie ɨni muidona naiñaiño jeacɨno jai fɨnode. Dotaca rɨñona ie aɨna illena bu ua mei, naimɨedɨ jeacɨnona jai fɨnode. Jeacɨno fɨnoñellena, aɨna dotañeno. ");
INSERT INTO huuNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","35","Jesús llote: —Omoɨ llofueraɨnɨmona bie jai cacadomoɨ. Moisés mɨcorɨ omoɨ jaiagaɨmo llote: “Taɨno lloñeno; ia Jusiñamuimo omoɨ lloga uaina fɨno”. Iedo jai jaicabidomoɨ. Omoɨ lloga uai omoɨ fɨnollena jɨaɨe comɨnɨ uiñollena, Jusiñamui mamecɨna llɨnotomoɨ. “Iena caɨ llɨnoia, caɨ lloga uaina caɨ fɨnoñenia, Jusiñamui caɨna duere fɨnoite” raitomoɨ. Jusiñamui mamecɨ omoɨ llɨnoñenia, omoɨ lloga uai omoɨ fɨnoñenia, omoɨmona mare. “Jusiñamui caɨna duere fɨnoñeite” raitomoɨ. Iemona monamo ite ra mamecɨna jamai ebena llɨnotomoɨ. Enɨruemo ite ra mamecɨna jamai ebena llɨnotomoɨ. Jerusalén railla naɨraɨ mamecɨna jamai ebena llɨnotomoɨ. Omoɨ ɨfogɨ mamecɨna jamai ebena jɨaɨ llɨnotomoɨ. Jusiñamui mamecɨna jamai ebena llɨnoñedomoɨ; ia jɨaɨe ra mamecɨna jamai ebena llɨnotomoɨ. Ero, monamo ite ra mamecɨna omoɨ llɨnoia, Jusiñamui mamecɨna jɨaɨ llɨnotomoɨ, nainomo ie illano illa jira. Enɨruemo ite ra mamecɨ omoɨ llɨnoia, iena Jusiñamui fɨnua jira, iena naimɨe sedaja jira, naimɨe mamecɨna jɨaɨ llɨnotomoɨ. Jerusalén railla naɨraɨ mamecɨna omoɨ llɨnoia, Jerusalén naimɨe naɨraɨna jira, naimɨe mamecɨna jɨaɨ llɨnotomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Omoɨ jitɨrede ɨfotɨraɨna usere omoɨ jaitanina jira, omoɨ userede ɨfotɨraɨna jitɨre omoɨ jaitanina jira, omoɨ ɨfogɨ mamecɨ jɨaɨ llɨnoñeno. Dama Jusiñamui iena usere itataja jira, dama naimɨe iena jitɨre itataja jira, ɨfotɨraɨ mamecɨna omoɨ llɨnoia, Jusiñamui mamecɨna jɨaɨ llɨnotomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ie jira Jusiñamui mamecɨ jamai ebena llɨnoñeno. Jɨaɨe ra mamecɨ jamai ebena llɨnoñeno; iadedɨ nɨe isoide rafuena omoɨ fɨnoia, omoɨ lloga uaina taɨno lloñeno fɨno. Uanaicɨnona jaca llono. Uanaicɨnona omoɨ lloñenia, Taɨfemona omoɨ uaina otomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Jesús llote: —Omoɨ llofueraɨnɨmona bie jai cacadomoɨ. Moisés mɨcorɨ jaie llote: “Fuirillamona o uisɨna jɨaɨmɨe jino juiconoia, juez naimɨe uisɨna juiconuana llua. O isidona jɨaɨmɨe oni taɨnoia, juez naimɨe isidona oni taɨnuana llua. Jɨaɨmɨe ona duere fɨnoia, o duere sefuilla isoi, juez naimɨena duere fɨnua”. Iedo birui jai jaicabidomoɨ; ");
INSERT INTO huuNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","iadedɨ birui omoɨmo llotɨcue: Ɨbana oñeno. Maraiñede rafue fɨnodɨmɨemona omoɨ abɨna rɨidoñeno. Omoɨ cacaɨna naimɨe dutaia, naimɨe dɨga icɨriñeno. Enefebeimo omoɨ uieco dobaiño, enefebei omoɨna naimɨe dutallesa. Naimɨe omoɨna duere fɨnoia, ɨbana oñeno. ");
INSERT INTO huuNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Omoɨ ɨniroi baɨrollena omoɨna bu llogɨdoia, juez nia omoɨmo lloñenia, naimɨe jitailla ɨniroi baɨfemo naimɨemo feca. ");
INSERT INTO huuNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Daje kilómetro naimacɨ raruiaɨ omoɨna uillana illaɨcomɨnɨ ocuia, iena uiño. Nɨbaɨ omoɨ comecɨ jitaiñede; ia naimacɨna canollena, iena mena kilómetros uiño. Naimacɨ ocuilla baɨfemo uiño. ");
INSERT INTO huuNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Omoɨmo ite rana bu jɨcaia, iena caidɨñeno. Omoɨ rana bu jamai jɨcuano uia, abɨdo atɨllena, iena caidɨñeno feca. ");
INSERT INTO huuNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Jesús llote: —Omoɨ llofueraɨnɨmona bie jai cacadomoɨ. Llotɨmacɨ: “Omoɨ comɨnɨna isirui; iadedɨ omoɨ naɨraɨñedɨnona enoi”. Iedo jai jaicabidomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Omoɨmo birui llotɨcue: Omoɨ naɨraɨñedɨnona isirui. Omoɨ gaɨñenanona isirui. Omoɨna duere fɨnodɨno facaina Jusiñamuimo jɨɨ. Naimacɨ comecɨaɨ iuai meiduana naimɨemo jɨcano. ");
INSERT INTO huuNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Jusiñamui comɨnɨna omoɨ illamona, naimacɨ facaina jɨɨ. Ero, Jusiñamui nana comɨnɨna daje isoi canode. Nana comɨnɨna daje isoi isiruilla jira, naimɨedɨ jitomana maraiñedɨnona llɨgaiñotade. Mareuidɨnona jɨaɨ llɨgaiñotade. Maraiñedɨno dɨne nocɨ deitate. Mareuidɨno dɨne jɨaɨ nocɨ deitate. ");
INSERT INTO huuNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Naimɨe comɨnɨ omoɨ illamona, nana comɨnɨ daje isoi isirui. Omoɨna isiruitɨnona omoɨ isiruia, mare; iadedɨ omoɨna gaɨñenanona omoɨ isiruiñenia, Jusiñamui omoɨna: “Mare” raiñeite. Maraiñede fɨnoraɨnɨ naimacɨna isiruitɨnona isiruitɨmacɨ. Nana comɨnɨna omoɨ isiruiñenia, maraiñede fɨnoraɨnɨ baɨfemo faɨñedomoɨ. Naimacɨ isoi itomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Danɨ omoɨ comɨnɨna omoɨ uaidoia, mare; ia omoɨna gaɨñenanona omoɨ uaidoñenia, naimacɨ baɨfemo faɨñedomoɨ. Jusiñamuina ɨɨnoñedɨno baɨfemo faɨñedomoɨ. Naimacɨ isoi itomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Iena omoɨ uiñuamona, omoɨ Moo Jusiñamui fɨnua isoi, mare rafuena fɨnocana omoɨ jai. ");
INSERT INTO huuNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Jesús llote: —Omoɨna nia llofueitɨcue. Jɨaɨe comɨnɨ iena cɨoillena, mare rafuena omoɨ fɨnoiadedɨ, omoɨna: “Mareuidɨnodɨmacɨ” naimacɨ raillena, Jusiñamuimona ɨbana feiñoñeitomoɨ. Ie jira mare rafuena fɨnoñeno, iena jɨaɨe comɨnɨ jamai cɨoillena. Iena ja ñaɨtɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Dueredɨnomo rana omoɨ jamai fecaia, iena uainino feca. Jɨaɨe comɨnɨmona iobillacɨnona omoɨ feiñollena, iena fecañeno. Ofiracomo maredɨnona abɨ caitadɨno isoi omoɨ iñeno. Naɨsomo maredɨno abɨ caitadɨno isoi iñeno. Iena comɨnɨ cɨoillena, dueredɨnomo rana marefodo fecacabidɨmacɨ. Comɨnɨmona naimacɨ iobillacɨno birui jai feiñotɨmacɨ. Jusiñamuimona ɨco feiñoñeitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Dueredɨnomo rana omoɨ fecaia, jɨaɨe comɨnɨmo iena lloñeno. ");
INSERT INTO huuNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Iena bainino feca. Bainino iena omoɨ fecaia, Jusiñamui iena uiñote. Naimɨemona ɨbana feiñoitomoɨ. Omoɨna: “Mare” raite. ");
INSERT INTO huuNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Jesús llote: —Jusiñamuimo omoɨ jɨɨia, maredɨnona abɨ caitadɨno isoi omoɨ iñeno. Ofiracomo naimacɨna comɨnɨ cɨoillena, marefodo jɨɨdɨmacɨ. Jɨɨcabilla facaiseconi naɨsomo naimacɨ ia, naimacɨna comɨnɨ cɨoillena, marefodo jɨaɨ jɨɨdɨmacɨ. Naimacɨna: “Jusiñamuina eo sedadɨmacɨ” comɨnɨ raillana jitaidɨmacɨ. Comɨnɨmona iobillacɨnona birui jai feiñotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Omoɨ jɨɨacania, omoɨ jofomo fo jai. Nainomo Jusiñamuimo anado omoɨ jɨɨ. Iena Jusiñamui uiñuamona, omoɨ jɨcaca rafue naimɨemona feiñoitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Jusiñamuimo omoɨ jɨɨia, naimɨena ɨɨnoñedɨno isoi jamaicɨnona ñaɨñeno. Naimacɨ comecɨna facadɨmacɨ: “Daje jɨɨracɨnona dɨga icaiño caɨ jɨɨa jira, ja muidomo caɨ Moo caɨna raise cacaite”. ");
INSERT INTO huuNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Naimacɨ isoi iñeno. Nia omoɨ jɨcañenia, naimɨe omoɨ jitaille rafuena uiñote. ");
INSERT INTO huuNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Naimɨemo omoɨ jɨɨacania, iese jɨɨ: Ore Moo, monamo itɨo. Comɨnɨ ori iobidesa. ");
INSERT INTO huuNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","O illaɨmana jira, nana comɨnɨna o anamo raɨre itata. O jaɨenisaɨ o jitaillacɨnona fɨnua isoi, comɨnɨna o jitaillacɨnona fɨnota. ");
INSERT INTO huuNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Nagarui guille caɨmo itata. ");
INSERT INTO huuNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Caɨna jeare jɨaɨno fɨnoia, iena caɨmona feilla isoi, caɨ jeacɨnona omona feilla jira, caɨ jeacɨnona oni dota. ");
INSERT INTO huuNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Caɨmo ramo bu faɨa, caɨna cano, iena caɨ ɨɨnoi raillano. Jeacɨnona fɨnuamona caɨna jillota. Iese omoɨ jɨɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Omoɨna jɨaɨe comɨnɨ jeare fɨnoia, iena omoɨ feitaia, omoɨ monamo ite Moo omoɨ jeacɨnona iena feitajanona, jɨaɨ oni dotaite; ");
INSERT INTO huuNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","iadedɨ jɨaɨe comɨnɨ fɨnoca jeacɨnona omoɨ feitañenia, omoɨ Moo Jusiñamui omoɨ jeacɨnona feitañeite. Iena oni dotañeite. ");
INSERT INTO huuNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Jesús llote: —Omoɨna nia llofueitɨcue. Raitomoɨ: “Jusiñamuina eo raise caɨ sedajanona, birui caɨ guiñeitɨcaɨ. Iemona naimɨe caɨna eo duenaite” raitomoɨ. Iese Jusiñamuina omoɨ sedajia, sunaiñeno, mareuidɨnona abɨ caitadɨno isoi. Sunaitɨmacɨ. Naimacɨ uieco fɨnobicabisɨde. Naimacɨ guiñenarui facaise illana comɨnɨ uiñollena, naimacɨna comɨnɨ cɨoillena, iese itɨmacɨ. Naimacɨna: “Mare” comɨnɨ raillamona, iobillacɨnona birui jai feiñotɨmacɨ. Jusiñamuimona ɨco iena feiñoñeitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ero, naimacɨ isoi omoɨ iñeno; iadedɨ omoɨ guiñenarui ia, omoɨ abɨaɨ raise fɨno. ");
INSERT INTO huuNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Iemei comɨnɨdɨ omoɨ guiñenarui illana uiñoñeitɨmacɨ. Naimacɨmona iobillacɨnona feiñoñeitomoɨ. Dama Jusiñamui iena uiñoite. Bainino omoɨ fɨnoca rafue naimɨe uiñua jira, naimɨemona ɨba feiñoitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Jesús llote: —Omoɨ jofomo ailluena rana eenocana uiñeno. Gɨɨreco iena guicabite. Dajerie ra nemuide. Omoɨ jofomona jɨaɨe comɨnɨ iena fɨɨacadɨmacɨ. Ailluena ra eenuamo omoɨ comecɨaɨna facañeno; ");
INSERT INTO huuNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","iadedɨ Jusiñamui dɨne monamo omoɨ ra illa isoi, iemo omoɨ comecɨaɨna faca. Naimɨemo comecɨaɨna caɨ facajamona, nainomo caɨ iobillacɨno iite. Gɨɨrecuaɨmona, nemuillamona, fɨɨriraɨnɨmona, iena nainomo faɨfiñeitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Aillue ra omoɨmo ia, Jusiñamuimo comecɨaɨna facañedomoɨ; iadedɨ naimɨe jitaillacɨnona omoɨ fɨnoia, naimɨemo comecɨaɨna facadomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","23","Jesús llote: —Caɨ uisɨ dɨga rana cɨodɨcaɨ. Caɨ uisɨ maraiñenia, rana raise cɨoiñedɨcaɨ. Ie isoide. Caɨ comecɨ maraiñenia, maraiñedɨcɨnona fɨnocana jaidɨcaɨ. Jusiñamuina uiñoñedɨcaɨ. Ie rafuena jɨaɨ uiñoñedɨcaɨ. Naimɨena nabaiñedɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Jesús llote: —Mena patrones dɨga daruido buna jaca maɨjɨnide. Mena dɨga bu maɨjɨacania, damɨena jɨaɨmɨe baɨfemo gaɨite. Ie gaɨamɨe ocuica rana fɨnoite. Jɨaɨmɨe ocuica rana raise fɨnoñeite. Ie isoide. Raruiaɨ ollemo comecɨna omoɨ eo facaia, Jusiñamui jitaillacɨnomo comecɨna raise facañeitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Jesús llote: —Jusiñamui jitaillacɨnomo omoɨ comecɨna facaia, omoɨ illamo omoɨ comecɨna jarire facañeitomoɨ. Bue omoɨ guillemo jarire comecɨna facañeno. Omoɨ jɨtalle ɨniroimo jarire comecɨna facañeno. Jusiñamui omoɨna itataja muidona, guille omoɨmo iite. Naimɨe omoɨ abɨ fɨnua muidona, ɨniroidɨ omoɨmo iite. ");
INSERT INTO huuNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Silliñɨaɨmo comecɨna faca. Buena riñedɨmacɨ. Nɨe isoide guillena eenoñedɨmacɨ; iadedɨ omoɨ Moo Jusiñamui naimacɨna sedajamona, naimacɨ guille ite. Naimacɨ baɨfemo omoɨ faɨa jira, naimɨe omoɨna canoite. ");
INSERT INTO huuNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Omoɨmona, ¿bu ie comecɨ jarire facajamona a sairite? Iese jaca buna a sairiñede. Dama Jusiñamui omoɨna a sairitarede. ");
INSERT INTO huuNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","¿Bue ñellena ɨniroimo jarire comecɨna facadomoɨ? Safiamo omoɨ comecɨna faca. ¿Nɨese sɨcodɨmacɨ? Maɨjɨñedɨmacɨ. Ɨniroina tɨforiñedɨmacɨ; ");
INSERT INTO huuNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","iadedɨ Salomón mɨcorɨ naimacɨ isoi jaie iñede. Naimɨe illaɨmana jira, naimɨe mɨcorɨ ɨniroi eo ebirede; iadedɨ safia naimɨe ɨniroi baɨfemo ebire eruaɨde. ");
INSERT INTO huuNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Jusiñamui safiana ebiretacabide. Dallu facaise illanona, safiadɨ duide. Safia baɨfemo omoɨ uailla jira, Jusiñamuidɨ ɨniroina omoɨmo jaca iite. Safiana naimɨedɨ ebiretaja muidona, omoɨmo ɨniroidɨ jaca iite. Omoɨ ra omoɨmo illena, naimɨena ɨɨno. ");
INSERT INTO huuNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Omoɨ comecɨ jarire fɨnoñeno. “¿Buena guitɨcaɨ? ¿Buena jɨtaitɨcaɨ?” raiñeno. Iemo comecɨaɨna eo facañeno. ");
INSERT INTO huuNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Jusinamuina ɨɨnoñedɨno iemo comecɨna facacabidɨmacɨ. Nana omoɨ jitaillacɨnona omoɨ Moodɨ uiñua jira, naimacɨ isoi iñeno. ");
INSERT INTO huuNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Jusiñamui anamo raise omoɨ i. Naimɨe jitaillacɨnona fɨnocana omoɨ jai. Naimɨemo omoɨ comecɨ facaia, omoɨ illamo omoɨ comecɨna jarire facañeitomoɨ. Iemona guille omoɨmo iite. Ɨniroi omoɨmo iite. ");
INSERT INTO huuNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Jusiñamui omoɨ birui jitailla ra omoɨmo iite. Iena uiñuamona, jɨaɨruido suille rafuemo jarire comecɨna facañeno. Ɨco omoɨ jitailla ra omoɨmo jɨaɨ iite. ");
INSERT INTO huuNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Jesús llote: —Omoɨna nia llofueiacadɨcue. Jɨaɨe comɨnɨna mameriñeno. Jɨaɨe comɨnɨna omoɨ mameria, omoɨmo ite maraiñede rafue facaina Jusiñamui omoɨna duere fɨnoite. ");
INSERT INTO huuNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Jɨaɨe comɨnɨna omoɨ mamerilla dɨese Jusiñamui omoɨna duere fɨnoite. ");
INSERT INTO huuNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Omoɨ ecɨmo itɨmɨemo janore maraiñedɨcɨno illana omoɨ uiñoia, iemo comecɨna facañeno; iadedɨ omoɨmo ailluena ite maraiñedɨcɨnomo nano omoɨ comecɨna faca. ");
INSERT INTO huuNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Omoɨmo maraiñedɨcɨno illamona, ¿nɨese omoɨ ecɨmo itɨmɨena mameritomoɨ? ");
INSERT INTO huuNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Omoɨmo ite maraiñedɨcɨnomo omoɨ comecɨna facaacaiñena jira, maredɨnona abɨ caitadɨnodomoɨ. Omoɨ comecɨaɨna nano raise fɨno. Iemei omoɨ ecɨmo itɨmɨena canorenitomoɨ. Naimɨe comecɨna raise canorenitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Ero, eo mare rana omoɨ jɨconɨaɨmo fecañeno. Eo raifide rana omoɨ chanchuaɨmo fecañeno. Naimacɨmo omoɨ fecaiadedɨ, iena feiñoñeitɨmacɨ. Omoɨna gaɨñenamona, jɨconɨaɨ omoɨna aɨnitɨmacɨ. Chanchuaɨ iena jamaillamona, iena saitaitɨmacɨ. Ie isoide. Damɨerie Jusiñamui uaina uaitacabitɨmacɨ. Iena naimacɨ jaca feiñoñena jira, naie rafue naimacɨmo llocabiñeno. Naimacɨmo omoɨ llocabia, omoɨna duere fɨnoitɨmacɨ. Omoɨ rafuena jamaitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","8","Jesús llote: —Daje ra omoɨ faɨfia, iena jenodomoɨ. Raise jenoia, iena baitomoɨ. Damɨena omoɨ jenoia, naimɨe illanomo jaidomoɨ. Nainomo naimɨena baillamona, omoɨna feiñoite. Ie isoide. Buena omoɨ jitaia, Jusiñamuimo jɨca. Iena omoɨ jɨcaja jira, iena naimɨe cacajamona, omoɨmo iite. ");
INSERT INTO huuNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ero, omoɨmona naimɨemo llomenicona ie moomo ie jito jɨcaia, nofɨcɨna fecañede. ");
INSERT INTO huuNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Llɨcɨaɨna jɨcaia, jaiona fecañede. ");
INSERT INTO huuNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Jeacɨnona fɨnocabidomoɨ; iadedɨ mare ra omoɨ uruiaɨmo fecacabillana uiñotomoɨ. Caɨ Moo Jusiñamuidɨ jaca mareuidɨmɨe. Caɨ baɨfemo naimɨe faɨte. Ie muidona naimɨemo jɨcanotɨnomo mare rana fecaite. ");
INSERT INTO huuNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Jusiñamui jitaillacɨnona omoɨ fɨnuamona, jɨaɨe comɨnɨna marena fɨno. Jɨaɨe comɨnɨ omoɨna fɨnuana omoɨ jitailla isoi, naimacɨna fɨno. Naimacɨ omoɨna marena fɨnuana omoɨ jitaia, naimacɨna marena fɨno. Naimacɨ omoɨna maraiñeno fɨnuana omoɨ jitaia, naimacɨna ie isoi maraiñeno fɨno. Moisés mɨcorɨ ie isoidɨcɨnona jaie llofuete. Jusiñamui facaina lloraɨnɨ mɨcorɨaɨ ie isoidɨcɨnona jaie jɨaɨ llofuetɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","Jesús llote: —Jusiñamui dɨne omoɨ rillena, janorede naɨsodo omoɨ jailla isoi isoilla. Naɨsomo ite nasedɨ janorede isoide. Naimɨe dɨne naie rilla jira, naiedo omoɨ jai. Nainomo jaidɨno jaca iitɨmacɨ. Naimɨe dɨne rillena eo sefuirena jira, janore comɨnɨ naiedo jaidɨmacɨ. Jɨaɨe naɨso ite. Naie naɨsodɨ aillue. Naie naɨsomo ite nasedɨ jɨaɨ aillue. Naiedo jaidɨno faɨfitɨmacɨ. Jusiñamui dɨne riñeitɨmacɨ. Sefuinina jira, ailluena comɨnɨ naiedo jai jaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Jesús llote: —Jusiñamui facaina lloraɨnɨna abɨ caitadɨnomona abɨna rairui. Mare lloraɨnɨ isoi bitɨmacɨ; iadedɨ Jusiñamui rafuedo omoɨ raise jaiñellena, omoɨna jɨfueiacadɨmacɨ. Naimacɨ llofuiacɨnodo omoɨ jaia, Jusiñamui rafuedo raise jaiñeitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Naimacɨ lloga rafuemona naimacɨ Jusiñamui lloraɨnɨñenana uiñoitomoɨ. Ero, eecuaɨmona uvas railla riara oñega. Eecuaɨmona higos railla riara jɨaɨ oñega. ");
INSERT INTO huuNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Mare riaramona mare llɨsilla comuide. Maraiñede riaramona maraiñede llɨsilla comuide. ");
INSERT INTO huuNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Mare riaramona maraiñede llɨsilla comuiñede. Maraiñede riaramona mare llɨsilla comuiñede. ");
INSERT INTO huuNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Mare llɨsilla comuitañena jira, naga maraiñede riara jaitaca, iena jobaillena. ");
INSERT INTO huuNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ie isoide. Naimacɨ fɨnoca rafuemona nɨe isoide lloraɨnɨ naimacɨna uiñoitomoɨ. Jusiñamui lloraɨnɨdena uiñoitomoɨ. Jusiñamui lloraɨñedɨnodena uiñoitomoɨ. Naimacɨ maraiñena jira, Jusinamui naimacɨna duere fɨnoite. ");
INSERT INTO huuNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Jesús llote: —Naga cuemo: “Odɨ cue Namadɨo” raitɨmɨedɨ Jusiñamui ie comɨnɨna sedajanomo iñeite; iadedɨ dama cue Moo jitaille rafue fɨnodɨmɨedɨ nainomo iite. ");
INSERT INTO huuNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Comɨnɨmo juez isoi Jusiñamui ɨco llua facaiseconi, dɨga comɨnɨdɨ cuemo lloitɨmacɨ: “Nama, caɨna o oretatɨo caɨ raillamona, o rafuena llocabitɨcaɨ. O uaido jananɨaɨna oni oredɨcaɨ. O uai dɨga siño rafuena fɨnodɨcaɨ” lloitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Uai oitɨcue: “Omoɨna uiñoñedɨcue. Cue comɨnɨñedomoɨ. Jeacɨno omoɨ comecɨmo nia illa jira, cuemona oni omoɨ jai. Cue Moo ie comɨnɨ sedajanomo jaca iñeitomoɨ”. ");
INSERT INTO huuNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Jesús llote: —Cue lluana cacadomoɨ; iadedɨ omoɨmona nana ɨɨnoñedomoɨ. Cue lluana ɨɨnotɨmɨedɨ abɨ uiñotɨmɨe. Jofona raise fɨnodɨmɨe isoide. Jofona raise fɨnodɨmɨedɨ ie jofona fɨnodemo, jofona goiñellena, nofɨcɨ illa dɨnori eo ana raɨte. ");
INSERT INTO huuNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Nocɨ deidemo, eo jɨnuidemo, jofomo ille toia, aɨfɨ bitemo, jofo raise fɨnua jira, jofo goiñede. Iena faɨfiñede. Ie isoide. Cue lluana ɨɨnotɨmɨe faɨfiñeite. ");
INSERT INTO huuNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Cue lluana ɨɨnoñedɨmɨedɨ abɨ uiñoñedɨmɨe. Jofona raise fɨnoñedɨmɨe isoide. Jofona raise fɨnoñedɨmɨedɨ ie jofona fɨnodemo, conillɨe emodomo iena fɨnode. Ana raɨñede. ");
INSERT INTO huuNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Nocɨ deidemo, eo jɨnuidemo, jofomo ille toia, aɨfɨ bitemo, jofo goillamona, jai eo judaɨsite. Iena faɨfide. Ie isoide. Cue lluana ɨɨnoñedɨmɨe faɨfite —llote. ");
INSERT INTO huuNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","29","Moisés mɨcorɨ rafue uiñoraɨnɨ isoi naimɨe llofueñena jira, illaɨmamo ite uai itɨmɨe isoi naimɨe llofuia jira, nainomo ite comɨnɨdɨ naimɨe lluari raijicaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Naimɨe llofuia mei, anedumona Jesús ie llofueoicaigano dɨga ana bite. Ailluena comɨnɨ naimɨena racadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Efonaitɨmɨe naimɨe dɨne billanona, naimɨena raise uaiduamona, caiñɨcɨ ɨfodo ana raɨnadate. Raite: —Maestro, o jitaiadedɨ, cuena jillotaredɨo. ");
INSERT INTO huuNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jesús ie onollɨ naimɨemo oni ñuitajanona, naimɨena jetade. Raite: —Ona jillotaiacadɨcue. Mai o jillo. —Ieconi naimɨe jillode. ");
INSERT INTO huuNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Jesús naimɨemo llote: —O jilluana bumo lloñeno; iadedɨ Jerusalémo, Jusiñamui jofomo, Jusiñamui dɨga ñaɨraɨma dɨne mai jai. O jilluana comɨnɨ raise uiñollena, naimɨemo o abɨna acatajai. Moisés mɨcorɨ jaie lloga rana Jusiñamuimo feca. —Iemei Jesús oni jaide. ");
INSERT INTO huuNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Capernaum railla naɨraɨmo Jesús ria, capitán raillamɨe naimɨe dɨne bite. Naie capitán Roma railla naɨraɨ imɨe. Judíuñedɨmɨe. Billanona, duere llote: ");
INSERT INTO huuNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","—Maestro, cuena cano. Cue jofomo cue mullaɨma ite. Ie abɨna niraɨdanide. Naimɨe abɨ eo isirede. Naimɨena jillota. ");
INSERT INTO huuNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesús uai ote: —Naimɨe dɨne jaitɨcue, naimɨena cue jilloitallena. ");
INSERT INTO huuNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Naie capitán dane llote: —Jaiñeno. Jamai bue isoidɨcue. Iemo, ¿nɨese cue jofomo biitɨo? O uaido bene lluanona cue mullaɨma jilloite. ");
INSERT INTO huuNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Jɨaɨe illaɨcomɨnɨ anamo itɨcue. Naimacɨ lloga uaina ɨɨnotɨcue. Cue anamo jɨaɨe soldaduaɨ illanona, cue uaina ɨɨnotɨmacɨ. Cue anamo cue mullaɨma illa jira, naimɨedɨ cue uaina ɨɨnote. O anamo naie duico illa jira, o uaina o lloia, cue mullaɨma jilloite. ");
INSERT INTO huuNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Iena cacajanona, Jesús raijicaide. Naimɨe dɨga jaidɨnomo llote: —Bie isoi cue uaina ɨɨnotɨmɨena jaca baiñedɨcue. Caɨ judíuaɨ comɨnɨmona biesedɨmɨena jaca iñede. ");
INSERT INTO huuNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ero, Jusiñamui ie comɨnɨna sedajanomo naimacɨ illena, dɨga judíuaɨñedɨno cue llua uaina ɨɨnoitɨmacɨ. Naga naɨraɨaɨmona ɨɨnoitɨmacɨ. Jusiñamui comɨnɨna Abraham mɨcorɨ, Isaac mɨcorɨ, Jacob mɨcorɨ illamona, naimacɨ dɨga Jusiñamui ie comɨnɨna sedajanomo bie judíuaɨñedɨno iitɨmacɨ. Nainomo caɨmare nabaitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ailluena judíuaɨñedɨno ɨɨnoitɨmacɨ. Jusiñamui ie comɨnɨna sedajanomo duillanodɨ omoɨ judíuaɨ. Naimɨena omoɨ ɨɨnoñena jira, omoɨna oni dotaite. Dotaja mei, eo duere sefuillamona eeitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Capitámo Jesús llote: —Mai jai. Cue uai siñonana o ɨɨnua jira, o jitailla rafue omo jai suide. —Ieconi naimɨe mullaɨma jillode. ");
INSERT INTO huuNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Oni jaillanona, Pedro jofomo Jesús ridemo, Pedro jɨfaiño duillana cɨode. Naiñaiño abɨ cuaride. ");
INSERT INTO huuNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Naiñaiño dɨne jaillanona, naiñaiñona jetade. Jetajamona ieconi naiñaiño jillode. Abɨ cuariñede. Naiñaiño naidacaillanona, guille fɨnuanona, ie jofomo itɨnona ecade. ");
INSERT INTO huuNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Naie naɨona naimɨe dɨne comɨnɨ ailluena jananɨaɨ anamo itɨnona atɨdɨmacɨ. Ie uaido naimɨedɨ jananɨaɨna oni oretate. Nana atɨca duidɨnona jɨaɨ jillotate. ");
INSERT INTO huuNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Naimacɨna Jesús jillotajamona, Isaías mɨcorɨ jaie cuegafuiaɨ iese jai suide. Naimɨe mɨcorɨ jaie cuega: “Caɨna jilloitajanona, caɨ duicona oni oretaite”. ");
INSERT INTO huuNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ailluena comɨnɨ naimɨe ecɨmo illana Jesús cɨuanona, ie llofueoicaiganomo ruica dɨne jaillena llote. ");
INSERT INTO huuNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ieconi Moisés mɨcorɨ rafue llofueraɨma naimɨe dɨne billanona, llote: —Maestro, o jaillɨnomo o dɨga jaiacadɨcue. O llofuegamɨena jaiacadɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesús uai ote: —Janorede ocainaɨaɨdɨ joforedɨmacɨ. Silliñɨaɨ jɨllaɨnɨaɨredɨmacɨ; iadedɨ jofonidɨcue. Monamona billanona, ɨimana jaidɨcue; iadedɨ buenidɨcue. Jofonidɨcue. Cue dɨga o jaiacania, bue isoidena cuemona oñeitɨo. Iemo o comecɨna raise faca. ");
INSERT INTO huuNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ie facaise jɨaɨe llofuegamɨe Jesúmo llote: —O dɨga jaitɨcue; ia cue moo nia fiodaiñena jira, o dɨga nia jaiñeitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jesús naimɨe uai ote: —Cue dɨga idai mai bi. Cuena ɨɨnoñedɨnodɨ o moona canoredɨmacɨ. Naimɨe fiodaia, naimɨena naimacɨ raɨlle. Cue rafue jɨaɨe rafue baɨfemo faɨte. Cue dɨga mai bi. ");
INSERT INTO huuNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Naie llofuegamɨe dɨga Jesús ñaɨa mei, ruica dɨne jaillena, botemo jaide. Ie llofueoicaigano jɨaɨ jaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Botemo jailla mei, Jesús ɨnɨde. Baɨ jorai motomo jaidɨmacɨmo, eo rɨire aɨfɨ billamona, joraidɨ eo bagode. Baguamona botemo jɨnui a uaide. Bote oruiacana jira, ");
INSERT INTO huuNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","jacɨruillamona, Jesúna casitatɨmacɨ. Raitɨmacɨ: —Maestro, caɨna cano. Jai buisaidɨcaɨ. Jai corobaisaidɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jesús uai ote: —¿Bue ñellena jacɨnaitomoɨ? Cuena raise ɨɨnoñedomoɨ. Jacɨnaiñeno. Iemei Jesús naidacaillano, aɨfɨna lletade. Joraina jɨaɨ llɨɨcaitade. Ieconi llɨɨcaide. Bagoñede. ");
INSERT INTO huuNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Naimɨe llofueoicaigano iemona raijicaidɨmacɨ. Iemona raitɨmacɨ: —Bimɨedɨ, ¿nɨe isoidɨmɨe? Aɨfɨ naimɨe uaina ɨɨnote. Jorai naimɨe uaina jɨaɨ ɨɨnote. Baɨ jaillanona, ruica dɨne ridɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ruica dɨne naimacɨ ridemo, Gadara railla enɨruemo sɨjɨdɨmacɨ. Ieconi menamɨe Jesús dɨne bitɨiaɨmaiaɨ. Jananɨaɨ anamo ite iaɨmaiaɨ. Comɨnɨ raɨoillanomo nofɨe moto ifuaɨmona bitɨiaɨmaiaɨ. Nai iaɨmaiaɨ eo rɨirena jira, jaca bu nainomo jainide. ");
INSERT INTO huuNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Jesúna iaɨmaiaɨ cɨua facaise jananɨaɨ iaɨmaiaɨna cuirioitate: —Jusiñamui Jitodɨo. ¿Nɨese cocona nɨbaɨacadɨo? Coco duere sefuille facaise nia iñede; iadedɨ birui cocona duere fɨnuaɨbidɨo —cuirioidɨaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Naie baɨ iaɨre ailluena chanchuaɨ guillano itɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Jananɨaɨ Jesúmo duere llotɨmacɨ: —Oni caɨna o oretajanona, chanchuaɨ abɨmo caɨna oreta. ");
INSERT INTO huuNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jesús uai ote: —Mai jai. Ieconi nai iaɨmaiaɨmona jananɨaɨ oni jaillanona, chanchuaɨ abɨmo jaide. Iemona iconɨaɨdo chanchuaɨ joraimo aisɨcana jaillanona, corobaisɨde. ");
INSERT INTO huuNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Iena cɨuanona, chanchuaɨ sedaraɨnɨ imacɨ naɨraɨ dɨne aisɨcana jaidɨmacɨ. Nana naie rafuena llotɨmacɨ. Jaive jananɨaɨ anamo illa iaɨmaiaɨ rafuena llotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ie jira ailluena comɨnɨ Jesús dɨne bitɨmacɨ. Naimɨena cɨuano, naimɨemo duere llotɨmacɨ, naimacɨ illanomona naimɨe jaillena. Naimacɨ jitailla jira, Jesús oni jaide. ");
INSERT INTO huuNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Botemo ie llofueoicaigano dɨga Jesús jaillano, ruica dɨne abɨdo jaide. Capernaumo ie illanomo ride. ");
INSERT INTO huuNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Nainomo rilla mei, naimɨe dɨne comɨnɨ ie bɨiramo bɨide tɨsitaitɨmɨena atɨde. Naimɨena atɨdɨnodɨ Jesús naimɨena jillotajana ɨɨnote. Iena Jesús uiñuanona, tɨsitaitɨmɨemo llote: —Moo, o comecɨna ocuiño. O jeacɨno cue feitaja jira, iena jai oni dotadɨcue. Ie facai ɨbana jai oñeitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Jesús dɨne ofidɨnomona dajerie Moisés mɨcorɨ llogacɨnona llofueraɨnɨ itɨmacɨ. Jesús lluana naimacɨ cacajano, Moisés mɨcorɨ llogacɨnona llofueraɨnɨ comecɨna facadɨmacɨ: “Dama Jusiñamui jeacɨnona dotarede. Bimɨe Jusiñamuiñede; ia Jusiñamui ifomo iacade. Jusiñamuina jai jeare ñaɨte”. ");
INSERT INTO huuNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Naimacɨ comecɨaɨna facajacɨnona Jesús uiñuamona, Jesús dɨnena jɨcanote: —¿Bue ñellena omoɨ comecɨna jeare facadomoɨ? ");
INSERT INTO huuNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Bimɨemo: “O jeacɨnona jai oni dotadɨcue” cue lloia, cue uai siñonana uiñoñeitomoɨ; ia bimɨemo: “Mai naidacaillanona macari” cue lloia, cue uai siñonana uiñoitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Monamona jaie cue billanona, ɨimana jaidɨcue. Ie jira jeacɨno oni dotaja uai cuemo ite. Iena omoɨ uiñollena, tɨsitaitɨmɨemo lloitɨcue: “Mai naidacai. O bɨira ferɨanona, o jofomo mai jai”. ");
INSERT INTO huuNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Iese naimɨe raillamona, tɨsitaitɨmɨe jillode. Naidacaida, ie jofomo jaide. ");
INSERT INTO huuNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Comɨnɨ iena cɨuanona, jacɨnaitɨmacɨ. Bimɨemo ie uaina Jusiñamui fecajana naimacɨ uiñuamona, Jusiñamuimo iobillacɨnona fecadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jesús baɨ macaritemo, cuena ucubena oranomo cue raɨllana cɨode. Mateodɨcue. Gobierno ucube oraɨmadɨcue. Jesús cuemo llote: —Cue llofuegamɨena o jaillena, cue dɨga bi. Naidacaida, naimɨe dɨga jaidɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Naillɨ cue jofomo Jesús ie llofueoicaigano dɨga guite. Dɨga gobierno ucube oraɨnɨ jɨaɨ guisaɨbitɨmacɨ. Dɨga Moisés mɨcorɨ llogacɨnodo jaiñedɨno jɨaɨ guisaɨbitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Nainomo fariseuaɨ comɨnɨ jamai bitɨmacɨ. Moisés mɨcorɨ llogacɨnodo eo jaidɨmacɨ. Jesúna cɨuanona, naimɨe llofueoicaiganomo jɨcanotɨmacɨ: —¿Bue ñellena omoɨ maestro ucube oraɨnɨ dɨga guite? Maraiñede comɨnɨ dɨga naimɨe guite. Moisés mɨcorɨ llogacɨnodo ucube oraɨnɨ raise jaiñenamona, naie isoidɨno dɨga, fariseuaɨ comɨnɨ nabairiñena jira, iese jɨcanoitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Iena cacajano, Jesús llote: —Ecairedɨnodɨ médicona jitaiñedɨmacɨ; ia duidɨnodɨ médicona jitaidɨmacɨ. Ie isoide. Mareuidɨno cuena jitaiñedɨmacɨ; ia maraiñedɨno cuena jitaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Jusiñamui facaina lloraɨma mɨcorɨ jaie cuega rafuemo omoɨ comecɨaɨna faca: “Jusiñamui llote: ‘Rana cuemo omoɨ fecajana jitaidɨcue; ia comɨnɨna omoɨ dueruillana jɨaɨ jitaidɨcue’ llote”. Comɨnɨna cue dueruilla jira, Jusiñamui dɨbeimo naimacɨ illena, mareuidɨnona itatajaɨbiñedɨcue; iadedɨ Jusiñamui dɨbeimo naimacɨ illena, maraiñedɨnona itatajaɨbitɨcue. Omoɨmona maraiñedɨno dɨga nabairitɨcue; ia naimacɨna uaɨbitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Naie facaise Juan Bautista llofueoicaiganodɨ Jesús dɨne bite. Naimɨemo llote: —Caɨ einamacɨ llua isoi, Jusiñamuina caɨ raise iobitallena, guiñenaruillaɨ illa facaiseconi guiñedɨcaɨ. Caɨ jeacɨno facaina sunaicabitɨcaɨ. Fariseuaɨ comɨnɨ jɨaɨ guiñedɨmacɨ; iadedɨ o llofueoicaigano guitɨmacɨ. Caɨ einamacɨ llogacɨnodo jaidɨcaɨ. ¿Bue ñellena o llofueoicaigano iedo jaiñedɨmacɨ? ");
INSERT INTO huuNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesús uai ote: —Jɨaɨe rafuedo iena lloitɨcue. Coniruedɨ ie aɨna uarui ia, iobilla jira, ie nabaiñɨaɨ sunaiñedɨmacɨ. Iobillamona guitɨmacɨ. Jɨaɨruido jai aɨreiacade conirue naimacɨ dɨga iñenia, naimacɨ comecɨ sunaillamona, naimacɨ jitaia, guiñenaruillaɨdɨ iite. Ie isoide. Cue comɨnɨ dɨga birui cue illa jira, iocɨre itɨmacɨ. Ɨco cue jaille mei, sunaitɨmacɨ. Ie muidona birui cue llofueoicaigano guicabitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Jɨaɨe rafuedo iena lloitɨcue. Nia jocoñega comue ɨniroidɨ jacaɨe ɨniroimo jɨlliñega. Jɨlliadɨ, jocua mei, comue ɨniroi jacaɨe ɨniroimona fo llirite. Eo fodo cuararite. Jai maraiñeno cɨoite. ");
INSERT INTO huuNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Jacagomona fɨnoca bolsa como fɨnoca vino joneñega. Jonegadena, maɨriñena jira, sɨrillamona, igoɨ raɨre cuararite. Vino faɨfite. Igoɨ jɨaɨ faɨfite. Como fɨnoca vino comogomo jonelle. Iemei iena faɨfiñeite. Ie isoide. Omoɨ einamacɨ rafue ifomo jɨaɨe rafue birui ite. Iena omoɨmo llocabitɨcue. Iedo jaidɨcaɨ —llote. ");
INSERT INTO huuNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Juan Bautista llofueoicaigano dɨga Jesús llotemo, jɨaɨmɨe naimɨe dɨne bite. Naimɨedɨ judíuaɨ ofiraco sedaraɨma. Jesúna duere jɨcanollena, caiñɨcɨ ɨfodo raɨnadacaida llote: —Cue jisa como fiodaite. O onollɨ naiñaiñomo o jonellesa, naiñaiño jilloillesa, cue jofomo cue dɨga mai bi. ");
INSERT INTO huuNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Iena cacajano, Jesús naimɨe dɨga jaide. Ie llofueoicaigano jɨaɨ jaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Baɨ jaillanona, duidɨñaiño jɨnafona jaide. Naimɨe ɨniroina jetallena, naimɨe dɨne bite. Ie jeraimona doce años jaca dɨaide. Billanona naimɨe ɨniroina jetade. ");
INSERT INTO huuNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","“Naimɨe ɨniroi cue jetajamona jilloitɨcue” comecɨna facajamona, naiñaiño naimɨe ɨniroina jetade. ");
INSERT INTO huuNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ieconi Jesús dobaidacaida, abɨdo erodatemo, naiñaiñona cɨode. Raite: —Ñoo, o comecɨna ocuiño. Cuena o ɨɨnua jira, jai jillodɨo. Ieconi naiñaiño jillode. ");
INSERT INTO huuNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ofiraco sedaraɨma jofomo Jesús rillano, naie jofo nama jisa jai fiodailla jira, comɨnɨ merɨre fillana cacade. Ailluena faɨlliñaillana cacade. ");
INSERT INTO huuNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Jesús dɨnena raite: —Jofomona nana omoɨ jino jaillana jitaidɨcue. Cuemona biñaiño fiodaiñedesa. Jamai ɨnɨde. Iena cacajano, naiñaiño jai fiodaite uiñuamona, Jesúri jaɨsitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Comɨnɨ jino oretaja mei, naiñaiño onollɨna naimɨe llɨnuano, fiodaillamona naiñaiño jillode. Jillua mei, naiñaiñodɨ naidacaide. ");
INSERT INTO huuNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Naie rafue nana naie enɨrue itɨnomo llocana jaide. ");
INSERT INTO huuNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ofiraco sedaraɨma jofomona Jesús baɨ jaidemo, uisɨnide iaɨmaiaɨ naimɨe jɨnafona jaidɨaɨmaiaɨ. Jesúna ado uaidotɨiaɨmaiaɨ: —Caɨ illaɨma David mɨcorɨ jitodɨo. Jusiñamuimona o billa jira, cocona duenai. ");
INSERT INTO huuNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Uai oñeno Jesús Capernaumo jaide. Naimɨe fo jailla mei, naimɨe dɨne bitɨiaɨmaiaɨ. Iaɨmaiaɨmo Jesús jɨcanote: —¿Omɨcona cue jillotajana ɨɨnotomɨco? Faɨriotɨiaɨmaiaɨ: —Jɨɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Iaɨmaiaɨ uisɨna Jesús jetajano raite: —Cuena omɨco ɨɨnua dɨese jilloitomɨco. ");
INSERT INTO huuNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ieconi iaɨmaiaɨ uisɨdɨ cɨode. Jesús naie rafuena lluana eo janotade. —Bumo lloñeno —llote; ");
INSERT INTO huuNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","iadedɨ iena llocana jaidɨiaɨmaiaɨ. Iemona Jesús mamecɨ nana naie enɨruemo itɨnomo soride. ");
INSERT INTO huuNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Capernaumona Jesús baɨ jaidemo, naimɨe dɨne Janaba anamo illamɨena jɨaɨe comɨnɨ atɨdɨmacɨ. Janaba anamo naimɨe illa jira, naimɨe ñaɨnide. ");
INSERT INTO huuNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jesús Janabana oni orede. Oretaja mei, naie ɨima ñaɨte. Nainomo ite comɨnɨ raijicaillanona raitɨmacɨ: —Caɨ comɨnɨ dɨne bie isoide ɨima jilluana jaca cɨoiñedɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ie jira fariseuaɨ comɨnɨ dɨnena raitɨmacɨ: —Taɨfe dɨbeimo Janaba illamona, Jesúdɨ Taɨfe uaido Janabana oni orede —raitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Dɨga naɨraɨaɨmo ie llofueoicaigano dɨga Jesús llocana jaide. Nainomo judíuaɨ ofiracuaɨmo llofueuide. Naimɨe anamo comɨnɨ illana Jusiñamui jitailla jira, Jesúdɨ Jusiñamui dɨbeimo naimacɨ comecɨaɨ iuaina meiduana llofuete. Ailluena duidɨnona jillotate. Naga isoide duicomona jillotate. ");
INSERT INTO huuNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Naimacɨna duenaite. Naimacɨ comecɨaɨ itɨcɨno oni duiñoitɨmɨe iñena jira, naimacɨna duenaite. Ailluena comɨnɨna cɨode. Toɨca llaudaɨaɨ isoi ebe isoi jaidɨmacɨ. Naimacɨ comecɨaɨ ocuiñonidɨmacɨ. Jusiñamui naimacɨna sedaacana uiñoñedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Naimacɨna duenaillamona, ie llofueoicaiganomo llote: —Illɨmo ailluena trigo ia, iena ollena, ailluena maɨjɨraɨnɨna jitailla. Ie isoide. Ailluena comɨnɨ ite naimacɨmo Jusiñamui rafuena caɨ llollena; iadedɨ naie rafuena lloraɨnɨ eo iñedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ie rafue naimacɨ llollena, ailluena comɨnɨna raɨre naimɨe oretallena Jusiñamuimo jɨcano. ");
INSERT INTO huuNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ie doce llofueoicaiganona Jesús uaiduanona, naimacɨmo ie uai iñonocaide, jananɨaɨ anamona comɨnɨna jilloitallena. Duicona oni oretallena, iena jɨaɨ iñonocaide. ");
INSERT INTO huuNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ie llofueoicaiganodɨ iese mamecɨredɨmacɨ: Simón. Naimɨe mamecɨ jɨaɨcɨdɨ Pedro. Andrés. Naimɨedɨ Simón ama. Jacobo. Juan. Iaɨmaiaɨ Zebedeo jito iaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe. Bartolomé. Tomás. Cuena jɨaɨ uaidote. Mateodɨcue. Gobierno ucubena oraɨmadɨcue. Jɨaɨe Jacobo. Naimɨedɨ Alfeo jito. Tadeo. ");
INSERT INTO huuNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Jɨaɨe Simón. Naimɨedɨ cananista comɨnɨ facaisemo duide. Judas Iscariote mɨcorɨ. Naimɨedɨ Jesúna gaɨtatate. ");
INSERT INTO huuNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jesús ie llofueoicaiganona oni oretajanona, raite: —Judíuaɨñedɨno dɨne jaiñeno. Samaritano railla comɨnɨ dɨne jaiñeno; ");
INSERT INTO huuNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","ia caɨ judíuaɨ comɨnɨ dɨne jai. Naimacɨmona ailluena comɨnɨ Jusiñamui rafuena nia ɨɨnoñedɨmacɨ. Faɨficana nia jaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Omoɨ jaillanona, comɨnɨmo llono: “Jusiñamui facaina jaie lloraɨnɨ mɨcorɨaɨ llogamɨe jai bene ite. Naimɨe anamo omoɨ illana Jusiñamui jitailla jira, naimɨe dɨbeimo omoɨ comecɨaɨ iuaina meido”. ");
INSERT INTO huuNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Duidɨnona jillota. Fiodaitɨnona jillota. Efonaitɨnona jillota. Jananɨaɨna oni oreta. Cue uaina jamai omoɨ feiñua jira, comɨnɨna jilloitajana ɨbatañeno. ");
INSERT INTO huuNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ucubena uiñeno. Guille ifo meidollena, rana uiñeno. ");
INSERT INTO huuNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ailluena rana omoɨ uiñellena, bolsana uiñeno. Abɨ meidolle ɨniroina uiñeno. Meidolle zapatona uiñeno. Omoɨ abɨ rɨidollena, jɨguidana uiñeno. Jɨaɨe comɨnɨna omoɨ canua isoi, omoɨna naimacɨ canua. Naimacɨmona omoɨ jitailla rana omoɨ ono. Ie jira ailluena rana uiñeno. ");
INSERT INTO huuNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Nɨe naɨraɨmo omoɨ ria, omoɨ rafuena jitaidɨmɨena jeno, naimɨe jofomo omoɨ illena. Naie jofomo omoɨ i, naie naɨraɨmo omoɨ ille dɨnori. ");
INSERT INTO huuNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Naie jofomo omoɨ rillanona, naie comɨnɨna marena uaido. ");
INSERT INTO huuNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Omoɨna naimacɨ raise feiñoia, naimacɨ uri illena, naimacɨmo marecɨnona llono; iadedɨ omoɨ rafuena naimacɨ jitaiñenia: “Jusiñamui omoɨna canoite” naimacɨmo lloñeno. ");
INSERT INTO huuNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Omoɨna bu feiñoiacaiñenia, omoɨ uaina bu cacarefiacaiñenia, naie naɨraɨmona omoɨ jaillanona, omoɨ eɨllɨaɨmo ite jearacuaɨna jaidɨno. Maraiñede rafuena naimacɨ fɨnuana naimacɨ uiñollena, omoɨ eɨllɨaɨna jaidɨno. ");
INSERT INTO huuNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Omoɨmo uanaicɨnona llotɨcue. Omoɨna naimacɨ feiñoñenia, Jusiñamuidɨ naimacɨna duere fɨnoite. Sodoma railla naɨraɨ jaie jeacɨnona eo fɨnodɨmacɨ. Gomorra railla naɨraɨ jaie jeacɨnona eo fɨnodɨmacɨ. Ie jira Jusiñamui naimacɨna jaie duere fɨnode. Omoɨna comɨnɨ birui feiñoñenia, Jusiñamuidɨ naimacɨna Sodoma naɨraɨ baɨfemo duere fɨnoite. Gomorra naɨraɨ baɨfemo duere fɨnoite. ");
INSERT INTO huuNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Jesús ie llofueoicaiganomo nia llote: —Naimacɨna janallari fañellena, naimacɨ duere sefuiñellena, toɨca llaudaɨaɨ raise sedajana jitaidɨmacɨ. Ie isoide. Eo maraiñede comɨnɨ motomo omoɨna oretaitɨcue. Omoɨna duere fɨnoacanitɨmacɨ. Raise sedajana jitaidomoɨ. Jaio fiodaiñellena, aisɨde. Naimɨena bu meineñellena, ie abɨna eenollena, jaio aisɨde. Ie isoi omoɨ abɨ uiñocana omoɨ jai. Ucugɨdɨ buena jeare fɨnoñede. Ie isoi omoɨ illa. Jeacɨno fɨnuamona eneno omoɨ i. ");
INSERT INTO huuNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Abɨna rairui. Dajerie omoɨna llogɨdoitɨmacɨ. Omoɨna gaɨtaja mei, naimacɨ ofiracomo omoɨna faitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Cue rafue omoɨ llua muidona, omoɨna gaɨtajanona, illaɨcomɨnɨ dɨne omoɨna uitɨmacɨ. Omoɨna llogɨdoitɨnomo cue rafuena lloitomoɨ. Naie illaɨcomɨnɨmo iena jɨaɨ lloitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Naie illaɨcomɨnɨ dɨne omoɨ ia, omoɨ rɨidollɨcɨnomo omoɨ comecɨaɨna jarire facañeno. Naie facaise omoɨ ñaɨllɨcɨnona uiñoitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Danɨ omoɨ comecɨaɨ icɨnodo ñaɨñeitomoɨ; ia Jusiñamui Joreño uaido ñaɨtomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Cuena ɨɨnotomoɨ; ia ailluena cuena ɨɨnoñeitɨmacɨ. Cuena omoɨ ɨɨnua jira, omoɨna enoitɨmacɨ. Iemona dajerie ie amana meinetallena, naimɨena llogɨdoite. Dajerie moodɨ ie uruena meinetallena, naimɨena llogɨdoite. Dajerie uruiaɨdɨ naimacɨ moona, naimacɨ eina meinetallena, naimacɨna llogɨdoitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Cue muidona ailluena comɨnɨ omoɨna enoitɨmacɨ; iadedɨ cue uaina faɨnonocaiñedɨmɨe cue Moo dɨga monamo ja muidomo jaca iite. Naimɨena jillotaitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Cue rafue naimacɨ jitaiñenamona, omoɨna nɨe naɨraɨ duere fɨnoia, dɨnomona cue rafuena llollena, jɨaɨe naɨraɨmo raɨre jai. Cue rafuena omoɨ llollena, dɨga judíuaɨ illanuaɨmo nia jaitomoɨ. Nana naie comɨnɨ nia ɨɨnoñenia, Jusiñamui dɨnena dane abɨdo biitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Ero, ie llofueraɨma duere sefuia, ie llofuegamɨe daje isoi duere sefuite. Ie ecɨ illamɨe duere sefuia, ie mullaɨma daje isoi duere sefuite. ");
INSERT INTO huuNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ie isoide. Cue comɨnɨna omoɨ jaillamona, cue duere sefuia, jɨaɨ duere sefuitomoɨ. Taɨfe mamecɨ jɨaɨcɨ llɨnuanona, “Beelzebúdɨo” jɨaɨno cuena raitɨmacɨ. Iese cuena naimacɨ jeare ñaɨa jira, cue comɨnɨna omoɨ illa jira, omoɨna jɨaɨ jeare ñaɨtɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Jesús nia llote: —Cuena ɨɨnoñedɨno omoɨna jeare ñaɨtɨmacɨ; ia nana cue rafuena llocana omoɨ jailla jira, naimacɨna jacɨruiñeno. ");
INSERT INTO huuNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Omoɨmo rafuena anado jai llotɨcue. Iena nana comɨnɨmo marefodo llono. Ado llono. ");
INSERT INTO huuNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Omoɨ abɨna meineredɨmacɨ; ia omoɨ joreñona meinenidɨmacɨ. Omoɨna naimacɨ meineia, omoɨ joreño Jusiñamui dɨne jaite. Iena uiñuamona, omoɨ meineiacadɨnona jacɨruiñeno. Cue rafuedo omoɨ raise jaiñenia, Jusiñamuina jacɨrui. Naimɨedɨ omoɨ abɨna, omoɨ joreño dɨga, iraimo dotarede. ");
INSERT INTO huuNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Omoɨna duere fɨnoacadɨnona jacɨruiñeno. Ero mena janorede sillina fecadomoɨna, eo janore ɨbaca; iadedɨ caɨ Moo Jusiñamui jitaiñenia, naimacɨmona daje fiodaiñede. ");
INSERT INTO huuNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ero, nɨga ɨfotɨraɨ omoɨmo illana Jusiñamui uiñote. ");
INSERT INTO huuNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Naimɨedɨ omoɨna sedajana jɨaɨ uiñote. Silliñɨaɨ baɨfemo Jusiñamui isiruigaomoɨ. Omoɨ duere fɨnoacadɨnona jacɨruiñeno. Jusiñamui jitaiñenia, omoɨmo jaca buena suiñeite. ");
INSERT INTO huuNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Ie llofueoicaiganomo Jesús nia llote: —Cue rafuena omoɨ lluamona, jɨaɨno omoɨna duere fɨnoitɨmacɨ. Cuena birui omoɨ janoñenia, nana comɨnɨ Jusiñamui uicomo ɨco ia, nainomo omoɨna janoñeitɨcue. “Cue comɨnɨdomoɨ” omoɨna raitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Cuena birui omoɨ janoia, nana comɨnɨ Jusiñamui uicomo ɨco ia, nainomo omoɨna janoitɨcue. “Cue comɨnɨñedomoɨ” omoɨna raitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Ie llofueoicaiganomo Jesús nia llote: —Nana comɨnɨna uri itatallena enɨruemo biñedɨcue. Cuena ɨɨnoñedɨnodɨ cuena ɨɨnotɨnona enoitɨmacɨ. Enoillamona cuena ɨɨnotɨnona duere fɨnoitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Cue lloga rafuena damɨerie ɨɨnua muidona, ie moo illa dɨbeimo ie jito iñeite. Ie ei illa dɨbeimo naiñaiño jisa iñeite. Ie jɨfaiño illa dɨbeimo naiñaiño mio iñeite. Iese comɨnɨna uri itatañedɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Omoɨ comɨnɨ coninɨna enoitomoɨ. Iemona duere sefuitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ero, ie moona cue baɨfemo bu isiruia, ie eina cue baɨfemo bu isiruia, cue jitailla ra naimɨe fɨnoacaiñena jira, cuemo raise duiñede. Ie uruiaɨ cue baɨfemo bu isiruia, cuemo raise duiñede. ");
INSERT INTO huuNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Cue facaina bu fiodaiacaiñenia, cuemo raise duiñede. Naimɨedɨ cue comɨnɨ naimɨena lloiacaiñedɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Cue facaina fiodaiacaiñedɨmɨe ja muidomo faɨfite. Cue dɨga jaca iñeite; iadedɨ cue facaina fiodaitɨmɨe monamo cue dɨga jaca iite. ");
INSERT INTO huuNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Jesús llote: —Cue rafuena omoɨ llocana jaia, dɨga jofuemo riitomoɨ. Cue comɨnɨna omoɨ illamona, omoɨna feiñotɨno cuena jɨaɨ feiñotɨmacɨ. Omoɨna bu feiñoia, cuane jɨaɨ feiñote. Cuena feiñotɨmɨedɨ cuena oretatɨmɨena jɨaɨ feiñote. ");
INSERT INTO huuNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Naimɨe cue comɨnɨ illamona, damɨerie Jusiñamui facaina lloraɨmana feiñoitɨmacɨ. Jusiñamui facaina lloraɨmana bu feiñoia, Jusiñamuimona ɨbana feiñoite, naie lloraɨma Jusiñamuimona feiñua isoi. Cue jitaillacɨnona fɨnodɨnona bu feiñoia, naimacɨ Jusiñamuimona feiñua isoi, Jusiñamuimona ɨbana feiñoite. ");
INSERT INTO huuNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Cue dɨbeimo itɨnona bu janore canoia, Jusiñamuimona ɨbana feiñoite. Naimacɨmo nɨbaɨ jamai jɨnuina fecade; iadedɨ naimacɨna canuamona, Jusiñamuimona ɨbana feiñoite —llote. Iemei Jesús ie llofueoicaiganona, ie rafuena llollena, orede. ");
INSERT INTO huuNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ie doce llofueoicaiganona Jesús oretaja mei, iaɨrei ite comɨnɨ illanuaɨmo naimɨedɨ ie rafuena llocana jaide. ");
INSERT INTO huuNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ie facaiseconi cárcelmo Juan Bautista mɨcorɨ Jesús fɨnoca rafuena fɨdɨano, iena raise uiñollena, Jesús dɨne ie llofueoicaiganona orede. ");
INSERT INTO huuNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Jesúmo llotɨmacɨ: —Juan Bautistamona bitɨcaɨ. Jofue iñenanomo navui naimɨe ia, “Jusiñamuimona damɨe biite” naimɨe llofuecabite. Juan llofuegamɨena o illana uiñoiacadɨcaɨ. Imɨeñedɨodena, jɨaɨmɨe billemo nia ocuiridɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesús uai ote: —Cue lluana cacadomoɨ. Cue fɨnoca rafuena cɨodomoɨ. Juan dɨne abɨdo omoɨ jaillanona, iena naimɨemo llono. ");
INSERT INTO huuNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","“Uisɨnidɨno jai cɨodɨmacɨ. Ñuja-ñujacaida jaidɨnodɨ jai raise macaritɨmacɨ. Efonaitɨno jai jillodɨmacɨ. Jefona cacaiñedɨnodɨ jai jefona cacasɨte. Fiodaillamona damɨerie jai jillodɨmacɨ. Dueredɨno mare rafuena jai cacadɨmacɨ” naimɨemo llono. ");
INSERT INTO huuNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Jɨaɨ llono: “Nɨbaɨ nana cue rafuena raise cacaiñedɨo; ia cuena jaca nia ɨɨnocana o jaia, caɨmare iitɨo”. ");
INSERT INTO huuNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Juan llofueoicaigano abɨdo jailla mei, naimɨe ecɨmo ailluena ite comɨnɨmo Jesúdɨ Juan rafuena llote: —Jofue iñenanomo naimɨe navui ia, naimɨe dɨne jaidomoɨ. ¿Nɨe isoidɨmɨena cɨodomoɨ? Daje uaido rafuena comecɨna facadɨmɨena cɨodomoɨ. Ero, fuirɨna aɨfɨ billamona, raitɨre afai bɨjɨde. Afaina aɨfɨ billamona, raitɨre fuirɨ bɨjɨde. Naimɨe ie isoiñede. Nɨe isoide rafue naimɨemo ia, cue rafuena llocana jaide. ");
INSERT INTO huuNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Bue ñellena naimɨe dɨne jaidomoɨ? Mare ɨniroina jɨtadɨmɨena cɨoiñedomoɨ. Mare ɨniroina jɨtadɨnona omoɨ cɨoacaniadedɨ, illaɨcomɨnɨ dɨne jaidomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Jusiñamui facaina lloraɨmana cɨodomoɨ. Naimɨe Jusiñamui facaina llocabite. Jɨaɨe lloraɨnɨ baɨfemo faɨte, cue billena omoɨmo naimɨe llua jira. ");
INSERT INTO huuNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Malaquías mɨcorɨ naimɨena jaie cuega: Jusiñamui raite: “Ero, o uicodo cue rafuena llollena, damɨena oretaitɨcue, comɨnɨ comecɨaɨna marecɨnona duiñollena” cuega. Malaquías Juan Bautistana cuete. ");
INSERT INTO huuNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Juan Bautista nana Jusiñamui facaina lloraɨnɨ baɨfemo faɨte; iadedɨ Jusiñamui comɨnɨna birui bu illamona, Juan baɨfemo birui faɨte. Juan cue billena llofuete; ia naimɨe cue lloga rafuena omoɨ isoi cacaiñede. Naimɨe cue lloga rafue omoɨ isoi suillana cɨoiñede. Iemona naimɨe baɨfemo faɨtomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Juan llofuia taɨniamona ailluena comɨnɨ cue rafuena ɨɨnuamona, Jusiñamui dɨbeimo birui duere iacadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Nana Jusiñamui facaina lloraɨnɨ mɨcorɨaɨdɨ cue billena jaie llotɨmacɨ. Moisés mɨcorɨ iena jɨaɨ jaie llote. Juan facaise naie llogacɨno jai suide. ");
INSERT INTO huuNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Jusiñamui facaina lloraɨma jaie llote: “Bie rafue suille facaise Elías isoidɨmɨe biite”. Naimɨe rafuena ɨɨnotomoɨdena, Juandɨ naimɨena uiñotomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Omoɨ jeforena jira, raise fueollena, cue lluamo cacarei. ");
INSERT INTO huuNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Jesús nia llofuete: —Ero, omoɨna ñaɨtɨcue. Jɨfanote uruiaɨ isoidomoɨ. Uruiaɨ jɨfanoiacania, naimacɨ nabaiñɨaɨna uaiduanona, raitɨmacɨ: ");
INSERT INTO huuNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Omoɨ dɨga jɨfanoiacadɨcaɨ; iadedɨ caɨ dɨga jɨfanoiacaiñedomoɨ. Caɨmarede rafuena caɨ jɨfanoiacania, sunailla rafuena jɨfanoiacadomoɨ. Sunailla rafuena caɨ jɨfanoiacania, caɨmarede rafuena jɨfanoiacadomoɨ. Coninɨna nabairiñedɨcaɨ” raitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ie isoidomoɨ. Juan jiroraɨnide. Caɨmare guiñede; ia naimɨe dɨga nabairiñedomoɨ. Naimɨena gaɨñedomoɨ. Ie jira omoɨmona dajerie naimɨena raitɨmacɨ: “Janaba anamo naimɨe illamona, naimɨe uaɨrico isoi ite” raitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Monamona billanona, ɨimana jaidɨcue. Omoɨ isoi guitɨcue. Caɨmataidɨcue; ia cue dɨga nabairiñedomoɨ. Cuena jɨaɨ gaɨñedomoɨ. Ie jira cuena jeare ñaɨtomoɨ. Raitomoɨ: “Guillaredɨmɨe. Jiroruidɨmɨe. Jearede rafue fɨnodɨno dɨga nabairitɨmɨedɨo”. Iese raitomoɨ; iadedɨ Jusiñamuina ɨɨnotɨnodɨ cue fɨnoca rafuena marenana uiñotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ailluena comɨnɨ Jesús dɨna nia ia, naimacɨmo ie navui jailla naɨraɨaɨna ñaɨte. Naimɨe siño fɨnoca rafuena uiñotɨmacɨ; iadedɨ naimacɨ comecɨaɨ iuai meidoñedɨmacɨ. Ie jira naimacɨna ñaɨte. ");
INSERT INTO huuNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Llote: —Omoɨmona damɨerie Corazín railla illanomona bitomoɨ. Omoɨmona damɨerie Betsaida railla illanomona bitomoɨ. Cue rafuena omoɨ ɨɨnoñena jira, duere sefuitomoɨ. Omoɨ dɨne cue navui siño fɨnoca rafuena Tiro railla naɨraɨmo jaie fɨnodɨcuena, Sidón railla naɨraɨmo jaie fɨnodɨcuena, naimacɨ comecɨaɨ eo isinotaillamona, naimacɨ comecɨaɨ iuai meidotɨmacɨ. Naimacɨ comecɨaɨ iuaina meiduana uiñotallena, ebinide ɨniroina jɨtajanona, naimacɨ ɨfogɨaɨmo jusefona jonetɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Jusiñamui uicomo nana comɨnɨ ɨco ia, Tiro naɨraɨ baɨfemo duere sefuitomoɨ. Sidón naɨraɨ baɨfemo duere sefuitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Omoɨmona damɨerie Capernaum railla illanomona bitomoɨ. Birui abɨna ɨedoiacadomoɨ; iadedɨ jɨaɨruido sunaitomoɨ. Omoɨ dɨne navui cue siño fɨnoca rafuena Sodoma railla naɨraɨmo jaie fɨnodɨcuena, naie naɨraɨdɨ birui niadedɨ nia ite. Omoɨ comecɨaɨ iuai omoɨ meidoñenia, monamo cue Moo dɨga jaca iñeitomoɨ; iadedɨ naimɨe omoɨna duere fɨnollemona sunaitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Jusiñamui uicomo nana comɨnɨ ɨco ia, cue rafuena omoɨ ɨɨnoñena jira, Sodoma railla naɨraɨ baɨfemo duere sefuitomoɨ —llote. ");
INSERT INTO huuNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","26","Ie facaiseconi Jesús ie Moo dɨga ñaɨanona raite: —Ore Moo, oca mona Namadɨo. Oca enɨrue Namadɨo. Abɨna uiñotɨnona bie isoide rafuena uiñotañedɨo; iadedɨ jamai bue isoidɨnona iena uiñotadɨo. O jitailla jira, iese uiñotadɨo. Ie jira iobillacɨnona omo fecaacadɨcue. Mai. ");
INSERT INTO huuNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Jesús dɨnena naimɨe ecɨmo ite comɨnɨmo dane llote: —Cue Moomona nana cue rafuena otɨcue. Dama cue Moo cuena raise uiñote. Dama cue Moona raise uiñotɨcue. Cue jitaille dɨese omoɨna naimɨena uiñotadɨcue. Ie muidona naimɨena uiñotomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Omoɨ jeacɨnomona omoɨ jillobillena, duere jaidomoɨ. Omoɨ comecɨaɨ marena uri illena, cue dɨbeimo mai omoɨ i. ");
INSERT INTO huuNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Cue lluacɨno anamo omoɨ i. Cue rɨinina jira, cuemona omoɨ fueo. Iemei omoɨ comecɨaɨ marena uri iite. ");
INSERT INTO huuNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Omoɨna cue canua jira, cue lluacɨno anamo omoɨ iacanano ia, sefuinide. Omoɨna cue canolle jira, cue lluacɨno fɨnuana sefuinide. ");
INSERT INTO huuNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ie rafue lluamona, ie llofueoicaigano jai abɨdo bitɨmacɨ. Ie facaiseconi sábadoruimo Jesús ie llofueoicaigano dɨga, trigo motodo joide naɨdo jaide. Ie llofueoicaigano aimetailla jira, trigona tɨjɨano, golluano, guicana jaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Dajerie fariseuaɨ iena cɨuano, llotɨmacɨ: —Ero, o llofueoicaigano rairuica rana fɨnosɨte. Moisés mɨcorɨ rairuilla jira, sábadoruimo maɨjɨnidɨcaɨ; iadedɨ trigona naimacɨ tɨjɨamona, caɨmona jai maɨjɨdɨmacɨ. Iese caɨ abɨmo jeacɨnona jai fɨnodɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ie llofueoicaiganona rɨiduano, Jesús uai ote: —Cuemona jeacɨno fɨnoñedɨmacɨ. David mɨcorɨ jaie fɨnoca rafuemo omoɨ comecɨaɨ raise facañedomoɨ. David mɨcorɨ guille iñenia, naimɨe aimetaia, ie nabaiñɨaɨ dɨga, Jusiñamui jofomo fo jaide. ");
INSERT INTO huuNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Jusiñamuimo fecaca llomenicona uanona, guitɨmacɨ. Jamai bue isoidɨno naie llomenicona guillana Jusiñamui rairuide. Danɨ Jusiñamui dɨga ñaɨraɨnɨ iena guiredɨmacɨ. Ie nabaiñɨaɨ dɨga David mɨcorɨ iena guite; ia Jusiñamui naimacɨna duere fɨnoñede. ");
INSERT INTO huuNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Moisés mɨcorɨ llogacɨnomo jɨaɨ raise comecɨaɨna facañedomoɨ. Moisés mɨcorɨ jaie llua isoi, sábadoruimo Jusiñamui jofomo Jusiñamui dɨga ñaɨraɨnɨ maɨjɨuidɨmacɨ. Jusiñamuina naimacɨ sedallena, ocainana fatɨmacɨ. Iraina bonodɨmacɨ. Iese maɨjɨuidɨmacɨ; iadedɨ Jusiñamuimona jeacɨno fɨnoñedɨmacɨ. Moisés mɨcorɨ jaie cuegafuiaɨna raise cacaiñedomoɨ. Iena raise facañedomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Omoɨmo nia lloitɨcue. Jusiñamui jofomo fɨnoca rafue baɨfemo faɨtɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Jusiñamui facaina lloraɨma iena jaie cuega: “Cuemo rana omoɨ fecajana jitaidɨcue; ia omoɨ jitaillamona, jɨaɨe comɨnɨna omoɨ duenaillacɨnodɨ rana cuemo fecajacɨno baɨfemo faɨte”. Iena omoɨ uiñotomoɨdena, cue llofueoicaiganomo: “Maraiñedɨcɨnona fɨnodomoɨ” lloñedomoɨ. Cuemona cue llofueoicaigano jeacɨno fɨnoñedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Monamona billanona, ɨimana jaidɨcue. Ie muidona sábadoruimo fɨnolle rafuena rairuiredɨcue. Nairuimo fɨnoñelle rafuena jɨaɨ rairuiredɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Baɨ jaillanona, naɨraɨ dɨne rillanona, naimacɨ ofiracomo Jesús fo jaide. ");
INSERT INTO huuNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Nainomo onollɨna ɨdɨsarodɨmɨe illanona, fariseuaɨ dɨnena Jesúmo jɨcanotɨmacɨ: —¿Sábadoruimo bimɨena o jilloitajana mare? —jɨcanotɨmacɨ. Sábadoruimo duidɨmɨena bu jillotaia, naimacɨmona naimɨe jai maɨjɨde. Uai uanona: “Mare” Jesús raiadedɨ, naimacɨmona naimɨe jai maɨjɨacana jira, naimɨena llogɨdoiacadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jesús uai ote: —Sábadoruimo omoɨmona damɨe ie toɨca llauda ifomo uaidena, nairuido arɨ iena ote. Naimɨemo buena lloñedomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ero, comɨnɨdɨ llauda baɨfemo faɨte. Sábadoruimo mare rafuena fɨnuadɨ mare. Bimɨena cue jillotaia, mare rafuena fɨnodɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Onollɨna ɨdɨsarodɨmɨemo llote: —O onollɨ mai oni ñuita. Iena ñuitajamona jillode. ");
INSERT INTO huuNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Iena cɨuanona, fariseuaɨ jino jaidɨmacɨ. Naimɨena meinellena, coninɨri siadotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Naimɨena naimacɨ meineiacanana Jesús uiñuamona, nainomona oni jaide. Dɨga comɨnɨ naimɨe dɨga jaidɨmacɨ. Naimacɨmona nana duidɨnona jillotate. ");
INSERT INTO huuNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","—Cuena llocana jaiñeno —naimacɨmo llote. Naimɨe mamecɨ are sorillana jitaiñede. Fariseuaɨ dɨga ie uai uaitaiacaiñede. ");
INSERT INTO huuNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Iemona Isaías mɨcorɨ jaie cuegafuiaɨ jai suide. Jusiñamui Isaías mɨcorɨna jaie cuetataga: ");
INSERT INTO huuNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Ero, cue fetoca mullaɨma ite. Naimɨedɨ cue isiruigamɨe. Naimɨeri iobidɨcue. Cue Joreño naimɨemo cue fecajanona, judíuaɨñedɨnomo naimacɨna cue jilloitaacanana lloite. ");
INSERT INTO huuNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Uai uaitañeite. Ie rafuena ado lloñeite. Naɨraɨ illano motomo naimɨe rafue llocabiñeite. ");
INSERT INTO huuNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Comecɨaɨ ocuinidɨnona canoite. Dueredɨnona canoite. Naimacɨna duere fɨnoñeite; ia naimacɨna canoite. Ie mare rafue lluamona, naimɨena ɨɨnotɨnona canoite. Nana comɨnɨ naimɨe anamo ille dɨnori iese naimɨe canoite. ");
INSERT INTO huuNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Naimacɨ jillobillena, ie rafue cacajanona, ailluena judíuaɨñedɨno naimɨena ɨɨnoitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Jesús dɨne damɨeriedɨ Janaba ie anamo illamɨena atɨdɨmacɨ. Janaba anamo naimɨe illa jira, naie atɨcamɨedɨ cɨoiñede. Jɨaɨ ñaɨñede. Jesús Janabana oni oretajanona, naimɨena jillotate. Naimɨe uaina botade. Ñaɨte. Cɨode. ");
INSERT INTO huuNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Naiena cɨodɨno raijicaillanona raitɨmacɨ: —Nɨbaɨ bimɨedɨ David mɨcorɨ jito. Caɨ illaɨmana naimɨe illena, naimɨe mɨcorɨ jitomo ocuiridɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Iena damɨerie fariseuaɨ cacajano, raitɨmacɨ: —Beelzebúdɨ Janaba comɨnɨ. Beelzebú anamo naimɨe illamona, Beelzebú uaido Janaba illa comɨnɨmona Jesús Janabana oni oretate —raitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Naimɨena naimacɨ enoillana Jesús uiñuanona, naimacɨmo llote: —Daje isoi comecɨaɨna lloillamo daje naɨraɨ facañenia, danomo maɨjɨnidɨmacɨ. Oni jaidɨmacɨ. Daje isoi comecɨaɨna lloillamo daje jofomo itɨno facañenia, danomo jaɨnaɨaɨnidɨmacɨ. Oni jaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ie isoide. Beelzebú uaido jananɨaɨna omoɨ llua isoi cue oretaia, Janaba ie dɨbeimo itɨno dɨga jai nabairiñede. Iemona naimɨe comɨnɨ danomo iñeitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Omoɨ comɨnɨ jananɨaɨna oni oretacabitɨmacɨ; iadedɨ naimacɨ fɨnoca rafuena uaitañedomoɨ. Naimacɨmo jɨcano, bie isoide rafuena omoɨ raise uiñollena. Iemei cue fɨnoca rafuena uaitañeitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","29","Ero, maɨridɨmɨe ie jofomo ite rana nɨbaɨ fɨɨacadomoɨ. Iena fɨɨllena, naimɨena nano raise omoɨ maɨga. Raise maɨa mei, ie rana fɨɨredomoɨ. Ie isoide. Janaba anamona comɨnɨna jillotacabitɨcue. Naimɨe afemo nano cue iñenia, comɨnɨna jillotanidɨcue. Naimɨe afemo cue illa jira, iena fɨnoredɨcue. Jusiñamui Joreño uaido naimɨena anafefitatɨcue. Iemona Jusiñamui rafuena cue lluana jai uiñotomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Cue dɨbeimo iñedɨmɨe cuena enoide. Cue dɨbeimo comɨnɨna itatañedɨmɨedɨ naie comɨnɨna cuena ɨɨnotañede. ");
INSERT INTO huuNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ie jira omoɨmo lloitɨcue: Jusiñamuidɨ nana comɨnɨ jeacɨnona dotarede. Naimɨedɨ comɨnɨ maraiñedɨcɨnona dotarede; iadedɨ naimɨedɨ ie Joreñona jeare ñaɨacɨnona dotañeite. ");
INSERT INTO huuNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","“Jusiñamui Joreño uaido siño rafuena fɨnoñedɨo; ia Janaba uaido siño rafuena fɨnodɨo” cuena raitomoɨ. Jusiñamuimona bitɨcue. Cuena omoɨ jeare ñaɨa, Jusiñamui iena feitarede; iadedɨ naimɨe Joreñona omoɨ jeare ñaɨa, Jusiñamui iena birui feitañeite. Iena ɨco jaca feitañeite. ");
INSERT INTO huuNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Jesús llote: —Llɨsillamona nɨe isoide riara illana uiñotɨcaɨ. Amena ie llɨsilla llillamona, amena marena uiñoga. Llillamona, amena maraiñenana jɨaɨ uiñoga. ");
INSERT INTO huuNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ie isoide. Omoɨ ñaɨamona omoɨna uiñotɨcaɨ. Cuena omoɨ maraiñeno ñaɨa jira, omoɨ comecɨaɨ itɨcɨnona uiñotɨcaɨ. Omoɨ maraiñena jira, jaio naɨraɨdomoɨ isoidomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Mareuidɨmɨe mare ie comecɨmona ñaɨte; iadedɨ maraiñedɨmɨe maraiñede ie comecɨmona ñaɨte. ");
INSERT INTO huuNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Jamai ebena birui omoɨ ñaɨa, Jusiñamui uicomo nana comɨnɨ ɨco illa facaiseconi Jusiñamui ɨba oite. ");
INSERT INTO huuNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Omoɨ jeare ñaɨaconi duere sefuitomoɨ; iadedɨ omoɨ mare ñaɨaconi duere sefuiñeitomoɨ. Ie jira Jusiñamui dɨbeimo omoɨ comecɨaɨ iuai meido. ");
INSERT INTO huuNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Naie facaiseconi dajerie Moisés mɨcorɨ llogacɨnona llofueraɨnɨ dajerie fariseuaɨ dɨga Jesúmo llotɨmacɨ: —Maestro, o lloga uaina caɨ ɨɨnollena, siño rafuena o fɨnuana cɨoacadɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jesús uai ote: —Maraiñedɨcɨnona fɨnocabidomoɨ. Jusiñamui dɨbeimo iacaiñedomoɨ; iadedɨ siño rafuena cɨoacadomoɨ. Iena omoɨ jamai cɨoillena, siño rafuena fɨnoñeitɨcue. Ero, Jonás mɨcorɨ jaie ite rafuena uiñotomoɨ. Naiemo omoɨ comecɨaɨna omoɨ faca. ");
INSERT INTO huuNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Darui amani aillue llɨcɨaɨ jeraimo naimɨe illamona jillode. Ie isoite. Cue fiodailla mei, darui amani raɨafomo iitɨcue. Iemei naiemona jilloitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Llɨcɨaɨ jeraimona naimɨe jillua mei, Nínive railla naɨraɨ dɨne Jonás mɨcorɨ jaide. Nainomo Jusiñamui rafuena llote. Naie comɨnɨ iena cacajano, naimacɨ comecɨaɨ icɨnuaɨna meidotɨmacɨ. Cue rafuena omoɨ cacajamona, omoɨ comecɨaɨ icɨnuaɨna birui omoɨ meidoñena jira, Jusiñamui uicomo ɨco nana comɨnɨ illa facaiseconi: “Cue comɨnɨdomoɨ” omoɨna raiñeitɨcue. Jonás mɨcorɨ baɨfemo birui uaidɨcue; iadedɨ cuena ɨɨnoñedomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ero, Saba railla naɨraɨ ie illaɨño mɨcorɨdɨ Salomón mɨcorɨ dɨne jaie aarena jaide. Naimɨe mɨcorɨ uiñuacɨnona naiñaiño mɨcorɨ cacareillena, aarena jaide. Salomón mɨcorɨ baɨfemo birui uaidɨcue; iadedɨ cuena ɨɨnoñedomoɨ. Omoɨ comecɨaɨ icɨnuaɨna birui omoɨ meidoñena jira, Jusiñamui uicomo nana comɨnɨ ille facaiseconi naiñaiño mɨcorɨ omoɨna ɨco ñaɨte: “Naimɨedɨ siño rafue fɨnuana cɨodomoɨ. ¿Bue ñellena naimɨena ɨɨnoñedomoɨ?” omoɨna ɨco ñaɨte. ");
INSERT INTO huuNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Jesús naimacɨmo nia llote: —Birui bene ite maraiñede comɨnɨdɨ Janaba anamo illamɨe isoidɨmacɨ. Naimɨemona Janaba oni jaia, jɨaɨe illanona baillena, jofue iñenanomo jaide; iade baiñede. ");
INSERT INTO huuNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Baiñena jira, naimɨe comecɨna facade: “Navui cue anamo illamɨe dɨne abɨdo jaitɨcue”. Abɨdo naimɨe bia, naie ɨima comecɨ namanidena naimɨe baite. ");
INSERT INTO huuNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Iemei oni jaillanona, jɨaɨe siete jananɨaɨna naimɨe dɨga atɨde, naimacɨ anamo naie ɨima illena. Naie siete jananɨaɨ naimɨe baɨfemo maraiñedɨmacɨ. Iemona naie ɨima eo fodo jaide. Ie isoide birui ite maraiñede comɨnɨ. Cue rafue naimacɨ ɨɨnoñenia, eo fodo jaitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jofomo comɨnɨ dɨga Jesús nia ñaɨa, naimɨe ei, ie amatɨaɨ dɨga, bite. Naimɨe dɨga ñaɨacanano, jino naidaide. ");
INSERT INTO huuNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Damɨe Jesúmo llote: —O ei, o amatɨaɨ dɨga, jino ite. O dɨga ñaɨacade. ");
INSERT INTO huuNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Naimɨemo Jesús dɨnena jɨcanote: —¿Bu cue ei? ¿Bu cue amatɨaɨ? ");
INSERT INTO huuNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ie llofueoicaigano dɨne ie onollɨ ñuitajanona, raite: —Jadi, cue ei, cue amatɨaɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Cue Moo monamo ite. Naimɨe jitaillacɨnona fɨnodɨmɨedɨ cue amana, cue mirɨñona, cue eina. Imacɨ ua cue comɨnɨna. ");
INSERT INTO huuNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Nai jofomona nairui Jesús jaillanona, jorai fue dɨne jaide. ");
INSERT INTO huuNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ailluena comɨnɨ nainomo ofilla jira, botemo Jesús jaillano, ana raɨde; iadedɨ comɨnɨ jorai fuedo itɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ailluena rafue naimacɨmo llote: —Jusiñamui omoɨna sedaacana omoɨ fueollena, bie rafuena lloitɨcue. Damɨe trigona judaɨaide. ");
INSERT INTO huuNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Naimɨe judaɨamona, naɨsomo janore iduaɨ juide. Naimɨe baɨ jailla mei, silliñɨaɨ iena guisaɨbitɨmacɨ. Ie jira sɨcoñede. ");
INSERT INTO huuNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Nofɨemo jɨaɨe iduaɨ juide. Nainomo enɨrue raise iñede. Sɨcode; iadedɨ enɨrue raise iñena jira, ");
INSERT INTO huuNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","raise jainañena jira, ecasillamona duide. Ie jira llɨsiñede. ");
INSERT INTO huuNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Eecuaɨ illanomo jɨaɨe iduaɨ juide. Eecuaɨ sɨcuamona, riara eecuaɨ ɨbaica. Ie jira llɨsiñede. ");
INSERT INTO huuNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Mare enɨruemo jɨaɨe iduaɨ juide. Sɨcode. Llɨsillamona danademo cien dɨga llɨsillana ote. Jɨaɨnamona sesenta dɨga llɨsillana ote. Jɨaɨnamona treinta dɨga llɨsillana ote. ");
INSERT INTO huuNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Omoɨ jeforena jira, raise fueollena, cue lluamo cacarei. Iena ɨɨno. ");
INSERT INTO huuNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ie llofueoicaigano Jesúmo jɨcanuaɨbisɨde: —¿Bue ñellena bie isoide rafuedo comɨnɨna llofuetɨo? ");
INSERT INTO huuNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Uai ote: —Jusiñamuidɨ omoɨna ie sedaacana rafuena jai uiñotade. Jaie iena uiñoñedomoɨ. Jɨaɨe comɨnɨna iena nia uiñotañede. ");
INSERT INTO huuNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Jusiñamuina ɨɨnotɨmɨe Jusiñamui rafuena ɨɨnocana jaite. Jusiñamui naimɨena uiñotaite; iadedɨ Jusiñamuina ɨɨnoñedɨmɨe Jusiñamui rafuena uiñoñecana jaite. ");
INSERT INTO huuNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ie jira bie isoidɨcɨnodo naimacɨmo llotɨcue. Cue siño fɨnoca rafuena cɨodɨmacɨ; iadedɨ iena naimacɨ ɨɨnoñena jira, uiñoñeno jaitɨmacɨ. Cue llofuiana jamai cacadɨmacɨ; iadedɨ naimacɨ ɨɨnoñena jira, raise cacaiñedɨmacɨ. Uiñoñedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Isaías mɨcorɨ naimacɨna jaie cuega rafue birui jai suide. Jaie raite: Jusiñamui llote: “Cue rafuena cacaitomoɨ; iadedɨ iena cacaiñeitomoɨ. Rafuena cɨoitomoɨ; iadedɨ iena uiñoñeitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Omoɨ comecɨaɨ jai taɨnomo ite isoide. Omoɨ jefona jai cacaiñedomoɨ isoidomoɨ. Cue rafuena jai cacaacaiñedomoɨ. Jai uisɨnidomoɨ isoidomoɨ. Siño rafuena jai cɨoiacaiñedomoɨ. Iena jai uiñoiacaiñedomoɨ. Cue dɨbeimo iacaiñedomoɨ, omoɨna cue jilloitai raillanona”. Isaías mɨcorɨ Jusiñamuina ɨɨnoñedɨnona iese jaie cuete; ");
INSERT INTO huuNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","iadedɨ bie siño rafuena birui omoɨ jai cɨua jira, cue lloga rafue omoɨ jai cacaja jira, iena birui omoɨ ɨɨnua jira, nɨ ua omoɨ marena ille jillacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Jusiñamui facaina jaie lloraɨnɨ mɨcorɨaɨ omoɨ siñona cɨua rafuena jaie cɨoacadɨmacɨ; iadedɨ cɨoiñedɨmacɨ. Iena cacaacadɨmacɨ; ia cacaiñedɨmacɨ. Jusiñamuina jaie ɨɨnotɨno mɨcorɨaɨ iena cɨoacadɨmacɨ; iadedɨ cɨoiñedɨmacɨ. Iena cacaacadɨmacɨ; iadedɨ cacaiñedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Jesús llote: —Ero, omoɨna trigo iduaɨna judaɨdɨmɨe rafuena llofueitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Dajerie iduaɨ naɨsomo juide. Dajerie comɨnɨ comecɨaɨ naie naɨso isoidɨmacɨ. Jusiñamuidɨ ie comɨnɨna sedaja rafuena cacadɨmacɨ; iadedɨ iena cacaiñedɨmacɨ. Ie jira Taɨfedɨ naimacɨ comecɨaɨmo cacaja uaina ɨɨnotañede. ");
INSERT INTO huuNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Jɨaɨe iduaɨ nofɨemo juide. Dajerie comɨnɨ comecɨaɨ naie nofɨe isoidɨmacɨ. Jusiñamui uai nano naimacɨ cacaia, iena caɨmare feiñotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Nofɨemo riga iduaɨ jainaonidedɨ raise sɨcoñede. Naie comɨnɨ janore ɨɨnua jira, ie isoidɨmacɨ. Dallu nano ɨɨnotɨmacɨ. Jusiñamui uai muidona duere naimacɨ sefuia, abɨdo danomo uaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Jɨaɨe iduaɨ eecuaɨ illanomo juide. Naie iduaɨ sɨcua mei, iena eecuaɨ ɨbailla jira, raise llɨsiñede. Dajerie comɨnɨ comecɨaɨ naie illano isoidɨmacɨ. Jusiñamui uaina cacadɨmacɨ. Ɨɨnotɨmacɨ; iadedɨ naimacɨ comecɨaɨ jarire illamona, naimacɨ raruiaɨna ebiruillamona, naie uai naimacɨ comecɨaɨmo itabiñede. Jusiñamui jitaille rafuena fɨnocana jaiñedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Jɨaɨe iduaɨ mare enɨruemo juide. Dajerie comɨnɨ comecɨaɨ naie enɨrue isoidɨmacɨ. Jusiñamui uaina cacajano, iena raise cacadɨmacɨ. Eo llɨside isoidɨmacɨ. Jusiñamui jitailla rafuena fɨnocana jaidɨmacɨ. Dajerie janore jaidɨmacɨ. Dajerie eo jaidɨmacɨ. Dajerie ua eo raise jaidɨmacɨ. Iese omoɨ jai. ");
INSERT INTO huuNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesús jɨaɨe rafuena llote: —Jusiñamui ie comɨnɨna sedaacana rafuena lloitɨcue. Naimɨe dɨbeimo comɨnɨ jaillena, naimɨe rafue llocana jaidɨcue. Jɨaɨe uaido iena omoɨmo lloitɨcue. Damɨe trigona judaɨaide. Ie illɨmo mare iduaɨna judaɨde. ");
INSERT INTO huuNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Naimɨe ɨnɨa mei, ie enoidɨmɨe trigona eruaɨde raitɨcɨaɨna bainino judaɨaide. Iemei oni jaide. ");
INSERT INTO huuNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Trigo sɨcuamona llɨside. Naie facaise naie raitɨcɨaɨ como raise bairede. ");
INSERT INTO huuNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Judaɨdɨmɨe maɨjɨraɨnɨ iena cɨuanona, naimɨemo llote: “Mare iduaɨ navui ritɨo. ¿Nɨesedeta raitɨcɨaɨ eo sɨcode?” ");
INSERT INTO huuNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Uai ote: “Cuena enoidɨmɨe iese fɨnoca”. Naie maɨjɨraɨnɨ naimɨemo jɨcanotɨmacɨ: “¿Birui nai raitɨcɨaɨ caɨ raitɨana jitaidɨo?” ");
INSERT INTO huuNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Uai ote: “Dama ite. Raitɨcɨaɨ omoɨ raitɨia, trigona jɨaɨ jaitaitomoɨ. Dama iesede. ");
INSERT INTO huuNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Danomo sɨcoite. Ua facaiseconi cue maɨjɨraɨnɨmo lloitɨcue: “Raitɨcɨaɨ nano jaita. Danomo ofita, jobaillesa. Trigo uanona, cue jofomo atɨanona, eeno”. ");
INSERT INTO huuNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesús jɨaɨe rafue llote: —Jusiñamui dɨbeimo comɨnɨ jailla rafuena lloitɨcue. Jɨaɨe uaido iena omoɨmo lloitɨcue. Damɨe mostaza idona rillamona, naiemona eo aillue riara sɨcode. ");
INSERT INTO huuNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Mostaza ido eo janorede; iadedɨ sɨcua mei, eo aillue riara jaillamona, nainomo silliñɨaɨ jɨcaicɨaɨna fɨnodɨmacɨ. Ie isoide. Jusiñamui rafuena janore comɨnɨ birui cacajamona, ailluena comɨnɨ naimɨe comɨnɨna ɨco jaitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jesús jɨaɨe rafuena llote: —Jusiñamui dɨbeimo comɨnɨ jailla rafuena lloitɨcue. Jɨaɨe uaido iena omoɨmo lloitɨcue. Daje cɨrɨgaɨ raifi coremo sɨritate ra faɨanona, namo tameia sɨritate. Ie isoide. Ailluena comɨnɨ iena cacaillena, Jusiñamui rafue llocana jaite. ");
INSERT INTO huuNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Naie isoide rafuedo Jusiñamui ie comɨnɨna sedaacana rafuena comɨnɨmo Jesús llote. Jɨaɨe rafuedo iena lloñede. ");
INSERT INTO huuNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Jusiñamui facaina lloraɨma mɨcorɨ iena jaie cuega: Jusiñamui llote: “Jɨaɨe isoide rafuedo comɨnɨmo lloitɨcue. Comɨnɨ nia uiñoñega rafuena lloitɨcue. Enɨrue fɨnua facaisemona jaca bu iena uiñoñede. Birui naimacɨ uiñollena, iena lloitɨcue”. ");
INSERT INTO huuNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Comɨnɨ jino faɨnonocaida, Jesús ie risoilla jofomo abɨdo jaide. Ie llofueoicaigano naimɨemo llotɨmacɨ: —Iena raise caɨ uiñollena, trigo motomo riga raitɨcɨaɨ rafuena caɨmo llono. ");
INSERT INTO huuNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Uai ote: —Mare iduaɨ judaɨdɨmɨedɨ cue. Jusiñamui rafuena llotɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Naie illɨdɨ nana comɨnɨ. Mare iduaɨdɨ Jusiñamuimo duide comɨnɨ. Raitɨcɨaɨdɨ Taɨfemo duide comɨnɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Naie maraiñede iduaɨ judaɨdɨmɨedɨ Taɨfe. Ua facaisedɨ cue abɨdo bille facaise. Trigo otɨnodɨ Jusiñamui jaɨenisaɨ. Trigodɨ cuena ɨɨnotɨno. ");
INSERT INTO huuNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Jobaillena raitɨcɨaɨ ofitaja isoi, ɨco abɨdo cue bia, daje isoi iite. ");
INSERT INTO huuNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Cue jaɨenisaɨna oretaitɨcue, nana jeacɨnona fɨnoraɨnɨ dɨese ofitallena, cue illanomona iraimo dotallena. ");
INSERT INTO huuNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Nainomo eo duere sefuillamona, eeitɨmacɨ. Subicaitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Iemei jitoma llɨgaiñua isoi, Jusiñamui sedajanomo naimɨena ɨɨnotɨnodɨ marena bairenitɨmacɨ. Omoɨ jeforena jira, raise fueollena, cue lluamo cacarei. Bie isoi omoɨ duere sefuiñellena, cue lluana ɨɨno. ");
INSERT INTO huuNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Jesús llote: —Jusiñamui dɨbeimo comɨnɨ jailla rafuena lloitɨcue. Jɨaɨe uaido iena omoɨmo lloitɨcue. Enɨruemo isiruiga raifide ra bu baia, ie nama jai iñena jira, naie enɨruena uainino ɨbaacade, naie ra ollena. Ucube ollena, naie rari iobilla jira, nana naimɨemo ite raruiaɨna fecaite. Iemei enɨruena ɨbaite. Ie isoide. Jusiñamui illanomo omoɨ illena, jɨaɨe rafue uanona jaiñeno. Danɨ Jusiñamui rafuena uanona jai. Danɨ iemo omoɨ comecɨaɨna faca. ");
INSERT INTO huuNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Jesús llote: —Jusiñamui dɨbeimo comɨnɨ jailla rafuena lloitɨcue. Iena omoɨ raise uiñollena, perlas railla rana ɨbaraɨmana lloitɨcue. Eo mare perlas ɨballena jenocabide. ");
INSERT INTO huuNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Eo raifide perla naimɨe baia, naie perlana ɨballena, nana ie raruiaɨna fecaite. Ie isoide. Jusiñamui ie comɨnɨna sedaacaja rafuena omoɨ cacaja jira, iena ocana jai. ");
INSERT INTO huuNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Jesús llote: —Jusiñamui dɨbeimo comɨnɨ jailla rafuena lloitɨcue. Iena omoɨ raise uiñollena, lloijina lloitɨcue. Joraimo lloijina comɨnɨ faɨanona, naga isoide llɨcɨaɨna otɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Arɨ sonua mei, mare llɨcɨaɨ dɨese fetodɨmacɨ. Maraiñede llɨcɨaɨ dɨese oni faɨtɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ie isoide. Ɨco abɨdo cue bia, iese iite. Jusiñamuina ɨɨnotɨnomona naimɨena ɨɨnoñedɨno dɨese oni fetollena, Jusiñamui jaɨenisaɨ biitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Iemei iraimo Jusiñamuina ɨɨnoñedɨnona dotaitɨmacɨ. Nainomo eo duere sefuillamona eeitɨmacɨ. Subicaitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ie llofueoicaiganomo Jesús jɨcanote: —¿Nana cue lluana cacadomoɨ? Uai otɨmacɨ: —Jɨɨ, nana cacadɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Naimacɨmo llote: —Ie jofomo comɨnɨ bia, naimacɨna raise nafuellena, naimacɨna caɨmare itatallena, jofo nama ie mare raruiaɨmona naimacɨ jitailla ra naimacɨmo fecade. Comɨnɨ comecɨaɨna llotɨcue. Jusiñamui facaina lloraɨnɨ mɨcorɨaɨ llogacɨnona uiñotomoɨ. Cuemona Jusiñamui ie comɨnɨna sedaja rafuena fueocana jɨaɨ jai jaidomoɨ. Comɨnɨ comecɨaɨna caɨmare itatallena, birui llofueredomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Naie rafuena Jesús llua mei, nainomona Nazaretmo jaide. ");
INSERT INTO huuNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ie enɨruemo rillanona, Nazaretmo ite ofiracomo llofuete. Naiemona comɨnɨdɨ raijicaillamona raitɨmacɨ: —¿Nɨese naimɨedɨ eo abɨna uiñote? ¿Nɨese siño rafuena naimɨedɨ fɨnode? Naimɨedɨ jamai bue isoidɨmɨe. ");
INSERT INTO huuNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Naimɨe amederaɨma jito. Naimɨe eidɨ María. Naimɨe amatɨaɨdɨ Jacobo, José, Simón, Judas. ");
INSERT INTO huuNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Naimɨe mirɨñotɨaɨdɨ caɨ motomo jɨaɨ ite. Naimacɨ dɨga nagarui nabairitɨcaɨ. Naimɨeori caɨ nabairicabilla. Ie jira, ¿nɨnena ie siño uaina ote? ");
INSERT INTO huuNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","“Caɨ comena naimɨe ite” raillanona, naimɨe uaina jamaidɨmacɨ. Jesús naimacɨmo llote: —Naga illanomo comɨnɨdɨ Jusiñamui facaina lloraɨma uaina feiñotɨmacɨ; iadedɨ naimɨe naɨraɨmo naimɨe ia, ie risoilla jofomo naimɨe ia, ie comɨnɨ naimɨe uaina feiñoiacasɨñede. Jamaisɨte. Ie isoide. Cue comɨnɨdomoɨna jira, cue uaina ɨɨnoñedomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Naimɨe uaina naimacɨ ɨɨnoñena jira, Jesús ailluena siño rafue fɨnoñede. ");
INSERT INTO huuNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Naie facaiseconi Herodes railla gobernador Jesús mamecɨna cacade. ");
INSERT INTO huuNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Naimɨe ecɨmo maɨjɨuidɨnomo llote: —Fiodaillamona Juan Bautista mɨcorɨ jai jillode. Jesús raillamɨedɨ naimɨe. Ie jira naimɨedɨ siño rafuena fɨnocabide. ");
INSERT INTO huuNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Iese raite, Herodes Juan mɨcorɨna navui meinetaja jira. Juan Bautista mɨcorɨna nia meinetañenia, Herodedɨ ie ama Felipe aɨna ote. Naiñaiño mamecɨdɨ Herodías. Ie jira Juan mɨcorɨ naimɨemo llote: —O ama aɨ dɨga itɨo. Maraiñede rafuena fɨnodɨo. Jusiñamui iena rairuide. Herodes Juan mɨcorɨ lluana gaɨñenano, naimɨena duere fɨnode. Herodes Juan mɨcorɨna gaɨtatajanona, cárcelmo jonetade. ");
INSERT INTO huuNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Naimɨe mɨcorɨna meinetaacade; iadedɨ Herodes dɨnena comɨnɨna jacɨruite. Juan mɨcorɨdɨ Jusiñamui facaina lloraɨmana naimacɨ raillanona, naimɨe mɨcorɨna jacɨruite. ");
INSERT INTO huuNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Iemei Herodes cumpleaños ie rafuena fɨnode. Nainomo jɨaɨe comɨnɨna uaidote. Rafuemo Herodías jisa naimacɨ uicomo saillamona, Herodena iobitade. ");
INSERT INTO huuNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ie jira naiñaiñomo llote: —Nɨe isoide rana o jitaiadedɨ, omo iitɨcue. Illaɨma uai cuemo illa jira, iena ua fɨnoitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Naiñaiño ei naiñaiñomo lluanona, naiñaiño uai ote: —Juan Bautista ɨfogɨ bandejamo jonecaida, cuemo ine. ");
INSERT INTO huuNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Iena cacajano, naimɨe sunaite; iadedɨ naimɨe jino ie llua uaina jira, nainomo naimɨe uaidogano jɨaɨ jai cacaja jira, Juan mɨcorɨna meinetajana llote. ");
INSERT INTO huuNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ie lloga uaina fɨnollena, cárcelmo soldadona orede. Nainomo Juan mɨcorɨ ɨfogɨna jaitade. ");
INSERT INTO huuNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Bandejamo naimɨe mɨcorɨ ɨfogɨ jonecaida, soldado atɨano, Herodías jisamo fecade. Ieconi ie eimo fecade. ");
INSERT INTO huuNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Iena fɨdɨanona, Juan mɨcorɨ llofueoicaigano naimɨe mɨcorɨ abɨna uaɨbitɨmacɨ. Iena naimacɨ raɨa mei, Jesúmo lluaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Juan mɨcorɨ meiniana Jesús fɨdɨano, nainomona comɨnɨ iñenanomo ie llofueoicaigano dɨga botedo jaide; iadedɨ naimɨe jaillana comɨnɨ fɨdɨano, naimɨena racadɨmacɨ. Dɨga comɨnɨ illanuaɨmona eɨllɨdo bitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Enɨruemo Jesús sɨjɨia, ailluena comɨnɨna dafaɨfide. Naimacɨna cɨuanona, naimacɨna duenaillanona, duidɨnona jillotate. ");
INSERT INTO huuNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Jitoma ana itemo, ie llofueoicaigano naimɨe dɨne lluaɨbitɨmacɨ. Raitɨmacɨ: —Jofue bene iñede. Jaca buedɨ iñede. Jai navuiacade. Comɨnɨna mai abɨdo oreta. Ianori ite naɨraɨmo naimacɨ guille ollena, naimacɨna oreta. ");
INSERT INTO huuNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Uai ote: —Naimacɨna oretañeitɨcue. Naimacɨna omoɨ eca. ");
INSERT INTO huuNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Uai onaisɨte: —Danɨ caɨmo ite cinco llomenico, mena llɨcɨaɨ dɨga. ");
INSERT INTO huuNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Uai ote: —Iena cuemo atɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Raitɨe illanomo comɨnɨ ana raɨllesa llono —raite. Naie cinco llomenicona naie mena llɨcɨaɨ dɨga uanona, monamo eruaɨllanona, Jusiñamuimo iobillacɨnona fecade. Iemei taɨllude. Ie llofueoicaiganomo fecade, comɨnɨna ecallena. ");
INSERT INTO huuNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Nana guillanona monidɨmacɨ. Monillamona, fɨebide guillena ɨraɨdɨmacɨ. Doce cɨrɨgaɨaɨmo oruitatɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Cinco mil ɨiñɨaɨ dɨese guitɨmacɨ. Naimacɨ aɨtɨaɨ jɨaɨ guitɨmacɨ. Naimacɨ uruiaɨ jɨaɨ guitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Guilla mei, botedo ie llofueoicaigano ruica dɨne jaillena llote. Naie facaiseconi naimɨe comɨnɨna nia facadote. ");
INSERT INTO huuNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Comɨnɨna facadua mei, aneduaɨmo dane jaide, Jusiñamui dɨga ñaɨllena. Jitɨbicaidemo nainomo dama ite. ");
INSERT INTO huuNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Naie facaiseconi ie llofueoicaigano jorai motomo itɨmacɨ. Aɨfɨ billamona, eo bagode. Naimacɨmo rɨire aɨfɨ rilla jira, rɨire jaɨtɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Nia monaiñedemo, jɨnui emododo naimacɨ dɨne Jesús bite. ");
INSERT INTO huuNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Naimɨena naimacɨ cɨuanona, jacɨnaillamona, raitɨmacɨ: —¿Bu joreño caɨmo billana cɨodɨcaɨ? —Jacɨnaillamona cuiriidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Naie dacaiño Jesús naimacɨmo llote: —Omoɨ joreñonicaiñeno. Cuesa. Jacɨruiñeno. ");
INSERT INTO huuNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pedro uai ote: —Uanai caɨ Namadɨo. O dɨne cue billesa cuemo llono. ");
INSERT INTO huuNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jesús uai ote: —Cue dɨne bi. —Ie jira botemona jɨnui emodo Jesús dɨne Pedro macarite; ");
INSERT INTO huuNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","iadedɨ aɨfɨ billana naimɨe cɨuanona, jacɨnaite. Jɨnuimo anabaiacade. Ado cuirioide: —Nama, cuena cano. ");
INSERT INTO huuNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Jesús ie onollɨ oni ñuitajanona, naimɨena llɨnuanona, raite: —Eo janore cue uaina ɨɨnotɨo. ¿Bue ñellena eo ɨɨnoñedɨo? Cuena ɨɨnotɨodena, jɨnui emododo cue dɨne niadedɨ ridɨo. ");
INSERT INTO huuNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Botemo a iaɨmaiaɨ jaillamona, ie facaise aɨfɨ llɨɨcaide. ");
INSERT INTO huuNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ie jira botemo itɨno Jesúmo iobillacɨnona fecadɨmacɨ. —Odɨ ua Jusiñamui Jitodɨo —raitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ruica dɨne jaillanona, Genesaret railla enɨruemo ridɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Jesúna nainomo itɨno uiñuamona, naimɨe dɨne duidɨnona atɨllena, nana naɨraɨmo jɨaɨe comɨnɨna oredɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Naimɨe dɨne billanona, danɨ ie ɨniroi fuedamo jutadallena naimɨemo jɨcanotɨmacɨ. “Naimɨe ɨniroimo caɨ jutadallemona jilloitɨcaɨ” raillamo comecɨaɨna facadɨmacɨ. Nana jutadate dɨese jillodɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Jerusalémona fariseuaɨ comɨnɨ Jesús dɨne bitɨmacɨ. Moisés mɨcorɨ llogacɨnona llofueraɨnɨ jɨaɨ bitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Naimɨemo jɨcanotɨmacɨ: —¿Bue ñellena o llofueoicaigano caɨ einamacɨ rafuedo jaiñedɨmacɨ? Naimacɨ guiacania, naimacɨ onollɨ caɨ einamacɨ llua isoi raise jocoñedɨmacɨ. Ie jira caɨ abɨmo jeacɨno fɨnodomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jesús uai ote: —¿Bue ñellena nana Jusiñamui llogacɨnodo jaiñedomoɨ? Omoɨ einamacɨ llogacɨnodo jaidomoɨ; iadedɨ nana Jusiñamui llogacɨnodo raise jaiñedomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Jusiñamui jaie llote: “O moo uai ɨɨnuanona, naimɨena cano. O ei uai ɨɨnuanona, naiñaiñona cano. Ie moori jeare ñaɨtɨmɨe, ie eiri jeare ñaɨtɨmɨe meinelle”. ");
INSERT INTO huuNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Iese Jusiñamui llote; iadedɨ omoɨ einamacɨ llotɨmacɨ: “Jusiñamuimo caɨ ucubena caɨ fecajamona, caɨ moona, caɨ eina jai canonidɨcaɨ”. ");
INSERT INTO huuNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Iese omoɨ fɨnocabilla jira, omoɨ einamacɨ llogacɨnodo omoɨ jaillamona, Jusiñamui uaina jamaidomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Mareuidɨnona abɨ caitauidɨnodomoɨ. Isaías mɨcorɨ omoɨna jaie raise llote. Naimɨedɨ Jusiñamui lluana cuete: ");
INSERT INTO huuNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Bimacɨ naimacɨ uaido marecɨnona cuemo llote; iadedɨ cue rafuedo raise jaiacaiñedɨmacɨ. “Ona isiruitɨcaɨ” llotɨmacɨ. “Ona sedadɨcaɨ” llotɨmacɨ. Jamai ñaɨtɨmacɨ. Naimacɨ comecɨaɨ cue dɨbeimo raise iñede. ");
INSERT INTO huuNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Cue uai itena, jamai comɨnɨ lluacɨnona naimacɨ llofuecabilla jira, taɨnona cuena sedadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Fariseuaɨ dɨga iese llua mei, naimɨe ecɨmo ailluena comɨnɨ dane ofillanona, naimacɨmo llote: —Iena raise omoɨ uiñollena, cue lluamo cacarei. ");
INSERT INTO huuNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Omoɨ einamacɨ isoi omoɨ guiñenia, naimacɨ isoi omoɨ onollɨna omoɨ jocoñenia, omoɨ comecɨaɨna jearetañedomoɨ. Omoɨ guigamona, omoɨ onollɨna jocuamona, Jusiñamuina nabaiñedomoɨ. Omoɨmo jeacɨno illa jira, Jusiñamuina nabaiñedomoɨ. Omoɨ comecɨaɨ jearena jira, jeacɨnona fɨnocabidomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ie llofueoicaigano naimɨemo lluaɨbitɨmacɨ: —O llua muidona, fairseuaɨ comɨnɨna icɨdɨo. ");
INSERT INTO huuNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Naimɨe dɨnena uai ote: —Dama ite. Nana cue Moomona oñega rafuedɨ jai ieconi duite. Naimacɨ rafue cue Moomona oñenia, ja muidomo ieconi duite. ");
INSERT INTO huuNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Naimacɨna faɨnonocai. Uanaicɨnona naimacɨ uiñoñena jira, uisɨnidɨno isoidɨmacɨ. Jɨaɨmɨena uisɨnidɨmɨe ɨfoia, dafomo uaidɨaɨmaiaɨ. Ie isoide. Uanaicɨnona fariseuaɨ uiñoñena jira, uanaicɨnona llofuenidɨmacɨ. Uanaicɨnodo jaiñedɨmacɨ. Ja muidomo faɨfitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pedro naimɨemo llote: —Aillɨnano o llua caɨmo raise llono. ");
INSERT INTO huuNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Uai ote: —¿Nɨese cue lluana jɨaɨ nia cacaiñedomoɨ? ");
INSERT INTO huuNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Nɨe isoide ra guitomoɨna, omoɨ jebemo jaide. Ie mei omoɨ abɨaɨmona jino bite; ");
INSERT INTO huuNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","iadedɨ omoɨ comecɨaɨmo itɨcɨnomona jearedena ñaɨtomoɨ. Omoɨ comecɨaɨ jearena jira, jearede rafuena fɨnocabidomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Omoɨ comecɨaɨ jearena jira, jeare comecɨaɨna facacabidomoɨ. Comena meinecabitomoɨ. Omoɨ aɨñede rɨño dɨga icabitomoɨ. Omoɨ ɨniñede ɨima dɨga icabitomoɨ. Fɨɨricabitomoɨ. Taɨnona llogɨricabitomoɨ. Jɨaɨe comɨnɨ joreñona jeare ñaɨcabitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Bie isoidɨcɨnuaɨ omoɨ comecɨaɨmo illa jira, jearede rafuena fɨnocabidomoɨ; iadedɨ omoɨ einamacɨ llua isoi, omoɨ onollɨ jocoñenamona jeacɨno comuiñede. ");
INSERT INTO huuNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Genesaret railla enɨruemona ie llofueoicaigano dɨga Jesús jaillanona, Tiro railla enɨruemo jaide. Sidón railla enɨruemo jɨaɨ jaide. ");
INSERT INTO huuNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ie facaiseconi naie enɨruemona judíuñedɨñaiñodɨ billanona, raite: —Maestro, David mɨcorɨ jitodɨo. Jusiñamuimona o billa jira, cuena duenai. Cue jisa Janaba anamo ite. Naiñaiño eo duere sefuicabide. ");
INSERT INTO huuNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Jesús uai oñede. Ie jira ie llofueoicaigano naimɨe dɨne billanona, duere llote: —Naiñaiñona abɨdo ie jofomo oreta. Caɨmo duere jɨcanuaɨbitesa. ");
INSERT INTO huuNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jesús uai ote: —Faɨficana jaillana naimacɨ jai jailla jira, danɨ caɨ judíuaɨ comɨnɨmo cue Moo cuena oretate. Naimɨedɨ judíuñedɨñaiñomo cuena oretañede. ");
INSERT INTO huuNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ie facaise naimɨe dɨne naiñaiño billanona, naimɨemo iobillacɨnona fecallena, caiñɨcɨ ɨfodo ana raɨnada raite: —Maestro, cuena cano. ");
INSERT INTO huuNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Judíuaɨñedɨnona naimɨe canoñenana naiñaiño uiñollena, naiñaiñomo Jesús llote: —Uruiaɨ guillamona jɨconɨaɨna ecadɨcaɨdena, maraiñede. ");
INSERT INTO huuNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Naiñaiño dɨnena uai ote: —Jɨɨ, maestro; iadedɨ jɨconɨaɨdɨ imacɨ nama guillamona fɨebide guillemona guitɨmacɨ. —Iese llote; ia jɨaɨe rafuemo comecɨna facade. Uruiaɨna llote; iadedɨ judíuaɨmo comecɨna facade. Jɨconɨaɨna llote; ia judíuaɨñedɨnomo jɨaɨ comecɨna facade. Comecɨna facade: “O comɨnɨmo o rafue duide; ia caɨ Namana o illa jira, nɨbaɨ o rafue caɨmo janore duide”. ");
INSERT INTO huuNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Jesús uai ote: —Cue uaina o ɨɨnua jira, o jitailla rafuena fɨnoitɨcue. —Ieconi naiñaiño jisa jillode. Janaba naiñaiñomona oni jaide. ");
INSERT INTO huuNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Nainomona Jesús baɨ jaillanona, Galilea railla jorai fuedo jaide. Iemei aneduaɨmo jaillanona, nainomo ana raɨde. Nainomo rilla mei, ");
INSERT INTO huuNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","ailluena comɨnɨ naimɨe dɨne bitɨmacɨ. Ailluena duidɨnona atɨdɨmacɨ. Ñuja-ñujacaida macaritɨnona, onollɨna ɨdɨsaruaɨdɨnona, uisɨnidɨnona, uainidɨnona atɨdɨmacɨ. Dɨga duidɨnona naimɨe dɨne atɨdɨmacɨ. Iemei naimacɨna jillotate. ");
INSERT INTO huuNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Aillɨ uainidɨno jai ñaɨana cacajamona, aillɨ onollɨna ɨdɨsaruaɨdɨno onollɨ jai marenana illana cɨuamona, aillɨ ñuja-ñujacaidɨno macaritɨno jai marena macarillana cɨuamona, aillɨ uisɨnidɨno jai cɨuana cɨuamona, nainomo ite comɨnɨ eo raijicaidɨmacɨ. Caɨ Jusiñamuimo iobillacɨnona fecadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jesús ie llofueoicaigano naimɨe dɨne uaiduanona, raite: —Bie comɨnɨ darui amani bene cue dɨga illa jira, naimacɨmo guille jai iñede. Naimacɨna aimeri oretaiacaiñedɨcue, naɨsomo naimacɨ baɨi raillanona. Naimacɨna cue duenailla jira, naimacɨna canoacadɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Jɨcanotɨmacɨ: —¿Nɨnomona guille oitɨcaɨ, naimacɨna caɨ ecallena? Ailluena comɨnɨ ite; iadedɨ jofue iñenanomo itɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesús jɨcanote: —¿Nɨga llomenico omoɨmo ite? Uai otɨmacɨ: —Siete. Janorede llɨcɨsɨrɨaɨ caɨmo jɨaɨ ite. ");
INSERT INTO huuNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Comɨnɨ ana raɨllena Jesús llote. ");
INSERT INTO huuNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Naie llomenico llɨcɨsɨrɨaɨ dɨga uanona, Jusiñamuimo iobillacɨno fecade. Taɨlluanona, ie llofueoicaiganomo fecade, naie comɨnɨmo fecallena. ");
INSERT INTO huuNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Nana guitɨmacɨ. Monidɨmacɨ. Monillamona, fɨebide guillena ɨraɨdɨmacɨ. Siete cɨrɨgaɨaɨmo oruitatɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Nainomo cuatro mil ɨiñɨaɨ guitɨmacɨ. Naimacɨ aɨnɨaɨ jɨaɨ guitɨmacɨ. Naimacɨ uruiaɨ jɨaɨ guitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Iemei comɨnɨna naimacɨ jofuemo orede. Naimacɨna oretaja mei, botedo Magdala railla enɨruemo Jesús jaide. ");
INSERT INTO huuNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Dajerie fariseuaɨ comɨnɨ Jesús dɨne bitɨmacɨ. Naimɨena facacɨllena, dajerie saduceuaɨ comɨnɨ jɨaɨ bitɨmacɨ. Siño rafuena naimɨe fɨnuana jɨcaacadɨmacɨ. Iena naimɨe fɨnoñedena, naimɨe ie llua isoi iñenana uiñoitɨmacɨ. Naimɨena duere fɨnoacadɨmacɨ. Llotɨmacɨ: —Iena caɨ cɨoillena, Jusiñamuina siño rafuena fɨnota. ");
INSERT INTO huuNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Jesús uai ote: —Jitoma sojicaidemo, mona jiaɨrenia, raitomoɨ: “Ɨco are maremonanite”. ");
INSERT INTO huuNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Jɨaɨ raitomoɨ: “Jitɨramo mona jiaɨrenia, ja nocɨ deite”. Monamo omoɨ eruaɨllamona, marena monaillana uiñotomoɨ; iadedɨ birui cue fɨnoca rafuena raise uiñoiacaiñedomoɨ. Omoɨ motomo birui suide rafuena raise cacaiñedomoɨ. Abɨna uiñotɨnona abɨ caitadomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Jeacɨnona fɨnocabidomoɨ. Jusiñamui dɨbeimo raise iacaiñedomoɨ. Siño rafuena fɨnoñeitɨcue. Jonás mɨcorɨmo jaie suide rafuena uiñotomoɨ. Jusiñamui naimɨemo siño rafuena fɨnode. Naiemo comecɨaɨna omoɨ faca. Fiodaillamona naimɨe jillode. Ie isoi cue jɨaɨ jilloitɨcue. —Ie llua mei, naimacɨmona Jesús ie llofueoicaigano dɨga oni jaide. ");
INSERT INTO huuNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ruica dɨne naimacɨ rillanona, ie llofueoicaigano llomenicona feillana uibiñotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Iena naimɨe uiñuamona, naimacɨmo Jesús llote: —Fariseuaɨ sɨritate ramona abɨna rairui. Saduceuaɨ sɨritate ramona abɨna rairui. —Iese Jesús llote; iadedɨ naimacɨ llofuiacɨnomona abɨ rairuillena ñaɨte. ");
INSERT INTO huuNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Jesús iese llua jira, iena naimacɨ raise cacaiñena jira, danɨ coninɨri siadotɨmacɨ: —Llomenicona caɨ atɨñena jira, caɨmo iese llote. ");
INSERT INTO huuNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Naimacɨ siaduana Jesús uiñua jira, naimɨe lluana naimacɨ nia raise cacaiñena jira, naimacɨmo llote: —Cue uaina nia raise ɨɨnoñedomoɨ. Omoɨna canoredɨcue. ¿Bue ñellena danɨ omoɨ llomenico iñenana siadotomoɨ? ");
INSERT INTO huuNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Nɨese ɨɨnoñedomoɨ? ¿Nɨese cue navui siño fɨnoca rafuemo comecɨaɨna facañedomoɨ? Navui cinco mil ɨiñɨaɨ cinco dɨganicodemo guitɨmacɨ. Monillamona, guigamona fɨebillamona, doce cɨrɨgaɨaɨmo ɨraɨdomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Jɨaɨcaiño cuatro mil ɨiñɨaɨ siete dɨganicodemona guitɨmacɨ. Monillamona guigamona fɨebillamona, siete cɨrɨgaɨaɨmo ɨraɨdomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Omoɨna cue ecallena, ¿nɨese cuena birui ɨɨnoñedomoɨ? Llomenicona aillɨ ñaɨñedɨcue. Fariseuaɨ sɨritate ramona abɨna rairuillena ñaɨtɨcue. Saduceuaɨ sɨritate ramona abɨna rairuillena ñaɨtɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ie facaise naimɨe lluana jai cacadɨmacɨ. Llomenico sɨritate rana naimɨe ñaɨñede; iadedɨ fariseuɨ llofuiacɨnomona naimacɨ abɨna rairuillena ñaɨte. Saduceuaɨ llofuiacɨnomona naimacɨ abɨna rairuillena ñaɨte. ");
INSERT INTO huuNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Cesarea Filipo railla enɨruemo Jesús jaidemo, ie llofueoicaiganomo jɨcanote: —¿Nɨese jɨaɨe comɨnɨ cuena raitɨmacɨ? ");
INSERT INTO huuNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Uai otɨmacɨ: —Damɨerie raitɨmacɨ: “Odɨ Juan Bautista mɨcorɨdɨo”. Damɨerie raitɨmacɨ: “Odɨ Elías”. Jɨaɨno raitɨmacɨ: “Jeremías mɨcorɨdɨo”. Jɨaɨno raitɨmacɨ: “Jusiñamui facaina lloraɨma mɨcorɨdɨo”. ");
INSERT INTO huuNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Jesús dane jɨcanote: —¿Nɨese omoɨ cuena raitomoɨ? ");
INSERT INTO huuNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Pedro uai ote: —Odɨ caɨ Jilloitaraɨmadɨo. Cristodɨo. Jusiñamui facaina lloraɨnɨ mɨcorɨaɨ o billena jaie llotɨmacɨ. Caɨ cajede Jusiñamui Jitodɨo. ");
INSERT INTO huuNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jesús dɨnena uai ote: —Simón Pedro, Jonás jitodɨo. Marena llotɨo. Comɨnɨ ona iena uiñotañede; iadedɨ cue Moo Jusiñamui ona iena uiñotade. ");
INSERT INTO huuNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Pedro, o comecɨna uiñotɨcue. Cuena como o lloga uaina meidoñeitɨo. Bie rafuena jɨaɨe comɨnɨmo o lluamona, jɨaɨ ɨɨnoitɨmacɨ. Cuena ɨɨnuamona, cue comɨnɨna jaitɨmacɨ. Cue dɨbeimo iñedɨno iena itatanidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ailluena comɨnɨmo Jusiñamui ie comɨnɨna jailla rafuena nano lloraɨmana jaitɨo. O lluacɨnodo jaitɨno cue comɨnɨna jaitɨmacɨ. O lluacɨnodo jaiñeitɨno cue comɨnɨna jaiñeitɨmacɨ ");
INSERT INTO huuNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Iena llua mei, ie llofueoicaiganona rairuide: —Cue Cristonana bumo nia lloñeno. ");
INSERT INTO huuNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Naie facaisemona ie llofueoicaiganomo Jerusalémo naimɨe jaillena marefodo llote: —Nainomo caɨ judíuaɨ illaɨcomɨnɨ cuena eo duere fɨnoitɨmacɨ. Cuena meineitɨmacɨ; iadedɨ darui amani illanona, fiodaillamona jilloitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pedro dɨnena lletade: —Nama, ¡Jusiñamui iena jitaiñede! Bie isoide rafue omo suiñeite. ");
INSERT INTO huuNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jesús jɨnafo dɨne naimɨemo erodate. Raite: —Cuemona oni jai. Iese ñaɨñeno, Taɨfe isoi o comecɨna o facaja jira. Jusiñamui isoi cuemo comecɨna facañedɨo. Comɨnɨ isoi cuemo comecɨna facadɨo. Iese o comecɨna facañeno. ");
INSERT INTO huuNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ie llofueoicaiganomo llote: —Cue comɨnɨna bu jaiacania, ie jitaille rafuedo jaiñena. Cue dɨbeimo naimɨe jaillamona, duere sefuicana jaite. Nɨbaɨ naiemona fiodaite. Bu iese jaiacania, cue dɨbeimo naimɨe iite. ");
INSERT INTO huuNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Duere sefuillana jacɨruillamona cue comɨnɨna bu jaiacaiñenia, ja muidomo faɨfite; iadedɨ duere sefuillana jacɨruiñenamona cue comɨnɨna bu jaia, jaca faɨfiñeite. ");
INSERT INTO huuNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Cue comɨnɨna bu jaiñenia, nɨbaɨ eo duere sefuiñeite. Nɨbaɨ ailluena ra naimɨemo iite; ia, ¿nɨese cue Moo dɨne riite? Nainomo naimɨe riñeno faɨfite. ");
INSERT INTO huuNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Cue jaɨenisaɨ dɨga cue Moo dɨnena monamona ɨco biitɨcue. Cue Moo uai cuemo illanona, ebirena biitɨcue. Nagamɨe imacɨ fɨnoca rafue dɨese cue ɨba ollena biitɨcue. Cue comɨnɨñedɨnona duere fɨnoitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Uanaicɨnona omoɨmo lloitɨcue. Omoɨmona dajerie nia fiodaiñeitomoɨmo, illaɨmana cue bairellena cɨoitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Seis dɨgarui illanona, anedumo comɨnɨ iñenanomo Jesús jaide. Naimɨe dɨga jaillena, Pedrona uite. Jacobona jɨaɨ uite. Jacobo ama, Juan, jɨaɨ uite. Jɨaɨe llofueoicaiganona uiñede. ");
INSERT INTO huuNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Nainomo rilla mei, naimacɨ uicomo naimɨe abɨ meidocaide. Jitoma isoi naimɨe uieco bairecaide. Naimɨe ɨniroi naie dacaiño eo userecaide. ");
INSERT INTO huuNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Naie facaise naimacɨmo Moisés mɨcorɨ joreño, Elías dɨga bairede. Elíadɨ Jusiñamui facaina jaie lloraɨma. Jesús dɨga ñaɨtɨiaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Jesúmo Pedro llote: —Nama, bene caɨ illana mare. O jitaia, daje amani bɨsaini fɨnoitɨcue. Daje oue; jɨaɨe Moisés mɨcorɨ ie; jɨaɨe Elías ie. ");
INSERT INTO huuNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Iena naimɨe nia lluanona, quenirede uillɨe billanona, naimacɨna ɨbaide. Uillɨe motomona Jusiñamui naimacɨmo llote: —Bimɨe cue isiruiga Jito. Naimɨeri iobidɨcue. Naimɨe lluamo cacareillanona, iena ɨɨno —llote. ");
INSERT INTO huuNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Jesús llofueoicaigana iena cacajanona, eo jacɨruillanona, naimacɨ uieco dɨnena ana bɨtadatɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jesús naimacɨ dɨne billano, naimacɨna jetajanona, raite: —Mai jacɨruiñeno naidacai. ");
INSERT INTO huuNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Naimacɨ erorillamona, dama Jesúna cɨodɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Anedumona bitɨmacɨmo, naimacɨmo Jesús llote: —Omoɨ aillɨ cɨua rafuena bumo lloñeno, cue fiodaillamona cue jillua dɨnori. ");
INSERT INTO huuNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Naimɨemo llotɨmacɨ: —Moisés mɨcorɨ llogacɨnona llofueraɨnɨ birui raicabitɨmacɨ: “Elías raillamɨe dane biite. Ie mei caɨ Jilloitaraɨma biite” raitɨmacɨ. Jusiñamuimona o billana ɨɨnotɨcaɨ. Odɨ caɨ Jilloitaraɨmana ɨɨnotɨcaɨ. Odɨ caɨ Jilloitaraɨmadɨomo, ¿bue ñellɨ iese raitɨmacɨ? ");
INSERT INTO huuNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Uai ote: —Raise ɨɨnotomoɨ. Elías isoidɨmɨe jai bite, nana Jusiñamui jitailla rafue raise llollena. Jusiñamui dɨbeimo naimacɨ illena, comɨnɨ imacɨ comecɨaɨ meiduana llote. ");
INSERT INTO huuNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ero, naimɨe jai bite; iadedɨ bie comɨnɨ naimɨena raise uiñoñedɨmacɨ. Naimacɨ jitailla jira, naimɨena jai meinetɨmacɨ. Ie isoide. Naimacɨmona duere sefuitɨcue. Monamona bitɨcue, ɨimana cue jaillena; iadedɨ duere sefuitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ie muidona Jesús llofueoicaigano naimɨedɨ Juan Bautista mɨcorɨna ñaɨana jai uiñotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ie jɨaɨe llofueoicaigano dɨne Jesús abɨdo ria, nainomo ailluena comɨnɨ itɨmacɨmo ride. Jesús dɨne damɨe billanona, naimɨena raise uaiduanona, caiñɨcɨ ɨfodo raɨnadacaida raite: ");
INSERT INTO huuNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Maestro, cue jitona duenai. Janaba anamo naimɨe ite. Iemona naɨllicabide. Duere sefuide. Uai-uaicabide. Jɨaɨcaiñodedɨ iraimo uaillanona, uside. Jɨnuimo jɨaɨ uaillanona, niadedɨ corobaite. ");
INSERT INTO huuNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Naimɨena jilloitallena o llofueoicaigano dɨne naimɨena atɨdɨcue; iadedɨ naimɨena jillotanidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Iena cacajanona, Jesús ie llofueoicaiganomo llote: —Cue uai siñonana nia ɨɨnoñedomoɨ. Cue mare rafuedo nia raise jaiacaiñedomoɨ. Omoɨ dɨga are itɨcue. Raise omoɨ ɨɨnollena, ¿nɨe dɨnori omoɨ dɨga iitɨcue? Naie duidɨmɨe moomo llote: —O jito cue dɨne mai atɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Naimɨena atɨamona, Jesús naimɨemo Janaba illana uiñote. Janabana Jesús lletaja jira, naie uruemona Janaba oni jaide. Ieconi naie urue jillode. ");
INSERT INTO huuNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ie mei ie llofueoicaigano Jesúmo anado jɨcanotɨmacɨ: —¿Bue ñellena Janabana oni oretanidɨcaɨ? ");
INSERT INTO huuNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Uai ote: —Raise nia omoɨ ɨɨnoñena jira, uanaicɨnona omoɨmo lloitɨcue. Janaba oni oretallena, cue uai navui omoɨmo itɨcue. Birui raise cuena omoɨ ɨɨnoñenia, bie Janaba oni oretanidomoɨ. Jusiñamuina eo janore ɨɨnotomoɨdena, dɨga rana fɨnodomoɨ. “Oni baɨ jai” bie anedumo llotomoɨdena, omoɨna naimɨe canuamona, bie anedu oni llɨaɨ baɨ jaite. Jusiñamuina omoɨ ɨɨnoia, naga rana fɨnoredomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Jusiñamuimo omoɨ comecɨaɨna facallena omoɨ guiñenamona, Jusiñamui dɨga omoɨ ñaɨamona, bie isoide Janabana oni oretaredomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Galileamo ie llofueoicaigano dɨga danomo itemo, Jesús naimacɨmo llote: —Monamona billanona, ɨimana jaidɨcue. Jusiñamui jitailla jira, cuena jɨaɨe comɨnɨ gaɨtajanona, illaɨcomɨnɨmo fecaitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Naie illaɨcomɨnɨ cuena meineitɨmacɨ; iadedɨ darui amani illamona, cue Moo cuena jillotaite. —Iena cacajanona, ie llofueoicaiganodɨ sunaitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Capernaumo naimacɨ rilla mei, Jusiñamui jofo ucube oraɨnɨ Pedro dɨne jɨcanuaɨbite: —Moisés mɨcorɨ llua isoi, ¿o llofueraɨma Jusiñamui jofomo ucubena fecacabide? ");
INSERT INTO huuNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pedro dɨnena uai ote: —Jɨɨ, fecacabide. —Ucube oraɨnɨ jailla mei, jofomo Pedro billanona, Jesúmo iena nia lloñedemo, Jesús dɨnena naimɨemo jɨcanote: —Simón Pedro, ¿nɨese o comecɨna raitɨo? ¿Bumona illaɨcomɨnɨdɨ imacɨ ucubena ocabitɨmacɨ? Imacɨ jitonɨaɨmona ocabiñedɨmacɨ; ia naimacɨmo duide comɨnɨmona otɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Uai ote: —Raise llotɨo. Naimacɨmo duide comɨnɨmona ocabitɨmacɨ. Ie jira Jesús raite: —Naimacɨ jitonɨaɨna ɨbatañede. Ie isoide. Naie ucube Jusiñamui jofomo comɨnɨ fecajamona, Jusiñamuimo duide. Jusiñamui Jitona cue illa jira, naimɨe jofo facaina naimɨe cuena ɨbatañede; ");
INSERT INTO huuNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","iadedɨ Jusiñamui jofo ucube oraɨnɨna coco icɨñellesa, ucubena jenuai. Joraimo aɨmajaitɨosa jai. Nano o olle llɨcɨaɨ fuena jɨbui. Nainomo ucubena baitɨo. Iena uanona, Jusiñamui jofomo coco facaina feca. —Pedro iena fɨnode. ");
INSERT INTO huuNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Naie facaiseconi naimɨe dɨne ie llofueoicaigano jɨcanuaɨbitɨmacɨ: —Jusiñamui ie comɨnɨna sedajanomo ɨco caɨ ia, ¿bu caɨ moto imɨena ille? ");
INSERT INTO huuNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Iena cacajanona, Jesús daje urue uaiduanona, naimacɨ motomo jonete. ");
INSERT INTO huuNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Uai ote: —Uanaicɨnona omoɨmo lloitɨcue. Jusiñamui dɨbeimo omoɨ illena, jeacɨnona omoɨ faɨnonocaiñenia, bie urue isoi omoɨ moto imɨeñedɨmɨena illanona, Jusiñamui sedajanomo iñeitomoɨ. Cue comɨnɨna omoɨ ia, bie urue isoi iitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Bie urue isoi abɨ ɨedoñedɨmɨedɨ Jusiñamui ie comɨnɨna sedajanomo imɨe moto naimɨena ille. ");
INSERT INTO huuNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Bie isoidɨmɨe cuemo duillamona, naimɨena feiñotɨmɨedɨ cuena jai feiñote; ");
INSERT INTO huuNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","iadedɨ cuena ɨɨnotɨmɨena jeacɨnona fɨnotaiacadɨmɨe iena fɨnoñellena, jeacɨnona fɨnotaiacadɨmɨe cɨmaɨomo aillue nofɨcɨ maɨanona joraimo corobaillena, naimɨena dotacadena, cuemona mare. ");
INSERT INTO huuNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Jesús llote: —Ramo faɨtɨno duere sefuillesa. Dɨga ramo omoɨ faɨcana uitɨnomo riitomoɨ; iadedɨ Jusiñamui omoɨ ramo faɨtɨmɨena duere fɨnoite. ");
INSERT INTO huuNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","9","Biena ñaɨtɨcue. Nɨe isoide rafue omoɨna jeacɨno fɨnotaia, iena llɨnoñeno. Naie rafue dɨne jaiñeno. Iemo eruaɨñeno. Rana omoɨ jetaja jira, omoɨ cɨua rana jira, omoɨ jitaillamona jeacɨno fɨnodomoɨ. Omoɨ abɨna omoɨ namatañeniadedɨ, omoɨ onollɨ jaita. Omoɨ uisɨna juicono. Iemona jeacɨnona fɨnoñellena, Jusiñamui dɨne daje onollɨ dɨga, daje eɨllɨ dɨga, daje uisɨ dɨga riitomoɨ; ia jeacɨnona omoɨ fɨnoia, iraimo jaitomoɨ. Omoɨ comecɨna ñaɨtɨcue. Omoɨ abɨna omoɨ raise namatallena, omoɨ comecɨ nano raise fɨno. Jeacɨno omoɨ fɨnoia, iraimo jaitomoɨ. Nana omoɨ abɨ dɨga iraimo jaitomoɨ. Iraimo omoɨ jaiñellena, jeacɨno fɨnoñeno. ");
INSERT INTO huuNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Jesús llote: —Urue isoi omoɨ illena como llotɨcue. Iena dane lloitɨcue. Cue Moo naimacɨna uiñua jira, bie urue isoidɨnona jamaiñocaiñeno. Monamo cue Moo ecɨmo naimacɨ jaɨenisaɨ jaca ite, naimacɨna canollena. ");
INSERT INTO huuNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Jusiñamuimona cue billanona, naimɨena ɨɨnoñedɨnona naimacɨ jeacɨnomona jilloitallena bitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Ero, omoɨmo iena jɨaɨe rafuedo lloitɨcue. Damɨemo cien dɨga toɨca llauda ite. Naiemona daje feiraite. Iena faɨfiñellena, jɨaɨe llaudaɨaɨna faɨnonocaida, iena jenuaite. ");
INSERT INTO huuNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Iena baillanona, ieri iobite. Baillari oni jaiñedɨnori baɨfemo iobite. ");
INSERT INTO huuNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ie isoide. Jusiñamui naimɨena ɨɨnotɨnomona damɨe faɨfillana jitaiñede. Ie jira naimacɨna jeacɨnona fɨnotañeno. ");
INSERT INTO huuNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Jesús nia llote: —O ecɨmo itɨmɨe ona jeare fɨnoia, naimɨe dɨne iena lluai. Daɨmaiaɨ iena omɨco llono. O uai naimɨe faɨrioia, naimɨe o dɨbeimo jai iite. ");
INSERT INTO huuNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","O uai naimɨe faɨrioñenia, jɨaɨ menamɨena uiño, o lluamo iaɨmaiaɨ cacareillesa. ");
INSERT INTO huuNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","O uai naimɨe faɨrioñenia, omoɨ ofiracomo bicabitɨnomo iena llono. Naimacɨ uai naimɨe faɨrioñenia, Jusiñamuina ɨɨñoñedɨmɨena omoɨ nabaiñena isoi, Moisés llogacɨnodo raise jaiñedɨno omoɨ nabaiñena isoi, naimɨena nabaiñeno. Omoɨ ofiracomo naimɨena feiñoñeno. ");
INSERT INTO huuNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Iese omoɨ fɨnoia, omoɨ comecɨaɨ daje isoi lloillamona, Jusiñamuimona mare. ");
INSERT INTO huuNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Omoɨmo nia lloitɨcue. Daje isoi comecɨna cue Moo Jusiñamuimo jɨcallena menamaiaɨ facajamona, cue Moomo iaɨmaiaɨ jɨɨanona, cue Moo iaɨmaiaɨ jitaille rafuena fɨnoite. ");
INSERT INTO huuNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Menamɨe cue dɨbeimo illamona, damɨe amani cue dɨbeimo illamona, naimacɨ motomo itɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Pedro naimɨemo jɨcanuaɨbite: —Nama, cue ecɨmo itɨmɨe cuena jeare fɨnoia, ¿nɨga icaiño ɨbana cue oñeno iena feitaitɨcue? Nɨbaɨ siete dɨgacaiño. ");
INSERT INTO huuNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesús dɨnena uai ote: —“Nɨbaɨ siete dɨgacaiño” raitɨo. Ona jeare fɨnodɨmɨe ie fɨnoca rafuena naga icaiño feita. Iena omoɨ raise uiñollena, bie rafuena lloitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","24","’Jusiñamui ie dɨbeimo itɨnona iese sedaite: Daje naɨraɨ illaɨmadɨ ie maɨjɨraɨnɨna uaidote, naimacɨ cuentas ɨballena. Damɨe eo debede. Diez mil ucubena debede. ");
INSERT INTO huuNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Naimɨe ucube iñena jira, naie illaɨmadɨ ie cuenta ɨballena, naimɨe aɨ, ie uruiaɨ dɨga, nana ie raruiaɨ dɨga, fecallena llote. ");
INSERT INTO huuNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Iena cacajano, ie illaɨma uicomo caiñɨcɨ ɨfodo raɨta duere jɨcade: “Nama, dama ite. Fecuise omo ɨbaitɨcue”. ");
INSERT INTO huuNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Naimɨe duenaillamona, naie illaɨma llote: “Ɨbatañeitɨcue. Cuemo jai debeñedɨo. Mai jai”. ");
INSERT INTO huuNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ie mei naimɨe jaide. Baɨ jaillanona, jɨaɨe maɨjɨraɨma dɨga dafaɨfide. Jai debeñedɨmɨemo janore debede. Cien ucubena debede. Jai debeñedɨmɨe dɨnena ie cɨmaɨona llɨnuana llote: “O debia cuemo mai ɨba”. ");
INSERT INTO huuNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ie jira debedɨmɨe caiñɨcɨ ɨfodo ana raɨnadacaida, duere jɨcade: “Ucube cuemo iñede; iadedɨ cuena duenai. Fecuise omo ɨbaitɨcue”. ");
INSERT INTO huuNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Uai ote: “Ja raɨre jitaidɨcue”. Naimɨena duenaiñena jira, cárcelmo naimɨena jonetade, ie cuenta ɨballe dɨnori. ");
INSERT INTO huuNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Naimɨe nabaiñɨaɨ iena fɨdɨanona, sunaitɨmacɨ. Ie jira naimacɨ illaɨma dɨne nana naie rafuena lluaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Naie illaɨmadɨ nano debedɨmɨena abɨdo uaiduano, naimɨemo llote: “Maraiñedɨo. Navui o cuentana ɨbatañedɨcue, cuemo o duere jɨcanua jira. ");
INSERT INTO huuNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","¿Bue ñe o nabaina duenaiñedɨo, ona cue duenailla isoi?” ");
INSERT INTO huuNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Icɨrillamona, naie illaɨma naimɨena cárcelmo jonetade, nainomo duere sefuillena, nana ie cuenta ɨballe dɨnori. ");
INSERT INTO huuNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ie isoide. Cue Moo Jusiñamui omoɨna duere fɨnoite, omoɨ comecɨaɨ jitaillamona omoɨ ecɨmo itɨmɨe ie maraiñede fɨnoca rafuena omoɨ feitañenia —llote. ");
INSERT INTO huuNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ie llofueoicaigano dɨga Galileamona jaillanona, Jordán railla ille ruica dɨbeimo Judeamo Jesús jaide. ");
INSERT INTO huuNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ailluena comɨnɨ naimɨena racadɨmacɨ Nainomo duidɨnona jillotate. ");
INSERT INTO huuNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Naimɨena facacɨllena, dajerie fariseuaɨ naimɨe dɨne bitɨmacɨ. Rafuena jɨcanoiacadɨmacɨ. Naimacɨ uai naimɨe raise oñenia, naimɨena duere fɨnoacadɨmacɨ. Jɨcanotɨmacɨ: —¿Ɨima ie aɨna dotajana rairuidɨo? ¿Nɨe isoide rafue muidona damɨe ie aɨna dotarede? ");
INSERT INTO huuNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesús dɨnena uai ote: —Moisés mɨcorɨ jaie cuete: “Enɨrue fɨnua facaiseconi Jesiñamuidɨ come iaɨmaiaɨna fɨnode. Ɨimana fɨnode. Rɨñona jɨaɨ fɨnode”. ");
INSERT INTO huuNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ie jira Jusiñamuidɨ jaie llote: “Ie aɨ dɨga illena, ɨima ie moona faɨnonocaite. Ie eina jɨaɨ faɨnonocaite. Ie aɨ dɨga illamona, menade comedɨ daamɨena jai jaide” llote. ");
INSERT INTO huuNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Menade come jai damɨena jai ite. Jusiñamui iese iaɨmaiaɨna itataja jira, ɨima ie aɨna dotañellesa. Rɨño ie ɨnina dotañellesa. ");
INSERT INTO huuNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Dane jɨcanotɨmacɨ: —¿Bue ñe Moisés mɨcorɨ cuete: “Ɨima ie aɨna dotaacania, dotalle rabena nano cueite. Ie mei naiñaiñona dotaite”? ");
INSERT INTO huuNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesús uai ote: —Jusiñamui uaina raise omoɨ ɨɨnoñena jira, Moisés mɨcorɨ ɨima ie aɨna dotajana rairuiñede; iadedɨ nano dofoconi iese iñede. ");
INSERT INTO huuNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Jɨaɨe rɨño dɨga naimɨe illena, ie aɨna bu dotaia, jɨaɨe ɨima dɨga naiñaiño iñenia, naimɨedɨ jeacɨnona jai fɨnode. Ie aɨna dotajana rairuidɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Naimɨemo ie llofueoicaigano dɨnena llotɨmacɨ: —Iese ia, caɨ jitaillamona aɨna jamai caɨ dotanina jira, damamei aɨnidɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Naimacɨmo Jesús llote: —Nana comɨnɨ omoɨ como lluacɨnodo jainidɨmacɨ. Danɨ Jusiñamuina jitaidɨno iedo jairedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Dajerie naimacɨ jeicɨamona aɨreiacaiñedɨmacɨ. Dajerie naimacɨ abɨna diamona aɨreiacaiñedɨmacɨ. Dajerie Jusiñamuina eo sedaacanano aɨreiacaiñedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Jesús dɨne comɨnɨ naimacɨ jesanidena atɨsɨte. Ie onollɨ naimacɨmo naimɨe joniamona, naimacɨ facaina naimɨe Moo dɨga naimɨe ñaɨllena atɨsɨte. “Naimacɨna raise cano” ie Moomo llollena jitaidɨmacɨ. Ie llofueoicaigano iena rairuidɨmacɨ; ");
INSERT INTO huuNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","iadedɨ Jesús raite: —Uruiaɨ cue dɨne billesa. Naimacɨna rairuiñeno. Cuena bie isoide ɨɨnotɨnodɨ Jusiñamui ie comɨnɨna sedajanomo jaɨnaɨaɨdɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ie jira ie onollɨ naimacɨmo jonete. Naimɨe facaina Jusiñamui dɨga ñaɨte, naimacɨ marena illena. Ie mei ie llofueoicaigano dɨga naimɨe oni jaide. ");
INSERT INTO huuNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Jesús oni jaillanona, conirue Jesús dɨne bite. Jɨcanote: —Maestro, Jusiñamui dɨga cue jaca illena, ¿nɨe isoide mare rafuena fɨnoitɨcue? ");
INSERT INTO huuNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesús dɨnena uai ote: —¿Bue ñe cuemo mare rafuena fɨnuana jɨcanotɨo? Dama damɨe maremɨe. Naimɨedɨ Jusiñamui. Naimɨemo jɨcano; ia jaca o illena, Jusiñamui jai llogacɨnuaɨna ɨɨnocana jai. ");
INSERT INTO huuNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Uai ote: —¿Nɨe llogacɨnuaɨna ɨɨnoitɨcue? Jesús dɨnena uai ote: —Comena meineñeno. O aɨñede rɨño dɨga iñeno. Fɨɨñeno. Jɨaɨmɨena o llogɨdoia, taɨnona lloñeno. ");
INSERT INTO huuNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","O moo uaina ɨɨno. O ei uaina ɨɨno. O abɨna o isiruilla isoi, nana comɨnɨna isirui. ");
INSERT INTO huuNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Naie conirue uai ote: —Nana iena jai ɨɨnotɨcue. ¿Nɨe isoide rafuena nia fɨnoitɨcue? ");
INSERT INTO huuNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesús dɨnena uai ote: —Jusiñamui jitaillacɨnodo o jaiacania, o raise marebicaiacania, omo ite raruiaɨna feca. Naie ucubena dueredɨnomo feca. Cuena o ɨɨnuamona, monamo ɨco jaca iitɨo. Cue llofuegamɨena o illena, mai cue dɨga bi. ");
INSERT INTO huuNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Iena naimɨe cacajano, sunaite. Naimɨemo eo ailluena ra illa jira, iena fecaacaiñede. ");
INSERT INTO huuNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Jesús ie llofueoicaiganomo llote: —Uanaicɨnona omoɨmo lloitɨcue. Ucuberedɨmɨedɨ Jusiñamui comɨnɨna jaillena eo sefuiruite. ");
INSERT INTO huuNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Iena nia lloitɨcue. Igɨdo ifodo camello jaca jainide. Ie isoide. Ie ra isiruillamona, ucuberedɨmɨedɨ Jusiñamui ie comɨnɨna jɨaɨ raise jainide. ");
INSERT INTO huuNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Iena ie llofueoicaigano cacajano, Jusiñamui comɨnɨna ucuberedɨno raise jainina jira, “¿Nɨese dueredɨnodɨcaɨdɨ Jusiñamui comɨnɨna jaitɨcaɨ?” raillamo comecɨaɨna facadɨmacɨ. Raijicaillanona, raitɨmacɨ: —Nana comɨnɨ rana jitailla jira, buca jillobitɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Naimacɨmo eruaɨllanona, Jesús raite: —Nana comɨnɨ danɨ jillobinidɨmacɨ; iadedɨ Jusiñamuidɨ naimacɨna jillobitarede. ");
INSERT INTO huuNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Pedro uai ote: —Ero, o llua isoi nana caɨ rana faɨnonocaida, o dɨga jaicabidɨcaɨ. ¿Nɨese Jusiñamuimona ɨbana feiñoitɨcaɨ? ");
INSERT INTO huuNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesús dɨnena uai ote: —Illaɨmana ɨco cue ia, eo ebirede illanomona comɨnɨna sedaitɨcue. Cue dɨga omoɨ jaicabilla jira, nainomo omoɨ illanuaɨ jɨaɨ iite, nainomona omoɨ judíuaɨ doce naɨraɨaɨna omoɨ sedallena. ");
INSERT INTO huuNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Cuena naimɨe isiruillamona, ie jofona bu faɨnonocaia, ie amatɨaɨna bu faɨnonocaia, ie mirɨñuaɨna bu faɨnonocaia, ie moona bu faɨnonocaia, ie eina bu faɨnonocaia, ie uruiaɨna bu faɨnonocaia, ie enɨruena bu faɨnonocaia, Jusiñamuimona ailluena ɨbana feiñoite. Monamo ɨco caɨmare iocɨre jaca iite. Nainomo benomo baɨfemo iocɨre caɨmare iite. ");
INSERT INTO huuNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Jamai bue isoidomoɨ. Omoɨmona jɨaɨno jamai bue isoiñedɨmacɨ; ia naimɨe comɨnɨna naimacɨ jaillamona, Jusiñamuimona naimacɨ dɨga daje isoidomoɨ. Naimɨe dɨga jaca iitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Jesús llote: —Jusiñamui dɨbeimo comɨnɨ jailla rafuena lloitɨcue. Naimɨe comɨnɨna naimacɨ jaillamona, Jusiñamuimona nana naimɨe comɨnɨ daje isoidɨmacɨ. Iena raise omoɨ uiñollena, bie rafuedo iena lloitɨcue. Jitɨramo daje patrón ie illɨmo maɨjɨllena, maɨjɨuidɨnona jenuaide. ");
INSERT INTO huuNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Dajeriena baillanona, “Omoɨmo daberie ɨbaitɨcue” llote. “Jee” raitɨmacɨ. Ieconi ie illɨmo maɨjɨllena, naimacɨna orede. ");
INSERT INTO huuNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Jitoma nia oni daidemo, mercadomo naimɨe jɨaɨnona cɨode. Jamai itɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ie jira naimacɨmo llote: “Cue illɨmo maɨjɨai. Raise ɨbaitɨcue” llote. ");
INSERT INTO huuNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ie mei jaidɨmacɨ. Jitoma naidai ia, jɨaɨnona cɨuanona, naimacɨmo maɨjɨllena llote. Jitoma oni caidemo, jɨaɨnona cɨuanona, naimacɨmo maɨjɨllena jɨaɨ llote. ");
INSERT INTO huuNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Jitoma jasicɨ muido itemo, jɨaɨnona cɨuanona, jɨcanote: “¿Bue ñellena namonana jamai itomoɨ?” ");
INSERT INTO huuNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Uai otɨmacɨ: “Jaca caɨmo maɨjɨlle rana budɨ lloñede”. Ie jira naimacɨmo llote: “Mai. Cue illɨmo maɨjɨai” llote. ");
INSERT INTO huuNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Jitoma edacɨidemo, naie patrón ie mullaɨmamo llote: “Maɨjɨraɨnɨna uaido. Jɨnafona maɨjɨaidɨnona raɨre nano ɨba. Ie mei jitɨramo maɨjɨaidɨnona jɨnafo ɨba” llote. ");
INSERT INTO huuNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ie jira jɨnafona maɨjɨaidɨnona nano ɨbade. Dabe ɨbade. ");
INSERT INTO huuNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","“Naimacɨ baɨfemo feiñoitɨcaɨ” raillamo jitɨramo maɨjɨaidɨno comecɨaɨna facadɨmacɨ; iadedɨ iese feiñoñedɨmacɨ. Nana daberie feiñotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ie jira naie patrón joreñona jeare ñaɨtɨmacɨ: ");
INSERT INTO huuNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","“Jɨnafona maɨjɨaidɨno dallu maɨjɨdɨmacɨ. Ecasilla facaise maɨjɨñedɨmacɨ; iadedɨ namonana maɨjɨdɨcaɨ. Danɨ caɨ ɨbaja isoi ɨbadɨo” ñaɨtɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Naimacɨmona damɨemo naie patrón llote: “Ero, ona jeare fɨnoñedɨcue. ‘Omo daberie facaitɨcue’ omo llotɨcue. O dɨnena: ‘Jee’ raitɨo. ");
INSERT INTO huuNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","O ucubena jai o feiñua jira, mai jai. Cue jitailla jira, da o ɨbaja isoi dallu maɨjɨdɨnona ɨbadɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Cue ucubena jira, cue jitaille isoi cue ɨbaia, ¿nɨese cuena jeare ñaɨtomoɨ? Jɨaɨnona cue duenaillanona, ¿bue ñellena uradoidomoɨ? Mai jai” llote. Jusiñamui ie comɨnɨna sedaacana omoɨ raise uiñollena, bie rafue jai llotɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Jamai bue isoidomoɨ. Omoɨmona jɨaɨno jamai bue isoiñedɨmacɨ; ia naimɨe comɨnɨna naimacɨ jaillamona, Jusiñamuimona naimacɨ dɨga daje isoidomoɨ. Naimɨe dɨga jaca iitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jerusalémo ie llofueoicaigano dɨga Jesús jaidemo, danɨ naimacɨ dɨga ñaɨllena, naimacɨna oni uite. ");
INSERT INTO huuNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Raite: —Ero, Jerusalémo jai jaidɨcaɨ. Monamona billanona, ɨimana jaidɨcue; iadedɨ omoɨ illaɨcomɨnɨ cuena gaɨtaitɨmacɨ. Gaɨtaja mei, cue meinellena lloitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Judíuaɨñedɨno illaɨcomɨnɨmo cuena fecaitɨmacɨ. Cueri jɨfanoitɨmacɨ. Cuena faitɨmacɨ. Ie mei cuena coraɨitɨmacɨ; iadedɨ cue fiodailla mei, darui amani illanona, Jusiñamui cuena jillotaite. ");
INSERT INTO huuNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Naie facaise Jesús dɨne Jacobo, Juan iaɨmaiaɨ ei dɨga, bitɨiaɨmaiaɨ. Iaɨmaiaɨ moodɨ Zebedeo. Jesús dɨne iaɨmaiaɨ ei rillanona, naimɨena raise uaidollena, caiñɨcɨ ɨfodo ana raɨnadacaida llote: —Omo daje rafue jɨcanoiacadɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Naiñaiñomo Jesús dɨnena jɨcanote: —¿Bue ñiaɨbitɨo? Naiñaiño uai ote: —Illaɨmana o jailla mei, cue jito iaɨmaiaɨ o ecɨmo illana o lluana jitaidɨcue. Damɨe o nabeimo. Jɨaɨmɨe o jarɨfebeimo. —Jɨaɨno baɨfemo iaɨmaiaɨ illena, naiñaiño iese llote. ");
INSERT INTO huuNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Naimacɨmo eruaɨllanona, Jesús dɨnena uai ote: —O jitaillacɨnona raise uiñoñedɨo. Cue duere sefuitɨcue. Naiñaiño jito iaɨmaiaɨmo jɨcanote: —¿Ie isoi duere sefuiacadomɨco? Uai otɨiaɨmaiaɨ: —Jɨɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jesús dɨnena raite: —Cue isoi duere sefuitomɨco; iadedɨ cue nabeimo omɨco illena, cue jarɨfebeimo omɨco illena itatanidɨcue. Naie illano jai cue Moo fɨnoca, nainomo iitɨno iena. ");
INSERT INTO huuNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Iena jɨaɨe llofueoicaigano cacajano, naie iaɨamaiaɨri icɨritɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Jesús nana naimacɨna uaiduanona, raite: —Nana illaɨcomɨnɨdɨ naimacɨ anamo itɨnona ocuicabidɨmacɨ; ");
INSERT INTO huuNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","iadedɨ omoɨ dɨne iese iñena. Omoɨmona bu imɨena iacania, omoɨ mullaɨmana naimɨe jaisoillasa. ");
INSERT INTO huuNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Omoɨmona bu imɨena iacania, omoɨna naimɨe canocana jaisoillasa. ");
INSERT INTO huuNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Cuemona fueo. Biñedɨcue comɨnɨna cue ocuillena; iadedɨ comɨnɨna canuaɨbidɨcue. Cue jitailla jira, nana comɨnɨ facaina fiodaisaɨbitɨcue. Naimacɨ jeacɨnomona naimacɨ jillobillena, fiodaisaɨbitɨcue. Ailluena comɨnɨ cuena ɨɨnuamona jilloitɨmacɨ. Coninɨna omoɨ canua —llote. ");
INSERT INTO huuNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jericó railla naɨraɨmona jaidɨmacɨmo, ailluena comɨnɨ naimacɨ jɨnafona racadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ie facaiseconi mena uisɨnidɨaɨmaiaɨ naɨ fuemo raɨdɨaɨmaiaɨ. Jesús naiedo jaillano cacajano, naimɨena ado uaidotɨiaɨmaiaɨ: —David mɨcorɨ Jitona o illamona, Jusiñamuimona o billa jira, cocona duenai. Cocona cano. ");
INSERT INTO huuNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Iaɨmaiaɨ llɨɨcaillena, Jesús dɨga jaidɨno iaɨmaiaɨna lletade; iadedɨ eo cuirioidɨaɨmaiaɨ: —Maestro, David mɨcorɨ Jitona o illamona, cocona duenai. ");
INSERT INTO huuNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Iaɨmaiaɨna Jesús cacajano, ieconi naidadajanona, iaɨmaiaɨna uaidote. Jɨcanote: —¿Nɨese omɨcona cue nɨbaɨana jitaidomɨco? ");
INSERT INTO huuNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Uai otɨiaɨmaiaɨ: —Maestro, coco uisɨna o cɨoitajana jitaidɨcoco. ");
INSERT INTO huuNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Iaɨmaiaɨna duenaillanona, iaɨmaiaɨ uisɨna jetade. Ieconi iaɨmaiaɨ uisɨdɨ cɨode. Iaɨmaiaɨ jai cɨuanona, ie llofueganona iaɨmaiaɨ jaillena, Jesús dɨga jaidɨiaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Oni jaillanona, Jerusalémo iaɨreicaidɨmacɨmo, Betfagé railla naɨraɨmo Jesús ie llofueoicaigano dɨga ridɨmacɨ. Olivos railla anedumo ite. Ie llofueoicaiganomona Jesús menamɨena orede. ");
INSERT INTO huuNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Raite: —Bie naɨraɨ illa uicomo mai omɨco jai. Nainomo cuinaca burrana baitomɨco. Ie ecɨmo ie uruena baitomɨco. Naie iaɨmaiaɨna suiñuano bene atɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Omɨcomo “¿Bue ñellena bie suiñodomɨco?” bu jɨcanoia, llono: “Coco Nama naie iaɨmaiaɨna jitaide. Naillɨ naimɨe iaɨmaiaɨna raɨre abɨdo oretaite” —raite. ");
INSERT INTO huuNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Jusiñamui facaina lloraɨma mɨcorɨ jaie llua isoi, bie rafue suide. ");
INSERT INTO huuNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Naimɨe mɨcorɨ jaie cuete: Jerusalén itɨnomo llono: “Ero, omoɨ illaɨma omoɨna sedallena biite. Abɨ ɨedoñeno biite. Burra urue emododo naimɨe biite” cuete. ");
INSERT INTO huuNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Iaɨmaiaɨ jaillanona, Jesús llua isoi fɨnodɨaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Burra ie urue dɨga atɨdɨaɨmaiaɨ. Burra urue emodomo naimɨe llofueoicaigano naimacɨ ɨniroina jobianona, ie emodomo Jesús raɨnadate. ");
INSERT INTO huuNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Naimɨena iobitallena, illaɨma isoi naimɨe jaillena, ailluena comɨnɨ imacɨ ɨniroi dɨga, naɨso motomo jobedɨmacɨ. Jɨaɨno raforono uanona, naɨso motomo jobedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Dajerie Jesús uicomo jaidɨmacɨ. Dajerie naimɨe jɨnafona jaidɨmacɨ. Ado cuiriisɨte: —¡Caɨ Jilloitaraɨma billa! ¡Naimɨedɨ David mɨcorɨ Jito! ¡Jusiñamui mamecɨdo bitɨmɨe eo mare! ¡Jusiñamui caɨna jilloitajasa! ");
INSERT INTO huuNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jerusalémo naimɨe ridemo, nana nainomo itɨno naie rafuena uiñoiacadɨmacɨ. —¿Buta bite? —jɨcanotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Jesús dɨga bitɨno dɨnena uai otɨmacɨ: —Jesús bite. Naimɨedɨ Jusiñamui facaina lloraɨma. Galileamo ite Nazaret imɨe. ");
INSERT INTO huuNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jerusalémo Jesús rilla mei, Jusiñamui jofomo naimɨe jaide. Naie jofo eo aillue. Dɨga cuartos nainomo ite. Jusiñamuimo ofomaɨaɨna fecallena, naimɨemo toɨca llaudaɨaɨna fecallena, nainomo comɨnɨ jaisoidɨmacɨ. Naie comɨnɨna ɨbatajanona, ofomaɨaɨna, toɨca llaudaɨaɨ dɨga, damɨerie fecauidɨmacɨ. Iena Jesús cɨuanona, naimacɨ mesaɨaɨna oni caicode. Ucugɨna fecauidɨno raɨracuaɨ jɨaɨ oni caicode. ");
INSERT INTO huuNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Naimacɨmo llote: —Ie facaina lloraɨma Jusiñamui llogacɨno jaie cuega: “Cue jofo ite, nainomo cuemo comɨnɨ jɨɨllena” cuega. Ero, ailluena omoɨ ɨbataja jira, naimɨe jofona fɨɨriruidɨno jofona omoɨ fɨnoca. ");
INSERT INTO huuNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ie facaise uisɨnidɨno Jusiñamui jofomo naimɨe dɨne bitɨmacɨ. Ñuja-ñujacaida macaritɨno jɨaɨ bitɨmacɨ. Naimacɨ billanona, Jesús naimacɨna jillotate. ");
INSERT INTO huuNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Nainomo Jesúdɨ dɨga mare rafuena fɨnode. Dɨga comɨnɨna jillotate. Iena cɨuanona, nainomo ite uruiaɨ ado cuiriisɨte: —David mɨcorɨ Jitori iobidɨcaɨ. Jusiñamui lloraɨnɨ mɨcorɨaɨ jaie llua isoi, caɨ Jilloitaraɨma jai ite. Iena cɨuanona, iena cacajanona, judíuaɨ illaɨcomɨnɨ icɨritɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Naimɨemo jɨcanotɨmacɨ: —¿Bie uruiaɨ cuiriillana cacadɨo? Jesús dɨnena uai ote: —Jɨɨ, cacadɨcue. David mɨcorɨ iena jaie cuete. ¿Nɨese iena cacaiñedomoɨ? Naimɨe cuete: Naimɨemo Jusiñamuidɨ uruiaɨna mare iobillacɨnona fecataite. ");
INSERT INTO huuNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Naimacɨna faɨnonocaida, Betaniamo Jesús jaide, nainomo ɨnɨllena. ");
INSERT INTO huuNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ie areruido Jerusalémo abɨdo ie llofueoicaigano dɨga Jesús bia, aimetaite. ");
INSERT INTO huuNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Naɨ fuemo higuera railla riarana cɨuanona, iena jɨbuide. Naiemo naie llɨsilladɨ iñede. Dama ie ibena cɨode. Ie jira naie amenana llote: —Biemona jaca llɨsiñeite. —Iese railla dacaiño naie riaradɨ duide. ");
INSERT INTO huuNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ie llofueoicaigano iena cɨuanona, raijicaillamona raitɨmacɨ: —¿Nɨese naie riara raɨre duide? ");
INSERT INTO huuNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesús dɨnena uai ote: —Uanaicɨnona omoɨmo lloitɨcue. Cue Moona raise omoɨ ɨɨnoia, bie isoide rafuena fɨnoitomoɨ. Raise omoɨ ɨɨnoia, omoɨ comecɨ ɨgɨreñenia, bene ite anedumo omoɨ lloia: “Monaillaimo o illena, benomona mai jai”, Jusiñamui o jitaille rana fɨnoite. ");
INSERT INTO huuNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Naimɨe iena fɨnuana omoɨ ɨɨnuamona, nɨe isoide rafue cue Moomo omoɨ jɨcajia, iena naimɨe fɨnoite. ");
INSERT INTO huuNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jerusalémo rillanona, Jusiñamui jofomo Jesús fo jailla mei, nainomo ite comɨnɨna llofuete. Judíuaɨ illaɨcomɨnɨ naimɨe dɨne billanona, jɨcanotɨmacɨ: —¿Nɨe isoide uaido o fɨnoca rafuena fɨnodɨo? ¿Bu omo iga uai dɨga o fɨnoca rafuena fɨnodɨo? ");
INSERT INTO huuNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesús dɨnena uai ote: —Omoɨmo daje rafuena nano jɨcanoitɨcue. Raise omoɨ faɨrioia, omoɨmo cue uaido cue fɨnoca rafuena lloitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Juan Bautista mɨcorɨdɨ comɨnɨna navui bautizade. ¿Bu naimɨe mɨcorɨna orede, comɨnɨna bautizallena? ¿Jusiñamui? ¿Comɨnɨ? Cuemo llono —llote. Danɨ coninɨri iena siaduanona, anado raitɨmacɨ: —“Jusiñamui” caɨ faɨrioia, caɨmo jɨcanoite: “¿Bue ñellena naimɨe mɨcorɨ lluana ɨɨnoñedomoɨ?” ");
INSERT INTO huuNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","“Comɨnɨ” caɨ faɨrioia, bene itɨno caɨna nɨbaɨ meineitɨmacɨ, Juan mɨcorɨdɨ Jusiñamui facaina lloraɨma naimacɨ railla jira. ");
INSERT INTO huuNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ie jira faɨriotɨmacɨ: —Uiñoñedɨcaɨ. Jesús dɨnena raite: —Ie muidona cuemo nɨe isoide uai illana omoɨmo lloñeitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Judíuaɨ illaɨcomɨnɨmo Jesús llote: —Bie rafuemo omoɨ comecɨaɨna faca. Damɨemo mena jito ite. Nano doforamɨemo llote: “Moo, cue illɨmo birui maɨjɨai”. ");
INSERT INTO huuNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Uai ote: “Jaiacaiñedɨcue” llote. Dallu illanona, ie comecɨna dane facajano, maɨjɨaide. ");
INSERT INTO huuNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Jɨaɨe jitomo daje isoi llote. Naimɨe uai ote: “Jɨɨ, maɨjɨaitɨcue” llote. Iese llote; iadedɨ maɨjɨaiñede. ");
INSERT INTO huuNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Nɨe jitoca ie moo jitailla rana fɨnode? —jɨcanote. Uai otɨmacɨ: —Nano doforamɨe. Jesús dɨnena naimacɨmo llote: —Uanaicɨnona omoɨmo lloitɨcue. Omoɨna ñaɨtɨcue. Omoɨmona maraiñedɨmacɨ; iadedɨ Jusiñamui comɨnɨna naimacɨ jaillamona, gobierno ucube oraɨnɨ Jusiñamui illanomo iitɨmacɨ. Calliredɨñaiñuaɨdɨ nainomo jɨaɨ iitɨmacɨ; iadedɨ nainomo jaca iñeitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Marena omoɨ comecɨaɨna itatallena, Juan mɨcorɨ navui bite; iadedɨ naimɨe mɨcorɨna ɨɨnoñedomoɨ. Ucube oraɨnɨ naimɨe mɨcorɨ rafuena ɨɨnotɨmacɨ. Calliredɨñaiñuaɨ naimɨe mɨcorɨ rafuena ɨɨnotɨmacɨ. Iena uiñotomoɨ; iadedɨ omoɨ comecɨaɨ iuaillaɨna meidoiñedomoɨ. Ɨɨnoñedomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Judíuaɨ illaɨcomɨnɨmo Jesús llote: —Jɨaɨe rafuena omoɨmo lloitɨcue. Iemo cacarei. Daje patrón uvas railla riaraɨaɨna rite. Naie abɨ llaɨte. Jɨaɨruido uvas ijina eenollena, enɨruemo ifona raɨte. Naie illɨna raise eruaɨllena, tɨdacana fɨnode. Iena sedallena, ɨbatajanona jɨaɨnomo fecade. Ie mei jɨaɨe enɨruemo jaide. ");
INSERT INTO huuNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Uvas jai einailla facaise riaraɨaɨna sedaraɨnɨ dɨne naie patrón janore mullaɨaɨna orede, naimɨe facaise iedɨnona naimɨe feiñollena; ");
INSERT INTO huuNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","iadedɨ naie sedaraɨnɨdɨ ie mullaɨaɨna duere fɨnosɨte. Daje mullaɨmana fatɨmacɨ. Jɨaɨmɨena meinetɨmacɨ. Jɨaɨmɨena nofɨcɨna faɨrɨnotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ie mei patrón jɨaɨe mullaɨaɨna orede. Naimacɨna jɨaɨ duere fɨnodɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ja muidomo ie jitona orede. “Cue jitona jacɨruitɨmacɨ. Naimɨe uaina ɨɨnoitɨmacɨ” comecɨna facade. ");
INSERT INTO huuNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Riaraɨaɨna sedaraɨnɨ naimɨena cɨuanona, coninɨri raitɨmacɨ: “Bimɨemo bie illɨ fɨebiite, naimɨe moo fiodailla mei. Naimɨena caɨ meinellɨ, bie illɨ caɨmo fɨebillesa” raitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Naimɨena jino dotajanona, naimɨena meinetɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Naie illɨ nama ɨco abɨdo bille mei, ¿nɨe isoide rafuena naimɨe naie illɨna sedaraɨnɨna fɨnoite? Cuemo llono —llote. ");
INSERT INTO huuNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Judíuaɨ illaɨcomɨnɨ uai otɨmacɨ: —Naie maraiñedɨnona dueruiñeno meineite. Ie mei jɨaɨe comɨnɨmo naie illɨ fecaite, iena sedallena, naiemona riarana feiñollena. ");
INSERT INTO huuNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Naimacɨmo Jesús llote: —Naie illɨ sedaraɨnɨ isoidomoɨ. Jusiñamui facaina lloraɨma mɨcorɨ omoɨna jaie cuete. Ie cuegafuena raise facañedomoɨ. Naimɨe mɨcorɨ cuega: Jofo fɨnoraɨnɨ jitaiñena nofɨcɨdɨ nana naie jofomo ite nofɨcɨ baɨfemo jai uaide. Jusiñamui iena fɨnotate. Iena caɨ uiñuamona, “Eo mare” raitɨcaɨ cuega. Jusiñamui comɨnɨna damɨerie jaillana naimɨe mɨcorɨ cuete. Jusiñamui oretagamɨena damɨerie jitaiñenamona, naimɨe comɨnɨna jaiñeitɨmacɨ; iadedɨ Jusiñamui oretagamɨena ailluena ɨɨnuamona, naimɨe comɨnɨna jaitɨmacɨ. Ero, naimɨe mɨcorɨ caɨna cuete. Naie jofona fɨnoraɨnɨ isoidomoɨ. Naie nofɨcɨ isoidɨcue. Cue rafuena omoɨ jitaiñena jira, naimɨe comɨnɨna jaiñeitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Jusiñamuidɨ ie comɨnɨna sedajanomo omoɨna itatañeite; iadedɨ jɨaɨe comɨnɨna nainomo itataite, naimɨe jitailla rafuena naimacɨ fɨnua jira. ");
INSERT INTO huuNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Jesús llote: —Naie nofɨcɨna dane ñaɨtɨcue. Nofɨcɨmo bu eɨcaɨtaia, bofedaite; ia naie nofɨcɨ bumo ana uaia, naimɨena saitaite. Ie isoide. Cue lluana omoɨ jamaia, duere sefuitomoɨ. Iena omoɨ ɨɨnoñenia, ja muidomo faɨfitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Jesús lluana naie judíuaɨ illaɨcomɨnɨ cacajanona, naimɨedɨ naimacɨna ñaɨana jai uiñotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Icɨrillamona, naimɨena gaɨtaacadɨmacɨ; iadedɨ comɨnɨna jacɨruitɨmacɨ, comɨnɨdɨ naimɨe Jusiñamui facaina lloraɨmana raillanona. ");
INSERT INTO huuNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jusiñamui jofomo Jesús nia illanona, nainomo itɨnona llofuete: ");
INSERT INTO huuNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Jusiñamui dɨbeimo comɨnɨ jailla rafuena omoɨmo lloitɨcue. Iena omoɨ uiñollena, bie rafuedo iena lloitɨcue. Illaɨmadɨ ie jito aɨ ua rafue fɨnode. ");
INSERT INTO huuNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Naimɨe ie mullaɨnɨ orede, rafuemo llogano uaidollena; iadedɨ nai llogano biacaiñedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Dane jɨaɨe mullaɨnɨ oretajano llote: “Nai lloganomo llono: ‘Rafue guille jai fɨnocasa. Ɨiretaɨaɨ, faredɨretaɨaɨ dɨga, jai faga. Jai nana fuite. Rafuemo mai bi’ ”. ");
INSERT INTO huuNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Naimacɨ cacarefiacaiñede. Damɨe ie illɨmo jaide. Jɨaɨmɨe ie chinganamo jaide. ");
INSERT INTO huuNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Jɨaɨno mullaɨnɨna gaɨtadɨmacɨ. Gaɨtajanona naimacɨri jɨfanotɨmacɨ. Ja muidomo naimacɨna meinetɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ie jira naie illaɨma eo icɨrite. Naimɨe soldaduaɨ oretate, naimɨe mullaɨnɨ meinetɨnona meinellena. Naimɨe naimacɨ illano jobaitate. ");
INSERT INTO huuNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ie meinoconi ie fɨebide mullaɨnɨmo llote: “Rafue guille jai nana fɨnoca; ia llogano maraiñedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Naɨso bojicaillanomo jai. Nana o cɨolle dɨese llono: ‘Rafuemo bi’ llono”. ");
INSERT INTO huuNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ie jira ie mullaɨnɨ jai naɨsona jaide. Maraiñedɨno baillanona dɨese ofitatɨmacɨ. Jɨaɨ maredɨno dɨese ofitatɨmacɨ. Rafue fɨnua jofo naie llogano dɨga oruide. Illaɨma nainomo fecaca ɨniroina jɨtadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Illaɨma fo bia, mesamo itɨno jɨbuillena, dɨnomo daje ɨima rafue ie mare ɨniroina jɨtañenana cɨode. ");
INSERT INTO huuNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Naimɨemo jɨcanote: “Nabai, ¿nɨese bene rafue ie mare ɨniroina jɨtañeno bitɨo?” jɨcanote. Naimɨe uainicaide. ");
INSERT INTO huuNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ie jira naie illaɨma ie mullaɨaɨmo llote: “Naimɨe cuena ɨɨnoñena jira, naimɨe onollɨ dajemo nitaicaida maɨno. Ie eɨllɨna daje isoi maɨno. Cuemona naimɨe jino dota. Nainomo itɨno dɨga duere sefuite. Jɨaɨ sunaite” llote. ");
INSERT INTO huuNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ero, naie rafuemona omoɨ fueo. Illaɨma ailluena uaidote; ia nana biñedɨmacɨ. Ie isoide. Jusiñamui ailluena comɨnɨna uaidote; iadedɨ naimacɨmona janore fetode. ");
INSERT INTO huuNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Naimacɨmo Jesús llua mei, fariseuaɨ comɨnɨ abɨdo jaillanona, coninɨri siadotɨmacɨ. Naimɨe raise uai oñedena, naimɨena duere fɨnollena, Jesúna facacɨiacadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ie jira naimɨe dɨne naimacɨ comɨnɨmona dajerie oredɨmacɨ. Herodianuaɨ railla comɨnɨna jɨaɨ jaidɨmacɨ. Jesús dɨne rillanona, raitɨmacɨ: —Maestro, uanaicɨnona llofuecabitɨo. Jusiñamui rafuedo caɨ marena jaillana raise llofuetɨo. Nana comɨnɨ dauaido llofuetɨo. Comɨnɨna iobitallena llofueñedɨo. ");
INSERT INTO huuNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Omo rafuena jɨcanoiacadɨcaɨ. Danɨ Jusiñamuina sedadɨcaɨ; iadedɨ romanos railla naɨraɨ anamo birui caɨ illa jira, ¿naimacɨ illaɨma Césarmo ucubena caɨ fecajana rairuidɨo? Caɨmo llono —llotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Naimacɨ comecɨaɨna maraiñedɨcɨnona facajana Jesús uiñuamona, uai ote: —¿Bue ñellena cuena facacɨtomoɨ? Maredɨnona abɨ caitadomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ucube cuemo acata —llote. Ie jira acatatɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Jesús dɨnena jɨcanote: —¿Bu ie joreño nainomo ite? ¿Bumo jaɨnaɨaɨde bie cuega radɨ? ");
INSERT INTO huuNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Uai otɨmacɨ: —César. Jesús dɨnena raite: —César iena itedɨ Césarmo ille. Jusiñamui iena itedɨ Jusiñamuimo ille —raite. ");
INSERT INTO huuNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Naimɨe lluana cacajano, raijicaidɨmacɨ. Naimɨe jeare uai oñena jira, naimɨe dɨnomona oni jaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Naie facaise saduceuaɨ railla comɨnɨ naimɨe dɨne bitɨmacɨ. Fiodaillamona jaca buna jilloñellena ɨɨnotɨmacɨ. Jesúmo llotɨmacɨ: ");
INSERT INTO huuNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Maestro, Moisés mɨcorɨ jaie cuega: “Ɨima fiodailla meinoconi, naimɨe urue iñenia, ie ama naie fecɨño olle. Naimɨedɨ uruiaɨna ie ama facaina comuitaite” cuega. ");
INSERT INTO huuNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ero, caɨ motomo siete amatɨaɨ ite. Nano doforamɨe ie aɨna ote. Naimɨe nia uruiaɨnide fiodailla. Ie emodo imɨe ie ama fecɨñona ote. Uruiaɨnide jɨaɨ fiodailla. ");
INSERT INTO huuNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Naie siete dɨgamɨedemona iese sefuide. ");
INSERT INTO huuNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ja muidomo naie rɨño jɨaɨ fiodaite. ");
INSERT INTO huuNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Fiodaillamona, ɨco naimacɨ jilloiadedɨ, ¿bu naie rɨño ienite? Naiñaiño siete dɨgamɨena ɨnirede —llotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesús uai ote: —Moisés mɨcorɨ cuegafuiaɨna raise omoɨ uiñoñena jira, Jusiñamui uaina raise omoɨ uiñoñena jira, bie isoide rafuena raise uiñoñedomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Fiodaillamona jillua mei, Jusiñamui dɨga ite comɨnɨ aɨnitɨmacɨ. Ɨninitɨmacɨ. Monamo Jusiñamui jaɨenisaɨ aɨnidɨmacɨ. Ɨninidɨmacɨ. Ie isoi iitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Fiodaitɨno jilluana omoɨmo lloitɨcue. Jusiñamui omoɨ jaiagaɨmo jaie llogacɨnona ɨɨnoñedomoɨ. Naimɨe llote: ");
INSERT INTO huuNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Abraham ie Jusiñamuidɨcue. Isaac ie Jusiñamuidɨcue. Jacob ie Jusiñamuidɨcue” llote. Jai fiodaitɨmacɨ; ia naimacɨ joreñuaɨ nia itɨmacɨ. Jusiñamuidɨ danɨ cajedɨno imacɨ Jusiñamuina jira, naimacɨ joreñuaɨ naimɨe dɨne itɨmacɨ. Ɨco naimacɨ abɨaɨna jɨaɨ jillotaite —llote. ");
INSERT INTO huuNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Nainomo ite comɨnɨ iena cacajano, naimɨe llofuiari raijicaidɨmacɨ; ia saduceuaɨ dɨnena uainicaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Saduceuaɨ comɨnɨ uainicaillana fariseuaɨdɨ jai fɨdɨano, Jesús dɨne ofidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Naimacɨmona damɨedɨ Moisés mɨcorɨ jaie llogacɨnona eo uiñote. Jesúna facacɨllena, naimɨemo jɨcanote: ");
INSERT INTO huuNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Maestro, Moisés mɨcorɨ jaie llogacɨnuaɨmona, ¿nɨe llogacɨno ua nanoca llogacɨnona? ");
INSERT INTO huuNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesús dɨnena uai ote: —Moisés mɨcorɨ jaie cuega: “Omoɨ jitailla jira, nana omoɨ comecɨmona caɨ Nama Jusiñamuina isirui. Naimɨemo omoɨ comecɨna eo faca”. ");
INSERT INTO huuNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Bie ua nanoca llogacɨno. ");
INSERT INTO huuNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ie emodomo ite llogacɨno janore daje isoide: “Danɨ omoɨ abɨ omoɨ isiruilla isoi, omoɨ ecɨmo itɨnona jɨaɨ isirui”. ");
INSERT INTO huuNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Bie mena llogacɨnomona nana jɨaɨe llogacɨnuaɨ comuide. Nana Moisés mɨcorɨ llogacɨnuaɨ naiemona comuide. Nana Jusiñamui facaina lloraɨnɨ mɨcorɨaɨ llogacɨnuaɨ naiemona comuide —llote. ");
INSERT INTO huuNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Naimɨe dɨne nia fariseuaɨ comɨnɨ ia, Jesús naimacɨmo llote: ");
INSERT INTO huuNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","—Jusiñamui lloraɨnɨ mɨcorɨaɨ jaie raitɨmacɨ: “Jusiñamuidɨ Cristo raillamɨena oretaite, ie comɨnɨna sedallena”. ¿Nɨese naimɨena raitomoɨ? ¿Bu jito naimɨedɨ? Uai otɨmacɨ: —David mɨcorɨ jito. David mɨcorɨ isoi Cristo ie comɨnɨna sedaite. ");
INSERT INTO huuNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Jesús dɨnena jɨcanote: —Naimɨedɨ David mɨcorɨ isoidena, ¿bue ñellena David mɨcorɨ “Cristodɨ cue Nama” llote? Jusiñamui Joreñodɨ David mɨcorɨ ñaɨtatajanona, David mɨcorɨ llote: ");
INSERT INTO huuNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Jusiñamuidɨ cue Namamo llote: “Illaɨmana o illamona, cue nabei dɨne ana raɨ. Ona ɨɨnoñedɨno o anamo itataitɨcue”. ");
INSERT INTO huuNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“Cristodɨ cue Nama” David mɨcorɨ raite. Iese naimɨe mɨcorɨ railla jira, Cristo David mɨcorɨ afemo faɨte. Naimɨedɨ jamai David mɨcorɨ jitoñede; ia jɨaɨ ie Nama. ");
INSERT INTO huuNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Uaina onidɨmacɨ. Naie facaisemona Jesús ie uaina dane uaitañedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Jusiñamui jofomo Jesús nia illanona, naimɨe dɨne ailluena comɨnɨ bitɨmacɨ. Ie llofueoicaigano nainomo jɨaɨ illanona, nana naimacɨmo llote: ");
INSERT INTO huuNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Moisés mɨcorɨ llogacɨnuaɨna llofueraɨnɨdɨ naie rafuedo jai jaicabidɨmacɨ. Fariseuaɨ comɨnɨ iedo jɨaɨ jaicabidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Naimacɨ llofuiacɨnodo omoɨ jai. Naimacɨ llofuiana omoɨ cacarefi; iadedɨ naimacɨ illa isoi omoɨ iñeno, naimacɨ llofuiacɨnodo naimacɨ jaiñena jira. ");
INSERT INTO huuNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Omoɨ einamacɨ llogacɨnuaɨdo raise omoɨ jaillena, dɨga rafuena omoɨ fɨnuana jitaidɨmacɨ; iadedɨ iedo omoɨ jaillena, omoɨna jaca canoñedɨmacɨ. “Jusiñamuina eo raise sedadɨcaɨ” comecɨna facadɨmacɨ. Iemo naimacɨ comecɨna facajamona, ");
INSERT INTO huuNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","iena omoɨ cɨoillena, nana naimacɨ fɨnua rafuena marefodo fɨnodɨmacɨ. Jɨaɨe comɨnɨmo ite Jusiñamuimo jɨɨrabe baɨfemo faɨtɨbena uiacacabidɨmacɨ. Ɨniroi fuedadɨ aillofena jonegana gaɨdɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Rafue ia, naimacɨ jamai bue isoiñedɨnomo comecɨna facajanona, rafue nama ecɨmo raɨacadɨmacɨ. Ofiracomo uicomo raɨacadɨmacɨ, comɨnɨ naimacɨri acarillena. ");
INSERT INTO huuNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Nɨne naimacɨ jaia, nana comɨnɨ naimacɨna uaiduana gaɨdɨmacɨ. Maestrodɨcɨnona uaiduana jɨaɨ gaɨdɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Jusiñamuina eo raise naimacɨ sedajana omoɨ uiñuana jitaidɨmacɨ. Naimacɨ isoi iñeno. Omoɨ damacɨna jira, omoɨmona damɨe omoɨ baɨfemo faɨamo comecɨna facañeno. Naimɨena maestrona raiñeno. Omoɨ baɨfemo cue illanona, omoɨ maestrodɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Omoɨ Moo Jusiñamui monamo illanona, dama naimɨena seda. Jɨaɨmɨena sedañeno. Jusiñamui isoi jɨaɨmɨena “Moo” raiñeno. ");
INSERT INTO huuNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Omoɨ damacɨna jira, omoɨmona damɨena “Caɨ illaɨma” raiñeno. Omoɨ illaɨmana jai itɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Omoɨmona bu imɨena jaiacania, omoɨ mullaɨmana naimɨe nano jaillamona, omoɨna naimɨe canua. ");
INSERT INTO huuNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Jusiñamuidɨ “Jɨaɨno afemo itɨcue” raillano comecɨna facadɨmɨena jamai bue isoidɨmɨena itataite; ia Jusiñamuidɨ “Jɨaɨno afemo iñedɨcue” raillano comecɨna facadɨmɨena jamai bue isoiñedɨmɨena itataite. ");
INSERT INTO huuNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Naie facaise Moisés mɨcorɨ llogacɨnona llofueraɨnɨdɨ fariseuaɨ comɨnɨ dɨga illanona, Jesús naimacɨmo llote: —Jusiñamui omoɨna duere fɨnoite. Mareuidɨnona abɨ caitadɨnodomoɨ. Jusiñamui dɨbeimo comɨnɨ illana jitaiñedomoɨ. Naimɨe dɨbeimo omoɨ illana jɨaɨ jitaiñedomoɨ. Ie muidona Jusiñamuimona duere sefuitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Jusiñamuina eo sedadɨmacɨ” omoɨmo comɨnɨ comecɨaɨna facajana jitaidomoɨ. Ie jira are jɨɨdomoɨ; iadedɨ iese iñedomoɨ. Maraiñede rafuena fɨnocabidomoɨ. Jɨfuianona fecɨñuaɨ rana baɨrocabidomoɨ. Ie jira Jusiñamui omoɨna eo duere fɨnoite. ");
INSERT INTO huuNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Damɨena omoɨ dɨbeimo itatallena, omoɨ isoi Jusiñamui rafuedo naimɨe jaillena, dɨga rafuena fɨnodomoɨ. Omoɨ dɨbeimo illa mei, omoɨ baɨfemo omoɨ einamacɨ llogacɨnodo naimɨe jaillana jitaidomoɨ. Omoɨ dɨga ɨco naimɨe ua faɨfite. Comɨnɨna uanaiñedɨcɨnodo jaitatomoɨ. Iese omoɨ illa jira, duere sefuitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’Omoɨ llofuiacɨno dɨga comɨnɨna canoñedomoɨ. Mareuidɨnona abɨ caitadɨnodomoɨ. Raicabitomoɨ: “Caɨ lloga uai caɨ fɨnollena jɨaɨ comɨnɨ uiñollena, Jusiñamui jofomo ite oro mamecɨna llɨnotɨcaɨ; iadedɨ Jusiñamui jofo mamecɨna caɨ llɨnoia, caɨ lloga uaina caɨ fɨnoñenia, caɨmona mare. Jusiñamuimona duere sefuiñeitɨcaɨ” raicabitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Abɨ uiñoñedomoɨ. Omoɨ llofuiacɨno dɨga comɨnɨna canoñedomoɨ. Jusiñamui jofomo naie oro jaɨnaɨaɨlla jira, naie orodɨ mare; iadedɨ naie oro naie jofo baɨfemo uaiñede. Abɨna omoɨ uiñoñena jira, Jusiñamui omoɨna duere fɨnoite. ");
INSERT INTO huuNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Jɨaɨ raitomoɨ: “Jusiñamuimo faga toɨca ocaina jobaisoillano mamecɨna caɨ llɨnoia, caɨ lloga uaina caɨ fɨnoñenia, caɨmona mare; iadedɨ Jusiñamuimo fecaca toɨca ocaina mamecɨna caɨ llɨnoia, caɨ lloga uaina jaca fɨnoitɨcaɨ”. ");
INSERT INTO huuNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Abɨ uiñoñedomoɨ. Omoɨ llofuiacɨno dɨga comɨnɨna canoñedomoɨ. Naie jobaisoillanomo naie ocaina illa jira, naie ocaina mare; iadedɨ naie ocaina naie jobaisoillano baɨfemo uaiñede. ");
INSERT INTO huuNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ero, Jusiñamuimo ocaina jobaisoillano mamecɨna omoɨ llɨnoia, nainomo ite ocaina mamecɨna jɨaɨ llɨnotomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Jusiñamui jofo mamecɨna omoɨ llɨnoia, Jusiñamui nainomo illa jira, naimɨe mamecɨna jɨaɨ llɨnotomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Monamo ite ra mamecɨna omoɨ llɨnoia, Jusiñamui illano nainomo illa jira, nainomona comɨnɨna naimɨe sedaja jira, naimɨe mamecɨna jɨaɨ llɨnotomoɨ. Omoɨ llua rafuena omoɨ fɨnoñenia, Jusiñamui omoɨna duere fɨnoite. ");
INSERT INTO huuNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’Mareuidɨnona abɨ caitadɨnona omoɨ illamona, omoɨmo nia lloitɨcue. Nana omoɨ illɨmo ite ramona, nana omoɨmo ite ucubemona Jusiñamuimo janore jisa fecacabidomoɨ. Nana comɨnɨ omoɨ isoi illena jitaidomoɨ. Mare; iadedɨ nanoca rafuena jaca fɨnoñedomoɨ. Jɨaɨe comɨnɨmo omoɨ comecɨna facañedomoɨ. Jɨaɨe comɨnɨna duenaiñedomoɨ. Omoɨ lloga uaina fɨnoñedomoɨ. Nana naie isoide rafuena omoɨ jɨaɨ fɨnua. Iena omoɨ fɨnoñenia, Jusiñamui omoɨna duere fɨnoite. ");
INSERT INTO huuNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Abɨna uiñoñedomoɨ. Jallecɨma jiroracomo ia, iena oni faɨga; ia aillue ra nainomo ia, iena cɨoiñeno namo gutadomoɨ. Ie isoide. Omoɨ llofuiacɨno dɨga comɨnɨna canoñedomoɨ. Jusiñamui ie eo jitailla rafuedo comɨnɨ jaillana llofueñedomoɨ. Nanocafueñededo comɨnɨ jailla rafuena llofuetomoɨ. Nanoca rafuedo comɨnɨ jaillana llofueñedomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’Omoɨmo nia lloitɨcue. Omoɨ einamacɨ llogacɨnodo eo jaidomoɨ; iadedɨ omoɨ comecɨaɨna raise fɨnoñedomoɨ. Eo fɨɨdomoɨ. Jɨfuianona comɨnɨ rana baɨrodomoɨ. Jeacɨnona fɨnocana jaidomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Abɨna uiñoñedomoɨ. Da pocillos jɨnafo, da platos jɨnafo jocodɨno isoidomoɨ. Pocillos jerai, platos jerai jocoñedɨno isoidomoɨ. Omoɨ abɨna fɨnodomoɨ; iadedɨ omoɨ comecɨaɨna raise fɨnoñedomoɨ. Nano omoɨ comecɨna raise fɨno. Mare rafue fɨnocana jai. Omoɨ einamacɨ rafuemo comecɨna facañeno; ia Jusiñamui rafuemo comecɨna faca. Iese omoɨ jaiñenia, Jusiñamui omoɨna duere fɨnoite. ");
INSERT INTO huuNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’Omoɨmo nia lloitɨcue. Marena fɨnoca raɨafo isoidomoɨ. Jinofe marena eruaɨde; iadedɨ nainomo mare ra iñede. Comɨnɨ illaicɨ jamai ite. Jai maraiñede. ");
INSERT INTO huuNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ie isoidomoɨ. Marena eruaɨdomoɨ; iadedɨ maredɨnona abɨ eo caitadomoɨ. Omoɨ comecɨaɨ eo maraisɨñede. Omoɨ comecɨna raise omoɨ fɨnoñenia, Jusiñamui omoɨna duere fɨnoite. ");
INSERT INTO huuNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’Omoɨmo nia lloitɨcue. Naimacɨmo birui omoɨ comecɨaɨna raise facallena, Jusiñamui facaina lloraɨnɨ mɨcorɨaɨ raɨafona marena eruaɨllena fɨnodomoɨ. Mareuidɨno mɨcorɨaɨ raɨafo emodo marena eruaɨllena fɨnodomoɨ, ");
INSERT INTO huuNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","raillano: “Caɨ jaiagaɨ Jusiñamui facaina lloraɨnɨ mɨcorɨaɨna meinetɨmacɨ. Naie facaiseconi itɨcaɨdena, naimacɨ isoi fɨnoñedɨcaɨ. Caɨ jaiagaɨ isoi birui iñedɨcaɨ” raitomoɨ; ");
INSERT INTO huuNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","iadedɨ omoɨ lluamona Jusiñamui facaina lloraɨnɨ mɨcorɨaɨ meinetɨno uruiaɨ omoɨna uiñotɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Omoɨ jitailla jira, omoɨ jaiagaɨ isoi jeacɨnona eo fɨnocana mai jai. Naimacɨ jai taɨneca rafuena mai omoɨ fɨnocana jai. ");
INSERT INTO huuNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Omoɨ maraiñena jira, jaio naɨraɨ isoidomoɨ. Ja muidomo iraimona jillobiñeitomoɨ. Nainomo duere sefuitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Cue rafuena llollena, cue facaina lloraɨnɨna omoɨ dɨne oretaitɨcue. Cue rafuena eo uiñotɨnona omoɨ dɨne oretaitɨcue. Cue rafuena omoɨ raise uiñollena, llofueraɨnɨ omoɨ dɨne jɨaɨ oretaitɨcue. Dajeriena meineitomoɨ. Naimacɨna coraɨitomoɨ. Omoɨ ofiracomo dajeriena faitomoɨ. Dɨga naɨraɨmo naimacɨna duere fɨnoitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Abel mɨcorɨ jaie ite. Naimɨe maremɨe. Ie ama naimɨena meinete. Naimɨe facaisemona omoɨ jaiagaɨ ailluena mare comɨnɨna meinetɨmacɨ. Ie mei omoɨ jaiagaɨ Zacaríana meinetɨmacɨ. Naimɨedɨ Berequías jito. Jusiñamui jofomo Jusiñamuimo toɨca ocaina jobaisoillano ecɨmo naimɨena meinetɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Uanaicɨno omoɨmo lloitɨcue. Naimacɨna omoɨ jaiagaɨ meinia muidona, omoɨmona Jusiñamui birui ɨbana oite. Naimacɨ isoi maraiñede rafuena fɨnocana jaidomoɨ. Jusiñamui omoɨna duere fɨnoite. ");
INSERT INTO huuNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jesús llote: —Jerusalémo itɨno, omoɨmo rafuena lloiacadɨcue. Jusiñamui facaina lloraɨnɨna jaie meinetomoɨ. Naimɨe omoɨ dɨne oretaganona nofɨcɨna faɨrɨnuano, naimacɨna meinetomoɨ. Omoɨna cue sedallena, atava ie uruiaɨ sedaja isoi, dɨga icaiño cue anamo omoɨna uaidoiacadɨcue; iadedɨ omoɨ dɨnena cuena jitaiñedomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Iemona Jusiñamuidɨ omoɨ illanona jai faɨnonocaide. ");
INSERT INTO huuNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Cue Moo dɨne jaitɨcue. Cue jailla mei, cuena cɨoiñeitomoɨ. Ɨco abɨdo cue bia, omoɨ comɨnɨ cuena lloitɨmacɨ: “Jusiñamui oretagamɨe eo mare. Naimɨedɨ caɨ Nama” lloitɨmacɨ ");
INSERT INTO huuNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jusiñamui jofomona ie llofueoicaigano dɨga Jesús jino jaidemo, Jesúna nai jofona eruaɨtatɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Jesús dɨnena llote: —Bie jofona cɨodomoɨ. Uanaicɨnona omoɨmo lloitɨcue. Nana bie jofomo ite nofɨcɨaɨ ɨco judaɨsite —llote. ");
INSERT INTO huuNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ie mei Olivos railla anedu dɨne rillanona, Jesús naie muidomo raɨdemo, ie llofueoicaigano naimɨemo iena anado llotɨmacɨ: —Jusiñamui jofo judaɨana omo jɨcanoiacadɨcaɨ. ¿Nɨruido iena suite? Caɨmo llono. O abɨdo billɨrui iaɨrei ia, ¿nɨe isoide rafue suite, o abɨdo billɨruina caɨ uiñollena? ");
INSERT INTO huuNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Uai ote: —Omoɨna bie rafuena bu jɨfueñellena, omoɨ abɨna rairui. ");
INSERT INTO huuNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ailluena comɨnɨ cue mamecɨdo billanona: “Cristodɨcue” raitɨmacɨ. Dɨga comɨnɨna jɨfueitɨmacɨ. Iemona omoɨ abɨna rairui. ");
INSERT INTO huuNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Jobaimiaɨ illena fɨdɨitomoɨ; iadedɨ jacɨruiñeno. Iese suite; iadedɨ abɨdo nia biñeitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Daje naɨraɨ jɨaɨe naɨraɨ dɨga jobairitɨmacɨ. Daje gobierno jɨaɨe gobierno dɨga jobairite. Dɨga illanuaɨmo comɨnɨ aime guitɨmacɨ. Dɨga illanuaɨmo ñuisañuaɨ suite. ");
INSERT INTO huuNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Iese suia, omoɨ duere sefuillɨfue omoɨmo suite. ");
INSERT INTO huuNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Cuena ɨɨnoñedɨno omoɨna gaɨtatajanona, omoɨna meineitɨmacɨ. Cue comɨnɨna omoɨ illamona, nana naɨraɨaɨ omoɨna enoitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Naie facaise cue dɨbeimo itɨnomona ailluena abɨdo danomo jaitɨmacɨ. Iemona duere omoɨ sefuillena, omoɨna janoñeitɨmacɨ; iadedɨ omoɨna enoillamona, omoɨna llogɨdoitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Naie facaise dɨga comɨnɨ raitɨmacɨ: “Jusiñamui facaina lloraɨnɨdɨcaɨ”; iadedɨ Jusiñamui facaina lloraɨnɨñedɨmacɨ. Uanaicɨnona lloñeitɨmacɨ. Dɨga comɨnɨ naimacɨ dɨbeimo itataitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Jeacɨno eo comuicana jailla jira, ailluena comɨnɨ coninɨ isiruiñeitɨmacɨ; ");
INSERT INTO huuNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","iadedɨ cuena faɨnonocaiñedɨmɨe ja muidomo monamo jaca iite. Naimɨena jillotaitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Dɨga comɨnɨdɨ Jusiñamui dɨbeimo comɨnɨ ille rafuena nana naɨraɨmo lloitɨmacɨ, nana naɨraɨaɨ iena cacaillena. Ie mei abɨdo biitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’Cue lluamo cacarei. Daniel mɨcorɨ Jusiñamui facaina lloraɨma. Naimɨe mɨcorɨdɨ jɨaɨmɨe jearede rafue fɨnollena jaie llote. Naie rafue suia, Jusiñamui jofomo Jusiñamuina sedañeitomoɨ. Nainomo naie jearede rafue fɨnuana omoɨ cɨuanona, ");
INSERT INTO huuNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","naiemona omoɨ jillobillena, duere omoɨ sefuiñellena, Judeamo omoɨ illamona, aneduaɨ dɨne omoɨ aisɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Jofo emodomo omoɨ ia, ana billanona, aneduaɨ dɨne raɨre rillena, jofomo jaiñeno. Nainomo ite rana omoɨ dɨga uiñeno. ");
INSERT INTO huuNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Aneduaɨ dɨne raɨre rillena, illɨmo omoɨ ia, abɨdo jofomo biñeno, omoɨ ɨniroi omoɨ dɨga uillena. ");
INSERT INTO huuNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Naie rafuemona jillobillena, naie facaise urueside rɨño duere sefuite. Uruena nia jirode rɨñodɨ jɨaɨ duere sefuite. ");
INSERT INTO huuNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Eo duere sefuiñellena, Jusiñamuimo omoɨ jɨcano, rollime facaiseconi bie rafue suiñellena. Moisés mɨcorɨ sábadomo are jaillana jaie rairuide. Sábadoruimo bie rafue suiñellena, Jusiñamuimo jɨcano. ");
INSERT INTO huuNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Naie facaise comɨnɨ eo duere sefuitɨmacɨ. Enɨrue fɨnua facaisemona iese comɨnɨ nia duere sefuiñedɨmacɨ. Ɨco iese eo duere sefuiñeitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Naie facaise ianori fo Jusiñamui oñeitena, buna jaca jillobiñeite. Naimɨe fetocano muidona, naie facaise Jusiñamui ianori fo oite. ");
INSERT INTO huuNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Ie facaise omoɨmo bu raia: “Jadi, Jusiñamui facaina lloraɨma benomo birui bairede. Naimɨedɨ Cristo”, iena ɨɨnoñeno. Jɨaɨmɨe raia: “Oni batɨne Cristo birui bairede”, iena ɨɨñoñeno. ");
INSERT INTO huuNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Cristona abɨ caitadɨno biitɨmacɨ. Jusiñamui facaina lloraɨnɨna abɨ caitadɨno jɨaɨ biitɨmacɨ. Siño rafuena fɨnuanona, comɨnɨna jɨfueitɨmacɨ. Jusiñamui fetoca comɨnɨna ua jɨfueitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ero, bie rafue nia suiñenia, iena omoɨmo jai llotɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Omoɨmo naimacɨ raia: “Ero, batɨne jofue iñenanomo Cristodɨ ite”, nainomo jaiñeno. Naimacɨ raia: “Ero, bene bie jofomo Cristo ite”, iena ɨɨnoñeno. ");
INSERT INTO huuNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Mona borillamona mona jillacɨdɨ usere cɨode. Nana comɨnɨmo bairede. Ie isoide. Cue abɨdo bia, nana comɨnɨ iena uiñoitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Urujaisaɨ rɨfaide ramo ofillana uiñua isoi, nana cuena ɨɨnotɨno cue billena uiñoitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Jesús llote: —Naie duere sefuilla facaise meinoconi jitoma llɨgaiñoñeite. Fɨvui jɨaɨ llɨgaiñoñeite. Monamona ucuaɨ llujite. Nana naie radɨ jaidɨsite. ");
INSERT INTO huuNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ie mei monamo baireitɨcue. Ieconi nana naɨraɨaɨ jarire iitɨmacɨ. Jacɨnaitɨmacɨ. Uillɨe motodo cue billena cɨoitɨmacɨ. Ebire biitɨcue. Naimacɨna cue sedallena, illaɨmana biitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Cue jaɨenisaɨna cue ecɨmona oretaitɨcue. Ado trompeta fɨcɨretajano, cue fetocano dɨese naganomona ofitaitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Higuera railla riaramona omoɨ fueo. Bie enɨruemo naie riara fɨruillamona, fɨemona raɨre illana uiñotomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ie isoide. Bie rafue ɨco suia, cue billɨrui iaɨrei illena uiñoitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Uanaicɨnona omoɨmo lloitɨcue. Nana bie rafue suille facaiseconi bie naɨraɨ nia iite. ");
INSERT INTO huuNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Mona enɨrue dɨga fuite; iadedɨ cue lloga uai jaca suite. ");
INSERT INTO huuNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Cue abɨdo billɨrui jaca bu uiñoñede. Jusiñamui jaɨenisaɨ iena uiñoñedɨmacɨ. Jusiñamui Jitodɨcue; iadedɨ cue abɨdo billɨruina jɨaɨ uiñoñedɨcue. Dama cue Moo iena uiñote. ");
INSERT INTO huuNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Abɨdo cue billɨrui iaɨrei ia, Noé mɨcorɨ facaiseconi itɨno isoi comɨnɨ iitɨmacɨ. Naimacɨ duere sefuillemo Noé mɨcorɨ facaise itɨnodɨ comecɨaɨna facañedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Naie facaiseconi nia eo nocɨ deiñenia. Noé mɨcorɨ ecɨmo itɨno naimacɨ isoilla isoi icana jaidɨmacɨ. Jamai guicana jaidɨmacɨ. Aɨna ua mei, ɨnina ua mei, jebuicana jaca jamai jaidɨmacɨ. Danɨ iemo comecɨaɨna facauidɨmacɨ. Jusiñamuimo comecɨaɨna facañedɨmacɨ. Iese itɨmacɨ, Noé mɨcorɨ ie balsamo fo jailla dɨnori. ");
INSERT INTO huuNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Nia nocɨ deiñenia, Noé mɨcorɨ lloga uaina ɨɨnoñedɨmacɨ. Nocɨ deilla mei, ebena nana faɨfidɨmacɨ. Cue abɨdo bia, ie isoite. Ebena biitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Naie facaiseconi menamɨe illɨmo danomo iitɨiaɨmaiaɨ. Damɨe Jusiñamui dɨne jaite. Jɨaɨmɨe fɨebillanona, Jusiñamuimona duere sefuite. ");
INSERT INTO huuNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Mena rɨño danomo doberitɨiaɨñuaɨ. Dañaiño Jusiñamui dɨne jaite. Jɨaɨñaiño fɨebillanona, Jusiñamuimona duere sefuite. ");
INSERT INTO huuNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Cue billɨrui omoɨ uiñoñena jira, iemo ocuiri. ");
INSERT INTO huuNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Bie rafuemo omoɨ comecɨaɨna omoɨ faca. Jofo namadɨ fɨɨriraɨma nɨe naɨona billena uiñotena, ie rana faɨfiñellena, ie jofona raise sedade. ");
INSERT INTO huuNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ie isoi cue billemo ocuiri. Monamona ɨco abɨdo biitɨcue. Omoɨ ocuiriñena facaisemo riitɨcue. Ie jira cue billemo nagarui ocuiri. ");
INSERT INTO huuNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Jesús llote: —Cue billena omoɨ raise cacaillena, jɨaɨe rafuedo iena lloitɨcue. Patrón daje mullaɨmana ie jofona sedatate. Naie mullaɨma ɨɨnogamɨe. Abɨna uiñotɨmɨe. Nainomo itɨnona raise ecacabide. Naie mullaɨmana ie jofona sedataja mei, naie patrón oni jaide. ");
INSERT INTO huuNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Patrón ɨco abɨdo bia, ie jofona ie mullaɨma raise sedaia, mullaɨmari naimɨe iobillamona, ie mullaɨma marena iite. ");
INSERT INTO huuNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Iobillamona, patrón ie mullaɨmana nana ie raruiaɨna sedatataite; ");
INSERT INTO huuNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","iadedɨ ie mullaɨma maraiñenia, ie comecɨna facaite: “Cue patrón are biñeite. Naimɨe lloga uaina fɨnoñeitɨcue”. ");
INSERT INTO huuNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ie comecɨna iese facaja jira, naimɨe anamo ite mullaɨaɨna faite. Ie jitailla rafue fɨnuamona, jɨfairuidɨno dɨga jirocabite. Naimacɨna nabaillamona, naimacɨ dɨga guite. Naimacɨ isoi jearede rafuena fɨnoite. ");
INSERT INTO huuNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ie ocuiriñena facaise ie patrón abɨdo billanona, naimɨena duere fɨnoite. ");
INSERT INTO huuNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ie isoide. Cue abɨdo bia, cuena ɨɨnotɨnori iobitɨcue; ia cuena ɨɨnotɨnona abɨ caitadɨno dɨne cuena ɨɨnoñedɨnona dotaitɨcue. Nainomo duere sefuillano eeitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Jesús llote: —Abɨdo cue bia, Jusiñamui ie comɨnɨna sedaite. Cue billemo ocuiritɨnona sedaite. Naie facaise ite comɨnɨdɨ diez jitaɨñuaɨmo ite rafue isoidɨmacɨ. Naiñaiñuaɨ lamparínɨaɨ llɨnuanona, ɨima ie aɨna ua meinomo fɨnoca rafuemo jaiacadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","4","Lamparínɨaɨ unellena, farena naiñaiñuaɨ uilla jira, cinco dɨga abɨna uiñotɨmacɨ. Farena naiñaiñuaɨ uiñena jira, cinco dɨga abɨna uiñoñedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ɨima dɨga ie rafue dɨne jaillemo ocuiridɨmacɨ. Ɨima are biñena jira, ɨnɨdɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Daje dɨberuise damɨe ado lluana cacadɨmacɨ. Llote: “Jadi, naie ɨimadɨ jai bite. Mai bi, naimɨe uicomo naimɨemo caɨ dafaɨfillesa”. ");
INSERT INTO huuNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Casillanona, naie jitaɨñuaɨ lamparínɨaɨ unedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Abɨ uiñoñedɨñaiñuaɨ dɨnena abɨ uiñotɨñaiñuaɨmo jɨcadɨmacɨ: “Farena caɨmo feca. Caɨ lamparínɨaɨ boacaiñedesa”. ");
INSERT INTO huuNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Uai otɨmacɨ: “Fecaacaiñedɨcaɨ. Omoɨmo caɨ fecaiadedɨ, caɨmo baiñeite. Omoɨ jitaia, chinganomo ɨbajai”. ");
INSERT INTO huuNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Naiñaiñuaɨ ɨbajailla mei, naie ɨima ride. Naimɨemo ocuiridɨñaiñuaɨ dɨese naimɨe dɨga nainomo guillena, rafuemo jaidɨmacɨ. Naimacɨ fo jailla mei, nase naie ɨima ɨbaide. ");
INSERT INTO huuNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ie mei naie farena ɨbajaidɨñaiñuaɨ abɨdo billano, raitɨmacɨ: “Nase econo”. ");
INSERT INTO huuNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Naie ɨima uai ote: “Uanaicɨnona omoɨmo lloitɨcue. Omoɨna uiñoñedɨcue. Econoñeitɨcue”. ");
INSERT INTO huuNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ie isoide. Cue billɨruina omoɨ uiñoñena jira, nagarui cuemo omoɨ ocuiri. ");
INSERT INTO huuNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Jesús llote: —Abɨdo cue bia, Jesiñamui ie comɨnɨna sedaite. Naie facaise ite comɨnɨ daje patrómo ite rafue isoide. Patrón jɨaɨe enɨrue jaiacana jira, ie mullaɨaɨna ie ucubena eenotade. ");
INSERT INTO huuNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Damɨemo cinco dɨga ucubena fecade. Jɨaɨmɨemo menacubena fecade. Jɨaɨmɨemo dacubena fecade. Nagamɨe ie maɨjɨlle dɨnori fecade. Ie mei oni jaide. ");
INSERT INTO huuNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Cinco dɨga ucubena feiñotɨmɨe jaillanona, iena fecallena, rana ɨbade. Iemona jɨaɨe cinco dɨga ucubena ote. ");
INSERT INTO huuNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Menacubena feiñotɨmɨe iena fecallena, rana ɨbade. Iemona jɨaɨe menacubena ote. ");
INSERT INTO huuNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Daucubena feiñotɨmɨe enɨruemo naie ucube eenote. Iena fecallena, rana ɨbañede. Iemona buena oñede. ");
INSERT INTO huuNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Dɨgarui illanona, naie patrón abɨdo bite. Naimacɨ cuentas siadollena, ie mullaɨaɨna uaidote. ");
INSERT INTO huuNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Cinco dɨga ucubena feiñotɨmɨe bite. Ie ucube atɨano raite: “Patrón, cinco dɨga ucubena cuemo fecadɨo. Jɨaɨe cincona otɨcue”. ");
INSERT INTO huuNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Patrón uai ote: “Raise marena maɨjɨdɨo. Eo mare mullaɨmadɨo. Janore ucube o raise sedaja jira, ona ailluena rana sedataitɨcue. Cue dɨga caɨmare jaca iitɨo”. ");
INSERT INTO huuNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Menacubena feiñotɨmɨe bite. Raite: “Patrón, cuemo menacubena fecadɨo. Iemona jɨaɨe menacube otɨcue”. ");
INSERT INTO huuNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Naimɨe patrón uai ote: “Raise marena maɨjɨdɨo. Eo mare mullaɨmadɨo. Janore ucube o raise sedaja jira, ona ailluena rana sedataitɨcue. Cue dɨga caɨmare jaca iitɨo”. ");
INSERT INTO huuNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Daucubena feiñotɨmɨe bite. Raite: “Patrón, o rɨirenana uiñotɨcue. O mullaɨaɨ maɨjɨamona ganacabidɨo. ");
INSERT INTO huuNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ucubena cue faɨfiñellena ona jacɨruitɨcue. Ie jira enɨruemo o cuemo iga ucubena eenotɨcue. Jadi, iena jai abɨdo atɨdɨcue”. ");
INSERT INTO huuNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Patrón uai ote: “Maraiñedɨo. Rairaɨedɨo. Cue mullaɨaɨ maɨjɨamona cue ucube uana uiñotɨo. ");
INSERT INTO huuNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Bancomo naie ucubena jonetɨodena, naie ucubemona jɨaɨe ucube janore uamona, abɨdo cue bia, iena feiñotɨcue”. ");
INSERT INTO huuNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","30","Ie mullaɨaɨmo llote: “Naimɨemona ie ucubena baɨro. Diez ucube illamɨemo iena feca. Bie maraiñede mullaɨma jitɨredɨnomo cuemona oni dota. Nainomo comɨnɨ duere sefuillanona eeitɨmacɨ”. Jusiñamui ie jitailla rafuena fɨnodɨnona: “Mare” raite; iadedɨ ie jitaille rafuena fɨnoñedɨnona duere fɨnoite. Jusiñamui omoɨna duere fɨnoñellena, cue abɨdo billɨrui omoɨ uiñoñena jira, Jusiñamui jitaillacɨnona fɨnocana omoɨ jai. ");
INSERT INTO huuNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Jesús llote: —Omoɨna nia llofueitɨcue. Abɨdo cue bia, nana cue jaɨenisaɨ dɨga biitɨcue. Illaɨmana ɨco cue bia, illaɨma illa ifomo iitɨcue. Eo siño uaido biitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Cue uicomo nana naɨraɨaɨ ofitɨmacɨ. Toɨca llaudaɨaɨ sedaraɨma ie chivos motomona ie llaudaɨaɨ oni fetua isoi, naimacɨna fetoitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Cue jitaillacɨnona fɨnodɨno dɨese cue fetuanona, cue nabeimo itataitɨcue. Cue jitaillacɨnona fɨnoñedɨno dɨese cue fetuanona, cue jarɨfebeimo itataitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Cue illaɨmana jira, cue nabeimo itɨnomo lloitɨcue: “Cue Moo omoɨri iobillanona, omoɨna jai caɨmare itatate. Cue Moo comɨnɨna omoɨ illa jira, cue sedajanomo mai bi. Nainomo duidomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Cue jitaillacɨnona omoɨ fɨnuamona navui aimetaitɨcuemo, cuena ecadomoɨ. Jiroacadɨcuemo, jɨnui cuemo fecadomoɨ. Omoɨ naɨraɨ dɨne cue macaria, cuena omoɨ uiñoñeno omoɨ jofomo cuena feiñotomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ɨniroinidɨcuemo, ɨniroi cuemo fecadomoɨ. Duidɨcuemo, cuena canollena, cuena jɨbuisaɨbidomoɨ. Cárcelmo itɨcuemo, cuena canollena, cuena jɨbuisaɨbidomoɨ”. ");
INSERT INTO huuNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Cue jitaillacɨnona fɨnodɨno dɨnena cuemo jɨcanoitɨmacɨ: “Nama, ¿nɨruido aimetaitɨomo, ona ecadɨcaɨ? ¿Nɨruido jiroacadɨomo, jɨnui omo fecadɨcaɨ? ");
INSERT INTO huuNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Nɨruido ona cɨodɨcaɨ, caɨ jofomo ona feiñollena? ¿Nɨruido ɨniroina omo fecadɨcaɨ? ");
INSERT INTO huuNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Nɨruido duidɨomo, ona jɨbuisaidɨcaɨ? ¿Nɨruido cárcelmo itɨomo, ona jɨbuisaidɨcaɨ?” ");
INSERT INTO huuNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Uai oitɨcue: “Uanaicɨnona omoɨmo lloitɨcue. Cuena ɨɨnotɨnomona jamai bue isoidɨmɨena canodomoɨmo, cuena jɨaɨ canodomoɨ” lloitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Iemei cue jarɨfebeimo itɨnomo lloitɨcue: “Cuemona oni mai jai. Cue comɨnɨñedomoɨ. Jai faɨfidomoɨ. Duere omoɨ sefuillena, iraimo mai jai. Naie irai jaca duiñede. Jusiñamuidɨ naiena Taɨfe iena jai fɨnode. Jusiñamuidɨ Taɨfe comɨnɨ iena jɨaɨ jai fɨnode. ");
INSERT INTO huuNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Cue jitaillacɨnona omoɨ fɨnoñenamona, navui aimetaitɨcuemo, cuena ecañedomoɨ. Jiroacadɨcuemo, jɨnui cuemo fecañedomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Omoɨ naɨraɨ dɨne cue macaria, omoɨ jofomo cuena feiñoñedomoɨ. Ɨniroinidɨcuemo, ɨniroi cuemo fecañedomoɨ. Duidɨcuemo, cuena canollena, cuena jɨbuisaɨbiñedomoɨ. Cárcelmo itɨcuemo, cue canollena, cuena jɨbuisaɨbiñedomoɨ”. ");
INSERT INTO huuNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Cuemo jɨcanoitɨmacɨ: “¿Nɨruido aimetaitɨomo, ona ecañedɨcaɨ? ¿Nɨruido jiroacadɨomo, jɨnui omo fecañedɨcaɨ? ¿Nɨruido ona cɨodɨcaɨ, caɨ jofomo ona feiñollena? ¿Nɨruido ɨniroinidɨomo, omo fecañedɨcaɨ? ¿Nɨruido duidɨomo, ona jɨbuisaiñedɨcaɨ? ¿Nɨruido cárcelmo itɨomo, ona jɨbuisaiñedɨcaɨ?” ");
INSERT INTO huuNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Uai oitɨcue: “Uanaicɨnona omoɨmo lloitɨcue. Dɨga comɨnɨ cuena ɨɨnotɨmacɨ. Naimacɨmona jamai bue isoidɨmɨena omoɨ canoñena jira, cuena canoñedomoɨ” lloitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Naimacɨ jaca isi cacaitɨmacɨ; iadedɨ cue jitaillacɨnona fɨnodɨno cue Moo sedajanomo jaca iitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ie llofueoicaiganona llofuia mei, naimacɨmo Jesús llote: ");
INSERT INTO huuNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Pascua railla rafue illena, menarui fɨebide. Iena uiñotomoɨ. Monamona jaie cue billamona, ɨimana jaidɨcue. Cue fiodaillena cue Moo cuena oretate. Illaɨcomɨnɨ cuena coraɨllena, birui cuena gaɨtaitɨmacɨ —llote. ");
INSERT INTO huuNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Naie facaiseconi Jusiñamui dɨga nanoca ñaɨraɨnɨdɨ, jɨaɨe illaɨcomɨnɨ dɨga, nanoca ñaɨraɨma jofomo ofidɨmacɨ Nanoca ñaɨraɨmadɨ Caifás. ");
INSERT INTO huuNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Jesúna jɨfuiano gaɨtallena coninɨri siadotɨmacɨ. Naimɨena meinellena jɨaɨ siadotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Raitɨmacɨ: —Pascua railla facaise naimɨena nia gaɨtañeitɨcaɨ. Naie facaise naimɨena caɨ gaɨtataia, iena gaɨñenamona, comɨnɨ caɨ dɨga fuiritɨmacɨ. Nia sedaitɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Betania railla naɨraɨmo Jesús jaillanona, Simón jofomo jaide. Simódɨ jaie efonaitɨmɨe. ");
INSERT INTO huuNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Naifomo mesamo Jesús guitemo, daje rɨñodɨ nofɨcɨmona fɨnoca frasco atɨano, naie frasco llaillanona, nainomo ite caɨmare soride ra naimɨe ɨfogɨmo totade. Naie ra eo raifide. ");
INSERT INTO huuNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Jesús llofueoicaigano iena cɨuanona, icɨritɨmacɨ. Coninɨri danɨ ñaɨtɨmacɨ: —Naie caɨmare soride ra jamai dotade. Jai faɨfide. ");
INSERT INTO huuNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Iena fecacadena, eo ailluena raifide. Naie ucube dueredɨnomo fecadena, caɨmona mare. ");
INSERT INTO huuNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Naimacɨ ñaɨana Jesús uiñua jira, naimacɨmo llote: —¿Bue ñellena naiñaiñona jeare ñaɨtomoɨ? Mare rafuena cuemo fɨnode. ");
INSERT INTO huuNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Omoɨ dɨga dueredɨno jaca itɨmacɨ; iadedɨ omoɨ dɨga jaca iñeitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Cue abɨmo bie caɨmare soride ra naiñaiño totajamona, cue fiodaillɨrui facaina naiñaiño iese fɨnode. ");
INSERT INTO huuNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Omoɨmo uanaicɨnona lloitɨcue. Nɨnomo cue mare fɨnoca rafuena bu lloia, naiñaiñona uibiñollena, nana comɨnɨmo naiñaiño fɨnoca rafuena lloite. ");
INSERT INTO huuNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ie facaise Jesús llofueoicaiganomona Judas Iscariote mɨcorɨ raillamɨedɨ Jusiñamui dɨga nanoca ñaɨraɨnɨ dɨne jaide. ");
INSERT INTO huuNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Naimacɨmo jɨcanote: —Omoɨmo Jesúna cue fecaia, ¿nɨga ucubena cuemo fecaitomoɨ? —jɨcanote. Naimacɨ siadua mei, treinta ucubena naimɨemo fecadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Naie facaiseconimona Jesúna gaɨtatallɨruimo naimɨe ocuiride. ");
INSERT INTO huuNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Pascua railla rafue ia, sɨritaga rana guiñedɨmacɨ. Danɨ llomenicona guitɨmacɨ. Egiptomona caɨ jaiagaɨ jillobillana comecɨllena, naie rafue ite. Naie rafue taɨniaruimo ie llofueoicaigano Jesús dɨne billano, jɨcanotɨmacɨ: —¿Nɨnomo pascua railla rafue ie guille fɨnuana jitaidɨo? ");
INSERT INTO huuNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Uai ote: —Jerusalémo omoɨ jaillanona, omoɨmo cue llogamɨena omoɨ cɨuanona, naimɨemo llono: “Caɨ llofueraɨma fiodaille facaise iaɨrei ite. O jofomo ie llofueoicaigano dɨga pascua rafuena fɨnoacade” llono. ");
INSERT INTO huuNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ie muidona ie llofueoicaiganodɨ ie lluana fɨnodɨmacɨ. Pascua railla rafue guille fɨnodɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Nairui jitoma ana itemo, Jesús ie doce llofueoicaigano dɨga nainomo guisaide. ");
INSERT INTO huuNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Naimacɨ mesamo guitɨmacɨmo, Jesús llote: —Omoɨmona damɨe cuena gaɨtataite —llote. ");
INSERT INTO huuNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Iena cacajanona, eo sunaitɨmacɨ. Damɨerie naimɨemo jɨcanosɨde: —¿Cuena ñaɨtɨo? ");
INSERT INTO huuNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Uai ote: —Omoɨmona damɨe bie platomo cue dɨga llomenico dɨga mutade. ");
INSERT INTO huuNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Jusiñamui facaina lloraɨma cuega isoi, monamona jai billamona fiodaitɨcue; iadedɨ cuena gaɨtataitɨmɨe eo duere sefuite. Naimɨe jeicɨñegadena, cuemona mare. ");
INSERT INTO huuNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Jesúna gaɨtataitɨmɨedɨ Judas mɨcorɨ. Naimɨe jɨcanote: —Maestro, ¿ona iese fɨnotaitɨcue? Uai ote: —Jɨɨ, iese fɨnotaitɨo. ");
INSERT INTO huuNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Naimacɨ nia guitɨmacɨmo, llomenicona Jesús llɨnuanona, Jusiñamuimo iobillacɨnona fecaja mei, llomenicona taɨrude. Naimacɨmo fecajano raite: —Iena llɨnuano guiño. Bie llomenicodɨ cue abɨ facai ie. Cue abɨmo omoɨ comecɨna facajano, iena guiño. ");
INSERT INTO huuNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ie mei naimɨe jiroracona jɨaɨ llɨnote. Jusiñamuimo iobillacɨnona llua mei, naie jiroracomo jai totaca vino naimacɨmo fecajano, raite: —Biemona nana omoɨ jiro. ");
INSERT INTO huuNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Cue fiodaillamona, dama cue dɨaillamona, naimacɨ jeacɨno anamona ailluena biruimona jilloitɨmacɨ. Jusiñamuidɨ omoɨmo jɨaɨe rafue birui itatajanona, omoɨ jeacɨno oni dotajana jai llote. Bie vinodɨ naie rafue facai ie. Cue llua isoi bie vinona omoɨ jiruamona, cue fiodaillamo omoɨ comecɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Omoɨna bene dane iese caɨmare nabaiñeitɨcue. Cue Moo sedajanomo omoɨ dɨga cue ia, nainomo omoɨna dane iese caɨmare marena nabaitɨcue. —Iena jirodɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Naimacɨ guilla mei, Jusiñamuimo iobilla ruana rotɨmacɨ. Ie mei Olivos railla anedumo jaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Jesús naimacɨmo llote: —Cuemo suille rafue muidona, ja naɨo cuena faɨnonocaitomoɨ. Jusiñamui facaina lloraɨma mɨcorɨ iena jaie cuega: “Toɨca llaudaɨaɨ sedaraɨmana meinetaitɨcue. Naimɨe toɨnɨaɨ uaficaida jaitɨmacɨ” cuega. Naimɨe mɨcorɨ caɨna cuete. ");
INSERT INTO huuNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ero, fiodaillamona cue jillua mei, omoɨ uicodo Galileamo jaitɨcue, nainomo omoɨ dɨga dafaɨfillena. ");
INSERT INTO huuNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pedro uai ote: —O fɨnolle rafue muidona nana jɨaɨno ona faɨnonocaia, ona jaca faɨnonocaiñeitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesús dɨnena raite: —Uanai omo lloitɨcue. Ja naɨo ɨitava nia ñaɨñenia, dacaiño amani cuena janoitɨo. ");
INSERT INTO huuNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pedro uai ote: —O dɨga cue fiodaiadedɨ, ona janoñeitɨcue. Nana ie llofueoicaigano daje uaido jɨaɨ raitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Oni jaillanona, Getsemaní railla illanomo jaidɨmacɨ. Ie llofueoicaiganomo Jesús llote: —Beno ana raɨ. Omoɨmona oni baɨ janore jaitɨcue. Cue Moo dɨga ñaɨllena, jaitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Pedrona uite. Zebedeo ie jito iaɨmaiaɨna jɨaɨ uite. Naimɨe sunaicaide. Ie comecɨ uri iñede. ");
INSERT INTO huuNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Naimacɨmo llote: —Cue comecɨ sunaicaide. Niadɨ fiodaitɨcue. Benomo fɨebi; ia nia ɨnɨñeno cue facaina omoɨ jɨɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Naimɨe janore baɨ jaillanona, enɨruemo bɨtadate. Jɨɨde: —Ore Moo, o jitaia, cuena duere fɨnoñeno; iadedɨ cue comecɨ jitaillacɨnona fɨnoñeno. Cuemo o jitaillacɨno fɨno —jɨɨde. ");
INSERT INTO huuNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ie mei ie llofueoicaigano dɨne abɨdo billanona, naimacɨ ɨnɨsɨtemo ride. Naimacɨna casitajano, Pedromo jɨcanote: —¿Nɨese raɨre ɨnɨdɨo? daje hora nia iñedemo. ");
INSERT INTO huuNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ɨnɨñeno. Taɨfe ramo omoɨna faɨ raillano, iena omoɨ ɨɨnoñellena, Jusiñamuimo jɨɨ. Omoɨ comecɨ mare rafuena fɨnoacade; iadedɨ omoɨ comecɨ danɨ ocuiñoñede. Ie muidona Jusiñamuimo jɨɨ, omoɨna naimɨe ocuiñotallena —llote. ");
INSERT INTO huuNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ie mei dane jɨɨllena jaide. Raite: —Ore Moo, o jitaia, cue duere sefuillamona cuena jillota. Cue fiodaillana o jitaia, o jitailla rafuena fɨnoitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ie llofueoicaigano dɨne dane billanona, naimacɨ uisɨ llirɨoilla jira, naimacɨ ɨnɨsɨtemo ride. ");
INSERT INTO huuNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Abɨdo jaillanona dane jɨɨde. Aillɨ daje isoidɨuaido jɨɨde. ");
INSERT INTO huuNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ie mei ie llofueoicaiganomo dane billanona, llote: —Nia ɨnɨdomoɨ. Jafaicɨ nia otomoɨ. Monamona jaie billanona, ɨimana jaidɨcue; ia ja fiodaitɨcue. Cuena ja gaɨtajanona, Jusiñamui jitailla jira, naimɨena ɨɨnoñedɨno anamo ja iitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","A naidacai. Maiña. Cue gaɨtataitɨmɨe jai bite. ");
INSERT INTO huuNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesús nia ñaɨtemo, ieconi Judas mɨcorɨ bite. Naimɨe ie llofueoicaigamɨe. Dɨga comɨnɨ naimɨe dɨga bitɨmacɨ. Naimacɨ lloebɨna atɨdɨmacɨ. Butaralluna jɨaɨ atɨdɨmacɨ. Jusiñamui dɨga nanoca ñaɨraɨnɨmona bitɨmacɨ. Einamacɨ dɨnena jɨaɨ bitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Jesús dɨne naimacɨ nia riñenia, Judas mɨcorɨ naimɨe dɨga bitɨnomo jai llote: —Jesúna omoɨ uiñollena, naimɨena llibanoitɨcue. Ie mei naimɨena gaɨta —llote. ");
INSERT INTO huuNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Jesús dɨne naimacɨ rillanona, Judas mɨcorɨ Jesús dɨne raɨre jaide. Naimɨena uaidote: —Maestro, jai bitɨcue. —Ieconi naimɨena llibanote. ");
INSERT INTO huuNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesús dɨnena raite: —¿Bue ñiaɨbitɨo? Ie mei Judas mɨcorɨ dɨga bitɨnodɨ Jesúna gaɨtadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Iena cɨuanona, Jesús dɨga itɨnomona damɨe ie lloebɨ llɨnuanona, Jusiñamui dɨga nanoca ñaɨraɨma ie mullaɨma jefona jaɨbonote. ");
INSERT INTO huuNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jesús naimɨemo llote: —O fuiriacania, o jɨaɨ fiodaitɨo. O lloebɨ dane eeno. Cue rɨiduanona, fuiriñeno. ");
INSERT INTO huuNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Cuena rɨidollena, cue Moomo cue jɨcaia, eo ailluena jaɨenisaɨ cue dɨne naimɨe oretaite; ");
INSERT INTO huuNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","iadedɨ iese cuena rɨidoia, Jusiñamui facaina lloraɨnɨ mɨcorɨaɨ cuegafuiaɨ suiñeite. Cue fiodaille rafuena cuetɨmacɨ —llote. ");
INSERT INTO huuNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ieconi naimɨe dɨne bitɨnomo Jesús llote: —Omoɨ butaralluna uitomoɨ. Omoɨ lloebɨ dɨga jɨaɨ bitomoɨ. Fɨɨriraɨmadɨcueta cuena omoɨ gaɨtajaɨbilla. Jusiñamui jofomo nagarui llofuecabitɨcue; iadedɨ cuena gaɨtañedomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Nana bie rafue suide, Jusiñamui facaina lloraɨnɨ mɨcorɨaɨ cuegafuiaɨ suillena —llote. Ie facaise nana naimɨe llofueoicaigano naimɨena faɨnonocaillano, aisɨdɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Jesúna gaɨtadɨnodɨ Caifás jofomo Jesúna uitɨmacɨ. Caifás Jusiñamui dɨga nanoca ñaɨraɨma. Naimɨe jofomo jɨaɨe illaɨcomɨnɨ jai ofidɨmacɨ. Moisés mɨcorɨ llogacɨnona llofueraɨnɨ ofidɨmacɨ. Einamacɨ jɨaɨ ofidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Jesús jɨnafona Pedro aarena jaide. Caifás jofo naɨraɨbɨrɨmo jaide. Naie rafue fuiduana naimɨe uiñollena, nainomo ite jofomo maɨjɨraɨnɨ dɨga raɨde. ");
INSERT INTO huuNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Naimɨena meinellena, nana naie illaɨcomɨnɨ Jesúmo nɨcɨno illana uiñoiacadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Iena coninɨri siadotɨmacɨ; iadedɨ naimɨemo jaca nɨe isoide maraiñede rafue illana uiñoñedɨmacɨ. Dɨga comɨnɨ Jesúna ñaɨtɨmacɨ; iadedɨ taɨno llotɨmacɨ. Ie mei menamɨe bitɨiaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Raitɨiaɨmaiaɨ: —Bimɨe llote: “Jusiñamui jofona judaɨredɨcue. Judaɨa mei, darui amani illanona, iena dane fɨnoredɨcue” —llotɨiaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Jusiñamui dɨga nanoca ñaɨraɨma Jesúmo jɨcanote: —¿Nɨese iaɨmaiaɨ uai oitɨo? ¿Nɨe isoide rafue ona llogɨdotɨiaɨmaiaɨ? ");
INSERT INTO huuNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Jesús uai oñede. Naie ñaɨraɨma dɨnena llote: —Caɨ Jusiñamui cajede. Naimɨe caɨna uiñua jira, uanaicɨnona caɨ lloñenia, caɨna duere fɨnoite. Uanaicɨnona caɨmo llono. “¿Odɨ Cristodɨo?” omo jɨcanotɨcue. “¿Odɨ Jusiñamui Jitodɨo?” omo jɨcanotɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesús dɨnena uai ote: —Jɨɨ, naimɨedɨcue. Iena raise llotɨo. Monamona jaie cue billamona, ɨimana jaidɨcue:; iadedɨ ɨco jɨaɨruido illaɨmana cue illena, Jusiñamui ecɨmo cue raɨllana omoɨ naɨraɨ cɨoitɨmacɨ. Mona uillɨe motodo cue abɨdo billena jɨaɨ cɨoitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Iena cacajanona, naimɨemona Jusiñamuina Jesús jeare ñaɨa jira, naie nanoca ñaɨraɨma dama ie ɨniroina cuaranote. Raite: —Naimɨedɨ Jusiñamuina jeare ñaɨte. Jɨaɨe naimɨena llogɨdotɨnona jai jitaiñedɨcaɨ. Ie ñaɨamona dama naimɨe abɨna llogɨdote. ");
INSERT INTO huuNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Nɨese naimɨena raitomoɨ? Jɨaɨ illaɨcomɨnɨ dɨnena uai otɨmacɨ: —Naimɨe fiodaillesa. ");
INSERT INTO huuNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ie mei naimɨe uiecona tuallaɨtɨmacɨ. Naimɨena ducoɨdɨmacɨ. Jɨaɨ bucoɨdɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Raitɨmacɨ: —O Cristodɨodena, ¿bu o bucoɨa? caɨmo llono. Jesús uai oñede. ");
INSERT INTO huuNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Naie facaise Pedro naie jofo naɨraɨbɨrɨmo ite. Naie jofo nama mullaɨño naimɨe dɨne billanona raite: —Galileamona Jesús bite. Odɨ ie comɨnɨdɨo. Naimɨe dɨga jaicabidɨo —raite. ");
INSERT INTO huuNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Nana nainomo itɨnomo Pedro llote: —O lluana uiñoñedɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Nase fuemo Pedro jaidemo, naimɨena jɨaɨe mullaɨño cɨuanona, nainomo itɨnomo llote: —Bimɨedɨ Nazaret ie Jesús comɨnɨ imɨe. ");
INSERT INTO huuNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pedro uai ote: —Uanaicɨnona cue lluana Jusiñamuidɨ uiñote. O llogamɨena uiñoñedɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Dallu illanona, nainomo itɨno Pedro dɨne billano, naimɨemo llotɨmacɨ: —Ua Jesús comɨnɨ imɨedɨo, o uai bairia jira. Naimɨe isoi ñaɨtɨo. ");
INSERT INTO huuNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Uai ote: —Uanai cue lloñenia, Jusiñamui cuena duere fɨnoite. Uanaicɨnona cue lluana naimɨe uiñote. Ero, Jesúna uiñoñedɨcue. —Ieconi ɨitava ñaɨte. ");
INSERT INTO huuNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Iena cacajano, Pedro Jesús lluana uibiñote. Jaive Jesús Pedromo llote: “Ɨitava nia ñaɨñenia, dacaiño amani cuena janoitɨo” llote. Iena uibiñuanona, Pedro jino jaillano, sure eede. ");
INSERT INTO huuNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Monaidemo, nana Jusiñamui dɨga nanoca ñaɨraɨnɨdɨ, nana einamacɨ dɨga, Jesúna siadotɨmacɨ. Naimɨena meinellena siadotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Siadua mei, Jesúna maɨanona, Poncio Pilatomo uitɨmacɨ. Romanuaɨ railla naɨraɨ anamo naimacɨ illa jira, Pilatodɨ naimacɨ gobernador. ");
INSERT INTO huuNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judas mɨcorɨ Jesúna jai gaɨtatate. Naie illaɨcomɨnɨ Jesúna meiniana lluana naimɨe mɨcorɨdɨ uiñuamona, ie comecɨ iuaina meidote. Illaɨcomɨnɨmo ie treinta dɨga ucubena abɨdo atɨde. ");
INSERT INTO huuNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Raite: —Jesús maraiñede rafuena jaca fɨnoñede. Naimɨe fiodaiñeite. Naimɨena cue gaɨtatajamona, maraiñedɨcɨnona jai fɨnodɨcue. Uai otɨmacɨ: —¿Bue ñe caɨmo lluaɨbitɨo? O rafue caɨmo duiñede. ");
INSERT INTO huuNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ie mei Judas mɨcorɨ Jusiñamui jofo jeraimo naie ucubena fo jamai faɨte. Jino jaillanona, oni jaide. Dama naimɨe abɨna meinellena, cɨmaɨo llirɨnote raona. ");
INSERT INTO huuNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","7","Jusiñamui dɨga nanoca ñaɨraɨnɨ naie ucubena ɨraɨa mei, iena siadotɨmacɨ. Coninɨri raitɨmacɨ: —Naie isoide ucube nainomo joniana Moisés mɨcorɨ jaie rairuilla jira, Jusiñamui jofomo ite ucube ocabiranomo jonenidɨcaɨ. Naie ucube dɨga damɨe meinellena ɨbadɨcaɨ. —Ie jira naie ucube dɨga enɨruena ɨbadɨmacɨ. Naie illanodɨ jiñora ouilla enɨrue. Jɨaɨe naɨraɨmona bu bia, naimɨe fiodaia, naie enɨruemo naimɨena raɨllena, iena ɨbadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Naie ucube muidona damɨe fiodailla jira, birui naie enɨrue mamecɨdɨ dɨrue ie enɨrue. ");
INSERT INTO huuNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Iemona Jeremías mɨcorɨ jaie cuega rafue jai suide. Naimɨe mɨcorɨdɨ Jusiñamui facaina lloraɨma. Naimɨe mɨcorɨ cuega: “Caɨ Israel railla comɨnɨmona damɨerie railla jira, naimɨena meinellena, treinta ucubena fecaitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Naie ucube dɨga jiñora ocabilla enɨruena ɨbaitɨmacɨ, caɨ Nama Jusiñamui llua isoi” cuega. ");
INSERT INTO huuNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Pilato railla gobernador uicomo Jesúna atɨa mei, Pilato Jesúmo jɨcanote: —¿Judíuaɨ comɨnɨ illaɨmadɨo? Jesús uai ote: —Jɨɨ. Raise llotɨo. ");
INSERT INTO huuNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ie mei Jusiñamui dɨga nanoca ñaɨraɨnɨdɨ, einamacɨ dɨga, naimɨena llogɨdote; iadedɨ naimɨe dɨnena uai oñede. Ie abɨna rɨidoñede. ");
INSERT INTO huuNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ie muidona Pilato naimɨemo llote: —Dɨga rafuena ona llogɨdotɨmacɨ. ¿Nɨese uai oñedɨo? ");
INSERT INTO huuNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Jesús nia uai oñede. Ie jira Pilato uainicaide. ");
INSERT INTO huuNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Naga año pascua railla rafue facaiseconi cárcelmo itɨnomona Pilatodɨ comɨnɨ jɨcacamɨena jamai jino orede. ");
INSERT INTO huuNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Bie año cárcelmo Barrabás raillamɨe ite. Naimɨe mamecɨ eo are soride. ");
INSERT INTO huuNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Naie rafue illa jira, ailluena comɨnɨ naimɨe dɨne ofillano, naimacɨmo Pilato jɨcanote: —Bie año cárcelmona, ¿bumɨe jino cue oretajana jitaidomoɨ? Barrabás raillamɨe ite. Jesús raillamɨe jɨaɨ ite. Naimɨedɨ Cristona jɨaɨ mamecɨrede. ");
INSERT INTO huuNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Iese jɨcanote; iadedɨ naimɨedɨ Jusiñamui dɨga nanoca ñaɨraɨnɨ Jesúri uradoillana uiñote. Naimacɨ Jesúna meineiacanana jɨaɨ uiñote. ");
INSERT INTO huuNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ie maɨjɨracomo naimɨe nia illanona, naie facaise Pilato aɨ naimɨe dɨne rabe orede. Cuete: “Bimɨedɨ maraiñede rafuena jaca fɨnoñede. Naimɨena duere fɨnoñeno. Jaive naɨo cue nɨcaɨrillano, naimɨe muidona cue comecɨ jarire ite”. ");
INSERT INTO huuNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ailluena comɨnɨ Pilato dɨne ofillanona, Jusiñamui dɨga nanoca ñaɨraɨnɨdɨ, einamacɨ dɨga, comɨnɨmo llotɨmacɨ: —Pilato caɨmo jɨcanoia, Barrabás jino oretallena jɨca. Jesús meinellena jɨca —llotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Comɨnɨ ofilla mei, naimacɨmo Pilato dane jɨcanote: —¿Nɨmɨe cue jino oretajana jitaidomoɨ? Uai otɨmacɨ: —Barrabás. ");
INSERT INTO huuNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilato dɨnena jɨcanote: —¿Nɨese Jesúna cue fɨnuana jitaidomoɨ? Naimɨedɨ Cristona jɨaɨ mamecɨrede. Nana uai otɨmacɨ: —Naimɨena cruzmo coraɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilato dane jɨcanote: —¿Nɨe isoide maraiñede rafuena fɨnode? Naimacɨ dɨnena ado ibi llonoidɨmacɨ: —Naimɨena coraɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Jesúna jino oretajana jitaiñedɨmacɨ. Iena Pilato uiñuamona, comɨnɨ jai uri iñenana naimɨe cɨuanona, jɨnui dɨga ie onollɨna jocuanona raite: —Bimɨe fiodaillana cue muidonañede. Bie rafue cuemo jai duiñede. Naimɨe fiodaite omoɨ muidona. ");
INSERT INTO huuNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Uai otɨmacɨ: —Dama iesede. Naimɨe fiodaite caɨ muidona. Jɨaɨ caɨ uruiaɨ muidona. ");
INSERT INTO huuNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ie mei Pilatodɨ Barrabás naimacɨ jitailla jira, jino orede; iadedɨ Jesúna sechedotajanona, naimɨena coraɨllena orede. ");
INSERT INTO huuNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Dajerie soldaduaɨdɨ Pilato jofomo Jesúna uite. Nana soldaduaɨ nainomo ofidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Naimɨe ɨniroi duiñuano, naimɨemo jiduirede ɨniroina jɨtadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Eecuaɨmona niga nuicɨraina naimɨe ɨfogɨmo jɨtadɨmacɨ. Ie nabeillɨmo radosina jonete, illaɨmana naimɨe illa isoi. Caiñɨcɨ ɨfodo raɨdɨmacɨ, illaɨmana naimɨe illa isoi. Raitɨmacɨ: —Jadi, judíuaɨ illaɨma. —Iese raillanona naimɨena jɨfanododɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Naimɨena tuallaɨtɨmacɨ. Naimɨe onollɨmo ite radosina naimacɨ llɨnocaida, naiedo naimɨe ɨfogɨna buta-butadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Jesúna naimacɨ jɨfanodua mei, naimɨe jiduirede ɨniroina duiñodɨmacɨ. Nano naimɨe ɨniroina dane abɨdo naimɨemo jɨtadɨmacɨ. Ie mei naimɨena coraɨllena oni uitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Jerusalémona naimacɨ jaillanona, Cirene railla enɨruemona bitɨmɨemo dafaɨfidɨmacɨ. Naimɨe mamecɨ Simón. Naimɨena Jesús uiga cruzna rocatatɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Gólgota raillanomo jaidɨmacɨ. Ɨfocoraɨna eruaɨlla jira, iese mamecɨrede. ");
INSERT INTO huuNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Nainomo rillanona, ie abɨ isirena cacaiñellena, vinomo erɨrede rana faɨanona, naimɨemo fecadɨmacɨ; iadedɨ iena naimɨe facajano, iena jiroñede. ");
INSERT INTO huuNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Naimɨe coraɨa mei, cruzna naidania mei, naie soldaduaɨ naimɨe ɨniroi danɨ coninɨmo fecasɨte. Naie ɨniroi bu uille raillanona uiñollena, jɨfanododɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ie mei ana raɨdɨmacɨ, naimɨemo eruaɨllena. ");
INSERT INTO huuNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Naimɨe ɨfogɨ afebeimo ie llogɨduafuena jonetɨmacɨ. Iese cuega: “Bimɨedɨ Jesús. Judíuaɨ comɨnɨ illaɨma”. ");
INSERT INTO huuNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ie mei mena fɨɨriruide iaɨmaiaɨna coraɨdɨmacɨ. Damɨe Jesús nabeimo coraɨca. Jɨaɨmɨe Jesús jarɨfebeimo coraɨca. ");
INSERT INTO huuNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Naɨsodo jamai jaidɨno Jesúna mameritɨmacɨ. Mamerillamona, ɨfogɨaɨna jaidɨdɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Raitɨmacɨ: —Navui raisoidɨo: “Jusiñamui jofona judaɨitɨcue. Darui amani illanona, iena dane fɨnoitɨcue” raisoidɨo. Ie muidona dama o abɨna mai jilloita. Jusiñamui Jitodɨodena, cruzmona ana bi. ");
INSERT INTO huuNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ie facaise Jusiñamui dɨga nanoca ñaɨraɨnɨ naimɨena mameritɨmacɨ. Moisés mɨcorɨ llogacɨno llofueraɨnɨ naimɨena jɨaɨ mameritɨmacɨ. Einamacɨ naimɨena jɨaɨ mameritɨmacɨ. Raitɨmacɨ: ");
INSERT INTO huuNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Jɨaɨe comɨnɨna jillotate; iadedɨ dama naimɨe abɨna jilloitanide. Naimɨedɨ caɨ judíuaɨ comɨnɨ illaɨma raillamɨedena, cruzmona naimɨe ana niade billasa. Ie mei naimɨena ɨɨnoitɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","“Jusiñamui Jitodɨcue” naimɨe railla jira, naimɨedɨ Jusiñamuina ja ɨɨnotena, Jusiñamui jitaia, Jusiñamui naimɨena jillotaite. —Iese naimɨena mameritɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Naimɨe dɨga coraɨca iaɨmaiaɨ daje isoi naimɨena mameritɨiaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Jitoma naidai itemona, daje amani horas mona jitɨbicaide. ");
INSERT INTO huuNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ie meinomo judíuaɨ railla uaido Jesús ado jɨdaioide: —Elí, Elí, ¿lama, sabactani? —jɨdaioide. Iena oni dobaiñuamona raite: “Cue Jusiñamui, cue Jusiñamui, ¿bue ñellena cuena faɨnonocaidɨo?” raite. ");
INSERT INTO huuNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Iena cacajano, nainomo jamai itɨnomona damɨerie raitɨmacɨ: —Naimɨe jaie Jusiñamui facaina lloraɨma Elíana uaidote —raitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Naimacɨmona damɨe jarire jaillanona, fibecode ramo vinona faɨte. Radosimo jɨllillano jirollena, naimɨemo a fecade. ");
INSERT INTO huuNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ieconi jɨaɨno raitɨmacɨ: —Ɨna nai. Dallu seda. Elías naimɨena jilloitajaɨbillena sedaitɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ieconi Jesús dane ado cuirioita, fiodaite. ");
INSERT INTO huuNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Naie facaise Jusiñamui jofomo ie fetaca ɨniroife ana anaba jillacɨmo motodo menafe cuararide. Ieconi ñuisaño suide. Iemona nofɨe oni bojode. ");
INSERT INTO huuNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Dɨga raɨafuaɨ econote. Jesús jillua mei, raɨafomona, fiodaillamona, ailluena Jusiñamuina ɨɨnotɨnodɨ jillodɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ie mei Jerusalémo naimacɨ jaillanona, dɨga comɨnɨ naimacɨna cɨodɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Nainomo ite capitán, ie soldaduaɨ dɨga, Jesús fiodaillana eruaɨdɨmacɨ. Ñuisaño ñuillana cacadɨmacɨ. Nana suide rafuena cɨuanona, eo jacɨnaillamona, naimɨe raite: —Uanai bimɨedɨ Jusiñamui Jito. ");
INSERT INTO huuNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ailluena rɨñonɨaɨ naie rafuena aarena cɨodɨmacɨ. Naimɨena canollena, Galileamona Jesús dɨga navui bitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Naimacɨ motomo María Magdalena ite. Jɨaɨe María jɨaɨ ite. Naiñaiñodɨ Jacobo ei. Naiñaiño jɨaɨ José ei. Zebedeo uruiaɨ ei jɨaɨ ite. ");
INSERT INTO huuNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Jitoma ana itemo, eo ucuberedɨmɨe Pilato dɨne jaide. Naimɨedɨ Arimatea naɨraɨ imɨe. Naimɨe mamecɨ José. Jesús dɨbeimo jaidɨmɨe. ");
INSERT INTO huuNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Jesús abɨna jɨcallena, Pilato dɨne jaide. Pilato “Jee” raillanona, Jesús abɨna naimɨe ollena llote. ");
INSERT INTO huuNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ie mei Jesús abɨna cruzmona ana José uanona, jeanide mare userede ɨniroi dɨga naimɨe abɨna ferɨnote. ");
INSERT INTO huuNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Nofɨcɨ ie raɨafomo jonete. Naie raɨafo dama José jaie fɨnoca, naimɨe iena. Jesús abɨ nainomo jonia mei, José naifomo nofɨcɨna ñuitade. Naifo ɨbaide. Ie mei oni jaide. ");
INSERT INTO huuNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","María Magdalena raɨafo uico dɨne jɨaɨe María dɨga raɨnadatɨiaɨñuaɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ie areruido, pascua railla rafue illarui, dajerie judíuaɨ illaɨcomɨnɨ Pilato dɨne jaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Raitɨmacɨ: —Ero, naie abɨ caitadɨmɨe nia fiodaiñenia, navui llote: “Cue fiodaillamona, darui amani illanona, jilloitɨcue”. ");
INSERT INTO huuNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ie jira o uai oreta, darui amani raifi naie raɨafo raise ɨbaillena, naimɨe llofueoicaigano nainomo jaillanona, naimɨe abɨ arɨ oi raillano. Naimɨe abɨna naimacɨ fɨɨanona lloitɨmacɨ: “Naimɨe jai jillode”. Iese suia, comɨnɨna eo jɨfueitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato uai ote: —Soldaduaɨ omoɨdo oreitɨcue, naie raɨafo raise sedallena. ");
INSERT INTO huuNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ie jira jaidɨmacɨ. Raona nitajano, raɨafo raise ɨbaidɨmacɨ. Naiena sedallena, soldaduaɨna nainomo faɨnonocaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sábado fuilla mei, monaiacania, María Magdalena, jɨaɨe María dɨga, raɨafona jɨbuisaidɨiaɨñuaɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ieconi ñuisaño suide. Monamona billanona, Jusiñamui jaɨenicɨ raɨafomo ɨbaica nofɨcɨna oni ñuitade. Naie nofɨcɨmo raɨde. ");
INSERT INTO huuNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Eo queniredena eruaɨde. Naimɨe ɨniroi eo userede. ");
INSERT INTO huuNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Nainomo ite soldaduaɨ naimɨena eo jacɨnaillamona, abɨ docaidɨmacɨ. Iemona fiodaitɨno isoi dallu itɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ie facaise naie jaɨenicɨdɨ dɨnena naie rɨño iaɨñuaɨmo llote: —Jacɨruiñeno. Coraɨca Jesúna omuiño jenuana uiñotɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Naimɨe bene iñede. Naimɨe llua isoi, fiodaillamona naimɨe jai jillode. Naimɨe ifo jeraimo bɨillano mai jɨbuisaɨbi. ");
INSERT INTO huuNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ie mei ie llofueoicaigano dɨne raɨre omuiño jai. Fiodaillamona naimɨe jilluana naimacɨmo llono. “Galileamo omoɨ uicomo naimɨe jaite” llono. Bie rafue omuiño jai llotɨcue —llote. ");
INSERT INTO huuNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ie jira raɨafomona raijicaillanona, eo iobillanona, raɨre jaidɨiaɨñuaɨ. Ie llofueoicaigano dɨne aisɨdɨiaɨñuaɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ie llofueoicaigano dɨne iaɨñuaɨ nia riñenia, Jesús iaɨñuaɨmo dafaɨfillano, raite: —Itomuiño. —Naimɨe dɨne iaɨñuaɨ rillanona, naimɨena sedallena, naimɨe eɨllɨna llɨnotɨiaɨñuaɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jesús dɨnena raite: —Jacɨruiñeno. Cue llofueoicaiganomo llono: “Galileamo jai. Nainomo omoɨna cɨoitɨcue” llono. ");
INSERT INTO huuNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Jaidɨiaɨñuaɨmo, nainomo ite soldaduaɨmona dajerie Jerusalémo jaide, nanoca Jusiñamui dɨga ñaɨraɨnɨmo nana naimacɨmo suide rafue llollena. ");
INSERT INTO huuNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Iena cacajano, einamacɨ dɨga iena siadotɨmacɨ. Ie mei naie soldaduaɨmo ucubena fecadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Raitɨmacɨ: —Jɨaɨe comɨnɨmo llono: “Caɨ ɨnɨa mei, ie llofueoicaigano ie abɨɨna fɨano uitɨmacɨ” llono. ");
INSERT INTO huuNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Iena caɨ gobernador fɨdɨia, naimɨe dɨga ñaɨtɨcaɨ, omoɨna naimɨe duere fɨnoñellena —raitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ie jira naie ucubena feiñuanona, comɨnɨmo illaɨcomɨnɨ llua isoi llotɨmacɨ. Naie rafue uiñocana jaide. Birui nia iena uiñocana jaide. ");
INSERT INTO huuNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ie mei Galileamo naie once llofueoicaigano jaidɨmacɨ. Jesús lloga anedumo jaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Naimɨena naimacɨ cɨuanona, naimɨena sedadɨmacɨ; iadedɨ dajerie Jesús jilluana raise nia ɨɨnoñedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jesús dɨnena raite: —Cue Moo cue uai cuemo iga, monamo cue jitailla rafue cue fɨnollena, enɨruemo cue jitailla rafue cue fɨnollena. ");
INSERT INTO huuNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ie jira naga naɨraɨmo jai, cue dɨbeimo naie comɨnɨna itatallena. Cue dɨbeimo naimacɨ jailla mei, cue Moo dɨbeimo naimacɨna illamona, naimacɨ cue dɨbeimo illamona, ie Joreño anamo naimacɨ illamona, naimacɨna bautiza. ");
INSERT INTO huuNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Nana omoɨmo cue lloga rafuena naimacɨ iena ɨɨnollena, llofue. Nia abɨdo cue biñenia, omoɨna canollena, omoɨ dɨga cue Joreño jaca iite —llote. Mai. Macaɨbaite. Mateodɨcue.");
INSERT INTO huuNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","2","Jesucristo rafuena omoɨmo lloiacadɨcue. Naimɨedɨ Jusiñamui Jito. Naimɨe rafue mare. Isaías mɨcorɨ Jusiñamui facaina jaie lluamona, Juan Bautista mɨcorɨ llofuellena llote. Iena suillamona, Jesucristo enɨruemo ite rafue taɨnede. Iena nano lloiacadɨcue. Isaías mɨcorɨ cuete: “Ero, o uicodo cue rafuena llollena, damɨena oretaitɨcue” Jusiñamui raite. ");
INSERT INTO huuNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Jofue iñenanomo damɨe jɨdai-jɨdaillana cacadɨcue. Naimɨe llote: “Caɨ Nama biite. Naimɨe naɨso atona raise fɨno” llote. Naɨsona llote; iadedɨ naimɨe uaina naimacɨ feiñollena, naimacɨ comecɨaɨ marena fɨnuana ñaɨte. ");
INSERT INTO huuNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Isaías mɨcorɨ llua isoi, Juan Bautista raillamɨe mɨcorɨdɨ Jusiñamui rafuena jofue iñenanomo llofuecana jaide. Comɨnɨna dafaɨfia, naimacɨmo llote: —Omoɨ jeacɨnona faɨnonocaida, Jusiñamui dɨbeimo omoɨ comecɨaɨ iuaillaɨ meido. Iemona omoɨ jeacɨnona feitaite. Omoɨ comecɨaɨ iuaillaɨ omoɨ meidoia, comɨnɨna iena uiñotallena, mai omoɨ bautizallomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Dɨga comɨnɨ naimɨe mɨcorɨ dɨne jai jaisoidɨmacɨ. Jerusalémona, nana Judeamona, nana Jordán fuemona jai jaisoidɨmacɨ. Jusiñamuimo naimacɨ jeacɨnona naimacɨ llua meino, naimacɨdɨ Juan mɨcorɨ bautizaga. ");
INSERT INTO huuNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Juan mɨcorɨdɨ camello itɨraɨaɨ ie nilla ɨniroina jɨtade. Igoɨ iena ie moilligaɨna jɨtade. Fioduaɨna rɨte. Cɨifona mete. Jamai rana guite. ");
INSERT INTO huuNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Comɨnɨmo llote: —Cue baɨfemo faɨtɨmɨe bie facaise biite. Jamai bue cue isoilla jira, naimɨena cue canuana uiñoñedɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Jusiñamui dɨbeimo omoɨ illamona, jɨnui dɨga omoɨna bautizadɨcue; ia naimɨe bia, naimɨe dɨbeimo omoɨ jaillamona, Jusiñamui Joreñona omoɨmo itataite. ");
INSERT INTO huuNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Jordán dɨne Juan mɨcorɨ nia ia, Galileamona, Nazaretmona naimɨe dɨne Jesús bite. Nainomo Jesúdɨ Juan bautizaga. ");
INSERT INTO huuNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Bautizaja mei, jɨnuimona billanona, ieconi mona bojodena cɨode. Jusiñamui Joreño, ucugɨ isoi, naimɨe emodomo ana billana cɨode. ");
INSERT INTO huuNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Monamona Jusiñamui llote: —Cue isiruiga Jitodɨo. Ori iobidɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Jesús bautizaja mei, Jusiñamui Joreño jofue iñenanomo naimɨena uite. ");
INSERT INTO huuNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Comɨnɨ nainomo iñede. Dɨfai ocainaɨaɨ itɨmacɨ. Nainomo cuarenta dɨgarui ite. Ie facaise Taɨfe naimɨena ramo faɨte; ia Jusiñamui jaɨenisaɨ naimɨena sedadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Naie facaise Juan Bautista mɨcorɨna Herodes gaɨtaja mei, Galilea railla enɨruemo Jesús jaide. Jusiñamui ie mare rafuena llocana jaide. ");
INSERT INTO huuNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Llote: —Jusiñamui birui omoɨna sedaacade. Ie comɨnɨna omoɨ jaillena birui jitaide. Jusiñamui dɨbeimo illena, omoɨ jeacɨnona faɨnonocaida, omoɨ comecɨaɨ iuaina meido. Bie rafuena mai omoɨ ɨɨno. ");
INSERT INTO huuNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jɨaɨruido Galilea railla jorai fuemo Jesús macaritemo, menamɨena cɨode. Naga ie ama iaɨmaiaɨ. Damɨe Simón. Jɨaɨmɨe Andrés. Lloijina faɨraɨma iaɨmaiaɨ. Iese jaca naie iaɨmaiaɨdɨ maɨjɨuidɨiaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Iaɨmaiaɨmo llote: —Cue dɨga omɨco jaioicaillena, cue dɨga mai bi. Cue llofueganona omɨco jaillena jitaidɨcue. Llɨcɨaɨna birui ocabitomɨco; iadedɨ comɨnɨna oitomɨco, cue dɨbeimo naimacɨ illena. ");
INSERT INTO huuNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Iena cacajanona, ieconi iaɨmaiaɨ lloijina faɨnonocaida, naimɨe dɨga jaidɨiaɨmaiaɨ. Ie llofueganona jaillena, jaidɨiaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Llɨaɨ baɨ Jesús jaidemo, jɨaɨe menamɨena cɨode. Naga ie ama iaɨmaiaɨ. Damɨe Jacobo. Jɨaɨmɨe Juan. Iaɨmaiaɨ moodɨ Zebedeo. Botemo iaɨmaiaɨ lloijina sɨgaɨdɨiaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jesús iaɨmaiaɨna uaidote, ie llofueganona jaillena. Ie maɨjɨraɨnɨ dɨga iaɨmaiaɨ moona faɨnonocaida, botemona arɨ billanona, Jesús dɨga jaidɨiaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Baɨ jaillanona, Capernaumo ie llofuegano dɨga Jesús ride. Nainomo naimɨe ia, sábadoruimo judíuaɨ ofiracomo jaide. Nainomo llofuete. ");
INSERT INTO huuNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Moisés mɨcorɨ llogacɨno llofueraɨnɨ isoi llofueñede. Illaɨma uai isoi naimɨe llofuia jira, nainomo ite comɨnɨ naimɨe llofuiamona raijicaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Janaba anamo illamɨe nainomo ite. ");
INSERT INTO huuNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Jesús llofuiana cacaita, Janabadɨ ɨimana ado cuirioitate: —Odɨ Nazaret ie Jesús. ¿Bue ñeacadɨo caɨ dɨga? Caɨna duere fɨnuaɨbidɨo. Ona uiñotɨcue. Odɨ Jusiñamui ie mare fetocamɨedɨo. ");
INSERT INTO huuNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesús naimɨena lletade: —Llɨɨcai. Naimɨemona oni jai. ");
INSERT INTO huuNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Janaba naimɨena docaitajanona, ado cuirioillanona, naimɨemona oni jaide. ");
INSERT INTO huuNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Iena cɨuanona, nana nainomo itɨno raijicaidɨmacɨ. Coninɨri siadotɨmacɨ: —¿Nɨese ite? Bimɨe jɨaɨe uaido llofuete. Janabamo naimɨe llua mei, ɨimamona Janaba oni jaide. Janaba Jesús uaina ɨɨnote. ");
INSERT INTO huuNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Iemona nana Galilea enɨruemo Jesús mamecɨ are soride. ");
INSERT INTO huuNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ofiracomona Jesús jaillanona, ie llofuegano dɨga, Simón jofomo jaide. Andrés nainomo jɨaɨ jaɨnaɨaɨde. Jacobo, Juan dɨga jɨaɨ fo jaide. ");
INSERT INTO huuNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ie facaise Simón jɨfaiño duide. Abɨ cuaride. Nainomo itɨno Jesúmo naiñaiño duillana llote. ");
INSERT INTO huuNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Iena cacajanona, naiñaiño dɨne jaillanona, Jesús naiñaiño onollɨna llɨnote. Naiñaiñona naidacaitade. Ieconi abɨ cuarilla faɨnonocaide. Guille fɨnuanona, ie jofomo itɨnona ecade. ");
INSERT INTO huuNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Navuida, jitɨbicaidemo, Jesús dɨne comɨnɨ ailluena duidɨnona atɨdɨmacɨ. Janaba anamo itɨnona jɨaɨ atɨdɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Nana Capernaum comɨnɨ naie jofo nasemo ofidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jesúdɨ dɨga duicona ailluena duidɨnona jillotate. Ailluena comɨnɨ Janaba anamona jillotate. Naimɨena jananɨaɨ uiñua jira, Jesús naimacɨ ñaɨana rairuide. ");
INSERT INTO huuNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ie areruido nia monaiñenia, Jesús casillanona, Capernaumona comɨnɨ iñenanomo Jesús jaide. Nainomo Jusiñamuimo jɨɨde. ");
INSERT INTO huuNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Monaia, casidemo, jofomo Jesús iñena jira, Simón, ie nabaiñɨaɨ dɨga, Jesúna jenuaide. ");
INSERT INTO huuNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Baillanona, raite: —Nana comɨnɨ ona jenodɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jesús uai ote: —Jɨaɨe naɨraɨaɨ dɨne mai caɨ jaillɨ. Nainomo llofueiacadɨcue. Ie jira Capernaumona jino bitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Nana Galileamo Jesús jaide. Judíuaɨ ofiracuaɨmo llofuecana jaide. Ailluena comɨnɨmona jananɨaɨna oni oretate. ");
INSERT INTO huuNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ie facaise efonaitɨmɨe Jesús dɨne billanona, naimɨena raise uaiduamona, caiñɨcɨ ɨfodo ana raɨnadate. Raite: —O jitaiadedɨ, cuena jillotaredɨo. ");
INSERT INTO huuNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Naimɨena duenaillamona, Jesús ie onollɨ naimɨemo oni ñuitajanona, naimɨena jetade. Raite: —Ona jillotaiacadɨcue. Mai o jillo. ");
INSERT INTO huuNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","—Ieconi naimɨe jillode. ");
INSERT INTO huuNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ie facaise Jesús naimɨena oretaiacanano, naimɨemo rɨire llote: ");
INSERT INTO huuNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—O jilluana bumo lloñeno; iadedɨ Jerusalémo Jusiñamui jofomo Jusiñamui dɨga ñaɨraɨma dɨne mai jai. O jilluana comɨnɨ raise uiñollena, naimɨemo o abɨna acatajai. Moisés mɨcorɨ jaie lloga rana Jusiñamuimo feca. ");
INSERT INTO huuNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Iese Jesús naimɨemo llote; iadedɨ Jesús fɨnoca rafue llocana eo uite. Ie muidona ailluena comɨnɨ Jesúna cɨoacana jira, Jesús marefodo comɨnɨ illanomo jaisoiñede; ia comɨnɨ iñenanomo jaisoide. Iese jaisoide; ia naganomona naimɨe dɨne biñoidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Nɨgarui illanona, Capernaumo Jesús dane abɨdo ride. Comɨnɨ iena fɨdɨanona, ");
INSERT INTO huuNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","ie risoillacomo naimɨe dɨne ofidɨmacɨ. Ailluena billa jira, fo illɨno iñede. Nasemo jɨaɨ eo ofidɨmacɨ. Jesús naimacɨmo Jusiñamui rafuena llofuete. ");
INSERT INTO huuNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Comɨnɨna Jesús llofuetemo, naimɨe dɨne nagaamagamɨe ie bɨiramo bɨide tɨsitaitɨmɨena atɨdɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ailluena comɨnɨ illa jira, Jesús dɨne naimacɨ rinidɨmacɨ. Naie jofo bɨbanilla jira, jofo emodomo a jaidɨmacɨ. Jofo beicɨmo ite tɨdabacuido a jaidɨmacɨ. Jofo emodo econuano, Jesús ecɨmo naimɨena ie bɨiramo bɨide dɨga, rao dɨga, ana ñuitadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Iena Jesús cɨuanona, tɨsitaitɨmɨe jilluana naimacɨ ɨɨnuana Jesús uiñote. Tɨsitaitɨmɨemo llote: —Nabai, o jeacɨno cue feitaja jira, iena jai oni dotadɨcue. Ie facai ɨbana jai oñeitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Nainomo itɨnomona damɨerie Moisés mɨcorɨ llogacɨnona llofueraɨnɨ nainomo raɨdɨmacɨ. Comecɨna facadɨmacɨ: ");
INSERT INTO huuNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Nɨese bimɨedɨ iese llote? Dama Jusiñamui jeacɨnona dotarede. Bimɨe Jusiñamuiñede; ia Jusiñamui ifomo iacade. Jusiñamuina jai jeare ñaɨte”. ");
INSERT INTO huuNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Naimacɨ comecɨaɨ facajacɨnona Jesús uiñuanona, naimacɨmo jɨcanote: —¿Bue ñellena omoɨ comecɨaɨna iese facadomoɨ? ");
INSERT INTO huuNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Bimɨemo: “O jeacɨnona jai oni dotadɨcue” cue lloia, cue uai siñonana uiñoñeitomoɨ; ia bimɨemo: “Mai naidacaillanona, o bɨira ferɨnocaida, mai macari” cue lloia, cue uai siñonana uiñoitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Monamona jaie cue billanona, ɨimana jaidɨcue. Ie jira jeacɨno oni dotaja uai cuemo ite. Iena omoɨ uiñollena, tɨsitaitɨmɨemo lloitɨcue: ");
INSERT INTO huuNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Mai naidacai. O bɨira ferɨanona, o jofomo mai jai”. ");
INSERT INTO huuNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Iese naimɨe raillamona, tɨsitaitɨmɨe jillode. Naidacaida, ie bɨira ferɨa mei, naimacɨmona jino jaide. Nana nainomo itɨno raijicaidɨmacɨ. Iemona Jusiñamuimo iobillacɨnona fecadɨmacɨ. Raitɨmacɨ: —Bie isoide siño comena jaca cɨoñedɨcai. ");
INSERT INTO huuNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jɨaɨruido jorai fuemo Jesús dane jaide. Ailluena comɨnɨ naimɨe dɨne ofillanona, naimacɨna llofuete. ");
INSERT INTO huuNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Llofuia mei, Jesús baɨ macaritemo, Leví raillamɨena cɨode. Levídɨ Alfeo jito. Gobierno ucube ouillanomo naimɨe maɨjɨuide. Nainomo raɨdena Levína cɨode. Naimɨemo llote: —Cue llofuegamɨena o jaillena, cue dɨga bi. —Naidacaida, Jesús dɨga jaide. ");
INSERT INTO huuNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ie mei Leví jofomo Jesús ie llofueoicaigano dɨga guisaide. Naie facaise ailluena comɨnɨ naimɨe dɨga jaisoidɨmacɨ. Naimacɨmona dɨga gobierno ucube oraɨnɨ nainomo guisaɨbitɨmacɨ. Moisés mɨcorɨ llogacɨnodo raise jaiñedɨno jɨaɨ guisaɨbitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ie facaise fariseuaɨ comɨnɨ, Moisés mɨcorɨ llogacɨnona llofueraɨnɨ dɨga, nainomo jamai bɨtɨmacɨ. Jesúna cɨuanona, naimɨe llofueoicaiganomo jɨcanotɨmacɨ: —¿Bue ñellena omoɨ maestro ucube oraɨnɨ dɨga guite? Maraiñede comɨnɨ dɨga naimɨe guite. Naie isoidɨno dɨga fariseuaɨ comɨnɨ nabairiñena jira, iese jɨcanotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Iena cacajano, Jesús llote: —Ecairedɨnodɨ médicona jitaiñedɨmacɨ; ia duidɨnodɨ médicona jitaidɨmacɨ. Ie isoide. Mareuidɨno cuena jitaiñedɨmacɨ; ia maraiñedɨno cuena jitaidɨmacɨ. Jusiñamui dɨbeimo mareuidɨnona uaɨbiñedɨcue; iadedɨ maraiñedɨnona uaɨbitɨcue. Omoɨmona maraiñedɨno dɨga nabairitɨcue; ia naimacɨna uaɨbitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ie facaise Jusiñamuina raise iobitallena, Juan Bautista llofueoicaigano guiñenaruillaɨ ite. Ie facaise fariseuaɨ comɨnɨ jɨaɨ guiñenaruillaɨ ite. Jesús dɨne comɨnɨ billanona, naimɨemo llote: —Caɨ einamacɨ llua isoi, Jusiñamuina naimacɨ raise iobitallena, guiñenaruillaɨ illa facaiseconi Juan Bautista llofueoicaigano guiñedɨmacɨ. Naimacɨ jeacɨno facaina sunaicabitɨmacɨ. Fariseuaɨ llofueoicaigano iedo jɨaɨ jaidɨmacɨ; ia o llofueoicaigano jaca guitɨmacɨ. ¿Bue ñellena caɨ einamacɨ rafuedo jaiñedɨmacɨ? ");
INSERT INTO huuNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","20","Jesús uai ote: —Jɨaɨe rafuedo iena lloitɨcue. Coniruedɨ ie aɨna uarui ia, iobilla jira, ie nabaiñɨaɨ sunaiñedɨmacɨ. Iobillamona guitɨmacɨ. Jɨaɨruido jai aɨreiacade conirue naimacɨ dɨga iñenia, naimacɨ comecɨ sunaillamona, naimacɨ jitaia, guiñenaruillaɨdɨ iite. Ie isoide. Cue comɨnɨ dɨga birui cue illa jira, iocɨre itɨmacɨ. Ɨco cue jaille mei, sunaitɨmacɨ. Ie muidona birui cue llofueoicaigano guicabitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","’Jɨaɨe rafuedo iena lloitɨcue. Nia jocoñega comue ɨniroidɨ jacaɨe ɨniroimo jɨlliñega. Jɨlliadɨ jocua mei, comue ɨniroi jacaɨe ɨniroimona fo llirite. Eo fodo cuararite. Jai maraiñeno cɨoite. ");
INSERT INTO huuNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Jacagomona fɨnoca bolsa como fɨnoca vino joneñega. Jonegadena, maɨriñena jira, sɨrillamona igoɨ raɨre cuararite. Vino faɨfite. Igoɨ jɨaɨ faɨfite. Como fɨnoca vino comogomo jonelle. Iemei iena faɨfiñeite. Ie isoide. Omoɨ einamacɨ rafue ifomo jɨaɨe rafue birui ite. Iena omoɨmo llocabitɨcue. Iedo jaidɨcaɨ —llote. ");
INSERT INTO huuNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Jɨaɨruido sábadoruimo Jesús, ie llofueoicaigano dɨga, trigo illa illɨ motodo joide naɨsona jaide. Ie llofueoicaigano trigona tɨjɨano, guicana jaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Dajerie fariseuaɨ iena cɨuano, llotɨmacɨ: —Rairuica rana fɨnosɨte. Moisés mɨcorɨ rairuilla jira, sábadoruimo maɨjɨnidɨcaɨ; iadedɨ trigona naimacɨ tɨjɨamona, caɨmona jai maɨjɨdɨmacɨ. Iese caɨ abɨmo jeacɨnona jai fɨnodɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ie llofueoicaiganona rɨiduano, Jesús uai ote: —Cuemona jeacɨno fɨnoñedɨmacɨ. David mɨcorɨ jaie fɨnoca rafuemo omoɨ comecɨaɨ raise facañedomoɨ. David mɨcorɨ guille iñenia, naimɨe aimetaia, ie nabaiñɨaɨ dɨga, Jusiñamui jofomo fo jaide. ");
INSERT INTO huuNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Naie facaise Jusiñamui dɨga nanoca ñaɨraɨmadɨ Abiatar. Jusiñamui jofomo naimacɨ fo jailla mei, Jusiñamuimo fecaca llomenicona uanona, guitɨmacɨ. Jamai bue isoidɨno naie llomenicona guillana Jusiñamui rairuide. Danɨ Jusiñamui dɨga ñaɨraɨnɨ iena guiredɨmacɨ. Ie nabaiñɨaɨ dɨga, David mɨcorɨ iena guite; ia Jusiñamui naimacɨna duere fɨnoñede. ");
INSERT INTO huuNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jusiñamui sábadona fɨnuamona, sábado ite, nairui illamona comɨnɨ caɨmare illena; ia omoɨ llofuiamona, iese iñedɨmacɨ. Nairuimo rairuica rana fɨnoñellena, comɨnɨ iese illena llofuecabitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Monamona cue billamona, ɨimana jaidɨcue. Ie jira sábadoruimo comɨnɨ fɨnolle rafuena rairuiredɨcue. Nairuimo fɨnoñelle rafuena jɨaɨ rairuiredɨcue. Ie jira nairuimo cue jitailla rafuena fɨnoredɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jɨaɨe sábadoruimo judíuaɨ ofiracomo Jesús dane jaide. Ie facaise onollɨna ɨdɨsarodɨmɨe nainomo ite. ");
INSERT INTO huuNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Nainomo itɨno Jesús eruaɨdɨmacɨ, sábadoruimo Jesús naimɨe raabaca ie segoitai. Iena Jesús fɨnoia, naimacɨmona sábadoruimo naimɨe jai maɨjɨa jira, naimɨena llogɨdoiacadɨmacɨ. Sábadoruimo bu maɨjɨia, naimacɨmona jeacɨno fɨnode. ");
INSERT INTO huuNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Onollɨna ɨdɨsarodɨmɨemo Jesús llote: —Cue ecɨmo mai baɨ bi. ");
INSERT INTO huuNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Jesús nainomo itɨnomo jɨcanote: —¿Nɨe isoide rafue sábadoruimo fɨnuadɨ mare? Bimɨe birui cue jillotaiadedɨ, birui mare rafuena fɨnodɨcue. Cuena birui omoɨ meineiadedɨ, birui maraiñede rafue fɨnodomoɨ. Sábadoruimo, ¿nɨe isoide rafue fɨnuana rairuidomoɨ? Comɨnɨ dɨnena uai oñedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Naimɨe uaina naimacɨ ɨɨnoñena jira, rɨicaillanona, Jesús naimacɨmo erodate. Duidɨmɨemo llote: —O onollɨ mai oni ñuita. Iena oni ñuitajamona jillode. ");
INSERT INTO huuNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Iena cɨuanona, fariseuaɨ jino jaidɨmacɨ. Naimɨena meinellena, illaɨma Herodes dɨbeimo itɨnona baillanona, naimacɨ dɨga coninɨri siadotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Naie naɨraɨmona jorai fuemo Jesús, ie llofueoicaigano dɨga, oni jaide. Galilea railla enɨruemona ailluena comɨnɨ naimɨe dɨne bitɨmacɨ. Judeamona jɨaɨno bitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jerusalémona, Idumeamona, Jordán ruicafebellemona, Tiro jinofemo ite enɨruemona, Sidón jinofemo ite enɨruemona ailluena bitɨmacɨ. Nana naimɨe siño fɨnoca rafuena cacajanona, naimɨena cɨoacadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Comɨnɨ naimɨena meetasɨi raillanona, ie llofueoicaiganomo daje botemo naimɨe jaillena eenogana llote. ");
INSERT INTO huuNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ailluena duidɨnona naimɨe jai jillotaja jira, nana duidɨno naimɨemo riacadɨmacɨ. Jilloillena naimɨena jetaacadɨmacɨ. Iemona naimɨe illa bote eenuana jitaide. ");
INSERT INTO huuNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Jananɨaɨ anamo itɨno Jesúna cɨoia, Jesús uicomo ana bɨtadajanona, jananɨaɨ naimacɨna ñaɨtatajamona, raitɨmacɨ: —Jusiñamui Jitodɨo. ");
INSERT INTO huuNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","—Ia Jesús naimɨena naimacɨ lluana rairuide. ");
INSERT INTO huuNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Naie facaise anedumo Jesús jaide. Ie jitaillano dɨese naimɨe dɨne uaidote. Naimɨe dɨne billa mei, ");
INSERT INTO huuNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","doce dɨgamɨena fetode. Naimɨe dɨga jaicabillena, naimacɨna fetode. Ie rafuena llollena, naimacɨna oretaiacade. ");
INSERT INTO huuNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Janaba anamo itɨnomona Janabana oni oretallena, ie uai naimacɨmo ite. ");
INSERT INTO huuNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Iese mamecɨredɨmacɨ: Simón; naimɨe mamecɨ jɨaɨcɨdɨ Jesús jɨtaca Pedrona. ");
INSERT INTO huuNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jacobo, Juan; iaɨmaiaɨ Zebedeo jito iaɨmaiaɨ. Jɨaɨe mamecɨ iaɨmaiaɨna Jesús jonete Boanergesna. Naie mamecɨ oni dobaiñuamona mona guruama. Icɨriruilla jira, iese mamecɨredɨiaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrés, Felipe, Bartolomé, Mateo, Tomás, jɨaɨe Jacobo; naimɨedɨ Alfeo jito. Tadeo, jɨaɨe Simón; naimɨedɨ cananista comɨnɨ facaisemo duide. ");
INSERT INTO huuNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Judas Iscariote mɨcorɨ; naimɨedɨ Jesúna gaɨtatatɨmɨe. ");
INSERT INTO huuNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ie llofueoicaiganona fetua mei, ie risoilla jofomo naimacɨ dɨga Jesús abɨdo jaide. Ailluena comɨnɨ naimɨe dɨne billa jira, naimɨe guillena, naimɨe abɨ juanide. ");
INSERT INTO huuNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Naimɨena ie comɨnɨ fɨdɨano: “Naimɨedɨ jai uaɨrico isoi iacade” raillanona, comecɨna facadɨmacɨ. Ie jira naimɨena ie ei jofomo isaɨbiacadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Jerusalémona Moisés mɨcorɨ llogacɨnona llofueraɨnɨ naie facaise billanona, raitɨmacɨ: —Beelzebúdɨ Janaba comɨnɨ. Beelzebú anamo Jesús illamona, Beelzebú uaido Janaba illa comɨnɨmona Jesúdɨ Janabana oni oretate —raitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Naimacɨ raillana naimɨe cacajanona, naimɨe dɨne Jesús naimacɨna uaidote. Llote: —Janaba dɨbeimo Beelzebú illamona, dama ie abɨna oretanide. ");
INSERT INTO huuNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ero, daje isoi comecɨaɨna lloiñenamo daje naɨraɨ facañenia, danomo maɨjɨnidɨmacɨ. Oni jaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Daje isoi comecɨaɨna lloiñenamo daje jofomo itɨno facañenia, danomo jaɨnaɨaɨnidɨmacɨ. Oni jaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ie isoide. Beelzebú uaido jananɨaɨna omoɨ llua isoi cue oretaia, Janaba ie dɨbeimo itɨno dɨga jai nabairiñede. Iemona naimɨe comɨnɨ danomo iñeitɨmacɨ. Ie uai ieconi saite. ");
INSERT INTO huuNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ero, maɨridɨmɨe ie jofomo ite rana nɨbaɨ fɨɨacadomoɨ. Iena fɨɨllena, naimɨena nano raise omoɨ maɨga. Raise maɨga mei, ie rana fɨɨredomoɨ. Ie isoide. Janaba anamona comɨnɨna jillotacabitɨcue. Naimɨe afemo nano cue iñenia, comɨnɨna jillotanidɨcue. Naimɨe afemo cue illa jira, iena fɨnoredɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ie jira bie omoɨmo lloitɨcue. Jusiñamui nana comɨnɨ jeacɨnona dotarede. Naimɨedɨ naimacɨ jeare ñaɨacɨnona dotarede; ");
INSERT INTO huuNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","iadedɨ naimɨedɨ ie Joreñona jeare ñaɨacɨnona jaca dotañeite. Jusiñamui iena jaca feitañeite —llote. ");
INSERT INTO huuNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","—Beelzebú anamo Jesús ite. Jusiñamui Joreño uaido siño rafuena fɨnoñede; ia Janaba uaido siño rafuena fɨnode —Jesúna raitɨmacɨ. Iese naimacɨ railla jira, “Jusiñamui naie isoide ñaɨacɨnona jaca dotañeite” iese Jesús llote. ");
INSERT INTO huuNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Jesús comɨnɨ naimɨe dɨne rillanona, naimɨe dɨga ñaɨacanano jino naidaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ie facaise ailluena comɨnɨ naimɨe ecɨmo raɨdɨmacɨ. Naimɨe comɨnɨ rillana naimacɨ cacajano, naimɨemo llotɨmacɨ: —O ei, o amatɨaɨ dɨga jino ite. O dɨga ñaɨacade. ");
INSERT INTO huuNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jesús dɨnena uai ote: —¿Bu cue ei? ¿Bu cue amatɨaɨ? ");
INSERT INTO huuNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Naimɨe ecɨmo itɨnomo erodajanona, llote: —Jadi, cue ei, cue amatɨaɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Jusiñamui jitaillacɨnona fɨnodɨmɨe cue amana, cue mirɨñona, cue eina. Imacɨ ua cue comɨnɨna. ");
INSERT INTO huuNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jɨaɨruido jorai fuemo dane jaillanona, ailluena comɨnɨ naimɨe dɨne ofillamona, Jesús naimacɨna llofuete. Ailluena comɨnɨ nainomo ofilla jira, botemo Jesús jaillano, ana raɨde; iadedɨ comɨnɨ jorai fuemo itɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ailluena rafuena naimacɨna llofuete. Raite: ");
INSERT INTO huuNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Omoɨ fueollena, bie rafuemo raise cacarei. Damɨe trigona judaɨaide. ");
INSERT INTO huuNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Naimɨe judaɨamona, naɨsomo janore iduaɨ juide. Naimɨe baɨ jailla mei, silliñɨaɨ iena guisaɨbitɨmacɨ. Ie jira sɨcoñede. ");
INSERT INTO huuNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Nofɨemo jɨaɨe iduaɨ juide. Nainomo enɨrue raise iñede. Sɨcode; iadedɨ enɨrue raise iñena jira, ");
INSERT INTO huuNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","raise jainañena jira, ecasillamona duide. Ie jira llɨsiñede. ");
INSERT INTO huuNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Eecuaɨ illanomo jɨaɨe iduaɨ juide. Eecuaɨ sɨcuamona riara eecuaɨ ɨbaica. Ie jira llɨsiñede. ");
INSERT INTO huuNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Mare enɨruemo jɨaɨe iduaɨ juide. Sɨcode. Llɨsillamona danademo treinta dɨga llɨsillana ote. Jɨaɨnamona sesenta dɨga llɨsillana ote. Jɨaɨnamona cien dɨga llɨsillana ote. ");
INSERT INTO huuNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Omoɨ jeforena jira, raise fueollena, cue lluamo cacarei. Iena ɨɨno. ");
INSERT INTO huuNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ailluena comɨnɨmona jailla mei, naimɨe dɨga jaisoidɨnodɨ, ie doce llofueoicaigano dɨga, Jesúmo ie llofuiana jɨcanotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Uai ote: —Jusiñamuidɨ omoɨna ie sedaacana rafuena jai uiñotade. Jaie iena uiñoñedomoɨ. Jɨaɨe comɨnɨna iena nia uiñotañede. ");
INSERT INTO huuNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ie jira bie isoidɨcɨnodo naimacɨmo llotɨcue. Cue siño fɨnoca rafuena cɨodɨmacɨ; iadedɨ iena naimacɨ ɨɨnoñena jira, uiñoñeno jaitɨmacɨ. Cue llofuiana jamai cacadɨmacɨ; iadedɨ naimacɨ ɨɨnoñena jira, raise cacaiñedɨmacɨ. Uiñoñedɨmacɨ. Jusiñamui dɨbeimo naimacɨ jaiacaiñena jira, Jusiñamui naimacɨ jeacɨnona oni dotañeite. Iena feitañeite. ");
INSERT INTO huuNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Cue como llofuiacɨnona omoɨ raise cacaiñenia, dane cue llofuia, iena jɨaɨ raise nɨbaɨ cacaiñeitomoɨ; ");
INSERT INTO huuNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","ia iena omoɨna llofueitɨcue. Trigona judaɨdɨmɨedɨ Jusiñamui rafue lloraɨma isoide. ");
INSERT INTO huuNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Dajerie iduaɨ naɨsomo juide. Dajerie comɨnɨ comecɨaɨ naie naɨso isoidɨmacɨ. Jusiñamui uaina cacadɨmacɨ; ia Taɨfe naimacɨ comecɨaɨmo cacaja uaina ɨɨnotañede. ");
INSERT INTO huuNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Jɨaɨe iduaɨ nofɨemo juide. Dajerie comɨnɨ comecɨaɨ naie nofɨe isoidɨmacɨ. Jusiñamui uai nano naimacɨ cacaia, iena caɨmare feiñotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Nofɨemo riga iduaɨ jainaonidedɨ raise sɨcoñede. Naie comɨnɨ janore ɨɨnua jira, ie isoidɨmacɨ. Dallu nano ɨɨnotɨmacɨ. Jusiñamui uai muidona duere naimacɨ sefuia, abɨdo danomo uaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Jɨaɨe iduaɨ eecuaɨ illanomo juide. Naie iduaɨ sɨcua mei, iena eecuaɨ ɨbailla jira, raise llɨsiñede. Dajerie comɨnɨ comecɨaɨ naie illano isoidɨmacɨ. Jusiñamui uaina cacadɨmacɨ. Ɨɨnotɨmacɨ; ");
INSERT INTO huuNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","iadedɨ naimacɨ comecɨaɨ jarire illamona, naimacɨ raruiaɨna ebiruillamona, naie uai naimacɨ comecɨaɨmo itabiñede. Jusiñamui jitaille rafuena fɨnocana jaiñedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Jɨaɨe iduaɨ mare enɨruemo juide. Dajerie comɨnɨ comecɨaɨ naie enɨrue isoidɨmacɨ. Jusiñamui uaina cacajano, iena raise feiñotɨmacɨ. Eo llɨside isoidɨmacɨ. Jusiñamui jitailla rafuena fɨnocana jaidɨmacɨ. Dajerie janore jaidɨmacɨ. Dajerie eo jaidɨmacɨ. Dajerie ua eo raise jaidɨmacɨ. Iese omoɨ jai. ");
INSERT INTO huuNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jorai fuedo Jesúdɨ comɨnɨna nia llofuete: —Jai uneca lamparín jɨaɨe illanomona atɨa mei, jɨaɨe ra bɨide anamo raɨnañega; iadedɨ jofo jeraimo llɨgaiñollena, nainomo bite comɨnɨ raise cɨoillena, ie raɨranomo raɨnade. ");
INSERT INTO huuNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ie isoide. Cue rafue llocana jaia, comɨnɨ comecɨaɨ itɨcɨnona uiñotade. Uanaicɨno naimacɨ cacajamona, damɨerie ɨɨnotɨmacɨ. Damɨerie ɨɨnoñedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Omoɨ jeforena jira, raise fueollena, cue lluamo cacarei. Iena ɨɨno. ");
INSERT INTO huuNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","’Cue lluamo raise cacarei. Omoɨ cacaja dɨese Jusiñamui omoɨna uiñotaite. ");
INSERT INTO huuNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Iena omoɨ ɨɨnoia, Jusiñamui omoɨna canoite. Omoɨna uiñocana jaitaite. Jɨaɨmɨe iena janore cacajamona, iena ɨɨnoñenia, Jusiñamui naimɨena faɨfitaite. ");
INSERT INTO huuNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesús llote: —Jusiñamui dɨbeimo comɨnɨ jailla rafuena nia lloitɨcue. Naimɨe dɨbeimo comɨnɨ jaillena, naimɨe rafue llocana jaidɨcue. Jɨaɨe uaido iena omoɨmo lloitɨcue. Damɨe ie illɨmo judaɨaide. ");
INSERT INTO huuNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Judaɨa mei, ie illɨmo nagarui ie maɨjɨcabilla isoi naimɨe jaide. Nɨese iduaɨ denuana naimɨe raise uiñoñede; ");
INSERT INTO huuNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","ia enɨruemona nano sɨcode. Monailla mei, llɨside. Iemona naicuaɨ comuide. ");
INSERT INTO huuNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Jai einaia, iena ote. Ie isoide. Jusiñamui rafuena raise cacaiñedomoɨ; ia iena ɨɨnocana jaidomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jesús jɨaɨe rafuena llote: —Jusiñamui dɨbeimo comɨnɨ jailla rafuena nia lloitɨcue. Jusiñamui rafuena janore comɨnɨ birui cacajamona, ailluena comɨnɨ naimɨe comɨnɨna ɨco jaitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Jɨaɨe rafuedo iena omoɨmo lloitɨcue. Damɨe mostaza idona rillamona, naiemona eo aillue riara sɨcode. Mostaza ido eo janorede; ");
INSERT INTO huuNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","iadedɨ sɨcua mei, eo aillue riara jaillamona, ie onogaillaɨ jegairiena jira, icairo anamo manaɨdɨnomo silliñɨaɨ jɨcaicɨaɨna fɨnodɨmacɨ. Ie isoide. Jusiñamui rafuena janore comɨnɨ birui cacajamona, ailluena comɨnɨ naimɨe comɨnɨna ɨco jaitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Naie isoide rafuiaɨdo Jesúdɨ Jusiñamui ie comɨnɨna sedaacana rafuena comɨnɨmo llote. ");
INSERT INTO huuNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Naimacɨ cacaja dɨese llote. Naimacɨmo jɨaɨe rafuedo lloñede; ia ie llofueoicaiganomo iena eneno llofuete. ");
INSERT INTO huuNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ailluena comɨnɨ llofuia mei, jitoma jai sojicaidemo, ie llofueoicaiganomo Jesús llote: —Ruica enefebeimo mai caɨ jaillɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Comɨnɨna faɨnonocaida, botemo naimɨe jai illamona, naimɨe llua isoi, oni jaidɨmacɨ. Jɨaɨe botes jɨaɨ jaide. ");
INSERT INTO huuNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","38","Baɨ jaillanona, jillacɨmo Jesús ɨnɨde. Ie ɨfogɨ almohadamo bɨide. Ie facaise aɨfɨ eo rɨire bite. Joraidɨ eo bagode. Baguamona, botemo jɨnui a uaide. Oruiacana jira, jacɨnaillamona, Jesúna casitatɨmacɨ. Raitɨmacɨ: —Maestro, ¿nɨese itɨo ɨnɨoilla? Caɨna cano. Jai buisaidɨcaɨ. Corobaisaidɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Naimɨe casillano, aɨfɨna lletade. Jɨnui baguana llɨɨcaitade. Ieconi aɨfɨ llɨɨcaide. Bagoñede. ");
INSERT INTO huuNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ie llofueoicaiganomo jɨcanote: —¿Bue ñellena jacɨnaitomoɨ? ¿Nɨese cuena raise ɨɨnoñedomoɨ? ");
INSERT INTO huuNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Uai oñeno eo raijicaidɨmacɨ. Coninɨri ñaɨtɨmacɨ: —Bimɨedɨ ¿nɨe isoidɨmɨe? Aɨfɨ naimɨe uaina ɨɨnote. Jorai naimɨe uaina jɨaɨ ɨɨnote. —Baɨ jaillanona, ruica dɨne ridɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ruica dɨne naimacɨ ridemo, Gadara railla enɨruemo sɨjɨdɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Botemona arɨ Jesús jaidemo, naimɨe dɨne damɨe bite. Naimɨedɨ Janaba anamo itɨmɨe. ");
INSERT INTO huuNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Comɨnɨ raɨoillanomo nofɨe moto ifuaɨmo naimɨe i-isoide. Janaba anamo naimɨe illamona, comɨnɨ dɨga marena jaca iraɨnide. ");
INSERT INTO huuNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Dɨga icaiño lloeo dɨga ie onollɨdɨ maɨga; iadedɨ oni ecocaida, lloeona tɨconote. Ie eɨllɨ jɨaɨ maɨga; iadedɨ saitaicaida, lloeona tɨconote. Ie jira buna naimɨena raise maɨnide. ");
INSERT INTO huuNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Nagarui nofɨe motomo ite. Anedumo jaisoide. Cuiri-cuirisoide. Dama ie abɨna nofɨcɨ dɨga jaɨdode. Iese naimɨe isoide. ");
INSERT INTO huuNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Nofɨemona Jesúna cɨuanona, aisɨcana Jesús dɨne bite. Naimɨena sedallena, ie caiñɨcɨ ɨfodo ana raɨnadate. ");
INSERT INTO huuNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Jesús llote: —Janaba, bimɨemona oni jai. Janabadɨ ɨimana ado llotatate: —Nanoca Jusiñamui Jitodɨo. ¿Nɨese cuena nɨbaɨacadɨo? Jusiñamui mamecɨdo cuena duere fɨnoñeno. ");
INSERT INTO huuNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jesús Janabamo jɨcanote: —¿O mamecɨ bu? Uai ote: —Aillosiedɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Bie illanomona naimacɨna oretañellena Jesúmo duere jɨcanotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Naie facaise nainomo ite anedumo ailluena chanchuaɨ itɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Chanchuaɨ abɨmo naimacɨ jaillena Jesúmo duere jɨcanotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jesús dɨnena: —Jee —raite. Ieconi ɨima abɨmona oni jaillanona, chanchuaɨ abɨmo jaidɨmacɨ. Dos mil chanchuaɨ nainomo itɨmacɨ. Iena suidemo, iconɨ jillacɨmo joraimo chanchuaɨ aisɨano corobaisɨdɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Iena cɨuanona, chanchuaɨ sedaraɨnɨ naimacɨ naɨraɨ dɨne aisɨcana jaidɨmacɨ. Naie rafuena llocana jaidɨmacɨ. Ie jira dɨga comɨni jaide, naie rafuena raise fɨdɨllena. ");
INSERT INTO huuNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Jesús dɨne naimacɨ ridemo, jaive Janaba anamo illamɨena Jesús ecɨmo raɨllana cɨodɨmacɨ. Naimɨe ɨniroina jai jɨtade. Naimɨe jai uaɨricoñede. Iena cɨuanona, Jesúna jacɨruitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Naie rafuena cɨodɨno jaive Janaba anamo illamɨe jilluana llotɨmacɨ. Chanchuaɨmo suide rafuena jɨaɨ llotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Naie enɨrue itɨnodɨ Jesúmo naimacɨ enɨruemona oni jaillena duere jɨcanotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Botemo Jesús jaiacania, jaive Janaba anamo illamɨe Jesúmo jɨcanote, naimɨe dɨga jaillena; ");
INSERT INTO huuNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","ia Jesús raite: —Dama ite. O nabaiñɨaɨ dɨne jai. Nana Jusiñamui omo fɨnoca rafuena naimacɨmo llono. Jusiñamui ona duenaillana naimacɨmo llono. ");
INSERT INTO huuNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ie jira oni jaide. Nana Decápolis railla enɨruemo Jesús nana naimɨemo fɨnoca rafuena llocana jaide. Iena cacajamona, nana comɨnɨ raijicaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ruica dɨbeimo ie llofueoicaigano dɨga Jesús abɨdo rilla mei, ailluena comɨnɨ naimɨe dɨne ofidɨmacɨ. Jorai fuedo naimɨe nia ia, ");
INSERT INTO huuNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Jairona mamecɨredɨmɨedɨ Jesús dɨne bite. Naimɨedɨ judíuaɨ rafue ofiraco sedarɨma. Jesúmo duere jɨcanollena, ana bɨtadate. ");
INSERT INTO huuNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Duere jɨcanote: —Cue jisa jai fiodaiacade. Cue jofomo cue dɨga bi, o onollɨ naiñaiñomo o jonellena, naiñaiño jilloillena. ");
INSERT INTO huuNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Iena cacajano, ie llofueoicaigano dɨga, naimɨe dɨga Jesús jaide. Ailluena comɨnɨ Jesúmo ñaijillanona jaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Baɨ jaillanona, duidɨñaiño Jesús jɨnafona jaide. Naiñaiño jeraimona doce años jaca dɨaide. ");
INSERT INTO huuNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Dɨga manoraɨnɨmona duere sefuide. Jilloñede; ia fodo jaide. Nana ie ucube jɨaɨ fuite. ");
INSERT INTO huuNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Jesús duidɨnona jilluana naiñaiño fɨdɨamona, jɨnafo dɨnena billanona, naimɨe ɨniroina jetade. ");
INSERT INTO huuNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","“Naimɨe ɨniroi cue jetajamona jilloitɨcue” comecɨna facajamona, naiñaiño naimɨe ɨniroina jetade. ");
INSERT INTO huuNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ieconi dɨailladɨ faɨnonocaide. Ie abɨ jilluana naiñaiño jai uiñote. ");
INSERT INTO huuNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ie abɨmona ie uai oni jaillana Jesús uiñuanona, dobaicaide. Comɨnɨmo jɨcanote: —¿Bu cue ɨniroina jetade? ");
INSERT INTO huuNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ie llofueoicaigano dɨnena uai otɨmacɨ: —Ailluena comɨnɨ o ecɨmo jaidɨmacɨ. Omo ñaijidɨnona: “¿Bu cue ɨniroi jetade?” raitɨo. ");
INSERT INTO huuNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Raise uiñollena, Jesús ie ecɨmo itɨnomo erodate. ");
INSERT INTO huuNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Duidɨñaiño ie jilluana uiñua jira, Jesús dɨne jacɨruicana bite. Naimɨe uicomo ana bɨtadajanona, nana naiñaiñomo ite rafuena llote. ");
INSERT INTO huuNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Naiñaiñomo Jesús llote: —Ñoo, cuena o ɨɨnua jira, jai jillodɨo. Mai marena o jai. O duicomona jai jillobidɨo. ");
INSERT INTO huuNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Naiñaiño dɨga Jesús nia ñaɨtemo, Jairo jofomona jɨaɨno bite. Jairomo llote: —O jisa jai fiodaite. Maestrona ñaɨdoñeno. ");
INSERT INTO huuNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Iena cacajano, Jairomo Jesús llote: —O comecɨ jarire iñeno; ia cuena nia ɨɨno. ");
INSERT INTO huuNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ailluena comɨnɨ naimɨe dɨga jaillana rairuide. Danɨ dɨese jaillana jitaide: Pedro, Jacobo, Juan. Juandɨ Jacobo ama. ");
INSERT INTO huuNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Jairo jofomo rillanona, nainomo itɨno eecuinaillana cacade. Faɨlliñaillana cacade. ");
INSERT INTO huuNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Jesús fo jailla mei, nainomo itɨnomo jɨcanote: —¿Nɨese itomoɨ eecuinailla? Cuemona naiñaiño fiodaiñedesa. Jamai ɨnɨde. ");
INSERT INTO huuNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Iena cacajano, naiñaiño jai fiodaite uiñuamona, Jesúri jaɨsitɨmacɨ. Naimacɨna Jesús jino oretaja mei, nai jitaɨño moo dɨga, naiñaiño ei dɨga, ie llofueoicaigano dɨga, naiñaiño ecɨmo Jesús jaide. ");
INSERT INTO huuNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Naiñaiño onollɨna llɨnocaida, judíuaɨ uaido raite: —Talita, cumi. —Iena oni dobaiñuamona: “Jitaɨbɨcɨ, mai naidacai” raite. ");
INSERT INTO huuNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ieconi jilluanona naidacaide. Jai jilluano macarite. Naiñaiñomo doce años jai ite. Nana nainomo itɨno ieri eo raijicaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","—Bumo bie rafuena lloñeno —naimacɨmo Jesús llote. Guillena naiñaiñona ecajana jɨaɨ llote. ");
INSERT INTO huuNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Naie illanomona Jesús oni jailla mei, ie llofueoicaigano dɨga Nazaretmo ride. ");
INSERT INTO huuNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Rilla mei, sábadoruimo nainomo ite ofiracomo llofuete. Iena cacajanona, nainomo itɨno raijicaidɨmacɨ. Raitɨmacɨ: —¿Nɨese eo abɨna uiñote? ¿Bumona ie uaina ote? ¿Nɨese siño rafuena naimɨedɨ fɨnode? Naimɨedɨ jamai bue isoidɨmɨe. ");
INSERT INTO huuNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Naimɨedɨ amederaɨma. María jito. Ie amatɨaɨdɨ Jacobo, José, Judas, Simón. Naimɨe mirɨñotɨaɨdɨ caɨ motomo jɨaɨ ite. —“Caɨ comena naimɨe ite” raillanona naimɨe uaina jamaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jesús naimacɨmo llote: —Naga illanomo comɨnɨdɨ Jusiñamui facaina lloraɨma uaina feiñotɨmacɨ; iadedɨ naimɨe naɨraɨmo naimɨe ia, ie jofomo naimɨe ia, ie comɨnɨ naimɨe uaina feiñoiacasɨñede. Jamaisɨte. Ie isoide. Cue comɨnɨdomoɨna jira, cue uaina ɨɨnoñedomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ie muidona nainomo siño rafuena eo fɨnonide. Damɨerie duidɨnona jetajamona, naimacɨna jillotate; ");
INSERT INTO huuNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","ia naimacɨ ɨɨnoñenari raijicaide. Ie mei dɨga naɨraɨaɨmo Jesús llofuecana jaide. ");
INSERT INTO huuNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ie doce llofueoicaiganona Jesús uaiduanona, naimacɨmo ie uai iñonocaide, jananɨaɨ anamona comɨnɨna jilloitallena. Ie rafuena llollena, jɨaɨe illanuaɨmo naimacɨna menamɨerie oretaiacade. ");
INSERT INTO huuNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Raite: —Ailluena rana uiñeno. Omoɨ abɨ rɨidollena, jɨguidana uiño. Llomenicona uiñeno. Ailluena rana omoɨ uiñellena, bolsana uiñeno. Ucubena uiñeno. ");
INSERT INTO huuNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Zapatona jɨtajano jai. Abɨ omoɨ meidolle ɨniroina uiñeno. ");
INSERT INTO huuNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Nɨe naɨraɨmo omoɨ jaia, daacomo omoɨ ri. Naie naɨraɨmo omoɨ ille dɨnori, daacomo omoɨ i. ");
INSERT INTO huuNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Omoɨna bu feiñoiacaiñenia, omoɨ uaina bu cacarefiacaiñenia, naie naɨraɨmona omoɨ jaillanona, omoɨ eɨllɨaɨmo ite jearacuaɨna oni jaidɨno. Maraiñede rafuena naimacɨ fɨnuana naimacɨ uiñollena, omoɨ eɨllɨaɨna jaidɨno. ");
INSERT INTO huuNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Jesús naimacɨmo llua mei, jaidɨmacɨ. —Omoɨ jeacɨnona faɨnonocaillanona, Jusiñamui dɨbeimo omoɨ comecɨaɨ iuai meiduana omoɨ jai —llofuecana jaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Janaba anamo ite comɨnɨmona Janabana oredɨmacɨ. Duidɨno abɨmo farena gɨa mei, naimacɨna jillotate. ");
INSERT INTO huuNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Jesús mamecɨ are sorilla jira. Herodes railla gobernador Jesús fɨnoca rafuena fɨdɨde. Naimɨe raite: —Fiodaillamona Juan Bautista mɨcorɨ jai jillode. Jesús raillamɨedɨ naimɨe. Ie jira naimɨe siño rafuena fɨnocabide. ");
INSERT INTO huuNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Jɨaɨe comɨnɨ raisoidɨmacɨ: —Elías jai bairede. Jɨaɨno raisoidɨmacɨ: —Fiodaillamona Jusiñamui facaina jaie lloraɨma mɨcorɨ jai jillode. ");
INSERT INTO huuNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Jesúna fɨdɨano, Herodes comecɨna facade: “Juan mɨcorɨ ie ɨfogɨna navui jaitatatɨcue. Fiodaillamona naimɨe jai jillode”. ");
INSERT INTO huuNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Iese comecɨna facade, Herodes Juan mɨcorɨna navui meinetaja jira. Juan Bautista mɨcorɨna nia meinetañenia, Herodes ie ama Felipe aɨna ote. Naiñaiño mamecɨdɨ Herodías. Ie jira Juan mɨcorɨ naimɨemo llote: —O ama aɨ dɨga itɨo. Maraiñede rafuena fɨnodɨo. Jusiñamui iena rairuide. ");
INSERT INTO huuNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ie muidona Herodías dɨnena Juan Bautista mɨcorɨna jearuite. Naimɨena meinetaiacade; ");
INSERT INTO huuNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ia fɨnonide, Juan Bautista mɨcorɨna Herodes jacɨruilla jira. Naimɨedɨ Juan mɨcorɨna mareuidɨmɨena uiñote. Naimɨe Juan mɨcorɨ Jusiñamui rafuedo jaillana jɨaɨ uiñote. Ie muidona naimɨe Juan mɨcorɨna raise eenote. Dɨga icaiño naimɨe mɨcorɨ lluana cacade. Iena gaɨde; ia iena raise cacaiñede. Ie muidona Herodías naimɨe mɨcorɨna meinetanide; ");
INSERT INTO huuNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","ia ja muidomo naiñaiño sedallɨrui ride. Herodes cumpleaños ie rafuena fɨnode. Ailluena illaɨcomɨnɨna ie rafuemo uaidote. Eo ucuberedɨnona jɨaɨ uaidote. ");
INSERT INTO huuNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Rafuemo Herodías jisa saillamona, Herodena iobitade. Ie uaidoganona jɨaɨ iobitade. Iobillamona, Herodes naiñaiñomo llote: —O jitailla ra cuemo jɨca. Iena omo fecaitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Illaɨma uai cuemo illa jira, iena ua fɨnoitɨcue. Nɨe isoide rana o jitaia, omo iitɨcue. Cue anamo ite naɨraɨ o jɨcadɨodena, atuedo omo iitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Iena cacajano, naiñaiño ie ei dɨne jino jaide. —¿Buena jɨcaitɨcue? —ie eimo jɨcanote. Ie ei uai ote: —Juan Bautista ɨfogɨna jɨca. ");
INSERT INTO huuNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Herodes dɨne raɨre abɨdo billanona, llote: —Juan Bautista ɨfogɨ bandejamo ja jonecaida, cuemo ine. ");
INSERT INTO huuNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Iena cacajano, Herodes sunaite; iadedɨ naimɨe llua jira, nainomo naimɨe uaidogano jɨaɨ illa jira, ie lloga uaina janoiacaiñede. ");
INSERT INTO huuNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ie facaise ie soldaduaɨmona Herodes damɨe cárcelmo orede. Juan ɨfogɨna atɨllena ocuide. Herodes ocuilla isoi fɨnode. Juan ɨfogɨna jaitade. ");
INSERT INTO huuNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Bandejamo naimɨe ɨfogɨ jonecaida, iena atɨano, Herodías jisamo fecade. Ieconi ie eimo fecade. ");
INSERT INTO huuNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Iena fɨdɨanona, Juan mɨcorɨ llofueoicaigano naimɨe mɨcorɨ abɨna uaɨbitɨmacɨ. Iena raɨtɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Jesús llofueoicaigano abɨdo bia, Jesúmo nana naimacɨ fɨnoca rafuena llotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ie facaise ailluena comɨnɨ naimacɨ dɨne biñoidɨmacɨ. Ie jira jafaicɨ ollena abɨ juanide. Guillena jɨaɨ abɨ juanide. Ie jira Jesús ie llofueoicaiganomo llote: —Jafaicɨ caɨ ollena, eneno oni mai caɨ jaillɨ. Comɨnɨ iñenanomo mai caɨ jaillɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ie muidona botedo comɨnɨ iñenanomo danɨ jaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ailluena comɨnɨ naimacɨ oni jaillana cɨodɨmacɨ. Naimacɨna uiñuamona, dɨga naɨraɨaɨmona aisɨcana jaidɨmacɨ. Jesús nia riñenia, uicodo ie jaillanomo ridɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jesús sɨjɨanona, ailluena comɨnɨna cɨode. Naimacɨna sedallena bu iñena jira, toɨca llaudaɨaɨna sedaraɨma iñena isoi, isoidɨmacɨ. Iena uiñuamona, Jesús naimacɨna duenaite. Ailluena rafuena naimacɨna llofuete. ");
INSERT INTO huuNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Jitoma ana itemo, ie llofueoicaigano naimɨe dɨne lluaɨbitɨmacɨ. Raitɨmacɨ: —Jofue bene iñede. Jaca buedɨ iñede. Jai navuiacade. ");
INSERT INTO huuNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Comɨnɨ mai abɨdo oreta. Ianori ite naɨraɨaɨmo, ianori ite jofuemo naimacɨ guille ollena, bie comɨnɨna abɨdo oreta. ");
INSERT INTO huuNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jesús uai ote: —Naimacɨna bene eca. Uai onaisɨte: —Naimacɨ guillena doscientos ucube raifi llomenico caɨ uana nɨbaɨ jitaidɨo. ");
INSERT INTO huuNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Naimacɨmo jɨcanote: —¿Nɨga llomenico omoɨmo ite? Mai jɨbuisai. Jɨbuisailla mei, raitɨmacɨ: —Cinco llomenico mena llɨcɨaɨ dɨga. ");
INSERT INTO huuNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Iena cacajano, comɨnɨmo raitɨe illanomo dajerise ana raɨllena Jesús llote. ");
INSERT INTO huuNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Naimacɨ cien dɨgamɨerie ana raɨsɨte. Jɨaɨno cincuenta dɨgamɨerie ana raɨsɨte. ");
INSERT INTO huuNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Naie cinco llomenicona, naie mena llɨcɨaɨ dɨga, Jesús uanona, monamo eruaɨllanona, Jusiñamuimo iobillacɨnona fecade. Iemei taɨllude. Ie llofueoicaiganomo fecade, comɨnɨna ecallena. Iese naie mena llɨcɨaɨ nana comɨnɨmo fecade. ");
INSERT INTO huuNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Nana guillanona monidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Monillamona, fɨebide guillena ɨraɨdɨmacɨ. Doce cɨrɨgaɨaɨmo oruitatɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Cinco mil ɨiñɨaɨ dɨese guitɨmacɨ. Naimacɨ aɨnɨaɨ, imacɨ uruiaɨ dɨga, jɨaɨ guitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Guilla mei, botedo ie llofueoicaigano ruica dɨne Betsaidamo jaillena llote. Naie facaiseconi comɨnɨna naimɨe nia facadote. ");
INSERT INTO huuNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Comɨnɨna facadua mei, aneduaɨmo dane jaide, Jusiñamui dɨga ñaɨllena. ");
INSERT INTO huuNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Jitɨbicaidemo, nainomo dama ite. Ie llofueoicaigano jorai motomo jai itɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Aɨfɨ naimacɨmo rɨire rilla jira, rɨire jaɨtɨmacɨ. Iena Jesús cɨuanona, jɨnui emododo naimacɨ dɨne bite. Naimacɨ ecɨdo naimɨe jaisaide; ");
INSERT INTO huuNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","ia naimɨena naimacɨ cɨuanona, comecɨna facadɨmacɨ: “¿Bu joreño caɨmo billana cɨodɨcaɨ?” ");
INSERT INTO huuNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Naimɨena cɨuamona, nana jacɨnaillamona cuirioidɨmacɨ. Naie dacaiño Jesús naimacɨmo llote: —Omoɨ joreñonicaiñeno. Cuesa. Jacɨruiñeno. ");
INSERT INTO huuNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Botemo Jesús jaide. Ie facaise aɨfɨ llɨɨcaide. Ieri eo raijicaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Janore guillemona ailluena comɨnɨna naimɨe ecajana jaive cɨodɨmacɨ; ia naimɨe uai siñonana nia raise uiñoñedɨmacɨ. Naimɨena nia raise ɨɨnoñedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ruica dɨne jaillanona, Genesaret railla enɨruemo ridɨmacɨ. Nainomo sɨjɨdɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Botemona arɨ jaidemo, nainomo itɨno Jesúna uiñotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Nana naie enɨruemo aisɨcana jaidɨmacɨ, duidɨno naimɨe dɨne atɨllena. Naimacɨ bɨira emododo duidɨnona atɨsɨte. Jesús illana naimacɨ fɨdɨano, iese atɨuidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Dɨga naɨraɨaɨmo naimɨe jaide. Nɨe naɨraɨmo Jesús ria, naimacɨ illano motomo duidɨnona atɨsɨte. Jilluana jitaidɨmacɨ. Ie ɨniroi fueda jetallena naimɨemo duere jɨcanotɨmacɨ. Nana naimɨe ɨniroina jetadɨno dɨese jillodɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Naie facaise fariseuaɨ comɨnɨdɨ Jesús dɨne bitɨmacɨ. Moisés mɨcorɨ llogacɨnona llofueraɨnɨ Jerusalémona jɨaɨ bitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Jesús llofueoicaiganomona damɨerie naimacɨ isoi guiñenana cɨodɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","5","Fariseuaɨ dɨnena Jesúmo jɨcanotɨmacɨ: —¿Bue ñellena omoɨ llofueoicaigano caɨ einamacɨ rafuedo jaiñedɨmacɨ? Naimacɨ guiacania, naimacɨ onollɨ caɨ einamacɨ llua isoi, raise jocoñedɨmacɨ. Ie jira caɨ abɨmo jeacɨno fɨnodomoɨ. Iese jɨcanotɨmacɨ, naimacɨ einamacɨ rafuedo naimacɨ jailla jira. Maraiñede rafue naimacɨmo suiñellena, iese ailluena judíuaɨ jaidɨmacɨ. Naimacɨ guiacania, naimacɨ einamacɨ llua isoi, onollɨna dɨga icaiño jocuano, guitɨmacɨ. Mercadomona bia, naimacɨ einamacɨ llua isoi, abɨna lleredɨmacɨ. Naimacɨ einamacɨ llua isoi, tazones, ollas, bandejas jɨaɨ jocodɨmacɨ. Iese jaisoidɨmacɨ. Comecɨna facadɨmacɨ: “Iese caɨ fɨnoia, Jusiñamuimona mare. Iese caɨ fɨnoñenia, Jusiñamuimona maraiñede. Naimɨe caɨna duere fɨnoite”. Jearede rafue naimacɨ abɨmo oñellena, iese fɨnouidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesús uai ote: —Mareuidɨnona abɨ caitauidɨnodomoɨ. Isaías mɨcorɨ jaie omoɨna raise llote. Naimɨedɨ Jusiñamui lluana cuete: Bimacɨ naimacɨ uaido marecɨnona cuemo llote; iadedɨ cue rafuedo raise jaiacaiñedɨmacɨ. “Ona isiruitɨcaɨ” llotɨmacɨ. “Ona sedadɨcaɨ” llotɨmacɨ. Jamai ñaɨtɨmacɨ. Naimacɨ comecɨaɨ cue dɨbeimo raise iñede. ");
INSERT INTO huuNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Cue uai itena, jamai comɨnɨ lluacɨnona naimacɨ llofuecabilla jira, taɨnona cuena sedadɨmacɨ cuete. ");
INSERT INTO huuNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Isaías mɨcorɨ llua isoi itomoɨ. Jusiñamui llogacɨnona faɨnonocaida, omoɨ einamacɨ rafuedo jaidomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","¿Bue ñellena nana Jusiñamui llogacɨnodo jaiñedomoɨ? Omoɨ einamacɨ llogacɨnodo jaidomoɨ; iadedɨ nana Jusiñamui llogacɨnodo raise jaiñedomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moisés mɨcorɨ jaie llote: “O moo uai ɨɨnuanona, naimɨena cano. O ei uai ɨɨnuanona, naiñaiñona cano. Ie moori jeare ñaɨtɨmɨe, ie eiri jeare ñaɨtɨmɨe meinelle”. ");
INSERT INTO huuNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Iese Moisés mɨcorɨ llote; iadedɨ omoɨ einamacɨ llotɨmacɨ: “Jusiñamuimo caɨ ucubena caɨ fecajamona, caɨ moona, caɨ eina jai canonidɨcaɨ”. ");
INSERT INTO huuNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Iese omoɨ fɨnocabilla jira, omoɨ einamacɨ llogacɨnodo omoɨ jaillamona, Jusiñamui uaina jamaidomoɨ. Bie isoide rafuedo jaca jaidomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Fariseuaɨ dɨga iese llua mei, naimɨe ecɨmo ailluena comɨnɨ dane ofillanona, naimacɨmo llote: —Iena raise omoɨ uiñollena, cue lluamo cacarei. ");
INSERT INTO huuNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Omoɨ einamacɨ isoi omoɨ guiñenia, naimacɨ isoi omoɨ onollɨna omoɨ jocoñenia, omoɨ comecɨaɨna jearetañedomoɨ. Omoɨ guillamona, omoɨ onollɨna jocuamona. Jusiñamuina nabaiñedomoɨ. Omoɨmo jeacɨno illa jira, Jusiñamuina nabaiñedomoɨ. Omoɨ comecɨaɨ jearena jira, jeacɨnona fɨnocabidomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Omoɨ jeforena jira, raise fueollena, cue lluamo cacarei. Iena ɨɨno. ");
INSERT INTO huuNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Comɨnɨmona oni jaillanona, Jesús ie risoilla jofomo jaide. Nainomo ie llofueoicaigano aillɨnano ie lluana jɨcanotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Uai ote: —¿Nɨese cue lluana jɨaɨ nia cacaiñedomoɨ? Nɨe isoide ra guitomoɨna, omoɨ comecɨaɨmo jeare iñede. ");
INSERT INTO huuNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Omoɨ comecɨaɨmo jaiñede; ia omoɨ jebemo jaide. Ie mei omoɨ abɨaɨmona jino bite. Jesús lluamona, nana guille radɨ mare uiñotɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Jesús llote: —Omoɨ comecɨaɨ jearena jira, jearede rafuena fɨnocabidomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Omoɨ comecɨaɨ jearena jira, jeare comecɨaɨna facacabidomoɨ. Omoɨ aɨñede rɨño dɨga icabitomoɨ. Omoɨ ɨniñede ɨima dɨga icabitomoɨ. Fɨɨricabitomoɨ. Comɨnɨna meinecabitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Jɨaɨ comɨnɨ rana nɨcɨdocabitomoɨ. Jearede rafuena fɨnocabidomoɨ. Iena ebiruitomoɨ. Jɨfuericabidomoɨ. Abɨna uradoicabidomoɨ. Jɨaɨe comɨnɨ joreñona jeare ñaɨcabitomoɨ. Abɨna ɨedocabitomoɨ. Ebena jaicabidomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Bie isoidɨcɨnuaɨ omoɨ comecɨaɨmo illa jira, jearede rafuena fɨnocabidomoɨ; iadedɨ omoɨ einamacɨ llua isoi, omoɨ onollɨ jocoñenamona jeacɨno comuiñede. ");
INSERT INTO huuNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Nainomona Jesús jaillanona, Tiro railla enɨruemo jaide. Sidón railla enɨruemo jɨaɨ jaide. Nainomo jofomo jaillanona, iena buna fɨdɨana jitaiñede; ia iena janonide. ");
INSERT INTO huuNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Ie facaise judío iñaiñoñedɨñaiño daño bite. Naiñaiñodɨ sirofenicia naɨraɨ iñaiño. Ie jisa Janaba anamo ite. Jesúna fɨdɨanona, naimɨe dɨne bite. Naimɨena raise uaiduanona, naimɨe ecɨmo ana bɨtadate. Ie jisamona Janabana oni oretallena Jesúmo duere jɨcade. ");
INSERT INTO huuNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Judíuaɨñedɨnona naimɨe canoñenana naiñaiño uiñollena, naiñaiñomo Jesús llote: —Uruiaɨ guillamona jɨconɨaɨna ecadɨcaɨdena, maraiñede. Uruiaɨ nano ecadɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Naiñaiño dɨnena uai ote: —Jɨɨ, maestro; iadedɨ jɨconɨaɨdɨ uruiaɨ guillamona fɨebide guillemona guitɨmacɨ. —Iese llote; ia jɨaɨe rafuemo comecɨna facade. Uruiaɨna llote; iadedɨ judíuaɨmo comecɨna facade. Jɨconɨaɨna llote; ia judíuaɨñedɨnomo jɨaɨ comecɨna facade. Comecɨna facade: “O comɨnɨmo o rafue duide; ia caɨ Namana o illa jira, nɨbaɨ o rafue caɨmo janore duide”. ");
INSERT INTO huuNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jesús uai ote: —Raise llotɨo. O jofomo mai abɨdo jai. O jisamona Janaba oni jaide. ");
INSERT INTO huuNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Naimɨe llua isoi jofomo jaide. Ie jisa bɨiramo bɨidena cɨode. Janaba naiñaiñomona oni jaillana jai uiñote. ");
INSERT INTO huuNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Tiro railla enɨruemona Jesús oni jaide. Jaillanona, Sidón railla enɨruemo jaide. Decápolis railla enɨruemo jɨaɨ jaide. Ja muidomo Galilea railla jorai fuemo ride. ");
INSERT INTO huuNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Iena fɨdɨano, naimɨe dɨne comɨnɨ jefona cacaiñedɨmɨena atɨde. Naimɨe gogoma. Naimɨena jilloitallena, naimɨemo ie onollɨ jonellena Jesúmo jɨcadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ailluena comɨnɨ naimɨe dɨne jai billa jira, jefona cacaiñedɨmɨena eneno oni uite. Nagafebe jefomo onocaɨ ñuitade. Ie onocaɨmo tuajanona, ɨima iɨfena jetade. ");
INSERT INTO huuNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Jusiñamui dɨne monamo eruaɨta, naimɨena duenaillamona, jafaicɨna faɨte. Judíuaɨ uaido naimɨemo llote: —¡Efata! —Oni dobaiñuamona: “¡Ecoricai!” raite. ");
INSERT INTO huuNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ieconi ie jefodɨ ecoricaide. Jai raise cacade. Jai raise ñaɨte. ");
INSERT INTO huuNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Comɨnɨmo: —Bimɨe jai jilluana bumo lloñeno —Jesús dɨga icaiño llote; ia naimɨe uaina ɨɨnoñedɨmacɨ. Iena llocana uitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Naimɨeri eo raijicaidɨmacɨ. Coninɨna naimɨena raitɨmacɨ: —Naga rafuena raise fɨnode. Jefona cacaiñedɨmɨena jai jillotate. Gogonaitɨmɨena jai jillotate. ");
INSERT INTO huuNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Naie facaise naimɨe dɨne ailluena comɨnɨ illanona, naimacɨ guille jai iñena jira, Jesús ie llofueoicaigano naimɨe dɨne uaidote. Raite: ");
INSERT INTO huuNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","3","—Bie comɨnɨ darui amani bene cue dɨga illa jira, naimacɨmo guille jai iñede. Damɨerie eo aarena bitɨmacɨ. Naimacɨna aimeri oretaiacaiñedɨcue, naɨsomo naimacɨ baɨi raillano. Naimacɨna cue duenailla jira, naimacɨna canoiacadɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Jɨcanotɨmacɨ: —¿Nɨese naimacɨna bene ecaitɨcaɨ? Jofue iñenanomo itɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jesús jɨcanote: —¿Nɨga llomenico omoɨmo ite? Uai otɨmacɨ: —Siete. ");
INSERT INTO huuNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Comɨnɨ ana raɨllena Jesús llote. Naie llomenicona uanona, Jusiñamuimo iobillacɨnona fecade. Taɨlluanona, ie llofueoicaiganomo fecade, naie comɨnɨmo fecallena. Iena fɨnodɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Naimacɨmo janore llɨcɨsɨrɨaɨ jɨaɨ ite. Ie facaina Jusiñamuimo iobillacɨnona fecaja mei, comɨnɨmo fecallena Jesús llote. ");
INSERT INTO huuNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Nana guitɨmacɨ. Monidɨmacɨ. Monillamona, fɨebide guillena ɨraɨdɨmacɨ. Siete cɨrɨgaɨaɨmo oruitatɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Nainomo cuatro mil ɨiñɨaɨ guitɨmacɨ. Naimacɨ aɨnɨaɨ, imacɨ uruiaɨ dɨga, jɨaɨ guitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Guilla mei, comɨnɨna naimacɨ jofuemo Jesús orede. Ie llofueoicaigano dɨga, botemo jaillanona, Dalmanuta railla enɨruemo jaide. ");
INSERT INTO huuNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Dajerie fariseuaɨ comɨnɨ Jesús dɨne bitɨmacɨ. Naimɨe uaina uaitaiacadɨmacɨ. Naimɨena facacɨllena, siño rafuena fɨnuana jɨcanoiacadɨmacɨ. Iena naimɨe fɨnoñedena, naimɨe ie llua isoi iñenana uiñotɨmacɨ. Naimɨena duere fɨnoacadɨmacɨ. Llotɨmacɨ: —Iena caɨ cɨoillena, Jusiñamuina siño rafuena fɨnota. ");
INSERT INTO huuNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Sunaillanona, Jesús jafaicɨ faɨte. Raite: —¿Bue ñellena siño rafuena fɨnuana cɨoiacadomoɨ? Omoɨ facaina iena fɨnoñeitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ie llua mei, naimacɨmona oni jaidɨmacɨ. Ie llofueoicaigano dɨga, botemo dane jaillanona, ruica dɨne Jesús jaide. ");
INSERT INTO huuNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ruica dɨne rilla mei, Jesús llofueoicaigano llomenicona feillana uibiñotɨmacɨ. Naimacɨmo daje llomenico ite. ");
INSERT INTO huuNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Iena naimɨe uiñuamona, naimacɨmo Jesús llote: —Fariseuaɨ sɨritate ramona abɨna rairui. Illaɨma Herodes sɨritate ramona abɨna rairui. —Iese Jesús llote; iadedɨ naimacɨ llofuiacɨnomona abɨ rairuillena ñaɨte. ");
INSERT INTO huuNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Jesús iese llua jira, iena naimacɨ raise cacaiñena jira, danɨ coninɨri siadotɨmacɨ: —Llomenicona caɨ atɨñena jira, caɨmo iese llote. ");
INSERT INTO huuNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Naimacɨ siaduana Jesús uiñua jira, naimɨe lluana naimacɨ raise nia cacaiñena jira, naimacɨmo jɨcanote: —¿Bue ñellena iese siadotomoɨ? ¿Nɨese cuena ɨɨnoñedomoɨ? Cuemo siño uai illana nia raise cacaiñedomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Uisɨredomoɨ. Jeforedomoɨ. ¿Nɨese cue navui siño fɨnoca rafuemo comecɨaɨna facañedomoɨ? ");
INSERT INTO huuNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Navui cinco mil ɨiñɨaɨ cinco dɨga llomenicona guitɨmacɨ. Monillamona, guigamona fɨebillamona, ¿nɨga cɨrɨgaɨaɨmo ɨraɨdomoɨ? Uai otɨmacɨ: —Doce. ");
INSERT INTO huuNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Jesús llote: —Jɨaɨcaiño cuatro mil ɨiñɨaɨ siete dɨga llomenicona guitɨmacɨ. Monillamona, guigamona fɨebillamona, ¿nɨga cɨrɨgaɨaɨmo ɨraɨdomoɨ? Uai otɨmacɨ: —Siete. ");
INSERT INTO huuNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Jesús dɨnena jɨcanote: —¿Nɨese cuena nia raise ɨɨnoñedomoɨ? Siño uai cuemo illana nia raise ɨɨnoñedomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Oni macarillanona, Betsaidamo Jesús, ie llofueoicaigano dɨga, ride. Ie facaise naimɨe dɨne comɨnɨ uisɨnidɨmɨena atɨde. Naimɨena jilloitallena, naimɨena jetallena, Jesúmo jɨcanote. ");
INSERT INTO huuNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Iena Jesús cacajanona, ie onollɨna llɨnuanona, naɨraɨ illa jinofemo uisɨnidɨmɨena uite. Ie mei ie uisɨna tuade. Ie uisɨna jɨaɨ jetade. Naimɨemo jɨcanote: —¿Buena cɨodɨo? ");
INSERT INTO huuNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","A eruaɨllanona, uai ote: —Comɨnɨ macarillana cɨodɨcue; ia amena isoi eruaɨdɨmacɨ. Nia raise cɨonidɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ie uisɨna Jesús dane jetade. Iemona oni erocaillamona, jai jillode. Jai raise cɨode. ");
INSERT INTO huuNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jai jillua jira, ie jofomo naimɨena abɨdo orede. Jesús llote: —Betsaidamo itɨno o jilluana lloñeno; ia nainomo jaiñeno o jofomo mai abɨdo jai. ");
INSERT INTO huuNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Cesarea Filipo enɨruemo ite naɨraɨaɨmo Jesús jaidemo, ie llofueoicaiganomo jɨcanote: —¿Nɨese jɨaɨe comɨnɨ cuena raitɨmacɨ? ");
INSERT INTO huuNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Uai otɨmacɨ: —Damɨerie raitɨmacɨ: “Juan Bautista mɨcorɨdɨo”. Damɨerie raitɨmacɨ: “Odɨ Elíadɨo”. Jɨaɨno raitɨmacɨ: “Jusiñamui facaina jaie ite lloraɨnɨmona damɨe jai jillode. Imɨedɨo”. ");
INSERT INTO huuNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Jesús dane jɨcanote: —¿Nɨese omoɨ cuena raitomoɨ? Pedro uai ote: —Odɨ caɨ Jilloitaraɨmadɨo. Jusiñamui facaina lloraɨnɨ mɨcorɨaɨ o billena jaie llotɨmacɨ ");
INSERT INTO huuNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Jesús iena bumo lluana rairuide. ");
INSERT INTO huuNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ie facaise ie llofueoicaiganona ie duere sefuillena llofuete. Llote: —Caɨ judíuaɨ illaɨcomɨnɨ cuena eo duere fɨnoitɨmacɨ. Cuena jitaiñellemona, cuena meineitɨmacɨ; iadedɨ darui amani illanona, fiodaillamona jilloitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Iena marefodo naimacɨmo llote. Iena cacajano, Pedro dɨnena lletade: —Dama ite. Iese lloñeno. Bie isoide rafuena lloñeno. ");
INSERT INTO huuNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ie llofueoicaiganomo erodajanona, Jesús Pedromo rɨire llote: —Cuemona oni jai. Iese ñaɨñeno, Taɨfe isoi o comecɨna o facaja jira. Jusiñamui isoi cuemo comecɨna facañedɨo. Comɨnɨ isoi cuemo comecɨna facadɨo. ");
INSERT INTO huuNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Naimɨe dɨne ailluena comɨnɨ uaidua mei, ie llofueoicaigano nainomo jɨaɨ illanona, naimacɨmo llote: —Cue comɨnɨna bu jaiacania, ie jitaille rafuedo jaiñena. Cue dɨbeimo naimɨe jaillamona, duere sefuicana jaite. Nɨbaɨ naiemona fiodaite. Bu iese jaiacania, cue dɨbeimo naimɨe iite. ");
INSERT INTO huuNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","37","Duere sefuillana jacɨruillamona, cue comɨnɨna bu jaiacaiñenia, ja muidomo faɨfite; iadedɨ duere sefuillana jacɨruiñenamona, cue comɨnɨna bu jaia, jaca faɨfiñeite. Cue comɨnɨna bu jaiñenia, nɨbaɨ eo duere sefuiñeite. Nɨbaɨ ailluena ra naimɨemo iite; ia, ¿nɨese cue Moo dɨne riite? Nainomo naimɨe riñeno faɨfite. ");
INSERT INTO huuNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Birui ite comɨnɨ Jusiñamuina jitaiñedɨmacɨ. Naimɨena jai faɨnonocaidɨmacɨ. Jeacɨnona fɨnocana jaidɨmacɨ. Cuena bu meiruia, cue rafuena bu meiruia, dane cue bia, naimɨena meiruitɨcue. Cuena meiruillamona: “Cristomo duidɨcue” bu lloiacaiñenia, ɨco cue bia: “Naimɨedɨ cue comɨnɨ” lloñeitɨcue. Jusiñamui jaɨenisaɨ dɨga, cue Moo dɨnena, monamona ɨco biitɨcue. Cue Moo uai cuemo illanona, ebire biitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","’Omoɨmo uanaicɨnona llotɨcue. Omoɨmona dajerie nia fiodaiñeitomoɨmo, illaɨmana ebire cue bairellena cɨoitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Seis dɨgarui illanona, anedumo comɨnɨ iñenanomo Jesús jaide. Naimɨe dɨga jaillena, Pedrona uite. Jacobo jɨaɨ uite. Juan jɨaɨ uite. Jɨaɨe llofueoicaiganona uiñede. Nainomo rilla mei, naimacɨ uicomo naimɨe abɨ meidocaide. ");
INSERT INTO huuNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Naie dacaiño naimɨe ɨniroi eo quenirecaide. Eo userecaide. Caɨ ɨniroimo jitoma llɨgaiñuamona ie isoi usere jaca jaiñede. ");
INSERT INTO huuNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Naie facaise naimacɨmo Moisés mɨcorɨ joreño, Elías dɨga, bairede. Elíadɨ Jusiñamui facaina jaie lloraɨma. Jesús dɨga ñaɨtɨiaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Iaɨmaiaɨ jaiacania, Pedro Jesúmo llote: —Maestro, bene caɨ illana mare. Daje amani bɨsaini caɨ fɨnollena, mare. Daje oɨe, jɨaɨe Moisés mɨcorɨ ie, jɨaɨe Elías ie. ");
INSERT INTO huuNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Eo jacɨruilla jira, naimɨe ñaɨa rafuena raise uiñoñeno jamai ebena ñaɨte. ");
INSERT INTO huuNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ie facaise uillɨe billamona, naimacɨna ɨbaide. Uillɨemona Jusiñamui llote: —Bimɨe cue isiruiga Jito. Naimɨe lluamo cacareillanona, iena ɨɨno —llote. ");
INSERT INTO huuNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ieconi oni erodajanona, dama Jesúna cɨodɨmacɨ. Jɨaɨnona cɨoiñedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Anedumona bitɨmacɨmo, naimacɨmo Jesús llote: —Omoɨ aillɨ cɨua rafuena bumo lloñeno, cue fiodaillamona cue jillua dɨnori. ");
INSERT INTO huuNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Jesús llua isoi fɨnodɨmacɨ. Iena bumo lloñedɨmacɨ; ia fiodaillamona naimɨe jilluana naimacɨ raise nia cacaiñena jira, iemo comecɨna facadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Naimɨemo llotɨmacɨ: —Moisés mɨcorɨ llogacɨnona llofueraɨnɨ birui raicabitɨmacɨ: “Elías raillamɨe dane biite. Ie mei caɨ Jilloitaraɨma biite” raitɨmacɨ. Jusiñamuimona o billana ɨɨnotɨcaɨ. Odɨ caɨ Jilloitaraɨmana ɨɨnotɨcaɨ. Odɨ caɨ Jilloitaraɨmadɨomo, ¿bue ñellɨ iese raitɨmacɨ? ");
INSERT INTO huuNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Uai ote: —Raise ɨɨnotomoɨ. Elías isoidɨmɨe jai bite, nana Jusiñamui jitailla rafue raise llollena. Jusiñamui dɨbeimo naimacɨ illena, comɨnɨ imacɨ comecɨaɨ meiduana llote. Jusiñamui facaina lloraɨnɨ mɨcorɨaɨ cue eo duere sefuillena cuetɨmacɨ. Comɨnɨ cue jeare fɨnollena cuetɨmacɨ. Iemo omoɨ comecɨaɨna jɨaɨ faca. ");
INSERT INTO huuNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Elías isoidɨmɨe jai bite; iadedɨ Jusiñamui facaina lloraɨma mɨcorɨ jaie cuega isoi, naimacɨ jitailla jira, naimɨena jai meinetɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ie jɨaɨe llofueoicaigano dɨne Jesús abɨdo ria, nainomo ailluena comɨnɨ itɨmacɨmo ride. Moisés mɨcorɨ llogacɨnona llofueraɨnɨ dɨnena ie llofueoicaigano uaina uaitasɨde. ");
INSERT INTO huuNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Jesús billana comɨnɨ cɨuanona, jacɨnaisɨdɨmacɨ. Naimɨena feiñollena, naimɨe dɨne aisɨda jaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Moisés mɨcorɨ llogacɨnona llofueraɨnɨmo Jesús jɨcanote: —¿Nɨese cue llofueoicaigano uaina uaitatomoɨ? ");
INSERT INTO huuNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Uai oñedɨmacɨ; ia comɨnɨmona damɨe uai ote: —Maestro, Janaba anamo cue jito illa jira, o dɨne naimɨena atɨdɨcue. Cue jito Janaba anamo illamona ñaɨnide. ");
INSERT INTO huuNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Nagarui Janaba bille dɨese, naimɨena enɨruemo uaitate. Iemona fuedɨ mullede. Ie isidodɨ murude. Ie abɨ jaɨaɨre jaide. O llofueoicaiganomo jɨcadɨcue, Janabana oni oretallena; ia oretanidɨmacɨ. Ie jira Moisés mɨcorɨ llogacɨnona llofueraɨnɨ bie rafuena, o llofueoicaigano dɨga, uaina uaitatɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Iena cacajanona, Jesús ie llofueoicaiganomo llote: —Cue uai siñonana nia ɨɨnoñedomoɨ. Omoɨ dɨga are itɨcue. Raise omoɨ ɨɨnollena, ¿nɨe dɨnori omoɨ dɨga iitɨcue? Naie duidɨmɨe moomo llote: —O jito cue dɨne mai atɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Naie urue Jesús dɨne atɨanona, Janaba naimɨena naɨllitate. Iemona urue enɨruemo uaide. Jabɨ-jabɨde. Fue mullede. ");
INSERT INTO huuNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesús dɨnena naie urue moomo jɨcanote: —¿Nɨe dɨnori o jitodɨ bie isoi ite? Uai ote: —Naimɨe uruenamona. ");
INSERT INTO huuNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Janabadɨ, dɨga icaiño iraimo usillena, naimɨena uaitate. Corobaillena, dɨga icaiño jɨnuimo jɨaɨ uaitate. Janaba oni o oretarenia, cocona duenaillamona, cocona cano. ");
INSERT INTO huuNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesús uai ote: —“O oretarenia” raitɨo. Ero, o jito jillotaredɨcue. Cuena o ɨɨnoia, o jito jilloite. ");
INSERT INTO huuNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Naie urue moo ieconi llote: —Ona ɨɨnotɨcue. Raise nia cue ɨɨnoñenia, cuena raise ɨɨnota. ");
INSERT INTO huuNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Naie facaise ailluena comɨnɨ naimɨe dɨne raɨre ofillana naimɨe cɨuanona, Jesús Janabana lletade: —Bie uruena ñaɨtatañedɨo. Naimɨena cacaitañedɨo. Naimɨemona oni jai. Naimɨe dɨne dane biñeno. ");
INSERT INTO huuNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ado cuirioillanona, naimɨena eo rɨire naɨllitajanona, Janaba oni jaide. Iemona naie urue fiodaitɨmɨe isoi erocaide. Naimɨena cɨuanona, nainomo itɨno raitɨmacɨ: —Naimɨe jai fiodaite; ");
INSERT INTO huuNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","—ia Jesús naimɨe onollɨna llɨnocaida, naimɨena a naidanete. ");
INSERT INTO huuNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Iemona oni jaillanona, damɨe jofomo Jesús naillɨ ria, naimɨemo ie llofueoicaigano anado jɨcanotɨmacɨ: —¿Bue ñellena Janabana oni oretanidɨcaɨ? ");
INSERT INTO huuNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jesús uai ote: —Jusiñamuimo omoɨ jɨɨamona, naimɨena raise omoɨ ɨɨnuamona, bie isoide Janabana oretaredomoɨ. Naimɨena omoɨ raise ɨɨnoñena jira, bie uruemona Janabana oni oretañedomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Ie llofueoicaigano dɨga Jesús oni jaillanona, Galilea railla enɨruemo jaide. Ie llofueoicaiganona naimɨe llofueiacana jira, naimɨe ie jaillana jɨaɨe comɨnɨ fɨdɨana jitaiñede. Naimacɨmo llote: —Monamona billanona, ɨimana jaidɨcue. Jusiñamui jitailla jira, cuena jɨaɨe comɨnɨ gaɨtajanona, illaɨcomɨnɨmo fecaitɨmacɨ. Naie illaɨcomɨnɨ cuena meineitɨmacɨ; iadedɨ darui amani illanona, jilloitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ie llofueoicaigano iena raise cacaiñedɨmacɨ; ia naimɨemo iena jɨcanuana meiruitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Capernaumo Jesús rilla mei, ie risoilla jofomo naimɨe ia, ie llofueoicaiganomo jɨcanote: —Naɨsona caɨ bia, ¿nɨe isoide rafuena coninɨri siadotomoɨ? ");
INSERT INTO huuNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Uai oñedɨmacɨ. Naimacɨ moto imɨena illena, naɨsodo siadocana bitɨmacɨ. Meiruillanona, uai oñedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Naimɨe ana raɨnadaja mei, ie ecɨmo naimacɨna uaidote. Raite: —Omoɨ moto imɨena bu iacania, jamai bue isoidɨmɨena naimɨe illa. Omoɨ muillaɨmana naimɨe jailla isoilla. ");
INSERT INTO huuNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Iena naimacɨ raise uiñollena, nainomo ite comɨnɨmona daje urue baɨ jaɨnanocaida, naimacɨ motomo naimɨena jonete. Naimɨena menioita, naimacɨmo llote: ");
INSERT INTO huuNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Jusiñamuimona bie urue jamai bue isoide. Abɨna ɨedoñede. Bie isoidɨmɨe cuemo duillamona, naimɨena feiñotɨmɨedɨ cuena jai feiñote. Cuena feiñotɨmɨe Jusiñamuina jɨaɨ jai feiñote, Jusiñamui cuena oretaja jira. ");
INSERT INTO huuNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Naie facaise ie llofueoicaiganomona Jesúmo Juan llote: —Maestro, o mamecɨdo jananɨaɨna oretacabitɨmɨena cɨodɨcaɨ. Caɨ dɨga naimɨe jaicabiñena jira, iena fɨnuana rairuidɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jesús uai ote: —Naimɨena rairuiñeno. Cue mamecɨdo siño rafuena bu fɨnoia, cuena jeare raɨre ñaɨñeite. ");
INSERT INTO huuNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Caɨ dɨbeimo itɨmɨedɨ caɨ facaisena ite. ");
INSERT INTO huuNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ero, cuemo omoɨ duillamona, omoɨna bu janore canoia, Jusiñamuimona ɨbana feiñoite. Omoɨmo nɨbaɨ jamai jɨnuina fecaite; iadedɨ omoɨna naimɨe canuamona, Jusiñamuimona ɨbana feiñoite. Ie jira naimɨe isoidɨno siño rafuena fɨnuana rairuiñeno. ");
INSERT INTO huuNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Jesús nia llofuete: —Cuena como ɨɨnotɨnona jeacɨnona fɨnotaiacadɨmɨe iena fɨnoñellena, naimɨe cɨmaɨomo aillue nofɨcɨ maɨanona, joraimo corobaillena naimɨena dotacadena, mare. ");
INSERT INTO huuNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","48","Biena ñaɨtɨcue. Nɨe isoide rafue omoɨna jeacɨno fɨnotaia, iena llɨnoñeno. Naie rafue dɨne jaiñeno. Iemo eruaɨñeno. Rana omoɨ jetaja jira, omoɨ cɨua rana jira, omoɨ jitaillamona jeacɨnona fɨnocabidomoɨ. Omoɨ abɨna omoɨ namatañenia, omoɨ onollɨna jaita. Omoɨ eɨllɨna jaita. Omoɨ uisɨna juicono. Iemona jeacɨnona fɨnoñellena, Jusiñamui dɨne daje onollɨ dɨga, daje eɨllɨ dɨga, daje uisɨ dɨga riitomoɨ; ia jeacɨno omoɨ fɨnoia, iraimo jaitomoɨ. Nana omoɨ abɨ dɨga iraimo jaitomoɨ. Omoɨ comecɨna ñaɨtɨcue. Omoɨ abɨna omoɨ raise namatallena, omoɨ comecɨ nano raise fɨno. Iraimo omoɨ jaiñellena, jeacɨno fɨnoñeno. Naimacɨmo ite aɨaɨ fiodaiñena jira, naie irai jaca duiñenamona, nainomo itɨno jaca duere sefuitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Ero, birui omoɨ duere sefuillamona, cue comɨnɨna jai jaidɨnona uiñoitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Guille caɨmaretallena, sal mare; iadedɨ ie caɨmano jai iñenia, iena dane caɨmaretañedɨcaɨ. Ie isoide. Jeacɨno omoɨ fɨnoia, omoɨ comecɨaɨ caɨmare iñede. Jusiñamui jitaillacɨnona omoɨ fɨnuamona, coninɨri caɨmare omoɨ i. Coninɨri uri omoi i. ");
INSERT INTO huuNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Capernaumona ie llofueoicaigano dɨga, Jesús oni jaillanona, Judea railla enɨrue dɨne jaide. Jordán railla ille ruica dɨbeimo jaide. Ailluena comɨnɨ naimɨe dɨne ofillamona, naimɨe llofueuilla isoi, naimacɨna llofuete. ");
INSERT INTO huuNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Naimɨena facacɨllena, dajerie fariseuaɨ naimɨe dɨne bitɨmacɨ. Rafuena jɨcanoiacadɨmacɨ. Naimacɨ uai naimɨe raise oñenia, naimɨena duere fɨnoacadɨmacɨ. Jɨcanotɨmacɨ: —¿Ɨima ie aɨna dotajana rairuidɨo? ");
INSERT INTO huuNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Uai ote: —¿Nɨese Moisés mɨcorɨ llote? ");
INSERT INTO huuNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Uai otɨmacɨ: —Moisés mɨcorɨ jaie cuete: “Ɨima ie aɨna dotaacania, dotalle rabena nano cueite. Ie mei naiñaiñona dotaite”. ");
INSERT INTO huuNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jesús uai ote: —Jusiñamui uaina raise omoɨ ɨɨnoñena jira, Moisés mɨcorɨ ɨima ie aɨna dotajana rairuiñede; ");
INSERT INTO huuNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","iadedɨ nano dofoconi iese iñede. Enɨrue fɨnua facaiseconi Jusiñamuidɨ come iaɨmaiaɨna fɨnode. Ɨimana fɨnode. Rɨñona jɨaɨ fɨnode. ");
INSERT INTO huuNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ie jira Jusiñamuidɨ jaie llote: “Ie aɨ dɨga illena, ɨima ie moona faɨnonocaite. Ie eina jɨaɨ faɨnonocaite. Ie aɨ dɨga illamona, menade comedɨ daamɨena jai jaide” llote. ");
INSERT INTO huuNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Menade come jai daamɨena jai ite. ");
INSERT INTO huuNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Jusiñamui iese iaɨmaiaɨna itataja jira, ɨima ie aɨna dotajana rairuidɨcue. Rɨño ie ɨnina dotajana rairuidɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Jofomo ie llofueoicaigano dɨga, naimɨe naillɨ illanona, naimɨemo bie rafuena jɨcanotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jesús dɨnena llote: —Jɨaɨe rɨño dɨga naimɨe illena, ie aɨna bu dotaia, naimɨedɨ jeacɨnona jai fɨnode. Ie aɨna jeare jɨaɨ fɨnode. ");
INSERT INTO huuNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ie ɨnina faɨnonocaillanona, jɨaɨmɨena nɨe rɨño uamona, naiñaiño jeacɨno jai fɨnode. ");
INSERT INTO huuNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Naie facaise Jesús dɨne comɨnɨ naimacɨ jesanide dɨese atɨdɨmacɨ. Ie onollɨ naimacɨmo naimɨe joniana jitaidɨmacɨ. “Naimacɨna raise cano” ie Moomo llollena jitaidɨmacɨ. Ie llofueoicaigano iena rairuidɨmacɨ; ");
INSERT INTO huuNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","iadedɨ iena cacajano, Jesús icɨrite. Jesús raite: —Uruiaɨ cue dɨne billesa. Naimacɨna rairuiñeno. Cuena bie isoi ɨɨnotɨnodɨ Jusiñamui comɨnɨdɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Bie uruiaɨ abɨna ɨedoñedɨmacɨ. Einamacɨmona jamai bue isoidɨmacɨ. Naimacɨ isoi bu iñenia, Jusiñamui comɨnɨna jaiñeitɨmacɨ. Jusiñamui naimɨena sedallena, Jusiñamui comɨnɨna naimɨe jaiñeite. ");
INSERT INTO huuNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Naie uruiaɨ dasarie meni-menioicaida, naimacɨ ɨfogɨmo ie onollɨna joneta: —Jusiñamui omoɨna canoite —llote. ");
INSERT INTO huuNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ie llofueoicaigano dɨga Jesús oni jai jaillanona, aisɨcana damɨe naimɨe dɨne bite. Naimɨena raise uaidollena, ie caiñɨcɨ ɨfodo raɨnadate. Raite: —Maestro, odɨ maremɨedɨo. Jusiñamui dɨga ɨco cue jaca illena, ¿buena fɨnoitɨcue? ");
INSERT INTO huuNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesús uai ote: —¿Bue ñellena odɨ: “Mare” cuena raitɨo? Dama damɨe maremɨe. Naimɨedɨ Jusiñamui. Naimɨemo jɨcano. ");
INSERT INTO huuNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Moisés mɨcorɨ llogacɨnuaɨna ɨɨnocana jai. Jaie cuete: “Comena meineñeno. O aɨñede rɨño dɨga iñeno. Fɨɨñeno. Jɨaɨmɨena o llogɨdoia, taɨnona lloñeno. O moo uaina ɨɨno. O ei uaina ɨɨno”. ");
INSERT INTO huuNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Uai ote: —Maestro, uruena cue illa facaisemona nana bie llogacɨnuaɨna ɨɨnotɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesús dɨnena naimɨemo eruaɨllanona, naimɨe ie comecɨdo jaide. Naimɨemo llote: —Omo daje rafue fɨebide. Jusiñamui jitaillacɨnodo o jaiacania, o raise marebicaiacania, omo ite raruiaɨna feca. Naie ucubena dueredɨnomo feca. Cuena o ɨɨnuamona, monamo ɨco jaca iitɨo. Cue llofuegamɨena o illena, mai cue dɨga bi. ");
INSERT INTO huuNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Iena cacajano, naimɨedɨ sunaite. Eo aillue ra naimɨemo illa jira, iena naimɨe fecaacaiñena jira, sure jaide. ");
INSERT INTO huuNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Naimɨe jailla mei, ie llofueoicaiganomo eruaɨllanona, naimacɨmo llote: —Ucuberedɨnodɨ Jusiñamui comɨnɨna jaillena eo sefuiruitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Iena cacajano, iena naimacɨ raise cacaiñena jira, Jesús dane llote: —Cue comɨnɨdomoɨ. Ero, ucuberedɨmɨedɨ Jusiñamui comɨnɨna jaillena eo sefuiruite. ");
INSERT INTO huuNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Igɨdo ifodo camello jaca jainide. Ie isoide. Ie ra isiruillamona, ucuberedɨmɨedɨ Jusiñamui ie comɨnɨna jɨaɨ raise jainide. ");
INSERT INTO huuNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Iena ie llofueoicaigano cacajano, Jusiñamui comɨnɨna ucuberedɨno raise jainina jira, “¿Nɨese dueredɨnodɨcaɨdɨ Jusiñamui comɨnɨna jaitɨcaɨ?” raillamo comecɨaɨna facadɨmacɨ. Raijicaillanona, coninɨri raitɨmacɨ: —Nana comɨnɨ rana jitailla jira, ¿buca jillobitɨ? ");
INSERT INTO huuNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Naimacɨmo eruaɨllanona, Jesús raite: —Nana comɨnɨ danɨ jillobinidɨmacɨ; iadedɨ Jusiñamuidɨ naimacɨna jillobitarede. ");
INSERT INTO huuNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pedro dɨnena llote: —O llua isoi jai fɨnodɨcaɨ. Nana caɨ rana faɨnonocaida, o dɨga jai jaicabidɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesús uai ote: —Uanaicɨno lloitɨcue. Cuena naimɨe isiruillamona, cue rafuena naimɨe lluamona, ie jofona bu faɨnonocaia, ie amatɨaɨna bu faɨnonocaia, ie mirɨñuaɨna bu faɨnonocaia, ie moona bu faɨnonocaia, ie eina bu faɨnonocaia, ie uruiaɨna bu faɨnonocaia, ie enɨruena bu faɨnonocaia, ");
INSERT INTO huuNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Jusiñamuimona birui ailluena ɨbana feiñoite. Duere sefuite; ia naimɨe isoi cue comɨnɨna ailluena jaillamona, naimɨe jofue iite. Ie amatɨaɨ, ie mirɨñuaɨ, ie eitɨaɨ, ie uruiaɨ, ie enɨrue birui iite. Monamo naimɨe ɨco caɨmare iocɨre jaca iite. ");
INSERT INTO huuNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Birui damɨeriemo ailluena ra illamona, Jusiñamuimo eo comecɨna facañedɨmacɨ. Naimacɨmona jamai bue isoiñedɨmacɨ; ia Jusiñamuimona ɨco jamai bue isoitɨmacɨ Jɨaɨnomo ailluena ra birui iñede; ia Jusiñamuimo comecɨna facadɨmacɨ. Naimacɨmona jamai bue isoidɨmacɨ; ia Jusiñamuimona ɨco jamai bue isoiñeitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jerusalémo nia jaillanona, Jesús uicodo jaide. Nainomo naimɨe jacɨruiñeno jaillamona, ie llofueoicaigano raijicaidɨmacɨ. Naimacɨ dɨga jaidɨno jacɨruioicaida jaidɨmacɨ. Naimacɨna jɨaɨ meiniana jacɨruitɨmacɨ. Ie llofueoicaigano dɨga ñaɨanona, naimɨemo suille rafuena llote: ");
INSERT INTO huuNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","—Ero, Jerusalémo jai jaidɨcaɨ. Monamona billanona, ɨimana jaidɨcue; iadedɨ omoɨ illaɨcomɨnɨ cuena gaɨtaitɨmacɨ. Gaɨtaja mei, cue meinellena lloitɨmacɨ. Judíuaɨñedɨno illaɨcomɨnɨmo cuena fecaitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Cueri jɨfanoitɨmacɨ. Cuena tuallaɨtɨmacɨ. Cuena faitɨmacɨ. Cuena meineitɨmacɨ; iadedɨ cue fiodailla mei, darui amani illanona, jilloitɨcue —llote. ");
INSERT INTO huuNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Naie facaise Jesús dɨne Jacobo, Juan dɨga bitɨiaɨmaiaɨ. Iaɨmaiaɨ moodɨ Zebedeo. Raitɨiaɨmaiaɨ: —Omo coco jɨcalle rafue cocoena fɨnuana jitaidɨcoco. ");
INSERT INTO huuNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jesús uai ote: —¿Nɨe isoide rafuena jitaidomɨco? ");
INSERT INTO huuNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Uai otɨiaɨmaiaɨ: —Illaɨmana o jailla mei, o ecɨmo coco illena o lluana jitaidɨcoco. Damɨe o nabeimo. Jɨaɨmɨe o jarɨfebeimo. —Jɨaɨno afemo iaɨmaiaɨ illena, iese llotɨiaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jesús dɨnena llote: —Omɨco jɨcanuana raise uiñoñedomɨco. Cue eo duere sefuitɨcue. Llegɨ cacaitɨcue. ¿Ie isoi duere sefuiacadomɨco? ¿Ie isoi llegɨ cacaiacadomɨco? ");
INSERT INTO huuNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Uai otɨiaɨmaiaɨ: —Jɨɨ. Sefuiacadɨcoco. Jesús dɨnena raite: —Cue isoi duere sefuitomɨco. Llegɨ cacaitomɨco; ");
INSERT INTO huuNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","iadedɨ cue nabeimo omɨco illena, cue jarɨfebeimo omɨco illena itatanidɨcue. Naie illano jai cue Moo fɨnoca, nainomo iitɨno iena. ");
INSERT INTO huuNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Iena jɨaɨe llofueoicaigano cacajano, naie iaɨmaiaɨri icɨritɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jesús nana naimacɨna uaiduanona, raite: —Nana illaɨcomɨnɨdɨ naimacɨ anamo itɨnona ocuicabidɨmacɨ; ");
INSERT INTO huuNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","iadedɨ omoɨ dɨne iese iñena. Omoɨmona bu imɨena iacania, omoɨ mullaɨmana naimɨe jaisoillasa. ");
INSERT INTO huuNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Omoɨmona bu imɨena iacania, omoɨna naimɨe canocana jaisoillasa. ");
INSERT INTO huuNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Cuemona fueo. Biñedɨcue, comɨnɨna cue ocuillena; iadedɨ comɨnɨna canuaɨbidɨcue. Cue jitailla jira, nana comɨnɨ facaina fiodaisaɨbitɨcue. Naimacɨ jeacɨnomona naimacɨ jillobillena, fiodaisaɨbitɨcue. Ailluena comɨnɨ cuena ɨɨnuamona, jilloitɨmacɨ. Coninɨna omoɨ canua —llote. ");
INSERT INTO huuNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Oni jaillanona, Jericó railla naɨraɨmo Jesús ride. Naiemona ie llofueoicaigano dɨga jaillanona, ailluena comɨnɨ Jesús jɨnafona racadɨmacɨ. Naie facaise naɨ fuemo uisɨnidɨmɨe raɨde. Naimɨe mamecɨ Bartimeo. Timeo jito. Nainomo jamai raɨde, ucubena jamai jɨca-jɨcallena. ");
INSERT INTO huuNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Nazaret ie Jesús jaillana naimɨe cacajano, ado cuirioide: —David mɨcorɨ Jitona o illamona, Jusiñamuimona o billa jira, cuena duenai. Cuena cano. ");
INSERT INTO huuNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Naimɨe llɨɨcaillena, Jesús dɨga jaidɨno naimɨena lletade; iadedɨ eo cuirioide: —Maestro, David mɨcorɨ Jitona o illamona, cuena duenai. ");
INSERT INTO huuNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Naimɨena cacajano, Jesús naidadajanona, llote: —Naimɨena cue dɨne uaido. Bartimeona uaiduanona, raitɨmacɨ: —O comecɨna ocuiño. Mai naidacai. Jesús ona uaidote. ");
INSERT INTO huuNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Iena cacajano, ie emodomo itɨroina duiñuanona, raɨre naidacaida, Jesús dɨne bite. ");
INSERT INTO huuNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Naimɨemo Jesús jɨcanote: —¿Nɨese ona cue nɨbaɨana jitaidɨo? Uai ote: —Maestro, cɨoacadɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesús dɨnena uai ote: —Cuena o ɨɨnua jira, jai jillodɨo. Mai jai. —Ieconi naimɨe jai cɨode. Jesús dɨga jaidɨno dɨga naimɨe jɨaɨ jaide. ");
INSERT INTO huuNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Oni jaillanona, Jerusalémo iaɨreicaidɨmacɨmo, Betfagé railla naɨraɨmo ie llofueoicaigano dɨga Jesús ride. Betania nainomo jɨaɨ ite. Olivos railla anedumo naga naɨraɨ iaɨmaiaɨ ite. Ie llofueoicaiganomona Jesús menamɨena orede. ");
INSERT INTO huuNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Raite: —Bie naɨraɨ illa uicomo mai omɨco jai. Nainomo omɨco ria, cuinaca burritona baitomɨco. Ie emodomo nia buna jaiñede. Iena suiñuanona bene atɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Omɨcomo: “¿Bue ñellena iena suiñodomɨco?” bu jɨcanoia, llono: “Coco Nama iena jitaide. Naillɨ iena raɨre abɨdo oretaite llote”. ");
INSERT INTO huuNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Naimɨe llua isoi, jaidɨiaɨmaiaɨ. Naɨsomo jofo nasemo burritona baillanona, iena suiñodɨiaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ie facaise nainomo itɨno jɨcanote: —¿Bue ñellena burritona suiñodomɨco? ");
INSERT INTO huuNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Jesús llua isoi uai otɨiaɨmaiaɨ. Ie muidona: —Jee —raitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Burritona atɨdɨaɨmaiaɨ. Ie emodomo naimɨe llofueoicaigano naimacɨ ɨniroi jobianona, ie emodomo Jesús raɨnadate. ");
INSERT INTO huuNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Naimɨena iobitallena, illaɨma isoi naimɨe jaillena, dɨga comɨnɨ, imacɨ ɨniroi dɨga, naɨso motomo jobedɨmacɨ. Jɨaɨno naɨ fuemona raforona uanona, naɨso motomo jobedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Dajerie Jesús uicomo jaidɨmacɨ. Dajerie naimɨe jɨnafona jaidɨmacɨ. Ado cuiriisɨte: —¡Caɨ Jilloitaraɨma billa! Jusiñamui mamecɨdo bitɨmɨe eo mare. ");
INSERT INTO huuNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Caɨ illaɨma David mɨcorɨ ifomo caɨna sedallena, damɨe billemo birui ocuiridɨcaɨ. Jusiñamui caɨna jilloitajasa. ");
INSERT INTO huuNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Iese Jerusalémo naimɨe jaide. Nainomo rillanona, Jusiñamui jofomo jaide. Nainomo eruaɨde. Jitoma ana illa jira, ie doce llofueoicaigano dɨga, Betaniamo ɨnɨllena jaide. ");
INSERT INTO huuNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ie areruido Betaniamona Jerusalémo abɨdo ie llofueoicaigano dɨga Jesús bia, aimetaite. ");
INSERT INTO huuNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Arena higuera railla riarana cɨuanona, iena jɨbuide. Como fɨruide; ia naie llɨsilladɨ iñede. Ie llɨsilla facaise nia iñede. ");
INSERT INTO huuNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ie jira naie riarana llote: —Biemona jaca llɨsiñeite. —Ie llofueoicaigano naimɨe lluana cacadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jerusalémo Jesús rilla mei, Jusiñamui jofomo naimɨe jaide. Naie jofo eo aillue. Dɨga cuartos nainomo ite. Jusiñamuimo ofomaɨaɨna fecallena, naimɨemo toɨca llaudaɨaɨna fecallena, nainomo comɨnɨ jaisoidɨmacɨ. Naie comɨnɨna ɨbatajanona, ofomaɨaɨna, toɨca llaudaɨaɨ dɨga, damɨerie fecauidɨmacɨ. Iena Jesús cɨuanona, naimacɨ mesaɨaɨna oni caicode. Ucugɨna fecauidɨno raɨracuaɨ jɨaɨ oni caicode. ");
INSERT INTO huuNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Jofo facaimo marena tuilla jira, comɨnɨ rana jamai uillanona, iedo jaisoidɨmacɨ. Atona tuidɨfodo jaisoidɨmacɨ. Iena Jesús rairuide. ");
INSERT INTO huuNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Naimacɨna llofuete: —Ie facaina lloraɨma mɨcorɨ Jusiñamui llogacɨno jaie cuega: “Cue jofo ite, nainomo nana comɨnɨ cuemo jɨɨllena” cuega. Ero, ailluena omoɨ ɨbataja jira, naimɨe jofona fɨɨriruidɨno jofona omoɨ fɨnoca. ");
INSERT INTO huuNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Judíuaɨ illaɨcomɨnɨ naimɨe fɨnoca rafuena fɨdɨanona, naimɨena meinellena, coninɨri siadotɨmacɨ. Ailluena comɨnɨ naimɨe llofuiana ebiruillanona, raijicaidɨmacɨ. Ie jira judíuaɨ illaɨcomɨnɨ naimɨena jacɨruillamona, naimɨena nia meinenidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Nairui navuida ie llofueoicaigano dɨga, Jerusalémona Jesús oni jaide. ");
INSERT INTO huuNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ie are ie llofueoicaigano dɨga, Jerusalén dɨne Jesús jaillanona, higuera railla riara duillana cɨodɨmacɨ. Nana ie jainao dɨga duillana cɨodɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Jesús navui are lluana Pedro uibiñuanona, naimɨemo llote: —Maestro, ero. O faidoca higuera jai duide. ");
INSERT INTO huuNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesús uai ote: —Jusiñamuina ɨɨnocana jai. ");
INSERT INTO huuNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Uanaicɨnona omoɨmo lloitɨcue. Jusiñamui lluana raise bu ɨɨnoia, naimɨe comecɨ ɨgɨreñenia, bene ite anedumo naimɨe lloia: “Monaillaimo o illena, benomona mai jai”, Jusiñamui ie jitaille rana fɨnoite. ");
INSERT INTO huuNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Nɨe isoide rafue Jusiñamuimo omoɨ jɨcajia, naimɨe iena fɨnuana omoɨ ɨɨnuamona, iena naimɨe fɨnoite. ");
INSERT INTO huuNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Jusiñamuimo o jɨɨacania, jɨaɨmɨe dɨga o rafue ia iena feita. Ie isoi caɨ Moo Jusiñamui omoɨmo ite jeacɨno jɨaɨ feitaite; ");
INSERT INTO huuNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","iadedɨ jɨaɨe comɨnɨ fɨnoca jeacɨnona omoɨ feitañenia, omoɨ Moo Jusiñamui omoɨ jeacɨnona feitañeite. Iena oni dotañeite. ");
INSERT INTO huuNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jerusalémo naimacɨ rillanona, Jusiñamui jofomo Jesús fo jailla mei, judíuaɨ illaɨcomɨnɨ naimɨe dɨne bitɨmacɨ. Naimacɨdɨ Jusiñamui dɨga nanoca ñaɨraɨnɨ. Naimacɨdɨ Moisés mɨcorɨ llogacɨno llofueraɨnɨ. Naimacɨdɨ einamacɨ. Dɨese billanona, ");
INSERT INTO huuNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","jɨcanotɨmacɨ: —¿Nɨe isoide uaido o fɨnoca rafuena fɨnodɨo? ¿Bu omo iga uai dɨga o fɨnoca rafuena fɨnodɨo? ");
INSERT INTO huuNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesús dɨnena uai ote: —Omoɨmo daje rafuena nano jɨcanoitɨcue. Raise omoɨ faɨrioia, omoɨmo cue uaido cue fɨnoca rafuena lloitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Juan Bautista mɨcorɨdɨ comɨnɨna navui bautizade. ¿Bu naimɨe mɨcorɨna orede, comɨnɨna bautizallena? ¿Jusiñamui? ¿Comɨnɨ? Cuemo llono —llote. ");
INSERT INTO huuNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Danɨ coninɨri iena siaduanona, anado raitɨmacɨ: —“Jusiñamui” caɨ faɨrioia, caɨmo jɨcanoite: “¿Bue ñellena naimɨe mɨcorɨ lluana ɨɨnoñedomoɨ?” ");
INSERT INTO huuNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","“Comɨnɨ” caɨ faɨrioia, bene itɨno caɨna nɨbaɨ meineitɨmacɨ, Juan mɨcorɨdɨ Jusiñamui facaina lloraɨma naimacɨ railla jira. ");
INSERT INTO huuNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ie jira faɨriotɨmacɨ: —Uiñoñedɨcaɨ. Jesús dɨnena raite: —Ie muidona cuemo nɨe isoide uai illana omoɨmo lloñeitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Judíuaɨ illaɨcomɨnɨmo Jesús llote: —Jɨaɨe rafuena omoɨmo lloitɨcue. Iemo cacarei. Daje patrón uvas railla riaraɨaɨna rite. Naie abɨ llaɨte. Jɨaɨruido uvas ijina eenollena, enɨruemo ifona raɨte. Naie illɨna raise eruaɨllena, tɨdacana fɨnode. Iena sedallena, ɨbatajanona, jɨaɨnomo fecade. Ie mei jɨaɨe enɨruemo jaide. ");
INSERT INTO huuNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Uvas jai einailla facaise riaraɨaɨna sedaraɨnɨ dɨne naie patrón ie mullaɨmana orede, naie illɨmona dajerie riara llɨsilla ollena; ");
INSERT INTO huuNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","iadedɨ naie sedaraɨnɨdɨ ie mullaɨmana fatɨmacɨ. Ie mei naimɨemo riara fecañeno naimɨena abɨdo oredɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ie mei patrón jɨaɨe mullaɨmana orede. Naimɨe ɨfogɨna bofedɨmacɨ. Naimɨena jeare fɨnodɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ie mei patrón jɨaɨmɨena orede. Naimɨena meinetɨmacɨ. Ie mei ailluena mullaɨaɨna orede. Damɨeriena fatɨmacɨ. Damɨeriena meinetɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Patrómo ie isiruiga jito ite. “Cue jitona jacɨruitɨmacɨ. Naimɨe uaina ɨɨnoitɨmacɨ. Naimɨena oretaitɨcue” patrón comecɨna facade. ");
INSERT INTO huuNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Riaraɨaɨna sedaraɨnɨ naimɨena cɨuanona, coninɨri raitɨmacɨ: “Bimɨemo bie illɨ fɨebiite, naimɨe moo fiodailla mei. Naimɨena caɨ meinellɨ, bie illɨ caɨmo fɨebillesa” raitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Naimacɨ dɨne naimɨe rilla mei, naimɨena meinetɨmacɨ. Ie mei ie abɨna illɨmona jino dotadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Iena fɨdɨa mei, ¿nɨese naie patrón nɨbaɨite? Ero, naimɨe billanona, ie illɨna sedaraɨnɨna fuidoite. Ie mei jɨaɨnona ie illɨna sedataite. ");
INSERT INTO huuNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","11","Naimacɨmo Jesús llote: —Naie illɨ sedaraɨnɨ isoidomoɨ. Jusiñamui facaina lloraɨma mɨcorɨ omoɨna jaie cuete. Ie cuegafuena raise facañedomoɨ. Naimɨe mɨcorɨ cuega: Jofo fɨnoraɨnɨ jitaiñena nofɨcɨdɨ nana naie jofomo ite nofɨcɨ baɨfemo jai uaide. Jusiñamui iena fɨnotate. Iena caɨ uiñuamona: “Eo mare” raitɨcaɨ cuega. Jusiñamui comɨnɨna damɨerie jaillana naimɨe mɨcorɨ cuete. Jusiñamui oretagamɨena damɨerie jitaiñenamona, naimɨe comɨnɨna jaiñeitɨmacɨ; iadedɨ Jusiñamui oretagamɨena ailluena ɨɨnuamona, naimɨe comɨnɨna jaitɨmacɨ. Ero, Jusiñamui facaina lloraɨma mɨcorɨ caɨna cuete. Naie jofona fɨnoraɨnɨ isoidomoɨ. Naie nofɨcɨ isoidɨcue. Cue rafuena omoɨ jitaiñena jira, naimɨe comɨnɨna jaiñeitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Judíuaɨ illaɨcomɨnɨ iena cacajanona, Jesús naimacɨna ñaɨana naimacɨ uiñuamona, naimɨena gaɨtaacadɨmacɨ; ia comɨnɨna jacɨruitɨmacɨ. Ie jira naimɨemona oni jaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Judíuaɨ illaɨcomɨnɨ jailla mei, dajerie fariseuaɨ comɨnɨna Jesús dɨne oredɨmacɨ. Illaɨma Herodes dɨbeimo itɨnona oredɨmacɨ. Naimɨe raise uai oñenia, naimɨena duere fɨnollena, Jesúna facacɨiacadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","15","Naimɨemo llotɨmacɨ: —Maestro, uanaicɨnona llofuecabitɨo. Jusiñamui rafuedo caɨ marena jaillana raise llofuetɨo. Nana comɨnɨ dauaido llofuetɨo. Comɨnɨna iobitallena llofueñedɨo. Omo rafuena jɨcanoiacadɨcaɨ. Danɨ Jusiñamuina sedadɨcaɨ; iadedɨ romanuaɨ railla naɨraɨ anamo birui caɨ illa jira, ¿naimacɨ illaɨma Césarmo ucubena caɨ fecajana rairuidɨo? Caɨmo llono —llotɨmacɨ. Naimacɨ mareuidɨnona abɨna caitadɨnona naimɨe uiñuamona, naimacɨmo llote: —¿Bue ñellena cuena facacɨtomoɨ? Ucube cuemo acata. ");
INSERT INTO huuNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ie jira acatatɨmacɨ. Naimacɨmo jɨcanote: —¿Bu ie joreño nainomo ite? ¿Bumo jaɨnaɨaɨde bie cuega radɨ? Uai otɨmacɨ: —César. ");
INSERT INTO huuNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Jesús dɨnena raite: —César iena itedɨ, Césarmo ille. Jusiñamui iena itedɨ, Jusiñamuimo ille —raite. Naimɨe lluana cacajano, naimɨe raise uai ua jira, ieri raijicaidɨmacɨ. Naimɨe iese llua jira, naimɨena duere fɨnonidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Naie facaise saduceuaɨ railla comɨnɨ naimɨe dɨne bitɨmacɨ. Fiodaillamona jaca buna jilloñellena ɨɨnotɨmacɨ. Jesúmo llotɨmacɨ: ");
INSERT INTO huuNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Maestro, caɨ facaina Moisés mɨcorɨ jaie cuega: “Ɨima fiodailla meinoconi, naimɨe urue iñenia, ie ama naie fecɨño olle. Naimɨedɨ uruiaɨna ie ama facaina comuitaite” cuega. ");
INSERT INTO huuNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Bie rafuena uiñoiacadɨcaɨ. Siete amatɨaɨ ite. Nano doforamɨe ie aɨna ote. Naimɨe nia uruiaɨnide fiodailla. ");
INSERT INTO huuNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ie emodo imɨe ie ama fecɨñona ote. Naimɨe uruiaɨnide jɨaɨ fiodailla. Naie siete dɨgamɨedemona iese sefuide. ");
INSERT INTO huuNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Uruiaɨnide nana fiodailla. Ja muidomo naie rɨño jɨaɨ fiodaite. ");
INSERT INTO huuNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Fiodaillamona, ɨco naimacɨ jilloiadedɨ, ¿bu naie rɨño ienite? Naiñaiño siete dɨgamɨena ɨnirede —llotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesús uai ote: —Moisés mɨcorɨ cuegafuiaɨna raise omoɨ uiñoñena jira, Jusiñamui uaina raise omoɨ uiñoñena jira, bie isoide rafuena raise uiñoñedomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Fiodaillamona jillua mei, Jusiñamui dɨga ite comɨnɨ aɨnitɨmacɨ. Ɨninitɨmacɨ. Monamo Jusiñamui jaɨenisaɨ aɨnidɨmacɨ. Ɨninidɨmacɨ. Ie isoi naie siete amatɨaɨ iitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Fiodaitɨno ɨco jilloillena omoɨmo lloitɨcue. Moisés mɨcorɨ jofue iñenanomo illa facaise, amena boode motodo Moisés mɨcorɨmo Jusiñamui ñaɨa facaise, naimɨe mɨcorɨmo comɨnɨ ɨco jilloillena Jusiñamui llote: “Abraham ie Jusiñamuidɨcue. Isaac ie Jusiñamuidɨcue. Jacob ie Jusiñamuidɨcue” llote. ");
INSERT INTO huuNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Jai fiodaitɨmacɨ; ia naimacɨ joreñuaɨ nia itɨmacɨ. Jusiñamuidɨ danɨ cajedɨno imacɨ Jusiñamuina jira, naimacɨ joreñuaɨ naimɨe dɨne itɨmacɨ. Ɨco naimacɨ abɨaɨna jɨaɨ jillotaite. Fiodaillamona jilluana omoɨ raise uiñoñedomoɨ —llote. ");
INSERT INTO huuNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Naie facaise Moisés mɨcorɨ llogacɨnona llofueraɨma Jesús dɨne billanona, naimɨedɨ comɨnɨ Jesús uaina uaitajana cacade. Jesús raise uai uana cacajano, Jesúmo jɨcanote: —Moisés mɨcorɨ jaie llogacɨnuaɨmona, ¿nɨe llogacɨno ua nanoca llogacɨnona? ");
INSERT INTO huuNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesús dɨnena uai ote: —Moisés mɨcorɨ jaie cuega: “Israel comɨnɨ, bie rafuemo cacarei. Caɨ Nama Jusiñamui jaca dajede. ");
INSERT INTO huuNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Omoɨ jitailla jira, nana omoɨ comecɨaɨ dɨga, caɨ Nama Jusiñamuina isirui. Naimɨemo omoɨ comecɨaɨna eo faca”. ");
INSERT INTO huuNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ie emodomo ite llogacɨno janore daje isoide: “Danɨ omoɨ abɨ omoɨ isiruilla isoi, omoɨ ecɨmo itɨnona jɨaɨ isirui”. Bie mena llogacɨno jɨaɨe llogacɨnuaɨ baɨfemo faɨte. ");
INSERT INTO huuNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Naie llofueraɨma dɨnena uai ote: —Maestro, raise llotɨo. Jusiñamui jaca dajede. Jɨaɨmɨe caɨ sedallena iñede. ");
INSERT INTO huuNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Caɨ jitailla jira, nana caɨ comecɨaɨ dɨga naimɨena caɨ isiruia, naimɨemo caɨ comecɨaɨna eo facaia, caɨ abɨna caɨ isiruilla isoi caɨ ecɨmo itɨnona caɨ isiruia, Jusiñamuina raise sedadɨcaɨ. Bie rafuedo naimɨemo toɨca ocaina fecajana baɨfemo faɨte. Bie rafuedɨ naimɨemo caɨ ra fecajana baɨfemo faɨte. ");
INSERT INTO huuNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Naimɨe raise uai ua jira, naimɨemo Jesús llote: —Iese o ɨɨnocana jaia, Jusiñamui jitailla isoi, ie comɨnɨna raɨre jaitɨo. —Ie facaisemona buna naimɨena facacɨaɨbiñede. ");
INSERT INTO huuNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jusiñamui jofomo Jesús jailla mei, nainomo itɨnomo jɨcanote: —¿Nɨese Moisés mɨcorɨ llogacɨnona llofueraɨnɨ Cristona raitɨmacɨ? ¿Nɨese naimɨedɨ David mɨcorɨ jitona raitɨmacɨ? ");
INSERT INTO huuNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Jusiñamui Joreñodɨ David mɨcorɨna ñaɨtatajanona, David mɨcorɨ llote: Jusiñamuidɨ cue Namamo llote: “Illaɨmana o illamona, cue nabei dɨne ana raɨ. Ona ɨɨnoñedɨno o anamo itataitɨcue”. ");
INSERT INTO huuNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“Cristodɨ cue Nama” David mɨcorɨ raite. Iese naimɨe mɨcorɨ railla jira, Cristo David mɨcorɨ afemo faɨte. Naimɨedɨ jamai David mɨcorɨ jitoñede; ia jɨaɨ ie Nama. —Nainomo itɨno naimɨe llofuiana iocɨre cacareidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jusiñamui jofomo Jesús nia llofuianona, raite: —Moisés mɨcorɨ llogacɨnona llofueraɨnɨmona abɨna rairui. Illaɨcomɨnɨna naimacɨ itɨmacɨdena, naimacɨna comɨnɨ cɨoillena, eo mare ɨniroina jɨtaacacabidɨmacɨ. Nɨne naimacɨ macaria, naimacɨ jamai bue isoiñedɨnona itɨmacɨdena, comɨnɨ naimacɨna uaiduana gaɨdɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Comɨnɨ naimacɨmo acarillena, ofiracomo uicomo raɨacadɨmacɨ. Rafue ia: “Jamai bue isoiñedɨcaɨ” raillamo comecɨna facajanona, rafue nama ecɨmo raɨacadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Fecɨñuaɨmona rana ocabillanona, naiñaiñuaɨna duere fɨnodɨmacɨ. Naimɨena eo sedadɨmacɨdena, Jusiñamuimo are jɨɨcabidɨmacɨ. Iese naimacɨ icabilla jira, Jusiñamui naimacɨna jɨaɨe comɨnɨ baɨfemo duere fɨnoite. ");
INSERT INTO huuNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jusiñamui jofomo Jesús nia ia, ucube fecarano uicomo ana raɨde. Nainomo comɨnɨ ucubena joniamo eruaɨde. Ailluena ucuberedɨno ailluena ucubena jonetɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ie facaise eo duerede fecɨño menaruñu jonete. ");
INSERT INTO huuNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Iena cɨuanona, naimɨe dɨne ie llofueoicaiganona uaiduanona, naimacɨmo llote: —Bie eo duerede fecɨño nana jɨaɨe comɨnɨ jonia baɨfemo jonete. ");
INSERT INTO huuNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Naimacɨmo ailluena ite ucubemona janore fecadɨmacɨ. Naiñaiño eo duerede; iadedɨ nana naiñaiñomo ite ucubena jonete. Ie jira jɨaɨno baɨfemo jonete. ");
INSERT INTO huuNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jusiñamui jofomona ie llofueoicaigano dɨga, Jesús jino jaidemo, ie llofueoicaiganomona Jesúmo damɨe raite: —Maestro, bie jofomo ite nofɨcɨaɨ co ebirede. Bico eo ebire cɨode. ");
INSERT INTO huuNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesús dɨnena uai ote: —Bie jofo birui eo mare; ia nana bie jofomo ite nofɨcɨaɨ ɨco judaɨsite —llote. ");
INSERT INTO huuNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ie mei Olivos railla anedu dɨne rillanona, Jusiñamui jofo uico dɨne Jesús naie anedu muidomo ana raɨde. Ie facaise Pedro, Jacobo dɨga, Juan dɨga, Andrés dɨga, eneno illanona, Jesúmo llotɨmacɨ: ");
INSERT INTO huuNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Jusiñamui jofo judaɨsillana omo jɨcanoiacadɨcaɨ. ¿Nɨruido iena suite? Nana o lloga rafue suillena, ¿nɨe isoide rafue nano suite? Iena caɨmo llono. ");
INSERT INTO huuNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Uai ote: —Omoɨna bie rafuena bu jɨfueñellena, omoɨ abɨna rairui. ");
INSERT INTO huuNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ailluena comɨnɨ cue mamecɨdo billemona: “Cristodɨcue” raitɨmacɨ. Dɨga comɨnɨna jɨfueitɨmacɨ. Iemona omoɨ abɨna rairui. ");
INSERT INTO huuNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Jobaimiaɨ illena fɨdɨitomoɨ; iadedɨ jacɨruiñeno. Iese suite; iadedɨ abɨdo nia biñeitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Daje naɨraɨ jɨaɨe naɨraɨ dɨga jobairitɨmacɨ. Daje gobierno jɨaɨe gobierno dɨga jobairite. Dɨga illanuaɨmo ñuisañuaɨ suite. Dɨga illanuaɨmo comɨnɨ aime guitɨmacɨ. Iese suia, omoɨ duere sefuillɨfue omoɨmo suite. ");
INSERT INTO huuNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Abɨna rairui. Dajerie omoɨna llogɨdoitɨmacɨ. Omoɨna gaɨtaja mei, naimacɨ ofiracomo omoɨna faitɨmacɨ. Cuemo omoɨ duilla jira, omoɨna gaɨtajanona, omoɨna duere fɨnollena, illaɨcomɨnɨ dɨne omoɨna uitɨmacɨ; ia naimacɨmo cue rafuena lloitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Dɨga comɨnɨ cue rafuena nana naɨraɨmo lloitɨmacɨ, nana naɨraɨaɨ iena cacaillena. Ie mei abɨdo biitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Naie illaɨcomɨnɨ dɨne omoɨ ia, juez dɨne omoɨ ia, omoɨ abɨ rɨidollɨcɨnomo omoɨ comecɨaɨna jarire facañeno. Naie facaise omoɨ ñaɨllɨcɨnona uiñoitomoɨ. Danɨ omoɨ comecɨaɨ icɨnodo ñaɨñeitomoɨ; ia Jusiñamui Joreño uaido ñaɨtomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Cuena ɨɨnotomoɨ; ia ailluena cuena ɨɨnoñeitɨmacɨ. Cuena omoɨ ɨɨnua jira, omoɨna enoitɨmacɨ. Iemona dajerie ie amana meinetallena, naimɨena llogɨdoite. Dajerie moodɨ ie uruena meinetallena, naimɨena llogɨdoite. Dajerie uruiaɨdɨ naimacɨ moona, naimacɨ eina meinetallena, naimacɨna llogɨdoitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Cue comɨnɨna omoɨ illamona, nana naɨraɨ omoɨna enoitɨmacɨ; iadedɨ cuena faɨnonocaiñedɨmɨe ja muidomo monamo jaca iite. Naimɨena jillotaitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Cue lluamo cacarei. Jusiñamui facaina lloraɨmadɨ jɨaɨmɨe jearede rafue fɨnollena jaie llote. Naie rafue suia, Jusiñamui jofomo Jusiñamuina sedañeitomoɨ. Nainomo ite jearede rafue fɨnuana omoɨ cɨuanona, naiemona omoɨ jillobillena, duere omoɨ sefuiñellena, Judeamo omoɨ illamona, aneduaɨ dɨne omoɨ aisɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Jofo emodomo omoɨ ia, ana billanona, aneduaɨ dɨne raɨre rillena, jofomo jaiñeno. Nainomo ite rana omoɨ dɨga uiñeno. ");
INSERT INTO huuNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Aneduaɨ dɨne raɨre rillena, illɨmo omoɨ ia, abɨdo jofomo biñeno, omoɨ ɨniroi omoɨ dɨga uillena. ");
INSERT INTO huuNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Naie rafuemona jillobillena, naie facaise urueside rɨño duere sefuite. Uruena nia jirode rɨñodɨ jɨaɨ duere sefuite. ");
INSERT INTO huuNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Eo duere sefuiñellena, Jusiñamuimo omoɨ jɨcano, rollime facaiseconi bie rafue suiñellena. ");
INSERT INTO huuNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Naie facaise comɨnɨ eo duere sefuitɨmacɨ. Jusiñamuidɨ enɨrue fɨnua facaisemona iese comɨnɨ nia duere sefuiñedɨmacɨ. Ɨco iese eo duere sefuiñeitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Naie facaise ianori fo Jusiñamui oñeitena, buna jaca jillobiñeite. Naimɨe fetocano muidona, naie facaise Jusiñamui ianori fo oite. ");
INSERT INTO huuNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Ie facaise omoɨmo bu raia: “Jadi, Jusiñamui facaina lloraɨma benomo birui bairede. Naimɨedɨ Cristo”, iena ɨɨnoñeno, Jɨaɨmɨe raia: “Oni batɨne Cristo birui bairede”, iena ɨɨnoñeno. ");
INSERT INTO huuNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Cristona abɨ caitadɨno biitɨmacɨ. Jusiñamui facaina lloraɨnɨna abɨ caitadɨno jɨaɨ biitɨmacɨ. Siño rafuena fɨnuanona, comɨnɨna jɨfueitɨmacɨ. Jusiñamui fetoca comɨnɨna ua jɨfueitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ie jira omoɨ abɨna rairui. Ero, bie rafue nia suiñenia, iena omoɨmo jai llotɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","’Naie duere sefuilla facaise meinoconi, jitoma llɨgaiñoñeite. Fɨvui jɨaɨ llɨgaiñoñeite. ");
INSERT INTO huuNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Monamona ucuaɨ ana llujite. Nana naie radɨ jaidɨsite. ");
INSERT INTO huuNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Naie facaise uillɨe motodo cue billena nana comɨnɨ cɨoitɨmacɨ. Ebire biitɨcue. Naimacɨna cue sedallena, illaɨmana biitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Cue jaɨenisaɨna cue ecɨmona oretaitɨcue. Cue fetocano dɨese naganomona ofitaitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Higuera railla riaramona omoɨ fueo. Bie enɨruemo naie riara fɨruillamona, fɨemona raɨre illana uiñotomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ie isoide. Bie rafue ɨco suia, cue billɨrui iaɨrei illena uiñoitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Uanaicɨnona omoɨmo lloitɨcue. Nana bie rafue suille facaiseconi bie naɨraɨ nia iite. ");
INSERT INTO huuNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Mona enɨrue dɨga fuite; iadedɨ cue lloga uai jaca suite. ");
INSERT INTO huuNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Cue abɨdo billɨrui jaca bu uiñoñede. Jusiñamui jaɨenisaɨ iena uiñoñedɨmacɨ. Jusiñamui Jitodɨcue; iadedɨ cue abɨdo billɨruina jɨaɨ uiñoñedɨcue. Dama cue Moo iena uiñote. ");
INSERT INTO huuNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Abɨna rairuicana jai. Naimɨe omoɨna canollena, Jusiñamuimo jɨaɨ jɨɨcabi. Cue billɨrui omoɨ uiñoñena jira, iemo ocuiri. ");
INSERT INTO huuNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","’Iena omoɨ raise uiñollena, bie rafuena lloitɨcue. Patrón jɨaɨe enɨruemo jaide. Nia jaiñenia, ie mullaɨaɨna ie jofona sedatate. Nagamɨe ie maɨjɨlle ocuide. Jofo nasena sedadɨmɨemo naimɨe billemo raise ocuirillena llote. ");
INSERT INTO huuNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Naie patrón abɨdo billena naimacɨ uiñoñena jira, naga hora iemo ocuiritɨmacɨ. Nɨbaɨ navuida baɨfe biite. Nɨbaɨ daferuise biite. Nɨbaɨ atava ñaɨa facaise biite. Monaia, nɨbaɨ biite. ");
INSERT INTO huuNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ebena naimɨe biite. Ɨnɨdɨmacɨmo naimacɨ baisaɨbi raillanona, naimacɨ jaca ocuirilla. ");
INSERT INTO huuNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ie isoide. Ebena biitɨcue. Cue abɨdo billɨrui omoɨ uiñoñena jira, iemo jaca omoɨ ocuiri. ");
INSERT INTO huuNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Naie facaise pascua railla rafue illena, menarui fɨebide. Naie facaise llomenico guille rafue jɨaɨ ite. Naie rafue ia, sɨritaga rana jaca guiñedɨmacɨ. Egiptomona naimacɨ jaiagaɨ jillobillana comecɨllena, naie rafue ite. Judíuaɨ illaɨcomɨnɨ Jesúna jɨfuiano gaɨtaacadɨmacɨ. Naimɨena meineiacadɨmacɨ. Iena siadua mei, ");
INSERT INTO huuNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","raitɨmacɨ: —Pascua railla facaise naimɨena nia gaɨtañeitɨcaɨ. Naie facaise naimɨena caɨ gaɨtataia, iena gaɨñenamona, comɨnɨ caɨ dɨga fuiritɨmacɨ. Nia sedaitɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Betania railla naɨraɨmo Jesús jaillanona, Simón jofomo jaide, Simódɨ jaie efonaitɨmɨe. Naifomo mesamo Jesús guitemo, daje rɨñodɨ nofɨcɨmona fɨnoca frasco atɨano, naie frasco llaillanona, nainomo ite caɨmare soride ra naimɨe ɨfogɨmo totade. Naie ra eo raifide. ");
INSERT INTO huuNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Damɨerie iena cɨuanona, icɨritɨmacɨ. Coninɨri danɨ ñaɨtɨmacɨ: —Naie ra jamai dotade. Jai faɨfide. ");
INSERT INTO huuNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Iena fecacadena, trescientos ucubena feiñote. Fecaja mei, naie ucube dueredɨnomo fecadena, caɨmona mare. —Naiñaiñona iese ñaɨtɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Naimacɨ ñaɨana Jesús uiñua jira, naimacɨmo llote: —Dama ite. ¿Bue ñellena naiñaiñona jeare ñaɨtomoɨ? Mare rafuena cuemo fɨnode. ");
INSERT INTO huuNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Omoɨ dɨga dueredɨno jaca itɨmacɨ. Nɨruido o jitaia, naimacɨna canoredomoɨ; ia omoɨ dɨga jaca iñeitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Cue facaina naiñaiño fɨnoacana dɨese jai fɨnode. Nia fiodaiñedɨcue; ia cue fiodaillɨrui facaina naiñaiño iese fɨnode. ");
INSERT INTO huuNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Omoɨmo uanaicɨnona lloitɨcue. Nɨnomo cue mare fɨnoca rafuena bu lloia, naiñaiñona uibiñollena, nana comɨnɨmo naiñaiño fɨnoca rafuena lloite. ");
INSERT INTO huuNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ie facaise Jesús llofueoicaiganomona Judas Iscariote mɨcorɨ raillamɨedɨ Jesúna gaɨtatallena, Jusiñamui dɨga nanoca ñaɨraɨnɨ dɨne jaide. ");
INSERT INTO huuNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Iena cacajano, iobidɨmacɨ. —Iena o fɨnoia, omo ucubena fecaitɨcaɨ —llotɨmacɨ. Iemona Jesúna gaɨtatallɨruimo Judas ocuiride. ");
INSERT INTO huuNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Llomenico guille rafue illanona, judíuaɨ comɨnɨ toɨca llaudaɨaɨna fajarui illanona, Jesúmo ie llofueoicaigano jɨcanote: —¿Nɨnomo pascua railla rafue ie guille fɨnuana jitaidɨo? ");
INSERT INTO huuNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Naimacɨmona menamɨena oretajanona raite: —Jerusalémo omɨco jaillanona, nogodo jɨnuina uitɨmɨena cɨoitomɨco. Naimɨena raca. ");
INSERT INTO huuNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Naimɨe jailla jofo namamo llono: “Coco llofueraɨma cocona omo jɨcanotade: ‘¿Nɨmai cue guiraco? ¿Nɨnomo guitɨcue, cue llofueoicaigano dɨga?’ ” ");
INSERT INTO huuNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ie mei omɨcomo afebebamo ite aillue cuartona acataite. Na raruiaɨ dɨga ite. Nainomo caɨ guille fɨno. ");
INSERT INTO huuNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Jesús llua isoi jaidɨiaɨmaiaɨ. Jerusalémo rilla mei, naimɨe llua isoi baitɨiaɨmaiaɨ. Pascua rafue guille fɨnodɨaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Nairui jitoma ana itemo, ie llofueoicaigano dɨga, Jesús nainomo guisaide. ");
INSERT INTO huuNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Mesamo guitɨmacɨmo, Jesús llote: —Omoɨmona damɨe cuena gaɨtataite. Naimɨe cue dɨga bene jai guite. ");
INSERT INTO huuNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Iena cacajanona, sunaitɨmacɨ. Damɨerie naimɨemo jɨcanosɨde: —¿Cuena ñaɨtɨo? ");
INSERT INTO huuNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Uai ote: —Omoɨmona damɨe bie platomo cue dɨga llomenico dɨga mutade. ");
INSERT INTO huuNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Jusiñamui facaina lloraɨma mɨcorɨ cuega isoi, monamona jai billamona, fiodaitɨcue; iadedɨ cuena gaɨtataitɨmɨe eo duere sefuite. Naimɨe jeicɨñegadena, cuemona mare. ");
INSERT INTO huuNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Naimacɨ nia guitɨmacɨmo, llomenicona Jesús llɨnuanona, Jusiñamuimo iobillacɨnona fecaja mei, llomenicona taɨrude. Naimacɨmo fecajano raite: —Iena llɨnuano guiño. Bie llomenicodɨ cue abɨ facai ie. Cue abɨmo omoɨ comecɨna facajano, iena guiño. ");
INSERT INTO huuNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ie mei naimɨe jiroracona jɨaɨ llɨnote. Jusiñamuimo iobillacɨnona llua mei, naie jiroracomo jai totaca vino naimacɨmo fecade. Iemona nana jirodɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Naimɨe raite: —Cue fiodaillamona, dama cue dɨaillamona, jeacɨno anamona ailluena jillotaitɨcue. Jusiñamui jɨaɨe rafue birui itatajamona, naimacɨ jeacɨno oni dotajana jai llote. Bie vinodɨ naie rafue facai ie. ");
INSERT INTO huuNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Omoɨna bene dane iese caɨmare nabaiñeitɨcue. Cue Moo sedajanomo omoɨ dɨga cue ia, nainomo omoɨna dane iese caɨmare marena nabaitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Iobilla rua Jusiñamuimo naimacɨ rua mei, Olivos railla anedumo Jesús ie llofueoicaigano dɨga jaide. ");
INSERT INTO huuNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Naimacɨmo llote: —Cuena faɨnonocaitomoɨ. Jusiñamui facaina lloraɨma mɨcorɨ iena jaie cuega: “Toɨca llaudaɨaɨ sedaraɨmana meinetɨmacɨ. Naimɨe toɨnɨaɨ uaficaida jaitɨmacɨ” cuega. Naimɨe mɨcorɨ caɨna cuete. ");
INSERT INTO huuNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ero, fiodaillamona cue jillua mei, omoɨ uicodo Galileamo jaitɨcue, nainomo omoɨ dɨga dafaɨfillena. ");
INSERT INTO huuNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pedro uai ote: —Nana jɨaɨno ona faɨnonocaia, ona jaca faɨnonocaiñeitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesús dɨnena raite: —Uanai omo lloitɨcue. Ja naɨo ɨitava menacaiño nia ñaɨñenia, dacaiño amani cuena janoitɨo. ");
INSERT INTO huuNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pedro dɨnena rɨire llote: —O dɨga cue fiodaiadedɨ, ona janoñeitɨcue. Nana ie llofueoicaigano daje uaido jɨaɨ raitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Oni jaillanona, Getsemaní railla illanomo jaidɨmacɨ. Ie llofueoicaiganomo Jesús llote: —Beno ana raɨ. Omoɨmona oni baɨ janore jaitɨcue. Cue Moo dɨga ñaɨllena jaitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Naimɨe dɨga Pedrona uite. Jacobona uite. Juan jɨaɨ uite. Naimɨe sunaicaide. Ie comecɨ uri iñede. ");
INSERT INTO huuNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Naimacɨmo llote: —Cue comecɨ sunaicaide. Niadɨ fiodaitɨcue. Benomo fɨebi; ia nia ɨnɨñeno cue facaina omoɨ jɨɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Naimɨe janore baɨ jaillanona, enɨruemo bɨtadate. Naimɨe duere sefuiñellena, Jusiñamuimo jɨɨde: ");
INSERT INTO huuNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","—Ore Moo, nana rana fɨnoredɨo. Cuena llegɨ cacaitañeno. Cue jitailla isoi cuena fɨnoñeno; iadedɨ o jitailla isoi cuena fɨno. ");
INSERT INTO huuNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ie mei ie llofueoicaigano dɨne abɨdo billanona, naimacɨ ɨnɨsɨtemo ride. Naimacɨna casitajano, Pedromo jɨcanote: —Simón, ¿nɨese raɨre ɨnɨdɨo? daje hora nia iñedemo. ");
INSERT INTO huuNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ɨnɨñeno. Taɨfe ramo omoɨna faɨ raillano, iena omoɨ ɨɨnoñellena, Jusiñamuimo jɨɨ. Omoɨ comecɨ mare rafuena fɨnoacade; iadedɨ omoɨ comecɨ danɨ ocuiñoñede. Ie muidona Jusiñamuimo jɨɨ, omoɨna naimɨe ocuiñotallena —llote. ");
INSERT INTO huuNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ie mei dane jɨɨllena jaide. Aillɨ naimɨe jɨɨa isoi, dane jɨɨde. ");
INSERT INTO huuNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ie llofueoicaigano dɨne dane billanona, naimacɨ uisɨ llirɨoilla jira, naimacɨ ɨnɨsɨtemo ride. Naimacɨna casitajano, Jesús naimacɨ dɨga ñaɨte; ia naimacɨ dɨnena uai uana uiñoñede. ");
INSERT INTO huuNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Dane jɨɨa mei, ie llofueoicaiganomo dane billanona, naimacɨna casitajano, llote: —¿Nɨese nia ɨnɨdomoɨ? ¿Nɨese jafaicɨ nia otomoɨ? Jai macaɨbaite. Cue fiodaille facaise jai ite. Jusiñamui jitailla jira, cuena ja gaɨtajanona, naimɨena ɨɨnoñedɨno anamo ja iitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","A naidacai. Maiña. Cue gaɨtataitɨmɨe jai bite. ");
INSERT INTO huuNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jesús nia ñaɨtemo, ieconi Judas bite. Naimɨe ie llofueoicaigamɨe. Dɨga comɨnɨ naimɨe dɨga bitɨmacɨ. Naimacɨ lloebɨna atɨdɨmacɨ. Naimacɨ butaralluna jɨaɨ atɨdɨmacɨ. Jusiñamui dɨga nanoca ñaɨraɨnɨmona bitɨmacɨ. Moisés mɨcorɨ llogacɨnona llofueraɨnɨmona bitɨmacɨ. Naimacɨ einamacɨmona bitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Jesús dɨne naimacɨ nia riñenia, Judas naimɨe dɨga bitɨnomo jai llote: —Jesúna omoɨ uiñollena, naimɨena llibanoitɨcue. Ie mei naimɨena gaɨta. Naimɨena raise maɨanona, naimɨena oni uiño. ");
INSERT INTO huuNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Jesús dɨne naimɨe rillanona, Judas Jesús dɨne raɨre jaide. Naimɨena uaidote: —Maestro, jai bitɨcue. —Ieconi naimɨena llibanote. ");
INSERT INTO huuNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ie jira Jesúna gaɨtadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Iena cɨuanona, Jesús dɨga itɨnomona damɨe ie lloebɨ llɨnuanona, naimɨedɨ nanoca ñaɨraɨma ie mullaɨma jefona jaɨbonote. ");
INSERT INTO huuNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Naimɨena gaɨtadɨnomo Jesús llote: —Omoɨ lloebɨna atɨdomoɨ. Omoɨ butaralluna atɨdomoɨ. Cuena gaɨtallena, fɨɨriraɨmadɨcueta cuemo omoɨ billa. ");
INSERT INTO huuNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Jusiñamui jofomo nagarui llofuecabitɨcue. ¿Bue ñe nainomo cuena gaɨtañedomoɨ? Cuena jai omoɨ gaɨtajamona, Jusiñamui facaina lloraɨnɨ mɨcorɨaɨ cuegafuiaɨ suite. ");
INSERT INTO huuNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ie facaise nana naimɨe llofueoicaigano naimɨena faɨnonocaillano, aisɨdɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ie facaise daje conirue Jesús jɨnafona racade. Jamai abɨmo ɨniroi ferɨnocaida racade. Naimɨena cɨuanona, comɨnɨ naimɨena gaɨtadɨmacɨ; ");
INSERT INTO huuNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ia ie ɨniroina faɨnonocaillanona, taɨmɨena aisɨde. ");
INSERT INTO huuNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Jesúna gaɨtaja mei, Jusiñamui dɨga nanoca ñaɨraɨma dɨne naimɨena uitɨmacɨ. Nana judíuaɨ illaɨcomɨnɨ itɨmacɨ. Nanoca ñaɨraɨnɨ itɨmacɨ. Einamacɨ jɨaɨ itɨmacɨ. Moisés mɨcorɨ llogacɨnona llofueraɨnɨ jɨaɨ itɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pedro naimacɨ jɨnafona aarena racade. Jusiñamui dɨga nanoca ñaɨraɨma naɨraɨbɨrɨmo jaide. Jofono sedadɨno dɨga nainomo ite iraimo agaide. ");
INSERT INTO huuNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Naimɨena meinellena, nana naie illaɨcomɨnɨ Jesúmo nɨcɨno illana uiñoiacadɨmacɨ. Iena coninɨri siadotɨmacɨ; iadedɨ naimɨemo jaca nɨe isoide maraiñede rafue illana uiñoñedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Dɨga comɨnɨ Jesúna llogɨdotɨmacɨ; ia taɨnona llotɨmacɨ. Daje isoi lloñedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Damɨerie billanona, taɨnona llogɨduanona, raite: ");
INSERT INTO huuNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Bimɨe lluana cacadɨcaɨ. Jusiñamui jofona jeare ñaɨte. Naimɨe llote: “Jusiñamui jofona comɨnɨ fɨnodɨmacɨ; ia iena cue judaɨanona, darui amani illanona, jɨaɨe fɨnoitɨcue. Comɨnɨ iena fɨnoñeitɨmacɨ”. ");
INSERT INTO huuNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","—Iese llotɨmacɨ; ia daje isoi lloñedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Naimacɨ motomo Jusiñamui dɨga nanoca ñaɨraɨma naidadajanona, Jesúmo jɨcanote: —¿Nɨese uai oitɨo? ¿Nɨe isoide rafue ona llogɨdotɨmacɨ? ");
INSERT INTO huuNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Jesús dɨnena uai oñede. Naie ñaɨraɨma jɨcanote: —¿Odɨ Cristodɨo? ¿Odɨ Jusiñamui Jitodɨo? ");
INSERT INTO huuNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesús uai ote: —Jɨɨ, naimɨedɨcue. Monamona jaie cue billamona, ɨimana jaidɨcue; ia ɨco jɨaɨruido illaɨmana cue illena, Jusiñamui ecɨmo cue raɨllena, omoɨ naɨraɨ cɨoitɨmacɨ. Mona uillɨemo cue abɨdo billena jɨaɨ cɨoitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Iena cacajanona, icɨrillanona, naie nanoca ñaɨraɨma dama ie ɨniroina cuaranote. Raite: —Jɨaɨno naimɨena llogɨdollena jai jitaiñedɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Jusiñamuina naimɨe jeare ñaɨana jai cacadomoɨ. ¿Nɨese naimɨena raitomoɨ? Jɨaɨe illaɨcomɨnɨ dɨnena: —Naimɨe fiodaillesa —llotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ie facaise damɨerie naimɨena tuallaɨtɨmacɨ. Ie uiecona ɨbailla mei, naimɨena ducoɨdɨmacɨ. Raitɨmacɨ: —Bu o ducoɨa caɨmo llono. Naimɨena gaɨtadɨno dɨnena naimɨena jɨaɨ ducoɨdɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Naie facaise Pedro naɨraɨbɨrɨmo ite. Naie nanoca ñaɨraɨma mullaɨñuaɨmona dañaiño nainomo billanona, ");
INSERT INTO huuNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pedro agaillana cɨode. Raite: —Nazaret ie Jesús comɨnɨdɨo. ");
INSERT INTO huuNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pedro iena januano, raite: —O lluana uiñoñedɨcue. Iena raise cacaiñedɨcue. Ie mei nase fuedo jaide. Naie facaise ɨitava dacaiño ñaɨte. ");
INSERT INTO huuNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Naie mullaɨño naimɨena dane cɨuanona, nainomo jamai itɨnomo llote: —Bimɨedɨ Jesús ie llofueoicaigano imɨe. ");
INSERT INTO huuNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Iena Pedro dane janote. Dallu illanona, nainomo jamai itɨno Pedromo llote: —Odɨ Galilea imɨedɨo. Jesús dɨga jaicabidɨo. ");
INSERT INTO huuNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Uai ote: —Uanai cue lloñenia, Jusiñamui cuena duere fɨnoite. Uanaicɨnona cue lluana naimɨe uiñote. Ero, omoɨ llogamɨena uiñoñedɨcue. ");
INSERT INTO huuNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ieconi ɨitava dane ñaɨte. Iena cacajano, Pedro Jesús lluana uibiñote. Jaive naɨo Jesús Pedromo llote: “Ɨitava menacaiño nia ñaɨñenia, dacaiño amani cuena janoitɨo”. Iena uibiñuamona, Pedro eo eede. ");
INSERT INTO huuNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Jitɨramo monaidemo, judíuaɨ illaɨcomɨnɨ danomo siadotɨmacɨ. Jusiñamui dɨga nanoca ñaɨraɨnɨ itɨmacɨ. Naimacɨ einamacɨ jɨaɨ itɨmacɨ. Moisés mɨcorɨ llogacɨnona llofueraɨnɨ jɨaɨ itɨmacɨ. Siadua mei, Jesúna maɨanona, Pilatomo uitɨmacɨ. Romanuaɨ railla naɨraɨ anamo naimacɨ illa jira, Pilatodɨ naimacɨ gobernador. ");
INSERT INTO huuNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilato naimɨemo jɨcanote: —¿Judíuaɨ comɨnɨ illaɨmadɨo? Jesús uai ote: —Jɨɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ie muidona Jusiñamui dɨga nanoca ñaɨraɨnɨ Jesúna llogɨdotɨmacɨ: —Naimɨe dɨga maraiñede rafuena fɨnode —llotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilato dɨnena naimɨemo jɨcanote: —¿Nɨese uai oñedɨo? Ona eo llogɨdotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Jesús nia uai oñena jira, Pilato uainicaide. ");
INSERT INTO huuNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Naga año pascua railla rafue facaiseconi cárcelmo itɨnomona Pilatodɨ comɨnɨ jɨcacamɨena jamai jino orede. ");
INSERT INTO huuNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Bie facaise cárcelmo Barrabás raillamɨe ite. Gobierno dɨga naimɨe navui jobairilla jira, naie facaise comena naimɨe meinia jira, cárcelmo ite. ");
INSERT INTO huuNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ie facaise ailluena comɨnɨ Pilato dɨne ofillanona, cárcelmona naimɨe fɨnocabilla isoi, damɨe jino jamai oretallena jɨcadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilato jɨcanote: —¿Bu jino cue oretallena jitaidomoɨ? Omoɨ judíuaɨ railla illaɨmana nɨbaɨ jitaidomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Iese jɨcanote; iadedɨ naimɨedɨ Jusiñamui dɨga nanoca ñaɨraɨnɨ Jesúri uradoillana uiñote. Naimacɨ Jesúna meiniacanana jɨaɨ uiñote. ");
INSERT INTO huuNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Jusiñamui dɨga nanoca ñaɨraɨnɨ naimacɨna llotataja jira, comɨnɨ dɨnena Barrabás jino jamai oretallena jɨcadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Iena cacajano, Pilato naimacɨmo jɨcanote: —¿Nɨese bimɨena cue fɨnuana jitaidomoɨ? Naimɨedɨ omoɨ judíuaɨ illaɨma raillamɨe. ");
INSERT INTO huuNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ado llotɨmacɨ: —¡Naimɨena coraɨ! ");
INSERT INTO huuNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilato dane jɨcanote: —¿Nɨe isoide maraiñede rafuena fɨnode? —Iena cacajano, ado ibi llonoidɨmacɨ: —¡Naimɨena coraɨ! ");
INSERT INTO huuNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Naimacɨna iobitallena, naimacɨ jitailla jira, Barrabás jino orede; iadedɨ Jesúna sechedotaja mei, naimɨena coraɨllena orede. ");
INSERT INTO huuNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Soldaduaɨ naimɨena gobernador jofo fo uillanona, nana soldaduaɨ nainomo ofidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Jiduirede ɨniroi naimɨemo jɨtadɨmacɨ. Eecuaɨmona niga nuicɨraina naimɨe ɨfogɨmo jɨtadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Naimɨena jɨfanoduanona, naimɨena uaidotɨmacɨ: —¡Jadi, judíuaɨ illaɨma! ");
INSERT INTO huuNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Radosi dɨga ie ɨfogɨmo buta-butadɨmacɨ. Naimɨena tuallaɨtɨmacɨ. Naimɨe illaɨmana itena, naimɨena sedallena, caiñɨcɨ ɨfodo raɨedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Jesúna naimacɨ jɨfanodua mei, naimɨe jiduirede ɨniroina duiñodɨmacɨ. Nano naimɨe ɨniroina dane abɨdo naimɨemo jɨtadɨmacɨ. Ie mei naimɨena coraɨllena oni uitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Jerusalémona naimacɨ jaillanona, jamai bitɨmɨemo dafaɨfidɨmacɨ. Naimɨedɨ Simón. Cirene railla enɨrue imɨe. Naimɨe jito iaɨmaiaɨdɨ Alejandro iaɨmaiaɨ Rufo dɨga. Jerusalén onifemona naimɨe billanona, naimɨemo dafaɨfidɨmacɨ. Naimɨena Jesús uiga cruzna rocatatɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Gólgota raillanomo jaidɨmacɨ. Ɨfocoraɨna eruaɨlla jira, iese mamecɨrede. ");
INSERT INTO huuNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Nainomo rillanona, ie abɨ isirena cacaiñellena, vinomo erɨrede rana faɨanona, Jesúmo fecadɨmacɨ; iadedɨ naimɨe iena jiroñede. ");
INSERT INTO huuNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ie mei naimɨe cruzmo coraɨa mei, cruzna naidania mei, naie soldaduaɨ naimɨe ɨniroi danɨ coninɨmo fecasɨte. Naie ɨniroi bu uille raillanona uiñollena, jɨfanododɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Jitoma nia fuirɨ daidemo, naimɨena coraɨdɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Cruzmo ie llogɨduafuena jonetɨmacɨ. Jai cuega: “Judíuaɨ comɨnɨ Illaɨma”. ");
INSERT INTO huuNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ie mei mena fɨɨriruide iaɨmaiaɨna coraɨdɨmacɨ. Damɨe Jesús nabeimo coraɨca. Jɨaɨmɨe Jesús jarɨfebeimo coraɨca. ");
INSERT INTO huuNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Iemona Jusiñamui facaina lloraɨma mɨcorɨ jaie cuegafue suide. Cuega: “Maraiñedɨno isoi naimɨe jai ite”. ");
INSERT INTO huuNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Naɨsodo jamai jaidɨno Jesúna mameritɨmacɨ. Mamerillamona, ɨfogɨaɨna jaidɨdɨmacɨ. Raitɨmacɨ: —Navui raisoidɨo: “Jusiñamui jofona judaɨitɨcue. Darui amani illanona, iena dane fɨnoitɨcue” raisoidɨo. ");
INSERT INTO huuNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Ie muidona dama o abɨna mai jillota. Cruzmona ana bi. ");
INSERT INTO huuNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ie facaise Jusiñamui dɨga nanoca ñaɨraɨnɨ naimɨena jɨfanododɨmacɨ. Moisés mɨcorɨ llogacɨno llofueraɨnɨ naimɨena jɨaɨ jɨfanododɨmacɨ. Raitɨmacɨ: —Jɨaɨe comɨnɨna jillotate; ia dama naimɨe abɨna jillotanide. ");
INSERT INTO huuNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Naimɨedɨ Cristodena, naimɨedɨ caɨ judíuaɨ comɨnɨ illaɨma raillamɨedena, dama niadedɨ cruzmona ana ie billa. Iena caɨ cɨoia, naimɨena ɨɨnoitɨcaɨ. —Iese naimɨena jɨfanododɨmacɨ. Naimɨe dɨga coraɨcamɨe iaɨmaiaɨ naimɨena jɨaɨ jeare ñaɨtɨiaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Jitoma naidai itemona, daje amani horas mona jitɨbicaide. ");
INSERT INTO huuNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ie meinomo judíuaɨ railla uaido Jesús ado jɨdaioide: —Eloi, Eloi, ¿lama, sabactani? —jɨdaioide. Iena oni dobaiñuamona raite: “Cue Jusiñamui, cue Jusiñamui, ¿bue ñellena cuena faɨnonocaidɨo?” raite. ");
INSERT INTO huuNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Iena cacajano, nainomo jamai itɨnomona damɨerie raitɨmacɨ: —Naimɨe jaie Jusiñamui facaina lloraɨma Elíana uaidote —raitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Naimacɨmona damɨe jarire jaillanona, fibecode ramo vinona faɨte. Radosimo jɨllillano jirollena, naimɨemo a fecade. Raite: —Dallu sedaitɨcaɨ. Elías naimɨena jillotajaɨbillena uiñoiacadɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ie facaise ado cuirioita fiodaite. ");
INSERT INTO huuNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Naie facaise Jusiñamui jofomo ie fetaca ɨniroife ana anaba jillacɨmo motodo menafe cuararide. ");
INSERT INTO huuNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Jesúna sedallena, nainomo capitán ite. Jesúmo eruaɨllanona, Jesús fiodaillana cɨode. Raite: —Uanai bimɨedɨ Jusiñamui Jito. ");
INSERT INTO huuNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Dajerie rɨñonɨaɨ naie rafuena aarena cɨodɨmacɨ. Naimacɨ motomo María Magdalena ite. Jɨaɨe María jɨaɨ ite. Naiñaiñodɨ Jacobo ei. Naimɨedɨ jamamɨe. Naiñaiñodɨ jɨaɨ José ei. Salomé jɨaɨ ite. ");
INSERT INTO huuNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Galileamo Jesús navui illa facaise naie rɨñonɨaɨ naimɨe dɨga jaisoidɨmacɨ. Naimɨena canouidɨmacɨ. Jerusalémo Jesús billanona, ailluena rɨñonɨaɨ naimɨe dɨga jɨaɨ bitɨmacɨ. Ie fiodaillana jɨaɨ cɨodɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Jitoma ana itemo, sábado rille jai iaɨrei illanona, ");
INSERT INTO huuNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Arimatea naɨraɨ imɨe Pilato dɨne jaide. Naimɨedɨ José. Naimɨedɨ illaɨcomɨnɨ. Maremɨe. Naimɨe Jusiñamui ie comɨnɨna ɨco sedajanomo illemo ocuiride. Ie comecɨna ocuiñocaida, Pilato dɨne jaide. Iena raɨllena, Jesús abɨna jɨcade. ");
INSERT INTO huuNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Iena cacajano, Pilato Jesús fiodaillana raise uiñoiacade. Ie fiodaillana nia fɨdɨñede. Jesúna sedade capitána uaiduanona, naimɨemo Jesús fiodaillana jɨcanote. ");
INSERT INTO huuNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","—Jesús jai fiodaite —capitán railla mei, Pilato Jesús abɨna Josémo fecallena llote. ");
INSERT INTO huuNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","José mare userede ɨniroi ɨbaja mei, cruzmona Jesús abɨ ana ua mei, naie ɨniroi dɨga ie abɨna ferɨnote. Nofɨcɨ motomo fɨnoca raɨafomo jonete. Naifona ɨbaillena, aillue nofɨcɨ nainomo baɨ ñuitade. ");
INSERT INTO huuNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","María Magdalena, jɨaɨe María dɨga, naimɨe raɨana cɨode. María José ei. ");
INSERT INTO huuNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sábadoruimo jitoma sojicaidemo, María Magdalena caɨmare soride rana ɨbade. Jacobo ei, María jɨaɨ ɨbade. Salomé jɨaɨ ɨbade. Jesús abɨmo jonellena, ie abɨna raise fɨnollena naimacɨ einamacɨ fɨnocabilla isoi, naiñaiñuaɨ iena ɨbade. ");
INSERT INTO huuNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Domingo jitɨramo jitoma como bairedemo, Jesús raɨafo dɨne naiñaiñuaɨ jaide. ");
INSERT INTO huuNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Jaillanona, coniñuaɨmo jɨcanote: —¿Bu nofɨcɨna caɨna oni ñuitalle raɨafomona? ");
INSERT INTO huuNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Raɨafo dɨne rillanona, iemo eruaɨllanona, nofɨcɨ oni ñuitacana cɨode. Naie nofɨcɨ eo aillue. ");
INSERT INTO huuNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Raɨafomo jaillanona, naiñaiñuaɨ coniruena eruaɨdɨmɨena nabeimo raɨllana cɨode. Naimɨe are userede ɨniroina jɨtade. Naimɨedɨ Jusiñamui jaɨenicɨ. Naiñaiñuaɨ jacɨnaite. ");
INSERT INTO huuNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Nainomo itɨmɨe dɨnena raite: —Jacɨnaiñeno. Nazaret ie Jesúna jenodomoɨ. Naimɨena coraɨdɨmacɨ; ia fiodaillamona naimɨe jai jillode. Bene jai iñede. Naimɨe jonianomo mai eroda. ");
INSERT INTO huuNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Naimɨe llofueoicaiganomo iena lluai. Ua Pedromo llono. Galileamo omoɨ uicomo naimɨe jaite. Omoɨmo naimɨe llua isoi, naimɨena cɨoitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Naiñaiñuaɨ jino jaillanona, raɨafomona aisɨcana jaide. Jacɨnaillamona abɨ jaidɨsite. Jacɨruillamona, iena bumo lloñede. ");
INSERT INTO huuNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Domingo jitɨramo Jesús jillua mei, María Magdalenamo Jesús nano bairede. Naiñaiño Janaba anamo navui illamona, Jesús naiñaiñomona siete jananɨaɨ navui oni orede. ");
INSERT INTO huuNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Naiñaiñomo naimɨe bairia mei, naimɨe dɨga jaicabidɨnomo iena lluaide. Naimacɨmo iena nia lloñenia, sure eedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","—Naimɨe jai jillode. Naimɨena jai cɨodɨcue —naimacɨmo naiñaiño llua mei, iena ɨɨnoñedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ie meinoconi Jesús mena llofueoicaiganomo bairede. Naimɨe eruaɨsoilla isoi, eruaɨñede. Iaɨmaiaɨ naɨsomo macaria, iaɨmaiaɨmo bairede. ");
INSERT INTO huuNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Jerusalémo abɨdo iaɨmaiaɨ rilla mei, jɨaɨe llofueoicaiganomo iena llotɨiaɨmaiaɨ; ia ɨɨnoñedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ie once llofueoicaigano danomo guitɨmacɨmo, Jesús naimacɨmo bairede. Naimɨe jillua mei, damɨerie naimɨena cɨuanona, ie llofueoicaiganomo iena llote; ia ɨɨnoñedɨmacɨ. Naimacɨ ɨɨnoñena jira, Jesús naimacɨmo rɨire llote. ");
INSERT INTO huuNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Naimacɨmo llote: —Nana naɨraɨaɨmo jai. Nana comɨnɨmo cue mare rafue llocana jai. ");
INSERT INTO huuNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Cuena ɨɨnuamona, bautizagano dɨese Jusiñamuimona duere sefuiñeitɨmacɨ; iadedɨ Jusiñamui cuena ɨɨnoñedɨnona duere fɨnoite. ");
INSERT INTO huuNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Cuena ɨɨnotɨno Janaba anamo itɨnomona Janabana oni oretaitɨmacɨ. Naimacɨ nia uiñoñega uaido ñaɨtɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Jaiona naimacɨ llɨnoia, naimacɨna nɨese nɨbaɨñeite. Baɨnode ra naimacɨ jiroia, naimacɨna nɨese nɨbaɨñeite. Duidɨnona naimacɨ jetajamona, jilloitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ie llofueoicaigano dɨga ñaɨa mei, Jusiñamui caɨ Nama Jesús monamo uiga. Illaɨmana Jesús illa jira, Jusiñamui nabeimo naimɨe raɨde. ");
INSERT INTO huuNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Monamo Jesús jailla mei, ie llofueoicaigano, dɨga naɨraɨaɨmo, ie rafuena llocana jaidɨmacɨ. Caɨ Nama naimacɨna canuamona, naimacɨna siño rafuena fɨnotate. Iemona comɨnɨ dɨnena Cristomona naimacɨ rafue illana uiñotɨmacɨ. Macaɨbaite. Cue cuega rafue jai fuite. Marcodɨcue.");
INSERT INTO huuNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","4","Teófilo, cue isiruiga nabai. ¿Nɨgacɨno? Omo bie cartana oredɨcue. Caɨ motomo birui dɨga rafue jai suide. Jesucristo rafuena omo cuetɨcue. Naimɨe billa mei, dɨga comɨnɨ naimɨemo suide rafuena cɨodɨmacɨ. Iena llocana jɨaɨ jaidɨmacɨ. Naimacɨmona bie rafue raise uiñotɨcue. Bie rafuena fɨdɨanona, damɨerie iena jai cuetɨmacɨ. Bie rafuena jɨaɨ jai cacadɨo. Bie rafuena cue raise uiñua jira, uanaicɨnona o raise uiñollena, bie cartana jai cuetɨcue. Iese birui cue comecɨ jitaide. ");
INSERT INTO huuNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Jesucristo nia jeicɨñenia, Zacarías illa facaise Herodena mamecɨrede illaɨmadɨ. Judea railla enɨruena sedade. Zacarías Jusiñamui dɨga ñaɨraɨma. Abías raillasie facaimo duillamona, Jusiñamui jofomo maɨjɨuide. Naimɨe aɨdɨ Elisabet. Naiñaiño jaie ite usumadɨ Aarón mɨcorɨ. Aarón mɨcorɨdɨ Jusiñamui dɨga nano ñaɨraɨma. ");
INSERT INTO huuNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Jusiñamuimona iaɨmaiaɨ mare, nana naimɨe lloga uaina raise iaɨmaiaɨ ɨɨnua jira. ");
INSERT INTO huuNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Naiñaiño oɨniñona jira, uruenidɨaɨmaiaɨ. Jɨaɨ jai uaɨcɨma iaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Zacarías facai ite comɨnɨ maɨjɨa facaise ia, Jusiñamui jofo dɨne naimɨe maɨjɨaide. ");
INSERT INTO huuNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Nainomo naimɨe maɨjɨia, caɨmare soride ra fo jobaillena, naimɨena fetodɨmacɨ. Naimacɨ fɨnouilla isoi, jobaillanona danɨ Jusiñamui dɨga ñaɨraɨnɨ naimɨena fetodɨmacɨ. Iemei naimɨe fo jaide. ");
INSERT INTO huuNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Fo jailla mei, naie caɨmare soride ra boa facaiseconi, Jusiñamui dɨga naimɨe ñaɨano, ailluena comɨnɨ Jusiñamui jofo ecɨmo itɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ieconi caɨ Nama Jusiñamui jaɨenicɨdɨ naie ra boano nabeimo Zacaríamo bairede. ");
INSERT INTO huuNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Naimɨena cɨuanona, Zacarías jacɨnaite. ");
INSERT INTO huuNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Jaɨenicɨ naimɨemo llote: —Zacarías, jacɨnaiñeno. Jusiñamui o jɨɨacɨnona jai cacade. Iemona o aɨ uruesite. Ɨimana jocoite. Juan o jɨtalle naimɨe mamecɨdɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Iemona o comecɨ caɨmare iite. Iobitɨo. Ailluena comɨnɨ naimɨe jeicɨari iobitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Jusiñamuimona naimɨe jamai bue isoiñeitɨmɨena jaite. Jɨfaitate rana jiroñeite. Naimɨe jeicɨamona Jusiñamui Joreño naimɨena namataite. ");
INSERT INTO huuNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Caɨ Nama Jusiñamui dɨbeimo ailluena Israel comɨnɨna naimɨe itataite. ");
INSERT INTO huuNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Jusiñamui jitaillacɨnona fɨnocana jaite. Elíamo Jusiñamui Joreño jaie siño uai illa isoi, naimɨemo iite. Jusiñamui rafuena naimɨe lluamona, damɨerie, naimacɨ jaiagaɨ isoi, Jusiñamuina ɨɨnoitɨmacɨ. Ailluena Jusiñamui uaina jai ɨɨnoñedɨmacɨ; ia damɨerie birui ɨɨnoitɨmacɨ. Naimacɨ comecɨaɨ Jusiñamui dɨbeimo meidoitɨmacɨ. Iemona caɨ Nama Jesucristo bia, naimɨena ɨɨnoitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zacarías dɨnena jɨcanote: —¿Nɨese o llua suillena uiñoitɨcue? Jai uaɨcɨmadɨcoco. ");
INSERT INTO huuNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Jusiñamui jaɨenicɨ dɨnena uai ote: —Gabrieldɨcue. Jusiñamuimona bitɨcue. Cuena oretate, bie mare rafuena omo llollena. ");
INSERT INTO huuNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ero, cue uaina o ɨɨnoñena jira, uainitɨo, o jito jeicɨlle dɨnori. Jɨaɨruido bie rafue suite. ");
INSERT INTO huuNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Jusiñamui jofomo jino itɨno Zacarías jino billena sedadɨmacɨ. “¿Bue ñellena naimɨe are biñede?” comecɨaɨna facadɨmacɨ. Naimɨe jino are biñena jira, raijicaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Naimɨe jino bitemo, naimacɨ dɨga jai ñaɨnide. Ie onollɨ dɨga facajamona, Jusiñamui jaɨenicɨ naimɨemo jai lluana uiñotɨmacɨ. Naimɨe ñaɨñeno ite. ");
INSERT INTO huuNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Jusiñamui jofomo naimɨe maɨjɨa facaise fuilla mei, ie jofomo abɨdo jaide. ");
INSERT INTO huuNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Dɨgarui illanona, ie aɨdɨ urueside. Ie jira jofomo naiñaiño cinco fɨvui fɨebide, comecɨna facajanona: ");
INSERT INTO huuNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Cue uruesilla jira, iena nia buna lloiacaiñedɨcue. Cue Nama cuena jai duenaillana uiñotɨcue. Navui cue urue iñena jira, meiruitɨcue. Jai meiruiñeitɨcue. Comɨnɨ cue joreñona jai ñaɨñeitɨmacɨ”. ");
INSERT INTO huuNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","27","Elisabet seis fɨvui uruesilla mei, Jusiñamuidɨ Galileamo ie jaɨenicɨ Gabrielna orede. Nazaretmo María dɨne naimɨena orede. María nia ɨninide; ia jai José jɨcanogañaiño. Naimɨe usumadɨ David mɨcorɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Rillanona, naiñaiñomo llote: —Itɨo. Caɨ Nama Jusiñamui ona eo duenaite. Ona jai fetuamona, nana jɨaɨe rɨñonɨaɨ baɨfemo naimɨedɨ ona marena itatate. ");
INSERT INTO huuNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Iena cacajanona, naiñaiño jacɨnaite. Iena naiñaiño raise cacaiñena jira, iemo comecɨna facade. ");
INSERT INTO huuNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Gabriel dɨnena llote: —Jacɨnaiñeno. Jusiñamui ona duenaite. ");
INSERT INTO huuNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Birui uruesitɨo. Ɨimana jocoitɨo. Naimɨe mamecɨna jɨtaitɨo Jesúna. ");
INSERT INTO huuNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Siño Jitona jaite. Nanoca Itɨmɨe Jitona jaite. Ie usuma David mɨcorɨ illaɨma illa isoi, Jusiñamuidɨ naimɨena illaɨmana itataite. ");
INSERT INTO huuNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Illaɨmana illamona, Israel railla naɨraɨna jaca sedaite. Naimɨe ifomo jɨaɨmɨe jaca iñeite. ");
INSERT INTO huuNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","María uai ote: —Ɨima dɨga nia iñedɨcue. ¿Nɨese bie nɨbaɨlle? ");
INSERT INTO huuNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Gabriel llote: —Jusiñamui Joreño omo iite. Ie siño uai dɨga iena fɨnoite. Jusiñamui marena isoi naimɨe jɨaɨ marenite. Naimɨedɨ Jusiñamui Jito. ");
INSERT INTO huuNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","O comɨnɨ iñaiño, Elisabet, ie uaɨcɨtailla facaise jɨaɨ jai urueside. Naiñaiño jai jionaide; ia jai seis fɨvui naiñaiño uruesilla ite. ");
INSERT INTO huuNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Jusiñamui nana bie isoide rafuena fɨnorede. ");
INSERT INTO huuNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","María uai ote: —Jee. Jusiñamui anamo itɨcue. O lluacɨno cuemona mare. Ie facaise Gabriel naiñaiñomona oni jaide. ");
INSERT INTO huuNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ie facaiseconi María aneduaɨ dɨne Judea railla enɨruemo Zacarías illanomo raɨre jaide. Elisabetna cɨoillena, jaide. ");
INSERT INTO huuNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Zacarías jofomo rillano: —Itɨo —raillanona, Elisabetna uaidote. ");
INSERT INTO huuNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elisabet naiñaiño uaina cacajano, ieconi naiñaiño jeraimo ite urue iena jɨaɨ uiñuamona, niraɨde. Ie facaise Jusiñamui Joreño anamo Elisabet jai ite. ");
INSERT INTO huuNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Iese illamona, María uruesillana uiñote. Naiñaiño ado llote: —Jusiñamui ona eo marena canoite. O uruena marena itataite. ");
INSERT INTO huuNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Jamai bue isoidɨcue; ia, odɨ cue Jilloitaraɨma ei illanona, cue dɨne bitɨo. Iena cuemo nia lloñedɨo; ");
INSERT INTO huuNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","ia, cuena o uaiduanona, iobillamona cue jeraimo ite uruedɨ niraɨde. ");
INSERT INTO huuNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Caɨ Nama omo llotataga uaina suillana o ɨɨnua jira, Jusiñamui ona eo marena canoite. —Jusiñamui Joreño naiñaiñomo illamona, iena llote. ");
INSERT INTO huuNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","María dɨnena uai ote: Caiñaɨ Nama eo mare. Naimɨemo iobillacɨnona fecaacadɨcue. ");
INSERT INTO huuNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Naimɨedɨ cue Jilloitaraɨmana jira, naimɨeri iobidɨcue. ");
INSERT INTO huuNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Jamai bue isoidɨcue; iadedɨ cuena fetode. Ie jira biruimona nana comɨnɨ cuena marena ñaɨtɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Naimɨedɨ siño. Naimɨedɨ mareuidɨmɨe. Cue facaina eo mare rafuena fɨnode. ");
INSERT INTO huuNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Naimɨena ɨɨnotɨnona jaca duenaite. Caɨ jaiagaɨna jaca duenaite. Caɨna birui jaca duenaite. Ua nana naimɨena ɨɨnotɨnona duenaite. ");
INSERT INTO huuNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Dɨga siño rafuena fɨnoite. Abɨ ɨedotɨno comecɨaɨ facajacɨnona llɨɨcaitaite. ");
INSERT INTO huuNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Naimɨedɨ illaɨcomɨnɨna oni dotaite; ia jamai bue isoidɨnona jamai bue isoiñedɨnona itataite. ");
INSERT INTO huuNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Dueredɨnona eo canoite; ia duenidɨnomo buena fecañeite. ");
INSERT INTO huuNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Duenaillamona, caɨ Israel comɨnɨna feitañeite. ");
INSERT INTO huuNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Caɨ jaiagaɨmo naimɨe jaie llua isoi, birui caɨna canoite. Abraham mɨcorɨmo jaie llote: “Ona duenaitɨcue. O comɨnɨna jaca duenaitɨcue” María llote. ");
INSERT INTO huuNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Elisabet dɨga davui amani naiñaiño fɨebide. Ie mei ie jofomo abɨdo jaide. ");
INSERT INTO huuNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisabet jocuarui jai ridemo, ɨimana jocode. ");
INSERT INTO huuNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Naiñaiño ecɨmo ite comɨnɨ, naiñaiño comɨnɨ dɨga, iena fɨdɨamona, caɨ Nama naiñaiñona eo duenaillana uiñotɨmacɨ. Naiñaiño dɨga iobidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ocho dɨgarui jeicɨa mei, naimacɨ fɨnouilla isoi, urue abɨna dia rafuemo bitɨmacɨ. Ie moo mamecɨna jɨtaacadɨmacɨ; ");
INSERT INTO huuNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","iadedɨ Elisabet llote: —Dama ite. Jitaiñedɨcue. Naimɨe mamecɨdɨ Juan caɨ jɨtalle. ");
INSERT INTO huuNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Uai otɨmacɨ: —¿Bue ñellena iese raitɨo? O comɨnɨmona jaca bu Juan mamecɨredɨmɨena iñede. ");
INSERT INTO huuNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Jefona cacaiñena jira Zacaríamo onollɨ dɨga jɨcanotɨmacɨ, ie jito mamecɨna jɨtallena. ");
INSERT INTO huuNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Onollɨ dɨga Zacarías faɨriuano, rabena jɨcade. Cuete: “Naimɨe mamecɨdɨ Juan”. Ieri raijicaidɨmacɨ. “¿Bue ñelle iena jɨtade?” comecɨaɨna facadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ieconi Zacarías jai dane ñaɨte. Ie jira Jusiñamuimo iobillacɨno fecade. ");
INSERT INTO huuNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Nana iaɨmaiaɨ ecɨmo itɨno raijicaidɨmacɨ. —Jusiñamui muidona naie rafue suide —llotɨmacɨ. Bie rafuena fɨdɨano, nana Judea railla aneduaɨmo itɨnodɨ iena ñaɨoidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Iena cacajano, comecɨaɨna facadɨmacɨ: “Bimɨe jamai bue isoiñeitɨmɨena jaite”. Caɨ Nama naimɨena marena jaca canua jira, iese llotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ie facaise Jusiñamui Joreño Zacaríana llotatajanona, Zacarías llote: ");
INSERT INTO huuNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Caɨ Nama Jusiñamuidɨ mare. Caɨ Israel comɨnɨ dɨne biite, caɨna jilloitallena. ");
INSERT INTO huuNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","David mɨcorɨ Jusiñamuina jaie sedade. David mɨcorɨ comɨnɨmona siño Jilloitaraɨmana caɨ dɨne oretaite. ");
INSERT INTO huuNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ie facaina lloraɨnɨdo naimɨe jaie llua isoi, caɨ Jilloitaraɨmana oretaite, ");
INSERT INTO huuNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Taɨfemona, Janabamona caɨ jilloillena. ");
INSERT INTO huuNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","73","Caɨ usumatɨaɨ mɨcorɨaɨmo: “Omoɨna duenaitɨcue” llote. Caɨ usuma Abraham mɨcorɨmo jaie llogacɨnona feitañede. ");
INSERT INTO huuNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","Taɨfemona caɨ jilloillena, caɨ Jilloitaraɨmana oretaite. Nana caɨ ille dɨnori Jusiñamuina jacɨruiñeno sedajana jitaide. Naimɨe jitailla isoi caɨ illena, naimɨe jitaillacɨnona caɨ fɨnollena, caɨ Jilloitaraɨmana oretaite. ");
INSERT INTO huuNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Cue jito, ona lloitɨcue. Jusiñamui ie lloraɨmana jaitɨo. Caɨ Nama uicomo jaitɨo, comɨnɨ comecɨaɨ o raise fɨnollena. ");
INSERT INTO huuNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ie comɨnɨmo jeacɨnomona jilluacɨnona lloitɨo. Iena naimacɨ ɨɨnoia, Jusiñamui naimacɨ jeacɨnona feitaite. ");
INSERT INTO huuNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","79","Jeacɨno anamo jai caɨ illa jira, jitɨredɨnomo itɨcaɨ isoidɨcaɨ. Jusiñamuina caɨ nia ɨɨnoñenia, fiodaillana jacɨruitɨcaɨ. Naimɨe caɨna duenaillamona, caɨ Jilloitaraɨma billena o llofuellena, ona oretaite. Naimɨena caɨ ɨɨnoia, jitɨredɨnomo iñeitɨcaɨ; ia Jusiñamui dɨga caɨ comecɨaɨ uri iite. ");
INSERT INTO huuNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Zacarías jito sairide. Jusiñamuina ɨɨnocana jaide. Comɨnɨmo naimɨe nia marefodo lloñenia, jofue iñenanomo ite. ");
INSERT INTO huuNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","2","Jesús jeicɨa facaise César Augusto anamo ailluena naɨraɨaɨ ite. Romamona naimacɨna sedauide. Naie facaise Siria railla enɨrue gobernadordɨ Cirenio. César Augusto, nɨe dɨese comɨnɨ naga naɨraɨmo illana naimɨe uiñollena, nana comɨnɨ mamecɨaɨ cuellena ocuide. Jaca bu iese jaie fɨnoñede. ");
INSERT INTO huuNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Naimacɨ jaiagaɨ illanomo mamecɨaɨ cuiana ocuide. ");
INSERT INTO huuNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ie jira José Galileamona Nazaretmona jaide. Judeamo Belémo jaide. David mɨcorɨ comɨnɨmo naimɨe jaɨnaɨaɨlla jira, David mɨcorɨ illanomo jaide. ");
INSERT INTO huuNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ie aɨ María dɨga jaide. Naiñaiño fenaɨ jai eo aillue. ");
INSERT INTO huuNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","7","Belémo iaɨmaiaɨ rillanona, naie facaise comɨnɨ jofomo ɨnɨllɨno iñena jira, jurareta jofomo ridɨiaɨmaiaɨ. Nainomo ie doforato jito jeicɨte. Jocua mei, ɨniroina naimɨena ferɨnote. Ie jito ɨnɨllena, jurareta ecaranomo naimɨena jonete. ");
INSERT INTO huuNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Jesús jeicɨa facaise naie naɨo Belén ecɨmo ite pastomo damɨerie toɨca llaudaɨaɨna sedaraɨnɨ itɨmacɨ. Naimacɨ toɨnɨaɨna sedadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ieconi caɨ Nama Jusiñamuimona daje jaɨenicɨ naimacɨmo ebena bairede. Jusiñamui ie siño uai dɨga naimacɨna quetiñote. Jacɨnaitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Jaɨenicɨ llote: —Jacɨnaiñeno. Mare rafue lloiacadɨcue. Nana comɨnɨna iobitallena, iena lloiacadɨcue. ");
INSERT INTO huuNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","David mɨcorɨ illanomo damɨe como jeicɨga. Jusiñamui facaina lloraɨnɨ mɨcorɨaɨ naimɨe billena jaie llouidɨmacɨ. Naimɨedɨ Cristo caɨ Nama. Naimɨe omoɨ Jilloitaraɨma. Jeacɨnomona omoɨna jillotaite. ");
INSERT INTO huuNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Naimɨena jɨbuisai. Ɨniroina ferɨnoga urue jurareta jofomo imacɨ ecaranomo baitomoɨ. Iemona cue lluana uanaicɨnona uiñoitomoɨ —llote. ");
INSERT INTO huuNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ie facaise naie jaɨenicɨ dɨne ailluena jaɨenisaɨ bitɨmacɨ. Jusiñamuimo iobillacɨnona fecajano rotɨmacɨ: ");
INSERT INTO huuNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Monamo Jusiñamui illanona, naimɨemo iobillacɨnona fecaacadɨcaɨ. Comɨnɨna naimɨe duenaillamona, naimɨe dɨga uri iitɨmacɨ rotɨmacɨ. Ie mei abɨdo jaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Monamo jaɨenisaɨ jailla mei, toɨca llaudaɨaɨ sedaraɨnɨ coninɨri ñaɨtɨmacɨ: —Belémo mai caɨ jaillɨ, caɨ Nama caɨmo como lloga rafuena caɨ jɨbuisaillena. ");
INSERT INTO huuNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ieconi raɨre jaidɨmacɨ. María José dɨga baitɨmacɨ. Iaɨmaiaɨ urue jurareta ecaranomo bɨillana cɨodɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Naimɨena cɨua mei, nana naimacɨmo jaɨenicɨ lloga rafuena llotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Nana naie rafuena cacadɨnodɨ ieri raijicaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","20","Iaɨmaiaɨ uruena cɨua mei, llaudaɨaɨ sedaraɨnɨ imacɨ toɨnɨaɨ dɨne abɨdo jaidɨmacɨ. Naimacɨmo jaɨenicɨ llua isoi naimacɨmo suilla jira, iobidɨmacɨ. Nana naimacɨ cacaja rafueri, nana naimacɨ cɨua rafueri Jusiñamuimo iobillacɨnona fecadɨmacɨ. María naie rafuena feitañede; ia iena comecɨna facauide. ");
INSERT INTO huuNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ocho dɨgarui illanona, naie urue abɨna dete. Ie ei jeraimo naimɨe nia comuiñenia, Jusiñamui jaɨenicɨ naimɨe lloga mamecɨna jɨtade. Jusiñamui jaɨenicɨ llua isoi, Jesúna ie mamecɨna jɨtade. ");
INSERT INTO huuNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Moisés mɨcorɨ jaie llua isoi Jerusalémo Jesúna uitɨiaɨmaiaɨ. Moisés mɨcorɨ jaie cuete: “Cuarenta dɨgarui jocua mei, Jusiñamuimona rɨño marena illena, Jusiñamuimo mena fɨcɨri naiñaiño fecaja. Jusiñamui dɨga ñaɨraɨma iena faja mei, rɨño facaina Jusiñamuimo jobaica”. Jɨaɨ cuete: “Naga nano doforamɨedɨ Jusiñamui ie. Ie muidona naimɨe facaina Jusiñamuimo ucubena fecaja”. Ie muidona Jerusalémo Jesús dɨga jaidɨiaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Naie facaise Jerusalémo Simeón raillamɨe ite. Jusiñamuimona naimɨedɨ mareuidɨmɨe. Jusiñamuina eo ɨɨnocana jaide. Naimɨe comɨnɨna Cristo jilloitallena, Cristo billemo ocuiride. Naie facaise Jusiñamui Joreño anamo naimɨe ite. ");
INSERT INTO huuNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Iemona Jusiñamui Joreñodɨ, naimɨena Cristona cɨoillena, navui uicodo uiñotade. O nia fiodaiñenia, Cristona cɨoitɨo raillanona llote. ");
INSERT INTO huuNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Jusiñamui jofomo Jusiñamui Joreño naimɨena oretate. Jusiñamuimo Jesúna fecallena, Jesús ei, José dɨga, Jesúna fo uillana Simeón cɨode. ");
INSERT INTO huuNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Naimacɨ dɨne jaillanona, Jesúna meniñote. Jusiñamuimo iobillacɨnona fecajano jɨɨde: ");
INSERT INTO huuNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Nama, o anamo itɨcue. Cuemo o lloga uai jai suilla jira, uri fiodaitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","O oretaga Jilloitaraɨmana jai cɨodɨcue. ");
INSERT INTO huuNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Naimɨena oredɨo, nana comɨnɨ jilloillena. ");
INSERT INTO huuNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Naimɨedɨ judíuaɨñedɨnona uanaicɨnona uiñotaite. O comɨnɨna iobitaite jɨɨde. ");
INSERT INTO huuNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Iena cacajamona, iaɨmaiaɨ jitona lloga uairi raijicaidɨiaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","Simeón iaɨmaiaɨmo caɨmaredɨcɨnona llote: —Jusiñamui omoɨna raise canoite —llote. Maríamo llote: —Ero, ie rafuena llollena, Jusiñamui o jitona jai fetode. Naimɨe illamona, comɨnɨ comecɨaɨna facajacɨnona uiñotaite. Naimɨemo suille rafuemona o comecɨ sure iite. Caɨ comɨnɨmona ailluena naimɨena jitaiñeitɨmacɨ. Ailluena jitaitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Nairuido Jusiñamui jofomo Ana railla fecɨño ite. Jusiñamui naiñaiñomo lloga rafuena llouide. Naiñaiño moo Fanuel mɨcorɨ. Naiñaiño naɨraɨdɨ Aser. Jitaɨño facaisemona ie ɨni dɨga siete años illanona, naimɨe fiodaite. ");
INSERT INTO huuNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Naiñaiño jai eo uaɨcɨño. Ochenta y cuatro años naiñaiñodɨ jai ite. Jusiñamui jofomo jaca isoide. Nagarui Jusiñamuimo jɨɨanona guicabiñeno naimɨena sedauide. ");
INSERT INTO huuNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Simeón ñaɨana cacajano, naiñaiño Jesús comɨnɨ dɨne billano, Jusiñamuimo iobillacɨnona fecade. Naimɨe billemo naimacɨ ocuirilla jira, naiñaiño naimacɨ Jilloitaraɨmana nainomo itɨnomo llocana uite. ");
INSERT INTO huuNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Moisés mɨcorɨ lloga uai naimacɨ fuidua mei, Jesúna uillanona, Galileamo Nazaretmo naimacɨ illanomo abɨdo jaidɨiaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Nainomo Jesús sairicana maɨricana jaide. Eo abɨna uiñote. Naimɨeri iobillamona, Jusiñamui naimɨena canouide. ");
INSERT INTO huuNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Naga año Jerusalémo pascua railla rafue dɨne Jesús moo iaɨmaiaɨ jaisoidɨiaɨmaiaɨ. Egiptomona naimacɨ jaiagaɨ jillobillana comecɨllena, naie rafue ite. ");
INSERT INTO huuNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Naimɨemo doce años illa facaise Jerusalémo iaɨmaiaɨ jaisoilla isoi, jaidɨiaɨmaiaɨ. Naimɨe doce años illa jira, Jesúna uitɨiaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","44","Rafue fuilla mei, abɨdo bitɨiaɨmaiaɨ. Ailluena comɨnɨ jɨaɨ billa jira, Jesús billana raise uiñoñedɨiaɨmaiaɨ. “Caɨ comɨnɨ dɨga naimɨe bite” raillanona comecɨna facadɨiaɨmaiaɨ; ia Jesús Jerusalémo fɨebide. Darui raifi billa mei, iaɨmaiaɨ comɨnɨmo naimɨena eo jenodɨiaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Baiñena jira, ɨnɨa mei, Jerusalémo darui jaillanona, abɨdo jaidɨiaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ie are Jusiñamui jofomo naimɨena baitɨiaɨmaiaɨ. Moisés mɨcorɨ llogacɨnona llofueraɨnɨ motomo naimɨe ite. Naimacɨ llofuiana cacade. Iena naimacɨ dɨga jɨaɨ siadote. ");
INSERT INTO huuNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Nana cacadɨno naimɨe uiñogacɨnori raijicaidɨmacɨ. Naimɨe raise siadogacɨnori jɨaɨ raijicaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Naimɨena iaɨmaiaɨ baia, raijicaidɨiaɨmaiaɨ. Ie ei naimɨemo jɨcanote: —¿Bue ñellena cocona duere fɨnodɨo? O moocama dɨga ona eo duere jenodɨcoco. ");
INSERT INTO huuNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Naimɨe uai ote: —¿Bue ñellena cuena duere jenodomɨco? Cue Moo jofomo naimɨe rafuena fɨnodɨcue. ¿Nɨese bene cue illana uiñoñedomɨco? ");
INSERT INTO huuNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Naimɨe lluana raise cacaiñedɨiaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Iemei iaɨmaiaɨ dɨga Nazaretmo naimɨe abɨdo jaide. Iaɨmaiaɨ uai ɨɨnuanona, iaɨmaiaɨ anamo ite. Ie ei María nana naie rafue ie comecɨmo facauide. ");
INSERT INTO huuNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Naimɨe sairicana abɨna uiñocana jaide. Jusiñamui naimɨeri iobide. Comɨnɨ dɨnena naimɨena jɨaɨ gaɨdɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Jofue iñenanomo dɨga años Juan illanona, Jusiñamuimona ie uaina feiñote. Naimɨedɨ Zacarías jito. Naie facaiseconi Romamo quince años Tiberio Césardɨ nanoca illaɨmana jai ite. Judea railla enɨrue gobernadordɨ Poncio Pilato. Galilea railla enɨrue gobernadordɨ Herodes. Naimɨe amadɨ Felipe. Iturea railla enɨrue, Traconite railla enɨrue dɨga, gobernadordɨ Felipe. Abilinia railla enɨrue gobernadordɨ Lisanias. Jusiñamui dɨga nanoca ñaɨraɨma iaɨmaiaɨdɨ Anás, Caifás dɨga. ");
INSERT INTO huuNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Jusiñamui llua jira, nana Jordán fuemo ite comɨnɨ dɨne Juan llofuecana jaide. Llote: —Omoɨ jeacɨnona faɨnonocaida, Jusiñamui dɨbeimo omoɨ comecɨaɨ iuai meido. Iemona Jusiñamui omoɨ jeacɨnona feitaite. Omoɨ comecɨ iuai omoɨ meidoia, comɨnɨ iena uiñollena, mai omoɨ bautizallomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Isaías mɨcorɨ ie rabemo naimɨena jaie cuete: Jofue iñenanomo damɨe jɨdai-jɨdaillana cacadɨcue. Naimɨe llote: “Caɨ Nama biite. Naimɨe jaillɨno atona fɨno. ");
INSERT INTO huuNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Nana iconɨ oruita. Naga aneduaɨ dɨese enɨruena judaɨ. Neɨcairuaɨ joide naɨsona atona fɨno. Naɨmo itaicuaɨ illa dɨese enɨruena oruita, daje facai illena. ");
INSERT INTO huuNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Nana comɨnɨ Jusiñamui naimacɨna jillotaiacanana uiñoitɨmacɨ” cuete; ia naimacɨ comecɨaɨna ñaɨte. Caɨ Namana ɨɨnuana ñaɨte. Abɨna ɨedoñenana ñaɨte. Jeacɨno fɨnocana jaiñenana ñaɨte. Caɨ Nama Jesús bia, Jesús uaina naimacɨ feiñollena, naimacɨ comecɨaɨ marena fɨnuana ñaɨte. ");
INSERT INTO huuNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Naimacɨna bautizallena, ailluena comɨnɨ naimɨe dɨne bitɨmacɨ. Naimacɨmo llouide: —Maraiñede rafuena fɨnocana omoɨ jailla jira, jaio naɨraɨ isoidomoɨ. ¿Nɨese jilloitomoɨ? Cue dɨne omoɨ billena, ¿bu omoɨmo lloga? ");
INSERT INTO huuNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Omoɨ comecɨaɨ iuaillaɨ meido. Omoɨ jeacɨnona faɨnonocai. Iemona Jusiñamui jitaillacɨnona fɨno. Mare rafuena fɨnocana jai. Naiemona omoɨ comecɨaɨ iuaillaɨ meiduana uiñoitɨcaɨ. Ie mei bautizallomoɨ. Omoɨ comecɨaɨna facañeno: “¿Bue ñellena o llua isoi fɨnoitɨcaɨ? Jusiñamui Abraham mɨcorɨna jaie eo raise nabaide. Abraham mɨcorɨ caɨ moo illamona, Jusiñamui rɨicaillɨfuemona jilloitɨcaɨ”. Ero, omoɨmo lloitɨcue: Cue llua isoi omoɨ fɨnoñenia, naimɨe rɨicaillɨfuemona jilloñeitomoɨ. Abraham mɨcorɨ uruiaɨdomoɨ; iadedɨ Jusiñamui jitaillacɨnodo jaiacaiñedomoɨ. Naimɨe jitaia, naimɨe jitaillacɨnona naimacɨ fɨnollena, bene ite nofɨcɨmona naimɨedɨ Abraham mɨcorɨ facaina uruiaɨna comuitarede. ");
INSERT INTO huuNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ero, llɨsiñede riara tɨedomoɨ. Tɨia mei, maraiñena jira, iena jobaidomoɨ. Ie isoidomoɨ. Omoɨ maraiñena jira, Jusiñamui omoɨna jai duere fɨnoacade. Ie rɨicaillafue anamo jai itomoɨ. Omoɨ comecɨaɨ iuai omoɨ meidoñenia, omoɨna duere fɨnoite. ");
INSERT INTO huuNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Iena cacajanona, comɨnɨ dɨnena naimɨemo jɨcanotɨmacɨ: —Caɨ bautizaja mei, ¿nɨese iitɨcaɨ? ¿Nɨe isoide mare rafuena fɨnoitɨcaɨ? ");
INSERT INTO huuNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Juan uai ote: —Ailluena ɨniroiredɨmɨedɨ ɨniroinidɨmɨemo ɨniroina feca. Guilleredɨmɨedɨ guillenidɨmɨemo guillena feca. ");
INSERT INTO huuNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Naimacɨna bautizallena, gobierno ucubena oraɨnɨ jɨaɨ bitɨmacɨ. Jɨcanotɨmacɨ: —Llofueraɨma, caɨ bautizaja mei, ¿nɨese iitɨcaɨ? ¿Nɨe isoide mare rafuena fɨnoitɨcaɨ? ");
INSERT INTO huuNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Uai ote: —Gobierno facaina omoɨ ɨbataia, comɨnɨmona gobierno llua baɨfemo oñeno. ");
INSERT INTO huuNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Naimɨe dɨne billanona, soldaduaɨ jɨcanotɨmacɨ: —Caɨ bautizaja mei, ¿nɨese iitɨcaɨ? ¿Nɨe isoide mare rafuena fɨnoitɨcaɨ? Uai ote: —Comɨnɨmona rana baɨroñeno. Rɨicɨnodo rana oñeno. Taɨnona llogɨduamona, comɨnɨmona rana oñeno. Omoɨ ucube illa dɨese feiño. Ie baɨfemo ucubena nɨcɨdoñeno. ");
INSERT INTO huuNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Juan llofuiamona naie facaise comɨnɨdɨ Cristo billemo ocuirilla jira, “Juandɨ nɨbaɨ Cristo” raillanona, Juanmo comecɨaɨna facauidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Iena fɨdɨano, Juan llote: —Cristoñedɨcue. Jusiñamui dɨbeimo omoɨ illamona, jɨnui dɨga omoɨna bautizadɨcue. Caɨ baɨfemo faɨtɨmɨe bie facaise biite. Naimɨe cue ifomo meidoite. Jamai bue cue isoilla jira, naimɨena cue canuana uiñoñedɨcue. Naimɨemo omoɨ duia, naimɨedɨ Jusiñamui Joreño omoɨmo itataite. Omoɨ comecɨaɨ iuai omoɨ meidoñenia, omoɨna duere fɨnoite. ");
INSERT INTO huuNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Trigona omoɨ betaia, mare trigona eenotomoɨ. Maraiñede ra oni dotajanona, iena jobaitomoɨ. Ie isoide. Naimɨe rafuena lluanona, naimɨedɨ comecɨaɨ iuaillaɨ meidotɨnona ie Moo illanomo ofitaite; iadedɨ jɨaɨe comɨnɨna duere fɨnoite. Iraimo dotaite. Naie irai jaca duiñede —llote. ");
INSERT INTO huuNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Bie isoidɨcɨnodo comɨnɨmo ie mare rafuena llofueuide. ");
INSERT INTO huuNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Naie facaiseconi Herodedɨ gobernador. Ie ama aɨ ote, ie aɨna illena. Naiñaiñodɨ Herodías. Dɨga jɨaɨe mariñede rafuena fɨnode. Ie muidona Juan naimɨena lletade. ");
INSERT INTO huuNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Maraiñede rafuena Herodes fɨnocana jaillamona, Juan cárcelmo jonetade. ");
INSERT INTO huuNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ailluena comɨnɨna Juan bautizaja facaise, Jesúna jɨaɨ bautizade. Bautizaja mei, Jesúdɨ ie Moo dɨga ñaɨanona, mona bojode. ");
INSERT INTO huuNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ieconi Jusiñamui Joreño ucugɨna eruaɨllano, naimɨe emodomo ana bite. Monamona Jusiñamui llote: —Cue isiruiga Jitodɨo. Ori iobidɨcue. ");
INSERT INTO huuNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesús treinta años illamona, Jesús ie maɨjɨlle rafue taɨnede. “Naimɨedɨ José mɨcorɨ jito” raillano naimɨemo comɨnɨdɨ comecɨaɨna facadɨmacɨ. Josédɨ Elí mɨcorɨ jito. ");
INSERT INTO huuNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elídɨ mɨcorɨ Matat mɨcorɨ jito. Matat mɨcorɨ Leví mɨcorɨ jito. Leví mɨcorɨ Melqui mɨcorɨ jito. Melqui mɨcorɨ Jana mɨcorɨ jito. Jana mɨcorɨ José mɨcorɨ jito. ");
INSERT INTO huuNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José mɨcorɨ Matatías mɨcorɨ jito. Matatías mɨcorɨ Amós mɨcorɨ jito. Amós mɨcorɨ Nahum mɨcorɨ jito. Nahum mɨcorɨ Esli mɨcorɨ jito. Esli mɨcorɨ Nagai mɨcorɨ jito. ");
INSERT INTO huuNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai mɨcorɨ Maat mɨcorɨ jito. Maat mɨcorɨ Matatías mɨcorɨ jito. Matatías mɨcorɨ Semei mɨcorɨ jito. Semei mɨcorɨ José mɨcorɨ jito. José mɨcorɨ Judá mɨcorɨ jito. ");
INSERT INTO huuNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá mɨcorɨ Joana mɨcorɨ jito. Joana mɨcorɨ Resa mɨcorɨ jito. Resa mɨcorɨ Zorobabel mɨcorɨ jito. Zorobabel mɨcorɨ Salatiel mɨcorɨ jito. Salatiel mɨcorɨ Neri mɨcorɨ jito. ");
INSERT INTO huuNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri mɨcorɨ Melqui mɨcorɨ jito. Melqui mɨcorɨ Adi mɨcorɨ jito. Adi mɨcorɨ Cosam mɨcorɨ jito. Cosam mɨcorɨ Elmodam mɨcorɨ jito. Elmodam mɨcorɨ Er mɨcorɨ jito. ");
INSERT INTO huuNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er mɨcorɨ Josué mɨcorɨ jito. Josué mɨcorɨ Eliezer mɨcorɨ jito. Eliezer mɨcorɨ Jorim mɨcorɨ jito. Jorim mɨcorɨ Matat mɨcorɨ jito. Matat mɨcorɨ Leví mɨcorɨ jito. ");
INSERT INTO huuNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Leví mɨcorɨ Simeón mɨcorɨ jito. Simeón mɨcorɨ Judá mɨcorɨ jito. Judá mɨcorɨ José mɨcorɨ jito. José mɨcorɨ Jonam mɨcorɨ jito. Jonam mɨcorɨ Eliaquim mɨcorɨ jito. ");
INSERT INTO huuNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim mɨcorɨ Melea mɨcorɨ jito. Melea mɨcorɨ Mainán mɨcorɨ jito. Mainán mɨcorɨ Matata mɨcorɨ jito. Matata mɨcorɨ Natán mɨcorɨ jito. Natán mɨcorɨ David mɨcorɨ jito. ");
INSERT INTO huuNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","David mɨcorɨ Isaí mɨcorɨ jito. Isaí mɨcorɨ Obed mɨcorɨ jito. Obed mɨcorɨ Booz mɨcorɨ jito. Booz mɨcorɨ Salmón mɨcorɨ jito. Salmón mɨcorɨ Naasón mɨcorɨ jito. ");
INSERT INTO huuNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasón mɨcorɨ Aminadab mɨcorɨ jito. Aminadab mɨcorɨ Aram mɨcorɨ jito. Aram mɨcorɨ Esrom mɨcorɨ jito. Esrom mɨcorɨ Fares mɨcorɨ jito. Fares mɨcorɨ Judá mɨcorɨ jito. ");
INSERT INTO huuNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá mɨcorɨ Jacob mɨcorɨ jito. Jacob mɨcorɨ Isaac mɨcorɨ jito. Isaac mɨcorɨ Abraham mɨcorɨ jito. Abraham mɨcorɨ Taré mɨcorɨ jito. Taré mɨcorɨ Nacor mɨcorɨ jito. ");
INSERT INTO huuNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor mɨcorɨ Serug mɨcorɨ jito. Serug mɨcorɨ Ragau mɨcorɨ jito. Ragau mɨcorɨ Peleg mɨcorɨ jito. Peleg mɨcorɨ Heber mɨcorɨ jito. Heber mɨcorɨ Sala mɨcorɨ jito. ");
INSERT INTO huuNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala mɨcorɨ Cainán mɨcorɨ jito. Cainán mɨcorɨ Arfaxad mɨcorɨ jito. Arfaxad mɨcorɨ Sem mɨcorɨ jito. Sem mɨcorɨ Noé mɨcorɨ jito. Noé mɨcorɨ Lamec mɨcorɨ jito. ");
INSERT INTO huuNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamec mɨcorɨ Matusalén mɨcorɨ jito. Matusalén mɨcorɨ Enoc mɨcorɨ jito. Enoc mɨcorɨ Jared mɨcorɨ jito. Jared mɨcorɨ Mahalaleel mɨcorɨ jito. Mahalaleel mɨcorɨ Cainán mɨcorɨ jito. ");
INSERT INTO huuNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainán mɨcorɨ Enós mɨcorɨ jito. Enós mɨcorɨ Set mɨcorɨ jito. Set mɨcorɨ Adán mɨcorɨ jito. Adándɨ Jusiñamui comuitagamɨe. ");
INSERT INTO huuNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jusiñamui Joreño anamo Jesús illamona, Jordán railla illemona Jesús jaillano, jofue iñenanomo Jusiñamui Joreño naimɨena orede. ");
INSERT INTO huuNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Nainomo cuarenta dɨgarui Taɨfedɨ naimɨena ramo faɨte. Naie facaiseconi Jesús jaca guiñede. Naie facaise fuilla mei, guiñeno illamona, naimɨe aimetaite. ");
INSERT INTO huuNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Jesús aimetaillana Taɨfe uiñuamona, naimɨemo llote: —Jusiñamui Jitodɨodena, naimɨemo llono: “Ore Moo, bie nofɨcɨna llomenicona jaita”. ");
INSERT INTO huuNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesús uai ote: —Iena lloñeitɨcue. Jusiñamui facaina lloraɨma mɨcorɨ iena jaie cuega: “Jɨaɨe rafuedɨ llomenico guilla baɨfemo faɨte”. ");
INSERT INTO huuNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ie mei a ite anedumo Taɨfe Jesúna uillano, dallu illanona, naimɨemo nana naɨraɨaɨna acatate. ");
INSERT INTO huuNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","Llote: —Nana bie naɨraɨaɨ cue anamo ite. Iena cue iacagamɨemo itataredɨcue. Cuena o sedajamona, iobillacɨnona cuemo o fecaia, nana bie naɨraɨaɨ omo fecaitɨcue. Bie naɨraɨaɨ illaɨmana jaitɨo. ");
INSERT INTO huuNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jesús uai ote: —Dama ite. Ona sedañeitɨcue. Moisés mɨcorɨ jaie cuega: “Caɨ Nama Jusiñamuina seda. Dama naimɨemo iobillacɨnona feca”. ");
INSERT INTO huuNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ie mei Jerusalémo Jusiñamui jofo muidomo Taɨfe Jesúna uite. Raite: —Jusiñamui Jitodɨodena, enɨruemo mai ana uai. ");
INSERT INTO huuNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","11","David mɨcorɨ ona jaie cuega: Ona eenollena Jusiñamuidɨ ie jaɨenisaɨmo lloite. Enɨruemo o uaiñellena, o abɨ bofedaiñellena, ona feiñoitɨmacɨ cuega. Naimɨe lloga uai suillena, bie jofo muidomona mai ana uai. Naimɨe ie lloga uaina fɨnorede; ia iena cue uiñollena, mai ana uai. ");
INSERT INTO huuNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jesús uai ote: —Dama ite. Ana uaiñeitɨcue. Ero, ie comɨnɨmo Moisés mɨcorɨ jaie cuega: “Caɨ Nama Jusiñamuina facacɨñeno”. Naimɨe cuena raise eenuana jai uiñotɨcue. Jamai ebena naimɨena facacɨñeitɨcue. O lluana fɨnoñeitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Taɨfe naimɨena ramo faɨa mei, naimɨemona ie jitaille dɨnori oni jaide. ");
INSERT INTO huuNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jusiñamui Joreño naimɨemo illamona, Galileamo Jesús abɨdo jaide. Nana naie enɨruemo naimɨe mamecɨ soride. ");
INSERT INTO huuNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ailluena judíuaɨ ofiracuaɨmo naimɨe llofueuide. Iena cacajanona, comɨnɨ: “Naimɨe llofuiacɨno mare” raitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Macarillamona, Nazaretmo naimɨe jaide. Navui nainomo naimɨedɨ sairide. Naimɨe jaisoilla isoi, sábadomo nainomo ite ofiracomo jaide. Jaie cuegafuiaɨna ado facallena, naimɨe a naidadate. ");
INSERT INTO huuNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Naie lloraco nama mullaɨmadɨ Isaías mɨcorɨ jaie cuegafuiaɨ jai ferɨnoga rabe naimɨemo fecade. Iena oni suiñocaida, bie rafuena baillanona facade: ");
INSERT INTO huuNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","19","Jusiñamui Joreño cuemo ite. Dueredɨnomo mare rafuena llollena, cuena fetode. Taɨfe anamo ailluena comɨnɨ illa jira, Jusiñamui naimacɨna jillotaiacana uiñoñedɨmacɨ. Jusiñamui rafuena ailluena comɨnɨ uiñoñena jira, naimɨe illanomo rillena uiñoñedɨmacɨ. Jeacɨno anamo naimacɨ illa jira, Jusiñamui naimacɨna jillotaiacana uiñoñedɨmacɨ. Naimɨe naimacɨna duenaillana birui uiñuana jitaide. Naimacɨmo mare rafue llollena, cuena jai oretate. ");
INSERT INTO huuNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Naie rafue facaja fuillamona, cuegafuiaɨ abɨdo fecade. Naimacɨna llofuellena, dane ana raɨde. Nana nainomo ite comɨnɨ naimɨemo eo eruaɨdɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Iemei naimɨe naimacɨna llofuete. Raite: —Omoɨ como cacaja cuegafuiaɨ omoɨ motomo jai suide. Cuena ñaɨte. ");
INSERT INTO huuNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Naimɨe lluana comɨnɨ cacajano, coninɨna raitɨmacɨ: —Naimɨe fue mare. Naimɨe marena llofuete. —Iemona raijicaillamona, coninɨri raitɨmacɨ—, Naimɨedɨ jamai José jito. ¿Nɨese naie rafue birui suide? ");
INSERT INTO huuNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Iena uiñuamona, Jesús dɨnena llote: —Cue lluana ɨɨnoñedomoɨ. Comecɨaɨna facadomoɨ: “Capernaumo naimɨe siño fɨnoca rafuena fɨdɨdɨcaɨ. Siño rafuena caɨ motomo naimɨe jɨaɨ fɨnoia, naimɨena ɨɨnoitɨcaɨ. ‘Ua médico duia, ie abɨna dama jillotarede’ caɨ einamacɨ raisoidɨmacɨ. Ie isoide. Naimɨe llua isoi naimɨe ia, siño rafue caɨ motomo fɨnorede” comecɨaɨna facadomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Uanaicɨnona omoɨmo lloitɨcue. Naimɨe comɨnɨ naɨraɨmo Jusiñamui facaina lloraɨma ia, ie comɨnɨ naimɨe uaina feiñoiacasɨñede. Iena jamaisɨte. Ie isoide. Cue naɨraɨmo cue illa jira, cue uaina ɨɨnoñedomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Jaie ie isoide. Elías facaiseconi daje amani años abɨmo atomonado nocɨ deiñede. Aime guitɨmacɨ. Naie facaiseconi bie enɨruemo caɨ comɨnɨ dɨne ailluena fecɨñuaɨ itɨmacɨ; iadedɨ omoɨ jaiagaɨ Jusiñamui uaina ɨɨnoñedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Jusiñamuidɨ Elíana caɨ comɨnɨ dɨne oreñede; iadedɨ jɨaɨe enɨruemo ite fecɨño dɨne naimɨena orede. Sarepta railla naɨraɨmo orede. Sidón railla enɨruemo naie naɨraɨ ite. Caɨ comɨnɨñede fecɨñomo orede. ");
INSERT INTO huuNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Jɨaɨe rafuena lloitɨcue. Eliseo mɨcorɨdɨ Jusiñamui facaina jaie llote. Eliseo mɨcorɨ facaiseconi bie enɨruemo dɨga efonaitɨno ite; iadedɨ naimacɨmona Jusiñamui buna jillotañede. Omoɨ jaiagaɨ Jusiñamui uaina ɨɨnoñena jira, Eliseo mɨcorɨ duidɨnona jillotañede. Naie facaiseconi dama Naamán mɨcorɨna jillotate. Caɨ comɨnɨmo naimɨe duiñede; ia Siria railla enɨruemo duide. Ie isoidomoɨ. Cue uaina ɨɨnoiacaiñedomoɨ —llote. ");
INSERT INTO huuNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Jesús lluana cacajano, naie ofiracomo itɨno eo icɨritɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Naidacaillano, naimɨena jino uitɨmacɨ. Naie illanodɨ iconɨmo ite. Nainomo naimɨena uillanona, iconɨmona naimɨena ana dotaacadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Naimɨena meineiacadɨmacɨ; iadedɨ naimacɨ motomo naimɨe jaillanona, naimacɨmona naimɨe jillobillano oni jaide. ");
INSERT INTO huuNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jesús Capernaumo jaide, Galilea railla enɨruemo ite. Nainomo naimɨe ia, sábadoruimo judíuaɨ ofiracomo jaide. Nainomo llofuete. ");
INSERT INTO huuNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Illaɨma uai isoi naimɨe llofuia jira, nainomo ite comɨnɨ naimɨe llofuiamona raijicaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Janaba anamo illamɨe nainomo ite. Jesús llofuiana cacaita, Janabadɨ ɨimana ado cuirioitate: ");
INSERT INTO huuNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—Odɨ Nazaret ie Jesús. ¿Bue ñeiacadɨo caɨ dɨga? Caɨna duere fɨnuaɨbidɨo. Ona uiñotɨcue. Odɨ Jusiñamui ie Mare Fetocamɨedɨo. ");
INSERT INTO huuNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jesús naimɨena lletade: —Llɨɨcai. Naimɨemona oni jai. —Iena cacajanona, naimacɨ motomo Janaba ɨimana ana dotade; ia naimɨedɨ bofedaiñede. Ie mei Janaba naimɨemona oni jaide. ");
INSERT INTO huuNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Iena cɨuanona, nana nainomo itɨno raijicaidɨmacɨ. Coninɨri siadotɨmacɨ: —¿Nɨe isoide Jesús uai? Janabamo naimɨe llua mei, ɨimamona Janabadɨ oni jaide. ");
INSERT INTO huuNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Jesús fɨnoca rafue muidona, naimɨe mamecɨdɨ nana naie enɨruemo soride. ");
INSERT INTO huuNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ofiracomona Jesús jaillanona, Simón Pedro jofomo jaide. Ie facaise Simón jɨfaiño duide. Abɨna cuaride. Naiñaiñona jilloitallena, nainomo itɨno Jesúmo jɨcanote. ");
INSERT INTO huuNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Naiñaiño dɨne Jesús jaillanona, ie uai lluamona, naie duicodɨ oni jaide. Ieconi naiñaiño jillode. Abɨ cuariñede. Naidacaillanona, guille fɨnuanona, ie jofomo itɨnona ecade. ");
INSERT INTO huuNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Nairuido jitoma ana itemo, comɨnɨ ailluena duidɨnona Jesús dɨne atɨdɨmacɨ. Dɨga duicuaɨ illanona atɨdɨmacɨ. Naimacɨna jetajamona, naimacɨna jillotate. ");
INSERT INTO huuNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Jananɨaɨna jɨaɨ oni oretajano, jananɨaɨ dɨnena raite: —Odɨ Jusiñamui Jitodɨo. —Naimɨena naimacɨ uiñua jira, Jesús naimacɨ ñaɨana rairuide. Naimɨedɨ Jusiñamui Jitona uiñotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ie areruido jitɨramo jofue iñenanomo Jesús jaide; iadedɨ comɨnɨ naimɨena jenuaidɨmacɨ. Baillanona, naimacɨ motomona naimɨe jaiñellena jɨcanotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Naimacɨmo llote: —Jɨaɨe naɨraɨmo cue mare rafuena lloiacadɨcue. Naimɨe anamo comɨnɨ illana Jusiñamui jitailla jira, naimacɨmo iena lloiacadɨcue. Ie mare rafuena llollena, Jusiñamui cuena orede. Oni jaitɨcue. Omoɨ dɨga fɨebiñeitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ie mei Judeamo ite ofiracuaɨmo Jesús llocana jaide. ");
INSERT INTO huuNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Jɨaɨruido Genesaret railla jorai fuemo Jesús ia, ailluena comɨnɨ naimɨe dɨne bitɨmacɨ. Ie rafue raise cacaillena, coninɨ oni ñuicocana naimɨe ecɨmo bitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ie facaise jorai fuemo Jesús mena sɨjɨde botena cɨode. Naimacɨ lloijina naimacɨ jocua jira, naie botemo lloiji faɨraɨnɨ iñede. ");
INSERT INTO huuNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Comɨnɨ ie llofuiacɨnona raise cacaillena, Jesús daje botemo jaide. Naie bote namadɨ Simón Pedro. Naie bote joraimo janore baɨ ñuitallena Simómo jɨcanote. Botemo ana raɨta, botemona comɨnɨna llofuete. ");
INSERT INTO huuNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Llofuia mei, Simómo llote: —Aforedɨnomo jai. Nainomo omoɨ lloijina faɨno. ");
INSERT INTO huuNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simón uai ote: —Maestro, cue nabaiñɨaɨ dɨga namona naɨo lloiji faɨtɨcaɨ; iadedɨ jaca buena oñedɨcaɨ. ¿Nɨese ja oitɨcaɨ? Iadedɨ o llua jira, lloijina faɨtɨcue. ");
INSERT INTO huuNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Iena naimacɨ faɨa mei, ailluena llɨcɨaɨna jiitatɨmacɨ. Ie jira naimacɨ lloiji cuaranoiacade. ");
INSERT INTO huuNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Iena cɨuano, onollɨ dɨga imacɨ nabaiñɨaɨna uaidote, naimɨena naimacɨ canollena. Naimacɨ canuaɨbilla mei, llɨcɨaɨna naga bote oruitate. Eo oruilla jira, buiacade. ");
INSERT INTO huuNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Iena cɨuano, Simón Pedro Jesúmo iobillacɨno fecallena, caiñɨcɨ ɨfodo raɨnadate. Raite: —Odɨ siño Jitodɨo; ia cue jamai bue isoilla jira, cuemona oni jai. Jeacɨnona fɨnouidɨmɨedɨcue. ");
INSERT INTO huuNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ailluena llɨcɨaɨna naimacɨ ua jira, naimacɨ raijicaillamona, iena naimɨe llote. ");
INSERT INTO huuNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Naimɨe nabaiñɨaɨmona Zebedeo jito iaɨmaiaɨ ite. Juan dɨga Jacobo iaɨmaiaɨ. Simómo Jesús llote: —Cuena jacɨruiñeno. Llɨcɨaɨna birui ocabitomoɨ; iadedɨ cue dɨbeimo naimacɨ illena, biruimona comɨnɨna oitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Enɨruemo sɨjɨano, naimacɨ raruiaɨ faɨnonocaida, Jesús dɨga jaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jɨaɨruido Jesúdɨ jɨaɨe naɨraɨmo ia, efonaitɨmɨe naimɨe dɨne bite. Naimɨe eo fodo jaide. Jesúna naimɨe cɨuano, naimɨena raise uaiduamona, ana bɨtadate. Llote: —Maestro, o jitaiadedɨ, cuena jillotaredɨo. ");
INSERT INTO huuNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jesús ie onollɨ oni ñuitajanona, naimɨena jetade. Raite: —Ona jillotaiacadɨcue. Mai o jillo. —Ieconi jillode. ");
INSERT INTO huuNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jesús naimɨemo llote: —Omo suide rafue jaca bumo lloñeno; iadedɨ Jerusalémo Jusiñamui jofomo Jusiñamui dɨga ñaɨraɨmamo o abɨna acatajai. O jillua jira, Jusiñamuimo Moisés mɨcorɨ jaie lloga rana feca Iemona comɨnɨ o jilluana uiñoitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Iese Jesús naimɨemo llote; iadedɨ Jesús fɨnoca rafue llocana eo uite. Ie muidona naimɨe lluana cacaillena, duidɨnona Jesús jillotallena, ailluena comɨnɨ naimɨe dɨne bitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Bitɨmacɨ; iadedɨ Jusiñamui dɨga ñaɨllena, jofue iñenanomo Jesús jaide. ");
INSERT INTO huuNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Jɨaɨruido naimɨe llofueia, dɨga comɨnɨ naimɨe illa jofomo bitɨmacɨ. Fariseuaɨ railla comɨnɨ bitɨmacɨ. Moisés mɨcorɨ llogacɨnuaɨna llofueraɨnɨ bitɨmacɨ. Galileamona dɨga naɨraɨmona bitɨmacɨ. Judeamona bitɨmacɨ. Jerusalémona bitɨmacɨ. Jusiñamui uaido Jesús naimɨe dɨne bite duidɨnona jillotate. ");
INSERT INTO huuNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ie facaise ie bɨiramo bɨide tɨsitaitɨmɨena Jesús dɨne damɨerie atɨdɨmacɨ; ");
INSERT INTO huuNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","iadedɨ naimacɨ uillɨfo iñena jira, ailluena comɨnɨ illa jira, riñedɨmacɨ. Naie jofo bɨbanilla jira, jofo emodomo a jaidɨmacɨ. Jofo beicɨmo ite tɨdabacuido a jaidɨmacɨ. Jofo emodo econocaida ifodo naimɨena ie bɨiramo bɨide dɨga, comɨnɨ motomo Jesús ecɨmo ana ñuitadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Iena Jesús cɨuanona, tɨsitaitɨmɨe jilluana naimacɨ ɨɨnuana Jesús uiñote. Tɨsitaitɨmɨemo llote: —Jadi, o jeacɨnona cue feitaja jira, iena oni jai dotadɨcue. Ie facai ɨbana jai oñeitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Nainomo itɨnomona Moisés mɨcorɨ llogacɨnona llofueraɨnɨ itɨmacɨ. Fariseuaɨ jɨaɨ itɨmacɨ. Comecɨaɨna facadɨmacɨ: “Naimɨe Jusiñamuina jeare ñaɨte. Dama Jusiñamui jeacɨnona dotarede. Bimɨe Jusiñamuiñede; ia Jusiñamui ifomo iacade”. ");
INSERT INTO huuNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Naimacɨ comecɨaɨ facajacɨnona Jesús uiñuanona, naimacɨmo jɨcanote: —¿Bue ñellena omoɨ comecɨaɨna iese facadomoɨ? ");
INSERT INTO huuNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Bimɨemo: “O jeacɨnona jai oni dotadɨcue” cue lloia, cue uai siñonana uiñoñeitomoɨ; ia bimɨemo: “Mai naidacaillanona macari” cue lloia, cue uai siñonana uiñoitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Monamona jaie cue billanona, ɨimana jaidɨcue. Ie jira jeacɨno oni dotaja uai cuemo ite. Iena omoɨ uiñollena, tɨsitaitɨmɨemo lloitɨcue: “Mai naidacai. O bɨira ferɨanona, o jofomo mai jai”. ");
INSERT INTO huuNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Iese naimɨe raillamona, tɨsitaitɨmɨe jillode. Ieconi naimacɨ motomo naimɨe naidaide. Ie bɨira ferɨano, Jusiñamuimo iobillacɨno fecajano, ie jofomo jaide. ");
INSERT INTO huuNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Nana naiena cɨodɨno eo raijicaidɨmacɨ. Iemona Jusiñamuimo iobillacɨnona fecadɨmacɨ. Eo raijicaillamona, raitɨmacɨ: —Bie isoide siño comena jaca cɨoiñedɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Jesús jino macarillano, gobierno facaina ucube oraɨmana cɨode. Naimɨe mamecɨ Leví. Ie ucubena ouillanomo raɨde. Jesús naimɨemo llote: —Cue llofuegamɨena o jaillena, cue dɨga bi. ");
INSERT INTO huuNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Naidacaida, Jesús dɨga jaillanona, ie maɨjɨana faɨnonocaide. ");
INSERT INTO huuNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Naillɨ ie jofomo Leví aillue rafuena fɨnode, Jesús iena. Dɨga ucube oraɨnɨ guisaɨbitɨmacɨ. Dɨga jɨaɨe comɨnɨ jɨaɨ guisaɨbitɨmacɨ. Jesús dɨga danomo guitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Nainomo fariseuaɨ comɨnɨdɨ, Moisés mɨcorɨ llogacɨno llofueraɨnɨ dɨga, jamai bitɨmacɨ. Jesúna cɨuanona, ie llofueoicaiganomo jɨcanotɨmacɨ: —¿Bue ñellɨ ucube oraɨnɨ dɨga guitomoɨ? Maraiñede comɨnɨ dɨga guitomoɨ. Moisés mɨcorɨ llogacɨnodo ucube oraɨnɨ raise jaiñenamona, naie isoidɨno dɨga fariseuaɨ comɨnɨ nabairiñena jira, iese jɨcanotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesús iena cacajano, llote: —Ecairedɨno médicona jitaiñedɨmacɨ; iadedɨ duidɨnodɨ médicona jitaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Jusiñamui dɨbeimo mareuidɨnona uaɨbiñedɨcue; iadedɨ maraiñedɨnona uaɨbitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Naie facaise fariseuaɨ dɨnena Jesúmo llote: —Caɨ einamacɨ llua isoi, Jusiñamuina caɨ raise iobitallena, guiñenaruillaɨ illa facaiseconi guiñedɨcaɨ. Jusiñamuimo jɨɨcabidɨcaɨ. Caɨ jeacɨno facaina sunaicabitɨcaɨ. Caɨ einamacɨ rafuedo Juan Bautista llofueoicaigano jaidɨmacɨ. Caɨ llofuegano iedo jɨaɨ jaidɨmacɨ; iadedɨ o llofueoicaigano jaca guitɨmacɨ. ¿Bue ñellena caɨ einamacɨ rafuedo jaiñedɨmacɨ? ");
INSERT INTO huuNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesús uai ote: —Jɨaɨe rafuedo iena lloitɨcue. Coniruedɨ ie aɨna uarui ia iobilla jira, ie nabaiñɨaɨ sunaiñedɨmacɨ. Iobillamona guitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Jɨaɨruido jai aɨreiacade conirue naimacɨ dɨga iñenia, naimacɨ comecɨ sunaillamona, naimacɨ jitaia, guiñenaruillaɨdɨ iite. Ie isoide. Cue comɨnɨ dɨga birui cue illa jira, iocɨre itɨmacɨ. Ɨco cue jaille mei, sunaitɨmacɨ. Ie muidona birui cue llofueoicaigano guicabitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jɨaɨe rafuedo iena lloitɨcue: Nia jocoñega comue ɨniroidɨ jacaɨe ɨniroimo jɨlliñega. Jɨlliadɨ jocua mei, comue ɨniroi jacaɨe ɨniroimona fo llirite. Eo fodo cuararite. Jai maraiñeno cɨoite. ");
INSERT INTO huuNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Jacagomona fɨnoca bolsa como fɨnoca vino joneñega. Jonegadena, maɨriñena jira, sɨrillamona igoɨ raɨre cuararite. Vino faɨfite. Igoɨ jɨaɨ faɨfite. ");
INSERT INTO huuNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Como fɨnoca vino comogomo jonelle. Iemei iena faɨfiñeite. ");
INSERT INTO huuNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Navui fɨnoca vino jirua mei: “Navui fɨnoca vino nia mare” raillamona, como fɨnoca vino buna jiroacaiñede. Ie isoide. Omoɨ einamacɨ rafue ifomo jɨaɨe rafue birui ite. Iena omoɨmo llocabitɨcue. Iedo jaidɨcaɨ; ia omoɨ einamacɨ rafuemo omoɨ fɨbilla jira, jɨaɨe rafuedo birui jaiacaiñedomoɨ —llote. ");
INSERT INTO huuNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Jɨaɨruido sábadoruimo Jesús, ie llofueoicaigano dɨga, trigo illa illɨ motodo joide naɨsona jaide. Ie llofueoicaigano trigona tɨjɨano, golluano, guicana jaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Dajerie fariseuaɨ iena cɨuano, llotɨmacɨ: —Rairuica rana fɨnosɨte. Moisés mɨcorɨ rairuilla jira, sábadoruimo maɨjɨnidɨcaɨ; iadedɨ trigona naimacɨ tɨjɨamona, caɨmona jai maɨjɨdɨmacɨ. Caɨmona jeacɨnona jai fɨnodɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ie llofueoicaiganona rɨiduano, Jesús uai ote: —Cuemona jeacɨno fɨnoñedɨmacɨ. David mɨcorɨ jaie fɨnoca rafuemo omoɨ comecɨaɨ raise facañedomoɨ. David mɨcorɨ guille iñenia, naimɨe aimetaia, ie nabaiñɨaɨ dɨga Jusiñamui jofomo fo jaide. ");
INSERT INTO huuNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Jusiñamuimo fecaca llomenicona uanona, guitɨmacɨ. Jamai bue isoidɨno naie llomenicona guillana Jusiñamui rairuide. Danɨ Jusiñamui dɨga ñaɨraɨnɨ iena guiredɨmacɨ. David mɨcorɨ iena guite; ia Jusiñamui naimacɨna duere fɨnoñede. ");
INSERT INTO huuNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Monamona cue billamona, ɨimana jaidɨcue. Ie jira sábadoruimo comɨnɨ fɨnolle rafuena rairuiredɨcue. Nairuimo fɨnoñelle rafuena jɨaɨ rairuiredɨcue. Ie jira nairuimo cue jitailla rafuena fɨnoredɨcue. ");
INSERT INTO huuNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Jɨaɨe sábadoruimo judíuaɨ ofiracomo Jesús jaillanona, llofuete. Ie facaise nainomo nabellɨmo ɨdɨsarodɨmɨe ite. ");
INSERT INTO huuNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Moisés mɨcorɨ llogacɨnona llofueraɨnɨ, fariseuaɨ dɨga, Jesúmo eruaɨdɨmacɨ, sábadoruimo Jesús naimɨena raabaca ie segoitai. Iena Jesús fɨnoia, naimacɨmona sábadoruimo naimɨe jai maɨjɨa jira, naimɨena llogɨdoiacadɨmacɨ. Naimacɨmona sábadoruimo bu maɨjɨia, jeacɨnona fɨnode. ");
INSERT INTO huuNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Naimacɨ comecɨaɨna facajacɨnona Jesús uiñuamona, onollɨna ɨdɨsarodɨmɨemo llote: —Cue ecɨmo naidada. —Iemei Jesús ecɨmo naidadate. ");
INSERT INTO huuNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Jesús nainomo itɨnomo jɨcanote: —¿Nɨe isoide rafue sábadoruimo fɨnuadena mare? Bimɨe birui cue jillotaiadedɨ, birui mare rafuena fɨnodɨcue. Cuena birui omoɨ meineiadedɨ, birui maraiñede rafue fɨnodomoɨ. Sábadoruimo ¿nɨe isoide rafue fɨnuana rairuidomoɨ? ");
INSERT INTO huuNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Naimacɨmo eruaɨllanona, duidɨmɨemo llote: —O onollɨ mai oni ñuita. —Iena ñuitajanona jillode. ");
INSERT INTO huuNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Nainomo itɨno iena cɨuanona, eo icɨritɨmacɨ. —¿Nɨese Jesúna nɨbaɨitɨcaɨ? —naiemona coninɨri siadotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Nairui aneduaɨmo Jesús jaide, Jusiñamui dɨga ñaɨllena. Namona naɨo jɨɨde. ");
INSERT INTO huuNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Monaidemo, ie llofueganona naimɨe dɨne uaidote. Naimacɨmona doce dɨgamɨena fetode. Naimɨe dɨga icabillena, naimacɨna naimɨe facaina lloraɨnɨna naimacɨ jaillena, naimacɨna fetode. ");
INSERT INTO huuNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Iese mamecɨredɨmacɨ: Simón; naimɨe mamecɨ jɨaɨcɨdɨ Jesús jɨtaca Pedrona. Andrés; naimɨedɨ Pedro ama. Jacobo, Juan, Felipe, Bartolomé, ");
INSERT INTO huuNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, Tomás, jɨaɨe Jacobo; naimɨedɨ Alfeo jito. Jɨaɨe Simóna fetode. Naimɨedɨ cananista comɨnɨ facaisemo duide. ");
INSERT INTO huuNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas; naimɨedɨ Jacobo jito. Judas Iscariote mɨcorɨ; naimɨedɨ Jesúna gaɨtatatɨmɨe. ");
INSERT INTO huuNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Aneduaɨmona sɨniaɨdɨnomo ie doce llofueoicaigano dɨga Jesús bite. Ie jɨaɨe llofuegano naimɨe dɨne bitɨmacɨ. Ailluena jɨaɨe comɨnɨ bitɨmacɨ. Nana Judeamona bitɨmacɨ. Jerusalémona bitɨmacɨ. Tiromona bitɨmacɨ. Sidómona bitɨmacɨ. Tiro monaillai fuemo ite. Sidón monaillai fuemo jɨaɨ ite. Naimɨe lluamo cacareillena bitɨmacɨ. Naimacɨ duicomona jɨaɨ jilloiacadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Jananɨaɨ anamo itɨnomona Jesús jananɨaɨna oni orede. ");
INSERT INTO huuNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Nana comɨnɨ naimɨena jetaacadɨmacɨ. Naimɨemo siño uai illa jira, naimɨena jetajamona, naimacɨ duicomona jillodɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ie llofueganomo eruaɨllanona, Jesús llote: —Naimɨe anamo omoɨ jai illamona, Jusiñamui omoɨna sedaacana rafuena omoɨna llofueitɨcue. Naimɨena jitaidomoɨna, omoɨna sedaite. Comecɨaɨna facadomoɨ: “Jusiñamui jitaillacɨnona danɨ fɨnonidɨcaɨ; ia Jusiñamui caɨna canuamona, iena fɨnoitɨcaɨ”. Naimɨe comɨnɨ omoɨ illamona, naimɨe omoɨna canoite. Iemona caɨmare iitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Naimɨe jitaillacɨno omoɨ fɨnuamona, Jusiñamui omoɨna sedaite. Naimɨedɨ mare rafuena omoɨ fɨnuana canoite. Iemona caɨmare iitomoɨ. Omoɨ sunaia, Jusiñamui omoɨna sedaite. Ailluena comɨnɨ jeacɨno fɨnocana jaidɨmacɨ. Iena uiñuamona, sunaitomoɨ. Naie isoidɨno omoɨ illamona, Jusiñamui omoɨ comecɨaɨna ocuiñotaite. Iemona iocɨre iitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Cuemo omoɨ duia, duere sefuitomoɨ. Jɨaɨe comɨnɨ omoɨna enoitɨmacɨ. Omoɨna oni dotaitɨmacɨ. Omoɨna jeare ñaɨtɨmacɨ. Cuemo omoɨ duilla jira, omoɨna jamaitɨmacɨ; ia Jusiñamui omoɨna caɨmare itataite. ");
INSERT INTO huuNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Omoɨ isoi omoɨ jaiagaɨmona Jusiñamui facaina lloraɨnɨ mɨcorɨaɨ jaie duere sefuidɨmacɨ. Iena omoɨ uiñuamona, monamo Jusiñamuimona ailluena ɨbana ɨco omoɨ feiñua jira, birui omoɨ duere sefuia, iocɨre omoɨ jai. ");
INSERT INTO huuNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Iese iitomoɨ; ia Jusiñamuina jitaiñedɨno ɨco duere sefuitɨmacɨ. Comecɨaɨna facadɨmacɨ: “Jusiñamuina jitaiñedɨcaɨ. Marena birui itɨcaɨ. Nana caɨ comecɨaɨ jitaillacɨno birui caɨmo ite”. Iese birui itɨmacɨ; ia Jusiñamui naimacɨna ɨco duere fɨnoite. ");
INSERT INTO huuNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Jusiñamuimona buena birui jitaiñedɨno ɨco duere sefuitɨmacɨ. “Nana caɨ comecɨaɨ jitailla rafue caɨmo birui illa jira, Jusiñamuimona buena jitaiñedɨcaɨ” raitɨmacɨ. Iese birui itɨmacɨ, ia Jusiñamui naimacɨna ɨco duere fɨnuamona, buenitɨmacɨ. “Caɨ comecɨaɨna iocɨre itatallena, Jusiñamuina jitaiñedɨcaɨ” damɨerie birui raitɨmacɨ. Naimacɨ jeacɨno facaina sunaiñedɨmacɨ. Birui ite rafuena ebiruitɨmacɨ. Iese birui itɨmacɨ; ia Jusiñamui naimacɨna ɨco duere fɨnuamona, sunaitɨmacɨ. Eeitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Naimacɨri iobillamona, omoɨ jaiagaɨdɨ Jusiñamui facaina lloraɨnɨna abɨ caitadɨnona marena ñaɨtɨmacɨ. Damɨerie birui daje isoidɨmacɨ. Jusiñamuina iobitaiacaiñedɨmacɨ; ia comɨnɨna iobitaiacadɨmacɨ. Iemona comɨnɨ naimacɨna marena ñaɨtɨmacɨ; ia Jusiñamui naimacɨna ɨco duere fɨnoite. ");
INSERT INTO huuNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Jesús llote: —Cue lluana cacajamona, iena ɨɨno. Ɨɨnuamona omoɨna enoidɨnona isirui. Naimacɨna cano. ");
INSERT INTO huuNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Omoɨ jeare ñaɨtɨnona marena ñaɨno. Omoɨna jeare fɨnodɨno facaina Jusiñamuimo omoɨ jɨɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Omoɨ cacaɨna bu dutaiade, ɨba oñeno; iadedɨ enefebeimo dobaida, enefebeimo jɨaɨ dutallena. Omoɨ ɨniroina bu baɨroiacania, omoɨmo naimɨe nia jɨcañenia, naimɨe jitailla ɨniroi baɨfemo naimɨemo feca. ");
INSERT INTO huuNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Omoɨmo ite rana bu jɨcaia, iena caidɨñeno feca. Omoɨmona rana bu baɨroia, iena abɨdo jɨcañeno. ");
INSERT INTO huuNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Jusiñamui jitaillacɨnona omoɨ fɨnuamona, jɨaɨe comɨnɨna marena fɨno. Jɨaɨe comɨnɨ omoɨna fɨnuana omoɨ jitailla isoi, naimacɨna fɨno. Naimacɨ omoɨna marena fɨnuana omoɨ jitaia, naimacɨna marena fɨno. Naimacɨ omoɨna maraiñeno fɨnuana omoɨ jitaia, naimacɨna ie isoi maraiñeno fɨno. O fɨnoacaga ra isoi jɨaɨe comɨnɨmo fɨno. ");
INSERT INTO huuNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Naimɨe comɨnɨna omoɨ illamona, nana comɨnɨ daje isoi isirui. Omoɨna isiruitɨnona omoɨ isiruia, mare; iadedɨ omoɨna gaɨñenanona omoɨ isiruiñenia, Jusiñamui omoɨna: “Mare” raiñeite. Maraiñede rafuena fɨnoraɨnɨ naimacɨna isiruitɨnona isiruitɨmacɨ. Nana comɨnɨna omoɨ isiruiñenia, maraiñede rafuena fɨnoraɨnɨ baɨfemo faɨñedomoɨ. Naimacɨ isoi itomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Naimɨe comɨnɨna omoɨ illamona, nana comɨnɨ daje isoi cano. Omoɨna canodɨnona omoɨ canoia, mare; iadedɨ omoɨna canoñedɨnona omoɨ canoñenia, Jusiñamui omoɨna: “Mare” raiñeite. Maraiñede rafuena fɨnoraɨnɨ naimacɨna canodɨnona canodɨmacɨ. Nana comɨnɨna omoɨ canoñenia, maraiñede rafuena fɨnoraɨnɨ baɨfemo faɨñedomoɨ. Naimacɨ isoi itomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Naimɨe comɨnɨna omoɨ illamona, nana comɨnɨmo daje isoi rana feca. Omoɨmo ra fecadɨnomo rana omoɨ fecajia, mare; iadedɨ omoɨmo rana fecañedɨnomo rana omoɨ fecañenia, Jusiñamui omoɨna: “Mare” raiñeite. Maraiñede rafuena fɨnoraɨnɨ naimacɨmo rana fecadɨnomo rana jɨaɨ fecadɨmacɨ. Nana comɨnɨmo rana omoɨ fecañenia, maraiñede rafuena fɨnoraɨnɨ baɨfemo faɨñedomoɨ. Naimacɨ isoi itomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","36","Omoɨna gaɨñedɨnona isirui. Naimacɨmo mare rafuena fɨno. Naimacɨmo rana jamai feca. Naimacɨmona ɨba uamo ocuiriñeno; ia Jusiñamui omoɨ raise ɨbaite. Jusiñamui maraiñedɨnona canocabide. Naimɨeri iobiñedɨmacɨ; ia naimacɨna canocabide. Naimacɨna duenaicabite. Ie jira maraiñedɨnona omoɨ duenai. Naimɨe isoi omoɨ illamona, maraiñedɨnodɨ naimɨe comɨnɨna omoɨ illana uiñoitɨmacɨ. Jusiñamuidɨ comɨnɨna duenailla isoi, comɨnɨna omoɨ jɨaɨ duenai. ");
INSERT INTO huuNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Jesús llote: —Duenaillacɨnona nia llofueiacadɨcue. Jɨaɨe comɨnɨna mameriñeno. Jɨaɨe comɨnɨna omoɨ mameria, omoɨmo ite maraiñede rafue facaina Jusiñamui omoɨna duere fɨnoite. Omoɨmo maraiñede rafuena bu fɨnoia, iena feita. Iena omoɨ feitañenia, Jusiñamui omoɨmo ite maraiñede rafuena feitañeite. ");
INSERT INTO huuNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Jɨaɨe rafuedo iena lloitɨcue. Rana omoɨ fecaia, iena raise omoɨ gaɨeia, ɨco ɨbana omoɨ oia, raise gaɨecana feiñoitomoɨ. Ie isoide. Jɨaɨnomo maraiñede rafuena fɨnoñeno; ia naimacɨna duenaillamona, naimacɨmo rana jamai feca. Iena raise feca. O fecaja dɨese Jusiñamuimona eo raise ɨbana feiñoitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Naimacɨna iena nia llofuiamona, naimacɨmo Jesús jɨaɨe rafuena llote: —Cue comɨnɨna omoɨ illamona, bie rafuena cacarei. Uanaicɨnodo omoɨ jaiñenia, uisɨnidɨmɨe isoi iitomoɨ. Uisɨnidɨmɨe jɨaɨe uisɨnidɨmɨena ɨfonide. Ifo iade, nagamaiaɨ dafomo uaidɨiaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Fueotɨmɨe ie llofueraɨma baɨfemo uaiñede; iadedɨ naimɨe raise fueoia, ie llofueraɨma isoi jaite. Raise fueollena, cue uaimo cacarei. ");
INSERT INTO huuNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Omoɨ ecɨmo itɨmɨemo janore maraiñedɨcɨno illana omoɨ uiñoia, iemo comecɨna facañeno; iadedɨ omoɨmo ailluena ite maraiñedɨcɨnomo nano omoɨ comecɨna faca. ");
INSERT INTO huuNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Omoɨmo maraiñedɨcɨno illamona, ¿nɨese omoɨ ecɨmo itɨmɨena mameritomoɨ? Omoɨmo ite maraiñedɨcɨnomo omoɨ comecɨna facaacaiñena jira, maredɨnona abɨ caitadɨnodomoɨ. Omoɨ comecɨaɨna nano raise fɨno. Iemei omoɨ ecɨmo itɨmɨena canorenitomoɨ. Naimɨe comecɨna raise canorenitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Jesús nia llofuete: —Mare riara maraiñede riara isoi llɨsiñede. Maraiñede riara mare riara isoi jɨaɨ llɨsiñede. ");
INSERT INTO huuNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Llɨsillamona nɨe isoide riara illana uiñotɨcaɨ. Amena ie llɨsilla llillamona amena marena uiñoga. Llillamona, amena maraiñenana jɨaɨ uiñoga. Eecuaɨmona uvas railla riarana oñedɨcaɨ. Monaigɨmona higos railla riarana jɨaɨ oñedɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ie isoide. Naimacɨ comecɨaɨmo itɨcɨnomona comɨnɨ ñaɨtɨmacɨ. Mare comecɨ itɨcɨnomona maremɨedɨ mare rafuena fɨnocabide. Maraiñede comecɨ itɨcɨnomona maraiñedɨmɨe maraiñede rafuena fɨnocabide. ");
INSERT INTO huuNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Jesús nia llofuete: —Omoɨmona damɨerie cuena: “Caɨ Nama” raitomoɨ; iadedɨ cue llogacɨnona fɨnoñedomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Dɨga comɨnɨ cue dɨne bitɨmacɨ. Cue uaina cacadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Cue uaina ɨɨnotɨmɨe jofona raise fɨnodɨmɨe isoide. Jofona raise fɨnodɨmɨedɨ ie jofona fɨnodemo, jofona goiñellena, nofɨcɨ illa dɨnori eo ana raɨte. Nocɨ deidemo, eo jɨnuidemo, jofomo ille toia, jofo raise fɨnua jira, jofo goiñede. Iena faɨfiñede. Ie isoide. Cue lluana ɨɨnotɨmɨe faɨfiñeite. ");
INSERT INTO huuNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Cue uaina ɨɨnoñedɨmɨe jofona raise fɨnoñedɨmɨe isoide. Jofona raise fɨnoñedɨmɨedɨ ie jofona fɨnodemo, enɨrue emodomo iena fɨnode. Ana raɨñede. Nocɨ deidemo, eo jɨnuidemo, jofomo ille toia, jofo goillamona, jai eo judaɨsite. Iena faɨfide. Ie isoide. Cue lluana ɨɨnoñedɨmɨe faɨfite —llote. ");
INSERT INTO huuNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ie llua fuillamona, Jesús Capernaumo jaide. ");
INSERT INTO huuNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Nainomo romanos railla naɨraɨmo duide illaɨma ite. Cien soldaduaɨna sedauide. Naimɨedɨ capitán. Judíuñedɨmɨe. Ie mullaɨma eo duide. Niade fiodaiacade. Capitán naimɨena eo gaɨde. ");
INSERT INTO huuNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Capernaumo Jesús illana capitán fɨdɨano, Jesús dɨne judíuaɨ einamacɨna orede. Naimɨe dɨne Jesús billena jitaide. Ie mullaɨmana jillotajaɨbillena jitaide. ");
INSERT INTO huuNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Jesús dɨne naimacɨ rillano, capitán dɨne naimɨe billena, naimɨemo duere jɨcanotɨmacɨ. Raitɨmacɨ: —Naimɨedɨ caɨmona maremɨena jira, naimɨena o canuana jitaidɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Caɨ naɨraɨna isiruite. Ie ucube dɨga caɨ ofiracona fɨnotate. ");
INSERT INTO huuNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Iena cacajamona, Jesús naimacɨ dɨga jaide. Capitán jofomo iaɨrei Jesús ria, capitádɨ Jesús dɨne ie nabaiñɨaɨna orede, Jesúmo llollena: —Maestro, biñeno. Jamai bue cue isoilla jira, cue jofomo biñeno. ");
INSERT INTO huuNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Jamai bue cue isoilla jira, o dɨne jɨaɨ jaiñedɨcue. O illanomona o uaido cue mullaɨma jilloita. ");
INSERT INTO huuNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Jɨaɨe illaɨcomɨnɨ anamo itɨcue. Naimacɨ lloga uaina ɨɨnotɨcue. Cue anamo jɨaɨe soldaduaɨ illanona, cue uaina ɨɨnotɨmacɨ. Cue anamo cue mullaɨma illa jira, naimɨedɨ cue uaina ɨɨnote. O anamo naie duico illa jira, o uaina bene o lloia, cue mullaɨma jilloite. ");
INSERT INTO huuNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Iena cacajano, Jesús raijicaide. Oni dobaidajano, naimɨe dɨga jaidɨnomo llote: —Bie isoidɨmɨe cue uaina ɨɨnotɨmɨena jaca baiñedɨcue. Caɨ judíuaɨ comɨnɨmona bie isoidɨmɨena jaca iñede. Mai abɨdo jai. ");
INSERT INTO huuNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Capitámona bitɨno abɨdo capitán jofomo rillano, mullaɨma jai jilluana cɨodɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Jɨaɨruido Naín railla naɨraɨmo Jesús jaide. Ie llofueoicaigano jɨaɨ jaidɨmacɨ. Ailluena comɨnɨ jɨaɨ jaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Naie naɨraɨ ie nasemo naimɨe iaɨreicaia, jai fiodaitɨmɨena comɨnɨ jino atɨana cɨode. Naie fiodaitɨmɨedɨ conirue. Ie eidɨ fecɨño. Dajede ie jitodɨ jai fiodaite. Ailluena Naín itɨno naie fecɨño dɨga jaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Jesús naiñaiñona cɨuanona, naiñaiñona duenaite. Naiñaiñona raite: —Mai eeñeno. ");
INSERT INTO huuNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Fiodaitɨmɨe dɨne Jesús jaillanona, naimacɨ ieconi naidadallena, ie uiga rana jetade. Naimɨena uitɨnodɨ ieconi naidadatɨmacɨ. Fiodaitɨmɨemo Jesús llote: —Mai a raɨnada. ");
INSERT INTO huuNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Iena Jesús llua mei, naie fiodaitɨmɨe ie uiga ramona a raɨnadate. Ie meinoconi naimɨe ñaɨte. Jesús naimɨena ie eimo abɨdo ite. ");
INSERT INTO huuNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Naieri nana jacɨnaitɨmacɨ. Jusiñamuimo iobillacɨnona fecadɨmacɨ. Raitɨmacɨ: —Jusiñamui facaina lloraɨma caɨ motomo ite. Naimɨe uai eo siño. Naimɨena Jusiñamui oretaja jira, Jusiñamui caɨna birui canoacana jira, iobidɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Nana Judeamo itɨno Jesús fɨnoca rafuena fɨdɨdɨmacɨ. Judea enɨrue fuemo ite naɨraɨaɨdɨ jɨaɨ fɨdɨdɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Juan Bautista mɨcorɨ llofueoicaiganodɨ nana Jesús fɨnoca rafuena fɨdɨano, iena naimɨemo llote. Ie llofueoicaiganomona Juan mɨcorɨdɨ menamɨena uaidote. ");
INSERT INTO huuNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Llote: —Jofue iñenanomo navui cue ia, jɨaɨmɨe billena llofuecabitɨcue. Jesús dɨne omɨco jai: “¿Buudɨo? ¿Odɨ Juan llofuegamɨedɨo? ¿Jɨaɨmɨe billemo nia ocuiritɨcaɨ?” naimɨemo jɨcano. ");
INSERT INTO huuNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Jesús dɨne iaɨmaiaɨ rillano, Jesúmo llotɨiaɨmaiaɨ: —Juan Bautista cocona orede. Jofue iñenanomo navui naimɨe ia: “Jusiñamuimona damɨe biite” naimɨe llofuecabite. Juan llofuegamɨena o illana uiñoiacadɨcaɨ. Imɨeñedɨodena, jɨaɨmɨe billemo nia ocuiritɨcaɨ. Cocomo llono. ");
INSERT INTO huuNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Jesús dɨne iaɨmaiaɨ billa facaiseconi, Jesús dɨga isoide duicuaɨ illanona jillotate. Jananɨaɨ anamo itɨnomona jananɨaɨna oni jɨaɨ orede. Uisɨnidɨnona uisɨna dane cɨotate. ");
INSERT INTO huuNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ie jira Jesús iaɨmaiaɨmo llote: —Cue lluana cacadomɨco. Cue fɨnoca rafuena cɨodomɨco. Juan dɨne abɨdo omɨco jaillanona, iena naimɨemo llono. “Uisɨnidɨno jai cɨodɨmacɨ. Ñuja-ñujacaida jaidɨnodɨ jai raise macaritɨmacɨ. Efonaitɨno jai jillodɨmacɨ. Jefona cacaiñedɨnodɨ jai jefona cacasɨte. Fiodaillamona damɨerie jai jillodɨmacɨ. Dueredɨno mare rafuena jai cacadɨmacɨ”. Iese naimɨemo llono. ");
INSERT INTO huuNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Jɨaɨ llono: “Nɨbaɨ nana cue rafuena raise cacaiñedɨo; ia cuena jaca nia ɨɨnocana o jaia, caɨmare iitɨo”. ");
INSERT INTO huuNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Iaɨmaiaɨ abɨdo jailla mei, naimɨe ecɨmo ailluena ite comɨnɨmo Jesúdɨ Juan rafuena llote: —Jofue iñenanomo naimɨe navui ia, naimɨe dɨne jaidomoɨ. ¿Nɨe isoidɨmɨena cɨodomoɨ? Daje uaido rafuena comecɨna facadɨmɨena cɨodomoɨ. Ero, fuirɨna aɨfɨ billamona, raitɨre afai bɨjɨde. Afaina aɨfɨ billamona, raitɨre fuirɨ bɨjɨde. Naimɨe ie isoiñede. Nɨe isoide rafue naimɨemo ia, cue rafuena llocana jaide. ");
INSERT INTO huuNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Bue ñellena naimɨe dɨne jaidomoɨ? Mare ɨniroina jɨtadɨmɨena cɨoiñedomoɨ. Mare ɨniroina jɨtadɨnona omoɨ cɨoacaniadedɨ, illaɨcomɨnɨ dɨne jaidomoɨ. Naimacɨmo ailluena ra ite. ");
INSERT INTO huuNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Jusiñamui facaina lloraɨmana cɨodomoɨ. Naimɨe Jusiñamui facaina llocabite. Jɨaɨe lloraɨnɨ baɨfemo faɨte, cue billena omoɨmo naimɨe llua jira. ");
INSERT INTO huuNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Malaquías mɨcorɨ naimɨena jaie cuega: “Jusiñamui raite: ‘Ero, o uicodo cue rafuena llollena, damɨena oretaitɨcue, comɨnɨ comecɨaɨna marecɨnona duiñollena’ ” cuega. Malaquías Juan Bautistana cuete. ");
INSERT INTO huuNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Juan Bautista nana Jusiñamui facaina lloraɨnɨ baɨfemo faɨte; iadedɨ Jusiñamui comɨnɨna birui bu illamona, Juan baɨfemo birui faɨte. Juan cue billena llofuete; ia naimɨe cue lloga rafuena omoɨ isoi cacaiñede. Naimɨe cue lloga rafue omoɨ isoi suillana cɨoiñede. Iemona naimɨe baɨfemo faɨtomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Naimacɨna navui Juan bautizaja jira, nainomo ite comɨnɨ iena cacajano, Jusiñamuimo iobillacɨnona fecadɨmacɨ. Gobierno ucube oraɨnɨdɨ jɨaɨ fecadɨmacɨ; ");
INSERT INTO huuNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","iadedɨ fariseuaɨ iobillacɨnona fecañedɨmacɨ. Moisés llogacɨnuaɨna llofueraɨnɨ jɨaɨ fecañedɨmacɨ. Jusiñamui naimacɨna jillotajana naimacɨ jamailla jira, naimacɨ jeacɨnona Jusiñamuimo lloñena jira, Juan naimacɨna navui bautizañede. ");
INSERT INTO huuNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jesús llote: —Cuena ɨɨnoñedɨnona lloitɨcue: Ero, omoɨna ñaɨtɨcue. ");
INSERT INTO huuNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Jɨfanote uruiaɨ isoidomoɨ. Uruiaɨ jɨfanoiacania, naimacɨ nabaiñɨaɨna uaiduanona, raitɨmacɨ: “Omoɨ dɨga jɨfanoiacadɨcaɨ; iadedɨ caɨ dɨga jɨfanoiacaiñedomoɨ. Caɨmarede rafuena caɨ jɨfanoiacania, sunailla rafuena jɨfanoiacadomoɨ. Sunailla rafuena caɨ jɨfanoiacania, caɨmarede rafuena jɨfanoiacadomoɨ. Coninɨna nabairiñedɨcaɨ” raitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ie isoidomoɨ. Juan jiroraɨnide. Caɨmare guiñede; ia naimɨe dɨga nabairiñedomoɨ. Naimɨena gaɨñedomoɨ. Ie jira omoɨmona dajerie naimɨena raitɨmacɨ: “Janaba anamo naimɨe illamona, naimɨe uaɨrico isoi ite” raitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Monamona billanona, ɨimana jaidɨcue. Omoɨ isoi guitɨcue. Caɨmataidɨcue; ia cue dɨga nabairiñedomoɨ. Cuena jɨaɨ gaɨñedomoɨ. Ie jira cuena jeare ñaɨtomoɨ. Raitomoɨ: “Guillaredɨmɨe. Jiroruidɨmɨe. Jearede rafue fɨnodɨno dɨga nabairitɨmɨedɨo”. ");
INSERT INTO huuNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Iese raitomoɨ; iadedɨ Jusiñamuina ɨɨnotɨnodɨ cue fɨnoca rafuena marenana uiñotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Jɨaɨruido fariseuaɨ comɨnɨmona, ie jofomo naimɨe dɨga guillena, damɨedɨ Jesúna uaidote. Naimɨedɨ Simón. Naimɨe dɨne Jesús jaillanona, naimɨe dɨga guite. ");
INSERT INTO huuNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Jesús guitemo, daje rɨño fo jaide. Naiñaiñodɨ maraiñede rafuena fɨnoraɨño. Naicomo Jesús guillana fɨdɨano, naiñaiño fo jaide. Nofɨcɨmona fɨnoca frascona atɨde, na soride ra illa dɨga. ");
INSERT INTO huuNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Judíuaɨ acɨaɨta jaca guisoidɨmacɨ. Jɨnafo dɨne eɨllɨ jonesɨuidɨmacɨ. Fo jaillano, naie rɨño Jesús abɨmo naidaide. Naiñaiño eiamona, naiñaiño uisɨmona uaide uillɨnocɨaɨ dɨga Jesús eɨllɨna jocode. Safenaillena, naimɨe eɨllɨna ie ɨfotɨe dɨga dote. Ie eɨllɨna jɨaɨ llibanote. Ie mei ie eɨllɨmo frascomona soride rana totade. Naimɨena naiñaiño isiruillamona, iese naiñaiño fɨnode. ");
INSERT INTO huuNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Iena cɨuanona, Simón dama comecɨna facade: “Bimɨe Jusiñamui facaina lloraɨmadena, nɨe isoide naimɨena jetade rɨñona niade uiñote. Naimɨedɨ naiñaiño maraiñede rafuena fɨnoraɨñona uiñote. Iena naimɨe uiñuamona, naiñaiñona jino raɨre orede. Naimɨedɨ Jusiñamui facaina lloraɨmañede”. ");
INSERT INTO huuNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jesús naimɨe comecɨna facajacɨnona uiñuano, naimɨemo llote: —Simón, naiñaiño fɨnoca rafuena o raise fueollena, omo bie rafuena lloiacadɨcue. Simón uai ote: —Maestro, mai cuemo llono. ");
INSERT INTO huuNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jesús llote: —Damɨe menamaiaɨmo ucubena fecade. Damɨemo quinientos dɨga ucubena fecade. Jɨaɨmɨemo cincuenta dɨga ucubena fecade. ");
INSERT INTO huuNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ie iade, naiena abɨdo meidonidɨaɨmaiaɨ. Ie jira ucubena fecadɨmɨedɨ raite: “Dama omɨco meidoñega. Naiena jai feitatɨcue”. Ero, Simón, ¿nɨmɨeca ucubena fecadɨmɨena eo isiruite? ");
INSERT INTO huuNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simón dɨnena uai ote: —Cue comecɨ raite: Ailluena ucube feitaja jira, eo ailluena ucubena igamɨe. Jesús dɨnena raite: —Raise cue uaina faɨriotɨo. ");
INSERT INTO huuNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Iemei Jesúdɨ rɨño dɨne dobaidajanona, Simómo llote: —Biñaiñona ja lloitɨcue. O jofomo bitɨcue; ia cuena raise nafueñedɨo. O nabai o dɨne bia, naimɨena raise nafuecabitɨo. Ie jearede eɨllɨ jocollena, comɨnɨ fɨnocabilla isoi, jɨnui fecadɨo. Safenaillena eɨllɨ dora fecadɨo. Naimɨena llibanotɨo. Ie abɨ caɨmare sorillena, janore soride ra naimɨemo jonetɨo. Iese cuena nafueñedɨo; ia bie rɨño cuena isiruillamona, ie uillɨnocɨaɨ dɨga cue eɨllɨna jocode. Ie ɨfotɨe dɨga dote. ");
INSERT INTO huuNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Naiñaiño cue ecɨmo fo billanona, cue eɨllɨna dɨga icaiño llibanote. ");
INSERT INTO huuNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Naiñaiño cue eɨllɨmo soride rana totade. ");
INSERT INTO huuNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Naiñaiñomo eo jeacɨno ite; ia cuena naiñaiño eo isiruillamona, nana ie jeacɨnona jai oni dotajana uiñotɨcaɨ. “Jeacɨno cuemo raise iñede” comecɨna bu facaia, Jusiñamui naimɨe jeacɨna oni dotajamona, naimɨe Jusiñamuina janore isiruite. Iemo o comecɨna faca. ");
INSERT INTO huuNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Naiñaiñomo llote: —O jeacɨno jai oni dotaca. Iena jai feitatɨcue. ");
INSERT INTO huuNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Jɨaɨno nainomo guillanona, coninɨri ñaɨtɨmacɨ: —Bimɨedɨ ¿nɨe isoidɨmɨe? Bimɨe jeacɨno oni dotanide. ");
INSERT INTO huuNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Jesús dɨnena rɨñomo llote: —Cuena o ɨɨnua jira, o jeacɨnomona jai jillodɨo. Mai uri o jaillano o i. ");
INSERT INTO huuNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ie facaise dɨga naɨraɨmo Jesúdɨ mare rafuena llocana jaide. Naimɨe anamo comɨnɨ illana Jusiñamui jitailla jira, Jesúdɨ Jusiñamui dɨbeimo naimacɨ comecɨaɨ iuaina meiduana llofuete. Ie doce llofueoicaigano naimɨe dɨga jaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Dajerie rɨñonɨaɨ jɨaɨ jaidɨmacɨ. Naiñaiñuaɨmona dajerie Jesús navui jananɨaɨ anamona orecañaiñuaɨ. Dajerie duicomona jilloitagañaiñuaɨ. María Magdalena ite. Naiñaiñomona siete dɨga jananɨaɨ oni oretate. ");
INSERT INTO huuNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Juana ite. Naiñaiño ɨnidɨ Chuza. Herodes railla illaɨma ecɨmo naimɨe maɨjɨuide. Susana ite. Jɨaɨe rɨñonɨaɨ jɨaɨ itɨmacɨ. Naiñaiñuaɨ ramona Jesúna canouidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Dɨga naɨraɨaɨmona ailluena comɨnɨ Jesús dɨne billanona, naimacɨmo llote: —Jusiñamui omoɨna sedaacana omoɨ fueollena, bie rafuena lloitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Damɨedɨ trigona judaɨaide. Naimɨe judaɨamona naɨsomo janore iduaɨ juide. Comɨnɨ nainomo jaillano, iena saitadɨmacɨ. Baɨ jailla mei, silliñɨaɨ iena jɨaɨ guisaɨbite. Ie jira sɨcoñede. ");
INSERT INTO huuNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Nofɨemo jɨaɨe iduaɨ juide. Sɨcode; iadedɨ jɨnui raise iñena jira, duide. ");
INSERT INTO huuNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Eecuaɨ illanomo jɨaɨe iduaɨ juide. Eecuaɨ sɨcuamona, riara eecuaɨ ɨbaica. Ie jira llɨsiñede. ");
INSERT INTO huuNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Mare enɨruemo jɨaɨe iduaɨ juide. Sɨcode. Llɨsillamona danademo cien dɨga llɨsillana ote. Bie rafuena naimɨe llua mei, naimacɨmo llote: —Omoɨ jeforena jira, raise fueollena, cue lluamo cacarei. Iena ɨɨno. ");
INSERT INTO huuNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Jesúmo ie llofueoicaigano ie como lloga rafuena jɨcanotɨmacɨ: —¿Bue ñellena bie isoide rafuedo comɨnɨna llofuetɨo? ");
INSERT INTO huuNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Uai ote: —Jusiñamuidɨ omoɨna ie sedaacana rafuena jai uiñotade. Jaie iena uiñoñedomoɨ. Jɨaɨe comɨnɨna iena nia uiñotañede. Ie jira bie isoidɨcɨnodo naimacɨmo llotɨcue. Cue siño fɨnoca rafuena cɨodɨmacɨ; iadedɨ iena naimacɨ ɨɨnoñena jira, uiñoñeno jaidɨmacɨ. Cue llofuiana jamai cacadɨmacɨ; iadedɨ naimacɨ ɨɨnoñena jira, raise cacaiñedɨmacɨ. Uiñoñedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","’Omoɨna cue como lloga rafuena llofueitɨcue. Naie iduaɨdɨ Jusiñamui uai. ");
INSERT INTO huuNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Dajerie comɨnɨ comecɨaɨ naɨsomo juide iduaɨ isoidɨmacɨ. Jusiñamui uaina cacadɨmacɨ; ia naimacɨ naie uaina ɨɨnoi raillano, naimacɨ naiemona jilloi raillanona, Taɨfe naimacɨ comecɨaɨmo cacaja uaina ɨɨnotañede. ");
INSERT INTO huuNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Jɨaɨe iduaɨ nofɨemo juide. Dajerie comɨnɨ comecɨaɨ naie nofɨe isoidɨmacɨ. Jusiñamui uai nano naimacɨ cacaia, iena caɨmare feiñotɨmacɨ. Nofɨemo riga iduaɨ jainaonidedɨ raise sɨcoñede. Naie comɨnɨ janore ɨɨnua jira, ie isoidɨmacɨ. Dallu nano ɨɨnotɨmacɨ. Jusiñamui uai muidona duere naimacɨ sefuia, abɨdo danomo uaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Jɨaɨe iduaɨ eecuaɨ illanomo juide. Naie iduaɨ sɨcua mei, iena eecuaɨ ɨbailla jira, raise llɨsiñede. Dajerie comɨnɨ comecɨaɨ naie illano isoidɨmacɨ. Jusiñamui uaina cacadɨmacɨ. Ɨɨnotɨmacɨ; iadedɨ naimacɨ comecɨaɨ jarire illamona, naimacɨ raruiaɨna ebiruillamona, naie uai naimacɨ comecɨaɨmo itabiñede. Jusiñamui jitaille rafuena fɨnocana jaiñedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Jɨaɨe iduaɨ mare enɨruemo juide. Dajerie comɨnɨ comecɨaɨ naie enɨrue isoidɨmacɨ. Jusiñamui uaina cacajano, iena raise cacadɨmacɨ. Mare jeanide comecɨaɨmona ɨɨnocana jaidɨmacɨ. Eo llɨside isoidɨmacɨ. Jusiñamui jitailla rafuena sefuiruiñeno ɨɨnocana jaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Jesús nia llote: —Lamparín bu unia meinoconi, jɨaɨe ra bɨide anamo raɨnañega; iadedɨ jofo jeraimo llɨgaiñollena, nainomo bite comɨnɨ raise cɨoillena, ie raɨranomo raɨnaca. ");
INSERT INTO huuNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ie isoide. Cue rafue llocana jaia, comɨnɨ comecɨaɨ itɨcɨnona uiñotade. Uanaicɨno naimacɨ cacajamona, damɨerie ɨɨnotɨmacɨ. Damɨerie ɨɨnoñedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Cue lluamo raise cacarei. Iena omoɨ ɨɨnuamona, Jusiñamui omoɨna canoite. Omoɨna uiñocana jaitaite. “Jusiñamui rafuena uiñotɨcue” raitɨmɨedɨ ɨɨnoñenia, Jusiñamui naimɨena faɨfitaite. ");
INSERT INTO huuNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Comɨnɨna Jesús nia llofuia, naimɨe dɨne Jesús ei, ie amatɨaɨ dɨga bitɨmacɨ; ia ailluena comɨnɨ illa jira, naimɨemo riñedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Nainomo itɨno naimɨemo llote: —O ei, o amatɨaɨ dɨga jino naidaidɨmacɨ. O dɨga ñaɨacadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Jesús uai ote: —Jusiñamui uaina cacajamona, iena ɨɨnotɨno ieca cue eidɨ, cue amatɨaɨdɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Jɨaɨruido botemo Jesús jailla mei, ie llofueoicaiganomo llote: —Ruica dɨbeimo mai caɨ jaillɨ. —Ie mei jaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Naimacɨ jaidemo, Jesús ɨnɨde. Baɨ jaidɨmacɨmo, eo rɨire aɨfɨ bite. Baguamona botemo jɨnui a uaide. Oruiacana jira, eo jacɨnaitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Jesúna casitajano, naimɨena raitɨmacɨ: —Maestro, jai buisaidɨcaɨ. Jai corobaisaidɨcaɨ. Naimɨe casillano, aɨfɨna lletade. Joraina llɨɨcaitade. Ieconi aɨfɨ llɨɨcaide. Bagoñede. ");
INSERT INTO huuNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Naimacɨmo jɨcanote: —¿Bue ñellena cuena ɨɨnoñedomoɨ? —Naimɨena jacɨnaillamona uai oñedɨmacɨ. Raijicaillamona, coninɨri ñaɨtɨmacɨ: —Bimɨedɨ, ¿nɨe isoidɨmɨe? Aɨfɨ naimɨe uaina ɨɨnote. Jorai naimɨe uaina jɨaɨ ɨɨnote. ");
INSERT INTO huuNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ruica dɨbellemo ridemo, Gadara railla enɨruemo sɨjɨdɨmacɨ. Galilea facaisemo ite. ");
INSERT INTO huuNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","29","Botemona arɨ Jesús jaidemo, damɨe Jesús dɨne bite. Naie naɨraɨ imɨe. Janaba anamo illamɨe. Taɨmɨena jai jaicaisoide. Jofomo naimɨe iraɨnide; ia comɨnɨ raɨoillanomo nofɨe moto ifuaɨmo i-isoide. Ebena comɨnɨna naimɨe faei raillanona, lloeo dɨga ie onollɨdɨ maɨga. Ie eɨllɨ jɨaɨ maɨga; iadedɨ lloeo oni tɨconote. Ie mei jofue iñenanomo Janaba naimɨena jaitate. Iese suisoide. Jesúna naimɨe cɨuanona, cuirioide. Jesús ecɨmo uaide. Janaba naimɨena ado llotatate: —Jesús, nanoca Jusiñamui Jitodɨo. ¿Nɨese cuena nɨbaɨacadɨo? Cuena duere fɨnoñeno. Iese raite, Janaba naie ɨimamona oni jai oretajana Jesús llua jira. ");
INSERT INTO huuNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jesús naimɨemo jɨcanote: —¿O mamacɨ bu? Uai ote: —Aillosiedɨcaɨ. —Ailluena jananɨaɨ naimɨe ecɨmo illa jira, iese naimɨedɨ raite. ");
INSERT INTO huuNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Jesúmo duere jɨcanosɨde, iraimo naimacɨna nia oretañellena. ");
INSERT INTO huuNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Naie facaise nainomo ite anedumo ailluena chanchuaɨ itɨmacɨ. Chanchuaɨ abɨmo naimacɨ jaillena Jesúmo duere jɨcanotɨmacɨ. Jesús dɨnena: —Jee —raite. ");
INSERT INTO huuNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ieconi ɨimamona jaidemo, chanchuaɨ abɨmo jaidɨmacɨ. Iena suidemo, iconɨ jillacɨmo joraimo chanchuaɨ aisɨdɨmacɨ. Dɨnomo corobaisɨde. ");
INSERT INTO huuNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Iena cɨuanona, chanchuaɨ sedaraɨnɨ naimacɨ naɨraɨ dɨne aisɨcana jaidɨmacɨ. Naie rafuena llocana jaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ie jira dɨga comɨnɨ jaide, naie rafuena raise fɨdɨllena. Jesús dɨne naimacɨ ridemo, jaive Janaba anamo illamɨena Jesús ecɨmo raɨllana ciodɨmacɨ. Naimɨe ɨniroina jai jɨtade. Naimɨe jai uaɨricoñede. Iena cɨuanona, Jesúna jacɨruitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Naie rafuena cɨodɨnodɨ como bitɨnomo naimɨe jilluana llotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Naimɨena naimacɨ jacɨruillanona, naimacɨmona oni jaillena nana naie enɨruemo ite naɨraɨdɨ Jesúmo jɨcanotɨmacɨ. Ie jira botemo Jesús jaide, ruica dɨbeimo abɨdo jaillena. ");
INSERT INTO huuNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ieconi jaive Janaba anamo illamɨe Jusúmo jɨcanote, naimɨe dɨga jaillena; iadedɨ Jesús raite: —Dama ite. ");
INSERT INTO huuNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Mai o jofomo o jai. Nainomo itɨnomo nana Jusiñamui omo fɨnoca rafuena llono. Ie mei jaide. Nana naimɨe naɨraɨmo Jesús naimɨemo fɨnoca rafuena llocana jaide. ");
INSERT INTO huuNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ruica dɨbeimo Jesús abɨdo ria, naimɨe abɨdo billemo naimacɨ ocuirilla jira, ailluena comɨnɨ naimɨena feiñotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Jairona mamecɨredɨmɨedɨ Jesús dɨne bite. Naimɨedɨ judíuaɨ rafue ofiraco sedaraɨma. Jesúmo duere jɨcanollena, ana bɨtadate. Naimɨe jofomo Jesús bɨllena duere jɨcanote. ");
INSERT INTO huuNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Dañaiñode ie jisa. Doce años naiñaiñodɨ ite. Niadedɨ fiodaiacade. Ie jira Jesúmo jɨcanuaɨbite. Iena cacajano, naimɨe dɨga Jesús jaide. Ie llofueoicaigano jɨaɨ jaidɨmacɨ. Jesús jaillano, dɨga comɨnɨ naimɨemo ñaijisaide. ");
INSERT INTO huuNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Baɨ jaillanona, duidɨñaiño Jesús jɨnafona jaide. Naiñaiño jeraimona doce años jaca dɨaide. Naiñaiñona jaca buna jillotanide. ");
INSERT INTO huuNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Jɨnafo dɨnena billanona, Jesús ɨniroi fueda jetade. Iemona dɨailladɨ faɨnonocaide. Jillode. ");
INSERT INTO huuNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jesús dɨnena jɨcanote: —¿Bu cuena jetade? Naimɨe ecɨmo ite comɨnɨ uai otɨmacɨ: —Ona jetañedɨcaɨ. Ie nabaiñɨaɨ dɨga Pedro dɨnena raite: —Maestro, ailluena comɨnɨ o ecɨmo jaidɨmacɨ. Omo ñaijidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Jesús uai ote: —Damɨe cuena jetade. Cue abɨmona cue uai jaillamona, naimɨe jai jillode. ");
INSERT INTO huuNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Jaive duidɨñaiñodɨ Jesús naiñaiñona uiñuana uiñote. Ie jira Jesús dɨne jacɨruicana bite. Naimɨe uicomo ana bɨtadajanona, nana comɨnɨ uicomo naimɨena jetaja rafuena llote. Naiñaiño ieconi jilluana llote. ");
INSERT INTO huuNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jesús dɨnena naiñaiñona raite: —Ñoo, cuena o ɨɨnua jira, jai jillodɨo. Mai jaillanona, uri o i. ");
INSERT INTO huuNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Naiñaiño dɨga Jesús nia ñaɨtemo, Jairo jofomona damɨe bite. Jairomo llote: —O jisa jai fiodaite. Maestrona ñaɨdoñeno. ");
INSERT INTO huuNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Iena Jesús cacajano raite: —O comecɨ jarire iñeno; ia cuena nia ɨɨno. Naiñaiño jilloite. ");
INSERT INTO huuNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Jairo jofomo naimacɨ rillano, ailluena comɨnɨ naimɨe dɨga fo jaillana rairuide. Danɨ dɨese fo jaillana jitaide: Pedro, Jacobo, Juan, nai jitaɨbɨcɨ moo, naiñaiño ei. Jaca dɨese fo illana jitaide. ");
INSERT INTO huuNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Nana nainomo itɨno eecuinaidɨmacɨ. Faɨlliñaidɨmacɨ. Jesús dɨnena raite: —Omoɨ eeñeno. Cuemona naiñaiñodɨ fiodaiñedesa. Jamai ɨnɨde. ");
INSERT INTO huuNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Jai fiodaitedɨ: “¿Bue ñellɨ ɨnɨde raitɨo?” raillanona jaisitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Jesús fo jailla mei, naiñaiño onollɨna llɨnocaida, raite: —Jitaɨbɨcɨ, mai naidacai. ");
INSERT INTO huuNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ieconi naiñaiño joreño abɨdo bite. Naidacaide. Jesús llote: —Guillena naiñaiñona eca. ");
INSERT INTO huuNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","—Naiñaiño moo, ie ei dɨga, raijicaidɨiaɨmaiaɨ. Jesús iaɨmaiaɨmo llote: —Bie rafuena bumo lloñeno. ");
INSERT INTO huuNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ie doce llofueoicaiganona naimɨe dɨne Jesús uaiduanona, naimacɨmo ie uaina iñonocaide, jananɨaɨna anamona comɨnɨna jilloitallena. Duicuaɨna oni oretallena, iena jɨaɨ iñonocaide. ");
INSERT INTO huuNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Naimacɨmo llote: —Omoɨ jaillanona, comɨnɨmo llono: “Jusiñamui facaina jaie lloraɨnɨ mɨcorɨaɨ llogamɨe jai bene ite. Naimɨe anamo omoɨ illana Jusiñamui jitailla jira, naimɨe dɨbeimo omoɨ comecɨaɨ iuaina meido”. Duidɨnona jillota. ");
INSERT INTO huuNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Omoɨ jaia, buena uiñeno. Omoɨ abɨna rɨidollena, jɨguidana uiñeno. Ailluena rana omoɨ uiñellena, bolsana uiñeno. Llomenicona uiñeno. Ucubena uiñeno. Guille ifo meidollena, rana uiñeno. Meidolle ɨniroina uiñeno. ");
INSERT INTO huuNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Nɨe naɨraɨmo omoɨ jaia, daacomo omoɨ ri. Naie naɨraɨmo omoɨ ille dɨnori, daacomo omoɨ i. ");
INSERT INTO huuNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Omoɨna comɨnɨ feiñoñenia, naimacɨ naɨraɨmona omoɨ jaia, omoɨ eɨllɨaɨmo ite jearacuaɨna oni jaidɨno. Nɨcɨno naimacɨmo illana naimacɨ uiñollena, omoɨ eɨllɨaɨna oni jaidɨno. ");
INSERT INTO huuNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Jesús naimacɨmo llua mei, jaidɨmacɨ. Jusiñamui rafuena lluanona, dɨga naɨraɨmo jaidɨmacɨ. Dɨga comɨnɨ imacɨ duicomona jillotatɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Naie facaise Herodes railla gobernador nana Jesús fɨnoca rafuena fɨdɨde. “Fiodaillamona Juan Bautista mɨcorɨ jai jillode” dajerie railla jira, ie comecɨ uri iñede. ");
INSERT INTO huuNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Jɨaɨe comɨnɨ raisoidɨmacɨ: —Elías jai bairede. Jɨaɨno raisoidɨmacɨ: —Fiodaillamona Jusiñamui facaina jaie lloraɨma mɨcorɨ jai jillode. ");
INSERT INTO huuNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Jesúna fɨdɨano, Herodes comecɨ uri iñede. Comecɨna facade: “Juan mɨcorɨ ie ɨfogɨna navui jaitatatɨcue. Ie muidona ¿birui bu ie rafuena fɨdɨdɨcue?” Raise uiñollena, Jesúna cɨoacade. ");
INSERT INTO huuNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Jesús llofueoicaigano abɨdo bia, Jesúmo naimacɨ fɨnoca rafuena llotɨmacɨ. Ie mei danɨ ie llofueoicaigano dɨga Jesús Betsaida railla naɨraɨ dɨne jaide; ");
INSERT INTO huuNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","iadedɨ comɨnɨ iena fɨdɨanona, naimɨena racadɨmacɨ. Naimɨe dɨne naimacɨ rilla mei, naimacɨna feiñuanona, naimɨe anamo comɨnɨ illana Jusiñamui jitailla jira, Jesúdɨ Jusiñamui dɨbeimo naimacɨ comecɨaɨ iuaina meiduana llofuete. Duidɨnona jɨaɨ jillotate. ");
INSERT INTO huuNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Jitoma ana itemo, ie doce llofueoicaigano naimɨe dɨne billanona, raitɨmacɨ: —Jofue bene iñede. Bene jaca buedɨ iñede. Ianori ite naɨraɨaɨmo, ianori ite jofuemo naimacɨ ɨnɨllena, naimacɨ guille ollena, bie comɨnɨna abɨdo oreta. ");
INSERT INTO huuNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Jesús uai ote: —Naimacɨna bene eca. Uai onaisɨte: —Danɨ caɨmo ite cinco llomenico mena llɨcɨaɨ dɨga. Nana naimacɨ guillena, ¿guille caɨ ɨballena nɨbaɨ jitaidɨo? ");
INSERT INTO huuNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Cinco mil ɨiñɨaɨ nainomo illa jira, ailluena guille jitaillana uiñotɨmacɨ. Naimacɨ aɨnɨaɨ, imacɨ uruiaɨ dɨga, jɨaɨ itɨmacɨ. Ie llofueoicaiganomo Jesús llote: —Comɨnɨ ana raɨllesa llono. Cincuenta dɨgamɨerie ana imacɨ raɨllesa llono. ");
INSERT INTO huuNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Iena fɨnodɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Naie cinco llomenicona, naie mena llɨcɨaɨ dɨga Jesús uanona, monamo eruaɨllanona, Jusiñamuimo iobillacɨnona fecade. Iemei taɨllude. Ie llofueoicaiganomo fecade, comɨnɨna ecallena. ");
INSERT INTO huuNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Nana guillanona monidɨmacɨ. Monillamona, fɨebide guillena ɨraɨdɨmacɨ. Doce cɨrɨgaɨaɨmo oruitatɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Jɨaɨruido Jesús ie Moomo jɨɨa facaiseconi, ie llofueoicaigano naimɨe dɨga illanona, naimacɨmo jɨcanote: —¿Nɨese comɨnɨdɨ cuena raitɨmacɨ? ");
INSERT INTO huuNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Uai otɨmacɨ: —Damɨerie raitɨmacɨ: “Juan Bautista mɨcorɨdɨo”. Damɨerie raitɨmacɨ: “Odɨ Elíadɨo”. Jɨaɨno raitɨmacɨ: “Jusiñamui facaina jaie ite lloraɨnɨmona damɨe jai jillode. Imɨedɨo”. ");
INSERT INTO huuNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Jesús naimacɨmo jɨcanote: —¿Nɨese omoɨ cuena raitomoɨ? Pedro uai ote: —Odɨ caɨ Jilloitaraɨmadɨo. Jusiñamui facaina lloraɨnɨ mɨcorɨaɨ o billena jaie llotɨmacɨ. Jusiñamui ona orede. ");
INSERT INTO huuNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Jesús naimacɨ como llogacɨno bumo lluana rairuide. ");
INSERT INTO huuNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Llote: —Caɨ judíuaɨ illaɨcomɨnɨ cuena eo duere fɨnoitɨmacɨ. Cuena jitaiñellemona, cuena meineitɨmacɨ; iadedɨ darui amani illanona, fiodaillamona jilloitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Nana ie llofueoicaiganomo llote: —Cue comɨnɨna bu jaiacania, ie jitaille rafuedo jaiñena. Cue dɨbeimo naimɨe jaillamona, duere sefuicana jaite. Nɨbaɨ naiemona fiodaite. Bu iese jaiacania, cue dɨbeimo naimɨe iite. ");
INSERT INTO huuNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Duere sefuillana jacɨruillamona cue comɨnɨna bu jaiacaiñenia, ja muidomo faɨfite; iadedɨ duere sefuillana jacɨruiñenamona cue comɨnɨna bu jaia, jaca faɨfiñeite. ");
INSERT INTO huuNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Cue comɨnɨna bu jaiñenia, nɨbaɨ eo duere sefuiñeite. Nɨbaɨ aillena ra naimɨemo iite; ia, ¿nɨese cue Moo dɨne riite? Nainomo naimɨe riñeno faɨfite. ");
INSERT INTO huuNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Cuena bu meiruia, cue uaina bu meiruia, dane cue bia, naimɨena meiruitɨcue. Cuena meiruillamona: “Cristomo duidɨcue” bu lloiacaiñenia, ɨco cue bia: “Naimɨedɨ cue comɨnɨ” lloñeitɨcue. Jusiñamui jaɨenisaɨ siño uai isoi illanona, cue Moo dɨnena monamona ɨco biitɨcue. Cue Moo uai cuemo illanona, ebire biitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Uanaicɨnona omoɨmo llotɨcue. Omoɨmona dajerie nia fiodaiñeitomoɨmo, illaɨmana cue bairellena cɨoitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ocho dɨgarui illanona, Jusiñamuimo jɨɨllena, anedumo Jesús jaide. Naimɨe dɨga jaillena, Pedrona uite. Juan jɨaɨ uite. Jacobona jɨaɨ uite. Jɨaɨe llofueoicaiganona uiñede. ");
INSERT INTO huuNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Naimɨe jɨɨamona naimɨe abɨ meidocaide. Naimɨe ɨniroi naie dacaiño eo userecaide. ");
INSERT INTO huuNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ieconi menamɨe bairiano, Jesús dɨga ñaɨtɨiaɨmaiaɨ. Moisés mɨcorɨ joreño ite. Elías jɨaɨ ite. ");
INSERT INTO huuNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ebire bairedɨaɨmaiaɨ. Jesús Jerusalémo fiodaille rafuena ñaɨtɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ie facaiseconi Pedro ie nabaiñɨaɨ dɨga jai ɨnɨdɨmacɨ; ia casillamona, Jesús ebirenana cɨodɨmacɨ. Jesús ecɨmo itɨiaɨmaiaɨna jɨaɨ cɨodɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Iaɨmaiaɨ jaiacania, Pedro Jesúmo llote: —Maestro, bene caɨ illana mare. Daje amani bɨsaini caɨ fɨnollena, mare. Daje oɨe, jɨaɨe Moisés mɨcorɨ ie, jɨaɨe Elías ie. —Iese raite; ia ie ñaɨa rafuena raise uiñoñeno jamai ebena ñaɨte. ");
INSERT INTO huuNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Iena naimɨe nia lluanona, uillɨe billamona, naimacɨna ɨbaide. Uillɨe ɨbaibillaconi jacɨnaitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Uillɨemona Jusiñamui naimacɨmo llote: —Bimɨedɨ cue Jito. Naimɨena fetodɨcue, cue jitaille rafue fɨnollena. Naimɨe lluana omoɨ cacareillanona, iena ɨɨno —llote. ");
INSERT INTO huuNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Jusiñamui llua mei, dama Jesúna dane cɨodɨmacɨ. Jesús dɨga itɨno naimacɨ cɨua rafuena naie facaiseconi jaca bumo lloñedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ie areruido anedumona ana bitɨmacɨmo, ailluena comɨnɨ naimacɨmo dafaɨfide. ");
INSERT INTO huuNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Comɨnɨmona damɨe ado llote: —Maestro, cue dajede cue jito duillana jɨbuisaɨbi. ");
INSERT INTO huuNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Janaba naimɨe anamo illamona, cue jito cuiritate. Cue jitona naɨllitacabite. Iemona ie fue mullecabide. Naimɨena bofedaicabite. Naimɨemona oni jaiacaiñede. ");
INSERT INTO huuNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Janabana oni oretallena, o llofueoicaiganomo jɨcanotɨcue; ia oretanidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Iena cacajanona, Jesús ie llofueoicaiganomo llote: —Cue uai siñonana nia ɨɨnoñedomoɨ. Cue mare rafuedo nia raise jaiacaiñedomoɨ. Omoɨ dɨga are itɨcue. Raise omoɨ ɨɨnollena, ¿nɨe dɨnori omoɨ dɨga iitɨcue? —Naie duidɨmɨe moomo llote—, O jito cue dɨne mai atɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Naie urue billano, Janaba naimɨena enɨruemo ana dotade. Naimɨena naɨllitate; ia oni jaillena Jesús Janabana lletade. Ieconi naie urue jillode. Iemei Jesús ie moomo naimɨena fecade. ");
INSERT INTO huuNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Comɨnɨ iena cɨuanona, Jusiñamui siño uai naimɨemo illari raijicaidɨmacɨ. Naimacɨ nia raijicaia, Jesús ie llofueoicaiganomo llote: ");
INSERT INTO huuNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Cue lluana feitañeno. Monamona billanona, ɨimana jaidɨcue; ia Jusiñamui jitailla jira, jɨaɨruido illaɨcomɨnɨ cuena meineitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Jesús lluana raise cacaiñedɨmacɨ. Naimɨe iena llofueñena jira, iena raise uiñoñedɨmacɨ. Naimɨemo iena jɨcanuana jɨaɨ meiruitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ie facaise Jesús llofueoicaigano coninɨ uaitajanona raitɨmacɨ: —¿Bu caɨ moto imɨena ille? ");
INSERT INTO huuNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jesús naimacɨ comecɨaɨ facajacɨnona uiñuamona, nainomo ite comɨnɨmona daje urue baɨ jaɨnanocaida, naimacɨ motomo naimɨena jonete. ");
INSERT INTO huuNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Raite: —Comɨnɨ dɨnena bie urue jamai bue isoide; ia bie isoidɨmɨe cuemo duillamona, naimɨena feiñotɨmɨedɨ cuena jai feiñote. Jusiñamui cuena oretaja jira, cuena feiñotɨmɨe Jusiñamuina jɨaɨ jai feiñote. Jamai bue isoidɨmɨedɨ omoɨ moto imɨena ille. ");
INSERT INTO huuNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Naie facaise ie llofueoicaiganomona Jesúmo Juan llote: —Maestro, o mamecɨdo jananɨaɨna oretacabitɨmɨena cɨodɨcaɨ. Caɨ dɨga naimɨe jaicabiñena jira, iena fɨnuana rairuidɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jesús dɨnena uai ote: —Naimɨena rairuiñeno. Caɨ dɨbeimo itɨmɨedɨ caɨ facaisena ite. Ie jira naimɨe isoidɨnona rairuiñeno. ");
INSERT INTO huuNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Monamo abɨdo Jesús jaillɨrui iaɨrei ia, Jerusalémo jaiacanamo naimɨe comecɨna facade. ");
INSERT INTO huuNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ie jira dajeriena uicodo oretate. Ie ɨnɨllɨnona jenollena, Samaria railla naɨraɨmo jaidɨmacɨ; ");
INSERT INTO huuNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","iadedɨ Jerusalémo naimacɨ jailla jira, judíuaɨñedɨnona samaritanodɨ gaɨñena jira, Jesús llofueoicaiganona feiñoiacaiñedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Iena fɨdɨanona, Jacobo, Juan dɨga, Jesúmo jɨcanotɨiaɨmaiaɨ: —Nama, ¿bie comɨnɨ jobaillena, monamona irai billena Jusiñamuimo coco jɨcanuana jitaidɨo? ");
INSERT INTO huuNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Iaɨmaiaɨmo eruaɨllanona, Jesús dɨnena iaɨmaiaɨmo rɨire lletade: —Dama ite. Iena jitaiñedɨcue. ");
INSERT INTO huuNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ie mei ɨnɨllena jɨaɨe illanomo jaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Naɨsona ie llofuecaigano dɨga, Jesús oni jaillanona, Jesúmo damɨe llote: —O jaillɨnomo o dɨga jaiacadɨcue. O llofuegamɨena jaiacadɨcue. ");
INSERT INTO huuNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesús uai ote: —Janorede ocainaɨaɨdɨ joforedɨmacɨ. Silliñɨaɨ jɨllaɨnɨaɨredɨmacɨ; iadedɨ jofonidɨcue. Monamona billanona, ɨimana jaidɨcue; iadedɨ buenidɨcue. Jofonidɨcue. Cue dɨga o jaiacania, bue isoidena cuemona oñeitɨo. Iemo o comecɨna raise faca. ");
INSERT INTO huuNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jɨaɨmɨemo Jesús llote: —Cue llofuegamɨena o jaillena, cue dɨga mai bi. Naimɨe uai ote: —O dɨga jaitɨcue; ia cue moo nia fiodaiñena jira, o dɨga nia jaiñeitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesús naimɨemo dane llote: —Dama ite. Cue dɨga mai bi. Cuena ɨɨnoñedɨnodɨ o moona canoredɨmacɨ. Naimɨe fiodaia, naimɨena naimacɨ raɨlle. Cue rafue jɨaɨe rafue baɨfemo faɨte. Naimɨe anamo comɨnɨ illana Jusiñamui jitailla jira, naimɨe dɨbeimo naimacɨ comecɨaɨ iuaina meiduana llocana cue dɨga mai o bi. ");
INSERT INTO huuNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Jɨaɨmɨe Jesúmo llote: —O llofuegamɨena jaiacadɨcue: iadedɨ cue jofomo nano jaiacadɨcue, cue comɨnɨna facadollena. ");
INSERT INTO huuNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesús uai ote: —Cue llogamɨena jaiacania, jɨaɨe ramo naimɨe comecɨna eo facañena. Jɨaɨe ramo naimɨe comecɨna eo facaia, Jusiñamui facaina raise maɨjɨnide. ");
INSERT INTO huuNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ie llofueganona llofuia mei, naimacɨmona Jesús setenta dɨgamɨena fetode. Naga naimɨe jaiacana naɨraɨaɨmo menamɨeriena oretate. ");
INSERT INTO huuNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Naimacɨmo llote: —Dɨga comɨnɨ ite, naimacɨna Jusiñamui rafuena ɨɨnotallena; iadedɨ eo janore lloraɨnɨ ite. Jusiñamuimo jɨcano, jɨaɨe lloraɨnɨna naimɨe oretallena. ");
INSERT INTO huuNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Mai jai; iadedɨ abɨ rairuicana jai. Toɨca llaudaɨaɨ janallari illanomo illa isoi, omoɨna oredɨcue. ");
INSERT INTO huuNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ucubena uiñeno. Ailluena rana omoɨ uiñellena, bolsana uiñeno. Meidolle zapatona uiñeno. Naɨsomo bu omoɨmo dafaɨfia, are ñaɨñeno. ");
INSERT INTO huuNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Bu ie jofomo omoɨ ria, jofomo itɨnomo marena uaido. ");
INSERT INTO huuNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Nainomo maremɨe ia, o uaina faɨrioite. Maremɨe iñenia, o uaina faɨrioñenia: “Jusiñamui ona canoite” naimɨemo lloñeno. ");
INSERT INTO huuNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Nɨe naɨraɨmo omoɨ ria, daacomo omoɨ ri. Omoɨ ecalle rana guiño. Cue facaina omoɨ maɨjɨa jira, comɨnɨ omoɨna ecajia, cue facaina omoɨ maɨjɨa facaina omoɨ guiño. Naga jofomo guicana jaiñeno. ");
INSERT INTO huuNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Nɨe naɨraɨ omoɨ ria, omoɨna naimacɨ feiñoia, omoɨ ecalle rana uaitañeno guiño. ");
INSERT INTO huuNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Duidɨnona jillota. Nainomo itɨnomo llono: “Naimɨe anamo omoɨ illana Jusiñamui jitailla jira, naimɨe dɨbeimo omoɨ comecɨaɨ iuaina meido”. ");
INSERT INTO huuNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Nɨe naɨraɨmo omoɨ ria, omoɨna naimacɨ feiñoñenia, ie naɨso motomo jaillanona llono: ");
INSERT INTO huuNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Omoɨ naɨsomo caɨ eɨllɨmo ite jearacuaɨ jai jaidɨnotɨcaɨ, maraiñede rafue omoɨmo illana omoɨ uiñollena. Jusiñamui omoɨna sedaacade; ia iena jitaiñedomoɨ” llono. ");
INSERT INTO huuNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Sodoma naɨraɨ jaie eo maraiñede. Jusiñamui iena jaie fuidode; ia nana comɨnɨ naimɨe uicomo ɨco ia, Jusiñamuidɨ omoɨna feiñoñedɨnona Sodoma railla naɨraɨ baɨfemo duere fɨnoite. ");
INSERT INTO huuNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Ie fetocanomo Jesús nia llote: —Corazín railla illanomo navui itɨcue. Betsaida railla illanomo navui jɨaɨ itɨcue. Naimacɨ dɨne dɨga siño rafuena fɨnodɨcue; iadedɨ ɨɨnoñedɨmacɨ. Ɨco duere sefuitɨmacɨ. Tiro railla naɨraɨmo, Sidón railla naɨraɨmo naie isoide siño rafuena fɨnodɨcuena, naimacɨ comecɨaɨ eo isinotaillamona, naimacɨ comecɨaɨ iuai meidotɨmacɨ. Naimacɨ comecɨaɨ iuai meiduana jɨaɨe comɨnɨ uiñotallena, ebinide ɨniroina jɨtajanona, jusefo naimacɨ ɨfogɨaɨmo jonetɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Jusiñamui uicomo nana comɨnɨ ɨco ia, Corazímo itɨno Tiro naɨraɨ baɨfemo duere sefuitɨmacɨ. Sidón naɨraɨ baɨfemo duere sefuitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Capernaumo itɨno jɨaɨ duere sefuitɨmacɨ. Birui abɨna ɨedoiacadɨmacɨ; iadedɨ jɨaɨruido sure iitɨmacɨ. Monamo cue Moo dɨga jaca iñeitɨmacɨ; iadedɨ naimɨe naimacɨna duere fɨnollemona, sure iitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Omoɨ lluana naimacɨ cacaacania, cuena cacadɨmacɨ. Omoɨ lluana naimacɨ jitaiñenia, cuena jitaiñedɨmacɨ. Cuena jitaiñedɨnodɨ cuena oretagamɨena jɨaɨ jitaiñedɨmacɨ. —Jesús naie fetocanomo iese llua mei, oni jaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Jɨaɨruido Jesús ie setenta fetocano abɨdo caɨmare bitɨmacɨ. Raitɨmacɨ: —Nama, o facaido comɨnɨmona jananɨaɨna oni oredɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesús naimacɨmo llote: —Monamona Taɨfe borilla isoi jaie ana dotajana cɨodɨcue. Iemona cue uai naimɨe uai baɨfemo faɨana uiñotɨcue. ");
INSERT INTO huuNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Jaiomona ramo omoɨ jiriñena uai omoɨmo jai itatatɨcue. Acaiduaɨmona ramo omoɨ jiriñena uai omoɨmo jɨaɨ jai itatatɨcue. Nana cue dɨbeimo iñedɨno omoɨ anamo jai itatatɨcue. Omoɨna nɨese nɨbaɨñeitɨmacɨ; ");
INSERT INTO huuNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","iadedɨ omoɨ uaina jananɨaɨ ɨɨnua jira, iobiñeno; iadedɨ Jusiñamui comɨnɨna omoɨ illamona, omoɨ mamecɨaɨ monamo Jusiñamui rabenicomo jai cuiamo iobi. ");
INSERT INTO huuNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ie facaiseconi ie Moo Joreño naimɨemo illa jira, Jesús iobide. Raite: —Ore Moo, oca mona Namadɨo. Oca enɨrue Namadɨo. Abɨna uiñotɨnona bie isoide rafuena uiñotañedɨo; iadedɨ jamai bue isoidɨnona iena uiñotadɨo. O jitailla jira, iese uiñotadɨo. Ie jira iobillacɨnona omo fecaacadɨcue. Mai. ");
INSERT INTO huuNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Jesús dɨnena naimɨe ecɨmo ite comɨnɨmo dane llote: —Cue Moomona nana cue rafuena otɨcue. Dama cue Moo cuena raise uiñote. Dama cue Moona raise uiñotɨcue. Cue jitaille dɨese omoɨna naimɨena uiñotadɨcue. Ie muidona naimɨena uiñotomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ie llofueoicaigano dɨga eneno ia, naimacɨmo llote: —Cue fɨnoca rafuena omoɨ cɨua jira, nɨ ua omoɨ marena illɨno jillacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Jusiñamui facaina jaie lloraɨnɨ mɨcorɨaɨ omoɨ siñona cɨua rafuena jaie cɨoacadɨmacɨ; iadedɨ cɨoiñedɨmacɨ. Iena cacaacadɨmacɨ; ia cacaiñedɨmacɨ. Jusiñamuina jaie ɨɨnotɨno mɨcorɨaɨ iena cɨoacadɨmacɨ; iadedɨ cɨoiñedɨmacɨ. Iena cacaacadɨmacɨ; iadedɨ cacaiñedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Jesús ecɨmo itɨnomona Moisés mɨcorɨ llogacɨnuaɨna llofueraɨmadɨ Jesúna facacɨano, naimɨemo jɨcanote: —Maestro, Jusiñamui illanomo jaca cue illena, ¿bue fɨnoitɨcue? ");
INSERT INTO huuNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesús uai ote: —¿Nɨese Moisés mɨcorɨ llogacɨnuaɨ iena raite? ");
INSERT INTO huuNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Uai ote: —Moisés mɨcorɨ jaie cuega: “O jitailla jira, o comecɨna facajamona, caɨ Nama Jusiñamuina nana o comecɨ jitaillamona naimɨena eo isirui. O abɨna o isiruilla isoi, o ecɨmo itɨnona isirui”. ");
INSERT INTO huuNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jesús dɨnena raite: —Marena cue uai otɨo. Iena o fɨnoia, Jusiñamui illanomo jaca iitɨo. ");
INSERT INTO huuNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Naie llofueraɨma Jesúmo dane jɨcanote: —¿Bu cue ecɨmo itɨno? ");
INSERT INTO huuNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jesús uai ote: —Jɨaɨe rafuedo iena omo lloitɨcue. Jerusalémona Jericómo damɨe jaide. Naimɨe jaillano fɨɨredɨno naimɨe dɨne bitɨmacɨ. Ie ɨniroina baɨrosɨte. Naimɨena fatɨmacɨ. Niade ie meinianona ie ecɨmona jaisɨte. ");
INSERT INTO huuNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Dallu illanona, Jusiñamui dɨga ñaɨraɨma naie naɨsona jaide. Fagamɨena cɨode; iadedɨ ecɨdo jaide. ");
INSERT INTO huuNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Dallu illanona, Jusiñamui jofomo maɨjɨraɨma jɨaɨ jaide. Fagamɨena cɨuanona, ecɨdo jɨaɨ jaide. ");
INSERT INTO huuNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ja muidomo Samaria naɨraɨ imɨe jaide. Naie naɨraɨna enoidomoɨ. Fagamɨena naimɨe cɨuanona, naimɨena duenaite. Iemona naimɨe canoacade. ");
INSERT INTO huuNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Naimɨe dɨne jaillano, ie bofellañona manode. Jɨaɨ maɨtade. Ie burro emodomo jonecaida, naimɨena uite. Ɨnɨllɨnomo rilla mei, nainomo naimɨena sedade. ");
INSERT INTO huuNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ie areruido ie ɨnɨa jofo namamo janore ucubena fecade. Raite: “Naimɨena seda. Naimɨe facaina jɨaɨe rana o oia, abɨdo cue bia, iena ɨbaitɨcue”. Ie mei oni jaide. ");
INSERT INTO huuNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","—Naie llofueraɨmamo Jesús dɨnena jɨcanote— ¿Fagamɨe ecɨmo itɨmɨedɨ bu? ");
INSERT INTO huuNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Uai ote: —Fagamɨena duenaitɨmɨe. Jesús raite: —Jai raise uiñotɨo. Mai jai. Ie isoi fɨnocana o jai. ");
INSERT INTO huuNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Nia macaritɨmacɨmo, comɨnɨ illanomo Jesús ie llofueoicaigano dɨga ridɨmacɨ. Marta raillañaiño ie jofomo naimɨena feiñote. ");
INSERT INTO huuNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Naiñaiño euiñodɨ María. Jesús ecɨmo llaribamo María ana raɨde, naimɨe llofuiacɨnona cacareillena; ");
INSERT INTO huuNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","iadedɨ Martamo maɨjɨlle eo illa jira, naiñaiño naimɨe llofuiacɨnona cacarefiñede. Ie jira Jesúmo llote: —Nama, cue euiño cuena canoacaiñena jira, daño maɨjɨdɨcue. “O euiñona cano” naiñaiñomo llono. ");
INSERT INTO huuNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Jesús uai ote: —Ero, Marta, jarire itɨo. Dɨga o ramo comecɨna facadɨo; ia Jusiñamui rafuemo comecɨna faca. ");
INSERT INTO huuNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","María iemo comecɨna jai facade. Naiñaiño cue llofuiana nano cacaiacade. Ona canollena naiñaiñomo lloñeitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Jɨaɨruido ie Moo dɨga Jesús ñaɨa, ie llofueganomona damɨe naimɨemo llote: —Nama, jɨɨana caɨna llofue, ie llofueoicaiganona Juan Bautista mɨcorɨ llofuia isoi. ");
INSERT INTO huuNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jesús uai ote: —Omoɨ jɨɨia, iese omoɨ jɨɨ: Ore Moo, comɨnɨ ori iobidesa. O illaɨmana jira, nana comɨnɨna o anamo raɨre itata. O jaɨenisaɨ o jitaillacɨnona fɨnua isoi, comɨnɨna o jitaillacɨnona fɨnota. ");
INSERT INTO huuNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Nagarui guille caɨmo itata. ");
INSERT INTO huuNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Caɨna jeare jɨaɨno fɨnoia, iena caɨmona feilla isoi, caɨ jeacɨnona omona feilla jira, caɨ jeacɨnona oni dota. Caɨna ramo bu faɨa, caɨna cano, iena caɨ ɨɨnoñellena. ");
INSERT INTO huuNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Iena naimacɨna nia llofuellena, Jesús jɨaɨe rafuena llote: —Naɨona mona moto llomenicona jɨcallena, o nabai dɨne o jaia, ado lloitɨo: “Nabai, daje amani llomenicona jitaidɨcue. ");
INSERT INTO huuNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Jɨaɨe nabai cue jofomo como ride. Jaca cuemo buedɨ iñede, naimɨena cue ecallena”. ");
INSERT INTO huuNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ie jofo jeraimona o nabai faɨrioite: “Cuena uaidoñeno. Cue nasedɨ jai cue ɨbaicasa. Cue uruiaɨ jai ɨnɨdɨmacɨ. Jɨaɨ ɨnɨdɨcue. Llomenicona omo fecallena casiacaiñedɨcue”. ");
INSERT INTO huuNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ja muidomo casillano, omo iena fecaite. Ie nabaina o illa jira, fecañeite; iadedɨ o eo jitailla jira, o jitaille rana fecaite. ");
INSERT INTO huuNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","10","Daje ra omoɨ faɨfia, iena jenodomoɨ. Raise jenoia, iena baitomoɨ. Damɨena omoɨ jenoia, naimɨe illanomo jaidomoɨ. Nainomo naimɨena baillamona, omoɨna feiñoite. Ie isoide. Buena omoɨ jitaia, Jusiñamuimo jɨca. Iena omoɨ jɨcaja jira, iena naimɨe cacajamona, omoɨmo iite. ");
INSERT INTO huuNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’Ero, omoɨmona ie moomo llomenicona ie jito jɨcaia, nofɨcɨna fecañede. Llɨcɨaɨna jɨcaia, jaiona fecañede. ");
INSERT INTO huuNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Jɨgɨna jɨcaia, acaidona fecañede. ");
INSERT INTO huuNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Jeacɨnona fɨnocabidomoɨ; iadedɨ omoɨ uruiaɨmo mare rana fecacabillana uiñotomoɨ. Caɨ Moo Jusiñamui jaca mareuidɨmɨe. Caɨ baɨfemo naimɨe faɨte. Ie muidomo naimacɨna canollena, naimɨemo jɨcadɨnomo ie Joreñona itataite. ");
INSERT INTO huuNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jɨaɨruido Janaba anamo illamɨemona Jesús Janabana oni orede. Janabana nia oretañenia, Janaba anamo naimɨe illamona, naie ɨima ñaɨnide. Janaba oni jailla mei, naimɨe ñaɨte. Ie jira comɨnɨ raijicaidɨmacɨ; ");
INSERT INTO huuNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","iadedɨ dajerie raitɨmacɨ: —Beelzebú anamo bimɨe illamona, Beelzebú uaido jananɨaɨna oni orede —raitɨmacɨ. Beelzebúdɨ Janaba comɨnɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Jɨaɨno naimɨena facacɨiacasɨte. Raitɨmacɨ: —Siño uai omo ia, Jusiñamuina siño rafuena fɨnota. ");
INSERT INTO huuNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Naimacɨ comecɨaɨna Jesús uiñua jira, naimacɨmo llote: —Daje isoi comecɨaɨna lloillamo daje naɨraɨ facañenia, danomo maɨjɨnidɨmacɨ. Oni jaidɨmacɨ. Daje isoi comecɨaɨna lloillamo daje jofomo itɨno facañenia, danomo jaɨnaɨaɨnidɨmacɨ. Oni jaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ie isoide. Beelzebú uaido jananɨaɨna, omoɨ llua isoi, cue oretaia, Janaba ie dɨbeimo itɨno dɨga jai nabairiñede. Iemona naimɨe comɨnɨ danomo iñeitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Omoɨ comɨnɨ jananɨaɨna oni oretacabitɨmacɨ; iadedɨ naimacɨ fɨnoca rafuena uaitañedomoɨ. Naimacɨmo jɨcano, bie isoide rafuena omoɨ raise uiñollena. Iemei cue fɨnoca rafuena uaitañeitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","22","’Jɨaɨe rafuedo iena lloitɨcue. Ero, ie rana raise rɨiduamona, maɨridɨmɨe ie rana raise enoite. Ie jofomo ie ra illanona, iena raise sedaite. Jamai bue isoidɨmɨe ie rana fɨɨnide; iadedɨ naimɨe baɨfemo maɨridɨmɨe bia, naimɨena emodofillamona, ie rana fɨɨrede. Ie isoide. Janaba anamona comɨnɨna jillotacabitɨcue. Naimɨe afemo nano cue iñenia, comɨnɨna jillotanidɨcue. Naimɨe afemo cue illa jira, iena fɨnoredɨcue. Jusiñamui uaido jananɨaɨna cue oretaia, Jusiñamui rafuena cue lluana uiñotomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","’Cue dɨbeimo iñedɨmɨe cuena enoide. Cue dɨbeimo comɨnɨna itatañedɨmɨedɨ naie comɨnɨna cuena ɨɨnotañede. ");
INSERT INTO huuNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Jesús naimacɨmo nia llote: —Birui bene ite maraiñede comɨnɨdɨ Janaba anamo illamɨe isoidɨmacɨ. Naimɨemona Janaba oni jaia, jɨaɨe illanona baillena, jofue iñenanomo jaide; iade baiñede. Baiñena jira, naimɨe comecɨna facade: “Navui cue anamo illamɨe dɨne abɨdo jaitɨcue”. ");
INSERT INTO huuNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Abɨdo naimɨe bia, naie ɨima comecɨ namanidena naimɨe baite. ");
INSERT INTO huuNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Iemei oni jaillanona, jɨaɨe siete jananɨaɨna naimɨe dɨga atɨde, naimacɨ anamo naie ɨima illena. Naie siete jananɨaɨ naimɨe baɨfemo maraiñedɨmacɨ. Iemona naie ɨima eo fodo jaide. Ie isoide birui ite maraiñede comɨnɨ. Cue rafue naimacɨ ɨɨnoñenia, eo fodo jaitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Comɨnɨmo Jesús llotemo, comɨnɨ motomona dañaiño Jesúmo llote: —O ei caɨmare illesa. Naiñaiñomona comuidɨo. Naiñaiño monoɨ jirodɨo. Naiñaiño caɨmare illesa. ");
INSERT INTO huuNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Jesús uai ote: —Marena llotɨo; ia Jusiñamui uaina naimacɨ cacajamona, iena ɨɨnuamona, jɨaɨno eo caɨmare iitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ie facaise dɨga comɨnɨ Jesús dɨne biñoidɨmacɨ. Naimacɨmo llote: —Birui ite comɨnɨdomoɨ maraiñedomoɨ. Siño rafuena cue fɨnuana cɨoacadomoɨ; iadedɨ iena omoɨ jamai cɨoillena, siño rafuena fɨnoñeitɨcue. Ero, Jonás mɨcorɨ jaie ite rafuena uiñotomoɨ. Naiemo omoɨ comecɨaɨna omoɨ faca. ");
INSERT INTO huuNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Naimɨemo suide rafuemona Nínive railla naɨraɨdɨ Jusiñamui naimɨena oretajana jaie uiñotɨmacɨ. Ie isoide. Fiodaillamona cue jilluamona birui ite comɨnɨdɨ Jusiñamui cuena oretajana uiñoitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ero, Saba railla naɨraɨ ie illaɨño mɨcorɨdɨ Salomón mɨcorɨ dɨne jaie aarena jaide. Naimɨe mɨcorɨ uiñuacɨnona naiñaiño mɨcorɨ cacareillena, aarena jaide. Salomón mɨcorɨ baɨfemo birui uaidɨcue; iadedɨ cuena ɨɨnoñedomoɨ. Omoɨ comecɨaɨ icɨnuaɨna birui omoɨ meidoñena jira, Jusiñamui uicomo nana comɨnɨ ille facaiseconi naiñaiño mɨcorɨ omoɨna ɨco ñaɨte: “Naimɨedɨ siño rafue fɨnuana cɨodomoɨ. ¿Bue ñellena naimɨena ɨɨnoñedomoɨ?” omoɨna ɨco ñaɨte. ");
INSERT INTO huuNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Llɨcɨaɨ jeraimona naimɨe jillua mei, Nínive railla naɨraɨ dɨne Jonás mɨcorɨ jaide. Nainomo Jusiñamui rafuena llote. Naie comɨnɨ iena cacajano, naimacɨ comecɨaɨ icɨnuaɨna meidotɨmacɨ. Cue rafuena omoɨ cacajamona, omoɨ comecɨaɨ icɨnuaɨna birui omoɨ meidoñena jira, Jusiñamui uicomo ɨco nana comɨnɨ ille facaiseconi: “Cue comɨnɨdomoɨ” omoɨna raiñeitɨcue. Jonás mɨcorɨ baɨfemo birui uaidɨcue; iadedɨ cuena ɨɨnoñedomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Jesús llote: —Lamparín bu unia mei, jofo anamo bainino raɨnañega. Cɨrɨgaɨ anamo raɨnañega. Ie raɨranomo raɨnaca, comɨnɨ nainomo bia, jofo jerai llɨgaiñollena. ");
INSERT INTO huuNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Omoɨ uisɨ dɨga rana cɨodomoɨ. Omoɨ uisɨ maraiñenia, rana raise cɨoiñedomoɨ. Ie isoide. Omoɨ comecɨ maraiñenia, maraiñedɨcɨnona fɨnocana jaidomoɨ. Jusiñamuina uiñoñedomoɨ. Ie rafuena jɨaɨ uiñoñedomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ie jira omoɨ comecɨaɨna raise fɨno, cue rafuena omoɨ raise ɨɨnollena. ");
INSERT INTO huuNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Nana omoɨ comecɨaɨ marena ia, cue rafuena ɨɨnocana jaitomoɨ. Iena raise uiñoitomoɨ. Jofomo lamparín raise llɨgaiñua isoi, cue rafuena raise uiñoitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Comɨnɨna Jesús llofuia mei, daje fariseo imɨe naimɨe dɨne bite. Raite: —Cue dɨga cue jofomo mai guisaɨbi. —Jesús faɨriua mei, naimɨe dɨga guisaide. ");
INSERT INTO huuNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Naimɨe nia guiñenia, naimacɨ einamacɨ llogacɨnodo naimɨe jaiñenamona, Jesús ie onollɨna jocoñede. Ie jira naie fariseo imɨe raijicaide. Ie comecɨna facade: “Naimɨe eo mare llofueraɨma. ¿Nɨese caɨ einamacɨ llogacɨnodo jaiñede?” ");
INSERT INTO huuNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Jesús naimɨemo llote: —Da platos jɨnafo, da pocillos jɨnafo jocodɨno isoidomoɨ. Da platos jerai, da pocillos jerai jocoñedɨno isoidomoɨ. Omoɨ abɨna fɨnodomoɨ; iadedɨ omoɨ comecɨaɨna fɨnoñedomoɨ. Rana eo nɨcɨdotomoɨ. Omoɨ comecɨaɨ jearede. ");
INSERT INTO huuNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Abɨ uiñoñedomoɨ. Jusiñamui omoɨ abɨaɨna omoɨ comecɨaɨ dɨga fɨnode. Omoɨ fɨnoca rafuena uiñote. Omoɨ comecɨaɨna facajacɨnona jɨaɨ uiñote. ");
INSERT INTO huuNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Omoɨ comecɨaɨ marena ia, jɨaɨe comɨnɨna canodomoɨ. Iemona Jusiñamuimona omoɨ abɨ jɨaɨ mare. ");
INSERT INTO huuNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Fariseuaɨ, omoɨmo rafuena lloitɨcue. Nana omoɨ illɨmo ite ramona Jusiñamuimo janore jisa feca-fecacabidomoɨ; iadedɨ jɨaɨe comɨnɨmo mare rafuena raise fɨnoñedomoɨ. Jusiñamuina jɨaɨ raise isiruiñedomoɨ. Nana naie isoide rafuena omoɨ jɨaɨ fɨnua. ");
INSERT INTO huuNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Comɨnɨ omoɨri acarillena, ofiracomo uicomo raɨacadomoɨ. Nɨne omoɨ macaria: “Jamai bue isoiñedɨcaɨ” omoɨ comecɨaɨna facajamona, jɨaɨe comɨnɨ omoɨna uaiduana gaɨdomoɨ. Iese omoɨ jailla jira, Jusiñamui omoɨna duere fɨnoite. ");
INSERT INTO huuNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Bainino ite raɨafo emodomo comɨnɨ uiñoñeno macarillamona, naimacɨ abɨ jai jearede” raitomoɨ. Bainino ite raɨafo isoidomoɨ. Omoɨ dɨga jɨaɨe comɨnɨdɨ omoɨmo ite jeacɨnona uiñoñeno nabairillamona, jeacɨnona jɨaɨ fɨnodɨmacɨ. Iese omoɨ fɨnocana jaia, Jusiñamui omoɨna duere fɨnoite. ");
INSERT INTO huuNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Naie facaise Moisés llogacɨnuaɨna llofueraɨnɨmona damɨe Jesúmo llote: —Iese o lloia: “Jeacɨno fɨnodomoɨ” caɨna jɨaɨ llotɨo. ");
INSERT INTO huuNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jesús uai ote: —Jusiñamuimona jɨaɨ duere sefuitomoɨ. Omoɨ einamacɨ llogacɨnuaɨdo raise naimacɨ jaillena, dɨga rafue comɨnɨ fɨnuana jitaidomoɨ; iadedɨ iedo naimacɨ raise jaillena, naimacɨna jaca canoñedomoɨ. “Jusiñamuina eo raise sedadɨcaɨ” comecɨna facadomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Omoɨ jaiagaɨdɨ Jusiñamui facaina lloraɨnɨna meinetɨmacɨ. Naie lloraɨnɨ mɨcorɨaɨ raɨafuaɨ birui marena fɨnodomoɨ; ");
INSERT INTO huuNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","iadedɨ naimacɨ mɨcorɨaɨ llogacɨnuaɨdo omoɨ birui jɨaɨ jaiñena jira, omoɨ jaiagaɨ fɨnoca radɨ: “Mare” raitomoɨ. Jusiñamui rafuedo birui omoɨ raise jaiñena jira, omoɨ jaiagaɨ isoi itomoɨ. Iese omoɨ jailla jira, Jusiñamui omoɨna duere fɨnoite. ");
INSERT INTO huuNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Omoɨna Jusiñamui abɨ uiñuamona jai llote: “Cue rafuena llollena, naimacɨ dɨne cue facaina lloraɨnɨna oretaitɨcue. Cue rafuena eo uiñotɨnona jɨaɨ oretaitɨcue. Dajeriena meineitɨmacɨ. Jɨaɨnona duere fɨnoitɨmacɨ”. ");
INSERT INTO huuNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Enɨrue fɨnua facaisemona ailluena Jusiñamui facaina lloraɨnɨna meinetɨmacɨ. Omoɨmona Jusiñamui ɨba oite. ");
INSERT INTO huuNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Abel mɨcorɨ jaie ite. Ie ama naimɨena meinete. Naimɨe facaisemona omoɨ jaiagaɨdɨ dɨga lloraɨnɨna meinetɨmacɨ. Zacaríana jɨaɨ meinetɨmacɨ. Jusiñamui jofomo Jusiñamuimo toɨca ocaina jobaisoillano motomo naimɨena meinetɨmacɨ. Omoɨmona Jusiñamui birui ɨba oite. ");
INSERT INTO huuNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Omoɨ llofuiamona comɨnɨ Jusiñamui rafuena uiñoñedɨmacɨ. Jusiñamui rafuena raise uiñoñedomoɨ. Jɨaɨno iena raise uiñuana jitaiñedomoɨ. Iese omoɨ jailla jira, Jusiñamui omoɨna duere fɨnoite. ");
INSERT INTO huuNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Fariseo jofomona Jesús jailla mei, fariseuaɨ comɨnɨ icɨrillamona, Jesúmo dɨga rafuena jɨcanotɨmacɨ, naimɨe uaina uaitallena. Moisés mɨcorɨ llogacɨno llofueraɨnɨ daje isoi uai uaitatɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Naimɨe raise uai oñedena, naimɨena duere fɨnoacadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ie facaiseconi eo ailluena comɨnɨ Jesús dɨne ofidɨmacɨ. Ailluena illa jira, coninɨ eɨllɨaɨmo naidadatɨmacɨ. Ie llofueoicaiganomo Jesús llote: —Fariseuaɨ sɨritate ramona abɨna rairui. Biena ñaɨtɨcue. “Maredɨcaɨ” raitɨmacɨ; iadedɨ mareuidɨnona abɨ caitadɨmacɨ. Naimacɨmona abɨna rairui. ");
INSERT INTO huuNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Naimacɨ birui fɨnoca rafuena birui bainino fɨnodɨmacɨ; ia Jusiñamui naimacɨ comecɨaɨ itɨcɨnona ɨco uiñotaite. ");
INSERT INTO huuNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ero, cue rafuena birui anado llocana jaidomoɨ; ia ɨco marefodo iena llocana jaitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ie llofueganomo Jesús llote: —Cue nabaiñɨaɨdomoɨ. Omoɨna meineiacadɨnona jacɨruiñeno. Omoɨ abɨna meineredɨmacɨ; ie iadedɨ omoɨ joreñona meinenidɨmacɨ. Omoɨna naimacɨ meinia, omoɨ joreño Jusiñamui dɨne jaite. Iena uiñuamona, omoɨ meineiacadɨnona jacɨruiñeno. ");
INSERT INTO huuNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Cue rafuedo omoɨ raise jaiñenia, Jusiñamuina jacɨrui. Omoɨ fiodailla mei, omoɨ abɨna omoɨ joreño dɨga iraimo ie dotalle uai naimɨemo ite. Ie jira naimɨena jacɨrui. ");
INSERT INTO huuNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ero, dabecuiro janorede sillina fecadomoɨna, eo janore ɨbaca. Silliñɨaɨ eo janore raifide; iadedɨ Jusiñamui naimacɨ illana uiñote. ");
INSERT INTO huuNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ero, nɨga ɨfotɨraɨ omoɨmo illana Jusiñamui jɨaɨ uiñote. Naimɨedɨ omoɨna sedajana jɨaɨ uiñote. Silliñɨaɨ baɨfemo Jusiñamui isiruigaomoɨ. Omoɨ duere fɨnoacadɨnona jacɨruiñeno. Jusiñamui jitaiñenia, omoɨmo jaca buena suiñeite. ");
INSERT INTO huuNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Ie llofueoicaiganomo Jesús nia llote: —Cue rafuena omoɨ lluamona, jɨaɨno omoɨna duere fɨnoitɨmacɨ. Cuena birui omoɨ janoñenia, nana comɨnɨ Jusiñamui jaɨenisaɨ uicomo ɨco ia, nainomo omoɨna janoñeitɨcue. “Cue comɨnɨdomoɨ” omoɨna raitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Cuena birui omoɨ janoia, nana comɨnɨ Jusiñamui jaɨenisaɨ uicomo ɨco ia, nainomo omoɨna janoitɨcue. “Cue comɨnɨñedomoɨ” omoɨna raitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Jusiñamuidɨ naga cuena jeare ñaɨtɨmɨe jeacɨnona feitarede; iadedɨ Jusiñamuidɨ ie Joreñona jeare ñaɨtɨmɨe jeacɨnona feitañeite. ");
INSERT INTO huuNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Cue rafuena omoɨ llua muidona, duere sefuitomoɨ. Illaɨcomɨnɨ dɨne omoɨna llogɨdollena comɨnɨ uia, omoɨ abɨ rɨidollɨcɨnomo omoɨ comecɨaɨna jarire facañeno. ");
INSERT INTO huuNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Naie facaiseconi Jusiñamui Joreño omoɨ abɨ rɨidollɨcɨnona uiñotaite. ");
INSERT INTO huuNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Nainomo ite comɨnɨmona damɨe Jesúmo llote: —Maestro, cue moo jai fiodailla mei, cue ama doforamɨe cue facaina ite rana cuemo iacaiñede. Naimɨemo llono, cuemo illena. ");
INSERT INTO huuNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jesús uai ote: —Juezñedɨcue. Bie isoide rafue cuemo duiñede. ");
INSERT INTO huuNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ie ecɨmo itɨnomo llote: —Ero, rana nɨcɨdoñeno. Ailluena ra omoɨmo illamona, Jusiñamui illanomo riñeitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Iena omoɨ raise uiñollena, jɨaɨe rafuedo iena lloitɨcue. Ucuberedɨmɨedɨ ie illɨmona ailluena rana ote. ");
INSERT INTO huuNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ie jira comecɨna facade: “Cue illɨmona ailluena rana otɨcue; iadedɨ ¿nɨnomo iena eenoitɨcue? ");
INSERT INTO huuNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Birui cuemo ite eenoracona judaɨitɨcue. Ie mei aillue eenoracona fɨnoitɨcue. Nainomo cue rana eenoitɨcue”. ");
INSERT INTO huuNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ie comecɨna facaite: “Cuemo ailluena ra jai ite. Dɨga años nia iitɨcue. Jamai iitɨcue. Marena guitɨcue. Caɨmare iitɨcue”. ");
INSERT INTO huuNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Iese comecɨna facade; iadedɨ Jusiñamui naimɨemo llote: “Abɨ uiñoñedɨo. Cue llua jira, ja naɨona fiodaitɨo. Ie mei omo ite ra omo fɨebiñeite”. ");
INSERT INTO huuNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Dama ramo ie comecɨna bu facaia, Jusiñamui jitaillacɨnomo ie comecɨna bu facañenia, faɨfite. ");
INSERT INTO huuNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ie llofueoicaiganomo Jesús llote: —Jusiñamui jitaillacɨnomo omoɨ comecɨna facaia, omoɨ illamo omoɨ comecɨna jarire facañeitomoɨ. Bue omoɨ guillemo jarire comecɨna facañeno. Omoɨ jɨtalle ɨniroimo jarire comecɨna facañeno. ");
INSERT INTO huuNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Jusiñamui omoɨna itataja muidona, guille omoɨmo iite. Naimɨe omoɨ abɨ fɨnua muidona, ɨniroidɨ omoɨmo iite. ");
INSERT INTO huuNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Silliñɨaɨmo comecɨna faca. Buena riñedɨmacɨ. Nɨe isoide guillena eenoñedɨmacɨ; iadedɨ omoɨ Moo Jusiñamui naimacɨna sedajamona, naimacɨ guille ite. Naimacɨ baɨfemo omoɨ faɨa jira, naimɨe omoɨna canoite. ");
INSERT INTO huuNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Omoɨmona, ¿bu ie comecɨ jarire facajamona a sairite? Iese jaca buna a sairiñede. Dama Jusiñamui omoɨna a sairitarede. ");
INSERT INTO huuNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Omoɨ comecɨaɨna facajamona omoɨ a sairiñena jira, jɨaɨe ramo omoɨ comecɨaɨna jarire fɨnoñeno. ");
INSERT INTO huuNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Safiamo omoɨ comecɨaɨna faca. ¿Nɨese sɨcodɨmacɨ? Maɨjɨñedɨmacɨ. Ɨniroina tɨforiñedɨmacɨ; iadedɨ Salomón mɨcorɨ naimacɨ isoi jaie iñede. Naimɨe illaɨmana jira, naimɨe mɨcorɨ ɨniroi eo ebirede; iadedɨ safia naimɨe ɨniroi baɨfemo ebire eruaɨde. ");
INSERT INTO huuNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Jusiñamui safiana ebiretacabide. Dallu facaise illanona, safiadɨ duide. Safia baɨfemo omoɨ uailla jira, Jusiñamuidɨ ɨniroina omoɨmo jaca iite. Safiana naimɨedɨ ebiretaja muidona, omoɨmo ɨniroidɨ jaca iite. Omoɨ ra omoɨmo illena, naimɨena ɨɨno. Jusiñamuina eo janore ɨɨnotomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Omoɨ comecɨaɨna jarire icana jaiñeno. “¿Buena guitɨcaɨ?” raiñeno. Iemo comecɨaɨna eo facañeno. ");
INSERT INTO huuNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Jusiñamuina ɨɨnoñedɨno iemo comecɨna facacabidɨmacɨ. Nana omoɨ jitaillacɨnona omoɨ Moo Jusiñamuidɨ uiñua jira, naimacɨ isoi iñeno. ");
INSERT INTO huuNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Jusiñamui jitaillacɨnona fɨnocana omoɨ jai. Naimɨemo omoɨ comecɨ facaia, omoɨ illamo omoɨ comecɨna jarire facañeitomoɨ. Iemona guille omoɨmo Jusiñamui iite. Ɨniroi omoɨmo jɨaɨ iite. ");
INSERT INTO huuNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Jesús llote: —Cue comɨnɨna omoɨ illanona, uri omoɨ i. Omoɨ Moo Jusiñamui jitailla jira, naimɨe anamo omoɨna itatajamona, omoɨna sedaite. ");
INSERT INTO huuNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Omoɨ raruiaɨna fecajanona, ucubena dueredɨnomo feca. Sabiñeite bolsana ono, omoɨ ra faɨfi raillano. Monamo omoɨ ra illa isoi ñaɨtɨcue. Monamo omoɨ ra illa isoi, iena faɨfiñeitomoɨ. Fɨɨriraɨma nainomo jaiñede. Gɨɨreco nainomo jɨaɨ iñede. ");
INSERT INTO huuNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Aillue ra omoɨmo ia, Jusiñamuimo comecɨaɨna facañedomoɨ; iadedɨ naimɨe jitaillacɨnona omoɨ fɨnoia, naimɨemo comecɨaɨna facadomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","38","Jesús nia llofuete: —Monamona ɨco cue abɨdo billemo ocuiri. Iena omoɨ raise cacaillena, bie rafuedo iena lloitɨcue. Damɨe ie nabai ie aɨ ua rafue dɨne naɨona jaide. Ie mullaɨaɨ naimɨe abɨdo billemo ocuirillana ocuide. Naimɨe billemo naimacɨ raise ocuiria, ɨniroina jɨtajanona, lamparínɨaɨ unianona, ocuiritɨmacɨ. Iese naimacɨ ia, nasena naimɨe tuia, iena raɨre econoitɨmacɨ. Nɨe hora naimɨe abɨdo bia, naimɨena naimacɨ ɨnɨñeno ocuiria, ieri naimɨe iobite. Iobillamona, mullaɨmana naimɨe itena, mesamo naimacɨna ecaite. Naimɨe bille hora naimacɨ uiñoñena jira, jaca ocuiricana naimacɨ illa. ");
INSERT INTO huuNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ero, fɨɨriraɨma bille facaiseconi jofo namadɨ uiñotena, nia caadote, ie ra faɨfi raillanona. ");
INSERT INTO huuNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Monamona ɨco abɨdo biitɨcue. Omoɨ ocuiriñena facaisemo biitɨcue. Ie jira cue billemo raise ocuiri. ");
INSERT INTO huuNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ie como lloga rafuena cacajano, Jesúmo Pedro jɨcanote: —¿Bumo bie rafuena llotɨo? ¿Caɨmo llotɨo? ¿Nana comɨnɨmo? ");
INSERT INTO huuNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Uai ote: —Bie isoide comɨnɨmo llotɨcue. Ie mullaɨaɨmona patrón damɨena fetode, ie jɨaɨe mullaɨaɨna sedallena. Naimacɨna sedajanona, naimɨe naimacɨna jɨaɨ ecade. ");
INSERT INTO huuNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ie mei patrón oni jaide. Jofomo abɨdo naimɨe bia, ie nanoca mullaɨma raise maɨjɨana fɨdɨia, naimɨena raise ɨbaite. ");
INSERT INTO huuNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Iobillamona, nana ie raruiaɨna sedataite; ");
INSERT INTO huuNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","iadedɨ naie mullaɨma maraiñenia, comecɨna facaite: “Cue patrón are biñeite. Jɨaɨe rafuena fɨnoitɨcue”. Ie comecɨna iese facaja jira, naimɨe anamo ite mullaɨaɨna faite. Ie jitailla rafue fɨnuamona, jɨfairuidɨno dɨga jirocabite. Naimacɨna nabaillamona, naimacɨ dɨga guite. Naimacɨ isoi jearede rafuena fɨnoite. ");
INSERT INTO huuNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ie ocuiriñena facaise ie patrón abɨdo billanona, naimɨena meinetaite. Ie uaina ɨɨnoñedɨno isoi, duere fɨnoite. ");
INSERT INTO huuNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Naie mullaɨma ie patrón jitailla rafuena fɨnuana uiñote; iadedɨ iena fɨnoñede. Ie jira eo duere sefuite; ");
INSERT INTO huuNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","iadedɨ maraiñede rafuena raise uiñoñeno jɨaɨe mullaɨma fɨnoia, janore duere sefuite. Ie isoide. Jusiñamui rafuena raise uiñotɨno iedo raise jaiñenia. Jusiñamui naimacɨna eo duere fɨnoite. Iena janore uiñotɨno iedo raise jaiñenia, Jusiñamui naimacɨna janore duere fɨnoite. Iese omoɨmo suiñellena, mare mullaɨma isoi, Jusiñamui jitaillacɨno fɨnocana omoɨ jai. ");
INSERT INTO huuNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Jesús llote: —Cuena naimacɨ ɨɨnollena, enɨruemo comɨnɨ dɨne bitɨcue. Cuena dajerie ɨɨnuamona, cue comɨnɨna jaitɨmacɨ. Cuena jɨaɨno ɨɨnoñenamona, cue comɨnɨna jaiñeitɨmacɨ. Iemona comɨnɨna duere fɨnoitɨcue. Cue maɨjɨa raɨre fuiduana jitaidɨcue. ");
INSERT INTO huuNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Cue nia eo duere sefuitɨcue. Iena raɨre suillena jitaidɨcue. ");
INSERT INTO huuNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Nana comɨnɨna uri itatallena enɨruemo biñedɨcue. Cuena ɨɨnoñedɨnodɨ cuena ɨɨnotɨnona enoitɨmacɨ. Enoillamona, cuena ɨɨnotɨnona duere fɨnoitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Cue billamona, daje jofomo itɨno dɨese danomo iñeitɨmacɨ. Dabecuiro comɨnɨ nainomo ia, menamɨe cue dɨbeimo iite. Daje amani cue dɨbeimo iñeite. Iese iñenia, daje amani cue dɨbeimo iite. Mena cue dɨbeimo iñeite. ");
INSERT INTO huuNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Cue lloga rafuena damɨerie ɨɨnua muidona, ie moo illa dɨbeimo ie jito iñeite. Ie jito dɨbeimo ie moo iñeite. Ie ei illa dɨbeimo naiñaiño jisa iñeite. Ie jisa dɨbeimo ie ei iñeite. Ie jɨfaiño illa dɨbeimo ie miodɨ iñeite. Ie mio dɨbeimo ie jɨfaiño iñeite. Iese comɨnɨna uri itatañedɨcue. ");
INSERT INTO huuNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Comɨnɨmo Jesús dane llote: —Bie enɨruemo afai dɨne uillɨena omoɨ cɨoia, raicabitomoɨ: “Nocɨ deiacade”. Iese omoɨ cɨua meinomo, ua nocɨ deide. ");
INSERT INTO huuNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Bie enɨruemo beicɨ dɨnena aɨfɨ bia: “Eo ecasiite” raicabitomoɨ. Iese aɨfɨ bia, ua eo ecasite. ");
INSERT INTO huuNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Abɨna uiñotɨnona abɨ caitadɨnodomoɨ. Monamo eruaɨllamona, rafue suillana uiñotomoɨ; iadedɨ omoɨ ecɨmo suiacalle rafuena raise uiñoñedomoɨ. Cue lloga rafuena raise cacaiñedomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Iemo omoɨ comecɨaɨna raise facañedomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ero, omoɨna bu llogɨdoia, juez dɨne nia omoɨ riñenia, omoɨna llogɨdotɨmɨe dɨga naie rafuena raise fɨno. Iena raise fɨnoñenia, juez dɨne omoɨ ria, nainomo duere sefuitomoɨ. Calabozomo omoɨna jonetaite. ");
INSERT INTO huuNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Nana raise ɨbañenia, juez llua isoi, jino jaiñeitomoɨ. Ie isoide. Cue rafue omoɨ cacajamona, naimɨemona duere sefuiñellena, Jusiñamui dɨga omoɨ rafuena raise fɨno. ");
INSERT INTO huuNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Comɨnɨna Jesús nia llofuetemo, jɨaɨe comɨnɨ Jesús dɨne billanona, raitɨmacɨ: —Jerusalémo Jusiñamui jofomo dajerie Galileamona navui bitɨmacɨ. Ocainaɨaɨna fatɨmacɨ, Jusiñamuina naimacɨ sedallena. Ie facaiseconi Pilato railla gobernadordɨ soldaduaɨna orede, naie comɨnɨna fallena. ");
INSERT INTO huuNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jesús uai ote: —¿Nɨese comecɨaɨna facadomoɨ? “Bie comɨnɨ iese duere sefuilla jira, jɨaɨe Galilea comɨnɨ baɨfemo jeacɨnona fɨnodɨmacɨ” comecɨaɨna facadomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Iese omoɨ comecɨaɨna facañeno; ia omoɨ comecɨaɨ iuai meiduamo comecɨaɨna faca. Omoɨ comecɨaɨ iuai omoɨ meidoñenia, omoɨdɨ jɨaɨ faɨfitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Siloé railla tɨdacana navui ana goillamo, dieciocho dɨgamɨe saitabidɨmacɨ. Iena fɨdɨdomoɨ. ¿Nɨese naimacɨmo omoɨ comecɨaɨna facadomoɨ? “Nana Jerusalémo ite comɨnɨ baɨfemo jeacɨnona fɨnodɨmacɨ” comecɨaɨna facadomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Iese omoɨ comecɨaɨna facañeno; ia omoɨ comecɨaɨ iuai meiduamo comecɨaɨna faca. Omoɨ comecɨaɨ iuai omoɨ meidoñenia, omoɨdɨ jɨaɨ faɨfitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Iena comɨnɨ raise uiñollena, Jesús bie rafuena llote: —Damɨe ie illɨmo higuera railla riarana rite. Sɨcua mei, riara ollena jɨbuisaide; iadedɨ nia llɨsiñede. ");
INSERT INTO huuNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ie jira ie illɨna sedaraɨmamo llote: “Ero, daje amani años bisoidɨcue, riarana ollena. Nia llɨsiñede. Iena mai tɨe. Naie illanomo jɨaɨe riarana coco rillesa”. ");
INSERT INTO huuNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ie illɨna sedaraɨma uai ote: “Dama ite. Daje año nia seda. Riara abɨna caigɨitɨcue. Enɨruena caɨmaretaitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Jɨaɨe año llɨsia, mare. Llɨsiñenia, iena tɨeitɨcoco”. Ie isoide. Jusiñamui omoɨ comecɨaɨ iuai meiduamo are ocuirite; ia meidoñenia, omoɨna duere fɨnoite. ");
INSERT INTO huuNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Jɨaɨruido sábadoruimo judíuaɨ ofiracomo Jesús llofuete. ");
INSERT INTO huuNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Nainomo duidɨñaiñodɨ ite. Janaba anamo naiñaiño illa jira, naiñaiño jɨicaide. Atona naidainide. ");
INSERT INTO huuNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Naiñaiñona Jesús cɨuanona, naiñaiñomo llote: —Ñoo, o duicomona jai jillodɨo. ");
INSERT INTO huuNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","—Ie mei naiñaiñona jetade. Ieconi naiñaiño atona naidadate. Ie jira Jusiñamuimo iobillacɨnona fecade. ");
INSERT INTO huuNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Naie ofiraco sedaraɨma icɨrite, sábadoruimo Jesús naiñaiñona jillotaja jira. Nainomo itɨnomo llote: —Seis dɨgarui ite maɨjɨllena. Nairuido omoɨ bi, omoɨ duicomona omoɨ jilloillena. Sábadoruimo biñeno. Sábadoruimo maɨjɨñedɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Jesús uai ote: —Maɨjɨñedɨnona abɨ caitadɨnodomoɨ. Sábado iruimo maɨjɨcabidomoɨ. Sábado iruimo omoɨ toɨnɨaɨna imacɨ illanomona suiñodomoɨ, jɨnui illanomo naimacɨ jiruaillena. Naie isoide maɨjɨa omoɨmona mare. ");
INSERT INTO huuNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ie isoide. Bie rɨñodɨ Abraham mɨcorɨ comɨnɨ. Omoɨ naɨraɨ iñaiño. Dieciocho años Janaba anamo jai illamona, duere sefuide. Naiñaiñona canollena, sábado iruimo naiñaiñona Taɨfe anamona cue jillotaia, cuemona mare. ");
INSERT INTO huuNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Iena Jesús lluamona, nana naimɨe dɨbeimo iñedɨnodɨ meidaitɨmacɨ; iadedɨ jɨaɨe comɨnɨ iobidɨmacɨ, dɨga mare rafue naimɨe fɨnua jira. ");
INSERT INTO huuNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jesús jɨaɨe rafuena llote: —Jusiñamui dɨbeimo comɨnɨ jailla rafuena nia lloitɨcue. Jusiñamui rafuena janore comɨnɨ birui cacajamona, ailluena comɨnɨ naimɨe comɨnɨna ɨco jaitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Jɨaɨe rafuedo iena omoɨmo lloitɨcue. Mostaza railla ido eo janorede. Ie illɨmo damɨe iena rillamona, eo aillue riaradɨ sɨcode. Ailluena jira, nainomo silliñɨaɨ jɨcaicɨaɨna fɨnodɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Jesús jɨaɨe rafuena llote: —Jusiñamui dɨbeimo comɨnɨ jailla rafuena lloitɨcue. Jɨaɨe uaido iena omoɨmo lloitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Daje cɨrɨgaɨ raifi coremo sɨritate ra faɨanona, namo tameia sɨritate. Ie isoide. Ailluena comɨnɨ iena cacaillena, Jusiñamui rafue llocana jaite. ");
INSERT INTO huuNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jesús dɨga naɨraɨmo llofuecana jaide. Jerusalén dɨne jaide. ");
INSERT INTO huuNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Jesús oni jaillanona, damɨe naimɨemo jɨcanote: —Nama, ¿nɨga comɨnɨ o uaina ɨɨnoitɨmacɨ? —Jesús uai ote: ");
INSERT INTO huuNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Monamo cue Moo dɨne jaille nasedɨ janorede isoide. Naie nasedo lliicana o jai. Ailluena comɨnɨ naiedo jaiacanitɨmacɨ; iadedɨ fo jainitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Naie jofo nama nase ɨbailla mei, ¿nɨese fo jaitomoɨ? Jino naidaillamona, nasena tutajanona, raitomoɨ: “Nama, o nase econo”. Naimɨe uai oite: “Omoɨna uiñoñedɨcue”. ");
INSERT INTO huuNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Dane lloitomoɨ: “O dɨga navui guitɨcaɨ. Caɨ illanomo llofuetɨo”; ");
INSERT INTO huuNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","iadedɨ naimɨe uai oite: “Omoɨna uiñoñedɨcue. Cue comɨnɨñedomoɨ. Jeacɨno omoɨ comecɨmo nia illa jira, mai jai”. ");
INSERT INTO huuNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Jusiñamui illanomo Abraham mɨcorɨna, Isaac mɨcorɨna, Jacob mɨcorɨna, nana Jusiñamui facaina lloraɨnɨ mɨcorɨaɨna cɨoitomoɨ; ia omoɨ jino illamona, duere sefuillamona, eeitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Dɨga comɨnɨ Jusiñamui illanomo iitɨmacɨ. Ailluena judíuaɨñedɨno naga naɨraɨaɨmona Jusiñamui illanomo biitɨmacɨ. Nainomo coninɨna caɨmare nabaitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Naga naɨraɨmona Jusiñamui comɨnɨna jillotarede. Cue rafuena cacadomoɨ; ia cue comɨnɨna omoɨ jaiacania, abɨ ɨedoñeno cuena ɨɨnocana omoɨ jailla. ");
INSERT INTO huuNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ie facaiseconi dajerie fariseuaɨ comɨnɨ Jesús dɨne billano raitɨmacɨ: —Benomona mai o jai. Caɨ illaɨma Herodes ona meineiacade. ");
INSERT INTO huuNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jesús uai ote: —Herodedɨ eo jɨfueraɨma. Naimɨe dɨne jai. Naimɨemo llono: “Janaba anamo ite comɨnɨmona Janabana oni orecabidɨcue. Duidɨnona jillotacabitɨcue. Birui siño rafuena fɨnocabidɨcue. Ɨco iese nia fɨnoitɨcue. Iese cue maɨjɨlle fuite. ");
INSERT INTO huuNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Nia oni jaitɨcue. Ailluena Jusiñamui facaina lloraɨnɨ mɨcorɨaɨ nainomo jai fiodailla isoi, Jerusalémo cue rafue jɨaɨ raɨre fuite” llono. ");
INSERT INTO huuNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Jerusalémo itɨnomo comecɨna facajano, Jesús llote: —Jerusalémo itɨno, omoɨmo rafuena lloiacadɨcue. Jusiñamui facaina lloraɨnɨna jaie meinetomoɨ. Naimɨe omoɨ dɨne oretaganona nofɨcɨna faɨrɨnuano, naimacɨna meinetomoɨ. Omoɨna cue sedallena, atava ie uruiaɨ sedaja isoi, dɨga icaiño cue anamo omoɨna uaidoiacadɨcue; iadedɨ omoɨ dɨnena cuena jitaiñedomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Iemona Jusiñamuidɨ omoɨ illanona jai faɨnonocaide. Cue Moo dɨne jaitɨcue. Cue jailla mei, cuena cɨoiñeitomoɨ. Ɨco cue abɨdo bia, comɨnɨ cuena lloitɨmacɨ: “Jusiñamui oretagamɨe eo mare. Naimɨedɨ caɨ Nama” lloitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Jɨaɨruido sábadoruimo Jesúdɨ fariseo imɨe jofomo guisaide. Naie fariseo imɨedɨ illaɨcomɨnɨ. Nainomo itɨno Jesúmo eo eruaɨdɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Guille facaise naie jofomo duidɨmɨe bite. Naimɨe abɨna sɨridɨmɨe. ");
INSERT INTO huuNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Nainomo itɨnomona damɨeriedɨ fariseuaɨ comɨnɨ. Moisés mɨcorɨ llogacɨnuaɨna llofueraɨnɨ jɨaɨ itɨmacɨ. Naimacɨmo Jesús jɨcanote: —Sábadoruimo comena cue jillotaia, ¿omoɨmona jeacɨno fɨnodɨcue? ¿Nɨese Moisés mɨcorɨ llogacɨnuaɨ iena llote? ");
INSERT INTO huuNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Uaina oñedɨmacɨ. Ie jira Jesús duidɨmɨe onollɨna llɨnuamona, naimɨena jillotate. Ie mei naimɨena jino orede. ");
INSERT INTO huuNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Nainomo itɨnomo llote: —Sábadoruimo maɨjɨcabidomoɨ. Sábadoruimo omoɨ jurareta pozomo uaidena, iena jillotallena, nairuimo iena arɨ otomoɨ. Omoɨmona naie isoide maɨjɨa mare. Bimɨena cue jillotaja jira, ¿nɨese cuena jeare ñaɨtomoɨ? ");
INSERT INTO huuNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Iena cacajanona, uainicaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jesúdɨ naimacɨ guisaɨbillana cɨode. Jɨaɨno baɨfemo illena, jofo nama abɨmo nana raɨacadɨmacɨ. Iena cɨuamona, naimacɨmo Jesús rafuena llofuete: ");
INSERT INTO huuNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Rafue dɨne guillena omoɨna bu uaidoia, jofo nama abɨmo raɨñeno, omoɨ baɨfemo itɨmɨe bi raillano. ");
INSERT INTO huuNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Jofo nama abɨmo omoɨ raɨa, omoɨ baɨfemo itɨmɨe bia, jofo nama omoɨmo lloite: “Bimɨemo omoɨ raɨllanona feca”. Meidaillanona, oni raɨnadaitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ie jira rafue dɨne omoɨna uaidoia, naie jofomo omoɨ ria, oni raɨ. Ie mei jofo nama jitaia, omoɨmo lloite: “Cue abɨmo raɨ”. Ie mei nana naie itɨno omoɨ iobillana cɨoitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ie isoide. Jusiñamuidɨ jɨaɨmɨe afemo iacadɨmɨena jɨaɨmɨe afemo iñenana itataite. Jusiñamuidɨ jɨaɨmɨe afemo iacaiñedɨmɨena jɨaɨmɨe afemo itataite. ");
INSERT INTO huuNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Naimɨena uaidotɨmɨemo Jesús llote: —Guille rafuena o fɨnoia, naga icaiño o nabaiñɨaɨna uaidoñeno. Naga icaiño o comɨnɨna uaidoñeno. Naga icaiño o ecɨmo itɨno ucuberedɨnona uaidoñeno. Naimacɨna o uaidotɨona, jɨaɨruido guillena ona uaidoitɨmacɨ, naie ɨba o ollena; ");
INSERT INTO huuNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","ia rafuena o fɨnoia, dueredɨnona uaido. Ñuja-ñujacaida macaritɨnona uaido. Uisɨnidɨnona uaido. ");
INSERT INTO huuNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Naimacɨmona ɨba ɨco o oñenamona, Jusiñamui ona caɨmare itataite. Jɨaɨruido fiodaillamona mareuidɨno jilloia, monamo Jusiñamui ona ɨbaite. ");
INSERT INTO huuNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Jesús abɨmo itɨnomona Jesús lluana damɨe cacajano, raite: —Monamo Jusiñamui illanomo itɨmɨedɨ marena iite. ");
INSERT INTO huuNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jesús uai ote: —Iena omoɨ raise uiñollena bie rafuena lloitɨcue. Damɨe aillue rafuena fɨnode. Ailluena comɨnɨna uaidote. ");
INSERT INTO huuNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Rafue illaruimo ie mullaɨmana orede, comɨnɨna dane uaidollena. Raite: “Mai bi. Nana guille fɨnuadɨ jai fuite”; ");
INSERT INTO huuNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","ia biacaiñedɨmacɨ. Damɨe llote: “Enɨruena como ɨbadɨcue. Iena jɨbuisaiacadɨcue. O rafuemo jaiñeitɨcue. Ie jira cue joreñona icɨñeitɨosa”. ");
INSERT INTO huuNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Jɨaɨmɨe llote: “Diez dɨga juraretana como ɨbadɨcue. Naimacɨna jɨbuisaiacadɨcue. O rafuemo jaiñeitɨcue. Ie jira cue joreñona icɨñeitɨosa”. ");
INSERT INTO huuNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Jɨaɨmɨe llote: “Rɨño como otɨcue. Ie jira o rafuemo jaiñeitɨcue”. ");
INSERT INTO huuNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ie nama dɨne naie mullaɨma abɨdo jaide. Comɨnɨ biacaiñenana llote. Iena cacajano, rafue namadɨ icɨrite. Ie mullaɨmamo llote: “Caɨ naɨraɨ naɨsona jai. Dueredɨnona uaido. Ñuja-ñujacaida jaidɨnona uaido. Uisɨnidɨnona uaido”. ");
INSERT INTO huuNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ie mei naie mullaɨma jaide. Abɨdo naimɨe bia, ie namamo llote: “O lluana fɨnodɨcue. Ailluena comɨnɨ jai bitɨmacɨ. O jofomo illɨno nia ite”. ");
INSERT INTO huuNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Rafue namadɨ uai ote: “Naɨsomo itɨnona bene atɨllena, cue jofona oruitallena, caɨ naɨraɨmona jino jai. ");
INSERT INTO huuNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Cue nano uaidogano cue guillena guiñeitɨmacɨ”. Ie isoide. Jusiñamui rafuena feiñotɨno monamo Jusiñamui illanomo ɨco iitɨmacɨ; ia naimɨe rafuena jitaiñedɨno nainomo ɨco iñeitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Naie facaise ailluena comɨnɨ Jesús dɨga jai jaisoidɨmacɨ. Naimacɨmo llote: ");
INSERT INTO huuNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Cue llofuegamɨena jaiacadɨmɨe cuena ie moo baɨfemo isiruilla. Cuena ie ei baɨfemo isiruilla. Cuena ie aɨ baɨfemo isiruilla. Cuena ie uruiaɨ baɨfemo isiruilla. Cuena ie amatɨaɨ baɨfemo isiruilla. Cuena ie mirɨñotɨaɨ baɨfemo isiruilla. Cuena ie abɨ baɨfemo isiruilla. Iese cuena isiruiñenia, cue llofuegamɨena raise jainide. ");
INSERT INTO huuNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Cue llofuegamɨena bu jaillamona, duere sefuicana jaite. Nɨbaɨ naiemona fiodaite. Bu iese jaiacaiñenia, cue llofuegamɨena naimɨe raise jainide. ");
INSERT INTO huuNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","’Ero, jɨaɨe rafuedo iena lloitɨcue. Jofona bu fɨnoacania, ie ucubena bailla dɨese uiñollena: “¿Nɨga raifite?” comecɨna nano facade. ");
INSERT INTO huuNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Iese naimɨe comecɨna facañenia, goguiraɨ naidania mei, ie ucube riñenia, taiguanona, naimɨeri jaɨsitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Raitɨmacɨ: “Ie jofo fɨnua taɨnede; iadedɨ fuidonide”. ");
INSERT INTO huuNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","’Ero, jɨaɨe rafuedo iena lloitɨcue. Illaɨma jobaimena fɨnoacania, nano comecɨna facade: “Cuemo ite diez mil soldaduaɨ. Cue bacauaimo ite veinte mil soldaduaɨ. ¿Nɨese emodofitɨcue?” Comecɨna facaja mei: “Emodofiñeitɨcue” naimɨe comecɨna facajia, ");
INSERT INTO huuNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","nia are naimɨe bacauai ia, daguelli uicodo orede, ie faɨriconɨ dɨga ñaɨllena. Raite: “Jobairiacaiñedɨcue; ia o dɨga bie rafuena raise fɨnoacadɨcue”. ");
INSERT INTO huuNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Biemo comecɨna omoɨ faca. Ie raruiaɨmo bu comecɨna eo facaia, cue llofuegamɨena jainide. ");
INSERT INTO huuNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","’Sal mare; iadedɨ ie caɨmano jai iñenia, ¿dane nɨese nɨbaɨamona caɨmarenite? ");
INSERT INTO huuNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Jai maraiñede. Enɨruemo jonegadena, jɨaɨ maraiñede. Oni dotaca. Ie isoide. Cue llua isoi omoɨ iñenia, cue llofueganona jainidomoɨ. Omoɨ jeforena jira, raise fueollena, cue lluamo cacarei. Iena ɨɨno. ");
INSERT INTO huuNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Naimacɨ bisoilla isoi ie rafuena cacaillena, dɨga gobierno ucubena oraɨnɨ Jesús dɨne ofidɨmacɨ. Jusiñamui llogacɨnona raise jaiñedɨno jɨaɨ ofidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Iena cɨuano, fariseuaɨ comɨnɨdɨ, Moisés mɨcorɨ llogacɨnuaɨna llofueraɨnɨ dɨga, Jesús joreñona ñaɨtɨmacɨ: —Bimɨe maraiñedɨcɨnona fɨnoraɨnɨna feiñote. Naimacɨ dɨga jɨaɨ guite. ");
INSERT INTO huuNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Naimacɨ ñaɨana uiñuanona, Jesús naimacɨmo bie rafuena llote: ");
INSERT INTO huuNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Omoɨmona damɨemo cien toɨca llaudaɨaɨ nɨbaɨ ite. Naimacɨmona daje feiraite. Ie noventa y nueve llaudaɨaɨna faɨnonocaida, iena jenuaite, ie baille dɨnori. ");
INSERT INTO huuNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Baillanona, ie fecanicomo rocanocaida, iobicana biite. ");
INSERT INTO huuNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Jofomo naimɨe ria, ie nabaiñɨaɨna uaidoite. Ie ecɨmo itɨnona jɨaɨ uaiduanona, raite: “Cue dɨga iobi. Cue feiraite llaudana jai baitɨcue”. ");
INSERT INTO huuNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ie isoide. Cue rafuena cue lluamona, damɨe ie comecɨ jeacɨnona faɨnonocaillamona, ie comecɨ iuai meiduamona, monamo itɨno eo iobitɨmacɨ; iadedɨ noventa y nueve comɨnɨ marena illamona, janore iobitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Jesús llote: —Jɨaɨe rafuena omoɨmo lloitɨcue. Dañaiñodemo diez dɨga ucube ite. Naiemona daje ucube naiñaiño faɨfia, lamparín unianona, ie jofona gallaite. Eo jenoite, ucube ie baille dɨnori. ");
INSERT INTO huuNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Iena naiñaiño baia, ie nabaiñɨaɨna uaidoite. Ie ecɨmo itɨnona jɨaɨ uaiduanona, raite: “Cue dɨga iobi. Cue faɨfide ucubena jai baitɨcue”. ");
INSERT INTO huuNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ie isoide. Cue rafuena cue lluamona, damɨe ie comecɨ jeacɨnona faɨnonocaillamona, ie comecɨ iuai meiduamona, Jusiñamui jaɨenisaɨ eo iobidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jesús llote: —Jɨaɨe rafuena omoɨmo lloitɨcue. Damɨemo mena jito ite. ");
INSERT INTO huuNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ie moomo jamamɨe llote: “Moo, o fiodailla mei, o raruiaɨmona janore feiñoitɨcue. O fiodaillana sedaacaiñedɨcue. O raruiaɨna cue facaina birui jitaidɨcue. Cuemo ine”. Ie jira ie moo naimɨemo fecade. ");
INSERT INTO huuNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ie mei nano nɨe dɨnori illamona, nana ie raruiaɨ ɨraɨanona, jɨaɨe enɨruemo jaide. Nainomo ie ucube jamai buruemo faɨaide. ");
INSERT INTO huuNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Nana naimɨe ucube fuidua facaise, naie enɨruemo guille iñede. Aime guitɨmacɨ. Naimɨe jɨaɨ aime guite. ");
INSERT INTO huuNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ie jira nainomo ite patrón dɨne maɨjɨaide. Naie patrón ie chanchuaɨna sedallena naimɨena orede. ");
INSERT INTO huuNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Naimɨena jaca buna ecaraɨnina jira, chanchuaɨ guillemona guiacade. ");
INSERT INTO huuNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Iese naimɨe duere sefuilla jira, ja muidomo abɨna uiñocaillamona, comecɨna facade: “Cue moo jofomo nana naimɨe mullaɨaɨ raise guitɨmacɨ. Guille fɨebicabite; iadedɨ bene aimeri fiodaitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Cue moo dɨne abɨdo ja jaitɨcue. Naimɨemo lloitɨcue: Jusiñamuimo jeacɨnona fɨnodɨcue. Omo jeare jɨaɨ fɨnodɨcue. ");
INSERT INTO huuNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Odɨ: ‘Cue jito’ cuena raiñeno. O mullaɨaɨ illa isoi, cuena abɨdo feiño”. ");
INSERT INTO huuNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ie facaise ie moo dɨne jai jaide. Nia aare naimɨe ia, ie moo naimɨena cɨode. Ie jitona duenaillanona, naimɨe dɨne aisɨde. Naimɨena caɨmadote. Jɨaɨ llibanote. ");
INSERT INTO huuNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ie jito naimɨemo llote: “Moo, Jusiñamuimo jeacɨnona fɨnodɨcue. Omo jeacɨno jɨaɨ fɨnodɨcue. Odɨ: ‘Cue jito’ cuena raiñeno”. ");
INSERT INTO huuNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ie moo iena cacajano, ie mullaɨaɨmo llote: “Cue jitona naimɨe eruaɨllena, eo mare ɨniroina atɨ, naimɨe jɨtallena. Cue jitona naimɨe illa jira, iena jɨtallena, anillona atɨ. Naimɨe jɨtallena, zapatona jɨaɨ atɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Janoreta faredɨretana fano. Iena raise fɨnuanona, iena mai caɨ guillɨ. Iobillamona, caɨmare ebirede rafuena fɨnoitɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Navui cuemona cue jito fiodaite isoide. Caje cuemo dane abɨdo rilla. Navui cuemona naimɨedɨ faɨfide; iadedɨ birui naimɨena dane cɨodɨcue”. Naimɨe llua isoi, rafuena fɨnodɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Naie facaise nano doforamɨe illɨmo ite. Jofomo abɨdo naimɨe bia, comɨnɨ ɨraɨsillana cacade. ");
INSERT INTO huuNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Daje mullaɨmana uaiduanona, naie rafuena jɨcanote. ");
INSERT INTO huuNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Naie mullaɨma uai ote: “O ama abɨdo jai bite. O ama ramo jiriñeno abɨdo billa jira, o moo ie janoreta faredɨretana jai fatatate”. ");
INSERT INTO huuNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Iena cacajano, icɨrite. Fo jaiacaiñede. Ie jira ie moo jino bite. Naimɨena fo uaidote. ");
INSERT INTO huuNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ie moomo llote: “Ero, dɨga años o dɨga maɨjɨdɨcue. O uaina jaca ɨɨnotɨcue; iadedɨ cue nabaiñɨaɨ dɨga, rafuena cue fɨnollena, chivo cuemo jaca fecañedɨo. ");
INSERT INTO huuNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","O jito jamamɨe ie ucube calliredɨñaiñuaɨmo fuidode; iadedɨ abɨdo naimɨe billano, naimɨe facaina janoreta faredɨretana fatatatɨo”. ");
INSERT INTO huuNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ie moo uai ote: “Moo, nagarui cue dɨga itɨo. Nana cue radɨ oɨenite. ");
INSERT INTO huuNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Cuemona o ama navui fiodaite isoide; iadedɨ naimɨena dane cɨodɨcue. Naimɨe navui faɨfide raitɨcue; iadedɨ caje cuemo dane abɨdo rilla. Cue iobillanona rafuena fɨnodɨcue”. Bie rafuemona omoɨ fueollena, iena jai llotɨcue —Jesús llote. ");
INSERT INTO huuNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ie llofueoicaiganomo Jesús jɨaɨe rafuena llote: —Ucuberede patrón ie mullaɨmana ie rana sedatate. Naie patrón eneno oni illanona, ie mullaɨma ie rana raise sedañenana fɨdɨde. ");
INSERT INTO huuNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Naimɨena uaiduanona, naimɨemo jɨcanote: “¿Maraiñede o fɨnoca rafuena nɨese fɨdɨdɨcue? Omo ite cuentas cɨoacadɨcue. Cuemo atɨ. Cue dɨga jai maɨjɨñeitɨo”. ");
INSERT INTO huuNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Iena cacajano, naie mullaɨma comecɨna facade: “¿Nɨese nɨbaɨitɨcue? Cue nama cuena jai dotaacade. Maɨjɨana ocuinidɨcue. Jɨaɨe comɨnɨmona ucube jamai jɨcajana meiruitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Cue fɨnuana jai uiñotɨcue. Naimacɨ jofomo comɨnɨ cuena ɨco feiñollena cue dotaja mei, nana cue patrón debedɨnona uaidoitɨcue”. ");
INSERT INTO huuNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ie jira naimacɨna uaidote. Damɨemo jɨcanote: “¿Cue patrómo nɨga debedɨo?” ");
INSERT INTO huuNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Uai ote: “Cien bidones raifi aceitunamona oga aceitena debedɨcue”. Naie mullaɨma raite: “O rabemo jarire ja cueno: cincuenta bidones”. ");
INSERT INTO huuNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Jɨaɨmɨemo jɨcanote: “¿Nɨga debedɨo?” Uai ote: “Cien dɨgagaɨ trigo raifi debedɨcue”. Naie mullaɨma dɨnena raite: “O rabemo ochentana cueno”. ");
INSERT INTO huuNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Iena fɨdɨano, naie mullaɨmamo ie patrón raite: “Jɨaɨruido marena o illemo o comecɨna raise facadɨo. Eo abɨna uiñotɨmɨedɨo” raite. Ero, Jusiñamuina ɨɨnoñedɨnodɨ naimɨena ɨɨnotɨno baɨfemo ra fecajana baitadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Naiemona omoɨ fueollena, omoɨmo lloitɨcue. Omoɨmo ite ra dɨga dueredɨnona cano. Iemona omoɨ nabaiñɨaɨna jaitɨmacɨ. Omoɨ fiodaia, omoɨ ra bene fɨebite; ia Jusiñamui illanomo naimacɨ dɨga omoɨ ia, naimacɨna birui omoɨ canuamona, nainomo omoɨna marena ñaɨtɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Janore ra omoɨmo illamona, Jusiñamui facaina birui omoɨ raise maɨjɨia, ailluena ra omoɨmo itedena, Jusiñamui facaina jɨaɨ raise maɨjɨitomoɨ. Janore ra omoɨmo illamona, maraiñede rafuena birui omoɨ fɨnoia, ailluena ra omoɨmo itedena, maraiñede rafue nia jɨaɨ fɨnoitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Omoɨmo birui ite ra dɨga Jusiñamui facaina omoɨ raise maɨjɨñenia, naimɨemona jɨaɨe rana feiñoñeitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Omoɨ anamo ite ra dɨga Jusiñamui facaina omoɨ raise maɨjɨñenia, Jusiñamui ie rafue omoɨmo itatañeite. ");
INSERT INTO huuNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Mena patrones dɨga daruido buna jaca maɨjɨnide. Mena dɨga bu maɨjɨacania, damɨena jɨaɨmɨe baɨfemo gaɨte. Ie gaɨamɨe ocuica rana fɨnoite. Jɨaɨmɨe ocuica rana raise fɨnoñeite. Ie isoide. Raruiaɨ ollemo comecɨna omoɨ eo facaia, Jusiñamui jitaillacɨnomo comecɨna raise facañeitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Jesús llofuiana fariseuaɨ comɨnɨ cacajano, ucubena eo gaɨa jira, naimɨe uaina jamaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Naimacɨmo Jesús llote: —Omoɨ fɨnoca rafuemona comɨnɨ omoɨna: “Mare” raillana jitaidomoɨ; iadedɨ Jusiñamui omoɨ comecɨaɨ maraiñenana uiñote. Iese omoɨ illana Jusiñamui gaɨñede. ");
INSERT INTO huuNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Jusiñamui facaina lloraɨnɨ mɨcorɨaɨ cuegafuiaɨmona Jusiñamui rafuena cacacabidomoɨ. Moisés mɨcorɨ cuegafuiaɨmona iena jɨaɨ cacacabidomoɨ. Juan Bautista mɨcorɨmona naimɨe anamo omoɨ illana Jusiñamui jitaillana cacadomoɨ. Jusiñamui dɨbeimo omoɨ comecɨaɨ iuaina meiduana cacadomoɨ. Iena jɨaɨ llocabitɨcue. Iena ailluena ɨɨnuamona, Jusiñamui dɨbeimo birui duere iacadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Mona enɨrue dɨga nia ia, nana Jusiñamui llogacɨnuaɨ suicana jaite. ");
INSERT INTO huuNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Jesús llote: —Naga aɨna dotadɨmɨedɨ, jɨaɨñaiño ollena, jeacɨnona jai fɨnode. Dotacañaiñona bu oia, jeacɨnona jai fɨnode. ");
INSERT INTO huuNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Jesús jɨaɨe rafuena llote: —Cue llogacɨnona omoɨ raise uiñollena, bie rafue lloitɨcue. Ucuberedɨmɨe ite. Eo mare ɨniroina jɨtade. Eo caɨmare raise guicabite. ");
INSERT INTO huuNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Naimɨe nasemo Lázaro raillamɨe jamai bɨide. Naimɨedɨ dueredɨmɨe. Efonaitɨmɨe. ");
INSERT INTO huuNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Naimɨedɨ ucuberedɨmɨe guiga allamona guiacade; ia guiñede. Jɨconɨaɨdɨ naimɨe efocɨaɨna mecabite. ");
INSERT INTO huuNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ie mei naimɨe fiodaite. Jusiñamui comɨnɨna naimɨe illamona, Jusiñamui jaɨenisaɨ naimɨe joreño monamo Abraham mɨcorɨ joreño illanomo uitɨmacɨ. Ucuberedɨmɨe jɨaɨ fiodaite. Comɨnɨ naimɨena raɨtɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Jusiñamui comɨnɨna naimɨe iñenamona, naimɨe joreño iraimo jaide. Nainomo naimɨe duere sefuillamona, Abraham joreñona aarena cɨode. Naimɨe ecɨmo Lázaro mɨcorɨ ie joreñona jɨaɨ cɨode. ");
INSERT INTO huuNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Abraham joreñona uaidote: “Cue moo Abraham, cuena duenai. Lázarona cue dɨne oreta, ie onocaɨ dɨga, jɨnuina cue fuemo llocatallesa, cue fuedo manare jaillena. Bie iraimona jai eo llegɨ cacadɨcue”. ");
INSERT INTO huuNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Abraham joreñodɨ uai ote: “Moo, o illa dɨnori naga ra omo ite. Marena itɨo; iadedɨ Lázaro duere sefuide. Birui naimɨe marena ite; iadedɨ o duere sefuidɨo. ");
INSERT INTO huuNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","O dɨne jainidɨcaɨ. O enefebetuemo itɨo. Caɨ enefebetuemo jɨaɨ itɨcaɨ. Caɨmona omoɨ dɨne bu jaiñellena, omoɨmona caɨ dɨne bu biñellena, iese ite”. ");
INSERT INTO huuNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ucuberedɨmɨe mɨcorɨ joreño dɨnena uai ote: “Cue moo jofomo Lázarona oreta. ");
INSERT INTO huuNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Cuemo cinco amatɨaɨ ite. Naimacɨmo rɨire llollena, bie iraimo naimacɨ riñellena, naimɨena oreta”. ");
INSERT INTO huuNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abraham joreñodɨ uai ote: “Naimacɨmo Moisés mɨcorɨ cuegafuiaɨ ite. Jusiñamui facaina jaie lloraɨnɨ mɨcorɨaɨ cuegafuiaɨ jɨaɨ ite. Iemo naimacɨ comecɨaɨna facallesa”. ");
INSERT INTO huuNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Uai ote: “Iese lloñeno. Iemo comecɨaɨna facañeitɨmacɨ; iadedɨ fiodaillamona jilluanona, naimacɨ dɨne bu jaia, naimɨena ɨɨnoitɨmacɨ. Naimacɨ comecɨaɨ iuai meidoitɨmacɨ”. ");
INSERT INTO huuNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Abraham joreñodɨ uai ote: “Moisés mɨcorɨ cuegafuiaɨ, Jusiñamui facaina jaie lloraɨnɨ mɨcorɨaɨ cuegafuiaɨ naimacɨ ɨɨnoñenia, fiodaillamona bu jilloia, naimɨena jɨaɨ ɨɨnoñeitɨmacɨ” —Jesús llote. ");
INSERT INTO huuNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ie llofueoicaiganomo Jesús llote: —Dɨga ramo omoɨ faɨcana uitɨnomo riitomoɨ. Omoɨ ramo faɨtɨmɨe duere sefuite. Jusiñamui omoɨ ramo faɨtɨmɨena duere fɨnoite. ");
INSERT INTO huuNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Como creyentena jaidɨmɨena ramo bu faɨa, naimɨe cɨmaɨomo aillue nofɨcɨ maɨanona, joraimo corobaillena naimɨena dotacadena, mare. ");
INSERT INTO huuNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Como creyentena jaidɨmɨena ramo omoɨ faɨñellena, abɨna omoɨ rairui. O ecɨmo itɨmɨe ona jeare fɨnoia, naimɨemo iena llono. Ie comecɨna meidoiacania, naimɨe jearede fɨnoca rafuena feita. ");
INSERT INTO huuNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Nagarui dɨga icaiño ona jeare naimɨe fɨnoia, naga icaiño o dɨga naimɨe marena dane ñaɨacania, naie rafuena feita. ");
INSERT INTO huuNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ie doce llofueoicaigano Jesúmo llote: —Ona ɨɨnotɨcaɨ; ia caɨna o uaina eo ɨɨnota. ");
INSERT INTO huuNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Uai ote: —Jusiñamuina eo janore ɨɨnotomoɨdena, bene ite amenamo omoɨ lloia: “Benomona jai. Joraimo sɨco”, naie amena omoɨ uaina ɨɨnote. ");
INSERT INTO huuNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Ie llofueoicaiganomo Jesús llote: —Bie rafuemona omoɨ fueollena, iena lloitɨcue. Illɨmo ie mullaɨma maɨjɨamona, ie toɨnɨaɨ sedajamona jofomo abɨdo naimɨe ria, ie patrón naimɨemo lloñeite: “Mai nano guisaɨbi”; ");
INSERT INTO huuNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","iadedɨ naimɨemo lloite: “Cueɨena guillena nano fɨno. Cuena eca. Ie mei guitɨo”. ");
INSERT INTO huuNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Naie mullaɨma ocuica rana fɨnua muidona, mullaɨmana naimɨe illa jira, ie mullaɨmamo patródɨ iobillacɨnona fecañeite. ");
INSERT INTO huuNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ie isoide. Nana cue lluana omoɨ fɨnodomoɨna, danɨ omoɨ maɨjɨadɨ, cue comɨnɨna omoɨ illa jira, cuemona iobillacɨnona feiñoñeitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jerusalémo ie llofueoicaigano dɨga Jesús jaidemo, naimɨe nabeimo Samaria enɨrue ite. Naimɨe jarɨfebeimo Galilea enɨrue ite. ");
INSERT INTO huuNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Naɨraɨ dɨne naimɨe riacania, diez efonaitɨnodɨ naimɨemo dafaɨfidɨmacɨ. Eneno oni naidaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Naimɨena ado uaidotɨmacɨ: —Jesús, Maestro, caɨna duenai. Caɨna ja jillota. ");
INSERT INTO huuNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Naimacɨna Jesús cɨuanona, naimacɨmo llote: —Mai jai. Jusiñamui dɨga ñaɨraɨnɨmo omoɨ abɨna acata. —Jaidɨmacɨmo, jillodɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ie abɨ jilluana cɨuano, naimacɨmona damɨe Jesús dɨne abɨdo bite. Jusiñamuimo iobillacɨnona ado fecade. ");
INSERT INTO huuNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Naimɨemo iobillacɨnona jɨaɨ fecallena, Jesús uicomo ana bɨtadate. Naimɨedɨ judíuñedɨmɨe. Samaritano imɨe. ");
INSERT INTO huuNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jesús llote: —Diez dɨgamɨedomoɨ. Omoɨna jai jillotatɨcue. ¿Nɨnomo jɨaɨnodɨ nueve dɨgamɨe itɨmacɨ? ");
INSERT INTO huuNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Nɨese Jusiñamuimo iobillacɨnona fecaacaiñedɨmacɨ? Dama bimɨe fecade. Naimɨedɨ judío imɨeñedɨmɨe. ");
INSERT INTO huuNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Jesús naimɨemo llote: —A naidada. Mai jai. Cuena o ɨɨnua jira, jai jillodɨo. ");
INSERT INTO huuNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Naie facaise fariseuaɨ comɨnɨ Jesúmo jɨcanotɨmacɨ: —¿Nɨruido Jusiñamui caɨna bene sedaite? Jesús uai ote: —Siño rafuena omoɨ cɨuamona, Jusiñamui omoɨna sedallena uiñoñeitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Buena cɨuamona raiñeitomoɨ: “Jadi, Jusiñamui bene caɨna jai sedade”. “Jadi, batɨne caɨna jai sedade”; iadedɨ omoɨ motomo itɨnomona Jusiñamui dɨbeimo damɨerie illamona, Jusiñamui omoɨ motomo jai illana uiñoitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ie llofueoicaiganomo llote: —Jɨaɨruido duere sefuillamona cue dɨga janore jisa iacanitomoɨ; iadedɨ iese nia iñeitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Damɨerie raia: “Ero, batɨne Cristo jai bairede” nainomo jaiñeno. Naimacɨ raia: “Ero, bene Cristo jai bairede” iena ɨɨnoñeno. ");
INSERT INTO huuNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Mona borillamona mona jillacɨdɨ usere cɨode. Ie isoide. Cue abɨdo bia, nana comɨnɨ iena uiñoitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Birui iese nia suiñeite. Nano duere sefuitɨcue. Birui ite comɨnɨ cuena jɨaɨ feiñoñeitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Abɨdo cue billɨrui iaɨrei ia, Noé mɨcorɨ facaiseconi itɨno isoi, comɨnɨ iitɨmacɨ. Naimacɨ duere sefuillemo Noé mɨcorɨ facaise itɨnodɨ comecɨaɨna facañedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Naie facaiseconi nia eo nocɨ deiñenia, Noé mɨcorɨ ecɨmo itɨno naimacɨ isoilla isoi icana jaidɨmacɨ. Jamai guicana jaidɨmacɨ. Aɨna ua mei, ɨnina ua mei, jebuicana jaca jamai jaidɨmacɨ. Danɨ iemo comecɨaɨna facauidɨmacɨ. Jusiñamuimo comecɨaɨna facañedɨmacɨ. Iese itɨmacɨ, Noé mɨcorɨ ie balsamo fo jailla dɨnori. Nia nocɨ deiñenia, Noé mɨcorɨ lloga uaina ɨɨnoñedɨmacɨ. Nocɨ deilla mei, ebena nana faɨfidɨmacɨ. Cue abɨdo bia, ie isoite. Ebena biitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Lot mɨcorɨ facaiseconi daje isoidɨmacɨ. Jamai guicana jaidɨmacɨ. Aɨna ua mei, ɨnina ua mei, jebuicana jaca jamai jaidɨmacɨ. Rana ɨbauidɨmacɨ. Iena fecauidɨmacɨ. Illɨmo maɨjɨuidɨmacɨ. Jofona fɨnouidɨmacɨ. Naimacɨ isoilla isoi icana jaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Danɨ iemo comecɨaɨna facadɨmacɨ. Jusiñamuimo comecɨaɨna facañedɨmacɨ. Iese icana jaidɨmacɨ, Sodomamona Lot mɨcorɨ jailla dɨnori. Nairui monamona boode azufre ebena billanona, nana Sodomamo itɨno jobaide. Ebena nana faɨfidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ie isoide. Abɨdo cue billɨruimo comɨnɨ iitɨmacɨ. Cue bia, ebena biitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Naie facaise bu ie jofo emodomo ia, ie raruiaɨna ollena, naimɨe dɨga uillena, bu fo jaiñena. Illɨmo bu ia, ie raruiaɨna ollena, ie jofomo bu jaiñena. ");
INSERT INTO huuNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Iemona fueollena, Lot ai mɨcorɨ rafuemo comecɨna faca. Naiñaiño ie raruiaɨmo daño comecɨna facajamona, na ie abɨ dɨga faɨfide. ");
INSERT INTO huuNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Dama ie raruiaɨmo ie comecɨna bu facaia, ja muidomo faɨfite. Cue dɨga jaca iñeite; iadedɨ cue jitaillacɨnona fɨnuamo ie comecɨna bu facaia, monamo cue dɨga jaca iite. ");
INSERT INTO huuNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Cue bille facaise menamɨe daje cuartomo ɨnɨano iitɨiaɨmaiaɨ. Damɨe jaite. Jɨaɨmɨe fɨebite. ");
INSERT INTO huuNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Mena rɨño danomo doberillanona iitɨiaɨñuaɨ. Dañaiño jaite. Jɨaɨñaiño fɨebite. ");
INSERT INTO huuNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Menamɨe illɨmo maɨjɨano iitɨiaɨmaiaɨ. Damɨe jaite. Jɨaɨmɨe fɨebite. ");
INSERT INTO huuNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ie llofueoicaigano jɨcanotɨmacɨ: —¿Nɨne jaitɨmacɨ? Uai ote: —Urujaisaɨ rɨfaide ramo ofillana uiñua isoi, nana cuena ɨɨnotɨno cue abɨdo billena uiñoitɨmacɨ. Cuemo duillamona, cue dɨga jaitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ie llofueoicaiganomo Jesús rafuena dane llote: —Jusiñamuimo jɨɨcabi, omoɨ jɨcaca rafue omoɨ feiñolle dɨnori. Raɨre feiñoñenia, abɨna jafueñeno. ");
INSERT INTO huuNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Iena omoɨ raise uiñollena, bie rafuena lloitɨcue. Jɨaɨe naɨraɨmo juez ite. Jusiñamuina jacɨruiñede. Comɨnɨna jɨaɨ jacɨruiñede. ");
INSERT INTO huuNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Nainomo naimɨe dɨne daje fecɨño jai-jaicabillanona, raite: “Cuena duere fɨnodɨmɨemona cuena cano”. ");
INSERT INTO huuNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Naimɨe dɨnena raite: “Dama iesede. Ona canoñeitɨcue”. Ie mei ie comecɨna facade: “Jusiñamuina jacɨruiñedɨcue. Comɨnɨna jɨaɨ isiruiñedɨcue; ");
INSERT INTO huuNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ia naiñaiño cuemo sefuire bi-bina jira, naiñaiñona canoitɨcue, cue rairaɨfaiñellena”. ");
INSERT INTO huuNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Jesús llote: —Maraiñede juez lluana cacadomoɨ. Ja muidomo naiñaiñona canode. ");
INSERT INTO huuNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ero, biemo omoɨ comecɨaɨna faca. Jusiñamui naie juez isoiñede. Nagarui Jusiñamuimo naimacɨ jɨcaia, ¿nɨese naimɨe ie fetocanona canoñeite? Jaca canoite. ");
INSERT INTO huuNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Raɨre faɨriuanona, naimacɨna raɨre canoite; iadedɨ abɨdo cue bia, ¿nɨga cuena ɨɨnotɨno iitɨmacɨ? Nɨbaɨ ailluena cuena ɨɨnoñeitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","“Mareuidɨcaɨ” dajerie railla jira, “Jɨaɨe comɨnɨ baɨfemo faɨtɨcaɨ” dajerie railla jira naimacɨmo Jesús bie rafuena llote: ");
INSERT INTO huuNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Jusiñamui jofomo, nainomo jɨɨllena, menamɨe jaidɨaɨmaiaɨ. Damɨe fariseo imɨe. Jɨaɨmɨe gobierno ucubena oraɨma. ");
INSERT INTO huuNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Fariseo imɨe naidadacaida, dama anado jɨɨde: “Jusiñamui, jɨaɨe comɨnɨ isoiñedɨcue. Fɨɨdɨmacɨ. Maraiñedɨmacɨ. Naimacɨ aɨñede rɨño dɨga itɨmacɨ. Cue ecɨmo ite ucubena oraɨma isoi iñedɨcue. ");
INSERT INTO huuNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Naga semana menarui guicabiñedɨcue, ona raise cue sedajanona. Cue ramona omo fecacabidɨcue. Macaɨbaite” jɨɨde. ");
INSERT INTO huuNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Gobierno ucubena oraɨma eneno naidadacaida, jɨɨde. Monamo eruaɨñede; iadedɨ jamai bue isoillanona, jogobena farode. Raite: “Jusiñamui, jeacɨnona fɨnoraɨmadɨcue. Cuena duenai. Macaɨbaite” jɨɨde. ");
INSERT INTO huuNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Jusiñamuidɨ jɨaɨmɨe afemo iacadɨmɨena jɨaɨmɨe afemo iñenana itataite. Jusiñamuidɨ jɨaɨmɨe afemo iacaiñedɨmɨena jɨaɨmɨe afemo itataite. Ie jira gobierno ucubena oraɨma ie jofomo Jusiñamuimona jai marebicaillanona jaide; ia fariseo imɨe iese jaiñede. ");
INSERT INTO huuNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Naie facaise Jesús dɨne comɨnɨ naimacɨ eisaɨaɨna atɨsɨte. Ie onollɨ naimacɨmo naimɨe joniana jitaidɨmacɨ. “Naimacɨna raise cano” ie Moomo llollena jitaidɨmacɨ. Iena cɨuanona, ie llofueoicaigano comɨnɨna Jesús dɨne billana rairuidɨmacɨ; ");
INSERT INTO huuNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","iadedɨ Jesúdɨ eisaɨaɨna uaiduano raite: —Uruiaɨ cue dɨne billesa. Naimacɨna rairuiñeno. Cuena bie isoi ɨɨnotɨnodɨ Jusiñamui comɨnɨdɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Bie uruiaɨ abɨna ɨedoñedɨmacɨ. Einamacɨmona jamai bue isoidɨmacɨ. Naimacɨ isoi bu iñenia, Jusiñamui comɨnɨna jaiñeite. Jusiñamui naimɨena sedallena, Jusiñamui comɨnɨna naimɨe jaiñeite. ");
INSERT INTO huuNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ie facaise illaɨcomɨnɨmona damɨe Jesúmo jɨcanote: —Maestro, odɨ mareuidɨmɨedɨo. Jusiñamui dɨga ɨco monamo cue jaca illena, ¿nɨe isoide rana fɨnoitɨcue? ");
INSERT INTO huuNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesús uai ote: —¿Bue ñellena cuena: “Mareuidɨmɨedɨo” raitɨo? Dama damɨe mareuidɨmɨena. Naimɨedɨ Jusiñamui. Naimɨemo jɨcano. ");
INSERT INTO huuNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Moisés mɨcorɨ llogacɨnuaɨna ɨɨnocana jai. Jaie cuete: “O aɨñede rɨño dɨga iñeno. Comena meineñeno. Rana fɨɨñeno. Jɨaɨmɨena o llogɨdoia, taɨnona lloñeno. O moo uaina ɨɨno. O ei uaina ɨɨno”. ");
INSERT INTO huuNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Uai ote: —Cue uruena illa facaisemona nana bie llogacɨnuaɨna ɨɨnotɨcue. ");
INSERT INTO huuNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Iena cacajano, Jesús raite: —Daje rana nia fɨnoñedɨo. O raise marebicaiacania, omo ite raruiaɨna feca. Naie ucubena dueredɨnomo feca. Cuena o ɨɨnuamona, monamo ɨco jaca iitɨo. Cue llofueoicaiganona o illena, mai cue dɨga bi. ");
INSERT INTO huuNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Jesús lluana naimɨe cacajano, sunaicaide. Naimɨemo eo ailluena ra illa jira, iena fecaacaiñede. ");
INSERT INTO huuNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Naimɨemo eruaɨllano, Jesús raite: —Ucuberedɨnodɨ Jusiñamui comɨnɨna jaillena eo sefuiruite. ");
INSERT INTO huuNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Igɨdo ifodo camello jaca jainide. Ie isoide. Ie ra isiruillamona, ucuberedɨmɨedɨ Jusiñamui comɨnɨna jɨaɨ raise jainide. ");
INSERT INTO huuNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Jesús lluana cacadɨno jɨcanote: —¿Iemona buca jillobitɨ? ");
INSERT INTO huuNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jesús uai ote: —Nana comɨnɨ danɨ jillobinidɨmacɨ; iadedɨ Jusiñamuidɨ naimacɨna jillobitarede. ");
INSERT INTO huuNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pedro raite: —Ero, o llua isoi caɨ jofuena faɨnonocaida, o dɨga jaisoidɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Uai ote: —Uanaicɨnona llotɨcue: Jusiñamui comɨnɨna naimɨe jaillamona, ie jofona bu faɨnonocaia, ie aɨna bu faɨnonocaia, ie amatɨaɨna bu faɨnonocaia, ie moona bu faɨnonocaia, ie eina bu faɨnonocaia, ie uruiaɨna bu faɨnonocaia, ");
INSERT INTO huuNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Jusiñamuimona ailluena ɨbana birui feiñoite. Monamo ɨco jɨaɨ jaca iite. ");
INSERT INTO huuNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ie doce llofueoicaigano eneno uillanona, danɨ naimacɨmo llote: —Ero, Jerusalémo jai jaidɨcaɨ. Monamona billanona, ɨimana jaidɨcue. Jusiñamui facaina lloraɨnɨ cuena jaie cuetɨmacɨ. Nana naie rafue ja suite. ");
INSERT INTO huuNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Judíuaɨñedɨnomo judíuaɨ illaɨcomɨnɨ cuena fecaitɨmacɨ. Cueri jɨfanoitɨmacɨ. Cuena jeare fɨnoitɨmacɨ. Cuena tuallaɨtɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Cuena faitɨmacɨ. Cuena meineitɨmacɨ; ia darui amani illanona, cue fiodaillamona jilloitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Naimɨe lluana raise cacaiñedɨmacɨ. Naimacɨna iena Jesús nia raise llofueñena jira, iena raise uiñoñedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jericó railla naɨraɨmo ie llofueoicaigano dɨga Jesús riacademo, uisɨnidɨmɨe naɨso fuemo raɨllana cɨode. Ucubena jamai jɨca-jɨcade. ");
INSERT INTO huuNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ailluena comɨnɨ Jesús dɨga jaillana naimɨe cacajano, naie comɨnɨmo nɨe isoide rafue illana jɨcanote. ");
INSERT INTO huuNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Uai otɨmacɨ: —Nazaret ie Jesús como bene bite. ");
INSERT INTO huuNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ie jira naimɨe cuirioide: —David mɨcorɨ Jitona o illamona, cuena duenai. Cuena cano. ");
INSERT INTO huuNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Uicodo jaidɨno naimɨena lletade, naimɨena llɨɨcaitallena; iadedɨ naimɨe eo cuirioide: —David mɨcorɨ Jitona o illamona, cuena duenai. ");
INSERT INTO huuNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Naimɨena cacajano, Jesús naidadate. —Cue dɨne naimɨena atɨ —llote. Naimɨena atɨanona, naimɨemo Jesús jɨcanote: ");
INSERT INTO huuNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Nɨese ona cue nɨbaɨana jitaidɨo? Uai ote: —Maestro, cɨoacadɨcue. ");
INSERT INTO huuNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jesús raite: —Mai eroda. Cuena o ɨɨnua jira, jai jillodɨo. ");
INSERT INTO huuNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ieconi naimɨe uisɨdɨ cɨode. Jusiñamuimo iobillacɨnona fecajano, Jesús dɨga jaidɨno dɨga naimɨe jaide. Naimɨe jilluana cɨuamona, nana comɨnɨ Jusiñamuimo iobillacɨnona jɨaɨ fecadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jericómo Jesús rillanona, nainomo macaritemo, ");
INSERT INTO huuNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","naie facaise nainomo Zaqueo raillamɨe ite. Gobierno ucubena nanoca oraɨma. Naimɨedɨ eo ucuberede. ");
INSERT INTO huuNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Jesús baɨ macaritemo, Zaqueo naimɨena cɨoacade; iadedɨ ailluena comɨnɨ illamona, Zaqueo ianorina jira, Jesúna cɨonide. ");
INSERT INTO huuNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ie jira uicodo aisɨcana jaide, amenamo a jaillena, naimɨena cɨoillena. ");
INSERT INTO huuNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Naimɨe dɨne Jesús rillano, Zaqueomo a erodate. Naimɨena uaidote: —Zaqueo, raɨre ana bi. O dɨga danomo illena, o jofo dɨne jaitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ie jira raɨre ana bite. Ie jofomo Jesúna iocɨre feiñote. ");
INSERT INTO huuNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Iena jɨaɨe comɨnɨ cɨuanona, Jesús joreñona jeare ñaɨanona raitɨmacɨ: —Mariñedɨcɨnona fɨnoraɨma jofomo naimɨe jaide. ");
INSERT INTO huuNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Jesúna naimɨe feiñua mei, Zaqueo Jesús ecɨmo naidaita, naimɨemo llote: —Nama, atuedo cue raruiaɨna dueredɨnomo biruimona fecaitɨcue. Bumona navui cue fɨɨia, cuatro dɨga ra abɨdo iitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jesús uai ote: —Iese o llua jira, o comɨnɨ dɨga Jusiñamuina jai o ɨɨnuana uiñotɨcaɨ. —Jamai bitɨnomo llote: —Zaqueodɨ Abraham mɨcorɨ jito; ia Jusiñamuina navui ɨɨnoñede. ");
INSERT INTO huuNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Naimɨe isoidɨno jillobitallena, bitɨcue. Monamona billanona, ɨimana jaie jaidɨcue. Jusiñamuina ɨɨnoñedɨnona jenuaɨbidɨcue, naimacɨna jillobitallena. ");
INSERT INTO huuNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Zaqueo jofomo itɨno Jesús llofuiana cacajano, comecɨna facadɨmacɨ: “Jerusalén ianori ite. Nainomo Jesús rilla mei, illaɨma isoi nainomo Jusiñamui ie comɨnɨna raɨre sedaite”. ");
INSERT INTO huuNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Iena naimacɨ raise uiñollena, Jesús bie rafue naimacɨmo llote: —Illaɨma jito ie nanoca illaɨma dɨne jɨaɨe naɨraɨmo jaide. Ie comɨnɨna sedallena, nanoca illaɨmamona ie uaina feiñoiacade. Iemei abɨdo biacade. ");
INSERT INTO huuNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Nia naimɨe jaiñenia, diez dɨga ie mullaɨaɨna uaidote. Nagamɨerie daberie ucubena fecade. Naimacɨmo llote: “Bie ucube dɨga jɨaɨe ucube ocana omoɨ jai”. Ie mei oni jaide. ");
INSERT INTO huuNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ie comɨnɨ naimɨena enoidɨmacɨ. Jɨaɨnona nanoca illaɨma dɨne oretajano, raitɨmacɨ: “Bimɨe caɨna sedajana jitaiñedɨcaɨ”; ia nanoca illaɨma dɨnena naimacɨ lluana jaca cacaiñede. Ie jira naie nanoca illaɨma naie illaɨma jitomo ie uaina ite. ");
INSERT INTO huuNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ie uaina feiñua mei, abɨdo ie enɨruemo jaide. Rilla mei, ie mullaɨaɨna uaidote. Nɨe dɨese ucubena ocana naimacɨ jaillana uiñoiacade. Ie jira naimacɨna uaidote. ");
INSERT INTO huuNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Nano bitɨmɨe raite: “Nama, o cuemo dabe fecadɨo. Dabedemona jai cuemo ite diez dɨgabe”. ");
INSERT INTO huuNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Naie illaɨma naimɨemo llote: “Eo marena maɨjɨdɨo. Mare mullaɨmadɨo. Janore ra raise o sedaja jira, ona diez naɨraɨaɨna sedataitɨcue”. ");
INSERT INTO huuNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ie mei jɨaɨe mullaɨma billanona, raite: “Nama, o cuemo fecaca dabedemona jai cuemo ite cinco dɨgabe”. ");
INSERT INTO huuNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Illaɨma llote: “Ona cinco naɨraɨaɨna sedataitɨcue”. ");
INSERT INTO huuNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ie mei jɨaɨe mullaɨma bite. Raite: “Nama, jadi, o cuemo iga o ucube. Ɨniroimo tɨllɨano, iena eenotɨcue. ");
INSERT INTO huuNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ona cue jacɨruillano, odɨ eo rɨimɨena jira, iena jamai eenotɨcue. Jɨaɨe comɨnɨmona ie rana baɨrocabidɨo. O maɨjɨñena ramona ocabitɨo”. ");
INSERT INTO huuNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Illaɨma dɨnena raite: “Eo maraiñede mullaɨmadɨo. Cuena o llua isoi, ona duere fɨnoitɨcue. Cue rɨimɨenana uiñotɨo. Jɨaɨe comɨnɨ ie rana cue baɨruana uiñotɨo. Cue maɨjɨñena motomo ra cue uana uiñotɨo; ia buena maɨjɨñedɨo. ");
INSERT INTO huuNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿Bue ñellena bancomo cue ucube joneñedɨo? Bancomo itena, jɨaɨe ucubena ocana jaide. Ie mei abɨdo cue bia, omo cue fecaja ucube baɨfemo feiñotɨcue”. ");
INSERT INTO huuNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Nainomo itɨnomo llote: “Naie ucube naimɨemona baɨruano, diez dɨgabe itɨmɨemo feca”. ");
INSERT INTO huuNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Uai otɨmacɨ: “Naimɨemo ailluena ucube jai ite. ¿Bue ñellena dane jɨaɨe fecaitɨo?” ");
INSERT INTO huuNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Illaɨma dɨnena uai ote: “Ailluena raredɨmɨe jɨaɨe rana feiñoite; iadedɨ janore raredɨmɨe ie rana faɨfite. ");
INSERT INTO huuNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Cuena enoidɨnona bene atɨ. Naimacɨna cue sedajana jitaiñedɨmacɨ. Naimacɨna meine”. Jesús nia llote: —Ie isoide. Iese omoɨmo suiñellana, Jusiñamui ie comɨnɨ sedallɨruina omoɨ uiñoñena jira, cue jitaillacɨno fɨnocana jai. ");
INSERT INTO huuNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Naie rafuena llofuia mei, Jerusalén dɨne comɨnɨ uicodo ie llofueoicaigano dɨga Jesús jaide. ");
INSERT INTO huuNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Jerusalén iaɨreicaidemo, mena naɨraɨmo riacade. Betfagémo railla naɨraɨmo ride. Betania nainomo jɨaɨ ite. Olivos railla anedumo naga naɨraɨ iaɨmaiaɨ ite. Ie llofueoicaiganomona mena orede. ");
INSERT INTO huuNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Raite: —Bie naɨraɨ illa uicomo mai omɨco jai. Nainomo cuinaca burritona baitomɨco. Naie burrito emodomo nia buna jaiñena. Iena suiñuano bene atɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Omɨcomo: “¿Bue ñellena iena suiñodomɨco?” bu jɨcanoia, llono: “Coco Nama iena jitaide”. ");
INSERT INTO huuNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Naimɨe llua isoi jaidɨiaɨmaiaɨ. Naimɨe llua isoi burritona baitɨiaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ie facaise ie nanɨaɨ iaɨmaiaɨmo jɨcanote: —¿Bue ñellena caɨ burritona suiñodomɨco? ");
INSERT INTO huuNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Uai otɨiaɨmaiaɨ: —Coco Nama iena jitaide. ");
INSERT INTO huuNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ie mei Jesúmo iena atɨdɨiaɨmaiaɨ. Burrito emodomo ɨniroina jobianona, ie emodomo Jesúdɨ raɨnadate. ");
INSERT INTO huuNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Jesús iese jaidemo, naimɨena iobitallena, illaɨma isoi naimɨe jaillena, comɨnɨ imacɨ ɨniroi dɨga, naɨso motomo jobedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Jerusalémo joide naɨso ite nafaɨ muidomo naimɨe rillanona, naie ituemo ana jaillanona, nana Jesús dɨga jaidɨno caɨmare itɨmacɨ. Nana Jesús siño fɨnoca rafuena naimacɨ jai cɨua jira, iena naimacɨ uibiñuamona, Jusiñamuimo iobillacɨnona ado eo fecadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Raitɨmacɨ: —¡Caɨ Illaɨma billa! ¡Jusiñamui mamecɨdo bitɨmɨemo caɨ iobicabillasa! O muidona Jusiñamuidɨ comɨnɨ dɨga uri ite. ¡O fɨnoca rafue muidona Jusiñamuimo iobicabillasa! ");
INSERT INTO huuNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Naie comɨnɨmona dajerie fariseuaɨ raitɨmacɨ: —Maestro, o dɨga jaidɨnona llɨɨcaillena, naimacɨna lleta. ");
INSERT INTO huuNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Uai ote: —Naimacɨ llɨɨcaia, biso fuemo ite nofɨcɨdɨ cuena marena ñaɨte. ");
INSERT INTO huuNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jerusalémo Jesús iaɨrei ria, iena cɨuano, eede. ");
INSERT INTO huuNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Raite: —Jerusalén itɨno, Jusiñamui dɨga omoɨ uri illena jai bitɨcue. Omoɨna naimɨe comɨnɨna itataiacadɨcue; iadedɨ iena jitaiñedomoɨ. Iena jitaidomoɨdena, ɨco duere sefuiñeitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Jɨaɨruido omoɨ bacauai jobaimena fɨnuanona, omoɨna cɨrɨnoitɨmacɨ. Omoɨ ecɨdo llaɨtɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Omoɨna meineitɨmacɨ. Omoɨ uruiaɨna meineitɨmacɨ. Omoɨ illanona judaɨitɨmacɨ. Jusiñamui omoɨ motomo birui illana omoɨ uiñoñena jira, iese omoɨmo suite. ");
INSERT INTO huuNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jerusalémo Jesús rilla mei, Jusiñamui jofomo jaide. Jusiñamuimo ofomaɨaɨna fecallena, naimɨemo toɨca llaudaɨaɨna fecallena, nainomo comɨnɨ jaisoidɨmacɨ. Naie comɨnɨna ɨbatajanona, ofomaɨaɨna, toɨca llaudaɨaɨ dɨga, damɨerie fecauidɨmacɨ. Iena cɨuanona, naimacɨna jino orede. ");
INSERT INTO huuNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Raite: —Ie facaina lloraɨma mɨcorɨ Jusiñamui llogacɨno jaie cuega: “Cue jofo ite nainomo cuemo comɨnɨ jɨɨllena” cuega. Ero, ailluena omoɨ ɨbataja jira, naimɨe jofona fɨɨriruidɨno jofona omoɨ fɨnoca. ");
INSERT INTO huuNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Jusiñamui jofomo nagarui Jesús llofuete. Judíuaɨ illaɨcomɨnɨdɨ Jesúna meineiacadɨmacɨ; ");
INSERT INTO huuNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","iadedɨ nɨese nɨbaɨñedɨmacɨ, nana comɨnɨ naimɨe llofuiana eo jitailla jira. ");
INSERT INTO huuNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Jusiñamui jofomo Jesúdɨ comɨnɨna llofuete. Jusiñamui rafuena llofuete. Judíuaɨ illaɨcomɨnɨ naimɨe dɨne bitɨmacɨ. Naimacɨdɨ Jusiñamui dɨga nanoca ñaɨraɨnɨ. Naimacɨdɨ Moisés mɨcorɨ llogacɨno llofueraɨnɨ. Naimacɨdɨ einamacɨ. Dɨese billanona, ");
INSERT INTO huuNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","jɨcanotɨmacɨ: —¿Nɨe isoide uaido o fɨnoca rafuena fɨnocabidɨo? ¿Bu omo iga uai dɨga o fɨnoca rafuena fɨnocabidɨo? ");
INSERT INTO huuNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jesús dɨnena uai ote: —Omoɨmo nano jɨcanoitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Juan Bautista mɨcorɨdɨ comɨnɨna navui bautizade. ¿Bu naimɨe mɨcorɨna comɨnɨna bautizatate? ¿Jusiñamui? ¿Comɨnɨ? Cuemo llono. ");
INSERT INTO huuNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Danɨ coninɨri iena siaduanona raitɨmacɨ: —“Jusiñamui” caɨ faɨrioia, caɨmo jɨcanoite: “¿Bue ñellena naimɨe mɨcorɨna ɨɨnoñedomoɨ? ¿Bue ñellena naimɨe mɨcorɨ llua isoi bautizañedomoɨ?” ");
INSERT INTO huuNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","“Comɨnɨ” caɨ faɨrioia, bene itɨno caɨna meineitɨmacɨ, Juan mɨcorɨdɨ Jusiñamui facaina lloraɨma naimacɨ railla jira. ");
INSERT INTO huuNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ie jira Jesús uai otɨmacɨ: —Uiñoñedɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Jesús dɨnena raite: —Ie muidona cuemo nɨe isoide uai illana omoɨmo lloñeitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Nainomo itɨnomo Jesús llote: —Jɨaɨe rafue omoɨmo lloitɨcue. Iemo cacarei. Daje patrón uvas railla riaraɨaɨna rite. Ie mei ɨbatajanona jɨaɨnomo fecade, iena sedallena. Ie mei jɨaɨe enɨruemo are illena jaide. ");
INSERT INTO huuNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Uvas jai einailla facaise riaraɨaɨna sedaraɨnɨ dɨne daje mullaɨmana orede, naimɨe facaise iedɨnona naimɨe feiñollena; iadedɨ naie sedaraɨnɨ naie mullaɨmana fatɨmacɨ. Uvas naimɨemo fecañeno abɨdo oredɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ie mei patrón jɨaɨe mullaɨmana orede. Naimɨena fatɨmacɨ. Jeare fɨnodɨmacɨ. Uvas naimɨemo fecañeno abɨdo oredɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Naie patrón jɨaɨmɨena orede. Naimɨena eo bofedaitajanona jino dotadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Iemei patrón comecɨna facade: “¿Nɨese nɨbaɨitɨcue? Cue isiruiga jitona oretaitɨcue. Naimɨena nɨbaɨ jacɨruitɨmacɨ. Naimɨe uaina ɨɨnoitɨmacɨ”. ");
INSERT INTO huuNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Riaraɨaɨna sedaraɨnɨ naimɨena cɨuanona, coninɨri ñaɨtɨmacɨ: “Bimɨemo bie illɨ fɨebiite, naimɨe moo fiodailla mei. Naimɨena caɨ meinellɨ, bie illɨ caɨmo fɨebillesa” ñaɨtɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Naimɨena jino dotajanona, naimɨena meinetɨmacɨ. Iena fɨdɨa mei, ¿nɨese naie patrón nɨbaɨite? ");
INSERT INTO huuNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Naimɨe biite, naie sedaraɨnɨna meinellena. Ie mei jɨaɨnona ie illɨna sedataite. Naie rafuena cacadɨno raitɨmacɨ: —Bie isoide rafue suillana jitaiñedɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Naimacɨmo Jesús eruaɨllano, llote: —Naie illɨ sedaraɨnɨ isoidomoɨ. Jusiñamui facaina lloraɨma mɨcorɨ omoɨna jaie cuete. Ie cuegafuena raise facañedomoɨ. Naimɨe mɨcorɨ cuega: Jofo fɨnoraɨnɨ jitaiñena nofɨcɨ nana naie jofomo ite nofɨcɨ baɨfemo jai uaide. cuega. Jusiñamui comɨnɨna damɨerie jaillana naimɨe mɨcorɨ cuete. Jusiñamui oretagamɨena damɨerie jitaiñenamona, naimɨe comɨnɨna jaiñeitɨmacɨ; iadedɨ Jusiñamui oretagamɨena ailluena ɨɨnuamona, naimɨe comɨnɨna jaitɨmacɨ. Ero, naimɨe mɨcorɨ caɨna cuete. Naie jofona fɨnoraɨnɨ isoidomoɨ. Naie nofɨcɨ isoidɨcue. Cue rafuena omoɨ jitaiñena jira, naimɨe comɨnɨna jaiñeitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Naie nofɨcɨna nia ñaɨtɨcue. Nofɨcɨmo bu eɨcaɨtaia, bofedaite; ia naie nofɨcɨ bumo ana uaia, naimɨena saitaite. Ie isoide. Cue lluana omoɨ jamaia, duere sefuitomoɨ. Iena omoɨ ɨɨnoñenia, ja muidomo faɨfitomoɨ —llote. ");
INSERT INTO huuNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Jesús como lloga rafuedo naimacɨna ñaɨana uiñotɨmacɨ. Ie jira naie facaiseconi judíuaɨ illaɨcomɨnɨ naimɨena gaɨtaacadɨmacɨ; iadedɨ comɨnɨna jacɨruitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ie jira naimɨena uiñododɨmacɨ. Mare rafuedo abɨ caitadɨnona oredɨmacɨ. Naimɨe raise uai oñenia, naimɨena duere fɨnollena, naimɨena facacɨiacadɨmacɨ. Gobernadormo naimɨena llogɨdoiacadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Jesúmo llotɨmacɨ: —Maestro, uanaicɨnona marena llofuecabitɨo. Nana comɨnɨna dauaido llofuecabitɨo. Jusiñamui rafuedo caɨ marena jaillana raise llofuetɨo. ");
INSERT INTO huuNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Omo rafuena jɨcanoiacadɨcaɨ. Dama Jusiñamuina sedadɨcaɨ; iadedɨ romanos railla naɨraɨ anamo birui caɨ illa jira, ¿naimacɨ illaɨma Césarmo ucubena caɨ fecajana rairuidɨo? Caɨmo llono —llotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Naimɨena naimacɨ jɨfuiana uiñuanona, Jesús dɨnena uai ote: ");
INSERT INTO huuNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","—Ucube cuemo acata. ¿Bu ie joreño nainomo ite? ¿Bumo jaɨnaɨaɨde bie cuega radɨ? Uai otɨmacɨ: —César. ");
INSERT INTO huuNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Jesús raite: —César iena itedɨ, Césarmo ille. Jusiñamui iena itedɨ, Jusiñamuimo ille —raite. ");
INSERT INTO huuNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Jesúdɨ uai raise ua jira naimɨe lluamona jeare rafuena uiñoñedɨmacɨ, naimɨena llogɨdollena. Naimɨe lluari raijicaillamona, llɨɨcaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Naie facaise dajerie saduceuaɨ railla comɨnɨ naimɨe dɨne bitɨmacɨ. “Fiodaillamona jaca buna jilloñeite” raisoidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Jesúmo llotɨmacɨ: —Maestro, caɨ facaina Moisés mɨcorɨ jaie cuega: “Ɨima fiodailla meinoconi, naimɨe urue iñenia, ie ama naie fecɨño olle. Naimɨedɨ uruiaɨna ie ama facaina comuitaite” cuega. ");
INSERT INTO huuNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Bie rafuena uiñoiacadɨcaɨ. Siete amatɨaɨ ite. Nano doforamɨe ie aɨna ote. Naimɨe nia uruiaɨnide fiodailla. ");
INSERT INTO huuNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","31","Ie emodo imɨe ie ama fecɨñona ote. Naimɨe uruiaɨnide jɨaɨ fiodailla. Naie siete dɨgamɨedemona iese sefuide. ");
INSERT INTO huuNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ja muidomo naie rɨño jɨaɨ fiodaite. ");
INSERT INTO huuNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Fiodaillamona, ɨco naimacɨ jilloiadedɨ, ¿bu naie rɨño ienite? Naiñaiño siete dɨgamɨena ɨnirede —llotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesús uai ote: —Birui aɨna otomoɨ. Ɨnina otomoɨ; ");
INSERT INTO huuNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","iadedɨ fiodaillamona, Jusiñamui dɨga jaca itɨno jillua mei, aɨnitɨmacɨ. Ɨninitɨmacɨ; ");
INSERT INTO huuNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","ia Jusiñamui jaɨenisaɨ isoi illanona, dane fiodaiñeitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Fiodaitɨno jilluana omoɨmo lloitɨcue. Moisés mɨcorɨ jofue iñenanomo illa facaise, amena boode motodo Moisés mɨcorɨmo Jusiñamui ñaɨa facaise, naimɨe mɨcorɨmo comɨnɨ ɨco jilloillena Jusiñamui llote: “Abraham ie Jusiñamuidɨcue. Isaac ie Jusiñamuidɨcue. Jacob ie Jusiñamuidɨcue” llote. ");
INSERT INTO huuNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Jai fiodaitɨmacɨ; ia naimacɨ joreñuaɨ nia itɨmacɨ. Jusiñamuidɨ danɨ cajedɨno imacɨ Jusiñamuina jira, naimacɨ joreñuaɨ naimɨe dɨne itɨmacɨ. Ɨco naimacɨ abɨaɨna jɨaɨ jillotaite. Naimɨemo naimacɨ duillamona, naimacɨ abɨaɨ dɨga jilluanona, naimɨe dɨga jaca iitɨmacɨ —llote. ");
INSERT INTO huuNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Iena cacajano, Moisés mɨcorɨ llogacɨnuaɨna llofueraɨnɨmona dajerie raite: —Maestro, raise llotɨo. ");
INSERT INTO huuNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ie facaise naimɨemo nɨe isoide rafuena dane jɨcanuana jacɨruitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Iemei naimɨe ecɨmo itɨnomo Jesús jɨcanote: —¿Nɨese Moisés mɨcorɨ llogacɨnona llofueraɨnɨ Cristona raitɨmacɨ? ¿Nɨese naimɨedɨ David mɨcorɨ jitona raitɨmacɨ? ");
INSERT INTO huuNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Salmos railla cuegafuiaɨmo David mɨcorɨ jaie cuega: Jusiñamuidɨ cue Namamo llote: “Illaɨmana o illamona, cue nabeimo ana raɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Ona ɨɨnoñedɨno o anamo itataitɨcue”. ");
INSERT INTO huuNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","“Cristodɨ cue Nama” David mɨcorɨ raite. Iese naimɨe mɨcorɨ railla jira, Cristo David mɨcorɨ afemo faɨte. Naimɨedɨ dama David mɨcorɨ jitoñede; ia jɨaɨ ie Nama. ");
INSERT INTO huuNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Nana comɨnɨ cacajano, ie llofueganomo Jesús llote: ");
INSERT INTO huuNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Moisés mɨcorɨ llogacɨnuaɨna llofueraɨnɨmona abɨna rairui. Illaɨcomɨnɨna naimacɨ itɨmacɨdena, naimacɨna comɨnɨ cɨoillena, eo mare ɨniroina jɨtaacacabidɨmacɨ. Nɨne naimacɨ macaria, naimacɨ jamai bue isoiñedɨnona itɨmacɨdena, comɨnɨ naimacɨna uaiduana gaɨdɨmacɨ. Comɨnɨ naimacɨri acarillena, ofiracomo uicomo raɨacadɨmacɨ. Rafue ia, naimacɨ jamai bue isoiñedɨnona comecɨna facajanona, rafue nama ecɨmo raɨacadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Fecɨñuaɨmona rana ocabillanona, naiñaiñuaɨna duere fɨnodɨmacɨ. Naimɨena eo sedadɨmacɨdena, Jusiñamuimo are jɨɨcabidɨmacɨ. Iese naimacɨ icabilla jira, Jusiñamui naimacɨna jɨaɨe comɨnɨ baɨfemo duere fɨnoite. ");
INSERT INTO huuNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jusiñamui jofomo Jesús nia ia, a erodatemo, nainomo ite eenoranomo ucuberedɨno ucubena joniana cɨode. ");
INSERT INTO huuNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Eo duerede fecɨño menaruñu joniana jɨaɨ cɨode. ");
INSERT INTO huuNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ie llofueoicaiganomo Jesús llote: —Bie eo duerede fecɨño nana ucuberedɨno jonia baɨfemo jonete. ");
INSERT INTO huuNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Naimacɨmo ailluena ite; iadedɨ naie ucubemona janore jonetɨmacɨ. Naiñaiño eo duerede; iadedɨ nana naiñaiñomo ite ucubena jai jonete. Janore jonete; ia Jusiñamuimona naiñaiñodɨ jɨaɨno baɨfemo jonete. ");
INSERT INTO huuNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Naie facaise Jesús llofueoicaiganomona dajerie Jusiñamui jofona eruaɨllanona, raite: —Mare nofɨcɨ dɨga fɨnoca. Eo mare ra nainomo jɨaɨ ite. ");
INSERT INTO huuNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Jesús llote: —Birui bie rana cɨodomoɨ; iadedɨ ɨco jɨaɨruido nana bie jofomo ite nofɨcɨaɨ oni judaɨsite. ");
INSERT INTO huuNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Jɨcanotɨmacɨ: —Jusiñamui jofo judaɨsillana omo jɨcanoiacadɨcaɨ. ¿Nɨruido iena suite? Nana o lloga rafue suillena, ¿nɨe isoide rafue nano suite? Iena caɨmo llono. ");
INSERT INTO huuNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Uai ote: —Omoɨna bie rafuena bu jɨfueñellena, omoɨ abɨna rairui. Ailluena comɨnɨ cue mamecɨdo billanona: “Cristodɨcue” raitɨmacɨ. “Cristo jai bairede” raitɨmacɨ. Naimacɨ dɨbeimo iñeno. ");
INSERT INTO huuNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Jobaimiaɨ illena fɨdɨitomoɨ; iadedɨ jacɨruiñeno. Iese suite; iadedɨ abɨdo nia biñeitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Daje naɨraɨ jɨaɨe naɨraɨ dɨga jobairite. Daje gobierno jɨaɨe gobierno dɨga jobairite. ");
INSERT INTO huuNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Eo aillena ñuisañuaɨ suite. Dɨga illanomo comɨnɨdɨ aime guitɨmacɨ. Duicuaɨ eo iite. Monamo comɨnɨ dɨga jacɨrede rana cɨoitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Bie isoide rafue nia suiñenia, cuena ɨɨnoñedɨno omoɨna llogɨdoitɨmacɨ. Omoɨna gaɨtatajanona, omoɨna duere fɨnoitɨmacɨ. Naimacɨ ofiracomo omoɨna uitɨmacɨ. Cárcelmo omoɨna jonetɨmacɨ. Cuemo omoɨ duilla jira, omoɨ duere sefuillena, illaɨcomɨnɨ dɨne omoɨna uitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Naie facaiseconi cue rafuena naimacɨmo lloitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Omoɨ abɨna omoɨ rɨidoia, omoɨ lluana uicodo jarire iñeno. ");
INSERT INTO huuNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Omoɨ raise llollena, omoɨna canoitɨcue. Uiñoracɨnona omoɨmo iitɨcue. Iemona omoɨ dɨbeimo iñedɨno o uaina uaitanitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Cuena ɨɨnotomoɨ; ia ailluena cuena ɨɨnoñeitɨmacɨ. Cuemo omoɨ duilla jira, omoɨna enoitɨmacɨ. Iemona dajerie mootɨaɨ, dajerie eitɨaɨ, dajerie amatɨaɨ, dajerie nabaiñɨaɨ omoɨna llogɨdoitɨmacɨ. Omoɨmona dajeriena meineitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Cue comɨnɨna omoɨ illamona, nana naɨraɨ omoɨna enoitɨmacɨ; iadedɨ cuena faɨnonocaiñedɨmɨe ja muidomo monamo jaca iite. Naimɨena jillotaitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Omoɨ ille dɨnori Jusiñamui omoɨna raise sedaite. ");
INSERT INTO huuNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Duere omoɨ sefuia, cuena faɨnonocaiñeno jai. Ja muidomo monamo jaca iitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Jerusalén fuedo ruicabene icaifona soldaduaɨ ia, ie judaɨlle facaiseconi iaɨrei iite. ");
INSERT INTO huuNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Naiemona omoɨ jillobillena, duere omoɨ sefuiñellena, Judeamo omoɨ illamona, aneduaɨ dɨne aisɨ. Jerusalémo omoɨ ia, naiemona oni jino omoɨ jai. Jino omoɨ ia, Jerusalémo omoɨ jaiñeno. ");
INSERT INTO huuNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ie facaina lloraɨnɨ mɨcorɨaɨ cuegafuiaɨ suillanona, naie facaiseconi naimɨena ɨɨnoñedɨnomona Jusiñamui ɨbana oite. ");
INSERT INTO huuNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Naie rafuemona jillobillena, naie facaise urueside rɨño duere sefuite. Uruena nia jirode rɨñodɨ jɨaɨ duere sefuite. Naie facaise comɨnɨ duere sefuitɨmacɨ. Llegɨ cacaitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Lloebɨ dɨga meinecana uitɨmacɨ. Jɨaɨe naɨraɨ dɨne naimacɨna jaiadoitɨmacɨ. Judíuaɨñedɨno sedalle facaise dɨnori, naimacɨ anamo Jerusalémo itɨno iitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Jesús nia llofuete: —Jitoma nagarui illa isoi iñenamona, fɨvui nagarui illa isoɨ iñenamona, ucuaɨ nagarui illa isoi iñenamona, comɨnɨ jɨaɨe rafue suillena uiñoitɨmacɨ. Monaillai eo baguamona, comɨnɨ comecɨaɨ eo jarire iitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Nana monamo ite radɨ jaidɨsite. Iena raise naimacɨ uiñoñena jira, nɨe isoide rafue suillena naimacɨ uiñoñena jira, jacɨruillamona, comɨnɨ fiodaitɨmacɨ isoi iitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Naie facaise uillɨe motodo cue billena nana comɨnɨ cɨoitɨmacɨ. Ebire biitɨcue. Naimacɨna cue sedallena, illaɨmana biitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Bie isoide rafue suia, omoɨna cue jilloitajaɨbillɨrui iaɨrei illa jira, cue billɨruimo raise ocuiri. ");
INSERT INTO huuNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","’Iena omoɨ raise uiñollena, bie rafuena omoɨmo lloitɨcue. Higuera railla riaramo omoɨ comecɨaɨna faca. Nana amenamo comecɨaɨna faca. ");
INSERT INTO huuNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Bie enɨruemo amena fɨruillamona, fɨemona raɨre illana uiñotomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ie isoide. Bie rafue ɨco suia, Jusiñamui ie comɨnɨna raɨre sedajana uiñoitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Uanaicɨnona omoɨmo lloitɨcue. Nana bie rafue suille facaiseconi bie naɨraɨ nia iite. ");
INSERT INTO huuNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Mona fuite. Enɨrue jɨaɨ fuite; iadedɨ cue lloga uai jaca suite. ");
INSERT INTO huuNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Jɨfaillacɨnona omoɨ ebirui raillano, omoɨ ecɨmo ite rana ebirui raillano, abɨna rairuicana jai. Cuena ɨɨnoñedɨnona duere fɨnollena, ebena abɨdo biitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Cue bia, illaɨmana cue illamona, nana comɨnɨmo juez isoi lloitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ie jira nagarui abɨ rairuicana jai. Naie duere sefuille facaise omoɨ jilloillena, Jusiñamuimo jɨɨ. Ja muidomo monamo cue dɨga jaca iitomoɨ —llote. ");
INSERT INTO huuNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Jusiñamui jofomo Jesús nagarui llofueuide. Naɨona Olivos railla anedumo, nainomo ɨnɨllena, jaisoide. ");
INSERT INTO huuNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Nagarui jitɨramo naimɨena cacareillena, Jusiñamui jofomo comɨnɨ bisoidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Naie facaise pascua railla rafue iaɨrei ite. Naie facaise llomenico guille rafue jɨaɨ ite. Naie rafue ia, sɨritate rana jaca guiñedɨmacɨ. Egiptomona naimacɨ jaiagaɨ jillobillana comecɨllena, naie rafue ite. ");
INSERT INTO huuNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Judíuaɨ illaɨcomɨnɨ Jesúna meineiacadɨmacɨ; iadedɨ comɨnɨna jacɨruillanona, naimɨena nia meineñedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ie facaiseconi Taɨfe ie anamo Judas Iscariote mɨcorɨna itatate. Judadɨ Jesús ie doce llofueoicaigano imɨe. ");
INSERT INTO huuNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Jusiñamui dɨga nanoca ñaɨraɨnɨ dɨne jaide. Jusiñamui jofona sedaraɨnɨ dɨne jɨaɨ jaide. Jesúna gaɨtatallena, naimacɨ dɨga ñaɨaide. ");
INSERT INTO huuNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Iobillanona, naimɨemo ucubena fecaacadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judas dɨnena: —Jee —raite. Jesús dɨga ailluena comɨnɨ iñena facaiseconi naimɨena gaɨtatallena sedade. ");
INSERT INTO huuNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Llomenico guille rafue illanona, judíuaɨ comɨnɨ toɨca llauda fauillarui ride. ");
INSERT INTO huuNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jesúdɨ Pedro iaɨmaiaɨ Juan dɨga oretajano, raite: —Caɨ rafue guille uicodo fɨnollesa omɨco jai. ");
INSERT INTO huuNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Naimɨemo jɨcanotɨiaɨmaiaɨ: —¿Nɨnomo naiena coco fɨnuana jitaidɨo? ");
INSERT INTO huuNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Uai ote: —Ero, Jerusalémo omɨco ria, nogodo jɨnuina uitɨmɨena cɨoitomɨco. Naimɨe jailla jofomo naimɨena raca. ");
INSERT INTO huuNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Jofo namamo llono: “Coco llofueraɨma cocona omo jɨcanotade: ‘¿Nɨmai cue guiraco? ¿Nɨnomo guitɨcue, cue llofueoicaigano dɨga?’ ” Iese llono. ");
INSERT INTO huuNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ie mei omɨcomo afebebamo ite aillue cuartona acataite. Na raruiaɨ dɨga ite. Nainomo caɨ guille fɨno. ");
INSERT INTO huuNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Jaidɨaɨmaiaɨ. Naimɨe llua isoi baitɨiaɨmaiaɨ. Pascua rafue guille fɨnodɨaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Guille facaiseconi ia, Jesús ie llofueoicaigano dɨga nainomo guisaide. ");
INSERT INTO huuNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Mesamo guitɨmacɨmo, ie llofueoicaiganomo llote: —Nia cue fiodaiñenia, omoɨ dɨga bie rafue guillena eo jitaidɨcue. ");
INSERT INTO huuNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ie comɨnɨna cue Moo ɨco sedalle facaise ia, nana bie rafue fuite. ");
INSERT INTO huuNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Jiroracomo jai totaca vino llɨnocaida, Jusiñamuimo iobillacɨnona fecaja mei, raite: —Mai llɨno. Biemona nana dajena omoɨ jiro. ");
INSERT INTO huuNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Omoɨna bene dane iese caɨmare nabaiñeitɨcue. Cue Moo sedajanomo omoɨ dɨga ɨco cue ia, nainomo omoɨna dane iese caɨmare marena nabaitɨcue. —Iena jirodɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Llomenicona llɨnuanona, Jusiñamuimo iobillacɨnona fecaja mei, iena taɨrude. Naimacɨmo fecajano raite: —Biedɨ cue abɨ facai ie. Omoɨ facaina fiodaitɨcue. Cue abɨmo omoɨ comecɨna facajano, iena guiño. ");
INSERT INTO huuNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Naimacɨ guilla fuilla mei, jiroracomo vino dɨga dane oruitajanona, naimacɨna jirotate. Raite: —Cue fiodaillamona, dama cue dɨaillamona, jeacɨno anamona jilloitomoɨ. Jusiñamuidɨ omoɨmo jɨaɨe rafue birui itatajanona, omoɨ jeacɨno oni dotajana jai llote. Bie vinodɨ naie rafue facai ie. —Iena jirodɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Jesús llote: —Ero, cuena gaɨtataitɨmɨe caɨ dɨga guite. ");
INSERT INTO huuNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Monamona billanona ɨimana jaidɨcue. Jusiñamui jitailla isoi jai jaioicaidɨcue; iadedɨ Jusiñamuimona cuena gaɨtataitɨmɨe eo duere sefuite. ");
INSERT INTO huuNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Iemei: “¿Nɨmɨe Jesúna gaɨtatalle?” danɨ coninɨri siadosɨde. ");
INSERT INTO huuNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ie facaise coninɨri siaduana raitɨmacɨ: —¿Caɨ moto imɨena bu ille? ");
INSERT INTO huuNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Iena cacajanona, Jesús raite: —Naimacɨ jitailla ra fɨnollena, judíuaɨñedɨno illaɨmaɨaɨdɨ naimacɨ anamo itɨnona ocuicabide. “Caɨ anamo itɨnona canocabidɨcaɨ” raitɨmacɨ; ");
INSERT INTO huuNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","iadedɨ omoɨmo iese iñede. Omoɨ moto itɨmɨe omoɨ moto imɨeñedɨmɨena jailla. Omoɨmona bu imɨena iacania, omoɨ mullaɨmana naimɨe jaicabillasa. Omoɨmona bu imɨena iacania, omoɨna naimɨe canocana jaicabillasa. ");
INSERT INTO huuNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ero, jɨaɨe rafuedo iena lloitɨcue. Naimɨena ecallena, naimɨena canollena, patrón anamo ie mullaɨaɨ itɨmacɨ. Naimacɨ baɨfemo patrón illamona, naimacɨna canollena, ie mullaɨaɨ facaina maɨjɨñede. Cue anamo itomoɨ; ia omoɨna canollena, omoɨ mullaɨma isoi itɨcue. ");
INSERT INTO huuNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Birui duere cue sefuidɨcuemo, cuena faɨnonocaiñedomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Cue Moo cuena illaɨmana jai itatate. Omoɨna fetodɨcue, ");
INSERT INTO huuNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","jɨaɨruido cue illaɨma illa facaiseconi cue ecɨmo omoɨ caɨmare marena iocɨre illena. Nainomo omoɨ judíuaɨ doce naɨraɨaɨna sedaitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Jesús llote: —Simón Pedro, ero, Taɨfedɨ Jusiñamuimo ona jɨcanote, o ramo faɨllena; ");
INSERT INTO huuNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","iadedɨ ori jai jɨɨdɨcue, cuena nia ɨɨnocana o jaillena. Ɨco cuena raise o ɨɨnoñena mei, cue dɨbeimo o comecɨ iuai dane o meidoia, iemona jɨaɨe creyentiaɨ comecɨaɨna ocuiñotaitɨo. ");
INSERT INTO huuNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pedro uai ote: —Nama, cárcelmo o ia, nainomo jɨaɨ iitɨcue. O fiodaia, jɨaɨ fiodaitɨcue. Ona faɨnonocaiñeitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesús uai ote: —Pedro, jitɨramo ɨitava nia ñaɨñenia, dacaiño amani cuena janoitɨo. ");
INSERT INTO huuNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ie llofueoicaiganomo Jesús llote: —Omoɨmo ite rafuena uiñoiacadɨcue. Cue rafue llollena, navui omoɨna oredɨcue. “Ucubena uiñeno, bolsa uiñeno, meidolle zapatos uiñeno” omoɨmo llotɨcue. Naie facaiseconi omoɨ, ¿bue rana jitaidomoɨ? Uai otɨmacɨ: —Caɨ buena jitaiñedɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Jesús raite: —Biruimona omoɨ duere sefuitomoɨ. Ie jira abɨna rairuicana jai. Birui ucube omoɨmo ia, nɨne omoɨ jaia, iena uiño. Bolsa bumo ia, iena uiño. Abɨna rɨidollena, omoɨmo lloebɨ iñenia, janore ɨniroina feca, lloebɨ ollena. ");
INSERT INTO huuNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Cuena jaie cuegafuiaɨ ja suite. Isaías mɨcorɨ cuena jaie cuega: “Maraiñede rafue fɨnoraɨma isoi naimɨe duere sefuite”. ");
INSERT INTO huuNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Raitɨmacɨ: —Ero, Nama, mena lloebɨ caɨmo birui ite. Jesús uai ote: —Mena ia, macaɨbaite. ");
INSERT INTO huuNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Guille mei, ie llofueoicaigano dɨga, Jesús jino jaide. Olivos railla anedumo naimɨe jaisoilla isoi jaide. ");
INSERT INTO huuNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Nainomo ria, naimacɨmo llote: —Taɨfe omoɨna ramo faɨ raillano, iena omoɨ ɨɨnoñellena, Jusiñamuimo jɨɨ —llote. ");
INSERT INTO huuNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Naimɨe janorede nofɨcɨ baɨ faɨa uailla dɨnori baɨ jaide. Caiñɨcɨ ɨfodo ana raɨta, Jusiñamuimo jɨɨde: ");
INSERT INTO huuNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","—Ore Moo, o jitaia, cue duere sefuillamona cuena jillota. Cue jitailla isoi cuena fɨnoñeno; iadedɨ o jitailla isoi cuena fɨno. ");
INSERT INTO huuNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Naimɨe comecɨna ocuiñotallena, ie facaiseconi monamona Jusiñamui jaɨenicɨ bite. ");
INSERT INTO huuNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Jesús comecɨ jarire illamona, naimɨe rɨocɨ faɨtemo, dɨfai dɨruena enɨruemo uaide. ");
INSERT INTO huuNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Jɨɨa mei, ie llofueoicaigano dɨne abɨdo bite. Ocosinaillamona, jai ɨnɨdɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Naimacɨmo jɨcanote: —¿Bue ñellena ɨnɨdomoɨ? Mai casi. Taɨfe ramo omoɨna faɨ raillano, iena omoɨ ɨɨnoñellena, Jusiñamuimo jɨɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Nia Jesús lloia, dɨga comɨnɨ naimɨe dɨne bitɨmacɨ. Judas Iscariote mɨcorɨ naimacɨna ɨfode. Naimɨedɨ Jesús llofueoicaigamɨe. Naimɨena llibanollena. Jesús dɨne iaɨrei bite. ");
INSERT INTO huuNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Jesús raite: —Judas, cuena llibanuanona, cuena gaɨtataiacadɨo. ");
INSERT INTO huuNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ie llofueoicaigano naie rafuena jai cɨodɨmacɨ. Jɨcanotɨmacɨ: —Nama, ¿caɨ atɨca lloebɨ dɨga ona rɨidoitɨcaɨ? ");
INSERT INTO huuNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ie facaise naimacɨmona damɨedɨ Jusiñamui dɨga nanoca ñaɨraɨma ie mullaɨma ie nabei jefona jaɨbonote. ");
INSERT INTO huuNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Jesús dɨnena raite: —Dama ite. —Ie jefona naimɨe jetajamona, naimɨena jillotate. ");
INSERT INTO huuNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Dɨga illaɨcomɨnɨ Judas dɨga Jesús dɨne bitɨmacɨ. Naimacɨmo Jesús llote: —Fɨɨriraɨmadɨcueta cuena omoɨ gaɨtajaɨbilla. Omoɨ lloebɨna atɨdomoɨ. Omoɨ butaralluna jɨaɨ atɨdomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Nagarui Jusiñamui jofomo omoɨ motomo llofuecabitɨcue; iadedɨ cuena gaɨtañedomoɨ. Jusiñamui jitailla jira, cuena omoɨ gaɨtaja facaise jai ride. Taɨfe anamo jai itomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Naimɨena gaɨtaja mei, Jusiñamui dɨga nanoca ñaɨraɨma jofomo uitɨmacɨ. Pedro aarena naimacɨ jɨnafona racade. ");
INSERT INTO huuNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Naɨraɨbɨrɨ motomo irai bonua mei, ana raɨdɨmacɨ. Pedro naimacɨ dɨga jɨaɨ raɨde. ");
INSERT INTO huuNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Nainomo ite mullaɨñodɨ irai bouamona, Pedromo eruaɨllano raite: —Bimɨedɨ Jesús dɨga jaisoɨdɨmɨe. ");
INSERT INTO huuNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pedro abɨ janote: —Naimɨena uiñoñedɨcue. ");
INSERT INTO huuNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Dallu illanona, jɨaɨmɨe Pedrona cɨuanona llote: —Jesús ie llofueoicaigano imɨedɨo. Pedro dɨnena uai ote: —Imɨeñedɨcue. ");
INSERT INTO huuNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Daje hora illanona, jɨaɨmɨe raite: —Bimɨe galileo imɨena jira, bimɨedɨ Jesús dɨga ua jaisoidɨmɨe. ");
INSERT INTO huuNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pedro dɨnena raite: —O lluana uiñoñedɨcue. —Ieconi naimɨe ñaɨtemo, ɨitava ñaɨte. ");
INSERT INTO huuNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Jesús dobaidacaida, Pedromo erodacaide. Iemei Pedro Jesús lluana uibiñote. Jesús naimɨemo jaive llote: “Ɨitava nia ñaɨñenia, dacaiño amani cuena janoitɨo”. ");
INSERT INTO huuNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Pedro jino jaillanona, eo sunaillamona, eo eede. ");
INSERT INTO huuNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ie facaise Jesúna gaɨtadɨno naimɨena jɨfanododɨmacɨ. Naimɨena jɨaɨ fatɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ie uisɨna maɨtɨmacɨ. Llotɨmacɨ: —Siño jitodɨosa, ¿bu o faja? caɨmo llono. ");
INSERT INTO huuNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Iese jɨfanodocana uitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Monaidemo judíuaɨ illaɨcomɨnɨ ofidɨmacɨ. Jusiñamui dɨga nanoca ñaɨraɨnɨ ofidɨmacɨ. Moisés mɨcorɨ llogacɨno llofueraɨnɨ ofidɨmacɨ. Naimacɨ dɨne naimɨena gaɨtadɨno Jesúna uitɨmacɨ. Naie illaɨcomɨnɨ dɨnena raitɨmacɨ: ");
INSERT INTO huuNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—Ua Cristodɨona, iena caɨmo llono. Jesús uai ote: —Omoɨmo iena cue lloia, ɨɨnoñeitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Buena omoɨmo cue jɨcanoia, cue uaina oñeitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Monamona jaie billanona, ɨimana jaidɨcue. Cuena omoɨ meiniamona, illaɨma isoi Jusiñamui ecɨmo raɨre iitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Nana jɨcanotɨmacɨ: —“¿Jusiñamui Jitodɨcue” raitɨo? Uai ote: —Raise cacadomoɨ. Imɨedɨcue. ");
INSERT INTO huuNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Iena cacajano, raitɨmacɨ: —Naimɨe lluana jai cacadɨcaɨ. Jɨaɨe comɨnɨ naimɨena llogɨduana jai jitaiñedɨcaɨ. “Jusiñamui Jitona itɨcue” naimɨe llua jira, Jusiñamuina jai jeare ñaɨte. Naimɨe Jusiñamui Jitoñede. ");
INSERT INTO huuNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Judíuaɨ illaɨcomɨnɨ naidacaillanona, Pilato dɨne Jesúna uitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Naimɨena llogɨdotɨmacɨ: —Caɨ comɨnɨmo maraiñedɨfuena llote. Gobiernomo ucubena caɨ fecajana rairuide. Naimɨe jɨaɨ raite: “Cristodɨcue. Illaɨmadɨcue”. ");
INSERT INTO huuNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilato dɨnena naimɨemo jɨcanote: —¿Judíuaɨ comɨnɨ illaɨmadɨo? Uai ote: —Jɨɨ, judíuaɨ illaɨmadɨcue. ");
INSERT INTO huuNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Jusiñamui dɨga nanoca ñaɨraɨnɨmo Pilato llote. Nainomo bite comɨnɨmo jɨaɨ llote: —Nɨcɨnodɨ naimɨemo iñede. ");
INSERT INTO huuNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Uai otɨmacɨ: —Gobierno joreño comɨnɨ comecɨaɨ jeare feidocana naimɨe uite. Nana Judeamo uite. Galileamona taɨnede. Bene jai caɨmo ride. ");
INSERT INTO huuNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Iena cacajano, naimɨe llogɨdotɨnomo Pilato jɨcanote: —¿Naimɨedɨ Galilea imɨe? ");
INSERT INTO huuNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","—Jɨɨ —raitɨmacɨ. Galilea enɨrue illaɨma Herodes. Naie facaiseconi Jerusalémo naimɨe illa jira, naimɨe dɨne Pilatodɨ Jesúna orede. ");
INSERT INTO huuNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Jesúna Herodes cɨuanona, iobide. Naimɨe fɨnoca rafuena naimɨe fɨdɨa jira, naimɨena cɨoacade. Siño rafuena naimɨe fɨnuana jɨaɨ cɨoacade. ");
INSERT INTO huuNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Jesúmo ie fɨnoca rafuena are jɨcanote; iadedɨ Jesús dɨnena uaina oñede. ");
INSERT INTO huuNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ie facaiseconi judíuaɨ illaɨcomɨnɨ Jesúna rɨire llogɨdotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herodes ie soldaduaɨ dɨga naimɨena eo jeare ñaɨtɨmacɨ. Illaɨma jɨtauiga ɨniroina jɨtatatɨmacɨ. Ie mei Pilato dɨne naimɨena abɨdo orede. ");
INSERT INTO huuNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Iemona nairuido Herodes Pilato dɨga nabairite. Jaie conimana enoidɨaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilatodɨ judíuaɨ illaɨcomɨnɨna, nainomo ite comɨnɨ dɨga, uaidote. ");
INSERT INTO huuNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Raite: —Bimɨe cue dɨne atɨdomoɨ. Raitomoɨ: “Comɨnɨ comecɨaɨ feidocana naimɨe uite”. Naimɨemo jai jɨcanotɨcue; ia naimɨemo nɨcɨnodɨ iñede. ");
INSERT INTO huuNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herodes cue dɨne naimɨena como abɨdo orede. “Naimɨemo nɨcɨnodɨ iñede” jɨaɨ raite. Naimɨena cue meinetallena, naimɨe jaca nɨcɨnona fɨnoñede. ");
INSERT INTO huuNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ie jira naimɨena cue sechedotajanona, naimɨena oni oretaitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Naie rafue facaiseconi naga año cárcelmona damɨena jino jamai oretauide. ");
INSERT INTO huuNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Pilato lluana cacajano, nana comɨnɨ ado cuiriidɨmacɨ: —¡Naimɨena oni uiño, naimɨena meinellena! ¡Barrabás cárcelmona jino oreta! ");
INSERT INTO huuNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Gobierno dɨga jobaimena naimɨe navui fɨnua jira, naie facaise comena naimɨe meinia jira, Barrabás cárcelmo ite. ");
INSERT INTO huuNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Jesúna naimɨe jamai oretaiacana jira, comɨnɨ dɨga Pilato dane ñaɨte; ");
INSERT INTO huuNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","iadedɨ cuiriidɨmacɨ: —¡Naimɨena coraɨ! ¡Naimɨena meine! ");
INSERT INTO huuNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilato dane jɨcanote: —¿Nɨe isoide maraiñede rafuena fɨnode? Naimɨena caɨ meinellena, naimɨe jaca nɨcɨnona fɨnoñede. Naimɨena sechedotaitɨcue. Ie mei naimɨena jamai oretaitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Eo rɨire cuiriidɨmacɨ: —¡Naimɨena coraɨ! —Ja muidomo Pilato dɨnena: —Jee —raite. ");
INSERT INTO huuNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Naimacɨ jitailla isoi Pilato faɨriote. Jesúna meinellena llote. ");
INSERT INTO huuNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ie mei Barrabásna cárcelmona jino oretate, naimɨena comɨnɨ jɨcaja jira; iadedɨ Jesúna naimacɨmo fecade, naimɨemo naimacɨ jitailla ra naimacɨ fɨnollena. ");
INSERT INTO huuNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Jesúna soldaduaɨ oni uitemo, Simón raillamɨe dɨga dafaɨfidɨmacɨ. Naimɨedɨ Cirene railla enɨrue imɨe. Jerusalén onifemona bite. Jesús jɨnafona naimɨena cruzna rocaoicaida sonotate. ");
INSERT INTO huuNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ailluena comɨnɨ Jesúna racadɨmacɨ. Ailluena rɨñonɨaɨ eo eecana jaisɨte. ");
INSERT INTO huuNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Iena cacajano, Jesús naiñaiñuaɨ dɨne dobaidacaida, naiñaiñuaɨmo llote: —Jerusalén itɨñaiñuaɨ, cue facaina eeñeno; iadedɨ omoɨ facaina mai omoɨ ee. Omoɨ uruiaɨ facaina mai omoɨ ee. ");
INSERT INTO huuNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ero, jɨaɨruido duere sefuillemona comɨnɨ raitɨmacɨ: “Oɨniñuaɨ jɨaɨe rɨñonɨaɨ baɨfemo duere sefuiñena jira, marena itɨmacɨ”. ");
INSERT INTO huuNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Jusiñamui rɨicaillafuemona jilloiacanamona, comɨnɨ jɨaɨ raitɨmacɨ: “Aneduaɨ caɨmo jaɨcorillana jitaidɨcaɨ”. ");
INSERT INTO huuNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Maraiñede rafuena fɨnoñedɨcue; iadedɨ jai duere sefuidɨcue, Maraiñede rafuena fɨnodɨmacɨ. Ie jira cue baɨfemo eo duere sefuitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Naie iaɨmaiaɨna meinellena, mena maraiñede ɨimana jɨaɨ uitɨmacɨ. Gobierno llogacɨnona ɨɨnoñedɨiaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ɨfocoraɨna eruaɨlla illanomo naimacɨ ria, Jesúna coraɨdɨmacɨ. Naie maraiñede iaɨmaiaɨna jɨaɨ coraɨdɨmacɨ. Damɨe Jesús nabeimo. Jɨaɨmɨe Jesús jarɨfebeimo. ");
INSERT INTO huuNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jesús ie Moomo llote: —Ore Moo, naimacɨ fɨnoca rafuena naimacɨ raise uiñoñena jira, bie soldaduaɨ cuena duere fɨnua rafuena feita —llote. Bu dajerie uille uiñollena, Jesús ɨniroina jɨfanoduano soldaduaɨ facasɨte. ");
INSERT INTO huuNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ailluena comɨnɨ eruaɨdɨmacɨ. Judíuaɨ illaɨcomɨnɨdɨ naimɨena jɨfanoduanona, coninɨri raitɨmacɨ: —Naimɨedɨ jɨaɨe comɨnɨna duicomona jillotate. ¿Nɨese dama naimɨe abɨna birui jillotañede? Naimɨedɨ Jusiñamui oretagamɨedena, Jusiñamui fetocamɨedena, fiodaillamona dama naimɨe abɨna jillotarede. ");
INSERT INTO huuNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Soldaduaɨ naimɨena jɨaɨ jɨfanododɨmacɨ. Ie abɨ isirena cacaiñellena, naimɨemo vino fecajanona, ");
INSERT INTO huuNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","raitɨmacɨ: —Judíuaɨ illaɨmadɨodena, fiodaillamona dama o abɨna jillota. —Naie vino Jesús jiroñede. ");
INSERT INTO huuNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Jesús ɨfogɨ afeconi rabɨcɨmo Pilato cuetatate: “Bimɨedɨ judíuaɨ comɨnɨ illaɨma”. ");
INSERT INTO huuNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Jesús dɨga coraɨca iaɨmaiaɨmona damɨe naimɨena taigode: —Jusiñamuimona bitɨodena, nia fiodaiñenamona dama o abɨna jillota. Cocona jɨaɨ jillota. ");
INSERT INTO huuNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Jɨaɨmɨedɨ naimɨena lletade: —¿Bue ñellena bimɨena taigodɨo? ¿Nɨese jearede rafuena nia fɨnoacadɨo? Ja fiodaitɨo. Iemei Jusiñamui uicomo ja iitɨo. ¿Nɨese Jusiñamui uicomo o illena jacɨruiñedɨo? ");
INSERT INTO huuNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Maraiñede rafuena coco fɨnua jira, duere sefuidɨcoco; iadedɨ bimɨe maraiñede rafuena fɨnoñede. ");
INSERT INTO huuNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Iemei Jesúmo llote: —Illaɨmana o illa facaise cuena comecɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesús uai ote: —Uanaicɨno llotɨcue. Birui cue dɨga cue Moo illanomo iitɨo. ");
INSERT INTO huuNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Jitoma naidai jai itemo, daje amani horas mona jitɨbicaide. ");
INSERT INTO huuNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Jitoma raise llɨgaiñoñede. Jusiñamui jofo ie fetaca ɨniroife ana anaba jillacɨmo motodo menafe cuararide. ");
INSERT INTO huuNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Jesús ado llote: —Ore Moo, cue joreñona feiño. —Ie mei naimɨe jai fiodaite. ");
INSERT INTO huuNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Soldaduaɨ imacɨ capitán bie rafuena cɨuano, Jusiñamuina jacɨruillamona, raite: —Bimɨe maraiñede rafuena fɨnoñede. ");
INSERT INTO huuNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ailluena comɨnɨ Jesús fiodaillana cɨodɨmacɨ. Ie mei eo sunaillamona, jogobemo faɨruanona, jofomo abɨdo jaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Jesús nabaiñɨaɨ bie rafuena aarena cɨodɨmacɨ. Galileamona bite rɨñonɨaɨ bie rafuena aarena jɨaɨ cɨodɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","52","Pilato dɨne José raillamɨe jaide, Jesús abɨna jɨcallena. Naimɨedɨ illaɨcomɨnɨ. Maremɨe. Ɨɨnogamɨe. Jesúna meiniana jitaiñede. Arimatea railla naɨraɨ imɨe. Judeamo naie naɨraɨ ite. Naimɨedɨ Jusiñamui ie comɨnɨna ɨco sedajanomo illemo ocuiride. ");
INSERT INTO huuNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Pilato: —Jee —railla mei, Jesús abɨna cruzmona ana uanona, iena useroi dɨga ferɨnote. Nofɨcɨ ie raɨafomo jonete. Nia bu raɨñenafomo jonete. ");
INSERT INTO huuNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Nairui viernes. Sábadorui rille jai iaɨrei illa jira, Jesús abɨna raɨafomo raɨre jonete. ");
INSERT INTO huuNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Galileamona navui bite rɨñonɨaɨ racadɨmacɨ. Raɨafona cɨodɨmacɨ. Naimɨe abɨ fɨnuana cɨodɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ie jira caɨmare soride rana fɨnollena, naimɨe abɨmo jonellena, jofomo jaidɨmacɨ. Naie ra fɨnua mei, ie abɨna raise fɨnollena, raɨafomo abɨdo jaidɨmacɨ. Ie mei sábadoruimo jafaicɨ otɨmacɨ, Moisés mɨcorɨ jaie llua isoi. ");
INSERT INTO huuNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Domingo jitɨramo monaidemo, naie rɨñonɨaɨ raɨafomo jaidɨmacɨ, iñaiñuaɨ fɨnoca soride rana uillena. ");
INSERT INTO huuNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Raɨafo ɨbailla nofɨcɨ oni joillana cɨodɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Fo jaidemo, Jesús abɨna cɨoiñedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Uainicaidɨmacɨ. Ieconi menamɨe naiñaiñuaɨ ecɨmo bairedɨiaɨmaiaɨ. Iaɨmaiaɨ ɨniroi eo quenirede. ");
INSERT INTO huuNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Iaɨmaiaɨna jacɨnaillamona, ɨfogɨ ana jɨtadacaidɨmacɨ. Naie iaɨmaiaɨ dɨnena jɨcanote: —¿Bue ñellena fiodaitɨmɨe illanomo cajedɨmɨena jenodomoɨ? ");
INSERT INTO huuNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Galileamo navui naimɨe omoɨmo llogacɨnona comecɨñedomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Naimɨe raite: “Monamona billanona, ɨimana jaidɨcue. Jusiñamui jitailla jira, maraiñede rafue fɨnoraɨnɨ anamo iitɨcue. Cuena coraɨitɨmacɨ. Darui amani illanona, fiodaillamona jilloitɨcue” raite. ");
INSERT INTO huuNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Iemona ie llogacɨnona jai comecɨtɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Raɨafomona abɨdo jaidɨmacɨ. Ie once llofueoicaiganomo naiñaiñuaɨ cɨua rafuena llotɨmacɨ. Naie llofueoicaigano dɨga itɨnomo jɨaɨ llotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Naie rɨñonɨaɨmona María Magdalena ite. Juana ite. María ite. Naiñaiñodɨ Jacobo ei. ");
INSERT INTO huuNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Naie rɨñonɨaɨdɨ iena llotɨmacɨ; iadedɨ ie rafuena cacadɨnodɨ iena ɨɨnoñedɨmacɨ. —Jamaifuena ñaɨtomoɨ —raitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Iena cacajano, Pedro aisɨcana raɨafomo jaide. Nainomo ria, ana jɨtadacaida, fo erodate. Useroi joillana cɨode. Iemo ie comecɨna facajano, jofomo abɨdo jaide. ");
INSERT INTO huuNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Jesús jilluarui mena llofuega iaɨmaiaɨ Emaús railla naɨraɨmo jaidɨaɨmaiaɨ. Jerusalémona nɨbaɨ once kilómetros ite. ");
INSERT INTO huuNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Nana Jesúmo suide rafuena ñaɨano jaidɨaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Iaɨmaiaɨ ñaɨanona, Jesús iaɨmaiaɨ dɨga dafaɨfillanona, iaɨmaiaɨ dɨga jaide. ");
INSERT INTO huuNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Jusiñamuidɨ iaɨmaiaɨna naimɨena uiñotañena jira, naimɨena uiñoñedɨaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Iaɨmaiaɨmo Jesús jɨcanote: —¿Buena ñaɨtomɨco? —Ieconi naidadatɨiaɨmaiaɨ. Sunaitɨiaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Naie iaɨmaiaɨmona damɨedɨ Cleofas. Naimɨe uai ote: —¿Nɨese Jerusalémo birui suide rafuena uiñoñedɨo? Nɨbaɨ como ridɨo. Nana jɨaɨ comɨnɨ iena uiñotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Uai ote: —¿Nɨe isoide rafue suide? Uai otɨiaɨmaiaɨ: —Nazaret ie Jesús rafue. Naimɨedɨ Jusiñamui facaina lloraɨma. Dɨga siño rafuena fɨnode. Comɨnɨna raise llofuete. Jusiñamuimona naimɨedɨ maremɨe. Comɨnɨmona naimɨe maremɨe; ");
INSERT INTO huuNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","iadedɨ caɨ illaɨcomɨnɨ naimɨena gaɨtatatɨmacɨ. Naimɨena cruzmo coraɨtatɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Jusiñamui naimɨe caɨ dɨne orecamɨemo comecɨna facadɨcoco. Naimɨe caɨ illaɨmana illemo ocuiridɨcoco; ia naimɨe jai fiodaite. Naimɨe fiodaillamona darui amani jai ite. ");
INSERT INTO huuNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Caɨ comɨnɨmona dajerie rɨñonɨaɨbirui caɨna jacɨnaitadɨmacɨ. Jitɨramo Jesús raɨafomo jaidɨmacɨ; ");
INSERT INTO huuNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","iadedɨ naimɨe abɨna cɨoiñedɨmacɨ. Abɨdo naimacɨ bia: “Jusiñamui jaɨenisaɨna cɨodɨcaɨ” raitɨmacɨ. Naie jaɨenisaɨ naimacɨmo llote: “Naimɨedɨ caje”. ");
INSERT INTO huuNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Iemei caɨmona dajerie raɨafomo jaidɨmacɨ. Rɨñonɨaɨ llua isoi cɨodɨmacɨ. Jesús abɨna cɨoiñedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Jesús dɨnena uai ote: —Abɨ uiñoñedomɨco. Nana Jusiñamui facaina lloraɨnɨ mɨcorɨaɨ cuegafuiaɨna ɨɨnoiacaiñedomɨco. ");
INSERT INTO huuNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Cristo duere sefuillena cuetɨmacɨ. Jusiñamui iena jitaillena cuetɨmacɨ. “Naimɨe nia illaɨmana jaiñenia, duere sefuite” cuetɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Iemei Jesús iaɨmaiaɨna llofuete. Moisés mɨcorɨ cuegafuiaɨna llofuete. Jusiñamui facaina lloraɨnɨ mɨcorɨaɨ cuegafuiaɨna jɨaɨ llofuete. Nana Cristona cuegafuiaɨna llofuete. ");
INSERT INTO huuNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Emaús dɨne iaɨrei naimacɨ ria, Jesús nia jaiacademo, ");
INSERT INTO huuNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","naimɨena caidɨdɨaɨmaiaɨ. Raitɨiaɨmaiaɨ: —Coco dɨga fɨebi. Jitoma jai ana ite. Jai abɨ juanide, nia o jaillena. —Ie muidona iaɨmaiaɨ dɨga fɨebillena fo jaide. ");
INSERT INTO huuNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Naillɨ guitɨmacɨmo, llomenicona Jesús llɨnuano, Jusiñamuimo iobillacɨnona fecade. Iena taɨruano, iaɨmaiaɨmo fecade. ");
INSERT INTO huuNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Jusiñamui jitailla jira, ieconi Jesúna uiñotɨiaɨmaiaɨ. Iemei iaɨmaiaɨmona naimɨena jai cɨoicaiñena. ");
INSERT INTO huuNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Daɨmaiaɨ ñaɨtɨiaɨmaiaɨ: —Coco dɨga naimɨe ñaɨa, coco comecɨ caɨmare ite. ");
INSERT INTO huuNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Naie dacaiño Jerusalémo abɨdo jaidɨaɨmaiaɨ. Jesús llofueoicaigano naimacɨ nabaiñɨaɨ dɨga danomo illana baitɨiaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Iaɨmaiaɨmo llotɨmacɨ: —Caɨ Nama fiodaillamona jai jillode. Simón Pedromo jai bairede. ");
INSERT INTO huuNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ie mei naɨsona iaɨmaiaɨ jailla rafuena llotɨiaɨmaiaɨ: —Caɨ guitɨcaɨmo, naimɨena uiñotɨcoco —llotɨiaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","“Jesúna cɨodɨcoco” llotɨiaɨmaiaɨmo, ie llofueoicaigano motomo Jesús bairede. Llote: —Jai bitɨcue. Uri omoɨ i. ");
INSERT INTO huuNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Naimɨena cɨuamona, jacɨnaitɨmacɨ. “Joreñona cɨodɨcaɨ” comecɨaɨna facajanona, jɨaɨ jacɨruitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Naimacɨmo Jesús jɨcanote: —¿Bue ñellena jacɨruitomoɨ? ¿Bue ñellena cue bene illana ɨɨnoñedomoɨ? ");
INSERT INTO huuNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Cue onollɨmo eruaɨ. Cue eɨllɨmo eruaɨ. Jesúdɨcue. Cuena jeta, raise uiñollena. Cuemo llɨcɨsi ite. Cuemo illaicɨ ite. Jamai joreño isoiñedɨcue. ");
INSERT INTO huuNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Iena llua mei, coraɨafona naimacɨ cɨoillena, ie onollɨ ie eɨllɨ dɨga acatate. ");
INSERT INTO huuNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Iobiacadɨmacɨ; iadedɨ nia raise ɨɨnoñedɨmacɨ. Iemo comecɨaɨna nia facadɨmacɨmo, naimacɨmo jɨcanote: —¿Bue illa, cue guillena? ");
INSERT INTO huuNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Naimɨemo janorede jai ruica llɨcɨaɨna fecadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Iena feiñuanona, rɨte. Iena cɨodɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Naimacɨmo llote: —Navui omoɨ dɨga cue ia, dɨga rafue omoɨmo llotɨcue. Moisés mɨcorɨ cuena cuete. Jusiñamui facaina lloraɨnɨ mɨcorɨaɨ cuena cuetɨmacɨ. Jusiñamui jitailla jira, iena jai suide. ");
INSERT INTO huuNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Naie facaiseconi naimacɨna naie cuegafuiaɨna raise uiñotade. ");
INSERT INTO huuNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Naimacɨmo llote: —Jusiñamui facaina lloraɨnɨ mɨcorɨaɨ cuena jaie cuetɨmacɨ: “Cristo duere sefuite. Fiodaillamona darui amani illanona, jilloite. ");
INSERT INTO huuNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Naimɨe muidona comecɨaɨ iuai meiduamona, Jusiñamui naimacɨ jeacɨnona oni dotaite. Naimɨe rafue nana naɨraɨmo damɨerie lloitɨmacɨ”. Omoɨmo biena lloitɨcue. Cue rafuena llollena, Jerusalémo taɨneitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Bie rafuena cɨodomoɨ. Iena lloitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ero, navui naimɨe llua isoi, cue Moo Joreño omoɨ dɨne oretaitɨcue. Jerusalémo fɨebi, naimɨe Joreño omoɨ feiñolle dɨnori. Cue rafuena omoɨ llollena, naimɨe Joreño omoɨ comecɨaɨna ocuiñotaite. ");
INSERT INTO huuNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Betania railla naɨraɨ dɨne Jesús naimacɨna ɨfode. Marecɨnona naimacɨmo llote. —Jusiñamui omoɨna raise marena canoite —llote. ");
INSERT INTO huuNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Iena naimacɨmo lluanona, monamo jaide. ");
INSERT INTO huuNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Jerusalémo eo caɨmare abɨdo jaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Jusiñamuimo iobillacɨno fecajano, Jusiñamui jofomo nagarui itɨmacɨ. Mai. Macaɨbaite. Lucadɨcue.");
INSERT INTO huuNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Jaca bue nia iñenia, Cristo jaca ite. Jusiñamui uai naimɨemo illamona, naimɨe caɨna Jusiñamuina birui uiñotade. Jusiñamuimo jaca duide. Naimɨedɨ Jusiñamui. ");
INSERT INTO huuNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Jusiñamui dɨga jaca nano ite. ");
INSERT INTO huuNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Naga ite rana fɨnode. Naimɨe fɨnoñega ra jaca iñede. Naga ite rana comuitaga. Naimɨe comuitañega ra jaca iñede. ");
INSERT INTO huuNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Naimɨe muidona itɨcaɨ. Naimɨena caɨ ɨɨnuamona, jaca iitɨcaɨ. Llɨgaiñora dɨga rana caɨ cɨua isoi, caɨna Jusiñamuina uiñotade. ");
INSERT INTO huuNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Naimɨena ɨɨnoñedɨno jitɨredɨnomo itɨmacɨ isoidɨmacɨ. Naimacɨ comecɨaɨ jitɨrede. Ie uaido naimacɨ comecɨaɨna llɨgaiñote, naimacɨ comecɨaɨmo ite jeacɨno oni jaillena. ");
INSERT INTO huuNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","7","Naimacɨ comecɨaɨna llɨgaiñotɨmɨena llollena, Juan mɨcorɨ lluacɨnodo Jusiñamuina nana comɨnɨ ɨɨnollena, Jusiñamuidɨ Juan Bautista raillamɨe mɨcorɨna oretate. ");
INSERT INTO huuNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Juan naie llɨgaiñoñedɨmɨe; iadedɨ Juan naimɨena lluaɨbite. ");
INSERT INTO huuNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Nanoca llɨgaiñotɨmɨena llote. Nanoca llɨgaiñotɨmɨedɨ enɨruemo billanona, nana comɨnɨ comecɨaɨna llɨgaiñote. ");
INSERT INTO huuNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Naimɨe muidona comɨnɨ comuidɨmacɨ; iadedɨ naimɨe bene billa meinoconi, comɨnɨ dɨnena naimɨena uiñoñedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ie naɨraɨ illanomo naimɨe ride; iadedɨ nana caɨ naɨraɨ naimɨena feiñoñedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Damɨerie naimɨena feiñotɨmacɨ. Naimɨena ɨɨnotɨmacɨ. Ie uaido naimɨedɨ naimacɨna Jusiñamui uruiaɨna itatate. ");
INSERT INTO huuNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Iena Jusiñamui jitailla jira, Jusiñamui uruiaɨna jaidɨcaɨ. Comemona jeicɨamona iena jaiñedɨcaɨ. Comɨnɨ jitaillamona iena jaiñedɨcaɨ. Buena caɨ fɨnuamona iena jaiñedɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Iemo caɨna Jusiñamuina uiñotallena, Jusiñamui Jito comena jaide. Naie facaise caɨ comɨnɨ motomo naimɨe ite. Caɨ comɨnɨna eo duenaite. Uanaicɨnona llouide. Ie siño uaina uiñocana jaidɨcaɨ. Jusiñamui dajede ie Jitona cɨodɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Juan mɨcorɨ naimɨena comɨnɨmo jaie llote: —Birui omoɨmo llotɨcue; iadedɨ jɨaɨmɨe cue ifo meidoite. Cue baɨfemo faɨte. Cue nia jeicɨñenia, naimɨedɨ jaca ite —llote. ");
INSERT INTO huuNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Jesucristo caɨna eo duenaillamona, birui caɨna eo canocabide. ");
INSERT INTO huuNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Moisés mɨcorɨ Jusiñamui uaina jaie llote; iadedɨ iemona Jusiñamui caɨna duenaillana jaie raise uiñoñedɨcaɨ. Jesucristo lluamona Jusiñamui caɨna duenaillana jai raise uiñotɨcaɨ. Naimɨemona uanaicɨnona jai raise cacadɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Jaca buna Jusiñamuina cɨoiñede; iadedɨ dajede ie Jito caɨna naimɨena uiñotade. Ie Moo dɨga danomo illamona, Jesús naimɨena uiñote. ");
INSERT INTO huuNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Jerusalémona Juan mɨcorɨ dɨne judíuaɨ illaɨcomɨnɨdɨ Jusiñamui dɨga ñaɨraɨnɨmona dajerie oredɨmacɨ. Jusiñamui dɨga ñaɨraɨnɨ canoraɨnɨmona dajerie jɨaɨ oredɨmacɨ. Naimɨemo: —¿Budɨo? —raillano jɨcanotadɨmacɨ. Juan dɨne rillanona, raitɨmacɨ: —Caɨ Jilloitaraɨma biite raillamɨemo ocuiridɨcaɨ. Cristo raillamɨe billemo ocuiridɨcaɨ. ¿Odɨ naimɨedɨo? —raillanona jɨcanotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Naimɨe dɨnena janoñede; ia: —Imɨeñedɨcue —raite. ");
INSERT INTO huuNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Dane naimɨemo jɨcanodosɨte: —¿Budɨo? ¿Elías? Juan mɨcorɨ dɨnena uai ote: —Elíañedɨcue. Raitɨmacɨ: —Moisés mɨcorɨ Jusiñamui facaina lloraɨma ɨco billena jaie llote. ¿Odɨ naimɨedɨo? Juan dɨnena raite: —Ieñedɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Dane jɨcanotɨmacɨ: —¿Budɨo? Caɨmo llono, caɨ oretatɨnomo caɨ llollena. ¿Nɨese naimacɨmo ona lloitɨcaɨ? ");
INSERT INTO huuNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Juan dɨnena raite: —Jofue iñenanomo ado llotɨmɨedɨcue. Isaías mɨcorɨ jaie llua isoi llocabitɨcue: “Caɨ Nama biite. Naimɨe naɨso atona raise fɨno”. Iese llotɨcue; ia naimɨe uaina omoɨ feiñollena, omoɨ comecɨaɨ raise fɨnollena ñaɨtɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Juan dɨne bitɨnodɨ fariseuaɨ comɨnɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Nia jɨcanoiacadɨmacɨ: —Odɨ caɨ Jilloitaraɨmañenia, o Elíañenia, o Moisés mɨcorɨ llotɨmɨeñenia, ¿bue ñellena comɨnɨna bautizadɨo? ¿Nɨe isoide uai omo ite? ¿Nɨnomona o uaina otɨo? ");
INSERT INTO huuNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Juan dɨnena uai ote: —Comɨnɨna bautizadɨcue; iadedɨ omoɨ motomo omoɨ uiñoñegamɨe jai ite. ");
INSERT INTO huuNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Naimɨe cue ifo meidoite. Cue baɨfemo faɨte. Jamai bue cue isoilla jira, naimɨe illafomo cue riñena jira, naimɨena canonidɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Naie rafuedɨ Betábaramo suide. Jordán railla ille ruicafebeimo ite. Nainomo Juan bautizauide. ");
INSERT INTO huuNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ie areruido Juan mɨcorɨdɨ Jesús naimɨe dɨne billana cɨuano, naimɨena raite: —Ero, Jusiñamui Jito toɨca llauda mamecɨdo jai bite. Caɨ jeacɨno facaina faga llauda ifomo Jusiñamui ie Jitona jai orede. Naimɨe fallemona comɨnɨ jeacɨnona dotaite. ");
INSERT INTO huuNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Navui naimɨena ñaɨtɨcue. Llotɨcue: “Cue ifo jɨaɨmɨe meidoite. Jamai bue isoidɨcue; iadedɨ naimɨe jamai bue isoiñede. Cue nia jeicɨñenia, naimɨedɨ jaca ite”. ");
INSERT INTO huuNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Cue dɨne naimɨe nia biñenia, naimɨedɨ caɨ Jilloitaraɨmana uiñoñedɨcue; iadedɨ comɨnɨna bautizallena bene itɨcue, caɨ comɨnɨmo naimɨena llollena. ");
INSERT INTO huuNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Juan jɨaɨ llote: —Monamona ucugɨ isoi Jusiñamui Joreño ana billana cɨodɨcue. Jesúmo baite. ");
INSERT INTO huuNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Naimɨedɨ caɨ Jilloitaraɨmana nia uiñoñedɨcue; iadedɨ comɨnɨna bautizallena, cuena oretagamɨedɨ jaie cuemo llote: “Cue Joreño ana billana damɨemo baillana ɨco cɨoitɨo. Cue Joreño baillamɨedɨ cue Joreño omoɨmo fecaite”. ");
INSERT INTO huuNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Naie rafuena cɨodɨcue. Iemona naimɨedɨ Jusiñamui Jitonana llotɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ie areruido Juan mɨcorɨ llofueoicaiganomona menamɨe Juan mɨcorɨ dɨga ia, ");
INSERT INTO huuNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Juan mɨcorɨ Jesús macarillana cɨuano, raite: —Ero, Jusiñamui Jito toɨca llauda mamecɨdo jai bite. ");
INSERT INTO huuNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Juan mɨcorɨ dɨga itɨiaɨmaiaɨ naiena cacajano, Jesúna racadɨiaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jɨnafo dɨne erodajanona, Jesús iaɨmaiaɨna cɨode. Iaɨmaiaɨmo jɨcanote: —¿Buena jitaidomɨco? Iaɨmaiaɨ dɨnena uai otɨiaɨmaiaɨ: —Rabbí, ¿nɨ o jofo? ¿Nɨnomo itɨo? —uai otɨiaɨmaiaɨ. Rabbí oni dobaiñuamona: “Llofueraɨma raillamɨe”. ");
INSERT INTO huuNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jesús nai iaɨmaiaɨ uaina ote: —Mai. Cue dɨga bi, omɨco uiñollena. —Ie jira jaidɨaɨmaiaɨ. Jesús illanona cɨodɨaɨmaiaɨ. Jitoma nia a illa jira, nairuido naimɨe dɨga fɨebidɨaɨmaiaɨ. Jitɨrecaidemo oni jaidɨaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","41","Naie iaɨmaiaɨmona damɨe Andréna mamecɨredɨmɨe. Jesús dɨnena naimɨe jaidemo, ie ama nano jenuaide. Naimɨe amadɨ Simón Pedro. Naimɨena baillanona, llote: —Jai caɨ comɨnɨna Jilloitaraɨmana baitɨcue. Cristo raillamɨena baitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ie mei Jesús dɨne naimɨena uite. Jesús naimɨena eo eruaɨllanona, raite: —Birui o mamecɨdɨ Simón. Juan ie jitodɨo. Biruimona Cefana jɨaɨ mamecɨrenitɨo —raite. Oni dobaiñuacɨdɨ Pedro. ");
INSERT INTO huuNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ie areruido Jesús Galileamo jaiacade. Felipena baillanona raite: —Cue llofuegamɨena o jaillena, cue dɨga coco jaillesa, mai cue dɨga bi. ");
INSERT INTO huuNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Felipedɨ Betsaida naɨraɨ imɨe. Andrés iaɨmaiaɨ Pedro dɨga daje naɨraɨ iaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Jesús naimɨemo llua mei, Felipedɨ Natanaelna oni jenuaide. Higuera railla riara anamo naimɨena baillanona, raite: —Moisés mɨcorɨ jaie cuegamɨena jai baitɨcue. Jusiñamui lloraɨnɨ mɨcorɨaɨdɨ naimɨena jaie jɨaɨ cuetɨmacɨ. Naimɨedɨ Jesús. Nazaret imɨe. Ie moodɨ José. ");
INSERT INTO huuNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanael naie naɨraɨna uaitajanona raite: —Nainomo mare comedɨ iñede. Felipe dɨnena raite: —Naie o uiñollena, cue dɨga mai bi. ");
INSERT INTO huuNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jesúmona iaɨmaiaɨ iaɨre ia, Jesús dɨnena llote: —Ero, buna jɨfueñegamɨe billa. Nanoca Israel imɨe bite. ");
INSERT INTO huuNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanael dɨnena uai ote: —¿Bu cuena llogao? ¿Nɨese cuena uiñotɨo? Jesús uai ote: —Felipe ona aillɨ nia baiñenia, higuera railla riara anamo o illana jai uiñotɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Jacɨnaillamona, Natanael dane uai ote: —Maestro, odɨ Jusiñamui Jitodɨo. Caɨ comɨnɨ illaɨmadɨo. ");
INSERT INTO huuNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesús dɨnena uai ote: —Amena anamo o illana cue uiñua jira, cuena ɨɨnotɨo. Dɨga siño rafuena cɨojitɨo. Bie rafue baɨfemo fɨnuana cɨojitɨo. ");
INSERT INTO huuNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Jusiñamuimona billanona, ɨimana jaidɨcue. Uanaicɨno omo llotɨcue. Mona ecorillana o cɨoia, Jusiñamui jaɨenisaɨ cue dɨne billena cɨoitɨo. Cuemona abɨdo jaillena jɨaɨ cɨoitɨo. ");
INSERT INTO huuNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Menarui illanona, Galileamo Canámo ɨima ie aɨ uarafue ite. Rafue nama uaidua jira, nainomo Jesús ei jaide. ");
INSERT INTO huuNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jesús jɨaɨ uaidoga. Ie llofueoicaiganodɨcaɨ jɨaɨ uaidogacaɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Vino cueillamona, Jesús ei Jesúmo llote: —Vino jai iñede. ");
INSERT INTO huuNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jesús dɨnena uai ote: —Quei, ¿bue ñellena iese cuemo llotɨo? Siño rafue cue fɨnolle facaisedɨ nia riñede. ");
INSERT INTO huuNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Iemei ie eidɨ rafue nama mullaɨaɨmo llote: —Naimɨe omoɨmo lluana fɨno. ");
INSERT INTO huuNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Jɨnui nainomo eenollena, nainomo seis nofɨcɨmona fɨnoca llerodana raɨsoide. Naiemona jɨnuina ouidɨmacɨ. Marena illena, caɨ einamacɨ llua isoi, jofomo naimacɨ ria, naimacɨ abɨaɨna llereuidɨmacɨ. Naga lleroda nɨbaɨ cinco latas totaca. ");
INSERT INTO huuNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Mullaɨaɨmo Jesús llote: —Naie llerodaɨaɨna jɨnui dɨga oruita. —Pozomona jɨnui atɨano, naie llerodamo toidɨmacɨ. Iena fɨnua mei, ");
INSERT INTO huuNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Jesús naimacɨmo llote: —Llerodamona janore jisa uanona, rafue nama dɨne uiño. ");
INSERT INTO huuNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Naie facaiseconi naie jɨnuidɨ vinona jaide. Rafue nama naiena facade. Naimɨedɨ nɨnomona naie vino uana uiñoñede. Danɨ nainomo ite mullaɨaɨ uiñotɨmacɨ. Jirua mei, aɨ otɨmɨe uaiduano, ");
INSERT INTO huuNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","raite: —Rafue bu fɨnoia, eo caɨmarede vino nano fecade. Comɨnɨ ailluena jirua mei, janore caɨmarede vino fecade; iadedɨ iese fecañedɨo. Eo mare vino jɨnafona fecadɨo —raite. ");
INSERT INTO huuNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Galileamo Canámo Jesúdɨ siño rafuena nano fɨnode. Iemona caɨna ie uai siñona uiñotade. Ie muidona naimɨe siño Jitonana ɨɨnotɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Rafue fuilla mei, Capernaumo Jesús ie ei dɨga, ie amatɨaɨ dɨga, ie llofueoicaiganodɨcaɨ dɨga jaide. Nano nɨgarui nainomo itɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Pascua railla rafue iaɨre iacana jira, Jerusalémo Jesús caɨ dɨga jaide. Egiptomona caɨ jaiagaɨ jillobillana comecɨllena, naie rafue ite. ");
INSERT INTO huuNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Rillano, Jusiñamui jofomo dɨga rana fecaraɨnɨna cɨode. Ucube ollena, nainomo juraretaɨaɨ, toɨca llaudaɨaɨ, ucugɨaɨ fecauidɨmacɨ. Ucubena meidoraɨnɨdɨ jɨaɨ itɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Naimacɨ ocainaɨaɨ dɨga naimacɨ jino jiullena, rao Jesús uanona, iena llerɨde. Naimacɨ ucubena judaɨde. Mesaɨaɨna oni caitade. ");
INSERT INTO huuNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ucugɨaɨna fecaraɨnɨmo llote: —Omoɨ ucugɨaɨna jino uiño. Cue Moo jofomo ra feca-fecajana jitaiñedɨcue —llote. ");
INSERT INTO huuNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Iemo Jusiñamuina lloraɨnɨ mɨcorɨaɨ cuegafuiaɨna jai comecɨtɨcaɨ. Iese jaie cuega: “O jofona cue rɨiduamona, jɨaɨno cuena meinetaitɨmacɨ”. ");
INSERT INTO huuNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Nainomo ite judíuaɨ illaɨcomɨnɨ dɨnena raitɨmacɨ: —¿Nɨe isoide uaido naimacɨna jino oredɨo? Siño rafuena fɨno, siño uai omo illana caɨ uiñollena. ");
INSERT INTO huuNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesús uai ote: —Bicona judaɨ. Darui amani maɨjɨamona iena dane nillana fuidoitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Dane raitɨmacɨ: —Cuarentiséis años bicomo maɨjɨdɨmacɨ, iena fɨnollena. ¿Nɨese iena darui amani illanona, iena dane nillana fuidoitɨo? ");
INSERT INTO huuNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Iese raitɨmacɨ; ia Jesúdɨ Jusiñamui jofona ñaɨñede. Dama ie abɨna ñaɨte. Fiodaillamona ie jilloillena ñaɨte. ");
INSERT INTO huuNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Jesús fiodaillamona naimɨe jillua mei, ie llofueoicaiganodɨcaɨ bie lluacɨnona comecɨtɨcaɨ. Ie jira naie cuegafuena ɨɨnotɨcaɨ. Jesús lluacɨnona jɨaɨ ɨɨnotɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Pascua railla rafue facaiseconi Jerusalémo Jesús ia, dɨga siño rafuena fɨnode. Ie jira ailluena comɨnɨ naimɨe uaina ɨɨnotɨmacɨ. Coninɨri raitɨmacɨ: —Naimɨedɨ caɨ Jilloitaraɨma. ");
INSERT INTO huuNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","—Naganomo comecɨaɨna naimacɨ facaja jira, naie comɨnɨna naimɨe uiñuamona, Jesús naimacɨ motomo iacaiñede. ");
INSERT INTO huuNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Naimacɨ comecɨaɨmo itɨcɨnuaɨna naimɨe eo raise uiñua jira, comɨnɨ rafuena naimɨemo bu lluana jitaiñede. ");
INSERT INTO huuNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","2","Judíuaɨ illaɨcomɨnɨmona damɨedɨ Nicodemo. Naimɨedɨ fariseo imɨe. Naɨona Jesús dɨne billanona, raite: —Maestro, caɨ comɨnɨna llofuellena, Jusiñamui ona orede. Iena uiñotɨcue. Siño rafuena o fɨnua jira, Jusiñamui uai omo illana uiñotɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesús dɨnena uai ote: —Raise llotɨo; ia daje rafue omo lloitɨcue: Uanai omo lloitɨcue. Dane abɨdo comonori o jeicɨñenia, Jusiñamui ie comɨnɨna sedajanomo jaca initɨo. ");
INSERT INTO huuNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nicodemo abɨdo jɨcanote: —¿Nɨese eimɨe ie ei jeraimo dane iite? ¿Nɨese dane comonori jeicɨite? ");
INSERT INTO huuNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesús uai ote: —Uanai omo llotɨcue. Jusiñamui ie comɨnɨ sedajanomo o illena, dama o eimona jeicɨñellɨo. Jusiñamui Joreñodo bu dane comonori comuitañenia, Jusiñamui ie comɨnɨna sedajanomo jaca iñeite. ");
INSERT INTO huuNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Comemona caɨ comuitaia, jaca comedɨcaɨ; iadedɨ Jusiñamui Joreñodo caɨ comuitaiadedɨ, Jusiñamui uruedɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Omo dane lloitɨcue: Comonori jeicɨa. Ieri raijicaiñeno. ");
INSERT INTO huuNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Iena o raise cacaillena, jɨaɨe rafuedo iena lloitɨcue. Aɨfɨdɨ ie jitailla dɨne saɨrɨde. Iena cacadɨo; iadedɨ nɨnena billana uiñoñedɨo. Nɨne jaillana jɨaɨ uiñoñedɨo. Ie isoide. Nɨese Jusiñamui Joreño comɨnɨna comuitajana jɨaɨ uiñoñedɨo. ");
INSERT INTO huuNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nicodemo dane jɨcanote: —¿Nɨese biedɨ dane iite? Raise cacaiñedɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesús uai ote: —Jusiñamui rafuena omoɨ comɨnɨna llofuecabitɨo. Jusiñamui rafuena omo llotɨcue; ia iena raise cacaiñedɨo. ");
INSERT INTO huuNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Uanaicɨnona omo llotɨcue. Abɨ uiñuamona omo llotɨcue. Cue cɨua rafuena llotɨcue; iadedɨ cue lluana ɨɨnoñedɨo. ");
INSERT INTO huuNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Bene ite rafuena cue lloia, iena ɨɨnoñedɨota, monamo ite rafuena cue lloia, iena jɨaɨ raise ɨɨnoñeitɨo. ");
INSERT INTO huuNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Enɨruemona monamo jaca buna jaiñena jira, monamo ite rafuena bu raise uiñoñede. Monamona cue billa jira, nainomo abɨdo jaitɨcue. Ie muidona nainomo ite rafuena uiñotɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Monamona bitɨcue; ia amenamo fiodaitɨcue. Jofue iñenanomo Moisés mɨcorɨ jaio joreño amenamo jaie cuinade. Jaionɨaɨ aɨnillamona comɨnɨ fiodaiñellena iena cuinade. Comɨnɨ ie isoi jilloillena, ie isoi cuena coraɨitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Cue fiodaillamona bu cue uaina ɨɨnoia, monamo jaca iite. ");
INSERT INTO huuNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Jusiñamuidɨ comɨnɨna eo isiruilla jira, comɨnɨ dɨne ie damɨede Jitona orede. Ie Jitona naimacɨ ɨɨnollena, naimɨena orede. Naimɨena ɨɨnuamona, monamo jaca iitɨmacɨ. Jɨaɨ faɨfiñeitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Naimacɨna duere fɨnotallena ie Jitona oreñede; iadedɨ naimacɨ jeacɨnomona jilloillena, naimɨena orede. ");
INSERT INTO huuNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Jusiñamuidɨ Jesús uaina ɨɨnotɨnona jaca duere fɨnoñeite; iadedɨ ie dajede Jitona uaina naimacɨ ɨɨnoñena jira, Jusiñamui duere fɨnollɨcɨno anamo jai itɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Comɨnɨ comecɨaɨna llɨgaiñollena, Jusiñamui Jito bite. Jeacɨno comecɨaɨmo illana naimacɨ uiñollena, naimacɨ comecɨaɨna llɨgaiñuaɨbite; iadedɨ naimacɨ comecɨaɨ jitɨredɨnomo iacana jira, jearede rafue naimacɨ fɨnua muidona, naimɨena jitaiñedɨmacɨ. Ie jira Jusiñamui naimacɨmo duere fɨnollɨcɨnona anamo jai itɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Naimɨe fɨnoca rafue bai raillano, naga jeacɨno fɨnoraɨma ie comecɨ llɨgaiñuana jitaiñede; ");
INSERT INTO huuNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","ia Jusiñamui jitaillacɨnona fɨnodɨno naimacɨ fɨnoca rafue baillena, llɨgaiñotɨmɨe dɨne marefodo bitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Dɨgarui illanona, Jesús ie llofueoicaiganodɨcaɨ dɨga, Judea railla enɨruemo macaricana jaidɨcaɨ. Nainomo dɨga irui fɨebidɨcaɨ. Llofuiamona ɨɨnotɨnona bautizacana uitɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","24","Nia cárcelmo iñenia, ailluena jɨnui nainomo illa jira, Enón railla naɨraɨmo bautizajanomo Juan mɨcorɨ jɨaɨ ite. Salim railla naɨraɨ iaɨrei ite. ");
INSERT INTO huuNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Naie facaise Juan mɨcorɨ llofueoicaigano judíuaɨ imɨe dɨga bautizajana siadotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ie muidona Juan mɨcorɨ dɨne billanona, raitɨmacɨ: —Maestro, navui Jordán ruica dɨne damɨe billena llotɨo. Naimɨena o bautizallena, o dɨne navui bite; iadedɨ birui naimɨedɨ comɨnɨna bautizade. Ailluena comɨnɨ naimɨe dɨne jaioidɨmacɨ. O dɨne jai raise biñedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Juan uai ote: —Jusiñamui ie uai fecañedena, Jusiñamui facaina buna jaca buena fɨnonide. ");
INSERT INTO huuNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Cue lluana navui cacadomoɨ. Llotɨcue: “Caɨ comɨnɨ Jilloitaraɨmañedɨcue. Cristoñedɨcue. Naimɨe billena cue llollena, Jusiñamuidɨ naimɨe uicomo cuena orede”. ");
INSERT INTO huuNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Jɨaɨe rafuedo iena lloitɨcue. Damɨe ie aɨna ua mei, dama naimɨemo duide. Ie aɨna ua rafue facaise, naimɨe nabai iena cɨuano, ieri jɨaɨ iobide. Ie isoide. Comɨnɨ cue dɨne navui biñoidɨmacɨ. Birui Jesúmo jaioidɨmacɨ. Naimɨemo jai duidɨmacɨ. Iena cue cacajamona, ieri iobidɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Comɨnɨ naimɨe uai siñona uiñuana jitaidɨcue. Comɨnɨ cue jamai bue isoidɨmɨena uiñuana jɨaɨ jitaidɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Jamai comedɨcue. Ie jira enɨruemo ite rafuena llocabitɨcue. Jusiñamuimona Jesús billa jira, caɨ baɨfemo faɨte. ");
INSERT INTO huuNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ie Moo illanomo cɨua rafuena llote. Ie Moo illanomo cacaja rafue jɨaɨ llote; iadedɨ eo janore comɨnɨ naimɨena ɨɨnotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Naimɨena ɨɨnotɨmɨedɨ Jusiñamui uanaicɨnona lluana raise uiñote. ");
INSERT INTO huuNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Jusiñamuidɨ ie Joreño ie Jitomo caidɨñeno fecaja jira, naimɨe Jusiñamui uaina llocabite. ");
INSERT INTO huuNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Jusiñamuidɨ ie Jitona isiruite. Ie jira naga rafue naimɨemo fecade. ");
INSERT INTO huuNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Bu Jusiñamui Jitona ɨɨnoia, Jusiñamui illanomo jaca iite; iadedɨ bu naimɨena ɨɨnoñenia, Jusiñamui illanomo jaca iñeite. Jusiñamui rɨicaillafue anamo jai ite. ");
INSERT INTO huuNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","2","Naie facaise ailluena comɨnɨ Jesúmona fueotɨmacɨ. Iemei naimɨe dɨbeido bautizadɨmacɨ. Naimacɨna naimɨe bautizallena, janore comɨnɨ Juan dɨne jaide. Jesúdɨ bautizañede. Danɨ ie llofueoicaiganodɨcaɨ bautizadɨcaɨ. Fariseuaɨ bie rafuena fɨdɨano, iena Jesús uiñua jira, ");
INSERT INTO huuNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Judeamona Galileamo Jesús caɨ dɨga dane abɨdo jaide. ");
INSERT INTO huuNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Galileamo jaillena, Jesúdɨ Samaria railla enɨrue dɨbeido jaiacade. ");
INSERT INTO huuNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Samariamo caɨ ria, Sicar railla naɨraɨmo iaɨrei rillano, daje pozomo ridɨcaɨ. Naie pozodɨ Jacob mɨcorɨ jaie fɨnoca. Jacob mɨcorɨ naie pozo illano ie jito José mɨcorɨmo jaie fecade. ");
INSERT INTO huuNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Jitoma naidai itemo, naie pozo fuemo caɨ rillano, Jesús ana raɨde. Are macarillanona, jafaicɨ ote. ");
INSERT INTO huuNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Jesús pozomo fɨebicailla meinona, Sicarmo jaidɨcaɨ, guille ollena. Caɨ jailla mei, Samaria iñaiñodɨ jɨnui ollena, pozomo bite. Jesús naiñaiñomo jɨcade: —Jɨnuina cue ine, cue jirollesa. ");
INSERT INTO huuNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Naiñaiñodɨ uai ote: —Judío imɨedɨo. Samaria iñaiñodɨcue. ¿Nɨese cuemo jɨnuina jɨcadɨo? —Naiñaiño iese raite, judíuaɨ Samaria comɨnɨ dɨga ñaɨraɨnina jira. ");
INSERT INTO huuNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesús dɨnena dane uai ote: —Jusiñamui omo fecaacalle ra uiñotɨodena, o dɨga ñaɨtɨmɨena uiñotɨona, cuemo jaca itataite jɨnuina cuemo jɨcadɨo. Iemei omo iena fecadɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Naiñaiño uai ote: —¿Nɨese bie pozomona jɨnuina oitɨo? Eo ana ite. ¿Nɨnomona jaca itataite jɨnuina oitɨo? ");
INSERT INTO huuNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Caɨ usuma Jacob mɨcorɨ bie pozo caɨmo jaie iñonocaiga. Naiemona naimɨe mɨcorɨ jaie jirode. Ie uruiaɨ mɨcorɨaɨ jɨaɨ naiemona jirodɨmacɨ. Ie ocainaɨaɨ dajemona jɨaɨ jirodɨmacɨ. Caɨ usuma mɨcorɨ baɨfemo faɨñedɨo —raite. ");
INSERT INTO huuNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesús uai ote: —Nagamɨiaɨ bie jɨnui jirua mei, dane jiroacanite; ");
INSERT INTO huuNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","iadedɨ cue fecalle jɨnuina jirua mei, dane jiroacaiñenite. Cue fecalle jɨnui, torafo illa isoi, naimɨemo jaca iite. Jusiñamui dɨne illena, naimɨena jaca itataite. ");
INSERT INTO huuNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Naiñaiño naimɨe uai ote: —Ero, cue dane jiroacaiñellena, bene dane cue biñellena, o lloga jɨnui cuemo ine. ");
INSERT INTO huuNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesús dɨnena uai ote: —O jofomo mai jai. O ɨni dɨga abɨdo bene bi. ");
INSERT INTO huuNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Naiñaiño uai ote: —Ɨninidɨcue. Jesús dɨnena uai ote: —Uanai llotɨo. Ua ɨninidɨo. ");
INSERT INTO huuNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Cinco dɨga ɨnina jai faɨcaidɨo. Birui o dɨga itɨmɨedɨ jɨaɨ o ɨniñede. Uanaicɨnona ua llotɨo. ");
INSERT INTO huuNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Iemona abɨna uiñocaillamona, naiñaiño dɨnena uai ote: —Odɨ Jusiñamui ie lloraɨmadɨo. Iena uiñotɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Caɨ jaiagaɨ baɨ bene ite anedumo Jusiñamuina sedauidɨmacɨ. Ie jira nainomo Jusiñamuina nia sedadɨcaɨ; iadedɨ omoɨ judíuaɨ dɨnena raitomoɨ: “Jerusalémo Jusiñamuina caɨ sedauilla”. ");
INSERT INTO huuNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesús dɨnena dane uai ote: —Cuena ɨɨno. Jɨaɨruido baɨ bene ite anedumo caɨ Moona sedañeitomoɨ. Jerusalémo naimɨena jɨaɨ sedañeitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Raise uiñoñeno Jusiñamuina biruido sedadomoɨ; iadedɨ caɨ naɨraɨmona caɨ Jilloitaraɨma illa jira, naimɨena raise uiñuana sedadɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Jɨaɨruido, ua birui, comɨnɨdɨ: “¿Nɨnomo Jusiñamuina sedaitɨcaɨ?” raillamo comecɨaɨna facañeitɨmacɨ. Naimacɨ comecɨaɨ jitaillamona, naimacɨ illanomo Jusiñamuina ua sedaitɨmacɨ. Naie isoide comɨnɨ naimɨena sedajana Jusiñamui jitaide. ");
INSERT INTO huuNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Jusiñamui comeñede. Naimɨedɨ jafaicɨ. Omoɨ comecɨaɨ jitaillamona naimɨena omoɨ sedajana jitaide. ");
INSERT INTO huuNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Rɨño uai ote: —Caɨ Jilloitaraɨma billena uiñotɨcue. Naimɨedɨ Cristo. Naimɨe bia, nana bie isoide rafuena caɨna raise uiñotaite. ");
INSERT INTO huuNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesús raite: —Naimɨedɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ieconi abɨdo ridɨcaɨ. Rɨño dɨga Jesús ñaɨa jira, raijicaidɨcaɨ; iadedɨ: “¿Buena naiñaiño jitaide?” raillano jɨcanoñedɨcaɨ. “¿Buena ñaɨtomɨco?” raillano jɨaɨ jɨcanoñedɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ie lleroda pozo ecɨmo raɨnanocaida, Jesús llua isoi, naie facaise naiñaiño ie naɨraɨmo abɨdo jaide. Nainomo abɨdo rillanona, naiñaiño comɨnɨmo llote: ");
INSERT INTO huuNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Aillɨ pozo fuemo cue jaca cɨoiraɨninamɨe dɨga dafaɨfidɨcue. Nana cue fɨnouiga rafue dɨese cuemo llote. Mai, caɨ jɨbuisaillɨ. Naimɨedɨ pozo fuemo ite. Nɨbaɨ naimɨedɨ caɨ Jilloitaraɨma. Naimɨedɨ nɨbaɨ Cristo. ");
INSERT INTO huuNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ie jira Jesús dɨne ailluena comɨnɨ bitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Naie rɨño ie naɨraɨ dɨne jailla mei, abɨdo caɨ dɨne nia riñenia, Jesúna raitɨcaɨ: —Maestro, mai guiño. ");
INSERT INTO huuNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Naimɨe uai ote: —Cuemo guille illana uiñoñedomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Coninɨri siadotɨcaɨ: —Jai nɨbaɨ bu ecajaɨbiga. ");
INSERT INTO huuNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jesús uai ote: —Jusiñamui cuena oretate. Naimɨe jitailla rafuena fɨnocana jaidɨcue. Naimɨe rafuena cue lluamona, jai guitɨcue isoidɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Comecɨna facadomoɨ: “Jusiñamui uaina nia lloñeitɨcaɨ. Ɨco iena lloitɨcaɨ”. Ie isoide. Illɨmo riara nia llisiñenia, comecɨaɨna facadomoɨ: “Riara einaillena, naga amaga fɨvui fɨebite. Naie facaise maɨjɨitɨcaɨ”. Omoɨmo llotɨcue: Omoɨ ecɨmo eruaɨ. Riara jai einaite isoide. Naimacɨmo Jusiñamui rafue llollena, iena naimacɨ ɨɨnollena, ailluena comɨnɨ jai itɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Naie llɨsillamo maɨjɨitɨmɨedɨ ie ucubena feiñoite. Ie isoide. Jusiñamui rafuena damɨerie llocabillamona, comɨnɨ iena cacadɨmacɨ. Jɨaɨno billamona, iena dane cacajamona, iena ɨɨnotɨmacɨ. Naie mare rafue lloraɨnɨ ɨbana feiñoitɨmacɨ. Jusiñamui dɨbeimo naimacɨ dajena maɨjɨa jira, dajena iobitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Caɨ comɨnɨ iena raicabitɨmacɨ: “Damɨe iduaɨna rite; ia jɨaɨmɨe llɨsillana ote”. ");
INSERT INTO huuNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ie isoide. Omoɨna oredɨcue, comɨnɨ cue dɨbeimo itatallena. Naimacɨmo cue uaina nano lloñedomoɨ; iadedɨ nano jɨaɨno naimacɨmo cue uaina llotɨmacɨ. Ie jira nana omoɨ llofuiamona cue uaina ɨɨnoitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Samaria iñaiño lluamona, naiñaiño naɨraɨmona ailluena comɨnɨ Jesúna ɨɨnotɨmacɨ. “Naimɨedɨ nana cue fɨnoca rafuena cuemo llote” naimacɨmo naiñaiño llote. “Naimɨedɨ caɨ Jilloitaraɨma” raillanona Jesúna ɨɨnotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Jesús dɨne naimacɨ rillanona, naimacɨ dɨga naimɨe fɨebillena, Jesúmo jɨcanotɨmacɨ. Ie jira Jesús menarui naimacɨ dɨnomo fɨebide. ");
INSERT INTO huuNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Naimɨe llofuiamona, jɨaɨe ailluena comɨnɨ naimɨena ɨɨnotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Rɨñomo llotɨmacɨ: —Daño o lluamona, navui ɨɨnotɨcaɨ; iadedɨ naimɨe uaina caɨ cacajamona, birui raise ɨɨnotɨcaɨ. Naimɨedɨ comɨnɨ ua Jilloitaraɨma. ");
INSERT INTO huuNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Menarui illanona, nainomona Galileamo Jesús caɨ dɨga jaide. ");
INSERT INTO huuNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Caɨmo llote: —Jusiñamuina lloraɨmadɨ ie naɨraɨ illanomo ia, naie comɨnɨ naimɨe lluamo cacarefiacaiñedɨmacɨ; ");
INSERT INTO huuNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","iadedɨ Galileamo caɨ rillanona, nainomo itɨno naimɨena caɨmare feiñotɨmacɨ. Pascua railla rafue facaise Jerusalémo nana naimɨe fɨnoca rafue navui naimacɨ cɨua jira, naimɨena caɨmare feiñotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Galileamo Jesús caɨ dɨga macaria, dane Canámo ridɨcaɨ. Nainomo jɨnuimona vino navui fɨnode. Nainomo caɨ ia, Capernaum railla naɨraɨmo itɨmɨe jito duide. Duidɨmɨe moodɨ gobierno dɨga maɨjɨuide. ");
INSERT INTO huuNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Judeamona Galileamo Jesús illana naimɨe fɨdɨano, Canámo bite. Jesús illanomo billena, ie jito jai fiodaiacana jira, ie jitona jillotallena Jesúmo duere jɨcanote. ");
INSERT INTO huuNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jesús naimɨemo llote: —Siño rafuena omoɨ cɨoiñenia, cuena ɨɨnoñedomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Uai ote: —Maestro, cue dɨga bi, cue jito fiodaiñellesa. ");
INSERT INTO huuNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jesús uai ote: —Mai jai. O jito jai fiodaiñeite —llote. Naie ɨima Jesús uaina ɨɨnuano, ie jofomo abɨdo jaide. ");
INSERT INTO huuNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Naɨsona naimɨe jaidemo, ie mullaɨaɨ dɨga afeedo beicɨ dafaɨfide. Llotɨmacɨ: —O jito jai jillode. ");
INSERT INTO huuNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ie jira naimɨe jɨcanote: —¿Nɨno jitoma itemo, jillode? Uai otɨmacɨ: —Navui are jitoma oni lluaɨ caidemo, abɨ cuarilladɨ faɨnonocaide. ");
INSERT INTO huuNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ie comecɨna facade: “Navui are naie facaise Jesús cuemo llote: ‘O jito jai jillode’ ”. Ie mullaɨaɨ lluana cacajamona, naimɨedɨ Jesúdɨ caɨ Jilloitaraɨmana ɨɨnote. Nana naimɨe jofomo itɨno jɨaɨ ɨɨnotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Judeamona Galileamo Jesús abɨdo billano, siño rafuena iese jai fɨnode. ");
INSERT INTO huuNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Dɨgarui illa mei, caɨ judíuaɨ rafue iacana jira, Jerusalémo Jesús abɨdo jaide. ");
INSERT INTO huuNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalémo toɨca llaudaɨaɨ jaisoilla nase facaimo joraibɨ ite. Caɨ judíuaɨ uaimona nai joraibɨ mamecɨdɨ Betesda. Naie jorai fuedo ite cinco jɨfocotɨaɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Nainomo dɨga duidɨno bɨidɨmacɨ: uisɨnidɨmacɨ, ñuja-ñujacaidɨno, tɨsitaitɨno. Jɨnuina begollena sedadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Feide isoidemona dacaiño Jusiñamui jaɨenicɨdɨ jɨnuina begotallena bite. Iemei nai jɨnuimo nano jaidɨmɨe ie duicomona jillode. ");
INSERT INTO huuNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Duidɨno motomo tɨsitaitɨmɨe ite. Treintiocho años duide. ");
INSERT INTO huuNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Naimɨena cɨuano, naimɨe are duillana uiñuamona, Jesús naimɨemo jɨcanote: —¿Jilloiacadɨo? ");
INSERT INTO huuNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Duidɨmɨe uai ote: —Jɨɨ; iadedɨ jɨnuina begoia, jaca buna iñede cue canoitena. Ie jira jɨaɨmɨedɨ cue uicodo jɨnuimo jaide. Ie jirari nia jilloñedɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesús uai ote: —Mai naidacai. O bɨira ferɨnocaida macari. ");
INSERT INTO huuNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ieconi naimɨe jillode. Ie bɨira ferɨanona oni jai macarite. Sábadoruimo, judíuaɨ jafaicɨ ouillaruimo, naimɨe jillode. ");
INSERT INTO huuNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ie jira judíuaɨ illaɨcomɨnɨdɨ jillodɨmɨemo llote: —Birui sábado. O bɨira abɨnocaida o uilla jira, Moisés mɨcorɨ rairuica rana jai fɨnodɨo. Sábadomo maɨjɨnidɨcaɨ. Birui jafaicɨ uaruimo jaca buena jetanidɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Naimɨe uai ote: —Cuena jilloitatɨmɨe cuemo llote: “O bɨira mai ferɨnocaida macari”. ");
INSERT INTO huuNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Judíuaɨ dɨnena jɨcanote: —¿Bu iena omo llote? —Naimɨe uiñoñena jira, uai oñede. ");
INSERT INTO huuNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Jesúdɨ comɨnɨ motomo itabilla jira, ailluena comɨnɨ illa jira, jai jillodɨmɨe ie jilloitatɨmɨena uiñoñede. ");
INSERT INTO huuNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ie meinoconi dallu illanona, Jusiñamui jofomo Jesús dɨnena naimɨena baite. Llote: —Jai jillodɨo. Abɨdo dane eo duere o sefuisa, dane jeacɨnona fɨnoñeno. ");
INSERT INTO huuNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ie mei judíuaɨ illaɨcomɨnɨmo jillodɨmɨe lluaide. Llote: —Jesús raillamɨe cuena jillotate. ");
INSERT INTO huuNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Sábadoruimo Jesús bie rafuena fɨnua jira, judíuaɨ illaɨcomɨnɨdɨ naimɨena duere fɨnoacasɨte. ");
INSERT INTO huuNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Jesúdɨ abɨna rɨiduano llote: —Cue Moodɨ ie jitailla rafue jaca fɨnode. Ie isoi cue jitailla rafue fɨnocana jaca jaidɨcue —llote. ");
INSERT INTO huuNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Sábadoruimo naimacɨmona Jesús maɨjɨa jira: “Jusiñamuidɨ cue Moo” naimɨe railla jira: “Jusiñamuidɨcue” naimɨe railla jira, judíuaɨ illaɨcomɨnɨ naimɨe meinellena eo jitaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Naimacɨmo Jesús llote: —Uanaicɨnona llotɨcue. Buena dama fɨnonidɨcue. Cue Moo fɨnua rafuena cɨuano fɨnocabidɨcue. Cue Moo fɨnua isoi fɨnodɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Cue Moo cuena isiruillanona, nana ie fɨnoca rafuena cuena jai uiñotade. Naimɨe Jitona cue illa jira, bie ɨimana cue jilloitaja baɨfemo jɨaɨe siño rafuena fɨnoitɨcue, omoɨ raijicaillena. ");
INSERT INTO huuNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Fiodaitɨnona jilloitallena, cue Moomo ie uai ite. Naie uai cuemo jɨaɨ ite. ");
INSERT INTO huuNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Cue Moo juez isoi naimɨe ɨɨnoñedɨnomo lloñeite; iadedɨ naimacɨmo juez isoi cue llollena, naimacɨ duere sefuillena, ie uai cuemo iga. ");
INSERT INTO huuNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Omoɨ dɨne naimɨe cuena oretate. Naimɨedɨ omoɨ cuena iobitajana jitaide, naimɨena omoɨ iobitaja isoi. Cuena omoɨ iobitañenia, cue Moona jɨaɨ iobitañedomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Uanaicɨnona llotɨcue. Cue uaina bu cacaia, cuena oretatɨmɨena bu ɨɨnoia, monamo jaca iite. Jearede rafue naimɨe fɨnua facaina duere sefuiñeite. Faɨfiñeite; ia monamo Jusiñamui dɨga jaca iite. ");
INSERT INTO huuNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Uanaicɨno llotɨcue. Jusiñamui Jitodɨcue. Ua birui cuena ɨɨnoñedɨno cue uaina cacareitɨmacɨ. Cuena cacajamona, cuena ɨɨnuamona, jaca iitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Comɨnɨna jaca itatallena, cue Moomo uai ite. Comɨnɨ jaca itatallena, cuemo ie uai jɨaɨ iga. ");
INSERT INTO huuNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Cuena ɨɨnoñedɨnomo juez isoi cue llollena, naimɨemo cue duillamona, ie uai cuemo jɨaɨ iga. ");
INSERT INTO huuNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ieri raijicaiñeno. Jɨaɨruido nana jai fiodaitɨno dɨese cue lluana cacaitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Fiodaillamona naimacɨ abɨaɨ jilloitɨmacɨ. Ie mei cue jitaillacɨnona fɨnodɨno jaca illena lloitɨcue. Cue jitaillacɨnona fɨnoñedɨno dɨese duere sefuillena lloitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Naimacɨmo cuena oretatɨmɨe jitailla isoi lloitɨcue. Dama cue comecɨmo ite rafuena cue lloñena jira, bie lluacɨnodɨ uanaicɨno. ");
INSERT INTO huuNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","32","Jesús nia llote: —Dama cue abɨna cue lloiadedɨ, bu cuena jaca ɨɨnoñede; iadedɨ Jusiñamui cue facaina jɨaɨ llote. Naimɨe lluacɨno uanaicɨno. Iena uiñotɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Naimɨena cacareillena, Juan Bautista mɨcorɨ dɨne comɨnɨna navui oretatomoɨ. Abɨdo naimacɨ bia, naimacɨ cacaja rafuena omoɨmo llollena, naimacɨna oretatomoɨ. Juan lluacɨnodɨ uanaicɨno. ");
INSERT INTO huuNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Naimɨe mɨcorɨ cue rafuena llouide; iadedɨ naimɨe mɨcorɨ llogacɨnomo omoɨ comecɨ eo facajana birui jitaiñedɨcue. Cuena omoɨ ɨɨnollena, naimɨe mamecɨna jai llɨnotɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Lamparín raise llɨgaiñua isoi, ie rafuedo Juan mɨcorɨ omoɨ comecɨaɨmo itɨcɨnona raise uiñotade. Dallu ieri iobidomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Cue fɨnoca rafue Juan mɨcorɨ fɨnoca rafue baɨfemo faɨte. Cue siño fɨnoca rafuena ñaɨtɨcue. Cuena naimɨe oretajamona, cue Moo uaido iena fɨnodɨcue. Ie jira naiemona naimɨe dɨnena cue billana jai uiñotomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Cue fɨnoca rafue muidona cuena uiñotomoɨ; iadedɨ naimɨe lluana jaca cacaiñedomoɨ. Naimɨena jɨaɨ jaca cɨoiñedomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Cuena omoɨ ɨɨnoñena jira, naimɨe uaina feiñoñedomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Jusiñamui dɨne omoɨ rillena, Jusiñamui facaina lloraɨnɨ mɨcorɨaɨ cuegafuiaɨna facacabidomoɨ. Naifuiaɨdɨ cuena ñaɨte; ");
INSERT INTO huuNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","iadedɨ Jusiñamui dɨne omoɨ rillena, cue uaina ɨɨnoiacaiñedomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Cuemo iobillacɨnona omoɨ fecallena sedañedɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Jusiñamuina isiruiñedomoɨ. Iena uiñotɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Cue Moo mamecɨdo cue billanona, cuena feiñoñedomoɨ; iadedɨ dama ie mamecɨdo jɨaɨmɨe bia, naimɨena feiñoitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Jaca ɨɨnoiacaiñedomoɨ. Iobillacɨno coninɨmo fecadomoɨ; iadedɨ ua Jusiñamuidɨ omoɨna “Mare” raillana jitaiñedomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Cue Moomo omoɨ maraiñede fɨnoca rafuena lloitɨcue” raillanomo comecɨaɨna facañeno. Moisés mɨcorɨ cuegafuiaɨmo omoɨ llogɨduafue jai ite. Moisés mɨcorɨ cuegafuiaɨ muidona Jusiñamui dɨne omoɨ jaca illemo ocuiridomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Moisés mɨcorɨ cuegafuiaɨna ɨɨnotomoɨna, cuena naimɨe mɨcorɨ cuia jira, cuena jɨaɨ ɨɨnoitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Naimɨe cuegafuiaɨna ɨɨnoñedomoɨ. Ie jira cuena jɨaɨ ɨɨnoñeitomoɨ —llote. ");
INSERT INTO huuNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Jɨaɨruido Galilea railla jorai ie ruica dɨbeimo Jesús ie llofueoicaiganodɨcaɨ dɨga jaide. Naie joraidɨ jɨaɨ Tiberiana mamecɨrede. ");
INSERT INTO huuNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Duidɨnona naimɨe jillotauillana naimacɨ cɨua jira, ailluena comɨnɨ naimɨena racadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","4","Naie facaiseconi pascua railla rafuedɨ jai iaɨre ite. Jesús caɨ dɨga anedumo a jaillanona, dɨnomo ana raɨde. ");
INSERT INTO huuNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Oni erodatemo, ailluena comɨnɨ naimɨe dɨne billana cɨode. Felipemo jɨcanote: —Naimacɨ guillena, ¿nɨnomona llomenicona oitɨcaɨ? ");
INSERT INTO huuNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Naimɨena facacɨllena, iena jɨcanote; iadedɨ Jesús ie fɨnolle rana jai uiñote. ");
INSERT INTO huuNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Felipe uai ote: —Janore naimacɨ guillena, doscientos dɨgarui ie maɨjɨa ucube dɨese llomenico otɨcaɨna, baiñede. ");
INSERT INTO huuNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Naie facaise caɨmona damɨe iena cacade. Naimɨedɨ Simón Pedro ama. Andréna mamecɨrede. Naimɨe raite: ");
INSERT INTO huuNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Cinco cebadamona fɨnoca jenide llomenico daje uruemo bene ite. Mena llɨcɨaɨ jɨaɨ naimɨemo ite; ia ¿nɨese nɨbaɨitɨcaɨ? Baiñeite. ");
INSERT INTO huuNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jesús caɨmo llote: —Comɨnɨmo llono, ana imacɨ raɨllesa. Ie jira raitɨre illanomo ana raɨdɨmacɨ. Cinco mil ɨiñɨaɨ itɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Llomenicona Jesús ua meinoconi, Jusiñamuimo iobillacɨnona fecajano, Jusiñamuimo jɨɨde. Iemei comɨnɨmo caɨna naie llomenicona fecatate. Comɨnɨ jitailla dɨerise llɨcɨaɨ daje isoi fecatate. ");
INSERT INTO huuNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Naimacɨ monillamona, caɨmo Jesús llote: —Buena jaca faɨfiñellena, fɨebide guille danomo ɨraɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ie jira iena ɨraɨdɨcaɨ. Naie cinco llomenicomona, comɨnɨ guigamona fɨebidemona, doce cɨrɨgaɨaɨmo oruitatɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Jesús fɨnoca rafuena naie comɨnɨdɨ cɨuanona, llotɨmacɨ: —Jusiñamui facaina lloraɨnɨ mɨcorɨaɨdɨ caɨ Jilloitaraɨma ɨco billena jaie llotɨmacɨ. Bimɨedɨ naimɨe. ");
INSERT INTO huuNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Naimacɨ illaɨmana naimɨe illena, naimɨena gaɨtaacadɨmacɨ. Iena naimɨe uiñua jira, iena naimɨe jitaiñena jira, aneduaɨmo naimɨe oni jaide. ");
INSERT INTO huuNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Jitoma ana itemo, jai navuidemo, ie llofueoicaiganodɨcaɨ joraimo jaidɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Caɨ botemo caɨ jaillano, ruica Capernaumo jaiacadɨcaɨ; iadedɨ Jesús nia biñede. Jesúna sedadɨcaɨmo, naimɨe biñena jirari, jai jitɨrena facaiseconi jai jaidɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Rɨire aɨfɨ illa jira, jorai eo bagode. ");
INSERT INTO huuNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Nɨbaɨ cinco, nɨbaɨ seis kilómetros jaidɨcaɨmo, damɨe caɨ dɨne jɨnui emododo billana cɨodɨcaɨ. Bote dɨne naimɨe billana cɨuanona, jacɨnaitɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Jesús caɨmo llote: —Jesúdɨcuesa. Jacɨnaiñeno. ");
INSERT INTO huuNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Iena cacajanona, botemo naimɨena a billana jitaidɨcaɨ. Ieconi ruica dɨne caɨ jaiacananomo ridɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","24","Caɨ jailla mei, daje bote nairuido illa jira, jɨnafomo fɨebidɨno Jesús caɨ dɨga jaiñenana uiñotɨmacɨ. Caɨ Nama ie Moomo iobillacɨnona fecajanomo, comɨnɨmo guille fecajanomo, Tiberiamona dajerie botes naie facaise iaɨre bite. Monaidemo, Jesúna naimacɨ cɨoiñena jira, caɨ jɨaɨ iñena jira, naie botiaɨdo Capernaumo Jesúna jenollena, jaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ruica dɨne Jesúna comɨnɨ baillanona, jɨcanotɨmacɨ: —¿Nɨruido bene ridɨo? ");
INSERT INTO huuNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesús uai ote: —Navui are omoɨna cue ecajamona, iemona omoɨ monillamona, cuena jenodomoɨ. Siño rafuena cue fɨnuana cɨodomoɨ; iadedɨ cuena nia ɨɨnoñedomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Guille raɨre cueicabide. Cueiruide ramo comecɨaɨna eo facañeno. Cueiruiñede ramo comecɨaɨna eo faca. Jusiñamui dɨga omoɨ jaca illemo comecɨaɨna eo faca. Cue Moo Jusiñamui, ɨimana cue jaillena, cuena oretate. Ie uai cuemo illanona, cue uaina omoɨ ɨɨnuamona, Jusiñamui dɨga jaca iitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Jɨcanotɨmacɨ: —Nia Jusiñamui dɨbeimo itɨcaɨna, ¿nɨe isoidɨfue fɨnodɨcaɨna mare? ");
INSERT INTO huuNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesús uai ote: —Naimɨe oretagamɨe uaina omoɨ ɨɨnuana jitaide. ");
INSERT INTO huuNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Naimacɨ dɨnena dane jɨcanotɨmacɨ: —¿Nɨe isoide rafuena fɨnoitɨo? iena caɨ cɨuano, o uaina caɨ ɨɨnollesa. ");
INSERT INTO huuNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Caɨ jaiagaɨ jofue iñenanomo Jusiñamuimona bite guilla ra guisoidɨmacɨ. Moisés mɨcorɨ iena jaie cuega: “Jusiñamuimona bite guiga ra naimacɨmo nagarui fecauide”. Iemo jɨaɨ birui ocuiridɨcaɨ. Naie isoide siño rafuena o fɨnuana jɨaɨ cɨoacadɨcaɨ —llotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jesús uai ote: —Uanai llotɨcue. Moisés mɨcorɨ naie guiga ra jaca fecañede. Cue Moo iena fecauide. Birui naimɨedɨ monamona bite ua llomenicona omoɨmo jai fecaacade. ");
INSERT INTO huuNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Jusiñamui fecaacalle llomenico monamona jai bite. Comɨnɨ iena guillamona, jaca iitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Llotɨmacɨ: —Nagarui caɨmo bie isoide llomenicona feca. ");
INSERT INTO huuNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesús uai ote: —Llomenico guillamona itɨcaɨ. Omoɨ llomenico isoidɨcue. Cuena ɨɨnuamona, monamo jaca iitomoɨ. Cuena ɨɨnotɨmɨe dane aimetaiñeite. Cuena isiruitɨmɨe jaca dane jiroacaiñenite. —Iese llote; ia naimacɨ comecɨaɨna ñaɨte. Naimacɨ comecɨaɨ jitaillacɨno naimacɨmo jaca illena ñaɨte—. ");
INSERT INTO huuNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Cuena cɨodomoɨ; iadedɨ cuena ɨɨnoñedomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Nana cue dɨbeimo cue Moo itatallɨnodɨ cuena ɨɨnoitɨmacɨ. Cuemona naimacɨna jaca oni dotañeitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Cuena oretatɨmɨe ie jitailla rafuena fɨnollena, monamona jai bitɨcue. Dama cue jitailla rafuena fɨnoitɨcuena biñedɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Cuena oretatɨmɨedɨ cue dɨbeimo itatallɨnomona buna faɨfillana jitaiñede. Jusiñamui lluaruimo fiodaillamona nana naimacɨ abɨaɨna cue jilloitajana jɨaɨ jitaide. ");
INSERT INTO huuNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Jusiñamui Jitona cue illana bu ɨɨnoia, cuena bu ɨɨnoia, monamo jaca iite. Jusiñamui llollɨruimo fiodaillamona naimɨe abɨna jillotaitɨcue. Iese cue Moo jitaide. ");
INSERT INTO huuNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Jesúdɨ: “Monamona bite llomenicodɨcue” railla jira, judíuaɨ illaɨcomɨnɨdɨ naimɨe uaina jamaillano ɨɨnosɨñede. ");
INSERT INTO huuNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Raitɨmacɨ: —Bimɨedɨ Jesús. José jito. Ie moona uiñotɨcaɨ. Ie eina jɨaɨ uiñotɨcaɨ. ¿Nɨese naimɨedɨ: “Monamona bitɨcue” raite? ");
INSERT INTO huuNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jesúdɨ uai ote: —Iese omoɨ naɨñeno. ");
INSERT INTO huuNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Naimɨena cue Moo ɨɨnotañenia, bu cuena ɨɨnonide. Cuena bu ɨɨnoñenia, Jusiñamui llollɨruimo fiodaillamona naimɨe abɨna jillotaitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Jusiñamuina lloraɨnɨ mɨcorɨaɨ jaie iena cuetɨmacɨ: “Jusiñamuidɨ nana comɨnɨna ɨco llofueite” cuetɨmacɨ. Birui naie rafue jai suide. Naga cue Moomo cacarefidɨmɨe, naga cue Moomona fueotɨmɨe cuena jɨaɨ ɨɨnoite. ");
INSERT INTO huuNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Buna cue Moona jaca cɨoiñede. Naimɨemona cue billamona, dama cue cɨua. ");
INSERT INTO huuNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Uanaicɨnona llotɨcue. Cue uaina ɨɨnotɨmɨe monamo jaca iite. ");
INSERT INTO huuNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Jesús dane llote: —Llomenico guillamona itɨcaɨ. Omoɨ llomenico isoidɨcue. Cuena ɨɨnuamona, monamo jaca iitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Jofue iñenanomo omoɨ jaiagaɨ Jusiñamuimona bite rana guisoidɨmacɨ; iadedɨ fiodaitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Birui jɨaɨe guille ra ite. Monamona ite. Iena bu guia, monamo jaca iite. ");
INSERT INTO huuNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Bie llomenicodɨ cue. Monamo comɨnɨna jaca itatallena, monamona bitɨcue. Bu bie isoide llomenicona guia, jaca iite. Bie llomenicodɨ cue abɨ. Comɨnɨ facaina fiodaitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Iena cacajano, judíuaɨ illaɨcomɨnɨ coninɨri naiena siadotɨmacɨ. Raitɨmacɨ: —¿Nɨese bimɨe abɨna rɨitɨcaɨ? ");
INSERT INTO huuNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ie jira Jesús dɨnena raite: —Uanai llotɨcue. Cue abɨna omoɨ rɨñenia, cue dɨruena omoɨ rɨñenia, cue Moo dɨga jaca iñeitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Bu cue abɨna rɨia, bu cue dɨruena rɨia, cue Moo dɨga jaca iite. Fiodaillamona naimɨe abɨ iiraɨruimo jillotaitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Cue abɨdɨ ua rɨlle. Cue dɨruedɨ ua rɨlle. ");
INSERT INTO huuNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Bu cue abɨna rɨia, bu cue dɨruena rɨia, cuena nabaide. Naimɨena jɨaɨ nabaidɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Cue Moo cuena orede. Naimɨedɨ jaca ite. Cue Moo jaca illa jira, cue jaca itɨcue. Daje isoide. Bu cue abɨna rɨia, cue illamona, naimɨe jɨaɨ iite. ");
INSERT INTO huuNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Bie isoide guille ra monamona jai bite. Omoɨ jaiagaɨ jaie guiga ra isoiñede. Jaie fiodaitɨmacɨ; iadedɨ bie guille ra birui bu guia monamo jaca iite. —Iese llote; iadedɨ naimɨe fiodaillamona, naimɨena comɨnɨ ɨɨnuamona, Jusiñamui dɨga naimacɨ jaca illena ñaɨte. ");
INSERT INTO huuNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Capernaumo judíuaɨ ofiracomo Jesús biena llote. ");
INSERT INTO huuNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Jesús dɨga jaisoidɨno naimɨe lluana cacajano, coninɨri siadotɨmacɨ: —Bie llua eo ɨrɨrede. Bu iena cacaiñede. ");
INSERT INTO huuNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jesúdɨ naimacɨ iese siaduana uiñote. Ie jira llote: —Cue lluana raise ɨɨnoñedomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Jusiñamuimona ɨimana jaillena jai bitɨcue. Monamo abɨdo ɨco cue jaillena cɨoitomoɨna, iena jɨaɨ nɨbaɨ raise ɨɨnoñeitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Caɨ joreño caɨmo illamona, itɨcaɨ. Danɨ caɨ abɨ dɨga iñedɨcaɨ. Ie isoide. Cue llogacɨno Jusiñamuimo duide. Iena omoɨ ɨɨnuamona, jaca iitomoɨ; ");
INSERT INTO huuNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","ia omoɨmona nana ɨɨnoñedomoɨ —llote. Nano dofoconimona Jesúdɨ naimɨena ɨɨnoñedɨnona uiñote. Naimɨena gaɨtataitɨmɨena jɨaɨ uiñote. ");
INSERT INTO huuNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Jesús dane llote: —Ie jira omoɨmo llotɨcue: Cue Moo jitaiñenia, cuena jaca bu ɨɨnonide. ");
INSERT INTO huuNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Iena cacajano, Jesús dɨga jaisoidɨnomona, dɨga comɨnɨ naimɨena faɨnonocaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ie jira ie doce llofueoicaiganodɨcaɨmo Jesús jɨcanote: —¿Jɨaɨ cuena faɨnonocaida, abɨdo jaitomoɨ? ");
INSERT INTO huuNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simón Pedro uai ote: —Nama, o dɨga caɨ jaiñenia, ¿bu dɨga jaitɨcaɨ? Jusiñamuimo caɨ rillena, o isoi Jillotaraɨma iñede. Jɨaɨmɨemo jaca itatajaracɨnodɨ iñede. ");
INSERT INTO huuNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","O lluana jai ɨɨnotɨcaɨ. Jusiñamui mare Jitodɨo. Iena uiñotɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesús dane uai ote: —Doce dɨgamɨe fetocaomoɨ; iadedɨ omoɨmona damɨe Taɨfemo jaɨnaɨaɨde —llote. ");
INSERT INTO huuNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Caɨmona Judas Iscariote mɨcorɨna ñaɨte. Judas mɨcorɨ Jesúna gaɨtataiacadɨmɨe. ");
INSERT INTO huuNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Jɨaɨruido Galileamo ite naɨraɨaɨmo Jesús macarite. Judíuaɨ illaɨcomɨnɨ naimɨena meineiacana jira, Judeamo jaiñede. ");
INSERT INTO huuNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Jɨfocotɨaɨaɨ railla rafue iaɨre ite. Judíuaɨ ie rafue. ");
INSERT INTO huuNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ie jira Jesús amatɨaɨ naimɨemo llote: —O dɨga jaicabidɨno o fɨnua rafuena raise cɨoillena, beno faɨnonocaida, Judeamo jai. ");
INSERT INTO huuNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Bu ie mamecɨ are soriacania, bainino maɨjɨraɨnina. Ie isoide. Siño rafuena o fɨnoia, ailluena comɨnɨ illa motomo iena fɨno. ");
INSERT INTO huuNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Jesús amatɨaɨ naimɨena ɨɨnoñena jira, iese raite. ");
INSERT INTO huuNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jesús dɨnena uai ote: —Jerusalémo nia jaiñeitɨcue; iadedɨ nainomo omoɨ jaiacallɨruido omoɨ jai. ");
INSERT INTO huuNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Comɨnɨ omoɨna enoiñedɨmacɨ. Naimacɨ fɨnoca jearede rafuena cue llua jira, cuena jaca enoidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Jerusalémo rafuemo jai. Cue jaillɨrui nia riñena jira, nia jaiñeitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","—Iese lluano, Galileamo naimɨe fɨebide. ");
INSERT INTO huuNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Naimɨe amatɨaɨ rafuemo jailla mei, Jesúdɨ naimacɨ jɨnafona dama bainino jaide. ");
INSERT INTO huuNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Nai rafuemo judíuaɨ illaɨcomɨnɨ Jesúna jenuano baiñenano, comɨnɨmo jɨcanotɨmacɨ: —¿Nɨnomo naimɨe ite? —Uiñoñena jira, comɨnɨ uai oñedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Nainomo ailluena comɨnɨ itɨmacɨ. Comɨnɨ illa motomo naimɨena anado siadosɨde. Jɨaɨno dɨnena: “Naimɨedɨ mare” raitɨmacɨ. Jɨaɨno dɨnena: “Naimɨedɨ comɨnɨna jɨfuete” raitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Judíuaɨ illaɨcomɨnɨna icɨana comɨnɨ jacɨruillanona, anado siadosɨde. Jesúna marefodo buna ñaɨñede. ");
INSERT INTO huuNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Jɨfocotɨaɨaɨ railla rafue atuedo fuitemo, Jesús Jusiñamui jofomo jaillano, llofuete. ");
INSERT INTO huuNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Illaɨcomɨnɨ naimɨe llofuiamona raijicaidɨmacɨ: —¿Nɨese naimɨe abɨ uiñote? Eo rafuena uiñotɨmɨemona jaca fueoñede —raitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesús uai ote: —Dama cuemona oñega cue llofuiacɨnodɨ. Cuena oretatɨmɨe ie. ");
INSERT INTO huuNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Jusiñamui jitaillacɨnona fɨnoiacadɨmɨedɨ nɨnomona cue llofuiacɨnona cue uana uiñoite. Jusiñamuimona cue uana uiñoite. Dama cue comecɨmona cue oñenana jɨaɨ uiñoite. ");
INSERT INTO huuNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Bu dama ie comecɨmona ie llofuiacɨnona uanona lloia, naimɨedɨ comɨnɨ naimɨemo iobillacɨnona fecajana jitaide; iadedɨ bu ie oretatɨmɨena iobitaia, uanai llote. Maraiñedɨcɨnona fɨnoñede. ");
INSERT INTO huuNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moisés mɨcorɨ Jusiñamui uaina jaie llote; iadedɨ birui naie llogacɨnuaɨna nia raise ɨɨnoñedomoɨ. Iena raise ɨɨnotomoɨdena, cuena niade meineiacaiñedomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Comɨnɨ dɨnena uai ote: —Nibaɨ uaɨritaidɨo. ¿Bu ona meineiacade? ");
INSERT INTO huuNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesús uai ote: —Dacaiño sábadoruimo damɨena jillotatɨcue. Ie jira cue uaina uaitatomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Sábadoruimo jɨaɨ maɨjɨcabidomoɨ. Moisés mɨcorɨ ɨisaɨaɨ abɨaɨ diana omoɨmo jaie llote; iadedɨ naimɨe mɨcorɨ naiena nano lloñede. Naimɨe mɨcorɨ usumatɨaɨ naiena nano llotɨmacɨ. Sábadoruimo ɨisana abɨ dellɨrui ia, detomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Moisés mɨcorɨ llogacɨnona ɨɨnollena, sábadoruimo ɨisaɨaɨna detomoɨ. Sábadoruimo ɨimana raise jillotatɨcuemo, ¿bue ñellena cue dɨga icɨritomoɨ? ");
INSERT INTO huuNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Comɨnɨmo jamai eruaɨllanona, naimacɨna jeare ñaɨñeno; ia naimacɨ fɨnoca rafuena raise uiñuamona, naimacɨmo comecɨna faca. Cue fɨnoca rafuemo comecɨna faca. ");
INSERT INTO huuNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ie jira Jerusalémo itɨno coninɨri siadotɨmacɨ: —Illaɨcomɨnɨ bimɨena meineiacadɨmacɨ; ");
INSERT INTO huuNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","iadedɨ beno marefodo naimɨe llofuete. Jaca buena lloñedɨmacɨ. Illaɨcomɨnɨdɨ: “Bimɨedɨ caɨ Jilloitaraɨma” raillano nɨbaɨ comecɨaɨna facadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Bimɨe ie billanona caɨ uiñua jira, naimɨedɨ caɨ Jilloitaraɨmañedɨmɨe. Caɨ Jilloitaraɨma baireia, jaca budɨ naimɨe billanona uiñoñeite —siadotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ie jira Jesús Jusiñamui jofomo naimɨe llofuiano llote: —Cuena uiñotomoɨ. Nɨnena cue billana jɨaɨ uiñotomoɨ. Cue jitailla jira biñedɨcue; iadedɨ jɨaɨmɨe cuena oretate. Naimɨedɨ uanai llote. Naimɨena uiñoñedomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Naimɨemona cue billa jira, naimɨena uiñotɨcue. Cuena oretate —llote. ");
INSERT INTO huuNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ie jira illaɨcomɨnɨ Jesúna gaɨtaacadɨmacɨ; iadedɨ naimɨe fiodaille facaise nia riñena jira, buna naimɨena gaɨtañede. ");
INSERT INTO huuNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Nairui ailluena comɨnɨ naimɨe uaina ɨɨnotɨmacɨ. Raitɨmacɨ: —Caɨ Jilloitaraɨma bia, ¿nɨese naimɨedɨ bimɨe baɨfemo jɨaɨe rafuena fɨnoite? ");
INSERT INTO huuNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Fariseuaɨdɨ comɨnɨ iese ñaɨana cacajano, Jesúna gaɨtallena, Jusiñamui dɨga nanoca ñaɨraɨnɨdɨ ailluena policíana orede. ");
INSERT INTO huuNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ie jira naimacɨna Jesús dɨnena raite: —Dallu omoɨ dɨga nia iitɨcue. Ie mei cuena oretatɨmɨe dɨne abɨdo jaitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Cuena jenoitomoɨ; iadedɨ cuena baiñeitomoɨ. Cue dɨne binitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ie jira nainomo ite illaɨcomɨnɨ danɨ siadotɨmacɨ: —¿Nɨne jaite? ¿Nɨese naimɨena baiñeitɨcaɨ? Judíuaɨñedɨnona llofuellena, jɨaɨe enɨruemo caɨ comɨnɨ dɨne nɨbaɨ jaite. ");
INSERT INTO huuNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Nɨese naimɨe raite: “Cuena jenoitomoɨ; iadedɨ cuena baiñeitomoɨ”? ¿Nɨese raite: “Cue dɨne binitomoɨ”? —iese siadotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Jifocotɨaɨaɨ railla rafue fuillaruimo, ua rafue ie nairuimo, Jusiñamui jofomo itɨnomo Jesús ado llote: —Bu jiroacania, cue dɨne bi. ");
INSERT INTO huuNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Jusiñamui facaina lloraɨnɨ mɨcorɨaɨ jaie cuega: “Naimɨena ɨɨnotɨmɨe comecɨmo jaca itatate jɨnui isoi iite, torafomona jɨnui tonooilla isoi”. ");
INSERT INTO huuNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jesúdɨ iese llote; ia Jusiñamui Joreñona ñaɨte. Jusúna ɨɨnotɨnomo Jusiñamuidɨ ie Joreñona ɨco illena ñaɨte. Jesús nia fiodaiñena jira, iena nia iñega. ");
INSERT INTO huuNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Jesús lluana comɨnɨ cacajano, raitɨmacɨ: —Jsiñamui facaina lloraɨnɨ mɨcorɨaɨ Jusiñamui facaina lloraɨma ɨco billena jaie llotɨmacɨ. “Cristo nia baireñenia, naimɨe biite” llotɨmacɨ. Bimɨedɨ naimɨe. ");
INSERT INTO huuNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Jɨaɨno raitɨmacɨ: —Naimɨedɨ caɨ Jilloitaraɨma. Naimɨedɨ Cristo. Jɨaɨno raitɨmacɨ: —Caɨ Jilloitaraɨma Galileamona biñeite. ");
INSERT INTO huuNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Jusiñamui facaina lloraɨma mɨcorɨ cuega: “Caɨ Jilloitaraɨmadɨ David mɨcorɨ jito. Belémo David mɨcorɨ illanomo jeicɨlle”. ");
INSERT INTO huuNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ie jira daje isoi naimɨemo comecɨaɨna facañedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Jɨaɨno naimɨena gaɨtaacadɨmacɨ; iadedɨ buna naimɨena jetañede. ");
INSERT INTO huuNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ie mei policías naimacɨ illaɨcomɨnɨ dɨne abɨdo jaidɨmacɨ. Fariseuaɨ dɨnena jɨcanotɨmacɨ: —¿Bue ñellena Jesúna atɨñedomoɨ? ");
INSERT INTO huuNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Policías dɨnena uai ote: —Naimɨe llofuia isoi jaca buna llofueñede. Iena jacɨnaillanona, naimɨena atɨñedɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Fariseuaɨ dane llotɨmacɨ: —Comɨnɨna jɨfuia isoi, omoɨna jɨaɨ jɨfuete. ");
INSERT INTO huuNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Caɨ illaɨcomɨnɨ dɨnena naimɨena jaca ɨɨnoñedɨcaɨ. Moisés mɨcorɨ llogacɨnodo raise jaidɨcaɨ; ");
INSERT INTO huuNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","ia Jesús llofuiana cacadɨno Moisés mɨcorɨ llogacɨnuaɨdo jaca raise jaiñedɨmacɨ. Ie jira jaca faɨfitɨmacɨsa. ");
INSERT INTO huuNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Naie illaɨcomɨnɨmona Nicodemo raillamɨe ite. Naimɨe naɨona Jesús dɨne navui jaide. Fariseo imɨe. ");
INSERT INTO huuNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Jesúna rɨiduanona, naimɨe llote: —Caɨ einamacɨ llocabitɨmacɨ: “Bu duere caɨ fɨnoacania, nano naimɨe lluamo cacarefitɨcaɨ. Jearede rafue naimɨe fɨnuana cacareillano, naimɨena duere fɨnoitɨcaɨ”. Iena caɨ cacaiñenia, naimɨena duere fɨnoñeitɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Nicodemomo llotɨmacɨ: —Galileamona bitɨno isoi ñaɨtɨo. Naimɨe llofuegamɨena nɨbaɨ jai jaiacadɨo. Jaie cuegafuiaɨna raise faca. Jusiñamui facaina lloraɨnɨ mɨcorɨaɨdɨ caɨ naɨraɨna Jilloitaraɨma Galileamona billena jaie cueñedɨmacɨ. Bie Jesús raillamɨedɨ caɨ naɨraɨna Jilloitaraɨmañedɨmɨe. ");
INSERT INTO huuNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ie meinoconi damɨerie imacɨ jofomo jaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Naie facaise Jesúdɨ Olivos railla anedumo jaide. ");
INSERT INTO huuNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ie areruido jitɨramo Jusiñamui jofomo abɨdo dane jaide. Ailluena comɨnɨ naimɨe dɨne billa jira, naimɨe ana raɨta, naimacɨna llofuete. ");
INSERT INTO huuNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Naie facaise Moisés mɨcorɨ llogacɨnona llofueraɨnɨmona dajerie bitɨmacɨ. Fariseuaɨmona dajerie jɨaɨ bitɨmacɨ. Daje rɨño atɨdɨmacɨ. Ie ɨniñede ɨima dɨga naiñaiñona jai eidatɨmacɨ. Comɨnɨ illa uicomo atɨano, ");
INSERT INTO huuNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Jesúmo llotɨmacɨ: —Llofueraɨma, biñaiño ie ɨniñede ɨima dɨga eidatɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moisés mɨcorɨ jaie cuega: “Bie isoidɨñaiñodɨ nofɨcɨ dɨga faɨrɨnoga, meinellena”. ¿Nɨese naiñaiñona o raitɨo? ");
INSERT INTO huuNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Naimɨena facacɨllena, naimɨe raise uai oñenia, naimɨena llogɨdollena, iese jɨcanotɨmacɨ. Iena cacajano, Jesús ana jɨtadacaida, enɨruemo ie onocaɨ dɨga cuete. ");
INSERT INTO huuNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Naimɨemo dɨga icaiño jɨca-jɨcanuano, naimɨe naidacaida, naimacɨmo llote: —Omoɨmona jeacɨno iñedɨmɨe naiñaiñomo nano nofɨcɨna faɨrɨno. ");
INSERT INTO huuNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Dane ana jɨtadacaida, enɨruemo dane cuete. ");
INSERT INTO huuNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Naimɨe lluana cacajano, dajerie jino jaidɨmacɨ. Nano eo einamacɨdɨ jino jaidɨmacɨ. Ie mei coniruenɨ jino jaidɨmacɨ. Nana comɨnɨ tuua mei, nainomo Jesús fɨebide, naie rɨño dɨga ñaɨllena. ");
INSERT INTO huuNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Eruaɨllano naiñaiñomo jɨcanote: —¿Nɨ nai o llogɨdotɨno? ");
INSERT INTO huuNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Naiñaiño uai ote: —Jaca iñedɨmacɨ. Cuena jai llogɨdoiacaiñedɨmacɨ. Jesús uai ote: —Jɨaɨ ona duere fɨnoñeitɨcue. Mai jai. Jeacɨno dane fɨnoñeno. ");
INSERT INTO huuNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jesúdɨ comɨnɨna dane llofuianona, raite: —Jeacɨno oni jaillena, comɨnɨ comecɨaɨna llɨgaiñotɨcue. Cuena ɨɨnotɨmɨe jitɨredɨnomo jaca iñeite. Jeacɨno anamo jai iñedɨmɨe Jusiñamui dɨga ɨco jaca iite. ");
INSERT INTO huuNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Fariseuaɨ dɨnena uai otɨmacɨ: —Dama o abɨna ñaɨtɨo. Ie jirari uanaicɨnona lloñedɨo. ");
INSERT INTO huuNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesús uai ote: —Dama cue abɨna llotɨcue; iadedɨ uanaicɨnona llotɨcue. Nɨnena cue billanona uiñotɨcue. Nɨne cue jaillɨnona jɨaɨ uiñotɨcue. Nɨnena cue billanona uiñoñedomoɨ. Nɨne cue jaillɨnona jɨaɨ uiñoñedomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Abɨ raise uiñoñeno cuena jeare ñaɨtomoɨ. Iese omoɨna ñaɨñedɨcue; ");
INSERT INTO huuNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","iadedɨ omoɨna cue ñaɨa, uanaicɨnona llotɨcue. Dama cue uaina omoɨna lloñedɨcue. Cuena oretatɨmɨe omoɨna jɨaɨ llote. ");
INSERT INTO huuNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Moisés mɨcorɨ iena jɨaɨ jaie cuega: “Menamɨe daje isoi lloia, naie iaɨmaiaɨ lluacɨnodɨ omoɨ ɨɨnua” cuega. ");
INSERT INTO huuNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Cue facaina llollena, menamɨe jai ite. Cue facaina llotɨcue. Cue Moo cue facaina jɨaɨ llote. ");
INSERT INTO huuNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Fariseuaɨ dɨnena jɨcanote: —¿Nɨ o moo? Jesúdɨ uai ote: —Cuena uiñoñedomoɨ. Cue Moona jɨaɨ uiñoñedomoɨ. Cuena uiñotomoɨna, cue Moona jɨaɨ uiñotomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jusiñamui jofomo ucube eenoracomo bicɨnona siadotɨmacɨ. Jesús fiodaille facaise nia riñena jira, jaca buna naimɨena gaɨtañede. ");
INSERT INTO huuNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Naimacɨmo Jesús dane llote: —Ɨco oni jaitɨcue. Cuena jenoitomoɨ; iadedɨ cuena baiñeitomoɨ. Na omoɨmo jeacɨno nia itemo, fiodaitomoɨ. Cue jaillɨnomo jainitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ie jira judíuaɨ illaɨcomɨnɨ dɨnena iena siadotɨmacɨ: —Dama ie abɨna meineite. “Cue jaillɨnomo jainitomoɨ” Jesús railla jira, iese siadotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jesúdɨ uai ote: —Jusiñamuimo ite rafuemo duiñedomoɨ. Naimɨemo ite rafuemo duidɨcue. Naimɨe dɨbeimo iñedomoɨ; ia naimɨe dɨbeimo itɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Cue Jusiñamui Jitonana omoɨ ɨɨnoñena jira, na omoɨ jeacɨno dɨga fiodaitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Jɨcanosɨde: —¿Budɨo? Jesús uai ote: —Nano omoɨ motomo cue illamona bumɨedɨcuena omoɨna raicabitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Dɨga rafue omoɨmo lloiacadɨcue. Maraiñede rafuena omoɨ fɨnuana omoɨmo nia lloiacadɨcue; iadedɨ omoɨmo cuena oretatɨmɨe uaina dama llotɨcue. Nai uaidɨ uanaicɨno —llote. ");
INSERT INTO huuNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Naimɨedɨ ie Moo Jusiñamuina llote; iadedɨ cacaiñedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ie jira Jesús llote: —Cuena omoɨ meinia mei, bumɨedɨcuena uiñoitomoɨ. Cue uaido dama lloñedɨcue; iadedɨ cue Moo cue llofuia uaido llocabitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Cuena oretatɨmɨe cue dɨga ite. Naimɨe jitaille rafuena cue fɨnua jira, cuena faɨnonocaiñede. ");
INSERT INTO huuNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Iese Jesús llotemo, dɨga illaɨcomɨnɨ naimɨe uaina como ɨɨnoiacadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Jesúdɨ naimɨe uaina como ɨɨnoiacadɨnomo llote: —Cue lluana ɨɨnocana omoɨ jaia, cue ua comɨnɨdomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Uanaicɨnona uiñoitomoɨ. Ie mei jɨaɨmɨe anamo dane iñeitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Uai otɨmacɨ: —Abraham mɨcorɨ ie uruiaɨdɨcaɨ. Jɨaɨmɨe anamo jaca iñedɨcaɨ. ¿Bue ñellena llotɨo: “Jɨaɨmɨe anamo iñeitomoɨ”? ");
INSERT INTO huuNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesúdɨ uai ote: —Uanai llotɨcue. Jeacɨno fɨnocabidomoɨ. Naga jeacɨno fɨnoraɨma ie jeacɨno anamo jai ite. Omoɨ jeacɨno anamo omoɨ illana ñaɨtɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Jɨaɨe rafuedo iena lloitɨcue. Ie patrón anamo itɨmɨemo ie patrón rafuedɨ duiñede; iadedɨ naie patrón jitomo ie rafuedɨ duide. ");
INSERT INTO huuNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ie isoide. Jusiñamui Jitona cue illamona, naimɨe rafuemo duidɨcue. Ie jira omoɨmo cue lloia, omoɨ jeacɨno anamo ua iñeitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Abraham mɨcorɨ ie uruiaɨdomoɨ. Iena uiñotɨcue; iadedɨ cue lluana omoɨ raise ɨɨnoñena jira, cuena meineiacadomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Cue Moo dɨga jaie cue illamona, cue cɨua rafuena llocabitɨcue. Omoɨ moomona cacaja rafuena fɨnocabidomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Uai otɨmacɨ: —Caɨ moodɨ Abraham mɨcorɨ. Jesús dane uai ote: —Abraham mɨcorɨ uruiaɨdomoɨdena, Abraham mɨcorɨ fɨnoca rafue isoi fɨnodomoɨ. Abraham mɨcorɨ uruiaɨñedomoɨ. Ie jira Abraham mɨcorɨ fɨnoca rafue isoi fɨnoñedomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Uanai cue llua jira, cuena meineiacadomoɨ; iadedɨ Abraham mɨcorɨ iese fɨnoacaiñede. Cue lluacɨno Jusiñamuimona otɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Jusiñamui uruiaɨ fɨnoca rafuena fɨnoñedomoɨ; iadedɨ omoɨ moo fɨnoca rafuena fɨnocabidomoɨ. Uai otɨmacɨ: —Jamai naɨraɨ ie uruiaɨñedɨcaɨ. Caɨ Moodɨ Jusiñamui. ");
INSERT INTO huuNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesús dane llote: —Jusiñamuidɨ omoɨ moodena, cuena isiruitomoɨ, naimɨemona cue billa jira. Cue jitailla jira, biñedɨcue; iadedɨ cuena oretate. ");
INSERT INTO huuNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Bue ñellena cue lluana cacaiñedomoɨ? Cacareiraɨnidomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Omoɨ moodɨ Taɨfena jira, cue lluana ɨɨnoñedomoɨ. Naimɨe jitailla rafuena fɨnoacacabidomoɨ. Nano dofomona naimɨedɨ comena meineraɨma. Naimɨe taɨno jaca llua jira, uanaicɨnona naimɨe jaca gaɨñede. Naimɨe taɨnona lloia, ie comecɨ llua isoi llote. Naimɨemona taɨno lluacɨnodɨ comuicabide. Naimɨe isoidomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Uanai cue llua jira, cuena ɨɨnoñedomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Nɨe isoide jeacɨno fɨnodɨcue? Cuemo llono. Uanai cue llia, ¿bue ñellena cuena ɨɨnoñedomoɨ? ");
INSERT INTO huuNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Jusiñamuina mooredɨmɨedɨ Jusiñamui uaina cacade. Jusiñamui uruiaɨñedomoɨ. Ie jira cue lluana cacaiñedomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Naimɨena jearuillanona, naie illaɨcomɨnɨ dɨnena iese raitɨmacɨ: —Samaritano naɨraɨ imɨedɨo. Janaba illamɨedɨo. Uaɨritaidɨo. ");
INSERT INTO huuNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesús uai ote: —Janaba illamɨeñedɨcue. Cue fɨnoca rafuemona cue Moona iobitadɨcue; iadedɨ iese cuena omoɨ ñaɨamona cuena iobitañedomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Omoɨmona iobillacɨnona feiñollena, cue rafuena fɨnoñedɨcue; ia cue Moo iena oiacade. Cuena omoɨ ɨɨnoñenia, cuemo iobillacɨnona omoɨ fecañenia, cue Moo omoɨna duere fɨnoite; ");
INSERT INTO huuNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","ia bu cue lluana ua ɨɨnoia, jaca ua fiodaiñeite. ");
INSERT INTO huuNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Naie illaɨcomɨnɨ dɨnena uai otɨmacɨ: —Janaba illamɨedɨona jai uiñotɨcaɨ. Abraham mɨcorɨ jaie fiodaite. Jusiñamuina lloraɨnɨ mɨcorɨaɨ jɨaɨ jaie fiodaitɨmacɨ; iadedɨ: “Bu cue lluana ɨɨnoiadedɨ, fiodaiñeite” raitɨo. ");
INSERT INTO huuNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Caɨ usuma Abraham mɨcorɨ baɨfemo faɨñedɨo. Jusiñamuina lloraɨnɨ mɨcorɨaɨ baɨfemo faɨñedɨo. ¿Bumɨedɨota? ");
INSERT INTO huuNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesúdɨ uai ote: —Dama cue abɨna birɨñedɨcue; ia cue Moo cuena marena ñaɨamona, cuena iobitate. “Caɨ Moodɨ Jusiñamui” raicabitomoɨ; ");
INSERT INTO huuNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","iadedɨ naimɨena uiñoñedomoɨ. Naimɨena uiñotɨcue. “Naimɨena uiñoñedɨcue” cue raia, omoɨ isoi taɨno llotɨcue. Naimɨena uiñotɨcue. Naimɨena jɨaɨ ɨɨnotɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Omoɨ usuma Abraham mɨcorɨ enɨruemo cue ɨco billena jaie uiñote. Iena uiñuamona, naimɨe iobide. ");
INSERT INTO huuNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Illaɨcomɨnɨ dɨnena uai otɨmacɨ: —Odɨ cincuenta años nia iñedɨo. ¿Nɨese Abraham mɨcorɨna cɨodɨo? ");
INSERT INTO huuNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesús uai ote: —Abraham mɨcorɨ nia iñena facaiseconi jaca itɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Iena cacajanona, naimɨe faɨrɨnollena, naie illaɨcomɨnɨ nofɨcɨna llɨnotɨmacɨ; iadedɨ Jesús reirillanona, Jusiñamui jofomona oni jaide. ");
INSERT INTO huuNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jɨaɨruido ie llofueoicaiganodɨcaɨ dɨga Jesús macaria, uisɨnidɨmɨena cɨode. Iese nanomona jaca naimɨedɨ jeicɨga. ");
INSERT INTO huuNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Jesúmo jɨcanotɨcaɨ: —Llofueraɨma, ¿bue ñellena naimɨedɨ iese jeicɨga? ¿Nɨe isoide ra ie moo jetajamona, naimɨe iese jeicɨga? ¿Nɨe isoide ra ie ei jetajamona, naimɨe iese jeicɨga? Caɨmo llono. ");
INSERT INTO huuNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesús uai ote: —Naimɨe jeacɨno fɨnua muidonañede. Ie moo muidonañede. Ie ei muidonañede. Jaca bue jetajamona, iese comuiñede. Jusiñamui uai siñonana comɨnɨ uiñollena, iese jeicɨga. ");
INSERT INTO huuNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Nia userena jira, cuena oretatɨmɨe ie jitailla rafuena fɨnoacadɨcaɨ. Raɨre jitɨrenite. Ie mei bu jaca maɨjɨnite. ");
INSERT INTO huuNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Enɨruemo cue nia ia, comɨnɨ comecɨaɨna llɨgaiñotɨcue. —Iese Jesús llote; iadedɨ jɨaɨe rafuena ñaɨte. Naimɨe nia fiodaiñenia, Jusiñamui rafuena llocana naimɨe jaillana ñaɨte. Ie fiodaillɨrui jai iaɨre iacanana ñaɨte. Comecɨaɨna llɨgaiñuana llote, jeacɨno oni jaillena. ");
INSERT INTO huuNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Iena lluanona enɨruena tuajano, enɨrue ɨdɨaɨ fɨnuanona, uisɨnidɨmɨe uisɨna naie enɨrue dɨga rɨgɨnote. ");
INSERT INTO huuNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Raite: —Siloé railla joraibɨmo mai noisai —raite. Siloé oni dobaiñuamona: “Oretarabɨ”. Ie jira naimɨe noisaide. Uisɨ jai cɨodemo, abɨdo bite. ");
INSERT INTO huuNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Billa mei, naimɨe ecɨmo itɨno, jɨaɨ naimɨena cɨocabidɨno dɨga, naimɨe jilluana coninɨri siadotɨmacɨ: —¿Buuta naimɨedɨ? Bene ucube jɨcallena raɨcabidɨmɨe isoide. ");
INSERT INTO huuNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Jɨaɨno raitɨmacɨ: —Jɨɨ, naimɨe. Jɨaɨno raitɨmacɨ: —Ieñede. Naimɨena eruaɨde isoide. Naimɨe dɨnena raite: —Uisɨnidɨmɨedɨcue; iadedɨ jai cɨodɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Naimɨemo jɨcanotɨmacɨ: —¿Nɨese jai birui cɨodɨo? ");
INSERT INTO huuNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Uai ote: —Jesús raillamɨe enɨrue ɨdɨaɨ fɨnuano, cue uisɨna rɨgɨnote. Cuemo llote: “Siloé railla joraibɨmo noisai”. Ie jira noisaidɨcue. Jai cɨodɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Jɨcanotɨmacɨ: —¿Nɨnomo ite nai Jesús? Naimɨe uai ote: —Uiñoñedɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Navui uisɨnidɨmɨe jai jillua mei, fariseuaɨ dɨne comɨnɨ naimɨena uitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Sábadoruimo Jesúdɨ naimɨena jillotaja jira, ");
INSERT INTO huuNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","fariseuaɨ naimɨemo jɨcanotɨmacɨ: —¿Nɨesenamona jai cɨodɨo? Uai ote: —Jesús raillamɨe enɨrue ɨdɨaɨ fɨnuano, cue uisɨna rɨgɨnote. Ie mei Siloé railla joraibɨmo noidɨcue. Iemona jai cɨodɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Fariseuaɨmona jɨaɨno raitɨmacɨ: —Sábadoruimo bimɨena Jesús jillotaja jira, caɨmona jai maɨjɨde isoide. Jesús maɨjɨa jira, Jusiñamuimona naimɨe biñede. Jɨaɨno raitɨmacɨ: —¿Nɨese jearede ra fɨnouidɨmɨedɨ uisɨnidɨmɨena jillotate? —Ie jira daje isoi comecɨaɨna facañedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ie jira navui uisɨnidɨmɨemo dane jɨcanotɨmacɨ: —Naimɨe ona jillotaja jira, ¿nɨese odɨ Jesúna raitɨo? Uai ote: —Naimɨedɨ Jusiñamui uai lloraɨma. ");
INSERT INTO huuNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Naimɨe moo, naimɨe ei iaɨmaiaɨmo nia jɨcanoñenia, judíuaɨ illaɨcomɨnɨ nai ɨima jaca cɨoiñenano ɨɨnosɨñede. Ie jira iaɨmaiaɨna uaiduanona, ");
INSERT INTO huuNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","jɨcanotɨmacɨ: —¿Bimɨedɨ omɨco jito? ¿Naimɨe jaca uisɨnino jeicɨga? ");
INSERT INTO huuNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Uai otɨiaɨmaiaɨ: —Jɨɨ, bimɨe coco jito. Jaca uisɨnino jeicɨga. Iena uiñotɨcoco. ");
INSERT INTO huuNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Nɨese jai naimɨe uisɨna cɨuana uiñoñedɨcoco. Bu naimɨena jilloitajana jɨaɨ uiñoñedɨcoco. Naimɨemo jɨcano. Naimɨedɨ jai eimɨesa. Dama ie facaina jai ñaɨte —uai otɨiaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Bie rafue nia suiñenia, judíuaɨ illaɨcomɨnɨ navui llotɨmacɨ: “Jesúdɨ caɨ Jilloitaraɨma bu lloia, caɨ ofiracomo naimɨena fo billana rairuitɨcaɨ”. Iena jacɨruillanona, ");
INSERT INTO huuNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","llotɨiaɨmaiaɨ: “Naimɨe jai eimɨesa. Naimɨemo jɨcano”. ");
INSERT INTO huuNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ie jira illaɨcomɨnɨ dane naimɨena uaiduano, llotɨmacɨ: —Jusiñamuimo iobillacɨnona feca. Jesúmo fecañeno. Naimɨe jearede rafuena fɨnouidɨmɨena uiñotɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Uai ote: —Naimɨe jearede rafuena fɨnouillana uiñoñedɨcue. Daje rafuena uiñotɨcue. Navuidɨ cɨoiraɨnidɨcue. Birui jai cɨodɨcue. Iena uiñotɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Jɨcanotɨmacɨ: —¿Nɨesede ra dɨga fɨnuamona odɨ uisɨna cɨodɨo? ¿Nɨese ona jillotate? ");
INSERT INTO huuNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Uai ote: —Omoɨmo jai llotɨcue; iadedɨ cacaiacaiñedomoɨ. ¿Bue ñellena omoɨmo dane lloitɨcue? ¿Ie llofueganona jaiacadomoɨ? ");
INSERT INTO huuNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Rɨire uai otɨmacɨ: —Naimɨe ie llofuegamɨedɨo. Caɨdɨ Moisés mɨcorɨ ie llofueganodɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Jusiñamui Moisés mɨcorɨmo jaie lluana uiñotɨcaɨ; iadedɨ bimɨena uiñoñedɨcaɨ. Naimɨe nɨnena billana jɨaɨ uiñoñedɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Nai ɨima uai ote: —Jadi, naimɨe nɨnena billana uiñoñedomoɨ; iadedɨ cuena jillotate. ");
INSERT INTO huuNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Jusiñamuidɨ jearede rafuena fɨnodɨno ñaɨa uaina cacarefiñede. Naie isoidɨno siño rafuena fɨnoñenana uiñotɨcaɨ; iadedɨ Jusiñamuidɨ naimɨena sedadɨmɨe ñaɨa uaina cacade. Ie jitailla rafuena fɨnodɨmɨe ñaɨa uaina cacade. Naie isoidɨno siño rafuena fɨnuana uiñotɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Enɨrue fɨnua facaisemona jaca buna uisɨnino jeicɨgamɨena jilloitañede. ");
INSERT INTO huuNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Jesúdɨ Jusiñamuimona biñedɨmɨedena, jaca buena fɨnonide. ");
INSERT INTO huuNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Uai otɨmacɨ: —Jamai caɨ naɨraɨ imɨedɨo. ¿Nɨese caɨna llofueitɨo? Ie jira naimacɨ ofiracomona naimɨena jino dotadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Uisɨnidɨmɨena jino dotajana fɨdɨanona, Jesús naimɨena jenode. Baillano, jɨcanote: —¿Omoɨ comɨnɨna Jilloitaraɨmana ɨɨnotɨo? ");
INSERT INTO huuNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Uai ote: —¿Bumai naimɨe? Cuemo llono, naimɨena cue ɨɨnollesa. ");
INSERT INTO huuNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesús uai ote: —Naimɨena cɨodɨo. O dɨga ñaɨte. Cue. ");
INSERT INTO huuNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Caiñɨcɨ ɨfodo raɨnadajanona, iobillacɨnona fecallena, uai ote: —Nama, jai o uaina ɨɨnotɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jesús uai ote: —Uisɨnidɨno cɨoitallena, enɨruemo bitɨcue. Jai uisɨna cɨodɨno uisɨna cɨoitañellena bitɨcue. —Iese Jesús raite; ia naimacɨ comecɨaɨna ñaɨte. Jesús “Jai maraiñedɨcaɨ” raitɨnona jillotajaɨbite. Jesús “Jai maredɨcaɨ” raitɨnomo ite jeacɨno naimacɨ uiñollena bite. ");
INSERT INTO huuNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Naimɨe ecɨmo ite fariseuaɨ iena cacajano, jɨcanotɨmacɨ: —¿Uisɨnidomoɨ caɨna raitɨo? ");
INSERT INTO huuNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesús uai ote: —Uisɨnidɨno isoi itomoɨna, omoɨmo ite jeacɨno omoɨ muidonañede; ia “Jai cɨodɨcaɨ” omoɨ railla jira, omoɨmo ite jeacɨno omoɨ muidona. Iese raite; ia naimacɨ comecɨaɨna ñaɨte. Jeacɨno naimacɨmo illana naimacɨ uiñoiacaiñena jira, iese ñaɨte. Naimacɨ jeacɨno oni dotajana jitaiñedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","2","Jesús dane llofuete: —Cue rafuena omoɨ raise uiñollena, toɨca llaudaɨaɨna ñaɨtɨcue. Llaudaɨaɨ jino uicabilla isoi, llaɨgafomo nasedo fo jaidɨmɨedɨ naie llaudaɨaɨ sedaraɨma; ia jinofebei dɨnena bitɨmɨedɨ fɨɨriraɨma. ");
INSERT INTO huuNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Llaɨgafo llaudaɨaɨ sedaraɨma fo jaillena, nase sedaraɨmadɨ nase econote. Llaudaɨaɨ naimɨe uaina uiñotɨmacɨ. Imacɨ mamecɨaɨdo uaiduamona, llaɨgafomona jino bitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Nana ie llaudaɨaɨ jino bia, naimacɨna ɨfode. Naimɨe uaina uiñuanona, naimɨena racadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Naimacɨ uiñoñegamɨena racañedɨmacɨ; iadedɨ naimɨe uaina naimacɨ uiñoñena jira, naimɨemona oni aisɨdɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Bie isoidɨcɨnona Jesús llofuete; iadedɨ naie comɨnɨ iena cacaiñedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ie jira Jesús dane llofuete: —Llaɨgafo ie nase isoidɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Damɨerie fɨɨriraɨnɨna bitɨmacɨ. Ie jira llaudaɨaɨ naimacɨ uaina cacaiñedɨmacɨ. —Iese Jesús llofuete; ia naimɨena ɨɨnotɨnona ñaɨte. Naimɨena abɨ caitadɨnona ñaɨte. Naimɨe ɨɨnotɨno naimɨena abɨ caitadɨno llogacɨnomo cacarefiñena ñaɨte. ");
INSERT INTO huuNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Nia llofuete: —Llaɨgafo isoidɨcue. Bu cue nasedo fo bia, jilloite. Llaudaɨaɨ isoi fo biite. Jino jaite. Mare guille baite isoite. —Iese llofuete; ia naimɨena ɨɨnotɨno marena illana ñaɨte. Naimɨemona naimacɨ jitailla rafuena uana ñaɨte. ");
INSERT INTO huuNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Nia llofuete: —Llaudaɨaɨna fɨɨllena, meinellena, faɨfillena, fɨɨriraɨma bite; iadedɨ comɨnɨna jaca raise itatallena, bitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Llaudaɨaɨ marena sedaraɨmadɨcue. Mare sedaraɨmadɨ ie toɨnɨaɨ facaina rɨiduanona ie abɨna faɨfite. ");
INSERT INTO huuNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Janallari bia, llaudaɨaɨ naimɨe ieñena jira, jamai maɨjɨdɨmɨedɨ, llaudaɨaɨna faɨnonocaillano, ecɨmona aisɨde. Llaudaɨaɨna janallari gaɨtaacanamona, llaudaɨaɨ tuudɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Jamai ucube oiacanano, isiruiñenano, jamai maɨjɨdɨmɨe aisɨde. ");
INSERT INTO huuNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Iese iñedɨcue. Mare sedaraɨmadɨcue. Cue llaudaɨaɨna uiñotɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Cue Moo dɨga conimana coco uiñua isoi, naimacɨ cuena jɨaɨ uiñotɨmacɨ. Cue llaudaɨaɨ facaina fiodaitɨcue. —Iese Jesús llofuete; ia naimɨena ɨɨnotɨnona ñaɨte. Jamai maɨjɨdɨmɨe isoi naimacɨna sedañede. Naimacɨna raise rɨidote. Naimacɨ facaina jɨaɨ fiodaiacade. ");
INSERT INTO huuNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Nia llofuete: —Jɨaɨe llaɨgafomo jɨaɨe llaudaɨaɨ cuemo ite. Naimacɨna jɨaɨ atɨacadɨcue. Cue uaina cacaitɨmacɨ. Ie mei danomo nana cue llaudaɨaɨ iitɨmacɨ. Naimacɨna dama sedaitɨcue. —Iese Jesús llofuete; ia jɨaɨe naɨraɨaɨmo naimɨena ɨɨnoitɨnona ñaɨte. Dajena naimacɨna sedajana ñaɨte. ");
INSERT INTO huuNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Jesús nia llofuete: —Cue jai fiodaiacanamona, cue Moo cuena isiruite. Fiodaillamona dane jilloitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Cue jitaiñenia, jaca buna cuena meineñeite. Cue jitailla jira, fiodaitɨcue. Siño uai cuemo illa jira, cue jitaillɨruimo fiodaitɨcue. Cuemo cue Moo siño uaidɨ jai illa jira, dane jilloitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Jesús iese llofuia jira, judíuaɨ illaɨcomɨnɨdɨ daje isoi comecɨaɨna facañedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Jɨaɨnodɨ: —Naimɨemo Janaba illamɨe —raitɨmacɨ—. Uaɨrico. Naimɨena cacareiacaiñedɨcaɨ —raitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Jɨaɨno raitɨmacɨ: —Bie isoidɨcɨnona Janaba illamɨe llofueñede. Janaba illamɨe uisɨnidɨmɨena jillotanide. ");
INSERT INTO huuNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Rollime facaise Jerusalémo Jesús ite. Naie facaiseconi Jusiñamui jofo ie fɨnua comecɨa rafue ite. ");
INSERT INTO huuNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Salomón mɨcorɨ fɨnotaga jofo abɨ ibɨrɨmo Jesús macarite. ");
INSERT INTO huuNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Naie facaise judíuaɨ illaɨcomɨnɨ naimɨe dɨne bitɨmacɨ. Jɨcanotɨmacɨ: —¿Nɨruido caɨmo ona lloitɨo? Odɨ caɨ Jilloitaraɨmania, caɨmo marefodo llono. ");
INSERT INTO huuNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesús uai ote: —Omoɨmo jai llotɨcue; iadedɨ ɨɨnoñedomoɨ. Cue Moo mamecɨdo cue fɨnoca rafuemona cuena uiñotomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Cue toɨca llaudaɨaɨmo omoɨ jaɨnaɨaɨñena jira, cuena ɨɨnoñedomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Cue toɨca llaudaɨaɨ cue uaina cacadɨmacɨ. Naimacɨna uiñotɨcue. Cuena racadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Naimacɨ jaca itatatɨcue. Jaca abɨna faɨfiñeitɨmacɨ. Cue anamona jaca budɨ naimacɨna baɨroñeite. ");
INSERT INTO huuNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Cue Moo naimacɨna cuemo fecade. Naimacɨdɨ jɨaɨno baɨfemo faɨtɨmacɨ. Naimɨemona jaca budɨ naimacɨna baɨronide. ");
INSERT INTO huuNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Cue Moo dɨga daje isoi comecɨna lloidɨcoco. —Iese llote; ia naimɨena ɨɨnotɨnona ñaɨte. Naie illaɨcomɨnɨ naimɨemo jaɨnaɨaɨñena jira, naimɨena ɨɨnoñedɨmacɨ. Iena Jesús ñaɨte. ");
INSERT INTO huuNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Jesús llofuiana cacajano, naie illaɨcomɨnɨ nofɨcɨna llɨnotɨmacɨ, naimɨena meinellena. ");
INSERT INTO huuNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Iena cɨuanona, Jesús llote: —Cue Moo uaido dɨga mare rafuena fɨnodɨcue. ¿Nɨe isoide rafuena cue fɨnua muidona, cuena meineiacadomoɨ? ");
INSERT INTO huuNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Uai otɨmacɨ: —Mare rafuena o fɨnua muidona, ona meineñeitɨcaɨ. Jamai ɨimadɨo. “Jusiñamuidɨcue” o railla jira, ona meineitɨcaɨ. Jusiñamui Joreñona jɨaɨ jeare ñaɨtɨo. ");
INSERT INTO huuNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","36","Jesús dɨnena uai ote: —Jaie cuegafuiaɨna jamainidɨcaɨ. Nainomo Jusiñamuidɨ naimɨe uaina cacadɨnomo jaie llote: “Omoɨdɨ jusiñamuillaɨdomoɨ”. Jusiñamui ie uaina cacadɨnomo jaie iese lloiade, ¿nɨese cuena jeare ñaɨtomoɨ? Jusiñamui cuena fetuano, cuena bene oretate. “Jusiñamui Jitodɨcue” cue railla jira, “Jusiñamui Joreñona jeare ñaɨtɨo” raitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Cue Moo isoi cue fɨnoñenia, cuena ɨɨnoñeno; ");
INSERT INTO huuNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","iadedɨ cuena omoɨ ɨɨnoiacaiñenia, cue Moo isoi cue fɨnoia, naie rafuena ɨɨno. Iemei cue Moomo cue jaɨnaɨaɨllana uiñoitomoɨ. Cuemo cue Moo jaɨnaɨaɨllana jɨaɨ uiñoitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Iena cacajano, naimɨena dane gaɨtaacadɨmacɨ; iadedɨ naimacɨmona jillode. ");
INSERT INTO huuNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ie mei Jesús Jordán railla ille ruica dɨbeimo jaide. Nainomo Juan mɨcorɨ comɨnɨna nano bautizade. Nainomo rillanona, nainomo Jesús fɨebide. ");
INSERT INTO huuNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ailluena comɨnɨ Jesús dɨne bitɨmacɨ. Coninɨna raitɨmacɨ: —Juan mɨcorɨ siño rafuena fɨnoñede; iadedɨ nana Juan mɨcorɨ Jesúna lluacɨnodɨ uanaicɨno. ");
INSERT INTO huuNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Nainomo ailluena comɨnɨdɨ Jesús naimacɨ Jilloitaraɨmana ɨɨnotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Naie facaise Betaniamo Lázaro raillamɨedɨ duide. Naimɨe mirɨñodɨ Marta, María iaɨñuaɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Naie Maríadɨ jɨaɨruido Jesús eɨllɨmo caɨmare soride rana totade. Ie mei naiñaiño ie ɨfotɨe dɨga naimɨe eɨllɨna safenaillena dote. ");
INSERT INTO huuNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Naie iaɨñuaɨ Jesús dɨne uaina oredɨaɨñuaɨ, naimɨe billena. Naimɨe jɨbuisaɨbillena llotatatɨiaɨñuaɨ: —Nama, o isiruigamɨe duide —llotatatɨiaɨñuaɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jesús naie rafuena fɨdɨano, llote: —Jamai fiodaillena naimɨe duiñede. Jusiñamui uaina siñonana comɨnɨ uiñollena, naimɨe duide. Iemona comɨnɨ dɨnena: “Ua Jusiñamui Jitodɨo” cuena raitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesúdɨ Lázarona isiruite. Ie mirɨño iaɨñuaɨna jɨaɨ isiruite; ");
INSERT INTO huuNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","iadedɨ Lázaro duillana Jesús fɨdɨano, naimɨe dɨne jaiñede. Naimɨe illanomo menarui nia fɨebide. ");
INSERT INTO huuNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ie mei ie llofueoicaiganodɨcaɨmo llote: —Judeamo abɨdo dane mai caɨ jaillɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Uai otɨcaɨ: —Llofueraɨma, judíuaɨ illaɨcomɨnɨ birui nofɨcɨna ona faɨrɨnoiacadɨmacɨ. ¿Nɨese naimacɨ dɨne dane jaitɨo? ");
INSERT INTO huuNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Uai ote: —Nagarui userede. Userenia bu macaria, raise cɨua jira, eɨcaɨtaiñede; ");
INSERT INTO huuNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","iadedɨ bu naɨona macaria, raise cɨoiñena jira, eɨcaɨtaide. —Iese llofuete; ia naimɨe rafuedo jaillena ñaɨte. Raite: —Cue rafue suicana jaite. Cue jitaille dɨnori nia llofuetɨcue. Cue rafuedo omoɨ jaia, marena jaitomoɨ. Iedo omoɨ jaiñenia, duere sefuitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Dane llote: —Lázaro jai ɨnɨde; iadedɨ naimɨena casitallena, jaitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Uai otɨcaɨ: —Nama, naimɨe jamai ɨnɨia, nia dama casite. ");
INSERT INTO huuNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Naimɨe jafaicɨ uanona ɨnɨamo comecɨaɨna facadɨcaɨ; iadedɨ Jesús naiena lloñede. Lázaro fiodaillana ñaɨte. ");
INSERT INTO huuNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ie jira Jesús caɨmo marefodo llote: —Naimɨe jai fiodaite. ");
INSERT INTO huuNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Nainomo cue iñena jira, cue siño uai omoɨ ɨɨnollena, omoɨ facaina iobidɨcue. Naimɨe dɨne mai caɨ jaillɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Caɨmona Tomás caɨmo llote: —Maiña. Naimɨe dɨga fiodaisaitɨcaɨ —llote. Tomás mamecɨ jɨaɨcɨdɨ Dídimo. Naimɨedɨ gorasa. ");
INSERT INTO huuNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Betaniamo caɨ ria, Lázaro raɨafomo jai nagaamagarui illana fɨdɨdɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Jerusalémona Betaniamo tres kilómetros dɨnori illa jira, ");
INSERT INTO huuNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","dɨga judíuaɨ illaɨcomɨnɨ eedollena, Marta iaɨñuaɨ María dɨne bitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Jesús billana Marta fɨdɨano, caɨ dɨne naɨsomo bite; iadedɨ jofomo María fɨebide. ");
INSERT INTO huuNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Jesúmo Marta llote: —Nama, o bene itɨona, cue ɨio fiodaiñede; ");
INSERT INTO huuNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","iadedɨ Jusiñamuimo buena o jɨcaia, naimɨe iena fɨnoite. Iena uiñotɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesús dɨnena uai ote: —O ɨio abɨdo jilloite. ");
INSERT INTO huuNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Naiñaiño uai ote: —Nana comɨnɨ jilloillɨruimo naimɨe jɨaɨ jilloite. Iena uiñotɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jesús uai ote: —Fiodaillamona comɨnɨ abɨaɨna Jilloitaraɨmadɨcue. Jusiñamui dɨga jaca illena, comɨnɨna itataraɨmadɨcue. Bu cuena ɨɨnuanona, fiodaiadedɨ, iemona ɨco jilloite. ");
INSERT INTO huuNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Cuena ɨɨnotɨmɨena Jusiñamui illanomo jaca illena itataitɨcue. ¿Iena ɨɨnotɨo? ");
INSERT INTO huuNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Naiñaiño uai ote: —Jɨɨ, Nama; odɨ caɨ Jilloitaraɨmadɨo. Odɨ Jusiñamui Jitodɨo. Jusiñamui dɨnena o billamo jaie ocuiridɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Iese raillanona, jofomo Marta abɨdo jaide. Ie euiñona uaiduano, anado llote: —Llofueraɨma jai ride. Ona uaidote. ");
INSERT INTO huuNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Iena cacajano, raɨre caɨ dɨne María bite. ");
INSERT INTO huuNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Marta dɨga ie ñaɨanomo Betania ecɨmo Jesús nia ite. ");
INSERT INTO huuNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Jesús dɨne María nia jaiñenia, judíuaɨ illaɨcomɨnɨdɨ Maríana nia eedotɨmacɨ. María jino jaillana cɨuano, racadɨmacɨ. “Raɨafomo eellena naiñaiño jaide” raillanona comecɨaɨna facadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","María Jesús dɨne rillano, naimɨena duenaillano, caiñɨcɨ ɨfodo raɨnadacaida, llote: —Nama, bene itɨona, niadedɨ cue ɨiodɨ fiodaiñede. ");
INSERT INTO huuNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","María eiana Jesús cɨuano, naiñaiño dɨga bitɨno eiana cɨuano, naimɨe comecɨ eo sunaite. Sunaillamona, jafaicɨna faɨte. ");
INSERT INTO huuNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Jɨcanote: —¿Nɨnomo Lázarona raɨtomoɨ? Uai otɨmacɨ: —Nama, mai jɨbuisaɨbi. ");
INSERT INTO huuNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Lázarona duenaillanona, Jesús eede. ");
INSERT INTO huuNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Iena cɨuanona, judíuaɨ illaɨcomɨnɨ dɨnena llotɨmacɨ: —Ero. Naimɨena eo isiruite. ");
INSERT INTO huuNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Jɨaɨno raitɨmacɨ: —Navui uisɨnidɨmɨena jillotate. ¿Bue ñellena bimɨena jilloitañede, naimɨe nia fiodaiñenia? ");
INSERT INTO huuNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Iena cacajanona, ie siño uai fɨnuana naimacɨ nia raise ɨɨnosɨñena jira, Jesús comecɨ dane sunaite. Oni jaillanona, raɨafomo ridɨcaɨ. Nofɨcɨ motomo ite naie raɨafo. Ifodɨ jɨaɨe nofɨcɨna ɨbaica. ");
INSERT INTO huuNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jesús llote: —Nofɨcɨ oni ñuita. Marta dɨnena naimɨe uai ote: —Nama, naimɨe abɨ jai sorirede. Nagaamagarui raɨafomo jai ite. ");
INSERT INTO huuNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jesús uai ote: —Cuena o ɨɨnoia, Jusiñamui uai siñonana uiñoitɨo. ");
INSERT INTO huuNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Iemona comɨnɨdɨ nofɨcɨna oni ñuitadɨmacɨ. Jesús monamo eruaɨllano, llote: —Moo, cue uaina o cacaja jira, iobidɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Jaca cuena cacadɨo. Iena uiñotɨcue; iadedɨ cue dɨga bene itɨno illa muidona, iese ado llotɨcue. Cuena o oretajana naimacɨ ɨɨnollena, o dɨga ado ñaɨtɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ie mei eo ado llote: —Lázaro, jino bi. ");
INSERT INTO huuNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Nai fiodaitɨmɨe nia naimɨe abɨ nana ferɨnua ra dɨga jino bite. Jesúdɨ comɨnɨmo llote: —Naimɨe abɨ ferɨnua oni suiño. —Ie jira suiñodɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ie muidona María dɨga bitɨnomona ailluena comɨnɨ Jesúna ɨɨnotɨmacɨ. Naimɨe fɨnoca rafuena cɨuanona, ɨɨnotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Jesúna ɨɨnoñedɨnomona damɨerie Jesús fɨnoca rafuena fariseuaɨ dɨne lluaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ie jira Jusiñamui dɨga nanoca ñaɨraɨnɨ, fariseuaɨ dɨga, danomo ofidɨmacɨ. Jesús rafuena siadotɨmacɨ: —¿Nɨese naimɨena nɨbaɨitɨcaɨ? Dɨga siño rafuena ua fɨnocabide. ");
INSERT INTO huuNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Naimɨena nɨese caɨ nɨbaɨñenia, nana comɨnɨ naimɨena ɨɨnoitɨmacɨ. Nana comɨnɨ naimɨe dɨbeimo jaia, naimacɨ illaɨmana naimɨe jaillana jitaitɨmacɨ. Iemei romanos soldaduaɨ biitɨmacɨ. Jusiñamui jofona judaɨaɨbitɨmacɨ. Caɨ naɨraɨaɨna jɨaɨ fuidoitɨmacɨ. Iena jitaiñedɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Naie facaise nanoca Jusiñamui dɨga ñaɨraɨmana Caifás illamona, naimacɨmo llote: —Naimɨe rafuena raise uiñoñedomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Iese caɨ naɨraɨmo suiñellena, damɨe caɨ naɨraɨ facaina fiodaitena, mare. Iena nɨbaɨ nia raise uiñoñedomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ie comecɨna dama facajano, iese lloñede; ia Jusiñamui dɨga nanoca ñaɨraɨmana naimɨe illamona, Jusiñamui naimɨena biena llotatate: —Jesúdɨ caɨ comɨnɨ facaina fiodaite. ");
INSERT INTO huuNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Caɨ comɨnɨ facaina dama fiodaiñede; iadedɨ nana Jusiñamuina ɨɨnoitɨnona facaina fiodaite. Dɨga naɨraɨaɨmo itɨmacɨ; iadedɨ naimɨemo dajena nana naimacɨ duillena, naimɨe fiodaite. ");
INSERT INTO huuNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Caifás lluana naimacɨ cacajamona, judíuaɨ illaɨcomɨnɨ comecɨaɨna nia facadɨmacɨ, naimɨena meinellena. ");
INSERT INTO huuNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ie jira Jesús judíuaɨ illaɨcomɨnɨ illa motodo marefodo macariñede. Jofue iñena dofodo jaidɨcaɨ. Efraín railla naɨraɨ dɨne ridɨcaɨ. Nainomo dɨga irui itɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Pascua railla rafue iaɨre iacana jira, ailluena comɨnɨ Jerusalémo naimacɨ naɨraɨaɨmona jaidɨmacɨ. Rafue nia taɨneñenia, naimacɨmo ite rafue oni jaillena, caɨ einamacɨ llua isoi fɨnodɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","57","Jusiñamui dɨga nanoca ñaɨraɨnɨdɨ fariseuaɨ dɨga navui ñaɨtɨmacɨ: —Bu Jesúna cɨoia, naimɨena caɨ gaɨtallena, caɨmo llono. Rafuemo bitɨno illamona, Jesúna jenodɨmacɨ. Jusiñamui jofomo naimacɨ ia, coninɨmo jɨcanododɨmacɨ: —¿Nɨese comecɨaɨna facadomoɨ? ¿Jesús bene biite? Caɨ illaɨcomɨnɨ llua jira, nɨbaɨ jai biñeite. Illaɨcomɨnɨ lluana fɨdɨano, naimɨe biñeite. ");
INSERT INTO huuNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Pascua railla rafue rilledɨ seis dɨgarui fɨebidemo, Jesús caɨ dɨga Betaniamo jaide. Betania Lázaro illano. Jesús Lázarona fiodaillamona navui jillotate. ");
INSERT INTO huuNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Jesúri iobillano, Lázaro ie guille rafuena fɨnode. Marta guille baɨ jonega. Jesús dɨga guitɨno motomo Lázaro ite. Jesús llofueoicaiganodɨcaɨdɨ jɨaɨ motomo guitɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Iemei Maríadɨ nardomona fɨnoca caɨmare soride ra Jesús eɨllɨmo totade. Daje botella raifi totade. Safenaillena naiñaiño ɨfotɨe dɨga ie eɨllɨna dote. Nai caɨmare soride ra eo raifide. Daje botella ite. Iemona nana jofo jeraidɨ soride. ");
INSERT INTO huuNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Caɨmona Judas Iscariote mɨcorɨna mamecɨredɨmɨe ite. Jesúna gaɨtataitɨmɨe. Llote: ");
INSERT INTO huuNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—¿Bue ñellena bie soride radɨ fecañede, ucubena ollena? Fecacadena, trescientos dɨgarui maɨjɨa ucube dɨese raifide. Ie mei nai ucube dueredɨnomo fecadena, mare —llote. ");
INSERT INTO huuNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Dueredɨnona naimɨe duenaiñede; iadedɨ naimɨe caɨ ucubena sedade. Naimɨedɨ fɨɨriraɨma. Naie ucubemona fɨɨuilla jira, iese naimɨe llote. ");
INSERT INTO huuNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jesús uai ote: —Dama ite. Bie soride ra naiñaiño jai eenoga cue fiodaillɨrui iena. ");
INSERT INTO huuNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Dueredɨno omoɨ dɨga jaca iitɨmacɨ; iadedɨ omoɨ dɨga jaca iñeitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Lázaro jofomo Jesús illana ailluena caɨ illaɨcomɨnɨ fɨdɨano, bitɨmacɨ. Navui fiodaillamona Lázarona Jesús jillotaja jira, Jesúna dama cɨoiacaiñedɨmacɨ; iadedɨ Lázarona jɨaɨ cɨoiacadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ie jira Jusiñamui dɨga nanoca ñaɨraɨnɨdɨ Lázarona jɨaɨ meinellemo comecɨaɨna facadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Lázaro muidona ailluena judíuaɨ illaɨcomɨnɨ naimacɨ illa dɨbei faɨnonocaida, Jesúna ɨɨnotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Pascua railla rafue illa jira, ailluena comɨnɨ Jerusalémo itɨmacɨ. Egiptomona caɨ jaiagaɨ jillobillana comecɨllena naie rafue ite. Jesús Lázaro dɨga guillarui ie areruido Jesús Jerusalémo billana naie comɨnɨ fɨdɨdɨmacɨ. Fiodaillamona Lázarona Jesús navui jilloitajana dɨga comɨnɨ cɨodɨmacɨ. Iena llocana uitɨmacɨ. Ie jira ailluena comɨnɨ Jesús dɨne jaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Raforona uanona, naimɨena feiñollena, naimɨe uicomo jaidɨmacɨ. Ado cuiriisɨte: —¡Caɨ Jilloitaraɨma billa! ¡Jusiñamui mamecɨdo bitɨmɨe eo mare! ¡Caɨ Illaɨma eo mare! —cuiriisɨte. ");
INSERT INTO huuNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesúdɨ aillɨ baiga burrito emododo jaide. Jusiñamui facaina lloraɨma mɨcorɨ jaie llua isoi jaide. Jaie llote: ");
INSERT INTO huuNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Jerusalén imacɨ, jacɨnaiñeno. O Illaɨma burrito emododo biite”. ");
INSERT INTO huuNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Naie facaise bie rafuemo comecɨaɨna facañedɨcaɨ; iadedɨ Jesús jillua mei, bie rafuena comecɨtɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","18","Lázarona Jesús jillotaja jira, ailluena comɨnɨ Jesús dɨne jaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Iena cɨuano, fariseuaɨ coninɨri ñaɨtɨmacɨ: —Jaca buena birui fɨnoñedɨcaɨ. Ailluena comɨnɨ Jesús dɨbeimo jai jaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Judíuaɨñedɨno Jusiñamuina sedallena, pascua railla rafuemo jɨaɨ bitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Naie facaise caɨ dɨne bitɨmacɨ. Felipedɨ Galilea ie Betsaida naɨraɨ imɨena jira, Felipe dɨne bitɨmacɨ. Felipemo llotɨmacɨ: —Jesúna cɨoiacadɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Felipe iena Andrémo llote. Ie mei Jesúmo lluaidɨaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jesús uai ote: —Monamona bitɨcue; ia jai cue fiodaille facaise ride. Comɨnɨ cue uaidɨ siñonana uiñua facaise jai ride. ");
INSERT INTO huuNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Jɨaɨe rafuedo iena lloitɨcue. Ido rilla mei, naie ido sɨcoñenia, buena iñede; iadedɨ sɨcuamona, ailluena llɨsilladɨ iite. Ie isoide. Cue fiodaiñenia, jaca bu jillobiñeite. Cue fiodaillemona ailluena comɨnɨ jillobitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ie abɨmo ite rafuemo comecɨna dama bu facaia, ja muidomo faɨfite; ia cuemo ite rafuemo comecɨna bu facaia, monamo jaca iite. ");
INSERT INTO huuNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Cuena bu raise sedaacania, cue rafuedo naimɨe jaite. Cue llofuegamɨena naimɨe jaillamona, cuemona fueoite. Iemona cue Moodɨ naimɨena caɨmare itataite. ");
INSERT INTO huuNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Cue comecɨ jai rucaicuerite; iadedɨ, ¿nɨese raitɨcue? Raiñeitɨcue: “Moo, cue fiodaillemona cuena jillote”. Fiodaillena bitɨcue. Ie jira raitɨcue: ");
INSERT INTO huuNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","“Moo, comɨnɨna o uai siñonana uiñota”. Ieconi monamona Jusiñamui llote: —Jai iena fɨnodɨcue. Dane iena fɨnoitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Jusiñamui ñaɨana nainomo ite comɨnɨ raise cacaiñenano, raitɨmacɨ: —Mona gurude. Jɨaɨno raitɨmacɨ: —Naimɨemo Jusiñamui jaɨenicɨ llote. ");
INSERT INTO huuNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jesús uai ote: —Cue facaina naie lluana cacaiñedomoɨ; iadedɨ omoɨ facaina iena cacadomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Cuena uiñoñedɨno duere sefuilla facaise ja taɨneite. Taɨfe anamo comɨnɨ jai itɨmacɨ; ia Jusiñamui Taɨfena ja anafefitaite. ");
INSERT INTO huuNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Cruzmo cue fiodaia, naimacɨna jilloitallena, ailluena comɨnɨna cue dɨbeimo itataitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","—Naimɨe fiodaillana naimacɨ uiñollena, iese llote. ");
INSERT INTO huuNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Naie comɨnɨ uai otɨmacɨ: —Jusiñamui facaina lloraɨnɨ mɨcorɨaɨ jaie cuega: “Caɨ Jilloitaraɨma jaca fiodaiñeite”. ¿Nɨese raitɨo: “Jusiñamuimona bitɨcue; ia fiodaitɨcue”? ");
INSERT INTO huuNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jesús dane uai ote: —Cue llofuia dɨnori omoɨ comecɨaɨna nia llɨgaiñotɨcue. Cue lluamo cacarei. Omoɨ dɨga cue nia ia, cue llofuiamo cacarei. Jitɨredemo bu macaria, naɨ illana raise uiñoñede. Ie isoide. Jeacɨno anamo itɨnodɨ jitɨredɨnomo itɨmacɨ isoidɨmacɨ. Uanaicɨnona uiñoñedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Jeacɨno anamona omoɨ jilloillena, cue llofuia uaido omoɨ comecɨaɨna birui llɨgaiñotɨcue. Cue uaina ɨɨno, cue comɨnɨna omoɨ jaillena. Bie llua mei, Jesús oni jaillano, naimacɨmona reirite. ");
INSERT INTO huuNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Jesús dɨga siño rafuena fɨnode; iadedɨ ailluena comɨnɨ: “Naimɨedɨ caɨ Jilloitaraɨma” raillana nia ɨɨnosɨñede. ");
INSERT INTO huuNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Iemona Isaías mɨcorɨ jaie cuegafuiaɨ suide. Naimɨe jaie cuega: Jusiñamui, caɨ lluacɨnona cacadɨmacɨ. O siño uaido o fɨnoca rafuena jɨaɨ cɨodɨmacɨ; iadedɨ ɨɨnoñedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","40","Isaías mɨcorɨ dane cuega: Naimacɨ cɨoi raillano, Jusiñamui naimacɨna uisɨnidɨno isoi itatate. Naimacɨ comecɨaɨmona abɨna uiñoi raillano, naimacɨ comecɨaɨna feitate. Naimɨena ɨɨnoi raillano, iese naimacɨna jai itatate. Ie jira jai ɨɨnonidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Jusiñamui ie ebirede rafuena naimɨe cɨuamona, Isaías mɨcorɨ iena llote. Isaías mɨcorɨ Jesúna llote. ");
INSERT INTO huuNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Isaías mɨcorɨ iese llote; iadedɨ ailluena judíuaɨ illaɨcomɨnɨ Jesús uaina ɨɨnotɨmacɨ. Fariseuaɨna jacɨruillanona, iena janotɨmacɨ. Naimacɨ ofiracomona naimacɨna jino dotajana jacɨruitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Comɨnɨ naimacɨna iobitajana naimacɨ eo jitailla jira, dotajana jitaiñedɨmacɨ. Jusiñamuimo ite iobillacɨnona raise oiacaiñedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Naie facaise Jesús eo ado llote: —Cuena ɨɨnotɨmɨe cuena oretatɨmɨena jɨaɨ jai ɨɨnote. ");
INSERT INTO huuNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Cuena cɨodɨmɨe cuena oretatɨmɨena jɨaɨ cɨode isoide. ");
INSERT INTO huuNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Comɨnɨ comecɨaɨna llɨgaiñollena bitɨcue. Ie muidona naga cuena ɨɨnotɨmɨe jitɨredɨnomo jai iñede. Jeacɨno anamo jai iñede. ");
INSERT INTO huuNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Cue uaina cacajano ɨɨnoñedɨmɨemo juez isoi birui lloñedɨcue. Comɨnɨna duere fɨnollena, biñedɨcue; iadedɨ naimacɨ jeacɨnomona naimacɨna jilloitallena bitɨcue; ");
INSERT INTO huuNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","ia cuena bu ɨɨnoñenia, cue uaina naimɨe ɨɨnoñenia, ja muidona faɨfite. Cue uaina naimɨe ɨɨnoñellemona, nana naimɨena ɨɨnoñedɨno janafefillɨruimo Jusiñamui naimɨena ɨco duere fɨnoite. Cuena jitaiñedɨmɨe, cue uaina jitaiñedɨmɨe comɨnɨ janafefillɨruimo janafefite. ");
INSERT INTO huuNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Dama cue comecɨ facaja uaido lloñedɨcue. Cue Moo cuena oretaja muidona, cue Moo cuemo lloga uaido llotɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Cue Moo lloga uaidɨ naimɨe dɨbeimo comɨnɨna jaca itatate. Iena uiñotɨcue. Ie jira cue Moo cuemo lloga uaina jaca llotɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Pascua railla rafue riacana areruido ia, Jesús ie Moo dɨne abɨdo jaiacanana uiñote. Naimacɨ dɨga naimɨe nia ia, ie comɨnɨna jaca eo isiruite. ");
INSERT INTO huuNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Jesúna gaɨtatallena, naie facaise Taɨfedɨ Judas Iscariote mɨcorɨ comecɨna feidote. Judas mɨcorɨ Simón jito. ");
INSERT INTO huuNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jesúdɨ ie uai ie Moomona feiñuana uiñote. Ie Moo dɨnena billana uiñote. Ie Moo dɨne abɨdo jaillena jɨaɨ uiñote. ");
INSERT INTO huuNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Nairuido Jesús caɨ dɨga guite. Guilla meinoconi, Jesús a naidacaida ie abɨmo ite ɨniroina duiñode. Abɨ dora dɨga ie moillɨna ferɨnote. ");
INSERT INTO huuNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Janorede nogomo jɨnuina totaja mei, caɨ eɨllɨaɨna jocode. Safenaillena, ie dora dɨga dote. ");
INSERT INTO huuNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Simón Pedro dɨne naimɨe ria, Pedro jɨcanote: —Nama, ¿cue eɨllɨna jɨaɨ jocoitɨo? ");
INSERT INTO huuNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesús uai ote: —Cue fɨnoca rafuena birui uiñoñedɨo; iadedɨ jɨaɨruido uiñoitɨo. ");
INSERT INTO huuNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pedro uai ote: —Cue eɨllɨna jaca jocoñeitɨo. Jesús uai ote: —O eɨllɨna cue jocoñenia, cue facaina iñeitɨo. ");
INSERT INTO huuNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Pedro uai ote: —Nama, dama cue eɨllɨna jocoñeno. O facaina raise cue illena, cue onollɨ, cue ɨfogɨ dɨga, jɨaɨ joco. ");
INSERT INTO huuNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jesús uai ote: —Nana o abɨna jocoñeitɨcue. Da o eɨllɨna jocoitɨcue. Jai noidɨmɨe mena icaiño noiñede. Ie abɨ jai jeanide. Dama ie eɨllɨna nɨbaɨ dane jocoacade. Omoɨ comecɨaɨ jɨaɨ jai jeanide; iadedɨ omoɨmona damɨe comecɨ nia jearede. ");
INSERT INTO huuNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Naimɨena gaɨtataiacadɨmɨena naimɨe uiñua jira, iese llote. ");
INSERT INTO huuNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Caɨ eɨllɨaɨna jocua mei, ie ɨniroi dane jɨtaja mei, dane ana raɨnadajanona, caɨmo jɨcanote: —Omoɨmo aillɨ cue fɨnoca rafuena nɨbaɨ raise cacaiñedomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Cuena “Caɨ Nama” raicabitomoɨ. “Caɨ llofueraɨma” cuena jɨaɨ raicabitomoɨ. Iese cuena omoɨ raia, mare. Ie isoi itɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Omoɨ Namadɨcue. Omoɨ llofueraɨmadɨcue; iadedɨ omoɨ mullaɨma isoi itɨcuedena, omoɨ eɨllɨaɨna jai jocodɨcue. Omoɨ jamai bue isoidɨnomona, omoɨ eɨllɨaɨna danɨrie jocua. ");
INSERT INTO huuNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Cuemona fueo. Abɨ ɨedoñeno cue isoi omoɨ jai. Cue afemo iñedomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Uanai omoɨmo llotɨcue. Mullaɨma ie nama afemo iñede. Oretagamɨe ie oretatɨmɨe afemo iñede. Ie isoide. Cue afemo iñedomoɨ; ia omoɨ eɨllɨaɨna jocodɨcue. “Jɨaɨmɨe afemo itɨcaɨ” raillanomo comecɨna omoɨ facañeno. ");
INSERT INTO huuNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Bicɨno omoɨ uiñuamona, iese omoɨ fɨnoia, caɨmare iitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Nana omoɨna iese ñaɨñedɨcue. Nana cue fetocanona uiñotɨcue. David mɨcorɨ jaie llote: “Cue dɨga guitɨnomona damɨe cuena enoidɨmɨe ite”. ");
INSERT INTO huuNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Bie nia suiñenia, iena jai llotɨcue. Iena cuemo suilla mei, David mɨcorɨ llogacɨno raise ɨɨnoitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Uanai llotɨcue. Cue oretagamɨena bu feiñoia, cuena jɨaɨ feiñote. Bu cuena feiñoia, cuena oretatɨmɨena jɨaɨ feiñote. ");
INSERT INTO huuNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jesús iese llua mei, ie comecɨ sunaite. Llote: —Uanai llotɨcue. Omoɨmona damɨe cuena gaɨtataite. ");
INSERT INTO huuNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Caɨmona ¿nɨmɨe naimɨena gaɨtataite? raillanona, comecɨna facajano, coninɨmo eroridɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Cuena Jesús eo gaɨa jira, Jesús abɨmo itɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Cuena uaiduanona, Pedro cuemo llote: —“¿Bu ona gaɨtataite?” Jesúmo jɨcano. ");
INSERT INTO huuNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ie jira Jesúmo jɨcanotɨcue: —Nama, ¿bu ona gaɨtataite? ");
INSERT INTO huuNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesús uai ote: —Bie llomenicona mutajanona, naimɨemo fecaitɨcue —raite. Mutaja mei, Judas mɨcorɨmo fecade. Naimɨe mɨcorɨdɨ Simón Iscariote jito. ");
INSERT INTO huuNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Llomenicona guilla meinoconi, Taɨfe anamo Judas mɨcorɨ illamona, Taɨfe naimɨe comecɨna feidote. Jesús naimɨemo llote: —O fɨnoacaga rana raɨre fɨno. ");
INSERT INTO huuNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Jesús Judas mɨcorɨmo lluana raise uiñoñedɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judas mɨcorɨ ucubena sedaja jira, jɨaɨno comecɨna facade: “ ‘Caɨ jitaille guille ɨbarisai’ Jesús naimɨemo llote”. Iese lloñenia, “ ‘Janore ucube dueredɨnomo feca’ nɨbaɨ naimɨemo llote”. ");
INSERT INTO huuNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Guilla mei, Judas mɨcorɨ jino jaide. Naie facaise jai jitɨreficaide. ");
INSERT INTO huuNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas mɨcorɨ jailla mei, Jesús llote: —Jusiñamuimona billanona, ɨimana jaidɨcue; ia cue fiodaille facaise jai ride. Cue fiodaillemona comɨnɨdɨ Jusiñamui uai siñonana uiñoitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Iemona Jusiñamui uai siñonana comɨnɨ uiñoia, Jusiñamuidɨ comɨnɨna cue siño Jitona jɨaɨ uiñotaite. Iese ja fɨnoite. ");
INSERT INTO huuNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Cue comɨnɨ, dallu omoɨ dɨga bene itɨcue. Jaitɨcue. Cue dɨga iacanitomoɨ. Judíuaɨ illaɨcomɨnɨmo navui cue llua isoi, omoɨmo ja lloitɨcue. Cue jaillɨnomo nia jaiñeitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ie jira jɨaɨe rafuena omoɨmo ja lloitɨcue. Omoɨna cue isiruilla isoi, coninɨna omoɨ isirui. ");
INSERT INTO huuNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Coninɨna omoɨ isiruillamona, jɨaɨe comɨnɨdɨ cue comɨnɨdomoɨna uiñoitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Naie facaise Pedro naimɨemo jɨcanote: —Nama, ¿nɨne jaitɨo? Jesús uai ote: —Cue jaillɨnomo cue dɨga ja jaiñeitɨo. Jɨaɨruido jaitɨo. ");
INSERT INTO huuNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pedro uai ote: —Nama, ¿bue ñellena ja jaiñetɨcue? O jitaia, o facaina ja fiodaitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesús dɨnena uai ote: —Cue facaina fiodaiacadɨo. Uanai omo llotɨcue. Nia monaiñenia, ɨitava nia ñaɨñenia, dacaiño amani cuena janoitɨosa. ");
INSERT INTO huuNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Jesús ie llofueoicaiganodɨcaɨna nia llofuete: —Rucaicueriñeno uri i. Jusiñamuina ɨɨnocana jai. Cuena jɨaɨ ɨɨnocana jai. ");
INSERT INTO huuNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Cue Moo illanomo dɨga comɨnɨ illanuaɨ ite. Iese iñedena, omoɨmo jai llotɨcue. Omoɨ illɨnuaɨna raise fɨnollena, nainomo jaitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Fuiduanona, dane abɨdo biitɨcue. Omoɨna cue dɨne uillena, cue dɨne omoɨ illena, biitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Cue jaillɨnona birui uiñotomoɨ. Nainomo omoɨ rillena jɨaɨ uiñotomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomás uai ote: —Nama, o jaillɨnona uiñoñedɨcaɨ. ¿Nɨese nainomo riitɨcaɨ? ");
INSERT INTO huuNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesús uai ote: —Omoɨ naɨso isoidɨcue. Uanaicɨnona llotɨcue. Cue Moo dɨbeimo comɨnɨna jaca itatatɨcue. Cue Moo dɨne joide naɨso isoidɨcue. Jaca dasode cue Moomo duide naɨdɨ. Cue Moo dɨne o ria, cuena ɨɨno. ");
INSERT INTO huuNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Cuena uiñotomoɨna, cue Moona jɨaɨ uiñotomoɨ. Biruidemona naimɨena uiñoitomoɨ. Naimɨena jai cɨodomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Felipe uai ote: —Nama, o Moona caɨmo acata. Iemo jai macaɨbaite. ");
INSERT INTO huuNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesús uai ote: —Felipe, are omoɨ dɨga itɨcue; iadedɨ cuena nia uiñoñedomoɨ. Cuena cɨodɨmɨe cue Moona jɨaɨ jai cɨode isoide. ¿Nɨese llotɨo: “O Moona caɨmo acata”? Cue Moona jai cɨodɨo isoidɨo. ");
INSERT INTO huuNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Cue Moo dɨga daajedɨcoco. Iena nia ɨɨnoñedɨo. Cue lluadɨ cue Moo uai. Cue lluadɨ cue comecɨ iuaiñede. Cue motodo naimɨe maɨjɨde. ");
INSERT INTO huuNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Cue Moo dɨga daajedɨcocona ɨɨno. Cue uaina omoɨ ɨɨnoñenia, siño rafuena cue fɨnua jira, cuena ɨɨno. ");
INSERT INTO huuNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Jesús nia llofuete: —Uanai llotɨcue. Cuena omoɨ ɨɨnoia, cue fɨnoca rafuena jɨaɨ fɨnoitomoɨ. Cue Moo dɨne cue jailla jira, cue Moo Joreñona omoɨ dɨne cue oretaja mei, cue fɨnua baɨfemo fɨnoitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Cue Moo uai siñonana omoɨ uiñollena, buena cue dɨbeido cue Moomo omoɨ jɨcaia, nana iena fɨnoitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Cue dɨbeido omoɨ jɨcaia, iena fɨnoitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Cuena omoɨ isiruia, cue llogacɨnuaɨna ɨɨnoitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ie Joreño omoɨmo fecallena cue Moomo jɨɨitɨcue. Naie Joreñodɨ omoɨna canoite. Omoɨ dɨga jaca iite. ");
INSERT INTO huuNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Uanaicɨnona llocabite. Naimɨena naimacɨ uiñoñena jira, cuena ɨɨnoñedɨno naimɨena feiñonidɨmacɨ; iadedɨ naimɨe omoɨ dɨga illa jira, naimɨena uiñotomoɨ. Omoɨ dɨga jaca iite. ");
INSERT INTO huuNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Omoɨna faɨnonocaiñeitɨcue; ia dane biitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Nano nɨgarui illanona, cuena ɨɨnoñedɨno cuena nia cɨoitɨmacɨ. Ie mei cuena cɨoiñeitɨmacɨ; iadedɨ fiodaillamona cue jillua mei, cuena nia cɨoitomoɨ. Cue jaca illa jira, jɨaɨ jaca iitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Fiodaillamona cue jillua mei, cue Moomo cue duillana raise uiñoitomoɨ. Cuemo omoɨ duillana jɨaɨ raise uiñoitomoɨ. Omoɨmo cue duillana jɨaɨ raise uiñoitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Cue llogacɨnuaɨna omoɨ isiruia, cuena isiruitomoɨ. Ie jira cue Moodɨ omoɨna jɨaɨ isiruite. Omoɨna jɨaɨ isiruitɨcue. Omoɨna cuena uiñotaitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Iscariotena mamecɨreñede Judas naimɨemo jɨcanote: —Nama, ¿bue ñellena danɨ caɨna ona uiñotaitɨo; iadedɨ jɨaɨe comɨnɨna ona uiñotañeitɨo? ");
INSERT INTO huuNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesús uai ote: —Cuena isiruitɨnona cue rafuena uiñotadɨcue. Bu cuena isiruia, cue llogacɨnuaɨna ɨɨnoite. Cue Moo naimɨena isiruite. Iemona naimɨena nabaitɨcoco. ");
INSERT INTO huuNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Bu cuena isiruiñenia, cue llogacɨnuaɨna ɨɨnoñede. Cue llogacɨnodɨ cuejeñede. Cue Moo ie. Naimɨe cuena oretate. ");
INSERT INTO huuNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Omoɨ dɨga nia cue illamona, bie llogacɨnuaɨ omoɨmo jai llotɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Cue Moodɨ omoɨna canollena, naga rafuena omoɨna llofuellena, cue facaina ie Joreñona omoɨmo oretaite. Omoɨna nana omoɨmo llogacɨnuaɨna comecɨtaite. ");
INSERT INTO huuNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Cue Moo dɨne jaitɨcue; iadedɨ omoɨ comecɨaɨna uri itataitɨcue. Cuena ɨɨnoñedɨno omoɨ comecɨaɨna iese itatanidɨmacɨ. Jarire iñeno. Jacɨruiñeno. ");
INSERT INTO huuNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Aillɨ cue lluana cacadomoɨ: “Cue Moo dɨne jaitɨcue; iadedɨ dane biitɨcue”. Cue Moo dɨne cue jailla jira, cuena omoɨ isiruia, cueri iobitomoɨ. Cue Moo cue afemo ite. ");
INSERT INTO huuNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Bie rafue cuemo nia suiñenia, uicodo omoɨmo iena jai llotɨcue. Naie suia, cuena faɨnonocaiñeno omoɨ jaillena jitaidɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Omoɨ dɨga are nia ñaɨñeitɨcue. Cuena ɨɨnoñedɨno anamo itɨmɨe cuena jai duere fɨnoacade. Taɨfena ñaɨtɨcue. Naimɨe anamo iñedɨcue; ");
INSERT INTO huuNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","iadedɨ cue Moona cue isiruillana cuena ɨɨnoñedɨno uiñollena, cue Moo cuemo llua isoi, fɨnoitɨcue. Mai caɨ jaillɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Jesús nia llofuete: —Cue dɨbeimo marena omoɨ illena omoɨ raise uiñollena, jɨaɨe rafuedo iena llofueitɨcue. Uvas railla ua riaradɨcue. Cue Moodɨ uvas railla riara sedaraɨma. ");
INSERT INTO huuNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Cue amena igaillaɨdomoɨ. Llɨsiñede igai cue Moo cugaica. Eo llɨsillena, naga llɨside igaina janore muido jaigaica. Ie isoide. ");
INSERT INTO huuNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Cue llogacɨnuaɨdo jaillamona, jai jaigaica isoidomoɨ. Iemona omoɨ comecɨaɨ jai jeanide. ");
INSERT INTO huuNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Cuena nabai. Ona jɨaɨ nabaitɨcue. Naie amenamo jai duiñena jira, daje dɨbegaise jaitaca igaidɨ jai llɨsiñede. Ie isoide. Cuena omoɨ nabaicabiñenia, llɨsiñede igai isoidomoɨ. Ie jira cuena nabai. ");
INSERT INTO huuNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Uvas railla riaradɨcue. Cue amena igaillaɨdomoɨ. Cuemo omoɨ duiadedɨ, omoɨmo cue duiadedɨ, eo llɨside isoidomoɨ; iadedɨ cuemo omoɨ duiñenia, jaca llɨsiñede isoidomoɨ. Cuemo omoɨ duiñenia, cue jitailla isoi mare rafuena jaca fɨnoñeitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Jai duide igaillaɨ safenailla mei, maraiñena jira, jobaillena, danomo ofitatɨcaɨ. Cuemo duiñedɨmɨe jai duide igai isoide. Jusiñamuimona duere sefuite. ");
INSERT INTO huuNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Cuena omoɨ nabaia, cue uaina omoɨ feitañenia, omoɨ jitaille rana jɨca. Ie mei feiñoitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Eo llɨside omoɨ isoia, cue Moo iobide. Iese omoɨ ia, ua cue comɨnɨdomoɨ. —Iese Jesús llofuete; ia naimɨe dɨbeimo naimacɨ raise illena ñaɨte. Mare rafuena naimacɨ fɨnocana jaillena ñaɨte. ");
INSERT INTO huuNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Nia llofuete: —Cuena cue Moo isiruilla isoi, omoɨna isiruitɨcue. Cuena nabaicabi. ");
INSERT INTO huuNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Cue Moo llogacɨnuaɨna cue ɨɨnuamona, naimɨe isiruillacɨno anamo itɨcue. Cue Moo llogacɨnuaɨna omoɨ ɨɨnuamona, cue isiruillacɨno anamo itomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Cue isoi omoɨ comecɨaɨ eo caɨmarellena, bicɨnuaɨ omoɨmo llotɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","’Dane bie rafuena lloitɨcue. Omoɨna cue isiruilla isoi, coninɨna omoɨ isirui. ");
INSERT INTO huuNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Naimacɨ o isiruillamona, o nabaiñɨaɨ facaina o fiodaia, naimacɨna eo ua isiruitɨo. ");
INSERT INTO huuNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Cue llogacɨnuaɨna omoɨ ɨɨnoia, cuena nabaidomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Omoɨna “Cue mullaɨaɨdomoɨ” jaca raiñedɨcue; iadedɨ omoɨna “Cue nabaiñɨaɨdomoɨ” birui raitɨcue. Mullaɨaɨ imacɨ patrón fɨnoca rafuena uiñoñedɨmacɨ. Ie jira nana cue Moomona cue cacaja rafuena omoɨmo jai llotɨcue. Ie jira nana cue rafuena jai uiñotomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Cuena fetoñedomoɨ; iadedɨ omoɨna fetodɨcue. Omoɨ llɨside isoicabillana omoɨmo jai llotɨcue. Ie mei buena cue mamecɨdo cue Moomo omoɨ jɨcaia, omoɨmo fecaite. ");
INSERT INTO huuNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Coninɨna omoɨ isiruillena jai llotɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Jesús nia llofuete: —Cuena ɨɨnoñedɨno omoɨna enoia, nano cuena jai enoidɨmacɨ. Iena uiñotomoɨ. Omoɨna nia enoiñenia, cuena jai enoidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Naimacɨmo jaɨnaɨaɨdomoɨna, omoɨna isiruitɨmacɨ; iadedɨ naimacɨmo omoɨ jaɨnaɨaɨñena jira, omoɨna cue fetua jira, omoɨna enoidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Omoɨmo jai llotɨcue. Illaɨma duere sefuia, naimɨe anamo itɨno jɨaɨ duere sefuidɨmacɨ. Ie isoide. Cuena comɨnɨ duere fɨnua isoi, omoɨna jɨaɨ duere fɨnoitɨmacɨ. Cue llofuiacɨnona naimacɨ ɨɨnua isoi, omoɨ llofuiacɨno jɨaɨ ɨɨnoitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Cuena oretatɨmɨena naimacɨ uiñoñena jira, cue muidona iese fɨnoitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Naimacɨmo ite jeacɨnona naimacɨmo lloñedɨcuena, naimacɨmo ite jeacɨnona uiñoñedɨmacɨ. Cue rafuena naimacɨ cacajamona, naimacɨmo ite jeacɨnona jai uiñotɨmacɨ. Naimacɨmo jeacɨno nia ia, naimacɨ muidona. ");
INSERT INTO huuNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Cuena enoidɨmɨedɨ cue Moona jɨaɨ enoide. ");
INSERT INTO huuNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Eo siño rafuena naimacɨ motomo fɨnodɨcue. Buna cue isoi jaca fɨnoñede. Iena fɨnoñedɨcuena, naimacɨmo ite jeacɨnona uiñoñedɨmacɨ. Cue siño fɨnoca rafuena jai cɨodɨmacɨ. Ie jira cuena enoidɨmacɨ. Cue Moona jɨaɨ enoidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Naimacɨna David mɨcorɨ jaie llote: “Naimacɨmo buena fɨnoñedɨcue; ia cuena enoidɨmacɨ”. Naie cuegafuiaɨ jai suide. ");
INSERT INTO huuNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’Cue Moo ie Joreño omoɨmo oretaite. Ie Joreño omoɨna canoite. Omoɨna uanaicɨnona uiñotaite. ");
INSERT INTO huuNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Cue nano lluaruimona cue dɨga omoɨ illa jira, cue facaisena jɨaɨ raise lloitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Jesús nia llofuete: —Danomo abɨdo omoɨ jaiñellena, cue uaina omoɨ faɨnonocaiñellena, bicɨnuaɨ omoɨmo ja lloitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Omoɨ ofiracomona illaɨcomɨnɨ omoɨna dotaitɨmacɨ. Jɨaɨruido omoɨna meiniamona: “Jai Jusiñamuina marena sedadɨcaɨ”, comecɨaɨna facaitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Cuena naimacɨ ɨɨnoñena jira, cue Moona jɨaɨ naimacɨ ɨɨnoñena jira, iena fɨnoitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Bie rafue omoɨmo suia, naie facaise cue lluana omoɨ comecɨllena, omoɨmo birui llotɨcue. Omoɨ dɨga cue illa jira, navui iena lloñedɨcue; iadedɨ omoɨmona birui oni jaitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Jesús nia llofuete: —Cuena oretatɨmɨe dɨne ja jaitɨcue; iadedɨ omoɨmona buna: “¿Nɨne jaitɨo?” cuemo jaca nia jɨcanoñede. ");
INSERT INTO huuNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Omoɨmo bie rafue cue llua jira, omoɨ comecɨaɨ eo sure ite. Ie jira cue jaillɨnona jɨcanoñedomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Uanai llotɨcue. Cue jaia, mare. Cue jaiñenia, omoɨna canoraɨma omoɨ dɨne biñeite. Cue jaia, omoɨ dɨne naimɨena oretaitɨcue. Jusiñamui Joreñodɨ omoɨ canoraɨma. ");
INSERT INTO huuNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Naimɨe bia, cuena ɨɨnoñedɨnona naimacɨmo ite jeacɨnona uiñotaite. Naimɨedɨ Jusiñamui marena naimacɨ illana jitaillana uiñotaite. Naimɨedɨ Jusiñamui naimacɨna duere fɨnollena jɨaɨ uiñotaite. ");
INSERT INTO huuNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Cuena naimacɨ ɨɨnoñenia, naimacɨna naimacɨmo jeacɨno nia illana uiñotaite. ");
INSERT INTO huuNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Cue Moo dɨne abɨdo cue jaillɨnona, cuena cɨoiñeitɨmacɨ; ia iemona Jusiñamui Joreño cue uaina siñonana uiñotaite. ");
INSERT INTO huuNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Fiodaillemona jilloitɨcue. Iemona cuena ɨɨnoñedɨno anamo itɨmɨedɨ cue Moo janafefillacɨno anamo iite. Taɨfena ñaɨtɨcue. Cue fɨnoca rafue muidona, cue Moo Joreñodɨ comɨnɨna, cue Moo Joreñodɨ comɨnɨna naie janafefillemona jilluana uiñotaite. ");
INSERT INTO huuNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Dɨga rafue omoɨmo nia lloiacadɨcue; iadedɨ jai rairaɨfaidomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Jusiñamui Joreño bia, omoɨmo nana uanaicɨnuaɨna llofueite. Dama ie facaina llofueñeite; iadedɨ ie cacajacɨnodo llofueite. Jɨaɨruido suille rafuena llofueite. ");
INSERT INTO huuNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Omoɨna cue rafuena uiñotaite. Ie jira cuena iobitaite. Nana cue Moomo ite uaidɨ cueje. ");
INSERT INTO huuNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ie jira bie rafuena llotɨcue. Jusiñamui Joreño omoɨna cue rafuena raise uiñotaite. ");
INSERT INTO huuNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Jesús nia llofuete: —Dallu illanona cuena cɨoiñeitomoɨ. Ie mei dallu illanona, cuena dane cɨoitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ie llofueoicaiganodɨcaɨmona damɨerie danɨ coninɨmo jɨcanodosɨte: —¿Nɨese caɨmo llote: “Dallu illanona, cuena cɨoiñeitomoɨ. Ie mei dallu illanona, cuena dane cɨoitomoɨ. Cue Moo dɨne jaitɨcue”? ");
INSERT INTO huuNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Buena caɨmo llote? Raise cacaiñedɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Caɨ jɨcanuana Jesús uiñuanona, naimɨe jɨcanote: —¿Cue lluana raise uiñoiacadomoɨ? ");
INSERT INTO huuNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Cuemo suille rafue suia, eo eeitomoɨ; iadedɨ cuena ɨɨnoñedɨno eo iobitɨmacɨ. Sunaitomoɨ; iadedɨ jɨaɨruido caɨmare iitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Jɨaɨe uaido iena lloitɨcue. Rɨño jocoacania, naiñaiño jigɨco isirede. Jocua mei, naiñaiño urue jeicɨamona, isirenadɨ feibicaide. Iemona jai iobide. ");
INSERT INTO huuNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ie isoide. Ja sunaitomoɨ; iadedɨ dane omoɨna cɨoitɨcue. Fiodaillamona cue jillua mei, dane cuena cɨoitomoɨ. Ie mei caɨmare iitomoɨ. Iemona omoɨna buna sure itatañeite. ");
INSERT INTO huuNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Nairuimo cuemo buena jɨcañeno; iadedɨ cue Moomo jɨca. Ie mei cue muidona naimɨe omoɨmo fecaite. ");
INSERT INTO huuNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Cue mamecɨdo cue Moomo buena jaca nia jɨcañedomoɨ. Jɨca. Ie mei feiñoitomoɨ, omoɨ comecɨ eo caɨmare illena. ");
INSERT INTO huuNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Jesús nia llofuete: —Jɨaɨe uaido bicɨnona omoɨmo jai llotɨcue. Jɨaɨruido iese lloñeitɨcue. Omoɨna cue Moona marefodo lloitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Nairuimo cue Moomo omoɨ facaina jɨcañeitɨcue. Cue mamecɨdo cue Moomo omoɨ jitaillacɨnona danɨ jɨcaitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Omoɨna naimɨe isiruillamona, omoɨmo fecajite. Cuena omoɨ isiruilla jira, cue Moomona cue billana omoɨ ɨɨnua jira, cue Moo omoɨna isiruite. ");
INSERT INTO huuNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Cue Moomona enɨruemo bitɨcue. Naimɨe dɨne abɨdo jaitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Llotɨcaɨ: —Jai marefodo caɨmo llotɨo. O uaina meidocana jai uiñedɨo. ");
INSERT INTO huuNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Nana rafuena o uiñuana uiñotɨcaɨ. Caɨ comecɨaɨmo itɨcɨnona o uiñuamona, caɨna raise uiñotɨo. Iemona Jusiñamuimona o billana jai ɨɨnotɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesús uai ote: —Cuena jai ɨɨnotomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Jɨaɨruido, ua birui, oni tuuitomoɨ. Nagamɨiaɨ jofomo omoɨ jailla mei, dama ifoconi fɨebitɨcue; iadedɨ dama iñeitɨcue. Cue Moo cue dɨga iite. ");
INSERT INTO huuNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Cuena omoɨ ɨɨnuano, omoɨ uri illena, omoɨmo bie llotɨcue. Enɨruemo omoɨ ia, jaca duere sefuitomoɨ; iadedɨ omoɨ comecɨaɨna ocuiño. Omoɨna duere fɨnodɨnona jai cue emodofilla jira, omoɨ comecɨaɨna ocuiño. Naimacɨ baɨfemo faɨtɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jesús bicɨnona llua mei, monamo eruaɨllano, jɨɨde: —Moo, cue fiodaiacanarui jai ride. Cue uai siñonana uiñota. Iemei o uai siñonana jɨaɨ uiñotaitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Nana comɨnɨ afemo cuena jai itatatɨo. Ɨimana cue jaillamona, nana comɨnɨ afemo cuena jai itatatɨo. Comɨnɨ comecɨaɨ iuaina o meidotajamona, cue fiodaillamona, ailluena comɨnɨ o dɨga jaca iitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ona nanoca Jusiñamuina uiñoitɨmacɨ. Jai cuena o oretajana jɨaɨ uiñoitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ailluena siño rafuena jai fɨnodɨcue. Nana o cuemo lloga rafuena cue fɨnuamona, bene ona jai iobitadɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ore Moo, enɨrue nia iñena facaiseconi o dɨga itɨcue. Illaɨma isoi o ecɨmo dane ebire iacadɨcue. Dane cuemo ine, daje isoi coco illesa. ");
INSERT INTO huuNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Comɨnɨ comecɨaɨ iuaina o meidotajamona, naimacɨna jai llofuecabitɨcue. O anamo naimacɨ illamona, omo ite rafuena llofuecabitɨcue. Iemona o rafuena ɨɨnocana jaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Nana cuemo ite rafue omona feiñotɨcue. Iena jai uiñotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Nana cuemo o llogacɨnuaɨna naimacɨmo jai llotɨcue. Jai ɨɨnotɨmacɨ. Omona cue billana jɨaɨ jai ɨɨnotɨmacɨ. Cuena o oretajana jɨaɨ ɨɨnotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Naimacɨ facaina birui jɨɨdɨcue. Naimacɨna cuena ɨɨnotadɨo. Ie jira omo jai duidɨmacɨ. Ona ɨɨnoñedɨno facaina birui jɨɨñedɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Nana o dɨbeimo itɨnodɨ cueje. Nana cue dɨbeimo itɨnodɨ oɨe. Nana naimacɨri iobidɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Bene enɨruemo fɨebitɨmacɨ. Enɨruemona monamo jaitɨcue. O dɨne abɨdo jaitɨcue. Ore Moo, jeacɨno naimacɨ fɨnoi raillano, o anamo o uai dɨga naimacɨna seda. Coco comecɨ lloilla isoi, naimacɨ daje isoi comecɨaɨna lloita. ");
INSERT INTO huuNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Naimacɨ dɨga nia cue ia, naimacɨna cue anamo sedadɨcue. Naimacɨna raise sedadɨcue, naimacɨ feirai raillano. Naimacɨ motomona dama Judas feiraite. Jusiñamui lloraɨma mɨcorɨ cuegafuiaɨ suillena, naimɨe ua faɨfite. ");
INSERT INTO huuNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","O dɨne ja jaitɨcue. Cue isoi naimacɨ comecɨaɨ eo caɨmare illena, naimacɨmo ailluena rafuena jai llotɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","O llogacɨnuaɨna jai llotɨcue. Ona ɨɨnoñedɨnomo naimacɨ jaɨnaɨaɨñena jira, ona ɨɨnoñedɨno naimacɨna enoidɨmacɨ. Ona ɨɨnoñedɨnomo jɨaɨ jaɨnaɨaɨñedɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Enɨruemona birui o naimacɨna uana jɨcanoñedɨcue; iadedɨ Taɨfemona naimacɨna o sedajana birui jɨcanotɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ona ɨɨnoñedɨnomo jaɨnaɨaɨñedɨmacɨ. Ona ɨɨnoñedɨnomo jɨaɨ jaɨnaɨaɨñedɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","O llogacɨnuaɨdo naimacɨna marena itata. O llogacɨnuaɨdɨ uanaicɨno. O jitaillacɨnona naimacɨ fɨnollena, o uai naimacɨ comecɨaɨmo raise itata. ");
INSERT INTO huuNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Bene cuena o oretaja isoi, ona ɨɨnoñedɨno dɨne naimacɨna oretatɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Uanaicɨnona naimacɨ uiñuamona, naimacɨ comecɨaɨ marebicaillena, cuena ɨɨnotɨno facaina fiodaiacadɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Bimacɨna birui dane jɨɨñedɨcue; iadedɨ bimacɨ cue rafuena ɨco lloia, jɨaɨe comɨnɨ cuena ɨɨnoitɨmacɨ. Cuena ɨco ɨɨnoitɨno facaina birui jɨaɨ jɨɨdɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Daajedɨcoco. Coco illa isoi, naimacɨ comecɨaɨna daje isoi lloillena, nana naimacɨ facaina jɨɨdɨcue. Daje isoi comecɨaɨ lloillamona, cuena nia ɨɨnoñedɨnodɨ ɨɨnoitɨmacɨ. Iemona cuena o oretajana ɨɨnoitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Cuemo o iga uaidɨ ebirede. Naimacɨ comecɨaɨ lloillena, naimacɨmo o uai jai cue iga. ");
INSERT INTO huuNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Naimacɨri dajedɨcaɨ. O dɨga daajedɨcoco. Naimacɨ comecɨaɨ daje isoi lloillana jitaidɨcue. Iemona cuena ɨɨnoñedɨno bene cuena o oretajana uiñoitɨmacɨ. Cuena o isiruilla isoi, naimacɨna o isiruillana jɨaɨ uiñoitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Ore Moo, naimacɨ cue dɨne illena jitaidɨcue. Enɨrue nia iñenia, illaɨma isoi o ecɨmo ebire jaie itɨcue. Dane ie isoi ebire birui cue ia, naimacɨ cuena cɨuana jitaidɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Ore Moo, mareuidɨmɨedɨo. Jɨaɨe comɨnɨ ona uiñoñedɨmacɨ; iadedɨ ona uiñotɨcue. Cue llofueoicaiganodɨ o cuena oretajana jai uiñotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Naimacɨmo ona jai llotɨcue. O cuena isiruilla isoi coninɨna naimacɨ isiruillena, naimacɨmo nia lloitɨcue —jɨɨde. ");
INSERT INTO huuNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jɨɨa mei, Jesús ie llofueoicaiganodɨcaɨ dɨga, Cedrón railla iconɨ enefebeimo ruica aceituna railla riaraɨaɨ illanomo naɨona jaide. ");
INSERT INTO huuNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Jesús caɨ dɨga nainomo jaisoilla jira, Judas mɨcorɨ naie illanona jɨaɨ uiñote. Jesúna gaɨtatallena nainomo Judas jaide. ");
INSERT INTO huuNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Soldaduaɨ dɨga policías dɨga jaide. Naimacɨna ɨfode. Jusiñamui dɨga nanoca ñaɨraɨnɨ naimacɨna oredɨmacɨ. Fariseuaɨ naimacɨna jɨaɨ oredɨmacɨ. Soldaduaɨdɨ lamparínɨaɨri bitɨmacɨ. Reɨnaɨaɨri jɨaɨ bitɨmacɨ. Sɨdanɨaɨri jɨaɨ bitɨmacɨ. Judas naimacɨna ɨfode. ");
INSERT INTO huuNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jesúdɨ nana naimɨemo suille rafue uiñuanona, naimacɨ dɨne billano, jɨcanote: —¿Buna jenodomoɨ? ");
INSERT INTO huuNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","6","Uai otɨmacɨ: —Nazaret ie Jesús. Jesús uai ote: —Imɨedɨcue. Iena cacajano, jacɨnaillamona, abɨdo ñaɨjillamona, enɨruemo uaidɨmacɨ. Jesúna gaɨtatallena, Judas mɨcorɨ naimacɨ dɨga ite. ");
INSERT INTO huuNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Jesús dane jɨcanote: —¿Buna jenodomoɨ? Uai otɨmacɨ: —Nazaret ie Jesús. ");
INSERT INTO huuNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jesús uai ote: —Omoɨmo jai llotɨcue: “Imɨedɨcue”. Cuena omoɨ jenoia, cue dɨga itɨno oni jaillena rairuiñeno. ");
INSERT INTO huuNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Naimɨe ie Moomo como lloga uai suillena, iese llote. Iese ie Moomo como llote: “Cuena o ɨɨnotaganomona jaca buna faɨfiñedɨcue”. ");
INSERT INTO huuNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ie daacaiño Simón Pedrodɨ ie lloebɨ llɨnocaida, Jusiñamui dɨga nanoca ñaɨraɨma mullaɨma jefona jaɨbonote. Naie mullaɨma mamecɨdɨ Malco. ");
INSERT INTO huuNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Iena cɨuanona, Jesús Pedromo llote: —O lloebɨna eeno. Cue Moo jitailla isoi, fiodaitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ie mei soldaduaɨ, imacɨ capitán dɨga, judíuaɨ imacɨ policías dɨga, Jesúna gaɨtajano, naimɨena maɨtɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Anás dɨne nano uitɨmacɨ. Anásdɨ Caifás jɨfai. Caifásdɨ Jusiñamui dɨga nanoca ñaɨraɨma. ");
INSERT INTO huuNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Navui Caifás judíuaɨ illaɨcomɨnɨmo llote: “Damɨe nana caɨ comɨnɨ facaina fiodaitena, mare”. ");
INSERT INTO huuNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simón Pedro Jesús jɨnafo racade. Jɨaɨ racadɨcue. Cuena Jusiñamui dɨga nanoca ñaɨraɨma uiñua jira, ie naɨraɨbɨrɨmo Jesús dɨga jaidɨcue; ");
INSERT INTO huuNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","iadedɨ Pedro nasemo fɨebicaide. Ie jira jino abɨdo jaillano, Pedro fo atɨllena, nasena sedaraɨñomo jɨcanotɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Naiñaiño Pedromo llote: —Jesús llofueoicaigano imɨedɨo. Pedro uai ote: —Ieñedɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Rosirena jira, naie jofo mullaɨaɨ, policías dɨga, coocɨ dɨga irai bonodɨmacɨ. Agaillena irai ecɨmo naidaidɨmacɨ. Agaillena Pedro naimacɨ motomo jɨaɨ ite. ");
INSERT INTO huuNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ie facaise Anás Jesúmo ie llofueoicaiganodɨcaɨna jɨcanote. Ie llofuiacɨnuaɨna jɨaɨ jɨcanote. ");
INSERT INTO huuNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesús dɨnena uai ote: —Nana comɨnɨmo marefodo llotɨcue. Omoɨ ofiracuaɨmo jaca llofuecabitɨcue. Jusiñamui jofomo jɨaɨ jaca llofuecabitɨcue. Nainomo nana o comɨnɨ oficabidomoɨ. Bainino buena jaca lloñedɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Bue ñellena birui cuemo jɨcanotɨo? Cuena cacadɨnomo iena jɨcano. Cue llofuiana uiñotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Iese Jesús llua jira, daje policía naimɨe uiecona butade. Jesúmo jɨcanote: —¿Bue ñellena iese uai otɨo? ");
INSERT INTO huuNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesús dɨnena naie uai ote: —Naimɨe uai jeare otɨcuena, cuemo llono. Jeare oñedɨcuemo, ¿bue ñellena cuena butadɨo? ");
INSERT INTO huuNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Jesús uai oñede. Iemei Anásdɨ Caifás jofomo Jesús maɨanona orede. ");
INSERT INTO huuNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ie facaise Pedro irai ecɨmo nia agaide. Nainomo itɨno naimɨemo llote: —Jesús llofueoicaigano imɨedɨo. Pedro janote: —Ieñedɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Naie facaise daje mullaɨma Pedromo llote: —Aceitunas railla riaraɨaɨ illanomo ona cɨodɨcue —llote. Jusúna soldaduaɨ gaɨtaja facaiseconi Pedro naie mullaɨma ie come jefona aillɨ jaɨbonote, soldaduaɨ Jesúna gaɨtaja ie daacaiño. ");
INSERT INTO huuNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pedro dane janote. Ieconi ɨitava ñaɨte. ");
INSERT INTO huuNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ie mei Caifás jofomona gobernador jofomo Jesúna jitɨramo uitɨmacɨ. Naie facaise gobernadordɨ Pilato. Naimɨedɨ judíuaɨñedɨmɨe. Naimacɨ einamacɨ rairuilla jira, judíuaɨñedɨmɨe jofomo naie facaise fo jaiñedɨmacɨ. Fo jaiadedɨ, pascua railla rafue guilledɨ guiñega. ");
INSERT INTO huuNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ie jira Pilato jino bite. Naimacɨmo jɨcanote: —¿Nɨe isoide rafue muidona llogɨdotomoɨ? ");
INSERT INTO huuNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Uai otɨmacɨ: —Bimɨe maraiñede rafue fɨnoñedena, o dɨne naimɨena atɨñedɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilato llote: —Naimɨena uiño. Omoɨ einamacɨ llogacɨnuaɨdo naimɨena duere fɨno. Uai otɨmacɨ: —Come meinellena caɨmona rairuidomoɨ. Naimɨe coraɨana jitaidɨcaɨ —llotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Navui Jesúdɨ: “Cuena cruzmo coraɨitɨmacɨ” llote. Naie lluacɨno jai suisaide. ");
INSERT INTO huuNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilato fo abɨdo jaillano, Jesúna uaiduano, naimɨemo llote: —Judíuaɨ illaɨma raillamɨedɨo. ");
INSERT INTO huuNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesús dɨnena jɨcanote: —¿O comecɨna dama iese facajano llotɨo? Iese comecɨna o facañenia, jɨaɨmɨe omo lloga. ");
INSERT INTO huuNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilato uai ote: —Judío imɨeñedɨcue. O rafue raise uiñoñedɨcue. Omoɨ comɨnɨ cuemo ona fecadɨmacɨ. Jusiñamui dɨga nanoca ñaɨraɨnɨ cuemo jɨaɨ fecadɨmacɨ. ¿Nɨe isoide maraiñede rafuena fɨnodɨo? ");
INSERT INTO huuNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesús uai ote: —Enɨruemo comɨnɨna sedañedɨcue. Judíuaɨ illaɨcomɨnɨ cuena gaɨtañellena, enɨruemo comɨnɨna sedadɨcuedena, cue comɨnɨ cue facaina fuiridɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilato uai ote: —Ie jira odɨ illaɨmadɨo. Jesús uai ote: —Jaca railla. Uanaicɨno llollena, jeicɨgacue. Nana uanaicɨnona jitaidɨno cue lluana cacadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilatodɨ Jesús uaina uaitajamona, raite: —¿Nɨe uai naidɨ uaina? Ie mei dane jino billano, comɨnɨmo llote: —Jaca nɨcɨno naimɨemo iñede. ");
INSERT INTO huuNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Pilato nia llote: —Naga año pascua railla rafue illa facaise, damɨe cárcelmona jino ollena, cuemo jɨcanuaɨbisoidomoɨ. Bie año omoɨ jitaia, omoɨ illaɨma raillamɨena marena oretaitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Comɨnɨ dɨnena cuiriidɨmacɨ: —Dama ite. Bimɨena jitaiñedɨcaɨ. Barrabásna cárcelmona marena jino oreta. —Iese cuiriidɨmacɨ. Barrabásdɨ fɨɨriraɨma. ");
INSERT INTO huuNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ie mei Pilato Jesúna oni uillanona, naimɨena sechedotade. ");
INSERT INTO huuNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Jɨfanodosɨllena, soldaduaɨ eecuaɨmona fɨnoca nuicɨraina naimɨe ɨfogɨmo jɨtadɨmacɨ. Jiduirede ɨniroina jɨtatajano raitɨmacɨ: ");
INSERT INTO huuNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","—Judíuaɨ illaɨmadɨo. —Iemei ie uiecona bucoɨdɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilato dane jino billano, raite: —Naimɨe omoɨ dɨne jino ja biite. Naimɨemo nɨcɨnodɨ iñede —raite. ");
INSERT INTO huuNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ie facaise Jesús jino bite. Eecuaɨmona fɨnoca nuicɨraina jɨtaca. Jiduirede ɨniroina jɨtaca. Pilato naimacɨmo llote: —Jadi, naimɨe. ");
INSERT INTO huuNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Jusiñamui dɨga nanoca ñaɨraɨnɨdɨ, jɨaɨe illaɨcomɨnɨ dɨga, naimɨena cɨuano, cuiriidɨmacɨ: —Naimɨena coraɨ. Pilato llote: —Naimɨemo nɨcɨnodɨ iñede; ia oni uillanona, naimɨena omoɨ coraɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Uai otɨmacɨ: —Moisés mɨcorɨ jaie cuega: “Bu Jusiñamuina jeare ñaɨanona, fiodailla”. “Jusiñamui Jitodɨcue” naimɨe railla jira, naimɨe fiodailla. Naimɨe Jusiñamui Jitona abɨna caitadɨmɨe. Caɨmona naimɨedɨ maraiñede rafue jai fɨnode. ");
INSERT INTO huuNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","“Naimɨedɨ Jusiñamui Jito” comɨnɨ raillana Pilato cacajano, eo jacɨnaite. ");
INSERT INTO huuNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Jesúna dane fo uite. Jesúdɨ Jusiñamui Jitona naimɨe raise uiñollena, Jesúmo jɨcanote: —¿Nɨnena bitɨo? Jesús uai oñede. ");
INSERT INTO huuNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ie jira Pilato dane jɨcanote: —¿Bue ñellena cue uaina oiacaiñedɨo? Uai cuemo ite, o marena oretallena. Uai cuemo ite, ona coraɨtallena. ");
INSERT INTO huuNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jesús uai ote: —O anamo Jusiñamui cuena itataja jira, o uai ite, cuemo llollena. Ie jira omo cuena fecadɨno o baɨfemo jeacɨno fɨnodɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ie facaimona Pilato Jesús marena jino oretaiacade; iadedɨ judíuaɨ illaɨcomɨnɨ dɨnena cuiriisɨte: —Bimɨe o jino marena oretaia, caɨ nanoca illaɨma ie nabaiñedɨo. “Illaɨmadɨcue” Jesús lluamona, caɨ nanoca illaɨma dɨbeimo naimɨedɨ iñede. Caɨ nanoca illaɨmadɨ César. ");
INSERT INTO huuNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Comɨnɨ lluana cacajano, Pilato Jesúna jino atɨde. Ie comɨnɨmo lloranomo raɨde. Naie illano nofɨnina mamecɨrede. Judíuaɨ uaido Gabatana mamecɨrede. ");
INSERT INTO huuNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Pascua rafue guilla fɨnoraruimo jitoma naidai illanona, Pilato dɨnena llote: —Jadi, omoɨ illaɨma. ");
INSERT INTO huuNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Iemona comɨnɨdɨ cuiriisɨte: —¡Naimɨe oni uillanona, naimɨena meine! ¡Naimɨena coraɨ! Pilato jɨcanote: —¿Bue ñellena omoɨ illaɨmana coraɨitɨcue? Jusiñamui dɨga nanoca ñaɨraɨnɨ uai otɨmacɨ: —Caɨ illaɨmadɨ César. Jɨaɨe illaɨmadɨ caɨmo iñede. Jaca dallaɨmade caɨ illaɨmadɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ie mei Pilato naimacɨmo naimɨena fecade, coraɨllena. Pilato llua jira, Jesúna uitɨmacɨ coraɨllena. ");
INSERT INTO huuNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Jesúdɨ ie cruzna rocaoicaida sonode. Ɨfocoraɨna eruaɨlla mamecɨrede illanomo jaidɨmacɨ. Judíuaɨ uaido naie illano Gólgotana mamecɨrede. ");
INSERT INTO huuNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Nainomo naimɨena coraɨdɨmacɨ. Naimɨe abɨmo menamɨe coraɨca. Damɨe Jesús nabeimo. Jɨaɨmɨe jarɨfebeimo. ");
INSERT INTO huuNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Cruzmo jonellena, Pilato rabɨcɨmo cuetatate: “Nazaret ie Jesús. Judíuaɨ Illaɨma”. ");
INSERT INTO huuNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Judíuaɨ uaido cuega. Romanos comɨnɨ uaido jɨaɨ cuega. Griego uaido jɨaɨ cuega. Jesús coraɨano Jerusalén ianori illa jira, ailluena comɨnɨ iena cɨodɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Iena cɨuamona, naie rabɨcɨna meidollena, Jusiñamui dɨga nanoca ñaɨraɨnɨ Pilatomo llotɨmacɨ: —“Judíuaɨ Illaɨma” raillano jai cuetatatɨo. Iena meiduana jitaidɨcaɨ. Bimɨe dɨnena raisoide: “Judíuaɨ Illaɨmadɨcue” raillanona, o cuetatajana jitaidɨcaɨ ");
INSERT INTO huuNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilato uai ote: —Jai cuetatatɨcue. Jɨaɨe rabɨcɨmo dane cuetatañeitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Jesúna coraɨa mei, soldaduaɨ naimɨe ɨniroi uanona, naga soldado dɨgamɨe jonega ɨniroi. Nagaamaga soldaduaɨ ite. Ie camisa fɨebide. Naie daje jamai nigaroi. ");
INSERT INTO huuNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ie jira danɨ coninɨri ñaɨtɨmacɨ: —Bie camisa cuaranoñeitɨcaɨ, danɨ caɨ fecallena. Mai. Conima jabomaitɨcaɨ, iena ollena. —Iese fɨnuano Jusiñamuina lloraɨma mɨcorɨ cuegafuiaɨ suide. Jaie cuega: “Cue ɨniroi danɨ naimacɨmo fecaitɨmacɨ; iadedɨ cue camisa ollena, conima jabomaitɨmacɨ”. Iese fɨnodɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Cruz abɨmo Jesús ei, ie euiño dɨga ite. Cleofas aɨdɨ ite. Naiñaiño mamecɨ María. María Magdalena jɨaɨ ite. ");
INSERT INTO huuNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jesús ie eina cɨode. Cuena naiñaiño ecɨmo jɨaɨ cɨode. Cuena eo gaɨde. Ie jira ie eimo llote: —Jadi, o jito isoi itɨmɨe anamo iitɨo. ");
INSERT INTO huuNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Cuemo llote: —Jadi, o ei isoidɨñaiño anamo iitɨo. Naie dacaiño naiñaiñona cue jofomo uillanona, naiñaiñona sedadɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ie mei Jesús nana rafue jai fuillana uiñuano, llote: —Jiroacadɨcue. —Iese lluanona, Jusiñamuina lloraɨma mɨcorɨ jaie cuegafuiaɨ jai suide. ");
INSERT INTO huuNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Nainomo llerojɨmo vino ite. Radosimo fibecode rana joniano, vinomo faɨte. Iemei Jesúmo fecade jaronollena. ");
INSERT INTO huuNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Iena jaronuano, Jesús llote: —Cue maɨjɨa jai fuite. Jai macaɨbaite. —Ie ɨfogɨ ana jɨtadacaida, fiodaite. ");
INSERT INTO huuNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Pascua railla rafue guille fɨnuarui illa jira, judíuaɨ illaɨcomɨnɨ Pilato dɨne jaidɨmacɨ. Raɨre fiodaillena, coraɨcano ɨdaɨaɨna uellullena naimɨemo jɨcanuaidɨmacɨ. Sábado rafue ie nairui nia illanona, sábadorui jai raɨre taɨneacana jira, coraɨcano cruzmo sábadoruimo illana jitaiñedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Soldaduaɨ jaillano, Jesús ecɨmo coraɨca iaɨmaiaɨ ɨdaɨaɨna uellude. ");
INSERT INTO huuNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Jesús dɨne billano, naimɨe jai fiodaillana cɨodɨmacɨ. Ie jira naimɨe ɨdaɨaɨna uelluñedɨmacɨ; ");
INSERT INTO huuNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","iadedɨ daje soldado Jesús cɨraigɨconi sɨda dɨga ducɨde. Naifo dɨaide. Naifomona jɨnui jɨaɨ bite. ");
INSERT INTO huuNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Nana iena cɨodɨcue. Uanai llotɨcue. Omoɨ ɨɨnollena, iena llotɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Soldaduaɨ iese fɨnuamona, jaie cuegafuiaɨ jai suide. Jaie Jesúna cuega: “Naimɨe illaicɨna taɨnoñeitɨmacɨ”. ");
INSERT INTO huuNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Jɨaɨ jaie cuega: “Judíuaɨ dɨnena naimacɨ ducɨtagamɨemo ɨco eruaɨtɨmacɨ”. ");
INSERT INTO huuNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Naie facaise Pilato dɨne José raillamɨe jaide. Cruzmona Jesús abɨ oni ollena, Pilatomo jɨcanuaide. Josédɨ Arimatea naɨraɨ imɨe. Pilato faɨriote. Ie jira José Jesús abɨ ana uanona, iena oni uite. Judíuaɨ illaɨcomɨnɨna naimɨe jacɨruillanona, Jesúna bainino ɨɨnote. ");
INSERT INTO huuNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nicodemo jɨaɨ bite. Siorede rana atɨde. Mirra áloe dɨga jai tamiano atɨde. Nɨbaɨ treinta kilos atɨde. Naimɨedɨ Jesús dɨne naɨona navui bite. ");
INSERT INTO huuNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","José, Nicodemo dɨga, Jesús abɨna useroina ferɨnotɨiaɨmaiaɨ. Naimacɨ comɨnɨ fɨnouilla isoi, naie siorede radɨ ɨniroimo jonega. ");
INSERT INTO huuNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Amenaɨaɨ iaɨre illanomo Jesúdɨ coraɨca. Nainomo nofɨcɨ ie raɨafodɨ ite. Nia buna naifomo raɨñenafo. ");
INSERT INTO huuNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Naifo iaɨre illa jira, sábadorui jai riacana jira, jɨaɨe raɨafo jenollena abɨ juanina jira, nainomo naimɨena jonetɨiaɨmaiaɨ. Nofɨcɨ dɨga raɨafo raise ɨbailla mei, jofomo jaidɨiaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Domingo jitɨramo nia monaiñenia, raɨafomo María Magdalena jaide. Raɨafo ɨbailla nofɨcɨ oni joillana cɨode. Jesús abɨna cɨoiñede. ");
INSERT INTO huuNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ie jira aisɨcana Pedrona jenuaide. Cuena jɨaɨ jenuaide. Baillano, llote: —Caɨ illaɨcomɨnɨ caɨ Nama abɨna raɨafomona otɨmacɨ. Naimɨena jonianona uiñoñedɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ie mei raɨafomo jaidɨcoco. ");
INSERT INTO huuNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Aisɨcana jaidɨcoco; iadedɨ rɨire cue aisɨcana jailla jira, nano ridɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ana bɨtadacaida, fo erodatɨcuemo, useroi joillana cɨodɨcue; iadedɨ fo jaiñedɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ie mei Simón Pedro rillano, fo jaide. Useroi joillana jɨaɨ cɨode. ");
INSERT INTO huuNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Ie ɨfogɨmo ferɨnoga ɨniroi eneno illana cɨode. Raise nacuana cɨode. ");
INSERT INTO huuNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Iemei jɨaɨ fo jaidɨcue. Ɨniroina cɨuamona, Jesús jai jilluana ɨɨnotɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Jaie cuegafuiaɨ llote: “Fiodaillamona jilloite”. Naie cuegafuiaɨna como raise ɨɨnotɨcoco. ");
INSERT INTO huuNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ie mei jofomo jaidɨcoco. ");
INSERT INTO huuNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Raɨafomo abɨdo billano, coco jailla mei, nainomo María fɨebide. Eede. Ana bɨtadacaida, fo erodatemo, ");
INSERT INTO huuNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Jusiñamuimona mena jaɨenicɨ jai billana cɨode. Userede ɨniroi jɨtadɨaɨmaiaɨ. Jesúna navui jonianomo ana raɨdɨaɨmaiaɨ. Damɨe ɨfogɨ dɨbeimo raɨde. Jɨaɨmɨe eɨllɨ dɨbeimo raɨde. ");
INSERT INTO huuNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Naiñaiñomo jɨcanotɨiaɨmaiaɨ: —¿Bue ñellena eedɨo? Naiñaiño uai ote: —Cue Namana bu oni uillanona, naimɨena jonianona jai uiñoñedɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Naie facaise jɨnafo dɨne erocaillanona, Jesúna cɨode; iadedɨ naimɨena uiñoñede. ");
INSERT INTO huuNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Naiñaiño comecɨna facade; “Naimɨedɨ bie illano sedaraɨma”. Jesús naiñaiñomo jɨcanote: —¿Bue ñellena eedɨo? ¿Bu jenodɨo? Naiñaiño uai ote: —Jesúna o uia, naimɨe jonianona cuemo llono. Ie mei naimɨena oni uitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jesús dɨnena uai ote: —¡María! Naimɨe dɨne naiñaiño como raise dobaicaide. Judíuaɨ uaido llote: —¡Raboni! —Naie uai oni dobaiñuamona: “Llofueraɨma”. ");
INSERT INTO huuNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesús uai ote: —Cuena llɨɨnoñeno cuena faɨcai. Cue Moo dɨne nia a jaiñedɨcue. Cue amatɨaɨ dɨne mai jaillanona, cue rafuena lluai. Cue Moo dɨne jaitɨcue. Naimɨedɨ cue Jusiñamui. Naimɨe jɨaɨ omoɨ Moo. Jɨaɨ omoɨ Jusiñamui. ");
INSERT INTO huuNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ie jira María Magdalena Jesús llofueoicaiganodɨcaɨmo lluaɨbite: —Caɨ Namana jai cɨodɨcue. —Iemei caɨmo naimɨe naiñaiñomo lluana llote. ");
INSERT INTO huuNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Domingo naɨo Jesús llofueoicaiganodɨcaɨ jofomo ofidɨcaɨ. Judíuaɨ illaɨcomɨnɨna caɨ jacɨruillamona, nasiaɨ nana caɨ ɨbaica. Nase econoñeno ieconi Jesús caɨ motomo billanona, caɨna uaiduano, llote: —Uri omoɨ i. ");
INSERT INTO huuNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ie onollɨna acatate. Ie cɨraigɨna jɨaɨ acatate. Caɨ Namana jai caɨ cɨuari eo iobidɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jesús dane llote: —Uri omoɨ i. Cue Moo cuena oretaja isoi cue rafuena llollena, omoɨna oretaitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ie facaise caɨna firaiñuanona, raite: —Jusiñamui Joreñona omoɨ feiñuana jitaidɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","“O jeacɨnona jai dotade” bumo omoɨ lloia, Jusiñamui jai dotaca. “O jeacɨnona nia dotañede” bumo omoɨ lloia, Jusiñamui nia dotañega. ");
INSERT INTO huuNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Naie naɨo Tomásna mamecɨrede llofueoicaigamɨe caɨ dɨga iñede. Dídimona jɨaɨ mamecɨrede. Naimɨedɨ gorasa. ");
INSERT INTO huuNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Naimɨemo llotɨcaɨ: —Caɨ Namana aillɨ cɨodɨcaɨ. Tomás uai ote: —Clavo ifona naimɨe onollɨ jeraimo cue cɨoiñenia, naie ifona cue jetañenia, naimɨe cɨraigɨ ifona cue jetañenia, ɨɨnoñeitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ocho dɨgarui illanona, Jesús llofueoicaiganodɨcaɨ dane ofillano, Tomás caɨ dɨga ite. Nana nasiaɨ ɨbaica; iadedɨ nase econoñeno ieconi Jesús caɨ motomo dane fo billano, uaiduano, llote: —Uri omoɨ i. ");
INSERT INTO huuNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Iemei Tomásmo llote: —Eroda cue onollɨmo. Naifo jeta. Cɨraigɨ ifona jɨaɨ jeta. Ɨɨnoñeno jaiñeno. Mai ɨɨno. ");
INSERT INTO huuNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomás uai ote: —Cue Namadɨo. Cue Jusiñamuidɨo. ");
INSERT INTO huuNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesús dane uai ote: —Cuena o cɨua jira, cuena ɨɨnotɨo; iadedɨ cuena cɨoiñedɨno cuena ɨɨnoia, jɨaɨ caɨmare iitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jesús dɨga siño rafuena fɨnode. Iena cɨodɨcaɨ. Nana naie rafuena bie rabenicomo cueñedɨcue; ");
INSERT INTO huuNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","iadedɨ dajerie cuetɨcue. Jesúdɨ caɨ Jilloitaraɨmana omoɨ ɨɨnollena, iena cuetɨcue. Naimɨedɨ Jusiñamui Jitona omoɨ ɨɨnollena, iena jɨaɨ cuetɨcue. Naimɨena omoɨ ɨɨnuano, naimɨe dɨga jaca iitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Dɨga irui illanona, Tiberíana mamecɨrede jorai fuemo Jesús ie llofueoicaiganodɨcaɨmo dane bairede. ");
INSERT INTO huuNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Nainomo dɨese itɨcaɨ: Simón Pedro, Tomás, Natanael, cue ama Jacobo, cue, jɨaɨe iaɨmaiaɨ. Tomás mamecɨ jɨaɨcɨdɨ Dídimo. Natanael Galilea ie Caná naɨraɨ imɨe. ");
INSERT INTO huuNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simón Pedro caɨmo llote: —Lloiji faɨaitɨcue. Naimɨe uai otɨcaɨ: —O dɨga jaitɨcaɨ. —Iese raillano, botemo jaidɨcaɨ. Namona naɨo lloijina faɨtɨcaɨ; ia jaca buena oñedɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Monaiacademo, Jesús jorai fuemo bite; iadedɨ naimɨena uiñoñedɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Jesús caɨmo jɨcanote: —Caɨmacɨ, ¿nɨe dɨese llɨcɨaɨna jai otomoɨ? Uai otɨcaɨ: —Jaca oñedɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Naimɨe dane uai ote: —Omoɨ bote nabei dɨne omoɨ lloijina faɨno. Ie jira faɨtɨcaɨ. Ailluena llɨcɨaɨ naiemo jilla jira, a aiñonidɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Iena cɨuamona, Pedromo llotɨcue: —Caɨ motomo caɨ Namadɨ ite. Pedro iena cacajano, naimɨe taɨmɨena jira, ie ɨniroi jɨtade. Jesús dɨne naimɨe raɨre rillena, joraimo daiade; ");
INSERT INTO huuNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","iadedɨ botedo bitɨcaɨ. Enɨrue iaɨre illa jira, na llɨcɨaɨmo sonocana, lloijina atɨdɨcaɨ. Nɨbaɨ cien metros oni ite. ");
INSERT INTO huuNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Jorai fuemo caɨ ria, coocɨmona bonoca iraina cɨodɨcaɨ. Llɨcɨaɨ iraimo ruica jai ite. Llomenico jɨaɨ ite. ");
INSERT INTO huuNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jesús caɨmo llote: —Omoɨ oga llɨcɨaɨmona janore atɨ. ");
INSERT INTO huuNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ie jira Simón Pedro botemo jaillano, lloijina llɨnuanona, enɨruemo arɨ sonode. Ciento cincuenta y tres jemɨerie jitatɨcaɨ. Ailluena ite; iadedɨ lloiji cuarariñede. ");
INSERT INTO huuNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jesús llote: —Mai guisaɨbi. —Jesúna caɨ uiñua jira: “¿Budɨo?” jaca buna raiñena. ");
INSERT INTO huuNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jesúdɨ llomenico dɨga llɨcɨaɨna caɨna ecade. ");
INSERT INTO huuNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Fiodaillamona jillua facaisemona dacaiño amani caɨmo Jesús jai abɨna bairetate. ");
INSERT INTO huuNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Guilla mei, Jesús Simón Pedromo llote: —Simón, odɨ Juan jitodɨo. —Jɨaɨ jɨcanote— ¿Nana o nabaiñɨaɨ baɨfemo cuena isiruitɨo? Simón uai ote: —Jɨɨ, Nama, ona cue isiruillana uiñotɨo. Jesús uai ote: —Toɨca llaudaɨaɨ uruiaɨna omoɨ raise sedaja isoi, cuena ɨɨnotɨnona raise seda. Naimacɨna cue rafuena raise llofue. ");
INSERT INTO huuNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Dane llote: —Simón, odɨ Juan jitodɨo. —Dane jɨcanote— ¿Cuena isiruitɨo? Simón uai ote: —Jɨɨ, Nama, ona cue isiruillana uiñotɨo. Jesús dɨnena uai ote: —Toɨca llaudaɨaɨ uruiaɨna omoɨ raise sedaja isoi, cuena ɨɨnotɨnona seda. ");
INSERT INTO huuNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Dane jɨcanote: —Simón, ¿cuena isiruitɨo? —Jesús naimɨemo dane jɨcanua jira, “Jesús cue uaina ɨɨnoñede” raillanona, Pedro comecɨ sunaite. Uai ote: —Nama, naga rafuena uiñotɨo. Ona cue isiruillana uiñotɨo. Jesús uai ote: —Toɨca llaudaɨaɨ uruiaɨna omoɨ raise sedaja isoi, cuena ɨɨnotɨnona seda. ");
INSERT INTO huuNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Daje rafue omo nia lloitɨcue. O nia conirue facai o ɨniroi dama jɨtadɨo. Ie mei o jitaillanomo jaidɨo. O uaɨcɨroma facaiseconi o onollɨ oni ñuitaitɨo. Ie mei jɨaɨmɨe o ɨniroi ona jɨtajano, o jitaiñenanomo ona uite. Cue lluana ɨɨnocana o jai. ");
INSERT INTO huuNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Fiodaillena Pedro uiñollena, uicodo Jesús iese llote. Cristo llua isoi, Cristo rafue muidona, illaɨcomɨnɨ Pedrona jɨaɨruido meinetɨmacɨ. Naimɨe fiodaillanona, Jusiñamuina iobitade. ");
INSERT INTO huuNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pedro dɨga Jesús nia ñaɨa facaise, Pedro dobaicaillanona, cuena cɨode. Iaɨmaiaɨ jɨnafona racadɨcue. Jesús gaɨamɨedɨcue. Navui caɨ guia, Jesús nia fiodaiñenia, Jesús abɨmo cue ia, Jesúmo jɨcanotɨcue: “¿Bu gaɨtatallɨo?” ");
INSERT INTO huuNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","“Cuena ɨɨnotɨnona seda” Pedromo Jesús llua mei, Pedro dobaicaillanona, cuena cɨuano, Jesúmo jɨcanote: —Nama, ¿nɨese naimɨe fiodaite? ");
INSERT INTO huuNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesús uai ote: —Naimɨe nia itemo, cue abɨdo bia, dama iesede. Naimɨe rafuedɨ omo duiñede; ia cue lluana ɨɨnocana o jai. ");
INSERT INTO huuNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ie jira creyentiaɨ naie lluana fɨdɨano cuena raitɨmacɨ: —Naimɨe fiodaiñeite. —Iese raitɨmacɨ; iadedɨ Jesús iese raiñede. Jesús llote: “Naimɨe nia itemo, cue abɨdo bia, dama iesede. Naimɨe rafuedɨ omo duiñede”. ");
INSERT INTO huuNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Nana rafuena cɨuano llotɨcue. Iena cuetɨcue. Uanaicɨnuaɨna cuetɨcue. ");
INSERT INTO huuNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jesús ailluena jɨaɨe rafuena fɨnode. Nana ie rafue cuegadena, enɨrue baiñede, naie libros eenollena. Mai. Juandɨcue.");
INSERT INTO huuNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teofilo, o dɨne, ¿nɨgacɨno? ¿Nɨe isoidɨo? Omo jɨaɨe rabe birui dane oretaiacadɨcue. Lucadɨcue. Navui jɨaɨe cartana oretatɨcue. Ailluena Jesús fɨnoca rafuena nainomo cuetɨcue. Ailluena Jesús llofuiacɨnona jɨaɨ cuetɨcue. ");
INSERT INTO huuNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Monamo naimɨena Jusiñamui nia uiñenia, Jesús ie llofueoicaiganona llofueuide. Ie llofueoicaiganona jaie naimɨe fetuamona, Jusiñamui Joreño uaido naimacɨna llofueuide. Naie llofuiacɨnona navui cuetɨcue. Jesús monamo jailla mei, ie llofueoicaigano naimɨe oretaganona mamecɨredɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Naimɨe fiodaillamona ie jillua mei, naimacɨmo bairede. Naimɨe ua jilluana naimacɨ raise uiñollena, dɨga icaiño cuarenta dɨgarui naimacɨmo baireuide. Naimacɨna Jusiñamui dɨbeimo ie comɨnɨ jai illa rafuena llofueuide. Naimɨemo jai suide rafuena llofueuide. Naimɨemo nia suiñede rafuena llofueuide. ");
INSERT INTO huuNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Naimacɨ dɨga Jesús guilla facaise, naimɨe Jerusalémona naimacɨ oni jaillana rairuide. Raite: —Cue Moo ie Joreño omoɨmo fecallena, omoɨmo jai llotɨcue. Naiena omoɨ feiñollena, Jerusalémo nia fɨebi. ");
INSERT INTO huuNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Naimɨe rafuena comɨnɨ ɨɨnuamona, Juan Bautista mɨcorɨ jɨnui dɨga bautizade; iadedɨ cue rafuena omoɨ ɨɨnuamona, nano nɨgarui illanona, cue Moo ie Joreñona feiñoitomoɨ —raite. ");
INSERT INTO huuNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ie llofueoicaigano dɨga Jesús dane ofillanona, naimɨemo jɨcanotɨmacɨ: —Nama, ¿birui caɨ judíuaɨ comɨnɨna jai sedaitɨo, David mɨcorɨ caɨ usumatɨaɨ mɨcorɨaɨ jaie sedaja isoi? ");
INSERT INTO huuNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Naimɨe uai ote: —Naie rafue suille facaiseconi jaca uiñoñeitomoɨ. Naimɨe siñona illamona, dama cue Moo naie rafue suillɨruina uiñote; ");
INSERT INTO huuNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","iadedɨ cue Moo ie Joreñona omoɨ feiñua mei, siño uai omoɨmo iite. Ie jira Jerusalémo cuena lloitomoɨ. Judeamo, Samariamo, ua nana enɨruemo ite naɨraɨmo lloitomoɨ —raite. ");
INSERT INTO huuNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Naimɨe iena llua mei, Olivos railla anedumo jai jaidɨmacɨ. Nainomo itɨmacɨmo, naimacɨ eruaɨsɨtemo, monamo Jesús Jusiñamui uiga. Uillɨe illa jira, naimɨena cɨoisɨñede. ");
INSERT INTO huuNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Monamo nia eruaɨdemo, ieconi naimacɨ dɨne Jusiñamui jaɨenicɨ, mena ɨima bairia isoi, bairedɨiaɨmaiaɨ. Naie iaɨmaiaɨ ɨniroi userede. ");
INSERT INTO huuNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Raitɨiaɨmaiaɨ: —Galileo imacɨ, ¿bue ñellena monamo eruaɨdomoɨ? Omoɨ motomona Jesús monamo jaillana jai cɨodomoɨ. Naimɨe jai jailla isoi, dane abɨdo ɨco biite —raitɨiaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Naimacɨmo Jusiñamui jaɨenicɨ llua mei, Olivos railla anedumona Jerusalémo naɨsodo abɨdo jaidɨmacɨ. Olivos railla anedumona Jerusalémo ochocientos metros dɨnori illanona, sábadoruimo Moisés mɨcorɨ lloga dɨnori macaritɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Rillano imacɨ cuartomo jaidɨmacɨ. A dɨbebamo ite. Nainomo itɨmacɨ: Pedro, Jacobo, Juan, Andrés, Felipe, Tomás, Bartolomé, Mateo, jɨaɨe Jacobo. Naimɨedɨ Alfeo jito. Simón ite. Naimɨedɨ cananista comɨnɨ facaisemo duide. Judas ite. Naimɨe jɨaɨe Jacobo jito. Dɨese nainomo itɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Naimacɨ jitaillamona, Jusiñamuimo jɨɨllena, nagarui danomo ofidɨmacɨ. Jɨɨllena, jɨaɨno naimacɨ dɨga jɨaɨ ofisoidɨmacɨ. Dɨga rɨñonɨaɨ jɨaɨ ofisoidɨmacɨ. Jesús ei, María, jɨaɨ ofisoide. Jesús amatɨaɨ jɨaɨ ofisoidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Comɨnɨ ofilla motomo Pedro naidaita, rafuena llote. Nɨbaɨ ciento veinte comɨnɨ nainomo itɨmacɨ. Pedro llote: ");
INSERT INTO huuNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","—Amatɨaɨ, David mɨcorɨ jaie lloga rafue birui jai suide. Jusiñamui Joreño jaie David mɨcorɨna Judas mɨcorɨna ñaɨtatate. Salmos rabenicomo naie ñaɨacɨnodɨ cuega. Iena uiñotɨcaɨ. Judas mɨcorɨna uiñotɨcaɨ. Naimɨe Jesúna gaɨtadɨnona ɨfode. ");
INSERT INTO huuNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Naimɨedɨ da caɨ llofueoicaigano imɨe. Caɨ dɨga maɨjɨuide. ");
INSERT INTO huuNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Ie maraiñeno fɨnoca rafuemona ucubena feiñua mei, ie comecɨ iuaina meiduanona, naie ucubena oni judaɨde. Judíuaɨ illaɨcomɨnɨ naie ucube dɨga enɨruena ɨbadɨmacɨ. Nainomo Judas mɨcorɨ ie cɨmaɨo cuinajanona, ie abɨna dama meinete. Rɨfaillamona, ana uaillamona, ie jebegɨ boficaillamona, nana ie jebegɨ jino uaide. ");
INSERT INTO huuNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Nana Jerusalémo itɨno iena fɨdɨdɨmacɨ. Ie jira caɨ uaido naie enɨrue mamecɨrede Acéldama. Oni dobaiñuamona dɨrue toillanɨe. ");
INSERT INTO huuNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Ero, Salmos rabenicomo Judas mɨcorɨna iese David mɨcorɨ jaie cuega: Naimɨe illano taɨno iite. Buna jaca iemo iñeite. Naimɨe maɨjɨlle jɨaɨmɨemo iite. Iese cuega. ");
INSERT INTO huuNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Ie jira caɨ dɨga itɨnomona damɨena fetoitɨcaɨ. Caɨ Nama Jesús caɨ dɨga illa facaiseconi, nagarui dɨga ɨiñɨaɨ caɨ dɨga jaisoidɨmacɨ. Juan Bautista mɨcorɨ Jesúna bautizaja facaisemona, Jesús monamo caɨmona jaillarui facaiseconi, naimacɨ caɨ dɨga jɨaɨ itɨmacɨ. Naimacɨmona damɨena fetoitɨcaɨ, Jesús jilluana caɨ dɨga llollena. —Iese Pedro raite. ");
INSERT INTO huuNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ie mei mena ɨimana fetodɨmacɨ. Damɨedɨ José Barsabas. Jɨaɨcɨ mamecɨ Justo. Jɨaɨmɨedɨ Matías. ");
INSERT INTO huuNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ie mei Jusiñamuimo jɨɨdɨmacɨ: —Nama, nana comɨnɨ imacɨ comecɨaɨna uiñotɨo. ¿Nɨe ɨimana jitaidɨo? Caɨna uiñota. ");
INSERT INTO huuNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Naimɨedɨ Judas ifo meidoite. Jesús ie oretagamɨena naimɨe jaillamona, caɨ dɨga maɨjɨjite. Ie fiodaillamona Judas mɨcorɨ ie maɨjɨana jai faɨnonocaide —jɨɨdɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ie jira conima jabomasɨde, uiñollena bu ille. Matíamo baite. Iemei jɨaɨe once dɨga oretagano isoi naimɨe ite. ");
INSERT INTO huuNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pentecostés railla rafue irui ria, nana creyentiaɨ dɨese danomo itɨmacɨ. Pentecostés trigo ua ie rafue. Pascua rafue illa meinoconi, cincuenta dɨgarui illanona bie rafue ite. ");
INSERT INTO huuNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Danomo ia, ebena illacɨnomona monamona rɨire aɨfɨ billa isoi buena cacadɨmacɨ. Nana jofomo itɨno naiena jɨaɨ cacadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Iena naimacɨmo bairede. Iena cɨodɨmacɨ. Irai boua isoi eruaɨde. Nana naimacɨmo baite. ");
INSERT INTO huuNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Iese Jusiñamui Joreñona feiñotɨmacɨ. Nana naimacɨ comecɨaɨna namatade. Iemei dɨga naɨraɨ uaillaɨdo ñaɨtɨmacɨ, Jusiñamui Joreño naimacɨna ñaɨtatajamona. Naimacɨ ñaɨa uaillaɨna uiñoñedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Naie facaiseconi Jerusalémo Jusiñamui rafuedo eo jaide judíuaɨdɨ itɨmacɨ. Dɨga naɨraɨaɨmona bitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Creyentiaɨ ñaɨana naimacɨ fɨdɨano, ailluena comɨnɨ jino taɨnomo ofidɨmacɨ. Nagamɨiaɨdɨ ie naɨraɨ uaina cacade. Ie jira jacɨnaitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Eo raijicaidɨmacɨ. Coninɨmo jɨcanotɨmacɨ: —¿Buta ñaɨte? Nana Galileos imacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Nɨese naimacɨna cacadɨcaɨ? Caɨ uaido dajerie ñaɨana cacadɨcaɨ —raitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Dɨga comɨnɨ imɨiaɨ itɨmacɨ: Partos, Medos, Elamitas, Mesapotamia imacɨ, Judea imacɨ, Capadocia imacɨ, Ponto imacɨ, Asia imacɨ, ");
INSERT INTO huuNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frigia imacɨ, Panfilia imacɨ, Egipto imacɨ, Libia imacɨ. Libia imacɨ enɨrue Cirenemo ruica eruaɨde. Romamona jamai macaritɨno jɨaɨ itɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Judíuaɨ itɨmacɨ. Judíuaɨñedɨno jɨaɨ itɨmacɨ. Judíuaɨ isoi Jusiñamuina jai sedadɨmacɨ. Cretenses itɨmacɨ. Arabes itɨmacɨ. —Caɨ uaido Jusiñamui ie ebirede fɨnoca rafuena cacadɨcaɨ —raitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Nana eo raijicaidɨmacɨ. Danɨrie jɨcanododɨmacɨ: —¿Bue ite? ");
INSERT INTO huuNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Jɨaɨe comɨnɨ jɨfanoduano, raitɨmacɨ: —Jɨfaidɨmacɨ. Ie jira iese ebena ñaɨtɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ie facaise ie once nabaiñɨaɨ naimɨe ecɨmo illanona, Pedro nainomo como ofidɨnomo ado llote: —Caɨmacɨ, ua nana Jerusalén imacɨ, cue lluamo cacarei. Naie rafuena lloitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Omoɨ comecɨaɨna omoɨ facaja isoi, jɨfaiñedɨcaɨ. Jitoma nia fuirɨ daidemo, bu jaca jɨfairaɨnina. ");
INSERT INTO huuNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Joel mɨcorɨ bie rafuena jaie llote. Joel mɨcorɨ Jusiñamui rafuena lloraɨma. Naimɨe jaie lloga rafue birui caɨmo jai suide. ");
INSERT INTO huuNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Llote: Jusiñamui caɨmo llote: “Jɨaɨruido bie rafue suite. Cue Joreñona dɨga comɨnɨmo fecajitɨcue. Iedo omoɨ uruiaɨ cue lluana lloitɨmacɨ. Iemona omoɨ coniruiaɨna nɨcaɨritaitɨcue. Iemona omoɨ einamacɨna jɨaɨ nɨcaɨritaitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ua nana cuena sedadɨnomo cue Joreñona fecajitɨcue. Naimacɨ cue lluana lloitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Monamo eo jacɨrede rafuena ɨco suiñotaitɨcue. Enɨruemo eo jacɨrede rafuena ɨco jɨaɨ suiñotaitɨcue. Comɨnɨ jobairillemona, enɨruemo comɨnɨ dɨruedɨ eo iite. Naie facaise daje dɨese enɨrue boojite. Bouamona uillɨe eo iite. ");
INSERT INTO huuNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Jitoma llɨgaiñoñeite. Fɨvui dɨruena eruaɨte. Nana bie suite, Cristo billa facaise nia iñenia. Naie facaise dɨga jacɨrede rafue suite; ");
INSERT INTO huuNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","iadedɨ birui cuemo bu jɨcaia, ie jeacɨnomona naimɨena jillotaitɨcue” Jusiñamui llote. Ie Joreño caɨmo birui illamona, Joel mɨcorɨ llogacɨno jai suide. ");
INSERT INTO huuNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","’Caɨmacɨ, bie uaina omoɨ cacarei. Nazaret ie Jesúna ñaɨtɨcue. Jusiñamuidɨ omoɨ motomo naimɨena siño rafuena jai fɨnotate. Iena jai uiñotomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Jusiñamui comecɨ jaie facaja isoi, Jusiñamui jitailla isoi, Jusiñamui naimɨena omoɨmo fecade. Jesúna coraɨtatomoɨ. Jusiñamuina ɨɨnoñedɨnona naimɨena meinetadomoɨ; ");
INSERT INTO huuNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","iadedɨ fiodaillamona naimɨena Jusiñamui jillotajano, llegɨ ie cacajamona naimɨe jillobide. Naimɨe fiodaite; iadedɨ fiodaillamona nainomo iñoiñede. ");
INSERT INTO huuNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","David mɨcorɨ naimɨena jaie llote: Jusiñamui cue dɨga jaca illana uiñotɨcue. Cue ecɨmo naimɨe ite, cue comecɨna ocuiñotallena. ");
INSERT INTO huuNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ie jira cue comecɨ caɨmare ite. Eo iobidɨcue. Cue marena illemo jai jɨaɨ ocuiridɨcue, ");
INSERT INTO huuNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","raɨafomo cue joreñona naimɨe faɨnonocaiñena jira, ie mare Jito abɨ rɨfaillana naimɨe jitaiñena jira. ");
INSERT INTO huuNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Naimɨe cuena jilloitallena uiñotɨcue. Cue dɨga naimɨe illa jira, cue comecɨ caɨmare iite. ");
INSERT INTO huuNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","’Caɨmacɨ, caɨ usuma David mɨcorɨna marefodo ñaɨtɨcue. David mɨcorɨ ñaɨa, dama naimɨe facaina ñaɨñede. Jesúna ñaɨte. David mɨcorɨ jaie fiodaite. Raɨafomo jonega. Naifo bene nia illamona, naimɨedɨ Jesúna ñaɨana uiñotɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ie ia David mɨcorɨ Jusiñamui rafuena llote. Naimɨe mɨcorɨdɨ Jusiñamui naimɨemo uanaicɨnona lluana uiñote. Jaie Jusiñamui naimɨemo llote: “O uruiaɨmona damɨe illaɨmana illanona, ie comɨnɨna sedajite” llote. ");
INSERT INTO huuNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Cristona ñaɨte. David mɨcorɨ nia suiñede rafuena llote. Naimɨe mɨcorɨ Cristo jilloillena llote: “Raɨafo Jusiñamui fiodaillanomo Cristo Joreño faɨnonocaiñeite. Cristo abɨ rɨfaiñeite” llote. ");
INSERT INTO huuNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Jesúna ñaɨte. Jusiñamui Jesúna jai jillotate. Nana caɨ iena cɨodɨcaɨ. Ie jira iena llotɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ie ecɨmo Jesúna jai dane itatajanona, Jusiñamui naimɨena iobitade. Ie Moo llua isoi, Jesús jai ie Moo Joreño caɨmo jai fecade, omoɨ birui cɨua isoi, omoɨ birui cacaja isoi. ");
INSERT INTO huuNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Naimɨe abɨ monamo jaiñena jira, David mɨcorɨ dama naimɨe facaina ñaɨñede; ia Cristona ñaɨte. Ero, jaie David mɨcorɨ raite: Jusiñamui Cristomo llote: “Cue ecɨmo ana raɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Ona ɨɨnoñedɨnona o anamo itataitɨcue” raite. David mɨcorɨ llua isoi, birui jai suide. ");
INSERT INTO huuNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Pedro nia ñaɨte: —Jesúna coraɨdomoɨ; iadedɨ Jusiñamui naimɨena caɨ Namana itatate. Naimɨena caɨ Jilloitaraɨmana jai itatate. Nana judíuaɨ comɨnɨ naiena uiñuana jitaidɨcue. ");
INSERT INTO huuNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Pedro lluana cacajano, naimacɨ comecɨaɨmo rɨire baite. Pedromo iena jɨcanotɨmacɨ. Ie nabaiñɨaɨmo jɨaɨ jɨcanotɨmacɨ: —Caɨmacɨ, o lluana jai cacadɨcaɨ. ¿Bue fɨnoitɨcaɨ? ");
INSERT INTO huuNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pedro uai ote: —Omoɨ comecɨaɨ iuaina meido. Iemei Jusiñamui omoɨmo ite jeacɨnuaɨna dotajite. Jesucristo facaina omoɨ bautizallomoɨ. Jusiñamui Joreñona jɨaɨ feiñoitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Omoɨmo ie Joreño fecallena navui llote. Omoɨ uruiaɨmo jɨaɨ fecaite. Jɨaɨe naɨraɨaɨ itɨnomo jɨaɨ fecaite. Ua nana Jusiñamui fetocanomo jɨaɨ fecaite. ");
INSERT INTO huuNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Dɨga uai naimacɨmo Pedro llote. Raite: —Ailluena comɨnɨ maraiñede rafuena birui fɨnocana jaidɨmacɨ. Faɨfitɨmacɨ. Naimacɨ isoi jaiñeno; iadedɨ cue lluana omoɨ cacajamona, iena ɨɨno. ");
INSERT INTO huuNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Dɨga comɨnɨ ie lloga uaina feiñuano, bautizadɨmacɨ. Nairuido nɨbaɨ tres mil comɨnɨ creyentiaɨna jaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Cristo oretagano llofuiana fueouidɨmacɨ. Cristo oretaganona eo nabaidɨmacɨ. Nagarui ofillanona, Jesús fiodaillana comecɨuidɨmacɨ. Jusiñamuimo jɨɨuidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Cristo oretaganodɨ dɨga siño rafuena fɨnuamona, nana comɨnɨ jacɨnaitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Nana creyentiaɨ damacɨna itɨmacɨ. Naimacɨ raruiaɨ coninɨmo fecauidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Dueredɨno ia, naimacɨna canollena, raruiaɨredɨno naimacɨ raruiaɨna vendedɨmacɨ. Iemei naie ucube dueredɨnomo fecadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Jusiñamuina sedallena, nagarui Jusiñamui jofomo ofisoidɨmacɨ. Danɨrie imacɨ jofuemo Jusiñamuina jɨaɨ sedauidɨmacɨ. Nainomo danomo guillanona, Jesús fiodaillana comecɨuidɨmacɨ. Caɨmare imacɨ comecɨaɨ illamona, caidɨñeno guisoidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Jusiñamuimo iobillacɨnona fecacana jaidɨmacɨ. Nana comɨnɨdɨ naimacɨna: “Mare” raitɨmacɨ. Naimacɨna Jusiñamui itataja isoi, nagarui comɨnɨ creyentiaɨna jaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Jusiñamui jofomo jɨɨa facaise Pedro iaɨmaiaɨ Juan dɨga jaide. Jitoma ana ia, comɨnɨ jɨɨuidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Iaɨmaiaɨ jaillanomo jɨaɨe comɨnɨ tɨsitaitɨmɨena atɨana cɨodɨiaɨmaiaɨ. Tɨsitaitɨmɨena naimɨe jaca jeicɨga. Naimɨena nagarui atɨano, Jusiñamui jofo ie ebiredena railla nase fuemo raɨnauidɨmacɨ. Nainomo naimɨena raɨnauidɨmacɨ, fo jaidɨnomona ucube jɨca-jɨcallena. ");
INSERT INTO huuNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Iaɨmaiaɨ fo jaiacania, ucube jɨcallena, ie onollɨ ñuitade. ");
INSERT INTO huuNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Iaɨmaiaɨ naimɨemo eruaɨllano, Pedro raite: —Cocomo eruaɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ie jira iaɨmaiaɨmo eruaɨde. Ra feiñoitena, ocɨanona sedade. ");
INSERT INTO huuNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pedro raite: —Ucube cuemo iñede; iadedɨ cuemo ite rana omo fecaitɨcue. Nazaret ie Jesucristo uai cuemo illa jira, ona macaritaitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Pedro naimɨe onollɨdo llɨnuano, a naidanete. Ieconi naimɨe eɨllɨdɨ jillode. Ie taisɨcoñuaɨ jɨaɨ jillode. ");
INSERT INTO huuNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Daiacaillanona naidacaide. Macarillanona, iaɨmaiaɨ dɨga fo jaide. Jusiñamuimo iobillacɨnona fecajano, daiacaillanona macarite. ");
INSERT INTO huuNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Nana comɨnɨ naimɨe macarillana cɨodɨmacɨ. Naimɨe iobillacɨnona fecajana jɨaɨ cacadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Naimɨe nase fuemo ana raɨsoilla jira, naimɨena uiñotɨmacɨ. Naimɨemo jai suide rafuena eo raijicaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Naimɨedɨ Pedro iaɨmaiaɨ Juan dɨga nia llɨnuano, naimacɨ dɨne Salomón mɨcorɨ fɨnotaga jofo abɨ ibɨrɨmo comɨnɨ aisɨdɨmacɨ. Raijicaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Iena cɨuano, Pedro naimacɨna raite: —Caɨmacɨ, ¿bue ñellena biemo raijicaidomoɨ? ¿Bue ñellena caɨmo iese eruaɨdomoɨ? “Daɨmaiaɨ iaɨmaiaɨ uaido naimɨena jilloitate” raillanona cocomo eruaɨdomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Iena fɨnoñedɨcoco; iadedɨ Jusiñamui iena fɨnuano, ie Jito Jesúna iobitade. Caɨ usumatɨaɨ mɨcorɨaɨ, Abraham, Isaac, Jacob, ua nana caɨ usumatɨaɨ mɨcorɨaɨ bie Jusiñamuina sedadɨmacɨ; iadedɨ Jesúna birui fecadomoɨ, coraɨllena. Pilato naimɨena jino marena oretaiacana jira, Pilato ecɨmo naimɨena llogɨdotomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Mareuidɨmɨena jitaiñedomoɨ; iadedɨ come fatɨmɨena cárcelmona jino billana jitaidomoɨ. Barrabás raillamɨena jitaidomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Jusiñamui dɨbeimo caɨna itatatɨmɨena meinetomoɨ. Naimɨe fiodaite; ia Jusiñamui naimɨena jillotate. Iena cɨodɨcoco. Ie jira iena llotɨcoco. ");
INSERT INTO huuNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Tɨsitaitɨmɨe jilluana jai cɨodomoɨ. Naimɨena uiñotomoɨ. Jesúna naimɨe ɨɨnua jira, Jesús naimɨena maɨritate. Naimɨena raise jillotate. Iena jai cɨodomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","’Caɨmacɨ, ero, omoɨ fɨnoca rafuena abɨna uiñoñeno fɨnodomoɨ. Omoɨ illaɨcomɨnɨ jɨaɨ daje isoi fɨnodɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Jaie Jusiñamuidɨ ie facaina lloraɨnɨna jɨaɨruido suille rafuena llotatate. Naimacɨna Cristo llegɨ cacajana llotatate. Birui naie llogacɨno suide. ");
INSERT INTO huuNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Omoɨ comecɨaɨ iuaillaɨ meido. Jusiñamui dɨbeimo omoɨ comecɨaɨna meido. Iemei Jusiñamui omoɨ jeacɨnona dotaite. Iena jaca feitaite. ");
INSERT INTO huuNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Omoɨ uri illa facaise illena, Jusiñamui omoɨ dɨga illena, iena fɨno. Jusiñamui Jesucristona omoɨ dɨne dane oretallena, iena fɨno. Naimɨedɨ omoɨ Jilloitaraɨma. ");
INSERT INTO huuNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Jusiñamui facaina lloraɨnɨ mɨcorɨaɨ jaie lloga rafue suille dɨnori monamo naimɨe fɨebiite. Jaie Jusiñamuidɨ ie mare lloraɨnɨ mɨcorɨaɨ uaido biena llote. ");
INSERT INTO huuNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moisés mɨcorɨ raite: “Omoɨ comɨnɨmona naimɨe rafue lloraɨmana jaillena, caɨ Nama Jusiñamui cue isoi damɨena fetoite. Nana naimɨe omoɨmo lluana cacarei. ");
INSERT INTO huuNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Bie lloraɨmana bu cacarefiñenia, Jusiñamui naimɨena duere fɨnoite. Iemona faɨfite”. ");
INSERT INTO huuNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Nana Jusiñamui ie lloraɨnɨ mɨcorɨaɨdɨ birui suille rafuena llotɨmacɨ. Samuel mɨcorɨ illa facaisemona naimacɨ biena llotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Jusiñamuidɨ caɨ usumatɨaɨ mɨcorɨaɨmo rafuena llote; ia bie rafue birui omoɨmo jɨaɨ duide. Jusiñamui Abraham mɨcorɨmo jaie llote: “Nana comɨnɨdɨ o uruiaɨ muidona caɨmare iitɨmacɨ”. ");
INSERT INTO huuNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ie rafue suiñollena, Jusiñamui ie Jitona omoɨ dɨne navui orede. Omoɨ caɨmare illena, nano omoɨ maraiñedɨcɨnona faɨnonocaitallena, omoɨ dɨne naimɨena nano jai oretate. ");
INSERT INTO huuNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Comɨnɨ dɨga Pedro iaɨmaiaɨ Juan dɨga ñaɨa facaise, Jusiñamui dɨga ñaɨraɨnɨdɨ naie iaɨmaiaɨ dɨne bitɨmacɨ. Jusiñamui jofona sedaraɨnɨ illaɨma dɨga, saduceuaɨ railla comɨnɨ dɨga jɨaɨ bitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Fiodaillamona Jesús jai jilluana llofuetɨiaɨmaiaɨ. Comɨnɨna iaɨmaiaɨ llofuia jira, naie iaɨmaiaɨ dɨga icɨritɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Iaɨmaiaɨna gaɨtajanona, jai navuilla jira, cárcelmo jonetɨmacɨ, ie jitɨramo naie rafuena siadollena. ");
INSERT INTO huuNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Iese suide; ia Pedro llogacɨnona cacadɨnomona ailluena comɨnɨ naiena ɨɨnotɨmacɨ. Cinco mil dɨgamɨe creyentiaɨna jai itɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ɨcoitɨ Jerusalémo nana judíuaɨ illaɨcomɨnɨ siadollena ofidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Anás jɨaɨ bite. Naimɨedɨ Jusiñamui dɨga nanoca ñaɨraɨma. Caifás bite. Juan bite. Alejandro jɨaɨ bite. Nana Jusiñamui dɨga nanoca ñaɨraɨma comɨnɨdɨ ofidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Naimacɨ motomo Pedro iaɨmaiaɨ Juan dɨga atɨanona, iaɨmaiaɨmo jɨcanotɨmacɨ: —¿Bu uai dɨga biena fɨnodomɨco? ");
INSERT INTO huuNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Jusiñamui Joreño nana Pedro comecɨmo namatajano, Pedro naimacɨmo llote: —Illaɨcomɨnɨ, bie rafuena omoɨmo lloitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Tɨsitaitɨmɨe jilluana birui cocomo jɨcanotomoɨ. “¿Buemona naimɨe jillode?” raillanona cocomo jɨcanotomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Jesucristo uai dɨga jillode. Omoɨ biena uiñuana, ua nana judíuaɨ comɨnɨ biena uiñuana jitaidɨcue. Jesucristodɨ Nazaret imɨe. Naimɨena jai coraɨdomoɨ; ia Jusiñamui naimɨena jai jillotate. Ie jira omoɨ uicomo Jesús muidona tɨsitaitɨmɨe jai benoconi naidaillana cɨodomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Omoɨ jofo fɨnoraɨnɨ isoidomoɨ. Omoɨ jitaiñede nofɨcɨdɨ jɨaɨe nofɨcɨ baɨfemo jai jaide. Jesúdɨ naie nofɨcɨ isoide. Naimɨe rafuena omoɨ jitaiñena jira, naimɨena meinetomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Caɨ jeacɨnomona jɨaɨmɨe caɨna jillotanide. Nana enɨruemo ite comɨnɨmona jɨaɨmɨe buna jaca jillotanide. Dama Jesús caɨna jillotarede —llote. ");
INSERT INTO huuNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Jacɨruiñeno marefodo llofuetɨiaɨmaiaɨ. Nainomo itɨno iena cacajano, comecɨna facadɨmacɨ: “Abɨna uiñoñedɨiaɨmaiaɨ. Jamai bue isoidɨaɨmaiaɨ”. Ie jira raijicaidɨmacɨ; iadedɨ Jesús llofueoicaigaiaɨmaiaɨna illana uiñotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Jilloitagamɨe iaɨmaiaɨ dɨga naidaillana cɨodɨmacɨ. Ie jira naimacɨ uai iñede. ");
INSERT INTO huuNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Naie rafuena siadollena, naie illaɨcomɨnɨ iaɨmaiaɨna baɨ oredɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Coninɨmo jɨcanotɨmacɨ: —¿Nɨese naie iaɨmaiaɨna nɨbaɨitɨcaɨ? Nana Jerusalémo itɨno iaɨmaiaɨ siño rafuena fɨnuana jai fɨdɨdɨmacɨ. Iena janonidɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Jɨaɨe comɨnɨ iena fɨdɨi raillano, Jesús rafuena iaɨmaiaɨ llofuiana rairuitɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ie mei iaɨmaiaɨna naimacɨ dɨne dane uaidotɨmacɨ. Iaɨmaiaɨmo Jesús rafuena llofueñellena rɨire llotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Pedro iaɨmaiaɨ Juan dɨga naimacɨ uai ote: —Ie rafuena coco llollena Jusiñamui jitaide. Omoɨ uaina coco ɨɨnoia, Jusiñamui jitailla rafuena fɨnoñeitɨcoco. Cocomo llono. ¿Bu uaina ɨɨnoitɨcoco? ¿Jusiñamui? ¿Omoɨ? Cocomo iese llono. ");
INSERT INTO huuNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Daɨmaiaɨ coco cɨua rafuena llotɨcoco. Daɨmaiaɨ coco cacaja rafuena llotɨcoco —raite. ");
INSERT INTO huuNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Iaɨmaiaɨna jacɨnaitajamona, iaɨmaiaɨna jino oretatɨmacɨ. Iaɨmaiaɨna duere fɨnoñedɨmacɨ, nainomo ite comɨnɨ icɨrinaiñellena. Jusiñamuimo nana nainomo itɨnodɨ iobillacɨnona fecadɨmacɨ, tɨsitaitɨmɨe jai jillua jira. ");
INSERT INTO huuNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Jai jillodɨmɨemo cuarenta años baɨfemo ite. Siño uaido naimɨe jillua jira, comɨnɨ iobidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Iaɨmaiaɨ jino jailla mei, iaɨmaiaɨ nabaiñɨaɨ dɨne jaidɨiaɨmaiaɨ. Illaɨcomɨnɨ iaɨmaiaɨmo lluana llotɨiaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Naimacɨ iena cacajano, Jusiñamuimo damɨe llua isoi jɨɨdɨmacɨ: —Ore Moo, mona fɨnodɨo. Enɨruena fɨnodɨo. Monaillaina fɨnodɨo. Nana naiemo ite rana jɨaɨ fɨnodɨo. ");
INSERT INTO huuNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Caɨ usuma David mɨcorɨna raise uiñotɨcaɨ. Naimɨedɨ ona sedadɨmɨe. Naimɨena bie rafuena o Joreño jaie llotatajamona, naimɨe llote: ¿Bue ñellena Jusiñamui dɨga judíuaɨñedɨno icɨritɨmacɨ? ¿Bue ñellena Jusiñamuimo comɨnɨ taɨnomo comecɨaɨna facadɨmacɨ? ");
INSERT INTO huuNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Illaɨcomɨnɨ ofidɨmacɨ, Jusiñamui dɨga fuirillena. Jusiñamui facaisena iñedɨmacɨ. Cristo facaisena jɨaɨ iñedɨmacɨ llote. ");
INSERT INTO huuNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Naie rafue birui bene suide. Bie naɨraɨmo Herodedɨ, Poncio Pilato dɨga, judíuaɨñedɨno dɨga, judíuaɨ comɨnɨ dɨga, ofide. O mare Jito Jesús facaisena iñedɨmacɨ. Naimacɨmo o oretagamɨe facaisena iñedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Naimacɨ ofillamona, nana o jitaille rafuedɨ, o jaie lloga rafue dɨga, jai suide. ");
INSERT INTO huuNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Nama naimacɨ jacɨruitajacɨnona jai uiñotɨo. Caɨ comecɨaɨna ocuiñota, o rafuena jacɨtaiñeno caɨ llollesa. ");
INSERT INTO huuNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Duidɨnona jilloita. O mare Jito Jesús uaido caɨna siño rafuena fɨnota —jɨɨdɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Jusiñamuimo jɨɨacɨno fuilla meinoconi, naimacɨ ofiracodɨ jaidɨsite. Jusiñamui Joreño nagamɨiaɨ comecɨmo namatade. Iemona Jusiñamui uai jacɨtaiñeno llocana jaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Nana creyentiaɨ damacɨna itɨmacɨ. Naimacɨmo raruiaɨ ia, dajena naimacɨmo duide. ");
INSERT INTO huuNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Naie facaise siño uaido naimɨe oretagano caɨ Nama Jesús jilluana llofueuidɨmacɨ. Iemona comɨnɨdɨ naimacɨna: “Mare” raitɨmacɨ. Nagarui Jusiñamui naimacɨna eo canode. ");
INSERT INTO huuNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Naimacɨ dɨne buna buena jaca jitaiñedɨmacɨ. Ucube ollena, enɨrueredɨno imacɨ enɨruena fecadɨmacɨ. Ucube ollena, joforedɨno imacɨ jofona fecadɨmacɨ. Ucubene atɨanona, ");
INSERT INTO huuNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Cristo oretaganomo fecadɨmacɨ. Ie mei dueredɨnomo imacɨ jitailla isoi fecauidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Naimacɨ motomo José mamecɨredɨmɨe ite. Cristo oretagano jɨtaca mamecɨdɨ Bernabé. Ie mamecɨ oni dobaiñuamona fɨradotɨmɨe. Naimɨe naɨraɨdɨ levita. Naimɨedɨ Chipre railla uiasi imɨe. ");
INSERT INTO huuNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Jerusalémo naimɨe fecalle enɨruedɨ ite. Iena fecajamona, ucube atɨano, Cristo oretaganomo fecade. ");
INSERT INTO huuNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Naie facaise Ananías ie aɨ dɨga iaɨmaiaɨ enɨruena jɨaɨ fecade. Ie aɨ mamecɨdɨ Safira. ");
INSERT INTO huuNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Naie ɨba naimɨemo dabei fɨebide. Ie aɨ iena uiñote. Atuedo atɨanona, Cristo oretaganomo fecade, “Nana ucube atɨdɨcue” raillanona. ");
INSERT INTO huuNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Jusiñamui Joreño Pedrona naie rafuena uiñotajamona, Ananíamo Pedro jɨcanote: —¿Nɨese Taɨfe o comecɨmo namatade? Jusiñamui Joreñomo taɨno llotɨo, dabei ucube omo fɨebilla jira. ");
INSERT INTO huuNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Enɨrue nia fecañenia, nia oɨe. Fecaja mei, naie ucubedɨ nia oɨe. ¿Bue ñellena o comecɨna maraiñeno facadɨo? Comɨnɨmo taɨno llotɨo. Jusiñamuimo taɨnona jɨaɨ llotɨo. ");
INSERT INTO huuNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananías bie uaina cacajano ieconi fiodaillamona oni caide. Nana iena cɨodɨno eo jacɨnaitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Iemei nainomo ite coniruenɨaɨ naimɨena ferɨdɨmacɨ. Jino uillano, raɨafomo jonetɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Naie rafue daje amani horas illanona, naimɨe aɨ ie ɨnimo suide rafuena uiñoñeno bite. ");
INSERT INTO huuNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pedro naiñaiñomo jɨcanote: —¿Nɨe dɨese o fecaca o enɨrue? Cuemo llono. Naiñaiño uai ote: —Jɨɨ, ie dɨese coco fecaca. ");
INSERT INTO huuNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Pedro jɨcanote: —¿Bue ñellena Jusiñamui Joreñona jɨfuetomɨco? Ero, o ɨni raɨafomo jonetɨno saisɨa jai nasemo cacade. Naimacɨ ona jɨaɨ jino ja uitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Naimɨe ecɨmo ieconi naiñaiño fiodaillamona, oni caide. Coniruenɨaɨ fo billano, naiñaiño fiodaillana cɨodɨmacɨ. Jino uillano, ie ɨni abɨmo dafomo jonetɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Iena fɨdɨamona, nana creyetiaɨ eo jacɨnaitɨmacɨ. Nana bie rafuena fɨdɨdɨnodɨ jɨaɨ eo jacɨnaitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Comɨnɨ motomo Cristo oretaganodɨ ailluena siño rafuena fɨnouidɨmacɨ. Naie facaise nana naimacɨdɨ Jusiñamui jofomo Salomón mɨcorɨ fɨnotaga jofo abɨ ibɨrɨmo ofisoidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Jɨaɨe comɨnɨdɨ jacɨruillanona, naimacɨna nabaiñedɨmacɨ; iadedɨ naimacɨna raite: —Cristo oretagano fue eo mare. ");
INSERT INTO huuNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Jacɨruitɨmacɨ; iadedɨ creyentiaɨna ailluena comɨnɨ jaidɨmacɨ. Ailluena ɨiñɨaɨ, ailluena rɨñonɨaɨ, dɨese creyentiaɨna jaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Imacɨ bɨiramo duidɨnona jonecaida, naɨsomo atɨdɨmacɨ. Pedro nainomo macarillano, o llota naimɨe joreño naimacɨmo ɨbaillamona, “Jillobitɨcaɨ” raillano, atɨdɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Jerusalémo ie fuemo ite naɨraɨaɨmona comɨnɨ biadedɨ, duidɨnona jɨaɨ atɨdɨmacɨ. Janaba anamo ite comɨnɨna jɨaɨ atɨdɨmacɨ. Nana jillodɨmacɨ. Ie isoi Cristo oretagano siño rafuena fɨnouidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Cristo oretagano fɨnoca rafueri Jusiñamui dɨga nanoca ñaɨraɨma eo uradoide. Nana naimɨe dɨbeimo itɨno jɨaɨ eo uradoidɨmacɨ. Saduceuaɨ railla comɨnɨmo duidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Eo uradoillamona, Cristo oretaganona gaɨtajano, cárcelmo jonetɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Naɨona Jusiñamui jaɨenicɨdɨ cárcel nasena econote. Cristo oretagano jino atɨano, naimacɨna raite: ");
INSERT INTO huuNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","—Jusiñamui jofomo mai abɨdo jai. Comɨnɨmo Jusiñamui dɨne naimacɨ ille rafuena llono. ");
INSERT INTO huuNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Iena cacajano, monaidemo, Jusiñamui jofomo jaillano, llofuetɨmacɨ. Ie facaiseconi Jusiñamui dɨga nanoca ñaɨraɨma, ie comɨnɨ dɨga billano, danomo ofillena illaɨcomɨnɨna uaidote. Cárcelmo policíaɨaɨna oretate, Cristo oretaganona atɨllena. ");
INSERT INTO huuNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Cárcelmo jaidemo, naimacɨna cɨoiñedɨmacɨ. Abɨdo billanona, llotɨmacɨ: ");
INSERT INTO huuNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","—Cárcel ie nase jaca ɨbaicana cɨodɨcaɨ. Raise llaveca. Nase fuemo jaca soldaduaɨ itɨmacɨ; iadedɨ econotɨcaɨmo, jaca buna cɨoiñedɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Jusiñamui jofo nanoca sedaraɨma, Jusiñamui dɨga ñaɨraɨnɨ dɨga, bie lluana cacajano, uainicaidɨmacɨ. Comecɨna facadɨmacɨ: “¿Nɨe isoide rafue naimacɨmo jai suide?” ");
INSERT INTO huuNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Iemo damɨe billanona, naimacɨna raite: —Cárcelmo jonega comɨnɨdɨ Jusiñamui jofomo jai itɨmacɨ. Comɨnɨna jai llofuetɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Iena cacajano, Jusiñamui jofo nanoca sedaraɨma ie policías dɨga jɨbuisaide. Cristo oretaganona atɨde. Fecuise atɨde, comɨnɨ dɨnena policíaɨaɨna nofɨcɨaɨdo faɨrɨnoi raillano. ");
INSERT INTO huuNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Naimacɨna atɨano, illaɨcomɨnɨ motomo jonetɨmacɨ. Iemei Jusiñamui dɨga nanoca ñaɨraɨma naimacɨmo llote: ");
INSERT INTO huuNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","—Omoɨmo Jesús rafuena llofuiana rairuidɨcaɨ; iadedɨ nana Jerusalén comɨnɨna jai llofuetomoɨ. Iese omoɨ llofuecabia, “Caɨ illaɨcomɨnɨ Jesúna meinetɨmacɨ” llotomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pedrodɨ jɨaɨe oretagano dɨga uai ote: —Jesús rafuena caɨ llofuiana jai rairuidomoɨ; iadedɨ omoɨ llua baɨfemo Jusiñamuina ɨɨnoiacadɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Caɨ usumatɨaɨ mɨcorɨaɨ Jusiñamuina sedauidɨmacɨ. Naie Jusiñamuidɨ Jesúna jai jillotate. Jesúna meinellena, cruzmo coraɨdomoɨ; ia Jesúna omoɨ meinia mei, ");
INSERT INTO huuNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Jusiñamuidɨ ie ecɨmo naimɨena jai itatate. Caɨ illaɨmana naimɨena jai itatate. Caɨ jilloitaraɨmana naimɨena jɨaɨ jai itatate. Caɨ judíuaɨ comɨnɨ comecɨaɨ iuai meidollena, naimacɨ jeacɨnuaɨ dotallena, iese naimɨena itatate. ");
INSERT INTO huuNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Bie rafuena llofuecabitɨcaɨ. Jusiñamui Joreño uaido iena jɨaɨ llofuetɨcaɨ. Jusiñamuina ɨɨnotɨnomo Jusiñamuidɨ ie Joreñona jai fecade —raite. ");
INSERT INTO huuNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Iena cacajano, illaɨcomɨnɨ eo icɨritɨmacɨ. Cristo oretaganona meineiacadɨmacɨ; ");
INSERT INTO huuNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","ia ieconi illaɨcomɨnɨ motomo damɨe naidaide. Naimɨe mamecɨ Gamaliel. Moisés mɨcorɨ llogacɨnona uiuicaide. Nana comɨnɨdɨ naimɨe uaina ɨɨnotɨmacɨ. Cristo oretaganona dallu baɨ oni oretajanona, naimɨe llote: ");
INSERT INTO huuNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","—Caɨmacɨ, omoɨ bie comɨnɨmo omoɨ fɨnolle rafuemo comecɨaɨna raise faca. ");
INSERT INTO huuNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Jaie Teudas mɨcorɨ illaɨmana jaiacade. “Jai uaina baitɨmɨedɨcue” raillano, naimɨe dɨbeimo cuatrocientos ɨiñɨaɨ jaidɨmacɨ. Iemei naimɨe fiodaite. Naimɨe mɨcorɨ dɨbeimo itɨnodɨ oni tuusɨte. Jai naie rafuedɨ jaca ieconi duide. ");
INSERT INTO huuNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Naimɨe mɨcorɨ illa mei, comɨnɨ mamecɨaɨna cuiana gobernador llua facaise, Galileo ie Judas mɨcorɨdɨ jobairiacade. Jɨaɨe comɨnɨ naimɨe dɨbeimo illena fuemo faɨte. Naimɨe jɨaɨ fiodaite. Naimɨe mɨcorɨ dɨbeimo itɨno oni tuusɨte. ");
INSERT INTO huuNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ie jira ja omoɨmo lloitɨcue: Bie comɨnɨna faɨnonocai. Jamai comɨnɨmona naimacɨ llogacɨno iade, jamai comɨnɨmona naimacɨ fɨnuacɨno iade, ieconi duite. ");
INSERT INTO huuNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Jusiñamuimona bie rafue ia, jaca nɨese nɨbaɨñeitomoɨ. Jusiñamuimona bie rafue ia, Jusiñamui dɨga omoɨ rafuedɨ iite. Naimacɨ naimɨe lluana feiñuano, ");
INSERT INTO huuNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Cristo oretagano fo atɨano, naimacɨna fatɨmacɨ. Naimacɨ Jesús rafuena llofuiana eo rairuide. Ie mei jino imacɨna oredɨmacɨ; ");
INSERT INTO huuNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","iadedɨ illaɨcomɨnɨ illanomona Cristo oretagano caɨmare jaidɨmacɨ. “Jesús dɨbeimo caɨ illa jira, caɨna duere fɨnodɨmacɨ” raillano, caɨmare jaidɨmacɨ. Jusiñamui naie facaise naimacɨna rɨidoñena jira, jɨaɨ caɨmare itɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Jusiñamui jofomo nagarui Jesucristo rafuena llofuetɨmacɨ. Comɨnɨ jofuemo nagarui jɨaɨ llofuetɨmacɨ. “Jesúdɨ caɨ Jilloitaraɨma” llofueuidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Naie facaise ailluena comɨnɨ creyentiaɨna jaidɨmacɨ. Uradoillamona griego uaido ñaɨte comɨnɨ dɨnena, judíuaɨ uaido ñaɨte comɨnɨna jeare ñaɨtɨmacɨ. Grieguaɨ fecɨñuaɨ judíuaɨ fecɨñuaɨ isoi nagarui rana feiñoñena jira, jeare ñaɨtɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ie jira naie doce oretaganodɨ creyentiaɨ danomo ofillena, nana naimacɨna uaidotɨmacɨ. Naimacɨmo llotɨmacɨ: —Jusiñamui uaina llollena, ra fecalle dɨga, abɨ juanide. Jusiñamui uaina llofuiana caɨ faɨnonocaiadedɨ, maraiñede. Ra jamai caɨ fecaiadedɨ, jɨaɨ maraiñede. ");
INSERT INTO huuNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ie jira, amatɨaɨ, omoɨmona siete dɨgamɨena feto. Ɨɨnoganona feto. Jusiñamui Joreño nana comecɨmo namatadɨnona feto. Eo abɨ uiñotɨnona feto. Ie isoide ɨiñɨaɨna feto. Bie ra fecaraɨnɨna maɨjɨitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ie mei caɨ abɨ juarenite, Jusiñamuimo caɨ jɨɨllena, Jusiñamui uaina caɨ llofuellena. ");
INSERT INTO huuNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Nana comɨnɨdɨ: —Jee —raitɨmacɨ. Esteban mɨcorɨna fetodɨmacɨ. Naimɨe Jusiñamuina eo ɨɨnote. Jusiñamui Joreño nana naimɨe comecɨmo namatade. Jɨaɨ fetodɨmacɨ: Felipe, Prócoro, Nicanor, Timón, Parmenas, Nicolás. Nicoládɨ Antioquía naɨraɨ imɨe. Judíuaɨ comɨnɨ isoi naimɨedɨ Jusiñamuina ɨɨnote. ");
INSERT INTO huuNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Fetua mei, oretagano dɨne atɨdɨmacɨ. Jusiñamuimo oretagano jɨɨa mei, fetocanomo imacɨ onollɨ jonetɨmacɨ, Jusiñamui naimacɨna marena itatallena. ");
INSERT INTO huuNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Naie facaise Jusiñamui uaidɨ comɨnɨdo uiñotacana jaide. Jerusalémo ailluena comɨnɨ creyentiaɨna jaidɨmacɨ. Jusiñamui dɨga ñaɨraɨnɨmona creyentiaɨna ailluena jɨaɨ jaisɨte. ");
INSERT INTO huuNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Esteban mɨcorɨ fue eo mare. Jusiñamui Joreño naimɨena namatajamona, naimɨe uai eo siño. Comɨnɨ motomo ailluena siño rafuena fɨnouide. ");
INSERT INTO huuNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Naie facaise daje judíuaɨ comɨnɨ ofiracomona damɨerie Esteban mɨcorɨ dɨne bitɨmacɨ. Patrón anamona jillobidɨnomo naie ofiraco jaɨnaɨaɨde. Naimacɨ dɨga damɨerie Cirene naɨraɨ imacɨ bitɨmacɨ. Damɨerie Alejandría naɨraɨ imacɨ danomo jɨaɨ bitɨmacɨ. Cilicia naɨraɨ imacɨ jɨaɨ bitɨmacɨ. Asia naɨraɨ imacɨ jɨaɨ bitɨmacɨ. Esteban coninɨ uaina uaitatɨmacɨ; ");
INSERT INTO huuNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","iadedɨ naimacɨ uaitalle uaidɨ iñede. Naimacɨmo Esteban uai isoidɨuaidɨ iñede. Jusiñamuimona ie uaina ua jira, Esteban abɨna uiñuano ñaɨte. ");
INSERT INTO huuNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ie jira jɨaɨe comɨnɨmo bainino ɨbajano, naimɨena llogɨdotadɨmacɨ. Raitɨmacɨ: —Esteban Moisés mɨcorɨ jɨnafomo jeare ñaɨana cacadɨcaɨ. Naimɨedɨ Jusiñamui jɨnafomo jeare ñaɨana jɨaɨ cacadɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Iese lluamona, comɨnɨ comecɨaɨna feidocana jaidɨmacɨ. Illaɨcomɨnɨ comecɨaɨna feidocana jɨaɨ jaidɨmacɨ. Esteban dɨne billanona, naimɨena gaɨtadɨmacɨ. Naie rafuena siadollena, naimacɨ ofiracomo naimɨe mɨcorɨna uitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Taɨnona llogɨdotɨnona jɨaɨ atɨdɨmacɨ. Llotɨmacɨ: —Bimɨedɨ Jusiñamui jofona jeare ñaɨcabite. Bimɨedɨ Moisés mɨcorɨ llogacɨno jɨnafomo jɨaɨ jeare ñaɨcabite. ");
INSERT INTO huuNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Naimɨedɨ Jesús bie jofona judaɨllena llote. Moisés mɨcorɨ caɨmo llogafuiaɨ faɨnonocaillena jɨaɨ llote. Iena cacadɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Iemo nana illaɨcomɨnɨ naimɨemo eruaɨdɨmacɨmo, naimɨe uieco Jusiñamui jaɨenicɨ isoi eruaɨde. ");
INSERT INTO huuNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Jusiñamui dɨga nanoca ñaɨraɨma Esteban mɨcorɨmo jɨcanote: —¿Ua ie isoi naimacɨ lluacɨno ite? ");
INSERT INTO huuNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Naimɨe uai ote: —Caɨmacɨ, cacarei. Caɨ jaiagaɨmona caɨ fueollena, naimacɨ mɨcorɨaɨna lloitɨcue. Jusiñamui maremɨena jira, naimɨedɨ caɨ eirue jitomo jaie bairede. Caɨ eirue jitodɨ Abraham mɨcorɨ. Mesopotamiamo naimɨe mɨcorɨ nia ia, Harámo naimɨe mɨcorɨ nia jaiñenia, Jusiñamuidɨ naimɨe mɨcorɨmo bairiano ");
INSERT INTO huuNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","llote: “O enɨruemona mai jai. O comɨnɨmona mai jai. Omo cue acatalle enɨruemo jaitɨo”. ");
INSERT INTO huuNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ie jira Caldea railla enɨruemona naimɨe mɨcorɨ jaide. Harámo rillanona, dɨga iruillaɨ nainomo ite. Naimɨe moo mɨcorɨ fiodailla mei, omoɨ birui illa enɨruemo Jusiñamui naimɨe mɨcorɨna oretate. ");
INSERT INTO huuNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Nainomo rillanona, Jusiñamuidɨ naie enɨrue naimɨe mɨcorimo fecañede. Ua janore jisa fecañede; iadedɨ: “Omo iena ɨco fecajitɨcue” raite. “O uruiaɨmo fecajitɨcue” jɨaɨ llote; iadedɨ naie facaise Abraham mɨcorɨ uruenide. ");
INSERT INTO huuNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Jusiñamui jɨaɨ llote: “O uruiaɨ jɨaɨe comɨnɨ enɨruemo jaianɨitɨmacɨ. Egiptomo jaianɨitɨmacɨ. Naimacɨna duere fɨnoitɨmacɨ. Cuatrocientos años llegɨ cacajitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Naimacɨna maɨjɨtaite naɨraɨna duere fɨnoitɨcue. Ie mei o uruiaɨ naie enɨruemona biitɨmacɨ. Bie illanomo cuemo iobillacɨnona fecajitɨmacɨ” llote. ");
INSERT INTO huuNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ie comɨnɨna naimacɨ jaillena, Jusiñamui Abraham mɨcorɨmo ɨisaɨaɨ dɨese abɨna diana llote. Ie facaise Abraham mɨcorɨ Isaac mɨcorɨna comuitate. Ie jeicɨamona ocho dɨgarui illamona, Abraham mɨcorɨ naimɨe mɨcorɨna dete. Isaac mɨcorɨ Jacob mɨcorɨna comuitate. Jacob mɨcorɨ doce uruiaɨna comuitate. Naimacɨ mɨcorɨaɨmona caɨ doce dɨga naɨraɨ comuidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","’Caɨmacɨ, José mɨcorɨna Jacob mɨcorɨ uruiaɨ mɨcorɨaɨ uradoillamona, Egipto comɨnɨmo naimɨena fecadɨmacɨ; ");
INSERT INTO huuNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","iadedɨ Jusiñamui naimɨena eo sedade. Ie llegɨ ie cacajamona naimɨena jillotate. Naimɨemo uiñoracɨnona fecade. Ie jira Faraón mɨcorɨ naimɨena jɨaɨ gaɨde. Faraón mɨcorɨdɨ Egipto illaɨma. Ie muidona Faraón Joséna fetode, nana Egiptomo itɨnona sedallena. Ie jofona jɨaɨ sedatate. ");
INSERT INTO huuNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Naie facaiseconi nana Egipto comɨnɨ aime guitɨmacɨ. Canaámo Jacob mɨcorɨ illanona, nana nainomo itɨno dɨga aime jɨaɨ guite. Eo duere sefuidɨmacɨ. Caɨ usumatɨaɨ mɨcorɨaɨ naimacɨ illanomo guillena baiñedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Egiptomo guille illana Jacob mɨcorɨ fɨdɨano, guille ollena, nano facaise ie uruiaɨ mɨcorɨna nainomo oretate. ");
INSERT INTO huuNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ie mei José ie amatɨaɨna naimɨena uiñotade. Faraóndɨ José comɨnɨ illana fɨdɨde. ");
INSERT INTO huuNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ie jira Josédɨ ie moona uaidote. Nana ie comɨnɨna uaidote. Setenta y cinco dɨgamɨe ite. ");
INSERT INTO huuNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ie jira Egiptomo Jacob mɨcorɨ jaide. Nainomo fiodaite. Ie uruiaɨ mɨcorɨaɨ nainomo jɨaɨ fiodaitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Siquem railla naɨraɨ illanomo naimacɨ comɨnɨ naimacɨ mɨcorɨaɨna uillano, nofɨcɨ ie raɨafomo jonetɨmacɨ. Siquemmo Abraham mɨcorɨ naifona Emmor uruiaɨ mɨcorɨaɨmona jaie ɨbade. ");
INSERT INTO huuNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","’Caɨmacɨ, Jusiñamui Abraham mɨcorɨmo lloga rafue suille iaɨrei illa facaiseconi, Egiptomo caɨ comɨnɨdɨ eo jebuidɨmacɨ. Abraham mɨcorɨmo: “Egiptomona o uruiaɨ biitɨmacɨ” Jusiñamui jaie llote. ");
INSERT INTO huuNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Naie facaise jɨaɨe illaɨma Egiptona sedade. José mɨcorɨna uiñoñede. ");
INSERT INTO huuNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ie jira caɨ comɨnɨna jɨfuiano maɨjɨtauide. Uruiaɨ fiodaillena, naimacɨna imacɨ uruiaɨna faɨnonocaitate. ");
INSERT INTO huuNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ie facaiseconi Moisés mɨcorɨ jeicɨga. Jusiñamuimona naimɨe mɨcorɨ eo ebire eruaɨde. Ie moo jofomo daje amani fɨvui ite. ");
INSERT INTO huuNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ie mei naimɨedɨ faɨnonocaiga. Faraón jisa mɨcorɨdɨ naimɨe mɨcorɨna uanona, naiñaiño jito isoi naimɨe mɨcorɨna uiuicaide. ");
INSERT INTO huuNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Naimɨe mɨcorɨ nana Egipto comɨnɨ uiñuacɨnona fueote. Illaɨma uai isoi naimɨe uaidɨ ite. Eo abɨna uiñotɨmɨe. ");
INSERT INTO huuNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","’Caɨmacɨ, naimɨe mɨcorɨ cuarenta años illa facai, ie comɨnɨ dɨne ie jaillemo ie comecɨna facade. Naimɨe comɨnɨdɨ caɨ judíuaɨ comɨnɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Egipto imɨemona damɨe llegɨ cacajana cɨuano, naimɨena rɨidote. Rɨiduanona, Moisés mɨcorɨdɨ Egipto imɨena meinete. ");
INSERT INTO huuNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moisés mɨcorɨ comecɨna facade: “Cue muidona Egiptomona Jusiñamuidɨ cue comɨnɨna oretaite”. “Cue comɨnɨ biena uiñotɨmacɨ” raillanona comecɨna facade; ie iadedɨ iena uiñoñedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ie aredɨruido Moisés mɨcorɨdɨ mena come iaɨmaiaɨ fuirillana cɨode. Iaɨmaiaɨna marena itataiacade. Raite: “¿Bue ñellena conimana duere fɨnoacadomɨco? ¿Bue ñellena o come dɨga fuiridomɨco?” ");
INSERT INTO huuNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Duere fɨnoacadɨmɨe naimɨena oni ñuitade. Jɨcanote: “¿Bu odɨ caɨ illaɨmana jonegao? ¿Bu caɨmo ona llotatate juez isoi? ");
INSERT INTO huuNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Na are Egipto imɨe o meinia isoi cuena jɨaɨ meineiacadɨo?” ");
INSERT INTO huuNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Iena cacajano, come fajana naimɨe llɨnua jira, jacɨnaillanona, Moisés mɨcorɨ aisɨde. Madián railla enɨruemo jamai ua illafuena ite. Dɨnomo ie aɨna ua mei, nainomo mena jitona comuitate. ");
INSERT INTO huuNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","’Caɨmacɨ, cuarenta años illa mei, jofue iñenanomo Moisés mɨcorɨ illanona, Jusiñamui jaɨenicɨ naimɨe mɨcorɨmo bairede. Sinaí railla anedu ianori ite. Amena boua isoi amenamo bairede. Naie boode amenadɨ fuiñede. ");
INSERT INTO huuNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Iena cɨuano, Moisés mɨcorɨ raijicaide. Naie iaɨreise naimɨe mɨcorɨ jɨbuisaidemo, naimɨemo Jusiñamui llote: ");
INSERT INTO huuNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“O usumatɨaɨ imacɨ Jusiñamuidɨcue. Abraham, Isaac, Jacob, imacɨ Jusiñamuidɨcue” llote. Jacɨnaillamona Moisés mɨcorɨ abɨ docaide. Jacɨruillanona, erodañede. ");
INSERT INTO huuNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Jusiñamui naimɨena raite: “Jamai bue o isoilla jira, o zapatona duiño. Benomo cue illa jira, o naidaillanodɨ eo mareno. ");
INSERT INTO huuNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Egiptomo cue comɨnɨ llegɨ cacajana raise cɨodɨcue. Naimacɨ duere sefuillana uiñotɨcue. Ie jira omo bairedɨcue, naimacɨna Egiptomona jilloitallena. Mai jai. Egiptomo ona oretaitɨcue” llote; ");
INSERT INTO huuNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","iadedɨ comɨnɨ dɨnena Moisés mɨcorɨna jaie jitaiñenamona, naimɨena raitɨmacɨ: “¿Bu illaɨmana odɨ jonegao? ¿Bu o juezna jonegao?” Comɨnɨ dɨnena naimɨena jitaiñedɨmacɨ; iadedɨ Jusiñamui naimɨena illaɨmana itatate. Naimɨena Egiptomona comɨnɨna jilloitaraɨmana jɨaɨ itatate. ");
INSERT INTO huuNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Egiptomona Moisés naimacɨna atɨde. Egiptomo nia ia, dɨga siño rafuena fɨnode. Jiaɨrede monaillai fuemo naimacɨ rillanona, siño rafuena jɨaɨ fɨnode. Jofue iñenanomo cuarenta años siño rafuena fɨnocana jaide. ");
INSERT INTO huuNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","’Caɨmacɨ, Moisés mɨcorɨdɨ caɨ judíuaɨ comɨnɨmo llote: “Omoɨmona Jusiñamuidɨ damɨena ie rafue lloraɨmana ɨco oretaite, naimɨe cuena oretaja isoi”. ");
INSERT INTO huuNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Jofue iñenanomo naimacɨ ia, Moisés Jusiñamui jaɨenicɨ dɨga anedumo ñaɨte. Anedu mamecɨdɨ Sinaí. Iemei caɨ usumatɨaɨ mɨcorɨaɨ dɨga naie jaɨenicɨ facaina Moisés ñaɨte. Caɨmo fecallena, naimɨedɨ comɨnɨna itatate uaina feiñote; ");
INSERT INTO huuNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","iadedɨ caɨ usumatɨaɨ mɨcorɨaɨ naimɨena ɨɨnoiacaiñedɨmacɨ. Naimɨena jitaiñedɨmacɨ. Egiptomo abɨdo jaillemo naimacɨ comecɨaɨ facadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ie jira comɨnɨ dɨnena Aarón mɨcorɨmo llotɨmacɨ: “Egipto enɨruemona Moisés caɨna atɨde; iadedɨ naimɨe caɨ dɨga illana ja uiñoñedɨcaɨ. Caɨ facaina Jusiñamuina eruaɨde jiraraɨna fɨno, Egiptomo abɨdo caɨna ɨfollena”. ");
INSERT INTO huuNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Iemo jurareta urue joreñona fɨnodɨmacɨ. Iena sedallena, faga toɨca ocainaɨaɨna fecadɨmacɨ. Naimacɨ fɨnoca rafueri eo caɨmataidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ie jira Jusiñamui naimacɨmona oni jaillanona, naimacɨna faɨnonocaide. Iemona jitomana sedauidɨmacɨ. Fɨvuina jɨaɨ sedauidɨmacɨ. Ucuaɨna jɨaɨ sedauidɨmacɨ. Jusiñamui rafue lloraɨma ie rabenicomo biena jaie iese cuega: Jusiñamui llote: “Judíuaɨ imacɨ, cuarenta años jofue iñenanomo omoɨ ia, cuemo omoɨ faga toɨca ocainaɨaɨ fecañedomoɨ; ");
INSERT INTO huuNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","iadedɨ cuemo omoɨ comecɨaɨna facañeno Moloc railla jiraraɨna sedadomoɨ. Refán railla ucuduna jɨaɨ sedadomoɨ. Naimacɨna sedallena, jiraraɨna fɨnodomoɨ. Ie jira Babilonia naɨraɨ baɨfemo omoɨna oretaitɨcue” cuega. Naie facaise caɨ usumatɨaɨ mɨcorɨaɨ Jusiñamuina jitaiñedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","’Caɨmacɨ, bie rafuena caɨ fueollena, caɨ usumatɨaɨ mɨcorɨaɨ motomo Jusiñamui illana lloitɨcue. Jofue iñenanomo caɨ usumatɨaɨ mɨcorɨaɨ motomo daje jofo aillocona nitɨmacɨ. Nainomo Jusiñamuina sedallena, Jusiñamui Moisés mɨcorɨmo acataja isoi, iena nitɨmacɨ. Jusiñamui jaie cuega nofɨcɨdɨ naicomo eenoga. ");
INSERT INTO huuNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Josué dɨga bie enɨruemo naimacɨ billa facaise, caɨ usumatɨaɨ mɨcorɨaɨ naicona atɨdɨmacɨ. Bie enɨrue jɨaɨe naɨraɨaɨmo jaɨnaɨaɨde; iadedɨ Jusiñamui naie naɨraɨaɨna dotajano, caɨ usumatɨaɨ naie enɨruena baɨrodɨmacɨ. Naico nainomo ite David mɨcorɨ facaiseconi. ");
INSERT INTO huuNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Jusiñamui David mɨcorɨna eo canode. Ie jira David mɨcorɨdɨ caɨ usuma Jacob mɨcorɨ ie Jusiñamui jofona fɨnollena jɨcanote: ");
INSERT INTO huuNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","ia Salomón mɨcorɨdɨ jofona Jusiñamui iena fɨnode; ");
INSERT INTO huuNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","iadedɨ Jusiñamuidɨ ɨima fɨnoca jofomo i-iñede. Jusiñamui facaina lloraɨma mɨcorɨdɨ Jusiñamuina iese cuete: ");
INSERT INTO huuNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","50","Caɨ Nama raite: “Monamo cue illamona, nana comɨnɨ cue anamo itɨmacɨ. Jafaicɨ otɨcuedena, naga rana cue fɨnua jira, nainomo cuena omoɨ sedallena, nɨe isoide jofona omoɨ fɨnuana jitaiñedɨcue” raite. ");
INSERT INTO huuNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","’Ero, omoɨ comecɨaɨ jaɨaɨrede. Omoɨ comecɨ ɨɨnoñede. Jefonidomoɨ isoidomoɨ. Ie jira Jusiñamui Joreño anamo iacaiñedomoɨ. Omoɨ usumatɨaɨ mɨcorɨaɨ isoi itomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Omoɨ usumatɨaɨ mɨcorɨaɨdɨ nana Jusiñamui rafue lloraɨma mɨcorɨaɨna duere fɨnodɨmacɨ. Mareuidɨmɨe billena llotɨnona meinetɨmacɨ. Mareuidɨmɨena gaɨtatatomoɨ. Naimɨena jai meinetomoɨ. Jesúna ñaɨtɨcue. ");
INSERT INTO huuNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Jusiñamui jaɨenicɨaɨmona Moisés mɨcorɨ llogacɨnona feiñotomoɨ; iadedɨ iena ɨɨnoñedomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Esteban llofuiana naimacɨ cacajano, eo icɨritɨmacɨ. Icɨrillamona, isiduaɨ muru-muru raite. ");
INSERT INTO huuNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Jusiñamui Joreño nana Esteban mɨcorɨ comecɨmo namatajamona, monamo eruaɨllano, naimɨedɨ Jusiñamui ebirenana cɨode. Naimɨedɨ Jusiñamui nabeimo Jesús naidaillana cɨode. ");
INSERT INTO huuNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Raite: —Mona ecuaɨllana cɨodɨcue. Jusiñamui Jito Jusiñamui nabeimo naidaillana cɨodɨcue. ");
INSERT INTO huuNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Esteban lluana cacajano, jefo oroisɨte. Eo cuiriillano, naimɨe dɨne aisɨcaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Jerusalémona naimɨena jino dotadɨmacɨ. Naimacɨmo ite emodomo itɨroina duiñuanona, Saulo railla conirue ecɨmo ɨniroina jonesɨde. Iemei Estebana nofɨcɨdo faɨrɨnosɨde. ");
INSERT INTO huuNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Estebana nofɨcɨ dɨga faɨrɨnuano, Estebadɨ Jusiñamuimo ado jɨɨde: —Cue Nama Jesús, cue joreño feiño. ");
INSERT INTO huuNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ieconi caiñɨcɨ ɨfodo raɨnadacaida ado jɨɨde: —Naimacɨ bie jeacɨno fɨnua muidona, ɨbana oñeno. Iese naimɨe jɨɨa mei, fiodaite. ");
INSERT INTO huuNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Saulo dɨnena Esteban meiniana jɨaɨ jitaide. Cristo rafuena eo ɨɨnotɨnomona damɨerie Esteban mɨcorɨ raɨafomo jonetɨmacɨ. Eiamona naimacɨmo uillɨnocɨ eo ite. Nairui Jerusalémo ite creyentiaɨ duere sefuilla facaiseconi taɨnede. Nana comɨnɨ tuficaida jaidɨmacɨ. Judea railla enɨruemo jaidɨmacɨ. Jɨaɨnodɨ Samaria railla enɨruemo jaidɨmacɨ; iadedɨ Cristo oretagano nɨne jaiñedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ie facaiseconi Saulodɨ creyentiaɨna eo duere fɨnode. Dɨga jofomo jamai jaillano, ɨiñɨaɨna gaɨtade, cárcelmo jonellena. Rɨñonɨaɨna jɨaɨ gaɨtade. ");
INSERT INTO huuNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Tuficaida jaidɨno naga illanomo Jesús rafuena llocana uitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Samariamo Felipedɨ daje naɨraɨmo jaide. Nainomo Cristo rafuena llofueuide. ");
INSERT INTO huuNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ailluena comɨnɨdɨ Felipe llofuiana eo raise feiñotɨmacɨ, naimɨe siño rafuena fɨnua jira. ");
INSERT INTO huuNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Felipedɨ dɨga jananɨaɨ anamo ite comɨnɨmona jananɨaɨna oretate. Rɨire cuirioillano, jaidɨmacɨ. Ailluena tɨsitaitɨnona jillotate. Ailluena ñuja-ñujacaidɨnona jɨaɨ jillotate. ");
INSERT INTO huuNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ie jira naie naɨraɨmo ite comɨnɨ eo iobidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Naie naɨraɨmo Simóna mamecɨredɨmɨe ite. Naimɨe siño rafuena fɨnouide. Iemona Samaria comɨnɨna raijicaitade. Naimɨe raite: —Siñomɨedɨcue. ");
INSERT INTO huuNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Nana comɨnɨ naimɨena ɨɨnotɨmacɨ. Abɨna uiñoñedɨno ɨɨnotɨmacɨ. Abɨna uiñotɨno jɨaɨ ɨɨnotɨmacɨ. Raitɨmacɨ: —Naimɨe uaidɨ Jusiñamui ie. Naimɨedɨ siño jito —raitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Iese naimacɨna are jɨfuete. Naimacɨ raijicailla jira, naimacɨ naimɨena cacadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ie mei Felipe Cristo ie mare rafuena llote. Naimɨe anamo naimacɨ illana Jusiñamui jitailla jira, Jusiñamui dɨbeimo naimacɨ comecɨaɨ iuaina meiduana llote. Naimacɨ Felipe llofuiana ɨɨnotɨmacɨ. Ɨɨnuamona, Felipe naimacɨna bautizade. Ɨiñɨaɨna bautizade. Rɨñonɨaɨna jɨaɨ bautizade. ");
INSERT INTO huuNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","—Jɨaɨ ɨɨnotɨcue —Simóndɨ raite. Naimɨe bautizaja mei, Felipe dɨga jaioicaide. Felipedɨ dɨga siño rafuena fɨnua jira, Simón naiena cɨuano, raijicaide. ");
INSERT INTO huuNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Jerusalémo ite Cristo oretaganodɨ, Samaria comɨnɨ Jusiñamui uaina feiñuana cacajano, Pedro, iaɨmaiaɨ Juan dɨga, batɨne oredɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Iaɨmaiaɨ rillano, naimacɨ Jusiñamui Joreñona feiñollena Jusiñamuimo jɨɨdɨaɨmaiaɨ, ");
INSERT INTO huuNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","naimacɨmo Jusiñamui Joreño nia iñena jira. Caɨ Nama Jesús facaina jai bautizadɨmacɨ; ia Jusiñamui Joreñona nia feiñoñedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ieconi iaɨmaiaɨ onollɨ naimacɨmo joniano, Jusiñamui Joreñona feiñotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Naimacɨ Jusiñamui Joreño feiñuana Simóndɨ cɨuano, ucubena iaɨmaiaɨmo fecaacade. ");
INSERT INTO huuNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Raite: —Cuemo omɨco uaina ine, bumo cue onollɨna cue joniamona, naimɨe Jusiñamui Joreñona feiñollena. ");
INSERT INTO huuNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Pedro dɨnena uai ote: —O ucube dɨga o faɨfisa. Ucube dɨga Jusiñamui fecaca uaina ɨbaacadɨo; iadedɨ Jusiñamui naiena jamai fecade. ");
INSERT INTO huuNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Bie rafuedɨ omo duiñede. Jusiñamuimona o comecɨ nia maraiñede. ");
INSERT INTO huuNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","O comecɨ iuai meido. Naimɨe o comecɨmo ite maraiñede facajacɨnuaɨna oni dotallena, caɨ Namamo jɨca. ");
INSERT INTO huuNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Omo ailluena maraiñedɨcɨno illana uiñotɨcue. O comecɨ eo uradoide. Maraiñedɨcɨnona o comecɨmo namaredɨo. ");
INSERT INTO huuNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simón uai ote: —O llua cuemo suiñellena, o Nama dɨga cue facaina ñaɨno. ");
INSERT INTO huuNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Cristo rafuena iaɨmaiaɨ llua mei, Jerusalémo abɨdo bitɨiaɨmaiaɨ. Abɨdo billano, Samariamo dɨga comɨnɨ illanuaɨmo Jesús ie mare rafuena llocana bitɨiaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Naie facaise Jusiñamui jaɨenisaɨmona damɨe Felipemo llote: —Beicɨdo joide naɨdo mai jai. Jerusalémona Gazamo joide naɨsona jai —llote. Naie naɨso jofue iñenanodo joide. ");
INSERT INTO huuNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Ie jira jaide. Jusiñamuina sedajamona, naie facaise Etiopía enɨrue imɨe Jerusalémona bite. Etiopía illaɨño dɨga maɨjɨuide. Naiñaiño mamecɨdɨ Candace. Naimɨedɨ nana naiñaiño gobierno ucubena sedade. ");
INSERT INTO huuNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Naimɨe jai abɨdo jaillano, ie carretamo raɨta, Isaías mɨcorɨ cuega rabenicona ado facade. ");
INSERT INTO huuNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Jusiñamui Joreño Felipemo llote: —Naimɨe dɨne iaɨrei jai. Carreta dɨne jai. ");
INSERT INTO huuNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Naimɨe dɨne Felipedɨ aisɨcana jaillanona, rabe ado facajana cacade. Felipe dɨnena naimɨemo jɨcanote: —¿O facaca rabenicona uiñotɨo? ");
INSERT INTO huuNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Naimɨe uai ote: —¿Nɨese uiñoitɨcue, bu cuena canoñenia? Felipemo jɨcanote, naimɨe dɨga a jaillano danomo raɨllena. ");
INSERT INTO huuNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Naimɨe facaca cuegafue iese raite: Toɨca llauda fallena uilla isoi, naimɨena uitɨmacɨ. Toɨca llauda itɨraɨ garedɨno dɨne eeñena isoi, naimɨe ñaɨñede. Ie abɨna rɨidollena, uaina oñede. ");
INSERT INTO huuNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Maraiñede rafuena naimɨe fɨnoñede; ia naimɨena duere fɨnodɨmacɨ. Naimɨe uruiaɨ iñededɨ, ¿bu naimɨe rafuena lloite? Meinia meinoconi, naimɨe jai iñede. ");
INSERT INTO huuNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Etiopía imɨe Felipemo jɨcanote: —¿Bie lloraɨma bu iena llote? ¿Dama naimɨe iena llote? ¿Jɨaɨmɨena iena llote? Cuemo llono. ");
INSERT INTO huuNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Iemei Felipedɨ bie cuegafuiamona naimɨemo Jesús ie mare rafuena llote. ");
INSERT INTO huuNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Naɨsona jaidɨiaɨmaiaɨmo, jɨnui illanomo ridɨiaɨmaiaɨ. Etiopía imɨe dɨnena raite: —Ero, bie jɨnui itemo, ¿bue ñe cuedɨ bautizañellɨcue? ");
INSERT INTO huuNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Felipe uai ote: —O comecɨmona o ɨɨnoia, cuemona mare. Naimɨe uai ote: —Jesucristodɨ Jusiñamui Jitonana ɨɨnotɨcue. ");
INSERT INTO huuNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Naimɨe ie carreta jorodate. Iemei jɨnui dɨne jaidɨiaɨmaiaɨ. Felipedɨ naimɨena bautizade. ");
INSERT INTO huuNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Jɨnuimona iaɨmaiaɨ bia, Jusiñamui Joreño Felipena oni uite. Etiopía imɨe Felipena dane cɨoiñede; iadedɨ Etiopía imɨe iobicana jaide. ");
INSERT INTO huuNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Jusiñamui Joreño Azotomo Felipena uite. Cesarea dɨne naimɨe jaillanona, naga naɨraɨaɨmo Jesús ie mare rafuena llocana uite. Ie mei Cesareamo ride. ");
INSERT INTO huuNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Naie facaise Saulo caɨ Nama Cristona ɨɨnotɨnona eo duere fɨnoacade. Icɨrillamona, naimacɨna meineiacade. Ie jira Jusiñamui dɨga nanoca ñaɨraɨma dɨne jaide. ");
INSERT INTO huuNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Judíuaɨ comɨnɨ naie ñaɨraɨma anamo illamona, creyentiaɨna duere fɨnollena, Saulo cartana naimɨemo jɨcajaide. Damascomo ite judíuaɨ ofiracuaɨmo dajerie cartana uiacade. Naie ofiracuaɨ sedaraɨnɨ naimɨe canollena jitaide. Jesucristona ɨɨnotɨnona naimɨe baia, naimacɨna gaɨtajano, Jerusalémo atɨllena, naimɨena canollena, cartana jitaide. Ɨiñɨaɨ baia, rɨñonɨaɨ baia, naimacɨna Jerusalémo atɨacade. ");
INSERT INTO huuNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Cartana ua mei, naimɨe jaillano, Damascomo iaɨre ia, ieconi monamona damɨe naimɨe abɨna quetiñote. ");
INSERT INTO huuNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Enɨruemo naimɨe ana uaillano, monamona damɨe naimɨemo lluana cacade: —Saulo, Saulo, ¿bue ñellena cuena duere fɨnodɨo? ");
INSERT INTO huuNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Naimɨe uai ote: —¿Budɨo? Monamona damɨe raite: —Jesúdɨcue. Cuena duere fɨnodɨo. Iemona o abɨna duere fɨnodɨo, rɨicaillamona raise maɨga jurareta suiñoacana isoi. Ie isoidɨo. Rɨicaillamona, cuena duere fɨnoacadɨo. ");
INSERT INTO huuNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Naidacai. Damascomo mai jai. Nainomo o fɨnolle rafue omo lloitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Saulo dɨga jaidɨnodɨ ñaɨñeno naidaidɨmacɨ. Naie uaina cacadɨmacɨ; iadedɨ buna cɨoiñedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Ieconi Saulo naidacaide. Ie uisɨ ecoricaillamona, erodatemo, jai buena cɨoiñede. Ie onollɨna llɨnocaida, naimɨena Damascomo uitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Darui amani cɨoiñede. Jusiñamuimo comecɨna facajamona, guiñede. Jɨaɨ jiroñede. ");
INSERT INTO huuNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damascomo Ananíana mamecɨredɨmɨe ite. Naimɨedɨ creyente. Ɨnɨñenamona, Ananías nɨcaɨrilla isoi cacaillena, Cristodɨ naimɨemo rafuena llote: —Ananías. Naimɨe uai ote: —Jɨɨ, bene itɨcue. ");
INSERT INTO huuNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Caɨ Nama Cristo naimɨemo llote: —Naidacai. Atona joide railla naɨsona jai. Judas ie jofomo jai. Naicomo Tarso ie Saulona jɨcano. Naimɨe cuemo jai jɨɨde. ");
INSERT INTO huuNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Naimɨe damɨena jai nɨcaɨrite isoide. Ananíana mamecɨredɨmɨena nɨcaɨrite isoide. Ona nɨcaɨrite isoide. Naimɨe dɨne o jaillena ona nɨcaɨrite isoide. Naimɨemo o onollɨ joniamona, naimɨe dane cɨuana nɨcaɨrite isoide. ");
INSERT INTO huuNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananías uai ote: —Nama, dɨga comɨnɨmona naimɨena fɨdɨdɨcaɨ. Jerusalémo naimɨedɨ maraiñede rafuena ona ɨɨnotɨnomo fɨnode. ");
INSERT INTO huuNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Jusiñamui dɨga nanoca ñaɨraɨma uai naimɨemo ite, nana bene ite creyentiaɨna gaɨtallena. ");
INSERT INTO huuNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Caɨ Nama naimɨemo llote: —Mai. Naimɨe jai cue fetoca, judíuaɨñedɨnomo cue rafuena llollena, illaɨcomɨnɨmo cuena llollena, judíuaɨ comɨnɨmo cue rafuena jɨaɨ llollena. ");
INSERT INTO huuNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Cuena naimɨe jai ɨɨnua muidona, naimɨe nɨe isoi llegɨ cacajite. Naimɨemo iena lloitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ie jira Ananías naie jofomo jaide. Ie onollɨ Saulomo joniano, raite: —Saulo, jai cue amana jai itɨo. Naɨsomo caɨ Nama Jesús omo jai bairede. Naimɨe cuena o dɨne orede, dane o cɨoillena, Jusiñamui Joreño nana o comecɨmo namatallena. ");
INSERT INTO huuNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ieconi Saulo uisɨmona llɨcɨaɨ ico isoide ra uaide. Dane cɨuana, naidaide. Ie mei jai bautizaga. ");
INSERT INTO huuNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ie mei jai guite. Dane maɨride. Dɨga irui Damascomo ite creyentiaɨ dɨga naimɨe ite. ");
INSERT INTO huuNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Judíuaɨ ofiracomo naimɨe jaillanona, Jesús ie rafuena llofuete. “Jesúdɨ Jusiñamui Jito” raillanona llofuete. ");
INSERT INTO huuNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Nana naimɨena cacadɨnodɨ raijicaide. Raitɨmacɨ: —Bimɨe Jerusalémo Jesúna ɨɨnotɨnona duere fɨnouide. Naimacɨna gaɨtallena, Jusiñamui dɨga nanoca ñaɨraɨnɨmo uillena, naimɨe bene bite; ia Jesús dɨbeimo jai ite. ");
INSERT INTO huuNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Saulo nagarui jacɨtaiñeno llofuiamo fɨbioicaide. Llofueuide: —Jesúdɨ caɨ Jilloitaraɨma. —Naimɨe raise llofuia jira, judíuaɨ dɨnena iena uaitanidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Dɨgarui illa mei, judíuaɨ comecɨaɨna facadɨmacɨ, naimɨena meinellena. ");
INSERT INTO huuNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Naimɨe aisɨi raillano, aremona naɨraɨ nasiaɨna sedadɨmacɨ. Naɨona nasiaɨna jɨaɨ sedadɨmacɨ, naimɨena meinellena; iadedɨ Saulo iena fɨdɨano, ");
INSERT INTO huuNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","naɨona creyentiaɨ naimɨena oni uitɨmacɨ. Naimɨe jillobillena, llaɨgafo jinofebeimo cɨrɨgaɨmo raɨnajanona, naimɨena ana ñuitadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Jerusalémo naimɨe jaide. Naimɨe ria, creyentiaɨna nabaiacade; ia naimɨena jacɨruitɨmacɨ. Creyentena naimɨe jaillana ɨɨnoñedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ie jira Bernabé naimɨena Cristo oretagano dɨne uillano, naimacɨmo naɨso motomo Saulo caɨ Namana cɨuana llote. Naɨso motomo caɨ Nama Saulomo lluana jɨaɨ llote. Damascomo naimɨe ia, Jesúna jacɨtaiñeno llofuiana jɨaɨ llote. ");
INSERT INTO huuNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ie jira Saulona nabaidɨmacɨ. Jerusalémo jaisoillanona, caɨ Nama ie rafuena jacɨtaiñeno lloouide. ");
INSERT INTO huuNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Iena cacajanona, griego uaina ñaɨte judíuaɨdɨ naimɨe llofuiana uaitatɨmacɨ. Naimɨena meineiacadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Creyentiaɨ iena fɨdɨano, Cesareamo Saulona uitɨmacɨ. Ie mei Tarsomo naimɨena oredɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Judeamo, Galileamo, Samariamo nana creyentiaɨ uri itɨmacɨ. Caɨ Namana ɨɨnocana jaidɨmacɨ. Caɨ Namana jacɨruioicaida jaidɨmacɨ. Jusiñamui Joreño naimacɨ comecɨaɨna eo ocuiñotade. Ailluena comɨnɨ creyentiaɨna jaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Naie facaise dɨga illanuaɨmo Pedro macarite. Lidamo ite creyentiaɨ dɨne ride. ");
INSERT INTO huuNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Nainomo damɨe bɨiramo bɨidena cɨode. Naimɨedɨ Eneas. Ocho años tɨsitaillamona bɨide. ");
INSERT INTO huuNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Naimɨena cɨuano, Pedro naimɨemo llote: —Eneas, Jesucristo ona jai jillotate. Mai naidacai. O bɨira ferɨ. —Ieconi naimɨedɨ naidadate. ");
INSERT INTO huuNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Nana Lidamo ite comɨnɨ, nana Sarónmo ite comɨnɨ dɨga, naimɨena jilluana cɨuanona, creyentiaɨna jaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Jopemo Tabitana mamecɨredɨñaiño ite. Griego uaimona oni dobaiñuamona naie mamecɨ Dorcas. Naiñaiño creyente. Ailluena mare rafuena fɨnouide. Ailluena duerede comɨnɨna canouide. ");
INSERT INTO huuNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Naie facaise naiñaiño duicotaide. Ie mei fiodaite. Naimacɨ einamacɨ fɨnua isoi, ie nabaiñɨaɨ naiñaiño abɨna jocodɨmacɨ. Iemei aneba ie cuartomo naiñaiñona jonetɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lidamona Jope iaɨre ite. Pedro Lidamo creyentiaɨ illana fɨdɨano, menamɨe naimɨe dɨne oredɨmacɨ. Iaɨmaiaɨna llotatatɨmacɨ: —Buena sedañeno caɨ dɨne raɨre bi. ");
INSERT INTO huuNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Ie jira Pedro naidacaida, naie iaɨmaiaɨ dɨga jaide. Naimɨe ria, aneba ie cuartomo naimɨena uitɨmacɨ. Nana fecɨñuaɨ Pedro ecɨmo eecana naidaidɨmacɨ. Dorcas fɨnouiga ɨniroina naimɨemo acatatɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Dorcas fɨnouiga rafuena Pedro fɨdɨano, Pedro nana naimacɨna jino orede. Caiñɨcɨ ɨfodo naimɨe raɨta, Jusiñamuimo jɨɨde. Abɨdo dobaicaida, naiñaiñomo erodate. Raite: —Tabita, mai raɨnaicai. Ieconi naiñaiño uisɨ oni erodate. Pedrona cɨuano, a raɨnadate. ");
INSERT INTO huuNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Naiñaiño onollɨ llɨnuanona, a naidanete. Ie mei Pedrodɨ fecɨñuaɨna, jɨaɨe creyentiaɨ dɨga, uaidote, naiñaiño jai cajenana naimacɨ cɨoillena. ");
INSERT INTO huuNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Nana Jopemo ite comɨnɨ naie rafuena fɨdɨdɨmacɨ. Ie jira ailluena comɨnɨ caɨ Namana ɨɨnotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Jopemo Pedro dɨga irui Simón jofomo ite. Simóndɨ ocaina igoɨna cuidoraɨma. ");
INSERT INTO huuNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Cornelio raillamɨedɨ Cesareamo ite. Naimɨedɨ capitán. Italiamona bite soldaduaɨ naimɨe anamo itɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Naimɨedɨ Jusiñamui llogacɨnodo jaide. Nana ie comɨnɨ dɨga Jusiñamuina ɨɨnote. Judíuaɨ comɨnɨmo ailluena rana jamai fecauide. Jusiñamuimo jɨɨuide. ");
INSERT INTO huuNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Jitoma ana ia, naimɨemo jai nɨcaɨrilla isoi ite. Naimɨedɨ Jusiñamui jaɨenicɨna naimɨe dɨne billana cɨode. Jaɨenicɨdɨ uaidote: —Cornelio. ");
INSERT INTO huuNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Naimɨena Cornelio jacɨruioicaida eruaɨde. Jɨcanote: —Nama, ¿buena jitaidɨo? Naimɨe uai ote: —Jusiñamui o jɨɨacɨnuaɨna jai cacade. Jusiñamuidɨ duerede comɨnɨna o canuana jɨaɨ feitañede. ");
INSERT INTO huuNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Mai, Jopemo damɨerie o mullaɨaɨmona oreta, Simón raillamɨena atɨllena. Naimɨe jɨaɨe mamecɨdɨ Pedro. ");
INSERT INTO huuNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Naimɨedɨ igoɨ cuidoraɨma jofomo ite. Naie cuidoraɨma mamecɨdɨ Simón. Monaillai fuemo naimɨe jofo ite. ");
INSERT INTO huuNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Jusiñamui jaɨenicɨ jailla mei, Corneliodɨ ie mullaɨaɨmona mena uaidote. Naimɨe anamo ite soldaduaɨmona damɨe jɨaɨ uaidote. Naie soldadodɨ Jusiñamuina jɨaɨ ɨɨnote. ");
INSERT INTO huuNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Nana naimɨemo Jusiñamui jaɨenicɨ lluana naimacɨmo llua mei, Jopemo oretate. ");
INSERT INTO huuNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ie are naimacɨ jaillano, Jopemo ianori riacanano, jitoma naidai ia, jofo emodomo Pedro jaide, Jusiñamuimo jɨɨllena. ");
INSERT INTO huuNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Naimɨe aimetaite. Guiacade. Guillena comɨnɨ fɨnodemo, naimɨemo nɨcaɨrilla isoi ite. ");
INSERT INTO huuNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Mona oni econuana cɨode. Aillue sábana isoi, buena ana billana cɨode. Enɨruemo naga muiduedo maɨgado ana bite. ");
INSERT INTO huuNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Naiemo jɨaɨforie eruaɨde ocainaɨaɨ ite. Dɨga enɨruemo jorode ranɨaɨ ite. Dɨga nuicɨnɨaɨ jɨaɨ ite. Nana Moisés mɨcorɨ fɨmaidoga rɨlle radɨ ite. ");
INSERT INTO huuNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Naimɨedɨ monamona damɨe lluana cacade: —Pedro, naidacaida, fajano, biena rɨno. ");
INSERT INTO huuNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pedro uai ote: —Nama, dama ite. Moisés mɨcorɨ fɨmaidoga rɨlle rana jaca rɨñedɨcue. ");
INSERT INTO huuNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Monamona damɨe lluana dane cacade: —Jusiñamui jai fɨmaidoñede. Ie jira iese lloñeno. ");
INSERT INTO huuNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Dacaiño amani iese suide. Ie mei naie radɨ monamo abɨdo jaide. ");
INSERT INTO huuNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pedro ie comecɨna facade: “¿Nɨese illana cɨodɨcue?” Ie daacaiño Cornelio oretagano bite. Simon illa jofo jɨcanuano, naie nasemo ride. ");
INSERT INTO huuNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Simón Pedrona naie jofomo illana jɨcanotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pedro ie nɨcaɨrillana isoidemo comecɨna facajano, Jusiñamui Joreño naimɨemo llote: —Ero, daje amani ɨima ona jenode. ");
INSERT INTO huuNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Naidacaida, ana jai. Naimacɨ dɨga buena sedañeno mai jai. O dɨne naimacɨna oredɨcue. ");
INSERT INTO huuNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Pedrodɨ comɨnɨ dɨne ana jaide. Raite: —Omoɨ jenocamɨedɨcue. ¿Bue ñiaɨbitomoɨ billa? ");
INSERT INTO huuNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Uai otɨmacɨ: —Cornelio raillamɨe anamo itɨcaɨ. Corneliomo Jusiñamui jaɨenicɨ birui llote: “Pedro dɨne damɨeriena oreta, naimɨena o jofomo atɨllena. Jusiñamui rafuena raise cacaillena, naimɨena atɨ” llote. Corneliodɨ capitán. Naimɨedɨ mareuidɨmɨe. Jusiñamuina ɨɨnotɨmɨe. Nana judíuaɨ comɨnɨ dɨnena naimɨedɨ mareuidɨmɨe. ");
INSERT INTO huuNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Iena Pedro cacajano, naimɨe jofomo ɨnɨllena naimacɨna fo uaidote. Ie are naimacɨ dɨga jaide. Damɨerie Jopemo ite creyentiaɨ naimɨe dɨga jɨaɨ jaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ie are Cesareamo ridɨmacɨ. Cornelio naimacɨ billemo ocuiride. Nana ie comɨnɨna jai uaidote. Ie nabaiñɨaɨ jɨaɨ jai uaidote. ");
INSERT INTO huuNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pedro fo jaia, Cornelio dɨnena naimɨena uaidote. Pedro anamo bɨtadate, Jusiñamuimo fecaja isoi Pedromo iobillacɨnona fecallena. ");
INSERT INTO huuNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Pedrodɨ naimɨena a naidanete. Raite: —Mai a naidada. Cue jɨaɨ jamai ɨimadɨcue. ");
INSERT INTO huuNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Naimɨe dɨga ñaɨano fo jaidɨiaɨmaiaɨ. Ailluena comɨnɨ ofillana cɨode. ");
INSERT INTO huuNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Naimacɨmo llote: —Moisés mɨcorɨ judío imɨe judíuñedɨmɨe nabairillana rairuide. Iena uiñotomoɨ. Judíuñedɨmɨe jofomo illana jɨaɨ rairuide. Ie areruido Jusiñamui nɨcaɨrilla isoidɨfuena cuemo acatate. Iemona jai fueotɨcue. Jɨaɨe naɨraɨ dɨga cue nabairillena, Jusiñamuimona marenana jai uiñotɨcue. Jusiñamui omoɨna cue jearuillana jai jitaiñede. ");
INSERT INTO huuNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ie jira buena sedañeno bitɨcue, cuena o uaidua jira. ¿Bue ñellena cuena uaidotomoɨ? Cuemo llono. ");
INSERT INTO huuNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Cornelio uai ote: —Nairui nagaamagarui illa meinomo, bie hora cue jofomo Jusiñamuimo jɨɨdɨcue. Ieconi Jusiñamui jaɨenicɨ cuemo bairede. Naimɨe ɨniroi quenirede. ");
INSERT INTO huuNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Cuena raite: “Jusiñamui o jɨɨana cacade. Naimɨedɨ duerede comɨnɨna o canuana feitañede. ");
INSERT INTO huuNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Ie jira Jopemo damɨeriena oreta, Simón Pedrona uaidollena. Jɨaɨe Simón jofomo ite. Simóndɨ igoɨ cuidoraɨma. Ie jofo monaillai fuemo ite”. ");
INSERT INTO huuNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Iemona ona uaidotɨcue. O comecɨ marena jira, bene bitɨo. Jai nana bene itɨcaɨ. Jusiñamui caɨ dɨga jɨaɨ ite. Caɨ Nama nana omo lluana cacareillena, bene itɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Pedro uai ote: —Jusiñamui nana comɨnɨ naimɨe ɨɨnuana jitaillana jai uiñotɨcue. ");
INSERT INTO huuNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Naga naɨraɨmona Jusiñamuidɨ comɨnɨna jai jitaide. Bu naimɨena ɨɨnoia, bu mare rafuedo jaia, Jusiñamui naimɨena jai jitaide. ");
INSERT INTO huuNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Caɨ judíuaɨ comɨnɨmo Jesucristo lluamona, Jusiñamui dɨbeimo caɨ illena jai uiñotɨcaɨ. Iemona Jusiñamui dɨga caɨ uri illana jai jɨaɨ uiñotɨcaɨ. Jesúdɨ nana caɨ Nama. Bie rafuena navui janore fɨdɨdomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Nana Judeamo bie rafue llocana jai jaide. Juan mɨcorɨ bautizajana llua mei, Galileamo Jesús naimɨe llofuiana taɨnede. ");
INSERT INTO huuNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Jusiñamuidɨ ie Joreñona Jesúmo fecade. Jesúdɨ Nazaret imɨe. Naimɨemo ie uaina jɨaɨ fecade. Ie jira Jesús mare rafuena fɨnocana uite. Jusiñamui naimɨe dɨga illa jira, dɨga Taɨfe anamo itɨnona jillotate. ");
INSERT INTO huuNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Judíuaɨ enɨruemo nana naimɨe siño fɨnoca rafuena cɨodɨcaɨ. Iena birui llocabitɨcaɨ. Cruzmo jonianona, caɨ illaɨcomɨnɨ naimɨena meinetɨmacɨ; ");
INSERT INTO huuNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","iadedɨ darui amani illa mei, Jusiñamui naimɨena jillotate. Jusiñamui jitailla jira, Jesús jillua mei, ailluena comɨnɨ naimɨena cɨodɨmacɨ. Cajedɨmɨena cɨodɨmacɨ. Jɨaɨ cɨodɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Nana comɨnɨ naimɨena cɨoiñedɨmacɨ; iadedɨ Jusiñamui fetocano dɨese naimɨena cɨodɨmacɨ. Fiodaillamona naimɨe jillua mei, naimɨe dɨga guitɨcaɨ. Naimɨe dɨga jamai jirodɨcaɨ. Naimɨena caɨ raise uiñua jira, Jusiñamui caɨna fetode, naie rafuena llollena. ");
INSERT INTO huuNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Comɨnɨmo bie rafuena lluana caɨmo llote. Jusiñamui Jesúna jai fetode, naimɨena ɨɨnoñedɨnona duere fɨnollena. Nia fiodaiñedɨnona duere fɨnoite. Jai fiodaitɨnona jɨaɨ duere fɨnoite. Ie jira Jesús rafuena llocana jaidɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Jesús muidona naga naimɨena ɨɨnotɨmɨe ie maraiñedɨcɨnodɨ Jusiñamui dotalle. Iena nana Jusiñamui facaina lloraɨnɨ mɨcorɨaɨ jaie llotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pedro biena nia llofueia, Jusiñamui Joreño nana bie rafuena cacadɨnomo bite. ");
INSERT INTO huuNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Iena cɨuanona, Pedro dɨga bite creyentiaɨ raijicaidɨmacɨ. Naimacɨdɨ judíuaɨ comɨnɨ. Judíuaɨñede comɨnɨmo Jusiñamui ie Joreño jai fecaja jira, raijicaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Jusiñamui Joreño naimacɨmo illamona, judíuaɨñedɨnodɨ jɨaɨe naɨraɨ uaillaɨdo ñaɨtɨmacɨ. Naie ñaɨa uaillaɨna uiñoñedɨmacɨ. Jusiñamuimo iobillacɨnona jai fecadɨmacɨ. Pedro dɨga bitɨno iena cacajano, raijicaidɨmacɨ. Iemei Pedro raite: ");
INSERT INTO huuNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","—Caɨ feiñua isoi, Jusiñamui Joreñona jɨaɨ feiñotomoɨ. Omoɨ bautizallena jaca budɨ rairuiñeite. ");
INSERT INTO huuNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Ie jira naimɨedɨ naimacɨ Jesucristo facaina bautizallena llote. Bautizaja mei, naimacɨ dɨga fɨebillana naimacɨ jitailla jira, dɨga irui nainomo fɨebide. ");
INSERT INTO huuNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Judeamo ite Cristo oretagano, jɨaɨe creyentiaɨ dɨga, judíuaɨñede comɨnɨ Jusiñamui uaina feiñuana fɨdɨdɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Pedro Jerusalémo abɨdo ria, judíuaɨ comɨnɨ naimɨena icɨdɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Jɨcanotɨmacɨ: —¿Bue ñellena judíuaɨñedɨno jofomo jaidɨo? ¿Bue ñellena naimacɨ dɨga guitɨo? ");
INSERT INTO huuNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Pedro uai uanona, naimacɨmo naie rafuena nagacɨnuaɨna llote: ");
INSERT INTO huuNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","—Jopemo navui cue ia, Jusiñamuimo cue jɨɨia, nɨcaɨrilla isoi itɨcue. Aillue sábana isoi ana billana cɨodɨcue. Monamona ana lloride, ie muiduaɨ maɨga dɨga. Cuemo ana ride. ");
INSERT INTO huuNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Nainomo eruaɨdɨcuemo, dɨga rana cɨodɨcue: ocainaɨaɨna, enɨruemo jorocana jaidɨnona, nuicɨnɨaɨna. Iena cɨodɨcue. ");
INSERT INTO huuNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Monamona damɨe cuemo lluana cacadɨcue. Raite: “Pedro, naidacaillanona, fajanona, rɨno”. ");
INSERT INTO huuNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Naie uai otɨcue: “Nama, dama ite. Moisés mɨcorɨ fɨmaidoga rɨlle rana jaca rɨñedɨcue”. ");
INSERT INTO huuNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Monamona dane cuemo llote: “Jusiñamui iena jai fɨmaidoñede. Ie jira iese lloñeno”. ");
INSERT INTO huuNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Dacaiño amani iese suide. Ie mei monamo nana abɨdo dane jaide. ");
INSERT INTO huuNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Ieconi daje amani ɨima caɨ illa jofomo ridɨmacɨ. Cesareamona cue dɨne damɨe naimacɨna orede. ");
INSERT INTO huuNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Jusiñamui Joreñodɨ naimacɨ dɨga buena sedañeno cue jaillena cuemo llote. Cue dɨga seis creyentiaɨ jɨaɨ jaidɨmacɨ. Cuena uaidotɨmɨe jofomo jaidɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Nainomo caɨ rilla mei, naimɨe ie jofomo Jusiñamui jaɨenicɨna navui cɨuana caɨmo llote. Naie jaɨenicɨ naimɨemo llote: “Jopemo comɨnɨna oreta, Simón Pedrona atɨllena. ");
INSERT INTO huuNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","O jitaille rafuena omo lloite. Naie rafuena o cacajamona, jeacɨnomona jilloitɨo, nana o jofomo ite comɨnɨ dɨga” llote. Ie jira naimɨe cuena uaidote. ");
INSERT INTO huuNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Nainomo cue llofuia facaiseconi, nano dofoconi caɨmo billa isoi, Jusiñamui Joreño naimacɨmo bite. ");
INSERT INTO huuNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Iena cue cɨuamona, caɨ Nama Jesús lloga uaina comecɨtɨcue. Naimɨe navui llote: “Juan mɨcorɨ rafuena comɨnɨ feiñuamona, Juan naimacɨna bautizade; iadedɨ cue rafuena omoɨ feiñuamona, cue Moo ie Joreñona birui feiñoitomoɨ”. ");
INSERT INTO huuNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Caɨ Nama Jesucristona caɨ ɨɨnuamona, Jusiñamuidɨ ie Joreñona caɨmo navui fecade. Naimacɨmo daje isoi birui fecademo, ¿nɨese Jusiñamui dɨbeimo iñeitɨcue? ");
INSERT INTO huuNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Iena Cristo oretagano cacajano, jai naimacɨ uaina uaitallɨcɨno iñede. Jusiñamuimo iobillacɨnona fecadɨmacɨ. Raitɨmacɨ: —Naimacɨ jaca illena, Jusiñamuidɨ judíuaɨñede comɨnɨ comecɨaɨ iuai meiduana jai jitaide. Naimɨe dɨbeimo naimacɨ illana jai jitaide. Ie jira naimɨeri iobidɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Esteban mɨcorɨna duere fɨnua facaise, creyentiaɨ tuficaida jaidɨmacɨ. Feniciamo damɨerie jaidɨmacɨ. Chipremo damɨerie jɨaɨ jaidɨmacɨ. Antioquíamo damɨerie jɨaɨ jaidɨmacɨ. Danɨ judíuaɨ comɨnɨmo naimacɨ rafuena llotɨmacɨ; ");
INSERT INTO huuNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","iadedɨ tuficaidɨnomona jɨaɨno Chripremona billanona, Cirenemona billanona, Antioquíamo rillano, judíuaɨñedɨnomo caɨ Nama Jesús rafuena llotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Cristo uai naimacɨmo illamona, ailluena comɨnɨ ɨɨnotɨmacɨ. Caɨ Nama dɨbeimo jaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Jerusalémo ite creyentiaɨ iena fɨdɨano, Antioquíamo Bernabéna oretatɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Naimɨe ria, naimacɨ marena illamona, naimɨedɨ Jusiñamui naimacɨna dueruillana uiñote. Ie jira iobide. Imacɨ comecɨaɨ ocuiñocana ɨɨnocana jaillana naimacɨmo llote. ");
INSERT INTO huuNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Naimɨedɨ maremɨe Jusiñamui Joreño nana naimɨe comecɨmo namatadɨmɨe. Jusiñamuina eo ɨɨnotɨmɨe. Naie facaise ailluena comɨnɨ creyentiaɨna jaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Ie mei Tarsomo Bernabé Saulona jenuaide. Naimɨena baillanona, Antioquíamo naimɨena uite. ");
INSERT INTO huuNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Daje año creyentiaɨ dɨga nabairillanona, naimacɨna llofuetɨiaɨmaiaɨ. Antioquíamo creyentiaɨdɨ cristianona nano mamecɨredɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Iemei Jerusalémona Antioquíamo damɨerie Jusiñamui rafuena lloraɨnɨ bitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Naimacɨmona Agabo raillamɨe ite. Jusiñamui Joreñodɨ naimɨena llotatate: —Nana comɨnɨ ɨco aime guitɨmacɨ. —Claudio illaɨmana illa facaiseconi iese jai suide. ");
INSERT INTO huuNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ie jira Antioquíamo ite creyentiaɨdɨ, Judeamo ite creyentiaɨmo, ucubena oretaiacadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Nagamɨiaɨ imacɨmo illa dɨerise ucubena oredɨmacɨ. Creyentiaɨna llofueraɨnɨmo Bernabé dɨga, iaɨmaiaɨ Saulo dɨga, naie ucubena oredɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Naie facaise Herodes railla illaɨmadɨ creyentiaɨmona damɨeriena gaɨtatate, naimacɨna duere fɨnollena. ");
INSERT INTO huuNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Lloebɨ dɨga Jacobo cɨmaɨona jaitatate. Jacobodɨ Juan ama. ");
INSERT INTO huuNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Ieri judíuaɨ illaɨcomɨnɨ iobidɨmacɨ. Iena uiñuamona, Herodes Pedrona jɨaɨ gaɨtatate. ");
INSERT INTO huuNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Naie facaiseconi judíuaɨ comɨnɨ llomenico guilla rafue ite. Naimɨena gaɨtatajanona, cárcelmo jonete. Soldaduaɨna orede, naimɨena sedallena. Daje soldado Pedro nabeimo lloeo dɨga cuinaca. Daje soldado Pedro jarɨfebeimo lloeo dɨga cuinaca. Mena soldado naie cuarto ie nasena sedade. Ie isoi sedauidɨmacɨ. Naie llomenico guilla rafue fuilla mei, comɨnɨ illa uicomo naimɨena meineiacade. ");
INSERT INTO huuNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Ie jira Pedro cárcelmo fɨebide; iadedɨ creyentiaɨ naimɨe facaina eo jɨɨdɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Herodes naimɨena meineiacanarui naɨo Pedro soldaduaɨ motomo ɨnɨde. Mena lloeo dɨga maɨga. Soldaduaɨ cárcel nasena jɨaɨ sedadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ieconi caɨ Nama ie jaɨenicɨdɨ cárcelmo bairede. Cárcelmo llɨgaiñote. Naimɨena casitallena, jaɨenicɨ Pedro cɨraigɨna jetade. Raite: —Raɨre naidacaɨ. Ie mei naimɨe onollɨmo ite lloeodɨ oni uaide. ");
INSERT INTO huuNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Jaɨenicɨ naimɨena raite: —O ɨniroina jɨta. O zapatona jɨaɨ jɨta— Iena jitaja mei, naie jaɨenicɨ dane raite—. O ɨniroi o abɨmo ferɨno. Cue dɨga mai bi. ");
INSERT INTO huuNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Naie jaɨenicɨ jɨnafona Pedro jino jaide. Pedrodɨ naie jaɨenicɨ naimɨemo fɨnoca rafuena uiñoñede. —Nɨcaɨrilla isoi comecɨna facadɨcue —raite. ");
INSERT INTO huuNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Naga nasena sedade soldadomona jaide. Jino jaillena, nanoca nasemo ride. Nai nasedɨ lloema ie; iadedɨ nase dama ecoride. Jino jaidɨiaɨmaiaɨ. Daje calle jaillanona, jaɨenicɨ naimɨena faɨnonocaide. ");
INSERT INTO huuNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Iemona Pedro naimɨemo suide rafuena jai uiñocaide. Raite: —Cue Nama ie jaɨenicɨna uanai oretate. Herodemona cuena jillobitade. Judíuaɨ illaɨcomɨnɨ cue meinellena cue sedajamona cuena jillobitade. ");
INSERT INTO huuNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Iena jai naimɨe uiñuano, María jofomo jaide. Maríadɨ Juan Marcos ei. Jusiñamuimo jɨɨllena, naicomo ailluena comɨnɨ ofidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Rillanona calle fuemo ite nasena tute. Daje mullaɨño bite. Naiñaiño mamecɨdɨ Rode. ");
INSERT INTO huuNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Naimɨe uaiduamona, naiñaiño Pedro uaina uiñote. Iobilla jira, nase econoñede; iadedɨ abɨdo fo aisɨde. Pedro nasemo illana llote. ");
INSERT INTO huuNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Raitɨmacɨ: —Odɨ uaɨrico isoidɨosa. Naiñaiñodɨ: —Pedrodɨ jaca ieseuide —raite. Uai uamona: —Naimɨe joreño ite —raitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Pedro nasena nia tua jira, nasena econuaɨbitɨmacɨ. Econuamona naimɨena naimacɨ cɨuamona, raijicaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Fo jaillano, Pedro ie onollɨ jaidɨde, naimacɨ llɨɨcaillena. Cárcelmona caɨ Nama naimɨena jino ua rafuena llote. Raite: —Jacobomo iena llono. Jɨaɨe creyentiaɨmo iena jɨaɨ llono. Ie mei Pedro jino jaillano, jɨaɨnomo jaide. ");
INSERT INTO huuNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Monaidemo, Pedro nainomo iñena jira, soldaduaɨ raijicaillanona, siadotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herodes iena fɨdɨano, naimɨena jenotate. Naimɨena baiñenia, soldaduaɨmo jɨcanote. Baiñena jira, naimacɨna meinellena llote. Iemei Judeamona Cesareamo Herodedɨ jaide. ");
INSERT INTO huuNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Naie facaise Herodedɨ Tiro railla naɨraɨ dɨga, Sidón railla naɨraɨ dɨga, eo icɨrite. Naimacɨ uri ille rafuena siadollena, naimɨe dɨne bitɨmacɨ. Herodes ecɨmo maɨjɨdɨmɨedɨ Blasto. Blasto dɨga naie comɨnɨdɨ nabairite, naimacɨ dɨbeimo naimɨe illena. Herodes enɨruemona naimacɨ guille billa jira, uri illena naimɨemo jɨcanote. ");
INSERT INTO huuNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Naie comɨnɨna Herodes feiñollena, ie ebirede ɨniroina jɨtade. Naimacɨna feiñollena, ie raɨrabɨcɨmo raɨde. Iemona raɨta, rafuena are llote. ");
INSERT INTO huuNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Iena cacajano, comɨnɨ ado cuiriidɨmacɨ: —Jamai ɨimadɨ ñaɨñena. ¡Jusiñamui ñaɨa! ");
INSERT INTO huuNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","“Jusiñamuiñedɨcue” naimɨe raiñena jira, ieconi caɨ Nama jaɨenicɨ naimɨena ɨracotaitate. Jusiñamuimo iobillacɨno naimɨe fecañena jira, aɨaɨ naimɨena aɨte. Iemona naimɨedɨ fiodaite. ");
INSERT INTO huuNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Naie facaiseconi Jusiñamui uai llocana jaide. Ailluena comɨnɨ iena ɨɨnotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Iaɨmaiaɨ uiga ucube illanona, Bernabé, Saulo dɨga, Jerusalémona Antioquíamo abɨdo bitɨiaɨmaiaɨ. Juan Marcos jɨaɨ atɨdɨiaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antioquíamo creyentiaɨ motomo Jusiñamui facaina lloraɨnɨ itɨmacɨ. Llofueraɨnɨ jɨaɨ itɨmacɨ: Bernabé, Simón. Simóndɨ jɨaɨe mamecɨ Negro. Lucio ite. Naimɨedɨ Cirene imɨe. Manaén ite. Naimɨedɨ Herodes ie amana mamede. Herodedɨ Galilea railla enɨrue gobernador. Saulo jɨaɨ ite. ");
INSERT INTO huuNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Naimacɨ Jusiñamuina sedajamona, guiñenaruillaɨ ia, Jusiñamui Joreño naimacɨmo llote: —Bernabé iaɨmaiaɨ Saulo dɨga feto, cuejena. Cue rafuena iaɨmaiaɨ llollena, iaɨmaiaɨna jai fetodɨcue. ");
INSERT INTO huuNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Jusiñamuimo naimacɨ jɨɨa mei, Jusiñamui iaɨmaiaɨna fetuana naimacɨ uiñuamona, naimacɨ onollɨ iaɨmaiaɨmo jonia mei, iaɨmaiaɨna naimacɨmona oni oretatɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Iaɨmaiaɨna Jusiñamui Joreño oretaja jira, Seleuciamo jaidɨiaɨmaiaɨ. Nainomona botedo Chipremo jaidɨiaɨmaiaɨ. Chipredɨ uiasi. ");
INSERT INTO huuNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Chipremo ria, Salaminamo judíuaɨ ofiracuaɨmo Jusiñamui uaina llofuetɨiaɨmaiaɨ. Juan Marcos iaɨmaiaɨ dɨga jɨaɨ jaide. ");
INSERT INTO huuNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Nana naie uiasimo jaillanona, Pafos railla naɨraɨmo ridɨmacɨ. Nainomo Barjesúna mamecɨredɨmɨena baitɨmacɨ. Naimɨe judío imɨe. Naimɨedɨ aima. Naimɨedɨ dɨga siño rafuena fɨnoraɨma. “Jusiñamui rafuena llotɨcue” raite; iadedɨ taɨno lloraɨma. ");
INSERT INTO huuNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Gobernador dɨga maɨjɨuide. Gobernadordɨ Sergio Paulo. Gobernadordɨ abɨna uiñotɨmɨe. Jusiñamui uaina cacaacana jira, naimɨe Bernabé iaɨmaiaɨ Saulo dɨga uaidote. ");
INSERT INTO huuNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Barjesús ie jɨaɨe mamecɨdɨ Elimas. Naie iaɨmaiaɨ llofuiana uaitate. Gobernador ɨɨnuana jitaiñede. ");
INSERT INTO huuNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Saulodɨ jɨaɨe mamecɨ Pablo. Pablo dɨnena naimɨena eo eruaɨllano, Jusiñamui Joreño nana Pablo comecɨmo namatajamona, ");
INSERT INTO huuNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","naimɨemo llote: —¡Eo jɨfueraɨmadɨo! ¡Eo maraiñedɨo! ¡Taɨfe dɨbeimo itɨo! Nana mare rafue dɨbeimo iñedɨo. Caɨ Nama ie mare uanaicɨnona dobairaɨdodɨo. ");
INSERT INTO huuNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Caɨ Nama ie uaido ona ja ɨracotaitaitɨcue. Nano nɨgarui useredɨnona cɨoiñeitɨo. Ieconi naimɨe cɨoiñede. Comɨnɨna jenuaide, ie onollɨdo llɨnocaida ie uillena. ");
INSERT INTO huuNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Iena cɨuamona, gobernador creyentena jaide. Caɨ Nama Jesús rafue siñonana cɨuanona, naimɨe jacɨnaite. ");
INSERT INTO huuNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pafomona botedo Pablo ie nabaiñɨaɨ dɨga jaide. Perge railla naɨraɨmo ride. Perge Panfilia railla enɨruemo ite. Juan Marcos iaɨmaiaɨna faɨnonocaida, Jerusalémo abɨdo jaide. ");
INSERT INTO huuNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Pergemona Antioquíamo jaidɨiaɨmaiaɨ. Pisidia railla enɨruemo Antioquía ite. Sábadoruimo judíuaɨ ofiracomo jaillano, ana raɨdɨiaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Moisés mɨcorɨ cuegafuena facaja mei, Jusiñamui facaina lloraɨnɨ mɨcorɨaɨ cuegafuena facaja mei, judíuaɨ ofiraco sedadɨno iaɨmaiaɨmo llotɨmacɨ: —Caɨmacɨ, comɨnɨmo bue omɨco lloiacania, mai llono. ");
INSERT INTO huuNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Pablo naidadajano, ie onollɨna jaidɨde, comɨnɨ llɨɨcaillena. Raite: —Jusiñamuina sedallena bene itomoɨ. Omoɨmona damɨerie judíuaɨdomoɨ. Jɨaɨno judíuaɨñedomoɨ; iadedɨ judíuaɨ isoi Jusiñamuina sedadomoɨ. Cue lluamo mai cacarei. ");
INSERT INTO huuNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Iemona omoɨ fueollena, caɨ jaiagaɨ rafuena lloitɨcue. Caɨ judíuaɨ comɨnɨ Jusiñamuina birui sedadɨcaɨ. Naimɨedɨ caɨ jaiagaɨna jaie fetode. Egiptomo naimacɨ ia, naimacɨna eo jebuitate. Nainomona ie siño uai dɨga naimacɨna atɨde. ");
INSERT INTO huuNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Jofue iñenanomo cuarenta años naimacɨna canode. ");
INSERT INTO huuNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Canaán enɨruemo siete naɨraɨna cuenode. Caɨ jaiagaɨmo, naimacɨ uruiaɨ dɨga, naie enɨruena fecade, naimacɨ iena. ");
INSERT INTO huuNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Cuatrocientos cincuenta años caɨ jaiagaɨna fetuamona, naie enɨruena naimacɨmo fecade. Naie facaise Jusiñamuidɨ jueces fetode, caɨ jaiagaɨna naimacɨ canollena. Naimɨe dɨbeimo naimacɨna itatallena, Jusiñamui naie jueces fetode; iadedɨ Samuel mɨcorɨ illa facaise juecesna jai jitaiñedɨmacɨ. Samuel mɨcorɨdɨ Jusiñamui facaina lloraɨma. ");
INSERT INTO huuNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Illaɨmana naimacɨ jitailla jira, Jusiñamui Saúl mɨcorɨna fetode. Naimɨedɨ Cis mɨcorɨ jito. Naimɨe mɨcorɨ naɨraɨdɨ Benjamín. Cuarenta años Saúl mɨcorɨ caɨ usumatɨaɨ mɨcorɨaɨna sedade. ");
INSERT INTO huuNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Naimɨe ifo meidollena, naimacɨ illaɨmana illena, Jusiñamui David mɨcorɨna fetode. Naimɨedɨ Isaí mɨcorɨ jito. Jusiñamui naimɨe mɨcorɨna llote: “Bimɨe eo cue comecɨdo jaidɨmɨe. Nana cue jitaille rafuena fɨnoite”. ");
INSERT INTO huuNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Jusiñamui llua isoi, David mɨcorɨ uruiaɨmona Jesúdɨ caɨ judíuaɨ comɨnɨ Jilloitaraɨmana jaide. ");
INSERT INTO huuNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Jesús nia llofueñenia, Juan Bautista mɨcorɨ llofueuide. Juan mɨcorɨ caɨ comɨnɨmo llouide: “Omoɨ jeacɨnona faɨnonocaida, Jusiñamui dɨbeimo omoɨ comecɨaɨ iuaillaɨ meido. Iena omoɨ meidoia, comɨnɨ iena uiñotallena, mai omoɨ bautizallomoɨ”. ");
INSERT INTO huuNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Juan mɨcorɨ ie llofuia fuillamona, raite: “Omoɨ comecɨ facajamɨeñedɨcue. Cue ifomo jɨaɨmɨena meidoite. Naimɨe isoiñedɨcue. Jamai bue isoidɨcue. Jamai bue cue isoilla jira, naimɨena cue canuana uiñoñedɨcue”. ");
INSERT INTO huuNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","’Caɨmacɨ, caɨ eirue jito Abraham mɨcorɨmona comuidɨcaɨ. Jusiñamuina birui sedadɨcaɨ. Ie jira caɨ jeacɨnomona naimɨe jilloitalle rafue caɨmo duide. Jesúna ñaɨtɨcue. ");
INSERT INTO huuNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Jerusalémo itɨnodɨ, caɨ illaɨcomɨnɨ dɨga, Jesúna jaie meinetɨmacɨ. Naga sábado Jusiñamui facaina lloraɨnɨ mɨcorɨaɨ cuegafuiaɨna facadɨmacɨ; iadedɨ iena raise cacaiñedɨmacɨ. Jesúna naimacɨ meiniamona, Jusiñamui lloraɨnɨ mɨcorɨaɨ cuegafuiaɨna jai suitatɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Jesús maraiñede rafuena fɨnoñede; iadedɨ naimɨena meinetɨmacɨ. Pilatomo jɨcanotɨmacɨ, naimɨena meinellena. ");
INSERT INTO huuNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Nana Jusiñamui facaina lloraɨnɨ mɨcorɨaɨ cuegafuiaɨna suilla mei, cruzmona naimɨe ana uano, nofɨcɨ ie raɨafomo naimɨena jonetɨmacɨ; ");
INSERT INTO huuNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","iadedɨ fiodaillamona Jusiñamui naimɨena jillotate. ");
INSERT INTO huuNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Galileamona Jerusalémo naimɨe dɨga jaidɨno naimɨena dɨga icaiño cɨodɨmacɨ. Iemei comɨnɨmo naimɨe rafuena jai llocabitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Jusiñamui caɨ jaiagaɨmo jaie lloga rafue jai suide. Iena omoɨmo ja lloitɨcoco. ");
INSERT INTO huuNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Jusiñamuidɨ caɨ jaiagaɨmo llogafue birui jai suide. Jesúna caɨ dɨne jai orede. Naiena salmos dosmo cuega: “Jusiñamui llote: ‘Cue jitodɨo. Birui ona Jilloitaraɨmana itatatɨcue’ ”. ");
INSERT INTO huuNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Fiodaillamona Jusiñamui naimɨena jai jillotate. Ie abɨ jaca rɨfaiñede. Iena Jusiñamui jɨaɨ raite: “Davidmo cue llogacɨnona omoɨ facaina jaca fɨnojitɨcue”. ");
INSERT INTO huuNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","David mɨcorɨ jɨaɨe salmomo iena cuete: “O mareuidɨmɨe jaca rɨfaillana jitaiñedɨo” raite. ");
INSERT INTO huuNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Jusiñamui David mɨcorɨna ñaɨñede. Ie illa dɨnori David mɨcorɨdɨ Jusiñamui jitailla rafuena fɨnode. Ie mei naimɨe fiodaite. Ie raɨafomo naimɨe comɨnɨ naimɨena jonetɨmacɨ. Ie mei David mɨcorɨ abɨ rɨfaide; ");
INSERT INTO huuNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","iadedɨ Jusiñamui Jito abɨdɨ ie isoi rɨfaiñede. ");
INSERT INTO huuNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","’Caɨmacɨ, daje rafue omoɨmo lloiacadɨcue. Jesús fiodailla jira, Jusiñamui omoɨ jeacɨno oni dotaacade. Moisés mɨcorɨ llogacɨnodɨ omoɨ maraiñedɨcɨnomona omoɨna jillotañede; ");
INSERT INTO huuNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","iadedɨ Jesúna birui omoɨ ɨɨnoia, omoɨ jeacɨno anamona jilloitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Abɨna omoɨ rairui, Jusiñamui facaina lloraɨnɨ mɨcorɨaɨ jaie cuegafuiaɨ omoɨmo sui raillano. Jaie cuetɨmacɨ: ");
INSERT INTO huuNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Ero, Jusiñamui uaina jamaidomoɨ. Ieri raijicaidomoɨ; iadedɨ faɨfidomoɨ. Omoɨ motomo siño mare rafuena birui fɨnodɨcue. Bu omoɨmo iena iese lloia, bie rafuena ɨɨnoñeitomoɨ. Ie isoi omoɨmo suiñellena, Jesúna birui omoɨ mai ɨɨno. ");
INSERT INTO huuNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Ie mei Pablo llɨɨcaide. Iaɨmaiaɨ jino jaidemo, comɨnɨ iaɨmaiaɨmo jɨcanotɨmacɨ, jɨaɨe sábadoruimo bie rafuena naimacɨmo dane llollena. ");
INSERT INTO huuNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Comɨnɨ jino jailla mei, ailluena comɨnɨ Pablo, iaɨmaiaɨ Bernabé dɨga, ñaɨcana jaidɨmacɨ. Judíuaɨ iese jaidɨmacɨ. Judíuaɨñedɨno iese jɨaɨ jaidɨmacɨ. Naie judíuaɨñedɨnodɨ judíuaɨ isoi Jusiñamuina ɨɨnotɨmacɨ. Pablo, iaɨmaiaɨ Bernabé dɨga, ñaɨcana jaillanona, naimacɨmo llotɨiaɨmaiaɨ: —Jusiñamui omoɨna duenaillana omoɨ jai uiñua jira, Jesús rafuena mai omoɨ ɨɨno. ");
INSERT INTO huuNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Jɨaɨe sábadoruimo ailluena comɨnɨ ofidɨmacɨ, Jusiñamui uaina cacareillena. ");
INSERT INTO huuNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ailluena comɨnɨna cɨuano, judíuaɨ comɨnɨ dɨnena eo uradoidɨmacɨ. Pablo joreñona ñaɨtɨmacɨ. Naimɨe llofuiacɨnuaɨna uaitatɨmacɨ; ");
INSERT INTO huuNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","iadedɨ Pablo, iaɨmaiaɨ Bernabé dɨga, jacɨtaiñeno llofuetɨiaɨmaiaɨ: —Omoɨmo Jusiñamui uaina nano lloiacadɨcoco. Iena jitaiñedomoɨ. Jusiñamui dɨga omoɨ jaca illena jitaiñedomoɨ. Ie jira judíuaɨñedɨno dɨne jaitɨcoco. ");
INSERT INTO huuNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Iese Jusiñamui jaie llote: Judíuaɨñedɨnomo ona oretaitɨcue, naimacɨmo cue rafue llollena, naga enɨruemo ite comɨnɨmo jeacɨnomona jilluana llollena. ");
INSERT INTO huuNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Iena cacajano, judíuaɨñedɨno iobidɨmacɨ. —Jusiñamui rafue mare —raitɨmacɨ. Jusiñamui jaca illena fetocano dɨese Jesúna ɨɨnotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Nana bie enɨruemo caɨ Nama Jesús uaina llocana jaide; ");
INSERT INTO huuNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","iadedɨ judíuaɨ dɨnena dɨga comɨnɨna fuemo faɨcana uitɨmacɨ. Jusiñamuina sedade rɨñonɨaɨna fuemo faɨcana uitɨmacɨ. Naie rɨñonɨaɨ mamecɨaɨ are soride. Illaɨcomɨnɨ fuemo faɨcana uitɨmacɨ. Ie jira Pablo, iaɨmaiaɨ Bernabé dɨga, duere fɨnodɨmacɨ. Naimacɨ illanomona iaɨmaiaɨna jino dotadɨmacɨ; ");
INSERT INTO huuNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","iadedɨ jioracuaɨ iaɨmaiaɨ eɨllɨmona jaidɨnotɨiaɨmaiaɨ, naimacɨmo ite jeacɨnuaɨna naimacɨ uiñollena. Ie mei Iconio railla naɨraɨmo jaidɨiaɨmaiaɨ; ");
INSERT INTO huuNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","iadedɨ Antioquíamo ite creyentiaɨ eo iocɨre itɨmacɨ. Jusiñamui Joreño nana naimacɨ comecɨmo namatade. ");
INSERT INTO huuNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Iconiomo judíuaɨ ofiracomo, iaɨmaiaɨ Antioquíamo jailla isoi, jaidɨiaɨmaiaɨ, Cristo rafuena duere llotɨiaɨmaiaɨ. Ie jira ailluena comɨnɨ creyentiaɨna jaidɨmacɨ. Judíuaɨ comɨnɨmona ailluena ɨɨnotɨmacɨ. Judíuaɨñede comɨnɨmona ailluena jɨaɨ ɨɨnotɨmacɨ; ");
INSERT INTO huuNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","iadedɨ ɨɨnoñede judíuaɨdɨ judíuaɨñedɨnona fuemo faɨtɨmacɨ. Naimacɨmo creyentiaɨna taɨnona llotɨmacɨ; ");
INSERT INTO huuNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","iadedɨ nainomo are fɨebidɨiaɨmaiaɨ. Caɨ Nama facaisena jacɨtaiñeno llotɨiaɨmaiaɨ. Caɨ Nama Jesús iaɨmaiaɨna siño rafuena fɨnotate. Ie jira comɨnɨdɨ caɨ Nama Jesús naimacɨna dueruillana fɨdɨdɨmacɨ; ");
INSERT INTO huuNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","iadedɨ nana comɨnɨ naiena ɨɨnoñedɨmacɨ. Comecɨaɨna daje isoi lloisɨñede. Damɨerie judíuaɨ facaisena itɨmacɨ. Damɨerie naie iaɨmaiaɨ facaisena itɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Judíuaɨñedɨnodɨ, judíuaɨ dɨga, naimacɨ illaɨcomɨnɨ dɨga, naie iaɨmaiaɨna duere fɨnoacadɨmacɨ. Nofɨcɨna iaɨmaiaɨna faɨrɨgɨiacadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Iena fɨdɨano, Licaoniamo ite naɨraɨmo aisɨcano jaidɨiaɨmaiaɨ. Listra railla naɨraɨmo jaidɨiaɨmaiaɨ. Derbe railla naɨraɨmo jɨaɨ jaidɨiaɨmaiaɨ. Naie naɨraɨ ecɨmo ite enɨruemo jɨaɨ jaidɨiaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Nainomo Jesús ie mare rafuena llofuetɨiaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Listramo damɨe tɨsitaite. Nanomona naimɨe iese jeicɨa jira, jaca macariñede. ");
INSERT INTO huuNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Pablo llofuiana naimɨe raise cacajamona, “Jusiñamui cuena jillotarede” raillanona, tɨsitaitɨmɨe ɨɨnote. Pablo dɨnena naimɨemo eruaɨllano, naimɨe ɨɨnuana uiñote. ");
INSERT INTO huuNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Naimɨemo ado llote: —A naidada. Iemei daiacaida naimɨe macarite. ");
INSERT INTO huuNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Ailluena comɨnɨ Pablo fɨnoca rafuena cɨodɨmacɨ. Naimacɨ uaido ado cuiriidɨmacɨ: —Ɨiñɨaɨ isoi Jusiñamui caɨ dɨne bite. Naie comɨnɨdɨ Júpiter railla jusiñamuina sedauidɨmacɨ. Mercurio railla jusiñamuina jɨaɨ sedauidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ie jira Bernabé mamecɨdɨ jɨaɨcɨna jonega Júpiter. Pablo mamecɨdɨ jɨaɨcɨna jonega Mercurio, naimɨe ñaɨraɨmana illa jira. ");
INSERT INTO huuNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Naie naɨraɨ nanoca nase ruica facai Júpiterna sedauilla jofo ite. Iaɨmaiaɨna sedallena, safia dɨga juraretaɨaɨna abɨna fɨnoduanona, Júpiter facaina ñaɨraɨma naimacɨna atɨde. Ailluena comɨnɨ dɨga bite. Juraretaɨaɨna fallena, “Naie iaɨmaiaɨdɨ caɨ Jusiñamui” raillano, iaɨmaiaɨmo fecaacadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Iaɨmaiaɨ iena cɨuanona, “Comɨnɨ maraiñede rafuena fɨnoacade” raillano, iaɨmaiaɨ ɨniroina cuaranotɨiaɨmaiaɨ. Comɨnɨ motomo aisɨcana jaidɨiaɨmaiaɨ. Ado llotɨiaɨmaiaɨ: ");
INSERT INTO huuNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","—Nabaiñɨaɨ, ¿bue ñellena cocomo iese fɨnodomoɨ? Jamai ɨimadɨcoco. Omoɨ isoidɨcoco. Jusiñamuina omoɨ sedallena, jamai rana omoɨ sedañellena, mare rafuena omoɨmo jai llotɨcoco. Cajede Jusiñamuina sedadɨcoco. Naimɨedɨ mona fɨnode. Enɨruena fɨnode. Monaillaina jɨaɨ fɨnode. Nana nainomo ite rana jɨaɨ fɨnode. ");
INSERT INTO huuNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Jaie Jusiñamuidɨ nana omoɨ judíuaɨñedɨno omoɨ jitailla rafuena fɨnuana rairuiñede; ");
INSERT INTO huuNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","iadedɨ naimɨe fɨnoca rafuemona naimɨena uiñoredomoɨ. Omoɨ facaina mare rafue naimɨe fɨnocabide. Nocɨ deitate. Omoɨ riara sɨcotate. Omoɨmo guille itatate. Iemona omoɨ comecɨaɨna caɨmare itatate. Iemona Jusiñamuina uiñoredomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Iese Pablo llote; iadedɨ iaɨmaiaɨmo juraretaɨaɨna fecajana jaca faɨnonocaiacaiñedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Nano nɨgarui illamona, Pisidiamo ite Antioquíamona judíuaɨ comɨnɨ bitɨmacɨ. Iconiomona jɨaɨ bitɨmacɨ. Judíuaɨ dɨnena fuemo faɨamona, naimacɨ dɨbeimo comɨnɨ jaidɨmacɨ. Iemona nofɨcɨdo Pablona faɨrɨgɨte. Naie naɨraɨmona naimɨena sonocana uitɨmacɨ, fiodaitɨmɨena naimɨe eruaɨlla jira. ");
INSERT INTO huuNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Naimɨena iese faɨnonocailla mei, creyentiaɨ naimɨe ecɨmo billamona, naimɨe a naidadate. Nai naɨraɨmo abɨdo jaide. Ie are Derbemo, Bernabé dɨga, jaide. ");
INSERT INTO huuNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Naie naɨraɨmo Jesús ie mare rafuena llotɨiaɨmaiaɨ. Dɨga comɨnɨ creyentiaɨna jaidɨmacɨ. Ie mei Listramo abɨdo jaidɨiaɨmaiaɨ. Iconiomo abɨdo jɨaɨ jaidɨiaɨmaiaɨ. Pisidiamo ite Antioquíamo jɨaɨ abɨdo jaidɨiaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Creyentiaɨ comecɨaɨna ocuiñotadɨiaɨmaiaɨ. Cristona nia ɨɨnuana llotɨiaɨmaiaɨ. Raitɨiaɨmaiaɨ: —Jusiñamui dɨne caɨ nia riñenia, eo duere sefuitɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Naga creyentiaɨ illanomo creyentiaɨna sedaraɨnɨna fetodɨiaɨmaiaɨ. Guiñeno Jusiñamuimo jɨɨa mei, guiñena facaise mei, naimɨena naimacɨ jai ɨɨnua jira, caɨ Nama illa anamo naimacɨna faɨnonocaidɨiaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Pisidiamo jaillanona, Panfiliamo ridɨiaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Pergemo Cristo uaina llua mei, Ataliamo jaidɨiaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Nainomona botedo Siriamo ite Antioquíamo abɨdo ridɨiaɨmaiaɨ. Nano naie iaɨmaiaɨ illanomo abɨdo ridɨiaɨmaiaɨ. Nainomona iaɨmaiaɨ navui nia jaiñenia, creyentiaɨ dɨnena Jusiñamui iaɨmaiaɨna duenaillana uiñuamona, iaɨmaiaɨna oredɨmacɨ. Jusiñamui rafuena iaɨmaiaɨ llollena, iaɨmaiaɨna oredɨmacɨ. Naie maɨjɨa fuilla jira, jai abɨdo bitɨiaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Iaɨmaiaɨ rilla mei, creyentiaɨna ofitatɨiaɨmaiaɨ. Nana Jusiñamui iaɨmaiaɨmo fɨnoca rafuena llotɨiaɨmaiaɨ. —Jusiñamuidɨ judíuaɨñedɨno naimɨena ɨɨnuana jai jitaide —llotɨiaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Dɨnomo creyentiaɨ dɨga are itɨiaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Antioquíamo Jerusalémona janore comɨnɨ billano, creyentiaɨna iese llofuetɨmacɨ: —Moisés mɨcorɨ caɨmo llua isoi, omoɨ abɨna omoɨ detatañenia, jeacɨnomona jillobiñeitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Ie jira creyentiaɨ uri iñedɨmacɨ. Pablo, iaɨmaiaɨ Bernabé dɨga, Jerusalémona bitɨno llofuiana eo uaitatɨiaɨmaiaɨ. Ie muidona creyentiaɨ dɨnena iaɨmaiaɨna, jɨaɨe creyentiaɨ dɨga, Jerusalémo jaillena fetodɨmacɨ. Cristo oretagano dɨga, Jerusalémo ite creyentiaɨna sedaraɨnɨ dɨga, bie rafuena siadoiacasɨte. ");
INSERT INTO huuNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Creyentiaɨ naimacɨna oretaja mei, Fenicia railla enɨrue dɨbeido jaidɨmacɨ. Ie mei Samaria railla enɨrue dɨbeido jɨaɨ jaidɨmacɨ. Creyentiaɨ illanuaɨmo llofuecana jaidɨmacɨ. Judíuaɨñedɨno creyentiaɨna jai jaillana naimacɨmo jɨaɨ llotɨmacɨ. Ie jira naie creyentiaɨ caɨmare itɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Jerusalémo ria, creyentiaɨdɨ naimacɨna feiñotɨmacɨ. Cristo oretagano itɨmacɨ. Creyentiaɨna sedaraɨnɨ jɨaɨ itɨmacɨ. Naimacɨmo nana Jusiñamui iaɨmaiaɨmo fɨnoca rafuena llotɨiaɨmaiaɨ. Cristo rafuena iaɨmaiaɨ llofuiamona, judíuaɨñedɨno Cristona ɨɨnuana llotɨiaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Iena cacajano, fariseuaɨ dɨbeimo ite creyentiaɨmona jɨaɨno naidaita raitɨmacɨ: —Moisés mɨcorɨ llogacɨnuaɨna ɨɨnuamona, judíuaɨñede creyentiaɨ abɨna diana jitaidɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Bie rafuena siadollena, Cristo oretaganodɨ, creyentiaɨ sedaraɨnɨ dɨga, danomo ofidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Iena are siadua mei, Pedro naidacaillano, raite: —Amatɨaɨ, judíuaɨñedɨnodɨ cuemona Jesús ie mare rafuena cacaillena, jaie omoɨmona Jusiñamui cuena fetode. Iena uiñotomoɨ. Cue llofuiamona ɨɨnotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Nana comɨnɨ comecɨaɨna naimɨe uiñuamona, judíuaɨñedɨno naimɨena ɨɨnuana Jusiñamuidɨ uiñote. Caɨmo fecaja isoi, ie Joreño naimacɨmo fecaja jira, Jusiñamuidɨ judíuaɨñedɨnona jitaillana jai uiñotɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Jusiñamuidɨ naimacɨna caɨ isoi jai feiñote. Naimɨena naimacɨ ɨɨnua jira, naimɨe naimacɨ comecɨaɨmona jeacɨnona jai dotade. ");
INSERT INTO huuNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","¿Bue ñellena Jusiñamuina ɨɨnoiacaiñedomoɨ? Jusiñamui jitaillacɨno omoɨ fɨnoacaiñena jira, naimɨe omoɨna duere fɨnuana jitaidomoɨ. Caɨ jaiagaɨ Moisés mɨcorɨ llogacɨnodo jaidɨmacɨ; iadedɨ iena raise ɨɨnoñedɨmacɨ. Nana ie llogacɨnona jaca fɨnonidɨmacɨ. Iedo jaie jɨaɨ jaidɨcaɨ; iadedɨ iena jɨaɨ fɨnonidɨcaɨ. ¿Bue ñellena iedo birui caɨ jaillana jitaidomoɨ? ");
INSERT INTO huuNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Jesucristo caɨna duenailla jira, caɨ jeacɨnomona jilloitɨcaɨ. Judíuaɨñedɨno caɨ isoi jilloitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Iena cacajano, nana ofidɨno uai llɨɨcaidɨmacɨ. Iemei Bernabé lluana cacadɨmacɨ. Pablo lluana jɨaɨ cacadɨmacɨ. —Jusiñamui judíuaɨñedɨno motomo cocona siño rafuena fɨnotate —llotɨiaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Iaɨmaiaɨ ñaɨa mei, Jacobo raite: ");
INSERT INTO huuNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","—Amatɨaɨ, cuemo cacarei. Judíuaɨñedɨnomo Jesús rafue Simón Pedro nano llua rafuena jai cacadɨcaɨ. Creyentiaɨna naimacɨ jaillena, Jusiñamui naimacɨna jai fetode. ");
INSERT INTO huuNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Jusiñamui facaina lloraɨnɨ mɨcorɨaɨ iena jaie cuetɨmacɨ: ");
INSERT INTO huuNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","18","Jusiñamui jaie llote: “David mɨcorɨ illaɨma isoi illaɨmana illena, cue Jitona ɨco oretaitɨcue. David jɨcorɨ jito illaɨmana birui iñede; iadedɨ David mɨcorɨ ifomo illaɨmana cue Jito iite. Iemona judíuaɨñedɨno cuena ɨɨnoitɨmacɨ. Naimacɨ cue comɨnɨna jaillena jɨaɨ jitaidɨcue. Iena cue llua jira, iena fɨnoitɨcue” llote. ");
INSERT INTO huuNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Ie muidona cue comecɨ raite: Judíuaɨñedɨnomona creyentiaɨna jaidɨnona duere fɨnoñeitɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Naimacɨmo rabena oreta, dama biena llollena: “Jiraraɨmo fecaca llɨcɨsina rɨñeno. O aɨñede rɨño dɨga iñeno. O ɨniñede ɨima dɨga iñeno. Llerɨnoga rana rɨñeno. Dɨruena jɨaɨ rɨñeno”. ");
INSERT INTO huuNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Jaiemona naga sábado naga judíuaɨ ofiracomo judíuaɨdɨ Moisés mɨcorɨ cuegafuiaɨmona naie isoide lletarafuena cacadɨmacɨ. Ie jira naie isoide rafuedo nia jaitɨcaɨ: iadedɨ jɨaɨe Moisés mɨcorɨ lletarafuedo jaiñeitɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Ie mei Cristo oretaganodɨ, creyentiaɨna sedaraɨnɨ dɨga, comecɨaɨna facadɨmacɨ, naimacɨmona comɨnɨna fetollena, Antioquíamo oretallena. Nana creyentiaɨ comecɨaɨna facajano: “Jee” raitɨmacɨ. Pablo, iaɨmaiaɨ Bernabé dɨga, naimacɨna oretaiacadɨmacɨ. Judana fetodɨmacɨ. Naimɨe mamecɨ jɨaɨcɨdɨ Barsabás. Silana jɨaɨ fetodɨmacɨ. Jɨaɨe comɨnɨ baɨfemo rafuena baitadɨiaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Rabena cuetɨmacɨ, iaɨmaiaɨ dɨga oretallena. Iese raillano, cuetɨmacɨ: “Antioquíamo itɨno, Siriamo itɨno, Ciliciamo itɨno, omoɨmo cuetɨcaɨ. Jerusalémo itɨcaɨ. Cristo oretaganodɨcaɨ. Creyentiaɨna sedaraɨnɨdɨcaɨ. Omoɨdɨ caɨ amatɨaɨ. Omoɨmo jai cuetɨcaɨ. Judíuaɨñedɨomoɨ; iadedɨ caɨ amatɨaɨdomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Caɨ motomona jɨaɨe comɨnɨ naimacɨ llofuiado omoɨna uri itatañenana fɨdɨdɨcaɨ. Omoɨ jeacɨnomona omoɨ jilloillena, Moisés mɨcorɨ llogacɨnodo omoɨ jaillana jitaidɨmacɨ. Ie jirari omoɨ comecɨaɨ rucaicuerite. Naimacɨna oretañedɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Danomo caɨ ofilla mei, menamɨena fetodɨcaɨ, omoɨmo oretallena, Bernabé, iaɨmaiaɨ Pablo dɨga. Bernabéna isiruitɨcaɨ. Pablona jɨaɨ isiruitɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Iaɨmaiaɨ caɨ Nama Jesucristo muidona navui niadedɨ fiodaitɨiaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Ie jira Judas, iaɨmaiaɨ Silas dɨga, oretaitɨcaɨ. Omoɨmo bie rabe cuia isoi lloitɨiaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Jusiñamui Joreño caɨmo illamona, bie rafuena omoɨmo lloitɨcaɨ. Ailluena rafue omoɨ fɨnuana lloñeitɨcaɨ. Danɨ bie rafuena fɨnojitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Jiraraɨmo fecaca rana rɨñeno. Dɨruena rɨñeno. Llerɨnoga rana rɨñeno. O aɨñede rɨño dɨga iñeno. O ɨniñede ɨima dɨga iñeno. Iese omoɨ iñenia, marena iitomoɨ. Macaɨbaite” cuetɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Ie mei Antioquíamo jaidɨmacɨ. Ailluena comɨnɨna ofitaja mei, naimacɨmo cartana fecadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Iena facajano, naie lluacɨnori iobidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judas Jusiñamui facaina lloraɨma. Silas daje isoide. Dɨga rafuena creyentiaɨmo llofuetɨiaɨmaiaɨ. Naimacɨ comecɨaɨna jɨaɨ ocuiñotadɨiaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Dɨga irui nainomo illa mei, iaɨmaiaɨna oretatɨnomo creyentiaɨ iaɨmaiaɨna marena abɨdo oretatɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Nainomo Silas comecɨna facajano, fɨebide. Ie jira Judas dama abɨdo jaide. ");
INSERT INTO huuNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Antioquíamo Pablo, iaɨmaiaɨ Bernabé dɨga, caɨ Nama Jesús rafuena llofuellena fɨebidɨiaɨmaiaɨ. Dɨga comɨnɨ jɨaɨ iese llofuetɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Dɨga irui illa mei, Pablo Bernabémo llote: p —Naga navui coco llua naɨraɨmo creyentiaɨ dɨne abɨdo mai coco jai. Caɨ Nama ie mare rafuena dane lloitɨcoco. Nɨe isoi naimacɨ illana jɨbuitɨcoco. ");
INSERT INTO huuNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Bernabédɨ, naie iaɨmaiaɨ dɨga, Juan Marcos uiacade. ");
INSERT INTO huuNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Panfiliamo iaɨmaiaɨna navui Juan faɨnonocaide. Iaɨmaiaɨ dɨga llofuellena jaiñena jira, Pablo naimɨena dane uiacaiñede. ");
INSERT INTO huuNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Rɨire ñaɨtɨiaɨmaiaɨ. Comecɨna daje isoi lloiñedɨiaɨmaiaɨ. Ie jira dajena jaiñedɨiaɨmaiaɨ. Bernabé Juan Marcona uillanona, Chipremo aillue botedo jaidɨiaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Ie mei Pablo Silana uite. “Jusiñamui omɨcona canoite” creyentiaɨ dɨnena raillanona, iaɨmaiaɨna oredɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Siria railla enɨruemo Jesús rafuena llocana jaidɨiaɨmaiaɨ. Cilicia railla enɨruemo jɨaɨ llocana jaidɨiaɨmaiaɨ. Creyentiaɨ comecɨaɨna ocuiñotacana jaidɨiaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Nano Derbemo Pablo, iaɨmaiaɨ Silas dɨga, ridɨiaɨmaiaɨ. Iemona Listramo ridɨiaɨmaiaɨ. Nainomo Timoteo railla creyente ite. Naimɨe eidɨ judía iñaiño. Jɨaɨ creyente. Ie moo mɨcorɨdɨ griego imɨe. ");
INSERT INTO huuNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Listramo ite creyentiaɨ, Iconiomo ite creyentiaɨ dɨga, naimɨena: “Mare” raitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pablodɨ Timoteona uiacade, naimɨe dɨga jaillena. Timoteo moo mɨcorɨ griego imɨena jira, naimɨe abɨna nia detatañede; iadedɨ nainomo ite judíuaɨ illa jira, Moisés mɨcorɨ llua isoi, Pablo Timoteo ie abɨna dete. Judíuñedɨmɨe naimacɨ motomo ia, naimacɨ motomo inide. ");
INSERT INTO huuNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Naga naɨraɨmo naimacɨ jaillanona, Jerusalémo siadogacɨnona creyentiaɨmo llote. Jerusalémo Cristo oretagano, creyentiaɨna sedaraɨnɨ dɨga, navui naicɨnona siadotɨmacɨ. Creyentiaɨ naie lluana ɨɨnollena, iena llocana jaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Ie jira creyentiaɨ ɨɨnocana jaidɨmacɨ. Nagarui ailluena comɨnɨ creyentiaɨna jaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Jusiñamui Joreño Asia railla enɨruemo ie uaina naimacɨ llofuiana rairuilla jira, Frigia railla enɨruemo macaricana jaidɨmacɨ. Iemona Galaciamo jaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Misiamo naimacɨ rillano, Bitiniamo jaiacade; iadedɨ Jesús Joreño dane imacɨ jaillana rairuide. ");
INSERT INTO huuNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Ie jira Misiamona ecɨdo jaillano, Troas railla naɨraɨmo jaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Nainomo naie naɨona Pablo nɨcaɨrilla ra isoidena cɨode. Daje Macedonia imɨedɨ uicomo naidaita naimɨemo jɨca-jɨcanode. Raite: “Macedoniamo ruica o bi. Caɨna canuaɨbi”. ");
INSERT INTO huuNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Naiena Pablo cɨua mei, naie facaisemona Pablo dɨga jaidɨcue. Lucadɨcue. Ie jira bie rafuena raise uiñotɨcue, iena omo cuellena. Macedoniamo ruica dɨne caɨ jaille botena jenodɨcaɨ. Comecɨna facadɨcaɨ: “Jusiñamuidɨ caɨna uaidote, nainomo ie mare rafuena caɨ llollena”. ");
INSERT INTO huuNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Ie jira Troamona Samotraciamo monaillaido atona ie mamedo jaidɨcaɨ. Ie ɨcoitɨdɨruido Neápolis railla naɨraɨmo ridɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Dɨnomona Filipomo duide naɨsodo jaidɨcaɨ. Macedoniamo ite. Naie enɨrue facaise ie nanoca naɨraɨ Filipos. Naie naɨraɨdɨ Romamona bitɨno naɨraɨ. Dɨga irui nainomo itɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Sábadoruido naie naɨraɨmona nasedo jino jaidɨcaɨ. Comecɨna facajamona: “Dɨnomo nɨbaɨ comɨnɨ oficabidɨmacɨ, Jusiñamuimo jɨɨllena”, ille fuemo jaidɨcaɨ. Nainomo dañaiñorie rɨñonɨaɨ billanona, dɨnomo ana raɨdɨcaɨ, naiñaiñuaɨmo Cristo rafuena llollena. ");
INSERT INTO huuNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Naimacɨmona dañaiño caɨ llofuiana eo cacade. Naiñaiño mamecɨdɨ Lidia. Tiatira railla naɨraɨ iñaiño. Naiñaiñodɨ jiduirede ɨniruena fecauide. Jusiñamuina jai sedade. Pablo llofuiana naiñaiño cacajano, caɨ Nama Jesús naiñaiño comecɨ naie lluana feiñotade. Naie facaise creyentena jaide. ");
INSERT INTO huuNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Naiñaiño ie jofomo itɨno dɨga bautizaja mei, caɨmo llote: —Cuedɨ caɨ Namana cue jai ɨɨnuana omoɨ uiñuamona, cue jofomo mai bi, nainomo omoɨ fɨebillesa. —Duere caɨna uai-uaidode. ");
INSERT INTO huuNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Jusiñamuimo jɨɨranomo jɨaɨruido jaidɨcaɨmo, daje jitaɨñomo dafaɨfidɨcaɨ. Naiñaiñodɨ jɨaɨnomona ɨbacañaiño. Janaba anamo naiñaiño jɨaɨ ite. Iemona naiñaiño jɨaɨruido suille rafuena llouide. Naie rafuena lluana ɨbatajano, naiñaiño namaɨaɨdɨ ailluena ucubena feiñouidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Naiñaiñodɨ caɨ jɨnafona jaillanona, ado cuiri-cuiricaide: —Naimacɨ nanoca Jusiñamui ie lloraɨnɨ. Omoɨ jilluana omoɨmo llocabitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Dɨga irui naiñaiñodɨ iese cuiri-cuirisoide. Icɨrillamona, Pablo abɨdo dobaidacaida, naiñaiñomo ite Janabamo llote: —Cue Nama Jesucristo uaido naiñaiñomona oni jai. —Iemona oni jaide. ");
INSERT INTO huuNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Naiñaiño lluamona ucubena jai oñenana naiñaiño namaɨaɨ jai uiñua jira, Pablo, iaɨmaiaɨ Silas dɨga, gaɨtadɨmacɨ. Iaɨmaiaɨna plazamo illaɨcomɨnɨ illanomo sonocana uitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Dɨnomo iaɨmaiaɨna illaɨcomɨnɨ dɨne atɨdɨmacɨ. Iese iaɨmaiaɨna llogɨdotɨmacɨ: —Naie iaɨmaiaɨdɨ caɨ naɨraɨna uri itatañedɨiaɨmaiaɨ. Iaɨmaiaɨ judíuaɨ comɨnɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Romanuaɨ comɨnɨna caɨ illa jira, iaɨmaiaɨ llogacɨnuaɨna caɨ ɨɨnoia, iedo caɨ jaia, maraiñede. ");
INSERT INTO huuNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Iena cacajano, nana comɨnɨ naie iaɨmaiaɨna fanaisɨtɨmacɨ. Illaɨcomɨnɨdɨ naie iaɨmaiaɨ ɨniroina cuaranuanona duiñode. Rasɨ dɨga, iaɨmaiaɨna dɨga icaiño fatatatɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Iaɨmaiaɨna eo faja mei, cárcelmo jonetɨmacɨ. Cárcelna sedaraɨmamo iaɨmaiaɨna raise sedallena llotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Iese llua jira, iaɨmaiaɨna llaveracomo fo iaɨmaiaɨna uite. Donoramo iaɨmaiaɨ eɨllɨaɨ ñuitajano, raise donode. ");
INSERT INTO huuNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Naɨona daferui facai Pablo, iaɨmaiaɨ Silas dɨga, Jusiñamuimo ɨfuerillacɨnona ro-rodɨiaɨmaiaɨ. Jɨaɨ jɨɨdɨiaɨmaiaɨ. Jɨaɨe llavecano naiena cacadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Jamai ebena illacɨnomona ñuisañodɨ suide. Cárcel illanodɨ jaidɨsite. Naie facaiseconi nana nasiaɨdɨ ecocorinaite. Ie dacaiño nana llavecano imacɨ donua radɨ oni ecoride. ");
INSERT INTO huuNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Cárcelna sedaraɨma casidemo, cárcel ie nasiaɨ ecocorinaillana cɨode. “Llavecano jai aisɨdɨmacɨ” raillamo naimɨe comecɨna facade. Ie jira ie lloesɨ aiñoicaida, dama abɨ faɨtaacade. “Illaɨcomɨnɨ bia, ¿bue lloitɨcue?” raillamona comecɨna facade; ");
INSERT INTO huuNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","iadedɨ Pablodɨ eo rɨire cuirioide: —¡O abɨna dama meineñeno! Bene nana itɨcaɨsa. ");
INSERT INTO huuNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Lamparína atɨllena cárcelna sedaraɨma jɨcajanona, jarire fo jaide, Pablo iaɨmaiaɨ Silas dɨne. Jacɨnaillano, naimɨe abɨdɨ docaillamona, iaɨmaiaɨ uicomo caiñɨcɨ ɨfodo ana raɨnadate. ");
INSERT INTO huuNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Iaɨmaiaɨna jino ua mei, nai iaɨmaiaɨmo jɨcanote: —¿Buena fɨnojitɨcue, cue jeacɨnomona cue jilloillena? ");
INSERT INTO huuNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Uai otɨiaɨmaiaɨ: —Coco Nama Jesúna ɨɨno. Iese na o jofomo ite comɨnɨ dɨga o jilloillesa. ");
INSERT INTO huuNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Iemei naimɨena Jesús ie rafuena llofuetɨiaɨmaiaɨ, nana ie jofomo itɨno dɨga. ");
INSERT INTO huuNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Naie facaise iaɨmaiaɨ bofellañona jocode. Iemei naimɨedɨ, nana ie comɨnɨ dɨga, bautizaga. ");
INSERT INTO huuNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Guillena, ie jofomo naie iaɨmaiaɨna uite. Jusiñamuina jai ɨɨnua jira, na ie comɨnɨ dɨga, naimɨe caɨmare ite. ");
INSERT INTO huuNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Ie oni monaidemo, illaɨcomɨnɨdɨ dajerie policíana cárcelmo oretatɨmacɨ, nai iaɨmaiaɨna jino orellena. ");
INSERT INTO huuNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Cárcel sedaraɨmadɨ naie rafuena Pablomo llote. Raite: —Omɨco jaillena, illaɨcomɨnɨdɨ omɨcona oredɨmacɨ. Mai marena jai. ");
INSERT INTO huuNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Iadedɨ policíamo Pablodɨ llote: —Cocodɨ romanuaɨ comɨnɨdɨcoco; iadedɨ cocomo ite rafuena raise uiñoñeno cocona marefodo fatɨmacɨ. Cárcelmo cocona jonetɨmacɨ. Jai bainino cocona jino oretaiacadɨmacɨ. Iese jino jaiñeitɨcoco. Naimacɨmo llono: “Cocona jino ollena bi”. ");
INSERT INTO huuNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Illaɨcomɨnɨmo policías naiena lluaɨbitemo, illaɨcomɨnɨdɨ naiena cacajanona, eo jacɨnaite, romanuaɨ comɨnɨna iaɨmaiaɨna jira. Caɨ nanoca illaɨcomɨnɨdɨ romanuaɨ naɨraɨ comɨnɨna jamai ebena duere fɨnuana rairuidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Ie jira naie iaɨmaiaɨ dɨne illaɨcomɨnɨdɨ jaidɨmacɨ, iaɨmaiaɨna: “Dama dɨno iesede” raillena. Jino atɨa mei, naɨraɨmona jino iaɨmaiaɨ jaillena oredɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Cárcelmona jino billano, Lidia jofomo fo jaidɨiaɨmaiaɨ. Creyentiaɨna cɨuano, naimacɨ comecɨaɨna ocuiñotallena, naimacɨna dane llofuetɨiaɨmaiaɨ. Ie mei oni jaidɨiaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Anfípolis railla naɨraɨmo macaritɨiaɨmaiaɨ. Apolonia railla naɨraɨmo macaritɨiaɨmaiaɨ. Ie mei Tesalónica railla naɨraɨmo ridɨiaɨmaiaɨ. Dɨnomo judíuaɨ ofiracodɨ ite. ");
INSERT INTO huuNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pablo fɨbilla isoi, nainomo fo jaide. Daje amani sábadoruimo Jusiñamuina cuegafuiaɨmona naimacɨna llofuete. ");
INSERT INTO huuNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Iese naimacɨna llofuete: —Cristo llegɨ cacaite. Fiodaillamona naimɨe jilloite. Naimɨedɨ Jesús. ");
INSERT INTO huuNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Naiena cacadɨnomona ailluena ɨɨnotɨmacɨ. Pablo, Silas iaɨmaiaɨ dɨbeimo jaidɨmacɨ. Jusiñamuina ɨɨnote grieguaɨmona ailluena comɨnɨ creyentiaɨna jaidɨmacɨ. Ie emodoconi ailluena nanocañaiñuaɨdɨ creyentiaɨna jɨaɨ jaidɨmacɨ; ");
INSERT INTO huuNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","iadedɨ judíuaɨdɨ uradoillano, jamai itɨnomona eo maraiñede ɨiñɨaɨna uaiduanona, ailluena comɨnɨna ofitatɨmacɨ. Ie jira naie naɨraɨ uri iñedɨmacɨ. Iaɨmaiaɨna comɨnɨ uicomo uillena, Jasón jofomo binaisɨte. ");
INSERT INTO huuNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Iaɨmaiaɨna baiñenano, Jesóna, jɨaɨe creyentiaɨ dɨga, illaɨcomɨnɨ illanomo aiñoicaida uitɨmacɨ. Cuiriisɨte: —Naga naɨraɨmo comɨnɨna uri itatañedɨiaɨmaiaɨ. Benomo jai bitɨiaɨmaiaɨ. Jai benomo billanona, Jasón ie jofomo iaɨmaiaɨna feiñote. ");
INSERT INTO huuNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Caɨ nanoca illaɨma ie llogacɨnona jai ɨɨnoñedɨmacɨ. Ie anamo jai iacaiñedɨmacɨ. Raitɨmacɨ: “Jɨaɨe illaɨma anamo itɨcaɨ. Jesús raillamɨe anamo itɨcaɨ”. ");
INSERT INTO huuNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Judíuaɨ iese lluamona, comɨnɨdɨ uri iñedɨmacɨ. Illaɨcomɨnɨdɨ jɨaɨ uri iñedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","“Naie iaɨmaiaɨ dane biñeitɨiaɨmaiaɨ” illaɨcomɨnɨmo creyentiaɨ raillano, illaɨcomɨnɨdɨ Jasón jɨaɨe creyentiaɨ dɨga, jino oretatɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Naie naɨo creyentiaɨdɨ Pablona, iaɨmaiaɨ Silas dɨga, Bereamo raɨre oretatɨmacɨ. Dɨnomo rillano, judíuaɨ ofiracomo jaidɨiaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Nainomo ite judíuaɨ eo mare. Tesalónicamo ite judíuaɨ isoiñedɨmacɨ. Bereamo itɨnodɨ Cristo rafuena iocɨre feiñotɨmacɨ. Nɨedɨ uanaicɨnoni raillanona, nagarui Jusiñamuina cuegafuiaɨna facadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Ie jira naimacɨmona ailluena ɨɨnotɨmacɨ. Judíuaɨñedɨnomona ailluena nanocañaiñuaɨ ɨɨnotɨmacɨ. Ailluena ɨiñɨaɨ jɨaɨ ɨɨnotɨmacɨ; ");
INSERT INTO huuNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","iadedɨ Bereamo Pablo Jusiñamui ie uaina jai lluana Tesalónicamo ite judíuaɨdɨ fɨdɨano, dɨnomo jaidɨmacɨ. Comɨnɨna fuemo faɨllena, jaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Naie facaise creyentiaɨdɨ Pablona oni oretatɨmacɨ. Monaillai fuemo duide naɨsona oretatɨmacɨ. Silas, iaɨmaiaɨ Timoteo dɨga, fɨebidɨiaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Pablo uigamacɨ naimɨe dɨga Atenamo jaidɨmacɨ. Dane abɨdo Bereamo jaidɨmacɨmo, naimacɨmo Pablo llote: —“Silas, iaɨmaiaɨ Timoteo dɨga, raɨre cue dɨne billesa” llono. ");
INSERT INTO huuNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Atenamo iaɨmaiaɨ rillena Pablo sedademo, naie naɨraɨmo ailluena jiraraɨaɨna cɨode. Iena cɨuanona, Pablo comecɨdɨ jeareficaide. ");
INSERT INTO huuNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Naiena cɨua mei, judíuaɨ ofiracomo judíuaɨ dɨga coninɨri Jusiñamui rafuena siadote. Jusiñamuina jai ɨɨnote judíuaɨñedɨno dɨga coninɨri iena jɨaɨ siadote. Plazamo nagarui jamai itɨno dɨga coninɨri iena jɨaɨ siadote. ");
INSERT INTO huuNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Jamai comecɨna facadɨnomona damɨerie naimɨe dɨga jɨaɨ ñaɨtɨmacɨ. Epicúreo railla rafuedo jaisoidɨmacɨ. Estoico railla rafuedo jɨaɨ jaisoidɨmacɨ. Damɨerie naimacɨmona raitɨmacɨ: —¿Buena nai ñaɨllareuidɨmɨe caɨmo lloiacade? Jɨaɨno raite: —Jɨaɨe naɨraɨ jusiñamuillaɨcaɨmo lloiacade isoide. Jesús fiodaillamona jilluana Pablodɨ llouilla jira, iese raitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Ie jira naimɨena naimacɨ siadouillanomo uitɨmacɨ. Naie illano Areópagona mamecɨrede. Jɨcanotɨmacɨ: —¿Nɨe isoide o comocɨnuaɨ? Caɨmo llono, caɨ uiñollena. ");
INSERT INTO huuNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Eo feiredɨcɨnuaɨna cacadɨcaɨ. ¿Buena nai llofuiacɨnodɨ llote? Iena uiñoiacadɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Nana Atenamo ite comɨnɨ, jɨaɨe illanomona bitɨno dɨga, jamai aillɨ como imacɨ fɨdɨa rafuena ñaɨ-ñaɨdɨmacɨ. Jamai aillɨ fɨdɨa rafuena caca-cacadɨmacɨ. Jɨaɨe rafuena fɨnoñedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Jɨcanua mei, Areópago railla illanomo Pablo naidacaida llote: —Atenas imacɨ, omoɨmo rafuena lloiacadɨcue. Omoɨ jusiñamuillaɨna eo sedacabidomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Cue macarillamona, omoɨ jusiñamuillaɨna sedaja jiraraɨna cɨodɨcue. Daje jiraraɨ abɨmo iese cuega: “Uiñoñega Jusiñamuina sedadɨcaɨ” cuega. Uiñoñeno naimɨena sedadomoɨ. Ja omoɨmo naimɨena lloitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Jusiñamui binɨena jaie fɨnode. Ie emodoconi Jusiñamuidɨ nana binɨemo itɨnona jɨaɨ fɨnode. Naimɨedɨ mona ie Nama. Enɨrue ie Nama. Ie jira ɨima fɨnoca jofomo naimɨe iñede. ");
INSERT INTO huuNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Naga jitaille rana naimɨemo illa jira, naimɨena canonidɨcaɨ. Naimɨe nana comɨnɨna comuitate. Jɨaɨ nagarui jafaicɨ caɨ uadɨ caɨmo iga. Uanai nana rana caɨmo iga. ");
INSERT INTO huuNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Damɨedemona nana comɨnɨna jebuitate, nana enɨruemo naimacɨ illena. Naimacɨ illa dɨnori naimɨe jonega. Naimacɨ illanomo naimɨe jɨaɨ jonega. ");
INSERT INTO huuNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Iese jonega, naimacɨ naimɨena jenollena. Jenuano, nɨbaɨ naimɨena baitɨmacɨ. Caɨmona naimɨe are iñede. ");
INSERT INTO huuNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Naimɨe jaca illa jira, caɨ jɨaɨ itɨcaɨ. Jɨaɨ cajedɨcaɨ. Ie isoi omoɨ rafue lloraɨnɨ jɨaɨ llotɨmacɨ: “Naimɨe ie uruiaɨdɨcaɨ”. ");
INSERT INTO huuNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","’Naimɨe caɨna comuitaja jira, Jusiñamuidɨ jiraraɨ isoiñedena uiñotɨcaɨ. Jusiñamuidɨ oromona fɨnoca ra isoiñede. Platamona fɨnoca ra isoiñede. Nofɨcɨmona fɨnoca ra isoiñede. Ɨima ie onollɨ dɨga fɨnoca ra isoiñede. ");
INSERT INTO huuNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Comɨnɨdɨ abɨ uiñoñeno jeacɨno jaie fɨnouidɨmacɨ. Jusiñamui naimacɨna nia janafeñede; iadedɨ jai birui Jusiñamuidɨ nana comɨnɨna naga illanomo naimacɨ comecɨaɨ iuai meidollena jitaide. ");
INSERT INTO huuNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Naimacɨ comecɨaɨ iuai naimacɨ meidoñenia, naimɨe jai lloga facaise, naimacɨna duere fɨnoite. Naimacɨna duere fɨnollena, ie Jitona jai fetode. Naimacɨ fɨnoca rafuena naimɨe raise uiñuamona, naimacɨna duere fɨnoite. Fiodaillamona Jesúna naimɨe jai jilloitaja jira, iena uiñotɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Fiodaillamona Jesús jilluana cacajano, damɨerie jaɨsitɨmacɨ. Ieconi jɨaɨnodɨ raite: —Jɨaɨruido o lluana dane cacajitɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Iemei naimacɨ motomona Pablo jino jaide. ");
INSERT INTO huuNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Naie comɨnɨmona damɨerie naimɨe dɨbeimo jaidɨmacɨ. Ɨɨnotɨmacɨ. Naimacɨmona damɨe Areópagomo siadouidɨmɨe. Ie mamecɨdɨ Dionisio. Jɨaɨñaiño ɨɨnote. Naiñaiño mamecɨdɨ Dámaris. Daje facaiseconi jɨaɨe comɨnɨdɨ ɨɨnotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Atenamona Corinto railla naɨraɨmo Pablodɨ jaide. ");
INSERT INTO huuNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Nainomo Aquila raillamɨena baisaide. Naimɨedɨ judío imɨe. Ponto railla enɨruedɨ naimɨe comuillano. Ie aɨ mamecɨdɨ Priscila. Naiñaiño dɨga Romamona como bitɨiaɨmaiaɨ. Romamona Claudio nana judíuaɨ comɨnɨna jai oretate. Ie jirari bitɨiaɨmaiaɨ. Roma ie nanoca illaɨmadɨ Claudio. ");
INSERT INTO huuNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Pablo iaɨmaiaɨ daje isoi maɨjɨa jira, Pablo iaɨmaiaɨ jofomo fɨebide. Iaɨmaiaɨ conima dɨga maɨjɨde. Chivos itɨraɨaɨ ie nilla ɨniroina tɨforisoidɨmacɨ, naiemona jofona fɨnollena. ");
INSERT INTO huuNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Naga sábadoruimo judíuaɨ ofiracomo llofuete, judíuaɨna ɨɨnotallena, judíuaɨñedɨnona iena jɨaɨ ɨɨnotallena. ");
INSERT INTO huuNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Macedoniamona Silas, iaɨmaiaɨ Timoteo dɨga, bitemo, Pablodɨ nagarui Jusiñamui uaina llofueuide. Judíuaɨmo: “Jesúdɨ caɨ Jilloitaraɨma” llouide; ");
INSERT INTO huuNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","ia naimɨe uaina ɨɨnosɨñedɨmacɨ. Jɨaɨ naimɨe jɨnafomo jeare ñaɨtɨmacɨ. Naimacɨ comecɨaɨ jeare cɨua jira, Pablo ie ɨniroina jaidɨnote, naimacɨna raillano: —Danɨ omoɨ muidona Jusiñamui omoɨna duere fɨnojite. Cue muidonañeite. Jai judíuaɨñedɨno dɨne jaitɨcue, naimacɨna cue llofuellena. ");
INSERT INTO huuNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Iese raillano, oni jaide. Justo jofomo jaide. Naimɨedɨ Jusiñamuina ɨɨnouidɨmɨe. Ie jofo judíuaɨ ofiraco ecɨmo ite. ");
INSERT INTO huuNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Crispodɨ, nana ie jofomo itɨno dɨga, caɨ Nama Cristona ɨɨnote. Naimɨedɨ judíuaɨ ofiraco ie sedaraɨma. Ailluena Corintomo ite comɨnɨ creyentiaɨna jaidɨmacɨ. Ie mei naimacɨdɨ bautizaga. ");
INSERT INTO huuNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Daje naɨona Pablo nɨcaɨrilla isoidemona, Pablomo caɨ Nama Jesucristodɨ llote: —Mai jacɨruiñeno. Faɨcaiñeno cue rafuena llocana jai. ");
INSERT INTO huuNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","O dɨga iitɨcue. Budɨ ona maraiñeno fɨnoñeite. Bie naɨraɨmo ailluena comɨnɨdɨ cue dɨbeimo jaitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Ie jira daje año ie emodo seis fɨvui dɨnomo Pablodɨ fɨebide, naimacɨmo Jusiñamui uaina llofuellena. ");
INSERT INTO huuNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Corinto railla naɨraɨdɨ Acaya railla enɨruemo jaɨnaɨaɨde. Naie facaise Acaya ie gobernadordɨ Galión. Naie facaiseconi damɨerie judíuaɨ comɨnɨ Pablona faiacadɨmacɨ. Galión dɨne naimɨena uitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Raitɨmacɨ: —Caɨ illaɨma llogacɨno isoi bimɨedɨ comɨnɨna Jusiñamuina sedallena llofueñede. ");
INSERT INTO huuNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pablo uai oiacademo, judíuaɨmo Galióndɨ llote: —Judíuaɨ, cacarei. Naimɨe maraiñede rafuena fɨnodena, naimɨe omoɨna jɨfuetena, omoɨ lluamo nia cacarefidɨcue; ");
INSERT INTO huuNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","iadedɨ jamai naimɨe uaillaɨ cuemo llotomoɨ. Omoɨ usumatɨaɨ mɨcorɨaɨ mamecɨaɨ cuemo jɨaɨ llotomoɨ. Omoɨ einamacɨ llogacɨnuaɨna cuemo jɨaɨ llotomoɨ. Iena omoɨ coninɨri siadotomoɨ. Bie isoide rafuena siadoiacaiñedɨcue. ");
INSERT INTO huuNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Iemona naimɨedɨ nainomona naimacɨna oni orede. ");
INSERT INTO huuNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Ie mei Sóstenena gaɨtadɨmacɨ. Sóstenes ofiraco ie sedaraɨma. Naimɨena gobernador uicomo fanaisɨte; ia naifuena Galión nɨese nɨbaɨñede. ");
INSERT INTO huuNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Naifue suilla mei, nainomo Pablo are fɨebide. Ie mei creyentiaɨna facaduano, Priscila iaɨmaiaɨ Aquila dɨga, Siria railla enɨruemo botedo jaide. Ie uai raise fɨnuana uiñollena, Moisés mɨcorɨ llua isoi, Cencreamo rillano, ie ɨfogɨna rɨjɨruda garetate. ");
INSERT INTO huuNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Efesomo rillanona, iaɨmaiaɨna faɨnonocaide. Judíuaɨ comɨnɨ Jusiñamui rafuena siadollena, Pablodɨ judíuaɨ ofiracomo fo jaide. ");
INSERT INTO huuNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Are naimacɨ motomo fɨebillena naimɨemo jɨcanotɨmacɨ; iadedɨ Pablo dɨnena uai ote: —Fɨebiñeitɨcue— ");
INSERT INTO huuNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Naimacɨna facaduano, llote—. Jerusalémo jaitɨcue; iadedɨ Jusiñamui jitaia, dane omoɨ dɨne abɨdo riitɨcue. —Iemei Efesomona jaide. ");
INSERT INTO huuNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Cesareamo sɨjɨano, Jerusalémo macarite. Creyentiaɨ dɨne jaide. Ie mei Antioquíamo jɨaɨ macarite. ");
INSERT INTO huuNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Nainomo are fɨebilla mei, Pablo dane jaide. Galaciamo macarite. Ie mei Frigiamo macarite. Nana creyentiaɨ imacɨ comecɨaɨna ocuiñotacana jaide. ");
INSERT INTO huuNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Ie facaise Efesomo Apolos raillamɨe Alejandría railla naɨraɨmona ride. Judío imɨe. Naimɨe eo raise llofueuidɨmɨe. Naimɨedɨ Jusiñamui facaina lloraɨnɨ mɨcorɨaɨ cuegafuiaɨ raise uiñote. ");
INSERT INTO huuNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Naimɨedɨ Jesús ie rafuena navui jai cacade. Ie comecɨmona iena eo llote. Jesús rafuena raise llofuete; iadedɨ naimɨe dama Juan mɨcorɨ ie bautizajana uiñote. Nana Jesús fɨnoca rafuena nia uiñoñede. Jusiñamui Joreño feiñuana jɨaɨ uiñoñede. ");
INSERT INTO huuNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Judíuaɨ ofiracomo naimɨe llofuia, jacɨtaiñeno llofuete. Priscila, iaɨmaiaɨ Aquila dɨga, naiena cacadɨiaɨmaiaɨ. Ie jira naimɨena oni eneno uitɨiaɨmaiaɨ. Ie uiñoñega rafuena eo raise naimɨena llofuetɨiaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Acayamo Apolodɨ jaiacana jira, creyentiaɨdɨ naimɨe comecɨna ocuiñotajano, naimɨena oresɨte. Acayamo ite creyentiaɨmo rabemo cuetɨmacɨ. Jusiñamui naimacɨna dueruilla jira, creyentiaɨna jai jaidɨmacɨ. Naimɨena marena feiñollena iese cuetɨmacɨ. Nainomo naimɨe rillanona, creyentiaɨna eo canode. ");
INSERT INTO huuNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Judíuaɨ dɨga marefodo jɨaɨ eo ñaɨte. Iemona naimacɨ uai ollɨnodɨ iñede. Naimɨedɨ Jusiñamui cuegafuiaɨmona Jesúdɨ caɨ Jilloitaraɨmana llofuete. ");
INSERT INTO huuNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Corintomo Apolo nia itemo, naɨraɨaɨ onifedo joide naɨdo jailla mei, Pablo Efesomo ride. Dɨnomo rillanona, creyentiaɨna baite. ");
INSERT INTO huuNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Naimacɨmo jɨcanote: —¿Cristona omoɨ ɨɨnuaruimo Jusiñamui Joreñona feiñotomoɨ? Uai otɨmacɨ: —Jusiñamui Joreñona nia jaca cacaiñedɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Dane jɨcanote: —¿Nɨe isoi omoɨ bautizagaomoɨ? Uai otɨmacɨ: —Juan mɨcorɨ lloga rafue facaina bautizagacaɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pablo uai ote: —Mare. Juan llote: “Omoɨ comecɨaɨ iuaina meido. Iemei bautizallomoɨ”. Ie ifo meidoitɨmɨena comɨnɨ ɨɨnollena llote. Jesúna ɨɨnollena llote. Jesús rafuena omoɨmo raise lloitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Iena cacajano, caɨ Nama Jesús dɨbeido bautizadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Naimacɨmo Pablo ie onollɨna joniamona, Jusiñamui Joreñona feiñotɨmacɨ. Ie mei naimacɨ uiñoñega naɨraɨ uaido ñaɨtɨmacɨ. Jusiñamui Joreño naimacɨmo llua rafuena jɨaɨ llotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Nɨbaɨ nana naimacɨdɨ doce ɨiñɨaɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Sábadoruimo judíuaɨ ofiracomo fo jaillano, naimɨe anamo naimacɨ illana Jusiñamui jitailla jira, Jusiñamui dɨbeimo naimacɨ comecɨaɨ iuaina meiduana Pablodɨ jacɨtaiñeno eo llouide. Nainomo daje amani fɨvui fɨebide. ");
INSERT INTO huuNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Naimacɨmona jɨaɨnodɨ Pablo uaina uaitatɨmacɨ. Jɨaɨ ɨɨnoiacaiñedɨmacɨ. Naimacɨ ɨɨnoñena ira, ofiracomo bitɨnomo: “Cristo rafuedɨ maraiñede” llouidɨmacɨ. Ie jira Pablodɨ creyentiaɨ dɨga naimacɨmona eneno oni jaide. Tiranno ie lloracomo nagarui Pablodɨ llofueuide. ");
INSERT INTO huuNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Mena fɨemona iese llofueuide. Ie jira dɨga Asia railla enɨruemo ite comɨnɨdɨ caɨ Nama ie uaina cacadɨmacɨ. Judíuaɨ cacadɨmacɨ. Judíuaɨñedɨno jɨaɨ cacadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Jusiñamuidɨ Pablona siño rafuena fɨnotate. ");
INSERT INTO huuNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Duidɨnomo comɨnɨdɨ naimɨe jetaca pañueluaɨna uitɨmacɨ. Duidɨnomo naimɨe jetaca ɨniroina jɨaɨ uitɨmacɨ. Naiena jetajamona, duidɨnodɨ jillodɨmacɨ. Janaba anamo itɨnodɨ jɨaɨ jillodɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Naie facaise jamai macarisoidɨno ridɨmacɨ. Judíuaɨ imacɨ. Naimacɨdɨ icoriraɨnɨ. Jesús mamecɨ llɨnuano, jananɨaɨ anamo itɨnomona jananɨaɨna oni oretaiacadɨmacɨ. Jananɨaɨmo raitɨmacɨ: —Pablo llua isoi, Jesús muidona bimacɨmona oni jai. ");
INSERT INTO huuNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Esceva ie siete jitotɨaɨdɨ iese fɨnoacadɨmacɨ. Escevadɨ Jusiñamui dɨga ñaɨraɨma. ");
INSERT INTO huuNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Janabana oni oretaiacadɨmacɨmo, Janaba dɨnena uai ote: —Jesúna uiñotɨcue. Pablona jɨaɨ uiñotɨcue; iadedɨ omoɨna uiñoñedɨcue. ");
INSERT INTO huuNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Ieconi Janaba anamo itɨmɨe naimacɨ emodomo daiacaide. Rɨire nana naimacɨna emodoficaide. Ie jira naie jofomona taɨmɨiaɨna jino aisɨdɨmacɨ. Naimacɨdɨ bofellaɨaɨ dɨga jino aisɨdɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Nana Efesomo itɨno iena fɨdɨdɨmacɨ. Judíuaɨ, judíuaɨñedɨno dɨga, naifuena fɨdɨdɨmacɨ. Naifuena fɨdɨanona, eo jacɨnaitɨmacɨ. Iemona caɨ Nama Jesús mamecɨdɨ are soride. Comɨnɨ dɨnena: “Jesús uai eo siño” raitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Ie jira ailluena creyentiaɨdɨ billano, imacɨ navui maraiñede fɨnoca rafuena Jusiñamuimo llotɨmacɨ. Icorilla rafuena fɨnouidɨmacɨ. Iena marefodo llotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Ailluena icorilla rafuiaɨ illabiaɨ atɨanona, marefodo jobaidɨmacɨ. Nɨga raifi rabiaɨ jobaillana facadɨmacɨ. Cincuenta mil ucube dɨese facai rabiaɨna jobaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Caɨ Nama Jesús uaina eo llocana jaide. Comɨnɨdɨ naie uai siñonana uiñotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Naie rafue illa mei, Pablodɨ comecɨna facajano raite: “Macedoniamo cue macarillamona, Acayamo cue jɨaɨ macarillamona, Jerusalémo riacadɨcue”. Ie emodoconi naimɨedɨ raite: “Nainomona Romamo jɨaɨ jaiacadɨcue”. ");
INSERT INTO huuNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Naimɨe nia Asiamo nano nɨgarui illanona, mena canoraɨmana Macedoniamo oretate. Timoteona, iaɨmaiaɨ Erasto dɨga, oretate. ");
INSERT INTO huuNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Naie facaiseconi Pablo nia oni jaiñenia, Jesucristo rafue muidona Efesomo ite comɨnɨdɨ maraiñede rafuena comuitatɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Demetrio raillamɨe platamona dɨga rana fɨnouide. Naimɨedɨ Diana ie jofo joreñuaɨna fɨnouide. Naimɨe anamo ailluena maɨjɨuidɨmacɨ. Dianadɨ naimacɨ jusiñamui. ");
INSERT INTO huuNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Naimɨe isoi maɨjɨuidɨnona Demetrio uaidote, nana naimacɨ danomo ofillena. Ie mei raite: —Jai danomo ofidɨcaɨ. Bie maɨjɨamona caɨ ucubena uana raise uiñotomoɨ; ");
INSERT INTO huuNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","iadedɨ Pablo raillamɨedɨ dɨga comɨnɨna jai llofuete: “Comɨnɨ fɨnoca ranɨaɨdɨ jusiñamuillaɨñede”. Naie llofuiamona ailluena comɨnɨ naimɨe dɨbeimo jaidɨmacɨ. Dama Efesomo iese suiñede; iadedɨ ua nana Asiamo iese suide. ");
INSERT INTO huuNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Ie jira abɨna rairuiacadɨcaɨ, caɨ maɨjɨlle faɨfi raillano, comɨnɨ Diana jofona jɨaɨ sofei raillanona. Comɨnɨdɨ naiñaiñona ebiruillana feitaitɨmacɨ. Naiñaiñori raijicaiñeitɨmacɨ. Dianadɨ eo ebirede jusiñamui. Nana Asiamo ite comɨnɨ naiñaiñona sedacabidɨmacɨ. Uanai nana bie enɨruemo ite naɨraɨdɨ naiñaiñona sedacabidɨmacɨ. Ie jira abɨna rairuiacadɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Iena cacajano, eo icɨritɨmacɨ. Rɨire cuiriidɨmacɨ: —¡Efeso ie Diana eo ebirede! ");
INSERT INTO huuNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Danɨrie siaduamona, nana comɨnɨ eo faɨlliñaidɨmacɨ. Iemo nana comɨnɨ dajena naimacɨ ofiracomo fo raɨre jaisɨte. Gayona, iaɨmaiaɨ Aristarco dɨga, gaɨtajano uitɨmacɨ. Naie iaɨmaiaɨdɨ Pablo ie nabai iaɨmaiaɨ. Iaɨmaiaɨ comuillanodɨ Macedonia. ");
INSERT INTO huuNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pablo ofiracomo jɨaɨ fo jaiacade; iadedɨ creyentiaɨdɨ naimɨe fo jaillana rairuidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Illaɨcomɨnɨmona damɨerie nabaiñɨaɨ naimɨemo fo jaillana jɨaɨ rairuidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Fo itɨnomona damɨerie daje rafuena ebena cuiriidɨmacɨ. Jɨaɨno jɨaɨfuena ebena cuiriidɨmacɨ. Eo faɨlliñaidɨmacɨ; ie iadedɨ bue ñellena naimacɨ ofillana raise uiñoñedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Comɨnɨ motomona judíuaɨ dɨnena damɨe uicomo oredɨmacɨ. Ie mamecɨdɨ Alejandro. Comɨnɨna llɨɨcaitallena, ie onollɨ jaidɨanona, comɨnɨmo lloiacade; ");
INSERT INTO huuNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","iadedɨ naimɨe judío imɨena naimacɨ uiñuanona, nana daacaiño cuiriidɨmacɨ. Mena horas raifi cuiri-cuiriidɨmacɨ: —¡Efeso ie Diana eo ebirede! ");
INSERT INTO huuNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Iemei naie naɨraɨ rabe cueraɨmadɨ comɨnɨna llɨɨcaitatate. Naimacɨ llɨɨcailla meinoconi, naimɨe lluacɨnona cacadɨmacɨ. Raite: —¡Cacarei! Caɨ naɨraɨdɨ Dianana sedacabidɨcaɨ. Naiñaiño ebiredɨñaiño. Naiñaiñona eruaɨde jiraraɨdɨ monamona jaie uaide. Iena jɨaɨ sedacabidɨcaɨ. Nana bie enɨruemo ite comɨnɨ iena uiñotɨmacɨ. Bu naiena uiñoñedɨmɨena jaca iñede. ");
INSERT INTO huuNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Bu cue lluana jaca uaitañeite. Ie jira omoɨ llɨɨcai. Comecɨaɨ facañeno buena fɨnoñeno. ");
INSERT INTO huuNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","¿Bue ñellena Gayo iaɨmaiaɨ Aristarco dɨga, benomo atɨdomoɨ? Iaɨmaiaɨdɨ caɨ jusiñamui joreñona ñaɨñedɨiaɨmaiaɨ. Naiñaiñona jeare fɨnoñedɨiaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Demetrio, ie maɨjɨraɨnɨ dɨga, iaɨmaiaɨna llogɨdoiacania, comɨnɨna llogɨdoraco ite. Dɨga jueces jɨaɨ ite. Coniniri nainomo iena siado; ");
INSERT INTO huuNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","iadedɨ jɨaɨ nɨcɨno omoɨmo ia, caɨ illaɨcomɨnɨ ofia, biena siaduano, caɨmo lloitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Birui bie rafue caɨ fɨnua jira, illaɨcomɨnɨ nɨbaɨ caɨna duere fɨnoitɨmacɨ. ¿Nɨese caɨ nɨbaɨlle? Illaɨcomɨnɨ caɨmo biena jɨcanoia, ¿nɨese raitɨcaɨ? ");
INSERT INTO huuNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Naie llua mei, ofidɨnona jino orede. Iemei jai jono tuudɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Efesomo ite rafue suilla mei, Pablodɨ creyentiaɨna uaidote. Naimacɨ comecɨaɨna ocuiñotafuena llote. Iemei naimacɨna naimɨe facaduano, Macedonia railla enɨruemo jaide. ");
INSERT INTO huuNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Nainomo ite naɨraɨaɨmo macarite. Comecɨna ocuiñotallena, naimacɨna llofuecana jaide. Iese Macedoniamona Grecia railla enɨruemo risaide. ");
INSERT INTO huuNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Nainomo daje amani fɨvui illa mei, Siriamo botedo abɨdo jaiacade; iadedɨ judíuaɨdɨ naimɨena meineiacanana Pablo fɨdɨano, Macedoniamo abɨdo macarite. ");
INSERT INTO huuNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Jɨaɨno naimɨe dɨga jaidɨmacɨ. Sópater jaide. Naimɨedɨ Berea naɨraɨ imɨe. Pirro jito. Aristarco, iaɨmaiaɨ Segundo dɨga, jaide. Tesalónica naɨraɨ imɨe iaɨmaiaɨ. Gayo naimɨe dɨga jɨaɨ jaide. Gayodɨ Derbe naɨraɨ imɨe. Timoteo naimɨe dɨga jɨaɨ jaide. Tíquico, iaɨmaiaɨ Trófimo dɨga, jɨaɨ jaidɨiaɨmaiaɨ. Asia imɨe iaɨmaiaɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Coco uicodo naimacɨ jaillano, Troamo cocona sedadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Llomenico guillaruillaɨ railla rafue fuilla mei, Filipomona jaidɨcoco. Monaillaido dabecuirorui coco jailla mei, Troamo naimacɨ dɨga dane danomo dafaɨfidɨcoco. Nainomo siete dɨgarui fɨebidɨcoco. ");
INSERT INTO huuNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Domingoruimo Jesús fiodaillana comecɨllena, danomo ofidɨcaɨmo, Pablodɨ caɨna llofuete. Ɨcoitɨ naimɨe jaiacana jira, Pablo are ñaɨte. Naɨona jitoma daferui illa facai nia ñaɨte. ");
INSERT INTO huuNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Caɨ ofillanomo ailluena lamparínɨaɨ ite. ");
INSERT INTO huuNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Pablo are ñaɨa jira, daje coniruemo ɨnɨaɨcɨdɨ suide. Naie conirue mamecɨdɨ Eutico. Naimɨedɨ ventanamo raɨde. Naimɨe eo ɨnɨa jira, ventanamona ana uaide. Tercer pisomo a itɨcaɨ. Nainomona enɨruemo naimɨedɨ uaide. Ana jɨbuisaɨbidemo, naimɨena meniñocaidemo, naimɨe jai fiodaillana cɨodɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Ie jira Pablo ana jaide. Naimɨe emodomo jɨtadacaida, naimɨena meniñote. Comɨnɨmo llote: —Omoɨ rucaicueriñeno. Naimɨe cajede. Jafaicɨna nia faɨte. ");
INSERT INTO huuNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Abɨdo a jaidɨmacɨ. Jesús fiodaillana comecɨllena, llomenicona taɨruano, comɨnɨmo Pablo fecade. Guilla meinomo, naimacɨ dɨga naimɨe are ñaɨte, monaiacademo. Ie mei oni jaide. ");
INSERT INTO huuNT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Nainomona conirue jai cajede uitɨmacɨ. Ie jira nana naimacɨ naimɨeri eo iobidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Pablodɨ Troamona Asón railla naɨraɨmo arɨdo jaiacana jira, botedo jaidɨcaɨ. Iese uicomo Asónmo jaidɨcaɨ. Nainomona Pablona botedo uiacadɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Ie jira Asónmo naimɨena caɨ baillanona, caɨ dɨga botemo bite. Ie mei Mitilene railla naɨraɨmo jaidɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Nainomona dane monaillaido caɨ jaillano, ie areruido Quío railla naɨraɨmo ruicafebellemo jaidɨcaɨ. Dane ie areruido Samos railla naɨraɨ mamedo atona jaidɨcaɨ. Ie areruido dane caɨ jaillano, Miletomo sɨjɨdɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Abɨ juarenia, Pentecostés railla rafue suillɨruimo naimɨe Jerusalémo iacade. Pentecostés trigo ua ie rafue. Pascua rafue illa meinoconi, cincuenta dɨgarui illanona bie rafue ite. Asia railla enɨruemo naimɨe are iacaiñena jira, Pablo comecɨna facade: “Efeso ecɨdo monaillaido jaitɨcaɨ”. ");
INSERT INTO huuNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Creyentiaɨna sedaraɨnɨna uaidollena, Miletomona Efesomo Pablo cartana orede. ");
INSERT INTO huuNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Naimɨe dɨne naimacɨ rillanona, Pablo naimacɨmo llote: —Asiamo nano cue rillaruimona, nɨese omoɨ dɨga nagarui cue illana uiñotomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Caɨ Nama dɨga abɨna ɨedoñeno maɨjɨuidɨcue. Eecana sure maɨjɨdɨcue. Judíuaɨ cuena duere uiñodosɨa jira, ie facaiseconi dueredɨcue. ");
INSERT INTO huuNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Cuemo ite marecɨnona omoɨmo jaca janoñedɨcue. Nana Jusiñamui rafuena omoɨmo jai llotɨcue. Omoɨ ofillanomo omoɨna llofueuidɨcue. Omoɨ jofuemo omoɨna jɨaɨ llofueuidɨcue. ");
INSERT INTO huuNT_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Judíuaɨna llofuetɨcue. Judíuaɨñedɨnona daje isoi llofuetɨcue. Jusiñamui dɨbeimo omoɨ comecɨaɨ iuaina meiduana llotɨcue. Caɨ Nama Jesúna omoɨ ɨɨnuana jɨaɨ llotɨcue. ");
INSERT INTO huuNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Jusiñamui Joreñodɨ cuena jai jaicaitaja jira, Jerusalémo birui jaitɨcue. Nainomo ramo cue jirille rafuena uiñoñedɨcue; ");
INSERT INTO huuNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","iadedɨ Jusiñamui Joreño naga naɨraɨmo cuemo llote: “Llaveracomo ona gaɨtajano ona jonesɨite. Duere sefuitɨo”. ");
INSERT INTO huuNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Cue ille dɨnori are illemo comecɨna facañedɨcue. Dama cue ille dɨnori fuidoiacadɨcue. Caɨ Nama Jesúmona cue feiñoga maɨjɨana fuidoacadɨcue. Mare rafuena omoɨmo lloiacadɨcue. Jusiñamui omoɨna duenaillana jɨaɨ llotɨcue. ");
INSERT INTO huuNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Jusiñamui anamo omoɨ illa rafuena omoɨmo jai llotɨcue. Jai dane cue uiecona cɨoiñeitomoɨ. Iena uiñotɨcue. ");
INSERT INTO huuNT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","27","Cue uaina jaca janoñedɨcue; ia nana Jusiñamui uai omoɨmo llotɨcue. Ie jira cuemona omoɨ dɨga cue comecɨ mare. Jusiñamui uaido omoɨ jaiñenia, cue muidonañeite. ");
INSERT INTO huuNT_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Mai omoɨ abɨ rairui. Jusiñamui Joreñodɨ omoɨna creyentiaɨna sedatate. Naimacɨna raise seda. Jusiñamui dɨbeimo itɨnona llofue. Naimɨe Jito fiodailla muidona, naimacɨna ote, naimɨe iena. ");
INSERT INTO huuNT_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Naimacɨdɨ toɨca llaudaɨaɨ isoidɨmacɨ. Nia abɨna raise uiñoñedɨmacɨ. Cue jailla meinoconi, taɨno lloraɨnɨdɨ, janallari isoi, omoɨmo biite. Naimacɨ nana omoɨ sedaca comɨnɨna ramo faɨte, danomo abɨdo naimacɨ jaillena, jɨconɨaɨ llaudaɨaɨ gaɨtaja isoi. ");
INSERT INTO huuNT_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Omoɨmona uanaiñedɨcɨnona lloraɨnɨdɨ iite. Creyentiaɨna ramo faɨtɨmacɨ, omoɨ lluacɨnona faɨnonocaillena, naimacɨ dɨbeimo illena. ");
INSERT INTO huuNT_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Ie jira abɨna rairui. Bie rafuena feitañeno. Daje amani fɨemona nana omoɨna jai llofuetɨcue. Naɨona omoɨna llofuetɨcue. Aremona omoɨna jɨaɨ llofuetɨcue. Omoɨna cue duenaillamona, eianona omoɨna llofuetɨcue. ");
INSERT INTO huuNT_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Mai. Caɨ Nama illa anamo omoɨna faɨnonocaitɨcue. Naimɨe uaimona naimɨe omoɨna duenaillana jai uiñotomoɨ. Naie uaidɨ omoɨna jɨaɨ ocuiñotaite. Iemona Cristona ɨɨnocana jaitomoɨ. Nana naimɨe fetocano dɨga naimɨe illanomo ɨco jaca iitomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Jɨaɨno ie ucubena jaca nɨcɨdoñedɨcue. Bu ie ɨniroillaɨna jaca jɨaɨ oiacaiñedɨcue. ");
INSERT INTO huuNT_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Cue jitaille rana dama cue maɨjɨano otɨcue. Cue dɨga jaidɨno imacɨ jitaille rana jɨaɨ dama cue maɨjɨano otɨcue. Iena nana omoɨdɨ uiñotomoɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Iese cue illamona omoɨna llofuetɨcue. Iese maɨjɨano duerede comɨnɨna canocana jaiacadɨcaɨ. Caɨ Nama Jesús ie llogacɨnona uiñotɨcaɨ. Naimɨe raite: “Raruiaɨna caɨ feiñoia, iobidɨcaɨ; iadedɨ caɨ eo iobiacania, jɨaɨnomo raruiaɨna fecadɨcaɨ”. ");
INSERT INTO huuNT_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Naie llua meino, naimacɨ dɨga caiñɨcɨ ɨfodo raɨnadajano, Jusiñamuimo jɨɨde. ");
INSERT INTO huuNT_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Nana naimacɨdɨ eo eedɨmacɨ. Pablona caɨmaduanona, naimɨena llibanotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","“Cuena dana cɨoiñeitomoɨ” naimacɨmo llua jira, eo sunaitɨmacɨ. Ieconi naimɨe dɨga botemo jaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Naimacɨna caɨ facadua meinoconi, suiñodɨcaɨ. Cos railla naɨraɨmo atona jaidɨcaɨ. Ie are Rodas railla uiasimo ridɨcaɨ. Iemei Pátara railla naɨraɨmo ridɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Nainomo Fenicia railla enɨruemo jaiacade botena baitɨcaɨ. Nai botemo caɨ jailla mei, suiñodɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Chipre railla uiasina caɨ cɨojia, caɨ nabei dɨbeimo ite. Iemei Siria railla enɨruemo jaidɨcaɨ. Tiro railla naɨraɨmo sɨjɨdɨcaɨ. Botedo uiga raruiaɨna nainomo joneacadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Tiromo ite creyentiaɨ caɨ baillanona, siete dɨgarui naimacɨ dɨga itɨcaɨ. Jerusalémo naimɨena judíuaɨ meineñellena, nainomo naimɨe jaiñellena, Jusiñamui Joreño naimacɨna Pablomo llotatate. ");
INSERT INTO huuNT_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Dɨgarui illa meinomo oni jaidɨcaɨ. Naie naɨraɨmona nana naimacɨ caɨ dɨga jaidɨmacɨ. Rɨñonɨaɨ, naimacɨ uruiaɨ dɨga, jaidɨmacɨ. Caiñɨcɨ ɨfodo monaillai fuemo ana raɨnadajano Jusiñamuimo jɨɨdɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Naimacɨ facadua meinoconi, botemo jaidɨcaɨ. Naimacɨ imacɨ jofuemo abɨdo jaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Tiromona Tolemaida railla naɨraɨmo jaidɨcaɨ. Creyentiaɨna uaiduano, darui naimacɨ dɨga itɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Ie are jaillano, Cesareamo caɨ ria, Felipe jofomo jaidɨcaɨ. Felipedɨ Jesucristo ie rafuena lloraɨma. Jerusalémo diáconuaɨna creyentiaɨ jaie fetua facaise, Felipena fetodɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Naimɨe dɨnomo fɨebidɨcaɨ. Naimɨemo cuatro jisa ite. Naiñaiñuaɨ nia ɨima abɨna uiñoñede. Jusiñamui naiñaiñuaɨmo lluacɨnona llocabitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Dɨgarui nainomo caɨ illamo Judeamona damɨe bite. Naimɨe mamecɨ Agabo. Jusiñamui facaina lloraɨma. ");
INSERT INTO huuNT_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Caɨmo ria, naimɨedɨ Pablo cinturóna aiñode. Naie dɨga ie eɨllɨna maɨte. Ie onollɨna jɨaɨ maɨte raillano: —Jusiñamui Joreño raite: “Jerusalémo judíuaɨ illaɨcomɨnɨ bie cinturón jaɨnaoide ɨimana daje isoi maɨtɨmacɨ. Judíuaɨñedɨnomo naimɨena fecajitɨmacɨ” raite. ");
INSERT INTO huuNT_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Naiena caɨ cacajano, naie comɨnɨ dɨga, Pablona caidɨdɨcaɨ, naimɨe Jerusalémo jaiñellena. ");
INSERT INTO huuNT_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Pablo uai ote: —¿Bue ñellena eedomoɨ? ¿Bue ñellena cue comecɨna ocuiñotañedomoɨ? Cue maɨana jaca jitaidɨcue. Ua cue fiodaillana jaca jɨaɨ jitaidɨcue. Cue Nama Jesús muidona cue fiodaiadedɨ, damamai fiodaitɨcue. ");
INSERT INTO huuNT_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Caɨ lloga uai naimɨe ɨɨnoñena muidona, raitɨcaɨ: —Caɨ Nama jitaille rafuena fɨnuana jitaidɨcaɨ. —Iemei llɨɨcaidɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Nano nɨgarui illanona, caɨ raruiaɨna fɨnuano, Jerusalémo jaidɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Cesareamo ite creyentiaɨmona jɨaɨno caɨ dɨga jaidɨmacɨ. Mnasón jofomo caɨna uitɨmacɨ. Naimɨedɨ Chipre railla uiasi imɨe. Naimɨedɨ nano bie rafue taɨniamona creyente. ");
INSERT INTO huuNT_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Jerusalémo caɨ ria, creyentiaɨdɨ caɨna caɨmare uaidotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Ie are Pablo, caɨ dɨga, Jacobo dɨne jaide. Nana creyentiaɨna sedaraɨnɨ nainomo jai ofidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Uaidua mei, Pablo nagacɨnuaɨdo Jusiñamui judíuaɨñedɨnomo fɨnoca rafuena llote: —Cue llofuiamona ailluena judíuaɨñedɨno creyentiaɨna jaidɨmacɨ —llote. ");
INSERT INTO huuNT_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Naie rafuena cacajano, Jusiñamuimo iobillacɨnona fecadɨmacɨ. Iemei naimɨemo llotɨmacɨ: —Ama, ero, judíuaɨmona ailluena comɨnɨ jai creyentiaɨna jaidɨmacɨ; ia nana naimacɨ Moisés mɨcorɨ llogacɨnodo eo jaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","O fɨnoca rafuena jai fɨdɨdɨmacɨ. Ona comɨnɨ ñaɨana jai fɨdɨdɨcaɨ. Jɨaɨe naɨraɨ motomo ite judíuaɨna Moisés mɨcorɨ llogacɨnona faɨnonocaillana llofuetɨo. Naimacɨ uruiaɨ abɨna deñenana llofuetɨo. Moisés mɨcorɨ llogacɨnuaɨdo jaiñellena llofuetɨo. ");
INSERT INTO huuNT_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Ie jira ¿nɨese nɨbaɨitɨcaɨ? O rillana jai fɨdɨdɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Ie jira omo caɨ lluana fɨno. Caɨ ecɨmo cuatro ɨima jai ite. Nɨe isoide rafuena Jusiñamuimo jai llotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Jusiñamui jofomo naimacɨna uiño. Naimacɨ dɨga Moisés mɨcorɨ llua isoi, o abɨ fɨno. Naie rafuena raise fuidollena, Jusiñamuimo fecallena, toɨca ocainaɨaɨna naimacɨ facaina ɨba. Naie rafue omoɨ fuiduanona, omoɨ ɨfogɨna rɨjɨruda gareitomoɨ. Ie mei nana comɨnɨ mare rafuena o fɨnocana jaillana uiñoitɨmacɨ. Moisés mɨcorɨ llogacɨnodo o nia jaillana uiñoitɨmacɨ. Iese omo lloiacadɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Judíuaɨñedɨno Moisés mɨcorɨ llogacɨnodo jaillena lloñeitɨcaɨ. Naimacɨmona creyentiaɨna jaidɨnomo navui cuetɨcaɨ: “Jiraraɨmo fecaca rana rɨñeno. Dɨruena rɨñeno. Llerɨnoga rana rɨñeno. O aɨñede rɨño dɨga iñeno. O ɨniñede ɨima dɨga iñeno” cuetɨcaɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Pablo “Jee” raillanona, nai cuatro ɨima dɨga ie are Moisés mɨcorɨ llogacɨnona fɨnuano, Jusiñamui jofomo jaide, naimɨe ie fɨnoca rafue fuillarui llollena. Jusiñamuimo nagamɨiaɨ rana fecajaruina jɨaɨ llote. Siete dɨgarui illanona, Moisés mɨcorɨ llua isoi, naie rafuena fuidoiacadɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Naie siete iruillaɨ fuiacanaruillaɨmo Asiamona damɨerie judíuaɨdɨ bitɨmacɨ. Jusiñamui jofomo Pablona cɨuano, comɨnɨ comecɨaɨna feidocana uitɨmacɨ. Pablona gaɨtajanona, ");
INSERT INTO huuNT_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","cuiriidɨmacɨ: —Caɨmacɨ, caɨna cano. Bimɨe naga illanomo llofuiamona, comɨnɨna raise itatañede. Moisés mɨcorɨ llogacɨnuaɨdo jaiñede. Bifona raise sedañede. Judíuaɨñedɨno bifomo atɨano, bie mare jofo naimɨe jai jeare fɨnode. ");
INSERT INTO huuNT_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Iese ite: Jerusalémo Trófimo dɨga Pablona cɨodɨmacɨ. Trófimodɨ Efeso naɨraɨ imɨe. Judíuñedɨmɨe. Pablo naimɨena Jusiñamui jofomo uillamo comecɨna facadɨmacɨ; iadedɨ uiñede. Judíuaɨ comɨnɨmona judíuñedɨmɨe Jusiñamui jofomo jaillana maraiñede. ");
INSERT INTO huuNT_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Asiamona bitɨno cuiriillamona, nana Jerusalémo ite comɨnɨ icɨrinaidɨmacɨ. Aisɨcana Jusiñamui jofomo jarire ofidɨmacɨ. Pablona gaɨtajanona, naifomona naimɨena jino sonodɨmacɨ. Ie mei Jusiñamui jofona sedaraɨnɨ nasena ɨbaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Pablona meineiacania, soldaduaɨ ie comandantedɨ nana comɨnɨ ɨeillana fɨdɨde. ");
INSERT INTO huuNT_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Ieconi naimɨedɨ, ie soldaduaɨ dɨga, nana ie illaɨcomɨnɨ dɨga, comɨnɨ dɨne aisɨcana bitɨmacɨ. Ie jira comɨnɨdɨ naimacɨna cɨuano, Pablona fajana faɨnonocaidɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Comandante naimɨemo iaɨreicaia, Pablona gaɨtade. Naimɨena mena lloeo dɨga maɨllena llote. Jɨcanote: —¿Bu naimɨedɨ? ¿Bue ñete? ");
INSERT INTO huuNT_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Nana ɨeidɨnodɨ jɨaɨforie llotɨmacɨ. Ie jira naie rafuena naimɨe jaca uiñoñede. Ie muidona cuatelmo naimɨena uillena llote. ");
INSERT INTO huuNT_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Cuartel tɨdabacuimo naimacɨ ria, comɨnɨ jarire jailla jira, soldaduaɨ Pablona uitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Ailluena comɨnɨ racadɨmacɨ. Ocuioisɨte: —¡Naimɨena meine! ");
INSERT INTO huuNT_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Cuartelmo jaiacania, Pablo comandantemo llote: —O dɨga ñaɨacadɨcue. Raijicaillamona, naimɨe uai ote: —Griego uaido ñaɨtɨo— ");
INSERT INTO huuNT_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Jɨaɨ llote—. Egipto imɨeñedɨo. Navui jobaime fɨnodɨo. Jofue iñenanomo, cuatro mil comɨnɨna meinetɨnona uitɨo. ");
INSERT INTO huuNT_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Pablo uai ote: —Naimɨeñedɨcue. Judío imɨedɨcue. Ciliciamo ite Tarso railla naɨraɨmona bitɨcue. Naie naɨraɨ mamecɨdɨ are soride. Comɨnɨmo cue llollena, omo jɨcanoiacadɨcue. ");
INSERT INTO huuNT_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","—Jee —raite. Pablo tɨdabacui muidomo naidaide. Comɨnɨna llɨɨcaitallena, ie onollɨna jaidɨde. Comɨnɨ llɨɨcailla mei, Pablo judíuaɨ uaido naimacɨmo llote: ");
INSERT INTO huuNT_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","—Caɨmacɨ, einamacɨ, cue abɨ rɨiduacɨnomo mai omoɨ cacarei. ");
INSERT INTO huuNT_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Naimɨe judíuaɨ uaido lluana naimacɨ cacajano, llɨɨcaidɨmacɨ. Ie jira Pablo llote: ");
INSERT INTO huuNT_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","—Judío imɨedɨcue. Ciliciamo ite Tarso railla naɨraɨmo jeicɨgacue. Bene omoɨ naɨraɨmo escuelamo jaidɨcue. Gamalielmona fueotɨcue. Moisés mɨcorɨ llogacɨnuaɨna eo raise facadɨcue. Jusiñamui rafuedo birui omoɨ isoi jaidɨcue. ");
INSERT INTO huuNT_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Jesucristo ɨɨnotɨnona jaie eo duere fɨnodɨcue. Dɨga creyentiaɨna maɨanona, cárcelmo jonetɨcue. Ɨiñɨaɨna duere fɨnodɨcue. Rɨñonɨaɨna jɨaɨ duere fɨnodɨcue. ");
INSERT INTO huuNT_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Jusiñamui dɨga nanoca ñaɨraɨma cuena uiñote. Nana omoɨ illaɨcomɨnɨ cuena uiñotɨmacɨ. Creyentiaɨna duere fɨnollena, naimacɨmona dajerie cartana jaie feiñotɨcue. Damascomo ite judíuaɨmo cuetɨmacɨ. Damascomo jaidɨcue, nainomo ite creyentiaɨ maɨano, Jerusalémo atɨanona, naimacɨna duere fɨnollena. ");
INSERT INTO huuNT_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","’Omoɨmo bie rafuena lloitɨcue. Jerusalémona jaidɨcue; iadedɨ Damascomo cue iaɨreicaia, jitoma naidai iacania, ieconi monamona damɨe cue abɨna eo quetiñote. ");
INSERT INTO huuNT_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Enɨruemo ana uaidɨcue. Monamona damɨe cuemo lluana cacadɨcue: “Saulo, Saulo, ¿bue ñellena cuena duere fɨnodɨo?” ");
INSERT INTO huuNT_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Jɨcanotɨcue: “¿Budɨo?” Monamona damɨe uai ote: “Nazaret ie Jesúdɨcue. Cuena duere fɨnodɨo”. ");
INSERT INTO huuNT_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Cue dɨga itɨnodɨ cue quetiñua rana cɨodɨmacɨ; iadedɨ cue dɨga ñaɨtɨmɨena cacaiñedɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Raitɨcue: “Nama, ¿bue ñeitɨcue?” Caɨ Nama cuena raite: “Naidadajanona, Damascomo jai. Nainomo o fɨnolle rafuena omo lloitɨcue”. ");
INSERT INTO huuNT_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","’Cuena eo quetiñua jira, cɨoiñedɨcue. Cue dɨga itɨno cue onollɨdo llɨnocaida, Damascomo cuena uitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Nainomo Ananías raillamɨedɨ ite. Jusiñamuina eo ɨɨnote. Moisés mɨcorɨ llogacɨnuaɨdo eo jaisoide. Nainomo ite judíuaɨdɨ naimɨena: “Mare” raitɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Naimɨe cuemo bite. Cuemo llote: “Saulo, ama, mai oni eroda”. Ieconi dane erodajanona, naimɨena cɨodɨcue. ");
INSERT INTO huuNT_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Naimɨe raite: “Caɨ usumatɨaɨ mɨcorɨaɨ ie Jusiñamuidɨ ona fetode, naimɨe jitaille rafuena o uiñollena, ie mare Jitona o cɨoillena, naimɨe uaina o cacareillena. ");
INSERT INTO huuNT_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Nana comɨnɨmo naimɨena lloitɨo. Nana o cɨua rafuena lloitɨo. Nana o cacaja rafuena jɨaɨ lloitɨo. ");
INSERT INTO huuNT_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Mai cue lluana ɨɨno. Naidadajanona, o jeacɨno oni dotallena, Jusiñamuimo jɨca. Ie mei bautiza” raite. ");
INSERT INTO huuNT_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","’Ie mei Jerusalémo abɨdo cue billa mei, Jusiñamui jofomo Jusiñamuimo cue jɨɨia, nɨcaɨritɨcue isoidɨcue. ");
INSERT INTO huuNT_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Caɨ Namana cɨodɨcue. Cuemo llote: “Jerusalémona raɨre mai jai. Comɨnɨdɨ o cuena lluana feiñoñeitɨmacɨ”. ");
INSERT INTO huuNT_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Uai otɨcue: “Nama, naga judíuaɨ ofiracomo ona ɨɨnotɨnona fauidɨcue. Cárcelmo naimacɨna joneuidɨcue. Nama, Jerusalémo itɨno iena uiñotɨmacɨ. ");
INSERT INTO huuNT_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Esteban mɨcorɨ fiodailla facaiseconi nainomo itɨcue. Naimɨe o facaina lloraɨma. Naimɨe fiodailla jira, iobidɨcue. Naimɨena meinetɨno ɨniroina sedadɨcue”; ");
INSERT INTO huuNT_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","iadedɨ cue Nama cuemo llote: “Mai jai. Judíuaɨñedɨnomo ona are oretaiacadɨcue”. ");
INSERT INTO huuNT_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Bie lloga dɨnori comɨnɨ Pablo lluana cacadɨmacɨ. Iemei cuiriidɨmacɨ: —Bie isoide ɨima illana benomo jitaiñedɨcaɨ. ¡Naimɨena meine! ");
INSERT INTO huuNT_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Cuiriillamona naimacɨ ɨniroina jaidɨsɨte. Icɨrisɨano enɨruena jɨaɨ fadosɨte. ");
INSERT INTO huuNT_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Judíuaɨ uaido comɨnɨmo Pablo llua jira, comandante iena cacaiñede; iadedɨ comɨnɨ icɨrillana cɨuanona, naimɨe llote: —Naimɨena cuartelmo uiño. Naimɨena fano. Naimɨemo ite rafuena caɨmo naimɨe llollena, naimɨena duere fɨno. ");
INSERT INTO huuNT_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Naimɨena maɨano naimɨena 