﻿USE sofia;
DROP TABLE IF EXISTS sofia.husNT2005_vpl;
CREATE TABLE husNT2005_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES husNT2005_vpl WRITE;
INSERT INTO husNT2005_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jechéꞌ jaꞌich nin bij nin wejeꞌ pakéliltsik na Jesukristo, xu kidhtaláb kʼal na Dabid ani na Abraham. ");
INSERT INTO husNT2005_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Na Abraham in kóꞌoy in chakámil xin bij ta Isák. Na Isák in kóꞌoy in chakámil xin bij ta Jakob. Na Jakob in kóꞌoy in chakámiltsik ani jún ti éb in bij ta Judá. ");
INSERT INTO husNT2005_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Nin tátaꞌ na Fares ani na Sara jaꞌich na Judá ani nin nánaꞌ jaꞌich na Tamar. Na Fares in kóꞌoy in chakámil xin bij ta Esrom ani na Esrom in kóꞌoy in chakámil xin bij ta Aram. ");
INSERT INTO husNT2005_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Na Aram in kóꞌoy in chakámil xin bij ta Aminadab, na Aminadab in kóꞌoy in chakámil xin bij ta Násón ani na Násón in kóꞌoy in chakámil xin bij ta Salmón. ");
INSERT INTO husNT2005_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Nin tátaꞌ na Bós jaꞌich na Salmón ani nin nánaꞌ jaꞌich na Ráb. Nin tátaꞌ na Obed jaꞌich na Bós ani nin nánaꞌ jaꞌich na Rut. Na Obed in kóꞌoy in chakámil xin bij ta Isaí. ");
INSERT INTO husNT2005_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Na Isaí in kóꞌoy in chakámil xin bij ta Dabid ani jechéꞌ na Dabid jaꞌich na kʼwajay ti pulek takʼix. An pulek takʼix Dabid kʼal nin tomtalwiꞌik na Urías in kóꞌoytsik in chakámil xin bij ta Salomón. ");
INSERT INTO husNT2005_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Na Salomón in kóꞌoy in chakámil xin bij ta Roboam, na Roboam in kóꞌoy in chakámil xin bij ta Abías ani na Abías in kóꞌoy in chakámil xin bij ta Asa. ");
INSERT INTO husNT2005_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Na Asa in kóꞌoy in chakámil xin bij ta Josafat, na Josafat in kóꞌoy in chakámil xin bij ta Joram ani na Joram in kóꞌoy in chakámil xin bij ta Usías. ");
INSERT INTO husNT2005_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Na Usías in kóꞌoy in chakámil xin bij ta Jotam, na Jotam in kóꞌoy in chakámil xin bij ta Akas ani na Akas in kóꞌoy in chakámil xin bij ta Esekías. ");
INSERT INTO husNT2005_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Na Esekías in kóꞌoy in chakámil xin bij ta Manasés, na Manasés in kóꞌoy in chakámil xin bij ta Amón ani na Amón in kóꞌoy in chakámil xin bij ta Josías. ");
INSERT INTO husNT2005_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Na Josías in kóꞌoy in chakámiltsik ani jún ti éb jaꞌich na Jekonías. Jechéꞌ támun tam ti an israelitatsik júná ti wikʼnél ban chabál xi Babilonia. ");
INSERT INTO husNT2005_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Más tayíl, tam ti támnékich jechéꞌ, na Jekonías in kóꞌoy in chakámil xin bij ta Salatiel ani na Salatiel in kóꞌoy in chakámil xin bij ta Sorobabel. ");
INSERT INTO husNT2005_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Na Sorobabel in kóꞌoy in chakámil xin bij ta Abiud, na Abiud in kóꞌoy in chakámil xin bij ta Eliakim ani na Eliakim in kóꞌoy in chakámil xin bij ta Asor. ");
INSERT INTO husNT2005_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Na Asor in kóꞌoy in chakámil xin bij ta Sadok, na Sadok in kóꞌoy in chakámil xin bij ta Akim ani na Akim in kóꞌoy in chakámil xin bij ta Eliud. ");
INSERT INTO husNT2005_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Na Eliud in kóꞌoy in chakámil xin bij ta Eleasar, na Eleasar in kóꞌoy in chakámil xin bij ta Matán ani na Matán in kóꞌoy in chakámil xin bij ta Jakob. ");
INSERT INTO husNT2005_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Na Jakob in kóꞌoy in chakámil xin bij ta José. Jechéꞌ na José, jaꞌich nin tomkíl na María ani ba jechéꞌ na María, tajaꞌ ti waꞌchin na Jesús xu bijyáb ti Kristo. ");
INSERT INTO husNT2005_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Waꞌchin lajuchéꞌ i kidhtalábtsik, tujey ba na Abraham asta ba na Dabid. Lajuchéꞌ jeye i kidhtalábtsik waꞌchin xi tujey ba na Dabid asta tam ti an israelitatsik júná Babilonia ti wikʼnél. Ani lajuchéꞌ jeye i kidhtalábtsik waꞌchin xi tujey tam ti an israelitatsik júná Babilonia ti wikʼnél asta ti waꞌchin ti chakam na Kristo. ");
INSERT INTO husNT2005_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Enchéꞌ ti waꞌchin ti chakam na Jesukristo: Na María, nin nánaꞌ, kʼwajat konodh abal ka tomkin kʼal na José ani tam ti yabél kʼwajattsik junax, jilkʼon kóꞌodh na María kʼal tin cháp an Tʼokat Ejattaláb. ");
INSERT INTO husNT2005_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Na José, nin tomkíl na María, jaꞌich jun i lujat inik, por yab in leꞌnaꞌ kin xalkʼaꞌ max anchanꞌ ti kʼwajat na María, tokot in leꞌnaꞌ kin jilaꞌ chinatkʼi. ");
INSERT INTO husNT2005_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Lejat kʼwajat in chalpayal jechéꞌ, in chuꞌu ba watsib jun in tʼokat abatwálejil an Okʼóxláb ani utsan kʼál enchéꞌ: ―José, xi kidhtaláb kʼal na Dabid, ka bachʼu na María ta tomtal ani yab ki kʼwajay ta chalpax, pos an chakam xi neꞌech kin waꞌchiy, kʼal an Tʼokat Ejattaláb tu dhabaláb. ");
INSERT INTO husNT2005_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Na María neꞌech kin waꞌchiy jun i chakam ani neꞌech ka bijiy ta Jesús. Anchanꞌ ti neꞌech ka bijyat abal neꞌech kin loꞌo an atiklábtsik kʼal an walastaláb xin koꞌoltsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ejtal jechéꞌ támun abal ka tʼájan xan tin ulúmal an Okʼóxláb enchéꞌ kʼal nin tʼiltsíxil: ");
INSERT INTO husNT2005_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","An tsidhan neꞌech ka jilkʼon kóꞌodh ani neꞌech kin waꞌchiy jun i chakam. Jechéꞌ an chakam neꞌech ka bijyat Emanuel. An bijláb Emanuel in léꞌ kin ulu: Na Dios kʼwajat kʼal wawáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Tam ti na José ejech, anchanꞌ tin tʼajaꞌ xan ti utsan kʼal nin tʼokat abatwálejil an Okʼóxláb ani yab in jilaꞌ na María. ");
INSERT INTO husNT2005_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Por yab junkun kʼal na María asta tam ti na María in kóꞌoy an chakam ani in kʼwajbantsi tin bij Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Na Jesús waꞌchin ban bitsow xin bij Belén xu takʼnal ban chabál xi Judea, tam ti na Erodes kʼwajat ti pulek takʼix ba jachanꞌ an chabál. Tam ti jachanꞌ i kʼij, ulich ban bitsow Jerusalén cháb óx i chalpadh iniktsik xi tál in lujtal xon tu kalel na kʼítsá ");
INSERT INTO husNT2005_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","ani konoxintsik enchéꞌ: ―¿Jónꞌ ti kʼwajat nin pulek takʼíxal an judíotsik xi waꞌchin ti chakam? Pos i chuꞌúmal nin ótil in lujtal xon tu kalel na kʼítsá ani u tsiꞌnek techéꞌ abal ki kʼakʼnaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Tam tin choꞌóbnaꞌ jechéꞌ an pulek takʼix Erodes, jilkʼon tʼajat ti chalpax ani ejtal jeye an atiklábtsik xi Jerusalén. ");
INSERT INTO husNT2005_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Kanyattsik tám kʼal an pulek takʼix ejtal an okʼlek páleꞌtsik ani an okʼtsixtsik xin wilál nin takʼixtal na Dios xin jilám dhutsadh na Moisés ani in konoytsik jónꞌ ti neꞌech ka waꞌchin ti chakam an Kristo. ");
INSERT INTO husNT2005_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Jajáꞌtsik tókʼon enchéꞌ: ―Ban bitsow xin bij Belén xu takʼnal ban chabál xi Judea; pos an tʼiltsix enchéꞌ tin jilámal dhutsadh: ");
INSERT INTO husNT2005_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Maske Belén jaꞌich jun i chakam bitsow xi kʼwajat ban chabál xi Judea, púlek ti kʼwajat, kom tajaꞌ ti neꞌech ka waꞌchin jun i okʼlek, xi neꞌech kin beletnaꞌ an atiklábtsik xi Israel. ");
INSERT INTO husNT2005_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Na Erodes in kaniy tám chinatkʼi an chalpadh iniktsik ani in konoy xowkʼi jun bél ti xalkʼanék na ót. ");
INSERT INTO husNT2005_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","In abaꞌtsik tám Belén ani in utsaꞌtsik enchéꞌ: ―Ki kʼaletsik tajaꞌ ani ka alꞌimay i tsubaxtaláb kʼal tin kwenta jachanꞌ an chakam. Tam ka elaꞌtsik an chakam, ti kin óltsi abal kin kʼale neye ku kʼakʼnaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Tam ti okʼon ti usnaltsik jechéꞌ kʼal an pulek takʼix, kʼaléchtsik tám. Na ót xin chuꞌúmaltsik in lujtal xon tu kalel na kʼítsá, taꞌ ti neꞌech okʼox ani tam tin bajaw xon ti kʼwajat an chakam, kubey. ");
INSERT INTO husNT2005_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Tam ti an chalpadh iniktsik in chuꞌu kubey na ót, kulbétsik tʼajat. ");
INSERT INTO husNT2005_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Tam ti ochichtsik ban atá, in chuꞌu an chakam junax kʼal na María. Jechéꞌ na María jaꞌich nin nánaꞌ an chakam. An chalpadh iniktsik tudhlan tám ani in kʼakʼnaꞌ an chakam. In japiy tám an balixtaláb xin tsiꞌdháltsik ani in chʼejwaliy ti oro, ti ikob ani ti mirra. ");
INSERT INTO husNT2005_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Por óltsintsik kʼal jun i watsib ke yab yejat ka witsiytsik xon ti kʼwajat na Erodes, jaxtám ti witsiytsik bin chabálil, píl bél. ");
INSERT INTO husNT2005_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Tayíl, tam ti kʼalnekich an chalpadh iniktsik, na José in chuꞌu ba jun i watsib jun in tʼokat abatwálejil an Okʼóxláb ani utsan kʼál enchéꞌ: ―Ki chʼakay ani ki ájlách abal Ejipto. Ka júnaꞌ an chakam junax kʼal nin nánaꞌ ani ki kʼwajay tajaꞌ asta tam nanáꞌ tu utsaꞌ ki witsiy. Pos na Erodes neꞌech kin aliy an chakam abal kin chemdhaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Tam ti na José ejech, jachanꞌ an akal ájlách abal Ejipto. In júnaꞌ an chakam junax kʼal nin nánaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Tajaꞌ ti kʼwajaytsik asta ti chemech na Erodes. Jechéꞌ támun abal ka tʼájan xan tin ulúmal enchéꞌ an Okʼóxláb kʼal nin tʼiltsíxil: “U utsaꞌ ka kʼale Ejipto nu Chakámil.” ");
INSERT INTO husNT2005_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Tam ti na Erodes in chuꞌu abal kʼambiyat kʼal an chalpadh iniktsik, chakuy tʼajat ani in abnaꞌ ka chemdhá ejtal an tsʼitsik kwitól xi ít ti waꞌchinék asta xin koꞌolich chabtsik i tamub. In abnaꞌ ka chemdhá an tsʼitsik kwitól xu kʼwajíl Belén ani xu kʼwajíltsik tajaꞌ kʼunat. Jechéꞌ in tʼajaꞌ anchanꞌ kom in koꞌolich kʼunat cháb i tamub ti watʼenek an chalpadh iniktsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Anchanꞌ ti támun jelt xan tin jilámal dhutsadh enchéꞌ an tʼiltsix Jeremías: ");
INSERT INTO husNT2005_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Achʼatmé ban bitsow Ramá i mímlábtsik ti ukʼnal ani ti tʼeꞌpinal; jaꞌich nin at kidhtaltsik na Rakel xi kʼwajat in ukʼintsal nin chakámiltsik ani yab in leꞌnaꞌtsik ka kʼijidhmédhá, kom chemdhantsidh tin chakámiltsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Por tam ti chemnekich na Erodes, tajaꞌ Ejipto, na José in chuꞌu ba jun i watsib jun in tʼokat abatwálejil an Okʼóxláb ani utsan kʼál enchéꞌ: ");
INSERT INTO husNT2005_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","―Ki chʼakay ani ki kʼale ban chabál xi Israel. Ka júnaꞌ an chakam junax kʼal nin nánaꞌ abal chemnekichtsik xin léꞌwiꞌik kin chemdhaꞌ an chakam. ");
INSERT INTO husNT2005_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Chʼakay tám na José ani in júnaꞌ an chakam kʼál nin nánaꞌ ban chabál xi Israel. ");
INSERT INTO husNT2005_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Por tam ti na José in achʼaꞌ abal na Arkelao jaꞌich na kʼwajat ti takʼix Judea in kuxyal nin tátaꞌ Erodes, jikʼey ani yab in leꞌnaꞌ ka kʼale tajaꞌ. Ani kom óltsinékich kʼal jun i watsib xon ti yejat ka kʼale, kʼale ban chabál xi Galilea. ");
INSERT INTO husNT2005_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Tam ti ulich tajaꞌ, kʼale ti kʼwajíl ban bitsow xin bij Nasaret. Jechéꞌ támun anchanꞌ abal ka tʼájan xan tin ulúmal an tʼiltsixtsik, ke na Jesús neꞌech ka bijyat ti nasareno. ");
INSERT INTO husNT2005_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Tam ti jachanꞌ i kʼij na Juan xu pujax ulich Judea ban chabál xon ti yab kʼwajtsidh. Tujey ti tʼiltsix ");
INSERT INTO husNT2005_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","ani in ulal enchéꞌ: ―Ka jilaꞌichtsik ta walablom, pos exomich ti kʼunel xowkʼi neꞌchich ti takʼix na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jechéꞌ na Juan jaꞌich an inik xin tʼilámal an tʼiltsix Isaías tam tin ulu enchéꞌ: Achʼat in káwintal jun xitaꞌ ban chabál xon ti yab kʼwajtsidh ani xu káw, in ulal kawidh enchéꞌ: “¡Ka tʼojojontsíchtsik tin bélil an Ajátikláb; ka júnaꞌichtsik jun i xeꞌchintaláb alwaꞌ; abal anchanꞌ, ki kʼwajáchtsik tʼojojodh tam ka tsích an Ajátikláb!” ");
INSERT INTO husNT2005_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Na Juan u xeketlinal kʼal i xeketláb xi tʼajadh kʼal nin xiꞌíl an koꞌnél xu bijyáb kameyo ani in wikʼál nin tsukul kʼal i ótʼ. Nin kʼapwál, jaꞌich an pichʼichʼ ani an alteꞌ chiꞌik. ");
INSERT INTO husNT2005_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Yán i atiklábtsik xi Jerusalén, ejtaltsik xu kʼwajíltsik ban chabál xi Judea ani ejtal xu kʼwajíltsik kʼunat ban waljaꞌ Jordán, u uleltsik abal kin achʼaꞌ xowaꞌ in ulal na Juan. ");
INSERT INTO husNT2005_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Tam kin ólnaꞌichtsik nin walab, u pujyábtsik kʼal na Juan ban waljaꞌ Jordán. ");
INSERT INTO husNT2005_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Por tam ti na Juan in chuꞌu ke yán i fariseotsik ani i saduseotsik u ulel abal ka pujyat, utsantsik enchéꞌ kʼal na Juan: ―¡Tatáꞌtsik a junwal jelti an chan! ¿Jitaꞌ ti okʼtsámaltsik ka chinkʼontsi an kʼakʼadh yajtsiktaláb xi exomich ti kʼunel? ");
INSERT INTO husNT2005_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ki kʼwajáchtsik alwaꞌ abal ka xalkʼan ke tsubax lejtal ta jilaꞌichtsik ta walablom. ");
INSERT INTO husNT2005_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Yab ka chalpaytsik ke i alwaꞌ inik tin tamét na Dios abalkʼi i kidhtalábtsik kʼal na Abraham; pos tu utsáltsik ke asta ba jechéꞌ an tʼujubtsik na Dios neꞌech kin ejto kin waꞌchindhaꞌ in kidhtaltsik a Abraham. ");
INSERT INTO husNT2005_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Anchanꞌ jelt xan ti jun i inik in kwajlál jun i teꞌ xi yab xataꞌ ti alwaꞌ ani in tsikál, anchanꞌ jeye ti neꞌech kin tʼajaꞌ na Dios kʼunat i kʼij kʼal an atiklábtsik xi Jajáꞌ kin chuꞌu ke yab alwaꞌ inik. ");
INSERT INTO husNT2005_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Nanáꞌ tu pujyaltsik kʼal i jaꞌ jelti jun i exól abal a jilaꞌichtsik ta walablom; por xi taꞌ tál tayíl, neꞌech ti ki pujaytsik kʼal an Tʼokat Ejattaláb ani kʼal i kʼamal. Jajáꞌ más in koꞌol i awiltaláb ke nanáꞌ, nanáꞌ nibal elaꞌ in tomnál ku téntsi tin pajab. ");
INSERT INTO husNT2005_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Anchanꞌ xan ti jun i inik in jutsyal an trigo abal kin taꞌpaꞌ ban wilteꞌ ani in tsiktsal an tin jokom, anchanꞌ jeye ti neꞌech ka tʼajtsin an atiklábtsik kʼal xi taꞌ tál tayíl. Neꞌech kin júnaꞌ walkʼiꞌ xi Jajáꞌ in dhabal ani neꞌech kin petʼnaꞌ xi yab Jajáꞌ in dhabal ban kʼamal xi yab jaykʼi u tepel. ");
INSERT INTO husNT2005_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ulich tám na Jesús ban waljaꞌ Jordán xon ti kʼwajat na Juan abal ka pujyat, na Jesús tál Galilea. ");
INSERT INTO husNT2005_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Yabwiꞌik u leꞌnáb ka pujyat na Jesús kʼal na Juan, tokot u usnal enchéꞌ: ―Nanáꞌ nin tomnál kin pujyat kʼal Tatáꞌ, ani ¿Tatáꞌ a léꞌ tu pujay nanáꞌ? ");
INSERT INTO husNT2005_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Por utsan enchéꞌ kʼal na Jesús: ―Xoꞌ ka tʼajaꞌich anchanꞌ; pos yejat ki tʼajaꞌ ejtal xowaꞌ in léꞌ na Dios. In tokʼóch tám na Juan. ");
INSERT INTO husNT2005_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Tam ti pujadhich na Jesús, kale ban jaꞌ. Támkʼi jachanꞌ, jakʼpin an walkʼiꞌ ani in chuꞌu na Jesús nin Tʼokat Ejattal na Dios ti paꞌíl jelti jun i kukuꞌ ani buxkan tin éb Jajáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Achʼatmé tám jun i káwintaláb walkʼiꞌ, xu káw in ulu enchéꞌ: ―Jechéꞌ jaꞌich nu Chakámil xu kʼanidhál tʼajat ani in kulbél tʼajat kʼal Jajáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Júná tám na Jesús kʼal an Tʼokat Ejattaláb ban chabál xon ti yab kʼwajtsidh abal ka taktamiyat kʼal an lej atʼax. ");
INSERT INTO husNT2005_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Tajaꞌ ti kʼwajay yab u kʼapul chab inik a kʼítsá ani chab inik i akal ani tayíl, kʼaꞌay. ");
INSERT INTO husNT2005_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Utey tám an lej atʼax ba na Jesús abal kin taktamiy ani in utsaꞌ enchéꞌ: ―Max tsubax lejtal i Chakámláb kʼal a Dios, ka utsaꞌ jachanꞌ an tʼujubtsik ka wenkʼon ti kʼapnél. ");
INSERT INTO husNT2005_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Tókʼoyat enchéꞌ kʼal na Jesús: ―An Tʼokat Dhuslab in ulal enchéꞌ: “Yab tokotkʼi kʼal i kʼapnél ti ejat an inik, ejat jeye kʼal ejtal xowaꞌ na Dios in ulal.” ");
INSERT INTO husNT2005_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Júná tám na Jesús kʼal an lej atʼax ban tʼokat bitsow Jerusalén, kʼadhbá bin éb an pulek atá xon tu kʼakʼnáb na Dios ");
INSERT INTO husNT2005_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ani utsan enchéꞌ: ―Max tsubax lejtal i Chakámláb kʼal a Dios, ka petʼnaꞌ tabáꞌ abal chaꞌat; pos an Tʼokat Dhuslab in ulal enchéꞌ: Na Dios neꞌech kin abaꞌ nin tʼokat abatwálejiltsik abal ti ki beletnaꞌ. Neꞌech ti ki bachʼu abal yab ka chaꞌaw na akan kʼal ni jun i tʼujub. ");
INSERT INTO husNT2005_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Tókʼoyat enchéꞌ kʼal na Jesús: ―In ulal jeye enchéꞌ an Tʼokat Dhuslab: “Yab ka taktamiy an Okʼóxláb na Diosil.” ");
INSERT INTO husNT2005_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Júná tám juní kʼal an lej atʼax ba jun i tʼekʼat chʼén, xalkʼantsat ejtal an ti pakdhaꞌ bitsow xi techéꞌ ti kʼayꞌlá xi kʼwajat takʼnél kʼal an pakdhaꞌ takʼix ani nin pubíl jachanꞌ an pakdhaꞌ bitsow ");
INSERT INTO husNT2005_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","ani utsan enchéꞌ: ―Neꞌech tu pidhaꞌ ejtal jechéꞌ, max ki tudhlan abal ti kin kʼakʼnaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Utsan tám enchéꞌ kʼal na Jesús: ―Lej atʼax, ki kʼaléch, pos an Tʼokat Dhuslab in ulal enchéꞌ: “Ka kʼakʼnaꞌ an Okʼóxláb na Diosil ani Jajáꞌkʼi ka tʼójontsal.” ");
INSERT INTO husNT2005_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Jilanich tám na Jesús kʼal an lej atʼax ani ulich i tʼokat abatwáletsik abal ka tʼójontsat kʼál na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Tam ti na Jesús in achʼaꞌ abal na Juan balidh ban wikʼaxteꞌ, witsiy ban chabál xi Galilea. ");
INSERT INTO husNT2005_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Por yab kʼwajay Nasaret, kʼale ti kʼwajíl Kapernaúm, jun i bitsow xi kʼwajat bin wál i pujal, ban chabál xon ti kʼwajinektsik na Sabulón ani na Neftalí. ");
INSERT INTO husNT2005_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Jechéꞌ támun abal ka tʼájan xan tin jilámal dhutsadh an tʼiltsix Isaías enchéꞌ: ");
INSERT INTO husNT2005_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Chabál xon ti kʼwajinektsik na Sabulón ani na Neftalí, xi kʼwajat in lujtal ban pujal, in lujtal xon tu kalel na kʼítsá kʼal an waljaꞌ Jordán, Galilea, xon tu kʼwajíl xi yabtsik u judío. ");
INSERT INTO husNT2005_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","An atiklábtsik xi kʼwajat jelti max ban jikʼwaxtaláb, in chuꞌutsik jun i pulek tajaxtaláb ani an atiklábtsik xi kʼwajat jelti max in kʼunkʼúmich tʼajat an chemlá, tajbayattsik kʼal jun i tajaxtaláb. ");
INSERT INTO husNT2005_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Asta tam ti tám ti tujey na Jesús ti tʼiltsix ani in ulal enchéꞌ: ―Ka jilaꞌichtsik ta walablom, pos exomich ti kʼunel xowkʼi neꞌchich ti takʼix na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Tam ti na Jesús neꞌech ti belal waltsik an pujal xi Galilea, in chuꞌu cháb i iniktsik xin kidhábkʼitsik; jún jaꞌich na Simón, xi bijyat jeye ta Pedro ani na jún a Andrés. Jechéꞌ an iniktsik, kʼwajat in petʼnál nin jixáb an toꞌol ban pujal, kom jajáꞌtsik u jixom toꞌol. ");
INSERT INTO husNT2005_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Utsantsik tám enchéꞌ kʼal na Jesús: ―Ti kin wéwnaꞌtsik ani neꞌech tu okʼtsitsik xan ti neꞌech ka aliy an atiklábtsik xi neꞌech ti kin belaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Támkʼi jachanꞌ tin jilaꞌtsik nin jixáb an toꞌol ani kʼaletsik kʼal na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Más asta tuwaꞌ wéꞌ aniꞌ, na Jesús in chuꞌu juní cháb i iniktsik xi aníl jeye in kidhábkʼitsik. Jechéꞌtsik jaꞌich na Jakobo ani na Juan, xu chakámlábtsik kʼal na Sebedeo xi kʼwajattsik ba jun i tan kʼal nin tátaꞌ ti lejkix tin jixáb an toꞌol. Kanyattsik kʼal na Jesús ");
INSERT INTO husNT2005_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ani támkʼi jachanꞌ tin jilaꞌtsik an tan. In jilaꞌtsik jeye nin tátaꞌ ani in wéwnaꞌtsik na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Na Jesús xeꞌech in lonyal putál an chabál xi Galilea ani u kubél ti okʼtsix ban bitsowtsik ban atá xon tu tʼajnal an junkuntaláb. In tʼilál an alwaꞌ tʼilab kʼal tin kwenta xan tu takʼix na Dios ani in jeldhál an atiklábtsik kʼal xowaꞌkichkʼi i yawꞌlách. ");
INSERT INTO husNT2005_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Choꞌóbná xantʼéy in tʼajál na Jesús kʼal ejtal an atiklábtsik xu kʼwajíl ban chabál xi Siria ani tsiꞌdhantsat ejtal xi kʼwajattsik kʼal i yajtsiktaláb, xu yaꞌultsik, xin koꞌoltsik i chʼukʼuxtaláb, xi kʼwajattsik ochadh kʼal i atʼax ejattalábtsik, xu wipipíltsik ani xi yabtsik in ejtowal ka yoyon. Ani jeldhátsik kʼal na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Kʼal yán i atiklábtsik ti wéwná na Jesús, wéwná kʼal xu kʼwajíltsik Galilea, kʼal xu kʼwajíltsik ban bitsowtsik xi Dekápolis, xi Jerusalén, kʼal xu kʼwajíltsik ban chabál xi Judea ani kʼal xu kʼwajíltsik jeye in lujtal xon tu kalel na kʼítsá kʼal an waljaꞌ Jordán. ");
INSERT INTO husNT2005_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Tam ti na Jesús in chuꞌu ejtal an atiklábtsik, kʼadhiy ba chʼén ani buxkan. Junkun tám nin exóbaliltsik malilíl xon ti Jajáꞌ kʼwajat ");
INSERT INTO husNT2005_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ani tujey ti okʼtsinaltsik enchéꞌ kʼal na Jesús: ");
INSERT INTO husNT2005_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","―Kʼijidh abal xin chalpayaltsik ke in yéntsal na Dios, pos neꞌech ka kʼwajaytsik takʼnél kʼal na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","ʼKʼijidh abal xu ukʼnaltsik, pos neꞌech ka kʼijidhmédhátsik kʼal na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","ʼKʼijidh abal xin chaꞌkáltsik tinbáꞌ, pos neꞌech kin bachʼutsik an chabál xi usnéktsik neꞌech ka pidhan kʼal na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","ʼKʼijidh abal xitaꞌ xin leꞌnáltsik kin tʼajaꞌ xowaꞌ lujat, pos neꞌech ka tolmiyattsik kʼal na Dios abal kin tʼajaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","ʼKʼijidh abal xitaꞌ xin yajnantsaltsik nin at kidhtal, pos neꞌech jeye ka yajnantsattsik kʼal na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","ʼKʼijidh abal xitaꞌ xin koꞌoltsik tʼokat nin ejattal, pos neꞌechtsik kin chuꞌu na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","ʼKʼijidh abal xitaꞌ xin ayaltsik an kʼijidhtaláb, pos neꞌech ka bijyattsik ti chakámláb kʼal na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","ʼKʼijidh abal xitaꞌ xu atʼnaltsik kʼal tin kwenta abal in tʼajáltsik xowaꞌ lujat, pos neꞌech ka kʼwajaytsik takʼnél kʼal na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","ʼKʼijidh abal tatáꞌtsik, tam ki odhbijyattsik, ki atʼantsik ani ki utsantsik xowaꞌkich xi yab alwaꞌ maske yab tsubax kʼal Nanáꞌkʼi tu kwenta. ");
INSERT INTO husNT2005_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ki kulbé ani ki kʼijidhmétsik abal neꞌech ka bachʼutsik jun i chʼejwalixtaláb púlek túꞌ walkʼiꞌ, pos anchanꞌ jeye ti tʼajtsinék an tʼiltsixtsik xi kʼwajinek más okʼox ke tatáꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","ʼTatáꞌtsik ni kʼwajat jelti an atʼem abal an atiklábtsik. Max an atʼem ka xawꞌmé, ¿jantʼó ti neꞌech ka éyná? Yabich xataꞌ ti alwaꞌ, tokot abal ka wakʼlá ani ka kʼáchʼíkʼná kʼal an atiklábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","ʼTatáꞌtsik ni kʼwajat jelti an tajaxtaláb abal an atiklábtsik. Jun i bitsow xi kʼwajat ba chʼén, yab neꞌech kin ejto ka chinkʼon. ");
INSERT INTO husNT2005_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Yab u letʼkʼoyáb jun i tajbaxtaláb abal ka paxkʼiyat kʼal jun i kajón, u letʼkʼoyáb abal ka kʼwajbá tʼekʼat abal kin tajbay ejtal xi kʼwajattsik ban atá. ");
INSERT INTO husNT2005_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Anchanꞌ xan tu tajbax an tajbaxtaláb, anchanꞌ teye ti ka xalkʼaꞌ xowaꞌ alwaꞌ a tʼajál abal kin chuꞌu an atiklábtsik ani anchanꞌ kin pubédhantsi tin bij na Tátaꞌ Dios xi kʼwajat walkʼiꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","ʼYab ka chalpaytsik ke Nanáꞌ in tsiꞌnek ku wékʼoy nin takʼixtal na Dios xin jilám dhutsadh na Moisés o xowaꞌ in jilámal dhutsadh an tʼiltsixtsik; yab in tsiꞌnek abal ku wékʼoy, in tsiꞌnek abal ku tʼajaꞌ xan tin ulal. ");
INSERT INTO husNT2005_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Pos tsubax tu utsáltsik, ke lejat kʼwajat an chabál ani an walkʼiꞌ, yab neꞌech ka wékʼontsat ni jun xataꞌ jechéꞌ an takʼixtaláb. Koꞌol ka tʼájan okʼox ejtal xowaꞌ kʼwajat dhutsadh. ");
INSERT INTO husNT2005_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Jaxtám, xitaꞌ kin chʼikat tʼajaꞌ xowaꞌ kʼwajat dhutsadh ba jechéꞌ an takʼixtaláb, maske jaꞌich jun xataꞌ xi más chipíl ani anchanꞌ kin okʼtsi an atiklábtsik, chaꞌat tʼajat in éy neꞌech ka kʼwajay xon tu takʼix na Dios. Por xitaꞌ kin tʼajaꞌ xowaꞌ in ulal jechéꞌ an takʼixtaláb ani jaꞌich kin okʼtsixnaꞌ, ultaláb neꞌech ka kʼwajay xon tu takʼix na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Pos tu utsáltsik, ke max yab ka tʼajaꞌ más an chápláb abal ka tʼajaꞌ xowaꞌ in léꞌ na Dios ké an okʼtsixtsik xin wilál nin takʼixtal na Dios xin jilám dhutsadh na Moisés ani an fariseotsik, yab neꞌech ka ejto ki kʼwajaytsik takʼnél kʼal na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","ʼA achʼámaltsik ke an wejeꞌ pakéltsik usnék enchéꞌ: “Yab ki chemdhaxin, pos xitaꞌ ka chemdhaxin yejat ka lújundhá kʼal an awiltaláb.” ");
INSERT INTO husNT2005_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Pos Nanáꞌ tu utsáltsik ke xitaꞌ kin chakuntsi nin at kidháb, yejat ka lújundhá kʼal an awiltalábtsik. Xitaꞌ kin odhbijiy nin at kidháb, yejat ka lújundhá kʼal an Junkulom Awiltaláb ani xitaꞌ kin bijiy nin at kidháb ti atʼax inik, in tomnálich ka kʼale ban kʼibeltaláb. ");
INSERT INTO husNT2005_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","ʼJaxtám, max neꞌchich ka kʼwajbantsi ti pikbantsixtaláb na Dios ani tajaꞌ ka chalpay ke yab i kʼwajat alwaꞌ kʼal na at kidháb, ");
INSERT INTO husNT2005_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ka jilaꞌ an pikbantsixtaláb tin tamét xon tu kʼwajbáb an pikbaxtaláb ani ki kʼale okʼox ta lejkinal kʼal na at kidháb. Tam i lejkinékich, ki witsích tám ani ka kʼwajbaꞌich an pikbantsixtaláb. ");
INSERT INTO husNT2005_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","ʼMax jun xitaꞌ ti ki utsbiy ani ti ki júnaꞌ ban awiltaláb, ki lejkintsik ti bél kʼal jajáꞌ abal yab ti ki júnaꞌ ban lújundhom; pos max ti ki júnaꞌ ban lújundhom, an lújundhom neꞌech ti ki pidhnaꞌ ban belkol wikʼaxteꞌ ani an belkol wikʼaxteꞌ neꞌech ti ki baliy ban wikʼaxteꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Tsubax tu utsál, ke yab neꞌech ki kale tajaꞌ asta ka jalbiy ejtal xowaꞌ a júnál. ");
INSERT INTO husNT2005_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","ʼAn wejeꞌ pakéltsik usnék jeye enchéꞌ: “Yab ki junkun kʼal xi yab a tomtal.” ");
INSERT INTO husNT2005_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Por Nanáꞌ tu utsáltsik ke xitaꞌ kin létʼendhaꞌ jun i mímláb, walbinich kʼal i uxúmbeꞌtaláb tin ejattal abal in létʼendhál jachanꞌ an mímláb. ");
INSERT INTO husNT2005_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","ʼMax na eját wal ti walbindhál, ka jixaꞌ ani ka petʼnaꞌ; pos más alwaꞌ ka kʼibdhaꞌ jun pejeꞌ a tʼuꞌúl ké ki petʼná kʼal ejtal na tʼuꞌúl ban kʼibeltaláb. ");
INSERT INTO husNT2005_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ani max na eját kʼubak ti walbindhál, ka muchʼiy ani ka petʼnaꞌ; pos más alwaꞌ ka kʼibdhaꞌ jun pejeꞌ na tʼuꞌúl ké ki petʼná kʼal ejtal na tʼuꞌúl ban kʼibeltaláb. ");
INSERT INTO husNT2005_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","ʼUsnéktsik jeye an wejeꞌ pakéltsik enchéꞌ: “Xitaꞌ ka jíláxin kʼal nin tomtal, yejat kin pidhaꞌ nin tomtal jun i úw xon tin ulal xantʼókʼi tin kwenta ti neꞌech ka jíláxin.” ");
INSERT INTO husNT2005_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Por Nanáꞌ tu utsáltsik ke max jun i inik kin jilaꞌ nin tomtal ani yab abal u junkunal kʼal kʼeꞌet, in tʼajálich tám ka wenkʼon ti junkux inik uxum; ani xu tomkinal kʼal jun i jiladh mímláb, u walbinalich jeye kʼal i uxúmbeꞌtaláb. ");
INSERT INTO husNT2005_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","ʼA achʼámaltsik jeye usnék enchéꞌ an wejeꞌ pakéltsik: “Koꞌol ka tʼajaꞌ xowaꞌ a lej tsubkʼantsámal an Okʼóxláb.” ");
INSERT INTO husNT2005_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Por Nanáꞌ tu utsáltsik ke yab yejat ka éynaꞌ ni jun xataꞌ abal ka lej tsubkʼaꞌ xataꞌ. Yab ka éynaꞌ an walkʼiꞌ abal ka lej tsubkʼaꞌ jun xataꞌ, kom jaꞌich jelti nin tʼokat kʼwajtal na Dios; ");
INSERT INTO husNT2005_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","nibal kʼal an chabál, kom jelti max tajaꞌ in kubál nin akan na Dios. Nibal ka lej tsubkʼaꞌ xataꞌ kʼal an bitsow Jerusalén, kom jaꞌich nin bitsówil an yejcheꞌ Pulek takʼix. ");
INSERT INTO husNT2005_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Yab jeye ka lej tsubkʼaꞌ xataꞌ kʼal tatáꞌ tabáꞌ, pos yab neꞌech ka ejto ka dhakniꞌbédhaꞌ o ka tʼunuybédhaꞌ ni jun a xiꞌíl. ");
INSERT INTO husNT2005_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Tam yejat ka tokʼoy jun xataꞌ, tokot ka ulu “aniꞌ” max aniꞌ, o “yabaꞌ” max yabaꞌ. Pos max ka puntsiy jechéꞌ, an lej atʼaxich ti tʼajál ka tʼajaꞌ anchanꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","ʼA achʼámaltsik jeye usnék enchéꞌ an wejeꞌ pakéltsik: “Xan ti ki tʼajtsin anílkʼi teye ti ka tʼajtsi.” ");
INSERT INTO husNT2005_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Por Nanáꞌ tu utsáltsik: Yab ka tomnaꞌtsik an inik xi atʼax, tokot ka tʼajaꞌtsik enchéꞌ: max jun xitaꞌ ti ki pikʼiy ba jun a chʼaꞌúb, ka pidhaꞌ jeye ti ki pikʼtsi xi jun pakʼeꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Max jun xitaꞌ ti ki péjey abal in léꞌ ti ki kʼántsi ta xekét, ka pidhaꞌ jeye kin júnaꞌ na wát. ");
INSERT INTO husNT2005_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Max ki tʼajtsin ti chápláb ka júnaꞌ jun i kitáláb jun kilómetro, ka júntsi chab kilómetro. ");
INSERT INTO husNT2005_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Max jun xitaꞌ ti ki kontsi jun xataꞌ, ka pidhaꞌ ani max ki kontsin xataꞌ matidh, ka pidhnaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","ʼA achʼámaltsik jeye usnék enchéꞌ an wejeꞌ pakéltsik: “Ka kʼanidhaꞌ xi kʼeꞌettsik por ka pojkaꞌ xi ti atʼál.” ");
INSERT INTO husNT2005_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Por Nanáꞌ tu utsáltsik: Ka kʼanidhaꞌ xi ti atʼáltsik, ka lábtʼajaꞌ xi ti odhbijyaltsik, ka tʼajtsi xowaꞌ alwaꞌ xi ti atʼáltsik ani ka kontsintsi xi ti atʼáltsik ani ti atʼax tʼajtsaltsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Max ka tʼajaꞌtsik anchanꞌ, i chakámlábichtsik tám kʼal na Tátaꞌ Dios xi kʼwajat walkʼiꞌ; pos Jajáꞌ in tajbayal kʼal na kʼítsá an iniktsik xi alwaꞌ ani xi atʼax; ani in uldhantsal an ti áb xi lujattsik ani xi yab lujattsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Max tokot a kʼanidhál xi ti kʼanidháltsik, ¿Jantʼéy neꞌech ka átaꞌ max anchanꞌ a tʼajáltsik? Asta an bachʼkʼul jalbixtaláb in tʼajáltsik jeye anchanꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Max tokot a chapnédhál na at kidhábtsik, ¿jantʼéy exom a tʼajáltsik watʼats? Pos asta xi yabtsik in exlál na Dios in tʼajál anchanꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ka lujkutsik tabáꞌ, anchanꞌ xan ti na Tátaꞌ Dios xi kʼwajat walkʼiꞌ lujat Jaꞌ tʼajat. ");
INSERT INTO husNT2005_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","ʼYab tokotkʼi ka tʼajál xowaꞌ lujat tin tamét an atiklábtsik abalkʼi ki chuꞌtat. Pos max ka tʼajaꞌ anchanꞌ, na Tátaꞌ Dios xi kʼwajat walkʼiꞌ yab neꞌech ti ki pidhaꞌ ni jun i chʼejwalixtaláb. ");
INSERT INTO husNT2005_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Jaxtám, tam ka pidhnaꞌ i tolmixtaláb, yab ka tʼilaꞌ, jelt xan tin tʼajál an kʼambixtsik ban atá xon tu tʼajnal an junkuntaláb ani ban bél. Jechéꞌ tin tʼajáltsik anchanꞌ, jaꞌich abal in léꞌ ka tʼilan alwaꞌ kʼal an atiklábtsik; por tsubax tu utsáltsik, ke kʼal jachanꞌ in bachʼwalichtsik nin chʼejwalíb. ");
INSERT INTO husNT2005_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Por tam tatáꞌ ka pidhnaꞌ i tolmixtaláb, yab ka tʼiltsi nibal na jaꞌúb; chinatkʼi ti ka tʼajaꞌ ");
INSERT INTO husNT2005_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ani na Tátaꞌ Dios, xin chuꞌtal xowaꞌ a tʼajál chinatkʼi, neꞌech ti ki pidhaꞌ an ta chʼejwalíb tin tamét an atiklábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","ʼTam ki ólan, yab ka tʼajaꞌtsik jelt xan tin tʼajál an kʼambixtsik, xin kulbetnál ti ól kubat ban atá xon tu tʼajnal an junkuntaláb ani ban bél abal ka chuꞌtat kʼal an atiklábtsik. Tsubax tu utsáltsik, ke kʼal jechéꞌ, in bachʼwalich nin chʼejwalíb. ");
INSERT INTO husNT2005_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Por tam tatáꞌ ki ólan, ki ochkan ba na altájil, ka mapuy an wiꞌleb ani ka ólantsi na Tátaꞌ Dios xi kʼwajat yab tejwaꞌ. Max anchanꞌ ka tʼajaꞌ, na Tátaꞌ xin chuꞌtal xowaꞌ a tʼajál chinatkʼi, neꞌech ti ki pidhaꞌ an ta chʼejwalíb. ");
INSERT INTO husNT2005_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","ʼTam ki ólan, yab ka wítsʼkʼókʼliy jayéchkʼi jayéchkʼi xowaꞌ a ulal, jelt xan tin tʼajál xi yabtsik in exlál na Dios abal in chalpayaltsik ke anchanꞌ neꞌech ka axtsin kʼal na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Yabtsik ka tʼajaꞌ xan ti jajáꞌtsik in tʼajál, pos na Tátaꞌ Dios in choꞌóbich xantʼéy a yéntsaltsik, maske yabél a kontsámal. ");
INSERT INTO husNT2005_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Jaxtám, enchéꞌ ki ólantsik: Tátaꞌ, xi kʼwajat walkʼiꞌ, Tatáꞌ i tʼokat tʼajat. ");
INSERT INTO husNT2005_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ti ku takʼích weye. Ka tʼájan techéꞌ ban chabál xowaꞌ Tatáꞌ a léꞌ, jelt xan tu tʼájnal túꞌ walkʼiꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ti ku pidhaꞌ xoꞌ an ti kʼapnél xi yéntsal tsudhey ka tsudhey. ");
INSERT INTO husNT2005_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ti ku pakwlantsi an ti walab, jelt xan ti wawáꞌ i pakwlantsal xitaꞌ tu waltsal. ");
INSERT INTO husNT2005_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Yab ka walkaꞌ ku taktamiyat, tokot ti ku beletnaꞌ abal yab ku átá kʼal an lej atʼax. Pos Tatáꞌ ni takʼix, Tatáꞌ na koꞌol an chápláb ani Tatáꞌ ka kóꞌoy an labidh tʼokattaláb malilíl i kʼij. Anchanꞌ ka tʼájan. ");
INSERT INTO husNT2005_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","ʼJaxtám, max tatáꞌtsik ka pakwlantsi xi ti waltsámal, na Tátaꞌ Dios xi kʼwajat walkʼiꞌ neꞌech jeye ti ki pakwlantsi an ta walastalábiltsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Por max yab ka pakwlantsitsik xi ti waltsámal, na Tátaꞌ Dios yab jeye neꞌech ti ki pakwlantsi an ta walastalábiltsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","ʼTam ki kʼílin, yab ka tʼajaꞌtsik jelt xan tin tʼajál an kʼambixtsik. Jajáꞌtsik in kʼwajbál tʼeꞌpidh nin wal abal ka chuꞌtat kʼal an atiklábtsik ke exom ti kʼíl. Tsubax tu utsáltsik ke kʼal jechéꞌ in bachʼwalichtsik nin chʼejwalíb. ");
INSERT INTO husNT2005_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Por tatáꞌ, tam ki kʼílin, ka midhiy na wal ani ki tsʼitsbaxin, ");
INSERT INTO husNT2005_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","abal yab ki chuꞌtat kʼal an atiklábtsik ke exom ta kʼíl. Tokot ki chuꞌtat kʼal na Tátaꞌ Dios xi kʼwajat yab tejwaꞌ ani Jajáꞌ, xin chuꞌtal xowaꞌ a tʼajál chinatkʼi, neꞌech ti ki pidhaꞌ an ta chʼejwalíb tin tamét an atiklábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","ʼYab ka junku xataꞌ xi kajbidh in jalbíl techéꞌ ti chabál. Pos xowaꞌ ka junku techéꞌ ti chabál u takúlinal, u kʼachel ani u kwéꞌyáb. ");
INSERT INTO husNT2005_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Más alwaꞌ ka junku túꞌ walkʼiꞌ xowaꞌ kajbidh in jalbíl. Tajaꞌ yab u takúlinal, yab u kʼachel, nibal u kwéꞌyáb. ");
INSERT INTO husNT2005_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Pos xon ti ka kóꞌoytsik xowaꞌ xi kajbidh in jalbíl, tajaꞌ jeye neꞌech ka kʼwajay na ejattal. ");
INSERT INTO husNT2005_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","ʼNa wal in junwal jelti nin tajbaxtal na tʼuꞌúl. Jaxtám, max na wal alwaꞌ, putál na tʼuꞌúl neꞌech ka kʼwajay jelti max ban tajaxtaláb. ");
INSERT INTO husNT2005_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Por max na wal yab alwaꞌ, ejtal na tʼuꞌúl neꞌech ka kʼwajay jelti max ban jikʼwaxtaláb. Ani max an tajaxtaláb xa koꞌol ka wenkʼon ti jikʼwaxtaláb, ¡tʼunuy tʼajat neꞌech ka xalkʼan jachanꞌ an jikʼwaxtaláb! ");
INSERT INTO husNT2005_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","ʼYab xitaꞌ neꞌech kin ejto kin tʼójontsi cháb in ajátik, pos neꞌech kin kʼanidhaꞌ xi jún ani neꞌech kin pojkaꞌ xi jún, o neꞌech kin tʼójontsi alwaꞌ xi jún ani xi jún yabaꞌ. Yab neꞌech ka ejto ka tʼójontsi na Dios ani an tumínladhtaláb. ");
INSERT INTO husNT2005_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","ʼTu utsáltsik: Yab ki kʼwajay ta chalpax kʼal tin kwenta xantʼéy neꞌech ka kʼapu o xantʼéy neꞌech ka uchʼaꞌ, nibal ki kʼwajay ta chalpax kʼal tin kwenta na kʼudhkʼúmil. ¿Awxeꞌ yab más in jalbíl na ejattal ke an kʼapnél ani na tʼuꞌúl, más ke na kʼudhkʼúmil? ");
INSERT INTO husNT2005_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ka telaꞌ an chʼichintsik xi xeꞌech ti jumumúl; yabtsik u óm, yabtsik in junkuwal i kʼapnél, nibal in taꞌpáltsik i kʼapnél ba wilteꞌ; por bélkʼi u kʼapundhábtsik kʼal na Dios xi kʼwajat walkʼiꞌ. ¿Awxeꞌ yab más a jalbíltsik ké an chʼichintsik? ");
INSERT INTO husNT2005_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿Ani jitaꞌ xi tatáꞌtsik, max ka kʼwajay tʼajat ti chalpax kʼal jun xataꞌ neꞌech kin ejto kin nakedhaꞌ tinbáꞌ elaꞌ chʼejel metro más? ");
INSERT INTO husNT2005_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","ʼ¿Jantʼókʼi ta kʼwajíltsik ta chalpax kʼal tin kwenta na kʼudhkʼúmil? Ka telaꞌtsik xan tu pakel an wich xi waꞌach ban aleláb, yab u tʼojnaltsik nibal u dhutseꞌlix. ");
INSERT INTO husNT2005_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Por tu utsáltsik ke nibal an pulek takʼix Salomón, kʼal ejtal nin tumínladhtal, yab kʼudhkʼumlinék labidh jelti an wichtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Max na Dios in labidhmédhál anchanꞌ an chʼojóltsik, xi xoꞌ kʼwajat ban aleláb ani kalám neꞌech ka tsikan, ¿awxeꞌ yab más neꞌech ti tolmiy tatáꞌtsik, atiklábtsik xi yab i lej belom? ");
INSERT INTO husNT2005_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Jaxtám, yab ki kʼwajaytsik ta chalpax ani ka ulutsik enchéꞌ: “¿Jantʼéy neꞌech ki kʼapu? O ¿jantʼéy neꞌech ki uchʼaꞌ? O ¿jantʼokʼál neꞌech ku kʼudhkʼumlin?” ");
INSERT INTO husNT2005_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Pos an atiklábtsik xi yab in exlál na Dios tokot in ayaltsik ejtal jechéꞌ; por na Tátaꞌ Dios xi kʼwajat túꞌ walkʼiꞌ, in choꞌób ke a yéntsaltsik ejtal jechéꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Jaxtám, ka aliytsik okʼox xan ti ki kʼwajay takʼnél kʼal na Dios ani ka tʼajaꞌtsik xowaꞌ Jajáꞌ in léꞌ ani ejtal jechéꞌ xowaꞌ a yéntsaltsik neꞌech ki pidhan. ");
INSERT INTO husNT2005_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Pos yab ki kʼwajaytsik ta chalpax kʼal tin kwenta xan ti neꞌech ka watʼnaꞌtsik kalám, pos kalám neꞌech jeye ka waꞌchin xantʼokʼál ti ki kʼwajaytsik ta chalpax. Tsudhey ka tsudhey u waꞌchinal xantʼokʼál ti ki kʼwajaytsik ta chalpax. ");
INSERT INTO husNT2005_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","ʼYabtsik ka walbiy xi kʼeꞌet abal yab teye ki walbiyattsik kʼal na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Pos anchanꞌ xan ti ka walbiytsik xi kʼeꞌet, anchanꞌ teye ti neꞌech ki walbiyattsik kʼal na Dios ani xowaꞌ ka tʼajtsi xi kʼeꞌettsik, jayéchkʼi teye neꞌech ki tʼajtsintsik kʼal na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Jantʼókʼi ta teltsal an ti elits xin koꞌol na at kidháb bin wal ani yab a chuꞌtal an yejcheꞌ elits xa koꞌol ba na wal? ");
INSERT INTO husNT2005_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿Janti neꞌech ka ejto ka utsaꞌ na at kidháb: “ti kin walkaꞌ tu jixtsi an ti elits xa koꞌol ba na wal”, max tatáꞌ más púlek an elits a koꞌol ba na wal? ");
INSERT INTO husNT2005_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Kʼambix!, ka jixaꞌ okʼox an yejcheꞌ elits xa koꞌol ba na wal ani anchanꞌ neꞌech tám ka ejto ka chuꞌu alwaꞌ abal ka jixtsi an ti elits xin koꞌol na at kidháb bin wal. ");
INSERT INTO husNT2005_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","ʼYab ka pidhaꞌ xowaꞌ tʼokat an atʼax iniktsik xin junwal jelti an pikʼoꞌ, abal yab telab, táꞌ ka witsiy ani ti ki tʼajtsi xowaꞌ yab alwaꞌ jelti tam u kʼatʼux an pikʼoꞌ. Ani yab ka pidhaꞌ xowaꞌ kajbidh in jalbíl an atʼax iniktsik xin junwal jelti an olom, abal yab táꞌ kin kʼáchʼíkʼnaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","ʼKa konoytsik xowaꞌ a yéntsal ani neꞌech ki pidhan kʼal na Dios; ka aliytsik ani neꞌech ka elaꞌ; ka tʼeneytsik an wiꞌleb ani neꞌech ki japtsin. ");
INSERT INTO husNT2005_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Pos xitaꞌ in konyal xowaꞌ in yéntsal, in bachʼwal; xitaꞌ in ayal, in elál ani xin tʼenyal an wiꞌleb, u japtsinal. ");
INSERT INTO husNT2005_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","ʼ¿Awxeꞌ waꞌach jun xitaꞌ xi tatáꞌtsik a kidhtal, ke max ka kontsin ti pan kʼal in chakámil neꞌech kin pidhaꞌ jun i tʼujub? ");
INSERT INTO husNT2005_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","O ¿max ka kontsin jun i toꞌol, kin pidhaꞌ jun i chan? ");
INSERT INTO husNT2005_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Pos max tatáꞌtsik, xi yabtsik i alwaꞌ inik, a witʼál ka pidhaꞌ xowaꞌ alwaꞌ na chakámiltsik, na Tátaꞌ Dios xi kʼwajat walkʼiꞌ, más Jaꞌ neꞌech kin pidhaꞌ xowaꞌ alwaꞌ xitaꞌ kʼál ti ka kontsin. ");
INSERT INTO husNT2005_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","ʼJaxtám, ejtal xowaꞌ a léꞌ ka chuꞌu ki tʼajtsin kʼal an atiklábtsik, jaꞌich teye ka tʼajtsi jajáꞌtsik, pos jechéꞌ jaꞌich xowaꞌ in ulal ka tʼajan nin takʼixtal na Dios xin jilám dhutsadh na Moisés ani xowaꞌ in dhutsámal jeye an tʼiltsixtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","ʼKi ochichtsik ban wiꞌleb xi xuyat. An wiꞌleb ani an bél xu júnax ban kʼibeltaláb, chʼikwat ani wejat ani yán u ocheltsik tajaꞌ; ");
INSERT INTO husNT2005_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","por an wiꞌleb ani an bél xu júnax ban xeꞌchintaláb xi yab in koꞌol in okʼontal, xuyat jaꞌ ani wéꞌ tʼajat xin eláltsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","ʼKa kóꞌoytsik tʼajat i kwenta kʼal an kʼambix tʼiltsixtsik. Jajáꞌtsik u ulel xon ta kʼwajattsik jelti max i alwaꞌ iniktsik. Por alkʼidh tin itsích i atʼax iniktsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Tatáꞌtsik neꞌech ka exlaꞌ kʼal xowaꞌkʼi in tʼajáltsik; pos yab u pitnal i uba ba kʼídh, nibal u pitnal i igo ba badhuts. ");
INSERT INTO husNT2005_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Anchanꞌ jeye, ejtal an teꞌtsik xi alwaꞌ, alwaꞌ in walíl in kóꞌyal ani an teꞌtsik xi yab alwaꞌ, yab alwaꞌ in walíl in kóꞌyal. ");
INSERT INTO husNT2005_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","An teꞌ xi alwaꞌ, yab neꞌech kin ejto kin kóꞌoy in walíl xi yab alwaꞌ ani an teꞌ xi yab alwaꞌ, yab jeye neꞌech kin kóꞌoy in walíl xi alwaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ejtal an teꞌtsik xi yab in kóꞌyal in walíl alwaꞌ, u kwajláb ani u tsiknal ban kʼamal. ");
INSERT INTO husNT2005_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Jaxtám, tatáꞌtsik neꞌech ka exlaꞌ an teꞌ kʼal nin walílkʼi. ");
INSERT INTO husNT2005_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","ʼYab ejtalkʼi xi tin utsáltsik, “Ajátik, Ajátik”, neꞌech kin ejto ka kʼwajay takʼnél kʼal na Dios, tokot xin tʼajáltsik xowaꞌ in léꞌ nu Tátaꞌ xi kʼwajat walkʼiꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Tam kin bajaw xowkʼi neꞌech an lújundhaxtaláb, yán neꞌech ti kin utsaꞌtsik enchéꞌ: “Ajátik, Ajátik, wawáꞌ i tʼilámal kʼal ta bij nin káwintal na Dios, kʼal tin awiltal na bij i káldhámal i atʼax ejattalábtsik ani i tʼajámal yán i labidh labandhaxtaláb.” ");
INSERT INTO husNT2005_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Por neꞌech ku utsaꞌtsik tám enchéꞌ: “Yab jaykʼi tu exlámaltsik; ki wixkʼintsik techéꞌ kʼal Nanáꞌ, atiklábtsik xa tʼajál xowaꞌ yab alwaꞌ.” ");
INSERT INTO husNT2005_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","ʼJaxtám, xitaꞌ tin axtsal ani in tʼajál xowaꞌ u ulal, in junwal jelti jun i inik xi chalpadh xin kubaꞌ nin kʼimáꞌ ba tʼujub. ");
INSERT INTO husNT2005_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ulich an áb, waꞌun an ikʼ, owtsikmé an waljaꞌ ani bawtsin tin akan jachanꞌ an atá, por kom ba tʼujub ti kubat, yab kwajlan. ");
INSERT INTO husNT2005_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Por xitaꞌ tin axtsal ani yab in tʼajál xowaꞌ u ulal, in junwal jelti jun i inik xi yab chalpadh xin kubaꞌ nin kʼimáꞌ ba kidhib. ");
INSERT INTO husNT2005_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ulich an áb, waꞌun an ikʼ, owtsikmé an waljaꞌ ani bawtsin tin akan jachanꞌ an atá ani kom ba kidhib ti kubat, julpá an atá ani pakudh ejtal ti jilkʼon. ");
INSERT INTO husNT2005_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Tam ti okʼon ti káw na Jesús, an atiklábtsik laban tʼajat xin achʼaꞌtsik xan tu okʼtsix na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Pos na Jesús u okʼtsix kʼal yantam i awiltaláb ani yab jelti an okʼtsixtsik xin wilál nin takʼixtal na Dios xin jilám dhutsadh na Moisés. ");
INSERT INTO husNT2005_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Tam ti na Jesús paꞌay ban chʼén, kʼal yán i atiklábtsik ti wéwná. ");
INSERT INTO husNT2005_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Utukná tám kʼal jun i inik xu yaꞌul kʼal an kʼwajat atʼax tʼítʼ, tudhlan tin tamét na Jesús ani in utsaꞌ enchéꞌ: ―Ajátik, max a léꞌ, neꞌech ka ejto ti kin jeldhaꞌ kʼal jechéꞌ an yawꞌlách xu koꞌol. ");
INSERT INTO husNT2005_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Takan tám kʼal na Jesús ani utsan enchéꞌ: ―U léꞌ ani xoꞌ i jeléch. Tokot tin ulu jechéꞌ, támkʼi ti wékʼon an kʼwajat atʼax tʼítʼ. ");
INSERT INTO husNT2005_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ani utsan enchéꞌ kʼal na Jesús: ―Yab xitaꞌ ka tʼiltsi xowaꞌ tu tʼajtsi, tokot ki kʼale, ki utey tin tamét an páleꞌ ani ka kʼwajbaꞌ an pikbantsixtaláb xan tin ulúmal na Moisés abal ejtal kin choꞌóbnaꞌ ke i jeléch kʼal an yawꞌlách xa koꞌol. ");
INSERT INTO husNT2005_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Tam ti na Jesús ochich ban bitsow xi Kapernaúm, utukná kʼal jun i okʼlek soldado romano ani pakabédhá. ");
INSERT INTO husNT2005_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Enchéꞌ ti utsan: ―Ajátik, nu tʼojnálil taꞌ kwachat tu kʼimáꞌ, yab in ejtowal ka yoyon ani u yajlom tʼajat. ");
INSERT INTO husNT2005_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Utsan enchéꞌ kʼal na Jesús: ―Neꞌech kin kʼale abal ku jeldhaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Tókʼoyat enchéꞌ kʼal an okʼlek soldado: ―Ajátik, yab in tomnál ki ochich tu kʼimáꞌ; tokot ka ulu abal ka jeley nu tʼojnálil ani neꞌech ka jeley. ");
INSERT INTO husNT2005_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Pos nanáꞌ in takʼnélkʼi neye tin kʼwajat kʼal nu okʼlékiltsik, por u koꞌol neye i soldadotsik xi nanáꞌ u takʼyal. Tam ku utsaꞌ jun i soldado ka kʼale, u kʼalel, tam ku utsaꞌ kʼeꞌet ka tsích, u tsiꞌil ani tam ku utsaꞌ nu tʼojnálil kin tʼajaꞌ jun xataꞌ, in tʼajál. ");
INSERT INTO husNT2005_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Tam ti na Jesús in achʼaꞌ jechéꞌ, laban tʼajat ani in utsaꞌtsik enchéꞌ xi kʼál ti wewkómte: ―Tsubax tu utsáltsik, ke putál ban chabál xi Israel yab u elámal ni jun xitaꞌ xu belom jelt xan tu belom jechéꞌ an inik. ");
INSERT INTO husNT2005_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nanáꞌ tu utsáltsik abal yán neꞌech ka tsíchtsik xon tu kalel na kʼítsá ani xon tu ochel na kʼítsá ani neꞌech ka buxkantsik kʼal na Abraham, na Isák ani na Jakob xon tu takʼix na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Waꞌach an israelitatsik xin chalpayal abal neꞌech ka kʼwajay xon tu takʼix na Dios abalkʼi u kidhtalábtsik kʼal na Abraham, por neꞌech ka káldhátsik eléb ban jikʼwaxtaláb. Tajaꞌ neꞌech ti ukʼnaltsik ani ti rechʼechʼél nin kamab. ");
INSERT INTO husNT2005_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Utsan tám enchéꞌ an okʼlek soldadotsik kʼal na Jesús: ―Ki kʼaléch ani ka tʼájan xan ta belál. Ani támkʼi jachanꞌ i ora ti jeley nin tʼojnálil. ");
INSERT INTO husNT2005_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Na Jesús kʼale bin kʼimáꞌ na Pedro ani in chuꞌu nin mím na Pedro kwachat bin waytal abal u kʼakʼél. ");
INSERT INTO husNT2005_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Taktsin tám tin kʼubak kʼal na Jesús ani wékʼon an kʼakʼlách; chʼakay tám an mímláb ani tujey ti tʼójontsáb na Jesús junax kʼal nin exóbaliltsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Tam ti jikʼwchinich, júntsin na Jesús yán i atiklábtsik xi ochadh kʼal i atʼax ejattaláb ani kʼal nin káwintalkʼi, in káldhaꞌ ejtal an atʼax ejattalábtsik ani in jeldhaꞌ jeye ejtal an yaꞌultsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Jechéꞌ támun abal ka tʼájan xan tin ulúmal an tʼiltsix Isaías, tam tin ulu enchéꞌ: “Jajáꞌ in kitnaꞌ ejtal an yawꞌlách xi koꞌol ani in júnaꞌ an yajtsiktaláb xi koꞌol.” ");
INSERT INTO husNT2005_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Tam ti na Jesús in chuꞌu abal kʼal yán i atiklábtsik ti wilidh, in ulu ka watʼbá jun pakʼeꞌ jaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Utukná tám na Jesús kʼal jun i okʼtsix xin wilál nin takʼixtal na Dios xin jilám dhutsadh na Moisés ani utsan enchéꞌ: ―Okʼtsix, u léꞌ tu wéwnaꞌ xónꞌtikichkʼi ki kʼale. ");
INSERT INTO husNT2005_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Tókʼoyat enchéꞌ kʼal na Jesús: ―Na wáx in koꞌol nin kʼimáꞌ ani an chʼichintsik in koꞌol nin pákʼw; por Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik, yab u koꞌol xon ti kin koyóch. ");
INSERT INTO husNT2005_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Utsan jeye enchéꞌ kʼal jún ti éb nin exóbaliltsik: ―Ajátik, neꞌech okʼox ku aytsi ka chemech nu tátaꞌ ani tam u jolyámich, tám neꞌech tu wéwnaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Tókʼoyat enchéꞌ kʼal na Jesús: ―Ti kin wéwnaꞌich, jilaꞌ ka jolyat an chemélomtsik kʼal xi yabtsik u belom. ");
INSERT INTO husNT2005_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ochich tám na Jesús ban tan ani wéwná kʼal nin exóbaliltsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Jun jikʼtowál ti tujey ti wawꞌnal i chapik ikʼ ban pujal ani múlákʼin an jaꞌ ke asta in luyꞌchiyalich an tan. Por na Jesús kʼwajat ti wayal. ");
INSERT INTO husNT2005_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Kʼale tám ti bakyáb kʼal nin exóbaliltsik ani utsan enchéꞌ: ―¡Ajátik, ti ku loꞌo! ¡Exomich tu lupnal! ");
INSERT INTO husNT2005_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Tókʼoyattsik enchéꞌ kʼal na Jesús: ―¿Jantʼókʼi ta jikʼél, atiklábtsik xi wéꞌ tʼajat ta belom? Chʼakay tám na Jesús, in kʼwiyaꞌ an ikʼ ani an pujal ani támkʼi ti jilkʼon chamamadh. ");
INSERT INTO husNT2005_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","An iniktsik laban tʼajat ani in ulutsik enchéꞌ: ―¿Jitam inik awil xi jechéꞌ, ke asta kʼal an ikʼ ani an pujal tu exbantsáb? ");
INSERT INTO husNT2005_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Tam ti na Jesús ulich jun pakʼeꞌ jaꞌ, ban chabál xi Gadara, utukná kʼal cháb i iniktsik xi kale ban jólimtaláb. Chablam jechéꞌ an iniktsik kʼwajat ochadhtsik kʼal i atʼax ejattalábtsik ani watʼatsich tʼajat ti atʼaxtsik ke nibalich xitaꞌ in ejtowal ka watʼey ba jachanꞌ an bél. ");
INSERT INTO husNT2005_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ani in ulutsik kawidh enchéꞌ: ―¿Jantʼéy a léꞌ kʼal wawáꞌ, Jesús, xi Chakámláb kʼal na Dios? ¿I tsiꞌnek abal ti ku yajlombédhaꞌ maske yabél in bajúmal xowkʼi neꞌech an lújundhaxtaláb? ");
INSERT INTO husNT2005_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Tajaꞌ kʼunat taꞌ ti xeꞌech yán i olomtsik ti kʼapupúl ");
INSERT INTO husNT2005_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","ani an atʼax ejattalábtsik in pakabédhaꞌ enchéꞌ na Jesús: ―Max ti ku káldhaꞌ, ti ku walkaꞌ ku ochich núꞌ ban olomtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Utsantsik tám enchéꞌ kʼal na Jesús: ―Ki kʼaléchtsik. Kale tám an atʼax ejattalábtsik ban iniktsik ani ochich ban olomtsik. Támkʼi jachanꞌ, ejtal an olomtsik in petʼnaꞌ tinbáꞌ ba jun i chʼén, kwajlan ban pujal ani tajaꞌ ti lupuntsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","An belkol olomtsik, jikʼeytsik tʼajat ani ájlách. Tam ti ulichtsik ban bitsow, in tʼilaꞌtsik ejtal jechéꞌ ani xantʼéy támun kʼal an iniktsik xi ochadhtsik kʼal an atʼax ejattalábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Tam ti an atiklábtsik xu kʼwajíl ba jachanꞌ an bitsow in achʼaꞌ jechéꞌ, kʼaletsik ejtal xon ti kʼwajat na Jesús ani tam ti chuꞌtat na Jesús, pakabédhá abal yabich más ka xeꞌchin ba jachanꞌ an chabál. ");
INSERT INTO husNT2005_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Balin tám na Jesús ban tan, watʼey juní jun pakʼeꞌ jaꞌ ani ulich bin bitsówil. ");
INSERT INTO husNT2005_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Júntsin tajaꞌ kwachat ba jun i chayteꞌ jun i inik xi yab in ejtowal ka yoyon. Tam ti na Jesús in chuꞌu abal u belnal kʼal jajáꞌtsik, in utsaꞌ enchéꞌ an yaꞌul: ―Payꞌlomláb, yab ka jilaꞌ tabáꞌ; na walastalábil pakwlantsidhich ti kʼwajat. ");
INSERT INTO husNT2005_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Tam ti na Jesús in ulu jechéꞌ, taltsik an okʼtsixtsik xin wilál nin takʼixtal na Dios xin jilám dhutsadh na Moisés, in chalpaytsik enchéꞌ: “Jechéꞌ in tʼajálich jelti max Jajáꞌ u Dios.” ");
INSERT INTO husNT2005_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Kom na Jesús in choꞌób xantʼéy kʼwajat in chalpayaltsik, in utsaꞌtsik enchéꞌ: ―¿Jantʼókʼi ti yab tʼajat alwaꞌ i chalab a koꞌoltsik? ");
INSERT INTO husNT2005_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Pos ¿jowaꞌ más yab tʼojláb ku ulu: “Na walastalábil pakwlantsidhich ti kʼwajat”, o ku ulu: “Ki chʼakay ani ki beley”? ");
INSERT INTO husNT2005_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Pos alwaꞌich, neꞌech tu xalkʼantsitsik ke Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik, u koꞌol i awiltaláb techéꞌ ti chabál abal ku pakwlantsi xi walbidhtsik. In utsaꞌ tám enchéꞌ an inik xi yab in ejtowal ka yoyon: ―Ki chʼakay, ka dhayaꞌ na chaytéꞌil ani ki kʼaléch ta kʼimáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Chʼakay tám an inik xi yab in ejtowal ka yoyon ani kʼaléch tám tin kʼimáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Tam ti an atiklábtsik in chuꞌu jechéꞌ, labantsik ani in pubédhantsi tin bij na Dios abal in pidhámal jechéꞌ an ti awiltaláb an iniktsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Tam ti na Jesús kale tajaꞌ, in chuꞌu jun i inik xin bij ta Mateo buxúl xon tin bachʼwal an jalbixtaláb abal an chabál xi Roma ani in utsaꞌ enchéꞌ: ―Wana ta exóbal kʼal Nanáꞌ. Chʼakay tám na Mateo ani in wéwnaꞌ na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Jun i kʼij, tam ti na Jesús kʼwajat ti kʼapul tin kʼimáꞌ na Mateo, ulich yán i bachʼkʼul jalbixtaláb ani i walablomtsik. Jechéꞌ an iniktsik buxkan jeye ti kʼapultsik ban mesa xon ti kʼwajat ti kʼapul na Jesús kʼal nin exóbaliltsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Tam ti an fariseotsik in chuꞌu jechéꞌ, in utsaꞌ enchéꞌ nin exóbaliltsik na Jesús: ―¿Jantʼókʼi tu kʼapul na Okʼtsíxal kʼal an bachʼkʼul jalbixtaláb ani kʼal an walablomtsik? ");
INSERT INTO husNT2005_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Tam ti na Jesús in achʼaꞌ jechéꞌ, in utsaꞌtsik enchéꞌ: ―Xi kʼwajattsik alwaꞌ ani yab u yaꞌul, yab in yéntsal i ilálix, por xu yaꞌul, in yéntsal. ");
INSERT INTO husNT2005_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ki kʼaléchtsik ani ka exbaytsik xantʼéy in léꞌ kin ulu jechéꞌ an Tʼokat Dhuslab: “Nanáꞌ u léꞌ ka kóꞌoytsik i yajnantsixtaláb ani yabich u léꞌ ka pikbaꞌ i chemdhats koꞌnéltsik.” Pos Nanáꞌ yab in tsiꞌnek ku aliy xi xeꞌechtsik lujat, in tsiꞌnek ku aliy xi walbidhtsik abal kin jilaꞌichtsik ti walablom. ");
INSERT INTO husNT2005_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Utukná tám na Jesús kʼal nin exóbaliltsik na Juan xu Pujax ani konyat enchéꞌ: ―¿Jantʼókʼi ti wawáꞌ ani an fariseotsik jeye u kʼíl tʼajat ani na exóbaliltsik yab u kʼíl? ");
INSERT INTO husNT2005_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Tókʼoyattsik enchéꞌ kʼal na Jesús: ―¿Awxeꞌ yejat ka kʼwajaytsik tʼeꞌpidh xi kanidhtsik ba jun i tomkixtaláb, tam an tomkinél inik kʼwajat kʼal jajáꞌtsik? ¡Yabaꞌ! Por neꞌech kin bajaw an kʼij tam ka wixkʼintsattsik an ti tomkinél inik ani neꞌchich jeye tám ti kʼíltsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","ʼYab xitaꞌ in patsʼkʼuyal jun i kʼej xeketláb kʼal jun pejeꞌ i ít kʼudhkʼum; pos an ít kʼudhkʼum, u muchel ani in michʼál más an kʼej kʼudhkʼum. ");
INSERT INTO husNT2005_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Nibal u balyáb an ít yajtsik uxnél ba kʼej ótʼ balixtaláb; pos max ka tʼajan anchanꞌ, an ótʼ balixtaláb u michʼkʼanal ani an yajtsik uxnél neꞌech ka wakʼlan. Jaxtám ti yejat ka balyat an ít yajtsik uxnél ban ít ótʼ balixtaláb abal chablam yab ka kʼibchon. ");
INSERT INTO husNT2005_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Lejat kʼwajat ti usnaltsik kʼal na Jesús ejtal jechéꞌ, ulich jun in okʼlékil an judíotsik, tudhlan tin tamét na Jesús ani in ulu enchéꞌ: ―Nu tsidhánil talél ti chemech, por max Tatáꞌ ki tsích ani ka takaꞌ, neꞌech ka ejech. ");
INSERT INTO husNT2005_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Chʼakay na Jesús ani kʼale kʼal jachanꞌ an inik junax kʼal nin exóbaliltsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Tam ti na Jesús neꞌech ti bél, utukná kʼal jun i mímláb xin neꞌdhálich lajucháb i tamub ti yaꞌul kʼal i lakúmtaláb, utey tin kúx na Jesús ani in taktsi tin wál nin kʼudhkʼúmil. ");
INSERT INTO husNT2005_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","In tʼajaꞌ anchanꞌ abal in chalpayal enchéꞌ: “Max u ejtowalak ku taktsi tin kʼudhkʼúmil, neꞌech kin jeley.” ");
INSERT INTO husNT2005_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Por na Jesús chawꞌkʼin, in chuꞌu an mímláb ani in utsaꞌ enchéꞌ: ―Mímláb, yab ka jilaꞌ tabáꞌ; i jeley abal i belmách. Ani támkʼi jachanꞌ, jilkʼon jelnek an mímláb. ");
INSERT INTO husNT2005_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Tam ti na Jesús ulich bin kʼimáꞌ an okʼlek inik ani in chuꞌu tʼojojodhich an tʼéneltsik abal an jólmách ani an atiklábtsik chapik u ukʼnaltsik, ");
INSERT INTO husNT2005_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","in utsaꞌtsik enchéꞌ: ―Ki kaletsik eléb, an tsidhan yab chemnek, u wayalkʼi ti kʼwajat. Tam ti achʼan in ulu jechéꞌ, labídhná kʼal an atiklábtsik, ");
INSERT INTO husNT2005_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","por in utsaꞌ ka kaletsik eléb. Ochich tám na Jesús, in téynaꞌ an tsidhan bin kʼubak ani chʼakay an tsidhan. ");
INSERT INTO husNT2005_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Jechéꞌ xowaꞌ in tʼajaꞌ na Jesús, choꞌóbná putálkʼi ba jachanꞌ an chabál. ");
INSERT INTO husNT2005_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Tam ti na Jesús kale tajaꞌ, wéwná kʼal cháb i jokʼoltsik, xi dhájaxintsik chapik enchéꞌ: ―¡Tatáꞌ xi kuxlab kʼal na Dabid, ti ku yajnantsi weye! ");
INSERT INTO husNT2005_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Tam ti na Jesús ochich ban atá, utukná kʼal an jokʼoltsik ani Jajáꞌ in konoy enchéꞌ: ―¿A beláltsikxeꞌ ke neꞌech ku ejto ku tʼajaꞌ xowaꞌ tin kontsaltsik? Jajáꞌtsik tókʼon enchéꞌ: ―I belál, Ajátik. ");
INSERT INTO husNT2005_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Taktsintsik tám an tin wal kʼal na Jesús ani utsantsik enchéꞌ: ―Pos ka tʼájan xan ta beláltsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Chuꞌxinichtsik tám, por utsantsik tʼajat enchéꞌ kʼal na Jesús: ―Yab ka tʼilaꞌtsik jechéꞌ abal yab kin choꞌóbnaꞌ ni jun xitaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Por tokot ti kaletsik tajaꞌ, in tʼilaꞌ putál ba jachanꞌ an chabál xantʼéy tʼajtsintsik kʼal na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Tam ti kʼaléch an jokʼoltsik, uldhantsat na Jesús jun i móꞌ xi ochadh kʼal i atʼax ejattaláb. ");
INSERT INTO husNT2005_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Tam ti na Jesús in káldhaꞌ an atʼax ejattaláb, an móꞌ káwinich tám. An atiklábtsik u labnal tʼajat ani in ulaltsik enchéꞌ: ―Yab jaykʼi i chuꞌúmal techéꞌ Israel jun xataꞌ jelti jechéꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Por an fariseotsik in ulal enchéꞌ: ―Jechéꞌ an inik in káldhál an atʼax ejattalábtsik kʼal tin awiltal in okʼlékil an atʼax ejattalábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Na Jesús xeꞌech in lonyal putál an bitsowtsik ani an kwentsaltsik ani u okʼtsix ban atátsik xon tu tʼajnal an junkuntaláb xi waꞌach tajaꞌ. In tʼilál an alwaꞌ tʼilab kʼal tin kwenta xan tu takʼix na Dios, in jeldhál ejtalkʼi kʼal xowaꞌkich i yawꞌlách ani kʼal xowaꞌkichkʼi jeye i yajtsiktaláb. ");
INSERT INTO husNT2005_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Tam tin chuꞌu yán an atiklábtsik, in kóꞌontsi ti yajnantsixtaláb abal in chuꞌtal ke walbadhtsik ti kʼwajat ani kʼwajat jelti borregotsik xi yab in koꞌol xitaꞌ kʼál ti ka beletná. ");
INSERT INTO husNT2005_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","In utsaꞌ tám enchéꞌ nin exóbaliltsik: ―Tsubax tu utsáltsik, ke anchanꞌ jelti tam labenek tʼajat nin walíl an tʼayabláb, anchanꞌ jeye ti waꞌach tʼajat xitaꞌ neꞌech ti kin belaꞌ. Por anchanꞌ jelti tam wéꞌ tʼajat an tʼojnaltsik waꞌach abal kin junkuntsi tin walíl an tʼayabláb, anchanꞌ jeye wéꞌ tʼajat waꞌach xitaꞌ kin tʼiltsi an ti alwaꞌ tʼilab an atiklábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Anchanꞌ jelt xan ti an dhabal tʼayabláb in abál i tʼojnaltsik abal kin junkuntsi tin walíl an tʼayabláb, anchanꞌ ti ka kontsitsik na Dios kin abaꞌ xitaꞌ kin tʼiltsi an ti alwaꞌ tʼilab an atiklábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","In kaniy tám na Jesús xi lajucháb nin abatwálejiltsik ani in pidhaꞌ ti awiltaláb abal kin káldhaꞌ i atʼax ejattalábtsik, abal kin jeldhaꞌ ejtalkʼi kʼal xowaꞌkichkʼi i yawꞌlách ani kʼal xowaꞌkichkʼi jeye i yajtsiktaláb. ");
INSERT INTO husNT2005_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Jechéꞌ jaꞌich nin bij xi lajucháb an abatwáletsik: na Simón, xi bijyat jeye ta Pedro ani nin kidháb Andrés; na Jakobo ani nin kidháb Juan, xu chakámlábtsik kʼal na Sebedeo. ");
INSERT INTO husNT2005_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Na Felipe, na Bartolomé, na Tomás ani na Mateo xin bachʼwal an jalbixtaláb abal an chabál xi Roma; na Jakobo nin chakámil na Alfeo ani na Lebeo, xu bijyáb jeye Tadeo. ");
INSERT INTO husNT2005_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Na Simón, xu takʼnal ban junkuntaláb xu bijyáb kananista ani na Judas Iskariote, xi tayíl kʼál ti pidhná na Jesús abal ka chemdhá. ");
INSERT INTO husNT2005_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Na Jesús in abaꞌ jechéꞌ lajucháb, kʼal jechéꞌ an punkʼuntsixtaláb: ―Yab ki kʼaletsik ban chabál xon tu kʼwajíl xi yabtsik u judío, nibal ki ochich ban bitsowtsik xi Samaria. ");
INSERT INTO husNT2005_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ki kʼaletsik okʼox ban yejcheꞌ bitsow Israel abal ka aliy xi yabtsik u belom. ");
INSERT INTO husNT2005_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Xon ti ki watʼey, ka tʼiláltsik abal exomich ti kʼunel xowkʼi na Dios neꞌech kin takʼích an atiklábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ka jeldhaꞌ an yaꞌultsik, ka ejdhaꞌ an chemélomtsik, ka jeldhaꞌtsik xin koꞌol an kʼwajat atʼax tʼítʼ ani ka káldhaꞌ an atʼax ejattalábtsik. Kom anikʼi ta bachʼúmaltsik jechéꞌ an awiltaláb, anikʼi jeye ti ka tʼajaꞌtsik xowaꞌkich an alwaꞌtaláb. ");
INSERT INTO husNT2005_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","ʼKi kʼaletsik mapats, yab ka júnaꞌtsik i tumín ");
INSERT INTO husNT2005_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","nibal i morrál. Yab ka júnaꞌtsik yán a xekét nibal yán a pajab, tokot xa kʼwajbím, nibal ka júnaꞌtsik a kwayab; pos an tʼojnal in tomnál ka kʼapundhá xon tu tʼójontsix. ");
INSERT INTO husNT2005_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","ʼTam ki ulichtsik ba jun i bitsow o ba jun i kwentsal, ka aliytsik jun xitaꞌ xi alwaꞌ inik ani tajaꞌ ki kʼwajaytsik bin kʼimáꞌ asta kin bajaw xowkʼi ti ki kaletsik tajaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Tam ki ochichtsik ba jachanꞌ an kʼimádh, ki chapnédhaxintsik enchéꞌ: “Ki kʼwajaytsik kʼijidh.” ");
INSERT INTO husNT2005_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Max an atiklábtsik xu kʼwajíl ba jachanꞌ an atá in tomnál kin bachʼutsik jechéꞌ an chapnédhomtaláb, neꞌech ka kʼwajaytsik kʼijidh, por max yab in tomnáltsik kin bachʼu, yab neꞌech ka kʼwajaytsik kʼijidh. ");
INSERT INTO husNT2005_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Max yab ki bachʼwattsik nibal ki leꞌná ki axtsintsik, ki kaletsik tám ba jachanꞌ an atá o ba jachanꞌ an bitsow ani ka tiniytsik an pojodh xi palenek ba na akan. ");
INSERT INTO husNT2005_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Tsubax tu utsáltsik ke tam kin bajaw xowkʼi neꞌech an lújundhaxtaláb, más jaꞌ púlek an yajtsiktaláb neꞌech kin bachʼu jachanꞌ an bitsow ké an yajtsiktaláb xi neꞌech kin bachʼu an atiklábtsik xi kʼwajinek ban chabál xi Sodoma ani Gomorra. ");
INSERT INTO husNT2005_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","ʼ¡Ka achʼaꞌtsik! Tu abál ka tʼilaꞌtsik an alwaꞌ tʼilab xon ti waꞌach i atiklábtsik xi atʼax. Jelti max exom u abál i borregotsik xon ti waꞌach i padhumtsik. Ka kóꞌoytsik tʼajat i kwenta jelt xan tin tʼajál an chan por ka chaꞌkaꞌtsik tʼajat tabáꞌ jelt xan tin tʼajál an kukuꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ka kóꞌoytsik tʼajat i kwenta, pos neꞌech ki pidhnátsik ban awiltaláb kʼal an atiklábtsik xi atʼax ani neꞌech ki lekbayattsik ban atá xon tu tʼajnal an junkuntaláb. ");
INSERT INTO husNT2005_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ani asta neꞌech ki júnátsik tin tamét i pakdhaꞌ awiltaláb ani tin tamét i pakdhaꞌ takʼix kʼal Nanáꞌkʼi tu kwenta. Anchanꞌ neꞌech tám ka ejtotsik ti kin tʼilaꞌ tin tamét an awiltalábtsik ani tin tamét xi yabtsik u judío. ");
INSERT INTO husNT2005_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Por tam ki pidhnátsik ban awiltaláb, yab ki kʼwajaytsik ta chalpax kʼal tin kwenta xantʼéy neꞌech ka ulutsik o xan ti neꞌech ki tókʼontsik; pos tam kin bajúch xowkʼi neꞌech ta lújundhábtsik kʼal an awiltaláb, na Dios neꞌech ti ki óltsi xan ti yejat ki tókʼontsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Pos yab tatáꞌtsik neꞌech ta káw, neꞌech ti káw nin Tʼokat Ejattal na Tátaꞌ Dios. ");
INSERT INTO husNT2005_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","ʼAn iniktsik neꞌech kin pidhnaꞌ nin kidháb abal ka chemdhá ani an tátaꞌlábtsik neꞌech kin pidhnaꞌ nin chakámil abal ka chemdhá. An chakámlábtsik neꞌech kin tomnaꞌ nin tátaꞌ ani nin nánaꞌ ani neꞌech kin tʼajaꞌ abal ka chemdhátsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Neꞌech ki atʼantsik kʼal ejtal an atiklábtsik xi yab u belom kʼal Nanáꞌkʼi tu kwenta; por xitaꞌ kin kuxuy ejtal jechéꞌ, neꞌech ka loꞌwat. ");
INSERT INTO husNT2005_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Tam ki atʼantsik ba jun i bitsow, ki kʼaletsik píl; pos tsubax tu utsáltsik ke Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik, neꞌech kin tsích juní tam tatáꞌtsik yabél a lonyámal ejtal in bitsówil an israelitatsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","ʼNi jun i exóbal más u awil ke nin okʼtsíxal ani ni jun i tʼójontsix más uluts ke nin ajátik. ");
INSERT INTO husNT2005_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Abal an exóbal, lejatich jeye max in bajúch jelti nin okʼtsíxal ani an tʼójontsix jelti nin ajátik. Max Nanáꞌ, xin kʼwajat jelti max tin tátaꞌtsik, in bijyáb tin lej atʼax, ¿jan ti neꞌech ki bijyat tatáꞌtsik xi kʼwajat jelti max tu chakámiltsik? ");
INSERT INTO husNT2005_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","ʼJaxtám, yab yejat ka jikʼnaꞌ an atiklábtsik. Pos yab waꞌach ni jun xataꞌ xi yab neꞌech ka chuꞌtat, nibal waꞌach xataꞌ chinat xi yab neꞌech ka choꞌóbná tayíl. ");
INSERT INTO husNT2005_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Xowaꞌ tu utsáltsik xon ti yab tejwaꞌ, ka ulutsik xon ti tejwaꞌ ani xowaꞌ tu utsáltsik chinat, ka ulutsik xon ti yán kin achʼaꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Yab ka jikʼnaꞌ an chemdhaxtsik, pos tokot in ejtowal ti ki chemdhantsi an ta tʼuꞌúl ani yab in ejtowal ti ki chemdhantsi an ta ejattal. Ka jikʼnaꞌtsik na Dios xin ejtowal ti ki chemdhantsi an ta ejattal ani ti ki petʼnantsi an ta tʼuꞌúl ban kʼibeltaláb. ");
INSERT INTO husNT2005_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","ʼ¿Yabxeꞌ u nujwáb cháb i chʼichintsik kʼal wéꞌ i tumín? Por ni jún xi jachanꞌ an chʼichintsik yab neꞌech ka kwajlan max na Tátaꞌ Dios yab anchanꞌ tin léꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Pos asta na xiꞌíl xa koꞌoltsik ba na ókʼ ajidh ti kʼwajat. ");
INSERT INTO husNT2005_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Pos yabtsik pé ka jikʼnaꞌ ni jun xitaꞌ, tatáꞌtsik más yán a jalbíl ké yantam i chʼichintsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","ʼXitaꞌ yab kin tidhenaꞌ ti kin tʼilaꞌ tin tamét an atiklábtsik, Nanáꞌ yab neye neꞌech ku tidhenaꞌ ku tʼilaꞌ tin tamét nu Tátaꞌ xi kʼwajat walkʼiꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Por xitaꞌ kin tidhenaꞌ ti kin tʼilaꞌ tin tamét an atiklábtsik, neꞌech neye ku tidhenaꞌ ku tʼilaꞌ tin tamét nu Tátaꞌ xi kʼwajat walkʼiꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","ʼYab ka chalpaytsik ke Nanáꞌ in tsiꞌnek techéꞌ ti kʼayꞌlá abal ku tsiꞌdhaꞌ i kʼijidhtaláb; pos yab anchanꞌ, in tsiꞌnek abal ku tsiꞌdhaꞌ i péjéxtaláb. ");
INSERT INTO husNT2005_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","In tsiꞌnek abal ku péjéxlindhaꞌ an kwitól kʼal nin tátaꞌ, an tsidhan kʼal nin nánaꞌ ani an alꞌíbe kʼal nin mím. ");
INSERT INTO husNT2005_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ani anchanꞌ, xi kʼwajattsik ba jun i atá, jajáꞌkʼitsik neꞌech ti péjéx. ");
INSERT INTO husNT2005_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","ʼXitaꞌ in kʼanidhál más nin tátaꞌ o nin nánaꞌ ke Nanáꞌ, yab neꞌech kin ejto ka kʼwajay kʼal Nanáꞌ; xitaꞌ in kʼanidhál más nin chakámiltsik ke Nanáꞌ, yab jeye neꞌech kin ejto ka kʼwajay kʼal Nanáꞌ ");
INSERT INTO husNT2005_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","ani xitaꞌ ti kin wéwnaꞌ por in chʼejnál ka chemdhá, yab neꞌech kin ejto ka kʼwajay kʼal Nanáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Xitaꞌ in léꞌ kin loꞌo nin xeꞌchintal, neꞌech kin kʼibdhaꞌ; por xitaꞌ kin kʼibdhaꞌ nin xeꞌchintal kʼal Nanáꞌ tu kwenta, neꞌech kin loꞌo. ");
INSERT INTO husNT2005_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","ʼXitaꞌ ti ki bachʼutsik, Nanáꞌ tin bachʼwal ani xitaꞌ ti kin bachʼu Nanáꞌ, in bachʼwalich xi tin abámal. ");
INSERT INTO husNT2005_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Xitaꞌ kin bachʼu jun i tʼiltsix abal in choꞌób ke kʼal a Dios ti abnék, neꞌech kin bachʼu i chʼejwalixtaláb jelti xi neꞌech kin bachʼu jun i tʼiltsix; xitaꞌ kin bachʼu jun i lujat inik abal in choꞌób ke i lujat inik, neꞌech kin bachʼu i chʼejwalixtaláb jelti xi neꞌech kin bachʼu jun i lujat inik. ");
INSERT INTO husNT2005_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ani xitaꞌ kin pidhaꞌ jun tuꞌ ti chamay jaꞌ jún ti éb xi jechéꞌtsik abal in choꞌób ke Nanáꞌ u exóbalil, neꞌech jeye kin bachʼu nin chʼejwalíb. ");
INSERT INTO husNT2005_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Tam ti na Jesús okʼon kin takʼiy xi lajucháb nin exóbaliltsik, kʼale ban kwentsaltsik xi kʼwajat ba jachanꞌ an chabál abal kin okʼtsitsik ani kin tʼiltsitsik an ti alwaꞌ tʼilab. ");
INSERT INTO husNT2005_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Tam ti na Juan xi balidh ban wikʼaxteꞌ in achʼaꞌ xowaꞌ in tʼajál na Kristo, in abaꞌ in exóbaliltsik abal ka kʼale kin chuꞌu na Jesús ");
INSERT INTO husNT2005_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ani kin konoy enchéꞌ: ―¿Tatáꞌichxeꞌ kwaꞌ xi bijidh neꞌech ka tsích o yejat ki aytsi kʼeꞌet? ");
INSERT INTO husNT2005_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Tókʼoyattsik enchéꞌ kʼal na Jesús: ―Ki kʼaletsik ani ka óltsi na Juan xowaꞌ exomtsik a chuꞌtal ani a achʼál. ");
INSERT INTO husNT2005_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ka óltsi abal an jokʼoltsik u chuꞌxinal, an kʼwechʼeꞌtsik u jelél, xin koꞌoltsik an kʼwajat atʼax tʼítʼ u jelél, xi yabtsik u ochʼox u ochʼxinal, an chemélomtsik u ejdháb ti ít ani an chʼojontáltsik u tʼiltsinal an ti alwaꞌ tʼilab. ");
INSERT INTO husNT2005_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Kʼijidh tʼajat abal xitaꞌ ti kin belaꞌ ani yab kin jilaꞌ ti kin belaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Tam ti nin exóbaliltsik na Juan kʼaléch, na Jesús tujey kin tʼiltsi an atiklábtsik kʼal tin kwenta na Juan, enchéꞌ tin utsaꞌtsik: ―¿Jantʼéy i kʼaletsik ka chuꞌu ban chabál xon ti yab kʼwajtsidh? ¿Jun i pakáb xi kʼwajat ti wawꞌyáb kʼal i ikʼ? ");
INSERT INTO husNT2005_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Max yabaꞌ, ¿jantʼéy i kʼaletsik ka chuꞌu? ¿Jun i inik xi xeketlidh kʼal i alwaꞌ kʼudhkʼum? Tatáꞌtsik a choꞌób ke xu xeketlinaltsik kʼal i alwaꞌ kʼudhkʼum u kʼwajíltsik bin kʼimáꞌ i pakdhaꞌ takʼix. ");
INSERT INTO husNT2005_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Max yab anchanꞌ, ¿jantʼéy i kʼaletsik ka chuꞌu? ¿Jun i tʼiltsix? Jaꞌich, ani jaꞌich jun xitaꞌ xi más púlek ké jun i tʼiltsix. ");
INSERT INTO husNT2005_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Na Juan jaꞌich xu tʼilnal enchéꞌ kʼal an Tʼokat Dhuslab: Neꞌech ku okxiy nu abatwálejil abal ti ki tʼojojontsi an ti bél. ");
INSERT INTO husNT2005_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Tsubax tu utsáltsik ke ejtal an atiklábtsik xi kʼwajinekich asta xoꞌ, yab jaykʼi waꞌchinék jun xitaꞌ más ultaláb ké na Juan xu pujax; por tu utsáltsik, xi más chaꞌat in éy xon tu takʼix na Dios, más jaꞌ ultaláb ké na Juan xu pujax. ");
INSERT INTO husNT2005_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","ʼAsta ti tsích na Juan xu pujax abal kin tʼilaꞌ an alwaꞌ tʼilab ani asta xoꞌ, waꞌach xin tʼajáltsik an chápláb abal ka kʼwajay takʼnél kʼal na Dios ani jaꞌich jajáꞌtsik xi neꞌech ka kʼwajay takʼnél kʼal na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ejtal an tʼiltsixtsik ani nin takʼixtal na Dios xin jilám dhutsadh na Moisés, in ólnámal xowaꞌ na Dios neꞌech kin tʼajaꞌ asta ti tsích na Juan ");
INSERT INTO husNT2005_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","ani max tatáꞌtsik a léꞌ ka belaꞌ, na Juan jaꞌich an tʼiltsix Elías xi bijidh neꞌech ka tsích. ");
INSERT INTO husNT2005_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Xin koꞌoltsik in ochʼoxtal alwaꞌ, kin exbay. ");
INSERT INTO husNT2005_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","ʼ¿Jantʼokʼál neꞌech ku ejto ku junbay an atiklábtsik xi jechéꞌ i kʼij? In junwal jelti an chakamtsik xu buxkanal ti ubátʼ chʼejel bitsow ani in dhájayal nin at ubátʼtsik enchéꞌ: ");
INSERT INTO husNT2005_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“I jutsuy an chúl ani yab i bixmáchtsik; i ajatnaꞌ i tʼeꞌpidh ajatláb ani yab i ukʼintsik.” ");
INSERT INTO husNT2005_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Pos tsích na Juan, xi yab u kʼapul nibal u uchʼal ani a ulutsik ke in koꞌol i atʼax ejattaláb. ");
INSERT INTO husNT2005_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Tayíl in tsích Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik, xin kʼapul ani in uchʼal ani a ulutsik abal in kʼapmaꞌ ani in uchʼal tʼajat, ke u jaꞌúb i walablomtsik ani xin bachʼwaltsik i jalbixtaláb. Por nin chalpadhtal na Dios u xalkʼanal kʼal xowaꞌ in tʼajál jun xitaꞌ xu dhabaláb kʼal Jajáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Tujey tám kin kʼwiyaꞌ na Jesús an atiklábtsik xon tin tʼajámal más yán an labidh labandhaxtalábtsik, abal an atiklábtsik xu kʼwajíl tajaꞌ, yab in jilámaltsik ti walablom. In ulu enchéꞌ: ");
INSERT INTO husNT2005_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","―¡Chʼojontál a chuꞌbíl, atiklábtsik xi kʼwajíl Korasín! ¡Chʼojontál a chuꞌbíl, atiklábtsik xi kʼwajíl Betsayda! Abal max an labidh labandhaxtaláb xi tʼájnék ba tatáꞌtsik, tʼájnékak ban bitsowtsik xi Tiro ani Sidón, an atiklábtsik xu kʼwajíl tajaꞌ, owenekichak tin jalkʼuyámaltsik nin chalab, in kʼwajbámalichaktsik nin kodhow kʼudhkʼúmil ani buxkanékichaktsik ba kʼwixix abal kin xalkʼaꞌ ke in jilámalichtsik ti walablom. ");
INSERT INTO husNT2005_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Jaxtám tu utsáltsik ke tam kin bajaw xowkʼi neꞌech an lújundhaxtaláb, más púlek an yajtsiktaláb neꞌech ka bachʼutsik ké an yajtsiktaláb xi neꞌech kin bachʼu an atiklábtsik xi Tiro ani Sidón. ");
INSERT INTO husNT2005_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ani tatáꞌtsik xi kʼwajíl Kapernaúm, ¿a chalpayalxeꞌ ke neꞌech ki tʼekʼbá asta walkʼiꞌ? ¡Yabaꞌ! Neꞌech ki petʼnátsik asta ban kʼibeltaláb. Abal max an labidh labandhaxtalábtsik xi tʼájnék ba tatáꞌtsik, tʼájnékak ban bitsow xi Sodoma, an atiklábtsik xi kʼwajinek ba jachanꞌ an bitsow, bélak jeye taꞌ kʼwajattsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Jaxtám tu utsáltsik ke tam kin bajaw xowkʼi neꞌech an lújundhaxtaláb, más púlek an yajtsiktaláb neꞌech ka bachʼutsik ké an atiklábtsik xi kʼwajinek ban bitsow xi Sodoma. ");
INSERT INTO husNT2005_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Tam ti jachanꞌ i kʼij, na Jesús in ulu enchéꞌ: ―Tátaꞌ, xa takʼyal an walkʼiꞌ ani an chabál, tu kʼakʼnál abal a xalkʼantsámal xin chaꞌkáltsik tinbáꞌ xowaꞌ yab a xalkʼantsámal xi chalpadhtsik ani u witʼomtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Tátaꞌ, anchanꞌ ta tʼajaꞌ, kom anchanꞌ ta leꞌnaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","ʼNu Tátaꞌ tin pidhámalich ejtal xowaꞌ waꞌach. Yab xitaꞌ kʼál tu exláb an Chakámláb, tokot kʼal an Tátaꞌláb ani yab xitaꞌ in exlál an Tátaꞌláb, tokot u exláb kʼal an Chakámláb ani xitaꞌ an Chakámláb in léꞌ kin pidhaꞌ kin exlaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ki uteytsik kʼal Nanáꞌ, ejtal tatáꞌtsik xi kʼwajat i walbidh ani neꞌech tu wixkʼintsi an ta walab; jelti jun xitaꞌ xu wékʼontsáb tin kitál abal ka koyóch. ");
INSERT INTO husNT2005_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ki kʼwajaytsik teye jelt xan ti Nanáꞌ in kʼwajat. Ka tʼajaꞌtsik xowaꞌ a chuꞌtal u tʼajál ani ka chaꞌkaꞌ tabáꞌ jelt xan ti Nanáꞌ u chaꞌkál tubáꞌ. Max ka tʼajaꞌtsik anchanꞌ, neꞌech tám ka kʼwajách alwaꞌ na ejattal. ");
INSERT INTO husNT2005_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Pos xowaꞌ Nanáꞌ tu utsáltsik ka tʼajaꞌ, yab tʼojláb ani yab altsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Tam ti jachanꞌ i kʼij, na Jesús neꞌech ti belal tin kʼítsájil an koyóxnich xon ti tʼayadh i trigo. Nin exóbaliltsik kʼaꞌay ani tujeytsik kin puꞌu an trigo ani kin kʼapu. ");
INSERT INTO husNT2005_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Tam ti an fariseotsik in chuꞌu jachanꞌ, in utsaꞌtsik enchéꞌ na Jesús: ―Na exóbaliltsik exom in tʼajál i tʼojláb xi yab alwaꞌ ka tʼajan tam in kʼítsájil i koyóxnich. ");
INSERT INTO husNT2005_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Por utsantsik enchéꞌ kʼal na Jesús: ―¿Yabxeꞌ a ajyámal xantʼéy in tʼajaꞌ jun i kʼij na Dabid tam ti jajáꞌ ani nin juniktsik kʼaꞌay? ");
INSERT INTO husNT2005_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ochich ban pulek atá xon tu kʼakʼnáb na Dios ani in kʼapu an pan xi pikbantsidh na Dios. Jechéꞌ an pan yab in tomnál kin kʼapu na Dabid nibal nin juniktsik, tokot in tomnál kin kʼapu an páleꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","O ¿yab a ajyámaltsik bin takʼixtal na Dios xin jilám dhutsadh na Moisés, ke an páleꞌtsik xi kʼwajat ban pulek atá xon tu kʼakʼnáb na Dios, yab u koyoltsik tam in kʼítsájil an koyóxnich ani yab walats xowaꞌ in tʼajáltsik? ");
INSERT INTO husNT2005_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Pos tu utsáltsik ke techéꞌ kʼwajat jun xitaꞌ más púlek ké an pulek atá xon tu kʼakʼnáb na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Tatáꞌtsik yab a exbayámal xantʼéy in léꞌ kin ulu jechéꞌ an Tʼokat Dhuslab: “Yabich u léꞌ ka chemdhaꞌtsik i koꞌnél abal ti kin pikbantsi, u léꞌ ki kʼánídháxintsik.” Max a exbayalaktsik, yabich neꞌech ka walbiytsik ni jun xitaꞌ xi yab in tʼajámal ni jun xataꞌ yab alwaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Pos Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik, u koꞌol i awiltaláb abal ku ulu xowaꞌ alwaꞌ ka tʼajan tin kʼítsájil an koyóxnich. ");
INSERT INTO husNT2005_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Kale tám na Jesús tajaꞌ ani kʼale ban atá xon tu tʼajnal an junkuntaláb. ");
INSERT INTO husNT2005_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Tajaꞌ, taꞌ ti kʼwajat jun i inik xin koꞌol jun in kʼubak teytemadh ani kom u leꞌnáb ka eltsin jun xataꞌ xantʼokʼál ti ka walbiyat na Jesús, konyat enchéꞌ: ―¿Alwaꞌxeꞌ ka jeldhá jun i yaꞌul tin kʼítsájil i koyóxnich? ");
INSERT INTO husNT2005_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Tókʼoyattsik enchéꞌ kʼal na Jesús: ―¿Jitaꞌ xi tatáꞌtsik a kidhtal, max in koꞌol jun i borrego ani ka balkʼin ba jun i cholax chabál tin kʼítsájil an koyóxnich, yab neꞌech ka kʼale kin jixaꞌ? ");
INSERT INTO husNT2005_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Pos más yán in jalbíl jun i inik ké jun i borrego. Jaxtám, tu utsáltsik ke alwaꞌ ka tʼajan xowaꞌ alwaꞌ tin kʼítsájil an koyóxnich. ");
INSERT INTO husNT2005_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Utsan tám enchéꞌ an inik kʼal na Jesús: ―Ka lujku na kʼubak. Ani tam tin lujku nin kʼubak, jeley, jilkʼon alwaꞌ jelti na jún nin kʼubak. ");
INSERT INTO husNT2005_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Kale tám an fariseotsik ani tujey kin aliy xan ti kin uwaꞌ abal kin ejto kin chemdhaꞌ na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Tam ti na Jesús in choꞌóbnaꞌ jechéꞌ, kʼale ani kʼal yán i atiklábtsik ti wéwná. Na Jesús in jeldhál ejtalkʼi an yaꞌultsik, ");
INSERT INTO husNT2005_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ani in utsáltsik abal yab kin tʼilaꞌtsik xitam jáꞌ jeye Jajáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Jechéꞌ támun anchanꞌ abal ka tʼájan xan tin ulúmal an tʼiltsix Isaías tam tin ulu enchéꞌ: ");
INSERT INTO husNT2005_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Jechéꞌ jaꞌich nu tʼójontsixil, xi Nanáꞌ u takwyámal, xi Nanáꞌ u kʼanidhál ani in kulbél tʼajat kʼal Jajáꞌ. Neꞌech ku kʼwajbaꞌ nu Tʼokat Ejattal ba Jajáꞌ ani neꞌech kin tʼiltsi ejtal an atiklábtsik ke neꞌech ku lújundhaꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Yab neꞌech ti péjéx, nibal neꞌech ti tʼilom kawidh, nibal neꞌech ka axtsin tin káwintal kʼal ni jun xitaꞌ ban béltsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Yab neꞌech kin pejaꞌ nibal elaꞌ jun i maꞌidh pakáb, nibal neꞌech kin tepdhaꞌ an kʼamal xi xowéy tʼajat exom ti letʼkʼonal, asta tam kin bajúch an kʼij xowkʼi Jajáꞌ neꞌech ti takʼix in lujtalkʼi. ");
INSERT INTO husNT2005_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ani ejtal an atiklábtsik neꞌech kin kʼwajbaꞌ nin aytsixtal ba Jajáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Júntsin tám na Jesús jun i jokʼol inik ani móꞌ xi kʼwajat teykómte kʼal jun i atʼax ejattaláb. Jeldhá kʼal na Jesús ani an inik káwin ani chuꞌxin. ");
INSERT INTO husNT2005_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ejtal an atiklábtsik laban ani in ulutsik enchéꞌ: ―¿Awxeꞌ jaꞌich jechéꞌ nin kuxtal na Dabid? ");
INSERT INTO husNT2005_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Por tam ti an fariseotsik in achʼaꞌ jechéꞌ, in ulutsik enchéꞌ: ―Jechéꞌ an inik in káldhál an atʼax ejattalábtsik kʼal tin awiltalkʼi an lej atʼax, nin okʼlékil an atʼax ejattalábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Kom na Jesús in choꞌób xantʼéy na kʼwajat ti chalpantsáb, in utsaꞌtsik enchéꞌ: ―Max jun i bitsow ka kʼéꞌáxin kweneꞌ ti kweneꞌ ani ka péjéxin jajáꞌkʼitsik, neꞌech ka okʼon. Ani max jun i kwentsal o jun i kʼimádh ka kʼéꞌáxin, yab neꞌech ka kʼwajay owat. ");
INSERT INTO husNT2005_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Anchanꞌ jeye, max an lej atʼax kin káldhál tinbáꞌ xi kʼwajat bin ejattal jun i inik, exomich tám in kʼeꞌál tinbáꞌ; max kin tʼajaꞌ anchanꞌ, ¿jan ti neꞌech kin ejto ka kʼwajay owat ti takʼix? ");
INSERT INTO husNT2005_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Tatáꞌtsik a ulal ke Nanáꞌ u káldhál an atʼax ejattalábtsik kʼal tin awiltal an lej atʼax; pos max anchanak, ¿jitaꞌ kʼál tu pidhnal ti awiltaláb xi tatáꞌtsik ti wéwnál abal kin káldhaꞌ an atʼax ejattalábtsik? Jaxtám, jajáꞌtsik ti xalkʼantsal abal i ukʼpinéktsik ta kʼwajat. ");
INSERT INTO husNT2005_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Por Nanáꞌ u káldhál an atʼax ejattalábtsik kʼal tin cháp nin Tʼokat Ejattal na Dios ani jechéꞌ, in léꞌ kin ulu ke xan tu takʼix na Dios ulnekich xon ta kʼwajattsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","ʼPos, ¿jan ti neꞌech kin ejto jun xitaꞌ ka ochich bin kʼimáꞌ jun i likat inik ani kin kʼántsi xowaꞌ in koꞌol, max yab kin wikʼaꞌ okʼox? Tokot neꞌech kin ejto kin kʼántsi xowaꞌ in koꞌol, max kin wikʼaꞌ okʼox. ");
INSERT INTO husNT2005_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","ʼXitaꞌ yab junax kʼal Nanáꞌ, tin atʼál. Ani xitaꞌ yab tin tolmiyal ku utu an atiklábtsik ba na Dios, jachanꞌ, jaꞌich xin tʼajál abal an atiklábtsik yab ka utey ba na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","ʼJaxtám tu utsáltsik, ke an iniktsik neꞌech ka pakwlantsat xowaꞌkichkʼi i walastaláb kin tʼajaꞌ ani xowaꞌkichkʼi i odhbijixtaláb kin ulu; por max kin odhbijiy an Tʼokat Ejattaláb, yab neꞌech ka pakwlantsat. ");
INSERT INTO husNT2005_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Xitaꞌ tin odhbijiy Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik, neꞌech ka pakwlantsat; por xitaꞌ kin odhbijiy an Tʼokat Ejattaláb, yab jaykʼi neꞌech ka pakwlantsat, neꞌech ka jilkʼon walbidh malilíl i kʼij. ");
INSERT INTO husNT2005_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","ʼMax an teꞌ alwaꞌ, alwaꞌ in walíl in kóꞌyal ani max an teꞌ yab alwaꞌ, yab alwaꞌ in walíl in kóꞌyal. Pos an teꞌ, kʼal in walílkʼi tu exláb. ");
INSERT INTO husNT2005_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Tatáꞌtsik a junwal jelti an chan. ¿Janti neꞌech ka ejto ka ulutsik xowaꞌ alwaꞌ, max tatáꞌtsik yab i alwaꞌ? Pos na wiꞌ in ulal xowaꞌ waꞌach ta ejattal. ");
INSERT INTO husNT2005_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","An alwaꞌ inik, in ulal xowaꞌ alwaꞌ, kom alwaꞌ xowaꞌ waꞌach tin ejattal ani an atʼax inik, in ulal xowaꞌ atʼax, kom atʼax xowaꞌ waꞌach tin ejattal. ");
INSERT INTO husNT2005_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Por tu utsáltsik, ke tam kin bajaw xowkʼi neꞌech an lújundhaxtaláb, ejtaltsik neꞌech ka lújundhá kʼal tin kwenta an aniꞌ tʼilab xin ulúmaltsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Pos kʼal xowaꞌkʼi in ulúmal kʼál ti neꞌech ka chuꞌtat max walbidh o yabaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Utsan tám enchéꞌ na Jesús kʼal taltsik i fariseotsik ani kʼal an okʼtsixtsik xin wilál nin takʼixtal na Dios xin jilám dhutsadh na Moisés: ―Okʼtsix, i léꞌ ki chuꞌu ka tʼajaꞌ jun i labidh labandhaxtaláb abal ti exól. ");
INSERT INTO husNT2005_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Tókʼoyattsik enchéꞌ kʼal na Jesús: ―An atiklábtsik xi atʼax ani u walablom, in konyal jun i labidh labandhaxtaláb abal ti exól; por yab neꞌech ka pidhan más ti exól, tokot xan ti támun kʼal an tʼiltsix Jonás. ");
INSERT INTO husNT2005_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Pos anchanꞌ xan ti na Jonás kʼwajay óx a kʼítsá ani óx i akal alkʼidh bin tsukul an yejcheꞌ toꞌol, anchanꞌ neye Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik, neꞌech kin kʼwajay óx a kʼítsá ani óx i akal alkʼidh ban chabál. ");
INSERT INTO husNT2005_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Tam kin bajaw xowkʼi neꞌech an lújundhaxtaláb, an atiklábtsik xi kʼwajinek Nínibe, neꞌech ka ejechtsik ti ít ani neꞌech kin walbiy an atiklábtsik xi jechéꞌ i kʼij. Pos an atiklábtsik xi kʼwajinek Nínibe, in jilaꞌtsik ti walablom tam ti tʼiltsin an tin káwintal na Dios kʼal na Jonás. Ani xoꞌ techéꞌ kʼwajat jun xitaꞌ más púlek ké na Jonás. ");
INSERT INTO husNT2005_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Tam kin bajaw xowkʼi neꞌech an lújundhaxtaláb, an pulek takʼix mímláb xi alál, neꞌech ka ejech ti ít ani neꞌech kin walbiy an atiklábtsik xi jechéꞌ i kʼij. Pos jechéꞌ an mímláb tsích ów chabál abal kin axtsi tin chalpadhtal na Salomón. Ani xoꞌ techéꞌ kʼwajat jun xitaꞌ más púlek ké na Salomón. ");
INSERT INTO husNT2005_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","ʼTam jun i atʼax ejattaláb ka kale ba jun i inik, u xeꞌchinal ban waynek chabáltsik in ayal xon ti ka koyóch; ani max yab kin elaꞌ, in chalpayal enchéꞌ: ");
INSERT INTO husNT2005_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“Neꞌech kin witsiy ban inik xon tin kalnek.” Tam ka witsiy, in elál jachanꞌ an inik jelti jun i atá xi yab kʼwajtsidh, kʼwetodh ani lejkikidh. ");
INSERT INTO husNT2005_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Neꞌech tám juní ka kʼale ani neꞌech kin ikʼiꞌ búk i atʼax ejattalábtsik xi más atʼax ké jajáꞌ ani ejtal neꞌech ka ochichtsik ti kʼwajíl ba jachanꞌ an inik. Jachanꞌ an inik neꞌech tám ka jilkʼon más kʼibenek ké tam ti kʼwajatwiꞌik. Anchanꞌ jeye neꞌech ka támun kʼal jechéꞌ an atiklábtsik xi atʼax. ");
INSERT INTO husNT2005_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Bél kʼwajat ti káw na Jesús kʼal an atiklábtsik, tam ti ulich nin nánaꞌ ani nin kidhábtsik abal in léꞌtsik ti tʼilolól kʼal na Jesús. Kom eléb ti jilkʼontsik, ");
INSERT INTO husNT2005_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","kʼale ti óltsinal na Jesús kʼal jun xitaꞌ ani utsan enchéꞌ: ―Na nánaꞌ ani na kidhábtsik núꞌ kʼwajat eléb ani in léꞌtsik ti tʼilolól kʼal Tatáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Por Jajáꞌ in tókʼoy enchéꞌ xi kʼál ti kʼalnek ti usnal: ―¿Jitam jáꞌ nu nánaꞌ ani jitam jáꞌ nu kidhábtsik? ");
INSERT INTO husNT2005_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","In tsʼútsbiy tám nin exóbaliltsik ani in ulu enchéꞌ: ―Jechéꞌtsik jaꞌich xi kʼwajattsik jelti nu nánaꞌ ani nu kidhábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Pos xitaꞌ in tʼajál xowaꞌ in léꞌ nu Tátaꞌ xi kʼwajat walkʼiꞌ, jachanꞌ, jaꞌich nu kidháb, nu ixám ani nu nánaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Tam ti jachanꞌ i kʼij, na Jesús kale ban atá xon tu tʼajnal an junkuntaláb ani kʼale ti buxkanal bin wál an pujal. ");
INSERT INTO husNT2005_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Kom yán i atiklábtsik junkun xon ti kʼwajat, ochich na Jesús ba jun i tan ani buxkan. Ani ejtal an atiklábtsik jilkʼon bin waltsik an jaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","In okʼtsitsik tám yán xataꞌ kʼal i junbaxtalábkʼi. Enchéꞌ tin utsaꞌtsik: ―Jun i inik kale ti búkʼul iyaláb, ");
INSERT INTO husNT2005_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","tam ti neꞌech an ti búkʼul iyaláb, taltsik an iyaláb kwajlan ba bél, ulich an chʼichintsik ani in kʼapu an iyaláb. ");
INSERT INTO husNT2005_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Taltsik kwajlan ba tʼujublom, xon ti yab lej waꞌach i lukuk ani jachanꞌ an iyalábtsik jikʼat ti ixkʼan abal an chabál yab lej owtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Por tam ti yajbé an kʼakʼal, tsikan ani kom yab ibidh, wayey. ");
INSERT INTO husNT2005_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Taltsik kwajlan ba kʼídhlom, pakey an kʼídhtsik ani paxkʼiyat an tʼayabláb. ");
INSERT INTO husNT2005_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Por wéꞌ an iyaláb, kwajlan ban chabál xi alwaꞌ ani labey tʼajat; taltsik, kʼal jún tokot i itsixlek, in kóꞌoy boꞌ inik i itsixlek. Taltsik ox inik i itsixlek ani taltsik jun inik láju i itsixlek. ");
INSERT INTO husNT2005_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Max a koꞌoltsik a ochʼoxtal alwaꞌ, ¡ka exbaytsik! ");
INSERT INTO husNT2005_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Utukná tám na Jesús kʼal an exóbaltsik ani konyat enchéꞌ: ―¿Jantʼókʼi ta tawnál an atiklábtsik kʼal i junbaxtalábkʼi? ");
INSERT INTO husNT2005_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Tókʼoyattsik enchéꞌ: ―Tatáꞌtsik, ti pidhál na Dios ka choꞌóbnaꞌ xowaꞌ in koꞌol yab tejwaꞌ kʼal tin kwenta xan ti Jajáꞌ tu takʼix; por jajáꞌtsik yab u pidhnal kin choꞌóbnaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Xitaꞌ xin bachʼúmalich an alwaꞌ tʼilab, neꞌech ka pidhan kin choꞌóbnaꞌ más; por xitaꞌ xi yab in bachʼúmal, neꞌech ka wixkʼintsat xowaꞌ in chalpayal in koꞌol wéꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Jaxtám tu tawnáltsik kʼal i junbaxtalábkʼi; pos jajáꞌtsik in chuꞌtal, por u jilkʼonaltsik jelti max yab xataꞌ in chuꞌúmal; in achʼáltsik, por yabtsik xataꞌ in exbayal, jelti max yab xataꞌ in achʼáltsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Anchanꞌ, u támnalich kʼal jajáꞌtsik jelt xan tin ulúmal an tʼiltsix Isaías enchéꞌ: Neꞌech ka achʼaꞌtsik, por yab neꞌech ka exbay; neꞌech ka chuꞌutsik, por jelti max yab a chuꞌtal. ");
INSERT INTO husNT2005_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Abal nin itsích jechéꞌ an atiklábtsik in chapikmédhámal tʼajat, wetsik tʼajat tin achʼáltsik kʼal nin ochʼoxtal. Ani mutʼutsik tin koꞌol nin wal; abal yab ka chuꞌxintsik kʼal nin wal, ani yab ka ochʼxintsik kʼal nin ochʼoxtal, nibal kin exbaytsik kʼal nin itsích, ani nibal ka uteytsik kʼal Nanáꞌ abal ku jeldhaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","ʼPor kʼijidh abal tatáꞌtsik, abal i chuꞌuxtsik ani i ochʼoxtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Tsubax tu utsáltsik, ke yán i tʼiltsix ani i alwaꞌ iniktsik in leꞌnámal kin chuꞌu xowaꞌ tatáꞌtsik a chuꞌtal, por yab in chuꞌúmaltsik; in leꞌnámaltsik kin achʼaꞌ xowaꞌ tatáꞌtsik a achʼál, por yab in achʼámal. ");
INSERT INTO husNT2005_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","ʼPos ka achʼaꞌtsik xantʼéy in léꞌ kin ulu an junbaxtaláb kʼal tin kwenta an óm inik. ");
INSERT INTO husNT2005_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Taltsik an atiklábtsik in achʼál an tsubaxtaláb kʼal tin kwenta xan tu takʼix na Dios, por kom yabtsik in exbayal, u ulel an lej atʼax ani u wékʼontsáb an ti tsubaxtaláb xin bachʼúmal tin itsích. Jechéꞌ an atiklábtsik in junwal jelti an iyalábtsik xi kwajlan ban bél. ");
INSERT INTO husNT2005_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Taltsik an atiklábtsik, tam kin achʼaꞌ an tsubaxtaláb in bachʼwal kʼal yantam i kulbétaláb, por tam ka taktamiyat o ka atʼan kʼal tin kwenta jechéꞌ an tsubaxtaláb, in jiláltsik jechéꞌ an tsubaxtaláb. ");
INSERT INTO husNT2005_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Jechéꞌ an atiklábtsik in junwal jelti an iyaláb xi kwajlan ban tʼujublom, kom yab owtsik nin ibíl tin koꞌol, yab u owel. Pos tam kin achʼaꞌ i yajtsiktaláb o ka atʼan kʼal tin kwenta abal in belámal nin káwintal na Dios, in jiláltsik kin belaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Taltsik an atiklábtsik in achʼál an tsubaxtaláb, por u chalpaxtsik tʼajat kʼal tin kwenta xowaꞌ waꞌach ban kʼayꞌlá, u kʼambiyábtsik kʼal an tumín ani yabtsik u walkanal kin tʼajaꞌ kʼál xowaꞌ alwaꞌ. Jechéꞌ an atiklábtsik in junwal jelti an iyaláb xi kwajlan ban kʼídhlom, u paxkʼiyáb kʼal an kʼídh ani yab u walkanal ka walin. ");
INSERT INTO husNT2005_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Taltsik an atiklábtsik xin achʼál an tsubaxtaláb, in exbayal ani in tʼajáltsik tʼajat xowaꞌ alwaꞌ, in junwal jelti an iyaláb xi kwajlan ban alwaꞌ chabál ani labey tʼajat. Taltsik in junwal jelti an itsixlek xin kóꞌoy boꞌ inik i itsixlek, taltsik jelti xin kóꞌoy ox inik láju ani taltsik jelti xin kóꞌoy jun inik láju. ");
INSERT INTO husNT2005_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Tʼiltsintsik jeye kʼal na Jesús jechéꞌ an ti junbaxtaláb: ―Xan tu takʼix na Dios, in junwal jelti jun i inik xin tʼayaꞌ i alwaꞌ iyaláb bin ale; ");
INSERT INTO husNT2005_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","por tam ti ejtalich u wayaltsik, ulich jun xitaꞌ xi kʼál tu atʼnal an dhabal ani tʼaytsin ti atʼax chʼojól xon tin tʼayámal an trigo ani tam tin tʼayámalich, kʼale. ");
INSERT INTO husNT2005_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Tam ti pakey an trigo ani tʼuꞌunich, xalkʼan jeye an atʼax chʼojól. ");
INSERT INTO husNT2005_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Kʼaletsik tám an tʼojnaltsik kin utsaꞌ enchéꞌ an dhabal: “Ajátik, max i alwaꞌ iyaláb a tʼayámal ba na ale, ¿jónꞌ pé tám ti tsiꞌnek an atʼax chʼojól?” ");
INSERT INTO husNT2005_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Utsantsik enchéꞌ kʼal an dhabal: “Jun xitaꞌ xi tin atʼál in tʼajámal jechéꞌ.” Konyat tám enchéꞌ kʼal an tʼojnaltsik: “¿A léꞌxeꞌ ku kʼale ki puꞌu an atʼax chʼojól?” ");
INSERT INTO husNT2005_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Por utsantsik enchéꞌ: “Yabaꞌ, pos max ka puꞌu an atʼax chʼojól, neꞌech jeye ka púꞌun an trigo. ");
INSERT INTO husNT2005_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Jilaꞌ ka pakey chablamkʼi asta kin bajaw xowkʼi ti neꞌech ki junku an trigo; tam neꞌech ki junkúch an trigo, neꞌech ku utsaꞌ enchéꞌ an tʼojnaltsik: Ka junku okʼox an atʼax chʼojól ani ka kʼwajbaꞌ ti wikʼeꞌtsik abal ka tsikan; por an trigo ka junku abal ka taꞌpá ban wilteꞌ.” ");
INSERT INTO husNT2005_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Tʼiltsintsik jeye jechéꞌ an ti junbaxtaláb: ―Xan tu takʼix na Dios in junwal jelti jun in itsích i mostasa xi jun i inik in tʼayál bin ale. ");
INSERT INTO husNT2005_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Jechéꞌ jaꞌich an iyaláb xi más chipíl ké xi kʼeꞌet an iyalábtsik, por tam ka ixkʼan ani ka pubey, u pubel tʼajat ké xi kʼeꞌet an tʼayablábtsik ani u kʼweꞌnal tʼajat. U ulel an chʼichintsik ani in tʼajál tajaꞌ nin pákʼw. ");
INSERT INTO husNT2005_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Tʼiltsintsik jeye jechéꞌ an ti junbaxtaláb: ―Xan tu takʼix na Dios in junwal jelti an jilbédhaxtaláb kʼoye xi jun i mímláb in xukʼyal kʼal ox lejab i cheꞌedh trigo ani in jilbédhál ejtal an xoꞌkadh cheꞌedh trigo. ");
INSERT INTO husNT2005_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Na Jesús in tʼiltsi ejtal jechéꞌ an atiklábtsik kʼal i junbaxtalábkʼi, yab in tʼilaꞌ xataꞌ xi yab kʼal i junbaxtaláb. ");
INSERT INTO husNT2005_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Jechéꞌ támun anchanꞌ abal ka tʼájan xan tin ulúmal enchéꞌ an tʼiltsix: Neꞌech tin káw kʼal i junbaxtalábkʼi, neꞌech ku tʼilaꞌ xataꞌ xowaꞌ kʼwajinek chinat asta tam ti na Dios in tʼajám an kʼayꞌlá. ");
INSERT INTO husNT2005_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Tam ti na Jesús in utsaꞌich an atiklábtsik abal ka kʼaléch, Jajáꞌ ochich altá. Utukná tám kʼal nin exóbaliltsik ani utsan enchéꞌ: ―Ti ku wiltsi an ti junbaxtaláb kʼal tin kwenta an atʼax chʼojól xi tʼayan ban aleláb. ");
INSERT INTO husNT2005_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Tókʼoyattsik tám enchéꞌ kʼal na Jesús: ―Xitaꞌ nin tʼayál an alwaꞌ iyaláb, jaꞌich Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik. ");
INSERT INTO husNT2005_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","An aleláb, jaꞌich an kʼayꞌlá; an alwaꞌ iyaláb, jaꞌich an atiklábtsik xin walkál tinbáꞌ ka takʼyat kʼal na Dios ani an atʼax chʼojól, jaꞌich an atiklábtsik xu dhabaláb kʼal an lej atʼax. ");
INSERT INTO husNT2005_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Xitaꞌ nin tʼayaꞌ an atʼax chʼojól, jaꞌich an lej atʼax. Xowkʼi ti neꞌech ka junkuwat an trigo, jaꞌich an pakwenib; ani an junkuxtsik, jaꞌich an tʼokat abatwáletsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Anchanꞌ jelt xan tu junkuwáb an atʼax chʼojól ani u petʼnáb ban kʼamal abal ka tʼaꞌay, anchanꞌ jeye neꞌech ka támun tam kin bajaw an pakwenib. ");
INSERT INTO husNT2005_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Xi Nanáꞌich xin abadh abal kin wenkʼon neye tin inik, neꞌech ku abaꞌ nu tʼokat abatwálejiltsik kin junku xi kʼwajattsik xon ti Nanáꞌ in takʼix, xu walbindhaxtsik ani xin tʼajáltsik xowaꞌ yab alwaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Neꞌech ka petʼnátsik ban kʼamal, neꞌech ti ukʼnaltsik ani ti rechʼechʼél nin kamab. ");
INSERT INTO husNT2005_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Jachanꞌ i kʼij, xi kʼwajatichtsik alwaꞌ kʼal na Dios, neꞌech ka kʼwajaytsik xon tu takʼix an Tátaꞌláb; neꞌech ka xalkʼantsik chʼaxixíl, jelti nin chʼaxixíltal na kʼítsá. Xitaꞌ in koꞌol in ochʼoxtal alwaꞌ, kin achʼaꞌ xowaꞌ u ulal. ");
INSERT INTO husNT2005_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","ʼXan tu takʼix na Dios, in junwal jelti tumín xi jolidh ba jun i aleláb, xi jun i inik in elál ani in chinál juní táykʼi; ani kulbenek kʼal jechéꞌ tin kwenta, u kʼalel kin nuju ejtal xowaꞌ in koꞌol ani in chʼaꞌyal jachanꞌ an chabál. ");
INSERT INTO husNT2005_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","ʼAníl jeye, xan tu takʼix na Dios in junwal jelti jun i chʼaꞌum inik xi xeꞌech in ayal i perlatsik xi alwaꞌ tʼajat. ");
INSERT INTO husNT2005_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Tam tin elaꞌ jun i perla xi kajbidh tʼajat in jalbíl, kʼale kin nuju ejtal xowaꞌ in koꞌol ani in chʼaꞌay jachanꞌ an perla xi kajbidh tʼajat in jalbíl. ");
INSERT INTO husNT2005_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","ʼAníl jeye, xan tu takʼix na Dios in junwal jelti jun in jixáb i toꞌol xu petʼnáb ban pujal ani in yakʼwál xowaꞌkich i toꞌoltsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Tam ka yákʼwanich yán an toꞌoltsik, an jixom toꞌoltsik in káldhál walteꞌ nin jixáb an toꞌol. Tajaꞌ u buxkanaltsik ti tákul an ti toꞌol, xi alwaꞌ in balyal ban tʼoknaltsik ani xi yab alwaꞌ in petʼnál. ");
INSERT INTO husNT2005_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Anchanꞌ jeye neꞌech ka támun tam kin bajaw an pakwenib; neꞌech ka kale an tʼokat abatwáletsik kin takuy an atiklábtsik xi atʼax ani xi alwaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Xi atʼaxtsik neꞌech ka petʼná ban kʼamal, tajaꞌ neꞌech ti ukʼnaltsik ani ti rechʼechʼél nin kamab. ");
INSERT INTO husNT2005_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Konyattsik tám enchéꞌ kʼal na Jesús: ―¿A exbayaltsikxeꞌ ejtal jechéꞌ? Jajáꞌtsik tókʼon enchéꞌ: ―I exbayal, Ajátik. ");
INSERT INTO husNT2005_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Utsantsik tám enchéꞌ: ―Tam jun i okʼtsix xin exlál nin takʼixtal na Dios xin jilám dhutsadh na Moisés, kin exlaꞌ jeye xan tu takʼix na Dios, in junwal jelti jun xitaꞌ xin koꞌol xataꞌ kajbidh in jalbíl. ");
INSERT INTO husNT2005_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Tam ti na Jesús in okʼoy kin tʼilaꞌ jechéꞌ an junbaxtalábtsik, kʼale. ");
INSERT INTO husNT2005_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ulich bin chabálil ani in tuju ti okʼtsix ban atá xon tu tʼajnal an junkuntaláb. Ejtal xin achʼáltsik xan tu okʼtsix, u labnal ani in ulaltsik enchéꞌ: ―¿Jónꞌ tin witʼámal jechéꞌ an inik ejtal jechéꞌ xowaꞌ in okʼtsixnál? ¿Jan tin ejtowal kin tʼajaꞌ jechéꞌ an labidh labandhaxtaláb? ");
INSERT INTO husNT2005_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Pos jechéꞌ jaꞌich nin chakámil an dhakúm ani nin nánaꞌ jaꞌich na María. In kidháb na Jakobo, na José, na Simón ani na Judas ");
INSERT INTO husNT2005_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","ani nin ixámtsik techéꞌ jeye u kʼwajíl xon ti wawáꞌ u kʼwajíl. ¿Pos, jónꞌ pé tám tin witʼámal ejtal jechéꞌ? ");
INSERT INTO husNT2005_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Jaxtám ti yab leꞌná ka tʼajan ti kʼij. Por utsantsik enchéꞌ kʼal na Jesús: ―Putálkʼi tu kʼakʼnáb jun i tʼiltsix, tokotkʼi bin chabálil ani kʼal xu kʼwajíltsik bin kʼimáꞌ ti yab u kʼakʼnáb. ");
INSERT INTO husNT2005_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ani yab in tʼajaꞌ yán i labidh labandhaxtaláb tajaꞌ, kom yab u belnal kʼal jajáꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Tam ti jachanꞌ i kʼij, na Erodes, xi kʼwajat ti takʼix Galilea, in achʼaꞌ u tʼilnal na Jesús ");
INSERT INTO husNT2005_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ani in utsaꞌtsik enchéꞌ xi táꞌtsik ti kʼwajat kʼal jajáꞌ: ―Jachanꞌ jaꞌich xónaꞌ na Juan xu pujax, xi ejnek ti ít. Jaxtám tin koꞌol an chápláb kin tʼajaꞌ i labidh labandhaxtalábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Jechéꞌ na Erodes in ulúmal ka yakʼwan na Juan ani ka balyat wikʼadh ban wikʼaxteꞌ. In tʼajaꞌ anchanꞌ kʼal tin kwentakʼi na Erodías, nin tomtal nin kidháb Felipe. ");
INSERT INTO husNT2005_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Na Juan in utsámal enchéꞌ na Erodes: ―Yab alwaꞌ ki junkun kʼal nin tomtal na kidháb. ");
INSERT INTO husNT2005_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Na Erodes in léꞌ kin chemdhaꞌ na Juan, por in jikʼnál an atiklábtsik abal ejtal in choꞌóbtsik ke na Juan kʼal a Dios ti abadh ti tʼiltsix. ");
INSERT INTO husNT2005_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Por tam ti na Erodes in ajíbnaꞌ nin tamúbil, nin tsidhánil na Erodías bixmách tin tamét an ajíblomtsik ani in kulbetnaꞌ tʼajat na Erodes ");
INSERT INTO husNT2005_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ke in utsaꞌ tsubax tʼajat ke neꞌech kin pidhaꞌ xowaꞌ ka kontsin. ");
INSERT INTO husNT2005_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Utsan tám an tsidhan kʼal nin nánaꞌ abal kin utsaꞌ enchéꞌ na Erodes: ―Ti kin pidhaꞌ ba jun i talab nin ókʼ na Juan xu pujax. ");
INSERT INTO husNT2005_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Tam ti an pulek takʼix Erodes in achʼaꞌ jechéꞌ, tʼeꞌpin; por kom in lej tsubax ulúmal ani axnék kʼal an ajíblomtsik, in ulu abal ka pidhan xowaꞌ in konyal. ");
INSERT INTO husNT2005_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","In ulu ka kotsin tin ókʼ na Juan ban wikʼaxteꞌ ");
INSERT INTO husNT2005_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","ani tám ti tsiꞌdhá ba jun i talab. Pidhanich tám an tsidhan ani an tsidhan in pidhaꞌ nin nánaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ulich tám nin exóbaliltsik na Juan ani in júnaꞌtsik kin joliy nin putálíl nin tʼuꞌúl na Juan ani tayíl kʼaletsik kin óltsi na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Tam ti na Jesús in choꞌóbnaꞌ jechéꞌ, balin kwetém ba jun i tan ani kʼale ba jun i chabál xon ti yab xitaꞌ waꞌach. Por an atiklábtsik in choꞌóbnaꞌ abal kʼale na Jesús ani kʼaletsik jeye belal abal kin wéwnaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Tam ti na Jesús kale ban tan, in chuꞌu abal yán an atiklábtsik taꞌ ti kʼwajat, in kóꞌontsitsik ti yajnantsixtaláb ani in jeldhaꞌ xu yaꞌultsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Tam ti exomich ti jikʼwchinal, utey an exóbaltsik ba na Jesús ani in utsaꞌ enchéꞌ: ―Dhamúlich ani techéꞌ yab xitaꞌ u kʼwajíl. Ka utsaꞌ an atiklábtsik ka kʼaléch abal ka kʼale ban kwentsaltsik kin chʼaꞌay i kʼapnél. ");
INSERT INTO husNT2005_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Utsantsik enchéꞌ kʼal na Jesús: ―Yab yejat ka kʼaletsik; tatáꞌtsik ka kʼapundhaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Jajáꞌtsik tókʼon enchéꞌ: ―Yab i koꞌol techéꞌ yán i kʼapnél, tokot bóꞌ i pan ani cháb i toꞌol. ");
INSERT INTO husNT2005_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Utsantsik enchéꞌ kʼal na Jesús: ―Ka tsiꞌdhaꞌ techéꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","In utsaꞌ tám an atiklábtsik ka buxkan ban tóm. In téynaꞌ xi bóꞌ an pan ani xi cháb an toꞌol, in telaꞌ walkʼiꞌ, in pidhaꞌ ti jalbintsixtaláb na Dios. In pejaꞌ tám an pan ani in pidhaꞌ nin exóbaliltsik ani jajáꞌtsik in pidhaꞌich tám an atiklábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ejtal kʼapúchtsik asta ajwé ani tayíl in tsʼutsiytsik lajucháb i tʼoknal kʼal an pejmatstaláb xi jilkʼon. ");
INSERT INTO husNT2005_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Boꞌ mil iniktsik xónaꞌ xi kʼapúch, yab ajidh i mímlábtsik nibal i chakamtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Tayíl, na Jesús in utsaꞌ nin exóbaliltsik ka balin ban tan abal ka okxinichtsik ka watʼey ban pujal ani ka kʼale jun pakʼeꞌ, lejat Jajáꞌ kʼwajat in chapnédhál an atiklábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Tam ti okʼon kin chapnédhaꞌ an atiklábtsik, na Jesús kʼadhiy ba jun i chʼén abal ti ól kwetém. Tam ti jikʼwchinich, na Jesús tajaꞌ ti kʼwajat kwetém, ");
INSERT INTO husNT2005_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","lejat an tan junax chʼejel pujalich ti neꞌech. U lanyáb an tan kʼal an múlákʼ jaꞌ abal tin tamét tu wawꞌyáb kʼal an ikʼ. ");
INSERT INTO husNT2005_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Tam ti dhajaw akalich, utuknátsik kʼal na Jesús. Por na Jesús tál belal ebtsik an jaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Tam ti chuꞌtat kʼal an exóbaltsik ti belal ebtsik an jaꞌ, jikʼeytsik ani kʼal an jíkʼib, dhájantsik kawidh enchéꞌ: ―¡I labax! ");
INSERT INTO husNT2005_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Por tawnátsik kʼal na Jesús ani utsantsik enchéꞌ: ―¡Ka likedhaꞌtsik tabáꞌ; Nanáꞌ, yab ki jikʼeytsik! ");
INSERT INTO husNT2005_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Tókʼoyat tám kʼal na Pedro ani utsan enchéꞌ: ―Ajátik, max Tatáꞌ lejtal, ti kin utsaꞌ neye kin beley ebtsik an jaꞌ ani kin ulich asta xon ta kʼwajat. ");
INSERT INTO husNT2005_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ani utsan enchéꞌ kʼal na Jesús: ―Jalaꞌich. Paꞌay tám ban tan na Pedro ani in tuju ti belal ebtsik an jaꞌ abal ka kʼale xon ti kʼwajat na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Por tam tin achʼaꞌ abal chapik u wawꞌnal an ikʼ, jikʼey; ani kom tujey ti luyꞌchinal, dhájan kawidh enchéꞌ: ―¡Ajátik, ti kin loꞌo! ");
INSERT INTO husNT2005_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Támkʼi jachanꞌ, téyná bin kʼubak kʼal na Jesús ani utsan enchéꞌ: ―¡Wéꞌ tʼajat ta belom! ¿Jantʼókʼi ta jilaꞌ tin belaꞌ? ");
INSERT INTO husNT2005_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Tam ti kʼadhíchtsik ban tan, kublan ti wawꞌnal an ikʼ. ");
INSERT INTO husNT2005_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Tam tin chuꞌutsik jechéꞌ xi táꞌtsik ti kʼwajat ban tan, uteytsik tin tamét na Jesús ani in kʼakʼnaꞌtsik enchéꞌ: ―Tsubax lejtal i Chakámláb kʼal a Dios. ");
INSERT INTO husNT2005_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Tam tin watʼnaꞌichtsik an pujal, ulich ban chabál xi Jenesaret. ");
INSERT INTO husNT2005_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Tam ti exlá na Jesús kʼal an atiklábtsik xu kʼwajíltsik tajaꞌ, tʼilan ba putálkʼi jachanꞌ an chabál ani tsiꞌdhantsat ejtal an ti yaꞌultsik xon ti Jajáꞌ kʼwajat. ");
INSERT INTO husNT2005_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","U pakabédháb abal kin walkaꞌ ka taktsin tin waltsik nin kʼudhkʼúmil ani ejtal xitaꞌ kʼál tu taknal, u jeléltsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Utukná tám na Jesús kʼal taltsik i fariseotsik ani i okʼtsixtsik xin wilál nin takʼixtal na Dios xin jilám dhutsadh na Moisés. Jechéꞌtsik tál ban bitsow Jerusalén ani konoxintsik enchéꞌ: ");
INSERT INTO husNT2005_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―¿Jantʼókʼi na exóbaliltsik ti yabich in tʼajál xowaꞌ u jiltsidh ki tʼajaꞌ kʼal ni wejeꞌ pakélil? Pos yabtsik in tʼakál okʼox nin kʼubak tam neꞌech ti kʼapultsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Por tókʼoyattsik enchéꞌ kʼal na Jesús: ―¿Ani jantʼókʼi teye ta chʼikat tʼajtsaltsik tin takʼixtal na Dios, abal a óntsal ka tʼajaꞌ xowaꞌ i jiltsidh ka tʼajaꞌ kʼal na wejeꞌ pakéliltsik? ");
INSERT INTO husNT2005_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Pos na Dios in ulúmal enchéꞌ: “Ka kʼakʼnaꞌ na tátaꞌ ani na nánaꞌ” ani “Xitaꞌ kin odhbijiy nin tátaꞌ ani nin nánaꞌ, yejat ka chemdhá.” ");
INSERT INTO husNT2005_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Por tatáꞌtsik a ulal ke jun xitaꞌ awil kin utsaꞌ enchéꞌ nin tátaꞌ o nin nánaꞌ: “Yabich neꞌech ku ejto tu tolmiy, pos ejtal xowaꞌ u koꞌol u pikbantsámalich a Dios”; ");
INSERT INTO husNT2005_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ani ke xitaꞌ kin ulu anchanꞌ, yabich yejat kin tolmiy nin tátaꞌ o nin nánaꞌ. Anchanꞌ, a tʼajálichtsik jelti max yab xataꞌ in jalbíl nin takʼixtal na Dios abal a óntsal ka tʼajaꞌ xowaꞌ i jiltsidh ka tʼajaꞌ kʼal na wejeꞌ pakéliltsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Kʼambixtsik! Tsubax tʼajat tin ulu an tʼiltsix Isaías kʼal tatáꞌtsik ta kwenta, tam tin dhutsaꞌ enchéꞌ: ");
INSERT INTO husNT2005_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Jechéꞌ an atiklábtsik kʼal in wiꞌkʼi tin kʼakʼnáltsik, por nin ejattal ów tʼajat ti kʼwajat kʼal Nanáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Yab xataꞌ in jalbíl xan tin kʼakʼnáltsik, pos tokot in okʼtsixnáltsik in takʼixtal i iniktsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","In kaniy tám an atiklábtsik ka utey xon ti Jajáꞌ kʼwajat ani in utsaꞌtsik enchéꞌ: ―Ka achʼaꞌtsik ani ka exbaytsik: ");
INSERT INTO husNT2005_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Yab u chʼóꞌnal nin ejattal an inik kʼal xowaꞌ in kʼapal. U chʼóꞌnal kʼal xowaꞌ in ulal. ");
INSERT INTO husNT2005_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Utukná tám na Jesús kʼal nin exóbaliltsik ani utsan enchéꞌ: ―¿A choꞌóbxeꞌ ke an fariseotsik chakuy tam tin achʼaꞌtsik xowaꞌ a ulu? ");
INSERT INTO husNT2005_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Por Jajáꞌ in tókʼoytsik enchéꞌ: ―Xowaꞌkich an tʼayabláb xi yab Jajáꞌ in tʼayámal nu Tátaꞌ xi kʼwajat walkʼiꞌ, neꞌech ka puꞌwat asta bin ibíl. ");
INSERT INTO husNT2005_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Jilaꞌ kʼwajat, pos in junwal i jokʼoltsik xi kʼwajat in lotʼokʼnál in at jokʼol. Ani max jun i jokʼol kin lotʼokʼnaꞌ in at jokʼol, chablam ti éb neꞌech ka kwajlan ban jól. ");
INSERT INTO husNT2005_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Utsan tám enchéꞌ na Jesús kʼal na Pedro: ―Ti ku wiltsi jechéꞌ an ti junbaxtaláb. ");
INSERT INTO husNT2005_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","In ulu tám enchéꞌ na Jesús: ―¿Yabtsik teye a exbayal? ");
INSERT INTO husNT2005_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Yabxeꞌ a choꞌóbtsik ke ejtal xowaꞌ i kʼapal u kʼalel ba ni tsukul ani tayíl neꞌech ki wakʼlaꞌ alteꞌ? ");
INSERT INTO husNT2005_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Por xowaꞌ i ulal, ba ni itsích tu tsiꞌil ani max ki ulu xowaꞌ yab alwaꞌ, kʼál tu chʼoꞌtsinal an ti ejattal. ");
INSERT INTO husNT2005_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Pos ba ni itsích tu kalel an atʼax chalab, an chémdháxtaláb, an kwéꞌtaláb, an kʼámbíxtaláb ani an odhbíjíxtaláb. Táykʼi jeye tu tsiꞌil an chalab xu junkunal kʼal xi yab in tomtal ani xu xeꞌchinaltsik yab exbadh. ");
INSERT INTO husNT2005_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ejtal jechéꞌ kʼál tu chʼoꞌtsinal tin ejattal an inik; por max ka kʼapúch yab tʼakadh nin kʼubak, yab u chʼoꞌtsinal kʼál tin ejattal. ");
INSERT INTO husNT2005_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Na Jesús kale tajaꞌ ani kʼale ban chabál xi Tiro ani Sidón. ");
INSERT INTO husNT2005_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ani jun i mímláb xi Kanán xu kʼwajíl ba jachanꞌ an chabál, utey ba na Jesús ani in ulu kawidh enchéꞌ: ―¡Ajátik, xi kuxlab kʼal na Dabid, ti kin yajnantsi neye! Nu tsidhánil ochadh kʼal jun i atʼax ejattaláb ani exom tʼajat ti yajlombédháb. ");
INSERT INTO husNT2005_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Por yab tókʼoyat níwéꞌ kʼal na Jesús. Utukná tám na Jesús kʼal nin exóbaliltsik ani pakabédhá enchéꞌ: ―Ka utsaꞌ ka kʼaléch, pos núꞌ tál tu wewkóm ani kawidh u tawnax. ");
INSERT INTO husNT2005_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","In ulu tám enchéꞌ na Jesús: ―Na Dios tin abámal abal tokot ku aliy an atiklábtsik xi Israel xi xeꞌechtsik kʼibchonék. ");
INSERT INTO husNT2005_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Por an mímláb utey, tudhlan tin tamét na Jesús ani in ulu enchéꞌ: ―¡Ajátik, ti kin tolmiy neye! ");
INSERT INTO husNT2005_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Tókʼoyat enchéꞌ kʼal na Jesús: ―Yab alwaꞌ ki kʼántsi ti kʼapnél an chakamtsik ani ki pidhaꞌ an pikʼoꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Por an mímláb in ulu enchéꞌ: ―Tsubax kʼejle xowaꞌ a ulal Ajátik, por asta an pikʼoꞌtsik in kʼapal in muꞌmats an kʼapnél xu kwajlanal tin ál nin mesajil nin ajátiktsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Utsan tám enchéꞌ kʼal na Jesús: ―¡Mímláb, tin belál tʼajat! Ka tʼájan jelt xan ta léꞌ. Ani támkʼi jachanꞌ ti jilkʼon jelnek nin tsidhánil. ");
INSERT INTO husNT2005_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Watʼey na Jesús tajaꞌ ani kʼale tin waltsik an pujal xi Galilea; kʼadhiy ba jun i chʼén ani buxkan tajaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Yán i atiklábtsik ulich xon ti Jajáꞌ kʼwajat ani in tsiꞌdháltsik i kʼwechʼeꞌtsik, i jokʼoltsik, i móꞌtsik, i mochoꞌtsik ani yán más kʼeꞌet i yaꞌultsik. Kʼwajbátsik tin tamét na Jesús ani Jajáꞌ in jeldhaꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","An atiklábtsik u labnal tam tin chuꞌu ke an móꞌ káwin, xi mochoꞌtsik u jelél, xu kʼwechʼeꞌtsik u belal ani xu jokʼoltsik u chuꞌxinal. Ani in kʼakʼnaꞌtsik nin Diosil an israelitatsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Na Jesús in kaniy tám nin exóbaliltsik ani in utsaꞌtsik enchéꞌ: ―U yajnantsal tʼajat jechéꞌ an atiklábtsik, abal in koꞌolich óx a kʼítsá ti kʼwajíl techéꞌ kʼal Nanáꞌ ani yab in koꞌoltsik xantʼéy kin kʼapu. Yab u léꞌ ku abaꞌtsik tin kʼimáꞌ u kʼaꞌíl abal yab táꞌ ka palmétsik ti bél. ");
INSERT INTO husNT2005_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Utsan tám enchéꞌ kʼal nin exóbaliltsik: ―Por, ¿jónꞌ neꞌech ki elaꞌ i kʼapnél abal ejtal jechéꞌ an atiklábtsik, techéꞌ xon ti yab xitaꞌ u kʼwajíl? ");
INSERT INTO husNT2005_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Konyattsik enchéꞌ kʼal na Jesús: ―¿Jáy i pan a koꞌoltsik? Ani jajáꞌtsik in ulu enchéꞌ: ―I koꞌol búk i pan ani cháb óx i tsʼitsik toꞌol. ");
INSERT INTO husNT2005_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","In utsaꞌ tám ka buxkan chabál an atiklábtsik, ");
INSERT INTO husNT2005_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","in téynaꞌ xi búk an pan ani an toꞌoltsik ani in pidhaꞌ ti jalbintsixtaláb na Dios. Tayíl in pejaꞌ, in pidhaꞌ nin exóbaliltsik ani an exóbaltsik in pidhaꞌ an atiklábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ejtal kʼapúchtsik asta ajwé. Ani tayíl in tsʼutsiytsik búk i tʼoknal kʼal an pejmatstaláb xi jilkʼon. ");
INSERT INTO husNT2005_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Cheꞌ mil iniktsik xónaꞌ xi kʼapúch ani yab ajidh i mímlábtsik nibal i chakamtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Tayíl, na Jesús in abaꞌich tám ka kʼale an atiklábtsik. Na Jesús balin ban tan ani kʼale ban chabál xi Magdala. ");
INSERT INTO husNT2005_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Kʼale ti chuꞌtáb na Jesús kʼal i fariseotsik ani kʼal i saduseotsik, ani abal ka walbindhá, kontsin kin tʼajaꞌ jun i labidh labandhaxtaláb abal kin xalkʼaꞌ ke tsubax lejtal kʼal a Dios ti abadh. ");
INSERT INTO husNT2005_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Por na Jesús tókʼon enchéꞌ: ―Tam dhamúlich, a ulaltsik: “Alwaꞌ i kʼij neꞌech ka kʼwajay, abal chakniꞌ tʼajat an walkʼiꞌ”; ");
INSERT INTO husNT2005_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","ani tam dhajaw a ulaltsik: “Xoꞌ yab alwaꞌ i kʼij neꞌech ka kʼwajay, abal chakniꞌ tʼajat an walkʼiꞌ ani tokwidh.” ¡Kʼambixtsik! A witʼáltsik ka exbantsi an exól xin kʼwajbál an walkʼiꞌ, por yab a witʼáltsik ka exbay ke xowaꞌ u tʼajál, u tʼajál kʼal tin cháp na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Jechéꞌ an atiklábtsik xi atʼax ani u walablom, in konyal jun i labidh labandhaxtaláb abal ti exól; por yab neꞌech ka pidhan ti exól, tokot xowaꞌ támun kʼal an tʼiltsix Jonás. Jilónátsik tám ani kʼale na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","An exóbaltsik watʼey jun pakʼeꞌ pujal, por in ukʼtsámaltsik kin júnaꞌ i pan. ");
INSERT INTO husNT2005_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Utsantsik tám enchéꞌ kʼal na Jesús: ―Ka achʼaꞌtsik; ka kóꞌoytsik i kwenta kʼal nin okʼtsixtal an fariseotsik ani kʼal nin okʼtsixtal an saduseotsik, xin junwal jelti i jilbédhaxtaláb kʼoye. ");
INSERT INTO husNT2005_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Tujey tám an exóbaltsik ti útsáx jajáꞌkʼitsik enchéꞌ: ―Jechéꞌ tin ulal abal yab i tsiꞌdhaꞌ an pan. ");
INSERT INTO husNT2005_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Achʼantsik kʼal na Jesús ani utsantsik enchéꞌ: ―¿Jantʼókʼi ti wéꞌ tʼajat tin belál? ¿Jantʼókʼi ta ulaltsik ke yab a koꞌol i pan? ");
INSERT INTO husNT2005_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Yabxeꞌ bél a exbayámtsik, nibal a chalpayaltsik tam tu kʼapundhaꞌ boꞌ mil i iniktsik kʼal xi bóꞌ an pan? ¿Ani jáy i tʼoknaltsik a tsʼutsiy kʼal an pejmatstaláb xi jilkʼon? ");
INSERT INTO husNT2005_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Nibal a chalpayal xi búk an pan xu kʼapundhaꞌ kʼál cheꞌ mil i iniktsik? ¿Ani jáy i tʼoknaltsik a tsʼutsiy kʼal an pejmatstaláb xi jilkʼon? ");
INSERT INTO husNT2005_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Jantʼókʼi ti yabtsik a exbayal ke yab in kʼwajat u tʼilál i pan, tam tu utsaꞌtsik abal ka kóꞌoy i kwenta kʼal nin jilbédhaxtaláb kʼoyéjil an fariseotsik ani an saduseotsik? ");
INSERT INTO husNT2005_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","In exbáchtsik tám ke yab usnéktsik kʼal na Jesús kin kóꞌoy i kwenta kʼal an jilbédhaxtaláb xu éynáb abal ka tʼajan an pan, usnéktsik kin kóꞌoy i kwenta kʼal nin okʼtsixtal an fariseotsik ani an saduseotsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Tam ti na Jesús ulich Sesarea, an bitsow xu takʼnal Filipo, in konoy enchéꞌ nin exóbaliltsik: ―¿Jitaꞌ tin ulal an atiklábtsik ke Nanáꞌ neye xin abadh abal kin wenkʼon neye tin inik? ");
INSERT INTO husNT2005_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Jajáꞌtsik tókʼon enchéꞌ: ―Juntsik in ulal ke Tatáꞌ i Juan xu pujax, kʼeꞌettsik in ulal ke i Elías xi xeꞌchinék ti tʼiltsix ti wejeꞌ ani taltsik in ulal ke i Jeremías o jun i kʼeꞌet tʼiltsix. ");
INSERT INTO husNT2005_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Konyattsik tám juní enchéꞌ kʼal na Jesús: ―Ani tatáꞌtsik, ¿jitaꞌ ta ulaltsik ke Nanáꞌ neye? ");
INSERT INTO husNT2005_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Tókʼoyat tám enchéꞌ kʼal na Simón Pedro: ―Tatáꞌ i Kristo, nin Chakámil na Dios xi ejat. ");
INSERT INTO husNT2005_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Tókʼoyat enchéꞌ kʼal na Jesús: ―Kʼijidh tʼajat abal tatáꞌ, Simón, xi chakámláb kʼal na Jonás, pos jechéꞌ yab i óltsinék kʼal jun i inik, i óltsidh kʼal nu Tátaꞌ xi kʼwajat walkʼiꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ani Nanáꞌ tu utsál ke tatáꞌ i Pedro, xin léꞌ kin ulu tʼujub, ani ba jechéꞌ an tʼujub ti neꞌech ku kʼwajbaꞌ xi neꞌech ti kin belaꞌtsik ani yab neꞌech ka ejtowat ka átá kʼal an chemlá. ");
INSERT INTO husNT2005_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nanáꞌ neꞌech tu pidhaꞌ ti awiltaláb abal ka choꞌóbnaꞌ xan ti neꞌech kin ejto ka kʼwajay jun xitaꞌ takʼnél kʼal na Dios. Xitaꞌ ka pakwlantsi techéꞌ ti kʼayꞌlá, neꞌech jeye ka pakwlantsat túꞌ walkʼiꞌ ani xitaꞌ yab ka pakwlantsi techéꞌ ti kʼayꞌlá, yab jeye neꞌech ka pakwlantsat túꞌ walkʼiꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Utsantsik tám an exóbaltsik kʼal na Jesús abal yab xitaꞌ kin óltsi max Jajáꞌich nu Kristo. ");
INSERT INTO husNT2005_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Asta tam ti tám, na Jesús in tuju kin wiltsi nin exóbaliltsik ke Jajáꞌ koꞌol ka kʼale Jerusalén ani ke neꞌech tʼajat ka atʼax tʼajtsin kʼal nin okʼlékil an judíotsik, an okʼlek páleꞌtsik ani an okʼtsixtsik xin wilál nin takʼixtal na Dios xin jilám dhutsadh na Moisés. In utsaꞌtsik jeye ke Jajáꞌ neꞌech ka chemdhá, por tin óxláb a kʼítsá neꞌech ka ejech ti ít. ");
INSERT INTO husNT2005_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Júná tám pílkʼi kʼal na Pedro ani tujey ti kʼwiynal enchéꞌ: ―¡Ajátik, ke na Dios yab kin walkaꞌ ka tamu anchanꞌ! ¡Ke yab jaykʼi ka támun jechéꞌ! ");
INSERT INTO husNT2005_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Por chawꞌkʼin na Jesús ani utsan enchéꞌ na Pedro: ―¡Ki wixkʼin techéꞌ lej atʼax! Tatáꞌ tin tʼojliyalkʼi, pos yab a chalpayal xan ti na Dios tin chalpayal, tokot a chalpayal xan tin chalpayal an iniktsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Utsan tám enchéꞌ an exóbaliltsik kʼal na Jesús: ―Max jun xitaꞌ in léꞌ ti kin wéwnaꞌ, yejat kin ukʼtsi tinbáꞌ ani tin wéwnaꞌ por yab kin ajay tinbáꞌ maske ka chemdhá. ");
INSERT INTO husNT2005_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Pos ejtal xitaꞌ in léꞌ kin loꞌo nin xeꞌchintal, neꞌech kin kʼibdhaꞌ; por xitaꞌ kin kʼibdhaꞌ nin xeꞌchintal kʼal Nanáꞌkʼi tu kwenta, neꞌech kin kóꞌoy an xeꞌchintaláb xi yab in koꞌol in okʼontal. ");
INSERT INTO husNT2005_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Pos, ¿jantʼó ti alwaꞌ max jun xitaꞌ kin bajaw kin kóꞌoy ejtal xowaꞌ waꞌach ban kʼayꞌlá ani kin kʼibdhaꞌ nin ejattal ba kʼibeltaláb? O ¿jantʼéy neꞌech kin ejto kin pidhnaꞌ an inik abal kin loꞌo nin ejattal? ");
INSERT INTO husNT2005_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Pos Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik, neꞌech kin tsích kʼal ejtal nin labidh tʼokát nu Tátaꞌ ani kʼal nin tʼokat abatwálejiltsik ani tám neꞌech ku pidhaꞌ an atiklábtsik xowaꞌ in lujyal kin bachʼu kʼal tin kwentakʼi xowaꞌ in tʼajámal. ");
INSERT INTO husNT2005_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Tsubax tu utsáltsik, ke waꞌach taltsik xi xoꞌ techéꞌ jeye kʼwajat, ke yab neꞌech ka chemech asta kin chuꞌutsik okʼox kin tsích tin takʼix Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik. ");
INSERT INTO husNT2005_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Akak a kʼítsá más tayíl, na Jesús in kaniy na Pedro, na Jakobo ani na Juan nin kidháb na Jakobo ani kʼale jajáꞌkʼitsik ba jun i tʼekʼat chʼén. ");
INSERT INTO husNT2005_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Tajaꞌ, na Jesús in jalkʼuy tinbáꞌ tin tamét nin exóbaliltsik xi kʼalnek kʼal Jajáꞌ. Nin wal chʼaxkʼin jelti na kʼítsá ani nin kʼudhkʼúmil dhakniꞌbé jelti an tajaxtaláb. ");
INSERT INTO husNT2005_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Támkʼi jachanꞌ, in chuꞌutsik jeye na Moisés ani na Elías, ti tʼilolól kʼal na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Utsan tám enchéꞌ na Jesús kʼal na Pedro: ―Ajátik, ¡alwaꞌ tʼajat abal techéꞌ u kʼwajat! Max Tatáꞌ a léꞌ, neꞌech ki tʼajaꞌ óx i padhel, jún abal Tatáꞌ, jún abal na Moisés ani jún abal na Elías. ");
INSERT INTO husNT2005_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Lejat na Pedro kʼwajat ti káw, dhabyattsik kʼal jun i chʼaxixíl tokow ani ban tokow achʼatmé jun i káwintaláb, xu káw in ulu enchéꞌ: ―Jechéꞌ jaꞌich nu Chakámil xu kʼanidhál tʼajat ani in kulbél tʼajat kʼal Jajáꞌ. Ka axtsitsik xowaꞌ Jajáꞌ in ulal. ");
INSERT INTO husNT2005_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Tam tin achʼaꞌtsik jechéꞌ, an exóbaltsik tudhlan kututsik asta chabál ani jikʼeytsik tʼajat. ");
INSERT INTO husNT2005_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Utey tám na Jesús xon ti kʼwajattsik, takan ani utsantsik enchéꞌ: ―Ki chʼakaytsik ani yab ki jikʼey. ");
INSERT INTO husNT2005_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Tam ti chʼakaytsik ani in telaꞌ, yab más xitaꞌ in chuꞌu, tokot na Jesús kwetém. ");
INSERT INTO husNT2005_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Tam ti exomich ti paꞌíltsik ban chʼén, utsantsik enchéꞌ kʼal na Jesús: ―Yab xitaꞌ ka tʼiltsi xowaꞌ a chuꞌutsik, asta tam kin chemdhá Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik ani in ejnekich ti ít. ");
INSERT INTO husNT2005_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Konyat tám enchéꞌ kʼal nin exóbaliltsik: ―¿Jantʼókʼi pé tám an okʼtsixtsik xin wilál nin takʼixtal na Dios xin jilám dhutsadh na Moisés tin ulaltsik ke koꞌol ka tsích okʼox na Elías? ");
INSERT INTO husNT2005_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Tókʼoyattsik enchéꞌ kʼal na Jesús: ―Tsubax kʼejle ke na Elías neꞌech ka tsích okʼox ani neꞌech kin lejkiy ejtal. ");
INSERT INTO husNT2005_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Por Nanáꞌ tu utsáltsik ke na Elías tsiꞌnekich, por yab exlá, tokot tʼajtsin xowaꞌ ka leꞌná. Anchanꞌ neye ti neꞌech kin tʼajtsin Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik. ");
INSERT INTO husNT2005_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","In exbách tám an exóbaltsik ke na Jesús kʼwajat in tʼilál na Juan xu pujax. ");
INSERT INTO husNT2005_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Tam ti ulichtsik xon ti kʼwajat an atiklábtsik, utukná na Jesús kʼal jun i inik, tudhlan tin tamét ani utsan enchéꞌ: ");
INSERT INTO husNT2005_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","―Ajátik, ka kóꞌontsi ti yajnantsixtaláb nu chakámil; pos ochadh kʼal i atʼax ejattaláb ani in achʼál tʼajat i yajtsiktaláb; yánílich kwajlanék ba kʼamal ani ba jaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","U tsiꞌdhantsám na exóbaliltsik, por yab in ejtómal kin káldhantsi an ti atʼax ejattaláb. ");
INSERT INTO husNT2005_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Tókʼoyat enchéꞌ kʼal na Jesús: ―¡Atiklábtsik xi jechéꞌ i kʼij, yab lejtal tʼajat i belom ani i walablomtsik tʼajat! ¿Asta jowkʼi koꞌol kin kʼwajay kʼal tatáꞌtsik? ¿Asta jowkʼi koꞌol tu kuxuytsik? Ka tsiꞌdhaꞌ techéꞌ an kwitól. ");
INSERT INTO husNT2005_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","In kʼwiyaꞌ tám na Jesús an atʼax ejattaláb, kale ani támkʼi jachanꞌ jilkʼon jelnek an kwitól. ");
INSERT INTO husNT2005_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Tayíl an exóbaltsik in kaniy tám pílkʼi na Jesús ani in konoytsik enchéꞌ: ―¿Jantʼókʼi wawáꞌ ti yab i ejto ki káldhaꞌ an atʼax ejattaláb? ");
INSERT INTO husNT2005_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Utsantsik enchéꞌ kʼal na Jesús: ―Pos tatáꞌtsik wéꞌ tʼajat ta belom. Tsubax tu utsáltsik max i belomak elaꞌ wéꞌ, jelt in pubíl jun in itsích i mostasa, neꞌech ka ejto ka utsaꞌtsik jechéꞌ an chʼén: “Ki wixkʼin techéꞌ ani ki kʼale píl” ani an chʼén neꞌech ka kʼale. Ejtal neꞌech ka ejto ka tʼajaꞌtsik max i belomak. ");
INSERT INTO husNT2005_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Por jelti jechéꞌ an atʼax ejattaláb tokot neꞌech ka ejtotsik ka káldhaꞌ max ki ólan ani ki kʼílin. ");
INSERT INTO husNT2005_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Tam ti kʼwajattsik Galilea, na Jesús in utsaꞌ enchéꞌ nin exóbaliltsik: ―Nanáꞌich xin abadh abal kin wenkʼon neye tin inik, neꞌech kin pidhná ban walablom iniktsik ");
INSERT INTO husNT2005_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ani neꞌech kin chemdhá, por tin óxláb a kʼítsá neꞌech kin ejech ti ít. Tam tin achʼaꞌtsik jechéꞌ xowaꞌ utsan, tʼeꞌpintsik tʼajat. ");
INSERT INTO husNT2005_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Tam ti na Jesús ani nin exóbaliltsik ulich ban bitsow xi Kapernaúm, utukná na Pedro kʼal xin bachʼwaltsik an jalbixtaláb kʼal tin kwenta an atá xon tu kʼakʼnáb na Dios ani konyat enchéꞌ: ―¿Yabxeꞌ Jaꞌ in pidhnál na Okʼtsíxal an jalbixtaláb abal an pulek atá xon tu kʼakʼnáb na Dios? ");
INSERT INTO husNT2005_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Tókʼon enchéꞌ na Pedro: ―In pidhnál. Tam ti na Pedro ochich altá, tsusbél ti utsan enchéꞌ kʼal na Jesús: ―¿Janta chuꞌtal, Simón? An okʼlektsik xi techéꞌ ti kʼayꞌlá jitaꞌ nin kontsaltsik an ti jalbixtaláb ¿nin at kidhtaltsik o xi píltsik? ");
INSERT INTO husNT2005_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Tókʼoyat enchéꞌ kʼal na Pedro: ―Xi píltsik. Utsan tám enchéꞌ kʼal na Jesús: ―Tám, yab yejat ka jalbixin xi techéꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Por abal yab ki itʼixbédhaꞌtsik, ki kʼale ban pujal, ka petʼnaꞌ nin jixáb an toꞌol ani ka yakʼwaꞌ an jidhtal toꞌol xi ka palkʼan. Ka chʼaꞌtsi tin wiꞌ ani tajaꞌ neꞌech ka elaꞌ jun i patʼál tumín, ka jixtsi ani ka júnaꞌ abal ka jalbiy xi tatáꞌ a lujyal ani xi Nanáꞌ neye. ");
INSERT INTO husNT2005_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Tam ti jachanꞌ i kʼij, utey an exóbaltsik ba na Jesús ani in konoytsik enchéꞌ: ―¿Jitaꞌ jáꞌ na más ultaláb xon tu takʼix na Dios? ");
INSERT INTO husNT2005_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","In kaniy tám na Jesús jun i chakam kwitól, in kʼwajbaꞌ junax chʼejel xon ti kʼwajattsik ");
INSERT INTO husNT2005_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ani in ulu enchéꞌ: ―Tsubax tu utsáltsik, ke max yabtsik ka jalkʼuy tabáꞌ ani yabtsik ka junu jelti an chakamtsik, yab neꞌech ka ejto ki kʼwajaytsik takʼnél kʼal na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Jaxtám, xitaꞌ na más ultaláb xon tu takʼix na Dios, jaꞌich xin chaꞌkál tinbáꞌ ani in junwal jelti jechéꞌ an chakam. ");
INSERT INTO husNT2005_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ani xitaꞌ in bachʼwal jun i chakam jelti jechéꞌ kʼal Nanáꞌ tu bij, Nanáꞌ tin bachʼwal. ");
INSERT INTO husNT2005_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","ʼXitaꞌ kin walbindhaꞌ jún ti éb jechéꞌ an chakamtsik xi tin belálichtsik, más alwaꞌ abal an walbindhom ka wikʼtsin bin núkʼ jun i yejcheꞌ chaꞌ tʼujub ani ka petʼná ban pujal abal ka luyꞌchin. ");
INSERT INTO husNT2005_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡Chʼojontál in chuꞌbíl an atiklábtsik xi techéꞌ ti kʼayꞌlá abal waꞌach tʼajat xantʼokʼál ti ka walbindhá! Echʼekʼi neꞌech ka waꞌchin xantʼokʼál ti ka walbindhá, por ¡chʼojontál in chuꞌbíl xitaꞌ ka walbindhaxin! ");
INSERT INTO husNT2005_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","ʼJaxtám, max na kʼubak o na akan ti walbindhál, ka kotoy ani ka petʼnaꞌ ów; pos más alwaꞌ ki ochich mochoꞌ o kʼwechʼeꞌ ban xeꞌchintaláb xi yab in koꞌol in okʼontal ani yab kʼal chablam na kʼubak o chablam na akan ki petʼná ban kʼibeltaláb. ");
INSERT INTO husNT2005_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ani max na wal ti walbindhál, ka jixaꞌ ani ka petʼnaꞌ ów; pos más alwaꞌ ki ochich ban xeꞌchintaláb xi yab in koꞌol in okʼontal kʼal jún tokot na wal ani yab kʼal chablam na wal ki petʼná ban kʼibeltaláb. ");
INSERT INTO husNT2005_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","ʼKa kóꞌoytsik i kwenta abal yab ka pojkaꞌtsik ni jun xitaꞌ xi tin belálichtsik. Pos tu utsáltsik ke nin tʼokat abatwálejiltsik túꞌ walkʼiꞌ echʼekʼi kʼwajat tin tamét nu Tátaꞌ xi kʼwajat walkʼiꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Pos Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik, in tsiꞌnek ku loꞌo xi kʼibchonékichtsikwiꞌik ti kʼwajat. ");
INSERT INTO husNT2005_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","ʼ¿Jan ta chuꞌtaltsik? Max jun i inik in koꞌol boꞌ inik i borregotsik ani kin kʼibdhaꞌ jún, ¿yabxeꞌ neꞌech kin jilaꞌ xi cheꞌ inik lajubeléju abal ka kʼale ban chʼénlom kin aliy xi kʼibchonék? ");
INSERT INTO husNT2005_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ani max kin elaꞌ, tu utsáltsik tsubax ke más neꞌech ka kulbé kʼal tin kwenta jachanꞌ xi kʼibchonék ké kʼal tin kwenta xi cheꞌ inik lajubeléju xi yab kʼibchonék. ");
INSERT INTO husNT2005_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Anchanꞌ jeye, na Tátaꞌ xi kʼwajat walkʼiꞌ, yab in léꞌ kin chuꞌu ka kʼibchon ni jun xitaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","ʼMax na at kidháb ti tʼajtsi jun xataꞌ yab alwaꞌ, ki kʼale abal ki tʼilololách tatáꞌkʼitsik. Max ti ki axtsi xowaꞌ ka utsaꞌ, neꞌech tám kin exbay ke yab alwaꞌ xowaꞌ in tʼajaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Por max yab ti ki axtsi, ka kaniy tám jún o cháb i belomtsik abal ka tawná jeye kʼal cháb o óx i belomtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Max yab jeye kin axtsi xi jechéꞌtsik, ka ulu tám tin tamét an kidháblábtsik; ani max yab jeye kin axtsi an kidháblábtsik, ka kóꞌóchtsik tám jelti jun i píl inik o jelti jun i bachʼkʼul jalbixtaláb xi yab in exlál a Dios. ");
INSERT INTO husNT2005_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","ʼTsubax tu utsáltsik, ke xitaꞌ ka pakwlantsitsik techéꞌ ti kʼayꞌlá, neꞌech jeye ka pakwlantsat túꞌ walkʼiꞌ ani xitaꞌ yab ka pakwlantsitsik techéꞌ ti kʼayꞌlá, yab jeye neꞌech ka pakwlantsat túꞌ walkʼiꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","ʼTu utsáltsik jeye, ke max cháb xi tatáꞌtsik a kidhtal xi kʼwajat techéꞌ ti kʼayꞌlá kin tʼajaꞌtsik i káw abal kin kontsi jun xataꞌ nu Tátaꞌ xi kʼwajat walkʼiꞌ, neꞌech ka pidhantsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Abal xon ti ka junkun cháb o óx kʼal Nanáꞌ tu bij, tajaꞌ neye in kʼwajat kʼal jajáꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Utukná tám na Jesús kʼal na Pedro ani konyat enchéꞌ: ―Ajátik, ¿jáyíl koꞌol ku pakwlantsi nu at kidháb max tin waltsi? ¿Asta búkíl? ");
INSERT INTO husNT2005_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Tókʼoyat enchéꞌ kʼal na Jesús: ―Yab neꞌech tu utsaꞌ ke tokot búkíl, yejat ka pakwlantsi echʼekʼi. ");
INSERT INTO husNT2005_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","ʼJaxtám, xan tu takʼix na Dios in junwal jelti jun i pulek takʼix xin leꞌnaꞌ kin tʼajaꞌ i kwenta kʼal nin tʼojnáliltsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Tam ti tám in tujwal kin tʼajaꞌ an kwenta, uldhantsat jun xitaꞌ xu júntsinal kʼál yán i tumín. ");
INSERT INTO husNT2005_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Kom jachanꞌ an tʼójontsix yab in koꞌol xan ti kin jalbiy, an pulek takʼix in ulu abal ka nujwat jachanꞌ an tʼójontsix kʼál nin tomtal, nin chakámiltsik ani ejtal xowaꞌ in koꞌol abal ka jalbin nin júntsixtal. ");
INSERT INTO husNT2005_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Tudhlan jachanꞌ an tʼójontsix tin tamét an pulek takʼix ani in pakabédhaꞌ enchéꞌ: “Ajátik, ti kin aytsintsi neye ani neꞌech tu jalbintsi ejtal xowaꞌ tu júntsal.” ");
INSERT INTO husNT2005_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Kóꞌontsat ti yajnantsixtaláb kʼal nin ajátik, pakwlantsat an tin júntsixtal ani walká. ");
INSERT INTO husNT2005_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Por tam ti kale jachanꞌ an tʼójontsix, in elaꞌ jun in at tʼójontsix, xu júntsinal kʼál wéꞌ i tumín. In yakʼwaꞌ bin núkʼ ani in tuju kin kʼuchʼédhaꞌ, in utsaꞌ enchéꞌ: “¡Tin witsbantsi xi tin júntsal!” ");
INSERT INTO husNT2005_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Tudhlan tám nin at tʼojnal tin tamét ani pakabédhá enchéꞌ: “Tin aytsintsi neye ani neꞌech tu jalbintsi ejtal xowaꞌ tu júntsal.” ");
INSERT INTO husNT2005_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Por jajáꞌ yab in leꞌnaꞌ kin aytsintsi, kʼale kin ulu ka balyat ban wikʼaxteꞌ asta kin jalbiy ejtal xu júntsinal. ");
INSERT INTO husNT2005_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Tam tin chuꞌu nin at tʼojnaltsik xowaꞌ támun, tʼeꞌpintsik tʼajat ani kʼaletsik kin tʼiltsi an ajátikláb ejtal xowaꞌ támun. ");
INSERT INTO husNT2005_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","In abnaꞌ tám an ajátikláb ka kanyat an tʼojnal xi yab pakwlantsixin ani in utsaꞌ enchéꞌ: “¡Atʼax tʼójontsix! Nanáꞌ tu pakwlantsi ejtal ta júntsixtal, abal tin pakabédhaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","¿Yabxeꞌ yejat ka pakwlantsiwiꞌik teye na at tʼojnal, jelt xan ti nanáꞌ tu pakwlantsi?” ");
INSERT INTO husNT2005_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","An ajátikláb chakuy tʼajat ani in ulu ka atʼax tʼajtsin an tʼojnal xi yab pakwlantsixin asta kin jalbiy ejtal xowaꞌ in júnál. ");
INSERT INTO husNT2005_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","’Anchanꞌ jeye neꞌech kin tʼajaꞌ kʼal tatáꞌtsik nu Tátaꞌ xi kʼwajat walkʼiꞌ, max yab ka pakwlantsitsik na at kidhábtsik kʼal ejtal na ejattal. ");
INSERT INTO husNT2005_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Tam ti na Jesús okʼon kin ulu ejtal jechéꞌ, kale Galilea ani kʼale ban chabál xi Judea xi kʼwajat tin ejtsím kalel kʼítsá kʼal an waljaꞌ Jordán. ");
INSERT INTO husNT2005_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Kʼal yán i atiklábtsik ti wéwná ani in jeldhaꞌ tajaꞌ an yaꞌultsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Utukná tám na Jesús kʼal cháb óx i fariseotsik ani abal ka taktamiyat, konyat enchéꞌ: ―¿Alwaꞌxeꞌ kin jilaꞌ jun xitaꞌ nin tomtal kʼal xowaꞌkichkʼi tin kwenta? ");
INSERT INTO husNT2005_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Tókʼoyattsik enchéꞌ kʼal na Jesús: ―¿Yabxeꞌ a ajyámaltsik ban Tʼokat Dhuslab, ke tam ti tujeykʼi, na Dios in tʼajaꞌ jun i inik ani jun i mímláb? ");
INSERT INTO husNT2005_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","In ulu jeye enchéꞌ: “Jaxtám, an inik neꞌech kin jilaꞌ nin tátaꞌ ani nin nánaꞌ abal ka kʼwajay junax kʼal nin tomtal ani xi jechéꞌ cháb, jún tokot ti neꞌech ka ájin.” ");
INSERT INTO husNT2005_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Yabich cháb ti neꞌech ka ájin, jún tokot. Jaxtám, an inik yab yejat kin kʼéꞌáxliy xowaꞌ in júnkúxliyámal na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Konyat tám enchéꞌ na Jesús: ―¿Jantʼókʼi pé tám na Moisés tin ulu ka pidhan an tomikláb mímláb jun i úw xon tin ulal xantʼókʼi tin kwenta ti neꞌech ka jilan? ");
INSERT INTO husNT2005_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Utsantsik enchéꞌ kʼal na Jesús: ―In ulu ka tʼajan anchanꞌ, kom tatáꞌtsik watʼats ta tanchuꞌ; jaxtám tin ulu ke awil ka jilaꞌtsik na tomtal, por tam ti tujeykʼi yab anchanꞌ ti tujenek. ");
INSERT INTO husNT2005_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nanáꞌ tu utsáltsik ke xin jiláltsik nin tomtal ani yab abal u junkunal kʼal kʼeꞌet ani ka tomkin kʼal kʼeꞌet i mímláb, u walbinalich kʼal i uxúmbeꞌtaláb; ani xitaꞌ ka tomkin kʼal jun i jiladh mímláb, u walbinalich jeye kʼal i uxúmbeꞌtaláb. ");
INSERT INTO husNT2005_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Utsan tám enchéꞌ kʼal nin exóbaliltsik: ―Max anchanꞌ u támnal, más alwaꞌ abal an inik yab ka tomkin. ");
INSERT INTO husNT2005_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Utsantsik tám enchéꞌ kʼal na Jesús: ―Yab ejtalkʼi neꞌech kin ejto ka kʼwajay kwetém, tokotkʼi xi bijtsidh kʼal na Dios ke anchanꞌ neꞌech ka kʼwajay. ");
INSERT INTO husNT2005_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Yán waꞌach xantʼókʼi tin kwenta ti yab neꞌech kin ejto ka tomkin an iniktsik: taltsik u waꞌchinal abal yab ka tomkin, taltsik yab in ejtowal ka tomkin abal tʼajtsidh jun xataꞌ kʼal an iniktsik ani taltsik yab u tomkinal abal in léꞌ kin tʼójontsi na Dios ani ka kʼwajay takʼnél kʼal Jajáꞌ. Xitaꞌ in ejtowal ka kʼwajay kwetém, ka kʼwajay kwetém. ");
INSERT INTO husNT2005_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Utuntsat tám na Jesús cháb óx ti chakamtsik abal kin kʼwajbaꞌ nin kʼubak ban chakamtsik ani ka ólan kʼal jajáꞌtsik tin kwenta; por an exóbaltsik tujey kin kʼwiyaꞌ xitaꞌ nin utwal an chakamtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","In ulu tám enchéꞌ na Jesús: ―Ka walkaꞌtsik ti kin utuknaꞌ an chakamtsik ani yab ka tamkʼuytsik; pos xitaꞌ kin walkaꞌ tinbáꞌ ka takʼyat kʼal na Dios, jelt xan tin walkál tinbáꞌ ka takʼyat jun i chakam, jachanꞌ jaꞌich xi neꞌech kin ejtotsik ka kʼwajay takʼnél kʼal na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","In kʼwajbaꞌ tám nin kʼubak ban chakamtsik ani tayíl kʼale píl. ");
INSERT INTO husNT2005_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Kʼale ti chuꞌtáb na Jesús kʼal jun i kwitól ani konyat enchéꞌ: ―Alwaꞌ Okʼtsix, ¿jantʼom alwaꞌtaláb yejat ku tʼajaꞌ abal ku ejto ku kóꞌoy an xeꞌchintaláb xi yab in koꞌol in okʼontal? ");
INSERT INTO husNT2005_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Utsan enchéꞌ kʼal na Jesús: ―¿Jantʼókʼi tin bijyal tin alwaꞌ? Jún tokot waꞌach xitaꞌ alwaꞌ, na Dios. Por max a léꞌ ka kóꞌoy an xeꞌchintaláb xi yab in koꞌol in okʼontal, ka tʼajaꞌ xowaꞌ in ulal an takʼixtaláb. ");
INSERT INTO husNT2005_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Konyat enchéꞌ kʼal an kwitól: ―¿Jowaꞌ takʼixtaláb? Ani tókʼoyat enchéꞌ kʼal na Jesús: ―Yab ki chemdhaxin, yab ki junkun kʼal xi yab a tomtal, yab ki kwéꞌlách, yab ka jantsi ti káw ni jun xitaꞌ, ");
INSERT INTO husNT2005_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ka kʼakʼnaꞌ na tátaꞌ ani na nánaꞌ ani ka kʼanidhaꞌ xi kʼeꞌettsik jelt xan ta kʼanidhál tabáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Utsan enchéꞌ kʼal an kwitól: ―Ejtal jechéꞌ u tʼajál asta tin chipíl, ¿jantʼéy más yejat ku tʼajaꞌ? ");
INSERT INTO husNT2005_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Utsan enchéꞌ kʼal na Jesús: ―Max a léꞌ lejtal ki xeꞌchin lujat, ki kʼale ka nuju ejtal xowaꞌ a koꞌol ani ka pidhaꞌ an ti tumín an chʼojontáltsik, anchanꞌ neꞌech ka kóꞌoy túꞌ walkʼiꞌ xowaꞌ xin jalbíl; ki tsích tám ani ti kin wéwnaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Tam ti an kwitól in achʼaꞌ jechéꞌ, u tʼeꞌpinal tʼajat ti kʼale, abal jajáꞌ yán xataꞌ in koꞌol. ");
INSERT INTO husNT2005_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Utsan tám enchéꞌ an exóbaltsik kʼal na Jesús: ―Tsubax tu utsáltsik, ke tʼojláb tʼajat kin jilaꞌ tinbáꞌ ka takʼyat kʼal a Dios jun i tumínladh inik. ");
INSERT INTO husNT2005_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Tu utsáltsik jeye, ke más yab tʼojláb ka watʼey jun i koꞌnél xin bij kameyo bin chultál jun i tʼidhab ké kin walkaꞌ tinbáꞌ jun i tumínladh inik ka takʼyat kʼal na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Tam ti an exóbaltsik in achʼaꞌ jechéꞌ, labantsik tʼajat ani kónóxin jajáꞌkʼitsik enchéꞌ: ―¿Pos jitaꞌ pé tám neꞌech kin ejto ka loꞌey? ");
INSERT INTO husNT2005_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Teloloyattsik kʼal na Jesús ani utsantsik enchéꞌ: ―Na Dios ejtal in ejtowal kin tʼajaꞌ, por an iniktsik, yabaꞌ. Tokot na Dios in ejtowal kin loꞌo xitaꞌkichkʼi. ");
INSERT INTO husNT2005_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Konyat tám enchéꞌ kʼal na Pedro: ―Ajátik, wawáꞌ i jilámal ejtal xowaꞌ i koꞌol abal ku xeꞌchin kʼal Tatáꞌ, ¿jantʼéy pé weye neꞌech ki kóꞌoy? ");
INSERT INTO husNT2005_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Tókʼoyattsik enchéꞌ kʼal na Jesús: ―Tsubax tu utsáltsik, ke tam kin bajaw an kʼij tam ejtal ka ítmédhájich, tam Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik, kin buxkan bu tʼokat kʼwajtal, tatáꞌtsik xi tin wéwnámal, neꞌech ki buxkantsik teye ba lajucháb i tʼokat kʼwajtaláb. Neꞌech ki buxkantsik abal ka lújundhaꞌ nin kidhtaltsik xi lajucháb nin chakámiltsik na Israel. ");
INSERT INTO husNT2005_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ani ejtal xin jilámaltsik in kʼimáꞌ, o in kidhábtsik, in ixámtsik, in tátaꞌ o in nánaꞌ, in tomtal, in chakámiltsik o in chabáliltsik, kʼal Nanáꞌkʼi tu kwenta, neꞌech ka pidhantsik más yán kʼal na Dios ani neꞌech jeye kin kóꞌoytsik an xeꞌchintaláb xi yab in koꞌol in okʼontal. ");
INSERT INTO husNT2005_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Por yán xi xoꞌ kʼwajattsik ultaláb, neꞌech ka jilkʼon tayíl ani yán xi xoꞌ kʼwajat tayíl, neꞌech ka kʼwajaytsik ultaláb. ");
INSERT INTO husNT2005_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","ʼXan tu takʼix na Dios in junwal jelti jun i dhabal tʼójomtaláb xi kale dhajawe ti álim tʼojnaltsik abal ka kʼale ti tʼojnal xon tin koꞌol tʼayadh i uba. ");
INSERT INTO husNT2005_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","In elaꞌ an tʼojnaltsik ani utsan neꞌech ka tolmiyat. In utsaꞌ neꞌech kin jalbiytsik jun i denario ta kʼítsá ani in abaꞌ ti tʼojnaltsik xon tin koꞌol tʼayadh an uba. ");
INSERT INTO husNT2005_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Tayíl, tam ti beléjujich xónaꞌ i dhajaw, kale juní, in elaꞌ kʼeꞌet xi yabtsik xataꞌ in tʼojnál ");
INSERT INTO husNT2005_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","ani in utsaꞌtsik enchéꞌ: “Ki kʼaletsik teye ta tʼojnal xon tu koꞌol tʼayadh an uba ani neꞌech tu pidhaꞌtsik xowaꞌ in tomnál ka átaꞌ.” Ani kʼaletsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","An dhabal tʼojláb kale juní tam ti chʼejelich a kʼítsá ani tam ti óxich i wákal ani anílkʼi tin tʼajaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Tam ti bóꞌich i wákal, kale juní ani in elaꞌ kʼeꞌet xi taꞌ ti kʼwajattsik yab xataꞌ in tʼajál ani in utsaꞌtsik enchéꞌ: “¿Jantʼókʼi ta kʼwajattsik techéꞌ putál a kʼítsá yab xataꞌ a tʼojnál?” ");
INSERT INTO husNT2005_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Tókʼoyat enchéꞌ: “Techéꞌkʼi u kʼwajat kom yab xitaꞌ tu kanyámal tu tʼojnal.” Utsantsik tám enchéꞌ: “Ki kʼaletsik teye ta tʼojnal xon tu koꞌol tʼayadh an uba ani neꞌech tu pidhaꞌtsik xowaꞌ in tomnál ka átaꞌ.” ");
INSERT INTO husNT2005_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Tam ti jikʼwchinich, an dhabal aleláb in utsaꞌ enchéꞌ an okʼlek tʼojnal: “Ka kaniy an tʼojnaltsik ani ka jalbiy, okʼox ka jalbiy xi tayílichtsik ti ochenek ti tʼojnal ani tayílich ka jalbiy xi okʼoxtsik ti ochenek.” ");
INSERT INTO husNT2005_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ulichtsik tám xi ochenektsik ti tʼojnal bóꞌich i wákal ani kidhat jeye pidhantsik juntsik i denario. ");
INSERT INTO husNT2005_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Tayíl, tam tin bajúchtsik jeye kin bachʼutsik nin jalbíl xi okʼoxtsik ti ochenek ti tʼojnal, in chalpay ke más yandhaꞌ neꞌech ka pidhantsik; por tokot jeye juntsik i denario pidhan. ");
INSERT INTO husNT2005_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Tam tin bachʼutsik, tujeytsik ti itʼixbél ");
INSERT INTO husNT2005_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ani in utsaꞌtsik enchéꞌ an dhabal tʼojláb: “Jechéꞌtsik xi ulich tayílich, tokot tʼójontsik jun i ora ani anílkʼi jeye ta jalbiytsik jelti wawáꞌ, xu tʼójnék ani i kuxyámal nin yájtsík an kʼakʼal putál a kʼítsá.” ");
INSERT INTO husNT2005_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Por an dhabal tʼojláb tókʼon ani in utsaꞌ enchéꞌ jún ti éb xi kʼwajat an ti káw: “Jaꞌúb, yab exom tu tʼajtsal ni jun xataꞌ yab alwaꞌ. ¿Yabxeꞌ tu utsaꞌ abal jún tokot i denario neꞌech tu jalbiy ta kʼítsá? ");
INSERT INTO husNT2005_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ka bachʼu na jalbíl ani ki kʼaléch. Por nanáꞌ u léꞌ ku pidhaꞌ anílkʼi jeye xan tu pidhaꞌ tatáꞌ jechéꞌ xi ochich tayílich an ti tʼojnal. ");
INSERT INTO husNT2005_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Awxeꞌ yab alwaꞌ ku tʼajaꞌ xowaꞌ nanáꞌ u léꞌ kʼal xowaꞌ u koꞌol? O ¿i chakúl abal a chuꞌtal ke nanáꞌ in alwaꞌ inik?” ");
INSERT INTO husNT2005_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Pos anchanꞌ pé, xi xoꞌ kʼwajat ultalábtsik, neꞌech ka jilkʼon tayíl ani xi xoꞌ kʼwajat tayíl, neꞌech ka kʼwajaytsik ultaláb. Pos yán tʼajat xi kanidhtsik, por wéꞌ tʼajat xi takudhtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Tam ti na Jesús neꞌchich abal Jerusalén, in kaniy pílkʼi xi lajucháb nin exóbaliltsik ani in utsaꞌtsik enchéꞌ: ");
INSERT INTO husNT2005_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―A chuꞌtaltsik ke u neꞌchich Jerusalén ani tajaꞌ, Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik, neꞌech kin pidhná ban okʼlek páleꞌtsik ani ban okʼtsixtsik xin wilál nin takʼixtal na Dios xin jilám dhutsadh na Moisés. Neꞌech kin ulutsik abal kin chemdhá ");
INSERT INTO husNT2005_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ani neꞌech kin pidhná ban píl iniktsik abal kin labídhná kʼal jajáꞌtsik, neꞌech kin lekbayat ani neꞌech kin chemdhá pajkʼidh ban peltsidh teꞌ; por tin óxláb a kʼítsá neꞌech kin ejech ti ít. ");
INSERT INTO husNT2005_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Utey tám ba Jesús nin nánaꞌ na Jakobo ani na Juan, xu chakámlábtsik kʼal na Sebedeo junax kʼal jajáꞌtsik ani tudhlan tin tamét na Jesús abal kin kontsi jun i alwaꞌtaláb. ");
INSERT INTO husNT2005_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Konyat enchéꞌ kʼal na Jesús: ―¿Jantʼéy a léꞌ? In ulu enchéꞌ an nánaꞌláb: ―Tam kin bajaw xowkʼi neꞌech ta takʼixich, tu kontsal ke jún ti éb nu chakámil ka buxkan ta eját ani xi jún ta kʼwatab. ");
INSERT INTO husNT2005_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Por tókʼoyattsik enchéꞌ kʼal na Jesús: ―Tatáꞌtsik yab a choꞌób xantʼéy a konyal. ¿Neꞌechxeꞌ ka ejto ka watʼnaꞌtsik an yajtsiktaláb xi neꞌech ku watʼnaꞌ ani an chemlá jeye? Jajáꞌtsik tókʼon enchéꞌ: ―Neꞌech ki ejto. ");
INSERT INTO husNT2005_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Utsantsik enchéꞌ kʼal na Jesús: ―Aniꞌ kʼejle. Tatáꞌtsik neꞌech ka watʼnaꞌtsik jechéꞌ an yajtsiktaláb ani an chemlá jeye; por kʼal tin kwenta xitaꞌ neꞌech ka buxkan tu eját ani tu kʼwatab, yab Nanáꞌ neꞌech ku ulu, tokot neꞌech ka buxkantsik xitam jáꞌ na takudhtsik kʼal nu Tátaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Tam tin achʼaꞌtsik jechéꞌ xi láju an exóbaltsik, in chakuntsitsik xi jechéꞌ cháb an kidháblábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Kanyattsik tám kʼal na Jesús ani utsantsik enchéꞌ: ―Anchanꞌ xan ta choꞌóbichtsik, an pakdhaꞌ takʼix u takʼix jelti ajátiklábtsik ani xi más ultalábtsik, u chapik takʼixtsik tʼajat. ");
INSERT INTO husNT2005_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Por tatáꞌtsik yab yejat ka tʼajaꞌ anchanꞌ. Xitaꞌ in léꞌ ka kʼwajay más púlek kʼal tatáꞌtsik, yejat kin tʼójontsi ejtalkʼi ");
INSERT INTO husNT2005_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","ani xitaꞌ in léꞌ ka kʼwajay más ultaláb kʼal tatáꞌtsik, yejat kin tʼójontsi ejtalkʼi. ");
INSERT INTO husNT2005_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Pos Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik, yab in tsiꞌnek abal kin tʼójontsat, in tsiꞌnek tin tʼójontsix ani ku pidhnaꞌ tubáꞌ kin chemdhá abal ku jalbiy an loꞌeltaláb xi yán neꞌech kin bachʼutsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Tam ti exomichtsik ti kalel ban bitsow xi Jerikó, kʼal yán i atiklábtsik ti wéwná na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Táꞌ ti buxutsik wal bél cháb i jokʼoltsik ani tam tin achʼaꞌtsik ke na Jesús exom ti watʼel tajaꞌ, in ulutsik kawidh enchéꞌ: ―¡Ajátik, xi kuxlab kʼal an pulek takʼix Dabid, ti ku yajnantsi weye! ");
INSERT INTO husNT2005_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Kʼwiyantsik kʼal an atiklábtsik abal ka chamkʼan, por jajáꞌtsik más kawidh ti dhájaxintsik: ―¡Ajátik, xi kuxlab kʼal an pulek takʼix Dabid, ti ku yajnantsi weye! ");
INSERT INTO husNT2005_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Kubey tám na Jesús, in kaniy an jokʼoltsik ani in konoytsik enchéꞌ: ―¿Jantʼéy a léꞌ tu tʼajtsitsik? ");
INSERT INTO husNT2005_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Jajáꞌtsik tókʼon enchéꞌ: ―Ajátik, ti ku chuꞌxindhaꞌ weye. ");
INSERT INTO husNT2005_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Kóꞌontsattsik tám ti yajnantsixtaláb kʼal na Jesús ani taktsintsik an tin wal. Támkʼi ti chuꞌxin an jokʼoltsik ani in wéwnaꞌtsik na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Tam ti kʼunatichtsik ti kʼwajat Jerusalén ani ulichtsik ban kwentsal xin bij Betfajé, xi kʼwajat kʼunat ban chʼén xin bij Olibos, na Jesús in abaꞌ cháb nin exóbaliltsik ");
INSERT INTO husNT2005_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ani in utsaꞌtsik enchéꞌ: ―Ki kʼaletsik ban kwentsal xi núꞌ kʼwajat tametláb. Tajaꞌ neꞌech ka elaꞌ wikʼats jun i uxum burru ani tajaꞌ jeye kʼwajat in tʼám. Ka wilaꞌ ani ti kin tsiꞌdhantsi. ");
INSERT INTO husNT2005_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ani max ki tawná kʼal jun xitaꞌ, ka utsaꞌtsik abal an Ajátikláb in yéntsal, por jikʼat neꞌech kin witsbaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Jechéꞌ támun abal ka tʼájan xan tin ulúmal an tʼiltsix, tam tin dhutsaꞌ enchéꞌ: ");
INSERT INTO husNT2005_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Ka utsaꞌ an atiklábtsik xu kʼwajíl Sión: “Ka telaꞌ, núꞌich tál na Pulek Takʼíxal, xin chaꞌkál tʼajat tinbáꞌ, punat ba jun i burru, ba jun i burru, in tʼám jun i koꞌnél xu kitandháb.” ");
INSERT INTO husNT2005_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Kʼale tám an exóbaltsik ani in tʼajaꞌ jelt xan ti usnéktsik kʼal na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","In tsiꞌdhaꞌtsik an uxum burru kʼál nin tʼám, in tatlabiy kʼal nin kʼudhkʼúmiltsik ani puney na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ani yán an atiklábtsik xi tajaꞌ ti neꞌech, in nukʼáltsik nin kʼudhkʼúmil ban bél xon ti neꞌech ka watʼey na Jesús ani kʼeꞌettsik in pejál in kʼweꞌél an teꞌ ani in umáltsik ban bél. ");
INSERT INTO husNT2005_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","An atiklábtsik xi neꞌech okʼox ani xi táltsik jeye kuxlek, in ulaltsik kawidh enchéꞌ: ―¡Ajátik, xi kidhtaláb kʼal an pulek takʼix Dabid, ti ku loꞌóch xoꞌ! ¡Lábtʼajadh xi tál tin bij an Okʼóxláb! ¡Okʼóxláb túꞌ walkʼiꞌ, ti ku loꞌóch xoꞌ! ");
INSERT INTO husNT2005_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Tam ti na Jesús ochich Jerusalén, ejtal an atiklábtsik xu kʼwajíl tajaꞌ, xakwan ani yán konoxintsik enchéꞌ: ―¿Jitam jáꞌ jeye jechéꞌ an inik? ");
INSERT INTO husNT2005_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ani an atiklábtsik in ulaltsik enchéꞌ: ―Jechéꞌ jaꞌich an tʼiltsix Jesús, xu kʼwajíl Nasaret, an bitsow xu takʼnal Galilea. ");
INSERT INTO husNT2005_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Tayíl ochich na Jesús ban pulek atá xon tu kʼakʼnáb na Dios ani in káldhaꞌ eléb ejtaltsik xi taꞌ ti kʼwajat tajaꞌ ti nújultsik ani ti chʼaꞌumtsik. In kʼetʼpantsi tin mesajil xi taꞌ ti kʼwajattsik tajaꞌ in jaltsal ti tumín an atiklábtsik. In kʼetʼpantsi jeye tin laktémil an nújul kukuꞌtsik ");
INSERT INTO husNT2005_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","ani in utsaꞌtsik enchéꞌ: ―Ban Tʼokat Dhuslab in ulal enchéꞌ: “Nu kʼimáꞌ abal i ólábkʼi ti bijidh neꞌech ka éyná”; por a wenkʼómalichtsik tin chinkʼontal i kwéꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Tajaꞌ ban pulek atá xon tu kʼakʼnáb na Dios, utukná na Jesús kʼal cháb óx i jokʼoltsik ani i kʼwechʼeꞌtsik ani Jajáꞌ in jeldhaꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Por tam ti an okʼlek páleꞌtsik ani an okʼtsixtsik xin wilál an takʼixtaláb in chuꞌu an labidh labandhaxtaláb xin tʼajál na Jesús ani in achʼaꞌtsik jeye ke an chakamtsik kawidh in ulaltsik enchéꞌ ban pulek atá xon tu kʼakʼnáb na Dios: “¡Kin bachʼu an labidh tʼokattaláb xu kuxlab kʼal an pulek takʼix Dabid!”, chakuytsik ");
INSERT INTO husNT2005_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ani in utsaꞌtsik enchéꞌ na Jesús: ―¿A achʼálxeꞌ xantʼéy in ulal xi jechéꞌ kʼwajattsik? Tókʼoyattsik enchéꞌ kʼal na Jesús: ―U achʼál. ¿Yabxeꞌ a ajyámaltsik ban Tʼokat Dhuslab xan tin ulal kʼal jechéꞌ tin kwenta? In ulal enchéꞌ: A tʼajámal ke xi tsʼitsik ani an chakamtsik xi bél u tsutsul kin ajatnaꞌ alwaꞌ i ajatláb. ");
INSERT INTO husNT2005_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Jilanichtsik tám kʼal na Jesús. Kale tám na Jesús ba jachanꞌ an bitsow, kʼale ban kwentsal xi Betania ani tajaꞌ tin watʼnaꞌ an akal. ");
INSERT INTO husNT2005_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Tam ti dhajaw, tam ti neꞌchich juní ban bitsow, na Jesús in achʼaꞌ u kʼaꞌíl. ");
INSERT INTO husNT2005_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","In chuꞌu jun akanlek i igo bin wál an bél, utey tajaꞌ, por yab in eltsi ni jun in walíl, tokot in xekél. Utsan tám kʼal na Jesús jachanꞌ nin akan an igo: ―¡Yab jaykʼi neꞌech ki witsiy ta walim! Ani támkʼi ti wayey jachanꞌ nin akan an igo. ");
INSERT INTO husNT2005_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Tam ti an exóbaltsik in chuꞌu jechéꞌ, labantsik tʼajat ani in konoytsik enchéꞌ na Jesús: ―¿Jantʼókʼi ti jikʼat tʼajat ti wayey nin akan an igo? ");
INSERT INTO husNT2005_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Tókʼoyattsik enchéꞌ kʼal na Jesús: ―Tsubax tu utsáltsik, max i belomtsik ani yab ka jálkʼúkʼliytsik na chalab, yab tokotkʼi neꞌech ka ejto ka tʼajaꞌtsik xowaꞌ a chuꞌu u tʼajtsi nin akan an igo, neꞌech jeye ka ejtotsik ka utsaꞌ jechéꞌ an chʼén: “Ki wixkʼin techéꞌ ani ka petʼnaꞌ tabáꞌ ban pujal” ani anchanꞌ neꞌech ka tʼájan. ");
INSERT INTO husNT2005_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ejtal xowaꞌ ka kontsitsik na Dios, max ka belaꞌtsik ke neꞌech ti pidhaꞌ, neꞌech ka bachʼutsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Tam ti ulich na Jesús ban pulek atá xon tu kʼakʼnáb na Dios, ochich ani okʼtsixin tajaꞌ. Lejat kʼwajat ti okʼtsix, utukná kʼal an okʼlek páleꞌtsik, kʼal nin okʼlékil an judíotsik ani konyat enchéꞌ: ―¿Kʼal jantʼom awiltaláb ta tʼajál jechéꞌ? ¿Jitaꞌ ti pidhámal jechéꞌ an ti awiltaláb? ");
INSERT INTO husNT2005_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Tókʼoyattsik enchéꞌ kʼal na Jesús: ―Neꞌech tu konoytsik jun xataꞌ; max tin tókʼoytsik, neꞌech tám tu utsaꞌtsik neye kʼal jantʼom awiltaláb tu tʼajál jechéꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Jitaꞌ kʼál ti abnék na Juan ti pújal? ¿Kʼal a Dios o kʼal i iniktsik? Tujeytsik tám ti káwlíx jajáꞌkʼitsik ani u útsáxtsik enchéꞌ: ―Max ki ulu ke kʼal a Dios ti abnék, neꞌech tu tókʼoy enchéꞌ: ¿Jantʼókʼi pé tám ti yab a beltsitsik? ");
INSERT INTO husNT2005_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ani max ki ulu ke kʼal i iniktsik, neꞌech ku tʼajtsin xataꞌ yab alwaꞌ kʼal an iniktsik; pos ejtal in beláltsik ke na Juan kʼal a Dios ti abnék ti tʼiltsix. ");
INSERT INTO husNT2005_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Jaxtám tin utsaꞌtsik enchéꞌ na Jesús: ―Yab i choꞌób. Utsantsik tám enchéꞌ kʼal na Jesús: ―Pos yab neye neꞌech tu utsaꞌtsik kʼal jantʼom awiltaláb tu tʼajál jechéꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Utsantsik enchéꞌ kʼal na Jesús: ―¿Jantʼéy a chalpayaltsik kʼal jechéꞌ xowaꞌ neꞌech tu tʼiltsitsik? Jun i inik in koꞌol cháb in chakámiltsik ani in utsaꞌ enchéꞌ jún ti éb: “Chakam, ki kʼale xoꞌ ta tʼojnal xon tu koꞌol tʼayadh an uba.” ");
INSERT INTO husNT2005_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Tókʼon enchéꞌ an chakámláb: “¡Yab u léꞌ!” Por tayíl in jalkʼuy nin chalab ani kʼale an ti tʼojnal. ");
INSERT INTO husNT2005_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Tayíl, kʼale an tátaꞌláb kin chuꞌu xi jún ani in utsaꞌ jeye anílkʼi ani jechéꞌ an chakámláb tókʼon enchéꞌ: “Neꞌech.” Por yab kʼale. ");
INSERT INTO husNT2005_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Jowaꞌ jáꞌ xi jechéꞌ cháb in tʼajaꞌ xowaꞌ in léꞌ an tátaꞌláb? In ulutsik enchéꞌ: ―Xi jidhtal. Utsantsik tám enchéꞌ kʼal na Jesús: ―Tsubax tu utsáltsik, ke xin bachʼwaltsik an jalbixtaláb ani an junkux inik uxumtsik, okʼox neꞌech kin walkaꞌtsik tinbáꞌ ka takʼyat kʼal na Dios ké tatáꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Pos na Juan xu pujax tsích ti okʼtsitsik xan ti yejat ki kʼwajaytsik ani yabtsik a beltsi; por xin bachʼwaltsik an jalbixtaláb ani an junkux inik uxumtsik in beltsitsik jaꞌ. Por tatáꞌtsik, maske a chuꞌúmal jechéꞌ, yab a jilaꞌtsik ta walablom abal ka beltsitsik xowaꞌ in ulu. ");
INSERT INTO husNT2005_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","ʼKa achʼaꞌtsik jeye jechéꞌ kʼeꞌet an junbaxtaláb: Jun i dhabal chabál in tʼayaꞌ yán i akanlek i uba ani in mapuy; in tʼajaꞌ jun i balixtaláb abal kin watʼiy tajaꞌ an uba ani jun i púnchéy abal kin beletnaꞌ tajaꞌ an ubalom. ʼTayíl in matintsi jachanꞌ an ti aleláb kʼeꞌet i tʼojnaltsik ani jajáꞌ kʼale ów ti belal. ");
INSERT INTO husNT2005_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Tam tin bajaw xowkʼi neꞌech ti pitnal an uba, in abaꞌ cháb óx in tʼojnáliltsik abal kin kontsi jachanꞌ an tʼojnaltsik xowaꞌ in lujyal kin bachʼu an dhabal aleláb. ");
INSERT INTO husNT2005_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Por an mat chabáltsik in yakʼwaꞌ nin tʼojnáliltsik an dhabal aleláb, jún in chaꞌaw, jún in chemdhaꞌ ani jún in tʼujbay. ");
INSERT INTO husNT2005_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","An dhabal aleláb in abaꞌ juní más yán i tʼojnaltsik ké tam tin jidhtal; por ejtaltsik yab bachʼwat alwaꞌ kʼal an mat aleláb. ");
INSERT INTO husNT2005_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","ʼTin okʼontal in abaꞌ nin chakámil, kom in chalpay enchéꞌ: “Neꞌech xónaꞌ kin kʼakʼnantsat tu chakámil.” ");
INSERT INTO husNT2005_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Por tam tin chuꞌutsik an chakámláb, an mat aleláb útsáxintsik enchéꞌ: “Jechéꞌ jaꞌich xi neꞌech ti dhabal tayíl, wana ki chemdhaꞌ abal wawáꞌ ki dhabalnaꞌ an aleláb.” ");
INSERT INTO husNT2005_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Jaxtám tin yakʼwaꞌtsik, in káldhaꞌ eléb aleláb ani in chemdhaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Konyattsik tám enchéꞌ kʼal na Jesús: ―Pos tam ka tsích an dhabal aleláb, ¿jantʼéy neꞌech ka tʼajtsintsik jachanꞌ an mat aleláb? ");
INSERT INTO husNT2005_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Utsantsik enchéꞌ: ―Neꞌech kin chemdhaꞌ jachanꞌ an atʼax mat aleláb ani neꞌech kin matintsi kʼeꞌet i tʼojnaltsik jachanꞌ an ti aleláb, xi ka pidhan kʼál xowaꞌ jajáꞌ in lujyal kin bachʼu tam kin bajaw xowkʼi neꞌech ti pitnal an uba. ");
INSERT INTO husNT2005_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Utsantsik tám enchéꞌ kʼal na Jesús: ―¿Yabxeꞌ jaykʼi a ajyámaltsik ban Tʼokat Dhuslab xin ulal enchéꞌ?: An tʼujub xi pojká kʼal an kúbal atátsik, jaꞌich nin bajaw ka kʼwajay más ultaláb. Jechéꞌ in tʼajámal an Okʼóxláb ani wawáꞌ i chuꞌtal jelti jun i pulek labandhaxtaláb. ");
INSERT INTO husNT2005_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Jaxtám tu utsáltsik, ke yab neꞌech ki kóꞌyattsik takʼnél kʼal na Dios; tokot neꞌech ka kʼwajaytsik takʼnél kʼal na Dios, xitaꞌ kin tʼajaꞌ xowaꞌ in léꞌ na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Xitaꞌ ka kwajlan ba jechéꞌ an tʼujub neꞌech ka muꞌkan ani xitaꞌ ka tʼuꞌchiyat kʼál, neꞌech ka jilan jelti pojodh. ");
INSERT INTO husNT2005_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Tam ti an okʼlek páleꞌtsik ani an fariseotsik in achʼaꞌ an junbaxtaláb xin ulu na Jesús, in exbaytsik ke jajáꞌtsik kʼwajat ti tʼilnal. ");
INSERT INTO husNT2005_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","In leꞌnaꞌtsik tám kin yakʼwaꞌ, por in jikʼnáltsik an atikláb, kom an atiklábtsik in belál ke na Jesús kʼal a Dios ti abnék ti tʼiltsix. ");
INSERT INTO husNT2005_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","In óntsi tám juní ti káw na Jesús kʼal i junbaxtalábkʼi ani in utsaꞌtsik enchéꞌ: ");
INSERT INTO husNT2005_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―Xan tu takʼix na Dios in junwal jelti jun i tomkixtaláb xi jun i pulek takʼix in tʼajaꞌ abal nin chakámil. ");
INSERT INTO husNT2005_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","In abaꞌ nin tʼojnáliltsik abal kin kaniy xi kʼwajatichtsik kanidh, por jechéꞌtsik yab in leꞌnaꞌ ka kʼale. ");
INSERT INTO husNT2005_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","In abaꞌ juní kʼeꞌet nin tʼojnáliltsik ani in utsaꞌ enchéꞌ: “Ka utsaꞌ xi kʼwajatichtsik kanidh abal tʼojojodhich u koꞌol an kʼapnél. Ka utsaꞌ abal chemdhatsich an bákatsik, an koꞌnéltsik xi kʼosdhaꞌ ani ejtalich kʼwajat tʼojojodh; ka utsaꞌ abal ka tsíchichtsik.” ");
INSERT INTO husNT2005_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Por xi kanidhtsik yab in tʼajaꞌ ti kʼij. Jún kʼale bin ale, jún kʼale xon tin tʼajál nin álimtal ");
INSERT INTO husNT2005_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ani xi kʼeꞌettsik, in yakʼwaꞌ nin tʼojnáliltsik an pulek takʼix, in atʼax tʼajtsitsik ani in chemdhaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Tam ti an pulek takʼix in achʼaꞌ jechéꞌ, chakuy tʼajat ani in abaꞌ nin soldadojiltsik kin chemdhaꞌ jachanꞌ an chemdhax iniktsik ani abal kin tsiktsi tin bitsówil. ");
INSERT INTO husNT2005_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Tayíl in utsaꞌ enchéꞌ nin tʼojnáliltsik: “Ejtalich kʼwajat tʼojojodh abal an tomkixtaláb, por jachanꞌ xi kanidhtsik yab xónaꞌ in tomnál ka tsích. ");
INSERT INTO husNT2005_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Pos ki kʼaletsik pé xon tu xayꞌmanal an bél ani ka kaniy ban tomkixtaláb ejtalkʼi xitaꞌ ka elaꞌtsik.” ");
INSERT INTO husNT2005_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Kale tám an tʼójontsixtsik ban bél ani in junku ejtal xin elaꞌtsik, xi alwaꞌ iniktsik ani xi atʼax iniktsik. Anchanꞌ ti tsʼutsich an altá kʼal an atiklábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","ʼOchich tám an pulek takʼix kin chuꞌu xi kanidhtsik ani in chuꞌu jun i inik xi taꞌ jeye ti kʼwajat, por yab xeketlidh jelt xan tu xeketlinal jun xitaꞌ xu kʼalel ba jun i tomkixtaláb. ");
INSERT INTO husNT2005_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ani in utsaꞌ enchéꞌ: “Jaꞌúb, ¿jan ta ochenek techéꞌ ani yab i xeketlidh jelt xan tu xeketlinal jun xitaꞌ xu kʼalel ba jun i tomkixtaláb?” Por yab tʼajat xataꞌ in ulu. ");
INSERT INTO husNT2005_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","An pulek takʼix in utsaꞌ tám enchéꞌ xi kʼwajattsik ti tʼojojól: “Ka wikʼaꞌ bin akan ani bin kʼubak ani ka káldhaꞌ eléb ban jikʼwaxtaláb, xon ti neꞌech ti ukʼnal ani ti rechʼechʼél nin kamab.” ");
INSERT INTO husNT2005_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Pos yán tʼajat xi kanidhtsik, por wéꞌ tʼajat xi takudhtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Kʼale tám an fariseotsik ani in tʼajaꞌ i káw abal kin aliy xan ti kin uwaꞌtsik kin tʼajaꞌ kin ulu jun xataꞌ yab alwaꞌ na Jesús ani anchanꞌ kin ejto kin ólnaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Jaxtám tin abaꞌ cháb óx nin kidhtaltsik junax kʼal nin kidhtaltsik jeye na Erodes ani utsan enchéꞌ na Jesús: ―Okʼtsix, i choꞌób abal tsubax xowaꞌ a ulal ani a okʼtsixnál in lujtalkʼi xan tu takʼix na Dios ani yab a ódhál ti kwenta xantʼéy in ulal an iniktsik, pos yab a telál an iniktsik eblidhkʼi. ");
INSERT INTO husNT2005_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Pos ti ku utsaꞌ: ¿Alwaꞌxeꞌ ki pidhaꞌ ti jalbixtaláb an lej pulek takʼix romano o yabaꞌ? ");
INSERT INTO husNT2005_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Por na Jesús in chuꞌu abal kʼwajatkʼi ti taktamiyáb ani in utsaꞌtsik enchéꞌ: ―Kʼambixtsik, ¿jantʼókʼi tin taktamiyaltsik? ");
INSERT INTO husNT2005_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ti kin óltsi jun i patʼál tumín xi kʼál tu tʼajnal an jalbixtaláb. Pidhan tám jun i denario. ");
INSERT INTO husNT2005_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Konyattsik tám enchéꞌ kʼal na Jesús: ―¿Jitaꞌ in wal ani in bij xi jechéꞌ kʼwajat chʼilbadh? ");
INSERT INTO husNT2005_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Tókʼoyat enchéꞌ: ―An lej pulek takʼix romano. Utsantsik tám enchéꞌ kʼal na Jesús: ―Pos ka pidhaꞌ an lej pulek takʼix romano xowaꞌ in lujyal kin bachʼu ani ka pidhaꞌ na Dios xowaꞌ Jajáꞌ in lujyal kin bachʼu. ");
INSERT INTO husNT2005_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Tam tin achʼaꞌtsik jechéꞌ, labantsik tʼajat. Jilan tám na Jesús ani kʼaletsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Jayéchkʼi jachanꞌ a kʼítsá, kʼale ti álnáb na Jesús kʼal cháb óx i saduseotsik. Jechéꞌ an saduseotsik, in ulal ke an chemélomtsik yabich u ejel ti ít; jaxtám ti konyat enchéꞌ na Jesús: ");
INSERT INTO husNT2005_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","―Okʼtsix, na Moisés in ulu ke max jun i tomkidh inik ka chemech ani yab kin jilaꞌ i chakamtsik, nin kidháb yejat ka tomkin kʼal jachanꞌ an chemtsidh mímláb abal kin kóꞌoy i chakamtsik jelti max in chakámil nin kidháb xi chemech. ");
INSERT INTO husNT2005_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Pos alwaꞌich, kʼal wawáꞌ táꞌwiꞌik ti kʼwajat búk i kwitóltsik in kidhábkʼitsik. Xi jidhtal tomkin ani chemech. Kom yab in jilaꞌ in chakámiltsik, in jiltsi an tin tomtal nin chabtal kidháb. ");
INSERT INTO husNT2005_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Anchanꞌ jeye ti támun kʼal xin chabtal, kʼal xin oxtal ani anchanꞌ ti támun kʼal xi búk an kwitóltsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Más tayíl chemech jeye an mímláb. ");
INSERT INTO husNT2005_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Tam ka ejech ti ít an chemélomtsik, ¿Kʼal jowaꞌ jáꞌ xi búk an kwitóltsik ti neꞌech ti tomikláb jachanꞌ an mímláb, abal ejtal an kwitóltsik in tomiknámal? ");
INSERT INTO husNT2005_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Tókʼoyattsik enchéꞌ kʼal na Jesús: ―Tatáꞌtsik i ukʼpinék tʼajat ta kʼwajat, abal yab a exláltsik an Tʼokat Dhuslab nibal nin cháp na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Pos tam ka ejech ti ít an chemélomtsik, yabich neꞌech ti tomkinaltsik nibal neꞌech ti pidhnáb xitaꞌ abal ka tomkin, pos neꞌech ka kʼwajaytsik jelti nin tʼokat abatwálejiltsik na Dios xi kʼwajattsik walkʼiꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Por kʼal tin kwenta max u ejel ti ít an chemélomtsik, ¿yabxeꞌ a ajyámaltsik xan ti na Dios tin ulu, tam tin ulu enchéꞌ?: ");
INSERT INTO husNT2005_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Nanáꞌ tin Diosil na Abraham, na Isák ani na Jakob.” Na Dios yab in Diosil i chemélomtsik, in Diosil xi kʼwajattsik ejat. ");
INSERT INTO husNT2005_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Tam ti an atiklábtsik in achʼaꞌ jechéꞌ, labantsik tʼajat xan tin achʼaꞌ u okʼtsix na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Tam ti an fariseotsik in choꞌóbnaꞌ abal na Jesús tókʼnék in lujtalkʼi ani an saduseotsik yab in elaꞌ xan ti ka tókʼon, junkun an fariseotsik ");
INSERT INTO husNT2005_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","ani jún ti éb xin wilál nin takʼixtal na Dios, in leꞌnaꞌ kin taktamiy. Jaxtám tin konoy enchéꞌ: ");
INSERT INTO husNT2005_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―Okʼtsix, ¿jowaꞌ jáꞌ an takʼixtaláb xi más uluts xi kʼwajat dhutsadh bin takʼixtal na Dios xin jilám dhutsadh na Moisés? ");
INSERT INTO husNT2005_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Tókʼoyat enchéꞌ kʼal na Jesús: ―“Ka kʼakʼnaꞌ an Okʼóxláb na Diosil kʼal ejtal na itsích, kʼal ejtal na ejattal ani kʼal ejtal na chalab.” ");
INSERT INTO husNT2005_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Jechéꞌ jaꞌich an takʼixtaláb xi más uluts ani xi más ultaláb. ");
INSERT INTO husNT2005_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Nin chabtal, in junwal jeye jelti xin jidhtal: “Ka kʼanidhaꞌ xi kʼeꞌettsik jelt xan ta kʼanidhál tabáꞌ.” ");
INSERT INTO husNT2005_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Jechéꞌ cháb an takʼixtaláb jaꞌich nin tujtal ejtal nin takʼixtal na Dios xin jilám dhutsadh na Moisés ani xin jilám dhutsadh an tʼiltsixtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Lejat an fariseotsik bél taꞌ ti kʼwajat juniniꞌ, ");
INSERT INTO husNT2005_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","konyattsik enchéꞌ kʼal na Jesús: ―¿Jantʼéy a chalpayaltsik kʼal tin kwenta an Kristo? ¿Kʼal jitaꞌ kʼál tu chakámláb? Tókʼoyat enchéꞌ: ―Kʼal an pulek takʼix Dabid. ");
INSERT INTO husNT2005_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Utsantsik tám enchéꞌ kʼal na Jesús: ―¿Jantʼókʼi pé tám na Dabid, ti ijtsiyat kʼal an Tʼokat Ejattaláb kin bijiy tin Ajátik? Abal na Dabid in ulu enchéꞌ: ");
INSERT INTO husNT2005_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","An Okʼóxláb in utsaꞌ enchéꞌ nu Ajátik: “Ki buxkan tu eját, asta ke Nanáꞌ tu átantsi ejtal xi ti atʼál.” ");
INSERT INTO husNT2005_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Pos max an pulek takʼix Dabid in bijiy tin Ajátik an Kristo, ¿jantʼókʼi pé tám ta ulaltsik ke an Kristo u chakámláb kʼal na Dabid? ");
INSERT INTO husNT2005_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ani kʼal ni jun xitaꞌ ti ejtowat ka tókʼoyat ani asta tam ti tám, jikʼeytsik ani ni jun xitaꞌ más konoxin xataꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Utsan tám enchéꞌ an atiklábtsik ani an exóbaltsik kʼal na Jesús: ");
INSERT INTO husNT2005_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","―An fariseotsik ani an okʼtsixtsik xin wilál nin takʼixtal na Dios xin jilám dhutsadh na Moisés, in koꞌoltsik i awiltaláb abal kin wilaꞌ nin takʼixtal na Dios xin jilám dhutsadh na Moisés. ");
INSERT INTO husNT2005_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Jaxtám, ka exbantsitsik ani ka tʼajaꞌ ejtal xowaꞌ kin ulutsik; por yab ka wéwnaꞌ xowaꞌ in tʼajáltsik, pos jajáꞌtsik in okʼtsixnál jun xataꞌ ani kʼeꞌet xowaꞌ in tʼajál. ");
INSERT INTO husNT2005_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Pos in okʼtsixnáltsik xataꞌ xi tʼojláb tʼajat ani in utsál an atiklábtsik kin tʼajaꞌ; por jajáꞌtsik yab in tʼajál nibal elaꞌ wéꞌ, jelt tam jun xitaꞌ in tʼajál jun i kitáláb altsik ani in kitáyal xi kʼeꞌettsik, por jajáꞌtsik nibal elaꞌ in léꞌ kin takaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ejtal xowaꞌ in tʼajáltsik, in tʼajál abal ka chuꞌtat kʼal an atiklábtsik. Pos in kulbetnáltsik kin chʼatʼaꞌ bin píkʼib ani bin okób wetsik an Tʼokat Dhuslab, dhutsadh ba juntsik pejeꞌ i kʼudhkʼum. In kʼwajbáltsik in kʼudhkʼúmil kʼal más nakdhaꞌ in dhutseꞌlíl ké xi kʼeꞌet an atiklábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Xon tu tʼajnal i kʼapúxnich, in kulbetnáltsik ka buxkan xon ti más ultaláb ani ban atátsik xon tu tʼajnal an junkuntaláb, in kulbetnáltsik ka buxkan ban kʼwajtaláb xi ultaláb. ");
INSERT INTO husNT2005_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","In kulbetnáltsik ka chapnédhá ti bél kʼal an atiklábtsik kʼal yantam i kʼakʼnaxtaláb ani ka bijyat ti okʼtsixtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","ʼPor tatáꞌtsik yab yejat ka leꞌnaꞌ ke an atiklábtsik ti bijiy ta okʼtsix, pos jún tokot i Okʼtsix a koꞌoltsik, jaꞌich an Kristo. Ani ejtal tatáꞌtsik a kidhábkʼitsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Yab ka bijiy ta tátaꞌ ni jun xitaꞌ xi techéꞌ ti chabál, pos jún tokot a Tátaꞌ a koꞌoltsik, xi kʼwajat walkʼiꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Nibal yejat ka walkaꞌtsik ki bijyat ta okʼlek, pos jún tokot i okʼlek waꞌach, jaꞌich an Kristo. ");
INSERT INTO husNT2005_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Xitaꞌ in tʼójontsal xi kʼeꞌet, jaꞌich xi más ultaláb kʼal tatáꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Pos xitaꞌ kin tʼekʼaꞌ tinbáꞌ, neꞌech ka chaꞌká ani xitaꞌ kin chaꞌkaꞌ tinbáꞌ, neꞌech ka tʼekʼbá. ");
INSERT INTO husNT2005_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","ʼ¡Chʼojontál a chuꞌbíl okʼtsixtsik ani fariseotsik xi kʼambix! Abal yab a walkál xi kʼeꞌettsik ka kʼwajách takʼnél kʼal na Dios. Pos nibal tatáꞌtsik yab a léꞌ ki kʼwajay takʼnél kʼal na Dios ani nibal a walkál xi kʼeꞌettsik ka kʼwajay takʼnél kʼal na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","ʼ¡Chʼojontál a chuꞌbíl okʼtsixtsik ani fariseotsik xi kʼambix! Abal a kʼántsal tin kʼimáꞌ an chemtsidh mímlábtsik ani tayíl, abal ki utsan ke i alwaꞌ iniktsik, a tʼajáltsik i nakdhaꞌ óláb. Jaxtám ti más púlek an yajtsiktaláb neꞌech ka bachʼutsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","ʼ¡Chʼojontál a chuꞌbíl okʼtsixtsik ani fariseotsik xi kʼambix! Tatáꞌtsik a lonyal i chabál ani i pujal abal ka okʼtsi jun xitaꞌ na belomtal ani tam ki beltsinich kʼal jun xitaꞌ, a tʼajálich ke jachanꞌ an inik ka kʼale más ban kʼibeltaláb ké tatáꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","ʼ¡Chʼojontál a chuꞌbíl, jokʼol junkiltsik! xa ulaltsik enchéꞌ: “Max jun xitaꞌ kin lej tsubkʼaꞌ jun xataꞌ kʼal tin bij an pulek atá xon tu kʼakʼnáb na Dios, yab xataꞌ; por max kin lej tsubkʼaꞌ jun xataꞌ kʼal tin bij an oro xi kʼwajat tajaꞌ, yejat tám kin tʼajaꞌ xowaꞌ in ulu.” ");
INSERT INTO husNT2005_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡I kʼwajattsik jelti max i jokʼol ani yab i chalpadh! Pos ¿jowaꞌ más uluts: an oro, o an pulek atá xon tu kʼakʼnáb na Dios xin tʼokwal an oro? ");
INSERT INTO husNT2005_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ani a ulaltsik jeye enchéꞌ: “Max jun xitaꞌ kin lej tsubkʼaꞌ jun xataꞌ kʼal tin bij xon tu kʼwajbáb an pikbaxtaláb, yab xataꞌ; por max kin lej tsubkʼaꞌ jun xataꞌ kʼal tin bij an pikbaxtaláb xi tajaꞌ kʼwajat, yejat tám kin tʼajaꞌ xowaꞌ in ulu.” ");
INSERT INTO husNT2005_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡I kʼwajattsik jelti max i jokʼol ani yab i chalpadh! Pos ¿jowaꞌ más uluts: an pikbaxtaláb, o xon tu kʼwajbáb an pikbaxtaláb xin tʼokwal an pikbaxtaláb? ");
INSERT INTO husNT2005_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Pos xitaꞌ in lej tsubkʼál jun xataꞌ kʼal tin bij xon tu kʼwajbáb an pikbaxtaláb, yab tokotkʼi kʼwajat in lej tsubkʼál jun xataꞌ kʼal tin bij xon tu kʼwajbáb an pikbaxtaláb, kʼálich jeye xowaꞌ kʼwajat tajaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Xitaꞌ kin lej tsubkʼaꞌ jun xataꞌ kʼal tin bij an pulek atá xon tu kʼakʼnáb na Dios, yab tokotkʼi kʼwajat in lej tsubkʼál jun xataꞌ kʼal tin bij an atá xon tu kʼakʼnáb na Dios, in lej tsubkʼálich jeye kʼal na Dios xi kʼwajat tajaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Aníl jeye, xin lej tsubkʼál jun xataꞌ kʼal tin bij an walkʼiꞌ, in lej tsubkʼálich jeye kʼal tin bij nin tʼokat kʼwajtal na Dios ani kʼal na Dios jeye, kom tajaꞌ u buxkanal. ");
INSERT INTO husNT2005_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","ʼ¡Chʼojontál a chuꞌbíl okʼtsixtsik ani fariseotsik xi kʼambix! Tatáꞌtsik a pidhál na Dios xowaꞌ in lujyal kin bachʼu kʼal an menta, an anís ani an komino, por yabtsik a tʼajál ti kʼij an takʼixtaláb xi más uluts, ke jaꞌich an lujattaláb, an yajnantsixtaláb ani ka belaꞌtsik na Dios. Jechéꞌ jaꞌich yejat ka tʼajaꞌtsik, por yab ka jilaꞌ ka pidhaꞌ xowaꞌ in lujyal na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Tatáꞌtsik, jokʼol junkiltsik, a tʼajáltsik xowaꞌ xi yab lej uluts, por yab a tʼajáltsik xowaꞌ xi más uluts. In junwal jelti max a dhikáltsik an chiꞌchim abal yab ka kʼutʼu, por jelti max a kʼutʼwaltsik an koꞌnél xin bij kameyo! ");
INSERT INTO husNT2005_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","ʼ¡Chʼojontál a chuꞌbíl okʼtsixtsik ani fariseotsik xi kʼambix! Tatáꞌtsik a junwal jelti an baso ani an talab xi eblidhkʼi ti tʼakadh, abal alkʼidh ta itsích tokot a chalpómtsik an kwéꞌlách ani ka tʼajaꞌ xowaꞌ yab lujat. ");
INSERT INTO husNT2005_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Fariseotsik, tatáꞌtsik a junwal jelti max i jokʼol, okʼox ka tʼaktsi alkʼidh na basojil, na talábil ani tʼokatich jeye tám neꞌech ka jilkʼon xi eblidh. ");
INSERT INTO husNT2005_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","ʼ¡Chʼojontál a chuꞌbíl okʼtsixtsik ani fariseotsik xi kʼambix! Pos a junwaltsik jelti an jólimtaláb xi mukudh ani labidh u xalkʼanal eblidhkʼi, por alkʼidh tsʼutsat kʼal in beklék i chemélomtsik ani kʼal xowaꞌkichkʼi i atʼaxtaláb. ");
INSERT INTO husNT2005_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Anchanꞌtsik teye, eblidh, jelti max i lujat iniktsik, por alkʼidh ta itsích tokot a chalpómtsik i kʼambixtaláb ani i walastaláb. ");
INSERT INTO husNT2005_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","ʼ¡Chʼojontál a chuꞌbíl okʼtsixtsik ani fariseotsik xi kʼambix! Tatáꞌtsik a lejkintsal xon ti jolidh an tʼiltsixtsik ani a dhibyal nin chʼilábil an lujat iniktsik, ");
INSERT INTO husNT2005_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","ani a ulaltsik enchéꞌ: “Max techéꞌak tu kʼwajat tam ti xeꞌchinék ni wejeꞌ pakéliltsik, yabak i tolmiyámal kin chemdhaꞌ an tʼiltsixtsik.” ");
INSERT INTO husNT2005_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Kʼal jechéꞌ, a ulalichtsik abal a kidhtal xin chemdhámal an tʼiltsixtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","¡Pos ka okʼóchtsik ka tʼajaꞌ xowaꞌ in tujúmal na wejeꞌ pakéliltsik! ");
INSERT INTO husNT2005_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","ʼ¡Tatáꞌtsik a kidhtal jelti an chan! Yab neꞌech ka ejto ka jekʼaꞌtsik abal yab ki kʼale ban kʼibeltaláb. ");
INSERT INTO husNT2005_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Jaxtám, Nanáꞌ neꞌech tu abtsi ti tʼiltsixtsik, ti chalpadhtsik ani ti okʼtsixtsik. Por tatáꞌtsik neꞌech ka chemdhaꞌ, taltsik neꞌech ka pajkʼiytsik ba peltsidh teꞌ, taltsik neꞌech ka chaꞌawtsik ban atá xon tu tʼajnal an junkuntaláb ani neꞌech ka kajnaꞌtsik bitsow ti bitsow. ");
INSERT INTO husNT2005_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Jaxtám, tatáꞌtsik i walbidh kʼal nin chemtal ejtal an lujat iniktsik xi chemdhats, asta tam ti chemdhá na Abel an lujat inik asta na Sakarías nin chakámil na Berekías, xi tatáꞌtsik a chemdhaꞌ tamchʼejélidh ban pulek atá xon tu kʼakʼnáb na Dios kʼal xon tu kʼwajbáb an pikbaxtaláb. ");
INSERT INTO husNT2005_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Tsubax tu utsáltsik, ke ejtal jechéꞌ an walastaláb neꞌech kin kitnaꞌ an atiklábtsik xi jechéꞌ i kʼij. ");
INSERT INTO husNT2005_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","ʼ¡Atiklábtsik xi kʼwajíl Jerusalén, xa chemdhál an tʼiltsixtsik ani a tʼujbayal nin abatwálejiltsik na Dios xi abtsinal! ¡Yánílich tʼajat u leꞌnámal tu junkutsik, jelt xan ti jun i pákʼwlam kwitaꞌ in junkuwal nin tsʼitsik tʼám tin ál in sutsʼútsʼ, por yab a leꞌnaꞌ! ");
INSERT INTO husNT2005_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Pos ka achʼaꞌtsik, an atá xon ta kʼakʼnáltsik na Dios, neꞌech ka jilkʼon walbadh; ");
INSERT INTO husNT2005_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","pos tu utsáltsik ke yabich neꞌech ki witsiy ti kin chuꞌutsik asta kin bajaw an kʼij tam tatáꞌtsik neꞌech ka ulu enchéꞌ: “Lábtʼajadh ti kʼwajat xi tál tin bij an Okʼóxláb.” ");
INSERT INTO husNT2005_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Kale na Jesús ban pulek atá xon tu kʼakʼnáb na Dios ani tam ti neꞌchich, utukná kʼal nin exóbaliltsik ani tujey ti óltsinal xan ti kubadh an pulek atá xon tu kʼakʼnáb na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Por tókʼoyattsik enchéꞌ kʼal na Jesús: ―Xoꞌ a chuꞌtaltsik ejtal jechéꞌ, por tsubax tu utsáltsik ke yab neꞌech ka jilkʼon ni jun i tʼujub tʼíꞌbáx. Ejtal neꞌech ka julpá. ");
INSERT INTO husNT2005_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Kʼaletsik tám ban chʼén Olibos ani tam ti na Jesús tajaꞌ ti buxúl, kʼale ti usnal chinatkʼi enchéꞌ kʼal nin exóbaliltsik: ―Ti ku utsaꞌ, ¿jowkʼi neꞌech ka támun jechéꞌ? ¿Jantʼom exól neꞌech ki chuꞌu tam i tálich ani tam u kʼunelich an pakwenib? ");
INSERT INTO husNT2005_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Tókʼoyattsik tám enchéꞌ kʼal na Jesús: ―Ka kóꞌoytsik i kwenta abal yab ti ki kʼambiytsik ni jun xitaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Pos yán neꞌech ka tsích ti kʼambixtsik ani neꞌech kin ulu ke jajáꞌich nu Kristo ani yán neꞌech kin kʼambiy. ");
INSERT INTO husNT2005_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Neꞌech ka achʼaꞌtsik ke exom i péjéxtaláb ani ke ítich juní neꞌech ka tujey, por yab ki jikʼeytsik. Pos anchanꞌ koꞌol ka támun, por yabél jaꞌich an pakwenib. ");
INSERT INTO husNT2005_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Pos jun i kidhtaláb neꞌech ti péjéx kʼal kʼeꞌet i kidhtaláb ani jun i bitsow neꞌech ti péjéx kʼal kʼeꞌet i bitsow; neꞌech ka waꞌchin i kʼaꞌínab, i yawꞌláchtsik ani neꞌech ka léwékʼin an chabál putálkʼi. ");
INSERT INTO husNT2005_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Por ejtal jechéꞌ jaꞌich nin tujtal an yajtsiktaláb xi neꞌech ka támun. Jelti an chʼukʼuxtaláb xin achʼál jun i mímláb tam neꞌchich kin waꞌchiy i chakam. ");
INSERT INTO husNT2005_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","ʼNeꞌech tám ki pidhnátsik abal ki atʼax tʼajtsin, neꞌech ki chemdhátsik ani neꞌech ki atʼantsik kʼal ejtal an atiklábtsik kʼal Nanáꞌkʼi tu kwenta. ");
INSERT INTO husNT2005_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Tam jachanꞌ i kʼij, yán neꞌech kin jilaꞌtsik ti belom, neꞌech ka chákúxintsik ani neꞌech ka pídhnáxintsik jún ani jún ban awiltaláb. ");
INSERT INTO husNT2005_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Neꞌech ka waꞌchin yán i kʼambix tʼiltsixtsik, xi neꞌech kin ulu ke kʼal a Dios ti abadh ti tʼiltsix ani yán i atiklábtsik neꞌech kin kʼambiy. ");
INSERT INTO husNT2005_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ani kʼal tin kwenta abal neꞌech tʼajat ka waꞌchin xowaꞌ yab alwaꞌ, yán neꞌech kin jilaꞌtsik ti kʼánídháx. ");
INSERT INTO husNT2005_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Por xitaꞌ kin kuxuy ejtal jechéꞌ, neꞌech ka loꞌwat. ");
INSERT INTO husNT2005_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ani jechéꞌ an alwaꞌ tʼilab kʼal tin kwenta xan tu takʼix na Dios, neꞌech ka tʼilan putálkʼi an kʼayꞌlá abal ka exlá kʼal ejtalkʼi an kidhtalábtsik; ani tám neꞌech ka ulchich an pakwenib. ");
INSERT INTO husNT2005_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","ʼXitaꞌ kin ajay jechéꞌ, kin exbay: Tam ka chuꞌutsik an kʼakʼadh atʼaxtaláb xin tʼilámal an tʼiltsix Daniel kʼwajatich xon tu kʼakʼnáb na Dios, ");
INSERT INTO husNT2005_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","tám, xi kʼwajattsik ban chabál xi Judea, ki kʼaletsik ta chinkʼonal ban chʼénlom. ");
INSERT INTO husNT2005_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Xi kʼwajattsik tin éb nin kʼimáꞌ, yab ka paꞌaytsik abal ka ochich kin ikʼiꞌ jun xataꞌ altá; ");
INSERT INTO husNT2005_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","ani xi kʼwajattsik bin ale, yab ka witsiy abal kin ikʼiꞌ nin wát. ");
INSERT INTO husNT2005_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Chʼojontál in chuꞌbíl an mímlábtsik xi ka elan kóꞌodh jachanꞌ i kʼij o u tsutsúdhom! ");
INSERT INTO husNT2005_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ka kontsaltsik na Dios abal yab ka támun jechéꞌ tam chamay nibal tam in kʼítsájil i koyóxnich; ");
INSERT INTO husNT2005_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","pos jachanꞌ i kʼij, neꞌech ka waꞌchin jun i kʼakʼadh yajtsiktaláb xi yab jaykʼi waꞌchinék asta ti tujenek an kʼayꞌlá, nibal más neꞌech ka waꞌchin jaykʼi anchanꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Max na Dios yab kin wéꞌmédhaꞌ jachanꞌ an pulek yajtsiktaláb, yab xitaꞌ neꞌech ka loꞌey; por kʼal tin kwenta in kʼánél xi Jajáꞌ in takwyámal, neꞌech kin wéꞌmédhaꞌ jachanꞌ an kʼij. ");
INSERT INTO husNT2005_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","ʼTam jachanꞌ i kʼij, max jun xitaꞌ ti ki utsaꞌtsik enchéꞌ: “Ka telaꞌ, jéꞌ kʼwajat an Kristo”, o “ka telaꞌ, núꞌ kʼwajat”, yab ka beltsi. ");
INSERT INTO husNT2005_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Pos neꞌech ka waꞌchin i kʼambixtsik xi neꞌech kin ulu ke jajáꞌich nu Kristo, o ke jajáꞌich xi abadh ti tʼiltsix kʼal a Dios. Neꞌech kin tʼajaꞌ i pakdhaꞌ exól ani i pakdhaꞌ labandhaxtaláb abal kin kʼambiy an atiklábtsik ani neꞌech kin leꞌnaꞌ kin kʼambiytsik max kin ejto asta xi takudhichtsik kʼal na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Exomichtsik tu utsál ejtal xowaꞌ neꞌech ka támun. ");
INSERT INTO husNT2005_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Jaxtám, max ki utsantsik enchéꞌ: “Ka telaꞌtsik, núꞌ kʼwajat ban chabál xon ti yab kʼwajtsidh”, yab ki kʼaletsik ka chuꞌu; o max ki utsantsik: “Ka telaꞌtsik, jéꞌ kʼwajat altá”, yab ka belaꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Pos anchanꞌ jelt xan tu lamkʼil an léy asta xon tu kalel na kʼítsá ani asta xon tu ochel, anchanꞌ neye ti neꞌech kin tsích Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik. ");
INSERT INTO husNT2005_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Xon ti kʼwajat an chemélom, tajaꞌ neꞌech ka junkun an tʼottsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","ʼTámkʼi tam ka watʼéch jechéꞌ an yajtsiktaláb, na kʼítsá neꞌech ka jikʼwchin, na íchʼ yab neꞌech ka tajkʼan, na óttsik neꞌech ka kwajlan ani asta an pakdhaꞌ chápláb xi kʼwajat walkʼiꞌ neꞌech ka yoywat. ");
INSERT INTO husNT2005_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Neꞌech tám ka xalkʼan walkʼiꞌ nu exólil Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik. Ejtal an kidhtalábtsik xi yab u belom xi kʼwajattsik ban kʼayꞌlá, neꞌech ka ukʼintsik tam tin chuꞌutsik Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik, in tál ban tokow xi walkʼiꞌ kʼal ejtal nu cháp ani nu labidh tʼokát. ");
INSERT INTO husNT2005_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Neꞌech ku abaꞌ nu tʼokat abatwálejiltsik abal kʼal jun i chapik jutsuxtaláb i korneta kin junku xu takwyámaltsik putálkʼi, asta jun pakʼeꞌ jun pakʼeꞌ an kʼayꞌlá. ");
INSERT INTO husNT2005_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","ʼKa exbaytsik xowaꞌ okʼtsixtaláb in pidhnál an junbaxtaláb kʼal tin kwenta in akan an igo: Tam dhálamich nin kʼweꞌéltsik ani exom ti kalel nin xekél, a choꞌóbichtsik abal exomich ti kʼunel an kʼakʼal kʼij. ");
INSERT INTO husNT2005_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Anchanꞌ jeye, tam ka chuꞌutsik ejtal jechéꞌ, ka choꞌóbnaꞌtsik abal Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik, kʼunatich i kʼij neꞌech kin tsích. ");
INSERT INTO husNT2005_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Tsubax tu utsáltsik, ke ejtal jechéꞌ neꞌech ka támun tam yabél chemnek na kidhtaltsik xi jechéꞌ i kʼij. ");
INSERT INTO husNT2005_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","An chabál ani an walkʼiꞌ neꞌech ka taley, por ejtal xowaꞌ u ulu, anchanꞌ neꞌech ka támun. ");
INSERT INTO husNT2005_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","ʼPor kʼal tin kwenta xowkʼi jun bél ti neꞌech kin tsích, yab xitaꞌ in choꞌób, nibal an tʼokat abatwáletsik xi kʼwajat walkʼiꞌ, nibal nin Chakámil na Dios. Tokot in choꞌób na Dios an Tátaꞌláb. ");
INSERT INTO husNT2005_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","ʼAnchanꞌ xan ti támun tam ti xeꞌchin na Noé, anchanꞌ jeye ti neꞌech ka támun tam kin tsích Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik. ");
INSERT INTO husNT2005_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Jachanꞌ i kʼij, tam ti yabél tujenek an chapik ábal kʼij, an atiklábtsik in óntsal ti kʼapul ani ti uchʼal, ti tomkinaltsik ani ti pidhnax tin chakámiltsik abal ka tomkin, asta tam tin bajaw xowkʼi na Noé ti ochichich ban tan atá; ");
INSERT INTO husNT2005_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","ani yab in exbaytsik asta tam ti ulchich an chapik áb ani chemechtsik ejtal. Anchanꞌ jeye ti neꞌech ka támun tam kin tsích juní Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik. ");
INSERT INTO husNT2005_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Tam jachanꞌ i kʼij, cháb i iniktsik xi kʼwajat ti tʼojnal junax bin ale, jún neꞌech ka júná ani jún neꞌech ka jilan. ");
INSERT INTO husNT2005_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Cháb i mímlábtsik xi kʼwajat ti cheꞌel junax, jún neꞌech ka júná ani jún neꞌech ka jilan. ");
INSERT INTO husNT2005_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","ʼYabtsik pé ki kʼwajay ukʼpipidh kom yab a choꞌóbtsik xowkʼi ti neꞌech kin tsích juní. ");
INSERT INTO husNT2005_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Por ka choꞌóbnaꞌtsik jechéꞌ, ke max jun i dhabal atá in choꞌób xowkʼi jun bél ti neꞌech ka ulich an kwéꞌ, yab neꞌech ka wayich ani yab neꞌech kin walkaꞌ ka ochich an kwéꞌ tin kʼimáꞌ abal ka kwéꞌyat. ");
INSERT INTO husNT2005_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Jaxtám, yab ki kʼwajaytsik teye ukʼpipidh, pos tam yabtsik a tʼílóm, neꞌech kin tsích Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik. ");
INSERT INTO husNT2005_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","ʼ¿Jitam jáꞌ an alwaꞌ tʼójontsix xin tʼajál xowaꞌ ka utsan, xu jilnal kʼal nin ajátik punkʼudh abal kin kʼapundhaꞌ xan ti yejat ejtal xi kʼwajat bin kʼimáꞌ an ajátikláb? ");
INSERT INTO husNT2005_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Kʼijidh abal an tʼójontsix xi ka elan kʼal nin ajátik tam ka witsiy, in tʼajál xowaꞌ jilnék kin tʼajaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Tsubax tu utsáltsik, ke neꞌech ka kʼwajbá kʼal nin ajátik abal kin beletnaꞌ ejtal xowaꞌ in koꞌol an ajátikláb. ");
INSERT INTO husNT2005_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Por max jachanꞌ an tʼójontsix jaꞌich jun i atʼax inik ani kin chalpay ke nin ajátik yab neꞌech ka witsiy jikʼat, ");
INSERT INTO husNT2005_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ka tujey kin atʼax tʼajtsitsik xi kʼeꞌet nin at tʼojnaltsik, ka kʼwajách ti kʼapul ani ti uchʼal kʼal an uchʼáltsik, ");
INSERT INTO husNT2005_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","tam ka witsiy nin ajátik tam yab xataꞌ in tʼílóm, nibal in choꞌób max neꞌech ka witsích, ");
INSERT INTO husNT2005_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","neꞌech ka pidhan jun i yajtsiktaláb púlek kʼal nin ajátik ani neꞌech ka kʼwajbá abal kin tamu jelt xan ti neꞌech kin tamu an kʼambixtsik. Tajaꞌ neꞌech ti ukʼnal ani ti rechʼechʼél nin kamab. ");
INSERT INTO husNT2005_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","ʼXan tu takʼix na Dios, in junwal jelti láju i tsidhantsik xin téynaꞌ i tajbaxtalábtsik xu joltsinal ti gás ani kʼaletsik kin bachʼu an tomkinél inik. ");
INSERT INTO husNT2005_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Bóꞌ xi jajáꞌtsik chalpadh tʼajat ani xi bóꞌ yabaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Xi yabtsik chalpadh, tam tin júnaꞌ nin tajbaxtalábiltsik, yab in júnaꞌtsik i gás abal kin baltsi ti ít tam kin talaꞌ; ");
INSERT INTO husNT2005_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","por xi chalpadhtsik, in júnámaltsik i boteya tsʼutsat kʼal i gás, yab tokotkʼi xi baltsidh nin tajbaxtalábiltsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Kom an tomkinél inik owéch ani yab u ulel, tujey ti onkʼal wayal ejtal an tsidhantsik ani tayíl wayichtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Tam ti chʼejel akalich xónaꞌ, achʼatmé in kawidh káwintal jun xitaꞌ xin ulu kawidh enchéꞌ: “¡Náꞌich tál an tomkinél inik, ki kaletsik ka bachʼu!” ");
INSERT INTO husNT2005_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ejtal jachanꞌ an tsidhantsik chʼakay abal kin tʼojojoy nin tajbaxtalábiltsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Utsan tám enchéꞌ an tsidhantsik xi chalpadh kʼal xi yabtsik chalpadh: “ti ku pidhaꞌ weye wéꞌ an ti gás abal exomich ti tepel ni tajbaxtalábil.” ");
INSERT INTO husNT2005_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Por tókʼon enchéꞌ an tsidhantsik xi chalpadh: “Yabaꞌ, xib yab tám neꞌech ka kidhey abal wawáꞌ nibal abal tatáꞌtsik. Más alwaꞌ ki kʼale ka chʼaꞌaytsik xon tu nujnal ani ka chʼaꞌay abal tatáꞌtsik.” ");
INSERT INTO husNT2005_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Por lejat xi bóꞌ an tsidhantsik kʼalnek ti chʼaꞌum an ti gás, ulich an tomkinél inik. An tsidhantsik xi taꞌ ti kʼwajat tʼojojodhtsik, ochichtsik jaꞌ junax kʼal an tomkinél inik ban tomkixtaláb ani tayíl mapyat an wiꞌleb. ");
INSERT INTO husNT2005_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Tayíl ulich xi bóꞌ an tsidhantsik ani in ulutsik enchéꞌ: “¡Ajátik, ajátik, ti ku japtsi!” ");
INSERT INTO husNT2005_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Por tókʼoyattsik enchéꞌ: “Tsubax tu utsáltsik ke yab tu exlál.” ");
INSERT INTO husNT2005_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Utsantsik tám enchéꞌ kʼal na Jesús: ―Yabtsik pé ki kʼwajay i ukʼpipidh, pos yabtsik a choꞌób xowkʼi jun bél ti neꞌech kin tsích Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik. ");
INSERT INTO husNT2005_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","ʼXan tu takʼix na Dios in junwal jelti jun i inik, xi tam ti neꞌchich ka kʼaléch píl bitsow, in kaniy nin tʼojnáliltsik ani in pidhaꞌtsik ti tumín kin tʼójondhaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","ʼJún ti éb in pidhaꞌ boꞌ mil i patʼál tumín, jún chab mil ani xi jún in pidhaꞌ mil i patʼál tumín; pidhan juntsik ti éb xantikʼi ti chuꞌtat neꞌech kin ejto kin tʼójondhaꞌ ani tayíl, kʼale tám ów ti belal. ");
INSERT INTO husNT2005_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","An tʼójontsix xin bachʼu boꞌ mil i patʼál tumín, in tʼajaꞌ i álimtaláb kʼal an tumín ani in átaꞌ anílkʼi in yaníl. ");
INSERT INTO husNT2005_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","An tʼójontsix xi jiltsin chab mil, anílkʼi jeye tin tʼajaꞌ ani in átaꞌ jeye chab mil más. ");
INSERT INTO husNT2005_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Por xi pidhan tokot mil kʼal nin ajátik, kʼale kin cholkʼaꞌ i chabál ani in taꞌpaꞌ tajaꞌ an tumín. ");
INSERT INTO husNT2005_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","ʼMás tayíl, witsiy nin ajátik jachanꞌ an tʼójontsixtsik ani tujey kin tʼajaꞌ i kwenta kʼal jajáꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ulich okʼox xin bachʼúmal boꞌ mil i patʼál tumín, in pidhaꞌ nin ajátik bél boꞌ mil ani in utsaꞌ enchéꞌ: “Ajátik, boꞌ mil i patʼál tumín tin pidhaꞌ ani jéꞌ kʼwajat boꞌ mil más xu átaꞌ kʼál.” ");
INSERT INTO husNT2005_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Utsan enchéꞌ kʼal nin ajátik: “Alwaꞌ tʼajat, tatáꞌ i alwaꞌ tʼójontsix ani i lujat; kom a tʼójondhaꞌ alwaꞌ xowaꞌ wéꞌ tu pidhaꞌ, neꞌech tu pidhaꞌ más. Ki ochich ani ki kulbé kʼal nanáꞌ.” ");
INSERT INTO husNT2005_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Tayíl ulich jeye an tʼójontsix xin bachʼúm chab mil i patʼál tumín ani in ulu enchéꞌ: “Ajátik, tin pidhaꞌ chab mil i patʼál tumín ani jéꞌ kʼwajat chab mil más xu átaꞌ kʼál.” ");
INSERT INTO husNT2005_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Utsan enchéꞌ kʼal nin ajátik: “Alwaꞌ tʼajat, tatáꞌ i alwaꞌ tʼójontsix ani i lujat; kom a tʼójondhaꞌ alwaꞌ xowaꞌ wéꞌ tu pidhaꞌ, neꞌech tu pidhaꞌ más. Ki ochich ani ki kulbé kʼal nanáꞌ.” ");
INSERT INTO husNT2005_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Por tam ti ulich an tʼójontsix xin bachʼúmal mil i patʼál tumín, in utsaꞌ enchéꞌ nin ajátik: “Ajátik, nanáꞌ u choꞌób abal tatáꞌ kidhat tʼajat a konyal, ke i kʼójol xon ti yab i ómámadh ani a junkuwal nin walíl an tʼayabláb xon ti yab a bukʼúmal i iyaláb. ");
INSERT INTO husNT2005_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Jaxtám tu jikʼnaꞌ, in kʼale ani u joliy na tumínal al chabál. Por jéꞌ kʼwajat xi tin pidhámal.” ");
INSERT INTO husNT2005_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Tókʼoyat enchéꞌ kʼal nin ajátik: “Atʼax tʼojnal ani óbe, max a choꞌóbich abal in kʼójol xon ti yab in ómámadh ani u junkuwal nin walíl an tʼayabláb xon ti yab u bukʼúmal i iyaláb, ");
INSERT INTO husNT2005_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","¿jantʼókʼi ti yab a kʼwajbaꞌ nu tumínal xon tu tʼójondháb abal tam kin witsiy, ku bachʼu nu tumínal kʼálich xowaꞌ in átámal?” ");
INSERT INTO husNT2005_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Utsan tám enchéꞌ kʼal an ajátikláb xi taꞌ ti kʼwajattsik: “Ka kʼántsi xin koꞌol mil an patʼál tumín ani ka pidhaꞌ xin koꞌol láju i mil. ");
INSERT INTO husNT2005_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Pos xitaꞌ xin koꞌol, neꞌech ka pidhan ani neꞌech kin kóꞌoy más yán; por xi yab in koꞌol, neꞌech ka kʼántsin asta xowaꞌ in chalpayal in koꞌol. ");
INSERT INTO husNT2005_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ani jechéꞌ an tʼójontsix xi yab xataꞌ ti alwaꞌ, ka káldhaꞌ eléb ban jikʼwaxtaláb, xon ti neꞌech ti ukʼnal ani ti rechʼechʼél nin kamab.” ");
INSERT INTO husNT2005_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","ʼTam Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik kin tsích kʼal ejtal nu labidh tʼokát ani kʼal ejtal nu tʼokat abatwálejiltsik, tám neꞌech kin buxkan bu labidh tʼokat kʼwajtalábil abal tin takʼix. ");
INSERT INTO husNT2005_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ejtal an atiklábtsik neꞌech ka junkun tu tamét ani tám neꞌech ku takuytsik, jelt xan ti an belkol borrego in kʼwajbál píl an borregotsik ani píl jeye an chibotsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Neꞌech kin kʼwajbaꞌ an borregotsik tin eját ani an chibotsik tin kʼwatab. ");
INSERT INTO husNT2005_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","An Pulek Takʼix neꞌech tám kin utsaꞌ enchéꞌ xi kʼwajattsik tin eját: “Jalaꞌichtsik, xi lábtʼajadhichtsik kʼal nu Tátaꞌ ani ka bachʼúchtsik xon ti neꞌech ta takʼix, xi bijtsidhich neꞌech ka takʼiy asta tam ti tujeykʼi an kʼayꞌlá. ");
INSERT INTO husNT2005_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Pos in kʼaꞌay ani tin kʼapundhaꞌtsik; in tsikey ani tin pidhaꞌtsik ti jaꞌ; in xeꞌchin jelti píl inik ani tin koydhaꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","U yéntsi u kʼudhkʼúmil ani tin pidhaꞌtsik; in yawꞌlách ani tin álnaꞌtsik; in wikʼan ani i kʼaletsik ti kin álnaꞌ.” ");
INSERT INTO husNT2005_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Xi lujattsik neꞌech tám kin ulutsik enchéꞌ: “Ajátik, ¿jowkʼi ta kʼaꞌinek ani tu kʼapundhámal? O ¿jowkʼi ta tsikenek ani tu pidhámal ti jaꞌ? ");
INSERT INTO husNT2005_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Jowkʼi ta xeꞌchinék jelti píl inik ani tu koydhámal? O ¿a yéntsámal a kʼudhkʼúmil ani tu pidhámal? ");
INSERT INTO husNT2005_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Jowkʼi ta yawꞌlámadh o i wikʼnék ani u kʼalnek tu álnaꞌ?” ");
INSERT INTO husNT2005_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ani neꞌech ka tókʼoyattsik enchéꞌ kʼal an Pulek Takʼix: “Tsubax tu utsáltsik, ke ejtal xowaꞌ a tʼajtsi jún nu at kidhábtsik, maske yab lej ultaláb, Nanáꞌ tin tʼajtsámaltsik.” ");
INSERT INTO husNT2005_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","ʼAn Pulek Takʼix neꞌech jeye tám kin utsaꞌ enchéꞌ xi kʼwajattsik tin kʼwatab: “Ki wixkʼintsik techéꞌ kʼal Nanáꞌ, atiklábtsik xi atʼax; ki kʼaléchtsik ban kʼamal xi yab jaykʼi u tepel xi kʼwajat tʼojojodh abal an lej atʼax ani abal nin tʼójontsixiltsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Pos in kʼaꞌay ani yab tin kʼapundhaꞌtsik; in tsikey ani yabtsik tin pidhaꞌ ti jaꞌ; ");
INSERT INTO husNT2005_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","in xeꞌchin jelti píl inik ani yabtsik tin koydhaꞌ. U yéntsi u kʼudhkʼúmil ani yabtsik tin pidhaꞌ; in yawꞌlách ani in wikʼan ani yabtsik i kʼale tin álnaꞌ.” ");
INSERT INTO husNT2005_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Neꞌech tám kin ulutsik jeye enchéꞌ: “Ajátik, ¿jowkʼi ta xeꞌchinék ta kʼaꞌíl, ta tsikél, jelti píl inik, a yéntsal a kʼudhkʼúmil, ta yaꞌul, o ta wikʼnél ani yab tu tolmiyámal?” ");
INSERT INTO husNT2005_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ani neꞌech ka tókʼoyattsik enchéꞌ kʼal an Pulek Takʼix: “Tsubax tu utsáltsik, ke ejtal xowaꞌ yab a tʼajtsi ni jun xitaꞌ, maske jaꞌich xi yab lej ultaláb, yab jeye tin tʼajtsámaltsik Nanáꞌ.” ");
INSERT INTO husNT2005_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Jechéꞌtsik neꞌech ban yajtsiktaláb ani xi lujattsik neꞌech kin bachʼu an xeꞌchintaláb xi yab in koꞌol in okʼontal. ");
INSERT INTO husNT2005_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Tam ti na Jesús in okʼoy kin ulu ejtal jechéꞌ, in utsaꞌ enchéꞌ nin exóbaliltsik: ");
INSERT INTO husNT2005_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―Jelt xan ta choꞌóbichtsik, téꞌ cháb a kʼítsá neꞌech kin bajúch in ajíb an paskwa; ani Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik, neꞌech kin pidhná abal kin chemdhá pajkʼidh ban peltsidh teꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Jachanꞌ i kʼij, an okʼlek páleꞌtsik, an okʼtsixtsik xin wilál nin takʼixtal na Dios xin jilám dhutsadh na Moisés ani nin okʼlékil an judíotsik, junkuntsik bin elébil nin kʼimáꞌ na Kayfás, nin okʼlékil an páleꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Tajaꞌ, in tʼajaꞌtsik i káw abal kin chalpay xan ti kin uwaꞌ kin yakʼwaꞌ na Jesús kʼal i kʼambixtaláb ani kin chemdhaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Por in ulaltsik enchéꞌ: ―Yab ki yakʼwaꞌ tam exom an ajib abal yab ka kʼwajaytsik ti péjéx an atikláb. ");
INSERT INTO husNT2005_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Na Jesús kʼwajat Betania, bin kʼimáꞌ na Simón xin kóꞌyámal an kʼwajat atʼax tʼítʼ; ");
INSERT INTO husNT2005_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ani utukná kʼal jun i mímláb xin tsiꞌdhál jun i frasko xi tʼajadh kʼal i alabastro tsʼutsat kʼal i niwiytaláb xi kajbidh. Tam ti na Jesús kʼwajat ban mesa, joltsin an ti niwiytaláb bin ókʼ kʼal an mímláb. ");
INSERT INTO husNT2005_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Tam ti an exóbaltsik in chuꞌu jechéꞌ, chakuytsik ani in ulu enchéꞌ: ―¿Jantʼókʼi ti odhná jechéꞌ an niwiytaláb? ");
INSERT INTO husNT2005_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ka nujwatwiꞌik kajbidh jechéꞌ an niwiytaláb abal ka pidhan an ti tumín an chʼojontáltsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Achʼantsik kʼal na Jesús ani utsantsik enchéꞌ: ―¿Jantʼókʼi ta itʼixbédháltsik jechéꞌ an mímláb? Jechéꞌ xowaꞌ tin tʼajtsi, alwaꞌ tʼajat. ");
INSERT INTO husNT2005_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Pos an chʼojontáltsik echʼekʼi neꞌech ka kʼwajay kʼal tatáꞌtsik, por Nanáꞌ yab echʼekʼi neꞌech kin kʼwajay kʼal tatáꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Xowaꞌ in tʼajaꞌ jechéꞌ an mímláb, tam tin joltsi an ti niwiytaláb bu tʼuꞌúl, jaꞌich abal ti kin tʼojojontsi an tu tʼuꞌúl abal ka kʼwajách tʼojojodh tam ka jolyat. ");
INSERT INTO husNT2005_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Tsubax tu utsáltsik, ke xónꞌtikichkʼi ka tʼilan jechéꞌ an alwaꞌ tʼilab ba putálkʼi an kʼayꞌlá, neꞌech jeye ka tʼilan xowaꞌ in tʼajaꞌ jechéꞌ an mímláb abal ka chalpayat. ");
INSERT INTO husNT2005_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Jún ti éb xi lajucháb an exóbaltsik, xu bijyáb ta Judas Iskariote, kʼale ti káw kʼal an okʼlek páleꞌtsik ");
INSERT INTO husNT2005_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ani in utsaꞌtsik enchéꞌ: ―¿Jáy i patʼál tumín neꞌech ti kin pidhaꞌtsik max tu pidhaꞌtsik an ta Jesús? Utsan tám kʼal an okʼlek páleꞌtsik abal neꞌech ka pidhan jun inik láju i patʼál tumín xi tʼajadh kʼal i plata. ");
INSERT INTO husNT2005_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ani asta tam ti tám, na Judas in tuju kin aliy xan ti kin pidhnaꞌ na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Tin jidhtal kʼítsájil an ajib tam u kʼapnal an pan xi yab jilbédhats kʼal an jilbédhaxtaláb kʼoye, an exóbaltsik utey ba na Jesús ani in konoytsik enchéꞌ: ―¿Jónꞌ ta léꞌ ki tʼojojoy an kʼapnél abal ka kʼapu an wiyadh borrego tin kwenta an paskwa? ");
INSERT INTO husNT2005_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Tókʼoyattsik enchéꞌ kʼal na Jesús: ―Ki kʼaletsik ban bitsow bin kʼimáꞌ jun i inik ani ka utsaꞌtsik enchéꞌ: “An Okʼtsix in ulu enchéꞌ: Exomich in bajwal an ora xowkʼi neꞌech kin chemdhá ani ba na kʼimáꞌ neꞌech ku kʼapu an kʼapnél kʼal tin kwenta an paskwa junax kʼal nu exóbaliltsik.” ");
INSERT INTO husNT2005_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","An exóbaltsik in tʼajaꞌ xan ti utsantsik kʼal na Jesús ani in tʼojojoytsik an kʼapnél abal tin kwenta an paskwa. ");
INSERT INTO husNT2005_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Tam ti jikʼwchin, na Jesús buxkan ti kʼapul ban mesa junax kʼal xi lajucháb nin exóbaliltsik; ");
INSERT INTO husNT2005_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","ani lejat kʼwajat ti kʼapultsik, in ulu enchéꞌ: ―Tsubax tu utsáltsik, ke jún ti éb xi tatáꞌtsik neꞌech ti kin pidhnaꞌ ban atiklábtsik xi tin atʼál. ");
INSERT INTO husNT2005_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Tʼeꞌpintsik tám tʼajat ani tujey ti konoxtsik juntsik ti juntsik enchéꞌ: ―Ajátik, ¿awxeꞌ nanáꞌ? ");
INSERT INTO husNT2005_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Tókʼon na Jesús ani in ulu enchéꞌ: ―Xitaꞌ xi kʼwajat ti kʼapul junax kʼal Nanáꞌ ban talab, jaꞌich xi neꞌech ti kin pidhnaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik, neꞌech ku watʼnaꞌ ejtal xowaꞌ in ulal an Tʼokat Dhuslab kʼal Nanáꞌ tu kwenta; por ¡chʼojontál in chuꞌbíl an inik xi ti kin pidhnaꞌ! Másakwiꞌik alwaꞌ abal jajáꞌ max yabak waꞌchinék ti chakam. ");
INSERT INTO husNT2005_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Káwin tám na Judas, xi kʼál ti neꞌech ka pidhná ani in ulu enchéꞌ: ―Okʼtsix, ¿nanáꞌxeꞌ? Tókʼoyat enchéꞌ kʼal na Jesús: ―Tatáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Lejat kʼwajattsik ti kʼapul, na Jesús in téynaꞌ an pan ani in pidhaꞌ ti jalbintsixtaláb na Dios. In pejaꞌ tám an pan, in pidhaꞌ nin exóbaliltsik ani in ulu enchéꞌ: ―Ka bachʼutsik ani ka kʼapu, jechéꞌ jaꞌich nu tʼuꞌúl. ");
INSERT INTO husNT2005_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Tayíl in téynaꞌ jun i lejab baltsidh kʼal i yajtsik uxnél, in pidhaꞌ ti jalbintsixtaláb na Dios, in pidhaꞌ nin exóbaliltsik ani in utsaꞌtsik enchéꞌ: ―Ka uchʼaꞌtsik ejtal ta éb jechéꞌ an yajtsik uxnél, ");
INSERT INTO husNT2005_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","pos jechéꞌ, jaꞌich nu xichʼál xi neꞌech kin jalbílnaꞌ an ít lejkintaláb. Jaꞌich xi neꞌech ku wakʼlaꞌ tam kin chemdhá abal yán xitaꞌ tin alwaꞌbíl ani abal ka pakwlantsatich tin walastalábiltsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Pos tu utsáltsik ke yabich neꞌech kin witsiy ku uxtsi tin jaꞌlíl an uba asta kin bajaw xowkʼi neꞌech ku uchʼaꞌ kʼal tatáꞌtsik an ít yajtsik uxnél xon tu takʼix nu Tátaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Tam ti okʼonich ti ajattsik, kʼaletsik ban chʼén xu bijyáb Olibos. ");
INSERT INTO husNT2005_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Utsantsik tám enchéꞌ kʼal na Jesús: ―Ejtal tatáꞌtsik neꞌech ti kin jilaꞌtsik jechéꞌ i akal; pos an Tʼokat Dhuslab in ulal enchéꞌ: “Neꞌech ku chemdhaꞌ an belkol borregotsik ani neꞌech ka bukʼey an borregotsik.” ");
INSERT INTO husNT2005_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Por tam kin ejech ti ít, neꞌech kin okxin kin kʼale Galilea ani tatáꞌtsik tayíl. ");
INSERT INTO husNT2005_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Tókʼoyat tám enchéꞌ kʼal na Pedro: ―Maske ejtal ti ki jilaꞌ, nanáꞌ yabaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Utsan tám enchéꞌ kʼal na Jesús: ―Tsubax tu utsál ke jechéꞌ i akal, tam yabél dhájnék an pekʼel, óxíl neꞌech ka ulu ke yab tin exlál. ");
INSERT INTO husNT2005_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Por utsan enchéꞌ kʼal na Pedro: ―Maske kin utsan ke neꞌech kin chemdhá junax kʼal Tatáꞌ, yab neꞌech ku ulu ke yab tu exlál. Ani ejtal an exóbaltsik anílkʼi tin ulu. ");
INSERT INTO husNT2005_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ulich tám na Jesús kʼal nin exóbaliltsik ba jun i kubtaláb xin bij Jetsemaní ani in utsaꞌtsik enchéꞌ: ―Ki buxkantsik techéꞌ, lejat Nanáꞌ in neꞌech núꞌ tin ól. ");
INSERT INTO husNT2005_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","In júnaꞌ na Pedro ani chablam nin chakámiltsik na Sebedeo ani tujey kin achʼaꞌ jun i pulek tʼeꞌpintaláb tin itsích. ");
INSERT INTO husNT2005_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Utsantsik tám enchéꞌ kʼal na Jesús: ―U achʼál tu ejattal jun i pulek tʼeꞌpintaláb xi neꞌech ku chémay. Ki jilkʼontsik techéꞌ ani yab ki wayichtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Kʼale tám na Jesús lej wéꞌ túꞌ aniꞌ, tudhlan kutúl asta chabál, ólan ani in utsaꞌ enchéꞌ na Dios: ―Tátaꞌ, max Tatáꞌ a léꞌ ka chuꞌu yab ku watʼnaꞌ jechéꞌ an yajtsiktaláb, neꞌech ka ejto ti kin wixkʼintsi; por yab ka tʼájan xan ti Nanáꞌ u léꞌ, ka tʼájan xan ti Tatáꞌ a léꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Witsiy tám xon ti kʼwajat nin exóbaliltsik ani u wayaltsik tin elaꞌ. In utsaꞌ tám enchéꞌ na Pedro: ―¿Yabtsik a ejto ka kuxuy ki kʼwajay ejat kʼal Nanáꞌ elaꞌ jun i ora? ");
INSERT INTO husNT2005_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Yabtsik ki wayich ani ki ólan abal yab ki átátsik kʼal an lej atʼax. Tsubax kʼejle ke na ejattal in léꞌ ka ólan, por na tʼuꞌúl yab likat. ");
INSERT INTO husNT2005_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Kʼale juní tin chabtal, ólan ani in ulu enchéꞌ: ―Tátaꞌ, max koꞌol ku watʼnaꞌ jechéꞌ an yajtsiktaláb, ka tʼájan xan ti Tatáꞌ a léꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Witsiy tám tin chabtal xon ti kʼwajat nin exóbaliltsik ani u wayaltsik juní tin elaꞌ, kom u mútʼnalichtsik tʼajat nin wal kʼal an akal. ");
INSERT INTO husNT2005_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","In jilaꞌtsik tám, kʼale juní ti ól tin oxtal ani anílkʼi juní ti ólan. ");
INSERT INTO husNT2005_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Witsiy tám tin oxtal xon ti kʼwajat nin exóbaliltsik ani in utsaꞌtsik enchéꞌ: ―Xoꞌ awilich ka óntsitsik ta wayal ani ta koyol. In bajúch an ora xowkʼi Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik, neꞌech kin pidhná ban walablomtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ki chʼakáchtsik ani wanách; núꞌich tál xi neꞌech ti kin pidhnaꞌ abal kin chemdhá. ");
INSERT INTO husNT2005_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Bél kʼwajat ti káw na Jesús tam ti ulich na Judas, xi jaꞌich jún ti éb xi lajucháb an exóbaltsik. Kʼal jajáꞌ, taꞌ ti tál yán i atiklábtsik teykodh kʼal i machéttsik ani i teꞌ. Abnéktsik kʼal nin okʼlékiltsik an páleꞌtsik ani kʼal in okʼlékil an judíotsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Na Judas, xi neꞌech an ti pidhnax, in utsámalichtsik xowaꞌ exól neꞌech kin tʼajaꞌ, enchéꞌ tin utsámaltsik: ―Xi ku chʼuchʼbay, jaꞌich ka yakʼwaꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Utey tám ba na Jesús ani in utsaꞌ enchéꞌ: ―¡Janta uwats, Okʼtsix! Ani in chʼuchʼbay. ");
INSERT INTO husNT2005_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Tókʼoyat enchéꞌ kʼal na Jesús: ―Jaꞌúb, ¿jantʼókʼi ta tsiꞌnek? Uteytsik tám, in yakʼwaꞌ na Jesús ani in júnaꞌ ti wikʼnél. ");
INSERT INTO husNT2005_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Por jún ti éb xi taꞌ ti kʼwajat kʼal na Jesús, in jixónaꞌ nin machétil ani in patíntsi tin xuchun jun in tʼojnálil an okʼlek páleꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Utsan tám enchéꞌ kʼal na Jesús: ―Ka taꞌpaꞌ an machét. Pos ejtal xu péjéxtsik kʼal i machét, kʼal i machét jeye ti neꞌech ka chemdhá. ");
INSERT INTO husNT2005_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Yab a choꞌób ke Nanáꞌ neꞌech ku ejto ku kontsi nu Tátaꞌ ani Jajáꞌ neꞌech ti kin abtsi xoꞌkʼi lajucháb i pakdhaꞌ kweneꞌ i tʼokat abatwáletsik abal ti kin loꞌo? ");
INSERT INTO husNT2005_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Por max ku tʼajaꞌ anchanꞌ, ¿jan ti neꞌech ka támun xowaꞌ kʼwajat dhutsadh ban Tʼokat Dhuslab, ke anchanꞌ yejat ka támun? ");
INSERT INTO husNT2005_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Támkʼi jachanꞌ, utsan enchéꞌ an atiklábtsik kʼal na Jesús: ―¿Jantʼókʼi ta tsiꞌnektsik kʼal i machét ani kʼal i teꞌ abal ti kin yakʼwaꞌ, jelti max neꞌech ka yakʼwaꞌtsik jun in kwéꞌ? Tsudhey ka tsudhey in buxkanék kʼal tatáꞌtsik tin okʼtsix ban pulek atá xon tu kʼakʼnáb na Dios ani yab jaykʼi tin yakʼwámaltsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Por ejtal jechéꞌ exom ti támnal abal ka tʼájan xan tin dhutsámal an tʼiltsixtsik ban Tʼokat Dhuslab. Támkʼi jachanꞌ, ejtal an exóbaltsik in jiloloy kwetém na Jesús ani kʼaletsik ti chinkʼonal. ");
INSERT INTO husNT2005_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Xin tʼajaꞌtsik ti yákʼwal, in júnaꞌ na Jesús ba na Kaifás, nin okʼlékil an páleꞌtsik. Tajaꞌ, junkunék an okʼtsixtsik xin wilál an takʼixtaláb ani nin okʼlékil an judíotsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Por na Pedro ów wéwnaxin asta bin elébil nin okʼlékiltsik an páleꞌtsik. Ochich tajaꞌ ani buxkan kʼal an belkoltsik abal in léꞌ kin chuꞌu xan ti neꞌech ka kʼale ti okʼnal jechéꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Nin okʼlékiltsik an páleꞌtsik, nin okʼlékil an judíotsik ani ejtal an Junkulom Awiltaláb, in ayaltsik xan ti kin uwaꞌ kin aniꞌ walbiy na Jesús abal kin ejtotsik kin ulu ka chemdhá. ");
INSERT INTO husNT2005_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Por yab in elaꞌtsik xan ti kin aniꞌ walbiy, maske yán i kʼambix ólnaxtsik ulich. Por tayíl ulich cháb i kʼambix ólnaxtsik, ");
INSERT INTO husNT2005_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","xin ulutsik enchéꞌ: ―Jechéꞌ an inik in ulúm enchéꞌ: “Neꞌech ku ejto ku paku jechéꞌ an pulek atá xon tu kʼakʼnáb na Dios ani ku kubaꞌ ti ít ti óx a kʼítsá.” ");
INSERT INTO husNT2005_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Chʼakay tám an okʼlek páleꞌ ani in konoy enchéꞌ na Jesús: ―¿Jantʼéy a ulal kʼal jechéꞌ tin kwenta? ¿Jantʼéy in éy xi jechéꞌ i kʼwajat ta usnal? ");
INSERT INTO husNT2005_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Por na Jesús yab tókʼon. Utsan tám enchéꞌ kʼal an okʼlek páleꞌtsik: ―Kʼal tin bij na Dios xi ejat, tu kontsal abal ti ku utsaꞌ max tatáꞌich lejtal ni Kristo xi Chakámláb kʼal na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Utsantsik tám enchéꞌ kʼal na Jesús: ―Nanáꞌ. Ani tu utsáltsik jeye, ke asta xoꞌ neꞌech tin chuꞌutsik Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik, buxúl tin eját na Dios xi ejtal in ejtowal kin tʼajaꞌ. Ani neꞌech jeye ti kin chuꞌutsik tam in tál ban tokow xi walkʼiꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Kom chakuy tʼajat an okʼlek páleꞌtsik, in michʼónaꞌ nin xekét xin kʼwajbím ani in ulu enchéꞌ: ―Jechéꞌ an inik in odhbijyalich na Dios kʼal xowaꞌ in ulal; yabich más i yéntsal ni jun i ólnax. Tatáꞌtsik a achʼaꞌ xan tin odhbijiy na Dios kʼal xowaꞌ in ulu, ");
INSERT INTO husNT2005_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿jantʼéy xoꞌ a chalpayaltsik? Jajáꞌtsik tókʼon enchéꞌ: ―Walbidh ti kʼwajat ani yejat ka chemdhá. ");
INSERT INTO husNT2005_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Tubkayat tám bin wal ani chaꞌwat. Taltsik in pikʼiy bin wal ");
INSERT INTO husNT2005_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ani in utsáltsik enchéꞌ: ―Kom Tatáꞌ i Kristo, ¡ti ku utsaꞌ xitaꞌ ti chaꞌaw! ");
INSERT INTO husNT2005_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Tam ti jachanꞌ, lejat na Pedro buxúl bin elébil an atá, utukná kʼal jun i mímláb xu tʼójontsix tajaꞌ ani utsan kʼál enchéꞌ: ―Tatáꞌ junax teye ta xeꞌech kʼal na Jesús, xi Galilea u kʼwajíl. ");
INSERT INTO husNT2005_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Por na Pedro in ulu ke yab aniꞌ tin tamét ejtal xi taꞌ ti kʼwajattsik, enchéꞌ tin ulu: ―Yab u choꞌób xantʼéy a tʼilál. ");
INSERT INTO husNT2005_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Tam ti na Pedro neꞌchich ban wiꞌleb, chuꞌtat juní kʼal kʼeꞌet i mímláb ani an mímláb, in utsaꞌ enchéꞌ xi táꞌtsik ti kʼwajat: ―Jechéꞌ an inik junax jeye ti xeꞌech kʼal na Jesús, xi Nasaret u kʼwajíl. ");
INSERT INTO husNT2005_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Por in ulu juní na Pedro ke yab aniꞌ, in lej tsubax ulu enchéꞌ: ―Yab u exlál jachanꞌ an inik. ");
INSERT INTO husNT2005_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Más tayíl, utukná na Pedro kʼal xi táꞌtsik ti kʼwajat ani utsan enchéꞌ: ―Tsubax lejtal, tatáꞌ a kidhtal teye nin exóbaliltsik na Jesús, pos anílkʼi teye i káw jelti jajáꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Tujey tám na Pedro kin lej tsubax ulu enchéꞌ: ―Yab u exlál jachanꞌ an inik. Ani támkʼi jachanꞌ, dhájan jun i pekʼel. ");
INSERT INTO husNT2005_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","In chalpánaꞌ tám na Pedro xantʼéy ti usnék kʼal na Jesús: “Tam yabél dhájnék an pekʼel, óxílich a ulúmal ke yab tin exlál.” Na Pedro kale eléb ani ukʼin tʼajat kʼal i tʼeꞌpintaláb. ");
INSERT INTO husNT2005_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Tam ti tsudhey, ejtal nin okʼlékiltsik an páleꞌtsik ani nin okʼlékil an judíotsik, in tʼajaꞌ i káw xan ti kin uwaꞌtsik abal kin chemdhaꞌ na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","In júnaꞌtsik wikʼadh na Jesús ani in pidhnaꞌ ba na Ponsio Pilato, xi jaꞌich an pulek awiltaláb. ");
INSERT INTO husNT2005_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Tam ti na Judas xin tʼajaꞌ ti pidhnax an ta Jesús abal ka chemdhá, in chuꞌu abal walbiyatich na Jesús, in achʼaꞌ abal yab alwaꞌ xowaꞌ in tʼajaꞌ, in jalkʼuy nin chalab ani kʼale kin witsbantsi xi jun inik láju an tumín an okʼlek páleꞌtsik ani nin okʼlékil an judíotsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","In utsaꞌtsik enchéꞌ: ―Nanáꞌ u walaꞌ abal u pidhnaꞌ ka chemdhá jun i inik xi yab walbidh. Por tókʼoyat enchéꞌ kʼal jajáꞌtsik: ―Wawáꞌ yab i kwenta xantʼéy a tʼajaꞌ. Tatáꞌich teye. ");
INSERT INTO husNT2005_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","In petʼnaꞌ tám na Judas an tumín ban pulek atá xon tu kʼakʼnáb na Dios, kʼale ani in palaꞌ tinbáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Nin okʼlékil an páleꞌtsik in penaꞌ an tumín ani in ulutsik enchéꞌ: ―Yab alwaꞌ ki baliy jechéꞌ an tumín xon tu taꞌpáb an pikbantsixtaláb, kom in jalbíl in chemtal jun i inik. ");
INSERT INTO husNT2005_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","In tʼajaꞌtsik tám i káw abal kin chʼaꞌay kʼal jachanꞌ an tumín jun i chabál xu bijyáb tin Chabálil i tʼojom pats, xon ti ka jolyat an píl iniktsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Jaxtám ti bijyat jachanꞌ an chabál asta xoꞌ, tin “Chabálil i Xichʼ.” ");
INSERT INTO husNT2005_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ani anchanꞌ, támunich xan tin ulúmal enchéꞌ an tʼiltsix Jeremías: In bachʼutsik xi jun inik láju an patʼál tumín xi tʼajadh kʼal i plata, nin jalbíl an inik xi an israelitatsik in kʼwajbantsi, ");
INSERT INTO husNT2005_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ani kʼál tin chʼaꞌaytsik an chabál xu bijyáb tin Chabálil i tʼojom pats, jelt xan tin utsan kʼal an Okʼóxláb. ");
INSERT INTO husNT2005_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Na Jesús júná tin tamét an pulek awiltaláb ani konyat enchéꞌ kʼal an pulek awiltaláb: ―¿Tatáꞌxeꞌ nin Pulek Takʼíxal an judíotsik? Tókʼoyat enchéꞌ kʼal na Jesús: ―Nanáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ani tam ti nin okʼlékiltsik an páleꞌtsik ani nin okʼlékil an judíotsik kʼwajat in walbiyal na Jesús, Jajáꞌ yab u tókʼnal. ");
INSERT INTO husNT2005_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Utsan tám enchéꞌ kʼal na Pilato: ―¿Yabxeꞌ a achʼál ejtal xowaꞌ exom ta usnal? ");
INSERT INTO husNT2005_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Por na Jesús yab kʼuchun, jaxtám ti labandhájich tokot an pulek awiltaláb ani yabich in choꞌób xantʼéy kin chalpay. ");
INSERT INTO husNT2005_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Pos alwaꞌich, tam exomich an ajib, an pulek awiltaláb in walkál jun i wikʼnél, xi ka kontsin kʼal an atiklábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Tam ti jachanꞌ i kʼij, taꞌ ti kʼwajat jun i wikʼnél xi exlómte tʼajat xu bijyáb ta Barrabás; ");
INSERT INTO husNT2005_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","ani tam ti an atiklábtsik taꞌ ti kʼwajat junkunék, konyattsik enchéꞌ kʼal na Pilato: ―¿Jitaꞌ a léꞌ ka chuꞌutsik ku walkaꞌ: na Barrabás o na Jesús xu bijyáb ti Kristo? ");
INSERT INTO husNT2005_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Na Pilato in ulu anchanꞌ, kom in choꞌób ke na Jesús pidhnats abal u atʼnal. ");
INSERT INTO husNT2005_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Lejat na Pilato buxúl xon tu lújundhom, abná ti usnal enchéꞌ kʼal nin tomtal: “Yab ka tʼajtsi xataꞌ jachanꞌ an lujat inik, pos ti akal u kóꞌoy jun i kʼakʼadh watsib kʼal Jajáꞌ tin kwenta.” ");
INSERT INTO husNT2005_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Por nin okʼlékiltsik an páleꞌtsik ani nin okʼlékil an judíotsik, in pidhkáwliy an atiklábtsik abal kin konoy ka walkantsat ta Barrabás ani ka chemdhá na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Tawnátsik juní kʼal an pulek awiltaláb ani konyattsik enchéꞌ: ―¿Jitaꞌ a léꞌ ka chuꞌutsik ku walkaꞌ xi jechéꞌ cháb? Jajáꞌtsik tókʼon enchéꞌ: ―Na Barrabás. ");
INSERT INTO husNT2005_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Konyattsik enchéꞌ kʼal na Pilato: ―¿Ani jantʼéy ku tʼajtsi na Jesús, xu bijyáb ti Kristo? Ejtal tókʼontsik enchéꞌ: ―¡Ka chemdhá pajkʼidh ban peltsidh teꞌ! ");
INSERT INTO husNT2005_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Utsantsik tám enchéꞌ kʼal an pulek awiltaláb: ―Pos, ¿jantʼom walastaláb in tʼajám? Por jajáꞌtsik in ulu juní kawidh enchéꞌ: ―¡Ka chemdhá pajkʼidh ban peltsidh teꞌ! ");
INSERT INTO husNT2005_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Tam tin chuꞌu na Pilato abal yab xataꞌ neꞌech kin exbay, tokot exomich in péjéxlindhál más an atiklábtsik, in abnaꞌ ka ikʼtsin ti jaꞌ, in tʼakaꞌ nin kʼubak tin tamét an atiklábtsik ani in ulu enchéꞌ: ―Nanáꞌ yab u léꞌ kin walbin kʼal nin chemtal jechéꞌ an lujat inik, tatáꞌtsik a choꞌób xantʼéy a tʼajál. ");
INSERT INTO husNT2005_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ani ejtal an atiklábtsik tókʼon enchéꞌ: ―¡Wawáꞌ ani ni chakámiltsik ku jilkʼon u walbidh kʼal nin chemtal! ");
INSERT INTO husNT2005_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Na Pilato in walkaꞌ tám na Barrabás, in abnaꞌ ka lekbayat na Jesús ani in pidhnaꞌich tám abal ka chemdhá pajkʼidh ban peltsidh teꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Tayíl, nin soldadojiltsik an pulek awiltaláb in júnaꞌtsik na Jesús ban atá xon tu tʼajnal an lújundhaxtaláb, in junku ejtal an soldadotsik ani wiliyat na Jesús kʼal jechéꞌ an soldadotsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Kʼoꞌtsin tám tin kʼudhkʼúmil ani xeketliyat kʼal jun i kʼudhkʼum xi tʼunuyich tʼajat kʼal in chákníꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Kʼwajbantsat jeye bin ókʼ jun i kwetsotsól dhipadh kʼídh ani teykoyat ti teꞌ bin eját kʼubak. U tudhéltsik tám tin tamét na Jesús ani in labídhnáltsik enchéꞌ: ―¡Ki kʼwajay kʼijidh, Pulek Takʼíxal an judíotsik! ");
INSERT INTO husNT2005_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Tubkayat jeye, u kʼántsinal an ti teꞌ ani u tʼoxyáb kʼál bin ókʼ. ");
INSERT INTO husNT2005_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Tam ti okʼon ti labídhnáb, wékʼontsatich tám an ti chak kʼudhkʼum, kʼwajbantsat xi Jajáꞌ in kʼudhkʼúmil ani júnájich tám abal ka chemdhá pajkʼidh ban peltsidh teꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Tam tu kalelichtsik, elan jun i inik xu kʼwajíl Sirene, xu bijyáb ta Simón ani tʼajtsin ti chápláb abal kin kitnantsi an ti peltsidh teꞌ xin neꞌdhál na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ulichtsik tám ba jun i chabál xu bijyáb Gólgota. Ti tének káw, Gólgota, in léꞌ kin ulu: “In chabálil in beklék in ókʼ i chemélom inik.” ");
INSERT INTO husNT2005_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Tajaꞌ, pidhan na Jesús kin uchʼaꞌ i yajtsik uxnél xukʼudh kʼal i tsʼaꞌiktaláb; por tam tin lekaꞌ, na Jesús yab in leꞌnaꞌ kin uchʼaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Tam ti pajkʼidhich na Jesús ban peltsidh teꞌ, an soldadotsik ubátʼin abal kin wélchíxnantsi tin kʼudhkʼúmil na Jesús. Anchanꞌ ti támun jelt xan tin ulúmal an tʼiltsix enchéꞌ: “Ubátʼintsik abal ti kin wélchíxnantsitsik an tu kʼudhkʼúmil.” ");
INSERT INTO husNT2005_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Buxkantsik tám tajaꞌ abal kin beletnaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ani éb in ókʼ an peltsidh teꞌ, kʼwajbá jun i dhuslab xin ulal xantʼókʼi tin kwenta ti pajkʼidh ban peltsidh teꞌ. An dhuslab in ulal enchéꞌ: “Jechéꞌ jaꞌich na Jesús, nin Pulek Takʼíxal an judíotsik.” ");
INSERT INTO husNT2005_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Pajkʼiyat jeye kʼal na Jesús cháb i kwéꞌtsik, jún tin eját ani jún tin kʼwatab. ");
INSERT INTO husNT2005_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","U odhbijyáb kʼal xu watʼeltsik tajaꞌ, in wíwókʼliyaltsik nin ókʼ ");
INSERT INTO husNT2005_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ani in ulaltsik enchéꞌ: ―Tatáꞌ, xa ulal ke neꞌech ka paku an pulek atá xon tu kʼakʼnáb na Dios ani ti óx a kʼítsá neꞌech ka kubaꞌ ti ít, ka loꞌo xoꞌ tabáꞌ. Max Tatáꞌich lejtal ni Chakámláb kʼal na Dios, ki paꞌay xoꞌ ban peltsidh teꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Anchanꞌ jeye tu labídhnáb kʼal nin okʼlékiltsik an páleꞌtsik, kʼal an okʼtsixtsik xin wilál nin takʼixtal na Dios xin jilám dhutsadh na Moisés, kʼal an fariseotsik, kʼal nin okʼlékil an judíotsik ani u útsáxtsik enchéꞌ: ");
INSERT INTO husNT2005_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―In loꞌóm kʼeꞌet, por xoꞌ yab in ejto kin loꞌo tinbáꞌ. Max Jajáꞌich lejtal nin Pulek Takʼíxal an Israelitatsik, ka paꞌay xoꞌ ban peltsidh teꞌ abal ki belaꞌich. ");
INSERT INTO husNT2005_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Jajáꞌ in belál tʼajat na Dios, pos ka loꞌwat xoꞌ kʼal na Dios, max tsubax lejtal tu leꞌnáb; kom in ulal ke Jajáꞌ u Chakámláb kʼal na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","An kwéꞌtsik xi taꞌ ti kʼwajattsik pajkʼidh junax kʼal Jajáꞌ, u odhbijixtsik jeye. ");
INSERT INTO husNT2005_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Jikʼwchin tám ba putál an chabál, asta chʼejel kʼítsá ani asta óx i wákal. ");
INSERT INTO husNT2005_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Tam ti wéꞌich óx i wákal, na Jesús in ulu kawidh enchéꞌ: ―Elí, Elí, ¿lama sabaktani? ―Ti tének káw, jechéꞌ in léꞌ kin ulu: Dios tu Ajátik, Dios tu Ajátik, ¿jantʼókʼi tin walbaꞌ? ");
INSERT INTO husNT2005_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Taltsik xi tajaꞌ ti kʼwajat, in achʼaꞌ jechéꞌ ani in ulutsik enchéꞌ: ―Jechéꞌ an inik kʼwajat in tawnál an tʼiltsix Elías. ");
INSERT INTO husNT2005_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Támkʼi jachanꞌ, jún ti éb xi taꞌ ti kʼwajattsik, kʼale adhik kin ikʼiꞌ jun i kwinim ani in axdhaꞌ ba jiliy jaytsik uxnél. In kʼwajbaꞌ bin tsúm jun i teꞌ ani in utuntsi na Jesús abal kin juchʼu. ");
INSERT INTO husNT2005_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Por utsan enchéꞌ kʼal xi kʼeꞌettsik: ―Jilaꞌ kʼwajat, wana ki chuꞌu max ka tsích ti loꞌwáb kʼal an tʼiltsix Elías. ");
INSERT INTO husNT2005_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Dhájan tám kawidh na Jesús ani chemchich tám. ");
INSERT INTO husNT2005_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Támkʼi jachanꞌ, an tolow kʼudhkʼum xi taꞌ ti palat ban pulek atá xon tu kʼakʼnáb na Dios, xílan asta tʼekʼat ani asta chaꞌat. An chabál léwékʼin, an pakdhaꞌ tʼujub pokʼchon, ");
INSERT INTO husNT2005_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","jakʼpin xon ti jolidh an chemélomtsik ani ejdhá yán i chemélomtsik xin belámal na Dios tam ti xeꞌchinéktsik ejat. ");
INSERT INTO husNT2005_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Jechéꞌtsik, kale xon ti kʼwajattsik jolidh tam ti ejnekich ti ít na Jesús ani ochichtsik ban tʼokat bitsow Jerusalén, xon ti chuꞌtat kʼal yán i atiklábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Tam ti an okʼlek soldadotsik ani xi táꞌ ti kʼwajattsik junax kʼal jajáꞌ ti belkol an ta Jesús, in chuꞌutsik léwékʼin an chabál ani ejtal xowaꞌ támun, jikʼeytsik tʼajat ani in ulutsik enchéꞌ: ―Tsubax lejtal, jechéꞌ an inik u Chakámláb kʼal na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Táꞌ jeye ti kʼwajat i mímlábtsik ti ów telom, xin juniknámaltsik na Jesús asta Galilea ani in tʼójontsámaltsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Jéꞌ kʼwajat taltsik nin bij xi táꞌtsik ti kʼwajat, na María Magdalena; na María nin nánaꞌ na Jakobo ani na José; ani nin nánaꞌ nin chakámiltsik na Sebedeo. ");
INSERT INTO husNT2005_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Tam ti exomich ti jikʼwchinal, ulich jun i tumínladh inik xu bijyáb ta José, xu kʼwajíl ban bitsow xin bij Arimatea, xin wéwnámal jeye na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Jechéꞌ na José kʼale kin chuꞌu na Pilato ani in kontsi tin tʼuꞌúl na Jesús. Na Pilato in ulu ka pidhan. ");
INSERT INTO husNT2005_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Na José in bachʼu nin tʼuꞌúl na Jesús, in boliy kʼal jun i alabél kʼudhkʼum ");
INSERT INTO husNT2005_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ani in kʼwajbaꞌ ba jun i ít jólimtaláb, xi jajáꞌ in ulúmal ka cholkʼantsat ba jun i tʼujub chʼén. Tam tin paxkʼiyámich an jólimtaláb kʼal jun i yejcheꞌ tʼujub, kʼaléch tám. ");
INSERT INTO husNT2005_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ani táꞌtsik jeye ti kʼwajat na María Magdalena ani na jún na María, buxutsik tin tamét an jólimtaláb. ");
INSERT INTO husNT2005_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Tam ti jun tsudhelom, xi jaꞌich tam watʼenekich xowkʼi tu tʼojojoyáb xowaꞌ u yéntsinal tam in kʼítsájil an koyóxnich, nin okʼlékiltsik an páleꞌtsik ani an fariseotsik kʼaletsik kin chuꞌu na Pilato ");
INSERT INTO husNT2005_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ani in utsaꞌtsik enchéꞌ: ―Payꞌlomláb, i chalpayámal ke jachanꞌ an kʼambix inik in ulúmal tam ti bél ejat, ke neꞌech ka ejech tin óxláb a kʼítsá. ");
INSERT INTO husNT2005_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Jaxtám, i konyal abal ka abnaꞌ ka beletná jachanꞌ an jólimtaláb asta ka watʼey xi óx a kʼítsá. Yab telab ka kʼale nin exóbaliltsik akal, kin kwéꞌeytsik nin tʼuꞌúl na Jesús ani tayíl kin utsaꞌ an atiklábtsik enchéꞌ: “Ejech ti ít.” Max ka támun anchanꞌ, jachanꞌ an kʼambixtaláb más tám púlek ké xi okʼox. ");
INSERT INTO husNT2005_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Utsantsik enchéꞌ kʼal na Pilato: ―Táꞌ a koꞌol i soldadotsik. Ki kʼaletsik junax ani ka paxkʼiytsik alwaꞌ an jólimtaláb jelt xan ta choꞌóbtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Kʼaletsik tám ani in paxkʼiytsik alwaꞌ an jólimtaláb. In tsʼutsʼkʼiytsik alwaꞌ nin paxkʼíl jachanꞌ an jólimtaláb ani in jilaꞌ tajaꞌ ti belkol an soldadotsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Tam ti watʼéch in kʼítsájil an koyóxnich ani exomich ti tsudhél tin jidhtal kʼítsájil an semana, na María Magdalena ani na jún na María, kʼaletsik kin álnaꞌ xon ti jolidh na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Jun jikʼtowál ti tujey ti léwékʼ an chabál. Jaꞌich abal jun in tʼokat abatwálejil an Ajátikláb paꞌinek walkʼiꞌ ani in wékʼoy an tʼujub xi kʼál ti paxkʼidh an jólimtaláb. Tayíl, buxkan ban tʼujub. ");
INSERT INTO husNT2005_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","An tʼokat abatwále chʼaxixíl tʼajat jelt in tajáx i léy tam u lamkʼil ani nin kʼudhkʼúmil dhakniꞌ tʼajat jelti an chám. ");
INSERT INTO husNT2005_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Tam ti chuꞌtat an tʼokat abatwáletsik kʼal an soldadotsik, an soldadotsik wipipilách kʼal i jíkʼib ani jilkʼontsik jelti max chemnek. ");
INSERT INTO husNT2005_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Utsan tám enchéꞌ an mímlábtsik kʼal an tʼokat abatwále: ―Yab ki jikʼeytsik. Nanáꞌ u choꞌób abal a ayaltsik na Jesús xi chemdhá pajkʼidh ban peltsidh teꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Yab waꞌach techéꞌ, pos ejnek ti ít, jelt xan tin ulúmal. Jalaꞌ ka chuꞌutsik xon ti kʼwajbantsidh an tin tʼuꞌúl. ");
INSERT INTO husNT2005_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ki kʼaletsik jikʼat ani ka utsaꞌ enchéꞌ nin exóbaliltsik: “Jajáꞌ chemech por ejech ti ít, okxinékich Galilea ani tajaꞌ neꞌech ka chuꞌutsik.” Jechéꞌ jaꞌich xowaꞌ koꞌol tu utsaꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Kale tám an mímlábtsik jikʼatkʼi ban jólimtaláb, u jikʼéltsik por u kulbél; ani kʼaletsik jikʼat kin óltsi an exóbaltsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Lejat neꞌechtsik ti bél abal kin óltsi jechéꞌ an exóbaltsik, na Jesús in xalkʼaꞌ tinbáꞌ abal ka chuꞌtat kʼal an mímlábtsik ani chapnédhátsik. Uteytsik tám an mímlábtsik ba na Jesús, in mulukʼnantsi tin akan ani tudhlantsik kutúl asta chabál abal kin kʼakʼnaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ani utsantsik enchéꞌ kʼal na Jesús: ―Yab ki jikʼeytsik. Ki kʼale ka óltsi an kidháblábtsik ke yejat ka kʼaletsik Galilea ani tajaꞌ neꞌech ti kin chuꞌutsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Lejat an mímlábtsik kʼale kin óltsi an exóbaltsik ejtal jechéꞌ, taltsik an soldadotsik xi taꞌ ti kʼwajat ti belkol, kʼale ban bitsow ani in óltsi nin okʼlékiltsik an páleꞌtsik ejtal xowaꞌ támnék. ");
INSERT INTO husNT2005_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Jechéꞌ an okʼlektsik, kʼale ti káw kʼal nin okʼlékil an judíotsik ani tam tin chalpayámichtsik xantʼéy neꞌech kin tʼajaꞌ, in pidhaꞌtsik tám yán ti tumín an soldadotsik ");
INSERT INTO husNT2005_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ani in utsaꞌtsik enchéꞌ: ―Ka ulutsik ke tam ti akal, lejat i kʼwajat ta wayaltsik, nin exóbaliltsik na Jesús ulich ani in kwéꞌeytsik nin tʼuꞌúl na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ani max an pulek awiltaláb kin choꞌóbnaꞌ abal i wayámadhtsik, wawáꞌ neꞌech ku káwin kʼal jajáꞌ abal yab xataꞌ ki utsantsik. ");
INSERT INTO husNT2005_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","In bachʼu tám an tumín an soldadotsik ani in tʼajaꞌ xan ti utsantsik. Ani anchanꞌ tin tʼilál an judíotsik asta xoꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Xi lajujún an exóbaltsik, kʼaletsik Galilea ba jun i chʼén xi bijtsidhich kʼal na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ani tam ti chuꞌtat na Jesús kʼal an exóbaltsik, kʼakʼná, maske kʼal taltsik yab u lej belnal. ");
INSERT INTO husNT2005_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Utuknátsik tám kʼal na Jesús ani utsantsik enchéꞌ: ―In pidhan ejtal ti awiltaláb ban walkʼiꞌ ani ban chabál. ");
INSERT INTO husNT2005_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Jaxtám, ki kʼaletsik putálkʼi an kʼayꞌlá ani ka okʼtsi an atiklábtsik xowaꞌ tu okʼtsámaltsik; ka pujaytsik tin bij an Tátaꞌláb, an Chakámláb ani an Tʼokat Ejattaláb. ");
INSERT INTO husNT2005_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ka okʼtsitsik kin tʼajaꞌ ejtal xowaꞌ tu okʼtsámaltsik ka tʼajaꞌ ani ka choꞌóbnaꞌtsik ke Nanáꞌ in kʼwajat kʼal tatáꞌtsik malilíl i kʼij, asta kin bajaw an pakwenib. Anchanꞌ ka tʼájan.");
INSERT INTO husNT2005_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Enchéꞌ ti kʼwajat dhutsadh xan ti tujey an alwaꞌ tʼilab kʼal tin kwenta xowaꞌ in tʼajaꞌ na Jesukristo, nin Chakámil na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","An tʼiltsix Isaías in jilám dhutsadh xowaꞌ na Dios in utsaꞌ nin Chakámil. Enchéꞌ tin jilaꞌ dhutsadh: Neꞌech ku abaꞌ nu abatwálejil abal ka okxin xon ti neꞌech ki ulich. Jajáꞌ neꞌech ti ki tʼojojontsi an ti bél. ");
INSERT INTO husNT2005_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Achʼat in káwintal jun xitaꞌ ban chabál xon ti yab kʼwajtsidh ani xu káw, in ulal kawidh enchéꞌ: Ka tʼojojontsíchtsik tin bélil an Ajátikláb. “Ka júnaꞌichtsik jun i xeꞌchintaláb alwaꞌ; abal anchanꞌ, ki kʼwajáchtsik tʼojojodh tam ka tsích an Ajátikláb.” ");
INSERT INTO husNT2005_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Anchanꞌ ti támun tam ti ulich na Juan ban chabál xon ti yab kʼwajtsidh. In pujyal tajaꞌ an atiklábtsik ani in utsál abal kin jilaꞌichtsik ti walablom. In utsál ka pujanichtsik abal ka pakwlantsatich tin walastalábiltsik kʼal na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ejtal xu kʼwajíltsik ban bitsow Jerusalén ani xu kʼwajíltsik jeye ban kwentsaltsik xu takʼnal ban chabál xi Judea, u kʼaleltsik kin axtsi xowaꞌ in ulal na Juan. Tam kin lujutsik nin walastalábil, u pujyábichtsik tám kʼal na Juan ban waljaꞌ Jordán. ");
INSERT INTO husNT2005_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Na Juan u xeketlinal kʼal i xeketláb xi tʼajadh kʼal in xiꞌíl an koꞌnél xu bijyáb kameyo ani in wikʼál nin tsukul kʼal i ótʼ. Nin kʼapwál, jaꞌich an pichʼichʼ ani an alteꞌ chiꞌik. ");
INSERT INTO husNT2005_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Jajáꞌ u tʼiltsix enchéꞌ: ―Wéꞌich u kʼibel ka ulich jun i inik xin koꞌol más i awiltaláb ké nanáꞌ. Nanáꞌ yab xataꞌ u éy nibal abal kin kutpan ku wiltsi tin wikʼáb nin pajab. ");
INSERT INTO husNT2005_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nanáꞌ tu pujyámaltsik kʼal i jaꞌ, por Jajáꞌ neꞌech ti ki pujaytsik kʼal an Tʼokat Ejattaláb. ");
INSERT INTO husNT2005_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Tam ti jachanꞌ i kʼij, kale na Jesús ban bitsow Nasaret, xu takʼnal ban chabál xi Galilea ani ulich ban waljaꞌ Jordán. Tajaꞌ ti pujyat kʼal na Juan. ");
INSERT INTO husNT2005_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Tam tu kalelich ban jaꞌ, na Jesús in chuꞌu ti jakʼpin an walkʼiꞌ ani in chuꞌu an Tʼokat Ejattaláb ti paꞌíl jelti jun i kukuꞌ ani buxkan tin éb Jajáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Achʼatmé tám jun i káwintaláb túꞌ walkʼiꞌ. Xu káw in ulu enchéꞌ: ―Tatáꞌ tu Chakámil ani tu kʼanidhál tʼajat. In kulbél tʼajat kʼal Tatáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Tayíl, ijtsiyat na Jesús kʼal an Tʼokat Ejattaláb abal ka kʼale ban chabál xon ti yab kʼwajtsidh. ");
INSERT INTO husNT2005_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Kʼwajay tajaꞌ chab inik a kʼítsá akal i kʼij xon tu kʼwajíl an padhumtsik. Tajaꞌ, táꞌ jeye ti kʼwajat an lej atʼax abal ka taktamiyat kʼál na Jesús ani taꞌ jeye ti kʼwajat i tʼokat abatwáletsik xu tʼójontsáb kʼál na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Tayíl, tam ti balidhich na Juan ban wikʼaxteꞌ, na Jesús kʼale Galilea. In tʼilaꞌ tajaꞌ an alwaꞌ tʼilab xin ulal xan tu takʼix na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","In ulu enchéꞌ: ―Xoꞌ in bajúch xowkʼi neꞌech ka tujéch ti takʼyáb an iniktsik kʼal na Dios. Ka jilaꞌichtsik ta walablom ani ka belaꞌichtsik an alwaꞌ tʼilab. ");
INSERT INTO husNT2005_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jun i kʼij neꞌech ti belal na Jesús tin waltsik an pujal xi Galilea ani in chuꞌu na Simón junax kʼal nin kidháb Andrés, xi kʼwajat in petʼnáltsik nin jixáb an toꞌol ban jaꞌ, kom jajáꞌtsik u jixom toꞌol. ");
INSERT INTO husNT2005_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Utsantsik enchéꞌ kʼal na Jesús: ―Wana ta exóbal kʼal Nanáꞌ. Tatáꞌtsik i jixom toꞌol, por xoꞌ neꞌech tu okʼtsi xan ti ka aliy an atiklábtsik xi neꞌech ti kin belaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Jikʼatkʼi tin jilaꞌtsik nin jixáb an toꞌol ani in wéwnaꞌtsik na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","In óntsi tám ti belal ani in chuꞌu na Jakobo junax kʼal nin kidháb Juan. Jajáꞌtsik u chakámláb kʼal na Sebedeo ani kʼwajattsik jeye balidh bin tanil ti patsʼkʼux tin jixáb an toꞌol. ");
INSERT INTO husNT2005_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","In kaniytsik jeye abal ka junikná kʼál. In jilaꞌtsik tám nin tátaꞌ Sebedeo ban tan kʼal an tʼojnaltsik ani kʼaletsik kʼal na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Kʼaletsik tám ban bitsow Kapernaúm ani tam tin bajúch nin kʼítsájil an koyóxnich, na Jesús ochich ti okʼtsix ban atá xon tu tʼajnal an junkuntaláb. ");
INSERT INTO husNT2005_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Labantsik tʼajat xin achʼaꞌ xan tu okʼtsix na Jesús abal u okʼtsix kʼal yantam i awiltaláb ani yab jelti an okʼtsixtsik xin wilál nin takʼixtal na Dios xin jilám dhutsadh na Moisés. ");
INSERT INTO husNT2005_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Táꞌ jeye ti kʼwajat altá xon tu tʼajnal an junkuntaláb, jun i inik xi ochadh kʼal jun i atʼax ejattaláb ani dhájaxin kawidh enchéꞌ: ");
INSERT INTO husNT2005_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","―¿Jantʼéy a léꞌ kʼal wawáꞌ, Jesús xi Nasaret? ¿I tsiꞌnekxeꞌ abal ti ku kʼibdhaꞌ? Nanáꞌ tu exlál ani u choꞌób ke Tatáꞌ i Tʼokat Chakámláb kʼal na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Kʼwiyan tám enchéꞌ an atʼax ejattaláb kʼal na Jesús: ―¡Ki chamkʼan ani ki kale ba jechéꞌ an inik! ");
INSERT INTO husNT2005_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","An atʼax ejattaláb in wipipindhaꞌ chapik an inik, dhájan kawidh ani támkʼi ti kale ba jachanꞌ an inik. ");
INSERT INTO husNT2005_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ejtal an atiklábtsik laban tʼajat ani u útsáxtsik enchéꞌ: ―¿Jantʼéy in léꞌ kin ulu jechéꞌ xowaꞌ támun? ¿Jantʼom ít okʼtsixtaláb xin okʼtsixnál? ¡Abal Jajáꞌ in koꞌol i awiltaláb kin utsaꞌ ka kale an atʼax ejattaláb ani u axtsinal! ");
INSERT INTO husNT2005_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ejtal xowaꞌ in tʼajaꞌ na Jesús, jikʼatkʼi ti choꞌóbná kʼal ejtal xu kʼwajíltsik ban pulek chabál xi Galilea. ");
INSERT INTO husNT2005_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Tam ti kaléchtsik ban atá xon tu tʼajnal an junkuntaláb, na Jesús kʼale bin kʼimáꞌ na Simón ani na Andrés, junikná kʼal na Jakobo ani na Juan. ");
INSERT INTO husNT2005_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Nin mím na Simón taꞌ ti kwachat abal u kʼakʼél ani utsan na Jesús, ke an mímláb u yaꞌul. ");
INSERT INTO husNT2005_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ochich tám xon ti kʼwajat an yaꞌul, in téynaꞌ bin kʼubak ani in dhayaꞌ. Tsusbél ti wékʼon an kʼakʼlách. Tayíl, kʼapundhá na Jesús kʼal an mímláb ani an junkiltsik jeye. ");
INSERT INTO husNT2005_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Tam ti ochenekich na kʼítsá ani jikʼwchinékich, júntsin xon ti kʼwajat na Jesús ejtal an ti yaꞌultsik ani ejtal jeye xi ochadh kʼal i atʼax ejattalábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ejtal an atiklábtsik xi ba jachanꞌ an bitsow, junkun tin tamét in wiꞌlébil an atá. ");
INSERT INTO husNT2005_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jeldhá kʼal na Jesús yán i yaꞌultsik kʼal xowaꞌkich i yawꞌláchtsik xin koꞌol ani káldhantsat jeye yán ti atʼax ejattaláb xi kʼál ti ochadhtsik. Na Jesús u exláb kʼal an atʼax ejattalábtsik, jaxtám na Jesús yab in walkaꞌ kin ulutsik xitam jáꞌ jeye Jajáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Tam ti jun tsudhelom, bél tʼajat jikʼwax ti chʼakay na Jesús. Kale ban bitsow ani kʼale ti ól walteꞌ xon ti yab kʼwajtsidh. ");
INSERT INTO husNT2005_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Tayíl, na Simón kʼál nin juniktsik kʼale kin aliy na Jesús putálkʼi. ");
INSERT INTO husNT2005_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Tam tin elaꞌ na Jesús, in utsaꞌtsik enchéꞌ: ―Ejtaltsik exom ti ayal. ");
INSERT INTO husNT2005_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Por tókʼoyattsik enchéꞌ kʼal na Jesús: ―Wana ki álnaꞌ an píl kwentsaltsik xi utat abal ku tʼiltsitsik jeye an ti alwaꞌ tʼilab, pos jaꞌich tin tsiꞌnek techéꞌ ti kʼayꞌlá. ");
INSERT INTO husNT2005_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Anchanꞌ ti xeꞌchin na Jesús ti tʼiltsix ban atátsik xon tu tʼajnal an junkuntaláb putálkʼi Galilea ani ti káldhantsix an ti atʼax ejattalábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Utukná tám na Jesús kʼal jun i inik xu yaꞌul kʼal an kʼwajat atʼax tʼítʼ, tudhlan tin tamét na Jesús ani in utsaꞌ enchéꞌ: ―Max a léꞌ, neꞌech ka ejto ti kin jeldhaꞌ kʼal jecheꞌ an yawꞌlách xu koꞌol. ");
INSERT INTO husNT2005_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Na Jesús in yajnantsi an yaꞌul, in takaꞌ ani in utsaꞌ enchéꞌ: ―U léꞌ ani xoꞌ i jeléch. ");
INSERT INTO husNT2005_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Támkʼi ti wékʼon ejtal an kʼwajat atʼax tʼítʼ ani jilkʼon jelnek an inik. ");
INSERT INTO husNT2005_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Utsan tám enchéꞌ kʼal na Jesús: ―Yab xitaꞌ ka óltsi xowaꞌ tu tʼajtsi. Tokot ki kʼale xon ti kʼwajat nin páleꞌil an israelitatsik abal ki chuꞌtat ani ka kʼwajbantsi na Dios an ti pikbantsixtaláb jelt xan tin ulúmal na Moisés abal kin choꞌóbnaꞌ ejtaltsik ke i jeléch. ");
INSERT INTO husNT2005_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Por tam ti kʼaléch an inik, in tuju kin tʼiltsi xitaꞌkich xowaꞌ tʼajtsin kʼal na Jesús. Putálkʼi tin tʼilaꞌ. Jaxtám na Jesús yabich in ejto ka xeꞌchin tametláb ba ni jun i bitsow. U jilkʼonal xon ti yab kʼwajtsidh, por bélkʼi u utuknáb kʼal an atiklábtsik xi tál putálkʼi. ");
INSERT INTO husNT2005_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Tayíl, tam ti watʼenekich cháb óx a kʼítsá, witsiy juní na Jesús ban bitsow xi Kapernaúm. Tam ti choꞌóbná abal taꞌ ti kʼwajat ban atá xon tu kubél, ");
INSERT INTO husNT2005_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","jikʼatkʼi ti junkun yán i atiklábtsik ke nibalich ejtidh tin tamét in wiꞌlébil an atá ani Jajáꞌ in tʼiltsaltsik tin káwintal na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ulich tám i iniktsik xin tsiꞌdhál jun i yaꞌul inik xi yab in ejtowal ti belal. Kitámte tu tsiꞌdháb bin chaytéꞌil kʼal chéꞌ ti éb. ");
INSERT INTO husNT2005_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","In léꞌwiꞌik kin ódhaꞌtsik altá xon ti kʼwajat na Jesús, por yab in ejtotsik abal taꞌ ti kʼwajat yán i atiklábtsik. Xowaꞌ in tʼajaꞌtsik tám, kʼadhiytsik tin éb an atá ani in wixkʼintsi wéꞌ tin jujúl. Tajaꞌ tin ódhaꞌ ani tin paꞌbaꞌ an yaꞌul kʼal nin chaytéꞌil asta xon ti kʼwajat na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Tam ti na Jesús in chuꞌu xantʼéy in tʼajaꞌtsik, in choꞌóbnaꞌ abal u belnal kʼal jajáꞌtsik; jaxtám tin utsaꞌ enchéꞌ an inik: ―Jaꞌúb, na walastalábil pakwlantsidh ti kʼwajat. ");
INSERT INTO husNT2005_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Táꞌ jeye ti buxutsik cháb óx i okʼtsixtsik xin wilál nin takʼixtal na Dios xin jilám dhutsadh na Moisés xin chalpayaltsik enchéꞌ: ");
INSERT INTO husNT2005_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Jantʼókʼi tu káw yab alwaꞌ jechéꞌ an inik? Abal u káw jelti max u Dios. Tokot a Dios in ejtowal ti pakwlantsix an ti walastaláb.” ");
INSERT INTO husNT2005_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Por na Jesús in choꞌóbnaꞌ xantʼéy u chalpantsáb kʼal an okʼtsixtsik ani in utsaꞌtsik enchéꞌ: ―¿Jantʼókʼi tin chalpantsal anchanꞌ? ");
INSERT INTO husNT2005_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Jowaꞌ más yab tʼojláb ku utsaꞌ an yaꞌul: “Na walastalábil pakwlantsidhich ti kʼwajat”, o ku utsaꞌ: “Ki chʼakay, ka dhayaꞌ na chaytéꞌil ani ki beley”? ");
INSERT INTO husNT2005_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Pos neꞌech tu xalkʼantsitsik ke Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik, u koꞌol i awiltaláb techéꞌ ti chabál abal ku pakwlantsi i walastalábtsik. Utsan tám enchéꞌ an yaꞌul kʼal na Jesús: ");
INSERT INTO husNT2005_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","―Ki chʼakay, ka dhayaꞌ na chaytéꞌil ani ki kʼaléch ta kʼimáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Chʼakay tám an inik, in dhayaꞌ nin chaytéꞌil ani kaléch tám tin tamét ejtal an atiklábtsik. Ejtal xi tajaꞌtsik ti kʼwajat, laban tʼajat, in pubédhantsaltsik tin bij na Dios ani in ulaltsik enchéꞌ: ―Yab jaykʼi i chuꞌúmal jun xataꞌ jelti jechéꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Tayíl, witsiy juní na Jesús bin waltsik an pujal ani tam ti an atiklábtsik utey xon ti Jajáꞌ kʼwajat, in okʼtsitsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Tam ti exomich ti watʼel ban bél, in chuꞌu jun i inik buxúl xon tu bachʼwáb an jalbixtaláb abal an chabál xi Roma. An bachʼkʼul tumín in bij ta Lebí, nin kwitólil na Alfeo. Utsan enchéꞌ kʼal na Jesús: ―Wana ta exóbal kʼal Nanáꞌ. Chʼakay tám na Lebí ani in wéwnaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Tayíl, na Jesús kʼwajat ti kʼapul bin kʼimáꞌ na Lebí junax kʼal nin exóbaliltsik, kʼal yán i bachʼkʼul jalbixtaláb ani kʼal an walablomtsik kom yán xitaꞌ kʼál ti wéwnadh. ");
INSERT INTO husNT2005_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Por an okʼtsixtsik xin wilál nin takʼixtal na Dios ani an fariseotsik, tam tin chuꞌu ti kʼapul na Jesús junax kʼal an walablomtsik ani kʼal an bachʼkʼul jalbixtaláb, in konoy enchéꞌ an exóbaltsik: ―¿Jantʼókʼi tu kʼapul na Okʼtsíxal kʼal an bachʼkʼul jalbixtaláb ani kʼal an walablomtsik? ");
INSERT INTO husNT2005_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Tam ti na Jesús in achʼaꞌ xowaꞌ in ulutsik, in utsaꞌtsik enchéꞌ: ―Xu yaꞌul, jaꞌich nin yéntsal an ilálix; xi yab u yaꞌul, yab in yéntsal. Anchanꞌ jeye, an walablomtsik jaꞌich xitaꞌ tin yéntsal. Jaxtám, Nanáꞌ yab in tsiꞌnek ku aliy xi xeꞌechtsik lujat, in tsiꞌnek ku aliy xi walbidhtsik abal ki jilaꞌichtsik ti walablom. ");
INSERT INTO husNT2005_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Jun i kʼij, tam ti nin exóbaliltsik na Juan kʼílin ani nin exóbaliltsik jeye an fariseotsik, ulich cháb óx i atiklábtsik xon ti kʼwajat na Jesús abal ka konyat enchéꞌ: ―¿Jantʼókʼi tu kʼíl an fariseotsik, nin exóbaliltsik jeye na Juan ani na exóbaliltsik yabaꞌ? ");
INSERT INTO husNT2005_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Tókʼoyattsik enchéꞌ kʼal na Jesús: ―¿Awxeꞌ neꞌech kin ejto ka kʼílintsik xi kanidh ba jun i tomkixtaláb tam bél kʼwajat an tomkinél inik kʼal jajáꞌtsik? ¡Yabaꞌ! ");
INSERT INTO husNT2005_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Por neꞌech kin bajaw an kʼij tam an tomkinél inik neꞌech ka wixkʼintsat ani neꞌchich jeye tám ka kʼílintsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","ʼYab xitaꞌ in patsʼkʼuyal i kʼej xeketláb kʼal jun pejeꞌ i ít kʼudhkʼum; pos an ít kʼudhkʼum, u muchel ani in michʼál más an kʼej kʼudhkʼum. ");
INSERT INTO husNT2005_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Nibal u balyáb an ít yajtsik uxnél ban kʼej ótʼ balixtaláb; pos max ka tʼajan anchanꞌ, an ít yajtsik uxnél in michʼál an kʼej ótʼ balixtaláb, neꞌech tám ka wakʼlan an yajtsik uxnél ani an ótʼ balixtaláb u kʼibchonal. Jaxtám ti yejat ka balyat an ít yajtsik uxnél ban ít ótʼ balixtaláb abal chablam yab ka kʼibchon. ");
INSERT INTO husNT2005_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Jun i sábado, xi jaꞌich nin kʼítsájil an koyóxnich, na Jesús xeꞌech ba jun i aleláb xon ti tʼayadh i trigo ani nin exóbaliltsik in tuju kin puꞌu an trigo abal kin kʼapu. ");
INSERT INTO husNT2005_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Utsan tám enchéꞌ na Jesús kʼal an fariseotsik: ―Ka telaꞌ, ¿jantʼókʼi tin tʼajál i tʼojláb na exóbaliltsik xi yab alwaꞌ ka tʼajan tam in kʼítsájil i koyóxnich? ");
INSERT INTO husNT2005_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Por tókʼoyattsik enchéꞌ kʼal na Jesús: ―¿Yabxeꞌ jaykʼi a ajyámaltsik xowaꞌ in tʼajaꞌ na Dabid junax kʼal nin juniktsik tam ti bél ejat na Abiatar, nin okʼlékil an páleꞌtsik? Kʼaꞌaytsik tʼajat ani yab in koꞌol xataꞌ kin kʼapu. ");
INSERT INTO husNT2005_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Jaxtám ti ochich na Dabid ban pulek atá xon tu kʼakʼnáb na Dios ani in kʼapu an pan xi pikbantsidh na Dios maske yab jajáꞌ in bijtsíl kin kʼapu. Tokot in bijtsíl kin kʼapu an páleꞌtsik. Na Dabid yab u páleꞌ, por in kʼapu jachanꞌ an pan ani in pidhaꞌ jeye nin juniktsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Utsantsik jeye enchéꞌ: ―Na Dios in jilaꞌ nin kʼítsájil an koyóxnich abal tin alwaꞌbíl an iniktsik ani yab abal kin kóꞌoy jelti jun i tʼojlixtaláb. ");
INSERT INTO husNT2005_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Jaxtám, Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik, u koꞌol i awiltaláb abal ku ulu xowaꞌ alwaꞌ ka tʼajan tam in kʼítsájil an koyóxnich. ");
INSERT INTO husNT2005_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Tayíl, ochich juní na Jesús ban atá xon tu tʼajnal an junkuntaláb ani tajaꞌ, taꞌ jeye ti kʼwajat jun i inik xi mulkanék in kʼubak. ");
INSERT INTO husNT2005_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Táꞌ jeye ti kʼwajat i atiklábtsik ti kwáchix abal u leꞌnáb ka chuꞌtat max na Jesús kin jeldhaꞌ an yaꞌul tin kʼítsájil an koyóxnich, pos max kin jeldhaꞌ, in chalpayaltsik tám kin ólnaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Utsan tám enchéꞌ kʼal na Jesús an inik xi mulkanék nin kʼubak: ―Ki kubey núꞌ junax chʼejel. ");
INSERT INTO husNT2005_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Utsan tám enchéꞌ an atiklábtsik kʼal na Jesús: ―¿Jantʼéy alwaꞌ ki tʼajaꞌ tam in kʼítsájil an koyóxnich? ¿Ki tʼajaꞌ xowaꞌ alwaꞌ o xowaꞌ yab alwaꞌ? ¿Alwaꞌxeꞌ ki jeldhaꞌ an yaꞌultsik o ki walbaꞌ ka chemech? Por yabtsik in elaꞌ xan ti ka tókʼon. ");
INSERT INTO husNT2005_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Na Jesús chakuy ani tʼeꞌpin tam tin teloloy xi taꞌ ti bukúl abal yabtsik tʼajat in léꞌ kin exbay. In utsaꞌ tám enchéꞌ an inik xi mulkanék nin kʼubak: ―Ka lujku na kʼubak. In lujku tám ani jeley. ");
INSERT INTO husNT2005_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Kaletsik tám an fariseotsik ani kʼale ti junkunal kʼal in kidhtal na Erodes abal kin chalpaytsik junax xan ti kin uwaꞌ abal kin ejto kin chemdhaꞌ na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Por na Jesús kʼale bin wál an pujal junax kʼal nin exóbaliltsik ani wéwná kʼal yán i atiklábtsik xi tál Galilea. ");
INSERT INTO husNT2005_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Tam ti choꞌóbná ke na Jesús in tʼajál an pakdhaꞌ labidh labandhaxtaláb, ulich tám xon ti Jajáꞌ kʼwajat yán i atiklábtsik xi tál Judea ani xi tál Jerusalén, xi tál Idumea, xi tál tin ejtsím kalel kʼítsá kʼal an waljaꞌ Jordán ani xi tál jeye ban chabál xi Tiro ani Sidón. ");
INSERT INTO husNT2005_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Jaxtám na Jesús tin utsaꞌ nin exóbaliltsik abal kin kóꞌoy tʼojojodhich jun i tan xon ti ka balin max ka nichʼokʼná kʼal tin kwenta nin yaníl an atiklábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Kom yánich xitaꞌ in jeldhámal, ejtal an yaꞌultsik tokot u níxkʼáxtsik abal in léꞌ ka utey kin takaꞌ na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Táꞌ jeye ti kʼwajat xi ochadhtsik kʼal i atʼax ejattalábtsik. Tam ka chuꞌtat na Jesús kʼal jajáꞌtsik, u tudhlanal tin tamét na Jesús ani u dhajnal tʼilomtsik chapik enchéꞌ: ―¡Tatáꞌ i Chakámláb kʼal a Dios! ");
INSERT INTO husNT2005_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Por utsantsik abal yab kin ulu xitam jáꞌ jeye na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Tayíl, kʼadhiy na Jesús ba jun i chʼén ani in kaniytsik xitaꞌ Jajáꞌ in leꞌnaꞌ abal ka junikná kʼál. Tam ti ulichtsik xon ti Jajáꞌ kʼwajat, ");
INSERT INTO husNT2005_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","in takuy tám lajucháb i iniktsik abal ka xeꞌchin kʼal Jajáꞌ ani abal kin abaꞌtsik kin tʼilaꞌ an alwaꞌ tʼilab. ");
INSERT INTO husNT2005_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","In pidhaꞌtsik ti awiltaláb abal kin jeldhaꞌ i yaꞌultsik ani kin káldhaꞌ i atʼax ejattalábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Jéꞌ kʼwajat nin bij xi lajucháb in takuy: Jún u Simón xin bijiy jeye ta Pedro, ");
INSERT INTO husNT2005_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","na Jakobo kʼál nin kidháb Juan, xu chakámlábtsik kʼal na Sebedeo. Jechéꞌ cháb in bijiy jeye ta Boanerjes. Jechéꞌ an bijláb in léꞌ kin ulu, in chakámiltsik i junkil áb. ");
INSERT INTO husNT2005_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Na Andrés, na Felipe, na Bartolomé, na Mateo, na Tomás ani na Jakobo, xu chakámláb kʼal na Alfeo. Na Tadeo ani na Simón; jechéꞌ na Simón jaꞌich xu takʼnal kʼal an junkunél xu bijyáb kananista. ");
INSERT INTO husNT2005_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Takwyat jeye na Judas Iskariote, xi tayíl pidhnaxin an ta Jesús abal ka chemdhá. Tayíl, ochich na Jesús ba jun i atá junax kʼal nin exóbaliltsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Junkun juní yán i atiklábtsik ke asta nibalich u jolkʼanal ti kʼapul na Jesús ani nin exóbaliltsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Tam tin choꞌóbnaꞌtsik jechéꞌ nin at kidhtal na Jesús, kʼale ti ikʼtáb abal in chalpayaltsik max olmanék na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ulich jeye an okʼtsixtsik xin wilál nin takʼixtal na Dios, xi táltsik Jerusalén ani in ulaltsik enchéꞌ: ―Jechéꞌ an inik kʼwajat teykómte kʼal an lej atʼax, nin okʼlékil an atʼax ejattalábtsik ani kʼal tin cháp an lej atʼax tin káldhál an atʼax ejattalábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jaxtám tin kaniy na Jesús ka utey xon ti Jajáꞌ kʼwajat xin ulutsik anchanꞌ. In wiltsitsik tám cháb óx ti káw abal kin exbay an tsubaxtaláb, in utsaꞌtsik enchéꞌ: ―¿Janti neꞌech kin ejto an lej atʼax kin káldhaꞌ tinbáꞌ xi kʼwajat bin itsích an iniktsik? ");
INSERT INTO husNT2005_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Max an atiklábtsik xu takʼnal ba jun i bitsow ka kʼéꞌáxin kweneꞌ ti kweneꞌ ani ka péjéxin kʼal in at kidhtal, jachanꞌ an bitsow neꞌech ka taley. ");
INSERT INTO husNT2005_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Aníl jeye, max xu kʼwajíltsik ba jun i atá ka péjéxintsik, neꞌech ka kʼéꞌáxin. ");
INSERT INTO husNT2005_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Max an lej atʼax ka kʼwajay ti péjéx kʼal in at atʼax, yabich neꞌech kin ejto ti okʼlek. Neꞌech ka okʼon nin awiltal. ");
INSERT INTO husNT2005_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","ʼNi jun xitaꞌ neꞌech kin ejto ka ochich bin kʼimáꞌ jun i likat inik ani kin kʼántsi xowaꞌ in koꞌol max yab kin wikʼaꞌ okʼox. Tokot neꞌech kin ejto kin kʼántsi xowaꞌ in koꞌol max kin wikʼaꞌ okʼox. ");
INSERT INTO husNT2005_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","ʼTsubax tu utsáltsik, ke na Dios neꞌech kin pakwlantsi ejtal tin walab an iniktsik ani an atʼax odhbijixtaláb jeye xu usnal. ");
INSERT INTO husNT2005_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Por xitaꞌ kin odhbijiy an Tʼokat Ejattaláb, yab jaykʼi neꞌech ka pakwlantsat kʼal na Dios; neꞌech ka jilkʼon walbidh malilíl i kʼij. ");
INSERT INTO husNT2005_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Anchanꞌ tin ulu na Jesús kom u usnal ke Jajáꞌ in koꞌol jun i atʼax ejattaláb. ");
INSERT INTO husNT2005_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ulich tám nin nánaꞌ ani nin kidhábtsik na Jesús, in abnaꞌ ka kantsin an ta Jesús ani jajáꞌtsik jilkʼon eléb. ");
INSERT INTO husNT2005_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Utsan tám enchéꞌ na Jesús kʼal xi taꞌ ti buxutsik wililíl xon ti Jajáꞌ kʼwajat: ―Na nánaꞌ ani na kidhábtsik taꞌ kʼwajat núꞌ eléb ani ti ayal. ");
INSERT INTO husNT2005_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Por utsantsik enchéꞌ kʼal na Jesús: ―¿A exláltsikxeꞌ xitaꞌ jáꞌ nu nánaꞌ ani nu kidhábtsik? ");
INSERT INTO husNT2005_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","In telaꞌ tám xi taꞌ ti buxutsik wililíl ani in ulu enchéꞌ: ―Jechéꞌtsik jaꞌich xi kʼwajattsik jelti nu nánaꞌ ani jelti nu kidhábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Pos xitaꞌ in tʼajál xowaꞌ in léꞌ na Dios, jachanꞌ jaꞌich nu kidháb, nu ixám ani nu nánaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jun i kʼij, na Jesús tujey juní ti okʼtsix bin wál an pujal, junkun yán i atiklábtsik xon ti Jajáꞌ kʼwajat ani wiliyat. Jaxtám ti balin na Jesús ba jun i tan xi kʼwajat ban pujal ani buxkan, an atiklábtsik jilkʼon tin wál an pujal. ");
INSERT INTO husNT2005_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","In okʼtsitsik tám yán xataꞌ, por kʼal i junbaxtalábkʼi. Tam ti exomich in okʼtsal, in utsaꞌtsik enchéꞌ: ");
INSERT INTO husNT2005_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―Ka achʼaꞌtsik jechéꞌ an junbaxtaláb xi neꞌech tu tʼiltsi: Jun i kʼij, kale jun i inik ti búkʼul iyaláb bin ale. ");
INSERT INTO husNT2005_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Tam ti exomich in bukʼwal an iyaláb, taltsik kwajlan ban bél, ulich an chʼichintsik ani in kʼapu. ");
INSERT INTO husNT2005_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Taltsik an iyaláb, kwajlan ban tʼujublom xon ti yab lej owtsik an lukuk ani jikʼat ti ixkʼan. ");
INSERT INTO husNT2005_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Por tam ti yajbé an kʼakʼal, batʼey ani kom yab owtsik tin koꞌol nin ibíl, wayey. ");
INSERT INTO husNT2005_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Taltsik an iyaláb kwajlan ban kʼídhlom, pakey an kʼídhtsik ani in paxkʼiy an tʼayabláb ani yab xataꞌ in kóꞌoy. ");
INSERT INTO husNT2005_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Por taltsik an iyaláb kwajlan xon ti alwaꞌ an chabál, ixkʼan, pakey ani labey tʼajat. Taltsik, kʼal jún tokot an iyaláb xi tʼayan, in kóꞌoy jun inik láju itsixlek; taltsik, ox inik ani taltsik, boꞌ inik. ");
INSERT INTO husNT2005_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","In utsaꞌtsik tám enchéꞌ xi taꞌ ti kʼwajattsik: ―Xitaꞌ in koꞌol nin ochʼoxtal alwaꞌ, kin exbay xowaꞌ u ulal. ");
INSERT INTO husNT2005_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Tayíl, tam ti jilkʼonich kwetém na Jesús, konyat kʼal xi taꞌ ti kʼwajattsik jeye kʼunat junax kʼal xi lajucháb an exóbaltsik xantʼéy in léꞌ kin ulu jachanꞌ an junbaxtaláb xin ulu. ");
INSERT INTO husNT2005_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Utsantsik enchéꞌ: ―Tatáꞌtsik, ti pidhál na Dios ka choꞌóbnaꞌ xowaꞌ in koꞌol yab tejwaꞌ kʼal tin kwenta xan ti Jajáꞌ tu takʼix. Por xi yabtsik tin belál, tokot u okʼtsaltsik kʼal i junbaxtaláb. ");
INSERT INTO husNT2005_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Abal anchanꞌ, maske in chuꞌtaltsik, por jáykʼi max yab in chuꞌtal; in achʼáltsik, por yab in exbayal. Anchanꞌ yab neꞌech ka uteytsik kʼal Nanáꞌ abal ku pakwlantsi tin walastalábiltsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Utsantsik jeye enchéꞌ: ―¿Yab a exbayaltsik jechéꞌ an junbaxtaláb? Pos max yab a exbayaltsik, ¿jan ti neꞌech ka ejto ka exbaytsik xi más an junbaxtaláb? ");
INSERT INTO husNT2005_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","An inik xu búkʼul iyaláb, in junwal jelti xin tʼilál nin káwintal na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Xowaꞌ u támnal kʼal taltsik an atiklábtsik xin achʼál nin káwintal na Dios, in junwal jelt xan ti támun kʼal an iyaláb xi kwajlan ban bél. Tam in achʼámalich, u utuknáb kʼal an lej atʼax ani u tʼajnal kin ukʼtsi xowaꞌ in achʼámal. ");
INSERT INTO husNT2005_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Xowaꞌ u támnal kʼal xi kʼeꞌet an atiklábtsik, in junwal jelt xan ti támun kʼal an iyaláb xi kwajlan xon ti yab lej waꞌach an lukuk. In achʼál nin káwintal na Dios ani in bachʼwal kʼal i kulbétaláb. ");
INSERT INTO husNT2005_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Por eb itsíchkʼi, jaxtám ti yab u owel an kulbétaláb; pos tam kin tamu jun xataꞌ yajtsik o ka atʼantsik abal in bachʼúmal nin káwintal na Dios, in jiláltsik kin belaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Xowaꞌ u támnal kʼal xi kʼeꞌettsik, in junwal jelt xan ti támun kʼal an iyaláb xi kwajlan ban kʼídhlom. In achʼáltsik nin káwintal na Dios, ");
INSERT INTO husNT2005_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","por u chalpaxtsik tʼajat kʼal xowaꞌ in léꞌtsik kin tʼajaꞌ ani u kʼambiyábtsik kʼal an tumín abal in chalpayaltsik ke an tumín u kʼijidhmédhom. In léꞌtsik jeye tʼajat kin kóꞌoy ejtal xowaꞌ waꞌach. Jaxtám, max jaꞌich tokot in chalpómtsik echʼekʼi, in ukʼtsal nin káwintal na Dios ani yab u tʼájnal ni jun xataꞌ alwaꞌ ba jajáꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Por xowaꞌ u támnal kʼal xi kʼeꞌettsik, in junwal jelt xan ti támun kʼal an iyaláb xi kwajlan ban chabál xi alwaꞌ. Tam in achʼáltsik nin káwintal na Dios, in bachʼwal ani in beláltsik kʼal yantam in ejattal. Jechéꞌtsik in junwal jelti an tʼayabláb xi labey tʼajat. Taltsik, kʼal jún tokot an iyaláb xi tʼayan, in pidhnaꞌ jun inik láju itsixlek, taltsik in pidhnaꞌ ox inik itsixlek ani xi taltsik, in pidhnaꞌ boꞌ inik. ");
INSERT INTO husNT2005_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Utsantsik jeye enchéꞌ: ―¿Awxeꞌ u letʼkʼoyáb jun i tajbaxtaláb abal ka paxkʼiyat kʼal jun i kajón o abal ka kʼwajbá bin ál i waytaláb? ¡Yabaꞌ! An tajbaxtaláb u letʼkʼoyáb ani u kʼwajbáb tʼekʼat abal ka tajbaxin alwaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Pos yab waꞌach ni jun xataꞌ chinat xi yab neꞌech ka xalkʼá tayíl, nibal waꞌach ni jun xataꞌ yab tejwaꞌ xi yab neꞌech ka choꞌóbná. ");
INSERT INTO husNT2005_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Max a koꞌoltsik a ochʼoxtal alwaꞌ, ka exbaytsik xowaꞌ u ulal. ");
INSERT INTO husNT2005_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Utsantsik jeye: ―Ka kóꞌoytsik i kwenta kʼal xowaꞌ exom a achʼál. Max wéꞌ i chápláb ka tʼajaꞌtsik abal ka exbay, wéꞌ jeye neꞌech ki pidhantsik ka exbay kʼal na Dios. Por max yán i chápláb ka tʼajaꞌtsik, yán jeye neꞌech ki pidhantsik ani más tʼajat neꞌech ki pidhan ka exbaytsik kʼal na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Xin exbayaltsik, neꞌech ka tolmiyat más kʼal na Dios abal kin exbay; ani xi yab in lej exbayal, neꞌech ka tʼajan kin ukʼtsitsik kʼal na Dios xowaꞌ wéꞌ in exbayámal. ");
INSERT INTO husNT2005_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","In ulu jeye enchéꞌ na Jesús: ―Xan tu takʼix na Dios in junwal jelti jun i inik xi kʼale ti óm bin ale. ");
INSERT INTO husNT2005_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Tam ómámadhich, neꞌech tám ka kʼaléch ti wayal ani tam ka tsudhey neꞌech ka chʼakay. Ani anchankʼi, tsudhél u tajkʼanal u watʼel an kʼij. Lejat an iyaláb u ixkʼanal ani u pubel, por jajáꞌ yab in choꞌób xan ti. ");
INSERT INTO husNT2005_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","An chabál jaꞌich nin ixkʼandhál an tʼayabláb ani in pubedhál. Okʼox u xeknal, u wixnal ani tayíl u walim. ");
INSERT INTO husNT2005_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Tam kin bajúch nin yéjnék an tʼayabláb, an dhabal neꞌech tám kin junkuntsích an tin walíl abal in bajúmalich an kʼij ka junkuwat. ");
INSERT INTO husNT2005_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","In óntsi ti káw ani in ulu jeye enchéꞌ: ―Neꞌech jeye tu tʼiltsitsik kʼeꞌet ti junbaxtaláb abal tu óltsi xan tu takʼix na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","In junwal jelt in itsích an mostasa. Jechéꞌ, jaꞌich an iyaláb xi más tsʼitsik xu tʼaynal techéꞌ ti kʼayꞌlá, ");
INSERT INTO husNT2005_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","por tam tʼayadhich, u ixkʼanal ani u pubel más ké xi kʼeꞌet an tʼayablábtsik. In kóꞌyal tʼajat pakdhaꞌ in kʼweꞌél, in kóꞌyal tʼajat i chalam ani an chʼichintsik in tʼajál tajaꞌ nin pákʼw. ");
INSERT INTO husNT2005_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Anchanꞌ ti okʼtsintsik an ti tsubaxtaláb kʼal na Jesús. Yán i junbaxtaláb tʼiltsintsik jelti jechéꞌ abal ka okʼtsintsik xantikʼi kin ejtotsik kin exbay. ");
INSERT INTO husNT2005_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Tokot kʼal i junbaxtalábkʼi tin okʼtsaltsik, por nin exóbaliltsik, in wiltsal ejtal xowaꞌ in léꞌ kin ulu an junbaxtaláb tam kʼwajatichtsik kwetém. ");
INSERT INTO husNT2005_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Tam ti dhamúch jachanꞌ a kʼítsá, in utsaꞌ enchéꞌ nin exóbaliltsik: ―Wana ku watʼey jun pakʼeꞌ pujal. ");
INSERT INTO husNT2005_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","In jilaꞌ tám an atiklábtsik xi taꞌ ti kʼwajat bin wál an pujal ani kʼaletsik kʼal an tan xon ti kʼwajat balidh. Táꞌ jeye ti kʼwajat i atiklábtsik ba kʼeꞌet i tantsik ani kʼale jeye kin juniknaꞌ na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Jun jikʼtowále ti tujey ti wawꞌnal jun i chapik ikʼ ani in múlákʼindhaꞌ an jaꞌ. Ochich an jaꞌ ban tan ke asta wéꞌich tʼajat ka tsʼutsich an tan kʼal an jaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Na Jesús kʼwajat ti wayal ba jun i latsikʼláb tin kúx an tan. Bakyat tám kʼal nin exóbaliltsik ani utsan enchéꞌ: ―¡Okʼtsix! ¿Yabxeꞌ a ódhál ti kwenta max ku lupun? ");
INSERT INTO husNT2005_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Chʼakay tám na Jesús in kʼwiyaꞌ an ikʼ ani in utsaꞌ enchéꞌ an pujal: ―¡Ki chamkʼan! ¡Yabich ki kʼuchun! Támkʼi ti kublan ti wawꞌnal an ikʼ ani jilkʼon chamamadh tʼajat. ");
INSERT INTO husNT2005_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Utsan tám enchéꞌ an exóbaltsik kʼal na Jesús: ―¿Jantʼókʼi ta jikʼéltsik ani jantʼókʼi ti yabtsik tin belál? ");
INSERT INTO husNT2005_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Jikʼeytsik tʼajat ani u útsáxtsik jún ani jún enchéꞌ: ―¿Jantʼom awiltaláb in koꞌol jechéꞌ an inik abal u axtsinal tam kin tawnaꞌ an ikʼ ani an pujal? ");
INSERT INTO husNT2005_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ulichtsik tám jun pakʼeꞌ pujal ban chabál xin bij Gadara. ");
INSERT INTO husNT2005_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Tam ti na Jesús exomich ti kalel ban tan, ulich jun i inik xi kʼwajat ochadh kʼal i atʼax ejattaláb. Jajáꞌ tál xon tu jolyáb an chemélomtsik ");
INSERT INTO husNT2005_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","abal tajaꞌich u kʼwajíl; kom watʼats ti olmanékich, yabich u ejtowáb ka yakʼwan, nibal ka wikʼan kʼal i patʼál. ");
INSERT INTO husNT2005_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Yantalich wikʼtsidh tin akan ani tin kʼubak kʼal i patʼál, por táyidh in tʼapyal ani in muꞌwal an patʼál. Kʼal ni jun xitaꞌ tu ejtowáb ka átá. ");
INSERT INTO husNT2005_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Akal i kʼij u xeꞌchinal ti dhajnal ban chʼénlom, ban jólimtaláb ani in chʼojbédhál tinbáꞌ kʼal i tʼujub. ");
INSERT INTO husNT2005_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Tam ti ów chuꞌtat na Jesús, ájlách an inik abal kin utuknaꞌ ani tudhlan tin tamét. ");
INSERT INTO husNT2005_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ani kawidh ti utsan enchéꞌ na Jesús: ―Jesús, xi Chakámláb kʼal na Dios xi púlek tʼajat, ¿jantʼéy a léꞌ kʼal nanáꞌ? Tu kontsal kʼal tin bij na Dios abal yab ti kin lej watʼpintsi an ti yajtsiktaláb. ");
INSERT INTO husNT2005_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Anchanꞌ tin ulu abal kʼwajatich ti usnal enchéꞌ kʼal na Jesús: ―¡Atʼax ejattaláb, ki kale ba jechéꞌ an inik! ");
INSERT INTO husNT2005_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Konyat tám enchéꞌ an atʼax ejattaláb kʼal na Jesús: ―¿Jan ta bij? Jajáꞌ tókʼon enchéꞌ: ―Nanáꞌ u bij Lejión, kom yán tʼajat tu éb. ");
INSERT INTO husNT2005_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Pakabédhá tʼajat na Jesús kʼal jún ti éb an atʼax ejattaláb abal yab ka abantsik píl chabál ti kʼwajíl. ");
INSERT INTO husNT2005_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Kom taꞌ ti xeꞌech tajaꞌ utat ban chʼén yán i olom ti kʼapupúl, ");
INSERT INTO husNT2005_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","pakabédhá na Jesús kʼal ejtal an atʼax ejattalábtsik enchéꞌ: ―Ti ku walkaꞌ ku ochich ban olomtsik xi núꞌ xeꞌech. ");
INSERT INTO husNT2005_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Tokʼontsat tám kʼal na Jesús xowaꞌ in konoytsik, kale tám an atʼax ejattalábtsik ban inik ani ochich ban olomtsik. Chab mil xónaꞌ in yaníl an olomtsik, bololól ti kʼale adhik ban chʼén, in petʼnaꞌ tinbáꞌ ban pujal ani tajaꞌ ti lupuntsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ájláchtsik tám an belkol olomtsik, kʼale ban bitsow ani bin waltsik an bitsow abal kin tʼiltsi an atiklábtsik xantʼéy támun. An atiklábtsik xu kʼwajíl ba jachanꞌ an bitsow kʼaletsik tám kin chuꞌu xantʼéy támnék. ");
INSERT INTO husNT2005_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Tam ti ulichtsik xon ti kʼwajat na Jesús, chuꞌtat an inik xi teykómtewiꞌik kʼal an atʼax ejattalábtsik, buxúlichkʼi, xeketlidhich ani juntam anikʼijich. Jikʼey an atiklábtsik xi ulich ti telom. ");
INSERT INTO husNT2005_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Xin chuꞌutsik xantʼéy támun kʼal an inik xi kʼwajatwiꞌik teykómte kʼal an atʼax ejattalábtsik ani xantʼéy jeye támun kʼal an olomtsik, jaꞌich kʼál ti tʼiltsin an atiklábtsik xi ulich. ");
INSERT INTO husNT2005_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Tujey tám ti pakabédháb na Jesús kʼal an atiklábtsik abal ka kaléch ba jachanꞌ an chabál. ");
INSERT INTO husNT2005_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Tam ti na Jesús exomich ti ochel ban tan, an inik xi teykómtewiꞌik kʼal an atʼax ejattaláb in pakabédhaꞌ na Jesús abal ka júná jeye kʼal Jajáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Por na Jesús yab in leꞌnaꞌ, tokot in utsaꞌ enchéꞌ: ―Ki kʼaléch ta kʼimáꞌ xon ti kʼwajat na jaꞌúbtsik, ka tʼiltsi ejtal xantʼéy ti tʼajtsámal an Okʼóxláb ani xan ti kóꞌontsámal ti yajnantsixtaláb. ");
INSERT INTO husNT2005_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Kʼale an inik ani tujey tám kin tʼiltsi an atiklábtsik xu kʼwajíl ba xi láju an bitsowtsik xu takʼnal Dekápolis an ti pakdhaꞌ labidh labandhaxtaláb xowaꞌ tʼajtsin kʼal na Jesús. Tam tin achʼaꞌtsik xowaꞌ tʼiltsin, labantsik tʼajat. ");
INSERT INTO husNT2005_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ochich tám na Jesús ban tan ani tam ti ulich juní jun pakʼeꞌ pujal, yán i atiklábtsik junkun wililíl xon ti kʼwajat na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ulich jun i inik xin bij ta Jairo xu okʼlek jeye ban atá xon tu tʼajnal an junkuntaláb. Tam ti chuꞌtat na Jesús, tudhlan na Jairo tin tamét ");
INSERT INTO husNT2005_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ani pakabédhá enchéꞌ: ―Nu tsidhánil exomich ti chemel, jalaꞌ ka puntsi an ta kʼubak bin tʼuꞌúl abal ka jeley ani yab ka chemech. ");
INSERT INTO husNT2005_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Kʼale tám na Jesús kʼal na Jairo ani yán kʼale ti juniknax. Kʼal nin yaníl an atiklábtsik, u nichʼokʼnábich tʼajat na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Táꞌ jeye ti kʼwajat jun i mímláb xin kidhbayámalich lajucháb i tamub ti yaꞌul kʼal i lakúmtaláb ani yab u jelél. ");
INSERT INTO husNT2005_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","In watʼnámalich tʼajat yajtsik kʼal yán i ilálixtsik, in pakúmalich ejtal nin tumínal ti ilálnal, por yab u elábmél; más tokot yawꞌláchich. ");
INSERT INTO husNT2005_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","An mímláb in achʼámal an pakdhaꞌ labidh labandhaxtaláb xin tʼajál na Jesús ani in chalpayal enchéꞌ: “Max ku ejto ku taktsi tin kʼudhkʼúmil, neꞌech kin jeley.” Jaxtám ti utey tin yaníl an atiklábtsik xi taꞌ ti tál, in utuknaꞌ na Jesús tin kúx ani in taktsi tin kʼudhkʼúmil. ");
INSERT INTO husNT2005_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Támkʼi ti kublan ti yaꞌul ani in choꞌóbnaꞌ abal jeléch. ");
INSERT INTO husNT2005_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Na Jesús in achʼaꞌ abal jeley jun xitaꞌ kʼal an chápláb xin koꞌol, chawꞌkʼin ani konoxin enchéꞌ: ―¿Jitaꞌ tin taktsi tu kʼudhkʼúmil? ");
INSERT INTO husNT2005_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Utsan tám enchéꞌ kʼal nin exóbaliltsik: ―A telálich pé jéꞌ kʼwajat yán i atiklábtsik ti kʼichʼkʼóm, ani ¿bél a konyal xitaꞌ ti takaꞌ? ");
INSERT INTO husNT2005_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Por na Jesús in teloloy putál abal kin chuꞌu xitam jáꞌ na takxinék. ");
INSERT INTO husNT2005_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Utey tám an mímláb ani tudhlan tin tamét na Jesús u wipipíl kʼal i jíkʼib abal in choꞌób xantʼéy támnék kʼal jajáꞌ. An mímláb in utsaꞌ ejtal na Jesús kʼal tin kwenta xowaꞌ in tʼajám. ");
INSERT INTO husNT2005_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Utsan tám enchéꞌ kʼal na Jesús: ―Mímláb, i jeley abal i belmách. Awil ki kʼaléch tsububudh a itsích, i jeléch kʼal an yawꞌlách xa koꞌolwiꞌik. ");
INSERT INTO husNT2005_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Tam ti na Jesús bél kʼwajat ti tʼilom, ulich cháb óx i iniktsik xi tál tin kʼimáꞌ na Jairo ani utsan enchéꞌ: ―Na tsidhánil chemech, yabich ka tʼojliy an Okʼtsix. ");
INSERT INTO husNT2005_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Na Jesús in achʼaꞌ xowaꞌ ulwat ani in utsaꞌ enchéꞌ na Jairo: ―Yab ki kʼwajay ta chalpax, ka belaꞌ tokot abal Nanáꞌ neꞌech ku ejto tu tolmiy. ");
INSERT INTO husNT2005_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Kʼale tám na Jesús kʼal na Jairo ani tokot in walkaꞌ ka junikná kʼal na Pedro, na Jakobo ani na Juan, nin kidháb na Jakobo. ");
INSERT INTO husNT2005_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Tam ti ulich bin kʼimáꞌ jachanꞌ an inik xu okʼlek ban atá xon tu tʼajnal an junkuntaláb, in achʼaꞌ abal kʼíbalich tʼajat an ukʼil ani an dhajal abal chemech an tsidhan. ");
INSERT INTO husNT2005_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ochich tám na Jesús ban altá ani in utsaꞌtsik enchéꞌ: ―¿Jantʼókʼi ta ukʼnaltsik ani ta dhajnaltsik? An tsidhan yab chemnek, u wayalkʼi ti kʼwajat. ");
INSERT INTO husNT2005_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Jajáꞌtsik in labídhnaꞌkʼi tokot na Jesús. Utsantsik tám kʼal na Jesús abal ka kale ejtal eléb, ochich ban altá xon ti kʼwajat an tsidhan junkímte kʼal an tátaꞌláb, an nánaꞌláb ani xi kʼalnek an ti junkiltsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","In téynantsi tám tin kʼubak an tsidhan ani káwin arameo enchéꞌ: ―Talita, kumi. Ti tének káw, in léꞌ kin ulu: Tsidhan, ki chʼakay. ");
INSERT INTO husNT2005_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Támkʼi ti chʼakay ani beley jachanꞌ an tsidhan xin koꞌol lajucháb i tamub ani ejtaltsik xin chuꞌu jechéꞌ, labantsik tʼajat. ");
INSERT INTO husNT2005_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Por utsantsik tʼajat kʼal na Jesús abal yab xitaꞌ kin tʼiltsi xowaꞌ in tʼajaꞌ ani utsan kin pidhaꞌ ti kʼapul an tsidhan. ");
INSERT INTO husNT2005_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Kale tám tajaꞌ na Jesús junkímte kʼal nin exóbaliltsik ani kʼale ban bitsow xon ti pubenek. ");
INSERT INTO husNT2005_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Tam tin bajúch nin kʼítsájil an koyóxnich, kʼale ban atá xon tu tʼajnal an junkuntaláb ani kʼwajay ti okʼtsix. Kʼal yán i atiklábtsik ti axtsin xowaꞌ in ulu ani labantsik tʼajat. U útsáxtsik jún ani jún enchéꞌ: ―¿Jónꞌ ti kʼalnek kin exóbnaꞌ jechéꞌ xowaꞌ in okʼtsixnál? In ulutsik jeye: ¿Jantʼom witʼomtaláb xi jechéꞌ pidhnék ani jan tin tʼajál an labidh labandhaxtalábtsik? ");
INSERT INTO husNT2005_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","In ulutsik jeye enchéꞌ: ¿Yabxeꞌ jaꞌich an dhakúm, nin chakámil na María, nin kidháb na Jakobo, na José, na Judas ani na Simón? ¿Yabxeꞌ techéꞌ jeye u kʼwajíl nin ixámtsik? Jaxtám tu pojkáb ani yab u beltsinal xowaꞌ in okʼtsixnál. ");
INSERT INTO husNT2005_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Por utsantsik enchéꞌ kʼal na Jesús: ―Putálkʼi tu kʼakʼnáb jun i tʼiltsix, tokotkʼi bin chabálil, kʼal nin kidhtaltsik ani kʼal xu kʼwajíltsik bin kʼimáꞌ ti yab u kʼakʼnáb. ");
INSERT INTO husNT2005_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Jaꞌich kʼal jechéꞌ tin kwenta ti yab in ejto na Jesús kin tʼajaꞌ ni jun i labidh labandhaxtaláb tajaꞌ bin bitsówil. Tokot in kʼwajbaꞌ nin kʼubak bin éb in ókʼ cháb óx i yaꞌultsik ani in jeldhaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Laban tʼajat na Jesús abal yab beltsin kʼal jajáꞌtsik. Kale tám tajaꞌ, kʼale kin loniy an kwentsaltsik xi tajaꞌ utat ani in okʼtsitsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","8","In junku tám xi lajucháb an exóbaltsik ani in pidhaꞌ ti awiltaláb kin káldhantsi ti atʼax ejattaláb xitaꞌ kʼwajat teykómte kʼál. In abaꞌ chabtsik ti chabtsik abal kin tʼajaꞌ xowaꞌ utsan, por tam ti yabél kʼalnektsik, utsantsik abal yab kin júnaꞌ xataꞌ abal an bél; yab kin júnaꞌ i morrál, nibal i kʼapnél, nibal i tumín, tokot kin júnaꞌ jun in kwayab. ");
INSERT INTO husNT2005_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Utsantsik ke tokot kin júnaꞌ nin pajab xin pajbím ani nin kʼudhkʼúmil xin kʼwajbím, yab kin júnaꞌtsik cháb. ");
INSERT INTO husNT2005_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Utsantsik jeye enchéꞌ: ―Xowaꞌkich an kʼimádh xon ti ki bachʼwat, ki kʼwajay tajaꞌ asta kin bajaw xowkʼi neꞌech ki kale ba jachanꞌ an bitsow. ");
INSERT INTO husNT2005_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Max ki ulich ba jun i bitsow xon ti yab ki bachʼwat ani yab ti ki axtsitsik, ki kale, ka tiniy an pojodh xi palenek ba na akan jelti jun i exól abal kin choꞌóbnaꞌtsik ke yab alwaꞌ xan ti tʼajtsitsik ani ki kʼaletsik tám píl bitsow. Tsubax tu utsáltsik, ke tam kin bajaw xowkʼi neꞌech an lújundhaxtaláb, an atiklábtsik xi yab ti bachʼu xu kʼwajíltsik ba jachanꞌ an bitsow, más jaꞌ púlek an yajtsiktaláb neꞌech kin bachʼu ké an yajtsiktaláb xi neꞌech kin bachʼu an atiklábtsik xi kʼwajinek Sodoma ani xi Gomorra. ");
INSERT INTO husNT2005_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Kale tám nin exóbaliltsik an ti tʼiltsix ani in utsál an atiklábtsik abal kin jilaꞌichtsik ti walablom ani ka utéchtsik ba na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Yán tʼajat xin káldhantsitsik ti atʼax ejattaláb xi kʼwajattsik teykómte kʼál. Yán jeye i yaꞌultsik in majuy kʼal i aséyte ani jeley. ");
INSERT INTO husNT2005_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","An pulek takʼix Erodes in achʼaꞌ xowaꞌ in tʼajál na Jesús kom putálkʼi tu tʼilnal ejtal xowaꞌ in tʼajál. Jaxtám tin ulu enchéꞌ: ―Jechéꞌ jaꞌich xónaꞌ na Juan xu Pujax, xi chemdhá ani xoꞌ ejnekich ti ít; jaxtám tin koꞌol an awiltaláb abal kin tʼajaꞌ an labidh labandhaxtalábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Xi kʼeꞌettsik in ulal enchéꞌ: ―Jaꞌich an tʼiltsix xin bij Elías. Taltsik in ulal: ―Jaꞌich jun i tʼiltsix jelti an wejeꞌ tʼiltsixtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Tam ti na Erodes in achʼaꞌ xowaꞌ in ulal an atiklábtsik, in ulu tám enchéꞌ: ―Jechéꞌ jaꞌich na Juan xu Pujax, xi nanáꞌ u abnaꞌ ka kotsin tin ókʼ ani xoꞌ ejnekich ti ít. ");
INSERT INTO husNT2005_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Xowaꞌ támnék jaꞌich jechéꞌ: na Erodes in abnámal ka balyat ban wikʼaxteꞌ na Juan xu Pujax wikʼadh kʼal i patʼál kʼal tin kwentakʼi na Erodías. Jechéꞌ na Erodías, kʼwajat tomkidh kʼal na Felipe, nin kidháb na Erodes, por na Erodes junkun kʼal jechéꞌ an mímláb ani in tʼajaꞌ tin tomtal. ");
INSERT INTO husNT2005_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Jaxtám ti utsan enchéꞌ na Erodes kʼal na Juan: ―Yab tʼajat alwaꞌ abal a tʼajámal ta tomtal na atmúl. ");
INSERT INTO husNT2005_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Na Erodías in atʼál tʼajat na Juan ani in léꞌ kin chemdhaꞌ, por yab in ejtowal ");
INSERT INTO husNT2005_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","abal na Erodes in choꞌób alwaꞌ ke na Juan, jaꞌich jun i lujat inik ani tʼokat, jaxtám tin jikʼnál. Jaxtám ti yab in walkál ka chemdhá na Juan kʼal na Erodías. Maske na Erodes yab in lej exbantsal alwaꞌ xowaꞌ in ulal na Juan, u jilkʼonal tʼajat ti chalpax tam in axtsal an tin takʼixtal kʼal yantam i kulbétaláb. ");
INSERT INTO husNT2005_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Por na Erodías in elaꞌ an kʼij abal ka chemdhá na Juan, tam ti na Erodes in ajíbnaꞌ nin tamúbil ani tʼajtsin jun i pulek kʼapúxnich an pakdhaꞌ awiltaláb, an pakdhaꞌ okʼlek soldadotsik ani ejtal an ultaláb tʼójodhtsik xi Galilea. ");
INSERT INTO husNT2005_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Tam ti exomich an kʼapúch, ochich nin tsidhánil na Erodías ani bixmách. Na Erodes ani ejtal xi kanidhtsik, watʼats tin kulbetnaꞌ xan ti bixmách an tsidhan, jaxtám na Erodes tin utsaꞌ enchéꞌ an tsidhan: ―Ti kin kontsi xowaꞌ ka leꞌnaꞌ ani neꞌech tu pidhaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ani in utsaꞌ lej tsubax enchéꞌ: ―Neꞌech tu pidhaꞌ xowaꞌ ti kin kontsi, maske ti kin kontsi asta junax chʼejel an chabál xu takʼyal. ");
INSERT INTO husNT2005_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Kʼale tám an tsidhan kin konoy nin nánaꞌ ani in utsaꞌ enchéꞌ: ―¿Jantʼéy ku kontsi? Utsan enchéꞌ kʼal nin nánaꞌ: ―Ka kontsi tin ókʼ na Juan xu Pujax. ");
INSERT INTO husNT2005_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Witsiy tám dhubatkʼi an tsidhan xon ti kʼwajat an pulek takʼix ani in utsaꞌ enchéꞌ: ―U léꞌ ti kin pidhaꞌ xoꞌich balidh ba jun i talab nin ókʼ na Juan xu Pujax. ");
INSERT INTO husNT2005_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","An pulek takʼix watʼats ti tʼeꞌpin tam tin achʼaꞌ xowaꞌ kontsin, por kom yab in leꞌnaꞌ ka jilkʼon tidhetál tin tamét an ajíblomtsik, koꞌol in tʼajaꞌ xowaꞌ kontsin. ");
INSERT INTO husNT2005_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","An pulek takʼix in abaꞌ jun i soldado abal ka tsiꞌdhantsat támkʼi tin ókʼ na Juan. Kʼale tám jachanꞌ an soldado ban wikʼaxteꞌ ani in kotsi tin ókʼ na Juan. ");
INSERT INTO husNT2005_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Tsiꞌdhantsat tám ba jun i talab, pidhan an tsidhan ani an tsidhan in júntsi nin nánaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Tam ti nin exóbaliltsik na Juan in choꞌóbnaꞌ xantʼéy in tamúmal na Juan, kʼale kin dhaytsi tin putálíl nin tʼuꞌúl ani in júnaꞌichtsik tám abal kin joliy. ");
INSERT INTO husNT2005_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Más tayíl, witsiy an abatwáletsik xon ti kʼwajat na Jesús ani in tʼiltsitsik xowaꞌ in tʼajámaltsik ani xowaꞌ in okʼtsixnámal. ");
INSERT INTO husNT2005_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Utsantsik tám enchéꞌ kʼal na Jesús: ―Wana xon ti yab xitaꞌ u kʼwajíl abal ki ejto jun wéꞌ tu koyol. Anchanꞌ ti utsantsik abal yán an atiklábtsik xu ulel ani xu kʼalel ani nibalich u jolkʼanaltsik ti kʼapul. ");
INSERT INTO husNT2005_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Balintsik tám ba jun i tan ani kʼale xon ti yab xitaꞌ u kʼwajíl abal kin ejtotsik ka kʼwajay kwetém. ");
INSERT INTO husNT2005_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Por kʼal yán ti chuꞌtat tam ti kʼaléchtsik ani exlá na Jesús abal taꞌ jeye ti neꞌech. Jaxtám an atiklábtsik xi tál ba putálkʼi an bitsowtsik, adhik ti kʼale xon ti neꞌech ka ulich na Jesús kʼal nin exóbaliltsik ani okʼoxtsik ti ulich. ");
INSERT INTO husNT2005_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Tam ti na Jesús kale ban tan, yánich tʼajat an atiklábtsik taꞌ ti kʼwajat tajaꞌ. In kóꞌontsi tʼajat ti yajnantsixtaláb abal kʼwajattsik jelti borrego xi yab in koꞌol xitaꞌ kʼál ti ka beletná. Ani yán xataꞌ okʼtsintsik kʼal na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Tam ti wákléch, utey nin exóbaliltsik ani utsan enchéꞌ na Jesús: ―Exomich ti dhamul ani techéꞌ yab xitaꞌ u kʼwajíl. ");
INSERT INTO husNT2005_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ka abaꞌ an atiklábtsik ban atátsik ani ban kwentsaltsik xi techéꞌ utat abal kin chʼaꞌay xantʼéy kin kʼapu, pos techéꞌ yab xataꞌ waꞌach xantʼéy kin kʼapu. ");
INSERT INTO husNT2005_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Por tókʼoyattsik enchéꞌ kʼal na Jesús: ―Ka pidhaꞌ tatáꞌtsik ti kʼapul. An exóbaltsik tókʼon enchéꞌ: ―Yab neꞌech ki ejto, pos neꞌech ki yéntsi cháb i boꞌ inik i denariotsik abal ki chʼayꞌtsi ti kʼapnél ejtal jechéꞌ an atiklábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Konyattsik tám enchéꞌ kʼal na Jesús: ―¿Jáy i pan a koꞌoltsik? Ki kʼale ka chuꞌu. Kʼaletsik tám kin chuꞌu ani tam ti witsiy in utsaꞌ enchéꞌ na Jesús: ―I koꞌol bóꞌ i pan ani cháb i toꞌol. ");
INSERT INTO husNT2005_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Na Jesús in abaꞌ nin exóbaliltsik abal kin utsaꞌ an atiklábtsik ka buxkan kweneꞌ ti kweneꞌ ban yax tóm, ");
INSERT INTO husNT2005_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","ani buxkantsik tám ti kweneꞌtsik. Taltsik an kweneꞌ ti boꞌ inik, an xi kʼeꞌet an kweneꞌ ti chab inik láju. ");
INSERT INTO husNT2005_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","In bachʼu tám na Jesús xi bóꞌ an pan ani xi cháb an toꞌol, in telaꞌ walkʼiꞌ ani in pidhaꞌ ti jalbintsixtaláb na Dios. Tam tin tʼajámich jechéꞌ, in pejaꞌ an pan ani in pidhaꞌich tám nin exóbaliltsik abal kin pidhaꞌ an atiklábtsik. Anchanꞌ jeye tin tʼajaꞌ kʼal xi cháb an toꞌol. ");
INSERT INTO husNT2005_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ejtaltsik kʼapúch asta ajwé ");
INSERT INTO husNT2005_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","ani bél junkuwat lajucháb i éx tsʼutsutsik kʼal an pejadh pan ani an pejadh toꞌol xi jilkʼonich. ");
INSERT INTO husNT2005_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Nin yaníl xi kʼapúchtsik, boꞌ mil i iniktsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Tayíl, na Jesús in abaꞌ nin exóbaliltsik ka balin ban tan ani ka okxin ka kʼale jun pakʼeꞌ pujal ban bitsow Betsayda, lejat Jajáꞌ in abál an atiklábtsik ka kʼaléch tin kʼimáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Tam tin talaꞌ abámich ka kʼaletsik, kʼadhiy ba jun i chʼén ti ól. ");
INSERT INTO husNT2005_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Tam ti akléch, an tan kʼwajatich junax chʼejel an pujal ani na Jesús jilkʼonék kwetém ban chabál. ");
INSERT INTO husNT2005_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Na Jesús in chuꞌu nin exóbaliltsik ti xaltsix kʼal yán i chápláb abal u nixkʼábtsik kʼal an chapik ikʼ ani jaxtám ti yab in ejtowaltsik kin beldhaꞌ an tan. Tam ti dhajaw akalich, na Jesús beley bin éb an jaꞌ asta xon talat ti kʼwajattsik ani walaꞌ ka jekʼwattsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Por tam ti chuꞌtat ti belal bin éb an jaꞌ, an exóbaltsik in chalpay max i labax ani dhájantsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Kʼal ejtal ti chuꞌtat ani jikʼeytsik tʼajat. Por Jajáꞌ in utsaꞌtsik enchéꞌ: ―¡Ka likedhaꞌtsik tabáꞌ! Nanáꞌ, yab ki jikʼeytsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ochichich tám na Jesús ban tan xon ti kʼwajattsik ani tsusbél ti kublan ti wawꞌnal an ikʼ. Nin exóbaliltsik laban tʼajat ani u jikʼéltsik ");
INSERT INTO husNT2005_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","abal yabél in exbayámaltsik xantʼéy in léꞌ kin ulu tam tin yanedhaꞌ an pan, pos yabtsik tʼajat in ejtowal kin exbay. ");
INSERT INTO husNT2005_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Tam tin watʼnaꞌichtsik an pujal, ulich ban chabál xin bij Jenesaret ani tajaꞌ tin wikʼaꞌ an tan tin wál an pujal. ");
INSERT INTO husNT2005_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Tokot ti kaletsik ban tan, dhubatkʼi ti exlá na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","An atiklábtsik xu kʼwajíl ba jachanꞌ an chabál, adhiktsik ti kʼale túkʼi túkʼi abal kin ikʼiꞌ an yaꞌultsik kwachat ban chayteꞌ ani kin júnaꞌ asta xon ti kin achʼaꞌ xeꞌech na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Xontikʼi ka ochich ban tsʼitsik bitsow, ban pakdhaꞌ bitsow o ban kwentsaltsik, u pakabédháb abal kin walkaꞌ ka taktsin tin waltsik nin kʼudhkʼúmil kʼal an yaꞌultsik. Ejtaltsik xitaꞌ kʼál tu taknal, u jelél. ");
INSERT INTO husNT2005_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Utukná tám na Jesús kʼal an fariseotsik ani kʼal cháb óx i okʼtsixtsik xin wilál nin takʼixtal na Dios xin jilám dhutsadh na Moisés xi táltsik Jerusalén. ");
INSERT INTO husNT2005_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Jajáꞌtsik in chuꞌu ke taltsik nin exóbalil na Jesús u kʼapul yab tʼakadh nin kʼubak, jaxtám ti kawyattsik abal yab in tʼakaꞌtsik nin kʼubak xan ti yejat kin tʼajaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Pos an fariseotsik ani ejtal xi más an judíotsik, in wewkómtsal tin takʼixtal nin wejeꞌ pakéliltsik, yabtsik u kʼapul max yab kin tʼakaꞌ okʼox nin kʼubak yáníl. ");
INSERT INTO husNT2005_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Tam ka witsiytsik ti chʼaꞌum, max yabtsik in tʼakám nin kʼubak xan ti yejat kin tʼajaꞌ, yabtsik u kʼapul ani yán más xataꞌ xowaꞌ in ujnámaltsik in tʼajál. Aníl jeye, in tʼakáltsik an balixtaláb, an patʼál balixtaláb ani an koytaláb xon tu jedhkanal tam u kʼapul.) ");
INSERT INTO husNT2005_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Konyat tám enchéꞌ na Jesús kʼal an fariseotsik ani kʼal an okʼtsixtsik xin wilál nin takʼixtal na Dios: ―¿Jantʼókʼi na exóbaliltsik ti yab in óntsal kin wéwnantsi tin takʼixtal ni wejeꞌ pakéliltsik abal u kʼapultsik yab tʼakadh nin kʼubak? ");
INSERT INTO husNT2005_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Tókʼoyattsik tám enchéꞌ kʼal na Jesús: ―¡Kʼambixtsik! Tsubax tʼajat tin ulu an tʼiltsix Isaías kʼal tatáꞌtsik ta kwenta, tam tin dhutsaꞌ enchéꞌ: Jechéꞌ an atiklábtsik kʼal in wiꞌkʼi tin kʼakʼnál, por nin ejattal ów tʼajat ti kʼwajat kʼal Nanáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Yab xataꞌ in jalbíl xan tin kʼakʼnáltsik, pos tokot in okʼtsixnáltsik in takʼixtal i iniktsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Tatáꞌtsik yab a tʼajál ti kʼij nin takʼixtal na Dios abal tokot a wéwnál xowaꞌ in tʼajál an iniktsik. A tʼakáltsik an balixtaláb xa éynáltsik ka uxnaꞌ ani yán más xataꞌ a tʼajáltsik jelti jechéꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","In óntsi ti káw na Jesús ani in utsaꞌtsik jeye enchéꞌ: ―Yab a tʼajáltsik ti kʼij nin takʼixtal na Dios abal a óntsaltsik tokot ka wéwnaꞌtsik xowaꞌ in tʼajál an iniktsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Pos na Moisés in ulu enchéꞌ: “Ka kʼakʼnaꞌ na tátaꞌ ani na nánaꞌ”, ani “Xitaꞌ kin odhbijiy nin tátaꞌ o nin nánaꞌ, yejat ka chemdhá.” ");
INSERT INTO husNT2005_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Por tatáꞌtsik a ulal ke jun xitaꞌ awil kin utsaꞌ enchéꞌ nin tátaꞌ o nin nánaꞌ: “Yabich neꞌech ku ejto tu tolmiy, pos ejtal xowaꞌ u koꞌol u pikbantsámalich a Dios.” ");
INSERT INTO husNT2005_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ani max jun xitaꞌ kin utsaꞌ anchanꞌ nin pakéliltsik, a ulaltsik ke yabich tám yejat kin tolmiy. ");
INSERT INTO husNT2005_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Anchanꞌ, a tʼajálichtsik jelti max yab xataꞌ in jalbíl nin takʼixtal na Dios abal tokot a tʼajáltsik xowaꞌ i jiltsinék kʼal na wejeꞌ pakéliltsik. Jaꞌich tokot a okʼtsixnál ka tʼajan ani jechéꞌ yab in takʼixtal a Dios. Ani yán más xataꞌ a tʼajál jelti jechéꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","In kaniy tám juní na Jesús ka utey an atiklábtsik ani in utsaꞌtsik enchéꞌ: ―Ka achʼaꞌtsik alwaꞌ xowaꞌ neꞌech tu utsaꞌ ani ka exbaytsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","An inik yab u chʼóꞌnal nin itsích kʼal xowaꞌ in kʼapal, u chʼóꞌnal kʼal xowaꞌ yab alwaꞌ in chalpayal tin itsích ani kin tʼajaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Max a koꞌoltsik na ochʼoxtal alwaꞌ, ka exbaytsik xowaꞌ u ulal. ");
INSERT INTO husNT2005_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Tayíl, tam ti na Jesús in jilaꞌich an atiklábtsik ani ochich ban atá, utsan tám kʼal nin exóbaliltsik kin wilaꞌ an junbaxtaláb xin ulu. ");
INSERT INTO husNT2005_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Utsantsik enchéꞌ: ―¿Yabxeꞌ teye a exbayámaltsik? ¿Yabxeꞌ a choꞌóbtsik ke ni jun xitaꞌ yab u chʼóꞌnal nin itsích kʼal xowaꞌ in kʼapal? ");
INSERT INTO husNT2005_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","An kʼapnél yab u ochel bin itsích an inik, u kʼalel bin tsukul ani tayíl neꞌech kin wakʼlaꞌ alteꞌ. Anchanꞌ tin ulu na Jesús abal kin xalkʼaꞌ ke xowaꞌkich an kʼapnél yab tu chʼoꞌtsal an ti itsích. ");
INSERT INTO husNT2005_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","In ulu jeye enchéꞌ: ―U chʼóꞌnal nin itsích an inik kʼal xowaꞌ in chalpayal yab alwaꞌ ani kin tʼajaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Pos xowaꞌ kʼwajat alkʼidh bin itsích an iniktsik, jaꞌich kʼál tu tʼajnal kin kóꞌoy an atʼax chalab. Kʼal jachanꞌ an atʼax chalab, kʼál tu tʼajnal ka junkun kʼal xi yab in tomtal. Waꞌach jeye xi yab u tomkinal, u aniꞌ junkunalkʼi. Waꞌach xu chemdhax, ");
INSERT INTO husNT2005_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","xu kwéꞌ, xi chʼeꞌneꞌ, xin tʼajtsal ti atʼaxtaláb xi kʼeꞌet, xu kʼambix, xin jilál tinbáꞌ ka óxná kʼal xowaꞌkich i atʼaxtaláb, xin telál kʼal i chákub xowaꞌ in koꞌol kʼeꞌet, xu tʼilom yab exbadh, xin tʼekʼál tinbáꞌ ani xi yab lujat in chalab. ");
INSERT INTO husNT2005_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ejtal jechéꞌ xowaꞌ yab alwaꞌ, u tujél bin itsích an iniktsik ani tam kin tʼajaꞌ, u jilkʼonalich tám chʼoꞌodh nin itsích kʼal an walastaláb. ");
INSERT INTO husNT2005_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Kale tám tajaꞌ na Jesús ani kʼale ban chabál xi Tiro ani Sidón. Tam ti ulich tajaꞌ, ochich ba jun i atá abal yab in léꞌ ka choꞌóbná max tajaꞌ ti kʼwajat, por yab in ejto ka chinkʼon. ");
INSERT INTO husNT2005_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Abal jun i mímláb xin koꞌol jun in tsidhánil ochadh kʼal i atʼax ejattaláb in choꞌóbnaꞌ ke taꞌ ti kʼwajat tajaꞌ, tsích ani tudhlan tin tamét na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Jechéꞌ an mímláb yab u israelita, jajáꞌ Sirofenisia in chabálil. Pakabédhá na Jesús kʼal an mímláb abal ka káldhantsat an ti atʼax ejattaláb xi kʼál ti ochadh nin tsidhánil. ");
INSERT INTO husNT2005_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Por utsan enchéꞌ kʼal na Jesús: ―Ka walkaꞌ okʼox ka kʼapúch an chakamtsik, pos yab alwaꞌ ki kʼántsi ti kʼapnél an chakamtsik ani ki pidhaꞌ an pikʼoꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Tókʼon enchéꞌ an mímláb: ―Ajátik, tsubax xowaꞌ a ulal. Xi tál píl bitsow jelti nanáꞌ u usnal kʼal tatáꞌtsik abal i junwal jelti an pikʼoꞌ, por asta an pikʼoꞌtsik xi kʼwajat tin ál an mesa, in kʼapal xowaꞌ u kwajlanal muꞌax tam exom ti kʼapul an chakamtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Utsan tám enchéꞌ kʼal na Jesús: ―Alwaꞌ tʼajat xan ta tókʼon; jaxtám, awil ki kʼaléch, pos an atʼax ejattaláb kalnekich ba na tsidhánil. ");
INSERT INTO husNT2005_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Tam ti an mímláb witsiy tin kʼimáꞌ, in elaꞌ nin tsidhánil kwachálkʼijich bin waytal abal an atʼax ejattaláb, kalnekich. ");
INSERT INTO husNT2005_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Kale na Jesús ban bitsow xi Tiro, watʼey Sidón, bin chabáliltsik jeye xi láju an bitsowtsik xin bij Dekápolis ani ulich ban pujal xi Galilea. ");
INSERT INTO husNT2005_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Uldhantsat tajaꞌ jun i inik xi yab u ochʼox ani yab in ejtowal ti káw alwaꞌ ani pakabédhá kin kʼwajbaꞌ nin kʼubak ban inik. ");
INSERT INTO husNT2005_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Na Jesús in júnaꞌ pílkʼi xon ti yab waꞌach an atiklábtsik ani in xaptsi tin tsʼútsbixtal bin xuchuntsik, in tubkay nin kʼubak ani in taktsi kʼál tin lekʼáb. ");
INSERT INTO husNT2005_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","In telaꞌ tám walkʼiꞌ, dhutsutsun asta tin itsích ani in utsaꞌ enchéꞌ an inik: ―¡Efata! ―Jechéꞌ an káw in léꞌ kin ulu: ¡Ki jakʼpin! ");
INSERT INTO husNT2005_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Támkʼi jachanꞌ ti ochʼxin an inik ani in ejtóch ti káw alwaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Utsantsik kʼal na Jesús abal yab kin tʼiltsi ni jun xitaꞌ xowaꞌ in tʼajaꞌ, por yabtsik in tʼajaꞌ ti kʼij, más tokot in tʼiláltsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Xin achʼáltsik, u labnaltsik tʼajat ani in ulaltsik enchéꞌ: ―Ejtal xowaꞌ in tʼajál, alwaꞌ tʼajat; asta xi yab u ochʼox in ochʼxindhál ani an móꞌtsik in káwindhál. ");
INSERT INTO husNT2005_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Tam ti jachanꞌ i kʼij, junkunék yán i atiklábtsik ani tam ti yabich in koꞌoltsik xataꞌ kin kʼapu, na Jesús in kaniy ka utey nin exóbaliltsik ani in utsaꞌtsik enchéꞌ: ");
INSERT INTO husNT2005_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―U yajnantsal tʼajat jechéꞌ an atiklábtsik abal kʼwajinekich óx a kʼítsá kʼal Nanáꞌ ani xoꞌ yabich in koꞌol xataꞌ kin kʼaputsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Max ku abaꞌich ka kʼaletsik tin kʼimáꞌ anchanꞌ yab kʼapúmadh, neꞌech ka palmétsik ti bél kʼal an kʼaꞌínab abal taltsik owdhaꞌ tʼajat ti tál. ");
INSERT INTO husNT2005_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Tókʼoyat enchéꞌ kʼal nin exóbaliltsik: ―¿Por jónꞌ ti neꞌech ki elaꞌ an kʼapnél abal ki kʼapundhaꞌ techéꞌ xon ti yab xitaꞌ u kʼwajíl? ");
INSERT INTO husNT2005_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Konyattsik tám kʼal na Jesús: ―¿Jáy i pan a koꞌoltsik? Jajáꞌtsik tókʼon enchéꞌ: ―Búk. ");
INSERT INTO husNT2005_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Utsan tám an atiklábtsik kʼal na Jesús ka buxkan chabál. Na Jesús in bachʼu tám xi búk an pan, in pidhaꞌ ti jalbintsixtaláb na Dios, in pejaꞌ ani in pidhaꞌ nin exóbaliltsik abal kin pidhaꞌ an atiklábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Táꞌ jeye tin koꞌol cháb óx i tsʼitsik toꞌol ani anílkʼi jeye tin tʼajaꞌ jelt xan tin tʼajaꞌ kʼal an pan, in pidhaꞌ ti jalbintsixtaláb na Dios ani in pidhaꞌ nin exóbaliltsik abal kin pidhaꞌ an atiklábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ejtal kʼapúchtsik asta ajwé. Tayíl, nin exóbaliltsik in tsʼutsiy búk i tʼoknal kʼal in pejmats an kʼapnél xi jilkʼon. ");
INSERT INTO husNT2005_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Wéꞌich xónaꞌ cheꞌ mil i atiklábtsik xi kʼapúch. Tayíl abanichtsik tám kʼal na Jesús abal ka kʼaléch. ");
INSERT INTO husNT2005_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Balin tám na Jesús ban tan kʼal nin exóbaliltsik ani kʼale ban chabál xin bij Dalmanuta. ");
INSERT INTO husNT2005_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ulich tám an fariseotsik ani in tuju ti káwlíx kʼal na Jesús. Ani abal ka taktamiyat na Jesús, u kontsinal kin tʼajaꞌ jun i labidh labandhaxtaláb abal kin xalkʼaꞌ ke tsubax lejtal kʼal a Dios ti abadh. ");
INSERT INTO husNT2005_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Dhutsutsun tám na Jesús tin ejattal kʼal yantam i tʼeꞌpintaláb ani in utsaꞌtsik enchéꞌ: ―¿Jantʼókʼi tin kontsaltsik ku tʼajaꞌ i labidh labandhaxtaláb? Tsubax tu utsáltsik, ke ni jun i labidh labandhaxtaláb yab neꞌech ku tʼajaꞌ ta taméttsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","In jilonaꞌtsik tám tajaꞌ, balin ban tan ani watʼey kʼal nin exóbaliltsik jun pakʼeꞌ pujal. ");
INSERT INTO husNT2005_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Nin exóbaliltsik na Jesús yab in chalpay kin júnaꞌtsik i pan, jún tokot i pan taꞌ tin koꞌoltsik ban tan. ");
INSERT INTO husNT2005_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Takʼyattsik tám enchéꞌ kʼal na Jesús: ―Ka kóꞌoytsik i kwenta kʼal nin okʼtsixtal an fariseotsik ani kʼal nin okʼtsixtal na Erodes xin junwal jelti an jilbédhaxtaláb kʼoye. ");
INSERT INTO husNT2005_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Tujey tám an exóbaltsik ti útsáx jún ani jún enchéꞌ: ―¿Awxeꞌ tu utsál jechéꞌ abal yab i tsiꞌdhaꞌ an pan? ");
INSERT INTO husNT2005_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Na Jesús in choꞌóbnaꞌ xantʼéy in ulaltsik, jaxtám tin utsaꞌtsik enchéꞌ: ―¿Jantʼókʼi ta kʼwajat ta útsáxtsik ke yab a tsiꞌdhám i pan? ¿Yabxeꞌ tʼajat a exbayaltsik? ¿Bélxeꞌ tʼajat tʼojláb ka exbaytsik? ");
INSERT INTO husNT2005_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","A koꞌoltsik a wal ani a ochʼoxtal, ¡por jáykʼi max yabtsik i chuꞌux nibal i ochʼox! ¿Yabxeꞌ a tʼílómtsik? ");
INSERT INTO husNT2005_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Tam tu pejaꞌ xi bóꞌ an pan abal xi boꞌ mil an atiklábtsik, ¿jáy i éx a tsʼutsiytsik kʼal xi jilkʼon? Tókʼontsik enchéꞌ: ―Lajucháb. ");
INSERT INTO husNT2005_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Utsantsik jeye enchéꞌ: ―Ani tam tu muꞌu jeye xi búk an pan abal xi cheꞌ mil an atiklábtsik, ¿jáy i tʼoknaltsik a tsʼutsiy kʼal xi jilkʼon? Tókʼontsik enchéꞌ: ―Búk. ");
INSERT INTO husNT2005_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Utsantsik tám enchéꞌ kʼal na Jesús: ―¿Yabxeꞌ bél a exbayaltsik? ");
INSERT INTO husNT2005_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Tayíl, ulichtsik ban bitsow xi Betsayda, tsiꞌdhantsat na Jesús jun i jokʼol kʼal cháb óx i atiklábtsik ani pakabédhá kin takaꞌ jachanꞌ an jokʼol abal ka chuꞌxin. ");
INSERT INTO husNT2005_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","In lotʼokʼnaꞌ tám an jokʼol ani in káldhaꞌ ban kwentsal. In ijlintsi tin wal an jokʼol, in kʼwajbantsi tin kʼubak bin éb nin wal an jokʼol ani in konoy max in chuꞌtalich xataꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","An jokʼol chuꞌxinich tám ani in ulu enchéꞌ: ―U chuꞌtal an iniktsik, por jáykʼi i teꞌ, por u belaltsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","In kʼwajbaꞌ tám juní na Jesús nin kʼubak bin éb in wal an jokʼol, chuꞌxinich tám alwaꞌ an inik ani jelnek alwaꞌ ti jilkʼon. Ejtalich tám in chuꞌtal alwaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Abanich tám tin kʼimáꞌ kʼal na Jesús ani utsan enchéꞌ: ―Yab ki ochich ban kwentsal, nibal xitaꞌ ka óltsi xi tajaꞌtsik xantʼéy tu tʼajtsi. ");
INSERT INTO husNT2005_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Tayíl, kʼale na Jesús kʼal nin exóbaliltsik ban kwentsaltsik xi kʼwajat wililíl Sesarea, an bitsow xu takʼnal Filipo. Tam ti neꞌechtsik ti bél, in konoy enchéꞌ nin exóbaliltsik: ―Kʼal an atiklábtsik, ¿jitaꞌ pé tin usnal ke Nanáꞌ neye? ");
INSERT INTO husNT2005_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Jajáꞌtsik tókʼon enchéꞌ: ―Taltsik in ulal ke Tatáꞌ i Juan xu Pujax, taltsik in ulal ke i Elías xi xeꞌchinék ti tʼiltsix ti wejeꞌ ani xi kʼeꞌettsik in ulal ke Tatáꞌ jaꞌich jun ti éb xi kʼeꞌet an tʼiltsixtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Konyattsik tám juní enchéꞌ kʼal na Jesús: ―Ani tatáꞌtsik, ¿jitaꞌ ta ulaltsik ke Nanáꞌ neye? Tókʼoyat kʼal na Pedro ani utsan enchéꞌ: ―Tatáꞌ i Kristo, xi takudh kʼal na Dios abal ta takʼix. ");
INSERT INTO husNT2005_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Por utsantsik kʼal na Jesús abal yab kin tʼiltsitsik jechéꞌ ni jun xitaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Tujey tám ti óltsinaltsik kʼal na Jesús xantʼéy neꞌech kin tamu Jajáꞌ. Utsantsik enchéꞌ: ―Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik, neꞌech ku watʼnaꞌ yán xataꞌ yajtsik. Neꞌech kin pojká kʼal an pakdhaꞌ tʼójodh, kʼal an okʼlek páleꞌtsik ani kʼal an okʼtsixtsik xin wilál nin takʼixtal na Dios xin jilám dhutsadh na Moisés. Neꞌech kin chemdhá, por tin óxláb a kʼítsá neꞌech kin ejech ti ít. ");
INSERT INTO husNT2005_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ejtal jechéꞌ tajax tʼajat ti utsantsik, jaxtám na Pedro tin júnaꞌ pílkʼi na Jesús ani in kʼwiyaꞌ abal kʼwajat in chalpayal ke anchanꞌ neꞌech ka tʼajtsin. ");
INSERT INTO husNT2005_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Por na Jesús chawꞌkʼin kin telaꞌ xi más an exóbaltsik ani in kʼwiyaꞌ na Pedro enchéꞌ: ―¡Ki wixkʼin techéꞌ lej atʼax! Tatáꞌ yab a chalpayal xan ti na Dios tin chalpayal, tokot a chalpayal xan tin chalpayal an iniktsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","In kaniytsik tám na Jesús ka utey an atiklábtsik ani nin exóbaliltsik ani in utsaꞌtsik enchéꞌ: ―Max jun xitaꞌ in léꞌ ti kin wéwnaꞌ, yab kin ajay tinbáꞌ ani yab kin ódhaꞌ ti kwenta maske ka chemdhá. ");
INSERT INTO husNT2005_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Pos max jun xitaꞌ in léꞌ kin loꞌo nin xeꞌchintal, neꞌech kin kʼibdhaꞌ, por xitaꞌ kin jilaꞌ tinbáꞌ ka chemdhá kʼal Nanáꞌkʼi tu kwenta ani kʼal tin kwenta an alwaꞌ tʼilab, neꞌech kin loꞌo. ");
INSERT INTO husNT2005_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","¿Jantʼó ti alwaꞌ abal jun xitaꞌ, max kin bajaw kin kóꞌoy ejtal xowaꞌ waꞌach ban kʼayꞌlá ani kin kʼibdhaꞌ nin ejattal ban kʼibeltaláb? ");
INSERT INTO husNT2005_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","O ¿jantʼéy neꞌech kin ejto kin pidhnaꞌ an inik abal kin loꞌo nin ejattal? ");
INSERT INTO husNT2005_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Max jun xitaꞌ kin tidhenaꞌ tin tʼilaꞌ ani kin tidhenaꞌ jeye kin tʼilaꞌ nu okʼtsixtal tin tamét an atiklábtsik xi atʼax ani u walablom xi xoꞌ waꞌach, tám, Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik, neꞌech neye kin tidhebé kʼal jajáꞌ tam kin witsiy kʼal ejtal in pulek labidh tʼokát nu Tátaꞌ ani in junkímte kʼal an tʼokat abatwáletsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Utsantsik jeye enchéꞌ kʼal na Jesús: ―Tsubax tu utsáltsik ke taltsik xi xoꞌ techéꞌ i kʼwajat, yab neꞌech ki chemech asta ka chuꞌutsik ti takʼix na Dios kʼal ejtal nin cháp. ");
INSERT INTO husNT2005_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Akak a kʼítsá más tayíl, na Jesús junax kʼal na Pedro, na Jakobo ani na Juan, kʼadhiytsik ba jun i tʼekʼat chʼén. Tam ti tajaꞌich ti kʼwajattsik, na Jesús in jalkʼuy tinbáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Nin kʼudhkʼúmil chʼaxkʼin ani dhakniꞌbé tʼajat jelti an chám; dhakniꞌbé tʼajat, ke ni jun i pakʼwtsix xi techéꞌ ti kʼayꞌlá yab neꞌech kin ejto kin dhakniꞌbédhaꞌ jelt xan ti dhakniꞌbé nin kʼudhkʼúmil na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","An exóbaltsik in chuꞌu jeye na Elías ani na Moisés ti tʼilolól kʼal na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Utsan tám enchéꞌ na Jesús kʼal na Pedro: ―Okʼtsix, ¡alwaꞌ tʼajat abal techéꞌ u kʼwajat! Neꞌech ki tʼajaꞌ óx i padhel, jún abal Tatáꞌ, jún abal na Moisés ani jún abal na Elías. ");
INSERT INTO husNT2005_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Anchanꞌ ti kʼwajat ti káw abal jajáꞌ ani nin kidhtaltsik jikʼenektsik tʼajat ani na Pedro yab in choꞌób xantʼéy kʼwajat in ulal. ");
INSERT INTO husNT2005_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Chaꞌkan tám jun i tokow xon ti jajáꞌtsik kʼwajat ani dhabyattsik, achʼatmé jun i káwintaláb ban tokow ani xu káw, in ulu enchéꞌ: ―Jechéꞌ jaꞌich nu Chakámil xu kʼanidhál tʼajat, ka exbantsitsik xowaꞌ Jajáꞌ in ulal. ");
INSERT INTO husNT2005_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Támkʼi, tam tin telaꞌtsik wililíl, yab xitaꞌ más in chuꞌu, tokot kwetém na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Tam ti exomichtsik ti paꞌíl ban chʼén, utsantsik kʼal na Jesús abal yab xitaꞌ kin tʼiltsi xowaꞌ in chuꞌúmaltsik asta tam Jajáꞌ, xi abadh abal ka wenkʼon jeye ti inik ka ejech ti ít. ");
INSERT INTO husNT2005_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Anchanꞌ tin tʼajaꞌtsik xan ti utsan ani ni jun xitaꞌ yab in tʼiltsitsik; por jajáꞌtsik echʼekʼi u kónóx xantʼéy in léꞌ kin ulu tam ti kʼwajat in ulal ke neꞌech ka ejech ti ít. ");
INSERT INTO husNT2005_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","In konoytsik tám enchéꞌ na Jesús: ―¿Jantʼókʼi tin ulal an okʼtsixtsik xin wilál nin takʼixtal na Dios xin jilám dhutsadh na Moisés ke yejat ka tsích okʼox na Elías? ");
INSERT INTO husNT2005_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Tókʼoyattsik enchéꞌ kʼal na Jesús: ―Tsubax kʼejle ke na Elías neꞌech ka tsích okʼox ani neꞌech kin lejkiy ti ít ejtal xowaꞌ waꞌach. In ulal jeye an Tʼokat Dhuslab ke Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik, neꞌech ku watʼnaꞌ tʼajat yajtsik ani neꞌech kin pojká. ");
INSERT INTO husNT2005_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Por tsubax tu utsáltsik ke na Elías tsiꞌnekich ani tʼajtsin kʼal an iniktsik xan ti ka leꞌná, jelt xan tin ulal an Tʼokat Dhuslab ke neꞌech kin tamu. ");
INSERT INTO husNT2005_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Tam ti witsiytsik xon ti kʼwajat xi más an exóbaltsik, in chuꞌu yán i atiklábtsik wililíl xon ti kʼwajattsik ani taꞌ jeye ti kʼwajat ti káwlíx kʼal jajáꞌtsik i okʼtsixtsik xin wilál nin takʼixtal na Dios xin jilám dhutsadh na Moisés. ");
INSERT INTO husNT2005_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Tam ti chuꞌtat na Jesús, labantsik tʼajat ani kʼaletsik adhik ti chapnédhom. ");
INSERT INTO husNT2005_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Konyattsik tám kʼal na Jesús: ―¿Jantʼéy i kʼwajat a káwlíxnál kʼal jajáꞌtsik? ");
INSERT INTO husNT2005_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Tókʼon tám jún xi tajaꞌ jeye ti kʼwajat: ―Okʼtsix, jéꞌ tu tsiꞌdhantsámal tu kwitólil abal kʼwajat teykómte kʼal jun i atʼax ejattaláb ani móꞌbédhats. ");
INSERT INTO husNT2005_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Tam ka bajujuyat xontikʼi ti xeꞌech, u wipipindháb, u dhopopól in ijil, u rechʼechʼél in kamab ani u jilkʼonal teytemadh. U utsámalich na exóbaliltsik abal kin káldhantsi an ti atʼax ejattaláb por yabtsik in ejtóm. ");
INSERT INTO husNT2005_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Utsantsik tám enchéꞌ kʼal na Jesús: ―¡Atiklábtsik xi jechéꞌ i kʼij, yab lejtal tʼajat i belomtsik! ¿Asta jowkʼi koꞌol kin kʼwajay kʼal tatáꞌtsik? ¿Asta jowkʼi koꞌol tu kuxuytsik? Ka tsiꞌdhaꞌ techéꞌ an kwitól. ");
INSERT INTO husNT2005_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Utuntsat tám ani tam ti chuꞌtat na Jesús kʼal an atʼax ejattaláb, wipipindhá tám an kwitól. Kwajlá chabál, tʼúlíkʼin ani u dhopopól in ijil bin wiꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Konyat tám an tátaꞌláb kʼal na Jesús: ―¿Jáyich i kʼij in koꞌol ti kʼwajat anchanꞌ? Tókʼon enchéꞌ an tátaꞌláb: ―Asta ti chipíl. ");
INSERT INTO husNT2005_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Yantalich an atʼax ejattaláb in tʼajám ka kwajlan ba kʼamal o ba jaꞌ abal kin chemdhaꞌ. Ti ku yajnantsi weye ani ti ku tolmiy max ka ejto. ");
INSERT INTO husNT2005_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Utsan tám kʼal na Jesús: ―¿Jantʼókʼi tin utsál max ka ejto? Ejtal u tʼájnal max jún u belom lejtal. ");
INSERT INTO husNT2005_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","In ulu tám kawidh enchéꞌ an tátaꞌláb: ―In belomich, por ti kin tolmiy neye abal kin belmách más. ");
INSERT INTO husNT2005_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Tam tin chuꞌu na Jesús ke exom tʼajat ti junkunal an atiklábtsik, in kʼwiyaꞌ an atʼax ejattaláb enchéꞌ: ―Atʼax ejattaláb, xa koꞌol jechéꞌ an kwitól u móꞌ ani yab u ochʼox, tu utsál ki kale ba jajáꞌ ani yab ki witsiy ka ochaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","An atʼax ejattaláb in tʼajaꞌ ka dhájan an kwitól, in wipipindhaꞌ chapik ti ít ani kaléch tám ba jachanꞌ an kwitól. An kwitól jilkʼon kwachál jelti max chemnek. Jaxtám ti yán in ulutsik ke chemchich. ");
INSERT INTO husNT2005_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Por na Jesús in téynaꞌ an kwitól bin kʼubak ani in tolmiy ka chʼakay. ");
INSERT INTO husNT2005_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Tayíl, tam ti kʼwajatichtsik kwetém ba jun i atá, konyat enchéꞌ na Jesús kʼal nin exóbaliltsik: ―¿Jantʼókʼi wawáꞌ ti yab i ejto ki káldhaꞌ an atʼax ejattaláb? ");
INSERT INTO husNT2005_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Tókʼoyattsik enchéꞌ: ―Jechéꞌ an atʼax ejattaláb ani xi más nin kidhtaltsik tokot u kalel tam jún ka ólan ani ka kʼílin. ");
INSERT INTO husNT2005_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Tam ti kaletsik tajaꞌ, watʼeytsik Galilea. Na Jesús yab in leꞌnaꞌ ka choꞌóbná kʼal ni jun xitaꞌ xon ti kʼwajat, ");
INSERT INTO husNT2005_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","abal Jajáꞌ kʼwajat in okʼtsal nin exóbaliltsik ani in utsáltsik enchéꞌ: ―Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik, neꞌech kin pidhná ban walbidh iniktsik abal kin chemdhá, por tin óxláb a kʼítsá neꞌech kin ejech ti ít. ");
INSERT INTO husNT2005_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","An exóbaltsik yab in exbay xantʼéy kʼwajattsik ti usnal ani in jikʼnáltsik kin konoy ka wiltsin. ");
INSERT INTO husNT2005_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ulichtsik tám ban bitsow xin bij Kapernaúm ani tam ti kʼwajatich ban atá, na Jesús in konoy enchéꞌ nin exóbaliltsik: ―¿Jantʼéy i kʼwajaytsik ta útsáxtsik ti bél? ");
INSERT INTO husNT2005_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Por yab tókʼontsik, kom kʼwajinektsik ti káwlíx abal in léꞌ kin choꞌóbnaꞌ xitaꞌ jáꞌ na más ultaláb xi jajáꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Buxkan tám na Jesús, in kaniy ka utey xi lajucháb an exóbaltsik ani in utsaꞌtsik enchéꞌ: ―Max jun xitaꞌ in léꞌ ka kʼwajay más ultaláb, yejat tʼajat kin chaꞌkaꞌ tinbáꞌ ani kin tʼójontsi ejtalkʼitsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","In yakʼwanaꞌ tám jun i chakam kwitól, in kʼwajbaꞌ junax chʼejel xon ti kʼwajattsik, in mulukʼnaꞌ ani in utsaꞌtsik enchéꞌ: ");
INSERT INTO husNT2005_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―Max jun xitaꞌ kin bachʼu ani kin beletnaꞌ jun i chakam kwitól jelti jechéꞌ kʼal Nanáꞌ tu bij, Nanáꞌ tin bachʼwal ani xitaꞌ ti kin bachʼu Nanáꞌ, yab Nanáꞌkʼi tin bachʼwal, in bachʼwalich jeye na Dios xi tin abámal. ");
INSERT INTO husNT2005_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Utsan tám enchéꞌ kʼal na Juan: ―Okʼtsix, i chuꞌu jun i inik xin káldhál i atʼax ejattaláb kʼal tin awiltal na bij, por i taxkʼantsi abal jajáꞌ yab xeꞌech kʼal wawáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Por na Jesús in ulu enchéꞌ: ―Yab ka taxkʼantsitsik, pos xitaꞌ in tʼajál i labidh labandhaxtaláb kʼal tin awiltal nu bij, yab neꞌech kin ejto kin ulu tayíl ke Nanáꞌ yab in alwaꞌ inik. ");
INSERT INTO husNT2005_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Pos xitaꞌ yab tu atʼál, junax kʼal wawáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Xitaꞌkich ti ki pidhaꞌ jun tuꞌ ti jaꞌ ka uchʼaꞌ kʼal Nanáꞌ tu kwenta abal i junax kʼal Nanáꞌ, tu utsáltsik tsubax ke neꞌech ka pidhan ti jalbintsixtaláb kʼal na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","ʼTu utsáltsik jeye, xitaꞌ kin walbindhaꞌ jún ti éb jechéꞌ an chakamtsik xi tin belálichtsik, yán an yajtsiktaláb neꞌech ka pidhan. Más alwaꞌ abal an walbindhom ka wikʼtsin bin núkʼ jun i yejcheꞌ chaꞌ tʼujub ani ka petʼná ban pujal abal ka luyꞌchin. ");
INSERT INTO husNT2005_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Max na kʼubak ti walbindhál, ka muchʼiy; pos más alwaꞌ ki ochich ban xeꞌchintaláb xi yab in koꞌol in okʼontal kʼal jún tokot a kʼubak ani yab kʼal chablam na kʼubak ki petʼná ban kʼibeltaláb xon ti an kʼamal yab jaykʼi u tepel. ");
INSERT INTO husNT2005_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Xi neꞌechtsik tajaꞌ, neꞌech ka kʼapattsik kʼal an dhúm xi yab jaykʼi u chemel ani neꞌech jeye ka tʼaꞌaytsik kʼal an kʼamal xi yab jaykʼi u tepel. ");
INSERT INTO husNT2005_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Max na akan ti walbindhál, ka muchʼiy; pos más alwaꞌ ki ochich ban xeꞌchintaláb xi yab in koꞌol in okʼontal kʼal jún tokot a akan ani yab kʼal chablam na akan ki petʼná ban kʼibeltaláb xon ti an kʼamal yab jaykʼi u tepel. ");
INSERT INTO husNT2005_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Xi neꞌechtsik tajaꞌ, neꞌech ka kʼapattsik kʼal an dhúm xi yab jaykʼi u chemel ani neꞌech ka tʼaꞌaytsik kʼal an kʼamal xi yab jaykʼi u tepel. ");
INSERT INTO husNT2005_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Max na wal ti walbindhál, ka jixaꞌ; pos más alwaꞌ ki ochich xon tu takʼix na Dios kʼal jún tokot a wal ani yab kʼal chablam na wal ki petʼná ban kʼibeltaláb. ");
INSERT INTO husNT2005_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Xi neꞌechtsik tajaꞌ, neꞌech ka kʼapattsik kʼal an dhúm xi yab jaykʼi u chemel ani neꞌech ka tʼaꞌaytsik kʼal an kʼamal xi yab jaykʼi u tepel. ");
INSERT INTO husNT2005_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","ʼEjtal xitaꞌ kin belaꞌ na Dios neꞌech ka tʼokwattsik kʼal an yajtsiktaláb, jelt in yájtsík an kʼamal. Pos anchanꞌ jeye, nin tʼuꞌúl an koꞌnél xu pikbantsáb na Dios, okʼox u chʼapniyáb abal ka tʼokwat. ");
INSERT INTO husNT2005_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","An atʼem alwaꞌ, por max ka xawꞌmé, ni jun xitaꞌ yab neꞌech kin ejto kin chʼapmédhaꞌ. Ki kʼwajaytsik echʼekʼi jelti an atʼem ani ki kʼwajaytsik kʼijidh jún ani jún. ");
INSERT INTO husNT2005_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Kale tám na Jesús ban bitsow xi Kapernaúm ani kʼale ban chabál xi Judea ani ban chabál xi kʼwajat jun jekʼat waljaꞌ Jordán. Junkun juní tajaꞌ xon ti kʼwajat na Jesús yán i atiklábtsik ani Jajáꞌ in okʼtsitsik jelt xan tin ujnámal in tʼajál. ");
INSERT INTO husNT2005_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Utukná tám na Jesús kʼal taltsik i fariseotsik abal ka konyat max in tomnál ka jíláxin xi tomkidhtsik. Anchanꞌ ti konyat na Jesús abal ka ejtowat ka walbindhá max yab ka tókʼon alwaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Tókʼoyattsik tám enchéꞌ kʼal na Jesús: ―¿Jantʼéy in takʼixnámal na Moisés ba nin dhuslábil? ");
INSERT INTO husNT2005_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Jajáꞌtsik tókʼon enchéꞌ: ―Na Moisés in takʼixnámal ba nin dhuslábil ke an inik awil kin jilaꞌ nin tomtal max kin pidhaꞌ jun i úw xin ulal xantʼókʼi tin kwenta ti neꞌech kin jilaꞌ ani awilich tám kin jilaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Utsantsik tám enchéꞌ kʼal na Jesús: ―Na Moisés in jilaꞌ dhutsadh jachanꞌ an takʼixtaláb abal i tanchuꞌtsik tʼajat ani yab a léꞌ ka exbaytsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Por tam ti tujeykʼi, tam ti na Dios in tʼajaꞌ ejtal xowaꞌ waꞌach, “in tʼajaꞌ an inik ani an mímláb”. ");
INSERT INTO husNT2005_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","“Jaxtám, tam jun i inik ka tomkin, koꞌol kin jilaꞌ nin tátaꞌ ani nin nánaꞌ abal ka kʼwajay kʼal nin tomtal. ");
INSERT INTO husNT2005_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Xi jechéꞌ cháb, jún tokot ti neꞌech ka ájin.” ");
INSERT INTO husNT2005_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Jaxtám, xowaꞌ na Dios in júnkúxliyámal, yab yejat kin kʼéꞌáxliy an inik. ");
INSERT INTO husNT2005_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Tayíl, tam ti kʼwajatichtsik ban atá, an exóbaltsik in konoy juní na Jesús kʼal jechéꞌ tin kwenta. ");
INSERT INTO husNT2005_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Utsantsik enchéꞌ kʼal na Jesús: ―Max jun i inik kin jilaꞌ nin tomtal ani ka tomkin kʼal kʼeꞌet i mímláb, u jilkʼonal walbidh kʼal i uxúmbeꞌtaláb ani kʼal jechéꞌ, in waltsalich nin jidhtal tomtal. ");
INSERT INTO husNT2005_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ani max jun i mímláb kin jilaꞌ nin tomkíl ani ka tomkin kʼal i kʼeꞌet inik, an mímláb u wenkʼonalich jeye tám ti junkux inik. ");
INSERT INTO husNT2005_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Utuntsat tám na Jesús cháb óx ti chakamtsik abal kin lábtʼajaꞌ, por an exóbaltsik tujey kin kʼwiyaꞌ xin utwal an chakamtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Tam ti na Jesús in chuꞌu ti kʼwiyax nin exóbaliltsik, chakuy ani in utsaꞌtsik enchéꞌ: ―Ka walkaꞌ ka utey an chakamtsik xon tin kʼwajat, yab ka tamkʼuytsik, pos xitaꞌ in jiláltsik tinbáꞌ ka takʼyat kʼal na Dios, in junwal jelti jechéꞌ an chakamtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Tsubax tu utsáltsik, ke xitaꞌ yab kin jilaꞌ tinbáꞌ ka takʼyat kʼal na Dios jelti jun i chakam, yab neꞌech kin ejto ka kʼwajay takʼnél kʼal a Dios. ");
INSERT INTO husNT2005_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","In mulukʼnaꞌ tám an chakamtsik, in punu nin kʼubak bin éb in ókʼ an chakamtsik ani in lábtʼajaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Tam ti na Jesús in óntsích an bél, utey adhik jun i inik, tudhlan tin tamét ani utsan enchéꞌ: ―Alwaꞌ Okʼtsix, ¿jantʼéy yejat ku tʼajaꞌ abal ku ejto neye ku kóꞌoy an xeꞌchintaláb xi yab in koꞌol in okʼontal? ");
INSERT INTO husNT2005_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Tókʼoyat enchéꞌ kʼal na Jesús: ―¿Jantʼókʼi tin bijyal tin alwaꞌ? Jún tokot waꞌach xitaꞌ alwaꞌ, na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","A exlálich xan tin ulal nin takʼixtal na Dios: “Yab ki junkun kʼal xi yab a tomtal, yab ki chemdhaxin, yab ki kwéꞌlách, yab ka jantsi ti káw ni jun xitaꞌ, yab ki kʼambixin ani ka kʼakʼnaꞌ na tátaꞌ ani na nánaꞌ.” ");
INSERT INTO husNT2005_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Tókʼon tám enchéꞌ an inik: ―Okʼtsix, ejtal jachanꞌ an takʼixtaláb u tʼajál asta tin chipíl. ");
INSERT INTO husNT2005_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","In teloloy tám na Jesús jachanꞌ an inik, in kóꞌontsi ti kʼanidhaxtaláb ani in utsaꞌ enchéꞌ: ―Tokot u kʼibel jun xataꞌ ka tʼajaꞌ: ki kʼale ka nuju ejtal xowaꞌ a koꞌol ani ka chʼejwaliy an chʼojontáltsik an ti tumín. Anchanꞌ, neꞌech tám ka kóꞌoy túꞌ walkʼiꞌ jun xataꞌ xi yán tʼajat in jalbíl ani wana tám ta exóbal kʼal Nanáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Tam ti an inik in achʼaꞌ jechéꞌ, tʼeꞌpin tʼajat ani kʼale, kom tumínladh tʼajat. ");
INSERT INTO husNT2005_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","In telaꞌ tám wililíl na Jesús ani in utsaꞌ enchéꞌ nin exóbaliltsik: ―¡Tʼojláb tʼajat kin jilaꞌ tinbáꞌ ka takʼyat kʼal na Dios jun i tumínladh inik! ");
INSERT INTO husNT2005_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Labantsik tʼajat an exóbaltsik kʼal xowaꞌ in achʼaꞌ in ulu na Jesús, por utsantsik juní enchéꞌ: ―Chakamtsik, ¡tʼojláb tʼajat kin jilaꞌ tinbáꞌ ka takʼyattsik kʼal na Dios xin kóꞌyaltsik tin belomtal an tumín! ");
INSERT INTO husNT2005_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Más yab tʼojláb ka watʼey jun i koꞌnél xu bijyáb kameyo bin chultál jun i tʼidhab ké kin walkaꞌ tinbáꞌ jun i tumínladh inik ka takʼyat kʼal na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","An exóbaltsik más laban tʼajat ani u kónóxtsik enchéꞌ: ―Pos max anchanꞌ ¿jitaꞌ neꞌech kin ejto ka loꞌey? ");
INSERT INTO husNT2005_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Telantsik tám kʼal na Jesús ani utsantsik enchéꞌ: ―Na Dios ejtal in ejtowal kin tʼajaꞌ, por an iniktsik, yabaꞌ. Tokot na Dios in ejtowal kin loꞌo xitaꞌkichkʼi. ");
INSERT INTO husNT2005_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Utsan tám enchéꞌ kʼal na Pedro: ―Ajátik, wawáꞌ i jilámal ejtal xowaꞌ i koꞌol abal ku xeꞌchin kʼal Tatáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Tókʼoyat enchéꞌ kʼal na Jesús: ―Tsubax tu utsáltsik, ke xitaꞌ kin jilaꞌ in kʼimáꞌ, in kidhábtsik, in ixámtsik, in tátaꞌ, in nánaꞌ, in tomtal, in chakámiltsik o in chabálil kʼal Nanáꞌkʼi tu kwenta ani kʼal tin kwenta an alwaꞌ tʼilab, ");
INSERT INTO husNT2005_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","neꞌech kin bachʼu ba jechéꞌ an kʼayꞌlá boꞌ inik más in yaníl xowaꞌ in jilámal: in kʼimáꞌtsik, in kidhábtsik, in ixámtsik, in nánaꞌtsik, in chakámiltsik ani in chabáliltsik, maske neꞌech ka atʼan, por tayíl neꞌech kin bachʼu an xeꞌchintaláb xi yab in koꞌol in okʼontal. ");
INSERT INTO husNT2005_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Por tam na Dios kin tʼajaꞌ an lújundhaxtaláb, yán xitaꞌ xoꞌ kʼwajat más ultaláb, neꞌech ka jilkʼon más tayíl ani yán xitaꞌ xoꞌ kʼwajat más tayíl, neꞌech ka kʼwajay más ultaláb. ");
INSERT INTO husNT2005_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Tam ti neꞌchichtsik ti bél abal ka kʼale Jerusalén, na Jesús okʼox ti neꞌech ani an exóbaltsik kuxlek. An exóbaltsik labnék tʼajat ani u jikʼéltsik. Pílmé tám juní na Jesús kʼal xi lajucháb an exóbaltsik ani tujey juní kin utsaꞌtsik xowaꞌ Jajáꞌ neꞌech kin tamu. ");
INSERT INTO husNT2005_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","In utsaꞌtsik enchéꞌ: ―A chuꞌtaltsik ke u neꞌchich abal Jerusalén, xon ti Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik, neꞌech kin pidhná ban okʼlek páleꞌtsik ani ban okʼtsixtsik xin wilál nin takʼixtal na Dios xin jilám dhutsadh na Moisés. Jajáꞌtsik neꞌech kin ulu abal kin chemdhá ani neꞌech tám kin pidhná ban píl iniktsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Neꞌech ti kin labídhnaꞌtsik, neꞌech ti kin kwadhaꞌ, neꞌech ti kin tubkay ani neꞌech ti kin chemdhaꞌ; por tin óxláb a kʼítsá, neꞌech kin ejech ti ít. ");
INSERT INTO husNT2005_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Uteytsik tám ba na Jesús, na Jakobo ani na Juan, xu chakámlábtsik kʼal na Sebedeo ani in utsaꞌtsik enchéꞌ: ―Okʼtsix, i léꞌ ti ku tʼajtsi jun i alwaꞌtaláb. ");
INSERT INTO husNT2005_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Konyattsik tám enchéꞌ kʼal na Jesús: ―¿Jantʼéy a léꞌ tu tʼajtsitsik? ");
INSERT INTO husNT2005_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Jajáꞌtsik in ulu enchéꞌ: ―Tam kin bajaw xowkʼi neꞌech ta takʼix kʼal na pulek labidh tʼokát, i léꞌ weye ku buxkan kʼal Tatáꞌ, jún ta eját ani jún ta kʼwatab. ");
INSERT INTO husNT2005_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Utsantsik tám kʼal na Jesús: ―Yab a choꞌóbtsik xantʼéy a konyal. ¿Neꞌechxeꞌ ka ejto ka kuxuytsik an yajtsiktaláb xi Nanáꞌ neꞌech ku kuxuy? ¿Ani neꞌechxeꞌ ka ejto ka watʼnaꞌtsik an chemlá xi jelti Nanáꞌ neꞌech ku watʼnaꞌ? ");
INSERT INTO husNT2005_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Jajáꞌtsik tókʼon enchéꞌ: ―Neꞌech ki ejto. Utsantsik tám kʼal na Jesús: ―Neꞌech kʼejle ka kuxuytsik an yajtsiktaláb xi Nanáꞌ neꞌech ku kuxuy ani neꞌech jeye ka ejto ka watʼnaꞌtsik an chemlá jelti xi neꞌech ku watʼnaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Por yab u koꞌol an awiltaláb abal tu utsaꞌtsik xitam jáꞌ neꞌech ka buxkan tu eját ani tu kʼwatab; tokot neꞌech ka buxkantsik kʼal Nanáꞌ xi takudh kʼal na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Tam tin achʼaꞌtsik xi láju an exóbaltsik xowaꞌ kontsidh na Jesús, in chakuntsitsik tʼajat xi cháb an exóbaltsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Por kanyattsik ka utey kʼal na Jesús ani utsantsik enchéꞌ: ―Jelt xan ta choꞌóbichtsik, xin takʼyal i bitsowtsik xi yab u israelitatsik u chapik takʼixtsik ani an pulek okʼlek, in tʼajál tinbáꞌ ti pulek inik kʼal an atiklábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Por tatáꞌtsik yab ka tʼajaꞌ anchanꞌ xan ti jajáꞌtsik in tʼajál. Max jun xitaꞌ xi tatáꞌtsik a kidhtal in léꞌ ka kʼwajay ultaláb, yejat kin tʼójontsitsik xi más. ");
INSERT INTO husNT2005_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Max jun xitaꞌ xi tatáꞌtsik a kidhtal in léꞌ ti tʼójodh, yejat ka kʼwajay ti jolib kʼal ejtalkʼitsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Pos nibal Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik, yab in tsiꞌnek abal kin tʼójontsat, in tsiꞌnek abal tin tʼójontsix ani abal ku pidhnaꞌ tubáꞌ kin chemdhá ani anchanꞌ yán kin ejto ka loꞌeytsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ulchichtsik tám Jerikó. Tam ti na Jesús exomich ti kalel ba jachanꞌ an bitsow junax kʼal nin exóbaliltsik ani kʼal yán i atiklábtsik, in elaꞌ buxúl wal bél jun i chʼojontál jokʼol xin konyal i tolmixtaláb. Jechéꞌ an jokʼol in bij ta Bartimeo ani u chakámláb kʼal na Timeo. ");
INSERT INTO husNT2005_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Tam tin achʼaꞌ abal exom ti watʼel na Jesús xi Nasaret, tujey ti dhájax ani in ulu enchéꞌ: ―¡Jesús, xi kuxlab kʼal an pulek takʼix Dabid, ti kin yajnantsi neye! ");
INSERT INTO husNT2005_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Yán kʼwiyxin abal ka chamkʼan, por jajáꞌ más kawidh ti dhájaxin: ―¡Jesús xi kidhtaláb kʼal an pulek takʼix Dabid, ti kin yajnantsi neye! ");
INSERT INTO husNT2005_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Kubey tám na Jesús ani in abnaꞌ ka kanyat an jokʼol. Kʼale tám ti usnal enchéꞌ an jokʼol: ―Yab ki kʼwajay ta chalpax, ki kubey, ti kanál. ");
INSERT INTO husNT2005_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","In petʼnaꞌ tám nin wát, kubey ani kʼale xon ti kʼwajat na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Konyat tám enchéꞌ kʼal na Jesús: ―¿Jantʼéy a léꞌ tu tʼajtsi? An jokʼol tókʼon enchéꞌ: ―Okʼtsix, u léꞌ neye ti kin chuꞌxindhaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Utsan tám enchéꞌ kʼal na Jesús: ―Awil ki kʼaléch, i jeley abal i belmách. Támkʼi jachanꞌ ti chuꞌxin an jokʼol ani in wéwnaꞌ na Jesús xon ti neꞌech. ");
INSERT INTO husNT2005_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Tam ti ulichtsik juntal xi cháb an kwentsal xin bij Betfajé ani Betania kʼunatich Jerusalén xi kʼwajattsik tin tamét an chʼén Olibos, in okxiy na Jesús cháb nin exóbaliltsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Utsantsik enchéꞌ: ―Ki kʼaletsik ban kwentsal xi núꞌ kʼwajat tametláb ani tam ki ulichtsik tajaꞌ neꞌech ka elaꞌtsik wikʼadh jun i burru xi yabél púnadh jaykʼi kʼal ni jun xitaꞌ. Ka wilaꞌtsik ani ka tsiꞌdhaꞌ techéꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Max ti ki konoy xantókʼi ti exom a wilál an burru, ka utsaꞌ enchéꞌ: “An Ajátikláb in yéntsal ani támeye kwaꞌ neꞌech kin witsbaꞌ.” ");
INSERT INTO husNT2005_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Kʼaletsik tám, in elaꞌ wikʼadh an burru eléb ban bél kʼunat ba jun i wiꞌleb ani in wilaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Utsantsik enchéꞌ kʼal xi tajaꞌtsik ti kʼwajat: ―¿Jantʼéy a tʼajáltsik? ¿Jantʼókʼi ta wiláltsik an burru? ");
INSERT INTO husNT2005_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Tókʼontsik jelt xan ti usnék kʼal na Jesús ani walkájich tám kin júnaꞌtsik an burru. ");
INSERT INTO husNT2005_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","In júntsitsik an ti burru na Jesús, in tatlabiytsik kʼal nin kʼudhkʼúmil ani puney na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Tin nakél an bél neꞌech in nukʼáltsik nin kʼudhkʼúmil xon ti neꞌech ka watʼey na Jesús ani kʼeꞌettsik in pejál in kʼweꞌél i teꞌtsik ani in kwachbál tin nakél an bél. ");
INSERT INTO husNT2005_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Xi neꞌechtsik okʼox ani xi palattsik kuxlek in ulaltsik kawidh enchéꞌ: ―¡Ti ku loꞌóch xoꞌ! ¡Lábtʼajadh xi tál tin bij an Okʼóxláb! ");
INSERT INTO husNT2005_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Lábtʼajadh xi tál ti takʼix jelt xan ti takʼxinék ni wejeꞌ pakélil Dabid! ¡Okʼóxláb túꞌ walkʼiꞌ, ti ku loꞌóch xoꞌ! ");
INSERT INTO husNT2005_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ochich na Jesús ban bitsow Jerusalén ani kʼale ban pulek atá xon tu kʼakʼnáb na Dios. Tam tin telámalich putál wililíl ejtal xowaꞌ waꞌach tajaꞌ, kʼaléch tám Betania kʼal xi lajucháb an exóbaltsik, abal wákléch. ");
INSERT INTO husNT2005_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Jun tsudhelom, tam ti kaletsik Betania, kʼaꞌay na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","In ów chuꞌu jun akanlek in xekedh akan i igo ani kʼale kin chuꞌu max walidh; por yab in eltsi ni jun in walíl, tokot in xekél, kom yabél in kʼijil ti walim. ");
INSERT INTO husNT2005_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","In utsaꞌ tám enchéꞌ na Jesús jachanꞌ in akan an igo: ―Yab jaykʼi neꞌech ki witsiy ta walim abal ki kʼaptsin an ta walíl. Nin exóbaliltsik in achʼaꞌ xan ti utsan in akan an igo. ");
INSERT INTO husNT2005_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Tam ti ulichtsik Jerusalén, na Jesús kʼale ban pulek atá xon tu kʼakʼnáb na Dios ani in ajaꞌ ka kale eléb ejtal an nújultsik ani an chʼaꞌumtsik xi tajaꞌ ti kʼwajattsik. In kʼetʼpantsi tin mesajil xin jaltsal ti tumín an atiklábtsik ani nin nújumtal jeye an nújul kukuꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ni jun xitaꞌ yab in walkaꞌ ka watʼey ti kititíl kʼal in kitáltsik ban pulek atá xon tu kʼakʼnáb na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","In okʼtsi an atiklábtsik ani in utsaꞌtsik enchéꞌ: ―Na Dios in ulal ban Tʼokat Dhuslab: “Nu kʼimáꞌ abal i ólábkʼi ti bijidh, neꞌech ka éyná kʼal ejtalkʼi an atiklábtsik”; por a wenkʼómalichtsik tin chinkʼontal i kwéꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Tam tin achʼaꞌtsik anchanꞌ an okʼlek páleꞌtsik ani an okʼtsixtsik xin wilál nin takʼixtal na Dios xin jilám dhutsadh na Moisés, tujeytsik kin aliy xan ti kin uwaꞌ abal kin ejto kin chemdhaꞌ na Jesús. Pos in chʼejnáltsik kom ejtal an atiklábtsik labnék tʼajat kʼal xowaꞌ in okʼtsixnál na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Por tam ti jikʼwchinich, na Jesús kale ba jachanꞌ an bitsow. ");
INSERT INTO husNT2005_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Tam ti jun tsudhelom, watʼeytsik dhajawe xon ti kʼwajat in akan an igo ani in chuꞌu abal waynek asta bin ibíl. ");
INSERT INTO husNT2005_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","In chalpánaꞌ tám na Pedro xantʼéy usnék kʼal na Jesús jachanꞌ in akan an igo ani in utsaꞌ enchéꞌ na Jesús: ―Okʼtsix, ka telaꞌ, in akan an igo xa odhbijiy, waynek xoꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Tókʼon tám na Jesús ani in utsaꞌtsik enchéꞌ: ―Ka belaꞌtsik na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Tsubax tu utsáltsik ke xitaꞌ kin utsaꞌ jechéꞌ an chʼén: “Ki wixkʼin tachanꞌ ani ka petʼnaꞌ tabáꞌ ban pujal”, max tsubax lejtal tin belál na Dios ani yab kin jálkʼúkʼliy nin chalab, neꞌech ka tʼájan xan tin ulu. ");
INSERT INTO husNT2005_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Jaxtám tu utsáltsik, ke xowaꞌkich ka kontsi na Dios kʼal i óláb, ka belaꞌ ke Jajáꞌ ti pidhámalich xowaꞌ a kontsámal ani neꞌech ka bachʼutsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Tam ki ólantsik, max jun xitaꞌ ti tʼajtsámal jun xataꞌ yab alwaꞌ, ka pakwlantsi; abal na Tátaꞌ xi kʼwajat walkʼiꞌ, ti ki pakwlantsi jeye an ta walastalábil. ");
INSERT INTO husNT2005_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Pos max yab ka pakwlantsi xi kʼeꞌettsik, na Tátaꞌ xi kʼwajat walkʼiꞌ yab jeye neꞌech ti ki pakwlantsitsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Witsiy tám juní na Jesús kʼal nin exóbaliltsik ban bitsow Jerusalén. Tam ti xeꞌchich na Jesús ban pulek atá xon tu kʼakʼnáb na Dios, utukná kʼal nin okʼlékiltsik an páleꞌtsik, kʼal an okʼtsixtsik xin wilál nin takʼixtal na Dios ani kʼal nin okʼlékil an judíotsik, ");
INSERT INTO husNT2005_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ani konyat enchéꞌ: ―¿Kʼal jantʼom awiltaláb ta tʼajál jechéꞌ? ¿Jitaꞌ ti pidhámal ti awiltaláb ka tʼajaꞌ? ");
INSERT INTO husNT2005_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Tókʼoyattsik enchéꞌ kʼal na Jesús: ―Neꞌech neye tu konoytsik jun xataꞌ, max ti kin tókʼoytsik, neꞌech tám tu utsaꞌtsik neye kʼal jantʼom awiltaláb tu tʼajál xowaꞌ u tʼajál. ");
INSERT INTO husNT2005_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ti kin utsaꞌtsik, ¿Jitaꞌ kʼál ti abnék na Juan ti pujax? ¿Kʼal a Dios o kʼal i iniktsik? ");
INSERT INTO husNT2005_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Tujeytsik tám ti kónóx jajáꞌkʼitsik enchéꞌ: ―¿Jantʼéy ki utsaꞌ? Max ki utsaꞌ ke kʼal a Dios ti abnék, neꞌech ti ku tókʼoy enchéꞌ: “¿Jantʼókʼi pé tám ti yab a beltsitsik xowaꞌ in ulu?” ");
INSERT INTO husNT2005_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","O ¿awxeꞌ ki utsaꞌ ke kʼal i iniktsik ti abnék? Por tákʼíxintsik jún ani jún abal yab xataꞌ kin utsaꞌ, pos in chʼejnál an atiklábtsik kom ejtal in belál ke na Juan kʼal a Dios ti abnék ti tʼiltsix. ");
INSERT INTO husNT2005_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","In utsaꞌtsik tám enchéꞌ na Jesús: ―Yab i choꞌób xitaꞌ kʼál ti abnék. Utsantsik tám kʼal na Jesús: ―Pos kom yabtsik tin utsaꞌ xitaꞌ kʼál ti abnék, yab neye neꞌech tu utsaꞌtsik kʼal jantʼom awiltaláb tu tʼajál jechéꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","In tuju tám ti káw na Jesús kʼal i junbaxtalábkʼi ani in ulu enchéꞌ: ―Jun i inik in tʼayaꞌ yán i akanlek i uba ani in mapuy. In tʼajaꞌ jeye jun i pulek balixtaláb abal kin baliy tajaꞌ nin jaꞌlíl an uba ani in tʼajaꞌ jeye jun i púnchéy abal kin ejto kin beletnaꞌ an tʼayablábtsik. ʼIn matintsixnaꞌ tám an aleláb abal ka tʼójomná kʼal kʼeꞌet ani jajáꞌ kʼale owél. ");
INSERT INTO husNT2005_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Tam tin bajúch an kʼij xowkʼi ti neꞌech ti pitnal an uba, in abaꞌ tám jun in tʼojnálil abal kin konoy xowaꞌ in lujyal jeye kin bachʼu an dhabal aleláb. ");
INSERT INTO husNT2005_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Por yakʼwan kʼal an mat aleláb, chaꞌwat ani mapats kʼubak ti witsiy. ");
INSERT INTO husNT2005_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","In abaꞌ juní ít in tʼojnálil ani jechéꞌ tʼujbayat kʼal an mat aleláb, chʼojbédhá bin ókʼ ani odhbijyat jeye. ");
INSERT INTO husNT2005_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","An dhabal aleláb in abaꞌ juní bél jún ani xi jechéꞌ chemdhá. Tayíl in abaꞌ yán más kʼeꞌet, taltsik chaꞌwat ani xi taltsik chemdhá. ");
INSERT INTO husNT2005_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","ʼJilkʼonék bél nin junkax chakámil xin kʼanidhál tʼajat. Tin okʼontal in abaꞌ jeye abal in chalpay enchéꞌ: “Neꞌech xónaꞌ kin kʼakʼnantsat tu chakámil.” ");
INSERT INTO husNT2005_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Por tam ti ulich an chakámláb, útsáxintsik enchéꞌ an mat aleláb: “Jechéꞌ jaꞌich xi neꞌech ti dhabal tayíl; wana ki chemdhaꞌ ani wawáꞌich tám neꞌech ki dhabalnaꞌ an aleláb.” ");
INSERT INTO husNT2005_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Pos in yakʼwaꞌtsik tám, in chemdhaꞌ ani in petʼnaꞌ eléb aleláb. ");
INSERT INTO husNT2005_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Konyattsik tám enchéꞌ kʼal na Jesús: ―¿Jantʼéy a chalpayaltsik neꞌech kin tʼajaꞌ an dhabal aleláb? ¿Yabxeꞌ neꞌech ka tsích kin chemdhaꞌ jachanꞌ an mat aleláb ani kin matintsi kʼeꞌet an ti aleláb? ");
INSERT INTO husNT2005_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Konyattsik jeye enchéꞌ: ―¿Awxeꞌ yab jaykʼi a ajyámaltsik an Tʼokat Dhuslab xin ulal enchéꞌ?: An tʼujub xi pojká kʼal an kúbal atátsik, jaꞌich nin bajaw ka kʼwajay más ultaláb. ");
INSERT INTO husNT2005_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Jechéꞌ in tʼajámal an Okʼóxláb ani wawáꞌ i chuꞌtal jelti jun i pulek labandhaxtaláb. ");
INSERT INTO husNT2005_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","U leꞌnábwiꞌik ka yakʼwan na Jesús kʼal taltsik xi taꞌ ti kʼwajattsik abal in choꞌób ke kʼal jajáꞌtsik tin kwenta ti tʼiltsin jachanꞌ an ti junbaxtaláb kʼal na Jesús. Por yab xataꞌ ti tʼajtsin na Jesús ani kʼaléchtsik tokot kom in chʼejnál an atiklábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Tayíl, abtsin na Jesús cháb óx ti fariseotsik junax kʼal in atiklábil na Erodes abal ka taktamiyat ani anchanꞌ ka tʼajan kin ulu jun xataꞌ yab alwaꞌ abal ka walbindhá. ");
INSERT INTO husNT2005_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Tam ti ulichtsik, utsan enchéꞌ na Jesús: ―Okʼtsix, wawáꞌ i choꞌób ke ejtal tsubax xowaꞌ a ulal. Tatáꞌ yab a ódhál ti kwenta xowaꞌ in chalpayal an atiklábtsik, pos yab i kʼwajat a eblidh telál an iniktsik xantʼéy in wáynáltsik in éy. A okʼtsixnál kʼal i tsubaxtaláb nin takʼixtal na Dios. ¿In tomnálxeꞌ ki pidhaꞌ ti jalbixtaláb an pulek takʼix romano, o yabaꞌ? ¿Ki pidhaꞌxeꞌ o yabaꞌ? ");
INSERT INTO husNT2005_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Por kom na Jesús in choꞌóbich abal u kʼambixkʼitsik, in utsaꞌtsik enchéꞌ: ―¿Jantʼókʼi tin taktamiyaltsik? Ti kin tsiꞌdhantsi jun i patʼál tumín abal ku telaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Tsiꞌdhantsat tám an ti tumín, tam tin telámich na Jesús, in utsaꞌ enchéꞌ an atiklábtsik: ―¿Jitaꞌ in wal xi jechéꞌ kʼwajat chʼilbadh ban tumín ani jitaꞌ in bij xi jechéꞌ dhutsadh? Tókʼontsik enchéꞌ: ―An lej pulek takʼix romano. ");
INSERT INTO husNT2005_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Utsantsik tám enchéꞌ kʼal na Jesús: ―Pos ka pidhaꞌ an lej pulek takʼix romano xowaꞌ in lujyal kin bachʼu ani ka pidhaꞌ na Dios xowaꞌ Jajáꞌ in lujyal kin bachʼu. Labantsik tʼajat abal anchanꞌ ti tókʼoyattsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Tsích jeye ti chuꞌtáb na Jesús kʼal cháb óx i Saduseotsik, xin ulal ke an chemélomtsik yabich u ejel ti ít ani utsan enchéꞌ: ");
INSERT INTO husNT2005_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―Okʼtsix, na Moisés tu jiltsi dhutsadh ke max jun i tomkidh inik ka chemech ani kin jilaꞌ nin tomtal ani yab in kóꞌyámaltsik ni jun i chakam, nin kidháb koꞌol ka tomkin kʼal an chemtsidh mímláb abal kin kóꞌoy i chakamtsik jelti max in chakámil nin kidháb xi chemech. ");
INSERT INTO husNT2005_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Pos táꞌwiꞌik ti kʼwajat búk i kwitóltsik in kidhábkʼitsik. An jidhtal kwitól tomkin, por chemech ani yab in jilaꞌ ni jun i chakam. ");
INSERT INTO husNT2005_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","In chabtal an kwitól tomkin kʼal an chemtsidh mímláb, por chemech jeye ani yab in jilaꞌ ni jun i chakam. Anchanꞌ jeye ti támun kʼal nin oxtal kidháb. ");
INSERT INTO husNT2005_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ani anchanꞌ ti támun kʼal ejtal xi búk an kwitóltsik. Tomkin kʼal an chemtsidh mímláb ani ni jún yab in jilaꞌ in chakámil. Okʼontaláb chemech jeye an mímláb. ");
INSERT INTO husNT2005_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Tam ka ejechtsik ti ít, ¿kʼal jowaꞌ an inik ti neꞌech ti tomikláb jachanꞌ an mímláb abal ejtal xi búk an kwitóltsik in tomiknámal? ");
INSERT INTO husNT2005_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Tókʼoyattsik tám enchéꞌ kʼal na Jesús: ―Tatáꞌtsik i ukʼpinék tʼajat ta kʼwajat, por jaꞌich abal yab a exláltsik an Tʼokat Dhuslab nibal nin cháp na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Pos tam ka ejdhá an chemélomtsik, neꞌech ka kʼwajay jelti an tʼokat abatwáletsik xi kʼwajat walkʼiꞌ; yabich neꞌech ti tomkinaltsik nibal neꞌech ti pidhnáb xitaꞌ abal ka tomkin. ");
INSERT INTO husNT2005_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Por kʼal tin kwenta an chemélomtsik xi neꞌech ka ejech ti ít, ¿ké yab jaykʼi a ajyámaltsik bin dhuslábil na Moisés xan ti tawná kʼal na Dios ban kʼidhadh teꞌ, xi kʼwajat ti tʼaꞌíl? Enchéꞌ ti utsan: “Nanáꞌ tin Diosil na Abraham, na Isák ani na Jakob.” ");
INSERT INTO husNT2005_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Na Dios, in Diosil xi ejattsik, pos nin ejattal an chemélomtsik kʼwajat ejat. Tatáꞌtsik i ukʼpinék tʼajat ta kʼwajat kʼal tin kwenta an chemélomtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Jun i okʼtsix xin wilál nin takʼixtal na Dios xin jilám dhutsadh na Moisés utey xon ti kʼwajattsik ani in achʼaꞌ xantʼéy u káwlíxnáb. Kom in choꞌóbnaꞌ ke na Jesús tókʼnék alwaꞌ, in konoy enchéꞌ: ―¿Jowaꞌ jáꞌ an takʼixtaláb xi más uluts? ");
INSERT INTO husNT2005_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Tókʼoyat enchéꞌ kʼal na Jesús: ―An takʼixtaláb xi más uluts jaꞌich jechéꞌ: “Ka achʼaꞌ, atiklábtsik xi Israel: an Okʼóxláb jaꞌich ni Diosil ani Jajáꞌ, jaꞌich nu junkax Okʼóxláb. ");
INSERT INTO husNT2005_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ka kʼakʼnaꞌ an Okʼóxláb na Diosil kʼal ejtal na itsích, kʼal ejtal na ejattal, kʼal ejtal na chalab ani kʼal ejtal na cháp.” Jechéꞌ jaꞌich an takʼixtaláb xi más uluts. ");
INSERT INTO husNT2005_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Nin chabtal, in junwal jeye jelti xin jidhtal: “Ka kʼanidhaꞌ xi kʼeꞌettsik jelt xan ta kʼanidhál tabáꞌ.” Yab waꞌach ni jun i takʼixtaláb xi más uluts ké xi jechéꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Utsan tám enchéꞌ kʼal an okʼtsix xin wilál nin takʼixtal na Dios: ―Okʼtsix, alwaꞌ tʼajat ani tsubax xowaꞌ a ulu. Jún tokot a Dios waꞌach ani yab waꞌach más kʼeꞌet. ");
INSERT INTO husNT2005_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Max i kʼakʼnál na Dios kʼal ejtal ni itsích, kʼal ejtal ni chalab, kʼal ejtal ni ejattal ani kʼal ejtal ni cháp ani max i kʼanidhál jeye ejtal xi kʼeꞌettsik jelt xan ti kʼanidhál tibáꞌ, jaꞌich más in jalbíl tin tamét na Dios ké tam ki chemdhál i koꞌnél abal ki pikbantsi na Dios tsikadh o tam ki pikbantsi xowaꞌkich. ");
INSERT INTO husNT2005_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Tam ti na Jesús in achʼaꞌ abal tókʼon kʼal i tʼekʼat chalab, in utsaꞌ tám enchéꞌ: ―Wéꞌich tʼajat u kʼibel abal ki kʼwajay takʼnél kʼal na Dios. Yabich tám xataꞌ konyat más kʼal ni jun xitaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Tam ti na Jesús kʼwajat ti okʼtsix bin elébil an pulek atá xon tu kʼakʼnáb na Dios, in ulu enchéꞌ: ―An okʼtsixtsik xin wilál nin takʼixtal na Dios xin jilám dhutsadh na Moisés, in ulaltsik ke an Kristo u chakámláb kʼal an pulek takʼix Dabid. ");
INSERT INTO husNT2005_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Pos max anchanꞌ, ¿jantʼókʼi pé tám ti jajáꞌ jeye tʼajat na Dabid ijtsiyat kin ulu enchéꞌ kʼal an Tʼokat Ejattaláb?: An Okʼóxláb in utsaꞌ enchéꞌ nu Ajátik: “Ki buxkan tu eját, asta ke Nanáꞌ tu átantsi ejtal xi ti atʼál.” ");
INSERT INTO husNT2005_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Pos max jajáꞌ jeye tʼajat an pulek takʼix Dabid in ulu ke an Kristo jaꞌich nin Ajátik, ¿jantʼókʼi pé tám tu ulwáb ke na Dabid, jaꞌich in wejeꞌ pakélil an Kristo? Yán i atiklábtsik taꞌ ti kʼwajat tajaꞌ ani u ochʼówixtsik kʼal yantam i kulbéxnich. ");
INSERT INTO husNT2005_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Tam ti na Jesús bél kʼwajat in okʼtsal an atiklábtsik in utsaꞌtsik enchéꞌ: ―Ka kóꞌoytsik i kwenta kʼal an okʼtsixtsik xin wilál nin takʼixtal na Dios. Jajáꞌtsik in kulbetnál ka xeꞌchin kʼal in jochʼdhaꞌ xekét ani ka chapnédhátsik kʼal yantam i kʼakʼnaxtaláb tin tamét an atiklábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ban atátsik xon tu tʼajnal an junkuntaláb, in kulbetnáltsik ka buxkan ban koytaláb xon tu buxkanaltsik xi más uluts ani tam waꞌach i kʼapúxnich, in kulbetnáltsik ka buxká ban koytaláb xi más alwaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Jajáꞌtsik in kʼántsal tin kʼimáꞌ an chemtsidh mímlábtsik ani tayíl, in tʼajáltsik i nakdhaꞌ óláb abal kin makʼuxnaꞌ ani abal ka utsantsik ke i lujdhaꞌ iniktsik. Xin tʼajáltsik anchanꞌ, neꞌech kin bachʼu jun i yajtsiktaláb más púlek. ");
INSERT INTO husNT2005_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jun i kʼij, na Jesús buxúl tin tamét xon ti kʼwajat nin bál an tumín xu pikbantsáb na Dios, in telál xan ti an atiklábtsik tin balyal an pikbantsixtaláb ani yán i tumínladh iniktsik in balyal yandhaꞌ i tumín. ");
INSERT INTO husNT2005_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ulich jeye jun i chʼojontál chemtsidh mímláb ani in baliy cháb i tsʼitsik tʼipax tumín xi yab yandhaꞌ in jalbíl. ");
INSERT INTO husNT2005_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Na Jesús in kaniy tám nin exóbaliltsik ka utey ani in utsaꞌtsik enchéꞌ: ―Tsubax tu utsáltsik, an tumín xin pidhnaꞌ jechéꞌ an chʼojontál chemtsidh mímláb wéꞌ tʼajat, por más jaꞌ yán in jalbíl tin tamét na Dios ké xi ejtal an tumín xi kʼeꞌettsik in balyámal bin bál an pikbantsixtaláb. ");
INSERT INTO husNT2005_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Pos kʼeꞌettsik, tokot in pidhnál xowaꞌ yabich in yéntsal; por an mímláb, kʼal in chʼojontáltal, in pidhnaꞌ ejtal xowaꞌ taꞌ tin koꞌol abal kin watʼnaꞌ kʼál na kʼítsá. ");
INSERT INTO husNT2005_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Tam ti na Jesús exomich ti kalel bin elébil an pulek atá xon tu kʼakʼnáb na Dios, utsan enchéꞌ kʼal jún ti éb nin exóbaliltsik: ―¡Okʼtsix, ka telaꞌ an labidh tʼujubtsik xi kʼál ti tʼajadh an pulek atá xon tu kʼakʼnáb na Dios ani an atátsik xi jayéch jeye in adhík! ");
INSERT INTO husNT2005_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Por tókʼoyat enchéꞌ kʼal na Jesús: ―Xoꞌ a chuꞌtal jechéꞌ an pakdhaꞌ atá, por yab neꞌech ka jilkʼon ni jun i tʼujub tʼíꞌbáx. Ejtal neꞌech ka julpá. ");
INSERT INTO husNT2005_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Kʼaletsik tám ban chʼén Olibos xi kʼwajat tin tamét an pulek atá xon tu kʼakʼnáb na Dios. Tam ti tajaꞌich ti buxúl na Jesús, utey tám na Pedro, na Jakobo, na Juan ani na Andrés abal kin konoytsik chinatkʼi enchéꞌ: ");
INSERT INTO husNT2005_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―Ti ku utsaꞌ xowkʼi neꞌech ka támun ejtal xowaꞌ a ulu ani ti ku utsaꞌ jeye xantʼom exól neꞌech ki chuꞌu abal ki choꞌóbnaꞌ ke exomich ti kʼunel xowkʼi neꞌech ka támun. ");
INSERT INTO husNT2005_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Tókʼoyattsik enchéꞌ kʼal na Jesús: ―Ka beletnaꞌtsik tabáꞌ abal yab ki kʼambiyat kʼal ni jun xitaꞌ, ");
INSERT INTO husNT2005_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","pos neꞌech ka tsích yán kin kʼambixnaꞌ nu bij ani neꞌech kin ulutsik enchéꞌ: “Nanáꞌich nin Kristo”. Ani yán neꞌech ka kʼambiyat kʼal jechéꞌ an kʼambixtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","ʼTam ka achʼaꞌtsik ke exom i péjéxtaláb túkʼi túkʼi ani u tʼilnal ke ítich juní neꞌech ka tujey, yab ki kʼwajay ta chalpax, pos anchanꞌ koꞌol ka támun, por yabél jaꞌich an pakwenib. ");
INSERT INTO husNT2005_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Pos an pakdhaꞌ bitsow neꞌech ti péjéx kʼal in at pakdhaꞌ bitsow ani an pakdhaꞌ okʼlek neꞌech ti péjéx kʼal in at pakdhaꞌ okʼlek. Neꞌech ka léwékʼin an chabál túkʼi túkʼi, neꞌech ka waꞌchin i kʼaꞌínab ani neꞌech ti péjéx an atiklábtsik. Por ejtal jechéꞌ, jaꞌich in tujtal an yajtsiktaláb, jelti an yajal xin achʼál jun i mímláb tam neꞌchich kin waꞌchiy i chakam. ");
INSERT INTO husNT2005_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","ʼKa beletnaꞌtsik tabáꞌ, pos neꞌech ki pidhná ban pakdhaꞌ tʼójodh ani neꞌech ki chaꞌwattsik ban atá xon tu tʼajnal an junkuntaláb. Neꞌech ki kinandhátsik ban pakdhaꞌ awiltaláb ani ban pakdhaꞌ takʼix kʼal Nanáꞌkʼi tu kwenta. Anchanꞌ, neꞌech ka ejto ti kin tʼilaꞌtsik tin tamét jajáꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ani neꞌech ka tʼiltsin jechéꞌ an ti alwaꞌ tʼilab ejtal an atiklábtsik xi techéꞌ ti kʼayꞌlá ani tám neꞌech ka ulchich an pakwenib. ");
INSERT INTO husNT2005_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Tam ki yakʼwantsik ani ki júnájich abal ki pidhná ban awiltalábtsik, yab ki kʼwajaytsik ta chalpax kʼal tin kwenta xowaꞌ neꞌech ka ulu. Tam kin bajúch an ora xowkʼi neꞌech ki káwin, neꞌech ki pidhantsik xowaꞌ ka ulu. Pos yab tatáꞌtsik neꞌech ta káw, neꞌech ti káw an Tʼokat Ejattaláb xi kʼwajat ba na itsích. ");
INSERT INTO husNT2005_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Taltsik neꞌech kin pidhnaꞌ nin kidhábtsik abal ka chemdhá ani an tátaꞌlábtsik neꞌech jeye kin pidhnaꞌ nin chakámiltsik abal ka chemdhá. An chakámlábtsik neꞌech kin tomnaꞌ nin tátaꞌ ani nin nánaꞌ ani neꞌech kin pidhnaꞌ abal ka chemdhátsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Neꞌech ki atʼantsik kʼal ejtal an atiklábtsik xi yab u belom kʼal Nanáꞌkʼi tu kwenta, por xitaꞌ kin kuxuy ejtal jechéꞌ, neꞌech ka loꞌwat. ");
INSERT INTO husNT2005_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","ʼXitaꞌ kin ajay jechéꞌ, kin exbay: Tam ka chuꞌutsik an kʼakʼadh atʼaxtaláb xin tʼilámal an tʼiltsix Daniel kʼwajatich xon tu kʼakʼnáb na Dios, tám, xi kʼwajattsik ban chabál xi Judea, ki kʼaletsik ta chinkʼonal ban chʼénlom. ");
INSERT INTO husNT2005_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Xi kʼwajattsik tin éb nin kʼimáꞌ, yab ka paꞌaytsik abal ka ochich kin ikʼiꞌ jun xataꞌ altá. ");
INSERT INTO husNT2005_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ani xi kʼwajattsik bin ale, yab ka witsiy tin kʼimáꞌ abal kin ikʼiꞌ nin wát. ");
INSERT INTO husNT2005_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Chʼojontál in chuꞌbíl an mímlábtsik xi ka elan kóꞌodh jachanꞌ i kʼij o u tsutsúdhom! ");
INSERT INTO husNT2005_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ka kontsaltsik na Dios abal yab ka támun jechéꞌ tam in kʼijil in chamáy, ");
INSERT INTO husNT2005_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","pos watʼats ti kʼakʼadh an yajtsiktaláb xi neꞌech ka waꞌchin jachanꞌ i kʼij. Asta tin tʼajám na Dios an chabál ani an walkʼiꞌ ani asta xoꞌ, yab jaykʼi waꞌchinék ni jun i yajtsiktaláb jelti xi neꞌech ka waꞌchin. Ani yab más jaykʼi neꞌech ka waꞌchin jun i yajtsiktaláb anchanꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Max an Okʼóxláb yab kin wéꞌmédhaꞌ jachanꞌ an kʼij, yab xitaꞌ neꞌech ka loꞌey; por kʼal tin kwentakʼi in kʼánél xi Jajáꞌ in takwyámal, neꞌech kin wéꞌmédhaꞌ jachanꞌ an kʼij. ");
INSERT INTO husNT2005_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","ʼTam jachanꞌ i kʼij, max jun xitaꞌ ti ki utsaꞌtsik enchéꞌ: “Ka telaꞌ, jéꞌ kʼwajat an Kristo”, o “ka telaꞌ, núꞌ kʼwajat”, yab ka beltsi. ");
INSERT INTO husNT2005_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Pos neꞌech ka waꞌchin i kʼambixtsik xi neꞌech kin ulu ke jajáꞌich nu Kristo, o ke jajáꞌich xi abadh ti tʼiltsix kʼal na Dios. Neꞌech kin tʼajaꞌ i pakdhaꞌ exól ani i pakdhaꞌ labandhaxtaláb abal kin kʼambiy an atiklábtsik ani neꞌech kin leꞌnaꞌ kin kʼambiytsik asta xi takudhich kʼal na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Por yab ka ukʼtsitsik ke ejtal jechéꞌ tu okʼox utsámalich abal ki kʼwajaytsik tʼojojodh. ");
INSERT INTO husNT2005_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","ʼTayíl, tam ka watʼéch jachanꞌ an yajtsiktaláb, na kʼítsá neꞌech ka jikʼwchin ani na íchʼ yab neꞌech ka tajkʼan; ");
INSERT INTO husNT2005_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","neꞌech ka kwajlan na óttsik ani ejtal an pakdhaꞌ chápláb xi kʼwajat walkʼiꞌ, neꞌech ka yoywat. ");
INSERT INTO husNT2005_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Támkʼi jachanꞌ, Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik, neꞌech kin chuꞌtat kʼal ejtalkʼi, pos neꞌech kin tsích ban tokow kʼal ejtal nu cháp ani nu pulek labidh tʼokát. ");
INSERT INTO husNT2005_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Neꞌech tám ku abaꞌ nu tʼokat abatwálejiltsik putálkʼi an kʼayꞌlá ani putálkʼi túꞌ walkʼiꞌ abal kin junku xu takwyámal. ");
INSERT INTO husNT2005_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","ʼKa exbaytsik jechéꞌ an junbaxtaláb kʼal tin kwenta in akan an igo: Tam ka tujéch ti kalel nin dhálam kʼweꞌéltsik ani ka tujéch ti eblinal nin xekéltsik, a choꞌóbichtsik abal exomich ti kʼunel an kʼakʼal kʼij. ");
INSERT INTO husNT2005_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Anchanꞌ jeye, tam ka chuꞌutsik exomich ti támnal ejtal xowaꞌ tu utsámal, ka choꞌóbnaꞌ abal wéꞌich u kʼibel kin tsích juní. ");
INSERT INTO husNT2005_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Tsubax tu utsáltsik, ke ejtal jechéꞌ neꞌech ka támun tam yabél chemnektsik xi kʼwajat ejat jechéꞌ i kʼij. ");
INSERT INTO husNT2005_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ejtal xi túꞌ kʼwajat walkʼiꞌ ani xi kʼwajat jeye techéꞌ ban kʼayꞌlá, neꞌech ka pakchun; por xowaꞌ Nanáꞌ u ulal, yab jaꞌ neꞌech ka watʼey yab ka támun anchanꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","ʼPor kʼal tin kwenta na kʼítsá ani an ora xowkʼi ti neꞌech kin tsích juní, ni jun xitaꞌ yab in choꞌób, nibal an tʼokat abatwáletsik xi túꞌ kʼwajat walkʼiꞌ, nibal Nanáꞌ xin Chakámláb kʼal na Dios, tokot in choꞌób nu Tátaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","ʼJaxtám tu utsáltsik: Ka koꞌkóm i kwenta ani ki ólantsik juniniꞌ abal yab ki elan ukʼpidh, pos yab a choꞌóbtsik xowkʼi neꞌech kin witsiy juní. ");
INSERT INTO husNT2005_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","In junwal jelti jun i inik xi neꞌech owél bitsow. Tam ti yabél kʼalnek, in punkʼuntsi nin tʼojnáliltsik abal ka beletnantsat tin kʼimáꞌ; juntsik juntsik in pidhaꞌ ti tʼojláb ani in takʼiy an belkol wiꞌleb kin chuꞌchúm alwaꞌ abal ka japtsin an ti wiꞌleb tam ka witsiy. ");
INSERT INTO husNT2005_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Nanáꞌ u junwal jelti an dhabal atá xi kʼale owél bitsow. Jaxtám tu utsáltsik ka koꞌkóm i kwenta kom yab a choꞌóbtsik xowkʼi neꞌech kin witsiy, max dhamkʼulom, chʼejel akal, tam ka dhájan an pekʼel o tam tsudhenekich, ");
INSERT INTO husNT2005_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","abal tam kin tsích jun jikʼtowále, yab tu elaꞌ i ukʼpidhtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Xowaꞌ tu utsáltsik yab tatáꞌkʼitsik tu utsál, ejtalkʼi u utsáltsik enchéꞌ: Ka koꞌkómtsik i kwenta. ");
INSERT INTO husNT2005_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Tam ti jachanꞌ, u kʼibel cháb a kʼítsá abal ka ajíbná an paskwa junax kʼal nin ajíb an pan xi yab jilbédhats kʼal an jilbédhaxtaláb kʼoye, an ajib xin ajíbnál an israelitatsik. An okʼlek páleꞌtsik junax kʼal an okʼtsixtsik xin wilál nin takʼixtal na Dios xin jilám dhutsadh na Moisés, in ayaltsik xan ti kin uwaꞌ abal kin yakʼwaꞌ na Jesús kʼal i kʼambixtaláb ani kin chemdhaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Por in ulaltsik enchéꞌ: ―Yab ki tʼajaꞌ tam exom an ajib abal yab ka kʼwajay ti péjéx an atiklábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Tam ti na Jesús kʼwajat ban bitsow xi Betania bin kʼimáꞌ na Simón xin koꞌolwiꞌik an kʼwajat atʼax tʼítʼ, lejat buxúl ti kʼapul, ulich jun i mímláb xin tsiꞌdhál jun i frasko tʼajadh kʼal i alabastro. An frasko tsʼutsat kʼal i niwiytaláb xi mapal jáꞌ in niwíy i wich xu bijyáb ti nardo ani kajbidh tʼajat in jalbíl. In pejkántsi tin núkʼ an frasko ani in joltsi an ti niwiytaláb bin ókʼ na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Taltsik xi taꞌ ti kʼwajattsik, chakuytsik ani u útsáxtsik enchéꞌ: ―¿Jantʼókʼi ti odhná jechéꞌ an niwiytaláb? ");
INSERT INTO husNT2005_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ka nujwatwiꞌik kʼal óx i boꞌ inik i denariotsik o más abal ka pidhan an ti tumín an chʼojontáltsik. Ani ulwat abal yab tʼajat alwaꞌ xowaꞌ in tʼajaꞌ jachanꞌ an mímláb. ");
INSERT INTO husNT2005_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Por na Jesús in ulu enchéꞌ: ―Jilaꞌ kʼwajat, yab xataꞌ ka utsaꞌ. Jechéꞌ xowaꞌ tin tʼajtsi, alwaꞌ tʼajat. ");
INSERT INTO husNT2005_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Pos an chʼojontáltsik echʼekʼi neꞌech ka kʼwajay kʼal tatáꞌtsik ani neꞌech ka ejto ka tolmiytsik tam ka leꞌnaꞌ, por Nanáꞌ yab echʼekʼi neꞌech kin kʼwajay kʼal tatáꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Jajáꞌ tin tʼajtsi xowaꞌ in ejto, tin niwbédhantsámalich an tu tʼuꞌúl abal ka kʼwajay tʼojojodhich tam kin jolyat. ");
INSERT INTO husNT2005_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Tsubax tu utsáltsik, ke putálkʼi tin pubíl an kʼayꞌlá xónꞌtikichkʼi ka tʼilan an alwaꞌ tʼilab, neꞌech jeye ka tʼilan xowaꞌ in tʼajámal jechéꞌ an mímláb abal ka chalpayat. ");
INSERT INTO husNT2005_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Na Judas Iskariote, jún ti éb xi lajucháb an exóbaltsik, kʼale tám kin chuꞌu an okʼlek páleꞌtsik ani in utsaꞌ abal jajáꞌ neꞌech kin pidhnaꞌ na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Tam tin achʼaꞌtsik, kulbétsik tʼajat ani utsan na Judas abal neꞌech ka pidhan ti tumín. Na Judas in tuju tám kin aliy xan ti kin uwaꞌ abal kin pidhnaꞌ na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Tin jidhtal kʼítsájil an ajib tam u kʼapnal an pan xi yab jilbédhats kʼal an jilbédhaxtaláb kʼoye ani tam u chemdháb jeye an borrego abal ka ajíbná an paskwa, konyat enchéꞌ na Jesús kʼal an exóbaltsik: ―¿Jónꞌ ta léꞌ ku kʼale ki tʼojojoy abal ka kʼapu an wiyadh borrego kʼal tin kwenta an paskwa? ");
INSERT INTO husNT2005_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","In abaꞌ tám cháb xi taꞌ ti xeꞌech kʼal Jajáꞌ ani in utsaꞌ enchéꞌ: ―Ki kʼale ban bitsow, tajaꞌ, neꞌech ka elaꞌtsik jun i inik xin neꞌdhál jun mul i jaꞌ ani ka wéwnaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ki ochichtsik xon ti jajáꞌ ka ochich ani ka utsaꞌ enchéꞌ an dhabal atá: “An okʼtsix in léꞌ kin choꞌóbnaꞌ xon ti kʼwajat an altá xon ti neꞌech kin kʼapu an wiyadh borrego junax kʼal nin exóbaliltsik kʼal tin kwenta an paskwa.” ");
INSERT INTO husNT2005_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Neꞌech tám ti ki óltsitsik jun i pulek altá tʼojojodhich alwaꞌ ba jun i púntsíx atá. Ka lejkiytsik tám tajaꞌ an kʼapnél abal wawáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Kale tám an exóbaltsik ani ulich ban bitsow Jerusalén. Anchanꞌ xan ti utsantsik, anchanꞌ tin elaꞌ ani in lejkíchtsik tám an kʼapnél abal tin kwenta an paskwa. ");
INSERT INTO husNT2005_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Tam ti akléch, ulich na Jesús junax kʼal xi lajucháb nin exóbaliltsik ");
INSERT INTO husNT2005_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","ani tam ti kʼwajatichtsik ti kʼapul ban mesa, utsantsik enchéꞌ kʼal na Jesús: ―Tsubax tu utsáltsik ke jún ti éb xi tatáꞌtsik, xi xoꞌ kʼwajat ti kʼapul kʼal Nanáꞌ, neꞌech ti kin pidhnaꞌ abal kin chemdhá. ");
INSERT INTO husNT2005_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Tʼeꞌpintsik tám tʼajat ani tujey ti konyáb enchéꞌ na Jesús kʼal xi lajucháb juntsik ti juntsik: ―¿Awxeꞌ nanáꞌ? Ani jún in ulu jeye enchéꞌ: ―¿Awxeꞌ nanáꞌ? ");
INSERT INTO husNT2005_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Tókʼoyattsik tám enchéꞌ kʼal na Jesús: ―Jún ti éb xi tatáꞌtsik lajucháb, xi exom in juꞌwal an pan ba jayéch an talab xon ti Nanáꞌ u juꞌwal, jaꞌich xi neꞌech ti kin pidhnaꞌ abal kin chemdhá. ");
INSERT INTO husNT2005_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik, neꞌech kin chemdhá jelt xan tin ulal an Tʼokat Dhuslab, por ¡chʼojontál in chuꞌbíl an inik xi neꞌech ti kin pidhnaꞌ! Pos yajtsik tʼajat ti neꞌech kin jalbiy, másakwiꞌik alwaꞌ max yabak waꞌchinék. ");
INSERT INTO husNT2005_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Lejat kʼwajattsik ti kʼapul, na Jesús in téynaꞌ an pan, in pidhaꞌ ti jalbintsixtaláb na Dios ani tam tin pejámalich, in pidhaꞌ nin exóbaliltsik ani in utsaꞌtsik enchéꞌ: ―Ka kʼaputsik, jechéꞌ jaꞌich nu tʼuꞌúl. ");
INSERT INTO husNT2005_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","In téynaꞌ tám jun i lejab baltsidh ti yajtsik uxnél, in pidhaꞌ ti jalbintsixtaláb na Dios, in watʼbantsi nin exóbaliltsik ani ejtal in uchʼaꞌ wetsik wetsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","In utsaꞌtsik enchéꞌ: ―Jechéꞌ, jaꞌich nu xichʼál xi neꞌech kin jalbílnaꞌ an ít lejkintaláb xin lejkiyámal na Dios. Jechéꞌ nu xichʼál, jaꞌich xi neꞌech ku wakʼlaꞌ ban peltsidh teꞌ abal tin alwaꞌbíl yán i atiklábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Tsubax tu utsáltsik ke yabich neꞌech kin witsiy ku uxtsi tin jaꞌlíl an uba asta tam ku uchʼaꞌ xi ít an uxnél xon tu takʼix na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Tam ti okʼontsik kin ajtintsi na Dios, kʼaletsik tám ban chʼén Olibos. ");
INSERT INTO husNT2005_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Utsantsik enchéꞌ kʼal na Jesús: ―Jechéꞌ i akal ejtal tatáꞌtsik neꞌech ka jilaꞌ ti kin belaꞌ kʼal tin kwenta xowaꞌ neꞌech ku tamu, pos enchéꞌ tin ulu na Dios ban Tʼokat Dhuslab: “Neꞌech ku walkaꞌ ka chemdhá an belkol borregotsik ani an borregotsik neꞌech ka bukʼey.” ");
INSERT INTO husNT2005_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Por tam kin ejech ti ít, neꞌech kin kʼale okʼox ban chabál Galilea ani tatáꞌtsik tayíl. ");
INSERT INTO husNT2005_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Utsan tám enchéꞌ kʼal na Pedro: ―Maske ejtal xi más kin jilaꞌ ti belaꞌ, nanáꞌ yabaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Por utsan enchéꞌ kʼal na Jesús: ―Tsubax tu utsál ke jechéꞌ i akal, tam yabél dhájnék an pekʼel chábíl, tatáꞌ óxílich a ulúmal ke yab tin exlál. ");
INSERT INTO husNT2005_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Por na Pedro in witsʼkʼo juní ani in ulu enchéꞌ: ―Maske kin utsan ke neꞌech kin chemdhá junax kʼal Tatáꞌ, yab neꞌech ku ulu ke yab tu exlál. Ani ejtaltsik anchanꞌ tin ulu. ");
INSERT INTO husNT2005_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ulichtsik tám ba jun i chakam aleláb xin bij Jetsemaní ani utsan enchéꞌ an exóbaltsik kʼal na Jesús: ―Ki buxkankʼitsik techéꞌ, lejat Nanáꞌ neꞌech núꞌ aniꞌ tin ól. ");
INSERT INTO husNT2005_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","In júnaꞌ na Pedro, na Jakobo ani na Juan abal ka junikná kʼál ani tujey kin achʼaꞌ na Jesús jun i tʼeꞌpintaláb ani yajtsiktaláb. ");
INSERT INTO husNT2005_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Utsantsik enchéꞌ kʼal na Jesús: ―U achʼál tu ejattal ke neꞌech ku chémay jechéꞌ an tʼeꞌpintaláb. Ki jilkʼontsik techéꞌ ani yab ki wayichtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Kʼale tám na Jesús lej wéꞌ túꞌ aniꞌ, tudhlan kutúl asta chabál ani in kontsi na Dios max in ejtowalak kin tʼajaꞌ abal yab kin watʼnaꞌ an yajtsiktaláb xi neꞌech kin tametnaꞌ jachanꞌ i ora. ");
INSERT INTO husNT2005_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ba nin ólábil in ulu enchéꞌ: ―Tátaꞌ, ejtal xowaꞌ a léꞌ u tʼájnal kʼal na awiltal ani kʼal na cháp. Nanáꞌ tu kontsal ti kin tolmintsi abal yab ku watʼnaꞌ jechéꞌ an yajtsiktaláb xi tin aytsím; por yab ka tʼájan xowaꞌ Nanáꞌ u léꞌ, ka tʼájan xowaꞌ Tatáꞌ a léꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Witsiy tám xon ti kʼwajat xi óx an exóbaltsik ani u wayaltsik tin elaꞌ. Utsan enchéꞌ na Pedro: ―Simón, ¿a belál ta wayal? ¿Yab a ejto ka kuxuy ni jun i ora yab ki wayich? ");
INSERT INTO husNT2005_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Yabtsik ki wayich ani ki ólan abal yab ki átátsik kʼal an lej atʼax. Tsubax kʼejle, na ejattaltsik in léꞌ ki ólan, por yab i tolmiyábtsik kʼal na tʼuꞌúl abal yab tʼajat likat. ");
INSERT INTO husNT2005_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Kʼale tám juní ani ólan. Anílkʼi ti ólan jelt xan tin tʼajámal tin jidhtal. ");
INSERT INTO husNT2005_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Tam ti witsiy na Jesús, u wayaltsik juní tin elaꞌ abal u mútʼnalichtsik tʼajat nin wal kʼal an akal ani yabtsik in elaꞌ xan ti ka tókʼon. ");
INSERT INTO husNT2005_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Kʼale juní ti ól tin oxtsíl ani tam ti witsiy xon ti kʼwajat an exóbaltsik, in utsaꞌtsik enchéꞌ: ―¿A óntsaltsik ta wayal ani ta koyol? ¡Lejatich! In bajúmalich an ora xowkʼi Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik, neꞌech kin pidhnájich abal kin chemdhá kʼal an walablomtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ki chʼakáchtsik ani wanách; núꞌich tál xi neꞌech ti kin pidhnaꞌ abal kin chemdhá. ");
INSERT INTO husNT2005_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Bél kʼwajat ti káw na Jesús tam ti ulich na Judas, jún ti éb xi lajucháb an exóbaltsik. Ulich junax kʼal yán i yákʼwaltsik, in teykómtsik i machét ani i teꞌ. Abnéktsik kʼal an okʼlek páleꞌtsik ani kʼal an okʼtsixtsik xin wilál nin takʼixtal na Dios xin jilám dhutsadh na Moisés ani kʼal nin okʼlékil an judíotsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Na Judas, xi neꞌech ti pidhnax, jaykʼi tin utsámalich an yákʼwaltsik xantʼéy neꞌech kin tʼajaꞌ abal kin exlaꞌtsik xitam jáꞌ na Jesús. Enchéꞌ tin utsaꞌtsik: ―An inik xi neꞌech ku chʼuchʼbay, jaꞌich xi tatáꞌtsik a ayal. Ka yakʼwaꞌ ani ka júnaꞌtsik belkómte alwaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Tam ti ulich, utey ba na Jesús ani in utsaꞌ enchéꞌ: ―¡Okʼtsix, Okʼtsix! Ani in chʼuchʼbay. ");
INSERT INTO husNT2005_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Támkʼi ti yakʼwan na Jesús kʼal an yákʼwaltsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Jún ti éb xi taꞌ ti kʼwajat kʼal na Jesús in jixónaꞌ nin machétil ani in patíntsi tin xuchun nin tʼojnálil an okʼlek páleꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Utsantsik tám enchéꞌ kʼal na Jesús xi ulich an ti yakʼwaxtsik: ―¿Jantʼókʼi ta tsiꞌnektsik kʼal i machét ani kʼal i teꞌ abal ti kin yakʼwaꞌ jelti max neꞌech ka yakʼwaꞌtsik jun i kwéꞌ? ");
INSERT INTO husNT2005_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Tsudhey ka tsudhey in kʼwajinek kʼal tatáꞌtsik ban pulek atá xon tu kʼakʼnáb na Dios tin okʼtsix ani yab tin yakʼwámal. Por jechéꞌ xowaꞌ exom tin tʼajtsaltsik, jaꞌich abal ka tʼájan xan ti kʼwajat dhutsadh ban Tʼokat Dhuslab. ");
INSERT INTO husNT2005_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Jilan tám kwetém na Jesús ani kʼale ti chinkʼonal an exóbaltsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Táꞌ jeye ti neꞌech wewkómte na Jesús kʼal jun i kwitól inik ani tokot bolilidh kʼal jun i dhak kʼudhkʼum. Jeché an kwitól inik, yakʼwan jeye kʼal an yákʼwaltsik xi kʼál ti yakʼwan na Jesús, ");
INSERT INTO husNT2005_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","por in jilchʼónaꞌ an dhak kʼudhkʼum xi kʼál ti bolidh ani chilim ti ájlách. ");
INSERT INTO husNT2005_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Júná tám na Jesús bin kʼimáꞌ an lej okʼlek páleꞌtsik ani junkun tajaꞌ nin okʼlékiltsik an páleꞌtsik, nin okʼlékiltsik an judíotsik ani an okʼtsixtsik xin wilál nin takʼixtal na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Na Pedro wéwnaxin ówkʼi ani ulich asta bin elébil in kʼimáꞌ an lej okʼlek páleꞌtsik. Buxkan tajaꞌ ti dhilal bin wál an kʼamal junax kʼal xin beletnáltsik an pulek atá xon tu kʼakʼnáb na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Nin okʼlékiltsik an páleꞌtsik ani an Junkulom Awiltaláb in ayal jun xataꞌ abal kin ejto kin walbiy na Jesús ani anchanꞌ ka pidhná abal ka chemdhá, por yab eltsin ni jun in walab. ");
INSERT INTO husNT2005_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Kʼal yán ti kʼwajay ti jantsinal ti káw na Jesús, por kʼeꞌetich kʼeꞌetich xowaꞌ in ulutsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Kubey tám taltsik ti ólnax jayéchkʼi kʼal i januts káw ani in ulutsik enchéꞌ: ");
INSERT INTO husNT2005_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―Wawáꞌ i achʼám tin ulúmal enchéꞌ: “Nanáꞌ neꞌech ku paku jechéꞌ an pulek atá xon tu kʼakʼnáb na Dios xin kubám an iniktsik ani ti óx a kʼítsá neꞌech ku kubaꞌ juní ít xi yab kubadh kʼal i iniktsik.” ");
INSERT INTO husNT2005_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Por nibal anchanꞌ yab in junu xowaꞌ in ulutsik xi jidhtal. ");
INSERT INTO husNT2005_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Kubey tám an lej okʼlek páleꞌtsik junax chʼejel xon ti kʼwajat xi táꞌtsik ti junkunék ani konyat enchéꞌ na Jesús: ―¿Jantʼókʼi ti yab i tókʼnal? ¿Tsubaxxeꞌ xowaꞌ i kʼwajat ta usnal o yabaꞌ? ");
INSERT INTO husNT2005_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Por na Jesús ní wéꞌ yab kʼuchun ani nibal xataꞌ in tókʼoy. Konyat tám juní enchéꞌ kʼal nin lej okʼlékil an páleꞌtsik: ―¿Tatáꞌxeꞌ ni Kristo, xi Chakámláb kʼal na Dios xu kʼakʼnáb? ");
INSERT INTO husNT2005_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Tókʼon enchéꞌ na Jesús: ―Nanáꞌ. Ani neꞌech ti kin chuꞌutsik Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik, buxúl tin eját na Dios xi ejtal in ejtowal kin tʼajaꞌ ani tam kin tsích juní ban tokow. ");
INSERT INTO husNT2005_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","An lej okʼlek páleꞌtsik in michʼónaꞌ kʼal in chákub nin kʼudhkʼúmil xin kʼwajbím abal anchanꞌ ti tókʼoyat kʼal na Jesús ani in ulu enchéꞌ: ―Yabich más i yéntsal i ólnax. ");
INSERT INTO husNT2005_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","A achʼaꞌichtsik xan tin chʼikat tʼajaꞌ na Dios. ¿Jantʼéy xoꞌ a ulaltsik ki tʼajtsi? Ejtal xi taꞌ ti junkunék, jununúl tin ulutsik abal walbidh tʼajat na Jesús ani in tomnál ka chemdhá. ");
INSERT INTO husNT2005_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Tujey tám ti tubkayáb na Jesús kʼal taltsik, ti putsuntsáb tin wal, ti chaꞌwáb kʼal i kʼubaklek ani u usnal enchéꞌ: ―¡Ka ulu xoꞌ xitaꞌ ti chaꞌaw! Ani pikʼyat jeye bin wal kʼal an belkol pulek atá xon tu kʼakʼnáb na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Na Pedro kʼwajat chaꞌat bin elébil an pulek atá ani támkʼi jachanꞌ, ulich jun in tsidhan xu tʼojnal bin kʼimáꞌ an lej okʼlek páleꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Tam ti chuꞌtat na Pedro ti dhilal, teloloyat alwaꞌ ani utsan enchéꞌ: ―Tatáꞌ junax teye ta xeꞌech kʼal na Jesús xi Nasaret. ");
INSERT INTO husNT2005_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Por na Pedro in ulu enchéꞌ: ―Yab u exlál, nibal u choꞌób xantʼéy a tʼilál. Kale eléb xon tu oxnáb ani dhájan tám jun i pekʼel. ");
INSERT INTO husNT2005_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Chab chuꞌtat juní kʼal an tsidhan ani tujey kin utsaꞌ enchéꞌ xi táꞌtsik ti kʼwajat: ―Jechéꞌ an inik jaꞌich jeye in kidhtal na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Por jajáꞌ in witsʼkʼo kin ulu ke yab aniꞌ. Tam ti más lej jun wéꞌ, utsan enchéꞌ kʼal xi táꞌtsik ti kʼwajat: ―Tsubax lejtal, tatáꞌ jaꞌich teye jún ti éb xi jajáꞌtsik, pos tatáꞌ i Galileo ani anchanꞌ teye i káw jelti jajáꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Tujey tám kin ulu na Pedro abal kin tamu xataꞌ yab alwaꞌ max yab tsubax xowaꞌ in ulal ani in lej tsubax ulu enchéꞌ: ―Tsubax tu utsáltsik ke yab u exlál xitam inik xi kʼwajattsik a tʼilál. ");
INSERT INTO husNT2005_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Támkʼi jachanꞌ, dhájan an pekʼel tin chabtsíl. In chalpánaꞌ tám na Pedro xan ti usnék kʼal na Jesús: “Tam yabél dhájnék an pekʼel tin chabtsíl, tatáꞌ óxílich a ulúmal ke yab tin exlál.” Ani ukʼikʼíl ti kʼwajay kin chalpay xowaꞌ usnék kʼal na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Tam ti tsudhey, dhajawe tʼajat ti junkun nin okʼlékiltsik an páleꞌtsik kʼal nin okʼlékil an judíotsik, kʼal an okʼtsixtsik xin wilál nin takʼixtal na Dios ani kʼal an Junkulom Awiltaláb. Tam tin chalpáchtsik alwaꞌ xantʼéy neꞌech kin tʼajaꞌ, in júnaꞌtsik tám wikʼadh na Jesús ani in pidhnaꞌ ba na Pilato. ");
INSERT INTO husNT2005_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Konyat enchéꞌ na Jesús kʼal na Pilato: ―¿Tatáꞌxeꞌ nin Pulek Takʼíxal an judíotsik? Tókʼon enchéꞌ na Jesús: ―Tatáꞌ a ulal abal anchanꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Kʼal yán xataꞌ ti walbiyat kʼal nin okʼlékiltsik an páleꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Konyat tám juní kʼal na Pilato: ―¿Yabxeꞌ neꞌech ki tókʼon? Ka achʼaꞌ xan ti exom ti walbiyaltsik, in ulaltsik ke yán xataꞌ a tʼajámal. ");
INSERT INTO husNT2005_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Por nibal anchanꞌ yab tókʼon na Jesús ani labandhájich tokot na Pilato. ");
INSERT INTO husNT2005_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Echʼekʼi tam u ajíbnáb an paskwa, na Pilato in walkál jun i wikʼnél xi ka kontsin kʼal an atiklábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Tam ti jachanꞌ i kʼij, taꞌ ti balidh ban wikʼaxteꞌ jun i inik xin bij ta Barrabás xi wikʼnék junax kʼal nin kidhtaltsik abal chemdhaxnéktsik tam tin péjeyám i awiltalábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Junkun tám an atiklábtsik abal kin kontsi na Pilato kin walkaꞌ jun i wikʼnél jelt xan ti echʼekʼi in ujnámal in tʼajál. ");
INSERT INTO husNT2005_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Tókʼoyattsik enchéꞌ kʼal na Pilato: ―¿A léꞌtsikxeꞌ tu walkantsi an tin Pulek Takʼíxal an judíotsik? ");
INSERT INTO husNT2005_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Konyattsik anchanꞌ kʼal na Pilato kom in choꞌób alwaꞌ ke yab u leꞌnáb ka chuꞌtat na Jesús kʼal nin okʼlékiltsik an páleꞌtsik ani jaxtám ti pidhnats na Jesús abal ka chemdhá. ");
INSERT INTO husNT2005_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Por nin okʼlékiltsik an páleꞌtsik, in nixoknaꞌ an atiklábtsik kin konoy ka walká na Barrabás. ");
INSERT INTO husNT2005_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Konyattsik tám juní enchéꞌ kʼal na Pilato: ―¿Ani jantʼéy a léꞌ ku tʼajtsi xa bijyaltsik tin Pulek Takʼíxal an judíotsik? ");
INSERT INTO husNT2005_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Jajáꞌtsik tókʼon kawidh ani in ulutsik enchéꞌ: ―¡Ka chemdhaꞌ pajkʼidh ban peltsidh teꞌ! ");
INSERT INTO husNT2005_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Konyattsik tám enchéꞌ kʼal na Pilato: ―¿Jantʼom walastaláb in tʼajám? Por jajáꞌtsik in óntsi kin ulu más kawidh enchéꞌ: ―¡Ka chemdhaꞌ pajkʼidh ban peltsidh teꞌ! ");
INSERT INTO husNT2005_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Kom na Pilato in léꞌ ka jilkʼon alwaꞌ kʼal an atiklábtsik, in walkaꞌ na Barrabás. In abnaꞌ tám ka lekbayat yáníl na Jesús ani tayíl in pidhnaꞌich tám abal ka chemdhá pajkʼidh ban peltsidh teꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Júná tám na Jesús kʼal an soldadotsik bin kuxtálil an atá xon tu tʼajnal an lújundhaxtaláb ani kanyat ka junkun tajaꞌ ejtal xi kʼeꞌet an soldadotsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Xeketliyat tám na Jesús kʼal jun i kʼudhkʼum xi tʼunuyich tʼajat kʼal in chákníꞌ ani kʼwajbantsat bin ókʼ ti kwetsotsól dhipadh kʼídh. ");
INSERT INTO husNT2005_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Tujey tám ti labídhnáb enchéꞌ na Jesús: ―¡Ki kʼwajay kʼijidh, Pulek Takʼíxal an judíotsik! ");
INSERT INTO husNT2005_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","U tʼoxyáb bin ókʼ kʼal jun i teꞌ, u tubkayáb ani u tudhéltsik tám tin tamét. ");
INSERT INTO husNT2005_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Tam ti okʼontsik kin ubátʼnaꞌ ani kin labídhnaꞌ, in wékʼontsíchtsik tám an ti chak kʼudhkʼum, kʼwajbantsat xi Jajáꞌ nin kʼudhkʼúmil ani kaldhájich tám abal ka júná ka chemdhá pajkʼidh ban peltsidh teꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Taman ti bél jun i inik xin bij Simón, xu takʼnal ban chabál Sirene, nin tátaꞌ na Alejandro ani na Rufo. Jajáꞌ u witsélich bin ale ani tam tu watʼelich tajaꞌ, tʼajtsin ti chápláb kʼal an soldadotsik abal kin kitnantsi an ti peltsidh teꞌ xin neꞌdhál na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Júná tám na Jesús ban chabál xu bijyáb Gólgota. Ti tének káw, Gólgota, in léꞌ kin ulu: “In chabálil in beklék in ókʼ i chemélom inik.” ");
INSERT INTO husNT2005_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Pidhan na Jesús ti yajtsik uxnél xukʼudh kʼal i tsʼaꞌiktaláb xu bijyáb mirra, por yab in leꞌnaꞌ kin uchʼaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Tam ti pajkʼiyatich ban peltsidh teꞌ, wélchíxnantsat an tin kʼudhkʼúmil na Jesús kʼal an soldadotsik, por yab anikʼi, okʼox ubátʼintsik abal kin chuꞌu xantʼéy kin lujuy kin átaꞌ juntsik ti éb. ");
INSERT INTO husNT2005_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Beléju i dhajaw tam ti na Jesús pajkʼiyat ban peltsidh teꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Kʼwajbá bin ókʼ an peltsidh teꞌ jun i dhuslab xin ulal xantʼókʼi tin kwenta ti chemdhá. Enchéꞌ ti kʼwajat dhutsadh: “Jechéꞌ jaꞌich nin Pulek Takʼíxal an judíotsik.” ");
INSERT INTO husNT2005_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Pajkʼiyattsik jeye ba peltsidh teꞌ junax kʼal na Jesús cháb i kwéꞌtsik, jún tin eját ani jún tin kʼwatab. ");
INSERT INTO husNT2005_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Anchanꞌ ti támun abal ka tʼájan xan ti kʼwajat dhutsadh enchéꞌ ban Tʼokat Dhuslab: “Ájin jeye jelti max i walablom, jelti xi chemechtsik junax kʼal Jajáꞌ.” ");
INSERT INTO husNT2005_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Odhbijyat kʼal xu watʼeltsik tajaꞌ tin tamét, in wíwókʼliyaltsik nin ókʼ ani in ulaltsik enchéꞌ: ―Tatáꞌ, xa ejtowal ka paku an pulek atá xon tu kʼakʼnáb na Dios ani neꞌech ka kubaꞌ juní ti óx a kʼítsá, ");
INSERT INTO husNT2005_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","ka loꞌo xoꞌ tabáꞌ ani ki paꞌay ban peltsidh teꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Táꞌ jeye ti kʼwajat nin okʼlékiltsik an páleꞌtsik ani an okʼtsixtsik xin wilál nin takʼixtal na Dios ti labídhnax ani u útsáxtsik enchéꞌ: ―In loꞌómal kʼeꞌettsik ani xoꞌ Jajáꞌ yab in ejtowal kin loꞌo tinbáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Max aniꞌ lejtal Jajáꞌich nu Kristo, nin Pulek Takʼíxal an israelitatsik, ka paꞌay xoꞌ ban peltsidh teꞌ ani neꞌech tám ki belaꞌich. Xi taꞌ ti kʼwajattsik tin wálím kʼejtsik pajkʼidh ban peltsidh teꞌ, u odhbijixtsik jeye. ");
INSERT INTO husNT2005_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Tam ti chʼejelich a kʼítsá, jikʼwchin tin pubíl an kʼayꞌlá ani in tʼójontsi asta óx i wákal. ");
INSERT INTO husNT2005_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Tam ti óxich i wákal, na Jesús in ulu kawidh enchéꞌ: ―Eloi, Eloi, ¿lama sabaktani? ―jechéꞌ an káw in léꞌ kin ulu: Dios tu Ajátik, Dios tu Ajátik, ¿jantʼókʼi tin walbaꞌ? ");
INSERT INTO husNT2005_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Taltsik xi tajaꞌ ti kʼwajat, in achʼaꞌtsik ani in ulu enchéꞌ: ―Ka achʼaꞌ, exom in kanál na Elías, an tʼiltsix xi xeꞌchinék ti wejeꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Jún ti éb kʼale adhik kin axdhaꞌ ban jiliy uxnél jun xataꞌ jelti kwinim, in wikʼaꞌ bin tsúm jun i teꞌ, in utuntsi bin wiꞌ na Jesús abal kin juchʼu ani in ulu enchéꞌ: ―Yabich más xataꞌ ki tʼajtsi, wana ki chuꞌu max ka tsích na Elías kin paꞌbaꞌ ban peltsidh teꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Dhájan tám kawidh na Jesús ani chemech. ");
INSERT INTO husNT2005_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Támkʼi jachanꞌ, an tolow kʼudhkʼum xi taꞌ ti palat altá ban pulek atá xon tu kʼakʼnáb na Dios, xílan asta tʼekʼat ani asta chaꞌat. ");
INSERT INTO husNT2005_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","An okʼlek soldado romano xi taꞌ ti kubúl tin tamét na Jesús, tam tin chuꞌu xan ti dhájan ani chemech, in ulu enchéꞌ: ―Tsubax lejtal, jechéꞌ an inik u Chakámláb kʼal na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Táꞌ jeye ti kʼwajat i mímlábtsik ti ów telom. Jéꞌ kʼwajat taltsik nin bij: na Salomé, na María Magdalena ani na María xin koꞌol cháb in chakámil, jún in bij ta José ani xi tayíl in bij ta Jakobo. ");
INSERT INTO husNT2005_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Jechéꞌ an mímlábtsik, juniknadh ani tolmidh kʼál na Jesús tam ti kʼwajay Galilea. Taꞌ jeye ti kʼwajat más kʼeꞌet i mímlábtsik xi juniknadh kʼál na Jesús tam ti kʼale Jerusalén. ");
INSERT INTO husNT2005_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Tam ti exomich ti dhamul, tam an israelitatsik in tʼojojoyal xowaꞌ in yéntsal abal in kʼítsájil an koyóxnich, ");
INSERT INTO husNT2005_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","ulich na José xu kʼwajíl ban bitsow Arimatea. Jajáꞌ jaꞌich jeye jun i ultaláb kidhtaláb kʼal an Junkulom Awiltaláb. Jajáꞌ kʼwajat jeye in aytsím xowkʼi na Dios neꞌech ka tujéch ti takʼix ani in kubaꞌ tinbáꞌ ka ochich xon ti kʼwajat na Pilato abal kin kontsi tin tʼuꞌúl na Jesús kin joliy. ");
INSERT INTO husNT2005_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Na Pilato labandhá abal in achʼaꞌ ke jaykʼi ti chemnek na Jesús. Jaxtám tin kaniy an okʼlek soldadotsik abal kin konoy max aniꞌ lejtal ti chemnekich. ");
INSERT INTO husNT2005_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Tam ti utsan kʼal an okʼlek soldadotsik abal aniꞌ, utsanich tám na José kʼal na Pilato abal awilich kin júnaꞌ kin joliy. ");
INSERT INTO husNT2005_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","In chʼaꞌay tám na José jun i kʼudhkʼum, in paꞌbaꞌ nin tʼuꞌúl na Jesús ban peltsidh teꞌ ani in boliy kʼal an kʼudhkʼum. Kʼale tám kin kʼwajbaꞌ ba jun i jólimtaláb xi taꞌ ti kʼwajat cholkʼadh bin akan jun i tʼujub chʼén ani tolilíl tin utu jun i yejcheꞌ tʼujub abal kin paxkʼintsi kʼál tin wiꞌlébil an jólimtaláb. ");
INSERT INTO husNT2005_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Na María Magdalena ani xi jún na María, nin nánaꞌ na José, in chuꞌutsik xon ti kʼwajbantsat tin tʼuꞌúl na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Tam ti watʼéch nin kʼítsájil an koyóxnich, na Salomé, na María Magdalena ani xi jún na María nin nánaꞌ na Jakobo, in chʼaꞌaytsik i niwiytaláb abal ka kʼaletsik kin mawtsi kʼál tin tʼuꞌúl na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Dhajawe tin jidhtal kʼítsájil an semana, kʼaletsik ban jólimtaláb ani tam ti ulich tajaꞌ jaykʼi ti eblinékich na kʼítsá. ");
INSERT INTO husNT2005_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Kónóxintsik enchéꞌ: ―¿Jitaꞌ neꞌech ti ku wixkʼintsi an ti tʼujub xi kʼál ti paxkʼidh an jólimtaláb? ");
INSERT INTO husNT2005_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Por tam ti ulchichtsik, in chuꞌu abal an yejcheꞌ tʼujub xi kʼál ti paxkʼidh an jólimtaláb jaykʼi ti wixkʼintsidh. ");
INSERT INTO husNT2005_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ochichtsik tám altá ani in chuꞌu tajaꞌ buxúl tin ejáttsik jun xitaꞌ jelti kwitól inik. An kwitól inik xeketlidh kʼal jun i dhak jochʼat xeketláb ani jikʼey tʼajat an mímlábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Por utsan enchéꞌ an mímlábtsik: ―Yab ki jikʼeytsik, u choꞌóbich abal a ayaltsik na Jesús xi Nasaret, xi chemdhá pajkʼidh ban peltsidh teꞌ. Jajáꞌ ejnekich ti ít, yabich waꞌach techéꞌ. Ka telaꞌti núꞌ xon ti kʼwajbadh. ");
INSERT INTO husNT2005_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ki kʼaléchtsik ani ka utsaꞌ nin exóbaliltsik ani na Pedro: “Na Jesús neꞌech ka okxin ka kʼale Galilea ani tatáꞌtsik tayíl; tajaꞌ neꞌech ka chuꞌutsik jelt xan ti utsámal.” ");
INSERT INTO husNT2005_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Kale tám adhik an mímlábtsik ban jólimtaláb abal tokot u wipipíltsik ani u jikʼél. Nibal xataꞌ in utsaꞌtsik ni jun xitaꞌ abal u jikʼéltsik tʼajat. ");
INSERT INTO husNT2005_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Tam ti na Jesús ejech dhajawe tin jidhtal kʼítsájil an semana, okʼox in xalkʼaꞌ tinbáꞌ abal ka chuꞌtat kʼal na María Magdalena, xi káldhantsidh búk i atʼax ejattaláb. ");
INSERT INTO husNT2005_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Na María kʼale tám ani in utsaꞌ xi xeꞌchinéktsik junax kʼal na Jesús ke jajáꞌ in chuꞌúmal na Jesús. Xi xeꞌchinéktsik kʼal na Jesús, elantsik ti ukʼnal ani ti tʼeꞌpinal kʼal na María. ");
INSERT INTO husNT2005_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Tam tin achʼaꞌ ke na Jesús ejnek ti ít ani ke na María in chuꞌúm, yab in belaꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Tayíl, chuꞌtat na Jesús kʼal cháb nin exóbaliltsik tam ti neꞌech ti bél, por Jajáꞌ in jalkʼuyámal tinbáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Tam tin exlaꞌichtsik abal jaꞌich na Jesús, witsiytsik xon ti kʼwajat xi más an exóbaltsik ani in tʼiltsi ke in chuꞌúmaltsik na Jesús, por nibal jajáꞌtsik yab beltsin. ");
INSERT INTO husNT2005_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Más tayíl, na Jesús in xalkʼaꞌ tinbáꞌ abal ka chuꞌtat kʼal xi lajujún an exóbaltsik tam ti buxutsik ti kʼapul. Kʼwiyantsik tám kʼal na Jesús abal yabtsik tʼajat u belom ani yabtsik tʼajat in exbayal, kom yab in belaꞌtsik xowaꞌ tʼiltsin kʼal xin chuꞌúmaltsik ke na Jesús ejnek ti ít. ");
INSERT INTO husNT2005_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Utsantsik tám enchéꞌ kʼal na Jesús: ―Ki kʼaletsik putálkʼi tin pubíl an kʼayꞌlá ani ka tʼiltsitsik an ti alwaꞌ tʼilab ejtal an atiklábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Xitaꞌ kin belaꞌ ani ka pujan, neꞌech ka loꞌey; por xitaꞌ yab kin belaꞌ, neꞌech ka kʼale ban kʼibeltaláb. ");
INSERT INTO husNT2005_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ejtal xitaꞌ kin beltsi an tin káwintal na Dios, neꞌech kin ejto kin tʼajaꞌ jechéꞌ an exóltsik: Kʼal tin awiltal nu bij neꞌech kin ejto kin káldhantsi ti atʼax ejattalábtsik xitaꞌ kʼwajat teykómte kʼál, neꞌech ti káwtsik kʼal i ít káwintaláb ");
INSERT INTO husNT2005_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ani max yab kin chuꞌu ani kin téynaꞌ i chan o max kin uchʼaꞌ jun i itʼlab, yab xataꞌ neꞌech kin tamu. Neꞌech jeye kin kʼwajbaꞌtsik nin kʼubak ban yaꞌultsik ani neꞌech ka jeley jachanꞌ an yaꞌultsik. ");
INSERT INTO husNT2005_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Tayíl, tam ti okʼonich ti tawnábtsik, júnájich tám walkʼiꞌ an Ajátikláb ani buxkan tin eját na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Tam ti kaléch an abatwáletsik, xeꞌchin putálkʼi kin tʼilaꞌ an alwaꞌ tʼilab ani tolmiyattsik kʼal an Ajátikláb kin tʼajaꞌ i labidh labandhaxtaláb abal ka choꞌóbná ke tsubax xowaꞌ in tʼiláltsik. Anchanꞌ ka tʼájan.");
INSERT INTO husNT2005_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Yán i atiklábtsik in dhutsámal kʼal tin kwenta ejtal xowaꞌ in tʼajaꞌ an Ajátikláb techéꞌ ba ni chabálil. ");
INSERT INTO husNT2005_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Anchanꞌ tin dhutsámaltsik jelt xan tu tʼiltsinék kʼal xi chúꞌlámadhtsik asta tam ti tujey jechéꞌ xowaꞌ támnék ani tolmixnéktsik abal ka tʼilan jechéꞌ an alwaꞌ tʼilab. ");
INSERT INTO husNT2005_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Pulek chalpadh Teófilo, nanáꞌ u alꞌimay neye kʼal yantam i kʼayúmtaláb ejtal xowaꞌ támnék asta tam ti tujeykʼi ani u chalpayal abal in tomnál tu dhutsuntsi ejtal xowaꞌ in tʼajaꞌ an Ajátikláb anchanꞌ xan ti támun. ");
INSERT INTO husNT2005_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Tu dhutsuntsal jechéꞌ abal ka exlaꞌ alwaꞌ an tsubaxtaláb kʼal tin kwenta xowaꞌ i okʼtsinékich. ");
INSERT INTO husNT2005_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Tam ti na Erodes u pulek takʼix ban chabál xi Judea, taꞌ ti kʼwajat jun i páleꞌ xu bijyáb ta Sakarías, jún ti éb xu kidhtaláb bin junkunélil na Abías. Nin tomtal in bij ta Elisabet ani jajáꞌ u kidhtaláb kʼal an páleꞌ Arón. ");
INSERT INTO husNT2005_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Chablam ti éb lujattsik tʼajat tin tamét na Dios, in tʼajáltsik ejtal xowaꞌ in ulal an takʼixtaláb ani xowaꞌ in ulal ka tʼajan an Okʼóxláb. ");
INSERT INTO husNT2005_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Por yab in koꞌol i chakamtsik kom na Elisabet yab u kóꞌnal, tám juní pakdhaꞌichtsik tʼajat. ");
INSERT INTO husNT2005_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Jun i kʼij, tam ti an páleꞌtsik xon tu takʼnal jeye na Sakarías in lujuy ka tʼójontsik abal kin tʼójontsi na Dios, ");
INSERT INTO husNT2005_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","ubátʼintsik abal kin choꞌóbnaꞌ xitaꞌ neꞌech kin lujuy ka ochich ti ikbax ban pulek atá xon tu kʼakʼnáb an Okʼóxláb. Ubátʼintsik okʼox kom anchanꞌ tin ujnámaltsik in tʼajál ani na Sakarías, jaꞌich in lujuy ka ochich. ");
INSERT INTO husNT2005_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Lejat an ikob kʼwajat ti tʼaꞌíl, ejtal an atiklábtsik kʼwajat eléb ti ól. ");
INSERT INTO husNT2005_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Támkʼi jachanꞌ, na Sakarías in chuꞌu jun in tʼokat abatwálejil an Okʼóxláb xi xalkʼan kubúl tin eját xon ti kʼwajat ti tʼaꞌíl an ikob. ");
INSERT INTO husNT2005_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Tam ti na Sakarías in chuꞌu an tʼokat abatwále, laban tʼajat ani jikʼey. ");
INSERT INTO husNT2005_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Por utsan enchéꞌ kʼal an tʼokat abatwále: ―Sakarías, yab ki jikʼey, pos na Dios in achʼámalich na ólábil ani na tomtal Elisabet neꞌech kin kóꞌoy jun i chakam xi neꞌech ka bijiy ta Juan. ");
INSERT INTO husNT2005_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Tatáꞌ neꞌech tʼajat ki kʼijidhmé ani yán neꞌech ka kulbé abal waꞌchin jachanꞌ an chakam, ");
INSERT INTO husNT2005_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","pos jachanꞌ na chakámil neꞌech ka kʼwajay púlek tin tamét na Dios. Yab neꞌech kin uchʼaꞌ i yajtsik uxnél nibal i bók ani neꞌech tʼajat ka kʼwajay teykómte kʼal an Tʼokat Ejattaláb asta tam ka waꞌchinkʼi. ");
INSERT INTO husNT2005_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Neꞌech kin tʼajaꞌ ka witsiytsik ti ít ban Okʼóxláb nin Diosil, yán i atiklábtsik xu kidhtaláb kʼal na Israel. ");
INSERT INTO husNT2005_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Jechéꞌ na Juan neꞌech ka okxin xon ti neꞌech ka ulich an Ajátikláb ani neꞌech kin kóꞌoy nin ejattal ani an chápláb jelti xin kóꞌoy an tʼiltsix Elías. Neꞌech kin tʼajaꞌ ka pákwlántsíxin an tátaꞌlábtsik kʼal nin chakámiltsik ani abal kin lujkúchtsik jeye nin chalab xi yabtsik u tʼajax ti kʼij. Anchanꞌ, neꞌech tám ka kʼwajách tʼojojodh an atiklábtsik abal kin bachʼu an Ajátikláb. ");
INSERT INTO husNT2005_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Na Sakarías in konoy enchéꞌ an tʼokat abatwále: ―¿Janti neꞌech ku ejto ku choꞌóbnaꞌ max tsubax jechéꞌ? Pos nanáꞌ in yejchelich ani nu tomtal púlekich jeye tʼajat. ");
INSERT INTO husNT2005_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Tókʼoyat enchéꞌ kʼal an tʼokat abatwále: ―Nanáꞌ u bij Gabriel ani u tʼójontsal a Dios, Jajáꞌ tin abámal tu tawnaꞌ ani tu óltsi jechéꞌ an ti alwaꞌ tʼilab. ");
INSERT INTO husNT2005_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Por xoꞌ, kom yab a belaꞌ xowaꞌ tu utsaꞌ, neꞌech ki móꞌbé ani yab neꞌech ka ejto ta káw asta ka waꞌchin na chakámil. Jechéꞌ neꞌech ka támun, tam kin bajaw an kʼij. ");
INSERT INTO husNT2005_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Lejat kʼwajat ti támnal jechéꞌ, an atiklábtsik kʼwajat eléb in aytsal na Sakarías, u labnalichtsik abal owéch tʼajat ani yab u kalel ban pulek atá xon tu kʼakʼnáb na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Tam ti kale na Sakarías, yabich in ejtowal kin tawnaꞌ an atiklábtsik, tawnaxin kʼal in kʼubakkʼi abal móꞌbédhats. An atiklábtsik in choꞌóbná tám abal na Sakarías in chuꞌúmal jun i xalkʼantsixtaláb ban pulek atá xon tu kʼakʼnáb na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Tam ti kidhéch an kʼij ti tʼójontsix, na Sakarías kʼale tin kʼimáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Más tayíl, nin tomtal Elisabet jilkʼon kóꞌodh ani bóꞌ a íchʼ yab kale tin kʼimáꞌ. Jajáꞌ in ulal enchéꞌ tin itsích: ");
INSERT INTO husNT2005_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“An Okʼóxláb tin tʼajtsám jechéꞌ abal yabich ti kin tidhebédhaꞌ an atiklábtsik.” ");
INSERT INTO husNT2005_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Tam tin akaklábich a íchʼ ti kʼwajat kóꞌodh na Elisabet, aban kʼal na Dios an tʼokat abatwále Gabriel ba jun i bitsow xi kʼwajat Galilea xu bijyáb Nasaret ");
INSERT INTO husNT2005_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","abal kin chaꞌbiy jun i tsidhan xin bij ta María. Jechéꞌ an tsidhan, kʼwajatich konodh abal ka tomikná kʼal jun i inik xin bij José. Jechéꞌ an inik u kidhtaláb kʼal an pulek takʼix Dabid. ");
INSERT INTO husNT2005_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","An tʼokat abatwále ochich xon ti kʼwajat na María ani in ulu enchéꞌ: ―¡María, tu chapnédhál, xi kʼanidháb tʼajat kʼal an Okʼóxláb! An Okʼóxláb kʼwajat kʼal tatáꞌ ani ti lábtʼajámal más ké xi kʼeꞌet an mímlábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Por tam ti na María in chuꞌu an tʼokat abatwále, laban tʼajat kʼal xowaꞌ in achʼaꞌ utsan ani u chalpax xantʼókʼi ti chapnédhá anchanꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Utsan tám enchéꞌ kʼal an tʼokat abatwále: ―María, yab ki jikʼey, pos i chuꞌtat kʼal na Dios ke alwaꞌ ka bachʼu nin alwaꞌtal. ");
INSERT INTO husNT2005_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Xoꞌ neꞌech ki jilkʼon kóꞌodh, neꞌech ka waꞌchiy jun i chakam kwitól ani neꞌech ka bijiy ta Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Jajáꞌ neꞌech ka kʼwajay ultaláb tʼajat, neꞌech ka bijyat tin Chakámil a Dios xi púlek tʼajat ani neꞌech ka kʼwajbá kʼal na Dios ti Pulek Takʼix jelti nin wejeꞌ pakélil Dabid, ");
INSERT INTO husNT2005_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","neꞌech kin takʼiy malilíl i kʼij nin kidhtaltsik na Israel ani nin takʼixtal yab jaykʼi neꞌech kin kóꞌoy in okʼontal. ");
INSERT INTO husNT2005_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Na María in konoy enchéꞌ an tʼokat abatwále: ―¿Jantich tám ti neꞌech ku kóꞌoy i chakam ani nanáꞌ yab jaykʼi in junkunék kʼal ni jun i inik? ");
INSERT INTO husNT2005_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Tókʼoyat enchéꞌ kʼal an tʼokat abatwále: ―An Tʼokat Ejattaláb neꞌech ka ulich ba tatáꞌ ani na Dios xi púlek tʼajat, neꞌech ti ki paxkʼiy kʼal nin cháp jelt xan tu paxkʼix jun i chalam. Jaxtám, an chakam kwitól xi neꞌech ka kóꞌoy tʼokat Jaꞌ tʼajat ani neꞌech ka bijyat tin Chakámil a Dios. ");
INSERT INTO husNT2005_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Na exlowál Elisabet, maske púlekich tʼajat, neꞌech jeye kin waꞌchiy jun i chakam kwitól. Xu usnal ke yab u kóꞌnal, xoꞌ in koꞌolich akak a íchʼ ti kʼwajat kóꞌodh. ");
INSERT INTO husNT2005_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Abal na Dios yab waꞌach ni jun xataꞌ xi yab neꞌech kin ejto kin tʼajaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","In ulu tám enchéꞌ na María: ―Nanáꞌ tin jolíbal an Okʼóxláb, ke Jajáꞌ kin tʼajaꞌ kʼal nanáꞌ jelt xan tin utsál. Tam ti okʼonich kin ulu jechéꞌ, an tʼokat abatwále kʼaléch tám. ");
INSERT INTO husNT2005_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Tam ti jachanꞌ i kʼij, na María kʼale jikʼatkʼi ba jun i bitsow xi kʼwajat ban chʼénlom xi Judea. ");
INSERT INTO husNT2005_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Tam ti ulich ba jachanꞌ an bitsow, ochich bin kʼimáꞌ na Sakarías ani in chapnédhaꞌ na Elisabet. ");
INSERT INTO husNT2005_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Tam ti na Elisabet in achʼaꞌ nin chapnédhaxtal na María, an chakam xi kʼwajat in kitkóm, yoyon ani na Elisabet in bachʼu nin cháp an Tʼokat Ejattaláb. ");
INSERT INTO husNT2005_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ani kawidh tʼajat tin ulu enchéꞌ: ―Na Dios ti lábtʼajámal más ké xi ejtal an mímlábtsik ani in lábtʼajámal an chakam xa kitkóm. ");
INSERT INTO husNT2005_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Jitaꞌ u éy nanáꞌ abal ka tsích ti kin álnaꞌ nin nánaꞌ nu Ajátik? ");
INSERT INTO husNT2005_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Pos tam tu achʼpiykʼi na chapnédhomtal, an chakam xi kʼwajat u kitkóm, yoyon kʼal i kulbéxnich. ");
INSERT INTO husNT2005_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Kʼijidh tʼajat abal a belaꞌ xowaꞌ i utsan, pos neꞌech ka tʼájan jelt xan ti utsámal an Okʼóxláb. ");
INSERT INTO husNT2005_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","In ulu tám enchéꞌ na María: Nanáꞌ u kʼakʼnál an Okʼóxláb ");
INSERT INTO husNT2005_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ani nu ejattal u kʼijidhmél kʼal na Dios nu Loꞌóxil. ");
INSERT INTO husNT2005_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Abal na Dios in chuꞌu ke nanáꞌ jaꞌich jun in chʼojontál jolíbal ani xoꞌ, ejtal an atiklábtsik xi neꞌech ka waꞌchin techéꞌ ti kʼayꞌlá, neꞌech kin ulutsik ke nanáꞌ in lábtʼajadh. ");
INSERT INTO husNT2005_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Pos na Dios xi ejtal in ejtowal kin tʼajaꞌ, tin tʼajtsámal yán xowaꞌ pakdhaꞌ. Jajáꞌ, tʼokat Jaꞌ tʼajat. ");
INSERT INTO husNT2005_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Na Dios echʼekʼi neꞌech kin kóꞌontsi ti yajnantsixtaláb ejtal xitaꞌ kʼál tu kʼakʼnáb. ");
INSERT INTO husNT2005_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Yán xataꞌ pakdhaꞌ in tʼajámal kʼal nin cháp; in pakwtsámal tin chalab xin tʼekʼáltsik tinbáꞌ abal yab kin ejto kin tʼajaꞌ xowaꞌ in chalpayámal. ");
INSERT INTO husNT2005_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","In wékʼontsámal tin awiltal an pakdhaꞌ takʼix ani in tʼekʼbámal xi yabtsik in tʼekʼál tinbáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Xu kʼaꞌíltsik, in pidhámal kin kóꞌoy xowaꞌkich xi alwaꞌ ani xi tumínladhtsik, in ajámal ka kʼale mapats kʼubak. ");
INSERT INTO husNT2005_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","In tolmiyámal nin tʼójontsixil, xi jaꞌich an israelitatsik ani yab in ukʼtsámal kin kóꞌontsi ti yajnantsixtaláb; ");
INSERT INTO husNT2005_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","anchanꞌ tin utsámal ni wejeꞌ pakélil Abraham ani ejtal nin kidhtaltsik abal malilíl i kʼij. ");
INSERT INTO husNT2005_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Na María kʼwajay tajaꞌ kʼal na Elisabet óx a íchʼ xónaꞌ ani más tayíl witsích tám juní tin kʼimáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Tam tin bajúch an kʼij xowkʼi na Elisabet ti neꞌech kin waꞌchiy an chakam, in waꞌchiy jun i chakam kwitól. ");
INSERT INTO husNT2005_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Nin at kʼimádhtsik ani nin jaꞌúbtsik, kulbé tʼajat tam tin achʼaꞌtsik ke na Elisabet kóꞌontsidh tʼajat ti yajnantsixtaláb kʼal an Okʼóxláb. ");
INSERT INTO husNT2005_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Tam tin kidhbay waxik a kʼítsá ti waꞌchinék an chakam, in júnaꞌtsik abal ka kʼwajbantsat ti exól bin tʼuꞌúl jelt xan ti usnék kin tʼajaꞌ na Abraham. U leꞌnábwiꞌik ka bijyat ta Sakarías jelti nin tátaꞌ, ");
INSERT INTO husNT2005_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","por nin nánaꞌ in ulu enchéꞌ: ―Yabaꞌ. Koꞌol ka bijyat ta Juan. ");
INSERT INTO husNT2005_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Tókʼoyat tám enchéꞌ: ―¿Jantʼókʼi? Yab waꞌach ni jun xitaꞌ a kidhtal xi anchanꞌ in bij. ");
INSERT INTO husNT2005_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Konyat tám kʼal i kʼubaklekkʼi nin tátaꞌ an chakam abal ka choꞌóbná xowaꞌ bijláb in léꞌ kin chuꞌu ka kʼwajbantsat nin chakámil. ");
INSERT INTO husNT2005_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Nin tátaꞌ an chakam, in konoy jun i okchaꞌ ani in dhutsaꞌ tajaꞌ enchéꞌ: “Jajáꞌ neꞌech ka bijyat ta Juan.” Ani ejtaltsik laban. ");
INSERT INTO husNT2005_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Támkʼi jachanꞌ, in ejtóch tám juní ti káw na Sakarías ani tujey kin pubédhantsi tin bij na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ejtal nin at kʼimádhtsik laban tam tin chuꞌu jechéꞌ ani putálkʼi ba jachanꞌ an chʼenadh chabál xi Judea, u tʼilnal xowaꞌ támnék. ");
INSERT INTO husNT2005_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ejtal xin achʼáltsik jechéꞌ u chalpaxtsik ani u kónóxtsik jún ani jún enchéꞌ: ―¿Jantʼéy awil neꞌech kin tʼajaꞌ jachanꞌ an chakam kwitól tam ka pubey? Pos jechéꞌ an chakam kwitól, tsubax lejtal ti teykómte kʼal in cháp an Okʼóxláb. ");
INSERT INTO husNT2005_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Na Sakarías, nin tátaꞌ an chakam, teykómte kʼal nin cháp an Tʼokat Ejattaláb, ijtsin kin ulu enchéꞌ: ");
INSERT INTO husNT2005_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Ki kʼakʼnaꞌ an Okʼóxláb, nin Diosil na Israel, abal tsiꞌnek techéꞌ ba nin bitsówil abal ti ku loꞌo. ");
INSERT INTO husNT2005_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Tu pidhámal jun i pulek Loꞌóxil, xi tál bin kidhtal na Dabid, nin tʼójontsixil. ");
INSERT INTO husNT2005_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Anchanꞌ tin ulúmal kʼal nin tʼokat tʼiltsíxiltsik asta ti wejeꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","In ulúmal ke neꞌech ti ku loꞌo kʼal xi tu péjeyal ani kʼal xi tu atʼál, ");
INSERT INTO husNT2005_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","ke neꞌech kin yajnantsi ni wejeꞌ pakéliltsik ani ke yab neꞌech kin ukʼtsi nin tʼokat lejkintalábil. ");
INSERT INTO husNT2005_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Jechéꞌ jaꞌich xowaꞌ na Dios in lej tsubax utsámal ni wejeꞌ pakélil Abraham: ");
INSERT INTO husNT2005_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ke neꞌech ti ku loꞌo kʼal xi tu péjeyaltsik abal ki tʼójontsích kʼal ni jun i jíkʼib ");
INSERT INTO husNT2005_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ani ku kʼwajay lujat ani tʼokat tin tamét Jajáꞌ, tsudhey ka tsudhey putál i kʼij asta xon talat tu ejat. ");
INSERT INTO husNT2005_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ani tatáꞌ teye, chakam, neꞌech ki bijyat tin tʼiltsíxil a Dios xi púlek tʼajat, pos neꞌech ki okxin ka tʼojojontsi tin bélil an Ajátikláb ");
INSERT INTO husNT2005_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","abal kin pidhaꞌ kin choꞌóbnaꞌ nin bitsówil ke nin walastalábiltsik neꞌech ka pakwlantsat ani anchanꞌ neꞌech kin bachʼúchtsik an loꞌeltaláb. ");
INSERT INTO husNT2005_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Kom tu kʼanidhál ani tu yajnantsal ni Diosil, neꞌech ti ku abtsi jun xitaꞌ xi túꞌ walkʼiꞌ abal ti ku tolmiy. Jajáꞌ in junwal jelt in tajáx jun i ít kʼij xin wékʼoyal i jikʼwaxtaláb. ");
INSERT INTO husNT2005_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Jajáꞌ neꞌech kin tajbay xi xeꞌechtsik ban jikʼwaxtaláb, xi neꞌechtsikwiꞌik ban kʼibeltaláb tam ka chemech ani neꞌech ti ku tajbantsi ku beley ban bél xi kʼijidh. ");
INSERT INTO husNT2005_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","An chakam kwitól u pubel ani nin ejattal más u chapniꞌbél, kʼwajay ban chabál xon ti yab kʼwajtsidh asta tam tin bajaw an kʼij kin pidhnaꞌ tinbáꞌ ka exlá kʼal an atiklábtsik xi Israel. ");
INSERT INTO husNT2005_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Tam ti jachanꞌ i kʼij, an lej pulek takʼix xu bijyáb ta Awgusto in ulu abal ka ajyat putálkʼi ejtal an atiklábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Jechéꞌ an jidhtal ajumtaláb, tʼajan tam ti na Sirenio kʼwajat ti pulek awiltaláb ban chabál xi Siria. ");
INSERT INTO husNT2005_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ejtaltsik koꞌol ka witsiy bin bitsówil abal ka ájin tajaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Jaxtám, na José kale Nasaret, an bitsow xi kʼwajat Galilea ani kʼale ban chabál xi Judea ban bitsow xu bijyáb Belén xon tu chakam an pulek takʼix Dabid, kom na José u kidhtaláb kʼal na Dabid. ");
INSERT INTO husNT2005_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Kʼale Belén abal ka ájin tajaꞌ junax kʼal na María, xi konodhich tin koꞌol abal ka tomkin kʼál ani kʼwajatich kóꞌodh. ");
INSERT INTO husNT2005_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Lejat kʼwajattsik Belén, in bajaw xowkʼi na María ti neꞌech kin waꞌchiy an chakam. ");
INSERT INTO husNT2005_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Tajaꞌ tin waꞌchiy nin jidhtal chakámil, in dhantsiy, in boliy kʼal i kʼudhkʼum ani in kwachbaꞌ xon tu mujtsinal tin kʼapwál an koꞌnéltsik, pos yab in elaꞌtsik ejtidh xon ti ka koyóch ba jachanꞌ an atá xon tu koynáb. ");
INSERT INTO husNT2005_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Kʼunat Belén, taꞌ ti kʼwajat cháb óx i belkol koꞌnéltsik xin beletnál nin koꞌwáltsik tam akal. ");
INSERT INTO husNT2005_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Jun jikʼtowále tin chuꞌutsik jun in tʼokat abatwálejil an Okʼóxláb, nin labidh tʼokát an Okʼóxláb tajkʼan malilíl xon ti kʼwajattsik ani jikʼeytsik tʼajat. ");
INSERT INTO husNT2005_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Por utsantsik enchéꞌ kʼal an tʼokat abatwále: ―Yab ki jikʼeytsik, pos tu tsiꞌdhantsaltsik jun i alwaꞌ tʼilab ani yán neꞌech ka kulbé kʼal jechéꞌ tin kwenta: ");
INSERT INTO husNT2005_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","ke xoꞌ waꞌchinich ti chakam bin bitsówil na Dabid jun i Loꞌox abal tatáꞌtsik, jaꞌich na Kristo an Ajátikláb. ");
INSERT INTO husNT2005_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ti exól, neꞌech ka elaꞌtsik an chakam dhantsidh, bolilidh kʼal i kʼudhkʼum ani kwachat xon tu mujtsinal tin kʼapwál an koꞌnéltsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Támkʼi jachanꞌ, xalkʼan tin wál an tʼokat abatwále yán i tʼokat abatwáletsik xi tál walkʼiꞌ, in pubédhantsaltsik tin bij na Dios ani in ulaltsik enchéꞌ: ");
INSERT INTO husNT2005_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Kin kóꞌoy an labidh tʼokattaláb na Dios túꞌ walkʼiꞌ ani ban chabál, kin kóꞌoy an kʼijidhtaláb an iniktsik xu kʼanidhábtsik kʼal na Dios! ");
INSERT INTO husNT2005_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Tam ti an tʼokat abatwáletsik kʼadhíchtsik juní walkʼiꞌ, an belkol koꞌnéltsik tujey ti útsáx jún ani jún enchéꞌ: ―Pos wana pé asta Belén abal ki chuꞌu jechéꞌ xowaꞌ támnék, xi tu óltsích an Okʼóxláb. ");
INSERT INTO husNT2005_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Kʼaletsik jikʼat ani in elaꞌ na María ani na José ani an chakam xi taꞌ ti kwachat xon tu mujtsinal tin kʼapwál an koꞌnéltsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Tam tin chuꞌutsik, in tʼilaꞌtsik xantʼéy usnéktsik kʼal an tʼokat abatwále kʼal tin kwenta jechéꞌ an chakam. ");
INSERT INTO husNT2005_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ejtal xi kʼál ti achʼan xowaꞌ in ulutsik, labantsik kʼal xowaꞌ in achʼaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Por na María in chalpóm tokot tin itsích ejtal jechéꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Más tayíl, an belkol koꞌnéltsik kʼaléchtsik tám, por in pubédhantsal ani in kʼakʼnantsal tin bij na Dios kʼal tin kwenta xowaꞌ in achʼaꞌtsik ani in chuꞌutsik, abal anchanꞌ ti támnék jelt xan ti usnéktsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Tam ti kidhey waxik a kʼítsá ti waꞌchinék an chakam, tʼajtsin ti exól bin tʼuꞌúl jelt xan ti usnék na Abraham ani bijyat ta Jesús. Jachanꞌ an bijláb, jaꞌich xi usnék na María kʼal an tʼokat abatwále tam ti jajáꞌ yabél kóꞌodh. ");
INSERT INTO husNT2005_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Tam ti kidhey an kʼij xowkʼi jajáꞌtsik yejat kin tʼoko tinbáꞌ jelt xan tin ulal nin takʼixtal na Dios xin jilám dhutsadh na Moisés, in júnaꞌtsik an chakam ban bitsow Jerusalén abal kin utu ban Okʼóxláb. ");
INSERT INTO husNT2005_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","In tʼajaꞌtsik anchanꞌ kom bin takʼixtal an Okʼóxláb kʼwajat dhutsadh enchéꞌ: “Ejtal an tsʼitsik kwitól xi jidhtal ka waꞌchin ti chakam, yejat ka pidhná abal an Okʼóxláb.” ");
INSERT INTO husNT2005_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Kʼalnektsik jeye abal kin pikbaꞌ cháb i bókʼ o cháb i tsʼitsik kukuꞌ jelt xan tin ulal nin takʼixtal an Okʼóxláb. ");
INSERT INTO husNT2005_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Tam ti jachanꞌ i kʼij, taꞌ ti kʼwajat Jerusalén jun i inik xu bijyáb Simeón. Jajáꞌ jaꞌich jun i lujat inik xin kʼakʼnál na Dios ani in aytsím jeye ka loꞌwat an israelitatsik. Jajáꞌ teykómte tʼajat kʼal an Tʼokat Ejattaláb ");
INSERT INTO husNT2005_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ani usnék kʼal an Tʼokat Ejattaláb abal yab neꞌech ka chemech max yab kin chuꞌu okʼox an Kristo xi neꞌech ka aban kʼal an Okʼóxláb. ");
INSERT INTO husNT2005_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Jechéꞌ na Simeón kʼale ban pulek atá xon tu kʼakʼnáb na Dios ijtsidh kʼal an Tʼokat Ejattaláb. Tam ti na Jesús júná kʼal nin tátaꞌtsik ban pulek atá xon tu kʼakʼnáb na Dios abal ka tʼajtsin xan tin ulal an takʼixtaláb ke yejat ka tʼajtsin, ");
INSERT INTO husNT2005_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","na Simeón in mulukʼnaꞌ an chakam ani in pubédhantsi tin bij na Dios enchéꞌ: ");
INSERT INTO husNT2005_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Okʼóxláb, awilich ti kin walkaꞌ kin chemech tsububudh u itsích abal a tʼajaꞌich jelt xan ta utsámal na tʼójontsixil. ");
INSERT INTO husNT2005_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Pos xoꞌ u chuꞌúch kʼal nanáꞌ tʼajat u wal an Loꞌox ");
INSERT INTO husNT2005_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","xa kʼwajbámal tin tamét ejtal an atiklábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Jajáꞌ jaꞌich jelti an tajaxtaláb xi neꞌech kin tajbay ejtalkʼi an bitsowtsik xi yab u israelitatsik ani neꞌech kin pidhaꞌ ti labidh tʼokattaláb an israelitatsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Nin tátaꞌ ani nin nánaꞌ na Jesús labantsik kʼal xowaꞌ in achʼál in ulal na Simeón kʼal tin kwenta an chakam. ");
INSERT INTO husNT2005_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Lábtʼajantsik kʼal na Simeón ani utsan enchéꞌ na María nin nánaꞌ na Jesús: ―Ka achʼaꞌ, jechéꞌ an chakam kʼwajbá abal kin tʼajaꞌ ke yán i israelitatsik ka kʼale ban kʼibeltaláb o ka loꞌeytsik. Jajáꞌ jaꞌich jun i exól xi neꞌech ka pojká kʼal yán xitaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Anchanꞌ neꞌech ka choꞌóbná xowaꞌ in chalpayal jun xitaꞌ tin itsích. Por abal tatáꞌ, ejtal jechéꞌ neꞌech kin junu jelti max exom ta tʼidhbantsáb ta ejattal kʼal jun i machét. ");
INSERT INTO husNT2005_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Táꞌ jeye ti kʼwajat jun i mímláb púlekich tʼajat xu tʼiltsix jeye, jajáꞌ in bij ta Ana ani u chakámláb kʼal na Fanuel, xu kidhtaláb kʼal na Aser. Jechéꞌ an mímláb, tsidhan tʼajat ti tomkinék ani tokot búk i tamub kʼwajay kʼal nin tomkíl. ");
INSERT INTO husNT2005_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Jajáꞌ jaꞌich xoꞌ jun i chemtsidh mímláb xin koꞌolich cheꞌ inik kʼal chéꞌ i tamub ti kwetém. Echʼekʼi kʼwajat ban pulek atá xon tu kʼakʼnáb na Dios, akal i kʼij in tʼójontsal an Okʼóxláb kʼal i kʼílixnich ani kʼal i óláb. ");
INSERT INTO husNT2005_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Na Ana ulich jeye támkʼi jachanꞌ, in tuju kin pidhaꞌ ti jalbintsixtaláb na Dios ani kin tʼiltsi an atiklábtsik kʼal tin kwenta jachanꞌ an chakam xu bijyáb ta Jesús. Jachanꞌ an atiklábtsik xu kʼwajíl Jerusalén, jaꞌich xin aytsím ka loꞌwat abal yabich más ka kóꞌyattsik takʼnél kʼal i kʼeꞌet bitsow. ");
INSERT INTO husNT2005_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Tam ti na José ani na María in tʼajaꞌichtsik ejtal xowaꞌ in ulal nin takʼixtal an Okʼóxláb, witsiytsik Nasaret, an bitsow xu takʼnal ban chabál xi Galilea. ");
INSERT INTO husNT2005_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Tsudhél u tajkʼanal an chakam u pubel, u likel ani más u chalpadhmél. Ani echʼekʼi in bachʼwal nin alwaꞌtal na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Tamub ti tamub nin tátaꞌtsik na Jesús u kʼalel Jerusalén abal kin ajíbnaꞌ an paskwa, an ajib xin ajíbnál an judíotsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Tam ti na Jesús in kidhbay lajucháb i tamub, kʼaletsik ejtal ti éb Jerusalén, jelt xan tin ujnámalichtsik in tʼajál tam kin bajaw an ajib. ");
INSERT INTO husNT2005_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Tam ti okʼonich an ajib, kaletsik tám abal ka witsích tin kʼimáꞌ, por na Jesús jilkʼonék Jerusalén ani nin tátaꞌtsik yab in choꞌób max Jajáꞌ jilkʼonék tajaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Jajáꞌtsik in chalpay ke na Jesús taꞌ jeye ti tál bin yaníl an atiklábtsik ani anchanꞌ ti beleytsik putál a kʼítsá; por tam ti alyat na Jesús bin kidhtaltsik ani bin exlowáltsik, yab elan. ");
INSERT INTO husNT2005_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Kom yab elan, witsiytsik tám Jerusalén nin tátaꞌtsik abal kin aliy tajaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Xeꞌchintsik kin aliy ani tin óxláb a kʼítsá in elaꞌ ban pulek atá xon tu kʼakʼnáb na Dios. Tajaꞌ ti buxúl junax kʼal an okʼtsixtsik xin wilál nin takʼixtal na Dios xin jilám dhutsadh na Moisés. In ochʼówiyal xantʼéy in tʼiláltsik ani in konyal ka wiltsin xowaꞌ Jajáꞌ in léꞌ kin exbay. ");
INSERT INTO husNT2005_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ejtaltsik xin achʼál u labnal abal in chuꞌtal chalpadh tʼajat na Jesús ani abal in tókʼoyal jeye alwaꞌ xowaꞌ u konyáb kʼal jajáꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Tam ti chuꞌtat kʼal nin tátaꞌtsik, labantsik ani utsan enchéꞌ kʼal nin nánaꞌ: ―Chakam, ¿jantʼókʼi tu tʼajtsámal anchanꞌ? Na tátaꞌ ani nanáꞌ neye u kʼwajinekich tʼajat tu álim ani tu chalpax abal i kʼibchonék. ");
INSERT INTO husNT2005_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Tókʼoyat tám enchéꞌ kʼal na Jesús: ―¿Jantʼókʼi tin ayaltsik? ¿Yabxeꞌ a choꞌóbtsik ke yejat kin kʼwajay techéꞌ abal ku tʼajaꞌ xowaꞌ in jilám ka tʼajan nu Tátaꞌ? ");
INSERT INTO husNT2005_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Por nin tátaꞌtsik yab in exbay xantʼókʼi ti tókʼoyattsik anchanꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Junaxich tám ti witsiy ban bitsow Nasaret. Tajaꞌ ti kʼwajay ani in tʼajál ejtal xowaꞌ u usnal kʼal jajáꞌtsik. Ani nin nánaꞌ echʼekʼi in chalpóm tin itsích ejtal xowaꞌ támun. ");
INSERT INTO husNT2005_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Na Jesús neꞌech u pubel ani más u chalpadhmél, in tʼajál ejtal xowaꞌ alwaꞌ tin tamét na Dios ani tin tamét an atiklábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Tam ti lajubóꞌich i tamub ti takʼix an lej pulek takʼix Tiberio, na Ponsio Pilato u pulek awiltaláb ban chabál xi Judea. Na Erodes u pulek awiltaláb ban chabál xi Galilea, nin kidháb xin bij ta Felipe, u takʼix ban chabál xi Iturea ani xi Trakonite. Na Lisanias, u pulek awiltaláb ban chabál xi Abilinia. ");
INSERT INTO husNT2005_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Na Anás ani na Kayfás, jaꞌich nu okʼlek páleꞌtsik. Tam ti jachanꞌ i kʼij, na Dios in tawnaꞌ na Juan ban chabál xon ti yab kʼwajtsidh. Jechéꞌ na Juan, jaꞌich xu chakámláb kʼal na Sakarías, ");
INSERT INTO husNT2005_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","watʼey putálkʼi an kwentsaltsik xi kʼunat ban waljaꞌ Jordán, in utsál an atiklábtsik ke yejatich kin jilaꞌtsik ti walablom ani ka pujanichtsik abal ka pakwlantsat an tin walastalábiltsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Jechéꞌ támun anchanꞌ abal ka tʼájan jelt xan tin jilámal dhutsadh an tʼiltsix Isaías enchéꞌ: Achʼat in káwintal jun xitaꞌ ban chabál xon ti yab kʼwajtsidh ani xu káw, in ulal kawidh enchéꞌ: “Ka tʼojojontsíchtsik tin bélil an Ajátikláb; ka júnaꞌichtsik jun i xeꞌchintaláb alwaꞌ abal anchanꞌ, ki kʼwajáchtsik tʼojojodh tam ka tsích an Ajátikláb. ");
INSERT INTO husNT2005_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","An chabál xi jokʼitsik neꞌech ka tsʼutsiyat, ejtal an pakdhaꞌ chʼén ani an tsʼitsik chʼén neꞌech ka lujkuwat, an bél xi kʼuchʼutsik neꞌech ka lujkuwat ani an bél xi jókʼmáx neꞌech ka lejkiyat. ");
INSERT INTO husNT2005_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Kʼal ejtal an atiklábtsik xi kʼwajat ban kʼayꞌlá ti neꞌech ka chuꞌtat an loꞌeltaláb xin pidhnál na Dios.” ");
INSERT INTO husNT2005_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Tam ti an atiklábtsik u ulel abal ka pujyat kʼal na Juan, u usnaltsik enchéꞌ kʼal na Juan: ―¡Tatáꞌtsik a junwal jelti chan! Abal a léꞌtsik ka jekʼaꞌ kʼal i pujaxtaláb nin chákub na Dios xi exomich ti kʼunel. ");
INSERT INTO husNT2005_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ki kʼwajáchtsik alwaꞌ abal ka xalkʼan ke tsubax lejtal ta jilaꞌichtsik ta walablom ani yab ka chalpaytsik ta ejattal ke neꞌech ki loꞌeytsik abalkʼi i kidhtalábtsik kʼal na Abraham; pos tu utsáltsik ke na Dios neꞌech kin ejto kin káldhaꞌ in chakámiltsik a Abraham asta ba jechéꞌ an tʼujubtsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Anchanꞌ jelt xan ti jun i inik in kwajlál ani in tsikál jun i teꞌ xi yab xataꞌ ti alwaꞌ, anchanꞌ jeye ti neꞌech kin tʼajaꞌ na Dios kʼunat i kʼij kʼal an iniktsik xi yab alwaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Konyat tám enchéꞌ kʼal an atiklábtsik: ―¿Jantʼéy yejat ki tʼajaꞌ? ");
INSERT INTO husNT2005_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Tókʼoyattsik enchéꞌ kʼal na Juan: ―Xitaꞌ in koꞌol cháb in xekét, yejat kin pidhaꞌ jún xi yab in koꞌol ani xitaꞌ in koꞌol i kʼapnél, yejat jeye kin pidhaꞌ xi yab in koꞌol. ");
INSERT INTO husNT2005_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ulich jeye cháb óx i bachʼkʼul jalbixtaláb xin léꞌ ka pujyattsik ani konyat enchéꞌ na Juan kʼal jajáꞌtsik: ―Okʼtsix, ¿jantʼéy yejat ki tʼajaꞌ? ");
INSERT INTO husNT2005_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Tókʼoyattsik enchéꞌ kʼal na Juan: ―Yab ka konoy watʼats an jalbixtaláb, tokotkʼi xowaꞌ in ulal an awiltalábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Konyat jeye kʼal cháb óx i soldadotsik enchéꞌ: ―Ani wawáꞌ, ¿jantʼéy yejat ki tʼajaꞌ? Tókʼoyattsik enchéꞌ kʼal na Juan: ―Yab ka kʼántsitsik xataꞌ ni jun xitaꞌ, nibal ka aniꞌ ólnaꞌ ni jun xitaꞌ xi yab in walám ani ki kulbétsik kʼal xowaꞌ a átál. ");
INSERT INTO husNT2005_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ejtal an atiklábtsik kʼwajat in aytsím an Kristo xi bijidh neꞌech ka tsích ani in chalpayaltsik max na Juan jaꞌchich an Kristo; ");
INSERT INTO husNT2005_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","por utsantsik ejtal enchéꞌ kʼal na Juan: ―Nanáꞌ tu pujyaltsik kʼal i jaꞌ, por taꞌ tál jun xitaꞌ xi más in koꞌol i awiltaláb ké nanáꞌ; nanáꞌ nibal elaꞌ xataꞌ u éy abal ku wiltsi tin wikʼáb nin pajab. Jajáꞌ neꞌech ti ki pujaytsik kʼal an Tʼokat Ejattaláb ani kʼal i kʼamal. ");
INSERT INTO husNT2005_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","In teykóm an pala abal kin jutsuy an trigo ani abal kin wixkʼintsích an ti amúl. Neꞌech kin junku an trigo bin wiltéꞌil, por an amúl neꞌech kin tsikaꞌ ban kʼamal xi yab jaykʼi u tepel. ");
INSERT INTO husNT2005_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Enchéꞌ ani yán más xan ti, na Juan in takʼyal ani in tʼiltsal an ti alwaꞌ tʼilab an atiklábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","In kʼwiyaꞌ jeye an pulek awiltaláb Erodes abal in tʼajámal tin tomtal na Erodías, nin tomtal nin kidháb Felipe ani kʼal tin kwenta jeye xowaꞌ yab alwaꞌ in tʼajámal. ");
INSERT INTO husNT2005_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Por na Erodes yab in tʼajaꞌ ti kʼij xowaꞌ utsan kʼal an Juan, más tokot in óntsi kin tʼajaꞌ xowaꞌ yab alwaꞌ: in baliy na Juan ban wikʼaxteꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Jun i kʼij, tam ti na Juan bél kʼwajat ti pújal an ti atiklábtsik, pujyat jeye na Jesús. Lejat na Jesús kʼwajat ti ól, jakʼpin an walkʼiꞌ, ");
INSERT INTO husNT2005_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","paꞌay an Tʼokat Ejattaláb ani buxkan tin éb Jajáꞌ. Tejwaꞌ tʼajat ti paꞌay jelti jun i kukuꞌ ani achʼatmé jun i káwintaláb túꞌ walkʼiꞌ, xu káw in ulu enchéꞌ: ―Tatáꞌ tu Chakámil ani tu kʼanidhál tʼajat. In kulbél tʼajat kʼal Tatáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","In koꞌol xónaꞌ jun inik láju i tamub tam ti na Jesús in tuju nin tʼojlábil. An atiklábtsik in chalpayal ke na Jesús u chakámláb kʼal na José. Na José u chakámláb kʼal na Elí, ");
INSERT INTO husNT2005_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","na Elí u chakámláb kʼal na Matat, na Matat u chakámláb kʼal na Lebí, na Lebí u chakámláb kʼal na Melki, na Melki u chakámláb kʼal na Jana, na Jana u chakámláb kʼal na José, ");
INSERT INTO husNT2005_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","na José u chakámláb kʼal na Matatías, na Matatías u chakámláb kʼal na Amós, na Amós u chakámláb kʼal na Naúm, na Naúm u chakámláb kʼal na Esli, na Esli, u chakámláb kʼal na Nagai, ");
INSERT INTO husNT2005_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","na Nagai u chakámláb kʼal na Mát, na Mát u chakámláb kʼal na Matatías, na Matatías u chakámláb kʼal na Semei, na Semei u chakámláb kʼal na José, na José u chakámláb kʼal na Judá, ");
INSERT INTO husNT2005_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","na Judá u chakámláb kʼal na Joana, na Joana u chakámláb kʼal na Resa, na Resa u chakámláb kʼal na Sorobabel, na Sorobabel u chakámláb kʼal na Salatiel, na Salatiel u chakámláb kʼal na Neri, ");
INSERT INTO husNT2005_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","na Neri u chakámláb kʼal na Melki, na Melki u chakámláb kʼal na Adi, na Adi u chakámláb kʼal na Kosam, na Kosam u chakámláb kʼal na Elmodam, na Elmodam u chakámláb kʼal na Er, ");
INSERT INTO husNT2005_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","na Er u chakámláb kʼal na Josué, na Josué u chakámláb kʼal na Elieser, na Elieser u chakámláb kʼal na Jorim, na Jorim u chakámláb kʼal na Matat, ");
INSERT INTO husNT2005_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","na Matat u chakámláb kʼal na Lebí, na Lebí u chakámláb kʼal na Simeón, na Simeón u chakámláb kʼal na Judá, na Judá u chakámláb kʼal na José, na José u chakámláb kʼal na Jonán, na Jonán u chakámláb kʼal na Eliakim, ");
INSERT INTO husNT2005_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","na Eliakim u chakámláb kʼal na Melea, na Melea u chakámláb kʼal na Mainán, na Mainán u chakámláb kʼal na Matata, na Matata u chakámláb kʼal na Natán, ");
INSERT INTO husNT2005_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","na Natán u chakámláb kʼal na Dabid, na Dabid u chakámláb kʼal na Isaí, na Isaí u chakámláb kʼal na Obed, na Obed u chakámláb kʼal na Bós, na Bós u chakámláb kʼal na Salmón, na Salmón u chakámláb kʼal na Násón, ");
INSERT INTO husNT2005_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","na Násón u chakámláb kʼal na Aminadab, na Aminadab u chakámláb kʼal na Aram, na Aram u chakámláb kʼal na Esrom, na Esrom u chakámláb kʼal na Fares, na Fares u chakámláb kʼal na Judá, ");
INSERT INTO husNT2005_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","na Judá u chakámláb kʼal na Jakob, na Jakob u chakámláb kʼal na Isák, na Isák u chakámláb kʼal na Abraham, na Abraham u chakámláb kʼal na Taré, na Taré u chakámláb kʼal na Nakor, ");
INSERT INTO husNT2005_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","na Nakor u chakámláb kʼal na Serug, na Serug u chakámláb kʼal na Ragaw, na Ragaw u chakámláb kʼal na Peleg, na Peleg u chakámláb kʼal na Eber, na Eber u chakámláb kʼal na Sala, ");
INSERT INTO husNT2005_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","na Sala u chakámláb kʼal na Kainán, na Kainán u chakámláb kʼal na Arfaksad, na Arfaksad u chakámláb kʼal na Sem, na Sem u chakámláb kʼal na Noé, na Noé u chakámláb kʼal na Lamek, ");
INSERT INTO husNT2005_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","na Lamek u chakámláb kʼal na Matusalén, na Matusalén u chakámláb kʼal na Enok, na Enok u chakámláb kʼal na Jared, na Jared u chakámláb kʼal na Málalél, na Málalél u chakámláb kʼal na Kainán, ");
INSERT INTO husNT2005_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","na Kainán u chakámláb kʼal na Enós, na Enós u chakámláb kʼal na Set, na Set u chakámláb kʼal na Adán ani na Adán tʼajadh kʼal na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Na Jesús, teykómte kʼal in cháp an Tʼokat Ejattaláb, kale ban waljaꞌ Jordán ani júná kʼal an Tʼokat Ejattaláb ban chabál xon ti yab kʼwajtsidh. ");
INSERT INTO husNT2005_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Kʼwajay tajaꞌ chab inik a kʼítsá ani taktamiyat kʼal an lej atʼax. Yab kʼapúch tin nakíl jachanꞌ an kʼij ani tayíl kʼaꞌay. ");
INSERT INTO husNT2005_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Utsan tám enchéꞌ kʼal an lej atʼax: ―Max tsubax lejtal i Chakámláb kʼal a Dios, ka utsaꞌ jechéꞌ an tʼujub ka wenkʼon ti kʼapnél. ");
INSERT INTO husNT2005_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Tókʼoyat enchéꞌ kʼal na Jesús: ―An Tʼokat Dhuslab in ulal enchéꞌ: “Yab tokotkʼi kʼal i kʼapnél ti ejat an inik, ejat jeye kʼal ejtal xowaꞌ na Dios in ulal.” ");
INSERT INTO husNT2005_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Júná tám kʼal an lej atʼax ba jun i tʼekʼat chʼén ani xalkʼantsat junwékʼi ejtal an ti chabáltsik xi kʼwajat takʼnél kʼal an pakdhaꞌ takʼix. ");
INSERT INTO husNT2005_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ani utsan enchéꞌ kʼal an lej atʼax: ―Neꞌech tu pidhaꞌ ti awiltaláb ka takʼiy ejtal jechéꞌ an chabáltsik ani abal ka dhabalnaꞌ jeye nin pubíl. Pos ejtal jechéꞌ, nanáꞌ in pidhnék ani neꞌech ku ejto ku pidhaꞌ xitaꞌ ku leꞌnaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Max ki tudhlan abal ti kin kʼakʼnaꞌ, ejtal jechéꞌ Tatáꞌ neꞌech ka dhabalnaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Por tókʼoyat enchéꞌ kʼal na Jesús: ―Lej atʼax, ki wékʼon techéꞌ tu tamét, pos an Tʼokat Dhuslab in ulal enchéꞌ: “Ka kʼakʼnaꞌ an Okʼóxláb na Diosil ani Jajáꞌkʼi ka tʼójontsal.” ");
INSERT INTO husNT2005_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Tayíl, júnaꞌ na Jesús kʼal an lej atʼax ban bitsow xi Jerusalén, kʼadhbá bin éb an pulek atá xon tu kʼakʼnáb na Dios ani utsan enchéꞌ: ―Max tsubax lejtal i Chakámláb kʼal a Dios, ka petʼnaꞌ tabáꞌ abal chaꞌat, ");
INSERT INTO husNT2005_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","pos an Tʼokat Dhuslab in ulal enchéꞌ: Na Dios neꞌech kin abaꞌ nin tʼokat abatwálejiltsik abal ti ki beletnaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Neꞌech ti ki bachʼu abal yab ka chaꞌaw na akan kʼal ni jun i tʼujub. ");
INSERT INTO husNT2005_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Tókʼoyat enchéꞌ kʼal na Jesús: ―In ulal jeye enchéꞌ an Tʼokat Dhuslab: “Yab ka taktamiy an Okʼóxláb na Diosil.” ");
INSERT INTO husNT2005_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Tam ti an lej atʼax yabich más in elaꞌ xan ti kin taktamiy na Jesús, in jilaꞌich tám wéꞌ i kʼij. ");
INSERT INTO husNT2005_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Na Jesús witsiy Galilea teykómte kʼal in cháp an Tʼokat Ejattaláb ani u tʼilnal Jajáꞌ putálkʼi ban chabál xi tajaꞌ kʼunat. ");
INSERT INTO husNT2005_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","U kʼwajíl ti okʼtsix ban atátsik xon tu tʼajnal an junkuntaláb ani kʼal ejtalkʼi tu kʼakʼnáb. ");
INSERT INTO husNT2005_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Kʼale tám Nasaret na Jesús, an bitsow xon ti Jajáꞌ pubenek. Tam tin bajaw nin kʼítsájil an koyóxnich, ochich ban atá xon tu tʼajnal an junkuntaláb jelt xan tin ujnámalich in tʼajál echʼekʼi ani kubey abal kin ajay an Tʼokat Dhuslab. ");
INSERT INTO husNT2005_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Pidhan tám kin ajay an dhutsadh úw xin jilám an tʼiltsix Isaías, tam tin wilaꞌ, in elaꞌ xon ti kʼwajat dhutsadh enchéꞌ: ");
INSERT INTO husNT2005_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Nin Tʼokat Ejattal an Okʼóxláb kʼwajat kʼal Nanáꞌ, pos tin takwyámal abal ku óltsi an ti alwaꞌ tʼilab an chʼojontáltsik, tin abámal abal ku kʼijidhmédhaꞌ xu tʼeꞌpinaltsik, abal ku tʼiltsi xi kʼwajat ti wikʼnéltsik, ke walkanichtsik, abal ku chuꞌxindhaꞌ xu jokʼoltsik, abal ku loꞌo xu atʼax tʼajtsinaltsik ");
INSERT INTO husNT2005_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ani abal ku tʼilaꞌ ke in bajúch xowkʼi an Okʼóxláb neꞌech ti ku xalkʼantsi an tin alwaꞌtal. ");
INSERT INTO husNT2005_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Tam ti okʼon kin ajay, in tʼuliy an úw, in witsbantsi xu tolmix ba jachanꞌ an atá ani buxkan, por in óntsal ti telnal kʼal ejtal xi tajaꞌ ti kʼwajattsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","In tuju tám ti káw ani in ulu enchéꞌ: ―Xoꞌ exomich ti tʼájnal ta taméttsik jelt xan tin ulal jechéꞌ an Tʼokat Dhuslab. ");
INSERT INTO husNT2005_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Kʼal ejtaltsik tu tʼilnal alwaꞌ na Jesús ani u labnaltsik kʼal an labidh tʼilabtsik xi Jajáꞌ in ulal. U kónóxtsik enchéꞌ: ―¿Yabxeꞌ jaꞌich jechéꞌ nin chakámil na José? ");
INSERT INTO husNT2005_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Utsantsik tám enchéꞌ kʼal na Jesús: ―Nanáꞌ u choꞌób alwaꞌ ke neꞌech ti kin utsaꞌtsik jechéꞌ an tʼilab: “Ilálix, ka iláliy tabáꞌ.” Neꞌech jeye ti kin utsaꞌtsik: “Xowaꞌ i achʼámal a tʼajám túꞌ Kapernaúm, ka tʼajaꞌ jeye techéꞌ ba chabálil.” ");
INSERT INTO husNT2005_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","In óntsi tám ti káw ani in ulu enchéꞌ: ―Tsubax tu utsáltsik ke ni jun i tʼiltsix u bachʼwáb alwaꞌ bin chabálil. ");
INSERT INTO husNT2005_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Tsubax tu utsáltsik ke yán i chemtsidh mímláb taꞌ ti kʼwajat ban chabál xi Israel tam ti xeꞌchin an tʼiltsix Elías. Tam ti yab ulich i áb óx i tamub kʼal chʼejel ani waꞌchin i pulek kʼaꞌínab tin pubíl jachanꞌ an chabál; ");
INSERT INTO husNT2005_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","por na Elías yab aban kʼal na Dios ba ni jun i chemtsidh mímlábtsik xu kʼwajíl Israel, tokot aban ba jun i chemtsidh mímláb xu kʼwajíl Sarepta, kʼunat ban bitsow xi Sidón. ");
INSERT INTO husNT2005_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Aníl jeye, yán taꞌ ti kʼwajat Israel xu yaꞌultsik kʼal an kʼwajat atʼax tʼítʼ tam ti xeꞌchin an tʼiltsix Eliseo, por yab jeldhá ni jun xitaꞌ xi jajáꞌtsik, tokot jeldhá na Námán xu kʼwajíl ban chabál xi Siria. ");
INSERT INTO husNT2005_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Tam tin achʼaꞌtsik ejtal jechéꞌ, ejtaltsik xi taꞌ ti kʼwajat ban atá xon tu tʼajnal an junkuntaláb chakuytsik tʼajat. ");
INSERT INTO husNT2005_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Chʼakaytsik ani in káldhaꞌ na Jesús ba jachanꞌ an bitsow ani júná tám bin éb an chʼén xon ti kʼwajat jachanꞌ an bitsow abal ka nixkʼá tajaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Por na Jesús watʼey junax chʼejel xon ti jajáꞌtsik kʼwajat ani kʼale. ");
INSERT INTO husNT2005_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Kʼale tám na Jesús Kapernaúm, jun i bitsow xu takʼnal Galilea ani tajaꞌ ti kʼwajay in okʼtsal an atiklábtsik tam in bajwal in kʼítsájil an koyóxnich. ");
INSERT INTO husNT2005_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ejtal u labnaltsik tʼajat xan tu okʼtsinaltsik, abal in chuꞌtaltsik ke na Jesús u káw kʼal yantam i awiltaláb. ");
INSERT INTO husNT2005_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ban atá xon tu tʼajnal an junkuntaláb, taꞌ ti kʼwajat jun i inik xi ochadh kʼal jun i atʼax ejattaláb ani dhájaxin kawidh enchéꞌ: ");
INSERT INTO husNT2005_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","―¡Ti ku jilaꞌ! ¿Jantʼéy a léꞌ kʼal wawáꞌ, Jesús xi Nasaret? ¿I tsiꞌnek abal ti ku kʼibdhaꞌ? Nanáꞌ tu exlál ani u choꞌób ke Tatáꞌ i Tʼokat Chakámláb kʼal a Dios. ");
INSERT INTO husNT2005_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Kʼwiyan tám enchéꞌ an atʼax ejattaláb kʼal na Jesús: ―¡Ki chamkʼan ani ki kale ba jechéꞌ an inik! Kwajlá tám chabál an inik kʼal an atʼax ejattaláb tin tamét ejtal jajáꞌtsik, kale ani yab xataꞌ ti tʼajtsin jachanꞌ an inik. ");
INSERT INTO husNT2005_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ejtal jikʼey ani u útsáxtsik jún ani jún enchéꞌ: ―¿Jantʼom káwintaláb awil jechéꞌ? ¡Jechéꞌ an inik in utsál an atʼax ejattalábtsik kʼal yantam i awiltaláb ani i chápláb abal ka kale ani u kalel! ");
INSERT INTO husNT2005_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Putálkʼi jachanꞌ an chabál ti choꞌóbná xowaꞌ in tʼajál na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Kale tám na Jesús ban atá xon tu tʼajnal an junkuntaláb ani kʼale bin kʼimáꞌ na Simón. Nin mím na Simón taꞌ ti kʼwajat u yaꞌul kʼal i kʼakʼlách ani pakabédhá na Jesús abal kin jeldhaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Kutpan tám na Jesús xon ti kʼwajat an yaꞌul, in utsaꞌ an kʼakʼlách abal ka wékʼon ani támkʼi ti wékʼon. Chʼakay tám an mímláb ani tujey ti tʼójontsáb kʼal an mímláb na Jesús ani nin juniktsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Tam ti ochichich na kʼítsá, ejtal xin koꞌol i yaꞌultsik xu yaꞌul kʼal xowaꞌkich i yawꞌlách, in tsiꞌdhaꞌ ba na Jesús. Jajáꞌ juntsik ti juntsik tin puntsi tin kʼubak an yaꞌultsik ani anchanꞌ tin jeldhaꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Aníl jeye, yán i yaꞌultsik in káldhantsi ti atʼax ejattalábtsik; tam u kalel, u dhajnaltsik chapik ani in ulaltsik enchéꞌ: ―Tatáꞌ i Chakámláb kʼal a Dios. Por na Jesús in kʼwiyaꞌ an atʼax ejattalábtsik ani yab más in walkaꞌ ti tʼilomtsik, abal choꞌóbte kʼal an atʼax ejattalábtsik ke Jajáꞌich nu Kristo. ");
INSERT INTO husNT2005_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Tam ti tsudhey, na Jesús kale ban bitsow ani kʼale ba jun i chabál xon ti yab kʼwajtsidh. Por alyat kʼal an atiklábtsik ani ulichtsik asta xon ti Jajáꞌ kʼwajat. U leꞌnáb ka kubdhá abal yab ka kʼale, ");
INSERT INTO husNT2005_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","por utsantsik enchéꞌ kʼal na Jesús: ―Koꞌol jeye kin kʼale ku tʼiltsitsik an ti alwaꞌ tʼilab an atiklábtsik xu kʼwajíl ba kʼeꞌet an bitsowtsik abal ka takʼyatichtsik kʼal na Dios, pos jaꞌich tin abnék. ");
INSERT INTO husNT2005_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Anchanꞌ ti xeꞌchin na Jesús ti tʼiltsix Galilea, putálkʼi ban atátsik xon tu tʼajnal an junkuntaláb. ");
INSERT INTO husNT2005_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Jun i kʼij, tam ti na Jesús kʼwajat bin wál an pujal xi Jenesaret, ulich yán i atiklábtsik, ke asta u kʼichʼnalich tʼajat na Jesús, abal in léꞌtsik kin achʼaꞌ nin káwintal na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Na Jesús in chuꞌu cháb i tan xi taꞌ ti kʼwajat mapats tin wál an pujal xon ti yab owtsik. Tajaꞌ ti kʼwajat kom an jixom toꞌoltsik paꞌinek ti tʼokom an tin jixáb an toꞌol. ");
INSERT INTO husNT2005_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Na Jesús balin tám ba jún an tan xin dhabal na Simón ani pakabédhá na Simón abal kin ówmédhaꞌ wéꞌ an tan bin wál an jaꞌ. Buxkan tám na Jesús ban tan ani tujey kin okʼtsi tajaꞌ an atiklábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Tam ti okʼon ti káw, in utsaꞌ enchéꞌ na Simón: ―Ka júnaꞌ an tan xon ti owtsik an pujal ani ka petʼnaꞌ tajaꞌ nin jixáb an toꞌol abal ka jixaꞌ an toꞌol. ");
INSERT INTO husNT2005_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Tókʼon na Simón: ―Okʼtsix, u tʼójnékich putál i akal ani yab xataꞌ i jixámal, por kom Tatáꞌ a ulal, neꞌech ku petʼnaꞌ juní an jixaxtaláb. ");
INSERT INTO husNT2005_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Tam tin tʼajaꞌtsik xowaꞌ utsan, yán i toꞌol yákʼwan, ke asta u michʼkʼanalich an jixaxtaláb kʼal in álém an toꞌoltsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","In kaniy tám kʼal in kʼubakkʼi nin at jixom toꞌol xi taꞌ ti kʼwajattsik jun pakʼeꞌ tan abal ka tsích ti tolmiyáb. Utey tám xi jún an tan ani in tsʼutsiytsik chablam ke asta wetsikich ka luyꞌchin ban pujal kʼal in álém. ");
INSERT INTO husNT2005_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Tam ti na Simón Pedro in chuꞌu jechéꞌ, tudhlan tin tamét na Jesús ani in utsaꞌ enchéꞌ: ―¡Ajátik, ki wixkʼin techéꞌ kʼal nanáꞌ, pos nanáꞌ in walablom! ");
INSERT INTO husNT2005_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Anchanꞌ tin ulu na Simón, kom jajáꞌ ani xi más nin at jixom toꞌol jikʼenektsik tʼajat abal yán i toꞌol in jixaꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Aníl jeye, na Jakobo ani na Juan, xu chakámlábtsik kʼal na Sebedeo, xi jayéch nin juniktsik na Simón, jikʼenektsik jeye. Por na Jesús in utsaꞌ enchéꞌ na Simón: ―Yab ki jikʼey, pos asta xoꞌ neꞌech ka tujúch ka aliy an atiklábtsik xi neꞌech ti kin belaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Tam tin júnaꞌichtsik an tan bin wál an pujal, in jilaꞌtsik ejtal ani kʼaletsik kʼal na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Tam ti na Jesús kʼwajat ba jun i bitsow, ulich jun i inik xu yaꞌul kʼal an kʼwajat atʼax tʼítʼ. Tam ti chuꞌtat na Jesús, an inik, tudhlan kutúl asta chabál ani pakabédhá enchéꞌ na Jesús: ―Ajátik, max a léꞌ, neꞌech ka ejto ti kin jeldhaꞌ kʼal jechéꞌ an yawꞌlách xu koꞌol. ");
INSERT INTO husNT2005_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Takan tám kʼal na Jesús ani utsan enchéꞌ: ―U léꞌ ani xoꞌ i jeléch. Támkʼi ti wékʼon an kʼwajat atʼax tʼítʼ ba jachanꞌ an inik. ");
INSERT INTO husNT2005_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Utsan tám enchéꞌ kʼal na Jesús: ―Yab xitaꞌ ka óltsi xantʼéy tu tʼajtsi, tokot ki kʼale ban páleꞌ ani ka pidhnaꞌ an pikbantsixtaláb kʼal tin kwenta na tʼokeltal jelt xan tin jilám ka tʼajan na Moisés. Ka tʼajaꞌ anchanꞌ abal ejtal kin choꞌóbnaꞌ ke i jeléch kʼal an yawꞌlách xa koꞌolwiꞌik. ");
INSERT INTO husNT2005_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Por bélkʼi u choꞌóbnáb putálkʼi xantʼéy in tʼajál na Jesús. Yandhaꞌ i atiklábtsik u junkunal abal ka axtsin xowaꞌ in ulal ani abal ka jeldhátsik kʼal an yawꞌlách xin koꞌol. ");
INSERT INTO husNT2005_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Por na Jesús u kʼalel xon ti yab xitaꞌ u kʼwajíl ani tajaꞌ u kʼwajíl ti ól. ");
INSERT INTO husNT2005_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Jun i kʼij, na Jesús kʼwajat ti okʼtsix ani taꞌ ti buxutsik tajaꞌ cháb óx i fariseotsik ani i okʼtsixtsik xin wilál nin takʼixtal na Dios xin jilám dhutsadh na Moisés. Jechéꞌtsik, tál túkʼi túkʼi ban kwentsaltsik xi Galilea, xi Judea ani xi táltsik jeye ban bitsow Jerusalén. Ani nin cháp an Okʼóxláb u xalkʼanal ba na Jesús abal kin jeldhaꞌ an yaꞌultsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ulich tám cháb óx i iniktsik xin tsiꞌdhál kʼal i chayteꞌ jun i inik. Jechéꞌ an inik yab in ejtowal ka yoyon ani in exaꞌtsik kin ódhaꞌ ban atá xon ti kʼwajat na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Por yab in elaꞌtsik xon ti kin ódhaꞌ, kom yán taꞌ ti kʼwajat an atiklábtsik; kʼadhiytsik tám bin éb an atá, in wékʼontsi wéꞌ tin jujúl ani tajaꞌ tin paꞌbaꞌ an yaꞌul kʼal nin chaytéꞌil junax chʼejel an atiklábtsik xon ti kʼwajat na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Tam ti na Jesús in chuꞌu abal u belnal kʼal jajáꞌtsik, in utsaꞌ enchéꞌ an yaꞌul: ―Jaꞌúb, na walastalábil pakwlantsidhich ti kʼwajat. ");
INSERT INTO husNT2005_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","An fariseotsik ani an okʼtsixtsik xin wilál nin takʼixtal na Dios xin jilám dhutsadh na Moisés, in tujutsik tám kin chalpay enchéꞌ: ―¿Jitam jáꞌ pé jeye jechéꞌ an inik xin tʼajál tinbáꞌ jelti max u Dios? Tokot a Dios in ejtowal kin pakwlantsi an walastalábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Por na Jesús in choꞌóbnaꞌ xantʼéy kʼwajat in chalpayaltsik ani in utsaꞌtsik enchéꞌ: ―¿Jantʼókʼi ta chalpayaltsik anchanꞌ? ");
INSERT INTO husNT2005_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Jowaꞌ más yab tʼojláb ku ulu: “Na walastalábil pakwlantsidhich ti kʼwajat”, o ku ulu: “Ki chʼakay ani ki beley”? ");
INSERT INTO husNT2005_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Pos neꞌech tu xalkʼantsitsik ke Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik, u koꞌol i awiltaláb techéꞌ ti chabál abal ku pakwlantsi i walastalábtsik. In utsaꞌ tám enchéꞌ an yaꞌul xi yab in ejtowal ka yoyon: ―Tatáꞌ tu utsál, ki chʼakay, ka dhayaꞌ na chaytéꞌil ani ki kʼaléch ta kʼimáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Támkʼi jachanꞌ, an inik xi yab in ejtowal ka yoyon, chʼakay tin tamét ejtal xi tajaꞌ ti kʼwajattsik. In dhayaꞌ nin chaytéꞌil xon ti kwachatwiꞌik ani kʼaléch tám tin kʼimáꞌ in pubédhantsal tin bij na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ejtal labantsik, in pubédhantsal tin bij na Dios ani kʼal an jíkʼib in ulutsik enchéꞌ: ―Xoꞌ i chuꞌu yán xataꞌ xi labidh tʼajat. ");
INSERT INTO husNT2005_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Tayíl, tam ti na Jesús kaléch, in chuꞌu jun i inik xin bij ta Lebí xin bachʼwal an jalbixtaláb abal an chabál xi Roma. Jechéꞌ an inik buxúl xon tu ulel ti pidhnáb an jalbixtaláb ani utsan enchéꞌ kʼal na Jesús: ―Wana ta exóbal kʼal Nanáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Chʼakay tám na Lebí, in jilaꞌ ejtal ani in wéwnaꞌ na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Más tayíl, na Lebí in tʼajtsi na Jesús jun i pulek kʼapúxnich tin kʼimáꞌ; taꞌ jeye ti buxutsik junax kʼal jajáꞌtsik ban mesa yán i bachʼkʼul jalbixtaláb ani kʼeꞌet jeye i atiklábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Por an fariseotsik ani an okʼtsixtsik xin wilál nin takʼixtal na Dios xin jilám dhutsadh na Moisés, in tujutsik kin kawiy nin exóbaliltsik na Jesús. Enchéꞌ tin ulutsik: ―¿Jantʼókʼi ta kʼapultsik ani i uchʼaltsik kʼal i bachʼkʼul jalbixtaláb ani kʼal i walablomtsik? ");
INSERT INTO husNT2005_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Tókʼoyattsik enchéꞌ kʼal na Jesús: ―Xi kʼwajattsik alwaꞌ ani yab u yaꞌul yab in yéntsal i ilálix, por xu yaꞌultsik, in yéntsal. ");
INSERT INTO husNT2005_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nanáꞌ yab in tsiꞌnek ku aliy xi xeꞌechtsik lujat, in tsiꞌnek ku aliy xi walbidhtsik abal kin jilaꞌichtsik ti walablom. ");
INSERT INTO husNT2005_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Utsan tám enchéꞌ na Jesús kʼal jajáꞌtsik: ―Nin exóbaliltsik na Juan ani nin exóbaliltsik an fariseotsik u kʼíltsik ani u óltsik tʼajat, por na exóbaliltsik echʼekʼi u kʼapultsik ani u uchʼaltsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Tókʼoyattsik enchéꞌ kʼal na Jesús: ―¿Awxeꞌ neꞌech kin ejtotsik ka kʼílin xi kanidhtsik ba jun i tomkixtaláb tam bél kʼwajat an tomkinél inik kʼal jajáꞌtsik? ¡Yabaꞌ! ");
INSERT INTO husNT2005_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Por neꞌech kin bajaw an kʼij tam neꞌech ka wékʼontsat an ti tomkinél inik ani neꞌchich jeye tám ka kʼílintsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Tʼiltsintsik jeye jechéꞌ an ti junbaxtaláb: ―Yab xitaꞌ in kotyal jun pejeꞌ i ít xeketláb abal kin patsʼkʼuy kʼál i kʼej xeketláb. Max kin tʼajaꞌ anchanꞌ, in odhnál an ít xeketláb, tám juní, an ít xeketláb yab neꞌech kin tomnaꞌ an kʼej xeketláb. ");
INSERT INTO husNT2005_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Nibal u balyáb an ít yajtsik uxnél ban kʼej ótʼ balixtaláb; pos max ka tʼajan anchanꞌ, an ít yajtsik uxnél in michʼál an kʼej ótʼ balixtaláb, neꞌech tám ka wakʼlan an yajtsik uxnél ani an ótʼ balixtaláb u kʼibchonal. ");
INSERT INTO husNT2005_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Jaxtám ti yejat ka balyat an ít yajtsik uxnél ban ít ótʼ balixtaláb abal chablam yab ka kʼibchon. ");
INSERT INTO husNT2005_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ni jun xitaꞌ xi kin uchʼaꞌ okʼox an kʼej yajtsik uxnél, in kulbetnál jeye an ít yajtsik uxnél, pos in ulal enchéꞌ: “An kʼej yajtsik uxnél, más jaꞌ alwaꞌ.” ");
INSERT INTO husNT2005_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Jun i kʼij tin kʼítsájil an koyóxnich, lejat na Jesús neꞌech ti belal ban aleláb xon ti waꞌach i tʼayablábtsik, nin exóbaliltsik in belal puꞌwal i trigo, in ixyal kʼal in kʼubak ani in kʼapaltsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Konyat tám enchéꞌ kʼal taltsik an fariseotsik: ―¿Jantʼókʼi ta tʼajáltsik i tʼojláb xi yab alwaꞌ ka tʼajan tam in kʼítsájil an koyóxnich? ");
INSERT INTO husNT2005_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Tókʼoyattsik enchéꞌ kʼal na Jesús: ―¿Yabxeꞌ jaykʼi a ajyámaltsik xowaꞌ in tʼajaꞌ na Dabid tam ti jajáꞌ ani nin juniktsik kʼaꞌay? ");
INSERT INTO husNT2005_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ochich ban pulek atá xon tu kʼakʼnáb na Dios ani in ikʼiꞌ an pan xi pikbantsidh na Dios, in kʼapu ani in pidhaꞌ jeye nin juniktsik xi taꞌ ti kʼwajat junax kʼal jajáꞌ, maske jachanꞌ an pan, tokot bijtsidh neꞌech kin kʼapu an páleꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","In ulu jeye enchéꞌ: ―Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik, u koꞌol i awiltaláb abal ku ulu xowaꞌ alwaꞌ ka tʼajan tam in kʼítsájil an koyóxnich. ");
INSERT INTO husNT2005_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Jun i kʼij, jayéchkʼi tin kʼítsájil an koyóxnich, ochich na Jesús ban atá xon tu tʼajnal an junkuntaláb ani in tuju ti okʼtsix. Tajaꞌ, taꞌ jeye ti kʼwajat jun i inik xi mulkanék in eját kʼubak. ");
INSERT INTO husNT2005_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","An okʼtsixtsik xin wilál nin takʼixtal na Dios xin jilám dhutsadh na Moisés ani an fariseotsik, taꞌ ti kʼwajat in kwáchiyaltsik na Jesús abal in léꞌ kin chuꞌu max kin jeldhaꞌ jachanꞌ an inik tin kʼítsájil an koyóxnich. Pos max kin tʼajaꞌ anchanꞌ, neꞌech tám kin kóꞌoytsik jun xataꞌ xantʼokʼál ti kin ólnaꞌ na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Por na Jesús, kom in choꞌób alwaꞌ xantʼéy kʼwajat ti chalpantsáb, in utsaꞌ enchéꞌ an inik xi mulkanék nin kʼubak: ―Ki chʼakay ani ki kubey junax chʼejel. Chʼakay tám an inik ani kubey tametláb. ");
INSERT INTO husNT2005_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Utsan tám enchéꞌ xi kʼeꞌettsik kʼal na Jesús: ―Neꞌech tu konoytsik jun xataꞌ: ¿Jantʼéy alwaꞌ ka tʼajan tam in kʼítsájil an koyóxnich? ¿Xowaꞌ alwaꞌ o xowaꞌ yab alwaꞌ? ¿Ka jeldhá an yaꞌultsik o ka walbá ka chemech? ");
INSERT INTO husNT2005_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","In teloloy tám na Jesús ejtal an atiklábtsik xi tajaꞌ ti kʼwajat wililíl ani in utsaꞌ enchéꞌ an inik: ―Ka lujku na kʼubak. Anchanꞌ tin tʼajaꞌ an inik ani jelnek ti jilkʼon nin kʼubak. ");
INSERT INTO husNT2005_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Por chakuy tʼajat xi kʼeꞌettsik ani tujey ti kónóx jajáꞌkʼitsik xantʼéy alwaꞌ kin tʼajtsi na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Tam ti jachanꞌ i kʼij, na Jesús kʼale ba jun i chʼén abal ti ól tajaꞌ ani tajaꞌ tin watʼnaꞌ putál i akal ti ólantsix an ta Dios. ");
INSERT INTO husNT2005_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Tam ti tsudhey, in kaniy nin exóbaliltsik ani in takuy lajucháb xi jajáꞌtsik, xin bijiy ti abatwáletsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Jajáꞌtsik jaꞌich na Simón, xi bijyat jeye ta Pedro; na Andrés, nin kidháb na Simón; na Santiago, na Juan, na Felipe, na Bartolomé, ");
INSERT INTO husNT2005_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","na Mateo, na Tomás, na Santiago xu chakámláb kʼal na Alfeo; na Simón xu takʼnal ban junkuntaláb xu bijyáb kananista; ");
INSERT INTO husNT2005_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","na Judas, xu chakámláb kʼal na Santiago ani na Judas Iskariote, xi más tayíl in pidhnaꞌ na Jesús abal ka chemdhá. ");
INSERT INTO husNT2005_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Paꞌay tám na Jesús ban chʼén junax kʼal jajáꞌtsik ani kubey ba jun i chaꞌlam kʼal nin exóbaliltsik. Junkunék tajaꞌ yán i atiklábtsik xi tál ban chabál Judea, ban bitsow Jerusalén ani xu kʼwajíltsik jeye Tiro ani Sidón tin waltsik an pujal. Ulnektsik tajaꞌ abal kin achʼaꞌ xowaꞌ in ulal na Jesús ani abal ka jeldhá jeye kʼal xowaꞌkich an yawꞌláchtsik xin koꞌol. ");
INSERT INTO husNT2005_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Xin achʼáltsik i yajtsiktaláb abal ochadh kʼal i atʼax ejattalábtsik, u jeléltsik jeye. ");
INSERT INTO husNT2005_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Jaxtám, kʼal ejtaltsik tu leꞌnáb ka takan na Jesús abal u jeldhábtsik kʼal an chápláb xu kalel ba Jajáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","In teloloy tám na Jesús nin exóbaliltsik ani in utsaꞌtsik enchéꞌ: ―Kʼijidh tʼajat abal tatáꞌtsik xi chʼojontál, kom a walkáltsik ki takʼyat kʼal na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","ʼKʼijidh tʼajat abal tatáꞌtsik xi xoꞌ i kʼaꞌíl, pos neꞌech ki ajwédhátsik. ’Kʼijidh tʼajat abal xi xoꞌ i ukʼnaltsik, pos tayíl neꞌech ki teꞌen. ");
INSERT INTO husNT2005_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","ʼKʼijidh tʼajat abal tatáꞌtsik tam ki atʼan kʼal an atiklábtsik, tam ki ajan, tam ki odhbijyat ani tam ki pojká jelti jun xataꞌ atʼax, kʼal tu kwenta Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik. ");
INSERT INTO husNT2005_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","ʼKi kulbétsik tʼajat ani ki kʼijidhmé jachanꞌ i kʼij, pos neꞌech ka bachʼutsik jun i pulek chʼejwalixtaláb túꞌ walkʼiꞌ; pos anchanꞌ jeye ti atʼax tʼajtsinék an tʼiltsixtsik kʼal nin wejeꞌ pakélil jachanꞌ an atiklábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","ʼPor chʼojontál a chuꞌbíl tumínladh iniktsik abal a kóꞌyámalichtsik xowaꞌ ti kʼijidhmédhámal. ");
INSERT INTO husNT2005_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","ʼChʼojontál a chuꞌbíl xi xoꞌ kidhat a koꞌoltsik, pos tayíl neꞌech ta kʼaꞌíl. ʼChʼojontál a chuꞌbíl xi xoꞌ i teꞌnaltsik, pos tayíl neꞌech ki ukʼintsik kʼal i tʼeꞌpintaláb. ");
INSERT INTO husNT2005_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","ʼChʼojontál a chuꞌbíl tam ejtal an atiklábtsik ti tʼilál alwaꞌ, pos anchanꞌ jeye tin tʼajámal nin wejeꞌ pakéliltsik kʼal an kʼambix tʼiltsixtsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","ʼPor tatáꞌtsik xi xoꞌ i kʼwajat tin axtsal, tu utsáltsik enchéꞌ: ’Ka kʼanidhaꞌ xi ti atʼáltsik, ka tʼajtsi ti alwaꞌtaláb xi ti atʼáltsik, ");
INSERT INTO husNT2005_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","ka lábtʼajaꞌ xi ti odhbijyaltsik ani ki kontsintsi xi ti atʼax tʼajtsaltsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Max jun xitaꞌ ti ki pikʼiy ba jun a chʼaꞌúb, ka pidhaꞌ jeye ti pikʼtsi xi jun pakʼeꞌ. Max jun xitaꞌ ti ki kʼántsi ta wát, ka walkaꞌ jeye kin júnaꞌ na xekét. ");
INSERT INTO husNT2005_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ka pidhaꞌ xitaꞌkich xowaꞌ ti ki kontsi ani xitaꞌ ti ki kʼántsi xowaꞌ tatáꞌ a dhabal, yab ka kontsi ti ki witsbantsi. ");
INSERT INTO husNT2005_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ka tʼajtsi xi kʼeꞌettsik jelt xan ta léꞌ ki tʼajtsin kʼal jajáꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","ʼMax tokot a kʼanidháltsik xitaꞌ ti kʼanidhál, ¿jantʼéy exom a tʼajáltsik watʼats? Pos asta an walablomtsik in tʼajál anchanꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Max tokot a tʼajtsaltsik ti alwaꞌtaláb xitaꞌ ti tʼajtsaltsik ti alwaꞌtaláb, ¿jantʼéy exom a tʼajáltsik watʼats? Pos anchanꞌ jeye in tʼajál an walablomtsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ani max tokot a matintsaltsik xa chalpayal ke neꞌech ti ki pidhaꞌ xataꞌ, ¿jantʼéy neꞌech ka átaꞌtsik? Pos an walablomtsik u mátíntsíxtsik jeye ani in aytsímtsik ka witsbantsat. ");
INSERT INTO husNT2005_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Por tatáꞌtsik yejat ka kʼakʼnaꞌ xi ti atʼáltsik, ka tʼajaꞌ i alwaꞌtalábtsik, ka matintsixnaꞌ xowaꞌkich, por yab ka aytsím ki witsbantsat. Anchanꞌ, púlek tám an chʼejwalixtaláb neꞌech ka bachʼu ani neꞌech ki kʼwajaytsik ta chakámlábtsik kʼal na Dios xi púlek tʼajat; pos Jajáꞌ i alwaꞌ inik tʼajat kʼal xi yabtsik in pidhnál i jalbintsixtaláb ani kʼal xi yab alwaꞌ iniktsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ki yajnantsixintsik, jelti xan ti ni Tátaꞌ u yajnantsix. ");
INSERT INTO husNT2005_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","ʼYab ka teltsi xantʼéy in tʼajál xi kʼeꞌettsik ani na Dios yab jeye neꞌech ti ki teltsi xantʼéy a tʼajáltsik. Yab ka walbiy ni jun xitaꞌ ani yab teye neꞌech ki walbiyattsik kʼal na Dios. Ki pakwlantsixin ani na Dios neꞌech jeye ti ki pakwlantsitsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ka pidhaꞌtsik xowaꞌ in yéntsal xi kʼeꞌettsik ani na Dios neꞌech jeye ti ki pidhaꞌ xowaꞌ tatáꞌtsik a yéntsal. Neꞌech ki pidhan ba na morrálil lejbadh alwaꞌ, kʼichʼadh alwaꞌ ani dhiyadh asta ke u wakʼlanalich kʼal in tsʼutsát. Na Dios jayéchkʼi neꞌech kin éynaꞌ an lejab xi tatáꞌtsik ka éynaꞌ kʼal kʼeꞌettsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Utsantsik tám kʼal na Jesús jechéꞌ an ti junbaxtaláb: ―¿Awxeꞌ jun i jokʼol neꞌech kin ejto kin lotʼokʼnaꞌ in at jokʼol? ¿Yabxeꞌ neꞌech ka kwajlan chablam ti éb ban jól? ");
INSERT INTO husNT2005_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ni jun i exóbal in choꞌób más ké nin okʼtsíxal, por tam kin okʼóch an ti exóbal, neꞌech jeye tám kin bajaw jelti nin okʼtsíxal. ");
INSERT INTO husNT2005_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","ʼ¿Jantʼókʼi ta teltsal an ti elits xin koꞌol na at kidháb bin wal ani yab a chuꞌtal an yejcheꞌ elits xa koꞌol ba na wal? ");
INSERT INTO husNT2005_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ani max yab a ejtowal ka chuꞌu an yejcheꞌ elits xa koꞌol ba na wal, ¿jantʼókʼi ta utsál enchéꞌ na at kidháb: “Kidháb, ti kin walkaꞌ tu jixtsi an ti elits xa koꞌol ba na wal”? ¡Kʼambix inik! Ka wékʼoy okʼox an yejcheꞌ elits xa koꞌol ba na wal ani anchanꞌ neꞌech tám ka ejto ka chuꞌu alwaꞌ abal ka jixtsi an ti elits xin koꞌol na at kidháb bin wal. ");
INSERT INTO husNT2005_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","ʼYab waꞌach i alwaꞌ teꞌ xi neꞌech kin kóꞌoy in walíl yab alwaꞌ, nibal waꞌach i teꞌ xi yab alwaꞌ xi neꞌech kin kóꞌoy in walíl alwaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Pos an teꞌtsik kʼal nin walílkʼi tu exláb. Yab u pitnal i igo ban kʼídhtsik, nibal u pitnal i uba ban kʼidhadh teꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","An inik xi alwaꞌ, in ulal xowaꞌ alwaꞌ, kom alwaꞌ xowaꞌ kʼwajat bin itsích. An atʼax inik, in ulal xowaꞌ yab alwaꞌ, kom yab alwaꞌ xowaꞌ kʼwajat bin itsích. Pos xowaꞌ kʼwajat bin itsích, jaꞌich in ulal. ");
INSERT INTO husNT2005_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","ʼ¿Jantʼókʼi tin bijyaltsik, “Ajátik, Ajátik” ani yab a tʼajáltsik xowaꞌ tu utsál? ");
INSERT INTO husNT2005_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Neꞌech tu utsaꞌtsik xitaꞌ in junwal xu uteltsik kʼal Nanáꞌ, xi tin axtsal ani in tʼajál xowaꞌ Nanáꞌ u ulal: ");
INSERT INTO husNT2005_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","In junwal jelti jun i inik xin kubaꞌ jun in kʼimáꞌ enchéꞌ: okʼox in chajaꞌ alkʼidh tʼajat an chabál ani in kʼwajbantsi tin akan ba tʼujub. Tam ti owtsikmé an waljaꞌ, ájlách chapik an jaꞌ xon ti kʼwajat an atá ani yab ejtowat ka yoywat abal nin akan kubat ba tʼujub. ");
INSERT INTO husNT2005_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Por xin achʼál nu káwintal ani yab in tʼajál xowaꞌ u ulal, in junwal jelti jun i inik xin kubaꞌ nin kʼimáꞌ eb chabál ani yab aknidh alwaꞌ; tam ti owtsikmé an waljaꞌ ájlách chapik an jaꞌ xon ti kʼwajat an atá, julpá an atá ani pakudh ejtal ti jilan. ");
INSERT INTO husNT2005_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Tam ti na Jesús in okʼóch kin tawnaꞌ an atiklábtsik, kʼale Kapernaúm. ");
INSERT INTO husNT2005_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Tajaꞌ taꞌ ti kʼwajat jun i romano xu okʼlek soldadotsik xin koꞌol jun in tʼojnálil xin kʼanidhál tʼajat. Jechéꞌ nin tʼojnálil u yaꞌul ti kʼwajat ani neꞌchich tʼajat ka chemech. ");
INSERT INTO husNT2005_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Tam ti jachanꞌ an okʼlek soldadotsik in achʼaꞌ u tʼilnal na Jesús, in abaꞌ cháb óx in okʼlékil an judíotsik abal kin pakabédhaꞌ na Jesús ka kʼale ti jeldhantsáb an tin tʼojnálil. ");
INSERT INTO husNT2005_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Kʼaletsik ba na Jesús ani in pakabédhaꞌ tʼajat enchéꞌ: ―Jechéꞌ an okʼlek soldadotsik in tomnál tʼajat ka tolmiy; ");
INSERT INTO husNT2005_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","pos jajáꞌ tu kʼanidhál tʼajat ani in abnámal ku kubtsin an ti atá xon ti tʼajál an junkuntaláb. ");
INSERT INTO husNT2005_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Kʼale tám na Jesús kʼal jajáꞌtsik. Por tam tu kʼunelichtsik ban atá, an okʼlek soldadotsik in abaꞌ cháb óx in jaꞌúbtsik abal ka utsan enchéꞌ na Jesús: ―Ajátik, yabich ki tʼojlin, pos yab in tomnál ki ochich bu kʼimáꞌ; ");
INSERT INTO husNT2005_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","jaxtám ti nibal elaꞌ nanáꞌ in kʼale tu aliy. Kʼal tokot ka ulu ka jeley nu tʼojnálil, neꞌech ka jeley. ");
INSERT INTO husNT2005_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Pos nanáꞌ in takʼnélkʼi neye tin kʼwajat kʼal nu okʼlékiltsik, por u koꞌol neye i soldadotsik xi nanáꞌ u takʼyal. Tam ku utsaꞌ jun i soldado ka kʼale, u kʼalel; tam ku utsaꞌ jeye xi kʼeꞌet ka tsích, u tsiꞌil ani tam ku utsaꞌ nu tʼojnálil kin tʼajaꞌ jun xataꞌ, in tʼajál. ");
INSERT INTO husNT2005_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Tam ti na Jesús in achʼaꞌ jechéꞌ, laban tʼajat kʼal xowaꞌ in achʼaꞌ in ulúmal jachanꞌ an inik, in teloloy tám an atiklábtsik xi kʼál ti wewkómte ani in ulu enchéꞌ: ―Tsubax tu utsáltsik, ke nibal ban israelitatsik yab u elámal jun xitaꞌ xin koꞌol in belomtal jelt xan tin koꞌol jechéꞌ an inik xi yab u israelita. ");
INSERT INTO husNT2005_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Tam ti witsiytsik ban atá xi abnéktsik ti kanix an ta Jesús, jelnekich tin elaꞌ jachanꞌ an tʼójontsix. ");
INSERT INTO husNT2005_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Tam ti watʼéch ejtal jechéꞌ, na Jesús neꞌech ba jun i bitsow xu bijyáb Naín, junkímte kʼal nin exóbaliltsik ani kʼal yán i atiklábtsik jeye. ");
INSERT INTO husNT2005_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Tam tu kʼunelich ba jachanꞌ an bitsow, in chuꞌu jun i chemélom xu neꞌdhábich ti jolyáb. Jachanꞌ an chemélom jaꞌich in junkax chakámil jun i chemtsidh mímláb. Kʼal yán i atiklábtsik ti neꞌech junkímte. ");
INSERT INTO husNT2005_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Tam ti chuꞌtat kʼal an Ajátikláb jachanꞌ an chemtsidh mímláb, kóꞌontsat ti yajnantsixtaláb ani in utsaꞌ enchéꞌ: ―Yab ki ukʼin. ");
INSERT INTO husNT2005_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Utey tám na Jesús, in takaꞌ an kʼimáꞌláb ani kubeytsik xi neꞌech in kitám jachanꞌ an kʼimáꞌláb. Na Jesús in utsaꞌ tám enchéꞌ an chemélom: ―Kwitól, Nanáꞌ tu utsál: ¡Ki chʼakay! ");
INSERT INTO husNT2005_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Buxkan tám xi chemnekwiꞌik ti kʼwajat ani tujey ti káw; na Jesús in pidhnaꞌich tám ba nin nánaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ejtaltsik xin chuꞌu jechéꞌ, jikʼey ani tujeytsik kin pubédhantsi tin bij na Dios. In ulaltsik enchéꞌ: ―Jun i pulek tʼiltsix xalkʼanék ba wawáꞌ. In ulaltsik jeye enchéꞌ: ―Na Dios tsiꞌnek abal kin tolmiy nin bitsówil. ");
INSERT INTO husNT2005_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Putál Judea ani an kwentsaltsik xi kʼwajat malilíl, in choꞌóbnaꞌtsik xantʼéy in tʼajámal na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Na Juan in achʼaꞌ jeye ejtal jechéꞌ, kom u tʼiltsinal kʼal nin exóbaliltsik. In kaniy tám cháb nin exóbaliltsik ");
INSERT INTO husNT2005_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ani in abaꞌ abal ka kʼale ti konyáb na Jesús max Jajáꞌich lejtal xi bijidh neꞌech ka tsích o koꞌol ki aytsi kʼeꞌet. ");
INSERT INTO husNT2005_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Tam ti uteytsik ba na Jesús xi abnék kʼal na Juan, in utsaꞌtsik enchéꞌ: ―Na Juan xu pujax tu abámal abal tu konoy max tatáꞌich kwaꞌ xi bijidh neꞌech ka tsích o yejat ki aytsi kʼeꞌet. ");
INSERT INTO husNT2005_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Jachanꞌ i ora tam ti ulich nin exóbaliltsik na Juan, na Jesús in jeldhaꞌ yán i yaꞌultsik kʼal xowaꞌkich an yawꞌláchtsik ani an chʼukʼuxtalábtsik xin koꞌol, xi ochadhtsik kʼal i atʼax ejattaláb in káldhantsi ani xu jokʼoltsik in chuꞌxindhaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Tókʼoyattsik tám enchéꞌ kʼal na Jesús: ―Ki kʼaléchtsik ani ka utsaꞌ na Juan xowaꞌ a chuꞌúmaltsik ani xowaꞌ a achʼámal. Ka utsaꞌ abal an jokʼoltsik u chuꞌxinal, an kʼwechʼeꞌtsik u belal, xin koꞌoltsik an kʼwajat atʼax tʼítʼ u jelél, an tanchuꞌtsik u ochʼxinal, an chemélomtsik u ejdháb ti ít ani an chʼojontáltsik u tʼiltsinal an ti alwaꞌ tʼilab. ");
INSERT INTO husNT2005_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Kʼijidh tʼajat abal xitaꞌ ti kin belaꞌ ani yab ka kux witsiy tayíl. ");
INSERT INTO husNT2005_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Tam ti kʼaléch xi abnéktsik kʼal na Juan, na Jesús tujey tám kin tʼiltsi an atiklábtsik kʼal tin kwenta na Juan. In ulu enchéꞌ: ―¿Jantʼéy i kʼalnek ka chuꞌutsik ban chabál xon ti yab kʼwajtsidh? ¿Jun i pakáb xi kʼwajat ti wawꞌyáb kʼal i ikʼ? ");
INSERT INTO husNT2005_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Max yabaꞌ, ¿jantʼéy i kʼalnektsik ka chuꞌu? ¿Jun i inik xi xeketlidh kʼal i alwaꞌ kʼudhkʼum? A choꞌóbtsik alwaꞌ ke xu xeketlinaltsik kʼal i alwaꞌ kʼudhkʼum ani kidhat in koꞌol u kʼwajíltsik bin kʼimáꞌ i pakdhaꞌ takʼix. ");
INSERT INTO husNT2005_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Pos tám, ¿jantʼéy i kʼalnektsik ka chuꞌu? ¿Jun i tʼiltsix? Aniꞌ kʼejle ani tu utsáltsik ke na Juan, más jaꞌ púlek ké jun i tʼiltsix. ");
INSERT INTO husNT2005_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Jechéꞌ na Juan jaꞌich xu tʼilnal kʼal an Tʼokat Dhuslab enchéꞌ: Jéꞌ u okxiyal nu abatwálejil abal ti ki tʼojojontsi an ti bél. ");
INSERT INTO husNT2005_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Tsubax tu utsáltsik, ke ba ejtal an atiklábtsik yab jaykʼi waꞌchinék jun i tʼiltsix más púlek ké na Juan xu pujax; por xi más chipíl xon tu takʼix na Dios, más jaꞌ púlek ké na Juan. ");
INSERT INTO husNT2005_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Tam tin achʼaꞌtsik jechéꞌ, ejtal an atiklábtsik ani an bachʼkʼul jalbixtaláb xi pujadhtsik kʼal na Juan, in exlaꞌtsik abal na Dios lujat tʼajat xowaꞌ in tʼajál; ");
INSERT INTO husNT2005_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","por an fariseotsik ani an okʼtsixtsik xin wilál nin takʼixtal na Dios xin jilám dhutsadh na Moisés, xi yabtsik pujadh kʼal na Juan, in pojkaꞌtsik xowaꞌ na Dios in leꞌnámal kin tʼajaꞌ kʼal jajáꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","In ulu tám enchéꞌ an Ajátikláb: ―¿Jantʼokʼál ti neꞌech ku ejto ku junbay an atiklábtsik xi jechéꞌ i kʼij? ¿Jantʼéy in junwaltsik? ");
INSERT INTO husNT2005_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","In junwal jelti tsʼitsik chakam xu buxkanal ti ubátʼ xon tu tʼajnal an nújlách ani in dhájayaltsik nin at chakamtsik enchéꞌ: “I jutsuy i chúl ani yab i bixmáchtsik; i ajatnaꞌ i tʼeꞌpidh ajatláb ani yab i ukʼintsik.” ");
INSERT INTO husNT2005_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Pos tsích na Juan xu pujax, xi yab in kʼapal i kʼapnél nibal in uchʼál i yajtsik uxnél ani a ulaltsik ke jajáꞌ ochadh kʼal i atʼax ejattaláb. ");
INSERT INTO husNT2005_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Tayíl in tsích Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik, xin kʼapul ani in uchʼal por a ulaltsik ke in jikʼlom ani ke u jaꞌúb i walablomtsik ani i bachʼkʼul jalbixtaláb. ");
INSERT INTO husNT2005_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Por nin chalab na Dios u xalkʼanal abal lujat bin xeꞌchintal an atiklábtsik xi kʼál tu belnal. ");
INSERT INTO husNT2005_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Pakabédhá na Jesús kʼal jun i fariseo abal ka kʼale ti kʼapul bin kʼimáꞌ jechéꞌ an fariseo, kʼale bin kʼimáꞌ jachanꞌ an fariseo ani buxkan ban mesa. ");
INSERT INTO husNT2005_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Tám, jun i mímláb xi xeꞌech yab exbadh, xu kʼwajíl jeye ba jachanꞌ an bitsow, xin achʼaꞌ abal na Jesús kʼalnek ti kʼapul bin kʼimáꞌ jachanꞌ an fariseo, ulich ani in tsiꞌdhál jun i frasko xi tʼajadh kʼal i alabastro, tsʼutsat kʼal i niwiytaláb. ");
INSERT INTO husNT2005_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Utey u ukʼnal ba na Jesús ani tujey kin axdhantsi tin akan kʼal in jaꞌmál nin wal. Tayíl exmách kin kʼwiꞌtsi kʼal nin xiꞌíl, in chʼuchʼbantsi ani in joltsi bin akan an ti niwiytaláb. ");
INSERT INTO husNT2005_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Tam tin chuꞌu jechéꞌ an fariseo xi kʼál ti kanidh na Jesús, in chalpay enchéꞌ: ―Max jechéꞌ an inik tsubaxak lejtal jaꞌich jun i tʼiltsix, neꞌech kin exlaꞌ xitaꞌ kʼál ti kʼwajat ti taknal ani xitam mímláb jeye jajáꞌ. Pos jajáꞌ, jaꞌich jun i mímláb xi xeꞌech yab exbadh. ");
INSERT INTO husNT2005_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Utsan tám enchéꞌ an fariseo kʼal na Jesús: ―Simón, u koꞌol jun xataꞌ xantʼéy u léꞌ tu utsaꞌ. Tókʼon enchéꞌ an fariseo: ―Ti kin utsaꞌich, Okʼtsix. ");
INSERT INTO husNT2005_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","In ulu tám enchéꞌ na Jesús: ―Cháb i iniktsik in júntsal ti tumín jun i inik xin matintsixnál i tumín. Jún in júnál bóꞌ i boꞌ inik i denariotsik ani jún in júnál chab inik láju; ");
INSERT INTO husNT2005_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","kom yab in ejtowaltsik kin witsbaꞌ, an matintsix tumín in pakwlantsi an tin júntsixtaltsik chablam. Ani xoꞌ ti kin utsaꞌ, ¿kʼal jowaꞌ kʼál ti neꞌech ka kʼakʼná más an matintsix tumín? ");
INSERT INTO husNT2005_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Tókʼon enchéꞌ na Simón: ―Nanáꞌ u chalpayal abal kʼal xi más yán nin júntsixtal pakwlantsat. Utsan kʼal na Jesús: ―Tsubax xowaꞌ a ulu. ");
INSERT INTO husNT2005_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Chawkʼin tám na Jesús, in telaꞌ an mímláb ani in utsaꞌ enchéꞌ na Simón: ―A chuꞌtal jechéꞌ an mímláb. In ochich ba na kʼimáꞌ ani yab tin pidhaꞌ ti jaꞌ abal ku tʼakaꞌ nu akan; por jechéꞌ an mímláb tin axdhantsámal tu akan kʼal nin jaꞌmál nin wal ani tin wayedhantsámal kʼal nin xiꞌíl. ");
INSERT INTO husNT2005_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Tatáꞌ yab tin chʼuchʼbay, por jechéꞌ an mímláb, asta tin ochenek yab in koydhámal tin chʼuchʼbantsi tu akan. ");
INSERT INTO husNT2005_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Yab tin joltsámal ti aséyte bu ókʼ, por jajáꞌ tin joltsámal ti niwiy aséyte bu akan. ");
INSERT INTO husNT2005_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Jaxtám tu utsál, kom pakwlantsat ejtal nin walastalábil maske yán tʼajat, jaxtám ti kʼanidhaxin tʼajat; por xitaꞌ wéꞌ in walastalábil ka pakwlantsat, wéꞌ jeye ti neꞌech ti kʼanidhax. ");
INSERT INTO husNT2005_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","In utsaꞌ tám enchéꞌ an mímláb: ―Na walastalábil pakwlantsidhich ti kʼwajat. ");
INSERT INTO husNT2005_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Xi más an kʼapultsik xi taꞌ jeye ti buxutsik kʼal Jajáꞌ, tujeytsik ti útsáx jajáꞌkʼitsik enchéꞌ: ―¿Jitam jáꞌ pé jeye awil jechéꞌ an inik, ke asta i walastalábtsik in ejtowal kin pakwlantsi? ");
INSERT INTO husNT2005_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Por na Jesús in utsaꞌ enchéꞌ an mímláb: ―I loꞌey abal i belmách, ki kʼaléch tsububudh a ejattal. ");
INSERT INTO husNT2005_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Tam ti watʼéch ejtal jechéꞌ, na Jesús xeꞌchin ba yán i bitsowtsik ani ban kwentsaltsik ti tʼiltsix ani ti óltsix an ti alwaꞌ tʼilab kʼal tin kwenta xan tu takʼix na Dios. Junkímte kʼal xi lajucháb nin exóbaliltsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Táꞌ jeye ti xeꞌech ti junkil cháb óx i mímlábtsik xi Jajáꞌ in jeldhámal kʼal an yawꞌlách xin koꞌoltsikwiꞌik ani in káldhantsám ti atʼax ejattalábtsik. Kʼal jechéꞌ an mímlábtsik taꞌ jeye ti xeꞌech na María xu bijyáb ta Magdalena, xi káldhantsidh búk ti atʼax ejattaláb. ");
INSERT INTO husNT2005_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Táꞌ jeye ti xeꞌech na Juana, nin tomtal na Kusa, an inik xi jaꞌichwiꞌik in okʼlek tʼojnálil na Erodes. Na Susana ani yán más kʼeꞌet i mímlábtsik taꞌ jeye ti xeꞌechtsik abal kin tolmiy na Jesús kʼal xowaꞌ in koꞌoltsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Yán xi kale ban bitsowtsik abal kin chuꞌu na Jesús. Tam ti junkunich yán i atiklábtsik, na Jesús tujey tám kin tawnaꞌtsik kʼal i junbaxtalábkʼi. Enchéꞌ tin utsaꞌtsik: ");
INSERT INTO husNT2005_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―Jun i óm kʼale ti búkʼul iyaláb. Tam ti kʼwajatich ti búkʼul, taltsik an iyaláb kwajlan ban bél, kʼachʼyat ani kʼapat kʼal an chʼichintsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Taltsik an iyaláb kwajlan ban tʼujublom ani tam ti jachanꞌ an iyalábtsik ixkʼan, wayey kom tajaꞌ, yab áchʼ an chabál. ");
INSERT INTO husNT2005_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Taltsik an iyaláb kwajlan ban kʼídhlom, ixkʼan, por kom junax ti pakey kʼal an kʼídh, paxkʼiyat. ");
INSERT INTO husNT2005_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Por taltsik an iyaláb, kwajlan ban chabál xi alwaꞌ, tam ti ixkʼan ani pakey, tʼuꞌuntsik tʼajat. Xi jun i iyaláb in kóꞌoy asta boꞌ inik i itsixlek. Tam ti okʼonich kin ulu jechéꞌ, utsantsik kawidh enchéꞌ kʼal na Jesús: ―Xitaꞌ in koꞌol in ochʼoxtal alwaꞌ, kin exbay xowaꞌ u ulal. ");
INSERT INTO husNT2005_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Konyat tám kʼal nin exóbaliltsik xantʼéy in léꞌ kin ulu jechéꞌ an junbaxtaláb. ");
INSERT INTO husNT2005_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ani Jajáꞌ in utsaꞌtsik enchéꞌ: ―Tatáꞌtsik, ti pidhál na Dios ka choꞌóbnaꞌ xowaꞌ in koꞌol yab tejwaꞌ kʼal tin kwenta xan ti Jajáꞌ tu takʼix; por xi kʼeꞌettsik, tokot u tawnál kʼal i junbaxtalábkʼi. Anchanꞌ, maske in chuꞌtaltsik, por jáykʼi max yab in chuꞌtal; maske in achʼáltsik, por yab in exbayal. ");
INSERT INTO husNT2005_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","ʼJechéꞌ jaꞌich xowaꞌ in léꞌ kin ulu an junbaxtaláb: An iyaláb, in junwal jelti nin káwintal na Dios; ");
INSERT INTO husNT2005_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","an iyaláb xi kwajlan ban bél, in junwal jelti an atiklábtsik xin achʼál nin káwintal na Dios, por tam tál an lej atʼax u wékʼontsáb bin itsích abal yab kin belaꞌtsik ani yab ka loꞌey. ");
INSERT INTO husNT2005_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","An iyaláb xi kwajlan ban tʼujublom, in junwal jelti an atiklábtsik xin axtsal tin káwintal na Dios ani in bachʼwal kʼal yantam i kulbétaláb, por eb itsíchkʼi; neꞌech ka belmách wéꞌ i kʼij, por tam ka taktamiyat, u kuxkultsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","An iyaláb xi kwajlan ban kʼídhlom, in junwal jelti an atiklábtsik xin achʼál nin káwintal na Dios por yab in tʼajáltsik ti kʼij. In walkál ka átátsik kʼal an chalpaxtaláb, kʼal an tumín ani kʼal xowaꞌkich xin kulbetnáltsik tʼajat. Anchanꞌ yab in ejtowal kin bajaw ka xeꞌchin lujat. ");
INSERT INTO husNT2005_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Por an iyaláb xi kwajlan ban alwaꞌ chabál, in junwal jelti an atiklábtsik xin bachʼwal nin káwintal na Dios kʼal ejtal nin ejattal; in tʼajáltsik xowaꞌ in achʼál ani kom in óntsal ti belomtsik, u xeꞌchinalichtsik tám lujat tʼajat. ");
INSERT INTO husNT2005_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","ʼNi jun xitaꞌ yab in letʼkʼoyal jun i tajbaxtaláb abal tayíl kin paxkʼiy kʼal jun i balixtaláb o kin kʼwajbaꞌ tin ál i chéy. U letʼkʼoyáb an tajbaxtaláb ani u kʼwajbáb tʼekʼat abal ka tajbayat xitaꞌ ka ochich. ");
INSERT INTO husNT2005_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Pos yab waꞌach xataꞌ chinat xi yab neꞌech ka xalkʼan tayíl, nibal waꞌach xataꞌ yab tejwaꞌ xi yab neꞌech ka choꞌóbná tayíl ani ka kʼwajbá tejwaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","ʼAnchanꞌ pé, ka achʼaꞌtsik alwaꞌ, xitaꞌ in exbayal, neꞌech ka pidhan kin exbay más ani xitaꞌ yab in exbayal, neꞌech ka kʼántsin asta xowaꞌ in chalpayal ke in exbayal. ");
INSERT INTO husNT2005_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ulichtsik tám nin nánaꞌ ani nin kidhábtsik na Jesús, por yab in ejtotsik ka utey asta xon ti Jajáꞌ kʼwajat abal yán tʼajat taꞌ ti kʼwajat an atiklábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Utsan tám enchéꞌ na Jesús: ―Na nánaꞌ ani na kidhábtsik núꞌ kʼwajat eléb ani in léꞌtsik ti ki chuꞌu. ");
INSERT INTO husNT2005_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Por Jajáꞌ in utsaꞌtsik enchéꞌ: ―Xitaꞌ in achʼáltsik nin káwintal na Dios ani in tʼajáltsik xowaꞌ in léꞌ na Dios, jachanꞌ, jaꞌich xi kʼwajattsik jelti nu nánaꞌ ani nu kidhábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Jun i kʼij, na Jesús balin ba jun i tan kʼal nin exóbaliltsik ani in utsaꞌtsik enchéꞌ: ―Wana jun pakʼeꞌ pujal. Ani kʼaletsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Por lejat exom ti watʼel, na Jesús wayich. Tajaꞌtsik ti elan ban pujal kʼal jun i chapik ikʼ, tujey ti baltsinal ti jaꞌ an tan ani wetsikich tʼajat ka luyꞌchin. ");
INSERT INTO husNT2005_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Kʼale tám ti bakyáb na Jesús ani utsan enchéꞌ: ―¡Okʼtsix! ¡Okʼtsix! ¡Exomich tu lupnal! Chʼakay tám na Jesús, in kʼwiyaꞌ an ikʼ ani an múlákʼ jaꞌ. Junwékʼi ti kublan ani jilkʼon chamamadh. ");
INSERT INTO husNT2005_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","In utsaꞌ tám enchéꞌ nin exóbaliltsik: ―¿Jantʼéy támun kʼal an belomtaláb xa koꞌoltsik? Por jajáꞌtsik jikʼenek ani labnéktsik tʼajat kʼal xowaꞌ in chuꞌu támun ani u kónóxtsik jún ani jún enchéꞌ: ―¿Jantʼom awiltaláb in koꞌol jechéꞌ an inik xin utsál ka chamkʼan an ikʼ ani an jaꞌ ani u axtsinal? ");
INSERT INTO husNT2005_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ulchichtsik tám ban chabál xi Gadara, xi kʼwajat jun pakʼeꞌ pujal tin tamét an chabál xi Galilea. ");
INSERT INTO husNT2005_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Tam ti na Jesús paꞌách ban tan, utukná kʼal jun i inik xu kʼwajíl ba jachanꞌ an bitsow. Jechéꞌ an inik nakatich tʼajat i kʼij ti kʼwajat ochadh kʼal i atʼax ejattalábtsik. Yab u xeketlinal nibal u kʼwajíl ba jun i atá, u kʼwajíl xon tu jolyáb an chemélomtsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Tam ti chuꞌtat na Jesús, tudhlan tin tamét ani in ulu kawidh enchéꞌ: ―¿Jantʼókʼi ta ochꞌom kʼal nanáꞌ, Jesús, xi Chakámláb kʼal na Dios xi púlek tʼajat? Tu pakabédhál abal yab ti kin yajlombédhaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","In ulu jechéꞌ, kom na Jesús kʼwajatich in utsál an atʼax ejattaláb abal ka kaléch ba jachanꞌ an inik. Owenekich tʼajat ti ochadh jachanꞌ an inik kʼal an atʼax ejattaláb. Wikʼtsinék kʼal an atiklábtsik tin kʼubak ani tin akan kʼal i patʼál abal ka kóꞌyat wikʼadh, por in tʼapyal ani u júnáb kʼal an atʼax ejattaláb ban chabál xon ti yab kʼwajtsidh. ");
INSERT INTO husNT2005_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Konyat tám enchéꞌ kʼal na Jesús: ―¿Jan ta bij? Jajáꞌ tókʼon enchéꞌ: ―Nanáꞌ u bij Lejión. Anchanꞌ tin ulu kom jajáꞌ yán tʼajat ti éb ti kʼwajat ba jachanꞌ an inik. ");
INSERT INTO husNT2005_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Jachanꞌ an atʼax ejattalábtsik in pakabédhaꞌ na Jesús abal yab ka abnátsik ban owtsiktaláb. ");
INSERT INTO husNT2005_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ba jachanꞌ an chʼénlom taꞌ ti xeꞌech yán i olomtsik ti kʼapupúl ani pakabédhaxin an atʼax ejattalábtsik abal ka walká ka ochich ban olomtsik. Walká ka ochichtsik tajaꞌ kʼal na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Kale tám an atʼax ejattalábtsik ba jachanꞌ an inik ani ochich ban olomtsik. Ejtal an olomtsik in petʼnaꞌ tinbáꞌ ban chʼén, kwajlan ban pujal ani tajaꞌ ti lupuntsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Tam ti an belkol olomtsik in chuꞌu xantʼéy támun, ájláchtsik ani kʼale kin tʼilaꞌ ban bitsow ani ban kwentsaltsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","An atiklábtsik kʼale kin chuꞌu xantʼéy támnék. Tam ti ulichtsik xon ti kʼwajat na Jesús, elan an inik xi ochadhwiꞌik kʼal an atʼax ejattalábtsik, buxúlkʼi xon ti kʼwajat na Jesús, xeketlidhich ani juntam anikʼijich. An atiklábtsik, jikʼey. ");
INSERT INTO husNT2005_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Xi chúꞌlámadhtsik, jaꞌich kʼál ti tʼiltsin an atiklábtsik xi ulich xan ti jeldhá jachanꞌ an inik xi ochadhwiꞌik kʼal an atʼax ejattalábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ejtal an atiklábtsik xu kʼwajíl tajaꞌ ban chabál xi Gadara, tujeytsik kin pakabédhaꞌ na Jesús abal ka kaléch bin chabáliltsik, kom jajáꞌtsik u jikʼéltsik tʼajat. Jaxtám na Jesús ti balin ban tan abal ka kʼaléch. ");
INSERT INTO husNT2005_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Por pakabédhá na Jesús kʼal an inik xin káldhantsámal an ti atʼax ejattalábtsik abal ka júná jeye kʼal Jajáꞌ, por utsan kʼal na Jesús abal ka jilkʼon tajaꞌ ani utsan jeye enchéꞌ: ");
INSERT INTO husNT2005_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―Ki kʼaléch ta kʼimáꞌ ani ka tʼilaꞌ xantʼéy ti tʼajtsámal na Dios. Kʼaléch tám an inik ani in tʼilaꞌ putál an bitsow xantʼéy tʼajtsin kʼal na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Tam ti na Jesús witsích jun pakʼeꞌ pujal, bachʼwat kʼal an atiklábtsik kʼal yantam i kulbétaláb kom kʼal ejtal ti kʼwajat aytsímte. ");
INSERT INTO husNT2005_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ulich tám jun i inik xu bijyáb ta Jairo, xu okʼlek ban atá xon tu tʼajnal an junkuntaláb. Tudhlan tin tamét na Jesús ani in pakabédhaꞌ abal ka kʼale ti álnáb tin kʼimáꞌ, ");
INSERT INTO husNT2005_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","kom taꞌ tin koꞌol jun in junkax tsidhánil xin koꞌolich lajucháb i tamub ani jechéꞌ an tsidhan exomich ti chemel. Kʼale tám na Jesús ani kʼal yán i atiklábtsik ti wéwná, ke asta u kʼichʼnalich tʼajat. ");
INSERT INTO husNT2005_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ba nin yaníl an atiklábtsik, taꞌ jeye ti tál jun i mímláb xin koꞌolich lajucháb i tamub ti yaꞌul kʼal i lakúmtaláb. In pakúmalich ejtal xowaꞌ in koꞌol kʼal i ilálixtsik ani yab u ejtowáb ka jeldhá kʼal ni jun i ilálix. ");
INSERT INTO husNT2005_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Jechéꞌ an mímláb utey tin kúx na Jesús, in taktsi tin wál nin kʼudhkʼúmil ani támkʼi jachanꞌ ti kublan ti xichʼnal. ");
INSERT INTO husNT2005_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Konoxin tám na enchéꞌ Jesús: ―¿Jitaꞌ tin takaꞌ? Kom ejtaltsik in ulal abal ni jun xitaꞌ kʼál ti taknék, na Pedro ani nin juniktsik in ulu enchéꞌ: ―Okʼtsix, kʼal yán i atiklábtsik ta kʼichʼnal ani i nixkʼáb túkʼi túkʼi, ani ¿bél a konyal xitaꞌ ti takaꞌ? ");
INSERT INTO husNT2005_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Por na Jesús in ulu enchéꞌ: ―Tin takám jun xitaꞌ, pos u achʼaꞌ abal kale i chápláb xu koꞌol ani jeley jun xitaꞌ kʼál. ");
INSERT INTO husNT2005_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Tam ti an mímláb in achʼaꞌ abal axnék, utey u wipipíl ani tudhlan tin tamét na Jesús. In ólnaꞌ tám tin tamét ejtal an atiklábtsik xantʼókʼi tin kwenta ti takxinék ani xan ti jeley támkʼi. ");
INSERT INTO husNT2005_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Utsan tám enchéꞌ kʼal na Jesús: ―Mímláb, i jeley abal i belmách, awil ki kʼale tsububudh a itsích. ");
INSERT INTO husNT2005_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Bél kʼwajat ti káw na Jesús, tam ti ulich jun xitaꞌ xi tál bin kʼimáꞌ na Jairo, an inik xu okʼlek ban atá xon tu tʼajnal an junkuntaláb ani utsan enchéꞌ na Jairo: ―Na tsidhánil chemech, yabich ki kʼwajay ka aniꞌ tʼojliy an Okʼtsix. ");
INSERT INTO husNT2005_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Por tam ti na Jesús in achʼaꞌ xowaꞌ utsan na Jairo, in utsaꞌ enchéꞌ: ―Yab ki jikʼey, tokot ki belmách ani na tsidhánil neꞌech ka ejech. ");
INSERT INTO husNT2005_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Tam ti ulich ban atá, yab xitaꞌ más in walkaꞌ ka ochich kʼal Jajáꞌ, tokot na Pedro, na Jakobo, na Juan, nin tátaꞌ ani nin nánaꞌ an tsidhan. ");
INSERT INTO husNT2005_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ejtal u ukʼnal ti kʼwajat ani u tʼeꞌpinaltsik abal chemnek an tsidhan. Por utsantsik enchéꞌ kʼal na Jesús: ―Yab ki ukʼintsik, an tsidhan yab chemnek ti kʼwajat, u wayalkʼi. ");
INSERT INTO husNT2005_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Por labídhnákʼi tokot, pos jajáꞌtsik in choꞌób alwaꞌ ke chemnek ti kʼwajat. ");
INSERT INTO husNT2005_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Téyná tám bin kʼubak an tsidhan kʼal na Jesús ani in ulu kawidh enchéꞌ: ―Tsidhan, ki chʼakay. ");
INSERT INTO husNT2005_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ejech tám ti ít an tsidhan ani támkʼi ti chʼakay; na Jesús in ulu abal ka pidhan ti kʼapul an tsidhan. ");
INSERT INTO husNT2005_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Nin tátaꞌ ani nin nánaꞌ an tsidhan labantsik tʼajat, por utsantsik kʼal na Jesús abal yab xitaꞌ kin tʼiltsi xantʼéy támun. ");
INSERT INTO husNT2005_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Na Jesús in junku xi lajucháb nin exóbaliltsik, in pidhaꞌ ti chápláb, ti awiltaláb abal kin ejtotsik jeye kin káldhaꞌ xowaꞌkich i atʼax ejattalábtsik ani abal kin jeldhaꞌ xu yaꞌultsik kʼal xowaꞌkich i yawꞌláchtsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","In abaꞌtsik abal kin tʼilaꞌ xan tu takʼix na Dios ani abal kin jeldhaꞌ i yaꞌultsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","In utsaꞌtsik enchéꞌ: ―Yab xataꞌ ka júnaꞌtsik abal ti bél, yab ka júnaꞌ a kwayab, nibal i morrál, nibal i kʼapnél ani nibal i tumín. Tokot ka júnaꞌtsik jún a xekét. ");
INSERT INTO husNT2005_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ba xowaꞌkich an atá xon ti ki ulichtsik ani ki bachʼwat alwaꞌ, ki kʼwajaytsik tajaꞌ asta kin bajaw xowkʼi neꞌech ki kale ba jachanꞌ an chabál. ");
INSERT INTO husNT2005_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ani xon ti yab ki leꞌnátsik ki bachʼwat, ki kale ba jachanꞌ an bitsow ani ka tiniy an pojodh xi palenek ba na akan jelti jun i exól abal yab i bachʼwattsik alwaꞌ kʼal jajáꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Kaletsik tám ani kʼaletsik kwentsal ti kwentsal in tʼilál an alwaꞌ tʼilab ani in jeldhál an yaꞌultsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","An pulek awiltaláb Erodes, in choꞌóbnaꞌ ejtal xowaꞌ in tʼajál na Jesús. Yabich in choꞌób xantʼéy kin chalpay abal taltsik in ulal ke na Juan xu pujax ejnek ti ít. ");
INSERT INTO husNT2005_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Kʼeꞌettsik in ulal ke jaꞌich an tʼiltsix Elías xi xoꞌ ulnekich ani kʼeꞌettsik in ulal ke jaꞌich jun i wejeꞌ tʼiltsix xi ejnek ti ít. ");
INSERT INTO husNT2005_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Por na Erodes in ulu enchéꞌ: ―Na Juan nanáꞌ tʼajat u abnaꞌ ka kotsin tin ókʼ. ¿Jitaꞌ jáꞌ pé tám jechéꞌ an inik xu achʼál u tʼilnal ke in tʼajál yán xataꞌ? Ani na Erodes in leꞌnál tʼajat kin chuꞌu na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Tam ti witsiy an abatwáletsik, in tʼiltsi na Jesús xowaꞌ in tʼajámaltsik. Júnátsik tám pílkʼi kʼal na Jesús ba jun i chabál xon ti yab kʼwajtsidh kʼunat ban bitsow xin bij Betsayda. ");
INSERT INTO husNT2005_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Por tam ti achʼan kʼal an atiklábtsik, wéwnátsik. Bachʼwat an atiklábtsik kʼal na Jesús, tʼiltsin xan tu takʼix na Dios ani jeldhá an yaꞌultsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Tam ti wákléch, utey xi lajucháb nin exóbaliltsik ba na Jesús ani in utsaꞌtsik enchéꞌ: ―Ka utsaꞌich an atiklábtsik ka kʼaléch ti koyol ani abal kin aliy xantʼéy kin kʼapu ban kwentsaltsik xi waꞌach techéꞌ kʼunat, pos techéꞌ xon tu kʼwajat yab xitaꞌ u kʼwajíl. ");
INSERT INTO husNT2005_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Por utsantsik enchéꞌ kʼal na Jesús: ―Ka pidhaꞌ tatáꞌtsik ti kʼapul. Jajáꞌtsik tókʼon enchéꞌ: ―Max yab ku kʼale ki chʼaꞌay i kʼapnél abal ejtal jechéꞌ an atiklábtsik yab neꞌech ki ejto ki kʼapundhaꞌ, pos yab i koꞌol yán i kʼapnél, tokot bóꞌ i pan ani cháb i toꞌol. ");
INSERT INTO husNT2005_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Nin yaníl, boꞌ mil xónaꞌ i iniktsik. Por na Jesús in utsaꞌ enchéꞌ nin exóbaliltsik: ―Ka utsaꞌ ka buxkantsik kweneꞌ ti kweneꞌ, xi juntsik i kweneꞌ, chab inik láju in yaníl. ");
INSERT INTO husNT2005_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Anchanꞌ tin tʼajaꞌtsik ani ejtal buxkan. ");
INSERT INTO husNT2005_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","In téynaꞌ tám na Jesús xi boꞌ an pan ani xi cháb an toꞌol. In telaꞌ walkʼiꞌ ani in pidhaꞌ ti jalbintsixtaláb na Dios kʼal tin kwenta jachanꞌ an kʼapnél. Tam tin pejámalich, in pidhaꞌich tám an exóbaltsik ani an exóbaltsik in pidhaꞌich tám an atiklábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ejtaltsik kʼapúch ani ajwétsik. Más tayíl, in tsʼutsiytsik lajucháb i tʼoknal kʼal an pejmatstaláb xi jilkʼon. ");
INSERT INTO husNT2005_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Jun i kʼij tam ti na Jesús kʼwajat ti ól pílkʼi ani taꞌ jeye ti kʼwajat nin exóbaliltsik tajaꞌ, in konoytsik enchéꞌ: ―Kʼal an atiklábtsik, ¿jitaꞌ pé tin usnal ke Nanáꞌ neye? ");
INSERT INTO husNT2005_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Jajáꞌtsik tókʼon enchéꞌ: ―Taltsik in ulal ke Tatáꞌ i Juan xu pujax, taltsik in ulal ke i Elías xi xeꞌchinék ti tʼiltsix ti wejeꞌ ani kʼeꞌettsik in ulal ke Tatáꞌ jaꞌich jun i wejeꞌ tʼiltsix xi ejnek ti ít. ");
INSERT INTO husNT2005_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Konyattsik tám juní enchéꞌ kʼal na Jesús: ―Ani tatáꞌtsik, ¿jitaꞌ pé ta ulaltsik ke Nanáꞌ neye? Utsan enchéꞌ kʼal na Pedro: ―Tatáꞌ i Kristo, xi takudh kʼal na Dios abal ta takʼix. ");
INSERT INTO husNT2005_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Por punkʼuntsattsik tʼajat kʼal na Jesús abal yab xitaꞌ kin óltsi jechéꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Enchéꞌ ti utsantsik: ―Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik, neꞌech ku watʼnaꞌ yán i yajtsiktaláb, neꞌech kin pojká kʼal in okʼlékil an judíotsik, kʼal an okʼlek páleꞌtsik ani kʼal an okʼtsixtsik xin wilál nin takʼixtal na Dios xin jilám dhutsadh na Moisés. Neꞌech kin chemdhá por tin óxláb a kʼítsá neꞌech kin ejech ti ít. ");
INSERT INTO husNT2005_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Más tayíl in utsaꞌ ejtaltsik enchéꞌ: ―Max jun xitaꞌ in léꞌ ti kin wéwnaꞌ, yejat kin ukʼtsitsiy tinbáꞌ ani ti kin wéwnaꞌ tsudhey ka tsudhey, nibal kin ajay tinbáꞌ maske ka chemdhá. ");
INSERT INTO husNT2005_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Pos xitaꞌ yab in léꞌ kin ukʼtsitsiy tinbáꞌ, neꞌech kin kʼibdhaꞌ nin ejattal ani xitaꞌ kin ukʼtsitsiy tinbáꞌ kʼal Nanáꞌkʼi tu kwenta, neꞌech kin loꞌo. ");
INSERT INTO husNT2005_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Pos, ¿jantʼó ti alwaꞌ max jun xitaꞌ kin bajaw kin kóꞌoy ejtal xowaꞌ waꞌach ban kʼayꞌlá ani kin kʼibdhaꞌ nin ejattal ban kʼibeltaláb? ");
INSERT INTO husNT2005_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Max jun xitaꞌ kin tidhenaꞌ ti kin tʼilaꞌ ani kin tidhenaꞌ kin tʼilaꞌ an alwaꞌ tʼilab, Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik, neꞌech neye ku tidhenaꞌ jajáꞌ tam kin tsích kʼal ejtal nu labidh tʼokát, kʼal ejtal nin labidh tʼokát nu Tatáꞌ ani nin labidh tʼokát jeye an tʼokat abatwáletsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Tsubax tu utsáltsik, ke taltsik xi techéꞌ kʼwajat yab neꞌech ka chemech asta kin chuꞌu okʼox ti takʼix na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Tam ti waxikich a kʼítsá tin ulúmal jechéꞌ, na Jesús kʼadhiy ba jun i chʼén ti ól, junkímte kʼal na Pedro, na Jakobo ani na Juan. ");
INSERT INTO husNT2005_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Lejat na Jesús kʼwajat ti ól, jalkʼun nin wal, dhakniꞌbé tʼajat nin kʼudhkʼúmil ani chʼaxkʼin. ");
INSERT INTO husNT2005_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Xalkʼan tám cháb i iniktsik xi kʼwajat ti tʼilolól kʼal Jajáꞌ. Jachanꞌ an iniktsik, jaꞌich na Moisés ani na Elías, ");
INSERT INTO husNT2005_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","wililidh kʼal i labidh tajaxtaláb ani kʼwajat in tʼiláltsik an chemlá xi neꞌech kin watʼnaꞌ Jerusalén na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Maske na Pedro ani nin juniktsik in léꞌ tʼajat ti wayal, lamkʼantsik nin wal, in chuꞌtsitsik tin labidh tʼokát na Jesús ani in chuꞌutsik jeye xi cháb an iniktsik xi taꞌ ti kʼwajat kʼal Jajáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Tam ti jachanꞌ an iniktsik ówméch ba na Jesús, utsan tám enchéꞌ na Jesús kʼal na Pedro: ―Okʼtsix, ¡alwaꞌ tʼajat abal techéꞌ u kʼwajat! Neꞌech ki tʼajaꞌ óx i padhel, jún abal Tatáꞌ, jún abal na Moisés ani jún abal na Elías. Por na Pedro yab in choꞌób xantʼéy kʼwajat in ulal. ");
INSERT INTO husNT2005_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Lejat kʼwajat ti káw, chaꞌkan jun i tokow, dhabyattsik kʼál ani jikʼeytsik tʼajat tam tin chuꞌu dhabyattsik kʼal an tokow. ");
INSERT INTO husNT2005_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Achʼatmé tám ban tokow jun i káwintaláb xin ulu enchéꞌ: ―Jechéꞌ jaꞌich nu Chakámil xu kʼanidhál tʼajat, ka axtsitsik xowaꞌ in ulal. ");
INSERT INTO husNT2005_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Tam ti chamkʼanich jachanꞌ an káwintaláb, in chuꞌúchtsik tám abal na Jesús kwetém ti kʼwajat. Yabich más xataꞌ in ulutsik ani yab in tʼiltsi xataꞌ ni jun xitaꞌ xowaꞌ in chuꞌutsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Jun tsudhelom, tam ti paꞌáchtsik ban chʼén, kʼal yán i atiklábtsik ti bachʼwat na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Utsan tám enchéꞌ kawidh kʼal jun i inik xi taꞌ jeye ti kʼwajat ba jachanꞌ an atiklábtsik: ―Okʼtsix, tu kontsal ti alwaꞌtaláb abal ti kin chuꞌtsi tu chakámil, pos tokot jáꞌ tu koꞌol. ");
INSERT INTO husNT2005_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","U oxnal kʼal jun i atʼax ejattaláb ani u tʼajnal ka dhájan; u wipindháb ani u dhopopól in ijil bin wiꞌ. U tʼajtsinal xan ti ka leꞌná ani yab u leꞌnáb ka walká. ");
INSERT INTO husNT2005_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","U pakabédhámalich na exóbaliltsik abal kin káldhantsi an ti atʼax ejattaláb, por yab in ejtómaltsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Tókʼon tám enchéꞌ na Jesús: ―¡Atiklábtsik xi jechéꞌ i kʼij, yab lejtal tʼajat i belom ani i walablomtsik tʼajat! ¿Asta jowkʼi koꞌol kin kʼwajay kʼal tatáꞌtsik? ¿Asta jowkʼi koꞌol tu kuxuytsik? Ka tsiꞌdhaꞌ techéꞌ na kwitólil. ");
INSERT INTO husNT2005_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Por tam ti exomich ti utwáb an kwitól, kwajlá chabál kʼal an atʼax ejattaláb ani wipindhá; por na Jesús in kʼwiyaꞌ an atʼax ejattaláb, in jeldhaꞌ an kwitól ani pidhanich tám an tátaꞌláb. ");
INSERT INTO husNT2005_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ejtaltsik laban kʼal nin pulek awiltal na Dios. Lejat kʼwajattsik labnék kʼal xowaꞌ in tʼajál na Jesús, utsantsik enchéꞌ an exóbaltsik kʼal na Jesús: ");
INSERT INTO husNT2005_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―Ka achʼaꞌtsik alwaꞌ jechéꞌ ani yab ka ukʼtsi: Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik, neꞌech kin pidhná abal kin chemdhá kʼal an iniktsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Por an exóbaltsik yab in exbay xantʼéy kʼwajat ti usnaltsik, pos yabtsik u pidhnal kin exbay ani in jikʼnáltsik kin konoy ka wiltsin xantʼéy utsantsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Tujey tám ti káwlíx an exóbaltsik abal in léꞌ kin choꞌóbnaꞌtsik xitaꞌ jáꞌ na más ultaláb xi jajáꞌtsik, ");
INSERT INTO husNT2005_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","por na Jesús in choꞌóbnaꞌ xowaꞌ in chalpayaltsik. In yakʼwánaꞌ tám jun i chakam kwitól, in kʼwajbaꞌ xon ti Jajáꞌ kʼwajat ");
INSERT INTO husNT2005_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ani in utsaꞌtsik enchéꞌ: ―Xitaꞌ kin bachʼu jun i chakam kwitól jelti jechéꞌ kʼal Nanáꞌ tu bij, Nanáꞌ tin bachʼwal; ani xitaꞌ tin bachʼu Nanáꞌ, in bachʼwalich jeye xitaꞌ tin abámal. Pos xitaꞌ xin chaꞌkál más tinbáꞌ kʼal tatáꞌtsik, jaꞌich na más ultaláb. ");
INSERT INTO husNT2005_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Utsan tám enchéꞌ na Jesús kʼal na Juan: ―Okʼtsix, i chuꞌúmal jun i inik ti káldhax atʼax ejattaláb kʼal Tatáꞌ a bij ani wawáꞌ i taxkʼantsi kom yab xeꞌech kʼal wawáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Por tókʼoyat enchéꞌ kʼal na Jesús: ―Yab ka taxkʼantsi, pos xitaꞌ yab tu atʼál, junax kʼal wawáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Tam ti exomich ti kʼunel xowkʼi na Jesús ti neꞌech ka kʼadhích walkʼiꞌ, in ulúch tám abal neꞌchich Jerusalén kʼal ni jun i jíkʼib. ");
INSERT INTO husNT2005_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","In okxiy cháb óx i iniktsik abal ka kʼale ba jun i kwentsal xu takʼnal Samaria ani kin aliy xon ti neꞌech ka koyóchtsik; ");
INSERT INTO husNT2005_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","por yab leꞌná ka bachʼwat kʼal an atiklábtsik xu kʼwajíl tajaꞌ abal in achʼaꞌtsik ke Jerusalén ti neꞌechtsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Tam ti na Jakobo ani na Juan, xi jaꞌich in exóbaliltsik na Jesús, in chuꞌu jechéꞌ, in utsaꞌtsik enchéꞌ na Jesús: ―Ajátik, ¿a léꞌxeꞌ ki konoy ka paꞌay i kʼamal walkʼiꞌ abal ka kʼibdhátsik, jelt xan tin tʼajámal ti wejeꞌ an tʼiltsix Elías? ");
INSERT INTO husNT2005_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Teloloyattsik tám kʼal na Jesús ani kʼwiytsikiyattsik enchéꞌ: ―Yab a choꞌóbtsik xantʼom ejattaláb ti ijtsal ka ulu jechéꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Pos Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik, yab in tsiꞌnek abal ku kʼibdhantsi tin ejattal an iniktsik, in tsiꞌnek abal ku loꞌtsi. Ani kʼaléchtsik tám píl kwentsal. ");
INSERT INTO husNT2005_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Tam ti jajáꞌtsik neꞌech ti bél, utsan enchéꞌ na Jesús kʼal jun i inik: ―Ajátik, u léꞌ tu juniknaꞌ putálkʼi xon ti ki kʼale. ");
INSERT INTO husNT2005_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Tókʼoyat enchéꞌ kʼal na Jesús: ―Na wáxtsik in koꞌol in kʼimáꞌ ani an chʼichintsik in koꞌol in pákʼw; por Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik, yab u koꞌol nibal elaꞌ xon ti kin koyóch. ");
INSERT INTO husNT2005_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Na Jesús in utsaꞌ jeye kʼeꞌet enchéꞌ: ―Wana ta exóbal kʼal Nanáꞌ. Por tókʼoyat enchéꞌ: ―Ajátik, ti kin aytsi okʼox asta ka chemech nu tátaꞌ ani ku joliy, tám neꞌech tu wéwnaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Tókʼoyat enchéꞌ kʼal na Jesús: ―Jilaꞌ ka jolyat an chemélomtsik kʼal xi yabtsik u belom; por tatáꞌ, ki kʼaléch ka tʼilaꞌ abal na Dios in léꞌ kin takʼích an atiklábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Utsan tám juní na Jesús kʼal kʼeꞌet enchéꞌ: ―Ajátik, u léꞌ tu juniknaꞌ, por ti kin aytsi okʼox kin kʼale ku utsaꞌ xi túꞌtsik tu kʼimáꞌ abal in neꞌchich. ");
INSERT INTO husNT2005_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Por utsan enchéꞌ kʼal na Jesús: ―Xitaꞌ kin téynaꞌ nin jobáb an chabál ani in telál tin kúx, yab neꞌech kin ejto kin júnaꞌ lujat an kʼadhíl. Anchanꞌ jeye, xitaꞌ kin tuju kin tʼójontsi na Dios por yab in tʼójontsi kʼal ejtal in ejattal, yab xataꞌ ti alwaꞌ xon tu takʼix na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Más tayíl, an Ajátikláb in takuy jeye ox inik láju i iniktsik abal kin abaꞌ chabtsik ti chabtsik ka okxin ban bitsowtsik ani ban kwentsaltsik xon ti Jajáꞌ neꞌech ka watʼey. ");
INSERT INTO husNT2005_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","In utsaꞌtsik enchéꞌ: ―Tsubax kʼejle, yán tʼajat waꞌach xi neꞌech ti kin belaꞌ, por wéꞌ tʼajat waꞌach xitaꞌ tin tʼilál. Jaxtám, yejat ka pakabédhaꞌtsik na Dios abal kin abaꞌ xitaꞌ ti kin tʼilaꞌ ani kin aliy xitaꞌ neꞌech ti kin belaꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ki kʼaletsik ani ka choꞌóbnaꞌ abal Nanáꞌ tu abáltsik jelti borrego xon ti waꞌach tʼajat i padhum. ");
INSERT INTO husNT2005_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Yab ka júnaꞌtsik i morrál, nibal in bál i tumín, nibal a pajab ani yab ki kubey ka chapnédhaꞌ ni jun xitaꞌ ti bél. ");
INSERT INTO husNT2005_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Tam ki ochichtsik ba jun i atá, ki chapnédhomáchtsik okʼox enchéꞌ: “Ke an kʼijidhtaláb ka waꞌchin echʼekʼi ba jechéꞌ an atá.” ");
INSERT INTO husNT2005_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Max ba jachanꞌ an atá u kʼwajíl i alwaꞌ kʼimádh, neꞌech kin bachʼutsik an chapnédhomtaláb; por max yabaꞌ, an chapnédhomtaláb neꞌech juní ka witsiy ba tatáꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Xon ti ki bachʼwat alwaꞌ, ki koyóchtsik tajaꞌ; ka kʼapu ani ka uchʼaꞌ xowaꞌ jajáꞌtsik ti ki pidhaꞌ, pos an tʼójontsix in tomnál kin bachʼu nin jalbíl. Yab ki xeꞌchintsik túkʼi túkʼi ban atátsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Tam ki ulichtsik ba jun i bitsow xon ti ki bachʼwat alwaꞌ, ka kʼaputsik xowaꞌ ki pidhan; ");
INSERT INTO husNT2005_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","ka jeldhaꞌ an yaꞌultsik xi ka elaꞌ tajaꞌ ani ka utsaꞌtsik enchéꞌ: “Na Dios in léꞌ kin tujúch ti ki takʼiytsik.” ");
INSERT INTO husNT2005_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Por max ki ulich ba jun i bitsow xon ti yab ki bachʼwattsik alwaꞌ, ki kale ban béltsik ani ka utsaꞌtsik enchéꞌ: ");
INSERT INTO husNT2005_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Asta an pojodh xi waꞌach techéꞌ ba na bitsówiltsik xi palenek ba ni akan, i tinyal jelti jun i exól kom tatáꞌtsik yab tu bachʼu alwaꞌ. Por ka choꞌóbnaꞌtsik jechéꞌ, na Dios in léꞌ kin tujúch ti ki takʼiytsik.” ");
INSERT INTO husNT2005_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Tsubax tu utsáltsik ke tam kin bajaw xowkʼi neꞌech an lújundhaxtaláb, jechéꞌ an bitsow, más jaꞌ púlek an yajtsiktaláb neꞌech kin bachʼu ké an yajtsiktaláb xi neꞌech kin bachʼu an atiklábtsik xi kʼwajinek Sodoma. ");
INSERT INTO husNT2005_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","ʼ¡Chʼojontál in chuꞌbíl an atiklábtsik xi Korasín! ¡Chʼojontál in chuꞌbíl an atiklábtsik xi Betsayda! Abal max jechéꞌ an labidh labandhaxtalábtsik xu tʼajámal ba jajáꞌtsik, u tʼajámalak ban bitsowtsik xi Tiro ani Sidón, an atiklábtsik xi tajaꞌ u kʼwajíl, wejeꞌichak tin kʼwajbámaltsik nin kodhow kʼudhkʼúmil ani buxkanékichaktsik ban kʼwixix abal kin xalkʼaꞌ ke in jilámalichtsik ti walablom. ");
INSERT INTO husNT2005_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Por tam kin bajaw xowkʼi neꞌech an lújundhaxtaláb, más jaꞌ púlek an yajtsiktaláb neꞌech kin bachʼu an atiklábtsik xi Korasín ani xi Betsayda ké an yajtsiktaláb xi neꞌech kin bachʼu an atiklábtsik xi Tiro ani Sidón. ");
INSERT INTO husNT2005_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ani tatáꞌtsik, atiklábtsik xi Kapernaúm, ¿a chalpayaltsikxeꞌ ke más neꞌech ki lábtʼajan kʼal na Dios? ¡Pos tu utsáltsik ke yabaꞌ! Neꞌech ki petʼnátsik asta xon ti kʼwajat an chemélomtsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","ʼXitaꞌ ti ki axtsitsik, Nanáꞌ tin axtsal, xitaꞌ ti ki pojkaꞌtsik, Nanáꞌ tin pojkál ani xitaꞌ tin pojkál, in pojkál xi tin abámal. ");
INSERT INTO husNT2005_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Xi ox inik láju an atiklábtsik, u kulbéltsik tʼajat ti witsiy ani enchéꞌ tin ulutsik: ―Ajátik, asta an atʼax ejattalábtsik tu exbantsal tam ki kʼwiyaꞌ kʼal Tatáꞌ ta bij. ");
INSERT INTO husNT2005_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Utsantsik tám enchéꞌ kʼal na Jesús: ―Nanáꞌ u chuꞌu ti kwajlan an lej atʼax adhik tʼajat jelti léy, tam ti petʼná abal chaꞌat. ");
INSERT INTO husNT2005_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Nanáꞌ tu pidhámaltsik ti awiltaláb abal ka kʼachʼiy i chan ani i dhiniy ani yab xataꞌ neꞌech ti ki tʼajtsitsik. Tu pidhámal jeye ti awiltaláb abal ka átantsi ejtal tin cháp an lej atʼax. ");
INSERT INTO husNT2005_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Por yab ki kulbétsik abal i axtsinal kʼal an atʼax ejattalábtsik, ki kulbétsik abal na bij kʼwajatich dhutsadh túꞌ walkʼiꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Támkʼi jachanꞌ, na Jesús u kulbél tʼajat kʼal an kulbétaláb xi pidhan kʼal an Tʼokat Ejattaláb in ulu enchéꞌ: ―Tátaꞌ, tu kʼakʼnál, Okʼóxláb xi takʼix walkʼiꞌ ani chabál, abal a chintsámal jechéꞌ xi chalpadhtsik ani xin exbayaltsik ani a xalkʼantsámal xi yabtsik lej chalpadh. Tátaꞌ, anchanꞌ ta tʼajaꞌ kom anchanꞌ ta leꞌnaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","ʼNu Tátaꞌ tin pidhámalich ejtal xowaꞌ waꞌach. Yab xitaꞌ tin exlál xitam jáꞌ neye Nanáꞌ, xin Chakámláb kʼal a Dios, tokot an Tátaꞌláb tin exlál. Ani yab xitaꞌ in exlál xitam jáꞌ jeye an Tátaꞌláb, tokot Nanáꞌ u exlál ani xitaꞌ Nanáꞌ, xin Chakámláb kʼal na Dios u léꞌ ku pidhaꞌ kin exlaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","In teloloy tám an exóbaltsik ani in utsaꞌ jajáꞌkʼitsik enchéꞌ: ―Kʼijidh tʼajat abal xitaꞌ in chuꞌtal xowaꞌ tatáꞌtsik exom a chuꞌtal, ");
INSERT INTO husNT2005_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","pos tsubax tu utsáltsik, ke yán i tʼiltsixtsik ani i pakdhaꞌ takʼix in leꞌnámal kin chuꞌu xowaꞌ tatáꞌtsik exom a chuꞌtal, por yab in chuꞌutsik; in leꞌnámaltsik jeye kin achʼaꞌ xowaꞌ tatáꞌtsik exom a achʼál, por yab in achʼaꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Jun i okʼtsix xin wilál nin takʼixtal na Dios xin jilám dhutsadh na Moisés, chʼakay kin tawnaꞌ enchéꞌ na Jesús abal kin taktamiy: ―Okʼtsix, ¿jantʼéy yejat ku tʼajaꞌ abal ku ejto ku bachʼu an xeꞌchintaláb xi yab in koꞌol in okʼontal? ");
INSERT INTO husNT2005_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Tókʼoyat enchéꞌ kʼal na Jesús: ―¿Jantʼéy kʼwajat dhutsadh ban takʼixtaláb? ¿Janti ta exbayal? ");
INSERT INTO husNT2005_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","An okʼtsix xin wilál an takʼixtaláb tókʼon enchéꞌ: ―“Ka kʼakʼnaꞌ an Okʼóxláb na Diosil kʼal ejtal a itsích, kʼal ejtal a ejattal, kʼal ejtal a cháp ani kʼal ejtal a chalab ani ka kʼakʼnaꞌ jeye na at kidhtaltsik jelt xan ta kʼakʼnál tabáꞌ.” ");
INSERT INTO husNT2005_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Utsan tám enchéꞌ kʼal na Jesús: ―Alwaꞌ tʼajat xan ta tókʼon. Max ka tʼajaꞌ jechéꞌ, neꞌech ka bachʼu an xeꞌchintaláb xi yab in koꞌol in okʼontal. ");
INSERT INTO husNT2005_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Por an okʼtsix xin wilál an takʼixtaláb, kom yab in léꞌ ka jilkʼon tidhetál tin tamét na Jesús, in konoy enchéꞌ: ―¿Ani jitaꞌ jáꞌ pé tám nu at kidhtal? ");
INSERT INTO husNT2005_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Tókʼoyat enchéꞌ kʼal na Jesús: ―Jun i inik tál ti belal ban bél xi Jerusalén in ókʼóm Jerikó. Yakʼwan kʼal i kwéꞌtsik, kweꞌtsin ejtal xowaꞌ in tsiꞌdhál ani kweꞌtsin asta tin kʼudhkʼúmil; chaꞌwat alwaꞌ, putedhá ani tám ti jilanich. ");
INSERT INTO husNT2005_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Watʼey jun i páleꞌ ba jachanꞌ an bél, por tam tin chuꞌu, yab in tʼajaꞌ ti kʼij, watʼeykʼi. ");
INSERT INTO husNT2005_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Watʼey jeye tajaꞌ jun i lebita, tam tin chuꞌu, watʼeykʼi jeye. ");
INSERT INTO husNT2005_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Por jun i inik xu kʼwajíl Samaria xi taꞌ jeye ti neꞌech ba jachanꞌ an bél, tam tin chuꞌu, in kóꞌontsi ti yajnantsixtaláb. ");
INSERT INTO husNT2005_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Utey tám xon ti kwachat jachanꞌ an inik, in ilálintsi kʼal i aséyte ani kʼal i yajtsik uxnél xon ti chaꞌudh ani in boltsi kʼal i kʼudhkʼum. In kʼadhbaꞌ tám ban koꞌnél xi tál in púnúm, in júnaꞌ ba jun i atá xon tu ulel i kubéltsik ani tajaꞌ tin beletnaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ti jun tsudhelom, tam ti an samaritano neꞌchich, in jixaꞌ cháb i tʼipax tumín, in pidhaꞌ an dhabal kubtaláb atá ani in utsaꞌ enchéꞌ: “Ti kin beletnantsi alwaꞌ jechéꞌ an ti inik ani max ka paku más an tumín, neꞌech tu witsbantsi tam kin witsiy.” ");
INSERT INTO husNT2005_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Konyat tám enchéꞌ an okʼtsix kʼal na Jesús: ―¿Kʼal jowaꞌ xi jechéꞌ óx ta chalpayal tu kʼakʼnáb jechéꞌ an inik xi chaꞌudh kʼal an kwéꞌtsik? ");
INSERT INTO husNT2005_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","An okʼtsix xin wilál an takʼixtaláb in ulu enchéꞌ: ―Xi kʼál ti kóꞌontsat ti yajnantsixtaláb. Utsan tám enchéꞌ kʼal na Jesús: ―Ki kʼaléch ani anílkʼi teye ka tʼajaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Na Jesús in óntsi an bél ani ulich ba jun i kwentsal. Tajaꞌ, jun i mímláb xin bij Marta in bachʼu na Jesús tin kʼimáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Na Marta in koꞌol jun in kidháb xu bijyáb María. Jechéꞌ na na María, buxkan kʼunat bin akan na Jesús abal kin axtsi xantʼéy in ulal. ");
INSERT INTO husNT2005_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Por na Marta in óntsal tokot ti tʼojojól abal yán tʼajat in koꞌol xantʼéy kin tʼajaꞌ. Utey tám ba na Jesús ani in utsaꞌ enchéꞌ: ―Ajátik, ¿Yabxeꞌ a chalpayal ke yejat ti kin tolmiy nu kidháb an tin tʼojojól? Ka utsaꞌ ti kin tolmiy. ");
INSERT INTO husNT2005_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Por tókʼoyat enchéꞌ kʼal na Jesús: ―Marta, Marta, tatáꞌkʼi a tʼojliyal tabáꞌ ani i chalpax kʼal xowaꞌkich. ");
INSERT INTO husNT2005_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Por jún tokot waꞌach xowaꞌ yejat. Na María in takwyámal xowaꞌ más alwaꞌ ani yab neꞌech ka kʼántsin. ");
INSERT INTO husNT2005_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Jun i kʼij kʼwajat ti ól na Jesús, tam ti okʼonich an ti ól, utsan enchéꞌ kʼal jún ti éb nin exóbaliltsik: ―Ajátik, ti ku okʼtsi weye xan ti ku ólan, jelt xan ti na Juan in okʼtsámal nin exóbaliltsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Utsantsik enchéꞌ kʼal na Jesús: ―Tam ki ólantsik, ka ulu enchéꞌ: Tátaꞌ, xi kʼwajat walkʼiꞌ, Tatáꞌ i tʼokat tʼajat. Ti ku takʼích weye. Ka tʼájan techéꞌ ban chabál xowaꞌ Tatáꞌ a léꞌ, jelt xan tu tʼájnal túꞌ walkʼiꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ti ku pidhaꞌ xoꞌ an ti kʼapnél xi yéntsal tsudhey ka tsudhey. ");
INSERT INTO husNT2005_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ti ku pakwlantsi an ti walab, jelt xan ti wawáꞌ i pakwlantsal xitaꞌ tu waltsal. Yab ka walkaꞌ ku taktamiyat, tokot ti ku beletnaꞌ abal yab ku átá kʼal an lej atʼax. ");
INSERT INTO husNT2005_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Utsantsik jeye enchéꞌ kʼal na Jesús: ―Max jún ti éb xi tatáꞌtsik in koꞌol jun in jaꞌúb ani ka ulich chʼejel akal ti bakyáb ani ka utsan enchéꞌ: “Jaꞌúb, ti kin matintsi óx i pan, ");
INSERT INTO husNT2005_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","pos jun u jaꞌúb xi tál ti belal ów, ulich tu kʼimáꞌ ani yab xataꞌ u koꞌol ku pidhaꞌ kin kʼapu.” ");
INSERT INTO husNT2005_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Neꞌech ka tókʼoyat enchéꞌ altákʼi kʼal na jún: “Yabich ti kin tʼojliy; mapudhich tu koꞌol an wiꞌleb ani nu chakámiltsik jéꞌ kwachatsik kʼal nanáꞌ bu waytal. Yab neꞌech ku ejto kin chʼakay tu pidhaꞌ.” ");
INSERT INTO husNT2005_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Por neꞌech tu utsaꞌtsik, maske yab ka chʼakay kin pidhaꞌ xataꞌ abal in jaꞌúb, neꞌech ka chʼakay kin pidhaꞌ abal yab más kin óntsi ti itʼixbédháb ani neꞌech kin pidhaꞌ ejtal xowaꞌ in yéntsal. ");
INSERT INTO husNT2005_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Jaxtám tu utsáltsik enchéꞌ: Ka kontsaltsik na Dios xowaꞌ a léꞌ ani neꞌech ti ki pidhaꞌtsik; ka ayaltsik ani na Dios neꞌech ti ki tolmiy abal ka elaꞌ; ka tawnáltsik na Dios ani neꞌech ti ki axtsitsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Abal xitaꞌ in kontsal na Dios, in bachʼwal xowaꞌ in konyal; xitaꞌ in ayal, in elál ani xitaꞌ in tʼenyal an wiꞌleb, u japtsinal. ");
INSERT INTO husNT2005_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","ʼ¿Awxeꞌ jun i tátaꞌláb xi tatáꞌtsik a kidhtal, max ka kontsin ti pan kʼal in chakámil, neꞌech kin pidhaꞌ ti tʼujub? O ¿max ka kontsin ti toꞌol, neꞌechxeꞌ kin pidhaꞌ ti chan? ");
INSERT INTO husNT2005_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","O ¿kin pidhaꞌ jun i dhiniy max ka kontsin jun i dhaktsokʼ? ");
INSERT INTO husNT2005_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Pos max tatáꞌtsik, xi yab i alwaꞌ inik, a witʼál ka pidhaꞌ xowaꞌ alwaꞌ na chakámiltsik, ¡an Tátaꞌláb xi kʼwajat walkʼiꞌ, más Jaꞌ in witʼál tʼajat! Ani Jajáꞌ neꞌech kin pidhaꞌ an ti Tʼokat Ejattaláb xitaꞌ kʼál ti ka kontsin. ");
INSERT INTO husNT2005_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Na Jesús kʼwajat in káldhál jun i atʼax ejattaláb xi móꞌbédhats kʼál jun i inik ani tam ti kale an atʼax ejattaláb, an móꞌ in ejtóch tám ti káw. An atiklábtsik laban tʼajat kʼal jechéꞌ xowaꞌ in chuꞌu. ");
INSERT INTO husNT2005_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Por taltsik in ulu enchéꞌ: ―Jechéꞌ an inik in káldhál an atʼax ejattalábtsik kʼal tin cháp an lej atʼax, nin lej okʼlékil an atʼax ejattalábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Xi kʼeꞌettsik jeye, abal kin taktamiy na Jesús, in kontsal kin tʼajaꞌ jun i labidh labandhaxtaláb xi tál walkʼiꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Por na Jesús, kom in choꞌób alwaꞌ xantʼéy kʼwajat in chalpayaltsik, in utsaꞌtsik enchéꞌ: ―Max jun i yejcheꞌ bitsow ka kʼéꞌáxin ani ka tujey ti péjéxtsik, neꞌech ka okʼon jachanꞌ an bitsow; ani max xu kʼwajíltsik ba jun i atá ka kʼéꞌáxin, neꞌech jeye ka okʼon. ");
INSERT INTO husNT2005_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Anchanꞌ jeye, max an lej atʼax ka kʼéꞌáxin kʼal nin kidhtaltsik, ¿jan ti neꞌech kin ejto kin kóꞌoy nin awiltal? Jechéꞌ tu utsáltsik abal a ulal ke u káldhál an atʼax ejattalábtsik kʼal tin cháp an lej atʼax; ");
INSERT INTO husNT2005_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","pos max anchanak, ¿kʼal jitaꞌ in cháp tin káldhál an atʼax ejattalábtsik na kidhtaltsik? Anchanꞌ, ti xalkʼantsalichtsik ke i ukʼpinéktsik ta kʼwajat. ");
INSERT INTO husNT2005_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Por Nanáꞌ u káldhál an atʼax ejattalábtsik kʼal tin awiltal na Dios ani kʼal jechéꞌ, u xalkʼanalich ke na Dios tujenekich ti takʼix ba tatáꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","ʼTam jun i likat inik kʼwajat tʼojojodh alwaꞌ ani in belkóm nin kʼimáꞌ, yab neꞌech ka ejtowat ka kweꞌtsin xowaꞌ in koꞌol taꞌpadh tajaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Por max tál jun xitaꞌ más likat ké jajáꞌ ani ka átá, neꞌech tám ka kʼántsin ejtal tin éyamtal xin éynál ti belkol ani neꞌech ka wélchíxnantsat ejtal xowaꞌ in koꞌol. ");
INSERT INTO husNT2005_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","ʼXitaꞌ yab junax kʼal Nanáꞌ, tin atʼál. Ani xitaꞌ yab tin tolmiyal ku utu an atiklábtsik ba na Dios, jachanꞌ, jaꞌich xin tʼajál abal an atiklábtsik yab ka utey ba na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","ʼTam jun i atʼax ejattaláb ka kale ba jun i inik, u xeꞌchinal ba waynek chabáltsik in ayal xon ti ka koyóch. Tam yab kin elaꞌ xon ti ka koyóch, in chalpayal enchéꞌ: “Neꞌech kin witsiy ban inik xon tin kalnek.” ");
INSERT INTO husNT2005_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Tam ka witsiy, in elál jachanꞌ an inik jelti jun i atá xi yab kʼwajtsidh, kʼwetodh ani lejkikidh. ");
INSERT INTO husNT2005_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Neꞌech tám juní ka kʼale ani neꞌech kin ikʼiꞌ búk i atʼax ejattalábtsik xi más atʼax ké jajáꞌ ani ejtal neꞌech ka ochichtsik ti kʼwajíl ba jachanꞌ an inik. Jachanꞌ an inik neꞌech tám ka jilkʼon más kʼibenek ké tam ti kʼwajatwiꞌik. ");
INSERT INTO husNT2005_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Lejat na Jesús kʼwajat in ulal jechéꞌ, jun i mímláb xi taꞌ jeye ti kʼwajat ban atiklábtsik, in ulu kawidh enchéꞌ: ―¡Kʼijidh tʼajat abal an mímláb xi ti waꞌchiyámal ta chakam ani ti pubedhám! ");
INSERT INTO husNT2005_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Por na Jesús in ulu enchéꞌ: ―¡Más kʼijidh abal xitaꞌ xin axtsaltsik xowaꞌ in ulal na Dios ani kin tʼajaꞌ! ");
INSERT INTO husNT2005_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","An atiklábtsik in óntsal ti junkunaltsik malilíl xon ti kʼwajat na Jesús. Tujey ti káw na Jesús ani ulu enchéꞌ: ―Tatáꞌtsik xi kʼwajat jechéꞌ i kʼij, i atʼaxtsik tʼajat ani tin kontsaltsik ku tʼajaꞌ jun i labidh exól; por yab más neꞌech ki pidhantsik kʼeꞌet i exól, tokot an exól jelt xan ti támun kʼal an tʼiltsix Jonás. ");
INSERT INTO husNT2005_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Pos anchanꞌ xan ti na Jonás kʼwajay ti exól abal an atiklábtsik xi Nínibe, anchanꞌ neye Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik, neꞌech kin kʼwajay tin exól abal tatáꞌtsik xi kʼwajattsik xoꞌ jechéꞌ i kʼij. ");
INSERT INTO husNT2005_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","An pulek takʼix mímláb xi Alál, neꞌech ka ejech ti ít tam kin bajaw xowkʼi neꞌech an lújundhaxtaláb, tam ki lújundhá xi kʼwajattsik xoꞌ jechéꞌ i kʼij. Jajáꞌ neꞌech kin xalkʼaꞌ abal tatáꞌtsik, xi kʼwajat xoꞌ jechéꞌ i kʼij, i walbidhtsik. Jajáꞌ tsích ów chabál abal kin axtsi tin chalpadhtal na Salomón ani xoꞌ, techéꞌ in kʼwajat Nanáꞌ, xi jaꞌich jun xitaꞌ xi más púlek ké na Salomón ani yab tin axtsaltsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Xi kʼwajinektsik ban bitsow xi Nínibe, neꞌech ka ejechtsik ti ít tam kin bajaw xowkʼi neꞌech an lújundhaxtaláb, tam ki lújundhá xi kʼwajattsik xoꞌ jechéꞌ i kʼij. Neꞌech kin xalkʼaꞌtsik abal tatáꞌtsik, xi kʼwajat xoꞌ jechéꞌ i kʼij, i walbidhtsik. Jajáꞌtsik in jilaꞌ ti walablom tam ti tʼiltsin an tin káwintal na Dios kʼal na Jonás; ani xoꞌ, techéꞌ in kʼwajat Nanáꞌ, xi jaꞌich jun xitaꞌ xi más púlek ké na Jonás ani yab tin axtsaltsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","ʼYab xitaꞌ in letʼkʼoyal jun i tajbaxtaláb abal kin kʼwajbaꞌ xon ti chinat o abal kin paxkʼiy kʼal jun i kajón. In letʼkʼoyal abal kin kʼwajbaꞌ tʼekʼat ani ka tajbayat xitaꞌ ka ochich. ");
INSERT INTO husNT2005_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Na wal in junwal jelti jun in tajbaxtal na tʼuꞌúl; max na wal alwaꞌ, na tʼuꞌúl putál tin koꞌol an tajaxtaláb; por max yab alwaꞌ, na tʼuꞌúl jelti max kʼwajat ba jikʼwaxtaláb. ");
INSERT INTO husNT2005_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ka kóꞌoy i kwenta kʼal an tajaxtaláb xa koꞌol abal yab táꞌ ka wenkʼon ti jikʼwaxtaláb. ");
INSERT INTO husNT2005_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Pos max ejtal na tʼuꞌúl in koꞌol i tajaxtaláb ani yab in koꞌol ni wéꞌ i jikʼwaxtaláb, ejtal xowaꞌkich, tajax ti neꞌech ka chuꞌu jelti tam i tajbantsáb kʼal jun i tajbaxtaláb. ");
INSERT INTO husNT2005_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Tam ti na Jesús in kubdhaꞌ ti káw, pakabédhá kʼal jun i fariseo abal ka kʼale ti kʼapul tin kʼimáꞌ jechéꞌ an fariseo. Na Jesús ochich altá ani buxkan ban mesa. ");
INSERT INTO husNT2005_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","An fariseo, laban abal in chuꞌu ke yab in tʼakaꞌ okʼox nin kʼubak xan ti jajáꞌtsik in tʼajál tam neꞌech ti kʼapul. ");
INSERT INTO husNT2005_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Por utsan enchéꞌ kʼal na Jesús: ―Tatáꞌtsik an fariseotsik, a tʼaktsal tin kúx an baso ani an talab, por alkʼidh yab a tʼakáltsik. Anílkʼi teye tatáꞌtsik, eblidh i tʼokattsik, por ba na ejattal tokot a chalpómtsik i kwéꞌlách ani i atʼaxtaláb. ");
INSERT INTO husNT2005_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","’¡Yabtsik i chalpadh! ¿Yabxeꞌ a choꞌóbtsik abal xitaꞌ in tʼajámal xi eblidh in tʼajámal jeye xi alkʼidh? ");
INSERT INTO husNT2005_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ka pidhaꞌ an chʼojontáltsik xowaꞌ a kʼanidháltsik tʼajat; anchanꞌ, tʼokatich tám neꞌech ka kʼwajay na ejattal. ");
INSERT INTO husNT2005_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","ʼ¡Chʼojontál a chuꞌbíl, fariseotsik! Xa pidháltsik na Dios xowaꞌ in lujyal jeye kin bachʼu kʼal an menta, an ruda ani ejtal xi más an chʼojóltsik, por yab a tʼajáltsik ti kʼij xowaꞌ lujat nibal i kʼanidhaxtsik jelt xan tu kʼanidhax na Dios. Yejat ka tʼajaꞌtsik xowaꞌ lujat ani ki kʼanidhaxintsik, por yab ka jilaꞌ ka pidhaꞌ xowaꞌ in lujyal na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","ʼ¡Chʼojontál a chuꞌbíl, fariseotsik! abal a kulbetnáltsik ki buxkan ban alwaꞌ kʼwajtalábtsik ban atá xon tu tʼajnal an junkuntaláb ani a kulbetnáltsik ki chapnédhá ti bél kʼal yantam i kʼakʼnaxtaláb. ");
INSERT INTO husNT2005_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","ʼ¡Chʼojontál a chuꞌbíl, okʼtsixtsik ani fariseotsik xi kʼambix! abal a junwaltsik jelti jólimtaláb xi yab tejwaꞌ ani tam jun xitaꞌ kin kʼachʼiy maske yab in choꞌób, u jilkʼonal chʼoꞌodh kʼal an atʼaxtaláb. Anchanꞌ teye tatáꞌtsik, yab tejwaꞌ an atʼaxtaláb xa koꞌoltsik ba na itsích ani xitaꞌ ti ki wéwnaꞌtsik u chʼóꞌnal kʼal na walastalábiltsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Tókʼon tám jún an okʼtsix xin wilál an takʼixtaláb ani in ulu enchéꞌ: ―Okʼtsix, tam a ulal jechéꞌ, tu tejtsalich weye. ");
INSERT INTO husNT2005_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Por utsantsik enchéꞌ kʼal na Jesús: ―¡Chʼojontáltsik teye a chuꞌbíl, okʼtsixtsik xa wilál an takʼixtaláb! abal a utsáltsik kʼeꞌet kin tʼajaꞌ xowaꞌ in ulal an takʼixtaláb ani tatáꞌtsik nibal elaꞌ a tʼajáltsik ti kʼij xowaꞌ a okʼtsixnál. ");
INSERT INTO husNT2005_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","ʼ¡Chʼojontál a chuꞌbíltsik! abal a kubtsal ti exól xon ti jolidh an tʼiltsixtsik xi chemdhats kʼal na wejeꞌ pakéliltsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Kʼal jechéꞌ, u kalel jelti max a ulalichtsik ke alwaꞌ xowaꞌ in tʼajámal na wejeꞌ pakéliltsik; jajáꞌtsik in chemdhaꞌ ani tatáꞌtsik a kubtsal ti exól xon ti jolidh. ");
INSERT INTO husNT2005_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","ʼKom na Dios chalpadh tʼajat, jaxtám tin ulu enchéꞌ: “Neꞌech ku abtsi ti tʼiltsixtsik ani ti abatwáletsik, taltsik neꞌech ka chemdhá ani xi kʼeꞌettsik neꞌech ka atʼan.” ");
INSERT INTO husNT2005_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Atiklábtsik xi xoꞌ jechéꞌ i kʼij, na Dios neꞌech ti tʼajaꞌtsik ka jalbiy nin chemtal ejtal an tʼiltsixtsik asta tam ti tujenek an kʼayꞌlá, ");
INSERT INTO husNT2005_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","asta tam ti chemdhá na Abel asta tam ti chemdhá na Sakarías. Jechéꞌ na Sakarías, jaꞌich xi chemdhá tamchʼejelidh ban pulek atá xon tu kʼakʼnáb na Dios kʼal xon tu kʼwajbáb an pikbaxtaláb. Jaxtám tu utsál atiklábtsik xi jechéꞌ i kʼij, ke na Dios neꞌech ti tʼajaꞌtsik ka jalbiy nin chemtal an tʼiltsixtsik ani an abatwáletsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","ʼ¡Chʼojontál a chuꞌbíl, okʼtsixtsik xa wilál an takʼixtaláb! abal yab a óltsal an atiklábtsik xan ti kin uwaꞌ abal ka takʼyatichtsik kʼal na Dios. Yab a léꞌtsik ki takʼyat kʼal na Dios nibal a walkál ka takʼyattsik kʼal na Dios xin léꞌtsik ka takʼyat. ");
INSERT INTO husNT2005_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Tam ti na Jesús in okʼoy kin ulu ejtal jechéꞌ, an okʼtsixtsik xin wilál an takʼixtaláb ani an fariseotsik, in chakuntsitsik tʼajat na Jesús ani tujeytsik kin taktamiy kʼal yán i konkomixtaláb. ");
INSERT INTO husNT2005_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","In taktamiyal abal in léꞌtsik kin achʼaꞌ max kin ulu jun xataꞌ yab alwaꞌ ani anchanꞌ kin ejtotsik kin ólnaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Tam ti jachanꞌ, junkun yán i mil i atiklábtsik, ke tokotich u níxkʼáx kʼal in yaníl. Na Jesús in okxiy kin utsaꞌ enchéꞌ nin exóbaliltsik: ―Ka kóꞌoytsik i kwenta kʼal nin okʼtsixtal an fariseotsik xin junwal jelti an jilbédhaxtaláb kʼoye. Jechéꞌ, jaꞌich xowaꞌ in kʼambixnálkʼitsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Pos yab waꞌach ni jun xataꞌ chinat xi yab neꞌech ka xalkʼan ani yab waꞌach xataꞌ yab tejwaꞌ xi yab neꞌech ka choꞌóbná tayíl. ");
INSERT INTO husNT2005_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Jaxtám tu utsáltsik, ejtal xowaꞌ a ulúmal ban jikʼwaxtaláb, neꞌech ka achʼan tam kʼij; ani xowaꞌ a ulúmaltsik chinat ani mapudh i wiꞌleb, neꞌech ka ulwat kawidh tin éb an atátsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","ʼJaꞌúbtsik, tu utsál ke yab yejat ka jikʼnaꞌ ni jun xitaꞌ xin ejtowal ti chemdhax ani tayíl yab más xataꞌ in ejtowal kin tʼajaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Por neꞌech tu utsaꞌtsik xitaꞌ yejat ka jikʼnaꞌ: ka jikʼnaꞌtsik na Dios, xi tam ti chemdhámalich, in koꞌol i awiltaláb abal ti ki petʼnaꞌ ban kʼibeltaláb. Jechéꞌ jaꞌich yejat ka jikʼnaꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","ʼ¿Yabxeꞌ u nujwáb bóꞌ i tsʼitsik chʼichin kʼal cháb i tʼipax tumín? Por na Dios yab in ukʼtsal ni jún xi jechéꞌ an chʼichintsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Pos asta na xiꞌíl xa koꞌoltsik ba na ókʼ, ejtal ajidh ti kʼwajat juntsik ti juntsik. Yab ki jikʼeytsik, pos tatáꞌtsik más yán a jalbíl ké yantam i chʼichintsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","ʼTu utsáltsik ejtal ta éb, xitaꞌ ti kin tʼilaꞌ tin tamét an atiklábtsik, Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik, neꞌech neye ku tʼilaꞌ tin tamét nin tʼokat abatwálejiltsik na Dios; ");
INSERT INTO husNT2005_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","por xitaꞌ kin tidhenaꞌ ti kin tʼilaꞌ tin tamét an atiklábtsik, Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik, neꞌech neye ku tidhenaꞌ ku tʼilaꞌ tin tamét nin tʼokat abatwálejiltsik na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","ʼXitaꞌ kʼál ti kin odhbijyat Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik, neꞌech ka pakwlantsat; por xitaꞌ kin odhbijiy an Tʼokat Ejattaláb, yab jaykʼi neꞌech ka pakwlantsat. ");
INSERT INTO husNT2005_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","ʼTam ki júnátsik ban atá xon tu tʼajnal an junkuntaláb, tin tamét i lújundhomtsik o ban awiltalábtsik, yab ki kʼwajaytsik ta chalpax xan ti neꞌech ki tókʼon o xantʼéy neꞌech ka ulu, ");
INSERT INTO husNT2005_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","pos tam kin bajúch xowkʼi neꞌech ta káw, an Tʼokat Ejattaláb, jaꞌich neꞌech ti óltsi xantʼéy neꞌech ka ulu. ");
INSERT INTO husNT2005_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Utsan enchéꞌ na Jesús kʼal jún ti éb xi taꞌ ti kʼwajat ban atiklábtsik: ―Okʼtsix, ka utsaꞌ nu kidháb ti kin pidhaꞌ an ti jiltsixtaláb xi nanáꞌ neye u lujyal. ");
INSERT INTO husNT2005_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Por utsan enchéꞌ kʼal na Jesús: ―Jaꞌúb, Nanáꞌ yab in kʼwajbadh tin lújundhax ani tin wélchíxlix. ");
INSERT INTO husNT2005_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","In ulu jeye enchéꞌ: ―Ka kóꞌoy tʼajat i kwenta kʼal an chʼeꞌneꞌtaláb, pos nin xeꞌchintal jun xitaꞌ yab jaꞌich tu likel kʼal xowaꞌ yán xataꞌ in koꞌol. ");
INSERT INTO husNT2005_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Tʼiltsintsik tám jechéꞌ an ti junbaxtaláb: ―Táꞌwiꞌik ti kʼwajat jun i inik xi tumínladh tʼajat, in tʼajaꞌ in ale ani labey tʼajat. ");
INSERT INTO husNT2005_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Kʼwajay tám kin chalpay enchéꞌ an tumínladh inik: “¿Jantʼéy xoꞌ neꞌech ku tʼajaꞌ? Yab u koꞌol xon ti ku taꞌpaꞌ an kʼapnél.” ");
INSERT INTO husNT2005_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","In chalpay tám enchéꞌ: “U choꞌóbich xantʼéy neꞌech ku tʼajaꞌ. Neꞌech ku paku nu wiltéꞌiltsik abal ku tʼajaꞌ ít más pakdhaꞌ, neꞌech ku taꞌpaꞌ ejtal an kʼapnél ani ejtal xowaꞌ u koꞌol. ");
INSERT INTO husNT2005_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Neꞌech tám ku ulu enchéꞌ tu ejattal: yán xataꞌ u koꞌol taꞌpadh abal ku watʼnaꞌ kʼál yán i tamub; jaxtám xoꞌ, awilich kin kʼwajay koyol koyolkʼi, kʼapul kʼapulkʼi, uchʼal uchʼalkʼi ani in kulbél.” ");
INSERT INTO husNT2005_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Por utsan enchéꞌ kʼal na Dios: “Jaꞌúb, yab tʼajat i chalpadh, pos jechéꞌ i akal neꞌech ki chemech ani xowaꞌ a koꞌol taꞌpadh, ¿jitaꞌ neꞌech kin dhabalnaꞌ?” ");
INSERT INTO husNT2005_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Anchanꞌ in tamwal xitaꞌ in junkuwal i tumín abal jajáꞌkʼi ani yab tumínladh abal a Dios. ");
INSERT INTO husNT2005_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Tayíl, na Jesús in utsaꞌ enchéꞌ nin exóbaliltsik: ―Tu utsáltsik jechéꞌ: Yab ki kʼwajaytsik ta chalpax kʼal xantʼéy neꞌech ka kʼapu abal ki kʼwajay ejat, nibal ki kʼwajay ta chalpaxtsik kʼal xowaꞌ a kʼudhkʼúmil neꞌech ka kʼwajbaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ni ejattal más in jalbíl ké an kʼapnél ani ni tʼuꞌúl más in jalbíl ké ni kʼudhkʼúmil. ");
INSERT INTO husNT2005_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ka telaꞌ an chʼichintsik, yab u óm, yab u kʼójol nibal in taꞌpál xataꞌ ba wilteꞌtsik; por u kʼapundhábtsik kʼal na Dios. ¿Awxeꞌ tatáꞌtsik más wéꞌ a jalbíl ké an chʼichintsik? ");
INSERT INTO husNT2005_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","¿Jitaꞌ xi tatáꞌtsik, max ka kʼwajay tʼajat ti chalpax, neꞌech kin ejto kin nakedhaꞌ tinbáꞌ elaꞌ chʼejel metro más? ");
INSERT INTO husNT2005_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Max yab a ejtowaltsik ka tʼajaꞌ xowaꞌ xi yab lej uluts, ¿jantʼókʼi ta kʼwajat ta chalpaxtsik kʼal xowaꞌkich xi más? ");
INSERT INTO husNT2005_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","ʼKa telaꞌtsik xan tu pakel an wich, yab u tʼojnaltsik nibal u dhutseꞌlix; tu utsáltsik ke nibal an pulek takʼix Salomón, kʼal ejtal nin tumínladhtal, yab kʼudhkʼumlinék labidh jelti an wichtsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","’Pos max na Dios in labidhmédhál anchanꞌ an chʼojól xi xoꞌ kʼwajat ban aleláb ani kalám neꞌech ka tsikan, ¿awxeꞌ na Dios yab neꞌech ti ki kʼudhkʼumliytsik más alwaꞌ? Tatáꞌtsik wéꞌ tʼajat ta belom. ");
INSERT INTO husNT2005_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Pos yab ki xeꞌchintsik ta chalpax ani ta álim xantʼéy ka kʼapu o xantʼéy ka uchʼaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","’An atiklábtsik xi yab u belom, jaꞌich in ayal ejtal jechéꞌ; por tatáꞌtsik, a koꞌol jun a Tátaꞌ xin choꞌób abal a yéntsal ejtal jechéꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ka aliytsik xan ti ki kʼwajay takʼnél kʼal na Dios ani ejtal jechéꞌ neꞌech ka bachʼutsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","ʼYab ki jikʼeytsik, tatáꞌtsik xi tin belálich, yab tʼajat yán ta éb, por na Tátaꞌ in kulbetnámal ti pidhaꞌtsik an ti awiltaláb abal ki takʼxin kʼal Nanáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","’Ka nujutsik xowaꞌ a koꞌol ani ka pidhaꞌ an ti tumín an chʼojontáltsik; anchanꞌ, a junkuwalichtsik i alwaꞌtaláb túꞌ walkʼiꞌ xi yab jaykʼi in koꞌol in okʼontal, xon ti an kwéꞌ yab in ejtowal ka ochich, nibal u kʼapnal kʼal an takúl. ");
INSERT INTO husNT2005_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Pos xon ti kʼwajat xowaꞌ alwaꞌ xi tatáꞌtsik a kulbetnál, tajaꞌ jeye neꞌech ka kʼwajay na ejattal. ");
INSERT INTO husNT2005_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","ʼKi kʼwajaytsik echʼekʼi i tʼojojodh, xeketlidh ani letʼotʼól na tajbaxtaltsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ka tʼajaꞌtsik jáykʼi jelti tam jun i tʼójontsix kʼwajat in aytsím ka witsiy nin ajátik ba jun i tomkixtaláb. Kʼwajat tʼojojodh abal kin japtsi an ti wiꞌleb tam ka ulich tokot kin tʼeney. ");
INSERT INTO husNT2005_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Kʼijidh tʼajat abal an tʼójontsix, xi ka elan ejat tam ka ulich nin ajátik; tsubax tu utsáltsik ke jachanꞌ an tʼójontsix neꞌech ka utsan kʼal nin ajátik ka buxkan ban mesa ani neꞌech ka joꞌtsin an ti kʼapnél kʼal nin ajátik. ");
INSERT INTO husNT2005_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Kʼijidh tʼajat abal jachanꞌ an tʼójontsix xi ka elan ejat kʼal nin ajátik, maske ka ulich chʼejel akal o dhajawichkʼi. ");
INSERT INTO husNT2005_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ka choꞌóbnaꞌtsik jechéꞌ, max jun i dhabal atá in choꞌóbak xáy i ora neꞌech ka ulich an kwéꞌ, yab neꞌech kin walkaꞌ ka japtsin tin kʼimáꞌ abal ka kwéꞌyat. ");
INSERT INTO husNT2005_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","’Anchanꞌ teye tatáꞌtsik, ki kʼwajaytsik i tʼojojodh; pos tam yab xataꞌ a tʼílómtsik, neꞌech kin ulich Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik. ");
INSERT INTO husNT2005_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Konyat tám enchéꞌ kʼal na Pedro: ―Ajátik, ¿a tʼilaꞌ jechéꞌ an junbaxtaláb abal wawáꞌkʼi o abal ejtal tu éb? ");
INSERT INTO husNT2005_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","In ulu enchéꞌ an Ajátikláb: ―An tʼójontsix xi lujat ani chalpadh, jaꞌich xi neꞌech ka punkʼuntsat kin takʼiy xi más nin tʼojnálil an ajátikláb; jajáꞌ jaꞌich xi neꞌech kin ulu xowkʼi ti yejat ka pidhan ti kʼapul xi kʼwajattsik ba jachanꞌ an atá. ");
INSERT INTO husNT2005_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Kʼijidh tʼajat abal an tʼójontsix xi ka elan kʼal nin ajátik tam ka witsiy, in tʼajál xowaꞌ jiltsidh kin tʼajaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Tsubax tu utsáltsik, ke neꞌech ka kʼwajbá ti belkol kʼal ejtal xowaꞌ in koꞌol an ajátikláb. ");
INSERT INTO husNT2005_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Por max an tʼójontsix xi ka jilan punkʼudh, kin chalpay ke nin ajátik yab neꞌech ka witsiy jikʼat ani ka tujey tokot ti kʼapul, ti uchʼal asta ka itey ani ka tujey kin atʼax tʼajtsi xi kʼeꞌet an payꞌlomlábtsik ani an mímlábtsik xi tajaꞌ u tʼojnal, ");
INSERT INTO husNT2005_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","neꞌech ka ulich nin ajátik tam jajáꞌ yab xataꞌ in tʼílóm, nibal in choꞌób xáy i ora; neꞌech tám ka pidhan jun i yajtsiktaláb púlek ani neꞌech ka tʼajtsin anílkʼi jelt xan tin tamwaltsik xi yab alwaꞌ inik. ");
INSERT INTO husNT2005_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","ʼAn tʼójontsix xin choꞌób xantʼéy in léꞌ nin ajátik, por yab tʼojojon nibal kin tʼajaꞌ ti kʼij, yán tʼajat i wichʼateꞌ neꞌech kin bachʼu. ");
INSERT INTO husNT2005_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Por an tʼójontsix xi yab in choꞌób, maske kin tʼajaꞌ xowaꞌ walats, wéꞌ i wichʼateꞌ neꞌech kin bachʼu. Xitaꞌ yán ka pidhan, yán jeye neꞌech ka kontsin; ani xitaꞌ yán ka punkʼuntsat, más yán neꞌech ka kontsin. ");
INSERT INTO husNT2005_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","ʼNanáꞌ in tsiꞌnek techéꞌ ti chabál abal ku tʼajaꞌ jelt xan tin tʼajál an kʼamal, in tsikál xowaꞌ u tʼaꞌíl ani in tʼokwal xowaꞌ yab u tʼaꞌíl; ¡ani u léꞌak max exomichak ti tʼaꞌíl! ");
INSERT INTO husNT2005_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","’Por koꞌol ku watʼnaꞌ okʼox jun i yajtsiktaláb púlek, ¡ani tʼojláb tʼajat ku kuxuy asta kin bajaw xowkʼi neꞌech ka támun jechéꞌ! ");
INSERT INTO husNT2005_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","’¿A chalpayaltsikxeꞌ ke Nanáꞌ in tsiꞌnek abal ku tsiꞌdhaꞌ i kʼijidhtaláb techéꞌ ti chabál? Tu utsáltsik ke yabaꞌ, in tsiꞌnek abal ku tʼajaꞌ i kʼéꞌáxtaláb. ");
INSERT INTO husNT2005_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Por xoꞌ ani tin nakíl an kʼij, bóꞌ xi kʼwajat ba jun i kʼimádh, neꞌech ka kʼéꞌáxin, xi óx neꞌech kin chakuntsi xi cháb ani xi cháb neꞌech kin chakuntsi xi óx. ");
INSERT INTO husNT2005_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","’An tátaꞌláb neꞌech kin chakuntsi nin kwitólil ani an kwitól neꞌech kin chakuntsi nin tátaꞌ; an nánaꞌláb neꞌech kin chakuntsi nin tsidhánil ani an tsidhan neꞌech kin chakuntsi nin nánaꞌ; an mímláb neꞌech kin chakuntsi nin alꞌíb ani an alꞌíbe neꞌech kin chakuntsi nin mím. ");
INSERT INTO husNT2005_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Utsan jeye enchéꞌ an atiklábtsik kʼal na Jesús: ―Tam tatáꞌtsik ka chuꞌu u chʼakíl an tokow xon tu ochel na kʼítsá, támkʼi a ulaltsik abal neꞌech ka ulich i áb ani anchanꞌ u támnal. ");
INSERT INTO husNT2005_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ani tam u wawꞌnal an ikʼ xi alál ti tál, a ulaltsik abal neꞌech tʼajat ka yajbé an kʼakʼal ani anchanꞌ u támnal. ");
INSERT INTO husNT2005_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","’¡Kʼambixtsik! A witʼáltsik ka exbantsi xowkʼi neꞌech ka ulich an áb ani xowkʼi neꞌech ka yajbé tʼajat an kʼakʼal, por yab a ejtowaltsik ka exbantsi xantʼéy exom ti támnal jechéꞌ i kʼij. ");
INSERT INTO husNT2005_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","ʼ¿Jantʼókʼi ti yab a ejtowaltsik ka chalpay xowaꞌ alwaꞌ ka tʼajaꞌ? ");
INSERT INTO husNT2005_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Max jun xitaꞌ ti ki utsbiy abal a waltsámal ani ki éláxin ti bél kʼal jajáꞌ tam i neꞌchich ban awiltaláb, ki lejkin kʼal jajáꞌ abal yabich ti ki utu tin tamét an lújundhom; pos max ti ki utu tajaꞌ, an lújundhom neꞌech ti ki pidhnaꞌ ban yákʼwal ani an yákʼwal neꞌech ti ki baliy ban wikʼaxteꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Tsubax tu utsál ke yab neꞌech ki kale ban wikʼaxteꞌ asta ka jalbiy ejtal xa júnál. ");
INSERT INTO husNT2005_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Támkʼi jachanꞌ, ulich cháb óx i atiklábtsik ani tʼiltsin na Jesús xan ti na Pilato tin chemdhámal i iniktsik xu kʼwajíltsik Galilea. Tʼiltsin abal in xukʼuntsámal tin xichʼál kʼal in xichʼál an koꞌnéltsik xin chemdháltsik abal kin pikbaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Utsantsik enchéꞌ kʼal na Jesús: ―¿A chalpayaltsikxeꞌ ke jachanꞌ an iniktsik xu kʼwajíl Galilea in tamu anchanꞌ abal más jaꞌ walbidhtsik ké xi kʼeꞌet xu kʼwajíltsik táykʼi ba jachanꞌ an bitsow? ");
INSERT INTO husNT2005_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Tsubax tu utsáltsik ke yabaꞌ. Max yabtsik teye ka jilaꞌ ta walablom, anílkʼi teye neꞌech ki chemechtsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","O ¿a chalpayaltsik ke xi lajuwaxik xi chemechtsik tʼuꞌchidh kʼal an pulek tʼiꞌadh tʼujub xu bijyáb Siloé, más jaꞌ walbidhtsik ké xi kʼeꞌet xu kʼwajíltsik Jerusalén? ");
INSERT INTO husNT2005_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Tsubax tu utsáltsik ke yabaꞌ. Max yabtsik teye ka jilaꞌ ta walablom, anílkʼi teye neꞌech ki chemechtsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Tʼiltsintsik tám kʼal na Jesús jechéꞌ an ti junbaxtaláb: ―Jun i inik in tʼayámal jun akanlek i igo bin ale ani kʼale kin chuꞌu max walidh, por yab in eltsi ni jun in walíl. ");
INSERT INTO husNT2005_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","In utsaꞌ tám enchéꞌ an inik xi kʼál tu belkómtsáb an tin ale: “Oxtalich tin tsiꞌil tamub ti tamub ku altsi tin walíl jechéꞌ an teꞌ, por yab jaykʼi u eltsámal. Ka kwajlaꞌich, pos yab xataꞌ ti alwaꞌ ka kʼwajay kubat anikʼi ba nu ale.” ");
INSERT INTO husNT2005_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Por an belkol aleláb tókʼon enchéꞌ: “Ajátik, jilaꞌ bél kubat jechéꞌ i tamub. Neꞌech ku jobtsi an ti chabál xon ti kubat ani neꞌech ku mujtsi an ti lukuk xi alwaꞌ, ");
INSERT INTO husNT2005_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","yab telab max anchanꞌ ka walin; max yab ka walin, neꞌech tám ku kwajlaꞌich.” ");
INSERT INTO husNT2005_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Jun i kʼij, tin kʼítsájil i koyóxnich, na Jesús kʼwajat ti okʼtsix ba jun i atá xon tu tʼajnal an junkuntaláb. ");
INSERT INTO husNT2005_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Tajaꞌ, taꞌ jeye ti kʼwajat jun i mímláb xin koꞌolich lajuwaxik i tamub ti yaꞌul. Kútandhats kʼal jun i atʼax ejattaláb ani jaxtám ti yab in ejtowal ni wéꞌ ka lujkun. ");
INSERT INTO husNT2005_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Tam ti chuꞌtat kʼal na Jesús, kanyat ani utsan enchéꞌ: ―Mímláb, i jeléch kʼal an yawꞌlách xa koꞌol. ");
INSERT INTO husNT2005_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","In kʼwajbaꞌ tám nin kʼubak ban mímláb ani támkʼi jachanꞌ ti lujkun an mímláb. An mímláb tujey tám kin pubédhantsi tin bij na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Por an inik xu okʼlek ba jachanꞌ an atá xon tu tʼajnal an junkuntaláb, chakuy abal na Jesús in jeldhaꞌ an mímláb tin kʼítsájil i koyóxnich ani in utsaꞌ enchéꞌ an atiklábtsik: ―Waꞌach akak a kʼítsá xowkʼi ti alwaꞌ ku tʼójon; ki tsíchtsik jachanꞌ a kʼítsá abal ki jeldhátsik ani yab tam in kʼítsájil i koyóxnich. ");
INSERT INTO husNT2005_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Tókʼon tám enchéꞌ na Jesús: ―Kʼambixtsik, ¿yabxeꞌ a wiláltsik na bákajil o na burrujil tam in kʼítsájil i koyóxnich abal ka júnaꞌtsik ka uchʼandhaꞌ? ");
INSERT INTO husNT2005_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","’Jechéꞌ an mímláb xu kidhtaláb jeye kʼal na Abraham, xu kóꞌyáb kʼal an lej atʼax ti yaꞌul lajuwaxikich i tamub kʼal jechéꞌ an yawꞌlách, ¿awxeꞌ yab in tomnál ka jeldhá tam in kʼítsájil i koyóxnich? ");
INSERT INTO husNT2005_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Tam ti na Jesús in ulu jechéꞌ, ejtaltsik xi kʼál tu atʼnal na Jesús, tidhebétsik; por ejtal xi más an atiklábtsik u kulbél tam tin chuꞌutsik an pakdhaꞌ labidh labandhaxtaláb xin tʼajál na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","In ulu tám enchéꞌ na Jesús: ―¿Jantʼéy in junwal xan tu takʼix na Dios ani jantʼokʼál ti neꞌech ku ejto ku junbay? ");
INSERT INTO husNT2005_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","In junwal jelti jun in itsích i mostasa xi jun i inik in tʼayál bin ale, u pubel tʼajat asta kin bajaw jelti jun i teꞌ. U pubel tʼajat, ke an chʼichintsik xi xeꞌech ti jumumúl in tʼajáltsik nin pákʼw bin kʼweꞌéltsik jechéꞌ an teꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","In ulu jeye enchéꞌ na Jesús: ―¿Jantʼokʼál ti neꞌech ku ejto ku junbay xan tu takʼix na Dios? ");
INSERT INTO husNT2005_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","In junwal jelti an jilbédhaxtaláb kʼoye xi jun i mímláb in xukʼyal kʼál ox lejab i cheꞌedh trigo ani in jilbédhál ejtal an xoꞌkadh cheꞌedh trigo. ");
INSERT INTO husNT2005_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Tam ti na Jesús neꞌech ti belal abal Jerusalén, u kʼwajíl ti okʼtsix ban bitsowtsik ani ban kwentsaltsik xon tu watʼel. ");
INSERT INTO husNT2005_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Konyat enchéꞌ kʼal jun xitaꞌ: ―Ajátik, ¿wéꞌxeꞌ tʼajat xu loꞌel? Jajáꞌ tókʼon enchéꞌ: ");
INSERT INTO husNT2005_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―Ka tʼajaꞌtsik an chápláb abal ka ejto ki kʼwajaytsik takʼnél kʼal na Dios, jelti an chápláb xi yejat ka tʼajaꞌtsik tam a léꞌ ki ochich ba jun i xuyat wiꞌleb. Tsubax tu utsáltsik ke yán tʼajat xi neꞌech kin leꞌnaꞌ ka kʼwajay takʼnél kʼal na Dios, por yabtsik neꞌech kin ejto. ");
INSERT INTO husNT2005_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Tam ka chʼakay an dhabal atá ani kin mapuy an wiꞌleb, tatáꞌtsik, xi jilkʼonék eléb, neꞌech ka tʼeneytsik an wiꞌleb ani neꞌech ka ulutsik enchéꞌ: “Ajátik ti ku japtsi weye.” Por Jajáꞌ neꞌech ti ki tókʼoytsik enchéꞌ: “Yab tu exláltsik nibal u choꞌób xon ta tál.” ");
INSERT INTO husNT2005_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Neꞌech tám ki tujeytsik ka utsaꞌ enchéꞌ: “U kʼwajinek pé tu kʼapul ani tu uchʼal junax kʼal Tatáꞌ ani Tatáꞌ i okʼtsixnék ba ni bitsówil.” ");
INSERT INTO husNT2005_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Por Jajáꞌ neꞌech ti ki tókʼoytsik enchéꞌ: “Tu utsálichtsik ke yab tu exlál nibal u choꞌób xon ta tál. ¡Ki wixkʼintsik techéꞌ kʼal Nanáꞌ, ejtal tatáꞌtsik xa tʼajál xowaꞌ yab alwaꞌ!” ");
INSERT INTO husNT2005_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Tajaꞌ neꞌech ki ukʼintsik ani neꞌech ti rechʼechʼél na kamab tam ka chuꞌutsik abal na Abraham, na Isák, na Jakob ani ejtal an tʼiltsixtsik kʼwajat xon tu takʼix na Dios ani tatáꞌtsik i jilan eléb. ");
INSERT INTO husNT2005_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Pos neꞌech ka tsích an atiklábtsik xi ebál ani alál, xon tu kalel na kʼítsá ani xon tu ochel jeye abal ka buxkantsik ti kʼapul xon tu takʼix na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Jachanꞌ i kʼij, taltsik xi xoꞌ kʼwajat kuxlek, neꞌech ka kʼwajay ultaláb ani taltsik xi xoꞌ kʼwajat ultaláb, neꞌech ka kʼwajay kuxlek. ");
INSERT INTO husNT2005_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Támkʼi jachanꞌ a kʼítsá, ulich cháb óx i fariseotsik ani utsan enchéꞌ na Jesús: ―Ki kʼaléch píl, pos na Erodes in léꞌ ti ki chemdhaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Por Jajáꞌ in tókʼoytsik enchéꞌ: ―Ki kʼaletsik ani ka utsaꞌ enchéꞌ jachanꞌ an inik xin koꞌol in chalab jelti a wáx: “Ka telaꞌ, xoꞌ ani kalám u káldhál an atʼax ejattalábtsik, u jeldhál an yaꞌultsik ani chabkʼiꞌ neꞌech ku okʼoy.” ");
INSERT INTO husNT2005_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Por xoꞌ koꞌol ku óntsi nu bélil, kalám ani chabkʼiꞌ jeye, pos yab in tomnál ke jun i tʼiltsix ka chemdhá píl bitsow ani yab Jerusalén. ");
INSERT INTO husNT2005_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","In ulu jeye enchéꞌ na Jesús: ―¡Atiklábtsik xi Jerusalén, xa chemdhál an tʼiltsixtsik ani a tʼujbayal xi abtsinaltsik kʼal na Dios abal ti ki óltsi an tin tsubaxtalábil! Yáníl u leꞌnaꞌ ku junku na chakámiltsik, jelt xan ti an pákʼwlam kwitaꞌ in junkuwal nin tsʼitsik tʼám abal kin pákʼwnaꞌ tin ál nin sutsʼútsʼ, por yab a leꞌnaꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ka achʼaꞌtsik xantʼéy neꞌech tu utsaꞌ, an pulek atá xon ta kʼakʼnáltsik na Dios, neꞌech ka walbá. Tu utsáltsik abal yab más neꞌech ki witsiy ti kin chuꞌutsik, asta kin bajaw an kʼij tam tatáꞌtsik neꞌech ka ulutsik enchéꞌ: “¡Lábtʼajadh ti kʼwajat xi tál tin bij an Okʼóxláb!” ");
INSERT INTO husNT2005_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Jun i kʼij, tin kʼítsájil i koyóxnich, na Jesús kʼalnek ti kʼapul bin kʼimáꞌ jun in okʼlékil i fariseo ani xi kʼeꞌet an fariseotsik taꞌ ti kʼwajat ti kwáchix. ");
INSERT INTO husNT2005_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Táꞌ jeye ti kʼwajat tajaꞌ tin tamét na Jesús, jun i inik xu yaꞌul kʼal i mál. ");
INSERT INTO husNT2005_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Konyattsik tám enchéꞌ kʼal na Jesús an okʼtsixtsik xin wilál nin takʼixtal na Dios xin jilám dhutsadh na Moisés ani an fariseotsik: ―¿Awilxeꞌ ka jeldhá jun i yaꞌul tam in kʼítsájil i koyóxnich o yabaꞌ? ");
INSERT INTO husNT2005_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Por jajáꞌtsik yab kʼuchun. Téyná tám an yaꞌul bin kʼubak kʼal na Jesús, jeldhá ani in utsaꞌ tám ka kʼaléch. ");
INSERT INTO husNT2005_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Utsan tám enchéꞌ an fariseotsik kʼal na Jesús: ―¿Jitaꞌ xi tatáꞌtsik a kidhtal, max nin burrujil o nin bákajil ka balkʼin ba jun i mom, yab in jixál támkʼi maske in kʼítsájil i koyóxnich? ");
INSERT INTO husNT2005_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ani yabtsik in ejto ka tókʼon ni wéꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Tam ti na Jesús in chuꞌu ti tákultsik an ti ultaláb kʼwajtaláb ban mesa xi kanidhtsik ba jun i tomkixtaláb, in pidhaꞌtsik jechéꞌ an ti takʼixtaláb: ");
INSERT INTO husNT2005_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―Tam jun xitaꞌ ti kaniy ta ajíblom ba jun i tomkixtaláb, yab ki buxkan ban kʼwajtaláb xi ultaláb, yab telab ka ulich jun xitaꞌ xi más uluts ké tatáꞌ ");
INSERT INTO husNT2005_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ani ka ulich ti ki utsaꞌ enchéꞌ xi ti kanyámal: “Ka pidhaꞌ jachanꞌ an ti kʼwajtaláb na jeꞌ jún.” Tidhetálich tám abal tatáꞌ ki kʼale ta buxkanal ban kʼwajtaláb xi más kuxlek. ");
INSERT INTO husNT2005_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Tam ki kanyat ba jun i tomkixtaláb, más alwaꞌ ki buxkan ban kʼwajtaláb xi kuxlek; abal tam ka ulich xi ti kanyámal, ti ki utsaꞌ enchéꞌ: “Jaꞌúb, jéꞌ ki watʼey ta buxkanal ban koytaláb xi más ultaláb.” Anchanꞌ neꞌech ki kʼakʼná kʼal xi taꞌ buxutsik ban mesa junax kʼal tatáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Pos xitaꞌ in tʼekʼál tinbáꞌ, neꞌech ka chaꞌká; ani xitaꞌ in chaꞌkál tinbáꞌ, neꞌech ka tʼekʼbá. ");
INSERT INTO husNT2005_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","In utsaꞌ jeye enchéꞌ an inik xi kʼál ti kanidh: ―Tam ka tʼajaꞌ jun i kʼapúxnich, yab ka kaniy na jaꞌúbtsik, nibal na kidhábtsik, nibal na exlowáltsik, nibal na at kʼimádh xi tumínladh; pos tam kin tʼajaꞌtsik jeye i kʼapúxnich, neꞌech jeye ti ki kaniy ani anchanꞌ, jelti max i witsbantsábich. ");
INSERT INTO husNT2005_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Tam ka tajaꞌ jun i ajib, más alwaꞌ ka kaniy an chʼojontáltsik, an mochoꞌtsik, an kʼwechʼeꞌtsik ani an jokʼoltsik, ");
INSERT INTO husNT2005_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","ani kʼijidh tʼajat neꞌech ki kʼwajay. Pos jajáꞌtsik yab neꞌech kin ejto ti jalbintsi, por tatáꞌ, neꞌech ka bachʼu an chʼejwalixtaláb tam ka ejdhá ti ít an atiklábtsik xi alwaꞌ inik. ");
INSERT INTO husNT2005_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Tam tin achʼaꞌ jechéꞌ, jún ti éb xi taꞌ ti buxutsik ban mesa, in utsaꞌ enchéꞌ na Jesús: ―¡Kʼijidh tʼajat abal xitaꞌ xi neꞌech ti kʼapul xon tu takʼix na Dios! ");
INSERT INTO husNT2005_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Utsan tám enchéꞌ kʼal na Jesús: ―Jun i inik in tʼajaꞌ jun i pulek kʼapúxnich ani in abnaꞌ ka kanyat yán i atiklábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Tam ti kʼwajatich tʼojojodh an kʼapnél, in abaꞌ nin tʼojnálil kin utsaꞌ enchéꞌ xi kʼwajattsik kanidh: “Ki tsíchichtsik, tʼojojodhich ejtal.” ");
INSERT INTO husNT2005_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Por ejtaltsik in konoy ka pakwlantsat abal yab neꞌech kin ejtotsik ka kʼale. Xi jidhtal in ulu enchéꞌ: “Talél tu chʼaꞌay jun i chabál ani koꞌol kin kʼale ku chuꞌu; tu kontsal ti alwaꞌtaláb abal ti kin pakwlantsi.” ");
INSERT INTO husNT2005_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Jún in ulu jeye enchéꞌ: “U chʼaꞌyámal boꞌ kubél i bákatsik xu kínal ani u léꞌ kin kʼale ku chuꞌu max alwaꞌ; tu kontsal ti alwaꞌtaláb abal ti kin pakwlantsi.” ");
INSERT INTO husNT2005_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ani jún in ulu jeye enchéꞌ: “Talél tin tomkin ani jaxtám ti yab neꞌech ku ejto kin kʼale.” ");
INSERT INTO husNT2005_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Tam ti witsiy an tʼójontsix, in utsaꞌ ejtal jechéꞌ nin ajátik. Chakuy an ajátikláb ani in utsaꞌ enchéꞌ nin tʼójontsixil: “Ki kʼale jikʼatkʼi ban pakdhaꞌ bél ani ban chʼikwdhaꞌ bél xi waꞌach techéꞌ ban bitsow ani ka kaniy ka tsích techéꞌ xi chʼojontáltsik, xi mochoꞌtsik, xu kʼwechʼeꞌtsik ani xu jokʼoltsik.” ");
INSERT INTO husNT2005_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Más tayíl, in ulu enchéꞌ an tʼójontsix: “Ajátik, u tʼajámalich xan ta ulúmal ani bél tʼajat ejtidh altá.” ");
INSERT INTO husNT2005_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Utsan tám enchéꞌ an tʼójontsix kʼal an ajátikláb: “Ki kʼale putálkʼi ban pakdhaꞌ bél ani ban béltsik xi tin waltsik an bitsow ani ka tʼajtsitsik ti chápláb ka ochich abal ka tsʼutsich nu kʼimáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Tu utsáltsik, ke ni jún xi jachanꞌ xu kanyámaltsik okʼox, yab neꞌech ka ochich ba nu kʼimáꞌ ti kʼapul.” ");
INSERT INTO husNT2005_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Kʼal yán i atiklábtsik ti wewkómte na Jesús, chawꞌkʼilách ani in utsaꞌtsik enchéꞌ: ");
INSERT INTO husNT2005_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―Max jun xitaꞌ ka utey kʼal Nanáꞌ, por in kʼanidhál más nin tátaꞌ, nin nánaꞌ, nin tomtal, nin chakámiltsik, nin kidhábtsik, nin ixámtsik ani in kʼanidhál tʼajat tinbáꞌ, yab neꞌech kin ejto ti kin wéwnaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Aníl jeye, max jun xitaꞌ in léꞌ ti kin wéwnaꞌ ani yab in léꞌ kin watʼnaꞌ i yajtsiktaláb o i chemlá kʼal Nanáꞌkʼi tu kwenta, yab neꞌech kin ejto ti kin wéwnaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Max jun xitaꞌ xi tatáꞌtsik in léꞌ kin kubaꞌ jun i atá pulek, ¿yabxeꞌ neꞌech ka buxkan okʼox kin chalpay xatʼwaꞌ neꞌech kin paku abal kin chuꞌu max neꞌech kin ejto kin okʼoy? ");
INSERT INTO husNT2005_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Pos max yab kin tʼajaꞌ anchanꞌ, kin kʼwajbantsích tokot okʼox an tin akan ani yab kin ejto kin okʼoy, neꞌech tám ka labídhná kʼal ejtal xitaꞌ kʼál ti ka chuꞌtat ");
INSERT INTO husNT2005_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","ani neꞌech kin ulutsik enchéꞌ: “Jechéꞌ an inik in tuju kin tʼajaꞌ jun i atá pulek ani yab in ejto kin okʼoy.” ");
INSERT INTO husNT2005_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","O max jun i pulek takʼix neꞌech ti péjéx kʼal kʼeꞌet i pulek takʼix, ¿yabxeꞌ neꞌech ka buxkan okʼox kin chalpay max neꞌech kin ejto kin tomnaꞌ kʼal láju mil i soldadotsik, xi tál kʼal jun inik mil i soldadotsik? ");
INSERT INTO husNT2005_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Max yab neꞌech kin ejto kin tomnaꞌ, neꞌech tám kin abaꞌ nin abatwálejiltsik abal kin konoy i lejkintaláb tam na jún an pulek takʼix ów bél ti tál ani anchanꞌ yabich tám ka péjéxin. ");
INSERT INTO husNT2005_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Anchanꞌ jeye, max jun xitaꞌ xi tatáꞌtsik yab kin jilaꞌ ejtal xowaꞌ in koꞌol, yab neꞌech kin ejto ka tsích ti exóbal kʼal Nanáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","ʼAn atʼem alwaꞌ, por max ka xawꞌmé, yabich xataꞌ ti neꞌech ka éyná. ");
INSERT INTO husNT2005_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Yab alwaꞌ abal an chabál nibal abal ka xukʼuxná an ti alwaꞌ lukuk, tokot abal ka wakʼlá. Xin koꞌol in ochʼoxtal alwaꞌ, kin exbay xowaꞌ u ulal. ");
INSERT INTO husNT2005_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ejtal an bachʼkʼul jalbixtaláb ani an walablomtsik, u uteltsik ba na Jesús abal kin axtsi xantʼéy in ulal. ");
INSERT INTO husNT2005_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Jaxtám tu kawyáb na Jesús kʼal an fariseotsik ani kʼal an okʼtsixtsik xin wilál an takʼixtaláb, in ulaltsik enchéꞌ: ―Jechéꞌ an inik u junkunal kʼal an walablomtsik ani u kʼapul junax kʼal jajáꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Kʼwajbantsattsik tám jechéꞌ an junbaxtaláb kʼal na Jesús: ");
INSERT INTO husNT2005_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―¿Jitaꞌ xi tatáꞌtsik, max in koꞌol boꞌ inik i borregotsik ani kin kʼibdhaꞌ jún, yab neꞌech kin jilaꞌ xi cheꞌ inik lajubeléju ban chabál xon ti yab kʼwajtsidh abal ka kʼale kin aliy na jún xi kʼibchonék asta kin elaꞌ? ");
INSERT INTO husNT2005_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Tam kin elaꞌ, kulbenek neꞌech kin okobnaꞌ ");
INSERT INTO husNT2005_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ani tam ka ulich tin kʼimáꞌ, neꞌech kin kaniy ejtal nin jaꞌúbtsik, nin at kʼimádhtsik ani neꞌech kin utsaꞌtsik enchéꞌ: “Ki kulbétsik kʼal nanáꞌ, abal u elaꞌ an borrego xu kʼibdhámal.” ");
INSERT INTO husNT2005_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Tu utsáltsik abal u waꞌchinal más i kulbétaláb túꞌ walkʼiꞌ tam jun i walablom kin jilaꞌich ti walablom ké kʼal xi cheꞌ inik lajubeléju i atiklábtsik xi alwaꞌ ani yabtsik yejat kin jalkʼuy nin chalab. ");
INSERT INTO husNT2005_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","ʼAníl jeye, ¿jitam mímláb xin koꞌol láju i tʼipax tumín ani kin kʼibdhaꞌ jún, yab neꞌech kin letʼkʼoy jun i tajbaxtaláb ani kin kʼwetoy putál an altá abal kin aliy kʼal yantam i kwenta asta kin elaꞌ? ");
INSERT INTO husNT2005_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Tam kin elaꞌ, neꞌech kin kaniy ejtal nin jaꞌúbtsik, nin at kʼimádhtsik ani neꞌech kin utsaꞌtsik enchéꞌ: “Ki kulbétsik kʼal nanáꞌ abal u elaꞌ an tʼipax tumín xu kʼibdhámal.” ");
INSERT INTO husNT2005_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Tu utsáltsik abal u kulbéltsik tʼajat nin tʼokat abatwálejiltsik na Dios tam jun i walablom kin jilaꞌich ti walablom. ");
INSERT INTO husNT2005_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","In ulu jeye enchéꞌ na Jesús: ―Jun i inik in koꞌol cháb in kwitóliltsik ");
INSERT INTO husNT2005_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","ani an kwitól xi tayíl in utsaꞌ enchéꞌ nin tátaꞌ: “Tátaꞌ, ti kin pidhaꞌich an ti jiltsixtaláb xi nanáꞌ neye neꞌech ku lujuy ku bachʼu.” Pidhantsik tám kʼal an tátaꞌláb xowaꞌ jajáꞌtsik in lujyal kin bachʼu. ");
INSERT INTO husNT2005_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Tam ti watʼéch cháb óx a kʼítsá, an tayíl kwitól in nuju ejtal xowaꞌ jajáꞌ in lujuy kin bachʼu. Kʼal an tumín xin bachʼu, kʼale ti kʼwajíl píl chabál, xon ti kʼwajay kin atʼax paku ejtal an tumín xin bachʼúmal. ");
INSERT INTO husNT2005_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Por tam tin pakúmalich ejtal an tumín, waꞌchin jun i pulek kʼaꞌínab ba jachanꞌ an chabál ani jajáꞌ tujey jeye kin achʼaꞌ i kʼaꞌínab. ");
INSERT INTO husNT2005_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Kʼale tám kin kontsi ti tʼojláb jun i inik xu kʼwajíl ba jachanꞌ an chabál ani aban ti belkol olomtsik bin ale jachanꞌ an inik. ");
INSERT INTO husNT2005_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Kom u kʼaꞌílich tʼajat, in léꞌakich max kin kʼaptsi tin kʼapwál an olomtsik, por yab u pidhnal kʼal ni jun xitaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Kʼwajay tám ti chalpax enchéꞌ: “¡Yán i tʼojnaltsik bin kʼimáꞌ nu tátaꞌ u kʼapultsik alwaꞌ ani nanáꞌ techéꞌ in kʼwajat tin chemel kʼal i kʼaꞌínab! ");
INSERT INTO husNT2005_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Neꞌech kin witsiy bin kʼimáꞌ nu tátaꞌ ani neꞌech ku utsaꞌ enchéꞌ: Tátaꞌ, u waltsámal na Dios ani tatáꞌ teye; ");
INSERT INTO husNT2005_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","yabich in tomnál kin bijyat ke in chakámláb kʼal tatáꞌ; ti kin bachʼu neye jelti jun a tʼojnálil.” ");
INSERT INTO husNT2005_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","In tuju tám an bél ani witsiy bin kʼimáꞌ nin tátaꞌ. ʼTam ti bél ów ti tál, chuꞌtat kʼal nin tátaꞌ ani kóꞌontsat ti yajnantsixtaláb. Ájlách abal ka kʼale ti tamwáb, mulukʼná ani chʼuchʼbayat. ");
INSERT INTO husNT2005_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","In ulu tám enchéꞌ jachanꞌ an kwitól: “Tátaꞌ, u waltsámal na Dios ani tatáꞌ teye, yabich in tomnál kin bijyat ke in chakámláb kʼal tatáꞌ.” ");
INSERT INTO husNT2005_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Por an tátaꞌláb in utsaꞌ enchéꞌ nin tʼojnáliltsik: “Ka jixaꞌtsik jikʼat an alwaꞌ xeketláb, ka xeketliy ani ka pajbiy; ka kʼwajbantsi jeye ti aniyo bin tsʼútsbixtal. ");
INSERT INTO husNT2005_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ka tsiꞌdhaꞌtsik an baka xi más kʼotsól ani ka chemdhaꞌ. Neꞌech tu kʼapul ani neꞌech ki tʼajaꞌ i ajib. ");
INSERT INTO husNT2005_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Pos jechéꞌ nu chakámil kʼwajatwiꞌik jelti max chemnek ani xoꞌ jelti max ejnekich ti ít; kʼibchonékwiꞌik ti kʼwajat ani xoꞌ i elaꞌich.” Tujeytsik tám kin tʼajaꞌ i ajib. ");
INSERT INTO husNT2005_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","ʼTam ti jachanꞌ, an okʼox kwitól xeꞌech ban aleláb; por tam tu witsélich ani exomich ti kʼunel ban atá, in achʼaꞌ an tʼénlách ani an bixmách. ");
INSERT INTO husNT2005_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","In kaniy tám jun ti éb an tʼojnaltsik ani in konoy xantʼéy exom ti tʼajnal. ");
INSERT INTO husNT2005_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Utsan enchéꞌ kʼal jachanꞌ an tʼojnal: “Exom i ajib kom na kidháb witsích; na tátaꞌ in abnaꞌ ka chemdhá an baka xi más kʼotsól abal na kidháb witsiy juntam anikʼi.” ");
INSERT INTO husNT2005_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Por an okʼox kwitól chakuy ani kom yab in léꞌ ti ochel altá, kale ti pakabédháb kʼal nin tátaꞌ abal ka ochich. ");
INSERT INTO husNT2005_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Jechéꞌ an okʼox kwitól in utsaꞌ enchéꞌ nin tátaꞌ: “Tatáꞌ, a choꞌób xáyich i tamub tu tʼójontsámal ani yab jaykʼi tu chʼikat tʼajtsámal ta takʼixtal; por yab jaykʼi tin elaꞌ pidhámal jun i chakam chibo abal ku chemdhaꞌ ani ku ajíbnaꞌ kʼal nu jaꞌúbtsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Por xoꞌ ulich jechéꞌ na chakámil, xi ti atʼax pakwtsámal ta tumínal kʼal i junkux inik uxumtsik ani a chemdhantsal kin kʼapu an baka xi más kʼotsól.” ");
INSERT INTO husNT2005_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Utsan tám enchéꞌ kʼal nin tátaꞌ: “Kwitól, tatáꞌ echʼekʼi techéꞌ i kʼwajat kʼal nanáꞌ ani ejtal xowaꞌ u koꞌol, a dhabal teye.” ");
INSERT INTO husNT2005_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Por xoꞌ alwaꞌ ki tʼajaꞌ i ajib ani ku kulbé, pos na kidháb xi kʼwajatwiꞌik jelti max chemnek, xoꞌ jelti max ejnekich ti ít; kʼibchonékwiꞌik ti kʼwajat ani xoꞌ i elaꞌich. ");
INSERT INTO husNT2005_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Na Jesús in utsaꞌ jeye enchéꞌ nin exóbaliltsik: ―Táꞌwiꞌik ti kʼwajat jun i tumínladh inik xin koꞌol jun i okʼlek tʼojnal ani kʼale ti óltsinal an tumínladh inik ke exom ti atʼax pakwtsinal tin tumínal kʼal jechéꞌ an okʼlek. ");
INSERT INTO husNT2005_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Abná tám ti kanyáb kʼal nin ajátik ani utsan enchéꞌ: “¿Jantʼéy in éy xowaꞌ u achʼál in usnal kʼal tatáꞌ ta kwenta? U léꞌ ti kin óltsi xoꞌ xantʼéy a tʼajám kʼal nu tumínal, pos yabich más neꞌech ka óntsi ta okʼlek tʼojnal kʼal nanáꞌ.” ");
INSERT INTO husNT2005_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","An okʼlek tʼojnal in chalpay tám enchéꞌ: “¿Jantʼéy xoꞌ neꞌech ku tʼajaꞌ abal nu ajátik neꞌech ti kin káldhaꞌich an tin tʼojnal? Nanáꞌ yabich in likat ku tʼajaꞌ u ale ani tidhetál u achʼál kin xeꞌchin tin konox tolmixtaláb. ");
INSERT INTO husNT2005_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","U chalpách xantʼéy neꞌech ku tʼajaꞌ abal ku kóꞌoy xitaꞌ ti kin bachʼu tin kʼimáꞌ tam kin káldhájich an tin okʼlek tʼojnal.” ");
INSERT INTO husNT2005_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Tujey tám kin kaniy juntsik ti juntsik xu júntsixtsik ban ajátikláb. Xi jidhtal in konoy enchéꞌ: “¿Jatʼwaꞌ a júntsal nu ajátik?” ");
INSERT INTO husNT2005_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Tókʼoyat enchéꞌ: “U júntsal boꞌ inik barril ti aséyte.” Utsan tám enchéꞌ kʼal an okʼlek tʼojnal: “Jéꞌ kʼwajat an úw xon ti dhutsadh abal anchanꞌ a júnál; ki buxkan jikʼat ani ka tʼajaꞌ jún xin ulal abal tokot a júnál chab inik láju.” ");
INSERT INTO husNT2005_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Tayíl in konoy jeye xin chabtal: “Ani tatáꞌ, ¿jatʼwaꞌ a júnál?” Jajáꞌ tókʼon enchéꞌ: “Boꞌ inik lejab i trigo.” In utsaꞌ jeye tám enchéꞌ: “Jéꞌ kʼwajat an úw xon ti dhutsadh abal anchanꞌ a júnál; ka tʼajaꞌ ít xon ti kin ulu abal tokot a júnál cheꞌ inik i lejab.” ");
INSERT INTO husNT2005_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","An ajátikláb in chuꞌu abal jachanꞌ an okʼlek tʼojnal xi yab alwaꞌ, in choꞌób tʼajat xan ti kin uwaꞌ abal yab ka xeꞌchin ti chʼojontálbél tayíl. Pos an atiklábtsik xi yab u belom, más jaꞌ in choꞌóbtsik xan ti kin uwaꞌ kʼal nin kidhtaltsik ké an atiklábtsik xu belom. ");
INSERT INTO husNT2005_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","ʼNanáꞌ tu utsáltsik enchéꞌ: ka éynaꞌ xowaꞌ waꞌach techéꞌ ban walbidh kʼayꞌlá abal ka kóꞌoy a jaꞌúbtsik, pos tam ka taley xowaꞌ waꞌach techéꞌ ti kʼayꞌlá, ka waꞌchin xitaꞌ ti ki bachʼu ban atá xi yab jaykʼi u pakchunal. ");
INSERT INTO husNT2005_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","ʼXitaꞌ in tʼajál alwaꞌ kʼal xowaꞌ wéꞌ in koꞌol, anchanꞌ jeye neꞌech kin tʼajaꞌ kʼal xi yán ani xitaꞌ in tʼajál yab alwaꞌ kʼal xowaꞌ wéꞌ in koꞌol, anchanꞌ jeye neꞌech kin tʼajaꞌ kʼal xi yán. ");
INSERT INTO husNT2005_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","’Jaxtám, max yabtsik a tʼajál alwaꞌ kʼal xowaꞌ a koꞌol techéꞌ ban walbidh kʼayꞌlá, ¿awxeꞌ neꞌech ki pidhan kʼal na Dios abal ka beletnaꞌ xowaꞌ alwaꞌ? ");
INSERT INTO husNT2005_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ani max yab ka beletnaꞌ alwaꞌ xowaꞌ na Dios ti pidhál ka beletnaꞌ, ¿awxeꞌ neꞌech ti ki pidhaꞌ na Dios xowaꞌ ti bijtsámalich ke tatáꞌ neꞌech ka dhabalnaꞌ? ");
INSERT INTO husNT2005_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","ʼNi jun i tʼójontsix yab neꞌech kin ejto kin tʼójontsi cháb i ajátikláb; pos neꞌech kin atʼaꞌ na jún ani neꞌech kin kʼanidhaꞌ na jún. Neꞌech kin tʼajaꞌ xowaꞌ ka utsan kʼal na jún ani na jún yab neꞌech kin tʼajaꞌ ti kʼij. Yab neꞌech ka ejto ka tʼójontsi na Dios ani ka tʼójontsi jeye an tumínladhtaláb. ");
INSERT INTO husNT2005_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","An fariseotsik xi chʼeꞌneꞌ tʼajat kʼal an tumín, kʼwajat in achʼáltsik ejtal jechéꞌ ani in labídhnaꞌtsik na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Utsantsik tám enchéꞌ kʼal na Jesús: ―Tatáꞌtsik a wáynál ke i alwaꞌ iniktsik tʼajat tin tamét an atiklábtsik, por na Dios ti exlantsal an ta ejattaltsik; pos xowaꞌ u chuꞌtáb kʼal an iniktsik ke alwaꞌ tʼajat, na Dios in pojkál. ");
INSERT INTO husNT2005_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","ʼAsta tam ti xeꞌchin na Juan xu pujax u éynal an takʼixtaláb xin jilám dhutsadh na Moisés ani in okʼtsixtal an tʼiltsixtsik. Tam ti xeꞌchin na Juan xu pujax, tám ti tujey ti tʼilnal an alwaꞌ tʼilab kʼal tin kwenta xan tu takʼix na Dios ani ejtalkʼi in tʼajál an chápláb abal ka kʼwajách takʼnél kʼal na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","ʼPor más yab tʼojláb ka kʼibchon an walkʼiꞌ ani an chabál ké yab ka támun ejtal jelt xan ti kʼwajat dhutsadh bin takʼixtal na Dios xin jilám dhutsadh na Moisés. ");
INSERT INTO husNT2005_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","ʼMax jun i inik kin jilaꞌ nin tomtal ani ka tomkin ti ít kʼal kʼeꞌet i mímláb, u walbinalich tám kʼal i uxúmbeꞌtaláb ani xitaꞌ ka tomkin kʼal an jiladh mímláb, u walbinalich jeye kʼal i uxúmbeꞌtaláb. ");
INSERT INTO husNT2005_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","ʼTáꞌwiꞌik ti kʼwajat jun i tumínladh inik xu xeketlinal kʼal i kʼudhkʼum xi tʼunuyich tʼajat kʼal in chákníꞌ ani in tʼajál i pakdhaꞌ ajib tsudhey ka tsudhey. ");
INSERT INTO husNT2005_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Táꞌ jeye ti kʼwajat jun i chʼojontál inik xu bijyáb ta Lásaro, xi tʼítʼidh tʼajat ani u buxkanal chabál bin wiꞌlébil jachanꞌ an tumínladh inik. ");
INSERT INTO husNT2005_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Jechéꞌ an chʼojontál inik, in leꞌnál kin kʼapu nin muꞌmats an kʼapnél xu kwajlanal tin ál nin mesajil an tumínladh inik. Jechéꞌ na Lásaro tʼítidh tʼajat ke asta an pikʼoꞌtsik u utel ti lekʼwtsinal kʼál an tin tʼítʼal. ");
INSERT INTO husNT2005_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Jun i kʼij, an chʼojontál inik chemech ani júná kʼal an tʼokat abatwáletsik abal ka kʼwajay xon ti kʼwajat na Abraham. Chemech jeye an tumínladh inik ani jolyat. ");
INSERT INTO husNT2005_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Tam ti an tumínladh inik kʼwajat ti chʼojontálbél kʼal an yajal ban kʼibeltaláb, in telaꞌ tʼekʼat ani in ów chuꞌu na Abraham junax kʼal na Lásaro. ");
INSERT INTO husNT2005_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Dhájaxin tám kawidh enchéꞌ: “Tátaꞌ Abraham, ti kin yajnantsi neye, ka abaꞌ na Lásaro abal kin axdhaꞌ nin tsúm nin tsʼútsbixtal ba jaꞌ ani ka tsích ti kin chamambédhantsi tu lekʼáb, pos yabich tʼajat u kuxyal an yajtsiktaláb ba jechéꞌ an kʼamal.” ");
INSERT INTO husNT2005_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Por utsan enchéꞌ kʼal na Abraham: “Chakámláb, ka chalpay abal tatáꞌ a bachʼúmalich xowaꞌ alwaꞌ tam ta xeꞌchinék ti chabál ani na Lásaro mapal yajtsiktaláb in bachʼúmal. Xoꞌ, jajáꞌ exom in bachʼwal i kʼijidhtaláb techéꞌ ani tatáꞌ exom a bachʼwal i yajtsiktaláb. ");
INSERT INTO husNT2005_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ani tám juní, yab neꞌech kin ejto ka watʼey xon ti tatáꞌ i kʼwajat kom waꞌach jun i owtsik jól ani yab xan ti ka watʼey tachanꞌ. Jaxtám, xi techéꞌtsik kʼwajat, yab neꞌech kin ejto ka kʼale tachanꞌ max in léꞌtsik ka kʼale ani xi tachanꞌtsik kʼwajat, yab neꞌech kin ejto ka tsích techéꞌ max in léꞌtsik ka tsích.” ");
INSERT INTO husNT2005_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","In ulu tám enchéꞌ an tumínladh inik: “Tátaꞌ Abraham, tu kontsal pé ti alwaꞌtaláb abal ka abaꞌ na Lásaro bin kʼimáꞌ nu tátaꞌ, ");
INSERT INTO husNT2005_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","xon ti kʼwajat bóꞌ u kidhábtsik abal kin óltsitsik jechéꞌ ani anchanꞌ, yabtsik ka tsích techéꞌ ban yajtsiktaláb.” ");
INSERT INTO husNT2005_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Por utsan enchéꞌ kʼal na Abraham: “Táꞌ in koꞌoltsik an takʼixtaláb xin dhutsámalt na Moisés ani an tʼiltsixtsik; ¡awil kin exbantsitsik jaꞌich!” ");
INSERT INTO husNT2005_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Tókʼon enchéꞌ an tumínladh inik: “Aniꞌ kʼejle, tátaꞌ Abraham, por max jún xi chemnekich ka ejech ti ít ani ka witsiy xon ti jajáꞌtsik kʼwajat, neꞌech tám kin jilaꞌtsik ti walablom.” ");
INSERT INTO husNT2005_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Por utsan enchéꞌ kʼal na Abraham: “Max yab in léꞌ kin exbantsitsik xowaꞌ in dhutsámal na Moisés ani an tʼiltsixtsik, yab jeye neꞌech kin exbantsitsik maske jun i chemélom ka ejech ti ít ani ka witsiy xon ti jajáꞌtsik kʼwajat.” ");
INSERT INTO husNT2005_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Na Jesús in utsaꞌ enchéꞌ nin exóbaliltsik: ―Echʼekʼi waꞌach xantʼokʼál tu walbindháb an atiklábtsik; por ¡chʼojontál in chuꞌbíl xitaꞌ kin walbindhaꞌ jun xitaꞌ! ");
INSERT INTO husNT2005_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Más alwaꞌ abal an walbindhom ka wikʼtsin bin núkʼ jun i yejcheꞌ chaꞌ tʼujub ani ka petʼná ban pujal abal ka luyꞌchin ké kin walbindhaꞌ jún ti éb xi jechéꞌ an chakamtsik xi tin belálichtsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ka kóꞌoytsik tʼajat i kwenta abal yab ka walbindhaꞌ ni jun xitaꞌ. ʼMax jun a at kidháb ti waltsi, ka tawnaꞌ, max kin exbay ani yabich más kin tʼajaꞌ an walastaláb, ka pakwlantsi. ");
INSERT INTO husNT2005_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Maske ti waltsi búkíl ta kʼítsá ani búkíl ti ki utsaꞌ enchéꞌ: “Yabich más neꞌech kin witsiy ku tʼajaꞌ”, ka pakwlantsi. ");
INSERT INTO husNT2005_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","An exóbaltsik in utsaꞌ enchéꞌ an Ajátikláb: ―Ti ku tolmiy abal ku belmách más. ");
INSERT INTO husNT2005_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Utsantsik tám enchéꞌ kʼal an Ajátikláb: ―Max i belomaktsik elaꞌ wéꞌ, jelt in pubíl jun in itsích i mostasa, neꞌech ka ejtotsik ka utsaꞌ jechéꞌ an teꞌ xu bijyáb sikómoro: “Ki puꞌchun techéꞌ xon ta kʼwajat ani ki kʼale ta kubél ban pujal”; ani an teꞌ neꞌech ti ki axtsi. ");
INSERT INTO husNT2005_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","ʼMax jun xitaꞌ xi tatáꞌtsik in koꞌol jun i jolib ti jóbal chabál o ti belkol koꞌnéltsik ban aleláb, tam ka witsích, yab in utsál enchéꞌ: “Ki ochichich ani ki buxkan ta kʼapul.” ");
INSERT INTO husNT2005_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Yab in tʼajál anchanꞌ, tokot in utsál enchéꞌ: “Ti kin lejkintsi an ti kʼapnél xowaꞌ neꞌech ku kʼapu ani ki kʼwajay techéꞌ abal ti kin bíntsi xowaꞌ ku yéntsi, lejat in kʼwajat tin kʼapul ani tin uchʼal. Tayíl, tám teye ki kʼapúch ani ki uchʼách.” ");
INSERT INTO husNT2005_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","¿Awxeꞌ neꞌech ka pidhan ti jalbintsixtaláb jechéꞌ an tʼójontsix abal in tʼajaꞌ xowaꞌ utsan? ¡Yabaꞌ! ");
INSERT INTO husNT2005_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Anchanꞌ teye tatáꞌtsik, tam ki okʼon ka tʼajaꞌ ejtal xowaꞌ ti utsáltsik na Dios, yejat ka ulutsik enchéꞌ: “Wawáꞌ u tʼójontsix por yab xataꞌ tu alwaꞌ, pos yab más xataꞌ i tʼajámal, tokot xowaꞌ xi yejat ki tʼajaꞌ.” ");
INSERT INTO husNT2005_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Tam ti na Jesús in óntsích an bél abal Jerusalén, watʼey bin xámlíl an chabáltsik xi Galilea ani xi Samaria. ");
INSERT INTO husNT2005_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Tam ti ulich ba jun i kwentsal, kʼale ti tamwáb kʼal láju i iniktsik xin koꞌol i kʼwajat atʼax tʼítʼ, por yab utukná, ");
INSERT INTO husNT2005_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","tokot dhájaxintsik kawidh enchéꞌ: ―¡Jesús, Okʼtsix, ti ku yajnantsi weye! ");
INSERT INTO husNT2005_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Tam ti chuꞌtattsik kʼal na Jesús, utsantsik enchéꞌ: ―Ki kʼaletsik tin tamét an páleꞌtsik abal ki chuꞌtat kʼal jajáꞌtsik. Lejat neꞌech ti belal, jeleytsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Jún ti éb xi jajáꞌtsik, tam tin chuꞌu abal jeley, witsiy in pubédhantsal kawidh tin bij na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Tudhlan kutúl asta chabál tin tamét na Jesús abal kin pidhaꞌ ti jalbintsixtaláb. Jechéꞌ an inik, u kʼwajíl Samaria. ");
INSERT INTO husNT2005_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","In ulu tám enchéꞌ na Jesús: ―¿Yabxeꞌ pé láju an yaꞌultsik xi jeley? ¿Jónꞌ ti kʼaletsik xi beléju? ");
INSERT INTO husNT2005_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Tokot jechéꞌ an píl inik witsiy abal kin pubédhantsi tin bij na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Utsan tám enchéꞌ an inik kʼal na Jesús: ―Ki chʼakay ani ki kʼaléch, i jeley abal i belmách. ");
INSERT INTO husNT2005_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Konyat na Jesús kʼal an fariseotsik xowkʼi neꞌech ka tujey ti takʼix na Dios ani Jajáꞌ in tókʼoytsik enchéꞌ: ―Xan tu takʼix na Dios, yab neꞌech kin junu jelti jun xataꞌ xi tejwaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Yab neꞌech ka ulwat enchéꞌ: “Jéꞌ kʼwajat” o “Núꞌ kʼwajat”; pos na Dios tujenekich ti takʼix xon ta kʼwajattsik, por tokot u xalkʼanal bin itsích xitaꞌ kʼál ti ka bachʼwat. ");
INSERT INTO husNT2005_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","In utsaꞌ tám enchéꞌ nin exóbaliltsik: ―Neꞌech kin bajaw an kʼij tam tatáꞌtsik neꞌech ka leꞌnaꞌ ti kin chuꞌu, Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik, maske jún tokot a kʼítsá, por yab neꞌech ka ejto ti kin chuꞌutsik kom yabél in bajúmal an kʼij xowkʼi ti neꞌech kin witsiy. ");
INSERT INTO husNT2005_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Taltsik neꞌech ti ki utsaꞌtsik enchéꞌ: “Ka telaꞌ, jéꞌ kʼwajat an Kristo” o “Ka telaꞌ, núꞌ kʼwajat.” Por yab ki kʼaletsik ti kin aliy nibal ka wéwnaꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Pos jelt xan tu lamkʼil an léy jun pakʼeꞌ jun pakʼeꞌ ban walkʼiꞌ, anchanꞌ jeye neꞌech ka támun jachanꞌ i kʼij tam kin tsích, Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik. ");
INSERT INTO husNT2005_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Por koꞌol okʼox ku watʼnaꞌ yán i yajtsiktaláb ani neꞌech kin pojká kʼal an atiklábtsik xi jechéꞌ i kʼij. ");
INSERT INTO husNT2005_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Jelt xan ti támun tam ti xeꞌchinék na Noé, anchanꞌ jeye neꞌech ka támun tam kin bajaw xowkʼi ti neꞌech kin tsích, Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik. ");
INSERT INTO husNT2005_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Jechéꞌ an atiklábtsik xi yab u belom, tokot in beláltsik ti kʼapul ani ti uchʼal, u tomkinaltsik ani in pidhnáltsik nin tsidhánil abal ka tomkin, asta tin bajaw xowkʼi na Noé ti ochich ban tan atá, tsích an chapik ábal kʼij ani ejtaltsik chemech. ");
INSERT INTO husNT2005_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Anchanꞌ jeye ti támun tam ti xeꞌchin na Lot. An atiklábtsik xi yab u belom, tokot in beláltsik ti kʼapul ani ti uchʼal, u chʼaꞌum ani u nújultsik, u óm ani u kúbal atátsik; ");
INSERT INTO husNT2005_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","por tam ti na Lot kale ba jachanꞌ an bitsow xi Sodoma, kwajlan i kʼamal ani i asufre xi tál walkʼiꞌ ani ejtal chemdhátsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Anchanꞌ jeye neꞌech ka támun jachanꞌ i kʼij tam kin xalkʼan, Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik. ");
INSERT INTO husNT2005_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","ʼJachanꞌ i kʼij, max jun xitaꞌ kʼwajat bin éb nin kʼimáꞌ ani in koꞌol xataꞌ taꞌpadh altá, yab ka paꞌay kin ikʼiꞌ ani max jun xitaꞌ kʼwajat bin ale, yab ka witsiy tin kʼimáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ka chalpaytsik xantʼéy in tamu nin tomtal na Lot. ");
INSERT INTO husNT2005_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Xitaꞌ kin leꞌnaꞌ kin loꞌo nin xeꞌchintal, neꞌech kin kʼibdhaꞌ; por xitaꞌ kin kʼibdhaꞌ, neꞌech kin loꞌo. ");
INSERT INTO husNT2005_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","ʼTsubax tu utsáltsik ke jachanꞌ i akal, max kʼwajat cháb ti wayal junax ba jun i waytaláb, jún neꞌech ka júná ani jún neꞌech ka jilan. ");
INSERT INTO husNT2005_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Max cháb i mímlábtsik kʼwajat ti cheꞌel junax, jún neꞌech ka júná ani jún neꞌech ka jilan. ");
INSERT INTO husNT2005_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Max cháb i iniktsik kʼwajat ti tʼojnal junax bin ale, jún neꞌech ka júná ani jún neꞌech ka jilan. ");
INSERT INTO husNT2005_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Tam ti an exóbaltsik in achʼaꞌ jechéꞌ, konoxintsik enchéꞌ: ―Ajátik, ¿jónꞌ ti neꞌech ka támun jechéꞌ? Na Jesús tókʼon enchéꞌ: ―Xonti kʼwajat an chemélom, tajaꞌ neꞌech ka junkun an tʼottsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Na Jesús in kʼwajbantsitsik jun i junbaxtaláb abal kin okʼtsitsik ke yejat ka ólan echʼekʼi ani yab kin jilaꞌtsik tinbáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","In utsaꞌtsik enchéꞌ: ―Táꞌwiꞌik ti kʼwajat ba jun i bitsow jun i lújundhom xi yab in jikʼnál a Dios nibal in tʼajál ti kʼij ni jun xitaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Táykʼi ba jachanꞌ an bitsow, taꞌ jeye ti kʼwajat jun i chemtsidh mímláb xu kʼalel kin chuꞌu jachanꞌ an lújundhom abal in léꞌ ka kinandhantsat jun xitaꞌ xi waltsinék kʼál. ");
INSERT INTO husNT2005_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Owey ti pakabédhax an ti lújundhom, por yab u tʼajnal ti kʼij. Tayíl in chalpay enchéꞌ an lújundhom: “Maske yab u jikʼnál na Dios, nibal u tʼajál ti kʼij ni jun xitaꞌ, ");
INSERT INTO husNT2005_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","kom jechéꞌ an chemtsidh mímláb, bélkʼi neꞌech kin óntsi ti kin itʼixbédhaꞌ, neꞌech ku exbantsi abal yabich más kin óntsi ti tsiꞌil yab táꞌ ti kin chakúdhaꞌ.” ");
INSERT INTO husNT2005_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ani in ulu enchéꞌ an Ajátikláb: ―Jechéꞌ jaꞌich in ulu an lújundhom xi yab alwaꞌ inik. ");
INSERT INTO husNT2005_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","¿Awxeꞌ na Dios yab neꞌech kin exbantsitsik jeye xi Jajáꞌ in takwyámal, xi akal i kʼij u tawnáb kawidh kʼál? ¿Awxeꞌ neꞌech kin kóꞌoy ti aytsixtsik? ");
INSERT INTO husNT2005_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Tsubax tu utsáltsik ke neꞌech ti ki exbantsitsik jikʼatkʼi. Por tam kin tsích, Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik, ¿bélxeꞌ awil neꞌech ku elaꞌ techéꞌ ti kʼayꞌlá xu belomtsik? ");
INSERT INTO husNT2005_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Na Jesús in tʼilaꞌ jeye jechéꞌ an junbaxtaláb abal taltsik an atiklábtsik xi taꞌ ti kʼwajat, in chalpayaltsik ke alwaꞌ iniktsik ani in pojkál xi kʼeꞌettsik. Enchéꞌ tin ulu: ");
INSERT INTO husNT2005_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","―Cháb i iniktsik kʼale ti ól ban pulek atá xon tu kʼakʼnáb na Dios: jún i fariseo ani jún i bachʼkʼul jalbixtaláb. ");
INSERT INTO husNT2005_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","An fariseo kubat ti ól enchéꞌ: “Dios, tu pidhál ti jalbintsixtaláb abal yab u junwal jelti xi kʼeꞌettsik, xu kwéꞌ, xi yabtsik alwaꞌ inik ani xu junkunaltsik kʼal xi yab in tomtal. Nibal elaꞌ u junwal jelti jechéꞌ an bachʼkʼul jalbixtaláb. ");
INSERT INTO husNT2005_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nanáꞌ in kʼíl chábíl ti semana ani tu pidhál xowaꞌ a lujyal ka bachʼu kʼal ejtal xowaꞌ u átál.” ");
INSERT INTO husNT2005_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Por an bachʼkʼul jalbixtaláb, ówkʼi jaꞌ ti jilkʼon ani nibal elaꞌ in leꞌnál kin telaꞌ walkʼiꞌ, in pewyal tokot in tamét nin itsích ani in ulal enchéꞌ: “¡Dios, ti kin kóꞌontsi neye ti yajnantsixtaláb abal in walablom!” ");
INSERT INTO husNT2005_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Tsubax tu utsáltsik ke jechéꞌ an bachʼkʼul tumín witsiy tin kʼimáꞌ pakwlantsidh kʼal na Dios, por an fariseo yabaꞌ. Pos xitaꞌ kin tʼekʼaꞌ tinbáꞌ, neꞌech ka chaꞌká ani xitaꞌ kin chaꞌkaꞌ tinbáꞌ, neꞌech ka tʼekʼbá. ");
INSERT INTO husNT2005_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","U utuntsáb jeye ti chakamtsik na Jesús abal kin puntsi tin kʼubak ani kin lábtʼajaꞌ, por tam ti an exóbaltsik in chuꞌu jechéꞌ, tujey kin kʼwiyaꞌ an tsiꞌdhom chakamtsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Kanyattsik kʼal na Jesús ani utsan enchéꞌ: ―Ka walkaꞌ ka utey an chakamtsik xon tin kʼwajat, yab ka tamkʼuy, pos xitaꞌ in jilál tinbáꞌ ka takʼyat kʼal na Dios, in junwal jelti chakam. ");
INSERT INTO husNT2005_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Tsubax tu utsáltsik, ke xitaꞌ yab kin jilaꞌ tinbáꞌ ka takʼyat kʼal na Dios jelti jun i chakam, yab jaykʼi neꞌech kin ejto ka kʼwajay takʼnél kʼal na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Konyat enchéꞌ na Jesús kʼal jun i okʼlek: ―Alwaꞌ Okʼtsix, ¿jantʼéy yejat ku tʼajaꞌ abal ku ejto ku kóꞌoy an xeꞌchintaláb xi yab in koꞌol in okʼontal? ");
INSERT INTO husNT2005_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Tókʼoyat enchéꞌ kʼal na Jesús: ―¿Jantʼókʼi tin bijyal tin alwaꞌ? Jún tokot waꞌach xitaꞌ alwaꞌ, na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","A exlálich an takʼixtaláb: “Yab ki junkun kʼal xi yab a tomtal, yab ki chemdhaxin, yab ki kwéꞌlách, yab ka jantsi ti káw ni jun xitaꞌ ani ka kʼakʼnaꞌ na tátaꞌ ani na nánaꞌ.” ");
INSERT INTO husNT2005_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Utsan enchéꞌ kʼal an inik: ―Ejtal jechéꞌ u tʼajál asta tin chipíl. ");
INSERT INTO husNT2005_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Tam ti na Jesús in achʼaꞌ xan ti tókʼon, in utsaꞌ enchéꞌ: ―Bél u kʼibel ka tʼajaꞌ jun xataꞌ: ka nuju ejtal xowaꞌ a koꞌol ani ka pidhaꞌ an ti tumín an chʼojontáltsik, anchanꞌ neꞌech tám ka kóꞌoy túꞌ walkʼiꞌ xowaꞌ más yán in jalbíl, ki tsích tám ani ti kin wéwnaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Tam ti an inik in achʼaꞌ jechéꞌ, tʼeꞌpin tʼajat kom watʼats ti tumínladh. ");
INSERT INTO husNT2005_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Tam ti na Jesús in chuꞌu abal tʼeꞌpin tʼajat an tumínladh inik, in ulu enchéꞌ: ―¡Tʼojláb tʼajat abal jun i tumínladh inik kin walkaꞌ tinbáꞌ ka takʼyat kʼal na Dios! ");
INSERT INTO husNT2005_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Más yab tʼojláb ka watʼey jun i koꞌnél xin bij kameyo bin chultál jun i tʼidhab ké kin walkaꞌ tinbáꞌ jun i tumínladh inik ka takʼyat kʼal na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Xin achʼaꞌtsik xowaꞌ in ulu na Jesús, in ulu enchéꞌ: ―Tám, ¿jitaꞌ neꞌech kin ejto ka loꞌey? ");
INSERT INTO husNT2005_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Utsantsik enchéꞌ kʼal na Jesús: ―Xowaꞌ yab in ejtowal kin tʼajaꞌ an iniktsik, na Dios in ejtowal kin tʼajaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Utsan tám enchéꞌ kʼal na Pedro: ―Wawáꞌ i jilámal ejtal xowaꞌ i koꞌol abal ku xeꞌchin kʼal Tatáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Tókʼoyattsik tám enchéꞌ kʼal na Jesús: ―Tsubax tu utsáltsik, ke xitaꞌ kin jilaꞌ in kʼimáꞌ, in tátaꞌtsik, in kidhábtsik, in tomtal o in chakámiltsik abal kin tʼójontsi na Dios, ");
INSERT INTO husNT2005_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","más yán neꞌech kin bachʼu ba jechéꞌ an kʼayꞌlá ani ban ít kʼayꞌlá xi neꞌech ka tsích tayíl, neꞌech kin bachʼu an xeꞌchintaláb xi yab in koꞌol in okʼontal. ");
INSERT INTO husNT2005_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Na Jesús in kaniy pílkʼi xi lajucháb an exóbal ani in utsaꞌtsik enchéꞌ: ―Xoꞌ u neꞌchich Jerusalén, xon ti neꞌech ka támun ejtal xowaꞌ in dhutsámal an tʼiltsixtsik kʼal tu kwenta Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik. ");
INSERT INTO husNT2005_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Neꞌech kin pidhná ban píl iniktsik, neꞌech kin labídhná, neꞌech kin odhbijyat ani neꞌech kin tubkayat. ");
INSERT INTO husNT2005_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Neꞌech kin chaꞌwat ani neꞌech kin chemdhá; por tin óxláb a kʼítsá, neꞌech kin ejech ti ít. ");
INSERT INTO husNT2005_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Por jajáꞌtsik yab in exbay xataꞌ jechéꞌ xowaꞌ utsan kʼal na Jesús, nibal in choꞌóbtsik xantʼéy nu tʼiltsinal, pos jechéꞌ xowaꞌ utsantsik, jaꞌich xowaꞌ yabél neꞌech kin ejtotsik kin exbay. ");
INSERT INTO husNT2005_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Tam ti na Jesús exomich ti kʼunel ban bitsow xi Jerikó, in elaꞌ jun i jokʼol buxúl wal bél ti konox tolmixtaláb. ");
INSERT INTO husNT2005_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Tam ti an jokʼol in achʼaꞌ abal exom ti watʼel yán i atiklábtsik, in konoy xantʼéy exom ti támnal. ");
INSERT INTO husNT2005_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Utsan abal exom ti watʼel tajaꞌ na Jesús xi Nasaret. ");
INSERT INTO husNT2005_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Tam tin achʼaꞌ jechéꞌ, dhájaxin tám kawidh enchéꞌ: ―¡Jesús, xi kidhtaláb kʼal an pulek takʼix Dabid, ti kin yajnantsi neye! ");
INSERT INTO husNT2005_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Xi taꞌ ti neꞌechtsik okʼox kʼwiyxin abal ka chamkʼan, por an jokʼol más kawidh ti dhájaxin enchéꞌ: ―¡Tatáꞌ, xi kidhtaláb kʼal an pulek takʼix Dabid, ti kin yajnantsi neye! ");
INSERT INTO husNT2005_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Kubey tám na Jesús ani in abnaꞌ ka ikʼtat an jokʼol. Tam ti tajaꞌich ti kʼwajat, in konoy enchéꞌ: ");
INSERT INTO husNT2005_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―¿Jantʼéy a léꞌ tu tʼajtsi? An jokʼol tókʼon enchéꞌ: ―Ajátik, u léꞌ neye ti kin chuꞌxindhaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Utsan tám enchéꞌ kʼal na Jesús: ―¡Ki chuꞌxinich! I jeley abal i belmách. ");
INSERT INTO husNT2005_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Támkʼi jachanꞌ ti chuꞌxin an jokʼol, in wéwnaꞌ tám na Jesús ani in pubédhantsal tin bij na Dios. Ejtal an atiklábtsik xin chuꞌu jechéꞌ, in pubédhantsitsik jeye tin bij na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Ulich tám na Jesús ban bitsow xi Jerikó ani tam ti exomich ti watʼel tajaꞌ, ochich ba jechéꞌ an bitsow. ");
INSERT INTO husNT2005_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ba jechéꞌ an bitsow, taꞌ ti kʼwajat jun i tumínladh inik xin bij Sakeo, jajáꞌ u okʼlek kʼal xin bachʼwaltsik an jalbixtaláb. ");
INSERT INTO husNT2005_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Na Sakeo in léꞌ kin exlaꞌ na Jesús, por yab in ejto kin chuꞌu kom yán tʼajat an atiklábtsik taꞌ ti neꞌech ani tám juní, yab nakat na Sakeo. ");
INSERT INTO husNT2005_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ájlách tám abal ka okxin ani abal kin ejto kin chuꞌu na Jesús, kʼadhiy ba jun i teꞌ kʼunat xon ti na Jesús neꞌech ka watʼey. ");
INSERT INTO husNT2005_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Tam ti na Jesús watʼey tajaꞌ, in telaꞌ tʼekʼat, in chuꞌu na Sakeo ani in utsaꞌ enchéꞌ: ―Sakeo, ki paꞌay jikʼatkʼi, pos xoꞌ koꞌol kin koyóch ta kʼimáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Paꞌay tám jikʼatkʼi na Sakeo ani kʼal yantam i kulbétaláb ti bachʼwat na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Tam ti an atiklábtsik in chuꞌu jechéꞌ, ejtal in tujutsik ti kawix, in ulaltsik abal na Jesús kʼalnek ti koyol bin kʼimáꞌ jun i walablom inik. ");
INSERT INTO husNT2005_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Kubey tám na Sakeo ani in utsaꞌ enchéꞌ an Ajátikláb: ―Ajátik, neꞌech ku pidhaꞌ an chʼojontáltsik junax chʼejel xowaꞌ u koꞌol ani max u kwéꞌyámal jun xitaꞌ, neꞌech ku witsbantsi chéꞌíl in yaníl xowaꞌ u kweꞌtsámal. ");
INSERT INTO husNT2005_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","In ulu tám enchéꞌ na Jesús: ―Xoꞌ loꞌwatichtsik xu kʼwajíl bin kʼimáꞌ na Sakeo, pos jajáꞌ u kidhtaláb jeye kʼal na Abraham ani xoꞌ belmáchich jelt xan ti belmámadh na Abraham. ");
INSERT INTO husNT2005_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Pos Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik, in tsiꞌnek ku aliy ani ku loꞌo an atiklábtsik xi kʼibchonékichwiꞌik ti kʼwajat. ");
INSERT INTO husNT2005_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Kom kʼunatich ka ulich Jerusalén ani kom xi taꞌ ti kʼwajattsik in achʼál xowaꞌ in ulal na Jesús in chalpayal ke wéꞌich u kʼibel kin tuju ti takʼix na Dios, jaxtám na Jesús in óntsi ti káw ani in tʼiltsitsik jechéꞌ an junbaxtaláb. ");
INSERT INTO husNT2005_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","In utsaꞌtsik enchéꞌ: ―Táꞌwiꞌik ti kʼwajat jun i inik xu kidhtaláb kʼal i pakdhaꞌ takʼix. Jechéꞌ an inik, kʼale ów ba jun i píl bitsow abal ka bijyat ti pulek takʼix ani tayíl ka witsiy ti takʼix. ");
INSERT INTO husNT2005_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Tam ti neꞌchich ka kʼaléch, in kaniy láju in tʼojnáliltsik, in pidhaꞌ juntsik ti éb jun i patʼál tumín xi yán tʼajat in jalbíl ani in utsaꞌtsik enchéꞌ: “Ka tʼójondhaꞌtsik jechéꞌ an tumín asta kin witsiy.” ");
INSERT INTO husNT2005_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Jechéꞌ an inik u atʼnal kʼal an atiklábtsik xi tajaꞌ bin bitsówil. Jaxtám ti aban jeye cháb óx i iniktsik tin kuxmats abal ka kʼaletsik kin ulu enchéꞌ: “Yab i kulbetnál jechéꞌ an inik abal ti pulek takʼíxal.” ");
INSERT INTO husNT2005_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Por bélkʼi bijyat ti pulek takʼix ani witsiy ba nin bitsówil. Tam ti ulich, in abnaꞌ ka kanyat an tʼojnaltsik xin jiltsámal an ti tumín abal kin choꞌóbnaꞌ xatʼwaꞌ in átámal juntsik ti éb kʼal jachanꞌ an tumín. ");
INSERT INTO husNT2005_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ulich xi jidhtal ani in ulu enchéꞌ: “Ajátik, u tʼójondhaꞌ na tumínal ani in átaꞌ lájujíl más in yaníl.” ");
INSERT INTO husNT2005_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Tókʼoyat enchéꞌ kʼal an pulek takʼix: “Alwaꞌ tʼajat, tatáꞌ i alwaꞌ tʼójontsix; kom i tʼójon alwaꞌ kʼal wéꞌ, neꞌech tu pidhaꞌ ti awiltaláb ka takʼiy láju i bitsowtsik.” ");
INSERT INTO husNT2005_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ulich jeye xin chabtal ani in ulu enchéꞌ: “Ajátik, u tʼójondhaꞌ na tumínal ani in átaꞌ bóꞌíl más in yaníl.” ");
INSERT INTO husNT2005_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Tókʼoyat jeye enchéꞌ: “Tatáꞌ neꞌech tu kʼwajbaꞌ ka takʼiy bóꞌ i bitsowtsik.” ");
INSERT INTO husNT2005_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ulich jeye jún ani in ulu enchéꞌ: “Ajátik, jéꞌ kʼwajat na tumínal. U boliy kʼal jun pejeꞌ i kʼudhkʼum ani u taꞌpaꞌ; ");
INSERT INTO husNT2005_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","kom tu jikʼnál abal tatáꞌ kidhat tʼajat a kawyal. Pos tatáꞌ a kʼániyal xowaꞌ yab tatáꞌ a dhabal ani i junkux xon ti yab i ómámadh.” ");
INSERT INTO husNT2005_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","In ulu tám enchéꞌ an pulek takʼix: “Tatáꞌ yab i alwaꞌ tʼójontsix, kʼal xowaꞌ a ulal, u xalkʼanal abal i walbidh. Max a choꞌób abal kidhat u kawyal, abal u kʼániyal xowaꞌ yab u dhabal ani in junkux xon ti yab in ómámadh, ");
INSERT INTO husNT2005_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿jantʼókʼi pé tám ti yab a kʼwajbaꞌ nu tumínal xon tu tʼójondháb abal tam kin witsiy, ku bachʼu nu tumínal kʼálich xowaꞌ in átámal?” ");
INSERT INTO husNT2005_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","In utsaꞌtsik enchéꞌ xi tajaꞌ ti kʼwajat: “Ka kʼántsi an ti tumín ani ka pidhaꞌ xin koꞌol láju.” ");
INSERT INTO husNT2005_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Jajáꞌtsik in ulu enchéꞌ: “Ajátik, por in koꞌolich láju an tumín xi yán in jalbíl.” ");
INSERT INTO husNT2005_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","An pulek takʼix tókʼon enchéꞌ: “Tu utsáltsik ke xitaꞌ in koꞌolich, neꞌech ka pidhan más kʼal na Dios; por xitaꞌ yab in koꞌol, neꞌech ka kʼántsin kʼal na Dios asta xowaꞌ wéꞌ in koꞌol. ");
INSERT INTO husNT2005_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ani an atiklábtsik xi tin atʼál, xi yabtsik tin kulbetnál tin pulek takʼíxal, ka tsiꞌdhaꞌtsik techéꞌ ani ka chemdhaꞌtsik tu tamét.” ");
INSERT INTO husNT2005_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Tam ti okʼonich kin ulu jechéꞌ, na Jesús in óntsi an bél abal Jerusalén. ");
INSERT INTO husNT2005_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Tam ti exomich ti ulel ban bitsowtsik xi Betfajé ani Betania, kʼunat ban chʼén xu bijyáb Olibos, in abaꞌ cháb nin exóbaliltsik ");
INSERT INTO husNT2005_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ani in utsaꞌtsik enchéꞌ: ―Ki kʼaletsik ban kwentsal xi núꞌ kʼwajat kʼunat, tam ki ulichtsik tajaꞌ neꞌech ka elaꞌ wikʼats jun i burru xi yabél jaykʼi púnadh. Ka wilaꞌ ani ka tsiꞌdhaꞌ techéꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Max ti konoy jun xitaꞌ xantʼókʼi ta wilál, ka utsaꞌtsik abal an Ajátikláb in yéntsal. ");
INSERT INTO husNT2005_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Kʼale tám an exóbaltsik ani anchanꞌ tin elaꞌ xan ti usnéktsik kʼal na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Tam ti exomtsik in wilál an burru, konyat enchéꞌ kʼal an dhabal: ―¿Jantʼókʼi ti exom a wilál an burru? ");
INSERT INTO husNT2005_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Jajáꞌtsik tókʼon enchéꞌ: ―An Ajátikláb in yéntsal. ");
INSERT INTO husNT2005_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","In júntsitsik tám na Jesús, in tatlabiy an burru kʼal jajáꞌtsik nin kʼudhkʼúmil ani in pumbaꞌ na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Lejat na Jesús neꞌech punat, an atiklábtsik in nukʼál nin kʼudhkʼúmil tin nakíl an bél. ");
INSERT INTO husNT2005_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Tam ti exomich ti kʼunel bin paꞌbíl an chʼén xu bijyáb Olibos, ejtal xitaꞌ kʼál ti wewkómte in tuju ti dhajnaltsik kawidh kʼal i kulbéxnich ani in pubédhantsal tin bij na Dios kʼal tin kwenta an labidh labandhaxtalábtsik xin chuꞌúmaltsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","In ulaltsik enchéꞌ: ―¡Lábtʼajadh an Pulek Takʼix xi tál tin bij an Okʼóxláb! ¡Ka waꞌchin i kʼijidhtaláb túꞌ walkʼiꞌ ani kin kóꞌoy na Dios an labidh tʼokattaláb! ");
INSERT INTO husNT2005_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Taltsik an fariseotsik xi taꞌ ti kʼwajat ba jachanꞌ an atikláb in utsaꞌtsik tám enchéꞌ na Jesús: ―Okʼtsix, ka utsaꞌtsik ka chamkʼan xi ti wéwnáltsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Por na Jesús in tókʼoytsik enchéꞌ: ―Tsubax tu utsáltsik, ke max jechéꞌ an atiklábtsik ka chamkʼan, an tʼujubtsik neꞌech ka dhájaxintsik kawidh. ");
INSERT INTO husNT2005_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Tam ti ulchich kʼunat Jerusalén ani in chuꞌu jachanꞌ an bitsow, na Jesús ukʼin kʼal tin kwenta an atiklábtsik xu kʼwajíl tajaꞌ ");
INSERT INTO husNT2005_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ani in ulu enchéꞌ: ―¡Max an atiklábtsik xu kʼwajíl ba jechéꞌ an bitsow in ejtowalak kin exbaytsik jechéꞌ a kʼítsá xan ti neꞌech kin kóꞌoytsik an kʼijidhtaláb, alwaꞌak tʼajat! Por yab in exbayaltsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Por neꞌech kin bajaw an kʼij tam xi kʼál tu atʼnal neꞌech ka mapyattsik kʼál, neꞌech ka wiliyat ani neꞌech ka péjeyattsik túkʼi túkʼi. ");
INSERT INTO husNT2005_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Neꞌech ka pakwtsin an tin bitsówil ani yab neꞌech ka jilan ni jun i tʼujub tʼíꞌbáx. Neꞌech ka pakwat ejtal ani neꞌech ka chemdhá ejtal an atiklábtsik xi tajaꞌ u kʼwajíl kom yab in exbaytsik an kʼij xowkʼi ti tsích ti álnáb kʼal na Dios abal ka loꞌwattsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ochich tám na Jesús ban pulek atá xon tu kʼakʼnáb na Dios ani tujey kin káldhaꞌ xi taꞌ ti kʼwajattsik tajaꞌ ti chʼaꞌum ani ti nújultsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","In utsaꞌtsik enchéꞌ: ―Ban Tʼokat Dhuslab in ulal enchéꞌ: “Nu kʼimáꞌ abal i ólábkʼi ti bijidh ti neꞌech ka éyná”, por a wenkʼómalichtsik tin chinkʼontal i kwéꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Tsudhey ka tsudhey na Jesús u kʼwajíl ti okʼtsix ban pulek atá xon tu kʼakʼnáb na Dios; por nin okʼlékiltsik an páleꞌtsik, an okʼtsixtsik xin wilál nin takʼixtal na Dios xin jilám dhutsadh na Moisés ani an okʼlektsik xi ba jachanꞌ an bitsow in ayaltsik xan ti kin uwaꞌ abal kin ejto kin chemdhaꞌ na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Por yab in elaꞌtsik xan ti kin uwaꞌ abal kin chemdhaꞌ, pos kʼal ejtal an atiklábtsik tu axtsinal xowaꞌ in okʼtsixnál na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Jun i kʼij, tam ti na Jesús kʼwajat ban pulek atá xon tu kʼakʼnáb na Dios in okʼtsal an atiklábtsik ani in tʼiltsal an ti alwaꞌ tʼilab, ulichtsik nin okʼlékil an páleꞌtsik ani an okʼtsixtsik xin wilál nin takʼixtal na Dios xin jilám dhutsadh na Moisés junax kʼal nin okʼlékil an judíotsik ");
INSERT INTO husNT2005_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ani utsan enchéꞌ na Jesús: ―Ti ku utsaꞌ kʼal jantʼom awiltaláb ta tʼajál jechéꞌ. ¿Jitaꞌ ti pidhámal jechéꞌ an ti awiltaláb? ");
INSERT INTO husNT2005_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Utsantsik tám enchéꞌ kʼal na Jesús: ―Neꞌech neye tu konoytsik jun xataꞌ ani ti kin tókʼoytsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Kʼal jitaꞌ ti abnék na Juan ti pújal? ¿Kʼal a Dios o kʼal i iniktsik? ");
INSERT INTO husNT2005_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Tujey tám ti káwlíx jajáꞌkʼitsik ani u kónóxtsik enchéꞌ: ―¿Jantʼéy ki utsaꞌ? Max ki utsaꞌ ke kʼal a Dios ti abnék, neꞌech ti ku konoy enchéꞌ: “¿Jantʼókʼi ti yabtsik a beltsi?” ");
INSERT INTO husNT2005_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ani max ki utsaꞌ ke kʼal i iniktsik ti abnék, an atiklábtsik neꞌech ti ku chemdhaꞌ kʼal i tʼujbaxtaláb, kom in choꞌóbtsik alwaꞌ ke kʼal a Dios ti abnék ti tʼiltsix. ");
INSERT INTO husNT2005_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Jaxtám tin ulutsik ke yab in choꞌób xitaꞌ kʼál ti abnék na Juan ti pújal. ");
INSERT INTO husNT2005_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Utsantsik tám enchéꞌ kʼal na Jesús: ―Pos yab neye neꞌech tu utsaꞌtsik kʼal jantʼom awiltaláb tu tʼajál ejtal jechéꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Tujey tám na Jesús kin tawnaꞌ an atiklábtsik ani in kʼwajbantsi jechéꞌ an ti junbaxtaláb: ―Táꞌwiꞌik ti kʼwajat jun i inik xin tʼayaꞌ yán i akanlek i uba. Tayíl in matixnaꞌ jachanꞌ an aleláb abal ka tʼójomná kʼal kʼeꞌettsik, an dhabal aleláb kʼale ów ti belal ani owey ti witsiy. ");
INSERT INTO husNT2005_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Tam tin bajúch an kʼij xowkʼi neꞌech ti pitnal an uba, in abaꞌ jun in tʼojnálil abal ka kontsin jachanꞌ an mat aleláb xowaꞌ in lujyal jeye kin bachʼu an dhabal aleláb; por an mat aleláb in chaꞌaw nin tʼojnálil an dhabal ani mapats tin abaꞌ ka kʼale. ");
INSERT INTO husNT2005_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","An dhabal aleláb in abaꞌ juní kʼeꞌet in tʼojnálil; por odhbijyat jeye, chaꞌwat ani mapats jeye ti aban ka kʼale. ");
INSERT INTO husNT2005_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","An dhabal aleláb in abnaꞌ juní kʼeꞌet, por an mat aleláb in chʼojbédhaꞌ ani in kajnaꞌ ka kale eléb aleláb. ");
INSERT INTO husNT2005_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","ʼTayíl an dhabal aleláb in ulu enchéꞌ: “¿Jantʼéy ku tʼajaꞌ? Neꞌech ku abaꞌ nu chakámil xu kʼanidhál tʼajat; tam ka chuꞌtat, neꞌech xónaꞌ ka kʼakʼnáꞌ.” ");
INSERT INTO husNT2005_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Por tam ti an chakámláb chuꞌtat kʼal an mat aleláb, útsáxintsik enchéꞌ: “Jechéꞌ jaꞌich neꞌech kin dhabalnaꞌ tayíl an aleláb; wana ki chemdhaꞌ abal wawáꞌ ki dhabalnaꞌ tayíl an aleláb.” ");
INSERT INTO husNT2005_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Káldhá tám an chakámláb ba jachanꞌ an aleláb ani chemdhá. Konoxin tám enchéꞌ na Jesús: ―¿Jantʼéy a chalpayaltsik neꞌech ka tʼajtsintsik jachanꞌ an mat aleláb kʼal an dhabal aleláb? ");
INSERT INTO husNT2005_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Neꞌech ka tsích ti chemdhábtsik jachanꞌ an mat aleláb ani neꞌech kin matintsi kʼeꞌet an ti aleláb. Tam tin achʼaꞌtsik anchanꞌ, in ulutsik enchéꞌ: ―¡Ke yab kin walkaꞌ na Dios ka támun anchanꞌ! ");
INSERT INTO husNT2005_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Por teloloyattsik kʼal na Jesús ani utsantsik enchéꞌ: ―¿Jantʼéy pé tám in léꞌ kin ulu xi kʼwajat dhutsadh ban Tʼokat Dhuslab? ¿Awxeꞌ yab Nanáꞌ tin tʼilál tam in ulal enchéꞌ?: An tʼujub xin pojkaꞌ an kúbal atátsik, jaꞌich nin bajaw ka kʼwajay ultaláb. ");
INSERT INTO husNT2005_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Xitaꞌ ka kwajlan ba jachanꞌ an tʼujub, muꞌax neꞌech ka kʼale ani max an tʼujub ka kwajlan ba jun xitaꞌ, neꞌech ka jilan jelti i pojodh. ");
INSERT INTO husNT2005_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","An okʼlek páleꞌtsik ani an okʼtsixtsik xin wilál an takʼixtaláb, in leꞌnaꞌ kin yakʼwaꞌ na Jesús támkʼi jachanꞌ abal in achʼaꞌtsik ke na Jesús in ulu jechéꞌ an junbaxtaláb kʼal jajáꞌtsik tin kwenta; por in jikʼnál an atiklábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Abtsin tám na Jesús ti kwáchixtsik xin wáynál u alwaꞌ iniktsik abal ka taktamiyat kʼal i tʼilabtsik ani ka tʼajan kin ulu jun xataꞌ yab alwaꞌ ani anchanꞌ, ka ejtowat ka utsbiyat ban pulek awiltaláb. ");
INSERT INTO husNT2005_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Jaxtám ti konyat enchéꞌ: ―Okʼtsix, wawáꞌ i choꞌób ke xowaꞌ a ulal ani xowaꞌ a okʼtsixnál ejtal tsubax, Tatáꞌ yab a ódhál ti kwenta xantʼéy in tʼajál o in chalpayal an atiklábtsik, Tatáꞌ a okʼtsixnál kʼal i tsubaxtaláb nin takʼixtalábil na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ti ku utsaꞌ max alwaꞌ ki pidhaꞌ ti jalbixtaláb an lej pulek takʼix romano, o yabaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Por na Jesús in chuꞌu abal kʼwajatkʼi ti taktamiyáb ani in utsaꞌtsik enchéꞌ: ―¿Jantʼókʼi ta kʼwajattsik tin taktamiyal? ");
INSERT INTO husNT2005_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Ti kin óltsi jún i patʼál tumín. ¿Jitaꞌ jáꞌ in wal xi jechéꞌ kʼwajat chʼilbadh ban tumín ani jitaꞌ in bij xi jechéꞌ kʼwajat dhutsadh? Tókʼontsik enchéꞌ: ―An lej pulek takʼix romano. ");
INSERT INTO husNT2005_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Utsantsik tám enchéꞌ: ―Pos, ka pidhaꞌ an lej pulek takʼix romano xowaꞌ in lujyal kin bachʼu ani ka pidhaꞌ na Dios xowaꞌ Jajáꞌ in lujyal kin bachʼu. ");
INSERT INTO husNT2005_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ani yab ejtowat ka walbindhá kʼal xowaꞌ Jajáꞌ in ulu tin tamét an atiklábtsik; tokot labantsik tam tin achʼaꞌ xan ti tókʼon ani chamkʼantsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Más tayíl, kʼale ti chuꞌtáb na Jesús kʼal cháb óx i saduseotsik. An saduseotsik in ulal abal an chemélomtsik yabich u ejel ti ít ani jaxtám ti utsan enchéꞌ na Jesús: ");
INSERT INTO husNT2005_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","―Okʼtsix, na Moisés tu jiltsámal dhutsadh enchéꞌ: Max jun i inik ka chemech ani yab kin jilaꞌ ni jun i chakam kʼal nin tomtal, nin kidháb jachanꞌ an inik, yejat ka tomkin kʼal an chemtsidh mímláb ani kin kóꞌoy i chakamtsik abal ka kʼwajay jelti max in chakámil nin kidháb xi chemnek. ");
INSERT INTO husNT2005_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Pos alwaꞌich, táꞌwiꞌik ti kʼwajat búk i kwitóltsik in kidhábkʼitsik. Nin jidhtal tomkin, por chemech an yab in jilaꞌ ni jun in chakámil. ");
INSERT INTO husNT2005_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Nin chabtal tomkin kʼal an chemtsidh mímláb, por chemech jeye ani yab in jilaꞌ ni jun in chakámil. ");
INSERT INTO husNT2005_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Tomkin jeye nin oxtal kʼal jachanꞌ an chemtsidh mímláb por yab jeye in kóꞌoy in chakámil. Anchanꞌ tin tʼajaꞌ ejtal xi búk an kwitóltsik, chemechtsik por yab in jilaꞌ ni jun in chakámil. ");
INSERT INTO husNT2005_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Tayíl, chemech jeye an mímláb. ");
INSERT INTO husNT2005_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Tam ka ejechtsik ti ít, ¿kʼal jowaꞌ an kwitól ti neꞌech ti tomikláb jachanꞌ an mímláb abal ejtal xi búk an kwitóltsik tomkinék kʼal jachanꞌ an mímláb? ");
INSERT INTO husNT2005_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Tókʼoyattsik tám enchéꞌ kʼal na Jesús: ―Techéꞌ ti kʼayꞌlá, an iniktsik ani an mímlábtsik u tomkinal. ");
INSERT INTO husNT2005_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Tam kin bajaw xowkʼi neꞌech ka ejdhá ti ít an chemélomtsik xi takudh kʼal na Dios abal ka kʼwajách malilíl i kʼij túꞌ walkʼiꞌ, yabich neꞌech ti tomkinaltsik nibal neꞌech ti pidhnáb xitaꞌ abal ka tomkin, ");
INSERT INTO husNT2005_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","pos, yabich neꞌech ka chemechtsik. Jajáꞌtsik neꞌech ka kʼwajay jelti an tʼokat abatwáletsik ani u chakámlábichtsik kʼal na Dios abal ejnekichtsik ti ít. ");
INSERT INTO husNT2005_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ani kʼal tin kwenta max an chemélomtsik u ejel ti ít, ¿yabxeꞌ jaykʼi a ajyámaltsik bin dhuslábil na Moisés xan ti tawná kʼal na Dios ban kʼidhadh teꞌ xi kʼwajat ti tʼaꞌíl, tam ti utsan enchéꞌ?: “Nanáꞌ tin Diosil na Abraham, na Isák ani na Jakob.” ");
INSERT INTO husNT2005_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Na Dios, yab in Diosil i chemélomtsik; na Dios, in Diosil xi ejattsik; pos abal Jajáꞌ, ejtal kʼwajat ejat. ");
INSERT INTO husNT2005_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Utsan tám enchéꞌ kʼal taltsik an okʼtsixtsik xin wilál an takʼixtaláb: ―Okʼtsix, alwaꞌich xan ta ulu. ");
INSERT INTO husNT2005_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ani yabich más xitaꞌ kʼwajay ti konkomix ni jun xataꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Utsantsik enchéꞌ kʼal na Jesús: ―¿Jantʼókʼi tin ulal an okʼtsixtsik xin wilál nin takʼixtal na Dios ke an Kristo u chakámláb kʼal an pulek takʼix Dabid? ");
INSERT INTO husNT2005_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Pos na Dabid in ulu jeye enchéꞌ xon ti dhutsadh nin ajatlábiltsik: An Okʼóxláb in utsaꞌ enchéꞌ nu Ajátik: “Ki buxkan tu eját, ");
INSERT INTO husNT2005_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","asta ke Nanáꞌ tu átantsi xi ti atʼál.” ");
INSERT INTO husNT2005_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Pos max na Dabid in bijiy jeye tin Ajátik, tám, yab tokotkʼi in kidhtal. ");
INSERT INTO husNT2005_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Kʼal ejtal an atiklábtsik ti kʼwajat ti axnal tam ti na Jesús in utsaꞌ enchéꞌ nin exóbaliltsik: ");
INSERT INTO husNT2005_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―Ka kóꞌoytsik i kwenta kʼal xowaꞌ in tʼajál an okʼtsixtsik xin wilál an takʼixtaláb, yab ka tʼajaꞌtsik xan ti jajáꞌtsik in tʼajál. Jajáꞌtsik in kulbetnál ka xeꞌchin kʼal in jochʼdhaꞌ xekét ani in kulbetnáltsik ka chapnédhá kʼal yantam i kʼakʼnaxtaláb. In kulbetnáltsik jeye ka buxkan ban ultaláb koytalábtsik ban atá xon tu tʼajnal an junkuntaláb ani xon tu tʼajnal i kʼapúch. ");
INSERT INTO husNT2005_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Jajáꞌtsik, in kʼántsal tin kʼimáꞌ an chemtsidh mímlábtsik; ani abal ka utsantsik ke jajáꞌ i alwaꞌ iniktsik, in tʼajál i nakdhaꞌ óláb. Jajáꞌtsik, jaꞌich xi neꞌech kin bachʼu más pakdhaꞌ an yajtsiktaláb. ");
INSERT INTO husNT2005_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Na Jesús kʼwajat ban pulek atá xon tu kʼakʼnáb na Dios in telál xan ti an tumínladh iniktsik in balyal an tumín bin bál an pikbantsixtaláb. ");
INSERT INTO husNT2005_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","In chuꞌu jeye xan ti jun i chʼojontál chemtsidh mímláb tin baliy tajaꞌ cháb i tsʼitsik tʼipax tumín xi yab in lej jalbíl ");
INSERT INTO husNT2005_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","ani in ulu enchéꞌ na Jesús: ―Tsubax tu utsáltsik, ke jechéꞌ an chʼojontál chemtsidh mímláb, más jaꞌ yán in pidhnaꞌ ké xi kʼeꞌettsik; ");
INSERT INTO husNT2005_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","pos xi kʼeꞌettsik tokot in pidhnál xowaꞌ yabich in yéntsal; por an mímláb kʼal in chʼojontáltal, in pidhnaꞌ ejtal xowaꞌ taꞌ tin koꞌol abal kin watʼnaꞌ kʼál na kʼítsá. ");
INSERT INTO husNT2005_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Taltsik kʼwajat in tʼiláltsik an pulek atá xon tu kʼakʼnáb na Dios, in ulaltsik abal labidh tʼajat an tʼujubtsik xi kʼál ti tʼajadh ani ejtal xowaꞌkich xi pidhnats ti pikbaxtaláb. Tam ti na Jesús in achʼaꞌ anchanꞌ, in ulu enchéꞌ: ");
INSERT INTO husNT2005_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","―Neꞌech kin bajaw i kʼij, tam ejtal jechéꞌ xowaꞌ a chuꞌtaltsik neꞌech ka pakwat ani yab neꞌech ka jilkʼon ni jun i tʼujub tʼíꞌbáx. ");
INSERT INTO husNT2005_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Konyat tám na Jesús: ―Okʼtsix, ¿jowkʼi neꞌech ka támun jechéꞌ? ¿Jantʼom exól neꞌech ka waꞌchin tam neꞌech ka támunich jechéꞌ? ");
INSERT INTO husNT2005_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Na Jesús in ulu enchéꞌ: ―Ka kóꞌoytsik tʼajat i kwenta ani yab ka walkaꞌ ki kʼambiyattsik. Pos yán neꞌech ka tsíchtsik kin kʼambixnaꞌ nu bij ani neꞌech kin ulutsik enchéꞌ: “Nanáꞌich nin Kristo, exomich in bajwal an pakwenib.” Por yab ka wéwnaꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Tam ka achʼaꞌtsik exom i péjéxtaláb, yab ki jikʼeytsik; pos jechéꞌ koꞌol ka támun okʼox, por jachanꞌ i kʼij yabél neꞌech ka ulich an pakwenib. ");
INSERT INTO husNT2005_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","In óntsi kin ulu enchéꞌ: ―An atiklábtsik xu kʼwajíl ba jun i pulek chabál, neꞌech ti péjéx kʼal an atiklábtsik xu kʼwajíltsik píl chabál; ani jun i pulek takʼix, neꞌech ti péjéx kʼal kʼeꞌet i pulek takʼix. ");
INSERT INTO husNT2005_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Neꞌech ka léwékʼin an chabál, neꞌech ka waꞌchin i kʼaꞌínab, neꞌech ka waꞌchin i yawꞌláchtsik túkʼi túkʼi, neꞌech ka waꞌchin i kʼakʼadh telomtaláb walkʼiꞌ ani yán i exóltsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","ʼPor tam yabél watʼenek jechéꞌ, neꞌech ki yakʼwantsik ani neꞌech ki atʼantsik. Neꞌech ki júnátsik ta lújundháb ban atá xon tu tʼajnal an junkuntaláb, neꞌech ki balyattsik ban wikʼaxteꞌ, neꞌech ki júnátsik tin tamét an pakdhaꞌ takʼix ani tin tamét an pakdhaꞌ awiltaláb kʼal Nanáꞌkʼi tu kwenta. ");
INSERT INTO husNT2005_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Anchanꞌ, neꞌech ka ejtotsik ti kin tʼilaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Yab ki kʼwajaytsik ta chalpax okʼox xan ti neꞌech ki tókʼon abal ka loꞌotsik tabáꞌ, ");
INSERT INTO husNT2005_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","pos Nanáꞌ neꞌech tu pidhaꞌtsik ti tʼilab ani ti chalab xan ti ki tókʼon abal ni jun xitaꞌ xi ti atʼáltsik, yab kin ejto ti ki tomnaꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Por taltsik xi tatáꞌtsik, neꞌech ka pidhná kʼal nin tátaꞌtsik, taltsik kʼal nin kidháb, taltsik kʼal nin exlowál ani taltsik kʼal nin jaꞌúb. Neꞌech ki chemdhá taltsik xi tatáꞌtsik ");
INSERT INTO husNT2005_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","ani neꞌech ki atʼantsik kʼal Nanáꞌkʼi tu kwenta kʼal ejtal an atiklábtsik xi yab u belom; ");
INSERT INTO husNT2005_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","por yab neꞌech ka kʼibdhaꞌtsik ni jun a xiꞌíl xa koꞌol ba na ókʼ. ");
INSERT INTO husNT2005_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Max ka kuxuytsik ejtal jechéꞌ, neꞌech ka bachʼutsik an xeꞌchintaláb xi yab in koꞌol in okʼontal. ");
INSERT INTO husNT2005_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","ʼTam ka chuꞌutsik abal an bitsow xi Jerusalén wilidhich tu kóꞌyáb kʼal an soldadotsik, ka choꞌóbnaꞌ abal kʼunatich i kʼij neꞌech ka pakwat. ");
INSERT INTO husNT2005_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Jachanꞌ i kʼij, xi kʼwajattsik Judea, yejat ka kʼaletsik ti chinkʼonal ban chʼénlom; xi kʼwajattsik ban bitsow Jerusalén, ka kaletsik tajaꞌ ani xi kʼwajattsik bin ale, yab ka witsiytsik ban bitsow. ");
INSERT INTO husNT2005_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Abal jachanꞌ i kʼij, mapal yajtsiktaláb neꞌech ka waꞌchin, pos anchanꞌ neꞌech ka támun jelt xan ti kʼwajat dhutsadh ban Tʼokat Dhuslab. ");
INSERT INTO husNT2005_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Chʼojontál in chuꞌbíl an mímlábtsik xi kʼwajat kóꞌodh o u tsutsúdhom ti tsʼitsik chakam jachanꞌ i kʼij! Pos jachanꞌ i kʼij, neꞌech ka waꞌchin jun i pulek yajtsiktaláb techéꞌ ti chabál ani neꞌech ka pidhan jun i pulek yajtsiktaláb an atiklábtsik xi yab u belom. ");
INSERT INTO husNT2005_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Taltsik neꞌech ka chemdhá ban péjéxtaláb ani xi kʼeꞌettsik neꞌech ka júná wikʼats túkʼi túkʼi ban píl chabál abal ka tʼajantsik ti jolib. An atiklábtsik xi yabtsik u judío neꞌech ti takʼixtsik ban bitsow xi Jerusalén ani neꞌech kin atʼax tʼajtsi ejtal xowaꞌkich asta kin bajaw xowkʼi neꞌech ka kubdhátsik ti takʼix. ");
INSERT INTO husNT2005_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","ʼJachanꞌ i kʼij, neꞌech ka waꞌchin i exóltsik ba na kʼítsá, ba na íchʼ ani ba na óttsik; techéꞌ ti chabál an atiklábtsik neꞌech ka ukʼpindhá ani neꞌech ka jikʼeytsik tam kin achʼaꞌ ti bososól an jaꞌ ban pujal ani ti múlákʼ. ");
INSERT INTO husNT2005_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Neꞌech ka puteytsik kʼal an jíkʼib tam kin chalpay xantʼéy neꞌech ka támun techéꞌ ban kʼayꞌlá; pos asta an pakdhaꞌ chápláb xi kʼwajat walkʼiꞌ neꞌech ka yoywat. ");
INSERT INTO husNT2005_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Neꞌech tám kin chuꞌtat, Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik tam in tál ba jun i tokow kʼal nu cháp ani kʼal nu labidh tʼokát. ");
INSERT INTO husNT2005_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Tam ka tujéch ti támnal jechéꞌ xowaꞌ in kʼwajat tu utsáltsik, ka likedhaꞌtsik tabáꞌ ani ki kulbé, pos kʼunatich i kʼij neꞌech ki loꞌwattsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Utsantsik jeye jechéꞌ an ti junbaxtaláb: ―Ka telaꞌtsik in akan an igo o kʼeꞌet i teꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Tam ka chuꞌutsik exomich ti eblinal nin xekél, a choꞌóbichtsik abal exomich ti kʼunel an kʼakʼal kʼij. ");
INSERT INTO husNT2005_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Anchanꞌ jeye, tam ka chuꞌúchtsik abal exomich ti támnal xowaꞌ in kʼwajat tu utsál, ka chalpaytsik abal kʼunatich i kʼij neꞌech ka tujey ti takʼix na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","ʼTsubax tu utsáltsik ke ejtal jechéꞌ neꞌech ka támun okʼox ani tám neꞌech ka chemech an atiklábtsik xi xoꞌ kʼwajat ejat jechéꞌ i kʼij. ");
INSERT INTO husNT2005_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","An walkʼiꞌ ani an chabál neꞌech ka wixkʼá, por xowaꞌ u ulal, anchanꞌ neꞌech ka támun. ");
INSERT INTO husNT2005_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","ʼKa kóꞌoytsik tʼajat i kwenta abal yab tokotkʼi ka chalpóm ta kʼapul, ta uchʼal ani xowaꞌ a kulbetnáltsik tʼajat techéꞌ ti kʼayꞌlá abal tam kin bajaw jachanꞌ an kʼij yab ki yakʼwantsik i ukʼpidh, ");
INSERT INTO husNT2005_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","jelt xan tu yakʼwnal jun xitaꞌ kʼal jun i paltsixtaláb, pos anchanꞌ ti neꞌech ka ulich jachanꞌ an kʼij ba ejtal xu kʼwajíltsik putálkʼi techéꞌ an kʼayꞌlá. ");
INSERT INTO husNT2005_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ki kʼwajaytsik echʼekʼi i tʼojojodh, ki ólantsik echʼekʼi abal ka ejto ka jekʼaꞌ ejtal jechéꞌ an yajtsiktaláb xi neꞌech ka watʼey ani ka ejto ki uteytsik kʼal ni jun i jíkʼib tu tamét tam kin tsích juní Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik. ");
INSERT INTO husNT2005_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Na Jesús u okʼtsix tam kʼij ban pulek atá xon tu kʼakʼnáb na Dios ani tam ka jikʼwchinich u kʼalel ban chʼén xin bij Olibos abal ka koyóch tajaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Tsudhey ka tsudhey u ulel dhajawe an atiklábtsik ban pulek atá xon tu kʼakʼnáb na Dios abal kin achʼaꞌtsik xantʼéy in ulal na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Tam ti jachanꞌ i kʼij, exomich ti kʼunel an ajib xowkʼi tu tʼajnal an pan xi yab jilbédhats kʼal an jilbédhaxtaláb kʼoye abal ka kʼapat junax kʼal an borrego xu chemdháb tam exom an ajib xu bijyáb paskwa. ");
INSERT INTO husNT2005_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Nin okʼlékiltsik an páleꞌtsik ani an okʼtsixtsik xin wilál an takʼixtaláb, in ayaltsik xan ti kin uwaꞌ abal kin chemdhaꞌ chinatkʼi na Jesús kom in chʼejnáltsik an atikláb. ");
INSERT INTO husNT2005_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ochich tám an lej atʼax bin itsích na Judas xu bijyáb jeye Iskariote, jechéꞌ na Judas, jaꞌich jún ti éb xi lajucháb an exóbaltsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Na Judas kʼale kin chuꞌu an okʼlek páleꞌtsik ani xu belkoltsik an ti pulek atá xon tu kʼakʼnáb na Dios, káwin kʼal jajáꞌtsik ani in utsaꞌ xan ti neꞌech kin pidhaꞌtsik an ta Jesús abal kin chemdhaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Jajáꞌtsik kulbétsik ani utsan na Judas abal neꞌech ka pidhan ti tumín; ");
INSERT INTO husNT2005_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","na Judas in tokʼoy ani in tuju tám kin aliy xan ti kin uwaꞌ abal kin pidhnaꞌ na Jesús tam yab waꞌach yán i atiklábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","In bajaw in kʼítsájil an ajib xowkʼi tu tʼajnal an pan xi yab jilbédhats kʼal an jilbédhaxtaláb kʼoye abal ka kʼapat junax kʼal an wiyadh borrego xu chemdháb abal tin kwenta an paskwa. ");
INSERT INTO husNT2005_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Na Jesús in abaꞌ tám na Pedro ani na Juan ani in utsaꞌtsik enchéꞌ: ―Ki kʼaletsik ka tʼojojoy an kʼapnél abal tin kwenta an paskwa. ");
INSERT INTO husNT2005_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","In konoytsik enchéꞌ na Jesús: ―¿Jónꞌ ta léꞌ ku kʼale ki tʼojojoy? ");
INSERT INTO husNT2005_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Tókʼoyattsik enchéꞌ kʼal na Jesús: ―Tam ki ochichtsik ban bitsow, neꞌech ka elaꞌ jun i inik xin neꞌdhál jun mul i jaꞌ. Ka wéwnaꞌtsik asta ban atá xon ti ka ochich ");
INSERT INTO husNT2005_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ani ka utsaꞌ enchéꞌ an dhabal atá: “An Okʼtsix in léꞌ kin choꞌóbnaꞌ xon ti kʼwajat an altá xon ti neꞌech kin kʼapu an wiyadh borrego junax kʼal nin exóbaliltsik kʼal tin kwenta an paskwa.” ");
INSERT INTO husNT2005_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Neꞌech tám ti ki óltsitsik jun i altá púlek ba jun i púntsíx atá xi kʼwajat tʼojojodhich; ka tʼojojoy tajaꞌ an tʼokat kʼapúxnich. ");
INSERT INTO husNT2005_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Kʼaletsik tám ani anchanꞌ tin elaꞌ ejtal xan ti usnéktsik kʼal na Jesús ani in lejkíchtsik tám an kʼapnél abal tin kwenta an paskwa. ");
INSERT INTO husNT2005_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Tam tin bajúch an ora, na Jesús ani nin abatwálejiltsik buxkan ban mesa. ");
INSERT INTO husNT2005_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Utsantsik tám enchéꞌ kʼal na Jesús: ―¡U leꞌnámal tʼajat ku kʼapu kʼal tatáꞌtsik jechéꞌ an kʼapnél abal tin kwenta an paskwa tam yabél in chemdhats! ");
INSERT INTO husNT2005_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Pos tu utsáltsik ke yabich neꞌech kin witsiy ku ajíbnaꞌ más an paskwa, asta tam ka tʼájanich xan ti yejat xon tu takʼix na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","In téynaꞌ tám jun i lejab baltsidh ti yajtsik uxnél, in pidhaꞌ ti jalbintsixtaláb na Dios ani in ulu enchéꞌ: ―Ka bachʼutsik jechéꞌ ani ka uchʼaꞌ wetsik wetsik, ");
INSERT INTO husNT2005_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","pos tu utsáltsik ke yabich neꞌech kin witsiy ku uxtsi tin jaꞌlíl an uba asta tam u takʼixich na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Tayíl, in téynaꞌ jeye an pan, in pidhaꞌ ti jalbintsixtaláb na Dios, in pejaꞌ, in pidhaꞌ nin exóbaliltsik ani in utsaꞌtsik enchéꞌ: ―Jechéꞌ jaꞌich nu tʼuꞌúl xi neꞌech ku pidhnaꞌ ka chemdhá abal tatáꞌtsik ta alwaꞌbíl. Ka tʼajáltsik jechéꞌ abal ti kin chalpay. ");
INSERT INTO husNT2005_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Anchanꞌ jeye tin tʼajaꞌ kʼal an yajtsik uxnél tam ti okʼonichtsik ti kʼapul ani in ulu enchéꞌ: ―Jechéꞌ an yajtsik uxnél, jaꞌich nu xichʼál xi neꞌech ku wakʼlaꞌ abal ku jalbiy kʼál na walabtsik. Jaꞌich an ít lejkintaláb xi neꞌech ku tʼajaꞌ abal tatáꞌtsik ta alwaꞌbíl. ");
INSERT INTO husNT2005_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","ʼPor xoꞌ, an inik xi neꞌech ti kin pidhnaꞌ abal kin chemdhá, techéꞌ kʼwajat ti kʼapul kʼal Nanáꞌ ban mesa. ");
INSERT INTO husNT2005_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Pos Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik, koꞌol ku tamu xan tin bijtsidh ke yejat ku watʼnaꞌ; por chʼojontál in chuꞌbíl an inik xi neꞌech ti kin pidhnaꞌ abal kin chemdhá. ");
INSERT INTO husNT2005_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Tujey tám ti kónóx jajáꞌkʼitsik enchéꞌ: ―¿Jitaꞌ awil xi neꞌech an ti pidhnax? ");
INSERT INTO husNT2005_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Tayíl, an exóbaltsik kʼwajay ti káwlíx abal in léꞌ kin choꞌóbnaꞌtsik xitam jáꞌ na más ultaláb xi jajáꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Por utsantsik enchéꞌ kʼal na Jesús: ―An pakdhaꞌ takʼix xi techéꞌ ti kʼayꞌlá, chapiktsik tʼajat in takʼyal nin bitsówil ani an okʼlektsik xi tajaꞌ, u bijyáb ti alwaꞌ iniktsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Por tatáꞌtsik yab yejat ka tʼajaꞌ anchanꞌ, tokot ka tʼajaꞌtsik enchéꞌ: Xitaꞌ más uluts xi tatáꞌtsik, yejat ka kʼwajay jelti xi más tayíl ani xu takʼix, yejat ka kʼwajay jelti xu tʼójontsix. ");
INSERT INTO husNT2005_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Pos ¿jitaꞌ jáꞌ xi más uluts, xu buxkanal ti kʼapul ban mesa o xu tʼójontsix? ¿Yabxeꞌ jaꞌich xu buxkanal ti kʼapul ban mesa? Por Nanáꞌ in kʼwajat kʼal tatáꞌtsik jelti xu tʼójontsix. ");
INSERT INTO husNT2005_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","ʼTatáꞌtsik echʼekʼi tin juniknámal ani yab i kuxkulámadhtsik tam tu watʼnaꞌ xowaꞌkich i yajtsiktaláb. ");
INSERT INTO husNT2005_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Jaxtám, neꞌech tu kʼwajbaꞌtsik ta takʼix jelt xan ti nu Tátaꞌ tin kʼwajbámal tin takʼix ");
INSERT INTO husNT2005_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","abal ki kʼapúchtsik ani ki uchʼáchtsik ba nu mesajil xon ti Nanáꞌ neꞌech tin takʼix. Neꞌech jeye ki buxkantsik ba tʼokat kʼwajtaláb abal ka lújundhaꞌ nin kidhtaltsik xi lajucháb nin chakámiltsik na Israel. ");
INSERT INTO husNT2005_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","In ulu jeye enchéꞌ an Ajátikláb: ―Simón, Simón, ka achʼaꞌ, an lej atʼax in konyámal i awiltaláb abal ti ki tiniytsik jelt xan tu tinyáb an trigo; ");
INSERT INTO husNT2005_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","por tu kontsintsámalich abal yab ka jilaꞌ ta belom. Por tam ka chalpay abal yab alwaꞌ xowaꞌ a tʼajaꞌ ani ki witsiy juní kʼal Nanáꞌ, ka tolmiy na at kidhábtsik abal ti kin belaꞌtsik tokotkʼi Nanáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Utsan tám enchéꞌ kʼal na Simón: ―Ajátik, in kʼwajat tʼojojodh abal kin kʼale junax kʼal Tatáꞌ ban wikʼaxteꞌ ani asta abal kin chemdhá junax kʼal Tatáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Utsan enchéꞌ kʼal na Jesús: ―Pedro, tsubax tu utsál ke xoꞌ tam yabél dhájnék an pekʼel, tatáꞌ óxílich a ulúmal ke yab tin exlál. ");
INSERT INTO husNT2005_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Konyattsik tám enchéꞌ kʼal na Jesús: ―Tam tu abaꞌtsik ka tʼilaꞌ an alwaꞌ tʼilab ani yab a júnaꞌ i morrál, nibal in bál i tumín, nibal a pajabtsik, ¿a yéntsixeꞌ xataꞌ? Jajáꞌtsik tókʼon enchéꞌ: ―Ni jun xataꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Utsantsik tám enchéꞌ: ―Por xoꞌ yab anchanꞌ, max jun xitaꞌ in koꞌol i morrál, kin júnaꞌ ani kin júnaꞌ jeye in bál i tumín. Xitaꞌ yab in koꞌol i machét, kin nuju nin kʼákʼ xekét abal kin chʼaꞌay. ");
INSERT INTO husNT2005_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Pos tu utsáltsik ke koꞌol ka támun kʼal Nanáꞌ jelt xan ti kʼwajat dhutsadh ban Tʼokat Dhuslab enchéꞌ: “Ajyat jeye jelti max yab i alwaꞌ inik.” Pos ejtal xowaꞌ kʼwajat dhutsadh kʼal Nanáꞌ tu kwenta, koꞌol ka támun anchanꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","In ulutsik tam enchéꞌ: ―Ajátik, jéꞌ kʼwajat cháb i machét. Na Jesús tókʼon enchéꞌ: ―Lejatich. ");
INSERT INTO husNT2005_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Kale tám na Jesús, kʼale ban chʼén xu bijyáb Olibos jelt xan tin ujnámalich in tʼajál echʼekʼi ani junikná kʼal nin exóbaliltsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Tam ti ulichtsik tajaꞌ, in utsaꞌ enchéꞌ nin exóbaliltsik: ―Ki ólan abal yab ki átaꞌtsik kʼal an lej atʼax. ");
INSERT INTO husNT2005_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Tayíl ówmé tám na Jesús ba nin exóbaliltsik, nin owíl jaꞌich xónaꞌ jelti xon tu kwajlanal jun i tʼujub tam ka kwiꞌná kʼal jun xitaꞌ ani tudhlan tajaꞌ ti ól. ");
INSERT INTO husNT2005_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Enchéꞌ tin ulu: ―Tátaꞌ, max Tatáꞌ a léꞌ ka chuꞌu yab ku watʼnaꞌ jechéꞌ an yajtsiktaláb, neꞌech ka ejto ti kin wixkʼintsi; por yab ka tʼájan xan ti Nanáꞌ u léꞌ, ka tʼájan xan ti Tatáꞌ a léꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Xalkʼan tám jun i tʼokat abatwále xi tál walkʼiꞌ abal ka pidhan kʼál ti chápláb. ");
INSERT INTO husNT2005_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ani kom púlek tʼajat an yajtsiktaláb xi kʼwajat in achʼál na Jesús, más chapikich u ól ani nin chakʼíb jáykʼijich i xichʼ u tʼuknal chabál. ");
INSERT INTO husNT2005_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Tam ti chʼakay xon ti kʼwajat an ti ól, witsiy xon ti kʼwajat an exóbaltsik ani u wayaltsik tin elaꞌ kom yab in ejtómaltsik kin kuxuy an tʼeꞌpintaláb. ");
INSERT INTO husNT2005_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Utsantsik tám enchéꞌ kʼal na Jesús: ―¿Jantʼókʼi ta wayaltsik? Ki chʼakay ani ki ólan abal yab ki átátsik kʼal an lej atʼax. ");
INSERT INTO husNT2005_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Bél kʼwajat ti káw na Jesús, tam ti ulich yán i atiklábtsik. Okʼox ti tál xu bijyáb ta Judas xi jaꞌich jún ti éb xi lajucháb an exóbaltsik ani utey ba na Jesús abal kin chʼuchʼbay. ");
INSERT INTO husNT2005_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Utsan tám enchéꞌ kʼal na Jesús: ―Judas, ¿kʼal jun i chʼuchʼbaxtaláb ti neꞌech tin pidhnaꞌ kin chemdhá Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik? ");
INSERT INTO husNT2005_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Xi taꞌ ti kʼwajattsik kʼal na Jesús, tam tin chuꞌu xantʼéy exom ti támnal, konoxintsik enchéꞌ: ―Ajátik, ¿ki tomnaꞌxeꞌ kʼal an machét? ");
INSERT INTO husNT2005_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Jún ti éb xi jajáꞌtsik in tʼakʼtsi tin tʼojnálil an okʼlek páleꞌtsik, in tʼakʼtsi tin eját xuchun. ");
INSERT INTO husNT2005_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Por na Jesús in ulu enchéꞌ: ―Jilaꞌ kʼwajat, yab ka tʼajaꞌtsik anchanꞌ. In taktsi tám na Jesús tin xuchun nin tʼójontsixil an okʼlek páleꞌtsik ani in jeldhantsi. ");
INSERT INTO husNT2005_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Tayíl in utsaꞌtsik tám enchéꞌ an okʼlek páleꞌtsik, nin okʼlékiltsik an belkol atá xon tu kʼakʼnáb na Dios ani nin okʼlékil an judíotsik xi ulnektsik kʼál ti yakʼwnal: ―¿Jantʼókʼi ta tsiꞌnektsik kʼal i teꞌ, kʼal i machét abal ti kin yakʼwaꞌ, jelti max neꞌech ka yakʼwaꞌtsik jun i kwéꞌ? ");
INSERT INTO husNT2005_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Tsudhey ka tsudhey in kʼwajinek kʼal tatáꞌtsik ban pulek atá xon tu kʼakʼnáb na Dios ani yab tin takámaltsik; por xoꞌ in bajúmalich na orajiltsik abal ka tʼajaꞌ xowaꞌ na léꞌ ani xowkʼi an lej atʼax, xu takʼix ban jikʼwaxtaláb neꞌech ka walká kin xalkʼaꞌ nin awiltal. ");
INSERT INTO husNT2005_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Yakʼwan tám na Jesús ani júná bin kʼimáꞌ in okʼlékil an páleꞌtsik. Na Pedro wéwnaxin ówkʼi. ");
INSERT INTO husNT2005_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Bin kʼimáꞌ in okʼlékil an páleꞌtsik, jokʼpá i kʼamal chʼejel eléb, buxkantsik malilíl ban kʼamal ani na Pedro buxkan jeye tajaꞌ kʼal jajáꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Támkʼi jachanꞌ, jun i mímláb xu tʼojnal ba jachanꞌ an atá chuꞌtat kʼál na Pedro buxúl bin wál an kʼamal; tam ti chuꞌtat, teloloyat alwaꞌ ani in ulu enchéꞌ an mímláb: ―Jechéꞌ an inik junax jeye ti xeꞌech kʼal na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Por na Pedro in ulu ke yab tsubax. Enchéꞌ tin ulu: ―Mímláb, yab u exlál. ");
INSERT INTO husNT2005_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Más tayíl, chuꞌtat juní kʼal kʼeꞌet ani utsan enchéꞌ: ―Tatáꞌ jayéch teye a kidhtal. Por na Pedro in ulu enchéꞌ: ―Payꞌlomláb, yab u kidhtal. ");
INSERT INTO husNT2005_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Jun i ora xónaꞌ más tayíl, in witsʼkʼo juní jun xitaꞌ kin ulu enchéꞌ: ―Tsubax kʼejle, jechéꞌ an inik taꞌ jeye ti kʼwajat junax kʼal na Jesús, pos jajáꞌ Galilea jeye ti tál. ");
INSERT INTO husNT2005_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","In ulu tám enchéꞌ na Pedro: ―Jaꞌúb, yab u choꞌób xantʼéy i kʼwajat a tʼilál. Támkʼi jachanꞌ, tam ti na Pedro bél kʼwajat ti káw, dhájan an pekʼel. ");
INSERT INTO husNT2005_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Chawkʼin tám an Ajátikláb ani teloloyat na Pedro. Na Pedro in chalpay tám xantʼéy usnék kʼal an Ajátikláb: “Xoꞌ, tam yabél dhájnék an pekʼel, tatáꞌ óxílich a ulúmal ke yab tin exlál.” ");
INSERT INTO husNT2005_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Kale tam na Pedro ani ukʼin tʼajat. ");
INSERT INTO husNT2005_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Na Jesús u labídhnáb ani u chaꞌwáb kʼal an iniktsik xi kʼál ti belkómte. ");
INSERT INTO husNT2005_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","U putsuntsáb tin wal, u chaꞌwáb ani u usnal enchéꞌ: ―¡Ti ku utsaꞌ xitaꞌ ti chaꞌaw! ");
INSERT INTO husNT2005_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ani yán i odhbijixtaláb u usnal. ");
INSERT INTO husNT2005_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Tam ti tsudhey, junkun nin okʼlékiltsik an judíotsik, nin okʼlékiltsik an páleꞌtsik ani an okʼtsixtsik xin wilál an takʼixtaláb. Júná na Jesús tin tamét an Junkulom Awiltaláb ani tajaꞌ, konyat enchéꞌ: ");
INSERT INTO husNT2005_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","―Ti ku utsaꞌ, ¿tatáꞌxeꞌ ni Kristo, xi takudh kʼal na Dios abal ta takʼix? Jajáꞌ in tókʼoytsik enchéꞌ: ―Max tu utsaꞌtsik abal Nanáꞌ, yab neꞌech ti kin beltsi. ");
INSERT INTO husNT2005_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Max tu konoytsik xataꞌ, yab neꞌech ti kin tókʼoytsik nibal neꞌech ti kin walkaꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Por asta xoꞌ, Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik neꞌech kin buxkan bin eját na Dios xi ejtal in ejtowal kin tʼajaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Tayíl konoxin tám ejtaltsik enchéꞌ: ―¿Tatáꞌxeꞌ pé tám ni Chakámláb kʼal na Dios? Tókʼoyattsik enchéꞌ kʼal na Jesús: ―Tatáꞌtsik a ulal abal anchanꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","In ulutsik tám enchéꞌ: ―Yabich más i yéntsal i ólnaxtsik. Pos i achʼaꞌich xan ti Jajáꞌ tu káw. ");
INSERT INTO husNT2005_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Chʼakaytsik tám ejtal ani in júnaꞌtsik na Jesús tin tamét na Pilato. ");
INSERT INTO husNT2005_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Tam ti tajaꞌich tin koꞌoltsik, tujey tám kin ólnaꞌtsik enchéꞌ: ―I elámal abal jechéꞌ an inik in pidhkáwliyal an atiklábtsik xi wawáꞌ i kidhtal. In ulal ke yab yejat ki pidhaꞌ ti jalbixtaláb an lej pulek takʼix romano ani in ulal jeye ke Jajáꞌich nu Kristo, jun i Pulek Takʼix, xi takudh kʼal na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Konyat tám enchéꞌ kʼal na Pilato: ―¿Tatáꞌxeꞌ nin Pulek Takʼíxal an judíotsik? Na Jesús tókʼon enchéꞌ: ―Tatáꞌ a ulal abal anchanꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Na Pilato in utsaꞌ tám enchéꞌ an okʼlek páleꞌtsik ani an atiklábtsik: ―Yab u eltsal ni jun i walastaláb jechéꞌ an inik. ");
INSERT INTO husNT2005_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Por jajáꞌtsik in óntsal kin ulu más kawidh enchéꞌ: ―Exom in péjéxlindhál ejtal an atiklábtsik xi Judea. Tujey ban chabál xi Galilea ani xoꞌ techéꞌich jeye exom in tʼajál. ");
INSERT INTO husNT2005_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Tam ti na Pilato in achʼaꞌ jechéꞌ, in konoytsik max jechéꞌ an inik Galilea u kʼwajíl. ");
INSERT INTO husNT2005_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Tam tin achʼaꞌ abal Galilea u kʼwajíl, in abnaꞌ ba na Erodes, an pulek awiltaláb xi Galilea, xi taꞌ jeye ti kʼwajat Jerusalén jachanꞌ i kʼij. ");
INSERT INTO husNT2005_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Tam ti na Erodes in chuꞌu na Jesús, kulbé tʼajat; pos na Erodes kʼejle owenekich in leꞌnál kin exlaꞌ, kom in achʼál u tʼilnal ani in léꞌ kin chuꞌu tam in tʼajál jun i labidh labandhaxtaláb. ");
INSERT INTO husNT2005_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Yán xataꞌ konyat na Jesús kʼal na Erodes, por yab in tókʼoy ni jún. ");
INSERT INTO husNT2005_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Táꞌ jeye ti kʼwajattsik tajaꞌ in okʼlékil an páleꞌtsik ani an okʼtsixtsik xin wilál an takʼixtaláb, xi kʼál tu ólnáb chapik na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Tám, na Erodes ani nin soldadojiltsik yabtsik in kʼakʼnaꞌ na Jesús. Ani abal kin labídhnaꞌtsik, in xeketliy kʼal i alwaꞌ kʼudhkʼum jelti xin éynál jun i pulek takʼix. Tayíl in abnaꞌ juní ka júná na Jesús ba na Pilato. ");
INSERT INTO husNT2005_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Asta tam ti jachanꞌ i kʼij, na Pilato ani na Erodes in kóꞌoytsik i junaxtaláb; pos tam ti kʼwajatwiꞌik, u átʼáxtsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Na Pilato in junku tám nin okʼlékiltsik an páleꞌtsik, an awiltalábtsik xu takʼix ba jachanꞌ an bitsow, an atiklábtsik ");
INSERT INTO husNT2005_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ani in utsaꞌtsik enchéꞌ: ―Tatáꞌtsik tin tsiꞌdhantsi jechéꞌ an ti inik, a ulaltsik abal in pidhkáwliyal an atiklábtsik, por nanáꞌ u lújundhámalich ta taméttsik ani yab u eltsi ni jun i walastaláb xi tatáꞌtsik a utsál in tʼajám. ");
INSERT INTO husNT2005_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Nibal kʼal na Erodes yab eltsin, pos jéꞌich juní tu witsbantsámal. A telálichtsik abal yab in tʼajámal ni jun xataꞌ xi yejat kin jalbiy kʼal i chemlá. ");
INSERT INTO husNT2005_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Neꞌech ku ulu ka kwadhan ani tám neꞌech ku walkaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Tam exom an ajib, na Pilato in ujnámal kin walkaꞌ jun i wikʼnél. ");
INSERT INTO husNT2005_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Por ejtal tujeytsik ti dhajnal kawidh enchéꞌ: ―¡Ka chemdhaꞌ jachanꞌ an inik! ¡Ani ka walkaꞌ na Barrabás! ");
INSERT INTO husNT2005_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Jechéꞌ na Barrabás, balidh ban wikʼaxteꞌ abal chemdhaxnék ba jun i péjextaláb xin tʼajámal tam tin tomnaꞌ an awiltalábtsik xi ba jachanꞌ an bitsow. ");
INSERT INTO husNT2005_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Na Pilato in léꞌwiꞌik kin walkaꞌ na Jesús ani in tawnaꞌ juní an atiklábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Por jajáꞌtsik más kawidh tin ulutsik enchéꞌ: ―¡Ka chemdhaꞌ pajkʼidh ban peltsidh teꞌ! ¡Ka chemdhaꞌ pajkʼidh ban peltsidh teꞌ! ");
INSERT INTO husNT2005_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Na Pilato in witsʼkʼo juní tin oxtsíl kin utsaꞌ enchéꞌ an atiklábtsik: ―¿Jantʼom walastaláb in tʼajámal? Nanáꞌ yab u eltsal ni jun in walab xi yejat kin jalbiy kʼal i chemlá. Neꞌech ku ulu ka kwadhan ani tám neꞌech ku walkaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Por jajáꞌtsik in óntsi kin konoy abal ka chemdhá na Jesús pajkʼidh ban peltsidh teꞌ; kom kawidh u dhajnal an atiklábtsik ani nin okʼlékiltsik an páleꞌtsik, exbantsat xowaꞌ nin konyaltsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","In tokʼoy tám na Pilato kin tʼajaꞌ xan tu kontsinal, ");
INSERT INTO husNT2005_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","in pidhnaꞌ na Jesús abal ka tʼajtsin xan tin konyal an atiklábtsik ani in walkaꞌ an inik xu kontsinal. Jechéꞌ an inik xi walká, taꞌ ti kʼwajat ti wikʼnél abal chemdhaxnék ba jun i péjextaláb. ");
INSERT INTO husNT2005_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Tam tu neꞌdhábich na Jesús abal ka pajkʼiyat ban peltsidh teꞌ, yakʼwan jun i inik xu kʼwajíl Sirene xu bijyáb ta Simón. Jeché na Simón u witsélich bin ale, tʼajan kin kitnaꞌ an peltsidh teꞌ ani ka kʼale in kitám in aykóm na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Kʼal yán i atiklábtsik ti wewkómte ani yán i mímlábtsik u ukʼnal ani u tʼeꞌpinaltsik kʼal tin kwenta na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Por teloloyattsik kʼal na Jesús ani utsantsik enchéꞌ: ―Mímlábtsik xi kʼwajíl Jerusalén, yab ti kin ukʼintsi, ka ukʼintsi tabáꞌ ani na chakámiltsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Pos neꞌech kin bajaw i kʼij tam neꞌech ka ulwat enchéꞌ: “Kʼijidh tʼajat abal an mímlábtsik xi yab u kóꞌnal, xi yab jaykʼi in waꞌchiyámal ani nibal tsutsudhomámadhtsik.” ");
INSERT INTO husNT2005_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","An atiklábtsik neꞌech tám kin tuju kin ulutsik enchéꞌ: u kwajlanalak an pakdhaꞌ chʼén abal ti ku tʼuꞌchiy. Ani neꞌech jeye kin ulutsik enchéꞌ: u kwajlanalak an tsʼitsik chʼén abal ti ku chinaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Pos max Nanáꞌ, xi yab in walbidh in tʼajtsinal jechéꞌ, ¿jantʼéy neꞌech ka tʼajtsin xi walbidh? ");
INSERT INTO husNT2005_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Táꞌ jeye tu neꞌdháb cháb i atʼax iniktsik abal ka chemdhá junax kʼal na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Tam ti ulichtsik ban chabál xu bijyáb tin Beklék in ókʼ i chemélom inik, pajkʼiyatich tám na Jesús ban peltsidh teꞌ. Pajkʼiyat jeye ba peltsidh teꞌ chablam an atʼax iniktsik, jún tin eját na Jesús ani jún tin kʼwatab. ");
INSERT INTO husNT2005_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Tam ti exomich ti pajkʼiyáb na Jesús ban peltsidh teꞌ, in ulu enchéꞌ: ―Tátaꞌ, ka pakwlantsitsik, pos yab in choꞌób xantʼéy exom in tʼajáltsik. An soldadotsik, abal kin wélchíxnantsi tin kʼudhkʼúmil na Jesús, ubátʼintsik abal kin chuꞌu xitaꞌ kin lujuy kin átaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","An atiklábtsik taꞌ ti kʼwajat tajaꞌ ti telom, asta u labídhnáb na Jesús kʼal an awiltalábtsik ani in ulaltsik enchéꞌ: ―In loꞌómal kʼeꞌettsik, kin loꞌo jeye xoꞌ tinbáꞌ max tsubax lejtal Jajáꞌich nu Kristo xi takudh kʼal na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","U labídhnáb jeye na Jesús kʼal an soldadotsik, u uteltsik kin pidhaꞌ kin uchʼaꞌ ti jiliy yajtsik uxnél ");
INSERT INTO husNT2005_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ani in utsáltsik enchéꞌ: ―¡Max Tatáꞌich lejtal nin Pulek Takʼíxal an judíotsik, ka loꞌo xoꞌ tabáꞌ! ");
INSERT INTO husNT2005_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Kʼwajbá bin ókʼ an peltsidh teꞌ jun i dhuslab xi kʼwajat dhutsadh griego, latín ani ebreo, xin ulal enchéꞌ: “Jechéꞌ jaꞌich nin Pulek Takʼíxal an judíotsik.” ");
INSERT INTO husNT2005_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Jún ti éb an atʼax iniktsik xi taꞌ ti kʼwajat jeye pajkʼidh ban peltsidh teꞌ, u odhbijix enchéꞌ: ―¡Max Tatáꞌich lejtal ni Kristo, ka loꞌo tabáꞌ ani ti ku loꞌo weye! ");
INSERT INTO husNT2005_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Por na jún in kʼwiyaꞌ xi odhbijxin, in utsaꞌ enchéꞌ: ―¿Yab a jikʼnál a Dios, maske i kʼwajat teye a tamtém jayéchkʼi an yajtsiktaláb? ");
INSERT INTO husNT2005_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Wawáꞌ in tomnál waꞌ ki bachʼu jechéꞌ an yajtsiktaláb kom exom i jalbiyal an walastaláb xi tʼajámal; por jechéꞌ an inik, yab in tʼajámal ni jun xataꞌ walats. ");
INSERT INTO husNT2005_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","In ulu tám enchéꞌ an inik xi kʼwiyxin: ―Jesús, ti kin chalpay neye tam ki tujéch ta takʼix. ");
INSERT INTO husNT2005_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Tókʼoyat enchéꞌ kʼal na Jesús: ―Tsubax tu utsál ke xoꞌich neꞌech ki kʼwajay junax kʼal Nanáꞌ ban kʼijidhtaláb xi walkʼiꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Tam ti chʼejelich xónaꞌ a kʼítsá jikʼwchin ani putál an chabál jilkʼon jikʼwax asta óx i wákal. ");
INSERT INTO husNT2005_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Na kʼítsá yab tajkʼan ani xílan an tolow kʼudhkʼum xi taꞌ ti palat ban pulek atá xon tu kʼakʼnáb na Dios. Chab pejeꞌ ti jilkʼon. ");
INSERT INTO husNT2005_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","In ulu tám kawidh na Jesús enchéꞌ: ―Tátaꞌ, ka bachʼu nu ejattal. Tam ti okʼon kin ulu jechéꞌ, chemchich tám. ");
INSERT INTO husNT2005_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Tam ti an okʼlek soldado romano in chuꞌu ejtal xantʼéy támun, in pubédhantsi tin bij na Dios enchéꞌ: ―Tsubax lejtal, jechéꞌ jaꞌich jun i lujat inik. ");
INSERT INTO husNT2005_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ejtal an atiklábtsik xi taꞌ ti kʼwajat ani in chuꞌutsik xantʼéy támun, kʼaletsik tám ani in pewyaltsik nin tamét itsích kʼal tin kwenta an tʼeꞌpintaláb. ");
INSERT INTO husNT2005_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Por ejtal nin jaꞌúbtsik na Jesús ani an mímlábtsik jeye xi juniknaxnéktsik asta Galilea, jilkʼontsik ówkʼi in telál ejtal xowaꞌ támun. ");
INSERT INTO husNT2005_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Táꞌ ti kʼwajat jun i inik xi alwaꞌ inik tʼajat ani lujat xu bijyáb ta José. Jechéꞌ an inik u kʼwajíl ban bitsow Arimatea, an bitsow xi kʼwajat Judea. Jajáꞌ u kidhtaláb jeye kʼal nin Junkulom Awiltalábil an judíotsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Jechéꞌ na José, kʼwajat jeye in aytsím xowkʼi neꞌech kin tujúch ti takʼix na Dios ani jaxtám jajáꞌ yab in káldhál ti alwaꞌ xowaꞌ in tʼajaꞌ an Junkulom Awiltaláb. ");
INSERT INTO husNT2005_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Kʼale kin chuꞌu na Pilato ani in kontsi an tin tʼuꞌúl na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Tam tin paꞌbámich ban peltsidh teꞌ, in boliy kʼal jun i dhak kʼudhkʼum ani in kʼwajbaꞌich tám ban jólimtaláb xi taꞌ ti cholkʼadh ba jun i tʼujub chʼén, xon ti yab jaykʼi jolidh bél ni jun xitaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Tam ti jachanꞌ, jaꞌich nin kʼítsájil xowkʼi tu tʼojojoyáb ejtal xowaꞌ neꞌech ka yéntsin tin kʼítsájil an koyóxnich, pos jun tsudhelom, jaꞌchich nin kʼítsájil an koyóxnich. ");
INSERT INTO husNT2005_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","An mímlábtsik xi tsiꞌnek junax kʼal na Jesús asta Galilea, kʼaletsik, in chuꞌu an jólimtaláb ani in chuꞌutsik jeye xan ti taꞌpantsat an tin tʼuꞌúl na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Tam ti witsiytsik tin kʼimáꞌ, in lejkiytsik i niwiytaláb, i majuxtaláb ani koyóchtsik tin kʼítsájil an koyóxnich, jelt xan tin ulal an takʼixtaláb ke yejat ka tʼajan. ");
INSERT INTO husNT2005_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Tin jidhtal kʼítsájil an semana, an mímlábtsik xin juniknámaltsik na Jesús, kʼale juní ban jólimtaláb dhajawe ani in júnaꞌtsik i niwiytaláb xin lejkiyámal. Juniknátsik jeye kʼal kʼeꞌet i mímlábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Tam ti ulichtsik ban jólimtaláb, in chuꞌu abal an tʼujub xi kʼál ti paxkʼidh an jólimtaláb, wékʼodh. ");
INSERT INTO husNT2005_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ochichtsik, por yab in elaꞌ nin tʼuꞌúl na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Jikʼeytsik tʼajat, ke nibalich in chalpayal xantʼéy kin tʼajaꞌ. Jun jikʼtowále tin chuꞌutsik cháb i iniktsik kubutsik tin wál jajáꞌtsik, xeketlidh kʼal i chʼaxixíl kʼudhkʼum. ");
INSERT INTO husNT2005_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Kom an mímlábtsik jikʼey tʼajat, kutpan asta chabál; por utsantsik enchéꞌ kʼal jachanꞌ an iniktsik: ―¿Jantʼókʼi ta ayal ban chemélomtsik xi kʼwajat ejat? ");
INSERT INTO husNT2005_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Yab waꞌach techéꞌ, ejnekich ti ít. Ka chalpay xan ti utsaꞌtsik tam ti Jajáꞌ bél kʼwajat Galilea, ");
INSERT INTO husNT2005_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","tam tin ulu ke Jajáꞌ, xi abadh abal ka wenkʼon jeye ti inik neꞌech ka pidhná ban walablom iniktsik, neꞌech ka chemdhá pajkʼidh ban peltsidh teꞌ ani tin óxláb a kʼítsá neꞌech ka ejech ti ít. ");
INSERT INTO husNT2005_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","An mímlábtsik in chalpay tám xantʼéy in ulúmal na Jesús ");
INSERT INTO husNT2005_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","ani tam ti witsíchtsik xon ti kʼwajat xi lajujún an abatwáletsik ani ejtal xi más, in tʼiltsitsik ejtal xowaꞌ in chuꞌu. ");
INSERT INTO husNT2005_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Xitaꞌ kʼál ti óltsintsik jechéꞌ an ti tʼilab an abatwáletsik, jaꞌich na María Magdalena, na Juana, na María nin nánaꞌ na Jakobo ani xi kʼeꞌettsik jeye an mímlábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Por an abatwáletsik yab in tʼajaꞌ ti kʼij xowaꞌ in ulu an mímlábtsik ani yab in beltsi. ");
INSERT INTO husNT2005_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Por na Pedro kʼale adhik ban jólimtaláb. Tam ti ulich tajaꞌ ani in telaꞌ altá, in chuꞌu abal yab waꞌach nin tʼuꞌúl na Jesús, tokot in chuꞌu taꞌ ti kʼwajat an dhak kʼudhkʼum xi kʼál ti boltsidh an tin tʼuꞌúl na Jesús. Na Pedro labnék tʼajat ti witsiy tin kʼimáꞌ tam tin chuꞌu xantʼéy támnék. ");
INSERT INTO husNT2005_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Jayéchkʼi jachanꞌ a kʼítsá, cháb xu belnal kʼál na Jesús neꞌech ti bél abal neꞌechtsik ban kwentsal xin bij Emaús, nin owíl, jaꞌich xónaꞌ lajujún i kilómetro abal Jerusalén. ");
INSERT INTO husNT2005_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","In tʼiláltsik ti neꞌech ejtal xantʼéy támun kʼal tin kwenta na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ani lejat neꞌechtsik in tʼilál ani in káwlíxnál jechéꞌ, utuknátsik kʼal na Jesús ani beley junax kʼal jajáꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Por maske in chuꞌtaltsik, yab u pidhnal kin exlaꞌ max jaꞌich na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Konyattsik tám enchéꞌ kʼal na Jesús: ―¿Jantʼéy pé a tʼiláltsik? Ani ¿jantʼókʼi ta tʼeꞌpinaltsik? ");
INSERT INTO husNT2005_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Jún ti éb xi jajáꞌtsik, xu bijyáb ta Cleofas, tókʼon enchéꞌ: ―Ejtal an atiklábtsik in choꞌób xantʼéy támnék Jerusalén jechéꞌ i kʼij, ¿tokot Tatáꞌ xi tajaꞌ teye ta kʼwajat yab a choꞌóbnámal? ");
INSERT INTO husNT2005_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Utsantsik tám enchéꞌ kʼal na Jesús: ―¿Jantʼéy pé támnék? Jajáꞌtsik tókʼon enchéꞌ: ―Na Jesús xi Nasaret pidhná kʼal nin okʼlékil an páleꞌtsik ani kʼal ni awiltalábiltsik abal ka chemdhá pajkʼidh ban peltsidh teꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Jechéꞌ na Jesús, jaꞌich jun i tʼiltsix xin koꞌol tʼajat i awiltaláb kʼal xowaꞌ in tʼajál ani kʼal xowaꞌ xin ulal tin tamét na Dios ani tin tamét jeye an atiklábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Wawáꞌ i chalpayámal max Jajáꞌich xi neꞌech ti ku loꞌo ejtal wawáꞌ xu israelita ani xoꞌ watʼenekich óx a kʼítsá ti chemdhats. ");
INSERT INTO husNT2005_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Por taltsik i mímlábtsik xi wawáꞌ i kidhtal tu labandhámal, pos kʼalnektsik dhajawe ban jólimtaláb ");
INSERT INTO husNT2005_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ani kom yab in eltsi an tin tʼuꞌúl na Jesús, tam ti witsiytsik tu utsaꞌ abal in chuꞌúmal i tʼokat abatwáletsik xi usnéktsik kʼál abal na Jesús ejnek ti ít. ");
INSERT INTO husNT2005_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Tayíl kʼale jeye cháb óx ni kidhtaltsik ban jólimtaláb ani anchanꞌ tin elaꞌtsik xan tin ulúmal an mímlábtsik, por yab in chuꞌutsik na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Utsantsik tám enchéꞌ kʼal na Jesús: ―¡Yabtsik tʼajat a ejtowal ka exbay ani tʼojláb tʼajat ka belaꞌtsik xowaꞌ in ulúmal an tʼiltsixtsik! ");
INSERT INTO husNT2005_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Yabxeꞌ in ulúmal an tʼiltsixtsik ke koꞌol kin watʼnaꞌ okʼox ejtal jechéꞌ an Kristo abal tayíl kin bachʼu nin kʼakʼnabíl? ");
INSERT INTO husNT2005_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Tujey tám ti wiltsinaltsik ejtal xowaꞌ kʼwajat dhutsadh ban Tʼokat Dhuslab xi kʼal Jajáꞌ tin kwenta, in tuju kʼal nin dhutsadh úwil na Moisés ani tayíl kʼal ejtal nin dhutsadh úwil an tʼiltsixtsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Tam ti ulich ban kwentsal xon tin ulúmal neꞌechtsik, na Jesús in wáynaꞌ jelti max neꞌech kin óntsi an bél. ");
INSERT INTO husNT2005_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Por in pakabédhaꞌ abal ka jilkʼon jeye kʼal jajáꞌtsik, enchéꞌ tin utsaꞌ: ―Ki jilkʼon teye kʼal wawáꞌ, pos dhamúlich ani exomich ti jikʼwchinal. Ochich tám na Jesús abal ka jilkʼon kʼal jajáꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Tam ti kʼwajatich buxutsik ban mesa, in téynaꞌ an pan, in lábtʼajaꞌ, in pejaꞌ ani pidhantsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Támkʼi jachanꞌ, pidhanichtsik tám kin exlaꞌ abal jaꞌich na Jesús xi taꞌ ti kʼwajat kʼal jajáꞌtsik. Por Jajáꞌ yab más chuꞌtat. ");
INSERT INTO husNT2005_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Útsáxintsik tám enchéꞌ: ―¿Yabxeꞌ tu kʼijidhmédhantsi ti itsích kʼal tin kwenta tam ti tál ti bél tu tʼiltsal ani tu wiltsal an ti Tʼokat Dhuslab? ");
INSERT INTO husNT2005_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Támkʼi jachanꞌ in tujutsik an bél abal ka witsiy Jerusalén. Tam ti ulichtsik, in elaꞌ junkunék xi lajujún an abatwáletsik ani nin juniktsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Utsantsik enchéꞌ xi cháb: ―Tsubax lejtal, an Ajátikláb ejnek ti ít ani in xalkʼámal tinbáꞌ abal ka chuꞌtat kʼal na Simón. ");
INSERT INTO husNT2005_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","In tʼilaꞌtsik jeye tám xi cháb xantʼéy in tamúm ti bél ani xan tin exlaꞌtsik na Jesús tam tin pejaꞌ an pan. ");
INSERT INTO husNT2005_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Bél kʼwajat in tʼiláltsik jechéꞌ, tam ti na Jesús xalkʼan junax chʼejel xon ti kʼwajattsik ani chapnédhomách enchéꞌ: ―Ki kʼwajaytsik kʼijidh. ");
INSERT INTO husNT2005_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Jikʼeytsik tʼajat abal in chalpay max kʼwajat in teláltsik jun i ejattaláb. ");
INSERT INTO husNT2005_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Por utsantsik enchéꞌ kʼal na Jesús: ―¿Jantʼókʼi ta jikʼéltsik? ¿Jantʼókʼi ta chalpaxtsik tʼajat ta itsích? ");
INSERT INTO husNT2005_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ka telaꞌtsik nu kʼubak ani nu akan. Nanáꞌ. Ti kin takaꞌtsik ani ti kin telaꞌ, jun i ejattaláb yab in koꞌol i tʼuꞌlek nibal i beklek jelt xan ta chuꞌtaltsik u koꞌol. ");
INSERT INTO husNT2005_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Tam ti na Jesús in ulu jechéꞌ, in ólnaꞌ nin kʼubak ani nin akan. ");
INSERT INTO husNT2005_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Por kom jajáꞌtsik yabél in belál max ejnek ti ít abal u kulbéltsik ani labnéktsik tʼajat, utsantsik enchéꞌ kʼal na Jesús: ―¿A koꞌoltsikxeꞌ techéꞌ i kʼapnél? ");
INSERT INTO husNT2005_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Pidhan tám jun pejeꞌ ti wiyadh toꞌol ani jun pejeꞌ ti tʼuyikʼ kʼal i chiꞌik, ");
INSERT INTO husNT2005_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","in bachʼu ani kʼwajay kin kʼapu tin tamét jajáꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Tayíl utsantsik enchéꞌ: ―Xowaꞌ u tamu, jaꞌich xowaꞌ tu utsaꞌ tam ti bél in kʼwajat kʼal tatáꞌtsik: ke koꞌol ka támun ejtal xan ti kʼwajat dhutsadh kʼal Nanáꞌ tu kwenta ba nin takʼixtal na Dios xin jilám dhutsadh na Moisés, bin dhutsadh úwil an tʼiltsixtsik ani ban ajatlábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","In pidhaꞌtsik tám ti chalab abal kin exbaytsik an Tʼokat Dhuslab ");
INSERT INTO husNT2005_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ani enchéꞌ tin utsaꞌtsik: ―Anchanꞌ ti kʼwajat dhutsadh, ke an Kristo, xi jaꞌich Nanáꞌich, koꞌol kin chemdhá ani tin óxláb a kʼítsá neꞌech kin ejech ti ít. ");
INSERT INTO husNT2005_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Kʼwajat jeye dhutsadh, ke koꞌol ka tʼiltsin an atiklábtsik abal yejatich kin jilaꞌtsik ti walablom ani ti kin belaꞌ abal ka pakwlantsatich tin walastalábiltsik kʼal na Dios. Jechéꞌ an tʼiltsixtaláb, Neꞌech ka tujey Jerusalén ani tayíl putálkʼi an kʼayꞌlá neꞌech ka tʼilan. ");
INSERT INTO husNT2005_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Tatáꞌtsik yejat ka tʼilaꞌ ejtal jechéꞌ xowaꞌ a chuꞌúmaltsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ani Nanáꞌ neꞌech tu abtsitsik an ti Tʼokat Ejattaláb xin ulúmal neꞌech ti ki abtsi an Tátaꞌláb. Por ki jilkʼontsik techéꞌ ban bitsow xi Jerusalén asta ka bachʼutsik nin cháp an Tʼokat Ejattaláb xi neꞌech ka tsích walkʼiꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Káldhátsik tám kʼal na Jesús ba jachanꞌ an bitsow ani júnátsik asta Betania, in dhayaꞌ tám nin kʼubak tʼekʼat na Jesús ani lábtʼajantsik. ");
INSERT INTO husNT2005_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Tam tin lábtʼajaꞌichtsik, ówmé kʼal jajáꞌtsik ani júnájich tám walkʼiꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Tam ti okʼonichtsik kin kʼakʼnaꞌ, u kulbéltsik tʼajat ti witsiytsik Jerusalén, ");
INSERT INTO husNT2005_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","echʼekʼi u kʼaleltsik ban pulek atá xon tu kʼakʼnáb na Dios ani in pubédhantsal tin bij na Dios. Anchanꞌ ka tʼájan.");
INSERT INTO husNT2005_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Tam ti yabél tʼajadh an walkʼiꞌ ani an chabál, kʼejle Jaꞌ kʼwajatich jachanꞌ xu bijyáb tin Káwintal na Dios; ani jachanꞌ nin Káwintal na Dios, kʼwajat kʼal na Dios ani jaꞌich na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Pos tam ti yabél tʼajadh an walkʼiꞌ ani an chabál, Jajáꞌ kʼejle kʼwajatich kʼal na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Kʼal Jajáꞌkʼi tin kwenta na Dios tin tʼajaꞌ ejtal xowaꞌ waꞌach; yab waꞌach ni jun xataꞌ xowaꞌ yab tʼajadh kʼal Jajáꞌkʼi tin kwenta. ");
INSERT INTO husNT2005_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Kʼal Jajáꞌ ti kʼwajat an ít xeꞌchintaláb ani jechéꞌ an ít xeꞌchintaláb jaꞌich an tajaxtaláb abal an atiklábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Jechéꞌ an tajaxtaláb u tajbax ban jikʼwaxtaláb ani an jikʼwaxtaláb yab in ejtómal kin tepdhaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Waꞌchin jun i inik xi abadh kʼal na Dios, xin bij ta Juan. ");
INSERT INTO husNT2005_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Jechéꞌ na Juan, tsích jelti jun i óltsix abal kin ólnaꞌ jachanꞌ an tajaxtaláb abal ejtaltsik ka belmách kʼal tin kwentakʼi xowaꞌ in ólnál na Juan. ");
INSERT INTO husNT2005_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Na Juan yab jajáꞌ nu tajaxtaláb; jajáꞌ jaꞌich jun i óltsix xi abnék abal kin ólnaꞌ an tajaxtaláb. ");
INSERT INTO husNT2005_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","An lej tajaxtaláb, xin tajbayal ejtal an atiklábtsik, u ulelich ti kʼwajat ban kʼayꞌlá. ");
INSERT INTO husNT2005_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Jachanꞌ xu bijyáb tin Káwintal na Dios kʼwajatich ban kʼayꞌlá ani maske kʼal Jajáꞌkʼi tin kwenta ti tʼajadh an kʼayꞌlá, yab exlá kʼal xi kʼwajattsik ban kʼayꞌlá. ");
INSERT INTO husNT2005_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Tsích ban kʼayꞌlá xon ti kʼwajattsik xi Jajáꞌ in tʼajámal, por yab bachʼwat kʼal jajáꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Por ejtaltsik xitaꞌ kʼál ti bachʼwat ani belan, pidhantsik ti awiltaláb ka kʼwajay u chakámláb kʼal a Dios. ");
INSERT INTO husNT2005_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Yab in junwal jelti xu chakámlábtsik kʼal i tátaꞌláb xi techéꞌ ti kʼayꞌlá, xu waꞌchinaltsik ti chakam kom anchanich ti jilnéktsik o abal anchanꞌ tin kulbetnaꞌ jun i inik; jajáꞌtsik u chakámláb kʼal a Dios. ");
INSERT INTO husNT2005_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ani jachanꞌ xu bijyáb tin Káwintal na Dios, wenkʼon ti inik ani kʼwajay kʼal wawáꞌ, kʼal yantam i alwaꞌtaláb ani i tsubaxtaláb. I chuꞌtsámalich tin labidh tʼokát, xi jaꞌich nin labidh tʼokát nin junkax Chakámil an Tátaꞌláb. ");
INSERT INTO husNT2005_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Na Juan jaꞌich in tʼilál tam tin ulu enchéꞌ: ―Jechéꞌ jaꞌich xi nanáꞌ tu tʼiltsámaltsik, tam tu ulu ke xi neꞌech ka tsích tayíl, kʼwajat más ultaláb ké nanáꞌ, kom Jajáꞌ kʼejlejich Jaꞌ kʼwajat tam ti nanáꞌ yabél in waꞌach. ");
INSERT INTO husNT2005_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Kʼal ejtal xowaꞌ Jajáꞌ in koꞌol, i bachʼkʼuntsámalich yán tin lábtʼajaxtalábil kʼal tin kwentakʼi nin alwaꞌtal. ");
INSERT INTO husNT2005_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","An takʼixtaláb pidhan na Moisés abal kin ólnaꞌ, por an alwaꞌtaláb ani an tsubaxtaláb tsích kʼal tin kwentakʼi na Jesukristo. ");
INSERT INTO husNT2005_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Yab jaykʼi chuꞌudh na Dios kʼal ni jun xitaꞌ; tokot kʼal nin junkax Chakámil ti chuꞌudh, xi kʼwajat junax kʼal an Tátaꞌláb ani jaꞌich Jajáꞌ xi tu óltsámal abal ki exlaꞌ an Tátaꞌláb. ");
INSERT INTO husNT2005_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","An judíotsik xi Jerusalén in abaꞌ i páleꞌtsik ani i lebitatsik ba na Juan abal kin konoy xitam jáꞌ jeye jajáꞌ, ");
INSERT INTO husNT2005_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","por na Juan in ulu tsubax enchéꞌ: ―Yab nanáꞌ nin Kristo. ");
INSERT INTO husNT2005_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Konyat tám juní: ―¿Tatáꞌxeꞌ pé ni Elías, an tʼiltsix? Na Juan in ulu enchéꞌ: ―Yab nanáꞌ. Konyat tám juní enchéꞌ: ―Tám, ¿tatáꞌichxeꞌ pé an tʼiltsix xi bijidh neꞌech ka tsích? Ani jajáꞌ tókʼon enchéꞌ: ―Yabaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Utsan tám enchéꞌ: ―¿Pos jitaꞌ pé teye? Koꞌol ki júntsi jun i tsubaxtaláb xi tu abámal. ¿Jantʼéy pé neꞌech ti ku utsaꞌ kʼal tatáꞌ ta kwenta? ");
INSERT INTO husNT2005_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Na Juan in tókʼoytsik enchéꞌ: ―Nanáꞌich xin tʼilámal an tʼiltsix Isaías tam tin ulu enchéꞌ: Achʼat in káwintal jun xitaꞌ ban chabál xon ti yab kʼwajtsidh ani xu káw, in ulal kawidh enchéꞌ: “Ka júnaꞌichtsik jun i xeꞌchintaláb alwaꞌ; abal anchanꞌ, ki kʼwajáchtsik tʼojojodh tam ka tsích an Ajátikláb.” ");
INSERT INTO husNT2005_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Xi kʼalnektsik ti káw kʼal na Juan, abnék kʼal an fariseotsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ani in konoytsik enchéꞌ: ―Tám, max yab tatáꞌ ni Kristo, nibal i Elías, nibal an tʼiltsix xi bijidh neꞌech ka tsích, ¿jantʼókʼi pé tám ta pujax? ");
INSERT INTO husNT2005_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Utsantsik tám enchéꞌ kʼal na Juan: ―Nanáꞌ tu pujyaltsik kʼal i jaꞌ, por kʼal tatáꞌtsik taꞌ kʼwajat jún xi yabtsik a exlál. ");
INSERT INTO husNT2005_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Neꞌech ka tsích tayíl, por Jajáꞌ kʼwajat más ultaláb ké nanáꞌ. Nanáꞌ yab xataꞌ u éy nibal abal ku wiltsi tin wikʼáb nin pajab. ");
INSERT INTO husNT2005_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ejtal jechéꞌ támun ban chabál xin bij Betábara, xu jilkʼonal ejtsím kalel kʼítsá kʼal an waljaꞌ Jordán, xon ti na Juan kʼwajat ti pújal. ");
INSERT INTO husNT2005_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Tam ti jun tsudhelom, na Juan in chuꞌu ti utel na Jesús xon ti jajáꞌ kʼwajat ani in ulu enchéꞌ na Juan: ―Ka telaꞌtsik, jechéꞌ jaꞌich jelti nin borregojil na Dios xi neꞌech ka pikbá abal kin wékʼontsi tin walastalábil an atiklábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Jajáꞌ u tʼilál tin kʼwajat tam tu ulu enchéꞌ: “Tayíl neꞌech ka tsích jun i inik xi más ultaláb ké nanáꞌ, abal kʼejle Jaꞌ kʼwajatich tam ti nanáꞌ yabél in waꞌach.” ");
INSERT INTO husNT2005_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Nanáꞌ yab u exlál xitam jáꞌ jeye Jajáꞌ; por jaꞌich tin pújal kʼal i jaꞌ abal ka exlá kʼal an atiklábtsik xi Israel. ");
INSERT INTO husNT2005_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","In ulu jeye enchéꞌ na Juan: ―Nanáꞌ u chuꞌu an Tʼokat Ejattaláb ti paꞌíl walkʼiꞌ jelti jun i kukuꞌ ani jilkʼon kʼal Jajáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Nanáꞌ yab u exlál xitam jáꞌ jeye Jajáꞌ; por xi tin abámal tin pújal kʼal i jaꞌ, tin utsaꞌ enchéꞌ: “Tam ka chuꞌu an Tʼokat Ejattaláb ti paꞌíl ani ka jilkʼon ba jun xitaꞌ, jachanꞌ jaꞌich xi neꞌech ti pújal kʼal an Tʼokat Ejattaláb.” ");
INSERT INTO husNT2005_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ani xoꞌ nanáꞌ u chuꞌúmalich ani u ulal ke jechéꞌ jaꞌich nin Chakámil na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Tam ti jun tsudhelom, tajaꞌ juní ti kʼwajat na Juan junax kʼal cháb in exóbaliltsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ani tam tin chuꞌu taꞌ ti xeꞌech na Jesús, na Juan in ulu enchéꞌ: ―Ka telaꞌtsik, jechéꞌ jaꞌich jelti nin borregojil na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Chablam nin exóbaliltsik na Juan in achʼaꞌ tam tin ulu jechéꞌ ani in wéwnaꞌtsik na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","In telaꞌ tám na Jesús tin kúx, in chuꞌu abal wewkómte ani in utsaꞌtsik enchéꞌ: ―¿Jantʼéy a ayaltsik? Jajáꞌtsik in utsaꞌ enchéꞌ: ―Okʼtsix, ¿jónꞌ pé teye i kʼwajíl? ");
INSERT INTO husNT2005_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Tókʼoyattsik enchéꞌ kʼal na Jesús: ―Jalaꞌ ani neꞌech ka chuꞌutsik. Kʼaletsik tám ani in chuꞌu xon tu kʼwajíl na Jesús. Jachanꞌ a kʼítsá jilkʼontsik kʼal Jajáꞌ abal tam ti jachanꞌ jaykʼich xónaꞌ chéꞌich i wákal. ");
INSERT INTO husNT2005_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Jún ti éb an exóbaltsik xin achʼámaltsik xan tin ulu na Juan ani in wéwnámal na Jesús, jaꞌich na Andrés, nin kidháb na Simón Pedro. ");
INSERT INTO husNT2005_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Na Andrés, kʼale okʼox kin aliy nin kidháb Simón ani in utsaꞌ enchéꞌ: ―I elámal an Mesías ―jechéꞌ in léꞌ kin ulu, an Kristo. ");
INSERT INTO husNT2005_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Na Andrés in júnaꞌ tám na Simón xon ti kʼwajat na Jesús ani tam ti na Jesús in chuꞌu na Simón, in utsaꞌ enchéꞌ: ―Tatáꞌ i Simón, xi chakámláb kʼal na Jonás, por neꞌech ki bijyat ta Sefas ―jechéꞌ in léꞌ kin ulu, Pedro. ");
INSERT INTO husNT2005_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Tam ti jun tsudhelom, na Jesús in leꞌnaꞌ ka kʼale ban chabál xi Galilea, in elaꞌ na Felipe ani in utsaꞌ enchéꞌ: ―Ti kin wéwnaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Jechéꞌ na Felipe u kʼwajíl ban bitsow xin bij Betsayda, xon tu kʼwajíltsik jeye na Andrés ani na Pedro. ");
INSERT INTO husNT2005_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Na Felipe in elaꞌ na Natanael ani in utsaꞌ enchéꞌ: ―I elámal an inik xu tʼilnal kʼal an tʼiltsixtsik ani kʼal nin takʼixtal na Dios xin jilám dhutsadh na Moisés. Jechéꞌ an inik jaꞌich na Jesús, xu chakámláb kʼal na José xu kʼwajíl ban bitsow Nasaret. ");
INSERT INTO husNT2005_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Na Natanael in utsaꞌ enchéꞌ na Felipe: ―¿Awxeꞌ neꞌech kin ejto ka waꞌchin jun xataꞌ alwaꞌ Nasaret? Tókʼoyat enchéꞌ kʼal na Felipe: ―Jalaꞌ ani wana ka chuꞌu. ");
INSERT INTO husNT2005_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Tam ti na Jesús in chuꞌu ke na Natanael exomich ti kʼunel, in ulu enchéꞌ kʼal tin kwenta na Natanael: ―Jéꞌ tál jun i inik xi tsubax lejtal tu israelita ani yab u kʼambix. ");
INSERT INTO husNT2005_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Konyat tám enchéꞌ kʼal na Natanael: ―¿Jónꞌ pé tám tin exlámal? Tókʼoyat enchéꞌ kʼal na Jesús: ―Nanáꞌ kʼejle tu chuꞌúmalich tam ti yabél i kanidh kʼal na Felipe, tam ta kʼwajat tin ál in akan an igo. ");
INSERT INTO husNT2005_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Utsan tám enchéꞌ kʼal na Natanael: ―Okʼtsix, Tatáꞌ i Chakámláb kʼal a Dios; Tatáꞌ nin Pulek Takʼíxal an israelitatsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Tókʼoyat enchéꞌ kʼal na Jesús: ―¿Tin belál abalkʼi tu utsaꞌ ke tu chuꞌúmal tin ál in akan an igo? Pos neꞌech ka chuꞌu tayíl xantʼéy más pakdhaꞌ ké jechéꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","In ulu jeye enchéꞌ na Jesús: ―Tsubax tu utsáltsik, ke neꞌech ka chuꞌutsik japidh an walkʼiꞌ ani neꞌech ka chuꞌutsik ti paꞌíl ani ti kʼadhíl nin tʼokat abatwálejiltsik na Dios, ba Nanáꞌich xin abadh abal kin wenkʼon neye tin inik. ");
INSERT INTO husNT2005_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Óx a kʼítsá tayíl, waꞌchin jun i tomkixtaláb ban bitsow Kaná, xu takʼnal ban chabál xi Galilea ani tajaꞌ ti kʼwajat nin nánaꞌ na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Na Jesús ani nin exóbaliltsik kanidhtsik jeye ba jachanꞌ an tomkixtaláb. ");
INSERT INTO husNT2005_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Taley an yajtsik uxnél ani utsan enchéꞌ na Jesús kʼal nin nánaꞌ: ―Yabich in koꞌoltsik i yajtsik uxnél. ");
INSERT INTO husNT2005_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Por tókʼoyat enchéꞌ kʼal na Jesús: ―Mímláb, ¿jantʼéy koꞌol ki chuꞌu wawáꞌ kʼal jechéꞌ? Yabél in bajúmal xowkʼi neꞌech ku xalkʼaꞌ xitam jáꞌ neye Nanáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Por utsan enchéꞌ kʼal nin nánaꞌ na Jesús xi kʼwajattsik ti tʼojojól: ―Ka tʼajaꞌtsik ejtal xowaꞌ Jajáꞌ ti ki utsaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Táꞌ tu kóꞌyáb tajaꞌ akak i pakdhaꞌ balixtaláb xi tʼajadh kʼal i tʼujub xu baltsinal ti jaꞌ, xin éynál an judíotsik kin tʼakaxnaꞌ abal kin tʼoko tinbáꞌ. Xi jun i yejcheꞌ balixtaláb in ákʼnál cheꞌ inik o boꞌ inik litro i jaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Na Jesús in utsaꞌ enchéꞌ xi kʼwajattsik ti tʼojojól: ―Ka tsʼutsiy kʼal i jaꞌ jachanꞌ an pakdhaꞌ balixtaláb. In tsʼutsiytsik tám alwaꞌ ");
INSERT INTO husNT2005_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","ani utsantsik tám enchéꞌ kʼal na Jesús: ―Ka jotʼiytsik xoꞌ wéꞌ ani ka júntsi an tʼojom ajib. Ani anchanꞌ tin tʼajaꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","An tʼojom ajib in lekaꞌ an jaꞌ xi wenkʼonékich ti yajtsik uxnél, maske yab in choꞌób xon tu tsiꞌdháb; tokot in choꞌób xi kʼwajattsik ti tʼojojól, kom jajáꞌtsik in jotʼyámal an jaꞌ. An tʼojom ajib in kaniy tám an tomkinél inik ");
INSERT INTO husNT2005_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ani in utsaꞌ enchéꞌ: ―Ejtalkʼi in pidhnál okʼox an alwaꞌ yajtsik uxnél ani tam yánich in uchʼám an ajíblomtsik, tám neꞌech kin pidhnaꞌ an yajtsik uxnél xi yab lej alwaꞌ. Por tatáꞌ a taꞌpámal an alwaꞌ yajtsik uxnél abal ka pidhnaꞌ tayíl. ");
INSERT INTO husNT2005_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jechéꞌ xowaꞌ in tʼajaꞌ na Jesús ban bitsow Kaná xu takʼnal Galilea, jaꞌich an jidhtal labidh exól xi kʼál tin xalkʼaꞌ nin labidh tʼokát ani belan kʼal nin exóbaliltsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Tam ti watʼéch ejtal jechéꞌ, kʼale ban bitsow xin bij Kapernaúm, junkímte kʼal nin nánaꞌ, nin kidhábtsik ani nin exóbaliltsik. Tajaꞌ ti kʼwajay cháb óx a kʼítsá. ");
INSERT INTO husNT2005_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Tam ti exomich ti kʼunel xowkʼi an judíotsik tin ajíbnál an paskwa, na Jesús kʼale ban bitsow xin bij Jerusalén. ");
INSERT INTO husNT2005_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","In elaꞌ tajaꞌ altá ban pulek atá xon tu kʼakʼnáb na Dios, xin nujwaltsik i baka, i borrego, i kukuꞌ ani xin jaltsal ti tumín an atiklábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Tam tin chuꞌu jechéꞌ, na Jesús in tʼajaꞌ jun i wichʼateꞌ kʼal i ládhutsik ani in ajaꞌtsik ejtal ka kale eléb xi táꞌ ti kʼwajattsik tajaꞌ ti nújul, junax kʼal nin borregojiltsik ani nin bákajiltsik. Xin jaltsal an ti tumín an atiklábtsik, in wakʼlantsi an ti tʼipax tumín chabál ani in kʼetʼpantsi an tin mesajiltsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","An nújul kukuꞌtsik utsan enchéꞌ kʼal na Jesús: ―¡Ka káldhaꞌtsik eléb xi jechéꞌ! ¡Yab ka wenkʼo nin kʼimáꞌ nu Tátaꞌ ti nújumtaláb! ");
INSERT INTO husNT2005_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","In chalpay tám nin exóbaliltsik xi kʼwajat dhutsadh enchéꞌ ban Tʼokat Dhuslab: “U kʼanidhál tʼajat na kʼimáꞌ.” ");
INSERT INTO husNT2005_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Konyat tám enchéꞌ kʼal an judíotsik: ―¿Jantʼom exól neꞌech ti ku pidhaꞌ ki chuꞌu abal ki exlaꞌ ke aniꞌ lejtal ta koꞌol i awiltaláb ka tʼajaꞌ jechéꞌ? ");
INSERT INTO husNT2005_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Tókʼoyattsik enchéꞌ kʼal na Jesús: ―Ka pakutsik jechéꞌ an pulek atá xon tu kʼakʼnáb na Dios ani Nanáꞌ neꞌech ku kubaꞌ ti ít ti óx a kʼítsá. ");
INSERT INTO husNT2005_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Utsan tám enchéꞌ kʼal an judíotsik: ―Chab inik kʼal akak i tamub in júnámal abal ka kuban jechéꞌ an pulek atá xon tu kʼakʼnáb na Dios; ani ¿Tatáꞌ a ulal ke neꞌech ka kubaꞌ ti ít ti óx a kʼítsá? ");
INSERT INTO husNT2005_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Por an pulek atá xon tu kʼakʼnáb na Dios xi kʼwajat in tʼilál na Jesús jaꞌich Jajáꞌ nin tʼuꞌúl. ");
INSERT INTO husNT2005_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Jaxtám, tam ti na Jesús chemdhá ani ejech ti ít, nin exóbaliltsik in chalpay jechéꞌ xowaꞌ in ulúmal na Jesús ani in belaꞌtsik an Tʼokat Dhuslab ani ejtal xowaꞌ usnéktsik kʼal na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Tam ti na Jesús kʼwajat Jerusalén, ban ajib kʼal tin kwenta an paskwa, kʼal yán ti belan tam tin chuꞌutsik an labidh exóltsik xin tʼajál. ");
INSERT INTO husNT2005_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Por na Jesús yab in lej beltsaltsik, abal Jajáꞌ in exlál ejtalkʼitsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Yab in yéntsal ka óltsin kʼal ni jun xitaꞌ xantʼéy in chalpayal an atiklábtsik, pos Jajáꞌ in choꞌób alwaꞌ xantʼéy in chalpayal tin itsích jun i inik. ");
INSERT INTO husNT2005_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Táꞌ ti kʼwajat jun i Fariseo xin bij ta Nikodemo, jun i ultaláb inik ban judíotsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Jechéꞌ na Nikodemo kʼale jun i akal kin álnaꞌ na Jesús ani in utsaꞌ enchéꞌ: ―Okʼtsix, i choꞌób abal a Dios ti abámal ta okʼtsix, pos ni jun xitaꞌ yab neꞌech kin ejto kin xalkʼaꞌ nin awiltal kʼal i labidh exóltsik jelt xan ta tʼajál, max na Dios yab kʼwajat kʼal jajáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Utsan tám enchéꞌ kʼal na Jesús: ―Tsubax tu utsál, ke xitaꞌ yab ka waꞌchin ti chakam ti ít, yab neꞌech kin ejto ka kʼwajay takʼnél kʼal na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Konoxin tám enchéꞌ na Nikodemo: ―Por ¿jan ti neꞌech kin ejto jun i pulek inik ka waꞌchin ti chakam ti ít? ¿Awxeꞌ neꞌech kin ejto ka ochich juní bin nánaꞌ abal ka waꞌchin ti chakam ti ít? ");
INSERT INTO husNT2005_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Tókʼoyat enchéꞌ kʼal na Jesús: ―Tsubax tu utsál, ke xitaꞌ yab ka pujan kʼal i jaꞌ ani kʼal an Tʼokat Ejattaláb, yab neꞌech kin ejto ka kʼwajay takʼnél kʼal na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Xu waꞌchinal techéꞌ ti kʼayꞌlá, in koꞌol in tʼuꞌúl jelti nin tátaꞌ ani nin nánaꞌ; por xu waꞌchinal kʼal an Tʼokat Ejattaláb, in kóꞌyalich an Tʼokat Ejattaláb. ");
INSERT INTO husNT2005_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Yab ki laban abal tu utsál: “Ejtaltsik koꞌol ka waꞌchin ti chakam ti ít.” ");
INSERT INTO husNT2005_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","An ikʼ u wawꞌnal xon ti kin leꞌnaꞌ; a achʼál u bososól, por yab a choꞌób xon ti tál nibal a choꞌób xon ti neꞌech. Anchanꞌ jeye ejtal xu waꞌchinaltsik kʼal an Tʼokat Ejattaláb. ");
INSERT INTO husNT2005_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Konyat tám juní enchéꞌ kʼal na Nikodemo: ―¿Jantich tám tu tʼájnal jechéꞌ? ");
INSERT INTO husNT2005_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Tókʼoyat enchéꞌ kʼal na Jesús: ―¿Tatáꞌ, xi jaꞌich jun in okʼtsíxal an israelitatsik, yab a choꞌób jechéꞌ? ");
INSERT INTO husNT2005_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Tsubax tu utsál, ke wawáꞌ tokot i tʼilál xowaꞌ i choꞌóbich ani tokot i ólnál xowaꞌ i chuꞌúmal; por tatáꞌtsik, yab a belál xowaꞌ tu utsáltsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Max yab tin beltsaltsik tam kin kʼwajay tu tʼiltsitsik xowaꞌ waꞌach techéꞌ ti kʼayꞌlá, ¿jan ti neꞌech ti kin beltsitsik max kin kʼwajay tu tʼiltsitsik xowaꞌ waꞌach túꞌ walkʼiꞌ? ");
INSERT INTO husNT2005_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","ʼNi jun xitaꞌ yab kʼadhinek walkʼiꞌ, tokot xi paꞌinek túꞌ walkʼiꞌ, jaꞌich Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik, xin kʼwajíl túꞌ walkʼiꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ani anchanꞌ xan ti na Moisés tin tʼekʼbaꞌ an chan túꞌ ban chabál xon ti yab kʼwajtsidh, anchanꞌ neye ti neꞌech kin tʼekʼbá Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik, ");
INSERT INTO husNT2005_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","abal ejtal xitaꞌ ti kin belaꞌ, yab ka kʼaletsik ban kʼibeltaláb, tokot kin kóꞌoytsik an xeꞌchintaláb xi yab in koꞌol in okʼontal. ");
INSERT INTO husNT2005_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","ʼNa Dios in kʼanidhaꞌ tʼajat xi kʼwajattsik ban kʼayꞌlá. Jaxtám tin abaꞌ nin junkax Chakámil ka tsích techéꞌ ti kʼayꞌlá, abal ejtal xitaꞌ kʼál ti ka belan, yab ka kʼaletsik ban kʼibeltaláb, tokot kin kóꞌoytsik an xeꞌchintaláb xi yab in koꞌol in okʼontal. ");
INSERT INTO husNT2005_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Na Dios yab in abámal nin Chakámil abal ti walbix, in abámal abal ti lóꞌol. ");
INSERT INTO husNT2005_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","ʼXitaꞌ kin belaꞌ nin Chakámil na Dios, yab neꞌech ka walbiyat, por xitaꞌ yab kin belaꞌ, walbidhich ti kʼwajat abal yab in belaꞌ nin junkax Chakámil na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Xitaꞌ yab in belaꞌ, walbidhich ti kʼwajat, abal tam ti tsích an tajaxtaláb ban kʼayꞌlá, in kulbetnaꞌtsik más an jikʼwaxtaláb ké an tajaxtaláb, kom tokot in tʼajáltsik xowaꞌ yab alwaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ejtal xin tʼajáltsik xowaꞌ yab alwaꞌ, in pojkáltsik an tajaxtaláb ani yab u uteltsik ban tajaxtaláb abal yab ka xalkʼan an walastaláb xin tʼajáltsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Por xi kʼwajattsik xan tin ulal an tsubaxtaláb, u uteltsik jaꞌ ban tajaxtaláb abal ka xalkʼan ke xowaꞌ in tʼajáltsik, jaꞌich xowaꞌ in léꞌ na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Tam ti watʼéch ejtal jechéꞌ, na Jesús kʼale kʼal nin exóbaliltsik ban chabál xi Judea ani kʼwajaytsik wéꞌ owat tajaꞌ ti pújal. ");
INSERT INTO husNT2005_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ani na Juan kʼwajat jeye ti pújal ba jun i kubtaláb xin bij Enón, kʼunat Salim, kom tajaꞌ waꞌach tʼajat i jaꞌ. U ulel tajaꞌ an atiklábtsik ani u pujyáb. ");
INSERT INTO husNT2005_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Jechéꞌ támun tam ti yabél balidh na Juan ban wikʼaxteꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Taltsik nin exóbaliltsik na Juan in tuju tám ti káwlíx kʼal an judíotsik kʼal tin kwenta an tʼokeltaláb. ");
INSERT INTO husNT2005_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Kʼaletsik tám kin utsaꞌ enchéꞌ na Juan: ―Okʼtsix, xi taꞌ ti kʼwajat kʼal tatáꞌ túꞌ jun pakʼeꞌ waljaꞌ Jordán, xi tatáꞌ a tʼilámal, u pújal jeye xoꞌ ani kʼal ejtaltsik ti exom ti wéwnáb. ");
INSERT INTO husNT2005_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Utsantsik tám enchéꞌ kʼal na Juan: ―Ni jun xitaꞌ yab neꞌech kin ejto kin kóꞌoy xataꞌ max yab ka pidhan kʼal na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Tatáꞌtsik a achʼámal tam tu ulu tsubax ke yab nanáꞌ nin Kristo, nanáꞌ jaꞌich jun i abatwále xin abnék okʼox ké Jajáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ba jun i tomkixtaláb, xitaꞌ kʼál tu dhabaláb an tomkinél tsidhan, jaꞌich kʼal an tomkinél inik; ani nin jaꞌúb an tomkinél inik, xi kʼwajat junax ani in achʼál xowaꞌ in ulal, u kulbél jeye tʼajat kʼal xowaꞌ in achʼál in tʼilál an tomkinél inik. Anchanꞌ jeye, xoꞌ in kulbél neye tʼajat. ");
INSERT INTO husNT2005_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Jajáꞌ koꞌol kin bajaw ka kʼwajay más ultaláb ani nanáꞌ koꞌol kin kʼwajay más tayíl. ");
INSERT INTO husNT2005_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","’Xi tʼekʼat ti tál, más Jaꞌ púlek ké ejtal wawáꞌ. Xi kʼwajat chabál, chabálkʼi ti kʼwajat ani tokot in tʼilál xowaꞌ waꞌach chabál. Por xi tál walkʼiꞌ, más Jaꞌ púlek ké ejtal wawáꞌ ");
INSERT INTO husNT2005_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","ani in tʼilál xowaꞌ in chuꞌúmal ani in achʼámal; por yab xitaꞌ kʼál tu beltsinal xowaꞌ in ulal. ");
INSERT INTO husNT2005_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Por max jun xitaꞌ kin belaꞌ, in ulalich tám ke na Dios tsubax xowaꞌ in ulal; ");
INSERT INTO husNT2005_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","abal xitaꞌ abnék kʼal a Dios, in káwintal a Dios in tʼilál, pos na Dios yán tʼajat tin pidhnál nin Tʼokat Ejattal. ");
INSERT INTO husNT2005_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","An Tátaꞌláb in kʼanidhál nin Chakámil ani in pidhámalich ejtal xowaꞌ waꞌach techéꞌ ti chabál ani xowaꞌ waꞌach walkʼiꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Xitaꞌ kin belaꞌ nin Chakámil na Dios, in koꞌolich an xeꞌchintaláb xi yab in koꞌol in okʼontal; por xitaꞌ yab in léꞌ kin belaꞌ nin Chakámil na Dios, yab neꞌech kin ejto kin kóꞌoy jachanꞌ an xeꞌchintaláb, tokot neꞌech kin bachʼu an kʼakʼadh yajtsiktaláb xi neꞌech ka pidhan kʼal na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","An fariseotsik in choꞌóbnaꞌ abal na Jesús u pújal más ké na Juan ani kʼal yán más xitaꞌ kʼál tu wéwnáb; ");
INSERT INTO husNT2005_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","maske yab kʼejle Jajáꞌ na Jesús nu pújal, u pújal nin exóbaliltsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Tam ti na Jesús in choꞌóbnaꞌ jechéꞌ, kale tám Judea abal ka witsiy Galilea. ");
INSERT INTO husNT2005_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","An bél xin yakʼwámal abal ka witsiy Galilea, koꞌol ka watʼey ban chabál xi Samaria, ");
INSERT INTO husNT2005_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","jaxtám ti ulich ba jun i bitsow xin bij Sikar xu takʼnal Samaria. Jechéꞌ an bitsow, kʼwajat kʼunat ban chabál xi na Jakob in pidhámal nin chakámil xin bij José. ");
INSERT INTO husNT2005_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Tajaꞌ ti kʼwajat an mom xu bijyáb tin momil na Jakob. Kom na Jesús u chekelich ti tál an ti belal, buxkan bin wál an mom. Tam ti jachanꞌ, wéꞌich xónaꞌ chʼejel kʼítsá. ");
INSERT INTO husNT2005_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","An exóbaltsik kʼalnek ban bitsow abal kin chʼaꞌay xantʼéy kin kʼapu. Támkʼi jachanꞌ, ulich ban mom jun i mímláb xu kʼwajíl ba jachanꞌ an chabál xi Samaria abal kin jotʼiy i jaꞌ ani utsan enchéꞌ kʼal na Jesús: ―Ti kin pidhaꞌ neye an ti jaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Tókʼoyat tám enchéꞌ kʼal an mímláb: ―¿Jantʼókʼi Tatáꞌ, xa kidhtal an judíotsik, tin kontsal ti jaꞌ maske a choꞌób alwaꞌ ke nanáꞌ in kʼwajíl ban chabál xi Samaria? (Utsan anchanꞌ, kom an judíotsik u átʼáx kʼal xu kʼwajíltsik Samaria.) ");
INSERT INTO husNT2005_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Tókʼoyat tám enchéꞌ kʼal na Jesús: ―Max a exlálak an chʼejwalixtaláb xin pidhnál na Dios ani xitaꞌ xi exom ti kontsal an ti jaꞌ, u choꞌób alwaꞌ abal neꞌech ti kin kontsi an ti jaꞌ ani Nanáꞌ neꞌech tu pidhaꞌ ti jaꞌ abal a ejattal. ");
INSERT INTO husNT2005_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Utsan tám enchéꞌ kʼal an mímláb: ―Payꞌlomláb, nibal elaꞌ a koꞌol xantʼokʼál ka jotʼiy an jaꞌ ani an mom owtsik. ¿Jónꞌ ti neꞌech ka elaꞌ an jaꞌ abal nu ejattal xi kʼwajat a ulal ke neꞌech ti kin pidhaꞌ? ");
INSERT INTO husNT2005_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ni wejeꞌ pakélil Jakob tu jiltsámal jechéꞌ an ti mom, xon ti jajáꞌ in jotʼyámal an jaꞌ abal kin uchʼaꞌ. Tajaꞌ jeye tin jotʼyámal an jaꞌ nin chakámiltsik ani tajaꞌ tin uchʼandhámal nin koꞌnéliltsik. ¿Awxeꞌ Tatáꞌ más i púlek ké jajáꞌ? ");
INSERT INTO husNT2005_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Tókʼoyat enchéꞌ kʼal na Jesús: ―Ejtal xin uchʼáltsik jechéꞌ an jaꞌ, neꞌech juní ka tsikey; ");
INSERT INTO husNT2005_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","por xitaꞌ kin uchʼaꞌ an jaꞌ xi Nanáꞌ u pidhnál, yab jaykʼi neꞌech ka tsikey. Pos an jaꞌ xi Nanáꞌ neꞌech ku pidhaꞌ, neꞌech ka kʼwajay alkʼidh ba jajáꞌ jelti jun in kalemtal i jaꞌ abal ka pidhan kʼál ti xeꞌchintaláb xi yab in koꞌol in okʼontal. ");
INSERT INTO husNT2005_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Utsan tám enchéꞌ kʼal an mímláb: ―Payꞌlomláb, ti kin pidhaꞌ neye jachanꞌ an ti jaꞌ abal yab más jaykʼi kin tsikey, nibal kin witsiy más ku jotʼiy i jaꞌ ba jechéꞌ an mom. ");
INSERT INTO husNT2005_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Utsan enchéꞌ kʼal na Jesús: ―Ki kʼale ka kaniy na tomkíl ani ki tsích tám juní techéꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Tókʼoyat enchéꞌ na Jesús kʼal an mímláb: ―Yab u koꞌol u tomkíl. Utsan tam enchéꞌ kʼal na Jesús: ―Tsubax kʼejle ta ulal ke yab a koꞌol a tomkíl; ");
INSERT INTO husNT2005_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","pos a beletnámalich bóꞌ i inik ani xi xoꞌ i kʼwajat a belkóm, yab a tomkíl. Tsubax tʼajat xowaꞌ a ulu. ");
INSERT INTO husNT2005_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Tam tin achʼaꞌ jechéꞌ an mímláb, in ulu enchéꞌ: ―Payꞌlomláb, nanáꞌ u achʼál ke Tatáꞌ jaꞌich jun i tʼiltsix. ");
INSERT INTO husNT2005_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ni wejeꞌ pakéliltsik xi techéꞌ jeye ti kʼwajinek Samaria in kʼakʼnámaltsik na Dios ba jechéꞌ an chʼén, por tatáꞌtsik an judíotsik a ulal ke Jerusalén ti yejat ki kʼakʼnaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Tókʼoyat enchéꞌ kʼal na Jesús: ―Mímláb, ti kin beltsi ke neꞌech kin bajaw an kʼij tam neꞌech ka kʼakʼnaꞌtsik an Tátaꞌláb ani yab neꞌech ka yéntsi ki tsíchtsik ba jechéꞌ an chʼén o ki kʼaletsik Jerusalén. ");
INSERT INTO husNT2005_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Tatáꞌtsik xi kʼwajíl ban chabál xi Samaria, yab a choꞌób xantʼéy a kʼakʼnáltsik; por wawáꞌ i choꞌób waꞌ xantʼéy i kʼakʼnál; pos an loꞌeltaláb tál ban judíotsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Por xoꞌ in bajúch an ora ani jaꞌich xoꞌich, tam xi tsubax lejtal tin kʼakʼnál an Tátaꞌláb neꞌech kin kʼakʼnaꞌ kʼal in ejattalkʼi ani kʼal i tsubaxtaláb. Pos an Tátaꞌláb in léꞌ kin chuꞌu ke anchanꞌ kin tʼajaꞌtsik xi kʼál tu kʼakʼnáb. ");
INSERT INTO husNT2005_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Na Dios i Ejattaláb ani xitaꞌ kʼál ti ka kʼakʼná, yejat kin kʼakʼnaꞌ kʼal in ejattalkʼi ani kʼal i tsubaxtaláb. ");
INSERT INTO husNT2005_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Utsan enchéꞌ kʼal an mímláb: ―Nanáꞌ u choꞌób abal neꞌech ka tsích an Mesías, xi jaꞌich an Kristo xi bijidh neꞌech ka tsích. Ani tam Jajáꞌ ka ulich, neꞌech ti ku wiltsi ejtal jechéꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Utsan enchéꞌ kʼal na Jesús: ―Jachanꞌ xa bijiy, jaꞌich Nanáꞌich, xi xoꞌ kʼwajat ti káw kʼal tatáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Támkʼi jachanꞌ, ulich nin exóbaliltsik ani labantsik tʼajat abal in chuꞌu ti tʼilolól na Jesús kʼal jun i mímláb. Por ni jun xitaꞌ yab in leꞌnaꞌ kin konoy xantʼéy in konyal o xantʼéy in tʼilál kʼal an mímláb. ");
INSERT INTO husNT2005_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","An mímláb in jilónaꞌ tám an mul ani kʼale ban bitsow xon ti kʼwajay kin tʼiltsi enchéꞌ an atiklábtsik: ");
INSERT INTO husNT2005_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―Jalaꞌ ka chuꞌutsik jun i inik xi tin utsámal ejtal xantʼéy u tʼajámal. ¿Awxeꞌ yab jaꞌchich an Kristo? ");
INSERT INTO husNT2005_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Kaletsik tám ban bitsow ani kʼaletsik xon ti kʼwajat na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Lejat an exóbaltsik kʼwajat in pakabédhál na Jesús enchéꞌ: ―Okʼtsix, kʼapulich teye. ");
INSERT INTO husNT2005_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Por utsantsik enchéꞌ kʼal na Jesús: ―Nanáꞌ u koꞌol jun xataꞌ xantʼéy neꞌech ku kʼapu, xi tatáꞌtsik yab a exlál. ");
INSERT INTO husNT2005_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Tujey tám an exóbaltsik ti kónóx jajáꞌkʼitsik enchéꞌ: ―¿Awxeꞌ tsiꞌdhantsidh ti kʼapnél kʼal jun xitaꞌ? ");
INSERT INTO husNT2005_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Por utsantsik enchéꞌ kʼal na Jesús: ―Nu kʼapnélil, jaꞌich ku tʼajaꞌ xowaꞌ in léꞌ xi tin abámal ani ku okʼontsi an tin tʼojlábil. ");
INSERT INTO husNT2005_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Tatáꞌtsik a ulal abal bél u kʼibel chéꞌ a íchʼ abal ka junkuntsat tin walíl a tʼayabláb, por Nanáꞌ tu utsáltsik abal nin walíl an tʼayabláb yejnekich ani alwaꞌich ti kʼwajat abal ka junkuwat. ");
INSERT INTO husNT2005_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Xu tʼojnal abal kin junkuntsi tin walíl an tʼayabláb, in bachʼwal nin jalbíl. Ani an walíláb xin junkuwal, jaꞌich xi yab jaykʼi neꞌech ka kʼibey; abal xu óm ani xin junkuntsal tin walíl an tʼayabláb, ka kulbétsik junax. ");
INSERT INTO husNT2005_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Tsubax xan tin ulal enchéꞌ jun i tʼilab: “Kʼeꞌet xu óm ani kʼeꞌet xin junkuntsal tin walíl an tʼayabláb.” ");
INSERT INTO husNT2005_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nanáꞌ tu abámaltsik ka junkuntsi tin walíl an tʼayabláb xi yab tatáꞌtsik a tʼayámal; jaxtám tu utsáltsik ke kʼeꞌet xi tʼójnék ani tatáꞌtsik neꞌech ki labey kʼal an tʼojláb xi jajáꞌtsik in tʼajámal. ");
INSERT INTO husNT2005_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Yán i atiklábtsik xu kʼwajíl ba jachanꞌ an bitsow xu takʼnal Samaria, in belaꞌtsik na Jesús kʼal xowaꞌkʼi in achʼaꞌtsik utsan kʼal an mímláb, tam ti utsantsik enchéꞌ: “Tin utsámal ejtal xantʼéy u tʼajámal.” ");
INSERT INTO husNT2005_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Jaxtám, tam ti ulich an atiklábtsik xu kʼwajíl ban chabál xi Samaria, pakabédhá na Jesús abal ka jilkʼon kʼal jajáꞌtsik. Na Jesús jilkʼon kʼal jajáꞌtsik cháb a kʼítsá, ");
INSERT INTO husNT2005_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","ani kʼal yán más ti belan, tam tin achʼaꞌtsik xantʼéy in ulal na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Utsan tám enchéꞌ an mímláb kʼal an atiklábtsik: ―Xoꞌ i belálich, yab tokotkʼi kʼal xowaꞌ tatáꞌ tu utsámal, i belál abal wawáꞌ weye i achʼámalich xantʼéy in tʼilál ani i choꞌóbich abal tsubax lejtal Jajáꞌich nu Kristo nin Loꞌóxil xi ejtal techéꞌ ti kʼayꞌlá. ");
INSERT INTO husNT2005_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Cháb a kʼítsá más tayíl, na Jesús kale Samaria ani in óntsi an bél abal ban chabál xi Galilea. ");
INSERT INTO husNT2005_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Pos jelt xan ti na Jesús in ulu, ni jun i tʼiltsix u kʼakʼnáb bin chabálil. ");
INSERT INTO husNT2005_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Tam ti na Jesús ulich Galilea, bachʼwat alwaꞌ kʼal xi tajaꞌtsik, abal xu kʼwajíltsik tajaꞌ, kʼalnektsik jeye Jerusalén kin ajíbnaꞌtsik an paskwa ani in chuꞌúmaltsik ejtal xowaꞌ in tʼajaꞌ ba jachanꞌ an ajib. ");
INSERT INTO husNT2005_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Na Jesús witsiy Kaná, an bitsow xu takʼnal ban chabál xi Galilea xon tin wenkʼómal an jaꞌ ti yajtsik uxnél. Tajaꞌ, taꞌ ti kʼwajat jun in tʼojnálil an pulek awiltaláb. Jechéꞌ an tʼójontsix, in koꞌol jun in chakámil u yaꞌul ban bitsow xi Kapernaúm. ");
INSERT INTO husNT2005_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Tam ti jachanꞌ an tʼójontsix in achʼaꞌ ke na Jesús ulich Galilea, kʼale kin chuꞌu ani in pakabédhaꞌ abal ka kʼale bin kʼimáꞌ ani ka jeldhantsat tin chakámil xi taꞌ ti kʼwajat tolowich tʼajat. ");
INSERT INTO husNT2005_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Utsan tám enchéꞌ kʼal Jesús: ―Max yab ka chuꞌutsik i exól ani i labidh labandhaxtalábtsik, yab neꞌech ti kin belaꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Por utsan enchéꞌ kʼal an tʼójontsix: ―Ajátik, ki tsích jikʼat, lejat yabél u chemel nu chakámil. ");
INSERT INTO husNT2005_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Utsan tám enchéꞌ kʼal na Jesús: ―Ki kʼaléch ta kʼimáꞌ, na chakámil yab neꞌech ka chemech. An inik in belaꞌ xowaꞌ utsan kʼal na Jesús ani kʼale. ");
INSERT INTO husNT2005_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Tam tu witsélich tin kʼimáꞌ, kale ti tamnal kʼal nin tʼojnáliltsik ani utsan enchéꞌ: ―Na chakámil yab chemech. ");
INSERT INTO husNT2005_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ani in konoy tám nin tʼojnáliltsik xáy i ora ti tujey ti elábmél nin chakámil ani utsan enchéꞌ: ―Ti weꞌél, jún xónaꞌ i wákal ti wékʼon an kʼakʼlách. ");
INSERT INTO husNT2005_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","In chalpay tám an tátaꞌláb ke jachanꞌ i ora, tám ti usnék enchéꞌ kʼal na Jesús: “Na chakámil yab neꞌech ka chemech.” Jajáꞌ ani ejtal nin kidhtaltsik in belaꞌ na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Jechéꞌ jaꞌich in chabtal an labidh labandhaxtaláb xin tʼajaꞌ na Jesús abal ti exól, tam ti witsiy Judea ani ulich Galilea. ");
INSERT INTO husNT2005_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Tam ti watʼenekich ejtal jechéꞌ, na Jesús witsiy Jerusalén xon ti an judíotsik kʼwajat in tʼajál jun i ajib. ");
INSERT INTO husNT2005_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Tajaꞌ Jerusalén, kʼunat bin wiꞌlébil an bitsow, waꞌach jun i chʼakat jaꞌ xi ti káwintaláb ebreo u bijyáb Betesda. Jechéꞌ an chʼakat jaꞌ, kʼwajat ban wiꞌleb xu bijyáb Obejatsik ani in koꞌol bóꞌ i chalam. ");
INSERT INTO husNT2005_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Tajaꞌ ban chalam, taꞌ ti kwachatsik yán i yaꞌultsik, xu jokʼoltsik, xu kʼwechʼeꞌtsik ani xi yabtsik in ejtowal ka yoyon. Jechéꞌ kʼwajattsik in aytsím ka lanyat an jaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Abal owdhaꞌkʼi i kʼij u paꞌíl jun i tʼokat abatwále ani in lanyal an jaꞌ. Xitaꞌ ka ochich okʼox tam ka lanyat an jaꞌ, u jelél kʼal xowaꞌkichkʼi an yawꞌlách xin koꞌol. ");
INSERT INTO husNT2005_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Táꞌ jeye ti kʼwajat tajaꞌ jun i inik xin koꞌolich jun inik lajuwaxik i tamub ti yaꞌul. ");
INSERT INTO husNT2005_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Tam ti na Jesús in chuꞌu kwachál jechéꞌ an inik ani in choꞌóbnaꞌ abal nakatich tʼajat i kʼij ti kʼwajíl anchanꞌ, in konoy enchéꞌ: ―¿A léꞌxeꞌ ki jeley? ");
INSERT INTO husNT2005_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Tókʼoyat enchéꞌ kʼal an yaꞌul: ―Ajátik, yab u koꞌol xitaꞌ ti kin ódhaꞌ ban chʼakat jaꞌ tam ka lanyat. Echʼekʼi tam u léꞌ neye kin ochich, okʼox u ochel kʼeꞌet. ");
INSERT INTO husNT2005_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Utsan enchéꞌ kʼal na Jesús: ―Ki chʼakay, ka dhayaꞌ na chaytéꞌil ani ki beley. ");
INSERT INTO husNT2005_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Támkʼi jachanꞌ ti jilkʼon jelnek an inik, in dhayaꞌ nin chaytéꞌil ani beley. Por kom tam ti jachanꞌ a kʼítsá jaꞌich in kʼítsájil an koyóxnich, ");
INSERT INTO husNT2005_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","utsan enchéꞌ kʼal an judíotsik jachanꞌ an inik xi jeldhá: ―Xoꞌ in kʼítsájil i koyóxnich, yab alwaꞌ ka kitnaꞌ na chaytéꞌil. ");
INSERT INTO husNT2005_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","An inik tókʼon enchéꞌ: ―Xi tin jeldhaꞌ, tin utsaꞌ enchéꞌ: “Ka dhayaꞌ na chaytéꞌil ani ki beley.” ");
INSERT INTO husNT2005_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Konyat tám enchéꞌ: ―¿Jitam jáꞌ pé jeye xi ti utsaꞌ: “Ka dhayaꞌ na chaytéꞌil ani ki beley”? ");
INSERT INTO husNT2005_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Por an inik yab in choꞌób xitam jáꞌ xi kʼál ti jeldhats, kom na Jesús pitʼkʼonékich bin yaníl an atiklábtsik xi tajaꞌ ti kʼwajat. ");
INSERT INTO husNT2005_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Tayíl elan jachanꞌ an inik kʼal na Jesús ban pulek atá xon tu kʼakʼnáb na Dios ani utsan enchéꞌ: ―Ka achʼaꞌ, xoꞌ i jeléch, yabich más ka walaꞌ abal yab ka tamu jun xataꞌ más yajtsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Kʼale tám an inik ani in óltsi an judíotsik ke kʼal na Jesús ti jeldhats. ");
INSERT INTO husNT2005_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Jaxtám na Jesús tu atʼnal kʼal an judíotsik ani u leꞌnáb ka chemdhá, abal na Jesús in tʼajál jechéꞌ tin kʼítsájil an koyóxnich. ");
INSERT INTO husNT2005_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Por utsantsik enchéꞌ kʼal na Jesús: ―Nu Tátaꞌ echʼekʼi u tʼojnal ani jaxtám Nanáꞌ tin tʼojnal neye. ");
INSERT INTO husNT2005_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Jaxtám an judíotsik másich tin leꞌnál kin chemdhaꞌ na Jesús, abal yab tokotkʼi yab in pakwlantsal nin kʼítsájil an koyóxnich, u leꞌnáb ka chemdhá, abal in ulal ke Jajáꞌ jáykʼi jeye a Dios, kom in ulal ke na Dios jaꞌich nin Tátaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Utsantsik tám enchéꞌ kʼal na Jesús: ―Tsubax tu utsáltsik, ke nin Chakámil na Dios yab neꞌech kin ejto kin tʼajaꞌ ni jun xataꞌ kʼal Jajáꞌkʼi tin kwetém chalab; tokot in tʼajál xowaꞌ in chuꞌtal in tʼajál an Tátaꞌláb. Ejtal xowaꞌ in tʼajál an Tátaꞌláb, anílkʼi jeye tin tʼajál an Chakámláb. ");
INSERT INTO husNT2005_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Pos an Tátaꞌláb in kʼanidhál nin Chakámil ani in xalkʼantsal ejtal xowaꞌ Jajáꞌ in tʼajál; ani neꞌech kin xalkʼantsi xowaꞌ más pakdhaꞌ xi Jajáꞌ in tʼajál, xi neꞌech ti ki jilaꞌtsik i labnék. ");
INSERT INTO husNT2005_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Anchanꞌ jelt xan ti an Tátaꞌláb in ejdhál an chemélomtsik ani in pidhál ti xeꞌchintaláb, anchanꞌ jeye an Chakámláb in pidhál ti xeꞌchintaláb xitaꞌ Jajáꞌ in léꞌ kin pidhaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Pos an Tátaꞌláb yab in lújundhál ni jun xitaꞌ, nin Chakámil jaꞌich nin pidhámal ejtal an ti awiltaláb abal ti lújundhax, ");
INSERT INTO husNT2005_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","abal kʼal ejtalkʼi ti ka kʼakʼná an Chakámláb jelt xan tu kʼakʼnáb an Tátaꞌláb. Xitaꞌ yab kin kʼakʼnaꞌ an Chakámláb, yabich jeye tám u kalel in kʼakʼnál an Tátaꞌláb xi kʼál ti abnék. ");
INSERT INTO husNT2005_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","ʼTsubax tu utsáltsik: Xitaꞌ kin exbay xowaꞌ Nanáꞌ u ulal ani kin belaꞌ xitam Jáꞌ tin abámal, neꞌech kin kóꞌoy an xeꞌchintaláb xi yab in koꞌol in okʼontal; ani yabich neꞌech ka jilkʼon walbidh, pos jajáꞌ in watʼnaꞌich an chemlá ani in kóꞌóch an xeꞌchintaláb xi yab in koꞌol in okʼontal. ");
INSERT INTO husNT2005_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Tsubax tu utsáltsik, ke neꞌech kin bajaw an ora ani jaꞌich xoꞌich, tam xi kʼwajattsik jelti max chemnek kʼal tin kwenta an walastaláb neꞌech kin axtsitsik tin káwintal nin Chakámil na Dios; ani xitaꞌ kin axtsi, neꞌech kin kóꞌoy an xeꞌchintaláb xi yab in koꞌol in okʼontal. ");
INSERT INTO husNT2005_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Anchanꞌ jelt xan ti an Tátaꞌláb in koꞌol i awiltaláb abal kin pidhnaꞌ i xeꞌchintaláb xi yab in koꞌol in okʼontal, anchanꞌ jeye tin pidhámal ti awiltaláb nin Chakámil abal kin pidhnaꞌ i xeꞌchintaláb xi yab in koꞌol in okʼontal. ");
INSERT INTO husNT2005_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","In pidhámal jeye ti awiltaláb abal ti lújundhom, kom Jajáꞌich xi abadh abal ka wenkʼon jeye ti inik. ");
INSERT INTO husNT2005_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Yab ki labantsik kʼal jechéꞌ, kom neꞌech kin bajaw an ora tam ejtal an chemélomtsik neꞌech kin axtsi tin káwintal ");
INSERT INTO husNT2005_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ani neꞌech ka kale xon ti kʼwajattsik jolidh. Xitaꞌ xin tʼajámaltsik xowaꞌ alwaꞌ, neꞌech ka ejechtsik abal yabich jaykʼi ka chemechtsik; por xitaꞌ xin tʼajámaltsik xowaꞌ yab alwaꞌ, neꞌech ka ejechtsik abal ka abnájichtsik ban kʼibeltaláb. ");
INSERT INTO husNT2005_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","ʼNanáꞌ yab u ejtowal ku tʼajaꞌ xataꞌ kʼal Nanáꞌkʼi tu kwetém chalab. Nanáꞌ in lújundhax xantikʼi ti kin utsan ani in lújundhax in lujtalkʼi, pos yab exom u tʼajál xowaꞌ Nanáꞌ u léꞌ, tokot u tʼajál xowaꞌ in léꞌ an Tátaꞌláb xi tin abámal. ");
INSERT INTO husNT2005_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Max Nanáꞌkʼijak in xeꞌech u tʼilál tubáꞌ, yab tsubax xowaꞌ u ulal. ");
INSERT INTO husNT2005_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Waꞌach kʼeꞌet xi tin tʼilál ani u choꞌób alwaꞌ ke tsubax xowaꞌ in ulal. ");
INSERT INTO husNT2005_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Tatáꞌtsik a abnámal ka konyat na Juan ani tsubax xan ti jajáꞌ tókʼnék. ");
INSERT INTO husNT2005_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Nanáꞌ yab in teykómte kʼal xowaꞌ kin ulu jun i inik kʼal Nanáꞌ tu kwenta; por u ulal jechéꞌ abal tatáꞌtsik ka ejto ki loꞌey. ");
INSERT INTO husNT2005_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Xowaꞌ in ulu na Juan, in junwal jelti jun i tajbaxtaláb xi kʼwajat letʼotʼól abal ti tajbax ani tatáꞌtsik a leꞌnaꞌ ki kulbé wéꞌ i kʼij kʼal nin tajaxtalábil. ");
INSERT INTO husNT2005_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Por Nanáꞌ u koꞌol jun i óltsixtaláb más alwaꞌ ké xowaꞌ xin ulúmal na Juan. Ejtal xowaꞌ an Tátaꞌláb tin pidhámal ku tʼajaꞌ, jaꞌich nin xalkʼál abal tsubax lejtal tin abadh kʼal an Tátaꞌláb. ");
INSERT INTO husNT2005_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Aníl jeye, an Tátaꞌláb xi tin abámal, in pidhnál jeye i óltsixtaláb kʼal Nanáꞌ tu kwenta, maske tatáꞌtsik yab jaykʼi a axtsámal tin káwintal nibal jaykʼi a chuꞌúmaltsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Por tatáꞌtsik yab a beltsal nin tsubaxtalábil abal yab tin beláltsik Nanáꞌ, xin abadh kʼal an Tátaꞌláb. ");
INSERT INTO husNT2005_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Tatáꞌtsik a ajyal an Tʼokat Dhuslab kʼal yantam i kwenta, abal a léꞌtsik ka chuꞌu max ka elaꞌtsik tajaꞌ an xeꞌchintaláb xi yab in koꞌol in okʼontal; por an Tʼokat Dhuslab Nanáꞌ tin tʼilál, ");
INSERT INTO husNT2005_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","por tatáꞌtsik yab a léꞌ ki uteytsik kʼal Nanáꞌ abal ka ejto ka kóꞌoytsik jachanꞌ an xeꞌchintaláb xi yab in koꞌol in okʼontal. ");
INSERT INTO husNT2005_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","ʼNanáꞌ yab u léꞌ kin exlá ke in alwaꞌ inik kʼal an atiklábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Por Nanáꞌ tu exláltsik ke yab a kʼakʼnál a Dios. ");
INSERT INTO husNT2005_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Nanáꞌ in tsiꞌnek abal in abnék kʼal nu Tátaꞌ, por tatáꞌtsik yab tin bachʼwal; por max tál jun xitaꞌ kʼal jajáꞌkʼi tin kwetém chalab, jachanꞌ neꞌech jaꞌ ka bachʼutsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿Janti neꞌech ka ejto ki belmáchtsik, max tokot a léꞌ ki exlomná ke i alwaꞌ inik kʼal an atiklábtsik ani yab kʼal na junkax Diosil? ");
INSERT INTO husNT2005_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Yab ka chalpaytsik ke Nanáꞌ neꞌech tu ólnaꞌtsik tin tamét nu Tátaꞌ; xitaꞌ ti ólnáltsik, jaꞌich xowaꞌ in dhutsámal na Moisés, xon ta kʼwajbámaltsik na aytsixtalábil. ");
INSERT INTO husNT2005_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Abal max tsubaxak ta beláltsik xowaꞌ in dhutsámal na Moisés, neꞌech jeye tám ka belaꞌtsik xowaꞌ Nanáꞌ u ulal, pos Nanáꞌ tin tʼilál xowaꞌ in dhutsámal na Moisés. ");
INSERT INTO husNT2005_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Por max yab a beláltsik xowaꞌ in jilámal dhutsadh na Moisés, ¿jan ti neꞌech ka ejto ka belaꞌtsik xowaꞌ Nanáꞌ tu utsáltsik? ");
INSERT INTO husNT2005_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Tam ti watʼéch ejtal jechéꞌ, na Jesús kʼale jun pakʼeꞌ pujal xi kʼwajat Galilea, xi jayéchkʼi in kidhtal an pujal xi Tiberias. ");
INSERT INTO husNT2005_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Kʼal yán i atiklábtsik ti neꞌech wewkómte kom in chuꞌúmalichtsik an labidh labandhaxtaláb xin tʼajál, abal in jeldhál an yaꞌultsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Kʼadhiy tám na Jesús ba jun i chʼén ani buxkan tajaꞌ kʼal nin exóbaliltsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Tam ti jachanꞌ i kʼij, exomich ti kʼunel an paskwa, an ajib xin ajíbnál an judíotsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Tam ti na Jesús in chuꞌu abal kʼal yán i atiklábtsik ti wéwnadh, in utsaꞌ enchéꞌ na Felipe: ―¿Jónꞌ neꞌech ki chʼaꞌay i kʼapnél abal ka kʼapúch ejtal jechéꞌ an atiklábtsik? ");
INSERT INTO husNT2005_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Por na Jesús in ulu anchanꞌ abal in léꞌ kin achʼaꞌ xantʼéy kin ulu na Felipe, pos Jajáꞌ in choꞌóbich alwaꞌ xantʼéy neꞌech kin tʼajaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Tókʼoyat tám enchéꞌ kʼal na Felipe: ―Maske ki chʼaꞌay cháb boꞌ inik i denariotsik i pan, yab neꞌech ka kidhey abal kin elaꞌ bachʼutsik wetsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Utsan tám enchéꞌ kʼal jún ti éb nin exóbaliltsik xin bij Andrés, xi jaꞌich nin kidháb na Simón Pedro: ");
INSERT INTO husNT2005_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―Jéꞌ kʼwajat jun i chakam kwitól xin tsiꞌdhál bóꞌ i pan xi tʼajadh kʼal i sebada ani cháb i toꞌol; por kʼal jechéꞌ yab neꞌech ka kidhey abal ki kʼapundhaꞌ yantam i atiklábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","In ulu tám enchéꞌ na Jesús: ―Ka utsaꞌ ejtal an atiklábtsik ka buxkan. Tajaꞌ xon ti kʼwajattsik, waꞌach tʼajat i tsʼitsik chʼojól ani buxkantsik boꞌ mil iniktsik xónaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","In téynaꞌ tám na Jesús xi bóꞌ an pan, in pidhaꞌ ti jalbintsixtaláb na Dios ani in pidhaꞌich tám nin exóbaliltsik. An exóbaltsik in pidhaꞌichtsik tám ejtal xi táꞌ ti buxutsik. Anílkʼi jeye tin tʼajaꞌ kʼal an toꞌoltsik ani in pidhaꞌtsik asta xan ti jajáꞌtsik in leꞌnaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Tam ti ajwéchtsik, na Jesús in utsaꞌ enchéꞌ nin exóbaliltsik: ―Ka junkutsik an pejmatstalábtsik xi jilkʼon abal yab xataꞌ ka odhná. ");
INSERT INTO husNT2005_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","In junkutsik tám ani in tsʼutsiytsik lajucháb i tʼoknaltsik kʼal an pejmatstaláb xi jilkʼon kʼal xi bóꞌ an pan xi tʼajadh kʼal i sebada. ");
INSERT INTO husNT2005_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Tam ti an atiklábtsik in chuꞌu jechéꞌ an labidh labandhaxtaláb xin tajaꞌ na Jesús, in ulutsik enchéꞌ: ―Tsubax lejtal jechéꞌ jaꞌich an tʼiltsix xi bijidh neꞌech ka tsích techéꞌ ti kʼayꞌlá. ");
INSERT INTO husNT2005_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Por kom na Jesús in chuꞌu abal u leꞌnáb ka júná kʼal i chápláb abal ka tʼajan ti pulek takʼix, kʼale juní ban chʼén abal ka kʼwajay kwetém. ");
INSERT INTO husNT2005_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Tam ti jikʼwchinékich, nin exóbaliltsik na Jesús kʼale ban pujal, ");
INSERT INTO husNT2005_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ochichtsik ban tan ani in tujúchtsik tám kin watʼnaꞌ an pujal abal ka kʼaletsik Kapernaúm. Jikʼwchinékich alwaꞌ ani na Jesús yabél ulnek xon ti jajáꞌtsik kʼwajat. ");
INSERT INTO husNT2005_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","An jaꞌ u múlákʼ asta tʼekʼat, kom u wawꞌnal jun i chapik ikʼ. ");
INSERT INTO husNT2005_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Tam tin belámalichtsik bóꞌ o akak i kilómetro, in chuꞌutsik na Jesús ti utel ban tan, tál belal tin éb an jaꞌ ani jikʼeytsik tʼajat. ");
INSERT INTO husNT2005_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Por utsantsik enchéꞌ kʼal na Jesús: ―¡Nanáꞌ, yab ki jikʼeytsik! ");
INSERT INTO husNT2005_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Tam tin achʼaꞌtsik jechéꞌ, in utsaꞌichtsik tám ka ochich ban tan ani junwékʼi ti ulichtsik ban chabál xon tin ulúmaltsik neꞌech. ");
INSERT INTO husNT2005_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Tam ti jun tsudhelom, an atiklábtsik xi jilkʼonéktsik jun pakʼeꞌ pujal, in chuꞌu abal an exóbaltsik kʼalnekich kʼal an junkax tan xi taꞌ ti kʼwajat ani na Jesús yab kʼalnek kʼal jajáꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Por támkʼi jachanꞌ, ulich kʼeꞌet i tan xi tál ban bitsow xin bij Tiberias, tajaꞌ kʼunat xon ti kʼapúmadh an atiklábtsik tam ti an Ajátikláb in pidhnámalich i jalbintsixtaláb. ");
INSERT INTO husNT2005_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ani jaxtám, tam ti an atiklábtsik in chuꞌu ke na Jesús yabich tajaꞌ ti kʼwajat nibal nin exóbaliltsik, balin ban tan ani kʼaletsik Kapernaúm abal kin aliy. ");
INSERT INTO husNT2005_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Tam ti an atiklábtsik ulich jun pakʼeꞌ pujal, in elaꞌ na Jesús ani in konoytsik enchéꞌ: ―Okʼtsix, ¿jowkʼijich ta ulnek techéꞌ? ");
INSERT INTO husNT2005_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Tókʼoyattsik enchéꞌ kʼal na Jesús: ―Tsubax tu utsál, ke tatáꞌtsik tin ayal abal a chuꞌu tu kʼapundhaꞌtsik asta ki ajwé ani yab abal a chuꞌúmaltsik an labidh labandhaxtaláb. ");
INSERT INTO husNT2005_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Yab ki tʼójontsik abal ka átaꞌ an kʼapnél xu talél, ki tʼójontsik abal ka átaꞌ an kʼapnél xi yab u talél xi neꞌech ti ki pidhaꞌtsik an ti xeꞌchintaláb xi yab in koꞌol in okʼontal. Jechéꞌ jaꞌich an kʼapnél xu pidhnál Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik. Pos na Dios an Tátaꞌláb tin takwyámal abal ku pidhnaꞌ jechéꞌ an kʼapnél. ");
INSERT INTO husNT2005_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Konyat tám enchéꞌ kʼal an atiklábtsik: ―¿Jantʼéy yejat ki tʼajaꞌ abal ki ejto ki tʼajaꞌ xowaꞌ in léꞌ na Dios? ");
INSERT INTO husNT2005_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Tókʼoyattsik enchéꞌ kʼal na Jesús: ―Na Dios in léꞌ kin chuꞌu ke tatáꞌtsik ka belaꞌ xi Jajáꞌ in abámal. ");
INSERT INTO husNT2005_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Konyat tám juní enchéꞌ na Jesús: ―¿Jantʼom labidh labandhaxtaláb neꞌech ka ejto ti ku xalkʼantsi abal ki chuꞌu ani anchanꞌ tu belaꞌich? ¿Jantʼéy a ejtowal ka tʼajaꞌ? ");
INSERT INTO husNT2005_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ni wejeꞌ pakéliltsik in kʼapúmal ban chabál xon ti yab kʼwajtsidh an kʼapnél xi tál walkʼiꞌ, jelt xan tin ulal enchéꞌ an Tʼokat Dhuslab: “Na Dios in pidhaꞌtsik kin kʼapu an kʼapnél xi tál walkʼiꞌ.” ");
INSERT INTO husNT2005_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Tókʼoyattsik tám enchéꞌ kʼal na Jesús: ―Tsubax tu utsáltsik: Yab kʼal a Moisés ti pidhnék na wejeꞌ pakéliltsik an ti kʼapnél xi tál walkʼiꞌ, kʼal nu Tátaꞌ ti pidhnéktsik jachanꞌ an kʼapnél xi tsubax lejtal ti tál walkʼiꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Pos an kʼapnél xin pidhnál na Dios, jaꞌich xi paꞌinek walkʼiꞌ ani in pidhál an atiklábtsik ti xeꞌchintaláb xi yab in koꞌol in okʼontal. ");
INSERT INTO husNT2005_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Utsan tám enchéꞌ na Jesús kʼal an atiklábtsik: ―Ajátik, ti ku pidhaꞌ echʼekʼi jachanꞌ an ti kʼapnél. ");
INSERT INTO husNT2005_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Utsantsik enchéꞌ kʼal na Jesús: ―Nanáꞌich an kʼapnél xin pidhnál an xeꞌchintaláb xi yab in koꞌol in okʼontal. Xitaꞌ ka utey kʼal Nanáꞌ, yab jaykʼi neꞌech ka kʼaꞌay ani xitaꞌ ti kin belaꞌ, yab jaykʼi neꞌech ka tsikey. ");
INSERT INTO husNT2005_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Por anchanꞌ jelt xan tu utsámalichtsik, tatáꞌtsik yab tin belál maske tin chuꞌúmalichtsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ejtal xowaꞌ tin pidhál an Tátaꞌláb, u ulel kʼal Nanáꞌ ani xitaꞌ ka utey kʼal Nanáꞌ, yab neꞌech ku pojkaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Pos Nanáꞌ yab in paꞌinek walkʼiꞌ abal ku tʼajaꞌ xowaꞌ u léꞌ, in paꞌinek abal ku tʼajaꞌ xowaꞌ in léꞌ xi tin abámal. ");
INSERT INTO husNT2005_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Xowaꞌ in léꞌ nu Tátaꞌ xi tin abámal, jaꞌich ke yab ku kʼibdhaꞌ ni jun xitaꞌ xi Jajáꞌ tin pidhál, tokot ku ejdhaꞌ ti ít tam kin bajaw an pakwenib. ");
INSERT INTO husNT2005_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Xowaꞌ in léꞌ xi tin abámal, jaꞌich ke ejtal xitaꞌ kin chuꞌu nin Chakámil na Dios ani kin belaꞌ, kin kóꞌoytsik an xeꞌchintaláb xi yab in koꞌol in okʼontal ani Nanáꞌ neꞌech ku ejdhaꞌ ti ít tam kin bajaw an pakwenib. ");
INSERT INTO husNT2005_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Tam ti an judíotsik in achʼaꞌ jechéꞌ, tujeytsik kin kawiy na Jesús abal in ulu enchéꞌ: “Nanáꞌich nin kʼapnél xi paꞌinek walkʼiꞌ.” ");
INSERT INTO husNT2005_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ani in ulutsik enchéꞌ: ―¿Yabxeꞌ jaꞌich jechéꞌ na Jesús, nin chakámil na José? Wawáꞌ i exlantsal tin tátaꞌ ani tin nánaꞌ. ¿Jantʼókʼi pé tám tin ulal ke Jajáꞌ walkʼiꞌ ti paꞌinek? ");
INSERT INTO husNT2005_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Utsantsik tám enchéꞌ kʼal na Jesús: ―Ka jilaꞌichtsik ti kin káwnaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Yab xitaꞌ neꞌech kin ejto ka utey kʼal Nanáꞌ max yab ka utwat kʼal an Tátaꞌláb xi tin abámal ani neꞌech ku ejdhaꞌ ti ít tam kin bajaw an pakwenib. ");
INSERT INTO husNT2005_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ba nin dhutsadh úwil an tʼiltsixtsik in ulal enchéꞌ: “Na Dios neꞌech kin okʼtsi ejtalkʼitsik.” Jaxtám, ejtal xitaꞌ kin axtsi an Tátaꞌláb ani kin walkaꞌ ka okʼtsin kʼal Jajáꞌ, u utel kʼal Nanáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","ʼJechéꞌ yab in léꞌ kin ulu ke jun xitaꞌ in chuꞌúmalich an Tátaꞌláb; xitaꞌ kʼál tokot ti chuꞌudh na Dios, jaꞌich xi tajaꞌ ti tál ba na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Tsubax tu utsáltsik, xitaꞌ ti kin belaꞌ Nanáꞌ, in koꞌolich an xeꞌchintaláb xi yab in koꞌol in okʼontal. ");
INSERT INTO husNT2005_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Nanáꞌich an kʼapnél xin pidhnál an xeꞌchintaláb xi yab in koꞌol in okʼontal. ");
INSERT INTO husNT2005_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Na wejeꞌ pakéliltsik in kʼapúmal ban chabál xon ti yab kʼwajtsidh an kʼapnél xi tál walkʼiꞌ ani bélkʼi chemechtsik; ");
INSERT INTO husNT2005_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","por xitaꞌ kin kʼapu an kʼapnél xi tál walkʼiꞌ xi Nanáꞌ u tʼilál, yab jaykʼi neꞌech ka chemech. ");
INSERT INTO husNT2005_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nanáꞌich an kʼapnél xi paꞌinek walkʼiꞌ; xitaꞌ kin kʼapu jechéꞌ an kʼapnél, neꞌech ka kʼwajay ejat malilíl i kʼij. An kʼapnél xi Nanáꞌ neꞌech ku pidhaꞌ, jaꞌich nu tʼuꞌúl xi neꞌech ku pidhnaꞌ abal an atiklábtsik xi techéꞌ ti kʼayꞌlá kin ejto kin kóꞌoy an xeꞌchintaláb xi yab in koꞌol in okʼontal. ");
INSERT INTO husNT2005_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Tujey tám ti káwlíx an judíotsik jajáꞌkʼitsik ani u útsáxtsik enchéꞌ: ―¿Janti neꞌech kin ejto jechéꞌ ti ku pidhaꞌ ki kʼaptsi tin tʼuꞌúl? ");
INSERT INTO husNT2005_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Utsantsik enchéꞌ kʼal na Jesús: ―Tsubax tu utsáltsik, ke max yab ti kin kʼaptsitsik an tu tʼuꞌúl ani yab ti kin uxtsitsik an tu xichʼál, Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik, yab neꞌech ka ejto ka kóꞌoytsik an xeꞌchintaláb xi yab in koꞌol in okʼontal. ");
INSERT INTO husNT2005_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Xitaꞌ ti kin kʼaptsi an tu tʼuꞌúl ani ti kin uxtsi an tu xichʼál, neꞌech kin kóꞌoy an xeꞌchintaláb xi yab in koꞌol in okʼontal ani Nanáꞌ neꞌech ku ejdhaꞌ ti ít tam kin bajaw an pakwenib. ");
INSERT INTO husNT2005_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Pos nu tʼuꞌúl jaꞌich i lej kʼapnél ani nu xichʼál jaꞌich i lej uxnél. ");
INSERT INTO husNT2005_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Xitaꞌ ti kin kʼaptsi an tu tʼuꞌúl ani ti kin uxtsi an tu xichʼál, kʼwajatich kʼal Nanáꞌ ani Nanáꞌ kʼal jajáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Anchanꞌ jelt xan ti an Tátaꞌláb xi tin abámal kʼwajat ejat ani Nanáꞌ in kʼwajat ejat kʼal Jajáꞌ, anchanꞌ jeye, xitaꞌ tin kʼaptsi an tu tʼuꞌúl jelti max i kʼapnél, neꞌech ka kʼwajay ejat kʼal Nanáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Jechéꞌ xowaꞌ in kʼwajat u tʼilál jaꞌich an kʼapnél xi paꞌinek walkʼiꞌ. Jechéꞌ an kʼapnél yab in junwal jelti an kʼapnél xi paꞌinek walkʼiꞌ xin kʼapúmal na wejeꞌ pakéliltsik ani bélkʼi chemechtsik; xitaꞌ kin kʼapu jechéꞌ an kʼapnél xin kʼwajat u tʼilál, neꞌech ka kʼwajay ejat malilíl i kʼij. ");
INSERT INTO husNT2005_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Na Jesús in okʼtsixnaꞌ jechéꞌ ban atá xon tu tʼajnal an junkuntaláb ban bitsow xin bij Kapernaúm. ");
INSERT INTO husNT2005_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Tam tin achʼaꞌtsik jechéꞌ an okʼtsixtaláb, yán xi kʼál ti wewkómte na Jesús in ulutsik enchéꞌ: ―Jechéꞌ xowaꞌ kʼwajat in ulal tʼojláb tʼajat abal ki belaꞌ. ¿Jitaꞌ kʼál ti neꞌech ka ejtowat ka exbantsat? ");
INSERT INTO husNT2005_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Tam ti na Jesús in chuꞌu abal kʼwajattsik ti tʼilom kʼal jechéꞌ tin kwenta, in konoytsik enchéꞌ: ―¿Ti itʼixbédháltsik jechéꞌ? ");
INSERT INTO husNT2005_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Pos jantʼéy pé tám neꞌech ka támun max tin chuꞌutsik Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik, tin kʼadhíl xon tin kʼwajatwiꞌik? ");
INSERT INTO husNT2005_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","An ejattaláb jaꞌich nin pidhnál an xeꞌchintaláb; ni tʼuꞌúl yab xataꞌ ti alwaꞌ. Xowaꞌ Nanáꞌ tu tʼiltsámaltsik jaꞌich abal tin kwenta a ejattaltsik ani jaꞌich kʼál ti neꞌech ki pidhan an ti xeꞌchintaláb xi yab in koꞌol in okʼontal. ");
INSERT INTO husNT2005_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Por waꞌach taltsik na kidhtal xi yab in belál. In ulu anchanꞌ na Jesús, kom in exláltsik xitaꞌ kʼál ti yab u belnal asta ti tujenek an kʼayꞌlá ani xitaꞌ kʼál ti neꞌech ka pidhná abal ka chemdhá. ");
INSERT INTO husNT2005_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ani in ulu enchéꞌ: ―Kʼal jechéꞌ tin kwenta tu utsámaltsik ke yab xitaꞌ neꞌech kin ejto ka utey kʼal Nanáꞌ, max yab kʼal an Tátaꞌláb ti ka utwat. ");
INSERT INTO husNT2005_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Asta tam ti tám, yán xi kʼál ti wéwnadh na Jesús in jilaꞌtsik ti wéwnax ani yabich más xeꞌchintsik kʼal Jajáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Konyat tám enchéꞌ kʼal na Jesús xi lajucháb an exóbaliltsik: ―¿A léꞌxeꞌ teye ki kʼaletsik? ");
INSERT INTO husNT2005_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Por tókʼoyat enchéꞌ kʼal na Simón Pedro: ―Ajátik, ¿Ba jitaꞌ ti neꞌech ki ejto ku kʼale? Pos tokot Tatáꞌ tu okʼtsal xan ti neꞌech ki ejto ki kóꞌoy an xeꞌchintaláb xi yab in koꞌol in okʼontal. ");
INSERT INTO husNT2005_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Wawáꞌ i belámalich ani i choꞌóbnámalich ke Tatáꞌich ni Kristo, nin Chakámil na Dios xi ejat. ");
INSERT INTO husNT2005_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Tókʼoyattsik enchéꞌ kʼal na Jesús: ―¿Yabxeꞌ Nanáꞌ tu takwyámal tatáꞌtsik xi lajucháb? Por jún ti éb xi tatáꞌtsik jaꞌich in kidhtal an lej atʼax. ");
INSERT INTO husNT2005_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Tam tin ulu jechéꞌ, na Jesús kʼwajat in tʼilál na Judas Iskariote, xu chakámláb kʼal na Simón, pos na Judas jaꞌich xi neꞌech kin pidhnaꞌ na Jesús abal ka chemdhá, maske jajáꞌ jaꞌich jeye jún ti éb xi lajucháb an exóbaltsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Tam ti watʼenekich ejtal jechéꞌ, na Jesús xeꞌchin ban chabál xi Galilea kom yab in léꞌ ka xeꞌchin Judea, abal tajaꞌ u leꞌnáb ka chemdhá kʼal an judíotsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Por kom exomich ti kʼunel xowkʼi tu ajíbnáb an padheltsik, jun i ajib xin ajíbnál an judíotsik, ");
INSERT INTO husNT2005_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","utsan enchéꞌ na Jesús kʼal nin kidhábtsik: ―Yab ki kʼwajaykʼi techéꞌ, ki kʼale Judea abal an atiklábtsik xi ti wéwnál xu kʼwajíltsik tajaꞌ, kin chuꞌu jeye xantʼéy a tʼajál. ");
INSERT INTO husNT2005_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Pos max jun xitaꞌ in léꞌ ka exlomná, yab in tʼajál xataꞌ chinat. Kom Tatáꞌ a tʼajál xataꞌ jelti jechéꞌ, ka tʼajaꞌ tin tamét ejtal an atiklábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Anchanꞌ ti utsan kʼal nin kidhábtsik kom yab u belnal nibal kʼal jajáꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Utsantsik tám enchéꞌ kʼal na Jesús: ―Yabél in bajúmal xowkʼi ti neꞌech kin kʼale, por abal tatáꞌtsik, xowkʼijakichkʼi alwaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Xu kʼwajíltsik techéꞌ ti kʼayꞌlá yab neꞌech kin ejto ti ki pojkaꞌtsik, por Nanáꞌ tin pojkál, abal u xalkʼantsal ke yab alwaꞌ xowaꞌ in tʼajáltsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ki kʼaléchtsik taꞌ ban ajib, Nanáꞌ yabél in neꞌech kom yabél in bajúmal xowkʼi ti neꞌech kin kʼale. ");
INSERT INTO husNT2005_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ani tam tin utsámalichtsik jechéꞌ, Jajáꞌ jilkʼon Galilea. ");
INSERT INTO husNT2005_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Por tam ti kʼalnekich nin kidhábtsik ban ajib, na Jesús kʼale jeye, maske yab choꞌóbte kʼal ni jun xitaꞌ, jelti max chinatkʼi. ");
INSERT INTO husNT2005_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","U alyáb kʼal an judíotsik ban ajib ani in ulaltsik enchéꞌ: ―¿Jónꞌ awil ti kʼwajat jachanꞌ an inik? ");
INSERT INTO husNT2005_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Kʼal yán an atiklábtsik xi tajaꞌ ti kʼwajat u tʼilnal na Jesús. Taltsik in ulal enchéꞌ: “Jajáꞌ jaꞌich jun i alwaꞌ inik” ani taltsik in ulal enchéꞌ: “Yab i alwaꞌ inik, pos in kʼambiyal an atiklábtsik.” ");
INSERT INTO husNT2005_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Por kʼal ni jun xitaꞌ tu tʼilnal kawidh, abal u chʼejnáb an judíotsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Por tam ti chʼejélábich an ajib, na Jesús ochich ban pulek atá xon tu kʼakʼnáb na Dios ani in tuju ti okʼtsix. ");
INSERT INTO husNT2005_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","An judíotsik laban tʼajat ani in ulaltsik enchéꞌ: ―¿Janti awil tin witʼámal jechéꞌ an inik yán xataꞌ ani yab exóblomámadh? ");
INSERT INTO husNT2005_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Tókʼoyattsik enchéꞌ kʼal na Jesús: ―An okʼtsixtaláb xu pidhnál yab Nanáꞌ u dhabal, in dhabal xi tin abámal. ");
INSERT INTO husNT2005_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Max jun xitaꞌ in léꞌ kin tʼajaꞌ xowaꞌ in léꞌ na Dios, neꞌech kin exlaꞌ max nu okʼtsixtal tsubax lejtal ba Dios ti tál, o exom tin káw kʼal Nanáꞌkʼi tu kwetém chalab. ");
INSERT INTO husNT2005_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Max in káwak kʼal Nanáꞌkʼi tu kwetém chalab, u kalelich tám jelti max u ayal kin kʼakʼná kʼal an atiklábtsik; por yab u tʼajál anchanꞌ, tokot u ulal xowaꞌ tin pidhámal na Dios xi tin abámal abal Jajáꞌ kin bachʼu an kʼakʼnaxtaláb. Nanáꞌ tokot u ulal xowaꞌ tsubax ani yab in kʼambix. ");
INSERT INTO husNT2005_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","ʼ¿Yabxeꞌ tsubax ke na Moisés ti jiltsámaltsik dhutsadh an tin takʼixtal na Dios? Por ni jun xitaꞌ xi tatáꞌtsik yab in tʼajál ti kʼij. ¿Jantʼókʼi ta léꞌtsik ti kin chemdhaꞌ? ");
INSERT INTO husNT2005_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Tókʼoyat enchéꞌ kʼal an atiklábtsik: ―I ochadh kʼal i atʼax ejattaláb; ¿jitaꞌ in léꞌ ti ki chemdhaꞌ? ");
INSERT INTO husNT2005_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Utsantsik enchéꞌ kʼal na Jesús: ―Kʼal jun xataꞌ xowaꞌ u tʼajaꞌ tin kʼítsájil an koyóxnich, ejtal tatáꞌtsik i labnal. ");
INSERT INTO husNT2005_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Na Moisés ti óltsi ka tʼajaꞌtsik an exól ba na tʼuꞌúl, (yab abal jajáꞌ in tujúmal kin tʼajaꞌ, in tujúmal kin tʼajaꞌ na wejeꞌ pakéliltsik) ani jaxtám xoꞌ ta tʼajtsaltsik an ti exól bin tʼuꞌúl na chakámiltsik maske in kʼítsájil i koyóxnich. ");
INSERT INTO husNT2005_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Pos alwaꞌich, max abal yab a léꞌtsik ka chʼikat tʼajaꞌ nin takʼixtal na Dios xin jilámal dhutsadh na Moisés, a tʼajtsaltsik an ti exól bin tʼuꞌúl an chakamtsik maske in kʼítsájil i koyóxnich, ¿jantʼókʼi tin chakuntsal abal u jeldhaꞌ jun i inik tin kʼítsájil i koyóxnich? ");
INSERT INTO husNT2005_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Yab ti kin kawiy kʼal tin kwentakʼi xowaꞌ a chuꞌtaltsik u tʼajál. Tam ka tʼajaꞌtsik anchanꞌ, ka tʼajaꞌtsik in lujtalkʼi. ");
INSERT INTO husNT2005_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Taltsik xu kʼwajíltsik Jerusalén in ulutsik tám enchéꞌ: ―¿Yabxeꞌ jaꞌich jechéꞌ an inik xi xeꞌech ti alyáb abal ka chemdhá? ");
INSERT INTO husNT2005_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Pos núꞌ kʼwajat tejwaꞌ ti okʼtsix ani yab xataꞌ tu usnal kʼal ni jun xitaꞌ. ¿Awxeꞌ an awiltalábtsik in belámalich lejtal ke jechéꞌ an inik jaꞌich an Kristo? ");
INSERT INTO husNT2005_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Por wawáꞌ i choꞌób xon ti tál jechéꞌ an inik; por tam ka ulich an Kristo, yab xitaꞌ neꞌech kin choꞌóbnaꞌ xon ti neꞌech ka tsích. ");
INSERT INTO husNT2005_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Tam tin achʼaꞌ jechéꞌ na Jesús, xi kʼwajat ti okʼtsix ban pulek atá xon tu kʼakʼnáb na Dios, in ulu kawidh enchéꞌ: ―¡Tám, tin exláltsik ani a choꞌóbtsik xon tin tál! Por yab in tsiꞌnek kʼal Nanáꞌkʼi tu kwetém chalab, in tsiꞌnek abal in abnék kʼal na Dios xi kʼwajat ejat xi tatáꞌtsik yab a exlál. ");
INSERT INTO husNT2005_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Nanáꞌ u exlál kom ba Jajáꞌ tin tál ani Jajáꞌ tin abámal. ");
INSERT INTO husNT2005_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Leꞌná tám ka júná ti wikʼnél, por ni jun xitaꞌ yab utey ti yakʼwax, kom yabél in bajúmal an kʼij xowkʼi ti neꞌech ka chemdhá. ");
INSERT INTO husNT2005_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Por kʼal yán ti belan ani in ulaltsik enchéꞌ: ―Tam ka tsích an Kristo, ¿awxeꞌ neꞌech kin tʼajaꞌ más i labidh labandhaxtaláb ké jechéꞌ an inik? ");
INSERT INTO husNT2005_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","An fariseotsik in achʼaꞌ xantʼéy in tʼilál an atiklábtsik kʼal tin kwenta na Jesús. Aban tám kʼal an okʼlek páleꞌtsik ani an fariseotsik i yákʼwaltsik abal ka yakʼwan na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ani na Jesús in ulu enchéꞌ: ―Bél neꞌech kin kʼwajay wéꞌ i kʼij kʼal tatáꞌtsik ani neꞌech juní kin kʼale xon ti kʼwajat na Dios xi tin abámal. ");
INSERT INTO husNT2005_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Neꞌech ti kin aliytsik, por yab neꞌech ti kin elaꞌ, pos yab neꞌech ka ejto ki kʼaletsik xon ti Nanáꞌ neꞌech kin kʼwajay. ");
INSERT INTO husNT2005_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Tujey tám an judíotsik ti útsáx jajáꞌkʼitsik enchéꞌ: ―¿Jónꞌ awil ti neꞌech ka kʼale jechéꞌ an inik abal in ulal ke yab neꞌech ki ejto ki elaꞌ? ¿Awxeꞌ neꞌech ban judíotsik xi kʼwajat túkʼi túkʼi kʼal an griegotsik ani kin okʼtsi an griegotsik? ");
INSERT INTO husNT2005_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Jantʼéy awil in leꞌnaꞌ kin ulu abal tu utsaꞌ enchéꞌ: “Neꞌech ti kin aliytsik por yab neꞌech ti kin elaꞌ, pos yab neꞌech ka ejto ki kʼaletsik xon ti Nanáꞌ neꞌech kin kʼwajay”? ");
INSERT INTO husNT2005_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Tin okʼontalich an ajib xi jaꞌich na kʼítsá xi más uluts, chʼakay na Jesús ani in ulu kawidh enchéꞌ: ―Max jun xitaꞌ u tsikél, ka utey kʼal Nanáꞌ ani kin uchʼaꞌ an jaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Pos jelt xan tin ulal an Tʼokat Dhuslab, tin ejattal xitaꞌ tin belál Nanáꞌ, neꞌech ka kale jelti i waljaꞌtsik xin pidhnál i xeꞌchintaláb xi yab in koꞌol in okʼontal. ");
INSERT INTO husNT2005_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Kʼal jechéꞌ, na Jesús in leꞌnaꞌ kin ulu ke xitaꞌ kʼál ti ka belan, neꞌech kin bachʼutsik an Tʼokat Ejattaláb. Abal tam ti jachanꞌ, yabél ulnek an Tʼokat Ejattaláb, pos na Jesús yabél xalkʼantsidh an tin labidh tʼokát. ");
INSERT INTO husNT2005_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Taltsik an atiklábtsik xi tajaꞌ ti kʼwajat, tam tin achʼaꞌ jechéꞌ, in ulutsik enchéꞌ: ―Tsubax lejtal, jechéꞌ an inik jaꞌich an tʼiltsix xi bijidh neꞌech ka tsích. ");
INSERT INTO husNT2005_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Xi kʼeꞌettsik in ulal enchéꞌ: ―Jechéꞌ jaꞌich an Kristo. Por taltsik in ulal enchéꞌ: ―¿Janti neꞌech ki ejto ki ulu ke Jajáꞌ jaꞌchich an Kristo ani i choꞌób alwaꞌ ke Galilea u kʼwajíl? ");
INSERT INTO husNT2005_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Pos an Tʼokat Dhuslab in ulal ke an Kristo koꞌol ka tsích bin kidhtaltsik an pulek takʼix Dabid ani Belén ti neꞌech ka waꞌchin, ban kwentsal xon ti kʼwajinek na Dabid. ");
INSERT INTO husNT2005_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Jaꞌich kʼal jechéꞌ ti yab jununúl nin chalab an atiklábtsik kʼal tin kwenta na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Taltsik in léꞌwiꞌik kin yakʼwaꞌ, por ni jun xitaꞌ yab in tʼajaꞌ anchanꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Witsiy an yákʼwaltsik xon ti kʼwajat an fariseotsik ani an okʼlek páleꞌtsik ani konyat enchéꞌ: ―¿Jantʼókʼi ti yabtsik a tsiꞌdhaꞌ? ");
INSERT INTO husNT2005_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ani an yákʼwaltsik tókʼon enchéꞌ: ―¡Yab jaykʼi i achʼámal xitaꞌ ti káw jelt xan tu káw jachanꞌ an inik! ");
INSERT INTO husNT2005_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Utsantsik tám enchéꞌ kʼal an fariseotsik: ―¿A walkámichtsikxeꞌ teye ki kʼambiyat? ");
INSERT INTO husNT2005_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Awxeꞌ belnékich kʼal jún ti éb ni okʼlékiltsik o kʼal an fariseotsik? ");
INSERT INTO husNT2005_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Por jechéꞌ an atiklábtsik xi yab in exlál an takʼixtaláb, bijtsidhichtsik abal neꞌech ban kʼibeltaláb. ");
INSERT INTO husNT2005_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Utsantsik tám enchéꞌ kʼal na Nikodemo, xi jaꞌich jún ti éb xi jajáꞌtsik in kidhtal xi kʼalnek kin álnaꞌ jun i akal na Jesús: ");
INSERT INTO husNT2005_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―An takʼixtaláb xi wawáꞌ i koꞌol, in ulal ke yab in tomnál ki walbiy jun i inik max yab ki axtsi okʼox ani ki choꞌóbnaꞌ xantʼéy in tʼajámal. ");
INSERT INTO husNT2005_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Tókʼoyat tám enchéꞌ na Nikodemo: ―¿I galileoxeꞌ teye? Ka ajay an Tʼokat Dhuslab ani neꞌech ka chuꞌu ke ni jun i tʼiltsix yab waꞌchinék jaykʼi Galilea. ");
INSERT INTO husNT2005_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Kʼaléchtsik tám kʼejtsik kʼejtsik tin kʼimáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Por na Jesús kʼale ban chʼén Olibos. ");
INSERT INTO husNT2005_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Tam ti jun tsudhelom, witsiy dhajawe ban pulek atá xon tu kʼakʼnáb na Dios. Utukná na Jesús kʼal ejtal an atiklábtsik, buxkan ani tujey ti okʼtsix. ");
INSERT INTO husNT2005_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Utuntsat tám kʼal an okʼtsixtsik xin wilál nin takʼixtal na Dios xin jilám dhutsadh na Moisés ani kʼal an fariseotsik jun i mímláb xi elnék chinat junax kʼal jun i inik xi yab in tomkíl. Kʼwajbá junax chʼejel xon ti kʼwajat an atiklábtsik ");
INSERT INTO husNT2005_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","ani utsan enchéꞌ na Jesús: ―Okʼtsix, jechéꞌ an mímláb elnék chinat junax kʼal jun i inik xi yab in tomkíl. ");
INSERT INTO husNT2005_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Nin takʼixtal na Dios xin jilám dhutsadh na Moisés in ulal abal jelti jechéꞌ an mímlábtsik yejat ka chemdhá tʼujbadh. ¿Tatáꞌ, jantʼéy a ulal? ");
INSERT INTO husNT2005_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","In ulutsik anchanꞌ, abal in léꞌ kin achʼaꞌtsik xantʼéy kin ulu na Jesús ani max yab ka tókʼon alwaꞌ, neꞌech tám ka ejtowat ka walbiyat. Kutpan tám na Jesús ani in tuju ti dhutsum ban chabál kʼal in tsʼútsbixtal. ");
INSERT INTO husNT2005_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Por kom in achʼál abal in óntsal ti konyáb, lujkun tám ani in utsaꞌtsik enchéꞌ: ―Max jun xitaꞌ xi tatáꞌtsik yab walbidh, awil kin tuju kin tʼujbay jechéꞌ an mímláb. ");
INSERT INTO husNT2005_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Kutpan tám juní na Jesús ani in óntsi ti dhutsum ban chabál. ");
INSERT INTO husNT2005_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Por tam tin achʼaꞌtsik jechéꞌ, in chalpay abal walbidhtsik ani in tuju ka kʼaleltsik juntsik ti juntsik. Okʼox tin tuju ka kʼale xi yejchelichtsik ani tayíl xi más. Tam ti ejtalich kʼalnektsik, na Jesús jilkʼon kwetém kʼal jachanꞌ an mímláb, xi tajaꞌ ti jilkʼonék. ");
INSERT INTO husNT2005_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Lujkun tám na Jesús ani kom yab más in chuꞌu xitaꞌ waꞌach, tokot an mímláb, in utsaꞌ enchéꞌ: ―Mímláb, ¿jónꞌ ti kʼaletsik xi kʼwajat ti ólnál? ¿Ni jun xitaꞌ ti walbiy? ");
INSERT INTO husNT2005_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Tókʼon enchéꞌ an mímláb: ―Yabaꞌ Ajátik, ni jun xitaꞌ. Utsan tám enchéꞌ kʼal na Jesús: ―Pos yab neye tu walbiyal; ki kʼaléch ani yabich más ka walaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Na Jesús in tawnaꞌ juní an atiklábtsik ani in utsaꞌ enchéꞌ: ―Nanáꞌich nin kʼwajat jelti an tajaxtaláb abal an kʼayꞌlá; xitaꞌ ti kin wéwnaꞌ neꞌech kin kóꞌoy an tajaxtaláb xin pidhnál an xeꞌchintaláb xi yab in koꞌol in okʼontal ani yab neꞌech ka xeꞌchin jelti max ban jikʼwaxtaláb. ");
INSERT INTO husNT2005_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Utsan tám enchéꞌ kʼal an fariseotsik: ―Tatáꞌkʼi exom a tʼilál tabáꞌ ani jachanꞌ xowaꞌ a tʼilál, yab xataꞌ in jalbíl. ");
INSERT INTO husNT2005_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Tókʼoyattsik enchéꞌ kʼal na Jesús: ―Maske Nanáꞌkʼi u tʼilál tubáꞌ, in jalbíl tʼajat xowaꞌ u tʼilál. Pos u choꞌób xon tin tál ani xon tin neꞌech; por tatáꞌtsik yab a choꞌób xon tin tál nibal xon tin neꞌech. ");
INSERT INTO husNT2005_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Tatáꞌtsik tin walbiyal kʼal xowaꞌkʼi a chuꞌtal u tʼajál. Nanáꞌ yab u walbiyal ni jun xitaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ani max ku walbiy jun xitaꞌ, in lujtalkʼi tu tʼajál; pos yab u tʼajál Nanáꞌ kwetém, i tʼajál junax kʼal an Tátaꞌláb xi tin abámal. ");
INSERT INTO husNT2005_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ban takʼixtaláb xi tatáꞌtsik a koꞌol, taꞌ kʼwajat dhutsadh enchéꞌ: “Tam cháb i ólnax kin ulu jayéchkʼi, awil ka beltsin.” ");
INSERT INTO husNT2005_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Nanáꞌ u tʼilál tubáꞌ ani an Tátaꞌláb xi tin abámal tin tʼilál jeye. ");
INSERT INTO husNT2005_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Konyat tám enchéꞌ na Jesús: ―¿Jónꞌ ti kʼwajat na Tátaꞌ? Tókʼoyattsik enchéꞌ kʼal na Jesús: ―Tatáꞌtsik yab tin exlál, nibal a exláltsik nu Tátaꞌ; max tin exlálaktsik, a exlálaktsik jeye nu Tátaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ejtal jechéꞌ in ulu na Jesús tam ti kʼwajat ti okʼtsix ban pulek atá xon tu kʼakʼnáb na Dios, xon ti kʼwajat in bál an pikbantsixtaláb. Por kʼal ni jun xitaꞌ ti yakʼwan, kom yabél in bajúmal an kʼij xowkʼi ti neꞌech ka chemdhá. ");
INSERT INTO husNT2005_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Witsʼkʼontsattsik juní ka utsan enchéꞌ kʼal na Jesús: ―Nanáꞌ neꞌech kin kʼale ani neꞌech ti kin aliytsik, por neꞌech ki chemechtsik kʼal na walastalábil; pos xon ti Nanáꞌ in neꞌech, tatáꞌtsik yab neꞌech ka ejto ki kʼale. ");
INSERT INTO husNT2005_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","In ulutsik tám enchéꞌ an judíotsik: ―¿Awxeꞌ neꞌech kin chemdhaꞌ tinbáꞌ ani jaxtám tu utsál ke wawáꞌ yab neꞌech ki ejto ku kʼale xon ti Jajáꞌ neꞌech? ");
INSERT INTO husNT2005_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Utsantsik tám enchéꞌ kʼal na Jesús: ―Tatáꞌtsik techéꞌ i kʼwajíl chaꞌat, por Nanáꞌ in kʼwajíl túꞌ tʼekʼat; tatáꞌtsik techéꞌ i kʼwajíl ban kʼayꞌlá, por Nanáꞌ yabaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Jaxtám tu utsaꞌtsik ke neꞌech ki chemech kʼal na walastalábiltsik; pos max yab a beláltsik xowaꞌ tu utsál kʼal tin kwenta xitam jáꞌ neye, neꞌech ki chemech kʼal na walastalábiltsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Konyat tám enchéꞌ na Jesús: ―¿Jitaꞌ pé teye? Ani tókʼoyattsik enchéꞌ kʼal na Jesús: ―Tu utsámalichtsik asta tam tu tujukʼi tu okʼtsitsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Yán tʼajat u koꞌol xantʼéy tu utsaꞌtsik ani tu lujtsitsik, por xitaꞌ tin abámal jaꞌich na Dios xi kʼwajat ejat. Ani xowaꞌ u utsáltsik xi techéꞌ ti kʼayꞌlá, jaꞌich xowaꞌ u achʼámal in ulal. ");
INSERT INTO husNT2005_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Por jajáꞌtsik yab in exbay ke na Jesús kʼwajat in tʼilál an Tátaꞌláb. ");
INSERT INTO husNT2005_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Jaxtám ti utsantsik enchéꞌ kʼal na Jesús: ―Tam tatáꞌtsik ti kin tʼekʼbaꞌich pajkʼidh ban peltsidh teꞌ, Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik, tám neꞌech ti kin exlaꞌtsik ke Nanáꞌich xitam jáꞌ tu utsámaltsik ani ke yab xataꞌ u tʼilál kʼal Nanáꞌkʼi tu kwetém chalab, tokot u tʼilál xowaꞌ in okʼtsidh kʼal an Tátaꞌláb. ");
INSERT INTO husNT2005_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Abal nu Tátaꞌ xi tin abámal, kʼwajat kʼal Nanáꞌ ani yab jaykʼi tin jilámal kwetém, pos echʼekʼi u tʼajál tokot xowaꞌ Jajáꞌ in léꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Tam ti na Jesús in tʼilaꞌ jechéꞌ, kʼal yán ti belan. ");
INSERT INTO husNT2005_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Utsantsik tám enchéꞌ kʼal na Jesús an judíotsik xi kʼál ti belnék: ―Max tatáꞌtsik yab ka jilaꞌ ka belaꞌ xowaꞌ tu utsáltsik, tsubaxich tám tu exóbaliltsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Neꞌech tám ka exlaꞌtsik an tsubaxtaláb ani an tsubaxtaláb neꞌech ti ki walkaꞌichtsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Tókʼontsik tám enchéꞌ: ―Wawáꞌ i wejeꞌ pakélil na Abraham ani yab jaykʼi u kʼwajinek tu jolib kʼal ni jun xitaꞌ. ¿Jantʼókʼi pé tám ta ulal ke neꞌech tám ku walkájich? ");
INSERT INTO husNT2005_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Tókʼoyattsik enchéꞌ kʼal na Jesús: ―Tsubax tu utsáltsik, ke ejtal xu walablomtsik, u kóꞌyáb jelti jolib kʼal an walastaláb. ");
INSERT INTO husNT2005_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Jun i jolib yab neꞌech ka kʼwajay echʼekʼi ban kʼimádh xon tu tʼójontsix, por jun i chakámláb echʼekʼi jaꞌ neꞌech ka kʼwajay ba jachanꞌ an kʼimádh. ");
INSERT INTO husNT2005_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Jaxtám, max an Chakámláb ti ki walkaꞌtsik, tsubaxich tám ta walkadhichtsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","U choꞌóbich abal a wejeꞌ pakéliltsik na Abraham; por a léꞌtsik ti kin chemdhaꞌ, kom yab a belál xowaꞌ tu utsáltsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nanáꞌ u tʼilál xowaꞌ tin xalkʼantsámal nu Tátaꞌ ani tatáꞌtsik a tʼajál xowaꞌ ti utsál na tátaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Tókʼoyat tám enchéꞌ kʼal jajáꞌtsik: ―Ni tátaꞌ jaꞌich na Abraham. Por utsantsik enchéꞌ kʼal na Jesús: ―Max tsubaxak lejtal ta chakámlábtsik kʼal na Abraham, a tʼajálaktsik xowaꞌ jajáꞌ in tʼajámal. ");
INSERT INTO husNT2005_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Por xoꞌ, maske tu óltsámalichtsik an ti tsubaxtaláb xi tin xalkʼantsámal na Dios, bélkʼi a léꞌtsik ti kin chemdhaꞌ. ¡Na Abraham yab jaykʼi in tʼajámal anchanꞌ! ");
INSERT INTO husNT2005_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","’Tatáꞌtsik a tʼajál xowaꞌ in tʼajál na tátaꞌ. Utsan tám enchéꞌ kʼal jajáꞌtsik: ―Wawáꞌ yab u chakámláb kʼal kʼeꞌetich kʼeꞌetich i tátaꞌláb, jún tokot i tátaꞌ i koꞌol ani jaꞌich na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Utsantsik tám enchéꞌ kʼal na Jesús: ―Max tsubaxak lejtal na Dios jaꞌichtsik na tátaꞌ, neꞌech ti kin kʼakʼnaꞌtsik, pos Nanáꞌ ba Dios tin tál. Yab in tsiꞌnek kʼal Nanáꞌkʼi tu kwetém chalab, in tsiꞌnek kom na Dios tin abámal. ");
INSERT INTO husNT2005_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Tatáꞌtsik yab a ejtowal ka exbay xowaꞌ u ulal kom yab a léꞌ ka achʼaꞌtsik an tsubaxtaláb xi tu utsál. ");
INSERT INTO husNT2005_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Tatáꞌtsik a tátaꞌ an lej atʼax ani kʼál ta dhabalábtsik; ani tokot a léꞌ ka tʼajaꞌtsik xowaꞌ jajáꞌ in léꞌ. An lej atʼax jaꞌich jun i chemdhax asta ti tujenek an kʼayꞌlá. Yab jaykʼi in éynámal an tsubaxtaláb ani yab jaykʼi in ulal xowaꞌ tsubax. Tam u kʼambix, kʼwajat ti káw jelt xan ti jajáꞌ jeye; pos jajáꞌ jaꞌich jun i kʼambix ani jaꞌich nu okʼlek kʼal an kʼambixtaláb. ");
INSERT INTO husNT2005_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Por kom Nanáꞌ u ulal xowaꞌ tsubax, yabtsik tin beltsal. ");
INSERT INTO husNT2005_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Jitaꞌ xi tatáꞌtsik neꞌech kin ejto ti kin utsaꞌ ke Nanáꞌ in walbidh? Ani max u ulal xowaꞌ tsubax, ¿jantʼókʼi ti yab tin beltsaltsik? ");
INSERT INTO husNT2005_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Xitaꞌ u dhabaláb kʼal a Dios, in axtsal tin káwintal na Dios; por kom tatáꞌtsik yab i dhabaláb kʼal na Dios, jaxtám ti yabtsik a léꞌ ka axtsi an tin káwintal. ");
INSERT INTO husNT2005_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Utsan tám enchéꞌ na Jesús kʼal an judíotsik: ―Tsubax xowaꞌ i ulal tam ki ulu ke Tatáꞌ i kʼwajíl Samaria ani i teykómte kʼal jun i atʼax ejattaláb. ");
INSERT INTO husNT2005_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Tókʼoyattsik enchéꞌ kʼal na Jesús: ―Yab in teykómte kʼal ni jun i atʼax ejattaláb, tokot u kʼakʼnál nu Tátaꞌ, por tatáꞌtsik yab tin kʼakʼnál. ");
INSERT INTO husNT2005_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Nanáꞌ yab u ayal kin kʼakʼná. Waꞌach jun xitaꞌ xin léꞌ kin chuꞌu kin kʼakʼná ani Jajáꞌ, jaꞌich nu lújundhax. ");
INSERT INTO husNT2005_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Tsubax tu utsáltsik, ke xitaꞌ kin exbay xowaꞌ u ulal, yab jaykʼi neꞌech ka chemech. ");
INSERT INTO husNT2005_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Tókʼoyat tám enchéꞌ kʼal an judíotsik: ―Xoꞌ ojniꞌ i exbách ke tsubax lejtal i kʼwajat teykómte kʼal jun i atʼax ejattaláb. Na Abraham ani ejtal an tʼiltsixtsik chemech, por Tatáꞌ a ulal ke xitaꞌ kin exbay xowaꞌ a ulal, yab jaykʼi neꞌech ka chemech. ");
INSERT INTO husNT2005_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Awxeꞌ Tatáꞌ más i uluts ké ni tátaꞌ Abraham? Jajáꞌ ani an tʼiltsixtsik chemech. ¿Jitam jáꞌ pé ta chalpayal ke Tatáꞌ teye? ");
INSERT INTO husNT2005_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Tókʼoyattsik enchéꞌ kʼal na Jesús: ―Max Nanáꞌkʼi u ayal kin kʼakʼnaꞌ, an kʼakʼnaxtaláb xi ku bachʼu yab xataꞌ in jalbíl. Por xitaꞌ tin kʼakʼnál jaꞌich nu Tátaꞌ xi tatáꞌtsik a ulal ke jaꞌich na Diosil. ");
INSERT INTO husNT2005_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Tatáꞌtsik yab a exlál, por Nanáꞌ u exlál ani max ku ulu ke yab u exlál, in kalelich neye tám in kʼambix jelti tatáꞌtsik. Nanáꞌ tsubax u exlál ani u tʼajál xowaꞌ Jajáꞌ in ulal. ");
INSERT INTO husNT2005_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Na wejeꞌ pakélil Abraham, kulbé tʼajat abal jajáꞌ neꞌech kin chuꞌu an kʼij xowkʼi Nanáꞌ ti neꞌech kin tsích. In chuꞌu ani kulbé tʼajat. ");
INSERT INTO husNT2005_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Utsan tám enchéꞌ na Jesús kʼal an judíotsik: ―Nibal bél a koꞌol chab inik láju i tamub, ani ¿a ulal ke a chuꞌúmal na Abraham? ");
INSERT INTO husNT2005_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Tókʼoyattsik tám enchéꞌ kʼal na Jesús: ―Tsubax tu utsáltsik, ke tam ti yabél waꞌach na Abraham, Nanáꞌ kʼejlejich taꞌ tin kʼwajat. ");
INSERT INTO husNT2005_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","In penaꞌtsik tám i tʼujub abal kin tʼujbay na Jesús, por Jajáꞌ chinkʼon ani kale ban pulek atá xon tu kʼakʼnáb na Dios. Tajaꞌ ti watʼey junax chʼejel xon ti kʼwajattsik ani kʼale. ");
INSERT INTO husNT2005_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Tam ti na Jesús watʼey ba jun i kwentsal, in chuꞌu jun i inik xi jokʼol ti waꞌchinék ti chakam. ");
INSERT INTO husNT2005_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ani konyat enchéꞌ kʼal nin exóbaliltsik: ―Okʼtsix, ¿jantʼókʼi ti anchanꞌ ti waꞌchinék ti chakam jechéꞌ an inik? ¿Awxeꞌ in walámal nin tátaꞌtsik, o jajáꞌ in walámal? ");
INSERT INTO husNT2005_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Tókʼoyattsik enchéꞌ kʼal na Jesús: ―Yab jajáꞌ in walámal, nibal nin tátaꞌtsik; jechéꞌ támnék anchanꞌ abal ka xalkʼan ba jechéꞌ an inik xowaꞌ na Dios in ejtowal kin tʼajaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Lejat xoꞌ bél tajax, yejat ku tʼajtsi an tin tʼojlábil xi tin abámal; pos neꞌech ka jikʼwchin ani yab xitaꞌ neꞌech kin ejto ti tʼojnal. ");
INSERT INTO husNT2005_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Lejat in kʼwajat techéꞌ ti kʼayꞌlá, Nanáꞌ nin kʼwajat jelti an tajaxtaláb abal an kʼayꞌlá. ");
INSERT INTO husNT2005_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Tam ti na Jesús okʼon kin ulu jechéꞌ, in tubaꞌ in ijil chabál, in tʼajaꞌ wéꞌ i kʼutʼ kʼal nin ijil ani in mawtsi kʼál tin wal an jokʼol. ");
INSERT INTO husNT2005_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","In utsaꞌ tám enchéꞌ: ―Ki kʼale ka midhiy na wal ban chʼakat jaꞌ xu bijyáb Siloé (Siloé, in léꞌ kin ulu Abatwále). Kʼale tám an jokʼol, in midhiy tajaꞌ nin wal ani tam ti witsiy, in ejtowalich tám ti chuꞌux. ");
INSERT INTO husNT2005_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Jaxtám, tam ti chuꞌtat kʼal nin at kʼimádhtsik ani kʼal ejtal xitaꞌ kʼál tu exláb abal jajáꞌ u jokʼol, in ulutsik enchéꞌ: ―¿Yabxeꞌ jaꞌich jechéꞌ an inik xu buxkanal ti konox tolmixtaláb? ");
INSERT INTO husNT2005_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Taltsik in ulal enchéꞌ: ―Jajáꞌ. Kʼeꞌettsik in ulal enchéꞌ: ―Yab jajáꞌ, por in junwal tʼajat. Por xu jokʼolwiꞌik in ulal enchéꞌ: ―Nanáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Konyat tám enchéꞌ: ―¿Por jan ti pé ta uwaꞌ abal i chuꞌuxich xoꞌ? ");
INSERT INTO husNT2005_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Tókʼon ani in ulu enchéꞌ: ―An inik xu bijyáb ta Jesús in tʼajaꞌ i kʼutʼ, tin mawtsi kʼál tu wal ani tin utsaꞌ enchéꞌ: “Ki kʼale ban chʼakat jaꞌ xu bijyáb Siloé ani ka midhiy tajaꞌ na wal.” Pos in kʼale ani tam tu midhiy nu wal, in chuꞌxinich tám. ");
INSERT INTO husNT2005_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Konyat tám enchéꞌ: ―¿Jónꞌ xoꞌ ti kʼwajat jachanꞌ an inik? Ani jajáꞌ tókʼon enchéꞌ: ―Yab u choꞌób. ");
INSERT INTO husNT2005_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Júná tám ban fariseotsik jachanꞌ an inik xu jokʼolwiꞌik. ");
INSERT INTO husNT2005_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Por kom in kʼítsájil i koyóxnich tam ti na Jesús in tʼajaꞌ an kʼutʼ ani in jeldhaꞌ an jokʼol, ");
INSERT INTO husNT2005_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","an fariseotsik in konoy juní jachanꞌ an inik xan tin uwámal abal u chuꞌuxich xoꞌ. Jajáꞌ in tókʼoytsik enchéꞌ: ―Tin mawtsi ti kʼutʼ bu wal, u midhiy ani xoꞌ in chuꞌuxich. ");
INSERT INTO husNT2005_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","In ulu tám enchéꞌ taltsik an fariseotsik: ―An inik xin tʼajaꞌ jechéꞌ, yab xónaꞌ ba Dios ti tál, pos yab in pakwlantsal in kʼítsájil an koyóxnich. Por taltsik in ulal enchéꞌ: ―¿Janti neꞌech kin ejto kin tʼajaꞌ jelti jechéꞌ i labidh labandhaxtaláb max i walablom inik? Jaxtám ti kʼeꞌetich kʼeꞌetich an chalab in koꞌoltsik kʼal tin kwenta xowaꞌ in tʼajám na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Konyat tám juní enchéꞌ an inik xu jokʼolwiꞌik: ―¿Ani tatáꞌ, jantʼéy a ulal kʼal tin kwenta jachanꞌ an inik xi ti chuꞌxindhaꞌ? Ani jajáꞌ in ulu enchéꞌ: ―Nanáꞌ u ulal ke Jajáꞌ jaꞌich jun i tʼiltsix. ");
INSERT INTO husNT2005_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Por an judíotsik yab in belál ke jachanꞌ an inik u jokʼolwiꞌik ani xoꞌ u chuꞌuxich, asta ti kantsin tin tátaꞌtsik jachanꞌ an inik xi jeldhats ");
INSERT INTO husNT2005_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ani konyat enchéꞌ an tátaꞌlábtsik: ―¿Jaꞌichxeꞌ jechéꞌ na chakámil, xa ulaltsik ke jokʼol ti waꞌchinék ti chakam? ¿Janti pé xoꞌ tu chuꞌuxich? ");
INSERT INTO husNT2005_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","An tátaꞌlábtsik tókʼon enchéꞌ: ―I choꞌób alwaꞌ abal jechéꞌ jaꞌich ni chakámil ani i choꞌób abal jokʼol ti waꞌchinék ti chakam; ");
INSERT INTO husNT2005_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","por yab i choꞌób xantʼókʼi tu chuꞌuxich xoꞌ nibal i choꞌób xitaꞌ kʼál ti chuꞌxindhats. Jajáꞌ ka konoy, púlekich ani neꞌech ti ki óltsitsik xitaꞌ kʼál ti jeldhats. ");
INSERT INTO husNT2005_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Nin tátaꞌtsik in ulu jechéꞌ abal in chʼejnál an judíotsik, pos an judíotsik in tʼajámalichtsik i káw abal yabich neꞌech kin walkaꞌ ka ochich ban atá xon tu tʼajnal an junkuntaláb xitaꞌ kin belaꞌ ke na Jesús jaꞌich an Kristo. ");
INSERT INTO husNT2005_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Jaxtám tin ulu enchéꞌ nin tátaꞌtsik jachanꞌ an inik: “Jajáꞌ ka konoy, púlekich.” ");
INSERT INTO husNT2005_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Kanyat tám juní kʼal an judíotsik jachanꞌ an inik xi jokʼolwiꞌik ani utsan enchéꞌ: ―Tin bij na Dios, ti ku utsaꞌ xowaꞌ tsubax. Wawáꞌ i choꞌób abal jachanꞌ an inik i walablom. ");
INSERT INTO husNT2005_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Jajáꞌ in tókʼoytsik tám enchéꞌ: ―Nanáꞌ yab u choꞌób max i walablom o yabaꞌ. Tokot u choꞌób ke nanáꞌ in jokʼolwiꞌik ani xoꞌ in chuꞌuxich. ");
INSERT INTO husNT2005_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ani konyat juní enchéꞌ: ―¿Jantʼéy ti tʼajtsi? ¿Jan tin uwaꞌ abal kin ejto ti ki chuꞌxindhaꞌ? ");
INSERT INTO husNT2005_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Jajáꞌ in tókʼoytsik enchéꞌ: ―Tu utsámalichtsik ani yab tin beltsal; ¿jantʼókʼi ta léꞌ tu witsʼkʼontsitsik? ¿A léꞌtsik teye ka wéwnaꞌ? ");
INSERT INTO husNT2005_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Odhbijyat tám ani utsan enchéꞌ: ―Tatáꞌ a wéwnál jachanꞌ an inik, por wawáꞌ i wéwnál a Moisés. ");
INSERT INTO husNT2005_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Wawáꞌ i choꞌób abal na Moisés tawnadh kʼal na Dios; por jachanꞌ an inik, nibal i choꞌób elaꞌ xon ti tál. ");
INSERT INTO husNT2005_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Tókʼoyattsik tám enchéꞌ kʼal jachanꞌ an inik xu jokʼolwiꞌik: ―¡Pos jaꞌich jechéꞌ xowaꞌ yab i ejtowal ki exbay! Tatáꞌtsik yab a choꞌób xon ti tál ani nanáꞌ tin chuꞌxindhaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Wawáꞌ i choꞌób ke na Dios yab in axtsal xowaꞌ kin konoy jun i walablom; tokot in axtsal xitaꞌ kʼál tu kʼakʼnáb ani in tʼajál xowaꞌ in léꞌ na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Yab jaykʼi i achʼámal ti tʼilnal jun xitaꞌ xin ejtowal kin chuꞌxindhaꞌ jun xitaꞌ xi jokʼol ti waꞌchinék ti chakam. ");
INSERT INTO husNT2005_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Max jechéꞌ an inik yabak ba Dios ti tál, yab neꞌech kin ejto kin tʼajaꞌ jun xataꞌ jelti jechéꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Utsan tám enchéꞌ: ―Tatáꞌ xi walbidh tʼajat ta waꞌchinék ta chakam, ¿a léꞌ ti ku okʼtsi? Ani utsan abal yabich más ka kʼale ban atá xon tu tʼajnal an junkuntaláb. ");
INSERT INTO husNT2005_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Na Jesús in choꞌóbnaꞌ abal ajnék jachanꞌ an inik xu jokʼolwiꞌik ani tam tin elaꞌ in utsaꞌ enchéꞌ: ―¿A belálxeꞌ nin Chakámil na Dios? ");
INSERT INTO husNT2005_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Utsan enchéꞌ kʼal an inik: ―Ajátik, ti kin óltsi xitam jáꞌ abal ku belaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Tókʼoyat enchéꞌ kʼal na Jesús: ―Pos a telálich ta kʼwajat, jaꞌich Nanáꞌich xi kʼwajat ta tʼilom junax. ");
INSERT INTO husNT2005_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Tudhlan tám jachanꞌ an inik tin tamét na Jesús ani in utsaꞌ enchéꞌ: ―U belál, Ajátik. ");
INSERT INTO husNT2005_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","In ulu tám enchéꞌ na Jesús: ―Nanáꞌ in tsiꞌnek techéꞌ ban kʼayꞌlá abal ku xalkʼantsi an atiklábtsik xan ti kʼwajat. In tsiꞌnek abal ku chuꞌxindhaꞌ xi kʼwajattsik jelti max u jokʼol ani xu chuꞌuxtsik, ka jilkʼon jelti max u jokʼol. ");
INSERT INTO husNT2005_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Tam tin achaꞌtsik jechéꞌ, taltsik an fariseotsik xi taꞌ ti kʼwajat xon ti kʼwajat na Jesús, konoxintsik enchéꞌ: ―¿U jokʼolxeꞌ weye? ");
INSERT INTO husNT2005_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Tókʼoyattsik enchéꞌ kʼal na Jesús: ―Max i jokʼolaktsik, yabak i walbidh; por kom a ulal abal i chuꞌuxtsik, jaxtám ta walbidh. ");
INSERT INTO husNT2005_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","ʼTsubax tu utsáltsik, xi yab u ochel bin wiꞌlébil in mapúl an borregotsik, xin tʼikontsalkʼi an mapuxtaláb, jachanꞌ jaꞌich an kwéꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Por xu ochel ban wiꞌleb, jachanꞌ jaꞌich an belkol borregotsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","U japtsinal kʼal an belkol wiꞌleb abal ka ochich, in bijyal tin bij an borregotsik ani u exlantsáb tin káwintal ani in káldhál an borregotsik xon ti kʼwajat mapudh. ");
INSERT INTO husNT2005_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Tam in káldhámalich ejtal an borregotsik xi jajáꞌ in dhabal, u okxinal ani u wéwnáb kʼal an borregotsik kom u exlantsáb an tin káwintal. ");
INSERT INTO husNT2005_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Por an borregotsik yab in wéwnál ni jun xitaꞌ xi yab kʼál tu dhabaláb, in jikʼnál tokot kom yab in exlantsal an tin káwintal. ");
INSERT INTO husNT2005_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Utsantsik jechéꞌ an ti junbaxtaláb kʼal na Jesús, por yab in exbaytsik xantʼéy leꞌná ka utsantsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Witsʼkʼontsattsik tám juní ka utsan enchéꞌ kʼal na Jesús: ―Tsubax tu utsáltsik: Nanáꞌich nin kʼwajat jelti an wiꞌleb xon tu ochel an borregotsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ejtal xi tsiꞌnektsik okʼox ké Nanáꞌ, i kwéꞌtsik, por yab tʼajan ti kʼij kʼal an borregotsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Nanáꞌich nin kʼwajat jelti an wiꞌleb; xitaꞌ ka ochich ba Nanáꞌ xin kʼwajat jelti an wiꞌleb neꞌech ka loꞌey. Neꞌech kin junu jelti jun i borrego xu ochel ani u kalel ban mapuxtaláb ani in elál i tóm. ");
INSERT INTO husNT2005_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","ʼAn kwéꞌ u tsiꞌilkʼi ti kwéꞌ ani ti chemdhax; por Nanáꞌ in tsiꞌnek abal ka kóꞌoytsik an ít xeꞌchintaláb, an xeꞌchintaláb xi yab in koꞌol in okʼontal. ");
INSERT INTO husNT2005_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Nanáꞌich nin kʼwajat jelti an alwaꞌ belkol borregotsik. An alwaꞌ belkol, yab in ódhál ti kwenta maske ka chemdhá abal kin loꞌo an borregotsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Por xu belkol abal in léꞌkʼi kin átaꞌ i tumín, tam kin chuꞌu tál an padhum, in jilál kwetém an borregotsik ani jajáꞌ u kʼalel ti chinkʼonal. In tʼajál anchanꞌ kom yab i alwaꞌ belkol ani kom yab jajáꞌ in dhabal an borregotsik. U yakʼwnal tám taltsik an borregotsik kʼal an padhum ani xi kʼeꞌettsik, u bukʼel, kom u jikʼédháb. ");
INSERT INTO husNT2005_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Jechéꞌ an inik u kʼalel ti chinkʼonal, kom tokotkʼi kʼwajat ti belkol abal in léꞌ kin átaꞌ i tumín ani yab in kʼanidhál an borregotsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","ʼNanáꞌich nin kʼwajat jelti an alwaꞌ belkol. Anchanꞌ jelt xan ti nu Tátaꞌ tin exlál ani Nanáꞌ u exlál Jajáꞌ, anchanꞌ tu exlál xitaꞌ tin belálichtsik ani jajáꞌtsik tin exlál neye. Nanáꞌ neꞌech ku pidhnaꞌ tubáꞌ kin chemdhá abal ku loꞌotsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","U koꞌol jeye kʼeꞌet xi neꞌech ti kin belaꞌtsik xi yabél kʼwajat kʼal Nanáꞌ ani koꞌol jeye ku ututsik kʼal Nanáꞌ. Neꞌech ti kin axtsitsik an tu káwintal, jún tokot i kweneꞌ neꞌech ka waꞌchin ani júnkʼi jeye tokot i belkol. ");
INSERT INTO husNT2005_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","ʼAn Tátaꞌláb tin kʼanidhál abal u pidhnál tubáꞌ kin chemdhá ani tayíl kin ejech ti ít. ");
INSERT INTO husNT2005_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Yab xitaꞌ tin nixál ku pidhnaꞌ tubáꞌ kin chemdhá, Nanáꞌkʼi u pidhnal tubáꞌ kʼal u kulbétal. U koꞌol i awiltaláb ku pidhnaꞌ tubáꞌ kin chemdhá ani u koꞌol i awiltaláb abal kin ejech ti ít. Jechéꞌ jaꞌich xowaꞌ tin utsámal ku tʼajaꞌ nu Tátaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Tam ti an judíotsik in achʼaꞌ jechéꞌ, in kóꞌoytsik kʼeꞌetich kʼeꞌetich i chalab kʼal tin kwenta xowaꞌ in ulu na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Yán xi jajáꞌtsik in ulal enchéꞌ: ―¿Jantʼókʼi ta exbantsaltsik? Jajáꞌ ochadh kʼal i atʼax ejattaláb ani u olmanal. ");
INSERT INTO husNT2005_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Por taltsik in ulal enchéꞌ: ―Ni jun xitaꞌ xi ochadh kʼal i atʼax ejattaláb yab neꞌech kin ejto ti káw anchanꞌ. ¿Awxeꞌ jun i atʼax ejattaláb neꞌech kin ejto kin chuꞌxindhaꞌ jun i jokʼol? ");
INSERT INTO husNT2005_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Tam ti jachanꞌ i kʼij, chamay ani ban bitsow Jerusalén kʼwajat ti tʼajnal i ajib kʼal tin kwenta xowkʼi ti tʼokwat ani tujey ti éynáb an pulek atá xon tu kʼakʼnáb na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Na Jesús taꞌ ti xeꞌech ban pulek atá xon tu kʼakʼnáb na Dios ban chakʼ xu bijyáb Salomón, ");
INSERT INTO husNT2005_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","wiliyat kʼal an judíotsik ani utsan enchéꞌ: ―¿Asta jowkʼi neꞌech tu kóꞌoy tu chalpax? Max Tatáꞌich ni Kristo, ti ku óltsitsích. ");
INSERT INTO husNT2005_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Tókʼoyattsik enchéꞌ kʼal na Jesús: ―Tu óltsámalichtsik ani yab tin beltsal. Ejtal xowaꞌ u tʼajál kʼal tin awiltal nu Tátaꞌ, in xalkʼálich xitam jáꞌ neye Nanáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Por yabtsik a belál, kom yab tin belál jelti xi utenekichtsik kʼal Nanáꞌ, jelt xan tu utsámalichtsik okʼox. ");
INSERT INTO husNT2005_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Xitaꞌ tin belálichtsik, tin axtsalichtsik xowaꞌ u ulal; u exláltsik ani jajáꞌtsik tin wéwnál. ");
INSERT INTO husNT2005_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","U pidhámalichtsik ti xeꞌchintaláb xi yab in koꞌol in okʼontal ani yab neꞌech ka kʼaletsik ban kʼibeltaláb, nibal xitaꞌ neꞌech kin ejto ti kin kʼántsi. ");
INSERT INTO husNT2005_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Nu Tátaꞌ jaꞌich tin pidhámaltsik. Jajáꞌ jaꞌich xi más púlek ani xi más ultaláb ani kʼal ni jun xitaꞌ ti neꞌech ka ejtowat ka kʼántsin. ");
INSERT INTO husNT2005_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nanáꞌ ani an Tátaꞌláb, jun tokot tu áynal. ");
INSERT INTO husNT2005_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","In penaꞌ tám juní i tʼujub an judíotsik abal kin tʼujbay na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ani utsantsik enchéꞌ kʼal na Jesús: ―Yánich tʼajat xataꞌ alwaꞌ u tʼajámal ta taméttsik kʼal tin awiltal nu Tátaꞌ, ¿kʼal jowaꞌ kʼál tin kwenta ta léꞌ ti kin tʼujbaytsik? ");
INSERT INTO husNT2005_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Tókʼoyat enchéꞌ kʼal an judíotsik: ―Yab i leꞌnáb ki tʼujbayat kʼal ni jun xowaꞌ alwaꞌ a tʼajámal. I leꞌnáb ki tʼujbayat kom púlekich tʼajat an walastaláb a tʼajál abal a tʼajálich tabáꞌ jelti max i Dios. Pos Tatáꞌ jayéch teye jun i inik jelti wawáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Utsantsik tám enchéꞌ kʼal na Jesús: ―Ban takʼixtaláb xi tatáꞌtsik a éynál kʼwajat dhutsadh ke na Dios in ulúmal enchéꞌ: “Tatáꞌtsik i diostsik teye.” ");
INSERT INTO husNT2005_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","I choꞌób ke xowaꞌ in ulal an Tʼokat Dhuslab, yab neꞌech ki ejto ki ulu ke yab tsubax ani na Dios in bijiy ti diostsik an atiklábtsik xi axtsin kʼál tin káwintal. ");
INSERT INTO husNT2005_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ani max na Dios tin takwyámal ani tin abámal techéꞌ ti kʼayꞌlá, yab neꞌech ka ejto ka ulutsik ke u odhbijyal na Dios abal u ulal ke Nanáꞌ in Chakámláb kʼal Jajáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Max yab u tʼajál xowaꞌ in tʼajál nu Tátaꞌ, yab ti kin belaꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Por max u tʼajál, maske yab ti kin belaꞌtsik, ka belaꞌtsik xowaꞌ a chuꞌtal u tʼajál abal ka choꞌóbnaꞌtsik ke an Tátaꞌláb kʼwajat kʼal Nanáꞌ ani Nanáꞌ in kʼwajat kʼal an Tátaꞌláb. ");
INSERT INTO husNT2005_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","U leꞌnábwiꞌik juní ka yakʼwan, por chinkʼontsattsik kʼal na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Witsiy tám na Jesús ban waljaꞌ Jordán ani tajaꞌ ti kʼwajay xon ti na Juan kʼwajinek ti pújal más okʼox. ");
INSERT INTO husNT2005_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Kʼal yán i atiklábtsik tu kʼalel ti chuꞌtáb na Jesús ani in ulaltsik enchéꞌ: ―Tsubax lejtal, maske na Juan yab in tʼajaꞌ ni jun i labidh exól, ejtal xowaꞌ in ulu kʼal tin kwenta jechéꞌ an inik, tsubax. ");
INSERT INTO husNT2005_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ani kʼal yán ti belan na Jesús tam ti tajaꞌ ti kʼwajat. ");
INSERT INTO husNT2005_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Táꞌ ti kʼwajat jun i inik u yaꞌul xu bijyáb ta Lásaro. Jechéꞌ an inik u kʼwajíl ban kwentsal xin bij Betania, xon tu kʼwajíltsik jeye na María ani na Marta, nin ixámtsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Jechéꞌ na María, nin ixám na Lásaro, an inik xu yaꞌul, jaꞌich an mímláb xin mawtsi kʼal i niwiytaláb tin akan an Ajátikláb ani in wayedhantsi kʼal in xiꞌíl. ");
INSERT INTO husNT2005_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Jechéꞌ cháb an mímlábtsik in abnaꞌ ka utsan enchéꞌ na Jesús: ―Ajátik, na jaꞌúb u yaꞌul. ");
INSERT INTO husNT2005_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Tam ti na Jesús in achʼaꞌ, in ulu enchéꞌ: ―Jechéꞌ an yawꞌlách yab jaꞌich tokot abal ka chemech, jaꞌich abal kin xalkʼaꞌ nin labidh tʼokát na Dios ani anchanꞌ ka xalkʼan jeye nin labidh tʼokát nin Chakámil na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Maske na Jesús in kʼanidhál tʼajat na Marta, na María ani na Lásaro jeye, ");
INSERT INTO husNT2005_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","tam ti utsan ke na Lásaro u yaꞌul, yab kʼale jikʼat kin álnaꞌ, jilkʼon bél cháb a kʼítsá xon ti kʼwajat. ");
INSERT INTO husNT2005_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Tayíl in utsaꞌ tám enchéꞌ nin exóbaliltsik: ―Wana juní Judea. ");
INSERT INTO husNT2005_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Utsan tám enchéꞌ kʼal nin exóbaliltsik: ―Okʼtsix, xoꞌ ít, an judíotsik xi tajaꞌ u kʼwajíl in leꞌnámaltsik ti ki tʼujbay; ani ¿xoꞌ a léꞌ juní ki kʼale tajaꞌ? ");
INSERT INTO husNT2005_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Tókʼoyattsik enchéꞌ kʼal na Jesús: ―¿Yabxeꞌ lajucháb i ora in koꞌol xi jun a kʼítsá? Pos max jun xitaꞌ xeꞌech ti belal tam kʼij, yab u tʼadhkʼunal kom in telál an tajaxtaláb xi waꞌach ba jechéꞌ an kʼayꞌlá. ");
INSERT INTO husNT2005_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Por max jun xitaꞌ xeꞌech tam jikʼwax, u tʼadhkʼunal kom yab tajax xon ti xeꞌech. ");
INSERT INTO husNT2005_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Tayíl utsantsik juní enchéꞌ kʼal na Jesús: ―Ni jaꞌúb Lásaro wayámadhich, por neꞌech ku bakiy. ");
INSERT INTO husNT2005_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Utsan tám enchéꞌ kʼal an exóbaltsik: ―Ajátik, max wayámadhich, tám, neꞌech ka elábmé. ");
INSERT INTO husNT2005_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Por xowaꞌ in leꞌnaꞌ kin ulu na Jesús, jaꞌich ke na Lásaro chemnek, por an exóbaltsik in chalpay ke na Jesús kʼwajat in tʼilál i aniꞌ wayich. ");
INSERT INTO husNT2005_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Utsutsuyattsik tám tsubax enchéꞌ kʼal na Jesús: ―Na Lásaro chemech. ");
INSERT INTO husNT2005_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","In kulbél tʼajat kʼal tatáꞌtsik ta kwenta abal yab tajaꞌ tin kʼwajat abal anchanꞌ ki belmáchtsik. Por wana ki chuꞌu. ");
INSERT INTO husNT2005_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Na Tomás, xu bijyáb ti Kwayaꞌ, in utsaꞌ tám enchéꞌ nin at exóbaltsik: ―Wana weye abal ku chemech junax kʼal Jajáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Tam ti na Jesús ulich Betania, utsan abal in koꞌolich chéꞌ a kʼítsá ti jolidh na Lásaro. ");
INSERT INTO husNT2005_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","An kwentsal xi Betania, kʼwajat kʼunat ban bitsow Jerusalén, cháb kʼal chʼejel xónaꞌ i kilómetro in owíl; ");
INSERT INTO husNT2005_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","ani kʼal yán i judíotsik ti kʼalnek ti álnáb na Marta ani na María abal ka kʼijidhmédhaꞌtsik kom chemnek nin kidháb Lásaro. ");
INSERT INTO husNT2005_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Tam ti na Marta in achʼaꞌ abal táꞌich tu ulel na Jesús, kale kin tamu; por na María jilkʼon ban atá xon tu kʼwajíltsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ani utsan enchéꞌ na Jesús kʼal na Marta: ―Ajátik, max techéꞌak ta kʼwajat, yabak chemnek nu kidháb. ");
INSERT INTO husNT2005_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Por u choꞌób alwaꞌ ke neꞌech ti ki pidhaꞌ na Dios xowaꞌ ka kontsi. ");
INSERT INTO husNT2005_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Utsan enchéꞌ kʼal na Jesús: ―Na kidháb neꞌech ka ejech ti ít. ");
INSERT INTO husNT2005_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Tókʼoyat enchéꞌ kʼal na Marta: ―Aniꞌ kʼejle, u choꞌóbich abal neꞌech ka ejech ti ít tam ka ejdhá an chemélomtsik tam kin bajaw an pakwenib. ");
INSERT INTO husNT2005_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Utsan tám enchéꞌ kʼal na Jesús: ―Nanáꞌich nin ejdhax ti ít ani xu pidhnál an xeꞌchintaláb xi yab in koꞌol in okʼontal. Xitaꞌ ti kin belaꞌ, maske ka chemech, bélkʼi neꞌech ka kʼwajay ejat; ");
INSERT INTO husNT2005_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ani ejtal xi xoꞌ kʼwajat ejat ani tin belál Nanáꞌ, yab neꞌech ka kʼwajay chemnek malilíl i kʼij. ¿A belálxeꞌ jechéꞌ? ");
INSERT INTO husNT2005_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Na Marta tókʼon enchéꞌ: ―U belál, Ajátik. U belál abal Tatáꞌich ni Kristo, nin Chakámil na Dios xi bijidh neꞌech ka tsích techéꞌ ti kʼayꞌlá. ");
INSERT INTO husNT2005_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Tam ti okʼon kin ulu jechéꞌ, na Marta kʼale kin kaniy nin kidháb María ani in utsaꞌ enchéꞌ chinatkʼi: ―Ulnek an Okʼtsix ani tin abámal tu kaniy. ");
INSERT INTO husNT2005_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Tokot tin achʼaꞌ jechéꞌ na María, chʼakay ani kʼale kin chuꞌu na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Na Jesús yabél ochenek ban kwentsal, tajaꞌ bél ti kʼwajat xon ti kʼwajinek ti tʼilolól kʼal na Marta. ");
INSERT INTO husNT2005_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Tam ti chuꞌtat abal chʼakay na María ani kale jikʼatkʼi tʼajat, an judíotsik xi tajaꞌ ti kʼwajat ti kʼijítnax, wéwnaxintsik. In chalpaytsik max na María neꞌech ti ukʼnal xon ti jolidh na Lásaro. ");
INSERT INTO husNT2005_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Tam ti na María ulich xon ti kʼwajat na Jesús, tudhlan tin tamét ani in utsaꞌ enchéꞌ: ―Ajátik, max techéꞌak ta kʼwajat, yabak chemnek nu kidháb. ");
INSERT INTO husNT2005_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Tam ti na Jesús in chuꞌu ti ukʼnaltsik na María ani an judíotsik xi wéwnaxnék, tʼeꞌpin tʼajat asta tin ejattal ");
INSERT INTO husNT2005_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","ani in konoytsik enchéꞌ: ―¿Jónꞌ ta jolyámal? Tókʼoyat enchéꞌ: ―Ajátik, jalaꞌ ka chuꞌu. ");
INSERT INTO husNT2005_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ukʼin tám jeye na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","In ulu tám enchéꞌ an judíotsik: ―Ka telaꞌtsik, in kʼanidhál tʼajat. ");
INSERT INTO husNT2005_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Por taltsik an judíotsik in ulu enchéꞌ: ―Jechéꞌ an inik, xin chuꞌxindhaꞌ an jokʼol, ¿awxeꞌ yabwiꞌik neꞌech kin ejto kin jeldhaꞌ na Lásaro abal yab ka chemech? ");
INSERT INTO husNT2005_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Na Jesús, kʼal yantam i yajnantsixtaláb, utey xon ti jolidh na Lásaro. Xon ti kʼwajat jolidh, jaꞌich jun i cholax chʼén ani paxkʼidh kʼal jun i tʼujub. ");
INSERT INTO husNT2005_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","In ulu tám enchéꞌ na Jesús: ―Ka wékʼoytsik an tʼujub. Utsan enchéꞌ kʼal na Marta, nin ixám an chemélom: ―Ajátik, kaxiyich xónaꞌ nin tʼuꞌúl, kom chéꞌich a kʼítsá in koꞌol ti chemnek. ");
INSERT INTO husNT2005_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Por utsan enchéꞌ kʼal na Jesús: ―¿Yabxeꞌ tu utsámich ke max i belom, neꞌech ka chuꞌtsi tin labidh tʼokát na Dios? ");
INSERT INTO husNT2005_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Wékʼoyat tám an tʼujub xi kʼál ti paxkʼidh an jólimtaláb, in telaꞌ walkʼiꞌ na Jesús ani in ulu enchéꞌ: ―Tátaꞌ, tu pidhál ti jalbintsixtaláb abal tin axtsámal. ");
INSERT INTO husNT2005_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","U choꞌób alwaꞌ abal Tatáꞌ echʼekʼi tin axtsal, por jechéꞌ tu ulal abal tin alwaꞌbíl ejtal jechéꞌ an atiklábtsik xi jéꞌ kʼwajat abal kin belaꞌtsik ke Tatáꞌ tin abámal. ");
INSERT INTO husNT2005_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Tam ti okʼon kin ulu jechéꞌ, in ulu kawidh enchéꞌ: ―¡Lásaro, ki kale! ");
INSERT INTO husNT2005_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ejech tám xi chemnek ani kale, malidh nin kʼubak ani nin akan kʼal i bolixtaláb ani nin ókʼ bolidh jeye kʼal i kʼudhkʼum. Utsantsik tám enchéꞌ kʼal na Jesús: ―Ka wilaꞌ ani ka walkaꞌich ka kʼale. ");
INSERT INTO husNT2005_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Kʼal tin kwentakʼi xowaꞌ in chuꞌutsik in tʼajaꞌ na Jesús, yán an judíotsik xi kʼalnek ti junkil an ta María, in belaꞌ na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Por taltsik an judíotsik kʼale kin chuꞌu an fariseotsik ani in tʼiltsi xowaꞌ in tʼajámal na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Tam ti an fariseotsik ani an okʼlek páleꞌtsik in achʼaꞌ jechéꞌ, junkun kʼal an Junkulom Awiltaláb ani in ulutsik enchéꞌ: ―¿Jantʼéy neꞌech ki tʼajaꞌ? Jechéꞌ an inik exom tʼajat in tʼajál yán i labidh exóltsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Max ki walkaꞌ kin óntsi anchanꞌ, kʼal ejtal ti neꞌech ka belan. Neꞌech tám ka tsích an awiltalábtsik xi Roma, neꞌech ti ku pakwtsi an ti pulek atá xon tu kʼakʼnáb na Dios ani neꞌech ti ku chemdhaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Por jun ti éb xi jajáꞌtsik xu bijyáb ta Kayfás, xi jaꞌich nin okʼlékil an páleꞌtsik tam ti jachanꞌ i tamub, in ulu enchéꞌ: ―Tatáꞌtsik yab a choꞌób xataꞌ, ");
INSERT INTO husNT2005_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","nibal a chalpayaltsik ke más alwaꞌ abal wawáꞌ, ka chemech jún tokot i inik abal tin kwenta an atiklábtsik ani yab ku chemdhá ejtal. ");
INSERT INTO husNT2005_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Por na Kayfás yab in ulu jechéꞌ kʼal jajáꞌkʼi tin kwetém chalab; kom jajáꞌ kʼwajat ti okʼlek páleꞌtsik jachanꞌ i tamub, jaxtám ti ijtsin kin ulu kʼal na Dios ke na Jesús neꞌech ka chemdhá abal ka loꞌey an judíotsik; ");
INSERT INTO husNT2005_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","ani yab tokot jáꞌkʼi, abal kin junku jeye nin chakámiltsik na Dios xi kʼwajat túkʼi túkʼi. ");
INSERT INTO husNT2005_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Jaxtám, asta tam ti jachanꞌ i kʼij, an awiltalábtsik xi Judea in ayaltsik xan ti kin uwaꞌ abal kin ejto kin chemdhaꞌ na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Na Jesús yabich tám in lej xalkʼál tinbáꞌ ka chuꞌtat kʼal an judíotsik, kale ba jachanꞌ an chabál xi Judea ani kʼale ba jun i chabál kʼunat ban chabál xon ti yab kʼwajtsidh, ba jun i bitsow xin bij Efrain. Tajaꞌ ti kʼwajay kʼal nin exóbaliltsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Tam ti jachanꞌ i kʼij, u kʼunelich xowkʼi tin ajíbnál an paskwa an judíotsik ani yán i atiklábtsik xu kʼwajíl ban kwentsaltsik kʼalnek Jerusalén abal kin tʼokotsik tinbáꞌ tam yabél watʼenek an paskwa. ");
INSERT INTO husNT2005_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","In ayaltsik na Jesús ban pulek atá xon tu kʼakʼnáb na Dios ani u kónóxtsik jún ani jún enchéꞌ: ―¿Jantʼéy a chalpayaltsik? ¿Awxeꞌ neꞌech ka tsích an ti ajíblom o yabaꞌ? ");
INSERT INTO husNT2005_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","An fariseotsik ani an okʼlek páleꞌtsik in ulúmal ke max jun xitaꞌ in choꞌób xon ti kʼwajat na Jesús, kin ólnaꞌ abal ka kʼale ti yakʼwnal. ");
INSERT INTO husNT2005_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Bél u kʼibel akak a kʼítsá abal ka watʼey an paskwa, na Jesús kʼale Betania xon tu kʼwajíl na Lásaro, xi chemnek ani ejdhá ti ít kʼal na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Tʼajan tajaꞌ jun i kʼapúch abal tin kʼakʼnabíl na Jesús; na Marta u jótʼil ani na Lásaro jaꞌich jún ti éb xi buxúl ti kʼapul ban mesa kʼal na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","In uldhaꞌ tám na María chʼejel litro xónaꞌ i niwiytaláb xi tʼajadh kʼal i wich xin bij nardo. Jechéꞌ an niwiytaláb, kajbidh tʼajat in jalbíl. Na María in mawtsi kʼál tin akan na Jesús ani in wayedhantsi kʼal nin xiꞌíl. Putál an altá niwbé kʼal jachanꞌ an niwiytaláb. ");
INSERT INTO husNT2005_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Na Judas Iskariote, xi jaꞌich jeye jún ti éb xi lajucháb nin exóbaliltsik na Jesús, xi kʼál ti neꞌech ka pidhná na Jesús abal ka chemdhá, in ulu tám enchéꞌ: ");
INSERT INTO husNT2005_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","―¿Jantʼókʼi ti yab nujwat jechéꞌ an niwiytaláb kʼal óx i boꞌ inik i denariotsik abal ka pidhan an ti tumín an chʼojontáltsik? ");
INSERT INTO husNT2005_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Por na Judas yab in ulu jechéꞌ abal tsubax lejtal tin kʼanidhál an chʼojontáltsik, in ulu anchanꞌ, kom jajáꞌ jaꞌich jun i kwéꞌ, ani kom jajáꞌ in xeꞌchindhál nin bál an tumín, in kwéꞌyal xowaꞌ u balyáb tajaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Utsan tám enchéꞌ kʼal na Jesús: ―Jilaꞌ kʼwajat, yab xataꞌ ka utsaꞌ; pos jajáꞌ in taꞌpámal jechéꞌ abal ti kin mawtsi an tu tʼuꞌúl abal ka kʼwajách tʼojojodh tam kin bajaw xowkʼi neꞌech kin jolyat. ");
INSERT INTO husNT2005_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","An chʼojontáltsik echʼekʼi neꞌech ka kʼwajay kʼal tatáꞌtsik, por Nanáꞌ, yab echʼekʼi neꞌech kin kʼwajay kʼal tatáꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Kʼal yán i judíotsik ti choꞌóbná ke na Jesús taꞌ ti kʼwajat Betania ani kʼaletsik tajaꞌ, yab tokotkʼi abal kin chuꞌutsik na Jesús, aníl jeye abal kin chuꞌutsik na Lásaro, xi ejdhats ti ít kʼal na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Nin okʼlékil an páleꞌtsik in tʼajaꞌtsik i káw abal kin chemdhaꞌ jeye na Lásaro, ");
INSERT INTO husNT2005_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","pos kʼal tin kwentakʼi na Lásaro, yán i judíotsik in pílmédháltsik tinbáꞌ ani in belálichtsik na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Yán i atiklábtsik kʼalnek Jerusalén abal kin ajíbnaꞌtsik an paskwa. Tam ti jun tsudhelom in achʼaꞌtsik abal na Jesús exomich ti ulel ba jachanꞌ an bitsow, ");
INSERT INTO husNT2005_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","in pejaꞌtsik i apachʼ, kale kin bachʼu ani in ulaltsik kawidh enchéꞌ: ―¡Ti ku loꞌóch xoꞌ! ¡Lábtʼajadh xi tál tin bij an Okʼóxláb! ¡Lábtʼajadh nin Pulek Takʼíxal an israelitatsik! ");
INSERT INTO husNT2005_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Na Jesús in elaꞌ jun i chakam burru ani puney tajaꞌ, jelt xan tin ulal an Tʼokat Dhuslab enchéꞌ: ");
INSERT INTO husNT2005_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Yab ki jikʼey, atiklábtsik xi kʼwajíl Sión; ka telaꞌtsik, náꞌich tál na Pulek Takʼíxal punat ba jun i chakam burru. ");
INSERT INTO husNT2005_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Tam ti jachanꞌ i kʼij, nin exóbaliltsik yab in exbay ejtal jechéꞌ, por más tayíl, tam ti na Jesús xalkʼantsatich tin labidh tʼokát, in chalpaytsik tám abal ejtal jechéꞌ kʼwajat dhutsadh ban Tʼokat Dhuslab kʼal tin kwenta na Jesús ani anchanich ti támnék. ");
INSERT INTO husNT2005_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","An atiklábtsik xi taꞌ ti kʼwajat tam ti na Jesús in ejdhaꞌ ti ít na Lásaro ani in utsaꞌ ka kale ban jólimtaláb, in tʼiláltsik xowaꞌ in chuꞌúmal. ");
INSERT INTO husNT2005_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Jaxtám an atiklábtsik ti kale kin bachʼu na Jesús, abal in choꞌóbnámalichtsik an labidh exól xin tʼajámal. ");
INSERT INTO husNT2005_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Por an fariseotsik in ulu jajáꞌkʼitsik enchéꞌ: ―A chuꞌtalichtsik xoꞌ, yab neꞌech ki ejto ki tʼajaꞌ ni jun xataꞌ. Ka telaꞌ, kʼal ejtal an atiklábtsik ti exom ti wéwnáb. ");
INSERT INTO husNT2005_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Kʼal an atiklábtsik xi kʼalnek Jerusalén abal ti ól tam exom an ajib, taꞌ jeye ti kʼwajattsik cháb óx i griego. ");
INSERT INTO husNT2005_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Jechéꞌ an griegotsik utey ba na Felipe. Na Felipe, jaꞌich xu kʼwajíl Betsayda, an chabál xu takʼnal Galilea. Tam ti utukná kʼal an griegotsik, pakabédhá kʼál enchéꞌ: ―Jaꞌúb, i léꞌ weye ki chuꞌu na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Na Felipe kʼale kin utsaꞌ na Andrés ani chablam ti éb ti kʼale kin óltsi na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Utsantsik tám enchéꞌ kʼal na Jesús: ―In bajúch an kʼij xowkʼi Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik, neꞌech kin xalkʼantsat an tu labidh tʼokát. ");
INSERT INTO husNT2005_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Tsubax tu utsáltsik, ke max jun i iyaláb yab ka tʼayan ani yab ka kʼibchon nin tʼuꞌúl, yab jaykʼi neꞌech ka yaney. Por max ka tʼayan ani ka kʼibchon nin tʼuꞌúl, neꞌech ka ixkʼan, neꞌech ka pubey ani neꞌech kin kóꞌoy yán in walíl. ");
INSERT INTO husNT2005_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Xitaꞌ in kʼanidhál nin ejattal neꞌech kin kʼibdhaꞌ; por xitaꞌ xi yab in kʼanidhál nin ejattal techéꞌ ti kʼayꞌlá, in koꞌolich tʼojojodh nin ejattal abal kin bachʼu an xeꞌchintaláb xi yab in koꞌol in okʼontal. ");
INSERT INTO husNT2005_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Max jun xitaꞌ in léꞌ ti kin tʼójontsi, ti kin wéwnaꞌ ani xon ti Nanáꞌ neꞌech kin kʼwajay, tajaꞌ jeye neꞌech ka kʼwajay xitaꞌ tin tʼójontsal. Max jun xitaꞌ ti kin tʼójontsi, neꞌech ka kʼakʼná kʼal nu Tátaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","ʼXoꞌ in chalpax tʼajat tin kʼwajat; por yab neꞌech ku utsaꞌ nu Tátaꞌ ti kin loꞌo kʼal xowaꞌ neꞌech ku tamu, pos jaꞌich tin tsiꞌnek abal ku tamu anchanꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tátaꞌ, ka xalkʼaꞌich na labidh tʼokát. Achʼatmé tám jun i káwintaláb túꞌ walkʼiꞌ ani xu káw in ulu enchéꞌ: ―U xalkʼámalich ani neꞌech juní ku xalkʼaꞌ ti ít. ");
INSERT INTO husNT2005_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","An atiklábtsik xi tajaꞌ ti kʼwajat ani in achʼaꞌ jachanꞌ an káwintaláb, in ulutsik abal i junkil áb u jululúl ani xi kʼeꞌettsik in ulal: ―Tawná kʼal jun i tʼokat abatwále. ");
INSERT INTO husNT2005_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Utsantsik tám enchéꞌ kʼal na Jesús: ―Yab abal Nanáꞌ tu kwenta ti achʼatmé jechéꞌ an káwintaláb, achʼatmé abal tatáꞌtsik ta kwenta. ");
INSERT INTO husNT2005_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Xoꞌ in bajúch an kʼij xowkʼi neꞌech ti lújundháb an atiklábtsik xi techéꞌ ban kʼayꞌlá ani neꞌech ka petʼnájich ban kʼibeltaláb an lej atʼax xi kʼwajat ti takʼix ba jechéꞌ an kʼayꞌlá. ");
INSERT INTO husNT2005_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ani tam Nanáꞌ kin tʼekʼbájich pajkʼidh ban peltsidh teꞌ, neꞌech ku ututsik ejtal kʼal Nanáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Kʼal jechéꞌ kʼwajatich in ólnál xan ti neꞌech ka chemdhá. ");
INSERT INTO husNT2005_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Tókʼoyat enchéꞌ kʼal an atiklábtsik: ―Wawáꞌ i achʼámal ti ajyáb bin takʼixtal na Dios xin jilám dhutsadh na Moisés ke an Kristo yab jaykʼi neꞌech ka chemech. ¿Jantʼókʼi pé tám ta ulal ke nin Chakámil na Dios neꞌech ka tʼekʼbá pajkʼidh ba peltsidh teꞌ? ¿Jitaꞌ pé jeye jachanꞌ xa utsál ke Jajáꞌich xi abadh abal ka wenkʼon jeye ti inik? ");
INSERT INTO husNT2005_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Utsantsik tám enchéꞌ kʼal na Jesús: ―Bél neꞌech kin kʼwajay wéꞌ i kʼij kʼal tatáꞌtsik, Nanáꞌ xin kʼwajat jelti an tajaxtaláb, por yabich neꞌech kin lej owey. Ki uteytsik kʼal Nanáꞌ lejat xoꞌ bél in kʼwajat kʼal tatáꞌtsik abal yab ki yakʼwantsik ukʼpidh kʼal an jikʼwaxtaláb; pos xi xeꞌechtsik ban jikʼwaxtaláb yab in choꞌób xon ti neꞌech. ");
INSERT INTO husNT2005_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ti kin belaꞌtsik lejat xoꞌ bél in kʼwajat kʼal tatáꞌtsik, Nanáꞌ in kʼwajat jelti an tajaxtaláb abal ki kʼwajaytsik jelti an atiklábtsik xi kʼwajat ban tajaxtaláb. Tam ti okʼon kin ulu jechéꞌ, na Jesús kʼale ani in chinkʼontsitsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Maske na Jesús in tʼajámalich tʼajat yán i labidh exóltsik tin tamét an judíotsik, bélkʼi yab u belnal. ");
INSERT INTO husNT2005_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Jechéꞌ támun anchanꞌ abal ka tʼájan jelt xan tin jilámal dhutsadh an tʼiltsix Isaías enchéꞌ: Okʼóxláb, ¿jitaꞌ in belámal xowaꞌ i ólnámal? ¿Jitaꞌ xalkʼantsidh tin cháp an Okʼóxláb? ");
INSERT INTO husNT2005_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Jaxtám ti yab u belnal na Jesús, pos na Isaías in dhutsámal jeye enchéꞌ: ");
INSERT INTO husNT2005_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Jokʼolbédhatstsik kʼal na Dios ani chapikmédhantsidhtsik tin itsích, abal yab ka chuꞌxintsik kʼal nin wal, nibal kin exbaytsik kʼal nin itsích, ani nibal ka uteytsik kʼal Nanáꞌ abal ku jeldhaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Na Isaías in tʼilámal jechéꞌ abal in chuꞌtsámalich tin labidh tʼokát na Jesús ani Jajáꞌ kʼwajat in tʼilál tam tin ulu jechéꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Por bélkʼi, kʼal yán i judíotsik ti belan na Jesús, belan asta kʼal taltsik i awiltalábtsik; por yabtsik in xalkʼál, kom in chʼejnál an fariseotsik ani in chʼejnál yabich ka walkan ka ochichtsik ban atá xon tu tʼajnal an junkuntaláb. ");
INSERT INTO husNT2005_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Pos jajáꞌtsik más in kulbetnál ka kʼakʼná kʼal an atiklábtsik ké kʼal na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Na Jesús in ulu kawidh enchéꞌ: ―Xitaꞌ ti kin belaꞌ Nanáꞌ, yab Nanáꞌ tin belál, in belál an Tátaꞌláb xi tin abámal. ");
INSERT INTO husNT2005_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ani xitaꞌ tin chuꞌtal Nanáꞌ, in chuꞌtalich xitaꞌ tin abámal. ");
INSERT INTO husNT2005_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nanáꞌ, xin kʼwajat jelti an tajaxtaláb, in tsiꞌnek ban kʼayꞌlá abal xitaꞌ ti kin belaꞌ yab ka jilkʼontsik ban jikʼwaxtaláb. ");
INSERT INTO husNT2005_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Por max jun xitaꞌ kin achʼaꞌ xowaꞌ u ulal ani yab kin tʼajaꞌ ti kʼij, yab Nanáꞌ exom u walbiyal; pos yab in tsiꞌnek ku walbiy an atiklábtsik xi kʼwajat ban kʼayꞌlá, in tsiꞌnek abal ku loꞌo. ");
INSERT INTO husNT2005_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Xitaꞌ tin pojkál ani yab in tʼajál ti kʼij xowaꞌ u ulal, in koꞌolich xitaꞌ kʼál ti neꞌech ka walbiyat: xowaꞌ Nanáꞌ u ulúmal, jaꞌich kʼál ti neꞌech ka walbiyat tam kin bajaw an pakwenib. ");
INSERT INTO husNT2005_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Xowaꞌ Nanáꞌ u ulúmal, yab u ulúmal kʼal Nanáꞌkʼi tu kwetém chalab; an Tátaꞌláb xi tin abámal, jaꞌich tin utsámal xowaꞌ neꞌech ku ulu ani xowaꞌ neꞌech ku okʼtsixnaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ani u choꞌób alwaꞌ ke xowaꞌ tin utsámal ku ulu nu Tátaꞌ, jaꞌich abal ka ejtotsik ka kóꞌoy an xeꞌchintaláb xi yab in koꞌol in okʼontal. Jaxtám, xowaꞌ u ulal, u ulal xantikʼi tin utsámal ku ulu an Tátaꞌláb. ");
INSERT INTO husNT2005_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Wéꞌich u kʼibel abal ka ajíbná an paskwa. Na Jesús in choꞌóbich abal in bajúmich an kʼij xowkʼi neꞌech kin jilaꞌich an kʼayꞌlá abal ka kʼaléch ban Tátaꞌláb. Kom echʼekʼi in kʼanidhál an atiklábtsik xi kʼál tu belnal, xoꞌ kʼwajat in xalkʼantsal ke tsubax lejtal tin kʼanidháltsik tʼajat. ");
INSERT INTO husNT2005_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","4","Na Judas Iskariote, xu chakámláb kʼal na Simón, ódhantsidhich bin itsích kʼal an lej atʼax abal kin pidhnaꞌ na Jesús ka chemdhá. Na Jesús in choꞌób alwaꞌ abal ba Dios ti tál ani abal neꞌech juní ka witsích táykʼi ani in choꞌób jeye abal pidhnékich ejtal an ti awiltaláb kʼal an Tátaꞌláb. Jaxtám, tam ti kʼwajattsik an ti kʼapul, chʼakay na Jesús ban mesa, in kʼotʼiy nin eblidh kʼudhkʼumil ani in wikʼaꞌ jun i kʼudhkʼum bin tsukul. ");
INSERT INTO husNT2005_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","In jolo tám i jaꞌ ba jun i balixtaláb ani kʼwajay kin tʼaktsi tin akan nin exóbaliltsik ani kin wayedhantsi kʼal an kʼudhkʼum xin wíkʼím bin tsukul. ");
INSERT INTO husNT2005_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Tam ti neꞌchich jeye ti tʼaktsinal tin akan na Simón Pedro, na Simón Pedro in ulu enchéꞌ: ―Ajátik, ¿Tatáꞌ neꞌech ti kin tʼaktsi tu akan? ");
INSERT INTO husNT2005_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Tókʼoyat enchéꞌ kʼal na Jesús: ―Xoꞌ yab neꞌech ka ejto ka exbay xowaꞌ exom u tʼajál, por tayíl neꞌech ka exbay. ");
INSERT INTO husNT2005_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Por utsan enchéꞌ kʼal na Pedro: ―Nanáꞌ yab jaykʼi neꞌech tu walkaꞌ ti kin tʼaktsi an tu akan. Utsan tám enchéꞌ kʼal na Jesús: ―Max yab tu tʼaktsi an ta akan, yabich neꞌech ka ejto ki kʼwajay kʼal Nanáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Utsan enchéꞌ kʼal na Simón Pedro: ―Ajátik, tám, yab tokotkʼi ti kin tʼaktsi tu akan, ti kin tʼaktsi jeye tu kʼubak ani ti kin pakʼwtsi tu ókʼ. ");
INSERT INTO husNT2005_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Por utsan enchéꞌ kʼal na Jesús: ―Xi tám ti okʼnék ti atsim, yab yejat xowaꞌ más kin tʼakaꞌ, tokot nin akan; pos ejtal kʼwajat tʼokat nin tʼuꞌúl. Tatáꞌtsik i tʼokat ta kʼwajat, maske yab kʼejle ejtal ta éb. ");
INSERT INTO husNT2005_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Na Jesús in ulu: “Yab ejtal ta éb i kʼwajattsik tʼokat”, kom in choꞌóbich xitaꞌ kʼál ti neꞌech ka pidhná abal ka chemdhá. ");
INSERT INTO husNT2005_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Tam ti okʼonich kin tʼaktsi tin akan nin exóbaliltsik, na Jesús in kʼwajbaꞌ juní nin eblidh kʼudhkʼúmil, buxkan juní ban mesa ani in utsaꞌtsik enchéꞌ: ―¿A exbayaltsikxeꞌ xowaꞌ tu tʼajtsi? ");
INSERT INTO husNT2005_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Tatáꞌtsik tin bijyal tin Okʼtsix ani tin Ajátikláb ani tsubax xowaꞌ a ulaltsik, kom aniꞌ kʼejle. ");
INSERT INTO husNT2005_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Pos max Nanáꞌ, xin Okʼtsix ani in Ajátikláb, tu tʼaktsitsik an ta akan, anílkʼi teye ti yejat ki tʼáktsíxintsik an ta akan jún ani jún. ");
INSERT INTO husNT2005_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Nanáꞌ tu pidhaꞌichtsik jun i okʼtsixtaláb abal ka tʼajaꞌtsik teye anílkʼi jelt xan ti Nanáꞌ u tʼajaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Tsubax tu utsáltsik, ke ni jun i tʼójontsix kʼwajat más púlek ké nin ajátik ani ni jun i abatwále kʼwajat más púlek ké xi kʼál ti abadh. ");
INSERT INTO husNT2005_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Max a exbayaltsik ejtal jechéꞌ ani ka tʼajaꞌtsik anchanꞌ, kʼijidh tʼajat neꞌech ki kʼwajaytsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","ʼYab abal ejtal ta éb tin kʼwajat tu utsáltsik jechéꞌ; Nanáꞌ u choꞌób xitaꞌ nu takwyámaltsik. Por koꞌol ka támun jelt xan tin ulal an Tʼokat Dhuslab enchéꞌ: “Xi kʼwajat ti kʼapul junax kʼal Nanáꞌ, tin atʼálich xoꞌ.” ");
INSERT INTO husNT2005_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Tu okxintsaltsik tu óltsi jechéꞌ abal tam ka támun, ka belaꞌtsik ke Nanáꞌich xitam jáꞌ tu utsámaltsik u éy. ");
INSERT INTO husNT2005_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Tsubax tu utsáltsik, ke xitaꞌ kin bachʼu xitaꞌ Nanáꞌ u abámal, Nanáꞌ tin bachʼwal ani xitaꞌ ti kin bachʼu Nanáꞌ, in bachʼwalich xitaꞌ tin abámal. ");
INSERT INTO husNT2005_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Tam ti okʼon kin ulu jechéꞌ, na Jesús in achʼaꞌ jun i pulek yajtsiktaláb tin ejattal ani in ulu enchéꞌ: ―Tsubax tu utsáltsik, ke jún ti éb xi tatáꞌtsik a kidhtal neꞌech ti kin pidhnaꞌ abal kin chemdhá. ");
INSERT INTO husNT2005_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Tujey tám an exóbaltsik ti téláx jún ani jún, maske yab in choꞌóbtsik xitam jáꞌ na kʼwajat ti usnal. ");
INSERT INTO husNT2005_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Jún ti éb an exóbaltsik, xu kʼanidháb tʼajat kʼal na Jesús, kʼwajat jeye ti kʼapul jedhél bin okób na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Na Simón Pedro in utsaꞌ jechéꞌ an exóbal kʼal in kʼubakkʼi abal kin konoy xitam jáꞌ na kʼwajat in tʼilál. ");
INSERT INTO husNT2005_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Utkakan tám más jechéꞌ an exóbal ba na Jesús ani in konoy enchéꞌ: ―Ajátik, ¿jitam jáꞌ xi kʼwajat a tʼilál? ");
INSERT INTO husNT2005_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Tókʼoyat enchéꞌ kʼal na Jesús: ―Neꞌech ku juꞌu jun pejeꞌ i pan ani xitaꞌ ku pidhaꞌ, jaꞌich xi neꞌech ti kin pidhnaꞌ abal kin chemdhá. In juꞌu tám jun pejeꞌ an pan ani in pidhaꞌ na Judas Iskariote, xu chakámláb kʼal na Simón, ");
INSERT INTO husNT2005_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","támkʼi tam ti na Judas in bachʼu an pan, ochich an lej atʼax bin itsích na Judas. Utsan tám enchéꞌ kʼal na Jesús: ―Xowaꞌ neꞌech ka tʼajaꞌ, ka tʼajaꞌ jikʼat. ");
INSERT INTO husNT2005_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Por ni jun xitaꞌ xi taꞌ ti kʼwajat ban mesa ti kʼapul, yab in exbay xantʼókʼi ti utsan anchanꞌ na Judas. ");
INSERT INTO husNT2005_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Kom na Judas jaꞌich nin xeꞌchindhál nin bál an tumín, taltsik in chalpay ke na Jesús kʼwajat in utsál na Judas ke yejat kin chʼaꞌay xataꞌ xowaꞌ neꞌech kin yéntsi abal an ajib, o kin pidhaꞌ wéꞌ ti tolmixtaláb an chʼojontáltsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Tam ti na Judas in kʼapúmalich an pan, kʼale. Tam ti jachanꞌ, jikʼwaxich. ");
INSERT INTO husNT2005_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Tam ti kʼalnekich na Judas, na Jesús in ulu enchéꞌ: ―Xoꞌ exomich ti xalkʼanal nu labidh tʼokát Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik ani nin labidh tʼokát na Dios u xalkʼanalich jeye ba Nanáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ani max Nanáꞌ, xin abadh abal kin wenkʼon neye tin inik, u xalkʼantsal tin labidh tʼokát na Dios, Jajáꞌ neꞌech jeye ti kin xalkʼantsi tu labidh tʼokát kʼunatich i kʼij. ");
INSERT INTO husNT2005_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Tsʼitsik chakam, yabich neꞌech kin kʼwajay nakat i kʼij kʼal tatáꞌtsik. Neꞌech ti kin aliytsik, por xowaꞌ u utsámal an judíotsik, xoꞌ jayéchkʼi teye neꞌech tu utsaꞌtsik: Yab neꞌech ka ejto ki kʼaletsik xon ti Nanáꞌ in neꞌech. ");
INSERT INTO husNT2005_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Neꞌech tu pidhaꞌtsik jun i ít takʼixtaláb: ki kʼánídháxintsik jún ani jún; ki kʼánídháxintsik jelt xan ti Nanáꞌ tu kʼanidhámaltsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Max ki kʼánídháxintsik jún ani jún, ejtal an atiklábtsik neꞌech kin chuꞌu ke Nanáꞌ lejtal tu exóbaliltsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Konyat enchéꞌ na Jesús kʼal na Simón Pedro: ―Ajátik, ¿jónꞌ ta neꞌech? Ani tókʼoyat enchéꞌ kʼal na Jesús: ―Xonti Nanáꞌ in neꞌech, yab xoꞌ neꞌech ka ejto ti kin wéwnaꞌ; por tayíl i neꞌech teye xon ti Nanáꞌ in neꞌech. ");
INSERT INTO husNT2005_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Utsan tám enchéꞌ kʼal na Pedro: ―Ajátik, ¿jantʼókʼi ti yab neꞌech ku ejto tu wéwnaꞌ xoꞌich? Nanáꞌ yab u ajyal tubáꞌ maske kin chemdhá kʼal Tatáꞌ ta kwenta. ");
INSERT INTO husNT2005_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Tókʼoyat enchéꞌ kʼal na Jesús: ―¿Tsubax lejtal yab a ajyal tabáꞌ maske ki chemdhá kʼal Nanáꞌ tu kwenta? Tsubax tu utsál, ke tam yabél dhájnék an pekʼel, tatáꞌ óxílich a ulúmal ke yab tin exlál. ");
INSERT INTO husNT2005_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","ʼYab ki kʼwajaytsik ta chalpax. Ka belaꞌ na Dios ani ti kin belaꞌ neye. ");
INSERT INTO husNT2005_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ba nin kʼimáꞌ nu Tátaꞌ, yán tʼajat waꞌach xon ti ki kʼwajaytsik; max yabak anchanꞌ, tu utsámalichaktsik. Jaxtám, neꞌech kin okxin abal tu tʼojojontsi xon ti neꞌech ki kʼwajaytsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ani tam in kʼalnekich ku tʼojojoy xon ti neꞌech ki kʼwajaytsik, neꞌech kin witsiy tu ikʼiꞌtsik ani tu júnaꞌtsik kʼal Nanáꞌ abal ki kʼwajaytsik teye xon ti Nanáꞌ neꞌech kin kʼwajay. ");
INSERT INTO husNT2005_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","A choꞌóbichtsik xon ti Nanáꞌ in neꞌech ani a choꞌóbichtsik jeye an bél. ");
INSERT INTO husNT2005_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Utsan enchéꞌ kʼal na Tomás: ―Ajátik, yab i choꞌób xon ta neꞌech; ¿jan ti neꞌech ki ejto ki choꞌóbnaꞌ an bél? ");
INSERT INTO husNT2005_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Tókʼoyat enchéꞌ kʼal na Jesús: ―Nanáꞌich nin kʼwajat jelti an bél, Nanáꞌich nin tsubaxtaláb ani Nanáꞌich nu pidhnál an xeꞌchintaláb xi yab in koꞌol in okʼontal. Yab xitaꞌ neꞌech kin ejto ka ulich ban Tátaꞌláb max yab ti kin belaꞌ Nanáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Max tatáꞌtsik ti kin exlaꞌtsik alwaꞌ, neꞌech jeye ka exlaꞌtsik nu Tatáꞌ; ani xoꞌ a exlálichtsik, pos a óntsámalichtsik ka chuꞌu. ");
INSERT INTO husNT2005_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Utsan tám enchéꞌ kʼal na Felipe: ―Ajátik, ti ku xalkʼantsi an ti Tátaꞌláb ani lejat kʼál. ");
INSERT INTO husNT2005_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Tókʼoyat enchéꞌ kʼal na Jesús: ―Felipe, owenekich tʼajat tin kʼwajíl kʼal tatáꞌtsik, ani ¿yabél tin exlál? Xitaꞌ tin chuꞌtal Nanáꞌ, in chuꞌtalich jeye an Tátaꞌláb; tám, ¿jantʼókʼi bél tin kontsal tu xalkʼantsitsik an ti Tátaꞌláb? ");
INSERT INTO husNT2005_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Yabxeꞌ a belál ke Nanáꞌ in kʼwajat kʼal an Tátaꞌláb ani an Tátaꞌláb kʼwajat kʼal Nanáꞌ? Ejtal xowaꞌ tu utsáltsik, yab u ulal kʼal Nanáꞌkʼi tu kwetém chalab. An Tátaꞌláb xi kʼwajat kʼal Nanáꞌ, jaꞌich nin tʼajál nin tʼojlábil. ");
INSERT INTO husNT2005_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ti kin beltsitsik ke Nanáꞌ in kʼwajat kʼal an Tátaꞌláb ani an Tátaꞌláb kʼwajat kʼal Nanáꞌ; max yab a beláltsik ke anchanꞌ, ka belaꞌtsik kʼal xowaꞌ a chuꞌtal u tʼajál. ");
INSERT INTO husNT2005_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Tsubax tu utsáltsik, ke xitaꞌ ti kin belaꞌ, neꞌech jeye kin ejto kin tʼajaꞌ xowaꞌ Nanáꞌ u tʼajál ani neꞌech kin ejto kin tʼajaꞌ xowaꞌ más pakdhaꞌ, pos Nanáꞌ in neꞌech xon ti kʼwajat an Tátaꞌláb. ");
INSERT INTO husNT2005_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ejtal xowaꞌ ka konoytsik kʼal Nanáꞌ tu bij, neꞌech ku tʼajaꞌ, abal Nanáꞌ, xin Chakámláb kʼal na Dios, ku xalkʼantsi tin labidh tʼokát nu Tátaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Neꞌech ku tʼajaꞌ xowaꞌkichkʼi ka konoy kʼal Nanáꞌ tu bij. ");
INSERT INTO husNT2005_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","ʼMax tin kʼanidháltsik, ka tʼajaꞌtsik xowaꞌ tu utsál. ");
INSERT INTO husNT2005_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ani Nanáꞌ neꞌech ku pakabédhaꞌ an Tátaꞌláb ti ki abtsitsik an ti Tʼokat Ejattaláb abal ka kʼwajay echʼekʼi kʼal tatáꞌtsik. An Tʼokat Ejattaláb jaꞌich neꞌech ti ki tolmiytsik ani ti ki pubédantsitsik an ta ejattal. ");
INSERT INTO husNT2005_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Jechéꞌ an Tʼokat Ejattaláb xi tsubax, yab neꞌech kin ejto kin bachʼu xi yabtsik u belom kom yabtsik in chuꞌtal nibal in exlál; por tatáꞌtsik a exlál, kom Jajáꞌ kʼwajat kʼal tatáꞌtsik ani neꞌech ka kʼwajay echʼekʼi kʼal tatáꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Yab neꞌech tu jilaꞌtsik kwetém, neꞌech kin witsiy abal kin kʼwajay kʼal tatáꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Kʼunat i kʼij, yabich neꞌech kin chuꞌtat kʼal an atiklábtsik, por tatáꞌtsik neꞌech ti kin chuꞌu; pos neꞌech ki kʼwajaytsik ejat kom Nanáꞌ in kʼwajat ejat. ");
INSERT INTO husNT2005_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Jachanꞌ i kʼij, neꞌech tám ka exbáchtsik ke Nanáꞌ in kʼwajat kʼal nu Tátaꞌ, tatáꞌtsik i kʼwajat kʼal Nanáꞌ ani Nanáꞌ kʼal tatáꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Xin exlálich ani in tʼajálich xowaꞌ u ulal, in xalkʼálich ke tsubax lejtal tin kʼanidhál. Xitaꞌ tin kʼanidhál, neꞌech jeye ka kʼanidhá kʼal nu Tátaꞌ, Nanáꞌ neꞌech neye ku kʼanidhaꞌ ani neꞌech kin xalkʼan ba jajáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Utsan tám enchéꞌ kʼal na Judas (yab kʼal na Judas Iskariote): ―Ajátik, ¿jantʼókʼi ti neꞌech ka xalkʼaꞌ tabáꞌ ba wawáꞌ ani yab jaꞌ ban atiklábtsik xi yab u belom? ");
INSERT INTO husNT2005_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Tókʼoyat enchéꞌ kʼal na Jesús: ―Xitaꞌ tin kʼanidhál, in tʼajál xowaꞌ Nanáꞌ u ulal. Neꞌech ka kʼanidhá kʼal nu Tátaꞌ ani nu Tátaꞌ ani Nanáꞌ, neꞌech ku tsích abal ku kʼwajay kʼal jajáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Xitaꞌ yab tin kʼanidhál, yab in tʼajál xowaꞌ Nanáꞌ u ulal. Xowaꞌ a achʼáltsik u ulal, yab u ulal kʼal Nanáꞌkʼi tu kwetém chalab, tál bin chalab an Tátaꞌláb xi tin abámal. ");
INSERT INTO husNT2005_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","ʼIn kʼwajat tu utsáltsik ejtal jechéꞌ lejat xoꞌ bél in kʼwajat kʼal tatáꞌtsik; ");
INSERT INTO husNT2005_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","por an Tʼokat Ejattaláb, xi neꞌech ti ki abtsitsik an Tátaꞌláb abal ti ki tolmiytsik ani ti ki pubédhantsitsik an ta ejattal, jaꞌich neꞌech ti ki óltsitsik ejtal ani ti ki chalpantsitsik xowaꞌ tu utsámal. ");
INSERT INTO husNT2005_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","ʼTu jilálichtsik kʼal yantam i kʼijidhtaláb. Tu pidháltsik ti kʼijidhtaláb xu koꞌol, por yab tu pidháltsik an ti kʼijidhtaláb jelt xan tin pidhnál an atiklábtsik. Yab ki kʼwajaytsik ta chalpax nibal ki jikʼey. ");
INSERT INTO husNT2005_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","A achʼámalichtsik tam tu ulu ke Nanáꞌ neꞌech kin kʼale ani ke neꞌech juní kin witsiy abal kin kʼwajay kʼal tatáꞌtsik. Max tin kʼanidhálaktsik, neꞌech ki kulbétsik tʼajat tam ta achʼaꞌ ke Nanáꞌ in neꞌech ban Tátaꞌláb; pos nu Tátaꞌ, más Jaꞌ púlek ké Nanáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Tu óltsalichtsik okʼox jechéꞌ, abal tam ka támun, ka belaꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","ʼYabich neꞌech tin káw yáníl kʼal tatáꞌtsik, pos neꞌech ka ulchich an lej atʼax xu takʼix techéꞌ ti kʼayꞌlá. Maske jajáꞌ u takʼix techéꞌ ti kʼayꞌlá, yab in koꞌol ni jun i awiltaláb abal ti kin takʼiy. ");
INSERT INTO husNT2005_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Anchanꞌ koꞌol ka támun abal kin choꞌóbnaꞌ an atiklábtsik xi techéꞌ ti kʼayꞌlá, ke Nanáꞌ u kʼanidhál an Tátaꞌláb ani tokot u tʼajál xowaꞌ Jajáꞌ tin utsámal ku tʼajaꞌ. Ki chʼakáchtsik ani wanách. ");
INSERT INTO husNT2005_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","ʼNanáꞌich nin kʼwajat jelti nin akan an uba ani nu Tátaꞌ jelti xu belkol. ");
INSERT INTO husNT2005_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ejtal an kʼweꞌlek xi yab u walim, in wékʼoyal; por in kaxwal ani in akʼyal an kʼweꞌlek xu walim abal ka walin más. ");
INSERT INTO husNT2005_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Tatáꞌtsik i kʼwajat jelti max i akʼidhich kʼal an okʼtsixtaláb xi tu pidhámaltsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ki kʼwajaytsik echʼekʼi kʼal Nanáꞌ, jelt xan ti Nanáꞌ in kʼwajat kʼal tatáꞌtsik. Jun i kʼweꞌlek yab neꞌech kin ejto ti walim max yab palat ban akanlek; anchanꞌ teye tatáꞌtsik, yab neꞌech ka ejto ka tʼajaꞌtsik xataꞌ alwaꞌ, max yab i kʼwajattsik kʼal Nanáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","ʼNanáꞌich nin kʼwajat jelti nin akan an uba ani tatáꞌtsik jelti nin kʼweꞌél. Xitaꞌ kʼwajat kʼal Nanáꞌ ani Nanáꞌ kʼal jajáꞌ, neꞌech tʼajat kin tʼajaꞌ xowaꞌ alwaꞌ. Tatáꞌtsik yab xataꞌ neꞌech ka ejto ka tʼajaꞌ xowaꞌ alwaꞌ, max yab i kʼwajat kʼal Nanáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Xitaꞌ yab ka kʼwajay kʼal Nanáꞌ, neꞌech ka petʼná jelti an kʼweꞌlek xi yab u walim, neꞌech ka wayey ani neꞌech ka tsikan. ");
INSERT INTO husNT2005_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","ʼMax ki kʼwajaytsik echʼekʼi kʼal Nanáꞌ ani yab ka ukʼtsitsik xowaꞌ tu okʼtsámaltsik, ka konoytsik xowaꞌ ka leꞌnaꞌ ani neꞌech ki pidhantsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Nu Tátaꞌ in bachʼwalich i kʼakʼnaxtaláb tam tatáꞌtsik a tʼajálich tʼajat xowaꞌ alwaꞌ ani anchanꞌ u xalkʼanalich ke tsubax lejtal tu exóbaliltsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Nanáꞌ tu kʼanidháltsik jelt xan ti an Tátaꞌláb tin kʼanidhál; pos ka óntsitsik ki kʼwajay i kʼán kʼal Nanáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Max ka tʼajáltsik xowaꞌ tu okʼtsámal, neꞌech ka óntsi ki kʼwajaytsik i kʼán kʼal Nanáꞌ, jelt xan ti Nanáꞌ in kʼwajat kʼán kʼal nu Tátaꞌ abal u tʼajál xowaꞌ tin utsál. ");
INSERT INTO husNT2005_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","ʼTu tʼiltsaltsik jechéꞌ abal ka kóꞌoytsik an kʼijidhtaláb jelti xi Nanáꞌ u koꞌol ani anchanꞌ ki kʼwajaytsik más i kulbél. ");
INSERT INTO husNT2005_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","An takʼixtaláb xi Nanáꞌ tu pidháltsik, jaꞌich jechéꞌ: ki kʼánídháxintsik jún ani jún jelt xan ti Nanáꞌ tu kʼanidháltsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","An kʼanidhaxtaláb más púlek xi jun xitaꞌ yejat kin kóꞌoy jaꞌich jechéꞌ: kin pidhnaꞌ tinbáꞌ ka chemdhá abal kin loꞌo nin jaꞌúbtsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Tatáꞌtsik tu jaꞌúb, max ka tʼajaꞌtsik xowaꞌ Nanáꞌ tu utsál. ");
INSERT INTO husNT2005_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Yabich neꞌech tu bijiy tu tʼójontsixiltsik, pos jun i tʼójontsix, yab in choꞌób xantʼéy in tʼajál nin ajátik. Tu bijyaltsik tu jaꞌúb, kom tu pidhámalichtsik ka choꞌóbnaꞌ ejtal xowaꞌ tin utsámal nu Tátaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Yab tatáꞌtsik tin takwyámal Nanáꞌ, Nanáꞌ tu takwyámal tatáꞌtsik. Tu takwyámaltsik abal ka tʼajaꞌtsik tʼajat xowaꞌ alwaꞌ ani ke jachanꞌ xowaꞌ alwaꞌ ka tʼajaꞌ ka kʼwajay echʼekʼi. Anchanꞌ, ejtal xowaꞌ ka kontsi an Tátaꞌláb kʼal Nanáꞌ tu bij, neꞌech ti pidhaꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Jechéꞌ jaꞌich xowaꞌ tu punkʼuntsaltsik ka tʼajaꞌ: ki kʼánídháxintsik jún ani jún. ");
INSERT INTO husNT2005_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","ʼMax ti pojkáltsik xi yabtsik u belom, ka choꞌóbnaꞌtsik ke Nanáꞌ okʼox tin pojkadh. ");
INSERT INTO husNT2005_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Max yabak i belomtsik, an atiklábtsik xi yab u belom, neꞌech ti ki kʼanidhaꞌtsik jelt xan tin kʼanidhál nin kidhtaltsik. Por Nanáꞌ tu takwyámaltsik tam ta kʼwajatwiꞌik kʼal jajáꞌtsik ani jaxtám xoꞌ ti pojkáltsik, kom yabich a kidhtaltsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ka chalpay xantʼéy tu utsámaltsik: “Ni jun i tʼójontsix kʼwajat más púlek ké nin ajátik.” Max Nanáꞌ in atʼnék, neꞌech teye ki atʼantsik ani max in exbantsidh an tu okʼtsixtal, neꞌech teye ki exbantsattsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ejtal jechéꞌ neꞌech ki tʼajtsintsik kʼal Nanáꞌkʼi tu kwenta, kom yab in exláltsik xitaꞌ tin abámal. ");
INSERT INTO husNT2005_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","ʼJajáꞌtsik yabak walbidh, max yabak in tsiꞌnek tu tawnaꞌtsik. Por xoꞌ, yab neꞌech kin ejtotsik kin ulu ke yab walbidh; ");
INSERT INTO husNT2005_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","pos xitaꞌ tin pojkál Nanáꞌ, in pojkálichtsik jeye nu Tátaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Yabak walbidhtsik max Nanáꞌ yabak u tʼajámal xataꞌ ba jajáꞌtsik xowaꞌ yab jaykʼi tʼajadh kʼal ni jun xitaꞌ; por xoꞌ, in chuꞌúmalichtsik ejtal xowaꞌ u tʼajámal ani bélkʼi tin pojkál ani in pojkál jeye nu Tátaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Por jechéꞌ exom ti tʼájnal anchanꞌ abal ka támun jelt xan ti kʼwajat dhutsadh bin takʼixtalábiltsik: “Tin pojkaꞌtsik maske yab xataꞌ tu waltsámaltsik.” ");
INSERT INTO husNT2005_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","ʼPor tam ka ulich an Tʼokat Ejattaláb xi tsubax, xi Nanáꞌ neꞌech ku abnaꞌ, xi neꞌech ti tolmiy ani ti ki likedhantsitsik an ta ejattal, jaꞌich neꞌech ti kin tʼilaꞌ Nanáꞌ. Jechéꞌ an Tʼokat Ejattaláb, tál ban Tátaꞌláb. ");
INSERT INTO husNT2005_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Tatáꞌtsik neꞌech teye ti kin tʼilaꞌtsik, kom i kʼwajinektsik kʼal Nanáꞌ asta tu tuju tin okʼtsix. ");
INSERT INTO husNT2005_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","ʼEjtal jechéꞌ tu tʼiltsaltsik abal yab ka jilaꞌ ti kin belaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Yabich neꞌech ki walkan ki ochichtsik ban atá xon tu tʼajnal an junkuntaláb, asta neꞌech kin bajaw i kʼij, tam jun xitaꞌ ti ki chemdhaꞌ neꞌech kin chalpay ke exom in tʼajál jun xataꞌ alwaꞌ abal a Dios. ");
INSERT INTO husNT2005_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Neꞌech kin tʼajaꞌtsik anchanꞌ, kom yab jaykʼi in exlámaltsik an Tátaꞌláb nibal tin exlámaltsik Nanáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Tu okxintsalichtsik tu utsaꞌ jechéꞌ, abal tam kin bajaw an kʼij, ka chalpaytsik ke tu okʼox utsámalichtsik. ʼJechéꞌ yab tu utsámaltsik okʼox, kom Nanáꞌ bél in kʼwajat kʼal tatáꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Por xoꞌ neꞌech kin kʼaléch abal kin kʼwajay kʼal xi tin abámal ani yab xitaꞌ tin konyal xon tin neꞌech. ");
INSERT INTO husNT2005_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","I tʼeꞌpinichtsik tokot abal tu utsáltsik jechéꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Por tsubax tu utsáltsik ke más alwaꞌ abal tatáꞌtsik kin kʼale. Pos max yab kin kʼale, yab neꞌech ka tsích abal ka kʼwajay kʼal tatáꞌtsik an Tʼokat Ejattaláb xi neꞌech ti ki tolmiytsik ani ti likedhantsitsik an ta ejattal; por max kin kʼale, Nanáꞌ neꞌech ku abaꞌ ka tsích. ");
INSERT INTO husNT2005_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Tam Jajáꞌ ka tsích, neꞌech kin xalkʼantsi an atiklábtsik xi techéꞌ ti kʼayꞌlá ke walbidhtsik, ke waꞌach jun i lujattaláb ani ke neꞌech ka lújundhá an atiklábtsik kʼal na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Neꞌech kin exbaytsik abal walbidh, kom yabtsik tin belaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Neꞌech kin exbaytsik ke waꞌach jun i lujattaláb, kom Nanáꞌ in neꞌech xon ti kʼwajat an Tátaꞌláb ani yabich más neꞌech ti kin chuꞌutsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ani neꞌech kin exbaytsik ke neꞌech ka lújundhátsik kʼal na Dios, kom an lej atʼax, xu takʼix techéꞌ ban kʼayꞌlá, bijtsidhich abal neꞌech ban kʼibeltaláb. ");
INSERT INTO husNT2005_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","ʼU koꞌol yán xantʼéy neꞌech tu utsaꞌtsik, por yab neꞌech ka ejto ka exbaytsik xoꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Por tam ka tsích an Tʼokat Ejattaláb xi tsubax, Jajáꞌ neꞌech ti ki óltsitsik ejtal xowaꞌ tsubax; pos yab neꞌech ti káw kʼal Jajáꞌkʼi tin kwetém chalab, tokot neꞌech kin ulu xowaꞌ ka utsan kʼal na Dios ani neꞌech ti ki óltsitsik ejtal xowaꞌ neꞌech ka támun tayíl. ");
INSERT INTO husNT2005_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Jajáꞌ neꞌech ti kin xalkʼantsi an tu labidh tʼokát, pos ejtal xowaꞌ u koꞌol ani xitam jáꞌ neye Nanáꞌ, jaꞌich neꞌech ti ki óltsitsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ejtal xowaꞌ in koꞌol an Tátaꞌláb u dhabal neye; jaxtám tu ulu ke an Tʼokat Ejattaláb jaꞌich neꞌech ti ki óltsitsik xitam jáꞌ neye Nanáꞌ ani ejtal xowaꞌ u koꞌol. ");
INSERT INTO husNT2005_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","ʼKʼunat i kʼij yabich neꞌech ti kin chuꞌutsik; por más lej wéꞌ tayíl, neꞌech juní ti kin chuꞌutsik, kom Nanáꞌ in neꞌech xon ti kʼwajat an Tátaꞌláb. ");
INSERT INTO husNT2005_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Taltsik nin exóbaliltsik kónóxin tám jajáꞌkʼitsik enchéꞌ: ―¿Jantʼéy in léꞌ kin ulu jechéꞌ? Abal tu utsál ke kʼunat i kʼij yabich neꞌech ki chuꞌu ani ke más tayíl neꞌech juní ki chuꞌu ani ke jaꞌich abal Jajáꞌ neꞌech xon ti kʼwajat an Tátaꞌláb. ");
INSERT INTO husNT2005_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Jantʼéy in léꞌ kin ulu kʼal: “Kʼunat i kʼij?” Yab i exbayal xantʼéy kʼwajat in ulal. ");
INSERT INTO husNT2005_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Na Jesús in chuꞌu abal u leꞌnáb ka konyat jun xataꞌ kʼal nin exóbaliltsik, jaxtám tin utsaꞌtsik enchéꞌ: ―Nanáꞌ tu utsaꞌtsik abal kʼunat i kʼij yabich neꞌech ti kin chuꞌutsik ani más lej wéꞌ tayíl neꞌech juní ti kin chuꞌutsik. ¿Jaꞌich kʼal jechéꞌ tin kwenta ta kʼwajat ta kónóxtsik? ");
INSERT INTO husNT2005_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Tsubax tu utsáltsik, ke neꞌech ki ukʼintsik ani neꞌech ki tʼeꞌpintsik, por an atiklábtsik xi yab tin belál, neꞌech ka kulbétsik. Por maske tatáꞌtsik i kʼwajat i tʼeꞌpinal, an tʼeꞌpintaláb neꞌech ka wenkʼon ti kulbétaláb. ");
INSERT INTO husNT2005_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Tam jun i mímláb neꞌech kin waꞌchiy i chakam, u tʼeꞌpinal abal in bajúch an ora xowkʼi neꞌech kin achʼaꞌ an yajal; por tam kin waꞌchích an chakam, in ukʼtsal an yajal kʼal an kulbétaláb xin achʼál abal in waꞌchích jun i chakam techéꞌ ti kʼayꞌlá. ");
INSERT INTO husNT2005_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Anchanꞌ jeye xoꞌ, tatáꞌtsik i tʼeꞌpinal, por neꞌech juní tu chuꞌutsik. Tam tu chuꞌutsik, neꞌech tám juní ki kulbétsik tʼajat kʼal jun i kulbétaláb xi yab xitaꞌ neꞌech kin ejto ti ki wékʼontsi. ");
INSERT INTO husNT2005_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","ʼJachanꞌ i kʼij, yabich tám neꞌech ti kin konoytsik ni jun xataꞌ. Tsubax tu utsáltsik, ke ejtal xowaꞌ ka kontsi an Tátaꞌláb kʼal Nanáꞌ tu bij, neꞌech ti ki pidhaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Asta xoꞌ, yab xataꞌ a konyámaltsik kʼal Nanáꞌ tu bij; ka konoytsik ani neꞌech ki pidhan abal ki kulbétsik echʼekʼi. ");
INSERT INTO husNT2005_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","ʼEjtal jechéꞌ tu tʼiltsaltsik kʼal i junbaxtalábkʼi; por neꞌech kin bajaw an kʼij tam yabich neꞌech tu tʼiltsitsik xataꞌ kʼal i junbaxtalábkʼi. Tam kin bajaw jachanꞌ an kʼij, neꞌech tám tu xalkʼantsíchtsik tejwaꞌ ejtal kʼal tin kwenta an Tátaꞌláb. ");
INSERT INTO husNT2005_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Tam jachanꞌ i kʼij, neꞌech ka kontsitsik xataꞌ an Tátaꞌláb kʼal Nanáꞌ tu bij ani yab exom u ulal ke Nanáꞌ neꞌech ku pakabédhaꞌ an Tátaꞌláb kʼal tatáꞌtsik ta kwenta, ");
INSERT INTO husNT2005_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","pos an Tátaꞌláb ti kʼanidháltsik. Ti kʼanidháltsik, kom tatáꞌtsik tin kʼanidhál ani a belámalichtsik abal ba Dios tin tál. ");
INSERT INTO husNT2005_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","In kale xon ti kʼwajat an Tátaꞌláb ani in tsích ba jechéꞌ an kʼayꞌlá, por xoꞌ, neꞌech ku jilaꞌich juní an kʼayꞌlá ani neꞌech kin witsích xon ti kʼwajat an Tátaꞌláb. ");
INSERT INTO husNT2005_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Utsan tám enchéꞌ kʼal nin exóbaliltsik: ―Xoꞌ tajaxich exom ta káw ani yabich a éynál i junbaxtaláb. ");
INSERT INTO husNT2005_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Xoꞌ i exbách abal a choꞌób ejtal xowaꞌkich ani yab yejat ki konoy xataꞌ ni jun xitaꞌ. Jaxtám ti belál ke ba Dios ta tál. ");
INSERT INTO husNT2005_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Tókʼoyattsik tám enchéꞌ kʼal na Jesús: ―¿Tám, tin belálichtsik xoꞌ? ");
INSERT INTO husNT2005_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Pos, neꞌech kin bajaw an kʼij ani jaꞌich xoꞌich, tam neꞌech ki bukʼeytsik túkʼi túkʼi xontikʼi ka chalpaytsik ki kʼale ani neꞌech ti kin jilaꞌtsik kwetém. Por yab kwetém tin kʼwajat, kom an Tátaꞌláb kʼwajat kʼal Nanáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Tu utsáltsik jechéꞌ abal ki kʼwajaytsik kʼijidh kʼal tin kwenta abal i kʼwajattsik kʼal Nanáꞌ. Neꞌech tʼajat ka watʼnaꞌtsik i yajtsiktaláb techéꞌ ti kʼayꞌlá; por yab ka jilaꞌtsik tabáꞌ, pos Nanáꞌ u átámalich xowaꞌ yab alwaꞌ xi waꞌach ban kʼayꞌlá. ");
INSERT INTO husNT2005_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Tam ti na Jesús okʼon kin ulu ejtal jechéꞌ, in teloloy walkʼiꞌ ani in ulu enchéꞌ: ―Tátaꞌ, in bajúch an kʼij. Ti kin xalkʼantsích an tu labidh tʼokát, abal Nanáꞌ, xin Chakámláb kʼal Tatáꞌ, tu xalkʼantsích teye an ta labidh tʼokát. ");
INSERT INTO husNT2005_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Pos, Tatáꞌ tin pidhámal ti awiltaláb abal ku takʼiy an atiklábtsik ani abal ku pidhaꞌtsik jeye ti xeꞌchintaláb xi yab in koꞌol in okʼontal, ejtaltsik xi Tatáꞌ tin pidhámal. ");
INSERT INTO husNT2005_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Neꞌech kin bachʼutsik an xeꞌchintaláb xi yab in koꞌol in okʼontal max ti ki exlaꞌich Tatáꞌ xi junkax Dios xi tsubax ani Nanáꞌ, xi Tatáꞌ tin abámal. ");
INSERT INTO husNT2005_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","ʼNanáꞌ tu xalkʼantsámalich an ta labidh tʼokát techéꞌ ti kʼayꞌlá ani u okʼyámalich ku tʼajaꞌ xowaꞌ tin abámal ku tʼajaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Tátaꞌ, ti kin xalkʼantsích xoꞌ ta tamét an tu labidh tʼokát, kʼal jayéchkʼi an labidh tʼokattaláb xu koꞌol kʼal Tatáꞌ asta tam ti yabél tʼajadh an walkʼiꞌ ani an chabál. ");
INSERT INTO husNT2005_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","ʼXi Tatáꞌ a takwyámaltsik ti kʼayꞌlá abal ti kin pidhaꞌ, u xalkʼantsámalich xitam jáꞌ teye Tatáꞌ. Tatáꞌ a dhabaltsik ani tin pidhaꞌ ani in exbayámalichtsik na káwintal. ");
INSERT INTO husNT2005_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Xoꞌ in choꞌóbichtsik abal ejtal xowaꞌ tin pidhámal, ba Tatáꞌ ti tál; ");
INSERT INTO husNT2005_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","pos u utsámalichtsik xowaꞌ Tatáꞌ tin utsámal ani in exbayámalichtsik. In choꞌóbnámalichtsik ke tsubax lejtal ba Tatáꞌ tin tál ani in belámalichtsik ke Tatáꞌ tin abámal. ");
INSERT INTO husNT2005_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","ʼTu pakabédhál abal ka pidhaꞌtsik ta alwaꞌtal, yab tu pakabédhál abal tin alwaꞌbíl xi yabtsik u belom, tu pakabédhál abal tin alwaꞌbíl xi Tatáꞌ tin pidhámaltsik, kom Tatáꞌ a dhabaltsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ejtal xowaꞌ Nanáꞌ u dhabal, a dhabal teye ani xowaꞌ Tatáꞌ a dhabal u dhabal neye ani nu labidh tʼokát u xalkʼanal ba jajáꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","ʼNanáꞌ yabich más neꞌech kin kʼwajay ban kʼayꞌlá, por jajáꞌtsik neꞌech ka jilkʼon ban kʼayꞌlá, Nanáꞌ neꞌech kin kʼaléch abal kin kʼwajay kʼal Tatáꞌ. Tʼokat Tátaꞌ, ka beletnaꞌtsik kʼal na awiltal xitaꞌ tin pidhámal abal ka kʼwajaytsik juniniꞌ, jelti Tatáꞌ kʼal Nanáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Tam tin kʼwajat kʼal jajáꞌtsik ban kʼayꞌlá, u beletnámal kʼal na awiltal, ejtaltsik xi Tatáꞌ tin pidhámal. Xitaꞌ Tatáꞌ tin pidhámal, ni jun xitaꞌ yab kʼibchonék, tokot xi kʼejle kʼibchonékich ti kʼwajat, abal ka támun jelt xan ti kʼwajat dhutsadh ban Tʼokat Dhuslab. ");
INSERT INTO husNT2005_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","ʼXoꞌ in neꞌchich xon ti Tatáꞌ i kʼwajat; por u ulal jechéꞌ, lejat bél in kʼwajat ban kʼayꞌlá abal ka kulbétsik echʼekʼi jelt xan ti Nanáꞌ in kulbél. ");
INSERT INTO husNT2005_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","U óltsámalichtsik an ta káwintal, por atʼantsik kʼal an atiklábtsik xi yab u belom, kom yabich techéꞌ u takʼnaltsik ban kʼayꞌlá, jelt xan ti Nanáꞌ yab techéꞌ in takʼnal ban kʼayꞌlá. ");
INSERT INTO husNT2005_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Yab tu kontsal abal ka wékʼoytsik ban kʼayꞌlá, tu kontsal abal yab ka walkaꞌ ka átátsik kʼal an lej atʼax. ");
INSERT INTO husNT2005_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Anchanꞌ jelti Nanáꞌ yab in takʼnal ban kʼayꞌlá, jajáꞌtsik yab jeye u takʼnal ban kʼayꞌlá. ");
INSERT INTO husNT2005_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ka tʼokotsik kʼal na tsubaxtalábil; na káwintal, jaꞌich an tsubaxtaláb. ");
INSERT INTO husNT2005_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Jelt xan ti Tatáꞌ tin abaꞌ ban atiklábtsik xi yab u belom, anchanꞌ neye xoꞌ tu abáltsik ban atiklábtsik xi yab u belom. ");
INSERT INTO husNT2005_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ani kʼal jajáꞌkʼitsik tin kwenta ti neꞌech ku pidhnaꞌ tubáꞌ kin chemdhá abal jajáꞌtsik, kin pidhnaꞌ jeye tinbáꞌ kin tʼilaꞌ an tsubaxtaláb. ");
INSERT INTO husNT2005_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","ʼPor yab exom tu pakabédhál abal jajáꞌkʼitsik ka pidhaꞌ an ta alwaꞌtal, tu pakabédhál jeye kʼal tin kwenta xi neꞌechtsik ti kin belaꞌ tayíl, tam kin achʼaꞌtsik an tsubaxtaláb xi neꞌech ka tʼiltsintsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Tu kontsal abal ka kʼwajaytsik echʼekʼi juniniꞌ. Tátaꞌ, ka kʼwajaytsik juniniꞌ kʼal wawáꞌ, anchanꞌ jelti Tatáꞌ i kʼwajat kʼal Nanáꞌ ani Nanáꞌ in kʼwajat kʼal Tatáꞌ. Ka kʼwajaytsik echʼekʼi juniniꞌ abal an atiklábtsik xi yab u belom, kin belaꞌtsik ke Tatáꞌ tin abámal. ");
INSERT INTO husNT2005_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","U pidhámalichtsik an ti labidh tʼokattaláb xi Tatáꞌ tin pidhámal abal ka kʼwajaytsik juniniꞌ, anchanꞌ jelti Tatáꞌ ani Nanáꞌ u kʼwajat juniniꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Nanáꞌ kin kʼwajay juniniꞌ kʼal jajáꞌtsik ani Tatáꞌ kʼal Nanáꞌ abal ka kʼwajaytsik in tsubtalkʼi lejtal juniniꞌ. Anchanꞌ, neꞌech tám kin exbay an atiklábtsik xi yab u belom, ke Tatáꞌ tin abámal ani ke a kʼanidháltsik tʼajat jelt xan ti Nanáꞌ tin kʼanidhál. ");
INSERT INTO husNT2005_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","ʼTátaꞌ, xitaꞌ tin pidhámaltsik, u léꞌ ka kʼwajay xon ti Nanáꞌ neꞌech kin kʼwajay abal kin chuꞌutsik an labidh tʼokattaláb xi Tatáꞌ tin pidhámal; pos kʼejle tin kʼanidhál asta tam ti yabél tʼajadh an walkʼiꞌ ani an chabál. ");
INSERT INTO husNT2005_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Tátaꞌ, xa tʼajál tokot xowaꞌ lujat; xi yabtsik u belom, yab ti exlál, por Nanáꞌ tu exlál ani jechéꞌtsik xitaꞌ tin pidhámal, in choꞌóbichtsik ke Tatáꞌ tin abámal. ");
INSERT INTO husNT2005_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","U óltsámalichtsik xitam jáꞌ teye Tatáꞌ ani neꞌech ku óntsi ku ólnaꞌ abal an kʼanidhaxtaláb xi Tatáꞌ tin kóꞌontsal, kin kóꞌoytsik jeye ani Nanáꞌ kin kʼwajay echʼekʼi kʼal jajáꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Tam ti okʼonich kin ulu ejtal jechéꞌ, kale na Jesús kʼal nin exóbaliltsik abal ka kʼale jun jekʼat jól xu bijyáb Sedrón. Tajaꞌ, taꞌ ti kʼwajat jun i aleláb ani ochich tajaꞌ na Jesús kʼal nin exóbaliltsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Na Judas, xi kʼál ti neꞌech ka pidhná na Jesús abal ka chemdhá, in exlál jeye alwaꞌ jachanꞌ an aleláb, pos yáníl tʼajat junkunék tajaꞌ na Jesús kʼal nin exóbaliltsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Na Judas ulich tajaꞌ kʼal yán i soldadotsik ani kʼal xu belkoltsik an ti pulek atá xon tu kʼakʼnáb na Dios. Jechéꞌ an belkoltsik, u takʼnal kʼal an okʼlek páleꞌtsik ani kʼal an fariseotsik. In júnámaltsik i machét ani i tajbaxtaláb. ");
INSERT INTO husNT2005_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Por kom na Jesús in choꞌóbich xantʼéy neꞌech kin tamu, utey xon ti kʼwajattsik ani in konoy enchéꞌ: ―¿Jitaꞌ a ayaltsik? ");
INSERT INTO husNT2005_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Tókʼoyat enchéꞌ: ―A Jesús xi Nasaret. Utsantsik enchéꞌ kʼal na Jesús: ―Nanáꞌich xitaꞌ na ayaltsik. Na Judas, xi kʼál ti exom ti pidhnáb na Jesús abal ka chemdhá, taꞌ jeye ti kʼwajat kʼal an yákʼwaltsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Tam ti utsantsik kʼal na Jesús: “Nanáꞌich xitaꞌ na ayaltsik”, kuxkuláchtsik ani kwajlan. ");
INSERT INTO husNT2005_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Konyattsik juní enchéꞌ kʼal na Jesús: ―¿Jitaꞌ a ayaltsik? Tókʼontsik enchéꞌ: ―A Jesús xi Nasaret. ");
INSERT INTO husNT2005_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Utsantsik tám enchéꞌ kʼal na Jesús: ―Tu utsámalichtsik ke Nanáꞌich xitaꞌ na ayal. Max Nanáꞌ tin ayaltsik, ka walkaꞌ ka kʼale xi jechéꞌtsik kʼwajat kʼal Nanáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Jechéꞌ támun anchanꞌ abal ka tʼájan jelt xan tin ulúmal na Jesús enchéꞌ: “Xitaꞌ Tatáꞌ tin pidhaꞌ, yab kʼibchon ni jún.” ");
INSERT INTO husNT2005_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Támkʼi jachanꞌ, na Simón Pedro xi taꞌ tin koꞌol jun i machét, in jixónaꞌ ani in patíntsi tin eját xuchun jún ti éb an yákʼwal xin bij ta Malko. Jechéꞌ na Malko, jaꞌich jún ti éb nin tʼójnálil an okʼlek páleꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Por na Jesús in utsaꞌ enchéꞌ na Pedro: ―Ka taꞌpaꞌ an machét. Max an Tátaꞌláb in léꞌ kin chuꞌu ku watʼnaꞌ jechéꞌ an yajtsiktaláb, ¿awxeꞌ yab yejat ku watʼnaꞌ? ");
INSERT INTO husNT2005_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","An soldadotsik kʼál nin okʼlékil ani an yákʼwaltsik xu takʼnal kʼal an judíotsik, in yakʼwaꞌ na Jesús ani in wikʼaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Júná tám okʼox na Jesús bin kʼimáꞌ na Anás. Jechéꞌ na Anás jaꞌich nin payꞌlóm na Kayfás, xi kʼwajat ti okʼlek páleꞌ jachanꞌ i tamub. ");
INSERT INTO husNT2005_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Na Kayfás, jaꞌich xin utsámal an judíotsik ke más alwaꞌ abal jajáꞌtsik, ke jún tokot i inik ka chemech abal tin alwaꞌbíl an atiklábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Na Simón Pedro ani jún jeye an exóbal in wéwnaꞌtsik na Jesús. Na jún an exóbal, in exlowál an okʼlek páleꞌ, jaxtám tin ejto ka ochich junax kʼal na Jesús bin elébil nin kʼimáꞌ an okʼlek páleꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Por na Pedro, jilkʼon eléb ban wiꞌleb. Jaxtám, kale an exóbal xin exlowál an okʼlek páleꞌ, káwin kʼal an mímláb xu belkol wiꞌleb ani in ódhaꞌ jeye na Pedro. ");
INSERT INTO husNT2005_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Konyat tám enchéꞌ na Pedro kʼal an mímláb xu belkol wiꞌleb: ―¿Yabxeꞌ jaꞌich teye jún ti éb nin exóbaliltsik na Jesús? Tókʼon enchéꞌ na Pedro: ―Yabaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Kom chamay tam ti jachanꞌ i kʼij, an tʼójontsixtsik ani an yákʼwaltsik in jokʼpámal i kʼamal ani tajaꞌ ti kubutsik ti dhilal. Na Pedro tajaꞌ jeye ti kʼwajat kʼal jajáꞌtsik ti dhilal bin wál an kʼamal. ");
INSERT INTO husNT2005_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Konyat na Jesús kʼal a okʼlek páleꞌtsik xantʼéy in okʼtsixnál ani xitam jáꞌ nin exóbaliltsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Tókʼoyat enchéꞌ kʼal na Jesús: ―Nanáꞌ echʼekʼi in kʼwajinek tin káw tin tamét an atiklábtsik. Echʼekʼi in kʼwajinek tin okʼtsix ban pulek atá xon tu tʼajnal an junkuntaláb ani ban pulek atá xon tu kʼakʼnáb na Dios, xon tu junkunal ejtal an judíotsik ani yab u ulúmal ni jun xataꞌ chinat. ");
INSERT INTO husNT2005_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Jantʼókʼi tin konyal Nanáꞌ? Ka konoytsik xantʼéy u okʼtsámal xitaꞌ tin achʼámal tin okʼtsix, jajáꞌtsik in choꞌób xantʼéy u okʼtsámal. ");
INSERT INTO husNT2005_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Tam ti na Jesús in ulu jechéꞌ, chaꞌwat bin wal kʼal jún ti éb an yákʼwaltsik xi tajaꞌ jeye ti kʼwajat ani utsan enchéꞌ: ―¿Anchanꞌ ta tókʼoyal an okʼlek páleꞌtsik? ");
INSERT INTO husNT2005_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Tókʼoyat enchéꞌ kʼal na Jesús: ―Max u ulu jun xataꞌ yab alwaꞌ, ka ulu xowaꞌ yab alwaꞌ u ulu; por max alwaꞌ xowaꞌ u ulu, ¿jantʼókʼi tin chaꞌwal? ");
INSERT INTO husNT2005_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Na Anás in abnaꞌ tám wikʼats na Jesús ba na Kayfás, nin okʼlékil an páleꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Tam ti jachanꞌ, na Pedro taꞌ ti kubat ti dhilal ani utsan enchéꞌ: ―¿Yabxeꞌ jaꞌich teye jún ti éb nin exóbaliltsik na Jesús? Na Pedro in ulu enchéꞌ: ―Yabaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Konyat tám enchéꞌ kʼal jún ti éb nin tʼojnálil an okʼlek páleꞌtsik, nin exlowál an inik xi kotsidh tin xuchun kʼal na Pedro: ―¿Yabxeꞌ tatáꞌ xitaꞌ xu chuꞌúmal ba jachanꞌ an chakam aleláb junax kʼal Jajáꞌ? ");
INSERT INTO husNT2005_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Na Pedro in ulu juní ke yab aniꞌ ani támkʼi jachanꞌ, dhájan an pekʼel. ");
INSERT INTO husNT2005_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Káldhá tám na Jesús bin kʼimáꞌ na Kayfás ani júná ban atá xon tu lújundhom an pulek awiltaláb. Tam ti jachanꞌ, exomich ti tsudhél ani an judíotsik yab ochich ba jachanꞌ an atá abal yab ka walbintsik, pos max ka walbintsik, yab tám neꞌech kin ejto kin kʼaputsik an kʼapnél kʼal tin kwenta an paskwa. ");
INSERT INTO husNT2005_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Jaxtám ti kale na Pilato ani in utsaꞌtsik enchéꞌ: ―¿Jantʼom walastaláb in tʼajámal jechéꞌ an inik abal a utsbiyaltsik? ");
INSERT INTO husNT2005_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Jajáꞌtsik tókʼon enchéꞌ: ―Max Jajáꞌ yabak jaꞌich jun i walablom, yab neꞌech ki tsiꞌdhaꞌ techéꞌ ta tamét. ");
INSERT INTO husNT2005_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Utsantsik tám enchéꞌ kʼal na Pilato: ―Ka júnaꞌichtsik ani ka lújundhaꞌich xan tin ulal an takʼixtaláb xi tatáꞌtsik a exlál. Tókʼoyat enchéꞌ kʼal an judíotsik: ―Wawáꞌ yab i koꞌol i awiltaláb abal ki chemdhaꞌ ni jun xitaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Anchanꞌ ti támun abal ka tʼájan jelt xan tin ulúmal na Jesús, tam ti kʼwajat in tʼilál xan ti neꞌech ka chemdhá. ");
INSERT INTO husNT2005_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ochich tám juní na Pilato ban atá xon tu lújundhom, in kaniy na Jesús ani in konoy enchéꞌ: ―¿Tatáꞌxeꞌ nin Pulek Takʼíxal an judíotsik? ");
INSERT INTO husNT2005_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Tókʼoyat enchéꞌ kʼal na Jesús: ―¿Tin konyal jechéꞌ kʼal Tatáꞌkʼi ta kwetém chalab o abal i tʼiltsinékkʼi kʼal kʼeꞌettsik? ");
INSERT INTO husNT2005_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Tókʼoyat enchéꞌ kʼal na Pilato: ―¿A chuꞌtalxeꞌ ke nanáꞌ in judío neye? Na kidhtaltsik ani an okʼlek páleꞌtsik, jaꞌich ti tsiꞌdhámaltsik techéꞌ tu tamét. ¿Jantʼéy a tʼajámal? ");
INSERT INTO husNT2005_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Tókʼoyat enchéꞌ kʼal na Jesús: ―Nanáꞌ yab techéꞌ in takʼix ban kʼayꞌlá. Pos max anchanak, an atiklábtsik xi tin wéwnál, péjéxnékak abal yab kin pidhná ban judíotsik. Por Nanáꞌ yab techéꞌ in takʼix ban kʼayꞌlá. ");
INSERT INTO husNT2005_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Konyat tám enchéꞌ kʼal na Pilato: ―Tám, ¿Tatáꞌ i Pulek Takʼix? Tókʼoyat enchéꞌ kʼal na Jesús: ―Nanáꞌ in Pulek Takʼix, jelt xan ti tatáꞌ a ulal. Nanáꞌ in waꞌchinék ani in tsiꞌnek ban kʼayꞌlá abal ku tʼilaꞌ xowaꞌ tsubax. Ejtal xitaꞌ kin exbay an tsubaxtaláb, in achʼáltsik xowaꞌ u ulal. ");
INSERT INTO husNT2005_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Konyat enchéꞌ kʼal na Pilato: ―¿Ani jantʼéy in éy an tsubaxtaláb? Tam ti na Pilato in ulu jechéꞌ, kale juní ti káw kʼal an judíotsik ani in utsaꞌtsik enchéꞌ: ―Nanáꞌ yab u eltsal ni jún tin walab jechéꞌ an inik. ");
INSERT INTO husNT2005_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Por tatáꞌtsik a ujnámalich ke nanáꞌ ku walkaꞌ jun i wikʼnél tam u ajíbnáb an paskwa; ¿a léꞌxeꞌ ka chuꞌutsik ku walkaꞌ nin Pulek Takʼíxal an judíotsik? ");
INSERT INTO husNT2005_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Tujeytsik tám juní kin ulutsik kawidh enchéꞌ: ―¡Jachanꞌ yabaꞌ! ¡Ka walkaꞌ na Barrabás! Jechéꞌ na Barrabás, jaꞌich jun i kwéꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Na Pilato in abnaꞌ tám ka lekbayat na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","An soldadotsik in tʼajaꞌ jun i kwetsotsól dhipadh kʼídh, in kʼwajbantsi bin ókʼ na Jesús ani in xeketliy kʼal jun i kʼudhkʼum xi tʼunuyich tʼajat kʼal in chákníꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","U uteltsik tám ba na Jesús ani in utsáltsik enchéꞌ: ―¡Ki kʼwajay kʼijidh, Pulek Takʼíxal an judíotsik! Ani in chaꞌwaltsik bin wal. ");
INSERT INTO husNT2005_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Kale tám juní na Pilato ani in utsaꞌ enchéꞌ an atiklábtsik: ―Ka telaꞌtsik, u káldhál abal ka chuꞌutsik ke yab u eltsal ni jun i walastaláb. ");
INSERT INTO husNT2005_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Kale tám na Jesús in kojám an kwetsotsól dhipadh kʼídh ani xeketlidh kʼal an chak kʼudhkʼum. Utsantsik tám enchéꞌ kʼal na Pilato: ―¡Jéꞌ kʼwajat an inik! ");
INSERT INTO husNT2005_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Tam ti chuꞌtat na Jesús kʼal an okʼlek páleꞌtsik ani kʼal xu belkoltsik an ti pulek atá xon tu kʼakʼnáb na Dios, in ulutsik kawidh enchéꞌ: ―¡Ka chemdhaꞌ pajkʼidh ban peltsidh teꞌ! ¡Ka chemdhaꞌ pajkʼidh ban peltsidh teꞌ! Utsantsik tám enchéꞌ kʼal na Pilato: ―Ka júnaꞌichtsik ani ka chemdhaꞌich pajkʼidh ban peltsidh teꞌ, nanáꞌ yab u eltsal ni jun in walab. ");
INSERT INTO husNT2005_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Tókʼoyat enchéꞌ kʼal an judíotsik: ―Wawáꞌ i koꞌol jun i takʼixtaláb ani jechéꞌ an takʼixtaláb in ulal ke yejat ka chemdhá, abal in ulal ke u Chakámláb kʼal a Dios. ");
INSERT INTO husNT2005_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Tam ti na Pilato in achʼaꞌ jechéꞌ, más jikʼéch. ");
INSERT INTO husNT2005_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ochich tám juní ban atá xon tu lújundhom ani in konoy enchéꞌ na Jesús: ―¿Jónꞌ pé teye ta tál? Por yab tókʼoyat kʼal na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Utsan tám enchéꞌ kʼal na Pilato: ―¿Yab neꞌech ti kin tókʼoy? ¿Yabxeꞌ a choꞌób ke nanáꞌ u koꞌol i awiltaláb ku ulu ki chemdhá pajkʼidh ban peltsidh teꞌ o ku ulu ki walká? ");
INSERT INTO husNT2005_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Tókʼoyat enchéꞌ kʼal na Jesús: ―Yab neꞌech ka ejto ka kóꞌoy ni jun i awiltaláb kʼal Nanáꞌ, max na Dios yabak ti pidhámal; jaxtám, xitaꞌ tin pidhnaꞌ kʼal tatáꞌ, más jaꞌ walbidh ké tatáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Asta tam ti tám, na Pilato in ayal xan ti kin uwaꞌ abal kin ejto kin walkaꞌ na Jesús; por utsan kawidh enchéꞌ kʼal an judíotsik: ―¡Max ka walkaꞌ, yab a jaꞌúb an lej pulek takʼix romano! ¡Ejtal xitaꞌ ka wenkʼon ti pulek takʼix, in tomnálich an lej pulek takʼix romano! ");
INSERT INTO husNT2005_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Tam ti na Pilato in achʼaꞌ jechéꞌ, in ulu abal ka káldhá na Jesús ani buxkan xon tu lújundhom. An koytaláb xon ti buxkan, ti káwintaláb ebreo, u bijyáb Gabata; jechéꞌ in léꞌ kin ulu, Tʼujbidh. ");
INSERT INTO husNT2005_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Tam ti jachanꞌ, júnich a kʼítsá u kʼibel abal kin bajaw an ajib xu bijyáb paskwa ani chʼejel kʼítsájich xónaꞌ. Na Pilato in utsaꞌ tám enchéꞌ an judíotsik: ―¡Jéꞌ kʼwajat na Pulek Takʼíxaltsik! ");
INSERT INTO husNT2005_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Por jajáꞌtsik in ulu kawidh enchéꞌ: ―¡Ka chemdhaꞌ! ¡Ka chemdhaꞌ! ¡Ka chemdhaꞌ pajkʼidh ban peltsidh teꞌ! Konyattsik enchéꞌ kʼal na Pilato: ―¿Ku chemdhaꞌ pajkʼidh ban peltsidh teꞌ na Pulek Takʼíxaltsik? Tókʼoyat enchéꞌ kʼal an okʼlek páleꞌtsik: ―Wawáꞌ yab i koꞌol más i pulek takʼíxal, tokot an lej pulek takʼix romano. ");
INSERT INTO husNT2005_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Pidhanichtsik tám an ta Jesús kʼal na Pilato abal kin júnaꞌtsik kin chemdhaꞌ pajkʼidh ban peltsidh teꞌ. In bachʼutsik tám na Jesús ani in júnaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Káldhájich tám na Jesús in okbám an peltsidh teꞌ abal ka kʼale ban chabál xu bijyáb “In beklék in ókʼ i chemélom inik”, (ti káwintaláb ebreo, in léꞌ kin ulu Gólgota). ");
INSERT INTO husNT2005_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Tam ti ulich ban chabál xin bij Gólgota, pajkʼiyat ban peltsidh teꞌ. Junax kʼal Jajáꞌ, pajkʼiyat jeye cháb i iniktsik, jún tin eját ani jún tin kʼwatab. ");
INSERT INTO husNT2005_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Na Pilato in abnaꞌ ka kʼwajbá bin ókʼ an peltsidh teꞌ, jun i dhuslab xon ti kʼwajat dhutsadh enchéꞌ: “Na Jesús xi Nasaret, nin Pulek Takʼíxal an judíotsik.” ");
INSERT INTO husNT2005_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Yán i judíotsik in ajay jachanꞌ an dhuslab kom an chabál xon ti pajkʼiyat na Jesús ban peltsidh teꞌ, kʼunat ti kʼwajat ban bitsow. An dhuslab kʼwajat dhutsadh ebreo, griego ani latín. ");
INSERT INTO husNT2005_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Jaxtám ti utsan enchéꞌ na Pilato kʼal nin okʼlek páleꞌil an judíotsik: ―Yab ka dhutsaꞌ: “nin Pulek Takʼíxal an judíotsik”, más alwaꞌ ka dhutsaꞌ enchéꞌ: “Xin ulal ke Jajáꞌ in Pulek Takʼíxal an judíotsik.” ");
INSERT INTO husNT2005_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Por tókʼoyattsik enchéꞌ kʼal na Pilato: ―Xowaꞌ u dhutsaꞌ, anchanich neꞌech ka jilkʼon. ");
INSERT INTO husNT2005_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Tam ti an soldadotsik in pajkʼiyámalich na Jesús ban peltsidh teꞌ, in pentsi an tin kʼudhkʼúmil na Jesús ani in muꞌu ti chéꞌ i pejeꞌ, juntsik pejeꞌ abal jun i soldado. In pentsi jeye an tin eblidh kʼudhkʼumil ani kom yab jaꞌ tsukudhkʼi, juntʼakʼi jaꞌ tin pubíl ti kʼwajat, ");
INSERT INTO husNT2005_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","útsáxin an soldadotsik jún ani jún enchéꞌ: ―Yab ki muꞌu, wana ku ubátʼin abal ki chuꞌu xitaꞌ kin lujuy kin dhabalnaꞌ. Anchanꞌ ti támun jelt xan tin ulal an Tʼokat Dhuslab enchéꞌ: “In wélchíxnaꞌtsik nu kʼudhkʼúmil ani ubátʼintsik abal kin chuꞌu xitaꞌ kin lujuy kin dhabalnaꞌ nu eblidh kʼudhkʼumil.” Jechéꞌ jaꞌich xowaꞌ in tʼajaꞌ an soldadotsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Kʼunat ban peltsidh teꞌ xon ti kʼwajat pajkʼidh na Jesús, taꞌ ti kʼwajat nin nánaꞌ ani nin kidháb nin nánaꞌ; na María, nin tomtal na Kleofas ani na María Magdalena. ");
INSERT INTO husNT2005_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Tam ti na Jesús in chuꞌu nin nánaꞌ ani kubúl jeye tin wál an exóbal xu kʼanidháb tʼajat kʼal na Jesús, in utsaꞌ enchéꞌ nin nánaꞌ: ―Mímláb, jachanꞌ kʼwajat na chakámil. ");
INSERT INTO husNT2005_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Tayíl in utsaꞌ jeye enchéꞌ an exóbal: ―Jachanꞌ kʼwajat na nánaꞌ. Ani asta tam ti jachanꞌ i kʼij, nin nánaꞌ na Jesús, bachʼwat abal ka kʼwajách bin kʼimáꞌ an exóbal. ");
INSERT INTO husNT2005_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Más tayíl, kom na Jesús in choꞌób abal támunich ejtal xowaꞌ bijidh neꞌech ka támun, in ulu enchéꞌ abal ka tʼájan jelt xan tin ulal an Tʼokat Dhuslab: ―In tsikél. ");
INSERT INTO husNT2005_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Táꞌ ti kʼwajat tajaꞌ jun i balixtaláb tsʼutsat kʼal i jiliy yajtsik uxnél. Axdhá wéꞌ i kwinim ba jachanꞌ an jiliy yajtsik uxnél, wikʼan bin tsúm jun i teꞌ xu bijyáb ti isopo ani utuntsat bin wiꞌ na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Tam ti na Jesús in uchʼámich an jiliy yajtsik uxnél, in ulu enchéꞌ: ―Ejtalich támun jelt xan ti bijidh neꞌech ka tʼájan. Kutpan tám ani chemech. ");
INSERT INTO husNT2005_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Júnich a kʼítsá u kʼibel abal kin bajaw an paskwa ani an judíotsik yab in léꞌ kin chuꞌu ka jilkʼon nin tʼuꞌúl an chemélomtsik ban peltsidh teꞌ tin kʼítsájil an koyóxnich, pos jachanꞌ a kʼítsá jaꞌich xi uluts tʼajat. Jaxtám ti pakabédhá na Pilato abal kin abnaꞌ ka pejtsin tin chʼejettsik xi taꞌ ti kʼwajattsik pajkʼidh ban peltsidh teꞌ ani ka wékʼoyatichtsik tám ban peltsidh teꞌ junax kʼal na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Kʼale tám an soldadotsik ani in pejtsi tin chʼejet xi taꞌ jeye ti kʼwajattsik pajkʼidh ban peltsidh teꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Por tam ti uteytsik xon ti kʼwajat na Jesús, in chuꞌu abal chemnekich. Jaxtám ti yabich Jaꞌ pejtsin an tin chʼejet. ");
INSERT INTO husNT2005_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Por jún ti éb an soldadotsik, in cholkʼantsi tin chóyíl kʼal jun i chʼupidh patʼál ani támkʼi ti kale i xichʼ ani i jaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Xitaꞌ kʼwajat in tʼilál jechéꞌ, jaꞌich jun xitaꞌ xin chuꞌúmal ani tsubax xowaꞌ in ulal; jajáꞌ in choꞌób alwaꞌ ke tsubax xowaꞌ in ulal abal ka belaꞌtsik teye. ");
INSERT INTO husNT2005_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Pos ejtal jechéꞌ támun abal ka tʼájan jelt xan tin ulal an Tʼokat Dhuslab enchéꞌ: “Yab neꞌech ka pejtsin ni jun in beklék.” ");
INSERT INTO husNT2005_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ani taꞌ jeye kʼwajat dhutsadh ban Tʼokat Dhuslab xon tin ulal enchéꞌ: “Neꞌech ka chuꞌutsik xi chʼojbédhats.” ");
INSERT INTO husNT2005_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Tam ti watʼéch ejtal jechéꞌ, na José, xu kʼwajíl ban bitsow xin bij Arimatea, in pakabédhaꞌ na Pilato abal ka walkan kin júnaꞌ nin tʼuꞌúl na Jesús. Na José jaꞌich jun i inik xin belál na Jesús, maske chinatkʼi, kom in chʼejnál an judíotsik. Pidhan an ti awiltaláb kʼal na Pilato, kʼale tám na José ani in júnaꞌich tám nin tʼuꞌúl na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ulich jeye na Nikodemo, xi kʼalnek jun i akal ti káw kʼal na Jesús ani in tsiꞌdhál jun inik láju i kilo i ilál xi tʼajadh kʼal i mirra xukʼudh kʼal i áloe. ");
INSERT INTO husNT2005_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Na José ani na Nikodemo in bachʼutsik tám nin tʼuꞌúl na Jesús ani in boliy kʼal i kʼudhkʼum xi umtsidh jachanꞌ an ti niwiy ilál; anchanꞌ xan tin tʼajál an judíotsik tam in jolyal i chemélomtsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Xon ti chemdhá na Jesús pajkʼidh ban peltsidh teꞌ, taꞌ ti kʼwajat jun i chakam aleláb; tajaꞌ, taꞌ ti cholkʼadh i chʼén xon ti neꞌech ka jolyat i chemélom, bél tʼajat ít ani yab jaykʼi jolidh bél ni jun xitaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Tajaꞌ ti kʼwajbantsat tin tʼuꞌúl na Jesús, kom kʼunat ti kʼwajat jachanꞌ an jólimtaláb ani abal tam ti jachanꞌ, támich tin tʼojojoyal an judíotsik xowaꞌ in yéntsal abal an paskwa. ");
INSERT INTO husNT2005_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Tin jidhtal kʼítsájil an semana, na María Magdalena kʼale dhajawe ban jólimtaláb, bél tʼajat jikʼwax. Tam ti ulich ban jólimtaláb, in chuꞌu abal wékʼodh an tʼujub xi kʼál ti paxkʼidh jachanꞌ an jólimtaláb. ");
INSERT INTO husNT2005_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Kʼale tám adhik xon ti kʼwajat na Simón Pedro ani xi jún jeye an exóbal xu kʼanidháb tʼajat ani in utsaꞌtsik enchéꞌ: ―¡An Ajátikláb wékʼodh ban jólimtaláb ani yab i choꞌób xon ti kʼwajbadh! ");
INSERT INTO husNT2005_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Na Pedro ani na jún an exóbal kaletsik ani kʼale ban jólimtaláb. ");
INSERT INTO husNT2005_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Chablam ti éb ti kʼale ti ádhiltsik; por na jún más adhik ti kʼale ké na Pedro ani okʼox ti ulich ban jólimtaláb. ");
INSERT INTO husNT2005_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Kutpan kin telaꞌ ani in chuꞌu an kʼudhkʼum xi kʼál ti boltsidh tin tʼuꞌúl na Jesús, por yab ochich. ");
INSERT INTO husNT2005_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Tin kuxmats ulich jeye na Simón Pedro ani ochich jaꞌ ban jólimtaláb. In chuꞌu jeye an kʼudhkʼumtsik xi kʼál ti boltsidh tin tʼuꞌúl na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","In chuꞌu jeye abal an kʼudhkʼum xi kʼál ti boltsidh tin ókʼ na Jesús yab junax ti kʼwajat kʼal xi más an kʼudhkʼumtsik, pílkʼi ti kʼwajat mululudh. ");
INSERT INTO husNT2005_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ochich jeye tám na jún an exóbal xi okʼox ti ulnek ban jólimtaláb, in chuꞌu xantʼéy támnék ani in belaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Pos yabél in exbayámaltsik xowaꞌ in ulal an Tʼokat Dhuslab, ke na Jesús koꞌol ka ejech ti ít. ");
INSERT INTO husNT2005_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Tayíl, jechéꞌ an exóbaltsik witsiy tin kʼimáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Na María jilkʼon eléb ban jólimtaláb ti ukʼnal. Lejat kʼwajat ti ukʼnal, kutpan kin telaꞌ alkʼidh ban jólimtaláb, ");
INSERT INTO husNT2005_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ani in chuꞌu cháb i tʼokat abatwáletsik xeketlidh kʼal i dhak kʼudhkʼum buxutsik xon ti kʼwajbantsidh tin tʼuꞌúl na Jesús, jún tin ókʼ ani jún tin akan. ");
INSERT INTO husNT2005_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Konyat enchéꞌ kʼal an tʼokat abatwáletsik: ―Mímláb, ¿jantʼókʼi ta ukʼnal? Jajáꞌ tókʼon enchéꞌ: ―In ukʼnal abal in júntsidh an tu Ajátik ani yab u choꞌób xon ti kʼwajbadh. ");
INSERT INTO husNT2005_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Tam tin ulúmalich jechéꞌ, chawꞌkʼin ani in chuꞌu na Jesús, por yab in choꞌób max jaꞌich na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Konyat tám enchéꞌ kʼal na Jesús: ―Mímláb, ¿jantʼókʼi ta ukʼnal? ¿Jitaꞌ a ayal? Na María, kom in chalpay max jaꞌich xu belkol an ti chakam aleláb, in utsaꞌ enchéꞌ: ―Payꞌlomláb, max tatáꞌ a júnámal, ti kin óltsi xon ta kʼwajbámal abal kin kʼale ku ikʼiꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Utsan tám enchéꞌ kʼal na Jesús: ―¡María! Na María chawꞌkʼin ani in utsaꞌ enchéꞌ kʼal i káwintaláb xi ebreo: ―¡Raboni! ―jechéꞌ in léꞌ kin ulu, Okʼtsix. ");
INSERT INTO husNT2005_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Utsan tám enchéꞌ kʼal na Jesús: ―Ti kin walkaꞌ, yabich más ti kin takaꞌ, pos yabél in kʼalnek xon ti kʼwajat nu Tátaꞌ. Por ki kʼale ani ka tʼiltsi an kidháblábtsik ke Nanáꞌ in neꞌchich xon ti kʼwajat nu Tátaꞌ ani a Tátaꞌtsik teye, nu Diosil ani a Diosiltsik teye. ");
INSERT INTO husNT2005_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Kʼale tám na María Magdalena ani in óltsi an exóbaltsik ke in chuꞌúmal an Ajátikláb ani in óltsitsik jeye xantʼéy usnék kʼal na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Tam ti jikʼwchinich jayéchkʼi jachanꞌ na kʼítsá, nin jidhtal kʼítsájil an semana, junkunék an exóbaltsik ba jun i atá mapupudh an wiꞌleb abal in jikʼnál an judíotsik. Ochich na Jesús, kubey junax chʼejel xon ti kʼwajat an exóbaltsik ani chapnédhaxin enchéꞌ: ―¡Ki kʼwajaytsik kʼijidh! ");
INSERT INTO husNT2005_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Tam tin ulu jechéꞌ, na Jesús in ólnaꞌ nin kʼubak ani nin chóyíl. Ani an exóbaltsik kulbé tʼajat abal in chuꞌutsik an Ajátikláb. ");
INSERT INTO husNT2005_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Utsantsik juní enchéꞌ kʼal na Jesús: ―¡Ki kʼwajaytsik kʼijidh! Anchanꞌ jelt xan tin abámal an Tátaꞌláb, anchanꞌ neye xoꞌ tu abáltsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Jutsutsuyattsik tám kʼal na Jesús ani utsantsik enchéꞌ: ―Ka bachʼutsik an Tʼokat Ejattaláb. ");
INSERT INTO husNT2005_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Xitaꞌ ka pakwlantsitsik, neꞌech ka pakwlantsat; xitaꞌ yab ka pakwlantsitsik, yab neꞌech ka pakwlantsat. ");
INSERT INTO husNT2005_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Na Tomás, xu bijyáb ti Kwayaꞌ, xi jaꞌich jeye jún ti éb xi lajucháb an exóbaltsik, yab jaꞌ waꞌach kʼal xi más an exóbaltsik tam ti ulich na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Tayíl óltsin enchéꞌ kʼal xi kʼeꞌet an exóbaltsik: ―I chuꞌúmal an Ajátikláb. Por tókʼoyattsik enchéꞌ kʼal na Tomás: ―Max yab ku chuꞌu bin kʼubak xon ti ochenek an pajkʼixtaláb ani ku xapaꞌ nu tsʼútsbixtal xon ti ochenek an pajkʼixtaláb ani ku xapaꞌ jeye nu kʼubak bin chóyíl, yab neꞌech ku belaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Waxik a kʼítsá más tayíl, an exóbaltsik junkunék juní ba jun i atá ani tam ti jachanꞌ i kʼij, taꞌ jeye ti kʼwajat na Tomás kʼal jajáꞌtsik. Mapudhtsik tin koꞌol an wiꞌleb, por ochich na Jesús, kubey junax chʼejel xon ti kʼwajattsik ani chapnédhomách enchéꞌ: ―¡Ki kʼwajaytsik kʼijidh! ");
INSERT INTO husNT2005_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Utsan tám enchéꞌ na Tomás kʼal na Jesús: ―Ka xapaꞌ techéꞌ na tsʼútsbixtal ani ka telaꞌ nu kʼubaktsik; ka tsiꞌdhaꞌ na kʼubak ani ka xapaꞌ ba nu chóyíl. Yab ka jálkʼúkʼliyal na chalab, tokot ka óntsi ti kin belaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","In ulu tám enchéꞌ na Tomás: ―¡Tatáꞌ tu Ajátik ani tu Diosil! ");
INSERT INTO husNT2005_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Utsan tám enchéꞌ kʼal na Jesús: ―¿I belmách abalkʼi tin chuꞌu? ¡Kʼijidhtsik tʼajat abal xitaꞌ tin beláltsik maske yab tin chuꞌúmal! ");
INSERT INTO husNT2005_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Na Jesús in tʼajám yán más i labidh exóltsik tin tamét nin exóbaliltsik, xi yab kʼwajat dhutsadh ba jechéꞌ an dhutsadh úw. ");
INSERT INTO husNT2005_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Por xowaꞌ kʼwajat dhutsadh, jaꞌich abal ka belaꞌtsik ke na Jesús jaꞌich an Kristo, nin Chakámil na Dios ani max ka belaꞌ, neꞌech ka kóꞌoy an xeꞌchintaláb xi yab in koꞌol in okʼontal. ");
INSERT INTO husNT2005_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Tam ti watʼenekich ejtal jechéꞌ, na Jesús in xalkʼaꞌ juní tinbáꞌ abal ka chuꞌtat kʼal nin exóbaliltsik. Jechéꞌ támun bin wál an pujal xi Tiberias, enchéꞌ ti támun: ");
INSERT INTO husNT2005_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Jun i kʼij, kʼwajattsik juniniꞌ na Simón Pedro, na Tomás, xu bijyáb ti Kwayaꞌ ani na Natanael, xu kʼwajíl Kaná, an bitsow xu takʼnal Galilea. Táꞌ jeye ti kʼwajat nin chakámiltsik na Sebedeo ani cháb más in exóbaliltsik na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Tam ti tajaꞌtsik ti kʼwajat juniniꞌ, utsantsik enchéꞌ kʼal na Simón Pedro: ―Neꞌech tin jixom toꞌol. Jajáꞌtsik tókʼon enchéꞌ: ―U neꞌech weye kʼal tatáꞌ. Kʼadhiytsik tám ba jun i tan ani kʼale; por jachanꞌ i akal yab xataꞌ in ejtotsik kin jixaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Tam ti exomich ti tsudhél, na Jesús in xalkʼaꞌ tinbáꞌ tin wál an pujal, por an exóbaltsik yab in choꞌób max jaꞌich na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Konyattsik tám enchéꞌ kʼal na Jesús: ―Chakamtsik, ¿yabxeꞌ xataꞌ a koꞌol ki kʼapu? Tókʼontsik enchéꞌ: ―Yabaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Utsantsik tám enchéꞌ kʼal na Jesús: ―Ka petʼnaꞌtsik nin jixáb an toꞌol tin eját an tan ani neꞌech ka jixaꞌtsik an toꞌol. Anchanꞌ tin tʼajaꞌtsik ani junwékʼi nibalich in ejtowaltsik kin káldhaꞌ ban jaꞌ nin jixáb an toꞌol kʼal in álém, kom yán i toꞌol yákʼwnék. ");
INSERT INTO husNT2005_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Utsan tám enchéꞌ na Pedro kʼal an exóbal xu kʼanidháb tʼajat kʼal na Jesús: ―¡Jaꞌich an Ajátikláb! Tam ti na Simón Pedro in achʼaꞌ abal jaꞌich an Ajátikláb, xeketlin kom chilim ti kʼwajat ani in petʼnaꞌ tinbáꞌ ban jaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Xi kʼeꞌet an exóbaltsik, ulich kʼal an tan bin wál an pujal xon ti yab owtsik, in bodhkóm in jixáb an toꞌol tsʼutsat kʼal an toꞌoltsik; pos nin owíl xon ti kʼwajattsik abal bin wál an jaꞌ, in koꞌol xónaꞌ boꞌ inik i metro. ");
INSERT INTO husNT2005_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Tam ti ulichtsik ban chabál, in elaꞌtsik jokʼpadh i kʼamal. Ban kʼamal taꞌ ti exom ti tekʼel jun i toꞌol ani i pan jeye. ");
INSERT INTO husNT2005_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Utsantsik tám enchéꞌ kʼal na Jesús: ―Ka tsiꞌdhaꞌtsik cháb óx i toꞌol xi talél ta jixámaltsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Na Simón Pedro kʼadhiy ban tan ani in bodhoy in jixáb an toꞌol tsʼutsat kʼal an pakdhaꞌ toꞌol asta tin wál an jaꞌ xon ti yab lej owtsik. Nin yaníl an toꞌol, jun i boꞌ inik kʼal chab inik lajuóx ani maske yán tʼajat an toꞌol, nin jixáb yab michʼkʼan. ");
INSERT INTO husNT2005_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Utsantsik tám enchéꞌ kʼal na Jesús: ―Jalaꞌ ta kʼapultsik. Ni jún an exóbaltsik yab in léꞌ kin konoy xitam jáꞌ jeye, kom in choꞌóbichtsik ke jaꞌich an Ajátikláb. ");
INSERT INTO husNT2005_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Tayíl utey na Jesús, in téynaꞌ an pan ani in pidhaꞌ an exóbaltsik; anílkʼi jeye tin tʼajaꞌ kʼal an toꞌol. ");
INSERT INTO husNT2005_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Jechéꞌ jaꞌich tin oxtalich ke na Jesús in xalkʼál tinbáꞌ abal ka chuꞌtat kʼal nin exóbaliltsik tam ti ejnekich ti ít. ");
INSERT INTO husNT2005_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Tam ti okʼonich ti kʼapultsik, na Jesús in konoy enchéꞌ na Simón Pedro: ―Simón, xi chakámláb kʼal na Jonás, ¿tin kʼanidhálxeꞌ más ke xi jechéꞌtsik? Tókʼon enchéꞌ na Pedro: ―Tu kʼanidhál Ajátik, Tatáꞌ a choꞌób alwaꞌ abal tu kʼanidhál. Utsan enchéꞌ kʼal na Jesús: ―Pos ti kin beletnantsi xitaꞌ tin beláltsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Konyat juní tin chabtal: ―Simón, xi chakámláb kʼal na Jonás, ¿tin kʼanidhálxeꞌ? Tókʼoyat enchéꞌ kʼal na Pedro: ―Tu kʼanidhál Ajátik, Tatáꞌ a choꞌób alwaꞌ abal tu kʼanidhál. Utsan enchéꞌ kʼal na Jesús: ―Ti kin beletnantsi xitaꞌ tin beláltsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Konyat juní tin oxtal: ―Simón, xi chakámláb kʼal na Jonás, ¿tin kʼanidhálxeꞌ? Na Pedro tʼeꞌpin abal óxílich ti konyáb max in kʼanidhál na Jesús ani tókʼon enchéꞌ: ―Ajátik, Tatáꞌ ejtal a choꞌób; a choꞌób abal tu kʼanidhál. Utsan tám juní enchéꞌ kʼal na Jesús: ―Ti kin beletnantsi xitaꞌ tin beláltsik. ");
INSERT INTO husNT2005_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Tsubax tu utsál, ke tam ti más i kwitóle, i xeketlinal ani i kʼalel xon ti tatáꞌ ka leꞌnaꞌ; por tam ki yejchelméch, neꞌech ka dhayaꞌ na okób ani kʼeꞌet neꞌech ti ki xeketliy ani neꞌech ti ki júnaꞌ xon ti yab a léꞌ ki kʼale. ");
INSERT INTO husNT2005_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Tam ti na Jesús in ulu jechéꞌ, kʼwajat in tʼilál xan ti neꞌech ka chemech na Pedro ani anchanꞌ, kin xalkʼantsi tin labidh tʼokát na Dios. Tayíl utsan enchéꞌ na Pedro: ―¡Ti kin wéwnaꞌ! ");
INSERT INTO husNT2005_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Tam ti chawꞌkʼin na Pedro, in chuꞌu abal taꞌ jeye ti tál tin kúx an exóbal xu kʼanidháb tʼajat kʼal na Jesús. Jechéꞌ an exóbal, jaꞌich xi jedhkakanék bin okób na Jesús tam ti kʼwajattsik ti kʼapul ani in konyámal enchéꞌ: “Ajátik, ¿jitaꞌ jáꞌ xi neꞌech ti ki pidhnaꞌ abal ki chemdhá?” ");
INSERT INTO husNT2005_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Tam ti na Pedro in chuꞌu jechéꞌ an exóbal, in konoy enchéꞌ na Jesús: ―Ajátik, ¿jantʼéy jeye neꞌech kin tamu jechéꞌ an exóbal? ");
INSERT INTO husNT2005_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Tókʼoyat enchéꞌ kʼal na Jesús: ―Max u léꞌ ka kʼwajay ejat asta tam Nanáꞌ kin witsiy, ¿jantʼó neꞌech ka éynaꞌ? Tatáꞌ ti kin wéwnaꞌich tokot. ");
INSERT INTO husNT2005_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Jaxtám ti tʼílan ban kidháblábtsik, ke jechéꞌ an exóbal yab neꞌech ka chemech. Por xowaꞌ in ulúmal na Jesús jaꞌich jechéꞌ: “Max u léꞌ ka kʼwajay ejat asta tam Nanáꞌ kin witsiy, ¿jantʼó neꞌech ka éynaꞌ?” ");
INSERT INTO husNT2005_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Jechéꞌ an exóbal xu kʼanidháb tʼajat kʼal na Jesús, jaꞌich xi kʼwajat in tʼilál ejtal jechéꞌ ani jajáꞌ in dhutsámal. Ani i choꞌób ke tsubax xowaꞌ in ulal. ");
INSERT INTO husNT2005_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Waꞌach jeye yán más kʼeꞌet xowaꞌ in tʼajámal na Jesús. Yán tʼajat, ke max ka dhutsan juntsik ti juntsik, u chalpayal ke nibal tin putálíl an kʼayꞌlá yab neꞌech ka exey an dhutsadh úwtsik xi ka tʼajan. Anchanꞌ ka tʼájan.");
INSERT INTO husNT2005_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Pulek Teófilo, ban jidhtal úw xi tu dhutsuntsi, u dhutsaꞌ ejtal xowaꞌ na Jesús in tʼajaꞌ ani in okʼtsixnaꞌ tam ti tujeykʼi ejtal jechéꞌ ");
INSERT INTO husNT2005_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ani asta tam tin bajaw na kʼítsá xowkʼi ti kʼadhích walkʼiꞌ. Tam ti yabél kʼadhinek walkʼiꞌ, in takʼiy nin abatwálejiltsik xin takwyám tin cháp an Tʼokat Ejattaláb abal kin choꞌóbnaꞌtsik xantʼéy neꞌech kin tʼajaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Tam ti chemdhá na Jesús ani ejnekich ti ít, in xalkʼaꞌ tinbáꞌ abal ka chuꞌtat kʼal nin abatwálejiltsik. Tin nakíl chab inik a kʼítsá, in óntsi kin xalkʼaꞌ tinbáꞌ abal ka chuꞌtat kʼal jajáꞌtsik ke tsubax lejtal ti ejnek ti ít. U tʼiltsinaltsik kʼal na Jesús xan tu takʼix na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Tam ti bél kʼwajat junax kʼal an abatwáletsik, utsantsik kʼal na Jesús abal yab ka kaletsik ban bitsow Jerusalén. Enchéꞌ ti utsantsik: ―Ka aytsitsik an Tʼokat Ejattaláb xin ulúmal nu Tátaꞌ ke neꞌech ka tsích, jelt xan ti Nanáꞌ tu utsámaltsik. ");
INSERT INTO husNT2005_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Tsubax kʼejle, na Juan pújlách kʼal i jaꞌ, por téꞌ cháb óx a kʼítsá neꞌech ka bachʼutsik an Tʼokat Ejattaláb. ");
INSERT INTO husNT2005_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Konyat tám enchéꞌ na Jesús kʼal xi taꞌ ti junkunéktsik: ―Ajátik, ¿xoꞌichxeꞌ ti neꞌech ka tʼajaꞌ abal yabich ku kʼwajay takʼnél kʼal i píl inik wawáꞌ xu israelita? ");
INSERT INTO husNT2005_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Tókʼoyattsik enchéꞌ kʼal na Jesús: ―Yab tatáꞌtsik a lujyal ka choꞌóbnaꞌ xowkʼi o xowaꞌ neꞌech kin tʼajaꞌ an Tátaꞌláb xi tokot Jajáꞌkʼi in koꞌol i awiltaláb kin tʼajaꞌ; ");
INSERT INTO husNT2005_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","por tam ka bachʼutsik an Tʼokat Ejattaláb, neꞌech ka bachʼutsik i chápláb. Neꞌech ti ki likedhaꞌ abal ki kʼaletsik ti kin tʼilaꞌ putál Jerusalén, putál ban chabál xi Judea, xi Samaria ani asta ban owdhaꞌ bitsowtsik xi waꞌach techéꞌ ti kʼayꞌlá. ");
INSERT INTO husNT2005_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Tam ti okʼonich kin ulu jechéꞌ, lejat jajáꞌtsik kʼwajat in telál, na Jesús dhayan ani júnájich walkʼiꞌ; makʼwchiyat kʼal jun i tokow ani yabich más chuꞌtat. ");
INSERT INTO husNT2005_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Lejat kʼwajat in teláltsik walkʼiꞌ tam ti exom ti kʼadhíl na Jesús, xalkʼan jun jikʼtowál xon ti kʼwajattsik, cháb i iniktsik xeketlidh kʼal dhakniꞌ ");
INSERT INTO husNT2005_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","ani utsantsik enchéꞌ kʼal jachanꞌ an iniktsik: ―Payꞌlomlábtsik xi Galilea, ¿jantʼókʼi ta kʼwajattsik a telál walkʼiꞌ? Jayéchkʼi jechéꞌ na Jesús xa chuꞌutsik ti kʼadhíl walkʼiꞌ, neꞌech ka witsiy juní anílkʼi jelt xan ta chuꞌutsik ti kʼale. ");
INSERT INTO husNT2005_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","In jilaꞌichtsik tám an chʼén xu bijyáb Olibos ani witsiytsik Jerusalén. An bél abal ban chʼén Olibos asta Jerusalén, yab lej nakat; jaꞌich tokot xowaꞌ in ulal an takʼixtaláb ka belná tam in kʼítsájil an koyóxnich. ");
INSERT INTO husNT2005_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Tam ti ulichtsik ban bitsow, kʼadhiy ban atá xon tu kʼwajíltsik. Jajáꞌtsik, jaꞌich na Pedro, na Jakobo, na Juan, na Andrés, na Felipe, na Tomás, na Bartolomé, na Mateo, na Jakobo xu chakámláb kʼal na Alfeo, na Simón xu takʼnal ban junkuntaláb xu bijyáb kananista ani na Judas, nin kidháb na Jakobo. ");
INSERT INTO husNT2005_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ejtal jajáꞌtsik u junkunal echʼekʼi abal ka ólantsik junax kʼal nin kidhábtsik na Jesús, kʼal na María nin nánaꞌ na Jesús ani kʼal xi más an mímlábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Tam ti jachanꞌ i kʼij, kubey na Pedro junax chʼejel xon ti kʼwajat an kidháblábtsik, (nin yaníl an kidháblábtsik jaꞌich jún i boꞌ inik kʼal jun inik i atiklábtsik) ani in utsaꞌtsik enchéꞌ: ");
INSERT INTO husNT2005_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","―Kidháblábtsik, koꞌol ka tʼájan xowaꞌ an Tʼokat Ejattaláb in ulúmal ban Tʼokat Dhuslab, xi káwnék tin wiꞌ na Dabid, kʼal tin kwenta xowaꞌ neꞌech ka támun kʼal na Judas. Jechéꞌ na Judas, jaꞌich xi éyan ti ólnax kʼal an iniktsik xi kʼal ti yakʼwan na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Pos na Judas jaꞌich jún ti éb xi wawáꞌ i kidhtal ani in koꞌol jeyewiꞌik xowaꞌ yejat kin tʼajaꞌ kʼal jechéꞌ an tʼojláb. ");
INSERT INTO husNT2005_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Por kʼale ani in chʼaꞌay jun i chabál kʼal an tumín xin átaꞌ kʼal nin walab; tayíl kwajlan chʼepat, pewen ani tʼáxin ejtal nin tʼidhídh. ");
INSERT INTO husNT2005_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ejtal an kʼwajíltsik xi Jerusalén, in choꞌóbnaꞌ ani in bijiytsik jachanꞌ an chabál, Aséldama, ke jajáꞌ tin káwintaltsik in léꞌ kin ulu, Xichʼ Chabál. ");
INSERT INTO husNT2005_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Abal ban dhutsadh úw, an ajatlábtsik in ulal enchéꞌ: Ka jilkʼon walbadh nin altájil ani yab ka kʼwajay ni jun xitaꞌ tajaꞌ. Ani in ulal jeye enchéꞌ: Ani ka kuxyat kʼal kʼeꞌet. ");
INSERT INTO husNT2005_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","ʼWaꞌach techéꞌ kʼal wawáꞌ i payꞌlomlábtsik xi tu juniknámal echʼekʼi tam ti techéꞌ ti kʼwajat kʼal wawáꞌ ni Ajátik Jesús, ");
INSERT INTO husNT2005_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","asta tam ti pujyat kʼal na Juan asta tam ti kʼadhích walkʼiꞌ. Yejat pé, ke jún ti éb xi jajáꞌtsik ka junkun kʼal wawáꞌ abal kin tʼilaꞌ jeye ke na Jesús ejech ti ít tam ti chemdhá. ");
INSERT INTO husNT2005_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Bijyat tám cháb xi jajáꞌtsik: na José, xu bijyáb Barsabás ani u bijyáb jeye ta Justo ani na Matías. ");
INSERT INTO husNT2005_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ólantsik tám enchéꞌ: ―Ajátik, Tatáꞌ xa a exlál ejtal an ejattalábtsik, ti ku óltsi xitaꞌ xi jechéꞌ cháb a takwyámal ");
INSERT INTO husNT2005_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","abal kin tʼajaꞌ nin tʼojlábil jun i abatwále xi na Judas in jilaꞌ kʼal nin walab, pos jajáꞌ kʼale xon tin lujyal ka kʼale. ");
INSERT INTO husNT2005_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ubátʼintsik tám abal kin chuꞌu xitam jáꞌ kin lujuy ka jilkʼon tin kuxúl na Judas, ani na Matías, jaꞌich in lujuy ka jilkʼon. Asta ti tám, na Matías junkunich kʼal xi lajujún an abatwáletsik. ");
INSERT INTO husNT2005_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Tam tin bajúch nin kʼítsájil an ajib Pentekostés, ejtal an belomtsik junkunék juniniꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Jun jikʼtowále ti achʼatmé jun xataꞌ xi tál walkʼiꞌ, jelti tam u wawꞌnal jun i chapik ikʼ ani achʼatmé putálkʼi an altá xon ti buxutsik. ");
INSERT INTO husNT2005_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Xalkʼan tám ba jajáꞌtsik in éb jun i kʼamal jomomól. ");
INSERT INTO husNT2005_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ejtal in bachʼutsik an Tʼokat Ejattaláb ani in tujutsik ti káw kʼeꞌetich kʼeꞌetich, xantikʼi ti tʼajan ka káwin kʼal an Tʼokat Ejattaláb. ");
INSERT INTO husNT2005_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Tam ti jachanꞌ i kʼij, taꞌ ti kʼwajat ti kʼwajíltsik Jerusalén i judíotsik xin tʼajál tʼajat xan tin ulal nin belomtaltsik, xi táltsik túkʼi túkʼi tin putálíl an kʼayꞌlá. ");
INSERT INTO husNT2005_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Tam ti achʼatmé jachanꞌ, junkun jechéꞌ an atiklábtsik ani nibalich in choꞌóbtsik xantʼéy kin chalpay abal in achʼáltsik ti káw an belomtsik kʼeꞌetich kʼeꞌetich jelt xan ti jajáꞌtsik u káw. ");
INSERT INTO husNT2005_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Labnéktsik tʼajat ani u útsáxtsik jún ani jún enchéꞌ: ―¿Yabxeꞌ jaꞌich xu kʼwajíltsik Galilea xi jechéꞌ kʼwajat ti tʼilomtsik? ");
INSERT INTO husNT2005_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Jantʼókʼi pé tám ti achʼáltsik ti káw jelt xan ti wawáꞌ u káw asta tu tsʼitsik? ");
INSERT INTO husNT2005_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Pos techéꞌ kʼwajat i atiklábtsik xi tál Partos, xi Medos, xi Elám, xi Mesopotamia, xi Judea, xi Kapadosia, xi Ponto ani xi táltsik ban chabál xi Asia. ");
INSERT INTO husNT2005_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Techéꞌ jeye kʼwajat xi táltsik Frijia, xi Panfilia, xi Ejipto ani xi ban chabáltsik xi Afrika xi kʼwajattsik más ów ké Sirene. Techéꞌ jeye kʼwajat i romanotsik xu kʼwajíltsik techéꞌ; taltsik xi jajáꞌtsik u judío ani taltsik yabaꞌ, por in wéwnantsámalichtsik tin belomtal an judíotsik. ");
INSERT INTO husNT2005_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Techéꞌ jeye kʼwajat i atiklábtsik xi tál Kreta ani xi Arabia. Ani ejtal i achʼáltsik ti káw kʼal wawáꞌ i káwintal, tam ti kʼwajattsik in tʼilál an pakdhaꞌ labidhtaláb xin tʼajám na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ejtal labnéktsik tʼajat, yabich in choꞌóbtsik xantʼéy kin chalpay ani u kónóx jajáꞌkʼitsik enchéꞌ: ―¿Jantʼéy in léꞌ kin ulu ejtal jechéꞌ? ");
INSERT INTO husNT2005_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Por taltsik u labídhnax ani in ulaltsik enchéꞌ: ―U itelkʼitsik ti kʼwajat. ");
INSERT INTO husNT2005_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Kubey tám na Pedro junax kʼal xi lajujún an abatwáletsik ani in utsaꞌ kawidh enchéꞌ an atiklábtsik: ―At judíotsik xi ulnek techéꞌ Jerusalén ani ejtal xi kʼwajíltsik techéꞌ, ka choꞌóbnaꞌtsik jechéꞌ ani ka achʼaꞌtsik alwaꞌ xantʼéy neꞌech tu utsaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Jechéꞌ an atiklábtsik yab u itel jelt xan ta chalpayaltsik, pos xowéy beléju i dhajaw. ");
INSERT INTO husNT2005_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Yab u iteltsik, jechéꞌ jaꞌich xowaꞌ xin ulúmal an tʼiltsix Joel, tam tin ulu enchéꞌ ijtsidh kʼal na Dios: ");
INSERT INTO husNT2005_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Na Dios in ulu abal enchéꞌ neꞌech ka támun tam u kʼunelich an pakwenib, neꞌech ku abtsi an tu Tʼokat Ejattal ejtalkʼi an atiklábtsik; an chakámlábtsik neꞌech ti tʼiltsix, xi yabéltsik lej pakdhaꞌ, neꞌech kin chuꞌu i xalkʼantsixtaláb ani an yejcheltsik neꞌech kin kóꞌoy i watsib. ");
INSERT INTO husNT2005_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Jachanꞌ i kʼij neꞌech ku pidhaꞌ tʼajat tu Tʼokat Ejattal an payꞌlomlábtsik ani an mímlábtsik xi tin tʼójontsal ani neꞌech ti tʼiltsixtsik. ");
INSERT INTO husNT2005_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ban walkʼiꞌ neꞌech ku xalkʼaꞌ xowaꞌkich i labidh exóltsik ani ban chabál neꞌech ku xalkʼaꞌ i exóltsik: i xichʼ, i kʼamal ani i paw xi jelti tokow. ");
INSERT INTO husNT2005_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Na kʼítsá neꞌech ka jikʼwchin ani na íchʼ neꞌech ka wenkʼon jelti xichʼ, tam yabél in bajúmal an kʼij xowkʼi ti neꞌech ka tsích an Ajátikláb, xi jaꞌich na kʼítsá xi púlek ani labidh. ");
INSERT INTO husNT2005_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ani ejtal xitaꞌ kin konoy ka loꞌwat kʼal an Ajátikláb, neꞌech ka loꞌey. ");
INSERT INTO husNT2005_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","ʼAt judíotsik, ka achʼaꞌ xantʼéy neꞌech tu utsaꞌtsik: Na Jesús xi Nasaret, jaꞌich jun i inik xi takudh kʼal a Dios ta tamét tatáꞌtsik abal kin tʼajaꞌ i pakdhaꞌ labidhtaláb, i labidh labandhaxtalábtsik ani i exóltsik xin tʼajaꞌ na Dios ba tatáꞌtsik kʼal na Jesúskʼi, jelt xan ta choꞌóbichtsik alwaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Por bélkʼi, tam ta pidhantsik an ta Jesús, jelt xan ti na Dios in koꞌolich kʼejle chalpadh, a júnaꞌtsik ti wikʼnél ani a pidhnaꞌ ban atʼax iniktsik abal ka chemdhá pajkʼidh ban peltsidh teꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Por na Dios in ejdhaꞌ ti ít ani in átantsi tin awiltal an chemlá. Pos na Jesús yab neꞌech ka ejtowat ka átá kʼal an chemlá. ");
INSERT INTO husNT2005_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","A Jesús u tʼilnal kʼal an pulek takʼix Dabid tam tin ulu ti wejeꞌ enchéꞌ: Echʼekʼi u chuꞌtal an Okʼóxláb tu tamét; Jajáꞌ kʼwajat tu eját abal yab ku jikʼnaꞌ ni jun xataꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Jaxtám ti kulbé tʼajat nu itsích ani jaxtám tu tʼilaꞌ i tʼilabtsik xi kʼijidh. Ani jaxtám jeye ti neꞌech kin koyóch u aytsím ke Jajáꞌ ti kin ejdhaꞌ ti ít; ");
INSERT INTO husNT2005_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","pos Tatáꞌ, tin Tʼokat Chakámil, yab neꞌech ka jilaꞌ nu ejattal bin takʼixtal an chemlá, nibal neꞌech ka walkaꞌ ka kʼachey nu tʼuꞌúl. ");
INSERT INTO husNT2005_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Tin óltsámalich an ti bél abal ku elaꞌ an xeꞌchintaláb xi yab in koꞌol in okʼontal ani neꞌech tʼajat ti kin kʼijidhmédhaꞌ tam kin kʼwajách xon ta kʼwajat. ");
INSERT INTO husNT2005_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","ʼAt kidhábtsik, tsubax kʼejle ke ni wejeꞌ pakélil Dabid chemech ani jolyat, pos an jólimtaláb xon ti jolidh, techéꞌ bél kʼwajat kʼal wawáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Por na Dabid jaꞌich jun i tʼiltsix ani in choꞌób abal usnék tsubax tʼajat kʼal na Dios, ke jún ti éb nin kidhtaltsik jaꞌich neꞌech an ti Kristo xi neꞌech ka buxkan ti takʼix bin tʼokat kʼwajtalábil. ");
INSERT INTO husNT2005_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Jaxtám na Dabid, kom in choꞌóbich xantʼéy usnék kʼal na Dios, in ulu abal an Kristo neꞌech ka ejech ti ít ani in ulu jeye abal nin ejattal yab neꞌech ka jilkʼon bin takʼixtal an chemlá nibal neꞌech ka odhey nin tʼuꞌúl. ");
INSERT INTO husNT2005_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Pos na Dios in ejdhaꞌ ti ít jechéꞌ na Jesús ani ejtal jechéꞌ i chuꞌúmal ani i ulal abal tsubax lejtal. ");
INSERT INTO husNT2005_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Pos Jajáꞌ dhayan kʼal in cháp nin eját kʼubak na Dios an Tátaꞌláb ani pidhan kʼál an ti Tʼokat Ejattaláb xi usnék neꞌech ku abtsin. Ejtal jechéꞌ xowaꞌ a chuꞌúmaltsik ani a achʼámal, tál ban Tʼokat Ejattaláb. ");
INSERT INTO husNT2005_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Pos na Dabid yab jajáꞌ na kʼadhiy walkʼiꞌ, por jajáꞌ in ulu enchéꞌ: An Okʼóxláb in utsaꞌ enchéꞌ nu Ajátik: “Ki buxkan tu eját, ");
INSERT INTO husNT2005_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","asta tu átantsi an ti atiklábtsik xi ti tomnál.” ");
INSERT INTO husNT2005_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","ʼKa choꞌóbnaꞌtsik alwaꞌ, atiklábtsik xi Israel, ke jechéꞌ na Jesús xi tatáꞌtsik a chemdhaꞌ pajkʼidh ban peltsidh teꞌ, na Dios in kʼwajbaꞌ abal ti Ajátikláb ani ti Kristo. ");
INSERT INTO husNT2005_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Tam tin achʼaꞌtsik jechéꞌ, tʼeꞌpintsik tʼajat asta tin itsích ani konyat enchéꞌ na Pedro ani xi más an abatwáletsik jeye: ―Kidháblábtsik, ¿jantʼéy yejat ki tʼajaꞌ? ");
INSERT INTO husNT2005_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Tókʼoyattsik enchéꞌ kʼal na Pedro: ―Ka jilaꞌichtsik ta walablom ani ka tʼajaꞌichtsik xowaꞌ in léꞌ na Dios. Ki pujanichtsik tin bij na Jesukristo abal ki pakwlantsatich an ta walastalábiltsik ani anchanꞌ, na Dios neꞌech tám ti pidhaꞌichtsik an ti Tʼokat Ejattaláb. ");
INSERT INTO husNT2005_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Jechéꞌ xowaꞌ na Dios in pidhnál, jaꞌich abal tatáꞌtsik, abal na chakámiltsik ani abal ejtalkʼi jeye xi kʼwajattsik owdhaꞌ; jaꞌich abal ejtalkʼitsik xitaꞌ ka kanyat kʼal an Okʼóxláb ni Diosil. ");
INSERT INTO husNT2005_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Kʼal jechéꞌ an tʼilabtsik ani cháb óx más, na Pedro in tawnaꞌ ani in takʼiytsik enchéꞌ: ―Ka bachʼúchtsik an loꞌeltaláb ani yabich ki kʼwajaytsik yab alwaꞌ jelti xi kʼeꞌet an atiklábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Anchanꞌ pé, xin belaꞌtsik jechéꞌ xowaꞌ utsan, pujyattsik. Jachanꞌ a kʼítsá, belmách ox mil xónaꞌ i atiklábtsik más. ");
INSERT INTO husNT2005_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ejtal in óntsi kin belaꞌ xowaꞌ jáꞌ u okʼtsinaltsik kʼal an abatwáletsik, kʼwajajadhtsik alwaꞌ jún ani jún, u óltsik ani u junkunaltsik abal kin kʼapu an pan. ");
INSERT INTO husNT2005_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ejtal u labnaltsik tʼajat, kʼal tin kwenta xi yán an labidh labandhaxtaláb ani an exóltsik xin tʼajál an abatwáletsik. ");
INSERT INTO husNT2005_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ejtal xi belmámadhichtsik, u junkunal tʼajat ani u chʼéjwálíx xataꞌkich jún ani jún. ");
INSERT INTO husNT2005_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","In nujwaltsik nin chabálil ani ejtal xowaꞌ in koꞌoltsik ani in wélchíxnáltsik an tumín ejtalkʼi ti éb xantikʼi tin koꞌoltsik an yejetaláb. ");
INSERT INTO husNT2005_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Tsudhey ka tsudhey u junkunaltsik ban pulek atá xon tu kʼakʼnáb na Dios ani ban atátsik abal kin péjtsíxnaꞌ an pan; in kʼapaltsik kʼal yantam i kulbétaláb ani kʼal jun in chaꞌat ejattaltsik. ");
INSERT INTO husNT2005_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","In ajtintsaltsik na Dios ani u kʼakʼnábtsik kʼal ejtal an atiklábtsik. Ani an Ajátikláb in yanedhál an belomtsik tsudhey ka tsudhey xu utelichtsik abal ka loꞌéch. ");
INSERT INTO husNT2005_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Jun i kʼij, tam ti óxich i wákal, na Pedro ani na Juan kʼale junax ban pulek atá xon tu kʼakʼnáb na Dios. Jechéꞌ i ora támich tin ujnámaltsik ka kʼalel ti ól. ");
INSERT INTO husNT2005_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Tsudhey ka tsudhey u kʼwajíl tajaꞌ jun i inik xu kʼwechʼeꞌ; jechéꞌ an inik, u kʼwechʼeꞌ ti waꞌchinék. U júnáb ban pulek atá xon tu kʼakʼnáb na Dios ani u kʼwajbáb ban wiꞌleb xu bijyáb ti Labidh abal kin kontsi ti tolmixtaláb xu ocheltsik tajaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Tam ti chuꞌtat na Pedro ani na Juan kʼal an kʼwechʼeꞌ ke exomichtsik ti ochel ban pulek atá xon tu kʼakʼnáb na Dios, pakabédhaxin an kʼwechʼeꞌ abal ka pidhan ti tolmixtaláb. ");
INSERT INTO husNT2005_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Teloloyat tám kʼal na Pedro ani na Juan ani utsan enchéꞌ kʼal na Pedro: ―Ti ku telaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Telxin tám an inik abal in chalpay max neꞌech ka pidhan ti tolmixtaláb. ");
INSERT INTO husNT2005_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Por utsan enchéꞌ kʼal na Pedro: ―Yab u koꞌol i plata nibal i oro, por neꞌech tu pidhaꞌ xowaꞌ u koꞌol. Tin bij na Jesukristo xi Nasaret, tu utsál ki kubey ani ki beley. ");
INSERT INTO husNT2005_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","In téynaꞌ tám na Pedro an inik bin eját kʼubak ani in dhayaꞌ; támkʼi ti likey nin akantsik ani nin mulíkʼ nin akantsik jachanꞌ an inik. ");
INSERT INTO husNT2005_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Tʼikcholách tám an kʼwechʼeꞌ, kubey ani in tujúch tám ti belal. Ochich tám junax kʼal jajáꞌtsik ban pulek atá xon tu kʼakʼnáb na Dios, u belal, u tʼikwnal ani in pubédhantsal tin bij na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Kʼal ejtal an atiklábtsik ti chuꞌtat ti belal ani ti pubédhantsix tin bij na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Labnéktsik tʼajat ejtal ani u jikʼél abal anchanꞌ in chuꞌutsik támun, pos u exláb ke jachanꞌ an inik, jaꞌich xu buxkanal ti konox tolmixtaláb bin wiꞌlébil an pulek atá xon tu kʼakʼnáb na Dios, xu bijyáb ti Labidh. ");
INSERT INTO husNT2005_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Yab u jilchʼowáb na Pedro ani na Juan kʼal an inik xi jeldhá; ejtal an atiklábtsik labnék tʼajat ani adhiktsik ti kʼale bin chakʼlíl an pulek atá xon tu kʼakʼnáb na Dios. Jechéꞌ an chakʼ, jaꞌich xu bijyáb Salomón. Tajaꞌ ti kʼwajattsik na Pedro, na Juan ani an inik xi jeldhats. ");
INSERT INTO husNT2005_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Tam ti na Pedro in chuꞌu jechéꞌ, in utsaꞌ enchéꞌ an atiklábtsik: ―Payꞌlomlábtsik xi kʼwajíl Israel, ¿jantʼókʼi ta labnéktsik tʼajat? ¿Jantʼókʼi ta kʼwajattsik tu telál jelti max kʼal wawáꞌ i cháp o i tʼokattal ti jeley ani ti beley jechéꞌ an inik? ");
INSERT INTO husNT2005_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Yab anchanꞌ, nin Diosil na Abraham, na Isák, na Jakob ani ni wejeꞌ pakéliltsik in pidhámal tin pulek awiltal nin Chakámil Jesús. Jachanꞌ an inik, jaꞌich xi tatáꞌtsik a pidhnaꞌ ban tʼójodhtsik. Tam ti na Pilato in leꞌnaꞌ kin walkaꞌ, tatáꞌtsik yab a leꞌnaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Tam ti yejat ka konoy abal ka walká jachanꞌ an inik xi tʼokat ani lujat, tatáꞌtsik, tokot a konoy ki walkantsat jun i chemdhax inik. ");
INSERT INTO husNT2005_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Anchanꞌ ta chemdhaꞌtsik jachanꞌ an inik xin pidhnál i xeꞌchintaláb xi yab in koꞌol in okʼontal. Por na Dios in ejdhaꞌ ti ít ani ejtal jechéꞌ, wawáꞌ i chuꞌúmal. ");
INSERT INTO husNT2005_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Jaꞌich kʼal tin bij jechéꞌ na Jesús, o jaꞌich ki ulu, an belomtaláb kʼal Jajáꞌ tin bij, jaꞌich kʼál ti pidhan an ti chápláb jechéꞌ an inik xa chuꞌtaltsik ani a exlál. Jechéꞌ an belomtaláb kʼal na Jesús, jaꞌich kʼál ti jeldhá, anchanꞌ xan ti xoꞌ i kʼwajat a chuꞌtaltsik. ");
INSERT INTO husNT2005_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","ʼKidháblábtsik, u choꞌób alwaꞌ, ke tam ti tatáꞌtsik ani na okʼlékiltsik a chemdhaꞌ na Jesús, a tʼajaꞌtsik anchanꞌ abal yab a choꞌóbtsik xantʼéy i kʼwajat a tʼajál. ");
INSERT INTO husNT2005_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Por na Dios in tʼajaꞌ anchanꞌ jelt xan tin ulúmich kʼejle más okʼox kʼal nin tʼiltsíxiltsik, ke an Kristo koꞌol kin watʼnaꞌ i yajtsiktaláb ani ka chemdhá. ");
INSERT INTO husNT2005_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Jaxtám xoꞌ, ka jilaꞌich ta walablomtsik ani ka belaꞌichtsik na Dios abal ki pakwlantsattsik an ta walastalábil. An Okʼóxláb neꞌech tám kin abnaꞌ i kʼij xi alwaꞌ, ");
INSERT INTO husNT2005_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","neꞌech kin abaꞌ na Jesukristo, xi takudhich ti wejeꞌ abal tatáꞌtsik ki loꞌey. ");
INSERT INTO husNT2005_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Por xoꞌ, yejat kʼejle ke na Jesukristo ka kʼwajay ban walkʼiꞌ asta tam na Dios kin lejkích ejtal, jelt xan tin ulúmal kʼal nin tʼokat tʼiltsíxiltsik xi kʼwajinektsik ti wejeꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Anchanꞌ pé, na Moisés in utsaꞌ enchéꞌ ni wejeꞌ pakéliltsik: “Na Dios an Okʼóxláb neꞌech kin takuy jun ti éb xi tatáꞌtsik abal ti tʼiltsix jelt xan ti nanáꞌ tin takwyámal. Ka exbantsitsik ejtal xowaꞌ Jajáꞌ ti ki utsaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Pos ejtal xi yab kin tʼajaꞌ ti kʼij jachanꞌ an tʼiltsix, neꞌech ka kʼibdhátsik ani neꞌech ka wékʼoyat ban atiklábtsik xin takwyámal na Dios.” ");
INSERT INTO husNT2005_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","ʼEjtal an tʼiltsixtsik, asta tam ti xeꞌchin na Samuel ani xi más tayíltsik, in tʼilámal jechéꞌ an kʼijtsik. ");
INSERT INTO husNT2005_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Xowaꞌ na Dios in ulúmal kʼal nin tʼiltsíxiltsik, jaꞌich abal tatáꞌtsik. Jaꞌich jeye abal tatáꞌtsik ta alwaꞌbíl tin tʼajámal na Dios jun i lejkintaláb kʼal ni wejeꞌ pakéliltsik, tam tin utsaꞌ na Abraham enchéꞌ: “Ejtal xi ka waꞌchintsik techéꞌ ti kʼayꞌlá, neꞌech ka lábtʼájan kʼal tatáꞌkʼi na kidhtaltsik.” ");
INSERT INTO husNT2005_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Tam ti na Dios in ejdhaꞌ ti ít nin Chakámil, tu abtsi okʼox wawáꞌ abal ti ku lábtʼajaꞌ ani ki jilaꞌich tu walablom. ");
INSERT INTO husNT2005_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Tam ti na Pedro ani na Juan bél kʼwajat in tawnál an atiklábtsik, ulich an páleꞌtsik junax kʼal nin okʼlékil an belkol pulek atá xon tu kʼakʼnáb na Dios ani kʼal an saduseotsik. ");
INSERT INTO husNT2005_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Jajáꞌtsik u chakúl tʼajat abal na Pedro ani na Juan in okʼtsal an atiklábtsik ani in ulal abal an chemélomtsik u ejel ti ít jelt xan ti na Jesús ejech ti ít. ");
INSERT INTO husNT2005_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Júnátsik tám ani balyat ban wikʼaxteꞌ asta jun tsudhelom, pos tam ti jachanꞌ a kʼítsá, wákalich. ");
INSERT INTO husNT2005_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Por yán i atiklábtsik belmách xin achʼaꞌ xowaꞌ in ulu na Pedro. Nin yaníl an atiklábtsik xi belmách, tokot jákʼi ajidh an iniktsik, in bajaw xónaꞌ wéꞌich boꞌ mil. ");
INSERT INTO husNT2005_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Tam ti jun tsudhelom, junkuntsik Jerusalén an pakdhaꞌ awiltalábtsik, nin okʼlékiltsik an judíotsik ani an okʼtsixtsik xin wilál nin takʼixtal na Dios xin jilám dhutsadh na Moisés. ");
INSERT INTO husNT2005_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Táꞌ jeye ti kʼwajattsik na Anás, xi jaꞌich in okʼlékil an páleꞌtsik, na Kayfás, na Juan, na Alejandro ani ejtal in kidhtaltsik an okʼlek páleꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Abná tám ka ikʼtat na Pedro ani na Juan, kʼwajbátsik junax chʼejel ani konyattsik enchéꞌ: ―¿Kʼal jantʼom awiltaláb, o kʼal jitaꞌ in bij ta tʼajámaltsik ejtal jechéꞌ? ");
INSERT INTO husNT2005_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Na Pedro, teykómte kʼal nin cháp an Tʼokat Ejattaláb in utsaꞌtsik tám enchéꞌ: ―Okʼlek atiklábtsik ani okʼlek judíotsik, ");
INSERT INTO husNT2005_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","kom tatáꞌtsik tu konyal kʼal tin kwenta an alwaꞌtaláb xi tʼájan ba jun i yaꞌul inik abal a léꞌ ka choꞌóbnaꞌtsik xan ti jeldhá, ");
INSERT INTO husNT2005_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","neꞌech ki ulu ta taméttsik abal kin choꞌóbnaꞌ ejtal an atiklábtsik xi Israel, ke jechéꞌ an inik xi jéꞌ kʼwajat, jelnek tin bij na Jesukristo xi Nasaret. Jechéꞌ na Jesukristo, jaꞌich xi tatáꞌtsik a chemdhaꞌ pajkʼidh ban peltsidh teꞌ ani xi na Dios in ejdhaꞌ ti ít. ");
INSERT INTO husNT2005_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jelti jun i kúbal atá xin kʼwajbaꞌ píl jun i tʼujub abal yab in léꞌ kin éynaꞌ, anchanꞌ ta tʼajaꞌtsik kʼal na Jesús, por Jajáꞌ in bajaw ka kʼwajay jelti an tʼujub xi ultaláb. ");
INSERT INTO husNT2005_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ba ni jun xitaꞌ más ti neꞌech ki elaꞌ i loꞌeltaláb; pos na Dios yab xitaꞌ más tu bijtsámal techéꞌ ti kʼayꞌlá, xi neꞌech kin ejto ti ku loꞌo. ");
INSERT INTO husNT2005_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Tam ti an okʼlektsik in chuꞌu ti káw na Pedro ani na Juan kʼal ni jun i jíkʼib ani in choꞌóbtsik ke jajáꞌtsik yab exóblomámadh, nibal in choꞌóbtsik xan tu wilnal nin takʼixtal na Dios xin jilám dhutsadh na Moisés, labantsik tʼajat ani in ulutsik tám, ke jechéꞌtsik jaꞌich xi xeꞌchinék kʼal na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","An inik xi jeldhats taꞌ jeye ti kubat junax kʼal jajáꞌtsik, jaxtám an okʼlektsik ti yab in ejto kin ulu ke yab tsubax. ");
INSERT INTO husNT2005_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Utsantsik tám abal ka kaléch tajaꞌ xon ti kʼwajat an junkuntaláb ani jajáꞌtsik jilkʼon ti káwlíx. ");
INSERT INTO husNT2005_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Ani in ulaltsik enchéꞌ: ―¿Jantʼéy neꞌech ki tajaꞌ kʼal jechéꞌ an iniktsik? Pos ejtal xu kʼwajíltsik Jerusalén in choꞌób abal in tʼajámal jechéꞌ an labidh labandhaxtaláb ani yab neꞌech ki ejto ki ulu ke yab aniꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Por abal yabich más ka choꞌóbná kʼal an atiklábtsik jechéꞌ xowaꞌ támun, wana ki utsaꞌtsik abal neꞌech ki atʼax tʼajtsitsik abal yabich más xitaꞌ kin tʼiltsitsik an ta Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Kanyattsik tám ani utsantsik abal yabich ka káwin nibal ka okʼtsixin tin bij na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Por tókʼoyattsik enchéꞌ kʼal na Pedro ani na Juan: ―Ka chalpaytsik max alwaꞌ más tin tamét na Dios ki tʼajaꞌ xowaꞌ tatáꞌtsik a léꞌ, o ki tʼajaꞌ xowaꞌ in léꞌ na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Pos wawáꞌ yab neꞌech ki ejto ki jilaꞌ ki tʼilaꞌ xowaꞌ i chuꞌúmal ani i achʼámal. ");
INSERT INTO husNT2005_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Utsantsik tám más kʼal an okʼlektsik abal neꞌech ka atʼax tʼajtsintsik, por walkátsik. Yab in elaꞌ xantʼokʼál ti kin walbindhaꞌtsik, pos ejtal an atiklábtsik in pubédhantsal tin bij na Dios kʼal tin kwenta xowaꞌ támun. ");
INSERT INTO husNT2005_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","An inik xi jeldhá kʼal tin awiltal na Dios, in koꞌolich chab inik watʼats i tamub. ");
INSERT INTO husNT2005_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Tam ti walkadhichtsik, na Pedro ani na Juan, kʼaletsik xon ti kʼwajat nin kidhtaltsik ani in óltsi ejtal xowaꞌ utsantsik kʼal nin okʼlékiltsik an páleꞌtsik ani kʼal nin okʼlékil an judíotsik. ");
INSERT INTO husNT2005_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Tam tin achʼaꞌtsik, ejtal jununúl ti ólan ani in utsaꞌtsik enchéꞌ na Dios: ―Okʼóxláb, Tatáꞌ ni Dios xa tʼajámal an walkʼiꞌ, an chabál, an pujal ani ejtal xowaꞌ waꞌach. ");
INSERT INTO husNT2005_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Tatáꞌ, kʼal na Tʼokat Ejattal ani kʼal nin wiꞌ na tʼójontsixil Dabid, a ulu ti wejeꞌ enchéꞌ: ¿Jantʼókʼi tu péjéx an pakdhaꞌ bitsow ani an atiklábtsik in chalpayal xowaꞌ xi yab xataꞌ in jalbíl? ");
INSERT INTO husNT2005_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","An pakdhaꞌ takʼix ani an okʼlektsik xi techéꞌ ti chabál, junkuntsik abal ti kin péjey ani abal kin péjey jeye an Kristo xu takwyám. ");
INSERT INTO husNT2005_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","ʼTsubax kʼejle, na Erodes ani na Ponsio Pilato, junkuntsik ba jechéꞌ an bitsow kʼal an píl iniktsik ani kʼal an israelitatsik abal kin péjey na tʼokat Chakámil Jesús, xi Tatáꞌ a takwyámal. ");
INSERT INTO husNT2005_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Kʼal jechéꞌ, jajáꞌtsik in tʼajaꞌ ejtal xowaꞌ Tatáꞌ a ulúmal ke anchanꞌ neꞌech ka támun. ");
INSERT INTO husNT2005_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ani xoꞌ, Okʼóxláb, ka achʼaꞌ xan tu utsan ke neꞌech ku atʼax tʼajtsin, por ti ku pidhaꞌ ti chápláb abal wawáꞌ xi jaꞌich na tʼojnáliltsik, ki óntsi ki tʼilaꞌ na káwintal kʼal ni jun i jíkʼib. ");
INSERT INTO husNT2005_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Kʼal na awiltal ki jeldhaꞌ i yaꞌultsik, ki tʼajaꞌ i exóltsik ani i labidh labandhaxtalábtsik tin bij na tʼokat Chakámil Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Tam ti okʼonichtsik an ti ól, an chabál xon ti kʼwajattsik, yoyon; likedhantsattsik tin itsích kʼal an Tʼokat Ejattaláb ani in óntsi kin tʼilaꞌtsik nin káwintal na Dios kʼal ni jun i jíkʼib. ");
INSERT INTO husNT2005_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ejtal xi belmámadhichtsik, jununúltsik aniꞌ tin koꞌol nin chalab ani jununúltsik nin ejattal. Ni jun xitaꞌ yab in ulal ke xowaꞌ in koꞌol kwetém tin dhabal, tokot in ulal abal ejtalkʼi tin dhabaltsik. ");
INSERT INTO husNT2005_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","An abatwáletsik in óntsal kin tʼilaꞌ kʼal yantam i awiltaláb, ke na Jesús ejnek ti ít ani u lábtʼajnaltsik tʼajat kʼal na Dios ejtalkʼitsik. ");
INSERT INTO husNT2005_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Yab waꞌach kʼal jajáꞌtsik ni jun xitaꞌ xi watʼatsich tʼajat tin yéntsal jun xataꞌ; pos ejtal xin koꞌol i chabáltsik o i atátsik, in nujwaltsik, in tsiꞌdhál an tumín ");
INSERT INTO husNT2005_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ani in pidhál an abatwáletsik. An abatwáletsik in wélchíxliyal xantikʼi jún tin yéntsal. ");
INSERT INTO husNT2005_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Anchanꞌ jeye tin tʼajaꞌ na José, jun i lebita xi Chipre tu chakam, an chabál xi kʼwajat ban jaꞌ; bijyat kʼal an abatwáletsik ta Bernabé, jechéꞌ an bijláb in léꞌ kin ulu Xu kʼijidhmédhom. ");
INSERT INTO husNT2005_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Jechéꞌ an inik in nuju jun i chabál xin koꞌol ani in tsiꞌdhaꞌ an tumín abal kin pidhaꞌ an abatwáletsik. ");
INSERT INTO husNT2005_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Por jun i inik jeye xu bijyáb ta Ananías ani nin tomtal xin bij ta Safira, in nujutsik jeye jun i chabál. ");
INSERT INTO husNT2005_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Jechéꞌ an inik, yab in pidhnaꞌ ejtal an tumín, in jilaꞌ wéꞌ ani xi más, in pidhaꞌ an abatwáletsik. Por jajáꞌ in pidhnaꞌ jachanꞌ an tumín jelti max ejtal xin bachʼu ani nin tomtal in choꞌób alwaꞌ ejtal jechéꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Utsan tám enchéꞌ kʼal na Pedro: ―Ananías, ¿jantʼókʼi ta walkaꞌ ti ki átantsi ta itsích an lej atʼax abal ti tʼajaꞌ ka kʼambiy an Tʼokat Ejattaláb ani yab ka pidhnaꞌ ejtal in jalbíl an chabál xa nujúmal? ");
INSERT INTO husNT2005_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","¿Yabxeꞌ tatáꞌ a dhabal jachanꞌ an chabál? Ani tam ta nujúch, ¿yabxeꞌ tatáꞌ a dhabal an tumín xa bachʼu? ¿Jantʼókʼi ta chalpay ka tʼajaꞌ anchanꞌ? Yab a kʼambiyámal i iniktsik, xitaꞌ a leꞌnámal ka kʼambiy, a Dios. ");
INSERT INTO husNT2005_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Tam tin achʼaꞌ jechéꞌ, na Ananías kwajlan ani chemech. Ejtal xin choꞌóbnaꞌtsik jechéꞌ, jikʼeytsik tʼajat. ");
INSERT INTO husNT2005_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ulich tám cháb óx i kwitól iniktsik, in boliy an chemélom ani in júnaꞌtsik kin joliy. ");
INSERT INTO husNT2005_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Óx i ora más tayíl, ochich nin tomtal na Ananías ani jajáꞌ yab in choꞌób xantʼéy támnék. ");
INSERT INTO husNT2005_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Konyat enchéꞌ kʼal na Pedro: ―Ti kin utsaꞌ, ¿tsubaxxeꞌ lejtal anchanꞌ ta nujúmaltsik an chabál jelt xan ta ulúmaltsik? An mímláb tókʼon enchéꞌ: ―Anchanꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Utsan tám enchéꞌ kʼal na Pedro: ―¿Jantʼókʼi ta tʼajaꞌtsik i káw abal a leꞌnaꞌ ka kʼambintsi tin Tʼokat Ejattal an Okʼóxláb? Jachanꞌ tál eléb xi kʼaletsik kin joliy na tomkíl ani xoꞌ, tatáꞌ teye neꞌech ti ki júnaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Támkʼi jachanꞌ, kwajlan jeye chabál na Safira ani chemech. Tam ti ochich an kwitól iniktsik, chemnekich tin elaꞌ; in káldhaꞌichtsik tám ani in júnaꞌ kin joliy tin wál xon ti jolidh nin tomkíl. ");
INSERT INTO husNT2005_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ejtal an atiklábtsik xu belomich ani ejtal jeye xin choꞌóbnaꞌtsik jechéꞌ, jikʼeytsik tʼajat. ");
INSERT INTO husNT2005_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Yán i exóltsik ani i labidh labandhaxtalábtsik in tʼajál an abatwáletsik ban atikláb kʼal tin awiltal an Ajátikláb; ejtal an belomtsik u junkunal ban chakʼ xu bijyáb Salomón ani juniniꞌtsik nin chalab. ");
INSERT INTO husNT2005_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Yab u junkunal kʼal jajáꞌtsik ni jun xitaꞌ xi yab u belom, por u kʼakʼnábtsik tʼajat kʼal an atiklábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Tsudhey ka tsudhey más u yanel an atiklábtsik xin belálich an Ajátikláb, i payꞌlomlábtsik ani i mímlábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","U káldháb an yaꞌultsik ban béltsik, u kʼwajbáb ban chéytsik ani ban chayteꞌtsik abal ka bajwattsik kʼal nin chalám na Pedro tam ka watʼey tajaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","U ulel jeye i atiklábtsik Jerusalén xu kʼwajíl ban kwentsaltsik xi tajaꞌ kʼunat. In tsiꞌdhál an yaꞌultsik ani xi kʼwajattsik jeye ochadh kʼal i atʼax ejattaláb ani ejtal u jeldhábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","An okʼlek páleꞌtsik ani nin kidhtal an saduseotsik, xi taꞌ ti kʼwajattsik kʼal jajáꞌ, chakuytsik tʼajat abal in atʼál xowaꞌ in tʼajál an abatwáletsik ");
INSERT INTO husNT2005_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","ani in júnaꞌ abal kin baliy ban wikʼaxteꞌ xon tu balyáb ejtalkʼitsik. ");
INSERT INTO husNT2005_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Por tam ti akal, jun in tʼokat abatwálejil an Ajátikláb in japiy in wiꞌlébil an wikʼaxteꞌ ani in káldhaꞌtsik. Tam ti exomich ti kalel, utsantsik enchéꞌ: ");
INSERT INTO husNT2005_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","―Ki kʼaléchtsik ani tam i kʼwajattsik ban pulek atá xon tu kʼakʼnáb na Dios, ka tʼiltsi an atiklábtsik ejtal kʼal tin kwenta jechéꞌ an ít xeꞌchintaláb. ");
INSERT INTO husNT2005_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Tam tin achʼaꞌtsik jechéꞌ, jun tsudhelom dhajawe ti ochichtsik ban pulek atá xon tu kʼakʼnáb na Dios ani in tujutsik ti okʼtsix. Tam ti jachanꞌ, ulich an okʼlek páleꞌtsik junax kʼal xi taꞌ ti kʼwajattsik kʼal jajáꞌ, in kaniytsik xu takʼix ban Junkulom Awiltaláb ani ejtal jeye nin okʼlékil an israelitatsik. In abnaꞌ tám ka ikʼtat ban wikʼaxteꞌ an abatwáletsik. ");
INSERT INTO husNT2005_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Por tam ti ulich ban wikʼaxteꞌ an belkoltsik, yab in elaꞌtsik; ani tam ti witsiytsik, ");
INSERT INTO husNT2005_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","in ulu enchéꞌ: ―Mapupudh alwaꞌ ti elaꞌ an wikʼaxteꞌ ani an soldadotsik taꞌ ti kʼwajat eléb ti belkol ban wiꞌlebtsik; por tam tin japiy an wiꞌlebtsik, yab i elaꞌ ni jun xitaꞌ altá. ");
INSERT INTO husNT2005_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Tam tin achʼaꞌtsik jechéꞌ nin okʼlékil an páleꞌtsik, nin okʼlékil xu belkoltsik an ti pulek atá xon tu kʼakʼnáb na Dios ani an ultaláb páleꞌtsik, u kónóxtsik xan ti neꞌech ka kʼale ti okʼnal jechéꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Támkʼi jachanꞌ, ulich jun i inik ani utsantsik kʼál enchéꞌ: ―An iniktsik xa balyámaltsik ban wikʼaxteꞌ, taꞌ kʼwajattsik in okʼtsal an atiklábtsik ban pulek atá xon tu kʼakʼnáb na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Kʼale tám nin okʼlékil xu belkoltsik an ti pulek atá, kʼál an yákʼwaltsik ani in tsiꞌdhaꞌtsik, por yab xataꞌ tin tʼajtsitsik abal in chʼejnál ka tʼujbayat kʼal an atiklábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Tam ti uldhátsik, kʼwajbá tin tamét an Junkulom Awiltaláb ani utsantsik enchéꞌ kʼal nin okʼlékil an páleꞌtsik: ");
INSERT INTO husNT2005_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","―Wawáꞌ i ulu alwaꞌ abal yabich i léꞌ ki chuꞌu ki okʼtsixintsik tin bij na Jesukristo. ¿Ani jantʼéy a tʼajaꞌtsik? Ejtal an atiklábtsik xi Jerusalén a okʼtsámalichtsik kʼal jachanꞌ an okʼtsixtaláb ani a léꞌtsik ti ku walbindhaꞌ kʼal nin chemtal jachanꞌ an inik. ");
INSERT INTO husNT2005_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Tókʼon tám na Pedro ani xi más an abatwáletsik enchéꞌ: ―Wawáꞌ i choꞌób alwaꞌ ke yejat ki tʼajaꞌ xowaꞌ in ulal nin tsubaxtalábil na Dios ani yab, xowaꞌ in ulal an iniktsik. ");
INSERT INTO husNT2005_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Nin Diosil ni wejeꞌ pakélil in ejdhaꞌ ti ít na Jesús, xi tatáꞌtsik a chemdhaꞌ pajkʼidh ban peltsidh teꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Na Dios in dhayaꞌ tʼekʼat, in kʼwajbaꞌ tin eját ani in kʼwajbaꞌ ti Okʼpidh Okʼlek ani ti Loꞌox. In tʼajaꞌ anchanꞌ abal kin pidhaꞌ bél ti kʼij an atiklábtsik xi Israel abal kin jilaꞌtsik ti walablom ani ka pakwlantsat tin walastalábiltsik. ");
INSERT INTO husNT2005_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ejtal jechéꞌ i chuꞌúmal weye ani an Tʼokat Ejattaláb jeye. Jechéꞌ an Tʼokat Ejattaláb, jaꞌich xi na Dios in pidhámalich xu axtsinal kʼál tin tsubaxtalábil. ");
INSERT INTO husNT2005_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Tam tin achʼaꞌtsik jechéꞌ, chakuytsik tʼajat ani in leꞌnaꞌtsik kin chemdhaꞌ an abatwáletsik. ");
INSERT INTO husNT2005_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Por tajaꞌ ban awiltalábtsik, taꞌ ti kʼwajat jun i fariseo xu bijyáb ta Gamaliel, jaꞌich jún ti éb an okʼtsixtsik xin wilál nin takʼixtal na Dios xin jilám dhutsadh na Moisés ani u kʼakʼnáb tʼajat kʼal an atiklábtsik. Kubey ani in ulu abal ka káldhá junwéꞌ an abatwáletsik. ");
INSERT INTO husNT2005_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","In utsaꞌ tám enchéꞌ an awiltalábtsik: ―Atiklábtsik xi Israel, ka kóꞌoytsik tʼajat i kwenta kʼal xantʼéy a léꞌ ka tʼajtsi jechéꞌ an iniktsik. ");
INSERT INTO husNT2005_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ka chalpaytsik ke ti weꞌél chabkʼiꞌ xeꞌchin na Tewdas, xin péjey an lej pulek takʼix ani in ulu ke jajáꞌ jaꞌich jun i pulek inik, wéwná kʼal chéꞌ i boꞌ inik i iniktsik. Por chemdhá ani ejtal xi kʼál ti wéwnadh, bukʼlantsik ani anchanꞌ ti okʼon. ");
INSERT INTO husNT2005_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","ʼMás tayíl, tam ti tʼajan an ajumtaláb, xeꞌchin jeye na Judas xu kʼwajíl Galilea ani kʼal yán jeye ti wéwná; por chemdhá jeye ani ejtal xi wéwnaxnék, bukʼlan. ");
INSERT INTO husNT2005_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Jaxtám tu utsáltsik, jilaꞌ kʼwajat jechéꞌ an iniktsik ani yab xataꞌ ka utsaꞌtsik. Pos max jechéꞌ xowaꞌ in tʼajáltsik, in chalab i iniktsik, neꞌech ka okʼon; ");
INSERT INTO husNT2005_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","por max a Dios in chalab, yab neꞌech ka ejto ka tamkʼuytsik. Ka kóꞌoytsik tʼajat i kwenta; pos yab a choꞌóbtsik max exom ta péjéx kʼal i iniktsik o kʼal a Dios. ");
INSERT INTO husNT2005_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ejtal in exbaytsik xowaꞌ utsan kʼal na Gamaliel. Kanyat tám an abatwáletsik, kwadhan ani utsantsik abal yabich más ka xeꞌchintsik ti káw tin bij na Jesús ani walkájichtsik tám. ");
INSERT INTO husNT2005_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Kaléch tám an abatwáletsik xon ti kʼwajat an awiltalábtsik ani u kulbéltsik tʼajat abal pidhan ti chápláb kʼal a Dios kin watʼnaꞌ i tidhetaláb kʼal tin kwentakʼi in bij na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Tsudhey ka tsudhey yab in jiláltsik kin okʼtsixnaꞌ an alwaꞌ tʼilab ani kin tʼilaꞌ ke na Jesús jaꞌich na takudh kʼal na Dios. U okʼtsixtsik ban pulek atá xon tu kʼakʼnáb na Dios ani ban atátsik jeye. ");
INSERT INTO husNT2005_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Tam ti jachanꞌ i kʼij, kom an belomtsik yanéch, an judíotsik xu káw griego tujey ti itʼixbéltsik kʼal an judíotsik xu káw ebreo. In ulaltsik xu káw griego ke an chemtsidh mímlábtsik xi jajáꞌ in kidhtal, yab u lej tʼajtsinaltsik ti kʼij tam u pidhnáb an kʼapnél tsudhey ka tsudhey. ");
INSERT INTO husNT2005_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Junkuwat tám ejtal an belomtsik kʼal xi lajucháb an abatwáletsik ani utsantsik enchéꞌ: ―Yab in tomnál ki jilaꞌ ki tʼilaꞌ nin káwintal na Dios kʼal tin kwentakʼi abal ku kʼwajay tu pidhnom kʼapnél. ");
INSERT INTO husNT2005_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Jaxtám kidháblábtsik, ka aliy búk i payꞌlomlábtsik xi tatáꞌtsik a kidhtal, xi alwaꞌ iniktsik, xi chalpadhtsik, xi teykómte tʼajat kʼal in cháp an Tʼokat Ejattaláb ani jaꞌich ka punkʼuntsitsik jechéꞌ an ti tʼojláb. ");
INSERT INTO husNT2005_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Wawáꞌ neꞌech ki óntsi tu ól ani ki okʼtsixnaꞌ nin káwintal na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ejtaltsik in tokʼoy jechéꞌ ani takwyat na Esteban, jun i inik xu belom tʼajat ani teykómte tʼajat kʼal in cháp an Tʼokat Ejattaláb. Takwyat jeye na Felipe, na Prókoro, na Nikanor, na Timón, na Parmenas ani na Nikolás, jun i inik xu kʼwajíl Antiokía xin belámal jeyewiꞌik nin belomtal an judíotsik. ");
INSERT INTO husNT2005_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Tsiꞌdhátsik tám xon ti kʼwajat an abatwáletsik, ólan an abatwáletsik ani in kʼwajbaꞌtsik nin kʼubak bin éb xi takwyattsik. ");
INSERT INTO husNT2005_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Nin káwintal na Dios jikʼat tʼajat ti bukʼey ani an belomtsik jikʼat tʼajat ti yaney Jerusalén, asta yán in páleꞌiltsik an judíotsik belmách. ");
INSERT INTO husNT2005_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Na Esteban, jun i inik xin bachʼúmal tʼajat nin alwaꞌtal ani nin cháp na Dios, in tʼajál i labidh labandhaxtalábtsik ani i exóltsik ban atiklábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Tám, taltsik i atiklábtsik xu takʼnal ban atá xon tu tʼajnal an junkuntaláb xu bijyábtsik ti jolib xi walkadhich, junax kʼal i atiklábtsik xi Sirene, xi Alejandría, xi Silisia ani xu kʼwajíltsik ban chabál xi Asia, in tujutsik ti káwlíx kʼal na Esteban; ");
INSERT INTO husNT2005_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","por yab u ejtowáb ka tomná na Esteban abal jajáꞌ u káw kʼal yantam i chalpadhtaláb xu pidhnal kʼal an Tʼokat Ejattaláb. ");
INSERT INTO husNT2005_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Jalbiyat tám kʼal jechéꞌtsik taltsik i iniktsik abal kin ulu ke in achʼámal ti odhbíjil ta Moisés ani ta Dios. ");
INSERT INTO husNT2005_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Anchanꞌ ti chakúdhá an atiklábtsik, nin okʼlékil an judíotsik ani an okʼtsixtsik xin wilál nin takʼixtal na Dios xin jilám dhutsadh na Moisés; péjeyat kʼál na Esteban, yakʼwan ani júná tin tamét an Junkulom Awiltaláb. ");
INSERT INTO husNT2005_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Alyat jeye i jánum káwtsik, xin ulutsik enchéꞌ: ―Jechéꞌ an inik yab u koyol ti odhbíjil an ti pulek atá xon tu kʼakʼnáb na Dios ani an tin takʼixtal na Dios xin jilám dhutsadh na Moisés. ");
INSERT INTO husNT2005_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","I achʼámal jeye tin ulu ke na Jesús xi Nasaret neꞌech kin paku an pulek atá xon tu kʼakʼnáb na Dios ani neꞌech kin jalkʼuy ejtal xowaꞌ in jilámal ka tʼajan na Moisés. ");
INSERT INTO husNT2005_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Tam ti an awiltalábtsik ani ejtal xi taꞌ ti buxutsik in telaꞌ na Esteban, in chuꞌutsik ke nin wal na Esteban in junwal jelt in wal jun i tʼokat abatwále. ");
INSERT INTO husNT2005_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Konyat tám enchéꞌ na Esteban kʼal nin okʼlékil an páleꞌtsik: ―¿Tsubaxxeꞌ jechéꞌ xowaꞌ i usnal? ");
INSERT INTO husNT2005_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ani na Esteban tókʼon enchéꞌ: ―At kidhtaltsik ani tátaꞌlábtsik, ka achʼaꞌ xantʼéy neꞌech tu utsaꞌtsik: Ni labidh tʼokat Diosil, in xalkʼaꞌ tinbáꞌ abal ka chuꞌtat kʼal ni wejeꞌ pakélil Abraham tam ti kʼwajat ban chabál xi Mesopotamia, tam ti yabél kʼalnek ti kʼwajíl Arán ");
INSERT INTO husNT2005_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","ani utsan enchéꞌ: “Ka jilaꞌ na chabálil ani ejtal na exlowáltsik ani ki kʼale ban chabál xi neꞌech tu óltsi.” ");
INSERT INTO husNT2005_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Kale tám na Abraham bin chabálil an kaldeotsik ani kʼale ti kʼwajíl Arán. Tayíl chemech nin tátaꞌ ani na Dios in tsiꞌdhaꞌ na Abraham ti kʼwajíl techéꞌ xon ti tatáꞌtsik xoꞌ i kʼwajat. ");
INSERT INTO husNT2005_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Por yab pidhan kʼal na Dios techéꞌ ni jun pejeꞌ ti chabál abal kin dhabalnaꞌ, nibal jun pejeꞌ elaꞌ xon ti kin kubaꞌ jun in akan; por utsan abal neꞌech ka pidhan ani ke tayíl, tam jajáꞌ ka chemchich, nin chakámiltsik jaꞌich neꞌech kin dhabalnaꞌ; maske tam ti jachanꞌ i kʼij, na Abraham yabél in koꞌol ni jun in chakámil. ");
INSERT INTO husNT2005_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Ani utsan jeye enchéꞌ kʼal na Dios: “Na kidhtaltsik neꞌech ka kʼwajay jelti píl iniktsik ba jun i chabál xi yab jajáꞌtsik in dhabal, neꞌech ka tʼajan ti jolibtsik ani neꞌech ka tʼajtsin xan ti ka leꞌná, tin nakíl chéꞌ i boꞌ inik i tamub.” ");
INSERT INTO husNT2005_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Por utsan jeye enchéꞌ: “Nanáꞌ neꞌech ku lújundhaꞌ an yejcheꞌ bitsow xi kin tʼajaꞌ ti jolib na kidhtaltsik ani tayíl, na kidhtaltsik neꞌech ka kale tajaꞌ ani neꞌech ti kin tʼójontsitsik ba jechéꞌ an chabál.” ");
INSERT INTO husNT2005_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Na Dios in tʼajaꞌ jun i lejkintaláb kʼal na Abraham ani utsan kin tʼajtsal jun i exól bin tʼuꞌúl an kwitól chakamtsik abal kin kóꞌoy ti exól kʼal tin kwenta an lejkintaláb. Jaxtám, tam ti waꞌchin ti chakam na Isák, na Abraham in tʼajtsi jun i exól bin tʼuꞌúl tam tin kidhbách waxik a kʼítsá ti waꞌchinék ti chakam. Anílkʼi jeye tin tʼajaꞌ na Isák kʼal nin chakámil Jakob ani na Jakob anílkʼi jeye tin tʼajaꞌ kʼal xi lajucháb nin chakámiltsik. Jechéꞌtsik, jaꞌich ni wejeꞌ pakélil. ");
INSERT INTO husNT2005_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","ʼJechéꞌ ni wejeꞌ pakéliltsik, in atʼaꞌ nin kidháb xin bij José ani in nujutsik abal ka júná ban chabál xi Ejipto. Por na Dios tajaꞌ ti kʼwajat junax kʼal na José ");
INSERT INTO husNT2005_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ani in tolmiy kʼal ejtal an yajtsiktaláb xin tametnaꞌ. In pidhaꞌ ti chalab ani in tolmiy abal kin bajaw ka kʼanidhá kʼal an Faraón. Jechéꞌ an Faraón, jaꞌich an pulek takʼix xi Ejipto, xi kʼál ti bijyat na José ti pulek awiltaláb abal ka takʼxin Ejipto ani abal ka takʼxin jeye bin kʼimáꞌ jechéꞌ an pulek takʼix. ");
INSERT INTO husNT2005_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","ʼWaꞌchin tám i kʼaꞌínab ani jun i yajtsiktaláb púlek, ban chabál xi Ejipto. Anchanꞌ jeye ti támun Kanán ani ni wejeꞌ pakéliltsik yabich in elál xantʼéy kin kʼapu. ");
INSERT INTO husNT2005_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Por tam ti na Jakob in achʼaꞌ abal waꞌach i trigo Ejipto, in abaꞌ tajaꞌ nin chakámiltsik, xi jaꞌich ni wejeꞌ pakéliltsik. Jechéꞌ jaꞌich an jidhtal bél xin tʼajaꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Tam ti kʼaletsik juní tin chabtal, na José in xalkʼaꞌ tinbáꞌ abal ka exlá kʼal nin kidhábtsik. Anchanꞌ tin choꞌóbnaꞌ an pulek takʼix xi Ejipto xitaꞌ kʼál tu kidhtaláb jeye na José. ");
INSERT INTO husNT2005_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","In abnaꞌ tám na José ka ikʼtat nin tátaꞌ Jakob ani ejtal nin kidhtaltsik, jajáꞌtsik ox inik lajubóꞌ ti éb. ");
INSERT INTO husNT2005_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Anchanꞌ ti támun, na Jakob kʼale ti kʼwajíl Ejipto xon ti chemech más tayíl ani xon ti chemechtsik jeye ni wejeꞌ pakéliltsik. ");
INSERT INTO husNT2005_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Más tayíl, júntsintsik an tin beklék Sikém ani joltsin ban jólimtaláb xi na Abraham in chʼayꞌtsámal nin chakámiltsik na Amor ban chabál xi Sikém. ");
INSERT INTO husNT2005_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","ʼTam ti kʼunatich an kʼij xowkʼi ti neꞌech ka támun xowaꞌ na Dios in lej tsubax utsámal na Abraham, an atiklábtsik xi Israel yanenekich tajaꞌ Ejipto. ");
INSERT INTO husNT2005_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Tujey tám ti takʼix tajaꞌ Ejipto jun i pulek takʼix xi yab u exláb kʼál na José. ");
INSERT INTO husNT2005_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Jechéꞌ an pulek takʼix, in kʼambiy ni kidhtaltsik ani tʼajtsintsik xan ti ka leꞌná ni wejeꞌ pakéliltsik. In tʼajaꞌ jeye abal kin walbaꞌ ka chemech nin chakámiltsik xi tsʼitsik. ");
INSERT INTO husNT2005_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Jachanꞌ i kʼij, tám jeye ti waꞌchin na Moisés. Jechéꞌ an chakam, kulbetná tʼajat kʼal na Dios ani tokot beletná óx a íchʼ bin kʼimáꞌ nin tátaꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Por tam ti an tátaꞌlábtsik in jilaꞌ, nin tsidhánil an pulek takʼix in penaꞌ ani in pubedhaꞌ jelti max jajáꞌ in chakámil. ");
INSERT INTO husNT2005_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Jaxtám, na Moisés okʼtsin ejtal xowaꞌ in choꞌób an atiklábtsik xi Ejipto in chabálil ani in kóꞌoy tʼajat i awiltaláb kʼal xowaꞌ in tʼajál ani kʼal xowaꞌ in ulal. ");
INSERT INTO husNT2005_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","ʼTam tin koꞌolich chab inik i tamub, na Moisés in leꞌnaꞌ ka kʼale kin álnaꞌ nin at kidhtaltsik, xi jaꞌich an israelitatsik. ");
INSERT INTO husNT2005_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ani in chuꞌu tajaꞌ ke jun i inik xi Ejipto in chabálil exom in atʼax tʼajtsal jun i israelita. Abal kin loꞌo ani abal kin tʼajtsi jayéchkʼi xowaꞌ exom in tʼajál, na Moisés in chemdhaꞌ jachanꞌ an inik xi Ejipto in chabálil. ");
INSERT INTO husNT2005_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Pos na Moisés in chalpayal ke ni at kidhtal, xi jaꞌich an israelitatsik, neꞌech kin exbaytsik ke jajáꞌ takudh kʼal na Dios abal kin walkaꞌ nin at kidhtal; por yab in exbaytsik. ");
INSERT INTO husNT2005_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Tam ti jun tsudhelom, na Moisés in elaꞌ cháb i at kidhtal ti péjéx ani kom in léꞌ kin chuꞌu yabich ka péjéxintsik, in utsaꞌtsik enchéꞌ: “Tatáꞌtsik a kidhábkʼitsik tabáꞌ; ¿jantʼókʼi ta atʼax tʼájtsíxtsik jún ani jún?” ");
INSERT INTO husNT2005_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Tám, xi kʼwajat in chaꞌwal nin at kidhtal nixíkʼlá kʼál na Moisés ani utsan enchéꞌ: “¿Jitaꞌ ti kʼwajbámal ta okʼlek ani ta lújundhom kʼal wawáꞌ? ");
INSERT INTO husNT2005_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿A léꞌxeꞌ neye ti kin chemdhaꞌ, jelt xan ta chemdhaꞌ ti weꞌél an inik xi techéꞌ Ejipto in chabálil?” ");
INSERT INTO husNT2005_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Tam tin achʼaꞌ jechéꞌ na Moisés, ájlách ani kʼale ban chabál xi Madián. Tajaꞌ ti kʼwajay jelti jun i píl inik ani in kóꞌoy cháb in chakámiltsik. ");
INSERT INTO husNT2005_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","ʼChab inik i tamub más tayíl, tam ti kʼwajat ban chabál xon ti yab kʼwajtsidh kʼunat ban chʼén xu bijyáb Sinaí, in chuꞌu jun i tʼokat abatwále bin kʼamálil jun i kʼidhadh teꞌ xi kʼwajat ti tʼaꞌíl. ");
INSERT INTO husNT2005_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Na Moisés laban tʼajat tam tin chuꞌu jechéꞌ an xalkʼantsixtaláb ani tam ti utey abal kin chuꞌu más alwaꞌ, in axtsi tin káwintal an Okʼóxláb. Enchéꞌ tin ulu an Okʼóxláb: ");
INSERT INTO husNT2005_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Nanáꞌ tin Diosil na wejeꞌ pakéliltsik, nin Diosil na Abraham, na Isák ani na Jakob.” Tujey tám na Moisés ti wipipíl kʼal i jíkʼib ani yab in léꞌ kin telaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Utsan tám enchéꞌ kʼal an Okʼóxláb: “Ka kʼotʼiy na pajab, pos an chabál xon ta kubat, jaꞌich jun i chabál xi tʼokat. ");
INSERT INTO husNT2005_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Nanáꞌ u chuꞌúmalich an yajtsiktaláb xi exom in achʼál Ejipto an atiklábtsik xu takwyám, xi jaꞌich na kidhtal, u achʼámich ti ejꞌéltsik ani in paꞌinek abal ku káldhaꞌichtsik tajaꞌ. Pos xoꞌ, jalaꞌich, neꞌech tu abaꞌ Ejipto.” ");
INSERT INTO husNT2005_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","ʼJechéꞌ na Moisés xi pojká ani utsan enchéꞌ kʼal an israelitatsik: “¿Jitaꞌ ti bijiy ta okʼlek ani ta lújundhax?”, jaꞌich aban kʼal na Dios jelti jun i pulek awiltaláb ani i walkax, kʼal an tʼokat abatwálekʼi xin chuꞌu taꞌ ti kʼwajat bin kʼamálil an kʼidhadh teꞌ xi kʼwajat ti tʼaꞌíl. ");
INSERT INTO husNT2005_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Jechéꞌ na Moisés, jaꞌich xin káldhaꞌ Ejipto ni wejeꞌ pakéliltsik ani xin tʼajaꞌ i labidh labandhaxtalábtsik ani i exóltsik tin nakíl chab inik i tamub ba jachanꞌ an chabál, ban Chak Pujal ani ban chabál xon ti yab kʼwajtsidh. ");
INSERT INTO husNT2005_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Jechéꞌ na Moisés jaꞌich xin utsaꞌ enchéꞌ an israelitatsik: “Na Dios neꞌech kin takuy jun i tʼiltsix xi wawáꞌ i kidhtal, jelt xan ti nanáꞌ tin takwyámal, ka exbantsitsik xowaꞌ jajáꞌ ti ki utsaꞌtsik.” ");
INSERT INTO husNT2005_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Na Moisés kʼwajay kʼal an atiklábtsik ban chabál xon ti yab kʼwajtsidh, tam ti junkuntsik ban chʼén xu bijyáb Sinaí. Tajaꞌ, utsan na Moisés kʼal an tʼokat abatwále kʼal tin kwenta an xeꞌchintaláb ani na Moisés, in watʼbantsi ni wejeꞌ pakéliltsik jechéꞌ xowaꞌ utsan. ");
INSERT INTO husNT2005_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","ʼPor ni wejeꞌ pakéliltsik yab in leꞌnaꞌ kin exbay, in pojkaꞌtsik tokot ani in léꞌtsikwiꞌik ka witsiy Ejipto, ");
INSERT INTO husNT2005_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","tam ti kʼwajat in utsáltsik enchéꞌ na Arón: “I léꞌ ti ku tʼajtsi ti diostsik xi ka okxin, pos yab i choꞌób xantʼéy in tamu na Moisés xi tu káldhaꞌ ban chabál xi Ejipto.” ");
INSERT INTO husNT2005_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","In tʼajaꞌtsik tám jun in chʼilábil i beserro kʼal i oro, in chemdhantsi ti koꞌnéltsik abal kin pikbantsi ani kulbétsik tʼajat kʼal xowaꞌ in tʼajámaltsik kʼal in kʼubak. ");
INSERT INTO husNT2005_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Wékʼon tám na Dios kʼal jajáꞌtsik ani walkátsik kin kʼakʼnaꞌ a óttsik xi waꞌach walkʼiꞌ. Pos anchanꞌ ti kʼwajat dhutsadh bin dhutsadh úwil an tʼiltsixtsik ke enchéꞌ ti utsan ni wejeꞌ pakéliltsik kʼal na Dios: ¿Awxeꞌ tatáꞌtsik, atiklábtsik xi Israel, a chemdhámal i koꞌnéltsik abal ti kin pikbantsi tin nakíl xi chab inik i tamub ban chabál xon ti yab kʼwajtsidh? ¡Yabaꞌ! ");
INSERT INTO husNT2005_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Tatáꞌtsik tokot a xeꞌchindhantsitsik tin ótʼ padhélil na dios Molok ani nin ótil na dios Renfán, i chʼilabtsik xa tʼajámaltsik abal ka kʼakʼnaꞌ. Jaxtám Nanáꞌ, neꞌech tu káldhaꞌtsik ba na chabálil ani neꞌech tu abnaꞌtsik más tuwaꞌ ké Babilonia. ");
INSERT INTO husNT2005_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","In óntsi ti káw na Esteban ani in ulu enchéꞌ: ―Tajaꞌ ban chabál xon ti yab kʼwajtsidh, ni wejeꞌ pakéliltsik taꞌ tin koꞌol an ótʼ padhel xon tin taꞌpál an tʼujubtsik xon ti kʼwajat dhutsadh nin takʼixtal na Dios. Jechéꞌ tʼajnék anchanꞌ xan ti na Dios tin utsaꞌ na Moisés, tam ti utsan kin tʼajaꞌ jelt xan ti óltsin. ");
INSERT INTO husNT2005_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ni wejeꞌ pakéliltsik in bachʼu jechéꞌ an ótʼ padhel jelti jun i jiltsixtaláb ani xi tsíchtsik kʼal na Josué, in tsiꞌdhaꞌ kʼal jajáꞌtsik tam tin kʼántsitsik an ti chabál an kʼeꞌet atiklábtsik, jaꞌich xin káldhaꞌtsik na Dios abal kin pidhaꞌ an ti chabál ni wejeꞌ pakéliltsik. Anchanꞌ ti tʼájan asta tam tin bajaw na Dabid. ");
INSERT INTO husNT2005_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Na Dios kulbé kʼal an pulek takʼix Dabid ani na Dabid in leꞌnaꞌ kin tʼajtsi jun i atá xon ti ka kʼwajay nin Diosil na Jakob; ");
INSERT INTO husNT2005_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","por na Salomón jaꞌich nin kubtsi tin kʼimáꞌ na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Por na Dios xi púlek tʼajat, yab u kʼwajíl ba atá xi tʼajadh kʼal i iniktsik. Jelt xan tin ulu an tʼiltsix enchéꞌ: ");
INSERT INTO husNT2005_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","An walkʼiꞌ jaꞌich nu tʼokat kʼwajtal ani an chabál, jaꞌich xon tu kubál nu akan. In ulu enchéꞌ an Okʼóxláb: ¿Janti uwats an atá xi neꞌech kin tʼajtsin? O ¿jónꞌ ti neꞌech ku ejto kin koyóch? ");
INSERT INTO husNT2005_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿Yabxeꞌ Nanáꞌ u tʼajámal kʼal u kʼubak ejtal jechéꞌ? ");
INSERT INTO husNT2005_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","In óntsi ti káw na Esteban ani in ulu enchéꞌ: ―Por tatáꞌtsik echʼekʼi tʼajat chapik na itsích ani a koꞌoltsik na ochʼoxtal ani na itsích jelti xi yab in exláltsik na Dios. Echʼekʼi a tomnáltsik an Tʼokat Ejattaláb. A junwaltsik jelti na wejeꞌ pakéliltsik. ");
INSERT INTO husNT2005_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","¿Jowaꞌ tʼiltsix yab atʼnék kʼal na wejeꞌ pakéliltsik? In chemdhaꞌtsik xi tsiꞌnek más okʼox kin tʼilaꞌ abal neꞌech ka tsích jachanꞌ xi lujat tʼajat ani xoꞌ tam ti ulich, a chinat pidhnaꞌtsik ani a chemdhaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Tatáꞌtsik xa bachʼu an takʼixtaláb kʼal an tʼokat abatwálekʼi, yab a tʼajáltsik ti kʼij. ");
INSERT INTO husNT2005_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Tam ti jajáꞌtsik in achʼaꞌ ejtal jechéꞌ, in chakuntsitsik tʼajat na Esteban ke asta u rechʼechʼéltsik nin kamab kʼal i chákub. ");
INSERT INTO husNT2005_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Por na Esteban, teykómte kʼal nin cháp an Tʼokat Ejattaláb, in teloloy walkʼiꞌ, in chuꞌtsi tin labidh tʼokát na Dios ani in chuꞌu jeye na Jesús tin eját na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","In ulu tám enchéꞌ: ―¡Ka telaꞌtsik! U chuꞌtal jebél an walkʼiꞌ ani u chuꞌtal na Jesús xi aban abal ka wenkʼon jeye ti inik kʼwajat tin eját na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Por jajáꞌtsik in tsʼutsʼkʼiy nin xuchun ani u dhajnaltsik kawidh, tujeytsik tám kin nixkʼaꞌ na Esteban. ");
INSERT INTO husNT2005_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Káldhá ban bitsow ani exmách ti tʼujbayáb. An ólnaxtsik xin tʼajaꞌ jechéꞌ, in jilaꞌ nin xekét ka beletnantsat kʼal jun i kwitól inik xin bij ta Sawlo. ");
INSERT INTO husNT2005_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Lejat kʼwajat ti tʼujbayáb, na Esteban ólan ani in ulu enchéꞌ: ―Ajátik Jesús, ka bachʼu nu ejattal. ");
INSERT INTO husNT2005_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Tayíl tudhlan ani in ulu kawidh enchéꞌ: ―Ajátik, ka pakwlantsitsik an tin walastalábil xi exom in tʼajál. Tam ti okʼonich kin ulu jechéꞌ, chemech. ");
INSERT INTO husNT2005_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Na Sawlo in ulu jeye abal alwaꞌ ka chemdhá na Esteban. Támkʼi jachanꞌ a kʼítsá, tujey tʼajat ti atʼnal an belomtsik xi Jerusalén. Ejtalkʼi an belomtsik atʼan, jaxtám ti bukʼeytsik ban chabál xi Judea ani xi Samaria. Tokot an abatwáletsik yab atʼan, jaxtám ti jilkʼontsik jaꞌ Jerusalén. ");
INSERT INTO husNT2005_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Taltsik an iniktsik xin wéwnáltsik tʼajat xan tin ulal nin takʼixtal na Dios, in júnaꞌ kin joliy na Esteban ani in ukʼintsitsik tʼajat abal chemdhá. ");
INSERT INTO husNT2005_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Tam ti jachanꞌ, na Sawlo in áynál an belomtsik, u ochel ban atátsik abal kin káldhaꞌ bodhodhól an payꞌlomlábtsik ani an mímlábtsik ani in júnál kin baliy al wikʼaxteꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Por xi kaletsik ban bitsow Jerusalén, in tʼiláltsik an alwaꞌ tʼilab xontikʼi ti xeꞌechtsik. ");
INSERT INTO husNT2005_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Jún ti éb xi jajáꞌtsik, xin bij ta Felipe, kʼale ba jun i bitsow xu takʼnal Samaria ani in tuju kin tʼiltsitsik an ta Kristo. ");
INSERT INTO husNT2005_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","An atiklábtsik u junkunal ani ejtal in achʼáltsik kʼal yantam i kwenta xowaꞌ in ulal na Felipe ani in chuꞌtaltsik jeye an labidh labandhaxtalábtsik xin tʼajál jechéꞌ na Felipe. ");
INSERT INTO husNT2005_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Pos yán i atiklábtsik xi ochadh kʼal i atʼax ejattalábtsik, u jeldháb ani an atʼax ejattalábtsik u dhajnal u kalel ba jajáꞌtsik ani yán xi yab in ejtowal ka yoyon ani xu kʼwechʼeꞌtsik, u jeldháb. ");
INSERT INTO husNT2005_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ejtal an atiklábtsik xu kʼwajíl ba jachanꞌ an bitsow u kulbéltsik tʼajat kʼal jechéꞌ xowaꞌ in chuꞌtal. ");
INSERT INTO husNT2005_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Por taꞌ ti kʼwajat ba jachanꞌ an bitsow jun i inik xu bijyáb ta Simón. Jechéꞌ an inik, jaꞌich jun i dhiman ani in kʼambiyal an atiklábtsik xi tajaꞌ Samaria. In ulal ke jajáꞌ jaꞌich jun i chalpadh inik. ");
INSERT INTO husNT2005_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Kʼal ejtaltsik tu axtsinal xowaꞌ jajáꞌ in ulal, kʼal xi tsʼitsik ani asta kʼal xi pakdhaꞌtsik ani in ulaltsik enchéꞌ: ―Jechéꞌ an inik, jaꞌich nin pulek cháp na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","U beltsinal tʼajat xowaꞌ in ulal ani in tʼajál, pos kʼal nin dhimantal, nakatich tʼajat i kʼij tin kóꞌyámal kʼambidhtsik. ");
INSERT INTO husNT2005_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Tam ti na Felipe xeꞌech in tʼilál na Jesukristo ani an alwaꞌ tʼilab kʼal tin kwenta xan tu takʼix na Dios, yán i payꞌlomlábtsik ani i mímlábtsik belmách ani pujantsik. ");
INSERT INTO husNT2005_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Na Simón xu dhimanwiꞌik, belmách jeye ani pujan ani xeꞌchin kʼal na Felipe. Tam in chuꞌtal an pakdhaꞌ labidh labandhaxtaláb ani an exóltsik xu tʼájnal, u labnal tʼajat. ");
INSERT INTO husNT2005_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Tam ti an abatwáletsik xi kʼwajat Jerusalén in choꞌóbnaꞌ ke xu kʼwajíltsik Samaria in bachʼúmalichtsik nin káwintal na Dios, aban tajaꞌ na Pedro ani na Juan. ");
INSERT INTO husNT2005_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Tam ti na Pedro ani na Juan ulichtsik tajaꞌ, ólantsik kʼal tin kwenta an belomtsik xi Samaria abal kin bachʼutsik an Tʼokat Ejattaláb. ");
INSERT INTO husNT2005_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Pos an belomtsik xi Samaria, yabél in bachʼúmaltsik an Tʼokat Ejattaláb, tokot pujadhtsik tin bij an Ajátikláb Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Na Pedro ani na Juan in kʼwajbaꞌtsik nin kʼubak bin éb an belomtsik ani in bachʼu tám an Tʼokat Ejattaláb an belomtsik. ");
INSERT INTO husNT2005_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Tam ti na Simón in chuꞌu ke an belomtsik in bachʼu an Tʼokat Ejattaláb tam ti an abatwáletsik in kʼwajbaꞌ nin kʼubak bin éb an belomtsik, in leꞌnaꞌ kin chʼaꞌay jechéꞌ an awiltaláb, ");
INSERT INTO husNT2005_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","in ulu enchéꞌ: ―Ti kin pidhaꞌ neye jachanꞌ an ti awiltaláb abal tam ku kʼwajbantsi an tu kʼubak bin éb jun xitaꞌ, kin bachʼu jeye an Tʼokat Ejattaláb. ");
INSERT INTO husNT2005_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Utsan tám enchéꞌ kʼal na Pedro: ―Ka kʼibchon na tumínal junax kʼal tatáꞌ abal a chalpayal ke xowaꞌ in pidhnál na Dios, neꞌech ka ejto ka chʼaꞌay kʼal i tumín. ");
INSERT INTO husNT2005_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Tatáꞌ yab a koꞌol ni jun xataꞌ xantʼéy ka chuꞌu kʼal jechéꞌ, pos na ejattal yab kʼwajat lujat tin tamét na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Ka jilaꞌich jechéꞌ an walastaláb xa koꞌol ani ka pakabédhaꞌ na Dios abal ka chuꞌu max anchanꞌ ti ki pakwlantsi kʼal xowaꞌ a chalpay ta ejattal. ");
INSERT INTO husNT2005_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Pos u chuꞌtal ke yab tʼajat alwaꞌ na chalab a koꞌol ani i teykómte tʼajat ta kʼwajat kʼal an walastaláb. ");
INSERT INTO husNT2005_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Tókʼon tám enchéꞌ na Simón: ―Ti kin kontsintsi neye ban Okʼóxláb abal yab ku tamu ni jun xataꞌ xowaꞌ i kʼwajat tin utsál. ");
INSERT INTO husNT2005_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Tam ti okʼonichtsik kin ólnaꞌ ani kin tʼilaꞌ nin káwintal na Dios, an abatwáletsik kʼale jeye kin tʼilaꞌ an alwaꞌ tʼilab ba yán i kwentsaltsik xi Samaria ani tayíl witsíchtsik tám juní Jerusalén. ");
INSERT INTO husNT2005_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Más tayíl, utsan enchéꞌ na Felipe kʼal jun in tʼokat abatwálejil an Ajátikláb: ―Ki chʼakay ani ki kʼale alál, ka yakʼwaꞌ an bél xi tál Jerusalén ani neꞌech Gasa. Jechéꞌ an bél, jaꞌich xu watʼel ban chabál xon ti yab kʼwajtsidh. ");
INSERT INTO husNT2005_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Chʼakay tám na Felipe ani kʼale; ti bél, in elaꞌ jun i inik xu kʼwajíl Etiopía. Jajáꞌ jaꞌich jun i inik xu ewnuko. Jechéꞌ jaꞌich jun i pulek tʼójodh, pos jajáꞌ in belkómtsal tin tumínal na Kandase, an pulek takʼix mímláb xi Etiopía, jajáꞌ kʼalnek Jerusalén abal kin kʼakʼnaꞌ na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Jechéꞌ an inik u witsélich bin pulek bitsówil, punat bin karretajil ani kʼwajat in ajyal nin dhutsadh úwil an tʼiltsix Isaías. ");
INSERT INTO husNT2005_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Utsan tam enchéꞌ na Felipe kʼal an Tʼokat Ejattaláb: ―Ki utey ban karreta ani ki beley junax kʼal jechéꞌ an inik. ");
INSERT INTO husNT2005_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Tam ti utey na Felipe, in achʼaꞌ ke jachanꞌ an inik kʼwajat in ajyal nin dhutsadh úwil an tʼiltsix Isaías ani in konoy enchéꞌ: ―¿A exbayalxeꞌ xowaꞌ i kʼwajat a ajyal? ");
INSERT INTO husNT2005_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Tókʼoyat enchéꞌ kʼal an inik: ―¿Janti neꞌech ku ejto ku exbay max yab waꞌach ni jun xitaꞌ ti kin wiltsi? Ani pakabédhá na Felipe kʼal an inik abal ka kʼadhiy ani ka buxkan junax kʼal jajáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","An Tʼokat Dhuslab xi kʼwajat in ajyal, jaꞌich jechéꞌ: Júná abal ka chemdhá jelti jun i borrego. Anchanꞌ jelti an borrego yab u kʼuxnal tin tamét an inik xi kʼál ti kʼwajat ti kaxwáb, anchanꞌ jeye Jajáꞌ yab kʼuchun ní wéꞌ abal kin ulu xataꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Tʼajan jelti max yab xataꞌ in éy ani yab lújundhá jelt xan tin ulal an takʼixtaláb. Kom chemdhá ani yab in jilaꞌ ni jun in kuxúl, ¿jitaꞌ kʼál ti neꞌech ka ejtowat ka tʼilan? Abal nin xeꞌchintal wékʼoyat techéꞌ ti kʼayꞌlá. ");
INSERT INTO husNT2005_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Konyat tám na Felipe enchéꞌ kʼal jachanꞌ an tʼójodh inik: ―Tu kontsal ti alwaꞌtaláb abal ti kin utsaꞌ, ¿jitaꞌ kʼwajat in tʼilál jechéꞌ an tʼiltsix, jajáꞌ in tʼilál tinbáꞌ o kʼeꞌet in tʼilál? ");
INSERT INTO husNT2005_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","In tuju tám na Felipe kin wiltsi xon ti kʼwajat in ajyal ban Tʼokat Dhuslab ani in tʼiltsi an ti alwaꞌ tʼilab kʼal tin kwenta na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Tam ti neꞌechtsik ti belal, ulichtsik xon ti waꞌach i jaꞌ ani an tʼójodh inik in ulu enchéꞌ: ―Techéꞌ waꞌach i jaꞌ, ¿awxeꞌ yab awil kin pujyat neye? ");
INSERT INTO husNT2005_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Utsan enchéꞌ kʼal na Felipe: ―Max a belál lejtal kʼal ejtal na ejattal na Jesukristo, awil ki pujan. An inik tókʼon enchéꞌ: ―U belál abal na Jesukristo jaꞌich nu Chakámláb kʼal na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","In ulu tám ka kubdhá an karreta, paꞌay chablam ti éb ban jaꞌ ani pujyat kʼal na Felipe. ");
INSERT INTO husNT2005_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Tam ti kaletsik ban jaꞌ, júnájich tám na Felipe kʼal nin Tʼokat Ejattal an Ajátikláb ani yab más witsiy ka chuꞌtat kʼal jachanꞌ an tʼójodh inik; por u kulbél tʼajat an tʼójodh inik tam tin óntsích nin bélil. ");
INSERT INTO husNT2005_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Tayíl, jun jikʼtowál tin chuꞌu na Felipe abal Asotojich ti kʼwajat ani watʼey bitsow ti bitsow ti tʼiltsix an ti alwaꞌ tʼilab, asta ti ulich Sesarea. ");
INSERT INTO husNT2005_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Tam ti jachanꞌ, na Sawlo in óntsal kin ulu abal neꞌech kin chemdhaꞌ xin belálichtsik an Ajátikláb. Jaxtám ti kʼale kin chuꞌu nin okʼlékil an páleꞌtsik, ");
INSERT INTO husNT2005_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","abal kin kontsi ti awiltaláb ka pidhan ka kʼale ban atátsik xon tu tʼajnal an junkuntaláb xi Damasko abal kin aliy xin belálichtsik an alwaꞌ tʼilab ani kin tsiꞌdhaꞌ ti wikʼnél Jerusalén; i payꞌlomlábtsik ani i mímlábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Por tam ti neꞌech ti bél ani u kʼunelich ban bitsow xi Damasko, jun jikʼtowál ti wiliyat kʼal jun i chʼaxixíl kʼamal xi tál walkʼiꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Kwajlan tám na Sawlo chabál ani in achʼaꞌ jun i káwintaláb, xu káw in ulu enchéꞌ: ―Sawlo, Sawlo, ¿jantʼókʼi tin atʼál? ");
INSERT INTO husNT2005_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Konoxin jeye tám na Sawlo enchéꞌ: ―¿Jitaꞌ pé teye, jaꞌúb? Ani tókʼoyat enchéꞌ kʼal xi kʼwajat ti káw: ―Nanáꞌ in Jesús, xi tatáꞌ a atʼál. Exom a yajlombédhál tatáꞌkʼi tabáꞌ, jelt xan tin tʼajál an koꞌnél tam in chochbiyal an chʼupidh patʼál. ");
INSERT INTO husNT2005_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","In ulu tám enchéꞌ na Sawlo u wipipíl kʼal i jíkʼib: ―Ajátik, ¿jantʼéy a léꞌ ku tʼajaꞌ? Utsan enchéꞌ kʼal an Ajátikláb: ―Ki chʼakách ani ki ulchich ban bitsow ani tajaꞌ neꞌech ki utsan xantʼéy yejat ka tʼajaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","An iniktsik xi junax ti neꞌech kʼal na Sawlo, labnéktsik tʼajat abal in achʼáltsik an káwintaláb por yab in chuꞌtaltsik xitaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Chʼakay tám na Sawlo ban chabál xon ti kwachat, por tam tin lamaꞌ nin wal, yab in chuꞌtal ni jun xataꞌ. Jaxtám ti lotʼokʼná ani júná Damasko. ");
INSERT INTO husNT2005_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Kʼwajay tajaꞌ óx a kʼítsá yab u chuꞌux, yab u kʼapul nibal xataꞌ in uchʼál. ");
INSERT INTO husNT2005_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Tajaꞌ Damasko, taꞌ ti kʼwajat jun i inik xu belom tʼajat xu bijyáb ta Ananías, xi utsan enchéꞌ kʼal an Ajátikláb ba jun i xalkʼantsixtaláb: ―¡Ananías! Ani jajáꞌ tókʼon enchéꞌ: ―Jeꞌtám in kʼwajat, Ajátik. ");
INSERT INTO husNT2005_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Utsan tám enchéꞌ kʼal an Ajátikláb: ―Ki chʼakay, ki kʼale ban bél xu bijyáb Eját ani ka konoy bin kʼimáꞌ na Judas max taꞌ kʼwajat tajaꞌ jun i inik xu bijyáb ta Sawlo xu kʼwajíl Tarso. Táꞌ kʼwajat ti ól ");
INSERT INTO husNT2005_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","ani ba jun i xalkʼantsixtaláb, in chuꞌúmal ke jun i inik xin bij Ananías neꞌech ka ochich xon ti jajáꞌ kʼwajat ani neꞌech kin kʼwajbaꞌ nin kʼubak bin éb jajáꞌ abal ka chuꞌxindhá juní. ");
INSERT INTO husNT2005_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Tam tin achʼaꞌ jechéꞌ na Ananías, in ulu enchéꞌ: ―Ajátik, kʼal yánich tin tʼiltsidh xantʼéy in tʼajál jachanꞌ an inik ani in tʼiltsidhich jeye ejtal an atʼaxtaláb xin tʼajtsal xi ti belálichtsik xu kʼwajíl Jerusalén. ");
INSERT INTO husNT2005_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Xoꞌ tsiꞌnek techéꞌ Damasko ani in kontsám ti awiltaláb an okʼlek páleꞌtsik abal kin yakʼwaꞌ ejtal xi ti belálichtsik. ");
INSERT INTO husNT2005_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Por utsan enchéꞌ kʼal an Ajátikláb: ―Ki kʼale, pos Nanáꞌ u takwyámal jachanꞌ an inik abal ti kin tʼilaꞌ ban atiklábtsik xi yab u judío, ban pulek takʼixtsik ani ban israelitatsik jeye. ");
INSERT INTO husNT2005_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Nanáꞌ neꞌech ku óltsi ejtal an ti yajtsiktaláb xi yejat kin watʼnaꞌ kʼal Nanáꞌ tu kwenta. ");
INSERT INTO husNT2005_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Kʼale tám na Ananías ban atá xon ti kʼwajat na Sawlo. Tam ti ochich, in kʼwajbaꞌ nin kʼubak bin éb na Sawlo ani in utsaꞌ enchéꞌ: ―Kidhábláb Sawlo, an Ajátikláb Jesús, xin xalkʼaꞌ tinbáꞌ ti bél xon ta tál abal ka chuꞌu, tin abámal abal tu chuꞌxindhaꞌ juní ani abal ka bachʼu jeye nin cháp an Tʼokat Ejattaláb. ");
INSERT INTO husNT2005_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Támkʼi jachanꞌ ti kwajlan jun xataꞌ xi pitʼkʼan bin wal jelt in otʼól i toꞌol ani chuꞌxinich tám juní. Chʼakách tám na Sawlo ani pujyatich jeye tám. ");
INSERT INTO husNT2005_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Tayíl kʼapúch ani likey tám juní ani kʼwajay cháb óx a kʼítsá tajaꞌ kʼal an belomtsik xu kʼwajíl tajaꞌ Damasko. ");
INSERT INTO husNT2005_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Más tayíl, in tujúch tám na Sawlo ti okʼtsix ban atátsik xon tu tʼajnal an junkuntaláb, in ulal ke na Jesús jaꞌich nu Chakámláb kʼal na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ejtaltsik xi kʼál tu axnal, u labnaltsik tʼajat ani in ulaltsik enchéꞌ: ―¿Yabxeꞌ jaꞌich jechéꞌ an inik xi xeꞌchinék Jerusalén in atʼax tʼajtsal xin beláltsik na Jesús? ¿Yabxeꞌ jaxtám ti tsiꞌnek jeye techéꞌ abal kin yakʼwaꞌ an belomtsik ani kin júnaꞌ abal kin pidhnaꞌ ban okʼlek páleꞌtsik? ");
INSERT INTO husNT2005_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Por na Sawlo u okʼtsix kʼal yán más i awiltaláb ani in ólnál ke na Jesús jaꞌich xi takudh kʼal na Dios abal ti loꞌox, asta in ukʼpindhál an judíotsik xu kʼwajíl tajaꞌ Damasko. ");
INSERT INTO husNT2005_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Tam ti watʼenekich yán a kʼítsá, an judíotsik in tʼajaꞌ i káw abal kin chemdhaꞌ na Sawlo; ");
INSERT INTO husNT2005_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","por na Sawlo in choꞌóbnaꞌ xantʼéy tu leꞌnáb ka tʼajtsin. Akal i kʼij an judíotsik u kʼwajíl kin aytsi na Sawlo bin wiꞌlébiltsik an bitsow abal kin chemdhaꞌ; ");
INSERT INTO husNT2005_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","por an belomtsik, in baliy na Sawlo ba jun i tʼoknal púlek ani in káldhaꞌ rechechél bin kúx in mapúl an bitsow tam ti jikʼwax. Anchanꞌ ti káldhá na Sawlo ba jachanꞌ an bitsow. ");
INSERT INTO husNT2005_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Tam ti na Sawlo ulich Jerusalén, in leꞌnaꞌ ka junkun kʼal an belomtsik; por kʼal ejtaltsik tu jikʼnáb abal yab u belnal max jajáꞌ u belomich jeye. ");
INSERT INTO husNT2005_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Por júná kʼal na Bernabé abal ka utwat ban abatwáletsik. Na Bernabé in tʼiltsitsik xan ti na Sawlo tin chuꞌúmal an Ajátikláb ti bél, xan ti jeye ti tawná kʼal an Ajátikláb ani xan ti na Sawlo ti okʼtsixnék Damasko kʼal yantam i awiltaláb kʼal tin bij na Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Kʼwajay tám Jerusalén na Sawlo ani xeꞌchin junax kʼal jajáꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","U káw kʼal yantam i awiltaláb tin bij an Ajátikláb, u tʼilolól ani u káwlíx kʼal an judíotsik xu tʼilom griego; por u leꞌnáb ka chemdhá kʼal jechéꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Tam ti an kidháblábtsik in choꞌóbnaꞌ jechéꞌ, júná Sesarea na Sawlo ani tam ti tajaꞌich ti kʼwajat, aban Tarso. ");
INSERT INTO husNT2005_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Tam ti jachanꞌ, ejtal an belomtsik xi ban chabál xi Judea, xi Galilea ani xi Samaria, kʼijidhtsik tʼajat ti kʼwajat ani u likeltsik. In koꞌoltsik nin belomtal ban Ajátikláb ani kʼal tin cháp an Tʼokat Ejattaláb, tsudhey ka tsudhey u waꞌchinal más xin belálich an Ajátikláb. ");
INSERT INTO husNT2005_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Tam ti na Pedro xeꞌchin ti álnax an ti kidháblábtsik, kʼale jeye kin álnaꞌ an kidháblábtsik xu kʼwajíl Lida. ");
INSERT INTO husNT2005_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","In elaꞌ tajaꞌ jun i inik xin bij ta Eneas, xin koꞌolich waxik i tamub ti kwachíl, kom yab in ejtowal ti belal. ");
INSERT INTO husNT2005_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ani utsan enchéꞌ kʼal na Pedro: ―Eneas, na Jesukristo neꞌech ti ki jeldhaꞌ. Ki chʼakay ani ka dhayaꞌ na waytal. Na Eneas támkʼi ti chʼakay ");
INSERT INTO husNT2005_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","ani chuꞌtat kʼal ejtaltsik xu kʼwajíl Lida ani Sarón, in jilaꞌichtsik tám nin wejeꞌ belomtalábiltsik ani in belaꞌich an Ajátikláb. ");
INSERT INTO husNT2005_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Tam ti jachanꞌ i kʼij, taꞌ ti kʼwajat ban bitsow xu bijyáb Jope jun i mímláb xu belom tʼajat xu bijyáb Tabita, ke ti káwintaláb griego, u ulwáb Dorkas. Jechéꞌ an mímláb echʼekʼi in tʼajál xowaꞌ alwaꞌ ani in tolmiyal an chʼojontáltsik. ");
INSERT INTO husNT2005_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Tam ti jachanꞌ i kʼij, yawꞌlách ani chemech. Tam ti okʼonich ti tʼaknal, kʼwajbá ba jun i altá xi kʼwajat tʼekʼat ba jun i púntsíx atá. ");
INSERT INTO husNT2005_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","An bitsow xi Jope, kʼunat ti kʼwajat Lida, xon ti kʼwajat na Pedro tam ti jachanꞌ i kʼij. Kom an belomtsik in choꞌóbnaꞌ abal tajaꞌ ti kʼwajat na Pedro, in abnaꞌ ka pakabédhá enchéꞌ kʼal cháb i iniktsik: ―Ki tsích dhubat ban bitsow xi Jope. ");
INSERT INTO husNT2005_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Kʼale tám na Pedro junax kʼal jajáꞌtsik. Tam ti ulchich, júná ban altá xon ti kʼwajat an chemélom ani kʼal ejtal an chemtsidh mímlábtsik ti wiliyat, u ukʼnaltsik ani in ólnáltsik nin lakab ani nin xekéttsik xi tʼajtsidh kʼal na Dorkas tam ti ejat. ");
INSERT INTO husNT2005_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Utsantsik tám kʼal na Pedro abal ka kaletsik ejtal, tudhlan tám ani ólan ani in teltóm an mímláb xi chemnek, in ulu enchéꞌ: ―Tabita, ki chʼakay. In lamaꞌ tám nin wal an mímláb ani tam ti chuꞌtat na Pedro, buxkan an mímláb. ");
INSERT INTO husNT2005_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","In téynaꞌ tám bin kʼubak ani in dhayaꞌ. In kaniy tám an kidháblábtsik ani an chemtsidh mímlábtsik ani chuꞌtatich tám abal ejnek ti ít jachanꞌ an mímláb. ");
INSERT INTO husNT2005_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ejtal jechéꞌ, choꞌóbná putál ban bitsow xi Jope ani kʼal yán ti belan an Ajátikláb. ");
INSERT INTO husNT2005_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Na Pedro kʼwajay yán a kʼítsá ba jachanꞌ an bitsow, bin kʼimáꞌ jun i inik xin lejkiyal i ótʼ, jechéꞌ an inik, u bijyáb ta Simón. ");
INSERT INTO husNT2005_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Táꞌ ti kʼwajat ban bitsow Sesarea jun i inik xin bij ta Kornelio, jajáꞌ jaꞌich jun i okʼlek xin takʼyal boꞌ inik i soldadotsik, jechéꞌ an kweneꞌ u bijyáb Italiano. ");
INSERT INTO husNT2005_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Jajáꞌ ani ejtal nin kidhtaltsik in kʼakʼnál na Dios ani in jikʼnál abal in choꞌóbtsik ke na Dios ejtal in ejtowal kin tʼajaꞌ. In pidhnál jeye yandhaꞌ i tumín abal kin tolmiy an judíotsik ani echʼekʼi in ólantsal a Dios. ");
INSERT INTO husNT2005_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Jun i kʼij, tam ti óxich xónaꞌ i wákal, in chuꞌu jun i xalkʼantsixtaláb. Ba jechéꞌ an xalkʼantsixtaláb, in chuꞌu ke jun in tʼokat abatwálejil a Dios ochich xon ti jajáꞌ kʼwajat ani utsan enchéꞌ: ―¡Kornelio! ");
INSERT INTO husNT2005_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Na Kornelio jilkʼon in telál an tʼokat abatwále kʼal yantam i jíkʼib ani in konoy enchéꞌ: ―¿Jantʼéy, Ajátik? Utsan tám enchéꞌ kʼal an tʼokat abatwále: ―Na Dios in achʼámalich an ólábtsik ani in chuꞌúmich xowaꞌ a tʼajál jeye abal ka tolmiy an chʼojontáltsik. ");
INSERT INTO husNT2005_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Pos ka abaꞌ xoꞌ i iniktsik ban bitsow xi Jope abal kin kaniy na Simón, xu bijyáb jeye ta Pedro. ");
INSERT INTO husNT2005_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Jajáꞌ taꞌ kʼwajat bin kʼimáꞌ jun i inik xu bijyáb jeye ta Simón, an inik xu lejkix ótʼ ani in koꞌol nin kʼimáꞌ bin wál i pujal. Na Simón Pedro neꞌech ti ki utsaꞌ xantʼéy yejat ka tʼajaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Tam ti kʼaléch an tʼokat abatwále xi kʼál ti tawná, na Kornelio in kaniy cháb nin tʼojnáliltsik ani in kaniy jeye jun i soldado, jechéꞌ jaꞌich jun i inik xin belál jeye tʼajat na Dios jelti na Kornelio ani alwaꞌ inik tʼajat. ");
INSERT INTO husNT2005_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","In tʼiltsitsik ejtal xowaꞌ in chuꞌúmal ani in abaꞌtsik Jope. ");
INSERT INTO husNT2005_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Tam ti jun tsudhelom, lejat jajáꞌtsik neꞌech ti bél ani exomich ti kʼunel Jope, na Pedro kʼadhiy bin éb an atá tam ti chʼejelich xónaꞌ a kʼítsá abal ti ól. ");
INSERT INTO husNT2005_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Kʼaꞌay tʼajat ani in leꞌnaꞌ ti kʼapul, por lejat kʼwajat ti lejkintsáb xantʼéy kin kʼapu, in chuꞌu jun i xalkʼantsixtaláb. ");
INSERT INTO husNT2005_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","In chuꞌu jakʼpin an walkʼiꞌ ani in chuꞌu ti paꞌíl jun xataꞌ xin junwal jelti jun i kʼudhkʼum púlek xi wikʼats tamatkʼi. ");
INSERT INTO husNT2005_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ban kʼudhkʼum, taꞌ ti kʼwajat yán i koꞌnéltsik xi cheꞌtsik in akan, i chantsik ani i chʼichintsik. ");
INSERT INTO husNT2005_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","In achʼaꞌ jun i káwintaláb xi utsan kʼál enchéꞌ: ―Pedro, ki chʼakay, ka chemdhaꞌ ani ka kʼapu. ");
INSERT INTO husNT2005_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Por na Pedro tókʼon enchéꞌ: ―Yabaꞌ, Ajátik; nanáꞌ yab jaykʼi u kʼapúmal ni jun xataꞌ xowaꞌ Tatáꞌ a ulúmal ke yab yejat ka kʼapat. ");
INSERT INTO husNT2005_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Tawná tám juní kʼal jachanꞌ an káwintaláb ani utsan enchéꞌ: ―Xowaꞌ Nanáꞌ u tʼokómal, yab yejat ka bijiy atʼax. ");
INSERT INTO husNT2005_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Óxíl tʼájan jechéꞌ ani tayíl kʼadhbájich tám juní walkʼiꞌ an kʼudhkʼum. ");
INSERT INTO husNT2005_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Lejat na Pedro kʼwajat ti chalpax xantʼéy in léꞌ kin ulu jachanꞌ an xalkʼantsixtaláb, ulich ban wiꞌleb nin tʼojnáliltsik na Kornelio, xi táltsik in konówiyal xon ti kʼwajat nin kʼimáꞌ na Simón. ");
INSERT INTO husNT2005_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Tam ti ulichtsik, in konoytsik kawidh max taꞌ ti kʼwajat ba jachanꞌ an atá jun i inik xin bij Simón ani u bijyáb jeye ta Pedro. ");
INSERT INTO husNT2005_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Kom na Pedro bél kʼwajat ti chalpax kʼal tin kwenta an xalkʼantsixtaláb, utsan enchéꞌ kʼal an Tʼokat Ejattaláb: ―Náꞌ kʼwajat ti ayal óx i iniktsik. ");
INSERT INTO husNT2005_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Ki paꞌay, ki kʼale kʼal jajáꞌtsik ani yab ki kʼwajay ta chalpax, pos Nanáꞌ u abámaltsik. ");
INSERT INTO husNT2005_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Paꞌay tám na Pedro xon ti kʼwajat an iniktsik xi abnék kʼal na Kornelio ani in utsaꞌtsik enchéꞌ: ―Nanáꞌich xitaꞌ i xeꞌechtsik a ayal. ¿Jantʼéy a léꞌ ta tsiꞌnektsik? ");
INSERT INTO husNT2005_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Tókʼontsik enchéꞌ: ―U tsiꞌnek abal u abnék kʼal an okʼlek soldadotsik xu bijyáb ta Kornelio. Jajáꞌ jaꞌich jun i lujat inik xin belál a Dios, xu kʼakʼnáb ani u kʼanidháb tʼajat kʼal ejtal na at kidhtaltsik. Usnék kʼal jun in tʼokat abatwálejil na Dios abal yejat ti kaniy ki kʼale tin kʼimáꞌ ani kin achʼaꞌ xowaꞌ neꞌech ka utsaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Utsantsik tám kʼal na Pedro abal ka ochichtsik ani tajaꞌ ti jilkʼontsik kʼal jajáꞌ jachanꞌ i akal. Tam ti tsudhey, na Pedro kʼaléch tám kʼal jajáꞌtsik ani junikná kʼal cháb óx i kidháblábtsik xu kʼwajíl Jope. ");
INSERT INTO husNT2005_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Tam ti jun tsudhelom, ulichtsik Sesarea, xon ti kʼwajat aytsímte kʼal na Kornelio junax kʼal jun kweneꞌ in exlowáltsik ani nin jaꞌúbtsik xin kanyámal na Kornelio. ");
INSERT INTO husNT2005_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Tam ti na Pedro ulich ban atá, kale ti bachʼwáb kʼal na Kornelio, tudhlan tin tamét na Pedro ani in kʼakʼnaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Por dhayan kʼal na Pedro ani utsan enchéꞌ: ―Ki chʼakay, pos jayéchkʼi neye jun i inik jelti tatáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Lejat u tʼilolóltsik, ochich altá ani in elaꞌ tajaꞌ yán i atiklábtsik xi junkunék. ");
INSERT INTO husNT2005_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Utsantsik tám enchéꞌ kʼal na Pedro: ―Tatáꞌtsik a choꞌób ke nin belomtal an judíotsik in ulal ke yab alwaꞌ ka junkun jun i judío kʼal jun i píl inik o ka ochich bin kʼimáꞌ an píl inik. Por na Dios tin óltsámalich ke yab in tomnál ku bijiy atʼax o yab alwaꞌ ni jun xitaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Jaxtám, tokot tin kanyat, in tsích ani yab in kʼwajay tin chalpax. Pos xoꞌ u léꞌ ku choꞌóbnaꞌ xantʼókʼi tin kanyámaltsik. ");
INSERT INTO husNT2005_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Tókʼon tám enchéꞌ na Kornelio: ―In koꞌolich chéꞌ a kʼítsá, enchéꞌ xónaꞌ i ora, in kʼwajat tin kʼíl techéꞌ tu kʼimáꞌ ani tin ól xin kwenta an wákal ani in xalkʼantsat abal ku chuꞌu jun i inik xi xeketlidh kʼal jun i chʼaxixíl kʼudhkʼum. ");
INSERT INTO husNT2005_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Ani tin utsaꞌ enchéꞌ: “Kornelio, na Dios in achʼámalich na ólábil ani in chuꞌúmalich xowaꞌ a tʼajál abal ka tolmiy an chʼojontáltsik. ");
INSERT INTO husNT2005_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Pos ka abaꞌ xoꞌ na tʼojnáliltsik ban bitsow xin bij Jope abal kin kaniy na Simón, xu bijyáb jeye ta Pedro. Táꞌ kʼwajat bin kʼimáꞌ na Simón, an inik xu lejkix ótʼ, jajáꞌ u kʼwajíl bin wál an pujal. Tam ka ulich techéꞌ, neꞌech ti káw kʼal tatáꞌ.” ");
INSERT INTO husNT2005_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Jaxtám tu abnaꞌ jikʼatkʼi ki kʼale ta alyáb ani alwaꞌ tʼajat abal i tsích. Xoꞌ ejtal techéꞌ u kʼwajat tin tamét na Dios ani i léꞌ ki achʼaꞌ ejtal xowaꞌ an Ajátikláb ti abámal ti ku utsaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","In tuju tám na Pedro ti káw ani in ulu enchéꞌ: ―Xoꞌ ojniꞌ u exbách abal na Dios yab u takukúl an ti atiklábtsik. ");
INSERT INTO husNT2005_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Na Dios in bachʼwal xitaꞌkichkʼi, tokot ka exlá ke Jajáꞌ ejtal in ejtowal kin tʼajaꞌ ani kin tʼajaꞌtsik xowaꞌ in léꞌ na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Na Dios in abtsi nin kidhtaltsik na Israel an ti tsubaxtaláb. Jechéꞌ an tsubaxtaláb, jaꞌich an alwaꞌ tʼilab xin pidhnál an kʼijidhtaláb kʼal tin kwentakʼi na Jesukristo ani jechéꞌ na Jesukristo, jaꞌich nu Ajátikláb kʼal ejtalkʼitsik. ");
INSERT INTO husNT2005_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","A choꞌóbtsik alwaꞌ xantʼéy tʼílan bin chabálil an judíotsik, tujey Galilea, tin kuxmats na Juan tam ti xeꞌchin ti tʼiltsix ani ti pújal. ");
INSERT INTO husNT2005_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","A choꞌóbtsik alwaꞌ xan ti na Dios tin pidhaꞌ na Jesús xi Nasaret tin cháp an Tʼokat Ejattaláb. Xan ti na Jesús ti xeꞌchin jeye in tʼajál xowaꞌ alwaꞌ ani in jeldhál ejtal xi kʼwajat teykómtetsik kʼal in cháp an lej atʼax. Ejtal jechéꞌ in tʼajál abal na Dios taꞌ ti kʼwajat kʼal Jajáꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Wawáꞌ i chuꞌúmal ejtal jechéꞌ xowaꞌ in tʼajámal na Jesús, ban chabáltsik xi Judea ani ban bitsow Jerusalén. Tayíl chemdhá pajkʼidh ban peltsidh teꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Por ejdhá ti ít kʼal na Dios tin óxláb a kʼítsá ani tu xalkʼantsi an ta Jesús abal ki chuꞌu ke Jajáꞌ ejnek ti ít. ");
INSERT INTO husNT2005_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Yab xalkʼantsat ejtal an atiklábtsik, tokot wawáꞌkʼi, xi na Dios in takwyámalich kʼejle okʼox abal ku xeꞌchin tu óltsix. Wawáꞌ u kʼapúch ani u uchʼách kʼal Jajáꞌ tam ti ejdhatsich. ");
INSERT INTO husNT2005_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ani tu abaꞌ ki tʼiltsi an atiklábtsik ani ki óltsitsik jeye ke jechéꞌ na Jesukristo bijidhich kʼal na Dios abal kin lújundhaꞌ xi ejattsik ani xi chemnektsik. ");
INSERT INTO husNT2005_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Ejtal an tʼiltsixtsik xi ti wejeꞌ, in tʼilámaltsik na Jesús, ke ejtal xitaꞌ kʼál ti ka belan, neꞌech ka pakwlantsat tin walastalábiltsik. ");
INSERT INTO husNT2005_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Lejat na Pedro kʼwajat ti káw, ulich an Tʼokat Ejattaláb ba ejtal xi kʼwajat in achʼáltsik nin tsubaxtalábil na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ani an judíotsik xu belomich, xi tsiꞌnektsik junax kʼal na Pedro, labantsik tʼajat abal in chuꞌu pidhantsik jeye an ti Tʼokat Ejattaláb xi yabtsik u judío. ");
INSERT INTO husNT2005_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Abal in achʼaꞌtsik ti káw kʼal i kʼeꞌet káwintalábtsik ani ti kʼakʼnaxtsik an tin bij na Dios. ");
INSERT INTO husNT2005_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","In ulu tám enchéꞌ na Pedro: ―¿Awxeꞌ waꞌach jun xitaꞌ xi neꞌech kin ejto kin tamkʼuy abal yab ka pujyat jechéꞌ an atiklábtsik, kom in bachʼúmichtsik jeye xoꞌ an Tʼokat Ejattaláb jelti wawáꞌ? ");
INSERT INTO husNT2005_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","In ulu abal ka pujyatichtsik tin bij na Jesukristo ani pakabédhá na Pedro abal ka kʼwajay cháb óx a kʼítsá kʼal jajáꞌtsik. ");
INSERT INTO husNT2005_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","An abatwáletsik ani an belomtsik xi kʼwajat Judea, in achʼaꞌ abal in bachʼúmaltsik jeye nin káwintal na Dios xi yabtsik u judío. ");
INSERT INTO husNT2005_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Tam ti na Pedro ulich Jerusalén, kawyat kʼal taltsik an judíotsik xu belomich xin ulal ke yejat jeye ka tʼajtsintsik an ti exól bin tʼuꞌúl xin belálichtsik na Jesukristo. ");
INSERT INTO husNT2005_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Konyat enchéꞌ: ―¿Jantʼókʼi ta kʼalnek ka álnaꞌ xi yab in koꞌoltsik an exól bin tʼuꞌúl ani i kʼapúmadh kʼal jajáꞌtsik? ");
INSERT INTO husNT2005_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Tʼiltsintsik tám kʼal na Pedro asta tin tujtal ejtal xowaꞌ támnék, enchéꞌ ti utsantsik: ");
INSERT INTO husNT2005_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","―Tam tin kʼwajat ban bitsow xi Jope ani in kʼwajat tin ól, u chuꞌu jun i xalkʼantsixtaláb. Ban xalkʼantsixtaláb, u chuꞌu jun xataꞌ jelti jun i kʼudhkʼum púlek xi tál ti paꞌíl walkʼiꞌ wikʼats tamatkʼi ani ulich asta xon tin kʼwajat. ");
INSERT INTO husNT2005_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Tam tu telaꞌ alwaꞌ abal ku chuꞌu xantʼéy taꞌ ti kʼwajat alkʼidh, u chuꞌu i koꞌnéltsik xi cheꞌtsik in akan, i padhumtsik, i chantsik ani i chʼichintsik. ");
INSERT INTO husNT2005_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ani u achʼaꞌ jun i káwintaláb xi tin utsaꞌ enchéꞌ: “Pedro ki chʼakay, ka chemdhaꞌ ani ka kʼapu.” ");
INSERT INTO husNT2005_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Por u ulu enchéꞌ: “Yabaꞌ, Ajátik, pos yab jaykʼi u kʼapúmal jun xataꞌ xowaꞌ Tatáꞌ a ulúmal ke yab yejat ka kʼapat.” ");
INSERT INTO husNT2005_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Tin tawnaꞌ tám juní jachanꞌ an káwintaláb xi tál walkʼiꞌ ani tin utsaꞌ enchéꞌ: “Xowaꞌ Nanáꞌ u tʼokómal, yab yejat ka bijiy atʼax.” ");
INSERT INTO husNT2005_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Óxíl tʼájan jechéꞌ ani tayíl kʼaléch tám juní walkʼiꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Támkʼi jachanꞌ, ulich óx i iniktsik ban atá xon tin kʼwajat. Jechéꞌ an iniktsik, tál Sesarea ani tsiꞌnek abal ti kin aliytsik. ");
INSERT INTO husNT2005_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","An Tʼokat Ejattaláb tin utsaꞌ abal kin kʼale kʼal jajáꞌtsik ani yab kin kʼwajay xataꞌ ku chalpay. Kʼaletsik jeye kʼal nanáꞌ jechéꞌ akak an kidháblábtsik ani ejtal tu éb tu ochich bin kʼimáꞌ jun i inik xin bij ta Kornelio. ");
INSERT INTO husNT2005_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Jechéꞌ an inik, tu tʼiltsi xan tin chuꞌúmal kubúl jun i tʼokat abatwále tajaꞌ tin kʼimáꞌ ani utsan kʼál enchéꞌ: “Ka abaꞌ i iniktsik ban bitsow xi Jope abal kin kaniy na Simón, xu bijyáb jeye ta Pedro, ");
INSERT INTO husNT2005_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","jajáꞌ neꞌech ti ki utsaꞌ xan ti neꞌech ka ejto ki loꞌey, tatáꞌ ani ejtal na kidhtaltsik.” ");
INSERT INTO husNT2005_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Tam ti nanáꞌ u tuju ku tawnaꞌtsik, in bachʼutsik an Tʼokat Ejattaláb, jelt xan ti wawáꞌ i bachʼúmal más okʼox. ");
INSERT INTO husNT2005_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","U chalpay tám xan tin ulúmal an Ajátikláb: “Tsubax kʼejle ke na Juan pujxin kʼal i jaꞌ, por tatáꞌtsik neꞌech ka bachʼu an Tʼokat Ejattaláb.” ");
INSERT INTO husNT2005_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Pos max na Dios in pidhaꞌtsik jeye jayéchkʼi xowaꞌ wawáꞌ tu pidhámal xi belámalich ni Ajátik Jesukristo, ¿jantʼéy u éy nanáꞌ abal kin kʼwajay ku tamkʼuy na Dios kʼal xowaꞌ in léꞌ kin tʼajaꞌ? ");
INSERT INTO husNT2005_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Tam ti an kidháblábtsik xi Jerusalén in achʼaꞌ ejtal jechéꞌ, chamkʼantsik ani kʼwajay kin kʼakʼnaꞌtsik na Dios. Enchéꞌ tin ulutsik: ―¡Tám, in pidhámaltsik jeye na Dios xi yabtsik u judío an ti chalab abal kin jilaꞌichtsik ti walablom ani anchanꞌ kin ejtóchtsik jeye kin kóꞌoy an xeꞌchintaláb xi yab in koꞌol in okʼontal! ");
INSERT INTO husNT2005_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Tam ti chemdhájich na Esteban, tujey jeye ti atʼnal xi kʼeꞌet an belomtsik ani taltsik kʼale asta Fenisia, Chipre ani Antiokía. Tajaꞌ, in tʼiltsitsik an ti alwaꞌ tʼilab an judíokʼitsik ani xi kʼeꞌet an atiklábtsik, yabaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Por taltsik an belomtsik xi tál Chipre ani Sirene, ulichtsik ban bitsow xi Antiokía ani in tʼiltsitsik jeye xi yabtsik u judío an ti alwaꞌ tʼilab kʼal tin kwenta an Ajátikláb Jesús. ");
INSERT INTO husNT2005_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Nin cháp an Ajátikláb kʼwajat kʼal jajáꞌtsik, pos yán xin jilaꞌ nin wejeꞌ belomtaltsik ani in belaꞌichtsik an Ajátikláb. ");
INSERT INTO husNT2005_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Tam ti an belomtsik xi Jerusalén in achʼaꞌ jechéꞌ, in abaꞌ na Bernabé asta Antiokía. ");
INSERT INTO husNT2005_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Tam ti na Bernabé ulich Antiokía, in chuꞌu xan ti na Dios tin lábtʼajámal an belomtsik xi tajaꞌ ani kulbé tʼajat. In takʼiytsik ejtal abal kin óntsi kin belaꞌtsik an Ajátikláb kʼal jun in ejattal lujat. ");
INSERT INTO husNT2005_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Pos jechéꞌ na Bernabé, jaꞌich jun i alwaꞌ inik, teykómte kʼal in cháp an Tʼokat Ejattaláb ani u belom tʼajat. Ani anchanꞌ, yán i atiklábtsik in tʼajaꞌ abal kin belaꞌ an Ajátikláb. ");
INSERT INTO husNT2005_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Tayíl, na Bernabé kʼale Tarso abal kin aliy na Sawlo. Tam tin elaꞌ, in júnaꞌ Antiokía. ");
INSERT INTO husNT2005_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Tajaꞌ ti kʼwajaytsik kʼal an belomtsik jun i tamub ani yán i atiklábtsik in okʼtsi. Tajaꞌ Antiokía ti tujey jidhtal tʼajat ti bijyáb an belomtsik, kristianotsik. ");
INSERT INTO husNT2005_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Tam ti jachanꞌ i kʼij, kale Jerusalén cháb óx i tʼiltsixtsik ani kʼaletsik Antiokía. ");
INSERT INTO husNT2005_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Jún ti éb xi jechéꞌ an tʼiltsixtsik, xu bijyáb ta Agabo, kubey junax chʼejel xon ti kʼwajat an kidháblábtsik ani tin ijtsixtal an Tʼokat Ejattaláb, in ulu abal neꞌech ka watʼey jun i pulek kʼaꞌínab putálkʼi an chabál. Anchanꞌ lejtal ti támun, tam ti an lej pulek takʼix Klawdio kʼwajat ti takʼix Roma. ");
INSERT INTO husNT2005_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Tám, an belomtsik xi Antiokía in ulu abal neꞌech kin abtsitsik jun i tolmixtaláb an kidháblábtsik xu kʼwajíl Judea, xantikʼi kin ejtotsik kin pidhnaꞌ juntsik ti éb. ");
INSERT INTO husNT2005_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Anchanꞌ tin tʼajaꞌtsik, in abtsitsik jun i tolmixtaláb an takʼix belomtsik xi Judea. Jechéꞌ an tolmixtaláb pidhan kin júnaꞌ na Bernabé ani na Sawlo. ");
INSERT INTO husNT2005_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Tam ti jachanꞌ i kʼij, an pulek takʼix Herodes in tuju kin atʼaꞌ taltsik an belomtsik. ");
INSERT INTO husNT2005_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","In ulu ka chemdhá kʼal i machét na Jakobo, nin kidháb na Juan ");
INSERT INTO husNT2005_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","ani kom in chuꞌu ke jechéꞌ in kulbetnaꞌ tʼajat an judíotsik xi yab u belom, in abnaꞌ jeye ka yakʼwan na Pedro. Jechéꞌ támun tam ti exom an ajib xowkʼi tu kʼapnal an pan xi yab jilbédhats kʼal an jilbédhaxtaláb kʼoye. ");
INSERT INTO husNT2005_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Tam ti yakʼwan na Pedro, abná ka balyat al wikʼaxteꞌ kʼal na Herodes, xon ti kʼwajay belkómte kʼal chéꞌ i kweneꞌ i soldadotsik, xi juntsik kweneꞌ, cheꞌtsik i soldado. In chalpayal kin káldhaꞌ tin tamét an atiklábtsik tam watʼenekich an ajib. ");
INSERT INTO husNT2005_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Na Pedro u kóꞌyáb balidh ban wikʼaxteꞌ belkómte tʼajat alwaꞌ, por an belomtsik in óntsaltsik kin kontsintsi na Pedro kʼal yantam i chápláb. ");
INSERT INTO husNT2005_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Jachanꞌ an akal, tam ti neꞌech ka tsudhéch xowkʼi na Herodes ti neꞌech kin káldhaꞌ na Pedro tin tamét an atiklábtsik, na Pedro kʼwajat ti wayal junax chʼejélidh kʼal cháb i soldado ani wikʼats kʼal cháb i patʼál ani belkómte nin wiꞌlébil an wikʼaxteꞌ kʼal cháb óx i soldadotsik. ");
INSERT INTO husNT2005_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Jun jikʼtowále ti ulich jun in tʼokat abatwálejil an Ajátikláb ani tajkʼan jun i kʼamal ba jachanꞌ an wikʼaxteꞌ. Takan na Pedro bin chóyíl kʼal jachanꞌ an tʼokat abatwále, bakyat ani utsan enchéꞌ: ―Ki chʼakay jikʼatkʼi. Wilkʼan tám an patʼáltsik xi kʼál ti kʼwajat wikʼadh nin kʼubaktsik na Pedro ");
INSERT INTO husNT2005_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","ani utsan enchéꞌ kʼal an tʼokat abatwále: ―Ka wikʼaꞌ na tsukul kʼal an ótʼ ani ka kʼwajbaꞌ na pajab. Tam ti na Pedro okʼon kin tʼajaꞌ jechéꞌ, utsan enchéꞌ kʼal an tʼokat abatwále: ―Ka wátnaꞌ na wát ani ti kin wéwnaꞌ. ");
INSERT INTO husNT2005_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Kale tám na Pedro in wewkóm an tʼokat abatwále, maske yab in choꞌób max tsubax o yabaꞌ xowaꞌ kʼwajat in tʼajál an tʼokat abatwále. Jajáꞌ in chalpayal ke kʼwajat in chuꞌtal jun i xalkʼantsixtaláb. ");
INSERT INTO husNT2005_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Por watʼeytsik ban jidhtal belkol ani bin chabtal jeye; tam ti ulichtsik ban patʼál wiꞌleb abal ka kaléch ban bél xu kʼalel ban bitsow, an wiꞌleb kwetémtal ti jakʼpin. Kaletsik tám, ani tam tin belámalichtsik jun pejeꞌ an bél, jilanich tám kwetém kʼal an tʼokat abatwále. ");
INSERT INTO husNT2005_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","In exbách tám na Pedro ani in ulu enchéꞌ: ―Xoꞌ ojniꞌ u exbách ke Jajáꞌ an Ajátikláb in abámal nin tʼokat abatwálejil abal ti kin loꞌo kʼal na Erodes ani kʼal ejtal xowaꞌ nu at kidhtaltsik xi yab u belom in léꞌ ti kin tʼajtsi. ");
INSERT INTO husNT2005_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","In chalpóm jechéꞌ, na Pedro kʼale bin kʼimáꞌ na María, nin nánaꞌ na Juan, xu bijyáb jeye ta Markos; tajaꞌ, taꞌ ti kʼwajat yán i atiklábtsik, jechéꞌ junkunéktsik abal ti ól. ");
INSERT INTO husNT2005_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Tam tin tʼeney an wiꞌleb xi kuxtál, jun i tsidhan xu bijyáb Rode kale kin chuꞌu xitam jáꞌ nin tʼenyal an wiꞌleb. ");
INSERT INTO husNT2005_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Por tam tin exbay abal a Pedro na kʼwajat ti tawnax, yab in japiy an wiꞌleb, ájlách altá kʼal i kulbéxnich abal kin ólnaꞌ ke na Pedro taꞌ ti kʼwajat ban wiꞌleb ti tawnax. ");
INSERT INTO husNT2005_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Utsan tám enchéꞌ: ―¡Tatáꞌ i olmanal! Por an tsidhan in ulal abal tsubax. Jajáꞌtsik in ulal enchéꞌ: ―Yab jajáꞌ, i tʼokat abatwále xi kʼál tu beletnáb. ");
INSERT INTO husNT2005_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Por na Pedro in óntsal kin tʼeney an wiꞌleb, ani tam tin japiytsik an wiꞌleb ani in chuꞌu, labantsik tʼajat. ");
INSERT INTO husNT2005_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Por jajáꞌ in utsaꞌtsik kʼal in kʼubakkʼi abal yab ka kʼuchuntsik ani in tʼiltsitsik xan ti káldhá ban wikʼaxteꞌ kʼal a