﻿USE sofia;
DROP TABLE IF EXISTS sofia.husNT1971_vpl;
CREATE TABLE husNT1971_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES husNT1971_vpl WRITE;
INSERT INTO husNT1971_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ne’ets cu bijiy i biyal juntalab xits’labchic c’al a Jesucristo. Ti lej biyal c’uajatac a David ani a Abraham. ");
INSERT INTO husNT1971_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","In tata a Isaac pelac a Abraham. In tata a Jacob pelac a Isaac. In tata a Judá c’al in at ebchalchic pelac a Jacob. ");
INSERT INTO husNT1971_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","In tata a Fares ani a Zara pelac a Judá. In mim jaja’chic pelac a Tamar. In tata a Esrom pelac a Fares. In tata a Aram pelac a Esrom. ");
INSERT INTO husNT1971_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","In tata a Aminadab pelac a Aram. In tata a Naasón pelac a Aminadab. In tata a Salmón pelac a Naasón. ");
INSERT INTO husNT1971_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","In tata a Booz pelac a Salmón ani in mim a Booz pelac a Rahab. In tata a Obed pelac a Booz ani in mim a Obed pelac a Rut. In tata a Isai pelac a Obed. ");
INSERT INTO husNT1971_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","In tata an ts’ale David pelac a Isai. In tata a Salomón pelac an ts’ale David. In mim a Salomón pelac i uxum axi tomquinenecac c’al a Urias. ");
INSERT INTO husNT1971_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","In tata a Roboam pelac a Salomón. In tata a Abias pelac a Roboam. In tata a Asa pelac a Abias. ");
INSERT INTO husNT1971_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","In tata a Josafat pelac a Asa. In tata a Joram pelac a Josafat. In tata a Uzias pelac a Joram. ");
INSERT INTO husNT1971_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","In tata a Jotam pelac a Uzias. In tata a Acaz pelac a Jotam. In tata a Ezequías pelac a Acaz. ");
INSERT INTO husNT1971_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","In tata a Manasés pelac a Ezequías. In tata a Amón pelac a Manasés. In tata a Josías pelac a Amón. ");
INSERT INTO husNT1971_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","In tata a Jeconías pelac a Josías. A Jeconías in cua’al in ebchalchic jaye. C’uajatac jaja’chic tam ti ne’tha huic’at an Israelchic ti Babilonia. ");
INSERT INTO husNT1971_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Taley in tata a Salatiel pelac a Jeconías. In tata a Zorobabel pelac a Salatiel. ");
INSERT INTO husNT1971_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","In tata a Abiud pelac a Zorobabel. In tata a Eliaquim pelac a Abiud. In tata a Azar pelac a Eliaquim. ");
INSERT INTO husNT1971_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","In tata a Sadoc pelac a Azar. In tata a Aquim pelac a Sadoc. In tata a Eliud pelac a Aquim. ");
INSERT INTO husNT1971_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","In tata a Eleazar pelac a Eliud. In tata a Matán pelac a Eleazar. In tata a Jacob pelac a Matán. ");
INSERT INTO husNT1971_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","In tata a José pelac a Jacob. Jats nixe’ a José axi pel i tomiclab c’al a María in mim a Jesús. A Jesús bijiyab jaye ti Cristo. ");
INSERT INTO husNT1971_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Antsana’its ma ti c’al a Abraham ani ma ti c’al a David tin aytal pelac lajuj tse’ i cuenel bichoulom. Aniye jaye pelac lajuj tse’ i cuenel bichoulom ma ti c’al in tsacamilchic a David ani ma ti c’al an Israelchic axi ne’tha ti Babilonia. Aniye jaye pelac lajuj tse’ i cuenel bichoulom ma tam ti ne’tha an Israelchic ani ma ti c’al a Cristo. ");
INSERT INTO husNT1971_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ne’ets cu olna’ i cau tin cuenta in hua’tsintal a Jesucristo. In mim María conothits ne’ets ca tomquin c’al a José, tocat yabaye juncunenecchic. Ani co’othits c’al an t’ele’ c’al in tsap an Espíritu Santo. ");
INSERT INTO husNT1971_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Cum a José axi c’al ne’ets ca tomquin pel i lej pututh inic ani yab in le’ max a María ca tithetal tsalpanchat c’al am bichou, jaxtam in tsalpayal yab ne’ets ca tomquin. ");
INSERT INTO husNT1971_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Tam ti antsana’ tin tsalpayal, tam in huachibnal tin huachib jun i ángel abath c’al a Dios. Ani uchan c’al an ángel: ―José, tata’ pel it at xits’lab c’al a David, yab ca tithena’ ca co’oy a María ta tomquil, cum co’othits c’al an t’ele’ expith c’al in tsap an Espíritu Santo. ");
INSERT INTO husNT1971_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ne’ets ca hua’tsin an t’ele’, ani u le’ abal ca bijiy ta Jesús. Antsana’ ta ca bijiy, cum ne’ets quin jec’ontha’ an inicchic c’al an hualabtalab. ");
INSERT INTO husNT1971_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Patal antsana’ ti t’ajnenec abal ca putun jahua’ in ulumalits a Dios tin hui’ c’al in caulomejil Isaias. In ulu antse’: ");
INSERT INTO husNT1971_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Jun i uxum axi yabaye juncunenec c’al i inic ne’ets ca co’on c’al jun i t’ele’ cuitol axi ne’ets ca bijiyat ta Emanuel. Emanuel in le’ quin ulu ti tenec cau a Dios c’uajat c’al huahua’. ");
INSERT INTO husNT1971_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Taley tam ti ejtsinits a José in t’aja’ jant’ini’ ti uchanits c’al an ángel abath c’al a Dios, im bats’u a María tin tomquil. ");
INSERT INTO husNT1971_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Bel yabaye lej juncunenecchic, biyat in aychal ca hua’tsin a Jesús in oc’ox t’ele’il a María. Taley tam ti hua’tsinits an t’ele’, tam a José im bijiy ta Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Hua’tsin a Jesús ti bichou Belén axi cuentalith ti bichoulom Judea tam ti a Herodes pel i ts’ale ti Judea. Ani jun a q’uicha ulitschic ti Jerusalén i lej tsalpath inicchic axi tal ma ti calel q’uicha. ");
INSERT INTO husNT1971_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Xe’ets in conomichical: ―¿Ju’ta ti c’uajat jaja’ axi it hua’tsinenec ne’ets tin Ts’alejil an Israelchic? I tsu’chamal in otil tihua’ ti calel q’uicha, ani u tal huahua’ abal qui c’ac’na’. ");
INSERT INTO husNT1971_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Tam ti an ts’ale Herodes ani patal an c’uajilchic ti Jerusalén in ats’a’its jahua’ antsana’ in ulumal an tsalpath inicchic, lej t’elelelchic in ichich. ");
INSERT INTO husNT1971_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ani a Herodes in caniy ca chich patal an oc’lec pale’ ani an exobchix c’al an ts’ejcath cau binath c’al a Moisés. In conoyalchic jahua’ tam bichou ti ne’ets ca hua’tsin a Cristo. ");
INSERT INTO husNT1971_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ani toc’tsinchic: ―Ne’ets ca hua’tsin ti bichou Belén axi cuentalith teje’ ti bichoulom Judea jant’ini’ ti thuchathits c’al in caulomejil a Dios Miqueas. In thucha’ jahua’ in ulu a Dios antse’: ");
INSERT INTO husNT1971_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Aba ani’ a Belén pel i tsacam bichou ti Judea, bel lej exbath in ey, cum tats ne’ets ca hua’tsin an lej Oc’nom c’al u bichohuil Israel. ");
INSERT INTO husNT1971_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Tam a Herodes in tsinat caniy ca chich an tsalpath inicchic. Ulitschic ani in conoyal an lej hora tam tin tsu’umal nixe’ xa ot. ");
INSERT INTO husNT1971_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ani cum ne’ets quin aba’chic ti Belén in ucha’chic: ―Quit c’alechic ti Belén ani ca lej alhua’ aliy an t’ele’ cuitol, ani tam ca ela’its quit huichiy tiquin olchi abal quin c’alene cu c’ac’na’. ");
INSERT INTO husNT1971_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ani tam ti uchanits antsana’ an tsalpath inicchic c’al an ts’ale Herodes, ta c’alechic ti Belén oc’nanchab c’al nixe’ xa ot ax in tsu’umal ti calel q’uicha. Jats in aynanchal ma ultsitschic ju’ta ti cubiyits hualq’ui’ ba’ an ata jun ti c’uajatits an t’ele’ Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Lej culbelchic tam tin tsu’u an ot taja’. ");
INSERT INTO husNT1971_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Otsitschic al an ata ani in tsu’uchic c’uajat an t’ele’ c’al in mim María. Tam in tuthuchic in c’ualal ani in c’ac’nal an t’ele’. Taley in caltha’chic i oro ani i jom ani i nihuihuiltalab mirra, ani in jilchi an t’ele’ Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Taley talbel uchanchic c’al a Dios tin huachib abal yab ca huichiy c’al a Herodes, ani jaxtam in yac’ua’chic pil i bel abal ca huichiy tim bichou. ");
INSERT INTO husNT1971_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Tam ti c’alets an tsalpath inicchic, a José in tsu’u tin huachib i ángel abath c’al a Dios. Ani uchan c’al an ángel: ―Cum c’al a Herodes ne’ets ca alchin an t’ele’ ca tsemthanchat, quit ts’aquiy ca thubat ne’tha’ an t’ele’ ani c’al in mim tihua’ ti Egipto. Taja’ quit c’uajiychic ma tam nan tu ucha’ quit calets. ");
INSERT INTO husNT1971_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Tam ejtsin a José ani in ne’tha’ an t’ele’ ani c’al in mim acal tihua’ ti Egipto. ");
INSERT INTO husNT1971_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ani tats ti c’uajilchic ma tam ti tsemtsits a Herodes. Patal antsana’ t’ajnenec abal ca putun jahua’ in ulumalits a Dios tin hui’ c’al in caulomejil Oseas antse’: Tihua’ ti Egipto ne’ets cu ucha’ u Tsacamil ca cale. ");
INSERT INTO husNT1971_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Tam ti a Herodes in tso’obna’ abal c’ambiyatits c’al an tsalpath inicchic, lej huat’ath c’athpich tsacul. Ma in aba’ i cau abal ca tala’ tsemtha patal an t’ele’ cuitol axi it hua’tsinenec ani ma ax im putumalits tsab i tamub. Cum a Herodes in exla’its abal yabaye huat’ath tsab tamub tam ti che’nec an tsalpath inicchic quin tsu’u an t’ele’ Jesús, jaxtam antsana’ ta ca tsemtha an t’ele’ cuitolchic tim patal am bichou ti Belén ani tin tonith a Belén. ");
INSERT INTO husNT1971_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ani tin ebal in tsemtal nixe’ xi t’ele’chic jats tu putnal an cau jahua’ in thuchamal in caulomejil a Dios Jeremias antse’: ");
INSERT INTO husNT1971_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Ti Ramá hua’ats i uxumchic lej t’e’pith ani lej uc’nal. Pel i Israelchic at xits’lab c’al a Raquel ax in uc’nanchalchic in tsemthach tsacamil. Ani ma yab in le’ ca culbethanchatchic in ichich, cum t’ajatits ti tsemthanchame axi yantalam in tsacamil. ");
INSERT INTO husNT1971_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Taley tam ti tsemtsits a Herodes, tamna’ a José tihua’ ti Egipto in tsu’u junil tin huachib i ángel abath c’al a Dios. Ani uchan c’al an ángel: ");
INSERT INTO husNT1971_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","―Quit ts’aquiy ani quit huichiy tihua’ ta tsabalil c’al a at Israelchic. Cum tsemtsits axi in le’ac ti tsemthom c’al an t’ele’ Jesús, xo’ ca ne’tha’ an t’ele’ ani c’al in mim tihua’. ");
INSERT INTO husNT1971_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Tam ts’aquiy a José ani in ne’tha’ an t’ele’ ani c’al in mim tihua’ tin tsabalil c’al in at Israel. ");
INSERT INTO husNT1971_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Bel in ts’ejnal a José ca lej c’uajiy ti tsabal Judea, cum in tso’obnal abal a Arquelao in tsacamil a Herodes pel i pulic oc’lec taja’. Ani jaxtam uchane más i cau c’al a Dios tin huachib, ca c’alecua’ ti Galilea. Ani tats ti c’alechic. ");
INSERT INTO husNT1971_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ulits ani c’uajiychic taja’ ti al am bichou Nazaret. Antsana’ tu putnal an cau ax in ulumal in caulomejilchic a Dios abal a Jesús ne’ets ca bijiyat ti Nazaretib. ");
INSERT INTO husNT1971_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Im bajuhuits an q’uij tam ti a Juan pujax chich ti thajchix ti al an joltam ti tsabal Judea. ");
INSERT INTO husNT1971_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Taja’ in thajchixnanchal ax u che’elchic antse’: ―Quit jic’tson c’al a hualab ani quit huenc’on c’al a Dios, cum hue’its ta tal a Dios quin t’aja’ ti lej Ts’ale teje’ tsabal. ");
INSERT INTO husNT1971_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Antsana’ c’al in thajchixtal a Juan tu putnal an cau jahua’ in thuchamal ma biyalits an caulome Isaías antse’: Jun i inic ne’ets quin thajchixnanchi an inicchic ax u che’el al an joltam antse’: Ca ts’ejcacanchi am bolith bel an Ajatic jun ti ca ulits. ");
INSERT INTO husNT1971_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Toltomith a Juan c’al i toltom axi ts’ejcath c’al in jujul an camello. In huic’ ts’ejcath pel i ot’. In c’apchal in t’u’ul an ts’ili’ ax u c’apab ani an alte’ tsi’im. ");
INSERT INTO husNT1971_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","U che’elchic quin ats’anchi in thajchixtal jat’hua’ tim patal an c’uajilchic ti Jerusalén. Jaye u che’el axi tim puhuel am bichoulom Judea axi utatchic c’uajilchic ti pulic itse’ Jordán. ");
INSERT INTO husNT1971_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","U pujayabchic taja’ c’al a Juan ti al am pulic itse’ Jordán jitats in lujuhual in hualab c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Tam ti a Juan in tsu’u abal u che’el yan i fariseo ani yan i saduceo ca pujayat, in ucha’chic: ―Tata’ ojni’chic ejtil it tsan. A le’ ca jec’a’ c’al i pujaxtalab an yajchictalab axi taye tal. ");
INSERT INTO husNT1971_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Max chubax it jic’tsonenequitschic c’al a hualab ani it huenc’onenequits c’al a Dios, ca tejhua’metha’ abal chubax anits c’al i alhua’ xe’tsintalab. ");
INSERT INTO husNT1971_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Yab ca tsalpaychic abal it alhua’its c’al a Dios expith cum pel it at xits’lab c’al a Abraham. Nan tu uchalchic max expith jats in le’ a Dios yantalam in xits’altal a Abraham, in huit’alac ma quin hua’tsintha’ c’al i t’ujub. ");
INSERT INTO husNT1971_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Jant’ini’ an inic in ijcal jun i te’ axi yab jant’o ti alhua’ ani quin chica’, antsana’ a Dios hue’its ne’ets quin t’aja’ c’al i inicchic axi jaja’ quin tsu’u yab alhua’. ");
INSERT INTO husNT1971_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Nan chubax xo’ tu pujayalchic c’al i ja’ ti tsu’bixtalab abal it jic’tsonenequits c’al a hualab ani it huenc’onenequits c’al a Dios. Talbel ne’ets ca chich jun i inic axi ne’ets ti pujaychic c’al an Espíritu Santo ani c’al i c’amal. Jaja’ lej pulic in ey ani nana’ iba. Nana’ lej tsa’at u ey, ma yab ne’ets cu baju cu tixc’anchi im pajab. ");
INSERT INTO husNT1971_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Tam jun i inic quin ic’oy in hualil an lab em, talbel ne’ets quin thaya’ ti al i huilte’. An amul ne’ets quin chica’ al i c’amal. Antsana’ jaja’ axi taye tal talbel ne’ets quin thaya’ in c’al jaja’ ti eb, ani quin jolou axi jaja’ yab in c’al ti al am pulic c’amal axi ni jayq’ui’ yab u teptsinal. ");
INSERT INTO husNT1971_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Cale a Jesús ti Galilea, c’ale ti pulic itse’ Jordán abal ca pujan c’al a Juan. ");
INSERT INTO husNT1971_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Cum a Juan in tsalpayal abal yab in tomnal quim pujay a Jesús, in ucha’: ―Nana’ ax in tomnal tiquim pujay, ani tocat tata’ a le’ tu pujay. ");
INSERT INTO husNT1971_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Toc’tsin a Jesús: ―Bel tiquim pujay, cum in tomnal qui putu c’al patal jahuats tu cu abatna c’al a Dios. Tam in ulu a Juan abal bel ne’ets quin t’aja’. ");
INSERT INTO husNT1971_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Tam ti pujanits a Jesús ani calnequits ti al am pulic itse’, tameq’ui japq’uinal ti eb ani in tsu’u pa’i’il an Espíritu Santo ejtil i cucu’. Ta jilc’on c’al a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Tam ats’atmel jun i cau tal ti eb c’al a Dios antse’: ―Axe’ ja’its u ichich hual Tsacamil. In lej culbel c’al jaja’. ");
INSERT INTO husNT1971_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Taley ne’tha a Jesús c’al an Espíritu Santo ca c’ale ti al i joltam, ani taja’ nixoc’nab c’al an oc’ox teneclab abal le’nab ca hualbin. ");
INSERT INTO husNT1971_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","C’uajat taja’ tsab inic a q’uicha ani tsab inic i acal, ani ni jant’o yab in c’apu, expith lej c’a’il. ");
INSERT INTO husNT1971_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Tam utey an teneclab in ucha’: ―Max chubax pel ti lej Tsacamil a Dios, ca ucha’ axe’ xi t’ujubchic ca huenc’on ti pan. ");
INSERT INTO husNT1971_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Toc’tsin a Jesús: ―An T’ocat Thuchlab in cahuintal a Dios in ulal abal an inic yab expith quin ejatna’ an c’apnel, jaye quin ejatnanchi patal in cahuintal a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Tam ne’tha a Jesús ti t’ocat bichou Jerusalén c’al an teneclab ani tin oc’ an tiyopan lej t’ec’at. ");
INSERT INTO husNT1971_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ani uchan: ―Max chubax pel ti lej Tsacamil a Dios, ma teje’ quit t’ic’ts’on ani ma tsabal. Ne’ets quit jec’ontha, cum thuchathits al an T’ocat Thuchlab abal a Dios ne’ets ti abchi i ángelchic abal ti alhua’ beletna’. Thuchathits jaye abal an ángelchic ne’ets ti co’bitsiy tin c’ubac abal ma yab quit t’ithc’uan al i t’ujub. ");
INSERT INTO husNT1971_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Toc’tsin a Jesús: ―In ulal an T’ocat Thuchlab abal yab ca tacchiquiy a Dios, aba ani’ jaja’ pel i beletnom c’al an inicchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Tam ne’tha a Jesús ti al i lej t’ec’at oc’ bolchal c’al an teneclab, ani uchan quin met a’ tim patal am pulic bichoulom tim puhuel an tsabal c’al patal in ts’alat. ");
INSERT INTO husNT1971_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ani uchan: ―Max ca tuthu a c’ualal ani tiquin c’ac’na’, nan ne’ets tu tala’ pitha’ patal jahua’ a tsu’tal abal ca abatna’. ");
INSERT INTO husNT1971_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Toc’tsin a Jesús: ―Satanás, quit tixc’anits xo’ c’al nana’. In ulal an T’ocat Thuchlab abal an inic quin c’ac’na’ ani quin t’ojonchi im Pay’lom Diosil expith. ");
INSERT INTO husNT1971_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Tam ta c’alets an teneclab, ani chich i ángelchic quin tolmiy a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Tam ti a Jesús in ats’a’ abal a Juan c’uajat ti al an huic’axte’, c’ale ti Galilea. ");
INSERT INTO husNT1971_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Tixc’an tim bichohuil Nazaret, chich ca c’uajiy ti bichou Capernaum. Pel i bichou tin hualte’lil am pulic lejem tihua’ ti al an tsabal Zabulón ani tsabal Neftalí. ");
INSERT INTO husNT1971_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Antsana’ tu putnal an cau jahua’ in thucha’ in caulomejil a Dios Isaías antse’: ");
INSERT INTO husNT1971_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","An tsabal Zabulón ani an tsabal Neftalí c’uajat utat ti pulic lejem jum poq’ue’ am pulic itse’ Jordán. Ja’its am bichoulom Galilea jun tu c’uajil axi yab Israelchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Taja’ an inicchic axi xe’ets al an yic’uax ne’ets quin tsu’u i tajaxtalab lej tajajal. Axi jiq’uelchic c’al an tsemla ne’ets ca tajbanchat in ichich c’al nixe’ xi tajaxtalab, in ulu a Isaías. ");
INSERT INTO husNT1971_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Taley im baju a q’uicha in ts’i’quiy a Jesús quin thajchixnanchi an inicchic in cahuintal a Dios. In uchalchic: ―Quit jic’tsonchic c’al a hualab ani quit huenc’on c’al a Dios, cum hue’its ta tal a Dios quin t’aja’ ti lej Ts’ale teje’ tsabal. ");
INSERT INTO husNT1971_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jun a q’uicha xe’ets a Jesús tin hualte’lil am pulic lejem Galilea, ani taja’ in tsu’u tsab i inic ti alim to’ol. Pel a Simón Pedro c’al in ebchal Andrés ax im pet’nalchic an thachumtalab c’al an to’ol ti al am pulic lejem. ");
INSERT INTO husNT1971_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","A Jesús in ucha’chic: ―Tiquin ts’at’enchi ani nana’ ne’ets tu aba’ tit alim c’al an inicchic axi nana’ tiquim bela’. ");
INSERT INTO husNT1971_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ani thubat in jiloc’na’chic in thachumtal c’al an to’ol, ani ts’at’ey c’al a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Taley belats a Jesús ne’ets más tihua’, ani in tsu’u jaye a Jacobo c’al in ebchal Juan. Jaja’chic pel in tsacamil a Zebedeo. C’uajatchic ti al an tan c’al in tata in c’ua’chiyal in thachumtal c’al an to’ol. Ani a Jesús in caniychic ca chich. ");
INSERT INTO husNT1971_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ani thubat in t’ajat jila’chic in tata ti al an tan, ani ta ts’at’ey c’al a Jesús jaye. ");
INSERT INTO husNT1971_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Xe’ets a Jesús ti tsa’bibil al i bichouchic tim puhuel am bichoulom Galilea, ani exom ti exobchichix c’al in cahuintal a Dios tin tiyopanilchic an Israel. In thajchichixnal an alhua’ cau jant’ini’ a Dios in t’ajal ti lej Ts’ale, ani in tala’ jelthal an ya’ulchic c’al jahuaquits tam yau’lats. ");
INSERT INTO husNT1971_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ani cum tim puhuel an tsabal Siria u lej t’iloxnab a Jesús, jaxtam u chanchinal patal an ya’ulchic. U chanchinal ax in cua’al i alq’uith yajal, jaye ax u co’oyab c’al i at’ax teneclab, jaye ax u ts’ebtsinal, ani jaye an tsambe. A Jesús in tala’ jelthachiquiyal. ");
INSERT INTO husNT1971_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Antsana’ tu ts’at’el c’al a Jesús yantalam i inic axi tal ma ti Galilea, jaye axi tal ma i bichouchic ti Decápolis, jaye axi tal ma ti Jerusalén, jaye axi tal ma i bichouchic ti Judea, ani jaye axi tal ma jum poq’ue’ am pulic itse’ Jordán. ");
INSERT INTO husNT1971_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Cum a Jesús in tsu’u lej mulcunenec an inicchic, c’athiy hue’ al i bolchal ani buxcan taja’. Ani uteychic c’al jaja’ in exobalil. ");
INSERT INTO husNT1971_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Taja’ a Jesús in exobchalchic, in uchalchic: ");
INSERT INTO husNT1971_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","―Ne’ets quit culbechic max a ats’al it ts’ejhuantal ta ichich tin tamet a Dios, cum tamits a Dios ne’ets quin t’aja’ ti Ts’ale ta ichich. ");
INSERT INTO husNT1971_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ne’ets quit culbechic max it t’e’pith, cum tamits a Dios ne’ets ti culbethanchi a ichich. ");
INSERT INTO husNT1971_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ne’ets quit culbechic max it c’aya’ ta ichich, cum tamits ne’ets quit pithan an tsabal ax it bijchithits c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ne’ets quit culbechic max it lej canat ca t’aja’ jahua’ bolith c’al a Dios, cum tamits a Dios ne’ets ti tolmiy abal ca t’aja’. ");
INSERT INTO husNT1971_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ne’ets quit culbechic max a yajnanchal a at inic, cum tamits a Dios ne’ets ti yajnanchi jaye. ");
INSERT INTO husNT1971_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ne’ets quit culbechic max it t’ocat ta ichich, cum tamits ne’ets ca tsu’chi in hual a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ne’ets quit culbechic max it juncuthmethom c’al ax u pejéx, cum tamits ne’ets quit olna ti tsacamil a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ne’ets quit culbechic max it yajchiquiyab tin ebal abal a t’ajal jahua’ bolith c’al a Dios, cum tamits a Dios ne’ets quin t’aja’ ti Ts’ale ta ichich. ");
INSERT INTO husNT1971_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Max it tilibnab, max it othnab, max it t’ajchinal i janamtalab c’al tin ebal u bij, ne’ets quit culbechic. ");
INSERT INTO husNT1971_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Yab quit t’e’pin max antsana’ ti quit t’ajchinchic, cum tam quit ulits ti eb ne’ets quit pithan lej yan a atohual. Ca t’ila’ abal antsana’its ti yajchiquiyame jaye im biyal caulomejilchic a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Tata’chic pel ejtil tit at’em c’al an inicchic. Expith max tsamc’ac’athits an at’em, yabats jant’o ti alhua’. Tocat ne’ets ca lejat huac’la ani ca q’uets’anq’ui c’al an inicchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Tata’chic jaye pel ejtil tit tajaxtalab c’al an inicchic. Yab u ejtohuab ca tsinc’on am bichou axi c’uajat ba’ i oc’ bolchal. ");
INSERT INTO husNT1971_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Yab ne’ets ca paxq’uiyat i lec’utsith tajablab c’al i poc’te’, tocat u c’uajbab jun ti t’ec’at abal ti tajbax c’al patal jitats c’uajat ti al an ata. ");
INSERT INTO husNT1971_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ca t’aja’chic alhua’ c’al a at inicchic abal quit t’ajchin ti cuenta ejtil max pel tit tajaxtalab c’al jaja’chic. Tam ojni’ c’al ta ebal ne’ets ca puhuenchat im bij i Tata ti eb. ");
INSERT INTO husNT1971_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Yab ca belchi jahua’ u uxnal abal in che’neccua’ cu talabethanchi an ts’ejcath cau binath c’al a Moisés ani jahua’ thuchathits c’al in caulomejilchic a Dios. In che’nec abal cu exobchinchi in tequeth ey ani yab cu talabethanchi. ");
INSERT INTO husNT1971_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Lej chubax jahua’ tu uchalchic abal ni jita’ yab ne’ets quin ejtou quin talabethanchi an ts’ejcath cau. Biyat hua’ats an eb ani an tsabal yab ne’ets ca pacuhuat ni jun i letra ani ma ni jun i tsacam pejach i letra. Ojni’ ne’ets ca tala’ putun jahua’ thuchath. ");
INSERT INTO husNT1971_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Jaxtam jitats quin jec’onchi nixe’ xi ts’ejcath cau, aba ani’ pel i uchbixtalab axi más tsipcats in ey ti al an ts’ejcath cau, ani max quin exobchi q’ue’atchic quin jec’onchi jaye, jats ne’ets ca tsu’tat más tsipcats in ey tin c’uajattal a Dios ti eb jun ti jaja’ in t’ajal ti lej Ts’ale. Ani jitats quin t’aja’ jahua’ in ulal an ts’ejcath cau ani quin exobchi q’ue’atchic quin t’aja’ jaye, jats ne’ets ca tsu’tat pulic in ey tin c’uajattal a Dios ti eb jun ti jaja’ in t’ajal ti lej Ts’ale. ");
INSERT INTO husNT1971_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Nan tu uchalchic abal ne’ets quit otsits tihua’ expith max a t’ajal jahua’ chubax alhua’ c’al a Dios. Yab ne’ets quit otsits max expith a eb t’ajalq’ui alhua’ ejtil an exobchixchic c’al an ts’ejcath cau ani an fariseochic. ");
INSERT INTO husNT1971_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Tata’chic tu c’al exobalil it olchinenequits jant’o ti uchbiyat am biyalabchic c’al an ts’ejcath cau binath c’al a Moisés yab quin tsemtha’ an iniccua’, ani max hua’ats i tsemthomac ca lejat ts’ejca tin tamet an ts’ejcom cau. ");
INSERT INTO husNT1971_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ani xo’ nan tu uchalchic abal jitats ca thubat alq’uith tsacuy c’al in at inic, ne’ets ca lejat ts’ejca tin cuenta in hualab. Jitats quin quithab ucha’ in at inic, ne’ets ca ts’ejca c’al an cuenel axi c’athpich in ey an ts’ejcom cau tin cuenta an tiyopanchic Israel. Jitats quin othnach ucha’ in at inic, ne’ets ca jolbiyat ma ca jolohuat ti al am pulic c’amal. ");
INSERT INTO husNT1971_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Hualam max jun a q’uicha ne’ets ca bina’ i ts’acchixtalab c’al a Dios jun tu ts’acnaxnab ti al an tiyopan, ani tameq’ui ca t’ilpa’ abal it hualbinenec c’al a at inic. ");
INSERT INTO husNT1971_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Yabaye ca bina’. Tocat ca jila’ utat an ts’acnaxtalab ani quit c’ale quit juncun c’al jaja’, ani tiq’uele tam quit huichiy ca bina’ an ts’acchixtalab. ");
INSERT INTO husNT1971_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Max it junax ne’ets c’al a tomolnaxil abal quit ts’ejcanchat an cau c’al an oc’lecchic, in tomnalac ca cuete’ ts’ejca’chic an cau ti bel. Tam jaja’ yab ne’ets ti ne’tha’ c’al an ts’ejcom cau, ani yab ne’ets quit baliyat al an huic’axte’. ");
INSERT INTO husNT1971_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Lej chubax max yab ca cuete’ ts’ejca’ c’al a tomolnaxil an cau ani max quit baliyat al an huic’axte’, yab ne’ets quit thubat caltha ma ta ca quithat jalbiyits jahua’ it uchanits ca jalbiy c’al an ts’ejcom cau. ");
INSERT INTO husNT1971_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","It olchinenequitschic jaye abal am biyalabchic uchan c’al an ts’ejcath cau yab ca uxumbejin ani yab ca inicbejincua’. ");
INSERT INTO husNT1971_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ani xo’ nan tu uchalchic max an inic quin met’a’ i uxum ani expith quin at’ax tsalpay ja’its pel i uxumbe. ");
INSERT INTO husNT1971_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Max ti hualbinthalac a hual ca t’aja’ ejtil max ca t’ajat caltha’ jun a hual ani ca pet’na’. In tomnal calthach jun a hual ani yab quit jolohuat ti al am pulic c’amal c’al a inictal quithat. ");
INSERT INTO husNT1971_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Max ti hualbinthalac a c’ubac ca t’aja’ ejtil max ca t’ajat muts’q’uiy jun a c’ubac ani ca pet’na’. In tomnal muts’q’uith jun a c’ubac ani yab quit jolohuat ti al am pulic c’amal c’al a inictal quithat. ");
INSERT INTO husNT1971_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Uchbiyat jaye am biyalabchic max in le’ quin jilcacay in tomquil ca oc’ox ts’ejcanchat an uxum an u jun tu olnab abal yabats tomquithchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Xo’ nan tu uchalchic max an inic quin jilcacay in tomquil yab tin ebal abal pel i inicbe, pel in hualab an inic max ca inicbejin an uxum. Ani pel i uxumbe an inic jitats ca tomquin c’al i uxum axi jilcacathits tin ebal abal pelac i inicbe. ");
INSERT INTO husNT1971_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","It olchinenequitschic jaye jant’o ti uchbiyat am biyalabchic tam in cubamalits jant’o ti lej chubax tin tamet a Dios. Quin lej chubax t’aja’ jahua’ im bijith uchamalits a Dios ne’ets quin t’aja’cua’. ");
INSERT INTO husNT1971_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ani xo’ nan tu uchalchic abal yabats ca cuba’ jant’o ti lej chubax. Yab ca cuba’ ti chubax an eb, cum an eb pel in c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Yab ca cuba’ an tsabal, cum a Dios jats pel an lej abatnom ti tsabal. Ni yab ca cuba’ ti lej chubax am bichou Jerusalén, cum jaye pel in c’al am pulic Ts’ale Dios ti eb. ");
INSERT INTO husNT1971_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Aniye jaye yab ca cuba’ ti chubax a oc’, cum yab pel a lej c’al. Yab a ejtohual ca thacni’betha’ ni jun a xi’il axi t’unu’ ani yab a ejtohual ca t’unu’betha’ axi thacni’. ");
INSERT INTO husNT1971_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ni jant’o yab ca cuba’ ti lej chubax, expith ca t’ajat ucha’ max ojni’ ne’ets ca t’aja’ jant’o o max iba yab ne’ets ca t’aja’. Max ca uchaye más i cau, tam ti hui’quiyal an teneclab. ");
INSERT INTO husNT1971_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","It olchinenequitschic jaye abal uchbiyat am biyalabchic c’al an ts’ejcath cau max ca q’uibethanchat jun in hual, tam ca q’uibethanchat jaye jun in hual an q’uibethanchix. Max ca pejcanchat in camab, tam ca pejcanchat jaye jun in camab am pejcanchixcua’. ");
INSERT INTO husNT1971_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ani xo’ nan tu uchalchic yab ca huichbanchi jitats ti t’ajchi quithab. Max jita’ ti cuajchi ta ts’a’ub, ca huenc’onchi jaye axi jum poq’ue’. ");
INSERT INTO husNT1971_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Max quit t’e’tsiyat alq’uith tin tamet an ts’ejcom cau, ani an t’e’tsix max quin le’na’ ti tixc’anchi a coton, ca jila’ jaye quin ne’tha’ a pulic coton. ");
INSERT INTO husNT1971_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Max i soldado ti ucha’ ca quitnanchi i quitalab jun i kilómetro, ca quitnanchi tsab i kilómetro. ");
INSERT INTO husNT1971_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Max jita’ ti conchi jant’o, ca pitha’. Max jita’ ti conchi jant’o matith, yab ca ucha’ yab ne’ets ca matinchi. ");
INSERT INTO husNT1971_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","It olchinenequitschic jaye abal uchbiyat am biyalabchic quin c’anitha’ in ja’ub ani quim pojca in tomolnaxilcua’. ");
INSERT INTO husNT1971_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ani xo’ nan tu uchalchic ca c’anitha’ a tomolnaxil ani ca conchinchi i alhua’talab c’al a Dios jitats ti quithab uchal. Ca t’ajchi alhua’ jitats ti pojcal. Ca conchinchi c’al a Dios i alhua’talab jitats ti quithab cahuiliyal ani jitats ti othnal. ");
INSERT INTO husNT1971_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Max antsana’ ta ca t’aja’, tam ojni’ ne’ets quit exlachic ti tsacamil i Tata ti eb. Ja’its i Tata ti eb in junini’ abchal in tajax a q’uicha axi alhua’ inic ani jaye axi pojcax inic. In junini’ ulthanchal an ab axi pututh inic ani jaye axi yab pututh inic. ");
INSERT INTO husNT1971_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","A Dios yab ne’ets ti lablinchi max expithq’ui a c’anithal jitats ti c’anithal. Ma am bats’c’ul jalbixtalab tumin c’al an gobierno antsana’ tu c’anithomchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Max expithq’ui it t’ilomchic c’al a ja’ub, yab ne’ets quit tejhua’me tit alhua’ inic. Ma axi yab exlom c’al a Dios antsana’ u t’ilomchic jaye. ");
INSERT INTO husNT1971_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Jant’ini’ i Tata ti eb in cua’al in ichich jum putat alhua’, antsana’ tata’chicte ta ca co’oy a ichich. ");
INSERT INTO husNT1971_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Ca t’aja’ ti cuentachic yab ca t’ojonchi a Dios expith abal quit tsu’tat tit alhua’ c’al a at inic. Max antsana’ ta ca t’aja’, i Tata ti eb yab jant’o ne’ets ti pitha’ i atabilab. ");
INSERT INTO husNT1971_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Tam ca ts’ejhualiy an ts’ejhuantalchic c’al jant’o, yab ca t’aja’ ejtil jaja’chic axi tocat in t’ajal eb alhua’q’ui. Ti tiyopan ani ti bel u ts’ejhualix expith abal ca olna ti alhua’. Lej chubax nan tu uchalchic abal c’al nixe’ xi olnomtalab im bats’umalits in atabil. ");
INSERT INTO husNT1971_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Axi tata’chic tu c’al nana’ ca tsinat ts’ejhualiy an ts’ejhuantalchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Antsana’ yab ne’ets quit tejhua’me c’al a at inic max it ts’ejhualix. Expith i Tata ti eb jats ne’ets ti lej tsu’u ani jats ne’ets ti pitha’ i atabilab. ");
INSERT INTO husNT1971_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Tam quit olonchic yab ca t’aja’ ejtil axi eb t’ocatq’ui tu ol. In culbetnal ti ol jun ta ca tsu’tat ti t’ocatac, max ti tiyopan o max ti bel. Lej chubax nan tu uchalchic abal c’al nixe’ in cua’alits in atabil. ");
INSERT INTO husNT1971_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Tata’chic tam quit olon quit otsits alta ta q’uima’ ani ca mapuy an hui’leb. Tats ti quit olon c’al i Tata ti eb tsinat. Expith jaja’ ne’ets ti tsu’u ani jaja’ ne’ets ti pitha’ i atabilab. ");
INSERT INTO husNT1971_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Tam quit olonchic yab quit alq’uith ulu’in c’al i cau ejtil in t’ajal axi yab exlom c’al a Dios. In q’uibts’oth tsalpayal abal ne’ets ca lej ats’an c’al a Dios tin ebal c’al yantalam i cau. ");
INSERT INTO husNT1971_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Yab ca t’aja’ ejtil jaja’chic, cum i Tata ti eb in lej exlalits jant’ots a yejenchal aba ma yabaye a conchamal. ");
INSERT INTO husNT1971_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Jaxtam antsana’ ne’ets quit olon: I Tata ti eb i c’ac’nanchal a bij. ");
INSERT INTO husNT1971_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Quit chich ca t’aja’ tit lej Ts’ale teje’ tsabal. Quin t’ajchi jaye an inicchic a culbetal teje’ tsabal jant’ini’ tu lej t’ajnal a culbetal tihua’ ti eb. ");
INSERT INTO husNT1971_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Tucu pithanchi qui c’apu jant’ots i yejenchal axe’ xa q’uicha. ");
INSERT INTO husNT1971_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Tucu paculanchi i hualab cum i paculanchal jitats tucu t’ajchi i hualabtalab. ");
INSERT INTO husNT1971_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Tucu lotocna’ abal yab cu c’ale jun ti cu hualbin. Tucu jec’ontha’ c’al an teneclab. Tata’its expith it lej pulic Ts’ale. A cua’al a lej tsap ani a ts’alat axi ne’ets ca ohuey abal ets’ey. Amén. ");
INSERT INTO husNT1971_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Max tata’chic ca paculanchi jitats ti t’ajchi i hualabtalab, a Tata ti eb ne’ets ti paculanchi a hualab jaye. ");
INSERT INTO husNT1971_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Yab ne’ets ti paculanchi a Tata ti eb, max yab ca paculanchi a at inic. ");
INSERT INTO husNT1971_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Tata’chic tam it pabil c’al an c’apnel yab ca t’aja’ ejtil axi eb t’ocatq’ui in t’ajal. In t’ajal in hual lej t’e’pith abal ca tsu’tat u pabil. Lej chubax nan tu uchalchic abal c’al nixe’ in cua’alits in atabil. ");
INSERT INTO husNT1971_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Tata’chic tam it pabil ca co’oy t’acath a hual ani ch’ichbath a xi’il. ");
INSERT INTO husNT1971_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Antsana’ yab ne’ets quit tsu’tat max it pabil. Expith i Tata ti eb jats ne’ets ti tsu’u tit pabil ani jats ne’ets ti pitha’ i atabilab. ");
INSERT INTO husNT1971_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Yab ca tamcuychic yan an c’alab axi teje’ tsabal, cum yab ja ax u ohuel. Hualam ne’ets ti c’apts’unchi tocat an thum. Hualam ne’ets ca cuete’ c’atsey o max ca cue’eyat. ");
INSERT INTO husNT1971_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Más alhua’ ca luba’ ca co’oy i c’alab axi tihua’ ti eb. Jats axi yab ne’ets ca c’apts’uhuat c’al an thum. Yab ne’ets ca cuete’ c’atsey ani yab ne’ets ca cue’eyat. ");
INSERT INTO husNT1971_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","An c’alab axi tata’chic a tsu’talits ley c’athpich huinat alhua’, jats ne’ets ca junini’ tsalapna’ ta ichich. ");
INSERT INTO husNT1971_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","C’al a hual a tsu’talchic an tajax. Max lubach a hual a ejtohual tiquin tajax tsu’u nana’ tin tajax a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Max yab lubach a hual yab ne’ets tiquin tsu’u. Tiquin co’oy nana’ tin tajax a Dios ta ichich ani iba an yic’uax lej t’ununul. ");
INSERT INTO husNT1971_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Yab a ejtohual ca co’oy tsab i amulab, cum ne’ets ca c’athpich c’anitha’ axi jun ani axi jun iba. Ne’ets ca putu c’al in uchbixtal c’al axi jun ani c’al axi jun iba. Ni abal jay yab a ejtohual ca c’anitha’ a Dios ani jaye ca t’ajat c’anitha’ an tumin. ");
INSERT INTO husNT1971_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Nan tu uchalchic yab quit xe’tsin tsalpopol c’al an c’apnel, ani c’al an uts’nel, ani c’al an toltom. In exbath a ejattal lej c’athpich yab ejtil in exbath an c’apnel, ani in exbath a inictal lej c’athpich yab ejtil in exbath an toltom. ");
INSERT INTO husNT1971_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ca t’aja’chic ti cuenta an ts’itsinchic abal yab u om, ani yab u c’ojol, ani yab in thayal jant’o ti al an huilte’. Bel u c’apulchic, cum expith c’al i Tata ti eb u pijchab. A exbath tata’chic lej c’athpich yab ejtil in exbath an ts’itsin. ");
INSERT INTO husNT1971_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Aba ma ca lej xijc’ath luba’ ta ba’ quit t’ec’atme ts’ejel metro, ni abal jay yab ne’ets ca ejtou. ");
INSERT INTO husNT1971_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Yab in tomnal quit xe’tsinchic tsalpopol c’al an toltom. Ca t’aja’chic ti cuenta jant’ini’ tu puhuel an huits. Yab ja tin ebal abal u t’ojnal, ani yab tin ebal max u huichalac abal quin ts’ejca’ tim ba’. ");
INSERT INTO husNT1971_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Nan tu uchalchic abal an ts’ale Salomón c’al patal in ts’alat toltomil yab im baju in alabental ejtil an huits. ");
INSERT INTO husNT1971_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","C’al a Dios jats tu ts’ejcanal an huits c’athpich alabel. Ti jun a q’uicha ejate, ani ti jun a q’uicha tsemenequits ani ca chican. Cum más a exbathchic c’al a Dios, más ne’ets ti t’ajchi. Tata’chic ojni’ yabaye a alhua’ belamalchic a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Yabats quit xe’tsin tsalpopol ani cononol ta ichich c’al an c’apnel, ani c’al an uts’nel, ani c’al an toltom. ");
INSERT INTO husNT1971_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Axi yab u exlom c’al a Dios jats axi xe’ets tsalpopol c’al jahua’ teje’ tsabal. Tata’chic yab antsana’ ta ca t’aja’, cum a cua’al a Tata ti eb ax in tso’obits patal jahua’ a yejenchal. ");
INSERT INTO husNT1971_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Expith ca junini’ jilchichic a Dios quin t’aja’ ti Ts’ale ta ichich ani ca junini’ t’aja’ bolith jant’ini’ jaja’ tin le’, ani tamna’ jaja’ ne’ets ti pitha’chic patal jahua’ ca yejenchi teje’ tsabal. ");
INSERT INTO husNT1971_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Jaxtam yabats quit xe’tsinchic tsalpopol jant’oye ta ca huat’a’ calam. Tam ca chutheyits, tam ne’ets ca yejenchi ca lej t’aja’ ti cuenta jant’o ta ca huat’a’. Ta q’uicha ta q’uicha bijithits jant’o qui yajchicna’. ");
INSERT INTO husNT1971_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Yab ca jolbiychic a at inic, ani a Dios yab ne’ets ti jolbiy. ");
INSERT INTO husNT1971_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ma ju’tam huichat tata’ ca jolbiy a at inic, antsana’ jaye a Dios ne’ets ti jolbiy. ");
INSERT INTO husNT1971_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Tata’chic ojni’ a huat’ath t’ajchal ti cuenta in tsacam hualab a at inic, ani yab a t’ajal ti cuenta a pulic hualab. Ejtil max ca tsu’chi an tsacam amul tin hual a at inic, ani yab a t’ajal ti cuenta am pulic te’ axi c’uajat ta hual. ");
INSERT INTO husNT1971_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","A uchal a at inic abal ti jilchi ca tixc’anchi an amul tin hual, ani yab a t’ajal ti cuenta am pulic te’ axi ta cuete’ hual. ");
INSERT INTO husNT1971_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Tocat it eb t’ocatq’ui. Ca oc’ox tixc’a’ am pulic te’ ta hual, ani tiq’uele ne’ets quit tajax tsu’xinits abal ca tixc’anchi an tsacam amul tin hual a at inic. ");
INSERT INTO husNT1971_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Jahua’ huinat alhua’ axi pel in c’al a Dios yab ca pithanchi an inicchic axi ejtil i pic’o’, i canats ti c’a’chiquiy ejtil i pic’o’. Ani jahua’ huinat alabel ani ts’alat yab ca pithanchi an inicchic axi ejtil i olom, i canats quin alq’uith q’uets’chiquiy ejtil i olom. ");
INSERT INTO husNT1971_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Max jant’o ca conchi c’al a Dios, jaja’ ne’ets ti pitha’. Ani jant’ots a aliyal, jaja’ ne’ets ti tolminchi ca ela’. Max ca tauna’, jaja’ ne’ets ti toc’tsiy. ");
INSERT INTO husNT1971_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Jitats u conchix ne’ets ca pithan. Jitats u alim ne’ets ca tolminchat quin ela’. Jitats u taunom ne’ets ca toc’tsiyat. ");
INSERT INTO husNT1971_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Max a tsacamil ti conchal i pan yab ne’ets ca pitha’ i t’ujub. ");
INSERT INTO husNT1971_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Max ti conchal i to’ol yab ne’ets ca pitha’ i tsan. ");
INSERT INTO husNT1971_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Aba ma yab it lej alhua’chic, bel a exlal ca pitha’ a tsacamilchic jahua’ alhua’. Ani más i Tata ti eb axi lej c’athpich huinat alhua’ ne’ets quim pitha’ jahua’ alhua’ jitats ta ca conchin. ");
INSERT INTO husNT1971_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Jant’ini’ tata’chic a le’ quit t’ajchin alhua’, antsana’ ta ca ets’ey t’ajchi a at inic. Antsana’ tin ulal an ts’ejcath cau binath c’al a Moisés ani an u thuchath c’al in caulomejilchic a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Quexat an otsnab ani ts’icoth am bel jun tu otsel yantalam i inic axi ne’ets ca q’uibey abal ets’ey. Tata’chic ca belna’ am bel axi xuyat in otsnab. ");
INSERT INTO husNT1971_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Xuyat an otsnab ani t’ililil am bel jun tu otsel huachic an inic axi ne’ets ca it ejatliyat abal ets’ey c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Yab ca hualca’ ta ba’chic quit c’ambiyat c’al i q’uet’ach caulomechic axi quin le’na’ ca otsits c’al tata’chic. Pel i c’ambix cum in t’ajal ejtil max pel i maxu oveja, ani tin lej ichich ejtil i pathum ax u c’apux. ");
INSERT INTO husNT1971_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ne’ets ca tequeth exlanchi in lej eychic c’al in t’ojlabil. Am bathuch yab im binal i hualilab lab t’uthub, ani an cholich yab im binal i hualilab lab bec. ");
INSERT INTO husNT1971_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Patal an te’ axi alhua’ im binal i alhua’ hualilab, ani an te’ axi yab alhua’ im binal i quithab hualilab. ");
INSERT INTO husNT1971_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Axi alhua’ an te’ yab in ejtohual quim bina’ i quithab hualilab, ani axi yab alhua’ an te’ yab in ejtohual quim bina’ i alhua’ hualilab. ");
INSERT INTO husNT1971_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Patal an te’ ax im binal hualim i quithab hualilab ne’ets ca cotoyat ani ne’ets ca jolohuat ti c’amal. ");
INSERT INTO husNT1971_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ne’ets ca exla’chic c’al in t’ojlabil yab alhua’ an q’uet’ach caulomechic. ");
INSERT INTO husNT1971_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Yab patalchic axi tiquim bijiy tin Ajatic ne’ets ca otsits ti eb jun ti a Dios in t’ajal ti lej Ts’ale. Expith ne’ets ca otsits jitats quin t’ajchi in culbetal u Tata ti eb. ");
INSERT INTO husNT1971_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Tam quim baju a q’uicha nan cu ts’ejca’ an inicchic, yantalam jaja’chic ne’ets tiquin ucha’: Ajatic Ajatic, c’al a bij i olnamal in cahuintal a Dios ani c’al a bij i calthamal i at’ax teneclab. Ma i t’ajamal yan i labith t’ajbilab c’al in tsap a bij. ");
INSERT INTO husNT1971_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Tamna’ nan ne’ets cu tequeth ucha’chic: Ni jayq’ui’ nan yab tu exlamal tu c’al. Quit tixc’an c’al nana’ ax a t’ajamal yab alhua’. ");
INSERT INTO husNT1971_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Jitats tiquin ats’anchi u cahuintal ani tiquin t’ajchi, pel ejtil i tsalpath ts’ejcom ata ax in cuba’ i ata tin t’ujub cub. ");
INSERT INTO husNT1971_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Lej ulits an ab ani juchun an ic’. Lej puhuey am pulic itse’ ma an ja’ im baju in acan an ata, ani yab cuajla cum in cua’al in lej alhua’ cub. ");
INSERT INTO husNT1971_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Jitats tiquin ats’anchi u cahuintal ani yab tiquin t’ajchi, jayetseq’ui ejtil i ts’ejcom ata. Pelchic xe’ ejtil i ts’ejcom ata axi macu’ in tsalap in cuba’ i ata eblimq’ui i quithib. ");
INSERT INTO husNT1971_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Lej ulits an ab ani juchun an ic’. Lej puhuey am pulic itse’ ma an ja’ im baju in acan an ata, ani t’ajat cuajla lej tumumul. ");
INSERT INTO husNT1971_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Talits ti cau a Jesús ani lej jic’panchab in exobchixtal c’al an mulcunel. ");
INSERT INTO husNT1971_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Antsana’ tu jic’panchab cum pel in lej exobchixtal axi lej abath c’al a Dios. Yab ja ejtil in exobchixtal an exobchixchic c’al an ts’ejcath cau binath c’al a Moisés. ");
INSERT INTO husNT1971_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Pa’iyits a Jesús ti al am bolchal, ani ts’at’enchab c’al yantalam i inic. ");
INSERT INTO husNT1971_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ani utey jun i inic ax in cua’al i t’it’ c’apux c’al in anam t’u’ul. In tuthu in c’ualal tin tamet a Jesús, ani in ucha’: ―Ajatic, max a le’ac a huit’al tiquin jeltha’. ");
INSERT INTO husNT1971_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Tam a Jesús in tacchi c’al in c’ubac, ani in ucha’: ―U le’ tu jeltha’, ani ma xohue’ it jelthachits. Ani tameq’ui jun t’ajat jelthajits c’al an t’it’. ");
INSERT INTO husNT1971_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Tam uchan c’al a Jesús: ―Ca t’aja’ ti cuenta yab ca olchi jita’ jahua’ it t’ajchinenec. Expith quit c’ale c’al am pale’ ani ca bina’ an ts’acchixtalab ax in ulal an ts’ejcath cau binath c’al a Moisés in uchbil quim bina’ jitats jelthach c’al an t’it’ axi c’apux c’al in anam t’u’ul. Antsana’ ta ca t’aja’ abal ca tejhua’methanchi an inicchic abal it jelthachits. ");
INSERT INTO husNT1971_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Otsitsits a Jesús ti bichou Capernaum, ani taja’ utey c’al jaja’ jun i inic axi pel i capitán c’al an soldado romanochic. In lej canat tauna’ a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","In ucha: ―Ajatic, tihua’ tu q’uima’ c’uajat mo’ol u tolmihual al i huaytalab tsey. Pel i tsambe ani in lej yajchicnal an yajal. ");
INSERT INTO husNT1971_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Tam uchan c’al a Jesús: ―Ne’ets quin c’ale abal tu jelthanchi. ");
INSERT INTO husNT1971_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Toc’tsin an capitán: ―Ajatic, yab u cua’al u alhua’ abal tata’ quit otsits nan tu q’uima’. Expith ca ulu an cau, ani ne’ets ca t’ajat jeltha u tolmihual. ");
INSERT INTO husNT1971_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","U exlal abal jahua’ tata’ ca ulu, jats ne’ets ca t’ajan. Cum nan in abatnab c’al i oc’lec ani nana’ pel tin abatnom c’al i soldadochic. Max nan cu ucha’ i soldado ca c’ale ju’ta, ne’ets ca lej c’ale. Max nan cu ucha’ i soldado ca chich teje’, ne’ets ca lej chich. Max cu ucha’ u tolmihual quin t’aja’ jant’ots, jats ne’ets tiquin t’ajchi. ");
INSERT INTO husNT1971_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","In jic’pal an c’au a Jesús tam tin ats’a’ an capitán in ulu antsana’. Tam in ucha’ axi ts’at’atchic c’al jaja’: ―Lej chubax nan tu uchalchic abal yab ju’ta u elamal jitats lej belom ejtil axe xi capitán. Ma ni c’al an Israelchic yab u elamal. ");
INSERT INTO husNT1971_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nan tu uchalchic abal ne’ets ca chich yantalam i inic ti calel q’uicha ani ti otsel q’uicha, ani ne’ets ca otsits ti eb jun tin t’ajal a Dios ti lej Ts’ale. Ne’ets ca buxcanchic ti c’apul junat c’al a Abraham, ani c’al a Isaac, ani c’al a Jacob. ");
INSERT INTO husNT1971_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Hua’ats an Israelchic in tsalpayal abal ne’ets ca otsits ti eb expith abal pel i at xits’lab c’al a Abraham, ani expith ne’ets ca jolohuat ti al am pulic yajchictalab jun ti lej yic’uax. Tats ti ne’ets ca uq’uinchic ani ca huech’ech’lats in camab c’al an lej yajchictalab. ");
INSERT INTO husNT1971_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Tam uchan an capitán c’al a Jesús: ―Xo’ quit c’ale ta q’uima’, cum jant’ini’ ta belamalits antsana’ ne’ets quit t’ajchin. Tameq’ui jun jic’tohual ti jelthanchatits in tolmihual. ");
INSERT INTO husNT1971_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","C’ale a Jesús tin q’uima’ a Pedro, ani tats tin tsu’u in uxum iyam a Pedro mo’ol al i huaytalab tsey c’al i c’aq’ueltalab. ");
INSERT INTO husNT1971_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","In tacchi in c’ubac, ani jun t’ajat tixc’anchatits an c’aq’ueltalab. Tam ts’acpan ani im pijchi a Jesús junax c’al in junquilchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Otscanits a q’uicha, ani u chanchinale a Jesús yan i inicchic ax u co’oyab c’al an at’ax teneclab. Tocat c’al in cahuintal in canchalchic. Jaye in jelthal patal axi ya’ulchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Antsana’ tu putnal jahua’ in ulumalits in caulomejil a Dios Isaias tin cuenta a Jesús antse’: Jaja’ pel i tsaplix c’al axi palulul in inictal ani pel i jelthom c’al an ya’ulchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Cum in tsu’u a Jesús tin tonith hua’ats yantalam i inic, tam in ucha’ in exobalilchic: Huana cu c’ale jum poq’ue’ am pulic lejem. ");
INSERT INTO husNT1971_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Tameq’ui ti utey c’al a Jesús jun i inic axi pel i exobchix c’al an ts’ejcath cau binath c’al a Moisés. In ucha: ―Exobchix, nan ne’ets tu ts’at’enchi abal ju’tamaquits quit c’ale. ");
INSERT INTO husNT1971_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","A Jesús in toc’tsiy: ―An occhic in cua’al an jol ju’ta ta ca c’uajiy ani an ts’itsinchic in cua’al in c’util ju’ta ta ca coyots, ani nana’ tin Juntal patal an inicchic ma yab u cua’al i ata ju’ta tu cu mo’ca’ u oc’. ");
INSERT INTO husNT1971_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Tam uchan a Jesús c’al jun i exobal: ―Ajatic, tiquin aychi ma ca tsemets u tata ani cu joliy, tam tiq’uele ne’ets tu ts’at’enchi. ");
INSERT INTO husNT1971_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","A Jesús in toc’tsiy: ―Tiquin jun t’ajat ts’at’enchi ma xohue’its. Ca jila’ ca joliyat an tsemelomchic c’al axi yab ejat c’al nana’ u bij. ");
INSERT INTO husNT1971_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Taley otsits a Jesús junax c’al in exobalilchic ca c’ale al i tan. ");
INSERT INTO husNT1971_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Tam ti ne’etsits al an ja’ thayc’an jun i tsapic ic’ ani lej lanq’uil an ja’, ma huachiquits ca uc’tsin an tan. Ani a Jesús huayamath. ");
INSERT INTO husNT1971_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Tam ejtsintha ani uchan: ―Ajatic, tucu jaluntha’ cum u uc’tsinalits. ");
INSERT INTO husNT1971_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","A Jesús in toc’tsiychic: ―¿Jale’ it lej jiq’uelchic? Jats cum yabaye tin alhua’ belamal. Tam ts’aquiy a Jesús in c’uiya’ an ic’ ani an ja’. Tameq’ui t’ajat cubiyits an ic’ ani yabats lanq’uil an ja’. ");
INSERT INTO husNT1971_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ani in exobalilchic in lej jic’pal ani in conoyal: ―¿Jita’ tam inic hualam jaja’ abal in ejtohual quin abatna’ an ic’ ani an ja’? ");
INSERT INTO husNT1971_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Taley ulits a Jesús jum poq’ue’ am pulic lejem tihua’ ti tsabal Gadara. Taja’ in tamu tal ti bel tsab i inic axi c’uajil ti al i jolimtalab tsemelom. Cum u co’oyab jaja’chic c’al i at’ax teneclab ani lej thimalon, jaxtam ni jita’ yab in inicnal tim ba’ ca huat’ey al nixe’ xi bel. ");
INSERT INTO husNT1971_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Tam an teneclabchic tin ichich nixe’ xi inic in thajanthalchic quin thajat ucha’ a Jesús antse’: ―Tata’its pel it Jesús ti Tsacamil a Dios. ¿Jant’o tam eyaltalab a cua’al abal tucu otsanchi? Yabaye im bajumalits an q’uij abal tata’ tucu yajchiquiy. ");
INSERT INTO husNT1971_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Taja’ xe’ets hue’ utat i pulic cuenel i olom ti ac’ul. ");
INSERT INTO husNT1971_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ani lej canat uchan a Jesús c’al nixe’ xi at’ax teneclabchic antse’: ―Max ne’ets tucu caltha’, tucu pitha’ an q’uij abal qui c’uajchiy tin inictal nixe’ xi olomlom. ");
INSERT INTO husNT1971_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Tam a Jesús in toc’tsiychic: ―Bel quit c’aletschic ca c’uajchiy. Tam calpachiquin an at’ax teneclab tin ichich axi tsab i inic, ani otsitschic quin c’uajchiy tin inictal an olomlom. Ani taley thubat tala’ jololol ti c’ale an olomchic al i cotoblom ma ijcachiquinits al am pulic lejem. Tats ti t’ajat uc’tsinchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Taley am beletnomchic c’al an olomlom athithil c’ale quin olna’ ti bichou. In tala’ t’ilchi am bichou jant’ini’ ti canchinenec an at’ax teneclabchic nixe’ xi tsab i inic. ");
INSERT INTO husNT1971_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Tam c’ale tim patal am bichou abal quin tsu’u a Jesús. Ani tam tin tsu’uhuits, tam in lej canat ucha’ abal ca lejat tixc’anits al nixe’ xi cuenchal. ");
INSERT INTO husNT1971_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Taley otsits a Jesús al i tan ani huat’ey jum poq’ue’ am pulic lejem, ani ulits tim bichohuil. ");
INSERT INTO husNT1971_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Taja’ u chanchinal jun i tsambe cuatsat al i tseyte’ tat. Ani tam ti a Jesús in tsu’u abal in lej belalchic, in ucha’ an tsambe: ―Quit culbe tsacamil, cum nan tu paculanchal a hualab. ");
INSERT INTO husNT1971_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Taja’ hua’ats talchic i exobchix c’al an ts’ejcath cau in tsalpanchal jahua’ a Jesús antsana’ in ucha’ an tsambe. In uluchic tin ichich jale’ in t’ajal ejtil max pel a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","A Jesús in exla’its jant’ini’ tu tsalpanchab c’al jaja’chic, ani jaxtam in ucha’: ―¿Jale’ tata’ chic tin q’uibts’oth tsalpanchal u ey? ");
INSERT INTO husNT1971_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Yab q’uibat abal nan cu ucha’ an tsambe nan tu paculanchal a hualab, ani yab q’uibat jaye cu ucha’ quit ts’aquiy ani quit belats. ");
INSERT INTO husNT1971_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Nana’its tin Juntal patal an inicchic, ani c’al u eyaltal tin jelthom tiquin exlanchi u ey abal u cua’al jaye u eyaltal teje’ tsabal cu paculanchi in hualab an inic. Tam a Jesús in ucha’ an tsambe: ―Quit ts’aquiy ca thaya’ a tseyte’ tatil ani quit c’alets ta q’uima’. ");
INSERT INTO husNT1971_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ma tamits ti ts’acpan jelthachits, ani ta c’alets tin q’uima’. ");
INSERT INTO husNT1971_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Tam tin tsu’u an inicchic abal antsana’ t’ajchinenec an tsambe c’al a Jesús, in lej jic’ palchic. Jaye im puhuethanchal jaja’chic im bij a Dios, cum pithame a Jesús in eyaltal antsana’ quin t’aja’ i labith t’ajbilab. ");
INSERT INTO husNT1971_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Taley tixc’an a Jesús ti al nixe’ xi c’uajattalab, ani tam ti ne’ets ti bel in tsu’u quetel jun i inic jun tu bats’uhuab an jalbixtalab tumin tin cuenta an gobierno. Pelits nana’ in Mateo. Tin ucha’ a Jesús: ―Tiquin ts’at’enchi. Tam in thubat ts’aquiy ani u ts’at’enchi. ");
INSERT INTO husNT1971_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Talbel otsits a Jesús tu q’uima’ ca c’aputs. Ani ulitschic jaye q’ue’at i bats’c’ul jalbixtalab tumin tin cuenta an gobierno ani q’ue’at i hualbith inicchic. Ani c’uajat jaja’chic quetel ti c’apul junax c’al a Jesús ani c’al huahua’ tu exobalil. ");
INSERT INTO husNT1971_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ani cum an fariseochic tu tsu’u u junax quetel huahua’ antsana’, tu conoyal: ―¿Jale’ u junax c’apul a Exobchixal c’al nixe’ xi bats’c’ul jalbixtalab tuminchic tin cuenta an gobierno ani c’al q’ue’at i hualbith inicchic? ");
INSERT INTO husNT1971_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Cum a Jesús in ats’a’ jahua’ antsana’ in conoychic, in ulu: ―Axi lubach an inic yab in yejenchal i ilalix, expith axi ya’ul ojni’ jats in yejenchal. ");
INSERT INTO husNT1971_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Nan in che’nec cu caniy ca chich c’al nana’ ca jic’tson c’al in hualab jitats in lej exlalits tin ichich abal pel i hualbith inic ani iba ax in tsalpayal pel i alhua’ inic. Ca ejtiychic jahua’ in ulal an T’ocat Thuchlab antse’: Nana’ in Dios u le’ abal ca yajnanchi an inicchic, ani yab expith tiquin ts’acchiy c’al i tsemthach co’nel. ");
INSERT INTO husNT1971_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Tam chich c’al a Jesús talchic axi pel i exobal c’al a Juan pujax, ani in conoyalchic: ―¿Jale’ huahua’ ani an fariseochic u lej pabil c’al an c’apnel ani yab u pabil a exobalilchic? ");
INSERT INTO husNT1971_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","A Jesús in toc’tsiychic: ―Yab in tomnal ca t’e’pin ax u tsa’bixchic c’al an tomquintalab biyat c’uajate an tomquinel inic. Max quim baju a q’uicha ca tixc’anenequits an inic tomquinel, tamna’ ojni’ in tomnal ca pablatschic. Tam nan in tixc’anenequits, tam ojni’ in tomnal ca pablats u exobalilchic jaye. ");
INSERT INTO husNT1971_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Yab in tomnal ca c’ua’chiyat am biyal toltom c’al i it pejach i toltom, cum tam ca pac’uhuat ne’ets ca muley axi it ani tam ne’ets ca oume in mits’tal axi biyal. ");
INSERT INTO husNT1971_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Yab in tomnal ca baliyat al i biyal balixtalab ot’ in ja’lil an lab t’uthub ax u it boclinalits. Max ani’ ca t’ajan, ne’ets ca mits’c’an an ot’ ani ne’ets ca huac’lan am boc lab t’uthub. Antsana’ ne’ets ca q’uibey am boc ani ne’ets ca othey am balixtalab ot’. Jaxtam in tomnal ca baliyat in ja’lil an lab t’uthub ax u it boclinalits al i it balixtalab ot’. Tamna’ ne’ets ca ohuey am boc ani jaye am balixtalab ot’. ");
INSERT INTO husNT1971_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Exom ti cahue a Jesús, ani chich jun i inic axi pel i oc’lec tin tiyopanil an Israel. In tuthu in c’ualal tin tamet a Jesús, ani in ucha’: ―Talel ti tsemetsits u ts’ic’achil. Bel aba ani’, quit c’ale ca punchi a c’ubac ca ejtha. ");
INSERT INTO husNT1971_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Tam cubiy a Jesús, c’ale junax c’al an inic ani c’al huahua’ tu exobalil. ");
INSERT INTO husNT1971_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ani ti bel ne’ets jaye jun i uxum ax in cua’al lajuj tsab i tamub yab u tajlunal ti ya’ul ta its’. Utey tin cux a Jesús ani in tacchi in acan in nacat coton. ");
INSERT INTO husNT1971_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","In cuete’ ulumalits tin ichich max expith quin tacchi in toltomil, ne’ets ca jeleycua’. ");
INSERT INTO husNT1971_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Huilq’uin a Jesús in tsu’u an uxum, ani in ucha’: ―Yab quit t’e’pin mimlab, nan xo’ tu jelthal cum tim belamalits. Ma tameq’ui t’ajat jelthachits. ");
INSERT INTO husNT1971_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Taley ulits a Jesús tin q’uima’ nixe’ xi oc’lec ani otsits alta. Taja’ in tsu’u c’uajatits an t’enelchic c’al an tsemelom. Ani thajat uc’nanchab an tsemelom. ");
INSERT INTO husNT1971_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Tam a Jesús in ucha’ axi muthatchic: ―Quit c’alechic eleb. Yab tsemenec an ts’ic’ach, u huayal expith. C’al axe’ xi cau tocat u tilibnath te’nal axi taja’chic. ");
INSERT INTO husNT1971_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Tam ti calejitschic eleb, otsits a Jesús alta jun ti c’uajat an ts’ic’ach. In yac’uchi in c’ubac, ani tameq’ui ts’acpan ejthachits. ");
INSERT INTO husNT1971_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ani thubat olna tim puhuel nixe’ xi tsabal jant’ini’ tin t’ajamal antsana’ a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Tixc’anits a Jesús taja’ ani ts’at’enchab c’al tsab i joc’tsi. Thajat uchan: ―Tata’its axi pel it at xits’lab c’al a David, tucu yajnanchi. ");
INSERT INTO husNT1971_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Tam otsits a Jesús al i ata ani ts’at’at jaye an joc’tsichic. A Jesús in conoy: ―¿A belal abal nana’ u ejtohual tu tsu’uxmetha’? Toc’tsinchic: ―Ojni’ Ajatic, i belal. ");
INSERT INTO husNT1971_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Tam a Jesús in tacchi in hualchic ani in ucha’: ―Jant’ini’ ta belalchic, antsana’ ne’ets tu t’ajchi. ");
INSERT INTO husNT1971_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Tameq’ui t’ajat jelthachits ani tsu’xinchic. Tam a Jesús in lej uluth ucha’chic: ―Ca lej t’aja’ ti cuentachic abal yab ca olchi jita’ jahua’ nan tu t’ajchamalchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Aba ani’ antsana’ uchan c’al a Jesús, bel tocat in lej olnal tim puhuel nixe’ xi tsabal jant’o t’ajchinenecchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Talel ti calejits ca c’ale an joc’tsichic, ani u chanchinal Jesús jun i mo’ inic ax u co’oyab c’al i at’ax teneclab. ");
INSERT INTO husNT1971_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","A Jesús in canchi an at’ax teneclab, ani thubat in ts’i’quiy ti cau axi mo’ac. Ani in lej jic’pal an inicchic axi taja’, in uluchic: ―Ni jayq’ui’ yab i tsu’umal i Israel quin t’aja’ jahua’ xohue’ i tsu’umal in t’ajamal axe’ xi inic. ");
INSERT INTO husNT1971_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Tam an fariseochic in ucha’ axi taja’ muthatchic: ―Axe’ xi inic in calthal an at’ax teneclab c’al in tsap an ts’ale teneclab. ");
INSERT INTO husNT1971_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Xe’ets a Jesús ti tsa’bibil ti al i pulic bichou ani ti al i tsacam bichouchic. In exobchichical an inicchic c’al in cahuintal a Dios ti al in tiyopanilchic an Israel, ani in thajchixnanchal an alhua’ cau jant’ini’ tin t’ajal ti Ts’ale a Dios. Jaye xe’ets ti jelthothol c’al patal jitats u ya’ul ani c’al jitats in cua’al i yajalchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Tam tin tsu’u a Jesús am pulic mulcunel in lej yajnanchal, cum in tsu’u abal lej yajchiquith ani lej t’e’pipil xe’ets. Xe’ets ejtil i q’uibelom ovejachic yab jita’ c’al ta ca beletna. ");
INSERT INTO husNT1971_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Tam a Jesús tu ucha’ huahua’ tu exobalil: ―Lej chubax jant’ini’ max hua’ats yan i huay’ ca c’ojohuat, antsana’ hua’ats yan i inicchic axi ts’ejcathits abal tiquim bela’ nana’. Ani jant’ini’ tam hua’ats lej hue’ an c’ojolchic, antsana’ hua’ats lej hue’ jita’ tiquin olnanchi u bij c’al an inicchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Jant’ini’ an thabal huay’ in abal jita’ ti c’ojol, antsana’ ta ca conchi a Dios abal quin abayechic jita’ tiquin olnanchi u bij c’al an inicchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Taley a Jesús tu caniy cu chich huahua’ tu lajuj tsab tu exobalil, ani tu pitha’chic i eyaltalab abal tu canchix c’al i at’ax teneclab ani tu jelthom c’al patal jahuaquits tam yau’lats ani tam yajalchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Im bijchic axi lajuj tsab tacuthits antsana’chic: An c’a’al pel a Simón Pedro, ani in ebchal Andrés, ani a Jacobo ani in ebchal Juan. Jats nixe’ a Jacobo ani a Juan axi pel in tsacamil a Zebedeo. ");
INSERT INTO husNT1971_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pel a Felipe, ani a Bartolomé, ani a Tomás, ani nana’ tin Mateo axi pelac tim bats’c’ul jalbixtalab tumin tin cuenta an gobierno, ani a Jacobo axi pel in tsacamil a Alfeo, ani a Lebeo ax u bijiyab jaye ta Tadeo. ");
INSERT INTO husNT1971_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Pel a Simón axi pelac i ts’at’el c’al an cuenel ax u bijiyab ti cananista. Taley pel a Judas Iscariote axi ne’ets quin tsinat bina’ a Jesús tin c’ubac in tomolnaxilchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Taley cum ne’ets tucu aba’its a Jesús tin t’ojlabil, tu ucha’chic: ―Yab quit c’ale tin tsabalil axi yab Israelchic ani yab ca tsa’biy am bichoulom ti Samaria. ");
INSERT INTO husNT1971_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Expith quit c’alechic c’al am bichou Israel, cum xe’etschic q’uibenec ejtil i q’uibenec ovejachic. ");
INSERT INTO husNT1971_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ca olnanchichic abal hue’its ne’ets quin t’aja’ a Dios ti lej Ts’ale teje’ tsabal. ");
INSERT INTO husNT1971_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ca jeltha’chic ax in cua’al an t’it’ axi c’apux c’al in anam t’u’ul ani jahuaquits tam yau’lats. Ca ejtha’ an tsemelomchic ani ca canchi an inicchic an at’ax teneclab. Cum nan tu ts’ejhualiy c’al axe’ xi eyaltalab, jaxtam yab ca bats’u i tumin tam ca t’ojontha’. ");
INSERT INTO husNT1971_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Quit c’alechic naptal. Yab ca ne’tha’chic i tumin. ");
INSERT INTO husNT1971_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Yab ca ne’tha’chic i morral, ni tsab i toltom, ni i pajablab, ni i cuayablab. Cum pel in uchbil an t’ojnal ca pijchin. ");
INSERT INTO husNT1971_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Jahuaquitsq’ui tam bichou ani cuenchalab quit ulits, taja’ ca aliy jun i inic axi alhua’. Quit otsits tin q’uima’, ani tats quit junini’ c’uajiy ma tam ti ne’etsits quit cale al nixe’ xi bichou. ");
INSERT INTO husNT1971_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Tam quit otsits tin q’uima’, ca ucha’ abal a le’ abal ca coythanchat in ichich c’al im bij a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ne’ets ti tabatnanchi a cahuintal max pel i alhua’ q’uimath, ani max i tocat ne’ets ti hualbanchi. ");
INSERT INTO husNT1971_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Jitats yab quin le’na’ ti bats’u tin q’uima’ ani yab ti ats’anchi a olnomtal, tam quit tixc’an c’al jaja’ ani quit calechic al nixe’ xi bichou. Ca tininiy am pojoth jahuats ca tha’u ta acan al nixe’ xi bichou tam ne’ets quit cale. Antsana’ ta ca tso’obna abal pojcamejits in cahuintal a Dios taja’. ");
INSERT INTO husNT1971_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Lej chubax nan tu uchalchic abal nixe’ xi inicchic ne’ets ca c’athpich yajchiquiyat tam quim baju an q’uicha tam ca ts’ejca c’al a Dios. Ma an Sodomajibchic ani an Gomorrajibchic c’al im pojcaxtal axi ti biyal yab ne’ets ca c’athpich yajchiquiyat jant’ini’ jaja’chic axi yab ti bats’uhual. ");
INSERT INTO husNT1971_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Tata’chic ne’ets quit c’ale tiquin olnanchi u bij, ani ne’ets ca tamu i inicchic ax u othnax ejtil i pathum ax u othnax c’al an oveja. Jant’ini’ in t’ajal an tsan lej tsalpath, antsana’ tata’chic ca t’aja’ tsalpath. Jant’ini’ an lab cucu’ in t’ajal maxu, antsana’ ca t’aja’ maxu. ");
INSERT INTO husNT1971_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Quit c’uajiychic ts’ejcacathits, cum a tomolnaxil ne’ets ti bina’chic tin c’ubac an eyalchic ti al i tiyopan. Ma taja’ ne’ets quit huithc’oyat ti al in tiyopanil an Israelchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Jaye tu ebal nana’ ne’ets quit bina tin tamet i oc’lec ani i ts’ale axi pel i pil inicchic yab Israel, ani c’al jaja’chic jaye ne’ets tiquin olnanchi u bij. ");
INSERT INTO husNT1971_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Tam tit binathits quit ts’ejca c’al an oc’lecchic, yab quit tsalpaxin tin cuenta jant’o ne’ets ca ucha’chic ani jant’ini’ ti ne’ets quit toc’tsin. Ma tameq’ui a Dios ne’ets ti pitha’ an cau jahua’ ca ulu. ");
INSERT INTO husNT1971_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Yab ne’ets quit cuete’ cahuin, cum an Espiritu Santo jats ne’ets ti pitha’ an cau. ");
INSERT INTO husNT1971_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","I ebchalab ne’ets quim bina’ in at ebchal abal ca tsemtha, ani ma i tatalab ne’ets quim bina’ in cuete’ tsacamilchic abal ca tsemtha. I tsacamchic ne’ets quin tomolna’ in tata ani in mim, ma quin t’aja’ abal ca tsemthachic. ");
INSERT INTO husNT1971_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","C’al tu ebal nana’ jat’hua’ tim patal an inicchic ne’ets ti at’a’chic. C’al a t’ayath cuxuthtal ne’ets quit jalunthachic ma ca taley an q’uij q’uicha. ");
INSERT INTO husNT1971_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Max ti othnal al jun i bichou, quit c’ale ti pil i bichou. Nana’ tin Juntal patal an inicchic ne’ets quin huichiy tam ma yabaye a tala’ tsa’biyamal tim patal am bichouchic Israel. ");
INSERT INTO husNT1971_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","In exbath an exobchix yab u jalunchab c’al in exbath an exobal, ani in exbath an amu yab u jalunchab c’al in exbath an t’ojnal. ");
INSERT INTO husNT1971_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Lejatits max an exobal quin ejtilna’ an exobchix ani an t’ojnal quin ejtilna’ an amu. Nana’its tin tatalab c’al tata’chic tu tsacamil. Max quin oth bijiyat nana’ tin ts’ale at’ax teneclab Beelzebú, tata’chic más ne’ets quit oth bijiyatte. ");
INSERT INTO husNT1971_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Yab ca ts’ejna’ a at inicchic. Jahua’ in tsinat t’ajal an inic ne’ets ca tala’ tejhua’methanchat pil a q’uicha, ani jahua’ in tsinat tsalpayal tin ichich ne’ets ca tso’obnanchat pil a q’uicha. ");
INSERT INTO husNT1971_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Jahua’ nan tu cuete’ uchalchic, jats ca lejquith olchi an inicchic. Jahua’ nan tu tsinat uchal, jats ca thajat t’iloxna’ jun ti ca tala’ ats’an c’al patal an inicchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Yab ca ts’ejna’ a at inic, cum expith in ejtohual ti tsemthanchi a inictal ani iba a ejattal. Tocat ca ts’ejna’ a Dios, cum jaja’ in ejtohual ti tixc’anchi a ejattal ani jaye ti jolou ti al am pulic tsemla. ");
INSERT INTO husNT1971_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","An nujul in nujuhual tsab i tsacam ts’itsin c’al juncats i tsacam tumin. Ani ni jun i tsacam ts’itsin yab u ijcanal tsabal max yab quin le’na’ i Tata ti eb. ");
INSERT INTO husNT1971_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ani jaja’ ti co’onchalits tata’chic ajith tin junchictal a xi’il ta oc’. ");
INSERT INTO husNT1971_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Cum a Dios lej beletnom, jaxtam yab ca ts’ejna’ jant’o quit t’ajchin c’al a at inic. Jaja’ ti tsu’tal a cua’al a lej c’athpich exbath ani yab ejtil an tsacam ts’itsin. ");
INSERT INTO husNT1971_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Patal jitats tiquin olnanchi u bij c’al in at inic, nana’ jaye ne’ets cu olnanchi im bij c’al u Tata ti eb. ");
INSERT INTO husNT1971_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ani jitats tiquin tsinc’onchi u bij c’al in at inic, nana’ jaye ne’ets cu tsinc’onchi im bij c’al u Tata ti eb. ");
INSERT INTO husNT1971_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Yab ca q’uibts’oth tsalpaychic max an inicchic ne’ets ca c’uajiy jun ejet expith tin ebal abal nan in che’nec teje’ tsabal. Ne’ets ca hua’tsin i tomolnaxtalab tin ebal nana’ u ey. ");
INSERT INTO husNT1971_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","In che’nec ani jats ti hua’tsinenequits i tomolnaxtalab. U tomolnab i tatalab c’al in cuitolil, ani i mimlab c’al in ts’ic’achil, ani i uxum iyam c’al in al’ib ts’ic’ach. ");
INSERT INTO husNT1971_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ne’ets ca tomolnáxin jun c’al xi jun tin cuete’ q’uima’. ");
INSERT INTO husNT1971_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Yab u ejtohual cu bijiy tu c’al jitats in c’athpich c’anithal in tata o in mim, ani max nana’ tocat lej hue’ tin c’anithal. Aniye jaye jitats in c’athpich c’anithal in cuitolil o in ts’ic’achil, ani max nana’ tocat lej hue’ tin c’anithal. ");
INSERT INTO husNT1971_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Jaye yab u ejtohual cu bijiy tu c’al jitats yab in le’ ca yajchiquiyat ani ma ca tsemtha tin ebal abal pel i ts’at’el c’al nana’. ");
INSERT INTO husNT1971_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Jitats in le’ expith quin t’aja’ in cuete’ culbetal, jats ne’ets ca q’uibey. Jitats quim bina’ tim ba’ c’al tin ebal nana’ u bij, jats ne’ets ca jec’ontha. ");
INSERT INTO husNT1971_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Jitats ti bats’u tata’chic, tin mac’uchith bats’uhualne. Ani max jitats tiquim bats’u nana’, in mac’uchith bats’uhual a Dios ax tin abamal quin chich teje’ tsabal. ");
INSERT INTO husNT1971_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Jitats quim bats’u axi pel i caulome c’al a Dios tin ebal abal abath c’al a Dios, jaja’ ne’ets quim bats’u jayetseq’ui an atabilab axi ejtil ne’ets quim bats’u an caulome. Jitats quim bats’u jun i alhua’ inic tin ebal abal pel i alhua’ inic, jaja’ ne’ets quim bats’u jayetseq’ui an atabilab axi ejtil ne’ets quim bats’u an alhua’ inic. ");
INSERT INTO husNT1971_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Max jitats ti pithalchic i tsamay ja’ ca uts’a’ tin ebal abal pel it ts’at’el c’al nana’, jaja’ lej chubax ne’ets ca pithan an atabilab c’al u Tata ti eb. ");
INSERT INTO husNT1971_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Talits ti exobchix a Jesús c’al huahua’ lajuj tsab tu exobalil, ani ta c’ale ti al i bichouchic axi taja’ utat abal ca exobchixin ani ca thajchixin c’al in cahuintal a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","C’uajate a Juan pujax ti al an huic’axte’, ani olchinal jant’ini’ ti xe’ets in t’ajal a Cristo. Tam in aba’ tsab in ts’at’elil abal ca c’ale c’al a Cristo. ");
INSERT INTO husNT1971_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Quin conoychic max jaja’ ja’its a Cristo axi bijithits ne’ets ca aban c’al a Dios ca chich, ani max iba quin aychiye más jita’ ca aban. Ulitschic ani antsana’ in conoychic a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","A Jesús in toc’tsiychic: ―Quit c’alechic ca olchi a Juan jahua’ xohue’its a tsu’umal ani jahua’ a ats’amal u t’ajchal an inicchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","U tsu’uxmethal an joc’tsichic ani u jelthal an c’uets’e’chic abal ca alhua’ belats. U jelthal an inicchic ax in cua’al i t’it’ axi c’apux c’al in anam t’u’ul. U ots’oxmethal an tsinechic ani u ejthal an tsemelomchic. U olnanchal an alhua’ cau an ts’ejhuantalchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Lej culbelits jitats t’ayath belom c’al nana’ ani max yab u t’apchinal im belomtal. ");
INSERT INTO husNT1971_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Tam ti c’alets axi tsab in exobalil a Juan, in ts’i’quiy a Jesús quín t’iloxnanchi in ey a Juan c’al axi muthat taja’. In conoychic: ―¿Jant’o tam inic a tsalpay ne’ets ca tsu’uchic tam it c’ale ca tsu’u a Juan tihua’ ti al an joltam? Hualam a tsalpay ne’ets ca tsu’u i inic axi palulul eitil i pacáb tam juchuyab c’al an ic’. ");
INSERT INTO husNT1971_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ani max i, hualam a tsalpay ne’ets ca tsu’u jun i inic lej huinat alhua’ ts’ejcath. Tata’ ojni’chic a alhua’ tso’obits abal axi lej huinat alhua’ ts’ejcath jats ax u c’uajil tin q’uima’ i ts’ale. ");
INSERT INTO husNT1971_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Tiquin lej ucha’ jant’o tam inic a chubax tsalpay ne’ets ca tsu’u max yab i pel i caulome c’al a Dios. Jats jaja’ a Juan, ani in ey jaja’ lej c’athpich yab ejtil axi q’ue’atchic an caulome c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Jats a Juan ax u olnab ti al an T’ocat Thuchlab tam ti a Dios in uchamal an Ajatic antse’: Nana’ in Dios ne’ets cu oc’chith aba’ u caulomejil abal ti ts’ejcacanchi am bel. ");
INSERT INTO husNT1971_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Lej chubax nan tu uchalchic abal a Juan pujax jats axi c’athpich pulic in ey c’al patal an inic axi ma xo’ hua’tsinenequits. Bel abal ani’ antsana’ in ey jaja’ xo’ lej c’athpich, talbel ne’ets ca jalunchat c’al axi más tsipili’ in ey tam a Dios quin t’aja’ ti lej Ts’ale. ");
INSERT INTO husNT1971_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ma tam ti chichits a Juan pujax c’al in cahuintal a Dios ani ma ti xohue’ hua’ats i inicchic ax in lej canat lubal ca otsits c’al a Dios jun tin t’ajal jaja’ ti lej Ts’ale, ani ja’its jaja’chic axi ne’ets ca chubax otsits c’al jaja’. ");
INSERT INTO husNT1971_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Patal am biyal caulomechic c’al a Dios in q’uejab olnamalits abal a Dios antsana’ ne’ets quin t’aja’. Jats in olna’ jaye a Juan. ");
INSERT INTO husNT1971_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Max a le’ ca bela’chic, nan tu uchalchic abal a Juan pel i caulome ejtil a Elias axi ti biyal. Jats a Juan lej bijithits c’al a Dios abal ne’ets ca chich. ");
INSERT INTO husNT1971_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Jitats junat in ichich c’al nana’ u ichich, quin lej alhua’ bina’ in xutsun c’al axe’ xi cau. ");
INSERT INTO husNT1971_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","¿Jant’o c’al tu cu tejhua’methanchi in ey an inicchic axi xo’ xe’ets tsabal? Pelchic ejtil i tsacam ax u ubat’q’ui ti al am plaza. Ca thajat uchan c’al in at ubat’chic antse’: ");
INSERT INTO husNT1971_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","It juchunchame an tsul tam ajib ani yab it bixmats. It yajchic ajtinchame tin q’uichajil an tsemelom ani yab it uq’uincua’. ");
INSERT INTO husNT1971_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Chich a Juan lej pabil c’al an c’apnel, ani a uluchic abal c’uajchith c’al i at’ax teneclab. ");
INSERT INTO husNT1971_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Talbel nana’ tin Juntal patal an inicchic in chichne. Yab im pabil c’al an c’apnel, ani tocat a uluchic pel tin c’apts’uts’ma’ ani pel tin uts’uts’ul. Pel tin ja’ubcua’ am bats’c’ul jalbixtalab tumin tin cuenta an gobierno ani pel tin ja’ubcua’ axi exlath ti lej hualbith inicchic. Aba ani’ antsana’ nana’ ani a Juan u tsalpanchab i ey, bel axi tsalpathchic in alhua’ tso’obits abal huahua’ u pithnenec an tsalpathtalab c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Taley a Jesús in c’uiyath t’iloxnal an inicchic axi al am bichouchic jun tin t’ajamalits jaja’ yan i labith t’ajbilab, cum yab jic’tsonenecchic c’al in hualab ani yab huenc’onenec c’al a Dios. In ulu: ");
INSERT INTO husNT1971_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","―Ts’ejhuantal axi c’uajatchic ti bichou Corazin ani ti bichou Betsaida cum ne’ets ca lej yajchiquiyat. Max ti biyal u t’ajamalac ti bichou Tiro ani ti bichou Sidón an labith t’ajbilab ax u t’ajamal xo’ ti Corazin ani ti Betsaida, jaja’chic jic’tsonenecac c’al in hualab ani huenc’onenecac c’al a Dios. In ca’iyamalaquits i toltom axi ts’ejcath c’al i thapup ani in majuyamalaquits tim ba’ c’al i joltay’ ti tsu’bixtalab abal jic’tsonenequits c’al in hualab ani huenc’onenequits c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Nan tu uchalchic abal axi xo’ u c’uajil ti Corazin ani ti Betsaida ne’ets ca c’athpich yajchiquiyatchic, ani axi ti bichou Tiro ani ti bichou Sidón yab antsana’ ne’ets ca c’athpich yajchiquiyat tam quim baju an q’uicha ca ts’ejca c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","U c’uajataque ma xo’ am bichou Sodoma max u t’ajamalac tihua’ i labith t’ajbilab ax u t’ajamal xohue’ ti Capernaum. Axi xo’ c’uajatchic ti Capernaum yab ne’ets ca otsits ti eb, tocat ne’ets ca jolohuat ti al an tamtsemla. ");
INSERT INTO husNT1971_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Nan tu uchalchic abal ja’its jaja’chic axi ne’ets ca c’athpich yajchiquiyat tam ca ts’ejca c’al a Dios, ani yab antsana’ ne’ets ca c’athpich yajchiquiyat axi ti biyal c’uajiy ti bichou Sodoma. ");
INSERT INTO husNT1971_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Taley ol a Jesús in ulu antse’: ―Nan tu puhuethanchal a bij Tata ti eb, cum it thabal c’al an eb ani c’al an tsabal. A tsinc’onchamal a tsalap an inicchic ax in tsalpayal tim ba’ abal pel i lej c’athpich tsalpath ani huit’om, ani a tejhua’methanchamal axi tsa’at in ichich ejtil i tsacam. ");
INSERT INTO husNT1971_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ojni’ Tata ti eb, antsana’ ta t’ajamal cum pel a culbetal. ");
INSERT INTO husNT1971_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Tam a Jesús in ucha’ axi taja’chic: U Tata ti eb tin tala’ jilchamalits tu c’ubac patal jahua’ hua’ats ti eb ani ti tsabal. Nana’its pel tin Tsacamil a Dios ani ni jita’ yab in ejtohual tiquin lej exla’ nana’ jant’ini’ u Tata ti eb expith tin lej exlalits. Ani ni jita’ yab in ejtohual quin lej exla’ u Tata ti eb jant’ini’ nana’ expith u lej exlalits. Expith jitats nan cu le’na’ cu tejhua’methanchi in ey u Tata ti eb, jats ne’ets ti lej exlom c’al jaja’. ");
INSERT INTO husNT1971_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Quit chich c’al nana’ patal tata’chic ax it tsequenequits tit t’ojnal ani tit quital, ani nan ne’ets tu coytha’chic. ");
INSERT INTO husNT1971_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Jant’ini’ tu tamcuth t’ojnal i hueyax huic’ath i yugo tin oc’, antsana’ ti quit tamcuth t’ojonchic c’al nana’. Tiquin exlanchi u ichich abal c’aya’ ani tsa’at, ani tam ne’ets ca co’oy i coytalab ta ichich junax c’al nana’. ");
INSERT INTO husNT1971_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","An yugo axi nan tu punubchalchic yab t’ojlab tiquin xe’tsinthanchi, ani an quitalab axi nan tu quitnanchal ic’ou tiquin xe’tsinthanchi. ");
INSERT INTO husNT1971_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Jun i sábado u xe’ets huahua’ tu exobalil junax c’al a Jesús al jun i t’ayablab lab em. Cum u lej c’a’ilits xe’ets i putsiyal in hualil an lab em ani i c’apchal in ichich. ");
INSERT INTO husNT1971_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Cum tsu’tab antsana’ i t’ajalchic, tam uchan a Jesús c’al an fariseochic: ―Ca tsu’u a exobalilchic in t’ajal tam sábado jahua’ in ulal an ts’ejcath cau binath c’al a Moisés yab quin t’aja’chic. ");
INSERT INTO husNT1971_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","A Jesús in toc’tsiychic: ―Auxe’ max yab a ajiyamal jant’o in t’aja’ a David junax c’al in junquilchic ti jayq’ui’ tam ti c’a’il jaja’chic. ");
INSERT INTO husNT1971_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Otsits jaja’ tin q’uima’ a Dios ani in c’apchi an t’ocat pan axi expith u jilchinal quin c’apu am pale’chic. ");
INSERT INTO husNT1971_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Auxe’ max yab a ajiyamal jahua’ in thucha’ a Moisés abal am pale’chic u t’ojnal tam sábado ti al an tiyopan, ani yab pel i hualabtalab. ");
INSERT INTO husNT1971_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Nan u t’ojlabil ani u cahuintal lej c’athpich exbath ani yab ejtil axi c’al am pale’chic. ");
INSERT INTO husNT1971_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Yab a ejtiyamal jahua’ in ulal an T’ocat Thuchlab antse’: Nana’ in Dios u le’ abal ca yajnanchi an inicchic, ani yab expith tiquin ts’acchiy c’al i tsemthach co’nel. Max tata’chic xo’ antsana’ a ejtiyamalac ani a t’ajamalac, yabac a jolbiyamalits u exobalilchic c’al am putslats. ");
INSERT INTO husNT1971_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Nana’its tin Juntal patal an inicchic ani u cua’al u eyaltal cu ulu jant’o ta ca eyentha an sábado. ");
INSERT INTO husNT1971_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Taley cale a Jesús taja’ ani otsits tin tiyopanil an Israelchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ani c’uajat taja’ jun i inic axi huayenec in c’ubac. Cum le’nab ca jolbiyat a Jesús max quin jeltha’ tam sábado, jaxtam u conoyab c’al talchic axi c’uajat ti al an tiyopan antse’: ―¿Ti jilal an ts’ejcath cau binath c’al a Moisés ca jeltha’ i ya’ul tam sábado? ");
INSERT INTO husNT1971_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","A Jesús in toc’tsiychic: ―Auxe’ max jita’ tata’chic ca ijcan a ovejajil al i mom tam sábado ani hualam yab ne’ets ca caltha’. ");
INSERT INTO husNT1971_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","In exbath jun i inic lej c’athpich yab ejtil in exbath jun i oveja. Jaxtam an ts’ejcath cau tu jilal qui tolmiy an inic tam sábado. ");
INSERT INTO husNT1971_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Tam a Jesús in ucha’ an inic axi huayenec in c’ubac: ―Xo’ ca lemc’a’ a c’ubac. In lemc’a’, cum jelthachits. Jilc’on tsablom in c’ubac lubach. ");
INSERT INTO husNT1971_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Tamna’ cale an fariseochic quin ts’ejca’ an cau jant’ini’ ti quin tsemtha’ a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Cum a Jesús in exla’ abal antsana’ le’nab ca t’ajchin, tam cale taja’ ani c’alets. Ani ts’at’enchab c’al yan i inicchic. Ani in jelthachiquiyal patal axi ya’ul. ");
INSERT INTO husNT1971_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","In lej uluth ucha’ an ts’at’elchic yab quin olnanchi in ey c’al jita’. ");
INSERT INTO husNT1971_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Antsana’ tu putnal jahua’ in ulumal in caulomejil a Dios Isaías ti biyal tin cuenta a Jesús antse’: ");
INSERT INTO husNT1971_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Nana’ in Dios ani axe’ pel u lej tacuth t’ojnalil. Jats u lej c’anithal ani c’al jaja’ in lej culbel. Ne’ets cu pitha’ an Espíritu Santo. Jaja’ ne’ets quin olchi am bichoulomchic abal nana’ tin Dios u ts’ejcal an inicchic c’al i lej bolithtalab. ");
INSERT INTO husNT1971_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Jaja’ yab ne’ets ti c’uiyax. Ne’ets ca cue’ xe’tsinq’ui ani yab ca thajat cahuin ti bel. ");
INSERT INTO husNT1971_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ne’ets quin tolmiy an inicchic axi yab in cua’al in tsap ejtil am pacáb axi hue’ pejcathits. Ne’ets quin c’aya’na’ an inicchic axi c’upupul in tsalap ejtil i tajablab axi hualim im binal tocat i pau’ c’upupul. Ne’ets quim baju an q’uij tam jaja’ quin talabetha’ patal jahua’ yab alhua’ ani jaja’ ca jilc’on ti lej pututh abatnom c’al patal. ");
INSERT INTO husNT1971_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Patal am bichoulomchic ne’ets quin aychi ca lablinchat c’al jaja’, in ulu a Isaias. ");
INSERT INTO husNT1971_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Taley chanchinal a Jesús jun i inic axi joc’tsi ani tsine ani jaye co’oyab c’al i at’ax teneclab. In jeltha’, ani taley tamna’ tsu’uxits ani ots’oxits. ");
INSERT INTO husNT1971_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ani patal an inicchic taja’ in jic’pal ani in uluchic tin cuenta a Jesús: ―Hualam axe’ xi inic ja’its an at xits’lab c’al a David axi bijithits ne’ets ca chich. ");
INSERT INTO husNT1971_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Cum an fariseochic in ats’a’ nixe’ xi cau, in uluchic: ―Axe’ xi inic in calthal i at’ax teneclab expith cum pithnenec i eyaltalab c’al an ts’ale at’ax teneclab a Beelzebú. ");
INSERT INTO husNT1971_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Cum a Jesús in exla’its jant’ini’ tu uxnal antsana’, in ucha’ an fariseochic: ―Max i bichou ca lehuáxin ani ca cuete’ pejéxin, ne’ets ca talabetha. Jaye max ca pejéxin i q’uimathchic ani ca buc’láxin, yab ne’ets ca lej ohuey. ");
INSERT INTO husNT1971_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ani max a Satanás quin tomolna’ ani quin caltha’ in at teneclab tin ichich an inic, yabats ne’ets ca ohuey in tsap ti abatnom tin ichich i inic. ");
INSERT INTO husNT1971_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","A ulumalitschic abal nan im pithnenec c’al a Beelzebú i eyaltalab tin calthom c’al i at’ax teneclab. ¿Max chubaxac jahua’ a ulumal, tam c’al jant’o tam eyaltalab tin calthal i at’ax teneclab a juntalchic? Jats tu tejhua’mel abal lejat q’uibts’oth a tsalapchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Cum u calthal i at’ax teneclab expith c’al in lej tsap an Espíritu Santo, jaxtam tejhua’ abal xo’ a Dios in t’ajalits ti Ts’ale ta tsu’ux hualchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Ni jita’ yab in ejtohual ca otsits tin q’uima’ i tsapic inic quin calthanchi jahua’ in cua’al, max yab oc’ox quin yac’ua’ ani quin huic’a’ an tsapic inic. Expith max huic’athits, tam ojni’ ne’ets ca ejtohuat ca calthanchat jahua’ in cua’al tin q’uima’. ");
INSERT INTO husNT1971_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Jitats yab junat in ichich c’al nan u ichich, pel i tomolnax c’al nana’. Jitats yab u ts’ot’c’óxlix c’al nana’ ani c’al an inicchic, pel i lehuáxlix. ");
INSERT INTO husNT1971_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Nan tu uchalchic abal a Dios in ejtohual quim paculanchi an inicchic patal jahuaquitsq’ui tam hualabtalab quin t’aja’ ani i quithab cau quin ulu. Expith yab ne’ets quim paculanchi jitats quin quithab cahuiliy an Espiritu Santo. ");
INSERT INTO husNT1971_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ne’ets bel ca ejtohuat ca paculanchat jitats tiquin quithab cahuiliy nana’ tin Juntal patal an inicchic. Jitats quin ulu abal in t’ojlabil an Espiritu Santo pel in t’ojlabil an teneclab, jats ojni’ ne’ets ca jilc’on jolbibith abal ets’ey c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Axi alhua’ an te’ im binal i alhua’ hualilab, ani axi yab alhua’ an te’ im binal i quithab hualilab. I exlal an te’ c’al in hualil. ");
INSERT INTO husNT1971_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Tata’chic ojni’ ejtil it tsan. Yab a ejtohualchic ca ulu i cau axi alhua’ cum quithab a ichich. Jant’inits a lej ichich, antsana’ ne’ets ca ulu ta hui’. ");
INSERT INTO husNT1971_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Axi alhua’ an inic in ulal jahua’ alhua’, cum alhua’ in ichich. Axi yab alhua’ an inic in ulal jahua’ yab alhua’, cum quithab in ichich. ");
INSERT INTO husNT1971_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Nan tu uchalchic abal tam quim baju an q’uicha tam ca ts’ejca an inicchic c’al a Dios, patal ne’ets quim bina’ i cuenta c’al a Dios patal jahuaquits tam jolat cau ax in ulumalits. ");
INSERT INTO husNT1971_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Tin ebal a cahuintal max yab alhua’ ne’ets quit jolbiyat c’al a Dios, ani tin ebal a cahuintal max alhua’ yab ne’ets quit jolbiyat c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Taley uchan a Jesús c’al talchic axi pel i exobchix c’al an ts’ejcath cau binath c’al a Moisés ani c’al an fariseochic antse’: ―Exobchix, i le’ max ca t’aja’ i labith t’ajbilab ti tsu’bixtalab c’al a ey. ");
INSERT INTO husNT1971_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","A Jesús in toc’tsiychic: ―An inicchic axi pojcax in ichich ani yab belom c’al nana’, jats ax in le’ abal nan cu t’ajaye i labith t’ajbilab, ani yab ne’ets cu t’aja’. Expith ca t’ila’chic jahua’ labith t’ajchinenec ti biyal in caulomejil a Dios Jonás. ");
INSERT INTO husNT1971_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jant’ini’ ti c’uajatac a Jonás ox a q’uicha ani ox i acal tin chucul am pulic to’ol, antsana’ nana’ tin Juntal patal an inicchic ne’ets quin c’uajiy jolith tsabal ox a q’uicha ani ox i acal. ");
INSERT INTO husNT1971_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Tam quim baju an q’uicha ca ts’ejca an inicchic c’al a Dios, tam ne’ets ca cubiy an Ninivejibchic axi ti biyal ti jolbix c’al tata’chic, cum jaja’chic jic’tsonenec c’al in hualab ani huenc’onenec c’al a Dios tam ti olnanchat in cahuintal a Dios c’al a Jonás. An cau jahua’ nan u olnal lej c’athpich exbath yab ejtil ax in olnamal a Jonás, ani tata’chic xo’ ma yab tim belchamal. ");
INSERT INTO husNT1971_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Aniye jaye an uxum ts’ale ax ti Sabá ne’ets ca cubiy ti jolbix c’al tata’chic al nixe’ xa q’uicha taye tal. Jaja’ ti biyal ou chich c’al a Salomón quin ats’anchi in tsalpath cahuintal, ani nana’ u cahuintal lej c’athpich exbath yab ejtil in cahuintal a Salomón. ");
INSERT INTO husNT1971_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Tam ca calejits an at’ax teneclab tin ichich an inic, xe’ets ti alilil ju’tam ta ca coyots al i joltam. Max yab quin ela’ ne’ets quin tsalpay jant’o quin t’aja’. ");
INSERT INTO husNT1971_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Ne’ets quin tsalpay ca huichiy junil tin ichich nixe’ xi inic jun ti calnequits. Tam huichits in tsu’chal in ichich an inic ejtil jun i ata axi lej alhua’ c’uet’ot’othits ani lej ts’ejcath alabel. ");
INSERT INTO husNT1971_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Tam ne’ets ca c’ale quin chi’tha’ buc in at at’ax teneclab axi lej c’athpich quithab. Tam axi huaxic ne’ets ca huichiy ca otsits tin ichich an inic ani ne’ets quin más c’athpich quithabmethanchi in ichich. Antsana’ tata’chic ne’ets quit t’ajchin ax it pojcax a ichich. ");
INSERT INTO husNT1971_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Exome ti cau a Jesús c’al axi muthatchic, tam ti ulits in mim ani jaye in ebchalchic a Jesús. Jilc’on elebchic ani in le’ ti cau c’al a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ani olchinal a Jesús abal le’nab ca tauna. Uchan: ―Te c’uajatchic eleb a mim ani a ebchal in le’ ti cau c’al tata’. ");
INSERT INTO husNT1971_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","A Jesús in toc’tsiychic: ―¿Jita’ ax a tsalpayal nana’ u ajiyal pel u mim ani pel u ebchal? ");
INSERT INTO husNT1971_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Tam a Jesús tu t’ipchi c’al in ch’uchub c’ubac huahua’ tu exobalil abal ja’its pel tu ebchalab c’al jaja’, ani jaye in ulu: ―Axe’chic axi te c’uajat c’al nana’ ja’its ax u ajiyal tu mim ani tu ebchalchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ani jitats quin t’ajchi in culbetal u Tata ti eb, ja’its axi pel u ebchal ani pel u uxum ebchal ani pel u mim. ");
INSERT INTO husNT1971_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Taley nixe’ xa q’uicha a Jesús cale al an ata, c’ale ti pulic lejem. Ani taja’ buxcan tin hualte’lil. ");
INSERT INTO husNT1971_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ani cum lej mulcunal yantalam i inic, otsits ani buxcan al i tan. Ani an mulcunel jilc’on ba’ an tsabal tin hualte’lil am pulic lejem. ");
INSERT INTO husNT1971_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Tam a Jesús in exobchalchic c’al yan i jalpith cau antse’: ―C’ale ti buc’ul jun i buc’ul iyalab lab em. ");
INSERT INTO husNT1971_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Xe’ets ti buc’ul ani ijcan talchic i iyalab ti al am bel. Chich taja’ an ts’itsinchic in c’apts’u an iyalab. ");
INSERT INTO husNT1971_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ani talchic i iyalab ijcan jaye jun ti hua’ats yan i t’ujub ani yab lej anmith. Taja’ thubat cale, cum huecats i anam. ");
INSERT INTO husNT1971_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Tam ti calejits a q’uicha lej tsapic an c’ac’al, tala’ huayts’on an acanchic cum yab luputh in ibil. ");
INSERT INTO husNT1971_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Talchic i iyalab ijcan jaye jun ti hua’ats yan i q’uith. Taja’ cale ani tala’ paxq’uiyatits, cum lej puhueyits an q’uithchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Talchic i iyalab ijcan jaye jun ti alhua’ an tsabal. Taja’ cale ani puhuey, ani im bina’ yan in hualil. Talchic i acan im bina’ in hualil ti bo’ inic, ani talchic ti ox inic, ani talchic ti ox i lajuj. ");
INSERT INTO husNT1971_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Jitats junat in ichich c’al nana’ u ichich, quin lej alhua’ bina’ in xutsun c’al axe’ xi cau. ");
INSERT INTO husNT1971_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Tam huahua’ tu exobalil a Jesús i más utenchi ani i conoy: ―¿Jale’ hualam a taunal an inicchic c’al i jalpith cau? ");
INSERT INTO husNT1971_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Toc’tsin a Jesús: ―A Dios ti tso’oblinchal tata’chic jant’ini’ tin t’ajal ti Ts’ale, ani axi q’ue’atchic teje’ ti al an mulcunel yab u tso’oblinchab. ");
INSERT INTO husNT1971_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Jitats in lej bats’umalits tin ichich in cahuintal a Dios, jats ne’ets ca pithane más ca t’uchinchat in ichich. Jitats tocat eblim im bats’umalits hue’ in cahuintal a Dios tin ichich, ne’ets ca tixc’anchat. ");
INSERT INTO husNT1971_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ne’ets tu olchichic jale’ u taunal an inicchic c’al i jalpith cau. In met’alchic jahua’ u t’ajal, ani ejtil max tam yab in lej tsu’tal. In ots’ohuiyalchic in cahuintal a Dios jahua’ u olchal, ani ejtil max tam yab in lej ats’al. ");
INSERT INTO husNT1971_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Antsana’its tu putnal jahua’ in ulumal in caulomejil a Dios Isaías antse’: Tata’chic ojni’ it ots’oxchic c’al an cau, tocat yab a ejtiyalchic. Ojni’ it tsu’ux, tocat, yab a t’ajalchic ti cuenta. ");
INSERT INTO husNT1971_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Expith a t’ujbathmethamalits a ichich. Yab a ejtohual ca pena’ ta ichich jahua’ a ats’alchic. Yab a lej tsu’tal jahua’ in t’ajal a Dios. Yab chubax a ats’anchal in cahuintal a Dios ani yab chubax a ejtiyal c’al a ichich. Yab a le’ quit huichiychic c’al a Dios abal quit jec’onthachic. ");
INSERT INTO husNT1971_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ani tata’chic tu exobalil yab antsana’, cum it lej lablinchithits c’al a Dios it alhua’ tsu’ux ani it alhua’ ots’ox c’al nana’. ");
INSERT INTO husNT1971_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Lej chubax nan tu uchalchic abal yan axi pel in caulomejilchic a Dios ani yan axi alhua’ inicchic in le’namal max quin tsu’u jahua’ tata’chic xo’ a tsu’tal u t’ajal, ani yab in tsu’uchic. In le’namalchic max quin ats’a’ jahua’ tata’chic xo’ a ats’al u ulal, ani yab in ats’a’chic. ");
INSERT INTO husNT1971_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Tiquin alhua’ ats’anchi cum ne’ets tu lejquinchichic an jalpith cau tin cuenta am buc’ul iyalab lab em. ");
INSERT INTO husNT1971_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","An iyalab axi ijcanenec ti al am bel jats ejtil max i inic quin ats’a’ jant’ini’ ca otsits jun tin t’ajal a Dios ti Ts’ale ani yab quin ejtiy. U che’el an teneclab ani in tixc’anchal in cahuintal a Dios axi t’aychame tin ichich nixe’ xi inic. ");
INSERT INTO husNT1971_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","An iyalab axi ijcanenec ti al an tsabal jun ti hua’ats yan i t’ujub jats ejtil max i inic quin ats’anchi in cahuintal a Dios ani quim bats’u c’al i culbeltalab. ");
INSERT INTO husNT1971_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Tocat cum yab lej luputh ibibin tin ichich, jaxtam yab in ohuat belal. U t’apchinal im belomtal tam ca yajchiquiyat ani tam ca othna tin ebal abal im belamal in cahuintal a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","An iyalab axi ijcanenec jun ti hua’ats yan i q’uith jaye ejtil max i inic quin ats’anchi in cahuintal a Dios, ani bel in xijc’ath tsalapnal jahua’ hua’ats teje’ tsabal ani u lej c’ambiyab c’al an ricotalab. Antsana’ u t’u’thithinchab in ichich c’al jahua’ hua’ats teje’ tsabal, ma yabats u lejel ca t’ayat c’uajiy in cahuintal a Dios tin ichich. Jaxtam yab in t’ajal jahua’ alhua’ c’al a Dios, ani pel ejtil i acan lab em axi yab im binal in hualil. ");
INSERT INTO husNT1971_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","An iyalab axi ijcanenec jun ti alhua’ an tsabal jats ejtil max i inic quin lej alhua’ ats’anchi in cahuintal a Dios tin ichich ani ca lej alhua’ t’aychin taja’. In alhua’ ejtiyal ani in lej t’ajal jahua’ alhua’ c’al a Dios. Pelchic ja ejtil i acan lab em ax im binal in hualil ti bo’ inic, ani talchic ti ox inic, ani talchic ti ox i lajuj. ");
INSERT INTO husNT1971_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Tam a Jesús in olna’ q’ue’at i jalpith cau, in ulu: ―Ne’ets tu olchiyechic jant’ini’ tin t’ajal a Dios ti Ts’ale. Am buc’ul iyalab im buc’uhuamalits an alhua’ iyalab lab em tin tsabalil. ");
INSERT INTO husNT1971_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Tam ti aclejits ani huaytsits, tam ti chich an tomolnax ani im buc’chi i iyalab alq’uith ts’ojol tin t’ayablabil lab em. Tam c’alets an tomolnax. ");
INSERT INTO husNT1971_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Calejits an iyalab lab em ani puhueyits, aniye jaye an alq’uith ts’ojol. ");
INSERT INTO husNT1971_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Tam chich an t’ojnalchic quin olchi in amu, in ucha’chic: Amu, a buc’umal expith i alhua’ iyalab lab em ani xo’ hua’ats i alq’uith ts’ojol jaye ta t’ayablabil. ");
INSERT INTO husNT1971_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Toc’tsin an amu: Pel u tomolnaxil ax tim buc’chamal xe’. Tam conoyat an amu c’al an t’ojnalchic: ¿A le’ cu c’ale qui la’u an alq’uith ts’ojol? ");
INSERT INTO husNT1971_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Toc’tsin an amu: Ibats ca la’u, i canats ca la’u jaye an lab em. ");
INSERT INTO husNT1971_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ca jila’ ca junax puhuey ma tam quim baju an cotlats, ani tam ne’ets cu aba’ an cotolchic abal quin oc’ox cotoy an alq’uith ts’ojol ani quin huic’a’ ti huiq’ue’ abal ca chican. Talbel quin cotoy an lab em ani tiquin thaychi ci al u huilte’lil. ");
INSERT INTO husNT1971_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Tam a Jesús in olna’ q’ue’at i jalpith cau, in ulu: ―Ne’ets tu olchiyechic jant’ini’ tin t’ajal a Dios ti Ts’ale. Jun i inic in t’aya’ i iyalab mostaza tin tsabalil. ");
INSERT INTO husNT1971_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ja’its an iyalab axi más tsipichic c’al patal an iyalab. Tocat ca cale ani ca puhueyits, in atal im puhuel axi patal an ts’ojol t’ayablab. U pactha’bel in c’ue’elchic, ma taja’ u che’el an ts’itsinchic quin ts’ejca’ in c’util ejtil max pel i te’. ");
INSERT INTO husNT1971_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","A Jesús in olna’ q’ue’at i jalpith cau, in ulu: ―Hua’atse i cau jant’ini’ tin t’ajal a Dios ti Ts’ale. Max i uxum quin xaluhuits an c’ac’chixtalab al i c’oye, c’al ne’ets ca tala’ puhuethajits tim puhuel an c’oye. ");
INSERT INTO husNT1971_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Antsana’ a Jesús in olnanchal an inicchic an chubaxtalab expith c’al i jalpith cau. ");
INSERT INTO husNT1971_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Antsana’ tu putnal jahua’ in ulumalits ani jahua’ in thuchamalits in caulomejil a Dios tin cuenta in olnanchixtal a Jesús antse’: Ne’ets cu tauna’ an inicchic c’al i jalpith cau. An cau axi tsinc’onchame an inicchic ma tam ti ts’ejca an eb ani an tsabal ani ma xo’, jats axi ne’ets cu olnanchi an inicchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Tam a Jesús in aba’ ca c’ale an mulcunel ani otsits al i ata. Ani huahua’ tu exobalil a Jesús u utey qui ucha’: ―Tucu lejquinchi an jalpith cau tin cuenta an alq’uith ts’ojol ti al an t’ayablab lab em. ");
INSERT INTO husNT1971_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Toc’tsin a Jesús: ―Nana’ tin Juntal patal an inicchic in ejtil nixe’ xi buc’ul iyalab lab em. ");
INSERT INTO husNT1971_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Tim puhuel an tsabal pel ejtil u t’ayablabil. An alhua’ lab em jats ejtil an inicchic ax in jilchal a Dios quin t’aja’ ti Ts’ale tin ichich. An alq’uith ts’ojol jats ejtil an inicchic axi pel in c’al an teneclab. ");
INSERT INTO husNT1971_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","An inic ax im buc’u an iyalab alq’uith ts’ojol ejtil an oc’ox teneclab axi lej tomolnax c’al nana’. An cotlats jats an taltalab q’uij q’uicha, ani an cotolchic jats an ángelchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Jant’ini’ an alq’uith ts’ojol u cotoyab ani u jolohuab ti c’amal, antsana’ an inicchic axi ejtil an alq’uith ts’ojol ne’ets ca t’ajchin ti al an taltalab q’uij q’uicha. ");
INSERT INTO husNT1971_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Nana’ tin Juntal patal an inicchic ne’ets cu aba’ an ángelchic ca chich teje’ tsabal quin tamcuy ani quim pilmetha’ patal an hualbith inicchic ani am pojcaxchic, cum yab ne’ets quin ejtou ca c’uajiy jun ti nan u t’ajal tin Ts’ale. ");
INSERT INTO husNT1971_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ani ne’ets quin jolouchic ti c’amal. Taja’ ne’ets ca lej uq’uinchic ani ne’ets ca huech’ech’lats in camab c’al an yajchictalab lej yajchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ani patal jitats bolith in ichich ne’ets ca c’uajiy ti eb jun tin t’ajal a Dios ti lej Ts’ale, ani tihua’ ne’ets ca tsu’tatchic ts’umimil ejtil in ts’umimiltal a q’uicha. Max junatchic a ichich c’al nana’ u ichich, ca lej alhua’ bina’ a xutsun c’al axe’ xi cau. ");
INSERT INTO husNT1971_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Ne’ets tu olchiyechic jant’ini’ tin t’ajal a Dios ti Ts’ale. In t’ajal ejtil i inic axi quin ela’ i jolith tumin tsinc’oth tsabal ani quin thubat tsincachiquiy tsabal junil, ani c’al in ichich lej culbel ne’ets quin tala’ nuju jahua’ in cua’al abal quin ejtou quin ts’a’iy nixe’ xi tsabal. ");
INSERT INTO husNT1971_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Ne’ets tu olchiyechic jant’ini’ tin t’ajal a Dios ti Ts’ale. In t’ajal ejtil max pel i ts’a’um quin lej alimichiquiy abal quin ts’a’iy i perla lej jalbith. ");
INSERT INTO husNT1971_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Tam quin ela’its, tam ne’ets quin tala’ nuju jahua’ in cua’al abal quin ejtou quin ts’a’iy nix am perla. ");
INSERT INTO husNT1971_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Ne’ets tu olchiyechic jant’ini’ tin t’ajal a Dios ti Ts’ale. In t’ajal ejtil i alim to’ol ax im pet’nal ti al am pulic lejem an thachumtalab c’al an to’ol, ani tats tu otsel patal jant’oquitsq’ui tam to’ol. ");
INSERT INTO husNT1971_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Tam ca t’uchichits an thachumtalab, tam in quinal tin hualte’lil am pulic lejem. Taja’ u buxcanal quin tacuy jahua’ alhua’ an to’olchic ani im baliyal al i t’ocnal. Axi yab alhua’ im pet’nalq’ui. ");
INSERT INTO husNT1971_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Antsana’ tam ca taley an q’uij q’uicha ne’ets ca chich an ángelchic quim pilmetha’ an inicchic axi alhua’ ani axi yab alhua’. ");
INSERT INTO husNT1971_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ani ne’ets quin jolouchic axi yab alhua’ ti al an c’amal. Taja’ ne’ets ca lej uq’uinchic ani ne’ets ca huech’ech’lats in camab c’al an yajchictalab lej yajchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Tam a Jesús in conoy in exobalilchic: ―¿A tala’ ejtiyal jahua’ nan tu ucha’its? Toc’tsin jaja’chic: ―Ojni’, Ajatic. ");
INSERT INTO husNT1971_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Tam a Jesús in ucha’chic: ―Xo’ a ejtohualchic tit exobchix, cum c’al u cahuintal ani jaye c’al im biyal cahuintal a Dios it exobchinenequits jant’ini’ tin t’ajal a Dios ti Ts’ale. It ejtil it thabal c’al jahua’ huinat alhua’, ani ne’ets ca ejtoyechic ca caltha’ yan i ts’alat lablinchixtalab c’al u cahuintal ani c’al im biyal cahuintal a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Tam ti talits a Jesús quin olna’ antsana’ nixe’ xi jalpith cauchic, ta c’ale. ");
INSERT INTO husNT1971_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ulits tim bichohuil, ani taja’ in exobchal jaye in cahuintal a Dios ti al in tiyopanil an Israelchic. Ax in ats’alchic in lej jic’pal, ani in uluchic: ―¿Ju’ta tin ela’ in lej tsalpathtal axe’ xi inic? ¿Jant’ini’ tin lej ejtohual quin t’aja’ i labith t’ajbilab? ");
INSERT INTO husNT1971_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Expith pelq’ui in tsacamil an thacum te’ ani in mim pel a María. A Jacobo, ani a José, ani a Simón, ani a Judas pel in ebchalchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ani in uxum ebchalchic u c’uajil teje’ c’al huahua’. ¿Tam ju’ta tim patal exlamal an cau? ");
INSERT INTO husNT1971_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Cum antsana’ u t’apchinal in tsalap nixe’ xi inicchic yab in exlanchi in lej ey a Jesús, tam a Jesús in ucha’chic: ―Axi caulome c’al a Dios u c’ac’nab abal ju’tamq’ui c’al patal an inicchic, expith yab u c’ac’nab c’al in at bichou ani c’al axi tin cuete’ q’uima’. ");
INSERT INTO husNT1971_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Cum yab u belnal a Jesús tihua’ tim bichou, jaxtam yabats in t’ajal yan i labith t’ajbilab taja’. ");
INSERT INTO husNT1971_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","A Herodes axi pel an gobernador ti Galilea olchinenequits jant’o xe’ets in t’ajal a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Tam in ucha’ axi c’uajatchic c’al jaja’: ―Axe’ xi inic jats a Juan pujax axi tsemenecac ani xo’ ejthachits, ani jaxtam in cua’al in lej tsap quin t’aja’ i labith t’ajbilab. ");
INSERT INTO husNT1971_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Ja’its nixe’ a Herodes axi ti jayq’ui’ in aba’ an cau ca yac’uan a Juan ani ca baliyat ti al an huic’axte’ ani taja’ ca huic’an c’al i calaniyo pat’al. Jats ti t’ajchinenec a Juan cum antsana’ ti le’na c’al a Herodías in tomquil a Felipe axi pel in ebchal a Herodes. ");
INSERT INTO husNT1971_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Uchanits ti jayq’ui’ a Herodes c’al a Juan antse’: ―Yab alhua’ ax a t’ajal a co’onchal in tomquil a ebchal. ");
INSERT INTO husNT1971_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Cum antsana’ ti uchan a Herodes c’al a Juan, jaxtam in lej le’ max quin t’ajat tsemtha’. Expith in ts’ejnal max ca t’ajchin jant’o c’al am bichou, cum in tsalpayalchic abal a Juan pel i lej caulome abath c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Im bajuhuits an q’uicha tam tin t’ajalchic an ajib tin tamub a Herodes. Otsits in ts’ic’achil a Herodías ti bixom tin tamet an ajibalchic, ani a Herodes in tsu’u lej q’uijith ti bixom an ts’ic’ach. ");
INSERT INTO husNT1971_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Tam in lej cuba’ tim ba’ abal lej chubax ne’ets quim pitha’ an ts’ic’ach jahuaquitsq’ui ta ca conchin. ");
INSERT INTO husNT1971_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Tam in mim an ts’ic’ach in lej ucha’ abal quin conchinchi in oc’ a Juan pujax. Ca chanchin al i talabcua’. ");
INSERT INTO husNT1971_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Tam lej t’e’pin an ts’ale Herodes c’al nixe’ xi cau. Bel cum in cubamalits tim ba’ ti chubax ani jaye ats’anchame jahua’ in ulu c’al an ajibalchic, jaxtam ne’ets quim putu c’al jahua’ in ulumalits. ");
INSERT INTO husNT1971_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Tam in aba’ an cau ca muts’inchat in oc’ a Juan tihua’ ti al an huic’axte’. ");
INSERT INTO husNT1971_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Taley chanchin an ts’ic’ach in oc’ a Juan al i talab, ani jaja’ in huat’banchi c’al in mim. ");
INSERT INTO husNT1971_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Taley ulits in exobalilchic a Juan, ani in ne’tha’ in inictal quin joliy. Ani talbel c’ale jaja’chic quin olchi a Jesús jahua’ t’ajchinenec a Juan. ");
INSERT INTO husNT1971_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Tam ti a Jesús antsana’ olchinenequits jant’o t’ajchinenec a Juan, tam otsits al i tan ca c’ale. Ne’ets tihua’ pil al i joltam. Tam ti an inicchic in tso’obits abal tihua’ ne’etsits a Jesús, c’alechic jaye tihua’ ti nixe’ xi joltam acan belal. ");
INSERT INTO husNT1971_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ulits ani calejits a Jesús al an tan, in tsu’u mulcunenec yantalam i inic. In yajnanchal an mulcunel ani in jelthal an ya’ulchic ax u chanchinal. ");
INSERT INTO husNT1971_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Lej huaclejits, ani chich huahua’ tu exobalil a Jesús i ucha’: ―Lej huaclejits ani ni jita’ yab u c’uajil teje’. Ca ucha’ an mulcunel ca c’ale ti al i bichouchic quin ts’a’iy jant’o quin c’apu. ");
INSERT INTO husNT1971_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Tam a Jesús tu ucha’chic: ―Yab in yejenchal ca c’alechic ju’ta. Tata’chic ca pijchi an mulcunel. ");
INSERT INTO husNT1971_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","I toc’tsiy: ―I cua’al expith bo’ i pan ani tsab i to’ol. ");
INSERT INTO husNT1971_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Tam tu ucha’chic a Jesús: ―Tiquim pitha’ jahua’ a cua’al. ");
INSERT INTO husNT1971_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Tam a Jesús in ucha’ an mulcunel ca buxcanchic tsabal. Ani tam tim bats’uhuits nixe’ xi bo’ i pan ani nixe’ xi tsab i to’ol, in met’al ti eb ani im pitha’ i c’ac’namal yan c’al a Dios. Taley in mu’u am pan ani tu pitha’ huahua’ tu exobalil qui huat’banchi an mulcunel. ");
INSERT INTO husNT1971_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ma patal an mulcunel c’aputs ani ajhuejits. Taley i thaya’ an jilc’omach, ma lajuj tsab i t’ocnal t’uchichithits. ");
INSERT INTO husNT1971_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ajith expith an inic pel i bo mil axi c’aputschic, ani yab ajith an uxum ani an tsacam axi c’aputs jaye. ");
INSERT INTO husNT1971_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Taley a Jesús tu ucha’ huahua’ tu exobalil cu otsits al an tan ani cu oc’chith c’ale jum poq’ue’ am pulic lejem, ani jaja’ ne’ets ca jilc’on ne’ets quin aba’ ca c’alets an mulcunel. ");
INSERT INTO husNT1971_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Tam tin aba’its ca c’ale, tam jaja’ c’athiy al jun i bolchal abal ca cuetem olon. Aclejits ani c’uajat a Jesús taja’ cuetem. ");
INSERT INTO husNT1971_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","An tan xan tu ne’ets huahua’ ne’ets ts’ejel ti al am pulic lejem. Cum lej juchnal an tsapic ic’, lej lanq’uil an ja’, ani lej tanc’uiyab an tan. ");
INSERT INTO husNT1971_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Tal chuthelits ani chich a Jesús c’al huahua’, ne’ets belbel eblim an ja’. ");
INSERT INTO husNT1971_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Tam i tsu’u antsana’ ne’ets belbel, tam u lej jiq’uel ani c’al i jiq’ueltalab i thajat uluchic: ―Pel i labax. ");
INSERT INTO husNT1971_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Tam a Jesús tu ucha’chic: ―Tiquin lej tsapnanaychic ta ichich. Yab quit jiq’uey, cum nana’its jats ax in tal c’al tata’chic. ");
INSERT INTO husNT1971_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Tam uchan a Jesús c’al a Pedro: ―Ajatic, max tata’its axi it tal, tiquin ucha’ne quim belats eblim an ja’ jun tit tal tata’. ");
INSERT INTO husNT1971_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Tam a Jesús in ucha’: ―Quit chich c’al nana’. Ani a Pedro pa’iy al an tan ani in ts’i’quiy ca belats eblim an ja’ quim baju a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Tam tin tsu’u abal lej tsapic an ic’, tam ti jiq’uel. Cum in ts’i’quiy ti lupts’inalits al an ja’, in thajat ulu: ―Tiquin jec’ontha’, Ajatic. ");
INSERT INTO husNT1971_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Tameq’ui a Jesús in yac’uchi in c’ubac ani in ucha’: ―Tata’ ojni’ yabaye tin alhua’ belamal, ani jats ta cua’al i hualamtalab ta ichich. ");
INSERT INTO husNT1971_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Tam ti otsitsitschic a Jesús ani a Pedro al an tan, tam ti coyots an ic’. ");
INSERT INTO husNT1971_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Tam i tuthuhual i c’ualal tin tamet a Jesús ani i ucha’: ―Lej chubax tata’its pel ti Tsacamil a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Taley talbel u ulits huahua’ jum poq’ue’ am pulic lejem ti tsabal Genesaret. ");
INSERT INTO husNT1971_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Tam ti an inicchic axi taja’ in exla’its abal ja’its a Jesús axi ulnequits, tam jaja’chic in aba’ an cau tim puhuel am bichou abal ca olchat abal ja’its a Jesús axi taja’ c’uajat. Ani chanchinal a Jesús patal an ya’ulchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Lej canat taunab max ca ejtohuat ca tacchin hue’ in acan in nacat coton. Ani patal ax in tacchal tala’ jeley. ");
INSERT INTO husNT1971_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Taley chich c’al a Jesús talchic i fariseochic ani talchic axi pel i exobchix c’al an ts’ejcath cau binath c’al a Moisés, tal ma ti Jerusalén. Ani conoyab c’al jaja’chic: ");
INSERT INTO husNT1971_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―¿Jale’ a exobalilchic in jec’onchal am biyal ujnamtalab axi jilchinenec c’al im biyal juntalchic? Yab in t’acacayal in c’ubac tam ne’ets ti c’apul abal ca tsu’tat ti t’ocat c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","A Jesús in toc’tsiychic: ―¿Ani tata’chic jale’ a jec’onchal in abatnaxtal a Dios abal ca t’aja’q’ui jahua’ in t’ajamal am biyalabchic? ");
INSERT INTO husNT1971_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","In abatnaxtal a Dios ti uchal abal ca c’ac’na’ a tata ani a mim. Ca tsemtha jitats quithab cahuilix c’al in tata ani c’al in mimcua’. ");
INSERT INTO husNT1971_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ani tata’chic a jilal an inic quin hualba’ in tata ani in mim tam in yejenchal jant’o. Yab quin tolmiychic max quin ulu in tala’ pitha’its a Dios jahua’ in co’oyamalchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Tam jaja’ quin ulu antsana’, tam a ulalchic abal yabats in cua’al in uchbil quin tolmiy in tata ani in mim. Antsana’ ta hualbanchal in abatnaxtal a Dios abal ca t’aja’q’ui in ujnamtal am biyalabchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Tata’ ojni’chic it eb t’ocatq’ui expith jant’ini’ tit thuchathits c’al in caulomejil a Dios Isaías antse’: ");
INSERT INTO husNT1971_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Axe’ xi inicchic tin c’ac’nalq’ui nana’ c’al in hui’, ani tin lej ichich tin ou tsu’tal. ");
INSERT INTO husNT1971_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Jolat in c’ac’naxtal, cum jats axi exobchithq’ui c’al in at inic ani yab c’al a Dios, in ulu a Isaías. ");
INSERT INTO husNT1971_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Tam a Jesús in ucha’ ca más utey an mulcunel, ani in ucha’chic: ―Tiquin alhua’ ats’anchi ani ca ejtiy jahua’ ne’ets tu ucha’chic. ");
INSERT INTO husNT1971_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Jahua’ in c’apal an inic yab ja c’al tu jolbiyab c’al a Dios. Jahua’ quin ulu yab alhua’ jats ojni’ c’al tu jolbiyab. ");
INSERT INTO husNT1971_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Tam u utey huahua’ tu exobalil a Jesús ani i conoyal: ―¿A tso’obits abal an fariseochic lej yajchic an cau in ats’a’ jahua’ a ulu? ");
INSERT INTO husNT1971_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","A Jesús in toc’tsiychic: ―Jant’ini’ an alq’uith ts’ojol u la’uhuab c’al an inic, antsana’ ne’ets ca t’ajan jitats yab pel in t’ayab u Tata ti eb. ");
INSERT INTO husNT1971_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Yab quit ts’at’eychic c’al an fariseochic, cum jaja’ pel ejtil i joc’tsi axi lotocnax c’al in at joc’tsi. Max ca ijcan an joc’tsi lotocnax al i jol, ne’ets ca ijcan jaye ax u lotocnab an joc’tsi. ");
INSERT INTO husNT1971_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Tam uchan a Jesús c’al a Pedro: ―Tucu lejquinchi nixe’ xi jalpith cau tin cuenta c’al jant’o tu jolbiyab an inic c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","A Jesús in toc’tsiy: ―¿Jayetseq’ui tata’chic yab a ejtiyal? ");
INSERT INTO husNT1971_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Jahua’ in c’apal an inic expith u ulel tin chucul, ani talbel u calel tin inictal jahua’ yab alhua’. Yab u ulel tin lej ichich. ");
INSERT INTO husNT1971_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Jahua’ quin ulu yab alhua’ u tal tin lej ichich, ani jats c’al tu jolbiyab c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Tin ichich an inic u tujel i quithab tsalap. Jaxtam hua’ats jita’ tsemthom c’al in at inic. Jaxtam hua’ats jita’ uxumbe ani jita’ inicbe. Jaxtam hua’ats jita’ c’ambibil c’al an uxum. Jaxtam hua’ats jita’ cue’, jita’ janamcau, jita’ quithab cahuilix c’al in at inic. ");
INSERT INTO husNT1971_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","C’al patal axe’ jahua’ yab alhua’, jats c’al tu jolbiyab an inic c’al a Dios. Yab ja tu jolbiyab abal yab in t’acacayal in c’ubac tam ne’ets ti c’apul abal max ca tsu’tat ti t’ocat c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Taley tixc’an a Jesús taja’, c’ale tihua’ al i cuenchalabchic axi cuentalith ti bichou Tiro ani ti bichou Sidón. ");
INSERT INTO husNT1971_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ani chich jun i uxum canaánib in thajat uchal a Jesús: ―Ajatic, tata’its pel it at xits’lab c’al a David. Tiquin yajnanchi cum c’uajchith u ts’ic’achil c’al i at’ax teneclab ani u lej yajchiquiyab. ");
INSERT INTO husNT1971_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","A Jesús ni jun i cau yab in toc’tsiyal. Tam huahua’ tu exobalil a Jesús i lej ucha’ a Jesús: ―Ca ucha’ ca c’ale an uxum, cum lej it’ix ti thajajal ts’at’at c’al huahua’. ");
INSERT INTO husNT1971_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Tam a Jesús in ucha’ an uxum: ―A Dios tin aba’ quin chich teje’ cu tolmiy am bichou Israel expith, cum jaja’chic pel ejtil i q’uibelom oveja. ");
INSERT INTO husNT1971_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Aba ani’ antsana’ uchan an uxum, bel utey ani in tuthu in c’ualal tin tamet a Jesús. In ucha: ―Bel tiquin tolmiy, Ajatic. ");
INSERT INTO husNT1971_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Toc’tsin a Jesús: ―Yab in tomnal i inic quin tixc’anchi am pan in tsacamilchic ani quim pet’nanchi am pic’o’ quin c’apchi. ");
INSERT INTO husNT1971_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Tam toc’tsin an uxum: ―Ojni’ lej chubax jahua’ a ulal, Ajatic. Aba ani’, bel am pic’o’ in c’apchal am pejlam pan ax u ijcanalq’ui tin mexajil in amu. ");
INSERT INTO husNT1971_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Tam uchan an uxum c’al a Jesús: ―Tata’ ojni’ mimlab, a lej belal. Jaxtam ne’ets tu t’ajchi jant’ini’ tin conchamal. Ma tameq’ui ti canchinits an at’ax teneclab in ts’ic’achil nixe’ xi uxum, ani t’ajat jilc’on jelthachits. ");
INSERT INTO husNT1971_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Cale a Jesús taja’ ani ta ne’ets ti hualchicte’ am pulic lejem Galilea. Taley c’athiy al jun i bolchal ani buxcan taja’. ");
INSERT INTO husNT1971_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ani ulelel yantalam i inicchic c’al jaja’. In chi’thal i c’uets’e’, i joc’tsi, i mo’, i tsambe c’al in c’ubac, ani más yantalam i ya’ulchic. In mo’calchic tin tamet a Jesús ani jaja’ in tala’ jelthal. ");
INSERT INTO husNT1971_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ani in lej jic’pal axi muthatchic taja’ tam tin tsu’u abal u cahuits axi mo’ac. In tsu’u jelthachic axi tsambejac c’al in c’ubac ani alhua’ belalits axi c’uets’e’ac. Ani jats ti lej puhuethanchixchic c’al im bij in Diosil am bichou Israel. ");
INSERT INTO husNT1971_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Taley a Jesús tu caniy cu utey huahua’ tu exobalilchic ani tu ucha: ―U lej yajnanchal an mulcunel, cum oxits a q’uicha ti c’uajat c’al nana’ ani yab in cua’al jant’o quin c’apu. Yab u le’ cu aba’chic tin q’uima’ ca c’ale el ichich, i ca luxan ti bel c’al i jayil. ");
INSERT INTO husNT1971_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Tam i conoy a Jesús: ―¿Jant’o ti qui pijchi am pulic mulcunel ani teje’ yab hua’ats ma ni jun i q’uimath jun ti qui elchi i c’apnel? ");
INSERT INTO husNT1971_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Tam a Jesús tu conoychic: ―¿Jay i pan a cua’alchic? I toc’tsiy: ―I cua’al buc i pan ani tsab ox i tsacam to’ol. ");
INSERT INTO husNT1971_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Tam a Jesús in ucha’ an mulcunel ca buxcan tsabal. ");
INSERT INTO husNT1971_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Taley im bats’u axi buc i pan ani an tsacam to’olchic. Tam tim bina’its i c’ac’namal yan c’al a Dios, in mu’u am pan ani tu pitha’ huahua’ tu exobalilchic qui huat’banchi an mulcunel. ");
INSERT INTO husNT1971_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ma tim patal an mulcunel c’aputsitschic ani ajhuejits. Taley i thaya’ an jilc’omach, ma buc i t’ocnal t’uchichithits. ");
INSERT INTO husNT1971_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ajith expith an inic pel i tse’ mil axi c’aputschic, ani yab ajith an tsacamchic ani an uxum axi c’aputs jaye. ");
INSERT INTO husNT1971_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Taley a Jesús in aba’its ca c’ale an mulcunel, ani jaja’ ta otsits al i tan ca c’ale tihua’ ti tsabal Magdala. ");
INSERT INTO husNT1971_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Talchic i fariseo ani i saduceochic chich abal quin tsu’u a Jesús. Cum tocat in le’ quin tacchiquiy a Jesús, in ucha’ quin t’aja’ i labith t’ajbilab ti tsu’bixtalab abal quin tejhua’metha’ max chubax in cua’al in tsap c’al a Dios ti eb. ");
INSERT INTO husNT1971_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","A Jesús in ucha’chic: ―Tata’chic tam ca tsu’u u otscanalits a q’uicha tsacninil an c’ay’lal, tam a ulal abal ne’ets ca chuthey alabel an q’uicha. ");
INSERT INTO husNT1971_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Jaye tam ca chutheyits tsacninile bel an c’ay’lal ani max mapulits, tam a ulalchic abal ne’ets ca c’uajiy an q’uicha yab alabel. Tata’ ojni’chic it lej eb tsalpathq’ui ani yab it lejat tsalpath ta ejattal. A tso’obchic an tsu’bixtalab al an c’ay’lal, ani ma ni hue’ yab a tso’ob an tsu’bixtalab axi nan u t’ajal c’al in lej tsap a Dios ti eb. ");
INSERT INTO husNT1971_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","An inicchic axi pojcax in ichich ani yab belom c’al nana’, jats ax in le’ abal nan cu t’ajaye i labith t’ajbilab, ani yab ne’ets cu t’aja’. Expith ca t’ila’chic jahua’ labith t’ajchinenec ti biyal in caulomejil a Dios Jonás. Tam tixc’an a Jesús c’al jaja’chic, ta c’ale. ");
INSERT INTO husNT1971_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","U ultsits huahua’ tu exobalil a Jesús jum poq’ue’ am pulic lejem ani yab jant’o i cua’alchic qui c’apu, cum i uc’chiychic qui ne’tha’ am pan. ");
INSERT INTO husNT1971_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Tam a Jesús tu ucha’chic: ―Ca lej t’aja’chic ti cuenta yab ca bats’u an c’ac’chixtalab c’oye ax in cua’al an fariseo ani an saduceochic. ");
INSERT INTO husNT1971_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Tam i uluchic: ―Antsana’ hualam in ulu cum yab i cua’al i pan. ");
INSERT INTO husNT1971_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Cum a Jesús in tso’ob abal antsana’ i uluchic, jaxtam tu ucha’chic: ―¿Jale’ a ulalchic abal yab a cua’al i pan? Tata’chic ojni’ yabaye tin alhua’ belamal. ");
INSERT INTO husNT1971_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Jale’ ma lejat yabaye tin exlanchal u lej ey? Hualam a uc’chiyamalits nixe’ xi bo’ i pan c’al tu pijchiyamal bo’ mil i inicchic ani an t’ocnalchic t’uchichith c’al i jilc’omach ax a thaya’ jaye. ");
INSERT INTO husNT1971_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Jaye a uc’chiyamalchic nixe’ xi buc i pan c’al tu pijchiyamal tse’ mil i inicchic ani an t’uchichith t’ocnalchic c’al an jilc’omach ax a thaya’. ");
INSERT INTO husNT1971_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Yabaye a ejtiyamalchic abal nan yabq’ui tu uchamal i cau tin cuenta i pan tam tu ucha’chic ca t’aja’ ti cuenta yab ca bats’uchic an c’ac’chixtalab c’oye ax in cua’al an fariseo ani an saduceochic. ");
INSERT INTO husNT1971_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ma tamits i ejtiyits abal a Jesús in t’ipchixnanchal in exobchixtal an fariseochic ani an saduceochic c’al nixe’ xi c’ac’chixtalab c’al an c’oye. ");
INSERT INTO husNT1971_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Tam tu ultsits huahua’ junax c’al a Jesús ti tsabal Cesarea Filipo, jaja’ tu conoychic: ―¿Jant’ini’ hualam tin olnal an inicchic c’al u ey nana’ tin Juntal patal an inicchic? ");
INSERT INTO husNT1971_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","I toc’tsiy: ―Talchic in ulal abal tata’ pel it Juan pujax ani talchic in ulal abal pel it Elías. Jaye hua’ats jita’chic in ulal abal pel it Jeremías, ani max i pel it caulome c’al a Dios axi junaquecua’. ");
INSERT INTO husNT1971_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Tam a Jesús tu conoyale: ―¿Ani tata’chic jant’ini’ tin exlanchal u ey? ");
INSERT INTO husNT1971_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Tam toc’tsin a Pedro: ―Tata’its ojni’ pel it Cristo ax it bijithits ne’ets quit aban c’al a Dios quit chich. Pel ti Tsacamil a Dios ax in ey ejat abal ets’ey. ");
INSERT INTO husNT1971_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Toc’tsin a Jesús: ―Simón ti tsacamil a Jonás, it lej lablinchith cum u Tata ti eb jats ax ti tso’oblinchi ta ichich u lej ey. Yab ja i inic ax ti tso’oblinchi. ");
INSERT INTO husNT1971_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Tata’ a bij tit Pedro ax in le’ quin ulu t’ujub. C’al tata’ ne’ets cu tamcuy u bichohuil, ani yab ne’ets ca ejtohuat ca atan ni c’al in tsap an tsemla. ");
INSERT INTO husNT1971_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nan ne’ets tu pitha’ a lej uchbil tin cuenta jant’ini’ tin t’ajal a Dios ti Ts’ale. Jahua’ a Dios ti eb in ulumalits alhua’ quin t’aja’ u bichohuil ani jaye jahua’ yab alhua’ yab quin t’aja’, jats ca huat’banchi. ");
INSERT INTO husNT1971_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Tam a Jesús tu ucha’ huahua’ tu exobalilchic yab qui olchi jita’ max jaja’its pel a Cristo axi bijithits ne’ets ca aban c’al a Dios ca chich. ");
INSERT INTO husNT1971_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ma tamits a Jesús in ts’i’quiy tucu lejquith olchi huahua’ tu exobalilchic abal jaja’ lej bijchithits ca lejat c’ale ti Jerusalén ani ca lej yajchiquiyat. Ca bina tin c’ubac an yejtselabchic ani c’al an oc’lec pale’chic ani c’al axi exobchixchic c’al an ts’ejcath cau binath c’al a Moisés. Ca tsemtha ani oxchilab q’uicha ne’ets ca ejtha, in ulu. ");
INSERT INTO husNT1971_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Tam a Pedro in ne’tha’ hue’ pil a Jesús ani in c’uiyath ucha’ antse’: ―Ibac in le’ a Dios quit yajchiquiyat, Ajatic. Ni abal jay ni jita’ yab ne’ets quin ejtou ti lej yajchiquiy jant’ini’ a ulumalits. ");
INSERT INTO husNT1971_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Huilq’uin a Jesús in toc’tsiy: ―Satanás, quit tixc’an c’al nana’. Tata’ ojni’ a le’ac tiquin t’apchi u tsalap. Yab a tsalapnanchal in tsalap a Dios, expith in tsalap an inic jats a tsalapnanchal. ");
INSERT INTO husNT1971_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Tam a Jesús tu ucha’ huahua’ tu exobalilchic: ―Quin t’ajat jilcachiquiy in cuete’ culbetal jitats in le’ ca ts’at’ey c’al nana’. Aba ani’ max yajchiquiyat c’al an inicchic ani ma ca le’na ca tsemtha, bel tiquin ts’at’enchi. ");
INSERT INTO husNT1971_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Jitats in le’ expith quin t’aja’ in cuete’ culbetal, jats ne’ets ca q’uibey. Jitats quim bina’ tim ba’ c’al tu ebal nana’, jats ne’ets ca jec’ontha. ");
INSERT INTO husNT1971_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ni jant’o ti exbath max an inic quin tala’ c’alna’ jahua’ teje’ tsabal ani quin q’uiba’its in ejattal. Ni jant’o yab hua’ats in exbath ejtil in c’athpich exbath in ejattal. ");
INSERT INTO husNT1971_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Nana’ tin Juntal patal an inicchic ne’ets quin huichiy junil junax c’al an ángelchic quim puhuethanchat u bij c’al u Tata ti eb. Tam ne’ets cu jalbinchi ti junchic an inicchic jahua’its in t’ajamal. ");
INSERT INTO husNT1971_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Lej chubax nan tu uchal abal hua’ats axi tata’chic yab ne’ets quit thubat tsemets, biyat ma tiquin tsu’u nana’ tin Juntal patal an inicchic in c’uajatits tin lej Ts’ale. ");
INSERT INTO husNT1971_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Acac a q’uicha talbel a Jesús in ne’tha’ a Pedro ani a Jacobo ani a Juan ax pel in ebchal a Jacobo al i t’ec’at oc’ bolchal. ");
INSERT INTO husNT1971_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Taja’ in tejhua’methal tim ba’ c’al jaja’chic hue’ jalc’uthits in tejhua’ inictal. In hual lej ts’umimil ejtil a q’uicha ani lej maq’uiq’uil in toltomil. ");
INSERT INTO husNT1971_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ani jun jic’tohual jaja’chic in tsu’u jaye c’uajatits a Moisés ani a Elías ti t’ilomchic c’al a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Tam a Pedro in ucha’ a Jesús: ―Ajatic, tequeth alhua’ abal xo’ teje’ u junat c’uajatchic huahua’. Max a le’ac, qui ts’ejca’ ox i pathel ata, jun abal tata’, ani jun abal a Moisés, ani jun abal a Elías. ");
INSERT INTO husNT1971_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Tam ti exome ti cau a Pedro, tam ti chich jun i mule’ i tocou ti eb lej tajax c’al ti paxq’uiq’uiyatchic. Al nixe’ xi tocou in ats’a’chic u cau a Dios antse’: ―Axe’ ja’its u ichich hual Tsacamil. In culbel c’al jaja’. Jats jaja’ ca ats’anchichic in cahuintal. ");
INSERT INTO husNT1971_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Tam tin ats’a’its nixe’ xi cau axi ox an exobal, nuc’pachiquin tsabal, ani lej jiq’uelchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Tam utey a Jesús ani in tacchichic, ani in ucha’: ―Quit ts’aquiychic yabats quit jiq’uey. ");
INSERT INTO husNT1971_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Tam in met’alchic ani in tsu’u expith jilc’on a Jesús. Xant’ojits a Elias ani a Moisés. ");
INSERT INTO husNT1971_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Taley tam ti ne’ets pa’a’alchic a Jesús c’al axi ox in exobalil al am bolchal, a Jesús in ucha’chic: ―Jahua’ xohue’ a tsu’umalchic yab ca olchi jita’. Ca aychi ma tam nana’ tin Juntal patal an inicchic quin ejthajits ti al an jolimtalab. ");
INSERT INTO husNT1971_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Tam conoyab a Jesús c’al jaja’chic: ―¿Hualam max chubaxcua’ jahua’ in ulal an exobchixchic c’al an ts’ejcath cau binath c’al a Moisés, abal a Elías oc’chith ne’ets ca chich ani talbel ne’ets ca chich a Cristo? ");
INSERT INTO husNT1971_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","A Jesús in toc’tsiychic: ―Lej chubax ne’ets ca oc’chith chich a Elías quin tala’ ts’ejcanchi patal. ");
INSERT INTO husNT1971_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ani nan tu uchalchic abal che’nequits jun axi ejtil a Elías. Pel ja axi t’ajchinenec quithab c’al an inicchic, cum antsana’ le’na ca t’ajchin. Jant’ini’ ti yajchiquiyame jaja’ c’al an inicchic, antsana’ nana’ tin Juntal patal an inicchic ne’ets quin yajchiquiyatne. ");
INSERT INTO husNT1971_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Tam in exobalilchic a Jesús in ejtinchits abal antsana’ a Jesús in olnal a Juan pujax c’al nixe’ xi cau. ");
INSERT INTO husNT1971_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Taley u ulits huahua’ jun ti muthat an inicchic, ani taja’ utey jun i inic in tuthuhual in c’ualal tin tamet a Jesús. In ucha’: ");
INSERT INTO husNT1971_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","―Ajatic, tiquin yajnanchi u cuitolil cum u ts’ebtsinal ani in lej yajchicnal. Yan i calat u ijcab al i c’amal ani al i ja’. ");
INSERT INTO husNT1971_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","U chi’thanchi a exobalilchic, ani yab in ejtou quin jeltha’. ");
INSERT INTO husNT1971_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Toc’tsin a Jesús: ―Tata’ ojni’chic it lej q’uibts’oth a tsalap ani yab tim belal. In ohuat c’uajinec c’al tata’chic tu c’aya’nal, ani yabaye tim belamal. Tiquin chanchi an cuitol teje’. ");
INSERT INTO husNT1971_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Tam a Jesús in c’uiya’ an at’ax teneclab ani in canchi an cuitol. Tameq’ui jelthajits. ");
INSERT INTO husNT1971_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Talbel huahua’ tu exobalil i conoyal a Jesús antse’: ―¿Jale’ yab i ejtou huahua’ qui canchi an cuitol an at’ax teneclab? ");
INSERT INTO husNT1971_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Toc’tsin a Jesús: ―Jats cum yabaye a lej belamalchic a Dios ta ichich. Lej chubax nan tu uchalchic max a cua’al a belomtal tsipili’ ejtil i iyalab mostaza, ne’ets ca ejtou ca ucha’ nixe’ xi ts’en ca tixc’a ani ne’ets ca tixc’a. Patal ne’ets quit t’ajchin c’al a Dios max a lej belal ta ichich. ");
INSERT INTO husNT1971_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Nixe’ an at’ax teneclab ne’ets ca ejtouchic ca caltha’, expith quit lej olon ani quit pablats yab quit c’aputs. ");
INSERT INTO husNT1971_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Tam tu xe’ets huahua’ c’al a Jesús ti Galilea, tu uchalchic junil abal jaja’ in Juntal patal an inicchic ne’ets ca bina tin c’ubac i inicchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ca tsemtha ani oxchilab q’uicha ca ejtha. Ani u lej t’e’pinal huahua’ c’al nixe’ xi cau. ");
INSERT INTO husNT1971_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Taley u ulits huahua’ junax c’al a Jesús ti Capernaum. Taja’ chich i penal tuminchic tin cuenta an tiyopan, ani conoyab a Pedro: ―¿Im binal a Exobchixal an tumin tin cuenta an tiyopan? ");
INSERT INTO husNT1971_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Toc’tsin a Pedro: ―Ojni’ im binal. Tam otsits a Pedro al i ata ani conoyab c’al a Jesús: ―¿Jant’ini’ ta tsalpanchal Simón, an ts’alechic teje’ tsabal in conchal an jalbixtalab tumin in tsacamilchic o’ in conchal q’ue’atchic ax u abatnab c’al jaja’? ");
INSERT INTO husNT1971_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Toc’tsin a Pedro: ―In conchal q’ue’atchic. Tam uchan c’al a Jesús: ―Tam yab in cua’al in uchbil in tsacamilchic an ts’ale quim bina’ an jalbixtalab tumin. ");
INSERT INTO husNT1971_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Bel abal yab qui t’apchi in tsalap am penal tumin expith qui binanchi. Quit c’ale tihua’ ti pulic lejem ani an c’a’al to’ol axi ca c’ut’bay, jats ca caltha’. Tin hui’ ne’ets ca elchi jun i tumin axi quim baju abal nan cu binanchi ani abal tata’te ca binanchi. Jats ca ne’thanchi ani ca binanchi tin cuenta an tiyopan. ");
INSERT INTO husNT1971_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Taley huahua’ tu exobalil i conoy a Jesús: ―¿Jita’ axi más huinat exbath in ey tin tamet a Dios ti eb? ");
INSERT INTO husNT1971_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Tam a Jesús in caniy ca chich jun i tsacam, ani in c’uajba’ ti tamet huahua’. ");
INSERT INTO husNT1971_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Taley tu ucha’chic: ―Lej chubax nan tu uchalchic patal max yab ca co’oy a ichich tsa’at ejtil in ichich i tsacam, a Dios yab ne’ets quin t’aja’ ti Ts’ale ta ichich. ");
INSERT INTO husNT1971_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Jitats quin tsa’ca’ tim ba’ ejtil in ichich axe’ xi tsacam, jats ax im bajuhual ti más huinat exbath in ey c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ani jitats quim bats’u i tsacam c’al tin ebal u bij, tin mac’uchith bats’uhualne. ");
INSERT INTO husNT1971_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Lej c’athpich hualbith jitats quin t’ajchi ca hualbin jun i tsacam axi nan tim belal. In tomnalac ca palchin i alchic tsa’ t’ujub tin nuc’ an hualbinthom ani ca pet’na al i pulic lejem ca t’ajat uctsin. ");
INSERT INTO husNT1971_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Lej ts’ejhuantal an inicchic teje’ tsabal cum hua’ats yan jant’o c’al ta ca hualbintha. Ets’ey hua’ats ax u hualbinthom. Ani lej ts’ejhuantal an hualbinthom cum ne’ets ca lej yajchiquiyat c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Max ti hualbinthalac a c’ubac o a acan in tomnal ejtil max ca t’ajat muts’q’uiy jun a c’ubac o jun a acan ani ca pet’na’. In tomnal quit otsits tihua’ ti eb c’al a Dios c’al juncats a c’ubac o c’al juncats a acan, ani yab quit jolohuat quit ets’ey c’uajiy al am pulic c’amal c’al tsab a c’ubac o c’al tsab a acan. ");
INSERT INTO husNT1971_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Max a hual ti hualbinthalac in tomnal ejtil max ca t’ajat caltha’ jun a hual ani ca pet’na’. In tomnal quit otsits tihua’ ti eb c’al a Dios c’al juncats a hual, ani yab quit jolohuat ti al am pulic c’amal c’al tsab a hual. ");
INSERT INTO husNT1971_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Yab ca uluchic abal an tsacam yab in cua’al in exbath. Nan tu uchal abal in lej cua’al, ma ets’ey u lej beletnab c’al an ángelchic axi tihua’ c’uajat ti eb c’al u Tata. ");
INSERT INTO husNT1971_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Nana’ tin Juntal patal an inicchic in che’nec cu jec’ontha’ jitats q’uibenec xe’ets al an hualabtalab. ");
INSERT INTO husNT1971_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","¿Jant’ini’ ta tsalpayalchic ne’ets quin t’aja’ max jun i inic in cua’al bo’ inic i ovejachic ani ca q’uibey jun? Auxe’ max yab i ne’ets quin jila’ axi tse’ inic c’al lajuj beleu ti ac’ul al am bolchal, ani axi jun q’uibenec ne’ets ca c’ale quin alimichiquiy. ");
INSERT INTO husNT1971_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Max quin ela’ ne’ets ca c’athpich culbe c’al axi juncats q’uibenecac ani yab ejtil c’al axi tse’ inic c’al lajuj beleu yab q’uibenec. ");
INSERT INTO husNT1971_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Antsana’ i Tata ti eb yab in le’ abal ca q’uibey ma ni jun i tsacam. ");
INSERT INTO husNT1971_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Max a at belom u hualbinal c’al tata’, tam ca cuete’ ts’ejca’chic c’al tsab ta eb. Ca tso’obliy c’al in hualab, ani max ti c’ac’nanchi a cahuintal tam ne’ets ca ejtou quit juncunchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Max yab ti c’ac’nanchi a cahuintal, tam ca ne’tha’ tsab ox i belom quin ats’anchi jant’o a ulalchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ani max axi hualbinenec yab quin c’ac’nanchi in cahuintal jaja’chic, tam ca olchi an cau an tamcunel ebchalab. Ani max jaja’ yab quin c’ac’nanchi in cahuintal an tamcunel ebchalab, tam ca ajiyat ejtil max pel i pil inic o ejtil am bats’c’ul jalbixtalab tumin tin cuenta an gobierno axi yab belom c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Nan tu uchalchic an chubaxtalab. Ca huat’banchi an ebchalabchic an cau jahua’ a Dios ti eb in ulumalits alhua’ quin t’aja’ ani jaye jahua’ yab alhua’ yab quin t’aja’ jaja’chic. ");
INSERT INTO husNT1971_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Nan tu uchalchic max tsab ta eb ca junax conchi jant’o u Tata ti eb, jaja’ ne’ets ti pitha’. ");
INSERT INTO husNT1971_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ani max it tamcuthits tsab ox ta eb c’al tin ebal u bij, nana’ne taja’ ne’ets quin c’uajiy c’al tata’chic. ");
INSERT INTO husNT1971_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Tam utey a Pedro c’al a Jesús ani in conoy: ―¿Jayil i calat cu paculanchi u ebchal ca hualbin c’al nana’? ¿Ma expith buquil cu paculanchi? ");
INSERT INTO husNT1971_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Toc’tsin a Jesús: ―Yab expith buquil, ma jayil ca hualbin. Nan tu uchal ca ets’ey paculanchi. ");
INSERT INTO husNT1971_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Nan ne’ets tu olchichic jant’ini’ tin t’ajal a Dios ti Ts’ale ti eb. In t’ajal ejtil i ts’ale ax u nenchab c’al in t’ojnalilchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","In caniy ca chich jun axi c’al tu nenchab lej yantalam i milchic i pexu. ");
INSERT INTO husNT1971_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Cum yab in cua’al jant’o c’al ti quin jalbiy an toc’lab, uchan c’al an ts’ale quin nuju in tomquil ani in tsacamilchic ani patal jahua’ in cua’al abal quin ejtou quin jalbiy jahua’ in ne’thal. ");
INSERT INTO husNT1971_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Tam an t’ojnal in tuthu in c’ualal tin tamet an ts’ale ani in lej canat ucha’ antse’: Tiquin aychiye ani ne’ets tu tala’ jalbinchi jahua’ tu nenchal. ");
INSERT INTO husNT1971_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ani cum lej yajnanchix an ts’ale, jaxtam in tala’ paculanchi an toc’lab ani in hualca’ ca c’alets yabats in ne’thal jant’o. ");
INSERT INTO husNT1971_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Tam ti calejits nixe’ xi t’ojnal ani ne’etsits ti bel, in tamu in at t’ojnal c’al ax tu nenchab tsab ox pexu. In yac’uchi in nuc’ ani in thi’chi. In ucha’: Tiquin thubat jalbinchi jahua’ tin nenchal. ");
INSERT INTO husNT1971_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Tam in at t’ojnal in tuthu in c’ualal ani in lej canat ucha’ antse’: Tiquin aychiye ani ne’ets tu tala’ jalbinchi jahua’ tu nenchal. ");
INSERT INTO husNT1971_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ani ni hue’ yab in le’ quin aychi. Tocat in ne’tha’ abal ca baliyat al i huic’axte’. In ucha’ am beletnom huic’axte’ yab quin hualca’ ma quin tala’ jalbiy an toc’labcua’. ");
INSERT INTO husNT1971_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ani q’ue’atchic in at t’ojnal in exla’its abal antsana’ ti t’ajchinenec in at t’ojnal, ani jilc’on lej t’e’pithchic. C’alechic quin olchi an ts’ale jant’ini’ ti t’ajchinenec in at t’ojnal. ");
INSERT INTO husNT1971_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Tam an ts’ale in ulu ca chanchin ax im paculanchamal lej yan an toc’lab. Ulits ani uchan: Tata’ ojni’ lej pojcax a ichich. Nana’ tu paculanchi lej yan an toc’lab cum tin lej pacabetha’. ");
INSERT INTO husNT1971_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","In tomnamalac a yajnanchamalac a at t’ojnal jant’ini’ nana’ tu yajnanchi. ");
INSERT INTO husNT1971_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Tam lej tsacuy an ts’ale, ma im bina’ ca baliyat jaye ti al an huic’axte’. In ucha’ am beletnom huic’axte’ yab quin hualca’ ma quin tala’ jalbiy an toc’lab. ");
INSERT INTO husNT1971_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Tam a Jesús in ulu: ―Aniye jaye u Tata ti eb ne’ets ti t’ajchichic max yab ca paculanchi in hualab a at belom c’al patal a ichich. ");
INSERT INTO husNT1971_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Tam ti talits antsana’ ti exobchix a Jesús cale ti Galilea, c’ale ti Judea ani ulits ma tihua’ jec’at am pulic itse’ Jordán. ");
INSERT INTO husNT1971_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Lej ts’at’enchab c’al yan i inicchic. Taja’ in jelthal an ya’ulchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Tam utey i fariseochic in le’ quin tacchiquiy a Jesús, ani conoyab jaja’: ―¿In jilal a Dios an inic quin jilcacay in tomquil c’al jant’oquitsq’ui tam ebaltalab? ");
INSERT INTO husNT1971_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","A Jesús in toc’tsiychic: ―A ajiyamalchic an T’ocat Thuchlab abal tam ti yabaye hua’ats jita’ teje’ tsabal, tamna’ a Dios in ts’ejca’ jun i inic ani jun i uxum. ");
INSERT INTO husNT1971_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Jaxtam in ulu a Dios abal an inic ca tixc’an c’al in tata ani in mim abal ca juncun c’al in tomquil. Ani tam juncunenequitschic ejtil max juncatsits tin ebchiccua’. ");
INSERT INTO husNT1971_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Cum antsana’ juncatsmethachits jaja’chic c’al a Dios ani ejtil yabats tsab, jaxtam yabats alhua’ max an inic quin jilcacay in tomquil. ");
INSERT INTO husNT1971_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ani conoyabe a Jesús: ―¿Jale’ tam in ulu a Moisés abal an inic max ne’ets quin jilcacay in tomquil, ca oc’ox ts’ejcanchat ani ca pithan an u jun tu olnab jale’ ne’ets ca jilcacayat? ");
INSERT INTO husNT1971_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","A Jesús in ucha’chic tam: ―Cum lej t’ujbathchic in ichich an inic, jats tin thucha’ a Moisés abal bel an inic quin jilcacay in tomquil. Tam ti lej c’a’alac yab pel in lej culbetal a Dios an inic quin jilcacay in tomquil. ");
INSERT INTO husNT1971_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nan tu uchalchic abal max jun i inic quin jilcacay in tomquil ani yab tin ebal abal pel i inicbe, ani max ca tomquin c’al q’ue’at i uxum, tamna’ jaja’ pel i uxumbe. Ani max i inic ca tomquin c’al i uxum axi jilcacathits tin ebal abal pel i inicbe, tamna’ jaja’ pel i uxumbe jaye. ");
INSERT INTO husNT1971_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Tam huahua’ tu exobalil a Jesús i ulu: ―Max antsana’ lej tsapic in uchbil an tomquith inic c’al in tomquil, tam hualam in tomnal yab ca tomquin. ");
INSERT INTO husNT1971_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","A Jesús tu toc’tsiychic: ―Yab tim patal an inicchic in ejtohual quin ejtiy jahua’ u ulumal. Expith jitats ca pithan an tsalpathtalab c’al a Dios, jats ne’ets quin ejtiy. ");
INSERT INTO husNT1971_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Hua’ats talchic i inic yab u tomquinal cum in t’ajtalits ey pel i eunuco ani hua’ats jaye axi pel i t’ajanthach eunuco c’al in at inic. Hua’ats i inicchic jaye yab u tomquinal cum antsana’ pel in culbetal a Dios ti eb. Jitats in ejtohual, quin alhua’ ejtiy axe’ xi cau. ");
INSERT INTO husNT1971_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Taley chanchinal a Jesús i tsacamchic abal ca punchin in c’ubac ani ca conchinchat i lablinchixtalab c’al a Dios. Ani huahua’ tu exobalil a Jesús i c’uiya’ an chi’thomchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Tam a Jesús tu ucha’chic: ―Yab ca c’anchi an tsacamchic yab ca chi’tha c’al nana’. Expith jitats tsa’at in ichich ejtil in ichich i tsacam, jats ax im bats’uhual a Dios ti Ts’ale tin ichich. ");
INSERT INTO husNT1971_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Tam ti talits a Jesús quim punchi in c’ubac antsana’ nixe’ xi tsacamchic, tam c’alets. ");
INSERT INTO husNT1971_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Chich jun i cuitol inic c’al a Jesús in conoyal: ―¿Jant’o pel u uchbil cu t’aja’ abal quin it ejatliyat abal ets’ey? Tata’ it alhua’ exobchix tiquin ucha’. ");
INSERT INTO husNT1971_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Toc’tsin a Jesús: ―¿Jale’ tin uchal tin alhua’? Hua’ats juncats expith axi alhua’, ja’its a Dios. Max a le’ quit it ejatliyat abal ets’ey, ca putu c’al in uchbixtalchic a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Tam in conoyale an cuitol inic: ―¿Jahua’ tam uchbixtalab? Toc’tsin a Jesús: ―Yab ca tsemtha’ a at inic. Yab quit uxumbejin. Yab quit cue’en. Ni jita’ yab ca t’ajchi an janamtalab. ");
INSERT INTO husNT1971_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ca c’ac’na’ a tata ani a mim. Ca c’anitha’ a at inic jant’ini’ ta c’anithal ta ba’. ");
INSERT INTO husNT1971_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Toc’tsin an cuitol: ―Ma tam tu tsacamtal u tala’ putumal an uchbixtalab c’al axe’ ax tin uchamal. ¿Jant’o hualam u q’uibchale cu t’aja’? ");
INSERT INTO husNT1971_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Toc’tsin a Jesús: ―Max a le’ ca baju tit huinat alhua’ inic, quit c’ale ca tala’ nuju jahua’ a cua’al ani ca pitha’ an tumin an ts’ejhuantalchic. Ma tam tiq’uele quit huichiy ani tiquin ts’at’enchi. Tam ojni’ ne’ets quit pithan yan i c’alab tihua’ ti eb. ");
INSERT INTO husNT1971_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Tam tin ats’a’ an cuitol inic antsana’ an cau, c’ale lej t’e’pith in ichich cum in le’ quin cuete’ c’alna’ axi yan in cua’al. ");
INSERT INTO husNT1971_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Tam a Jesús tu ucha’chic huahua’ tu exobalil: ―Chubax man tu uchal abal lej q’uibat an ricochic quim bats’u a Dios ti Ts’ale tin ichich. ");
INSERT INTO husNT1971_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Tu uchalchic abal lej q’uibat ca huat’ey jun i camello tin lo’tal in acan an t’ithab, ani lej huat’ath más q’uibat abal i rico quim bats’u a Dios ti Ts’ale tin ichich max quin huat’ath tsapna’ axi yan in cua’al. ");
INSERT INTO husNT1971_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Tam huahua’ i ats’a’ nixe’ xi cau i lej jic’pal, ani i conoyal jun c’al xi jun: ―¿Max chubax antsana’ jahua’ in ulu, tam jita’ hualam ne’ets ca ejtohuat ca jec’ontha? ");
INSERT INTO husNT1971_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","A Jesús tocat tu met’a’chic ani tu ucha’: ―An inicchic yab in ejtohual quin cuete’ jec’ontha’ tim ba’, expith c’al a Dios ojni’ ne’ets ca ejtohuat ca jec’ontha. A Dios expith patal in ejtohual quin t’aja’. ");
INSERT INTO husNT1971_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Tam uchan a Jesús c’al a Pedro: ―Ajatic, huahua’ i tala’ jilamal i c’al jahua’ i co’oyamal, ani xo’ u ts’at’enec c’al tata’. ¿Jant’o tam alhua’talab ne’ets qui bats’u? ");
INSERT INTO husNT1971_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Toc’tsin a Jesús: ―Nana’ tin Juntal patal an inicchic ne’ets quin chich quim buxcan tu ts’alat lactemil cu t’aja’ tin lej Ts’ale ti al an it eb. Chubax nan tu uchal abal tata’chic ax it ts’at’enec c’al nana’ ne’ets quit buxcan ti lajuj tsab i ts’alat lactem ca ts’ejca’ axi lajuj tsab i cuenel am bichou Israel. ");
INSERT INTO husNT1971_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Patal jitats in jilamalits jant’o c’al tin ebal u bij ne’ets ca pithan yan más c’al a Dios. Ma bo’ inic huichc’othe ne’ets ca pithan max quin jila’ in q’uima’, max in ebchal, max in uxum ebchal, max in tata, max in mim, max in tomquil, max in tsacamilchic, max in tsabalil. Ani ti eb ne’ets ca c’uajiy it ejatlith abal ets’ey. ");
INSERT INTO husNT1971_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Hua’ats xohue’ teje’ tsabal yan i inicchic pulic in ey, ani talbel ne’ets ca ajiyat ti tsipilin in ey ti eb c’al a Dios. Hua’ats jaye yan i inicchic axi xohue’ tsipilin in ey, ani talbel ne’ets ca ajiyat ti pulic in ey ti eb c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Ne’ets tu olchiyechic jant’ini’ tin t’ajal a Dios ti Ts’ale. Jant’ini’ jun i amu ca c’ale thajujul quin aliy i t’ojnal ca t’ojon c’al i lab t’uthublom, antsana’ a Dios in aliyal jita’ quin t’ojontha’ tin t’ojlabil. ");
INSERT INTO husNT1971_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","An amu in ts’ejca’ an cau c’al an t’ojnalchic abal quin jalbiy c’al jun i tumin denario ta q’uicha. Tam in aba’ ca c’alechic quin t’ojonchi an lab t’uthublom. ");
INSERT INTO husNT1971_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Talbel ti beleu hora an thaju cale an amu tin q’uima’ ani c’ale ti plaza. T’aja’ in tsu’u i inicchic xe’tsitsilq’ui yab jant’o ta ca t’ojon. ");
INSERT INTO husNT1971_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","In ucha’chic: Quit c’alechicte ca t’ojonchi an lab t’uthublom ani ne’ets tu alhua’ jalbinchi a q’uichajil. Ani c’ale jaja’chic jaye ca t’ojon. ");
INSERT INTO husNT1971_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Jaye ti ts’ejel q’uicha ani ti ox hora an huacal c’ale an amu quin aliye i t’ojnal. ");
INSERT INTO husNT1971_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","C’ale jaye ti bo’ hora an huacal ani in ela’ q’ue’at i inicchic yab jaye jant’o ta ca t’ojon. In ucha’chic: ¿Jale’ a palc’anchamal an hora yab it t’ojnenec? ");
INSERT INTO husNT1971_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Toc’tsinchic: Cum yab jita’ tucu t’ojontha’, jaxtam yab u t’ojnenec. Tam uchanchic c’al an amu: Quit c’alechicte ca t’ojonchi an lab t’uthublom ani ne’ets tu alhua’ jalbinchi a q’uichajil. ");
INSERT INTO husNT1971_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Tam ti aclejits, tamna’ in ucha’ an amu an cuentalom t’ojnal: Ca caniy ca chich an t’ojnalchic an ca jalbinchi an t’ojlab. Oc’ox ca jalbinchi axi lej taltalabits ulits ca t’ojon, tiq’uele ca jalbinchi axi lej oc’ox ulits ca t’ojon. ");
INSERT INTO husNT1971_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Tam chichchic ax in ts’i’quiyamal ti t’ojnal ma ti bo’ hora an huacal, ani ti junchic pithan quithat jun i tumin denario. ");
INSERT INTO husNT1971_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Taley chichchic jaye axi oc’ox ulits ca t’ojon, ani in tsalpayal abal ne’ets ca pithan más an tumin. Ani jaja’chic jayetseq’ui pithan ti junchic jun i tumin denario. ");
INSERT INTO husNT1971_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Im bats’u an tumin ani tocat in c’uiyalchic an amu. ");
INSERT INTO husNT1971_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","In uluchic: Axi taltalabits ulits ca t’ojon expith t’ojnenec jun i hora ani pithnenec an tumin jant’ini’ huahua’. Patal a q’uicha huahua’ u t’ojnenec ani i yajchicnamal an c’ac’al. ");
INSERT INTO husNT1971_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Tam toc’tsin an amu: Pay’lom, nan yab tu cue’chal ni jant’o. I ts’ejca’its an cau abal nan ne’ets tu jalbinchichic c’al jun i tumin denario. ");
INSERT INTO husNT1971_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ca t’ajat bats’uchic an jalbixtalab ani huinits quit c’ale. Pel u culbetal cu jalbinchi jayetseq’ui axi taltalabits ulits ca t’ojon jant’ini’ tata’chic ax it oc’ox ulits. ");
INSERT INTO husNT1971_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","U ejtohual cu t’aja’ c’al u tuminal jahuats nan cu le’na’. Yab ca co’oy i pa’ixnomtalab ta ichich c’al jahua’ alhua’ u t’ajamal, in ulu an amu. ");
INSERT INTO husNT1971_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ani in uluye a Jesús: Hua’ats i inicchic u tsalpanchab yab exbath in t’ojlabil c’al in at inic, ani c’al a Dios ojni’ u tsalpanchab exbath in t’ojlabil. Hua’ats i inicchic u tsalpanchab exbath in t’ojlabil c’al in at inic, ani c’al a Dios u tsalpanchab yab exbath in t’ojlabil. Hua’ats yan i inicchic u caniyab c’al a Dios ca t’ojon c’al jaja’, ani hue’ expith axi tacuthits ja’its ax u t’ojnal. ");
INSERT INTO husNT1971_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Tam tu ne’etsits huahua’ lajui tsab tu exobalilchic junax c’al a Jesús ti Jerusalén, u peley hue’ ti bel. Tam a Jesús tu ucha’chic: ");
INSERT INTO husNT1971_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Ca lej t’aja’chic ti cuenta xohue’ hue’its cu ulits ti Jerusalén. Taja’ nana’ tin Juntal patal an inicchic ne’ets quim bina tin c’ubac an oc’lec pale’chic ani tin c’ubac axi exobchix c’al an ts’ejcath cau binath c’al a Moisés. Jaja’chic ne’ets tiquin jolbiy abal quin tsemtha. ");
INSERT INTO husNT1971_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Taley ne’ets tiquin huat’ba’ tin c’ubac axi yab Israelchic. Ani jaja’chic ne’ets tiquin tilibna’ ani tiquin huithc’oy, ani ma tiquin t’ajat tsemtha’ ti al an cruz. Aba ani’ quin tsemtha, oxchilab q’uicha ne’ets quin ejtha ti al an jolimtalab. ");
INSERT INTO husNT1971_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Tam uteychic c’al a Jesús a Jacobo ani a Juan ani c’al in mim. In tata jaja’chic pel a Zebedeo. In mim jaja’chic in tuthuhual in c’ualal tin tamet a Jesús quin conchinchi i alhua’talab. ");
INSERT INTO husNT1971_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ani conoyab c’al a Jesús: ―¿Jant’o tam alhua’talab a le’ac abal nan tu t’ajchi? Uchan a Jesús: ―Axe’ xi tsab u tsacamil u le’ac abal tata’ ca pitha’ an q’uij ca buxcan jun ta huinab ani jun ta c’uatab tam ca t’aja’ tit lej Ts’ale teje’ tsabal. ");
INSERT INTO husNT1971_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","A Jesús in ucha’chic: ―Tata’chic yab a alhua’ ejtiyamal jahua’ ax tin conchal. ¿A ejtohualchic ca yajchicna’ an yajchictalab ani an tsemtalab axi nan ne’ets cu yajchicna’? Toc’tsin jaja’chic: ―I ejtohual. ");
INSERT INTO husNT1971_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Tam a Jesús in ucha’chic: ―Chubax ne’ets ca yajchicna’te i yajchictalab ani i tsemtalab ejtil axi nan ne’ets cu yajchicna’. Expith yab u uchbil abal nan tu pitha’ an q’uij quit buxcanchic tu huinab ani tu c’uatab. Pel in uchbil expith u Tata quim pitha’ an q’uij antsana’ jitats jaja’ im bijiyamalits. ");
INSERT INTO husNT1971_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Huahua’ axi lajuj tu exobalil a Jesús u tsacuy, cum axi tsab antsana’ in le’ ca pithan an q’uij. ");
INSERT INTO husNT1971_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Tam a Jesús tu caniychic cu utey, ani tu ucha’: ―A tso’obits tata’chic abal am pulic oc’lec u tsapic abatnom ani in t’ajal ti pulic inic c’al am bichoulomchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Yab in tomnal tata’chic antsana’ ca t’aja’ jayetseq’ui. Max a le’ tit pulic a ey c’al a Dios, ca tolmiy a at belomchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ani max a le’ tit lej c’athpich pulic a ey c’al a Dios, ca t’ayat tolmiy a at belomchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Cum nana’ tin Juntal patal an inicchic in che’nequits abal tin tolmix c’al an inicchic, ani yab tin tsapic abatnom. Ma ne’ets cu bina’ tu ba’ quin tsemtha ti calchixtalab abal yantalam i inic ca hualca ani yabats ca c’unat co’oyat c’al i hualabtalab. ");
INSERT INTO husNT1971_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Taley ne’ets u calelits huahua’ junax c’al a Jesús ti Jericó, ani ts’at’at i pulic mulcunel jaye. ");
INSERT INTO husNT1971_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ani c’uajat tsab i joc’tsi quetelchic tin hual am bel. Tam tin ats’a’chic abal ne’ets ca huat’ey a Jesús taja’, in thajat ucha’chic: ―Tata’ Ajatic axi pel it at xits’lab c’al a David, tucu yajnanchi. ");
INSERT INTO husNT1971_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ani tamna’ c’uiynalchic c’al an mulcunel, uchan ca ts’ibc’an. Ani jaja’chic tocat in más thajat ucha’ a Jesús: ―Tata’ Ajatic axi pel it at xits’lab c’al a David, tucu yajnanchi. ");
INSERT INTO husNT1971_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Tam cubiy a Jesús ani in caniy ca chich c’al jaja’ an joc’tsichic. Ulitschic ani conoyat c’al a Jesús: ―¿Jant’o a le’chic abal nan tu t’ajchi? ");
INSERT INTO husNT1971_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Toc’tsin jaja’chic: ―I le’ abal tucu tsu’uxmetha’. ");
INSERT INTO husNT1971_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Tam a Jesús in yajnanchi ani in tacchi in hualchic. Ma tamna’its u tajax tsu’uxits, ani taley ts’at’eychic c’al a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Taley u ne’etsits cu ulitschic ti Jerusalén, ani i baju utat ti bichou Betfagé axi utat ti bolchal Olivos. Ma taja’ a Jesús ne’ets quin aba’ tsab i at exobal c’al i cau. ");
INSERT INTO husNT1971_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","In ucha’chic: ―Quit c’alechic al nixe’ xi bichou axi utatits, ani taja’ ne’ets ca ela’ jun i burra huic’at c’al in inic t’am. Ca piliy ani tiquin chanchichic teje’. ");
INSERT INTO husNT1971_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Max jita’ ti ucha’ abal jale’ ta piliyal, ca ucha’ abal nana’ in Ajatic ax u yejenchal. Jaye ca ucha’ abal thubat ne’ets cu huichba’. ");
INSERT INTO husNT1971_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ani antsana’ ne’ets ca putun jahua’ in olnamal ani in thuchamal an caulome c’al a Dios antse’: ");
INSERT INTO husNT1971_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Ca ucha’ ax u c’uajilchic ti Sion: Ca tsu’uchic te tal a Ts’alejil. Tal c’al i tsa’attalab punat al i burra c’al i tsacam burro. Pel ax u eyenthab ti quital. ");
INSERT INTO husNT1971_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Tam c’alechic axi tsab i exobal in t’aja’ jant’ini’ ti uchnenec c’al a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","In chi’tha’chic am burra ani in inic t’am c’al a Jesús. Taley im punchal jaja’chic in toltomil tin cux am burra ani in t’am, ani puney a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ani an mulcunel in mo’cal in toltomil ba’ am bel jun ti ne’ets ca huat’ey a Jesús. Talchic jaye in cotoyal in c’ue’el i tsacam te’ quin mo’canchi ti bel. ");
INSERT INTO husNT1971_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Axi oc’chith ne’ets ani jaye axi tal cuxlab in thajat ulalchic: ―Qui puhuethanchi im bij axi te talits in at xits’al an ts’ale David. Ja’its axi tal abath c’al a Dios, ani ja’its qui ajatnanchi im bij. Qui puhuethanchi im bij a t’ec’at Dios ti eb. ");
INSERT INTO husNT1971_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Tam ti otsitsits a Jesús ti Jerusalén, tam thayc’an am bichou lej xacuecuel. Yantalam i inic in conoyalchic: ―¿Jita’ hualam axe’ xi inic axi che’nec? ");
INSERT INTO husNT1971_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Toc’tsinchic axi ts’at’at c’al a Jesús: ―Ja’its a Jesús. Pel in caulomejil a Dios axi tal ma ti bichou Nazaret cuentalith ti Galilea. ");
INSERT INTO husNT1971_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Taley otsits a Jesús ti al am pulic tiyopan ti Jerusalén, in tala’ quethmachiquiyal eleb axi nujul ani axi ts’a’um taja’. In cuajlachiquinchal in mexajil an jalum tumin ani in lactemilchic an nujul lab cucu’. ");
INSERT INTO husNT1971_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","In ucha’chic: ―Thuchathits ti al an T’ocat Thuchlab jahua’ in ulu a Dios antse’: U q’uima’ ja’its jun ta ca olon an inicchiccua’. Nan tu uchalchic abal xo’ tata’ a eyenthal abal ca cue’chi jant’o ax u che’el ti ol. ");
INSERT INTO husNT1971_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Taja’ ti al an tiyopan u utel talchic i joc’tsi ani talchic i c’uets’e’, ani a Jesús in jelthalchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Tam tu tsu’tab a Jesús antsana’ in t’ajal i labith t’ajbilab, lej tsacul an oc’lec pale’chic ani axi exobchix c’al an ts’ejcath cau binath c’al a Moisés. Jaye lej tsacul cum in ats’alchic i cuitol ani i ts’ic’ach in thajat ulalchic antse’: Qui puhuethanchi im bij axe’ axi pel in at xits’al an ts’ale David. ");
INSERT INTO husNT1971_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Tam conoyab a Jesús c’al nixe’ xi oc’lec pale’chic ani c’al nixe’ xi exobchix: ―¿A ats’al jahua in ulal nixe’ xi cuitolchic ani an ts’ic’ach? Toc’tsin a Jesús: ―Ojni’ u ats’al. Auxe’ max yab a ajiyamalchic jahua’ in ulal an T’ocat Thuchlab tin cuenta am puhuethaxtalab c’al im bij a Dios. In ulal antse’: Tata’ a Dios a pithamal ma an tsacamchic ani axi chuchule i cau abal ti puhuethanchi a bij. ");
INSERT INTO husNT1971_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Tam cale a Jesús ti Jerusalén, ta c’ale ti bichou Betania. Ani tats ti jilc’on an acal. ");
INSERT INTO husNT1971_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Tam ti chutheyits, huichelits junil a Jesús ti Jerusalén, ani lej c’a’il. ");
INSERT INTO husNT1971_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","In tsu’u jun i te’ higuera tin hual am bel, ani utey taja’. Ni jant’o tam hualilab yab in elchi, tocat xequeth. Tam a Jesús in tauna’ an te’, in ucha’: ―T’ajat yabats quit hualin. Tameq’ui t’ajat huayts’on an te’ higuera. ");
INSERT INTO husNT1971_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Huahua’ tu exobalil a Jesús i tsu’u jant’o antsana’ in t’ajamal, ani i lej jic’pal. Ani i conoyal a Jesús: ―¿Jant’ini’ ti lejat huayts’on jun athic an te’ higuera? ");
INSERT INTO husNT1971_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","A Jesús tu toc’tsiychic: ―Lej chubax nan tu uchalchic abal max ca lej bela’ a Dios ani yab ca co’oy i hualamtalab ta ichich, tam ne’ets quit ejtohuat quit t’ajchinchic ejtil nan u t’ajamal an te’ higuera. Ne’ets ca ejtou ca ucha’ nixe’ xi ts’en ca tixc’a ca pet’na al i pulic lejem, ani a Dios ne’ets ti t’ajchi. ");
INSERT INTO husNT1971_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Patal jahuats ca conchi a Dios, jaja’ ne’ets ti pitha’ max chubax a lej belalits c’al patal a ichich. ");
INSERT INTO husNT1971_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Tam otsitsits junil a Jesús ti al am pulic tiyopan, ani u exobchixits taja’. Ani utenchab c’al an oc’lecchic pale’ ani c’al an yejtselab Israelchic. Conoyab: ―¿Jita’ ti pithamal an eyaltalab ani jita’ ti abamal abal ca t’aja’ jahua’ a t’ajal? ");
INSERT INTO husNT1971_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Toc’tsin a Jesús: ―Nana’ne ne’ets tu conoychic c’al jun i cau. Max tata’chic tiquin toc’tsinchi, tam nana’ne ne’ets tu olchichic c’al jant’o tam eyaltalab tu t’ajal jahua’ u t’ajal. ");
INSERT INTO husNT1971_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿C’al jita’ ti aban a Juan ti pujax? Tiquin toc’tsinchi, max c’al a Dios o max c’al i inic. Tam jaja’chic in t’iloxnachiquiyal jahua’ in ulu a Jesús, ani taley in uluchic: ―¿Jant’ini’ ti qui toc’tsinchi? Max qui ulu abal c’al a Dios jats ti abnenec a Juan ti pujax, tam jaja’ ne’ets quin ulu abal jale’ yab i belchamal in cahuintal. ");
INSERT INTO husNT1971_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Max qui ulu abal c’al i inic jats ti abnenec, jant’o hualam cu t’ajchin c’al am bichou, cum tim patal in lej belalits abal a Juan pel i lej chubax caulome abnenec c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Jaxtam tocat uchan a Jesús c’al jaja’chic: ―Yab i tso’ob c’al jita’ ti abnenec a Juan ti pujax. Tam a Jesús in ucha’chic: ―Nana’ne yab ne’ets tu olchichic c’al jita’ tin abnenec ani c’al jita’ tim pithnenec u eyaltal cu t’aja’ jahua’ u t’ajal. ");
INSERT INTO husNT1971_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","A Jesús in uchayechic: ―Ne’ets tu olchichic i cau tin cuenta jun i inic ax in co’oy tsab in cuitolil. In ucha’ axi jun: Cuitol, xo’ quit c’ale quit t’ojon c’al an lab t’uthublom. ");
INSERT INTO husNT1971_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Toc’tsin an cuitol: Yab ne’ets quin c’ale. Aba ani’ antsana’ in ulu, bel talbel c’ale ti t’ojnal. ");
INSERT INTO husNT1971_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Tamna’ c’ale an tatalab quin tauna’ axi junaque in cuitolil. In ucha’ jayetseq’ui ca c’ale ca t’ojon. Toc’tsin an cuitol: Ojni’ tata, ne’ets quin c’ale. Aba ani’ antsana’ in ulu, bel yab c’ale. ");
INSERT INTO husNT1971_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Jahua’ axi tsablom in t’ajchi in culbetal in tata? Toc’tsinchic: ―Pel axi oc’ox tauna jats in t’ajchi in culbetal in tata. Tam a Jesús in ucha’chic: ―Lej chubax nan tu uchalchic abal am bats’c’ulchic jalbixtalab tumin tin cuenta an gobierno ani an uxumchic axi c’ambibil c’al an inic, más in le’chic ca otsits ti eb jun tin t’ajal a Dios ti Ts’ale ani tata’chic yab a le’. ");
INSERT INTO husNT1971_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Chich a Juan pujax ti olchix jant’ini’ ta ca t’aja’ jahua’ bolith, ani yab a belchichic. Ojni’ belchin c’al axi pelac i bats’c’ul jalbixtalab tumin tin cuenta an gobierno ani c’al i uxumchic axi xe’etsac c’ambibil c’al an inic. A tsu’umalchic abal antsana’ belchame a Juan c’al jaja’chic c’al in exobchixtal, ani tata’chic yabaye it jic’tsonenec c’al a hualab ani yab a belchamal. ");
INSERT INTO husNT1971_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ca ats’a’chic q’ue’at i jalpith cau antse’. Jun i thabal in t’aya’ i lab t’uthublom tin tsabalil. In tenmay c’al i te’ ani in ts’ejca’ in tsa’ub in hualil an lab t’uthub. Jaye in ts’ejca’ jun i t’ec’at tsac’ jun ti ca c’uajiy am beletnom lab t’uthublom. Taley im bina’ c’al jita’ ta ca t’ojonchat an lab t’uthublom. Ani c’ale ou an thabal. ");
INSERT INTO husNT1971_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Taley im baju in q’uijil an cotlats c’al an lab t’uthub, ani an thabal in aba’ i t’ojnalchic ca c’ale quim bats’c’unchi an lab t’uthub axi ne’ets ca jilc’on abal jaja’ an thabal. ");
INSERT INTO husNT1971_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ulits jaja’chic, ani tocat yac’uan c’al an t’ojonchixchic. Jun i t’ojnal cuathan, ani jun tsemtha, ani jun cui’iyat c’al i t’ujub. ");
INSERT INTO husNT1971_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Tam an thabal in aba’ ca c’aleye más yan i t’ojnal. Ani t’ajchinchic jayetseq’ui jant’ini’ axi oc’ox abnenecchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ani tin lej taltalits an thabal in lejat aba’ in lej tsacamil. In tsalpay abal chubax ne’ets ca alhua’ bats’uhuat in cuete’ tsacamil. ");
INSERT INTO husNT1971_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ani iba, expith in uluchic an t’ojonchix tam tin tsu’uchic pel in tsacamil an thabal antse’: Jats axe’ ne’ets ti c’alnanchix c’al an lab t’uthublom tam ca tsemets in tata. Qui tsemtha’ ani qui c’alnanchi huahua’. ");
INSERT INTO husNT1971_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Tam in yac’ua’chic ani in caltha’ tin elebtal an lab t’uthublom. In t’ajat tsemtha’. ");
INSERT INTO husNT1971_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Tam a Jesús in conoychic axi taja’ c’uajat: ―¿Tam ca chich an thabal lab t’uthublom jant’ini’ ti ne’ets quin t’ajchi nixe’ xi t’ojonchixchic? ");
INSERT INTO husNT1971_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Toc’tsin jaja’chic: ―Ne’ets quin t’ajat tsemtha’ cum lej pojcaxchic, ani ni hue’ yab ne’ets quin yajnanchi. Ne’ets quim bina’ an lab t’uthublom ca t’ojonchat c’al q’ue’atchic i inic, ani jaja’chic ojni’ ne’ets quim binanchi in hualil an lab t’uthublom c’al an thabal ax in uchbil quim binanchi. ");
INSERT INTO husNT1971_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Tam a Jesús in ucha’chic: ―Auxe’ max yab a ajiyamalchic an T’ocat Thuchlab jun tin olnab nana’its ejtil in mimlab t’ujub antse’: An ts’ejcom atachic in ulu yab jant’o ti alhua’ axe’ xi t’ujub, ani tocat im pet’na’. Ani ja’its nix an t’ujub axi punuthits ti mimlab t’ujub. Jats a Dios axi antsana’ im punu. Pel i jic’path t’ajbilab abal antsana’ ti punuthits c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Cum tata’chic nan tim pojcamal, jaxtam nan tu uchal abal a Dios yab in t’ajal ti Ts’ale c’al tata’chic. Expith in t’ajal c’al jitats tiquim bats’u nana’. ");
INSERT INTO husNT1971_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ejtil an inic axi ca ijcan al i t’ujub ani ca yajchiquiyat, antsana’ jitats yab tim belal nana’. Ejtil max ca ijcanchat i t’ujub ani ca tsemtha, antsana’ jitats yab tim belal nana’. ");
INSERT INTO husNT1971_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Tam ti an oc’lec pale’chic ani an fariseochic in ats’a’ nixe’ xi jalpith cau, in exlalitschic abal jaja’ ja’its ax u uxnal. ");
INSERT INTO husNT1971_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Jaxtam in le’chic quin yac’ua’ a Jesús. Tocat yab in t’aja’chic, cum in ts’ejnal jant’o ca t’ajchin c’al an inicchic, cum in lej belalchic abal a Jesús pel i lej chubax caulome abnenec c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","A Jesús in olchiye an inicchic i jalpith cau antse’. In ucha’chic: ");
INSERT INTO husNT1971_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―Nan ne’ets tu olchiyechic jant’ini’ tin t’ajal a Dios ti Ts’ale. Jun i ts’ale ne’ets quin t’ajchi in cuitolil an tomquintalab ajib. ");
INSERT INTO husNT1971_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","In aba’its i olchixchic quin caniychic patal axi bijithits ca chich, ani tocat yab in le’chic ca chich. ");
INSERT INTO husNT1971_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Tam in abaye ca uchanchat: Ts’ejcathits an c’apnel. Tsemthachits an c’apnel toro ani an t’u’uthmethach co’nel. Cum lej t’ojojothits tihua’, ca lej luba’ quit c’aletschic c’al an tomquintalabcua’. ");
INSERT INTO husNT1971_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ani ma lejatits yab in t’ajat t’aja’chic ti cuenta ca utey axi lej bijithits. Jun c’alets ti lonim c’al in tsabalil, ani jun c’alets ti nujul. ");
INSERT INTO husNT1971_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ani talchic axi q’ue’at ma tocat in yac’ua’ an olchixchic quin lej alhua’ cuatha’, ma in tsemtha’. ");
INSERT INTO husNT1971_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Tam lej tsacuyits an ts’ale, ma in aba’ i soldado quin tsemtha’chic axi tsemthomats c’al an olchix ani quin tala’ chica’ am bichou. ");
INSERT INTO husNT1971_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Taley talbel an ts’ale in ucha’ in t’ojnalilchic: Lej jum putat t’ojojothits an ajib, ani axi lej bijithits ca chich yabats ca pithan an q’uij ca chich. ");
INSERT INTO husNT1971_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Jaxtam quit c’alechic ca caniy ca chich c’al an tomquintalab ajib patal axi ca tamuq’ui ti alte’ belchic, in ulu. ");
INSERT INTO husNT1971_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ani c’alechic xe’ets in canalchic patal jahuaquitsq’ui tam inic max alhua’ ani max yab alhua’. In ne’thachicalchic c’al an tomquintalab ajib. Ani taley ma jilc’on t’uchichithits an ata. ");
INSERT INTO husNT1971_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Tam otsitsits an ts’ale quin tsu’u axi chi’thachitschic, ani taja’ in tsu’u jun i inic axi yab toltomith c’al in cuenta an tomquintalab. ");
INSERT INTO husNT1971_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ani uchan c’al an ts’ale: ¿Ja’ub, jant’ini’ tit otsenenequits teje’ ani yab it toltomith c’al an toltom ax in cuenta an tomquintalab? Ani yab jant’o in toc’tsiy nixe’ xi inic. ");
INSERT INTO husNT1971_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Tam an ts’ale in ucha’chic in t’ojnalilchic c’al in cuenta an ajib: Ca huic’chi in acan ani in c’ubac nixe’ xi inic ani ca jolou eleb ti al an yic’uax. Tats ca uq’uin ani ca huech’ech’lats in camab c’al an yajchictalab. ");
INSERT INTO husNT1971_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","In uluye a Jesús: Hua’ats yan i inicchic u caniyab c’al a Dios ca otsits c’al jaja’, ani hue’ expith axi tacuthits ja’its ax u otsel. ");
INSERT INTO husNT1971_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Taley an fariseochic in ts’ejca’ an cau jant’ini’ ti quin t’ajchi a Jesús abal max quin ulu i q’uibts’oth cau c’al ca ejtohuat ca jolbiyat. ");
INSERT INTO husNT1971_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","In aba’chic talchic in at fariseo ani jaye talchic axi ts’at’at c’al a Herodes quin tauna’ a Jesús. Ulitschic ani in ucha’: ―Exobchix, i tso’ob abal jahua’ tata’ ca ulu pel i lej chubaxtalab. Expith a olnanchal in tequeth belil a Dios. Yab a t’ajal ti cuenta jahua’its it uxnal c’al an inic, ani yab it poc’oth tsu’tom c’al an inicchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Tucu ucha’ max i cua’al i uchbil o max yab i cua’al qui jalbiy an jalbixtalab tumin c’al an ts’ale oc’lec romano. ");
INSERT INTO husNT1971_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Cum a Jesús in exla’its abal pel i c’ambix cau, jaxtam in toc’tsiychic antse’: ―Tata’ ojni’chic it c’ambix. ¿Jale’ a le’ tiquin macla’? ");
INSERT INTO husNT1971_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Qui met’a’ jun i tumin ax a jalbixnal. Tam pithanits. ");
INSERT INTO husNT1971_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Tam in met’a’ ani in conoy: ―¿Jita’ axe’ in hual ani jita’ axe’ im bij axi thuchath teje’ al an tumin? ");
INSERT INTO husNT1971_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Toc’tsin jaja’chic: ―Pel in hual ani pel im bij an ts’ale oc’lec. Tam a Jesús in ucha’chic: ―Ca pitha’ an ts’ale oc’lec jahua’ pel a uchbil ca pitha’, ani ca pitha’ a Dios jahua’ pel a uchbil ca pitha’ jaye. ");
INSERT INTO husNT1971_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Tam tin ats’a’chic antsana’ an fariseo an cau, tocat in lej jic’pal. Tam tixc’anchic c’al a Jesús, ani ta c’alets. ");
INSERT INTO husNT1971_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Nixe’ xa q’uicha chich jaye i saduceochic c’al a Jesús. Cum yab im belalchic abal max ne’ets ca ejtha an tsemelomchic, jaxtam uchan a Jesús c’al jaja’chic: ");
INSERT INTO husNT1971_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","―Exobchix, a Moisés in thucha’ abal max ca tsemets jun i tomquith inic ani yab in co’oyamal i tsacam c’al in q’uimathil, ca tomquin in ebchal an tsemelom c’al an tsemchith uxum. Lequitsq’ui max quin co’oy i tsacam tam. ");
INSERT INTO husNT1971_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Hua’atsac c’al huahua’ buc i ebchalab. Tomquin an oc’ox, ani tsemets yab in co’oyamal i tsacam. Taley tomquin in tsabchil ebchal an tsemelom c’al an tsemchith uxum. ");
INSERT INTO husNT1971_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Tsemets jaja’ jaye. Ma tim patal nixe’ xi buc i ebchalab tomquinenec c’al nixe’ xi uxum juncats. ");
INSERT INTO husNT1971_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Taley tsemets jaye an uxum. ");
INSERT INTO husNT1971_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","¿Cum tomquinenec an uxum c’al axi buc i ebchalab teje’ tsabal, c’al jahua’ ti ne’ets ca c’uajiy ti tomiclab tam ca ejtha’ an tsemelomchic? ");
INSERT INTO husNT1971_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","A Jesús in toc’tsiychic: ―Tata’chic ojni’ lej q’uibts’othits a tsalap tin cuenta an tsemelomchic, cum yab a exlal an T’ocat Thuchlab ani yab a exlanchal in tsap a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Tam ca ejtha an tsemelomchic in ey an inic ani in ey an uxum yabats ne’ets ca tomquin. Ne’ets ca c’uajiychic ejtil an ángelchic axi ti eb yab u tomquinal. ");
INSERT INTO husNT1971_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Tin cuenta abal u ejthab an tsemelomchic, auxe’ max yab a ajiyamalchic jahua’ in ulu a Dios ani jahua’ thuchathits. In ulu antse’: ");
INSERT INTO husNT1971_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Nana’its pel tin Diosil a Abraham ani tin Diosil a Isaac ani tin Diosil a Jacob, in ulu. Cum pel in Diosil nixe’ xi ox i inic axi tsemenec teje’ tsabal, jaxtam i exlalits abal bel c’uajatchic ejate tin tamet a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ani lej jic’panchab in exobchixtal a Jesús c’al an inicchic taja’. ");
INSERT INTO husNT1971_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Taley tam ti an fariseochic in ats’a’ abal atanits an saduceochic yab in ejtou quin toc’tsiy a Jesús, tamna’ tamcun jaja’chic jaye. ");
INSERT INTO husNT1971_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ani jun axi pel i exobchix c’al an ts’ejcath cau in le’ quin tacchiquiy a Jesús. Jaxtam chich ani in conoy: ");
INSERT INTO husNT1971_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―¿Exobchix, jahua’ hualam an uchbixtalab axi más lej huinat exbath ti al an ts’ejcath cau binath c’al a Moisés? ");
INSERT INTO husNT1971_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Toc’tsin a Jesús: ―Ca lej jum putat c’anitha’ a Pay’lom Diosil c’al patal a ichich, ani c’al patal a ejattal, ani c’al patal a tsalapcua’. ");
INSERT INTO husNT1971_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Nan tu uchalchic abal ja’its an uchbixtalab axi más lej huinat exbath. ");
INSERT INTO husNT1971_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Huinat exbath jaye an uchbixtalab axi thuchath c’al a Moisés antse’: Ca c’anitha’ patal a at inic jant’ini’ ta c’anithal ta ba’cua’. ");
INSERT INTO husNT1971_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","C’al axe’ xi tsab i uchbixtalab c’uajat mac’uchithits tim patal an uchbixtalab ti al an ts’ejcath cau binath c’al a Moisés, ani jaye tim patal in exobchixtal am biyal caulomechic c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","C’uajate tamcuth an fariseochic. ");
INSERT INTO husNT1971_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Ani conoyabchic c’al a Jesús: ―¿Jant’o ta tsalpanchalchic in ey a Cristo? ¿C’al jita’ c’al tu tsacamlab? Toc’tsinchic: ―Pel in tsacamil a David. ");
INSERT INTO husNT1971_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Tam a Jesús in ucha’chic: ―Yab ja cum a David c’uajchith c’al an Espíritu Santo im bijiy a Cristo tin Ajatic. In ulu antse’: ");
INSERT INTO husNT1971_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","A Dios in ucha’ u Ajatic: Teje’ quit buxcan tu huinab c’ubac, ma nan tu pitha’its ta c’ubac a tomolnaxilchic abal ca tala’ ata’. ");
INSERT INTO husNT1971_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Cum antsana’ a David im bijiy a Cristo tin Ajatic, jaxtam i tso’obits abal yab pel in tsacamil a David. ");
INSERT INTO husNT1971_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","C’al nixe’ xi cau ni jita’ yab in ejtou quin toc’tsiy a Jesús. Ani ni jita’ taja’ yab in inicnal tim ba’ abal quin conomichiquiye a Jesús c’al más i cau. ");
INSERT INTO husNT1971_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Tam a Jesús tu ucha’ huahua’ tu exobalilchic ani an mulcunel antse’: ");
INSERT INTO husNT1971_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","―An fariseochic ani an exobchix c’al an ts’ejcath cau binath c’al a Moisés in cua’al in uchbilcua’ quin exobchi an ts’ejcath cau. ");
INSERT INTO husNT1971_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Patal jahua’ jaja’chic ti uchalchic tin cuenta an ts’ejcath cau, jats ca t’aja’. Expith yab ca t’aja’ jant’ini’ jaja’chic in t’ajal yab im putuhual c’al in exobchixtal, tocat exobchixq’ui. ");
INSERT INTO husNT1971_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ejtil i quitax ax in quitayal in at inic c’al i quitalab lej alchic, antsana’ jaja’chic in t’ajchal an inicchic c’al im punc’uth exobchixtal lej alchic axi yab ejtohuab ca quitna. Ani ni jayq’ui’ ni hue’ yab quitnax c’al in cuete’ exobchixtal. ");
INSERT INTO husNT1971_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Patal jahua’ in t’ajalchic expith abal max ca tsu’tat ti lej t’ocat. Im pulicmethamalits an tsacam balixtalab c’al an T’ocat Thuchlab ax in xe’tsinthal tim piq’uib ani tin ocob. U xe’etschic c’al in lej nacat coton abal max ca tsu’tat ti pulic in ey. ");
INSERT INTO husNT1971_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Tam ti hua’ats i ajib ts’alat c’apuxtalab in lej le’chic ca buxcan jun ti quetel axi lej c’athpich pulic in ey. Aniye jaye in le’ tam ti c’uajatchic ti al an tiyopan. ");
INSERT INTO husNT1971_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","In lej culbetnalchic ca tsapnetha ti bel c’al yan i c’ac’naxtalab ani ca uchan ti exobchix. ");
INSERT INTO husNT1971_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Yab ca le’na’ tata’chic quit uchan tit exobchix, cum pel it ebchalabchic ta ba’. Nana’its tin Cristo tin juncats Exobchix c’al tata’chic. ");
INSERT INTO husNT1971_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Yab ca ucha’ jita’ teje’ tsabal ta tata ti al an tiyopan, cum juncats i lej Tata axi c’uajat ti eb. ");
INSERT INTO husNT1971_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Yab ca ucha’ jita’ ti Ajatic, cum nana’ tin Cristo tin juncats Ajatic c’al tata’chic. ");
INSERT INTO husNT1971_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Jitats axi más tolmix c’al tata’chic, jats axi más pulic in ey c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Jitats quim puhuetha’ tim ba’ ne’ets ca tsa’ca, ani jitats quin tsa’ca’ tim ba’ ne’ets ca puhuethanchat in ey c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","It lej ts’ejhuantal tata’chic ax it exobchix c’al an ts’ejcath cau binath c’al a Moisés ani ax it fariseochic, cum it eb t’ocatq’ui expith. A t’apchal in tsalap an inicchic abal yab quin jilchi a Dios quin t’aja’ ti Ts’ale tin ichich. Tata’chic yab a jilchal a Dios quin t’aja’ ti Ts’ale ta ichich, ani a tanc’uiyal q’ue’atchic ax in le’ quin jilchi a Dios quin t’aja’ ti Ts’ale tin ichich. ");
INSERT INTO husNT1971_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","It lej ts’ejhuantal tata’chic ax it exobchix c’al an ts’ejcath cau binath c’al a Moisés ani ax it fariseo, cum it eb t’ocatq’ui expith. C’al a pojcaxtal a tixc’anchal i c’alab an tsemchith uxumchic, ani bel it lej ohuel tit ol expith abal max quit tsu’tat tit t’ocat. Jaxtam ne’ets quit c’athpich jolbiyat c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","It lej ts’ejhuantal tata’chic ax it exobchix c’al an ts’ejcath cau binath c’al a Moisés ani ax it fariseo, cum it eb t’ocatq’ui expith. It xe’ets tim puhuel an tsabal a lej alimichical max jita’ ca ts’at’ey c’al tata’chic. Tam ts’at’atits a lej c’athpich quithabmethanchal in ichich, ma in quithabtal lej c’athpich yab ejtil a quithabtal tata’chic. In ey im bajuhual ejtil an teneclab. ");
INSERT INTO husNT1971_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","It lej ts’ejhuantalchic cum a le’ ca t’aja’ tit oc’nom ani it joc’tsichic. A ulalchic abal yab chubax uchbith an inic quim putu c’al jahua’ quin ulu ne’ets quin t’aja’ max in cubal ti chubax an tiyopan. Expith uchbithcua’ quim putu max quin cuba’ ti chubax an oro axi ti al an tiyopan. ");
INSERT INTO husNT1971_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Tata’chic ojni’ lej macu’ a tsalap ani it joc’tsi. An oro yab ja axi lej exbath. An tiyopan jun ti c’uajat an oro jats ojni’ lej exbath. ");
INSERT INTO husNT1971_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","A ulalchic jaye abal yab chubax uchbith an inic quim putu c’al jahua’ quin ulu ne’ets quin t’aja’ max in cubal ti chubax an ts’acnaxtalab ti al an tiyopan. Expith uchbithcua’ quim putu max quin cuba’ ti chubax an ts’acchixtalab. ");
INSERT INTO husNT1971_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Tata’chic ojni’ lej macu’ a tsalap ani it joc’tsi. An ts’acchixtalab yab ja axi lej exbath. An ts’acnaxtalab jun tu binab an ts’acchixtalab jats ojni’ axi lej exbath. ");
INSERT INTO husNT1971_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Jitats in cubal ti chubax an ts’acnaxtalab, in mac’uchith cubal jaye an ts’acchixtalab. ");
INSERT INTO husNT1971_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ani jitats in cubal ti chubax an tiyopan, in mac’uchith cubal jaye a Dios ti chubax cum jaja’ u c’uajil taja’. ");
INSERT INTO husNT1971_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Jitats in cubal ti chubax an eb, in mac’uchith cubal jaye ti chubax in ts’alat lactemil a Dios ani jaye a Dios axi quetel taja’. ");
INSERT INTO husNT1971_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","It lej ts’ejhuantal tata’chic ax it exobchix c’al an ts’ejcath cau binath c’al a Moisés ani ax it fariseochic, cum it eb t’ocatq’ui expith. A pithal a Dios jun i elbenax c’al tin cuenta an lajuj ani antsana’ a t’ajal jaye c’al an anis ani c’al an comino, ani jahua’ más exbath c’al a Dios yab ja a t’ajalchic. Pel a lej uchbil quit xe’tsinchic bolith. Ca yajnanchi an inicchic ani ca lej bela’ a Dios. Ja’its axe’ axi más exbath an uchbixtalabchic c’al an ts’ejcath cau ca putu, ani yab expith ca pitha’ a Dios jun c’al an lajuj jahua’its a cua’al. ");
INSERT INTO husNT1971_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Tata’chic ojni’ a le’ ca t’aja’ tit oc’nom ani it joc’tsi. A t’ajal ti cuenta an uchbixtalab axi hue’ exbath ani yab a t’ajal ti cuenta axi más exbath. ");
INSERT INTO husNT1971_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","It lej ts’ejhuantal tata’chic ax it exobchix c’al an ts’ejcath cau binath c’al a Moisés ani ax it fariseochic, cum it eb t’ocatq’ui expith. It ejtil i uts’umtalab axi t’acathits eleb ani i talap axi expith t’acathits tin cux ani yab alta. Ta lej ichich hualim it jaylom ani hualim a t’ajal a cuete’ canat. ");
INSERT INTO husNT1971_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","It joc’tsichic, fariseo. Ca t’aca’ tin al an uts’umtalab abal ca jilc’on t’acathits ejtil tin elebtal, ani jaye alta an talab abal ca jilc’on t’acathits ejtil tin cux. ");
INSERT INTO husNT1971_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","It lej ts’ejhuantal tata’chic ax it exobchix c’al an ts’ejcath cau binath c’al a Moisés ani ax it fariseochic, cum it eb t’ocatq’ui expith. Ejtil it jolimtalab tsemelom ax in cua’al eblim i t’ujub lej thacni’bethach c’al i tay’. Eleb u tsu’tab alabel ani tin al hualim im beclac i tsemelom ani patal i c’atselomtalab. ");
INSERT INTO husNT1971_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Antsana’ tata’chic ta elebtal it tsu’tab tit t’ocat, ani ta lej ichich hualim it c’ambix ani hualim it jec’om c’al jahua’ in le’ a Dios ca t’aja’. ");
INSERT INTO husNT1971_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","It lej ts’ejhuantal tata’chic ax it exobchix c’al an ts’ejcath cau binath c’al a Moisés ani ax it fariseochic, cum it eb t’ocatq’ui expith. A ts’ejcanchal i jolimtalab jun ti ca joliyat axi pel i caulomechic c’al a Dios ani a c’uajbanchal i huits tin jolimtal am pututh inicchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","A ulalchic: Max u c’uajatachue ti lej jayq’ui’ tam ti xe’ets i biyal tatachic, yab i tsemthamalac in caulomejilchic a Dios jant’ini’ in t’ajamal jaja’chic. ");
INSERT INTO husNT1971_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Cum antsana’ a bijiyal ti tatalabchic, a tejhua’methal abal it juntalab c’al nixe axi tsemthomats ti biyal c’al axi pel i caulomechic c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Xo’ tata’chic a quithbanchal jahua’ a biyal tatachic in ts’i’quiyamal ti tsemthom. ");
INSERT INTO husNT1971_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Tata’chic ojni’ ejtil it tsan. Ni hue’ yab ne’ets ca jec’a’ yab quit yajchiquiyat ti al an tamtsemla. ");
INSERT INTO husNT1971_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Nan ne’ets tu abchiyechic i caulomechic ani i tsalpath inicchic ani i exobchix c’al in cahuintal a Dios. Ani tocat ne’ets ca tsemtha’ talchic jaja’, ani ma talchic ne’ets ca q’uet’ath tsemtha’ ti al i cruz. Ne’ets ca huithc’oy talchic jaja’ ta tiyopanil ani ne’ets ca quethmaychic talchic ti bichou ti bichou. ");
INSERT INTO husNT1971_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Jaxtam a Dios ne’ets ti mac’uchith jolbiychic c’al ax in tsemthamalits patal axi q’ue’atchic am pututh inicchic. Pel a mac’uchith hualab in huac’lath xits’al jaja’chic. Abal axi tsemtha ti biyal ani jaye in huac’lath xits’al a Zacarías in tsacamil a Berequias axi tata’chic ite a tsemthamal utat an ts’acnaxtalab tin cuenta an tiyopan, patal pel a mac’uchith hualab. ");
INSERT INTO husNT1971_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Lej chubax jahua’ nan tu uchalchic abal ax it xo’ c’uajat teje’ tsabal ne’ets quit jolbiyatte junax c’al patal nixe’ xi huac’lath xits’lab. ");
INSERT INTO husNT1971_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Tata’chic ojni’ ax it c’uajil ti Jerusalén it lej tsemthom c’al in caulomejilchic a Dios ani it lej cui’ix c’al i t’ujub c’al in abathualejilchic a Dios. Ejtil i pita’ ax in tamcuyal in tsacam t’am abal quin c’aniy tin alcam in ocob, antsana’ yan i calat nan u lej le’ac tu tamcuy ani tu c’aniy, ani tocat yab a le’acchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ca t’aja’chic ti cuenta abal lejat jolat ne’ets ca jilc’on a tiyopanil. ");
INSERT INTO husNT1971_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Nan tu uchalchic abal lej chubax yabats ne’ets tiquin tsu’u ma biyat tiquin olna’ antse’: Jaja’ jats axi tal abath c’al a Dios, ani jats axi qui puhuethanchi im bij. ");
INSERT INTO husNT1971_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Huahua’ tu exobalil a Jesús junax c’al jaja’ u calejits al am pulic tiyopan, ani i ts’i’quiy cu t’ilmats tin cuenta an tiyopan ani an atachic ax in cuenta an tiyopan. ");
INSERT INTO husNT1971_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Tam a Jesús tu ucha’chic: ―Xohue’ a tsu’talchic am pulic tiyopan ani an atachic ax in cuenta an tiyopan. Chubax nan tu uchalchic abal ne’ets ca tala’ pacluhuat c’al i inicchic, ma ni jun i t’ujub yab ne’ets ca jilc’on t’i’póx c’al in at t’ujub. ");
INSERT INTO husNT1971_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Tam u c’alechic huahua’ junax c’al a Jesús ti bolchal Olivos, ani taja’ u buxcan. Expith u c’uajat huahua’, ani i ucha’ a Jesús: ―I lej le’ abal tata’ tucu olchi jayq’ui’ ne’ets ca t’ajan jahua’ ti hui’i a ulumal. ¿Jant’o tam tsu’bixtalab qui aychi abal qui exla’ max thubat ne’ets ca taley an q’uij q’uicha? ");
INSERT INTO husNT1971_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Toc’tsin a Jesús: ―Ca lej t’aja’chic ti cuenta abal ni jita’ yab ti c’ambiy. ");
INSERT INTO husNT1971_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Cum ne’ets ca chich yan i inic ti timc’ox c’al nana’. Ne’ets quin ulu abal jaja’chic pel a Cristo axi abnenec c’al a Dios, ani antsana’ ne’ets quin c’ambiy yantalam i inicchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ne’ets quit t’ilchin i pejextalab axi yan u thayc’anal ani más axi taye talac. Ani antsana’ bijithits ne’ets ca thayc’an. Bel yab quit jiq’ueychic, cum yabaye ne’ets ca thubat taley an q’uij q’uicha. ");
INSERT INTO husNT1971_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","I pulic bichoulom ne’ets ca pejéxin c’al pil i pulic bichoulom. An ts’alechic ne’ets ca tomolnáxin jun c’al xi jun. Ne’ets ca hua’tsin yan i jayil ani yan i yau’lats. Abal ju’tamq’ui ne’ets ca lej t’elelats an tsabal. ");
INSERT INTO husNT1971_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ani patal axe’ jats expith in ts’i’quintal an yajchictalab axi más taye tal. ");
INSERT INTO husNT1971_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Ani tata’chic ne’ets quit bina tin c’ubac an inicchic quit othna, ma talchic ne’ets quit tsemtha. Jat’hua’ tim patal an inicchic ne’ets ti at’a’ c’al tin ebal nana’ u bij. ");
INSERT INTO husNT1971_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Jaxtam yantalam ne’ets ca t’apchin in tsalap ani yabats tiquin ts’at’enchi. Ne’ets ca at’áxin jun c’al xi jun ani ne’ets ca jolbíxin tin tamet an oc’lecchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ne’ets ca chich yan i q’uet’ach caulome c’al ca c’ambiyat yantalam i inic. ");
INSERT INTO husNT1971_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Tin ebal an yanethach hualabtalab, jaxtam yan i inicchic yabats ne’ets ca c’anithaxin. ");
INSERT INTO husNT1971_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Expith c’al in t’ayath cuxuthtal ne’ets ca jalunthachic an inic ma ca taleyits an q’uij q’uicha. ");
INSERT INTO husNT1971_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ani tim puhuel an tsabal ne’ets ca olna an alhua’ cau jant’ini’ tin t’ajal a Dios ti Ts’ale, abal patal an inicchic quin ats’anchi. Ma talbelaquits ne’ets ca taley an q’uij q’uicha. ");
INSERT INTO husNT1971_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","16","Ca alhua’ ejtiyat c’al jitats quin ajiy axi más i cau tu olchi huahua’ a Jesús antse’: Ti biyalits an caulome c’al a Dios Daniel in q’uejab thucha’ abal ne’ets ca c’uajba ti al an t’ocat tiyopan jant’o lej c’ac’ath ani q’uibethom. Tam tata’chic ca tsu’u antsana’ c’uajbathits, tamna’ ax it c’uajatchic teje’ ti bichoulom Judea quit thubat pit’c’on quit c’ale ti al an ts’en. ");
INSERT INTO husNT1971_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Tam quim bajuhuits nixe’ xa q’uicha, jitats c’uajat tin hualq’ui’lal in q’uima’ ca thubat pa’iy, ani ma yabats ca otsits alta quin calthaye jant’o. ");
INSERT INTO husNT1971_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Jitats c’uajat tin t’ayablabil, ma yabats ca huichiy tin q’uima’ quin calthaye in toltomil. ");
INSERT INTO husNT1971_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Lej ts’ejhuantal ne’ets ca c’uajiy an uxum axi co’oth c’al i tsacam ani an uxum axi chuchuthome c’al i tsacam tam quim baju nixe’ xa q’uicha. ");
INSERT INTO husNT1971_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Quin conchichic a Dios abal yab quim baju ca pit’c’on ti al an tsamay q’uij ni ti al an sábado. ");
INSERT INTO husNT1971_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ma tam ti tamna’its a Dios ne’ets quin abchi an inicchic i c’athpich yajchictalab axi ni jayq’ui’ yab in abchamal, ani ni jayq’ui’ talbel yab ne’ets quin abchi ejtil nixe’ lej huat’ath c’athpich an yajchictalab. ");
INSERT INTO husNT1971_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Max a Dios yab quin t’apiy nixe’ xa q’uij q’uicha lej c’athpich yajchictalab, ni jita’ tam inic yab ne’ets quin cuxuy ni ohuat hue’. Cum a Dios lej c’anithom c’al ax in tacuyamalits, jaxtam ne’ets quin t’apiy tin ebal jaja’chic. ");
INSERT INTO husNT1971_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Ne’ets ca xe’tsin i inicchic quin ulu teje’ c’uajatits a Cristo ani jun ne’ets quin ulu tihua’ c’uajatits a Cristo. Yab ca belchi ja. ");
INSERT INTO husNT1971_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ne’ets ca chich i c’ambixchic tiquin timc’oy nana’ ani talchic i inic ne’ets quin timc’oy i caulome c’al a Dios. Ma ne’ets quin t’aja’chic jaye i pulic labith t’ajbilab ti tsu’bixtalab, max quin ejtou antsana’ quin c’ambiy axi tacuthits tin c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","C’al axe’ xi cau nan tu q’uejab olchamalits tata’chic jahua’ yabaye t’ajnenequits. ");
INSERT INTO husNT1971_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Jaxtam yab quit c’alechic ti al i joltam max jita’ ti ucha’ tihua’ in c’uajat, ani yab ca belchi max jita’ ti ucha’ tihua’ in c’uajat al jun i ata. ");
INSERT INTO husNT1971_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","An ley tam u leyts’om u tsu’tab ma ti calel q’uicha ani ma ti otsel q’uicha, ani nana’ tin Juntal patal an inicchic ne’ets quin lej tsu’tat tam quin chich junil. ");
INSERT INTO husNT1971_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ju’tamits tu c’uajat i tsemelom t’u’lec, tats ne’ets ca tamcun an t’otchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Ca taleyits nixe’ xa q’uichachic lej huat’ath c’athpich yajchictalab, tam ne’ets ca yic’utsin a q’uicha ani a its’ yab ne’ets quim bina’ in tajax. Ne’ets ca lej tsapic t’elelats an eb, ma ne’ets jololol a otchic abal ju’tamq’ui. ");
INSERT INTO husNT1971_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Tam tim patal an inicchic ne’ets quin tsu’u i tsu’bixtalab ti eb abal nana’its tin Juntal patal an inicchic in talits al i tocoulom. Tam ne’ets cu tejhua’metha’ u lej tsap ani u lej ts’alat, ani patal an inicchic tim puhuel an tsabal ne’ets ca uq’uin tam tiquin tsu’u in tal nana’its tin Juntal patal an inicchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Tam ca ats’atme tsapic juchuyabits an trompeta, tam nan ne’ets cu aba’ i ángelchic tiquin tamcunchi an inicchic axi nan u tacuyamalits tu c’al. Ne’ets ti tamcunchixchic tim puhuel an tsabal. ");
INSERT INTO husNT1971_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Ca ats’a’chic jun i jalpith cau c’al an te’ higuera. Tam ti it in c’ue’elchic ani u puthnalits in xequel, tam a exlalits abal hue’its ne’ets quim baju an c’ac’al q’uij. ");
INSERT INTO husNT1971_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Antsana’ tam tata’chic ca tsu’uhuits u t’ajnal patal axe’ jahua’ nan tu uchamalits ne’ets ca t’ajan, tam ca exla’its abal hue’its nana’ ne’ets quin chich junil. ");
INSERT INTO husNT1971_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Lej chubax nan tu uchalchic abal yab ne’ets ca taley a juntalchic, ma oc’ox ca t’ajanits patal jahua’ axe’ nan tu olchamalchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","An eb ani an tsabal jats ne’ets ca taley, expith nan u cahuintal ojni’ jats ni jayq’ui’ yab ne’ets ca taley. Ets’ey ne’ets ca putun. ");
INSERT INTO husNT1971_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Ni jita’ tam inic yab in tso’bim am pejath q’uicha ni am pejath hora tam antsana’ ne’ets ca t’ajan. Ma an ángelchic ti eb ani ma nana’its tin Tsacamil a Dios yab i tso’bim. Expith in tso’bim u Tata ti eb. ");
INSERT INTO husNT1971_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Jant’ini’ in xe’tsintal an inicchic tam ti lej biyalits xe’tsin a Noé, antsana’ ne’ets quim baju tam utataquits nana’ tin Juntal patal an inicchic ne’ets quin chich junil. ");
INSERT INTO husNT1971_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Tam ti yabaye che’nec an uq’ueltalab c’al am pulic ab, xe’etsac jaja’chic ti c’apupulq’ui ani ti tomquinalq’ui, ma tam tin lej bajuhuits an q’uicha tam ti a Noé otsitsits ti al am pulic tan ata. ");
INSERT INTO husNT1971_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Yab in tso’obnamalchic an hora tam ne’etsac ca ulits am pulic ab, ma ulitsits ani tala’ uc’tsin tim patal c’al an lej pulic ab. Antsana’ jaye yab ne’ets quin tso’obna’ an inicchic an hora tam nana’ tin Juntal patal an inicchic quin chich. ");
INSERT INTO husNT1971_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Max c’uajat tsab i inic ti junax t’ojnal tin tsabalil, ne’ets cu ne’tha’ jun ani jun ne’ets ca jilc’on. ");
INSERT INTO husNT1971_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Max tsab i uxum c’uajat ti junax tse’el c’oye, ne’ets cu ne’tha’ jun ani jun ne’ets ca jilc’on. ");
INSERT INTO husNT1971_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Cum yab a tso’bimchic an hora tam nana’ tin Ajatic quin chich junil, jaxtam ca junini’ ne’tha’ ts’ejcacathits a ichich tiquim bats’u. ");
INSERT INTO husNT1971_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ca t’aja’ ti cuenta jun i thabal ata axi otsanchat in q’uima’ ani cue’chinenec. Max in tso’obnamalac jahua’ tam hora ne’etsac ca chich an cue’, yab huayamathac ani yab cue’chinenecac. ");
INSERT INTO husNT1971_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Tata’chic quit junini’ c’uajiy t’ojojothits, cum nana’ tin Juntal patal an inicchic ne’ets quin chi’pin lej jun athic tam yab a t’ilt’om. ");
INSERT INTO husNT1971_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","An t’ojnal axi pututh ani tsalpath jats axi ne’ets ca punuhuat ti abatnanchix c’al xi q’ue’at in t’ojnalil an amulab, ma quin ulu jahua’ tam hora ca pijchinchat. ");
INSERT INTO husNT1971_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Tam ca chich in amu, tam ne’ets ca lej culbe nixe’ xi abatnanchix max im putuhual c’al in uchbil. ");
INSERT INTO husNT1971_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Lej chubax nan tu uchalchic abal jats jaja’ axi ne’ets ca punuhuat ti ts’ale abatnanchix c’al patal jahua’ in cua’al in amu. ");
INSERT INTO husNT1971_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ani max yab pututh ne’ets quin tsalpay abal in amu ne’ets ca ohuey abal ca chich. ");
INSERT INTO husNT1971_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Hualam tocat ne’ets quin othna’ ax in abatnalchic. Tocat ca xe’tsin c’apupulq’ui ani ca uts’alin c’al in ja’ubchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Antsana’ ne’ets ca elchin c’al in amu tam ca chi’pin jun athic tam yab u aychab. ");
INSERT INTO husNT1971_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Jaxtam ne’ets ca c’athpich yajchiquiyat. Ne’ets ca huat’ba ca c’uajiy jolbibith junax c’al axi eb pututh expith. Taja’ ne’ets ca uq’uin ani ne’ets ca huech’ech’lats in camab c’al an yajchictalab lej yajchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ne’ets tu olchiyechic jant’ini’ quit c’uajiy ts’ejcacath quit otsits jun tin t’ajal a Dios ti Ts’ale. Lajuj i ts’ic’ach ne’etsits ti bel in ne’thalchic ti junchic i tajablab cum ne’ets quin tamu i tomquinel inic. ");
INSERT INTO husNT1971_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Bo’ jaja’chic tsalpath ani bo’ axi yab tsalpath. ");
INSERT INTO husNT1971_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Axi yab tsalpathchic in ne’thal i tajablab ani yab in ne’thal i gas abal quin jolchi tam ca taley ax in cua’alits. ");
INSERT INTO husNT1971_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Axi tsalpathchic in ne’thal i tajablab ani jaye i gas al i limete. ");
INSERT INTO husNT1971_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Cum yab thubat chich an tomquinel inic, jaxtam ts’ebc’analchic an ts’ic’ach ani talbel huayits. ");
INSERT INTO husNT1971_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ma ts’ejel acal in ats’alchic jun i tsapic cau antse’: Tax talits an tomquinel inic. Quit c’alechic ca tamucua’. ");
INSERT INTO husNT1971_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Tam ejtsinchic an ts’ic’ach ani in thubat ts’ejcachical in tajablabilchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Tam axi bo’ yab tsalpath in ucha’ axi bo’ tsalpath: Tucu pitha’ hue’ i gas, cum teptsitsilits i tajablabil. ");
INSERT INTO husNT1971_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Toc’tsin axi tsalpathchic: Iba, cum hualam ne’ets qui q’uibchiyehue max tu pitha’. Quit c’ale jun tu nujuhuab an gas ani ca ts’a’iy a cuete’ c’alcua’. ");
INSERT INTO husNT1971_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ani tam ti ne’etschic quin ts’a’iy an gas, tamna’its biyat chich an tomquinel inic. Ani axi bo’ tsalpathchic jats axi otsits c’al jaja’ jun tu t’ajnal an tomquintalab ajib. Tam mapuyat an hui’leb. ");
INSERT INTO husNT1971_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Talbel ulits axi bo’ yab tsalpath ani in lej uluchic: Pay’lom, tucu japchi an hui’leb. ");
INSERT INTO husNT1971_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Toc’tsiyatchic: Lej chubax tu uchal abal nan yab tu exlal. ");
INSERT INTO husNT1971_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Tam a Jesús tu ucha’ huahua’: Cum yab a tso’obchic jayq’ui’ nana’ tin Juntal patal an inicchic ne’ets quin chich, jaxtam quit ets’ey c’uajiy ts’ejcacath tiquim bats’u. Yab a tso’obchic jahua’ tam q’uicha ni jahua’ tam hora ne’ets quin chich. ");
INSERT INTO husNT1971_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","In uluye a Jesús: Ne’ets tu olchiyechic jant’ini’ tin t’ajal a Dios ti Ts’ale. Cum jun i amu ne’ets ca c’ale ti al pil i bichou, in caniy ca chich in t’ojonchixalchic ca jilchin in tumin quin t’ojonthanchi. ");
INSERT INTO husNT1971_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Im pitha’ jun bo’ mil i tumin, ani axi jun tsab mil, ani axi jun mil. Im pitha’ ti junchic jant’inits in huit’omtal quin eyentha’. Tam c’alets an amu. ");
INSERT INTO husNT1971_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","An t’ojonchix ax im bats’u bo’ mil in alhua’ t’ojonthanchi an tumin, ma in atanchiye bo’ mil más. ");
INSERT INTO husNT1971_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ax im bats’u tsab mil in atanchiye tsab mil. ");
INSERT INTO husNT1971_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ax in bats’u mil, tocat c’ale in tsinat joliy an tumin tsabal. ");
INSERT INTO husNT1971_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Tam ti huat’enequits yan a q’uicha, tam huichiy an amu quin ts’ejca’ an cuenta c’al an t’ojonchixchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Oc’ox ulits c’al an amu ax im bats’u bo’ mil i tumin. In chi’thal jaye axi bo’ mil más in atanchamal. In ucha’: Pay’lom, te c’uajat am bo’ mil ax tin jilchi ani jaye bo’ mil ax u atanchamal. ");
INSERT INTO husNT1971_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Tam uchan c’al an amu: Lej chubax it alhua’ ani it pututh t’ojonchix. Cum tin alhua’ t’ojonthanchamal an hue’ ax tu jilchi, ne’ets tu pithaye más a uchbil. Quit otsits te c’al nana’ ani cu junax culbe abal ets’ey. ");
INSERT INTO husNT1971_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Talbel ulits c’al an amu an t’ojonchix ax im bats’u tsab mil i tumin. In ucha’ in amu: Pay’lom, te c’uajat an tsab mil ax tin jilchi ani jaye tsab mil ax u atanchamal. ");
INSERT INTO husNT1971_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Uchan c’al in amu: Lej chubax it alhua’ ani it pututh t’ojonchix. Cum tin alhua’ t’ojonthanchamal an hue’ ax tu jilchi, ne’ets tu pithaye más a uchbil. Quit otsits te c’al nana’ ani cu junax culbe abal ets’ey. ");
INSERT INTO husNT1971_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ulits jaye axi jilchin mil i tumin ani in ucha’ in amu: Pay’lom, nan u exlal abal it lej pathay. Ejtil max a c’ojohual jun ti yab a t’ayamal ani ejtil max a yac’ual an hualilab jun ti yab a t’ayamal. ");
INSERT INTO husNT1971_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Jaxtam in jiq’uey ani u tsinat joliy a tuminal tsabal. Te tu huichbanchal a tuminal. ");
INSERT INTO husNT1971_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Toc’tsin an amu: Tata’ ojni’ it pojcax t’ojonchix ani it obe. U c’ojohual jun ti yab u t’ayamal ani u yac’ual an hualilab jun ti yab u t’ayamalcua’. ");
INSERT INTO husNT1971_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Alhua’ max anac tim binanchamal u tuminal c’al q’ue’at i inic abal jaja’ tiquin t’ojonthanchi, ani antsana’ u bats’unchalac jahua’ tin atanchamalac c’al u tuminal xo’ tin che’nec. ");
INSERT INTO husNT1971_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Tam an amu in ucha’ axi c’uajatchic taja’: Ca tixc’anchi axe’ xi inic an mil tumin ani ca huat’banchi ax tin chanchi axi lajuj mil i tumin. ");
INSERT INTO husNT1971_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Jitats quin alhua’ t’ojonthanchi jahua’ u jilchamal, jats axi ne’ets cu jilchiye más, ani jitats yab quin alhua’ t’ojonthanchi, ne’ets ca tixc’anchat axi hue’ u jilchamal. ");
INSERT INTO husNT1971_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ca jolohuat eleb ti al an yic’uax axe’ xi t’ojonchix cum yab jant’o ti alhua’. Taja’ ca uq’uin ani ca huech’ech’lats in camab c’al an yajchictalab lej yajchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Nana’ tin Juntal patal an inicchic ne’ets quin chich junil junax c’al patal an ángelchic cu tejhua’metha’ u lej ts’alat. Ne’ets quim buxcan tu ts’alat lactemil cu t’aja’ tin lej Ts’ale teje’ tsabal. ");
INSERT INTO husNT1971_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ne’ets cu caniy ca chich tu tamet patal an inicchic tim patal am pactha’ bichoulom axi tim puhuel an tsabal. Ne’ets cu pilmetha’chic jant’ini’ am beletnom co’nel im pilmethal an ovejachic ani an chivachic. ");
INSERT INTO husNT1971_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ne’ets cu c’uajba’ axi ejtil an ovejachic tu huinab ani axi ejtil an chivachic tu c’uatab. ");
INSERT INTO husNT1971_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Tam nana’ tin Ts’ale ne’ets cu ucha’ axi c’uajat tu huinab: Cum it lablinchithitschic c’al u Tata, quit c’uajiy c’al nana’. Ca t’aja’chic tit ts’ale jaye, cum jats tit bijithits ma tam ti biyal ts’ejcanenec an eb ani an tsabal c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Cum tam tin xe’tsin c’al i jayil, tata’chic tim pijchi. Tam tin xe’tsin c’al i chiquen, tata’chic tim pitha’ an ja’ cu uts’a’. Tam tin talac ou, tata’chic tim bats’u ta q’uima. ");
INSERT INTO husNT1971_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Tam tin xe’tsin c’ot’ith, tata’chic tin ts’ejhualiy c’al i toltom. Tam tin ya’ulac, tin tsa’biy. Tam tin c’uajatac ti al an huic’axte’, it chichchic tiquin tsu’u. Antsana’ ne’ets cu ucha’chic. ");
INSERT INTO husNT1971_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Tam axi bolithchic in ichich ne’ets tiquin toc’tsiy: ¿Ajatic, jayq’ui’ huahua’ tu tsu’u it c’a’il, ani tu pijchi? ¿Jayq’ui’ tu tsu’u it chiquel, ani tu pitha’ an ja’ ca uts’a’? ");
INSERT INTO husNT1971_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Jayq’ui’ tu tsu’u it talac ou, ani tu bats’u ti q’uima’? ¿Jayq’ui’ tu tsu’u tit c’ot’ith, ani tu ts’ejhualiy c’al i toltom? ");
INSERT INTO husNT1971_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Jayq’ui’ u c’ale huahua’ tu tsa’biy tam tit ya’ul, ani tam it c’uajatac ti huic’axte’? ");
INSERT INTO husNT1971_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Tam nana’ tin Ts’ale ne’ets cu toc’tsiychic: Lej chubax nan tu uchalchic, cum antsana’ a t’ajchamal u juntalchic, jaye tin mac’uchith t’ajchamalne. Ma a t’ajchamal axi lej huecats in exbath. ");
INSERT INTO husNT1971_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Tam nana’ tin Ts’ale ne’ets cu ucha’chic axi c’uajat tu c’uatab: Cum it t’ajat q’uibenecchic c’al a Dios, quit tixc’an c’al nana’ ani quit c’ale ti al am pulic c’amal abal ets’ey. Jats an c’amal axi ts’ejcathits jun ti ca c’uajiy an oc’ox teneclab ani in juntalchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Tam tin xe’tsin c’al i jayil, tata’chic yab tim pijchi. Tam tin xe’tsin c’al i chiquen, yab jant’o tim pitha’ an ja’ cu uts’a’. ");
INSERT INTO husNT1971_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Tam tin talac ou, yab tim bats’u ta q’uima’. Tam tin xe’tsin c’ot’ith, yab tin ts’ejhualiy c’al i toltom. Yab tin tsa’biy tam tin ya’ulac ani tam tin c’uajatac ti huic’axte’. ");
INSERT INTO husNT1971_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Tam jaja’chic ne’ets tiquin toc’tsiy: ¿Ajatic, jayq’ui’ tu tsu’u tit c’a’il, ani tit chiquel, ani tit talac ou, ani tit c’ot’ith, ani tit ya’ul, ani tit c’uajatac ti huic’axte’ ani yab tu yajnanchi? ");
INSERT INTO husNT1971_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Tam nana’ tin Ts’ale ne’ets cu ucha’chic: Lej chubax nan tu uchalchic, cum yab a yajnanchi u juntalchic, yab tin mac’uchith yajnanchamalne. Ma yab a yajnanchi ni axi lej huecats in exbath. Antsana’ ne’ets cu ucha’chic. ");
INSERT INTO husNT1971_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Jats jaja’chic axi ne’ets ca aban ca c’ale ca yajchiquiyat abal ets’ey. Axi bolithchic in ichich jats axi ne’ets ca c’uajiy it ejatlith abal ets’ey c’al a Dios, in ulu a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Tam ti talits antsana’ quin ulu a Jesús patal nixe’ xi cau, tu uchaye huahua’ tu exobalilchic: ");
INSERT INTO husNT1971_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―A tso’obits abal ti tsab a q’uicha an Israelchic ne’ets quin t’aja’ an ajib tin cuenta abal ti calthame im biyal juntalchic ti Egipto. Nana’ tin Juntal patal an inicchic ne’ets quim bina tin c’ubac jaja’chic abal quin tsemtha q’uet’ath al an cruz. ");
INSERT INTO husNT1971_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Tam tamcunchic an oc’lec pale’ ani an exobchix c’al an ts’ejcath cau binath c’al a Moisés ani an yejtselabchic Israel tin elebil tin q’uima’ an ts’ale pale’ Caifás. ");
INSERT INTO husNT1971_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","In juncuhualchic an cau jant’ini’ ti quin c’ambiy ani quin yac’ua’ a Jesús, cum in le’ quin tsemtha’. ");
INSERT INTO husNT1971_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","In uluchic: ―Yab qui yac’ua’ tam ajib abal i ca thayc’an i xacueltalab al am bichou. ");
INSERT INTO husNT1971_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","C’uajat a Jesús ti Betania tin q’uima’ a Simón ax in cua’alac an t’it’ axi c’apux c’al in anam t’u’ul. ");
INSERT INTO husNT1971_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ani ulits taja’ jun i uxum in chal i frasco ts’ejcath c’al i t’ujub im bij alabastro. T’uchat an frasco c’al i nihuihuiltalab lej jalbith. In jolchi tin oc’ a Jesús jun ti quetel ba’ an mexa. ");
INSERT INTO husNT1971_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ani huahua’ tu exobalil a Jesús u tsacul, cum i tsu’u jant’o in t’ajamal an uxum. I ulu: ―¿Jale’ ti huac’la an nihuihuiltalab antse’? ");
INSERT INTO husNT1971_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ejtohuamejac ca nujuhuat jalbith ani an tumin pithnenecac an ts’ejhuantalchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","A Jesús in ats’a’ jant’o i ulu ani tu ucha’chic: ―Yab ca c’uiya’chic axe’ xi uxum, cum lej alhua’ jahua’ tin t’ajchamal. ");
INSERT INTO husNT1971_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ets’ey ne’ets ca c’uajiy i ts’ejhuantalchic c’al tata’chic, ani nana’ expith jun i hue’ in c’uajat c’al tata’chic. ");
INSERT INTO husNT1971_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Aba ani’ yabaye in tsemenec, bel tin jolchi an nihuihuiltalab ejtil max tin q’uejab t’ojojonchalits u inictal tam ne’ets quin joliyat. ");
INSERT INTO husNT1971_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Lej chubax nan tu uchalchic abal ju’tamq’ui ca olnanchat an inicchic an alhua’ cau tim puhuel an tsabal, taja’ ca t’iloxnanchat jaye in t’ajbil axe’ xi uxum. ");
INSERT INTO husNT1971_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Taley jun axi lajuj tsab c’al huahua’ tu exobalilchic a Jesús, c’ale quin tsu’u an oc’lec pale’chic abal quin tauna’. Pel a Judas Iscariote. ");
INSERT INTO husNT1971_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","In conoyal: ―¿Jay i tumin tim pithal max cu tsinat bina’ ta c’ubac a Jesús? Tam pithan ox i lajuj i tumin plata. ");
INSERT INTO husNT1971_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ma tam ti tamits in lej alimichical a Judas jant’ini’ ti quin tsinat bina’ a Jesús tin c’ubac in tomolnaxilchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Im bajuhuits an c’a’al q’uicha an ajib tin cuenta am bichou Israel ti calthame ti Egipto ti biyal. Tamits u c’apab am pan axi yab ts’ejcath c’al i c’ac’chixtalab c’oye. Huahua’ tu exobalilchic a Jesús u ulits c’al jaja’ ani i conoy: ―¿Ju’tam a le’ qui t’ojojoy abal cu c’aputs tin cuenta in ajib am bichou Israel tam ti calthame ti Egipto ti biyal? ");
INSERT INTO husNT1971_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Toc’tsin a Jesús: ―Quit c’alechic nihua’ ti bichou Jerusalén tin q’uima’ jun i inic axi bijithits. Ca ucha’ antse’: An Exobchix Jesús ti abchal an cau abal hue’its ne’ets quim baju in horajil tam ne’ets ca tsemtha. Ta q’uima’cua jaja’ ani huahua’ tu exobalil ne’ets qui t’aja’ an ajib tin cuenta ti calthame ti Egipto am biyal bichou Israel. ");
INSERT INTO husNT1971_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Tam u c’ale huahua’ i t’ojojoy patal jant’ini’ tu uchame c’al a Jesús tin cuenta an c’apuxtalab ajib. ");
INSERT INTO husNT1971_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ani aclejits tam tu quetelits huahua’ lajuj tsab tu exobal junax c’al a Jesús ba’ an mexa. ");
INSERT INTO husNT1971_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Tam tu c’apulitschic, a Jesús tu ucha’: ―Lej chubax nan tu uchalchic abal jun axi c’al tata’chic ne’ets tiquin tsinat bina’ tin c’ubac u tomolnaxilchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Tam ojni’ u t’e’pinal huahua’, ani i conoyal a Jesús ti junchictal: ―¿Hualamac xe’ max nana’ ja’its, Ajatic? ");
INSERT INTO husNT1971_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","A Jesús tu toc’tsiychic: ―Ax u lej c’apul c’al nana’ u talabil, jats axi ne’ets tiquin tsinat bina’. ");
INSERT INTO husNT1971_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Quim bina nana’ ani quin tsemtha, cum nana’ tin Juntal patal an inicchic antsana’ im bijchithits ti al an T’ocat Thuchlab. Tocat lej c’athpich ts’ejhuantal nixe’ xi inic axi ne’ets tiquin tsinat bina’, cum ne’ets ca lej yajchiquiyat. Alhua’ max lejatac yab hua’tsinenec. ");
INSERT INTO husNT1971_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Tam conoyab a Jesús c’al a Judas axi c’al ti ne’ets ca tsinat bina: ―¿Hualamac xe’ max nana’ ja’its, Exobchix? Toc’tsin a Jesús: ―Tata’ ojni’ ja’its. ");
INSERT INTO husNT1971_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Biyat huahua’ u c’apule, a Jesús im pena’ am pan ani im bina’ i c’ac’namal yan c’al a Dios. Tam in mu’u am pan ani tu pitha’, ani tu ucha’: ―Ca c’apuchic axe’ u anam t’u’ul. ");
INSERT INTO husNT1971_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Tam im pena’ an uts’umtalab c’al an vino ani im bina’ i c’ac’namal yan c’al a Dios. Tam tu huat’banchi huahua’ ani tu ucha’: ―Patal tata’chic ca uts’a’. ");
INSERT INTO husNT1971_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Axe’ pel u xits’al axi hue’its ne’ets quin huac’lanchat ti al an cruz abal yantalam i inicchic ca paculanchat in hualab. C’al tin ebal u huac’lath xits’al a Dios ne’ets quin ts’ejca’ i it jilchith cau c’al an inicchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nan tu uchalchic abal yabats ne’ets cu uts’a’ an vino lab t’uthub c’al tata’chic ejtil u t’ajal xo’. Ma tihua’ talbelaquits tam u Tata ti eb quin t’aja’ ti lej Ts’ale, tam tiq’uele ne’ets cu uts’a’ junil. ");
INSERT INTO husNT1971_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Taley i ajatnanchi im bij a Dios, ani tam u c’alechic ti bolchal Olivos. ");
INSERT INTO husNT1971_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Taja’ a Jesús tu ucha’chic: ―Patal tata’chic tin ebal u tsemtal ne’ets quit t’apchin a tsalap axe’ xi acal. In olnab nana’ ti al an T’ocat Thuchlab jant’o ne’ets quin t’ajchin c’al a Dios antse’: Nan ne’ets cu tsemtha’ am beletnom oveja, ani ne’ets ca buc’uhuat tam an ovejachic, in ulu a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Talbel tam quin ejthajits, ne’ets quin oc’chith c’ale ti Galilea, ani tata’chicte quit c’ale talbel. ");
INSERT INTO husNT1971_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Tam uchan a Jesús c’al a Pedro: ―Aba ma patal an ts’at’el ca t’apchin in tsalap yab ti ts’at’enchi, nan ojni’ ne’ets tu junini’ ts’at’enchi. ");
INSERT INTO husNT1971_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Toc’tsin a Jesús: ―Lej chubax nan tu uchal abal axe’ xi acal tata’ ne’ets ca tsinca’ ta ba’ c’al nana’ oxil i calat ma tam ti ibaque thajnenec an coxol. ");
INSERT INTO husNT1971_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Bel a Pedro in lej ucha’ a Jesús: ―Aba ma quin le’nane quin tsemtha junax c’al tata’, nan yab ne’ets cu tsinca’ tu ba’. Tam patal huahua’ tu exobal i ulu jayetseq’ui jant’ini’ in ulu a Pedro. ");
INSERT INTO husNT1971_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Taley u ulits huahua’ junax c’al a Jesús al jun i tsabal im bij Getsemaní. Taja’ a Jesús tu ucha’chic: ―Quit jilc’onchic teje’, biyat nan ne’ets quin c’ale hue’ nihua’ quin olon. ");
INSERT INTO husNT1971_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","In ne’tha’ ca c’ale jaye a Pedro ani axi tsab in tsacamil a Zebedeo. Ani lej huat’ath c’athpich t’e’pith in ichich a Jesús, ma lej c’olothits tin inictal in ats’al. ");
INSERT INTO husNT1971_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Jaxtam in ucha’chic: ―U ats’al ejtil max u lej tse’eyab u ichich c’al i c’athpich t’e’pithtalab, ma ejtil ne’ets quin tsemetsits. Tata’chic quit jilc’on teje’ ani yab quit huayits. ");
INSERT INTO husNT1971_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Tam nixq’uin a Jesús hue’ nihua’, ani t’ajat pac’lun tsabal ca olon. In ulu: ―Tata, max ejtohuabac tiquin jaluntha’ abal yab cu yajchicna’ an yajchictalab axi taye tal. Max i, bel u le’ tu t’ajchi a culbetal ani yab u cuete’ culbetal. ");
INSERT INTO husNT1971_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Tam huichiy a Jesús jun ti c’uajat axi ox i juntal exobal, ani in tsu’u tocat huayamathchic. Tam in ucha’ a Pedro: ―¿Jale’ yab a ejtouchic quit c’uajiy yab quit huayits ma ni jun i hora, quit olon ejtil nana’? ");
INSERT INTO husNT1971_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ca junini’ ne’tha’chic ts’ejcacath a ichich quit olon abal yab ti ata’ an teneclab. Lej chubax lej canat a ichich ca olon c’al nana’, tocat a anam t’u’ul jats yab u lej tsapnel. ");
INSERT INTO husNT1971_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Tam tsab c’ale junil a Jesús ca olon. In ulu: ―Tata, max yab ejtohuab tiquin jaluntha’ yab cu yajchicna’ an yajchictalab axi taye tal, bel cu t’ajchi a culbetal. ");
INSERT INTO husNT1971_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Huichiy junil c’al axi ox i juntal, ani in tsu’u tocat huayamath junil cum atanits c’al i ts’ebattalab. ");
INSERT INTO husNT1971_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Tam in jila’chic taja’ ani jaja’ c’ale ca olon junil. Pel i oxchilab calat. ");
INSERT INTO husNT1971_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Tam huichiy junil jun ti c’uajat axi ox i juntal, ani in ucha’chic: ―Xohue’ alhua’ max anac quit hue’ huayitschic ani quit hue’ coyots, tocat yab in tomnal ani’, cum im bajuhuits an hora nana’ tin Juntal patal an inicchic ne’ets quin tsinat bina tin c’ubac i hualbith inicchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Xo’ quit ts’aquiychic ani huana. Tax talits jaja’ axi ne’ets tiquin tsinat bina’ tin c’ubac u tomolnaxilchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Exome ti cau a Jesús tam ti ulits a Judas axi ajith c’al huahua’ lajuj tsab tu exobalil a Jesús. Ulits junax c’al jaja’ yan i inicchic ts’ejcachic c’al i matset ani c’al i te’chic. Abnenec jaja’chic ti yac’ual c’al a Jesús c’al an oc’lec pale’chic ani c’al an yejtselabchic Israel. ");
INSERT INTO husNT1971_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","A Judas in olchi an t’ipchixtalab an yac’ualchic antse’: ―Jitats nan cu ts’uts’bay, jats tata’chic ca yac’ua’. ");
INSERT INTO husNT1971_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Tam utcan a Judas tin tamet a Jesús, ani in ucha’: ―Thamc’unenec, Exobchix. Tam in ts’uts’bay. ");
INSERT INTO husNT1971_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ani a Jesús in conoy: ―¿Jale’ tit chich, ja’ub? Tam utey in juntalchic a Judas, in yac’ua’ a Jesús ani in ne’tha’. ");
INSERT INTO husNT1971_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Tam jun axi pel i juntal exobal c’al a Jesús in jixa’ in matsetil ani in muts’q’uinchi in xutsun in tolmixal an ts’ale pale’. ");
INSERT INTO husNT1971_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Tam uchan c’al a Jesús: ―Ca huichba’ a matsetil tin ot’ol, cum patal jitats ca pejéxin c’al i matset ne’ets ca tsemtha c’al i matset. ");
INSERT INTO husNT1971_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Hualam yab a tso’ob abal nan xohue’its u ejtohual cu conchi u Tata ani quin abchin lajuj tsab i pulic cuenel i ángelchic abal tiquin c’aniy. ");
INSERT INTO husNT1971_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Max quin c’aniyatac yab ne’ets ca putun an T’ocat Thuchlab jun tim bijchithits nana’ quin yajchiquiyat. ");
INSERT INTO husNT1971_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Tam a Jesús in ucha’chic an yac’ualchic: ―Tata’ ojni’chic it che’nec tiquin yac’ua’ c’al i matset ani c’al i te’chic ejtil max pel in cue’. Chuthel chuthel in c’uajatac ta tiyopanil tin exobchix ani yab tin yac’ua’ taja’. ");
INSERT INTO husNT1971_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ma xo’ ojni’ tin yac’ualchic abal antsana’ ta ca putun an T’ocat Thuchlab jant’ini’ tin thuchnenequits c’al in caulomejilchic a Dios antse’ quin yac’uan. Tam u t’ajat c’ale ti athil patal huahua’ tu exobalilchic a Jesús, ani tam jaja’ a Jesús jilcacayatits. ");
INSERT INTO husNT1971_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Taley ta ne’thajits a Jesús c’al an yac’ualchic tin q’uima’ an ts’ale pale’ Caifás. Taja’ tamcuthits an exobchixchic c’al an ts’ejcath cau binath c’al a Moisés ani an yejtselabchic Israel. ");
INSERT INTO husNT1971_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ani a Pedro ta tale ts’at’at hue’ ou. Talbel tam ti ulitsits jaye tin q’uima’ an ts’ale pale’, otsits taja’ ani buxcan ti al am patio c’al an yac’ualchic abal quin tsu’u jant’o ne’ets ca t’ajchin a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Taja’ c’uajat an oc’lec pale’chic ani an yejtselabchic Israel ani patal an cuenel axi c’athpich in ey an ts’ejcom cau tin cuenta an tiyopanchic Israel. In alimichical jant’ini’ ti quin jolbiy a Jesús abal ca tsemtha, ani yab chubax jahua’ in uluchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Yab in ejtohual quin elchi i hualabtalab, aba ani’ yan i inicchic in jolohual i janamtalab tin cuenta a Jesús. Ma tin lej taltalits cubiy tsab i inic in olnal i cau axi jaye yab chubax ");
INSERT INTO husNT1971_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","In uluchic: ―Axe’ xi inic in ulu antse’: U ejtohual cu paclu in tiyopanil a Dios, ani cu tsab ts’ejca’ junil ti ox a q’uichacua’. ");
INSERT INTO husNT1971_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Tam cubiy an ts’ale pale’ ani in conoy a Jesús: ―¿Yab ne’ets ca toc’tsiy ni jun an jolbixtalab jahua’ it uxnal? ");
INSERT INTO husNT1971_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Yab toc’tsin a Jesús. Tam uchan c’al an ts’ale pale’: ―Tim bij a Dios axi ejat abal ets’ey ca chubax olna’ ta ba’. Tucu ucha’ max tata’its it Cristo ani max pel ti Tsacamil a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Toc’tsin a Jesús: ―Nana’its ojni’ ja’its jant’ini’ ta ulu. Nan tu uchalchic jaye abal tata’chic ne’ets tiquin exlanchi u ey tam in quetelits tin huinat c’ubac a Dios ti eb ax in cua’al patal in cuete’ tsap. Ani ne’ets tiquin exlanchiye u ey abal pel tin lej Juntal patal an inicchic tam quin huichiy junil pa’i’ilits al i tocoulom. ");
INSERT INTO husNT1971_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","C’al nixe’ xi cau lej tsacuy an ts’ale pale’, ma in mits’al in nacat coton. In ulu: ―Xohue’its ojni’ a ats’amalchic jahua’ antsana’ in ulumal ejtil max jaja’ pel a Dios. Yabats i yejenchal jita’ más tucu olchiye tin cuenta axe’ xi inic. ");
INSERT INTO husNT1971_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Jant’ini’ ta tsalpayalchic nana’ jant’ini’ tu cu t’ajchi? Toc’tsinchic: ―Alhua’ max ca tsemtha, cum lej jolbithits jaja’. ");
INSERT INTO husNT1971_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Tam talchic i inic in tubcanchal a Jesús in hual ani in cuathcuayal. In mo’canchal i c’ubaclec tin hual. ");
INSERT INTO husNT1971_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Uchan a Jesús: ―Tata’its it Cristocua’, tucu olchi jita’ ti cuatha’. ");
INSERT INTO husNT1971_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Quetelits a Pedro ti al am patio tin q’uima’ an ts’ale pale’ tam ti utey jun i cuthinel. Uchan a Pedro: ―Tata’ ojni’ pel it ts’at’el c’al a Jesús axi tal ti Galilea. ");
INSERT INTO husNT1971_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Tam a Pedro in tsinca’ tim ba’, in ulu: ―Yab u exlal jant’o tam cau ax a ulal. ");
INSERT INTO husNT1971_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Tam a Pedro ne’etsits tihua’ ba’ an hui’leb ani tsu’tab c’al q’ue’at i cuthinel. Ani jaye jaja’ in ucha’ axi muthat taja’: ―Chubax jaja’ pel i ts’at’el c’al a Jesús Nazaretib. ");
INSERT INTO husNT1971_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Tam a Pedro in tsab tsinca’ tim ba’ junil. In cuba’ tim ba’ ti lej chubax, in lej ulu: ―Nan yab u exlal axe’ xi inic ax a ulal. ");
INSERT INTO husNT1971_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Tam uchan c’al axi c’uajatchic taja’: ―Lej chubax tata’its pel ti juntal axi ts’at’elchic c’al a Jesús. Ti tejhua’methal a cahuintal abal pel it lej Galileajib. ");
INSERT INTO husNT1971_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Tam a Pedro in ulu alhua’ max ca t’ajat yajchiquiyat c’al a Dios max yab chubax jahua’ in ulumal. In cuba’ tim ba’ ti lej chubax junil, in ulu: ―Nan yab u exlal axe’ xi inic. Tameq’ui ti thajnalits an coxol. ");
INSERT INTO husNT1971_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Tam a Pedro in t’ilpa’ jahua’ uchnenec c’al a Jesús abal ne’ets quin tsinca’ tim ba’ oxil i calat tam ti ibaque thajnenec an coxol. Ani cale a Pedro taja’ lej tsapic uc’nal. ");
INSERT INTO husNT1971_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Tam ti chutheyits in ts’ejcal an cau patal an oc’lec pale’chic ani an yejtselabchic Israel abal jant’ini’ ti quin tsemtha’ a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Taley in ne’tha’chic a Jesús huic’at ani im bina’ tin c’ubac an gobernador Poncio Pilato. ");
INSERT INTO husNT1971_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Tam ti a Judas in tsu’u abal ne’ets ca tsemtha a Jesús, tam in lej yajna’ abal jale’ in tsinat bina’. In le’ quin huichbanchi nixe’ xi ox i lajuj i tumin plata an oc’lec pale’chic ani an yejtselab Israel. ");
INSERT INTO husNT1971_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","In ucha’chic: ―In hualbinenec, cum u tsinat binamal axe’ xi t’ocat inic abal ca tsemtha. Toc’tsin jaja’chic: ―Yab pel i cuenta huahua’ jahua’ a t’ajamal, pelits a cuete’ cuenta expith. ");
INSERT INTO husNT1971_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Tamna’ a Judas in joloc’na’ an tumin alta ti al an tiyopan, ani ta c’ale in huic’a’ i ts’aj tin nuc’. Im pala’ tim ba’ ani thut’c’uth tsemets. ");
INSERT INTO husNT1971_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Taley an oc’lec pale’chic im pena’ an tumin ani in uluchic: ―Yab i ejtohual qui xalu axe’ xi tumin c’al ax u pithnal a Dios, cum pel i tumin axi pel i jalbixtalab c’al in xits’al i inic. ");
INSERT INTO husNT1971_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Jaxtam jaja’chic thubat in ts’ejca’ an cau abal quin ts’a’iy c’al nixe’ xi tumin i tsabal ax u bijiyab ti thacum pach tsabal. Tats ca joliyat an tsemelomchic axi pel i pil inic ani yab Israel. ");
INSERT INTO husNT1971_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Jaxtam ma xohue’ u bijiyab nixe’ xi tsabal ti xits’ tsabal. ");
INSERT INTO husNT1971_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Antsana’ putnenec an cau jahua’ in ulumal an caulome c’al a Dios Jeremias antse’: Huichbanchame axi ox i lajuj i tumin plata. Antsana’ tu tsalpanchab in jalbil jaja’ axi bina c’al am bichou Israel. ");
INSERT INTO husNT1971_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","C’al nixe’ xi tumin ts’a’iyame an tsabal axi eyenthame c’al an thacum pach jant’ini’ in ulumal a Dios, in ulu a Jeremías. ");
INSERT INTO husNT1971_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Taja’ c’uajat a Jesús tin tamet an gobernador Pilato ani conoyab: ―¿Tata’its pel ti Ts’alejil an Israelchic? Toc’tsin a Jesús: ―Nana’ ja’its ojni’ ax a ulal. ");
INSERT INTO husNT1971_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ani u jolbiyab a Jesús c’al an oc’lec pale’chic ani c’al an yejtselabchic Israel. Tocat yab toc’tsin. ");
INSERT INTO husNT1971_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Tam conoyabe c’al a Pilato: ―¿Yab a ats’al abal it lej jolbiyab? ");
INSERT INTO husNT1971_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Bel yab jant’o toc’tsin a Jesús. Ani jats tin lej jic’pal a Pilato, ma yab in exla’ jant’ini’ ti quin tsalpanchi a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","In ujnam an gobernador quin hualca’ jun i huic’nel tam u t’ajnal an ajib tin cuenta abal calthame am biyal bichou Israel ti Egipto. Ca hualca an huic’nel jitats ca bijchin c’al am bichou ");
INSERT INTO husNT1971_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","C’uajatits tam ti al an huic’axte’ jun i huic’nel lej exlab im bij a Barrabás. ");
INSERT INTO husNT1971_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Jaxtam tam ti mulcunenequits am bichou, conoyab c’al a Pilato: ―¿Jita’ a le’chic abal nan tu hualcanchi? ¿Cu hualca’ a Barrabás o cu hualca’ a Jesús ax u bijiyab jaye ta Cristo? ");
INSERT INTO husNT1971_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","A Pilato in exla’its abal u lej pa’ixnab a Jesús, ani jats ti binanchamejits tin c’ubac abal jaja’ quin jolbiy. ");
INSERT INTO husNT1971_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Quetelits a Pilato tin lactemil jun tin ts’ejcal an cau, ani tam abchinal i cau c’al in tomquil antse’ ca uchan: Yab jant’o ca t’ajchi yab alhua’ nixe’ xi pututh inic, cum ti acal tu huachib u lej yajchicna’ tin cuenta jaja’. ");
INSERT INTO husNT1971_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ani an oc’lec pale’chic ani an yejtselabchic Israel exome in nixoc’nal an mulcunel abal quim bijchi a Barrabás ca hualca ani a Jesús ca tsemtha. ");
INSERT INTO husNT1971_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Tam an gobernador in tsab tauna’ am bichou junil in conoyal: ―¿Jahua’ axi tsablom a le’ abal nan tu hualcanchi? Toc’tsin an mulcunel: ―Ca hualca’ a Barrabás. ");
INSERT INTO husNT1971_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ani a Pilato in conoyalchic: ―¿Ani jant’o cu t’ajchi a Jesús ax u bijiyab ta Cristo? An mulcunel tim patal toc’tsin: ―Ca t’ajat bina’ ca q’uet’ath tsemtha ti al an cruz. ");
INSERT INTO husNT1971_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Tam a Pilato c’al más i cau in conoyal: ―¿Jant’o yab alhua’ in t’ajamalac abal antsana’ cu bina’? Ani lej thajat toc’tsin an mulcunel: ―Ca t’ajat bina’ ca q’uet’ath tsemtha ti al an cruz. ");
INSERT INTO husNT1971_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Tam a Pilato in tsu’u abal ni hue’ u t’ajchinal ti cuenta, tocat xacuecuel an mulcunel. Tam in conchi i ja’ ca chanchin, ani taley in t’aca’ in c’ubac tin tamet an mulcunel. In ucha’chic: ―Max ca tsemtha axe’ xi pututh inic yab pel u cuenta nana’, pel a cuenta tata’chic expith. ");
INSERT INTO husNT1971_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Toc’tsin tim patal jaja’chic: ―Max ca tsemtha pel i cuenta huahua’ junax c’al i tsacamilchic, expith ca t’ajat tsemtha. ");
INSERT INTO husNT1971_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Tam a Pilato in aba’ an cau ca hualca a Barrabás. Ani im bina’ a Jesús ca huithc’oyat c’al an soldadochic, ani ca ne’tha ca q’uet’ath tsemtha ti al an cruz. ");
INSERT INTO husNT1971_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Taley an soldadochic in ne’tha’ a Jesús tin atajil an gobernador, ani taja’ patal jaja’chic in cuentsimiyal. ");
INSERT INTO husNT1971_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","In tixc’anchal in toltomil ani in cay’chal i tsacni’ nacat coton. ");
INSERT INTO husNT1971_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Tin oc’ im punchal jun i thipath q’uith corona ani tin huinab c’ubac i pacáb. In tilibnath tuthuhual in c’ualalchic tin tamet a Jesús ejtil max pel i ts’ale. Tam in tilibnath uluchic: ―Je’its an Ts’ale c’al an Israelchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Taley in tubcayalchic a Jesús. In tixc’anchal am pacáb tin c’ubac ani in mo’canchal tin oc’. ");
INSERT INTO husNT1971_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Tam tin tilibnamalits antsana’chic, tam in tixc’anchi an tsacni’ nacat coton ani in cay’chi in cuete’ c’al. Taley in ne’tha’chic abal ca q’uet’ath tsemtha ti al an cruz. ");
INSERT INTO husNT1971_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Tam ti ne’etsits ne’thab a Jesús ti bel, tal jun i inic im bij Simón axi pel i Cirenejib. Jats punuhuat c’al an soldadochic abal quin quitnanchi an cruz ax in quitnal a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Taley ulitschic al jun i c’uajattalab im bij Gólgota. Ti tenec cau in le’ quin ulu Tam’oc’. ");
INSERT INTO husNT1971_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ani taja’ an soldadochic im pitha’ a Jesús i vino xaluth c’al i ilal lej ts’a’ic. In oc’ox leca’, yab in le’na’ quin uts’a’. ");
INSERT INTO husNT1971_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Tam ti q’uet’athits a Jesús ba’ an cruz, tam an soldadochic in calthal i q’uij jant’ini’ quin c’alnanchi in toltomil a Jesús. Antsana’ ti putnal jahua’ in ulumalits in caulomejil a Dios antse’: In caltha’chic i q’uij jant’ini’ tiquin c’alnanchi u toltomil. ");
INSERT INTO husNT1971_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Taley buxcan an soldadochic utat ti al an cruz abal ti beletnom. ");
INSERT INTO husNT1971_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Tin oc’ an cruz punchithits i thuchlab jolbixtalab antse’ ti thuchath: Ja’its axe’ a Jesús in Ts’alejil an Israelchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Taja’ c’uajat q’uet’athits al i cruz jaye c’al a Jesús tsab i cue’, jun tin huinab ani jun tin c’uatab. ");
INSERT INTO husNT1971_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ani talchic i huat’el ba’ am bel in quithab uchal a Jesús. Tocat in huihuohuiyal in oc’, cum im pojcal a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","In tilibnath ucha’chic: ―Tata’ a ulumalits a ejtohualac ca paclu an tiyopan ani ti ox a q’uicha ca tsab ts’ejca’ junil. Xohue’its ca jec’ontha’ ta ba’. Quit pa’iy ba’ an cruz max chubax pel ti Tsacamil a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ani tilibnab a Jesús jaye c’al an oc’lec pale’chic, ani c’al i exobchix c’al an ts’ejcath cau binath c’al a Moisés, ani c’al i fariseo, ani c’al i yejtselabchic Israel. In uluchic: ");
INSERT INTO husNT1971_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―In jec’onthamal q’ue’at i inicchic ani abal jaja’ yab in ejtohual quin jec’ontha’ tim ba’. Auxe’ max jaja’ ja’its ax u aychab ca chich ti Ts’ale c’al huahua’ tu Israel. Max chubax ja’its, ca t’ajat pa’iy ti al an cruz abal qui bela’. ");
INSERT INTO husNT1971_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Max chubax in tsapnalcua’ a Dios ani max chubax u c’anithab c’al a Dios, tam xohue’its ca jec’ontha c’al a Dios. Cum in ulumalits abal jaja’ ja’its in Tsacamil a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ma tilibnab a Jesús c’al nixe’ xi tsab i cue’ jaye axi q’uet’ath ba’ i cruz. ");
INSERT INTO husNT1971_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Taley tala’ yic’utsin tim puhuel an tsabal ma ti ts’ejel q’uicha ani ma ti ox hora an huacal. ");
INSERT INTO husNT1971_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ma tam ti tamits nixe’ xi hora, in lej tsapic ulu a Jesús: ―Elí, Elí, ¿lama sabactani? Ti tenec cau in le’ quin ulu: U Diosil u Diosil, ¿jale’ tin jilcacayamalits? ");
INSERT INTO husNT1971_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ani talchic i inic axi c’uajat taja’ tam tin ats’a’ nixe’ xi cau, in uluchic: ―In caniyal ca chich am biyal caulome c’al a Dios Elías. ");
INSERT INTO husNT1971_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Tam jun jaja’chic ax in ats’al thubat athlats abal quin iq’ui’ i thic’axtalab axi hue’ ejtil i cuinim. In tsabay al i ts’a’ic vino, ani in umchi tin chum i te’. Taley in utunchi tin hui’ a Jesús quin juts’u. ");
INSERT INTO husNT1971_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ani q’ue’atchic axi c’uajat in ulu: ―Qui hue’ aychiye max ca chich a Elías quin tolminchi. ");
INSERT INTO husNT1971_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Tam lej tsapic cahuin junil a Jesús, ani taley t’ajat tsemetsits. ");
INSERT INTO husNT1971_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Tameq’ui ti cathlun ma ebal ani ma alal am pelcath toltom ba’ an tiyopan. Jilc’on tsab i pejach. Ani lej t’elelel an tsabal, ma poq’ueq’uel an t’ujubchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ani japq’uinal i paxal jolchic jun ti jolith i tsemelomchic. Ani ejthab yan axi belom c’al a Dios axi jolith taja’. ");
INSERT INTO husNT1971_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Tocat yab thubat calechic ti al nixe’ xi paxal jolchic. Ma tam ti ejthachits a Jesús, tam tiq’uele cale jaja’chic. Otsitschic ti al an t’ocat bichou Jerusalén, ani taja’ tsu’tab c’al yan i inicchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","An capitán soldado ani an soldadochic ax im beletnal a Jesús in tsu’u t’elelel an tsabal ani axi q’ue’at más i jic’path t’ajbilab. Ani cum lej jiq’uelchic, in ulu: ―Axe’ xi inic ojni’ ja’its pel in Tsacamil a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","C’uajatchic taja’ hue’ ou yan i uxum in met’al a Jesús ba’ an cruz. Pel i uxumchic axi ts’at’enec ani tolmixin c’al a Jesús ma tam ti xe’etsac jaja’ ti Galilea. ");
INSERT INTO husNT1971_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","C’uajat a María Magdalajib ani a María axi pel in mim a Jacobo ani a José. C’uajat jaye in mim a Jacobo ani a Juan ax in cua’al in tata Zebedeo. ");
INSERT INTO husNT1971_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Taley lej huaclejits tal jun i inic im bij a José pel i Arimateajib. Pel i rico inic ani pel i ts’at’el c’al a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ulits c’al a Pilato ani in conchi in inictal a Jesús quin joliy. A Pilato in aba’ an cau ca pithanchat. ");
INSERT INTO husNT1971_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Tam a José in ne’thanchi, ani in thu’bay c’al jun i it putat toltom. ");
INSERT INTO husNT1971_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","In cua’al a José i it jolimtalab tsajath jol paxal t’ujub, ani tats tin mo’canchi in inictal a Jesús. Ani jun i pulic t’ujub cubat taja’ in toliy ani im paxq’uinchi an otsnamtalab. Taley ta c’ale. ");
INSERT INTO husNT1971_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ani quetechic taja’ a María Magdalajib ani axi q’ue’at María eleb utat tin otsnamtal an jolimtalab. ");
INSERT INTO husNT1971_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Huat’eyits an viernes tam ti t’ojojol an Israel tin cuenta an sábado, ani nixe’ xi sábado an oc’lec pale’chic ani an fariseochic c’ale quin tsu’u a Pilato. ");
INSERT INTO husNT1971_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","In ucha’chic: ―Pay’lom, i t’ilal jant’o in ulu nixe’ xi janamcau tam ti ejatac. Ca tsemets ani ti ox a q’uicha tam ne’ets ca ejthacua’. ");
INSERT INTO husNT1971_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Jaxtam ca aba’ an cau ca lej alhua’ beletna an jolimtalab ca quithbanits xi ox q’uicha, i ca chich acal in exobalilchic quin cue’chi in inictal ani talbel quin uluchic ejthachits. I ca c’athpich c’ambiyat an inicchic c’al i pulic janamtalab antsana’ yab ejtil axi hue’ c’ambiyamejits c’al q’ue’at in cahuintalchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","A Pilato in toc’tsiychic: ―Tata’chic a cua’al i beletnom ta tiyopanilchic. Jats ca aba’chic quim beletna’ an jolimtalab jant’inits quin ejtou. ");
INSERT INTO husNT1971_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Tam c’alechic in ts’a’chi i tsacam ts’aj pelc’ath ma jum poq’ue’ al am pulic paxic’lab t’ujub tin otsnamtal an jolimtalab. Pel i tsu’bixtalab c’al an oc’lecchic abal ni jita’ yab quin calthanchi in inictal a Jesús. Ani jilc’onchic taja’ nixe’ xi soldado ti beletnom. ");
INSERT INTO husNT1971_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Huat’eyits an q’uicha sábado, ani chuthelits pel an c’a’al q’uicha semana. Ani chich quin tsa’biychic an jolimtalab a María Magdalajib ani axi q’ue’at María. ");
INSERT INTO husNT1971_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ani jun jic’tohual lej tsapic t’elelatsits an tsabal, ani pa’iy ti eb ulits ti al an jolimtalab jun i ángel abath c’al a Dios. In tixc’anchi am pulic paxic’lab t’ujub tin otsnamtal an jolimtalab, ani buxcan ba’ eblim an t’ujub. ");
INSERT INTO husNT1971_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ani tsu’tab an ángel lej ts’umimil ejtil an ley, ani in toltomil lej thacninil ejtil i pojoth tsam. ");
INSERT INTO husNT1971_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ani lej jiq’uel an soldadochic axi beletnom c’al an jolimtalab, ma ijcan tsabal ejtil tam tsemenec. ");
INSERT INTO husNT1971_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Tam uchan an uxumchic c’al an ángel: ―Yab quit jiq’ueychic. U tso’ob abal a aliyalchic a Jesús axi q’uet’ath tsemtha ti al an cruz. ");
INSERT INTO husNT1971_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Yabats c’uajat teje’, cum ejthajits jant’ini’ tin ulumal jaja’ abal ne’ets ca ejtha. Ca met’a’chic te jun ti c’uajatac in inictal. ");
INSERT INTO husNT1971_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Thubat quit c’alechic ca olchi in exobalilchic abal ejthachits ani ne’ets ca oc’chith ulits ti Galilea. Jaja’chic ca c’ale’ tihua’ quin tsu’u. Ja’its axe’ an cau axi nan tu uchalchic, in ulu an ángel. ");
INSERT INTO husNT1971_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Tam calpanchic an uxum ti al an jolimtalab c’al in athic. Jun t’ajatq’ui u jiq’uel ani jaye jun t’ajatq’ui u lej culbel. Ta ne’etsits athithil tucu olchi huahua’ tu exobalilchic a Jesús jahua’ in tsu’umalchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ani tam ti ne’etsits jaja’chic ti bel, tam tamuhuab ani tsapnethab c’al a Jesús. Tam in tuthuchic in c’ualal tin tamet a Jesús, ani in muts’c’unchichic in acan. Antsana’ ti c’ac’naxin c’al jaja’. ");
INSERT INTO husNT1971_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Tam uchanchic c’al jaja’: ―Yab quit jiq’ueychic. Tocat quit c’ale ca ucha’ i ebchalchic ca c’ale ti Galilea, ani taja’ ne’ets tiquin tsu’u. ");
INSERT INTO husNT1971_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ani biyat ne’etsits an uxumchic c’al nixe’ xi cau, tsab ox i soldado axi beletnom c’al an jolimtalab ulits ti al am bichou quin olchi an oc’lec pale’chic patal jahua’ t’ajnenec. ");
INSERT INTO husNT1971_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Tam c’ale an oc’lec pale’chic quin olchi an yejtselabchic Israel. Taley in juncuchic an cau abal quim pitha’ yan i tumin an soldadochic. ");
INSERT INTO husNT1971_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Uchanchic an soldado: ―Antse’ ca ulu: Chich acal in exobalilchic a Jesús ani in cue’chi in inictal biyat huahua’ u huayamath, ca ulu. ");
INSERT INTO husNT1971_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ani max an gobernador quin tso’obna’ abal it huayamathchic, yab quit t’e’pin cum huahua’ ne’ets qui ts’ejca’ an cau c’al jaja’ abal yab quit jolbiyat. ");
INSERT INTO husNT1971_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Tam an soldadochic im bats’u an tumin, ani ta c’ale quin t’aja’ jant’ini’ ti uchanits. Ma xo’ u t’ilnale nixe’ xi cau c’al an Israelchic. ");
INSERT INTO husNT1971_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","U c’alechic huahua’ ti Galilea lajuj jun ti eb tu exobalilchic a Jesús, ani u ulits ti al am bolchal jun tu bijchamalits a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Taja’ i tsu’uchic a Jesús ani i c’ac’nal. Bel tsab ox huahua’ i cua’ale i hualamtalab ti ichich tin cuenta jaja’. ");
INSERT INTO husNT1971_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Tam a Jesús tu ucha’chic: ―Im pithnenec c’al a Dios patal cu abatna’ axi ti eb ani jaye axi ti tsabal cu co’oy. ");
INSERT INTO husNT1971_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Jaxtam quit c’alechic tim puhuel an tsabal ca exobchi tim patal an inicchic u cahuintal abal tiquin ts’at’enchi. Ca pujaychic tim bij u Tata, ani tu bij nana’ tin Tsacamil a Dios, ani tim bij an Espíritu Santo. ");
INSERT INTO husNT1971_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ca exobchichic abal quim putu c’al patal an uchbixtalab axi nan tu jilchamalits. Ca t’ila’chic abal nan ne’ets quin ets’ey c’uajiy c’al tata’chic ma ta ca taleyits an q’uij q’uicha. Amén.");
INSERT INTO husNT1971_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ne’ets cu olna’ jant’ini’ ti ts’i’quin an alhua’ cau tin cuenta a Jesucristo in Tsacamil a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ma ti lej biyalits in caulomejil a Dios Isaias in thucha’ jahua’ a Dios in uchamal antse’ in Tsacamil Jesucristo: Nana’ in Dios ne’ets cu oc’chith aba’ u caulomejil abal ti ts’ejcacanchi am bel. ");
INSERT INTO husNT1971_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Jaja’ ne’ets quin thajchixnanchi an inicchic ax u che’el ti al an joltam antse’: Ca ts’ejcacanchi am bolith bel an Ajatic jun ti ca ulits. ");
INSERT INTO husNT1971_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Jant’ini’ ti thuchathits antsana’ ne’ets ca aban i caulome c’al a Dios, antsana’ ti chich a Juan. Xe’ets ti pujax c’al an inicchic ax u che’el c’al jaja’ ti al an joltam. In thajchixnanchal ca jic’tson c’al in hualab abal ca paculanchat c’al a Dios, ani ca pujan. ");
INSERT INTO husNT1971_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Chich taja’ jat’hua’ patal an inicchic ax u c’uajil tihua’ tim puhuel an tsabal Judea ani ax ti bichou Jerusalén quin ats’anchi in thajchixtal a Juan. U pujayabchic taja’ c’al a Juan ti al am pulic itse’ Jordán jitats in lujuhual in hualab c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Toltomith a Juan c’al i toltom axi ts’ejcath c’al in jujul an camello. In huic’ ts’ejcath pel i ot’. In c’apchal in t’u’ul an ts’ili’ ax u c’apab ani an alte’ tsi’im. ");
INSERT INTO husNT1971_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","In thajchixnanchal an inicchic antse’: ―Ta tal talbel jun i inic lej pulic in ey ani nana’ iba. Nana’ lej tsa’at u ey, ma yab ne’ets cu baju cu pilchi in quintsol im pajab. ");
INSERT INTO husNT1971_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nana’ tu pujayalchic c’al i ja’, ani jaja’ axi taye tal talbel jats ne’ets ti pujaychic c’al an Espiritu Santo. ");
INSERT INTO husNT1971_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Jun a q’uicha cale a Jesús ti bichou Nazaret axi cuentalith ti Galilea, ani ulits c’al a Juan ti pulic itse’ Jordán. Ani pujnal taja’ c’al a Juan. ");
INSERT INTO husNT1971_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Taley tam ti calelelits a Jesús ti al an ja’, tam tin tsu’u japq’uinal an eb ani pa’i’il an Espiritu Santo ejtil i cucu’. Ta jilc’on c’al a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ani ats’atmel jaye jun i cau tal ti eb c’al a Dios, taunab a Jesús antse’: ―Tata’its pel tu ichich hual Tsacamil. In lej culbel c’al tata’. ");
INSERT INTO husNT1971_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Taley talbel ne’tha a Jesús c’al an Espiritu Santo ca c’ale ti al i joltam. ");
INSERT INTO husNT1971_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ani tats ti c’uajiy tsab inic a q’uicha jun ti hua’ats i thimalon tse’ acanchic. Ani lej nixoc’nab le’nab ca hualbin c’al a Satanás. Chich i ángelchic abal quin tsapliy a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Balithits a Juan ti al an huic’axte’ tam ti a Jesús ulits ti Galilea. Taja’ in olnanchalchic an inic an alhua’ cau jant’ini’ tin t’ajal a Dios ti Ts’ale. ");
INSERT INTO husNT1971_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","In ucha’chic: ―Hue’its a q’uicha ne’ets quim baju ca chich a Dios quin t’aja ti lej Ts’ale c’al an inicchic teje’ tsabal. Quit jic’tsonchic c’al a hualab ani ca bela’ an alhua’ cau abal quit jec’ontha c’al a hualab. ");
INSERT INTO husNT1971_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ne’ets a Jesús hualchicte’ am pulic lejem Galilea, ani taja’ in tsu’u tsab i inic ti alim to’ol. Pel a Simón c’al in ebchal Andrés ax im pet’nalchic an thachumtalab c’al an to’ol ti al am pulic lejem. ");
INSERT INTO husNT1971_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","A Jesús in ucha’chic: ―Tiquin ts’at’enchi ani nan ne’ets tu aba’ tit alim c’al an inic axi nana’ tiquim bela’. ");
INSERT INTO husNT1971_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ani thubat in jiloc’na’chic in thachumtal c’al an to’ol, ani ts’at’ey c’al a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Taley belats a Jesús ne’ets más tihua’, ani in tsu’u jaye a Jacobo c’al in ebchal Juan. Jaja’chic pel in tsacamil a Zebedeo. C’uajatchic ti al an tan in c’ua’chiyal in thachumtal c’al an to’ol. ");
INSERT INTO husNT1971_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","A Jesús in caniychic ca chich. Ani in jila’chic in tata Zebedeo c’al in t’ojnalilchic ti al an tan, ani ta c’alechic ca ts’at’eyits jaye c’al a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ulits a Jesús junax c’al in ts’at’elilchic ti bichou Capernaum. Taja’ otsits tin tiyopanil an Israelchic, ani in exobchal in cahuintal a Dios an inicchic. Pel i sábado. ");
INSERT INTO husNT1971_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Cum u exobchix c’al i lej uchbith cau yab ejtil axi exobchix c’al an ts’ejcath cau binath c’al a Moisés, jaxtam lej jic’panchab in exobchixtal. ");
INSERT INTO husNT1971_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ani c’uajat al nixe’ xi tiyopan jun i inic co’oyab c’al i at’ax teneclab. U lej thajanthab c’al an at’ax quin ucha’ a Jesús antse’: ");
INSERT INTO husNT1971_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","―¿Jant’o hualam a le’ tucu t’ajchi, Jesús Nazaretib? Hualam a le’ tucu t’ajat talabetha’. Nan tu exlanchal a ey pel ti T’ocat Tsacamil a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Tam c’uiyan an at’ax teneclab c’al a Jesús, uchan: ―Quit ts’ibc’an ani quit cale tin ichich axe’ xi inic. ");
INSERT INTO husNT1971_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Tam lej ts’ebtsinthab ani lej thajanthab lej tsapic nixe’ xi inic c’al an at’ax teneclab, ani tam calejits tin ichich. ");
INSERT INTO husNT1971_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ani cum lej in jic’pal patal axi muthat taja’ in conoyal antse’: ―¿Jant’o hualam in uchbil axe’ xi inic? ¿Jant’o tam it exobchixtalab hualam in chal? In cua’al in lej tsap abal quin ata’ an at’ax teneclab jant’ini’ jaja’ ti quin le’na’. ");
INSERT INTO husNT1971_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ani lej thubat t’iloxnanchab in labith t’ajbilchic a Jesús tim puhuel am bichouchic ti Galilea. ");
INSERT INTO husNT1971_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Calejitschic ti al an tiyopan, c’ale a Jesús junax c’al a Jacobo ani c’al a Juan, ulits tin q’uima’ a Simón ani a Andrés. ");
INSERT INTO husNT1971_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Taja’ c’uajat mo’ol c’al i c’aq’ueltalab in uxum iyam a Simón ti al i huaytalab tsey. Ani olchinal a Jesús abal u ya’ul. ");
INSERT INTO husNT1971_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Tam utey a Jesús, in yac’uchi in c’ubac ani in ts’acba’. Ma tameq’ui jun t’ajat tixc’anchat an c’aq’ueltalab. Tam jaja’ an uxum im pijchi a Jesús junax c’al in junquilchic. ");
INSERT INTO husNT1971_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Otscanits a q’uicha ani aclelits tam tu chanchinal a Jesús yan i ya’ulchic ani yan ax u co’oyab c’al i at’ax teneclab. ");
INSERT INTO husNT1971_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ma tim patal am bichou utey al an hui’leb jun ti c’uajat a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ani in jelthachiquiyal yan i ya’ul jahuaquitsq’ui tam yau’lats, ani jaye in canchal yan i at’ax teneclab. Aba ani’ exlanchat in ey a Jesús c’al nixe’ xi at’ax teneclabchic, bel yab in hualcanchi quin olchi in ey c’al jita’. ");
INSERT INTO husNT1971_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Taley aytalab q’uicha ts’aquiy a Jesús tam yic’uic’uile. Cale ti al am bichou, c’ale ti ol pil jun ti jolat. ");
INSERT INTO husNT1971_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ani talbel c’ale a Simón c’al in junquilchic quin aliy a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","In ela’ ani in ucha’: ―Patal an inicchic ti aliyal. ");
INSERT INTO husNT1971_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Toc’tsin a Jesús: ―Huana qui tsa’biy an utat cuenchalabchic qui thajchixna’ jaye tihua’ in cahuintal a Dios. Jats tin che’nec teje’ tsabal. ");
INSERT INTO husNT1971_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ani xe’tsitsil a Jesús tim puhuel an tsabal Galilea ti thajchix c’al in cahuintal a Dios ti al in tiyopanilchic an Israelchic, ani jaye in canchal i at’ax teneclab an inicchic. ");
INSERT INTO husNT1971_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Taley utey c’al a Jesús jun i inic ax in cua’al i t’it’ c’apux c’al in anam t’u’ul. In tuthuhual in c’ualal tin tamet a Jesús, ani in ucha’: ―Max a le’ac a huit’al tiquin jeltha’. ");
INSERT INTO husNT1971_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","A Jesús in yajnanchi. In tacchi ani in ucha’: ―U le’ tu jeltha’, ani ma xohue’ it jelthachits. ");
INSERT INTO husNT1971_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Tam tin ucha’its antsana’ a Jesús, tameq’ui jelthachits. ");
INSERT INTO husNT1971_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Tam ti a Jesús oc’chithe abal quin aba’ ca c’ale, in lej ucha’: ");
INSERT INTO husNT1971_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","―Ca lej t’aja’ ti cuenta yab jita’ ca olchi jahua’ nan tu t’ajchamal. Expith quit c’ale c’al am pale’ ani ca bina’ an ts’acchixtalab ax in ulal an ts’ejcath cau binath c’al a Moisés in uchbil quim bina’ jitats jelthachits c’al an t’it’ axi c’apux c’al in anam t’u’ul. Antsana’ ta ca t’aja’ abal ca tejhua’methanchi an inicchic abal it jelthachits. ");
INSERT INTO husNT1971_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Aba ani’ uchan yab jita’ quin olchi, bel xe’ets in olchal patal jitats in tamuhual abal jelthachits c’al a Jesús. Cum lej olnanchab in t’ajbil a Jesús ani jaja’ yab in le’ antsana’ ca olnanchat, jaxtam yabats lej tejhua’ xe’ets al i bichouchic. Aba ani’ xe’ets al i joltam, bel chich yantalam i inicchic aba ju’tamq’ui quin tsu’u a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Taley pil a q’uicha huichiy a Jesús junil ti bichou Capernaum. Ani tso’obna abal c’uajat tin q’uima’. ");
INSERT INTO husNT1971_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ani thubatq’ui mulcunal yan i inicchic, ma t’uchichin an alta ani yabats u lejel ju’ta ta ca otsitse más al an hui’leb. Ani a Jesús in thajchixnanchal axi muthat taja’ in cahuintal a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Tam ulits tse’ i inic in chi’thal jun i inic tsambe. ");
INSERT INTO husNT1971_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Cum lej q’uits’c’omathits an mulcunel, yab in ejtohual quin utba’ tin tamet a Jesús. Jaxtam ti c’athiychic hualq’ui’ quin jacchi hue’ in jujlabil an ata tim bolithtal jun ti c’uajat a Jesús. Tam im pa’ba’ an tsambe c’al patal an tseyte’ tat. ");
INSERT INTO husNT1971_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Tam ti a Jesús in tsu’u antsana’ in lej belalchic, tam in ucha’ an tsambe: ―C’an tsacamil, nan tu paculanchal a hualab. ");
INSERT INTO husNT1971_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Taja’ hua’ats quetel talchic i exobchix c’al an ts’ejcath cau binath c’al a Moisés, in tsalpanchal jahua’ a Jesús antsana’ in ucha’ an tsambe. ");
INSERT INTO husNT1971_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","In tsalpayalchic abal jale’ antsana’ in ucha’, cum expith a Dios jats in cua’al in eyaltal quim paculanchi in hualab an inic. In t’ajal ejtil max pel a Dios, in uluchic tin ichich. ");
INSERT INTO husNT1971_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","A Jesús in exla’its jant’ini’ tu tsalpanchab c’al nixe’ xi exobchixchic, ani jaxtam in ucha’chic: ―¿Jale’ tata’chic tin q’uibts’oth tsalpanchal u ey? ");
INSERT INTO husNT1971_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Yab q’uibat abal nan cu ucha’ an tsambe nan tu paculanchal a hualab, ani yab q’uibat jaye cu ucha’ quit ts’aquiy ani ca thaya’ a tseyte’ tatil ani quit belats. ");
INSERT INTO husNT1971_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Nana’its tin Juntal patal an inicchic, c’al u eyaltal tin jelthom tiquin exlanchi u ey abal u cua’al jaye u eyaltal teje’ tsabal cu paculanchi in hualab an inic. Tam a Jesús in ucha’ an tsambe: ");
INSERT INTO husNT1971_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","―Quit ts’aquiy ca thaya’ a tseyte’ tatil ani quit c’alets ta q’uima’. ");
INSERT INTO husNT1971_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ma tamits ti ts’acpan jelthachits ani in thaya’ in tseyte’ tatil, ani ta c’ale. Patal an inicchic in lej jic’pal tam tin tsu’u jahua’ antsana’ t’ajchinenec an tsambe c’al a Jesús. Jats tim puhuethanchalchic im bij a Dios, in uluchic: ―Ni jayq’ui’ yab i tsu’umal jita’ quin t’aja’ antsana’ i labith t’ajbilab. ");
INSERT INTO husNT1971_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Taley talbel xe’ets a Jesús junil hualchicte’ am pulic lejem. Ulits yan i inicchic jun ti c’uajat jaja’, ani in exobchalchic in cahuintal a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Tam ti ne’ets más hue’ tihua’, in tsu’u a Leví quetel ti bats’c’ul jalbixtalab tumin tin cuenta an gobierno. Pel in tsacamil a Alfeo. A Jesús in ucha’: ―Tiquin ts’at’enchi. Tam cuble a Leví, ani in ts’at’enchi a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ani talbel c’ale a Jesús ti c’apul tin q’uima’ a Leví. Hua’ats taja’ yan axi pel i bats’c’ul jalbixtalab tumin tin cuenta an gobierno ani hua’ats jaye yan q’ue’at i hualbith inicchic. C’uajatchic quetel ti c’apul junax c’al a Jesús ani c’al in exobalilchic. Yan jaja’chic in ts’at’enchamalits a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ani talchic i inicchic axi pel i exobchix c’al an ts’ejcath cau binath c’al a Moisés ani i fariseochic in tsu’u a Jesús antsana’ quetel ti c’apul junax c’al nixe’ xi inicchic. Tam taunab in exobalilchic a Jesús c’al jaja’chic, conoyab antse’: ―¿Jale’ u junax c’apul a Exobchixal c’al nixe’ xi bats’c’ul jalbixtalab tuminchic tin cuenta an gobierno ani q’ue’at i hualbith inicchic? ");
INSERT INTO husNT1971_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Tam ti a Jesús in ats’a’ antsana’ in uluchic, tam in ucha’chic: ―Axi lubach an inic yab in yejenchal i ilalix, expith axi ya’ul ojni’ jats in yejenchal. Nan in che’nec cu caniy ca chich c’al nana’ jitats in lej exlalits tin ichich abal pel i hualbith inic ani iba ax in tsalpayal pel i alhua’ inic. ");
INSERT INTO husNT1971_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Jun a q’uicha tam ti pabil yab u c’apul in exobalilchic a Juan ani in exobalil an fariseochic, tamna’ chich talchic i inicchic c’al a Jesús, ani in conoyal: ―¿Jale’ u pabil yab u c’apul in exobalilchic a Juan ani in exobalil an fariseochic, ani yab u pabil tata’ a exobalilchic? ");
INSERT INTO husNT1971_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","A Jesús in toc’tsiychic: ―Yab in tomnal ca pablats yab ca c’aputs ax u tsa’bixchic c’al an tomquintalab biyat c’uajate an tomquinel inic. ");
INSERT INTO husNT1971_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Max quim baju a q’uicha tixc’anenequits an tomquinel inic, tam ojni’ in tomnal ca pablatschic ani yab ca c’aputs. Tam nan in tixc’anenecaquits, tam ojni’ in tomnal ca pablats u exobalilchic jaye. ");
INSERT INTO husNT1971_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Yab in tomnal ca c’ua’chiyat am biyal toltom c’al i it pejach i toltom, cum tam ca pac’uhuat ne’ets ca muley axi it ani tam ne’ets ca oume in mits’tal axi biyal. ");
INSERT INTO husNT1971_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Yab in tomnal ca baliyat al i biyal balixtalab ot’ in ja’lil an lab t’uthub ax u it boclinalits. Max ani’ ca t’ajan, ne’ets ca mits’c’an an ot’ ani ne’ets ca huac’lan am boc lab t’uthub. Antsana’ ne’ets ca othey am balixtalab ot’ ani ne’ets ca q’uibey am boc. Jaxtam in tomnal ca baliyat in ja’lil an lab t’uthub ax u it boclinalits al i it balixtalab ot’. ");
INSERT INTO husNT1971_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Juni sábado xe’ets a Jesús junax c’al in exobalilchic al jun i t’ayablab lab em, ani in exobalilchic in ts’i’quiyal quim putsiy in hualil an lab em. ");
INSERT INTO husNT1971_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Tam uchan a Jesús c’al an fariseochic: ―Ca tsu’u in t’ajal a exobalilchic tam sábado jahua’ in ulal an ts’ejcath cau binath c’al a Moisés yab quin t’aja’. ");
INSERT INTO husNT1971_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","A Jesús in toc’tsiychic: ―Auxe’ max yab a ajiyamalchic jant’o in t’aja’ a David junax c’al in junquilchic ti jayq’ui’ tam ti c’a’il jaja’chic. ");
INSERT INTO husNT1971_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Otsits jaja’ tin q’uima’ a Dios ani in c’apchi an t’ocat pan axi expith u jilchinal quin c’apu am pale’chic. A Abiatar pel an ts’ale pale’ tam ti tam. Aba ani’ yab pel i pale’ a David, in c’apchi nixe’ xi pan ani im pitha’ in junquilchic quin c’apchi jaye. ");
INSERT INTO husNT1971_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","A Jesús in uchayechic an fariseochic más i cau antse’: ―A Dios im bijiy an sábado abal an inic quin tabatna’, yab ja abal ca huat’ath c’unat abatna an inic c’al an sábado. ");
INSERT INTO husNT1971_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Nana’its pel tin Juntal patal an inicchic ani u cua’al u eyaltal cu ulu jant’o ta ca eyentha an sábado. ");
INSERT INTO husNT1971_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Otsenequits junil a Jesús tin tiyopanil an Israelchic, ani c’uajat taja’ jun i inic axi huayenec in c’ubac. ");
INSERT INTO husNT1971_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ani an fariseochic in lej tsapic co’com a Jesús c’al in hual. Max quin jeltha’ tam sábado an inic, ne’ets quin jolbiy. ");
INSERT INTO husNT1971_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Tam a Jesús in ucha’ an inic axi huayenec in c’ubac: ―Quit ts’aquiy ani quit cubiy teje’. ");
INSERT INTO husNT1971_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Tam a Jesús in conoy an fariseochic: ―¿Jant’o tu jilalchic an ts’ejcath cau binath c’al a Moisés qui t’aja’ tam sábado? ¿Qui t’aja’ alhua’ o qui t’aja’ yab alhua’? ¿Qui jeltha’ axi ya’ul o qui jila’ ca tsemets? Ani an fariseochic yab in elal jant’ini’ ta ca toc’tsin. ");
INSERT INTO husNT1971_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Tam a Jesús tocat in met’alchic c’al in hual tsacunec. Jaye in yajnal, cum jaja’chic yab in le’ quin ejtiy an cau jahua’ ti conoyat. Tam a Jesús in ucha’ axi huayenec in c’ubac: ―Xo’ ca lemc’a’ a c’ubac. In lemc’a’, cum jelthachits. ");
INSERT INTO husNT1971_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Tam cale an fariseochic, c’ale quin ts’ejca’ an cau c’al axi ts’at’atchic c’al a Herodes jant’ini’ ti quin tsemtha’ a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Taley c’ale a Jesús junax c’al in exobalilchic tin hualchicte’lil am pulic lejem, ani ts’at’enchab c’al yantalam i inic Galileajibchic. ");
INSERT INTO husNT1971_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Tam ti tso’obnab a Jesús abal xe’ets in t’ajal i pulic t’ajbilab, tam ti chich yan i inicchic tal ti Judea, ani ti Jerusalén, ani ti Idumea, ani jum poq’ue’ am pulic itse’ Jordán, ani ti Tiro ani ti Sidón. In le’chic quin tsu’u a Jesús jant’o in t’ajal. ");
INSERT INTO husNT1971_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Cum lej mulcunenec yan i inic, a Jesús in ucha’ in exobalilchic ca t’ojojonchat jun i tan jun ti ca otsits max ca más q’uits’c’omane an mulcunel inicchic. ");
INSERT INTO husNT1971_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ani cum lej yantalam i inicchic in jelthamal a Jesús, jaxtam u lej q’uits’c’omayab cum le’nab max ca ejtohuat ca tacan c’al an ya’ulchic. ");
INSERT INTO husNT1971_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Chich jaye ax u co’oyabchic c’al i at’ax teneclab, ani in tuthuhualchic in c’ualal tin tamet a Jesús. Ani lej tsapic thajanthab c’al an at’ax teneclab, thajat uchan a Jesús antse’: ―Tata’its pel ti Tsacamil a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ani tam a Jesús in lej ucha’chic: Ni jita’ yab ca olchi nana’ u ey. ");
INSERT INTO husNT1971_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Taley talbel c’athiy a Jesús al i bolchal, ani tats tin caniy jitats jaja’ in le’nanchal ca chich c’al jaja’. Ani chichchic. ");
INSERT INTO husNT1971_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Hua’ats lajuj tsab i inic ax in tacuy ca xe’tsin c’al jaja’ ani quin abatna’ ti thajchixchic c’al in cahuintal a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Im pitha’chic i eyaltalab abal ti jelthom c’al i ya’ul ani ti canchix c’al i at’ax teneclab. ");
INSERT INTO husNT1971_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Im bijchic axi lajuj tsab tacuthits antsana’chic: Pel a Simón Pedro. ");
INSERT INTO husNT1971_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Pel a Jacobo ani jaye in ebchal Juan axi tsacamlabchic c’al a Zebedeo. U bijiyab jaye xi tsablom ta Boanerges, cum lej tsapic in janith in cahuintal ejtil an mamlab. ");
INSERT INTO husNT1971_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Pel a Andrés, ani a Felipe, ani a Bartolomé, ani a Mateo, ani a Tomás, ani a Jacobo axi pel in tsacamil a Alfeo, ani a Tadeo, ani a Simón axi pelac i ts’at’el c’al an cuenel ax u bijiyab ti cananista. ");
INSERT INTO husNT1971_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Taley pel a Judas Iscariote axi ne’ets quin tsinat bina’ a Jesús tin c’ubac in tomolnaxilchic. Taley talbel otsits a Jesús al jun i ata junax c’al in exobalilchic. ");
INSERT INTO husNT1971_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ani junil u mulcunal lej yan i inicchic ca tolminchat c’al a Jesús, ma yab u jolc’anal c’al in exobalilchic ca c’aputs. ");
INSERT INTO husNT1971_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ani ulits taja’ axi pelchic in at ja’ub xits’al ax tin q’uima’ a Jesús abal quin ne’tha’, cum olmanitscua’ jaja’. Antsana’ in uluchic. ");
INSERT INTO husNT1971_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Hua’ats taja’ jaye i exobchixchic c’al an ts’ejcath cau binath c’al a Moisés. In ulalchic abal u co’oyab a Jesús c’al an ts’ale at’ax teneclab a Beelzebú, ani jats c’al tin calthal i at’ax teneclabcua’. ");
INSERT INTO husNT1971_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Tam a Jesús in caniychic ca chich c’al ax tu uxnal antsana’, abal quin olchi i t’ipchixtalab. In ucha’chic: ―Auxe’ max a Satanás quin tomolna’ ani quin caltha’ in at teneclab tin ichich an inic. Iba. ");
INSERT INTO husNT1971_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Max i bichou ca lehuáxin ani ca cuete’ pejéxin, ne’ets ca talabetha. ");
INSERT INTO husNT1971_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Jaye max ca pejéxin i q’uimathchic ani ca buc’láxin, yab ne’ets ca ohuey. ");
INSERT INTO husNT1971_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ani a Satanás max quin tomolna’ ani quin caltha’ in at teneclab tin ichich an inic, ne’ets ca talabetha in tsap ti abatnom tin ichich i inic. ");
INSERT INTO husNT1971_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ni jita’ yab in ejtohual ca otsits tin q’uima’ i tsapic inic quin calthanchi jahua’ in cua’al max yab oc’ox quin yac’ua’ ani quin huic’a’ an tsapic inic. Expith max huic’athits, tam ojni’ ne’ets quin ejtou quin calthanchi jahua’ in cua’al tin q’uima’. ");
INSERT INTO husNT1971_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Lej chubax nan tu uchalchic abal a Dios in ejtohual quim paculanchi an inicchic patal jahuaquits tam hualabtalab quin t’aja’ ani i quithab cau quin ulu. ");
INSERT INTO husNT1971_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Expith yab ne’ets quim paculanchi jitats quin quithab cahuiliy an Espiritu Santo. Jitats quin ulu abal in t’ojlabil an Espiritu Santo pel in t’ojlabil an teneclab, jats ojni’ ne’ets ca jilc’on jolbibith abal ets’ey c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Antsana’ a Jesús in ucha’chic nixe’ xi exobchixchic, cum jaja’chic in ulumal abal a Jesús co’oyab c’al i at’ax teneclabcua’. ");
INSERT INTO husNT1971_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Taley ulits in mim ani in ebchalchic a Jesús jun ti c’uajat jaja’. Jilc’onchic eleb biyat in abchal i cau a Jesús abal ca cale ti tsu’tab. ");
INSERT INTO husNT1971_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ani olchinal an cau axi quetechic taja’ c’al a Jesús, ani jaja’chic in olchi a Jesús. Uchan: ―Te c’uajatchic eleb a mim ani a ebchalchic ti aliyal. ");
INSERT INTO husNT1971_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ani a Jesús toc’tsin: ―¿Jita’ ax a tsalpayalchic nana’ u ajiyal pel u mim ani pel u ebchalchic? ");
INSERT INTO husNT1971_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Tam a Jesús in met’alchic axi quetechic tin tonith, ani in ucha’chic: ―Axe’chic axi te c’uajat c’al nana’ ja’its ax u ajiyal tu mim ani tu ebchalchic. ");
INSERT INTO husNT1971_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ani jitats quin t’ajchi in culbetal a Dios, ja’its axi pel u mim ani pel u ebchalchic. ");
INSERT INTO husNT1971_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Taley in ts’i’quiy junil a Jesús ti exobchix hualchicte’ am pulic lejem, ani taja’ mulcunal yan i inicchic. Cum lej q’uits’c’omathits an mulcunel, otsits a Jesús al jun i tan. Tats ti buxcan ti exobchix, ani an mulcunel jilc’on hualchicte’ am pulic lejem. ");
INSERT INTO husNT1971_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","In exobchalchic c’al yan i jalpith cau antse’: ");
INSERT INTO husNT1971_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―Ca lej bina’chic a xutsun c’al jahua’ ne’ets tu ucha’. C’ale ti buc’ul jun i buc’ul iyalab lab em. ");
INSERT INTO husNT1971_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Xe’ets ti buc’ul ani ijcan talchic i iyalab ti al am bel. Chich taja’ an ts’itsinchic in c’apts’u an iyalab. ");
INSERT INTO husNT1971_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Talchic i iyalab ijcan jaye jun ti hua’ats yan i t’ujub ani yab lej anmith. Taja’ thubat cale an iyalab cum lej huecats an anam. ");
INSERT INTO husNT1971_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Tam ti calejits a q’uicha lej tsapic an c’ac’al, tam ti tala’ huayts’on cum yab luputh in ibil. ");
INSERT INTO husNT1971_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Talchic i iyalab ijcan jaye jun ti hua’ats yan i q’uith. Taja’ cale ani tala’ paxq’uiyatits, cum lej puhueyits an q’uithchic. Yab im bina’ ni jun in hualil. ");
INSERT INTO husNT1971_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Talchic i iyalab ijcan jaye jun ti alhua’ an tsabal. Taja’ cale ani puhuey, ani im bina’ yan in hualil. Talchic i acan im bina’ ti ox i lajuj in hualil, ani talchic ti ox inic, ani talchic ti bo’ inic. ");
INSERT INTO husNT1971_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Tam a Jesús in ucha’ an mulcunel: ―Jitats junat in ichich c’al nana’ u ichich, quin lej alhua’ bina’ in xutsun c’al axe’ xi cau. ");
INSERT INTO husNT1971_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","C’alnequits an mulcunel, ani jilc’oneneque c’al a Jesús tsab ox i inicchic ani xi lajuj tsab in exobalilchic in conoyal jant’o in le’ quin ulu nixe’ xi jalpith cau c’al am buc’ul iyalab lab em. ");
INSERT INTO husNT1971_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Tam a Jesús in ucha’chic: ―A Dios ti tso’oblinchal tata’chic jant’ini’ tin t’ajal ti Ts’ale, ani nan u taunal c’al i jalpith cau an inicchic axi yab im belal an chubaxtalab. ");
INSERT INTO husNT1971_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Quin met’a’ jaja’chic jahua’ u t’ajal, ani ejtil max tam yab in lej tsu’tal. Quin ots’ohuiy in cahuintal a Dios jahua’ u olchal, ani ejtil max tam yab in lej ats’al. Jaxtam yab u huenc’onal c’al a Dios ani yab u paculanchab in hualabchic. ");
INSERT INTO husNT1971_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","A Jesús in uchayechic: ―¿Jale’ yab a ejtiyalchic axe’ xi jalpith cau? ¿Max yab a ejtiyalchic ax, jant’ini’ tam ne’ets ca ejtiy más i cau axi nan ne’ets tu olchiyechic? ");
INSERT INTO husNT1971_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Am buc’ul iyalab lab em ejtil ax u olnom c’al in cahuintal a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","An iyalab axi ijcanenec al am bel jats ejtil an inic axi quin ats’anchi in cahuintal a Dios tin ichich ani ca tixc’anchat c’al a Satanás. ");
INSERT INTO husNT1971_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","An iyalab axi ijcanenec al an tsabal jun ti hua’ats yan i t’ujub jats ejtil an inic axi quin ats’anchi in cahuintal a Dios tin ichich c’al i culbeltalab. ");
INSERT INTO husNT1971_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Tocat cum yab lej luputh ibibin tin ichich, jaxtam yab in ohuat belal. U t’apchinal im belomtal tam ca yajchiquiyat ani ca othna tin ebal abal im belamal in cahuintal a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","An iyalab axi ijcanenec jun ti hua’ats yan i q’uith, jaye ejtil an inic axi quin ats’anchi in cahuintal a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Bel in lej xijc’ath tsalapnal ani in junini’ c’a’inchal jahua’ hua’ats teje’ tsabal, ani u lej c’ambiyab c’al an ricotalab. Antsana’ u t’u’thithinchab in ichich c’al jahua’ teje’ tsabal, ma yabats u lejel ca t’ayat c’uajiy in cahuintal a Dios tin ichich. Jaxtam yab in t’ajal jahua’ alhua’ c’al a Dios, ani pel ejtil i acan lab em axi yab im binal in hualil. ");
INSERT INTO husNT1971_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","An iyalab axi ijcanenec jun ti alhua’ an tsabal jats ejtil an inic axi quin lej alhua’ ats’anchi in cahuintal a Dios tin ichich ani ca lej alhua’ t’aychin taja’. Jaxtam in lej t’ajal jahua’ alhua’ c’al a Dios. Pelchic ja ejtil i acan lab em ax im binal in hualil ti jun inic lajuj, ani talchic ti ox inic, ani talchic ti bo’ inic. ");
INSERT INTO husNT1971_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","A Jesús in uchayechic: ―Auxe’ max ca paxq’uiyat i lec’utsith tajablab c’al i poc’te’ o max ca c’uajba tin alam i huaytalab tsey. Iba. U c’uajbab jun ti t’ec’at abal quin tala’ tajbay alta ti al an ata. ");
INSERT INTO husNT1971_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Patal jahua’ xohue’ u tsincacayab c’al i jalpith cau, talbel ne’ets ca tala’ tejhua’methanchat ani ca tala’ lejquinchat an inicchic. ");
INSERT INTO husNT1971_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Jitats junat in ichich c’al nana’ u ichich, quin lej alhua’ bina’ in xutsun c’al axe’ xi cau. ");
INSERT INTO husNT1971_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","A Jesús in uchayechic: ―Ca lej t’aja’ ti cuentachic ca alhua’ bina’ a xutsun c’al in cahuintal a Dios. Max hue’ ta ca bina’ a xutsun ca ats’anchi, tocat lej hue’ ne’ets ca ejtiy. Max jum putat ca bina’ a xutsun ca ats’anchi, ne’ets ca alhua’ ejtiy lej yan ani a Dios ne’ets ti pithaye ca más exla’. ");
INSERT INTO husNT1971_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Jitats in lej bats’umalits tin ichich in cahuintal a Dios, jats axi ne’ets ca pithane más. Jitats tocat eblim im bats’umalits hue’ in cahuintal a Dios, jats axi ne’ets ca tixc’anchat. ");
INSERT INTO husNT1971_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","A Jesús in uchayechic: ―Jant’ini’ ca t’ayan jun i iyalab ithith ti tsabal ani ca cale ani ca puhuey, antsana’ tin t’ajal a Dios ti Ts’ale tin ichich an inic. ");
INSERT INTO husNT1971_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Patal an acal u huayal ani patal a q’uicha u ejtsinal nixe’ xi inic ax in t’ayamal an iyalab. An iyalab u cuete’ calel ani u puhuel, ani yab in tso’ob an inic jant’ini’ tu calel ani tu puhuel. ");
INSERT INTO husNT1971_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","C’al in huinat alhua’ an tsabal jats tu calel ani jats tu puhuel an ithith. Ne’ets puhuehuel in xequel ani tam quim baju in q’uijil, tam u t’uchbinal. Tam talbel u c’oc’tsinal. ");
INSERT INTO husNT1971_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Tam ca payeyits an huay’, tam ne’ets an c’ojol quin tamcuy. ");
INSERT INTO husNT1971_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","A Jesús in uchayechic: ―Nan ne’ets tu olchiyechic i jalpith cau jant’ini’ tin t’ajal a Dios ti Ts’ale. ");
INSERT INTO husNT1971_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ca t’ayan i iyalab mostaza ti tsabal, pel xe’ axi más tsipichic c’al patal an iyalab. ");
INSERT INTO husNT1971_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Tam t’ayathits ani calejits ani puhueyits, in atal axi patal an ts’ojol t’ayablab. U pactha’bel in c’ue’elchic, ma an ts’itsinchic u che’el quin ts’ejca’ in c’util taja’ ejtil max pel i te’. ");
INSERT INTO husNT1971_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Antsana’ a Jesús in exobchalchic an inic c’al yan i jalpith cau ma ju’tam huichat u ejtohuab ca ejtinchat. ");
INSERT INTO husNT1971_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Expith in taunal c’al i jalpith cau axi yab pel in exobalilchic, ani axi pel in exobalilchic jats in lejquinchal an jalpith cau jant’o in le’ quin ulu. ");
INSERT INTO husNT1971_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Tameq’ui nixe’ xa q’uicha tam ti aclejits, a Jesús in ucha’ in exobalilchic: ―Cu c’alechic tihua’ jum poq’ue’ am pulic lejem. ");
INSERT INTO husNT1971_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Tam tixc’an in exobalilchic c’al an mulcunel, ta c’alechic junax c’al a Jesús al an tan jum poq’ue’ am pulic lejem. C’uajat jaye más q’ue’at i tanchic axi ne’ets c’al a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Tam thayc’an jun i ic’ lej tsapic al am pulic lejem. U lej lanq’uil an ja’ c’al an tsapic ic’, ma ne’ets t’uchichilits an tan c’al an ja’. ");
INSERT INTO husNT1971_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ani a Jesús huayamath al i lachic’lab tin cux an tan. Tam ejtsintha c’al in exobalilchic ani uchan: ―¿Exobchix, jale’ yab a t’ajal ti cuenta max cu uc’tsin? ");
INSERT INTO husNT1971_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Tam ts’aquiy a Jesús in c’uiyath tauna’ an ic’ ani an ja’ antse’: ―Quit cubiy ani yabats quit lanq’uilats. Ani tam t’ajat cubiyits an ic’ ani yabats lanq’uil an ja’. ");
INSERT INTO husNT1971_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Tam a Jesús in conoy in exobalilchic: ―¿Jale’ it lej jiq’uelchic? ¿Jale’ yab tim belal? ");
INSERT INTO husNT1971_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Tamna’ in lej jic’palchic ani in conoyal: ―¿Jita’ tam inic hualam jaja’ abal in ejtohual quin abatna’ an ic’ ani an ja’? ");
INSERT INTO husNT1971_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Taley ultsitschic a Jesús ani in exobalil jum poq’ue’ am pulic lejem ti tsabal Gadara. ");
INSERT INTO husNT1971_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Tam ti calejits a Jesús ti al an tan, ta ti tal jun i inic ax u co’oyab c’al i at’ax teneclab. U c’uajil ti al i jolimtalab tsemelom. ");
INSERT INTO husNT1971_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Tats tu c’uajil ani ma c’al ni jita’ tam inic yab u ejtohuab ca ohuat huic’an, ni c’al i calaniyo pat’al. ");
INSERT INTO husNT1971_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Yan i calat tu huic’nal c’al i calaniyo pat’al tin acan ani tin c’ubac, ani tocat in tala’ t’apiyal ani in tala’ mu’uhual. Ma c’al ni jita’ tam inic yab u ejtohuab ca maxubetha. ");
INSERT INTO husNT1971_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Tam q’uicha ani tam acal xe’ets ti thajajal ti ts’en ani al nixe’ xi jolimtalab tsemelom. In cuete’ ts’ojbethachical tim ba’ c’al i t’ujub. ");
INSERT INTO husNT1971_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Tam tin tsu’u a Jesús ta ti tal hue’ ou, tam ti athlats abal quim baju. Ultsits in tuthuhual in c’ualal tin tamet. ");
INSERT INTO husNT1971_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ani an at’ax teneclab ax tin ichich tocat in thajanthal quin ucha’ a Jesús antse’: ―Tata’its pel it Jesús ti Tsacamil a t’ec’at pulic Pay’lom Dios ti eb. ¿Jant’o tam eyaltalab a cua’al abal tiquin ots’anchi? Nan tu lej uchal tim bij a Dios yab tiquin yajchiquiy. ");
INSERT INTO husNT1971_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Antsana’ in ulu an at’ax teneclab, cum uchanits c’al a Jesús abal ca tixc’an tin ichich nixe’ xi inic. ");
INSERT INTO husNT1971_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Tam conoyab an at’ax teneclab c’al a Jesús: ―¿Jant’o tata’ a bij? Toc’tsin: ―Nana’ u bij Legión. Jats u bij cum c’uajat c’al nana’ yantalam u juntal. ");
INSERT INTO husNT1971_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Tam nixe’ xi jun an at’ax teneclab in lej canat ucha’ a Jesús abal jaja’ ani c’al in juntalchic ca pithan an q’uij ca jilc’on al nixe’ xi c’uajattalab jun ti c’uajatits. ");
INSERT INTO husNT1971_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Taja’ hue’ utat xe’ets jun i pulic cuenel i olom ti ac’ul al i bolchal. ");
INSERT INTO husNT1971_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Tam patal nixe’ xi at’ax teneclab in lej canat ucha’ a Jesús antse’: ―Tucu pitha’ an q’uij abal qui c’uajchiy tin inictal nixe’ xi olomlom. ");
INSERT INTO husNT1971_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Tam a Jesús in ucha’chic bel. Tam tixc’an nixe’ xi at’ax teneclabchic tin ichich an inic ani otsits tin inictal an olomlom. Ani tam nixe’ xi tsab i nni i olomchic jololol ti c’ale ti al an cotoblom, ani ta tala’ ijcachiquinits al am pulic lejem jun ti t’ajat uc’tsinchic. ");
INSERT INTO husNT1971_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Taley am beletnomchic c’al an olomlom c’ale athithil ti bichou ani ti alte’ q’uimathchic quin olna’ jahua’ in t’ajamal a Jesús. Ani c’ale am bichou quin tsu’u jahua’ t’ajnenec c’al a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ulitschic c’al a Jesús ani in tsu’u quetel toltomith an inic axi canchinenec an at’ax teneclabchic. In tsu’u alhua’methachits in tsalap. Ani lej jiq’ueychic axi chich am bichou. ");
INSERT INTO husNT1971_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Tam u olchinal jaja’chic c’al ax in oc’ox tsu’uchic jant’ini’ ti canchinenec an inic an at’ax teneclabchic ani jant’ini’ ti uc’tsin an olomlom. ");
INSERT INTO husNT1971_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Tam patal an inic axi muthatchic taja’ in lej ucha’ a Jesús abal ca lejat tixc’an ani yabats ca xe’tsin al nixe’ xi cuenchal. ");
INSERT INTO husNT1971_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Taley otsits a Jesús al an tan xan ti che’necac, ani lej canat conoyab c’al axi canchinenec an at’ax teneclabchic max ca pithan an q’uij ca ts’at’ey c’al jaja’. ");
INSERT INTO husNT1971_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","A Jesús yab im pitha’ an q’uij ca ts’at’ey, tocat in ucha’: ―Quit c’ale ta q’uima’ ani c’al a at ja’ubchic xits’al ca t’iloxnanchi patal jant’o a Dios ti t’ajchamal tin ebal in c’anithomtal. ");
INSERT INTO husNT1971_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ani ta c’ale in t’iloxnanchal am bichouchic axi cuentalith ti Decápolis patal jahua’ t’ajchinenec c’al a Jesús. Ani patal jita’ olchinal in lej jic’panchal jahua’ t’ajchinenec nixe’ xi inic. ");
INSERT INTO husNT1971_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Taley tal a Jesús al an tan ani huichits junil jum poq’ue’ am pulic lejem. C’uajat jaja’ tin hualte’lil am pulic lejem tam ti chich yantalam i inic. ");
INSERT INTO husNT1971_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Tam chich jun i inic im bij pel a Jairo axi pel i oc’lec tin tiyopanil an Israelchic. In tsu’u a Jesús taja’, ani utey tin tamet in tuthuhual in c’ualal. ");
INSERT INTO husNT1971_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","In lej canat ucha’: ―Lej talec’ u ts’ic’achil. U lej le’ max ca ejtou quit c’ale ca punchi a c’ubac abal ca jeltha’ ani yab ca tsemets. ");
INSERT INTO husNT1971_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Tam a Jesús ta ne’ets junax c’al a Jairo tin q’uima’. Ani cum ts’at’enchab c’al yantalam i inic lej q’uits’c’omath ne’ets a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ani c’uajat ti al an cuenel jun i uxum ax in cua’al lajui tsab i tamub yab u tajlunal ti ya’ul ta its’. ");
INSERT INTO husNT1971_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","In lej ohuat yajchicnamalits an yau’lats, ma c’al yanits i ilalix ti ilaliyamejits. In tala’ pacumalits an tumin ax in cua’alac ani yab u elabme, tocat u c’alchinal. ");
INSERT INTO husNT1971_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Tam tin ats’a’ abal u t’ilnal a Jesús c’al an mulcunel, tamna’ utey tin cux a Jesús ani in tacchi in toltomil. ");
INSERT INTO husNT1971_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Antsana’ in t’aja’ cum in cuete’ ulumalits tin ichich max expith quin tacchi in toltomil ne’ets ca jeley. ");
INSERT INTO husNT1971_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Tameq’ui t’ithpanits in xits’al. In exbayal tin inictal abal c’uajatits jelenec. ");
INSERT INTO husNT1971_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Tameq’ui a Jesús in exla’its tin lej ichich abal hua’ats jita’ jelthame c’al jaja’ in lej tsap ti jelthom. In met’al tin cux an mulcunel ani in conoyal: ―¿Jita’ tin tacchi u toltomil? ");
INSERT INTO husNT1971_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Tam uchan c’al in exobalilchic: ―A tsu’talits abal ti lej q’uits’c’omayal an mulcunel ani a conoyale jita’ ti tacchi a toltomil. ");
INSERT INTO husNT1971_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Tam a Jesús in met’c’achiquiyal tin tonith max quin exla’ jita’ c’al ti tacchinenec in toltomil. ");
INSERT INTO husNT1971_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Tam nixe’ xi uxum lej jiq’uel, ma t’elelel cum in tsalpayal abal ne’ets ca exlajits abal jaja’ in tacchamal in toltomil a Jesús. Tam chich tin tamet a Jesús in tuthu in c’ualal, ani in olchi an chubaxtalab abal ja’its jaja’ ax in tacchamal in toltomil. ");
INSERT INTO husNT1971_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ani uchan an uxum c’al a Jesús: ―Mimlab, nan tu jeltha’ cum tim belamal. Quit c’ale c’al a ichich ts’aclalathits cum it jelnequits. ");
INSERT INTO husNT1971_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Tam tu cahue a Jesús c’al an ts’at’elchic, tam ti ulits i inicchic axi tal ma tihua’ tin q’uima’ a Jairo. Ani uchan a Jairo c’al jaja’chic: ―Cum tihua’ tsemetsits a ts’ic’achil, yabats ca ucha’ an Exobchix ca c’ale quin jeltha’. ");
INSERT INTO husNT1971_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","A Jesús lejat yab in t’aja’ ti cuenta max antsana’ uchan a Jairo, tocat in ucha’ a Jairo: ―Yab quit jiq’uey c’al jahua’ it uchan, tocat ca lej bela’ abal nan u ejtohual tu tolmiye. ");
INSERT INTO husNT1971_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Tam a Jesús in ne’tha’ ca c’ale junax c’al jaja’ a Pedro, ani a Jacobo, ani a Juan in ebchal a Jacobo. Jats expith in ne’tha’. ");
INSERT INTO husNT1971_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Tam ti ulitschic tihua’ tin q’uima’ a Jairo, a Jesús in ats’a’ xacuecuel axi muthatchic taja’. Tocat u uc’nal ani u thajnalchic. ");
INSERT INTO husNT1971_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Otsits a Jesús ani in ucha’chic: ―¿Jale’ it lej xacuecuel ani it uc’nalchic? Yab tsemenec an ts’ic’ach, u huayal expith. ");
INSERT INTO husNT1971_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","C’al axe’ xi cau jahua’ in ulu a Jesús, tocat u tilibnath te’nal axi muthatchic. Tam a Jesús in ucha’ ca tala’ cale axi c’uajat altachic. In ne’tha’ expith in tata ani in mim an ts’ic’ach, ani in exobalilchic jun ti c’uajat an tsemelom ts’ic’ach. ");
INSERT INTO husNT1971_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Tam a Jesús in yac’uchi in c’ubac ani in ucha’: ―Talita cumi. Ti tenec cau in le’ quin ulu, ts’ic’ach quit ts’aquiy. ");
INSERT INTO husNT1971_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Tameq’ui ts’acpan an ts’ic’ach ani belats. In cua’al lajuj tsab i tamub. In lej jic’pal an inicchic abal ejtha axi tsemenecac. ");
INSERT INTO husNT1971_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ani a Jesús in lej uluth ucha’ axi c’uajatchic abal ni jita’ yab quin olchi abal jaja’ in ejthamal an tsemelom ts’ic’ach. Taley in ulu ca pijchin an ts’ic’ach. ");
INSERT INTO husNT1971_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Taley tixc’an a Jesús tin q’uima’ a Jairo, ta huichiy tim bichou junax c’al in exobalilchic. ");
INSERT INTO husNT1971_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Taley pel i sábado ani c’uajat ti exobchix a Jesús tin tiyopanil an Israelchic tim bichou. Yantalam i inic in ats’anchal ani in lej jic’panchal in exobchixtal. In uluchic: ―¿Ju’ta tin ela’ patal axe’ xi cau axe’ xi inic? ¿C’al jita’ ti pithanchat ja in lej tsalpathtal, ani jant’ini’ tin lej ejtohual quin t’aja’ i labith t’ajbilab? ");
INSERT INTO husNT1971_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","I exlalq’ui ti thacum te’. Pel in tsacamil a Maria, ani pel in ebchal a Jacobo, ani a José, ani a Judas, ani a Simón. Ani u c’uajil jaye teje’ c’al huahua’ in uxum ebchalchic. Antsana’ u t’apchinal in tsalap nixe’ xi inicchic yab in tequeth exlanchi in lej ey a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jaxtam a Jesús in ucha’chic: ―U c’ac’nab axi caulome c’al a Dios abal ju’tamq’ui c’al tim patal an inicchic, expith yab u c’ac’nab c’al in at bichou, ani c’al in at ja’ubchic xits’al, ani c’al axi tin cuete’ q’uima’. ");
INSERT INTO husNT1971_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Cum yab u belnal a Jesús c’al an inicchic tihua’ tim bichou, jaxtam yabats in t’ajal yan i labith t’ajbilab taja’. Expith in mo’cal in c’ubac c’al tsab ox i ya’ul abal quin jeltha’. ");
INSERT INTO husNT1971_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","In jic’pal a Jesús abal jale’ yab u belchinal in lej ey. Aba ani’, bel xe’ets ti exobchix al i bichouchic axi utat taja’ tim bichou. ");
INSERT INTO husNT1971_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Taley a Jesús in caniy ca chich c’al jaja’ axi lajuj tsab in exobalilchic abal quin aba’ tin t’ojlabil. In ucha’chic ca xe’tsin ti tsabchic tin eb. Im pitha’chic i eyaltalab abal ti canchix c’al i at’ax teneclab. ");
INSERT INTO husNT1971_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","In ucha’chic quin ne’tha’ expith i cuayablab tam ne’ets ti bel. Yab quin ne’tha’ i morral, ni i pan, ni i tumin. ");
INSERT INTO husNT1971_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Quin xe’tsintha’ i pajablab axi yab lej huinat alhua’. Quin ne’tha’ expith juncats i toltom ax in ca’quimits. ");
INSERT INTO husNT1971_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","In uchayechic más i cau antse’: ―Al an ata jun ti quit bats’uhuat, tats quit junini’ c’uajiy ma tam ti ne’etsits quit cale al nixe’ xi bichou. ");
INSERT INTO husNT1971_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Max jun i bichou yab ti bats’uhual ani yab ti ats’anchal a cahuintal, tam quit tixc’an taja’ c’al jaja’chic. Am pojoth jahuats ca tha’u ta acan al nixe’ xi bichou, ca tininiy tam ne’ets quit tixc’an. Antsana’ ta ca t’aja’ abal quin alhua’ tso’obna’ an inicchic taja’ abal yab alhua’ in t’ajamal cum im pojcanchamal in cahuintal a Dios. Lej chubax nan tu uchalchic abal jaja’chic ne’ets ca c’athpich yajchiquiyat tam quim baju an q’uicha tam ca ts’ejca c’al a Dios. Ma an Sodomajibchic ani an Gomorrajibchic c’al im pojcaxtal axi ti biyal yab ne’ets ca c’athpich yajchiquiyat jant’ini’ jaja’chic axi yab ti bats’uhual. ");
INSERT INTO husNT1971_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Tam ti antsana’its uchanchic in exobalil c’al a Jesús, ta c’aletschic. Xe’ets in olnanchalchic in cahuintal a Dios c’al an inicchic ca jic’tson c’al in hualab ani ca huenc’on c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Jaye in canchal i at’ax teneclab an inicchic, ani in mauchal i aceite yantalam i ya’ul inicchic ani in jelthalchic. ");
INSERT INTO husNT1971_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Cum lej t’iloxnanchab in labith t’ajbilchic a Jesús c’al jat’hua’ tim patal an inicchic, olchinal jaye an ts’ale Herodes. In ulu jaja’ tamna’: ―Axe’ xi inic jats a Juan pujax axi tsemenecac ani xo’ ejthachits, ani jaxtam in cua’al in lej tsap quin t’aja’ i labith t’ajbilab. ");
INSERT INTO husNT1971_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Talchic i inic taja’ in ulu: ―Ja’its jaja’ pel an caulome a Elias. Q’ue’atchic in ulu: ―Ja’its pel i caulome c’al a Dios ejtil axi biyal caulome c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Tam tin ats’a’ a Herodes jant’ini’ tin ulu an inicchic taja’, tam jaja’ in ulu: ―Ojni’ ja’its jaja’ pel a Juan pujax axi tsemenecac ani xo’ ejthachits. Ja’its jaja’ ax u aba’ an cau ca muts’inchat in oc’. ");
INSERT INTO husNT1971_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Antsana’ tin ulu a Herodes cum ti jayq’ui’ in aba’ an cau ca baliyat a Juan ti huic’axte ani ca huic’an c’al i calaniyo pat’al, cum a Herodías antsana’ in le’ ca t’ajchinchat a Juan. Nixe’ a Herodías pel in tomquil a Felipe axi’ pel in ebchal a Herodes. Ani juncunenec jaja’ c’al a Herodes. ");
INSERT INTO husNT1971_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Uchanits ti jayq’ui’ a Herodes c’al a Juan antse’: ―Yab alhua’ ax a t’ajal a co’onchal in tomquil a ebchal. ");
INSERT INTO husNT1971_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Jats ti lej tsacuy a Herodías ani in lej le’ max quin t’ajat tsemtha’ a Juan. Tocat yab in ejtou quin tsemtha’. ");
INSERT INTO husNT1971_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Ani cum a Herodes in exla’its abal a Juan pel i pututh inic t’ocat ti xe’ets, jaxtam in c’ac’nal. Ani yab in jilchi a Herodías quin t’ajchi jant’o yab alhua’ a Juan. Ani lej canat a Herodes quin ats’a’ an cau jahua’ in olnal a Juan, aba ani’ yab in alhua’ ejtiyal. ");
INSERT INTO husNT1971_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Talbel im baju a q’uicha tam ti a Herodías in ejtou quin ts’ejca’ an cau c’al a Herodes jant’ini’ ta ca tsemthanchat a Juan. Pel a q’uicha tam tin t’ajal an ajib tin tamub a Herodes. Mulcunenequits ti c’apul c’al i ts’alat c’apnel patal an oc’lecchic, ani an eyalchic, ani axi q’ue’atchic c’athpich pulic in ey ti bichoulom Galilea. ");
INSERT INTO husNT1971_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Otsits in ts’ic’achil a Herodías taja’ jun tu c’apulchic, ani bixom. Ani a Herodes in tsu’u lej q’uijith ti bixom an ts’ic’ach. Jaye q’uijith tsu’tab ti bixom c’al axi taja’chic in at juntal c’apul c’al jaja’. Tam uchan an ts’ic’ach c’al a Herodes: ―Tiquin conchi jahua’ tata’ ca le’na’, ani nan ne’ets tu pitha’. ");
INSERT INTO husNT1971_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Tam in lej cuba’ tim ba’ ti chubax a Herodes abal lej chubax ne’ets quim pitha’ an ts’ic’ach jahuaquitsq’ui ta ca conchin, ma tam ts’ejel jahua’ in cua’al ti ts’ale max quin le’nanchi. ");
INSERT INTO husNT1971_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Tam calpan an ts’ic’ach, ta c’ale quin conoy in mim antse’: ―¿Jant’o cu conchi? Toc’tsin in mim: ―Ca conchi in oc’ a Juan pujax. ");
INSERT INTO husNT1971_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Tam otscan junil an ts’ic’ach jun ti c’uajat an ts’ale Herodes, ani in ucha’: ―Ma xohue’itscua’ u le’ in oc’ a Juan pujax al jun i talab. ");
INSERT INTO husNT1971_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Tam lej t’e’pinal an ts’ale c’al nixe’ xi cau. Bel cum im cubamalits tim ba’ ti chubax ani jaye ats’anchamejits jahua’ in ulu c’al an ajibalchic, jaxtam ne’ets quim putu c’al jahua’ in ulumalits. ");
INSERT INTO husNT1971_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Thubat an ts’ale in aba’ an soldado abal ca chanchin in oc’ a Juan. ");
INSERT INTO husNT1971_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ta c’ale ba’ an huic’axte’. In muts’inchi in oc’ a Juan ani in chanchi a Herodes al jun i talab. Tam a Herodes im pithanchi an ts’ic’ach ani an ts’ic’ach in huat’banchi in mim. ");
INSERT INTO husNT1971_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Tam tin ats’a’ in exobalilchic a Juan abal jaja’ tsemthachits, tam c’alechic quim penchi in inictal. In nenchi abal quin joliy. ");
INSERT INTO husNT1971_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Jun a q’uicha talbel tamcun in abathualejilchic a Jesús c’al jaja’, in tala’ t’ilchal jahua’ in t’ajamalchic ani jahua’ in exobchamalchic. ");
INSERT INTO husNT1971_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Tam uchanchic c’al a Jesús: ―Huana cu c’ale tu coyol hue’ al jun i c’uajattalab pil. Antsana in ulu, cum yabats u jolc’anal jaja’chic ca c’aputs c’al tin ebal axi yantalam an inicchic ax u ulelel. ");
INSERT INTO husNT1971_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Tam ta c’ale al i tan a Jesús junax c’al in exobalilchic. Ne’ets al i c’uajattalab pil. ");
INSERT INTO husNT1971_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ani tsu’tab abal pel a Jesús tihua’ ne’ets junax c’al in exobalilchic. Tam athlatschic yan i inicchic, ani oc’ox ulits jaja’chic tihua’ jun ti ne’ets a Jesús ani in exobalilchic. ");
INSERT INTO husNT1971_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Tam ti calejits a Jesús al an tan, tam in tsu’u jun i pulic cuenel i inicchic muthat taja’. In yajnanchalchic cum xe’ets ejtil i cuenel i ovejachic yab jita’ ta ca beletna. Tam in ts’i’quiyal quin exobchichic c’al yan i cau: ");
INSERT INTO husNT1971_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Taley lej huaclejits, ani chich in exobalilchic quin ucha’ a Jesús: ―Lej huaclejits ani ni jita’ yab u c’uajil teje’. ");
INSERT INTO husNT1971_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Cum yab jant’o in cua’alchic an mulcunel quin c’apu, ca ucha’ ca c’ale ti al i q’uimathlomchic ani ti al i bichouchic axi utat abal quin ts’a’iy jant’o quin c’apu. ");
INSERT INTO husNT1971_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Toc’tsin a Jesús: ―Tata’chic ca pijchi an mulcunel. Toc’tsin jaja’chic: ―Auxe’ max ca lejey qui pijchi an mulcunel c’al tsab i bo’ inic i tumin denario i pan qui ts’a’iy. ");
INSERT INTO husNT1971_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Tam a Jesús in ucha’chic: ―Quit c’ale ca tsu’u jay i pan a cua’al. Tam tin tsu’uhuits, huichc’on junil ani in olchi a Jesús antse’: ―I cua’al bo’ i panchic ani tsab i to’ol. ");
INSERT INTO husNT1971_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Tam a Jesús in ucha’ an mulcunel ca buxcan ti cuenel ti cuenelchic ba’ an tsabal jun ti hua’ats i tsacam tom. ");
INSERT INTO husNT1971_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ani tats ti buxcanchic ti bo’ inic ti junchic i cuenelchic ani ti tsab inic c’al lajuj ti junchic i cuenelchic. ");
INSERT INTO husNT1971_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Tam a Jesús im bats’u axi bo’ i pan ani axi tsab i to’ol. Tam in met’al ti eb ani im pitha’ i c’ac’namal yan c’al a Dios. Taley in mu’u am pan ani im pitha’ in exobalilchic quin huat’banchi an mulcunel. Jaye im pitha’chic an to’ol quin huat’banchi an mulcunel. ");
INSERT INTO husNT1971_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","C’aputs patal an mulcunel ani ajhuejits. ");
INSERT INTO husNT1971_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Taley in exobalilchic a Jesús in thaya’ an jilc’omach pan ani an jilc’omach to’ol, ma lajuj tsab i t’ocnal t’uchichithits. ");
INSERT INTO husNT1971_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ajith an inic pel i bo’ mil axi c’aputs. ");
INSERT INTO husNT1971_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Taley a Jesús in ucha’ in exobalilchic ca otsits al an tan ani ca oc’chith c’ale ti Betsaida jum poq’ue’ am pulic lejem, ani jaja’ ne’ets ca jilc’on ne’ets quin aba’ ca c’alets an mulcunel. ");
INSERT INTO husNT1971_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Tam tin aba’its ca c’ale, tam jaja’ c’athiy al jun i bolchal ca olon. ");
INSERT INTO husNT1971_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Aclejits ani an tan ne’ets tam ts’ejel al am pulic lejem, ani a Jesús c’uajate ba’ an tsabal. ");
INSERT INTO husNT1971_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","In tsu’u a Jesús abal u tanc’uiyab an tan c’al i tsapic ic’ ani lej t’ojlabits quin xalu an ja’ abal quim beltha’ an tan. Tal chuthelits ani c’ale a Jesús c’al in exobalilchic, ne’ets belbel eblim an ja’. In t’aja’ ejtil max ne’ets quin huat’anchi in exobalilchic. ");
INSERT INTO husNT1971_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Tam tsu’tab ne’ets belbel eblim an ja’, ani u tsalpanchab hualam pel i labax. Tam thajnal in exobalilchic. ");
INSERT INTO husNT1971_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Patal jaja’chic t’elelel in ichich c’al i jiq’ueltalab. Tam a Jesús in tauna’ in ucha’chic: ―Tiquin lej tsapnanaychic ta ichich. Yab quit jiq’ueychic cum nana’its jats ax in tal c’al tata’chic. ");
INSERT INTO husNT1971_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Tam otsits a Jesús c’al jaja’chic al an tan, ani yabats juchuchul an ic’ tamna’. Ani lej jic’pab a Jesús c’al in exobalilchic cum in coytha’ an ic’. ");
INSERT INTO husNT1971_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Aba ani’ in tsu’umalits a Jesús quin yanetha’ i pan, yabaye in lej exlanchal in lej tsap. T’ujbabathechic in ichich. ");
INSERT INTO husNT1971_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Taley talbel ultsitschic a Jesús ani in exobalilchic jum poq’ue’ am pulic lejem ti tsabal Genesaret. Taja’ tats tin huic’a’ an tan tin hualte’lil am pulic lejem. ");
INSERT INTO husNT1971_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ani lej thubat an inicchic in exla’its abal ja’its a Jesús axi calejits al an tan. ");
INSERT INTO husNT1971_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Jaxtam thubat c’alechic tim puhuel nixe’ xi tsabal quin aliy i ya’ulchic quin ne’tha’ ju’tamits ta ca xe’tsin a Jesús. Ani u chanchinal a Jesús yan i ya’ulchic, ma al i tseyte’ tat tu chi’thab. ");
INSERT INTO husNT1971_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ju’tamaquitsq’ui ti xe’ets a Jesús max ti al i cuenchalab, max ti al i bichouchic, max ti al i alte’ q’uimath, taja’ u chanchinal ani u mo’canchab i ya’ulchic ju’ta ta ca huat’ey. Ani an ya’ulchic in lej canat ucha’ a Jesús max in ejtohual quin tacchi hue’ in acan in nacat coton. Ani patal ax in tacchal tala’ jeley. ");
INSERT INTO husNT1971_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Taley chich c’al a Jesús i fariseochic ani talchic i exobchix c’al an ts’ejcath cau binath c’al a Moisés, tal ma ti Jerusalén. ");
INSERT INTO husNT1971_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Jaja’chic in tsu’u in exobalilchic a Jesús talchic u c’apul ani yab t’acacath in c’ubac, ani in jolbiychic. ");
INSERT INTO husNT1971_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Jaja’chic an fariseo ani jat’hua’ patal an Israelchic in ujnam quin t’aja’ in ujnamtal im biyal juntalchic. Yab u c’apulchic max yab oc’ox quin t’acacay in c’ubac. ");
INSERT INTO husNT1971_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Tam ca huichits ti ts’a’um, tam ne’ets quin t’acacay in c’ubac abal max ca tsu’tat ti t’ocat c’al a Dios. Hua’atse yan q’ue’at i ujnamtalab in t’ajalchic. In ujnam quin t’acacay jaye an uts’umtalab ani an juyul ani an eyextalab pat’al ani an coytalab tsey jun tu buxcanal tam ne’ets ti c’apul. Antsana’ tin t’ajalchic abal max ca tsu’tat ti t’ocat c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Tam conoyab a Jesús c’al an fariseochic ani c’al nixe’ xi exobchixchic c’al an ts’ejcath cau binath c’al a Moisés antse’: ―¿Jale’ a exobalilchic in jec’onchal am biyal ujnamtalab axi jilchinenec c’al im biyal juntalchic? Yab in t’acacayal in c’ubac tam ne’ets ti c’apul abal max ca tsu’tat ti t’ocat c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","A Jesús in toc’tsiychic: ―It eb t’ocatq’uichic jant’ini’ tit thuchathits c’al an caulome Isaías antse’: Axe’ xi inicchic tin c’ac’nalq’ui nana’ c’al in hui’, ani tin lej ichich tin ou tsu’tal. ");
INSERT INTO husNT1971_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Jolat in c’ac’naxtal cum jats ax i exobchithq’ui c’al in at inic ani yab c’al a Dios, in ulu a Isaías. ");
INSERT INTO husNT1971_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Tata’chic a jec’onchal in abatnaxtal a Dios abal ca t’aja’q’ui jant’ini’ a biyal juntalchic. A t’acacayalchic an juyul ani an uts’umtalab jant’ini’ jaja’chic in t’ajamal. Yantalam i ujnamtalab antsana’ a t’ajalchic. ");
INSERT INTO husNT1971_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","A Jesús in uchayechic: ―A jec’onchal in abatnaxtal a Dios abal ca t’aja’q’ui yan i biyal ujnamtalab. ");
INSERT INTO husNT1971_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","An ts’ejcath cau binath c’al a Moisés in ulal antse’: Ca c’ac’na’ a tata ani a mim. Ca tsemtha jitats quithab cahuilix c’al in tata ani c’al in mimcua’. ");
INSERT INTO husNT1971_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ani tata’chic a jilal an inic quin hualba’ in tata ani in mim tam in yejenchal jant’o. Yab quin tolmiychic max quin ulu in tala’ pitha’its a Dios jahua’ in co’oyamalchic. Quin ulu Corbán ani alhua’its. Corbán ti tenec in le’ quin ulu abal pithachits c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Tam jaja’chic quin ulu antsana’, tam a ulalchic yabats in cua’al in uchbil quin tolmiy in tata ani in mim. ");
INSERT INTO husNT1971_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Antsana’ ta hualbanchal in abatnaxtal a Dios c’al i ujnamtalab axi it huat’banchame c’al a biyal juntalchic. Ani más yane i ujnamtalab a t’ajalq’ui antsana’. ");
INSERT INTO husNT1971_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Tam a Jesús in caniy ca más utey an mulcunel c’al jaja’, ani in ucha’chic: ―Tiquin alhua’ ats’anchi ani ca ejtiychic jahua’ ne’ets tu ucha’. ");
INSERT INTO husNT1971_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Jahua’ in c’apal an inic yab ja c’al tu jolbiyab c’al a Dios. Jahua’ quin co’oy tin ichich yab alhua’ ani quin t’aja’ jats c’al tu jolbiyab. ");
INSERT INTO husNT1971_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Jitats junat in ichich c’al nana’ u ichich, quin lej alhua’ bina’ in xutsun c’al axe’ xi cau. ");
INSERT INTO husNT1971_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Taley tixc’an a Jesús c’al an mulcunel ani otsits al jun i ata. Taja’ conoyab c’al in exobalilchic quin lejquiy nixe’ xi jalpith cau tin cuenta c’al jant’o tu jolbiyab an inic c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","A Jesús in ucha’chic: ―¿Jayetseq’ui tata’chic yab a ejtiyal? Jahua’ in c’apal an inic yab ja c’al tu jolbiyab c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Tocat u ulel tin chucul, ani talbel u calel tin inictal jahua’ yab alhua’. Yab u ulel tin lej ichich. C’al axe’ xi cau a Jesús in le’ quin ulu abal alhua’ ca c’apat patal an c’apnel, cum yab ja tu jolbiyab an inicchic c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","A Jesús in uchayechic: ―Jahua’ quin t’aja’ an inic yab alhua’ tin ichich jats c’al tu jolbiyab c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Tin ichich an inic u tujel i quithab tsalap. Jaxtam hua’ats jita’ uxumbe ani jita’ inicbe. Jaxtam hua’ats jita’ c’ambibil c’al an uxum. ");
INSERT INTO husNT1971_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Jaxtam hua’ats jita’ cue’ ani jita’ c’a’inchix c’al jahua’ yab in c’al. Jaxtam hua’ats jita’ in t’ajal pojcax ani jita’ in t’ajal c’ambix. Jaxtam hua’ats jita’ lej c’ambinelom c’al in cuete’ le’nomtal. Jaxtam hua’ats jita’ pa’ixnom ani jita’ quithab uchax. Jaxtam hua’ats jita’ in c’athatnal tim ba’ ani jaxtam hua’ats jita’ in t’ajal yab tsalpath. ");
INSERT INTO husNT1971_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","C’al patal axe’ jahua’ yab alhua’ quin t’aja’ an inic jats c’al tu jolbiyab c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Taley tixc’an a Jesús taja’, c’ale tihua’ al i cuenchalabchic axi cuentalith ti bichou Tiro ani ti bichou Sidón. Otsits al jun i ata, cum yab in le’ taja’ jita’ ta ca tso’obna. Bel aba ani’, yab in ejtou ca tsinat c’uajiy. ");
INSERT INTO husNT1971_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Jun i mimlab thubat in exla’ abal a Jesús ta c’uajat, ani chich in tuthu in c’ualal tin tamet. In cua’al in ts’ic’achil co’oyab c’al i at’ax teneclab. ");
INSERT INTO husNT1971_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Pel i uxum axi yab i Israel, cum in xits’al ti tal pel i sirofenicia. In conchi a Jesús ca canchin an at’ax teneclab tin ts’ic’achil. ");
INSERT INTO husNT1971_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","A Jesús in toc’tsiy: ―Yab in tomnal i inic quin tixc’anchi am pan in tsacamilchic ani quim pet’nanchi am pic’o’ quin c’apchi. An tsacamchic oc’ox quin c’apu am pan. ");
INSERT INTO husNT1971_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Tam toc’tsin an mimlab: ―Ojni’ lej chubax jahua’ a ulal, Ajatic. Aba ani’, bel am pic’o’ tin alam an mexa in c’apchal am pejlam pan ax u ijcanalq’ui tam u c’apul an tsacamchic. ");
INSERT INTO husNT1971_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Tam uchan c’al a Jesús: ―Lej chubax jahua’ a ulu. Quit c’alets, cum canchinits a ts’ic’achil an at’ax teneclab. ");
INSERT INTO husNT1971_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Tam ti ultsits tin q’uima’ an mimlab, tam in tsu’u cuatsat tin huaytal in ts’ic’achil canchithits an at’ax teneclab. ");
INSERT INTO husNT1971_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Taley tixc’an a Jesús taja’ al an cuenchalabchic axi cuentalith ti bichou Tiro ani ti bichou Sidón, ani ne’ets tsa’bibil al i bichouchic axi cuentalith ti Decápolis. Taley ultsits ti pulic lejem Galilea. ");
INSERT INTO husNT1971_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ani taja’ chanchin jun i inic axi tsine ani hueque’ cau, uchan max quim punchi in c’ubac. ");
INSERT INTO husNT1971_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Tam a Jesús ta in ne’tha’ hue’ pil. Im balchi in ch’uchub c’ubac tin xutsun, ani taley in tubcay in ijil tin ch’uchub c’ubac ani in umchi tin lec’ab. ");
INSERT INTO husNT1971_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Tamna’ in met’a’ ti eb, ani c’al i thuchumtalab tin ichich in ulu: ―Efata. Ti tenec cau in le’ quin ulu quit japq’uinchat. ");
INSERT INTO husNT1971_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Tameq’ui thubat japq’uinchatits in ots’oxtal ani hualcanchatits in thuc’chul in lec’ab. Ma tamits t’ajat u tajax cau. ");
INSERT INTO husNT1971_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ani huichits a Jesús jun ti muthat an inicchic, in ucha’chic yab quin olchi jita’ jahua’ t’ajchinenec nixe’ xi inic. Aba ani’ lej uchanchic antsana’, bel xe’ets ti olchix. ");
INSERT INTO husNT1971_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ani lej jic’pab ani lej t’iloxnab a Jesús c’al nixe xi inicchic jahua’ in t’ajamal. In uluchic: ―Patal jahua’ in t’ajal axe’ xi inic lej huinat alhua’, ma in ots’oxmethal an tsinechic ani in jelthal an mo’chic abal ca cahuin. ");
INSERT INTO husNT1971_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Jun a q’uicha c’uajat mulcuthits yantalam i inicchic, ani yab in cua’al jant’o quin c’apu. Ani a Jesús in caniy ca chich in exobalilchic, in ucha’: ");
INSERT INTO husNT1971_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―U lej yajnanchal an mulcunel, cum oxits a q’uicha ti c’uajat c’al nana’ ani yab in cua’al jant’o quin c’apu. ");
INSERT INTO husNT1971_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Max cu aba’ ca c’ale tin q’uima’ el ichich ne’ets ca luxan ti bel, cum yantalam che’nec lej ou. ");
INSERT INTO husNT1971_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","In ulu tam in exobalil: ―¿Jant’o ti qui pijchi an mulcunel ani teje’ yab hua’ats ma ni jun i q’uimath jun ti qui elchi i c’apnel? ");
INSERT INTO husNT1971_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","A Jesús in conoychic: ―¿Jay i panchic a cua’al? Toc’tsinchic: ―I cua’al buc i pan. ");
INSERT INTO husNT1971_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Tam a Jesús in ucha’ an mulcunel ca buxcan tsabal. Taley im bats’u axi buc i pan ani im bina’ i c’ac’namal yan c’al a Dios. Tam in mu’u ani im pitha’ in exobalilchic, ani jaja’chic in huat’banchi an mulcunel. ");
INSERT INTO husNT1971_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Jaye im bina’ i c’ac’namal yan c’al a Dios c’al xi tsab ox i tsacam to’ol, ani in ucha’ in exobalilchic quin huat’banchi an mulcunel. ");
INSERT INTO husNT1971_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Tim patal an mulcunel c’aputs ani ajhuejits. Taley in exobalilchic a Jesús in thaya’ an jilc’omach, ma buc i t’ocnal t’uchichithits. ");
INSERT INTO husNT1971_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Jelat ti tse’ mil i inicchic jats c’aputs. Tam a Jesús in ucha’ an mulcunel ca c’alets. ");
INSERT INTO husNT1971_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Taley jaja’ c’al in exobalilchic otsits al i tan, ta c’alechic ma ti tsabal Dalmanuta. ");
INSERT INTO husNT1971_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Chich i fariseochic in ts’i’quiyal ti cau c’al a Jesús. In tacchiquiyal in ucha’ quin t’aja’ i labith t’ajbilab ti tsu’bixtalab abal quin tejhua’metha’ max chubax in cua’al in tsap c’al a Dios ti eb. ");
INSERT INTO husNT1971_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Tam c’al i thuchumtalab tin ichich a Jesús in ulu: ―¿Jale’ hualam in le’ axe’ xi inicchic nan cu tejhua’metha’ u ey c’al i labith t’ajbilab? Lej chubax u ulal abal yab ne’ets cu t’ajchi. ");
INSERT INTO husNT1971_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Tam tixc’an a Jesús c’al nixe’ xi fariseochic, otsits junil al an tan c’al in exobalilchic, ani ta c’alechic jum poq’ue’ am pulic lejem. ");
INSERT INTO husNT1971_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","In exobalilchic in uc’chiy quin ne’tha’ i pan quin c’apu tam ne’etsits al an tan. Juncats i pan expith in cua’alq’ui. ");
INSERT INTO husNT1971_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Tam a Jesús in ucha’chic: ―Ca t’aja’chic ti cuenta yab ca bats’u an c’ac’chixtalab c’oye ax in cua’al an fariseochic ani axi ts’at’atchic c’al a Herodes. ");
INSERT INTO husNT1971_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Tam conóx jun c’al xi jun ani in uluchic: ―Antsana’ hualam in ulu cum yab i cua’al i pan. ");
INSERT INTO husNT1971_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Cum a Jesús in tso’ob jant’o in ulalchic, jaxtam in ucha’chic: ―¿Jale’ a ulalchic abal yab a cua’al i pan? ¿Jale’chic ma lejat yabaye tin exlanchal u lej ey? ¿Jale’ hualam t’ujbabathechic a ichich? ");
INSERT INTO husNT1971_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","A cua’alchic a hual ani a xutsun. ¿Jale’ yab it tsu’ux ani jale’ yab it ots’ox? ¿Jale’ it lejat uc’pithchic? ");
INSERT INTO husNT1971_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","¿Jay i t’ocnal an jilc’omach a thaya’ tam nan u pijchiyamal c’al nixe’ xi bo’ i pan bo’ mil i inicchic? Toc’tsin jaja’chic: ―I thaya’ lajuj tsab i t’ocnal. ");
INSERT INTO husNT1971_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","―¿Jay i t’uchichith t’ocnal an jilc’omach a thaya’ tam nan u pijchiyamal c’al nixe’ xi buc i pan tse’ mil i inicchic? Toc’tsin jaja’chic: ―I thaya’ buc i t’uchichith t’ocnal. ");
INSERT INTO husNT1971_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Tam a Jesús in conoychic: ―¿Jale’ hualam tata’chic yabaye tin exlanchal u lej ey c’al u labith t’ajbil? ");
INSERT INTO husNT1971_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Taley ulits a Jesús c’al in exobalilchic ti Betsaida, ani taja’ chanchin jun i joc’tsi. Ani lej canat taunab a Jesús max ca tacchinchat in hual abal ca tsu’uxme. ");
INSERT INTO husNT1971_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Tamna’ in yac’uchi in c’ubac an joc’tsi, in lotocna’ quin caltha’ al am bichou. In tubcay in ijil tin ch’uchub c’ubac ani in umchi tin hual an joc’tsi, ani tam in conoy max tsu’uxits. ");
INSERT INTO husNT1971_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Cum thabubul tsu’ux an joc’tsi, in toc’tsiy: ―U tsu’tal i inicchic ejtil max pel i te’lom, ani u tsu’tal ejtil max belelelchic. ");
INSERT INTO husNT1971_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Tam a Jesús in tsab tacchi junil in hual, ani an joc’tsi in luba’ ca tajax tsu’xin. Tam ojni’ in lej tajax tsu’talits patal jahua’ quin met’a’. ");
INSERT INTO husNT1971_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ani cum a Jesús ne’ets quin aba’ ca c’ale tin q’uima’, in ucha’ antse’: ―Yab quit otsits ta bichou, ani yab ca olchi jita’ jahua’ it t’ajchinenec. ");
INSERT INTO husNT1971_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Taley a Jesús c’al in exobalilchic xe’ets ti tsa’bibil al i bichouchic axi cuentalith ti Cesarea Filipo. Tam ti ne’ets tihua’chic ti bel, a Jesús in conoyal in exobalilchic: ―¿Jant’ini’ hualam tin olnal an inicchic c’al u ey nana’? ");
INSERT INTO husNT1971_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Toc’tsin jaja’chic: ―Talchic in ulal abal tata’ pel it Juan pujax. Talchic in ulal abal pel it Elías, ani talchic in ulal abal pel it caulome c’al a Dios axi junaquecua’. ");
INSERT INTO husNT1971_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ani a Jesús in conoyalechic: ―¿Ani tata’chic jant’ini’ tin exlanchal u ey? Tam toc’tsin a Pedro: ―Tata’its ojni’ pel it Cristo axi it bijithits ne’ets quit aban c’al a Dios quit chich. ");
INSERT INTO husNT1971_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Tam a Jesús in lej uluth ucha’ in exobalilchic yab quin olchi jita’ max jaja’its pel a Cristo. ");
INSERT INTO husNT1971_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Tam a Jesús in ts’i’quiy quin lej olchi in exobalilchic jant’o ne’ets ca t’ajchin jaja’ in Juntal patal an inicchic. Lej bijchithits ne’ets ca yajchiquiyat ani ca pojca c’al an yejtselabchic Israel ani c’al an oc’lec pale’chic ani c’al an exobchix c’al an ts’ejcath cau binath c’al a Moisés. Ne’ets ca tsemtha ani oxchilab q’uicha ne’ets ca ejtha. ");
INSERT INTO husNT1971_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Antsana’ a Jesús in lejquith olchi in exobalilchic. Tam a Pedro in ne’tha’ a Jesús hue’ pil ani in c’uiyath ucha’ yab in tomnal antsana’ quin tsalpay abal ne’ets ca tsemtha. ");
INSERT INTO husNT1971_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Huilq’uin a Jesús ani tocat in met’al in exobalilchic. Tam jaja’ in c’uiyath ucha’ a Pedro jaye antse’: ―Satanás, quit tixc’an c’al nana’. Yab a tsalapnanchal in tsalap a Dios, expith in tsalap an inic jats a tsalapnanchal. ");
INSERT INTO husNT1971_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Tam a Jesús in caniy ca utey in exobalilchic ani an mulcunel, ani in ucha’chic: ―Quin t’ajat jilcachiquiy in cuete’ culbetal jitats in le’ ca ts’at’ey c’al nana’. Aba ani’ max ca yajchiquiyat c’al an inicchic ani ma ca le’na ca tsemtha, bel tiquin ts’at’enchi. ");
INSERT INTO husNT1971_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Jitats in le’ expith quin t’aja’ in cuete’ culbetal, jats ne’ets ca q’uibey. Jitats quim bina’ tim ba’ c’al tu ebal nana’ ani c’al tin ebal an alhua’ cau, jats ne’ets ca jec’ontha. ");
INSERT INTO husNT1971_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ni jant’o ti exbath max an inic quin tala’ c’alna’ jahua’ teje’ tsabal ani quin q’uiba’its in ejattal. ");
INSERT INTO husNT1971_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ni jant’o yab hua’ats in exbath ejtil in c’athpich exbath in ejattal. ");
INSERT INTO husNT1971_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Xo’ lej hualbith an inicchic ani yab belom c’al nana’. Jitats tiquin tithenanchi u bij ani u cahuintal c’al jaja’chic, nana’ ne’ets cu tithena’ tam quin huichiy junil quim puhuethanchat u bij c’al u Tata ti eb. Nana’its tin Juntal patal an inicchic ne’ets quin huichiy junax c’al an t’ocat ángelchic. ");
INSERT INTO husNT1971_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","A Jesús in uchayechic antse’ in exobalilchic: ―Lej chubax nan tu uchalchic abal hua’ats axi tata’chic yab ne’ets quit thubat tsemets, biyat ma tiquin tsu’u in c’uajatits tin lej Ts’ale c’al u lej tsap. ");
INSERT INTO husNT1971_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Acac a q’uicha talbel a Jesús in ne’tha’ a Pedro ani a Jacobo ani a Juan al jun i t’ec’at oc’ bolchal. Taja’ in tejhua’methal tim ba’ c’al jaja’chic hue’ jalc’uthits in tejhua’ inictal. ");
INSERT INTO husNT1971_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Maq’uiq’uil in toltomil ani lej thacninil ejtil i pojoth tsam, ma i pac’ul toltom teje’ tsabal ni jayq’ui’ yab in ejtohual quim bajuthanchi ejtil in toltomil a Jesús lej c’athpich thacninil. ");
INSERT INTO husNT1971_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ani jaja’chic in tsu’u jaye c’uajatits a Elías ani a Moisés ti t’ilomchic c’al a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Tam a Pedro in ucha’ a Jesús: ―Exobchix, tequeth alhua’ abal xo’ teje’ u junat c’uajatchic huahua’. Qui ts’ejca’ ox i pathel ata, jun abal tata’, jun abal a Moisés, ani jun abal a Elías. ");
INSERT INTO husNT1971_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Antsana’ tin ulu a Pedro, cum jun jic’tohual yab in tso’bim jant’o quin más ulu. Jaye jiq’uel junax c’al in at exobalchic. ");
INSERT INTO husNT1971_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ani pa’iy jun i mule’ i tocou ti eb c’al ti paxq’uiq’uiyatchic. Al nixe’ xi tocou in ats’a’chic u cau a Dios antse’: ―Axe’ ja’its pel u ichich hual Tsacamil. Jats jaja’ ca ats’anchichic in cahuintal. ");
INSERT INTO husNT1971_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Tameq’ui axi ox an exobal in tsu’u expith jilc’on a Jesús. Xant’ojits a Elías ani a Moisés. ");
INSERT INTO husNT1971_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Taley tam ti ne’ets pa’a’alchic al am bolchal a Jesús c’al axi ox in exobalil, in ucha’chic abal yab quin olchi jita’ jahua’ in tsu’u. Quin aychi quin olchi ma tam ca ejthajits jaja’ ti al an jolimtalab in Juntal patal an inicchic. ");
INSERT INTO husNT1971_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Cum antsana’ ti uchanchic c’al a Jesús, jaxtam in tsinat t’ilal tin ichich jahua’ in tsu’umalits. Expith in t’iloxnalchic abal jant’o tam cau nix abal ne’ets ca ejtha ti al an jolimtalab. ");
INSERT INTO husNT1971_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Tam a Jesús conoyat c’al jaja’chic: ―¿Hualam max chubaxcua’ jahua’ in ulal an exobchixchic c’al an ts’ejcath cau binath c’al a Moisés, abal a Elías oc’chith ne’ets ca chich ani talbel ne’ets ca chich a Cristo? ");
INSERT INTO husNT1971_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","A Jesús in toc’tsiychic: ―Lej chubax ne’ets ca oc’chith chich a Elías quin tala’ ts’ejcanchi patal. Ani in ulal an T’ocat Thuchlab abal nana’ tin Juntal patal an inicchic ne’ets quin yajchiquiyat ani ne’ets quim pojca c’al an inicchic. ");
INSERT INTO husNT1971_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Nan tu uchalchic abal che’nequits jun axi ejtil a Elías ani t’ajchinenec quithab c’al an inicchic, cum antsana’ le’na ca t’ajchin. Antsana’ cum jant’ini’ tin ulal an T’ocat Thuchlab ne’ets quin yajchicna’. ");
INSERT INTO husNT1971_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Taley huichitschic a Jesús c’al axi ox in exobalilchic jun ti c’uajat axi q’ue’at in exobalilchic. In tsu’u c’al jaja’chic muthat yantalam i inic. Ani an exobchixchic c’al an ts’ejcath cau binath c’al a Moisés hueutsíx c’al in exobalilchic a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ani tam ti tsu’tabits tal a Jesús, patal axi taja’chic in jic’pal ani utey c’al in athic quin tsapnetha’ a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Tam a Jesús in conoychic nixe’ xi exobchixchic c’al an ts’ejcath cau: ―¿Jant’o tam cau ax a hueutsixnal c’al u exobalilchic? ");
INSERT INTO husNT1971_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Toc’tsin jun i inic c’al axi muthat taja’ in ulu: ―Exobchix, te tu chanchal u cuitolil c’uajchith ani mo’bethachits c’al i at’ax teneclab. ");
INSERT INTO husNT1971_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Abal ju’tamaquits ca xe’tsin u lej tsapic c’olohuab, ma u ijcab tsabal c’al an at’ax teneclab. U bititil in ijil ani u huech’ech’el in camab c’al an yajal. Tocat u luxuxmel in inictal. U ucha’chic a exobalilchic abal tiquin canchinchi an at’ax teneclab, ani yab in ejtouchic. ");
INSERT INTO husNT1971_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Toc’tsin a Jesús in ucha’chic: ―Tata’chic ojni’ yab tim belal. In ohuat c’uajinec c’al tata’chic tu c’aya’nal, ani yabaye tim belamal. Tiquin chanchi an cuitol teje’. ");
INSERT INTO husNT1971_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Tam ti chi’thachits an cuitol tin tamet a Jesús, an at’ax teneclab in tsu’u a Jesús ani in lej ts’ebtsinthal an cuitol. Ma ijca tsabal junil ani t’ulq’uiq’uil ti c’ale, ani u bititil junil in ijil. ");
INSERT INTO husNT1971_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Tam a Jesús in conoy in tata an cuitol: ―¿Ma jayq’ui’ ti ts’at’enec an ts’ebtsintalab c’al an cuitol? Toc’tsin in tata an cuitol: ―Ma tin t’ele’tal ti ts’at’enec. ");
INSERT INTO husNT1971_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Yan i calat u ijcab al i c’amal ani al i itse’, cum u le’nab ca tsemtha’ c’al nixe’ xi at’ax teneclab. Tucu yajnanchi ani tucu tolminchi max ca ejtou. ");
INSERT INTO husNT1971_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Tam uchan c’al a Jesús: ―Nan u ejtohual tu tolminchi c’al patal ma jutamits huichat a ejtohual tiquim bela’. ");
INSERT INTO husNT1971_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Tam in tata an cuitol in lej thajat ulu: ―Ojni’ u belalits, ani u lej le’ max tata’ tiquin tolmiy tu más beloyoye. ");
INSERT INTO husNT1971_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Tam ti a Jesús in tsu’u abal u lej q’uits’c’omanal an mulcunel, in c’uiya’ an at’ax teneclab. In thubat ucha’: ―At’ax teneclab, it lej mo’bethom ani it lej tsinebethom c’al an inicchic. Nan tu uchal quit tix’can c’al axe’ xi cuitol, ani ni jayq’ui’ yab quit huichiy quit otsits c’al jaja’ junil. ");
INSERT INTO husNT1971_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Tam an at’ax teneclab in lej ts’ebtsinthal an cuitol ani in lej tsapic thajanthal, ma jilc’on ejtil max tsemenec an cuitol. Ani yan i inic in ulu abal tsemetsits. ");
INSERT INTO husNT1971_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Tam a Jesús in yac’uchi in c’ubac ani in ts’acba’ ca cubiy. ");
INSERT INTO husNT1971_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Taley a Jesús otsits al jun i ata, ani taja’ tsinat conoyab c’al in exobalilchic: ―¿Jale’ yab i ejtou huahua’ qui canchi an cuitol nixe’ xi at’ax teneclab? ");
INSERT INTO husNT1971_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","A Jesús in toc’tsiychic: ―Ne’ets ca ejtouchic ca caltha’ nixe’ an at’ax teneclab, expith quit lej olon ani quit pablats yab quit c’aputs. ");
INSERT INTO husNT1971_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Calejitschic taja’ a Jesús junax c’al in exobalilchic, c’ale ani xe’etsits ti Galilea. Yab in le’ jita’ c’al ta ca tso’obna max xe’ets taja’. ");
INSERT INTO husNT1971_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Lej exome in exobchal in exobalilchic. In olchalchic abal jaja’ in Juntal patal an inicchic ne’ets ca bina tin c’ubac i inicchic abal ca tsemtha ani oxchilab q’uicha ne’ets ca ejtha. ");
INSERT INTO husNT1971_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Aba ani’ antsana’ olchinenec axe’ xi cau in exobalilchic a Jesús, bel yab in ejtiyal ani in ts’ejnal quin más conomichiquiye a Jesús abal ca lejquinchat an cau. ");
INSERT INTO husNT1971_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Taley ultsitschic a Jesús junax c’al in exobalilchic ti bichou Capernaum. Otsitschic al i ata ani taja’ a Jesús in conoyal in exobalilchic antse’: ―¿Jant’o tam cau ax a hueutsixnamal tihua’ ti bel? ");
INSERT INTO husNT1971_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Yab toc’tsinchic t’ajat, cum in hueutsixnamal jita’ c’al jaja’chic axi más huinat exbath in ey. ");
INSERT INTO husNT1971_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Tam buxcan a Jesús ani in caniy ca más utey axi lajuj tsab in exobalilchic. In ucha’chic: ―Jitats in le’ quim baju ti más huinat exbath in ey tin tamet a Dios, quin tsa’ca’ tim ba’ ani quin tolmiy patal jitaquitsq’ui tam inic. ");
INSERT INTO husNT1971_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Tam a Jesús in c’uajba’ jun i tsacam tin tamet in exobalilchic. Taley talbel im pumba’ tin ocob, ani in ucha’ in exobalilchic: ");
INSERT INTO husNT1971_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―Max jitats quim bats’u jun i tsacam ejtil axe’ c’al nana’ u bij, tin mac’uchith bats’uhualne. Ani max jitats tiquim bats’u yab expith nana’ tim bats’uhual, jaye in mac’uchith bats’uhual u Tata ti eb ax tin abamal quin chich teje’ tsabal. ");
INSERT INTO husNT1971_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Tam uchan a Jesús c’al a Juan: ―Exobchix, huahua’ i tsu’u jun i inic ti canchixnanchal a bij c’al i at’ax teneclab, ani i c’anchi cum yab ts’at’enec c’al huahua’. ");
INSERT INTO husNT1971_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Toc’tsin a Jesús: ―In tomnalac yab ca c’anchi, cum jitats quin t’aja’ i labith t’ajbilab c’al u lej bij pel i chubax inic. Yab ne’ets tiquin q’uibts’oth eyenthanchi u bij ani yab ne’ets tiquin quithab t’iloxnanchi u bij. ");
INSERT INTO husNT1971_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Jitats yab u tomolnax c’al huahua’ jats axi junat in ichich c’al huahua’ i ichich. ");
INSERT INTO husNT1971_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Max jitats ti pithalchic i ja’ ca uts’a’ c’al tin ebal nana’ u bij ani c’al tin ebal cum tata’chic pel tu c’al nana’, jats lej chubax ne’ets ca pithan i atabilab c’al u Tata ti eb. ");
INSERT INTO husNT1971_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Lej c’athpich hualbith jitats quin t’ajchi ca hualbin jun i tsacam axi nan tim belal. In tomnalac ca palchin i alchic tsa’ t’ujub tin nuc’ an hualbinthom ani ca pet’na al i pulic lejem ca t’ajat uc’tsin. ");
INSERT INTO husNT1971_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Max ti hualbinthalac a c’ubac in tomnal ejtil max ca t’ajat muts’q’uiy. In tomnal quit otsits tihua’ ti eb c’al a Dios c’al juncats a c’ubac, ani yab quit jolohuat ti al am pulic c’amal c’al tsab a c’ubac. Taja’ ni jayq’ui’ yab u teptsinal an c’amal. ");
INSERT INTO husNT1971_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Taja’ ne’ets ca ets’ey c’uajiy an c’amal ani an yajchictalab. ");
INSERT INTO husNT1971_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Max ti hualbinthalac a acan in tomnal ejtil max ca t’ajat muts’q’uiy. In tomnal quit otsits ti eb c’al a Dios c’al juncats a acan, ani yab quit jolohuat ti al am pulic c’amal c’al tsab a acan. Taja’ ni jayq’ui’ yab u teptsinal an c’amal. ");
INSERT INTO husNT1971_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Taja’ ne’ets ca ets’ey c’uajiy an c’amal ani an yajchictalab. ");
INSERT INTO husNT1971_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Max ti hualbinthalac a hual in tomnal ejtil max ca t’ajat caltha’ jun a hual. In tomnal quit otsits ti eb jun ti a Dios in t’ajal ti Ts’ale c’al juncats a hual, ani yab quit jolohuat ti al am pulic c’amal c’al tsab a hual. ");
INSERT INTO husNT1971_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Taja’ ne’ets ca ets’ey c’uajiy an c’amal ani an yajchictalab. ");
INSERT INTO husNT1971_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Patal jitats ca c’uajiy c’al a Dios ne’ets ca t’ojojonchat in ichich c’al i yajchictalab. Patal ne’ets ca bina c’al jaja’ t’ojojonchithits in ichich ejtil ti biyal bina t’ojojonchithits i ts’acchixtalab tsemthach co’nel jolchithits i at’em. ");
INSERT INTO husNT1971_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","An at’em in cua’al in huinat alhua’ ey tam yab tsamc’ac’ath. Max tsamc’ac’athits, yabats jant’o ti alhua’. Tata’chic ca cuxuy an yajchictalab ani a Dios ne’ets ti t’ojojonchi a ichich ca baju tit alhua’ ejtil i at’em axi alhua’. Tam ne’ets quit c’uajlelen jun ejetchic jun c’al xi jun. ");
INSERT INTO husNT1971_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Calejits a Jesús ti bichou Capernaum, c’ale ti Judea jum poq’ue’ am pulic itse’ Jordán. Taja’ u mulcunal junil yantalam i inicchic, ani a Jesús in exobchalchic cum antsana’ in ujnamits ti exobchix. ");
INSERT INTO husNT1971_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Tam utey i fariseochic in le’ quin tacchiquiy a Jesús. In conoyalchic max a Dios in jilal an inic quin jilcacay in tomquil. ");
INSERT INTO husNT1971_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Toc’tsin a Jesús in conoychic: ―¿Jant’o in ulal a Moisés tin thuchath cahuintal tin cuenta jahua’ tata’chic tin conoyal? ");
INSERT INTO husNT1971_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Toc’tsinchic: ―In ulu abal an tomquith uxum ca oc’ox ts’ejcanchat ani ca pithan an u jun tu olnab jale’ ne’ets ca jilcacayat, ani tiq’uele tam an inic in ejtohual quin jilcacay in tomquil. ");
INSERT INTO husNT1971_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Tam a Jesús in ucha’chic: ―Cum lej t’ujbathchic in ichich an inic, jats tin thucha’ a Moisés abal bel an inic quin jilcacay in tomquil. ");
INSERT INTO husNT1971_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Yab antsana’ ti c’a’alac tam ti a Dios in ts’ejca’ jun i inic ani jun i uxum. ");
INSERT INTO husNT1971_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Jaxtam in ulu a Dios abal an inic ca tixc’an c’al in tata ani in mim abal ca juncun c’al in tomquil. ");
INSERT INTO husNT1971_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ani tam juncunenequits ejtil max juncats tin ebchiccua’. ");
INSERT INTO husNT1971_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Cum antsana’ juncatsmethachits jaja’chic c’al a Dios, jaxtam yabats alhua’ max an inic quin jilcacay in tomquil. ");
INSERT INTO husNT1971_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Taley otsitschic in exobalil alta ti al an ata jun ti c’uajat a Jesús, ani conoyab jaja’ tin cuenta nixe’ xi cau an jilcacaxtalab c’al i tomquilab. ");
INSERT INTO husNT1971_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","A Jesús in ucha’chic: ―Max i inic quin jilcacay in tomquil ani ca tomquin c’al q’ue’at i uxum, tamna’ pel i uxumbe ani in t’ajchal i hualabtalab in oc’ox tomquil. ");
INSERT INTO husNT1971_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Max i uxum quin jilcacay in tomquil ani ca tomquin c’al q’ue’at i inic, tamna’ pel i inicbe ani in t’ajchal i hualabtalab in oc’ox tomquil. ");
INSERT INTO husNT1971_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Taley chanchinal a Jesús i tsacamchic abal ca tacchin c’al jaja’. Ani in exobalilchic a Jesús tocat in ts’i’quiyal quin c’uiya’ an chi’thom. ");
INSERT INTO husNT1971_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Tam tin tsu’u a Jesús abal antsana’ c’uiyax in exobalilchic, tam tsacuy ani in ucha’chic: ―Yab ca c’anchi an tsacamchic yab ca chi’tha c’al nana’. Expith jitats tsa’at in ichich ejtil in ichich i tsacam, jats ax im bats’uhual a Dios ti Ts’ale tin ichich. ");
INSERT INTO husNT1971_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Jitats yab antsana’ tsa’at in ichich, yab in ejtohual quim bats’u a Dios ti Ts’ale tin ichich ani yab ne’ets ca c’uajiy ti eb jun tin t’ajal a Dios ti Ts’ale. Jats an lej chubaxtalab nan tu uchalchic. ");
INSERT INTO husNT1971_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Taley a Jesús im pumbal ti junchic an tsacamchic tin ocob, ani im punchal in c’ubac tin oc’. ");
INSERT INTO husNT1971_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Tam ti ne’ets a Jesús ti bel, tal jun i inic c’al in athic. Ulcan tin tamet a Jesús ani in tuthuhual in c’ualal, ani in conoyal: ―¿Jant’o pel u uchbil cu t’aja’ abal quin it ejatliyat abal ets’ey? Tata’ it alhua’ exobchix tiquin ucha’. ");
INSERT INTO husNT1971_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Tam uchan c’al a Jesús: ―¿Jale’ tin uchal tin alhua’? Hua’ats juncats expith axi alhua’, ja’its a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","A tso’obits an uchbixtalabchic axi thuchat tin cahuintal a Dios antse’: Yab quit uxumbejin. Yab ca tsemtha’ a at inic. Yab quit cue’en. Ni jita’ yab ca t’ajchi an janamtalab. Ni jita’ yab ca c’ambiy. Ca c’ac’na’ a tata ani a mim. ");
INSERT INTO husNT1971_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Toc’tsin an inic: ―Ma tam tu tsacamtal u tala’ putumal an uchbixtalab c’al axe’ ax tin uchamal. ");
INSERT INTO husNT1971_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","A Jesús in ichich hual met’a’ ani in ucha’: ―Hua’atse jant’o in le’ a Dios abal ca t’aja’. Quit c’ale ca tala’ nuju jahua’ a cua’al ani ca pitha’ an tumin an ts’ejhuantalchic. Max antsana’ ca t’aja’, tam ojni’ ne’ets quit pithan yan i c’alab tihua’ ti eb. Ani xo’ aba ma quit yajchiquiyat ani ma quit le’na quit tsemtha, bel tiquin ts’at’enchi. ");
INSERT INTO husNT1971_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Tam tin ats’a’ axe’ xi cau, ta c’ale lej yajchic ani lej t’e’pith in ichich, cum in le’ quin cuete’ c’alna’ axi yan in cua’al. ");
INSERT INTO husNT1971_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Tam a Jesús in met’a’ an inicchic axi muthat toninil c’al jaja’ ani in ucha’ in exobalilchic: ―Lej q’uibat an ricochic quim bats’u a Dios ti Ts’ale tin ichich. ");
INSERT INTO husNT1971_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Lej jic’pax in exobalilchic a Jesús c’al nixe’ xi cau jahua’ in ulu jaja’, ani jats tin tsab ucha’chic junil in exobalilchic antse’: ―Tsacamilchic, tu uchal lej q’uibat quim bats’u a Dios ti Ts’ale tin ichich jitats quin tsapna’ axi yan in cua’al. ");
INSERT INTO husNT1971_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Lej q’uibat ca huat’ey jun i camello tin lo’tal in acan i t’ithab, ani lej huat’ath más q’uibat abal i rico quim bats’u a Dios ti Ts’ale tin ichich max quin huat’ath tsapna’ axi yan in cua’al. ");
INSERT INTO husNT1971_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Tam c’al nixe’ cau lej jic’pax in exobalilchic a Jesús, ani conóx jun c’al xi jun: ―¿Max chubax antsana’ jahua’ in ulu, tam jita’ hualam ne’ets ca ejtohuat ca jec’ontha? ");
INSERT INTO husNT1971_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Tam a Jesús in met’a’chic ani in ucha’: ―An inicchic yab in ejtohual quin cuete’ jec’ontha’ tim ba’, expith c’al a Dios ojni’ ne’ets ca ejtohuat ca jec’ontha. A Dios expith patal in ejtohual quin t’aja’. ");
INSERT INTO husNT1971_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Tam uchan a Jesús c’al a Pedro: ―Ajatic, huahua’ i tala’ jilamal i c’al jahua’ i co’oyamal ani xo’ u ts’at’enec c’al tata’. ");
INSERT INTO husNT1971_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Toc’tsin a Jesús: ―Chubax nan tu uchalchic ne’ets ca pithan yan más c’al a Dios jitats in jilamal jant’o tin ebal u bij ani tin ebal abal pel i olnanchix c’al an alhua’ cau. Antsana’ ne’ets ca pithan max quin jila’ in q’uima’, max in ebchalchic, max in uxum ebchalchic, max in tata, max in mim, max in tomquil, max in tsacamilchic, max in tsabalil. ");
INSERT INTO husNT1971_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Teje’ tsabal ne’ets quim bats’uye ma bo’ inic huichc’oth, in q’uima’, in ebchalchic, in uxum ebchalchic, in mimchic, in tsacamilchic, in tsabalilchic. Jaye ne’ets ca othna c’al in at inicchic teje’ tsabal, ani ti eb ne’ets ca c’uajiy it ejatlith abal ets’ey. ");
INSERT INTO husNT1971_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Hua’ats xohue’ teje’ tsabal yan i inicchic pulic in ey, ani talbel ne’ets ca ajiyat tsipilin in ey ti eb c’al a Dios. Hua’ats jaye yan i inicchic axi xohue’ tsipilin in ey, ani talbel ne’ets ca ajiyat pulic in ey ti eb c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","A Jesús junax c’al in exobalilchic ne’etsits ti bel c’athithil ti Jerusalén, ani a Jesús hue’ más oc’chith ti ne’ets. In jic’palchic abal yab u jiq’uel a Jesús c’al jant’o ne’ets ca t’ajchin ti Jerusalén, ani jaja’chic ojni’ u jiq’uel. Tam a Jesús in ucha’ ca peleychic hue’, cum junil ne’ets quin olchichic jant’o ne’ets ca t’ajchin jaja’ tihua’ ti Jerusalén. ");
INSERT INTO husNT1971_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","In ucha’chic: ―Ca lej t’aja’ ti cuenta xohue’ hue’its cu ulits ti Jerusalén. Taja’ nana’ tin Juntal patal an inicchic ne’ets quim bina tin c’ubac an oc’lec pale’chic ani tin c’ubac axi exobchixchic c’al an ts’ejcath cau binath c’al a Moisés. Jaja’chic ne’ets tiquin jolbiy abal quin tsemtha. Taley ne’ets tiquin huat’ba’ tin c’ubac axi yab Israelchic. ");
INSERT INTO husNT1971_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ani jaja’chic ne’ets tiquin tilibna’, ani tiquin mo’canchi i c’ubaclec, ani tiquin tubcay. Ma ne’ets tiquin t’ajat tsemtha’. Aba ani’ quin tsemtha, oxchilab q’uicha ne’ets quin ejtha ti al an jolimtalab. ");
INSERT INTO husNT1971_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Tam uteychic c’al a Jesús a Jacobo ani a Juan. In tata jaja’chic pel a Zebedeo. Uchan a Jesús c’al jaja’chic: ―Exobchix, huahua’ i le’ i alhua’talab tucu t’ajchi c’al jahua’ ne’ets tu conchi. ");
INSERT INTO husNT1971_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Tam a Jesús in conoy: ―¿Jant’o tam alhua’talab a le’ac abal nan tu t’ajchichic? ");
INSERT INTO husNT1971_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","In uluchic: ―Tam tata’ ca lej t’aja’ tit Ts’ale teje’ tsabal huahua’ i le’ cu buxcan jun ta huinab ani jun ta c’uatab. ");
INSERT INTO husNT1971_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Tam a Jesús in ucha’chic: ―Yab a alhua’ exbayamal jahua’ ax tin conchalchic. ¿A ejtohualchic ca yajchicna’ an yajchictalab ani an tsemtalab axi nan ne’ets cu yajchicna’? ");
INSERT INTO husNT1971_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Toc’tsin jaja’chic: ―I ejtohual. Tam a Jesús in ucha’chic: ―Chubax ne’ets ca yajchicna’te i yajchictalab ani i tsemtalab ejtil axi nan ne’ets cu yajchicna’. ");
INSERT INTO husNT1971_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Expith yab u uchbil abal nan tu pitha’ an q’uij quit buxcan jun tu huinab ani jun tu c’uatab. Pel in uchbil expith u Tata quim pitha’ an q’uij ca buxcan tu huinab ani tu c’uatab jitats jaja’ im bijiyamalits. ");
INSERT INTO husNT1971_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Axi lajuj in exobalilchic a Jesús tsacuy c’al a Jacobo ani c’al a Juan, cum antsana’ in le’ ca pithan an q’uij. ");
INSERT INTO husNT1971_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Tam a Jesús in caniychic ca utey, ani in ucha’chic: ―A tso’obits tata’chic abal am pulic oc’lec u tsapic abatnom ani in t’ajal ti pulic inic c’al am bichoulomchic. ");
INSERT INTO husNT1971_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Yab in tomnal tata’chic antsana’ ca t’aja’ jayetseq’ui. Max a le’ tit pulic a ey c’al a Dios, ca tolmiy a at belom. ");
INSERT INTO husNT1971_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ani max a le’ tit lej c’athpich pulic a ey c’al a Dios, ca t’ayat tolmiy patal a at belomchic. ");
INSERT INTO husNT1971_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Cum nana’ tin Juntal patal an inicchic in che’nequits abal tin tolmix c’al an inicchic, ani yab tin tsapic abatnom. Ma ne’ets cu bina’ tu ba’ quin tsemtha ti calchixtalab abal yantalam i inic ca hualca ani yabats ca c’unat co’oyat c’al i hualabtalab. ");
INSERT INTO husNT1971_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ulnenequits a Jesús junax c’al in exobalilchic ti Jericó ani calelelits taja’, ani ts’at’at jaye i mulcunel pulic. Ani quetelits tin hual am bel jun i joc’tsi im bij Bartimeo ti conol c’al i ts’ejhualixtalab tumin. Pel in tsacamil a Timeo. ");
INSERT INTO husNT1971_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Tam tin ats’a’ abal utat c’uajat a Jesús taja’, tam in thajat ucha’: ―Tata’ Jesús axi pel it at xits’lab c’al a David, tiquin yajnanchi. ");
INSERT INTO husNT1971_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ani tamna’ c’uiynal c’al yan i inicchic taja’, uchan ca ts’ibc’an. Ani jaja’ más thajajal cahuin. In lej tsapic ucha’ a Jesús: ―Tata’ axi pel it at xits’lab c’al a David, tiquin yajnanchi. ");
INSERT INTO husNT1971_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Tam cubiy a Jesús ani in ucha’ axi muthatchic taja’: ―Ca ucha’ ca chich an joc’tsi. Ani ta c’ale axi uchanchic, ulits c’al an joc’tsi ani in ucha’chic: ―Xo’ quit culbejits, cum a Jesús in le’ ti tsu’u. Quit ts’aquiy ani cu c’ale c’al jaja’. ");
INSERT INTO husNT1971_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Tameq’ui an joc’tsi in thubat tixc’a’ in nacat coton, ani t’ic’ts’oth ts’acpan. C’ale ani ulits tin tamet a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ani conoyat c’al a Jesús: ―¿Jant’o a le’ abal nan tu t’ajchi? Toc’tsin an joc’tsi: ―U le’ abal tiquin tsu’uxmetha’. ");
INSERT INTO husNT1971_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Tam uchan c’al a Jesús: ―Ojni’ ne’ets tu tsu’uxmetha’ cum tim belamal. Xo’ a ejtohual quit c’ale cum jelthachits a hual. Ma tamna’its u tajax tsu’uxits, ani ts’at’ey c’al a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Taley ne’etsits ca ulits a Jesús junax c’al in exobalilchic ti Jerusalén, ani im bajuchic utat ti bichou Betfagé ani ti bichou Betania axi utatchic ti bolchal Olivos. Ma taja’ a Jesús ne’ets quin aba’ tsab in exobalil c’al i cau. ");
INSERT INTO husNT1971_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","In ucha’chic: ―Quit c’alechic al nixe’ xi bichou axi utat, ani taja’ ne’ets ca ela’ jun i burro huic’at axi lejat yabaye puname. Ca piliy ani tiquin chanchi teje’. ");
INSERT INTO husNT1971_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Max jita’ ti ucha’ abal jale’ ta piliyal, ca ucha’ abal nana’ in Ajatic ax u yejenchal. Jaye ca ucha’ abal thubat ne’ets cu huichba’. ");
INSERT INTO husNT1971_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Tana’ c’alechic in ela’ am burro huic’at ba’ i bel utat tin hui’lebil jun i ata. Im piliyalits. ");
INSERT INTO husNT1971_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ani tam conoyab c’al talchic i inic: ―¿Jant’o a t’ajalchic a piliyal am burro? ");
INSERT INTO husNT1971_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Tam toc’tsin in exobalilchic a Jesús jant’ini’ ti uchanits c’al a Jesús quin toc’tsiychic. Tam uchanchic bel quin ne’tha’. ");
INSERT INTO husNT1971_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Tam in chi’tha’chic am burro c’al a Jesús. Im punchal jaja’chic in toltomil tin cux am burro, ani tam puney a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Yan i inicchic in mo’cal in toltomil ba’ am bel jun ti ne’ets ca huat’ey a Jesús, ani talchic i inic in cotoyal in c’ue’el i tsacam te’ quin mo’canchi ti bel. ");
INSERT INTO husNT1971_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ta ne’ets an mulcunel ti Jerusalén. Axi oc’ox ne’ets ani jaye axi tal cuxlabchic in thajat ulal antse’: ―Qui puhuethanchi im bij axi te talits. Ja’its axi tal abath c’al a Dios, ani ja’its qui ajatnanchi im bij. ");
INSERT INTO husNT1971_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Qui ajatnanchi im bij, cum hue’its ne’ets quin t’aja’ ti lej Ts’ale jant’ini’ tin t’aja’ ti ts’ale i biyal juntal David. Qui puhuethanchi im bij a Dios ti eb. ");
INSERT INTO husNT1971_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Antsana’ ti bats’uhuatits a Jesús ti Jerusalén. Ani talbel otsits ti al an tiyopan, ani in tala’ met’cachiquiyal jant’o in t’ajal an inicchic taja’. Taley cum huaclejits, c’ale a Jesús junax c’al axi lajuj tsab in exobalilchic ti Betania. ");
INSERT INTO husNT1971_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ti chuthey q’uicha taja’ calejitschic ti bichou Betania, ani c’a’il a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","In tsu’u hue’ ou jun i xequeth te’ higuera. C’ale quin tsu’u max in cua’al in hualil. Cum yabaye pel in q’uijil ca hualin, ni jant’o tam hualilab yab in elchi, tocat xequeth. ");
INSERT INTO husNT1971_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Tam a Jesús in tauna’ an te’, in ucha’: ―Ni jita’ yabats ne’ets quin ela’ i hualilab c’al tata’ quin c’apu. In exobalilchic in ats’a’ jant’o in ulu a Jesús c’al nix an te’. ");
INSERT INTO husNT1971_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Taley ulits a Jesús junax c’al in exobalilchic ti Jerusalén. Taja’ otsits ti al am pulic tiyopan, in tala’ quethmachiquiyal eleb axi nujul ani axi ts’a’um. Xe’ets in cuajlachiquinchal in mexajilchic an jalum tumin ani in lactemilchic an nujul lab cucu’. ");
INSERT INTO husNT1971_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Yab in jilal jita’ ti quititil c’al i nujnel al an tiyopan. ");
INSERT INTO husNT1971_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","A Jesús in ucha’chic axi antsana’ tin eyenthal an tiyopan: ―Thuchathits ti al an T’ocat Thuchlab jahua’ in ulu a Dios antse’: U q’uima’ ja’its jun ta ca olon patal an inicchiccua’. Nan tu uchalchic abal xo’ tata’ a eyenthal abal ca cue’chi jant’o ax u che’el ti ol. ");
INSERT INTO husNT1971_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","An oc’lec pale’chic ani an exobchixchic c’al an ts’ejcath cau binath c’al a Moisés in ats’a’ jant’o antsana’ in ulu a Jesús, ani tamna’ thubat in aliyal jant’ini’ ti quin tsemtha’ a Jesús. Expith in ts’ejnalchic quin tejhua’ tsemtha’ cum jat’hua’ tim patal an inic in lej jic’panchal in exobchixtal a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Taley taja’ calets a Jesús ti Jerusalén tam ti aclejits. ");
INSERT INTO husNT1971_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ti chuthey q’uichajits tam thaju, tamna’ u huat’el junil a Jesús junax c’al in exobalilchic jun ti c’uajat nixe’ xi te’ higuera. In tsu’uchic lejat huayts’onenequits ani tsemenequits. ");
INSERT INTO husNT1971_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Tam a Pedro in t’ila’ jant’o in uchamal a Jesús nixe’ xi te’, ani in ucha’ a Jesús: ―Exobchix, ca tsu’u lejat huayts’onenequits an te’ higuera ax a c’uiya’. ");
INSERT INTO husNT1971_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Toc’tsin a Jesús: ―Ca lej bela’chic a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Chubax nan tu uchalchic max ca ucha’ nixe’ xi ts’en ca tixc’a ani ca pet’na al i pulic lejem, a Dios ne’ets ti t’ajchi max ca lej bela’ c’al patal a ichich ani yab ca co’oy i hualamtalab ta ichich. ");
INSERT INTO husNT1971_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Jaxtam nan tu uchalchic abal patal jahuats ca conchi a Dios, jaja’ ne’ets ti pitha’ max chubax a lej belalits c’al patal a ichich abal ne’ets ti pitha’. ");
INSERT INTO husNT1971_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Tam it olchic ca paculanchi jitats ti t’ajchamal quithab, abal i Tata ti eb ti paculanchi a hualab. ");
INSERT INTO husNT1971_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Max tata’chic yab ca paculanchi a at inic, i Tata ti eb yab ne’ets ti paculanchi a hualab. ");
INSERT INTO husNT1971_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Huichits a Jesús junax c’al in exobalilchic ti Jerusalén. Xe’ets junil ti al am pulic tiyopan, ani uteychic an oc’lec pale’ ani an exobchix c’al an ts’ejcath cau binath c’al a Moisés ani an yejtselab Israel. ");
INSERT INTO husNT1971_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ani conoyab a Jesús c’al jaja’chic: ―¿Jita’ ti pithamal an eyaltalab ani jita’ ti abamal abal ca t’aja’ jahua’ a t’ajal? ");
INSERT INTO husNT1971_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Toc’tsin a Jesús: ―Nana’ne ne’ets tu conoychic c’al jun i cau. Max tata’chic tiquin toc’tsinchi, tam nana’ne ne’ets tu olchichic c’al jant’o tam eyaltalab tu t’ajal jahua’ u t’ajal. ");
INSERT INTO husNT1971_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿C’al jita’ ti aban a Juan ti pujax? Tiquin toc’tsinchi, max c’al a Dios o max c’al i inic. ");
INSERT INTO husNT1971_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Tam jaja’chic in t’iloxnachiquiyal jahua’ in ulu a Jesús, ani taley in uluchic: ―¿Jant’ini’ ti qui toc’tsinchi? Max qui ulu abal c’al a Dios jats ti abnenec a Juan ti pujax, tam jaja’ ne’ets quin ulu abal jale’ yab i belchamal in cahuintal. ");
INSERT INTO husNT1971_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Max qui ulu abal c’al i inic jats ti abnenec, tam jant’o hualam ne’ets quin ulu am bichou. In ts’ejnalchic jant’o quin ulu am bichou, cum patal in lej belalits abal pel i lej chubax caulome abnenec c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Jaxtam jaja’chic tocat in ucha’ a Jesús: ―Yab i tso’ob c’al jita’ ti abnenec a Juan ti pujax. Tam a Jesús in ucha’chic: ―Nana’ne yab ne’ets tu olchichic c’al jita’ tin abnenec ani c’al jita’ tim pithnenec u eyaltal cu t’aja’ jahua’ u t’ajal. ");
INSERT INTO husNT1971_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Taley a Jesús in ts’i’quiy junil quin tauna’ c’al i jalpith cau axi muthatchic c’al jaja’. In ucha’chic: ―Jun i inic in t’aya’ jun i lab t’uthublom, ani taley in tenmay c’al i te’. In ts’ejca’ in tsa’ub in hualil an lab t’uthub. Jaye in ts’ejca’ jun i t’ec’at tsac’ jun ti ca c’uajiy am beletnom lab t’uthublom. Taley im bina’ c’al jita’ ta ca t’ojonchat an lab t’uthublom. Tam c’ale ou an thabal. ");
INSERT INTO husNT1971_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Im baju in q’uijil an cotlats c’al an lab t’uthub, ani an thabal in aba’ jun i t’ojnal ca c’ale quim bats’c’unchi an lab t’uthub axi ne’ets ca jilc’on abal jaja’ an thabal. ");
INSERT INTO husNT1971_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ultsits an t’ojnal ani tocat yac’uan c’al an t’ojonchixchic. Cuathan ani aban ca huichiy naptal c’al an thabal. ");
INSERT INTO husNT1971_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Tam an thabal in aba’ q’ue’at i t’ojnal. Tocat cui’iyat ani ts’ojbetha tin oc’ c’al i t’ujub, ani quithab uchan. ");
INSERT INTO husNT1971_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Taley an thabal in aba’ q’ue’ate. Ani jaja’ t’ajat tsemtha. Huilq’uith in aba’ i t’ojnalchic, ani tocat cuathan ani ma talchic jaja’ tsemtha. ");
INSERT INTO husNT1971_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ani tin lej taltalits an thabal in lejat aba’ in cuete’ ichich hual tsacamil. In tsalpay abal chubax ne’ets ca alhua’ bats’uhuat in tsacamil. ");
INSERT INTO husNT1971_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ani iba, expith in ulu an t’ojonchixchic antse’: Jats axe’ ne’ets ti c’alnanchix c’al an lab t’uthublom tam ca tsemets in tata. Qui tsemtha’ ani qui c’alnanchi huahua’. ");
INSERT INTO husNT1971_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Tam in yac’ua’chic ani in t’ajat tsemtha’, ani in caltha’ tin elebtal an lab t’uthublom. ");
INSERT INTO husNT1971_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Tam a Jesús in conoy axi c’uajat c’al jaja’chic: ―¿Jant’ini’ ti ne’ets quin t’aja’ nixe’ xi thabal lab t’uthublom? Ne’ets ca c’ale quin t’ajat tsemtha’ an t’ojonchixchic, ani ne’ets quim bina’ an lab t’uthublom ca t’ojonchat c’al q’ue’at i inicchic. ");
INSERT INTO husNT1971_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Auxe’ max yab a ajiyamalchic an T’ocat Thuchlab jun tin olnab nana’its ejtil in mimlab t’ujub antse’: An ts’ejcom atachic in ulu yab jant’o ti alhua’ axe’ xi t’ujub, ani tocat im pet’na’. Ani ja’its nix an t’ujub axi punuthits ti mimlab t’ujub. ");
INSERT INTO husNT1971_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Jats a Dios axi antsana’ im punu. Pel i lej jic’path t’ajbilab abal antsana’ ti punuthits c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Tam c’al nixe’ xi cau a Jesús u le’nab ca yac’uan c’al talchic i inic ax in exla’its abal jaja’chic ja’its ax u uxnal al nixe’ xi jalpith cau. Expith in ts’ejnalchic max jant’o ca t’ajchin c’al am bichouchic max quin lej yac’ua’ a Jesús, ani ta c’alechic. ");
INSERT INTO husNT1971_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Taley aban ca c’alechic c’al a Jesús talchic i fariseo ani talchic axi ts’at’at c’al a Herodes, quin t’ajchi quin ulu i q’uibts’oth cau abal ca ejtohuat ca jolbiyat. ");
INSERT INTO husNT1971_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ultsitschic c’al a Jesús, in ucha’chic: ―Exobchix, i tso’ob abal jahua’ tata’ ca ulu pel i lej chubaxtalab. Expith a olnanchal in tequeth belil a Dios. Yab a t’ajal ti cuenta jahua’its it uxnal c’al an inicchic, ani yab it poc’oth tsu’tom c’al an inicchic. Tucu ucha’ max i cua’al i uchbil o max yab i cua’al qui jalbiy an jalbixtalab tumin c’al an ts’ale oc’lec romano. ");
INSERT INTO husNT1971_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Cum a Jesús in exla’its abal pel i c’ambix cau, jaxtam in ucha’chic: ―¿Jale’ a le’chic tiquin macla’? Tiquim pitha’ jun i tumin abal qui met’a’. ");
INSERT INTO husNT1971_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Tam pithanits. Taley in met’a’ ani in conoy: ―¿Jita’ axe’ in hual ani jita’ axe’ im bij axi thuchath teje’ al an tumin? Toc’tsin jaja’chic: ―Pel in hual ani pel im bij an ts’ale oc’lec. ");
INSERT INTO husNT1971_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Tam a Jesús in ucha’chic: ―Ca pitha’ an ts’ale oc’lec jahua’ pel a uchbil ca pitha’, ani ca pitha’ a Dios jahua’ pel a uchbil ca pitha’ jaye. Ani lej jic’panchab in toc’tsixtal a Jesús c’al axi che’nec ti maclaxchic. ");
INSERT INTO husNT1971_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Taley talchic i saduceo chich c’al a Jesús. Cum yab im belalchic abal max ne’ets ca ejtha an tsemelomchic, uchan a Jesús c’al jaja’chic: ");
INSERT INTO husNT1971_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Exobchix, a Moisés in thucha’ abal max ca tsemets jun i tomquith inic ani yab in co’oyamal i tsacam c’al in q’uimathil, ca tomquin in ebchal an tsemelom c’al an tsemchith uxum. Lequitsq’ui max quin co’oy i tsacam tam. ");
INSERT INTO husNT1971_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Hua’atsac buc i ebchalab. Tomquin an oc’ox, ani tsemets yab in co’oyamal i tsacam. ");
INSERT INTO husNT1971_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Taley tomquin in tsabchil ebchal an tsemelom c’al an tsemchith uxum. Tsemets jaja’, ani yab in co’oyamal i tsacam. Jayetseq’ui in oxchil ebchal an tsemelom tomquin c’al nixe’ xi tsemchith uxum, ani tsemets jaja’ jaye yab in co’oyamal i tsacam. ");
INSERT INTO husNT1971_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Tim patal nixe’ xi buc i ebchalab tomquinenec c’al nixe’ xi juncats uxum, ani ni jun yab in co’oyamal i tsacam. Taley tsemets jaye an uxum. ");
INSERT INTO husNT1971_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","¿Cum tomquinenec nixe’ xi uxum c’al axi buc i ebchalab teje’ tsabal, c’al jahua’ ti ne’ets ti c’uajiy ti tomiclab tam ca ejtha an tsemelomchic? ");
INSERT INTO husNT1971_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","A Jesús in toc’tsiychic: ―Tata’chic ojni’ lej q’uibts’othits a tsalap tin cuenta an tsemelomchic, cum yab a exlal an T’ocat Thuchlab ani yab a exlanchal in tsap a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Tam ca ejtha an tsemelomchic in ey an inic ani in ey an uxum yabats ne’ets ca tomquin. Ne’ets ca c’uajiychic ejtil an ángelchic axi ti eb yab u tomquinal. ");
INSERT INTO husNT1971_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Tin cuenta abal u ejthab an tsemelomchic hualam yab a ajiyamalchic jahua’ in thucha’ a Moisés, abal tauna jaja’ c’al a Dios ti al i tsacam te’ tam ti t’a’ilits. Uchan a Moisés antse’: Nana’its pel tin Diosil a Abraham ani tin Diosil a Isaac ani tin Diosil a Jacob, in ulu. ");
INSERT INTO husNT1971_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Cum a Dios pel in Diosil nixe’ xi ox i inic axi tsemenec teje’ tsabal, jaxtam i exlalits abal bel c’uajatchic ejate tin tamet a Dios. Lej q’uibts’oth a tsalap tata’chic tin cuenta an tsemelomchic. ");
INSERT INTO husNT1971_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Taley utey c’al a Jesús jun i inic axi pel i exobchix c’al an ts’ejcath cau binath c’al a Moisés. In ats’amalits jaja’ tam ti hueutsíxin an saduceochic c’al a Jesús. Cum in exla’its abal tsalpath in toc’tsixtal a Jesús, jaxtam in conoy: ―¿Jahua’ hualam an uchbixtalab axi más lej huinat exbath ti al an ts’ejcath cau binath c’al a Moisés? ");
INSERT INTO husNT1971_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Toc’tsin a Jesús: ―Ja’its ax in thuchanchi a Moisés in juntalchic Israel antse’: I Pay’lom Diosil jats juncats expith axi hua’ats. ");
INSERT INTO husNT1971_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Jats jaja’ ca lej jum putat c’anitha’chic c’al patal a ichich, ani c’al patal a ejattal, ani c’al patal a tsalap, ani c’al patal a tsapcua’. Nan tu uchalchic abal ja’its xe’ an uchbixtalab axi más lej huinat exbath. ");
INSERT INTO husNT1971_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Huinat exbath jaye an uchbixtalab ax in thucha’ a Moisés antse’: Ca c’anitha’ patal a at inic jant’ini’ ta c’anithal ta ba’cua’. Nan tu uchalchic abal yab hua’ats q’ue’at i uchbixtalab axi lej huinat exbath ejtil axe’ xi tsab. ");
INSERT INTO husNT1971_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Tam uchan a Jesús c’al nixe’ xi exobchix c’al an ts’ejcath cau binath c’al a Moisés: ―Exobchix, jahua’ tata’ a ulumal lej tequeth. Lej chubax hua’ats juncats a Dios, ani yab hua’ats q’ue’at. ");
INSERT INTO husNT1971_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Lej chubax pel in uchbil an inic quin lej jum putat c’anitha’ a Dios c’al patal in ichich, ani c’al patal in tsalap, ani c’al patal in ejattal, ani c’al patal in tsapcua’. Jaye quin c’anitha’ patal in at inic jant’ini’ tin c’anithal tim ba’cua’. Max antsana’ quin t’aja’, tam ojni’ más in exbath nixe’ xi inic tin tamet a Dios, yab ejtil axi expith in ts’acchiyal a Dios c’al yantalam i tsemthach t’u’lec ani c’al yantalam i ts’acchixtalab jahuaquitsq’ui. ");
INSERT INTO husNT1971_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Tam tin ats’a’ a Jesús abal antsana’ tsalpath toc’tsin nixe’ xi exobchix, in ucha’: ―A q’uibchale expith hue’ abal a Dios quin t’aja’ ti Ts’ale ta ichich. C’al axe’ xi cau ni jita’chic taja’ yabats in inicnal tim ba’ ti quin conomichiquiye a Jesús c’al jant’o. ");
INSERT INTO husNT1971_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","U exobchixe a Jesús ti al an tiyopan, ani in ucha’ axi taja’chic: ―In ulal an exobchixchic c’al an ts’ejcath cau binath c’al a Moisés abal a Cristo pel in tsacamil a David. ");
INSERT INTO husNT1971_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Yab ja cum a David c’uajchith c’al an Espíritu Santo im bijiy a Cristo tin Ajatic. In ulu antse’: A Dios in ucha’ u Ajatic: Teje’ quit buxcan tu huinab c’ubac, ma nan tu pitha’its ta c’ubac a tolmolnaxilchic abal ca tala’ ata’. ");
INSERT INTO husNT1971_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Cum antsana’ a David im bijiy a Cristo tin Ajatic, jaxtam i tso’obits abal yab pel in tsacamil a David. An mulcunel axi c’uajat taja’ in lej culbetnanchal jahua’ antsana’ in ulu a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","A Jesús in exobchiye an inicchic al an tiyopan, in uchalchic: ―Ca lej t’aja’chic ti cuenta yab ca t’aja’ jant’ini’ in t’ajal an exobchixchic c’al an ts’ejcath cau binath c’al a Moisés. In culbetnal ca xe’tsin c’al in nacat coton abal max ca tsu’tat ti pulic in ey. Jaye ca lej tsapnethachic ti bel c’al yan i c’ac’naxtalab. ");
INSERT INTO husNT1971_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ti al an tiyopan in lej c’a’inchal ca buxcan jun ti quetel axi lej c’athpich pulic in ey, aniye jaye tam hua’ats i ajib ts’alat c’apuxtalab. ");
INSERT INTO husNT1971_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ani c’al im pojcaxtal bel in tixc’anchalchic i c’alab an tsemchith uxumchic. U lej ohuel ti ol expith abal max ca tsu’tat ti t’ocat. Jats jaja’chic axi ne’ets ca c’athpich jolbiyat c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Quetel a Jesús ti al am pulic tiyopan tin tamet am poc’te’ jun tu binab an c’ac’naxtalab tumin. In me’tal an inicchic ax im binal an tumin taja’. Yan i ricochic im binal yan i tumin. ");
INSERT INTO husNT1971_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Chich jun i ts’ejhuantal tsemchith uxum im bina’ tsab i tsacam tumin cobre lej hue’ in jalbil. ");
INSERT INTO husNT1971_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","A Jesús in caniy ca uteychic in exobalil, ani in ucha’chic: ―Lej chubax nan tu uchalchic abal axe’ xi ts’ejhuantal tsemchith uxum in lejat bina’ yab ejtil axi q’ue’at im bina’. ");
INSERT INTO husNT1971_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Axi q’ue’atchic im bina’ i jilc’omach tumin, ani jaja’ aba ani’ ts’ejhuantal in tala’ bina’ jahua’ in cua’alac quin cuxuthna’. ");
INSERT INTO husNT1971_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Tam ti calejits a Jesús ti al am pulic tiyopan, uchan c’al jun axi lajuj tsab in exobalilchic: ―Exobchix, ca tsu’u an t’ujubchic jant’ini’ ti alhua’ ts’ejcathits ba’ an tiyopan ani ba’ an atachic ax in cuenta an tiyopan. ");
INSERT INTO husNT1971_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Toc’tsin a Jesús: ―Xohue’ a tsu’talchic am pulic tiyopan ani an atachic ax in cuenta an tiyopan. Ne’ets ca tala’ pacluhuat c’al i inicchic, ma ni jun i t’ujub yab ne’ets ca jilc’on t’i’póx c’al in at t’ujub. ");
INSERT INTO husNT1971_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Tam c’alechic a Jesús junax c’al in exobalilchic ani c’athiy ti bolchal Olivos axi c’uajat tin tamtal an tiyopan. Buxcan taja’ a Jesús hue’ pil c’al a Pedro ani c’al a Jacobo ani c’al a Juan ani c’al a Andrés. Ani uchan c’al jaja’chic: ");
INSERT INTO husNT1971_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―I lej le’ abal tata’ tucu olchi jayq’ui’ ne’ets ca t’ajan jahua’ ti hui’i a ulumal. ¿Jant’o tam tsu’bixtalab qui aychi abal qui exla’ max thubat ne’ets ca taley an q’uij q’uicha? ");
INSERT INTO husNT1971_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Toc’tsin a Jesús: ―Ca lej t’aja’chic ti cuenta abal ni jita’ yab ti c’ambiychic. ");
INSERT INTO husNT1971_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Cum ne’ets ca chich yan i inic ti timc’ox c’al nana’. Ne’ets quin uluchic abal jaja’chic pel a Cristo axi abnenec c’al a Dios, ani antsana’ ne’ets quin c’ambiy yantalam i inicchic. ");
INSERT INTO husNT1971_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Yab quit jiq’ueychic tam quit t’ilchin i pejextalab axi yan u thayc’anal ani más axi taye tal, cum antsana’ bijithits abal ne’ets ca lej thayc’an. Yabaye ne’ets ca thubat taley an q’uij q’uicha. ");
INSERT INTO husNT1971_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","I pulic bichoulom ne’ets ca pejéxin c’al pil i pulic bichoulom. An ts’alechic ne’ets ca tomolnáxin jun c’al xi jun. Ne’ets ca lej t’elelats an tsabal abal ju’tamq’ui, ani ne’ets ca hua’tsin yan i jayil. An inicchic ne’ets ca lej xe’tsin xacuecuel c’al jahua’ in tsu’tal u t’ajnal c’ac’ath. Ani patal axe’ jats expith in ts’i’quintal an lej yajchictalab axi más taye tal. ");
INSERT INTO husNT1971_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Ca junini’ ne’tha’chic ts’ejcacathits a ichich, cum ne’ets quit bina tin c’ubac i oc’lecchic quit othna. Ne’ets quit huithc’oyat tin tiyopanil an Israelchic. Ne’ets quit bina tin c’ubac i oc’lec eyalchic ani tin c’ubac i ts’alechic c’al tin ebal nana’ u bij, ani ne’ets tiquin olnanchi u bij tin tamet jaja’chic. ");
INSERT INTO husNT1971_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Tam ti yabaye talnecaquits an q’uij q’uicha, oc’oxe ne’ets ca olna an alhua’ cau tim puhuel an tsabal cum antsana’ ti bijithits ne’ets ca t’ajan. ");
INSERT INTO husNT1971_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Tam tit binathits tin c’ubac an oc’lecchic yab quit tsalpaxin, ani yab ca oc’chith tsalpay jant’o ne’ets ta ca ucha’chic. Expith ca ucha’ i cau ax quit pithan c’al a Dios tamna’. Yab ne’ets quit cuete’ cahuin, cum an Espíritu Santo jats ne’ets ti pitha’ i cau ca ucha’. ");
INSERT INTO husNT1971_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","I ebchalab ne’ets ca bina c’al in at ebchal abal ca tsemtha, ani ma i tatalab ne’ets quim bina’ in cuete’ tsacamil abal ca tsemtha. I tsacamchic ne’ets quin tomolna’ in tata ani in mim, ma quim bina’ abal ca tsemthachic. ");
INSERT INTO husNT1971_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","C’al tu ebal nana’ jat’hua’ tim patal an inicchic ne’ets ti at’a chic. C’al a t’ayath cuxuthal ne’ets quit jalunthachic ma ta ca taleyits an q’uij q’uicha. ");
INSERT INTO husNT1971_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Ca alhua’ ejtiyat c’al jitats quin ajiy axi más i cau in uluye a Jesús antse’: Ti biyalits an caulome c’al a Dios Daniel in q’uejab thucha’ abal ne’ets ca c’uajba ti al an t’ocat tiyopan jant’o lej c’ac’ath ani q’uibethom. Tam tata’chic ca tsu’u antsana’ c’uajbathits jun ti yab in uchbil ca c’uajiy taja’, tamna’ ax it c’uajatchic teje’ ti Judea quit thubat pit’c’on quit c’ale ti al an ts’en. ");
INSERT INTO husNT1971_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Tam quim bajuhuits nixe’ xa q’uicha, jitats c’uajat tin hualq’ui’lal in q’uima’ ca thubat pa’iy, ani ma yabats ca otsits alta quin calthaye jant’o. ");
INSERT INTO husNT1971_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Jitats c’uajat tin t’ayablabil, ma yabats ca huichiy tin q’uima’ quin calthaye in toltomil. ");
INSERT INTO husNT1971_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Lej ts’ejhuantal an uxum axi co’oth c’al i tsacam ani i uxum axi chuchuthome c’al i tsacam tam quim baju nixe’ xa q’uicha. ");
INSERT INTO husNT1971_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Quin conchichic a Dios abal yab quim baju ca pit’c’on ti al an tsamay q’uij. ");
INSERT INTO husNT1971_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Al nixe’ xa q’uichachic a Dios ne’ets quin abchi an inicchic i c’athpich yajchictalab axi ni jayq’ui’ yab in abchamal, ani ni jayq’ui’ talbel yab ne’ets quin abchi ejtil nixe’ lej huat’ath c’athpich an yajchictalab. ");
INSERT INTO husNT1971_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Max a Dios yab quin t’apiy nixe’ xa q’uij q’uicha lej c’athpich yajchictalab ni jita’ tam inic yab ne’ets quin cuxuy ni ohuat hue’. Cum a Dios lej c’anithom c’al jitats tacuthits tin c’al jaja’, jaxtam ne’ets quin t’apiy tin ebal jaja’chic. ");
INSERT INTO husNT1971_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ne’ets ca xe’tsin i inicchic quin ulu teje’ c’uajat a Cristo ani jun ne’ets quin ulu tihua’ c’uajat a Cristo. Yab ca belchi ja. ");
INSERT INTO husNT1971_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ne’ets ca chich i c’ambixchic ti timc’ox c’al nana’, ani talchic i inic ne’ets quin timc’oy i caulome c’al a Dios. Ma ne’ets quin t’aja’chic jaye i labith t’ajbilab ti tsu’bixtalab, max quin ejtou ani’ quin c’ambiy talchic i inic axi tacuthits tin c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","C’al patal axe’ xi cau nan tu q’uejab olchamalits tata’chic jahua’ yabaye t’ajnenequits. Jaxtam ca lej alhua’ pena’ ta ichich abal yab quit c’ambiyat c’al pil i cau. ");
INSERT INTO husNT1971_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ca taleyits nixe’ xa q’uicha lej huat’ath c’athpich yajchictalabchic, tam ne’ets ca yic’utsin a q’uicha ani a its’ yab ne’ets quim bina’ in tajax. ");
INSERT INTO husNT1971_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ne’ets ca lej tsapic t’elelats an eb, ma ne’ets jololol a ot abal ju’tamq’ui. ");
INSERT INTO husNT1971_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Tam ne’ets quin tsu’tat nana’its tin Juntal patal an inicchic in talits ti eb al i tocoulom. Tam ne’ets cu tejhua’metha’ u lej tsap ani u lej ts’alat. ");
INSERT INTO husNT1971_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ne’ets cu aba’ i ángelchic tiquin tamcunchi an inicchic axi nana’ u tacuyamalits tu c’al. Ne’ets ti tamcunchixchic ma tim puhuel an tsabal. ");
INSERT INTO husNT1971_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Ca ats’a’chic jun i jalpith cau c’al an te’ higuera. Tam ti it in c’ue’elchic ani u puthnalits in xequel, tam a exlalits abal hue’its ne’ets quim baju an c’ac’al q’uij. ");
INSERT INTO husNT1971_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Tam tata’chic ca tsu’uhuits u t’ajnal patal axe’ jahua’ nan tu uchamalits ne’ets ca t’ajan, tam ca exla’its abal hue’its nana’ ne’ets quin chich junil. ");
INSERT INTO husNT1971_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Lej chubax nan tu uchalchic abal yab ne’ets ca taley a juntalchic, ma oc’ox ca t’ajanits patal jahua’ axe’ nan tu olchamalchic. ");
INSERT INTO husNT1971_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","An eb ani an tsabal jats ne’ets ca taley, expith nan u cahuintal ojni’ ni jayq’ui’ yab ne’ets ca taley. Ets’ey ne’ets ca putun. ");
INSERT INTO husNT1971_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Ni jita’ tam inic yab in tso’bim am pejath q’uicha ni am pejath hora tam antsana’ ne’ets ca t’ajan. Ma i ángelchic ti eb ani ma nana’its tin Tsacamil a Dios yab i tso’bim. Expith in tso’bim u Tata ti eb. ");
INSERT INTO husNT1971_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Cum yab a tso’bimchic an q’uicha ani an hora tam ne’ets quin huichiy junil, jaxtam ca junini’ ne’tha’ ts’ejcacathits a ichich tiquim bats’u. Tiquin lej junini’ aychi ani quit lej t’ayat olonchic. ");
INSERT INTO husNT1971_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Nana’its ejtil jun i thabal ata axi ne’ets ca c’ale ou. Oc’ox in uchbiy ti junchic in t’ojnalil jant’o ne’ets quin t’ojna’. In ucha’ am beletnom hui’leb ca lej c’uajiy ts’ejcacath ca japchin an hui’leb tam ca huichiycua’. ");
INSERT INTO husNT1971_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Antsana’ táta’chic quit lej c’uajiy ts’ejcacathits abal tiquim bats’u tam nan quin huichiy junil. Yab a tso’bimchic jayq’ui’ ne’ets quin huichiy junil, max tam ca aclejits, max tam ts’ejel acal, max tam c’a’al ca thajan an coxol, max tam thajuhuits. ");
INSERT INTO husNT1971_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","I quin chich jun jic’tohual tu ela’ it c’uajatq’uichic ejtil i beletnom hui’leb axi huayamath. ");
INSERT INTO husNT1971_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Nan tu lej uluth uchalchic quit ets’ey c’uajiy ts’ejcacathits abal tiquim bats’u, ani ja’its an cau ax u lej uluth uchalac tim patal an inicchic ca ets’ey c’uajiy ts’ejcacathits. ");
INSERT INTO husNT1971_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","In q’uibchale tsab a q’uicha tam an Israelchic quin t’aja’ an ajib tin cuenta abal ti calthame im biyal juntalchic ti Egipto. Pel i q’uij tam an Israel quin c’apu i pan axi yab ts’ejcath c’al i c’ac’chixtalab c’oye. An oc’lec pale’chic ani an exobchixchic c’al an ts’ejcath cau binath c’al a Moisés exome in alimichical jant’ini’ ti quin c’ambiy ani quin yac’ua’ a Jesús, cum in le’ quin tsemtha’. ");
INSERT INTO husNT1971_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","In uluchic: ―Yab qui yac’ua’ tam ajib abal i ca thayc’an i xacueltalab al am bichou. ");
INSERT INTO husNT1971_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","C’uajat a Jesús ti Betania tin q’uima’ a Simón ax in cua’alac an t’it’ axi c’apux c’al in anam t’u’ul. Tam ti quetelits a Jesús ba’ an mexa, chich jun i uxum in chal i frasco ts’ejcath c’al i t’ujub im bij alabastro. T’uchat an frasco c’al i nihuihuiltalab nardo lej chubax ani lej jalbith. Im pejcanchi in nuc’ an frasco, ani taley in jolchi an nihuihuiltalab tin oc’ a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Tam tsacuy talchic axi taja’ c’uajat, in uluchic: ―¿Jale’ tu huac’labq’ui antse’ an nihuihuiltalab? ");
INSERT INTO husNT1971_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ejtohuamejac ca nujuhuat ti ox i bo’ inicchic i denario ani an tumin pithnenecac an ts’ejhuantalchic. Ni hue’ yab culbetnanchat jahua’ antsana’ in t’aja’ an uxum. ");
INSERT INTO husNT1971_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","A Jesús in ucha’chic axi tsacunec: ―Yab a cuenta jahua’ in t’ajamal axe’ xi uxum. Yab ca c’uiya’chic, cum lej alhua’ jahua’ tin tajchamal. ");
INSERT INTO husNT1971_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Cum ets’ey c’uajat an ts’ejhuantalchic c’al tata’chic a ejtohual ca t’ajchi i alhua’talab jayq’uits ta ca le’na’chic, ani nana’ expith jun i hue’ in c’uajat. ");
INSERT INTO husNT1971_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Tin t’ajchi jaja’ ma jant’inits in ejtohual. Aba ani’ yabaye in tsemenec, bel tin jolchi an nihuihuiltalab ejtil max tin q’uejab t’ojojonchalits u inictal tam ne’ets quin joliyat. ");
INSERT INTO husNT1971_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Lej chubax nan tu uchalchic abal ju’tamq’ui ca olnanchat an inicchic an alhua’ cau tim puhuel an tsabal, taja’ ca t’iloxnanchat jaye in t’ajbil axe’ xi uxum. ");
INSERT INTO husNT1971_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Taley jun axi lajuj tsab in exobalilchic a Jesús c’ale quin tsu’u an oc’lec pale’chic abal quin tauna’ ani quin juncu an cau quin tsinat bina’ a Jesús tin c’ubac jaja’chic. Pel a Judas Iscariote. ");
INSERT INTO husNT1971_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Lej culbel jaja’chic tam in ats’a’ jant’o in ulu a Judas, ani in uluchic abal ne’ets quim pitha’ i tumin. Ma tam ti tamits a Judas in lej alimichical jant’ini’ ti quin tsinat bina’ a Jesús tin c’ubac in tomolnaxilchic. ");
INSERT INTO husNT1971_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Im bajuhuits an c’a’al q’uicha an ajib tin cuenta am bichou Israel ti calthame ti Egipto ti biyal. Tamits tu c’apab am pan axi yab ts’ejcath c’al i c’ac’chixtalab c’oye ani tam tu tsemthab an cordero ti ts’acchixtalab. Conoyab a Jesús c’al in exobalilchic: ―¿Ju’tam a le’ qui t’ojojoy abal cu c’aputs tin cuenta in ajib am biyal bichou Israel ti calthame ti Egipto? ");
INSERT INTO husNT1971_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Cum a Jesús ne’ets quin oc’chith aba’ tsab in exobalilchic in ucha’chic: ―Quit c’alechic nihua’ ti bichou Jerusalén, ani taja’ ne’ets ca baju jun i inic in ic’tal i ja’ c’al i mul. Jats ca ts’at’enchi. ");
INSERT INTO husNT1971_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Jun ti jaja’ ca otsits ca ucha’ an thabal c’al an ata antse’: An Exobchix Jesús ti abchal jun i cau. Ti conoyal abal jahua’ tam alta ta q’uima’ ca matinchi quin t’aja’ an c’apuxtalab junax c’al in exobalilchic tin cuenta in ajib am biyal bichou Israel ti calthame ti Egipto. ");
INSERT INTO husNT1971_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Tam an thabal ata ne’ets ti olchi jun i pulic alta ts’ejcacathits tim pulic punchith atajil. Tats ta ca t’ojojoychic an c’apuxtalab ajib. ");
INSERT INTO husNT1971_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Tam c’ale axi tsab i exobal, ulitschic ti Jerusalén. In ela’ jant’ini’ ti uchanits c’al a Jesús, ani tats tin t’ojojoychic patal tin cuenta an c’apuxtalab ajib. ");
INSERT INTO husNT1971_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ani aclejits tam ti ulitschic a Jesús junax c’al axi lajuj tsab in exobalilchic al nixe’ xi ata. ");
INSERT INTO husNT1971_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Tam ti quetelits ti c’apul ba’ an mexa, a Jesús in ucha’chic: ―Lej chubax tu uchalchic abal jun axi lajuj tsab c’al tata’chic ax it junax c’apul c’al nana’ ne’ets tiquin tsinat bina’ tin c’ubac u tomolnaxilchic. ");
INSERT INTO husNT1971_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Tam ojni’ lej t’e’pinchic, in conoyal ti junchic ti junchic: ―¿Hualamac xe’ max nana’ ja’its? ");
INSERT INTO husNT1971_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","A Jesús in toc’tsiychic: ―It lajuj tsab ta eb nana’ tu exobalil, ani ja’its jun ax u lej c’apul c’al nana’ u talabil. ");
INSERT INTO husNT1971_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Bel alhua’ quim bina ani quin tsemtha, cum nana’ tin Juntal patal an inicchic antsana’ im bijchithits ti al an T’ocat Thuchlab. Tocat lej c’athpich ts’ejhuantal nixe’ xi inic axi ne’ets tiquin tsinat bina’, cum ne’ets ca lej yajchiquiyat. Alhua’ max lejatac yab hua’tsinenec. ");
INSERT INTO husNT1971_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Biyat u c’apul an exobalchic, a Jesús im pena’ am pan ani im bina’ i c’ac’namal yan c’al a Dios. In mu’u ani im pitha’ in exobalilchic, ani in ucha’chic: ―Ca c’apuchic axe’ u anam t’u’ul. ");
INSERT INTO husNT1971_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Tam im pena’ an uts’umtalab c’al an vino ani im bina’ i c’ac’namal yan c’al a Dios. In huat’banchi in exobalilchic quin uts’a’ tim patal jaja’chic. ");
INSERT INTO husNT1971_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","In ucha’chic: ―Axe’ pel u xits’al axi hue’its ne’ets quin huac’lanchat ti al an cruz abal yantalam i inicchic ca paculanchat in hualab. C’al tin ebal u huac’lath xits’al a Dios ne’ets quin ts’ejca’ i it jilchith cau c’al an inicchic. ");
INSERT INTO husNT1971_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Lej chubax nan tu uchalchic abal yabats ne’ets cu uts’a’ i vino lab t’uthub c’al tata’chic ejtil u t’ajal xo’. Ma tihua’ talbelaquits tam ti a Dios quin t’aja’ ti lej Ts’ale, tam tiq’uele ne’ets cu uts’a’ junil. ");
INSERT INTO husNT1971_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Taley a Jesús ani in exobalilchic in ajatnanchi im bij a Dios, ani tam c’alechic ti bolchal Olivos. ");
INSERT INTO husNT1971_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Taja’ a Jesús in ucha’chic: ―Patal tata’chic tin ebal u tsemtal ne’ets quit t’apchin a tsalap axe’ xi acal. In olnab ti al an T’ocat Thuchlab jant’o ne’ets quin t’ajchin c’al a Dios antse’: Nan ne’ets cu tsemtha’ am beletnom oveja, ani ne’ets ca buc’uhuat tam an ovejachic, in ulu a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Talbel tam quin ejthajits ne’ets quin oc’chith c’ale ti Galilea, ani tata’chicte quit c’ale talbel. ");
INSERT INTO husNT1971_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Tam uchan a Jesús c’al a Pedro: ―Aba ma patal an ts’at’el ca t’apchin in tsalap yab ti ts’at’enchi, nan ojni’ ne’ets tu junini’ ts’at’enchi. ");
INSERT INTO husNT1971_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Toc’tsin a Jesús: ―Lej chubax nan tu uchal abal axe’ xi acal ne’ets ca tsinca’ ta ba’ c’al nana’ oxil i calat ma tam ti ibaque thajnenec tsabil i thajach an coxol. ");
INSERT INTO husNT1971_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Bel a Pedro in lej ucha’ a Jesús: ―Aba ma quin le’nane quin tsemtha junax c’al tata’, nan yab ne’ets cu tsinca’ tu ba’. Taley patal in exobalilchic a Jesús in ulu jayetseq’ui jant’ini’ in ulu a Pedro. ");
INSERT INTO husNT1971_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Taley ulits a Jesús junax c’al in exobalilchic al jun i tsabal im bij Getsemaní. Taja’ a Jesús in ucha’chic: ―Quit jilc’onchic teje’, biyat nan ne’ets quin c’ale hue’ nihua’ quin olon. ");
INSERT INTO husNT1971_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Expith a Pedro ani a Jacobo ani a Juan jats axi ne’tha ca c’alechic jaye. Ani ley huat’ath c’athpich yajchic in ichich a Jesús, ma lej c’olothits tin inictal in ats’al. ");
INSERT INTO husNT1971_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Jaxtam in ucha’ axi ox in exobalil: ―U ats’al ejtil max u lej tse’eyab u ichich c’al i c’athpich t’e’pithtalab, ma ejtil ne’ets quin tsemetsits. Tata’chic quit jilc’on teje’ ani yab quit huayits. ");
INSERT INTO husNT1971_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Tam nixq’uin a Jesús hue’ nihua’, ani t’ajat pac’lun tsabal. In conchal a Dios max u ejtohuabac ca jaluntha abal yab quin yajchicna’ an yajchictalab axi taye tal. ");
INSERT INTO husNT1971_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","In ucha’ a Dios antse’: ―Tata ti eb, a huit’al ca t’aja’ patal jahuats ca le’na’. Tiquin jaluntha’ abal yab cu yajchicna’ an yajchictalab axi taye tal. Ani max i, bel u lej le’ tu t’ajchi a culbetal ani yab u cuete’ culbetal. ");
INSERT INTO husNT1971_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Tam huichiy a Jesús jun ti c’uajat axi ox in exobalilchic, ani in tsu’u tocat huayamathchic. Ani in conoy a Pedro: ―¿Simón, it huayamathchic? ¿Jale’ yab a ejtouchic quit c’uajiy yab quit huayits ma ni jun i bora? ");
INSERT INTO husNT1971_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ca junini’ ne’tha’chic ts’ejcacath a ichich quit olon abal yab ti ata’ an teneclab. Lej chubax lej canat a ichich ca olon c’al nana’, tocat a anam t’u’ul jats yab u lej tsapnel. ");
INSERT INTO husNT1971_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Tam c’ale junil a Jesús ca olon. In ucha’ in Tata ti eb jayetseq’ui an cau ax in oc’ox uchamalits. ");
INSERT INTO husNT1971_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Huichiy junil c’al axi ox in exobalilchic, ani in tsu’u tocat huayamathchic junil cum atanits c’al i ts’ebattalab. A Jesús in tauna’chic, ani jaja’chic yab in tso’ob jant’ini’ ta ca toc’tsin. ");
INSERT INTO husNT1971_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Oxchilab c’ale a Jesús ca olon, ani taley huichiy junil c’al in exobalilchic in ucha’chic: ―Xohue’ alhua’ max anac quit hue’ huayitschic ani quit coyots, tocat yab in tomnal ani’, cum im bajuhuits an hora nana’ tin Juntal patal an inicchic ne’ets quin tsinat bina tin c’ubac i hualbith inicchic. ");
INSERT INTO husNT1971_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Xo’ quit ts’aquiychic ani huana. Tax talits jaja’ axi ne’ets tiquin tsinat bina’ tin c’ubac u tomolnaxilchic. ");
INSERT INTO husNT1971_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Exome ti cau a Jesús c’al in exobalilchic tam ti ulits a Judas axi jaye ajith c’al xi lajuj tsab an exobal. Ulits junax c’al jaja’ yan i yac’ual ts’ejcachic c’al i matset ani c’al i te’chic. Abnenec jaja’chic c’al an oc’lec pale’chic, ani c’al an exobchixchic c’al an ts’ejcath cau binath c’al a Moisés, ani c’al an yejtselabchic Israel. ");
INSERT INTO husNT1971_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","A Judas antse’ in olchi an t’ipchixtalab an yac’ualchic: ―Jitats nan cu ts’uts’bay, jats tata’chic ca yac’ua’ ani ca ne’tha’ lej alhua’ beletnath. ");
INSERT INTO husNT1971_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Tam utcan a Judas tin tamet a Jesús, in ucha’: ―Exobchix. Tameq’ui in ts’uts’bay. ");
INSERT INTO husNT1971_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Tameq’ui yac’uan a Jesús c’al in juntalchic a Judas. ");
INSERT INTO husNT1971_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Jun ax pel in exobalil a Jesús in jixa’ in matsetil ani in muts’q’uinchi in xutsun in tolmixal an ts’ale pale’. ");
INSERT INTO husNT1971_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Tam a Jesús in ucha’ an yac’ualchic: ―Tata’ ojni’chic it che’nec tiquin yac’ua’ c’al i matset ani c’al i te’chic ejtil max pel in cue’. ");
INSERT INTO husNT1971_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Chuthel chuthel in c’uajatac tin exobchix ta tiyopanil ani yab tin yac’ua’ taja’. Ma xo’ ojni’ tin yac’ualchic abal antsana’ ta ca putun an T’ocat Thuchlab jant’ini’ tin thuchnenequits antse’ quin yac’uan. ");
INSERT INTO husNT1971_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Tam t’ajat c’ale ti athil patal in exobalil a Jesús, ani tam jaja’ jilcacayatits. ");
INSERT INTO husNT1971_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Expith ts’at’ate c’al a Jesús jun i cuitol axi malilith c’al i putat toltom. Ne’etsac ca yac’uan jaja’ jaye c’al an yac’ualchic c’al a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Tocat yab lej ejtohuat ca yac’uan. Tam ti yac’uabac, expith am putat toltom jilc’on tin c’ubac an yac’ual, an ta c’ale an cuitol c’ot’it’ith. ");
INSERT INTO husNT1971_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Taley ta ne’thajits a Jesús ma tin q’uima’ an ts’ale pale’. Taja’ tamcunalits patal an oc’lec pale’chic ani i yejtselabchic Israel ani i exobchixchic c’al an ts’ejcath cau binath c’al a Moisés. ");
INSERT INTO husNT1971_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ani a Pedro ta tale ts’at’at hue’ ou. Talbel ulits jaye tin q’uima’ an ts’ale pale’, ani buxcan ti al am patio c’al an yac’ualchic ti thilal ba’ an c’amal. ");
INSERT INTO husNT1971_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ani an oc’lec pale’chic ani an cuenel axi c’athpich in ey an ts’ejcom cau tin cuenta an tiyopanchic Israel in alimichical jant’ini’ ti quin jolbiy a Jesús abal ca tsemtha, tocat yab in elchal jant’ini’ ti quin chubax jolbiy. ");
INSERT INTO husNT1971_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Yantalam i inicchic in jolohual i janamtalab tin cuenta a Jesús, ani yab lej juncuth jahua’ in ulalchic. ");
INSERT INTO husNT1971_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Talchic i inic cubiy ti jolbix c’al i q’uet’ach cau. In uluchic: ");
INSERT INTO husNT1971_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―I ats’a’ quin ulu antse’: Ne’ets cu paclu axe’ xi tiyopan axi pel in ts’ejcabil i inic, ani ti ox a q’uicha ne’ets cu ts’ejca’ junaque it axi yab pel in ts’ejcabil i iniccua’. ");
INSERT INTO husNT1971_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Tocat yab jununul an cau jahua’ in olnal an jolbixchic. ");
INSERT INTO husNT1971_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Taley cubiy an ts’ale pale tin tamet an cuenel ts’ejcom cauchic, ani in conoy a Jesús: ―¿Yab ne’ets ca toc’tsiy ni jun an jolbixtalab jahua’ it uxnal? ");
INSERT INTO husNT1971_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Yab toc’tsin a Jesús. Ani junil u conoyab c’al an ts’ale pale’: ―¿Tata’its it Cristo ti Tsacamil a Dios, a Dios axi huahua’ i c’ac’nal? ");
INSERT INTO husNT1971_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Toc’tsin a Jesús: ―Nana’ ojni’ ja’its. Ani tata’chic ne’ets tiquin exlanchi u ey tam in quetelits tin huinab c’ubac a Dios ti eb ax in cua’al patal in cuete’ tsap. Ani ne’ets tiquin exlanchiye u ey abal pel tin lej Juntal patal an inicchic tam quin huichiy junil pa’i’ilits al i tocoulom. ");
INSERT INTO husNT1971_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","C’al nixe’ xi cau lej tsacuy an ts’ale pale’, ma in mits’al in nacat coton. In ulu: ―Yabats i yejenchal jita’ más tucu olchi tin cuenta axe’ xi inic. ");
INSERT INTO husNT1971_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Xohue’its ojni’ a ats’amal tata’chic jahua’ in ulumal ejtil max jaja’ pel a Dios. ¿Jant’ini’ ta tsalpayalchic nana’ jant’ini’ tu cu t’ajchi? Tam patal axi muthat taja’chic in toc’tsiy abal alhua’ max ca tsemtha, cum lej jolbithits jaja’. ");
INSERT INTO husNT1971_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Tam talchic i inic taja’ in tubcanchal a Jesús ani im paxq’uinchal in hual. In mo’canchal i c’ubaclec ani in uchalchic: ―Tucu olchi jita’ ti cuatha’. Taley an yac’ualchic jaye in mo’canchi i c’ubaclec tin hual a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","C’uajat a Pedro ti al am patio tin q’uima’ an ts’ale pale’, ani ulits jun axi pel in cuthinelil an ts’ale pale’. ");
INSERT INTO husNT1971_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","In tsu’u jaja’ a Pedro ti thilal ba’ an c’amal. In lej met’al, ani in ucha’: ―Tata’ ojni’ pel it ts’at’el c’al a Jesús Nazaretib. ");
INSERT INTO husNT1971_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Tam a Pedro in tsinca’ tim ba’, in ulu: ―Yab u exlal jita’ jaja’ ax a ulal. Tameq’ui ti calpanits eleb a Pedro, tam thajnalits an coxol. ");
INSERT INTO husNT1971_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ani an cuthinel in lej met’al a Pedro junil, ani in ucha’ axi c’uajatchic taja’: ―Jaja’ ojni’ pel in juntal axi ts’at’elchic c’al a Jesús Nazaretib. ");
INSERT INTO husNT1971_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","A Pedro in tsinca’ tim ba’ junil. Tam uchan jaye c’al axi c’uajatchic taja’: ―Lej chubax tata’its ojni’ pel ti juntal axi ts’at’elchic c’al a Jesús. Ti tejhua’methal a cahuintal abal pel it lej Galileajib jant’ini’ axi pel i ts’at’elchic. ");
INSERT INTO husNT1971_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Tam a Pedro in ulu alhua’ max ca t’ajat yajchiquiyat c’al a Dios max yab chubax jahua’ in ulumal. In cuba’ tim ba’ ti lej chubax, in ulu: ―Yab u exlal jita’ tam inic nixe’ ax a ulal. ");
INSERT INTO husNT1971_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Tameq’ui tin tsabchil thajnal an coxol. Tam a Pedro in t’ilpa’ jahua’ uchnenec c’al a Jesús abal ne’ets quin tsinca’ tim ba’ c’al a Jesús oxil i calat tam ti ibaque thajnenec an coxol tsabil. Tam tin tsalpanchi nixe’ xi cau jahua’ uchnenequits, tam ti uq’uin. ");
INSERT INTO husNT1971_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Tam ti chutheyits, tamcun an oc’lec pale’chic ani an yejtselabchic Israel ani an exobchixchic c’al an ts’ejcath cau binath c’al a Moisés ani an cuenel axi c’athpich in ey an ts’ejcom cau tin cuenta an tiyopanchic Israel. Taley in huic’a’chic a Jesús ani in ne’tha’ c’al a Pilato ax pel i gobernador ti Judea. ");
INSERT INTO husNT1971_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Taja’ conoyab a Jesús c’al a Pilato: ―¿Tata’its pel ti Ts’alejil an Israelchic? Toc’tsin a Jesús: ―Nana’ ja’its ojni’ ax a ulal. ");
INSERT INTO husNT1971_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ani u lej jolbiyab a Jesús c’al yan i jolbixtalab c’al an oc’lec pale’chic. ");
INSERT INTO husNT1971_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Tam a Pilato in conoyale a Jesús: ―¿Yab t’ajat ne’ets ca toc’tsiy c’al ni jun i jolbixtalab ax ti jolbiyal? ");
INSERT INTO husNT1971_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ani cum yab toc’tsin a Jesús, a Pilato yab in exlal jant’ini’ ti quin tsalpanchi. ");
INSERT INTO husNT1971_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","In ujnam a Pilato quin hualca’ jun i huic’nel tam u t’ajnal an ajib tin cuenta abal calthame ti biyal an Israelchic ti Egipto. Quin hualca’ an huic’nel jitats ca bijchin c’al am bichou. ");
INSERT INTO husNT1971_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","C’uajatchic ti al an huic’axte’ yan i inicchic axi pejexnenequits c’al an oc’lecchic ani tsemthomamathits c’al i inicchic. Jun jaja’ im bijchic Barrabás. ");
INSERT INTO husNT1971_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Uchan a Pilato c’al an mulcunel quin hualca’ jun i huic’nel jant’ini’ in ujnam quin t’aja’. ");
INSERT INTO husNT1971_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Toc’tsin a Pilato, in conoy: ―¿A le’ Israelchic abal nan tu hualcanchi axe’ axi pel a Ts’alejil? ");
INSERT INTO husNT1971_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","A Pilato in exla’its abal u lej pa’ixnab a Jesús c’al an oc’lec pale’chic, ani jats ti binanchamejits tin c’ubac abal jaja’ quin jolbiy. ");
INSERT INTO husNT1971_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ani an oc’lec pale’chic tocat in nixoc’nal an mulcunel abal quim bijchi a Barrabás ca hualca. ");
INSERT INTO husNT1971_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Tam a Pilato in conoy an mulcunel: ―¿Ani janto’ a le’ abal nan cu t’ajchi a Ts’alejil, Israelchic? ");
INSERT INTO husNT1971_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ani lej thajat toc’tsin tamna’ an mulcunel: ―Ca t’ajat bina’ ca q’uet’ath tsemtha ti al an cruz. ");
INSERT INTO husNT1971_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Conoyabe an mulcunel c’al a Pilato: ―¿Jant’o yab alhua’ in t’ajamalac abal cu bina’? Ani lej thajat toc’tsin junil an mulcunel: ―Ca t’ajat bina’ ca q’uet’ath tsemtha ti al an cruz. ");
INSERT INTO husNT1971_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Tam a Pilato in aba’ an cau ca hualca a Barrabás, cum in le’ abal ca jilc’on culbel an mulcunel. Ani im bina’ a Jesús ca huithc’oyat c’al an soldadochic, ani taley ca ne’tha ca q’uet’ath tsemtha ti al an cruz. Ani antsana’ huithc’oyat a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Taley an soldadochic in caltha’ a Jesús eleb ti al am patio, ani taja’ tamcun patal an soldadochic axi pel i beletnom c’al an gobernador. ");
INSERT INTO husNT1971_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ani jaja’chic in tilibnath t’ajchal a Jesús ti ts’ale. In cay’chal i tsacni’ nacat coton ani im punchal tin oc’ jun i thipath q’uith corona. ");
INSERT INTO husNT1971_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","In lej thajat uluchic i tilibnax cau antse’: ―Je’its an Ts’ale c’al an Israelchic. ");
INSERT INTO husNT1971_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Taley an soldadochic in cuajchal c’al i pacáb tin oc’ a Jesús, ani in tubcayal. In tilibnath tuthuhual in c’ualalchic tin tamet. ");
INSERT INTO husNT1971_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Tam ti antsana’ in lej tilibna’its, tam in tixc’anchi nixe’ xi coton ani in cay’chi in cuete’ c’al. Ma tamna’its t’ajat in ne’tha’chic quin q’uet’ath tsemtha’ ti al an cruz. ");
INSERT INTO husNT1971_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Tam ti ne’ets ne’thabits a Jesús ti bel, tal jun i inic im bij Simón axi pel i Cirenejib. Tal eleb ti al am bichou ani u aynalits. Pel i tatalab c’al a Alejandro ani c’al a Rufo. Jats punuhuat c’al an soldadochic abal quin quitnanchi an cruz ax in quitnal a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Taley ultsitschic al jun i c’uajattalab im bij Gólgota. Ti tenec cau in le’ quin ulu Tam’oc’. ");
INSERT INTO husNT1971_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","An soldadochic im pitha’ a Jesús i vino xaluth c’al in xits’al i tsacam te’ mirra lej ts’a’ic. Yab in uts’a’. ");
INSERT INTO husNT1971_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Tam ti q’uet’athits a Jesús ba’ an cruz, tam an soldadochic in calthal i q’uij jant’ini’ ti junchic quin c’alnanchi in toltomil. ");
INSERT INTO husNT1971_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Pel i beleu hora an thaju ani q’uet’ath a Jesús ti al an cruz. ");
INSERT INTO husNT1971_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Tin oc’ an cruz punchithits i thuchlab jolbixtalab axi antse’ thuchath: Ja’its axe’ in Ts’alejil an Israelchic. ");
INSERT INTO husNT1971_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Q’uet’ath c’uajat jaye al i cruz c’al a Jesús tsab i cue’, jun tin huinab ani jun tin c’uatab. ");
INSERT INTO husNT1971_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Antsana’ ti putnal an T’ocat Thuchlab jant’ini’ tu thuchath olnab a Jesús antse’: Tsalpanchat jaja’ ti pojcax inic. ");
INSERT INTO husNT1971_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ani talchic ax u huat’el ba’ am bel in quithab uchal tin hual a Jesús. Tocat in huihuohuiyal in oc’ cum im pojcal a Jesús. In ucha’chic i tilibnath cau: ―Tata’ ojni’ a ulumalits a ejtohualac ca paclu an tiyopan ani ti ox a q’uicha ca tsab ts’ejca’ junil. ");
INSERT INTO husNT1971_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Xohue’its ca jec’ontha’ ta ba’, quit pa’iy ba’ an cruz. ");
INSERT INTO husNT1971_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ma tilibnab a Jesús jaye c’al an oc’lec pale’chic ani c’al an exobchixchic c’al an ts’ejcath cau binath c’al a Moisés. In tilibnath uluchic: ―In jec’onthamal q’ue’at i inicchic ani abal jaja’ yab in ejtohual quin jec’ontha’ tim ba’. ");
INSERT INTO husNT1971_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Max chubax jaja’ ja’its pel a Cristo ax u aychab c’al an Israelchic ca chich ti Ts’ale, ca t’ajat pa’iy ba’ an cruz. Ojni’ ne’ets qui bela’ max qui tsu’u pa’iyits. Ma tilibnab a Jesús c’al nixe’ xi tsab i cue’ jaye axi q’uet’ath ba’ i cruz. ");
INSERT INTO husNT1971_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Taley tala’ yic’utsin tim puhuel an tsabal ma ti ts’ejel q’uicha ani ma ti ox hora an huacal. ");
INSERT INTO husNT1971_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ma tam ti tamits nixe’ xi hora in lej tsapic ulu a Jesús: ―Eloi, Eloi, ¿lama sabactani? Ti tenec cau in le’ quin ulu: U Diosil u Diosil, ¿jale’ tin jilcacayamalits? ");
INSERT INTO husNT1971_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ani talchic i inic axi c’uajat taja’ tam tin ats’a’ nixe’ xi cau, in uluchic: ―Ca ats’a’ jant’o in ulal in caniyal ca chich am biyal caulome c’al a Dios Elías. ");
INSERT INTO husNT1971_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Tam jun jaja’chic ax in ats’al thubat athlats abal quin iq’ui’ i thic’axtalab axi hue’ ejtil i cuinim. In tsabay al i ts’a’ic vino ani in umchi tin chum i te’. In utunchi tin hui’ a Jesús abal quin juts’u ani in ulu: ―Qui hue’ aychiye max ca chich a Elías quim pa’ba’ ti al an cruz. ");
INSERT INTO husNT1971_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Tam lej tsapic cahuin a Jesús, ani taley tsemetsits. ");
INSERT INTO husNT1971_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Tameq’ui ti cathlun ma ebal ani ma alal am pelcath toltom ba’ am pulic tiyopan. Jilc’on tsab i pejach. ");
INSERT INTO husNT1971_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ani taja’ cubat jun i capitán soldado romano tin tamet a Jesús. Cum in ats’a’ lej tsapic thajan a Jesús ani in tsu’u jant’ini’ ti tsemetsits, in ulu: ―Axe’ xi inic ojni’ ja’its pel in Tsacamil a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ani c’uajatchic hue’ ou taja’ talchic i uxum in met’al a Jesús ba’ an cruz. C’uajat a María Magdalajib, ani a Salomé, ani a María axi pel in mim a José ani a Jacobo an talbel cuitol. ");
INSERT INTO husNT1971_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Pel jaja’chic i uxum axi ts’at’enec ani tolmixin c’al a Jesús ma tam ti jaja’ xe’etsac ti Galilea. C’uajatchic taja’ jaye yantalam q’ue’at i uxum axi ulits ti Jerusalén junax c’al a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Pel i viernes ani lej huaclejits. Pel an q’uicha tam ti t’ojojol an Israelchic tin cuenta an sábado. ");
INSERT INTO husNT1971_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Chich a José Arimateajib axi lej ajith ti al an cuenel axi c’athpich in ey an ts’ejcom cau tin cuenta an tiyopanchic Israel. Pel i inic ax in junini’ aychal a Dios ca chich quin t’aja’ ti lej Ts’ale teje’ tsabal. C’al in ichich tsaplilithits otsits c’al a Pilato quin conchi in inictal a Jesús quin joliy. ");
INSERT INTO husNT1971_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","A Pilato in jic’pal max thubat tsemetsits a Jesús, ani in caniy ca chich an capitán soldado quin conoy max chubax tsemetsits. ");
INSERT INTO husNT1971_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Tam ti olchinits a Pilato abal chubax tsemenequits, tam in ucha’ a José quin ne’thanchi in inictal a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Oc’ox c’ale in ts’a’iy jun i ts’alat putat toltom. Taley huichiy im pa’banchi in inictal a Jesús ani in thu’bay. Tam in ne’thanchi ani in mo’canchi al i jolimtalab tsajath jol paxal t’ujub. Ani jun i pulic t’ujub cubat taja’ in toliy ani im paxq’uinchi an otsnamtalab. ");
INSERT INTO husNT1971_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ani taja’ a María Magdalajib ani a María in mim a José in tsu’uchic jun ti joliyat in inictal a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Huat’eyits an q’uicha sábado ani a María Magdalajib, ani c’al a Salomé, ani c’al a María in mim a Jacobo c’alechic quin ts’a’iy i nihuihuiltalab quin ne’tha’ quin umchi tin inictal a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Pel an c’a’al q’uicha semana lej thajujul tam ti jaja’chic ultsits ti al an jolimtalab. ");
INSERT INTO husNT1971_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","In uluchic: ―¿Jita’ hualam ne’ets tucu tixc’anchi am pulic paxic’lab t’ujub tin otsnamtal an jolimtalab? ");
INSERT INTO husNT1971_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Taley in met’a’chic ani in tsu’u tixc’athits am pulic t’ujub. ");
INSERT INTO husNT1971_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Tam otsitschic alta ti al an jolimtalab, ani taja’ in tsu’u jun i ángel quetel tin huinab an jolimtalab. In tejhua’ inictal ejtil i cuitol, ani toltomith c’al jun i nacat coton lej thacninil. Ani tocat lej jiq’uelchic. ");
INSERT INTO husNT1971_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Tam uchanchic c’al an ángel: ―Yab quit jiq’ueychic. A aliyal a Jesús Nazaretib axi q’uet’ath tsemtha ti al an cruz. Xo’ ejthachits ani yabats c’uajat teje’. Ca met’a’ te jun ti c’uajatac in inictal, xant’ojits. ");
INSERT INTO husNT1971_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Quit c’alechic ca olchi in exobalilchic ani a Pedro abal a Jesús tihua’ ne’ets ca oc’chith ulits ti Galilea. Jaja’chic ca c’ale tihua’ quin tsu’u, ani tam ojni’ ne’ets quin tso’obna’ abal chubax ejthachits jant’ini’ nan xohue’ te tu uchalchic. ");
INSERT INTO husNT1971_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Tam tixc’an axi ox i uxum ti al an jolimtalab, ta c’alechic ti athil. Cum t’elelel ne’ets c’al in jiq’uib, yab in taunalchic jita’ ti bel. ");
INSERT INTO husNT1971_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Pel an c’a’al q’uicha semana tam ti ejtha a Jesús, ani oc’ox tejhua’me c’al a María Magdalajib axi canchinenec c’al a Jesús buc i at’ax teneclab. ");
INSERT INTO husNT1971_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ani jaja’ c’ale quin olchichic ani’ axi junax xe’tsinenequits c’al a Jesús. Tam ti ultsits a María in tsu’uchic lej t’e’pith ani uc’nal. ");
INSERT INTO husNT1971_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Tam ti olchinchic abal ejthachits a Jesús ani tsu’ume c’al a María, yab im belchalchic. ");
INSERT INTO husNT1971_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Taley talbel tejhua’me a Jesús c’al in inictal hue’ pil ti tejhua’ c’al tsab in exobalil axi ne’ets huat’et’el utat i alte’. ");
INSERT INTO husNT1971_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Taley ta c’ale jaja’chic quin olchi axi q’ue’atchic in at exobal abal in tsu’uchic ejthachits a Jesús. Jayetseq’ui yab im belchalchic jahua’ antsana’ u olchinal. ");
INSERT INTO husNT1971_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Taley talbel tejhua’me a Jesús c’al xi lajuj jun in exobalil tam ti quetelchic ti c’apul ba’ i mexa. Ani a Jesús in c’uiya’chic, cum jale’ t’ujbabathe in ichich ani yab im belchamalits jant’ini’ ti olchinenequits c’al ax ti tsu’umejits ejthachits. ");
INSERT INTO husNT1971_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Tam a Jesús in ucha’chic: ―Quit c’alechic tim puhuel an tsabal ca olnanchi an alhua’ cau c’al tim patal an inicchic. ");
INSERT INTO husNT1971_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Jitats quim bela’ an alhua’ cau ani ca pujan ne’ets ca jec’ontha. Jitats yab quim bela’ ne’ets ca jolbiyat c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Axi belomits ne’ets quin t’aja’ i labith t’ajbilab ti tsu’bixtalab abal lej chubax an alhua’ cau jahua’ in olnalchic. C’al u bij ne’ets quin caltha’ i at’ax teneclab. Ne’ets quin cauna’ i pil cahuintalab axi yab in cuete’ cahuintal. ");
INSERT INTO husNT1971_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Yab ne’ets ca othna max quim pena’ i tsan c’al in c’ubac ani max quin uts’a’ jahua’ u it’ix. Ne’ets quim punchi in c’ubac tin anam t’u’ul i ya’ul ani ne’ets quin jeltha’chic. ");
INSERT INTO husNT1971_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Tam ti an Ajatic Jesús antsana’ in ucha’its in exobalilchic, tam tihua’ c’alets ti eb. Tats ti buxcan tin huinab c’ubac a Dios jant’ini’ ti puhuethanchatits im bij c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ani in exobalilchic ta c’ale ti olnom c’al an alhua’ cau abal ju’tamq’ui ca xe’tsin. An Ajatic in tolminchalchic quin t’aja’ i labith t’ajbilab ti tsu’bixtalab. Antsana’ quin exla’ an inicchic abal lej chubax an alhua’ cau jahua’ u olchinal. Amén.");
INSERT INTO husNT1971_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Talchic i inicchic in thuchamalits tin cuenta jahua’ in t’ajamal an Ajatic tam ti xe’tsin teje’ tsabal. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Jahua’ jaja’chic in olchamalits jave jats an cau jahua’ huahua’hue u olchinenequits c’al ax in c’a’al tsu’umalchic an Ajatic ani in c’a’al olnamal an alhua’ cau. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Cum nana’ne u lej alhua’ t’ajamalits ti cuenta in xe’tsintal ani in t’ajbilchic an Ajatic ma tin tujtal, jaxtam u tsalpayal abal in tomnal tu thuchanchi, huinat alhua’ Teófilo. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Antsana’ ne’ets tu tequeth thuchanchi abal ca lej alhua’ exla’ abal ja’its an lej chubax cau ax it olchinenequits. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Tam ti a Herodes pelac i ts’ale ti bichoulom Judea, a Zacarías c’uajatac ti pale’. Pel in at pale’ c’al an cuenel im bij Abías. In q’uimathil a Zacarías pel a Elisabet axi pel i at xits’lab c’al am biyal pale’ Aarón. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Cum a Zacarías ani a Elisabet ets’ey im putuhual c’al in uchbixtal a Dios, jats ti tsu’tat ti pututhchic c’al a Dios. Yab in q’uibchamal in c’ac’naxtal c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","A Elisabet yabats in ejtohual quin co’oy i tsacam, cum lej uxcue’labits. Ani a Zacarías lej yejtselabits. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Im bajuhuits im pejchith q’uichajil an cuenel Abías quin t’ojonchi a Dios ti pale’. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Patal an cuenel in ujnam ca bijchin in q’uij abal jant’o tam t’ojlab ne’ets quin t’aja’ al nixe’ xi pejchith q’uicha. Ani bijchinits a Zacarías abal quin chica’ an jom ti al am pulic tiyopan. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Tam tin chicalits an jom alta, tam ti c’uajatits patal an c’ac’nax eleb ti ol. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ani chich jun i ángel c’al a Zacarías tal abath c’al a Dios, cubiy tin huinab an ts’acnaxtalab jun tu chicnal an jom. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Tam tin tsu’uhuits a Zacarías an ángel, tocat lej jiq’uel. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Tam uchan c’al an ángel: ―Yab quit jiq’uey Zacarías, cum a Dios ti ats’anchamalits a conchixtal. Xo’ a q’uimathil Elisabet ne’ets quin co’oy i tsacam, ani tata’ ca bijiy ta Juan. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ne’ets quit lej culbe c’al a tsacamil, ani jaye yantalam i inicchic ne’ets ca culbe abal hua’tsinenec. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Cum jaja’ ne’ets quim baju ti lej pulic c’al a Dios. Yab ne’ets quin uts’a’ i vino ani yab ne’ets quin uts’a’ jant’o boclith ca huiletha. Ma tin hua’tsintal ne’ets ca jum putat co’onchat in ichich c’al an Espíritu Santo. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ne’ets quin tolminchi yan i Israelchic ca huichiy c’al im Pay’lom Diosil ti eb. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","A Juan oc’chith ne’ets ca chich ani talbel an Ajatic. Ne’ets ca lej tsaplilinchat in ichich c’al a Dios ti caulome jant’ini’ ti lej tsaplilinchat in ichich an caulome Elias ti lej jayq’ui’. C’al in t’ojlabil ne’ets ca t’ajchin ca c’uajiy juncúx in ichich i q’uimath ax u c’uiyáx. Ne’ets ca lujunchat in ichich an jec’omchic abal quin t’aja’ jahua’ alhua’. Antsana’ ti ne’ets ca t’ojojonchatchic in ichich an inic c’al a Juan abal quim bats’u an Ajatic. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Tam a Zacarías in ucha’ an ángel: ―Auxe’ max ne’ets qui co’oy i tsacam, cum nan in lej yejtselabits ani u q’uimathil uxcue’labits. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Toc’tsiyat a Zacarías c’al an ángel: ―Nana’its in Gabriel u t’ajchal a Dios jahua’its tiquin ucha’. Jaja’ tin aba’ abal tu olchi axe’ xi cau lej huinat alhua’. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Jahua’ nan tu uchamalits lej chubax ne’ets quit t’ajchin tam quim bajuhuits am pejchith q’uij. Cum yab tim belchamal an cau, xo’ ca tsuhuaque ne’ets quit t’ajat mo’be. Antsana’ ne’ets quit jilc’on ma tam ta ca hua’tsinits a tsacamil Juan. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Biyat u lej aychabits a Zacarías ca cale eleb c’al an mulcunel, in jic’palchic abal jale’ lej ohuel ti al an tiyopan. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Tam ti calejits a Zacarías, chubaxcua’ t’ajat yab in ejtohual ti cau. Cum mo’bejits, expith in t’ipchalq’uichic. Tam in exla’its an mulcunel abal a Zacarías tsu’binchame jant’o ejtil i huachbilab ti al an tiyopan. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Taley im putuhuits an q’uichachic tam pel in uchbil a Zacarías ca t’ojon ti pale’ ti al an tiyopan, tam ta c’alets tin q’uima’. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Tsab ox a q’uicha talbel tam ti co’othits a Elisabet c’al an tsacam. Ta jilc’on tin q’uima’ bo’ a its’. In ulu tin ichich: ");
INSERT INTO husNT1971_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ma xohue’ tin t’ajchi axe’ xi labith t’ajbilab a Dios abal ne’ets cu co’oy u tsacamil. Yabats ne’ets tiquin tithebetha’ an inicchic abal yab u co’oyamal i tsacam. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Putunits acac a its’, tamna’ a Dios in aba’ an ángel Gabriel tihua’ ti bichou Nazaret axi cuentalith Galilea. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Quin ne’thanchi an cau jun i uxum im bij María. Yabaye juncunenec jaja’ c’al i inic. Expith ts’ejcathits an cau abal ca tomquin c’al jun i inic im bij José axi pel i at xits’lab c’al a David. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Otsits an ángel jun ti c’uajat a María, aní in ucha: ―Nan tu tsapnethal. Ne’ets quit t’ajchin i lej alhua’talab c’al a Dios c’al tim patal an uxumchic. Jaja’ c’uajat c’al tata’ ani ne’ets ti lej lablinchi. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ani in lej jic’pal a María tam tin tsu’u an ángel ani antsana’ uchan. In ulu tin ichich, jale’ hualam antsana’ tin ucha’ an ángel. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Tam uchan c’al an ángel: ―Yab quit jiq’uey María, cum a elcanchits i alhua’talab c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Xo’ ne’ets quit co’ontha c’al an tsacam, ani jats ne’ets ca bijiy ta Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ne’ets quim baju ti c’athpich pulic in ey, ani ne’ets ca exla tin Tsacamil a t’ec’at pulic Pay’lom Dios ti eb. Ti lej jayq’ui’ a David punuhuat ti ts’ale c’al a Dios, ani a Jesús jats axi ne’ets ca punuhuat ti lej oc’lec Ts’ale. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ne’ets ti abatnom c’al am bichou Israel abal ets’ey. Ni jayq’ui’ yab ne’ets ca taley in tsap ti abatnom. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Tam a María in conoy an ángel: ―¿Jant’ini’ ne’ets cu co’oy i tsacam ani yabaye in juncunenec c’al i inic? ");
INSERT INTO husNT1971_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Toc’tsiyat c’al an ángel: ―C’al in tsap a t’ec’at pulic Pay’lom Dios ti eb jats c’al ti ne’ets ca co’oy an tsacam, cum ne’ets ca chich an Espíritu Santo ta inictal. Jaxtam an inicchic ne’ets quin exlanchi in lej ey an t’ele’ abal ja’its in t’ocat Tsacamil a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ca tsu’u jant’ini’ a Dios in t’ajchamal a at ja’ub xits’al Elisabet. Aba ani’ uxcue’labits, xo’ in cua’al acac a its’ ti co’othits c’al an tsacam. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","A Dios ojni’ patal jant’ots in ejtohual quin t’aja’ jant’inits jaja’ ti quin le’na’. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Tam a María in ucha’ an ángel: ―Cum nana’ pel tin c’al a Dios, alhua’ quin t’ajchin jant’ini’ tat tin uchamalits. Tam ta c’ale an ángel. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Taley jun a q’uicha c’ale a María c’al in athic ti jun i bichou cuentalith ti Judea al i bolchalom. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Taja’ c’uajat in q’uima’ a Zacarías. Otsits ani in tsapnethal a Elisabet. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Tam tin ats’a’ a Elisabet an tsapnethomtalab, tam ti yatsq’uinal an t’ele’ tin chucul. Ani lej jum putat co’onchith in ichich a Elisabet c’al an Espíritu Santo. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Tam a Elisabet in ucha’ a María: ―Tata’ ojni’ it lej lablinchith c’al a Dios c’al tim patal an uxum. Aniye jaye a tsacamil axi ne’ets ca co’oy. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ma yab u ats’al max in tomnal tata’ tiquin tsa’biy, cum ne’ets ca hua’tsin c’al tata’ u Ajatic. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Huijits hue’ tam tata’ tin tsapnetha’, jun jic’tohual u ats’a’ yatsq’uin an t’ele’ tu chucul ejtil max lej culbel cum it chich. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Lej yan ti quit culbe cum a belamal an cau jahua’ ti abchamal a Dios, cum lej chubax jats ne’ets ti t’ajchi. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Tam in ulu a María: C’al patal u ichich u puhuethanchal im bij a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Lej culbel u ichich cum a Dios pel u Jec’onthaxil. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Aba ani’ pel in ts’ejhuantal tin tamet a Dios, bel tin t’ilamal. Ma xo’ ne’ets tiquin t’iloxna’ patal an inic abal in lej lablinchith c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","A Dios c’al in lej tsap tin t’ajchamal i labith t’ajbilab. Pel in ey ti lej t’ocat. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ets’ey pel i yajnanchix c’al jitats tu c’ac’nanchab im bij. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ja’its a Dios ax in t’ajal i labith t’ajbilab. In tsa’atmethanchal in ey axi c’athat in ichich. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","In tixc’anchal in ey an oc’lecchic. Im pulicmethanchal in ey axi tsa’at in ichich. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","In ajhuethanchal in ichich jitats u c’a’il c’al in cahuintal. In jilcacanchal naptal in ichich jitats yab u c’a’il c’al in cahuintal a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","In tolminchal am bichou Israel cum pel in c’al. Ets’ey in t’ilal ani ets’ey in yajnanchal. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Antsana’ a Dios in t’ajchal im bichohuil, cum ma ti lej jayq’ui’ im bijchith uchamalits i at Israel abal antsana’ ne’ets quin t’ajchi. Antsana’ ti bijchith uchamejits a Abraham ani patal axi pel in at xits’al. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Jilc’on a María c’al a Elisabet jelat ox a its’, ani talbel huichits tin q’uima’. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Im bajuhuits an q’uij tam ti a Elisabet ne’ets quin tsu’uhuits an t’ele’. Ani hua’tsinits an t’ele’ cuitol. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Patal in at q’uimathchic an in at ja’ub xits’alchic in tso’obna’its abal a Elisabet in cua’alits an t’ele’ axi pithach c’al in alhua’ inictal a Dios. C’alechic ca junax culbe c’al jaja’. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Tam ti an t’ele’ cuitol in cua’alits huaxic a q’uicha ti hua’tsinenec, tam ti cojchin in inictal jant’ini’ tu t’ajchinal an t’ele’ cuitol Israel. Ani le’nab ca punchin im bij ta Zacarías, cum antsana’ im bij in tata. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Tam in mim an t’ele’ cuitol in ulu: ―Iba, yab qui bijiy ani’. Qui bijiy ta Juan. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Toc’tsin axi taja’chic: ―¿Jale’ a le’ ca bijiy ta Juan? Yab hua’ats a at ja’ub xits’al im bij ta Juan. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Tam conoyab t’ipchithq’ui in tata an t’ele’ cuitol jant’ini’ ti ne’ets quin le’na’ quim bijiy. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Tam in toc’tsiy t’ipchithq’ui abal in le’ ca pithan i u jun ti quin thuchanchi im bij. Ani in thuchanchi im bij pel a Juan. Ani tam lej jic’pax axi c’uajatchic taja’. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ma tameq’ui a Zacarías japq’uinits in cahuintal, ani in ts’i’quiy tam quim puhuethanchi im bij a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Tam in lej jic’palchic am bichou axi taja’. Ani tim puhuel an tsabal Judea u lej t’iloxnab an t’ele’ Juan. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ani patal jitats u olchab lej tsalpachiquix. Ani conóx jun c’al xi jun: ―¿Jant’ini’ hualam ti ne’ets quim baju in ey nixe’ xi t’ele’? C’al in lej tsap a Dios jats ti hua’tsinenec. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Tam lej jum putat co’onchith in ichich a Zacarías c’al an Espíritu Santo, ani u lej pithnal i cau. In ulu: ");
INSERT INTO husNT1971_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Qui puhuethanchi im bij i pulic Pay’lom Diosil huahua’ tu Israel. Ne’ets ca chich abal tucu jec’ontha’ cum pel tu c’al jaja’. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ne’ets tucu abchi jun ax in lej cua’al in tsap ti Jec’onthax. Pel in at ja’ub xits’al a David axi ti lej jayq’ui’ pelac in t’ojnalil a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ma tam ti biyalits a Dios im bijchith uchamalits in t’ocat caulomejilchic ne’ets tucu abchi i Jec’onthax. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ne’ets tucu jec’ontha’ c’al an inicchic ax tu tomolnal ani c’al ax tu at’al. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ne’ets tucu yajnanchi jant’ini’ ti yajnanchixin c’al i biyal at xits’al Israelchic. Ne’ets tucu putunthanchi an jilchith t’ocat cau ax in ucha’ a Abraham. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ma ti biyalits a Dios in cuba’ tim ba’ ti lej chubax c’al i biyal juntal Abraham jant’ini’ ti ne’ets tucu t’ajchi. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","In ucha’ abal ne’ets tucu jec’ontha’ c’al i tomolnaxilchic. Jaxtam yab cu jiq’uey. Qui t’ojonchi a Dios c’al i ichich thacat. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Patal a q’uicha cu xe’tsin bolith c’al i ichich t’oquethathanchithits c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Tata’ Juan pel tu tsacamil. Ne’ets quit exla c’al an inicchic tit caulome c’al a t’ec’at pulic Pay’lom Dios ti eb. Ne’ets quit oc’chith xe’tsin abal ca ts’ejcacanchi am bel an Ajatic jun ti ca ulits. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","C’al a olnomtal an Israelchic ne’ets quin tso’obna’ abal a Dios pel i Jec’onthax ani pel i paculanchix c’al an hualabtalab. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Cum lej c’anithom ani lej yajnanchix i Diosil, jaxtam ne’ets tucu abchi a Jesús axi c’uajat ti eb tucu pitha’ i tajaxtalab ti ichich. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Jitats xe’ets ti al an yic’uax, ca xe’tsin tin tajax an Ajatic. Jitats u co’oyab c’al in tsap an tsemla, ca co’oyat c’al in tsap an Ajatic. Jitats xe’ets cuetem, ca lotocna c’al an Ajatic in ichich jun ejet. Antsana’its in ulu a Zacarías. ");
INSERT INTO husNT1971_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ani an cuitol Juan ne’ets puhuehuel in inictal ani ne’ets tsaplilinal in ejattal c’al a Dios. Tam ti inicbejits, ta xe’ets al an joltam. In aychal quim bajuhuits am pejchith q’uij tam ca tejhua’ xe’ets c’al an Israelchic. ");
INSERT INTO husNT1971_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Tam ti nihua’ q’uicha an lej ts’ale oc’lec Augusto in aba’ an cau ca penchin im bij al an u patal an inicchic ma ju’tamits huichat jaja’ in abatnal. ");
INSERT INTO husNT1971_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","C’a’al antsana’ penchinits im bij an inicchic tam ti a Cirenio pel i gobernador ti Siria. ");
INSERT INTO husNT1971_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Pel in uchbil tim patal an inicchic ca c’ale ti bichou jun ti cuentalith abal antsana’ ca penchin im bij. ");
INSERT INTO husNT1971_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Cale a José tim bichohuil Nazaret axi cuentalith ti bichoulom Galilea, c’ale ti bichou Belén axi ti bichoulom Judea. Tats ti c’ale cum pel in at ja’ub xits’al a David, ani tats ti hua’tsinenec a David. ");
INSERT INTO husNT1971_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ulits ti Belén jaye junax c’al a María abal ca penchin im bijchic. Ts’ejcathits an cau abal a María ne’ets ca tomquin c’al a José. Ani co’othits a María c’al an tsacam. ");
INSERT INTO husNT1971_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Biyat c’uajatchic tihua’ ti Belén, im bajuhuits an q’uij tam ti ne’ets ca hua’tsin an t’ele’. ");
INSERT INTO husNT1971_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ani tats ti hua’tsin in c’a’al tsacamil a María. In thu’bay c’al i toltom ani in cuatsba’ ba’ in c’apumtal i co’nel jun tu co’oyab jaja’chic, cum yabats hua’ats i alta jun tin huat’al an acal am belal inicchic. ");
INSERT INTO husNT1971_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Utat ti Belén taja’ c’uajat i inicchic ax im beletnal tam acal an ovejachic. ");
INSERT INTO husNT1971_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Jun jic’tohual chich c’al jaja’chic jun i ángel abath c’al a Dios. Ani ijcan jun ti c’uajatchic jun i lej tsapic tajaxtalab tal ma ti eb. Tam lej jiq’ueychic. ");
INSERT INTO husNT1971_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ani uchanchic c’al an ángel: ―Yab quit jiq’ueychic, cum nan in tal abal tu olchi i cau axi lej huinat alhua’, c’al ca culbe patal an inicchic. ");
INSERT INTO husNT1971_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Xo’ hua’tsin i t’ele’ tim bichohuil a David. Jats an Ajatic Cristo axi abnenec c’al a Dios ti Jec’onthax c’al tata’chic. ");
INSERT INTO husNT1971_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ne’ets ca tso’obnanchi abal chubax an cau jahua’ tu ucha’ tam ca tsu’u thu’babach an t’ele’ c’al i toltom ani cuatsat tin c’apumtal i co’nel jun tu co’oyab jaja’chic. ");
INSERT INTO husNT1971_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Tameq’ui ulits yantalam i ángelchic tal ti eb c’al axi jun i ángel ulnequits oc’ox. Tim patalchic im puhuethanchal im bij a Dios. In uluchic: ");
INSERT INTO husNT1971_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Patal an inicchic quin lej puhuethanchi im bij a Dios ti eb. Ani patal jitats teje’ tsabal c’al tu culbel a Dios, jats ca jun ejetbethanchat in ichich c’al jaja’. ");
INSERT INTO husNT1971_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Tam ta c’alets an ángelchic ti eb. Ani am beletnomchic c’al an oveja in ulu jun c’al xi jun: ―Cum tu abchi a Dios an cau c’al an ángel, huana cu c’ale ti Belén qui tsu’u. ");
INSERT INTO husNT1971_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Tam ta c’alechic c’al in athic. Taja’ in ela’ a María ani a José c’uajatchic, ani an t’ele’ cuatsat al nixe’ xi c’apumtalab jun tu co’oyab an co’nelchic. ");
INSERT INTO husNT1971_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Tocat in met’alchic an t’ele’. Tam in olchichic an inicchic taja’ an cau jant’ini’ ti olchinenec c’al an ángel tin cuenta an t’ele’. ");
INSERT INTO husNT1971_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ani lej jic’panchab jahua’ in uluchic. ");
INSERT INTO husNT1971_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","A María jats in lej luputh t’aya’ ani in lej tsalapnal nixe’ xi cau tin ichich. ");
INSERT INTO husNT1971_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Taley ta huichits am beletnom ovejachic jun ti c’uajat in co’nelil. In lej puhuethanchalchic im bij a Dios c’al an ángel ani c’al an t’ele’ ax in tsu’umal. Patal jant’ini’ ti uchanchic c’al an ángel, jats antsana’ tin tsu’umal. ");
INSERT INTO husNT1971_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Tam ti an t’ele’ in cua’alits huaxic a q’uicha ti hua’tsinenec, cojchin in inictal jant’ini’ in ujnamtal an Israel. Ani bijiyat ta Jesús, cum antsana’ ti uchnenequits a María c’al an ángel quim bijiy tam ti yabaye co’othits c’al an tsacam. ");
INSERT INTO husNT1971_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","An ts’ejcath cau binath c’al a Moisés in ulal abal an mimlab quin aychi ma ta ca putunits tsab inic a q’uicha ti hua’tsinenec an t’ele’, tam tiq’uele ta ca otsits ti al an tiyopan. Im putuhuits tsab inic a q’uicha, tam a José ani a María in ne’tha’ an t’ele’ Jesús ti Jerusalén quim binanchi c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Antsana’ in t’aja’chic jant’ini’ an thuchath ts’ejcath cau in ulal ca binanchat tin c’ubac a Dios patal an oc’ox t’ele’ cuitol. ");
INSERT INTO husNT1971_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Jaye im putu c’al an ts’ejcath cau ax in ulal an uxum ax in cua’al i it t’ele’ quim bina’ i ts’acchixtalab. Quim bina’ tsab i boc’ o max tsab i lab cucu’. ");
INSERT INTO husNT1971_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Tam ti nihua’ q’uicha c’uajat ti Jerusalén jun i alhua’ inic im bij Simeón. U lej co’oyab c’al an Espíritu Santo an u lej c’ac’nax c’al a Dios. In lej aychal a Dios quin aba’ an Jec’onthax ca jec’ontha in at Israelchic. ");
INSERT INTO husNT1971_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","C’al an Espíritu Santo olchin abal yab ne’ets ca thubat tsemets, ma ti quin oc’ox tsu’u a Cristo axi bijithits ne’ets ca aban c’al a Dios ca chich. ");
INSERT INTO husNT1971_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Nixe’ xi Simeón c’ale ne’thach c’al an Espíritu Santo ti tiyopan. Ani taja’ c’uajatchic a José ani a María ti al an tiyopan im putuhual c’al an ts’ejcath cau tin cuenta ca binanchat an t’ele’ Jesús tin c’ubac a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Tam a Simeón im bats’uhual an t’ele’ Jesús ani in teynal tin ocob. Tam im puhuethanchal im bij a Dios, in ulu: ");
INSERT INTO husNT1971_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Dios, xo’ ojni’ u ejtohual quin tsemets c’al u ichich thacat, cum a putumalits am bijchith cau ax tin tso’oblinchamalits. ");
INSERT INTO husNT1971_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Xo’ u tsu’uhuits c’al u lej hual an t’ele’ axi ne’ets ti Jec’onthax. ");
INSERT INTO husNT1971_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Jats ax a punumalits ti Jec’onthax c’al tim patal an inic. ");
INSERT INTO husNT1971_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Jaja’ ja’its axi ne’ets quim pitha’ i tajaxtalab tin ichich axi yab Israel. Ne’ets quim pitha’ a bichohuil Israel i ts’alattalab tin ichich. ");
INSERT INTO husNT1971_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ani a José ani a María in mim a Jesús in lej jic’pal an cau jahua’ antsana’ in ulu a Simeón tin cuenta an t’ele’ Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Tam uchanchic c’al a Simeón, a Dios ti lej lablinchichic. Ani a Simeón in uchaye a María: ―Ca lej t’aja’ ti cuenta abal axe’ xi t’ele’ tequeth pithnenequits in ey c’al a Dios. Tam ca puhueyits ne’ets ca pojca c’al yanchic i Israel, ani jats ti ne’ets ca q’uibeychic. Jaye ne’ets ca bats’uhuat c’al yanchic i Israel, ani jats ti ne’ets ca jec’onthachic. ");
INSERT INTO husNT1971_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Antsana’ ti ne’ets ca tso’obnanchi in tsalap ti junchic an inic. Ani tata’ ne’ets ca lej yajna’ tam ca tsu’u abal u pojcab a Jesús, ma ne’ets ca ats’a’ ta ichich ejtil max it xec’chinal c’al i cutsil. ");
INSERT INTO husNT1971_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ani tam c’uajat jaye ti al an tiyopan jun i uxcue’lab im bij Ana axi pel i caulome c’al a Dios. Jaja’ in tata pel a Fanuel axi pel i at xits’lab c’al an cuenel Aser. Tomquinenec a Ana tam ti ts’ic’ache, ani buc i tamub talbel tam ti tsemetsits in tomquil. ");
INSERT INTO husNT1971_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Pel i tsemchith uxum in cua’alits tse’ inic c’al tse’ i tamub. Ets’ey u pabil ol ti al an tiyopan. Lej c’ac’nax c’al a Dios q’uicha ani acal. ");
INSERT INTO husNT1971_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Tam ti talits ti cau a Simeón, chich a Ana quim bina’ i c’ac’namal yan c’al a Dios. Taley tamna’ in ts’i’quiy quin t’iloxnanchi an t’ele’ Jesús c’al patal jita’ taja’ in lej aychal ca jec’ontha am bichou Jerusalén c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Im putuhuits a José ani a María patal an uchbixtalab tin cuenta an ts’ejcath cau taja’ ti Jerusalén, ani taley huichitschic tim bichohuil Nazaret axi cuentalith ti Galilea. ");
INSERT INTO husNT1971_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ani an t’ele’ Jesús ne’ets puhuhuel ani ne’ets tsapnenel. U lej tsalpapnal ani u lej lablinchab c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ti tamub ti tamub u c’alelchic a José ani a María ti Jerusalén quin ajibnanchi in q’uichajil am biyal bichou Israel tam ti calthame ti Egipto. ");
INSERT INTO husNT1971_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Tam tin cua’alits lajuj tsab tamub a Jesús, tam c’ale junax c’al jaja’chic ti Jerusalén tin cuenta nixe’ xi ajib. ");
INSERT INTO husNT1971_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Talits an ajib ani u huichelits tin q’uima’ a José ani a María in mim a Jesús. Yab in tso’bimchic max a Jesús jilc’onenec ti Jerusalén. ");
INSERT INTO husNT1971_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","In tsalpayalchic abal ta talits cuxlab junax c’al axi q’ue’atchic. Belatschic jun a q’uicha, ani tamna’ in aliyal max tal a Jesús c’al in at ja’ub xits’al ani c’al in exlohualchic. ");
INSERT INTO husNT1971_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Cum yab in elal, jaxtam huichiychic ti Jerusalén abal quin aliy taja’. ");
INSERT INTO husNT1971_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Xe’ets alililchic, ani taley oxchilab q’uicha in ela’chic quetel al an tiyopan c’al an exobchixchic c’al an ts’ejcath cau binath c’al a Moisés. In ots’omichiquinchal in exobchixtal jaja’chic ani in conomichical jant’ini’ tin le’ quin ulu in exobchixtal. ");
INSERT INTO husNT1971_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ani an exobchixchic jaye in conomichical a Jesús. In lej jic’panchal in toc’tsixtal ani in tsalpathtal. ");
INSERT INTO husNT1971_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Tam ti a José ani a María in tsu’u a Jesús taja’ al an tiyopan, in lej jic’palchic. Ani tamna’ a María in conoyal a Jesús: ―¿Tsacamil, jale’ yab it junax ayin c’al huahua’? Lej t’e’pipith i ichich cum hualim tu alilil c’al tata’. ");
INSERT INTO husNT1971_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Tam a Jesús in toc’tsiy: ―¿Jale’ it xe’tsinenecchic alilil c’al nana’? ¿Yab xe’ a lej tso’obits abal nan u cua’al u uchbil cu t’ojonchi u Tata ti eb? ");
INSERT INTO husNT1971_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Yab in ejtiychic an cau jahua’ antsana’ uchan. ");
INSERT INTO husNT1971_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Tam junax huichiy a Jesús c’al jaja’chic ti Nazaret. Taja’ in lej putuhual in uchbil jant’o ta ca abatna tin q’uima’. A María in tala’ thaycaquiyal tin ichich jahua’ quin tsu’u ani jahua’ quin ats’a’ tin cuenta a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ne’ets puhuehuele ani ne’ets tsalpapnale a Jesús. In t’ajal jahua’ alhua’ c’al a Dios ani jaye c’al an inicchic. ");
INSERT INTO husNT1971_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Tam ti a Tiberio in cua’alits lajuj bo’ tamub ti lej ts’ale oc’lec, a Poncio Pilato pel i gobernador ti Judea. A Herodes pel i gobernador ti Galilea ani in ebchal Felipe pei i gobernador ti Iturea ani ti Traconite. Ani a Lisanias pel i gobernador ti Abilinia. ");
INSERT INTO husNT1971_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ani an ts’alechic pale’ c’al an Israel pel a Anás ani a Caifás. Tam ti tameq’ui ta ti xe’ets a Juan in tsacamil a Zacarías ti al an joltam, ani taja’ uchan c’al a Dios quin ts’i’quiy in t’ojlabil. ");
INSERT INTO husNT1971_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Taley talbel ta ti xe’ets utat ti pulic itse’ Jordán, in thajchixnanchal an inicchic ca jic’tson c’al in hualab abal ca paculanchat c’al a Dios, ani ca pujan. ");
INSERT INTO husNT1971_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Antsana’ c’al in thajchixtal a Juan u putnal an cau jahua’ in thuchamal ma biyalits an caulome Isaías antse’: Jun i inic ne’ets quin thajchixnanchi an inicchic ax u che’el ti al an joltam antse’: Ca ts’ejcacanchi am bolith bel an Ajatic jun ti ca ulits. ");
INSERT INTO husNT1971_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ca tala’ elchiyat am poc’ jolchic. Jaye ca pac’luhuat an ts’enchic ani am bolchal. Ca bolithmetha jun ti yunq’uichic am bel ani ca juncuhuat jun ti jolichic. ");
INSERT INTO husNT1971_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Antsana’ ne’ets quin tsu’u patal an inicchic an Jec’onthax axi ta tal abath c’al a Dios, in ulu a Isaías. ");
INSERT INTO husNT1971_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ani axi c’uajatchic taja’ u pujnal c’al a Juan, uchan c’al jaja’: ―Tata’chic ojni’ ejtil it tsan. A le’ ca jec’a’ c’al i pujaxtalab an yajchictalab axi taye tale. ");
INSERT INTO husNT1971_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Max chubax it jic’tsonenequitschic c’al a hualab ani it huenc’onenequits c’al a Dios, ca tejhua’metha’ abal chubax anits c’al i alhua’ xe’tsintalab. Yab ca tsalpaychic abal it alhua’its c’al a Dios expith cum pel it at xits’lab c’al a Abraham. Max expith jats in le’ a Dios yan in xits’altal a Abraham, in huit’alac ma quin hua’tsintha’ c’al i t’ujub. ");
INSERT INTO husNT1971_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Jant’ini’ an inic in ijcal jun i te’ axi yab jant’o ti alhua’ ani quin chica’, antsana’ a Dios hue’its ne’ets quin t’aja’ c’al i inicchic axi yab alhua’. ");
INSERT INTO husNT1971_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Tam an inicchic taja’ in conoyal a Juan: ―¿Jant’o pel i uchbil c’al a Dios qui t’aja’? ");
INSERT INTO husNT1971_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","A Juan in toc’tsiychic: ―Jitats in cua’al tsab i cotonlab, quim pitha’ jun axi yab in cua’al. Jitats in cua’al jant’o quin c’apu, quim pitha’ jaye axi yab in cua’al. ");
INSERT INTO husNT1971_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ta u che’el jaye c’al a Juan i bats’c’ul jalbixtalab tumin c’al an gobierno ca pujan. Jaja’chic in conoyal a Juan jayetseq’ui: ―¿Exobchix, jant’o pel i uchbil c’al a Dios qui t’aja’? ");
INSERT INTO husNT1971_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","A Juan in toc’tsiychic: ―Yab ca huat’ath conchi yan an jalbixtalab tumin, expith jahua’ in ulal in uchbixtal an oc’lecchic. ");
INSERT INTO husNT1971_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","I soldadochic in conoyal a Juan jayetseq’ui: ―¿Ani huahua’ jant’o pel i uchbil c’al a Dios? A Juan in toc’tsiychic: ―Yab quit cue’enchic. Ni jita’ yab ca q’uet’ach othanchi an cau. Quit culbejits c’al an tumin ax a atal. ");
INSERT INTO husNT1971_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","U lej t’ajnal ti cuenta a Juan, cum c’al yan i inicchic tu tsalpanchab max hualam ja’its a Cristo axi lej bijithits ne’ets ca aban c’al a Dios ca chich. ");
INSERT INTO husNT1971_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ani a Juan in ucha’chic: ―Nana’ yabaye ja. Jaja’ lej pulic in ey ani nana’ iba. Nana’ lej tsa’at u ey, ma yab ne’ets cu baju cu pilchi in quintsol im pajab. Nan tu pujayalchic c’al i ja’, ani jaja’ axi taye tal talbel jats ne’ets ti pujaychic c’al an Espíritu Santo ani c’al i c’amal. ");
INSERT INTO husNT1971_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Tam jun i inic quin ic’oy in hualil an lab em, talbel ne’ets quin thaya’ ti al i huilte’. Ne’ets quin tamcuy an amul quin chica’ al i c’amal. Antsana’ jaja’ axi taye tal ne’ets quin thaya’ in c’al jaja’ ti eb, ani quin jolou axi jaja’ yab in c’al ti al am pulic c’amal axi ni jayq’ui’ yab u teptsinal. ");
INSERT INTO husNT1971_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Antsana’ xe’ets a Juan ti exobchix ani ti olchix c’al an alhua’ cau c’al an inicchic. ");
INSERT INTO husNT1971_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ani jun a q’uicha in jolbiy an gobernador Herodes, cum juncunenec c’al a Herodías axi pel in tomquil a Felipe. Ani nixe’ xi Felipe pel in ebchal a Herodes. In jolbiy jaye c’al q’ue’atchic i hualabtalab ax in t’ajamal. ");
INSERT INTO husNT1971_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ani a Herodes ni hue’ yab in t’ajchi ti cuenta jahua’ uchan c’al a Juan. Ma tocat in t’ajaye yab alhua’, im bina’ an cau ca baliyat ti huic’axte’ a Juan. ");
INSERT INTO husNT1971_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","A Juan im pujayamalits yan i inicchic. Taley chichits a Jesús, ani pujan jaye. Ani biyat tam ti exom ti ol a Jesús, japq’uinal ti eb. ");
INSERT INTO husNT1971_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Tamna’ tal ti eb pa’i’il an Espíritu Santo tsu’tab ejtil i cucu’. Ta jilc’on c’al a Jesús. Tam ats’atmel jun i cau tal ti eb c’al a Dios, taunab a Jesús antse’: ―Tata’its pel tu ichich hual Tsacamil. In lej culbel c’al tata’. ");
INSERT INTO husNT1971_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","A Jesús in cua’alits jelat jun inic c’al lajuj i tamub tam tin tuju in t’ojlabil. Exla pel i tsacamlab c’al a José axi pel i tsacamlab c’al a Elí. ");
INSERT INTO husNT1971_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","A Elí pel i tsacamlab c’al a Matat. A Matat pel i tsacamlab c’al a Leví. A Leví pel i tsacamlab c’al a Melqui. A Melqui pel i tsacamlab c’al a Jana axi pel i tsacamlab c’al a José. ");
INSERT INTO husNT1971_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","A José pel i tsacamlab c’al a Matatías ani a Matatías pel i tsacamlab c’al a Amós. A Amós pel i tsacamlab c’al a Nahum. A Nahum pel i tsacamlab c’al a Esli axi pel i tsacamlab c’al a Nagai. ");
INSERT INTO husNT1971_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","A Nagai pel i tsacamlab c’al a Maat ani a Maat pel i tsacamlab c’al a Matatías. A Matatías pel i tsacamlab c’al a Semei. A Semei pel i tsacamlab c’al a José axi pel i tsacamlab c’al a Judá. ");
INSERT INTO husNT1971_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","A Judá pel i tsacamlab c’al a Joana axi pel i tsacamlab c’al a Resa. A Resa pel i tsacamlab c’al a Zorobabel ani a Zorobabel pel i tsacamlab c’al a Salatiel axi pel i tsacamlab c’al a Neri. ");
INSERT INTO husNT1971_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","A Neri pel i tsacamlab c’al a Melqui axi pel i tsacamlab c’al a Adi. A Adi pel i tsacamlab c’al a Cosam ani a Cosam pel i tsacamlab c’al a Elmodam axi pel i tsacamlab c’al a Er. ");
INSERT INTO husNT1971_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","A Er pel i tsacamlab c’al a Josué ani a Josué pel i tsacamlab c’al a Eliezer. A Eliezer pel i tsacamlab c’al a Jorim axi pel i tsacamlab c’al a Matat. ");
INSERT INTO husNT1971_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","A Matat pel i tsacamlab c’al a Leví axi pel i tsacamlab c’al a Simeón. A Simeón pel i tsacamlab c’al a Judá ani a Judá pel i tsacamlab c’al a José. A José pel i tsacamlab c’al a Jonán axi pel i tsacamlab c’al a Eliaquim. ");
INSERT INTO husNT1971_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","A Eliaquim pel i tsacamlab c’al a Melea axi pel i tsacamlab c’al a Mainán. A Mainán pel i tsacamlab c’al a Matata axi pel i tsacamlab c’al a Natán. ");
INSERT INTO husNT1971_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","A Natán pel i tsacamlab c’al a David axi pel i tsacamlab c’al a Isaí. A Isaí pel i tsacamlab c’al a Obed axi pel i tsacamlab c’al a Booz. A Booz pel i tsacamlab c’al a Salmón axi pel i tsacamlab c’al a Naasón. ");
INSERT INTO husNT1971_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","A Naasón pel i tsacamlab c’al a Aminadab axi pel i tsacamlab c’al a Aram. A Aram pel i tsacamlab c’al a Esrom ani a Esrom pel i tsacamlab c’al a Fares axi pel i tsacamlab c’al a Judá. ");
INSERT INTO husNT1971_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","A Judá pel i tsacamlab c’al a Jacob axi pel i tsacamlab c’al a Isaac. A Isaac pel i tsacamlab c’al a Abraham ani a Abraham pel i tsacamlab c’al a Taré axi pel i tsacamlab c’al a Nacor. ");
INSERT INTO husNT1971_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","A Nacor pel i tsacamlab c’al a Serug axi pel i tsacamlab c’al a Ragau. A Ragau pel i tsacamlab c’al a Peleg ani a Peleg pel i tsacamlab c’al a Heber axi pel i tsacamlab c’al a Sala. ");
INSERT INTO husNT1971_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","A Sala pel i tsacamlab c’al a Cainán axi pel i tsacamlab c’al a Arfaxad. A Arfaxad pel i tsacamlab c’al a Sem. A Sem pel i tsacamlab c’al a Noé axi pel i tsacamlab c’al a Lamec. ");
INSERT INTO husNT1971_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","A Lamec pel i tsacamlab c’al a Matusalén axi pel i tsacamlab c’al a Enoc. A Enoc pel i tsacamlab c’al a Jared. A Jared pel i tsacamlab c’al a Mahalaleel axi pel i tsacamlab c’al a Cainán. ");
INSERT INTO husNT1971_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","A Cainán pel i tsacamlab c’al a Enós axi pel i tsacamlab c’al a Set. A Set pel i tsacamlab c’al a Adán axi pel i tsacamlab c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Taley tixc’an a Jesús jun ti pujnenec al am pulic itse’ Jordán, ani jum putat co’onchith in ichich c’al an Espíritu Santo. Ani ne’tha c’al an Espíritu Santo ca c’ale ti al i joltam. ");
INSERT INTO husNT1971_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Taja’ lej nixoc’nab le’nab ca hualbin c’al an oc’ox teneclab. Jilc’on tsab inic a q’uicha taja’, ani ni jant’o yab in c’apu, expith lej c’a’il. ");
INSERT INTO husNT1971_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Taley uchan c’al an teneclab: ―Max chubax pel ti lej Tsacamil a Dios, ca ucha’ axe’ xi t’ujubchic ca huenc’on ti pan. ");
INSERT INTO husNT1971_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Toc’tsin a Jesús: ―An T’ocat Thuchlab in cahuintal a Dios in ulal abal an inic yab expith quin ejatna’ an c’apnel, jaye quin ejatnanchi patal in cahuintal a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Tam ne’tha a Jesús c’al an teneclab ti al i t’ec’at oc’ bolchal, ani uchan quin met’a’ jun athic tim patal am pulic bichoulom tim puhuel an tsabal. ");
INSERT INTO husNT1971_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ani uchan c’al an teneclab: ―Nan im pithnenequits u ey c’al patal nixe’ xi pulic bichoulom ani u punuhual ti abatnom jitats nan cu le’na’. U ejtohual tu punu tit abatnom c’al patal nixe’ xi pulic bichoulom tsabal c’al patal in ts’alat. ");
INSERT INTO husNT1971_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Expith ca tuthu a c’ualal ani tiquin c’ac’na’, tamna’ ne’ets tu tala’ pitha’ patal jahua’ a tsu’tal abal ca abatna’. ");
INSERT INTO husNT1971_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Toc’tsin a Jesús: ―Teneclab, quit tixc’anits xo’ c’al nana’. In ulal an T’ocat Thuchlab abal an inic quin c’ac’na’ ani quin t’ojonchi im Pay’lom Diosil expith. ");
INSERT INTO husNT1971_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Tam ne’tha a Jesús ti bichou Jerusalén c’al an teneclab ani tin oc’ an tiyopan lej t’ec’at. Uchan: ―Max chubax pel ti lej Tsacamil a Dios, ma teje’ quit t’ic’ts’on ani ma tsabal. ");
INSERT INTO husNT1971_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Ne’ets quit jec’ontha, cum thuchathits al an T’ocat Thuchlab abal a Dios ne’ets ti abchi i ángelchic abal ti alhua’ beletna’. ");
INSERT INTO husNT1971_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Thuchathits jaye abal an ángelchic ne’ets ti co’bitsiy tin c’ubac abal ma yab quit t’ithc’uan al i t’ujub. ");
INSERT INTO husNT1971_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Toc’tsin a Jesús: ―In ulal an T’ocat Thuchlab abal yab ca alq’uith tacchiquiy a Dios, aba ani’ jaja’ pel i beletnom c’al an inicchic. ");
INSERT INTO husNT1971_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Cum an teneclab yabats in más ela’ jant’o ti quin nixoc’naye a Jesús ca hualbin, tam tixc’anits ani ohueyits hue’ yab huichiy. ");
INSERT INTO husNT1971_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Taley huichiy a Jesús ti pulic bichoulom Galilea, ani jum putat tsaplilinchab in ichich c’al an Espíritu Santo. Ani lej t’iloxnanchab in t’ajbil ti al nixe’ xi tsabal abal ju’tamq’ui. ");
INSERT INTO husNT1971_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Xe’ets tsa’bibil ti exobchix tin tiyopanilchic an Israel, ani lej puhuethanchab im bij c’al tim patal an inicchic. ");
INSERT INTO husNT1971_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Taley ulits a Jesús ti bichou Nazaret jun ti yejenec ti inic. Cum in ujnam ani’, otsits tam sábado tin tiyopanil an Israel, ani cubiy taja’ abal quin ajinchi an inicchic an T’ocat Thuchlab in cahuintal a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Pithan an u thuchath c’al an caulome c’al a Dios Isaías, in japiy ani in ajiy jun tu olnab jaja’ al nixe’ xi Thuchlab antse’: ");
INSERT INTO husNT1971_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","An Espíritu Santo c’uajat c’al nana’. A Dios tim punumal cu exobchi an ts’ejhuantalchic an alhua’ cau. Jaja’ tin abamal abal cu lubachmethanchi in ichich jitats yajchiquith. Cu olchi jant’ini’ ta ca hualcanthanchat in ichich c’al an hualabtalab axi c’al tu huic’at co’oyab. Cu tsu’uxmetha’ an joc’tsichic. Cu jec’ontha’ an inicchic ax u othnab c’al in hualab. ");
INSERT INTO husNT1971_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Cu olchi an inicchic abal xo’ pelits in q’uijil ca yajnanchat c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Taley a Jesús in mapc’uy an u ani in huichbanchi an tolmix eyal axi taja’ ti al an tiyopan. Tam buxcanits ani u lej met’nal c’al patal axi c’uajat ti al an tiyopan, aychab jant’o ne’ets quin ulu. ");
INSERT INTO husNT1971_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Tam in ulu: ―Xohue’its nan u t’ajchal an inicchic jant’ini’ tin olnab ti al nixe’ xi T’ocat Thuchlab ax tu ajinchichic. ");
INSERT INTO husNT1971_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ani patal axi muthat taja’chic in tsu’tal abal a Jesús pel i alhua’ inic, ani in jic’panchal an alabel cau jahua’ u olchinalchic. Aba ani’, talchic in ulu bel antse’: ―¿Yab i ja’its axe’ in tsacamilq’ui a José? ");
INSERT INTO husNT1971_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Tam a Jesús in ucha’chic: ―U uluhuabits ilalixcua’ ca cuete’ jeltha’ ta ba’, ani chubax jats a le’ tiquin ucha’. A le’ tiquin ucha’ cu t’aja’ teje’ tu cuete’ bichohuil jahua’ a ats’amal u t’ajamal tihua’ ti Capernaum. ");
INSERT INTO husNT1971_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","A Jesús in uchayechic: ―Chubax nan tu uchalchic abal axi caulome c’al a Dios yab u c’ac’nab c’al in at bichou. ");
INSERT INTO husNT1971_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ti biyal hua’atsac yan i tsemchith uxum c’al an Israelchic tam ti xe’tsin a Elías an caulome c’al a Dios. Tsemets yan i inicchic c’al an jayil, cum ox tamub c’al ts’ejel ti yab ulits an ab. ");
INSERT INTO husNT1971_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ani a Dios in aba’ a Elías ca c’ale c’al juncats i tsemchith uxum ax u c’uajil ti pil i bichou Sarepta utat ti bichou Sidón, ani yab in aba’ ca c’ale c’al ni jun i tsemchith uxum axi pel in at Israel. ");
INSERT INTO husNT1971_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ani jaye pil a q’uicha c’al an Israelchic hua’atsac yan ax in cua’al an t’it’ axi c’apux c’al in anam t’u’ul tam ti xe’tsin a Eliseo an caulome c’al a Dios. Ani a Eliseo yab in jeltha’ in at Israelchic, expith in jeltha’ a Naamán ax u c’uajil ti pil i bichou ti tsabal Siria. ");
INSERT INTO husNT1971_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Tam tin ats’a’ an cau jahua’ antsana’ in ulu a Jesús, tam ti lej tsacuy patal axi c’uajat taja’ ti al an tiyopan. ");
INSERT INTO husNT1971_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Thubat cubiychic ani in ne’tha’ a Jesús hualte’ am bichou. In ne’tha’ tin chum i t’ec’at oc’ bolchal abal taja’ quim pet’na’. ");
INSERT INTO husNT1971_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Tocat yab in ejtouchic, cum tsinat c’alets jaja’. ");
INSERT INTO husNT1971_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Taley ulits a Jesús ti Capernaum axi pel i bichou cuentalith ti Galilea. Taja’ tam sábadochic in exobchalchic an inic, cum antsana’ in ujnamits quin exobchi. ");
INSERT INTO husNT1971_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ani lej jic’panchab in exobchixtal cum u exobchix c’al i lej uchbith cau. ");
INSERT INTO husNT1971_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Taja’ jun i sábado c’uajat ti al an tiyopan jun i inic co’oyab c’al i at’ax teneclab. U lej thajanthab c’al an at’ax quin ucha’ a Jesús antse’: ");
INSERT INTO husNT1971_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","―¿Tata’ ojni’ jant’o hualam a le’ tucu t’ajchi. Jesús Nazaretib? Hualam a le’ tucu t’ajat talabetha’. Nan tu exlanchal a ey pel ti T’ocat Tsacamil a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Tam a Jesús in c’uiya’ an at’ax teneclab in ucha’: ―Quit ts’ibc’an ani quit cale tin ichich axe’ xi inic. Tam ma ijca tsabal an inic c’al an at’ax teneclab, ani tam calejits tin ichich yabats in othnal. ");
INSERT INTO husNT1971_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ani tam lej in jic’pal patal axi c’uajatchic taja’, ani in uluchic: ―¿Jant’o tam uchbixtalab in cua’al axe’ xi inic? In cua’al in lej tsap abal quin ata’ ani quin canchi i at’ax teneclab. ");
INSERT INTO husNT1971_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ani lej t’iloxnanchab in labith t’ajbilchic a Jesús tim puhuel nixe’ xi tsabal Galilea. ");
INSERT INTO husNT1971_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Tam cale a Jesús ti al an tiyopan, ta c’ale tin q’uima’ a Simón. Taja’ c’uajat mo’ol c’al i tsapic c’aq’ueltalab in uxum iyam a Pedro. Ani lej canat uchan a Jesús max quin jeltha’. ");
INSERT INTO husNT1971_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Tam utey a Jesús, tocat in ulu ca tixc’an an c’aq’ueltalab, ani thubat tixc’anchatits. Ts’acpan, ani taley im pijchi a Jesús junax c’al in junquilchic. ");
INSERT INTO husNT1971_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Otscanalits a q’uicha, ani u chanchinal a Jesús yan i ya’ulchic c’al jahuaquitsq’ui tam yau’lats. Im punchal in c’ubac ti junchic an ya’ulchic ani antsana’ tin jelthalchic. ");
INSERT INTO husNT1971_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ani yantalam jaye axi co’oyab c’al i at’ax teneclab canchinal. Thajat uchnal a Jesús c’al nixe’ xi at’ax teneclab: ―Tata’its pel ti Tsacamil a Dios. Tam a Jesús in c’uiya’chic an at’ax’ teneclab. Aba ani’ exlanchatits in ey c’al jaja’chic abal jaja’ ja’its a Cristo, bel yab in hualcanchi quin olchi in ey c’al jita’. ");
INSERT INTO husNT1971_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Tam ti chutheyits cale a Jesús ti al am bichou, c’ale ti al i joltam. Ani aliyab c’al am bichou, ani tats ti elan ti al an joltam. Ani lej canat uchan abal yabaye ca tixc’an, cum le’nabe ca jilc’on al nixe’ xi bichou. ");
INSERT INTO husNT1971_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ani a Jesús in ucha’chic: ―U cua’al u uchbil cu c’ale cu olnanchi an inicchic al pil i bichouchic jaye jant’ini’ tin t’ajal a Dios ti Ts’ale. Jats tin abath c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Jaxtam xe’tsitsil a Jesús ti Galilea ti exobchix ti al in tiyopanil an Israelchic. ");
INSERT INTO husNT1971_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Jun a q’uicha c’uajat a Jesús hualte’ am pulic lejem Genesaret, ani ulits taja’ yantalam i inic c’al jaja’. Lej q’uits’c’omayab jaja’ c’al an mulcunel, cum in le’chic ca exobchin in cahuintal a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","A Jesús in tsu’u tsab i jolat tan hualte’ am pulic lejem. Pel i tanchic axi jilnenec taja’ c’al i alim to’olchic, ani c’uajat jaja’chic hualte’ am pulic lejem ti pac’ul c’al an thachumtalab c’al an to’ol. ");
INSERT INTO husNT1971_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Otsits a Jesús tin tanil a Simón, ani in ucha’ max ca hue’ nixq’uinchat al am pulic lejem. Tam buxcan a Jesús al an tan, ani in ts’i’quiy ti exobchix c’al am pulic mulcunel. ");
INSERT INTO husNT1971_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Tam ti talits ti exobchix, in uchaye a Simón: ―Ca beltha’ más hue’ an tan jun ti luputh an ja’, ani ca pet’na’ an thachumtalab c’al an to’ol abal ca caltha’ hue’ i to’ol. ");
INSERT INTO husNT1971_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Toc’tsin a Simón: ―Exobchix, i examalits qui caltha’ an to’ol ma patal an acal, ani ma ni jun i to’ol yab i calthamal. Ojni’ bel cum tata’ tin uchal ne’ets cu pet’na’ an thachumtalab. ");
INSERT INTO husNT1971_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Im pet’na’its, ani balin yan i to’ol ma tujey ca t’apts’in an thachumtalab. ");
INSERT INTO husNT1971_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Tam in t’ipchi c’al in c’ubac ca chich ti tolmiyab c’al in at t’ojnal axi c’uajatchic al junaquits i tan. Tam chich jaja’chic in t’uchiy axi tsab i tan c’al i to’ol, ma hue’its ca uc’tsin an tanchic c’al xi yantalam i to’ol. ");
INSERT INTO husNT1971_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Tam tin tsu’u a Simón Pedro antsana’, tam tin tuthu in c’ualal tin tamet a Jesús, ani in ucha’: ―Ajatic, cum pel in hualbith inic u ats’al yab u tomnal quin chich ta tamet. ");
INSERT INTO husNT1971_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ani lej jic’pax a Simón ani c’al patal in at t’ojnalchic c’al nixe’ xi yantalam i to’ol calthame. ");
INSERT INTO husNT1971_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Aniye jaye in jic’pal a Jacobo ani a Juan in cuitolilchic a Zebedeo. Pelchic xe’ in at t’ojnal jaye a Simón. Tam uchan a Simón c’al a Jesús: ―Yab quit jiq’uey, quit chich c’al nana’. Ma xohue’its nan ne’ets tu aba’ tit alim c’al an inic axi nana’ tiquim bela’. ");
INSERT INTO husNT1971_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","C’al axe’ xi cau im beltha’chic an tan ma in tamu an tsabal. Tam in tala’ jilcachiquiy in t’ojlabil, ani ts’at’eychic c’al a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jun a q’uicha c’uajat a Jesús al i bichou tam ti ulits jun i inic ax in cua’al i t’it’ c’apux c’al in anam t’u’ul. In tsu’u a Jesús ani chich in tuthuhual in c’ualal tin tamet, ma pac’lun tsabal c’al in hual. In lej canat ucha’: ―Ajatic, max a le’ac a huit’al tiquin jeltha’. ");
INSERT INTO husNT1971_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Tam a Jesús in tacchi c’al in c’ubac ani in ucha’: ―U le’ tu jeltha’, ani ma xohue’ it jelthachits. Ani tameq’ui tixc’anchatits an t’it’. ");
INSERT INTO husNT1971_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Tam a Jesús in ucha’ yab quin olchi jita’ jahua’ t’ajchinenec. In ucha’ jaye: ―Expith quit c’ale c’al am pale’ ani ca bina’ an ts’acchixtalab ax in ulal an ts’ejcath cau binath c’al a Moisés in uchbil quim bina’ jitats jelthachits c’al an t’it’ axi c’apux c’al in anam t’u’ul. Antsana’ ta ca t’aja’ abal ca tejhua’methanchi an inicchic abal it jelthachits. ");
INSERT INTO husNT1971_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ani lej t’iloxnanchab in labith t’ajbilchic a Jesús. Chuthel chuthel u tamcunal yantalam i inic abal quin ats’anchi in cahuintal ani abal ca jeltha. ");
INSERT INTO husNT1971_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Aba ani’ u le’nab ca ats’anchat in cahuintal a Jesús, bel jaja’ u pelel junchiquil al i joltam ca olon. ");
INSERT INTO husNT1971_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Jun a q’uicha tam ti exobchix a Jesús, c’uajat quetechic ti ots’ohuix i fariseochic ani i exobchixchic c’al an ts’ejcath cau binath c’al a Moisés. Che’necchic ma ti Jerusalén ani ma tim patal am bichouchic axi cuentalith ti Galilea ani ti Judea. Jaye a Jesús in jelthal i ya’ulchic, ani antsana’ tin tejhua’methal in tsap a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Tam ulits talchic i inic in chi’thal i tsambe al i tseyte’ tat. In le’ quin otha’ tin al an ata ani quin mo’ca’ tin tamet a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Yab in ejtou ni ju’ta quin otha’ cum lej yantalam an inicchic c’uajat. Tam c’athiychic hualq’ui’ ani in jacchi hue’ in jujlabil an ata. Tam im pa’ba’chic an tsambe c’al patal an tseyte’ tat, ani in mo’ca’ tin tamet a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Tam ti a Jesús in tsu’u antsana’ in lej belalchic, tam in ucha’ an tsambe: ―Nan tu paculanchal a hualab. ");
INSERT INTO husNT1971_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Tam an exobchixchic c’al an ts’ejcath cau binath c’al a Moisés ani an fariseochic in tsalpanchal jahua’ a Jesús antsana’ in ucha’ an tsambe. In tsalpayalchic jita’ jaja’ abal in t’ajal ejtil max pel a Dios. In uluchic tin ichich abal expith a Dios jats in cua’al in eyaltal quim paculanchi in hualab an inic. ");
INSERT INTO husNT1971_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ani a Jesús in exla’its jant’ini’ tu tsalpanchab c’al jaja’chic. Jaxtam in ucha’chic: ―¿Jale’ tata’chic tin q’uibts’oth tsalpanchal u ey? ");
INSERT INTO husNT1971_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Yab q’uibat abal nan cu ucha’ an tsambe nan tu paculanchal a hualab, ani yab q’uibat jaye cu ucha’ quit ts’aquiy ani quit belats. ");
INSERT INTO husNT1971_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Nana’its tin Juntal patal an inicchic, ani c’al u eyaltal tin jelthom tiquin exlanchi u ey abal u cua’al jaye u eyaltal teje’ tsabal cu paculanchi in hualab an inic. Tam a Jesús in ucha’ an tsambe: ―Quit ts’aquiy ca thaya’ a tseyte’ tatil ani quit c’alets ta q’uima’. ");
INSERT INTO husNT1971_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ma tameq’ui thubat ts’acpan jelthachits, ani in thaya’ in tseyte’ tatil jun ti cuatsatac, ani ta c’ale tin q’uima’. In lej puhuethanchal im bij a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Patal an inicchic axi muthat taja’ in jic’pal ani im puhuethanchal im bij a Dios jaye. In uluchic: ―Xo’ ojni’ i tsu’uhuits i labith t’ajbilab. ");
INSERT INTO husNT1971_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Taley talbel tam ti ne’ets ti bel a Jesús in tsu’u jun i inic quetel im bats’c’uhual an jalbixtalab tumin tin cuenta an gobierno. Pel a Leví. A Jesús in ucha’: ―Tiquin ts’at’enchi. ");
INSERT INTO husNT1971_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Tam thubat cuble a Leví, in tala’ jilcachiquiy jahua’ in t’ajalac. In ts’at’enchi a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ani talbel ts’ejcanchat a Jesús i ts’alat c’apuxtalab tin q’uima’ a Leví. C’uajatchic taja’ quetel ti c’apul al an mexa yan i bats’c’ul jalbixtalab tumin tin cuenta an gobierno ani yan q’ue’at i inic. ");
INSERT INTO husNT1971_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Tam talchic i fariseo ani i exobchixchic c’al an ts’ejcath cau binath c’al a Moisés in ts’i’quiyal quin jolbiy in exobalilchic a Jesús. In ucha’chic: ―¿Jale’ a t’ajalchic antsana’ it junax c’apul c’al nixe’ xi bats’c’ul jalbixtalab tuminchic tin cuenta an gobierno ani c’al xi q’ue’at i hualbith inicchic? ");
INSERT INTO husNT1971_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Toc’tsin a Jesús in ucha’chic: ―Axi lubach an inic yab in yejenchal i ilalix, expith axi ya’ul ojni’ jats in yejenchal. ");
INSERT INTO husNT1971_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nan in che’nec cu caniy ca chich c’al nana’ ca jic’tson c’al in hualab jitats in lej exlalits tin ichich abal pel i hualbith inic ani iba ax in tsalpayal pel i alhua’ inic. ");
INSERT INTO husNT1971_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Exom conoyabe a Jesús c’al an fariseochic ani c’al an exobchixchic c’al an ley binath c’al a Moisés antse’: ―¿Jale’ u huilq’uith pabil yab u c’apul ani u lej ol in exobalilchic a Juan pujax ani in exobalil an fariseochic, ani tata’ a exobalilchic patal a q’uicha u c’apul ani yab u pabil? ");
INSERT INTO husNT1971_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Toc’tsiyatchic c’al a Jesús: ―Yab in tomnal ca pablats yab ca c’aputs ax u tsa’bixchic c’al an tomquintalab biyat c’uajate an tomquinel inic. ");
INSERT INTO husNT1971_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Max quim baju a q’uicha tixc’anenequits an tomquinel inic, tam ojni’ in tomnalits ca pablatschic ani yab ca c’aputs. Tam nan in tixc’anenecaquits, tam ojni’ in tomnal ca pablats u exobalilchic jaye. ");
INSERT INTO husNT1971_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","A Jesús in uchayechic i jalpith cau: ―Yab in tomnal ca muts’iyat i it ts’ejcathits toltom ani c’al ca c’ua’chiyat i biyal toltom. Max ani’ ca t’ajchin, u othiyab axi it. Ani jaye am pejach an it toltom yab u jilc’onal alabel c’al am biyal toltom. ");
INSERT INTO husNT1971_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Yab in tomnal ca baliyat al i biyal balixtalab ot’ in ja’lil an lab t’uthub ax u it boclinalits. Max ani’ ca t’ajan, ne’ets ca mits’c’an an ot’ ani ne’ets ca huac’lan am boc lab t’uthub. Antsana’ ti ne’ets ca othey am balixtalab ot’ ani ne’ets ca q’uibey am boc. ");
INSERT INTO husNT1971_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Jaxtam in tomnal ca baliyat in ja’lil an lab t’uthub ax u it boclinalits al i it balixtalab ot’. Tam ne’ets ca ohuey am balixtalab ot’ ani jaye am boc. ");
INSERT INTO husNT1971_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Jitats in uts’al am biyal boc yab ne’ets quin le’na’ axi it, cum in tsalpayal abal axi biyal jats axi lej huinat alhua’. ");
INSERT INTO husNT1971_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Jun i sábado xe’ets a Jesús junax c’al in exobalilchic al jun i t’ayablab lab em, ani in exobalilchic xe’ets im putsiyal in hualil an lab em. In ixiyal tin c’ubac ani in c’apal. ");
INSERT INTO husNT1971_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Tam uchanchic c’al an fariseochic: ―Tata’chic ojni’ a t’ajal tam sábado jahua’ in ulal an ts’ejcath cau binath c’al a Moisés yab ca t’aja’. ");
INSERT INTO husNT1971_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Tam a Jesús in ucha’ an fariseochic: ―Hualam yab a ajiyamal jant’o in t’aja’ a David junax c’al in junquilchic ti jayq’ui’ tam ti c’a’il jaja’chic. ");
INSERT INTO husNT1971_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Otsits jaja’ tin q’uima’ a Dios ani in c’apchi an t’ocat pan axi expith u jilchinal quin c’apu am pale’chic. Aba ani’ yab pel i pale’ a David, in c’apchi nixe’ xi pan ani im pitha’ in junquilchic quin c’apchi jaye. ");
INSERT INTO husNT1971_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","A Jesús in uchayechic antse’: ―Nana’its tin Juntal patal an inicchic ani u cua’al u eyaltal cu ulu jant’o ta ca eyentha an sábado. ");
INSERT INTO husNT1971_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Junaque i sábado otsits a Jesús tin tiyopanil an Israelchic, ani taja’ in ts’i’quiy ti exobchix. Ani c’uajat taja’ jun i inic axi huayenec in huinab c’ubac. ");
INSERT INTO husNT1971_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","An fariseochic ani c’al an exobchixchic c’al an ts’ejcath cau binath c’al a Moisés in lej tsapic co’com a Jesús c’al in hual. Max quin jeltha’ tam sábado an inic, ne’ets quin jolbiy. ");
INSERT INTO husNT1971_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","A Jesús in exla’its abal antsana’ tu tsalpanchab c’al jaja’chic. Tam in ucha’ an inic axi huayenec in c’ubac: ―Quit ts’aquiy ani quit cubiy teje’. Tam ts’aquiy ani cubiy. ");
INSERT INTO husNT1971_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Tam a Jesús in conoy an fariseochic ani nixe’ xi exobchix: ―¿Jant’o tu jilalchic an ts’ejcath cau binath c’al a Moisés qui t’aja’ tam sábado? ¿Qui t’aja’ alhua’ o qui t’aja’ yab alhua’? ¿Qui jeltha’ axi ya’ul o qui jila’ ca tsemets? ");
INSERT INTO husNT1971_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Tam a Jesús tocat in met’al tin tonith axi c’uajatchic c’al jaja’, ani in ucha’ an inic axi huayenec in c’ubac: ―Xo’ ca lemc’a’ a c’ubac. In lemc’a’, cum jelthachits. ");
INSERT INTO husNT1971_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Tam lej tsacuy axi c’uajatchic taja’, ani conóx jun c’al xi jun jant’ini’ ti quin jolbiy a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Jun a q’uicha c’ale a Jesús al i bolchal ca olon, ani ma tats tin huat’a’ patal an acal ti ol. ");
INSERT INTO husNT1971_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Tam ti chuthenequits, in caniy ca chich in exobalilchic quin tacuy lajuj tsab jaja’chic tin abathualejil. ");
INSERT INTO husNT1971_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Im bijchic pel a Simón Pedro, ani a Andrés axi pel in ebchal a Simón. Pel a Jacobo, ani a Juan, ani a Felipe, ani a Bartolomé. ");
INSERT INTO husNT1971_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Pel a Mateo, ani a Tomás, ani a Jacobo axi pel in tsacamil a Alfeo, ani a Simón axi pelac i ts’at’el c’al an cuenel ax u bijiyab ti cananista. ");
INSERT INTO husNT1971_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Taley pel a Judas in ebchal a Jacobo, ani jaye a Judas Iscariote axi ne’ets quin tsinat bina’ a Jesús tin c’ubac in tomolnaxilchic. ");
INSERT INTO husNT1971_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Taley pa’iy a Jesús ti al am bolchal junax c’al in exobalilchic, ani jilc’on al jun i pac’chal jun ti mulcunenequits yantalam i inicchic. Che’nec jaja’chic ma tim puhuel Judea ani ma ti Jerusalén. Talchic jaja’ che’nec ma ti Tiro ani ti Sidón axi pel i bichouchic tin hualchicte’lil am pulic lejem. Che’necchic abal quin ats’anchi in cahuintal a Dios c’al a Jesús, ani jaye abal ca jeltha c’al an yau’lats ax in cua’alchic. ");
INSERT INTO husNT1971_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Talchic jaye u co’oyab c’al i at’ax teneclab, ani u canchinal. ");
INSERT INTO husNT1971_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Patal an ya’ulchic in lej le’ ca tacxin c’al a Jesús, cum jaja’ in tala’ jelthal an yau’lats c’al in tsap. ");
INSERT INTO husNT1971_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Tam in met’al a Jesús in exobalilchic ani in ucha’chic: ―Ne’ets quit lej culbechic max a ats’al it ts’ejhuantal ta ichich tin tamet a Dios, cum tamits a Dios ne’ets quin t’aja’ ti Ts’ale ta ichich. ");
INSERT INTO husNT1971_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ne’ets quit culbechic max a c’a’inchal jahua’ bolith, cum tamits a Dios ne’ets ti pitha’. Ne’ets quit culbechic max it uc’nal, cum tamits a Dios ne’ets ti culbethanchi a ichich. ");
INSERT INTO husNT1971_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Ne’ets quit culbechic max quit at’a ani max quit pojca c’al tin ebal nana’ u bij tin Juntal patal an inicchic. Ne’ets quit culbechic max quit ts’a’uhuat c’al i cau ani max quit tilibnanchat a bij tin ebal nan u bij. ");
INSERT INTO husNT1971_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Quit jum putat culbechic tam quim bajuhuits a q’uicha antsana’ ti quit t’ajchin, cum tam quit ulits ti eb ne’ets quit pithan lej yan a atohual. Ca t’ila’ abal antsana’its ti yajchiquiyame jaye im biyal caulomejilchic a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","It ts’ejhuantalchic max it rico c’al expith jahua’ teje’ tsabal, cum jats expith a ejtohual ca culbetna’. ");
INSERT INTO husNT1971_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","It ts’ejhuantalchic max a tsalpayal yab a yejenchal a Dios, cum talbel ne’ets ca ats’a’ i yejenchixtalab ta ichich. It ts’ejhuantalchic max it culbel ta cuetemtal ani yab c’al a Dios, cum ne’ets quim baju a q’uicha ma tam quit uq’uin tin ebal an t’e’pintalab. ");
INSERT INTO husNT1971_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","It ts’ejhuantalchic max patal an inicchic ti uchal abal it alhua’ iniccua’, cum antsana’ tu uxnal tam ti biyalits an q’uet’ach caulomechic jaye. ");
INSERT INTO husNT1971_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Nan tu uchalchic axi xo’ tin ats’anchal, ma ca c’anitha’ a tomolnaxil. Ma ca t’ajchi i alhua’talab jaye jitats ti at’al. ");
INSERT INTO husNT1971_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ca conchinchi i lablinchixtalab c’al a Dios jitats ti quithab uchal ani jitats ti ts’a’uhual c’al i cau. ");
INSERT INTO husNT1971_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Max jita’ ti cuajchi ta ts’a’ub, ca huenc’onchi jaye axi jum poq’ue’. Max jita’ ti tixc’anchi a pulic coton, ca jila’ ti tixc’anchi jaye a coton. ");
INSERT INTO husNT1971_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Max jita’ ti conchi jant’ots, ca pitha’. Max jita’ ti tixc’anchi i c’alab, yab ca xijc’ath ucha’ ti huichbanchi. ");
INSERT INTO husNT1971_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Jant’ini’ tata’chic a le’ quit t’ajchin alhua’, antsana’ ta ca t’ajchi a at inic. ");
INSERT INTO husNT1971_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Yab pel i lej alhua’talab max expith a c’anithal jitats ti c’anithal. Ma am pojcaxchic in c’anithal in at pojcax. ");
INSERT INTO husNT1971_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Yab pel i lej alhua’talab max expith a t’ajchal i alhua’talab jitats ti t’ajchal i alhua’talab. Ma am pojcaxchic in t’ajchal i alhua’talab in at pojcax. ");
INSERT INTO husNT1971_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Yab pel i lej alhua’talab max expith a matinchal jita’ in ejtohual ti huichbanchi. Ma am pojcaxchic in matinchal in at pojcax. ");
INSERT INTO husNT1971_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Tata’chic pelits a uchbil ma ca c’anitha’ a tomolnaxil ani ca t’ajchi i alhua’talab. Ca matinchi ani yab ca xijc’ath aychi ti huichbanchi. Max antsana’ ta ca t’ajchi a at inic, tam a Dios ne’ets ti pithaye más yan i alhua’talab. Tam ojni’ ne’ets quit exlachic tit tsacamlab c’al a t’ecat pulic Pay’lom Dios ti eb. Ca t’ajchi alhua’ a at inic, cum a Dios pel i alhua’ inic ma c’al axi yab c’ac’nax c’al jaja’ ani ma c’al axi pojcax jaye. ");
INSERT INTO husNT1971_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Jant’ini’ a Tata ti eb in yajnanchal patal an inicchic, antsana’te ca yajnanchichic. ");
INSERT INTO husNT1971_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Yab ca jolbiychic a at inic, ani a Dios yab ne’ets ti jolbiy. Yab ca t’e’tsiychic a at inic, ani a Dios yab ne’ets ti t’e’tsiy. Ca paculanchi a at inic, ani a Dios ne’ets ti paculanchi. ");
INSERT INTO husNT1971_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ca pitha’ a at inic, ani a Dios ne’ets ti pitha’. Ne’ets ti lej pitha’ alhua’ lejbath, ani alhua’ ni’ath, ani alhua’ thiyach, ani ma alhua’ oc’at. C’al a lejbaxtal jant’o tit lejbanchix ani ca pitha’ a at inic, antsana’ a Dios jaye ne’ets ti lejbanchi ani ti pitha’. ");
INSERT INTO husNT1971_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Tam a Jesús in uchaye q’ue’at i jalpith cau: ―Auxe’ max in ejtohual i joc’tsi quin lotocna’ in at joc’tsi. Hualam axi tsab tin eb ne’ets ca ijcan al i jol cum yab u tsu’ux. ");
INSERT INTO husNT1971_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Yab u jalunchab in tsalpathtal an exobchix c’al in tsalpathtal an exobal. Ma an exobal quin tala’ exobnanchits in exobchixtal an exobchix, tam tiq’uele ne’ets quin ejtilnanchi in tsalpathtal an exobchix. ");
INSERT INTO husNT1971_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Tata’chic ojni’ a huat’ath t’ajchal ti cuenta in tsacam hualab a at inic, ani yab a t’ajal ti cuenta a pulic hualab. Ejtil max ca tsu’chi an tsacam amul tin hual a at inic, ani yab a t’ajal ti cuenta am pulic te’ axi c’uajat ta cuete’ hual. ");
INSERT INTO husNT1971_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Tata’ ojni’ a uchal a at inic abal ti jilchi ca tixc’anchi an amul tin hual, ani yab a t’ajal ti cuenta am pulic te’ axi ta cuete’ hual. Tocat it eb t’ocatq’uichic. Ca oc’ox tixc’a’ am pulic te’ ta hual, ani tam tiq’uele ne’ets quit tajax tsu’xinits abal ca tixc’anchi an tsacam amul tin hual a at inic. ");
INSERT INTO husNT1971_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Axi alhua’ an te’ yab in ejtohual quim bina’ i quithab hualilab, ani axi yab alhua’ an te’ yab in ejtohual quim bina’ i alhua’ hualilab. ");
INSERT INTO husNT1971_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","I exlal an te’ c’al in hualil. Am bathuch yab im binal i hualilab lab bec, ani an t’ocnal ts’aj yab im binal i hualilab lab t’uthub. ");
INSERT INTO husNT1971_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","An inic axi alhua’ in ichich in caunal i alhua’ cau, ani an inic axi quithab in ichich in caunal i quithab cau. Jant’inits tin lej ichich an inic, jats ne’ets quin ulu tin hui’. ");
INSERT INTO husNT1971_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Tata’chic tin alq’uith bijiyalq’ui tin Ajatic ani yab a t’ajal jahua’ nan tu uchal ca t’aja’. ");
INSERT INTO husNT1971_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Nan ne’ets tu olchichic in ejtiltal jitats ca chich c’al nana’ ani tiquin ats’anchi u cahuintal ani tiquin t’ajchi jahua’ nan cu ucha’ quin t’aja’. ");
INSERT INTO husNT1971_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Pelchic xe’ ejtil i ts’ejcom ata ax in oc’ox tsaja’ lej luputh ma im baju jun ti c’uajat i t’ujub. Tats tin mo’ca’ in t’ujub cub abal ca tsapic cubiy an ata. Lej puhuey am pulic itse’ ma an ja’ im baju in acan an ata, ani yab paclun an ata cum in cua’al in lej alhua’ cub. ");
INSERT INTO husNT1971_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Jitats tiquin ats’anchi u cahuintal ani yab tiquin t’ajchi, jayetseq’ui ejtil i ts’ejcom ata. Pelchic xe’ ejtil i ts’ejcom ata ax in eb cuba’ i ata eblimq’ui an tsabal, ani yab in ts’ejcanchi in t’ujub cub an ata. Lej puhuey am pulic itse’ ma an ja’ im baju in acan an ata, ani tocat cuajla ani tala’ paclunits an ata. ");
INSERT INTO husNT1971_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Talits ti exobchix a Jesús c’al an iniclom, ta c’ale ti Capernaum. ");
INSERT INTO husNT1971_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Taja’ ti c’uajat jun i capitán soldado romano ax in cua’al in tolmihual lej c’alchith, ma hue’its ne’ets ca tsemets. Ani lej c’anithab c’al an capitán. ");
INSERT INTO husNT1971_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Tam tin ats’a’ an capitán abal ta xe’ets a Jesús, in aba’ talchic i yejtselab Israel quin caniy ca chich abal ca jelthanchat in tolmihual. ");
INSERT INTO husNT1971_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Utey jaja’chic c’al a Jesús, in lej canat ucha’: ―Pel i lej alhua’ inic an capitán ani in tomnal tata’ ca jelthanchi in tolmihual. ");
INSERT INTO husNT1971_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Jaja’ lej c’anithom c’al am bichou Israel, ma tu ts’ejcanchamal huahua’ i tiyopan. ");
INSERT INTO husNT1971_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Tam ta c’ale a Jesús junax c’al jaja’chic. Tam ti utatits ti ne’ets ca ulits tin q’uima’ an capitán, tam an capitán in aba’ talchic in ja’ub quin ucha’ a Jesús antse’: ―Ajatic, yabats ca t’aja’ i t’ojlab quit chich, cum nan u ats’al abal yab u cua’al u alhua’ abal tata’ quit otsits nan tu q’uima’. ");
INSERT INTO husNT1971_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ani jaxtam nan yab in c’ale tu aliy. Bel tocat ca ulu i cau tata’, ani ne’ets ca jeltha u tolmihual. ");
INSERT INTO husNT1971_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","U exlal abal jahua’ tata’ ca ulu, jats ne’ets ca t’ajan. Cum nana’ in abatnab c’al i oc’lec ani nana’ pel tin abatnom c’al i soldadochic. Max nan cu ucha’ i soldado ca c’ale ju’ta, ne’ets ca lej c’ale. Max nan cu ucha’ i soldado ca chich teje’, ne’ets ca lej chich. Max cu ucha’ u tolmihual quin t’aja’ jant’ots, jats ne’ets tiquin t’ajchi. ");
INSERT INTO husNT1971_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","In jic’pal a Jesús tam ti olchin abal an capitán in ulu antsana’. Tam in met’al an inicchic axi ts’at’at c’al jaja’, ani in ulu: ―Lej chubax yab ju’ta u elamal jitats lej belom ejtil axe’ xi capitán. Ma ni c’al an Israelchic yab u elamal. ");
INSERT INTO husNT1971_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Tam ti huichits jaja’chic tin q’uima’ an capitán axi abatnamechic quin taunanchi a Jesús, tam in ela’ jelthachits in tolmihual an capitán. ");
INSERT INTO husNT1971_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Taley a Jesús ne’ets tihua’ ti bichou Naín junax c’al in exobalilchic ani c’al yantalam i inicchic jaye. ");
INSERT INTO husNT1971_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Tam ti hue’its utat ne’ets quim baju am bichou, a Jesús in tsu’u u ne’thab jun i tsemelom ca joliyat. Pel in juncats cuitolil i tsemchith uxum. Ani ne’ets junquimte an tsemchith uxum c’al yantalam i inicchic ax u c’uajilchic taja’ ti Naín. ");
INSERT INTO husNT1971_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Tam ti a Jesús in tsu’u an tsemchith uxum in yajnanchi, ani in ucha’: ―Yabats quit uq’uin. ");
INSERT INTO husNT1971_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ani utey in taca’ an caja jun ti balith an cuitol tsemelom, ani cubitschic an quital. Tam a Jesús in tauna’ an tsemelom: ―Cuitol, quit ts’aquiy. ");
INSERT INTO husNT1971_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Tam ts’acpan an cuitol axi tsemenecac ani in ts’i’quiy ti cau. Ani taley a Jesús in huat’banchi c’al in mim. ");
INSERT INTO husNT1971_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ani patal an inicchic axi taja’ jic’tson tam tin tsu’u jahua’ t’ajnenec, ani im puhuethanchal im bij a Dios. In uluchic: ―Teje’ chichits c’al huahua’ jun i pulic caulome. In uluchic jaye antse’: ―Pel in abbil a Dios abal tucu tolminchi huahua’ ax pel tu bichohuil a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ani t’iloxnanchab jat’hua’ tim puhuel am pulic bichoulom Judea an labith t’ajbilab jahua’ antsana’ in t’aja’ a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","A Juan pujax in tso’obna’its jant’ini’ tin t’ajamal a Jesús cum olchinenequits c’al in ts’at’elilchic. In caniy ca chich tsab jaja’chic. ");
INSERT INTO husNT1971_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","In aba’chic ca c’ale c’al a Jesús quin conoy max chubax jaja’ ja’its pel a Cristo axi bijithits ne’ets ca aban ca chich c’al a Dios. Max yab ja jaja’, tam quin conoy max quin aychiye más jita’ ca aban. ");
INSERT INTO husNT1971_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ulitschic c’al a Jesús, ani in ucha’: ―A Juan pujax tu abamal abal tu conoy max tata’its pel it Cristo ax it bijithits ne’ets quit aban c’al a Dios quit chich. Ani max iba, tam tucu ucha’ max qui aychiye más jita’ ca aban. ");
INSERT INTO husNT1971_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Exome a Jesús in jelthal yantalam i ya’ulchic. Jaye in canchal i at’ax teneclab an inicchic ani in tsu’uxmethal yan i joc’tsichic. ");
INSERT INTO husNT1971_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Taley in toc’tsiy in abatnanelilchic a Juan: ―Quit c’alechic ca olchi a Juan jahua’ xohue’its a tsu’umal ani jahua’ a ats’amal u t’ajchal an inicchic. U tsu’uxmethal an joc’tsichic ani u jelthal an c’uets’e’chic abal ca alhua’ belats. U jelthal ax in cua’al i t’it’ axi c’apux c’al in anam t’u’ul. Jaye u ots’oxmethal an tsinechic ani u ejthal an tsemelomchic. Jaye u thajchixnanchal an ts’ejhuantalchic an alhua’ cau. Antsana’ ca olchi a Juan. ");
INSERT INTO husNT1971_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Lej culbelits jitats t’ayath belom c’al nana’ ani max yab u t’apchinal im belomtal. ");
INSERT INTO husNT1971_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Tam ti c’alets in abatnanelilchic a Juan, tam a Jesús in ts’i’quiy quin t’iloxnanchi an inicchic a Juan, ani in conoyal antse’: ―¿Jant’o tam inic a tsalpay ne’ets ca tsu’uchic tam it c’ale ca tsu’u a Juan tihua’ ti al an joltam? Hualam a tsalpay ne’ets ca tsu’u i inic axi palulul ejtil i pacáb tam juchuyab c’al an ic’. ");
INSERT INTO husNT1971_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ani max i, hualam a tsalpay ne’ets ca tsu’u jun i inic lej huinat alhua’ ts’ejcath. Tata’ ojni’chic a alhua’ tso’obits abal axi lej huinat alhua’ ts’ejcath ani in ts’alat huat’al tim ba’ jats ax u c’uajil tin q’uima’ i ts’ale. ");
INSERT INTO husNT1971_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Tiquin ucha’ jant’o tam inic a chubax tsalpay ne’ets ca tsu’u max yab i pel i caulome c’al a Dios. Ja’its jaja’ a Juan, ani in ey jaja’ lej c’athpich yab ejtil axi q’ue’atchic an caulome c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Jats a Juan ax u olnab al an T’ocat Thuchlab ax in ulal antse’: Nana’ in Dios ne’ets cu oc’chith aba’ u caulomejil abal ti ts’ejcacanchi am bel. ");
INSERT INTO husNT1971_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Nan tu uchalchic abal ja’its a Juan pujax axi lej c’athpich pulic in ey ti caulome c’al patal an inic axi ma xo’ hua’tsinenequits. Bel abal ani’ antsana’ in ey jaja’ xo’ lej c’athpich, talbel ne’ets ca jalunchat c’al axi más tsipili’ in ey tam a Dios quin t’aja’ ti lej Ts’ale. ");
INSERT INTO husNT1971_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Yan i inicchic axi c’uajat taja’ ani ma i bats’c’ul jalbixtalab tumin tin cuenta an gobierno tam tin atsa’its jahua’ antsana’ in ulu a Jesús, im puhuethanchal im bij a Dios. Ja’its jaja’chic axi pujnenequits c’al a Juan. ");
INSERT INTO husNT1971_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","An fariseochic ani axi exobchixchic c’al an ts’ejcath cau binath c’al a Moisés iba. Yab pujnenec jaja’chic c’al a Juan, ani antsana’ im pojcanchal in culbetal a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Taley in ulu an Ajatic: ―¿Jant’o c’al tu cu tejhua’methanchi in ey an inicchic axi xo’ xe’ets tsabal? ");
INSERT INTO husNT1971_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Pelchic ejtil i tsacam ax u ubat’q’ui ti al am plaza. Ca thajat uchan c’al in at ubat’chic antse’: It juchunchame an tsul tam ajib ani yab it bixmats. It yajchic ajtinchame tin q’uichajil an tsemelom ani yab it uq’uincua’. ");
INSERT INTO husNT1971_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Chich a Juan lej pabil c’al an c’apnel, ani a uluchic c’uajchith c’al i at’ax teneclab. ");
INSERT INTO husNT1971_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Talbal nana’ tin Juntal patal an inicchic in chichne. Yab im pabil c’al an c’apnel, ani tocat a uluchic pel tin c’apts’uts’ma’ ani pel tin uts’uts’ul. Pel tin ja’ubcua’ axi bats’c’ul jalbixtalab tumin tin cuenta an gobierno ani pel tin ja’ubcua’ axi exlath ti lej hualbith inicchic. ");
INSERT INTO husNT1971_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Aba ani’ antsana’ u tsalpanchab nana’ ani a Juan, bel axi tsalpathchic in alhua’ tso’obits abal huahua’ u pithnenec an tsalpathtalab c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Cum conoyat a Jesús c’al jun i fariseo ca c’aputs c’al jaja’, c’ale tin q’uima’. Ulits taja’, ani buxcan ba’ an mexa. ");
INSERT INTO husNT1971_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ani jun i lej hualbith uxum al nixe’ xi bichou in tso’obna’its abal a Jesús ta c’uajat ti c’apul. Tam chich in chal i frasco ts’ejcath c’al i t’ujub im bij alabastro. T’uchat an frasco c’al i nihuihuiltalab. ");
INSERT INTO husNT1971_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Utey tin tamet a Jesús in tuthu in c’ualal. Cum uc’nal, ijcan in ja’lil in hual tin acan a Jesús. Tam in huayethanchi c’al in xi’il. Taley in ts’uts’banchi in acan, tam tin jolchi an nihuihuiltalab. ");
INSERT INTO husNT1971_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Tam tin tsu’u nixe’ xi fariseo antsana’ t’ajchinenequits a Jesús, in cuete’ tsalpaychic tin ichich antse’: Max axe’ xi inic pelac i lej chubax caulome c’al a Dios in exlamalac abal pel i lej hualbith uxum c’al ti chich ti tacnal. ");
INSERT INTO husNT1971_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Tam uchan an fariseo c’al a Jesús: ―Nan u le’ tu ucha’ jun i cau, Simón. Toc’tsin an fariseo: ―Tiquin ucha’, Exobchix. ");
INSERT INTO husNT1971_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Tam uchan c’al a Jesús: ―Jun i inic u nenchinal i tumin c’al tsab i inic. C’al jun u nenchinal bo’ i bo’ inicchic i tumin ani c’al axi junaque u nenchinal tsab inic c’al lajuj i tumin. ");
INSERT INTO husNT1971_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Cum yab in ejtohualchic quin jalbinchi an matith tumin, tamna’ paculanchatits c’al an thabal tumin. Xo’ tata’ tiquin olchi jahua’ nixe’ xi tsablom axi ne’ets ti más c’anithom c’al an thabal tumin. ");
INSERT INTO husNT1971_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Toc’tsin a Simón: ―Nan tu tsalap ne’ets ti más c’anithom axi paculanchatits más yan an tumin in ne’thal. Uchan c’al a Jesús: ―Chubax jahua’ a ulu. ");
INSERT INTO husNT1971_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Tam a Jesús in met’a’ an uxum, ani in ucha’ a Simón: ―Ca t’aja’ ti cuenta jahua’ tin t’ajchamal axe’ xi uxum. Nan in otsits ta q’uima’, ani tata’ yab tim pitha’ i ja’ cu t’aca’ u acan. Axe’ xi uxum tin t’acchi u acan c’al in ja’lil in hual ani tin huayethanchi c’al in xi’il. ");
INSERT INTO husNT1971_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Tata’ yab tin ts’uts’bay, ani jaja’ tin ts’uts’babanchi u acan. ");
INSERT INTO husNT1971_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Tata’ yab tin jolchi i aceite tu oc’, ani jaja’ tin jolchi i nihuihuiltalab tu acan. ");
INSERT INTO husNT1971_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Nan tu uchal abal jaja’ c’al in lej c’anithomtal in tejhua’methamal abal paculanchamejits in yantalam hualab. Axi paculanchamejits lej hue’ in hualab lej hue’ in c’anithomtal. ");
INSERT INTO husNT1971_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Tam uchan an uxum c’al a Jesús: ―Nan tu paculanchamalits a hualab. ");
INSERT INTO husNT1971_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Tam axi c’uajatchic quetel c’al a Jesús ba’ an mexa in ulu jun c’al axi jun: ―¿Jita’ hualam axe’ xi inic abal ti paculanchix c’al i hualabtalab? ");
INSERT INTO husNT1971_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Tam a Jesús in ucha’ an uxum: ―It jec’onthach c’al a hualab cum tim belamalits. Quit c’ale ta q’uima’ c’al a ichich ts’aclalathits. ");
INSERT INTO husNT1971_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Taley xe’tsitsil a Jesús ti yan i bichou ani ti yan i cuenchalabchic in olnal jant’ini’ tin t’ajal a Dios ti Ts’ale. Junax xe’ets c’al jaja’ axi lajuj tsab in abathualejil. ");
INSERT INTO husNT1971_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Xe’ets c’al jaja’ jaye tsab ox i uxum axi canchinenec i at’ax teneclab ani axi jelthame c’al an yau’lats. Jun pel a María Magdalajib axi canchinenec buc i at’ax teneclab. ");
INSERT INTO husNT1971_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Q’ue’at pel a Juana in tomquil a Chuza axi pel in tolmihual an ts’ale Herodes. Q’ue’at pel a Susana. Xe’ets jaye hue’ yan i uxum ax in tolminchal a Jesús c’al jahua’ in cua’al. ");
INSERT INTO husNT1971_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Yantalam i bichouchic chich quin tsu’u a Jesús. Tam ti mulcunenequits uchanchic i jalpith cau antse’ c’al jaja’: ");
INSERT INTO husNT1971_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―C’ale ti buc’ul jun i buc’ul iyalab lab em. Xe’ets ti buc’ul ani ijcan talchic i iyalab ti al am bel. Taja’ u q’uets’nal c’al an inicchic ani u c’apab c’al an ts’itsin. ");
INSERT INTO husNT1971_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Talchic i iyalab ijcan jaye jun ti hua’ats yan i t’ujub ani yab lej anmith. Taja’ cale ani huayts’on cum huayenec an tsabal. ");
INSERT INTO husNT1971_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Talchic i iyalab ijcan jaye jun ti hua’ats yan i q’uith. Taja’ cale ani tala’ paxq’uiyatits c’al xi yantalam an q’uith. ");
INSERT INTO husNT1971_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Talchic i iyalab ijcan jaye jun ti alhua’ an tsabal. Taja’ cale ani puhuey, ma hua’ats i acan im bina’ in hualil ti bo’ inic. Tam tin ulumalits axe’ xi cau a Jesús, tam in lej tsapic ucha’ axi muthat taja’chic: ―Jitats junat in ichich c’al nana’ u ichich, quin lej alhua’ bina’ in xutsun c’al axe’ xi cau. ");
INSERT INTO husNT1971_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Tam conoyab a Jesús c’al in exobalilchic abal jant’o in le’ quin ulu nixe’ xi jalpith cau c’al am buc’ul iyalab lab em. ");
INSERT INTO husNT1971_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ani uchanchic c’al a Jesús: ―Tata’chic ti tso’oblinchal a Dios jant’ini’ tin t’ajal ti Ts’ale, ani axi q’ue’atchic teje’ ti al an mulcunel u olchal expith c’al i jalpith cau. Quin met’a’ jaja’chic jahua’ u t’ajal, ani ejtil max tam yab in lej tsu’tal. Quin ots’ohuiy in cahuintal a Dios jahua’ u olchal, ani ejtil max tam yab in lej ats’al. ");
INSERT INTO husNT1971_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Xo’ nan ne’ets tu olchichic jant’o in le’ quin ulu nixe’ xi jalpith cau. An iyalab lab em jats ejtil in cahuintal a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","An iyalab axi ijcanenec al am bel jats ejtil an inic axi quin ats’anchi in cahuintal a Dios ani ca tixc’anchat c’al an teneclab. Yab u jilchinal quim bela’ ani ca jec’ontha c’al in hualab. ");
INSERT INTO husNT1971_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","An iyalab axi ijcanenec jun ti hua’ats yan i t’ujub jats ejtil an inic axi quin ats’anchi in cahuintal a Dios ani quim bats’u tin ichich c’al i culbeltalab. Tocat cum yab lej luputh ibibin tin ichich, jaxtam yab in ohuat belal. U t’apchinal im belomtal tam ca yajchiquiyat tin ebal abal im belamal in cahuintal a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","An iyalab axi ijcanenec jun ti hua’ats yan i q’uith jaye ejtil an inic axi quin ats’anchi in cahuintal a Dios, ani bel in aynal in cuete’ biyal le’nomtal. In xijc’ath tsalapnal an ricotalab ani an q’uijithtalab axi teje’ tsabal. Antsana’ u t’u’thithinchab in ichich c’al jahua’ teje’ tsabal, ma yabats u lejel ca t’ayat c’uajiy in cahuintal a Dios tin ichich. Jaxtam yab in t’ajal jahua’ alhua’ c’al a Dios ani pel ejtil i acan lab em axi yab im binal in hualil. ");
INSERT INTO husNT1971_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","An iyalab axi ijcanenec jun ti alhua’ an tsabal jaye ejtil an inic axi quin lej alhua’ ats’anchi in cahuintal a Dios c’al patal in ichich ani quin lej alhua’ penonoy tin ichich. Jats in aynanchal c’al i c’aya’talab, ani in lej t’ajal jahua’ alhua’ c’al a Dios. Pel ja ejtil i acan lab em ax in lej binal in hualil. ");
INSERT INTO husNT1971_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Ni jita’ yab in lec’utsiyal i tajablab abal ca paxq’uiyat o abal ca c’uajba tin alam i huaytalab tsey. Tocat in c’uajbal jun ti t’ec’at abal ca tala’ tajbayat alta ti al an ata. ");
INSERT INTO husNT1971_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Patal jahua’ xohue’ u tsincacayab c’al i jalpith cau, talbel ne’ets ca tala’ tejhua’methanchat ani ca tala’ lejquinchat an inicchic. ");
INSERT INTO husNT1971_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ca lej alhua’ bina’chic a xutsun c’al in cahuintal a Dios. Cum jitats in lej bats’umalits xe’ tin ichich, jats ne’ets ca pithane más in cahuintal a Dios. Jitats tocat eblim im bats’umalits, ne’ets ca tixc’anchat ax in tsalpayalac abal in cua’al tin ichich. ");
INSERT INTO husNT1971_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Taley ulits in mim ani in ebchalchic a Jesús jun ti c’uajat jaja’. Yab in ejtohualchic ca utey c’al a Jesús, cum lej q’uits’c’omath an mulcunel. ");
INSERT INTO husNT1971_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Tam olchinal a Jesús c’al jun axi taja’chic: ―Te c’uajatchic eleb a mim ani a ebchalchic in le’ ti tsu’u. ");
INSERT INTO husNT1971_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","A Jesús in toc’tsiy: ―Jitats quin ats’anchi ani quim putu c’al in cahuintal a Dios, ja’its axi pel u mim ani pel u ebchal. ");
INSERT INTO husNT1971_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Jun a q’uicha otsenequits a Jesús al jun i tan c’al in exobalilchic, ani in ucha’chic: ―Cu c’ale tihua’ ti jum poq’ue’ am pulic lejem. Ani ta c’alechic. ");
INSERT INTO husNT1971_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Tihua’ ne’ets a Jesús huayamath, biyat in exobalilchic im belthal an tan. Tameq’ui thayc’an jun jic’tohual jun i ic’ lej tsapic ti al an lejem. Ani ne’ets t’uchichilits an tan c’al an ja’, ma huachiquits ca uc’tsin. ");
INSERT INTO husNT1971_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Tam ejtsintha a Jesús c’al in exobalilchic ani uchan: ―Exobchix Exobchix, u uc’tsinalitschic. Tam ts’aquiy a Jesús in c’uiya’ an ic’ ani an ja’. Tameq’ui t’ajat cubiyits an ic’ ani yabats lanq’uil an ja’. ");
INSERT INTO husNT1971_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Tam a Jesús in conoy in exobalilchic: ―¿Jale’ yab tim belal? Ani jaja’chic tocat jiq’uel ani conóx antse’: ―¿Jita’ tam inic hualam jaja’ abal in ejtohual quin abatna’ an ic’ ani an ja’? ");
INSERT INTO husNT1971_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Taley ulits a Jesús ani c’al in exobalilchic jum poq’ue’ am pulic lejem ti tsabal Gadara axi jec’at ti Galilea. ");
INSERT INTO husNT1971_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Tam ti calejits a Jesús ti al an tan, utenchab c’al jun i inic Gadarajib axi ohuatits co’oyab c’al i at’ax teneclab. Xe’ets c’ot’ith ani u c’uajil al i jolimtalab tsemelom. Yabats u c’uajil al i ata. ");
INSERT INTO husNT1971_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Utey quin tsu’u a Jesús, in tuthu in c’ualal tin tamet. An at’ax teneclab tin ichich in thajanthal quin thajat ucha’ a Jesús antse’: ―Tata’its pel it Jesús ti Tsacamil a t’ec’at pulic Pay’lom Dios ti eb. ¿Jant’o tam eyaltalab a cua’al abal tiquin otsanchi? Nan tu lej canat uchal yab tiquin yajchiquiy. ");
INSERT INTO husNT1971_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Antsana’ in ulu an at’ax teneclab, cum uchanits c’al a Jesús abal ca calejits tin ichich nixe’ xi inic. Yan i calat tam tu tsapic yac’unal nixe’ xi inic c’al an at’ax, u huic’nal c’al an inicchic c’al i calaniyo pat’al tin c’ubac ani tin acan. Ani tocat in tala’ t’apiyal ani u ne’thab c’al an at’ax teneclab ca c’ale al i joltam. ");
INSERT INTO husNT1971_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Tam conoyab an at’ax teneclab c’al a Jesús: ―¿Jant’o tata’ a bij? Toc’tsin: ―Nana’ u bij Legión. Antsana’ ti toc’tsin an at’ax teneclab cum yan tin eb ti otsenec tin ichich nixe’ xi inic. ");
INSERT INTO husNT1971_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Tam nixe’ xi at’ax teneclabchic in lej canat ucha’ a Jesús abal yab ca aban ti al an luputh jol. ");
INSERT INTO husNT1971_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Taja’ hue’ utat xe’ets jun i pulic cuenel i olom ti ac’ul al i bolchal, ani lej canat uchan a Jesús max ca pithanchic an q’uij abal ca otsits tin inictal an olomlom. A Jesús in ucha’chic bel. ");
INSERT INTO husNT1971_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Tam calpanchic tin ichich nixe’ xi inic, ani otsits al nixe’ xi olomlom. Ani taley patal an olomchic jololol ti c’ale ti al i cotoblom, ani ta ijcan ti al am pulic lejem jun ti t’ajat uc’tsinchic. ");
INSERT INTO husNT1971_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Taley am beletnomchic c’al an olomlom c’ale athithil ti bichouchic ani ti alte’ q’uimath quin olna’ jahua’ in t’ajamal a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Taley c’ale am bichou quin tsu’u jant’o t’ajnenec c’al a Jesús. Ulitschic c’al a Jesús ani in tsu’u an inic canchithits an at’ax teneclabchic. Quetel utat c’al a Jesús ani c’ua’chimath, alhua’methachits in tsalap. Tam ti jiq’uey an inicchic. ");
INSERT INTO husNT1971_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Tam u olchinal jaja’chic c’al ax in oc’ox tsu’uchic jant’ini’ ti canchinenec nixe’ xi inic an at’ax teneclabchic. ");
INSERT INTO husNT1971_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Tam patal an Gadarajibchic in lej ucha’ a Jesús abal ca lejat tixc’an tin cuenchal cum lej jiq’uelchic. Tam otsits a Jesús al an tan ani ne’etsac ca c’ale. ");
INSERT INTO husNT1971_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ani lej canat conoyab c’al nixe’ xi inic axi canchinenec an at’ax teneclab max ca pithan an q’uij ca ts’at’ey c’al jaja’. Ani a Jesús tocat in ucha’: ");
INSERT INTO husNT1971_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―Quit c’ale ta q’uima’ ani ca t’iloxna’ patal jahua’ a Dios ti t’ajchamal. Tam ta c’ale ani in t’iloxnachical tim puhuel am bichou jahua’ t’ajchinenec c’al a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Tam ti huichits a Jesús tal jum poq’ue’ am pulic lejem, taja’ bats’uhuat c’al i culbeltalab cum aychame ca huichiy. ");
INSERT INTO husNT1971_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Tam chich c’al a Jesús jun i inic im bij pel i Jairo axi pel i oc’lec tin tiyopanil an Israelchic. In tuthu in c’ualal, ani in lej canat ucha’ ca c’ale tin q’uima’. ");
INSERT INTO husNT1971_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","In cua’al in juncats ts’ic’achil ax in cua’al lajuj tsab i tamub, ani talec’. Tam c’ale a Jesús, ani cum lej ts’at’enchab c’al yantalam i inic lej q’uits’c’omath ne’ets. ");
INSERT INTO husNT1971_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ani c’uajat ti al nixe’ xi cuenel jun i uxum ax in cua’al lajuj tsab i tamub yab u tajlunal ti ya’ul ta its’. In tala’ pacumalits an tumin ax in cua’alac c’al yantalam i ilalix, ani c’al ni jun yab ejtohuat ca jeltha. ");
INSERT INTO husNT1971_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Utey tin cux a Jesús ani in tacchi in toltomil, ani tameq’ui t’ithpanits in xits’al. ");
INSERT INTO husNT1971_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Tam a Jesús in conoy: ―¿Jita’ tin tacchi u toltomil? Ani patal jaja’chic in ulu yab jaja’. Tam a Pedro ani in at abathualechic in ucha’ a Jesús: ―Exobchix, ti lej pac’amnath q’uits’c’omayal an mulcunel ani a conoyale jita’ ti tacchi a toltomil. ");
INSERT INTO husNT1971_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","A Jesús in ulu: ―Hua’ats jita’ tin tacchi u toltomil, cum u exla’its tu lej ichich abal hua’ats jita’ jelthame c’al nana’ u tsap. ");
INSERT INTO husNT1971_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Tam chich ma t’elelel in inictal nixe’ xi uxum, cum in tsalpayal abal ne’ets ca exlajits abal jaja’its ax in tacchamal in toltomil a Jesús. In tuthu in c’ualal tin tamet a Jesús. In olchi an chubaxtalab an mulcunel jale’ tin tacchamal in toltomil a Jesús ani jant’ini’ ti jelthame tameq’ui. ");
INSERT INTO husNT1971_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Tam uchan an uxum c’al a Jesús: ―Mimlab, nan tu jeltha’ cum tim belamalits. Quit c’ale c’al a ichich ts’aclalathits. ");
INSERT INTO husNT1971_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Tam tu cahue a Jesús c’al an ts’at’elchic, ulits jita’ tal ma tin q’uima’ a Jairo quin tauna’ a Jairo. Uchan: ―Cum tihua’ tsemetsits a ts’ic’achil, yabats ca ucha’ an Exobchix ca c’ale quin jeltha’. ");
INSERT INTO husNT1971_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Tam ti a Jesús in ats’a’ antsana’ uchan a Jairo, tam jaja’ in ucha’ jaye: ―Yab quit jiq’uey c’al jahua’ it uchan, tocat ca lej bela’ ani ne’ets tu jelthanchi a ts’ic’achil. ");
INSERT INTO husNT1971_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ulitschic tin q’uima’ a Jairo, ani tamna’ a Jesús expith in jila’ ca otsits a Pedro, ani a Jacobo, ani a Juan, ani in tata ani in mim an ts’ic’ach. ");
INSERT INTO husNT1971_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ani patal axi muthat al an ata in thajat uc’nanchal an tsemelom ts’ic’ach. Tam uchanchic c’al a Jesús: ―Yabats quit uq’uinchic, cum yab tsemenec an ts’ic’ach. U huayal expith. ");
INSERT INTO husNT1971_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","C’al axe’ xi cau jahua’ in ulu a Jesús, tocat u tilibnath te’nal axi muthatchic cum in tso’obits abal chubax tsemenequits an ts’ic’ach. ");
INSERT INTO husNT1971_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Tam a Jesús in yac’uchi in c’ubac an ts’ic’ach ani in tsapic ucha’: ―Ts’ic’ach, quit ts’aquiy. ");
INSERT INTO husNT1971_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Tameq’ui ts’acpan ejthachits. Ani tam a Jesús in ulu ca pijchin an ts’ic’ach. ");
INSERT INTO husNT1971_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","In lej jic’pal in tata ani in mim an ts’ic’ach abal ejtha. Tam uchan jaja’chic c’al a Jesús abal ni jita’ yab quin olchi abal jaja’ in ejthamal an tsemelom ts’ic’ach. ");
INSERT INTO husNT1971_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","A Jesús in tamcuy axi lajuj tsab in exobalilchic, ani im pitha’chic i eyaltalab abal ti canchix c’al i at’ax teneclab ani ti jelthom c’al an ya’ulchic. ");
INSERT INTO husNT1971_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ne’ets quin aba’chic quin olnanchi an inicchic an alhua’ cau jant’ini’ tin t’ajal a Dios ti Ts’ale, ani jaye quin jeltha’ an ya’ulchic. ");
INSERT INTO husNT1971_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","In ucha’chic: ―Quit c’alechic naptal. Yab ca ne’tha’ i cuayablab, ni i morral, ni i pan, ni i tumin. Ca ne’tha’ expith i toltom ax a ca’quimits. ");
INSERT INTO husNT1971_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Al an ata jun ti quit bats’uhuat, tats quit junini’ c’uajiy ma tam ti ne’etsits quit cale al nixe’ xi bichou. ");
INSERT INTO husNT1971_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Max jun i bichou yab ti bats’uhual, tam quit tixc’an taja’. Am pojoth jahuats ca tha’u ta acan al nixe’ xi bichou, ca tininiy tam ne’ets quit tixc’an. Antsana’ ta ca t’aja’chic abal quin alhua’ tso’obna’ an inicchic taja’ abal yab alhua’ in t’ajamal cum im pojcanchamal in cahuintal a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Tam ta c’ale in exobalilchic a Jesús, xe’ets tsa’bibil tim patal am bichouchic in olnal an alhua’ cau ani in jelthal an ya’ulchic. ");
INSERT INTO husNT1971_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Aba ani’ olchinenec a Herodes in labith t’ajbilchic a Jesús, yab in tequeth exla’ jita’ jaja’. Cum talchic i inic in ulal abal a Jesús pel a Juan pujax axi tsemenecac ani xo’ ejthachits. ");
INSERT INTO husNT1971_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Q’ue’atchic in ulu abal pel a Elías axi caulome c’al a Dios ti jayq’ui’ ani xo’ huichits. Q’ue’atchic in ulu abal a Jesús pel q’ue’at i biyal caulome c’al a Dios axi xo’ ejthachits. ");
INSERT INTO husNT1971_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Tam in ulu a Herodes: ―Nana’its ax u aba’ an cau ca muts’inchat in oc’ a Juan. ¿Ani jita’ hualam axe’ xi inic ax in olchinal in t’ajbil? Ani a Herodes in lej lubal quin tsu’u a Jesús abal quin tequeth exla’. ");
INSERT INTO husNT1971_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Jun a q’uicha huichits an abathualechic ani in t’ilchi a Jesús jahua’ in t’ajamalchic. Tam a Jesús in ne’tha’chic al jun i c’uajattalab pil utat ti bichou Betsaida. ");
INSERT INTO husNT1971_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Cum in tso’obna’its am bichou abal tihua’ ne’ets a Jesús, c’alechic yan ca ts’at’ey c’al jaja’. A Jesús im bats’uchic ani in olnanchal jant’ini’ tin t’ajal a Dios ti Ts’ale. Jaye in jelthal i ya’ulchic. ");
INSERT INTO husNT1971_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Taley otscanits a q’uicha, ani uteychic axi lajuj tsab an abathuale quin ucha’ a Jesús: ―Ca ucha’ an mulcunel ca c’ale ti al i bichouchic ani ti al i q’uimathlomchic axi utat abal quin aliy ju’ta ca coyots ani ju’ta ca c’aputs. Teje’ yab hua’ats jant’o quin c’apuchic. ");
INSERT INTO husNT1971_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Tam a Jesús in ucha’chic: ―Tata’chic ca pijchi an mulcunel. Toc’tsin jaja’chic: ―Expith teje’ i cua’al bo’ i pan ani tsab i to’ol. Expith max cu c’ale qui ts’ay’chi jant’o quin c’apu patal axe’ xi pulic mulcunel. ");
INSERT INTO husNT1971_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ajith expith an inic pel i bo’ mil. Tam a Jesús in ucha’ in exobalilchic: ―Ca ucha’ an mulcunel ca buxcan ti cuenel ti cuenelchic tsab inic c’al lajuj. ");
INSERT INTO husNT1971_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ani antsana’ ti buxcan tim patalchic. ");
INSERT INTO husNT1971_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Tam a Jesús im bats’u axi bo’ i pan ani axi tsab i to’ol. Tam in met’al ti eb ani im pitha’ i c’ac’namal yan c’al a Dios. Taley in mu’u ani im pitha’ in exobalilchic quin huat’banchi an mulcunel. ");
INSERT INTO husNT1971_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ani patal an mulcunel c’aputs ani ajhuejits. Taley in exobalilchic a Jesús in thaya’ an jilc’omach ma lajuj tsab i t’ocnal t’uchichithits. ");
INSERT INTO husNT1971_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Jun a q’uicha exom ti ol a Jesús, ani hue’ utat ti c’uajat in exobalilchic. Tam ti talits ti ol in conoyalchic: ―¿Jant’ini’ hualam tin olnal an inicchic c’al u ey nana’? ");
INSERT INTO husNT1971_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Toc’tsin jaja’chic: ―Talchic in ulal abal tata’ pel it Juan pujax. Talchic in ulal abal pel it Elías, ani hua’ats talchic in ulal abal pel it biyal caulome c’al a Dios axi xo’ ejthame. ");
INSERT INTO husNT1971_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Tam a Jesús in conoyalechic: ―¿Ani tata’chic jant’ini’ tin exlanchal u ey? Tam toc’tsin a Pedro: ―Tata’its ojni’ pel it Cristo ax it bijithits ne’ets quit aban c’al a Dios quit chich. ");
INSERT INTO husNT1971_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Tam a Jesús in lej uluth ucha’ in exobalilchic yab quin olchi jita’ max jaja’its pel a Cristo. ");
INSERT INTO husNT1971_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Jaye in uchayechic: ―Nana’ tin Juntal patal an inicchic im bijchithits quin lej yajchiquiyat ani quim pojca c’al an yejtselabchic Israel ani c’al an oc’lec pale’chic ani c’al axi exobchixchic c’al an ts’ejcath cau binath c’al a Moisés. Ne’ets quin tsemtha ani oxchilab q’uicha ne’ets quin ejtha. ");
INSERT INTO husNT1971_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ani in uchaye patal axi muthat taja’chic: ―Quin t’ajat jilcachiquiy in cuete’ culbetal jitats in le’ ca ts’at’ey c’al nana’. Aba ani’ max ca yajchiquiyat c’al an inicchic ani ma ca le’na ca tsemtha, bel chuthel chuthel tiquin ts’at’enchi. ");
INSERT INTO husNT1971_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Jitats in le’ expith quin t’aja’ in cuete’ culbetal, jats ne’ets ca q’uibey. Jitats quim bina’ tim ba’ c’al tu ebal nana’, jats ne’ets ca jec’ontha. ");
INSERT INTO husNT1971_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ni jant’o ti exbath max an inic quin tala’ c’alna’ jahua’ teje’ tsabal ani quin q’uiba’its in ejattal. ");
INSERT INTO husNT1971_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Jitats tiquin tithenanchi u bij ani u cahuintal c’al an inicchic, nana’ ne’ets cu tithena’ nixe’ xi inic tam nan quin huichiy cu t’aja’ tin lej Ts’ale. Nana’ tin Juntal patal an inicchic ne’ets quim puhuethanchat u bij c’al u Tata ti eb tam quin huichiy junax c’al an t’ocat ángelchic. ");
INSERT INTO husNT1971_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Lej chubax nan tu uchalchic abal hua’ats axi tata’chic yab ne’ets quit thubat tsemets, biyat ma tiquin tsu’u in c’uajatits tin lej Ts’ale. ");
INSERT INTO husNT1971_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ma huaxic a q’uicha tam tin ulumalits a Jesús nixe’ xi cau, tam ti c’athiy al i oc’ bolchal ca olon. In ne’tha’ a Pedro ani a Jacobo ani a Juan. ");
INSERT INTO husNT1971_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Taja’ tam ti exom ti ol a Jesús, tsu’tab hue’ jalc’uthits lej ts’umimil in hual. In toltomil lej thacninil ani lej maq’uiq’uil. ");
INSERT INTO husNT1971_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Tameq’ui tu tejhua’mel a Moisés ani a Elías ti t’ilom c’al a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","In t’iloxnalchic jant’ini’ ne’ets ca yajchiquiyat ani ca tsemtha a Jesús ti Jerusalén cum antsana’ ti bijchithits. Taja’ lej tajajal c’al in ts’alat tajax a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Aba ani’ lej ts’ebat a Pedro ani a Jacobo ani a Juan, tam tin lej lamc’a’its in hual in tsu’u lej ts’umimil a Jesús ani axi tsab i inic c’al jaja’. ");
INSERT INTO husNT1971_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ani tam tu tixc’analits taja’ a Moisés ani a Elías, tamna’ a Pedro in ucha’ a Jesús: ―Exobchix, tequeth alhua’ abal xo’ teje’ u junat c’uajatchic huahua’. Qui ts’ejca’ ox i pathel ata, jun abal tata’, ani jun abal a Moisés, ani jun abal Elías. Antsana’ tin ulu a Pedro, cum jun jic’tohual yab in tso’bim jant’o quin más ulu. ");
INSERT INTO husNT1971_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Tam ti cahue a Pedro, tam ti pa’iy jun i mule’ i tocou ti eb c’al ti paxq’uiq’uiyatchic. Ani lej jiq’uelchic tam tin tsu’tal antsana’. ");
INSERT INTO husNT1971_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ani al nixe’ xi tocou in ats’a’chic u cau a Dios antse’: ―Axe’ ja’its pel u ichich hual Tsacamil. Jats jaja’ ca ats’anchichic in cahuintal. ");
INSERT INTO husNT1971_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Tam ti talits nixe’ xi cau, tam a Pedro ani a Jacobo ani a Juan in tsu’u expith jilc’on a Jesús. Xant’ojits a Moisés ani a Elías. Ani jaja’chic yab in olchal jita’ jahua’ antsana’ in tsu’umal. ");
INSERT INTO husNT1971_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Aytalab q’uicha pa’iy al am bolchal a Jesús junax c’al axi ox in exobalilchic, ani ba’ am bel u aychab c’al yantalam i inic. ");
INSERT INTO husNT1971_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ani jun i inic taja’ in tsapic ucha’ a Jesús: ―Exobchix, tiquin t’ajchi jun i alhua’talab ca met’a’ u juncats cuitolil. ");
INSERT INTO husNT1971_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","In cua’al i at’ax teneclab c’al tu ets’ey ts’ebtsinthab ani c’al tu lej thajanthab. Tam ta ca ts’ebtsinthabits, u bititil in ijil. ");
INSERT INTO husNT1971_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","U lej ucha’ a exobalilchic tiquin canchinchi an at’ax teneclab, ani yab in ejtouchic. ");
INSERT INTO husNT1971_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Tam toc’tsin a Jesús: ―Tata’chic ojni’ it lej q’uibts’oth a tsalap ani yab tim belal. In ohuat c’uajinec c’al tata’chic tu c’aya’nal, ani yabaye tim belamal. Tiquin chanchi an cuitol teje’. ");
INSERT INTO husNT1971_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Tam tu chi’thabits yac’uan junil, ma ijca tsabal ani ts’ebtsinthab. Tam a Jesús in ucha’ ca tixc’anits an at’ax teneclab c’al an cuitol, ani im binanchi c’al in tata tam jelthachits. ");
INSERT INTO husNT1971_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ani patalchic an inic taja’ in jic’pal abal antsana’ jelthame an cuitol c’al in lej tsap a Dios. Jaye in exobalilchic a Jesús jic’pax c’al nixe’ xi labith t’ajbilab ax in t’ajamal a Jesús. Ani uchanchic c’al jaja’: ");
INSERT INTO husNT1971_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―Ca lej otsits ta xutsun jahua’ ne’ets tu ucha’ ani yab ca uc’chiy. Nana’ tin Juntal patal an inicchic ne’ets quim bina tin c’ubac am pojcax inicchic. ");
INSERT INTO husNT1971_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ani jaja’chic yab in ejtiy nixe’ xi cau cum yabaye bijithits quin ejtiy, ani in ts’ejnalchic quin más conomichiquiye a Jesús abal ca lejquinchat an cau. ");
INSERT INTO husNT1971_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Tam in exobalilchic a Jesús in ts’i’quiy ti t’ilom abal jita’ c’al jaja’chic axi más huinat exbath in ey. ");
INSERT INTO husNT1971_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Cum a Jesús in exlanchits in tsalapchic, in c’uajba’ tin tametchic jun i tsacam. ");
INSERT INTO husNT1971_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Tamna’ in ucha’ in exobalilchic: ―Max jitats quim bats’u jun i tsacam ejtil axe’ c’al nana’ u bij, tin mac’uchith bats’uhualne. Ani max jitats tiquim bats’u nana’, jaye in mac’uchith bats’uhual u Tata ti eb ax tin abamal quin chich teje’ tsabal. Jitats c’al tata’chic axi quin más tsa’ca’ tim ba’ jats axi más huinat exbath in ey. ");
INSERT INTO husNT1971_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Tam uchan a Jesús c’al a Juan: ―Exobchix, huahua’ i tsu’u jun i inic ti canchixnanchal a bij c’al i at’ax teneclab, ani i c’anchi cum yab ts’at’enec c’al huahua’. ");
INSERT INTO husNT1971_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Uchan c’al a Jesús: ―In tomnalac yab ca c’anchi, cum jitats yab u tomolnax c’al huahua’ jats axi junat in ichich c’al huahua’ i ichich. ");
INSERT INTO husNT1971_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Tam u c’unelits in q’uijil a Jesús ca huichiy ti eb, ani in lej punu tin ichich abal ne’ets ca c’alets ti Jerusalén. ");
INSERT INTO husNT1971_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","In aba’ i olchixchic ca oc’chith c’ale tihua’ ti jun i bichou cuentalith ti Samaria abal quin t’ojojonchi jun ta ca ulits taja’. ");
INSERT INTO husNT1971_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ani an inicchic taja’ yab in le’ quim bats’u a Jesús, cum in tso’obits abal ne’ets ca c’ale ma tihua’ ti Jerusalén. ");
INSERT INTO husNT1971_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Cum an exobalchic a Jacobo ani a Juan in exla’its abal yab u le’nab a Jesús taja’, in conoyalchic: ―¿Ajatic, a le’ qui conchinchi c’al a Dios i c’amal abal ca ijcanchat nixe’ xi bichou ani ca t’ajat talabetha? Antsana’ ti lej jayq’ui’ an caulome Elías in conchinchi c’al a Dios i c’amalcua’. ");
INSERT INTO husNT1971_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Tam a Jesús tocat in met’al ani in c’uiyath ucha’chic: ―Tata’chic ma yab a tso’ob ju’ta ti che’nec a tsacunec tsalap. ");
INSERT INTO husNT1971_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Nana’ tin Juntal patal an inicchic in che’nec abal cu jec’ontha’ an inicchic, ani yab in che’nec cu talabetha’. Taley c’ale a Jesús c’al in exobalilchic ti pil i bichou. ");
INSERT INTO husNT1971_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Tam ti ne’ets ti belchic uchan a Jesús c’al jun i inic: ―Ajatic, nan ne’ets tu ts’at’enchi abal ju’tamaquits quit c’ale. ");
INSERT INTO husNT1971_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","A Jesús in toc’tsiy: ―An oc’chic in cua’al an jol ju’ta ta ca c’uajiy ani an ts’itsinchic in cua’al in c’util ju’ta ta ca coyots, ani nana’ tin Juntal patal an inicchic ma yab u cua’al i ata ju’ta tu cu mo’ca’ u oc’. ");
INSERT INTO husNT1971_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ani a Jesús in ucha’ junaque axi c’uajat jaye taja’: ―Tiquin ts’at’enchi. Ani toc’tsin jaja’: ―Ajatic, tiquin aychi ma ca tsemets u tata ani cu joliyits, tam tiq’uele ne’ets tu ts’at’enchi. ");
INSERT INTO husNT1971_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","A Jesús in toc’tsiy: ―Ca jila’ ca joliyat an tsemelomchic c’al axi yab ejat c’al nana’ u bij, ani tata’ ma xohue’ quit c’alets ca olna’ jant’ini’ tin t’ajal a Dios ti Ts’ale. ");
INSERT INTO husNT1971_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Tam uchan a Jesús c’al q’ue’at i inic taja’: ―Ajatic, nan ne’ets tu ts’at’enchi, expith tiquin aychi ne’ets quin c’ale cu olchi ax tu q’uima’ abal ne’ets tu ts’at’enchi. ");
INSERT INTO husNT1971_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ani uchan c’al a Jesús: ―Yab alhua’ max an xalum tsabal ca huenc’on quin met’a’ tin cux tam in aycom an yunta, ani yab alhua’ max an inic ax in jilchamalits a Dios quin t’aja’ ti Ts’ale tin ichich talbel quin met’a’ tin cux ani quin le’na’ junil im biyal xe’tsintal. ");
INSERT INTO husNT1971_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Taley an Ajatic in tacuyal jaye ox inic c’al lajuj i inic abal quin aba’ tsab tin eb quin oc’chith tsa’biy tim patal am bichouchic ani an cuenchalabchic jun ti jaja’ ne’ets talbel. ");
INSERT INTO husNT1971_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","In ucha’chic: ―Lej chubax jant’ini’ max hua’ats yan i huay’ ca c’ojohuat, antsana’ hua’ats yan i inicchic axi ts’ejcathits abal tiquim bela’ nana’. Ani jant’ini’ tam hua’ats lej hue’ an c’ojolchic, antsana’ hua’ats lej hue’ jita’ tiquin olnanchi u bij c’al an inicchic. Jant’ini’ an thabal huay’ in abal jita’ ti c’ojol, antsana’ ca conchi a Dios abal quin abayechic jita’ tiquin olnanchi u bij. ");
INSERT INTO husNT1971_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ani xo’ tata’chic ne’ets quit c’ale tiquin olnanchi u bij, ani ne’ets ca tamu i inicchic ax u othnax ejtil i pathum ax u othnax c’al an corderochic. ");
INSERT INTO husNT1971_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Quit c’alechic naptal. Yab ca ne’tha’ i morral, ni i tumin, ni i pajab. Cum lej exbath u t’ojlabil ma yab quit lej ohuey tit tsapnethom ti bel. ");
INSERT INTO husNT1971_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","An ata axi ca tsa’biy ca tsapnetha’ axi taja’chic ani ca ucha’ abal a le’ abal ca coythanchat in ichich c’al im bij a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Jaja’chic ne’ets ti tabatnanchi a cahuintal max pel i alhua’ q’uimath, ani max i tocat ne’ets ti hualbanchi. ");
INSERT INTO husNT1971_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Quit jilc’onchic al juncats i ata, ani tats ta ca c’apu ani ca uts’a’ jahuaquitsq’ui quit pithan. Cum tata’chic pel tu t’ojnalil, in tomnal quit pijchin. ");
INSERT INTO husNT1971_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Jun ti quit alhua’ bats’uhuat al jun i bichou ca c’apu jant’ots quit pithan. ");
INSERT INTO husNT1971_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ca jeltha’ an ya’ulchic taja’ ani ca olchichic abal hue’its ta tal a Dios quin t’aja’ ti lej Ts’ale teje’ tsabal. ");
INSERT INTO husNT1971_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Max quit ulits ti al i bichou ani yab quit alhua’ bats’uhuat ani yab quit ats’anchat a olnomtal, tam expith quit tixc’an. Tocat ca ucha’ an inicchic axi taja’: ");
INSERT INTO husNT1971_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Ne’ets qui tininiy am pojoth ax i tha’u ti acan ta bichohuil. Antsana’ ta ca tso’obna’chic abal a pojcanchamalits in cahuintal a Dios. Ca lej tso’obna’ abal hue’its ta tal a Dios quin t’aja’ ti lej Ts’ale teje’ tsabal. Antsana’ ca ucha’chic. ");
INSERT INTO husNT1971_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nan tu uchalchic abal nixe’ xi inicchic ne’ets ca c’athpich yajchiquiyat tam quim baju an q’uicha ca ts’ejca c’al a Dios. Ma an Sodomajibchic axi ti biyal yab ne’ets ca c’athpich yajchiquiyat jant’ini’ jaja’chic axi yab ti bats’uhualchic. ");
INSERT INTO husNT1971_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Ts’ejhuantal axi c’uajatchic ti bichou Corazín ani axi ti bichou Betsaida cum ne’ets ca yajchiquiyat. Max ti biyal u t’ajamalac ti bichou Tiro ani ti bichou Sidón an labith t’ajbilabchic axi xo’ nan u t’ajamal ti Corazín ani ti Betsaida, jaja’chic jic’tsonenecac c’al in hualab ani huenc’onenecac c’al a Dios. In ca’iyamalaquits i toltom axi ts’ejcath c’al i thapup ani in majuyamalaquits tim ba’ c’al i joltay’ ti tsu’bixtalab abal jic’tsonenequits c’al in hualab ani huenc’onenequits c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ti al an q’uicha tam ca ts’ejcachic c’al a Dios ne’ets ca c’athpich yajchiquiyatchic axi xo’ u c’uajil ti Corazín ani ti Betsaida, ani axi ti biyal c’uajiy ti bichou Tiro ani ti bichou Sidón yab antsana’ ne’ets ca c’athpich yajchiquiyat. ");
INSERT INTO husNT1971_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ani axi xo’ c’uajatchic ti Capernaum yab ne’ets ca otsits ti eb, tocat ne’ets ca jolohuat ti al an tamtsemla. ");
INSERT INTO husNT1971_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Jitats quin ats’anchi in cahuintal u abathualejil, nana’ tin mac’uchith ats’alne. Jitats quim pojca’ u abathualejil, nana’ tin mac’uchith pojcalne. Ani jitats tiquim pojca’ nana’, in mac’uchith pojcal jaye a Dios ax tin aba’ teje’ tsabal. ");
INSERT INTO husNT1971_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Huichits axi ox inic c’al lajuj an abathualechic lej culbel, in ucha’ an Ajatic: ―Ajatic, ma i canchamal i at’ax teneclab c’al a bij. ");
INSERT INTO husNT1971_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Uchanchic c’al a Jesús: ―Lej chubax jahua’ a ulal, cum u tsu’u ti eb ejtil max jolohuat eleb an oc’ox teneclab jun athic ejtil in athic an ley. ");
INSERT INTO husNT1971_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Nan tu pithamalits i tsaplabchic abal max ca q’uets’a’ i tsan ani i thiniy yab quit othna ta anam t’u’ul. Nan tu pithamalits i tsaplabchic abal ca tala’ ata’ an teneclab. ");
INSERT INTO husNT1971_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Yab quit culbechic expith cum a ejtohual ca canchi i at’ax teneclab, quit lej c’athpich culbe cum thuchathits a bij ti al an u tihua’ ti eb jun ti a Dios in thuchal im bij in tsacamilchic. ");
INSERT INTO husNT1971_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Lej jum putat culbethanchab in ichich a Jesús c’al an Espíritu Santo, ani ol. In ulu: ―Nan tu puhuethanchal a bij, Tata ti eb, cum it thabal c’al an eb ani c’al an tsabal. A tsinc’onchamal a tsalap an inicchic ax in tsalpayal tim ba’ abal pel i c’athpich tsalpath ani huit’om, ani a tejhua’methanchamal axi tsa’at in ichich ejtil i tsacam. Ojni’ Tata ti eb, antsana’ ta t’ajamal cum pel a culbetal. ");
INSERT INTO husNT1971_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Tam a Jesús in ucha’ in exobalilchic: U Tata ti eb tin jilchamal tu c’ubac patal jahua’ hua’ats ti eb ani ti tsabal. Nana’its pel tin Tsacamil a Dios ani ni jita’ yab in ejtohual tiquin lej exla’ nana’ jant’ini’ u Tata ti eb expith tin lej exlalits. Ani ni jita’ yab in ejtohual quin lej exla’ u Tata ti eb jant’ini’ nana’ expith u lej exlalits. Expith jitats nan cu le’na’ cu tejhua’methanchi in ey u Tata ti eb, jats ne’ets ti lej exlom c’al jaja’. ");
INSERT INTO husNT1971_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Tam a Jesús in lej met’al in exobalilchic ani in uchaye jaja’chic expith: ―Tata’chic it lej lablinchithits cum nan tu t’ajchamal i labith t’ajbilab ta lej tsu’ux hual. ");
INSERT INTO husNT1971_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Nan tu uchalchic abal ti jayq’ui’ lej yan i caulome c’al a Dios ani yan i ts’ale in lej le’ac max quin tsu’uchic jaye an labith t’ajbilab axi xo’ u t’ajal, ani yab in tsu’umalchic. In lej le’ac max quin ats’a’chic jaye an cau jahua’ tata’chic xo’ a ats’amalits, ani yab in ats’amalchic. ");
INSERT INTO husNT1971_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","C’ale jun axi exobchix c’al an ts’ejcath cau binath c’al a Moisés quin tacchiquiy a Jesús. In conoy: ―¿Exobchix, jant’o u yejenchal cu t’aja’ abal quin it ejatliyat abal ets’ey? ");
INSERT INTO husNT1971_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","A Jesús in toc’tsiy: ―¿Jant’o tam uchbixtalab hua’ats thuchath ti al an ts’ejcath cau binath c’al a Moisés? ¿Jant’ini’ ti utha’ xe’ ta ejtiyal? ");
INSERT INTO husNT1971_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Toc’tsin jaja’: ―Cu lej jum putat c’anitha’cua’ u Pay’lom Diosil c’al patal u ichich, ani c’al patal u ejattal, ani c’al patal u tsap, ani c’al patal u tsalap. Jaye cu c’anitha’ u at inic jant’ini’ tu c’anithal tu ba’cua’. ");
INSERT INTO husNT1971_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Tam toc’tsin a Jesús: ―Lej chubax jahua’ a toc’tsiyamal. Max ca putu c’al jahua’ a ulumal ne’ets quit it ejatliyat abal ets’ey. ");
INSERT INTO husNT1971_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Cum nixe’ xi exobchix in le’ quin t’aja’ abal yab ca tithebetha max yab im putumal c’al nixe’ xi uchbixtalab, jaxtam in conoyale a Jesús: ―¿Jita’ pel u at inic cu c’anitha’? ");
INSERT INTO husNT1971_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Tam a Jesús in toc’tsiy: ―Jun i inic tal ti Jerusalén ne’ets ti Jericó. Ani ti bel tats tin tamu i cue’chic, ma tixc’anchatits in toltomil. Lej huat’ath ti cuathan, ma jat’hua’ tsemenequits ti jilan. ");
INSERT INTO husNT1971_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Taley tal jun i pale’ in tsu’u mo’ol, tocat in toniy ani yab huat’ey utat. ");
INSERT INTO husNT1971_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Talbel tal jaye junaque i inic axi pel i levita ax u tolmix ti al an tiyopan, ani jaja’ jayetseq’ui yab in t’ajchi i alhua’talab. ");
INSERT INTO husNT1971_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Taley tal jaye al nixe’ xi bel jun i Samariajib, ani jaja’ ojni’ in tsu’u ani in yajnanchi an ts’ejhuantal ti mo’ol. ");
INSERT INTO husNT1971_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Utey ani in ilaliy c’al i aceite ani c’al i vino, ani in huic’chi c’al i toltom jun ti lej c’oloth. Ani im pumba’ tim pun ani in ne’tha’ ma jun ti ca coyots. Tats ti beletnanchat. ");
INSERT INTO husNT1971_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Aytalab q’uicha ne’ets ca c’ale an Samariajib. In caltha’ tsab i tumin denario ani im pitha’ an thabal ata. In ucha’: Tiquim beletnanchi nixe’ xi inic, ani tam quin huichiy nana’ ne’ets tu huichbanchiye max ca pacuye más a tuminal. ");
INSERT INTO husNT1971_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","¿Nixe’ xi ox i inic jahua’ a tsalpayal axi lej c’anithom c’al an c’uathnel inic? ");
INSERT INTO husNT1971_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Toc’tsin nixe’ xi exobchix: ―Pel c’al ax ti yajnanchat ani t’ajchin an alhua’talab. Tam uchan c’al a Jesús: ―Quit c’alets ani ca tala’ c’anitha’chic a at inic tata’ jaye. ");
INSERT INTO husNT1971_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Taley c’ale a Jesús ti jun i bichou, ulits ani bats’uhuat tin q’uima’ jun i uxum im bij Marta. ");
INSERT INTO husNT1971_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","C’uajat taja’ jaye a María an uxum ebchalab c’al a Marta. Ani a María jats u buxcanal utat tin acan a Jesús abal quin ats’anchi an cau jahua’ quin olna’. ");
INSERT INTO husNT1971_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","A Marta iba, tocat u lej t’ojlinal c’al yan i t’ojlab. Taley utey a Marta in ucha’ a Jesús: ―¿Ajatic, yab a t’ajal ti cuenta abal u ebchal tin jilchamal cu tala’ t’aja’ an t’ojlab cuetem? Ca ucha’ tiquin tolminchi. ");
INSERT INTO husNT1971_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","A Jesús in toc’tsiy: ―Marta Marta, tata’ ojni’ tocat it lej tsalpax ani it t’e’pith c’al yan i tsalap. ");
INSERT INTO husNT1971_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Expith hua’ats juncats i tsalap axi lej huinat alhua’. Jats tiquin ats’anchi u cahuintal. Jats xe’ ax in tacuyamal a María, ani jahua’ im penamalits tin ichich yab jita’ ta ca tixc’anchat. ");
INSERT INTO husNT1971_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Jun a q’uicha talits ti ol a Jesús, ani taley uchan c’al jun in exobalil: ―Ajatic, tucu exobchi tu ol jant’ini’ a Juan pujax in exobchi in exobalilchic ti ol. ");
INSERT INTO husNT1971_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Uchan c’al a Jesús: ―Tam it ol ca ulu antse’: I Tata ti eb i c’ac’nanchal a bij. Quit chich ca t’aja’ tit lej Ts’ale teje’ tsabal. Quin t’ajchi jaye an inicchic a culbetal teje’ tsabal jant’ini’ tu lej t’ajnal a culbetal tihua’ ti eb. ");
INSERT INTO husNT1971_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Tucu pithanchi qui c’apu jant’ots i yejenchal axe’ xa q’uicha. ");
INSERT INTO husNT1971_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Tucu paculanchi i hualab cum i paculanchal jitats tucu t’ajchi i hualabtalab. Tucu lotocna’ abal yab cu c’ale jun ti cu hualbin. Tucu jec’ontha’ c’al an teneclab. ");
INSERT INTO husNT1971_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","A Jesús in uchaye in exobalilchic: ―Ca t’aja’ ti cuenta max jun tata’chic quit c’ale ts’ejel acal tin q’uima’ a ja’ub ca conchi matith i pan. It ultsits ani a uchalac antse’: Ja’ub, tiquin matinchi ox i pan. ");
INSERT INTO husNT1971_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Taleleq’ui ti ulits u ja’ub tu q’uima’ ani yab jant’o tu cu pijchicua’. ");
INSERT INTO husNT1971_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ani jaja’ ti toc’tsiyalac antse’: Yab tiquin it’ixbetha’, cum maputhits an hui’leb ani huahua’ c’al i tsacamilchic u cuatsenequits tu huayal. Yab u ejtohual quin ts’aquiy tu pitha’ jant’ocua’. ");
INSERT INTO husNT1971_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Nan tu uchalchic abal max yab ca ts’aquiy ti pitha’ abal jaja’ pel a ja’ub, bel ne’ets ca ts’aquiy ti pitha’ patal jahua’ ca yejenchi max tocat it huilq’uith t’ayat conchix. ");
INSERT INTO husNT1971_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Antsana’ nan tu uchalchic abal max jant’o ca lej t’ayat conchi c’al a Dios, jaja’ ne’ets ti pitha’. Ani jant’ots a aliyal, jaja’ ne’ets ti tolminchi ca ela’. Ani max ca tauna’, jaja’ ne’ets ti toc’tsiy. ");
INSERT INTO husNT1971_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Jitats u conchix ne’ets ca pithan. Jitats u alim ne’ets ca tolminchat quin ela’. Jitats u taunom ne’ets ca toc’tsiyat. ");
INSERT INTO husNT1971_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Max a tsacamil ti conchal i pan yab ne’ets ca pitha’ i t’ujub. Max ti conchal i to’ol yab ne’ets ca pitha’ i tsan. ");
INSERT INTO husNT1971_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Max ti conchal i thac’choc’ yab ne’ets ca pitha’ i thiniy. ");
INSERT INTO husNT1971_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Aba ma yab it lej alhua’chic, bel a exlal ca pitha’ a tsacamil jahua’ alhua’. Ani más i Tata ti eb axi lej huinat alhua’ ne’ets quim pitha’ an Espíritu Santo jitats ta ca conchin. ");
INSERT INTO husNT1971_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","A Jesús in canchal jun i inic an at’ax teneclab c’al ti mo’bethame. Tam ti canchinits, tam tin huit’alits ti cau. Ani lej jic’pax an inicchic c’al jahua’ antsana’ t’ajchinenec nixe’ xi inic. ");
INSERT INTO husNT1971_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Aba ani’ jic’paxchic, bel hua’ats talchic i inic taja’ ax in ulu: ―Axe’ xi inic in calthal an at’ax teneclab expith cum pithnenec i eyaltalab c’al an ts’ale at’ax teneclab a Beelzebú. ");
INSERT INTO husNT1971_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Q’ue’atchic i inic taja’ in le’ quin tacchiquiy a Jesús, in ucha’ quin t’aja’ i labith t’ajbilab ti tsu’bixtalab max chubax in cua’al in tsap c’al a Dios ti eb. ");
INSERT INTO husNT1971_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Cum a Jesús in lej exlanchalits in tsalap, in toc’tsiychic antse’: ―Max i bichou ca lehuáxin ani ca cuete’ pejéxin, ne’ets ca talabetha. Jaye max ca pejéxin i q’uimathchic ani ca buc’láxin, ne’ets ca talabetha. ");
INSERT INTO husNT1971_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ani max a Satanás quin tomolna’ ani quin caltha’ in at teneclab tin ichich an inic, yabats ne’ets ca ohuey in tsap ti abatnom tin ichich i inic. Antsana’ nan tu uchalchic cum a ulumalitschic abal nan im pithnenec c’al a Beelzebú i eyaltalab tin calthom c’al i at’ax teneclab. ");
INSERT INTO husNT1971_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","¿Max chubaxac jahua’ a ulal, tam c’al jant’o tam eyaltalab tin calthal i at’ax teneclab a juntalchic? Jats tu tejhua’mel abal lejat q’uibts’othchic a tsalap. ");
INSERT INTO husNT1971_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Cum u calthal i at’ax teneclab expith c’al in lej tsap a Dios, jaxtam tejhua’ abal xo’ a Dios in t’ajalits ti Ts’ale ta tsu’ux hualchic. ");
INSERT INTO husNT1971_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Max i tsapic inic in cua’al yan jant’o c’al ti quin alhua’ beletna’ in q’uima’, yab jant’o ne’ets ca ejtohuat ca canchin tin q’uima’. ");
INSERT INTO husNT1971_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Expith max ca chich jun axi lej c’athpich tsapic ani ca tala’ tixc’anchat am beletnomtalab, ma tamits ne’ets ca ata. Tam ne’ets ca ejtohuat ca canchin jahua’ in cua’al tin q’uima’. ");
INSERT INTO husNT1971_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Jitats yab junat in ichich c’al nan u ichich, pel i tomolnax c’al nana’. Jitats yab u ts’ot’c’óxlix c’al nana’ ani c’al an inicchic, pel i lehuáxlix. ");
INSERT INTO husNT1971_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Tam ca calejits an at’ax teneclab tin ichich an inic, u xe’ets ti alilil ju’tam ta ca coyots al i joltam. Max yab quin ela’ ne’ets quin tsalpay ca huichiy junil tin ichich an inic jun ti calnequits. ");
INSERT INTO husNT1971_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Tam huichits in tsu’chal in ichich nixe’ xi inic ejtil jun i ata axi lej alhua’ c’uet’ot’othits ani lej ts’ejcath alabel. ");
INSERT INTO husNT1971_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Tam ne’ets ca c’ale quin chi’tha’ buc in at at’ax teneclab axi lej c’athpich quithab. Tam axi huaxic u huichel ani u otsel tin ichich nixe’ xi inic ani más c’athpich quithabmethanchab. ");
INSERT INTO husNT1971_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Tam ti cahue a Jesús c’al axi taja’chic, tam ti thajat uchan c’al jun i uxum antse’: ―Ojni’ lej culbel an uxum axi c’al tit hua’tsin ani it yejthame. ");
INSERT INTO husNT1971_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ani a Jesús toc’tsin: ―Jitats quin ats’anchi ani quim putu c’al in cahuintal a Dios jats axi lej culbel. ");
INSERT INTO husNT1971_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ts’at’ate yan i inicchic c’al a Jesús, ani taunabe c’al jaja’ antse’: ―Cum pojcaxchic a ichich, jaxtam a le’ abal nan tu t’ajchiye i labith t’ajbilab ti tsu’bixtalab c’al u ey. Yab ne’ets cu t’aja’. Expith ca t’ila’chic jahua’ labith t’ajchinenec ti biyal in caulomejil a Dios Jonás. ");
INSERT INTO husNT1971_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Nix ti jayq’ui’ pel i tsu’bixtalab abal c’al an Nínivejibchic ti biyal, ani jahua’ ne’ets quin labith t’ajchine nana’ tin Juntal patal an inicchic jats tata’chic ca t’aja’ ti cuenta ti tsu’bixtalab c’al u ey. ");
INSERT INTO husNT1971_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Tam quim baju an q’uicha ca ts’ejca an inicchic c’al a Dios, tam ne’ets ca cubiy ti jolbix c’al tata’chic an uxum ts’ale ax ti Sabá. Jaja’ ti biyal ou chich c’al a Salomón quin ats’anchi in tsalpath cahuintal, ani nana’ u cahuintal lej c’athpich exbath yab ejtil in cahuintal a Salomón. ");
INSERT INTO husNT1971_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ani jaye an Nínivejibchic axi ti biyal ne’ets ca cubiy ti jolbix c’al tata’chic, cum jaja’chic jic’tsonenec c’al in hualab ani huenc’onenec c’al a Dios tam ti olnanchat in cahuintal a Dios c’al a Jonás. An cau axi nan u olnal lej c’athpich exbath yab ejtil ax in olnamal a Jonás, ani tata’chic xo’ ma yab tim belchamal. ");
INSERT INTO husNT1971_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Ni jita’ yab in tsinc’oyal i lec’utsith tajablab al i poc’te’, tocat in c’uajbal jun ti t’ec’at abal ca tajbanchat jitats c’uajat ti al an ata. ");
INSERT INTO husNT1971_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","C’al a hual a tsu’talchic an tajax. Max lubach a hual a ejtohual tiquin tajax tsu’u nana’ tin tajax a Dios, ani max yab lubach a hual iba. ");
INSERT INTO husNT1971_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ca lej t’aja’chic ti cuenta ca co’oy nana’ tin tajax a Dios ta ichich ani iba an yic’uax. ");
INSERT INTO husNT1971_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Max chubax in c’uajat ta ichich, ni hue’ yab ne’ets ca co’oy i yic’uax. Ani nana’ ne’ets tu tala’ tajbanchichic a tsalap ejtil max it lej tajbanchab c’al in tajax i tajablab. ");
INSERT INTO husNT1971_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Talits ti cau a Jesús, ani taley u caniyab c’al jun i fariseo ca c’alecua’ tin q’uima’ ti c’apul. Talbel ulits taja’, ani buxcan ba’ an mexa. ");
INSERT INTO husNT1971_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ani nixe’ an fariseo in t’ajal ti cuenta abal a Jesús ne’ets ti c’apul ani yab in oc’ox t’acacayamal in c’ubac jant’ini’ tin ujnamtal an Israelchic abal max ca tsu’tat ti t’ocat c’al a Dios, ani jats tu jic’pab. ");
INSERT INTO husNT1971_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Tam uchan c’al an Ajatic: ―Tata’chic fariseo it ejtil i uts’umtalab axi t’acathits eleb ani i talap axi expith t’acathits tin cux ani yab alta. Ta lej ichich hualim it jaylom ani it quithab. ");
INSERT INTO husNT1971_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","It lej macu’chic a tsalap. Yab a ejtiyalchic abal a Dios ax in ts’ejca’ an inic in c’athpich le’ t’oquethach in ichich an inic ani yab expith elebq’ui. ");
INSERT INTO husNT1971_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Max ca ts’ejhualiy jant’o ca t’aja’ c’al jum putat a ichich, ani tamna’ ne’ets quit exlanchat abal t’oquethachits a ichich. ");
INSERT INTO husNT1971_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","It lej ts’ejhuantal tata’chic fariseo c’al a eb c’ac’naxtal. A pithal a Dios jun i elbenax c’al tin cuenta an lajuj ani antsana’ a t’ajal jaye c’al an tijtson ani c’al patal an t’ayablab ts’ojol, ani jahua’ más exbath c’al a Dios yab ja a t’ajalchic. Pel a lej uchbil quit xe’tsin bolith ani quit c’anithomats ejtil a Dios c’anithom, ani yab expith ca pitha’ a Dios jun c’al an lajuj jahua’its a cua’al. ");
INSERT INTO husNT1971_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","It lej ts’ejhuantal tata’chic fariseo. Ti al an tiyopan a le’ quit buxcan jun tu buxcanal axi lej c’athpich pulic in ey an inic. A le’chic quit tsapnetha ti bel c’al yan i c’ac’naxtalab. ");
INSERT INTO husNT1971_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","It lej ts’ejhuantal tata’chic fariseo ani ax it exobchixchic c’al an ts’ejcath cau binath c’al a Moisés, cum it eb t’ocatq’ui expith. Ejtil it jolimtalab tsemelom ax yab u tsu’tab tin al c’al an inic. Taja’ u xe’ets eblim an inic ani yab in tsu’tal alta max hua’ats i c’atselomtalab. ");
INSERT INTO husNT1971_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Tam toc’tsiyat a Jesús c’al jun i exobchix c’al an ts’ejcath cau binath c’al a Moisés antse’: ―Exobchix, lej yajchic an cau jahua’ i ats’amal. ");
INSERT INTO husNT1971_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Toc’tsiyat c’al a Jesús: ―It lej ts’ejhuantal tata’chic ax it exobchix c’al an ts’ejcath cau binath c’al a Moisés. Ejtil i quitax ax in quitayal in at inic c’al i quitalab lej alchic, antsana’ tata’chic a t’ajchal an inicchic c’al a punc’uth exobchixtal lej alchic axi yab ejtohuab ca quitna. Ani ni jayq’ui’ ni hue’ yab it quitnax c’al a cuete’ exobchixtal. ");
INSERT INTO husNT1971_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","It lej ts’ejhuantalchic cum a ts’ejcanchal an jolimtalab jun ti jolith in caulomejilchic a Dios axi tsemthame c’al a biyal juntalchic. ");
INSERT INTO husNT1971_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Antsana’ a tejhua’methal abal a tsalapchic juncuth c’al a biyal juntal axi tsemthomats c’al i caulomechic. Jaja’chic tsemthomats ani tata’chic it ts’ejcanchix c’al an jolimtalab. ");
INSERT INTO husNT1971_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","A Dios in ulu i cau tin cuenta in tsemthomtal nixe’ xi inicchic antse’: Ne’ets cu abchi i caulomechic ani i abathualechic, ani talchic ne’ets ca tsemtha ani talchic ne’ets ca othna, in ulu a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","A Dios ne’ets ti t’ajchi tata’chic an ts’ejcaxtalab, cum jayetseq’ui pel a mac’uchith hualab in huac’lath xits’al in caulomejilchic a Dios axi tsemthame ma tam ti ts’i’quin ca xe’tsin teje’ tsabal. ");
INSERT INTO husNT1971_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Pel a mac’uchith hualabchic in huac’lath xits’al a Abel axi tsemtha ti biyal ani jaye in huac’lath xits’al a Zacarías ax a ite tsemthamal utat an ts’acnaxtalab tin cuenta an tiyopan. Jaxtam nan tu uchalchic ax it xo’ c’uajat teje’ tsabal, ne’ets ca bina’te i cuenta c’al a Dios c’al patal nixe’ xi huac’lath xits’lab. ");
INSERT INTO husNT1971_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","It lej ts’ejhuantal tata’chic ax it exobchix c’al an ts’ejcath cau binath c’al a Moisés, cum yab a tequeth exlanchalchic in tsalap a Dios ta ichich. Yab a exlanchal tata’chic, ani jaye yab a jilal quin exlanchi an inicchic ax in lej le’ quin exlanchi. ");
INSERT INTO husNT1971_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Tam lej tsacuy an fariseochic ani an exobchixchic c’al an ts’ejcath cau binath c’al a Moisés c’al jahua’ antsana’ in ulu a Jesús, ma in ts’i’quiy quin c’uiyath conomichiquiy c’al yan i cau. ");
INSERT INTO husNT1971_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","In lej t’ajchal ti cuentachic max a Jesús quin ulu i q’uibts’oth cau c’al quin ejtou quin jolbiy. ");
INSERT INTO husNT1971_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Lej tamcunale yan i mil i inicchic, ani lej q’uits’c’omanal ma q’uets’áxchic c’al in acan. Tam a Jesús in ucha’ in exobalilchic: ―Ca t’aja’chic ti cuenta yab quit c’ambiyat c’al an fariseochic, cum eb t’ocatq’ui ani in exobchixtal u tsinat t’ojnal ejtil an c’ac’chixtalab c’al an c’oye. ");
INSERT INTO husNT1971_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Jahua’ in tsinat t’ajal an inic ne’ets ca tala’ tejhua’methanchat pil a q’uicha, ani jahua’ in tsinat tsalpayal tin ichich ne’ets ca tso’obnanchat pil a q’uicha. ");
INSERT INTO husNT1971_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Jahua’ tata’chic a tsinat t’iloxnal ta cuetemtal ne’ets quit tala’ tso’obnanchat c’al an inicchic. Jahua’ a cue’ ulal alta ta q’uima’ c’al an hui’leb maputh ne’ets quit thajat t’iloxnanchat jun ti ca tala’ ats’an c’al patal an inicchic. ");
INSERT INTO husNT1971_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ja’ubchic, nan tu uchal yab ca ts’ejna’ a at inic, cum expith in ejtohual ti tsemthanchi a inictal ani expith ja. ");
INSERT INTO husNT1971_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Nan tu uchalchic ca ts’ejna’ a Dios, cum jaja’ in ejtohual ti tixc’anchi a ejattal ani jaye max ti jolou ti al am pulic tsemla. Ojni’ jaja’ jats ca ts’ejna’. ");
INSERT INTO husNT1971_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","An nujul in nujuhual bo’ i tsacam ts’itsin c’al tsab i tsacam tumin. Cum a Dios lej beletnom ni jayq’ui’ yab in uc’chiyal an tsacam ts’itsin. ");
INSERT INTO husNT1971_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ani jaja’ ti co’onchalits ajith tin junchictal a xi’il ta oc’. Cum a Dios lej beletnom, jaxtam yab ca ts’ejna’ jant’o quit t’ajchin c’al a at inic. Jaja’ ti tsu’tal a cua’al a lej c’athpich exbath ani yab ejtil an tsacam ts’itsin. ");
INSERT INTO husNT1971_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Patal jitats tiquin olnanchi u bij c’al in at inic, nana’ jaye ne’ets cu olnanchi im bij c’al an ángelchic axi tihua’ ti eb c’al a Dios. Nana’its pel tin Juntal patal an inicchic. ");
INSERT INTO husNT1971_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Jitats tiquin tsinc’onchi u bij c’al in at inic, nana’ jaye ne’ets cu tsinc’onchi im bij c’al an ángelchic tihua’ ti eb c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Jitats tiquin quithab cahuiliy nana’ tin Juntal patal an inicchic ne’ets ca ejtohuat ca paculanchat. Jitats quin quithab cahuiliy an Espíritu Santo yab ne’ets ca ejtohuat ca paculanchat. ");
INSERT INTO husNT1971_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Tam tit binathits quit ts’ejca c’al i ts’ejcom cau ax ti al an tiyopan ani jaye c’al i oc’lecchic, yab quit tsalpaxin tin cuenta jant’o ne’ets ca ucha’ o jant’ini’ ti ne’ets quit toc’tsin. ");
INSERT INTO husNT1971_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ma tameq’ui an Espíritu Santo ne’ets ti pitha’ an cau jant’o ca ulu. ");
INSERT INTO husNT1971_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Jun i inic axi taja’ al an mulcunel in ucha’ a Jesús: ―Exobchix, ca ucha’ u ebchal abal tiquim pitha’ jahua’ bijithits cu bats’u c’al an they jilchith c’alab. ");
INSERT INTO husNT1971_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Toc’tsin a Jesús: ―Pay’lom, yab u ey tin ts’ejcanchix ani tim buc’chix c’al tata’chic. ");
INSERT INTO husNT1971_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Uchanaye c’al a Jesús: ―Ca lej taja’ ti cuenta yab ca huat’ath c’a’inchi an c’alab axi teje’ tsabal, cum yab c’al ja ti ne’ets ca co’oy a ejattal it ejatlith c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Tam a Jesús in olna’ i jalpith cau antse’: ―C’uajatac jun i rico inic in cua’al lej yan i t’ayablab lej hualith. ");
INSERT INTO husNT1971_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Xe’ets in lej tsalpayal ju’ta ti quin tala’ thaya’ an hualilab, cum yab ne’ets quin tala’ ac’na’ an huilte’chic ax in cua’al. ");
INSERT INTO husNT1971_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Tam in cuete’ ulu tin ichich antse’: Ma xohue’ u exla’its jahua’ ne’ets cu t’aja’. Ne’ets cu ijca’ u huilte’ilchic ani cu ts’ejca’ axi más pulic. Tats ne’ets cu tala’ thaya’ an hualilab. ");
INSERT INTO husNT1971_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","C’al xi yantalom hualilab ne’ets cu huat’a’ yan i tamub coyolq’ui ani culbelq’ui. Ne’ets tin c’apupulq’ui ani ne’ets tin uts’uts’ulq’ui, in ulu. ");
INSERT INTO husNT1971_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ma tamna’ ojni’ tauna c’al a Dios antse’: Tata’ ojni’ it macu’ a tsalap, cum ne’ets quit tsemets axe’ xi acal. ¿Tam jita’ ne’ets quin tabatna’ ax a cua’al yan jant’o thayach? Antsana’ ti conoyat c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Pel i macu’ in tsalap jitats quin thaya’ yan jant’o jahua’ hua’ats teje’ tsabal quin cuete’ c’alna’q’ui ani ni jant’o tam c’alab yab in cua’al thayach tihua’ ti eb c’al a Dios, in ulu a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Taley a Jesús in ucha’ in exobalilchic: ―Jaxtam nan tu uchalchic yab quit xe’tsin tsalpopol c’al an c’apnel ani c’al an toltom. ");
INSERT INTO husNT1971_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","In exbath a ejattal lej c’athpich yab ejtil in exbath an c’apnel, ani in exbath a inictal lej c’athpich yab ejtil in exbath an toltom. ");
INSERT INTO husNT1971_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ca t’aja’ ti cuentachic an c’ojchic abal yab u om, ani yab u c’ojol, ani yab in thayal jant’o ti al an huilte’. Bel u c’apulchic, cum expith c’al a Dios u pijchab. A exbath tata’chic lej c’athpich yab ejtil in exbath an ts’itsin. ");
INSERT INTO husNT1971_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Aba ma ca lej xijc’ath luba’ ta ba’ quit t’ec’atme ts’ejel metro, ni abal jay yab ne’ets ca ejtou. ");
INSERT INTO husNT1971_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Max yab a ejtohualchic ca t’aja’ jahua’ yab lej q’uibat, jolat quit xe’tsin tsalpopol c’al jahua’ lej q’uibat. ");
INSERT INTO husNT1971_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ca t’aja’chic ti cuenta jant’ini’ tu puhuel an huits. Yab ja tin ebal abal u t’ojnal ani yab tin ebal max u huichalac abal quin ts’ejca’ tim ba’. Nan tu uchalchic abal an ts’ale Salomón c’al patal in ts’alat toltomil yab im baju in alabental ejtil an huits. ");
INSERT INTO husNT1971_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","C’al a Dios jats tu ts’ejcanal an huits c’athpich alabel. Ti jun a q’uicha ejate ani ti junaque a q’uicha tsemenequits ani ca chican. Cum más a exbathchic c’al a Dios, más ne’ets ti pitha’chic an toltom. Tata’chic ojni’ yabaye a alhua’ belamalchic a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Yabats quit t’e’piplats c’al an c’apnel ani c’al an uts’nel. ");
INSERT INTO husNT1971_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Axi yab u exlom c’al a Dios jats axi xe’ets tsalpopol c’al jahua’ teje’ tsabal. Tata’chic yab antsana’ ta ca t’aja’, cum a cua’al a Tata ti eb ax in tso’obits patal jahua’ a yejenchal. ");
INSERT INTO husNT1971_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Expith ca junini’ jilchichic a Dios quin t’aja’ ti Ts’ale ta ichich, ani tamna’ jaja’ ne’ets ti pitha’chic patal jahua’ ca yejenchi teje’ tsabal. ");
INSERT INTO husNT1971_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Tata’chic ejtil it tsacam cuenel i oveja axi tu c’alchic nana’. Yab quit jiq’ueychic, cum a Tata ti eb in le’ quin t’aja’ ti Ts’ale ta ichich. ");
INSERT INTO husNT1971_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ca nuju jahua’ a cua’al ani ca pitha’ an tumin an ts’ejhuantal. Ca t’aja’chic alhua’ abal ca co’oy a c’al tihua’ ti eb c’al a Dios. Jahua’ tihua’ hua’ats ti eb ojni’ yab ne’ets ca ejtohuat ca cue’eyat c’al i cue’ ani yab ne’ets ca ejtohuat ca c’apts’uhuat c’al i thum. ");
INSERT INTO husNT1971_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","An c’alab axi tata’chic a tsu’talits lej c’athpich huinat alhua’, jats ne’ets ca junini’ tsalapna’ ta ichich. ");
INSERT INTO husNT1971_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Quit c’uajiychic lej ts’ejcacath a tsalap ejtil axi pel i beletnanchix ata. ");
INSERT INTO husNT1971_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","In junini’ aychal ca huichiy in amu axi c’alnec quin tsu’u an tomquintalab. Tocat ca ulcan ani ca tauna, thubatq’ui ne’ets quin japchi an hui’leb. ");
INSERT INTO husNT1971_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Max im putuhualits c’al in uchbil ne’ets ca lej culbe tam ca huichiy in amu. Lej chubax nan tu uchalchic abal an amu jaja’ lej putat ne’ets quin ts’ejcacanchi an c’apnel am beletnanchix ata. ");
INSERT INTO husNT1971_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ojni’ ne’ets ca lej culbe am beletnanchix ata max ets’ey lej ts’ejcacathits tam ca ulcan in amu, max ts’ejel acal o max tam chuthelaquits. ");
INSERT INTO husNT1971_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ca t’aja’ ti cuentachic jun i thabal ata axi otsanchat in q’uima’ ani cue’chinenec. Max in tso’obnamalac jahua’ tam hora ne’etsac ca chich an cue’, yabac huayamath ani yab cue’chinenecac. ");
INSERT INTO husNT1971_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Tata’chic quit c’uajiy lej ts’ejcacath, cum nana’ tin Juntal patal an inicchic ne’ets quin chi’pin lej jun athic tam yabchic a t’ilt’om. ");
INSERT INTO husNT1971_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Tam conoyab a Jesús c’al a Pedro: ―¿Ajatic, tu olchamal axe’ xi jalpith cau expith huahua’ ax tu exobalil o a olchamal jaye patal axi muthat teje’? ");
INSERT INTO husNT1971_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Toc’tsin an Ajatic: ―An t’ojnal axi pututh ani tsalpath jats axi ne’ets ca punuhuat ti abatnanchix c’al xi q’ue’at in t’ojnalil an amulab, ma quin ulu jahua’ tam hora ca pijchinchat. ");
INSERT INTO husNT1971_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Tam ca chich in amu, tam ne’ets ca lej culbe nixe’ xi abatnanchix max im putuhual c’al in uchbil. ");
INSERT INTO husNT1971_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Lej chubax nan tu uchalchic abal jats jaja’ axi ne’ets ca punuhuat ti ts’ale abatnanchix c’al patal jahua’ in cua’al in amu. ");
INSERT INTO husNT1971_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ani max yab pututh ne’ets quin tsalpay abal in amu ne’ets ca ohuey abal ca chich, ani hualam tocat ne’ets quin othna’ ax in abatnalchic ani an cuthinelchic. Tocat ca xe’tsin c’apupulq’ui ani uts’uts’ulq’ui, ma ne’ets ca uts’alin. ");
INSERT INTO husNT1971_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Max antsana’ ca elchin c’al in amu tam ca chi’pin jun athic tam yab u aychab, tam ne’ets ca c’athpich yajchiquiyat ani ca c’uajiy jolbibith ejtil axi q’ue’atchic an inicchic yab pututh c’al in uchbil. ");
INSERT INTO husNT1971_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","An abatnanchix ax in exlanchits in culbetal in amu ani yab in t’ajchamal, jats ne’ets ca c’athpich yajchiquiyat. ");
INSERT INTO husNT1971_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Axi yab in exlanchi, huachic ne’ets ca yajchiquiyat max yab in t’ajchamal. Jitats pithnenec hue’ yan in uchbil, antsana’ ti quim bina’ an cuenta hue’ yan. Jitats pithnenec lej yan in uchbil, antsana’ ti quim bina’ an cuenta lej yan. ");
INSERT INTO husNT1971_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","In che’nec teje’ tsabal ani u ts’at’elilchic ne’ets ca lej yajchiquiyat ejtil max ca huat’ba al i c’amal, ani u lej le’ max xohue’ exomaquits. ");
INSERT INTO husNT1971_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Pel u uchbil cu lej yajchicna’ne an yajchictalab, ani jats c’al tu junini’ co’oyab u ichich ma ta ca tala’ putunits nixe’ xi yajchictalab. ");
INSERT INTO husNT1971_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Yab ca q’uibts’oth tsalpaychic max an inic ne’ets ca c’uajiychic jun ejet expith tin ebal abal nan in che’nec teje’ tsabal. Tu uchalchic abal ne’ets ca tomolnáxin tin ebal nana’ u ey. ");
INSERT INTO husNT1971_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ma xohue’its i q’uimath ne’ets ca cuete’ tomolnáxin jun c’al xi jun. Jun ti hua’ats bo’ i ejattalab hualam ox quin tomolna’ axi tsab. ");
INSERT INTO husNT1971_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ne’ets ca tomolna i cuitol c’al in tata ani i tatalab c’al in cuitolil. Ne’ets ca tomolna i ts’ic’ach c’al in mim ani i mimlab c’al in ts’ic’achil. Ne’ets ca tomolna i al’iblab ts’ic’ach c’al in uxum iyam ani i uxum iyamlab c’al in al’ib ts’ic’ach. ");
INSERT INTO husNT1971_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Uchane an mulcunel c’al a Jesús: ―Tam ca tsu’uchic an tocou ti otsel q’uicha, tamna’ a ulalchic abal ne’ets ca ulitsits an ab tihua’, ani chubax u ulel. ");
INSERT INTO husNT1971_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Tam ca juchun an ic’ tal alal, tamna’ a ulalchic abal ne’ets ca lej cubiyits an c’ac’al, ani chubax u cubel. ");
INSERT INTO husNT1971_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Tata’chic ojni’ it lej eb tsalpathq’ui ani yab it lejat tsalpath ta ejattal. A tso’obchic an tsu’bixtalab c’al an ab ani c’al an c’ac’al, ani ma ni hue’ yab a tso’ob an tsu’bixtalab axi nan u t’ajal c’al in tsap a Dios ti eb. ");
INSERT INTO husNT1971_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","¿Jale’ yab a tso’obnalitschic quit ts’ejcacan c’al a ichich c’al a Dios? ");
INSERT INTO husNT1971_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ca t’aja’chic ti cuenta max it junax ne’ets c’al a tomolnaxil abal quit ts’ejcanchat i cau c’al an oc’lecchic, in tomnalac ca cuete’ ts’ejca’chic an cau ti bel. Tam jaja’ yab ne’ets ti ne’tha’ c’al an ts’ejcom cau, ani yab ne’ets quit baliyat al an huic’axte’. ");
INSERT INTO husNT1971_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Nan tu uchalchic abal max yab ca cuete’ ts’ejca’ c’al a tomolnaxil an cau ani max quit baliyat al an huic’axte’, yab ne’ets quit thubat caltha ma ta ca quithat jalbiyits jahua’ it uchanits ca jalbiy c’al an ts’ejcom cau. ");
INSERT INTO husNT1971_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","C’uajatchic taja’ talchic i inic c’al a Jesús in olchal jant’o t’ajchinenec talchic i Galileajib c’al in soldadojilchic a Pilato. Tsemthamecua’chic jaja’ biyat in tsemthal i co’nelchic axi ne’ets ca bina ti ts’acchixtalab ti al an tiyopan. ");
INSERT INTO husNT1971_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","A Jesús in ucha’chic: ―Hualam a tsalpayalchic abal nixe’chic tsemthame abal cum lej c’athpich hualbith ani yab ejtil in juntalchic tim bichohuil. ");
INSERT INTO husNT1971_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nan tu uchalchic abal yab antsana’. Ani ta patal tata’chic max yab quit jic’tson c’al a hualab ani yab quit huenc’on c’al a Dios, ne’ets ca q’uiba’ a ejattal. ");
INSERT INTO husNT1971_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Hualam a tsalpayalchic abal axi lajuj huaxic tsemthame tam ti ijcanchat an torre ti Siloé abal jaja’chic lej c’athpich hualbith ani yab ejtil axi q’ue’atchic ax u c’uajil ti Jerusalén. ");
INSERT INTO husNT1971_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nan tu uchalchic abal yab antsana’. Ani ta patal tata’chic max yab quit jic’tson c’al a hualab ani yab quit huenc’on c’al a Dios, ne’ets ca q’uiba’ a ejattal. ");
INSERT INTO husNT1971_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Tam a Jesús in olchichic i jalpith cau antse’: ―Jun i inic in cua’al jun i te’ higuera t’ayathits tin tsabalil. C’ale quin tsu’u max in cua’alits in hualil, ani yab jant’o in elchi. ");
INSERT INTO husNT1971_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Tam uchan am beletnanchix tsabal c’al an thabal antse’: Oxits i tamub in che’nec cu aliy i hualilab al axe’ xi te’ higuera ani ni jayq’ui’ yab u elchal. Ca t’aq’uiy jun t’ajat abal yabats quin jolat xuts’q’uiy an tsabal. ");
INSERT INTO husNT1971_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Toc’tsiyat an thabal tsabal: Ca jilaye axe’ xi tamub ani nan ne’ets cu xalchi an tsabal ani ne’ets cu jolchi i elich anam abal ca t’u’un an tsabal. ");
INSERT INTO husNT1971_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Lequitsq’ui max ca hualin tamna’, ani max i tam cu t’aq’uiy jun t’ajat. ");
INSERT INTO husNT1971_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Jun i sábado c’uajat a Jesús ti exobchix tin tiyopanil an Israelchic. ");
INSERT INTO husNT1971_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ani c’uajat taja’ jun i uxum ax in cua’al lajuj huaxic tamub ti cutulmethanchame in cux tin ebal abal co’oyab c’al i at’ax teneclab, ani ni hue’ yab in ejtohual ca lujcun. ");
INSERT INTO husNT1971_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","A Jesús in tsu’u ani in ucha’: ―Uxum, nan ne’ets tu jeltha’ c’al an yau’lats. ");
INSERT INTO husNT1971_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Tam a Jesús im punchi in c’ubac tin inictal, ani tameq’ui t’ajat lujcunits in cux. Ani tamna’ an uxum im puhuethanchal im bij a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Tam tsacuy an oc’lec c’al nixe’ xi tiyopan, cum jelthomats a Jesús tam sábado. In ucha’ axi muthat taja’chic: ―Hua’ats acac a q’uicha cu t’ojon. Jahuaquitsq’ui tam q’uicha nixe’chic alhua’ quit chich abal quit jeltha, ani expith yab quit chich tam sábado. ");
INSERT INTO husNT1971_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Tam toc’tsiyat c’al an Ajatic: ―It eb t’ocatq’uichic. ¿Max huic’ath a hueyaxil o a burrojil tam sábado hualam max yab ne’ets ca ne’tha’ ti uts’al c’al an ja’? ");
INSERT INTO husNT1971_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Auxe’ max yab in tomnamal cu jeltha’ tam sábado nixe’ xi uxum. Pel jaja’ in at xits’al a Abraham jant’ini’ tata’chic, ani lajuj huaxic tamubits ti ya’unthame c’al a Satanás. ");
INSERT INTO husNT1971_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Tam tin uluhuits antsana’ a Jesús, tam patal in tomolnaxil tithebelchic. Ani aba ani’, bel patal am bichou lej culbel c’al an labith t’ajbilab ax in t’ajal a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Tam a Jesús in ulu: ―Ne’ets tu olchichic i jalpith cau jant’ini’ tin t’ajal a Dios ti Ts’ale. ");
INSERT INTO husNT1971_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Jun i inic quin t’aya’ i iyalab mostaza tin tsabalil. Tocat ca cale ani ca puhueyits, tamna’ an ts’itsinchic u che’el quin ts’ejca’ in c’util ba’chic in c’ue’el ejtil max pel i te’. ");
INSERT INTO husNT1971_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","¿C’al jant’oye más i t’ipchixtalab cu ulu a Dios in t’ajal ti Ts’ale? ");
INSERT INTO husNT1971_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Pel ejtil i c’ac’chixtalab axi quin xaluhuits an uxum al an c’oye, c’al ne’ets ca tala’ puhuethajits tim puhuel an c’oye. ");
INSERT INTO husNT1971_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","A Jesús ne’ets in aynale am bel ne’ets ti Jerusalén, ani u otsele ti exobchix alchic i tsacam bichou ani alchic i cuenchalab. ");
INSERT INTO husNT1971_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ani conoyab c’al jun i inic ti bel: ―¿Ajatic, hua’ats expith tsab ox i inic ax u jec’onthab c’al in hualab? Toc’tsin a Jesús in ucha’: ");
INSERT INTO husNT1971_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―Ejtil i inic ax in lej lubal ca otsits al i xuyat otsnab, antsana’ ta ca t’aja’ abal max quit jec’ontha. Yan ne’ets quin lej le’na’ ca jec’ontha, ani yab ne’ets quin ejtou. ");
INSERT INTO husNT1971_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ca t’aja’ ti cuenta max i thabal ata quin mapuyits an hui’leb tin q’uima’, ani tata’chic it c’uajat eleb ani a le’ quit otsits. Ne’ets ca ucha’: Pay’lom, tucu japchi an hui’leb. Ani jaja’ expith ne’ets ti toc’tsiychic: Nan yab tu exlalchic ani yab u tso’ob ma ju’tam it tal. ");
INSERT INTO husNT1971_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ani tata’chic ne’ets quit toc’tsin: Cum i tu exlalits cum u junat c’apumath ani u junat uts’lamath, ani jaye it exobchixin al i bichohuil. ");
INSERT INTO husNT1971_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ani jaja’ ne’ets ti toc’tsiychic: Tu lejat ucha’its abal yab tu exlalchic ani yab u tso’ob ma ju’tam it tal. Quit t’ajat tixc’anchic c’al nana’, cum pel it pojcax. Antsana’ ne’ets ti ucha’chic an thabal ata. ");
INSERT INTO husNT1971_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Tam ca tsu’uchic a Abraham ani a Isaac ani a Jacob ani patal an caulomechic otsenequits jun ti a Dios in t’ajal ti lej Ts’ale ani tata’chic tocat it jilc’onenequits eleb, ne’ets quit uq’uinchic ani ne’ets ca huech’ech’latschic a camab c’al an lej yajchictalab. ");
INSERT INTO husNT1971_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ne’ets ca chich an inicchic yantalam ma tim puhuel an tsabal, ani ne’ets ca buxcan ti c’apul tin mexajil a Dios tam jaja’ quin t’aja’ ti lej Ts’ale. ");
INSERT INTO husNT1971_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Al nixe’ xa q’uicha ne’ets ca ajiyat ti pulic in ey c’al a Dios yan i inic axi xo’ tsipilin in ey teje’ tsabal, ani ne’ets ca ajiyat ti tsipilin in ey yan i inic axi xo’ pulic in ey teje’ tsabal. ");
INSERT INTO husNT1971_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Nixe’ xa q’uicha ulitse i fariseochic c’al a Jesús quin ucha’: ―Quit tixc’an teje’, cum a Herodes in le’ ti tsemtha’. ");
INSERT INTO husNT1971_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","A Jesús in toc’tsiychic: ―A Herodes pel i c’ambixma’. Quit c’ale ani ca ucha’: Xo’ u calthal an at’ax teneclabchic ani u jelthal an ya’ulchic, ani ne’ets cu t’ajaye antsana’ calam ani ma oxchilab q’uicha. Ma tam ne’ets cu tala’its u t’ojlabil. ");
INSERT INTO husNT1971_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Pel u uchbil antsana’ quin t’ojone axe’ xa q’uichachic. Taley ne’ets quin ulits ti Jerusalén ani quin tsemtha taja’, cum tats expith ne’ets quin tsemtha tin caulome c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Tata’chic ojni’ ax it c’uajil ti Jerusalén it lej tsemthom c’al in caulomejilchic a Dios ani it lej cui’ix c’al i t’ujub c’al in abathualejilchic a Dios. Ejtil i pita’ ax in tamcuyal in tsacam t’am quin c’aniy tin alcam in ocob, antsana’ yan i calat nan u lej le’ac tu tamcuy ani tu c’aniy, ani tocat yab a le’acchic. ");
INSERT INTO husNT1971_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ca t’aja’ ti cuentachic abal lejat jolat ne’ets ca jilc’on a tiyopanil. Nan tu uchalchic abal lej chubax yabats ne’ets tiquin tsu’u ma biyat tiquin olna’ antse’: Jaja’ jats axi tal abath c’al a Dios, ani jats axi qui puhuethanchi im bij. ");
INSERT INTO husNT1971_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","C’ale ti c’apul jun i sábado a Jesús tin q’uima’ i oc’lec fariseo, ani taja’ lej tsapic met’nal a Jesús c’al axi q’ue’at i fariseochic jant’o quin t’aja’. ");
INSERT INTO husNT1971_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","C’uajat jaye jun i inic ax in cua’al i yau’lats pel i mal. ");
INSERT INTO husNT1971_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Tam a Jesús in conoy axi taja’chic an exobchix c’al an ts’ejcath cau binath c’al a Moisés ani an fariseochic: ―¿Jant’o a ulalchic tu jilal an ts’ejcath cau qui jeltha’ an ya’ul tam sábado? ");
INSERT INTO husNT1971_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ani ma lejat yab ela’ toc’tsinchic. Tam a Jesús in yac’uchi in c’ubac an ya’ul ani in jeltha’its. Tam in ucha’ ca c’alets. ");
INSERT INTO husNT1971_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Taley tam a Jesús in ucha’ an fariseochic: ―Auxe’ max jita’ tata’chic ca ijcan a burrojil o a hueyaxil al i mom tam sábado, ani hualam yab ne’ets ca caltha’. ");
INSERT INTO husNT1971_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Yab in ejtohualchic ca toc’tsin ni c’al jahua’. ");
INSERT INTO husNT1971_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","A Jesús in tsu’tal axi chichits ti c’apul c’al an fariseo abal u buxcanalchic ti mexa jun ti bijithits ca buxcan axi lej huinat exbath in ey. Tam in ucha’chic: ");
INSERT INTO husNT1971_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―Max jitats ti caniy tit c’apul c’al i ts’alat c’apuxtalab tin cuenta i tomquintalab yab quit buxcan jun ti bijithits ca buxcan axi lej huinat exbath in ey, cum hualam ne’ets ca ulitse jun axi más huinat exbath in ey axi bijithits ca buxcan taja’. ");
INSERT INTO husNT1971_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Tam ax ti canamal quit chich ne’ets ti ucha’ quit tixc’an abal ca buxcan axi lej bijith, ani tata’ ne’ets quit uchan quit buxcan c’al an alq’uith inicchic. Tam ojni’ ne’ets quit tithebe. ");
INSERT INTO husNT1971_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Tam quit c’ale c’al an ts’alat c’apuxtalab quit buxcan c’al an alq’uith inicchic, ani hualam ax ti canamal ne’ets ti ucha’, ja’ub quit chich quit buxcan teje’ jun ti bijithits ca buxcan axi lej huinat exbath in ey. Ani tam ojni’ ne’ets quit ajiyatitste tit lej exbath. ");
INSERT INTO husNT1971_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Cum antsana’its jitats quin t’aja’ lej pulic ne’ets ca tsa’ca, ani jitats quin tsa’ca’ tim ba’ ne’ets ca pulicmethanchat in ey c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Tam a Jesús in ucha’ an fariseo c’al axi ti caniyat ti c’apul: ―Tam ne’ets ca t’aja’ i c’apuxtalab yab ca caniy a ja’ub, ni a at ebchal, ni a at xits’al, ni a at q’uimath axi rico, cum in ejtohualchic ti huichbanchi. ");
INSERT INTO husNT1971_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Expith ca caniy an ts’ejhuantal, ani an tsambe, ani an c’uets’e’, ani an joc’tsi. ");
INSERT INTO husNT1971_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Aba ma jaja’chic yab ne’ets quin ejtou ti huichbanchi, bel ne’ets quit culbe cum a Dios ne’ets ti huichbanchi tam jaja’ quin ejtha’ am pututh inicchic. ");
INSERT INTO husNT1971_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Tam uchan a Jesús c’al jun i inic axi quetel ti mexa: ―Ne’ets ca lej culbe jitats ca buxcan ti c’apul ti eb tam a Dios quin t’aja’ ti lej Ts’ale. ");
INSERT INTO husNT1971_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Tam a Jesús in toc’tsiy: ―Jun i inic in caniy yantalam i inic ca chich ti c’apul tin q’uima’ c’al i ts’alat c’apuxtalab. ");
INSERT INTO husNT1971_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Cum ts’ejcacathits in cua’al an c’apnel, tocat in aba’ in t’ojnalil ca c’ale quin caniy axi bijithits ca chich. ");
INSERT INTO husNT1971_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ani patal jaja’chic tocat in ts’i’quiy quin huaynanchi jant’o. Jun in ulu, talele u ts’a’iy jun i pejach i tsabal ani u le’ quin c’ale cu tsu’u. Ca ucha’ a amu abal yab in ne’ets. ");
INSERT INTO husNT1971_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Junaque in ulu, talele u ts’a’iy bo’ i yunta i hueyax ani ne’ets quin c’ale cu t’ojontha’ max alhua’ ca t’ojon. Ca ucha’ a amu abal yab in ne’ets. ");
INSERT INTO husNT1971_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Q’ue’at in ulu, talele in tomquinenec ani jaxtam yab u ejtohual quin c’ale c’al an c’apuxtalabcua’. ");
INSERT INTO husNT1971_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Taley huichits an t’ojnal c’al in amu ani in tala’ olchi jant’ini’ ti uchnenec. Tam lej tsacuy an amu ani in ucha’ an t’ojnal: Thubat quit c’ale ti al am pulic belchic ti al am bichou ani jaye ti al an tsacam belchic ax tin hualchicte’lil am bichou, ani ca chi’tha’ ti c’apul an ts’ejhuantal, ani an tsambe, ani an c’uets’e’, ani an joc’tsi, in ulu an amulab. ");
INSERT INTO husNT1971_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Tam ta c’alets ti olchix, ani tam ti huichits an t’ojnal in ulu: Amu, u t’ajamal jahua’ tin uchamal ani bel hua’atse i jolat ju’ta ta ca buxcan i c’apulchic. ");
INSERT INTO husNT1971_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Tam toc’tsiyat an t’ojnal c’al in amu: Xo’ quit c’ale ti al i pulic alte’ bel ani jaye ti al i tsacam alte’ bel ca lej uluth ucha’ ca chichits jitats ca ela’ abal ca t’uchichits u q’uima’. ");
INSERT INTO husNT1971_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Nan tu uchal abal axi oc’ox bijithits ca chich ti c’apul, ni jun yab ne’ets quin c’apu an ts’alat c’apuxtalab ax u ts’ejcanchamal. ");
INSERT INTO husNT1971_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ne’ets ts’at’at yan i inicchic c’al a Jesús. Tam huilq’uin ani in ucha’chic: ");
INSERT INTO husNT1971_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―Yab in ejtohual ca ts’at’ey c’al nana’ jitats in c’athpich c’anithal in tata ani in mim, o in tomquil, o in tsacamilchic, o in ebchalchic, o in uxum ebchalchic, o in cuete’ le’nomtal. ");
INSERT INTO husNT1971_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Aniye jaye yab in ejtohual ca ts’at’ey c’al nana’ jitats yab ts’ejcacathits ca yajchiquiyat ani ma ca tsemtha c’al tu ebal nana’. ");
INSERT INTO husNT1971_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Max ne’ets ca ts’ejca’ i ata ca oc’ox tsalpay max a cua’alits an tumin abal ca tala’ ts’ejca’. ");
INSERT INTO husNT1971_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Max ca ts’ejca’ tocat in cub an ata ani yab ca ejtou ca tala’ ts’ejca’ an ata, tam tocat ne’ets quit tilibna. ");
INSERT INTO husNT1971_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Ne’ets quin ulu an tilibnax abal a tuju an ata ani yab a ejtou ca tala’ ts’ejca’ tim puhuel. ");
INSERT INTO husNT1971_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Jaye max i ts’ale ne’ets ca pejéxin c’al q’ue’at i ts’ale in tomnal quin oc’ox tsalpay max c’al lajuj mil i soldado in ejtohual quin ata’ an ts’ale ax in cua’al jun inic mil i soldado. ");
INSERT INTO husNT1971_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Max quin tsalpay yab ne’ets quin ejtou quin ata’, tam ne’ets quin abchi i caulome quin ucha’ an tomolnax ts’ale abal ca coyotsits c’al an cau ani yab ca pejéxin. ");
INSERT INTO husNT1971_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Antsana’its jitats c’al tata’chic yab it ts’ejcacathits ca tala’ jilcachiquiy jahua’ a cua’al, yab ne’ets ca ejtou quit ts’at’ey c’al nana’. ");
INSERT INTO husNT1971_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","An at’em in cua’al in huinat alhua’ ey tam yab tsamc’ac’ath. Max tsamc’ac’athits, yabats jant’o ti alhua’. ");
INSERT INTO husNT1971_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Tocat ne’ets ca lejat huac’la ejtil i amul, ani ma yab ne’ets ca tabatna ni c’al an tsabal ni c’al i t’ayablab. Jitats junat in ichich c’al nana’ u ichich, quin lej alhua’ bina’ in xutsun c’al axe’ xi cau. ");
INSERT INTO husNT1971_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Yantalam i bats’c’ul jalbixtalab tumin tin cuenta an gobierno ani axi exlath ti lej hualbith inicchic u che’el c’al a Jesús abal quin ats’anchi in cahuintal. ");
INSERT INTO husNT1971_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Jaxtam ti tsacul an fariseochic ani an exobchixchic c’al an ts’ejcath cau binath c’al a Moisés. In c’uiyath uluchic tin cuenta a Jesús antse’: ―Nixe’ xi inic im bats’uhual ani u junax c’apul c’al i hualbith inicchic. ");
INSERT INTO husNT1971_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Tam a Jesús in t’iloxnanchichic jun i jalpith cau antse’: ");
INSERT INTO husNT1971_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―¿Max a cua’al bo’ inic i oveja ani ca q’uibey jun jant’o ne’ets ca t’aja’? Auxe’ max yab i ne’ets ca jila’ axi tse’ inic c’al lajuj beleu biyat quit c’ale ca aliy axi jun q’uibenec ma tam ta ca ela’its. ");
INSERT INTO husNT1971_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ani tam ca ela’its ne’ets ca antha’ ta punuc’ c’al a ichich lej culbel. ");
INSERT INTO husNT1971_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Quit ultsits ta q’uima’ ne’ets ca tamcuy a ja’ubchic ani a at q’uimathchic ani ca ucha’: Cu junax culbejits cum te u ela’its an oveja axi q’uibenec juncats. ");
INSERT INTO husNT1971_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Antsana’ nan tu uchalchic abal lej c’athpich u junax culbel an ángelchic ti eb tam jun i hualbith inic ca jic’tson c’al in hualab ani ca huenc’on c’al a Dios, ani yab ejtil c’al tse’ inic c’al lajuj beleu i inic ax in q’uibts’oth tsalpayalq’ui pel i alhua’ inic ani yab in yejenchal ca jic’tson c’al in hualab ani ca huenc’on c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","¿Max jun i uxum in cua’al lajuj i tumin ani quin q’uiba’ jun jant’o ne’ets quin t’aja’? Auxe’ max yab i ne’ets quin lec’utsiy an tajablab ani quin tala’ c’uet’oy an ata ma tam quin ela’its. ");
INSERT INTO husNT1971_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ani tam quin ela’its ne’ets quin tamcuy in ja’ubchic ani in at q’uimathchic quin ucha’: Cu junax culbejits cum te u ela’its an tumin ax u q’uibamal. ");
INSERT INTO husNT1971_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Antsana’ nan tu uchalchic abal ne’ets ca c’athpich junax culbe an ángelchic tam jun i hualbith inic ca jic’tson c’al in hualab ani ca huenc’on c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","A Jesús in uchaye an fariseochic ani an exobchixchic c’al an ts’ejcath cau binath c’al a Moisés antse’: ―C’uajatac jun i inic ax in cua’al tsab in cuitolil. ");
INSERT INTO husNT1971_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Uchan c’al an talbel cuitol: Tata, tiquim pitha’ an c’alab jahua’ bijithits ne’ets tiquim pitha’. Tam in tata an cuitol in caltha’ an tumin ani im pitha’ axi tsab in cuitolil. ");
INSERT INTO husNT1971_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Tsab ox a q’uicha tam an talbel cuitol in tala’ tamcuy jahua’ in cua’al, ani ta c’ale al i pil bichou lej ou. Tats ti xe’tsitsil quithab pacucul c’al an tumin. ");
INSERT INTO husNT1971_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","In tala’ pacuhuits. Tam hua’tsin jun i pulic jayil al nixe’ xi bichou, ani lej c’a’il an cuitol. ");
INSERT INTO husNT1971_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Tam c’ale quin conoy i t’ojlab, ani pithan i t’ojlab ti beletnanchix c’al i olom. ");
INSERT INTO husNT1971_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Cum c’al ni jita’ yab u pithnal ti c’apul, ma in le’ac quin c’apu an tsamal axi ne’ets quim pijchixna’ c’al an olom. ");
INSERT INTO husNT1971_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Tam in tsalpachiquiyal: Axi yan i t’ojonchix tin q’uima’ u tata in cua’al yan jant’o quin c’apu ma hua’ats i jilc’omach, ani nana’ teje’ in tsemelits c’al an jayil. ");
INSERT INTO husNT1971_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ne’ets quin huichiy c’al u tata cu ucha’ abal in hualbinenequits c’al a Dios ani in hualbinenequits c’al jaja’. ");
INSERT INTO husNT1971_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Jaxtam yabats in tomnal tiquim bats’u ejtil max pel tin tsacamil, expith tiquim bats’u ejtil max pel tin t’ojnalil, cu ucha’. ");
INSERT INTO husNT1971_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Tamna’ ta c’ale an cuitol tin q’uima’ in tata. Tam ti ohue ti tal, tam ti tsu’tatits ani lej yajnanchat c’al in tata. Tam athlats in tata ani im bats’u an cuitol c’al i muts’uc’naxtalab ani c’al i ts’uts’baxtalab. ");
INSERT INTO husNT1971_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Tam an cuitol in ucha’ in tata: Tata, in hualbinenequits c’al a Dios ani in hualbinenequits c’al tata’. Yabats in tomnal tiquim bats’u ejtil max pel tin tsacamil. ");
INSERT INTO husNT1971_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Aba ani’ antsana’ in ulu an cuitol, bel in tata in ucha’ an t’ojnalchic: Ca thubat caltha’ an huinat alhua’ toltom ca alhua’ toltomiyat an cuitol. Ca punchin tin c’ubac jun i anillo ani ca cay’chin i pajablab. ");
INSERT INTO husNT1971_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ca chi’tha’chic an novillo axi alabel t’u’uthmethachits ani ca tsemtha’. Qui t’aja’ an ajib, cu ts’alat c’aputs. ");
INSERT INTO husNT1971_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Cum u cuitolil u tsalpay hualam max tsemetsits, ani iba cuchic cum xo’ te ulnec ejat. U tsalpay hualam max q’uibenequits, ani iba cuchic cum xo’ te c’uajat c’al huahua’, in ulu an tatalab. Tam in ts’i’quiychic quin t’aja’ an ajib. ");
INSERT INTO husNT1971_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Xe’etsnenec an oc’ox cuitol ti t’ojnal tin tsabalil in tata, ani xo’ u huichelits tin q’uima’. Tam ti utatits ne’ets ca ulits in ats’a’ an t’enelchic ani in tsu’u exom am bixom. ");
INSERT INTO husNT1971_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Tam in caniy ca chich jun i cuitol ani in conoy jant’o in t’ajalchic tihua’. ");
INSERT INTO husNT1971_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Uchan: In t’ajalchic an ajib cum huichits a ebchal. Cum in chi’thamal tim ba’ alhua’, jaxtam a tata in tsemthanchamal an novillo axi alabel t’u’uthmethachits. ");
INSERT INTO husNT1971_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Tam tsacuy an oc’ox cuitol, ma yab in le’ ca otsits tin q’uima’. Tam c’ale in tata abal quin lej ucha’ ca otsits. ");
INSERT INTO husNT1971_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","An cuitol tocat in ucha’ in tata: A tso’obits abal yanits i tamub nan tu t’ojonchamal a c’al, ani ma yab a le’ tiquim pitha’ jun i chivo abal cu t’aja’ an ajib c’al u ja’ubchic. Ani ni jayq’ui’ yab in jec’om c’al tata’. ");
INSERT INTO husNT1971_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Nixe’ xa cuitolil expith xe’tsitslats quithab pacucul c’al an tumin c’al i uxum, ani xo’ huichits ani a tsemthanchamal an novillo axi alabel t’u’uthmethachits. ");
INSERT INTO husNT1971_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Tam uchan an oc’ox cuitol c’al in tata: Cuitol, ets’ey it c’uajat c’al nana’ ani patal jahua’ u cua’al tu c’al nana’ pelits a c’alte. ");
INSERT INTO husNT1971_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","In tomnal qui t’aja’ an ajib ani cu lej culbe cum u tsalpay hualam max tsemetsits a ebchal, ani iba cuchic cum xo’ te ulnec ejat. U tsalpay hualam max q’uibenequits, ani iba cuchic cum xo’ te c’uajat c’al huahua’. ");
INSERT INTO husNT1971_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","A Jesús in uchaye in exobalilchic: ―C’uajatac jun i rico inic in cua’al jun i t’ojonthanchix tumin, ani olchinal abal jolat pacucunchab in tuminal. ");
INSERT INTO husNT1971_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Tam in caniy ca chich an t’ojonthanchix ani in ucha’: Tata’ ojni’ tin jolat pacucunchamal u tuminal. Tiquin huat’banchits an cuenta, cum yabats ne’ets tu jila’ tit t’ojonthanchix c’al u tuminal. ");
INSERT INTO husNT1971_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Tam in lej tsalpachical tin ichich: ¿Jant’o ne’ets cu t’aja’ cum yabats ne’ets quim pithan an t’ojlab ax u t’ajalac? Yab in tsapnel cu t’ojonchi an tsabal ani in tithebel cu conchi i ts’ejhualixtalab. ");
INSERT INTO husNT1971_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Xo’ u tso’obits jant’o ne’ets cu t’aja’ abal cu co’oy u ja’ub jita’ tiquim bats’u tin q’uima’. ");
INSERT INTO husNT1971_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Tam in caniy ca chich ti junchic ax u nenchix c’al in amujac. Axi oc’ox chich in conoy: ¿Jant’o a nenchal u amujac? ");
INSERT INTO husNT1971_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Toc’tsin: U nenchal bo’ inic i tambor i aceite. Tam uchan: Te c’uajat an cuenta. Thubat quit buxcan te ca thucha’ expith tsab inic c’al lajuj a nenchal. ");
INSERT INTO husNT1971_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Tam conoyat junaque i nenchix: ¿Ani tata’ jant’o a nenchal u amujac? Toc’tsin: Bo’ inic i doble an lab em jats u nenchal. Tam uchan: Te c’uajat an cuenta. Ca ts’ejca’ tse’ inic i doble jats a nenchal. ");
INSERT INTO husNT1971_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Aba ani’ yab pututh c’al jahua’ antsana’ in t’ajamal nixe’ xi inic t’ojonthanchixac tumin, bel in amujac in ulu abal lej tsalpath jahua’ in t’ajamal c’al an nenchixchic. Antsana’ más lej tsalpath axi yab exlom c’al a Dios c’al jahua’ hua’ats teje’ tsabal, ani yab tsalpath axi exlomchic c’al a Dios c’al jahua’ hua’ats ti eb c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Nan tu uchalchic abal jahua’ a cua’al teje’ ti al an hualab c’ay’lal ca alhua’ eyentha’ abal ca tolmiy an inicchic, ani tam ta ca taley jahua’ hua’ats teje’ tsabal ne’ets ca co’oy a ja’ub c’al quit junax otsits ti eb quit c’uajiy abal ets’ey. ");
INSERT INTO husNT1971_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Jitats quin alhua’ eyentha’ ax in cua’alits hue’, max ca pithan yan jayetseq’ui ne’ets quin alhua’ eyentha’. Jitats yab quin alhua’ eyentha’ ax in cua’alits hue’, max ca pithan yan jayetseq’ui yab ne’ets quin alhua’ eyentha’. ");
INSERT INTO husNT1971_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Max yab ca alhua’ eyentha’ jahua’ a Dios ti pithal ti al an hualab c’ay’lal, yab ne’ets ti pitha’ jahua’ lej huinat alhua’ ti eb. ");
INSERT INTO husNT1971_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Max yab ca alhua’ beletna’ jahua’ a Dios ti pithal ca beletna’, yab ne’ets ti pitha’ jahua’ bijithits ne’ets ti pitha’ ta lej chubax c’al. ");
INSERT INTO husNT1971_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Yab a ejtohualchic ca co’oy tsab i amulab, cum ne’ets ca c’athpich c’anitha’ axi jun ani axi jun iba. Ne’ets ca putu c’al in uchbixtal c’al axi jun ani c’al axi jun iba. Ni abal jay yab a ejtohual ca c’anitha’ a Dios ani jaye ca t’ajat c’anitha’ an tumin. ");
INSERT INTO husNT1971_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","An fariseochic in ats’a’ abal antsana’ in ulu a Jesús, ani cum pel i lej jaylomchic c’al an tumin tocat in tilibnanchalq’ui. ");
INSERT INTO husNT1971_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Tam a Jesús in ucha’chic: ―Tata’chic ojni’ c’al jahua’ a t’ajal, expith abal a le’ max quit exla tit alhua’ inicchic c’al a at inic, ani a Dios jats ti lej exlanchal a lej ey ta ichich. Hua’ats i t’ajbilab ax u tsu’tab ti lej alhua’ c’al an inic, ani c’al a Dios u tsu’tab ti yab alhua’. ");
INSERT INTO husNT1971_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Ma ti lej biyalits ani ma tam ti chichits a Juan pujax u aynab an ts’ejcath c’au binath c’al a Moisés ani in exobchixtal axi ti biyal an caulomechic c’al a Dios. Ani a Juan jats in lej olnamal abal a Dios ne’ets quin t’aja’ ti lej Ts’ale teje’ tsabal, ani xo’ yan i inicchic in canat lubal ca otsits taja’. ");
INSERT INTO husNT1971_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Más thubat ne’ets ca taley an tsabal ani an eb, ani an ts’ejcath cau in cahuintal a Dios ma ni hue’ yab ne’ets ca taley jayq’ui’ ni jun i letra. ");
INSERT INTO husNT1971_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Jitats quin jilcacay in tomquil ani ca tomquin c’al q’ue’at i uxum, tamna’ pel i uxumbe. Ani jitats ca tomquin c’al i uxum axi jilcacath, tamna’ pel i uxumbe jaye. ");
INSERT INTO husNT1971_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Cahue a Jesús in ulu: C’uajatac jun i rico inic ax u toltomnal c’al i huinat alhua’ toltom ani lej ts’alat c’apul ti patal q’uicha. ");
INSERT INTO husNT1971_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","C’uajatac jaye jun i ts’ejhuantal inic im bij Lázaro, ani lej t’it’lith tim puhuel in inictal. Hualim quetel tin hui’lebil tin q’uima’ an rico quin aychi max ca pithan jant’oquitsq’ui. ");
INSERT INTO husNT1971_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ma in le’ac max ca pithan an mu’mach pan ax in ijcachical an rico ba’ an mexa. Tats tu che’el i pic’o’chic c’al ca lec’onchat in t’it’al a Lázaro. ");
INSERT INTO husNT1971_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Jun a q’uicha tsemetsits an ts’ejhuantal, ani ne’tha c’al an ángelchic ca c’uajiy jun ti c’uajat a Abraham tin ts’alat coytal a Dios. Taley tsemetsits jaye an rico ani joliyat. ");
INSERT INTO husNT1971_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ani tocat in yajchicnal ti al an tamtsemla. Ani ma taja’ in tsu’u ou ti c’uajat a Abraham ani jaye a Lázaro. ");
INSERT INTO husNT1971_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ani in thajat ulu: Pay’lom Abraham, tiquin yajnanchi. Tiquin abchi a Lázaro quin tsabay in ch’uchub c’ubac al i ja’ abal ca chich tiquin tsamambethanchi in chum u lec’ab. Cum te in c’uajat tocat u lej yajchicnal al axe’ xi c’amal. ");
INSERT INTO husNT1971_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Tam uchan an rico c’al a Abraham: Pay’lom, ca lej t’ila’ abal a huat’amal lej alhua’ a q’uicha ti tsabal ani a Lázaro in huat’amal lej yajchic. Xohue’ a Lázaro lej alhua’ in huat’al teje’, ani tata’ a huat’al lej yajchic tihua’. ");
INSERT INTO husNT1971_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ani cum hua’ats ejtil i luputh quexat jol ts’ejel c’al huahua’, axi te c’uajatchic yab in ejtohual ca c’ale tihua’ aba ani’ in le’ac. Jaye axi tihua’ c’uajatchic yab in ejtohual ca chich teje’. ");
INSERT INTO husNT1971_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Tam toc’tsin an rico: Pay’lom Abraham, nan tu lej pacabethal ca aba’ a Lázaro ti olchix tin q’uima’ u tata. ");
INSERT INTO husNT1971_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Quin olchi axi bo’ u ebchal an chubaxtalab abal yab ca ulits teje’ al axe’ xi c’uajattalab lej yajchic. ");
INSERT INTO husNT1971_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Tam uchan c’al a Abraham: In cua’alits a ebchalchic an u jahua’ thuchath c’al a Moisés ani c’al an caulomechic c’al a Dios. Jats quin lej t’aja’chic ti cuenta jahua’ in ulal. ");
INSERT INTO husNT1971_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Toc’tsin an rico: Pay’lom Abraham, max jaja’chic ca tsa’biyat c’al jita’ pelac i tsemelom ani xo’ ejthachits, tam ojni’ ne’ets ca jic’tson c’al in hualabchic ani ca huenc’on c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Toc’tsin a Abraham: Max yab im belamalchic jahua’ thuchath c’al a Moisés ani c’al an caulomechic c’al a Dios, jaye max ca ejtha i tsemelom yab ne’ets quim bela’. ");
INSERT INTO husNT1971_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","A Jesús in ucha’ in exobalilchic: ―Abal ju’tamq’ui ets’ey hua’ats ax u hualbinthom c’al in at inic, ani lej ts’ejhuantalchic cum ne’ets ca lej yajchiquiyat c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Max jita’ quin t’ajchi ca hualbin jun i tsacam axi nan tim belal, in tomnalac ca palchin i alchic tsa’ t’ujub tin nuc’ an hualbinthom ani ca pet’na al i pulic lejem ca t’ajat uc’tsin. ");
INSERT INTO husNT1971_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ca lej beletna’ ta ba’ abal yab quit hualbintha. ―Ani max a at belom u hualbinal c’al tata’, ca tsapic exobchi. Max ca jic’tson c’al in hualab, ca paculanchi. ");
INSERT INTO husNT1971_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Max ca hualbin buquil i calat ta q’uicha ani ti uchalac yabats ne’ets ca hualbin, ca paculanchi jaye ma buquil i calat. ");
INSERT INTO husNT1971_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Tam uchan a Jesús c’al in abathualejilchic: ―Tucu tolminchi abal qui más beloloye a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","A Jesús in toc’tsiychic: ―Max a cua’al a belomtal tsipili’ ejtil i iyalab mostaza, ne’ets ca ejtou ca ucha’ nixe’ xi te’ sicómoro ca la’uhuat ani ca c’uajba ti al am pulic lejem, ani ne’ets quit t’ajchin c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Max it amulab ani a t’ojnalil huichits ti xalum tsabal o ti beletnom co’nel, auxe’ max thubat ne’ets ca ucha’ ca otsits ti c’apul. ");
INSERT INTO husNT1971_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Hualam yab i ne’ets ca ucha’ antse’: Tiquin ts’ejcanchi an c’apnel ani tiquin t’ojojonchi an mexa. Oc’ox nan ne’ets quin c’aputs tiq’uelte quit c’aputs. Antsana’its ne’ets ca ucha’. ");
INSERT INTO husNT1971_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Auxe’ max ne’ets ca bina’ i c’ac’namal yan c’al a t’ojnalil max ti t’ajchi jahuats ta ca abatna’. Iba ");
INSERT INTO husNT1971_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Max tata’chic a tala’ t’ajchamal jahuats ti quit abatna c’al a Dios, in tomnal ca ucha’ a Dios antse’: Pel huahua’ tu t’ojnalil ani yab bijith tata’ tucu ucha’ c’ac’namal yan, cum expith i t’ajchamal jahua’ tu abatnamal. Expith i putumal i uchbil. ");
INSERT INTO husNT1971_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ne’etsits a Jesús ti Jerusalén ani huat’ey jun ti xamlith am bichoulom Samaria ani am bichoulom Galilea. ");
INSERT INTO husNT1971_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Tam ti utatits ca ulits al i tsacam bichou, in tamu lajuj i inic ax in cua’al i t’it’ c’apux c’al in anam t’u’ul. Cubiychic hue’ ou. ");
INSERT INTO husNT1971_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","In thajat uluchic: ―Exobchix Jesús, tucu yajnanchi. ");
INSERT INTO husNT1971_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Tamna’ a Jesús in meta’chic ani in ucha’: ―Quit c’alechic tihua’ c’al am pale’. Ani biyat ne’etsits c’al am pale’, tam ti jelthajitschic. ");
INSERT INTO husNT1971_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ani jun al nixe’ xi lajuj tam tin tsu’u abal jelthachits, huichiy c’al a Jesús in lej puhuethanchal im bij a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","In tuthu in c’ualal tin tamet a Jesús ani in mo’cal in hual ti tsabal abal quim bina’ i c’ac’namal. Pel i Samariajib. ");
INSERT INTO husNT1971_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Tam a Jesús in ulu: ―¿Yab i lajuj axi jelthame? ¿Ju’ta ti c’uajat xo’ axi beleu? ");
INSERT INTO husNT1971_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Expith axe’ xi pil inic yab pel i Israel jats huichits tiquim pitha’ i c’ac’namal yan? ");
INSERT INTO husNT1971_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Tam uchan an inic c’al a Jesús: ―Xo’ it jelthachits cum a belamal. Quit cubiy ani quit c’alets. ");
INSERT INTO husNT1971_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Conoyab a Jesús c’al an fariseochic jayq’ui’ hualam ti ne’ets quin t’aja’ a Dios ti lej Ts’ale teje’ tsabal. Toc’tsin: ―Xo’ yab a ejtohualchic ca tsu’u c’al a tsu’ux hual max a Dios in t’ajal ti lej Ts’ale. ");
INSERT INTO husNT1971_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ni jita’ yab ne’ets ti olchi max teje’ c’uajat a Dios ti tejhua’ Ts’ale o max tihua’ c’uajat ti tejhua’ Ts’ale. Cum xohue’ a Dios in t’ajal ti Ts’ale teje’ tsabal expith tin ichich i inicchic. ");
INSERT INTO husNT1971_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Tam a Jesús in ucha’ in exobalilchic: ―Ne’ets quim baju a q’uicha tam ne’ets ca le’na’chic tiquin tsu’u nana’ tin Juntal patal an inicchic in huichenequits, ani yabaye ne’ets tiquin tsu’u. ");
INSERT INTO husNT1971_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ne’ets quit uchanchic: Teje’ in c’uajat o tihua’ nana’ in c’uajat. Yab ca belchi ja, ani yab quit c’ale ca tsu’u cum yab chubax nana’its. ");
INSERT INTO husNT1971_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ejtil an ley tam u leyts’om ani u tsu’tab tim puhuel an c’ay’lal, antsana’ nana’ tin Juntal patal an inicchic ne’ets quin tsu’tat tam quim bajuhuits u q’uichajil quin chich junil. ");
INSERT INTO husNT1971_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Xo’ bijithits c’al a Dios ne’ets quin oc’ox lej yajchiquiyat ani quim pojca c’al an inicchic. ");
INSERT INTO husNT1971_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Jant’ini’ in xe’tsintal an inicchic tam ti lej biyalits xe’tsin a Noé, antsana’ ne’ets quim baju tam utataquits nana’ tin Juntal patal an inicchic ne’ets quin chich junil. ");
INSERT INTO husNT1971_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ti lej biyalits xe’tsin an inicchic ti c’apupulq’ui ani ti tomquinalq’ui, ma tam tin lej bajuhuits an q’uicha tam ti a Noé otsitsits ti al am pulic tan ata. Tam t’ajat uc’tsin tim patalchic c’al an lej pulic ab. ");
INSERT INTO husNT1971_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Aniye jaye tam ti lej biyalits xe’tsin a Lot, an inicchic xe’tsin ti c’apupulq’ui, ti ts’a’umq’ui, ti nujulq’ui, ti omq’ui, ani ti ts’ejcomq’ui ata. ");
INSERT INTO husNT1971_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ani tam ti calets a Lot ti al am bichou Sodoma, tam tu jolnalits an c’amal t’ujub tal ti eb ti al nixe’ xi bichou Sodoma. Tam t’ajat tala’ tsemets nixe’ xi bichou. ");
INSERT INTO husNT1971_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ejtil tin t’ajamal an inicchic tam ti xe’tsin a Noé ani tam ti xe’tsin a Lot, antsana’ ti ne’ets quin t’aja’ an inicchic tam utataquits nana’ tin Juntal patal an inicchic quin chich junil. ");
INSERT INTO husNT1971_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Tam quim bajuhuits u q’uichajil quin chich, tam jitats c’uajat tin hualq’ui’lal in q’uima’ ca thubat pa’iy, ani ma yabats ca otsits alta quin calthaye jahua’ in cua’al. Ani max jita’ c’uajat tin t’ayablabil, ma yabats ca huichiy tin q’uima’. ");
INSERT INTO husNT1971_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ca t’ila’chic jant’o t’ajchinenec in q’uimathil a Lot c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Jitats in le’ expith quin t’aja’ in cuete’ culbetal, jats ne’ets ca q’uibey. Jitats quim bina’ tim ba’ c’al tu ebal nana’, jats ne’ets ca jec’ontha. ");
INSERT INTO husNT1971_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Nan tu uchalchic max quin chich acal ani c’uajat tsab ti junax huayal al i huaytalab, ne’ets cu ne’tha’ jun ani jun ne’ets ca jilc’on. ");
INSERT INTO husNT1971_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Max tsab i uxum c’uajat ti junax tse’el c’oye, ne’ets cu ne’tha’ jun ani ne’ets ca jilc’on jun. ");
INSERT INTO husNT1971_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Max c’uajat tsab i inic ti junax t’ojnal tin tsabalil, ne’ets cu ne’tha’ jun ani jun ne’ets ca jilc’on. ");
INSERT INTO husNT1971_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Tam tin ats’a’itschic antsana’ an cau in exobalilchic a Jesús, tam in conoychic: ―¿Ajatic, ju’ta ti ne’ets ca t’ajan antsana’? A Jesús in toc’tsiychic: ―Ju’tamits ti c’uajat i tsemelom t’u’lec, tats ne’ets ca tamcun an t’otchic. ");
INSERT INTO husNT1971_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","A Jesús in olchiye in exobalilchic q’ue’at i jalpith cau c’al ca exobchin abal patal in lej yejenchal ca ets’ey olon ani yab ca palme in ichich. ");
INSERT INTO husNT1971_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","In ulu: ―C’uajatac al jun i bichou i ts’ejcom cau axi yab in c’ac’nal a Dios ani yab in t’ajchal ti cuenta tam ca chich an othom cauchic. ");
INSERT INTO husNT1971_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","C’uajatac jaye al nixe’ xi bichou i tsemchith uxum, lej ets’ey u c’alel c’al nixe’ xi ts’ejcom cau abal quin othanchi an cau in tomolnaxil. ");
INSERT INTO husNT1971_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ohuatits an ts’ejcom cau yab in le’ quin ts’ejcanchi an cau, ma lej talbelits in ulu tin ichich antse’: Nan yab u c’ac’nal a Dios ani yab u t’ajal ti cuenta an inic. ");
INSERT INTO husNT1971_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Aba ani’ bel ne’ets cu ts’ejcanchi an cau an uxum cum tin ets’ey it’ixbethal. Ne’ets cu lejat ts’ejcanchi abal yabats ca huichiy tiquin it’ixbetha’. ");
INSERT INTO husNT1971_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Tam in ulu an Ajatic: ―Aba ani’ pojcax an ts’ejcom cau, ca lej t’aja’chic ti cuenta jant’o in ulu abal ne’ets quin tolminchi an uxum. ");
INSERT INTO husNT1971_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Max antsana’ tin tolminchi an uxum, jaquitsq’ui yab i a Dios ne’ets quin más tolminchi jitats in tacuyamalits tam ca conchin jant’o. A Dios yab u it’ixbel ti tolmix c’al jant’ots ca conchin max acal o max q’uicha. ");
INSERT INTO husNT1971_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Lej chubax nan tu uchalchic abal thubat in tolmiyal im bichohuil. Aba ani’ antsana’ pel in ey a Dios ti lej tolmix, bel hualam max cu ela’ i belomchic tam nana’ tin Juntal patal an inicchic quin chich junil. ");
INSERT INTO husNT1971_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Tam a Jesús in olchi i jalpith cau talchic i inicchic axi alalnax c’al in at inic ani in tsalpayal abal jats jaja’ lej c’athpich pututh. In ucha’chic: ");
INSERT INTO husNT1971_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","―C’alechic tsab i inic ti tiyopan ca olon, jun pel i fariseo ani axi jun pel i bats’c’ul jalbixtalab tumin c’al an gobierno. ");
INSERT INTO husNT1971_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Cubiy ti ol an fariseo al an tiyopan in ulu antse’: Dios, u binal i c’ac’namal cum nan u ey yab ejtil in ey axi q’ue’at ax u cue’, ax u pojcax, ax u uxumbe. Yab in ejtil nixe’ xi bats’c’ul jalbixtalab tumin. ");
INSERT INTO husNT1971_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Im pabil yab in c’apul tsab i calat ti al an semana ani tu pithal jun tin cuenta c’al an lajuj patal jahua’ u cua’al. ");
INSERT INTO husNT1971_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ani am bats’c’ul jalbixtalab tumin cubat hue’ ou. In ats’al lej hualbith, ma yab in tomnal quin met’a’ hualq’ui’ ti eb. Tocat in cuathcuayal in ichich cum in ats’al lej jolbith. U ol in ulu antse’: Dios, tiquin yajnanchi cum nan in lej hualbith. ");
INSERT INTO husNT1971_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Tam in uluye a Jesús: Nan tu uchalchic abal huichits tin q’uima’ am bats’c’ul jalbixtalab tumin paculanchithits in hualab, ani an fariseo yab ja paculanchithits in hualab. Jitats quin c’athatna’ tim ba’ yab ne’ets ca yajnanchat c’al a Dios, ani jitats quin tsa’ca’ tim ba’ jats ne’ets ca yajnanchat. ");
INSERT INTO husNT1971_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","An inicchic in chi’thal i tsacamchic ca tacchin c’al a Jesús, ani in exobalilchic tocat in ts’i’quiyal quin c’uiya’ an chi’thom. ");
INSERT INTO husNT1971_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Tam a Jesús in ucha’chic’ in exobalil: Yab ca c’anchi an tsacamchic yab ca chi’tha c’al nana’. Expith jitats tsa’at in ichich ejtil in ichich i tsacam, jats ax im bats’uhual a Dios ti Ts’ale tin ichich. ");
INSERT INTO husNT1971_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Jitats yab antsana’ in ichich, yab in ejtohual quim bats’u a Dios ti Ts’ale ani yab ne’ets ca c’uajiy ti eb jun tin t’ajal a Dios ti lej Ts’ale. Jats an lej chubaxtalab nan tu uchalchic. ");
INSERT INTO husNT1971_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Jun i oc’lec in conoy a Jesús: ―¿Jant’o pel u uchbil cu t’aja’ abal quin it ejatliyat abal ets’ey? Tata’ it alhua’ exobchix tiquin ucha’. ");
INSERT INTO husNT1971_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Toc’tsin a Jesús: ―¿Jale’ tin uchal tin alhua’? Hua’ats juncats expith axi alhua’, ja’its a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","A tso’obits an uchbixtalabchic axi thuchat tin cahuintal a Dios antse’: Yab quit uxumbejin. Yab ca tsemtha’ a at inic. Yab quit cue’en. Ni jita’ yab ca t’ajchi an janamtalab. Ca c’ac’na’ a tata ani a mim. ");
INSERT INTO husNT1971_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Tam uchan a Jesús c’al an oc’lec nixe’: ―Ma tam tu tsacamtal u tala’ putumal an uchbixtalab c’al axe’ ax tin uchamal. ");
INSERT INTO husNT1971_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Toc’tsin a Jesús: ―Hua’atse jant’o in le’ a Dios abal ca t’aja’. Ca tala’ nuju jahua’ a cua’al ani ca pitha’ an tumin an ts’ejhuantalchic. Ma tam tiq’uele quit huichiy ani tiquin ts’at’enchi. Max antsana’ ca t’aja’, tam ojni’ ne’ets quit pithan yan i c’alab tihua’ ti eb. ");
INSERT INTO husNT1971_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","C’al nixe’ xi cau jilc’on lej t’e’pith an oc’lec, cum in le’ quin cuete’ c’alna’ axi yan in cua’al. ");
INSERT INTO husNT1971_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","A Jesús in tsu’u abal lej t’e’pith ani in ulu: ―Lej q’uibat an ricochic quim bats’u a Dios ti Ts’ale tin ichich. ");
INSERT INTO husNT1971_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Lej q’uibat ca huat’ey jun i camello tin lo’tal in acan an t’ithab, ani lej huat’ath más q’uibat abal i rico quim bats’u a Dios ti Ts’ale tin ichich max quin huat’ath tsapna’ axi yan in cua’al. ");
INSERT INTO husNT1971_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ani ax in ats’alchic jahua’ antsana’ in ulu a Jesús, in conoyal: ―¿Max chubax antsana’ jahua’ in ulu, tam jita’ hualam ne’ets ca ejtohuat ca jec’ontha? ");
INSERT INTO husNT1971_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","A Jesús in toc’tsiychic: ―An inicchic yab in ejtohual quin cuete’ jec’ontha’ tim ba’, expith c’al a Dios ojni’ ne’ets ca ejtohuat ca jec’ontha. ");
INSERT INTO husNT1971_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Tam uchan a Jesús c’al a Pedro: ―Ajatic, i tala’ jilamal i c’al abal tu ts’at’enchi. ");
INSERT INTO husNT1971_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","A Jesús in toc’tsiy: ―Lej chubax nan tu uchalchic abal hua’ats jita’chic in jilamalits i c’alab cum im bats’umalits a Dios ti Ts’ale tin ichich. Hua’ats ax in jilamalits in q’uima’, in tata ani in mim, in tomquil, ani in tsacamilchic. ");
INSERT INTO husNT1971_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Jats jaja’chic axi ne’ets ca pithan yan más c’al a Dios biyat xe’etse teje’ tsabal, ani talbel ne’ets ca c’uajiy ti eb it ejatlith abal ets’ey. ");
INSERT INTO husNT1971_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","A Jesús in ne’tha’ hue’ pil in exobalilchic ani in ucha’: ―Xo’ ojni’ huahua’ u ne’etsits tihua’ ti Jerusalén, ani taja’ ne’ets quin tala’ t’ajchin jahua’ an caulomechic c’al a Dios biyalits in thuchamal antsana’ ne’ets quin t’ajchin. Nana’its pel tin Juntal patal an inicchic. ");
INSERT INTO husNT1971_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ne’ets quim bina tin c’ubac i pil inicchic axi yab Israel, c’al quin tilibna, ani quin othna, ani quin tubcayat. ");
INSERT INTO husNT1971_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ne’ets quin huithc’oyat, ani ne’ets quin tsemtha. Aba ani’ quin tsemtha, bel ne’ets quin ejtha oxchilab q’uicha ti al an jolimtalab. ");
INSERT INTO husNT1971_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ni jahua’ axe’ xi cau in exobalilchic a Jesús yabaye in ejtohual quin exbay. ");
INSERT INTO husNT1971_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Utatits a Jesús ca ulits ti bichou Jericó, ani tats ti quetel tin hualte’lil am bel jun i joc’tsi ti conol c’al i ts’ejhualixtalab tumin. ");
INSERT INTO husNT1971_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Cum in ats’al lej yantalam i inicchic u huat’el, in conoyal jale’ tu huat’el yantalam i inic. ");
INSERT INTO husNT1971_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Tam uchan pel a Jesús Nazaretib u huat’el. ");
INSERT INTO husNT1971_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Tam in thajat ulu: ―Tata’ Jesús axi pel it at xits’lab c’al a David, tiquin yajnanchi. ");
INSERT INTO husNT1971_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Tamna’ c’uiynal an joc’tsi, uchan ca ts’ibc’an c’al axi ne’ets hue’ más oc’ox c’al a Jesús. Ani jaja’ tocat más tsapic thajat cau, in ucha’ a Jesús: ―Tata’ axi pel it at xits’lab c’al a David, tiquin yajnanchi. ");
INSERT INTO husNT1971_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Tam cubiy a Jesús ani in aba’ an cau ca chanchin an joc’tsi. Ani tam ti ulthanchatits, tam in conoy: ");
INSERT INTO husNT1971_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―¿Jant’o a le’ abal nan tu t’ajchi? Toc’tsin an joc’tsi: ―U le’ abal tiquin tsu’uxmetha’. ");
INSERT INTO husNT1971_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Tam a Jesús in ucha’: ―Ojni’ ne’ets tu tsu’uxmetha’ cum tim belamal. Xo’ jelthachits a hual. ");
INSERT INTO husNT1971_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ma tamna’ an joc’tsi tsu’uxits, ani taley ts’at’eyits c’al a Jesús in lej puhuethanchal im bij a Dios. Ani patal an inicchic ax in tsu’u jahua’ t’ajchinenec an joc’tsi, jaye im puhuethanchal im bij a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Taley otsits a Jesús ti bichou Jericó ani tats ti xe’ets. ");
INSERT INTO husNT1971_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ani taja’ c’uajat jun i rico inic im bij Zaqueo. Pel i oc’lec c’al am bats’c’ul jalbixtalab tumin c’al an gobierno. ");
INSERT INTO husNT1971_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","In aychal quin tsu’u a Jesús, in le’ quin exla’. Tocat yab in ejtohual quin alhua’ tsu’u tin ebal an mulcunel ani cum jaye tsipilin jaja’ ti inic. ");
INSERT INTO husNT1971_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Jaxtam oc’chith c’ale athithil jun ti ne’ets ca huat’ey a Jesús, ani c’athiy al jun i te’ sicómoro abal quin alhua’ tsu’u. ");
INSERT INTO husNT1971_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Tam tim baju a Jesús ba’ al nixe’ xi te’, tam in tsu’u c’uajat a Zaqueo hualq’ui’. Tam in ucha’: ―Thubat quit pa’iy Zaqueo, cum nan ne’ets xo’ quin jilc’on ta q’uima’. ");
INSERT INTO husNT1971_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Tam thubat pa’iy lej culbel, c’ale quim bats’u a Jesús tin q’uima’. ");
INSERT INTO husNT1971_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Tam tin ats’a’chic axi muthat taja’ antsana’ in ulu a Jesús, tam in c’uiyath ulu abal jale’ ne’ets ca jilc’on tin q’uima’ i hualbith inic. ");
INSERT INTO husNT1971_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Tam cubiy a Zaqueo tin tamet jaja’chic, ani in ucha’a Jesús: ―Ajatic, xo’ nan ne’ets cu ts’ejhualiy c’al an ts’ejhuantalchic ma tam ts’ejel jahua’ u cua’al. Max u c’ambith tixc’anchamal jita’ an tumin ne’ets cu huichbanchi ma tse’ huichc’oth. ");
INSERT INTO husNT1971_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","A Jesús toc’tsin: ―Ma xohue’ jec’onthachits axe’ xi inic axi pel in at xits’al a Abraham. Jaye ne’ets ca jec’onthachic axi tin q’uima’. ");
INSERT INTO husNT1971_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Nana’ tin Juntal patal an inicchic in che’nec cu aliy axi xe’ets q’uibenec al an hualabtalab ani cu jec’ontha’. ");
INSERT INTO husNT1971_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Hue’ ne’ets ca ulitschic ti Jerusalén a Jesús ani axi ts’at’atchic c’al jaja’ in ats’anchal in cahuintal, c’al in tsalpayalchic abal hualam hue’its a Dios ne’ets quin t’aja’ ti lej Ts’ale teje’ tsabal. Tam olchinal i jalpith cau c’al a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","In ulu antse’: ―Jun i inic axi lej bijithits quim baju ti ts’ale ne’ets ca c’ale al jun i bichou ou abal ca punuhuat tihua’ ti ts’ale, ani talbel ne’ets ca huichiy tim bichou. ");
INSERT INTO husNT1971_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Oc’ox in caniy ca chich c’al jaja’ lajuj in t’ojnalil, ani im pitha’ ti junchic jun i tumin axi lej yan in jalbil. In ucha’chic quin t’ojonthanchi ma tam ta ca huichits jaja’cua’. ");
INSERT INTO husNT1971_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ani cum at’ab jaja’ c’al am bichou jun ti ne’ets ca punuhuat, chich i abathualechic quin ucha’ an oc’lec ts’ale abal yab u le’nab ti ts’ale nixe’ axi lej bijithits. ");
INSERT INTO husNT1971_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Aba ani’ yab u le’nab, bel c’ale ani punuhuat ti ts’ale. Taley talbel huichiy tim bichou. Ulits ani in aba’ ca caniyat ca chich ti junchic ax im pithamal an tumin ca t’ojonthanchat, cum in le’ quin exla’ jay in atamal. ");
INSERT INTO husNT1971_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Uchan c’al axi oc’ox chich: Pay’lom, c’al an tumin ax tim pithamal u atamal lajuj huichc’oth. ");
INSERT INTO husNT1971_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ani toc’tsin an ts’ale: Pel it lej alhua’ t’ojnal cum antsana’ tin alhua’ t’ojonthanchamal axi hue’ an tumin ax tu pithamal. Jaxtam nan ne’ets tu punu tit oc’lec c’al lajuj i bichou. ");
INSERT INTO husNT1971_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Chich q’ue’at i t’ojnal in ucha’ an ts’ale: Pay’lom, c’al an tumin ax tim pithamal u atamal bo’ huichc’oth. ");
INSERT INTO husNT1971_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ani toc’tsin an ts’ale: Nan ne’ets tu punu tit oc’lec c’al bo’ i bichou. ");
INSERT INTO husNT1971_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Tamna’ chich q’ue’ate an t’ojnal in ucha’ an ts’ale: Pay’lom, te tu huichbanchal an tumin ax tim pithamal. Tu alhua’ beletnanchi thut’pipith c’al i toltom. ");
INSERT INTO husNT1971_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Cum it lej pathay, u ts’ejnal max yab cu ejtou tu alhua’ t’ojonthanchi a tuminal. U tso’ob abal a tixc’anchal jat’hua’ tim patal an tumin axi it huichc’oth t’ojonthanchithits. ");
INSERT INTO husNT1971_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Tam uchan an t’ojnal: Tata’ ojni’ c’al jahua’ tin uchamal nan tu exlalits abal pel it pojcax inic. Tin exlal abal im pathaycua’ ani u t’ixc’anchal jat’hua’ tim patal an tumin ax in huichc’oth t’ojonthanchithitscua’. ");
INSERT INTO husNT1971_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿Max antsana’ u ey tin tsalpanchal, jale’ yab tim binanchi u tuminal c’al q’ue’at i inic abal jaja’ tiquin t’ojonthanchi ani cu bats’unchi in oc’tal u tuminal? ");
INSERT INTO husNT1971_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Tam an ts’ale in ucha’ axi c’uajat taja’chic: Ca tixc’anchi axe’ xi inic an tumin ani ca huat’banchi ax tin t’ojonthanchamalits lajuj huichc’oth. ");
INSERT INTO husNT1971_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Toc’tsinchic: Pay’lom, ca tsu’u abal in cua’alits lajuj i tumin. ");
INSERT INTO husNT1971_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Toc’tsin an ts’ale: Nan tu uchalchic abal jitats quin alhua’ t’ojonthanchi jahua’ u pithamal nan ne’ets cu pithaye más, ani jitats yab quin alhua’ t’ojonthanchi ne’ets cu tixc’anchi axi hue’ u pithamal. ");
INSERT INTO husNT1971_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ani axi tomolnaxchic yab tin le’na’ tin ts’ale, ca chi’tha’ teje’ tu tamet ani tiquin tsemthanchi. ");
INSERT INTO husNT1971_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Tam ti talits quin ulu antsana’ a Jesús, ta c’ale in aynal am bel ti Jerusalén. ");
INSERT INTO husNT1971_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Hue’its quim baju am bichou Betfagé ani am bichou Betania axi utatchic ti bolchal Olivos, ani ma taja’ a Jesús ne’ets quin aba’ tsab in exobalil c’al i cau. ");
INSERT INTO husNT1971_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","In ucha’chic: ―Quit c’alechic al nixe’ xi bichou axi utatits, ani taja’ ne’ets ca ela’ jun i burro huic’at axi lejat yabaye punume. Ca piliy ani tiquin chanchi teje’. ");
INSERT INTO husNT1971_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Max jita’ ti ucha’ abal jale’ ta piliyal, ca ucha’ abal nana’ in Ajatic ax u yejenchal. ");
INSERT INTO husNT1971_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Tana’ c’alechic ani in ela’ am burro jant’ini’ ti uchnenec c’al a Jesús ne’ets quin ela’. ");
INSERT INTO husNT1971_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Tam tim piliyalits am burro, tam tu conoyab c’al an thabal: ―¿Jale’ ta piliyal am burro? ");
INSERT INTO husNT1971_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Toc’tsin jaja’chic: ―Cum an Ajatic in yejenchal. ");
INSERT INTO husNT1971_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Tam in chi’tha’chic am burro c’al a Jesús. Im punchal jaja’chic in toltomil tin cux am burro, ani tam puney a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ani an mulcunel in mo’cal in toltomil ba’ am bel jun ti ne’ets ca huat’ey a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Tam ti utatits ne’ets quim baju am bel axi pa’a’al ti bolchal Olivos, patal am belomchic axi ts’at’at c’al a Jesús in ts’i’quiyal ti thajat cau c’al in ichich lej culbelchic. Im puhuethanchal im bij a Dios, cum in tsu’umalits yan i labith t’ajbilab ax in t’ajamal a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","In thajat ulalchic: ―Qui ajatnanchi im bij i Ts’alejil axi te talits abath c’al a Dios. Qui puhuethanchi im bij a t’ec’at Dios ti eb axi jun ejetbethanchix c’al i ichich. ");
INSERT INTO husNT1971_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Tam uchan a Jesús c’al talchic i fariseochic axi al an mulcunel: ―Exobchix, ca ucha’ ca ts’ibc’an an mulcunel. ");
INSERT INTO husNT1971_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","A Jesús in toc’tsiychic: ―Nan tu uchalchic max ca ts’ibc’an an mulcunel, ma nixe’ xi t’ujubchic mo’ol ne’ets quin thajat puhuethanchi im bij a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Tam ti utatits ne’ets ca ulits ti Jerusalén, a Jesús in met’a’ am bichou ani in uc’nanchal. ");
INSERT INTO husNT1971_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","In ulu: ―Lej alhua’ max xo’ a tso’obnalaquitschic jant’ini’ quit jec’ontha ani quit c’uajiy jun ejet ta bichou. Expith ejtil it joc’tsiye. ");
INSERT INTO husNT1971_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ne’ets quim baju a q’uichachic lej c’ac’ath tam a tomolnaxilchic ne’ets ti tala’ t’oc’banchi a bichou ti peiéx, ani ma ni hue’ yab ne’ets ca ejtouchic quit pit’c’on. ");
INSERT INTO husNT1971_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ne’ets ti tala’ paclunchi a bichou ani ne’ets ti tsemtha’chic. Ni jun i t’ujub ne’ets ca jilc’on t’i’póx. Antsana’ ne’ets quit t’ajchinchic, cum yab a tso’obnal abal nan xo’ in abath c’al a Dios abal tu jec’onthalac. ");
INSERT INTO husNT1971_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Taley otsits a Jesús ti al am pulic tiyopan ti Jerusalén, in tala’ quethmachiquiyal eleb axi nujul ani axi ts’a’um taja’. ");
INSERT INTO husNT1971_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","In ucha’chic: ―Thuchathits ti al an T’ocat Thuchlab jahua’ in ulu a Dios antse’: U q’uima’ ja’its jun ta ca olon an inicchiccua’. Nan tu uchalchic abal xo’ tata’ a eyenthal abal ca cue’chi jant’o ax u che’el ti ol. ");
INSERT INTO husNT1971_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Chuthel chuthel exome ti exobchix a Jesús taja’ ti al am pulic tiyopan, ani an oc’lec pale’chic ani an exobchix c’al an ts’ejcath cau binath c’al a Moisés ani an oc’lecchic ti al am bichou in junax lubal quin aliy jant’ini’ ti quin tsemtha’ a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Tocat yab in elalchic jant’ini’, cum patal am bichou in lej canat ats’anchal jahua’ in exobchal a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Jun a q’uicha c’uajat a Jesús ti al am pulic tiyopan ti Jerusalén in olnanchal an inicchic an alhua’ cau, ani ulits c’al jaja’ i oc’lec pale’chic ani i exobchixchic c’al an ts’ejcath cau binath c’al a Moisés ani i yejtselabchic Israel. ");
INSERT INTO husNT1971_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ani conoyab a Jesús: ―¿Jita’ ti pithamal an eyaltalab ani jita’ ti abamal abal ca t’aja’ jahua’ a t’ajal? ");
INSERT INTO husNT1971_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Toc’tsin a Jesús: ―Nana’ne ne’ets tu conoychic c’al jun i cau ani u le’ abal tiquin toc’tsinchi. ");
INSERT INTO husNT1971_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿C’al jita’ ti aban a Juan ti pujax? Tiquin toc’tsinchi, max c’al a Dios o max c’al i inic. ");
INSERT INTO husNT1971_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Tam jaja’chic in t’iloxnachiquiyal jahua’ in ulu a Jesús, ani taley in uluchic: ―¿Jant’ini’ ti qui toc’tsinchi? Max qui ulu abal c’al a Dios jats ti abnenec a Juan ti pujax, tam jaja’ ne’ets quin ulu abal jale’ yab i belchamal in cahuintal. ");
INSERT INTO husNT1971_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Max qui ulu abal c’al i inic jats ti abnenec, tam patal an inicchic ne’ets tucu cui’iy c’al i t’ujub ma tucu tsemtha’, cum in lej belalits abal a Juan pel i lej chubax caulome abnenec c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Tam tocat in toc’tsiychic abal yab in tso’ob c’al jita’ ti abnenec a Juan ti pujax. ");
INSERT INTO husNT1971_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Tam a Jesús in ucha’chic: ―Nana’ne yab ne’ets tu olchichic c’al jita’ tim pithnenec u eyaltal ani c’al jita’ tin abnenec. ");
INSERT INTO husNT1971_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Taley a Jesús in olchiye an inicchic q’ue’at i jalpith cau antse’: ―Jun i inic in t’aya’ jun i lab t’uthublom. Taley im bina’ c’al jita’ ta ca t’ojonchat. Tam c’ale an thabal ti ohuat c’uajil pil. ");
INSERT INTO husNT1971_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Taley im bajuhuits in q’uijil an cotlats c’al an lab t’uthub, ani an thabal in aba’ jun i t’ojnal ca c’ale quim bats’c’unchi an lab t’uthub axi ne’ets ca jilc’on abal jaja’ an thabal. Ulits jaja’, ani tocat cuathan ani aban ca huichiy naptal c’al an thabal. ");
INSERT INTO husNT1971_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Tam an thabal in aba’ ca c’ale q’ue’at i t’ojnal. Jayetseq’ui cuathan ani quithab uchan, ani aban ca huichiy naptal c’al an thabal. ");
INSERT INTO husNT1971_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Taley an thabal in aba’ q’ue’ate i t’ojnal, ani jayetseq’ui ts’ojbetha ani quethmayat ca c’ale. ");
INSERT INTO husNT1971_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Taley in ulu an thabal: ¿Jant’o ne’ets cu t’aja’ xo’? Ne’ets cu lejat aba’ u ichich hual tsacamil. Hualam jaja’ ojni’ ne’ets ca c’ac’nacua’. ");
INSERT INTO husNT1971_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ani iba, expith in ulu an t’ojonchixchic antse’: Jats axe’ ne’ets ti c’alnanchix c’al an lab t’uthublom tam ca tsemets in tata. Qui tsemtha’ abal qui c’alnanchi huahua’. ");
INSERT INTO husNT1971_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Tam in caltha’ tin elebtal an t’uthublom, ani in t’ajat tsemtha’. Tam a Jesús in conoyal: ―¿Jant’ini’ ti ne’ets quin t’ajchi an thabal lab t’uthublom nixe’ xi t’ojonchixchic? ");
INSERT INTO husNT1971_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ne’ets ca c’ale quin t’ajat tsemtha’chic, ani ne’ets quim bina’ an lab t’uthublom ca t’ojonchat c’al q’ue’at i t’ojonchix. Tam tin ats’a’its axi taja’chic antsana’ in ulu a Jesús, in uluchic: ―Iba a Dios yab quin jila’ antsana’ ca tsemthachic. ");
INSERT INTO husNT1971_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ani a Jesús tocat in met’alchic ani in ulu: ―Auxe’ max yab nana’ ax u olnab ti al an T’ocat Thuchlab ejtil in mimlab t’ujub. In thuchathits antse’: An ts’ejcom atachic in ulu yab jant’o ti alhua’ axe’ xi t’ujub, ani tocat im pet’na’. Ani ja’its nix an t’ujub axi punuthits ti mimlab t’ujub. ");
INSERT INTO husNT1971_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ejtil an inic axi ca ijcan al i t’ujub ani ca yajchiquiyat, antsana’ jitats yab tim belal nana’. Ejtil max ca ijcanchat i t’ujub ani ca tsemtha i inic, antsana’ jitats yab tim belal nana’. ");
INSERT INTO husNT1971_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","C’al nixe’ xi cau an oc’lec pale’chic ani an exobchixchic c’al an ts’ejcath cau binath c’al a Moisés in le’ quin yac’ua’ a Jesús, cum in exlalits abal jaja’chic ax u olnab al nixe’ xi jalpith cau. Expith in ts’ejnalchic max jant’o ca t’ajchin c’al am bichouchic max quin lej yac’ua’ a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Tam in aba’chic talchic i inic ax in timc’oyal tim ba’ abal jaja’ alhua’, quin cuatsith t’ajchi ti cuenta a Jesús max quin q’uibts’oth ulu i cau, ani antsana’ ca ejtohuat ca jolbiyat ani ca bina tin c’ubac an gobernador. ");
INSERT INTO husNT1971_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ulitschic ani uchan a Jesús: ―Exobchix, i tso’ob abal jahua’ tata’ ca ulu ani ca exobchi pel i lej chubaxtalab. Yab it poc’oth tsu’tom c’al an inic, ani c’al patal an inicchic a olnanchal in tequeth belil a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Tucu ucha’ max i cua’al i uchbil o max yab i cua’al qui jalbiy an jalbixtalab tumin c’al an ts’ale oc’lec romano. ");
INSERT INTO husNT1971_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Cum a Jesús in exlanchits in c’ambixtal, jaxtam in toc’tsiychic antse’: ―¿Jale’ a le’chic tiquin macla’? ");
INSERT INTO husNT1971_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Qui met’a jun i tumin. ¿Jita’ axe’ in hual ani jita’ axe’ im bij axi thuchath teje’ al an tumin? ―Toc’tsinchic: ―Pel in hual ani pel im bij an ts’ale oc’lec. ");
INSERT INTO husNT1971_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Tam a Jesús in ucha’chic: ―Ca pitha’ an ts’ale oc’lec jahua’ pel a uchbil ca pitha’, ani ca pitha’ a Dios jahua’ pel a uchbil ca pitha’ jaye. ");
INSERT INTO husNT1971_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Axi che’nec ti maclaxchic yab in ejtou ni hue’ quin macla’ a Jesús c’al jahua’ in toc’tsinchi tin tamet an inicchic. Tocat in jic’panchalchic in toc’tsixtal, ani lejat ts’ibc’anchic. ");
INSERT INTO husNT1971_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Taley chich talchic i saduceo quin tsu’u a Jesús. Cum yab im belalchic abal max ne’ets ca ejtha an tsemelomchic, jaxtam uchan a Jesús c’al jaja’chic: ");
INSERT INTO husNT1971_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","―Exobchix, in thucha’ a Moisés abal max ca tsemets jun i tomquith inic ani yab in co’oyamal i tsacam c’al in q’uimathil, ca tomquin in ebchal an tsemelom c’al an tsemchith uxum. Lequitsq’ui max quin co’oy i tsacam tam. ");
INSERT INTO husNT1971_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Hua’atsac buc i ebchalab. Tomquin an oc’ox, ani tsemets yab in co’oyamal i tsacam. ");
INSERT INTO husNT1971_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Taley tomquin in tsabchil ebchal an tsemelom c’al an tsemchith uxum. Tsemets jaja’, ani yab in co’oyamal i tsacam. ");
INSERT INTO husNT1971_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Taley tomquin in oxchil ebchal an tsemelom c’al an tsemchith uxum. Tim patal nixe’ xi buc i ebchalab tomquinenec c’al nixe’ xi uxum juncats, ani tim patal tsemets ani ni jun yab in co’oyamal i tsacam. ");
INSERT INTO husNT1971_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Taley tsemets jaye an uxum. ");
INSERT INTO husNT1971_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","¿Cum tomquinenec nixe’ xi uxum c’al axi buc i ebchalab teje’ tsabal, c’al jahua’ ti ne’ets ca c’uajiy ti tomiclab tam ca ejtha an tsemelomchic? ");
INSERT INTO husNT1971_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Tam a Jesús in toc’tsiychic: ―U tomquinal an inic ani an uxum expith teje’ tsabal. ");
INSERT INTO husNT1971_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Tam ca ejtha an tsemelomchic axi jec’onthach, in ey an inic ani in ey an uxum yabats ne’ets ca tomquin. ");
INSERT INTO husNT1971_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ne’ets ca ejthachic c’al a Dios tin lej tsacamilchic, ani ne’ets ca c’uajiy ejtil an ángelchic yab u tomquinal. Tihua’ ti eb ni jayq’ui’ yab ne’ets ca tsemetschic. ");
INSERT INTO husNT1971_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","A Moisés in olna’ jant’ini’ ti tauna jaja’ c’al a Dios ti al i tsacam te’ tam ti t’a’ilits, ani c’al in cahuintal i tso’obits abal ne’ets ca ejtha an tsemelomchic. Uchan abal a Dios pel in Diosil a Abraham ani in Diosil a Isaac ani in Diosil a Jacobcua’. ");
INSERT INTO husNT1971_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Cum a Dios pel in Diosil nixe’ xi ox i inic axi tsemenec teje’ tsabal, i exlalits abal bel c’uajatchic ejate tin tamet a Dios. A Dios in tsu’tal abal ejate patal an inicchic. ");
INSERT INTO husNT1971_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Tam uchan a Jesús c’al talchic i exobchix c’al an ts’ejcath cau binath c’al a Moisés: ―Exobchix, lej chubax an cau jahua’ a ulumal. ");
INSERT INTO husNT1971_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ma tamits ni jita’ yab in inicnal tim ba’ abal quin conomichiquiye a Jesús c’al más i cau. ");
INSERT INTO husNT1971_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Taley a Jesús in conoyalchic: ―¿Jale’ a ulalchic abal a Cristo pel in tsacamil a David? ");
INSERT INTO husNT1971_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ani a David im bijiy a Cristo tin Ajatic tam tin thucha’ al i Salmo antse’: A Dios in ucha’ u Ajatic: Quit buxcan tu huinab c’ubac. ");
INSERT INTO husNT1971_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Teje’ quit buxcan, ma nan tu pitha’its ta c’ubac a tomolnaxilchic abal ca tala’ ata’. ");
INSERT INTO husNT1971_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Cum antsana’ a David im bijiy a Cristo tin Ajatic, jaxtam i tso’obits abal yab pel in tsacamil a David. ");
INSERT INTO husNT1971_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Taley tin tamet patal an inicchic taja’, a Jesús in ucha’ in exobalilchic: ");
INSERT INTO husNT1971_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―Ca lej t’aja’chic ti cuenta yab ca t’aja’ jant’ini’ in t’ajal an exobchixchic c’al an ts’ejcath cau binath c’al a Moisés. In culbetnal ca xe’tsin c’al in nacat coton abal max ca tsu’tat ti pulic in ey. Jaye ca tsapnetha ti bel c’al yan i c’ac’naxtalab. Ti al an tiyopan in lej c’a’inchal ca buxcanchic jun ti quetel axi lej c’athpich pulic in ey, aniye jaye tam hua’ats i ajib ts’alat c’apuxtalab. ");
INSERT INTO husNT1971_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Bel c’al im pojcaxtal in tixc’anchal i c’alab an tsemchith uxumchic, ani talbelaquits u lej ohuelchic ti ol expith abal max ca tsu’tat ti t’ocat. Jats jaja’chic axi ne’ets ca c’athpich jolbiyat c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","C’uajat a Jesús ti al am pulic tiyopan in met’al an ricochic u che’el quim bina’ an c’ac’naxtalab tumin al am poc’te’. ");
INSERT INTO husNT1971_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","In tsu’u jaye chich jun i ts’ejhuantal tsemchith uxum im bina’ tsab i tsacam tumin cobre. ");
INSERT INTO husNT1971_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Tam a Jesús in ulu: ―Lej chubax nan tu uchalchic abal axe’ xi ts’ejhuantal tsemchith uxum in lejat bina’ yab ejtil xi q’ue’at im bina’. ");
INSERT INTO husNT1971_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Axi q’ue’atchic im bina’ i jilc’omach tumin, ani jaja’ aba ani’ ts’ejhuantal in tala’ bina’ jahua’ in cua’alac quin cuxuthna’. ");
INSERT INTO husNT1971_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Talchic i inic taja’ al am pulic tiyopan in t’iloxnal in alabental an tiyopan c’al an t’ujub ani c’al patal jahua’ binathits ti c’ac’naxtalab. Tam a Jesús in ucha’chic: ");
INSERT INTO husNT1971_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","―Ne’ets quim baju a q’uicha ca tala’ pacluhuat c’al i inicchic am pulic tiyopan axi xohue’ a tsu’talchic, ma ni jun i t’ujub yab ne’ets ca jilc’on t’i’póx c’al in at t’ujub. ");
INSERT INTO husNT1971_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Tam conoyab a Jesús c’al jaja’chic: ―¿Exobchix, jayq’ui’ ne’ets ca t’ajan antsana’? ¿Jant’o tam tsu’bixtalab qui aychi abal qui exla’ max thubat ne’ets ca taley an q’uij q’uicha? ");
INSERT INTO husNT1971_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","A Jesús in toc’tsiychic: ―Ne’ets ca chich yan i inic ti timc’ox c’al nana’. Ne’ets quin uluchic abal jaja’its a Cristo axi abnenec c’al a Dios ani hue’its ne’ets ca taley an q’uij q’uichacua’. Ca lej t’aja’ ti cuentachic yab quit ts’at’ey c’al jaja’chic abal yab quit c’ambiyat. ");
INSERT INTO husNT1971_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Yab quit jiq’ueychic tam quit t’ilchin i pejextalab ani i jec’omtalab, cum antsana’ ti bijithits abal ne’ets ca thayc’an. Yabaye ne’ets ca thubat taley an q’uij q’uicha. ");
INSERT INTO husNT1971_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Cahue a Jesús in ulu: ―I pulic bichoulom ne’ets ca pejéxin c’al pil i pulic bichoulom. An ts’alechic ne’ets ca tomolnáxin jun c’al xi jun. ");
INSERT INTO husNT1971_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Abal ju’tamq’ui ne’ets ca lej t’elelats an tsabal, ani ne’ets ca hua’tsin an jayil ani yan i yau’lats. Ti eb ne’ets ca tsu’tat i labith t’ajbilab ti tsu’bixtalab axi c’al ne’ets ca lej jiq’uey an inicchic. ");
INSERT INTO husNT1971_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Tam yabaye antsana’ ca t’ajan, oc’oxe tata’chic ne’ets quit othna. Ne’ets quit yac’uan ani quit ne’tha quit ts’ejca ti al in tiyopanilchic an Israel, ani jaye ne’ets quit baliyat al i huic’axte’. Ne’ets quit bina tin c’ubac i ts’alechic ani i gobernadorchic c’al tin ebal nana’ u bij. ");
INSERT INTO husNT1971_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Tam antsana’ quit t’ajchinchic ne’ets ca ejtou tiquin olnanchi u bij tin tamet a tomolnaxilchic. ");
INSERT INTO husNT1971_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Yab quit tsalpaxinchic ani yab ca oc’chith tsalpay jant’ini’ ti ne’ets ca toc’tsiy an jolbixtalab. ");
INSERT INTO husNT1971_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Cum tamna’its nan ne’ets tu pitha’chic i cau ani i tsalap, ani a tomolnaxilchic yab ne’ets quin ela’ jant’ini’ ti toc’tsiy. ");
INSERT INTO husNT1971_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ma a tata ani a mim ani a ebchal, ani a at xits’al, ani a ja’ub ne’ets ti bina’ tin c’ubac a tomolnaxil. Ma talchic tata’ ne’ets quit tsemtha. ");
INSERT INTO husNT1971_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Jat’hua’ tim patalchic an inic ne’ets ti at’a’chic c’al tin ebal nana’ u bij. ");
INSERT INTO husNT1971_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Aba ani’ ne’ets quit t’ajchin antsana’, bel yab ne’ets ca q’uibey ma ni jun a xi’il ta oc’. ");
INSERT INTO husNT1971_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Expith c’al a t’ayath cuxuthtal ne’ets quit jalunthachic. ");
INSERT INTO husNT1971_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Tam ca tsu’uchic tontsimathits am bichou Jerusalén c’al i soldadochic, tam ca lej tso’obna’ abal im bajumalits an q’uicha ne’ets ca talabetha nixe’ xi bichou. ");
INSERT INTO husNT1971_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Tamits ca pit’c’on ani ca c’ale ti ts’en patal ax u c’uajil ti bichoulom Judea ani ti bichou Jerusalén. Ani yab ca huichiy tim bichou ax u t’ojnal alte’. ");
INSERT INTO husNT1971_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Tam quim bajuhuits antsana’ lej yajchic an yajchictalab, jats abal u putnal an T’ocat Thuchlab jant’ini’ ti thuchathits. ");
INSERT INTO husNT1971_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Lej ts’ejhuantal an uxum axi co’oth c’al i tsacam ani i uxum axi chuchuthome c’al i tsacam tam quim baju nixe’ xa q’uicha. Tam ojni’ an inicchic ne’ets ca lej yajchiquiyat ani ca lej t’e’pipin. ");
INSERT INTO husNT1971_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Yantalam ne’ets ca tsemtha ti al i pejextalab ani yantalam ne’ets ca ne’tha huic’at al pil i bichou. Ne’ets ca c’unat co’oyat am bichou Jerusalén c’al i pil inicchic, ma tam ta ca taleyits an q’uij yabats ca jilchin c’al a Dios quin co’oy. ");
INSERT INTO husNT1971_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Tihua’ ti eb a Dios ne’ets quin t’aja’ i labith t’ajbilab ti tsu’bixtalab c’al a q’uicha ani c’al a its’ ani c’al a otchic. Teje’ tsabal patal an inicchic ne’ets ca jilc’on lej c’upupul in tsalap. Ne’ets ca lej jiq’uetha c’al in cahuith am pulic lejem lej tsapic tumumul. ");
INSERT INTO husNT1971_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ne’ets ca lejat luxan an inicchic c’al xi yantalam i c’ac’athtalab axi taye tal, ma patal jahua’ c’uajat ti eb ne’ets ca t’elelats ani yabats ne’ets ca c’uajiy tin aytal. ");
INSERT INTO husNT1971_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ani ma tamits ne’ets quin tsu’tat in tal nana’ tin Juntal patal an inicchic. Ne’ets quin chich al i tocoulom cu tejhua’metha’ u lej tsap ani u lej ts’alat. ");
INSERT INTO husNT1971_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Tam ca tujeyits antsana’ jant’ini’ xo’ tu uchal, ca lej luba’chic tiquin inicna’ cum hue’its tal ne’ets quit lej jum putat jaluntha. ");
INSERT INTO husNT1971_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","A Jesús in olchiyechic q’ue’at i jalpith cau jaye antse’: ―Ca met’a’chic an te’ higuera ani q’ue’at i te’chic jaye. ");
INSERT INTO husNT1971_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Tam ca tsu’u u puthnalits in xequel, tam a exlalits abal hue’its ta tal an c’ac’al q’uij. ");
INSERT INTO husNT1971_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Antsana’ tam tata’chic ca tsu’uchic abal u t’ajnalits patal axe’ jahua’ tu uchamalits ne’ets ca t’ajan, tam ca exla’its abal hue’its nan ne’ets quin chich cu t’aja’ tin lej Ts’ale teje’ tsabal. ");
INSERT INTO husNT1971_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Lej chubax nan tu uchalchic abal yab ne’ets ca thubat taley a juntalchic, ma oc’ox ca t’ajanits patal jahua’ axe’ nan tu olchamalchic. ");
INSERT INTO husNT1971_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","An eb ani an tsabal jats ne’ets ca taley, expith nan u cahuintal ojni’ jats ni jayq’ui’ yab ne’ets ca taley. Ets’ey ne’ets ca putun. ");
INSERT INTO husNT1971_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Ca lej t’aja’chic ti cuenta abal yab ca hualca’ a ichich ca t’ujbathmetha c’al jahuaquitsq’ui tam hualabtalab. Yab quit uts’alin ani yab ca xijc’ath tsalapna’ an yejenchixtalab axi teje’ tsabal. I ca chich nixe’ xa q’uicha tam yab a t’ilt’om. ");
INSERT INTO husNT1971_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Cum jun jic’tohual ne’ets ca chich tim puhuel an tsabal an yajchictalab axe’ nan tu olchamal. ");
INSERT INTO husNT1971_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Quit c’uajiychic ets’ey ts’ejcacath a ichich ani quit ets’ey olon abal ca ejtou quit jaluntha c’al patal nixe’ xi huat’ath c’athpich yajchictalab axi taye tal. Antsana’ ti ne’ets ca ejtou quit utey nana’ tu tamet tin Juntal patal an inicchic tam quin chich junil. ");
INSERT INTO husNT1971_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","U exobchichixe a Jesús ti al an tiyopan tam q’uicha, ani u c’alel ca jilc’on ti al am bolchal Olivos tam acal. ");
INSERT INTO husNT1971_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Chuthel chuthel thajujulaque u che’el jat’hua’ patal am bichou ti al an tiyopan abal quin ats’anchi in exobchixtal a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Hue’its ne’ets quim baju ca ajibnanchat in q’uijil am bichou Israel ti calthame ti Egipto ti biyal. Pel i q’uij tam an Israel quin c’apu i pan axi yab ts’ejcath c’al i c’ac’chixtalab c’oye. ");
INSERT INTO husNT1971_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","An oc’lec pale’chic ani an exobchixchic c’al an ts’ejcath cau binath c’al a Moisés exome in alimichical jant’ini’ ti quin tsemtha’ a Jesús. Aba ani’ in le’acchic quin tsemtha’, bel in ts’ejnal am bichou jant’o quin ulu. ");
INSERT INTO husNT1971_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Tam otsits a Satanás tin ichich a Judas Iscariote. Pel jun axi c’al an lajuj tsab in abathualejil a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","C’ale jaja’ quin tsu’u an oc’lec pale’chic ani axi oc’lec c’al am beletnomchic tiyopan abal quin tauna’chic ani quin juncu an cau jant’ini’ ti quin tsinat bina’ a Jesús tin c’ubac jaja’chic. ");
INSERT INTO husNT1971_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ani lej culbel jaja’chic c’al jahua’ uchan, in uluchic abal ne’ets quim pitha’ i tumin. ");
INSERT INTO husNT1971_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Cum in ulumalits a Judas abal ne’ets quin chi’tha’ a Jesús, ma tamits tin lej alimichical jant’ini’ ti quin tsinat bina’ tin c’ubac in tomolnaxilchic ani yab ca tso’obna c’al am bichou. ");
INSERT INTO husNT1971_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Taley im bajuhuits ca ajibnanchat in q’uijil am bichou Israel ti calthame ti Egipto ti biyal. Ne’ets ca c’apat am pan axi yab ts’ejcath c’al i c’ac’chixtalab c’oye ani ne’ets ca tsemtha an cordero ti ts’acchixtalab. ");
INSERT INTO husNT1971_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Cum a Jesús ne’ets oc’chith quin aba’ a Pedro ani a Juan in ucha’chic: ―Quit c’ale tucu t’ojojonchi an c’apuxtalab tin cuenta in ajib am bichou Israel ti calthame ti Egipto ti biyal. ");
INSERT INTO husNT1971_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ani jaja’chic in conoyal a Jesús: ―¿Ju’tam ta le’ qui t’ojojoy? ");
INSERT INTO husNT1971_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","A Jesús in toc’tsiychic: ―Tam quit otsitsits nihua’ ti bichou Jerusalén, ne’ets ca baju jun i inic in ic’tal i ja’ c’al jun i mul. Jats ti quit c’ale junax ti al an ata jun ti jaja’ ca otsits. ");
INSERT INTO husNT1971_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ca ucha’ an thabal c’al an ata antse’: An Exobchix Jesús ti abchal jun i cau. Ti conoyal abal jahua’ tam alta ta q’uima’ ca matinchi quin t’aja’ an c’apuxtalab junax c’al in exobalilchic tin cuenta in ajib am bichou Israel ti calthame ti Egipto ti biyal. ");
INSERT INTO husNT1971_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Tam jaja’ ne’ets ti olchi jun i pulic alta ts’ejcacathits tim pulic punchith atajil. Tats ta ca t’ojojoychic an c’apuxtalab ajib. ");
INSERT INTO husNT1971_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Tam c’alechic a Pedro ani a Juan, ani in ela’ patal antsana’ jant’ini’ ti uchanits c’al a Jesús, ani tats tin t’ojojoychic patal tin cuenta an c’apuxtalab ajib. ");
INSERT INTO husNT1971_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Im bajuhuits an hora quin c’apuchic, ani buxcan a Jesús ba’ an mexa junax c’al in abathualejilchic. ");
INSERT INTO husNT1971_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ani in ucha’chic: ―C’al u lej canat ichich u lej le’ quin c’aputs junax c’al tata’chic c’al axe xi c’apuxtalab biyat yabaye in tsemthame. ");
INSERT INTO husNT1971_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Nan tu uchalchic abal yabats ne’ets cu c’apu xe’ ejtil u t’ajal xo’. Ma tihua’ talbelaquits tam ti a Dios quin t’aja’ ti lej Ts’ale, tam tiq’uele cu c’apu xe’ junil tam ca quithat putunits in ey axe’ xi c’apuxtalab. ");
INSERT INTO husNT1971_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Tam a Jesús im pena’ an uts’umtalab c’al an vino ani im bina’ i c’ac’namal c’al a Dios. In ucha’chic in abathualejilchic: ―Ca bats’uchic axe’ ani ca uts’a’. ");
INSERT INTO husNT1971_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Nan tu uchalchic abal yabats ne’ets cu uts’a’ an vino lab t’uthub c’al tata’chic ejtil u t’ajal xo’. Ma tihua’ talbelaquits tam ti a Dios quin t’aja’ ti lej Ts’ale, tam ne’ets cu uts’a’ junil. ");
INSERT INTO husNT1971_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Tam a Jesús im pena’ am pan ani im bina’ i c’ac’namal c’al a Dios. In mu’u ani im pitha’ in abathualejilchic, ani in ucha’chic: ―Axe’ pel u anam t’u’ul axi ne’ets cu bina’ ti al an cruz abal quit paculanchat a hualabchic. Ca c’apuchic, ani antsana’ tiquin t’ila’. ");
INSERT INTO husNT1971_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Tam ti c’apumathitschic, a Jesús in ulu antse’ tin cuenta an vino: ―Axe’ pel u xits’al axi ne’ets quin huac’lanchat ti al an cruz abal quit paculanchat a hualabchic. C’al tin ebal u huac’lath xits’al a Dios ne’ets quin ts’ejca’ i it jilchith cau c’al an inicchic. ");
INSERT INTO husNT1971_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","C’uajatits c’al nana’ teje’ ti al an mexa jaja’ axi ne’ets tiquin tsinat bina’ tin c’ubac u tomolnaxilchic. ");
INSERT INTO husNT1971_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Pel nana’ tin Juntal patal an inicchic, ani chubax ne’ets quim bina ani quin tsemtha jant’ini’ tim bijchithits. Expith lej c’athpich ts’ejhuantal nixe’ xi inic axi ne’ets tiquin tsinat bina’, cum ne’ets ca lej yajchiquiyat. ");
INSERT INTO husNT1971_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Tam in ts’i’quiychic ti conóx jun c’al xi jun, jita’ hualam jaja’chic axi ne’ets ti tsinat binom c’al a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Tam in abathualejilchic a Jesús u t’ilom tin cuenta abal jita’ c’al jaja’chic lej c’athpich pulic in ey. ");
INSERT INTO husNT1971_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ani uchanchic c’al a Jesús: ―An ts’alechic c’al am bichoulom u tsapic abatnom ani an oc’lecchic u bijiyab ti patrón. ");
INSERT INTO husNT1971_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Yab in tomnal tata’chic antsana’ ca t’aja’ jayetseq’ui. Jitats lej c’athpich pulic in ey c’al tata’chic, quin t’aja’ ejtil i cuitol axi yab lej pulic tim ba’. Axi oc’nom c’al tata’chic, quin co’oy in ichich ti tolmix. ");
INSERT INTO husNT1971_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Jahua’ axi lej c’athpich pulic in ey, axi quetel ti mexa ti c’apul o ax u pijchix c’al jaja’? Yab i jats axi quetel ti mexa ti c’apul. Ca t’aja’chic ti cuenta abal nana’ in c’uajat c’al tata’chic tin tolmix. ");
INSERT INTO husNT1971_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Chuthel chuthel tata’chic it junax xe’tsinenec c’al nana’ biyat cu tala’ yajchicna’ an yajchictalab. ");
INSERT INTO husNT1971_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Jaxtam nan ne’ets tu punu tit ts’alechic jant’ini’ nana’ u Tata ti eb tim punumalits nana’. ");
INSERT INTO husNT1971_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ne’ets quit c’aputschic tu mexajil tam nan cu t’aja’ tin lej Ts’ale. Ne’ets quit buxcanchic al i ts’alat lactem ca ts’ejca’ axi lajuj tsab i cuenel an Israelchic. ");
INSERT INTO husNT1971_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Cahue an Ajatic in ulu: ―Simón Simón, ca lej t’aja’ ti cuenta cum a Satanás in lej le’ ti quinoc’na’ abal max yabats tiquim bela’ nana’. ");
INSERT INTO husNT1971_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ani nan tu conchinchamalits c’al a Dios abal nana’ tiquin junini’ bela’. Bel ne’ets quit ohuey hue’ yab quit ts’at’ey c’al nana’, ani talbel quit huichits c’al nana’ ca lej tsaplinchi in ichich an ebchalabchic abal jaja’chic jaye tiquin junini’ bela’ nana’. ");
INSERT INTO husNT1971_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Toc’tsin a Pedro: ―In ts’ejcacathits quin jolohuat ti al an huic’axte’ ani ma quin tsemtha c’al tin ebal a bij. ");
INSERT INTO husNT1971_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Tam uchan c’al a Jesús: ―Pedro, nan tu uchal abal xo’ ne’ets ca tsinca’ ta ba’ c’al nana’ oxil i calat ma tam ti ibaque thajnenec an coxol. ");
INSERT INTO husNT1971_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Tam a Jesús in ucha’ in abathualejilchic: ―Tiquin ucha’ max a yejenchiye jant’o tam nan tu aba’ ti jayq’ui’ tit caulomechic naptal. Yab a xe’tsintha’ i morral, ni i tumin, ni i pajab. Toc’tsinchic: ―Ni jant’o yab i yejenchi. ");
INSERT INTO husNT1971_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Tam uchanchic c’al a Jesús: ―Ma xohue’ yabats quit xe’tsinchic naptal. Ca xe’tsintha’ i morral ani i tumin. Max yab a cua’al i matset, ca nuju a pulic coton ani ca ts’a’iy. ");
INSERT INTO husNT1971_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Nan tu uchalchic abal pel in uchbil ca putun an T’ocat Thuchlab jant’ini’ tin thuchathits nana’ taja’ antse’: Tsalpanchat jaja’ ti pojcax inic. Ani ne’ets chubax quin tala’ t’ajchin jant’ini’ tim bijchithits ti al an T’ocat Thuchlab. ");
INSERT INTO husNT1971_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Tam uchan a Jesús c’al in abathualejilchic: ―Ajatic, te i cua’al tsab i matset. Toc’tsin a Jesús: ―Lejatits c’al xi tsablom. ");
INSERT INTO husNT1971_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Tam c’ale a Jesús c’al in exobalilchic ti al am bolchal Olivos, cum tihua’ in ujnam antsana’ ca c’ale. ");
INSERT INTO husNT1971_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ulitschic taja’, ani a Jesús in ucha’chic: ―Quit olonchic abal yab ti ata’ an teneclab. ");
INSERT INTO husNT1971_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Tam a Jesús tixc’an c’al jaja’chic ani belats hue’. In ohuel im bajuhual ejtil tam ca pet’na jun i t’ujub c’al i inic. Taja’ in tuthu in c’ualal ani olon. ");
INSERT INTO husNT1971_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","In ulu: ―Tata ti eb, max pel a culbetal tiquin jaluntha’ abal yab cu yajchicna’ an yajchictalab axi taye tal. Ani max i, bel u lej le’ tu t’ajchi a culbetal ani yab u cuete’ culbetal. ");
INSERT INTO husNT1971_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Tam chich jun i angel tal ti eb quin tsapliy a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Cum lej huat’ath c’athpich yajchic in ichich, jaxtam más tsapic u ol. Ani ma lej ts’acbinal, ejtil max pel i xits’ u t’ucnal tsabal. ");
INSERT INTO husNT1971_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Talits ti ol ani huichiy jun ti c’uajat in exobalilchic. In tsu’uchic huayamath, cum lejat atathits c’al i t’e’pintalab. ");
INSERT INTO husNT1971_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Tam a Jesús in ucha’chic: ―¿Jale’ it huayamathchic? Quit ts’aquiy ani quit olon abal yab ti ata’ an teneclab. ");
INSERT INTO husNT1971_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Exome ti cau a Jesús c’al in exobalilchic tam ti ulitsits jun i cuenel i inic. An oc’nom pel a Judas axi ajith c’al xi lajuj tsab in exobalil a Jesús. Utey c’al a Jesús abal quin ts’uts’bay. ");
INSERT INTO husNT1971_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Tam uchan c’al a Jesús: ―Nana’its pel tin Juntal patal an inicchic. Tata’ ojni’ Judas a le’ tiquin ts’uts’bay ejtilac max tin c’anithal, ani bel ne’ets tiquin tsinat bina’ tin c’ubac u tomolnaxilchic. ");
INSERT INTO husNT1971_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","In exobalilchic in tsu’u jant’o ne’ets ca t’ajchin a Jesús ani in conoy: ―¿Ajatic, a le’ abal qui t’aq’uiychic c’al i matset? ");
INSERT INTO husNT1971_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Tam jun in exobalil a Jesús in muts’q’uinchi in huinab xutsun in tolmixal an ts’ale pale’. ");
INSERT INTO husNT1971_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ani uchan c’al a Jesús: ―Iba yab antsana’ ta ca t’aja’chic. Tam a Jesús in tacchi jun ti muts’q’uith in xutsun ani in jelthanchi t’ajat. ");
INSERT INTO husNT1971_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Taley a Jesús in tauna’ an oc’lec pale’chic ani an oc’lecchic beletnom tiyopan ani an yejtselabchic Israel axi che’nequits abal quin ne’tha’. In ucha’chic: ―Tata’ ojni’ it che’necchic c’al i matset ani c’al i te’chic abal tiquin yac’ua’ ejtil max nan pel in cue’. ");
INSERT INTO husNT1971_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Chuthel chuthel in c’uajatac ti al an tiyopan ani yab tin yac’ua’ taja’. Ma xohue’ im bajuhuits an hora quit chich tiquin yac’ua’, cum it jum putat c’uajat al an yic’uax ani it lej co’oyab c’al an teneclab. ");
INSERT INTO husNT1971_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Tam yac’uan a Jesús ani ne’tha tin q’uima’ an ts’ale pale’, ani a Pedro ta tale ts’at’at hue’ ou. ");
INSERT INTO husNT1971_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Taja’ ti al am patio tin q’uima’ an ts’ale pale’ hua’ats i c’amal, ani buxcanal taja’ i inicchic toninil al an c’amal. Ulitsits a Pedro ani buxcan jaye. ");
INSERT INTO husNT1971_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Tam jun i cuthinel in tsu’u quetel a Pedro utat ba’ an c’amal. In lej met’al, ani in ulu: ―Axe’ xi inic pel i ts’at’el c’al jaja’ axi te chi’thame. ");
INSERT INTO husNT1971_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","A Pedro in tsinca’ tim ba’, in ulu: ―Uxum, nana’ iba yab u exlal jaja’. ");
INSERT INTO husNT1971_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Hue’ talbel tsu’tat a Pedro c’al junaque ani uchan jaye: ―Tata’ ojni’ it junax xe’tsinenec c’al in ts’at’elilchic axe’ xi inic. Toc’tsin a Pedro: ―Iba yab ja nana’. ");
INSERT INTO husNT1971_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Jun i hora talbel q’ue’at i inic in ulu jaye: ―Lej chubax axe’ xi inic xe’tsinenec c’al jaja’ axi xo’ chi’thame. Pel i Galileajib jaye. ");
INSERT INTO husNT1971_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Tam a Pedro in ucha’: ―Nan yab u exlal jant’o a ulal antsana’. Tameq’ui biyat cahue a Pedro, thajnalits jaye an coxol. ");
INSERT INTO husNT1971_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Tam huilq’uin an Ajatic quin met’a’ a Pedro, ani tamits in t’ilpa’ jahua’ uchnenec c’al an Ajatic abal ne’ets quin tsinca’ tim ba’ oxil i calat tam ti ibaque thajnenec an coxol. ");
INSERT INTO husNT1971_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ani cale a Pedro taja’ lej tsapic uc’nal. ");
INSERT INTO husNT1971_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Tam tilibnab a Jesús ani u cuathnal c’al an inicchic axi c’al tu co’oyab. ");
INSERT INTO husNT1971_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Paxq’uinchab in hual ani mo’canchab i c’ubaclec tin hual. Uchan: ―Tucu olchi jita’ ti cuatha’. ");
INSERT INTO husNT1971_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ani c’al lej yane i cau othnab a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Tam ti chutheyits tamcun an yejtselabchic Israel ani an oc’lecchic pale’ ani an exobchixchic c’al an ts’ejcath cau binath c’al a Moisés. In juncuchic an cau ani in ne’tha’ a Jesús c’al an cuenel axi c’athpich in ey an ts’ejcom cau tin cuenta an tiyopanchic Israel. Taja’ conoyab: ");
INSERT INTO husNT1971_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","―¿Pel it Cristo? Tucu ucha’ max tata’its. Toc’tsin jaja’: ―Max nan tu uchalacchic abal nana’ ojni’ ja’its, bel yab ne’ets ca bela’. ");
INSERT INTO husNT1971_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Max nan tu conchalac i cau yab ne’ets tiquin toc’tsiy ani yab ne’ets tiquin hualca’. ");
INSERT INTO husNT1971_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Lej hue’its nana’ tin Juntal patal an inicchic ne’ets quin c’uajiy tin huinab ocob a Dios ti eb ax in cua’al patal in cuete’ tsap. ");
INSERT INTO husNT1971_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ani patalchic in conoyal a Jesús: ―¿Tam tata’its pel ti lej Tsacamil a Dios? Toc’tsin a Jesús: ―Nana’ ja’its ojni’ ax a ulalchic. ");
INSERT INTO husNT1971_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Tam in uluchic: ―Xohue’its huahua’ putat i lejat ats’amal jahua’ antsana’ in lej ulu c’al qui jolbiy. Yabats i yejenchal jita’ tucu olchiye más i cau. ");
INSERT INTO husNT1971_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Taley patal axi muthatchic taja’ c’ale, in ne’thal a Jesús c’al a Pilato. ");
INSERT INTO husNT1971_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ani taja’ tin tamet a Pilato in ts’i’quiychic quin jolbiy a Jesús. In uluchic: ―I ats’amalits axe’ xi inic pel i q’uibts’oth exobchix c’al huahua’ tu Israel. Yab pelcua’ i uchbil qui jalbinchi an ts’ale oc’lec romano an jalbixtalab tumin. Jaja’cua’ ja’its a Cristo axi abath c’al a Dios ti Ts’ale c’al an inicchic. ");
INSERT INTO husNT1971_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Tam conoyab a Jesús c’al a Pilato: ―¿Tata’its pel ti Ts’alejil an Israelchic? Toc’tsin a Jesús: ―Nana’ ja’its ojni’ ax a ulal. ");
INSERT INTO husNT1971_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Tam a Pilato in ucha’ an oc’lecchic pale’ ani patal axi muthat taja’: ―Ni jant’o yab u elchal jahua’ yab alhua’ axe’ xi inic abal ca jolbiychic. ");
INSERT INTO husNT1971_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ani lej pajamix an mulcunel in ulu: ―Tocat in t’ajal abal ca xacueculats an inicchic tim puhuel am pulic bichoulom Judea c’al in exobchixtal. Ti c’a’al in ts’i’quiy ti exobchix tihua’ ti pulic bichoulom Galilea, ani xohue’ chich ma teje’ c’al in exobchixtal. ");
INSERT INTO husNT1971_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Cum a Pilato in ats’a’ abal in uluchic Galilea, in conoy max a Jesús pel i Galileajib. ");
INSERT INTO husNT1971_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Cum olchin abal ja’its, tam in aba’ ca ne’tha c’al a Herodes axi c’uajat ti Jerusalén nixe’ xa q’uicha. Cum pel jaja’ an gobernador ax ti Galilea. ");
INSERT INTO husNT1971_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ani lej culbel a Herodes tam tin tsu’u a Jesús, cum ohuatits tin le’namal quin tsu’u. In ats’amalits lej t’ilnal, ani in lej le’ max quin tsu’u quin t’aja’ i labith t’ajbilab. ");
INSERT INTO husNT1971_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ani lej conomichiquix a Herodes c’al a Jesús, tocat yab toc’tsiyab. ");
INSERT INTO husNT1971_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Taja’ c’uajat jaye an oc’lecchic pale’ ani an exobchixchic c’al an ts’ejcath cau binath c’al a Moisés lej pajamix ti jolbix c’al a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Lej alalnab ani tilibnab Jesús c’al a Herodes ani c’al in soldadojilchic. Alq’uith toltomiyab c’al i ts’alat nacat coton ejtilac max pel i ts’ale. Taley a Herodes in aba’ an cau ca huichba c’al a Pilato. ");
INSERT INTO husNT1971_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Aba ani’ ti jayq’ui’ c’uiyax a Pilato c’al a Herodes, ma tam nixe’ xa q’uicha ja’ubnax. ");
INSERT INTO husNT1971_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Tam a Pilato in tamcuy an oc’lecchic pale’ ani an oc’lecchic bichou ani axi q’ue’atchic al am bichou. ");
INSERT INTO husNT1971_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","In ucha’chic: ―Te a chi’thamalchic axe’ xi inic q’uibts’oth exobchixcua’. Nan u conomichiquiyamal ta tametchic jant’o tam hualabtalab in t’ajamalac, ani yab u elchamal ni jant’o abal ca ejtouchic ca jolbiy. ");
INSERT INTO husNT1971_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Aniye jaye yab elchinenec c’al a Herodes jant’o c’al ta ca jolbiyat. Ca lej t’aja’ ti cuenta abal ni jant’o yab in t’ajamal yab alhua’ abal ca tsemtha. ");
INSERT INTO husNT1971_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Expith u ulal ca huithc’oyat, ani tam ne’ets cu hualca’. ");
INSERT INTO husNT1971_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Antsana’ pel i ujnamtalab ca hualca jun i huic’nel tam u t’ajnal an ajib tin cuenta abal calthame am biyal bichou Israel ti Egipto. ");
INSERT INTO husNT1971_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ani patal an mulcunel tocat in thajat uluchic: ―Ca tsemtha axe’ xi inic. A Barrabás jats ca hualca’. ");
INSERT INTO husNT1971_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","C’uajat a Barrabás ti al an huic’axte’ cum pejexnenequits c’al an oc’lecchic ani tsemthomamathits. ");
INSERT INTO husNT1971_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Cum a Pilato in le’ quin hualca’ a Jesús, in tsab tauna’ an mulcunel junil. ");
INSERT INTO husNT1971_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Tocat c’athpich thajat toc’tsin: ―Ca t’ajat bina’ ca q’uet’ath tsemtha ti al an cruz. ");
INSERT INTO husNT1971_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Oxchilab calat a Pilato in ucha’chic: ―¿Jant’o tam lej hualabtalab in t’ajamalac? Ni jant’o yab u elchal abal cu bina’ ca tsemtha. Expith ca huithc’oyat, ani tam ne’ets cu hualca’. ");
INSERT INTO husNT1971_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Lej pajamixe an mulcunel, in thajat uluchic ca q’uet’ath tsemtha a Jesús ti al an cruz. Taley a Pilato in ucha’ an mulcunel ani an oc’lecchic pale’ abal bel ne’ets quin t’aja’ jant’inits jaja’chic in le’. ");
INSERT INTO husNT1971_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Antsana’ a Pilato tim bina’ in cahuintal jant’ini’ ti uchenec c’al an mulcunel. ");
INSERT INTO husNT1971_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Tam im bina’ a Jesús c’al an mulcunel ca tsemtha jant’ini’ ti le’nab c’al jaja’chic, ani in hualca’ a Barrabás jant’ini’ ti le’nab ca hualca c’al an mulcunel. Pel jaja’ axi c’uajat ti al an huic’axte’ cum pejexnenequits c’al an oc’lecchic ani tsemthomamathits. ");
INSERT INTO husNT1971_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Tam ti ne’ets ne’thabits a Jesús ti bel abal ca tsemtha, tal jun i inic im bij Simón axi pel i Cirenejib. Tal eleb ti al am bichou ani u aynalits. Jats punuhuat c’al an soldadochic abal quin quitnanchi an cruz ax in quitnal a Jesús ani ca ts’at’ey tin cux a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","An ts’at’elchic hua’ats yantalam, ani yan i uxum in thajat uc’nanchal a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ani a Jesús tocat in met’al an uxumchic, ani in ucha’: ―Tata’chic uxum Jerusalénibchic, yab tiquin uc’nanchi, expith ca uc’nanchi a tsacamilchic ani quit cuete’ uq’uin ta ba’. ");
INSERT INTO husNT1971_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Cum ne’ets quim baju an q’uichachic lej yajchictalab. Ne’ets quin ulu an inicchic: Lej alhua’talab max i uxum yab quin ejtou quin co’oy i tsacam ani max i uxum yab chuchuthom. ");
INSERT INTO husNT1971_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ne’ets quin tauna’ an ts’enchic ani an t’ec’at bolchalchic quin ulu: Quit ijcan c’al huahua’ abal tucu t’ajat tsa’cuy, quin uluchic. ");
INSERT INTO husNT1971_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Nana’ yab in hualbith ani bel ne’ets quin lej yajchiquiyat, ani al nixe’ xa q’uicha taye tal axi hualbith ne’ets ca más c’athpich yajchiquiyat. ");
INSERT INTO husNT1971_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","An soldadochic in ne’thal jaye tsab i jolbinel quin tsemtha’ junax c’al a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Taley ultsitschic al jun i c’uajattalab im bij Tam’oc’, ani tats ti q’uet’an a Jesús ti al an cruz. Antsana’ jaye t’ajchin nixe’ xi tsab i jolbinel, jun jilchin tin huinab a Jesús ani axi jun tin c’uatab. ");
INSERT INTO husNT1971_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Tam ti q’uet’athits a Jesús ti al an cruz olon, in ulu: ―Tata ti eb, ca paculanchi axe’ xi inicchic cum yab in exlal jant’o in t’ajalchic. Ani an soldadochic tocat in calthal i q’uij jant’ini’ quin c’alnanchi in toltomil a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","An mulcunel tocat in met’alq’ui a Jesús, ani an oc’lecchic in tilibnath ulu: ―In jec’onthamal q’ue’atchic i inic. Max chubax pel a Cristo lej tacuth c’al a Dios, xohue’its quin jec’ontha’ tim ba’ jaye. ");
INSERT INTO husNT1971_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ani u tilibnax an soldadochic jaye c’al a Jesús. Uteychic im pitha’ i tsa’ic vino quin uts’a’. ");
INSERT INTO husNT1971_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ani tilibnath uchan c’al jaja’chic: ―Max chubax tata’its it Ts’ale c’al an Israel, ca jec’ontha’ ta ba’. ");
INSERT INTO husNT1971_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Tin oc’ an cruz punchithits i thuchlab jolbixtalab thuchath ti griego cau, ani ti latín cau, ani ti hebreo cau. In ulal antse’: Ja’its axe’ in Ts’alejil an Israelchic. ");
INSERT INTO husNT1971_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Jun axi tsab an jolbinel q’uet’ath jaye al an cruz in tilibnath ucha’ a Jesús: ―Max chubax pel it Cristo, ca jec’ontha’ ta ba’ ani tucu jec’ontha’hue. ");
INSERT INTO husNT1971_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Tam jaja’ c’uiyath uchan c’al axi junaque an jolbinel antse’: ―Tata’ ojni’ te it q’uet’athits al an cruz jant’ini’ jaja’. ¿Bel yab a ts’ejnal a Dios? ");
INSERT INTO husNT1971_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Huahua’ exom i yajchicnal an yajchictalab jahua’ in tomnal qui yajchicna’, cum expith i jalbiyal an hualabtalab jahua’ i t’ajamal, ani jaja’ yab in ne’thal ni jun i hualabtalab. ");
INSERT INTO husNT1971_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Tam jaja’ in ucha’ a Jesús: ―Tiquin t’ila’ne tam ca t’aja’its tit lej Ts’ale. ");
INSERT INTO husNT1971_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Toc’tsiyat c’al a Jesús: ―Chubax nan tu uchal abal xo’ ne’ets quit junax c’uajiy c’al nana’ tin ts’alat c’uajattal a Dios ti eb. ");
INSERT INTO husNT1971_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Im bajuhuits ts’ejel q’uicha ani tam tala’ yic’utsin tim puhuel an tsabal, ani antsana’ jilc’on ma ti ox hora an huacal. ");
INSERT INTO husNT1971_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","A q’uicha yab im bina’ in tajax. Ani cathlun am pelcath toltom ba’ am pulic tiyopan. Jilc’on tsab i pejach. ");
INSERT INTO husNT1971_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Tam a Jesús in lej tsapic ulu: ―Tata ti eb, nan tu jilchal u ejattal ta c’ubac. Tam tin expith ulu antsana’, tam ti tsemetsits. ");
INSERT INTO husNT1971_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","An capitán c’al an soldadochic in tsu’u antsana’ tsemetsits a Jesús, ani im puhuethanchal im bij a Dios. In ulu: ―Lej chubax axe’ xi inic yab in ne’thal ni jun i hualabtalab. ");
INSERT INTO husNT1971_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Tam an inicchic axi muthat taja’ quin met’a’ a Jesús, ta c’alechic in cuathcuayal in ichich c’al i lej t’e’pintalab. ");
INSERT INTO husNT1971_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Expith jilc’on quin met’a’ hue’ ou a Jesús patal axi exlomchic c’al jaja’ junax c’al i uxumchic axi ts’at’enec c’al jaja’ tam ti xe’etsac ti Galilea. ");
INSERT INTO husNT1971_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","C’uajatac jun i inic alhua’ ani pututh im bij José. U c’uajil ti Arimatea axi cuentalith ti Judea. Pel i ts’ejcom cau c’al an cuenel axi c’athpich in ey an ts’ejcom cau tin cuenta an tiyopanchic Israel. ");
INSERT INTO husNT1971_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Jaja’ in junini’ aychal a Dios ca chich quin t’aja’ ti lej Ts’ale teje’ tsabal. Yab in culbetnanchal abal jolbiyame a Jesús c’al in juntalchic al nixe’ xi cuenel ts’ejcom cau. ");
INSERT INTO husNT1971_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","C’ale quin conchi a Pilato in inictal a Jesús quin joliy. ");
INSERT INTO husNT1971_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Cum uchan bel quin ne’thanchi, c’ale im pa’banchi in inictal a Jesús ti al an cruz ani in thu’bay c’al i putat toltom. In mo’canchi al i jolimtalab tsajath jol paxal t’ujub. Taja’ yabaye jita’ joliyame. ");
INSERT INTO husNT1971_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Pel i viernes tam ti t’ojojol am bichou Israel tin cuenta an sábado, ani hue’its ne’ets quim baju an sábado. ");
INSERT INTO husNT1971_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Hua’ats i uxumchic axi ts’at’enec c’al a Jesús ma tam ti xe’etsac jaja’ ti Galilea. C’alechic ani in tsu’u ju’ta ti mo’cathits in inictal a Jesús ti al an jolimtalab. ");
INSERT INTO husNT1971_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Taley huichiychic tin q’uima’ in t’ojojoyal i nihuihuiltalab ani i ilal quin ne’tha’ jun ti jolith a Jesús. Tam tin cua’alits t’ojojothits, pelits an sábado. Tam coyotschic, cum antsana’ bijithits quin t’aja’ c’al an ts’ejcath cau binath c’al a Moisés. ");
INSERT INTO husNT1971_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Pel an c’a’al q’uicha semana lej thajujul tam ti ne’ets junil nixe’ xi uxumchic ti al an jolimtalab jun ti jolith a Jesús, ani junax ne’ets q’ue’atchic i uxum jaye. In ne’thal an nihuihuiltalab ani an ilal ax in t’ojojoyamalits. ");
INSERT INTO husNT1971_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ulitschic ani in tsu’u tixc’athits am pulic paxic’lab t’ujub tin otsnamtal an jolimtalab. ");
INSERT INTO husNT1971_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Otsitschic, ani xant’o in inictal an Ajatic Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Tam tocat lej jiq’uelchic, yab in exlal jant’o quin t’aja’. Tam in tsu’uchic cubat tsab i ángel lej ts’umimil in toltomil. ");
INSERT INTO husNT1971_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Cum lej c’athpich jiq’uelchic, in cutpal in oc’ tsabal. Tam uchanchic: ―¿Jale’ ta aliyalchic teje’ c’al an tsemelomchic axi ejat? ");
INSERT INTO husNT1971_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Cum ejthachits a Jesús yabats c’uajat teje’. Ca t’ila’chic jant’ini’ jaja’ ti uchamalits tam tit c’uajatchic tihua’ ti Galilea. ");
INSERT INTO husNT1971_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","In ulu: Nana’its pel tin Juntal patal an inicchic im bijchithits quim bina tin c’ubac i hualbith inicchic. Ne’ets quin q’uet’ath tsemtha ti al an cruz ani oxchilab q’uicha ne’ets quin ejtha, in ulu. ");
INSERT INTO husNT1971_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ma tamna’its in t’ilalchic abal anits chubax tin ulumal a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Tam ta c’alechic ani u aynalits. Ulitschic c’al xi lajuj jun in abathualejilchic a Jesús ani q’ue’atchic axi muthat c’al jaja’chic, in tala’ olchalchic jahua’ olchinenec c’al an ángelchic. ");
INSERT INTO husNT1971_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Pel a María Magdalajib, ani a Juana, ani a María in mim a Jacobo, ani q’ue’at i uxumchic axi antsana’ u olchixchic. ");
INSERT INTO husNT1971_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Cum an abathualechic in tsalpayal abal hualam pel i cau axi c’al i olmanal, jaxtam yab im belchal. ");
INSERT INTO husNT1971_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Bel c’ale a Pedro ti athil tihua’ ti al an jolimtalab. Ulits ani otsits, in tsu’u expith mo’ol an malilil toltom in thu’bal a Jesús. Taley u aynalits tam c’al in ichich lej jic’pax. ");
INSERT INTO husNT1971_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Jayetseq’ui nixe’ xa q’uicha tsab in exobalil a Jesús ne’etsits al i bel ca ulitschic al i bichou im bij Emaús. Ma ti Emaús ani ma ti Jerusalén jat’hua’ lajuj jun i kilómetro. ");
INSERT INTO husNT1971_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ne’ets im belal t’iloxnalchic jahua’ in ats’amal ani jahua’ in tsu’umal tin cuenta a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ani biyat antsana’ u t’ilomchic, tam utey a Jesús ani ts’at’ey c’al jaja’chic. ");
INSERT INTO husNT1971_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Yabaye in exlalchic max pel a Jesús, cum antsana’ ti bijithits yabaye quin exla’. ");
INSERT INTO husNT1971_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Taley a Jesús in conoyalchic: ―¿Jant’o hualam ax a t’iloxnalchic abal it lej t’e’pith? ");
INSERT INTO husNT1971_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Tam toc’tsin jun jaja’ ax im bij Cleofas: ―Patal an inicchic in tso’obits jahua’ t’ajnenec ti Jerusalén axe’ xa q’uichachic. Auxe’ max tata’ yab a tso’ob jaye. ");
INSERT INTO husNT1971_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Tam a Jesús in toc’tsiy: ―¿Jant’o ax a ulu t’ajnenec ti Jerusalén? Toc’tsinchic: ―Pel xe’ tin cuenta a Jesús Nazaretib axi pelac i caulome c’al a Dios lej huinat in ahuiltal. Antsana’ ti exla c’al a Dios ani c’al an inicchic, tin ebal in labith t’ajbil ani tin ebal in tsalpath cahuintal. ");
INSERT INTO husNT1971_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Aba ani’ pel i caulome, bel bina jaja’ tin c’ubac a Pilato c’al an oc’lecchic pale’ ani c’al i oc’lequilchic abal ca jolbiyat ani ca q’uet’ath tsemtha ti al an cruz. ");
INSERT INTO husNT1971_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Xohue’ pelits an oxchilab q’uicha ti tsemthame. Jats jaja’ ax i aychamalac abal tucu hualcantha’ c’al i tomolnaxilchic, cum hua’ats jita’ bijithits ca chich c’al huahua’ tu Israel tucu hualcantha’. ");
INSERT INTO husNT1971_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Talchic i uxum axi belom ejtil huahua’, c’alechic thajujul quin tsa’biy an jolimtalab jun ti joliyame a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Huichiychic c’al i lej jic’path olchixtalab. Yab in tsu’chi in inictal. In tsu’ucua’ tsab i ángel, ani jats c’al ti olchin jaja’chic abal ejthachits a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Taley talchic i juntal c’ale jaye ti al an jolimtalab, ani jats in ulu jaye jayetseq’ui yab in tsu’chi in inictal a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Tam a Jesús in ucha’chic: ―Tata’ ojni’ it macu’chic a tsalap. Lej bomomol a ichich abal ca tala’ belchi in thuchath cahuintal in caulomejilchic a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ma ti biyalits bijithits abal a Cristo quin oc’ox yajchicna’ teje’ tsabal, ani talbel ca huichiy ti eb ca puhuethanchat im bij c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Tam a Jesús in lejquinchalchic patal an cau jant’ini’ tu olnab jaja’ ti al an T’ocat Thuchlab. In ts’i’quiy c’al an cau axi thuchath c’al a Moisés ani tin aytal in tala’ lejquinchal an cau jun tu olnab jaja’ c’al patal in caulomejilchic a Dios ti jayq’ui’. ");
INSERT INTO husNT1971_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Tam ti ultsitschic ti bichou Emaús, a Jesús in t’aja’ ejtil max ne’ets quin aynaye más am bel ca c’ale. ");
INSERT INTO husNT1971_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ani jaja’chic im pajamith ucha’ a Jesús: ―Quit lej jilc’on c’al huahua’ teje’, cum hue’its ne’ets ca lejat aclejits. Tam otsits a Jesús al i ata c’al jaja’chic ca jilc’on. ");
INSERT INTO husNT1971_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Tam ti quetelits ti c’apul ti al an mexa im pena’ am pan ani im bina’ i c’ac’namal yan c’al a Dios. In mu’u ani pithan jaja’chic. ");
INSERT INTO husNT1971_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Tameq’ui ti lamc’anchatchic in ichich ani in exla’its abal ja’its pel a Jesús. Tameq’ui jun jic’tohual xant’o a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Tam in cuete’ uluchic: ―¿Yab i lej chubax ti ats’amal lej canatbethach i ichich tam tu tal ti bel tu lejquinchal an T’ocat Thuchlab? ");
INSERT INTO husNT1971_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Tam thubat c’alechic ani huichiy ti Jerusalén. Taja’ in ela’ tamcuthchic axi lajuj jun in abathualejilchic a Jesús c’al q’ue’at i belomchic jaye. ");
INSERT INTO husNT1971_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ani uchanchic xi tsablom: ―Lej chubax ejthame an Ajatic, cum tsu’umejits c’al a Simón. ");
INSERT INTO husNT1971_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Tam nixe’ xi tsab an exobal in olchalchic axi muthat taja’ jant’ini’ ti t’ilmats jaja’chic c’al a Jesús ti bel, ani jant’ini’ tin exla’its tam tin mu’uhual am pan. ");
INSERT INTO husNT1971_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Exome ti olchixchic, tam jun jic’tohual chich a Jesús c’al jaja’chic. In tsapnethalchic ani in ucha’: ―Nan tu pithalchic ta ichich i jun ejettalab. ");
INSERT INTO husNT1971_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Tam lej jiq’uelchic, cum in tsalpayal hualam pel i labax ax in tsu’umal. ");
INSERT INTO husNT1971_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","A Jesús in ucha’chic tam: ―¿Jale’ ti t’elelelchic a ichich ani jale’ a cua’al i hualamtalab ta ichich c’al nana’ u ey? ");
INSERT INTO husNT1971_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Tiquin met’anchi u c’ubac ani u acan abal nana’its ax tin tsu’tal. Tiquin taca’ ani tiquin met’a’ abal tiquin exla’ abal nana’its ax u cua’al u anam t’u’ul ani u beclac. Abal nana’ yab in labax jant’ini’ tata’ tin tsalpanchalchic u ey. ");
INSERT INTO husNT1971_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Tam tin olna’its tim ba’ antsana’ a Jesús, tamna’ in lej tejhua’methanchalchic in c’ubac ani in acan. ");
INSERT INTO husNT1971_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ani tam lej c’athpich culbelchic ani lej huat’ath c’athpich jic’pax, ma yabaye in ejtohualchic quin thubat bela’. Tam a Jesús in conoyalchic: ―¿A cua’alchic teje’ jant’o ca c’apu? ");
INSERT INTO husNT1971_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Tam pithan a Jesús pejach i huiyath to’ol ani pejach i ocou c’al in tsi’mal. ");
INSERT INTO husNT1971_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ani in c’apu tin tamet jaja’chic. ");
INSERT INTO husNT1971_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Tam a Jesús in ucha’chic: ―Jahua’ nan in t’ajchinenequits jats jahua’ nan tu uchamalchic tam ti nan in lej xe’tsin c’al tata’chic. Pel in uchbil ca tala’ putun an T’ocat Thuchlab jant’ini’ tin thuchathits nana’ ti al an ts’ejcath cau binath c’al a Moisés, ani tin thuchath uhuil in caulomejilchic a Dios, ani ti al an salmochic. ");
INSERT INTO husNT1971_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Tam a Jesús in lamc’anchichic in ichich abal quin tequeth ejtiy an T’ocat Thuchlab. ");
INSERT INTO husNT1971_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","In ucha’chic: ―In thuchathits ti al an T’ocat Thuchlab abal nana’its in Cristo im bijchithits quin tsemtha ani oxchilab q’uicha quin ejtha ti al an jolimtalab. ");
INSERT INTO husNT1971_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Thuchath jaye abal ja’its an cau ca olnanchat tim patal an inicchic, abal ca jic’tson c’al in hualab ani ca paculanchat in hualab c’al a Dios. Ca oc’ox olnanchat axi teje’chic ti Jerusalén. ");
INSERT INTO husNT1971_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ani xohue’ tata’chic pel a uchbil tit olnom c’al patal jahua’ antsana’ in t’ajchinenec. ");
INSERT INTO husNT1971_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Jaxtam ca t’aja’chic ti cuenta abal nan ne’ets tu abchi an Espíritu Santo jant’ini’ u Tata ti eb im bijchith ulumalits ne’ets quit abchin. Expith quit jilc’onchic teje’ ti Jerusalén ma tam nan tu abchi xe’ c’al patal in tsap a Dios ti eb. ");
INSERT INTO husNT1971_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Taley cale ti Jerusalén a Jesús junax c’al in exobalilchic, c’alechic ti bichou Betania. Taja’ in thaya’ in c’ubac ani in labliychic. ");
INSERT INTO husNT1971_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Taley tixc’anits c’al jaja’chic, tihua’ c’alets ti eb. ");
INSERT INTO husNT1971_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Jilc’on in exobalilchic in c’ac’nanchal im bij. Taley ta huichits ti Jerusalén lej culbelchic. ");
INSERT INTO husNT1971_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ani chuthel chuthel c’uajatchic ti al am pulic tiyopan im puhuethanchal im bij a Dios. Amén.");
INSERT INTO husNT1971_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","C’uajatits jaja’ axi bijiyab ti Cau tam ti yabaye ts’ejcath an eb ani an tsabal. C’uajatits c’al a Dios, ani pel jaja’its a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","C’uajatits c’al a Dios tam ti yabaye hua’ats jant’o ts’ejcath. ");
INSERT INTO husNT1971_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ani pithan c’al a Dios in uchbil quin ts’ejca’ patal jahua’ hua’ats xohue’. Ani c’al jaja’ jats ti ts’ejcanenec patal jahua’ hua’ats tim puhuel an eb ani tim puhuel an tsabal. ");
INSERT INTO husNT1971_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ja’its jaja’ ax tu pithal i it ejattalab ani i tajaxtalab ti ichich. ");
INSERT INTO husNT1971_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Jaxtam yabats u xe’ets huahua’ al an yic’uax, ani ni jita’ tam inic yab in ejtohual tucu tepthanchi nixe’ xi tajaxtalab ti ichich. ");
INSERT INTO husNT1971_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Chich jun i inic im bij a Juan abath c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Chich abal quin olna’ an chubaxtalab tin cuenta nixe’ xi tajaxtalab, abal patal ta ca belchin jita’ ca olchin. ");
INSERT INTO husNT1971_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","A Juan yab ja axi tu pithal i tajaxtalab ti ichich, expith abath c’al a Dios abal quin olna’ an chubaxtalab tin cuenta jaja’ axi tu pithal an tajaxtalab. ");
INSERT INTO husNT1971_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Tu pithalac i chubax tajaxtalab ti ichich abal patal huahua’ cu ulitsac tin tamet a Dios. Ja’its jaja’ axi bijithits ne’ets ca chich teje’ tsabal. ");
INSERT INTO husNT1971_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ani chubax chich talbel teje’ tsabal. Aba ani’ in ts’ejcamal an eb ani an tsabal ani patal jahua’ hua’ats, bel yab exlanchat in ey c’al an inicchic. ");
INSERT INTO husNT1971_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Chich teje’ tsabal ax in ts’ejcamal jaja’, ani yab bats’uhuat c’al in at juntalchic. ");
INSERT INTO husNT1971_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Aba ani’ yab bats’uhuat c’al in at juntalchic, bel hua’ats i inicchic c’al ti bats’uhuat ani c’al ti belan. Ja’its tin ebal jaja’ abal am belomchic im bajuhual tin tsacamil a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Antsana’ tim bajuhual cum pel in culbetal a Dios. Yab ja tim bajumal tin ebal in t’ajtal ey ti hua’tsinenec. Yab ja tin ebal in le’nomtal i inic, ani yab ja tin ebal in tsalap i inic quim baju antsana’ tin tsacamilchic a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ja’its nixe’ axi bijiyab ti Cau ani hua’tsin ti inic. Xe’tsin teje’ tsabal junat c’al huahua’. Tu tejhua’methanchi in ts’alat. I exlanchi in ey pel in lej juncats Tsacamil a Dios ani in ts’alat jaye ejtil in Tata ti eb. Ja’its jaja’ ax tu tejhua’methanchi in alhua’ inictal a Dios ani tu calpunchi an chubaxtalab. ");
INSERT INTO husNT1971_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ja’its a Jesucristo olnamejits c’al a Juan antse’: ―Chichits jaja’ ax u ulumalits ne’ets ca chich. Lej pulic in ey ani nana’ iba. Ejatits jaja’ tam ti nan yabaye in hua’ats. ");
INSERT INTO husNT1971_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","C’al patal jahua’ in cua’al a Jesucristo i ets’ey bats’uhual yan i lablinchixtalab c’al tin ebal in alhua’ inictal. ");
INSERT INTO husNT1971_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","C’al jaja’ a Dios tu abchi in alhua’ inictal ani an chubaxtalab. Tam ti biyalits a Dios in abchi c’al a Moisés an inicchic am biyal ts’ejcath cau ax in olnal in uchbixtalchic a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Aba ani’ yab i ejtohual qui tsu’chi in lej hual a Dios, bel jaja’ a Jesucristo putat chich tucu tejhua’methanchi in lej ey a Dios. In ejtohual tucu tejhua’methanchi, cum ja’its in lej juncats Tsacamil a Dios axi ets’ey c’uajat utat tin ichich a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","An levitachic axi pel i beletnom c’al in tiyopanil an Israelchic ani i pale’chic jaye aban c’al i Israelchic axi ti Jerusalén abal ca c’ale quin tauna’ a Juan. Quin conoychic max jaja’ a Juan ja’its a Cristo axi bijithits ne’ets ca aban c’al a Dios ca chich. ");
INSERT INTO husNT1971_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ulitschic c’al a Juan ani tequeth uchan antse’: ―Nana’ yab ja in Cristo. ");
INSERT INTO husNT1971_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Tam conoyab antse’ a Juan: ―¿Tam jita’ tata’ max yab it Cristo? ¿Hualam pel it Elías axi pelac in caulomejil a Dios ti biyal, axi uxnal ne’ets ca huichiy teje’ tsabal junil? Toc’tsin a Juan: ―Nana’ yab ja. Ani conoyabe antse’: ―¿Max yab it Elías hualam tata’its nixe’ xi caulome ax in ulumalits a Moisés ne’ets ca chich? Toc’tsin a Juan: ―Iba nana’ yab ja. ");
INSERT INTO husNT1971_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Taley uchan a Juan c’al jaja’chic: ―Tam tucu ucha’ jita’ tata’ abal qui olchi axi tihua’chic tu abamal. Tucu lejquith ucha’ jant’o a ey. ");
INSERT INTO husNT1971_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","A Juan in toc’tsiychic: ―Nana’ u ey tin thajchix c’al in cahuintal a Dios teje’ al an joltam ju’tamq’ui ca tamcun an inicchic. U thajchixnanchal an cau ax in ulumal am biyal caulome c’al a Dios Isaías antse’: Ca ts’ejcacanchi am bolith bel an Ajatic jun ti ca ulits. ");
INSERT INTO husNT1971_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Talchic nixe’ axi che’nec quin conoy a Juan abal jita’ jaja’ pelchic xe’ i fariseo. ");
INSERT INTO husNT1971_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Exomchic in conoyale a Juan: ―¿Max yab it Cristo, tamna’ jale’ it pujal? A ulu yab it Cristo, ani yab it Elías, ani yab nixe’ xi caulome in ulumal a Moisés ne’ets ca chich. Tucu ucha’ jant’o a ey abal jale’ it pujal. ");
INSERT INTO husNT1971_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","A Juan in toc’tsiychic: ―Nana’ in xe’ets tim pujal c’al i ja’, ani xe’etsits jun c’al tata’chic yab a exlanchal in ey. ");
INSERT INTO husNT1971_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Taye ne’ets ca chich jaja’ axi lej pulic in ey ani nana’ iba. Nana’ lej tsa’at u ey, ma yab ne’ets cu baju cu tixc’anchi im pajab. ");
INSERT INTO husNT1971_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Im bij an c’uajattalab Betábara jun ti t’ilmats a Juan c’al an fariseochic antsana’. Tats ti xe’ets jaja’ ti pujal jum poq’ue’ am pulic itse’ Jordán. ");
INSERT INTO husNT1971_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Aytalab q’uicha a Juan in tsu’u talits ututul a Jesús. In ulu: ―Ca tsu’uchic ta talits jaja’ axi abnenec c’al a Dios abal ca paculanchat in hualab an inicchic. Pel jaja’ ejtil an cordero axi ti jayq’ui’ tsemthachicab c’al an Israelchic tin cuenta in hualabchic. ");
INSERT INTO husNT1971_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ja’its jaja’ ax u olna’its abal taye ne’ets ca chich. Lej pulic in ey ani nana’ iba. Ja’its axi ejatits tam ti nan yabaye in hua’ats. ");
INSERT INTO husNT1971_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Aba ani’ ti c’a’al yab u lej tajax exla’ jaja’, bel nan tu pujayalchic c’al i ja’ axi tit Israel abal ca lej t’ojojoy a ichich ani ca tequeth exla’ jaja’ ax u olnal. ");
INSERT INTO husNT1971_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Cahue a Juan in ulu: ―U tsu’u tal ti eb pa’i’il an Espíritu Santo ejtil i cucu’. Taley jilc’on c’al jaja’ ax tu ucha’ abnenec c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Nana’ yabaye u lej tajax exla’ jita’ jaja’ c’al ti jilc’on an Espíritu Santo. Expith a Dios ax tin aba’ tim pujal c’al i ja’ tin ucha’ max cu tsu’u pa’i’il an Espíritu Santo ani ca jilc’on c’al jun i inic, jats axi ne’ets ti pujal c’al an Espíritu Santo. ");
INSERT INTO husNT1971_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Xohue’ u tsu’umalits jant’ini’ tin uchan antsana’ c’al a Dios. Ani nan tu olchalchic an chubaxtalab abal ja’its jaja’ pel in Tsacamil a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Aytalab q’uicha c’uajat a Juan junil jun tin c’a’al tsu’umalits a Jesús. C’uajat jaye c’al jaja’ tsab in exobalilchic. ");
INSERT INTO husNT1971_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","In tsu’tal ne’ets huat’el a Jesús, ani in ucha’ in exobalilchic: ―Ca tsu’uchic tana’ u huat’el jaja’ ax tu olchits abnenec c’al a Dios. Pel jaja’ ejtil an cordero axi ti jayq’ui’ tsemthachicab c’al an Israelchic tin cuenta in hualabchic. ");
INSERT INTO husNT1971_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Tam ti ats’anchat a Juan abal antsana’ in ulu c’al xi tsab in exobalil, tam ta ts’at’eychic c’al a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Tam a Jesús huenc’on quin met’a’ tin cux, in tsu’u abal ts’at’enequits tsab i inic. In conoychic: ―¿Jant’o a le’chic? Toc’tsinchic: ―Tucu ucha’ Exobchix, ju’ta tit c’uajil. ");
INSERT INTO husNT1971_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","A Jesús in toc’tsiychic: ―Huana qui tsu’u. Tam ta c’aletschic quin tsu’u jun tu c’uajil a Jesús. Cum pelits i tse’ hora an huacal tam ti ulitschic, ta jilc’on taja’. ");
INSERT INTO husNT1971_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Jun axi ts’at’enec tsab c’al a Jesús pel a Andrés axi pel in ebchal a Simón Pedro. ");
INSERT INTO husNT1971_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Taley a Andrés thubat c’ale quin aliy in ebchal Simón. In ela’ ani in ucha’: ―Xohue’ i ela’its an Mesías. Ja’its a Cristo axi bijithits ne’ets ca aban c’al a Dios ca chich. ");
INSERT INTO husNT1971_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Tam thubat ne’tha a Simón c’al a Andrés jun ti c’uajat a Jesús. Tam ti a Jesús in tsu’u a Simón, in ucha’: ―Tata’its Simón pel ti tsacamil a Jonás. Ma xohue’ ne’ets quit bijiyat tit Cefas ax in le’ quin ulu Pedro. ");
INSERT INTO husNT1971_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Aytalab q’uicha a Jesús c’ale ti Galilea quin tsa’biy i cuenchalabchic taja’. In tamu oc’ox a Felipe, ani in ucha’: ―Tiquin ts’at’enchi. ");
INSERT INTO husNT1971_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","In q’uima’ a Felipe c’uajat ti bichou Betsaida axi jaye pel im bichohuil a Andrés ani a Pedro. ");
INSERT INTO husNT1971_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Tam c’ale a Felipe quin aliy a Natanael. In ela’ ani in ucha’: ―I tsu’umalits xohue’ nixe’ xi inic ax u olnab ma ti biyalits ne’ets ca chich. Ja’its jaja’ ax u olnab ti al an thuchath u thuchan c’al a Moisés ani c’al am biyal caulomechic c’al a Dios. Pelits a Jesús axi pel in tsacamil a José ax u c’uajil ti bichou Nazaret, in ulu a Felipe. ");
INSERT INTO husNT1971_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Tam in ulu a Natanael: ―Auxe’ max ja’its a Jesús ax u olnab c’al am biyal caulome ne’ets ca chich. I tso’obits abal yab hua’ats ni jun i alhua’ inic ti Nazaret. Tam a Felipe in toc’tsiy: ―Max yab a belal, huana qui tsu’u. ");
INSERT INTO husNT1971_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Tam ti a Jesús in tsu’u uteyits a Natanael, in ulu: ―Ca t’aja’ ti cuenta ta tal jun i Israel axi lej chubax in ichich. ");
INSERT INTO husNT1971_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Tam a Natanael in conoy a Jesús: ―¿Jant’ini’ tin exlal jant’ini’ u ey? Toc’tsin a Jesús: ―Nan tu tsu’u ani tu exla’its tam tit cubat tihua’ acan i te’ higuera. Ma tam ti yabaye it uchnenec c’al a Felipe quit chich tiquin tsu’u, nan tu tsu’u. ");
INSERT INTO husNT1971_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Tam uchan a Jesús c’al a Natanael: ―Lej chubax Exobchix, nan u belal abal pel ti Tsacamil a Dios. Tata’its axi it bijithits c’al a Dios ne’ets quit chich tit Ts’ale c’al huahua’ tu Israel. ");
INSERT INTO husNT1971_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Toc’tsin a Jesús: ―Hualam max a belal abal nana’ pel tin Tsacamil a Dios cum tu ucha’its abal tu tsu’u tam tit cubat tihua’ acan i te’ higuera. Aba ani’ a jic’palits abal nan antsana’ tu tsu’u, ne’ets ca jic’paye más i lej pulic t’ajbilab axi ne’ets cu t’ajaye. ");
INSERT INTO husNT1971_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","A Jesús in uchayechic: ―Lej chubax nan tu uchalchic abal ne’etse tu tejhua’methanchi u ey. Ne’ets ca tso’obna’chic talbel abal nana’ tin Juntal patal an inicchic pel tin abatnom c’al i ángelchic ti eb. ");
INSERT INTO husNT1971_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ne’ets quin t’aja’ ox a q’uicha tam ti caunenec a Natanael c’al a Jesús, ani exom i ajib tin cuenta i tomquintalab ti bichou Caná axi cuentalith Galilea. Tats ti c’uajat in mim a Jesús c’al an ajib. ");
INSERT INTO husNT1971_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","C’uajatchic taja’ jaye a Jesús ani huahua’ tu exobalilchic, cum u caniyame cu c’ale. ");
INSERT INTO husNT1971_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ani cum talits an vino, uchan a Jesús c’al in mim: ―Yabats hua’ats i vino quin uts’a’chic. ");
INSERT INTO husNT1971_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Toc’tsin a Jesús: ―Ca aychi hue’, mim. U tso’ob jant’o ne’ets cu t’aja’ tam quim bajuhuits an hora cu t’aja’. In q’uibchale hue’ abal cu t’aja’. ");
INSERT INTO husNT1971_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Tam in mim a Jesús in ucha’ am buc’ulchic c’al an c’apnel ani c’al an uts’nel: ―Ca t’ajchichic patal jahua’ ne’ets ti ucha’ jaja’. ");
INSERT INTO husNT1971_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Hua’ats taja’ acac i pulic mul ax u balchixnab c’al an ja’ abal quin t’acaxna’ an Israelchic tam ne’ets ti c’ac’nax c’al a Dios. Ti junchic an mul in ac’nal jat’hua’ ti tse’ inicchic ani ti bo’ inic i litro i ja’. ");
INSERT INTO husNT1971_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","A Jesús in ucha’chic am buc’ulchic c’al an c’apnel ani c’al an uts’nel: ―Ca t’uchiychic c’al i ja’ nix an mul. Ani in t’uchiychic ma eblim. ");
INSERT INTO husNT1971_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Tam a Jesús in ucha’chic: ―Ca caltha’ hue’ i ja’ ani ca nenchi tihua’ an cuentalom c’al an ajib. Tam in caltha’chic ani in nenchi jant’ini’ ti uchan c’al a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","An cuentalom im bats’u ani in leca’ an vino axi pelac i ja’. Yab in tso’ob ju’ta tin chi’tha’, expith in tso’obits ax in caltha’chic an ja’ quim bina’. Tam an cuentalom in caniy ca chich an tomiclab inic. ");
INSERT INTO husNT1971_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Ani in ucha’: ―Ets’ey in ujnam an inic quin oc’ox pitha’ axi lej huinat alhua’ an vino ca uts’an yan c’al an tamcunel ajibal, ani taley tiq’uele axi yab lej alhua’. Tata’ yab a t’ajamal antsana’. Hue’its ne’ets ca taley an ajib, ani ma xohue’ a pithal an vino axi lej huinat alhua’. ");
INSERT INTO husNT1971_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Antsana’ a Jesús tin huenc’ou an ja’ ti vino ti al an ajib tin cuenta an tomquintalab ti bichou Caná axi cuentalith Galilea. Ja’its an oc’ox labith t’ajbilab in t’aja’ ti tsu’bixtalab c’al in ey. Cum antsana’ in tejhua’metha’ in ey abal in lej cua’al in tsap, jaxtam huahua’ pel tu exobalilchic a Jesús i belamal. ");
INSERT INTO husNT1971_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Taley u c’ale huahua’ tu exobalil a Jesús junax c’al jaja’ ti bichou Capernaum, ani c’al in at ebchalchic, ani c’al in mim’ jaye. Ani tats tu jilc’onchic tsab ox a q’uicha. ");
INSERT INTO husNT1971_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Hue’its ne’ets quim baju an q’uicha tam an Israelchic quin t’aja’ an ajib tin cuenta abal ti calthame ti Egipto im biyal juntalchic. Cum ne’ets quin t’aja’chic ti bichou Jerusalén, tats ti c’ale tihua’ a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Otsits al an tiyopan ani in tsu’u i nujul hueyax, ani i nujul oveja, ani i nujul lab cucu’. Hua’ats jaye al an tiyopan quetechic tin mexajil i jalum tuminchic. ");
INSERT INTO husNT1971_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Tam tin tsu’u a Jesús jahua’ in t’ajalchic, in ts’ejca’ jun i cuathaxtalab ts’aj abal quin quethmaychic. Taley in tala’ quethmachiquiyal eleb an nujulchic c’al patal an ovejachic ani an hueyaxchic. In cuajlachiquinchal in mexajil an jalum tuminchic, ani huac’lalal ti c’ale in tuminal. ");
INSERT INTO husNT1971_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Tam a Jesús in ucha’chic an nujul lab cucu’: ―Ca thubat caltha’ a nujnelil ani yabats ca eyentha’ ti nujumtalab in q’uima’ u Tata ti eb. ");
INSERT INTO husNT1971_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Tamits huahua’ tu exobalil i t’ila’ jahua’ thuchath tin T’ocat Thuchlab tin cuenta a Jesús antse’: Tu t’ayat ichich u lej cua’al u canat abal ca chubax eyentha in q’uima’ a Dios jant’ini’ in tomnal ca eyentha c’al axi lej chubax c’ac’nax c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Tam conoyat a Jesús c’al talchic i Israelchic: ―¿Jant’o ne’ets ca t’aja’ ti tsu’bixtalab abal qui tso’obna’ max chubax a cua’al a uchbil ca tala’ quethmay i inicchic antsana’ eleb ti al an tiyopan? ");
INSERT INTO husNT1971_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Tam a Jesús in toc’tsiychic: ―Max tata’chic ca paclu axe’ xi tiyopan, nan ne’ets cu tsab ts’ejca’ junil ti ox a q’uicha. ");
INSERT INTO husNT1971_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ani uchan a Jesús c’al jaja’chic: ―Auxe’ max ca chubax ejtou ca tsab ts’ejca’ ti ox a q’uicha, cum an ts’ejcomchic c’al axe’ xi tiyopan in t’ojna’ tsab inic c’al acac i tamub ti ts’ejcom. ");
INSERT INTO husNT1971_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Tam ti a Jesús in ulu antsana’ c’al an tiyopan, pel i t’ipchixtalab c’al in inictal. ");
INSERT INTO husNT1971_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Huahua’ tu exobalilchic yab i thubat ejtiy nix an cau jahua’ in ulu. Expith i ejtiyits talbel tam ti ejthachits a Jesús. I t’ila’chic tamna’ jahua’ in ulumalits abal ne’ets quin tsab ts’ejca’ junil an tiyopan ti ox a q’uicha. Ma tamna’its i lej belchits jahua’ antsana’ thuchath ti al an T’ocat Thuchlab in cahuintal a Dios ani jahua’ in ulumalits a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Exome an ajib ti bichou Jerusalén tin cuenta abal ti calthame ti Egipto im biyal juntalchic an Israel. Tats ti xe’ets a Jesús in t’ajalchic i labith t’ajbilab ti tsu’bixtalab c’al in ey, ani c’al yantalam i inicchic tu belnal tam ti tsu’tabits jahua’ in t’ajamal. ");
INSERT INTO husNT1971_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Cum a Jesús in tala’ exlanchal in ichich jaja’chic, yab in lej bela’ max pel i chubax belom. ");
INSERT INTO husNT1971_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Yab in yejenchal ca olchin in ey an inic, cum in tala’ exlanchalits jant’o tam tsalap in ne’thal tin ichich an inicchic. ");
INSERT INTO husNT1971_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Hua’ats jun i inic pel i oc’lec c’al an Israelchic ax im bij Nicodemo. Jaye pel i fariseo. ");
INSERT INTO husNT1971_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Chich acal quin tsa’biy a Jesús, in ucha’: ―Huahua’ tu Israel i tso’ob abal it abath tit Exobchix c’al a Dios abal tucu exobchi in cahuintal. Cum tu tejhua’methanchal a tsap c’al i labith t’ajbilab, jaxtam i tso’ob abal it lej abath c’al a Dios ani jaja’ ti tolmiyal. ");
INSERT INTO husNT1971_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Tam uchan c’al a Jesús: ―Lej chubax nan tu uchal abal c’al in t’ajtal ey ti hua’tsinenec ni jita’ yab in ejtohual quin tso’obna’ jant’ini’ tin t’ajal a Dios ti Ts’ale. In yejenchal ca oc’ox it hua’tsin. ");
INSERT INTO husNT1971_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Tam conoyat a Jesús c’al a Nicodemo: ―¿Jant’ini’ in ejtohual ca it hua’tsin jun ani puliquits ti inic? Auxe’ max in ejtohual ca huichiy tin chucul in mim ani ca it hua’tsin junil ti t’ele’. ");
INSERT INTO husNT1971_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Toc’tsin a Jesús: ―Expith jitats ca it ejatliyat c’al i ja’ ani c’al an Espíritu Santo, jats ne’ets ca otsits jun tin t’ajal a Dios ti Ts’ale. Lej chubax jahua’ antsana’ nan tu uchal. ");
INSERT INTO husNT1971_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ca hua’tsin i t’ele’, in cua’al in anam t’u’ul ejtil in mim ani in tata. Ca it ejatliyat jun i inic c’al an Espíritu Santo, in cua’al i it ejattalab. ");
INSERT INTO husNT1971_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Yab ca jic’pa’ abal nan tu uchal in yejenchal ca it hua’tsin jitats in le’ ca otsits jun tin t’ajal a Dios ti Ts’ale. ");
INSERT INTO husNT1971_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","U juchnal an ic’ abal ju’tamq’ui quin le’na’. Aba ani’ a ejtohual ca ats’anchi in cahuith an ic’, yab a tso’ob ma ju’ta ti tal ani ma ju’ta ti ne’ets. Antsana’ jaye yab a ejtohual ca tso’obna’ jant’ini’ tu it ejatliyab i inicchic c’al an Espíritu Santo. An Espíritu Santo im pithal i it ejattalab an inicchic jitats quin le’nanchi quim pitha’, ani yab a ejtohual ca tso’obna’ jant’ini’ tim pithalchic. ");
INSERT INTO husNT1971_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Tam conoyat a Jesús c’al a Nicodemo: ―¿Jant’ini’ tam u ejtohual cu bats’u i it ejattalab? ");
INSERT INTO husNT1971_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Toc’tsin a Jesús: ―Tata’ ojni’ it lej huit’ath tit exobchix c’al an Israelchic ani jant’ini’ ti yab a ejtohual ca ejtiy an cau jahua’ nan tu uchal. ");
INSERT INTO husNT1971_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nan u tso’obits abal jats an lej chubax cau jahua’ tu uchal, cum tin tso’oblinchamalits u Tata ti eb. Aba ani’ pel i chubaxtalab, yab a le’ ca belchi. ");
INSERT INTO husNT1971_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","An cau axi nan tu t’ilchal tin cuenta teje’ tsabal yab a le’ ca belchi, ani más yab ne’ets ca belchi max tu t’ilchiye hualim xi tihua’ c’al u Tata ti eb. ");
INSERT INTO husNT1971_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Nana’ tin Juntal patal an inicchic u c’uajattal ti eb, ani expith nana’ ja’its an inic ax im pa’inec in tal ti eb. ");
INSERT INTO husNT1971_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Tam ti biyal a Moisés in ts’ejca’ c’al i pat’al in t’ipoth inquithtal i tsan, ani in tejcou chum i acanlab ti al an joltam. Quin met’a’ jitats ts’icathits c’al an tsan, ani ne’ets ca jeltha. Nana’ tin Juntal patal an inicchic im bijchithits quin q’uet’an al jun i pelc’oth te’. ");
INSERT INTO husNT1971_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Antsana’ ne’ets quin t’ajchin abal ca pithan i it ejattalab patal jitats tiquim bela’ nana’, ani ne’ets ca ets’ey c’uajiy c’al a Dios yab ca q’uibey, in ulu a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Cum a Dios lej ichich hual in tsu’tal an inicchic, jaxtam in aba’ in lej juncats Tsacamil ca chich teje’ tsabal. Patal jitats quim bela’ in Tsacamil a Dios ne’ets ca pithan i it ejattalab abal ca ets’ey c’uajiy c’al a Dios yab ca q’uibey. ");
INSERT INTO husNT1971_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","A Dios in aba’ in Tsacamil abal c’al jaja’ ca jec’ontha an inicchic, yab abal ca jolbiyat. ");
INSERT INTO husNT1971_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Jitats quim bela’ in Tsacamil a Dios yab ne’ets ca jolbiyat c’al a Dios. Max yab quim bela’ tamna’ jolbithits. ");
INSERT INTO husNT1971_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Jolbithits cum yab im belal ani im pojcal jaja’ axi che’nec quim pitha’ an inicchic i tajaxtalab tin ichich. Tocat in culbetnale ca xe’tsin más al an yic’uax ani iba al an tajax. Antsana’ in culbetnal cum in ey in c’anithal ani in t’ajal jahua’ yab alhua’. ");
INSERT INTO husNT1971_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Patal jitats ax in t’ajal jahua’ yab alhua’ im pojcal an tajaxtalab, cum yab in le’ ca tejhua’metha jahua’ yab alhua’ in t’ajal. ");
INSERT INTO husNT1971_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Jitats in ne’thal juncuth in tsalap c’al an chubaxtalab u xe’ets al an tajax, ani antsana’ ti ne’ets ca tsu’tat c’al in at inic abal u tolmiyab c’al a Dios quin t’aja’ jahua’ alhua’. ");
INSERT INTO husNT1971_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Taley talbel u c’ale huahua’ tu exobalil a Jesús junax c’al jaja’ ti tsabal Judea. Ani taja’ xe’ets a Jesús ti pujal tsab ox a q’uicha. ");
INSERT INTO husNT1971_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Jayetseq’ui taja’ utat hue’ ti Enón axi utat ti bichou Salim, xe’ets ti pujal a Juan cum hua’ats yan i ja’ taja’. Tats tu che’el an inicchic ani u pujnal. ");
INSERT INTO husNT1971_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Antsana’ ti xe’ets a Juan tam ti yabaye baliyame ti al an huic’axte’. ");
INSERT INTO husNT1971_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Tam taja’chic in ts’i’quiy ti t’ilom talchic in exobalil a Juan ani talchic i Israelchic. In t’iloxnal jant’o in ey ca t’oquetha an inicchic ani ca t’oquetha an eyextalab abal tin cuenta an c’ac’naxtalab c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Taley chich c’al a Juan in exobalilchic quin tauna’. Uchan a Juan c’al jaja’chic: ―Ca t’aja’ ti cuenta exobchix, nixe’ xi inic a ulu abal it junax xe’tsin c’al jaja’ ti jayq’ui’ jum poq’ue’ ti pulic itse’ Jordán. Xohue’ xe’ets ti pujal jaye, ani jat’hua’ tim patal an inic u ts’at’el c’al jaja’. ");
INSERT INTO husNT1971_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Tam a Juan in ucha’chic: ―Pelits a Dios expith ax im pithal in uchbil an inicchic, max ti pujal ani max jant’ots in uchbil. ");
INSERT INTO husNT1971_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Nan tu lejquith ucha’itschic abal nana’ yab ja in Cristo. A Dios tin aba’ quin chich hue’ oc’chith abal cu tolmiy an inicchic quin t’ojojoy in ichich abal quim bats’u a Cristo talbel. ");
INSERT INTO husNT1971_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","An ts’ic’ach axi ne’ets ca tomquin c’al i inic ne’ets ca c’alna c’al jaja’. Antsana’ jitats ca juncun c’al a Cristo ne’ets ca c’alna c’al jaja’. Nana’ expith u tolmiyal an inicchic ca juncun c’al a Cristo ejtil max pel tin conox c’al i ts’ic’ach ax u le’nab ca juncun c’al i cuitol. In lej culbel tam u juncunal i inicchic c’al a Cristo. ");
INSERT INTO husNT1971_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Lej bijithits a Cristo expith ca c’athpich t’ajchin ti cuenta c’al an inicchic cum in ey lej pulic, ani nana’ tocat quin tsu’tat más tsa’at u ey. ");
INSERT INTO husNT1971_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","A Cristo ojni’ tal ti eb ani lej c’athpich pulic in ey. Yab hua’ats jita’ teje’ tsabal quim baju ejtil in ey jaja’. Jitats ca hua’tsin teje’ pel i inic, ani in t’iloxnal jahua’ hua’ats teje’ tsabal. ");
INSERT INTO husNT1971_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","A Cristo tal ti eb ani in t’iloxnal jahua’ in tsu’umal ani jahua’ in ats’amal ti eb. Ani an inicchic yab in le’ quim belchi jahua’ in ulal. ");
INSERT INTO husNT1971_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Max i belchal jahua’ in ulal a Cristo abal lej chubax, tam jun t’ajat i mac’uchith belchal jaye abal chubax patal jahua’ in ulal a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Cum ja’its a Dios ax in aba’ a Cristo teje’ tsabal abal tucu olnanchi in cahuintal a Dios. Patal jahua’ in ulal jaja’ pel i chubaxtalab cum jum putat pithnenec an Espíritu Santo c’al a Dios, ani yab pithnenec t’ipothq’ui. ");
INSERT INTO husNT1971_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","An Tatalab ti eb in lej c’anithal a Cristo cum pel in Tsacamil, ani in tala’ pithamalits tin c’ubac patal jahua’ hua’ats ti eb ani ti tsabal. ");
INSERT INTO husNT1971_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Jitats quim bela’ in Tsacamil a Dios, jats ax u pithnal i it ejattalab abal ca ets’ey c’uajiy c’al a Dios. Jitats yab quim bela’, jats ne’ets ca ijcanchat an c’ac’ath yajchictalab c’al a Dios taye tal. ");
INSERT INTO husNT1971_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","In ats’a’ an fariseochic abal lej yan i inicchic u ts’at’el ani u pujnal c’al a Jesús, ani c’al a Juan hue’ jun tsab expith. ");
INSERT INTO husNT1971_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Antsana’ in ats’a’chic aba ani’ jaja’ yab u pujal a Jesús. Expith u pujalchic huahua’ tu exobalil. ");
INSERT INTO husNT1971_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Tam tin tso’obna’its a Jesús abal antsana’ ti olchinenec nixe’ xi fariseochic, tamna’ cale ti pulic bichoulom Judea ne’ets ca huichiy ti pulic bichoulom Galilea. ");
INSERT INTO husNT1971_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Abal ca ulits ti Galilea in yejenchal ca huat’ey ti Samaria. ");
INSERT INTO husNT1971_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Tam ti ne’etsits ti bel im baju jun i bichou im bij Sicar axi cuentalith Samaria. Nixe’ xi bichou Sicar utat an tsabal ax a Jacob tam ti biyalits im pitha’ in tsacamil José. ");
INSERT INTO husNT1971_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Tats ti hua’ats jun i mom im bij in momil a Jacob. Cum tsequenequits a Jesús ti belal coyots ba’ an mom. Lej hue’its in le’ quim baju ts’ejel q’uicha. ");
INSERT INTO husNT1971_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Tam chich jun i uxum Samariajib quin caltha’ an ja’. Uchan c’al a Jesús: ―Tiquim pitha’ an ja’ cu uts’a’. ");
INSERT INTO husNT1971_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Biyat u c’alnequits huahua’ tu exobalilchic a Jesús ti bichou abal qui ts’a’iy jant’o qui c’apu. ");
INSERT INTO husNT1971_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Tam uchan a Jesús c’al nixe’ xi uxum: ―Cum tata’ pel it Israel ani nana’ pel in Samariajib yab in tomnal tata’ tiquin conchi i ja’. Antsana’ in ulu cum yab u le’nab an Samariajibchic c’al an Israel. ");
INSERT INTO husNT1971_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Toc’tsin a Jesús: ―Yab tin exlanchal u ey ani yab a tso’ob jahua’ in le’ ti pitha’ a Dios. Max tin exlalac jita’ nana’, tin conchamalac ani nan ne’ets tu pitha’ i ja’ tin cuenta a ejattal c’al quit ejatlinchat ets’ey. ");
INSERT INTO husNT1971_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Uchan a Jesús: ―¿Tata’ ojni’ pay’lom, ju’ta ta cua’al an ja’ ax tin ucha’ ne’ets tiquim pitha’ tin cuenta u ejattal? Ma yab a cua’al jant’o ta ca caltha’ i ja’ al axe’ xi luputh mom. ");
INSERT INTO husNT1971_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Te tu jilchamal axe’ xi mom i biyal juntal Jacob. Teje’ tin calthamal i ja’ abal quin uts’a’chic c’al in tsacamilchic ani c’al i co’nelchic. Auxe’ max jats tata’ ax it lej pulic a ey ani jaja’ a Jacob hue’ tocat in ey. ");
INSERT INTO husNT1971_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Toc’tsin a Jesús: ―Ne’ets ca tajlun ti chiquel jitats quin uts’a’ an ja’ al axe’ xi mom, ani talbel junil ne’ets ca chiquey. ");
INSERT INTO husNT1971_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Jitats quin uts’a’ an ja’ axi nan cu pitha’ tin cuenta in ejattal yabats ne’ets ca chiquey. Pel ejtil i elel ja’ tin ichich axi yab jayq’ui’ u thiquel. Ne’ets ca lejat it ejatlinchab in ejattal abal ets’ey. ");
INSERT INTO husNT1971_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Tam uchan a Jesús c’al nixe’ xi uxum: ―Ojni’ pay’lom, tiquim pitha’ an ja’ cu uts’a’ a ulal a cua’al abal yabats quin chiquey, ani yabats cu yejenchi quin huichiy cu caltha’ an ja’ teje’ al an mom. ");
INSERT INTO husNT1971_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Tam uchan c’al a Jesús: ―Quit c’ale ca ucha’ ca chich teje’ a tomquil. ");
INSERT INTO husNT1971_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Toc’tsin an uxum: ―Nan yab u cua’al u tomquil. Tam uchan c’al a Jesús: ―Lej chubax jahua’ a ulal abal yab a cua’al a tomquil. ");
INSERT INTO husNT1971_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","A co’oyamalits bo’ i inic ani ax a cua’al xohue’ yab pel a tomquil. Lej chubax a ulu abal yab a cua’al a tomquil. ");
INSERT INTO husNT1971_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Tam tin ats’a’ antsana’ an cau an uxum, tam in ucha’ a Jesús: ―Tata’ ojni’ pay’lom, hualam pel it caulome c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Tata’chic tit Israel a ulal abal expith ti bichou Jerusalén jats jun ti bijithits an inicchic quin c’ac’na’ a Dios. I biyal juntalchic Samariajib yab in ulu ani’. Jaja’chic in c’ac’namal a Dios teje’ al axe’ xi bolchal. ");
INSERT INTO husNT1971_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Toc’tsin a Jesús: ―Uxum, nan u le’ abal tiquim belchi jahua’ nan ne’ets tu ucha’. Ne’ets quim baju an hora tam an inicchic ax in le’ ti c’ac’nax c’al an Tatalab ti eb yab ne’ets quin yejenchi ca chich ti c’ac’nax al axe’ xi bolchal. Ani jayetseq’ui yab ne’ets quin yejenchi ca c’ale ti Jerusalén abal ti c’ac’nax. ");
INSERT INTO husNT1971_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Tata’chic tit Samariajib yab chubax it c’ac’nax c’al an Tatalab ti eb, cum yab a chubax exlal xe’. Huahua’ tu Israel i chubax exlal, ani jaxtam i ejtohual qui chubax c’ac’na’. Ani c’al huahua’ tu Israel a Dios ne’ets quin caltha’ an Jec’onthax. ");
INSERT INTO husNT1971_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Xohue’its jitats in le’ quin chubax c’ac’na’ an Tatalab ti eb in yejenchal quin c’ac’na’ c’al in lej ichich ani c’al in lej tsalap jun ejet t’ayat c’al a Dios ti c’ac’nax. Antsana’ ojni’ in le’ a Dios ca c’ac’na. ");
INSERT INTO husNT1971_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","A Dios pel i Espíritu. Pel in uchbil an inic quin c’ac’na’ a Dios c’al in lej ichich ani c’al in lej tsalap jun ejet t’ayat max chubax pel i c’ac’nax c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Tam uchan a Jesús c’al an uxum: ―U tso’obits abal ne’ets ca chich an Mesías axi pel a Cristo bijithits c’al a Dios ne’ets ca aban. Ja’its jaja’ axi ne’ets tucu tala’ lejquinchi an cau tin cuenta a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Tam uchan an uxum c’al a Jesús: ―Nana’its ti ja in Cristo ax tu t’ilom xohue’. ");
INSERT INTO husNT1971_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Taley u ulits huahua’ tu exobalilchic a Jesús i tsu’u abal t’ilom c’al i uxum, ani i lej jic’pal. Tocat ni jun yab in luba’ abal quin conoy a Jesús jale’ ti t’ilomac c’al nixe’ xi uxum ani jant’o ax in t’iloxnanchal. ");
INSERT INTO husNT1971_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Tam an uxum in jilcacay in mulil, ta c’ale ti bichou. Taja’ in ucha’ an inicchic: ");
INSERT INTO husNT1971_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―Huana qui tsu’u jun i inic ax tin tala’ olchamal jahua’ nan u t’ajamal. Hualam ja’its axi pel a Cristo. ");
INSERT INTO husNT1971_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Tam cale am bichou ani c’ale jun ti c’uajat a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Biyat yabaye ulnec am bichou, huahua’ i ucha’ a Jesús: ―Exobchix, te c’uajat an c’apnel ca c’apu. ");
INSERT INTO husNT1971_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Tam a Jesús tu ucha’chic: ―Nan u cua’alits jant’o cu c’apu aba ani’ yab a tso’obchic jahua’ u cua’al. ");
INSERT INTO husNT1971_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Tam u conóx huahua’ jun c’al xi jun. I ulu: ―Hualam chanchinits i c’apnel c’al jita’ ani hualam c’aputsits. ");
INSERT INTO husNT1971_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Tam a Jesús tu ucha’chic: ―An c’apnel jahua’ nan u cua’al jats tin cuenta u ejattal. Ja’its a Dios ax tin tsaplinchal u ejattal, cum u t’ajchal in culbetal ani u lubal cu tala’ an t’ojlab jahua’ jaja’ tim pitha’. ");
INSERT INTO husNT1971_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ca met’a’chic teje’ ulelel i inicchic axi xo’ hue’its ne’ets quim belchi in cahuintal a Dios tam ca t’aychin tin ichich. Yab ca ulu ta ichich max ne’ets ca aychiye abal quim belchi. Yab ca ulu ejtil jun i inic tam huejnequits an hualilab lab em ne’ets quin aychiye ca putunits tse’ a its’ ani tiq’uele quin cotoy. ");
INSERT INTO husNT1971_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Hua’ats jita’ ax in oc’ox t’aychal in cahuintal a Dios tin ichich in at inic, ani hua’ats jita’ jaye ax in tolminchal talbel quim belchi in cahuintal a Dios jitats t’aychinenequits tin ichich. An t’aychix ani an tolminchix ne’ets ca junax culbe ani ca jalbinchat c’al a Dios tam i inicchic quim belchits in cahuintal a Dios. Ani jitats quim belchi in cahuintal a Dios ne’ets ca pithan i it ejattalab abal ca ets’ey c’uajiy c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Lej chubax jahua’ uxnal jun i inic in uchbil ti t’ayal c’al i iyalab ani junaque i inic in uchbil ti cotol c’al an hualilabcua’. ");
INSERT INTO husNT1971_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nan tu abalchic abal ca tolminchi quim belchi in cahuintal a Dios jitats t’aychinenequits tin ichich. Pel jaja’chic axi oc’ox t’aychinenec in cahuintal a Dios tin ichich c’al q’ue’at i belom, ani tata’chic talbel ca tolminchi quim belchi. ");
INSERT INTO husNT1971_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Cum nixe’ xi uxum Samariajib in olchi im bichohuil abal in tsu’u jun i inic c’al ti tala’ olchin patal jahua’ jaja’ in t’ajamal an uxum, jaxtam yantalam i inicchic al nixe’ xi bichou im bela’ a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Tam ti ulits am bichou jun ti c’uajat a Jesús, tam ti lej uchan a Jesús max quin ejtou ca jilc’on hue’ tihua’ tim bichohuil. Ani tats ti jilc’on tsab a q’uicha. ");
INSERT INTO husNT1971_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ani yantalame i inicchic ax in ats’anchal in cahuintal a Cristo taja’ im bela’ jaye. ");
INSERT INTO husNT1971_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Tam uchan an uxum c’al nixe’ xi belomchic: ―I belchamal jahua’ tata’ tu olchi’ tin cuenta jaja’, ani xohue’ i lej belchal cum huahua’ putat i ats’anchal in cahuintal. I lej tso’obits abal ja’its jaja’ a Cristo axi bijithits ne’ets ca aban c’ale a Dios ca chich. Ja’its an Jec’onthax c’al an inicchic. ");
INSERT INTO husNT1971_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Tam tim putuhuits tsab a q’uicha al nixe’ xi bichou, tam ti cale a Jesús taja’ ani c’ale quin tsa’biy i cuenchalabchic ti Galilea. ");
INSERT INTO husNT1971_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Cum lej chubax jant’ini’ in ulu jaja’ abal yab u c’ac’nab i caulome c’al a Dios tin lej cuete’ bichohuil. ");
INSERT INTO husNT1971_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Tam ti ulits a Jesús ti Galilea lej alhua’ bats’uhuat c’al an inicchic taja’, cum in tsu’umalits jahua’ in t’ajamal tihua’ ti bichou Jerusalén. Cum tats ti xe’tsin a Jesús ti Jerusalén tam ti an Israel in t’aja’ an ajib tin cuenta abal ti calthame ti Egipto im biyal juntalchic. ");
INSERT INTO husNT1971_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Taley huichits junil a Jesús ti Caná axi cuentalith Galilea jun tin huenc’ohuamal an ja’ ti vino. Ani hua’ats jun i oc’lec in cua’al in cuitolil ya’ul tihua’ ti bichou Capernaum. ");
INSERT INTO husNT1971_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Tam tin ats’a’ abal ulits a Jesús taja’ ti Galilea tal ma ti Judea, tam c’ale quin tsu’u. Chich ani in lej canat ucha’ max quin ejtou ca c’ale quin jelthanchi in cuitolil axi taleq’uits. ");
INSERT INTO husNT1971_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Uchan an oc’lec c’al a Jesús: ―Tata’ ojni’ yab a le’ tiquim bela’ max yab tu t’ajchi i labith t’ajbilab ti tsu’bixtalab c’al u ey. ");
INSERT INTO husNT1971_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Tam uchan a Jesús c’al an oc’lec: ―Huana thubat tu q’uima’ pay’lom, biyat hualam hue’ ejate u cuitolil. ");
INSERT INTO husNT1971_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Uchan c’al a Jesús: ―Quit c’ale ta q’uima’. Yab ne’ets ca tsemets a cuitolil. Cum an oc’lec im belchi jahua’ antsana’ uchan c’al a Jesús, ta c’ale tin q’uima’. ");
INSERT INTO husNT1971_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Tam ti ne’ets ti bel, tam ti tamuhuatits c’al tsab ox in t’ojnalil. Uchan an oc’lec: ―Elabmejits a cuitolil. ");
INSERT INTO husNT1971_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Tam in conoy jahua’ hora ti ts’i’quin ti elabmel. Uchan: ―Ti hue’el jun hora an huacal hualcanits c’al an c’ac’al. ");
INSERT INTO husNT1971_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Tam tin t’ila’ in tata an cuitol abal ja’its an hora tam ti uchan c’al a Jesús abal yab ne’ets ca tsemets in cuitolil. Tam an oc’lec ani c’al patal ax tin q’uima’ in ts’i’quiyal quim bela’chic a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Axe’ ja’its an tsabchilab labith t’ajbilab ax in t’ajamal a Jesús ti tsu’bixtalab c’al in ey. Antsana’ in t’ajamal tam ti huichits ti Galilea tal ma ti Judea. ");
INSERT INTO husNT1971_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Taley c’ale a Jesús ti Jerusalén jun ti ne’ets ca t’ajan junaque i ajib c’al an Israelchic. ");
INSERT INTO husNT1971_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Taja’ ti Jerusalén hua’ats i ts’acbath ja’ ax u bijiyab ti hebreo cau Betesda. Nixe’ xi ja’ c’uajat utat al i otsnamtalab c’al am bichou jun ti hua’ats i hui’leb ax u bijiyab ti Ovejachic, ani hua’ats bo’ i hueu cucu’ ata tin tonithtal nixe’ xi ts’acbath ja’. ");
INSERT INTO husNT1971_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Taja’ mo’ochic yantalam i ya’ul in aychal ca lanq’uiyat an ja’. Hua’ats i joc’tsi, i c’uets’e’, i tsambe. ");
INSERT INTO husNT1971_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Junchiquil u pa’il taja’ jun i ángel quin lanq’uiy an ja’, ani an ya’ul axi ca oc’ox otsits al an lanq’uith ja’ u jelthabits c’al jahuaquitsq’ui tam yau’lats. ");
INSERT INTO husNT1971_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","C’uajat taja’ jun i inic u ya’ul ox i lajuj c’al huaxic i tamub. ");
INSERT INTO husNT1971_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","A Jesús in tso’obits abal ohuatits tu ya’ul. In tsu’u mo’olq’ui ani in conoy: ―¿A le’ quit jeley? ");
INSERT INTO husNT1971_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Toc’tsin an ya’ul in ulu: ―Ni jita’ yab hua’ats pay’lom, abal tiquin otha’ al an ja’ tam ca lanq’uiyat. Tam nan ne’ets quin otsits, tamna’ u oc’ox otsel q’ue’at i ya’ul. ");
INSERT INTO husNT1971_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Tam uchan c’al a Jesús: ―Quit ts’acpan ca thaya’ a tatil ani quit belatsits. ");
INSERT INTO husNT1971_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Tam tin ulpiy antsana’ a Jesús, tam ti huelc’anits an yau’lats tin inictal. Tam ojni’ in thaya’ in tatil ani belatsits. Pel i sábado tam ti jeltha. ");
INSERT INTO husNT1971_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Uchan c’al talchic i Israelchic axi taja’ c’uajat: ―In ulal an ts’ejcath cau axi pithnenec a Moisés c’al a Dios yabcua’ ca thaya’ a tatil tam sábado. Xo’ pelits i sábado ani tata’ ojni’ a thayamal. ");
INSERT INTO husNT1971_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Toc’tsin axi ya’ulac: ―An inic ax tin jeltha’ tin ucha’ cu thaya’ u tatil ani quim belats. ");
INSERT INTO husNT1971_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Tam conoyat: ―¿Jita’ nixe’ hualam ax ti ucha’ ca thaya’ a tatil ani quit belats? ");
INSERT INTO husNT1971_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ani jaja’ yab in tso’ob max pel c’al a Jesús ti jeltha, cum tixc’anenequits taja’ ani jaye hua’ats yantalam i inic muthat. ");
INSERT INTO husNT1971_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ma talbel tamuhuatits c’al a Jesús ti al an tiyopan ani uchan: ―Xohue’ it jelthachits. Ca lej luba’ ta ba’ yabats quit hualbin, i quit c’athpich yajchiquiyat yab ejtil ti oc’ox. ");
INSERT INTO husNT1971_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Tam c’ale axi ya’ulac in olchi an Israelchic abal c’al a Jesús jats ti jeltha. ");
INSERT INTO husNT1971_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ani jaja’chic tocat in aynal a Jesús in le’ quin tsemtha’ tin ebal abal in jeltha’ an ya’ul tam sábado. ");
INSERT INTO husNT1971_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Uchanchic c’al a Jesús: ―Cum u Tata ti eb yab jayq’ui’ im palc’anchal ti t’ojnal, jaxtam nana’ne yab u palc’anchal. ");
INSERT INTO husNT1971_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Tam ti an Israelchic in ats’a’ antsana’ in ulu a Jesús, tam tin más luba’ quin tsemtha’. In le’chic quin tsemtha’ tin ebal abal in ulu a Dios pel in Tata ti eb, ani yab expith tin ebal abal in jec’onchi an ts’ejcath cau tam in jeltha’ an ya’ul tam sábado. In tsalpanchalchic abal a Jesús in le’ quin ulu c’al nixe’ xi cau jununul in ey c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Tam a Jesús in ucha’ nixe’ xi Israelchic: ―Lej chubax nan tu uchalchic abal pel tin Tsacamil a Dios. Jahua’ nan u tsu’tal u Tata ti eb in t’ajal, jats expith u t’ajalne. Ni jant’o yab u ejtohual cu t’aja’ tu cuete’ tsalap. U t’ajalne patal jahua’ quin t’aja’ u Tata ti eb. ");
INSERT INTO husNT1971_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Cum pel tin Tsacamil u Tata ti eb, jaxtam jaja’ tin lej c’anithal ani tin lej tso’oblinchal patal jahua’ in t’ajal. Tim pitha’ u eyaltal cu jeltha’ nixe’ xi ya’ul. Aba ani’ pel i labith t’ajbilab u t’ajchamal, bel u Tata ti eb ne’ets tiquin tolmiye cu t’aja’ i más pulic labith t’ajbilab. Tam ojni’ ne’ets ca c’athpich jic’pa’chic. ");
INSERT INTO husNT1971_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Jant’ini’ u Tata ti eb in ejthal i tsemelom, antsana’ ne’etsne cu t’ajchi jitats cu le’nanchi. ");
INSERT INTO husNT1971_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","U Tata ti eb yab ne’ets quin ts’ejca’ an inicchic, cum tim pithamalits nana’ tin Tsacamil u eyaltal cu ts’ejcanchichic. ");
INSERT INTO husNT1971_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Antsana’ tim pithamal u eyaltal, abal an inicchic tiquin c’ac’na’ne jant’ini’ u c’ac’nax jaye c’al u Tata ti eb. Max yab tin c’ac’nalne, yab chubax in c’ac’nalchic u Tata ti eb, cum ja’its u Tata ti eb ax tin aba’ quin chich teje’ tsabal. Nana’ tin Tsacamil a Dios quin c’ac’na jayetseq’ui jant’ini’ tu c’ac’nab u Tata ti eb. ");
INSERT INTO husNT1971_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Lej chubax nan tu uchalchic max tata’chic tin t’ajchal ti cuenta u cahuintal jahua’ nan tu uchal ani ca bela’ u Tata ti eb ax tin aba’ quin chich teje’ tsabal, tam nan ne’ets tu pitha’ i it ejattalab abal quit ets’ey c’uajiy c’al a Dios. Quit pithanits i it ejattalab ani yabats ne’ets quit jolbiyat c’al a Dios, ani yabats ne’ets quit xe’tsin ejtil max it tsemenec al i hualabtalab. ");
INSERT INTO husNT1971_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Lej chubax im bajumalits an hora abal nan cu pitha’ an inicchic i it ejattalab. Nana’ tin Tsacamil a Dios ne’ets cu tauna’chic axi ejtil max tsemenec al i hualabtalab, ani ne’ets cu pitha’ i it ejattalab jitats tiquim belchi u cahuintal. ");
INSERT INTO husNT1971_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Jant’ini’ u Tata ti eb in cua’al in cuete’ lej tsap ti ejatlix, antsana’ tim pitha’ne u cuete’ lej tsap tin ejatlix. ");
INSERT INTO husNT1971_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Cum nana’its tin Juntal patal an inicchic, jaxtam u Tata ti eb tim pitha’ u cuete’ lej tsap cu t’ajchi an inicchic an ts’ejcaxtalab. ");
INSERT INTO husNT1971_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Yab ca jic’pa’chic abal antsana’ u cua’al u cuete’ lej tsap. Lej chubax ne’ets quim baju an hora tam ne’ets cu tauna’ ca ejtha patal an tsemelomchic abal cu t’ajchi an ts’ejcaxtalab. ");
INSERT INTO husNT1971_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Ne’ets cu caltha’chic ti al an jolimtalabchic jun ti jolith. Ne’ets ca c’uajiy c’al a Dios jaja’chic ax in t’ajamal alhua’, ani ne’ets ca t’ajat jolbiyat c’al a Dios jaja’chic ax in t’ajamal yab alhua’. ");
INSERT INTO husNT1971_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ni jant’o yab u ejtohual cu t’aja’ tu cuete’ tsalap. U t’ajchal an inicchic an ts’ejcaxtalab expith jant’ini’ tin uchbiyame c’al u Tata ti eb. U t’ajchal c’al i bolithtalab jant’ini’ in le’ u Tata ti eb cu t’ajchi. Yab u t’ajchal an ts’ejcaxtalab jant’ini’ nan u le’ tu cuete’ tsalap, expith jant’ini’ ti quin le’na’ u Tata ti eb ax tin aba’ quin chich teje’ tsabal. ");
INSERT INTO husNT1971_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Yab lej exbath u olnomtal max nan expith cu olna’ u cuete’ ey. ");
INSERT INTO husNT1971_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Hua’ats jita’ ax tin olnanchal u ey, ani jats axi lej exbath ani chubax an olnomtalab. ");
INSERT INTO husNT1971_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Tata’chic a aba’ ca c’ale i inicchic c’al a Juan tiquin conchinchi u ey, ani jahua’ olchin jats lej chubax an cau. ");
INSERT INTO husNT1971_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Aba ani’ yab u lej yejenchal jita’ tiquin olnanchi u ey, bel tu uchalchic lej chubax an cau jahua’ ti olchichic a Juan tin cuenta u ey. Antsana’ tu uchalchic max jita’ in le’ ca chich c’al nana’ ani ca jec’ontha. ");
INSERT INTO husNT1971_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","An cau ax ti olchichic a Juan pel ejtil i tajaxtalab lej tajajal, ani jun hue’ tocat a culbetnanchichic. ");
INSERT INTO husNT1971_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Exbath in olnomtal a Juan tin cuenta u ey ani lej c’athpich exbath in olnomtal an t’ajbilabchic jahua’ nan u t’ajal. Cum jahua’ nan u t’ajal jats tin uchbiyamal u Tata ti eb cu t’aja’, ani jats c’al tin tejhua’methanchal u lej ey abal in abnenec c’al u Tata ti eb. ");
INSERT INTO husNT1971_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Tin tejhua’methanchal u ey u Tata ti eb c’al an t’ajbilabchic ax a tsu’chal u t’ajal jant’ini’ tin uchbiyamalits u Tata ti eb cu t’aja’. Aba ani’ ni jayq’ui’ yab a ats’amal ti lej cau a Dios ani yab a tsu’chamal in hual, bel c’al axe’ xi t’ajbilabchic jahua’ u t’ajal it jilchinal i tejhua’methaxtalab tin cuenta u ey ani tin cuenta in ey u Tata ti eb. ");
INSERT INTO husNT1971_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Tejhua’ abal yab a alhua’ penamal in cahuintal a Dios ta ichich, cum yab a belal abal chubax in abnenec c’al u Tata ti eb quin chich teje’ tsabal. ");
INSERT INTO husNT1971_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Tata’chic a lej exobnanchal an T’ocat Thuchlab cum a tsalpayal tats ne’ets ca elcanchi quit it ejatliyat ani quit ets’ey c’uajiy c’al a Dios. Ja’its xe’ ax tin olnanchal u ey. ");
INSERT INTO husNT1971_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Tocat yab a le’chic quit chich c’al nana’ abal nan tu pitha’ i it ejattalab abal quit ets’ey c’uajiy c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Yab lej exbath max quim puhuethanchat u bij expith c’al an inicchic. ");
INSERT INTO husNT1971_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Nan tu exlanchalchic a ichich abal yab chubax a c’anithal a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Aba ani’ in abnenec ani in uchbiyame c’al u Tata ti eb, bel tata’chic yab tim bats’uhual. A bats’uhualchic c’al a culbetal axi ca chich c’al in cuetemtal yab uchbiyame c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Yab a ejtohualchic tiquim belchi u cahuintal, cum tocat a le’ quit tsalpanchat tit alhua’ inic jun c’al xi jun ani yab c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Aba ani’ tata’chic yab tim belal, nan yab ne’ets tu jolbiy c’al u Tata ti eb. In thuchath cahuintal a Moisés jats ti jolbiyalchic, cum yab chubax a belchal. Jats ax a palenchalchic. ");
INSERT INTO husNT1971_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Max chubax a belchalac in thuchath cahuintal a Moisés, tam tin belchalacne u cahuintal. Tim belalacne cum nan in olnab ti al in thuchath cahuintal a Moisés. ");
INSERT INTO husNT1971_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Max yab ca belchichic in thuchath cahuintal a Moisés, ni abal jay yab ne’ets tiquim belchi u cahuintal jahua’ nan tu uchalchic. ");
INSERT INTO husNT1971_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Taley talbel a Jesús c’ale jum poq’ue’ am pulic lejem Galilea ax u bijiyab jaye ti Tiberias. ");
INSERT INTO husNT1971_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ani tihua’ ne’ets jaye yantalam i inic c’al ti tsu’chame an labith t’ajbilabchic jahua’ in t’ajamal c’al yantalam i ya’ulchic. ");
INSERT INTO husNT1971_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Tam huahua’ tu exobal ani c’al a Jesús u c’athiy al i bolchal, ani buxcan taja’ a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Hue’its ne’ets quim baju an Israelchic quin t’aja’ an ajib tin cuenta abal ti calthame ti Egipto im biyal juntalchic. ");
INSERT INTO husNT1971_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Cum a Jesús in tsu’tal ts’at’at yantalam i inicchic, in ucha’ a Felipe: ―¿Ju’ta ti qui ts’a’iy i c’apnel abal ca c’aputs axe’ xi yantalam i inicchic? ");
INSERT INTO husNT1971_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","A Jesús in exlalits jant’o ne’ets quin t’aja’ abal ca c’aputs am pulic mulcunel, expith in conoyq’ui a Felipe in le’ quin ats’a’ jant’ini’ ti ne’ets quin toc’tsiy. ");
INSERT INTO husNT1971_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Tam toc’tsin a Felipe: ―C’al tsab i bo’ inic i tumin denario i c’apnel qui ts’a’iy, ma yab ne’ets quim baju quin huachic bats’u tim patal an inicchic axi muthat teje’. ");
INSERT INTO husNT1971_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Tam uchan a Jesús c’al junaque in exobalil im bij a Andrés axi pel in ebchal a Simón Pedro: ");
INSERT INTO husNT1971_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―C’uaját teje’ jun i cuitol ax in cua’al bo’ i pan ani tsab i to’ol. Ni hue’ lejat yab ne’ets ca lejey ca c’aputs axe’ xi yantalam i inicchic. ");
INSERT INTO husNT1971_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Tam a Jesús tu ucha’chic: ―Ca ucha’ tim patal an inic axi muthat ca buxcan tsabal. Ani axi buxcan bo’ mil i inic taja’ jun ti hua’ats yan i tsacam tom. ");
INSERT INTO husNT1971_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Tam a Jesús im bats’u axi bo’ i pan ani im bina’ i c’ac’namal yan c’al a Dios. Taley tu pitha’ huahua’ qui huat’banchi an mulcunel axi quetechic taja’. Jayetseq’ui in t’aja’ a Jesús c’al xi tsab i to’ol. Ani patal an mulcunel im bats’uhual jayits in le’ quin c’apu. ");
INSERT INTO husNT1971_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Tam ti ajhuejits patal an mulcunel, tam a Jesús tu ucha’ huahua’ tu exobalil: ―Ca thaya’ patal an jilc’omach yab ca jila’ ca jolat q’uibey. ");
INSERT INTO husNT1971_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","I thaya’ ani i t’uchiy lajuj tsab i t’ocnal c’al an jilc’omach pan. ");
INSERT INTO husNT1971_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Tam tin tsu’u an mulcunel abal antsana’ in t’ajamal an labith t’ajbilab a Jesús, in ulu: ―Lej chubax axe’ ja’its an caulome axi bijithits c’al a Dios ne’ets ca chich teje’ tsabal. ");
INSERT INTO husNT1971_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Cum a Jesús in tso’obits abal u le’nab ca yac’uan c’al an mulcunel ani ca punuhuat c’al i tsaplab ti ts’ale c’al jaja’chic, jaxtam tixc’an ani c’ale cuetem al jun i oc’ bolchal. ");
INSERT INTO husNT1971_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Tam ti aclets tam tu c’alets huahua’ tu exobalil a Jesús, cu pa’iy tin hualte’lil am pulic lejem. ");
INSERT INTO husNT1971_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","U ulits ani u otsits al i tan cu c’ale ti jun i bichou im bij Capernaum axi jum poq’ue’ am pulic lejem. Tam tu ne’ets huat’elitschic al an ja’ tam ti yic’uaxits, ani xant’o a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ts’i’quin tam ca juchun lej tsapic an ic’ ani lej tsapic lanq’uil an ja’. ");
INSERT INTO husNT1971_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Tam ti belthamalits an tan max bo’ o max acac i kilómetro, tam i tsu’u a Jesús abal tal utetel utat an tan. Tal ti belbel eblim an ja’, ani tocat u jiq’uel huahua’. ");
INSERT INTO husNT1971_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","A Jesús tu ucha’chic: ―Cum nana’its jats ax in tal yab quit jiq’ueychic. ");
INSERT INTO husNT1971_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Tam c’al i lej culbetalab i bats’u ca otsits al an tan. Ani thubat u ulits ma tihua’ jun tu ne’etschic. ");
INSERT INTO husNT1971_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Jilc’onenec i inicchic jum poq’ue’ al am pulic lejem jun tu calnequitschic taja’ huahua’ tu exobalil a Jesús. Aytalab q’uicha in t’aja’chic ti cuenta abal xant’o axi juncats an tan axi c’uajatac. In tso’obits jaja’chic abal cuetem tu c’alnequits huahua’ ani yab c’uajat a Jesús c’al huahua’. ");
INSERT INTO husNT1971_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Biyat ulcanalits i tanchic axi tal ti bichou Tiberias. Ulcanalitschic taja’ al in hualte’lil am pulic lejem utat jun ti c’apumath am pulic mulcunel c’al am pan ani c’al an to’ol. Tats tim binamalits an Ajatic i c’ac’namal yan c’al a Dios ani tats tim pijchamal am pulic mulcunel. ");
INSERT INTO husNT1971_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Tam tin tsu’u jaja’chic abal xant’o a Jesús ani huahua’ tu exobalil, tam otsits al an tanchic axi it ulnec ca chich ti bichou Capernaum abal taja’ quin aliychic a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ultsits nixe’ xi inicchic jum poq’ue’ tin hualte’lil am pulic lejem, ani in ela’ a Jesús taja’. In conoychic: ―¿Jayq’ui’ tit ulits teje’, Exobchix? ");
INSERT INTO husNT1971_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","A Jesús in toc’tsiychic: ―Lej chubax nan tu uchalchic abal nan tin aliyal tocat abal it ajhuejits c’al am pan, ani yab tin aliyal abal max tim belalac abal u t’ajal i labith t’ajbilabchic ti tsu’bixtalab c’al u ey. ");
INSERT INTO husNT1971_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Yab ca c’athpich t’e’pinchi an c’apnel ax u talel ax tin cuenta a inictal. Ca luba’ ca co’onchi an c’apnel axi yab u talel, jahua’ nana’ tin Juntal patal an inicchic u le’ tu pitha’chic. Jats axi tin cuenta a ejattal c’al quit ejatliyat abal quit ets’ey c’uajiy c’al a Dios. Tim pitha’ a Dios Tatalab ti eb u uchbil abal nan tu pitha’chic axe’ xi c’apnel tin cuenta a ejattal. ");
INSERT INTO husNT1971_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Tam conoyat a Jesús c’al jaja’chic: ―¿Jant’o pel i uchbil qui t’aja’ abal ca jilc’on culbel a Dios c’al huahua’? ");
INSERT INTO husNT1971_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","A Jesús in toc’tsiychic: ―Pel in culbetal a Dios abal tata’chic tiquim bela’ nana’. Nana’its ax in abnenec c’al a Dios quin chich teje’ tsabal abal tiquim bela’ an inicchic. ");
INSERT INTO husNT1971_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Conoyat a Jesús tam: ―¿Jant’o tam tsu’bixtalab a ejtohual tucu t’ajchi abal qui exla’ max chubax it abnenec c’al a Dios ani chubax huahua’ qui bela’ tata’? ");
INSERT INTO husNT1971_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Alhua’ max tu pithalac jant’o qui c’apu jant’ini’ ti pithnenec c’al a Dios i biyal juntalchic i c’apnel i maná quin c’apuchic tam ti xe’tsin ti al an joltam ti jayq’ui’. In ulal an T’ocat Thuchlab antse’: A Dios im pitha’chic i c’apnel axi ti eb quin c’apu. ");
INSERT INTO husNT1971_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","A Jesús in toc’tsiychic: ―Lej chubax nan tu uchalchic abal a biyal juntalchic pithnenec i c’apnel axi ti eb c’al u Tata ti eb, ani yab pithnenec nixe’ xi c’apnel c’al a Moisés. Ani xohue’ u Tata ti eb ti abchamalits tata’chic an c’apnel axi lej chubax tal ti eb tin cuenta a ejattalchic. ");
INSERT INTO husNT1971_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ti abchamalitschic xo’ jaja’ axi pa’inequits tal ti eb in it ejatlinchal in ejattal an inicchic. ");
INSERT INTO husNT1971_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Tam uchan a Jesús c’al jaja’chic: ―I lej le’ max tata’ pay’lom tucu ets’ey pitha’ nixe’ xi c’apnel ax a ulal. ");
INSERT INTO husNT1971_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","A Jesús in ucha’chic: ―Nana’its in ejtil i c’apnel tin cuenta in ejattal an inicchic. Jitats ca chich c’al nana’ ni jayq’ui’ yab ne’ets ca c’a’iy in ejattal. Jitats tiquim bela’ nana’ ni jayq’ui’ yab ne’ets ca chiquey in ejattal. ");
INSERT INTO husNT1971_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Aba ani’ tin tsu’umalits tata’chic yab a le’ tiquim bela’. Antsana’ nan tu ucha’itschic abal yab a le’ tiquim bela’. ");
INSERT INTO husNT1971_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Bel ne’ets ca chich c’al nana’ patal jitats quim pithan c’al u Tata ti eb nan cu c’alna’. Ja’its axi jaja’chic ne’ets cu bats’u, yab cu pojca’. ");
INSERT INTO husNT1971_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","In tal ti eb ani in che’nequits teje’ tsabal abal cu t’ajchi in culbetal a Dios ani iba nana’ u culbetal. Ja’its a Dios ax tin aba’ quin chich teje’ tsabal. ");
INSERT INTO husNT1971_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Pel tin abathualejil u Tata ti eb. Pel in culbetal jaja’ cu alhua’ beletna’ an inicchic axi jaja’ tim pithamal nan cu c’alna’. Yab cu jilchi ma ni jun ca q’uibey. Ani an tsemelomchic talbel ne’ets cu ejtha’ tam quim baju an taltalab q’uicha axi pejathits c’al a Dios ca ejthachic. ");
INSERT INTO husNT1971_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Nana’its tin Tsacamil a Dios, ani pel in culbetal a Dios abal patal jitats tiquin tsu’u ani tiquim bela’, jats jaja’chic cu pitha’ i it ejattalab abal ca ets’ey c’uajiy c’al a Dios. Ja’its jaja’chic axi ne’ets cu ejtha’ tam quim baju an taltalab q’uicha axi pejathits c’al a Dios ca ejthachic. ");
INSERT INTO husNT1971_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Tam talchic axi taja’ an Israelchic in ts’i’quiy quin c’uiya’ a Jesús, cum in ulumalits abal jaja’ pel i c’apnel axi tal ma ti eb tin cuenta in ejattal an inicchic. ");
INSERT INTO husNT1971_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","In uluchic: ―Auxe’ max yab i ja’its a Jesús axi pel in tsacamil a José. I exlanchalits in tata ani in mim. ¿Jale’ in ulu abal tal ma ti eb? ");
INSERT INTO husNT1971_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Tam a Jesús in ucha’chic: ―Yabats tiquin c’uiya’. ");
INSERT INTO husNT1971_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","U Tata ti eb jats tin aba’ quin chich teje’ tsabal, ani ni jita’ yab in ejtohual ca chich c’al nana’ max yab ca quinchin in ichich c’al u Tata ti eb. An tsemelomchic ne’ets cu ejtha’ tam quim baju an taltalab q’uicha axi pejathits c’al a Dios ca ejthachic. ");
INSERT INTO husNT1971_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Thuchathits al an T’ocat Thuchlab jahua’ in ulu in caulomejilchic a Dios ti jayq’ui’ antse’: Ne’ets ca exobchin tim patal an inicchic c’al a Dioscua’. Ani xohue’ patal jitats ca chubax exobchin c’al u Tata ti eb ani quin ats’anchi in exobchixtal, jats ne’ets ca chich c’al nana’. ");
INSERT INTO husNT1971_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Yab u ulal abal hua’ats jita’ in tsu’umalits u Tata ti eb, expith nana’ jats u tsu’umalits. Nana’ jats in tal ma ti eb c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Lej chubax nan tu uchalchic abal jitats tim belamal nana’, jats ax u pithamalits i it ejattalab ca c’uajiy ets’ey c’al u Tata ti eb. ");
INSERT INTO husNT1971_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Nana’its in ejtil i c’apnel tin cuenta in ejattal an inicchic. ");
INSERT INTO husNT1971_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Lej chubax a biyal juntalchic in c’apu an maná ti jayq’ui’ tihua’ ti al an joltam, ani bel tsemets jaja’chic cum yab lej jum putat ejatliyat abal ets’ey. ");
INSERT INTO husNT1971_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","An c’apnel jahua’ nan tu olchalchic jats axi pa’inec tal ma ti eb. Jitats quin c’apu ne’ets ca it ejatliyat ani ca ets’ey c’uajiy c’al a Dios ti eb. ");
INSERT INTO husNT1971_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nana’its in ejtil i c’apnel ani im pa’inec tal ma ti eb. Jitats quin c’apu axe’ xi c’apnel jats c’al ti ne’ets ca it ejatliyat ani ca ets’ey c’uajiy c’al a Dios ti eb. U anam t’u’ul nana’ ja’its ejtil i c’apnel. Ne’ets cu bina’ tu ba’ abal ca it ejatliyat an inicchic. ");
INSERT INTO husNT1971_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Tam an Israelchic axi taja’ c’uajat in ts’i’quiy quin t’iloxnanchi jahua’ in ulu a Jesús antsana’ c’al in anam t’u’ul. In uluchic: ―¿Jant’ini’ tin ejtohual axe’ xi inic quim bina’ in anam t’u’ul ani qui c’apchi? ");
INSERT INTO husNT1971_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","A Jesús in ucha’chic: ―Nana’its tin Juntal patal an inicchic. Expith max ca c’apchi u anam t’u’ul ejtil max pel in c’apnel ani max ca uts’anchi u xits’al ejtil max pel in uts’nel, tamna’ ne’ets quit it ejatliyatchic. ");
INSERT INTO husNT1971_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","U it ejatliyab abal ets’ey jitats tin c’apchal u anam t’u’ul ejtil i c’apnel ani tin uts’anchal u xits’al ejtil i uts’nel. Aba ani’ ca tsemets, nan ne’ets cu ejtha’ tam quim baju an taltalab q’uicha axi pejathits c’al a Dios ca ejtha an tsemelomchic. ");
INSERT INTO husNT1971_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","U anam t’u’ul pel i lej chubax c’apnel ani u xits’al pel i lej chubax uts’nel tin cuenta in ejattal an inicchic ca it ejatlinchat. ");
INSERT INTO husNT1971_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Jitats tin c’apchal u anam t’u’ul ejtil i c’apnel ani tin uts’anchal u xits’al ejtil i uts’nel jats axi junini’ ts’ot’c’óx c’al nana’. ");
INSERT INTO husNT1971_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","U Tata ti eb axi ets’ey ejat jats tin aba’ quin chich teje’ tsabal, ani ja’its jaja’ ax u ejatnal. Jitats tin c’apchal u anam t’u’ul ejtil i c’apnel ani tin uts’anchal u xits’al ejtil i uts’nel jats ax tin ejatnal nana’. ");
INSERT INTO husNT1971_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","U olnal tu ba’ abal nana’its in ejtil i c’apnel ani im pa’inec tal ma ti eb. Jitats quin c’apu axe’ xi c’apnel jats c’al ti ne’ets ca it ejatliyat ani ca ets’ey c’uajiy c’al a Dios ti eb. Axe’ xi c’apnel yab ja ejtil an maná axi pithnenec a biyal juntalchic ti al an joltam ti jayq’ui’. Jats nixe’ ja in c’apuchic ani bel tsemets. ");
INSERT INTO husNT1971_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Antsana’ c’al axe’ xi cau tin cuenta an c’apnel a Jesús in exobchi an tamcunel al in tiyopanil an Israelchic ti Capernaum. ");
INSERT INTO husNT1971_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Tam tin ats’a’itschic antsana’ an cau in exobchi a Jesús tin cuenta an c’apnel, tamna’ yan axi ts’at’enec c’al a Jesús in ulu: ―Lej q’uibat qui belchi axe’ xi cau. ¿Jita’ hualam in ejtohual quin exbay? ");
INSERT INTO husNT1971_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Tam a Jesús in t’ajchichic ti cuenta abal in le’ ti toc’oc’ol c’al nixe’ xi cau tin cuenta an c’apnel. In conoychic: ―¿It t’apchinal a tsalap c’al axe’ xi cau? ");
INSERT INTO husNT1971_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Max it t’apchinal c’al axe’ xi cau, más ne’ets quit t’apchin max tiquin tejhua’ tsu’u nana’ tin Juntal patal an inicchic quin c’athiy ti eb jun tin talac. ");
INSERT INTO husNT1971_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","A ejattal jats c’al tit ejatchic. Yab lej exbath a inictal. An cau jahua’ nan tu olchamalitschic pel tin cuenta a ejattal ani jats c’al quit ejatlinchat a ejattal. ");
INSERT INTO husNT1971_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Aba ani’ lej chubax an cau jahua’ nan tu olchamalitschic, bel talchic c’al tata’ hua’ats yab a belchamal. In q’uejab tso’obits a Jesús jita’ c’al ti yab ne’ets ca belan ani jita’ c’al ti ne’ets ca tsinat bina tin c’ubac in tomolnaxilchic. ");
INSERT INTO husNT1971_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Tam in ulu a Jesús: ―Nan tu uchamalitschic abal ni jita’ yab in ejtohual ca chich c’al nana’ max yab ca quinchin in ichich c’al u Tata ti eb. ");
INSERT INTO husNT1971_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ma tamna’its ti tixc’an c’al a Jesús yantalam, i inic ani yabats xe’tsinchic c’al jaja’. ");
INSERT INTO husNT1971_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Tam a Jesús tu conoy huahua’ lajuj tsab tu exobalil: ―¿A le’chicte quit tixc’an c’al nana’? ");
INSERT INTO husNT1971_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Toc’tsin a Simón Pedro: ―¿Ajatic, jita’ c’al tu cu c’ale huahua’ cum yab jita’ in olnal i cau ax tata’ a olnal? Expith tata’ tu olchalchic i cau c’al cu it ejatliyat abal cu ets’ey c’uajiy c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","I belchamalits a cahuintal. I lej tso’obits abal tata’its it Cristo ax it bijithits ne’ets quit aban c’al a Dios quit chich. Pel ti Tsacamil a Dios, ani pel in ey a Dios ejat abal ets’ey. ");
INSERT INTO husNT1971_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","A Jesús tu toc’tsiychic: ―Lajuj tsab ta eb axi nana’ tu tacuyamalits abal tiquin ts’at’enchi, ani jun jats axi ts’at’at c’al an teneclab. ");
INSERT INTO husNT1971_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","C’al axe’ xi cau jahua’ in ulal a Jesús in olnal a Judas Iscariote axi pel in tsacamil a Simón. Aba ani’ ajithits c’al huahua’ tu lajuj tsab tu exobalil a Jesús, bel jaja’ ja’its axi ne’ets quin tsinat bina’ a Jesús tin c’ubac in tomolnaxilchic. ");
INSERT INTO husNT1971_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Taley talbel xe’ets a Jesús ti Galilea. Yab in le’na’ ca xe’tsin ti Judea, cum hua’ats talchic i Israel in le’ ti tsemthax c’al jaja’. ");
INSERT INTO husNT1971_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Hue’its ne’ets quim baju a q’uicha tam an Israelchic quin t’aja’ an ajib tin cuenta an tamcuth hualilab, tam tu ts’ejcab i tsacam pathel ata jun tu c’uajil an ajibalchic buc a q’uicha tu t’ajnal an ajib. ");
INSERT INTO husNT1971_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Uchan a Jesús c’al in cuete’ ebchalchic: ―Quit tixc’an teje’ ani quit c’ale ti Judea abal tihua’ ca t’ajchi i tsu’bixtalab a ts’at’elilchic jaye. ");
INSERT INTO husNT1971_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ni jita’ tam inic ne’ets quin t’aja’ jant’o tsinat max in le’ ca exla c’al in at inic. Ca t’ajchi i labith t’ajbilabchic patal an inic abal ti exla’. ");
INSERT INTO husNT1971_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ma c’al in cuete’ ebchalabchic a Jesús yab u belnal. ");
INSERT INTO husNT1971_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Tam a Jesús in ucha’chic: ―Xoq’ui yabaye im bajumal an hora abal nan quin c’ale ti Judea. Tata’chic a tsalpayal abal jahuaquitsq’ui tam hora alhua’ max quin c’ale. ");
INSERT INTO husNT1971_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Tim pojcal nana’ axi yab exlomchic c’al a Dios, cum u olchal max quin t’aja’ jahua’ yab alhua’. Yab ti pojcal tata’chic, cum a ey ejtil jaja’chic in ey. ");
INSERT INTO husNT1971_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Tata’chic quit c’ale ti Judea c’al an ajib. Nana’ yabaye in ne’ets, cum yabaye im bajumal an hora abal quin c’ale. ");
INSERT INTO husNT1971_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Antsana’ a Jesús in ucha’chic in cuete’ ebchal. Ani jaja’ jilc’on ti Galilea. ");
INSERT INTO husNT1971_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Taley tam ti c’alets in cuete’ ebchalchic a Jesús c’al an ajib, tam ta c’ale jaja’ jaye a Jesús talbel. C’ale tsininil abal yab ca exla. ");
INSERT INTO husNT1971_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Hua’ats i Israelchic tihua’ al an ajib xe’ets alililchic c’al a Jesús ju’ta ti quin ela’. Xe’ets in conomichical: ―¿Ju’ta ti c’uajat nixe’ xi inic? ");
INSERT INTO husNT1971_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","U cue’ t’iloxnab a Jesús c’al an ajibalchic axi xe’ets taja’. Talchic in ulu pel i alhua’ inic, ani talchic in ulu yab pel i alhua’ inic, cum tocat in c’ambiyal an iniccua’. ");
INSERT INTO husNT1971_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ni jita’ yab in lubal quin lej tejhua’ ulu jant’o in ey a Jesús, cum in ts’ejnal ca c’uiyan c’al an Israelchic c’al ti yab le’nab a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ts’ejelomits ne’ets ca taley an ajib tam ti otsits a Jesús al an tiyopan, ani in ts’i’quiy ti exobchix taja’ c’al in cahuintal a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ani lej jic’panchab in exobchixtal c’al an Israelchic. In uluchic: ―¿Jant’ini’ tin exlamal axe’ xi inic yan i cau ani yab exoblamath? ");
INSERT INTO husNT1971_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","A Jesús in toc’tsiychic: ―Jahua’ nan u exobchixnal an cau jats ax tim pitha’ u Tata ti eb ax tin aba’ quin chich teje’ tsabal, yab nana’ u cuete’ cahuintal u exobchixnal. ");
INSERT INTO husNT1971_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Jitats in ne’thal in ichich ts’ejcacathits quin t’ajchi in culbetal a Dios, jats axi ne’ets quin exla’ max pel i cau ax tim pithamal a Dios jahua’ u exobchixnal o max pel u cuete’ cahuintal ax u exobchixnal. ");
INSERT INTO husNT1971_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Hua’ats jita’chic in exobchixnal in cuete’ cahuintal abal ca puhuethanchat in ey. Nana’ expith u exobchixnal an cau ax tim pithamal a Dios abal ca puhuethanchat im bij jaja’. Lej chubax an cau jahua’ nan tu olchalchic. Nan yab in c’ambix. ");
INSERT INTO husNT1971_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Aba ani’ lej chubax a cua’alchic nixe’ xi ts’ejcath cau binath c’al a Moisés, bel ni jita’ tata’chic yab a putuhual xe’. ¿Jale’ a le’chic tiquin tsemtha? ");
INSERT INTO husNT1971_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Toc’tsinchic axi muthat taja’: ―¿Jita’ in le’ ti tsemtha? Tata’ ojni’ it co’oyab c’al i at’ax teneclab. ");
INSERT INTO husNT1971_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Tam a Jesús in ucha’chic: ―Cum nan u t’ajchi i alhua’talab jun i inic tam sábado, tocat a jic’pal ta patalchic. ");
INSERT INTO husNT1971_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Tata’chic tam quim bajuhuits huaxic a q’uicha ti hua’tsinenec an inic t’ele’, a ujnam ca cojchi in inictal abal pel in c’al a Dios an t’ele’. Max quim bajuhuits an huaxicchilab q’uicha pel i sábado, bel a cojchal in inictal jant’ini’ a biyal juntalchic in t’ajamal jaye. Pel xe’ i ujnamtalab axi oc’ox t’ajnenec c’al a biyal juntalchic ani talbel jaye c’al a Moisés. ");
INSERT INTO husNT1971_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Aba ani’ pel i sábado antsana’ a t’ajalchic an inic t’ele’ cum a le’ ca putu c’al an ts’ejcath cau ax ti uchbiyal antsana’ ca t’ajchi. Cum antsana’ a t’ajalchic tam sábado, jaxtam yab in tomnal quit tsacuychic c’al nana’ abal u jeltha’ jun i ya’ul tam sábado. ");
INSERT INTO husNT1971_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ca lej tequeth tsalpanchi jahua’ nan u t’ajamal ani yab jun athic ca eblim tsalpanchiq’ui. ");
INSERT INTO husNT1971_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Tam talchic ax u c’uajilchic ti Jerusalén in conoyal: ―¿Hualam max ja’its axe’ xi inic jaja’ u aliyab le’nab ca tsemtha? ");
INSERT INTO husNT1971_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ca tsu’u lej tejhua’ t’ilom c’al an inicchic, ani yab u c’uiynal. Hualam max an oc’lecchic c’al an Israel in chubax belal abal ja’its axe’ a Cristo axi bijithits ne’ets ca aban c’al a Dios ca chich. ");
INSERT INTO husNT1971_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Hualam yab ja axe’, cum i tso’obits ju’ta ti tal. Tam ca chich a Cristo ni jita’ yab ne’ets quin tso’obna’ ju’ta ti tal. ");
INSERT INTO husNT1971_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Exom a Jesús ti exobchix ti al an tiyopan. Tam tin ats’a’ jaja’ antsana’ u t’iloxnab, in lej tsapic ulu: ―Tata’chic tin exlalac ani a tso’obnalac ma ju’ta tin tal. In che’nec teje’ tsabal cum in abnenec c’al jun axi tata’chic yab chubax a exlal. Ja’its a Dios axi lej chubax ejat tin abamal quin chich teje’ tsabal, ani yab in che’nec abal max expithac nana’ u lej le’ quin chich. ");
INSERT INTO husNT1971_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Nana’ u lej chubax exlal a Dios, cum in tal ma lej tihua’ ti eb. Ja’its jaja’ ax tin aba’ quin chich teje’ tsabal. ");
INSERT INTO husNT1971_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Tam c’al talchic i Israel u lej le’nab ca yac’uan a Jesús, ani yab ejtohuat cum yabaye im bajumal an hora axi pejchame c’al a Dios ca yac’uan. ");
INSERT INTO husNT1971_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Aba ani’ antsana’ le’nab ca yac’uan, bel hua’ats yantalam i inic c’al tu belnal. In ulu jaja’chic: ―Auxe’ max jant’o tam labith t’ajbilab más ne’ets quin t’aja’ a Cristo tam ca chich ani max axe’ a Jesús jaja’ yab in t’ajamal. Tejhua’ abal ja’its jaja’ a Cristo c’al in labith t’ajbilchic. ");
INSERT INTO husNT1971_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Tam ti an fariseochic in tso’obna’its abal antsana’ tu t’iloxnab a Jesús, tamna’ jaja’chic ani c’al an ts’alechic c’al am pale’ in aba’ ca c’alechic i yac’ual abal quin yac’ua’its a Jesús. Pel i yac’ualchic ax u abatnab c’al am pale’chic. ");
INSERT INTO husNT1971_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ultsitschic ani uchan c’al a Jesús: ―Hue’ ne’ets quin c’uajiye teje’ tsabal c’al tata’chic, ani talbel ne’ets quin huichiy c’al jaja’ ax tin abamal quin chich teje’ tsabal. ");
INSERT INTO husNT1971_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Tata’chic ne’ets tiquin aliy tamna’, ani yabats ne’ets tiquin ela’ ma ni ju’ta. Yab ne’ets ca ejtouchic quit ulits jun ti nan ne’ets quin c’uajiy talbel. ");
INSERT INTO husNT1971_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Tam nixe’ an Israelchic in ts’i’quiy ti conóx jun c’al xi jun: ―¿Ju’ta hualam ne’ets ca c’ale axe’ xi inic abal yab ne’ets qui ejtou qui ela’ ma ni ju’ta? Hualam ne’ets quin tsa’biy i at Israel ax u pil c’uajil xalulul c’al an griegochic. ");
INSERT INTO husNT1971_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Jant’o tam cau nixe’ abal in ulu ne’ets tiquin aliy ani yab ne’ets tiquin ela’ ma ni ju’ta? Ni jita’ yab ne’ets ca ulits jun ti ne’ets quin c’uajiycua’. ");
INSERT INTO husNT1971_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Im bajuhuits an taltalab q’uicha axi lej c’athpich in exbath c’al an ajib. Tam cubiy a Jesús in taunal lej tsapic axi c’uajatchic taja’. In ulu: ―Max hua’ats jita’ u chiquel c’al in ejattal ca chich c’al nana’, ani nana’ ne’ets cu pitha’ an ja’ quin uts’a’ tin cuenta in ejattal. ");
INSERT INTO husNT1971_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","In ulal an T’ocat Thuchlab abal jitats tiquim bela’ nana’, ne’ets ca cale athithil ejtil i elel ja’ tin ichich. Pel i ja’ axi c’al ti ne’ets ca it ejatlinchat in ejattal an inicchic. ");
INSERT INTO husNT1971_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Antsana’ a Jesús in t’ipchixnanchi an ja’ tin cuenta an Espíritu Santo axi ne’ets ca pithan jitats quim bela’ a Jesús. Tocat yabaye lej che’nequits an Espíritu Santo, cum yabaye huichenec a Jesús tihua’ ti eb ca puhuethanchat im bij. ");
INSERT INTO husNT1971_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Talchic i inicchic ax in ats’a’ jahua’ antsana’ in ulu a Jesús, in ulu: ―Lej chubax axe’ xi inic ja’its an caulome axi uxnal c’al an Israelchic ne’ets ca aban c’al a Dios ca oc’chith chich tam ti yabaye che’nequits a Cristo. ");
INSERT INTO husNT1971_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Q’ue’atchic axi taja’ c’uajat in ulu: ―Ja’its axe’ a Cristo axi bijithits ne’ets ca aban c’al a Dios ca chich. Ani hua’atse jita’chic in ulu: ―Iba yab ja, cum a Cristo yab tal ti Galilea. ");
INSERT INTO husNT1971_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","In ulal an T’ocat Thuchlab abal a Cristo ne’ets ca hua’tsin ti bichou Belén jun ti hua’tsin jaye am biyal ts’ale David. In ulal jaye abal a Cristo pel in at xits’al a David. ");
INSERT INTO husNT1971_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Antsana’ ti lehuáx an inicchic axi taja’ muthat, cum yab jununul in tsalpanchal in ey a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Aba ani’ talchic i inic taja’ in le’ quin yac’ua’ a Jesús, yab in t’aja’. ");
INSERT INTO husNT1971_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Huichits an yac’ualchic axi abnenec quin yac’ua’ a Jesús ani conoyatchic c’al an fariseochic ani c’al an ts’alechic c’al am pale’: ―¿Jale’ yab a chi’tha’ nixe’ xi inic? ");
INSERT INTO husNT1971_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Toc’tsin an yac’ualchic: ―Ni jayq’ui’ yab i ats’amal i inic quin ulu an cau axi ejtil jaja’ in ulal. ");
INSERT INTO husNT1971_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Tam uchanchic c’al an fariseochic: ―Tata’ ojni’chic hualam a hualca’its ta ba’ quit c’ambiyatte c’al jahua’ in ulal nixe’ xi inic. ");
INSERT INTO husNT1971_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Auxe’ max hua’ats c’al huahua’ tu Israel i oc’lec ani i fariseo ax im belamalits nixe’ xi inic. ");
INSERT INTO husNT1971_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","T’ajat q’uibenequits axe’ xi mulcunel axi ts’at’enec c’al jaja’, cum yab in exbayalchic an ts’ejcath cau jahua’ huahua’ tu Israel u pithnenec c’al a Moisés. ");
INSERT INTO husNT1971_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Taja’ c’uajat a Nicodemo an fariseo axi chich quin tauna’ a Jesús jun i acal. In ucha’ in at fariseochic: ");
INSERT INTO husNT1971_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―In ulal an ts’ejcath cau abal yab i ejtohual qui alq’uith jolbiy i inic. Oc’ox qui conomichiquiy abal qui alhua’ exla’ max in t’ajamalits jahua’ yab alhua’. ");
INSERT INTO husNT1971_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Toc’tsiyat a Nicodemo: ―¿Tata’ ojni’ hualam pel it Galileajibte? Ca exobna’ an T’ocat Thuchlab abal ca tso’obna’ abal taja’ ti Galilea ni jayq’ui’ yab u tal i inic axi pel i caulome c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Tam patal an inicchic axi tamcuth taja’ c’al a Jesús c’ale tin q’uima’chic. ");
INSERT INTO husNT1971_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ani a Jesús c’ale ti bolchal Olivo. ");
INSERT INTO husNT1971_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Aytalab q’uicha lej thajujul huichiy junil ti tiyopan. Utey c’al jaja’ patal an inicchic axi c’uajat taja’, ani buxcan a Jesús ti exobchix c’al in cahuintal a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Tam talchic axi pel i exobchixchic c’al an ts’ejcath cau junax c’al i fariseochic in chi’thal jun i uxum axi elchinence ti at cuaxnax c’al i inic axi yab pel in tomquil. In c’uajba’ an uxum ts’ejel jun ti exobchix a Jesús c’al an mulcunel. ");
INSERT INTO husNT1971_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Uchan a Jesús c’al jaja’chic ax in chi’tha’ an uxum: ―Exobchix, axe’ xi uxum elchinenec ti at cuaxnax c’al i inic axi yab pel in tomquil. ");
INSERT INTO husNT1971_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","An ts’ejcath cau ax tu jilchi a Moisés in ulal abal jita’ quin t’aja’ i hualabtalab ejtil in t’ajamal axe’ xi uxum, ca pithcachiquinchat c’al i t’ujub ma ta ca t’ajat tsemtha. ¿Ani tata’ jant’o a ulal ca t’ajchin axe’ xi uxum? ");
INSERT INTO husNT1971_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Antsana’ ti conoyat a Jesús abal u le’nab ca jolbiyat max quin ulu i cau axi yab juncuth c’al an ts’ejcath cau. Tam cutle a Jesús in ts’i’quiy jant’o quin thucha’ c’al in ch’uchub ti tsabal ba’ am pojoth. ");
INSERT INTO husNT1971_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Cum lej conomichiquiyabe c’al i cau, lujcun a Jesús. In ucha’chic: ―Max hua’ats jita’ c’al tata’chic yab hualbith, jats quim pithcanchi an oc’ox t’ujub axe’ xi uxum. ");
INSERT INTO husNT1971_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Tam cutle a Jesús junil quin thuchaye más jant’o ti tsabal ba’ am pojoth. ");
INSERT INTO husNT1971_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Tam in ts’i’quiy an inicchic ti calelel ti junchic, cum tin ats’a’ lej uchan antsana’ max hua’ats jita’ yab hualbith jats quim pithcanchi an uxum an oc’ox t’ujub. Patal in ats’a’ jolbith in ichich. Oc’ox ne’ets calelel an yejtselchic, ani taley tiq’uele ti tala’ calets axi patal jitaquitsq’ui. Jilc’on expith a Jesús ani nixe’ xi uxum. ");
INSERT INTO husNT1971_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Tam lujcun a Jesús, in tsu’u expith c’uajat an uxum. In ucha: ―¿Uxum, ju’ta ti c’uajat ax ti jolbiyalac? ¿Yab jilc’on ma ni jun abal ti lej jolbiy? ");
INSERT INTO husNT1971_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Tam in ulu an uxum: ―Iba ni jun yab jilc’on, pay’lom. Tam uchan c’al a Jesús: ―Nana’ne yab tu jolbiyal. Quit c’ale ani yabats quit hualbin. ");
INSERT INTO husNT1971_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Taley in taunaye junil a Jesús an inicchic, in ucha’: ―Nana’its ax u pithal an inicchic i tajaxtalab tin ichich. Jitats ca ts’at’ey c’al nana’ ne’ets ca xe’tsin al an tajax ani iba al an yic’uax. Ne’ets ca xe’tsin it ejatlith al an tajax. ");
INSERT INTO husNT1971_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Tam uchan a Jesús c’al talchic i fariseochic: ―Yab jant’o ti exbath an cau jahua’ a ulal, cum tocat a olnal ta ba’. ");
INSERT INTO husNT1971_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","A Jesús in toc’tsiychic: ―Aba ani’ u olnal tu ba’, bel exbath an cau ani lej chubax jahua’ u olnal. Nana’ u alhua’ tso’obits ma ju’tam in tal ani ma ju’tam in ne’ets, ani tata’chic yab a exlal. ");
INSERT INTO husNT1971_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Tata’chic ojni’ tin jolbiyal cum tin tsalpanchal u ey jant’inits tin tsu’talq’ui ejtil max pel i jahuaquitsq’ui tam inic. Nana’ teje’ tsabal yab u jolbiyal i inic. ");
INSERT INTO husNT1971_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Max u jolbiyalac lej chubax an ts’ejcaxtalab ne’ets cu pitha’ cum nan yab in ts’ejcom cuetem, in ts’ejcom junax c’al u Tata ti eb ax tin abamal quin chich teje’ tsabal ani ets’ey c’uajat c’al nana’. ");
INSERT INTO husNT1971_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","In ulal an ts’ejcath cau ax a cua’alchic abal lej chubax an olnomtalab max jununul in olnomtal tsab i olnom. ");
INSERT INTO husNT1971_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Nana’ u olnal tu ba’ ani tin olnanchal u ey u Tata ti eb ax tin aba’ quin chich teje’ tsabal. Tsab ti eb huahua’ tu olnom. ");
INSERT INTO husNT1971_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Tam conoyat a Jesús: ―¿Ju’ta ti c’uajat a Tata? A Jesús in toc’tsiychic: ―Tata’chic yab tin exlal, ani yab a exlal u Tata ti eb. Max tin exlalac nana’, a exlalac u Tata ti eb jaye. ");
INSERT INTO husNT1971_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ja’its axe’ xi cau ax in exobchal a Jesús ti al an tiyopan utat jun ti c’uajat am poc’te’chic jun tu bats’uhuab an c’ac’naxtalab tumin. Ni jita’ yab in yac’ua’ a Jesús, cum yabaye im baju an hora jant’ini’ ti pejchame c’al a Dios ca yac’uan. Jun ti nan in ne’ets tata’chic yab a ejtohual quit c’alechic in ulu a Jesús ");
INSERT INTO husNT1971_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Taley in taunaye junil a Jesús an inicchic: ―Nan in ne’ets, ani tata’chic ne’ets tiquin aliy. Yab ne’ets tiquin ela’, cum yab ne’ets ca ejtou quit ulits jun ti nan in ne’ets. Ne’ets quit tsemets, ani ne’ets quit jilc’on t’ajat q’uibenec c’al a hualab. ");
INSERT INTO husNT1971_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Tam in ulu talchic i Israelchic: ―Hualam max ne’ets quin cuete’ tsemtha’ tim ba’ ani jaxtam in ulu huahua’ yab i ejtohual cu ulits jun ti jaja’ ne’ets. ");
INSERT INTO husNT1971_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Tam a Jesús in ucha’chic: ―Tata’chic it hua’tsinenec tit eleb poq’uel teje’ tsabal, ani nana’ in tal ti eb. Jununul a tsalapchic c’al a at inic teje’ ti al an hualab c’ay’lal, ani nana’ u tsalap pil yab ejtil tata’chic. ");
INSERT INTO husNT1971_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Cum a t’ajtal ey it hualbith, jaxtam nan tu ucha’chic abal ne’ets quit tsemets ani quit jilc’on q’uibenec c’al a hualab. Max yab tim belchal abal lej chubax jant’ini’ nan tu olchits u ey, ne’ets quit tsemets ani quit jilc’on t’ajat q’uibenec c’al a hualab. ");
INSERT INTO husNT1971_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Tam conoyat a Jesús: ―¿Jita’ tata’? A Jesús in toc’tsiychic: ―Nana’its u ey ax tu uchamalits ma ti jayq’ui’ tam tu oc’ox tauna’. ");
INSERT INTO husNT1971_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Hua’atse yan i cau u ejtohualac tu uchayechic tin cuenta a ey. U ejtohualac tu jolbiy ani yab ne’ets cu t’aja’. Expith u lubal cu olchi an inicchic an cau jahua’ u ats’amal c’al jaja’ ax tin aba’ quin chich teje’ tsabal. Lej chubax an cau jahua’ jaja’ quin ulu. ");
INSERT INTO husNT1971_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ma ni c’al patal axe’ xi cau yab in ejtiyalchic abal a Jesús in olnal an Tatalab ax ti eb. ");
INSERT INTO husNT1971_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Tam a Jesús in ucha’chic: ―Nana’its tin Juntal patal an inicchic. Tam tata’chic tiquin co’oy q’uet’ath al am pelc’oth te’, tam tiq’uele ne’ets ca tso’obna’ abal lej chubax u ey jahua’ u ulumalits. Tamna’its ne’ets ca tso’obna’chic ta lej ichich abal jahua’ nan u ulal yab pel u cuete’ cahuintal, pel ax tim pithamal u Tata ti eb. ");
INSERT INTO husNT1971_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","U Tata ti eb ax tin aba’ quin chich teje’ tsabal ets’ey c’uajat c’al nana’. Yab tin jilcacayal, cum ets’ey u t’ajchal in culbetal. ");
INSERT INTO husNT1971_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ani c’al axe’ xi cau jahua’ uchan, yan i inicchic im bela’ a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Tam a Jesús in ucha’ an Israelchic axi c’al tu belnal jaja’: ―Max ca t’ayat bina’ a xutsun c’al an cau jahua’ nan u olnal, pel it lej chubax exobal c’al nana’. ");
INSERT INTO husNT1971_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ne’ets ca exla’ an chubaxtalab ani jats ne’ets ti hualca’. ");
INSERT INTO husNT1971_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Toc’tsiyat a Jesús: ―Huahua’ pel tu at xits’al a Abraham ani u hualcath. Ni jayq’ui’ yab jita’ tu huic’at co’oyamal. ¿Jale’ a ulal ne’ets cu hualca? ");
INSERT INTO husNT1971_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","A Jesús in ucha’: ―Lej chubax nan tu uchalchic abal patal jitats u hualbinal jats u huic’at co’oyab c’al an hualabtalab. ");
INSERT INTO husNT1971_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Pel in ey jaja’ yab hualcath ejtil i t’ojnal axi c’unat co’oyab c’al i amulab. Expith in tsacamil an amulab jats axi lej chubax hualcath. ");
INSERT INTO husNT1971_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Nana’its tin Tsacamil a Dios. Max nana’ tu hualcanthanchichic a ichich tin cuenta an hualabtalab, tam ne’ets ca ats’a’ abal it lej chubax hualcathits a ichich. Yabats ne’ets quit huic’at co’oyat c’al an hualabtalab. ");
INSERT INTO husNT1971_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","U tso’obits abal pel ti at xits’alchic a Abraham. Aba ani’ antsana’ a ey, bel a le’chic tiquin tsemtha’ cum yab u lejel ta ichich an cau jahua’ nan tu olchalchic. ");
INSERT INTO husNT1971_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Aba ani’ nan tu olnanchalchic jahua’ u tsu’umal c’al u Tata ti eb, bel a le’chic ca t’aja’ jahua’ it exobchith c’al a tata. ");
INSERT INTO husNT1971_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Toc’tsinchic tam: ―Huahua’ i biyal tata pel a Abraham. A Jesús in ucha’chic: ―Max chubax anac a Abraham pel a tata, a chubax aynanchalac an chubaxtalab jahua’ ti jilchamal. ");
INSERT INTO husNT1971_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Nan tu chubax olchalchic an chubaxtalab ax tin olchal a Dios, ani bel a le’ tiquin tsemtha’. Max c’uajatac teje’ a Abraham, jaja’ yab ne’ets tiquin t’ajchi antsana’. ");
INSERT INTO husNT1971_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Tata’chic a nits’binchal in t’ajbil a tata. Tam uchan a Jesús c’al jaja’chic: ―Huahua’ yab pel u peno’ tsacam. I cua’al juncats i tata axi pel a Dios ti eb. ");
INSERT INTO husNT1971_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Tam a Jesús in ucha’chic: ―Max chubaxac pel a Tata Dios ti eb tin c’anithalac nana’, cum ja’its tin aba’ quin chich teje’ tsabal c’al tata’chic. Yab in che’nec expith max nan u lej le’ quin chich tu cuete’ ba’. Ja’its a Dios ax tin abamal. ");
INSERT INTO husNT1971_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Jale’ yab a ejtohual ca exbay jahua’ u ulal? Jats cum yab a alhua’ binal a xutsun c’al an cau jahua’ nan tu uchalchic. ");
INSERT INTO husNT1971_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","An teneclab jats a tatachic ani an teneclab pel ti tsacamilchic. Jats jaja’ a lej culbetnal ca t’ojonchi. Ma tam ti c’a’al jaja’ pel i tsemthom inic. Ni jayq’ui’ yab in lejatnamal tin ichich an chubaxtalab ani ni jayq’ui’ yab in ulal an chubaxtalab. Pel i janamcau ani c’al jaja’ jats tu hua’tsinthab an janamtalab. ");
INSERT INTO husNT1971_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Nan tu uchalchic an chubaxtalab ani yab tim belchal. ");
INSERT INTO husNT1971_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Jita’ hualam axi c’al tata’chic in ejtohual tiquin jolbiy ani tiquin ucha’ abal yab chubax jahua’ u ulal ani yab chubax jahua’ u t’ajal? ¿Jale’ hualam yab tim belchal an chubaxtalab jahua’ tu uchalchic? ");
INSERT INTO husNT1971_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Jitats pel in c’al a Dios, jats in alhua’ binal in xutsun quin ats’anchi in cahuintal a Dios. Cum tata’chic yab pel ti c’al, jaxtam yab a le’ ca lej bina’ a xutsun ca ats’anchi xe’. ");
INSERT INTO husNT1971_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Tam uchan a Jesús c’al an Israelchic: ―Lej chubax jahua’ i ulumalits abal pel it Samariajib ani it co’oyab c’al i at’ax teneclab. ");
INSERT INTO husNT1971_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","A Jesús in toc’tsiychic: ―Iba yab in co’oyab c’al i at’ax teneclab. Expith u lubal cu c’ac’na’ u Tata ti eb, ani tata’chic yab tin c’ac’nal nana’. ");
INSERT INTO husNT1971_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Nan ni jant’o yab u t’ajal abal quim puhuethanchat u bij. U Tata ojni’ jats in le’ quim puhuethanchat u bij, ani jats quin ulu jayq’ui’. ");
INSERT INTO husNT1971_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Lej chubax nan tu uchalchic abal jitats quim putu c’al u cahuintal, jats axi ni jayq’ui’ yab ne’ets quin leca’ an lej tsemla. ");
INSERT INTO husNT1971_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Tam toc’tsin an Israelchic: ―Xohue’ ojni’ i tso’obits abal it co’oyab c’al i at’ax teneclab. Tsemetsits a Abraham ani patal am biyal caulomechic c’al a Dios, ani tata’ a ulal max jita’ quim putu c’al a cahuintal jats yab ne’ets quin leca’ an lej tsemla. ");
INSERT INTO husNT1971_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Auxe’ max it más lej pulic ani i biyal tata Abraham iba. Tsemetsits jaja’ ani patal am biyal caulomechic c’al a Dios. ¿Jita’ hualam pel a ey a t’ajal? ");
INSERT INTO husNT1971_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","A Jesús in toc’tsiychic: ―Ni jant’o yab ti exbath max nan u puhuethalac tu ba’. Ja’its a Dios ax tim puhuethanchal u bij, ani ja’its a Dios ax a ulal a c’ac’nalchic. ");
INSERT INTO husNT1971_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Yab chubax a exlalchic a Dios, nana’ ja’its ax u lej exlal a Dios. Max u ulalac abal yab u exlal a Dios, ne’etsne tin janamcau jant’ini’ tata’chic it janamcau. Lej chubax u exlal a Dios ani u putuhual c’al jahua’ in ulal. ");
INSERT INTO husNT1971_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","A biyal tata Abraham lej culbe tam tin exla’ abal nan ne’ets quin chich teje’ tsabal. Xohue’ in tso’obits abal in che’nequits, ani jats ti jum putat culbel jaja’. ");
INSERT INTO husNT1971_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Tam uchan a Jesús c’al nixe’ xi Israelchic: ―Auxe’ max a tsu’umal a Abraham, ani yabaye a cua’al tsab inic i tamub. ");
INSERT INTO husNT1971_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","A Jesús in toc’tsiychic: ―Lej chubax nan tu uchalchic abal in ejatits tam ti yabaye hua’tsinenec a Abraham. ");
INSERT INTO husNT1971_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Tam im pena’chic i t’ujub abal quin cui’iy a Jesús. Ani jaja’ cale tsininil jun ti muthat an inicchic ti al an tiyopan, ta c’alets. ");
INSERT INTO husNT1971_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ne’ets belal a Jesús in tsu’u jun i inic axi joc’tsi ma tin hua’tsintal. ");
INSERT INTO husNT1971_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ani huahua’ tu exobalil i conoy a Jesús: ―¿Exobchix, hualam exbath jale’ ti hua’tsin joc’tsi axe’ xi inic? Hualam tin ebal jaja’ in hualab, ani max i hualam tin ebal in hualab in tata ani in mim. ");
INSERT INTO husNT1971_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","A Jesús tu ucha’chic: ―Yab pel i joc’tsi tin ebal in cuete’ hualab ni tin ebal in hualab in tata ani in mim. Pel i joc’tsi expith abal ca tsu’uxmetha c’al in tsap a Dios, ani antsana’ ca tejhua’me abal a Dios in lej cua’al in tsap. ");
INSERT INTO husNT1971_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Biyat q’uichaye u cua’al u uchbil cu t’ojonchi in t’ojlabil a Dios ax tin aba’ quin chich teje’ tsabal. Hue’its ne’ets ca acle, ani yabats ne’ets cu ejtou cu t’ojonchiye tam. ");
INSERT INTO husNT1971_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Biyat nan quin xe’tsin teje’ tsabal, u pithal an inicchic i tajaxtalab tin ichich. ");
INSERT INTO husNT1971_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Tam tin uluhuits antsana’ axe’ xi cau, tamna’ a Jesús tubal tsabal. In ts’ejca’ i lucuc tsipili’ c’al in ijil, ani in mauchi tin hual an joc’tsi. ");
INSERT INTO husNT1971_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Tam a Jesús in ucha’: ―Quit c’ale ca t’aca’ a hual ti al an ts’acbath ja’ Siloé. An cau Siloé in le’ quin ulu abath ti tenec. Ani c’ale an joc’tsi in t’aca’ in hual. Tam ti huichits u tsu’uxits. ");
INSERT INTO husNT1971_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Tam in at q’uimathchic c’al ti tsu’ume joc’tsijac in uluchic: ―Hualam axe’ ja’its ax i exlamal ti joc’tsijac tam tu conol c’al an limoxna. ");
INSERT INTO husNT1971_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Talchic jaja’chic in ulu: ―Ja’its xe’. Q’ue’atchic in ulu: ―Yab ja, tocat ejtilits. Tam axi joc’tsijac in ulu: ―Nana’ ojni’ ja’its ax a t’iloxnalchic. ");
INSERT INTO husNT1971_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Tam conoyat jaja’: ―¿Jant’ini’ tit t’ajchinenec abal it tsu’uxits? ");
INSERT INTO husNT1971_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Jaja’ in toc’tsiychic: ―Jun i inic uxnal ti Jesús in ts’ejca’ i lucuc ani tin mauchi tu hual. Taley tin ucha’ quin c’ale cu t’aca’ u hual ti al an ts’acbath ja’ Siloé. In c’ale ani u t’aca’ u hual taja’, ani xo’ in tsu’uxits. ");
INSERT INTO husNT1971_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Tam conoyat: ―¿Ju’ta ti c’uajat nixe’ xi inic a olnalac? Toc’tsin jaja’: ―Yab u tso’ob. ");
INSERT INTO husNT1971_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Tam ne’tha axi joc’tsijac jun ti c’uajat talchic i fariseochic. ");
INSERT INTO husNT1971_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Pelac i sábado tam ti a Jesús in ts’ejca’ i lucuc ani in tsu’uxmetha’ an joc’tsi. ");
INSERT INTO husNT1971_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Conoyat junil axi joc’tsijac jant’ini’ ti t’ajchinenec abal tsu’uxits. Ani toc’tsin: ―In mauchin i lucuc tu hual ani u t’aca’ u hual, ani xo’ in tsu’uxits. ");
INSERT INTO husNT1971_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Tam talchic nixe’ xi fariseochic in ulu: ―I tso’obits abal axe’ xi inic ax in tsu’uxmetha’ an joc’tsi yab c’al a Dios ti abnenec, cum yab in c’ac’nal an q’uicha sábado. Ani q’ue’atchic i fariseo al nixe’ xi cuenel in ulu: ―Auxe’ max i hualbith inic in ejtohualac quin t’aja’ i labith t’ajbilab ejtil in t’ajal axe’ xi inic ax in tsu’uxmetha’ an joc’tsi. Tam lehuáx an fariseochic, cum yab jununul in tsalpanchal in ey a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Tam conoyat junil c’al an fariseochic axi joc’tsijac: ―¿Ani tata’ jant’ini’ ta tsalpanchal in ey ax ti tsu’uxemtha’ c’al a hual? Toc’tsin jaja’: ―Nan u tsalpanchal in ey pel i caulome abnenec c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Cum an Israelchic yab in le’ quim bela’ max chubax pelac i joc’tsi ani max tsu’uxmethamejits, jaxtam in abchi an cau ca chich in tata ani in mim. ");
INSERT INTO husNT1971_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Chich jaja’chic ani conoyat: ―¿Ja’its axe’ a tsacamil? Tucu ucha’ max joc’tsi ti hua’tsinenec. ¿Max chubax joc’tsijac jant’ini’ ti t’ajchinenec abal xo’ tsu’uxits? ");
INSERT INTO husNT1971_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Toc’tsinchic in tata ani in mim: ―I tso’ob abal ja’its axe’ huahua’ i lej tsacamil ani joc’tsi ti hua’tsinenec. ");
INSERT INTO husNT1971_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Tin cuenta abal xo’ tsu’uxits yab i tso’ob jant’ini’. Yab i tso’ob c’al jita’ ti tsu’uxmetha. Cum pelits i inic pulic, jaja’ ca conoy. Jaja’ in ejtohual ti toc’tsiychic jant’ini’ ti tsu’uxmetha. ");
INSERT INTO husNT1971_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Antsana’ ti toc’tsin in tata ani in mim axi joc’tsijac, cum in ts’ejnal an Israelchic ax in ulumalits ca quethmayat eleb ca c’ale tin tiyopanil max jita’ quin olna’ abal a Jesús ja’its a Cristo axi bijithits ne’ets ca aban c’al a Dios ca chich. ");
INSERT INTO husNT1971_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Jaxtam in tata ani in mim axi joc’tsijac in ucha’ an oc’lec Israelchic ca conchinchat axi joc’tsijac cum pelits i inic pulic. ");
INSERT INTO husNT1971_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Taley tam an oc’lecchic in abchi an cau ca chich junil axi joc’tsijac. Chich junil ani uchan: Ca lej t’aja’ ti cuenta tucu ucha’ an chubaxtalab, cum a Dios ti tsu’tal ani ti ats’al. I lej tso’obits abal pel i hualbith inic ax ti tsu’uxmetha’. ");
INSERT INTO husNT1971_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Tam jaja’ in toc’tsiychic: ―Yab u tso’ob max pel i hualbith inic o max pel i alhua’ inic. Tocat u tso’obits abal in joc’tsijac ani xo’ in tsu’uxits. ");
INSERT INTO husNT1971_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Conoyate junil: ―¿Jant’ini’ ti t’ajchi abal ti tsu’uxmetha’? ");
INSERT INTO husNT1971_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Jaja’ in toc’tsiychic: ―Nan tu uchamalitschic an chubaxtalab ani yab a t’ajamal ti cuenta. Hualam max a le’chicte quit ts’at’ey c’al jaja’, jaxtam a le’ abal nan tu tsab ucha’ junil jant’ini’ jaja’ tin t’ajchi. ");
INSERT INTO husNT1971_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ma tamna’its lej tsapic c’uiyan c’al nixe’ xi fariseochic. Uchan: ―Tata’ it ts’at’atits c’al jaja’ ani huahua’ iba, cum u ts’at’atits c’al an cau ax tu jilchamal a Moisés. ");
INSERT INTO husNT1971_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","I tso’obits abal t’ilmats a Dios c’al a Moisés, ani axe’ xi inic ni jant’o yab i tso’obnanchamal tin cuenta a Dios. Ma yab i tso’ob ju’ta ti tal. ");
INSERT INTO husNT1971_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Tam axi joc’tsijac in toc’tsiychic: ―Auxe’ max cu bela’ yab a tso’obchic. ¿Tin tsu’uxmethamal ani ma yab a tso’ob ju’ta ti tal jaja’? ");
INSERT INTO husNT1971_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","I lej alhua’ tso’obits abal a Dios yab u ats’ax c’al i hualbith inic. Axi c’ac’nax c’al a Dios ani in t’ajchal in culbetal a Dios jats axi ne’ets ca ats’an c’al jaja’. ");
INSERT INTO husNT1971_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ni jayq’ui’ yab jita’ xe’tsinenec teje’ tsabal ti tsu’uxmethom c’al axi joc’tsi ma tin hua’tsintal. ");
INSERT INTO husNT1971_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Yab in ejtohualac axe’ xi inic ti tsu’uxmethom max yabac pithnenec in tsap c’al a Dios ani max yabac abnenec c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Tam uchan axi joc’tsijac: ―Tata’ ojni’ a lej t’ajtal ey tit hua’tsinenec tit huat’ath hualbith inic ani ma a le’ tucu exobchi huahua’. Taley tamna’ quethmayat eleb ca c’ale. ");
INSERT INTO husNT1971_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","In tso’obna’ a Jesús abal quethmayatits eleb al an tiyopan axi joc’tsijac. Talbel in tamu ani in ucha’: ―¿A belal in Tsacamil a Dios? ");
INSERT INTO husNT1971_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Toc’tsiyat a Jesús: ―Pay’lom, tiquin ucha’ jita’ pel in Tsacamil a Dios abal cu bela’. ");
INSERT INTO husNT1971_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Toc’tsin a Jesús: ―Xo’ a tsu’umalits in Tsacamil a Dios. Ja’its nana’ ax tu taunal. ");
INSERT INTO husNT1971_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Tam axi joc’tsijac in tuthu in c’ualal tin tamet a Jesús ani in ucha’: ―Ajatic, nan u belal abal tata’its ti Tsacamil a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Tam uchan c’al a Jesús: ―Cum in che’nec teje’ tsabal patal an inicchic in cua’al in uchbil tiquim bela’. Axi ejtil i joc’tsi ani tiquim bela’ nana’, jats ax u tsu’uxmethal abal ca tsu’xin c’al jahua’ in t’ajal a Dios. Axi yab tiquim bela’ u jilal ca más joc’tsibe, cum in tsalpayal abal lej tsu’ux c’al jahua’ in t’ajal a Dios ani yab chubax. ");
INSERT INTO husNT1971_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Tam c’al nixe’ xi cau talchic nixe’ xi fariseo in conoy a Jesús: ―¿U joc’tsi huahua’? ");
INSERT INTO husNT1971_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","A Jesús in toc’tsiychic: ―Max tata’chic tim belamalac nan yabac tu t’ajat jolbiyamal tin cuenta a hualab aba ani’ pel ejtil it joc’tsi. It jolbithits cum yab tim belal ani a ulal abal it tsu’ux c’al jahua’ in t’ajal a Dios ani yab chubax. ");
INSERT INTO husNT1971_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Lej chubax nan tu uchalchic abal an cue’ u c’athil tim ba’te’lil in tenmal an ovejachic abal ca otsits, ani yab tin lej hui’lebil. ");
INSERT INTO husNT1971_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Am beletnom ovejachic jats ojni’ u otsel tin hui’lebil in tenmal an ovejachic. ");
INSERT INTO husNT1971_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Tats tu otsel tam ca japchin c’al am beletnom hui’leb tam ne’ets quin caltha’ ti ac’ul an ovejachic. Cum exlanchab in cahuintal am beletnom oveja, tocat quim bijiy tim bijchic tam u calelel an ovejachic. ");
INSERT INTO husNT1971_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Tam calnequits tim patalchic, tam ne’éts oc’chith am beletnom oveja ani tal cuxlab an ovejachic. U aynab am beletnom c’al an ovejachic cum exlanchab in cahuintal. ");
INSERT INTO husNT1971_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","An ovejachic yab ne’ets quin ayna’ i pil inic, cum yab in exlanchal in cahuintal, tocat ne’ets ca c’ale ti athil max quin ats’anchi in cahuintal. ");
INSERT INTO husNT1971_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ax in ats’a’chic antsana’ axe’ xi jalpith cau yab in exbay jant’o in le’ quin ulu a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Taley tam a Jesús in uchaye i cau axi c’uajatchic c’al jaja’: ―Nana’its in ejtil i hui’leb jun tu otsel an ovejachic. ");
INSERT INTO husNT1971_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Patal axi che’nequits ani yab tequeth olnomats c’al in cahuintal a Dios, jats ejtil nixe’ ax in le’ ti cue’ c’al an ovejachic. Axi chubax u belom c’al u cahuintal yab u belom c’al nixe’ axi ejtil i cue’chic. ");
INSERT INTO husNT1971_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Cum nana’its in ejtil i hui’leb jun tu otsel an ovejachic tin tenmal, jitats ca otsits nan ne’ets cu jec’ontha’ c’al patal jahuaquits quin tamu. Ne’ets cu alhua’ beletnanchi in ejattal ejtil i oveja ax u othab tam acal tin tenmal ani ca chutheyits u calthab abal ti ac’ul. ");
INSERT INTO husNT1971_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Axi yab tequeth olnom c’al in cahuintal a Dios, jats axi ejtil i cue’ ax u che’el abal quin cue’ey ani quin tsemtha’ an ovejachic. Nan yab u ey antsana’. Nan in che’nec teje’ tsabal abal tu pitha’chic i it ejattalab abal quit jum putat canat c’uajiy c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Nana’its in alhua’ beletnom c’al u belomilchic. Ne’ets cu bina’ tu ba’ quin tsemtha ti al an cruz abal tata’chic quit jec’ontha. Jitats lej chubax c’anithom c’al in ovejajilchic, ma ts’ejcachic in ichich ca tsemets abal ca jec’onthachic. ");
INSERT INTO husNT1971_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Yab lej alhua’ jec’onthax axi expith ti atlomq’ui ti beletnom oveja. Tam ca chich am pathum quin yac’ua’ an oveja, tam jaja’ u pit’c’onal. In jilal ca yac’uan an ovejachic c’al am pathum ani axi más in jilal ca tala’ buq’uey. ");
INSERT INTO husNT1971_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Antsana’ tu pit’c’onal axi atlomq’ui, cum yab in c’anithal an ovejachic, expith an tumin in le’. ");
INSERT INTO husNT1971_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Nana’its in alhua’ beletnom c’al u belomilchic cum pel ejtil i oveja. U exláx nana’ ani u belomilchic ejtil nana’ ani u Tata ti eb u exláx. Ne’ets cu bina’ tu ba’ quin tsemtha abal ca jec’onthachic. ");
INSERT INTO husNT1971_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Nan ne’ets tu jec’ontha’ tata’chic ax it belom c’al nana’ ani jaye ne’ets cu jec’onthaye axi pil xe’etschic yab c’al tata’chic. Jaja’chic jaye ne’ets quin t’aja’ jahua’ nan cu ucha’. Ne’ets cu tamcuy c’al tata’ ta yaneltalchic, ani ne’ets cu ts’ejca’ juncats i cuenel. Ani nan ne’ets quin jilc’on tin juncats beletnom c’al ta yaneltalchic. ");
INSERT INTO husNT1971_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Cum nan ne’ets cu bina’ tu ba’ quin tsemtha, jaxtam u Tata ti eb tin lej c’anithal. Ne’ets quin tsemtha ani ne’ets quin ejatlin junil. ");
INSERT INTO husNT1971_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","C’al u cuete’ culbetal ne’ets cu bina’ tu ba’ quin tsemtha, cum ni jita’ tam inic yab in ejtohual tiquin tsemtha’ max nan yab cu le’na’. Pel u uchbil ax im pithnenec c’al u Tata ti eb cu bina’ tu ba’ ani quin ejatlin junil. ");
INSERT INTO husNT1971_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Tam lehuáx talchic i Israelchic tin ebal c’al axe’ xi cau jahua’ in ulu a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Yan jaja’chic in ulu: ―Yab qui t’ajchi ti cuenta in cahuintal axe’ xi inic, cum u co’oyab c’al i at’ax teneclab ani u olmanalits. ");
INSERT INTO husNT1971_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ani q’ue’at jaja’chic in ulu: ―Max chubaxac u co’oyab c’al i at’ax teneclab yab ne’ets quin ejtou quin ulu abal in cua’al in uchbil c’al a Dios. Ani jaye jun i inic ax u co’oyab c’al i at’ax teneclab yab ne’ets quin ejtou quin tsu’uxmetha’ i joc’tsichic. ");
INSERT INTO husNT1971_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Im bajuhuits an tsamay q’uij, ani u t’ajnalits an ajib ti Jerusalén tam tu it binab an tiyopan ca c’ac’naxnaye c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Xe’ets a Jesús ti al an tiyopan al i c’uajattalab im bij hueu cucu’ ata Salomón. ");
INSERT INTO husNT1971_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ani tamcunits toninil taja’ i Israelchic c’al a Jesús, ani uchan jaja’: ―¿Jayq’ui’ ne’ets tucu lejquith olchi a lej ey abal yabats cu xe’tsin cononol i ichich c’al jant’o a ey? Tucu t’ajat lejquith olchi max tata’its it Cristo ax it bijithits ne’ets quit aban c’al a Dios quit chich. ");
INSERT INTO husNT1971_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","A Jesús in toc’tsiychic: ―Nan tu uchamalits abal nana’its ani yab tim belchamal. Nan tu tejhua’methanchi u lej ey c’al an t’ajbilab jahua’ u t’ajamalits tim bij u Tata ti eb. ");
INSERT INTO husNT1971_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Tocat yab a le’chic tiquim belchi, cum yab ja tata’chic axi nana’ tu c’al an ovejachic. Antsana’ tu uchamalitschic abal yab pel tu c’al. ");
INSERT INTO husNT1971_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","An inicchic axi chubax pel u ovejajil jats ax tin exlanchal u cahuintal ani tin aynal. ");
INSERT INTO husNT1971_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Cum u pithalchic i it ejattalab abal ca ets’ey c’uajiy c’al a Dios, jaxtam ni jayq’ui’ yab ne’ets ca q’uibeychic. Cum u t’ayat co’oyalchic tu c’ubac ni jita’ tam inic in ejtohualac tiquin tixc’anchi. ");
INSERT INTO husNT1971_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Pel jaja’chic ax im pithnenec u Tata ti eb cu c’alna’. Cum u co’oyabitschic tihua’ tin c’ubac u Tata ti eb jaye, ni jita’ tam inic yab in ejtohualac quin tixc’anchi tin c’ubac jaja’. U Tata ti eb in lej cua’al in ets’ey tsap yab ejtil an inic. ");
INSERT INTO husNT1971_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nana’ ani c’al u Tata ti eb jununul i ey. ");
INSERT INTO husNT1971_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Tam junil talchic i Israelchic im pena’ i t’ujub abal quin cui’iy a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","A Jesús in ucha’chic tam: ―Yan i alhua’ t’ajbilab u t’ajamalits ta tsu’ux hualchic, cum antsana’ tim pitha’ u uchbil u Tata ti eb cu t’aja’. ¿C’al jant’o c’al tin ebal ta le’chic tiquin cui’iy c’al i t’ujub? ");
INSERT INTO husNT1971_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Toc’tsin an Israelchic: ―Yab ne’ets tu cui’iy c’al tin ebal i t’ajbilab jahua’ a t’ajamal, tocat abal pel i pulic hualabtalab c’al a Dios a t’ajamal cum a ulu pel it Dios ani expith a ey pel it inic. ");
INSERT INTO husNT1971_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Tam a Jesús in ucha’chic: ―Thuchathits ti al an ts’ejcath cau ax it jilchin c’al a Moisés, abal a Dios in ulu tin cuenta an inic pelits i dioschic. ");
INSERT INTO husNT1971_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","I tso’obits abal an T’ocat Thuchlab pel i lej chubaxtalab ani ni jita’ tam inic yab in ejtohual quim pacuchi. Ca t’aja’ ti cuenta abal a Dios ti jayq’ui’ im bijiy ti dioschic ax im pithamal in cahuintal jaja’. ");
INSERT INTO husNT1971_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ja’its a Dios ax tin tacuy ani tin aba’ quin chich teje’ tsabal. ¿Jale’ tam a ulu abal u t’aja’ i pulic hualabtalab c’al a Dios tam tu ulu nana’its pel tin Tsacamil a Dios? ");
INSERT INTO husNT1971_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Yab tiquim bela’ max yab cu t’ajchi i labith t’ajbilab u Tata ti eb ax tim pitha’ u uchbil cu t’aja’. ");
INSERT INTO husNT1971_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Aba ani’ tata’chic yab a le’ tiquim bela’ c’al tin ebal u cahuintal, bel tiquim bela’ c’al tin ebal an labith t’ajbilab jahua’ u t’ajamalits ta tsu’ux hual. Max chubax tiquim bela’ ne’ets ca alhua’ exla’ abal nana’ ani c’al u Tata ti eb ts’ot’c’óx i ichich. ");
INSERT INTO husNT1971_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ani junil le’nab ca yac’uan a Jesús ca ne’tha, tocat tixc’an ta c’alets. ");
INSERT INTO husNT1971_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Tam huichiy a Jesús jum poq’ue’ am pulic itse’ Jordán juntalab ti calel q’uicha. Tats ti jilc’on al an c’uajattalab jun ti xe’tsin a Juan ti jayq’ui’ ti pujal. ");
INSERT INTO husNT1971_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ani chich yantalam i inicchic quin tsu’u a Jesús. In uluchic: ―A Juan abal i yab in t’aja’ ni jun i labith t’ajbilab ti tsu’bixtalab abal quin tejhua’metha’ max chubax abnenec c’al a Dios, bel pel i lej chubaxtalab patal jahua’ in olnanchi in ey axe’ xa Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ani c’al yantalam i inic axi taja’chic tu belnal a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","C’uajat jun i ya’ul ti bichou Betania im bij Lázaro. Pel in ebchal a María ani a Marta. ");
INSERT INTO husNT1971_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Pel jaja’ a María ax ti jayq’ui’ in jolchi i nihuihuiltalab tin acan a Jesús ani in huayethanchi c’al in xi’il. Pel in ebchal Lázaro axi ya’ul. ");
INSERT INTO husNT1971_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Abchinal an cau a Jesús c’al a María ani a Marta ca uchan an cau antse’: ―Ajatic, ca lej t’aja’ ti cuenta abal te a ja’ub Lázaro u ya’ul. ");
INSERT INTO husNT1971_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Tam ti olchinits antsana’ an cau a Jesús, in ulu: ―Aba ani’ ya’ul yab ne’ets ca t’ayat tsemets. C’al jahua’ cu t’ajchi a Lázaro ne’ets tu tejhua’methanchi in tsap a Dios ani nana’ u tsap tin Tsacamil a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","A Jesús in lej ichich hual tsu’tal a Marta ani a María ani a Lázaro. ");
INSERT INTO husNT1971_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Aba ani’ olchinenequits abal ya’ul a Lázaro, bel jilc’one taja’ tsab a q’uicha jun ti c’uajat. ");
INSERT INTO husNT1971_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Taley talbel a Jesús tu ucha’ huahua’ tu exobalilchic: ―Huana cu c’ale junil ti Judea. ");
INSERT INTO husNT1971_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","I toc’tsiy: ―¿Exobchix, jale’ ta le’ quit huichiy tihua’ junil, ani tats tit le’name quit tsemtha c’al i t’ujub c’al talchic i Israelchic? ");
INSERT INTO husNT1971_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","A Jesús tu ucha’chic: ―Biyat yabaye u talchamal in t’ojlabil a Dios ax tin abamal, yabaye ne’ets quin tsemtha. Hua’ats jat’hua’ lajuj tsab i hora tam tajaxe ta q’uicha ca xe’tsin an inic yab ca t’ithc’uan. ");
INSERT INTO husNT1971_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Expith tam acal tam ti yic’uaxits hualam ne’ets ca t’ithc’uan, cum yab hua’ats i tajax. ");
INSERT INTO husNT1971_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Talbel a Jesús tu uchaye: ―U huayitsits i ja’ub Lázaro. Ne’ets quin c’ale cu ejtsintha’. ");
INSERT INTO husNT1971_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Tam huahua’ i uchal a Jesús: ―Ajatic, alhua’ abal max huayitsits, cum ne’ets hualam elabmelits an yau’lats. ");
INSERT INTO husNT1971_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Tam tin ulu a Jesús abal huayitsits a Lázaro, in le’ quin ulu abal tsemetsits. Huahua’ i tsalpanchalq’ui abal coyomathq’ui ti huayal. ");
INSERT INTO husNT1971_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Tam a Jesús tu lejquith ucha’chic: ―Tsemetsits a Lázaro. ");
INSERT INTO husNT1971_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Alhua’ abal in jilc’onenec teje’ ani yabaye in c’alnec c’al a Lázaro, cum talbel tata’chic más ne’ets tiquin lej bela’. Huanats qui tsu’u xohue’. ");
INSERT INTO husNT1971_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tam cau a Tomás axi uxnal ti cuaya’cua’. Tu ucha’ huahua’ tu at exobalchic: ―Cu c’alehue c’al a Jesús ani cu junax tsemtha c’al jaja’. ");
INSERT INTO husNT1971_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ulits a Jesús jun ti jolith a Lázaro, olchin abal tse’its a q’uicha ti joliyame. ");
INSERT INTO husNT1971_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Am bichou Betania c’uajat utat ti bichou Jerusalén jelat max tsab c’al ts’ejel i kilómetro. ");
INSERT INTO husNT1971_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Tats ti ultsits yan i Israelchic quin ts’abiy a Marta ani a María quin culbethanchi in ichich, cum in tso’obits abal tsemetsits in ebchal Lázaro. ");
INSERT INTO husNT1971_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Cum olchinal a Marta abal ta tal a Jesús, c’ale abal quin tamu. A Maria jats jilc’on tin q’uima’. ");
INSERT INTO husNT1971_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ulits a Marta, in ucha’ a Jesús: ―Ajatic, max it c’uajatac yabac tsemenec u ebchal Lázaro. ");
INSERT INTO husNT1971_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Aba ani’ tsemenequits, u tso’obits abal ne’ets ca ejtha c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Toc’tsin a Jesús: ―Ne’ets ca ejtha ani ca xe’tsine ejat junil a ebchal. ");
INSERT INTO husNT1971_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Uchan a Jesús tam: ―U tso’obits abal ne’ets ca ejtha tam quim baju an taltalab q’uicha tam a Dios ne’ets quin tala’ ejtha’ an tsemelomchic. ");
INSERT INTO husNT1971_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Toc’tsin a Jesús: ―Nana’its in ejthax c’al an tsemelomchic ani im pithoblix c’al i it ejattalab. Aba ani’ max ca tsemets jitats tiquim bela’ nana’, bel ne’ets cu ejtha’ junil talbel. ");
INSERT INTO husNT1971_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ne’ets ca c’uajiy it ejatlith abal ets’ey yab quin leca’ an lej tsemla jitats belom c’al nana’. ¿A belal axe’ xi cau? ");
INSERT INTO husNT1971_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Tam toc’tsin a Marta: ―U lej belal Ajatic abal pel ti Tsacamil a Dios. Pel it Cristo ax it bijithits ne’ets quit aban c’al a Dios quit chich. ");
INSERT INTO husNT1971_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Talits ti t’ilom a Marta c’al a Jesús, huichits c’al a María quin caniy ca chich c’al a Jesús quin tsu’u. In cue’ ucha’: ―An Exobchix Jesús tax talits utat in le’ abal quit c’ale ca tsu’u. ");
INSERT INTO husNT1971_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Tam ti olchinits an cau a María, tam ta c’ale thubat quin tsu’u a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yabaye ulnec a Jesús ti bichou Betania, c’uajate tihua’ jun ti tamuhuat c’al a Marta. ");
INSERT INTO husNT1971_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","An Israelchic axi c’uajat abal quin culbethanchi in ichich a María in tsu’u abal thubat c’alets. Ani c’alechic jaja’ jaye, cum in tsalpayal abal a María ne’ets quin tsa’biy an jolimtalab ani ca uq’uin taja’. ");
INSERT INTO husNT1971_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ultsits a María taja’ jun ti c’uajat a Jesús, in tuthu in c’ualal tin tamet ani in ucha’: ―Ajatic, max it c’uajatac yabac tsemenec u ebchal Lázaro. ");
INSERT INTO husNT1971_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Tam tin tsu’u a Jesús uc’nal a María ani an Israelchic axi c’uajat taja’, in ats’a’ tim ba’ lej t’elelel in ichich ani lej ej’el. ");
INSERT INTO husNT1971_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Tam in conoychic: ―¿Ju’ta ta joliyamal a Lázaro? Uchan a Jesús: ―Quit utey Ajatic abal ca tsu’u. ");
INSERT INTO husNT1971_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Tam uc’nal a Jesús jaye. ");
INSERT INTO husNT1971_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Tam in ulu an Israelchic axi taja’chic: ―Ca t’aja’ ti cuenta abal lej ichich hual tsu’tom c’al a Lázaro. ");
INSERT INTO husNT1971_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Talchic jaja’chic in ulu: ―Ja’its axe’ xi inic ax in tsu’uxmetha’ an joc’tsi, ani hualam max pelac in culbetal in ejtohuamalac quin jeltha’ a Lázaro ani yab ca tsemets. ");
INSERT INTO husNT1971_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Junil in ats’a’ a Jesús lej ej’el tin ichich. Tam utey jun ti jolith a Lázaro al i jol paxal t’ujub axi paxq’uithits c’al i pulic t’ujub. ");
INSERT INTO husNT1971_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","A Jesús in ucha’chic: ―Ca tixc’a’chic an t’ujub taja’. Uchan c’al a Marta in uxum ebchal an tsemelom: ―Ajatic, cum tse’its a q’uicha ti tsemenec hualam pet’el caxiyits. ");
INSERT INTO husNT1971_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Uchan a Marta c’al a Jesús: ―Ca t’ila’ jahua’ nan tu ucha’its, max a belal nan ne’ets tu tejhua’methanchi in tsap a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Tam in tixc’a’chic an t’ujub. Tam a Jesús in met’a’ hualq’ui’ ti eb ani in ulu: ―U binal i c’ac’namal yan Tata ti eb, cum tin ats’anchamal u conchixtal. ");
INSERT INTO husNT1971_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Aba ani’ u tso’obits abal ets’ey tin ats’anchal jahuaquitsq’ui tu conchi, bel tu mo’canchal u conchixtal abal antsana’ axi teje’ muthatchic quin lej bela’ abal tata’ tin aba’ quin chich teje’ tsabal. ");
INSERT INTO husNT1971_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Tam tin uluhuits antsana’, tam lej thajan a Jesús: ―Lázaro, quit cale tana’. ");
INSERT INTO husNT1971_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ani cale a Lázaro malithe c’al i malilil toltom ani c’al jun i toltom thu’bathe tin oc’. A Jesús in ucha’chic axi taja’ c’uajat: ―Ca huilchi an malilil toltom abal ca hualcanits. ");
INSERT INTO husNT1971_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","C’al axe’ xi pulic tsu’bixtalab in t’aja’ a Jesús, jats ti belan c’al yan i Israelchic axi che’nequits c’al a María jun ti joliyame a Lázaro. In tsu’uchic ani im bela’chic. ");
INSERT INTO husNT1971_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ani talchic jaja’chic c’ale quin olchi an fariseochic jahua’ a Jesús in t’ajchamal a Lázaro. ");
INSERT INTO husNT1971_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Tam nixe’ an fariseochic ani c’al axi pel i ts’alechic pale’ c’ale quin tauna’ an cuenel axi c’athpich exbath ti ts’ejcom c’al an cau tin cuenta an tiyopan. In ucha’chic: ―¿Jant’o ne’ets qui t’aja’, cum axe’ xi inic xe’ets in t’ajal yan i labith t’ajbilab? ");
INSERT INTO husNT1971_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Lejat patal an inicchic ne’ets ca belomats max qui jila’ antsana’ ca xe’tsine. Hualam max ca chich an romanochic tucu tsemtha’ ani tucu t’ajat talabethanchi i tiyopanil. ");
INSERT INTO husNT1971_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Tam jun axi taja’ c’al jaja’chic im bij a Caifás ani pel i ts’ale pale’ nixe’ xi tamub, in ucha’chic: ―Tata’chic ojni’ yab it tsalpath. ");
INSERT INTO husNT1971_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ca t’aja’ ti cuenta abal alhua’ ca tsemtha juncats i inic, ani yab cu talabetha huahua’ tu bichou. ");
INSERT INTO husNT1971_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Caifás yab in elentha’ nixe’ xi cau tin cuete’ oc’. Antsana’ ti cahuintha c’al a Dios, abal a Jesús ne’ets ca tsemtha ti calchix c’al am bichou Israel. Cum pel i ts’ale pale’ a Caifás nixe’ xi tamub, antsana’ in ucha’ in at juntalchic. ");
INSERT INTO husNT1971_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ani yab expith ca tsemtha a Jesús abal ca jec’ontha am bichou Israel, jaye abal ca jec’ontha ani ca mulcuhuat patal in tsacamilchic a Dios axi buc’uc’ul xe’ets tim puhuel an tsabal. ");
INSERT INTO husNT1971_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ma tam nixe’ xa q’uichajits an oc’lecchic c’al an Israel in luba’ quin ts’ejca’ an cau jant’ini’ ti quin tsemtha’ a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Jaxtam a Jesús yabats lej tejhua’ xe’ets jun ti ca tsu’tat c’al an Israelchic. Cale ti Judea ani c’ale ti jun i bichou im bij Efraín axi utat i joltam. Tats ti jilc’on a Jesús ani jaye huahua’ tu exobalil. ");
INSERT INTO husNT1971_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Cum yabats más ohuat a q’uicha ne’ets quim baju an Israelchic quin t’aja’ an ajib tin cuenta abal ti calthame ti Egipto im biyal juntalchic, tamcunenequits yan i inicchic ti Jerusalén quin oc’ox t’oquetha’ tim ba’ jant’ini’ ti uchbith c’al an ts’ejcath cau axi jilchin c’al a Moisés. ");
INSERT INTO husNT1971_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Talchic jaja’chic xe’ets alilil max quin ela’ a Jesús. Talchic axi al an tiyopan xe’ets in conoyalchic: ―¿Jant’o a tsalpayal hualam ne’ets ca chich a Jesús c’al an ajib? ");
INSERT INTO husNT1971_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","An fariseochic ani an ts’ale pale’chic in abchamalits’ an cau am bichou abal ca tso’oblinchat max ca tsu’tat ju’ta a Jesús, cum ne’ets ca abchin jita’ ta ca yac’uan. ");
INSERT INTO husNT1971_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","In q’uibchale acac a q’uicha tam an Israelchic quin t’aja’ an ajib tin cuenta abal ti calthame im biyal juntalchic ti Egipto. Chich a Jesús ti Betania tin q’uima’ a Lázaro axi tsemenecac ani xo’ ejthachits. ");
INSERT INTO husNT1971_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ani ts’ejcanchab i c’apnel ca c’aputs. Quetel a Jesús ba’ an mexa junax c’al a Lázaro, ani pijchiyabchic c’al a Marta. ");
INSERT INTO husNT1971_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Tam a María in chi’tha’ ts’ejel i litro i nihuihuiltalab nardo lej chubax ani lej jalbith. In jolchi tin acan a Jesús, ani taley in huayethanchi c’al in xi’il. Ani lej nihuihuilbe tim puhuel an ata. ");
INSERT INTO husNT1971_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Tam cau a Judas Iscariote axi ne’ets talbel quin tsinat bina’ a Jesús tin c’ubac in tomolnaxilchic. Ja’its pel in tsacamil a Simón. In ulu: ");
INSERT INTO husNT1971_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","―In tomnalac max nujuhuamejac nixe’ xi nihuihuiltalab ti ox i bo’ inicchic i tumin denario ani pithnenecac an tumin an ts’ejhuantalchic. ");
INSERT INTO husNT1971_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Antsana’ in ulu yab abal in yajnanchal an ts’ejhuantalchic, tocat abal in le’ ca balchinchat an tumin ti al an morral ax in xe’tsinthal jun tu baliyab in tuminal in exobalilchic a Jesús. Cum a Judas pel i cue’ tin lej ichich, in ujnam ti cue’ c’al an tumin taja’ al an morral. ");
INSERT INTO husNT1971_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Tam uchan c’al a Jesús: ―Yab a cuenta jahua’ tin t’ajchamal a María. Aba ani’ yabaye in tsemenec, bel tin jolchi an nihuihuiltalab ejtil max tin q’uejab t’ojojonchalits u inictal tam ne’ets quin joliyat. ");
INSERT INTO husNT1971_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ets’ey ne’ets ca c’uajiy an ts’ejhuantalchic c’al tata’chic ani nana’ expith jun i hue’ in c’uajat. ");
INSERT INTO husNT1971_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Cum olchinenequits i Israelchic abal c’uajat a Jesús tihua’ ti Bitania, jaxtam c’alechic yantalam tihua’. Chich jaja’chic abal quin tsu’u a Jesús ani jaye a Lázaro axi ejtha c’al a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","An ts’alechic c’al am pale’chic in junax ts’ejca’ an cau abal jant’ini’ ti quin tsemtha’ a Lázaro jaye. ");
INSERT INTO husNT1971_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Cum yan i Israelchic im bela’ a Jesús tam tin tsu’u ejthachits a Lázaro, ani yabats ts’at’ey c’al in at Israelchic. ");
INSERT INTO husNT1971_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ulnequits yantalam i inicchic ti Jerusalén quin t’aja’ an ajib tin cuenta abal ti calthame an Israelchic ti biyal ti Egipto, ani an aytalab q’uicha tso’obliyab abal ne’ets ca ulits a Jesús taja’. ");
INSERT INTO husNT1971_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Tam an ajibalchic in cotoyal in xequel i apats’ abal quin xe’tsintha’ huihuohuol tam ca ulits a Jesús. Tam c’alechic quim bats’u a Jesús. Ne’ets thajajal in ulalchic: ―Qui puhuethanchi im bij a Dios. Qui ajatnanchi im bij axi te talits abath c’al a Dios. Qui ajatnanchi im bij i Ts’alejil huahua’ tu Israel. ");
INSERT INTO husNT1971_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Tal a Jesús punat al i burro. Antsana’ putun jahua’ thuchath ti al an T’ocat Thuchlab antse’: ");
INSERT INTO husNT1971_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Yab quit jiq’uey bichou Sion c’al axe’ a Ts’alejil. Ca tsu’u ta tal punat al i burro. ");
INSERT INTO husNT1971_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Huahua’ tu exobalil a Jesús yab i thubat ejtiy abal u olnab antsana’ a Jesús ti al an T’ocat Thuchlab. Ma tam ti huichits a Jesús ti eb puhuethanchithits im bij, tam tiq’uelejits i alhua’ exbaychic abal ja’its jaja’ ax u olnab c’al nixe’ xi thuchath cau. ");
INSERT INTO husNT1971_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Talchic axi c’uajat al an mulcunel ajibal jats axi c’uajatac tam ti ejtha a Lázaro c’al a Jesús, ani jats jaja’chic ax in olnanchal axi q’ue’at an ajibalchic jahua’ t’ajchinenec a Lázaro c’al a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Cum antsana’ ti olchinenecchic an lej labith t’ajbilab ax in t’ajamal a Jesús, jaxtam ti lej xe’ets in lej aliyalchic a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Tam in ulu an fariseochic jun c’al xi jun: ―Ca t’aja’chic ti cuenta abal ni jant’o yab i ejtohual qui t’aja’ abal an inicchic yab ca ts’at’ey c’al axe’ xi inic. Jat’hua’ tim patal an inicchic u ts’at’el c’al jaja’. ");
INSERT INTO husNT1971_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Talchic i inicchic axi che’nequits ti Jerusalén tin cuenta an ajib pel i griegochic. ");
INSERT INTO husNT1971_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Utey jaja’chic c’al a Felipe axi tal ti Betsaida cuentalith ti Galilea. Lej canat uchan a Felipe: ―Pay’lom, i lej le’ qui tsu’u a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Tam c’ale a Felipe quin olchi a Andrés jant’o uchan, ani axi tsabchic c’ale quin olchi a Jesús abal le’nab ca tsu’tat. ");
INSERT INTO husNT1971_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ani a Jesús in ucha’chic: ―Hue’its ne’ets quim baju am pejchith hora ne’ets quim puhuethanchat u bij c’al a Dios. Nana’its pel tin Juntal patal an inicchic. ");
INSERT INTO husNT1971_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Lej chubax nan tu uchalchic abal expith max ca t’ayan an iyalab ani ca elchiyat c’al i anam, expith tamna’ ne’ets ca cale ani ca puhuey ani quim bina’ yan i hualilab. Max yab ca t’ayan, u jilc’onale lej cuetemits. ");
INSERT INTO husNT1971_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Jitats quin t’aja’ expith in cuete’ culbetal, jats ne’ets ca q’uibey. Jitats quim pojca’ in cuete’ culbetal ani tiquin t’ajchi u culbetal, jats ne’ets ca jec’ontha ani ca ets’ey c’uajiy c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Patal jitats in le’ tiquin t’ojonchi pel in uchbil tiquin junini’ ts’at’enchi ju’tamits nan quin c’ale. Jats axi ne’ets ca puhuethanchat in ey c’al u Tata ti eb. ");
INSERT INTO husNT1971_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Cum hue’its ne’ets quim baju an hora tam quin yajchiquiyat, c’athpich yajchic u ichich. Hualam max cu ucha’ u Tata ti eb tiquin jaluntha’ ani yab quin yajchiquiyat. Iba tiquin jaluntha’ xe’, cum ja’its tin che’nequits abal quin yajchiquiyat. ");
INSERT INTO husNT1971_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","U lej le’ Tata ti eb abal expith tata’ quit puhuethanchat a bij c’al jahua’ cu yajchicna’. Tamna’ tal jun i cau ma ti eb antse’: ―U puhuethamalits u bij, ani ne’ets cu puhuethaye junil. ");
INSERT INTO husNT1971_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Talchic i inicchic taja’ in ats’a’ nix an cau ani in ulu abal u petnal an mamlab. Q’ue’atchic in ulu: ―Pel in cahuintal i ángel. ");
INSERT INTO husNT1971_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Tam a Jesús in ucha’chic: ―A Dios ti abchi tata’chic axe’ xi cau abal ca tso’obna’ jant’o in t’ajal, ani yab tin abchi nana’. ");
INSERT INTO husNT1971_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Hue’its ani ne’ets ca tejhua’me in lej pojcaxtal an inicchic. Hue’its ani ne’ets cu ata’ an oc’ox teneclab abal yabats quin t’aja’ ti abatnom c’al an inicchic. ");
INSERT INTO husNT1971_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Cum nan ne’ets quin q’uet’an al i te’, jaxtam ne’ets cu quinchi in ichich tim patal an inicchic ca chich c’al nana’. ");
INSERT INTO husNT1971_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Antsana’ in olna’ a Jesús jant’ini’ ne’ets ta ca tsemtha. ");
INSERT INTO husNT1971_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Toc’tsiyat a Jesús c’al an inicchic axi taja’chic: ―Huahua’ u olchinenequits jahua’ thuchath ti al an ts’ejcath cau axi jilchin a Moisés abal in ey a Cristo ets’ey ejat, ni jayq’ui’ yab u tsemel. Ja’its axi bijithits ne’ets ca aban c’al a Dios ca chich. Hualam yab it Cristo, jaxtam a uluhuits abal in Juntal patal an inicchic in yejenchal ca q’uet’an al i te’. Tucu lejquith olchi jita’ nixe’ in Juntal patal an inicchic ax a ulu. ");
INSERT INTO husNT1971_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Tam a Jesús in ucha’chic: ―Nana’its ax u pithal an inicchic i tajaxtalab tin ichich. Quit ts’at’ey c’al nana’ biyat in c’uajate hue’ teje’ tsabal, ani ne’ets quit xe’tsin al an tajax. Yab ne’ets ca ts’ejna’ an yic’uax. Yab ne’ets quit xe’tsin q’uibenec ejtil an inic axi q’uibets al an yic’uax yab in exlal ju’ta ti ne’ets. ");
INSERT INTO husNT1971_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Max tiquim bela’ abal nana’ chubax tu pithal i tajaxtalab ta ichich, tam ne’ets ca ujna’ quit xe’tsin al an tajax. Tiquim bela’ biyat hua’atse an q’uij. Tam tin ulumalits a Jesús patal axe’ xi cau, tam c’alets ani tsinat xe’etse hue’. ");
INSERT INTO husNT1971_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Aba ani’ in t’ajamalits a Jesús yan i labith t’ajbilabchic ti tsu’bixtalab tin tsu’ux hual an Israelchic, ni abal jay yab im bela’chic. ");
INSERT INTO husNT1971_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Antsana’ ti putun jant’ini’ ti thuchathits jaja’chic axi yab belom c’al an caulome Isaías antse’: Hualam max hua’ats jita’ im belchamalits an cau jahua’ huahua’ i olnanchamalits ta cuenta tata’ Ajatic. Hualam max hua’ats jita’ ti t’ajchal ti cuenta abal tejhua’methanchatits a tsap Ajatic. ");
INSERT INTO husNT1971_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Yab in ejtou nixe’ xi Israelchic quim belchi in cahuintal a Jesús. T’ajchinenec c’al a Dios jant’ini’ ti jayq’ui’ t’ajchinenecchic am biyal inicchic thuchathits antse’ c’al a Isaías: ");
INSERT INTO husNT1971_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","A Dios in jila’chic ca joc’tsime c’al in hual ani ca t’ujbathme in ichichchic. Jaxtam yab in ejtouchic ti tsu’ux c’al jahua’ in t’ajal a Dios. Cum yabats huichiy jayq’ui’ c’al a Dios yab jec’onthachic. ");
INSERT INTO husNT1971_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ja’its xe’ an cau ax in olnamalits a Isaías tin cuenta a Jesús tam tin tsu’umalits c’uajatits ti eb lej c’athpich pulic in ey. In q’uejab olna’ abal yab ne’ets ca lej belchin in cahuintal a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Aba ani’ yab ne’ets ca belchin c’al patal an Israelchic, bel yantalam axi taja’ c’uajatchic c’al a Jesús im bela’. Talchic jaja’chic ax im belal pel i lej oc’lecchic c’al an Israelchic. Tocat yab in le’chic quin olna’ max im belalits a Jesús, cum in exlalits abal ne’ets ca caltha ti al an tiyopan max quin olna’. In lej ts’ejnalchic an fariseochic max ca caltha tin elebtal an tiyopan ani ca quethmayat ca c’ale. ");
INSERT INTO husNT1971_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Yab in olnal max im belalchic a Jesús, cum más in le’chic ca uchan ti alhua’ c’al an inicchic ani lej hue’ c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Tam a Jesús in lej tsapic ulu: ―Max tata’chic tiquim bela’ nana’, tamna’ a mac’uchith belal jaye u Tata ti eb, cum ja’its jaja’ ax tin aba’ quin chich teje’ tsabal. ");
INSERT INTO husNT1971_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Max tata’chic tin tsu’tal nana’, tamna’ a mac’uchith tsu’tal jaye u Tata ax tin aba’ teje’. ");
INSERT INTO husNT1971_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","In chich teje’ tsabal abal cu pitha’ an inicchic i tajaxtalab tin ichich. Jitats tiquim bela’ yabats ne’ets ca xe’tsin al an yic’uax. ");
INSERT INTO husNT1971_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Aba ani’ yab in chich abal cu jolbiy an inicchic teje’ tsabal, bel ne’ets ca jolbiyat c’al a Dios jitats tiquin ats’anchi u cahuintal ani tiquim pojcanchi talbel. ");
INSERT INTO husNT1971_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Lej chubax hua’ats jant’o c’al ta ca jolbiyat jitats tiquim pojca’ nana’ ani tiquim pojcanchi u cahuintal. An cauchic jahua’ nan tu olchamalitschic ja’its axi nixe’ ti jolbix tam quim baju an taltalab q’uicha tam ca t’ajchin an inicchic an ts’ejcaxtalab. ");
INSERT INTO husNT1971_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","An cauchic jahua’ nan tu olchamalits yab u elenthamal tu cuete’ oc’, expith nan tu olchamal ani tu exobchamal an cau jahua’ tim pithamal u Tata abal nan tu olchichic. Ja’its u Tata ti eb ax tin aba’ abal nan tu olchichic in cahuintal jaja’. ");
INSERT INTO husNT1971_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Patal an cau jahua’ nan cu olna’ jats ax tim pithal u Tata ti eb. U lej tso’obits abal c’al in cahuintal jaja’ jats c’al tu it ejatliyab abal ets’ey an inicchic. ");
INSERT INTO husNT1971_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","In q’uibchale jun a q’uicha tam an Israelchic ne’ets quin t’aja’ an ajib tin cuenta abal ti calthame ti Egipto im biyal juntalchic. In tso’obits a Jesús abal hue’its ne’ets quim baju an hora ca huichits c’al in Tata ti eb. Aba ani’ ets’ey c’anithom a Jesús c’al im belomchic, xohue’ ne’ets quin t’ajchiyechic i tsu’bixtalab c’al ca tsu’tat abal lejatits ti lej c’athpith c’anithom c’al jaja’chic. ");
INSERT INTO husNT1971_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","4","Balchinenequits a Judas Iscariote i tsalap tin ichich c’al an oc’ox teneclab abal quin tsinat bina’ a Jesús tin c’ubac in tomolnaxilchic. Ja’its nixe’ xa Judas axi pel in tsacamil a Simón. In lej alhua’ tso’obits tin ichich a Jesús abal jaja’ abnenequits c’al a Dios ca chich teje’ tsabal ani ne’ets ca huichiy junil ti eb c’al a Dios. Jaye in lej alhua’ tso’obits abal tala’ pithnenequits tin c’ubac c’al in Tata ti eb patal jahua’ hua’ats ti eb ani ti tsabal. Huahua’ tu exobal ani junax c’al a Jesús u quetel tu c’apulits, ani tam cuble a Jesús in tixc’a’ in nacat coton. Taley im pena’ jun i toltom huayethomtalab ani in huic’a’ tin huic’. ");
INSERT INTO husNT1971_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Tam in jolou i ja’ al jun i lac, ani tu t’acchal i acan huahua’ tu exobalilchic. Tu huayethanchal c’al an toltom ax in cua’al huic’at tin huic’. ");
INSERT INTO husNT1971_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Tam ti ne’ets quin t’acchi in acan a Simón Pedro, uchan c’al a Pedro: ―Auxe’ max a tomnalac tata’ Ajatic tiquin t’acchi u acan. ");
INSERT INTO husNT1971_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Toc’tsin a Jesús: ―Xohue’ ojni’ yab a lej ejtiyal jale’ ne’ets tu t’ajchi antsana’, ma talbelaquits tam ojni’ ne’ets ca lej alhua’ ejtiy. ");
INSERT INTO husNT1971_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Uchan a Jesús c’al a Pedro: ―Ni jayq’ui’ tata’ yab ne’ets tiquin t’acchi nana’ u acan. A Jesús in ucha’ tam: ―Max yab tu t’acchi a acan, yabats ne’ets ca ejtou quit ts’at’ey c’al nana’. ");
INSERT INTO husNT1971_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","A Simón Pedro toc’tsin: ―Max chubax anits Ajatic, tam tiquin t’acchi ma u c’ubac ani u oc’ jaye, ani yab expith u acan. ");
INSERT INTO husNT1971_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","A Jesús in ucha’: ―Axi achimathits yabats in yejenchal ca t’acchin tim puhuel in inictal. Max pojothlith in acan jats expith ca t’acchin hue’. Tata’chic it t’acchithits, expith hua’ats jun jita’ axi yab chubax t’acchithits. ");
INSERT INTO husNT1971_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Antsana’ in ulu a Jesús abal hua’ats jun jita’ axi yab t’acchithits, cum in exlalits jita’ c’al ti ne’ets ca tsinat bina tin c’ubac in tomolnaxilchic. ");
INSERT INTO husNT1971_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Tam ti talits tucu t’acchi a Jesús i acan, tam in ca’iy junil in nacat coton. Huichiy ca coyots ti al an mexa, ani tu ucha: ―¿A ejtiyalchic an t’acaxtalab abal antsana’ xohue’ tu t’acchichic a acan? ");
INSERT INTO husNT1971_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Alhua’ abal tata’chic tim bijiyal tin Exobchix ani tin Ajatic, cum nana’ ja’its. ");
INSERT INTO husNT1971_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Cum nan antsana’ tu t’acchamalchic a acan, pel a uchbilchic quit t’acchíxin c’al a acanchic jun c’al xi jun. ");
INSERT INTO husNT1971_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Antsana’ nan tu jilchal i t’iplab abal tiquin nits’binchi. ");
INSERT INTO husNT1971_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Chubax nan tu uchalchic abal lej hue’ in exbath an t’ojnal, ani lej pulic in exbath an amulab. Lej hue’ in exbath an abathuale, ani lej pulic in exbath an abatnom. ");
INSERT INTO husNT1971_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Max a lej alhua’ ejtiyal an cau jahua’ tu uchalchic ani ca t’aja’ jaye, tam ojni’ ne’ets quit culbe. ");
INSERT INTO husNT1971_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Lej chubax ne’ets ca putun jahua’ thuchath ti al an T’ocat Thuchlab tin cuenta jaja’ axi ne’ets tiquin tomolna’. Jun axi junax c’apul c’al nana’, jats axi ne’ets tiquin tomolna’cua’. Yab u ulal abal patal tata’chic ne’ets tiquin tomolna’, iba. U tso’obits jita’chic u tacuyamalits abal tiquin chubax bela’. ");
INSERT INTO husNT1971_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Nan tu q’uejab uchalchic axe’ xi cau tin cuenta u tomolnaxil, abal tata’chic tiquin lej t’ayat bela’ ta ichich abal chubax nana’its pel in Cristo axi bijithits ne’ets ca aban c’al a Dios ca chich. ");
INSERT INTO husNT1971_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Lej chubax nan tu uchalchic abal jitats tiquim belchi u abathualejil ani max quim bats’u, nana’ tim mac’uchith bats’uhualne. Ani jitats tiquim bats’u nana’, im mac’uchith bats’uhual jaye u Tata ti eb ax tin aba’ quin chich teje’ tsabal. ");
INSERT INTO husNT1971_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Tam tin uluhuits a Jesús axe’ xi cau antsana’, tam in ats’al t’elelel tin ichich. Tu uchalchic huahua’: ―Lej chubax nan tu uchalchic abal jun axi c’al tata’chic ne’ets tiquin tsinat bina’ tin c’ubac u tomolnaxilchic. ");
INSERT INTO husNT1971_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Tam tu met’áx huahua’ tu exobalilchic a Jesús, cum yab i exlal jita’ nixe’ ax u olnab ne’ets ti tsinat binom c’al a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","In c’uajat taja’ nana’ in Juan tin lej ichich hual exobalil a Jesús. In quetel tin tsoylim a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Tin t’ajchi i t’iplab a Simón Pedro abal cu conoy a Jesús jita’ c’al huahua’ axi ne’ets ti tsinat binom c’al jaja’. ");
INSERT INTO husNT1971_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Tam in cutle tin hual a Jesús, ani u conoy antse’: ―¿Jita’ hualam axi c’al huahua’ a ulal ne’ets ti tsinat bina’ antsana’, Ajatic? ");
INSERT INTO husNT1971_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Toc’tsin a Jesús: ―Ne’ets cu tsabay pejach i pan, ani jita’ cu pitha’ jats axi ne’ets tiquin tsinat bina’. In tsabay, ani im pitha’ a Judas Iscariote axi pel in tsacamil a Simón. ");
INSERT INTO husNT1971_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Tam ti a Judas im bats’uhuits am pan, thubat otscan a Satanás tin ichich. Tam uchan c’al a Jesús: ―Ca thubat t’aja’ jahua’ a tsalpayamalits ta ichich ne’ets ca t’aja’. ");
INSERT INTO husNT1971_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ni junchic huahua’ ax u quetel ti c’apul al an mexa yab i tso’bim jale’ ti uchan a Judas antsana’ c’al a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Talchic in tsalpayal antsana’ ti uchan cum in xe’tsinthal an morral jun tu baliyab i tuminal, ani hualam uchan quin ts’ay’chi jant’o tin cuenta an ajib axi hue’its ne’ets quin t’aja’ an Israelchic. Hualam uchan quin ts’ejhualiy an ts’ejhuantalchic c’al jant’o. ");
INSERT INTO husNT1971_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Tam ti a Judas in c’apumalits am pan axi pithnenec, ta c’ale. Aclejits tam ti c’ale. ");
INSERT INTO husNT1971_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Tam ti c’alnequits a Judas, tam a Jesús in ulu: ―Nana’ tin Juntal patal an inicchic hue’its ne’ets quim puhuethanchat u bij, ani ne’ets ca mac’uchith puhuethanchat im bij a Dios c’al jahua’ nan ne’ets cu yajchicna’. ");
INSERT INTO husNT1971_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Cum nana’ tin Juntal patal an inicchic ne’ets cu t’aja’ abal ca puhuethanchat im bij a Dios c’al an inicchic, jaxtam a Dios ne’ets quin t’aja’ abal quim puhuethanchatne u bij. Ani thubat a Dios ne’ets tiquin tejhua’methanchi u lej ey c’al an inicchic. ");
INSERT INTO husNT1971_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Tsacamilchic, yabats ne’ets quin ohuat c’uajiy c’al tata’chic. Tam quin c’alets, jolat ne’ets ca le’na’ tiquin aliy ani yab ne’ets tiquin ela’, cum yab a ejtohual xohue’ quit ulitschic jun ti nana’ in ne’ets. Antsana’ u ucha’chic an Israelchic jaye axi yab belom c’al nana’. ");
INSERT INTO husNT1971_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Tocat u le’ tu jilchi i it uchbixtalab antse’: Quit c’anitháxin jun c’al xi jun. Jant’ini’ nan tu c’anithalchic, antsana’ pel a uchbilchic quit c’anithomats c’al am belomchic. ");
INSERT INTO husNT1971_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Max chubax quit c’anitháxin, tam patal an inicchic ne’ets quin tso’obna’ abal tata’chic pel tu lej exobalil. ");
INSERT INTO husNT1971_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Tam a Simón Pedro in conoy a Jesús: ―¿Ju’ta it ne’ets cum a ulu yabats ne’ets quit ohuat c’uajiy, Ajatic? Toc’tsin a Jesús: ―Yab a ejtohual tiquin ayna’ jun tin ne’ets xohue’, ma talbelaquits tam ojni’ ne’ets ca ejtou. ");
INSERT INTO husNT1971_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Tam a Pedro in ucha’: ―¿Jale’ yab ne’ets cu ejtou tu ayna’, Ajatic? In ts’ejcacathits cu jum putat bina’ tu ba’ quin tsemtha c’al tin ebal a bij. ");
INSERT INTO husNT1971_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Toc’tsin a Jesús: ―Hualam max lej chubax it ts’ejcacathits ca jum putat bina’ ta ba’ quit tsemtha c’al tin ebal u bij. Lej chubax nan tu uchal abal ma ibaque thajnenec an coxol, tata’ ne’ets ca tsinca’ ta ba’ c’al nana’ oxil i calat. ");
INSERT INTO husNT1971_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yab quit t’e’pinchic abal nan tu ucha’ yabats ne’ets quin ohuat c’uajiy c’al tata’chic. Ca belaye a Dios ani tiquim belayene. ");
INSERT INTO husNT1971_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Tihua’ ti eb tin t’ocat c’uajattal u Tata hua’ats yan i ata jun ti ne’ets quit c’uajiychic. Max yabac chubax antsana’ yab ne’ets tu ucha’ alq’uith. Nan ne’ets quin c’ale tihua’ abal tu t’ojojonchichic i ata. ");
INSERT INTO husNT1971_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Tam cu tala’ t’ojojoyits an atachic tihua’ ti eb, tam ne’ets quin huichiy junil tu ne’tha’chic abal quit junax c’uajiy tihua’ c’al nana’. ");
INSERT INTO husNT1971_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","A tso’bimits tata’chic ju’ta ti ne’ets quin c’ale, ani a tso’bim jaye am bel ju’ta ti nan in ne’ets. ");
INSERT INTO husNT1971_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Uchan a Jesús c’al a Tomás: ―¿Cum yab i tso’ob Ajatic ju’ta ti ne’ets quit c’ale, jant’ini’ tam huahua’ i ejtohual qui tso’obna’ am bel? ");
INSERT INTO husNT1971_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Toc’tsin a Jesús: ―Nana’its am bel ani jant’ini’ i ca tso’obna’. Expith max tiquim belnanchi u ey ne’ets quit ulits c’al u Tata ti eb. Nana’its ax tu uchalchic an chubaxtalab, ani nana’its ax tu it ejatliyalchic. ");
INSERT INTO husNT1971_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Max tata’chic chubax tin exlalac nana’, a lej exlalaquits jaye u Tata. Xohue’ tin tsu’talits nana’, ani jats ta exlalac u Tata ti eb. ");
INSERT INTO husNT1971_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Tam uchan a Jesús c’al a Felipe: ―Tucu tejhua’methanchi a Tata ti eb ani lejatits. ");
INSERT INTO husNT1971_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Toc’tsin a Jesús: ―Tata’ ojni’ Felipe, yabaye tin exlanchal u lej ey ani ohuatits in xe’ets c’al tata’chic. Jitats tin tsu’chal u hual, in tsu’chal jaye in hual u Tata ti eb. Yab in tomnal tiquin uchaye nan tu tejhua’methanchiye u Tata ti eb. ");
INSERT INTO husNT1971_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Jale’ yab a belal abal nana’ ani c’al u Tata ti eb u ts’ot’c’óx i ichich? An cau jahua’ nan tu uchalchic yab u elenthal tu cuete’ oc’ ani an labith t’ajbilabchic jahua’ u t’ajal yab tu cuetemtal u t’ajal. U Tata ti eb axi c’uajat tu ichich nana’ jats c’al tu junax t’ojnal qui t’aja’ i t’ajbilabchic. ");
INSERT INTO husNT1971_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Tiquim belchi abal chubax nana’ ani c’al u Tata ti eb u ts’ot’c’óx i ichich. Ani max yab a le’ tiquim belchi u ey tin ebal u cahuintal, tiquim belchi tin ebal an labith t’ajbilabchic jahua’ u t’ajal. ");
INSERT INTO husNT1971_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Pel i labith t’ajbilabchic ax u t’ajal, ani jitats tiquim bela’ ne’ets quin t’aja’ jaye i labith t’ajbilab jant’ini’ nan u t’ajamal. Ma ne’ets quin t’aja’ i más c’athpich labith t’ajbilabchic. Antsana’ lej chubax ne’ets quin t’aja’, cum nan in ne’ets c’al u Tata ti eb. ");
INSERT INTO husNT1971_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Nana’ ne’ets tu pitha’chic patal jahuaquits ca conchi u Tata ti eb c’al nana’ u bij. Antsana’ nan tin Tsacamil a Dios ne’ets tu pitha’ abal ca puhuethanchat im bij u Tata ti eb. ");
INSERT INTO husNT1971_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Jahuaquitsq’ui tam conchixtalab ca mo’ca’ tin c’ubac u Tata ti eb c’al nan u bij, nana’ ne’ets tu pitha’. ");
INSERT INTO husNT1971_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Max tata’chic tin chubax c’anithal, ca lej luba’ ca putu c’al jahua’ nan tu punubchalits ca t’aja’. ");
INSERT INTO husNT1971_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Nan ne’ets tu conchinchi c’al u Tata ti eb abal ti abchi an Espíritu Santo ca ets’ey c’uajiy c’al tata’chic. Jats jaja’ ne’ets ti tolminchi ani ti culbethanchi a ichich, cum nan yabats ne’ets quin c’uajiy c’al tata’chic. Ja’its jaja’ an Espíritu Santo axi ne’ets ti exobchiye an chubaxtalab. ");
INSERT INTO husNT1971_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Yab in ejtohual quim bats’u an Espíritu Santo axi yab belom, cum yabaye tsalpath in ichich c’al in tsalap a Dios ani yabaye exlom c’al an Espíritu Santo. Ojni’ c’uajatits jaja’ c’al tata’chic, ani ne’ets ca ets’ey c’uajiy ta ichich. ");
INSERT INTO husNT1971_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Nan yab ne’ets tu jila’chic tit oth inic. Ne’ets quin huichiy quin c’uajiy c’al tata’chic. ");
INSERT INTO husNT1971_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Hue’its ani yabats ne’ets tiquin tsu’u axi yab belomchic. Tata’chic ax it belom ne’ets tiquin tsu’uye tam in ejthachits junil. Ma tamna’its nan ne’ets tu lej co’onchi ejatlilith a ichich. ");
INSERT INTO husNT1971_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Tam quim baju an q’uicha nan quin ejtha, tamna’its ne’ets ca alhua’ tso’obna’ abal ts’ot’c’óx u ichich c’al u Tata ti eb. Ani ne’ets ca alhua’ tso’obna’ jaye abal nana’ ani c’al tata’chic ts’ot’c’óx i ichich. ");
INSERT INTO husNT1971_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Max a tso’obnalitschic u uchbixtalchic ani ca putu c’al jahua’ nan tu uchamalits, a tejhua’methalits abal chubax tin c’anithal. Jitats chubax c’anithom c’al nana’, jats axi ne’ets ca lej c’anitha c’al u Tata ti eb ani jaye c’al nana’. Ja’its jaja’ axi ne’ets tiquin lej alhua’ exla’, cum ne’ets cu tejhua’metha’ u ey c’al jitats tin c’anithal. ");
INSERT INTO husNT1971_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Tam uchan a Jesús i cau c’al a Judas. Yab ja a Judas Iscariote. Uchan: ―¿Jale’ ne’ets ca tejhua’metha’ a ey c’al huahua’ Ajatic, ani yab c’al axi yab belomchic? ");
INSERT INTO husNT1971_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Toc’tsin a Jesús: ―Jitats tin chubax c’anithal, jats ne’ets quin lej putu c’al u cahuintal ani jats ne’ets ca lej c’anitha c’al u Tata ti eb. Nana’ ani c’al u Tata ti eb ne’ets cu lej junax c’uajiy tin ichich jaja’. ");
INSERT INTO husNT1971_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Jitats yab tin c’anithal, jats axi yab ne’ets quim putu c’al u cahuintal. Pel i cau ax tim pitha’ u Tata ti eb ax tin aba’, ani yab pel u cuete’ cahuintal ax u elenthal tu cuete’ oc’. ");
INSERT INTO husNT1971_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Patal axe’ xi cau u lej le’ tu olchichic biyat hue’ in c’uajate teje’ tsabal c’al tata’chic. ");
INSERT INTO husNT1971_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","U Tata ti eb ne’ets ti abchi c’al nana’ u bij an Espíritu Santo abal ti tolminchi ani abal ti culbethanchichic a ichich. Ne’ets jaja’ ti t’ilanthanchi ta ichich patal an cau jahua’ nan tu uchamalits xohue’, ani ne’ets ti exobchiye an chubaxtalab jahua’ a q’uibchale ca tso’obna’. ");
INSERT INTO husNT1971_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Xohue’ ne’ets quin c’ale, ani u le’ tu jilchi i jun ejettalab ta ichich. Pel i jun ejettalab jant’ini’ nan u cua’al tu ichich. Pel xe’ axi yab ne’ets ca elcanchi teje’ al an hualab c’ay’lal. Yab quit t’e’pinchic ani yab quit jiq’uey abal nan u uluhuits ne’ets quin huichits ti eb c’al u Tata ti eb. ");
INSERT INTO husNT1971_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","A ats’amalchic jahua’ nan tu ucha’its abal ne’ets quin c’ale hue’ ani ne’ets quin huichiy junil abal quin c’uajiy c’al tata’chic. Max tin chubax c’anithal, ne’ets quit culbechic cum in ne’ets c’al u Tata ti eb. In ey jaja’ lej pulic ani nana’ hue’ tocat. ");
INSERT INTO husNT1971_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Xohue’ nan tu q’uejab olchalchic abal in ne’ets c’al u Tata, ani tam quin c’alets yab ca hualcanchi a tsalap quit t’apchin a belomtal. Tiquin lej t’ayat bela’. ");
INSERT INTO husNT1971_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Cum hue’its ne’ets ca chich an oc’ox teneclab ax u abatnom c’al an hualab c’ay’lal, yabats ne’ets tu uchayechic yan i cau. Aba ani’ pel i abatnom, yab in cua’al in lej tsap abal nan tiquin abatna’. ");
INSERT INTO husNT1971_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Expith u t’ajal jahua’ tin abatnal u Tata ti eb cu t’aja’. Antsana’ in tso’obnal axi yab belomchic abal lej chubax u c’anithal u Tata ti eb. Huana cu tixc’anchic teje’. ");
INSERT INTO husNT1971_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Nana’its ejtil in acanlec lab t’uthub, ani u Tata ti eb jats ejtil am beletnom lab t’uthub. ");
INSERT INTO husNT1971_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","U belomilchic ejtil i c’ue’lab. Ne’ets ca muts’iyat c’al u Tata axi yab alhua’ ejtil max ca muts’iyat in c’ue’el i lab t’uthub axi yab alhua’ ani yab im binal i hualilab. Ne’ets ca huejlanchat c’al u Tata ti eb an belomchic axi alhua’ tin ichich ejtil ca huejlanchat in c’ue’el i lab t’uthub axi alhua’ abal quim binaye más hualilab. ");
INSERT INTO husNT1971_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","It huejlanchithitschic a ichich c’al an cau jahua’ nan tu exobchamalits. ");
INSERT INTO husNT1971_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ets’ey ca ne’tha’ a ichich ts’ot’c’óx c’al nana’ u ichich jant’ini’ nana’ u ichich ets’ey ts’ot’c’óx c’al tata’chic a ichich. Jun i c’ue’lab yab in ejtohual quim bina’ i hualilab max yab ca jilc’on ts’ot’c’óx c’al in acan an lab t’uthub, cum an c’ue’lab yab in cua’al in cuete’ tsap. Antsana’ tata’chic max yab junini’ ts’ot’c’óx a ichich c’al nana’ u ichich yab ne’ets ca ejtou ca t’aja’ jahua’ alhua’. ");
INSERT INTO husNT1971_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Nana’its ejtil in acanlec lab t’uthub, ani tata’chic ejtil max it c’ue’lab. Ne’ets ca ejtouchic ca t’aja’ yan alhua’ max it junini’ ts’ot’c’óx a ichich c’al nana’ u ichich, ani antsana’ ne’ets ca baju ejtil i alhua’ c’ue’lab ts’at’at tin acan an lab t’uthub ax im binal yan i hualilab. Ni jant’o yab a ejtohual ca t’aja’ alhua’ max nan yab tu tolminchal. ");
INSERT INTO husNT1971_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Max yab ca ne’tha’ a ichich junini’ ts’ot’c’óx c’al nana’ u ichich, ne’ets quit tixc’a ani quit pet’na ejtil i c’ue’lab axi yab alhua’. Ca t’ajat huayey ani ca tamcuth chican. ");
INSERT INTO husNT1971_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Max ca ne’tha’chic a ichich junini’ ts’ot’c’óx c’al nana’ u ichich ani u cahuintal junini’ lej t’ayat ta ichich, tam ojni’ ne’ets ca ejtou ca conchi a Dios jahuats ca le’na’ ani jaja’ ne’ets ti pitha’. ");
INSERT INTO husNT1971_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Max a t’ajalchic yan i alhua’ t’ajbilab tam ojni’ ne’ets ca puhuethanchat im bij u Tata ti eb. Ani antsana’ ne’ets ca tejhua’metha’ abal tata’chic chubax pel tu exobalilchic. ");
INSERT INTO husNT1971_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Nan tu c’anithal tata’chic jant’ini’ nana’ tin c’anithal jaye u Tata ti eb. Ets’ey ca lej t’ilt’om ta ichich abal nan tu lej c’anithalchic. ");
INSERT INTO husNT1971_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Antsana’ ne’ets ca t’ilt’om max ca putu c’al an uchbixtalabchic jahua’ nan tu uchbiyal. Nan u putuhual c’al an uchbixtalabchic ax tin uchbiyal u Tata ti eb, ani jaxtam u ets’ey t’ilt’om abal u Tata ti eb tin c’anithal. ");
INSERT INTO husNT1971_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Nan tu t’iloxnanchichic axe’ xi cau abal quit jum putat culbe junax c’al nana’. ");
INSERT INTO husNT1971_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","U uchbixtal jats axe’: Quit c’anitháxin jun c’al xi jun. Quit c’anithomats jayetseq’ui jant’ini’ nana’ tin c’anithom c’al tata’chic. ");
INSERT INTO husNT1971_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","An c’anithomtalab más c’athpich jats max jun i inic quim bina’ tim ba’ ca tsemets ti calchix c’al in ja’ub. ");
INSERT INTO husNT1971_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Tata’chic pel tu lej cuete’ ja’ub max a putuhual c’al jahua’ tu uchalchic ca t’aja’. ");
INSERT INTO husNT1971_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Nan tu bijiyal tit ja’ubchic, cum nan tu tso’oblinchamalits patal an cau jahua’ tim pithamal u Tata ti eb. Yabats ne’ets tu bijiychic expith tit t’ojnal c’al nana’, cum an t’ojnal yab u tso’oblinchab in lej tsalap in amu. ");
INSERT INTO husNT1971_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Nana’ tu oc’ox tacuychic abal ca baju nana’chic tu c’al, ani talbel tata’chic tiq’uele tin tacuy. Nan tu tacuychic abal ca t’aja’ jahua’ alhua’ abal ca baju ejtil i alhua’ c’ue’lab ax im binal i alhua’ hualilab. A alhua’ t’ajbilchic ne’ets ca ohuey abal ets’ey. U Tata ti eb ne’ets ti pitha’chic patal jahua’ ca conchi c’al nana’ u bij. ");
INSERT INTO husNT1971_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Nan tu uchbiyalchic quit c’anitháxin jun c’al xi jun. ");
INSERT INTO husNT1971_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Max it at’abchic c’al axi yab exlom c’al a Dios, ca t’aja’ ti cuenta abal nan oc’ox in at’ame c’al axi yab exlom c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Max jununulac a tsalapchic c’al axi yab exlom c’al a Dios, it c’anithabac c’al jaja’chic. Cum yab jununul a tsalap c’al jaja’chic, jats tit at’abchic. Cum nan tu tacuychic ani tu calthamalits c’al jaja’chic, jaxtam yabats it le’nab c’al jaja’chic. ");
INSERT INTO husNT1971_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ca t’ila’chic jahua’ tu ucha’ lej hue’ in exbath an t’ojnal ani lej pulic in exbath an amulab. Cum nana’ tin othnamal axi yab exlom c’al a Dios, ne’ets quit othnachicte. Cum yab im putumal an cau jahua’ nan u exobchamalitschic, más max tata’ ca exobchichic yab ne’ets quin le’na’ quim putu. ");
INSERT INTO husNT1971_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Antsana’ ne’ets quit t’ajchin cum it ts’at’atchic c’al nana’. Axi yab exlom c’al u Tata ti eb ax tin aba’ quin chich teje’ tsabal, jats ne’ets ti at’a’ ani ti othna’chic. ");
INSERT INTO husNT1971_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Nan in che’nequits ani u olchamalits an inicchic an chubaxtalab. Jolbithits jitats yab exlom c’al a Dios, cum im pojcamal an chubaxtalab. Yab in ejtohualchic quin huaynanchi in hualab, cum u olchamalits jant’ini’ ta ca paculanchat c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Jitats tin at’al nana’, in mac’uchith at’al jaye u Tata ti eb. ");
INSERT INTO husNT1971_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","U t’ajamal i labith t’ajbilabchic axi ni jayq’ui’ yab t’ajnenec tin tsu’ux hual an inicchic. Jolbithits jitats tin tsu’chamal u labith t’ajbilchic ani yab im belamal. Tin at’al nana’, ani in mac’uchith at’al jaye u Tata ti eb. ");
INSERT INTO husNT1971_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Tin t’ajchal axi yab exlom c’al a Dios jant’ini’ ti thuchath al an ts’ejcath cau axi jilchin a Moisés antse’: Tin at’al aba ani’ yab jant’o u t’ajchamalchic quithab. ");
INSERT INTO husNT1971_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","C’al in culbetal u Tata ti eb nan ne’ets tu abchichic an Espíritu Santo abal ti tolminchi ani ti culbethanchi a ichich. Ja’its an Espíritu Santo axi ne’ets ti exobchiye u ey. ");
INSERT INTO husNT1971_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ani tata’chic ne’ets tiquin olnanchi u ey c’al an inicchic, cum it xe’tsinenec c’al nana’ ma tam ti nan tu tacuyamalits abal quit ts’at’ey c’al nana’. ");
INSERT INTO husNT1971_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Nan tu q’uejab uchamalitschic abal ne’ets quit at’a ani ne’ets quit othna, abal tam antsana’ quit t’ajchinchic yab quit t’apchin a belomtal. ");
INSERT INTO husNT1971_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ne’ets quit quethmayat quit c’ale eleb tin tiyopanil an Israelchic. Ma jita’chic ne’ets quin le’na’ ti t’ajat tsemtha’chic, ani ne’ets quin ulu abal antsana’ in t’ajchal in culbetal a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Antsana’ ne’ets quit t’ajchin quithab c’al i inicchic, cum yab pel i exlom c’al u Tata ti eb ani yab pel i exlom c’al nana’. ");
INSERT INTO husNT1971_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Tam antsana’ quit t’ajchin ca t’ila’ jahua’ tu ucha’its, yab quit t’apchin a belomtal. Nan yab tu thubat ucha’chic axe’ xi cau, cum nan u exla’ abal ne’ets quin c’uajiye hue’ c’al tata’chic. ");
INSERT INTO husNT1971_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Xohue’its ojni’ tu uchalchic abal in ne’ets ti eb c’al u Tata ax tin aba’ quin chich teje’ tsabal. Antsana’ tu uchalchic aba ani’ ni jun tata’chic yab tin conoyal jale’ tin ne’ets. ");
INSERT INTO husNT1971_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Xohue’ it lej t’e’pinalchic a ichich, cum tu ucha’ abal in ne’ets. ");
INSERT INTO husNT1971_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Lej chubax tu uchalchic abal in tomnal quin c’ale ti eb, cum ma tihua’ ne’ets tu abchichic an Espíritu Santo. Max yab quin c’ale yab u ejtohual tu abchi abal ti tolminchi ani ti culbethanchi a ichich. ");
INSERT INTO husNT1971_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ne’ets ca chich an Espíritu Santo quin tso’oblinchi axi yab exlomchic c’al a Dios tin cuenta an hualabtalab, tin cuenta jahua’ bolith, ani tin cuenta an ts’ejcaxtalab axi ne’ets ca t’ajchin an inicchic c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ne’ets ca tso’oblinchat jaja’chic pel i hualabtalab max yab tiquim bela’ nana’. ");
INSERT INTO husNT1971_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ne’ets ca tso’oblinchat abal patal jahua’ nan u t’ajamal jats axi bolith, ani jaxtam ne’ets quim bats’uhuat c’al u Tata ti eb tam quin c’ale tihua’. Hue’its ani yabats ne’ets tiquin tsu’u quin xe’tsin teje’ tsabal. ");
INSERT INTO husNT1971_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ne’ets ca tso’oblinchat abal ne’ets ca t’ajchin an ts’ejcaxtalab c’al a Dios. Ne’ets ca jolbiyat max yab tiquim bela’ ani ca jilc’one c’al an teneclab, cum jolbithits an teneclab. ");
INSERT INTO husNT1971_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","U cua’ale yan i cau u le’ tu ucha’chic, ani yabaye a ejtohual ca penonoy ta ichich. ");
INSERT INTO husNT1971_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ne’ets ca chich an Espíritu Santo abal ti quithat exobchi an chubaxtalab. Jaja’ ne’ets ti olchinchi i cau axi ca pithan c’al a Dios ti eb, ani yab in cuete’ cahuintal axi ne’ets ti olchinchichic. Ne’ets ti tso’oblinchichic c’al tata’ jahua’ a Dios ne’ets quin t’ajaye talbel. ");
INSERT INTO husNT1971_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ja’its an Espíritu Santo axi ne’ets ti tso’oblinchichic c’al tata’ u lej ey ani patal jahua’ u cua’al, ani antsana’ ti ne’ets tiquim puhuethanchi u bij c’al tata’chic. ");
INSERT INTO husNT1971_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Patal jahua’ pel in c’al u Tata ti eb pel u c’alne, ani jaxtam nan tu ucha’chic abal an Espíritu Santo ne’ets ti tso’oblinchichic c’al tata’ u lej ey ani patal jahua’ u cua’al. ");
INSERT INTO husNT1971_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Hue’its yab ne’ets tiquin tsu’u c’al a tsu’ux hual. Ma talbelaquits hue’ tam ne’ets tiquin tsu’u junil c’al a tsu’ux hual, ani tam ojni’ in ne’ets jun ti c’uajat u Tata ti eb. ");
INSERT INTO husNT1971_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Tamna’ huahua’ tu exobalil a Jesús i conoyal jun c’al xi jun: ―¿Jant’ini’ tu lejquith calel hualam axe’ xi cau abal hue’its yab ne’ets qui tsu’u c’al i tsu’ux hual, ani ma talbelaquits hue’ tam ne’ets qui tsu’u c’al i tsu’ux hual junil? ¿Jant’ini’ hualam tin ulal abal in ulal ne’ets c’al in Tata ti eb? ");
INSERT INTO husNT1971_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Yab i ejtiyal an cau jahua’ in ulal abal hue’itscua’. ");
INSERT INTO husNT1971_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Cum a Jesús in tso’obits abal le’nab ca conoyat c’al nixe’ xi cau, tu ucha’chic: ―Nan tu ucha’chic abal hue’its yab ne’ets tiquin tsu’u, ani ma talbelaquits hue’ tam ne’ets tiquin tsu’u junil c’al a tsu’ux hual. ¿Jats axe’ an cau c’al ax a conoyalchic? ");
INSERT INTO husNT1971_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Lej chubax nan tu uchalchic abal ne’ets quit uq’uin ani ne’ets quit lej t’e’pin tam nan quin c’alejits. Axi yab exlomchic c’al a Dios jats axi ne’ets ca culbe tam ne’ets quin c’ale. Aba ani’ ne’ets quit t’e’pinchic, bel ne’ets quit culbethanchat a ichich. ");
INSERT INTO husNT1971_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","An uxum u yajbel lej tam hue’its ne’ets ca hua’tsin i t’ele’, ani u lej culbel tam hua’tsinenequits in t’ele’il. Tam hua’tsinenequits in t’ele’il yabats in ats’al an yajal an uxum. ");
INSERT INTO husNT1971_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Xohue’ tata’chic a ats’al yajchic cum ne’ets quin c’ale. Talbel tam quin huichiy ani cu tsu’úxin junil, tam ne’ets quit jum putat culbechic. Ne’ets ca ne’tha’ t’ayat ta ichich nixe’ xi culbeltalab, ani ni jita’ yab ne’ets quin ejtou ti tixc’anchi. ");
INSERT INTO husNT1971_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Tam quim bajuhuits an q’uicha in c’uajataquits c’al u Tata ti eb, tam yabats ne’ets ca yejenchi tiquin conchi jant’o. Ne’ets ca conchi u Tata ti eb c’al nana’ u bij, ani lej chubax ne’ets ti pitha’chic patal jahua’ ca conchi. ");
INSERT INTO husNT1971_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Yabaye a conchamal u Tata ti eb jant’o c’al nana’ u bij. Ma xohue’ ca conchi, ani jaja’ ne’ets ti pitha’ abal quit jum putat culbechic a ichich. ");
INSERT INTO husNT1971_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Axe’ xi cauchic jahua’ tu uchamalitschic u eyenthamal i t’ipchixtalab. Ne’ets quim baju an hora tam ne’ets tu lejquith olnanchichic in ey u Tata ti eb, ani yabats cu eyentha’ i t’ipchixtalab. ");
INSERT INTO husNT1971_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Tam in c’uajataquits ti eb, tam ne’ets ca mo’canchi a conchixtal c’al u Tata ti eb c’al nana’ u bij. Yabats ne’ets cu yejenchi cu ucha’ u Tata ti eb abal ti pitha’ jahua’ ca conchi. ");
INSERT INTO husNT1971_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Ne’ets ti pitha’chic u Tata ti eb, cum jaja’ ti lej c’anithalchic. Ti lej c’anithalchic u Tata ti eb, cum tata’chic tin c’anithal nana’ ani a belal abal u Tata ti eb jats tin aba’ quin chich teje’ tsabal. ");
INSERT INTO husNT1971_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","In c’uajatac c’al u Tata ti eb ani tin aba’ quin chich teje’ tsabal. Ne’ets quin cale teje’ tsabal ani quin huichiy junil c’al u Tata ti eb. ");
INSERT INTO husNT1971_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Tam huahua’ i ucha’ a Jesús: ―Xohue’ tu lejquith olchalchic an cau ani yab c’al i t’ipchixtalab. ");
INSERT INTO husNT1971_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Xohue’ ojni’ i tso’obits abal a tala’ exlal patal an cau ani yab a yejenchal jita’ ti olchiye i cau. Jaxtam lej chubax i belal abal ti abamalits a Dios quit chich teje’ tsabal. ");
INSERT INTO husNT1971_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","A Jesús tu ucha’chic: ―¿Lej chubax antsana’ tim belalits? ");
INSERT INTO husNT1971_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Hue’its ne’ets quim baju an hora tam ne’ets quit athintha quit xe’tsin buc’uc’ul. Ne’ets quit buc’uc’ul c’uajiy ta cuete’ q’uima’chic. Aba ani’ tata’chic ne’ets tiquin jilcacay cuetem, bel yab ne’ets quin c’uajiy cuetem cum u Tata ti eb ets’ey c’uajat c’al nana’. ");
INSERT INTO husNT1971_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Patal axe’ xi cau nan tu uchalchic abal tu jun ejetbethanchi a ichich ani tu thacatbethanchichic a ichich. Aba ani’ lej chubax ne’ets ca yajchicna’ teje’ ti al an hualab c’ay’lal, bel ca ne’tha’ a ichich thacat cum nan u tala’ atanthanchamalits jahua’ yab alhua’ ani axi tomolnax c’al a Dios teje’ ti al an hualab c’ay’lal. ");
INSERT INTO husNT1971_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Tam ti a Jesús tu uchamalitschic huahua’ patal axe’ xi cau, tam in met’a’ hualq’ui’ ti eb ani in ulu: ―Tata ti eb im bajuhuits am pejchith hora tam ne’ets quin yajchiquiyat. Tata ti eb cum nan pel tin Tsacamil tiquin tejhua’methanchi u pulic ey c’al an inicchic, ani nana’ jaye ne’ets tu tejhua’methanchi a pulic ey c’al an inicchic. ");
INSERT INTO husNT1971_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Cum pel tin Tsacamil tata’ tim pithamalits u eyaltal c’al patal an inicchic, abal cu pitha’ i it ejattalab abal ca ets’ey c’uajiy c’al tata’ ti eb patal jitats tata’ tiquim pitha’ nan cu c’alna’. ");
INSERT INTO husNT1971_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","U pithalchic i it ejattalabchic abal ti alhua’ exla’ tin ichich tit juncats ani tit lej chubax Dios. Quin ejtouchic tiquin alhua’ exla’ne, abal nana’ chubax pelits in Jesucristo ani chubax in abnenec c’al tata’ Tatalab ti eb quin chich teje’ tsabal. ");
INSERT INTO husNT1971_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Nan tu puhuethanchamalits a bij teje’ ti al an hualab c’ay’lal, cum u tala’ t’ajamal patal jahua’ tin uchbiyamal cu t’aja’. ");
INSERT INTO husNT1971_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Jaxtam xo’ Tata ti eb, tiquin t’ojojonchi tihua’ ti eb abal quim puhuethanchat u bij junil ejtil tim puhuethanchame u bij ti jayq’ui’ tam ti yabaye ts’ejcanenec an eb ani an tsabal ani patal jahua’ hua’ats. ");
INSERT INTO husNT1971_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Nan tu tso’oblinchamalits a ey c’al am belomchic axi tata’ tim pithamalits cu c’alna’. Pel jaja’chic ax a tacuyamal ta c’al tata’, ani xo’ tim pithanchamal cu c’alna’ne. Pel jaja’chic im putuhual c’al a cahuintal jahua’ nana’ u olchamalits. ");
INSERT INTO husNT1971_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","In tso’bimits jaja’chic abal patal jahua’ u cua’al jats axi tata’ tim pithamal. ");
INSERT INTO husNT1971_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Nan u huat’banchamalits a cahuintal c’al jaja’chic ani in lej belchamalits c’al in lej ichich. Tin alhua’ exlalits abal nana’ jats ax in tal c’al tata’ tihua’ ti eb. In lej belalitschic abal jats nana’ ax in abnenec c’al tata’ quin chich teje’ tsabal. ");
INSERT INTO husNT1971_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Cum axe’ xi belomchic pel tata’ a c’al ani xo’ tata’ tim pithanchamal cu c’alna’ne, jaxtam u conchinchalchic i alhua’talab c’al tata’. Yab u conchinchalchic i alhua’talab axi yab exlom c’al tata’. ");
INSERT INTO husNT1971_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Patal am belomchic pelits i they c’al, ani c’al jaja’chic in xe’tsintal jats c’al tim puhuethanchab u bij. ");
INSERT INTO husNT1971_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Hue’its ne’ets quin cale teje’ tsabal quin c’ale c’al tata’ t’ocat Tata ti eb. Ca biyat xe’tsinchic am belom teje’ tsabal ca lej alhua’ co’bitsiy c’al a tsap, cum jats jaja’chic tim pithanchamal cu c’alna’ne. Quin co’oychic juncuth in ichich jant’ini’ nana’ juncuth u ichich c’al tata’ a ichich. ");
INSERT INTO husNT1971_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ma xohue’ nan in xe’tsinenec c’al jaja’chic ax tim pithanchi cu c’alna’, ani u lej beletnamalchic ani u lej jec’onthamal c’al u tsap jaja’chic axi tata’ tim pitha’. Yab u hualcanchi ca q’uibeychic. Expith jaja’ axi pel i t’ajat q’uibelom inic jats ne’ets ca q’uibey. Antsana’ ne’ets ca putun an T’ocat Thuchlab jun tu olnab jaja’ abal ne’ets ca q’uibey. ");
INSERT INTO husNT1971_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Hue’its ani nan in ne’ets jun ti tata’ it c’uajat quin c’uajiyne. Biyat hue’ in c’uajate teje’ tsabal ne’ets cu exobchiye u belomilchic tsab ox i cau abal ca jum putat culbe in ichich jant’ini’ tu culbel nana’ u ichich. ");
INSERT INTO husNT1971_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nan u huat’banchamalits c’al jaja’chic patal an cau axi tata’ tim pithamal. Ani u at’ab jaja’chic c’al an inicchic axi yab exlom c’al a Dios, cum yab juncuth in ichich jant’ini’ nana’ u ichich jaye yab juncuth c’al axi yab exlom c’al a Dios ani in t’ajt’om ti cuenta expith jahua’ teje’ tsabal. ");
INSERT INTO husNT1971_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Nan yab tu conchal Tata ti eb max ca t’ajat tixc’a’ am belomchic teje’ tsabal, expith tu conchal abal ca c’aniychic c’al an teneclab. ");
INSERT INTO husNT1971_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Jant’ini’ nana’ u ichich yab juncuth c’al axi yab exlomchic c’al a Dios ani in t’ajt’om ti cuenta expith jahua’ teje’ tsabal, antsana’ jaye in ichich am belomchic jant’ini’ nan u ichich. ");
INSERT INTO husNT1971_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Quin lej penonoy tin ichich a cahuintal axi lej chubaxtalab, ani quin ne’tha’ in ichich ets’ey binathits c’al tata’. ");
INSERT INTO husNT1971_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Jant’ini’ tata’ tin aba’ teje’ tsabal tu t’ajchi a culbetal, antsana’ jaye nana’ ne’ets cu aba’chic u belomil abal tiquin t’ajchi u culbetal. ");
INSERT INTO husNT1971_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Nan u lej t’ayat binal tu ba’ c’al tata’ abal cu tolminchi u belomilchic quim penonoy tin ichich an chubaxtalab, ani antsana’ quin ne’tha’ in ichich ets’ey binathits c’al tata’. ");
INSERT INTO husNT1971_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Nan tu conchinchal Tata ti eb i alhua’talab c’al axi pelits i belomchic, ani jaye tu conchinchal c’al axi ne’etse tiquim bela’ tam ca olchin an alhua’ cau c’al axi belomits. ");
INSERT INTO husNT1971_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Tu conchal Tata ti eb ca pitha’chic in ichich juncuthits jant’ini’ nana’ juncuth u ichich c’al tata’ a ichich. Quin co’oychic in ichich ts’ot’c’óx ejtil tata’ ani nana’ i ichich, abal axi yabaye exlom c’al a Dios quim bela’ jaye abal chubax tata’ tin aba’ quin chich teje’ tsabal. ");
INSERT INTO husNT1971_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Jant’ini’ tata’ tim pitha’ u ts’alat ey, antsana’ nana’ jaye u pithamalits jayetseq’ui in ts’alat ey am belomchic, abal patalchic jaja’ quin co’oy in ichich juncuthits ejtil nana’ ani tata’ u juncuthits i ichich. ");
INSERT INTO husNT1971_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Nana’ in c’uajat c’al jaja’chic tin ichich jant’ini’ tata’ it c’uajat c’al nana’ tu ichich, abal cu tolminchi quin co’oychic in ichich lej jum putat juncuthits. Antsana’ ca t’ajchin ti cuenta lej juncuthits in ichich am belomchic abal axi yabaye exlomchic c’al a Dios quim bela’ abal lej chubax tata’ tin aba’ quin chich teje’ tsabal. Aniye ca t’ajchin ti cuenta c’al axi yab exlomchic c’al a Dios abal lej ichich hual u c’anithab am belomchic c’al tata’ jayetseq’ui jant’ini’ nana’ tin ichich hual c’anithab c’al tata’. ");
INSERT INTO husNT1971_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Tata ti eb, tata’ tim pitha’ am belomchic cu c’alna’, ani cum pel u lej c’al u lej le’ abal ca c’uajiychic c’al nana’ ti eb. Tihua’ ca tejhua’methanchat u ts’alat ey axi tata’ tim pithamal tin ebal a c’anithomtal. Ets’ey tata’ tin lej c’anithal, ma tam ti yabaye ts’ejcanenec an eb ani an tsabal tin c’anithamalits. ");
INSERT INTO husNT1971_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Tata’ Tata ti eb it ets’ey pututh c’al jahua’ ca ulu ne’ets ca t’aja’. An inicchic ax in t’ajt’om ti cuenta expith jahua’ teje’ tsabal yab ti exlal. Nana’ ojni’ tu exlalits. Ani am belomchic in exlalits abal tata’ tin aba’ quin chich teje’ tsabal. ");
INSERT INTO husNT1971_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nana’ tu tso’oblinchamalits a ey c’al jaja’chic ani ne’ets cu tso’oblinchiye. Quin alhua’ exlanchi tin ichich a c’anithomtal abal quin ejtou ti c’anithom jant’ini’ tata’ it lej c’anithom jant’ini’ tata’ it lej c’anithom c’al nana’. Quin alhua’ exla’chic abal nana’ in c’uajat tin ichich jaja’chic am belom. ");
INSERT INTO husNT1971_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Tam ti talits tucu ucha’ antsana’ an cau a Jesús huahua’ tu exobalil, u junax c’ale jum poq’ue’ an tsacam itse’ Cedrón. Taja’ hua’ats i t’ayablab te’lom jun tu otsits. ");
INSERT INTO husNT1971_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Cum yan i calat taja’ tu otsenec huahua’ junax c’al a Jesús, in exla’ taja’ jaye a Judas axi ne’ets quin tsinat bina’ a Jesús tin c’ubac in tomolnaxilchic. ");
INSERT INTO husNT1971_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Tats ti ulits a Judas junax c’al i cuenel i soldadochic ani i yac’ualchic axi abnenec c’al an ts’alechic pale’ ani c’al an fariseochic. Ts’ejcachic ti tal c’al i te’ ani c’al i matset. In chi’thalchic i tajablab ani i huayelom tsajib joc’path c’al i c’amal. ");
INSERT INTO husNT1971_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Cum a Jesús in tala’ exla’its jant’o ne’ets ca t’ajchin, utey c’al jaja’chic ani in conoy: ―¿Jita’ ax a aliyal? ");
INSERT INTO husNT1971_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Toc’tsinchic: ―A Jesús Nazaretib. A Jesús in toc’tsiychic: ―Nana’ ojni’ ja’its. Ani taja’ c’uajat c’al an yac’ualchic a Judas axi ne’ets quin tsinat bina’ a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Tam ti a Jesús in ulu nana’ ojni’ ja’its, tam ti tala’ je’at ijcachiquinchic tsabal. ");
INSERT INTO husNT1971_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Tam a Jesús in conoychic junil: ―¿Jita’ ax a aliyal? Toc’tsinchic: ―A Jesús Nazaretib. ");
INSERT INTO husNT1971_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Tam a Jesús in ucha’chic: ―Tu ucha’its abal nana’ ojni’ ja’its. Max nana’ ja’its tin aliyal, expith ca jila’ ca c’alechic axe’ u juntalchic. ");
INSERT INTO husNT1971_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Antsana’ in ulu a Jesús ca jilan ca c’alechic abal ca putun an cau jahua’ in ulumalits antse’: Yab u hualcanchi ca q’uibey ni jun i belom ax tim pitha’ u Tata ti eb cu c’alna’. ");
INSERT INTO husNT1971_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Tam a Simón Pedro in jixa’ an matset ax in xe’tsinthal ani in muts’q’uinchi in huinab xutsun in tolmixal an ts’ale pale’. Im bij pel i Malco. ");
INSERT INTO husNT1971_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Taley a Jesús in ucha’ a Pedro: ―Ca huichba’ an matset tin ot’ol. Hualam max a lej tsalpayal abal nan yab pel u uchbil cu yajchicna’ jant’ini’ tim bijchithits c’al u Tata ti eb cu yajchicna’. ");
INSERT INTO husNT1971_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Tam nixe’ xi soldadochic junax c’al in oc’lequil ani junax c’al nixe’ xi Israel yac’ualchic in yac’ua’ ani in huic’a’ a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ani thubatq’ui ne’tha a Jesús tin q’uima’ a Anás axi pel i ts’ale pale’ nixe’ xi tamub. Ja’its nixe’ a Anás axi pel i iyam tatalab c’al a Caifás. ");
INSERT INTO husNT1971_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Pel nixe’ a Caifás ax in ulumal abal alhua’ ca tsemtha’ juncats i inic ti calchix, ani yab ca talabetha patal am bichou Israel. ");
INSERT INTO husNT1971_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","A Simón Pedro ani junaque in exobalil a Jesús in aycom a Jesús jun ti ne’thab. Cum axi junaque pel in exlohual an ts’ale pale’, jilan ca otsits ti al am patio tin q’uima’ an ts’ale pale’. ");
INSERT INTO husNT1971_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ani a Pedro jilc’on utat an hui’leb eleb. Ani nixe’ xi exobal in tauna’ an ts’ic’ach axi beletnom hui’leb quin jila’ ca otsits a Pedro. ");
INSERT INTO husNT1971_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Tam conoyat a Pedro c’al an ts’ic’ach: ―¿Yab i pelte ti exobalil axe’ xi inic te chi’thame? Toc’tsin a Pedro: ―Nana’ iba. ");
INSERT INTO husNT1971_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Cum lej tsamay, in ts’ejcamalits i c’amal an yac’ualchic ani an t’ojnalchic tin q’uima’ an ts’ale pale’. Cubuchic ti thilal taja’, ani c’uajat a Pedro junax thilal c’al jaja’chic. ");
INSERT INTO husNT1971_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","An ts’ale pale’ in ts’i’quiy quin conoy a Jesús jita’ jaja’ in exobalilchic ani jaye tin cuenta in exobchixtal. ");
INSERT INTO husNT1971_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","A Jesús in toc’tsiy: ―Nan ets’ey in xe’tsinenec abal ju’tamq’ui tin exobchix c’al an inicchic ani jaye tin tiyopanilchic an Israelchic ani ti al am pulic tiyopan jun tu mulcunal an Israelchic. U tejhua’ exobchamalitschic ani ibats u tsinat exobchamal c’al ni jun i cau. ");
INSERT INTO husNT1971_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Jale’ tin conoyal abal jita’ nan u exobalilchic ani jaye tin cuenta u exobchixtal? Ca conoychic ax tin ats’anchamal u exobchixtal, ani jaja’chic ne’ets ti olchi jant’o tam cau nan u exobchamal. Jaja’chic ojni’ in tso’obits jant’o in ey ax u exobchamal. ");
INSERT INTO husNT1971_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Tam ti a Jesús in ulu antsana’ an cau, tamna’ ti mo’canchat i c’ubaclec tin hual c’al jun nixe’ xi yac’ualchic. Ani conoyab: ―¿Jale’ antsana’ ta toc’tsiyal an ts’ale pale’? ");
INSERT INTO husNT1971_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Toc’tsin a Jesús: ―Tiquin tequeth ucha’ max quithab jahua’ u ulal o max iba. ¿Jale’ tin alq’uith cuathal max iba? ");
INSERT INTO husNT1971_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Taley a Anás in aba’ ca ne’tha a Jesús huic’ath c’al an ts’ale pale’ Caifás. ");
INSERT INTO husNT1971_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Biyat cubate hue’ a Pedro ti thilal ba’ an c’amal, uchan: ―¿Yab i pelte ti exobalil axe’ xi inic te chi’thame? A Pedro in tsinca’ tim ba’, in ulu: ―Nana’ iba. ");
INSERT INTO husNT1971_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","C’uajat taja’ jun axi pel in tolmixal an ts’ale pale’ ani pel in at xits’al ja’ub an inic axi muts’q’uinchat in xutsun c’al a Pedro. Conoyat a Pedro c’al jaja’: ―¿Auxe’ max yab i tata’its ax tu tsu’u tihua’ al an t’ayablab te’lom c’al axe’ xi inic? ");
INSERT INTO husNT1971_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","A Pedro tam in tsinca’ tim ba’ junil, ani tameq’ui tu thajnal an coxol. ");
INSERT INTO husNT1971_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Tam caltha a Jesús tin q’uima’ a Caifás ani ne’tha tam ti chuthelits ti al an ata jun tin ts’ejcal an cau an gobernador. An Israelchic ax u jolbix c’al a Jesús yab in le’ ca otsits taja’, cum pel i hualabtalabcua’ jaja’chic ca otsits antsana’ c’al axi yab Israel. Max quin t’aja’, yab ne’ets quin ejtouchic quin c’apchi in t’u’ul an cordero ax u tsemthab c’al an ajib tin cuenta abal ti calthame ti Egipto im biyal juntalchic. ");
INSERT INTO husNT1971_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Jaxtam cale eleb a Pilato quin tauna’ an Israelchic. In conoychic: ―¿Jant’o in t’ajamal yab alhua’ axe’ xi inic abal a le’ ca jolbiy? ");
INSERT INTO husNT1971_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Toc’tsinchic: ―Tu chanchi cum pel i pojcax inic jaja’. ");
INSERT INTO husNT1971_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Tam a Pilato in ucha’chic: ―Tata’chic ca ne’tha’ ani ca t’ajchi an ts’ejcaxtalab jant’inits tin ulal a ts’ejcath cahuintal ca ts’ejcan. Toc’tsin an Israelchic: ―Huahua’ tu Israelchic yab i uchbil qui ulu ca tsemtha, expith max tata’ ca bina’ an cau ne’ets ca ejtohuat ca tsemtha. ");
INSERT INTO husNT1971_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Antsana’ ne’ets ca putun an cau jant’ini’ tin ulumalits a Jesús abal ne’ets ca tsemtha ti al an cruz. ");
INSERT INTO husNT1971_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Otsits a Pilato alta, in abchi an cau ca chi’tha a Jesús. Chi’tha ani conoyat c’al a Pilato: ―¿Tata’its pel ti Ts’alejil an Israelchic? ");
INSERT INTO husNT1971_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","A Jesús in ucha’: ―¿Tin conoyal ta cuetemtal o hua’ats jita’ ti ucha’ tiquin conoy antsana’? ");
INSERT INTO husNT1971_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Toc’tsin a Pilato: ―Auxe’ max pel in Israel. Pel a at juntal Israelchic ani an ts’alechic pale’ ax ti chi’tha’ c’al nana’. ¿Jant’o hualam a t’ajamal abal ti chi’tha’? ");
INSERT INTO husNT1971_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Tam a Jesús in toc’tsiy: ―Nan yab u lej t’ajal tin Ts’ale teje’ tsabal. Max u lej t’ajalac, tam pejexnenecac u ts’at’elilchic ani yabac tim binathits tin c’ubac an Israelchic. Yab in lej Ts’ale teje’ tsabal. ");
INSERT INTO husNT1971_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Tam a Pilato in ucha’: ―Tam tata’ pelits it Ts’ale. Toc’tsin a Jesús: ―Pel tin Ts’ale jant’ini’ ta ulu. In hua’tsinenec ani in xe’tsinenec teje’ tsabal abal cu olnanchi an inicchic an chubaxtalab. Patal jitats quin lej putu c’al an chubaxtalab, jats axi lej chubax tin ats’anchal u cahuintal. ");
INSERT INTO husNT1971_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Tam a Pilato in conoy: ―¿Jant’o pel in ey an chubaxtalab? Tam ti a Pilato antsana’ in conoy, tam cale ta c’ale quin tauna’ junil an Israelchic. In ucha’chic: ―Yab u elchal ni jant’o yab alhua’ axe’ xi inic abal cu jolbiy. ");
INSERT INTO husNT1971_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Tata’chic a ujnam tiquin conchi abal cu hualca’ jun i huic’nel tam a t’ajalchic an ajib tin cuenta abal ti calthome ti Egipto a biyal juntalchic. ¿A le’chic tu hualcanchi axe’ axi pel a Ts’alejil? ");
INSERT INTO husNT1971_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Tam tim patalchic lej tsapic thajan: ―Iba yab ja ca hualca’. A Barrabás jats ca hualca’. Ja’its a Barrabás pel i cue’. ");
INSERT INTO husNT1971_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Tam a Pilato im bina’ an cau ca huithc’oyat a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Taley an soldadochic im punchal tin oc’ a Jesús jun i thipath q’uith corona ani in cay’chal i tsacni’ nacat coton. Antsana’ in tilibnath t’ajchi a Jesús ti ts’ale. ");
INSERT INTO husNT1971_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Tam in uluchic: ―Je’its in Ts’alejil an Israelchic. Ani tocat in mo’canchalchic i c’ubaclec tin hual. ");
INSERT INTO husNT1971_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Tam cale c’ale eleb junil a Pilato, in ucha’ an Israelchic: ―Te ne’ets tu calthanchi jaja’ ax a chi’thamal. Tu uchalchic abal yab u elchal ni jant’o yab alhua’ abal cu jolbiy. ");
INSERT INTO husNT1971_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Tam cale a Jesús c’al an thipath q’uith corona tin oc’ ani cay’chith c’al nixe’ xi tsacni’ nacat coton. Tam a Pilato in ucha’ an Israelchic: ―Ca met’a’chic te c’uajat jaja’ ax a chi’thamal. ");
INSERT INTO husNT1971_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Tam ti tsu’tat a Jesús c’al an ts’alechic pale’ ani c’al an yac’ualchic, tam in thajat uluchic: ―Ca t’ajat bina’ ca q’uet’ath tsemtha ti al an cruz. Ca t’ajat bina’ ca q’uet’ath tsemtha ti al an cruz. A Pilato in ucha’chic: ―Tata’chic jats ca ne’tha’ ca q’uet’ath tsemtha’ ti al an cruz, cum nana’ yab u elchal jant’o yab alhua’ abal cu jolbiy. ");
INSERT INTO husNT1971_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Toc’tsin an Israelchic: ―Huahua’ an ts’ejcath cau ax tu jilchamal a Moisés in ulal ca tsemtha axe’ xi inic, cum in ulumal abal pel in Tsacamil a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Tam tin ats’a’ antsana’ axe’ xi cau a Pilato, tam lej jiq’uey. ");
INSERT INTO husNT1971_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Otsits junil al an ata jun tin ts’ejcal an cau, in conoy a Jesús: ―¿Ma ju’ta tit tal? Yab toc’tsin a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Tam a Pilato in ucha: ―¿Jale’ yab tin toc’tsiyal? Hualam yab a exlal abal nana’ u cua’al u eyaltal abal tu bina’ quit q’uet’ath tsemtha al an cruz ani u cua’al jaye u eyaltal abal tu jec’ontha’ abal yab quit tsemtha. ");
INSERT INTO husNT1971_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Toc’tsin a Jesús: ―Jats a Dios ax ti pithamal an eyaltalab. Expith jats ta ejtohualac jant’o tiquin t’ajchi. Axi c’athpich hualbith jats jaja’chic ax tim bina’ c’al tata’. ");
INSERT INTO husNT1971_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ma tamits a Pilato in lej luba’ quin tsalpay tin oc’ jant’ini’ ti quin hualca’ a Jesús abal yab ca tsemtha. Bel an Israelchic yab in le’ ca hualca a Jesús, ani jaxtam in thajat ucha’ a Pilato: ―Max tata’ ca hualca’ axe’ xi inic tejhua’ abal yab pel it ja’ub c’al an ts’ale oc’lec romano. Jitats in t’ajalac ti ts’ale ejtil tin t’ajamalac axe’ xi inic, pel i lej tomolnax c’al an ts’ale oc’lec romano. ");
INSERT INTO husNT1971_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Tam tin ats’a’ Pilato axe’ xi cau, tam in abchi an cau ca caltha eleb a Jesús. Taley chich a Pilato ani buxcan tin lactemil jun tin ts’ejcal an cau. Im bij nixe’ xi c’uajattalab ti tenec nic’ath ts’ejcath t’ujub. ");
INSERT INTO husNT1971_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Pelits i ts’ejel hora q’uicha. Pel a q’uicha tam ti t’ojojol an Israelchic tin cuenta an ajib, tam ca chutheyits quin t’aja’ an ajib tin cuenta abal ti calthame ti Egipto im biyal juntalchic. Tam a Pilato in ucha’ an Israelchic: ―Ca tsu’uchic te c’uajat a Ts’alejil. ");
INSERT INTO husNT1971_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Jaja’chic tocat thajat toc’tsin: ―Ca tsemtha. Ca tsemtha. Ca t’ajat bina’ ca q’uet’ath tsemtha ti al an cruz. A Pilato in ucha’chic: ―Auxe’ max cu bina’ ca q’uet’ath tsemtha ti al an cruz a Ts’alejil. Toc’tsinchic an ts’ale pale’: ―I cua’al juncats i ts’ale an ts’ale oc’lec romano. ");
INSERT INTO husNT1971_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Taley a Pilato im bina’ a Jesús c’al an Israelchic abal ca tsemtha. Ta in ne’thalchic. ");
INSERT INTO husNT1971_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ta ne’ets a Jesús in quitnal an cruz. Ultsits al an c’uajattalab im bij Calavera ax u bijiyab ti hebreo cau Gólgota. ");
INSERT INTO husNT1971_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Tats ti q’uet’an a Jesús ti al an cruz. Antsana’ t’ajchin jaye tsab i inic, jun c’uajat tin huinab ani jun c’uajat tin c’uatab a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","A Pilato in abchi i thuchlab jolbixtalab ca punchin tin oc’ an cruz thuchath antse: Ja’its axe’ a Jesús Nazaretib in Ts’alejil an Israelchic. ");
INSERT INTO husNT1971_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Antsana’ ti thuchath ti hebreo cau, ani ti griego cau, ani ti latin cau. Cum c’uajat utatits am bichou jun ti q’uet’ath a Jesús al an cruz, taja’ u huat’el yan i inicchic quin ajiy nixe’ xi thuchlab jolbixtalab. ");
INSERT INTO husNT1971_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Jaxtam uchan a Pilato c’al an ts’alechic pale’: ―Yab alhua’ jant’ini’ ti thuchath abal pel in Ts’alejil an Israelchic. In tomnal ca jalc’uy ca thucha’ antse’, abal jaja’ in ulu pel in Ts’alejil an Israelchic. ");
INSERT INTO husNT1971_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","A Pilato in toc’tsiychic: ―An cau jant’ini’ tu thuchamalits, lejat antsana’ ca jilc’on. ");
INSERT INTO husNT1971_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Tam ti antsana’ c’uajat a Jesús q’uet’ath ti al an cruz, tam an soldadochic in mo’canchi in toltomil ti tse’ i muque’ abal ca c’alnanchat ti junchic i muque’ c’al tse’ i soldado. In nacat coton a Jesús expith tsajith tin naquel ani yab chucuth. ");
INSERT INTO husNT1971_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","An soldadochic in ulu jun c’al xi jun: ―Yab qui cathu axe’. Qui caltha’ i q’uij abal qui tsu’u jita’ ne’ets quin c’alnanchi. Tam antsana’ in t’aja’chic an soldado, tam ti putnal an T’ocat Thuchlab ax in ulu antse’: In caltha’chic i q’uij jant’ini’ tiquin c’alnanchi u toltomil. Jita’ quin c’alnanchi u coton. ");
INSERT INTO husNT1971_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Taja’ cubat utat ti al an cruz in mim a Jesús junax c’al in uxum ebchal in mim a Jesús, ani a María axi pel in tomquil a Cleofas, ani a María Magdalajib. ");
INSERT INTO husNT1971_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Tam tin tsu’uhuits a Jesús taja’ in mim ani nana’ne tin lej ichich hual exobalil, in ucha’ in mim: ―Mim, ca t’aja’ ti cuenta na’ cubat jaja’ axi ca c’uajiy ejtil max pel a cuete’ tsacamil. ");
INSERT INTO husNT1971_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Tam a Jesús tin ucha’ nana’: ―Ca t’aja’ ti cuenta na’ cubat jaja’ axi ca c’uajiy ejtil max pel a cuete’ mim. Ma tamits u ne’tha’ cu beletna’ tu q’uima’. ");
INSERT INTO husNT1971_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Taley in tso’obits a Jesús abal in tala’ putumal in t’ojlabil. Ani abal ca putun jaye an T’ocat Thuchlab jant’ini’ ti q’uejab thuchath ne’ets quin ulu, in ulu: ―In chiquel. ");
INSERT INTO husNT1971_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ani hua’ats taja’ i juyul t’uchat c’al i ts’a’ic vino. Ani jun i inic in tsabay al nixe’ xi vino i thic’axtalab axi hue’ ejtil i cuinim. Taley in caltha’ ani in umchi tin chum i c’ue’lab i te’ hisopo, ani in utenchi tin hui’ a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Tam ti a Jesús in leca’its, tam in ulu: ―Ma xohue’its u tala’ putumalits u t’ojlabil. Tam cutpan in oc’, ani tsemetsits. ");
INSERT INTO husNT1971_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ca chutheyits an Israelchic ne’ets quin t’aja’ an ajib tin cuenta abal ti calthame ti Egipto im biyal juntalchic. Ca chuthey ja’its an sábado, ani yab in le’chic abal ca jilc’on a Jesús ani xi tsab i inicchic al an cruz cum pel i sábado lej c’athpich pulic. Jaxtam an Israelchic in tauna’ a Pilato max ca pejchin im pelet acan abal ca más thubat tsemets ani ca tixc’achic in anam t’u’ul ti al an cruz. ");
INSERT INTO husNT1971_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Tam c’alechic an soldadochic im pejchi im pelet acan axi tsab i inic q’uet’ath al an cruz ejtil a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Tam ti chichchic c’al a Jesús in tsu’u abal tsemenequits, ani jaxtam yabats im pejchi im pelet acan. ");
INSERT INTO husNT1971_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Aba ani’ yabats ejat a Jesús, jun i soldado in xec’chi in tsoyil a Jesús. Thubat c’ale i xits’ ani i ja’. ");
INSERT INTO husNT1971_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Nana’ putat u tsu’u jahua’ t’ajchin a Jesús, ani lej chubax an cau jahua’ nan tu olchalchic abal ca bela’chic an chubaxtalab. ");
INSERT INTO husNT1971_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Cum nixe’ xi soldado yabats im pejchi im pelet acan a Jesús, jaxtam putun jahua’ thuchath ti al an T’ocat Thuchlab antse’: Yab ca pejchin ni jun im beclac. ");
INSERT INTO husNT1971_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ani jaye in ulal an T’ocat Thuchlab axi thuchath antse’ tin cuenta a Jesús: An inicchic ne’ets quin tsu’u jaja’ axi xec’nenec. ");
INSERT INTO husNT1971_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Jun i ts’at’el c’al a Jesús im bij pel a José Arimateajib. Pel i tsinat ts’at’el, cum in ts’ejnal in at Israelchic. In conchi a Pilato ca pithan in inictal a Jesús quin joliy. Cum uchanits quin ne’tha’, c’ale quin t’aja’. ");
INSERT INTO husNT1971_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Tam chich a Nicodemo jaye ju’ta ti c’uajat in inictal a Jesús. Jats jaja’ ax ti jayq’ui’ chich c’al a Jesús tam acal abal ca t’ilmats. In chal ox i lajuj i kilo i ilal ts’ejcath c’al i mirra ani c’al i áloe. ");
INSERT INTO husNT1971_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","A José ani a Nicodemo in thu’banchi in inictal a Jesús c’al i malilil toltom umchithits nixe’ xi ilal, cum antsana’ in ujnam an Israelchic quin thu’banchi in inictal i tsemelom tam ne’ets quin joliy. ");
INSERT INTO husNT1971_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ani taja’ utat jun ti tsemtha a Jesús ti al an cruz hua’ats i t’ayablab te’lom jun ti hua’ats i it jolimtalab tsajath jol paxal t’ujub jun ti yab jayq’ui’ joliyame jita’. ");
INSERT INTO husNT1971_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Tats tin mo’canchi in inictal a Jesús utat jun ti tsemthame. In thubat mo’canchi, cum lej hue’its ne’ets quim baju an q’uicha sábado tam bijithits an Israelchic ca coyots. ");
INSERT INTO husNT1971_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Pel an c’a’al q’uicha semana tam ti ulits a María Magdalajib ti al an jolimtalab lej thajujul ma hue’ yic’uaxe. In tsu’u tixc’athits am pulic paxic’lab t’ujub tin otsnamtal an jolimtalab. ");
INSERT INTO husNT1971_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ani taley tamna’ chich jaja’ athithil jun ti c’uajat a Simón Pedro ani nana’ tin lej ichich hual exobalil a Jesús. Tu ucha’chic: ―Ne’thajits in inictal a Jesús, ani yab u tso’ob ju’ta ti c’uajat. ");
INSERT INTO husNT1971_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Tam a Pedro ani nana’ u c’alechic qui tsu’u. ");
INSERT INTO husNT1971_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ta u ne’etsits lej athithilchic tsab ti eb. Cum in más athlats, in oc’ox ulits ti al an jolimtalab. ");
INSERT INTO husNT1971_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","In cua’pan cu met’a’ al an jolimtalab tsajath jol paxal t’ujub. U tsu’u tocat mo’ol an napach malilil toltom. Yab in otsits. ");
INSERT INTO husNT1971_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Taley ulits a Pedro, ani jaja’ otsits. In tsu’u jaye tocat mo’ol an napach malilil toltom. ");
INSERT INTO husNT1971_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","In tsu’u pil mo’ol t’ulilith an toltom in thu’bal in oc’ a Jesús. Yab tamcuth c’al an malilil toltom. ");
INSERT INTO husNT1971_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Tam in otsitsne, ani u tsu’u jant’ini’ ti tsu’tat jaye c’al a Pedro alta. Tam u lej bela’ abal ejthachits a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Yabaye i lej alhua’ exbayamal an T’ocat Thuchlab ax in olnal abal lej bijithits ne’ets ca ejtha a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Tam u huichits huahua’ ti q’uima’. ");
INSERT INTO husNT1971_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Cubat eleb a María ti uc’nal utat jun ti joliyame a Jesús. Cua’pan quin met’a’ alta al an jol paxal t’ujub. ");
INSERT INTO husNT1971_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","In tsu’u quetel tsab i ángelchic thac toltomith jun ti c’uajatac in inictal a Jesús, jun cuentalith tin oc’ ani jun cuentalith tin acan. ");
INSERT INTO husNT1971_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Conoyat a María c’al an ángelchic: ―¿Jale’ hualam it uc’nal, uxum? A María in toc’tsiychic: ―Ne’thajits in inictal u Ajatic, ani yab u tso’ob ju’ta ti c’uajat. ");
INSERT INTO husNT1971_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Tam ti expith antsana’ in ulu a María, huenc’on hue’ in tsu’piy cubulits jun i inic. Pelits a Jesús, ani a María yab in exla’ max ja’its. ");
INSERT INTO husNT1971_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Tam conoyat c’al a Jesús: ―¿Jale’ hualam it uc’nal, uxum? ¿Jita’ ax a aliyal? In tsalpayal a María abal pel am beletnom t’ayablab te’lom, ani in ucha’: ―Tiquin ucha’ pay’lom, max a ne’tha’ in inictal u Ajatic. Tiquin ucha’ ju’ta ta mo’ca’ abal quin c’ale cu ne’tha’. ");
INSERT INTO husNT1971_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Tam toc’tsin a Jesús: ―María. Tam a María huenc’on, in ucha’ a Jesús ti hebreo cau: ―Raboni. Ti tenec in le’ quin ulu Exobchix. ");
INSERT INTO husNT1971_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Tam uchan c’al a Jesús: ―Yab tiquin taca’ cum yabaye in c’athinec c’al u Tata ti eb. Huinits quit c’ale ca olchichic i ebchalchic abal ne’ets quin c’athiy c’al u Tata axi jaye pel a Tata. Ne’ets quin c’athiy c’al u Diosil axi jaye pel a Diosil. ");
INSERT INTO husNT1971_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Tam a María Magdalajib chich tucu olchi huahua’ tu exobalilchic a Jesús abal in tsu’umal an Ajatic. Tu olchichic an cau jahua’ uchanits c’al a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Pel an c’a’al q’uicha semana ani aclejits tam tu tamcuthitschic huahua’ tu exobalil a Jesús. Lej alhua’ maputh i cua’al an hui’leb, cum i ts’ejnalchic an Israelchic. Tam otscan a Jesús jun tu tamcuthits, ani tu ucha’chic: ―Nan tu pithalchic ta ichich i jun ejettalab. ");
INSERT INTO husNT1971_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Tam tin uluhuits antsana’ a Jesús, tam tu tejhua’methanchichic in c’ubac ani jaye in tsoyil jun ti xec’nenec. Ani u lej culbel cum i tsu’tal an Ajatic c’uajatits. ");
INSERT INTO husNT1971_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Tam a Jesús tu ucha’chic junil: ―Nan tu pithalchic ta ichich i jun ejettalab. Jant’ini’ u Tata ti eb tin aba’ quin chich teje’ tsabal cu t’ajchi in culbetal, antsana’ nana’ tu aba’ tata’chic abal tiquin t’ajchi u culbetal. ");
INSERT INTO husNT1971_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Taley a Jesús tu ixc’aychic, ani tu ucha’: ―Xo’ ca bats’u an Espíritu Santo. ");
INSERT INTO husNT1971_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Max tata’chic ca paculanchi in hualab i inic, tam ojni ne’ets ca paculanchat. Max yab ca paculanchi, tam ojni’ antsana’ ne’ets ca jilc’on yab paculanchith in hualab. ");
INSERT INTO husNT1971_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tam ti chich a Jesús quin tejhua’metha’ tim ba’ c’al huahua’ tu exobalil yab c’uajatac tamna’ a Tomás. Pel jaja’ axi uxnal ti cuaya’cua’. ");
INSERT INTO husNT1971_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Huahua’ i ucha’ a Tomás: ―Xohue’ i tsu’umalits an Ajatic. Toc’tsin a Tomás: ―Nana’ yab ne’ets cu bela’ max yab cu tsu’chi in c’ubac jun ti xec’nenec c’al an labux, ani cu xapchi u ch’uchub c’ubac tin c’ubac ani tin tsoyil jun ti xec’nenec. ");
INSERT INTO husNT1971_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Huaxic a q’uicha talbel u tamcuthits junil al jun i ata huahua’ tu exobalil a Jesús, ani xo’ ojni’ c’uajatits jaye a Tomás. Aba ani’ i cua’al alhua’ maputhits an hui’lebchic, bel otsits a Jesús ani cuble ts’ejel c’al huahua’. Tu ucha’chic junil: ―Nan tu pithalchic ta ichich i jun ejettalab. ");
INSERT INTO husNT1971_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Tam a Jesús in ucha’ a Tomás: ―Ca xapa’ a ch’uchub c’ubac te tu c’ubac. Ca ne’tha’ a ichich lej t’ayat belolol c’al nana’, ani yabats ca ne’tha’ i hualamtalab ta ichich. ");
INSERT INTO husNT1971_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tam toc’tsin a Tomás: ―Tata’its ojni’ pel tu Ajatic ani pel tu Diosil. ");
INSERT INTO husNT1971_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","A Jesús in ucha’: ―Cum tata’ Tomás tin tsu’umal, jaxtam tim belamal. Jitats yab tiquin tsu’u ani bel tiquim bela’, jats axi ne’ets quin ne’tha’ lej ets’ey culbel in ichich. ");
INSERT INTO husNT1971_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","In t’ajamal a Jesús yan i labith t’ajbilabchic abal quin tejhua’methanchi in lej ey an inicchic. Yab lej patal thuchath al axe’ xi u jahua’ jaja’ in t’ajamal. ");
INSERT INTO husNT1971_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Jahua’ thuchathits jats c’al ti qui bela’ abal a Jesús ja’its a Cristo axi bijithits ne’ets ca aban c’al a Dios ca chich. Qui bela’ abal chubax ja’its jaja’ in Tsacamil a Dios. Ma tamna’its ne’ets cu pithan c’al jaja’ i it ejattalab. ");
INSERT INTO husNT1971_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Taley talbel junilaquits a Jesús in tejhua’metha’ tim ba’ c’al tsab ox huahua’ tu exobalil tam tu c’uajat tin hualte’lil am pulic lejem Tiberias. In tejhua’metha’ tim ba’ antse’. ");
INSERT INTO husNT1971_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","U c’uajat muthatchic a Simón Pedro, a Tomás axi uxnal ti cuaya’cua’, a Natanael axi ti Caná cuentalith Galilea, nana’ in Juan ani u ebchal, ani tsabaye i at exobal jaye. ");
INSERT INTO husNT1971_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","A Simón Pedro tu ucha’chic: ―Ne’ets tin calthom to’ol. Ani huahua’ i ulu: ―U ne’etshue c’al tata’. U c’alechic ani u otsits al an tan. Ta u ne’ets ani patal an acal ma ni jun i to’ol yab i caltha’. ");
INSERT INTO husNT1971_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Exomits ti tajc’anal, ani c’uajatits a Jesús tin hualte’lil am pulic lejem. Yab i exla’ max ja’its a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Tam tu ucha’chic: ―¿Cuitolchic, yabaye a calthamal an to’ol? I toc’tsiy: ―Iba. ");
INSERT INTO husNT1971_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Tam a Jesús tu ucha’chic: ―Ca pet’na’ an thachumtalab tin huinab an tan, ani tats ne’ets ca elcanchi. I pet’na’chic jant’ini’ tu uchan, ani taley talbel yab i ejtouchic qui caltha’ an thachumtalab c’al xi yantalam to’ol balnenec. ");
INSERT INTO husNT1971_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Tam nana’ tin lej ichich hual exobalil a Jesús u ucha’ a Pedro: ―Ja’its an Ajatic. Expith in ats’a’ Simón Pedro abal ja’its an Ajatic, ani thubat in ca’iy in coton. Im pet’na’ tim ba’ al an ja’, ani ta c’ale quin tsu’u a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","An tan c’uajat jelat bo’ inic i metro abal ca ts’at’ey tin hualte’lil am pulic lejem. Ani huahua’ ax u jilc’on al an tan i bothcom an thachumtalab t’uchat c’al i to’ol. Taley u ulitsitschic tin hualte’lil am pulic lejem. ");
INSERT INTO husNT1971_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Tam tu calejits al an tan i tsu’uchic hua’ats i c’alul c’amal ba’ an tsabal. Pelc’ath jun i huiynel to’ol eblim al an c’amal. I tsu’u hua’ats jaye i pan. ");
INSERT INTO husNT1971_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","A Jesús tu ucha’chic: ―Ca chi’tha’chic tsab ox i to’ol ax a calthamal talel. ");
INSERT INTO husNT1971_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Tam otsits a Simón Pedro al an tan quin chi’tha’ quininil an thachumtalab t’uchat c’al hualim i pactha’ to’ol ma tin hualte’lil am pulic lejem. Hua’ats lajuj bo’ i lajujchic c’al ox i pactha’ to’ol. Aba ani’ lej c’athpich yan an to’ol, yab t’apts’in an thachumtalab. ");
INSERT INTO husNT1971_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Tam a Jesús tu ucha’chic: ―Quit chich cu c’aputs. Cum i lej tsalpay abal ja’its an Ajatic, ni junchic yab i conoy a Jesús max chubax ja’its. ");
INSERT INTO husNT1971_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Utey ani im pena’ am pan ani an huiyath to’ol, ani tu pitha’ cu c’apu. ");
INSERT INTO husNT1971_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","C’al axe’ jats in oxchil ti tejhua’mel a Jesús c’al huahua’ tu exobalilchic ma ti ejthamejits ti al an jolimtalab. ");
INSERT INTO husNT1971_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Tam tu c’aputschic, conoyat a Simón Pedro c’al a Jesús: ―¿Simón ti tsacamil a Jonás, it lej c’athpich c’anithom c’al nana’ ani yab ejtil axi q’ue’at u exobalilchic? Toc’tsin a Pedro: ―Ojni’ Ajatic, a tso’obits abal nan tu c’anithal. Uchan c’al a Jesús: ―Tam ca pijchi c’al in cahuintal a Dios axi pel u c’al ani pel ejtil i corderochic. ");
INSERT INTO husNT1971_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Conoyat junil a Pedro c’al a Jesús: ―¿Simón ti tsacamil a Jonás, it lej c’anithom c’al nana’? Toc’tsin a Pedro: ―Ojni’ Ajatic, a tso’obits abal nan tu c’anithal. Uchan c’al a Jesús: ―Tam ca alhua’ beletna’ axi pel u c’al ani pel ejtil i ovejachic. ");
INSERT INTO husNT1971_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Tin oxchil i calat conoyat a Pedro: ―¿Simón ti tsacamil a Jonás, it c’anithom c’al nana’? Cum antsana’ ti conoyat a Pedro tin oxchil i calat max c’anithom c’al a Jesús, tam lej t’e’pith. In ucha’: ―Ajatic, tata’ tin lej tala’ exlanchalits u ichich abal nan tu c’anithal. Uchan c’al a Jesús: ―Tam ca pijchi c’al in cahuintal a Dios axi pel u c’al ani pel ejtil i ovejachic. ");
INSERT INTO husNT1971_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Lej chubax nan tu uchal abal tam pelac it cuitole it toltomin ta ba’ ani it xe’tsinenec ju’tamits a le’namal. Tam quit yejtselbejits, ne’ets ca q’uet’a’ a ocob ani q’ue’at ne’ets ti toltomiy. Ne’ets tam quit ne’tha jun ti yab ca le’na’. ");
INSERT INTO husNT1971_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","C’al axe’ xi cau a Jesús in olna’ jant’ini’ ti ne’ets ca tsemets a Pedro. Antsana’ ne’ets ca puhuethanchat im bij a Dios. Taley a Jesús in ucha’ a Pedro: ―Xo’ tiquin ayna’. ");
INSERT INTO husNT1971_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Tam ti huenc’on a Pedro in tsu’u ts’at’at an exobal axi lej ichich hual tsu’tab c’al a Jesús. Jats xe’ c’al ti conoyame ti jayq’ui’ a Jesús abal jita’ c’al ti ne’ets ca tsinat bina tin c’ubac in tomolnaxilchic. Antsana’ ti conoyat Jesús c’al jaja’ tam ti c’uajatac tin ts’oylim ti c’apul. ");
INSERT INTO husNT1971_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Tam tin tsu’uhuits a Pedro ts’at’at antsana’ nixe’ xi exobal, tam in conoy a Pedro a Jesús: ―¿Ani Ajatic, axe’ xa exobalil jant’o ne’ets ca t’ajchin hualam? ");
INSERT INTO husNT1971_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Toc’tsin a Jesús: ―Yab a cuenta max nan cu le’na’ ca xe’tsin ejat jaja’ ma quin huichiy. Tata’ expith a cuenta tiquin ts’at’enchi. ");
INSERT INTO husNT1971_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Tam c’al an ebchalabchic lej athithil t’iloxnab nixe’ xi cau, cum tsalpayab abal a Jesús in ulu yab ne’ets ca tsemets nixe’ xi jun i exobal. Ani yab antsana’ in ulu, tocat in ulu abal yab pel in cuenta a Pedro max a Jesús quin le’na’ abal ca xe’tsin ejat nixe’ xi exobal ma ta ca huichiy jaja’. ");
INSERT INTO husNT1971_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Nana’its ja nixe’ xi exobal. U tsu’umal ani u olnal al axe’ xi u abal lej chubax jahua’ in t’ajamal ani jahua’ in ulumal a Jesús teje’ tsabal. A tso’obits abal lej chubax jahua’ u olnal. ");
INSERT INTO husNT1971_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Max ca tala’ olna in t’ajbilchic a Jesús ti junchic ti junchic ani ca thuchan al i u, hualam yab ne’ets ca lejey xi c’athpich yantalam i thuchath u ma tim puhuel an tsabal. Amén.");
INSERT INTO husNT1971_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","C’an Teófilo, nana’ in Lucas tu thuchanchamalits an oc’ox u yan i cau tin cuenta jahua’ a Jesús in t’ajamal ani in exobchamal. Tu olchamalits yantalam in t’ajbil ani in exobchixtal ma tam ti ts’i’quinenequits ti t’ojnal ani ti exobchix. ");
INSERT INTO husNT1971_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Xe’etsac ti t’ojnal ani ti exobchix ma tam ti c’athiyits ti eb. Junax c’al an Espíritu Santo in exobchichiquiyamal in abathualejilchic jant’ini’ ta ca t’ojon ani jant’ini’ ta ca xe’tsin. Pel i inicchic axi tacuyame c’al a Jesús ti abathuale. ");
INSERT INTO husNT1971_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Nan tu olchamalits abal lej yajchiquiyat ma tsemtha a Jesús, ani talbel ejthachits ani tejhua’menequits junil c’al in abathualejilchic. Tsab inic a q’uicha ti xe’etsac tam ti ejthachits quin tejhua’metha’ tim ba’ c’al in t’ajbil abal lej chubax ejthachits. Exome in exobchal in abathualejilchic jant’ini’ tin t’ajal a Dios ti lej Ts’ale. ");
INSERT INTO husNT1971_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Uchamejits an abathualechic c’al a Jesús tam ti yabaye tsemthach antse’: ―Nan tu olchamalits abal u Tata ti eb im bijchith ulumalits abal ne’ets ti abchichic an Espíritu Santo. Jaxtam ca aychichic ti Jerusalén ma tam ti abchits. ");
INSERT INTO husNT1971_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","A Juan im pujayamal an inicchic c’al i ja’, ani u Tata ti eb ti jun tsab ox a q’uicha ne’ets ti pujaychic c’al an Espíritu Santo. ");
INSERT INTO husNT1971_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Jun a q’uicha tam ti tamcuth an abathualechic uchan a Jesús c’al jaja’chic: ―Ajatic, tucu ucha’ max xohue’ im bajumalits an q’uij abal tata’ ca t’aja’ tit lej Ts’ale c’al huahua’ tu Israel ani yabats cu abatna c’al i pil inic. ");
INSERT INTO husNT1971_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Toc’tsin a Jesús: ―Yab it pithnal ca tso’obna’chic an q’uij antsana’. Expith u Tata ti eb jats in cua’al in tsalap quim bijiy an q’uijlab jant’inits quin le’nanchi jaja’. ");
INSERT INTO husNT1971_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Expith ca tso’obna’chic abal hue’its ne’ets ca chich an Espíritu Santo ti c’uajchiy ta ichich. Ne’ets ti tsaplilinchi a ichich abal tiquin olnanchi u bij ti bichou Jerusalén, ani tim puhuel an tsabal Judea, ani tim puhuel an tsabal Samaria, ani ma tim puhuel an tsabal. ");
INSERT INTO husNT1971_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Taley tam tin ucha’its antsana’ an cau in abathualejilchic, tameq’ui ti tsu’tat ne’ets c’athithilits a Jesús ti eb. Hue’ talbel tam ti paxq’uiq’uiyats c’al i tocou ani yabats u tsu’tab. ");
INSERT INTO husNT1971_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Biyat met’ot’ol an abathualechic ti eb, chich c’al jaja’chic tsab i ángel thac toltomith. ");
INSERT INTO husNT1971_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Uchanchic: ―Galileajibchic, yabats quit met’ot’lats ti eb. Jant’ini’ a tsu’uchic c’athithil a Jesús ti eb, antsana’ ne’ets ca huichiy pa’i’il ti eb. ");
INSERT INTO husNT1971_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Taley tixc’an in abathualejilchic a Jesús ti bolchal Olivos ani huichiy ti Jerusalén. Ma am bolchal Olivos ani ma ti bichou Jerusalén jelat jun i kilómetro. ");
INSERT INTO husNT1971_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ulitschic al jun i ata ti Jerusalén, ani tats ti c’athiy tin tsabchil i piso al i alta ax in c’uajchiyalchic. C’uajatchic a Pedro, ani a Jacobo, ani a Juan, ani a Andrés, ani a Felipe, ani a Tomás, ani a Bartolomé, ani a Mateo, ani a Jacobo ax pel in tsacamil a Alfeo, ani a Simón axi pelac i cananista, ani a Judas in ebchal a Jacobo. ");
INSERT INTO husNT1971_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Taja’ c’uajatchic jaye a Maria in mim a Jesús ani in ebchalchic a Jesús ani talchic i uxum. Ne’ets ca junax olonchic, cum antsana’ ets’ey in ujnamits quin t’aja’. ");
INSERT INTO husNT1971_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Hua’ats jelat acac i jun inic i ebchalab tamcuthits al nixe’ xi alta. Tam cubiy a Pedro in ucha’chic: ");
INSERT INTO husNT1971_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","―Ebchalabchic, ma ti biyalits a David in thucha’ jahua’ olchin c’al an Espíritu Santo abal a Judas ne’ets quin tsinat bina’ a Jesús c’al an yac’ualchic. Ani xo’ putnenequits an T’ocat Thuchlab jahua’ antsana’ in ulumal. ");
INSERT INTO husNT1971_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Pelac i at t’ojnal huahua’ a Judas tin t’ojlabil an Ajatic. ");
INSERT INTO husNT1971_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Jats jaja’ in tsinat bina’ a Jesús, ani an tumin ax im bats’u c’al in quithab t’ajbil in eyentha’ quin ts’a’iy i tsabal. Talbel tam tim palamalits in nuc’ ba’ an te’, tam ti ijcanits tsabal bic’lath in oc’. Pichc’an in chucul ma tala’ huac’lan in t’ithith. ");
INSERT INTO husNT1971_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Cum an c’uajilomchic ti Jerusalén in exla’its abal a Judas in ts’a’iy nixe’ xi tsabal c’al an tumin ax im bats’u c’al in quithab t’ajbil, jaxtam im bijiy nixe’ xi tsabal ti Acéldama. Ti tenec cau in le’ quin ulu ti xits’ tsabal. ");
INSERT INTO husNT1971_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Ani q’uejab thuchath a Judas ti al i salmo antse’: Ne’ets ca jilc’on jolat in atajil. Ni jita’ yab quin c’uajchiy. Thuchath jaye al q’ue’at i salmo: Ne’ets ca calchinchat in t’ojlabil c’al q’ue’at i inic. ");
INSERT INTO husNT1971_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Jaxtam xohue’ ca calchinchat in t’ojlabil a Judas c’al jita’ axi teje’ c’uajatchic. In ejtohual quin calchinchi jitats ts’at’enequits c’al huahua’ ma tam ti a Jesús tu tacuyamalits tu abathualejilchic. ");
INSERT INTO husNT1971_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Max ts’at’enequits ma tam ti pujnenec a Jesús c’al a Juan ani ma ti c’athiyits ti eb, jats qui tacuy ti calchix. Jats tucu tolmiy tu olnom abal ejthachits a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Taley bijiyat tsab, jun ax im bij José Barsabás ax in cua’al im punc’uth bij Justo, ani jun ax im bij Matías. ");
INSERT INTO husNT1971_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Tam ol an ebchalabchic. In uluchic: ―Dios, expith tata’ a exlanchalits tim patal in ichich an inic. Tucu tejhua’methanchi jahua’ axe’ xi tsab ax a tacuyamalits ti calchix c’al a Judas. ");
INSERT INTO husNT1971_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Jats ca punuhuat ti abathuale quin calchinchi in t’ojlabil ax in q’uiba’ tin ebal in hualab. In q’uiba’ ani c’alets ti tamtsemla tin ebal im pojcax ey. ");
INSERT INTO husNT1971_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Tam an ebchalabchic in calthanchi an q’uijlab axi tsab abal jahua’ axi ne’ets quim baju. Tam tejhua’mejits a Matías ojni’ jats ne’ets ti calchix c’al in t’ojlabil a Judas. Ani ma tamna’its jaja’ ti punuthits ti abathuale c’al axi lajuj jun in abathualejilchic a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Im bajuhuits in ajib am bichou Israel ax u uxnal ti Pentecostés, ani tam al nixe’ xi ata tamcuthits patal in abathualejilchic a Jesús c’al i ebchalabchic. ");
INSERT INTO husNT1971_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Jun jic’tohual in ats’alchic tal jun i cahuithtalab ti eb ejtil i tsapic ic’ axi lej tumumul. U ats’nal tim puhuel an ata jun ti jaja’ quetechic. ");
INSERT INTO husNT1971_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Tam in tsu’talchic tin junchictal tin oc’ ejtil in inquith i lec’ablec joc’pathits c’al i c’amal. ");
INSERT INTO husNT1971_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ani ma tamna’its tim patal jaja’chic jum putat co’onchithits in ichich c’al an Espíritu Santo. Ani in ts’i’quiychic quin cauna’ i pil cahuintalab jahuats pithnenec c’al an Espíritu Santo quin cauna’. Yab ja in cuete’ cahuintal. ");
INSERT INTO husNT1971_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Tam ti nixe’ xa q’uicha c’uajat ti Jerusalén i Israelchic ax in lej aynal an ts’ejcath cau binath c’al a Moisés. Che’necchic taja’ ma tim puhuel an tsabal. ");
INSERT INTO husNT1971_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ani tamcun jaja’chic jaye tam tin ats’a’ nixe’ xi cahuithtalab tal ti eb. Uc’pinchabchic in tsalap cum in ats’alchic caunanchab in cuete’ cahuintal c’al axi yab pel in at juntal. ");
INSERT INTO husNT1971_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Jilc’on lej jic’paxchic. In ulu jun c’al axi jun: ―Patal jaja’chic ax u caunanchix pel i Galileajib ani yab i at juntal. ");
INSERT INTO husNT1971_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Jant’ini’ in ejtohualchic tucu caunanchi i cahuintal huahua’ ax i caunamal ma ti tsacamtal? ");
INSERT INTO husNT1971_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Hua’ats jita’chic teje’ che’nec ma ti Partia, ani ma ti Media, ani ma ti Elam, ani ma ti Mesopotamia, ani ma ti Judea, ani ma ti Capadocia, ani ma ti Ponto, ani ma ti Asia. ");
INSERT INTO husNT1971_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Hua’ats jaye axi che’necchic ma ti Frigia, ani ma ti Panfilia, ani ma ti Egipto, ani ma ti Africa jum poq’ue’ ti Cirene. Jaye hua’ats axi che’necchic ma ti Roma ax in cua’alits in q’uima’ teje’ ti Jerusalén. Talchic xe’ jaja’ ax in t’ajtal ey pel i Israel ani talchic axi huenc’onenequits ti Israel quin ayna’ an ts’ejcath cau binath c’al a Moisés. ");
INSERT INTO husNT1971_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Jaye hua’ats teje’ axi che’necchic ma ti Creta ani ma ti Arabia. Patal huahua’ teje’ c’uajat u lej tamculam. I ats’al ti cuete’ cahuintal u t’ilchab in jic’path t’ajbilchic a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Jat’hua’ tim patal an tamcunel in lej jic’pal ani u uc’pinchab in tsalap. In conoyal: ―¿Jant’o in ey axe’ xi inicchic abal antsana’ u caunanchix c’al i cuete’ cahuintal huahua’? ");
INSERT INTO husNT1971_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Expith talchic ax u tilibnax toc’tsin antse’: ―Cum u uts’alits jaxtam u caunanchix c’al i cuete’ cahuintal. ");
INSERT INTO husNT1971_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Taley cubiy a Pedro c’al axi lajuj jun in abathualejil a Jesús tin tamet an tamcunel. In thajat ulu: ―At Israelchic ani c’al patal ax it c’uajil ti Jerusalén, ca lej alhua’ bina’ a xutsun ani ca lej alhua’ exbay jahua’ ne’ets tu ucha’chic. ");
INSERT INTO husNT1971_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Yab chubax u uts’al axe’ xi caunanchixchic jant’ini’ tata’ a ulalchic. Yabaye jant’ini’ ta ca uts’alin cum expith pel i beleu hora an thaju. ");
INSERT INTO husNT1971_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Lej inic tu caunanchixchic. Xo’ u putnalits jahua’ ti biyal an caulome c’al a Dios Joel in thucha’ jahua’ in ulu a Dios antse’: ");
INSERT INTO husNT1971_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Tam c’unelits an q’uij q’uicha ne’ets ca taley, tamna’ nan ne’ets cu abchi an Espíritu Santo patal an inicchic. An cuitolchic ani an ts’ic’ach ne’ets tiquin caunanchi u cahuintal. Ne’ets cu tsu’binchi an c’uitolchic i tsu’bixtalab ejtil tam u huachbil. Ani ne’ets cu tejhua’methanchi jant’o an yejtselchic tam u huayal ani u huachbil. ");
INSERT INTO husNT1971_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Tam nihua’aquits a q’uicha ne’ets cu abchi an Espíritu Santo u t’ojnalilchic i inic ani i uxum. Ani jaja’chic ne’ets tiquin caunanchi jahua’ nan cu pitha’ quin cauna’. ");
INSERT INTO husNT1971_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ti eb ne’ets cu t’aja’ i lej jic’path t’ajbilab. Ti tsabal ne’ets cu tejhua’methanchi an inicchic u tsap c’al i pulic tsu’bixtalab. Ne’ets cu tejhua’methanchi c’al i xits’, ani c’al i c’amal, ani c’al i pau. ");
INSERT INTO husNT1971_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ne’ets ca yic’utsin a q’uicha. A its’ ne’ets ca huenc’on ejtil i xits’. Antsana’ ne’ets ca t’ajan tam c’unatits ne’ets ca chich an Ajatic. Tam ojni’ al nixe’ xa q’uicha ne’ets quin tejhua’metha’ in lej tsap ani in lej ts’alat. ");
INSERT INTO husNT1971_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ani patal jitats quim palenchi an Ajatic jats ne’ets ca jaluntha tam. Antsana’ a Joel in thucha’ jahua’ in ulu a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Cahue a Pedro in ulu: At Israelchic, ca lej alhua’ japiy a xutsun ca ats’a’ jahua’ nan ne’ets tu ucha’chic tin cuenta a Jesús Nazaretib. C’al im pulic t’ajbilchic tejhua’ abal tacuthits ani abathits c’al a Dios. A Dios ani a Jesús in mac’uchith t’ajamal ta tametchic i jic’path labith t’ajbilab ti tsu’bixtalab c’al in ey. Tata’chic a lej alhua’ tso’obits abal lej chubax anits. ");
INSERT INTO husNT1971_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Aba ani’ antsana’ a tso’obnamalits, bel a bats’uchic a Jesús tam ti a Judas in tsinat bina’ ta c’ubac. A ne’tha’ ani a bina’ tin c’ubac i pojcax inicchic ca q’uet’ath tsemtha ti al an cruz, cum antsana’ q’uejab tsalpanchamejits c’al a Dios ca t’ajchin jant’inits im bijith le’nomtalits a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Aba ani’ tsemtha, a Dios bel in ejtha’. Yab in jila’ ca ohuat co’oyat c’al in tsap an tsemla, cum ni abal jay yab ejtohuat ca lej atan c’al an tsemla. ");
INSERT INTO husNT1971_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Jaxtam an ts’ale David ti biyal in olna’ i cau tin cuenta abal ne’ets ca ejtha a Jesús. Ejtil max a Jesús ax in taunamal a Dios. In ulu antse’: Dios, u exlal abal ets’ey it c’uajat utat c’al nana’. Jaxtam ni jita’ yab in ejtohual tiquin t’e’pinthanchi u ichich. ");
INSERT INTO husNT1971_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Jaxtam jum putat culbel u ichich ani c’al u hui’ tu puhuethanchal a bij. Quin tsemets ne’ets quin coyots c’al u ichich thacat, cum tata’ ne’ets tiquin ejtha’ junil. ");
INSERT INTO husNT1971_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Tata’ Dios, yab ne’ets tiquin ohuat jilchi u ejattal quin co’onchat c’al an tsemla. Cum nana’ pel tin T’ocat Tsacamil yab ne’ets tiquin jilchi ca c’atsey u inictal. ");
INSERT INTO husNT1971_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Tata’ Dios, tin tejhua’methanchi jant’ini’ quin ets’ey c’uajiy c’al tata’. In jum putat culbel cum ne’ets tu tsu’chi a hual abal ets’ey. Antsana’ a Pedro in olna’ jant’o in ulu a David tin cuenta in ejthachtal a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Cahue a Pedro in ulu: At juntalabchic, ne’ets tu lejquith ucha’ jun i cau. I biyal juntal David lej chubax tsemets ani joliyat, ani ma xohue’its bel i ejtohual qui tsu’chi in jolimtal. ");
INSERT INTO husNT1971_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","A David pelac i caulome c’al a Dios. In alhua’ exla’ abal c’al ja in xits’al ne’ets ca hua’tsin a Cristo, ani ne’ets ca punuhuat ti Ts’ale ejtil jaja’. Antsana’ a Dios tim bijchith ulumalits ani in cuba’ tim ba’ abal chubax ne’ets ca t’ajan. ");
INSERT INTO husNT1971_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Jaxtam a David in q’uejab exla’ ani in q’uejab olna’ abal ne’ets ca ejtha a Cristo. In ulu abal a Dios yab ne’ets quin jilchi in ejattal ca co’onchat c’al an tsemla ani in inictal yab ne’ets ca c’atsey. ");
INSERT INTO husNT1971_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ani chubax a Dios in ejtha’ a Jesús. Patal huahua’ i tsu’umal ejthachits ani i olnal abal anits. ");
INSERT INTO husNT1971_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Xo’ punuthits tin huinab c’ubac a Dios jant’ini’ ti puhuethanchithits im bij. Ma tihua’ ti eb a Jesús tu abchamalits an Espíritu Santo jant’ini’ ti bijchith uchan c’al in Tata tucu abchi. Patal jahua’ talel a tsu’umalitschic ani a ats’amalitschic jats pel in t’ojlabil an Espíritu Santo. ");
INSERT INTO husNT1971_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Aba ani’ yab c’athiy a David ti eb, bel in exla’ abal tihua’ c’uajat ti eb an Ajatic. In olna’ jant’o uchan an Ajatic c’al a Dios antse’: Quit buxcan tu huinab c’ubac. ");
INSERT INTO husNT1971_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Teje’ quit buxcan ma nan tu pitha’ ta c’ubac a tomolnaxilchic abal ca tala’ ata’. ");
INSERT INTO husNT1971_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Ja’its nixe’ a Jesús ax a q’uet’ath tsemtha’chic al an cruz. Xo’ patal tata’chic ax it Israel in tomnal ca alhua’ tso’obna’ abal lej chubax a Dios im punumalits ti eb ti lej Ajatic ani ti lej Ts’ale c’al patal an inicchic, in ulu a Pedro. ");
INSERT INTO husNT1971_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Tam tin ats’a’itschic antsana’ an cau, tamna’ lej c’athpich yajchiquithits in ichich in ats’alchic c’al an lej tsapic t’e’pintalab. Ani jaja’chic in lej ucha’ a Pedro ani axi q’ue’at an abathualechic antse’: ―At juntalabchic, tucu ucha’ jant’o i uchbil qui t’aja’ xo’. ");
INSERT INTO husNT1971_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","A Pedro in toc’tsiychic: ―Quit t’ajat jic’tsonchic c’al a hualab ani quit pujanchic tim bij a Jesucristo abal quit paculanchat a hualab. Tam a Dios ne’ets ti abchichic an Espíritu Santo ca c’uajiy ta ichich. ");
INSERT INTO husNT1971_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Im bijchith ulumalits a Dios abal ne’ets ti abchi, ani yab expith tata’chic, jaye a tsacamilchic. Ma ne’ets ca abchinchic jaye axi al pil i bichoulomchic patal jitats tacuthits c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","C’al yane i cau a Pedro in exobchal an mulcunel. Taley tin lej taltal an cau in ucha’: ―Ca bina’ ta ba’chic quit jec’ontha c’al a Dios, ani yabats quit xe’tsin q’uibenec ejtil xi q’ue’at i inicchic. ");
INSERT INTO husNT1971_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Taley u pujnalchic patal ax in lej penamalits tin ichich jahua’ uchan c’al a Pedro. Jelat ox i mil i inic jats axi huenc’onenec quim bela’ a Jesús nixe’ xa q’uicha. ");
INSERT INTO husNT1971_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ani patalchic in junini’ aynanchal jahua’ tu exobchinal c’al an abathualechic. Lej jun ejetchic in ichich c’al in t’ilomtal an Ajatic. Yab im palc’anchalchic ti ol ani quin t’aja’ an santa cena. ");
INSERT INTO husNT1971_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ani patal nixe’ xi it belomchic c’al an Ajatic in lej c’ac’nanchal im bij, cum in tsu’tal an abathualechic in t’ajal i labith t’ajbilab ti tsu’bixtalab c’al im bij an Ajatic. ");
INSERT INTO husNT1971_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Lej juncuthchic in ichich ani lej ts’ejhualix c’al jahua’ in cua’alchic ejtil max pel i they c’alab. ");
INSERT INTO husNT1971_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","In tala’ nujuhualchic jahua’ in cua’al, ani buc’tsixnanchab an tumin jant’inits i yejenchixtalab in tsu’tal in cua’al ti junchic. ");
INSERT INTO husNT1971_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Chuthel chuthel u tamcunalchic ti c’ac’nax c’al a Dios ti al an tiyopan. Tin q’uima’chic in t’ajalchic an santa cena ani junax c’apul c’al in ichich lej culbel ani tsa’at. ");
INSERT INTO husNT1971_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","In junini’ puhuehuenchalchic im bij a Dios. Ani jat’hua’ c’al patal am bichou u tsu’tab ti alhua’ inic. Chuthel chuthel hua’ats ax u it huenc’onal c’al an Ajatic, ani antsana’ ne’ets puhuehuel im bichohuil a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Jun a q’uicha ox hora an huacal a Pedro ani a Juan ne’ets junaxchic ti tiyopan. Pel i hora tam an Israelchic in ujnam ca olon taja’. ");
INSERT INTO husNT1971_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Chuthel chuthel u chi’thab ca c’uajba utat tin hui’lebil nixe’ xi tiyopan jun i inic axi tsambe in acan ma tin hua’tsintal. Im bij nixe’ xi hui’leb ti Alabel. Tats ti conchix an tsambe c’al an tumin c’al jitats ca otsits ti al an tiyopan. ");
INSERT INTO husNT1971_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ulitschic a Pedro ani a Juan tin hui’lebil an tiyopan ani conchab an tumin. ");
INSERT INTO husNT1971_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Tam lej met’nal c’al a Pedro ani c’al a Juan, ani uchan c’al a Pedro: ―Tucu met’a’ te huahua’. ");
INSERT INTO husNT1971_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Tam an tsambe in lej met’a’chic, cum in tsalpayal hualam ne’ets ca pithan jant’o. ");
INSERT INTO husNT1971_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ani iba. Tocat uchan c’al a Pedro: ―Nan yab u cua’al i tumin ma ni jant’o. Expith jahua’ im pithnenec c’al an Ajatic jats ne’ets tu pitha’. C’al in tsap im bij a Jesucristo Nazaretib quit ts’aquiy ani quit belats. ");
INSERT INTO husNT1971_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Tam a Pedro in yac’uchi in huinab c’ubac ani in ts’acba’. Ani tameq’ui jeleyits in acan ma c’al patal im puthic’. ");
INSERT INTO husNT1971_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Tam jun athic t’ic’ts’onits ani in ts’i’quiy ti belal. Otsits t’ic’ts’ots’ol c’al a Pedro ani c’al a Juan ti al an tiyopan. Hualim im binal i c’ac’namal yan c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Patal an inicchic taja’ in tsu’tal ti belal ani ti puhuethanchix c’al im bij a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","In lej jic’palchic ani u hue’ jiq’uel jant’ini’ ti thubat jelthanchat in acan nixe’ xi inic. In exlalitschic abal ja’its jaja’ axi ets’ey quetelac ti conchix c’al i tumin utat tin hui’lebil an tiyopan. Im bij nixe’ xi hui’leb ti Alabel. ");
INSERT INTO husNT1971_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ti al nixe’ xi tiyopan hua’ats i hueu cucu’lab im bij ti Salomón. Tats ti c’uajat a Pedro lej c’unat ts’at’enchat c’al nixe’ xi tsambejac. Lej jic’pachiquix patal an inicchic c’al nixe’ xi pulic t’ajbilab, chich athithil quin tsu’u axi jelthanchat in acan. ");
INSERT INTO husNT1971_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Tam a Pedro in tsu’u lej pulic an mulcunel ani in ucha’: ―¿At Israelchic, jale’ hualam it lej jic’pachiquix? Hualam tin lej telal nana’ ani c’al a Juan cum a tsalpayalchic huahua’ i jelthamal axe’ xi inic c’al i cuete’ tsap. Hualam a tsalpayalchic abal huahua’ u c’athpich t’ocat ani jats tu jelthom. Iba. ");
INSERT INTO husNT1971_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","C’al in tsap a Jesús jats ti jelthach axe’ xi inic, ani antsana’ tejhua’ abal a Dios im puhuethanchamalits ti eb im bij in Tsacamil Jesús. Ja’its a Dios axi pel in Diosil a Abraham ani a Jacob ani a Isaac. Ja’its a Jesús axi tata’chic a bina’ tin c’ubac an oc’lecchic. Ani tam ti Pilato in le’na’ quin hualca’, tata’chic ojni’ yab a le’na’. ");
INSERT INTO husNT1971_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Tocat a thajat ucha’chic quin hualca’ jun i tsemthom inic. In tomnal max hualcamejac a Jesús axi lej t’ocat inic ani lej pututh inic. ");
INSERT INTO husNT1971_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","A bina’chic ca tsemtha a Jesús axi lej ejatlix expith. Aba ani’ tsemtha, bel a Dios in ejtha’ ti al an jolimtalab, ani huahua’ i tsu’umal ejthachits. ");
INSERT INTO husNT1971_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","C’al tin ebal in tsap im bij a Jesús jats ti jelthanchat in acan axe’ xi inic. Cum in lej bela’ a Jesús, jaxtam ti jum putat jelthamejits. A tsu’talitschic ani a exlalits abal lej chubax anits. ");
INSERT INTO husNT1971_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","At juntalabchic, nan u tso’obits abal yab a tequeth exlanchi in ey max pel in Tsacamil a Dios tam ta bina’ a Jesús ca tsemtha. Aniye jaye a oc’lequilchic yab in tequeth exlanchi in ey. ");
INSERT INTO husNT1971_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Bel cum yajchiquiyat jats ti putnenec in cahuintal a Dios. Cum a Dios in q’uejab olnamalits c’al in caulomejilchic abal ne’ets quin aba’ a Cristo, ani pel in uchbil ca lej yajchiquiyat. ");
INSERT INTO husNT1971_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Jaxtam xohue’ quit jic’tsonchic c’al a hualab ani quit huichiy c’al a Dios, abal jaja’ ti paculanchi a hualab. Tam ojni’ a Dios ne’ets ti lubach co’onchichic a ichich. ");
INSERT INTO husNT1971_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Ani talbel ne’ets quin aba’ a Jesucristo ca huichiy junil teje’ tsabal ta lej Ts’alejil. Ma ti lej jayq’ui’ antsana ti bijchamejits in ey c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Xo’ pel in uchbil a Jesucristo ca jilc’on tihua’ ti eb, ma tam quim bajuhuits am pejath q’uij tam ti a Dios ne’ets quin tala’ alhua’metha’ patal teje’ tsabal jant’ini’ ti c’a’al alhua’ac. A Dios in q’uejab olnamalits c’al in t’ocat caulomejilchic axi biyal abal antsana’ ti ne’ets quin t’aja’. ");
INSERT INTO husNT1971_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","An caulome Moisés in ucha’chic i biyal juntalchic antse’: Am pulic Dios Pay’lom ne’ets ti abchichic jun i caulome axi pel a at juntal xits’al. Jant’ini’ a Dios tin abamal nana’ tin caulome, antsana’ axi junaque axi taye tal ca aban. Jats ca lej alhua’ bina’ a xutsunchic ca ats’anchi patal jahua’ ne’ets ti ucha’. ");
INSERT INTO husNT1971_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ne’ets ca t’ajat q’uibey patal jitats yab quin alhua’ ats’anchi nixe’ xi caulome, ani yabats ne’ets ca ajiyat ti Israel tim bichohuil a Dios. Antsana’ tin ulu a Moisés, in ulu a Pedro. ");
INSERT INTO husNT1971_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Tim patal an caulomechic ma tam tin q’uichajil a Samuel in q’uejab t’ilamal abal ne’ets ca t’ajan jahua’ xo’ i tsu’talits al axe’ xa q’uichachic u t’ajnal. ");
INSERT INTO husNT1971_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","A Dios im bijchith uchamalits am biyal caulomechic jant’o ne’ets quin t’aja’, ani in le’ abal tata’chicte ca tabatnanchi nixe’ xi bijchith cau. A Dios im pitha’ i biyal juntalchic i jilchith cau abal tata’chicte ca tabatnanchi. A Dios in ucha’ a Abraham antse’: Jun i inic axi pel a at juntal xits’al jats ne’ets quin lablinchi tim patal an inicchic tim puhuel an tsabal. ");
INSERT INTO husNT1971_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ani xo’ nan tu uchalchic abal ja’its jaja’ ax a Dios in ejthamalits in Tsacamil. Ja’its jaja’ ax a Dios xo’ tu oc’ox abchal huahua’ tu Israel abal tucu lablinchi ani tucu coythanchi jahua’ yab alhua’ i t’ajal. ");
INSERT INTO husNT1971_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Tam ti cahue a Pedro ani a Juan c’al an mulcunel, tam ti chich i pale’chic, ani c’al talchic i saduceo, ani c’al jun i inic ax pel i oc’lec c’al am beletnom tiyopanchic. ");
INSERT INTO husNT1971_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Tsacul jaja’chic, cum a Pedro ani a Juan in exobchal an inicchic abal ne’ets ca ejtha an tsemelomchic cum a Jesús ejthamejits. ");
INSERT INTO husNT1971_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","In yac’ua’chic a Pedro ani a Juan, ani im baliychic ti al an huic’axte’. Cum huaclejits ani yab ejtohuat ca t’ajan an ts’ejcaxtalab, jaxtam ti jilan al an huic’axte’ ma tin aytal q’uicha. ");
INSERT INTO husNT1971_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ani yantalam i inic ax in ats’anchi in cahuintal a Dios c’al a Pedro ani a Juan, im belchichic jaye. Tin yanel axi it im belal jelat bo’ i mil i ejattalab max qui ajiy expith an inicchic. ");
INSERT INTO husNT1971_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Tin aytal q’uicha tamcunchic ti Jerusalén axi oc’lecchic c’al an Israelchic, ani c’al i yejtselabchic Israel, ani c’al i exobchixchic c’al an tsejcath cau binath c’al a Moisés. ");
INSERT INTO husNT1971_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","C’uajat taja’ an ts’ale pale’ Anás. C’uajatchic jaye a Caifás, ani c’al a Juan, ani c’al a Alejandro, ani c’al tim patal axi pel in at ja’ub xits’al an ts’ale pale’. ");
INSERT INTO husNT1971_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Tam in aba’chic an cau ca chi’tha a Pedro ani a Juan tin tamet jaja’chic. Chi’thachic ani conoyat: ―¿Jita’ ti pithamalchic a eyaltal abal a t’ajamal tit jelthom c’al an tsambe? ¿C’al jita’ im bij ta jelthamal? ");
INSERT INTO husNT1971_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Tam a Pedro jum putat co’onchithits in ichich c’al an Espíritu Santo in toc’tsiychic: ―Oc’lecchic ani yejtselab Israel, tiquin lej ats’anchi. ");
INSERT INTO husNT1971_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Huahua’ i t’ajchamal i alhua’talab axe’ xi inic axi tsambejac, ani tata’ a conoyalchic jant’ini’ ti jelthame. ");
INSERT INTO husNT1971_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Nana’ ne’ets tu olchichic jant’ini’ ti jelthame abal tim patal an Israelchic quin alhua’ tso’obna’its. Axe’ xi jelthach inic ta tametchic jelthame c’al in tsap tim bij a Jesucristo Nazaretib. Jats a Jesucristo ax a bina’chic ca q’uet’ath tsemtha al an cruz, ani talbel ejtha c’al a Dios ti al an jolimtalab. ");
INSERT INTO husNT1971_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ejtil jun i thacum ata quim mo’ca’ pil jun i t’ujub axi yab in le’ quin eyentha’, antsana’ tata’chic a t’ajamal c’al a Jesús. Aba ani’ a pojcamal a Jesús, bel ja’its jaja’ axi xohue’ punuthits ejtil i mimlab t’ujub c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ja’its jaja’ expith an Jec’onthax axi hua’ats c’al an inicchic. Ni jita’ yab hua’ats q’ue’at teje’ tsabal bijith c’al a Dios abal tucu jec’ontha’. ");
INSERT INTO husNT1971_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","An oc’lecchic in t’aja’ ti cuenta abal a Pedro ani a Juan u cau c’al i lej inictalab. In tso’obna’itschic abal yab lej exoblamathits ani pel i alq’uith inicchic. Ani lej jic’paxchic. Tam in t’ila’its abal jats a Pedro ani a Juan axi xe’tsinenecchic junax c’al a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Cum in tsu’uchic cubatits an tsambe jelthathach, yab in ejtohual an oc’lecchic jant’ini’ ti quin jolbiy a Pedro ani a Juan. ");
INSERT INTO husNT1971_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Tam uchanchic ca tixc’an biyat jaja’chic ne’ets quin ts’ejca’ an cau. ");
INSERT INTO husNT1971_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Taley an oc’lecchic in ulu jun c’al xi jun: ―¿Jant’o i ejtohual qui t’aja’ c’al axe’ xi inicchic? C’al patal axi c’uajatchic teje’ ti Jerusalén u exlabits abal in t’ajchamal an tsambe i pulic labith t’ajbilab. Yab i ejtohual qui tsinc’onchi. ");
INSERT INTO husNT1971_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Expith qui c’uiya’chic abal yabats ca t’iloxna más in labith t’ajbil. Qui tsapic ucha’chic abal yabats quin olnanchi im bij a Jesús c’al jitaquitsq’ui tam inic. ");
INSERT INTO husNT1971_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Tam caniyat ca chich a Pedro ani a Juan ani c’uiyath uchanchic abal yabats quin más olnanchi im bij a Jesús ani yabats jita’ quin más exobchichiquiy tin cuenta a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Toc’tsin jaja’chic in ulu: ―Tata’ ojni’ inicchic ca lej alhua’ tsalpay jahua’ axi más i uchbil qui t’aja’. Qui t’ajchi más in culbetal a Dios o qui t’ajchi más a culbetal tata’chic. ");
INSERT INTO husNT1971_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ni abal jant’ini’ yab i ejtohual cu ts’ibc’an c’al jahua’ i tsu’umalits ani c’al jahua’ i ats’amalits c’al tin cuenta a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Taley tamna’ an oc’lecchic in c’uiya’ junil a Pedro ani a Juan, ani in jila’chic ca c’alets. Yab in elchichic jant’o c’al ti quin jolbiy ani quin yajchiquiy. Yab hua’ats i jolbix, cum patal am bichou im puhuethanchal im bij a Dios c’al jahua’ t’ajchinenec an tsambe. ");
INSERT INTO husNT1971_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","In cua’al an tsambe huat’ath tsab inic tamub tam ti t’ajchin nixe’ xi pulic labith t’ajbilab. ");
INSERT INTO husNT1971_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Tam ti jilan ca c’alets a Pedro ani a Juan, tam c’alechic quin tsa’biy in at belomchic. In tala’ t’ilchalchic jahua’ uchnenec c’al an oc’lec pale’chic ani c’al an yejtselab Israelchic. ");
INSERT INTO husNT1971_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Tam tin ats’a’itschic ani’, tamna’ patal olon jununul in conchixtal. In uluchic: ―Pulic Dios Pay’lom, tata’ a ts’ejcamal an eb, ani an tsabal, ani am pulic lejemchic, ani patal jahua’ hua’ats. ");
INSERT INTO husNT1971_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Tam ti biyalits a cahuintha’ a t’ojnalil David c’al an Espíritu Santo tam tin ulu antse’: ¿Jale’ u tsacul c’al a Dios an inicchic tim puhuel an tsabal? ¿Jale’ in tsalap an inicchic lej jolat jec’om c’al a Dios? ");
INSERT INTO husNT1971_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Patal an ts’alechic ani an oc’lecchic teje’ tsabal in lubal quin tamcuth tomolna’ a Dios ani a Cristo axi aban c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Ani lej chubax tamcunenecchic teje’ ti Jerusalén an ts’ale Herodes ani an ts’ale Poncio Pilato junax c’al i Israelchic ani c’al axi yab Israelchic, expith quin tamcuth tomolna’ a T’ocat Tsacamil Jesús. Ani ja’its a Jesús ax a punumalits ti lej Ts’ale c’al patal an inicchic. ");
INSERT INTO husNT1971_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ani patal jahua’ t’ajchinenec a Jesús c’al nixe’ xi tomolnaxchic, jats axi tata’ a q’uejab tsalpanchamalits ca t’ajchin jant’inits a le’nomtal. ");
INSERT INTO husNT1971_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ani xohue’ Dios, ca t’aja’ ti cuenta abal hua’ats i oc’lecchic ax tu c’uiyal huahua’. Cum pel tu t’ojnalil, tucu lej tsaplilichiquiye qui olnachiquinchiye a bij. Yab cu jiq’uey c’al in c’uiyaxtal. ");
INSERT INTO husNT1971_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","C’al a lej tsap ani c’al in tsap im bij a T’ocat Tsacamil Jesús ca jelthachiquiye i ya’ulchic. Ca t’ajaye i labith t’ajbilab ti tsu’bixtalab c’al an inicchic. ");
INSERT INTO husNT1971_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Tam ti talits ti olchic, tam t’elelel an ata jun ti tamcuthchic ti ol. Ani tam chich an Espíritu Santo in jum putat co’onchi in ichich patal axi tamcuth taja’. Ani taley tam xe’ets jaja’chic ti buc’ul c’al in cahuintal a Dios c’al in ichich lej tsaplilithits. ");
INSERT INTO husNT1971_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Jununul in tsalap ani in canat patal am belomchic. Ni jita’ yab in ulu max pel in cuete’ c’al jahua’ in cua’al. In tsalpayalchic abal patal jahua’ in cua’al ejtil max pel i they c’alab. ");
INSERT INTO husNT1971_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ani in abathualejilchic a Jesús c’al in lej tsap, xe’ets in olnachiquinchal an inic abal ejthachits an Ajatic Jesús. Lej tolminchab tim patal am belomchic c’al im pulic alhua’ inictal a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Tim patal am belomchic u pithnal jant’inits in yejenchixtal. Ax in cua’alchic i tsabal ani ax in cua’alchic i ata in nujujuyal, ani im binanchal an tumin tin c’ubac an abathualechic. ");
INSERT INTO husNT1971_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Taley jaja’chic im buc’tsixnanchal am belomchic jant’inits ti yejenchith. ");
INSERT INTO husNT1971_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Taja’ c’al an ebchalabchic hua’ats jun axi pel in at xits’al a Levi. Pel a José axi hua’tsin ti al an ts’aclath tsabal axi al am pulic lejem im bij Chipre. Im punchith bij c’al an abathualechic pel a Bernabé, axi ti tenec cau in le’ quin ulu culbethanchix c’al in ichich an inic. ");
INSERT INTO husNT1971_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","In nuju in tsabalil ani im binanchi an tumin tin c’ubac an abathualechic. ");
INSERT INTO husNT1971_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Hua’ats jaye jun i ebchalab im bij Ananías in nuju in tsabalil. In tomquil pel a Safira. ");
INSERT INTO husNT1971_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","In canchi hue’ an tumin c’al ax ti jalbinchat c’al an tsabal, ani axi más jats im binanchi tin c’ubac an abathualechic. In ucha’ abal ja’its tim patal an tumin axi jalbinchame. Expith in tomquil jats in tso’obna’ abal yab chubax. ");
INSERT INTO husNT1971_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Tam uchan a Ananías c’al a Pedro: ―Tata’ ojni’ a hualca’ ta ba’ ti otsanchi ta ichich a Satanás abal ti t’ajchi quit janamcahuin. It hualbinenec c’al an Espíritu Santo cum a canchi hue’ an tumin jahua’ tit jalbinchame. ");
INSERT INTO husNT1971_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Nixe’ xi tsabal pel a lej c’al tam ti yabaye a nujumal, ani tam tit jalbinchamejits tam nixe’ xi tumin pel a lej c’al. A ejtohuamalac ca eyentha’ jant’inits a culbetal, ani yab quit janamcahuin. Xo’ ojni’ it janamcahuinits c’al a Dios, ani yab expith c’al huahua’ it janamcaunenec. ");
INSERT INTO husNT1971_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Tam tin ats’a’its antsana’ a Ananías, tam t’ajat ijcan tsemenec. Ani lej jiq’uey patal jitats in tso’obna’ abal antsana’ ti tsemetsits jun jic’tohual. ");
INSERT INTO husNT1971_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Chich i cuitolchic ani in thu’banchi in inictal, in ne’tha’ quin joliy. ");
INSERT INTO husNT1971_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ox i hora talbel tam ti otsitsits in tomquil a Ananías. Yab in tso’bim max tsemenequits a Ananías. ");
INSERT INTO husNT1971_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Tam uchan c’al a Pedro: ―Tiquin ucha’ an chubaxtalab max jats antsana’ tin nujumal an tsabal a q’uimathil jant’ini’ tin olchamalits jaja’. Toc’tsin jaja’ in ulu: ―Ojni’ chubax ja’its antsana. ");
INSERT INTO husNT1971_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Tam uchan c’al a Pedro: ―¿Tata’ ojni’ jale’ a juncu an cau quit junax janamcahuin c’al a q’uimathil? It hualbinenecte c’al an Espíritu Santo. Te huichits an cuitolchic ax in ne’tha’ quin joliy a q’uimathil, ani tata’te ne’ets ti ne’tha’ quit jolin. ");
INSERT INTO husNT1971_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ani tameq’ui ti t’ajat ijcan tsemenec jaye a Safira tin acan a Pedro. Otsits alta an cuitolchic ani in tsu’u mo’ol tsemenequits. In caltha’ in ne’tha’chic jaye ani in joliy utat jun ti jolithits in q’uimathil Ananías. ");
INSERT INTO husNT1971_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ani jats ti lej jiq’uey patal im bichohuil a Dios ani patal jitats in tso’obna’ abal antsana’ t’ajat tsemetsits a Ananías ani a Safira. ");
INSERT INTO husNT1971_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","An abathualechic in t’ajale yan i labith t’ajbilab ti tsu’bixtalab c’al an inicchic. Ani taley tamcun c’al jaja’chic yantalam i belom tin hueu cucu’il an tiyopan. Im bij nixe’ xi hueu cucu’lab Salomón. ");
INSERT INTO husNT1971_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Patal pel i belom axi tamcuth, cum axi yab belom in ts’ejnal ca tamcun. Aba ani’ yab in inicnal tim ba’ ca tamcun c’al am belomchic, bel in lej c’ac’nalchic. ");
INSERT INTO husNT1971_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ani lej yanenel ne’ets am belom c’al an Ajatic, i inic ani i uxum. ");
INSERT INTO husNT1971_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","U chi’thachicab ti bel yan i ya’ul c’al i lactem ani q’ue’at c’al i tseyte’ tat, ani u mo’cab jun ti ne’ets ca huat’ey a Pedro. Lej lequitsq’ui max ca huat’ey a Pedro ani ca tsalamliyat, c’al ca t’ajat jeltha. ");
INSERT INTO husNT1971_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Taja’ ti Jerusalén u ulelel yantalam i inic axi tal al i bichouchic axi utat. In chi’thachicalchic i ya’ul ani axi co’oyab c’al i at’ax teneclab. Tim patal u jelthathayab c’al an abathualechic. ");
INSERT INTO husNT1971_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Taley lej pa’ixnanchab in tsap an abathualechic c’al an ts’ale pale’ ani c’al an cuenel saduceo axi ts’at’at c’al jaja’ an ts’ale pale’. ");
INSERT INTO husNT1971_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Jaxtam yac’uanchic ani baliyat al an huic’axte’. ");
INSERT INTO husNT1971_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ani taja a Dios in aba’ jun i ángel abal quin japchi in hui’lebil an huic’axte’ tam acal. In caltha’ an abathualechic ani in ucha’: ");
INSERT INTO husNT1971_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","―Quit c’alechic ti al an tiyopan ani ca olchi an inicchic jant’ini’ ta ca it ejatliyat c’al an Ajatic. ");
INSERT INTO husNT1971_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Tam tin ats’a’its antsana’ an abathualechic, tam c’alechic ani otsits ti al an tiyopan ti exobchix. Thajuhuits tamna’. C’uajate ti exobchix an abathualechic ti al an tiyopan, ani an ts’ale pale’ ani in tolmihualchic in tamcuy an yejtselabchic Israel axi pel i cuenel ts’ejcom cau axi lej c’athpich exbath in ey. Cum in tsalpayalchic abal c’uajate an abathualechic ti al an huic’axte’ in aba’ i ic’tom ca ic’tatchic. ");
INSERT INTO husNT1971_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Tam ti ulitschic an ic’tom tihua’ al an huic’axte’ yab jita’ hua’ats. Huichits jaja’chic c’al an cuenel ts’ejcom cau quin olchi yab jita’ hua’ats. ");
INSERT INTO husNT1971_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","In ucha’chic: ―I tsu’u tocat mapuputhits an huic’axte’ ani lej alhua’ beletnanath c’al i soldadochic. Tam tu japchatits an hui’leb, ni jita’ yab hua’ats. ");
INSERT INTO husNT1971_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Tam tin ats’a’its antsana’ an cau an ts’ale pale’, ani c’al an oc’lec c’al am beletnom tiyopanchic, ani c’al am pale’chic axi lej exbath, tam jilc’onchic lej c’upupul in tsalap. In uluchic jant’o hualam t’ajnenec ani ne’ets ca más t’ajane. ");
INSERT INTO husNT1971_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Taley tameq’ui ulcan c’al jaja’chic jun i inic in ulu: ―An inicchic ax a baliyamal al an huic’axte’ tihua’ c’uajat ti al an tiyopan ti exobchix junil c’al an inicchic. ");
INSERT INTO husNT1971_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Tam an oc’lec c’al am beletnom tiyopanchic, ani c’al nixe’ xi ic’tomchic c’alechic quin iq’ui’ an abathualechic c’al i lej c’aya’talab. Yab ic’tat c’al i othnaxtalab, cum an ic’tomchic in ts’ejnal max ca cui’iyat c’al i t’ujub c’al am bichou. ");
INSERT INTO husNT1971_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","In ultha’itschic tin tamet an cuenel ts’ejcom cau. Tam an ts’ale pale’ in ucha’ an abathualechic: ");
INSERT INTO husNT1971_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","―Huahua’ tu lej tsapic uchamalits abal yabats jita’ ca más exobchichiquiy tin cuenta a Jesús. Bel a t’ajalchic, ma tim patal an c’uajilom teje’ ti bichou Jerusalén in ats’amalits a exobchixtal. Ani jaye a le’chic tucu jolbiy c’al in tsemtal a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Tam toc’tsin a Pedro ani axi q’ue’at an abathualechic in uluchic: ―Pel i uchbil qui oc’ox t’ajchi jahua’ tucu abatna’ a Dios. Yab qui t’ajchi jahua’ tucu abatna’ i inic max yab juncuth in tsalap c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ojni’ tata’chic a tsemtha’ a Jesús ti al i pelc’oth te’, ani pel in Diosil i biyal at juntal c’al ti ejtha a Jesús tam ti tsemenequits. ");
INSERT INTO husNT1971_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ja’its a Dios ax in c’uajba’ a Jesús tin huinab c’ubac jant’ini’ ti puhuethanchithits im bij. Im punuhuits ti Ts’ale Abatnom ani ti Jec’onthax c’al an inicchic. Xo’ a Dios in le’ abal huahua’ tu Israelchic cu jic’tson c’al i hualab ani cu paculanchat i hualab. ");
INSERT INTO husNT1971_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Lej chububul axe’ xi cau jahua’ i olnal, ani jaye an Espíritu Santo in olnal xe’. Ja’its jaja’ an Espíritu Santo u pithnal c’al a Dios jitats quin t’ajchi jahua’ a Dios in le’. ");
INSERT INTO husNT1971_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Tam tin ats’a’its antsana’ axe’ xi cau an cuenel ts’ejcom cau, tam ti lej tsacuy, ma in le’ quin tsemtha’ an abathualechic. ");
INSERT INTO husNT1971_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Tam cubiy jun jaja’chic im bij Gamaliel. Pel i fariseo ax u exobchix c’al an ts’ejcath cau binath c’al a Moisés ani lej c’ac’nab c’al am bichou. In ulu ca ne’tha eleb jun i hue’ an abathualechic. ");
INSERT INTO husNT1971_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Tam in ucha’ an cuenel ts’ejcom cau: ―At Israelchic, ca lej t’aja’ ti cuenta jahua’ a le’ ca t’ajchi axe’ xi inicchic. ");
INSERT INTO husNT1971_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ca t’ila’chic jant’o t’ajchin a Teudas ax in ulu in lej cua’al in cuete’ c’athat ey. Tocat tsemtha jaja’ ani tala’ pit’c’ochiquin axi tse’ i bo’chic inic in ts’at’elil. T’ajat taley nixe’ xi pulic cuenel. ");
INSERT INTO husNT1971_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ani talbel tam tin q’uichajil ca penan am bijlab, ts’at’enec yan i inic c’al a Judas Galileajib. Tsemtha jaja’ jaye ani tala’ pit’c’ochiquinchic in ts’at’elil. ");
INSERT INTO husNT1971_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Jaxtam nan tu uchalchic yab ca t’apchi in t’ojlabil axe’ xi inicchic. Ne’ets ca cuete’ taley in t’ojlabil max pel in cuete’ c’al expith. ");
INSERT INTO husNT1971_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Max pel in c’al a Dios yab ne’ets ca ejtouchic ca t’apchi. Ca lej alhua’ t’aja’ ti cuentachic, lequitsq’ui hualam expith a tomolnanchal in t’ojlabil a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ani patal an cuenel ts’ejcom cau in tsalpay abal lej chubax jahua’ in ulu a Gamaliel. Aba ani’ antsana’ uchanits, bel in abchi an cau ca chi’tha an abathualechic ani ca huithc’oyat. In lej tsapic ucha’chic yabats más quin olnanchiye jita’ im bij a Jesús. Tam in hualca’chic ca c’alets. ");
INSERT INTO husNT1971_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ani tamna’ calejits an abathualechic taja’ ti al an cuenel ts’ejcom cau, c’alechic lej culbel cum pithnenec an q’uij c’al a Dios ca pojca tin cuenta im bij a Jesús. ");
INSERT INTO husNT1971_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Chuthel chuthel ti al an tiyopan ani ti q’uimathchic xe’etschic ti exobchix c’al in cahuintal a Dios ani ti olnanchix c’al im bij a Jesucristo. ");
INSERT INTO husNT1971_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Nixe’ xa q’uichachic ne’ets yanenel am belomchic c’al an Ajatic. Chuthel chuthel u buc’tsixnanchab i c’apnel, tocat jaye hua’ats i jolbixtalab tin cuenta am buc’tsixtalab c’apnel. Am belomchic ax in caunal an cau griego in ulu abal an tsemchith uxum c’al jaja’chic yab u quithat pithnalchic an c’apnel ejtil tu quithat pithnal an tsemchith uxumchic ax in caunal in cuete’ cahuintal Israel. ");
INSERT INTO husNT1971_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Tam axi lajuj tsab i abathuale in ucha’ ca tala’ tamcun am belomchic. Tamcunits ani in ucha’chic: ―Yab in tomnal huahua’ tu abathuale qui jila’ tu olnom c’al in cahuintal a Dios ani tocat qui buc’tsixnanchi an c’apnel. ");
INSERT INTO husNT1971_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Jaxtam ebchalabchic, ca tacuy buc i inic ani ca punuchic ti buc’tsixnanchix c’apnel. Ca tacuy buc ax u lej c’ac’nab c’al patal am belomchic ani lej alhua’ tsalpath ani jum putat co’onchith in ichich c’al an Espíritu Santo. ");
INSERT INTO husNT1971_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ani huahua’ ne’ets qui lej expinchiye cu olon ani cu exobchixin c’al in cahuintal a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ani patal am belomchic in tsalpay abal alhua’ jahua’ in ulu antsana’ an abathualechic. Tam tacuyat a Esteban axi lej lubach belom ani jum putat co’onchith in ichich c’al an Espíritu Santo. Jaye tacuyatchic a Felipe, ani a Prócoro, ani a Nicanor, ani a Timón, ani a Parmenas, ani a Nicolás Antioquíajib. Pel a Nicolás axi ti jayq’ui’ huenc’onenec ti c’ac’nax c’al a Dios ejtil an Israelchic. ");
INSERT INTO husNT1971_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Tam chanchin axi buc tin tamet an abathualechic, punchin tin oc’chic in c’ubac ani conchinchat in tolmixtal a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ne’ets yanenel in cahuintal a Dios, ani ne’ets lej yanenel am belomchic ti Jerusalén. Ma yan i pale’chic jaye in it belal an Ajatic. ");
INSERT INTO husNT1971_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Jun axi buc tacuthits pel a Esteban. Cum lej tsaplilith c’al a Dios in t’ajal yan i labith t’ajbilab ti tsu’bixtalab tin tamet an inicchic. Lej jum putat co’onchab in ichich c’al in alhua’ inictal a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ani hua’ats taja’ al an tiyopan Israel i cuenel axi hueutsíx c’al a Esteban. U bijiyab an cuenel ti Hualcathlom, cum pelac i inicchic axi ti jayq’ui’ lej c’unat co’oyame c’al i amulab ani xo’ itsots. Pelchic al nixe’ xi cuenel axi c’uajinec ti Cirene, ani ti Alejandria, ani ti Cilicia, ani ti Asia. ");
INSERT INTO husNT1971_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ani yab in ejtouchic quin ata’ a Esteban, cum jaja’ pithnenec i tsalpathtalab ani i cau c’al an Espíritu Santo. ");
INSERT INTO husNT1971_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Tam jaja’chic in ucha’ talchic in juntal ca janamcahuin jun t’ajat tin cuenta a Esteban. Quin uluq’ui abal in ats’amalits tam ti quithab cahuilixin c’al a Moisés ani c’al a Dios. Im pitha’chic i tumin abal antsana’ quin ulu. ");
INSERT INTO husNT1971_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ani cum belchinits an janamtalab, tam tocat tsacuy an mulcunel junax c’al an yejtselabchic Israel ani c’al an exobchixchic c’al an ts’ejcath cau binath c’al a Moisés. Tam lej muthenchab a Esteban c’al jaja’chic. Yac’uan ani ne’tha tin tamet an cuenel ts’ejcom cau axi lej c’athpich exbath in ey. ");
INSERT INTO husNT1971_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Tam cubiychic i q’uet’ach jolbix in ulu: ―Axe’ xi inic yab u coyol tucu quithab olnanchi i t’ocat tiyopanil ani tucu pojcanchi an ts’ejcath cau ax tu pithamal a Moisés. ");
INSERT INTO husNT1971_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","I ats’amal tam tin ulu abal a Jesús Nazaretib ne’ets tucu paclunchi i tiyopanil ani ne’ets tucu jalc’unchi an uchbixtalab ax tu pithamal a Moisés. ");
INSERT INTO husNT1971_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Tam an cuenel ts’ejcom cau ani patal axi quetechic c’al jaja’chic in ejchical a Esteban, ani in tsu’chal in hual ejtil in hual i ángel. ");
INSERT INTO husNT1971_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Tam conoyab a Esteban c’al an ts’ale pale’ antse’: ―¿Nix chubax jant’ini’ tit jolbiyab? ");
INSERT INTO husNT1971_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Toc’tsin a Esteban: ―Pay’lomlabchic ani at juntalabchic, tiquin ats’anchi jahua’ ne’ets tu ucha’. Huahua’ i Diosil an Ts’ale Pay’lom ti eb in tejhua’metha’ tim ba’ ti biyal c’al a Abraham tam ti c’uajate ti Mesopotamia. Yabaye c’ale ca c’uajiy ti Harán. ");
INSERT INTO husNT1971_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Uchan a Abraham c’al a Dios: Ca jilca’ a tsabalil ani quit tala’ tixc’an c’al patal a at ja’ub xits’alchic, ani tihua’ quit c’ale al jun i tsabal axi nan ne’ets tu olchiye. ");
INSERT INTO husNT1971_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Tam cale a Abraham ti tsabal Caldea, c’ale ca c’uajiy ti bichou Harán. Tats ti c’uajiy ma tam ti tsemets in tata. Taley a Dios in aba’ ca chich a Abraham teje’ jun tu c’uajil huahua’ tu Israel xo’. ");
INSERT INTO husNT1971_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","A Dios yabaye in lej jilchi quin c’alna’ ni jun i xacab i tsabal. Expith im bijchith ucha’ abal in tsacamilchic jats ne’ets quin c’alna’ axe’ xi tsabal tam ca tsemets jaja’. Antsana’ ti uchan aba ani’ yabaye in co’oyamal in tsacamil. ");
INSERT INTO husNT1971_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Uchan jaye abal ne’ets ca oc’ox c’uajiy in tsacamilchic al i pil tsabal xan ti yab in cuete’ c’al, ani taja’ ne’ets ca c’unat co’oyatchic c’al i tsaplab ani ca othna ma tse’ i bo’chic inic i tamub. ");
INSERT INTO husNT1971_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Uchane a Abraham c’al a Dios: Nan ne’ets cu yajchiquiy am bichou axi ne’ets ti c’unat co’onchi a tsacamilchic c’al i tsaplab. Taley talbel jaja’chic ne’ets ca tixc’an al nixe’ xi pil tsabal, ani ca chich teje’ al axe’ xi tsabal in lej c’al. Teje’ ti ne’ets tiquin t’ojonchi, in ulu a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ani pithan a Abraham c’al a Dios i jilchith cau. Uchan ca cojchinchic in inictal axi inic ti Israel cum pelchic tin c’al a Dios. Jaxtam tam ti huaxic a q’uicha ti hua’tsinenequits in tsacamil a Abraham Isaac, cojchin in inictal. Talbel t’ajchin jaye ani’ a Jacob in tsacamil a Isaac. Ani talbele in tsacamilchic a Jacob t’ajchin jaye ani’. Axi lajuj tsab in tsacamil a Jacob jats u tatalab c’al axi lajuj tsab i cuenel huahua’ tu Israel. ");
INSERT INTO husNT1971_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Jun jaja’chic im bij José lej pa’ixna c’al in cuete’ ebchalchic, ani jats ti nujuhuat ani ne’tha ti Egipto c’al an ts’a’um. Ani tihua’ c’uajiy alhua’ beletnanath c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Cum a Dios in jec’onthathiyal c’al jahuaquits tam yajchictalab. In lej tsalpathmetha’ ani in tolminchi quim baju ca tsu’tat ti alhua’ inic c’al an ts’ale Faraón ti Egipto. Jaxtam a Faraón im punu a José ti pulic oc’lec ti Egipto ani ti abatnanchix c’al patal jahua’ tin q’uima’. ");
INSERT INTO husNT1971_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Taley hua’tsin i pulic jayil ani i yajchictalab tim puhuel an tsabal Egipto ani jaye ti tsabal Canaán. I ts’ejhuantal at juntalchic ni jant’o yab in ela’ quin c’apu. ");
INSERT INTO husNT1971_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ma talbel tam tin ats’a’its a Jacob abal hua’ats i lab em ti Egipto, tamna’ in aba’ ca c’ale in cuitolilchic tihua’. Pel jaja’chic i biyal at juntal xits’al. Jats an c’a’al acan in t’aja’ ca c’alechic ti Egipto. ");
INSERT INTO husNT1971_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ma tam tin tsabchil acan c’alechic junil, tam tin tejhua’metha’ a José tim ba’ abal jaja’ ja’its pel in cuete’ ebchalchic. Ma tamits ti exlajits a José c’al a Faraón abal jant’o tam xits’lab. ");
INSERT INTO husNT1971_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Tam a José in abchi an cau ca chanchin in tata Jacob c’al patal in at ja’ub xits’alchic. Hua’ats jelat ox inic c’al lajuj bo’ i inic. ");
INSERT INTO husNT1971_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Antsana’ c’ale a Jacob ca c’uajiy ti Egipto, ani talbel tats ti tsemets. Tats ti tsemets jaye q’ue’atchic i biyal at juntal xits’al. ");
INSERT INTO husNT1971_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Lej talbelits canchin im beclac jaja’chic ani ne’tha ti Siquem. Tats ti joliyat al i ts’ejcath jol paxal t’ujub axi a Abraham in ts’a’iy c’al in tsacamilchic a Hamor ax ti Siquem. ");
INSERT INTO husNT1971_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Hue’its ne’ets quim baju an q’uij tam tin tsacamilchic a Abraham ne’ets ca pithan in cuete’ tsabalilchic, cum antsana’ ti bijchith uchnenec a Abraham. Ma a Dios in cuba’ tim ba’ abal chubax ne’ets quim pitha’chic. Lej ne’ets puhuehuel am bichou Israel ti Egipto. ");
INSERT INTO husNT1971_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Im baju a q’uicha tam ti punuhuat q’ue’at i ts’ale ti Egipto, c’al axi ti yab exlanchat in ey a José ti oc’lec. ");
INSERT INTO husNT1971_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Nixe’ xi it ts’ale in lej c’ambibiyal ani in lej othnaniyal i at juntal xits’alchic. Im bina’ i tsapic cau abal quin jilcacay in t’ele’ilchic abal ca taley yabats ca c’uajiy ejat. ");
INSERT INTO husNT1971_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Tam ti hua’tsin a Moisés ani lej culbel a Dios c’al jaja’. In tata ani in mim in ejtohualchic quin co’oy expith ox a its’. ");
INSERT INTO husNT1971_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Tam in jilcacay jaye. Talbel elchin c’al in ts’ic’achil an ts’ale, ani tihua’ tin q’uima’ yejtha jant’ini’ max pel in cuete’ tsacamil. ");
INSERT INTO husNT1971_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Tihua’ ti Egipto tats tin alhua’ exlanchi a Moisés patal in exobchixtal an Egiptojibchic. Lej huit’om ti huilom c’al an cau ani lej huit’om ti t’ojnal c’al jahuaquitsq’ui. ");
INSERT INTO husNT1971_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Tam tin cua’alits tsab inic i tamub a Moisés, tam tin tsalpay quin tsa’biy in at juntal xits’alchic Israel. ");
INSERT INTO husNT1971_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ani tam ti c’uajatits tihua’ c’al jaja’chic in tsu’u othnanchab jun in at juntal c’al i inic Egiptojib. In thubat c’aniy ani in tsemtha’ an Egiptojib. Antsana’ in t’ajchi an huichbanchixtalab am pojcax. ");
INSERT INTO husNT1971_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","C’al in c’anixtal antsana’ a Moisés in tsalpay abal ne’ets ca exla c’al in at juntal Israelchic abal ja’its jaja’ punuthits c’al a Dios ti hualcanthom c’al jaja’chic. Ani belq’ui yab chubax tsalpanchat antsana’ c’al in at juntal xits’alchic. ");
INSERT INTO husNT1971_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Tin aytal q’uicha a Moisés in tsu’u u pejéx jaye tsab i Israelchic. Cum in le’ quin jilabetha’chic in conoy: ¿Jale hualam it othnáx ani pel it at ebchalabchic? ");
INSERT INTO husNT1971_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Tam tsacuy axi jun, im pac’amna’ a Moisés. In conoy: ¿Jita’ ti punu tit abatnom ani tit ts’ejcom c’al huahua’? ");
INSERT INTO husNT1971_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Hualam a le’ tiquin tsemtha’ jant’ini’ a tsemtha’ an Egiptojib ti hue’el? ");
INSERT INTO husNT1971_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Tam tin ats’a’ axe’ xi cau antsana’ a Moisés, tameq’ui thubat pit’c’on c’ale ti tsabal Madián. Taja’ c’uajiy ti pil inic. Tomquin ani in tsu’u tsab i tsacam c’al in q’uimathil. ");
INSERT INTO husNT1971_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Tsab inic i tamub talbel tejhua’me jun i ángel c’al a Moisés ti al i joltam utat ti bolchal Sinaí. Tejhua’me al i tsacam t’ijax te’ tam tu t’a’ilits. ");
INSERT INTO husNT1971_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","A Moisés in lej jic’pa’ jant’ini’ tu tsu’biyab in tsu’u. Utey jun t’ajat abal quin lej alhua’ tsu’u, ani tamna’ tin ats’a’ i cau. Uchan c’al a Dios: ");
INSERT INTO husNT1971_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Nana’its tin Diosil c’al a biyal at juntal xits’alchic. Pel tin Diosil a Abraham ani a Isaac ani a Jacob. Tam ti lej jiq’uey a Moisés, ma t’elelel in inictal. Yabats in inicnal tim ba’ abal quim met’aye c’al jahua’ tu tsu’biyab. ");
INSERT INTO husNT1971_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","A Dios in ucha’: Ca tixc’a’ a pajab biyat nana’ in T’ocat Dios te in c’uajat ta tamet. ");
INSERT INTO husNT1971_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","U tsu’umalits lej yajchic in huat’al u bichohuil ti Egipto. U ats’amalits ej’elchic xe’ets. Xo’ im pa’inequits abal cu hualcantha’ c’al an yajchictalab. Jaxtam ojni’ xo’ ne’ets tu aba’its ti Egipto. ");
INSERT INTO husNT1971_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Taja’ olchin in eylabil a Moisés tam ti tejhua’me nixe’ xi ángel ti al an tsacam t’ijax te’. Chubax punume c’al a Dios ti abatnom ani ti hualcanthom c’al in at juntal xits’alchic. Belq’ui pojcajits c’al jaja’chic. Yab im bela’chic max in ey ti abatnom ani ti ts’ejcom c’al jaja’chic. ");
INSERT INTO husNT1971_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ja’its nixe’ a Moisés c’al ti caltha i biyal at juntal xits’alchic ti Egipto. Ja’its jaja’ ax in t’ajamal i labith t’ajbilab ti tsu’bixtalab ti Egipto ani ti al am pulic lejem Rojo. Jaye in t’ajamal ti al an joltam jun ti xe’ets i at Israelchic tsab inic i tamub. ");
INSERT INTO husNT1971_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Jats a Moisés ax in ucha’ an Israelchic: A Dios ne’ets ti abchichic jun i caulome axi pel a at juntal xits’al. Jant’ini’ a Dios tin abamal nana’ tin caulome, antsana’ axi junaque axi taye tal ca aban. Jats ca lej alhua’ bina’ a xutsunchic ca ats’anchi jahua’ ne’ets ti ucha’. ");
INSERT INTO husNT1971_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Jats a Moisés axi xe’tsin junax c’al in at Israelchic ti al an joltam. Ani tam ti tamcuthchic tihua’ ti bolchal Sinaí, tats ti tauna a Moisés c’al i ángel ani pithan i cau quin huat’banchi i biyal at juntalchic. Ja’its an cau huahua’hue xo’ qui ejatna’. ");
INSERT INTO husNT1971_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Ani i biyal at juntalchic yab in le’na’ quin t’aja’ jahua’ u uchnal c’al a Moisés, tocat im pojca’. In lej uq’uixnalchic am bichou Egipto jun ti calthamejits. ");
INSERT INTO husNT1971_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Tam ti c’uajate a Moisés tihua’ al am bolchal, jaja’chic muthat acan am bolchal. Ani uchan a Aaron c’al an mulcunel: I lej le’ cu ts’ejcanchat i inquith dios ani jaja’ tucu oc’nanchi am bel, cum yab i tso’ob ju’ta ti c’uajat a Moisés axi tu oc’nanchamal ma tam tu calthachits huahua’ tihua’ ti bichou Egipto. ");
INSERT INTO husNT1971_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Tam in ts’ejca’chic i inquith dios. Pel i becerro axi ts’ejcath c’al i oro, ani lej q’uijithnab. In tsemtha’chic i co’nel ani in ts’acchiychic nixe’ xi thulcuts. ");
INSERT INTO husNT1971_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Jaxtam ti jilcacayatchic c’al a Dios, ma jilanchic quin c’ac’na’q’ui a otchic ti eb. Thuchathits ti al in thuchat uhuil an caulomechic c’al a Dios jant’o uchan jaja’chic c’al a Dios antse’: Tata’ ojni’ Israelchic, tin eb c’ac’namalq’ui tam tit xe’etsac tsab inic i tamub ti al an joltam. Tocat tin ts’acchiyamalq’ui c’al i tsemthach co’nel. ");
INSERT INTO husNT1971_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Tocat a xe’tsinthamalq’uichic an lona ata jun ta diosnamalq’ui an thulcuts Moloch. A diosnamalq’uichic i inquith ot ax u bijiyab dios Renfán. Yan i thulcuts a ts’ejcamalchic abal ca diosna’. Jaxtam nan ne’ets tu ou huat’ba’chic jum poq’ue’ tihua’ ti bichou Babilonia. ");
INSERT INTO husNT1971_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Cahue a Esteban in ulu: Tam ti xe’etsac i at Israelchic tihua’ ti al an joltam ets’ey in xe’tsinthamal am pulic lona tiyopan ata jun tu co’oyab an ts’ejcath cau binath c’al a Moisés. Pel i tiyopan axi ts’ejcanenec jant’ini’ ti pithan an t’iplab a Moisés c’al a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Taley tam ti tsemetsits a Moisés, calchiyat c’al a Josué. Ani jaja’ in ne’tha’ i biyal at Israelchic ca otsits al an tsabal jahua’ bijchith uchnenec ne’ets ca pithanchic c’al a Dios. Taja’ a Dios in quethmay axi c’uajatchic al nixe’ xi tsabal abal ca otsits i biyal at juntalchic. Antsana’ ohuat eyentha nixe’ xi tiyopan ata ma tam ti punume a David ti ts’ale. ");
INSERT INTO husNT1971_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Taley tam jaja’ in le’ quin ts’ejcanchi in t’ayat q’uima’ a Dios axi pelac in Diosil jaye a Jacob. Ani lej culbel a Dios c’al a David. ");
INSERT INTO husNT1971_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Aba ani’, bel yab im pitha’ an q’uij a David quin ts’ejcanchi. In tsacamil Salomón jats in ts’ejcanchi in t’ayat q’uima’ a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Aba ani’ ca ts’ejcanchat i tiyopan ata a Dios, yab qui tsalpay max u che’el i t’ec’at pulic Pay’lom Dios ca c’uajiy al i ata ax in ts’ejcabil i inic. In olnal an caulome c’al a Dios jant’o in ulu a Dios tin cuenta in q’uima’ jaja’ antse’: ");
INSERT INTO husNT1971_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","In c’uajil ti eb tin lej Ts’ale ani jaye tim puhuel an tsabal tin Ts’ale. Yab u yejenchal i ata cu c’uajchiy. Yab u yejenchal ju’ta quin coyots. ");
INSERT INTO husNT1971_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Nana’its ax u tala’ ts’ejca’ patal jahua’ hua’ats c’al u tsap. ");
INSERT INTO husNT1971_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Cahue a Esteban in ucha’ in at Israelchic: Tata’ ojni’chic a t’ayat ey lej t’ujbabathits a ichich. A xutsun yab a cua’al binanath c’al a Dios. It ejtil axi yab exlom c’al jaja’. Jant’ini’ a biyal at juntalchic in tomolnamal an Espíritu Santo, antsana’te a tomolnalchic. ");
INSERT INTO husNT1971_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ca ulu max hua’tsinenec ti jayq’ui’ i caulome c’al a Dios axi yab othname c’al jaja’chic. Ma tsemthame an caulomechic ax in olna’ ne’ets quim baju a q’uicha ca chich jun i pututh inic. Ani jaja’ yab ohuey tam ti chichits. Tocat a bina’chic tin c’ubac an oc’lecchic ca tsemtha. ");
INSERT INTO husNT1971_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Aba ani’ a cua’alitschic an ts’ejcath cau axi binanchat ti jayq’ui’ a Moisés c’al i ángelchic, bel yab a putuhualchic. ");
INSERT INTO husNT1971_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Tam tin ats’a’its an Israelchic jahua’ in ulu antsana’ a Esteban, tam ti lej tsacuy. Ma huech’ech’el in camab c’al in tsacultal. Ma tamna’its ti lej tomolnaxchic c’al a Esteban. ");
INSERT INTO husNT1971_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ani a Esteban jum putat co’onchabe in ichich c’al an Espíritu Santo. Tocat in met’al ti eb ani in tsu’chal in lej ts’alat a Dios. Jaye in tsu’tal a Jesús cubat tin huinab c’ubac a Dios jant’ini’ ti puhuethanchithits im bij. ");
INSERT INTO husNT1971_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Tam a Esteban in ucha’chic: ―Ca lej met’a’chic japith tihua’ ti eb. Nan u tsu’tal cubat in Juntal patal an inicchic tin huinab c’ubac a Dios. ");
INSERT INTO husNT1971_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ani jaja’chic tocat im paxq’uiyal in xutsun. U lej tsapic thajnalchic tocat. Tam tim patal jaja’chic in muthenchi a Esteban. ");
INSERT INTO husNT1971_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","In ne’tha’chic tin elebtal am bichou ani in cui’iyal c’al i t’ujub. Jilchamejits in coton an cui’ixchic tin acan i cuitol ca beletnanchat. Im bij pel a Saulo. ");
INSERT INTO husNT1971_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Tam tu biyat cui’iyab a Esteban, tamna’ u ole jaja’. In ulu: ―Ajatic Jesús, ca bats’u u espíritujil. ");
INSERT INTO husNT1971_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Taley in tuthu in c’ualal, ani lej tsapic in ulu: ―Ajatic, yab ca jolbiy axe’ xi inicchic c’al jahua’ tin t’ajchamal. Taley expith tam tin ulu antsana’, tsemetsits. ");
INSERT INTO husNT1971_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","A Saulo jaye culbel c’al in tsemtal a Esteban. Nixe’ xa q’uicha tam ti tsemthajits a Esteban, ts’i’quin ca lej tsapic othna im bichohuil a Dios ti Jerusalén. Jaxtam jat’hua’ tim patal am belomchic c’ale buc’uc’ul ti Judea ani ti Samaria. In abathualejilchic a Jesús jats jilc’one ti Jerusalén. ");
INSERT INTO husNT1971_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Talchic i inic axi lej c’ac’nax c’al a Dios u lej t’e’pinal c’al in tsemtal a Esteban, ma in lej uc’nanchalchic. In ne’thanchi in inictal quin joliy. ");
INSERT INTO husNT1971_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","A Saulo ojni’ jats axi xe’ets ti lej tsapic othnax c’al im bichohuil a Dios. Xe’ets ti q’uimath ti q’uimath in calthal bothothol i inicchic ani i uxumchic. In ne’thalchic ca baliyat al i huic’axte’. ");
INSERT INTO husNT1971_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Am belomchic axi pit’c’onenec ti Jerusalén xe’ets abal ju’tamq’ui ti olnom c’al an alhua’ cau. ");
INSERT INTO husNT1971_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Jun jaja’chic pel a Felipe. Ulits al jun i bichou cuentalith Samaria, ani in ts’i’quiy quin olnanchi an inicchic im bij a Cristo. ");
INSERT INTO husNT1971_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ani axi tamcuthchic taja’ in lej alhua’ bina’ in xutsun c’al jahua’ u olchinal c’al a Felipe. Jaye in lej t’ajchichic ti cuenta an labith t’ajbilab ax in t’ajal. ");
INSERT INTO husNT1971_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","In jelthal yan i tsambe ani yan i c’uets’e’. In cancha