﻿USE sofia;
DROP TABLE IF EXISTS sofia.hun_vpl;
CREATE TABLE hun_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES hun_vpl WRITE;
INSERT INTO hun_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jézus Krisztusnak, Dávid fiának, Ábrahám fiának nemzetségéről szóló könyv. ");
INSERT INTO hun_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ábrahám nemzette Izsákot, Izsák nemzette Jákóbot, Jákób nemzette Júdát és testvéreit. ");
INSERT INTO hun_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Júda nemzette Fáreszt és Zerahot Támártól, Fáresz nemzette Heszrónt, Heszrón nemzette Arámot. ");
INSERT INTO hun_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Arám nemzette Aminádábot, Aminádáb nemzette Nahsont, Nahson nemzette Szalmónt. ");
INSERT INTO hun_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Szalmón nemzette Boázt Ráhábtól, Boáz nemzette Obédet Ruthtól, Obéd nemzette Isait. ");
INSERT INTO hun_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isai nemzette Dávid királyt. Dávid király nemzette Salamont Úriás feleségétől. ");
INSERT INTO hun_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salamon nemzette Roboámot, Roboám nemzette Abijját, Abijja nemzette Ászát. ");
INSERT INTO hun_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ásza nemzette Jósafátot, Jósafát nemzette Jórámot, Jórám nemzette Uzziást. ");
INSERT INTO hun_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzziás nemzette Jótámot, Jótám nemzette Áházt, Áház nemzette Ezékiást. ");
INSERT INTO hun_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezékiás nemzette Manassét, Manassé nemzette Ámónt, Ámón nemzette Jósiást. ");
INSERT INTO hun_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Jósiás nemzette Jekonjást és testvéreit a babiloni fogságravitelkor. ");
INSERT INTO hun_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","A babiloni fogságravitel után pedig Jekonjás nemzette Sealtiélt, Sealtiél nemzette Zerubbábelt. ");
INSERT INTO hun_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubbábel nemzette Abihudot, Abihud nemzette Eljákimot, Eljákim nemzette Azzurt. ");
INSERT INTO hun_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azzur nemzette Cádókot, Cádók nemzette Jákint, Jákin nemzette Elihudot. ");
INSERT INTO hun_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Elihud nemzette Eleázárt, Eleázár nemzette Mattánt, Mattán nemzette Jákóbot. ");
INSERT INTO hun_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jákób nemzette Józsefet, férjét Máriának, akitől született Jézus, akit Krisztusnak neveznek. ");
INSERT INTO hun_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Az összes nemzetség tehát Ábrahámtól Dávidig tizennégy nemzetség, Dávidtól a babiloni fogságravitelig tizennégy nemzetség, a babiloni fogságraviteltől Krisztusig tizennégy nemzetség. ");
INSERT INTO hun_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jézus Krisztus születése pedig így történt: Anyja, Mária, aki József jegyese volt, egybekelésük előtt viselős lett a Szentlélektől. ");
INSERT INTO hun_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","József, a férje, igaz ember volt, és nem akarta őt gyalázatba keverni, titokban akarta őt elbocsátani. ");
INSERT INTO hun_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Mikor pedig ezeket magában elgondolta, íme, az Úr angyala megjelent neki álmában, és ezt mondta: „József, Dávid fia, ne félj magadhoz venni Máriát, a te feleségedet, mert ami benne fogantatott, az a Szentlélektől van. ");
INSERT INTO hun_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Fiat fog majd szülni, és nevezd őt Jézusnak, mert ő szabadítja meg népét bűneitől.“ ");
INSERT INTO hun_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Mindez pedig azért történt, hogy beteljesedjék, amit az Úr mondott a próféta által, aki így szólt: ");
INSERT INTO hun_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","„Íme, a szűz méhében fogan, és fiat szül, és Immánuelnek fogják nevezni“ – ami azt jelenti: Velünk az Isten. ");
INSERT INTO hun_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","József pedig álmából felserkenve úgy tett, amint az Úr angyala parancsolta neki: magához vette feleségét, ");
INSERT INTO hun_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","és nem érintette addig, amíg meg nem szülte elsőszülött fiát, akit Jézusnak nevezett el. ");
INSERT INTO hun_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Amikor pedig megszületett Jézus a júdeai Betlehemben, Heródes király idejében, íme, napkeletről bölcsek jöttek Jeruzsálembe, és ezt mondták: ");
INSERT INTO hun_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","„Hol van a zsidók királya, aki megszületett? Mert láttuk csillagát napkeleten, és azért jöttünk, hogy tisztességet tegyünk neki.“ ");
INSERT INTO hun_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Amikor Heródes király ezt meghallotta, felháborodott, és vele együtt az egész Jeruzsálem. ");
INSERT INTO hun_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Egybegyűjtött minden főpapot és a nép írástudóit, és tudakozódott tőlük, hogy hol kell Krisztusnak megszületnie. ");
INSERT INTO hun_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Azok pedig ezt mondták neki: „A júdeai Betlehemben, mert így írta meg a próféta: ");
INSERT INTO hun_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","»És te, Betlehem, Júdának földje, semmiképpen sem vagy legkisebb Júda fejedelmi városai között, mert belőled származik a fejedelem, aki legeltetni fogja népemet, Izraelt.«“ ");
INSERT INTO hun_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ekkor Heródes titkon hívatta a bölcseket, szorgalmasan megtudakolta tőlük a csillag megjelenésének idejét. ");
INSERT INTO hun_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Elküldte őket Betlehembe, és azt mondta nekik: „Menjetek el, szorgalmasan kérdezősködjetek a gyermek felől, mihelyt pedig megtaláljátok, adjátok tudtomra, hogy én is elmenjek, és tisztességet tegyek neki.“ ");
INSERT INTO hun_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ők pedig a király beszédét meghallgatták, és elindultak. És íme, a csillag, amelyet napkeleten láttak, előttük ment mindaddig, amíg odaérve megállt a hely fölött, ahol a gyermek volt. ");
INSERT INTO hun_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Amikor meglátták a csillagot, igen nagy örömmel örvendeztek. ");
INSERT INTO hun_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Bementek a házba, ott találták a gyermeket anyjával, Máriával, és leborulva tisztességet tettek neki, kincseiket kitárva ajándékot adtak neki: aranyat, tömjént és mirhát. ");
INSERT INTO hun_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Mivel álmukban intést kaptak, hogy Heródeshez vissza ne menjenek, más úton tértek vissza hazájukba. ");
INSERT INTO hun_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Mikor pedig elmentek, megjelent Józsefnek az Úr angyala álmában, és mondta neki: „Kelj fel, vedd a gyermeket és anyját, fuss Egyiptomba, és maradj ott, amíg én mondom neked, mert Heródes halálra fogja keresni a gyermeket.“ ");
INSERT INTO hun_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ő pedig felkelt, vette a gyermeket és anyját még éjjel, és Egyiptomba ment. ");
INSERT INTO hun_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","És ott volt egészen Heródes haláláig, hogy beteljesedjék, amit az Úr mondott a próféta által, aki így szólt: „Egyiptomból hívtam ki az én fiamat.“ ");
INSERT INTO hun_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ekkor Heródes látta, hogy a bölcsek megcsúfolták őt, szerfölött felháborodott, kiküldte embereit, és megöletett Betlehemben és annak egész környékén minden kétesztendős és azon aluli gyermeket a szerint az idő szerint, ahogyan azt pontosan megtudta a bölcsektől. ");
INSERT INTO hun_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ekkor teljesedett be, amit Jeremiás próféta mondott, midőn így szólt: ");
INSERT INTO hun_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","„Szó hallatszott Rámában, sírás-rívás és sok keserves jajgatás. Ráhel siratta fiait, és nem akart megvigasztalódni, hogy nincsenek.“ ");
INSERT INTO hun_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Mikor pedig Heródes meghalt, íme, az Úr angyala megjelent álmában Józsefnek Egyiptomban, ");
INSERT INTO hun_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","és ezt mondta: „Kelj fel, vedd a gyermeket és anyját, és eredj Izrael földjére, mert meghaltak, akik a gyermeket halálra keresték.“ ");
INSERT INTO hun_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ő pedig felkelt, magához vette a gyermeket és anyját, és elment Izrael földjére. ");
INSERT INTO hun_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Amikor pedig hallotta, hogy Júdeában Arkhelaosz uralkodik Heródesnek, atyjának helyén, nem mert odamenni, hanem miután álmában figyelmeztetést kapott, Galileába ment. ");
INSERT INTO hun_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Odaérkezve a Názáret nevű városkában lakott, hogy beteljesedjék, amit a próféták mondtak, hogy názáretinek fogják nevezni. ");
INSERT INTO hun_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Azokban a napokban pedig eljött Keresztelő János, aki Júdea pusztájában prédikált, ");
INSERT INTO hun_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","és ezt mondta: „Térjetek meg, mert közel van a mennyeknek országa.“ ");
INSERT INTO hun_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Mert ő volt az, akiről Ézsaiás próféta így szólt: „Kiáltó szó a pusztában: Készítsétek az Úr útját, és egyengessétek ösvényeit.“ ");
INSERT INTO hun_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jánosnak ruhája pedig teveszőrből volt, bőröv volt a dereka körül, elesége pedig sáska és erdei méz volt. ");
INSERT INTO hun_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Akkor kiment hozzá Jeruzsálem és egész Júdea, a Jordánnak egész környéke. ");
INSERT INTO hun_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","És megkeresztelkedtek általa a Jordán vizében, megvallva bűneiket. ");
INSERT INTO hun_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Amikor pedig látta, hogy a farizeusok és a szadduceusok közül sokan mennek hozzá, hogy megkeresztelkedjenek, ezt mondta nekik: „Mérges kígyóknak fajzatai! Ki intett titeket, hogy Istennek eljövendő haragjától meneküljetek? ");
INSERT INTO hun_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Teremjetek hát megtéréshez illő gyümölcsöket, ");
INSERT INTO hun_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","és ne gondoljátok, hogy így szólhattok magatokban: Ábrahám a mi Atyánk! Mert mondom nektek, hogy Isten ezekből a kövekből is támaszthat fiakat Ábrahámnak. ");
INSERT INTO hun_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","A fejsze immár a fák gyökerére vettetett, ezért minden fát, amely jó gyümölcsöt nem terem, kivágnak, és tűzre vetnek. ");
INSERT INTO hun_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Én csak vízzel keresztellek titeket megtérésre, de aki utánam jön, erősebb nálam, neki saruját hordozni sem vagyok méltó. Ő majd Szentlélekkel és tűzzel keresztel majd titeket. ");
INSERT INTO hun_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Szórólapát van kezében, és megtisztítja szérűjét, gabonáját csűrbe takarítja, a polyvát pedig megégeti olthatatlan tűzzel.“ ");
INSERT INTO hun_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ekkor eljött Jézus Galileából a Jordán mellé Jánoshoz, hogy megkeresztelkedjen általa. ");
INSERT INTO hun_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","János azonban visszatartotta őt, és ezt mondta: „Nekem kell általad megkeresztelkednem, és te jössz hozzám?“ ");
INSERT INTO hun_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jézus pedig ezt felelte: „Engedj most, mert így illik nekünk minden igazságot betöltenünk.“ Ekkor engedett neki. ");
INSERT INTO hun_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jézus megkeresztelkedett, azonnal kijött a vízből, és íme, az egek megnyíltak, és látta Isten Lelkét lejönni, mint egy galambot, és reászállt. ");
INSERT INTO hun_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","És íme, egy égi hang ezt mondta: „Ez az én szeretett Fiam, akiben én gyönyörködöm.“ ");
INSERT INTO hun_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ekkor Jézust a Lélek a pusztába vitte, hogy ott az ördög megkísértse. ");
INSERT INTO hun_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Negyven nap és negyven éjjel böjtölt, mikor végre megéhezett. ");
INSERT INTO hun_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ekkor odament hozzá a kísértő, és ezt mondta: „Ha Isten Fia vagy, mondd, hogy e kövek változzanak kenyerekké.“ ");
INSERT INTO hun_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ő pedig ezt felelte: „Meg van írva: Nemcsak kenyérrel él az ember, hanem minden igével, amely Isten szájából származik.“ ");
INSERT INTO hun_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ekkor elvitte őt az ördög a szent városba, és a templom tetejére állította, ");
INSERT INTO hun_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","és ezt mondta neki: „Ha Isten Fia vagy, vesd le magadat, mert meg van írva: »Angyalainak parancsol felőled, és kézben hordoznak téged, hogy meg ne üsd lábadat a kőbe.«“ ");
INSERT INTO hun_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jézus ezt mondta neki: „Viszont meg van írva: »Ne kísértsd az Urat, a te Istenedet.«“ ");
INSERT INTO hun_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ismét magával vitte az ördög egy igen magas hegyre, és megmutatta neki a világ minden országát és azok dicsőségét, ");
INSERT INTO hun_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","és ezt mondta neki: „Mindezeket neked adom, ha leborulva imádsz engem.“ ");
INSERT INTO hun_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ekkor azt mondta neki Jézus: „Eredj el, Sátán, mert meg van írva: Az Urat, a te Istenedet imádd, és csak neki szolgálj.“ ");
INSERT INTO hun_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ekkor elhagyta őt az ördög, és íme, angyalok jöttek szolgálni őt. ");
INSERT INTO hun_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Amikor pedig meghallotta Jézus, hogy Jánost börtönbe vetették, visszatért Galileába. ");
INSERT INTO hun_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Majd otthagyva Názáretet, elment, és a tengerparti Kapernaumban lakott, Zebulon és Naftali határán, ");
INSERT INTO hun_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","hogy beteljesedjék, amit Ézsaiás próféta mondott: ");
INSERT INTO hun_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","„Zebulonnak és Naftalinak földje a tenger felé, a Jordánon túl, a pogányok Galileája! ");
INSERT INTO hun_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","A nép, amely sötétségben ült, nagy világosságot látott, és akik a halál földjén és árnyékában ültek, azoknak világosság támadt.“ ");
INSERT INTO hun_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ettől fogva Jézus prédikálni kezdett, és ezt mondta: „Térjetek meg, mert elközelített a mennyeknek országa.“ ");
INSERT INTO hun_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Mikor pedig a Galileai-tenger mellett járt Jézus, látott két testvért, Simont, akit Péternek neveznek, és Andrást, az ő testvérét, amint a tengerbe hálót vetettek, mert halászok voltak. ");
INSERT INTO hun_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ezt mondta nekik: „Kövessetek engem, és én emberek halászaivá teszlek titeket.“ ");
INSERT INTO hun_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Azok pedig azonnal otthagyták a hálókat, és követték őt. ");
INSERT INTO hun_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Onnan továbbmenve látott még két testvért, Jakabot, Zebedeus fiát és Jánost, a testvérét, amint a hajóban atyjukkal, Zebedeussal hálóikat kötözgették, és hívta őket is. ");
INSERT INTO hun_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Azok pedig azonnal otthagyták a hajót és atyjukat, és követték őt. ");
INSERT INTO hun_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Azután Jézus bejárta egész Galileát, tanított a zsinagógákban, hirdette az Isten országának evangéliumát, gyógyított a nép között minden betegséget és minden erőtlenséget. ");
INSERT INTO hun_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Elterjedt a híre egész Szíriában, és hozzá vitték mindazokat, akik rosszul voltak, különféle betegségekben és kínokban sínylődtek, ördöngösöket, holdkórosokat és gutaütötteket, és meggyógyította őket. ");
INSERT INTO hun_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Nagy sokaság követte őt Galileából, Tízvárosból, Jeruzsálemből, Júdeából és a Jordánon túlról. ");
INSERT INTO hun_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Mikor pedig látta Jézus a sokaságot, felment a hegyre, leült, és odamentek hozzá tanítványai. ");
INSERT INTO hun_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","És megnyitva száját, így tanította őket: ");
INSERT INTO hun_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","„Boldogok a lelki szegények, mert övék a mennyeknek országa. ");
INSERT INTO hun_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Boldogok, akik sírnak, mert ők megvigasztaltatnak. ");
INSERT INTO hun_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Boldogok a szelídek, mert ők örökségül bírják a földet. ");
INSERT INTO hun_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Boldogok, akik éheznek és szomjaznak az igazságra, mert ők megelégíttetnek. ");
INSERT INTO hun_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Boldogok az irgalmasok, mert ők irgalmasságot nyernek. ");
INSERT INTO hun_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Boldogok, akiknek szívük tiszta, mert ők az Istent meglátják. ");
INSERT INTO hun_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Boldogok a békességre igyekezők, mert ők az Isten fiainak mondatnak. ");
INSERT INTO hun_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Boldogok, akik háborúságot szenvednek az igazságért, mert övék a mennyek országa. ");
INSERT INTO hun_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Boldogok vagytok, ha szidalmaznak és háborgatnak titeket, gonosz hazugságokat mondanak rólatok énmiattam. ");
INSERT INTO hun_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Örüljetek és örvendezzetek, mert a ti jutalmatok bőséges a mennyekben, hiszen így háborgatták a prófétákat is, akik előttetek éltek.“ ");
INSERT INTO hun_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","„Ti vagytok a földnek sója. Ha pedig a só megízetlenül, mivel sózzák meg? Nem jó azután semmire, csak arra, hogy kidobják, és eltapossák az emberek. ");
INSERT INTO hun_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ti vagytok a világ világossága. Nem rejthetik el a hegyen épült várost. ");
INSERT INTO hun_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Gyertyát sem azért gyújtanak, hogy a véka alá tegyék, hanem hogy a gyertyatartóba, hogy fényljék mindazoknak, akik a házban vannak. ");
INSERT INTO hun_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Úgy fényljék a ti világosságotok az emberek előtt, hogy lássák a ti jó cselekedeteiteket, és dicsőítsék a ti mennyei Atyátokat.“ ");
INSERT INTO hun_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","„Ne gondoljátok, hogy a törvénynek vagy a prófétáknak eltörléséért jöttem. Nem azért jöttem, hogy eltöröljem, hanem inkább, hogy betöltsem. ");
INSERT INTO hun_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Mert bizony mondom néktek, míg az ég és föld el nem múlik, a törvényből egy ióta vagy egyetlen pontocska sem múlik el, amíg minden be nem teljesedik. ");
INSERT INTO hun_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ezért ha valaki csak egyet is eltöröl a legkisebb parancsolatok közül, és úgy tanítja az embereket, a mennyeknek országában a legkisebb lesz; ha pedig valaki eszerint cselekszik, és úgy tanít, az a mennyeknek országában nagy lesz. ");
INSERT INTO hun_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Mert mondom néktek, ha a ti igazságtok nem több az írástudók és farizeusok igazságánál, semmiképpen sem mehettek be a mennyeknek országába. ");
INSERT INTO hun_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Hallottátok, hogy megmondatott a régieknek: »Ne ölj, mert aki öl, méltó az ítéletre.« ");
INSERT INTO hun_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Én pedig azt mondom nektek, hogy mindaz, aki haragszik atyjafiára ok nélkül, méltó az ítéletre; aki pedig azt mondja az atyjafiának: ostoba, méltó a főtörvényszékre; aki pedig azt mondja: bolond, méltó a gyehenna tüzére. ");
INSERT INTO hun_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Ezért, ha ajándékodat az oltárra viszed, és ott eszedbe jut, hogy a te atyádfiának valami panasza van ellened, ");
INSERT INTO hun_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","hagyd ott az oltár előtt ajándékodat, és menj el, és előbb békülj meg atyádfiával, és azután visszajőve vidd fel ajándékodat. ");
INSERT INTO hun_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Légy jóakarója ellenségednek hamar, amíg az úton együtt vagy vele, hogy ellenséged valamiképpen a bíró kezébe ne adjon, és a bíró oda ne adjon a poroszló kezébe, és tömlöcbe ne vessen téged. ");
INSERT INTO hun_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Bizony mondom néked: ki nem jössz onnan, mígnem megfizetsz az utolsó fillérig. ");
INSERT INTO hun_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Hallottátok, hogy megmondatott a régieknek: Ne paráználkodj! ");
INSERT INTO hun_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Én pedig azt mondom nektek, ha valaki gonosz kívánsággal tekint egy asszonyra, már paráználkodott azzal az ő szívében. ");
INSERT INTO hun_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ha pedig jobb szemed megbotránkoztat téged, vájd ki azt, és vesd el magadtól, mert jobb neked, hogy egy vesszen el a tagjaid közül, semhogy egész tested a gyehennára vettessék. ");
INSERT INTO hun_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","És ha jobb kezed botránkoztat meg téged, vágd le, és vesd el magadtól, mert jobb neked, hogy egy vesszen el tagjaid közül, semhogy egész tested a gyehennára vettessék. ");
INSERT INTO hun_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Megmondatott továbbá: »Ha valaki elbocsátja feleségét, adjon neki válólevelet.« ");
INSERT INTO hun_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Én pedig azt mondom nektek: Ha valaki elbocsátja feleségét, a paráznaság esetét kivéve, az paráznává teszi őt, és aki elbocsátott asszonyt vesz el, paráznaságot követ el. ");
INSERT INTO hun_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Ismét hallottátok, hogy megmondatott a régieknek: »Hamisan ne esküdj, hanem teljesítsd az Úrnak tett esküidet.« ");
INSERT INTO hun_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Én pedig azt mondom nektek: Egyáltalán ne esküdjetek: se az égre, mert az az Istennek királyi széke, ");
INSERT INTO hun_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","se a földre, mert az az ő lábainak zsámolya, sem Jeruzsálemre, mert az a nagy Királynak városa; ");
INSERT INTO hun_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","de ne esküdj saját fejedre se, mert egyetlen hajszálat sem tehetsz fehérré vagy feketévé, ");
INSERT INTO hun_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","hanem legyen a ti beszédetekben az igen igen, a nem nem; ami pedig ezeken felül van, az a gonosztól való. ");
INSERT INTO hun_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Hallottátok, hogy megmondatott: »szemet szemért és fogat fogért.« ");
INSERT INTO hun_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Én pedig azt mondom nektek: Ne álljatok ellene a gonosznak, hanem aki arcul üt téged jobb felől, fordítsd felé a másik orcádat is. ");
INSERT INTO hun_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","És aki törvénykezni akar fölötted, és elvenni az alsóruhádat, engedd oda neki a felsőt is. ");
INSERT INTO hun_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","És aki téged egy mérföldre akar kényszeríteni, menj el vele kettőre. ");
INSERT INTO hun_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Aki tőled kér, adj neki, és aki tőled kölcsön akar kérni, el ne fordulj attól. ");
INSERT INTO hun_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Hallottátok, hogy megmondatott: »Szeresd felebarátodat, és gyűlöld ellenségedet.« ");
INSERT INTO hun_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Én pedig azt mondom nektek: Szeressétek ellenségeiteket! Áldjátok azokat, akik titeket átkoznak, jót tegyetek azokkal, akik titeket gyűlölnek, imádkozzatok azokért, akik háborgatnak és kergetnek titeket. ");
INSERT INTO hun_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Hogy a mennyei Atyátok fiai legyetek, aki felhozza napját mind a gonoszokra, mind a jókra, és esőt ad mind az igazaknak, mind a hamisaknak. ");
INSERT INTO hun_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Mert ha azokat szeretitek, akik titeket szeretnek, micsoda jutalmat vártok? Avagy a vámszedők is nem ugyanezt cselekszik-e? ");
INSERT INTO hun_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","És ha csak atyátokfiait köszöntitek, mit tesztek másoknál többet? A vámszedők is nem ugyanígy cselekszenek-e? ");
INSERT INTO hun_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Legyetek azért tökéletesek, miként mennyei Atyátok tökéletes.“ ");
INSERT INTO hun_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","„Vigyázzatok, hogy alamizsnátokat ne osztogassátok az emberek előtt, hogy lássanak titeket; mert különben nem lesz jutalmatok a ti mennyei Atyátoknál. ");
INSERT INTO hun_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Azért, amikor alamizsnát osztogatsz, ne kürtöltess magad előtt, ahogy a képmutatók tesznek a zsinagógákban és az utcákon, hogy az emberektől dicséretet nyerjenek. Bizony mondom néktek: elvették jutalmukat. ");
INSERT INTO hun_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Te, amikor alamizsnát osztogatsz, ne tudja a bal kezed, mit cselekszik a jobb kezed, ");
INSERT INTO hun_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","hogy a te alamizsnád titokban történjék; és a te Atyád, aki a titokban is lát, megfizet neked.“ ");
INSERT INTO hun_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","„Amikor imádkozol, ne légy olyan, mint a képmutatók, akik a gyülekezetekben és az utcák szegletein fennállva szeretnek imádkozni, hogy lássák őket az emberek. Bizony mondom néktek: megkapták jutalmukat. ");
INSERT INTO hun_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Te pedig, amikor imádkozol, menj be belső szobádba, és ajtódat bezárva imádkozzál a te Atyádhoz titokban; és a te Atyád, aki a titokban is lát, megfizet neked. ");
INSERT INTO hun_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Amikor imádkoztok, ne legyetek sokbeszédűek, mint a pogányok, akik azt gondolják, hogy a sok beszédükért hallgattatnak meg. ");
INSERT INTO hun_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ne legyetek hát ezekhez hasonlók, mert jól tudja a ti Atyátok, mire van szükségetek, mielőtt kérnétek tőle. ");
INSERT INTO hun_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ti ezért így imádkozzatok: »Mi Atyánk, ki vagy a mennyekben, szenteltessék meg a te neved; ");
INSERT INTO hun_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","jöjjön el a te országod; legyen meg a te akaratod, mint a mennyben, úgy a földön is. ");
INSERT INTO hun_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","A mi mindennapi kenyerünket add meg nekünk ma, ");
INSERT INTO hun_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","és bocsásd meg a mi vétkeinket, miképpen mi is megbocsátunk az ellenünk vétkezőknek; ");
INSERT INTO hun_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","és ne vígy minket kísértésbe, de szabadíts meg a gonosztól; mert tied az ország, a hatalom és a dicsőség mindörökké. Ámen!« ");
INSERT INTO hun_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Mert ha megbocsátjátok az embereknek az ő vétkeiket, megbocsát nektek is mennyei Atyátok. ");
INSERT INTO hun_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ha pedig nem bocsátjátok meg az embereknek vétkeiket, mennyei Atyátok sem bocsátja meg a ti vétkeiteket. ");
INSERT INTO hun_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","„Amikor pedig böjtöltök, ne legyen komor a nézésetek, mint a képmutatóké, akik eltorzítják arcukat, hogy lássák az emberek, hogy ők böjtölnek. Bizony mondom néktek, elvették jutalmukat. ");
INSERT INTO hun_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Te pedig, amikor böjtölsz, kend meg fejedet, és orcádat mosd meg, ");
INSERT INTO hun_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","hogy ne az emberek lássák böjtölésedet, hanem a te Atyád, aki titkon van, és a te Atyád, aki a titokban is lát, megfizet neked. ");
INSERT INTO hun_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","„Ne gyűjtsetek magatoknak kincseket a földön, ahol a rozsda és a moly megemészti, és ahol a tolvajok kiássák és ellopják, ");
INSERT INTO hun_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","hanem gyűjtsetek magatoknak kincseket a mennyben, ahol sem a rozsda, sem a moly meg nem emészti, és ahol a tolvajok ki nem ássák, sem el nem lopják. ");
INSERT INTO hun_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Mert ahol a ti kincsetek van, ott van a ti szívetek is. ");
INSERT INTO hun_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","„A test lámpása a szem. Azért, ha a szemed tiszta, az egész tested világos lesz. ");
INSERT INTO hun_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ha pedig a szemed gonosz, az egész tested sötét lesz. Ezért, ha a benned lévő világosság sötétség, mekkora akkor a sötétség! ");
INSERT INTO hun_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","„Senki sem szolgálhat két úrnak. Mert vagy az egyiket gyűlöli, és a másikat szereti, vagy az egyikhez ragaszkodik, és a másikat megveti. Nem szolgálhattok Istennek és a mammonnak. ");
INSERT INTO hun_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","„Ezért ezt mondom nektek: Ne aggodalmaskodjatok az életetek miatt, hogy mit egyetek, és mit igyatok; sem a testetek miatt, hogy mibe öltözködjetek. Mert nem több-e az élet, mint az eledel, és a test, mint az öltözet? ");
INSERT INTO hun_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Tekintsetek az égi madarakra: nem vetnek, nem aratnak, sem csűrbe nem takarnak, és a ti mennyei Atyátok eltartja azokat. Nem sokkal különbek vagytok-e azoknál? ");
INSERT INTO hun_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Kicsoda pedig közületek az, aki aggodalmaskodásával megnövelheti termetét egy arasszal? ");
INSERT INTO hun_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Az öltözet miatt is miért aggodalmaskodtok? Figyeljétek meg a mező liliomait, hogyan növekednek: nem munkálkodnak, és nem fonnak, ");
INSERT INTO hun_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","de mondom nektek, hogy Salamon minden dicsőségében sem öltözködött úgy, mint ezek közül egy. ");
INSERT INTO hun_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ha pedig a mezőnek füvét, amely ma van, és holnap kemencébe vetik, így ruházza fel az Isten, nem sokkal inkább titeket, ti kicsinyhitűek? ");
INSERT INTO hun_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ne aggodalmaskodjatok tehát, és ne mondjátok: Mit együnk? Vagy: Mit igyunk? Vagy: Mivel ruházkodjunk? ");
INSERT INTO hun_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Mert mindezeket a pogányok kérdezik. Mert jól tudja mennyei Atyátok, hogy mindezekre szükségetek van. ");
INSERT INTO hun_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Hanem keressétek először Istennek országát és igazságát, és ezek mind megadatnak nektek. ");
INSERT INTO hun_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ne aggodalmaskodjatok tehát a holnap miatt, mert a holnap majd aggodalmaskodik a maga dolgai miatt. Elég minden napnak a maga baja.“ ");
INSERT INTO hun_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","„Ne ítéljetek, hogy ne ítéltessetek! ");
INSERT INTO hun_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Mert amilyen ítélettel ítéltek, olyannal ítéltettek, és amilyen mértékkel mértek, olyannal mérnek nektek is. ");
INSERT INTO hun_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Miért nézed a szálkát, amely atyádfia szemében van, a gerendát pedig, amely a te szemedben van, nem veszed észre? ");
INSERT INTO hun_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Vagy hogyan mondhatod a te atyádfiának: Hadd vegyem ki a szálkát a szemedből! – holott íme, a te szemedben gerenda van? ");
INSERT INTO hun_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Képmutató, vedd ki előbb a gerendát a te szemedből, és akkor gondolj arra, hogy kivedd a szálkát atyádfiának szeméből! ");
INSERT INTO hun_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","„Ne adjátok az ebeknek azt, ami szent, se gyöngyeitekből ne hányjatok a disznók elé, hogy meg ne tapossák azokat lábaikkal, és ellenetek fordulva szét ne tépjenek titeket. ");
INSERT INTO hun_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","„Kérjetek, és adatik nektek, keressetek, és találtok, zörgessetek, és megnyittatik nektek. ");
INSERT INTO hun_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Mert aki kér, mind kap, aki keres, talál, és a zörgetőnek megnyittatik. ");
INSERT INTO hun_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Vagy ki az az ember közületek, aki ha az ő fia kenyeret kér tőle, követ ad neki? ");
INSERT INTO hun_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","És ha halat kér, vajon kígyót ad-e neki? ");
INSERT INTO hun_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ha tehát ti gonosz létetekre tudtok fiaitoknak jó ajándékokat adni, mennyivel inkább ad mennyei Atyátok jókat azoknak, akik kérnek tőle? ");
INSERT INTO hun_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","„Ezért amit akartok, hogy az emberek veletek cselekedjenek, mindazt cselekedjétek velük ti is, mert ez a törvény és a próféták. ");
INSERT INTO hun_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","„Menjetek be a szoros kapun! Mert tágas az a kapu, és széles az az út, amely a veszedelemre visz, és sokan vannak, akik azon járnak. ");
INSERT INTO hun_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Mert szoros az a kapu, és keskeny az az út, amely az életre visz, és kevesen vannak, akik megtalálják azt. ");
INSERT INTO hun_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Őrizkedjetek a hamis prófétáktól, akik juhok ruhájában jönnek hozzátok, de belül ragadozó farkasok. ");
INSERT INTO hun_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Gyümölcseikről ismeritek meg őket. Vajon a tövisről szednek-e szőlőt vagy a bojtorjánról fügét? ");
INSERT INTO hun_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ekképpen minden jó fa jó gyümölcsöt terem, a romlott fa pedig rossz gyümölcsöt terem. ");
INSERT INTO hun_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Nem teremhet jó fa rossz gyümölcsöt; romlott fa sem teremhet jó gyümölcsöt. ");
INSERT INTO hun_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Minden fa, amely nem terem jó gyümölcsöt, kivágattatik, és tűzre vettetik. ");
INSERT INTO hun_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Tehát gyümölcseikről ismeritek meg őket. ");
INSERT INTO hun_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","„Nem mindenki megy be a mennyek országába, aki ezt mondja nekem: Uram, Uram, hanem csak az, aki cselekszi az én mennyei Atyámnak akaratát. ");
INSERT INTO hun_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Sokan mondják majd nekem ama napon: Uram, Uram, nem a te nevedben prófétáltunk-e, és nem a te nevedben űztünk-e ki ördögöket, és nem cselekedtünk-e sok hatalmas dolgot a te nevedben? ");
INSERT INTO hun_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","És akkor kijelentem nekik: Sohasem ismertelek titeket, távozzatok tőlem, ti gonosztevők! ");
INSERT INTO hun_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","„Ezért ha valaki hallja tőlem ezeket a beszédeket, és cselekszi azokat, hasonlítom azt a bölcs emberhez, aki kősziklára építette házát. ");
INSERT INTO hun_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","És ömlött az eső, eljött az árvíz, fújtak a szelek, és beleütköztek abba a házba, de nem dőlt össze, mert a kősziklára építették. ");
INSERT INTO hun_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","És ha valaki hallja tőlem ezeket a beszédeket, és nem cselekszi azokat, hasonlatos lesz a bolond emberhez, aki a fövenyre építette házát. ");
INSERT INTO hun_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","És ömlött az eső, eljött az árvíz, fújtak a szelek, és beleütköztek abba a házba; az összeomlott, és nagy lett a romlása.“ ");
INSERT INTO hun_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Amikor befejezte Jézus ezeket a beszédeket, álmélkodott a sokaság a tanításán, ");
INSERT INTO hun_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","mert úgy tanította őket, mint akinek hatalma van, és nem úgy, mint az írástudók. ");
INSERT INTO hun_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Mikor lejött a hegyről, nagy sokaság követte őt, ");
INSERT INTO hun_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","És íme, odajött egy bélpoklos, leborult előtte, és mondta: „Uram, ha akarod, megtisztíthatsz engem.“ ");
INSERT INTO hun_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jézus kinyújtotta kezét, megérintette, és ezt mondta: „Akarom, tisztulj meg.“ És azonnal eltisztult annak poklossága. ");
INSERT INTO hun_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ekkor ezt mondta neki Jézus: „Vigyázz, senkinek se szólj. Hanem eredj, mutasd meg magadat a papnak, és vidd fel az ajándékot, amelyet Mózes rendelt, bizonyságul nekik.“ ");
INSERT INTO hun_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Mikor pedig bement Jézus Kapernaumba, egy százados ment hozzá, és kérte őt. ");
INSERT INTO hun_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Ezt mondta: „Uram, a szolgám otthon gutaütötten fekszik, és nagy kínokat szenved.“ ");
INSERT INTO hun_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ezt mondta neki Jézus: „Elmegyek, és meggyógyítom.“ ");
INSERT INTO hun_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","De a százados ezt felelte neki: „Uram, nem vagyok méltó, hogy az én hajlékomba jöjj, hanem csak szólj egy szót, és meggyógyul az én szolgám. ");
INSERT INTO hun_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Mert én is hatalom alá rendelt ember vagyok, és vannak alattam vitézek, és ha azt mondom egyiknek: Eredj el, elmegy; és a másiknak: Gyere ide, odajön; és a szolgámnak: Tedd ezt, megteszi.“ ");
INSERT INTO hun_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jézus pedig amikor ezt meghallotta, elcsodálkozott, és ezt mondta az őt követőknek: „Bizony mondom néktek, még Izraelben sem találtam ilyen nagy hitet. ");
INSERT INTO hun_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","De mondom nektek, sokan jönnek majd napkeletről és napnyugatról, letelepednek Ábrahámmal, Izsákkal és Jákóbbal a mennyeknek országában; ");
INSERT INTO hun_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","az ország fiait pedig kivetik a külső sötétségre, ahol lesz majd sírás és fogcsikorgatás.“ ");
INSERT INTO hun_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","És Jézus ezt mondta a századosnak: „Eredj el, és legyen néked a te hited szerint.“ És meggyógyult annak szolgája, abban az órában. ");
INSERT INTO hun_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Amikor bement Jézus Péter házába, és látta, hogy annak anyósa fekszik és lázas, ");
INSERT INTO hun_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","rátette kezét, és elhagyta őt a láz, fölkelt, és szolgált nekik. ");
INSERT INTO hun_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Az est beálltával pedig kivittek hozzá sok ördöngöst, és egy szóval kiűzte a tisztátalan lelkeket, és meggyógyított minden beteget; ");
INSERT INTO hun_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","hogy beteljesedjék, amit Ézsaiás próféta mondott így szólván: „Ő vette el a mi erőtlenségünket, és ő hordozta el a mi betegségünket.“ ");
INSERT INTO hun_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Látván pedig Jézus a nagy sokaságot maga körül, megparancsolta, hogy menjenek át a túlsó partra. ");
INSERT INTO hun_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Hozzámenve egy írástudó, ezt mondta neki: „Mester, követlek téged, akárhová mégy.“ ");
INSERT INTO hun_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jézus pedig így válaszolt: „A rókáknak van barlangjuk, és az égi madaraknak fészkük, de az Emberfiának nincs hová fejét lehajtania.“ ");
INSERT INTO hun_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Egy másik a tanítványai közül ezt mondta neki: „Uram, engedd meg, hogy előbb elmenjek, és eltemessem atyámat.“ ");
INSERT INTO hun_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jézus pedig ezt mondta neki: „Kövess engem, és hagyd, hogy a halottak temessék el halottaikat.“ ");
INSERT INTO hun_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Amikor hajóra szállt, követték őt tanítványai. ");
INSERT INTO hun_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","És íme, nagy vihar támadt a tengeren, annyira, hogy a hajót elborították a hullámok, ő pedig aludt. ");
INSERT INTO hun_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Tanítványai pedig odamentek hozzá, felköltötték, és ezt mondták: „Uram, ments meg minket, mert elveszünk.“ ");
INSERT INTO hun_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","De ő ezt mondta nekik: „Mit féltek, ó, kicsinyhitűek?“ Ekkor fölkelt, megdorgálta a szeleket és a tengert, és nagy csendesség lett. ");
INSERT INTO hun_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Az emberek pedig elcsodálkoztak, és mondták: „Kicsoda ez, hogy mind a szelek, mind a tenger engedelmeskedik neki?“ ");
INSERT INTO hun_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Amikor eljutottak a túlsó partra, a gadaraiak tartományába, két ördöngös ment eléje, akik a sírboltokból kijőve igen kegyetlenkedtek, annyira, hogy senki sem mert azon az úton járni. ");
INSERT INTO hun_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Kiáltoztak, és ezt mondták: „Mi közünk hozzád, Jézus, Istennek Fia? Azért jöttél ide, hogy idő előtt meggyötörj minket?“ ");
INSERT INTO hun_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Tőlük távol pedig egy nagy disznónyáj legelészett. ");
INSERT INTO hun_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Az ördögök pedig kérték őt, és ezt mondták: „Ha kiűzöl minket, engedd meg, hogy abba a disznónyájba mehessünk!“ ");
INSERT INTO hun_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ő pedig ezt mondta nekik: „Menjetek!“ Azok pedig kimenve, belementek a disznónyájba. És íme, az egész disznónyáj a meredekről a tengerbe rohant, és odaveszett a vízbe. ");
INSERT INTO hun_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","A pásztorok pedig elfutottak, bementek a városba, és hírül adtak mindent, azt is, ami az ördöngösökkel történt. ");
INSERT INTO hun_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Íme, az egész város kiment Jézus elé, és mihelyst meglátták, kérték őt, hogy távozzék az ő határukból. ");
INSERT INTO hun_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Hajóra szállva átkelt, és elment az ő városába. ");
INSERT INTO hun_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","És íme, hoztak hozzá egy ágyban fekvő gutaütött embert. Látva Jézus ezeknek hitét, ezt mondta a gutaütöttnek: „Bízzál, fiam! Megbocsáttattak neked a te bűneid.“ ");
INSERT INTO hun_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Némelyek az írástudók közül ezt mondták magukban: „Ez káromlást szól.“ ");
INSERT INTO hun_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jézus látta a gondolataikat, és ezt mondta: „Miért gondoltok gonoszat a ti szívetekben? ");
INSERT INTO hun_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Mert mi könnyebb, ezt mondani: Megbocsáttattak néked a te bűneid! vagy ezt mondani: Kelj föl és járj! – ");
INSERT INTO hun_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Azért, hogy megtudjátok, hogy az Emberfiának van hatalma a földön a bűnöket megbocsátani – mondta a gutaütöttnek: Kelj föl, vedd az ágyadat és eredj haza.“ ");
INSERT INTO hun_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","És az felkelt, és hazament. ");
INSERT INTO hun_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","A sokaság pedig ezt látva elálmélkodott, és dicsőítette az Istent, hogy ilyen hatalmat adott az embereknek. ");
INSERT INTO hun_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Amikor Jézus onnét továbbment, látott egy embert ülni a vámszedő helyen, akinek Máté volt a neve, és ezt mondta neki: „Kövess engem!“ És az felkelt, és követte őt. ");
INSERT INTO hun_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Amikor letelepedtek a házban, sok vámszedő és bűnös jött oda, letelepedtek Jézussal és tanítványaival az asztalhoz. ");
INSERT INTO hun_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Látva ezt a farizeusok, ezt mondták az ő tanítványainak: „Miért eszik mesteretek a vámszedőkkel és bűnösökkel együtt?“ ");
INSERT INTO hun_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jézus pedig ezt meghallotta, és ezt mondta nekik: „Nem az egészségeseknek van szüksége orvosra, hanem a betegeknek. ");
INSERT INTO hun_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Menjetek el, és tanuljátok meg, mit jelent ez: »Irgalmasságot akarok és nem áldozatot.« Mert nem az igazakat jöttem hívogatni, hanem a bűnösöket a megtérésre.“ ");
INSERT INTO hun_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Akkor János tanítványai jöttek hozzá, és ezt mondták: „Miért van az, hogy mi és a farizeusok sokat böjtölünk, a te tanítványaid pedig nem böjtölnek?“ ");
INSERT INTO hun_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ezt mondta nekik Jézus: „Vajon szomorkodhat-e a násznép, amíg velük van a vőlegény? De eljönnek a napok, mikor elvétetik tőlük a vőlegény, és akkor böjtölni fognak. ");
INSERT INTO hun_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Senki sem rak új posztóból foltot az ócska ruhára, mert ami azt kitoldaná, még tovább szakít a ruhából, és még nagyobb szakadás támad. ");
INSERT INTO hun_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Új bort sem töltenek régi tömlőkbe, mert akkor a tömlők szétszakadoznak, és a bor kiömlik, a tömlők is elvesznek; hanem az új bort új tömlőkbe töltik, és mindkettő megmarad.“ ");
INSERT INTO hun_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Mikor ezeket mondta, odajött egy főember, leborult előtte, és ezt mondta: „Az én lányom éppen most halt meg, de gyere, tedd rá kezedet, és megelevenedik.“ ");
INSERT INTO hun_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jézus felkelt, és követte őt tanítványaival együtt. ");
INSERT INTO hun_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","És íme, egy asszony, aki tizenkét éve vérfolyásban szenvedett, hozzáférkőzve hátulról, megérintette ruhájának szegélyét, ");
INSERT INTO hun_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","mert azt mondta magában: „Ha csak ruháját érintem is, meggyógyulok.“ ");
INSERT INTO hun_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jézus pedig megfordult, rátekintett, és ezt mondta: „Bízzál, leányom, a hited megtartott téged.“ És meggyógyult az asszony, abban az órában. ");
INSERT INTO hun_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Jézus a főember házához érve meglátta a sípolókat és a sokaságot, ");
INSERT INTO hun_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","és ezt mondta nekik: „Menjetek innen, mert a lány nem halt meg, csak alszik.“ Azok kinevették őt. ");
INSERT INTO hun_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Mikor pedig a sokaságot eltávolították, bement, megfogta a kezét, és a lány felkelt. ");
INSERT INTO hun_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ez a hír elterjedt az egész tartományban. ");
INSERT INTO hun_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Mikor Jézus továbbment onnan, két vak követte őt, kiáltoztak, és ezt mondták: „Könyörülj rajtunk, Dávidnak fia!“ ");
INSERT INTO hun_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Amikor bement a házba, odamentek a vakok, és ezt mondta nekik Jézus: „Hiszitek-e, hogy én ezt megcselekedhetem?“ Ezt mondták neki: „Igen, Uram.“ ");
INSERT INTO hun_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Akkor megérintette szemeiket, és ezt mondta: „Legyen nektek a ti hitetek szerint.“ ");
INSERT INTO hun_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","És megnyíltak szemeik, Jézus pedig rájuk parancsolt, és ezt mondta: „Vigyázzatok, senki meg ne tudja!“ ");
INSERT INTO hun_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Azok pedig kimentek, és elterjesztették hírét az egész tartományban. ");
INSERT INTO hun_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Mikor pedig elmentek, egy ördöngös néma embert hoztak oda hozzá. ");
INSERT INTO hun_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Az ördögöt kiűzte, és megszólalt a néma, a sokaság pedig csodálkozva mondta: „Soha nem láttak ilyet Izraelben!“ ");
INSERT INTO hun_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","A farizeusok pedig ezt mondták: „Az ördögök fejedelme által űzi ki az ördögöket.“ ");
INSERT INTO hun_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Körüljárta Jézus a városokat és a falvakat mind, tanított a zsinagógáikban, és hirdette az Isten országának evangéliumát, gyógyított mindenféle betegséget és mindenféle erőtlenséget a nép között. ");
INSERT INTO hun_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Mikor látta a sokaságot, könyörületességre indult rajtuk, mert elgyötörtek és elesettek voltak, mint a pásztor nélküli juhok. ");
INSERT INTO hun_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ekkor ezt mondta tanítványainak: „Az aratnivaló sok, de a munkás kevés. ");
INSERT INTO hun_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Kérjétek azért az aratás Urát, hogy küldjön munkásokat az ő aratásába.“ ");
INSERT INTO hun_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Előszólította tizenkét tanítványát, hatalmat adott nekik a tisztátalan lelkek felett, hogy kiűzzék azokat, és gyógyítsanak minden betegséget és erőtlenséget. ");
INSERT INTO hun_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","A tizenkét apostol nevei pedig ezek: első Simon, akit Péternek hívnak, és András, az ő testvére; Jakab, Zebedeus fia és János, az ő testvére; ");
INSERT INTO hun_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Fülöp és Bertalan, Tamás és Máté, a vámszedő; Jakab, Alfeus fia és Lebbeus, akit Taddeusnak hívtak; ");
INSERT INTO hun_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simon, a kananita és Júdás, az Iskariótes, aki el is árulta őt. ");
INSERT INTO hun_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ezt a tizenkettőt küldte el Jézus, és megparancsolta nekik: „Pogányok útjára ne menjetek, és samaritánusok városába ne menjetek be, ");
INSERT INTO hun_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","hanem menjetek inkább Izrael házának eltévelyedett juhaihoz. ");
INSERT INTO hun_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Menjetek el, és prédikáljatok, mondjátok: Elközelített a mennyek országa! ");
INSERT INTO hun_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Betegeket gyógyítsatok, poklosokat tisztítsatok, halottakat támasszatok, ördögöket űzzetek. Ingyen vettétek, ingyen adjátok. ");
INSERT INTO hun_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ne szerezzetek se aranyat, se ezüstöt, se rézpénzt erszényetekbe. ");
INSERT INTO hun_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Se útitáskát, se két ruhát, se sarut, se pálcát, mert méltó a munkás a kenyerére. ");
INSERT INTO hun_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ha pedig egy városba vagy faluba bementek, tudjátok meg, ki méltó ott erre, és maradjatok ott, amíg tovább nem indultok. ");
INSERT INTO hun_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ha bementek a házába, köszöntsétek. ");
INSERT INTO hun_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","És ha méltó a ház, szálljon a ti békességetek reá, ha pedig nem méltó, a ti békességetek rátok térjen vissza. ");
INSERT INTO hun_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ha valaki nem fogad be titeket, és nem hallgatja a beszédeteket, amikor kimentek abból a házból vagy városból, lábaitok porát is verjétek le. ");
INSERT INTO hun_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Bizony mondom néktek: az ítélet napján könnyebb lesz Sodoma és Gomora földjének dolga, mint annak a városnak. ");
INSERT INTO hun_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Íme, én elbocsátlak titeket, mint juhokat a farkasok közé, legyetek azért okosak, mint a kígyók, és szelídek, mint a galambok. ");
INSERT INTO hun_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Óvakodjatok az emberektől, mert törvényszékre adnak titeket, és gyülekezeteikben megostoroznak titeket, ");
INSERT INTO hun_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","helytartók és királyok elé visznek érettem, bizonyságul maguknak és a pogányoknak. ");
INSERT INTO hun_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Amikor átadnak titeket, ne aggodalmaskodjatok, miképpen vagy mit szóljatok, mert megadatik nektek abban az órában, hogy mit mondjatok. ");
INSERT INTO hun_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Mert nem ti vagytok, akik szóltok, hanem Atyátoknak Lelke az, aki szól tibennetek. ");
INSERT INTO hun_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Halálra adja majd testvér testvérét, atya gyermekét, gyermekek támadnak szüleik ellen, és megöletik őket. ");
INSERT INTO hun_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Gyűlöletesek lesztek mindenki előtt az én nevemért, de aki mindvégig megáll, az megtartatik. ");
INSERT INTO hun_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Amikor pedig egy városban üldöznek titeket, szaladjatok a másikba. Mert bizony mondom néktek, be sem járjátok Izrael városait, mire az Emberfia eljön. ");
INSERT INTO hun_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Nem följebbvaló a tanítvány a tanítónál, sem a szolga az ő uránál. ");
INSERT INTO hun_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Elég a tanítványnak, ha olyan, mint a mestere, és a szolga, mint az ő Ura. Ha a házigazdát Belzebubnak hívták, mennyivel inkább az ő házanépét? ");
INSERT INTO hun_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Ezért ne féljetek tőlük. Mert nincs olyan rejtett dolog, ami napfényre ne jönne, és olyan titok, ami ki ne tudódnék. ");
INSERT INTO hun_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Amit nektek a sötétben mondok, azt a világosságban mondjátok el; amit fülbe súgva hallotok, a háztetőkről hirdessétek. ");
INSERT INTO hun_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ne féljetek azoktól, akik a testet ölik meg, de a lelket meg nem ölhetik. Hanem attól féljetek inkább, aki mind a lelket, mind a testet elveszítheti a gyehennában. ");
INSERT INTO hun_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ugye két verebecskét meg lehet venni egy fillérért, és egy sem esik közülük a földre a ti Atyátok akarata nélkül? ");
INSERT INTO hun_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Nektek még a fejetek hajszálai is mind számon vannak tartva. ");
INSERT INTO hun_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ne féljetek tehát: ti sok verebecskénél drágábbak vagytok. ");
INSERT INTO hun_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Aki tehát vallást tesz énrólam az emberek előtt, én is vallást teszek arról az én mennyei Atyám előtt, ");
INSERT INTO hun_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","aki pedig megtagad engem az emberek előtt, én is megtagadom azt az én mennyei Atyám előtt. ");
INSERT INTO hun_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Ne gondoljátok, hogy azért jöttem, hogy békességet hozzak a földre. Nem azért jöttem, hogy békességet hozzak, hanem hogy fegyvert. ");
INSERT INTO hun_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Mert azért jöttem, »hogy meghasonlást támasszak az ember és az atyja, a leány és az anyja, a meny és az anyósa közt, ");
INSERT INTO hun_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","és hogy az embernek ellensége legyen az ő házanépe.« ");
INSERT INTO hun_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Aki inkább szereti atyját és anyját, mint engem, nem méltó énhozzám; és aki inkább szereti fiát és lányát, mint engem, nem méltó énhozzám; ");
INSERT INTO hun_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","és aki nem veszi föl az ő keresztjét, és nem követ engem, nem méltó énhozzám. ");
INSERT INTO hun_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Aki megtalálja életét, elveszíti azt, és aki elveszíti az ő életét énérettem, megtalálja azt. ");
INSERT INTO hun_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Aki titeket befogad, engem fogad be, és aki engem befogad, azt fogadja be, aki engem küldött. ");
INSERT INTO hun_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Aki befogadja a prófétát próféta nevében, prófétának jutalmát veszi; és aki befogadja az igazat igaznak nevében, igaznak jutalmát veszi. ");
INSERT INTO hun_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Aki inni ad egynek e kicsinyek közül, csak egy pohár hideg vizet, mert az én tanítványom, bizony mondom néktek, el nem vesztheti jutalmát.“ ");
INSERT INTO hun_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Amikor elvégezte Jézus a tizenkét tanítványnak adott utasítást, elment onnan, hogy tanítson és prédikáljon a városokban. ");
INSERT INTO hun_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","János pedig, amikor a fogságban ülve hallott Krisztus cselekedeteiről, elküldött hozzá kettőt tanítványai közül. ");
INSERT INTO hun_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ezt mondta neki: „Te vagy-e az, aki eljövendő, vagy pedig mást várjunk?“ ");
INSERT INTO hun_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jézus ezt mondta nekik: „Menjetek el, és jelentsétek Jánosnak, amiket hallotok és láttok: ");
INSERT INTO hun_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","a vakok látnak, a sánták járnak, a poklosok megtisztulnak, a süketek hallanak, a halottak feltámadnak, és a szegényeknek evangélium hirdettetik. ");
INSERT INTO hun_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Boldog, aki énbennem meg nem botránkozik.“ ");
INSERT INTO hun_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Amikor pedig ezek elmentek, Jézus beszélni kezdett a sokasághoz Jánosról: „Mit mentetek ki látni a pusztába? Nádszálat, amit a szél hajtogat? ");
INSERT INTO hun_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Vagy mit mentetek ki látni? Puha ruhába öltözött embert? Akik puha ruhákat viselnek, királyok palotáiban vannak. ");
INSERT INTO hun_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Vagy mit mentetek ki látni? Prófétát? Bizony mondom néktek, prófétánál is nagyobbat. ");
INSERT INTO hun_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Mert ő az, akiről meg van írva: »Íme, elküldöm követemet a te arcod előtt, aki elkészíti előtted utadat.« ");
INSERT INTO hun_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Bizony mondom néktek: az asszonyoktól születettek között nem támadott nagyobb Keresztelő Jánosnál; de aki a legkisebb a mennyek országában, nagyobb nála. ");
INSERT INTO hun_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Keresztelő János idejétől fogva mind a mai napig erőszakoskodnak a mennyek országáért, és az erőszakoskodók ragadják el azt. ");
INSERT INTO hun_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Mert minden próféta, és a törvény Jánosig ezt prófétálta. ");
INSERT INTO hun_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","És ha tudni akarjátok, ő Illés, akinek el kell jönnie. ");
INSERT INTO hun_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Akinek van füle a hallásra, hallja meg. ");
INSERT INTO hun_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Kihez hasonlítsam ezt a nemzetséget? Hasonlatos a gyermekekhez, akik a piacon ülnek, és kiáltoznak társaiknak: ");
INSERT INTO hun_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","»Sípoltunk nektek és nem táncoltatok; siralmas énekeket énekeltünk nektek, és nem sírtatok.« ");
INSERT INTO hun_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Mert eljött János, aki nem eszik, nem iszik, és ezt mondják: Ördög van benne. ");
INSERT INTO hun_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Eljött az Emberfia, aki eszik és iszik, és ezt mondják: Íme, a nagyétkű és részeges ember, a vámszedők és bűnösök barátja. De a bölcsesség fiai igazolni fogják.“ ");
INSERT INTO hun_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ekkor elkezdett szemrehányást tenni azoknak a városoknak, melyekben a legtöbb csoda történt, hogy nem tértek meg: ");
INSERT INTO hun_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","„Jaj néked, Korazin! Jaj néked, Bétsaida! Mert ha Tíruszban és Szidónban történtek volna azok a csodák, amelyek bennetek voltak, rég megtértek volna gyászruhában és hamuban. ");
INSERT INTO hun_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","De mondom nektek: Tírusznak és Szidónnak könnyebb dolga lesz az ítélet napján, mint nektek. ");
INSERT INTO hun_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Te is Kapernaum, aki az égig felmagasztaltattál, a pokolig fogsz megaláztatni! Mert ha Sodomában történtek volna azok a csodák, amelyek tebenned történtek, mind a mai napig megmaradt volna. ");
INSERT INTO hun_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","De mondom nektek, hogy Sodoma földjének könnyebb dolga lesz az ítélet napján, mint neked.“ ");
INSERT INTO hun_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Abban az időben így szólt Jézus, és ezt mondta: „Hálát adok néked, Atyám, mennynek és földnek Ura, mert elrejtetted ezeket a bölcsek és értelmesek elől, és a kicsinyeknek jelentetted ki. ");
INSERT INTO hun_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Igen, Atyám, mert így volt kedves előtted. ");
INSERT INTO hun_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Mindent nekem adott át Atyám, és senki sem ismeri a Fiút, csak az Atya, és az Atyát sem ismeri senki, csak a Fiú, és az, akinek a Fiú akarja kijelentetni. ");
INSERT INTO hun_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Jöjjetek énhozzám mindnyájan, akik megfáradtatok, és meg vagytok terhelve, és én megnyugtatlak titeket. ");
INSERT INTO hun_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Vegyétek föl magatokra az én igámat, és tanuljátok meg tőlem, hogy szelíd és alázatos szívű vagyok, és nyugalmat találtok lelketeknek. ");
INSERT INTO hun_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Mert az én igám gyönyörűséges, és az én terhem könnyű.“ ");
INSERT INTO hun_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Abban az időben Jézus a vetéseken át haladt szombatnapon, tanítványai pedig megéheztek, és elkezdték a kalászokat tépni és enni. ");
INSERT INTO hun_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Látták ezt a farizeusok és ezt mondták neki: „Íme, a tanítványaid azt cselekszik, amit nem szabad szombatnapon cselekedni.“ ");
INSERT INTO hun_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ő pedig ezt válaszolta nekik: „Nem olvastátok, mit tett Dávid, amikor megéhezett ő, és akik vele voltak? ");
INSERT INTO hun_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Hogyan ment be az Isten házába, és ette meg a szentelt kenyereket, amelyeket nem volt szabad megenni neki, sem azoknak, akik ővele voltak, csak a papoknak? ");
INSERT INTO hun_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Vagy nem olvastátok a törvényben, hogy szombatnapon megtörik a papok a szombatot a templomban, és nem vétkeznek? ");
INSERT INTO hun_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Mondom nektek, hogy még a templomnál is nagyobb van itt. ");
INSERT INTO hun_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ha pedig tudnátok, mi ez: »Irgalmasságot akarok és nem áldozatot« – nem ítéltétek volna el az ártatlanokat. ");
INSERT INTO hun_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Mert a szombatnak is Ura az Emberfia.“ ");
INSERT INTO hun_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Továbbmenve onnan elment a zsinagógába. ");
INSERT INTO hun_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","És íme, ott volt egy elszáradt kezű ember. És megkérdezték őt: „Szabad-e szombatnapon gyógyítani?“ – hogy vádolhassák őt. ");
INSERT INTO hun_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ő pedig ezt mondta nekik: „Kicsoda közületek az az ember, akinek van egy juha, és ha az szombatnapon a verembe esik, nem ragadja meg, és nem húzza ki? ");
INSERT INTO hun_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Az ember pedig mennyivel drágább a juhnál? Szabad tehát szombatnapon jót cselekedni.“ ");
INSERT INTO hun_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ekkor ezt mondta ennek az embernek: „Nyújtsd ki a kezedet.“ Az kinyújtotta, és olyan éppé lett, mint a másik. ");
INSERT INTO hun_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","A farizeusok pedig kimentek, tanácsot tartottak ellene, hogyan veszíthetnék el őt. ");
INSERT INTO hun_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jézus észrevette ezt, és eltávozott onnan. Nagy sokaság követte őt, és ő meggyógyította mindnyájukat. ");
INSERT INTO hun_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Megfenyegette őket, hogy hírét el ne terjesszék; ");
INSERT INTO hun_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","hogy beteljesedjék Ézsaiás próféta mondása, aki így szólt: ");
INSERT INTO hun_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","„Íme, az én szolgám, akit választottam, aki én szeretek, akiben az én lelkem kedvét leli! Lelkemet adom belé, és ítéletet hirdet a pogányoknak. ");
INSERT INTO hun_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Nem verseng, és nem kiált, az utcákon senki nem hallja szavát. ");
INSERT INTO hun_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","A megrepedezett nádat nem töri el, a pislogó gyertyabelet nem oltja ki, míg diadalra nem viszi az ítéletet. ");
INSERT INTO hun_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","És az ő nevében reménykednek majd a pogányok.“ ");
INSERT INTO hun_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Akkor egy vak és néma ördöngöst hoztak hozzá, és meggyógyította őt annyira, hogy a vak és néma ember attól fogva beszélt és látott. ");
INSERT INTO hun_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Elálmélkodott az egész sokaság, és ezt mondta: „Vajon nem ő Dávidnak Fia?“ ");
INSERT INTO hun_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","A farizeusok hallották ezt, és ezt mondták: „Nem ő űzi ki az ördögöket, hanem Belzebubbal, az ördögök fejedelmének segítségével teszi ezt.“ ");
INSERT INTO hun_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jézus pedig ismerve gondolataikat ezt mondta: „Minden ország, amely magával meghasonlik, elpusztul, és egy város vagy egy háznép sem maradhat fenn, amely meghasonlik önmagával. ");
INSERT INTO hun_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ha pedig a Sátán Sátánt űz ki, önmagával hasonlott meg, és akkor hogyan maradhat fenn országa? ");
INSERT INTO hun_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","És ha én Belzebub által űzöm ki az ördögöket, a ti fiaitok ki által űzik ki? Ezért ők maguk lesznek a ti bíráitok. ");
INSERT INTO hun_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ha pedig én Istennek Lelke által űzöm ki az ördögöket, akkor kétség nélkül elérkezett hozzátok az Isten országa. ");
INSERT INTO hun_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Vagy hogyan mehet be valaki a hatalmasnak házába, és rabolhatja el annak kincseit, hacsak meg nem kötözi előbb a hatalmast, és akkor rabolja ki annak házát? ");
INSERT INTO hun_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Aki nincs velem, ellenem van, és aki nem gyűjt velem, tékozol. ");
INSERT INTO hun_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Azt mondom ezért nektek: Minden bűn és káromlás megbocsáttatik az embereknek, de a Lélek káromlása nem bocsáttatik meg az embereknek. ");
INSERT INTO hun_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Még aki az Emberfia ellen szól, annak is megbocsáttatik, de aki a Szentlélek ellen szól, annak sem ezen, sem a másvilágon meg nem bocsáttatik. ");
INSERT INTO hun_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Vagy legyetek jó fák, és teremjetek jó gyümölcsöt, vagy legyetek romlott fák, és teremjetek romlott gyümölcsöt, mert gyümölcséről ismerik meg a fát. ");
INSERT INTO hun_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Mérges kígyóknak fajzatai, hogyan szólhattok jókat, holott gonoszak vagytok? Mert a szívnek teljességéből szól a száj. ");
INSERT INTO hun_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","A jó ember a szívének jó kincseiből hozza elő a jókat, a gonosz ember a szívének gonosz kincseiből hozza elő a gonoszokat. ");
INSERT INTO hun_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","De mondom néktek: minden hivalkodó beszédért, amit beszélnek az emberek, számot adnak majd az ítélet napján. ");
INSERT INTO hun_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Mert a beszédedből ismernek meg igaznak, és a beszédedből ismernek meg hamisnak.“ ");
INSERT INTO hun_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ekkor feleltek neki némelyek az írástudók és farizeusok közül, és ezt mondták: „Mester, jelt akarunk látni tőled.“ ");
INSERT INTO hun_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ő pedig ezt felelte nekik: „E gonosz és parázna nemzetség jelt kíván, és nem adatik neki más jel, csak a Jónás prófétának jele. ");
INSERT INTO hun_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Mert amint Jónás három éjjel és három nap volt a cethal gyomrában, úgy az Emberfia is három nap és három éjjel lesz a föld gyomrában. ");
INSERT INTO hun_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ninive férfiai az ítéletkor együtt támadnak majd fel ezzel a nemzetséggel, és elítélik ezt, mert ők megtértek Jónás prédikálására; És íme, itt nagyobb van, mint Jónás. ");
INSERT INTO hun_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Dél királynője felkel majd az ítéletkor ezzel a nemzetséggel együtt, és elítéli ezt, mert ő eljött a földnek széléről, hogy hallhassa Salamon bölcsességét; És íme, nagyobb van itt Salamonnál. ");
INSERT INTO hun_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Mikor pedig a tisztátalan lélek kimegy az emberből, víz nélküli helyeken jár nyugalmat keresve, és nem talál. ");
INSERT INTO hun_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Akkor ezt mondja: Visszatérek a házamba, ahonnan kijöttem. És odamenve üresen, kisöpörve és fölékesítve találja azt. ");
INSERT INTO hun_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Akkor elmegy, és vesz maga mellé másik hét lelket, gonoszabbakat magánál, és bemenve ott laknak, és ennek az embernek utolsó állapota gonoszabb lesz az elsőnél. Így lesz ezzel a gonosz nemzetséggel is.“ ");
INSERT INTO hun_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Mikor pedig még beszélt a sokaságnak, íme, anyja és testvérei álltak meg odakinn, és beszélni akartak vele. ");
INSERT INTO hun_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Szólt neki valaki: „Íme, anyád és testvéreid odakinn állnak, és beszélni akarnak veled.“ ");
INSERT INTO hun_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ő pedig így felelt annak, aki szólt: „Ki az én anyám, és kik az én testvéreim?“ ");
INSERT INTO hun_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","És kezét kinyújtva tanítványai felé, ezt mondta: „Íme, az én anyám és az én testvéreim! ");
INSERT INTO hun_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Mert aki cselekszi az én mennyei Atyám akaratát, az nekem fivérem, nővérem és az én anyám.“ ");
INSERT INTO hun_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Azon a napon kiment Jézus a házból, és leült a tenger mellett. ");
INSERT INTO hun_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Nagy sokaság gyűlt köréje, akkora, hogy bement a hajóba leülni, az egész sokaság pedig a parton állt. ");
INSERT INTO hun_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Sokat beszélt nekik példázatokban: „Íme, kiment a magvető vetni, ");
INSERT INTO hun_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","és amikor vetett, némely mag az útszélre esett, s jöttek a madarak, felkapdosták azt. ");
INSERT INTO hun_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Némely pedig a köves helyre esett, ahol nem sok föld volt, és hamar kikelt, mivel nem volt mélyen a földben. ");
INSERT INTO hun_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","De amikor a nap felkelt, kiégett, és mivel nem volt gyökere, elszáradt. ");
INSERT INTO hun_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Némelyek pedig tövisek közé estek, és a tövisek fölnövekedve megfojtották azt. ");
INSERT INTO hun_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Némely pedig a jó földbe esett, és gyümölcsöt termett, némely százannyit, némely hatvanannyit, némely pedig harmincannyit. ");
INSERT INTO hun_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Akinek van füle a hallásra, hallja meg!“ ");
INSERT INTO hun_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","A tanítványok odamentek hozzá, és ezt mondták neki: „Miért beszélsz hozzájuk példázatokban?“ ");
INSERT INTO hun_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ő pedig ezt felelte nekik: „Azért, mert nektek megadatott, hogy megértsétek a mennyek országának titkait, őnekik pedig nem adatott meg. ");
INSERT INTO hun_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Mert akinek van, annak adatik, és bővölködik, de akinek nincs, attól az is elvétetik, amije van. ");
INSERT INTO hun_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Azért szólok nekik példázatokban, mert látván nem látnak, és hallván nem hallanak, sem nem értenek. ");
INSERT INTO hun_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","És beteljesedik rajtuk Ézsaiás jövendölése, amely ezt mondja: »Hallván halljatok, és ne értsetek, és látván lássatok, és ne ismerjetek! ");
INSERT INTO hun_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Mert megkövéredett e nép szíve, füleikkel nehezen hallottak, és szemeiket behunyták, hogy valami módon ne lássanak szemeikkel, ne halljanak füleikkel, és ne értsenek szívükkel, és meg ne térjenek, és meg ne gyógyítsam őket.« ");
INSERT INTO hun_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","A ti szemeitek boldogok, hogy látnak, és a ti füleitek, hogy hallanak. ");
INSERT INTO hun_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Mert bizony mondom néktek, hogy sok próféta és igaz kívánta látni, amiket ti láttok, és nem látták, és hallani, amiket ti hallotok, és nem hallották. ");
INSERT INTO hun_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Ti tehát halljátok meg a magvető példázatát! ");
INSERT INTO hun_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ha valaki hallja az igét a mennyeknek országáról, és nem érti, eljön a gonosz, és elkapja azt, ami az ő szívébe van elvetve. Ez az, amelyik az útfélre esett. ");
INSERT INTO hun_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Amelyik pedig a köves helyre esett, az az, aki hallja az igét, és mindjárt örömmel fogadja, ");
INSERT INTO hun_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","de nincs gyökere benne, hanem csak ideigvaló, mihelyst pedig nyomorgatás vagy üldözés támad az ige miatt, azonnal megbotránkozik. ");
INSERT INTO hun_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Amelyik pedig a tövisek közé esett, az az, aki hallja az igét, de a világnak gondja és a gazdagságnak csalárdsága elfojtja az igét, és nem terem gyümölcsöt. ");
INSERT INTO hun_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Amely pedig a jó földbe esett, az az, aki hallja is, és érti is az igét, gyümölcsöt is terem, némelyik százannyit, némelyik hatvanannyit, némelyik pedig harmincannyit.“ ");
INSERT INTO hun_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Más példázatot is mondott nekik: „Hasonlatos a mennyek országa ahhoz az emberhez, aki földjébe jó magot vetett. ");
INSERT INTO hun_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","De amikor az emberek aludtak, eljött az ellensége, konkolyt vetett a búza közé, és elment. ");
INSERT INTO hun_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Amikor pedig felnövekedett a vetés, és gyümölcsöt termett, akkor meglátszott a konkoly is. ");
INSERT INTO hun_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","A gazda szolgái ekkor odamentek hozzá, és ezt mondták neki: Uram, nem tiszta magot vetettél földedbe? Honnan van benne a konkoly? ");
INSERT INTO hun_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ő pedig ezt mondta nekik: Valamelyik ellenség cselekedte azt. A szolgái ezt mondták neki: Akarod-e, hogy elmenjünk, és összeszedjük a konkolyt? ");
INSERT INTO hun_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ő pedig azt mondta: Nem. Mert amikor összeszeditek a konkolyt, azzal együtt talán a búzát is kiszaggatjátok. ");
INSERT INTO hun_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Hagyjátok, hogy együtt nőjön mindkettő az aratásig, és az aratás idején azt mondom majd az aratóknak: Szedjétek össze először a konkolyt, és kössétek kévébe, hogy elégessétek; a búzát pedig takarítsátok be csűrömbe.“ ");
INSERT INTO hun_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Más példázatot is mondott nekik: „Hasonlatos a mennyeknek országa a mustármaghoz, melyet fog az ember, és elvet a mezejébe. ");
INSERT INTO hun_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Az kisebb ugyan minden magnál, de amikor felnő, nagyobb a veteményeknél, és fává lesz, úgyhogy reá szállnak az égi madarak, és fészket raknak ágain.“ ");
INSERT INTO hun_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Más példázatot is mondott nekik: „Hasonlatos a mennyeknek országa a kovászhoz, amelyet fog az asszony, három mérce lisztbe belekever, amitől az egész megkel.“ ");
INSERT INTO hun_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Mindezeket példázatokban mondta Jézus a sokaságnak, és példázat nélkül semmit sem mondott nekik, ");
INSERT INTO hun_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","hogy beteljesedjék, amit a próféta mondott: „Megnyitom a számat példázatokra, és feltárom, amik e világ alapítása óta rejtve vannak.“ ");
INSERT INTO hun_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ekkor elbocsátotta Jézus a sokaságot, és bement a házba. Tanítványai odamentek hozzá, és ezt mondták: „Magyarázd meg nekünk a szántóföld konkolyáról szóló példázatot!“ ");
INSERT INTO hun_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ő pedig így felelt nekik: „Aki a jó magot veti, az az Emberfia, ");
INSERT INTO hun_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","a szántóföld pedig a világ, a jó mag az Isten országának fiai, a konkoly pedig a gonosznak fiai. ");
INSERT INTO hun_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Az ellenség, aki a konkolyt vetette, az ördög; az aratás pedig a világ vége, az aratók pedig az angyalok. ");
INSERT INTO hun_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ahogyan összegyűjtik a konkolyt és megégetik, úgy lesz a világ végén. ");
INSERT INTO hun_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Az Emberfia elküldi angyalait, és az országából összegyűjtenek minden botránkozást okozót és mindenkit, aki gonoszságot cselekedett, ");
INSERT INTO hun_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","és tüzes kemencébe vetik őket: ott lesz sírás és fogcsikorgatás. ");
INSERT INTO hun_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Akkor az igazak fénylenek, mint a nap Atyjuk országában. Akinek van füle a hallásra, hallja meg! ");
INSERT INTO hun_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","„Ismét hasonlatos a mennyek országa a szántóföldben elrejtett kincshez, amelyet megtalált az ember, elrejti, örömében elmegy, eladja mindenét, amije van, és megveszi azt a szántóföldet. ");
INSERT INTO hun_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Ismét hasonlatos a mennyek országa a kereskedőhöz, aki igazgyöngyöket keres. ");
INSERT INTO hun_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Amikor egy drágagyöngyöt talál, mindenételadja, amije van, és megveszi azt. ");
INSERT INTO hun_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Szintén hasonlatos a mennyeknek országa a tengerbe vetett hálóhoz, amely mindenféle fajta halat összefog. ");
INSERT INTO hun_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Miután megtelik, kivonják a partra a halászok, és leülve, a jókat edényekbe gyűjtik, a hitványakat pedig kidobják. ");
INSERT INTO hun_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Így lesz a világnak végén is: Eljönnek majd az angyalok, és kiválasztják a gonoszakat az igazak közül. ");
INSERT INTO hun_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","És tüzes kemencébe vetik őket, ott lesz sírás és fogcsikorgatás.“ ");
INSERT INTO hun_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Azután Jézus ezt kérdezte tőlük: „Megértettétek mindezeket?“ Azok ezt mondták: „Megértettük, Uram.“ ");
INSERT INTO hun_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ő pedig ezt mondta nekik: „Ezért minden írástudó, aki ismeri a mennyek országáról szóló tanítást, hasonlatos az olyan gazdához, aki ót és újat hoz elő éléskamrájából.“ ");
INSERT INTO hun_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","És történt, hogy amikor Jézus elmondta ezeket a példázatokat, elment onnan. ");
INSERT INTO hun_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","És hazájába érve, tanította őket a zsinagógában, úgy, hogy álmélkodtak, és ezt mondták: „Honnan van ebben ez a bölcsesség és az erő? ");
INSERT INTO hun_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Nem ő annak az ácsmesternek a fia? Nem az ő anyját hívják Máriának, és az ő testvéreit Jakabnak, Józsefnek, Simonnak és Júdásnak? ");
INSERT INTO hun_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","És nővérei is nem mind közöttünk élnek? Honnan vette mindezeket?“ ");
INSERT INTO hun_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","És megbotránkoztak őbenne. Jézus pedig ezt mondta nekik: „A prófétának csak az ő hazájában és házában nincs tisztessége.“ ");
INSERT INTO hun_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Nem is tett ott sok csodát a hitetlenségük miatt. ");
INSERT INTO hun_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Abban az időben Heródes negyedes fejedelem meghallotta Jézus hírét, ");
INSERT INTO hun_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","és ezt mondta szolgáinak: „Ez Keresztelő János: ő támadt fel a halálból, és ezért működnek benne az erők.“ ");
INSERT INTO hun_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Mert Heródes elfogatta Jánost, és megkötözve tömlöcbe vettette Heródiás kedvéért, testvérének, Fülöpnek feleségéért. ");
INSERT INTO hun_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Mert azt mondta neki János: „Nem szabad neked ővele élned.“ ");
INSERT INTO hun_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","De amikor meg akarta öletni, félt a sokaságtól, mert prófétának tartották őt. ");
INSERT INTO hun_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Hanem amikor Heródes születésnapját ünnepelték, táncolt Heródes lánya őelőttük, és megtetszett Heródesnek. ");
INSERT INTO hun_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ezért esküvel fogadta, hogy amit kér, megadja neki. ");
INSERT INTO hun_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","A leány pedig anyja rábeszélésére ezt mondta: „Add ide nekem egy tálban Keresztelő János fejét.“ ");
INSERT INTO hun_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Megszomorodott a király, de esküje és a vendégek miatt megparancsolta, hogy adják oda. ");
INSERT INTO hun_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Elküldetett, hogy fejét vegyék Jánosnak a tömlöcben, ");
INSERT INTO hun_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","elhozták a fejét egy tálban, odaadták a leánynak, ő pedig odavitte az anyjának. ");
INSERT INTO hun_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Azután eljöttek tanítványai, elvitték a testet, és eltemették. Majd elmentek, és jelentették Jézusnak. ");
INSERT INTO hun_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Amikor ezt meghallotta Jézus, elment onnan hajón egy puszta helyre egyedül. A sokaság ezt meghallva gyalog követte őt a városokból. ");
INSERT INTO hun_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Amikor kiszállt Jézus, látta a nagy sokaságot, megszánta őket, és betegeiket meggyógyította. ");
INSERT INTO hun_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Mikor pedig esteledett, odamentek hozzá tanítványai, és ezt mondták: „Puszta hely ez, és az idő már későre jár. Bocsásd el a sokaságot, hogy menjenek el a falvakba, és vegyenek maguknak eleséget.“ ");
INSERT INTO hun_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jézus pedig ezt mondta nekik: „Nem szükséges elmenniük, adjatok nekik ti enni.“ ");
INSERT INTO hun_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Azok pedig ezt mondták neki: „Nincsen itt csupán öt kenyerünk és két halunk.“ ");
INSERT INTO hun_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ő pedig ezt mondta: „Hozzátok ide hozzám.“ ");
INSERT INTO hun_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Akkor megparancsolta a sokaságnak, hogy üljenek le a fűre, vette az öt kenyeret és a két halat, szemeit az égre emelte, hálát adott, megszegte a kenyereket, a tanítványoknak adta, a tanítványok pedig a sokaságnak. ");
INSERT INTO hun_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Mindnyájan ettek és jóllaktak, felszedték a maradék darabokat, tizenkét teli kosárral. ");
INSERT INTO hun_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Akik pedig ettek, mintegy ötezren voltak férfiak, asszonyokon és gyermekeken kívül. ");
INSERT INTO hun_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Mindjárt ezután Jézus kényszerítette tanítványait, hogy szálljanak be a hajóba, és menjenek át a túlsó partra, míg ő elbocsátja a sokaságot. ");
INSERT INTO hun_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","És amint elbocsátotta a sokaságot, felment a hegyre magányosan imádkozni. Mikor pedig beesteledett, egyedül volt ott. ");
INSERT INTO hun_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","A hajó pedig ekkor már a tenger közepén volt, a haboktól háborgattatva, mert a szél szembe fújt. ");
INSERT INTO hun_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Az éjszaka negyedik részében hozzájuk ment Jézus a tengeren járva. ");
INSERT INTO hun_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Amikor látták a tanítványok, hogy a tengeren jár, megrémültek, és azt mondták, hogy kísértet, és félelmükben kiáltoztak. ");
INSERT INTO hun_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Jézus azonnal hozzájuk szólt, és ezt mondta: „Bízzatok, én vagyok, ne féljetek!“ ");
INSERT INTO hun_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Péter ekkor így felelt neki: „Uram, ha te vagy, parancsold meg, hogy hozzád mehessek a vízen.“ ");
INSERT INTO hun_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ő pedig ezt mondta: „Jöjj!“ És Péter kiszállt a hajóból, hogy a vizeken járva Jézushoz menjen. ");
INSERT INTO hun_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","De amikor látta a nagy szelet, megrémült, és amikor merülni kezdett, felkiáltott: „Uram, tarts meg engem!“ ");
INSERT INTO hun_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Jézus pedig azonnal kinyújtotta a kezét, megragadta őt, és ezt mondta neki: „Kicsinyhitű, miért kételkedtél?“ ");
INSERT INTO hun_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Amikor beléptek a hajóba, elállt a szél. ");
INSERT INTO hun_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","A hajóban levők pedig odamentek hozzá, leborultak előtte és mondták: „Bizony, Isten Fia vagy.“ ");
INSERT INTO hun_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","És átkelve a tavon eljutottak Genezáret földjére. ");
INSERT INTO hun_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Amikor megismerték őt annak a helynek lakosai, szétküldték hírét az egész környékben, és minden beteget odavittek hozzá. ");
INSERT INTO hun_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Kérték, hogy csak ruhájának peremét érinthessék meg. Akik megérintették, mindnyájan meggyógyultak. ");
INSERT INTO hun_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Akkor írástudók és farizeusok jöttek Jézushoz Jeruzsálemből, és ezt mondták: ");
INSERT INTO hun_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","„Miért hágják át tanítványaid az ősök rendeléseit? Mert nem mossák meg kezeiket, amikor enni akarnak.“ ");
INSERT INTO hun_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ő pedig így felelt nekik: „Ti meg miért hágjátok át Isten parancsolatait a ti rendeléseitek által? ");
INSERT INTO hun_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Mert Isten parancsolta ezt: »Tiszteld atyádat és anyádat«, és »aki atyját vagy anyját szidalmazza, halállal lakoljon.« ");
INSERT INTO hun_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ti pedig ezt mondjátok: Aki atyjának vagy anyjának ezt mondja: Áldozati ajándék az, amivel megsegíthetnélek, annak nem kell tisztelnie többé az ő atyját vagy anyját. ");
INSERT INTO hun_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ezzel érvénytelenné tettétek az Isten parancsolatait a ti rendeléseitek által. ");
INSERT INTO hun_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Képmutatók, igazat prófétált felőletek Ézsaiás: ");
INSERT INTO hun_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","»Ez a nép szájával közelít hozzám, és ajkával tisztel engemet, szíve pedig távol van tőlem. ");
INSERT INTO hun_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Pedig hiába tisztelnek engem, ha oly tudományokat tanítanak, melyek embereknek parancsolatai.«“ ");
INSERT INTO hun_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","És odahívta a sokaságot, és ezt mondta nekik: „Halljátok és értsétek meg: ");
INSERT INTO hun_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Nem az fertőzi meg az embert, ami a szájon bemegy, hanem ami kijön a szájából, az fertőzi meg az embert.“ ");
INSERT INTO hun_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Akkor odamentek tanítványai hozzá, és ezt mondták neki: „Tudod, hogy a farizeusok e beszédet hallva megbotránkoztak?“ ");
INSERT INTO hun_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ő pedig ezt felelte: „Minden palántát, amelyet nem az én mennyei Atyám plántált, ki fognak tépni. ");
INSERT INTO hun_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Hagyjátok őket, vakoknak vak vezetői ők! Ha pedig vak vezeti a vakot, mindketten a verembe esnek.“ ");
INSERT INTO hun_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Péter pedig ezt mondta neki: „Magyarázd meg nekünk ezt a példázatot!“ ");
INSERT INTO hun_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jézus erre ezt mondta: „Még ti sem értitek? ");
INSERT INTO hun_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Nem értitek, hogy minden, ami a szájon bemegy, a gyomorba jut, és az árnyékszékbe kerül? ");
INSERT INTO hun_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ami azonban a szájból jön ki, a szívből származik, és ezek fertőzik meg az embert. ");
INSERT INTO hun_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Mert a szívből származnak a gonosz gondolatok, gyilkosságok, házasságtörések, paráznaságok, lopások, hamis tanúbizonyságok, káromlások. ");
INSERT INTO hun_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ezek fertőzik meg az embert. De az, hogy mosdatlan kézzel eszik, nem fertőzi meg az embert.“ ");
INSERT INTO hun_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Elment onnan Jézus Tírusz és Szidón vidékeire. ");
INSERT INTO hun_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","És íme, egy kánaáni asszony jött ki abból a tartományból, és így kiáltott neki: „Uram, Dávid Fia, könyörülj rajtam! Leányomat gonoszul gyötri az ördög.“ ");
INSERT INTO hun_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ő pedig egy szót sem felelt neki. Tanítványai odamentek hozzá, és kérték őt: „Bocsásd el, mert utánunk kiáltozik.“ ");
INSERT INTO hun_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ő pedig ezt mondta: „Nem küldettem, csak Izrael házának elveszett juhaihoz.“ ");
INSERT INTO hun_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Az asszony pedig odaérve leborult előtte, és ezt mondta: „Uram, légy segítségül nekem!“ ");
INSERT INTO hun_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ő pedig ezt felelte: „Nem jó a fiak kenyerét elvenni, és az ebeknek vetni.“ ");
INSERT INTO hun_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Az pedig így felelt: „Úgy van, Uram! De hiszen az ebek is esznek a morzsákból, amelyek az uruknak asztaláról lehullanak.“ ");
INSERT INTO hun_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ekkor így felelt neki Jézus: „Ó, asszony! Nagy a te hited! Legyen neked akaratod szerint.“ És meggyógyult a leánya abban a pillanatban. ");
INSERT INTO hun_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Onnan eltávozva elment Jézus a Galileai-tenger mellé, felment a hegyre, és ott leült. ");
INSERT INTO hun_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Nagy sokaság ment hozzá, vittek magukkal sántákat, vakokat, némákat, csonkákat és sok más beteget. Odahelyezték őket Jézus lábai elé, és meggyógyította őket. ");
INSERT INTO hun_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Úgy, hogy a sokaság álmélkodott, látva, hogy a némák beszélnek, a csonkák felépülnek, a sánták járnak, a vakok látnak, és dicsőítették Izrael Istenét. ");
INSERT INTO hun_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jézus pedig odahívta tanítványait, és ezt mondta: „Szánakozom e sokaságon, mert három napja immár, hogy velem vannak, és nincs mit enniük. Éhen pedig nem akarom őket elbocsátani, nehogy valamiképpen kidőljenek az úton.“ ");
INSERT INTO hun_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Tanítványai ezt mondták neki: „Honnan volna e pusztában annyi kenyerünk, hogy jóllakassunk ilyen nagy sokaságot?“ ");
INSERT INTO hun_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jézus ezt mondta nekik: „Hány kenyeretek van?“ Ők pedig így feleltek: „Hét, és néhány halunk.“ ");
INSERT INTO hun_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","És megparancsolta a sokaságnak, hogy telepedjenek le a földön, ");
INSERT INTO hun_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","azután vette a hét kenyeret és a halakat, hálát adva megtörte, tanítványainak adta, a tanítványok pedig a sokaságnak. ");
INSERT INTO hun_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Mindnyájan ettek, és jóllaktak, azután fölszedték a maradék darabokat, hét teli kosárral. ");
INSERT INTO hun_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Akik pedig ettek, négyezren voltak férfiak, asszonyokon és gyermekeken kívül. ");
INSERT INTO hun_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ezek után elbocsátotta a sokaságot, beszállt a hajóba, és elment Magdala vidékére. ");
INSERT INTO hun_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Odamentek hozzá a farizeusok és a szadduceusok, meg akarták kísérteni, és kérték őt, hogy mutasson nekik mennyei jelt. ");
INSERT INTO hun_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ő pedig így felelt nekik: „Amikor esteledik, azt mondjátok: Szép idő lesz, mert vörös az ég. ");
INSERT INTO hun_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Reggel pedig: Ma zivatar lesz, mert az ég borús és vörös. Képmutatók, az ég ábrázatát meg tudjátok ítélni, az idők jeleit pedig nem tudjátok? ");
INSERT INTO hun_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","E gonosz és parázna nemzetség jelt kíván, és nem adatik néki jel, csak Jónás prófétának jele.“ És otthagyva őket, elment. ");
INSERT INTO hun_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Tanítványai a túlsó partra mentek, és elfelejtettek kenyeret vinni magukkal. ");
INSERT INTO hun_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jézus pedig mondta nekik: „Vigyázzatok, és őrizkedjetek a farizeusok és szadduceusok kovászától!“ ");
INSERT INTO hun_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ők pedig tanakodtak maguk között, és ezt mondták: „Nem hoztunk kenyeret magunkkal.“ ");
INSERT INTO hun_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jézus meghallotta ezt, és mondta nekik: „Miért tanakodtok magatok között, ó kicsinyhitűek, hogy kenyeret nem hoztatok magatokkal? ");
INSERT INTO hun_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Mégsem értitek? Nem is emlékeztek az ötezernek öt kenyerére, és hogy hány kosarat töltöttetek meg? ");
INSERT INTO hun_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Sem a négyezernek hét kenyerére, és hogy hány kosarat töltöttetek meg? ");
INSERT INTO hun_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Hogyan lehet, hogy nem értitek meg, hogy nem a kenyérről beszéltem nektek, mikor mondtam, hogy őrizkedjetek a farizeusok és szadduceusok kovászától?“ ");
INSERT INTO hun_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ekkor értették meg, hogy nem arról szólt, hogy a kenyér kovászától őrizkedjenek, hanem a farizeusok és szadduceusok tudományától. ");
INSERT INTO hun_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Mikor pedig Jézus Cezárea Filippi környékére ment, megkérdezte tanítványait: „Engem, az Emberfiát kinek mondanak az emberek?“ ");
INSERT INTO hun_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ők pedig ezt mondták: „Némelyek Keresztelő Jánosnak, mások Illésnek; némelyek pedig Jeremiásnak vagy egynek a próféták közül.“ ");
INSERT INTO hun_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Erre ezt mondta nekik: „Ti kinek mondotok engem?“ ");
INSERT INTO hun_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simon Péter felelt, és ezt mondta: „Te vagy a Krisztus, az élő Isten Fia.“ ");
INSERT INTO hun_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jézus így felelt neki: „Boldog vagy, Simon, Jóna fia, mert nem test és vér jelentette ezt ki neked, hanem az én mennyei Atyám. ");
INSERT INTO hun_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","De én is mondom neked, hogy te Péter vagy, és ezen a kősziklán építem fel az anyaszentegyházamat, és a pokol kapui sem vesznek rajta diadalmat. ");
INSERT INTO hun_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","És neked adom a mennynek országának kulcsait, és amit megkötsz a földön, a mennyekben is kötve lesz, és amit feloldasz a földön, a mennyekben is oldva lesz.“ ");
INSERT INTO hun_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Azután megparancsolta tanítványainak, hogy senkinek se mondják, hogy ő a Jézus Krisztus. ");
INSERT INTO hun_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ettől fogva kezdte Jézus jelenteni tanítványainak, hogy neki Jeruzsálembe kell mennie, sokat szenvednie a vénektől, a főpapoktól és az írástudóktól, és meg kell öletnie, de harmadnapon föl kell támadnia. ");
INSERT INTO hun_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Péter ekkor odafordult hozzá, és megfeddte őt: „Mentsen Isten, Uram! Ez nem eshet meg veled!“ ");
INSERT INTO hun_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ő pedig megfordult, és ezt mondta Péternek: „Távozz tőlem, Sátán, bántasz engem, mert nem az Isten dolgaira gondolsz, hanem az emberi dolgokra.“ ");
INSERT INTO hun_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ekkor mondta Jézus tanítványainak: „Ha valaki énutánam akar jönni, tagadja meg magát, vegye föl az ő keresztjét, és kövessen engem. ");
INSERT INTO hun_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Mert aki meg akarja tartani életét, elveszíti azt, aki pedig elveszíti életét énérettem, megtalálja azt. ");
INSERT INTO hun_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Mert mit használ az embernek, ha az egész világot megnyeri is, de az ő lelkében kárt vall? Vagy milyen váltságot adhat az ember a lelkéért? ");
INSERT INTO hun_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Mert az Emberfia eljön Atyjának dicsőségében angyalaival, és akkor megfizet mindenkinek cselekedete szerint. ");
INSERT INTO hun_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Bizony mondom néktek: azok között, akik itt állnak, vannak némelyek, akik nem kóstolják meg a halált, amíg meg nem látják az Emberfiát eljönni az ő országában.“ ");
INSERT INTO hun_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Hat nap múlva magához vette Jézus Pétert, Jakabot és annak testvérét Jánost, és felvitte őket magával egy magas hegyre. ");
INSERT INTO hun_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Elváltozott előttük, és arca ragyogott, mint a nap, ruhája pedig fehér lett, mint a fényesség. ");
INSERT INTO hun_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","És íme, megjelent neki Mózes és Illés, akik beszéltek vele. ");
INSERT INTO hun_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Péter pedig megszólalt, és ezt mondta Jézusnak: „Uram, jó nekünk itt lennünk. Ha akarod, építünk itt három hajlékot, neked egyet, Mózesnek is egyet, Illésnek is egyet.“ ");
INSERT INTO hun_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Még beszélt, mikor fényes felhő borította be őket, és íme, szózat szólt a felhőből, mondván: „Ez az én szeretett Fiam, akiben én gyönyörködöm: őt hallgassátok!“ ");
INSERT INTO hun_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","És a tanítványok, amint ezt hallották, arcra estek, és igen megrémültek. ");
INSERT INTO hun_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jézus pedig odament hozzájuk, megérintette őket, és ezt mondta: „Keljetek fel, és ne féljetek!“ ");
INSERT INTO hun_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Mikor pedig szemeiket felemelték, senkit sem láttak, csak Jézust egyedül. ");
INSERT INTO hun_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Mikor a hegyről lejöttek, megparancsolta nekik Jézus: „Senkinek se mondjátok el, amit láttatok, amíg fel nem támadt az Emberfia a halálból.“ ");
INSERT INTO hun_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","És megkérdezték őt tanítványai: „Miért mondják akkor az írástudók, hogy előbb Illésnek kell eljönnie?“ ");
INSERT INTO hun_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jézus pedig így felelt nekik: „Illés bizony eljön előbb, és mindent helyreállít. ");
INSERT INTO hun_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","De mondom nektek, hogy Illés már eljött, de nem ismerték fel őt, hanem azt művelték vele, amit csak akartak. Ugyanígy az Emberfiának is szenvednie kell majd miattuk.“ ");
INSERT INTO hun_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ekkor megértették a tanítványok, hogy Keresztelő Jánosról szólt nekik. ");
INSERT INTO hun_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Amikor a sokasághoz értek, egy ember jött hozzá, és térdre esett előtte, ");
INSERT INTO hun_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","és ezt mondta: „Uram, könyörülj az én fiamon, mert holdkóros, és kegyetlenül szenved, mivel gyakran esik tűzbe, és gyakran esik vízbe. ");
INSERT INTO hun_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Elvittem őt tanítványaidhoz, és nem tudták meggyógyítani.“ ");
INSERT INTO hun_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jézus pedig erre ezt mondta: „Ó, hitetlen és elfajult nemzedék! Vajon meddig leszek veletek? Vajon meddig szenvedlek titeket? Hozzátok őt ide nekem!“ ");
INSERT INTO hun_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","És megdorgálta őt Jézus, és kiment belőle az ördög, a gyermek pedig meggyógyult még abban az órában. ");
INSERT INTO hun_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ekkor a tanítványok mikor magukban voltak, odamentek Jézushoz, és ezt kérdezték tőle: „Mi miért nem tudtuk ezt kiűzni?“ ");
INSERT INTO hun_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jézus pedig ezt mondta nekik: „A hitetlenségetek miatt. Mert bizony mondom néktek: ha akkora hitetek volna, mint a mustármag, és azt mondanátok ennek a hegynek: Menj innen oda! – odamenne, és semmi sem volna lehetetlen nektek. ");
INSERT INTO hun_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ez a fajta pedig nem megy ki, csak könyörgés és böjtölés által.“ ");
INSERT INTO hun_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Amikor pedig Galileában jártak, ezt mondta nekik Jézus: „Az Emberfia emberek kezébe adatik, ");
INSERT INTO hun_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","és megölik őt, de harmadnapon föltámad.“ És felettébb elszomorodtak. ");
INSERT INTO hun_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Amikor pedig eljutottak Kapernaumba, a drachmaszedők odamentek Péterhez, és ezt kérdezték tőle: „A ti mesteretek nem fizeti a két drachmát?“ ");
INSERT INTO hun_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ő így felelt: „De igen.“ És amikor bementek a házba, megelőzte őt Jézus, és ezt mondta: „Mit gondolsz, Simon, a föld királyai kiktől szednek vámot vagy adót: a fiaiktól-e vagy az idegenektől?“ ");
INSERT INTO hun_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Péter ezt mondta neki: „Az idegenektől.“ Ezután Jézus ezt mondta neki: „Tehát a fiak szabadok. ");
INSERT INTO hun_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","De hogy őket meg ne botránkoztassuk, menj a tengerre, vesd be a horgot, és vond ki az első halat, amely ráakad. És felnyitva száját egy státert találsz benne. Vedd ki, és add oda nekik értem és éretted.“ ");
INSERT INTO hun_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Abban az órában odamentek a tanítványok Jézushoz, és megkérdezték tőle: „Vajon ki nagyobb a mennyek országában?“ ");
INSERT INTO hun_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jézus odahívott egy kisgyermeket, közéjük állította, ");
INSERT INTO hun_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","és ezt mondta: „Bizony mondom néktek: ha meg nem tértek, és olyanok nem lesztek, mint a kisgyermekek, semmiképpen nem mentek be a mennyek országába. ");
INSERT INTO hun_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Aki tehát megalázza magát, mint ez a kisgyermek, az a nagyobb a mennyek országában. ");
INSERT INTO hun_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Aki egy ilyen kisgyermeket befogad az én nevemben, engem fogad be. ");
INSERT INTO hun_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Aki pedig megbotránkoztat egyet e kicsinyek közül, akik énbennem hisznek, jobb annak, hogyha malomkövet kötnek nyakába, és a tenger mélyébe vetik. ");
INSERT INTO hun_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Jaj a világnak a botránkozások miatt! Mert szükséges, hogy botránkozások történjenek, de jaj annak az embernek, aki által a botránkozás történik. ");
INSERT INTO hun_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ha pedig a kezed vagy lábad megbotránkoztat, vágd le azokat, és dobd el magadtól: mert jobb neked az életre sántán vagy csonkán bemenned, mint ha két kézzel vagy két lábbal vettetel az örök tűzre. ");
INSERT INTO hun_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ha pedig a szemed botránkoztat meg téged, vájd ki azt, és dobd el magadtól: jobb neked félszemmel bemenned az életre, mint ha két szemmel vettetel a gyehenna tüzére. ");
INSERT INTO hun_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Vigyázzatok, hogy e kicsinyek közül egyet se utáljatok, mert mondom néktek, hogy angyalaik a mennyekben mindig látják mennyei Atyám arcát. ");
INSERT INTO hun_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Mert az Emberfia azért jött, hogy megtartsa, ami elveszett. ");
INSERT INTO hun_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Mit gondoltok, ha valamelyik embernek száz juha van, és egy azok közül eltéved, vajon nem hagyja-e őket ott, és a hegyekbe elmenve nem keresi-e meg azt, amely eltévelyedett? ");
INSERT INTO hun_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","És ha történetesen megtalálja, bizony mondom néktek, inkább örvend annak az egynek, mint a kilencvenkilencnek, amelyik nem tévedett el. ");
INSERT INTO hun_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Hasonlóképpen a ti mennyei Atyátok sem akarja, hogy egy is elvesszen e kicsinyek közül. ");
INSERT INTO hun_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","„Ha pedig atyádfia vétkezik ellened, menj el, és dorgáld meg négyszemközt: ha hallgat rád, megnyerted atyádfiát. ");
INSERT INTO hun_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ha pedig nem hallgat rád, végy magad mellé még egy vagy két embert, »hogy két vagy három tanú vallomásával erősítsen meg minden szót.« ");
INSERT INTO hun_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ha azokra sem hallgat, mondd meg a gyülekezetnek. Ha a gyülekezetre sem hallgat, legyen előtted olyan, mint a pogány és a vámszedő. ");
INSERT INTO hun_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Bizony mondom néktek: amit megköttök a földön, a mennyben is kötve lesz, amit feloldotok a földön, a mennyben is oldva lesz. ");
INSERT INTO hun_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ismét mondom néktek, hogyha ketten közületek egyetértenek a földön minden dologban, amit csak kérnek, megadja nekik az én mennyei Atyám. ");
INSERT INTO hun_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Mert ahol ketten vagy hárman összegyűlnek az én nevemben: ott vagyok közöttük.“ ");
INSERT INTO hun_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ekkor odament hozzá Péter, és ezt mondta: „Uram, hányszor lehet atyámfiának ellenem vétkeznie, és neki megbocsátanom? Még hétszer is?“ ");
INSERT INTO hun_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jézus ezt mondta neki: „Nem azt mondom neked, hogy még hétszer is, hanem még hetvenhétszer is. ");
INSERT INTO hun_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ezért hasonlatos a mennyek országa a királyhoz, aki számot akart vetni az ő szolgáival. ");
INSERT INTO hun_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Amikor pedig számot kezdett vetni, hoztak eléje egyet, aki tízezer talentummal volt adós. ");
INSERT INTO hun_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Mivel nem tudott fizetni, megparancsolta ura, hogy adják el őt, feleségét és gyerekeit, és mindenét, amije van, és fizessen. ");
INSERT INTO hun_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","A szolga ezért leborult előtte, könyörgött neki, és ezt mondta: Uram, légy türelemmel hozzám, és mindent megfizetek neked. ");
INSERT INTO hun_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Az úr pedig megszánta a szolgát, elbocsátotta őt, és az adósságát is elengedte neki. ");
INSERT INTO hun_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","A szolga pedig kiment, és találkozott eggyel az ő szolgatársai közül, aki száz dénárral volt neki adós. Megragadta, fojtogatni kezdte, és ezt mondta: Fizesd meg nekem, amivel tartozol. ");
INSERT INTO hun_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Szolgatársa ekkor leborult a lábai elé, és könyörgött neki: Légy türelemmel hozzám, és mindent megfizetek neked. ");
INSERT INTO hun_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","De ő ezt nem akarta, hanem elment, börtönbe vettette addig, amíg megfizeti, amivel tartozik neki. ");
INSERT INTO hun_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Amikor szolgatársai látták, hogy mi történt, nagyon megszomorodtak. Elmentek, és jelentettek uruknak mindent, ami történt. ");
INSERT INTO hun_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Akkor magához hívatta őt ura, és ezt mondta neki: Gonosz szolga, minden adósságodat elengedtem neked, mert könyörögtél nekem. ");
INSERT INTO hun_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Nem kellett volna neked is könyörülnöd szolgatársadon, amint én is könyörültem rajtad? ");
INSERT INTO hun_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ekkor megharagudott az ura, átadta őt a hóhérok kezébe, míg meg nem fizet mindent, amivel tartozik. ");
INSERT INTO hun_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Így cselekszik az én mennyei Atyám is veletek, ha szívetekből meg nem bocsátjátok, ki-ki az ő atyjafiának a vétkeiket.“ ");
INSERT INTO hun_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Amikor befejezte Jézus ezeket a beszédeket, elment Galileából, és elment Júdának határaiba, a Jordánon túl. ");
INSERT INTO hun_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Nagy sokaság követte őt, és meggyógyította ott őket. ");
INSERT INTO hun_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Odamentek hozzá a farizeusok, hogy kísértsék őt, és ezt mondták: „Szabad-e az embernek feleségét bármilyen ok miatt elbocsátani?“ ");
INSERT INTO hun_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ő pedig így felelt: „Nem olvastátok-e, hogy a Teremtő kezdettől fogva »férfiúvá és asszonnyá teremtette őket?« ");
INSERT INTO hun_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","És ezt mondta: »Ezért elhagyja a férfiú atyját és anyját, és ragaszkodik feleségéhez, és lesznek ketten egy testté.« ");
INSERT INTO hun_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Úgyhogy többé nem kettő, hanem egy test. Amit azért az Isten egybeszerkesztett, ember el ne válassza.“ ");
INSERT INTO hun_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Erre azt mondták neki: „Miért rendelte akkor Mózes, hogy válólevelet kell adni, és úgy bocsátani el az asszonyt?“ ");
INSERT INTO hun_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jézus ezt mondta nekik: „Mózes a ti szívetek keménysége miatt engedte meg nektek, hogy feleségeteket elbocsássátok, de ez kezdettől fogva nem így volt. ");
INSERT INTO hun_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Mondom nektek, hogy aki elbocsátja feleségét, hacsak nem paráznaság miatt, és mást vesz el, házasságtörő; és aki elbocsátottat vesz el, az is házasságtörő.“ ");
INSERT INTO hun_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Erre ezt mondták neki tanítványai: „Ha így van a férfi dolga az asszonnyal, akkor nem jó megházasodni.“ ");
INSERT INTO hun_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ő pedig ezt mondta nekik: „Nem mindenki érti meg, hanem csak az, akinek megadatik. ");
INSERT INTO hun_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Mert vannak nemzésre alkalmatlanok, akik anyjuk méhéből születtek így, és vannak nemzésre alkalmatlanok, akiket az emberek tettek ilyenekké; és vannak olyanok, akik önmagukat tették nemzésre alkalmatlanná a mennyeknek országáért. Aki megérti, értse meg.“ ");
INSERT INTO hun_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ekkor kisgyermekeket hoztak hozzá, hogy kezeit rájuk tegye, és imádkozzék értük. A tanítványok azonban megdorgálták őket. ");
INSERT INTO hun_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Jézus pedig ezt mondta: „Hagyjátok e kisgyermekeket, és ne tiltsátok meg nekik, hogy hozzám jöjjenek, mert ilyeneké a mennyek országa.“ ");
INSERT INTO hun_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","És kezeit rájuk tette, majd eltávozott onnan. ");
INSERT INTO hun_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","És íme, odajött hozzá egy ember, és ezt kérdezte: „Jó mester, mi jót cselekedjem, hogy örök életet nyerjek?“ ");
INSERT INTO hun_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ő pedig ezt mondta neki: „Miért mondasz engem jónak? Senki sem jó, csak egy, az Isten. Ha pedig be akarsz menni az életre, tartsd meg a parancsolatokat.“ ");
INSERT INTO hun_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Az megkérdezte: „Melyeket?“ Jézus pedig ezt mondta: „»Ne ölj, ne paráználkodj, ne lopj, hamis tanúbizonyságot ne tégy, ");
INSERT INTO hun_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","tiszteld atyádat és anyádat, és szeresd felebarátodat, mint önmagadat.«“ ");
INSERT INTO hun_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Az ifjú erre ezt mondta: „Mindezeket megtartottam ifjúságomtól fogva; mi fogyatkozás van még bennem?“ ");
INSERT INTO hun_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jézus ezt mondta neki: „Ha tökéletes akarsz lenni, eredj, add el vagyonodat, és oszd ki a szegényeknek, és kincsed lesz a mennyben; azután jöjj, és kövess engem.“ ");
INSERT INTO hun_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Az ifjú pedig ezt a beszédet hallva, megszomorodva ment el, mert sok jószága volt. ");
INSERT INTO hun_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Jézus pedig ezt mondta tanítványainak: „Bizony mondom néktek, hogy a gazdag nehezen megy be a mennyeknek országába. ");
INSERT INTO hun_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ismét mondom néktek: Könnyebb a tevének a tű fokán átmenni, mint a gazdagnak az Isten országába bejutni.“ ");
INSERT INTO hun_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","A tanítványok pedig amikor ezeket hallották, felettébb álmélkodtak, és ezt mondták: „Kicsoda üdvözülhet tehát?“ ");
INSERT INTO hun_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jézus pedig rájuk tekintve mondta nekik: „Embereknél ez lehetetlen, de Istennél minden lehetséges.“ ");
INSERT INTO hun_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Akkor Péter ezt mondta neki: „Íme, mi elhagytunk mindent, és követtünk téged: mi lesz hát a jutalmunk?“ ");
INSERT INTO hun_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jézus pedig ezt mondta neki: „Bizony mondom néktek, hogy ti, akik követtetek engem, az újjászületéskor, amikor az Emberfia beül a dicsőségének királyi székébe, ti is beültök majd tizenkét királyi székbe, és ítélkezni fogtok Izrael tizenkét nemzetsége fölött. ");
INSERT INTO hun_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","És aki elhagyta házát vagy testvéreit, nőtestvéreit, atyját, anyját, feleségét, gyermekeit vagy szántóföldjét az én nevemért, mindaz százannyit kap, és örök életet nyer az örökség szerint. ");
INSERT INTO hun_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","De sok elsőből lesz utolsó és sok utolsóból első.“ ");
INSERT INTO hun_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","„Hasonló a mennyek országa a gazdához, aki korán reggel kiment, hogy munkásokat fogadjon szőlőjébe. ");
INSERT INTO hun_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Megegyezett a munkásokkal napi tíz pénzben, és elküldte őket szőlőjébe. ");
INSERT INTO hun_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Amikor kiment három óra tájban, látott másokat is, akik tétlenül a piacon álltak. ");
INSERT INTO hun_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ezt mondta nekik: Menjetek el ti is a szőlőbe, és ami igazságos, megadom nektek. ");
INSERT INTO hun_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Azok pedig elmentek. Hat és kilenc óra tájban ismét kiment, és ugyanúgy cselekedett. ");
INSERT INTO hun_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Tizenegy óra tájban is kiment, és talált másokat, akik tétlenül álltak ott, és megkérdezte tőlük: Miért álltok itt egész napon át tétlenül? ");
INSERT INTO hun_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Azok így feleltek: Mert senki sem fogadott fel minket. Erre ezt mondta nekik: Menjetek el ti is a szőlőbe, és ami igazságos megkapjátok. ");
INSERT INTO hun_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Mikor beesteledett, a szőlőnek ura ezt mondta vincellérjének: Hívd elő a munkásokat, és add ki nekik a bért, az utolsóktól kezdve mind az elsőkig. ");
INSERT INTO hun_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","És jöttek a tizenegy órások, fejenként tíz-tíz pénzt kaptak. ");
INSERT INTO hun_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Jöttek azután az elsők, és azt gondolták, hogy ők többet kapnak, de ők is tíz-tíz pénz kaptak fejenként. ");
INSERT INTO hun_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Amint pedig fölvették, zúgolódni kezdtek a házigazda ellen, ");
INSERT INTO hun_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","és ezt mondták: Azok az utolsók egyetlen óráig dolgoztak, és egyenlővé tetted őket velünk, akik a napnak terhét és hőségét szenvedtük. ");
INSERT INTO hun_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ő pedig így felelt közülük egynek: Barátom, nem cselekszem igazságtalanul veled: Vagy nem tíz pénzben szerződtél velem? ");
INSERT INTO hun_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Vedd, ami a tiéd, és menj el. Én pedig ennek az utolsónak is annyit akarok adni, mint neked. ");
INSERT INTO hun_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Talán nem szabad nekem a magaméval azt tennem, amit akarok? Vagy a te szemed azért gonosz, mert én jó vagyok? ");
INSERT INTO hun_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ekképpen lesznek az utolsók elsők és az elsők utolsók; mert sokan vannak a hivatalosak, de kevesen a választottak.“ ");
INSERT INTO hun_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Amikor felment Jézus Jeruzsálembe, útközben csupán a tizenkét tanítványt vette magához, és ezt mondta nekik: ");
INSERT INTO hun_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","„Íme, felmegyünk Jeruzsálembe, és az Emberfia átadatik a főpapoknak és írástudóknak, és halálra ítélik őt. ");
INSERT INTO hun_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","A pogányok kezébe adják, hogy megcsúfolják, megostorozzák, és keresztre feszítsék, de harmadnapon feltámad.“ ");
INSERT INTO hun_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ekkor hozzáment a Zebedeus fiainak anyja fiaival együtt, leborult előtte, hogy kérjen tőle valamit. ");
INSERT INTO hun_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ő pedig megkérdezte tőle: „Mit akarsz?“ Ő ezt mondta neki: „Mondd, hogy az én két fiam üljön a te országodban: egyik jobb kezed felől, a másik bal kezed felől.“ ");
INSERT INTO hun_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jézus pedig ezt felelte neki: „Nem tudjátok, mit kértek. Megisszátok-e a poharat, melyet én iszom? És megkeresztelkedtek-e azzal a keresztséggel, amellyel én megkeresztelkedem?“ Azt mondták neki: „Meg.“ ");
INSERT INTO hun_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Erre ő azt mondta nekik: „Az én poharamat megisszátok ugyan, és a keresztséggel, amellyel én megkeresztelkedem, megkeresztelkedtek, de az én jobb és bal kezem felől való ülést nem az én dolgom megadni, hanem azoké lesz az, akiknek az én Atyám elkészítette.“ ");
INSERT INTO hun_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Amikor ezt meghallotta a többi tíz, bosszankodtak a két testvérre. ");
INSERT INTO hun_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Jézus pedig előszólította őket, és ezt mondta: „Tudjátok, hogy a pogányok fejedelmei uralkodnak szolgáikon, és a nagyok hatalmaskodnak rajtuk. ");
INSERT INTO hun_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","De ne így legyen közöttetek, hanem aki közöttetek nagy akar lenni, legyen a ti szolgátok, ");
INSERT INTO hun_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","és aki közöttetek első akar lenni, legyen a ti szolgátok. ");
INSERT INTO hun_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Amint az Emberfia sem azért jött, hogy neki szolgáljanak, hanem, hogy ő szolgáljon, és adja az ő életét váltságul sokakért.“ ");
INSERT INTO hun_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Amikor Jerikóból távoztak, nagy sokaság követte őt. ");
INSERT INTO hun_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","És íme, két vak, aki az út mellett ült, meghallva, hogy Jézus arra megy el, elkezdett kiáltozni: „Uram, Dávidnak Fia, könyörülj rajtunk!“ ");
INSERT INTO hun_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","A sokaság pedig megdorgálta őket, hogy hallgassanak, de azok annál jobban kiáltoztak: „Uram, Dávidnak Fia, könyörülj rajtunk!“ ");
INSERT INTO hun_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jézus pedig megállt, és megszólította őket, és ezt kérdezte: „Mit akartok, hogy cselekedjem veletek?“ ");
INSERT INTO hun_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ők így feleltek neki: „Azt, Uram, hogy megnyíljanak szemeink.“ ");
INSERT INTO hun_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jézus pedig megszánta őket, megérintette szemeiket, és szemeik azonnal megnyíltak, és követték őt. ");
INSERT INTO hun_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Amikor közeledtek Jeruzsálemhez és Betfagéba, az Olajfák hegyéhez jutottak, akkor elküldött Jézus két tanítványt, ");
INSERT INTO hun_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","és ezt mondta nekik: „Menjetek ebbe a faluba, amely előttetek van, és ott találtok egy megkötött szamarat és vele együtt a csikóját: oldjátok el, és hozzátok ide nekem. ");
INSERT INTO hun_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ha valaki valamit szól nektek, mondjátok, hogy az Úrnak van szüksége rájuk, és rögtön el fogja engedni őket.“ ");
INSERT INTO hun_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Mindez pedig azért történt, hogy beteljesedjék a próféta mondása, aki így szólt: ");
INSERT INTO hun_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","„Mondjátok meg Sion leányának: »Íme, királyod jön hozzád, alázatosan és szamáron ülve, teherhordozó szamárnak csikóján.«“ ");
INSERT INTO hun_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","A tanítványok pedig elmentek, és úgy cselekedtek, amint Jézus parancsolta nekik. ");
INSERT INTO hun_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Elhozták a szamarat és annak csikóját, felsőruhájukat rájuk terítették, Jézus pedig ráült. ");
INSERT INTO hun_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","A sokaság legnagyobb része pedig felsőruháit az útra terítette, mások pedig fákról gallyakat vagdostak, és az útra szórták. ");
INSERT INTO hun_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Az előtte és utána menő sokaság pedig így kiáltott: „Hozsánna a Dávid Fiának!“ „Áldott, aki jő az Úrnak nevében!“ „Hozsánna a magasságban!“ ");
INSERT INTO hun_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","És amikor bement Jeruzsálembe, felbolydult az egész város, és kérdezték: „Kicsoda ez?“ ");
INSERT INTO hun_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","A sokaság pedig ezt mondta: „Ez Jézus, a galileai Názáretből való próféta.“ ");
INSERT INTO hun_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","És bement Jézus az Isten templomába, és kiűzte mindazokat, akik árultak és vásároltak a templomban; és a pénzváltók asztalait és a galambárusok székeit felforgatta. ");
INSERT INTO hun_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","És ezt mondta nekik: „Meg van írva: »Az én házamat imádság házának mondják: ti pedig latrok barlangjává tettétek.«“ ");
INSERT INTO hun_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Azután vakok és sánták mentek hozzá a templomban, és meggyógyította őket. ");
INSERT INTO hun_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","A főpapok és az írástudók pedig látva a csodákat, amelyeket cselekedett, és a gyermekeket, akik a templomban kiáltoztak: „Hozsánna a Dávid Fiának!“ – haragra gerjedtek, ");
INSERT INTO hun_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","és ezt mondták neki: „Hallod, mit mondanak ezek?“ Jézus pedig ezt válaszolta nekik: „Hallom. Sohasem olvastátok: »A gyermekek és csecsemők szája által szereztél dicsőséget?«“ ");
INSERT INTO hun_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ezután otthagyta őket, kiment a városból Betániába, és ott maradt éjjel. ");
INSERT INTO hun_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Reggel pedig a városba visszajövet megéhezett. ");
INSERT INTO hun_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","És meglátott egy fügefát az út mellett, odament hozzá, és nem talált rajta semmit, hanem csak leveleket. Ekkor ezt mondta neki: „Gyümölcs ezután rajtad soha ne teremjen!“ És a fügefa azonnal elszáradt. ");
INSERT INTO hun_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Látták ezt a tanítványok, és csodálkozva mondták: „Hogyan száradt el a fügefa oly hirtelen?“ ");
INSERT INTO hun_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jézus pedig ezt felelte nekik: „Bizony mondom néktek, ha van hitetek, és nem kételkedtek, nemcsak azt tehetitek meg, ami ezzel a fügefával történt, hanem ha azt mondjátok e hegynek: Kelj fel, és zuhanj a tengerbe, az is megtörténik. ");
INSERT INTO hun_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","És amit imádságotokban kértek, mindazt meg is kapjátok, ha hisztek.“ ");
INSERT INTO hun_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Amikor bement a templomba, odamentek hozzá a főpapok és a nép vénei, amint tanított, és ezt mondták: „Micsoda hatalommal cselekszed ezeket? És ki adta neked ezt a hatalmat?“ ");
INSERT INTO hun_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jézus ezt felelte nekik: „Én is kérdezek egy dolgot tőletek, amire ha megfeleltek nekem, én is megmondom nektek, milyen hatalommal cselekszem ezeket. ");
INSERT INTO hun_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","A János keresztsége honnan volt: mennyből vagy emberektől?“ Azok pedig így tanakodtak magukban: „Ha azt mondjuk: mennyből, azt mondja majd nekünk: Akkor miért nem hittetek neki? ");
INSERT INTO hun_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ha pedig azt mondjuk: emberektől, akkor félünk kell a sokaságtól, mert Jánost mindenki prófétának tartja.“ ");
INSERT INTO hun_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ezért így feleltek Jézusnak: „Nem tudjuk.“ Ő pedig ezt mondta nekik: „Én sem mondom meg nektek micsoda hatalommal cselekszem ezeket. ");
INSERT INTO hun_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","„De mit gondoltok ti? Volt egy embernek két fia, és odamenve az elsőhöz, ezt mondta: Eredj, fiam, munkálkodj ma a szőlőmben. ");
INSERT INTO hun_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Az pedig így felelt: Nem megyek; de azután meggondolta magát, és elment. ");
INSERT INTO hun_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","A másikhoz is odamenve, hasonlóképpen szólt. Ő pedig azt felelte: Elmegyek Uram – de nem ment el. ");
INSERT INTO hun_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","E kettő közül melyik teljesítette az atyja akaratát?“ Ezt felelték neki: „Az első.“ Jézus ekkor ezt mondta nekik: „Bizony mondom néktek: A vámszedők és a parázna nők megelőznek titeket az Isten országában. ");
INSERT INTO hun_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Mert eljött hozzátok János, az igazság útján, és nem hittetek neki, a vámszedők és a parázna nők pedig hittek neki. Ti pedig, akik ezt láttátok, azután sem tértetek meg, és nem hittetek neki.“ ");
INSERT INTO hun_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Hallgassatok meg egy másik példázatot: „Volt egy gazda, aki szőlőt ültetett, azt gyepűvel körülvette, sajtót ásott le benne, és tornyot épített, kiadta munkásoknak, és elutazott. ");
INSERT INTO hun_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Amikor pedig a szüret ideje elérkezett, elküldte szolgáit a munkásokhoz, hogy vegyék át a termést. ");
INSERT INTO hun_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","A munkások megfogták a szolgáit, az egyiket megverték, a másikat megölték, a harmadikat pedig megkövezték. ");
INSERT INTO hun_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ismét küldött más szolgákat, többet, mint az előbb, és azokkal is úgy cselekedtek. ");
INSERT INTO hun_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Utoljára pedig elküldte saját fiát, ezt mondván: A fiamat meg fogják becsülni. ");
INSERT INTO hun_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","De a munkások meglátták a fiút, és azt mondták maguk közt: Ez az örökös. Gyertek, öljük meg, és foglaljuk el az örökségét. ");
INSERT INTO hun_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","És megfogták őt, kivetették a szőlőből, és megölték. ");
INSERT INTO hun_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Amikor azért megjön a szőlőnek ura, vajon mit tesz ezekkel a munkásokkal?“ ");
INSERT INTO hun_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ezt felelték neki: „Mivel gonoszok, gonoszul elveszti őket, a szőlőt pedig kiadja más munkásoknak, akik idejében odaadják majd neki a termést.“ ");
INSERT INTO hun_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Erre Jézus ezt kérdezte tőlük: „Sohasem olvastátok az Írásokban: »Amelyik követ az építők megvetettek, az lett a szegletkő, az Úrtól lett ez, és csodálatos a mi szemeink előtt«? ");
INSERT INTO hun_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ezért mondom nektek, hogy elvétetik tőletek az Istennek országa, és oly népnek adatik, amely megtermi annak gyümölcsét. ");
INSERT INTO hun_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","És aki erre a kőre esik, szétzúzza magát, akire pedig ez esik reá, szétmorzsolja azt.“ ");
INSERT INTO hun_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Amikor a papok és a farizeusok hallották példázatait, megértették, hogy róluk beszél. ");
INSERT INTO hun_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","És amikor el akarták őt fogni, megrémültek a sokaságtól, mivel prófétának tartották őt. ");
INSERT INTO hun_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jézus ismét példázatokban beszélt nekik: ");
INSERT INTO hun_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","„Hasonlatos a mennyek országa a királyhoz, aki a fiának menyegzőt készített. ");
INSERT INTO hun_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Elküldte szolgáit, hogy meghívják azokat, akik a menyegzőre hivatalosak voltak; de nem akartak eljönni. ");
INSERT INTO hun_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ismét küldött másik szolgákat, ezt mondva: Mondjátok meg a hivatalosoknak: Íme, ebédemet elkészítettem, ökreim és hizlalt állataim le vannak vágva, és kész minden: gyertek a menyegzőre. ");
INSERT INTO hun_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","De azok nem törődtek vele, elmentek: az egyik a szántóföldjére, a másik a kereskedésébe. ");
INSERT INTO hun_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","A többiek pedig megfogták szolgáit, bántalmazták, és megölték őket. ");
INSERT INTO hun_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Meghallotta ezt a király, megharagudott, és elküldte hadait, és ezeket a gyilkosokat megölette, és városaikat fölégette. ");
INSERT INTO hun_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Akkor ezt mondta szolgáinak: A menyegző ugyan készen van, de a hivatalosok nem voltak méltók. ");
INSERT INTO hun_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Menjetek azért a keresztutakra, és akit csak találtok, hívjátok be a menyegzőre. ");
INSERT INTO hun_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","És kimentek a szolgák az utakra, begyűjtöttek mindenkit, akiket csak találtak, jókat és gonoszakat egyaránt. És megtelt a menyegző vendégekkel. ");
INSERT INTO hun_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Amikor bement a király, hogy megtekintse a vendégeket, látott ott egy embert, akinek nem volt menyegzői ruhája, ");
INSERT INTO hun_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","és ezt mondta neki: Barátom, hogyan jöttél ide, holott nincsen menyegzői ruhád? Az pedig hallgatott. ");
INSERT INTO hun_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Akkor mondta a király a szolgáknak: Kötözzétek meg lábait és kezeit, vigyétek és vessétek őt a külső sötétségre; ott lesz sírás és fogcsikorgatás. ");
INSERT INTO hun_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Mert sokan vannak a hivatalosak, de kevesen a választottak.“ ");
INSERT INTO hun_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ekkor a farizeusok elmentek, és tanácsot tartottak, hogy szóval csalják tőrbe. ");
INSERT INTO hun_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Elküldték hozzá tanítványaikat a Heródes-pártiakkal, akik ezt mondták: „Mester, tudjuk, hogy igaz vagy, és az Isten útját igazán tanítod, és nem törődsz senkivel, mert nem emberek személyére nézel. ");
INSERT INTO hun_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Mondd meg nekünk tehát, mit gondolsz: szabad-e a császárnak adót fizetnünk vagy nem?“ ");
INSERT INTO hun_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jézus pedig ismerve álnokságukat, ezt mondta: „Mit kísértetek engem, képmutatók? ");
INSERT INTO hun_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Mutassátok nekem az adópénzt.“ Azok pedig odavittek neki egy dénárt. ");
INSERT INTO hun_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ekkor ezt kérdezte tőlük: „Kié ez a kép és ez a felírás?“ ");
INSERT INTO hun_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Azt felelték neki: „A császáré.“ Akkor ezt mondta nekik: „Adjátok meg tehát a császárnak, ami a császáré, és Istennek, ami Istené.“ ");
INSERT INTO hun_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ezt hallva elcsodálkoztak, otthagyták őt, és elmentek. ");
INSERT INTO hun_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ugyanazon a napon mentek hozzá a szadduceusok, akik a feltámadást tagadják, és megkérdezték őt: ");
INSERT INTO hun_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","„Mester, Mózes azt mondta: »ha valaki gyermek nélkül hal meg, annak testvére vegye el feleségét, és támasszon utódot testvérének.« ");
INSERT INTO hun_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Volt pedig nálunk hét testvér: és az első feleséget vett, meghalt, és mivelhogy nem volt gyermeke, feleségét a testvérére hagyta. ");
INSERT INTO hun_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Hasonlóképpen a második is, a harmadik is, mind a hetedikig. ");
INSERT INTO hun_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Legutoljára pedig az asszony is meghalt. ");
INSERT INTO hun_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","A feltámadáskor azért a hét közül melyiké lesz az asszony? Mert mindegyiké volt.“ ");
INSERT INTO hun_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jézus ezt felelte nekik: „Tévelyegtek, mivel nem ismeritek sem az írásokat, sem az Istennek hatalmát. ");
INSERT INTO hun_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Mert a feltámadáskor sem nem házasodnak, sem férjhez nem mennek, hanem olyanok lesznek, mint az Isten angyalai a mennyben. ");
INSERT INTO hun_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","A halottak feltámadása felől pedig nem olvastátok-e, amit az Isten mondott nektek, amikor így szólt: ");
INSERT INTO hun_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","»Én vagyok Ábrahám Istene, Izsák Istene és Jákób Istene«? Az Isten nem holtaknak, hanem élőknek Istene.“ ");
INSERT INTO hun_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","És a sokaság ezt hallva, csodálkozott az ő tudományán. ");
INSERT INTO hun_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","A farizeusok pedig amikor meghallották, hogy a szadduceusokat elnémította, egybegyűltek, ");
INSERT INTO hun_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","és megkérdezte őt közülük az egyik törvénytudó, hogy kísértse: ");
INSERT INTO hun_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","„Mester, melyik a nagy parancsolat a törvényben?“ ");
INSERT INTO hun_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jézus pedig ezt mondta neki: „»Szeresd az Urat, a te Istenedet teljes szívedből, teljes lelkedből és teljes elmédből.« ");
INSERT INTO hun_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ez az első és nagy parancsolat. ");
INSERT INTO hun_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","A második pedig hasonlatos ehhez: »Szeresd felebarátodat, mint magadat.« ");
INSERT INTO hun_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","E két parancsolattól függ az egész törvény és a próféták.“ ");
INSERT INTO hun_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Mikor a farizeusok egybegyülekeztek, megkérdezte őket Jézus: ");
INSERT INTO hun_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","„Hogyan vélekedtek ti a Krisztus felől? Kinek a fia?“ Ezt mondták neki: „A Dávidé.“ ");
INSERT INTO hun_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Aztán megkérdezte tőlük: „Hogyan hívhatja tehát őt Dávid lélekben Urának, amikor ezt mondja: ");
INSERT INTO hun_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","»Mondta az Úr az én Uramnak: Ülj az én jobb kezem felől, amíg lábaid alá nem vetem ellenségeidet zsámolyul.« ");
INSERT INTO hun_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ha tehát Dávid »Urának« hívja őt, hogyan lehet akkor a Fia?“ ");
INSERT INTO hun_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","És senki nem tudott neki felelni egyetlen szót sem, és megkérdezni sem merte őt többé senki ettől a naptól fogva. ");
INSERT INTO hun_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Akkor szólt Jézus a sokaságnak és a tanítványainak: ");
INSERT INTO hun_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","„Az írástudók és a farizeusok Mózes székében ülnek. ");
INSERT INTO hun_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ezért amit parancsolnak nektek, mindazt tartsátok meg, és tegyétek meg, de az ő cselekedeteik szerint ne cselekedjetek. Mert ők mondják, de nem cselekszik. ");
INSERT INTO hun_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Nehéz és elhordozhatatlan terheket kötöznek egybe, és az emberek vállaira vetik, de ők az ujjukkal sem akarják azokat megérinteni. ");
INSERT INTO hun_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Minden dolgukat pedig csak azért cselekszik, hogy lássák őket az emberek, mert megszélesítik homlokszíjaikat, megnagyobbítják köntöseik peremét, ");
INSERT INTO hun_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","szeretik a lakomákon a főhelyeket, és a gyülekezetekben az első helyeken szeretnek ülni. ");
INSERT INTO hun_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Szeretik, ha a piacokon köszöntik őket, és ha az emberek így hívják őket: Mester, mester! ");
INSERT INTO hun_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","De ti ne hivassátok magatokat mesternek, mert egy a ti mesteretek, a Krisztus, ti pedig mindnyájan testvérek vagytok. ");
INSERT INTO hun_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Atyátoknak se szólítsatok senkit ezen a földön, mert egy a ti Atyátok, aki a mennyben van. ");
INSERT INTO hun_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Tanítóknak se hívassátok magatokat, mert egy a ti tanítótok, a Krisztus. ");
INSERT INTO hun_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Hanem aki nagyobb közöttetek, legyen a ti szolgátok. ");
INSERT INTO hun_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Mert aki magát felmagasztalja, megaláztatik, és aki magát megalázza, felmagasztaltatik. ");
INSERT INTO hun_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","De jaj nektek, képmutató írástudók és farizeusok, mert a mennyeknek országát bezárjátok az emberek előtt: ti nem mentek be, és azokat sem engeditek be, akik be akarnának menni. ");
INSERT INTO hun_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Jaj nektek, képmutató írástudók és farizeusok, mert felemésztitek az özvegyek házát, és színből hosszan imádkoztok: ezért annál súlyosabb lesz a ti büntetésetek. ");
INSERT INTO hun_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Jaj nektek, képmutató írástudók és farizeusok, mert megkerülitek a tengert és a földet, hogy egy pogányt zsidóvá tegyetek, és ha azzá lett, a gyehenna fiává teszitek őt, kétszerte inkább magatoknál. ");
INSERT INTO hun_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Jaj nektek, vak vezetők, akik ezt mondjátok: Ha valaki a templomra esküszik, semmi az, de ha valaki a templom aranyára esküszik, akkor az kötelezi. ");
INSERT INTO hun_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Bolondok és vakok, melyik a nagyobb: az arany vagy a templom, amely szentté teszi az aranyat? ");
INSERT INTO hun_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","És: ha valaki az oltárra esküszik, semmi az, de ha valaki a rajta levő ajándékra esküszik, akkor az kötelezi. ");
INSERT INTO hun_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Bolondok és vakok: melyik a nagyobb, az ajándék vagy az oltár, amely szentté teszi az ajándékot? ");
INSERT INTO hun_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Aki azért az oltárra esküszik, esküszik arra, és mindazokra, amik azon vannak. ");
INSERT INTO hun_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","És aki a templomra esküszik, esküszik rá és arra, aki abban lakik. ");
INSERT INTO hun_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","És aki az égre esküszik, esküszik az Isten királyi székére és arra, aki abban ül. ");
INSERT INTO hun_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Jaj nektek, képmutató írástudók és farizeusok, mert megdézsmáljátok a mentát, a kaprot és a köményt, és elhagyjátok azt, amik a legnehezebbek a törvényben: az ítéletet, az irgalmasságot és a hűséget; pedig ezeket kellene cselekedni, és azokat sem elhagyni. ");
INSERT INTO hun_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Vak vezetők: kiszűritek a szúnyogot, a tevét pedig lenyelitek. ");
INSERT INTO hun_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Jaj nektek, képmutató írástudók és farizeusok, mert megtisztítjátok a pohárnak és a tálnak a külsejét, belül pedig meg vannak rakva zsákmánnyal és mértéktelenséggel. ");
INSERT INTO hun_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Vak farizeus, tisztítsd meg először a pohár és tál belsejét, hogy külsejük is tiszta legyen. ");
INSERT INTO hun_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Jaj nektek, képmutató írástudók és farizeusok, mert hasonlóak vagytok a meszelt sírokhoz, amelyek kívülről szépnek tetszenek, belül pedig holtaknak csontjaival és minden undoksággal vannak teli. ");
INSERT INTO hun_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Éppen így ti is, kívülről igazaknak látszotok ugyan, de belül tele vagytok képmutatással és törvénytelenséggel. ");
INSERT INTO hun_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Jaj nektek, képmutató írástudók és farizeusok, mert építitek a próféták sírjait, és felékesítitek az igazak síremlékeit, ");
INSERT INTO hun_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","és ezt mondjátok: Ha atyáink korában éltünk volna, nem lettünk volna bűntársaik a próféták vére ontásában. ");
INSERT INTO hun_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Így hát magatok ellen tesztek bizonyságot, hogy fiai vagytok azoknak, akik megölték a prófétákat. ");
INSERT INTO hun_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Töltsétek be ti is atyáitoknak mértékét! ");
INSERT INTO hun_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Kígyók, mérges kígyóknak fajzatai, hogyan kerülitek ki a gyehenna büntetését? ");
INSERT INTO hun_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ezért íme, prófétákat, bölcseket és írástudókat küldök hozzátok: és ezek közül némelyeket megöltök és megfeszítetek, másokat ezek közül zsinagógáitokban megostoroztok, és városról városra üldöztök, ");
INSERT INTO hun_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","hogy rátok szálljon minden igaz vér, amely kiömlött a földön, az igaz Ábelnak vérétől Zakariásnak, Barakiás fiának véréig, akit a templom és az oltár között megöltetek. ");
INSERT INTO hun_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Bizony mondom néktek, mindezek megtörténnek ezzel a nemzedékkel. ");
INSERT INTO hun_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","„Jeruzsálem, Jeruzsálem, ki megölöd a prófétákat, és megkövezed azokat, akik hozzád küldettek, hányszor akartam egybegyűjteni fiaidat, miképpen a tyúk egybegyűjti kiscsibéit szárnya alá, de te nem akartad. ");
INSERT INTO hun_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Íme, elhagyott lesz a ti házatok. ");
INSERT INTO hun_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Mert mondom néktek: Mostantól fogva nem láttok engem mindaddig, amíg ezt nem mondjátok: »Áldott, aki jön az Úr nevében!«“ ");
INSERT INTO hun_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Amikor kijött Jézus a templomból, és továbbment, odamentek hozzá tanítványai, hogy megmutassák neki a templom épületeit. ");
INSERT INTO hun_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Jézus pedig ezt mondta nekik: „Nem látjátok mindezeket? Bizony mondom néktek: nem marad itt kő kövön, amelyet le nem lerombolnak.“ ");
INSERT INTO hun_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Amikor pedig az Olajfák hegyén ült, tanítványai odamentek hozzá, és ezt kérdezték: „Mondd meg nekünk, mikor fognak ezek történni? És mi lesz a jele te eljövetelednek és a világ végének?“ ");
INSERT INTO hun_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jézus így felelt nekik: „Figyeljetek, hogy valaki meg ne tévesszen titeket. ");
INSERT INTO hun_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Mert sokan jönnek majd az én nevemben, akik ezt mondják: Én vagyok a Krisztus; és sokakat megtévesztenek. ");
INSERT INTO hun_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Hallanotok kell majd háborúkról és háborúk híreiről, figyeljetek, hogy meg ne rémüljetek, mert mindezeknek meg kell lenniük, de ez még nem a vég. ");
INSERT INTO hun_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Mert nemzet nemzet ellen támad, ország ország ellen, éhínség és ragály lesz, és földrengések lesznek mindenfele. ");
INSERT INTO hun_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Mindez pedig a sok nyomorúságnak a kezdete. ");
INSERT INTO hun_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Akkor nyomorúságra adnak majd benneteket, megölnek titeket, és gyűlöletesek lesztek minden nép előtt az én nevemért. ");
INSERT INTO hun_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Akkor sokan megbotránkoznak, elárulják és meggyűlölik egymást. ");
INSERT INTO hun_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Sok hamis próféta támad, akik sokakat megtévesztenek. ");
INSERT INTO hun_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Mivel pedig a gonoszság megsokasodik, a szeretet sokakban meghidegül. ");
INSERT INTO hun_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","De aki mindvégig állhatatos marad, az üdvözül. ");
INSERT INTO hun_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","És az Isten országának ez az evangéliuma hirdettetik majd az egész világon, bizonyságul minden népnek; és akkor jő el a vég. ");
INSERT INTO hun_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Mikor pedig látjátok majd, hogy »az a pusztító utálatosság«, amelyről Dániel próféta szólott, ott áll a szent helyen – aki olvassa, értse meg! – , ");
INSERT INTO hun_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","akkor akik Júdeában lesznek, fussanak a hegyekre, ");
INSERT INTO hun_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","aki a ház tetején van, ne szálljon le, hogy házából valamit kivigyen, ");
INSERT INTO hun_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","és aki a mezőn van, ne térjen vissza, hogy ruháját elvigye. ");
INSERT INTO hun_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Jaj a terhes és szoptató asszonyoknak azokon a napokon! ");
INSERT INTO hun_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Imádkozzatok pedig, hogy a futástok ne télen legyen, sem szombatnapon. ");
INSERT INTO hun_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Mert akkor olyan nagy nyomorúság lesz, amilyen nem volt a világ kezdete óta mind ez ideig, és nem is lesz soha. ");
INSERT INTO hun_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ha azok a napok nem rövidülnének meg, egyetlen ember sem menekülhetne meg, de a választottakért megrövidülnek majd azok a napok. ");
INSERT INTO hun_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","„Ha valaki ezt mondja akkor néktek: Íme, itt a Krisztus, vagy amott: ne higgyétek el. ");
INSERT INTO hun_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Mert hamis krisztusok és hamis próféták támadnak, és nagy jeleket és csodákat tesznek, annyira, hogy megtévesszék – ha lehet – a választottakat is. ");
INSERT INTO hun_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Íme, előre megmondattam nektek! ");
INSERT INTO hun_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ezért, ha azt mondják nektek: Íme, a pusztában van, ne menjetek ki! Íme, a belső szobákban, ne higgyétek! ");
INSERT INTO hun_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Mert amiképpen a villámlás napkeletről támad, és ellátszik egész napnyugatig, úgy lesz az Emberfiának eljövetele is. ");
INSERT INTO hun_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Mert ahol a dög, oda gyűlnek a keselyűk. ");
INSERT INTO hun_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Mindjárt pedig ama napok nyomorúságai után »a nap elsötétedik, és a hold nem fénylik, a csillagok az égről lehullanak, és az egek összetartó erői megrendülnek.« ");
INSERT INTO hun_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","És akkor feltűnik az Emberfiának jele az égen, akkor sír majd a föld minden nemzetsége, és meglátják az Emberfiát eljönni az ég felhőiben nagy hatalommal és dicsőséggel. ");
INSERT INTO hun_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","És elküldi az angyalait nagy trombitaszóval, és egybegyűjtik az ő választottait a négy égtáj felől, az ég egyik végétől a másik végéig. ");
INSERT INTO hun_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","A fügefáról vegyétek a példát: amikor az ága már zsendül, és levelet hajt, tudjátok, hogy közel van a nyár. ");
INSERT INTO hun_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Így ti is, amikor mindezeket látjátok, tudjátok meg, hogy közel van ő, az ajtó előtt. ");
INSERT INTO hun_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Bizony mondom néktek, el nem múlik ez a nemzedék, míg mindezek meg nem történnek. ");
INSERT INTO hun_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Az ég és a föld elmúlnak, de az én beszédeim semmiképpen el nem múlnak. ");
INSERT INTO hun_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Arról a napról és óráról pedig senki sem tud, az ég angyalai sem, hanem csak az én Atyám egyedül. ");
INSERT INTO hun_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Amiképpen pedig Noé napjaiban volt, akképpen lesz az Emberfiának eljövetele is. ");
INSERT INTO hun_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Mert ahogyan az özönvíz előtti napokban ettek és ittak, házasodtak és férjhez mentek mindaddig a napig, amelyen Noé a bárkába ment, ");
INSERT INTO hun_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","és nem vettek észre semmit, míg el nem jött az özönvíz, és elragadta őket, akképpen lesz az Emberfiának eljövetele is. ");
INSERT INTO hun_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Akkor ketten lesznek a mezőn: az egyik felvétetik, a másik otthagyatik, ");
INSERT INTO hun_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","két asszony őröl a malomban, az egyik felvétetik, a másik otthagyatik. ");
INSERT INTO hun_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Vigyázzatok tehát, mert nem tudjátok, mely órában jön el a ti Uratok! ");
INSERT INTO hun_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Azt pedig jegyezzétek meg: ha tudná a ház ura, hogy az éjszakának melyik szakában jön el a tolvaj: vigyázna, és nem engedné, hogy házába törjön. ");
INSERT INTO hun_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ezért legyetek készen ti is, mert amelyik órában nem gondoljátok, abban jön el az Emberfia! ");
INSERT INTO hun_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","„Ki tehát a hű és bölcs szolga, akit az ő ura gondviselővé tett a háza népén, hogy a maga idejében adjon nekik eledelt? ");
INSERT INTO hun_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Boldog az a szolga, akit az ő ura hazajőve ily munkában talál. ");
INSERT INTO hun_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Bizony mondom néktek, hogy minden jószága fölött gondviselővé teszi őt. ");
INSERT INTO hun_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ha pedig ama gonosz szolga így szólna szívében: Halogatja még az én uram a hazajövetelt, ");
INSERT INTO hun_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","és az ő szolgatársait verni kezdené, a részegesekkel pedig enni és inni kezdene: ");
INSERT INTO hun_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","megjön annak a szolgának az ura, amelyik napon nem várja, és amelyik napon nem gondolja; ");
INSERT INTO hun_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","akkor kettévágatja őt, és a képmutatók sorsára juttatja: ott lesz sírás és fogcsikorgatás.“ ");
INSERT INTO hun_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","„Akkor hasonlatos lesz a mennyek országa a tíz szűzhöz, akik elővették lámpásaikat, és kimentek a vőlegény elé. ");
INSERT INTO hun_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Öt pedig közülük eszes volt, és öt bolond. ");
INSERT INTO hun_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Akik bolondok voltak, amikor lámpásaikat elővették, nem vittek magukkal olajat. ");
INSERT INTO hun_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Az eszesek pedig lámpásaikkal együtt olajat is vittek magukkal az edényeikben. ");
INSERT INTO hun_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Mivel pedig a vőlegény késett, mindannyian elszunnyadtak és elaludtak. ");
INSERT INTO hun_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Éjfélkor pedig kiáltás hallatszott: Íme, jön a vőlegény! Jöjjetek elé! ");
INSERT INTO hun_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Akkor felkeltek a szüzek mind, és elkészítették lámpásaikat. ");
INSERT INTO hun_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","A bolondok ezt mondták az eszeseknek: Adjatok nekünk olajotokból, mert a mi lámpásaink ki fognak aludni. ");
INSERT INTO hun_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Az eszesek pedig így feleltek: Nem lenne elegendő talán sem nekünk, sem nektek; menjetek inkább az árusokhoz, és vegyetek magatoknak. ");
INSERT INTO hun_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Mikor pedig elmentek vásárolni, megérkezett a vőlegény, és akik készen voltak, bementek vele a menyegzőre, és bezárták az ajtót. ");
INSERT INTO hun_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Később pedig a többi szűz is megjött, és ezt mondták: Uram, uram, nyisd ki nekünk. ");
INSERT INTO hun_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ő pedig így felelt: Bizony mondom néktek, nem ismerlek titeket. ");
INSERT INTO hun_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Vigyázzatok azért, mert sem a napot, sem az órát nem tudjátok, amelyen az Emberfia eljön. ");
INSERT INTO hun_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","„Mert éppen úgy van ez, mint az az ember, aki útra akart kelni, hívatta szolgáit, és amije volt, átadta nekik. ");
INSERT INTO hun_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Az egyiknek öt talentumot adott, a másiknak kettőt, a harmadiknak pedig egyet, kinek-kinek erejéhez képest, és azonnal útra kelt. ");
INSERT INTO hun_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Az, aki az öt talentumot kapta, elment, kereskedett azokkal, és szerzett másik öt talentumot. ");
INSERT INTO hun_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ugyanígy, akié a kettő volt, az is másik kettőt nyert hozzá. ");
INSERT INTO hun_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Aki pedig az egyet kapta, elment, elásta azt a földbe, és elrejtette urának pénzét. ");
INSERT INTO hun_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Sok idő múlva pedig megjött a szolgáknak ura, és számadást tartott velük. ");
INSERT INTO hun_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Eljött az, aki az öt talentumot kapta, és hozott másik öt talentumot, és ezt mondta: Uram, öt talentumot adtál nekem, íme, másik öt talentumot nyertem azokon. ");
INSERT INTO hun_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ura pedig ezt mondta neki: Jól van, jó és hű szolgám, kevésen voltál hű, sokra bízlak ezután, menj be uradnak örömébe. ");
INSERT INTO hun_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Eljött az is, ki a két talentumot kapta, és ezt mondta: Uram, két talentumot adtál nekem, íme, két másik talentumot nyertem rajta. ");
INSERT INTO hun_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ura ezt mondta neki: Jól van, jó és hű szolgám, kevésen voltál hű, sokra bízlak ezután, menj be uradnak örömébe. ");
INSERT INTO hun_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Eljött az is, aki az egy talentumot kapta, és ezt mondta: Uram, tudtam, hogy te kegyetlen ember vagy, aki ott is aratsz, ahol nem vetettél, ott is gyűjtesz, ahol nem szórtál. ");
INSERT INTO hun_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ezért félelmemben elmentem, és elástam a te talentumodat a földbe: Íme, itt van, ami a tied. ");
INSERT INTO hun_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ura pedig így felelt neki: Gonosz és rest szolga, tudtad, hogy ott is aratok, ahol nem vetettem, és ott is gyűjtök, ahol nem szórtam. ");
INSERT INTO hun_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","El kellett volna helyezned pénzemet a pénzváltóknál, és én megjőve nyereséggel kaptam volna meg a magamét. ");
INSERT INTO hun_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Vegyétek el ezért tőle a talentumot, és adjátok oda annak, akinek tíz talentuma van. ");
INSERT INTO hun_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Mert mindenkinek, akinek van, adatik, és megszaporíttatik; akinek pedig nincsen, attól az is elvétetik, amije van. ");
INSERT INTO hun_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","A haszontalan szolgát vessétek a külső sötétségre: ott lesz sírás és fogcsikorgatás. ");
INSERT INTO hun_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","„Amikor pedig eljön az Emberfia az ő dicsőségében és vele a szent angyalok mind, akkor majd beül dicsőségének királyi székébe. ");
INSERT INTO hun_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","És eléje gyűjtenek minden népet, és elválasztják majd őket egymástól, ahogyan a pásztor elválasztja a juhokat a kecskéktől. ");
INSERT INTO hun_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","És a juhokat jobb keze felől, a kecskéket pedig bal keze felől állítja. ");
INSERT INTO hun_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Akkor ezt mondja a király a jobb keze felől állóknak: Gyertek, Atyám áldottai, örököljétek ezt az országot, amelyet számotokra készített a világ megalapítása óta. ");
INSERT INTO hun_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Mert éheztem, és ennem adtatok, szomjaztam, és innom adtatok, jövevény voltam, és befogadtatok, ");
INSERT INTO hun_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","mezítelen voltam, és felruháztatok, beteg voltam, és meglátogattatok, fogoly voltam, és eljöttetek hozzám. ");
INSERT INTO hun_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Akkor így felelnek majd neki az igazak: Uram, mikor láttuk, hogy éheztél, és tápláltunk volna, vagy szomjaztál, és innod adtunk volna? ");
INSERT INTO hun_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Mikor láttuk, hogy jövevény voltál, és befogadtunk volna, vagy mezítelen voltál, és felruháztunk volna? ");
INSERT INTO hun_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Mikor láttuk, hogy beteg vagy fogoly voltál, és hozzád mentünk volna? ");
INSERT INTO hun_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","És így felel a király majd nekik: Bizony mondom néktek, amennyiben megcselekedtétek ezt eggyel az én legkisebb atyámfiai közül, velem cselekedtétek meg. ");
INSERT INTO hun_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Akkor szól majd a bal keze felől állókhoz is: Távozzatok tőlem, átkozottak, az ördögöknek és az ő angyalainak elkészített örök tűzre. ");
INSERT INTO hun_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Mert éheztem, és nem adtatok ennem, szomjaztam, és nem adtatok innom, ");
INSERT INTO hun_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","jövevény voltam, és nem fogadtatok be, mezítelen voltam, és nem ruháztatok fel, beteg és fogoly voltam, és nem látogattatok meg engem. ");
INSERT INTO hun_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Akkor ezek is így felelnek majd neki: Uram, mikor láttuk, hogy éheztél vagy szomjaztál, vagy hogy jövevény, vagy mezítelen, vagy beteg, vagy fogoly voltál, és nem szolgáltunk volna neked? ");
INSERT INTO hun_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Akkor így felel majd nekik: Bizony mondom néktek, amennyiben nem cselekedtétek meg eggyel ezekkel a legkisebbek közül, velem nem cselekedtétek meg. ");
INSERT INTO hun_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","És ezek elmennek az örök gyötrelemre, az igazak pedig az örök életre.“ ");
INSERT INTO hun_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Amikor Jézus mindezeket a beszédeket befejezte, ezt mondta tanítványainak: ");
INSERT INTO hun_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","„Tudjátok, hogy két nap múlva húsvétnak ünnepe lesz, és az Emberfia elárultatik, hogy megfeszítsék.“ ");
INSERT INTO hun_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Akkor egybegyűltek a főpapok, az írástudók és a nép vénei a főpap házában, akit Kajafásnak hívtak. ");
INSERT INTO hun_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","És tanácsot tartottak, hogy Jézust csellel elfogják és megölik. ");
INSERT INTO hun_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","De ezt mondták: „Ne az ünnepen: nehogy zendülés legyen a nép között.“ ");
INSERT INTO hun_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Amikor Jézus Betániában, a poklos Simon házában volt, ");
INSERT INTO hun_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","odament hozzá egy asszony, akinél drága kenetnek alabástrom szelencéje volt, és ezt a fejére öntötte, amint az asztalnál ült. ");
INSERT INTO hun_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Látva ezt tanítványai, bosszankodtak, és ezt mondták: „Mire való ez a tékozlás? ");
INSERT INTO hun_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Mert eladhatták volna ezt a kenetet nagy áron, és odaadhatták volna árát a szegényeknek.“ ");
INSERT INTO hun_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Amikor ezt észrevette Jézus, ezt mondta nekik: „Miért bántjátok ezt az asszonyt? Hiszen jó dolgot cselekedett velem. ");
INSERT INTO hun_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Mert a szegények mindenkor veletek lesznek, de én nem leszek mindenkor veletek. ");
INSERT INTO hun_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Mert amikor ő ezt a kenetet testemre öntötte, a temetésemre gondolva cselekedte azt. ");
INSERT INTO hun_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Bizony mondom néktek, hogy ahol az egész világon prédikálják majd az evangéliumot, amit ez énvelem cselekedett, azt is hirdetik majd az ő emlékezetére!“ ");
INSERT INTO hun_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Akkor a tizenkettő közül egy, akit Iskariótes Júdásnak hívtak, a főpapokhoz ment, ");
INSERT INTO hun_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","és ezt mondta: „Mit akartok nekem adni, ha én kezetekbe adom őt?“ Azok pedig harminc ezüstpénzt rendeltek neki. ");
INSERT INTO hun_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","És ettől fogva keresete az alkalmat, hogy elárulja őt. ");
INSERT INTO hun_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","A kovásztalan kenyerek első napján odamentek Jézushoz a tanítványok, és ezt mondták: „Hol akarod, hogy elkészítsük neked a húsvéti bárányt?“ ");
INSERT INTO hun_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ő pedig ezt válaszolta: „Menjetek el a városba ahhoz a bizonyos emberhez, és ezt mondjátok neki: A Mester üzeni: Az én időm közel van; nálad tartom meg a húsvétot tanítványaimmal.“ ");
INSERT INTO hun_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","És úgy cselekedtek a tanítványok, amint Jézus parancsolta nekik, és elkészítették a húsvéti bárányt. ");
INSERT INTO hun_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Mikor pedig beesteledett, letelepedett a tizenkettővel, ");
INSERT INTO hun_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","és amikor ettek, ezt mondta: „Bizony mondom néktek, közületek egy elárul engem.“ ");
INSERT INTO hun_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","És felettébb megszomorodva kezdték mindannyian kérdezni tőle: „Én vagyok-e az, Uram?“ ");
INSERT INTO hun_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ő pedig így felelt: „Aki velem együtt mártja kezét a tálba, az árul el engem. ");
INSERT INTO hun_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Az Emberfia jóllehet elmegy, amint meg van írva felőle, de jaj annak az embernek, aki az Emberfiát elárulja; jobb volna annak az embernek, ha nem született volna meg.“ ");
INSERT INTO hun_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Megszólalt Júdás is, aki elárulta őt, és ezt mondta: „Én vagyok az, Mester?“ Ő ezt felelte: „Te mondtad.“ ");
INSERT INTO hun_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Mikor pedig ettek, vette Jézus a kenyeret, hálát adott, megtörte és a tanítványoknak adta, és ezt mondta: „Vegyétek és egyétek, ez az én testem!“ ");
INSERT INTO hun_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Azután vette a poharat, és hálát adott, nekik adta, és ezt mondta: „Igyatok ebből mindnyájan, ");
INSERT INTO hun_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","mert ez az én vérem, az új szövetség vére, amely sokakért kiontatik bűnöknek bocsánatára. ");
INSERT INTO hun_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Mondom pedig néktek: Mostantól fogva nem iszom a szőlőtőkének ebből a terméséből mind ama napig, amikor újat iszom veletek Atyámnak országában.“ ");
INSERT INTO hun_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","És dicséretet énekelve, kimentek az Olajfák hegyére. ");
INSERT INTO hun_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Akkor ezt mondta nekik Jézus: „Mindnyájan ezen az éjszakán megbotránkoztok énbennem. Mert meg van írva: »Megverem a pásztort, és elszélednek a nyájnak juhai.« ");
INSERT INTO hun_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","De föltámadásom után előttetek megyek majd Galileába.“ ");
INSERT INTO hun_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Péter pedig így felelt neki: „Ha mindnyájan megbotránkoznak is tebenned, én soha meg nem botránkozom.“ ");
INSERT INTO hun_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jézus ezt mondta neki: „Bizony mondom néked, ezen az éjszakán, mielőtt megszólal a kakas, háromszor megtagadsz engem.“ ");
INSERT INTO hun_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Péter ezt mondta neki: „Ha meg is kell veled halnom, akkor sem tagadlak meg téged.“ Hasonlóképpen szóltak a többi tanítványok is. ");
INSERT INTO hun_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Akkor elment Jézus velük egy helyre, amelyet Gecsemánénak hívtak, és ezt mondta a tanítványoknak: „Üljetek le itt, míg elmegyek, és amott imádkozom.“ ");
INSERT INTO hun_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","És maga mellé vette Pétert és Zebedeusnak két fiát, kezdett szomorkodni és gyötrődni. ");
INSERT INTO hun_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ekkor ezt mondta nekik: „Felette igen szomorú az én lelkem mindhalálig! Maradjatok itt, és virrasszatok énvelem.“ ");
INSERT INTO hun_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","És egy kissé előre menve, arcra borult, és így könyörgött: „Atyám! Ha lehetséges múljék el tőlem e pohár; mindazáltal ne úgy legyen, amint én akarom, hanem amint te.“ ");
INSERT INTO hun_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ekkor odament a tanítványokhoz, és alva találta őket, és ezt mondta Péternek: „Így nem bírtok velem virrasztani egy óráig sem? ");
INSERT INTO hun_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Virrasszatok, és imádkozzatok, hogy kísértésbe ne essetek; mert jóllehet a lélek kész, de a test erőtlen.“ ");
INSERT INTO hun_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ismét elment másodszor is, és így könyörgött: „Atyám! Ha el nem múlhat tőlem e pohár, hogy ki ne igyam, legyen meg a te akaratod.“ ");
INSERT INTO hun_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","És amikor visszatért, ismét alva találta őket, mert elnehezedtek szemeik. ");
INSERT INTO hun_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Otthagyva őket ismét elment, és imádkozott harmadszor ugyanazokkal a szavakkal szólva. ");
INSERT INTO hun_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ekkor odament tanítványaihoz, és ezt mondta nekik: „Aludjatok immár, és nyugodjatok. Íme, elközelgett az óra, és az Emberfia a bűnösök kezére adatik. ");
INSERT INTO hun_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Keljetek fel, menjünk! Íme, közel van, aki elárul engem.“ ");
INSERT INTO hun_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Amikor még beszélt, íme, Júdás, egy a tizenkettő közül, eljött a főpapoktól és a nép véneitől, és vele együtt nagy sokaság fegyverekkel és fustélyokkal. ");
INSERT INTO hun_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Aki pedig őt elárulta, jelt adott nekik: „Akit én majd megcsókolok, ő az, fogjátok el őt.“ ");
INSERT INTO hun_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","És mindjárt Jézushoz lépve ezt mondta: „Üdvözlégy, Mester!“ És megcsókolta. ");
INSERT INTO hun_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jézus pedig ezt mondta neki: „Barátom, miért jöttél?“ Akkor odamentek hozzá, kezeiket Jézusra vetették, és elfogták őt. ");
INSERT INTO hun_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","És íme, egy azok közül, akik Jézussal voltak, kinyújtva kezét, szablyáját kirántotta, és a főpap szolgáját megcsapva, levágta annak egyik fülét. ");
INSERT INTO hun_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Akkor ezt mondta neki Jézus: „Tedd helyére szablyádat, mert akik fegyvert fognak, fegyverrel kell veszniük. ");
INSERT INTO hun_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Vagy azt gondolod, hogy nem kérhetném most az én Atyámat, hogy adjon ide mellém tizenkét sereg angyalnál is többet? ");
INSERT INTO hun_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","De miképpen teljesednének be az Írások, hogy így kell lennie?“ ");
INSERT INTO hun_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ugyanekkor ezt mondta Jézus a sokaságnak: „Mint valami latorra úgy jöttetek, fegyverekkel és fustélyokkal, hogy megfogjatok engem? Naponként nálatok ültem, tanítva a templomban, és mégsem fogtatok el engem.“ ");
INSERT INTO hun_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Mindez pedig azért lett, hogy beteljesedjenek a próféták írásai. Ekkor elhagyták őt a tanítványok mind, és elfutottak. ");
INSERT INTO hun_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Azok pedig megfogták Jézust, elvitték Kajafáshoz, a főpaphoz, ahol az írástudók és vének összegyűltek. ");
INSERT INTO hun_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Péter pedig követte őt távolról, egészen a főpap pitvaráig, és bement, leült a szolgákkal, hogy lássa a dolgok végét. ");
INSERT INTO hun_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","A főpapok pedig és a vének és az egész tanács hamis bizonyítékot keresett Jézus ellen, hogy megölhessék őt, ");
INSERT INTO hun_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","de nem találtak. Noha sok hamis tanú állt elő, mégsem találtak. Végül pedig előállt két hamis tanú, ");
INSERT INTO hun_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","és így szólt: „Ez azt mondta: Lerombolhatom az Isten templomát, és három nap alatt felépíthetem azt.“ ");
INSERT INTO hun_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","És fölkelt a főpap, és ezt mondta neki: „Semmit sem felelsz? Micsoda tanúbizonyságot tesznek ezek ellened?“ ");
INSERT INTO hun_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Jézus pedig hallgatott. A főpap ekkor ezt mondta neki: „Az élő Istenre kényszerítlek téged, hogy mondd meg nekünk, hogy te vagy-e a Krisztus, az Istennek Fia?“ ");
INSERT INTO hun_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jézus ezt felelte: „Te mondtad. Sőt mondom nektek: Mostantól fogva meglátjátok az Emberfiát az Istennek hatalmas jobbján ülni és eljönni az égnek felhőiben.“ ");
INSERT INTO hun_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ekkor a főpap megszaggatta ruháit, és ezt mondta: „Káromlást szólt. Mi szükségünk van még bizonyítékokra? Íme, most hallottátok az istenkáromlást. ");
INSERT INTO hun_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Mit gondoltok?“ Azok pedig így feleltek: „Méltó a halálra.“ ");
INSERT INTO hun_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Akkor szembeköpték, és arcul csapták, néhányan pedig botokkal verték, ");
INSERT INTO hun_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","és ezt mondták: „Prófétáld meg nekünk, Krisztus, ki az, aki megütött téged!“ ");
INSERT INTO hun_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Péter pedig kint ült az udvaron. Odament hozzá egy szolgálóleány, és ezt mondta: „Te is a galileai Jézussal voltál.“ ");
INSERT INTO hun_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ő pedig mindenkinek a hallatára megtagadta, és ezt mondta: „Nem tudom, mit beszélsz.“ ");
INSERT INTO hun_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Amikor pedig kiment a tornácra, meglátta őt egy másik szolgálóleány, és ezt mondta az ott levőknek: „Ez is a názáreti Jézussal volt.“ ");
INSERT INTO hun_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","És ismét megtagadta, mégpedig esküvel: „Nem is ismerem ezt az embert.“ ");
INSERT INTO hun_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Kevés idő múlva pedig az ott álldogálók mentek oda hozzá, és mondták Péternek: „Bizony te is közülük való vagy, hiszen a te beszéded is elárul téged.“ ");
INSERT INTO hun_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ekkor átkozódni és esküdözni kezdett: „Nem ismerem ezt az embert.“ És a kakas azonnal megszólalt. ");
INSERT INTO hun_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","És visszaemlékezett Péter Jézus szavára, aki ezt mondta neki: „Mielőtt a kakas megszólal, háromszor megtagadsz engem.“ És kimenve onnan keserves sírásra fakadt. ");
INSERT INTO hun_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Amikor pedig reggel lett, tanácsot tartottak mind a főpapok és a nép vénei Jézus ellen, hogy őt megöljék. ");
INSERT INTO hun_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Megkötözték, elvitték és átadták Poncius Pilátusnak, a helytartónak. ");
INSERT INTO hun_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Akkor látta Júdás, aki őt elárulta, hogy elítélték, megbánta tettét, és visszavitte a harminc ezüstpénzt a főpapoknak és a véneknek, ");
INSERT INTO hun_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","és ezt mondta: „Vétkeztem, hogy elárultam az ártatlan vért.“ Azok pedig ezt mondták: „Mi közünk hozzá? A te dolgod!“ ");
INSERT INTO hun_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ő pedig eldobta az ezüstpénzeket a templomban, eltávozott, elment, és felakasztotta magát. ");
INSERT INTO hun_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","A főpapok pedig felszedték az ezüstpénzeket, és ezt mondták: „Nem szabad ezeket a templom kincsei közé tennünk, mert vér díja.“ ");
INSERT INTO hun_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Tanácsot ültek, és megvásárolták azon a Fazekasmezőt, idegenek számára temetőnek. ");
INSERT INTO hun_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ezért hívják ezt a mezőt Vérmezőnek mind a mai napig. ");
INSERT INTO hun_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ekkor teljesedett be Jeremiás próféta mondása, aki így szólott: „És vették a harminc ezüstpénzt, a megbecsültnek árát, akit Izrael fiai ennyire becsültek. ");
INSERT INTO hun_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","És adták a Fazekasmezőért, amint az Úr rendelte nékem.“ ");
INSERT INTO hun_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jézus pedig ott állt a helytartó előtt, aki ezt kérdezte tőle: „Te vagy-e a zsidók királya?“ Jézus pedig ezt mondta neki: „Te mondod.“ ");
INSERT INTO hun_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","És amikor a főpapok és a vének vádolták őt, semmit sem felelt. ");
INSERT INTO hun_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Akkor ezt mondta neki Pilátus: „Nem hallod, milyen sok mindent vallanak ellened?“ ");
INSERT INTO hun_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","És nem felelt neki egyetlen szóra sem, úgyhogy a helytartó igen elcsodálkozott. ");
INSERT INTO hun_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ünnepenként pedig egy foglyot szokott szabadon bocsátani a helytartó a sokaság kedvéért, akit akarnak. ");
INSERT INTO hun_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Volt akkor egy nevezetes foglyuk, akit Barabbásnak hívtak. ");
INSERT INTO hun_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Mikor ezért egybegyűltek, ezt mondta nekik Pilátus: „Melyiket akarjátok, hogy elbocsássam nektek: Barabbást vagy Jézust, akit Krisztusnak hívnak?“ ");
INSERT INTO hun_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Mert jól tudta, hogy irigységből adták őt kezére. ");
INSERT INTO hun_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Amint pedig az ítélőszékben ült, küldött jött hozzá feleségétől, aki ezt üzente: „Ne avatkozz ennek az igaz embernek dolgába, mert sokat szenvedtem ma álmomban miatta.“ ");
INSERT INTO hun_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","A főpapok és vének pedig rábeszélték a sokaságot, hogy Barabbást kérjék ki, Jézust pedig veszítsék el. ");
INSERT INTO hun_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","A helytartó megkérdezte tőlük: „A kettő közül melyiket akarjátok, hogy elbocsássam nektek?“ Azok pedig ezt mondták: „Barabbást.“ ");
INSERT INTO hun_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilátus ezt mondta nekik: „Mit cselekedjem hát Jézussal, akit Krisztusnak hívnak?“ Mindnyájan ezt mondták: „Feszíttessék meg!“ ");
INSERT INTO hun_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","A helytartó ezután ezt mondta: „Mert mi rosszat cselekedett?“ Azok pedig még inkább kiáltoztak: „Feszíttessék meg!“ ");
INSERT INTO hun_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilátus pedig látva, hogy semmit sem használ, hanem még nagyobb háborúság támad, vizet hozatott, megmosta kezeit a sokaság előtt, és ezt mondta: „Ártatlan vagyok ennek az igaz embernek vérétől. Ti lássátok!“ ");
INSERT INTO hun_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Az egész nép ezt mondta: „Az ő vére mirajtunk és magzatainkon!“ ");
INSERT INTO hun_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Akkor elbocsátotta nekik Barabbást, Jézust pedig megostoroztatta, és kezükbe adta, hogy feszítsék meg. ");
INSERT INTO hun_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Akkor a helytartó vitézei elvitték Jézust az őrházba, és odagyűjtötték hozzá az egész csapatot. ");
INSERT INTO hun_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Levetkőztették, bíborpalástot adtak rá, ");
INSERT INTO hun_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","tövisből font koronát tettek fejére, és nádszálat a jobb kezébe, és térdet hajtva előtte csúfolták őt, ezt mondva: „Üdvözlégy, zsidóknak királya!“ ");
INSERT INTO hun_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Amikor megköpdösték őt, elvették tőle a nádszálat, és fejéhez verdesték. ");
INSERT INTO hun_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Miután megcsúfolták, levették róla a palástot, maga ruháiba felöltöztették, és elvitték, hogy keresztre feszítsék őt. ");
INSERT INTO hun_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Kifele menet pedig találkoztak egy cirénei emberrel, akit Simonnak hívtak, ezt kényszerítették, hogy vigye az ő keresztjét. ");
INSERT INTO hun_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Amikor eljutottak arra a helyre, amit Golgotának, azaz Koponya-helynek neveztek, ");
INSERT INTO hun_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","méreggel kevert ecetet adtak neki inni. De amikor megízlelte azt, nem akart inni. ");
INSERT INTO hun_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Miután pedig megfeszítették őt, elosztották ruháit, sorsot vetve, hogy beteljesedjék a próféta mondása: „Megosztoznak ruháimon, és köntösömre sorsot vetnek.“ ");
INSERT INTO hun_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Azután leültek ott, és őrizték őt. ");
INSERT INTO hun_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Feje fölé illesztették elítélésének okát, ez volt odaírva: „Ez Jézus, a zsidók királya.“ ");
INSERT INTO hun_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Akkor megfeszítettek vele együtt két latrot is, egyiket jobb kéz felől, a másikat bal kéz felől. ");
INSERT INTO hun_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Az arra menők pedig szidalmazták őt, fejüket csóválva, ");
INSERT INTO hun_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","és ezt mondták: „Te, aki lerontod a templomot, és harmadnapra felépíted, szabadítsd meg magadat; ha Isten Fia vagy, szállj le a keresztről!“ ");
INSERT INTO hun_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Hasonlóképpen csúfolódtak a főpapok az írástudókkal és vénekkel együtt, és ezt mondták: ");
INSERT INTO hun_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","„Másokat megtartott, magát nem tudja megtartani. Ha Izrael királya, szálljon le most a keresztről, és hiszünk neki. ");
INSERT INTO hun_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Bízott az Istenben: mentse meg most őt, ha akarja; hiszen azt mondta: Isten Fia vagyok.“ ");
INSERT INTO hun_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Akiket vele együtt feszítettek meg, a latrok is ugyanazt hányták szemére. ");
INSERT INTO hun_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Hat órától kezdve sötétség lett mind az egész földön, kilenc óráig. ");
INSERT INTO hun_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Kilenc óra körül pedig hangosan kiáltott Jézus: „Éli, Éli! Lamá sabaktáni?“ azaz: „Én Istenem, én Istenem! Miért hagytál el engemet?“ ");
INSERT INTO hun_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Némelyek pedig az ott állók közül, amint ezt hallották, ezt mondták: „Illést hívja.“ ");
INSERT INTO hun_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Egy közülük azonnal odafutott, fogott egy szivacsot, megtöltötte ecettel, és egy nádszálra tűzte, majd inni adott neki. ");
INSERT INTO hun_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","A többiek pedig ezt mondták: „Hagyd el, lássuk, eljön-e Illés, hogy megszabadítsa őt?“ ");
INSERT INTO hun_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jézus pedig ismét hangosan felkiáltott, és kiadta lelkét. ");
INSERT INTO hun_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","És íme, a templom kárpitja felülről az aljáig kettéhasadt, a föld megrendült, és a kősziklák megrepedeztek. ");
INSERT INTO hun_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","A sírok megnyíltak, és sok elhunyt szentnek a teste feltámadt. ");
INSERT INTO hun_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","És kijöttek a sírokból, és Jézus feltámadása után bementek a szent városba, és sokaknak megjelentek. ");
INSERT INTO hun_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","A százados pedig és akik vele őrizték Jézust, látva a földrengést, és amik történtek, igen megrémültek, és ezt mondták: „Bizony Istennek Fia volt ez!“ ");
INSERT INTO hun_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Sok asszony volt ott, akik távolról szemlélődtek, akik Galileából követték Jézust, szolgálva neki. ");
INSERT INTO hun_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ezek közt volt a magdalai Mária és Mária, Jakab és József anyja és a Zebedeus fiainak anyja. ");
INSERT INTO hun_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Amikor pedig beesteledett, eljött egy gazdag ember Arimátiából, név szerint József, aki maga is tanítványa volt Jézusnak. ");
INSERT INTO hun_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ez elment Pilátushoz, és elkérte Jézus testét. Akkor megparancsolta Pilátus, hogy adják át neki. ");
INSERT INTO hun_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","És magához vette József a testet, begöngyölte tiszta gyolcsba, ");
INSERT INTO hun_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","és elhelyezte a maga új sírjába, amelyet a sziklába vágatott. A sír szájára egy nagy követ hengerített, és elment. ");
INSERT INTO hun_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ott volt pedig a magdalai Mária és a másik Mária, akik a sírral szemben ültek. ");
INSERT INTO hun_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Másnap pedig, amely péntek után következik, összegyűltek a főpapok és a farizeusok Pilátushoz, ");
INSERT INTO hun_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","és ezt mondták: „Uram, emlékszünk rá, hogy az a csaló még életében azt mondta: Harmadnapra föltámadok. ");
INSERT INTO hun_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Parancsold meg ezért, hogy őrizzék a sírt harmadnapig, nehogy a tanítványai odamenve éjjel, ellopják őt, és azt mondják a népnek: Feltámadott a halálból. Ez az utolsó hitetés még gonoszabb lenne az elsőnél.“ ");
INSERT INTO hun_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilátus pedig ezt mondta nekik: „Van őrségetek, menjetek, őriztessétek, ahogyan tudjátok.“ ");
INSERT INTO hun_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ők pedig elmentek, lepecsételték a követ, és az őrséggel őrizet alá helyezték a sírt. ");
INSERT INTO hun_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","A szombat végén, a hét első napjára virradóan kiment a magdalai Mária és a másik Mária, hogy megnézzék a sírt. ");
INSERT INTO hun_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","És íme, nagy földrengés támadt, mert az Úrnak angyala leszállt a mennyből, és odament, elhengerítette a követ a sír szájáról, és ráült arra. ");
INSERT INTO hun_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Tekintete pedig olyan volt, mint a villámlás, és a ruhája fehér, mint a hó. ");
INSERT INTO hun_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Az őrök pedig a tőle való féltükben megrettentek, és olyanokká lettek, mint a holtak. ");
INSERT INTO hun_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Az angyal pedig megszólalt, és ezt mondta az asszonyoknak: „Ti ne féljetek; mert tudom, hogy a megfeszített Jézust keresitek. ");
INSERT INTO hun_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Nincsen itt, mert feltámadott, amint megmondta. Gyertek, lássátok a helyet, ahol feküdt az Úr. ");
INSERT INTO hun_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","És menjetek gyorsan, mondjátok meg tanítványainak, hogy feltámadott a halálból, és íme, előttetek megy Galileába: ott meglátjátok őt. Íme, megmondtam nektek.“ ");
INSERT INTO hun_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","És gyorsan eltávoztak a sírtól, félelemmel és nagy örömmel, futottak, hogy megmondják tanítványainak. ");
INSERT INTO hun_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Amikor pedig mentek, hogy megmondják tanítványainak, íme, szembejött velük Jézus, s ezt mondta: „Legyetek üdvözölve!“ Azok pedig odamentek hozzá, megragadták lábait, és leborultak előtte. ");
INSERT INTO hun_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Akkor ezt mondta nekik Jézus: „Ne féljetek, menjetek el, mondjátok meg az én atyámfiainak, hogy menjenek Galileába, és ott meglátnak engem.“ ");
INSERT INTO hun_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Mialatt ők elmentek, íme, az őrségből bementek néhányan a városba, jelentettek a főpapoknak mindent, ami történt. ");
INSERT INTO hun_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","És összegyülekeztek a vénekkel együtt, tanácsot tartottak, és sok pénzt adtak a vitézeknek, ");
INSERT INTO hun_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","és ezt mondták: „Mondjátok, hogy az ő tanítványai odajöttek éjjel, és ellopták őt, amikor mi aludtunk. ");
INSERT INTO hun_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","És ha ez a helytartó fülébe jut, mi elhitetjük vele, és kimentünk titeket a bajból.“ ");
INSERT INTO hun_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Azok pedig fölvették a pénzt, úgy cselekedtek, amint megtanították őket. És elterjedt ez a hír a zsidók között mind a mai napig. ");
INSERT INTO hun_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","A tizenegy tanítvány pedig elment Galileába a hegyre, ahová Jézus rendelte őket. ");
INSERT INTO hun_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Amikor meglátták őt, leborultak előtte, pedig némelyek kételkedtek. ");
INSERT INTO hun_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","És akkor odament hozzájuk Jézus, és így szólt: „Nékem adatott minden hatalom mennyen és földön. ");
INSERT INTO hun_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Menjetek el azért, tegyetek tanítványokká minden népet, megkeresztelvén őket az Atyának, a Fiúnak és a Szentléleknek nevében, ");
INSERT INTO hun_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","tanítván őket, hogy megtartsák mindazt, amit én parancsoltam nektek; és íme, én veletek vagyok minden napon a világ végezetéig. Ámen!“");
INSERT INTO hun_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Jézus Krisztus, az Isten Fia evangéliumának kezdete, ");
INSERT INTO hun_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","amint meg van írva a prófétáknál: „Íme, elküldöm az én követemet a te orcád előtt, aki elkészíti az utadat előtted; ");
INSERT INTO hun_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","kiáltó szava szól a pusztában: Készítsétek az Úrnak útját, egyengessétek ösvényeit!“ ");
INSERT INTO hun_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","János pedig előállt, és keresztelt a pusztában, prédikálva a megtérés keresztségét a bűnöknek bocsánatára. ");
INSERT INTO hun_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","És kiment hozzá Júdea egész tartománya és a jeruzsálembeliek is, és bűneikről vallást téve megkeresztelkedtek mindnyájan a Jordán vizében. ");
INSERT INTO hun_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","János pedig teveszőr ruhát és dereka körül bőrövet viselt, és sáskát és erdei mézet evett, ");
INSERT INTO hun_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","és ezt prédikálta: „Utánam jön, aki erősebb nálam, akinek nem vagyok méltó, hogy lehajolva sarujának szíját megoldjam. ");
INSERT INTO hun_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Én vízzel kereszteltelek meg titeket, de ő Szentlélekkel keresztel meg titeket.“ ");
INSERT INTO hun_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Történt pedig azokban a napokban, hogy eljött Jézus a galileai Názáretből, és megkeresztelte őt János a Jordánban. ");
INSERT INTO hun_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","És amikor feljött a vízből, látta az eget megnyílni, és a Lelket, mint egy galambot őreá leszállani; ");
INSERT INTO hun_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","és szózat szólt az égből: „Te vagy az én szeretett Fiam, akiben én gyönyörködöm.“ ");
INSERT INTO hun_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","A Lélek pedig azonnal elragadta őt a pusztába. ");
INSERT INTO hun_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","És negyven napig volt a pusztában, miközben kísértette a Sátán. Vadállatokkal volt együtt; és az angyalok szolgáltak neki. ");
INSERT INTO hun_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Miután pedig Jánost tömlöcbe vetették, elment Jézus Galileába, és prédikálta az Isten országának evangéliumát, ezt mondván: ");
INSERT INTO hun_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","„Betelt az idő, és elközelített az Istennek országa: térjetek meg, és higgyetek az evangéliumban.“ ");
INSERT INTO hun_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Amikor pedig a Galileai-tenger mellett járt, látta Simont és az ő testvérét Andrást, amint a tengerbe hálót vetettek, mert halászok voltak; ");
INSERT INTO hun_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","és ezt mondta nekik Jézus: „Kövessetek engem, és én azt teszem, hogy embereket halásszatok.“ ");
INSERT INTO hun_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Erre azonnal elhagyva a hálóikat, követték őt. ");
INSERT INTO hun_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","És onnan egy kevéssé előbbre menve, látta Jakabot, a Zebedeus fiát és annak testvérét, Jánost, amint a hajóban azok is a hálókat kötözgették; ");
INSERT INTO hun_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","és azonnal elhívta őket. Ők pedig atyjukat, Zebedeust a napszámosokkal a hajóban hagyva, elmentek őutána. ");
INSERT INTO hun_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ezután bementek Kapernaumba. És mindjárt szombaton bement a zsinagógába, és tanított. ");
INSERT INTO hun_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Elálmélkodtak a tanításán, mert úgy tanította őket, mint akinek hatalma van, és nem úgy, mint az írástudók. ");
INSERT INTO hun_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Azok zsinagógájában pedig volt egy ember, akiben tisztátalan lélek volt, és így kiáltott fel: ");
INSERT INTO hun_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","„Ah! Mi dolgunk van nekünk veled, Názáreti Jézus? Azért jöttél-e, hogy elveszíts minket? Tudom, hogy ki vagy te: az Istennek Szentje.“ ");
INSERT INTO hun_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jézus megdorgálta őt, és ezt mondta neki: „Némulj meg, és menj ki belőle!“ ");
INSERT INTO hun_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","A tisztátalan lélek megszaggatta őt, és hangosan kiáltott, és kiment belőle. ");
INSERT INTO hun_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Mindnyájan annyira elálmélkodtak, hogy egymás között ezt kérdezgették: „Mi ez? Micsoda új tudomány ez, hogy hatalommal parancsol a tisztátalan lelkeknek is, és azok engedelmeskednek neki?“ ");
INSERT INTO hun_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","És azonnal az ő híre elterjedt Galilea egész környékén. ");
INSERT INTO hun_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ezután azonnal kimentek a zsinagógából, és Simon és András házához mentek Jakabbal és Jánossal együtt. ");
INSERT INTO hun_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simon anyósa pedig lázasan feküdt, és azonnal szóltak Jézusnak felőle. ");
INSERT INTO hun_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","És ő odamenve, megfogta a kezét, és fölemelte, úgyhogy a láz azonnal elhagyta őt, és szolgált nekik. ");
INSERT INTO hun_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Estefelé pedig, amikor leszállt a nap, mind őhozzá vitték a betegeket és az ördöngösöket; ");
INSERT INTO hun_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","és az egész város összegyűlt az ajtó előtt. ");
INSERT INTO hun_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","És meggyógyított sokakat, akik különféle betegségekben sínylődtek; sok ördögöt kiűzött, és nem hagyta szólni az ördögöket, mivelhogy őt ismerték. ");
INSERT INTO hun_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Kora reggel pedig, még szürkületkor, fölkelt, kiment, és elment egy puszta helyre, és ott imádkozott. ");
INSERT INTO hun_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simon pedig és a vele lévők utána siettek; ");
INSERT INTO hun_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","és amikor megtalálták őt, ezt mondták neki: „Mindenki téged keres.“ ");
INSERT INTO hun_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ő pedig ezt mondta nekik: „Menjünk a közeli városokba, hogy ott is prédikáljak, mert azért jöttem.“ ");
INSERT INTO hun_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","És prédikált a zsinagógákban, egész Galileában, és ördögöket űzött ki. ");
INSERT INTO hun_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","És jött hozzá egy bélpoklos, kérve és leborulva előtte, ezt mondta neki: „Ha akarod, megtisztíthatsz engem.“ ");
INSERT INTO hun_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jézus pedig könyörületességre indulva, kezét kinyújtva megérintette őt, és mondta néki: „Akarom, tisztulj meg.“ ");
INSERT INTO hun_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","És amint ezt mondta, azonnal eltávozott tőle a poklosság, és megtisztult. ");
INSERT INTO hun_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","És erősen megfenyegetve, azonnal elküldte őt, ");
INSERT INTO hun_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","és mondta néki: „Vigyázz, hogy senkinek semmit ne szólj, hanem eredj el, mutasd meg magadat a papnak, és vidd fel a te tisztulásodért, amit Mózes parancsolt, bizonyságul nékik!“ ");
INSERT INTO hun_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Az pedig kiment, és elkezdte mindenfelé beszélni, és terjeszteni az esetet, annyira, hogy nyilvánosan immár be sem mehetett Jézus a városba, hanem kinn a puszta helyeken volt, és oda mentek hozzá mindenfelől. ");
INSERT INTO hun_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Napok múlva pedig ismét bement Kapernaumba, és elterjedt a híre, hogy otthon van. ");
INSERT INTO hun_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Erre olyan sokan gyülekeztek össze, hogy még az ajtó előtt sem fértek el; ő pedig hirdette nekik az igét. ");
INSERT INTO hun_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","És odajöttek hozzá egy gutaütöttet hozva, akit négyen vittek. ");
INSERT INTO hun_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Mivel a sokaság miatt nem férkőzhettek hozzá, megbontották annak a háznak fedelét, ahol ő volt, és rést törve, leeresztették az ágyat, amelyben a gutaütött feküdt. ");
INSERT INTO hun_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jézus pedig azoknak hitét látva, ezt mondta a gutaütöttnek: „Fiam, megbocsáttattak néked a te bűneid.“ ");
INSERT INTO hun_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Néhányan az írástudók közül ott ültek, és szívükben így okoskodtak: ");
INSERT INTO hun_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","„Hogyan lehet, hogy ez ilyen káromlásokat szól? Ki bocsáthatja meg a bűnöket, ha nem egyedül az Isten?“ ");
INSERT INTO hun_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","És Jézus azonnal észrevette lelkével, hogy azok magukban így okoskodnak, és mondta nékik: „Miért gondoljátok ezeket a ti szívetekben? ");
INSERT INTO hun_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Mi könnyebb, azt mondanom a gutaütöttnek: Megbocsáttattak néked a te bűneid, vagy ezt mondanom: Kelj fel, vedd fel a nyoszolyádat, és járj? ");
INSERT INTO hun_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Hogy pedig megtudjátok, hogy az Emberfiának van hatalma e földön a bűnöket megbocsátani – ezt mondta a gutaütöttnek: ");
INSERT INTO hun_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Mondom néked, kelj föl, vedd fel a nyoszolyádat, és eredj haza.“ ");
INSERT INTO hun_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Az pedig azonnal fölkelt és felvéve nyoszolyáját, kiment mindenkinek szeme láttára; úgyhogy mindenki elálmélkodott, és dicsőítette az Istent, ezt mondván: „Soha sem láttunk ilyet!“ ");
INSERT INTO hun_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","És ismét kiment a tenger mellé, és az egész sokaság odament hozzá, és ő tanította őket. ");
INSERT INTO hun_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","És amikor továbbment, meglátta Lévit, az Alfeus fiát, aki a vámszedőhelyen ült, és mondta neki: „Kövess engem.“ És ő felkelt, és követte őt. ");
INSERT INTO hun_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","És történt, hogy amikor Lévi házában asztalhoz ült, a vámszedők és bűnösök is sokan odaültek Jézussal és az ő tanítványaival, mivel sokan voltak, és követték őt. ");
INSERT INTO hun_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","És amikor látták az írástudók és a farizeusok, hogy együtt eszik a vámszedőkkel és bűnösökkel, mondták a tanítványainak, hogy a vámszedőkkel és a bűnösökkel eszik és iszik. ");
INSERT INTO hun_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","És amikor ezt hallotta Jézus, ezt mondta nékik: „Nem az egészségeseknek van szükségük orvosra, hanem a betegeknek; nem azért jöttem, hogy igazakat, hanem hogy bűnösöket hívjak megtérésre.“ ");
INSERT INTO hun_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","János és a farizeusok tanítványai pedig böjtöltek. Odamentek Jézushoz, és ezt mondták neki: „Mi az oka annak, hogy Jánosnak és a farizeusoknak tanítványai böjtölnek, a te tanítványaid pedig nem böjtölnek?“ ");
INSERT INTO hun_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jézus pedig ezt mondta nekik: „Böjtölhet-e a vőlegény násznépe, amíg velük van a vőlegény? Ameddig a vőlegény velük van, nem böjtölhetnek. ");
INSERT INTO hun_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","De jönnek majd napok, amikor elvétetik tőlük a vőlegény, és akkor böjtölni fognak azokon a napokon. ");
INSERT INTO hun_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Senki sem varr új posztóból foltot régi ruhára, máskülönben ami azt kitoldaná, még kiszakít belőle, az új a régiből, és még nagyobb szakadás lesz. ");
INSERT INTO hun_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","És senki sem tölt új bort régi tömlőkbe, különben az új bor a tömlőket szétszakítja, a bor is kiömlik, a tömlők is elpusztulnak; hanem az új bort új tömlőkbe kell tölteni.“ ");
INSERT INTO hun_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","És történt, hogy Jézus szombatnapon a vetések közt ment át, és az ő tanítványai mentükben a kalászokat kezdték tépni. ");
INSERT INTO hun_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ekkor a farizeusok ezt mondták neki: „Íme, miért művelik azt szombatnapon, amit nem szabad?“ ");
INSERT INTO hun_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ő pedig ezt mondta nekik: „Soha sem olvastátok, mit művelt Dávid, amikor szükséget szenvedett, és megéhezett társaival együtt? ");
INSERT INTO hun_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Hogyan ment be az Isten házába Abjátár főpap idején, és ette meg a szent kenyereket, amelyeket nem szabad megenni csak a papoknak; és adott a társainak is?“ ");
INSERT INTO hun_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","És mondta nekik: „A szombat lett az emberért, nem az ember a szombatért. ");
INSERT INTO hun_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Tehát az Emberfia a szombatnak is ura.“ ");
INSERT INTO hun_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","És ismét bement a zsinagógába. Volt ott egy sorvadt kezű ember; ");
INSERT INTO hun_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","és lesték őt, hogy meggyógyítja-e szombatnapon, hogy megvádolhassák. ");
INSERT INTO hun_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Akkor ezt mondta a megszáradt kezű embernek: „Állj elő középre.“ ");
INSERT INTO hun_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Azoknak pedig ezt mondta: „Szabad-e szombatnapon jót vagy rosszat tenni, lelket menteni vagy kioltani?“ De azok hallgattak. ");
INSERT INTO hun_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ő pedig haragosan nézte őket, bánkódva szívük keménysége miatt; majd ezt mondta az embernek: „Nyújtsd ki a kezedet.“ Erre kinyújtotta, és meggyógyult a keze, és ép lett, mint a másik. ");
INSERT INTO hun_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Akkor a farizeusok kimenve, a Heródes-pártiakkal mindjárt tanácsot tartottak ellene, hogy elveszítsék őt. ");
INSERT INTO hun_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jézus pedig elment tanítványaival a tenger mellé, ahová nagy sokaság követte őt Galileából és Júdeából ");
INSERT INTO hun_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jeruzsálemből és Idumeából és a Jordánon túlról. A Tírusz és a Szidón környékiek is, amikor hallották, hogy miket tett, nagy sokasággal ment hozzá. ");
INSERT INTO hun_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Jézus pedig mondta tanítványainak, hogy egy kis hajót tartsanak számára készen a sokaság miatt, hogy ne szorongassák őt. ");
INSERT INTO hun_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Mert sokakat meggyógyított, úgyhogy akiknek valami bajuk volt, reá rohantak, hogy megérinthessék őt. ");
INSERT INTO hun_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","A tisztátalan lelkek is, amikor meglátták őt, leborultak előtte, és így kiáltottak: „Te vagy az Istennek a Fia.“ ");
INSERT INTO hun_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ő pedig erősen megfenyegette őket, nehogy felfedjék kilétét. ");
INSERT INTO hun_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Azután felment a hegyre, és magához szólította, akiket akart; és azok odamentek hozzá. ");
INSERT INTO hun_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","És kiválasztott tizenkettőt, hogy vele legyenek, és hogy kiküldje őket prédikálni, ");
INSERT INTO hun_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","és hatalmuk legyen a betegeket gyógyítani és az ördögöket kiűzni: ");
INSERT INTO hun_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Simont, akinek a Péter nevet adta; ");
INSERT INTO hun_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","és Jakabot, a Zebedeus fiát és Jánost, a Jakab testvérét, és a Boanerges nevet adta nekik, amely azt jelenti: mennydörgés fiai; ");
INSERT INTO hun_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","továbbá Andrást és Fülöpöt, Bertalant és Mátét, Tamást és Jakabot, az Alfeus fiát, Taddeust és a kananeai Simont ");
INSERT INTO hun_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","és Iskáriótes Júdást, aki el is árulta őt. ");
INSERT INTO hun_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Azután hazatértek. És ismét egybegyűlt a sokaság, annyira, hogy még enni sem tudtak emiatt. ");
INSERT INTO hun_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Amint az övéi ezt meghallották, eljöttek, hogy megfogják, mert azt mondták, hogy magán kívül van. ");
INSERT INTO hun_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Az írástudók pedig, akik Jeruzsálemből jöttek le, azt mondták, hogy Belzebub van vele, és az ördögök fejedelme által űzi ki az ördögöket. ");
INSERT INTO hun_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ő pedig magához hívta őket, és példázatokban mondta nekik: „Sátán hogyan tud Sátánt kiűzni? ");
INSERT INTO hun_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","És ha egy ország önmagával meghasonlik, nem maradhat meg az az ország. ");
INSERT INTO hun_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","És ha egy ház önmagával meghasonlik, nem maradhat meg az a ház. ");
INSERT INTO hun_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","És ha a Sátán önmaga ellen támadt, és meghasonlott, nem maradhat meg, hanem vége van. ");
INSERT INTO hun_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Nem rabolhatja el senki az erősnek kincseit, bemenve annak házába, ha csak előbb az erőset meg nem kötözi, és azután rabolja ki annak házát. ");
INSERT INTO hun_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Bizony mondom néktek, hogy minden bűn megbocsáttatik az emberek fiainak, még a káromlások is mind, amelyekkel káromlanak: ");
INSERT INTO hun_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","De aki a Szentlélek ellen szól káromlást, nem nyer bocsánatot soha, hanem örök kárhozatra méltó.“ ");
INSERT INTO hun_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ugyanis ezt mondták: „Tisztátalan lélek van benne.“ ");
INSERT INTO hun_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ekkor megérkeztek testvérei és az ő anyja, és kívül megállva, beküldtek hozzá, és hívatták őt. ");
INSERT INTO hun_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Körülötte pedig sokaság ült, és mondták neki: „Íme, a te anyád és a te testvéreid odakint keresnek téged.“ ");
INSERT INTO hun_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ő pedig ezt felelte nekik: „Ki az én anyám, vagy kik az én testvéreim?“ ");
INSERT INTO hun_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Azután végignézve köröskörül a körülötte ülőkön, ezt mondta: „Íme, az én anyám és az én testvéreim. ");
INSERT INTO hun_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Mert aki az Isten akaratát cselekszi, az az én fivérem, nővérem és az én anyám.“ ");
INSERT INTO hun_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ismét tanítani kezdett a tenger mellett. És nagy sokaság gyűlt őhozzá, úgyhogy ő a hajóba lépve, a tengeren tartózkodott; az egész sokaság pedig a tenger mellett a földön ült. ");
INSERT INTO hun_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Sokat tanította őket példázatokban, és ezt mondta nékik tanításában: ");
INSERT INTO hun_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","„Halljátok: Íme, a magvető kiment vetni. ");
INSERT INTO hun_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","És történt vetés közben, hogy némely mag az út mellé esett, és eljöttek az égi madarak, és megették azt. ");
INSERT INTO hun_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Némely pedig a köves helyre esett, ahol nem sok földje volt, és hamar kikelt, mivel nem volt mélyen a földben. ");
INSERT INTO hun_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Mikor pedig fölkelt a nap, megégett, és mivel nem volt gyökere, elszáradt. ");
INSERT INTO hun_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Némely pedig a tövisek közé esett, és a tövisek megnőttek, megfojtották azt, és így nem adott gyümölcsöt. ");
INSERT INTO hun_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Némely pedig a jó földbe esett; és növekedő és bővölködő gyümölcsöt adott, és némely harmincannyit, némely hatvanannyit, némely pedig százannyit hozott.“ ");
INSERT INTO hun_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Majd ezt mondta nekik: „Akinek van füle a hallásra, hallja.“ ");
INSERT INTO hun_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Mikor pedig egyedül volt, megkérdezték őt a körülötte lévők a tizenkettővel együtt a példázat felől. ");
INSERT INTO hun_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ő pedig ezt mondta nekik: „Nektek megadatott, hogy az Isten országának titkát tudjátok, de a kívül levőknek minden példázatokban adatik; ");
INSERT INTO hun_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","hogy »nézvén nézzenek, és ne lássanak; és hallván halljanak, és ne értsenek, hogy soha meg ne térjenek, és bűneik meg ne bocsáttassanak.«“ ");
INSERT INTO hun_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","És mondta nekik: „Nem értitek ezt a példázatot? Akkor hogyan értitek meg majd a többi példázatot? ");
INSERT INTO hun_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","A magvető az igét hinti. ");
INSERT INTO hun_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Az útfélen valók pedig azok, akiknek hintik az igét, de mihelyt hallják, azonnal eljön a Sátán, és elragadja a szívükbe vetett igét. ");
INSERT INTO hun_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","És hasonlóképen a köves helyre vetettek azok, akik mihelyt hallják az igét, mindjárt örömmel fogadják, ");
INSERT INTO hun_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","de nincsen bennük gyökere, hanem ideig valók; azután ha nyomorúságot vagy háborúságot kell szenvedniük az ige miatt, azonnal megbotránkoznak. ");
INSERT INTO hun_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","A tövisek közé vetettek pedig azok, akik az igét hallják, ");
INSERT INTO hun_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","de a világi gondok, a gazdagság csalárdsága és egyéb dolgok megkívánása közbejönnek, elfojtják az igét, és gyümölcstelen lesz. ");
INSERT INTO hun_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","A jó földbe vetettek pedig azok, akik hallják az igét, befogadják, és gyümölcsöt teremnek, némely harmincannyit, némely hatvanannyit, némely százannyit.“ ");
INSERT INTO hun_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ezután ezt mondta nékik: „Vajon azért veszik-e elő a gyertyát, hogy véka alá tegyék, vagy az ágy alá? Nem azért, hogy a gyertyatartóba tegyék? ");
INSERT INTO hun_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Mert nincs semmi rejtett dolog, ami ki ne derülne, és semmi titok, ami nyilvánosságra ne kerülne. ");
INSERT INTO hun_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ha valakinek van füle a hallásra, hallja.“ ");
INSERT INTO hun_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ezt is mondta nekik: „Megjegyezzétek, amit hallotok: Amilyen mértékkel mértek, olyannal mérnek nektek, sőt ráadást is adnak, akik halljátok. ");
INSERT INTO hun_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Mert akinek van, annak adatik, és akinek nincs, attól az is elvétetik, amije van.“ ");
INSERT INTO hun_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","És mondta Jézus: „Úgy van az Isten országa, mint amikor az ember beveti a magot a földbe, ");
INSERT INTO hun_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","azután alszik és fölkel, éjjel és nappal: a mag pedig kihajt és felnő, ő maga sem tudja, miképpen. ");
INSERT INTO hun_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Mert magától terem a föld, először füvet, azután kalászt, azután teljes búzát a kalászban. ");
INSERT INTO hun_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Mihelyt pedig a gabona arra való, azonnal sarlót ereszt reá, mert az aratás elérkezett.“ ");
INSERT INTO hun_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Majd ezt mondta: „Mihez hasonlítsuk az Isten országát? Vagy milyen példázatba foglaljuk azt? ");
INSERT INTO hun_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","A mustármaghoz, amely amikor a földbe elvetik, minden földi magnál kisebb, ");
INSERT INTO hun_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","és amikor elvetették, felnő, és minden veteménynél nagyobb lesz, és nagy ágakat hajt, úgyhogy árnyéka alatt fészket rakhatnak az égi madarak.“ ");
INSERT INTO hun_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","És sok ilyen példázatban hirdette nékik az igét, úgy, amint megérthették. ");
INSERT INTO hun_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Példázat nélkül pedig nem szólt nekik; maguk közt azonban a tanítványoknak mindent megmagyarázott. ");
INSERT INTO hun_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Azután ezt mondta nékik ugyanazon a napon, amint este lett: „Menjünk át a túlsó partra.“ ");
INSERT INTO hun_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Elbocsátották tehát a sokaságot, elvitték őt, úgy, amint éppen a hajóban volt; de más hajók is voltak vele. ");
INSERT INTO hun_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Akkor nagy szélvihar támadt, a hullámok pedig becsaptak a hajóba, annyira, hogy már-már megtelt. ");
INSERT INTO hun_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ő pedig a hajó hátulsó részében a vánkoson aludt. Ekkor fölkeltették őt, és ezt mondták néki: „Mester, nem törődsz vele, hogy elveszünk?“ ");
INSERT INTO hun_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","És felkelve megdorgálta a szelet, és mondta a tengernek: „Hallgass, némulj el!“ És elállt a szél, és nagy csendesség lett. ");
INSERT INTO hun_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Akkor ezt mondta nekik: „Miért vagytok ilyen félénkek? Miért nincsen hitetek?“ ");
INSERT INTO hun_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","És nagy félelem fogta el őket, és ezt mondták egymásnak: „Kicsoda hát ez, hogy mind a szél, mind a tenger engedelmeskedik néki?“ ");
INSERT INTO hun_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","És elmentek a tenger túlsó partjára, a gadaraiak földjére. ");
INSERT INTO hun_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","És amint a hajóból kiszállt, azonnal elébe ment egy ember a sírboltokból, akiben tisztátalan lélek volt, ");
INSERT INTO hun_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","akinek lakása a sírboltokban volt, és már láncokkal sem bírta őt senki megkötözni. ");
INSERT INTO hun_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Mert már sokszor megkötözték őt béklyókkal és láncokkal, de ő a láncokat szétszaggatta, és a béklyókat összetörte, és senki sem tudta őt megfékezni. ");
INSERT INTO hun_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Éjjel és nappal mindig a hegyeken és a sírboltokban volt, kiáltozott, és magát kövekkel vagdosta. ");
INSERT INTO hun_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Mikor pedig Jézust távolról meglátta, odafutott, és elébe borult, ");
INSERT INTO hun_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","és fennhangon kiáltva mondta: „Mi közöm nekem hozzád, Jézus, a magasságos Istennek Fia? Az Istenre kényszerítelek, ne kínozz engem.“ ");
INSERT INTO hun_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","(Ugyanis Jézus ezt mondta neki: „Eredj ki, tisztátalan lélek, ebből az emberből.“) ");
INSERT INTO hun_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","És ezt kérdezte tőle: „Mi a neved?“ Az így felelt: „Légió a nevem, mert sokan vagyunk.“ ");
INSERT INTO hun_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","És igen kérte őt, hogy ne küldje el őket arról a vidékről. ");
INSERT INTO hun_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ott a hegynél pedig volt egy nagy disznónyáj, amely legelt. ");
INSERT INTO hun_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","És az ördögök kérték őt mindnyájan, ezt mondva: „Küldj minket a disznókba, hogy azokba menjünk be.“ ");
INSERT INTO hun_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","És Jézus azonnal megengedte nekik. A tisztátalan lelkek pedig kijöttek, bementek a disznókba, és a nyáj a meredekről, mintegy kétezren, a tengerbe rohant, és belefulladt a tengerbe. ");
INSERT INTO hun_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Akik pedig őrizték a disznókat, elfutottak, és hírt vittek a városba és a falvakba. Erre kimentek az emberek, hogy lássák, mi az, ami történt. ");
INSERT INTO hun_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","És odamentek Jézushoz, és látták, hogy az ördöngös, akiben a légió volt, ott ül, fel van öltözködve, és eszénél van, és félelem fogta el őket. ");
INSERT INTO hun_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Akik pedig látták, elbeszélték nekik, hogy mi történt az ördöngössel és a disznókkal. ");
INSERT INTO hun_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","És kezdték kérni őt, hogy távozzék el az ő határukból. ");
INSERT INTO hun_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Mikor pedig a hajóba beszállott, a volt ördöngös kérte őt, hogy vele maradhasson. ");
INSERT INTO hun_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","De Jézus nem engedte meg neki, hanem ezt mondta: „Eredj haza a tieidhez, és vidd hírül nékik, mily nagy dolgot cselekedett veled az Úr, és mint könyörült rajtad.“ ");
INSERT INTO hun_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","El is ment, és hirdetni kezdte a Tízvárosban, mily nagy dolgot cselekedett vele Jézus; és mindnyájan csodálkoztak. ");
INSERT INTO hun_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Amikor Jézus ismét átkelt a hajón a túlsó partra, nagy sokaság gyűlt hozzá; és ő a tenger mellett maradt. ");
INSERT INTO hun_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Íme, eljött a zsinagógai elöljárók egyike, név szerint Jairus, aki meglátva őt, lábai elé borult, ");
INSERT INTO hun_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","és esedezve kérte: „Az én leánykám halálán van, jöjj, tedd reá kezedet, hogy meggyógyuljon és éljen.“ ");
INSERT INTO hun_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","El is ment vele, és nagy sokaság követte őt, és ott tolongott körülötte. ");
INSERT INTO hun_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Egy asszony pedig, aki tizenkét év óta vérfolyásos volt, ");
INSERT INTO hun_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","és sok orvostól sokat szenvedett, és minden vagyonát magára költötte, és semmit sem javult, sőt inkább még rosszabbul lett; ");
INSERT INTO hun_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","amikor Jézus felől hallott, a sokaságban hátulról kerülve, megérintette annak ruháját ");
INSERT INTO hun_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","mert ezt mondta: „Ha csak ruháit érinthetem is meg, meggyógyulok.“ ");
INSERT INTO hun_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","És vérének forrása azonnal kiszáradt, és megérezte testében, hogy kigyógyult bajából. ");
INSERT INTO hun_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jézus pedig azonnal észrevette magán, hogy isteni erő áradott ki belőle, megfordult a sokaságban, és ezt mondta: „Kicsoda érintette meg az én ruháimat?“ ");
INSERT INTO hun_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","És mondták neki az ő tanítványai: „Látod, hogy a sokaság szorít össze téged, és azt kérdezed: Kicsoda érintett meg engem?“ ");
INSERT INTO hun_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","És körülnézett, hogy lássa azt, aki ezt cselekedte. ");
INSERT INTO hun_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Az asszony pedig tudva, hogy mi történt vele, félve és remegve ment oda, és elé borult, és elmondott neki mindent igazán. ");
INSERT INTO hun_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ő pedig ezt mondta neki: „Leányom, a te hited megtartott téged. Eredj el békével, és gyógyulj meg a te bajodból.“ ");
INSERT INTO hun_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Még beszélt Jézus, amikor odajöttek a zsinagóga elöljárójától, ezt mondván: „Leányod meghalt; miért fárasztod tovább a Mestert?“ ");
INSERT INTO hun_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jézus pedig, amint hallotta, a beszédet, amit mondtak, azonnal mondta a zsinagógai elöljárónak: „Ne félj, csak higgy!“ ");
INSERT INTO hun_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","És senkinek sem engedte, hogy vele menjen, csak Péternek, Jakabnak és Jánosnak, a Jakab testvérének. ");
INSERT INTO hun_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","És odament a zsinagógai elöljáró házához, és látta a zűrzavart, a sok siránkozót és jajgatót, ");
INSERT INTO hun_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","és bemenve, ezt mondta nekik: „Miért zavarogtok és sírtok? A gyermek nem halt meg, hanem alszik.“ ");
INSERT INTO hun_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Erre kinevették őt. Ő pedig mindenkit kiküldve, maga mellé vette a gyermeknek atyját, anyját és a vele levőket, és bement oda, ahol a gyermek feküdt. ");
INSERT INTO hun_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Majd megfogva a gyermeknek kezét, ezt mondta neki: „Talitha, kúmi!“ – ami megmagyarázva azt jelenti: „Leányka, néked mondom, kelj föl!“ ");
INSERT INTO hun_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","És a leányka azonnal fölkelt és járt, mert tizenkét esztendős volt. Azok pedig nagy csodálkozással elámultak. ");
INSERT INTO hun_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ő pedig erősen megparancsolta nekik, hogy ezt senki meg ne tudja. És mondta, hogy adjanak enni neki. ");
INSERT INTO hun_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Akkor Jézus elment onnan, és a hazájába ment, és követték őt a tanítványai. ");
INSERT INTO hun_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","És amint eljött a szombat, tanítani kezdett a zsinagógában. Sokan, akik őt hallották, elálmélkodtak, ezt mondván: „Honnan veszi ezeket? És milyen bölcsesség az, ami neki adatott, hogy ilyen csodák is történnek általa? ");
INSERT INTO hun_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Talán nem ez az ácsmester, Máriának fia, Jakabnak, Józsefnek, Júdásnak és Simonnak testvére? És nincsenek-e itt közöttünk az ő nőtestvérei is?“ És megbotránkoztak őbenne. ");
INSERT INTO hun_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jézus pedig ezt mondta nekik: „A prófétának csak a maga hazájában, a rokonai között és a saját házában nincs tisztessége.“ ");
INSERT INTO hun_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Nem is tehetett ott semmi csodát, csak néhány beteget gyógyított meg, rájuk téve kezeit. ");
INSERT INTO hun_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","És csodálkozott azoknak hitetlenségén. Aztán körbejárta a falvakat, és tanított. ");
INSERT INTO hun_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Majd magához szólította a tizenkettőt, és kezdte őket kiküldeni kettesével, és hatalmat adott nekik a tisztátalan lelkeken, ");
INSERT INTO hun_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","és megparancsolta nekik, hogy az útra semmit ne vigyenek egy boton kívül, se táskát, se kenyeret, se pénzt az övükben; ");
INSERT INTO hun_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","hanem kössenek sarut, de két ruhát ne öltsenek magukra. ");
INSERT INTO hun_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","És ezt mondta nekik: „Ahol valamelyik házba bementek, maradjatok ott mindaddig, amíg tovább nem mentek onnan. ");
INSERT INTO hun_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Akik pedig nem fogadnak be titeket, és nem is hallgatnak rátok, onnan kimenve, verjétek le a port is lábaitokról, bizonyságul ellenük. Bizony mondom néktek: Sodomának vagy Gomorának tűrhetőbb lesz a dolga az ítélet napján, mint annak a városnak.“ ");
INSERT INTO hun_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Elmentek tehát, és prédikálták, hogy térjenek meg; ");
INSERT INTO hun_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","és sok ördögöt űztek ki, és olajjal sok beteget megkentek és meggyógyítottak. ");
INSERT INTO hun_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","És meghallotta ezeket Heródes király (mert közismert lett az ő neve), és ezt mondta: „Keresztelő János támadt fel a halálból, és azért működnek benne ezek az erők.“ ");
INSERT INTO hun_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Némelyek azt mondták, hogy Illés ő; mások meg azt mondták, hogy próféta, vagy olyan, mint egy a próféták közül. ");
INSERT INTO hun_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Heródes pedig mikor meghallotta ezeket, ezt mondta: „Akinek én fejét vétettem, az a János ez; ő támadt fel a halálból.“ ");
INSERT INTO hun_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Mert maga Heródes fogatta el és vettette börtönbe Jánost, Heródiás miatt, Fülöpnek, az ő testvérének felesége kedvéért, mivelhogy azt vette feleségül. ");
INSERT INTO hun_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Mert János azt mondta Heródesnek: „Nem szabad neked a testvéred feleségével élned.“ ");
INSERT INTO hun_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Heródiás pedig ólálkodott utána, és meg akarta őt ölni, de nem tehette, ");
INSERT INTO hun_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","mert Heródes félt Jánostól, mert igaz és szent embernek ismerte, és oltalmába vette őt; és ráhallgatva, sok dologban követte, és örömest hallgatta őt. ");
INSERT INTO hun_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","De egy alkalmas nap jöttével, mikor Heródes születése ünnepén nagyjainak, vezéreinek és Galilea előkelő embereinek lakomát adott, ");
INSERT INTO hun_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","ennek a Heródiásnak a leánya bement és táncolt. Megtetszett Heródesnek és a vendégeknek. A király ezt mondta a leánynak: „Kérj tőlem, amit akarsz, és megadom neked.“ ");
INSERT INTO hun_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","És megesküdött neki: „Bármit kérsz tőlem, megadom neked, még ha országom felét is.“ ");
INSERT INTO hun_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ő pedig kiment és megkérdezte anyjától: „Mit kérjek?“ Az pedig ezt mondta: „A Keresztelő János fejét.“ ");
INSERT INTO hun_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","És a királyhoz nagy sietve azonnal bement, és kérte őt: „Akarom, hogy mindjárt add ide nékem Keresztelő János fejét egy tálon.“ ");
INSERT INTO hun_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","A király pedig, noha igen megszomorodott, esküje és a vendégek miatt nem akarta őt elutasítani. ");
INSERT INTO hun_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","És azonnal hóhért küldött a király, és megparancsolta, hogy hozzák el annak fejét. ");
INSERT INTO hun_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Az pedig elment, és fejét vette neki a börtönben, és elhozta a fejét egy tálon, és odaadta a leánynak; a leány pedig az anyjának adta oda. ");
INSERT INTO hun_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","A tanítványai pedig, amikor ezt meghallották, eljöttek, és elvitték a testét, és sírba helyezték. ");
INSERT INTO hun_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Az apostolok visszatértek Jézushoz, és elbeszéltek neki mindent, azt is, amiket cselekedtek, azt is, amiket tanítottak. ");
INSERT INTO hun_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ő pedig mondta nekik: „Gyertek velem, csupán ti magatok, valamilyen puszta helyre, és pihenjetek meg egy kevéssé.“ Mert sokan voltak a járókelők, és még evésre sem volt alkalmas idejük. ");
INSERT INTO hun_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","És elmentek hajón egy puszta helyre, csupán ő maguk. ");
INSERT INTO hun_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","A sokaság pedig meglátta őket, amint mentek, és sokan felismerték őt; és minden városból egybefutottak oda, és megelőzték őket, és odagyülekeztek hozzá. ");
INSERT INTO hun_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","És kimenve Jézus, nagy sokaságot látott, és megszánta őket, mert olyanok voltak, mint a pásztor nélkül való juhok. És kezdte őket sok mindenre tanítani. ");
INSERT INTO hun_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Mikor pedig immár az idő későre járt, hozzámenve a tanítványai, ezt mondták: „Puszta ez a hely, és immár az idő későre jár: ");
INSERT INTO hun_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Bocsásd el őket, hogy elmenve a környező majorokba és falvakba, vegyenek maguknak kenyeret; mert nincs mit enniük.“ ");
INSERT INTO hun_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ő pedig azt felelte nekik: „Adjatok nekik ti enni.“ Mire ők ezt mondták neki: „Elmenjünk és vegyünk kétszáz pénz árú kenyeret, hogy enni adjunk nékik?“ ");
INSERT INTO hun_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ő pedig ezt mondta nekik: „Hány kenyeretek van? Menjetek és nézzétek meg.“ Amikor megtudták, ezt mondták: „Öt, és két halunk.“ ");
INSERT INTO hun_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ekkor megparancsolta nekik, hogy ültessenek le mindenkit csoportonként a zöld pázsitra. ");
INSERT INTO hun_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Letelepedtek tehát szakaszonként, százasával és ötvenesével. ");
INSERT INTO hun_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ő pedig vette az öt kenyeret és a két halat, és az égre tekintve, hálákat adott, és megszegte a kenyereket, és adta tanítványainak, hogy tegyék azok elé; és a két halat is elosztotta mindnyájuk között. ");
INSERT INTO hun_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Mindnyájan ettek, és jóllaktak; ");
INSERT INTO hun_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","és felszedték a kenyérből és a halakból a maradékot, tizenkét tele kosárral. ");
INSERT INTO hun_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Akik pedig a kenyerekből ettek, mintegy ötezren voltak férfiak. ");
INSERT INTO hun_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ekkor azonnal arra kényszerítette tanítványait, hogy szálljanak hajóba, és menjenek át előre a túlsó partra Betsaida felé, amíg ő a sokaságot elbocsátja. ");
INSERT INTO hun_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Miután pedig elbocsátotta őket, fölment a hegyre imádkozni. ");
INSERT INTO hun_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Mikor beesteledett, a hajó a tenger közepén volt, ő pedig egymaga a szárazon. ");
INSERT INTO hun_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","És látta őket, amint az evezéssel vesződnek, mert a szél velük szembe fújt; és az éj negyedik szakában hozzájuk ment a tengeren járva, és el akart haladni mellettük. ");
INSERT INTO hun_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Azok pedig látva őt a tengeren járni, kísértetnek vélték, és felkiáltottak; ");
INSERT INTO hun_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","mert mindnyájan látták őt, és megrémültek. De ő azonnal megszólította őket, és mondta nekik: „Bízzatok, én vagyok, ne féljetek.“ ");
INSERT INTO hun_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ekkor beszállt hozzájuk a hajóba, és elállt a szél, ők pedig szerfölött álmélkodtak és csodálkoztak magukban, ");
INSERT INTO hun_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","mert nem okultak a kenyerekből, mivel a szívük meg volt keményedve. ");
INSERT INTO hun_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ezután átkelve a túlsó partra, eljutottak Genezáret földjére, és kikötöttek. ");
INSERT INTO hun_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","De mihelyt kiszálltak a hajóból, azonnal megismerték őt, ");
INSERT INTO hun_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","és befutva az egész környéket, kezdték a betegeket az ágyakon ide-oda hordozni, amerre hallották, hogy ő ott van. ");
INSERT INTO hun_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","És ahová csak bement, falvakba, városokba vagy majorokba, a betegeket letették a piacokon, és kérték őt, hogy legalább a ruhája szegélyét érinthessék, és valahányan csak megérintették, meggyógyultak. ");
INSERT INTO hun_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","És köréje gyűltek a farizeusok, és némelyek az írástudók közül, akik Jeruzsálemből jöttek. ");
INSERT INTO hun_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","És látva, hogy az ő tanítványai közül némelyek közönséges, azaz mosdatlan kézzel esznek kenyeret, panaszkodtak miatta. ");
INSERT INTO hun_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Mert a farizeusok és a zsidók mind, a régiek rendelését követve, nem esznek, míg kezüket erősen meg nem megmossák; ");
INSERT INTO hun_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","és piacról jőve sem esznek, ha meg nem mosakodnak; és sok más egyéb is van, aminek megtartását átvették, mint poharaknak, korsóknak, rézedényeknek és nyoszolyáknak megmosását. ");
INSERT INTO hun_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Azután megkérdezték őt a farizeusok és az írástudók: „Mi az oka, hogy a te tanítványaid nem járnak a régiek rendelése szerint, hanem mosdatlan kézzel esznek kenyeret?“ ");
INSERT INTO hun_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ő pedig ezt felelte nekik: „Találóan jövendölt felőletek, képmutatók felől Ézsaiás próféta, amint meg van írva: »Ez a nép ajkaival tisztel engem, a szívük pedig távol van tőlem. ");
INSERT INTO hun_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Pedig hiába tisztelnek engem, ha olyan tudományokat tanítanak, amelyek embereknek parancsolatai.« ");
INSERT INTO hun_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Mert az Isten parancsolatát elhagyva, az emberek rendelését tartjátok meg, korsóknak és poharaknak mosását; és sok egyéb efféléket is cselekesztek.“ ");
INSERT INTO hun_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","És ezt mondta nekik: „Az Isten parancsolatát szépen félreteszitek azért, hogy a magatok rendelését tartsátok meg. ");
INSERT INTO hun_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mert Mózes azt mondta: »Tiszteld atyádat és anyádat«, és »aki atyját vagy anyját szidalmazza, halállal haljon meg.« ");
INSERT INTO hun_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ti pedig azt mondjátok: Ha valaki ezt mondja atyjának vagy anyjának: Korbán, vagyis templomi ajándék az, amivel megsegíthetnélek, ");
INSERT INTO hun_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","akkor már nem engeditek, hogy az atyjával vagy anyjával valami jót tegyen, ");
INSERT INTO hun_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","és így eltörlitek az Isten beszédét a ti rendelésetekkel, amelyet rendeltetek; és sok effélét is cselekesztek.“ ");
INSERT INTO hun_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","És magához szólítva az egész sokaságot, ezt mondta nekik: „Hallgassatok reám mindnyájan, és értsétek meg: ");
INSERT INTO hun_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Nincs semmi ami az emberen kívül van, és belébemenve, megfertőzhetné őt, hanem amik belőle kijönnek, azok fertőzik meg az embert. ");
INSERT INTO hun_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ha valakinek van füle a hallásra, hallja.“ ");
INSERT INTO hun_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","És mikor a sokaság közül bement a házba, megkérdezték őt tanítványai a példázat felől. ");
INSERT INTO hun_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","És ezt mondta nekik: „Ti is ennyire tudatlanok vagytok? Nem értitek, hogy ami kívülről megy az emberbe, semmi sem fertőzheti meg őt? ");
INSERT INTO hun_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Mert nem a szívébe megy be, hanem a gyomrába, és az árnyékszékbe kerül.“ Így nyilvánított Jézus tisztának minden eledelt. ");
INSERT INTO hun_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","És ezt mondta: „Amik belőle kijönnek, azok fertőzik meg az embert. ");
INSERT INTO hun_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Mert onnan belülről, az emberek szívéből származnak a gonosz gondolatok, házasságtörések, paráznaságok, gyilkosságok, ");
INSERT INTO hun_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","lopások, telhetetlenségek, gonoszságok, álnokság, szemérmetlenség, gonosz szem, káromlás, kevélység, bolondság: ");
INSERT INTO hun_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Mindezek a gonoszságok belülről jönnek ki, és megfertőzik az embert.“ ");
INSERT INTO hun_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","És onnan fölkelve, elment Tírusz és Szidón határaiba; és bement egy házba, mert nem akarta, hogy valaki észrevegye. De nem titkolhatta el magát. ");
INSERT INTO hun_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Mert egy asszony, akinek leányában tisztátalan lélek volt, hallott felőle, eljött, és lábaihoz borult. ");
INSERT INTO hun_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ez az asszony pedig pogány volt, sziroföníciai származású, és kérte őt, hogy űzze ki a leányából az ördögöt. ");
INSERT INTO hun_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jézus pedig ezt mondta neki: „Engedd, hogy először a gyermekek lakjanak jól. Mert nem jó a gyermekek kenyerét elvenni és az ebeknek vetni.“ ");
INSERT INTO hun_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Az pedig így felelt neki: „Úgy van, Uram, de hiszen az ebek is esznek az asztal alatt a gyermekek morzsáiból.“ ");
INSERT INTO hun_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Erre ezt mondta neki: „Ezért a beszédért eredj el, az ördög kiment a leányodból.“ ");
INSERT INTO hun_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","És hazamenve, úgy találta, hogy az ördög már kiment belőle, a leány pedig az ágyon feküdt. ");
INSERT INTO hun_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Aztán ismét kimenve Tírusz és Szidón határaiból, a Galileai-tengerhez ment, a Tízváros határain át. ");
INSERT INTO hun_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","És hoztak hozzá egy nehezen beszélő siketet, és kérték őt, hogy tegye reá kezét. ");
INSERT INTO hun_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ő pedig, mikor kivitte azt egymagában a sokaságból, ujját fülébe dugta, és ujjára köpve megérintette a nyelvét, ");
INSERT INTO hun_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","föltekintett az égre, fohászkodott, és ezt mondta neki: „Effata“, azaz: „nyílj meg!“ ");
INSERT INTO hun_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","És azonnal megnyíltak fülei, és nyelvének kötele is megoldódott, és helyesen beszélt. ");
INSERT INTO hun_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","És megparancsolta nekik, hogy senkinek se mondják el; de mennél inkább tiltotta, annál inkább híresztelték, ");
INSERT INTO hun_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","és szerfelett álmélkodtak, és ezt mondták: „Mindent jól cselekedett; a siketeket is hallókká teszi, a némákat is beszélőkké.“ ");
INSERT INTO hun_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Azokban a napokban, mivel ismét fölötte nagy volt a sokaság, és nem volt mit enniük, magához szólította Jézus a tanítványait, és mondta nekik: ");
INSERT INTO hun_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","„Szánakozom e sokaságon, mert immár harmadik napja, hogy velem vannak, és nincs mit enniük; ");
INSERT INTO hun_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","és ha éhen bocsátom haza őket, kidőlnek az úton, mert némelyek közülük messziről jöttek.“ ");
INSERT INTO hun_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","A tanítványai pedig ezt felelték neki: „Honnan laktathatná jól ezeket valaki kenyérrel itt e pusztában?“ ");
INSERT INTO hun_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","És megkérdezte őket: „Hány kenyeretek van?“ Azok pedig mondták: „Hét.“ ");
INSERT INTO hun_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Akkor megparancsolta a sokaságnak, hogy telepedjenek le a földre. És vette a hét kenyeret, és hálákat adva, megszegte, és adta az ő tanítványainak, hogy tegyék eléjük. És a sokaság elé tették. ");
INSERT INTO hun_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Volt egy kevés haluk is. És hálákat adva azt mondta, hogy tegyék eléjük azokat is. ");
INSERT INTO hun_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ettek azért, és jóllaktak; és fölszedték a maradék darabokat, hét kosárral. ");
INSERT INTO hun_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Akik pedig ettek mintegy négyezren voltak. Ezután elbocsátotta őket. ");
INSERT INTO hun_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","És azonnal hajóba szállt tanítványaival, és elment Dalmanuta vidékére. ");
INSERT INTO hun_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Kijöttek hozzá a farizeusok, és kezdték őt faggatni, mennyei jelt kívánva tőle, hogy kísértsék őt. ");
INSERT INTO hun_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ő pedig lelkében felfohászkodva, ezt mondta: „Miért kíván jelt ez a nemzetség? Bizony mondom nektek: Nem adatik jel ennek a nemzetségnek.“ ");
INSERT INTO hun_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","És otthagyva őket, ismét hajóba szállt, és a túlsó partra ment. Őrizkedjetek a farizeusok kovászától és a Heródes kovászától! ");
INSERT INTO hun_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","De elfelejtettek kenyeret vinni, és egy kenyérnél nem volt velük több a hajóban. ");
INSERT INTO hun_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","És Jézus figyelmeztette őket, mondván: „Vigyázzatok, őrizkedjetek a farizeusok kovászától és a Heródes kovászától!“ ");
INSERT INTO hun_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ekkor egymás között tanakodtak, hogy nincs kenyerünk. ");
INSERT INTO hun_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jézus pedig észrevette ezt, és mondta nekik: „Miért tanakodtok, hogy nincsen kenyeretek? Még most sem látjátok be és nem értitek? Mégis kemény a szívetek? ");
INSERT INTO hun_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Van szemetek, és nem láttok, és van fületek, és nem hallotok? Nem emlékeztek ");
INSERT INTO hun_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","mikor az öt kenyeret megszegtem az ötezernek, hány kosarat hoztatok el darabokkal tele?“ Mondták neki: „Tizenkettőt.“ ");
INSERT INTO hun_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","„Amikor pedig a hetet a négyezernek, hány kosarat hoztatok el darabokkal tele?“ Azok pedig mondták: „Hetet.“ ");
INSERT INTO hun_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","És mondta nekik Jézus: „Hogy nem értitek hát?“ ");
INSERT INTO hun_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Azután Betsaidába ment, és egy vakot vittek hozzá, és kérték őt, hogy érintse meg. ");
INSERT INTO hun_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ő pedig megfogta a vaknak kezét, kivezette őt a falun kívül, és a szemeibe köpve és kezeit reátéve, megkérdezte őt, vajon lát-e valamit. ");
INSERT INTO hun_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Az pedig föltekintve mondta: „Látom az embereket, mint valami járkáló fákat.“ ");
INSERT INTO hun_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Azután kezeit ismét rátette annak szemeire, ő pedig feltekintett vele, és meggyógyult, és messze és világosan látott mindent. ");
INSERT INTO hun_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","És hazaküldte, mondván: „Se a faluba be ne menj, se senkinek el ne mondd a faluban.“ ");
INSERT INTO hun_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","És elment Jézus tanítványaival együtt Cézárea Filippi falvaiba. Útközben megkérdezte tanítványaitól: „Kinek mondanak engem az emberek?“ ");
INSERT INTO hun_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ők pedig így feleltek: „Keresztelő Jánosnak, némelyek Illésnek, ismét némelyek pedig egynek a próféták közül.“ ");
INSERT INTO hun_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ő pedig ezt kérdezte tőlük: „Hát ti kinek mondtok engem?“ Péter így felelt neki: „Te vagy a Krisztus.“ ");
INSERT INTO hun_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","És rájuk parancsolt, hogy senkinek se szóljanak felőle. ");
INSERT INTO hun_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","És tanítani kezdte őket, hogy az Emberfiának sokat kell szenvednie, megvettetnie a vénektől, a főpapoktól és az írástudóktól, és megöletnie, és harmadnapra fel kell támadnia. ");
INSERT INTO hun_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","És ezt nyíltan mondta. Péter pedig magához vonva őt, dorgálni kezdte. ");
INSERT INTO hun_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ő azonban megfordulva tanítványaira tekintett, megfeddte Pétert, és ezt mondta: „Távozz tőlem, Sátán, mert nem az Isten dolgaira, hanem az emberi dolgokra gondolsz.“ ");
INSERT INTO hun_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","A sokaságot pedig az ő tanítványaival együtt magához szólítva, ezt mondta nekik: „Ha valaki énutánam akar jönni, tagadja meg magát, vegye fel az ő keresztjét, és kövessen engem. ");
INSERT INTO hun_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Mert aki meg akarja tartani az ő életét, elveszti azt, aki pedig elveszti az ő életét énérettem és az evangéliumért, az megtalálja azt. ");
INSERT INTO hun_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Mert mit használ az embernek, ha az egész világot megnyeri, lelkében pedig kárt vall? ");
INSERT INTO hun_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Avagy mit adhat az ember váltságul az ő lelkéért? ");
INSERT INTO hun_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Mert aki szégyell engem és az én beszédeimet e parázna és bűnös nemzetség között, az Emberfia is szégyellni fogja azt, mikor eljön az ő Atyja dicsőségében a szent angyalokkal.“ ");
INSERT INTO hun_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Azután mondta nékik: „Bizony mondom néktek, hogy vannak némelyek az itt állók között, a kik nem kóstolnak addig halált, amíg meg nem látják, hogy az Isten országa eljött hatalommal.“ ");
INSERT INTO hun_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","És hat nap múlva magához vette Jézus Pétert, Jakabot és Jánost, és felvitte csupán őket magukban egy magas hegyre. És elváltozott előttük. ");
INSERT INTO hun_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ruhája fényes lett, és olyan fehér, mint a hó, amihez hasonlót a ruhafestő e földön nem fehéríthet. ");
INSERT INTO hun_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","És megjelent nekik Mózes Illéssel együtt, és beszéltek Jézussal. ");
INSERT INTO hun_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Péter pedig megszólalt, és ezt mondta Jézusnak: „Mester, jó nékünk itt lenni, csináljunk azért három hajlékot, neked egyet, Mózesnek is egyet, Illésnek is egyet.“ ");
INSERT INTO hun_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","De nem tudta mit beszél, mivel megrémültek, ");
INSERT INTO hun_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","és felhő támadt, mely beárnyékolta őket, és a felhőből szózat jött: „Ez az én szeretett Fiam, őt hallgassátok.“ ");
INSERT INTO hun_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","És mikor nagyon hirtelen körültekintettek, senkit sem láttak maguk körül, egyedül Jézust. ");
INSERT INTO hun_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Mikor pedig a hegyről leszálltak, megparancsolta nékik, hogy senkinek se beszéljék el, amit láttak, csak amikor az Emberfia a halálból feltámad. ");
INSERT INTO hun_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","És ezt a parancsot megtartották magukban, tanakodva egymás között: mit jelent a halálból feltámadni? ");
INSERT INTO hun_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","És megkérdezték tőle: „Miért mondják az írástudók, hogy előbb Illésnek kell eljönnie?“ ");
INSERT INTO hun_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ő pedig ezt felelte nekik: „Illés ugyan előbb eljön, és helyreállít mindent; de hogyan van az Emberfiáról megírva, hogy sokat kell szenvednie és megvettetnie? ");
INSERT INTO hun_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","De mondom nektek, hogy Illés is eljött, és azt cselekedték vele, amit akartak, amint meg van írva róla.“ ");
INSERT INTO hun_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Amikor a tanítványokhoz odament, nagy sokaságot látott körülöttük, és írástudókat, akik azokkal vitatkoztak. ");
INSERT INTO hun_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Amikor az egész sokaság meglátta őt, azonnal elálmélkodott, és hozzásietve köszöntötte őt. ");
INSERT INTO hun_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ő pedig megkérdezte az írástudókat: „Miről vitatkoztok ezekkel?“ ");
INSERT INTO hun_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","A sokaságból valaki így felelt neki: „Mester, idehoztam hozzád a fiamat, akiben néma lélek van. ");
INSERT INTO hun_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","És amikor csak megragadja, szaggatja őt, ő pedig tajtékzik, fogát csikorgatja, és megmerevedik. Mondtam hát tanítványaidnak, hogy űzzék ki azt, de nem tudták.“ ");
INSERT INTO hun_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ő pedig így felelt neki: „Ó, hitetlen nemzetség, meddig leszek még veletek? Meddig szenvedlek még titeket? Hozzátok őt hozzám.“ ");
INSERT INTO hun_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","És odavitték hozzá, és mihelyt meglátta őt, a lélek azonnal megrázta azt, és leesve a földre, tajtékozott és fetrengett. ");
INSERT INTO hun_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","És megkérdezte az atyját: „Mennyi ideje, hogy ez van rajta?“ Az pedig mondta: „Gyermeksége óta. ");
INSERT INTO hun_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","És gyakran vetette tűzbe is, vízbe is, hogy elveszítse őt, de ha valamit tehetsz, légy segítségül nekünk, megkönyörülvén rajtunk.“ ");
INSERT INTO hun_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jézus pedig ezt mondta neki: „Ha hiheted azt, minden lehetséges a hívőnek.“ ");
INSERT INTO hun_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","A gyermek atyja pedig azonnal kiáltott, és könnyhullatással mondta: „Hiszek, Uram! Légy segítségül az én hitetlenségemnek.“ ");
INSERT INTO hun_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jézus pedig mikor látta, hogy a sokaság még inkább összetódul, megdorgálta a tisztátalan lelket, ezt mondva neki: „Te néma és siket lélek, én parancsolom neked, menj ki belőle, és többé belé ne menj!“ ");
INSERT INTO hun_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","És kiáltás és erős szaggatás között kiment belőle. A fiú pedig olyan lett, mint egy halott, annyira, hogy sokan azt mondták, hogy meghalt. ");
INSERT INTO hun_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Jézus pedig megfogta a kezét, fölemelte, és az fölkelt. ");
INSERT INTO hun_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Mikor pedig bement a házba, tanítványai megkérdezték őt külön: „Mi miért nem űzhettük ki azt?“ ");
INSERT INTO hun_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ő pedig ezt mondta nekik: „Ez a fajta semmivel sem űzhető ki, csupán könyörgéssel és böjtöléssel.“ ");
INSERT INTO hun_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","És onnan kimenve, Galileán mentek át, és nem akarták, hogy valaki megtudja. ");
INSERT INTO hun_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Mert tanította tanítványait, és ezt mondta nekik: „Az Emberfia az emberek kezébe adatik, és megölik őt, de ha megölték, harmadnapra föltámad.“ ");
INSERT INTO hun_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","De ők nem értették ezt a beszédet, és féltek megkérdezni őt. ");
INSERT INTO hun_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","És elment Kapernaumba. És odahaza megkérdezték őket: „Miről vitatkoztatok egymással az úton?“ ");
INSERT INTO hun_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","De ők hallgattak, mert egymás között azon vitatkoztak az úton, hogy ki a nagyobb. ");
INSERT INTO hun_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","És leülve Jézus, odaszólította a tizenkettőt, és mondta nékik: „Ha valaki első akar lenni, legyen mindenki között utolsó, és mindenkinek szolgája.“ ");
INSERT INTO hun_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","És kézenfogva egy gyermeket, közéjük állította, ölébe vette, és azt mondta nekik: ");
INSERT INTO hun_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","„Aki az ilyen gyermekek közül egyet befogad az én nevemben, engem fogad be, és aki engem befogad, nem engem fogad be, hanem azt, aki engem elküldött.“ ");
INSERT INTO hun_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","János pedig így felelt neki: „Mester, láttunk valakit, aki a te neveddel ördögöket űz, aki nem követ minket, és eltiltottuk őt, mivel nem követ minket.“ ");
INSERT INTO hun_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jézus pedig ezt mondta: „Ne tiltsátok el őt, mert senki sincs, aki csodát tesz az én nevemben, és ugyanakkor gonoszul szólhatna felőlem. ");
INSERT INTO hun_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Mert aki nincs ellenünk, mellettünk van. ");
INSERT INTO hun_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Aki inni ad egy pohár vizet az én nevemben, mivel a Krisztuséi vagytok, bizony mondom néktek, el nem veszti a jutalmát. ");
INSERT INTO hun_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","„Aki pedig megbotránkoztat egyet ama kicsinyek közül, akik én bennem hisznek, jobb annak, ha malomkövet kötnek a nyakára, és a tengerbe vetik. ");
INSERT INTO hun_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","És ha megbotránkoztat téged a te kezed, vágd le, mert jobb neked csonkán bemenned az életre, mint két kézzel menned a gyehennára, az olthatatlan tűzre, ");
INSERT INTO hun_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","ahol férgük nem pusztul el, és tüzük nem alszik el. ");
INSERT INTO hun_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","És ha a te lábad botránkoztat meg téged, vágd le azt, mert jobb neked sántán bemenned az életre, mint két lábbal vettetned a gyehennára, az olthatatlan tűzre, ");
INSERT INTO hun_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","ahol férgük nem pusztul el, és tüzük nem alszik el. ");
INSERT INTO hun_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","És ha a te szemed botránkoztat meg téged, vájd ki azt, mert jobb neked félszemmel bemenned az Isten országába, mint két szemmel vettetned a tüzes gyehennára, ");
INSERT INTO hun_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","ahol férgük nem pusztul el, és tüzük nem alszik el. ");
INSERT INTO hun_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","„Mert mindenki tűzzel sózatik meg, és minden áldozat sóval sózatik meg. ");
INSERT INTO hun_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Jó a só, de ha a só ízét veszti, mivel adtok ízt neki? Legyen bennetek só, és legyetek békében egymással.“ ");
INSERT INTO hun_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jézus onnan felkelve Júdea határaiba ment, a Jordánon túlra; és ismét sokaság gyülekezett hozzá; ő pedig szokása szerint ismét tanította őket. ");
INSERT INTO hun_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","A farizeusok hozzámenve megkérdezték tőle, hogy szabad-e férjnek feleségét elbocsátani: ezzel kísértették Jézust. ");
INSERT INTO hun_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ő pedig ezt felelve, mondta nekik: „Mit parancsolt nektek Mózes?“ ");
INSERT INTO hun_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ők pedig ezt mondták: „Mózes megengedte, hogy válólevelet írjunk, és elváljunk.“ ");
INSERT INTO hun_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jézus ezt felelte nékik: „A szívetek keménysége miatt írta nektek ezt a parancsolatot; ");
INSERT INTO hun_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","de a teremtés kezdete óta »férfiúvá és asszonnyá« teremtette az embert az Isten. ");
INSERT INTO hun_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","»Ezért elhagyja az ember az ő atyját és anyját; és ragaszkodik a feleségéhez, ");
INSERT INTO hun_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","és lesznek ketten egy testté«, úgyhogy többé már nem két, hanem egy test. ");
INSERT INTO hun_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Amit tehát az Isten egybeszerkesztett, ember el ne válassza.“ ");
INSERT INTO hun_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","És odahaza tanítványai ismét megkérdezték őt erről. ");
INSERT INTO hun_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ő pedig ezt mondta nekik: „Aki elbocsátja feleségét, és mást vesz el, házasságtörést követ el az ellen. ");
INSERT INTO hun_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ha pedig a feleség hagyja el a férjét, és mással kel egybe, házasságtörést követ el.“ ");
INSERT INTO hun_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ekkor kisgyermekeket vittek hozzá, hogy érintse meg őket, a tanítványok azonban megfeddték azokat, akik hozták. ");
INSERT INTO hun_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jézus pedig ezt látva, haragra gerjedt, és mondta nékik: „Engedjétek hozzám jönni a kisgyermekeket, és ne tiltsátok el őket, mert ilyeneké az Istennek országa. ");
INSERT INTO hun_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Bizony mondom néktek: Aki nem úgy fogadja az Isten országát, mint egy kisgyermek, semmiképpen sem megy be abba.“ ");
INSERT INTO hun_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Aztán ölébe vette őket, és kezét rájuk téve, megáldotta őket. ");
INSERT INTO hun_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Amikor útnak indult, odafutott hozzá egy ember, és letérdelve előtte, kérdezte őt: „Jó Mester, mit cselekedjem, hogy az örök életet elnyerhessem?“ ");
INSERT INTO hun_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jézus pedig mondta neki: „Miért mondasz engem jónak? Senki sem jó, csak egy, az Isten. ");
INSERT INTO hun_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","A parancsolatokat tudod: »Ne paráználkodjál; ne ölj; ne lopj; hamis tanúbizonyságot ne tégy, kárt ne tégy; tiszteld atyádat és anyádat.«“ ");
INSERT INTO hun_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Az pedig ezt mondta neki: „Mester, mindezeket megtartottam ifjúságomtól fogva.“ ");
INSERT INTO hun_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jézus pedig rátekintett, és megkedvelte őt, és mondta néki: „Egy fogyatékosságod van: eredj el, add el minden vagyonodat, és add a szegényeknek, és kincsed lesz a mennyben; aztán jöjj, és kövess engem, felvéve a keresztet.“ ");
INSERT INTO hun_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Az pedig elszomorodva e beszéden, elment búsan, mert sok jószága volt. ");
INSERT INTO hun_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jézus pedig körültekintve, mondta tanítványainak: „Milyen nehezen mennek be az Isten országába, akiknek gazdagságuk van!“ ");
INSERT INTO hun_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","A tanítványok pedig elálmélkodtak az ő beszédén, de Jézus ismét mondta nékik: „Gyermekeim, milyen nehéz azoknak, akik a gazdagságban bíznak, az Isten országába bemenni! ");
INSERT INTO hun_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Könnyebb a tevének a tű fokán átmenni, mint a gazdagnak az Isten országába bejutni.“ ");
INSERT INTO hun_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Azok pedig még inkább elálmélkodtak, ezt mondva maguk között: „Kicsoda üdvözülhet tehát?“ ");
INSERT INTO hun_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jézus pedig rájuk tekintve, ezt mondta: „Az embereknek lehetetlen, de nem az Istennek, mert az Istennek minden lehetséges.“ ");
INSERT INTO hun_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Péter ezt kezdte mondani neki: „Íme, mi elhagytunk mindent, és követtünk téged.“ ");
INSERT INTO hun_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jézus pedig így felelt: „Bizony mondom néktek, senki sincs, aki elhagyta házát vagy testvéreit, atyját vagy anyját, feleségét vagy gyermekeit, vagy szántóföldjeit énérettem és az evangéliumért, ");
INSERT INTO hun_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","és százannyit ne kapna most ebben az időben, házakat, testvéreket, anyákat, gyermekeket és szántóföldeket, üldözésekkel együtt, a jövendő világon pedig örök életet. ");
INSERT INTO hun_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Sok elsőkből pedig utolsó lesz, és sok utolsóból első.“ ");
INSERT INTO hun_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Mikor pedig a Jeruzsálembe vezető úton mentek fel, és előttük ment Jézus, ők álmélkodtak, és követve őt, féltek. Ekkor a tizenkettőt ismét maga mellé vette, és azokról a dolgokról kezdett nekik szólni, amelyek majd vele történnek, ");
INSERT INTO hun_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","ezt mondván: „Íme, felmegyünk Jeruzsálembe, és az Emberfia átadatik a főpapoknak és az írástudóknak, és halálra ítélik, és a pogányok kezébe adják, ");
INSERT INTO hun_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","megcsúfolják és megostorozzák, megköpdösik és megölik, de harmadnapon feltámad.“ ");
INSERT INTO hun_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Odamentek hozzá Jakab és János, a Zebedeus fiai, és ezt mondták neki: „Mester, szeretnénk, hogy amire kérünk, tedd meg nékünk.“ ");
INSERT INTO hun_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ő pedig ezt kérdezte tőlük: „Mit kívántok, hogy tegyek veletek?“ ");
INSERT INTO hun_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Azok pedig ezt mondták neki: „Add meg nekünk, hogy egyikünk jobb kezed felől, másikunk pedig bal kezed felől üljön a te dicsőségedben.“ ");
INSERT INTO hun_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jézus pedig ezt mondta nekik: „Nem tudjátok, mit kértek. Megihatjátok-e azt a poharat, amelyet én megiszom, és megkeresztelkedhettek-e azzal a keresztséggel, amellyel én megkeresztelkedem?“ ");
INSERT INTO hun_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Azok pedig ezt mondták neki: „Megtehetjük.“ Jézus pedig ezt mondta nekik: „A poharat ugyan, amelyből én iszom, megisszátok, és a keresztséggel, amellyel én megkeresztelkedem, megkeresztelkedtek, ");
INSERT INTO hun_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","de az én jobb és bal kezem felől való ülést nem az én dolgom megadni, hanem azoké lesz az, akiknek elkészíttetett.“ ");
INSERT INTO hun_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Amikor ezt a tíz tanítvány meghallotta, haragudni kezdtek Jakabra és Jánosra. ");
INSERT INTO hun_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jézus pedig magához szólítva őket, ezt mondta nekik: „Tudjátok, hogy azok, akiket a pogányok között fejedelmeknek tartanak, uralkodnak felettük, és nagyjaik hatalmaskodnak rajtuk. ");
INSERT INTO hun_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","De nem így lesz közöttetek, hanem, aki nagy akar lenni közöttetek, az legyen a ti szolgátok, ");
INSERT INTO hun_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","és aki közületek első akar lenni, mindenkinek szolgája legyen. ");
INSERT INTO hun_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Mert az Emberfia sem azért jött, hogy néki szolgáljanak, hanem hogy ő szolgáljon, és adja az ő életét váltságul sokakért.“ ");
INSERT INTO hun_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Azután Jerikóba érkeztek, és amikor ő, tanítványai és nagy sokaság Jerikóból mentek ki, a vak Bartimeus, Timeus fia ott ült az úton, és koldult. ");
INSERT INTO hun_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Amikor meghallotta, hogy a Názáreti Jézus az, így kiáltott fel: „Jézus, Dávidnak Fia, könyörülj rajtam!“ ");
INSERT INTO hun_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Sokan megfedték őt, hogy hallgasson, de ő annál jobban kiáltotta: „Dávidnak Fia, könyörülj rajtam!“ ");
INSERT INTO hun_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Akkor Jézus megállt, és azt mondta, hogy hívják oda. És odahívták a vakot, ezt mondva neki: „Bízzál és kelj föl! Hív téged!“ ");
INSERT INTO hun_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Az pedig felső ruháját ledobta, felkelt, és odament Jézushoz. ");
INSERT INTO hun_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jézus pedig megkérdezte tőle: „Mit akarsz, hogy cselekedjem veled?“ A vak pedig mondta neki: „Mester, hogy lássak.“ ");
INSERT INTO hun_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jézus pedig mondta neki: „Eredj el, a te hited megtartott téged.“ És azonnal megjött a szeme világa, és követte Jézust az úton. ");
INSERT INTO hun_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Amikor Jeruzsálemhez közeledtek, Betfagé és Betánia felé, az Olajfák hegyénél elküldött tanítványai közül kettőt, ");
INSERT INTO hun_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","és ezt mondta nekik: „Eredjetek abba a faluba, amely előttetek van, és amikor abba bejuttok, azonnal találtok egy szamárcsikót megkötve, amelyen ember nem ült még soha; oldjátok el és hozzátok ide. ");
INSERT INTO hun_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ha valaki pedig megkérdezi tőletek: Miért teszitek ezt? Mondjátok: Az Úrnak van szüksége rá. Erre azonnal elengedi.“ ");
INSERT INTO hun_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Elmentek tehát, és megtalálták a megkötött szamárcsikót, az ajtón kívül a kettős útnál, és eloldották azt. ");
INSERT INTO hun_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Az ott állók közül pedig némelyek ezt mondták nekik: „Mit műveltek, hogy eloldjátok a szamárcsikót?“ ");
INSERT INTO hun_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ők pedig úgy feleltek nekik, amint Jézus megparancsolta. Erre elengedték őket. ");
INSERT INTO hun_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Odavitték a szamárcsikót Jézushoz, rátették felsőruháikat, ő pedig felült rá. ");
INSERT INTO hun_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Sokan pedig felsőruháikat az útra terítették, mások pedig ágakat vagdostak a fákról, és az útra szórták. ");
INSERT INTO hun_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Akik pedig előtte mentek, és akik követték, ezt kiáltották: „Hozsánna! Áldott, aki jön az Úrnak nevében! ");
INSERT INTO hun_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Áldott a mi Atyánknak, Dávidnak országa, amely az Úrnak nevében jön! Hozsánna a magasságban!“ ");
INSERT INTO hun_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","És bement Jézus Jeruzsálembe és a templomba, mindenhol körülnézett, és mivel az idő már későre járt, kiment Betániába a tizenkettővel. ");
INSERT INTO hun_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Másnap, mikor Betániából kimentek, megéheztek, ");
INSERT INTO hun_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","és messziről meglátva egy fügefát, amelynek levelei voltak, odament, hátha talál valamit rajta. De odaérve, egyebet, mint levelet, nem talált rajta, mert nem volt fügeérés ideje. ");
INSERT INTO hun_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Akkor Jézus megszólalt, és ezt mondta a fügefának: „Soha többé ne egyék rólad gyümölcsöt senki.“ A tanítványai is hallották ezt. ");
INSERT INTO hun_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Azután Jeruzsálembe érkeztek. Bemenve a templomba, Jézus kezdte kiűzni azokat, akik a templomban árultak és vásároltak, a pénzváltók asztalait és a galambárusok székeit pedig felborította, ");
INSERT INTO hun_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","és nem engedte, hogy valaki edényt vigyen a templomon keresztül. ");
INSERT INTO hun_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Azután így tanította őket: „Nincs-e megírva: »Az én házamat imádság házának nevezik minden nép között«? Ti pedig rablók barlangjává tettétek azt.“ ");
INSERT INTO hun_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","És meghallották az írástudók és a főpapok, és azon tanakodtak, hogy hogyan veszíthetnék el őt. Mert féltek tőle, mivel az egész sokaság álmélkodott az ő tanításán. ");
INSERT INTO hun_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Amikor azután beesteledett, kiment a városból. ");
INSERT INTO hun_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Reggel pedig, amikor elmentek a fügefa mellett, látták, hogy az gyökerestől kiszáradt. ");
INSERT INTO hun_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Péter visszaemlékezve, ezt mondta neki: „Mester, nézd, a fügefa, amelyet megátkoztál, kiszáradt.“ ");
INSERT INTO hun_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","És Jézus ezt felelte nekik: „Legyen hitetek Istenben. ");
INSERT INTO hun_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Mert bizony mondom néktek, ha valaki azt mondja ennek a hegynek: Kelj fel, és ugorjál a tengerbe, és szívében nem kételkedik, hanem hiszi, hogy amit mond, megtörténik, meglesz, amit mondott. ");
INSERT INTO hun_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ezért mondom nektek: Amit könyörgésetekben kértek, higgyétek, hogy mindazt megkapjátok, és meg is adatik néktek. ");
INSERT INTO hun_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","És amikor imádkozva megálltok, bocsássátok meg, ha valaki ellen valami panaszotok van, hogy a ti mennyei Atyátok is megbocsássa nektek vétkeiteket. ");
INSERT INTO hun_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ha pedig ti nem bocsátotok meg, a ti mennyei Atyátok sem bocsátja meg a ti vétkeiteket.“ ");
INSERT INTO hun_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ismét elmentek Jeruzsálembe. Amikor pedig Jézus a templomban körüljárt, odamentek hozzá a főpapok, az írástudók és a vének. ");
INSERT INTO hun_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","És mondták neki: „Milyen hatalommal cselekszed ezeket, és ki adta neked a hatalmat arra, hogy ezeket cselekedd?“ ");
INSERT INTO hun_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jézus pedig ezt mondta nekik: „Én is kérdezek egy dolgot tőletek, feleljetek meg nekem, és megmondom nektek, hogy miféle hatalomnál fogva cselekszem ezeket. ");
INSERT INTO hun_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","A János keresztsége mennyből való volt-e vagy emberektől? Erre feleljetek nekem.“ ");
INSERT INTO hun_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Azok pedig tanakodtak maguk között, ezt mondván: „Ha azt mondjuk: a mennyből, azt fogja mondani: Akkor miért nem hittetek neki? ");
INSERT INTO hun_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Mondjuk talán azt: az emberektől?“ De féltek a néptől, mert mindenki azt tartotta Jánosról, hogy valóban próféta volt. ");
INSERT INTO hun_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ezért így feleltek Jézusnak: „Nem tudjuk.“ Jézus is válaszolt nekik: „Én sem mondom meg nektek, miféle hatalomnál fogva cselekszem ezeket.“ ");
INSERT INTO hun_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ezután példázatokban kezdett beszélni hozzájuk: „Egy ember szőlőt ültetett, körülvette gyepűvel, és sajtót ásott, és tornyot épített, és kiadta munkásoknak, és elutazott. ");
INSERT INTO hun_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Amikor eljött az ideje, szolgát küldött a munkásokhoz, hogy kapjon a munkásoktól a szőlő gyümölcséből. ");
INSERT INTO hun_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Azok azonban megfogták, megverték, és üresen küldték vissza. ");
INSERT INTO hun_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","És ismét küldött hozzájuk egy másik szolgát, akit meg kővel dobáltak meg, fejét betörték, és gyalázattal illetve visszaküldték. ");
INSERT INTO hun_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ismét küldött egy másikat, de azt megölték, és még sok más szolgát is, akik közül némelyeket megvertek, némelyeket pedig megöltek. ");
INSERT INTO hun_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Mivel pedig még egyvalakije, egyetlen szeretett fia is volt, utoljára azt is elküldte hozzájuk, ezt mondván: A fiamat meg fogják becsülni. ");
INSERT INTO hun_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","A munkások azonban ezt mondák maguk között: Ez az örökös, gyertek, öljük meg, és mienk lesz az örökség. ");
INSERT INTO hun_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","És megfogták, megölték, és a szőlőn kívülre dobták. ");
INSERT INTO hun_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Mit cselekszik hát a szőlőnek ura? Eljön, és elveszti a munkásokat, és a szőlőt másoknak adja. ");
INSERT INTO hun_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ezt az Írást sem olvastátok: »Amelyik követ az építők megvetettek, az lett a szegletkővé. ");
INSERT INTO hun_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Az Úrtól lett ez, és csodálatos a mi szemeink előtt«?“ ");
INSERT INTO hun_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","És igyekeztek őt elfogni, de féltek a sokaságtól, mert tudták, hogy a példázatot ellenük mondta. Ezért otthagyták őt, és tovább mentek onnan. ");
INSERT INTO hun_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Elküldtek hozzá néhányat a farizeusok és a Heródes-pártiak közül, hogy szavaival fogják meg. ");
INSERT INTO hun_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Azok pedig odamenve, ezt mondták neki: „Mester, tudjuk hogy igaz vagy, és nem tartasz senkitől, mert nem az emberek személyére tekintesz, hanem az igazság szerint tanítod az Isten útját. Szabad-e a császárnak adót fizetni vagy nem? Fizessünk vagy ne fizessünk?“ ");
INSERT INTO hun_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ő pedig ismerve képmutatásukat, ezt mondta nekik: „Miért kísértetek engem? Hozzatok nekem egy pénzt, hadd lássam.“ ");
INSERT INTO hun_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Azok pedig hoztak, és Jézus megkérdezte tőlük: „Kié ez a kép és a felirat?“ Azok pedig ezt felelték: „A császáré.“ ");
INSERT INTO hun_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ekkor Jézus ezt mondta nékik: „Adjátok meg a császárnak, ami a császáré, és az Istennek, ami az Istené.“ És elálmélkodtak rajta. ");
INSERT INTO hun_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ezután szadduceusok jöttek hozzá, akik azt mondják, hogy nincsen feltámadás, és megkérdezték tőle: ");
INSERT INTO hun_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","„Mester, Mózes azt írta nekünk, hogy »ha valakinek testvére meghalt, és feleséget hagyott hátra, gyermekeket pedig nem hagyott, akkor a feleségét vegye el az ő testvére, és támasszon utódot a testvérének.« ");
INSERT INTO hun_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Volt tehát hét fiútestvér. Az első feleséget vett, de meghalt, és nem hagyott utódot. ");
INSERT INTO hun_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","A második is elvette az asszonyt, de meghalt, és utódot ő sem hagyott. Hasonlóképpen a harmadik is, ");
INSERT INTO hun_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","és mind a hét elvette, és utódot nem hagytak. Legutoljára meghalt az asszony is. ");
INSERT INTO hun_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","A feltámadáskor tehát, mikor feltámadnak, melyiküknek lesz a felesége? Mert mind a hétnek a felesége volt.“ ");
INSERT INTO hun_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jézus pedig így felelt nekik: „Vagy nem azért tévelyegtek-e, mert nem ismeritek az Írásokat, sem az Istennek hatalmát? ");
INSERT INTO hun_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Mert amikor a halálból feltámadnak, sem nem házasodnak, sem férjhez nem mennek, hanem olyanok lesznek, mint az angyalok a mennyekben. ");
INSERT INTO hun_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","A halottakról pedig, hogy feltámadnak, nem olvastátok-e a Mózes könyvében, a csipkebokornál, hogy hogyan szólott neki az Isten, ezt mondván: »Én vagyok Ábrahám Istene, Izsák Istene és Jákób Istene«? ");
INSERT INTO hun_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Az Isten nem holtaknak, hanem élőknek Istene. Ti tehát igen tévelyegtek.“ ");
INSERT INTO hun_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Akkor odament hozzá egy az írástudók közül, aki az ő vitatkozásukat hallotta, és tudva, hogy jól megfelelt nekik, megkérdezte tőle: „Melyik az első az összes parancsolat közül?“ ");
INSERT INTO hun_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jézus ezt felelt neki: „Minden parancsolat közül az első: »Halljad, Izrael, az Úr, a mi Istenünk az egyetlen Úr. ");
INSERT INTO hun_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Szeressed azért az Urat, a te Istenedet teljes szívedből, teljes lelkedből, teljes elmédből és teljes erődből. Ez az első parancsolat.« ");
INSERT INTO hun_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","A második pedig hasonlít ehhez: »Szeresd felebarátodat, mint magadat.« Nincs más ezeknél nagyobb parancsolat.“ ");
INSERT INTO hun_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Akkor mondta neki az írástudó: „Jól van, Mester, helyesen mondod, hogy egy Isten van, és nincsen kívüle más, ");
INSERT INTO hun_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","és szeretni őt teljes szívből, teljes elméből, teljes lélekből és teljes erőből és szeretni az ember felebarátját, mint önmagát, többet ér minden égőáldozatnál és véres áldozatnál.“ ");
INSERT INTO hun_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jézus pedig látva, hogy bölcsen felelt, ezt mondta neki: „Nem vagy messze az Isten országától.“ És többé senki sem merte őt megkérdezni. ");
INSERT INTO hun_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Amint Jézus a templomban tanított, ezt kérdezte: „Hogyan mondhatják az írástudók, hogy a Krisztus Dávidnak Fia? ");
INSERT INTO hun_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Hiszen Dávid maga mondta a Szentlélek által: »Mondta az Úr az én Uramnak: ülj az én jobb kezem felől, amíg lábaid alá nem vetem ellenségeidet zsámolyul.« ");
INSERT INTO hun_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Tehát maga Dávid nevezi őt »Urának«, hogyan lehet akkor a Fia?“ És a nagy sokaság örömmel hallgatta. ");
INSERT INTO hun_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jézus pedig ezt mondta nekik tanításában: „Őrizkedjetek az írástudóktól, akik örömest járnak hosszú köntösökben, és szeretik, ha a piacokon köszöntik őket. ");
INSERT INTO hun_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","És szeretik a gyülekezetekben az első helyeket és a lakomákon a főhelyeket. ");
INSERT INTO hun_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Az özvegyeknek házát fölemésztik, és színlelésből hosszan imádkoznak: ezek súlyosabb ítélet alá esnek.“ ");
INSERT INTO hun_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ezután leült Jézus a templompersellyel átellenben, és nézte, hogy a sokaság miként dob pénzt a perselybe. Sok gazdag pedig sokat dobott abba. ");
INSERT INTO hun_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Egy szegény özvegyasszony is odajött, két fillért, azaz egynegyed pénzt dobott bele. ");
INSERT INTO hun_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Akkor odaszólította tanítványait, és ezt mondta nekik: „Bizony mondom néktek, hogy ez a szegény özvegyasszony többet dobott mindenkinél, akik a perselybe dobtak. ");
INSERT INTO hun_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Mert azok mindnyájan a fölöslegükből dobtak, ő pedig a szegénységéből, amije csak volt, mind bedobta, az egész vagyonát.“ ");
INSERT INTO hun_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Amikor Jézus a templomból kiment, tanítványai közül az egyik ezt mondta neki: „Mester, nézd, milyen kövek, és milyen épületek!“ ");
INSERT INTO hun_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jézus pedig ezt felelte neki: „Látod ezeket a nagy épületeket? Nem marad kő kövön, amelyet le nem rombolnak.“ ");
INSERT INTO hun_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Mikor pedig az Olajfák hegyén ült, a templommal átellenben, maguk között megkérdezte tőle Péter, Jakab, János és András: ");
INSERT INTO hun_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","„Mondd meg nékünk, mikor történnek meg ezek, és mi lesz a jel, amikor mindezek beteljesednek?“ ");
INSERT INTO hun_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jézus pedig felelt nekik, és ezt kezdte mondani: „Vigyázzatok, hogy valaki meg ne tévesszen titeket. ");
INSERT INTO hun_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Mert sokan jönnek majd az én nevemben, akik azt mondják: Én vagyok – és sokakat megtévesztenek. ");
INSERT INTO hun_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Mikor pedig hallani fogtok háborúkról, és háborúk híreiről, meg ne rémüljetek, mert ezeknek meg kell lenniük, de ez még nem a vég. ");
INSERT INTO hun_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Mert nemzet nemzet ellen, és ország ország ellen támad, lesznek földindulások mindenfelé, és lesznek éhségek és háborúságok. ");
INSERT INTO hun_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Nyomorúságok kezdetei ezek. Ti pedig vigyázzatok magatokra, mert törvényszékeknek adnak át titeket, a gyülekezetekben vernek meg, helytartók és királyok elé állítanak énértem, bizonyságul nekik. ");
INSERT INTO hun_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","De előbb hirdetni kell az evangéliumot minden pogány között. ");
INSERT INTO hun_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Mikor pedig elfogva visznek, hogy átadjanak titeket, ne aggodalmaskodjatok előre, hogy mit szóljatok, és ne gondolkodjatok, hanem ami adatik nektek abban az órában, azt szóljátok, mert nem ti vagytok, akik szóltok, hanem a Szentlélek. ");
INSERT INTO hun_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Akkor pedig testvér testvérét, atya gyermekét fogja halálra adni; gyermekek támadnak szülők ellen, és megöletik őket. ");
INSERT INTO hun_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","És gyűlöletesek lesztek mindenki előtt az én nevemért, de aki mindvégig kitart, az üdvözül. ");
INSERT INTO hun_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Mikor pedig meglátjátok a »pusztító utálatosságot« – amelyről Dániel próféta szólt – ott állni, ahol nem kellene (aki olvassa, értse meg!), akkor akik Júdeában lesznek, fussanak a hegyekre, ");
INSERT INTO hun_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","a háztetőn levő pedig le ne szálljon a házba, se be ne menjen, hogy házából valamit kivigyen; ");
INSERT INTO hun_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","és a mezőn levő haza ne térjen, hogy ruháját elvigye. ");
INSERT INTO hun_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Jaj pedig a terhes és a szoptató asszonyoknak azokban a napokban. ");
INSERT INTO hun_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Imádkozzatok pedig, hogy a ti futástok ne télen legyen. ");
INSERT INTO hun_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Mert azok a napok olyan nyomorúságosak lesznek, amilyenek a világ kezdete óta, amelyet Isten teremtett, mind ez ideig nem voltak, és nem is lesznek. ");
INSERT INTO hun_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","És ha az Úr meg nem rövidítette volna azokat a napokat, egyetlen test sem menekülne meg, de a választottakért, akiket kiválasztott, megrövidítette azokat a napokat. ");
INSERT INTO hun_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","„Ha pedig akkor ezt mondja nektek valaki: Íme, itt a Krisztus, vagy: Íme, amott, ne higgyétek. ");
INSERT INTO hun_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Mert hamis Krisztusok és hamis próféták támadnak, jeleket és csodákat tesznek, hogy megtévesszék, ha lehet, még a választottakat is. ");
INSERT INTO hun_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ti pedig vigyázzatok, íme, előre megmondtam nektek mindent! ");
INSERT INTO hun_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","De azokban a napokban, azután a nyomorúság után, »a nap elsötétedik, és a hold nem fénylik, ");
INSERT INTO hun_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","és az ég csillagai lehullanak, és az egekben levő hatalmasságok megrendülnek.« ");
INSERT INTO hun_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Akkor meglátják az Emberfiát eljönni felhőkön, nagy hatalommal és dicsőséggel. ");
INSERT INTO hun_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","És akkor elküldi az angyalait, és egybegyűjti választottait a világ négy tája felől, a föld végső határától az ég végső határáig. ");
INSERT INTO hun_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","A fügefáról vegyétek pedig a példát. Amikor ága már zsendül, és levelet hajt, tudjátok, hogy közel van a nyár. ");
INSERT INTO hun_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Azonképpen ti is, mikor látjátok, hogy ezek meglesznek, tudjátok meg, hogy közel van ő, az ajtó előtt. ");
INSERT INTO hun_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Bizony mondom néktek, hogy el nem múlik ez a nemzetség, amíg meg nem lesznek mindezek. ");
INSERT INTO hun_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Az ég és a föld elmúlnak, de az én beszédeim soha el nem múlnak. ");
INSERT INTO hun_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Arról a napról és óráról pedig senki semmit sem tud, sem az égben az angyalok, sem a Fiú, hanem csak az Atya. ");
INSERT INTO hun_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Figyeljetek, vigyázzatok és imádkozzatok, mert nem tudjátok, mikor jön el az az idő! ");
INSERT INTO hun_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Úgy, mint az az ember, aki messze útra kelve, házát elhagyva, szolgáit felhatalmazva, kinek-kinek a maga dolgát megszabva, az ajtónállónak is megparancsolta, hogy vigyázzon. ");
INSERT INTO hun_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Vigyázzatok azért, mert nem tudjátok, mikor érkezik meg a háznak ura, este-e vagy éjfélkor, vagy kakasszókor, vagy reggel. ");
INSERT INTO hun_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Nehogy, ha hirtelen megérkezik, alva találjon titeket. ");
INSERT INTO hun_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Amiket pedig nektek mondok, mindenkinek mondom: Vigyázzatok!“ ");
INSERT INTO hun_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Két nap múlva pedig húsvét volt, és a kovásztalan kenyerek ünnepe. A főpapok és az írástudók azon tanakodtak, hogy csalárdsággal hogyan fogják meg és öljék meg őt. ");
INSERT INTO hun_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Mert azt mondták: „Ne az ünnepen, hogy a nép fel ne zendüljön.“ ");
INSERT INTO hun_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Mikor pedig Betániában a poklos Simon házánál volt, amint asztalhoz ült, egy asszony ment oda, akinél alabástromedény volt valódi és igen drága nárdusolajjal; és eltörve az alabástromedényt kitöltötte azt az ő fejére. ");
INSERT INTO hun_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Némelyek pedig háborogtak maguk között, és ezt mondták: „Mire való az olajnak ez a tékozlása? ");
INSERT INTO hun_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Mert el lehetett volna azt adni háromszáz pénznél is többért és odaadni a szegényeknek.“ És zúgolódtak ellene. ");
INSERT INTO hun_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Jézus pedig ezt mondta: „Hagyjátok békén! Miért bántjátok őt? Jó dolgot cselekedett énvelem. ");
INSERT INTO hun_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Mert a szegények mindenkor veletek lesznek, és amikor csak akarjátok, jót tehettek velük; de én nem leszek mindenkor veletek. ");
INSERT INTO hun_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ő, ami tőle telt, azt tette: előre megkente az én testemet a temetésre. ");
INSERT INTO hun_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Bizony mondom néktek: Valahol csak prédikálják ezt az evangéliumot az egész világon, amit ez az asszony cselekedett, azt is hirdetni fogják az ő emlékezetére.“ ");
INSERT INTO hun_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Akkor Júdás Iskáriótes, egy a tizenkettő közül, elment a főpapokhoz, hogy azoknak elárulja őt. ");
INSERT INTO hun_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Azok pedig, amint meghallották, örvendeztek, és ígérték, hogy pénzt adnak neki. Ő pedig kereste a jó alkalmat, hogy árulhassa őt. ");
INSERT INTO hun_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","A kovásztalan kenyerek ünnepének első napján, amikor a húsvéti bárányt szokták vágni, ezt mondták neki a tanítványai: „Hova akarod, hogy elmenjünk, és elkészítsük, és megehesd a húsvéti bárányt?“ ");
INSERT INTO hun_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Akkor elküldött kettőt az ő tanítványai közül, és ezt mondta nekik: „Menjetek el a városba, és ott egy ember jön veletek szembe, aki egy korsó vizet visz; kövessétek őt, ");
INSERT INTO hun_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","és ahová bemegy, mondjátok a házigazdának: A Mester kérdi: hol van az a szállás, ahol megeszem az én tanítványaimmal a húsvéti bárányt? ");
INSERT INTO hun_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","És ő mutat nektek egy nagy házat vacsorára berendezve, készen: ott készítsétek el nekünk.“ ");
INSERT INTO hun_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Elmentek tehát a tanítványai, és eljutottak a városba, és úgy találtak mindent, amint nekik megmondta, és elkészítették a húsvéti bárányt. ");
INSERT INTO hun_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Mikor pedig beesteledett, odament a tizenkettővel, ");
INSERT INTO hun_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","és amikor leültek és ettek, ezt mondta Jézus: „Bizony mondom néktek, egy közületek elárul engem, aki együtt eszik velem.“ ");
INSERT INTO hun_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ők pedig szomorkodni kezdtek, és egyenként kérdezni tőle: „Csak nem én?“ A másik is: „Csak nem én?“ ");
INSERT INTO hun_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ő pedig ezt felelte nekik: „Egy a tizenkettő közül, aki velem együtt márt a tálba. ");
INSERT INTO hun_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Az Emberfia jóllehet elmegy, amint meg van írva felőle, de jaj annak az embernek, aki az Emberfiát elárulja: jobb lenne annak az embernek, ha meg sem született volna.“ ");
INSERT INTO hun_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","És mikor ettek, vette Jézus a kenyeret, és hálákat adva, megtörte, és adta nekik, ezt mondván: „Vegyétek, egyétek, ez az én testem.“ ");
INSERT INTO hun_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","És vette a poharat, és hálákat adva, adta nekik; és ittak belőle mindnyájan, ");
INSERT INTO hun_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","és ezt mondta nekik: „Ez az én vérem, az új szövetség vére, amely sokakért kiontatik. ");
INSERT INTO hun_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Bizony mondom néktek, nem iszom többé a szőlőtőnek gyümölcséből mind ama napig, amikor mint újat iszom azt az Isten országában.“ ");
INSERT INTO hun_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ezután dicséretet énekelve kimentek az Olajfák hegyére. ");
INSERT INTO hun_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jézus pedig ezt mondta nekik: „Ezen az éjszakán mindnyájan megbotránkoztok bennem, mert meg van írva: »Megverem a pásztort, és elszélednek a juhok.« ");
INSERT INTO hun_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","De feltámadásom után előttetek fogok felmenni Galileába.“ ");
INSERT INTO hun_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Péter pedig ezt mondta neki: „Ha mindnyájan megbotránkoznak is, én akkor sem.“ ");
INSERT INTO hun_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jézus ezt mondta neki: „Bizony mondom néked: még ma, ezen az éjszakán, mielőtt a kakas kétszer megszólalna, háromszor tagadsz meg engem.“ ");
INSERT INTO hun_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ő pedig annál inkább mondta: „Ha veled együtt kell is meghalnom, semmiképpen nem tagadlak meg téged.“ Hasonlóképpen szóltak a többiek is. ");
INSERT INTO hun_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ekkor arra a helyre mentek, amelynek Gecsemáné a neve, és ezt mondta a tanítványainak: „Üljetek le itt, amíg imádkozom.“ ");
INSERT INTO hun_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","És maga mellé vette Pétert, Jakabot és Jánost, rettegni és gyötrődni kezdett, ");
INSERT INTO hun_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","majd ezt mondta nekik: „Szomorú az én lelkem mind halálig; maradjatok itt, és virrasszatok.“ ");
INSERT INTO hun_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Egy kissé előre ment, a földre borult, és imádkozott, hogy ha lehetséges, múljék el tőle ez az óra. ");
INSERT INTO hun_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","És ezt mondta: „Abbá, Atyám! Minden lehetséges néked: vedd el tőlem ezt a poharat; mindazáltal ne az én akaratom legyen meg, hanem a tied.“ ");
INSERT INTO hun_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Azután visszatért, és alva találta őket, és ezt mondta Péternek: „Simon, alszol? Nem bírtál egy óráig virrasztani? ");
INSERT INTO hun_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Vigyázzatok és imádkozzatok, hogy kísértésbe ne essetek: a lélek ugyan kész, de a test erőtelen.“ ");
INSERT INTO hun_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ismét elment, és ugyanazon szavakkal imádkozott. ");
INSERT INTO hun_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Amikor pedig visszatért, ismét alva találta őket, mert a szemeik elnehezedtek; és nem tudták, mit feleljenek neki. ");
INSERT INTO hun_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Harmadszor is jött, és ezt mondta nekik: „Aludjatok immár és nyugodjatok. Elég! Eljött az óra! Íme, az Emberfia bűnösök kezébe adatik. ");
INSERT INTO hun_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Keljetek föl, menjünk! Íme, közel van, aki engem elárul.“ ");
INSERT INTO hun_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","És még mikor beszélt, eljött Júdás, egy a tizenkettő közül, és vele együtt nagy sokaság, fegyverekkel és botokkal, a főpapoktól, az írástudóktól és a vénektől. ");
INSERT INTO hun_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Az árulója pedig jelt adott nekik, ezt mondta: „Akit megcsókolok majd, ő az; fogjátok el, és vigyétek el biztos őrizettel.“ ");
INSERT INTO hun_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","És odajutva, azonnal hozzáment, és mondta: „Mester! Mester!“ És megcsókolta őt. ");
INSERT INTO hun_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Azok pedig rátették kezeiket, és elfogták őt. ");
INSERT INTO hun_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","De egy az ott állók közül az ő szablyáját kivonva, a főpap szolgájához csapott, és levágta annak fülét. ");
INSERT INTO hun_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jézus pedig ezt mondta nekik: „Mint egy rablóra, úgy jöttetek reám fegyverekkel és botokkal, hogy megfogjatok engem?! ");
INSERT INTO hun_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Naponta nálatok voltam, a templomban tanítottam, és nem fogtatok el engem; de szükséges, hogy az Írások beteljesedjenek.“ ");
INSERT INTO hun_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Akkor elhagyva őt, mindnyájan elfutottak. ");
INSERT INTO hun_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Egy ifjú pedig követte őt, akinek testét csak egy gyolcsing takarta: elfogták őt is. ");
INSERT INTO hun_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","De ő otthagyva ingét, meztelenül elszaladt tőlük. ");
INSERT INTO hun_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ekkor Jézust a főpaphoz vitték, és oda gyülekeztek mindnyájan a főpapok, a vének és az írástudók. ");
INSERT INTO hun_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Péter pedig távolról követte őt, be egészen a főpap udvaráig, és ott ült a szolgákkal, és melegedett a tűznél. ");
INSERT INTO hun_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","A főpapok pedig és az egész tanács bizonyítékot kerestek Jézus ellen, hogy megölhessék őt; de nem találtak. ");
INSERT INTO hun_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Mert sokan tettek ugyan hamis tanúbizonyságot ellene, de a bizonyságtételek nem voltak megegyezők. ");
INSERT INTO hun_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ekkor néhányan fölkeltek, és hamis vallomást tettek ellene, ezt mondták: ");
INSERT INTO hun_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","„Mi hallottuk, amikor ezt mondta: Én lerombolom ezt a kézzel csinált templomot, és három nap alatt mást építek, amelyet nem kéz alkotott.“ ");
INSERT INTO hun_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","De még így sem egyezett vallomásuk. ");
INSERT INTO hun_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Akkor a főpap odaállt középre, és megkérdezte Jézust: „Semmit sem felelsz? Miféle vallomást tesznek ezek ellened?“ ");
INSERT INTO hun_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ő pedig hallgatott, és semmit sem felelt. Ismét megkérdezte őt a főpap, és mondta neki: „Te vagy-e a Krisztus, az áldott Isten Fia?“ ");
INSERT INTO hun_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jézus pedig ezt mondta: „Én vagyok. És meglátjátok majd az Emberfiát a hatalomnak jobbján ülni és eljönni az ég felhőin.“ ");
INSERT INTO hun_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","A főpap pedig megszaggatva ruháit, ezt mondta: „Mi szükségünk van még tanúkra? ");
INSERT INTO hun_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Hallátok a káromlást. Mi a véleményetek?“ Azok pedig halálra méltónak ítélték őt mindnyájan. ");
INSERT INTO hun_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","És kezdték némelyek köpdösni, az arcát betakarni és ütlegelni és ezt mondani neki: „Most prófétálj!“ A szolgák pedig arcul csapták őt. ");
INSERT INTO hun_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Amint pedig Péter lent volt az udvarban, odajött egy a főpap szolgálói közül. ");
INSERT INTO hun_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Meglátta Pétert, amint melegedett, rátekintett, és ezt mondta: „Te is a Názáreti Jézussal voltál!“ ");
INSERT INTO hun_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ő pedig tagadta, és azt mondta: „Nem ismerem s nem is értem, mit mondasz.“ És kiment a tornácra; és a kakas megszólalt. ");
INSERT INTO hun_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","A szolgáló pedig meglátva őt, ismét mondani kezdte az ott állóknak: „Ez közülük való.“ ");
INSERT INTO hun_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ő pedig ismét tagadta. De kevés idő múlva az ott állók ismét mondták Péternek: „Bizony közülük való vagy, mert Galileából való vagy te is, és a beszéded is hasonló.“ ");
INSERT INTO hun_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ő pedig átkozódni és esküdözni kezdett: „Nem ismerem azt az embert, akiről beszéltek.“ ");
INSERT INTO hun_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","És másodszor is megszólalt a kakas. Ekkor Péternek eszébe jutott a beszéd, amelyet Jézus mondott neki: „Mielőtt a kakas kétszer megszólalna, háromszor megtagadsz engem.“ És sírva fakadt. ");
INSERT INTO hun_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Mindjárt reggel tanácsot tartottak a főpapok a vénekkel és írástudókkal, és az egész tanáccsal együtt. Azután Jézust megkötözve elvitték, és átadták Pilátusnak. ");
INSERT INTO hun_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilátus pedig megkérdezte őt: „Te vagy-e a zsidók királya?“ Ő pedig így felelt: „Te mondod.“ ");
INSERT INTO hun_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","És erősen vádolták őt a főpapok. ");
INSERT INTO hun_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilátus pedig ismét megkérdezte őt: „Semmit sem felelsz? Íme, mennyi tanúbizonyságot szólnak ellened!“ ");
INSERT INTO hun_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Jézus pedig semmit sem felelt, úgyhogy Pilátus elcsodálkozott. ");
INSERT INTO hun_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ünnepenként pedig egy foglyot szokott elbocsátani nekik, akit éppen óhajtottak. ");
INSERT INTO hun_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Volt pedig egy Barabbás nevű fogoly, megkötöztetve azokkal a lázadókkal együtt, akik a lázadás alkalmával gyilkosságot követtek el. ");
INSERT INTO hun_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","A sokaság pedig kiáltva, kezdte kérni Pilátust arra, amit mindenkor megtett nekik. ");
INSERT INTO hun_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilátus pedig ezt kérdezte tőlük: „Akarjátok-e, hogy elbocsássam nektek a zsidók királyát?“ – ");
INSERT INTO hun_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","mert tudta, hogy irigységből adták kezére a főpapok. ");
INSERT INTO hun_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","A főpapok azonban felizgatták a sokaságot, hogy inkább Barabbást bocsássa el nekik. ");
INSERT INTO hun_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilátus pedig ismét megkérdezte tőlük: „Mit akartok tehát, hogy cselekedjem azzal, akit a zsidók királyának mondotok?“ ");
INSERT INTO hun_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","És azok ismét kiáltottak: „Feszítsd meg!“ ");
INSERT INTO hun_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilátus pedig ezt mondta nekik: „De mi rosszat cselekedett?“ Azok pedig annál jobban kiáltottak: „Feszítsd meg!“ ");
INSERT INTO hun_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilátus pedig eleget akarva tenni a sokaságnak, elbocsátotta nekik Barabbást, Jézust pedig megostoroztatva, kezükbe adta, hogy megfeszítsék. ");
INSERT INTO hun_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","A vitézek pedig elvitték őt az udvar belső részébe, ami az őrház, és összehívták az egész csapatot. ");
INSERT INTO hun_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Bíborba öltöztették, és tövisből font koszorút tettek a fejére, ");
INSERT INTO hun_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","és elkezdték őt köszönteni: „Üdvözlégy, zsidók királya!“ ");
INSERT INTO hun_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","A fejét nádszállal verték, leköpdösték, és térdet hajtva tisztelték őt. ");
INSERT INTO hun_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Mikor pedig kicsúfolták, levették róla a bíbor ruhát, és saját ruháiba öltöztették; és kivitték, hogy megfeszítsék. ");
INSERT INTO hun_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Kényszerítettek egy mellettük elmenő embert, bizonyos cirénei Simont, aki a mezőről jött, Alexander és Rufusz atyját, hogy vigye a keresztjét. ");
INSERT INTO hun_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Elvitték őt a Golgota nevű helyre, amely megmagyarázva azt jelenti: Koponya-hely, ");
INSERT INTO hun_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","és mirhás bort adtak neki inni; de ő nem fogadta el. ");
INSERT INTO hun_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ekkor keresztre feszítették, és elosztották ruháit, sorsot vetve azokra, hogy ki mit kapjon. ");
INSERT INTO hun_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Három óra volt, amikor megfeszítették őt. ");
INSERT INTO hun_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Az elítélésének oka pedig így volt föléje felírva: A ZSIDÓK KIRÁLYA. ");
INSERT INTO hun_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Két rablót is megfeszítettek vele együtt, egyet jobb és egyet bal keze felől. ");
INSERT INTO hun_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","És így teljesedett be az Írás, amely azt mondja: „És bűnösök közé számlálták.“ ");
INSERT INTO hun_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Az arra menők pedig szidalmazták őt, fejüket hajtogatva és ezt mondva: „Hah! – te, aki lerontod a templomot, és három nap alatt fölépíted, ");
INSERT INTO hun_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","szabadítsd meg magadat, és szállj le a keresztről!“ ");
INSERT INTO hun_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Hasonlóképpen a főpapok is, csúfolódva egymás között, az írástudókkal együtt ezt mondták: „Másokat megmentett, de magát nem bírja megmenteni. ");
INSERT INTO hun_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","A Krisztus, az Izrael királya, szálljon le most a keresztről, hogy lássuk, és higgyünk.“ Akiket vele feszítettek meg, azok is szidalmazták őt. ");
INSERT INTO hun_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Amikor pedig hat óra lett, sötétség támadt az egész földön kilenc óráig. ");
INSERT INTO hun_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","És kilenc órakor Jézus hangosan felkiáltott és ezt mondta: „Elói, Elói! Lámá sabaktáni?“ – ami megmagyarázva azt jelenti: „Én Istenem, én Istenem! Miért hagytál el engemet?“ ");
INSERT INTO hun_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Néhányan pedig meghallva ezt az ott állók közül, ezt mondták: „Íme, Illést hívja.“ ");
INSERT INTO hun_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Egy ember pedig odafutott, és egy szivacsot megtöltve ecettel, nádszálra tűzve, inni adott neki, és ezt mondta: „Hadd lássuk, eljön-e Illés, hogy levegye!“ ");
INSERT INTO hun_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jézus pedig hangosan felkiáltva kibocsátotta lelkét. ");
INSERT INTO hun_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ekkor a templom kárpitja felülről az aljáig kettéhasadt. ");
INSERT INTO hun_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Amikor pedig a százados, aki vele átellenben állt, látta, hogy így kiáltva bocsátotta ki lelkét, ezt mondta: „Bizony ez az ember Isten Fia volt!“ ");
INSERT INTO hun_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Asszonyok is voltak ott, akik távolról nézték, és közöttük volt a magdalai Mária és Mária, a kis Jakabnak és Józsefnek anyja és Salómé, ");
INSERT INTO hun_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","akik amikor Galileában volt, akkor is követték őt, és szolgáltak neki; és sok más asszony, akik vele mentek fel Jeruzsálembe. ");
INSERT INTO hun_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Amikor immár este lett, mivel péntek volt, azaz szombat előtt való nap, ");
INSERT INTO hun_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","eljött az arimátiai József, egy tisztességes tanácsbeli, aki maga is várta az Isten országát; bement bátran Pilátushoz, és elkérte Jézusnak testét. ");
INSERT INTO hun_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilátus pedig csodálkozott, hogy már meghalt, ezért magához hívatta a századost, és megkérdezte tőle, hogy régen halt-e meg. ");
INSERT INTO hun_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Amikor ezt megtudta a századostól, odaajándékozta a testet Józsefnek. ");
INSERT INTO hun_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ő pedig gyolcsot vásárolt, levette őt, begöngyölte a gyolcsba, és elhelyezte egy sírboltba, amely kősziklába volt kivágva; és követ hengerített a sírbolt szájára. ");
INSERT INTO hun_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","A magdalai Mária pedig és Mária, a József anyja nézték, hová helyezték őt. ");
INSERT INTO hun_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Mikor pedig elmúlt a szombat, a magdalai Mária és Mária, a Jakab anyja és Salómé drága keneteket vásároltak, hogy elmenjenek, és megkenjék őt. ");
INSERT INTO hun_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Korán reggel, a hétnek első napján a sírbolthoz mentek napkeltekor, ");
INSERT INTO hun_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","és ezt mondták maguk között: „Kicsoda hengeríti el nekünk a követ a sírbolt szájáról?“ ");
INSERT INTO hun_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","És odatekintve látták, hogy a kő el van hengerítve; pedig az felette nagy volt. ");
INSERT INTO hun_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","És bemenve a sírboltba, láttak egy ifjút ülni jobb felől, fehér ruhába öltözve, és megrémültek. ");
INSERT INTO hun_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Az pedig mondta nekik: „Ne féljetek! A Názáreti Jézust keresitek, akit megfeszítettek? Föltámadott, nincsen itt. Íme, a hely, ahová őt helyezték. ");
INSERT INTO hun_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","De menjetek el, mondjátok meg a tanítványainak és Péternek, hogy előttetek megy Galileába: ott meglátjátok őt, amint megmondta nektek.“ ");
INSERT INTO hun_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ekkor igen hamar kijöttek, és elfutottak a sírbolttól, mert félelem és álmélkodás fogta el őket; és senkinek semmit sem szóltak, mert féltek. ");
INSERT INTO hun_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Mikor pedig reggel, a hétnek első napján föltámadott, megjelent először a magdalai Máriának, akiből hét ördögöt űzött ki. ");
INSERT INTO hun_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ő elment, és jelentette ezt azoknak, akik vele voltak, keseregtek és sírtak. ");
INSERT INTO hun_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Amikor pedig ezek hallották, hogy él, és ő látta, nem hitték el. ");
INSERT INTO hun_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ezután pedig közülük kettőnek jelent meg más alakban, útközben, amikor a mezőre mentek. ");
INSERT INTO hun_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ezek is elmentek, és jelenték a többieknek, de nekik sem hittek. ");
INSERT INTO hun_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Azután, amikor asztalnál ültek, megjelent magának a tizenegynek, és szemükre vetette hitetlenségüket és keményszívűségüket, hogy azoknak, akik őt feltámadva látták, nem hittek. ");
INSERT INTO hun_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ezután ezt mondta nekik: „Menjetek el széles e világra, hirdessétek az evangéliumot minden teremtésnek. ");
INSERT INTO hun_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Aki hisz és megkeresztelkedik, üdvözül, aki pedig nem hisz, elkárhozik. ");
INSERT INTO hun_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Azokat pedig, akik hisznek, ilyen jelek követik: az én nevemben ördögöket űznek ki, új nyelveken szólnak, ");
INSERT INTO hun_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","kígyókat vesznek föl, és ha valami halálosat isznak, nem árt nekik, betegekre teszik kezeiket, és azok meggyógyulnak.“ ");
INSERT INTO hun_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Az Úr Jézus pedig, miután ezeket mondta nekik, felvitetett a mennybe, és az Istennek jobbjára ült. ");
INSERT INTO hun_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Azok pedig elmentek, prédikáltak mindenütt, az Úr pedig együtt munkálkodott velük, és megerősítette az igét a jelek által, amelyek követték. Ámen!");
INSERT INTO hun_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Mivel sokan kezdték már rendszeresen megírni azoknak az eseményeknek elbeszélését, amelyek nálunk beteljesedtek, ");
INSERT INTO hun_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","úgy, amint ránk hagyták azokat, akik kezdettől fogva szemtanúi és szolgái voltak az igének, ");
INSERT INTO hun_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","jónak láttam magam is, aki eleitől fogva mindennek szorgalmasan végére jártam, hogy azokról rendszeresen írjak neked, jó Teofilus, ");
INSERT INTO hun_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","hogy megtudd azoknak a dolgoknak megbízhatóságát, amelyekre tanítottak. ");
INSERT INTO hun_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Heródesnek, Júdea királyának idejében volt egy Zakariás nevű pap, az Abija rendjéből. Felesége pedig Áron leányai közül való volt, és annak neve: Erzsébet. ");
INSERT INTO hun_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Mindketten igazak voltak Isten előtt, és feddhetetlenül éltek az Úr parancsolatai és rendelései szerint. ");
INSERT INTO hun_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Nem volt nekik gyermekük, mert Erzsébet meddő volt, és mindketten már idős emberek voltak. ");
INSERT INTO hun_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Történt pedig, hogy amikor rendjének beosztása szerint papi szolgálatot végzett Isten előtt, ");
INSERT INTO hun_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","a papi tiszt szokása szerint rá került a sor, hogy bemenjen az Úr templomába, és bemutassa a füstölőáldozatot. ");
INSERT INTO hun_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","A nép egész sokasága kint imádkozott a füstölőáldozat idején. ");
INSERT INTO hun_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Neki pedig megjelent az Úr angyala, megállt a füstölőoltár jobb oldalán. ");
INSERT INTO hun_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Láttára megrettent Zakariás, és félelem szállta meg. ");
INSERT INTO hun_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Az angyal ezt mondta neki: „Ne félj, Zakariás, mert meghallgatásra talált a te könyörgésed, és feleséged, Erzsébet fiút szül neked, akit nevezz Jánosnak. ");
INSERT INTO hun_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ő örömödre és vigasságodra lesz, és sokan fognak örülni születésének, ");
INSERT INTO hun_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","mert nagy lesz ő az Úr előtt, és bort és részegítő italt nem iszik, és már anyja méhétől fogva megtelik Szentlélekkel. ");
INSERT INTO hun_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","És Izrael fiai közül sokakat megtérít az Úrhoz, az ő Istenükhöz. ");
INSERT INTO hun_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","És maga is Isten előtt fog járni Illés lelkével és erejével, hogy az atyák szívét a gyermekekhez, és az engedetleneket az igazak lelkületére térítse, hogy az Úr számára felkészítse a népet.“ ");
INSERT INTO hun_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zakariás ezt mondta az angyalnak: „Miből tudhatom ezt meg? Mert én vén vagyok, és az én feleségem is igen idős.“ ");
INSERT INTO hun_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Az angyal így válaszolt neki: „Én vagyok Gábriel, aki Isten előtt állok. Ő küldött engem, hogy beszéljek veled, és ezt az örömhírt meghozzam neked. ");
INSERT INTO hun_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Íme, megnémulsz, és nem szólhatsz addig a napig, amelyen ezek megtörténnek, mert nem hittél az én beszédemnek, amelyek majd beteljesednek a maguk idejében.“ ");
INSERT INTO hun_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","A nép pedig várta Zakariást, és csodálkozott, hogy a templomban késlekedik. ");
INSERT INTO hun_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Amikor kijött, nem tudott szólni hozzájuk, és ebből megértették, hogy látomást látott a templomban, mert csak integetett nekik, és néma maradt. ");
INSERT INTO hun_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","És történt, hogy amikor leteltek szolgálatának napjai, elment haza. ");
INSERT INTO hun_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","E napok után felesége, Erzsébet fogant méhében, és öt hónapra elrejtőzött, és ezt mondta: ");
INSERT INTO hun_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","„Így cselekedett velem az Úr azokban a napokban, amelyekben rám tekintett, hogy elvegye szégyenemet az emberek előtt.“ ");
INSERT INTO hun_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","A hatodik hónapban Isten elküldte Gábriel angyalt Galileának Názáret nevű városába ");
INSERT INTO hun_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","egy szűzhöz, aki a Dávid házából való József nevű férfinak volt a jegyese. A szűznek Mária volt a neve. ");
INSERT INTO hun_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","És az angyal bement hozzá, és ezt mondta: „Üdvözlégy, kegyelembe fogadott! Az Úr veled van!“ ");
INSERT INTO hun_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ő pedig megdöbbent ezekre a szavakra, és elgondolkozott, hogy milyen köszöntés ez. ");
INSERT INTO hun_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Az angyal ezt mondta neki: „Ne félj, Mária, mert kegyelmet találtál Istennél! ");
INSERT INTO hun_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Íme, fogansz méhedben, és fiút szülsz, akit nevezz Jézusnak. ");
INSERT INTO hun_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ő nagy lesz, és a Magasságos Fiának nevezik, és neki adja az Úr Isten Dávidnak, az Ő atyjának királyi székét. ");
INSERT INTO hun_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","És uralkodik a Jákób házán örökké, és az Ő királyságának nem lesz vége!“ ");
INSERT INTO hun_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mária ezt mondta az angyalnak: „Hogyan lesz ez, hiszen nincs férjem?“ ");
INSERT INTO hun_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Így válaszolt neki az angyal: „A Szentlélek száll reád, és a Magasságos ereje árnyékoz be téged, ezért aki születik, Szentnek nevezik majd, Isten Fiának. ");
INSERT INTO hun_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Íme, a te rokonod, Erzsébet is fiút fogant öregségére, és már a hatodik hónapban van az, akit meddőnek mondtak, ");
INSERT INTO hun_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","mert Istennél semmi sem lehetetlen.“ ");
INSERT INTO hun_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mária ezt mondta: „Íme, az Úr szolgálóleánya, legyen úgy, ahogy mondtad.“ És akkor elment tőle az angyal. ");
INSERT INTO hun_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Azokban a napokban útra kelt Mária, és nagy sietséggel a hegyvidékre, Júda egyik városába ment. ");
INSERT INTO hun_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Bement Zakariás házába, és köszöntötte Erzsébetet. ");
INSERT INTO hun_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","És történt, hogy amikor Erzsébet meghallotta Mária köszöntését, a magzat megmozdult méhében, és Erzsébet megtelt Szentlélekkel, ");
INSERT INTO hun_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","és hangosan felkiáltott: „Áldott vagy te az asszonyok között, és áldott a te méhednek gyümölcse. ");
INSERT INTO hun_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","De hogyan történhet velem az, hogy az én Uramnak anyja jön hozzám? ");
INSERT INTO hun_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Mert íme, amikor köszöntésed szava eljutott fülembe, a magzat ujjongva megmozdult méhemben. ");
INSERT INTO hun_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","És boldog az, aki hitt, mert beteljesednek azok, amiket az Úr neki mondott.“ ");
INSERT INTO hun_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Akkor Mária ezt mondta: „Magasztalja az én lelkem az Urat, ");
INSERT INTO hun_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","és örvendez az én lelkem megtartó Istenemben. ");
INSERT INTO hun_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Mert rátekintett szolgálóleányának alázatos állapotára, mert íme, mostantól fogva boldognak mond engem minden nemzedék. ");
INSERT INTO hun_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Mert nagy dolgokat cselekedett velem a Hatalmas, és szent az ő neve. ");
INSERT INTO hun_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","És irgalma nemzedékről nemzedékre van azokon, akik őt félik. ");
INSERT INTO hun_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Hatalmas dolgot cselekedett karjával, szétszórta a szívük szándékában felfuvalkodottakat. ");
INSERT INTO hun_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Hatalmasokat döntött le trónjaikról, és felmagasztalta az alázatosokat. ");
INSERT INTO hun_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Éhezőket látott el javakkal, és gazdagokat küldött el üresen. ");
INSERT INTO hun_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Felkarolta Izraelnek, az ő szolgájának ügyét, mert megemlékezett irgalmasságáról ");
INSERT INTO hun_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Ábrahám és utódai iránt örökké – amint megmondta atyáinknak.“ ");
INSERT INTO hun_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mária Erzsébettel maradt három hónapig, aztán hazament. ");
INSERT INTO hun_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Amikor eljött Erzsébet szülésének ideje, fiút szült. ");
INSERT INTO hun_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","És meghallották szomszédai és rokonai, hogy az Úr kegyelmesen cselekedett vele, együtt örültek vele. ");
INSERT INTO hun_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","És történt a nyolcadik napon, eljöttek körülmetélni a gyermeket, és az ő atyja nevéről Zakariásnak akarták őt nevezni. ");
INSERT INTO hun_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Anyja azonban megszólalt, és ezt mondta: „Nem, hanem János legyen a neve.“ ");
INSERT INTO hun_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","És ezt mondták neki: „De hiszen senki sincs rokonságodban, akit így hívnának.“ ");
INSERT INTO hun_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","És intettek atyjának, hogy hogyan akarja nevezni. ");
INSERT INTO hun_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ő pedig egy táblát kért, és ezt írta rá: „János a neve.“ Erre mindenki elcsodálkozott. ");
INSERT INTO hun_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","És egyszerre megnyílt szája és nyelve, és beszélt, és áldotta Istent. ");
INSERT INTO hun_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Félelem szállta meg a szomszédokat, és Júdea egész hegyvidékén elhíresztelték mindezeket. ");
INSERT INTO hun_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Akik meghallották, szívükbe vésték, és ezt mondták: „Vajon mi lesz ebből a gyermekből?“ Az Úr keze vele volt. ");
INSERT INTO hun_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zakariás, az ő atyja megtelt Szentlélekkel, és így prófétált: ");
INSERT INTO hun_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","„Áldott az Úr, Izrael Istene, hogy meglátogatta és megváltotta az Ő népét, ");
INSERT INTO hun_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","és erős üdvözítőt támasztott nekünk az ő gyermekének, Dávidnak házában, ");
INSERT INTO hun_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","amint szólott a szent prófétáinak szája által örök időktől fogva, ");
INSERT INTO hun_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","hogy megszabadít ellenségeinktől, és mindazoknak kezéből, akik minket gyűlölnek; ");
INSERT INTO hun_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","hogy irgalmasságot cselekedjék a mi atyáinkkal, és megemlékezzék az ő szent szövetségéről, ");
INSERT INTO hun_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","az esküről, amellyel megesküdött Ábrahámnak, a mi atyánknak, hogy megadja nekünk, ");
INSERT INTO hun_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","hogy megszabadulva ellenségeink kezéből, félelem nélkül szolgáljunk Neki, ");
INSERT INTO hun_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","szentségben és igazságban őelőtte életünk minden napján. ");
INSERT INTO hun_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Te pedig, kisgyermek, a Magasságos prófétája leszel, mert az Úr előtt jársz, hogy útjait előkészítsd, ");
INSERT INTO hun_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","és az üdvösség ismeretére megtanítsd az ő népét a bűnök bocsánatával, ");
INSERT INTO hun_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","a mi Istenünknek nagy irgalmasságáért, amellyel meglátogatott minket a naptámadat a magasságból, ");
INSERT INTO hun_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","hogy világítson azoknak, akik a halál árnyékában ülnek, és igazgassa lábunkat a békesség útjára.“ ");
INSERT INTO hun_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","A kisgyermek pedig növekedett és erősödött lélekben, és a pusztában volt egészen addig a napig, amelyen nyilvánosan föl nem lépett Izraelben. ");
INSERT INTO hun_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Történt pedig azokban a napokban, hogy Augustus császár parancsolatot adott ki, hogy írják össze az egész földet. ");
INSERT INTO hun_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ez az összeírás először akkor történt, amikor Szíriában Cirénius volt a helytartó. ");
INSERT INTO hun_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Mindenki elment tehát a maga városába, hogy összeírják. ");
INSERT INTO hun_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","József is elment Galileából, Názáret városából Júdeába, Dávid városába, amelynek neve Betlehem, mivel Dávid házából és nemzetségéből való volt, ");
INSERT INTO hun_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","hogy összeírják Máriával, aki jegyese volt, és aki várandós volt. ");
INSERT INTO hun_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","És történt, amikor ott voltak, eljött szülésének ideje. ");
INSERT INTO hun_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","És megszülte elsőszülött fiát, és bepólyálta, és jászolba fektette, mert nem volt helyük a vendégfogadóban. ");
INSERT INTO hun_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Pásztorok voltak azon a vidéken, akik kinn a mezőn tanyáztak, és éjszaka is őrködtek nyájuk mellett. ");
INSERT INTO hun_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","És íme, az Úr angyala hozzájuk jött, és az Úr dicsősége körülvette őket, és nagy félelem vett erőt rajtuk. ");
INSERT INTO hun_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Az angyal pedig ezt mondta nekik: „Ne féljetek! Íme, nagy örömöt hirdetek nektek, amely az egész népnek öröme lesz. ");
INSERT INTO hun_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Mert Megtartó született ma nektek, aki az Úr Krisztus, a Dávid városában. ");
INSERT INTO hun_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ez pedig nektek a jel: egy kisgyermeket találtok bepólyálva feküdni a jászolban.“ ");
INSERT INTO hun_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","És hirtelen az angyallal mennyei seregek sokasága jelent meg, akik Istent dicsérték, és ezt mondták: ");
INSERT INTO hun_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","„Dicsőség a magasságban Istennek, és a földön békesség, és az emberekhez jóakarat!“ ");
INSERT INTO hun_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","És történt, hogy amikor elmentek tőlük az angyalok a mennybe, a pásztorok ezt mondták egymásnak: „Menjünk el egészen Betlehemig, és lássuk meg, ami történt, amit az Úr tudtul adott nekünk.“ ");
INSERT INTO hun_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Elmentek azért nagy sietséggel, és megtalálták Máriát és Józsefet és a kisgyermeket, aki a jászolban feküdt. ");
INSERT INTO hun_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ezt látva elbeszélték azt, amit a gyermekről hallottak. ");
INSERT INTO hun_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Mindenki, aki hallotta, elcsodálkozott azon, amit a pásztorok mondtak. ");
INSERT INTO hun_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mária pedig megőrizte, és szívében forgatta a hallottakat. ");
INSERT INTO hun_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","A pásztorok pedig visszatértek, dicsőítették és dicsérték Istent mindazért, amit hallottak és láttak, úgy, ahogy az megmondatott nekik. ");
INSERT INTO hun_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Amikor a nyolc nap elmúlt, hogy a kisgyermeket körülmetéljék, Jézusnak nevezték, ahogy az angyal nevezte mielőtt még anyja méhében megfogant. ");
INSERT INTO hun_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Amikor Mózes törvénye szerint leteltek Mária tisztulásának napjai, felvitték Jézust Jeruzsálembe, hogy bemutassák az Úrnak. ");
INSERT INTO hun_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ahogyan meg van írva az Úr törvényében, hogy minden elsőszülött fiú az Úrnak legyen szentelve, ");
INSERT INTO hun_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","és hogy áldozatot mutassanak be az Úr törvénye szerint: „Egy pár gerlicét vagy két galambfiókát.“ ");
INSERT INTO hun_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","És íme, volt Jeruzsálemben egy ember, akinek a neve Simeon volt, és ez az ember igaz és istenfélő volt, és várta Izrael vigasztalását, és a Szentlélek volt rajta. ");
INSERT INTO hun_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Azt a kinyilatkoztatást kapta a Szentlélektől, hogy addig nem hal meg, amíg meg nem látja az Úrnak Krisztusát. ");
INSERT INTO hun_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","A Lélek indításából a templomba ment, és amikor a gyermek Jézust szülei bevitték, hogy érte a törvény előírása szerint cselekedjenek, ");
INSERT INTO hun_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","karjába vette, és áldotta Istent, és ezt mondta: ");
INSERT INTO hun_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","„Mostan bocsátod el, Uram, a te szolgádat beszéded szerint békességben, ");
INSERT INTO hun_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","mert látták az én szemeim a te üdvösségedet, ");
INSERT INTO hun_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","amelyet készítettél minden nép szeme láttára, ");
INSERT INTO hun_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","világosságul a pogányok megvilágosítására, és a te népednek, Izraelnek dicsőségére.“ ");
INSERT INTO hun_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","József pedig és az ő anyja csodálkozott azokon, amiket őfelőle mondott. ");
INSERT INTO hun_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","És Simeon megáldotta őket, és ezt mondta Máriának, az ő anyjának: „Íme, ő sokak elbukására és felemelésére rendeltetett Izraelben, és jel lesz, amelynek sokan ellene mondanak, ");
INSERT INTO hun_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","még a te lelkedet is éles tőr járja majd át, hogy sok szív gondolata nyilvánvalóvá legyen.“ ");
INSERT INTO hun_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Volt egy prófétanő is, Anna, Fánuel leánya, Áser nemzetségéből. Nagyon előrehaladott korú volt, hajadon kora után csak hét esztendeig élt férjével. ");
INSERT INTO hun_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Már nyolcvannégy esztendeje özvegy volt. Nem távozott el a templomból, mert böjtöléssel és imádkozással szolgált éjjel és nappal. ");
INSERT INTO hun_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ugyanabban az órában odalépett, hálát adott az Úrnak, és beszélt róla mindenkinek, akik Jeruzsálemben a megváltást várták. ");
INSERT INTO hun_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Amikor mindent elvégeztek az Úr törvénye szerint, visszatértek Galileába, városukba, Názáretbe. ");
INSERT INTO hun_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","A kisgyermek pedig növekedett és erősödött lélekben, megtelt bölcsességgel és az Isten kegyelme volt rajta. ");
INSERT INTO hun_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Szülei évenként felmentek Jeruzsálembe húsvét ünnepére. ");
INSERT INTO hun_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Amikor tizenkét esztendős lett, szintén fölmentek Jeruzsálembe az ünnepi szokás szerint. ");
INSERT INTO hun_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Miután elteltek az ünnepnapok, hazaindultak. A gyermek Jézus azonban Jeruzsálemben maradt, de sem József, sem az anyja nem vette észre. ");
INSERT INTO hun_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Azt gondolták, hogy az útitársaik között van. Egynapi járóföldet mentek, és akkor kezdték keresni a rokonok és ismerősök között. ");
INSERT INTO hun_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Amikor nem találták, visszamentek Jeruzsálembe, hogy megkeressék. ");
INSERT INTO hun_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","És történt, hogy harmadnapra találták meg a templomban, a tanítómesterek között ülve, amint hallgatta és kérdezgette őket. ");
INSERT INTO hun_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Mindnyájan, akik őt hallgatták, elcsodálkoztak értelmén és feleletein. ");
INSERT INTO hun_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Amikor szülei meglátták, elcsodálkoztak, és anyja ezt mondta neki: „Fiam, miért tetted ezt velünk? Íme, atyád és én nagy bánattal kerestünk téged.“ ");
INSERT INTO hun_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ő pedig ezt mondta nekik: „Miért kerestetek engem? Vagy nem tudjátok, hogy nekem az én Atyám dolgaival kell foglalkoznom?“ ");
INSERT INTO hun_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","De ők nem értették, amit mondott nekik. ");
INSERT INTO hun_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Jézus ezután elment velük Názáretbe, és engedelmeskedett nekik. Anyja szívében megőrizte mindezeket. ");
INSERT INTO hun_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jézus pedig gyarapodott bölcsességben, testben és az Isten és emberek előtti kedvességben. ");
INSERT INTO hun_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Tibérius császár uralkodásának tizenötödik esztendejében pedig, amikor Júdeában Poncius Pilátus volt a helytartó, és Galileának negyedes fejedelme Heródes volt, Iturea, Trakhónitisz tartományának pedig negyedes fejedelme az ő testvére, Fülöp volt, Abiléné negyedes fejedelme pedig Lüszániász volt. ");
INSERT INTO hun_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Annás és Kajafás főpapsága idején szólt az Úr Jánoshoz, Zakariás fiához a pusztában. ");
INSERT INTO hun_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Az elment a Jordán mellett lévő tartományokba, prédikálva a megtérés keresztségét a bűnök bocsánatára, ");
INSERT INTO hun_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","ahogyan meg van írva Ézsaiás próféta beszédeinek könyvében, aki ezt mondja: „Kiáltó szava szól a pusztában: Készítsétek el az Úrnak útját, egyengessétek ösvényeit. ");
INSERT INTO hun_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Minden szakadékot töltsetek fel, minden hegyet és halmot hordjatok el, ami egyenetlen, legyen egyenessé, és a göröngyös simává, ");
INSERT INTO hun_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","és meglátja minden halandó Isten szabadítását.“ ");
INSERT INTO hun_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ezt mondta tehát a sokaságnak, amely kiment hozzá, hogy megkeresztelje: „Viperák fajzata! Ki figyelmeztetett titeket, hogy a közelgő harag elől elmeneküljetek? ");
INSERT INTO hun_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Teremjetek azért megtéréshez méltó gyümölcsöket, és ne mondogassátok magatokban: Ábrahám a mi atyánk! Mert mondom nektek, hogy Isten ezekből a kövekből is tud fiakat támasztani Ábrahámnak. ");
INSERT INTO hun_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","A fejsze pedig már ott van a fák gyökerén: kivágnak, és tűzre vetnek minden fát, amely nem terem jó gyümölcsöt.“ ");
INSERT INTO hun_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","A sokaság megkérdezte tőle: „Mit cselekedjünk tehát?“ ");
INSERT INTO hun_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ő így felelt nekik: „Akinek két köntöse van, egyiket adja annak, akinek nincs, és akinek van ennivalója, hasonlóan cselekedjék.“ ");
INSERT INTO hun_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","És eljöttek a vámszedők is, hogy megkeresztelkedjenek, és ezt mondták neki: „Mester, mit cselekedjünk?“ ");
INSERT INTO hun_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ő pedig nekik ezt mondta: „Semmi többet ne követeljetek, mint amennyi ki van szabva.“ ");
INSERT INTO hun_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","És megkérdezték őt a katonák is. „Hát mi mit cselekedjünk?“ Nekik ezt felelte: „Senkit ne bántalmazzatok, ne zsaroljatok, és elégedjetek meg zsoldotokkal.“ ");
INSERT INTO hun_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Amikor a nép várt, szívükben azon gondolkoztak, hogy vajon nem János-e a Krisztus? ");
INSERT INTO hun_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","János így válaszolt mindenkinek: „Én ugyan vízzel keresztellek titeket, de eljön, aki nálam erősebb, és nem vagyok méltó, hogy saruja szíját megoldjam. Ő majd Szentlélekkel és tűzzel keresztel titeket. ");
INSERT INTO hun_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Szórólapátja a kezében van, és megtisztítja szérűjét, és a gabonát a csűrébe gyűjti, a polyvát pedig megégeti olthatatlan tűzzel.“ ");
INSERT INTO hun_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Még sok egyébre is intette őket, és hirdette az evangéliumot a népnek. ");
INSERT INTO hun_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Amikor pedig Heródest, a negyedes fejedelmet megfeddte Heródiásért, testvérének, Fülöpnek feleségéért és minden gonosz tettéért, amiket Heródes cselekedett, ");
INSERT INTO hun_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","ő még mindezt azzal tetézte, hogy Jánost tömlöcbe vetette. ");
INSERT INTO hun_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Történt pedig, hogy amikor az egész nép megkeresztelkedett, és Jézus is megkeresztelkedett és imádkozott, megnyílt az ég, ");
INSERT INTO hun_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","és leszállt rá a Szentlélek testi formában, mint egy galamb, és szózat jött a mennyből: „Ez az én szeretett fiam, akiben gyönyörködöm!“ ");
INSERT INTO hun_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jézus mintegy harmincesztendős volt, amikor tanítani kezdett, aki, amint állították, József fia volt, ő pedig Élié; ");
INSERT INTO hun_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ez Mattáté, ez Lévié, ez Melkié, ez Jannájé, ez Józsefé, ");
INSERT INTO hun_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ez Mattatiásé, ez Ámósé, ez Náhumé, ez Heszlié, ez Naggaié, ");
INSERT INTO hun_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","ez Mahaté, ez Mattatiásé, ez Simeié, ez Jószeké, ez Jódáé; ");
INSERT INTO hun_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ez Jóhánáné, ez Résáé, ez Zerubbábelé, ez Sealtielé, ez Nérié, ");
INSERT INTO hun_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","ez Melkié, ez Addié, ez Kószámé, ez Elmadámé, ez Éré; ");
INSERT INTO hun_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ez Jézusé, ez Eliézeré, ez Jórimé, ez Mattáté, ez Lévié, ");
INSERT INTO hun_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","ez Simeoné, ez Júdáé, ez Józsefé, ez Jónámé, ez Eljákimé; ");
INSERT INTO hun_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ez Meleáé, ez Mennáé, ez Mattátáé, ez Nátáné, ez Dávidé, ");
INSERT INTO hun_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ez Isaié, ez Óbédé, ez Bóázé, ez Szalmóné, ez Nahsóné, ");
INSERT INTO hun_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","ez Aminádábé, ez Adminé, ez Arnié, ez Heszróné, ez Fáreszé, ez Júdáé, ");
INSERT INTO hun_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ez Jákóbé, ez Izsáké, ez Ábrahámé, ez Táréé, ez Náhoré, ");
INSERT INTO hun_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","ez Szerugé, ezt Reué, ez Pelegé, ez Héberé, ez Selahé, ");
INSERT INTO hun_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ez Kénáné, ez Arpaksádé, ez Sémé, ez Nóéé, ez Lámeké; ");
INSERT INTO hun_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ez Metusélahé, ez Hénóké, ez Járedé, ez Mahalalélé, ez Kénáné, ");
INSERT INTO hun_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","ez Enósé, ez Sété, ez Ádámé; ez pedig Istené. ");
INSERT INTO hun_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jézus Szentlélekkel telve visszatért a Jordántól, és a Lélek indítására a pusztában volt ");
INSERT INTO hun_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","negyven napig, miközben kísértette az ördög. Nem evett semmit azokban a napokban, de amikor azok elmúltak, megéhezett. ");
INSERT INTO hun_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","És az ördög ezt mondta neki: „Ha Isten Fia vagy, mondd ennek a kőnek, hogy változzék kenyérré.“ ");
INSERT INTO hun_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jézus így válaszolt neki: „Meg van írva, hogy »nemcsak kenyérrel él az ember, hanem Istennek minden igéjével.«“ ");
INSERT INTO hun_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Majd felvitte őt az ördög egy nagy, magas hegyre, megmutatta neki egy szempillantás alatt a föld minden országát, ");
INSERT INTO hun_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","és ezt mondta neki: „Neked adom mindezt a hatalmat és ezek dicsőségét, mert nekem adatott, és annak adom, akinek akarom. ");
INSERT INTO hun_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Azért, ha engem imádsz, mindez a tied lesz.“ ");
INSERT INTO hun_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jézus így válaszolt neki: „Távozz tőlem, sátán! Meg van írva: »Az Urat, a te Istenedet imádd, és csak neki szolgálj!«“ ");
INSERT INTO hun_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Aztán Jeruzsálembe vitte őt, és a templom párkányára állította, és ezt mondta neki: „Ha Isten Fia vagy, vesd le magad innen, ");
INSERT INTO hun_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","mert meg van írva: »Az ő angyalainak megparancsolta, hogy őrizzenek téged, ");
INSERT INTO hun_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","és tenyerükön hordozzanak, hogy kőbe ne üsd lábadat.«“ ");
INSERT INTO hun_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jézus így válaszolt neki: „Megmondatott: »Ne kísértsd az Urat, a te Istenedet!«“ ");
INSERT INTO hun_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Amikor az ördög minden kísértést elvégzett, eltávozott tőle egy időre. ");
INSERT INTO hun_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jézus visszatért a Lélek erejével Galileába, és híre ment az egész környéken. ");
INSERT INTO hun_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Tanított a zsinagógáikban, és mindenki dicsőítette. ");
INSERT INTO hun_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Amikor Názáretbe ment, ahol felnevelkedett, szokása szerint szombatnapon a zsinagógába ment, és felállt felolvasni. ");
INSERT INTO hun_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ézsaiás próféta könyvét adták neki, és amikor kinyitotta a könyvet, felkereste azt a helyet, ahol ez volt megírva: ");
INSERT INTO hun_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","„Az Úr Lelke van rajtam, mert felkent engem, hogy a szegényeknek az evangéliumot hirdessem, elküldött, hogy a megtört szívűeket meggyógyítsam, hogy a foglyoknak szabadulást hirdessek, és a vakoknak szemük megnyílását, hogy szabadon bocsássam az elnyomottakat, ");
INSERT INTO hun_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","hogy hirdessem az Úr kedves esztendejét!“ ");
INSERT INTO hun_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","És behajtva a könyvet, visszaadta a szolgának, és leült. A zsinagógában mindenkinek a szeme rajta függött. ");
INSERT INTO hun_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ő pedig így szólt hozzájuk: „Ma teljesedett be ez az Írás fületek hallatára!“ ");
INSERT INTO hun_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","És mindnyájan bizonyságot tettek róla, és álmélkodtak a kegyelem igéin, amelyek ajkáról fakadtak, és ezt mondták: „Nem József fia ez?“ ");
INSERT INTO hun_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ő ezt mondta nekik: „Bizonyára azt a közmondást mondjátok nekem: Orvos, gyógyítsd meg magad! Amit hallottunk, hogy Kapernaumban történt, itt a te házadban is cselekedd meg!“ ");
INSERT INTO hun_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Majd így folytatta: „Bizony mondom nektek, hogy egy próféta sem elfogadott a maga hazájában. ");
INSERT INTO hun_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Igazán mondom nektek: Illés idejében sok özvegyasszony volt Izraelben, amikor az ég három esztendeig és hat hónapig be volt zárva, úgyhogy az egész tartományban nagy éhség volt, ");
INSERT INTO hun_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","és közülük senkihez sem küldetett Illés, csak a szidóni Sareptába az özvegyasszonyhoz. ");
INSERT INTO hun_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Elizeus próféta idejében sok bélpoklos volt Izraelben, de azok közül egy sem tisztult meg, csak a szír Naamán.“ ");
INSERT INTO hun_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ennek hallatán harag töltött el mindenkit a zsinagógában. ");
INSERT INTO hun_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Felkeltek, kiűzték őt a városon kívül, és annak a hegynek a szélére vitték, amelyen az ő városuk épült, hogy onnan letaszítsák. ");
INSERT INTO hun_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ő azonban átment közöttük, és eltávozott. ");
INSERT INTO hun_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Elment Kapernaumba, Galilea városába, és tanította őket szombatnapon. ");
INSERT INTO hun_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Azok csodálkoztak a tanításán, mert szavának hatalma volt. ");
INSERT INTO hun_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","A zsinagógában pedig volt egy tisztátalan ördögi lélektől megszállt ember, aki fennhangon így kiáltott: ");
INSERT INTO hun_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","„Mi közünk hozzád názáreti Jézus? Azért jöttél, hogy elpusztíts minket. Ismerlek téged, hogy ki vagy: az Isten Szentje!“ ");
INSERT INTO hun_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jézus rászólt: „Némulj meg, és menj ki belőle!“ És az ördög középre vetette, kiment belőle, és nem ártott neki semmit. ");
INSERT INTO hun_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Mindnyájukat félelem szállta meg, és így szóltak egymáshoz: „Milyen beszéd ez, hogy hatalommal és erővel parancsol a tisztátalan lelkeknek, és azok kimennek?“ ");
INSERT INTO hun_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","És elterjedt a híre mindenütt a környéken. ");
INSERT INTO hun_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","A zsinagógából eltávozva Simon házába ment. Simon anyósa pedig nagy lázban feküdt, és szóltak neki érdekében. ");
INSERT INTO hun_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jézus mellé állt, ráparancsolt a lázra, és az elhagyta őt. Ő pedig azonnal felkelt, és szolgált nekik. ");
INSERT INTO hun_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Napnyugtakor mindenki hozzá vitte különféle bajban szenvedő betegét, ő pedig mindegyikre rátette kezét, meggyógyította őket. ");
INSERT INTO hun_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Sokakból ördögök is kimentek, és ezt kiáltozták: „Te vagy a Krisztus, az Isten Fia!“ De ő rájuk parancsolt, nem engedte őket szólni, mivel tudták, hogy ő a Krisztus. ");
INSERT INTO hun_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Napfölkeltekor elindult, és egy puszta helyre ment. De a sokaság megkereste őt, hozzá mentek, marasztalták, hogy ne menjen el tőlük. ");
INSERT INTO hun_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ő pedig ezt mondta nekik: „Más városokban is hirdetnem kell Isten országát, mert ez a küldetésem.“ ");
INSERT INTO hun_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","És prédikált Galilea zsinagógáiban. ");
INSERT INTO hun_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Történt, hogy amikor a sokaság hozzá tódult, hogy hallgassa Isten beszédét, ő a Genezáret-tónál állt, ");
INSERT INTO hun_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","és látott két hajót állni a vízen. A halászok pedig, miután azokból kiszálltak, a hálóikat mosták. ");
INSERT INTO hun_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Beszállt az egyik hajóba, amely Simoné volt, és kérte őt, hogy vigye egy kissé beljebb a parttól. Amikor leült, a hajóból tanította a sokaságot. ");
INSERT INTO hun_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Miután befejezte beszédét, ezt mondta Simonnak: „Evezz a mélyre, és vessétek ki hálóitokat fogásra!“ ");
INSERT INTO hun_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simon így felelt: „Mester, jóllehet egész éjszaka fáradtunk, mégsem fogtunk semmit, de a te parancsodra kivetem a hálót.“ ");
INSERT INTO hun_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Amikor ezt megtették, a halaknak olyan sokaságát kerítették be, hogy szakadozott a hálójuk. ");
INSERT INTO hun_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ezért intettek társaiknak, akik a másik hajóban voltak, hogy jöjjenek, és segítsenek nekik. Azok odamentek, és megtöltötték mind a két hajót annyira, hogy csaknem elsüllyedtek. ");
INSERT INTO hun_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Amikor ezt Simon Péter látta, Jézus lába elé borult, és ezt mondta: „Eredj el tőlem, mert én bűnös ember vagyok, Uram!“ ");
INSERT INTO hun_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Mert félelem fogta el őt és mindazokat, aki vele voltak, a halfogás miatt. ");
INSERT INTO hun_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Hasonlóképpen Jakabot és Jánost is, Zebedeus fiait, akik Simonnak társai voltak. Jézus ezt mondta Simonnak: „Ne félj, mostantól fogva embereket fogsz.“ ");
INSERT INTO hun_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","És a hajókat a szárazra vonták, elhagyták mindenüket, és követték őt. ");
INSERT INTO hun_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Történt, hogy amikor az egyik városban volt, íme, volt ott egy leprával borított ember, és amikor meglátta Jézust, arcra borulva kérte őt, és ezt mondta: „Uram, ha akarod, megtisztíthatsz engem!“ ");
INSERT INTO hun_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jézus pedig kinyújtotta kezét, megérintette őt, és ezt mondta: „Akarom, tisztulj meg!“ És azonnal letisztult róla a lepra. ");
INSERT INTO hun_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","És megparancsolta neki, hogy ezt senkinek se mondja el, hanem: „Menj el, mutasd meg magad a papnak, és vigyél áldozatot megtisztulásodért, amint Mózes megparancsolta, bizonyságul nekik.“ ");
INSERT INTO hun_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","De a hír annál jobban elterjedt róla, és nagy sokaság gyűlt össze, hogy őt hallgassák, és hogy meggyógyítsa betegségüket. ");
INSERT INTO hun_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ő azonban félrevonult a pusztába, és imádkozott. ");
INSERT INTO hun_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","És történt egy napon, hogy tanított, és ott ültek a farizeusok és a törvénytudók, akik Galileának és Júdeának falvaiból és Jeruzsálemből jöttek, az Úr hatalma volt vele, hogy gyógyítson. ");
INSERT INTO hun_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","És íme, férfiak ágyon hoztak egy embert, aki béna volt, és igyekezték bevinni és elé tenni. ");
INSERT INTO hun_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","A sokaság miatt azonban nem találták módját, hogyan vigyék be, felmentek a háztetőre, és a cseréptetőn át bocsátották le ágyastól a középre, Jézus elé. ");
INSERT INTO hun_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ő pedig látva hitüket, így szólt: „Ember, megbocsátattak neked a te bűneid!“ ");
INSERT INTO hun_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Az írástudók és farizeusok elkezdtek tanakodni: „Kicsoda ez, aki ilyen káromlást szól? Ki bocsáthatja meg a bűnöket, ha nem egyedül Isten?“ ");
INSERT INTO hun_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jézus felismerte gondolataikat, ezt mondta nekik: „Miért tanakodtok szívetekben? ");
INSERT INTO hun_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Mi könnyebb, azt mondani: megbocsátattak neked a te bűneid, vagy azt mondani: kelj fel és járj? ");
INSERT INTO hun_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Hogy pedig megtudjátok, hogy az Emberfiának van hatalma e földön megbocsátani a bűnöket (ezt mondta a bénának): Neked mondom, kelj fel, vedd fel az ágyadat, eredj haza!“ ");
INSERT INTO hun_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","És az szemük láttára felkelt, felvette, amin feküdt, és elment haza, dicsőítve Istent. ");
INSERT INTO hun_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ámulat fogta el mindnyájukat, dicsőítették Istent, és megteltek félelemmel, és ezt mondták: „Bizony csodálatos dolgokat láttunk ma!“ ");
INSERT INTO hun_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ezután kiment, és meglátott egy Lévi nevű vámszedőt, aki a vámnál ült, és ezt mondta neki: „Kövess engem!“ ");
INSERT INTO hun_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Az otthagyva mindent, felkelt, és követte őt. ");
INSERT INTO hun_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","És Lévi nagy vendégséget készített neki házában. Vámosoknak és másoknak sokasága volt ott, akik velük együtt asztalhoz telepedtek. ");
INSERT INTO hun_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Az írástudók és farizeusok pedig zúgolódtak, és a tanítványainak ezt mondták: „Miért esztek és isztok a vámszedőkkel és bűnösökkel együtt?“ ");
INSERT INTO hun_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jézus így válaszolt nekik: „Az egészségeseknek nincs szükségük orvosra, hanem a betegeknek. ");
INSERT INTO hun_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nem azért jöttem, hogy az igazakat hívjam megtérésre, hanem a bűnösöket.“ ");
INSERT INTO hun_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Azok pedig ezt mondták neki: „Mi az oka, hogy János tanítványai gyakran böjtölnek és imádkoznak, hasonlóképpen a farizeusoké is, a te tanítványaid pedig esznek és isznak?“ ");
INSERT INTO hun_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ő pedig ezt mondta nekik: „Rávehetitek-e a lakodalmasokat, hogy böjtöljenek, míg velük van a vőlegény? ");
INSERT INTO hun_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","De jönnek majd napok, amikor a vőlegény elvétetik tőlük, és akkor azokban a napokban böjtölnek majd.“ ");
INSERT INTO hun_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Egy példázatot is mondott nekik: „Senki sem tép ki új ruhából foltot, hogy a régi ruhára varrja, mert így az újat is eltépi, és nem is illene a régi ruhához az új folt. ");
INSERT INTO hun_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","És senki sem tölti az új bort régi tömlőbe, mert az új bor kiszakítja a tömlőket, és a bor kiömlik, és a tömlők is tönkremennek. ");
INSERT INTO hun_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Hanem az új bort új tömlőkbe kell tölteni, és akkor mindkettő megmarad. ");
INSERT INTO hun_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Aki pedig óbort iszik, az nem kíván újat, mert azt mondja: Jobb az ó.“ ");
INSERT INTO hun_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Történt pedig a húsvét szombatját követő második szombaton, hogy vetések között ment át, és az ő tanítványai kalászokat tépdestek, és azokat kezükkel kimorzsolva ették. ");
INSERT INTO hun_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Némelyek pedig a farizeusok közül ezt mondták nekik: „Miért cselekszitek azt, amit szombatnapon nem szabad cselekedni?“ ");
INSERT INTO hun_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jézus így válaszolt nekik: „Nem olvastátok, hogy mit cselekedett Dávid, amikor megéhezett, és azok is, akik vele voltak? ");
INSERT INTO hun_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Bement az Úr házába, és elvette a szent kenyereket, és evett, és adott azoknak is, akik vele voltak, pedig azokat nem lett volna szabad megenni, csak a papoknak.“ ");
INSERT INTO hun_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Így szólt hozzájuk: „Az Emberfia ura a szombatnak is.“ ");
INSERT INTO hun_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Történt egy másik szombaton, hogy a zsinagógába ment, és tanított. Volt ott egy ember, akinek a jobb keze béna volt. ");
INSERT INTO hun_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Az írástudók és farizeusok leselkedtek utána, hogy vajon gyógyít-e szombatnapon, hogy vádat találjanak ellene. ");
INSERT INTO hun_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ő pedig ismerve gondolataikat, ezt mondta a béna kezű embernek: „Kelj fel, és állj középre!“ Az felkelt, és középre állt. ");
INSERT INTO hun_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Jézus ezt mondta nekik: „Valamit kérdezek tőletek: Szabad-e szombaton jót tenni vagy rosszat tenni, életet megmenteni vagy elpusztítani?“ ");
INSERT INTO hun_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Végignézett rajtuk, és így szólt hozzá: „Nyújtsd ki a kezedet!“ Az pedig úgy tett, és a keze olyan éppé lett, mint a másik. ");
INSERT INTO hun_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Azokat pedig esztelen düh szállta meg, és arról beszélgettek, hogy mit tegyenek Jézussal. ");
INSERT INTO hun_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Történt azokban a napokban, hogy kiment a hegyre imádkozni, és az éjszakát Istenhez imádkozva töltötte el. ");
INSERT INTO hun_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Amikor megvirradt, odahívta tanítványait, és kiválasztott azok közül tizenkettőt, akiket apostoloknak nevezett el. ");
INSERT INTO hun_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simont, akit Péternek nevezett, és Andrást, annak testvérét, Jakabot és Jánost, Fülöpöt és Bertalant, ");
INSERT INTO hun_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mátét, Tamást, Jakabot, az Alfeus fiát és Simont, akit Zélótának neveztek, ");
INSERT INTO hun_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Júdást, a Jakab fiát és Iskáriótest, aki árulóvá lett. ");
INSERT INTO hun_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Aztán lement velük, megállt a síkságon, és vele együtt tanítványainak sokasága és a nép nagy tömege egész Júdeából és Jeruzsálemből, és Tírusznak és Szidónnak tengermellékéről. Ezek azért jöttek, hogy hallgassák őt, és meggyógyítsa őket betegségeikből. ");
INSERT INTO hun_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Akiket tisztátalan lelkek gyötörtek, meggyógyultak. ");
INSERT INTO hun_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Az egész sokaság igyekezett őt megérinteni, mert erő áradt ki belőle, és mindenkit meggyógyított. ");
INSERT INTO hun_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ő pedig tanítványaira nézett, és ezt mondta: „Boldogok vagytok, ti szegények, mert tiétek Isten országa. ");
INSERT INTO hun_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Boldogok vagytok, akik most éheztek, mert megelégíttettek. Boldogok vagytok, akik most sírtok, mert nevetni fogtok. ");
INSERT INTO hun_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Boldogok lesztek, amikor gyűlölnek titeket az emberek, és kiközösítenek, és szidalmaznak titeket, és kitörlik neveteket, mint gonosz nevet az Emberfiáért. ");
INSERT INTO hun_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Örüljetek azon a napon, és örvendezzetek, mert íme, jutalmatok bőséges lesz a mennyben, hiszen hasonlóképpen cselekedtek a prófétákkal az ő atyáik. ");
INSERT INTO hun_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","De jaj nektek, gazdagok, mert megkaptátok már vigasztalásotokat. ");
INSERT INTO hun_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Jaj nektek, akik most jóllaktatok, mert éhezni fogtok. Jaj nektek, akik most nevettek, mert sírni és jajgatni fogtok. ");
INSERT INTO hun_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Jaj nektek, amikor minden ember jót mond rólatok, mert éppen így cselekedtek a hamis prófétákkal az ő atyáik. ");
INSERT INTO hun_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","„Nektek azonban, akik engem hallgattok, ezt mondom: Szeressétek ellenségeiteket, jót tegyetek azokkal, akik titeket gyűlölnek. ");
INSERT INTO hun_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Áldjátok azokat, aki titeket átkoznak, és imádkozzatok azokért, akik titeket bántalmaznak. ");
INSERT INTO hun_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Aki egyik arcodat megüti, annak fordítsd oda a másikat is. Aki felsőruhádat elveszi, attól alsóruhádat se tagadd meg. ");
INSERT INTO hun_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Mindenkinek, aki kér tőled, annak adj, és attól, aki elveszi a tiédet, ne kérd vissza. ");
INSERT INTO hun_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","És amint akarjátok, hogy az emberek veletek cselekedjenek, ti is úgy cselekedjetek azokkal. ");
INSERT INTO hun_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Ha csak azokat szeretitek, akik titeket szeretnek, milyen jót tettetek? Hiszen a bűnösök is szeretik azokat, akik őket szeretik. ");
INSERT INTO hun_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","És ha csak azokkal tesztek jót, akik veletek jót tesznek, mi jót tettetek? ");
INSERT INTO hun_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","És ha csak azoknak adtok kölcsön, akiktől remélitek, hogy visszakapjátok, mi jót tettetek? Hiszen a bűnösök is adnak kölcsönt a bűnösöknek, hogy ugyanannyit kapjanak vissza. ");
INSERT INTO hun_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ti azonban szeressétek ellenségeiteket, és tegyetek jót, és adjatok kölcsön, érte semmit sem várva, és a ti jutalmatok sok lesz, és a magasságos Isten fiai lesztek, mert ő is jóságos a hálátlanokhoz és gonoszokhoz. ");
INSERT INTO hun_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Legyetek azért irgalmasok, amint a ti Atyátok is irgalmas. ");
INSERT INTO hun_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","„Ne ítéljetek, hogy meg ne ítéljenek. Ne kárhoztassatok, és nem lesz kárhoztatásotok. Bocsássatok meg, és nektek is megbocsátanak. ");
INSERT INTO hun_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Adjatok, és adnak majd nektek is: jó, megnyomott, megrázott, színig telt mértékkel adnak öletekbe. Mert azzal a mértékkel mérnek nektek, amellyel ti is mértek.“ ");
INSERT INTO hun_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Példázatot is mondott nekik: „Vajon a vak vezethet-e világtalant? Nem esnek-e mindketten a verembe? ");
INSERT INTO hun_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Nem különb a tanítvány az ő mesterénél. Csak ha mindent megtanult, akkor lesz olyan, mint a mestere. ");
INSERT INTO hun_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Miért nézed pedig a szálkát, amely a te atyádfia szemében van, a gerendát pedig, ami a te saját szemedben van, nem veszed észre? ");
INSERT INTO hun_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Hogyan mondhatod a te atyádfiának: Atyámfia, hadd vegyem ki a szálkát a te szemedből, holott a te szemedben lévő gerendát nem látod? Te képmutató, vedd ki először a gerendát a te szemedből, és azután gondolj arra, hogy kivedd a szálkát, amely a te atyádfia szemében van. ");
INSERT INTO hun_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","„Nem jó fa az, amely rossz gyümölcsöt terem. És nem rossz fa az, amely jó gyümölcsöt terem. ");
INSERT INTO hun_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Mert minden fát saját gyümölcséről lehet megismerni. Mert tövisről nem szednek fügét, sem a szederről nem szednek szőlőt. ");
INSERT INTO hun_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","A jó ember szívének jó kincseiből hoz elő jót. A gonosz ember pedig szívének gonosz kincséből hoz elő gonoszt. Mert amivel csordultig van a szív, azt szólja a száj. ");
INSERT INTO hun_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Miért mondjátok nekem: Uram, Uram, ha nem teszitek azt, amit mondok? ");
INSERT INTO hun_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","„Ha valaki hozzám jön, és hallgatja az én beszédemet, és azokat megtartja, megmondom, kihez hasonló. ");
INSERT INTO hun_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Hasonló ahhoz a házépítő emberhez, aki leásott, és mélyre hatolt, és kősziklára alapozott: amikor aztán jött az árvíz, beleütközött az áradat abba a házba, de azt meg nem mozdíthatta, mert kősziklára épült. ");
INSERT INTO hun_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Aki pedig hallgatja beszédemet, de nem tartja meg, az hasonló ahhoz az emberhez, aki csak a földre építette házát fundamentum nélkül: beleütközött az áradat, és azonnal összeomlott, és romhalmazzá lett.“ ");
INSERT INTO hun_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Miután befejezte minden beszédét, amelyet a nép füle hallatára mondott, Kapernaumba ment. ");
INSERT INTO hun_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Egy századosnak volt egy szolgája, aki annál nagy becsben volt, igen rosszul lett, és már halálán volt. ");
INSERT INTO hun_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Amikor hallott Jézusról, hozzá küldte a zsidók véneit, és kérte, hogy jöjjön el, és gyógyítsa meg a szolgáját. ");
INSERT INTO hun_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Azok pedig elmentek, és nagyon kérték őt: „Méltó, hogy megtedd neki. ");
INSERT INTO hun_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Mert szereti a mi népünket, és a zsinagógát is ő építtette nekünk.“ ");
INSERT INTO hun_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Jézus tehát elment velük. Amikor azonban már nem messze volt a háztól, a százados eléje küldte néhány jó barátját, és ezt üzente neki: „Uram, ne fáraszd magad, mert nem vagyok méltó, hogy hajlékomba jöjj, ");
INSERT INTO hun_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","de magamat sem tartom érdemesnek arra, hogy hozzád menjek. Hanem csak szólj egy szót, és meggyógyul az én szolgám. ");
INSERT INTO hun_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Mert én is hatalom alá rendelt ember vagyok, és katonák szolgálnak alattam. És ha az egyiknek azt mondom: Eredj el, elmegy; vagy a másiknak: Jöjj ide, eljön, és ha a szolgámnak szólok: Tedd ezt, megteszi.“ ");
INSERT INTO hun_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Amikor Jézus ezt hallotta, elcsodálkozott, és hátrafordulva így szólt az őt követő sokaságnak: „Mondom nektek, ekkora hitet Izraelben sem találtam!“ ");
INSERT INTO hun_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","És a küldöttek visszatértek a házhoz, és a beteg szolgát már egészségben találták. ");
INSERT INTO hun_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Történt másnap, hogy egy Nain nevű városba ment, és vele mentek tanítványai és nagy sokaság. ");
INSERT INTO hun_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Amikor a város kapujához közeledtek, íme, egy halottat hoztak ki, anyjának egyetlen fiát, az asszony pedig özvegy volt. A városból nagy sokaság volt vele. ");
INSERT INTO hun_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Amikor az Úr meglátta, megkönyörült rajta, és ezt mondta neki: „Ne sírj!“ ");
INSERT INTO hun_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","És odament, megérintette a koporsót. Akik vitték, megálltak. Ő pedig így szólt: „Ifjú, neked mondom, kelj föl!“ ");
INSERT INTO hun_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Erre felült a halott, és elkezdett beszélni. Ő pedig átadta anyjának. ");
INSERT INTO hun_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Félelem fogta el mindnyájukat, és dicsőítették Istent, és ezt mondták: „Nagy próféta támadt közöttünk, és meglátogatta Isten az ő népét.“ ");
INSERT INTO hun_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","És elterjedt híre egész Júdeában és a környező tartományokban. ");
INSERT INTO hun_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jánosnak mindezeket elmondták tanítványai. És János magához hívatott kettőt tanítványai közül. ");
INSERT INTO hun_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Elküldte őket Jézushoz, és ezt kérdeztette: „Te vagy-e az Eljövendő, vagy mást várjunk?“ ");
INSERT INTO hun_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Amikor azért azok a férfiak hozzá mentek, ezt mondták: „Keresztelő János küldött minket hozzád, és kérdezteti: te vagy-e az Eljövendő, vagy mást várjunk?“ ");
INSERT INTO hun_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Abban az órában sokakat meggyógyított betegségekből, bajokból és gonosz lelkektől, és sok vaknak adta vissza szeme világát. ");
INSERT INTO hun_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Jézus így válaszolt nekik: „Menjetek el, mondjátok meg Jánosnak, amit láttatok és hallottatok, hogy a vakok látnak, a sánták járnak, a leprások megtisztulnak, a süketek hallanak, a halottak feltámadnak, és a szegénynek az evangélium hirdettetik. ");
INSERT INTO hun_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","És boldog, aki nem botránkozik meg énbennem.“ ");
INSERT INTO hun_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Amikor elmentek János követei, elkezdett beszélni a sokaságnak Jánosról: „Mit akartatok látni, amikor kimentetek a pusztába? Szélingatta nádszálat? ");
INSERT INTO hun_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Hát mit akartatok látni, amikor kimentetek? Finom ruhába öltözött embert? Íme, akik drága öltözetben és bőségben élnek, a királyi palotákban vannak. ");
INSERT INTO hun_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Hát mit akartatok látni, amikor kimentetek? Prófétát? Bizony mondom nektek, még prófétánál is nagyobbat. ");
INSERT INTO hun_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ő az, akiről meg van írva: »Íme, elküldöm követemet előtted, aki elkészíti neked az utat.« ");
INSERT INTO hun_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Mert mondom nektek, hogy azok között, akik asszonytól születtek, senki sincs nagyobb Keresztelő Jánosnál, de aki a legkisebb Isten országában, nagyobb nála.“ ");
INSERT INTO hun_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Amikor ezt hallotta az egész nép és a vámszedők is, igazat adtak Istennek, és megkeresztelkedtek a János keresztségével; ");
INSERT INTO hun_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","a farizeusok és a törvénytudók azonban Isten rájuk vonatkozó szándékát elutasították, és nem keresztelkedtek meg nála. ");
INSERT INTO hun_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","És ezt mondta az Úr: „Kihez hasonlítsam ennek a nemzedéknek tagjait? Kihez hasonlók? ");
INSERT INTO hun_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Hasonlók a piacon ülő gyermekekhez, akik ezt kiáltják egymásnak: »Furulyáztunk nektek, és nem táncoltatok, siratót énekeltünk, és nem sírtatok.« ");
INSERT INTO hun_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Mert eljött Keresztelő János, aki kenyeret nem eszik, bort nem iszik, és ezt mondjátok: Ördög van benne. ");
INSERT INTO hun_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Eljött az Emberfia, aki eszik és iszik, és azt mondjátok: Íme, falánk és borivó ember, vámszedők és bűnösök barátja. ");
INSERT INTO hun_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","És igazolódott minden gyermekében az ő bölcsessége.“ ");
INSERT INTO hun_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Egy farizeus arra kérte őt, hogy egyék vele. Ezért bement a farizeus házába, és asztalhoz telepedett. ");
INSERT INTO hun_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","És íme, a városban volt egy bűnös asszony, aki megtudta, hogy ő a farizeus házában asztalhoz telepedett, egy alabástromedényben drága kenetet hozott. ");
INSERT INTO hun_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Megállt hátul az ő lábánál sírva, könnyeivel kezdte öntözni lábait, és hajával törölte meg, és csókolgatta lábait, és megkente a drága kenettel. ");
INSERT INTO hun_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Amikor látta ezt a farizeus, aki őt meghívta, ezt mondta magában: „Ha ő próféta volna, tudná, hogy ki és miféle asszony az, aki megérintette, tudná, hogy bűnös.“ ");
INSERT INTO hun_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ekkor megszólalt Jézus és ezt mondta neki: „Simon, van valami mondanivalóm neked.“ Az így szólt: „Mester, mondjad.“ ");
INSERT INTO hun_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","„Egy hitelezőnek két adósa volt. Az egyik adós volt ötszáz dénárral, a másik pedig ötvennel. ");
INSERT INTO hun_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","És amikor nem volt nekik miből megadniuk, mind a kettőnek elengedte. Akkor a kettő közül, mondd meg, melyik szereti őt jobban?“ ");
INSERT INTO hun_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simon így válaszolt: „Azt gondolom, hogy az, akinek többet engedett el.“ És Jézus ezt mondta neki: „Helyesen ítéltél“, ");
INSERT INTO hun_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","és az asszonyhoz fordulva ezt mondta Simonnak: „Látod ezt az asszonyt? Bejöttem a házadba, lábamnak vizet nem adtál, ő pedig könnyeivel öntözte lábaimat, és hajával törölte meg. ");
INSERT INTO hun_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Engem meg nem csókoltál, ő mióta bejöttem, nem szűnt meg lábaimat csókolgatni. ");
INSERT INTO hun_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Olajjal fejemet nem kented meg, ő pedig drága kenettel kente meg lábaimat. ");
INSERT INTO hun_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ezért mondom neked: Neki sok bűne bocsáttatott meg, mert nagyon szeretett. Akinek pedig kevés bocsáttatik meg, az kevésbé szeret.“ ");
INSERT INTO hun_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Így szólt az asszonyhoz: „Megbocsáttattak neked a te bűneid!“ ");
INSERT INTO hun_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","És akik együtt ültek vele az asztalnál, elkezdték kérdezgetni egymás között: „Kicsoda ez, hogy a bűnöket is megbocsátja?“ ");
INSERT INTO hun_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ő pedig így szólt az asszonyhoz: „A te hited megtartott téged. Eredj el békességgel!“ ");
INSERT INTO hun_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Történt ezután, hogy városról városra és faluról falura járt, és prédikálta és hirdette Isten országát, és vele volt a tizenkettő, ");
INSERT INTO hun_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","és néhány asszony is, akiket gonosz lelkektől és betegségekből gyógyított meg: Mária, akit Magdalainak neveznek, akiből hét ördög ment ki, ");
INSERT INTO hun_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","és Johanna, Kuzának, Heródes egyik főemberének a felesége és Zsuzsanna és sokan mások, akik vagyonukból szolgáltak neki. ");
INSERT INTO hun_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Amikor nagy sokaság gyűlt egybe, azokból is, akik a városokból mentek hozzá, ezt a példázatot mondta nekik: ");
INSERT INTO hun_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","„Kiment a magvető, hogy elvesse vetőmagját. Magvetés közben némelyik az útfélre esett, és eltaposták, és az ég madarai megették. ");
INSERT INTO hun_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Némelyik sziklára esett, és amikor kikelt, elszáradt, mert nem volt nedvessége. ");
INSERT INTO hun_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Némelyik tövisek közé esett, és a tövisek velük együtt növekedve megfojtották azt. ");
INSERT INTO hun_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Némelyik pedig jó földbe esett, és amikor kikelt, százszoros termést hozott.“ Amikor ezt mondta, felkiáltott: „Akinek van füle a hallásra, hallja!“ ");
INSERT INTO hun_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Megkérdezték tőle tanítványai: „Mit jelent ez a példázat?“ ");
INSERT INTO hun_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ő ezt mondta nekik: „Nektek megadatott, hogy értsétek Isten országának titkait, a többieknek azonban példázatokban adatik, »hogy látván ne lássanak, és hallván ne értsenek.« ");
INSERT INTO hun_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","A példázat pedig ez: A mag Isten beszéde. ");
INSERT INTO hun_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Az útfélre esettek azok, akik meghallgatták, de aztán eljön az ördög, és kikapja szívükből, hogy ne higgyenek és ne üdvözüljenek. ");
INSERT INTO hun_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","A sziklára esettek azok, akik amikor hallják, örömmel fogadják az igét, de nem ver bennük gyökeret, egy ideig hisznek, a kísértés idején pedig elpártolnak. ");
INSERT INTO hun_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","A tövisek közé esettek azok, akik meghallgatták, de amikor elmentek, az élet gondja és gazdagsága és gyönyörűsége megfojtja azt, és termést nem hoznak. ");
INSERT INTO hun_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Akiknél pedig a jó földbe esett, ezek azok, akik a hallott igét tiszta és jó szívvel megtartják, és termést hoznak állhatatossággal. ");
INSERT INTO hun_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","„Aki gyertyát gyújt, nem takarja le azt egy edénnyel, ágy alá sem rejti, hanem gyertyatartóba teszi, hogy akik bemennek, lássák a világosságot. ");
INSERT INTO hun_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Mert nincs olyan titok, amely nyilvánvalóvá ne lenne, és nincs olyan rejtett dolog, amely ki ne tudódnék, és világosságra ne jönne. ");
INSERT INTO hun_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Vigyázzatok azért, hogyan hallgatjátok, mert akinek van, annak adatik, és akinek nincs, attól az is elvétetik, amiről azt gondolja, hogy az övé.“ ");
INSERT INTO hun_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Odamentek hozzá anyja és testvérei, de nem tudtak hozzájutni a sokaság miatt. ");
INSERT INTO hun_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ezért tudtára adták neki: „A te anyád és testvéreid kint állnak, téged akarnak látni.“ ");
INSERT INTO hun_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ő azonban így válaszolt nekik: „Az én anyám és testvéreim azok, akik Isten beszédét hallgatják, és megcselekszik azt.“ ");
INSERT INTO hun_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Történt egy napon, hogy hajóba szállt tanítványaival, és ezt mondta nekik: „Menjünk át a tó túlsó partjára.“ És elindultak. ");
INSERT INTO hun_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Hajózásuk közben elszenderedett. Ekkor szélvész csapott le a tóra, és megrémültek, és veszélyben voltak. ");
INSERT INTO hun_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Hozzá mentek, felkeltették, és ezt mondták: „Mester, Mester, elveszünk!“ Ő pedig felkelt, rászólt a szélre és a hullámokra, mire azok elültek, és csend lett. ");
INSERT INTO hun_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","És ezt mondta nekik: „Hol van a ti hitetek?“ Ők pedig félelemmel és csodálkozással ezt mondták egymásnak: „Ugyan kicsoda ez, hogy a szélnek és víznek is parancsol, és azok engedelmeskednek neki?“ ");
INSERT INTO hun_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Aztán áthajóztak a gadaraiak földjére, amely Galileával átellenben van. ");
INSERT INTO hun_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Amikor kiment a partra, egy ember jött elé a városból, akiben ördögök voltak. Régóta nem viselt ruhát, s házban sem lakott, hanem csak sírboltokban. ");
INSERT INTO hun_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Amikor meglátta Jézust, felkiáltott, lába elé borult, és hangosan ezt mondta: „Mi közöm hozzád, Jézus, a felséges Isten Fia? Kérlek téged, ne gyötörj engem!“ ");
INSERT INTO hun_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Azt parancsolta ugyanis a tisztátalan léleknek, hogy menjen ki ebből az emberből. Mert már régóta hatalmában tartotta, ezért láncokkal és bilincsekkel megkötözve őrizték, de ő elszakította kötelékeit, az ördög pedig a pusztába űzte. ");
INSERT INTO hun_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jézus megkérdezte: „Mi a neved?“ Az így felelt: „Légió“, mert sok ördög ment bele. ");
INSERT INTO hun_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","És kérték őt, hogy ne parancsolja őket vissza az alvilágba. ");
INSERT INTO hun_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Volt pedig ott egy disznócsorda, amely a hegyen legelészett, és kérték őt, hogy engedje meg nekik, hogy azokban menjenek. ");
INSERT INTO hun_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Miután kimentek az ördögök az emberből, és bementek a disznókba, a csorda a meredekről a tóba rohant, és megfulladt. ");
INSERT INTO hun_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Amikor a pásztorok látták, mi történt, elfutottak, és hírét vitték a városba és a falvakba. ");
INSERT INTO hun_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Kimentek az emberek megnézni, mi történt, és Jézushoz mentek, és ott találták azt az embert, akiből az ördögök kimentek, amint felöltözve és ép elmével ült Jézus lábainál, és nagyon megijedtek. ");
INSERT INTO hun_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Akik látták, elbeszélték nekik, hogyan szabadult meg az a megszállott. ");
INSERT INTO hun_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ekkor a Gadara vidékének egész népe arra kérte, hogy menjen el onnan, mert nagyon féltek. Ő pedig hajóra szállt, és visszatért. ");
INSERT INTO hun_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Az az ember, akiből az ördögök kimentek, arra kérte, hogy vele lehessen. De Jézus elküldte őt, és ezt mondta neki: ");
INSERT INTO hun_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","„Térj vissza házadhoz, és beszéld el, milyen nagy dolgokat tett Isten veled.“ Elment azért, és hirdette az egész városban, hogy milyen nagy dolgot tett vele Jézus. ");
INSERT INTO hun_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","És történt, amikor Jézus visszatért, a nép örömmel fogadta, mert mindnyájan várták. ");
INSERT INTO hun_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","És íme, jött egy Jairus nevű ember, aki a zsinagóga elöljárója volt, és Jézus lábai elé borult, és kérte, hogy menjen el házába, ");
INSERT INTO hun_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","mert egyetlen, mintegy tizenkét esztendős leánya halálán volt. Miközben ment, a sokaság szorongatta. ");
INSERT INTO hun_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","És egy asszony, aki tizenkét esztendő óta vérfolyásos volt, és bár minden vagyonát orvosokra költötte, senki sem tudta meggyógyítani. ");
INSERT INTO hun_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Hátulról hozzálépett, megérintette ruhájának szegélyét, és azonnal elállt a vérfolyása. ");
INSERT INTO hun_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jézus ezt mondta: „Ki az, aki megérintett?“ Amikor mindnyájan tagadták, Péter, és akik vele voltak így szóltak: „Mester, a sokaság szorongat és lökdös téged, és te azt mondod: ki az, aki megérintett engem?“ ");
INSERT INTO hun_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","De Jézus ezt mondta: „Valaki megérintett engem, mert észrevettem, hogy erő árad ki belőlem.“ ");
INSERT INTO hun_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Amikor pedig látta az asszony, hogy nem maradt titokban, reszketve előjött, eléje borult, és elbeszélte az egész sokaság előtt, hogy miért érintette őt, és hogy azonnal meggyógyult. ");
INSERT INTO hun_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jézus pedig ezt mondta neki: „Bízzál, leányom, a te hited megtartott téged, eredj el békességgel!“ ");
INSERT INTO hun_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Még beszélt, amikor eljött egy ember a zsinagógai elöljáró házából, és ezt mondta: „Meghalt a leányod, ne fáraszd a Mestert!“ ");
INSERT INTO hun_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Amikor Jézus ezt hallotta, ezt mondta neki: „Ne félj, csak higgy, és meggyógyul.“ ");
INSERT INTO hun_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Bemenve a házba, senkit sem engedett be, csak Pétert, Jakabot és Jánost és a leány atyját és anyját. ");
INSERT INTO hun_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Mindnyájan sírtak, és gyászolták. Ő pedig ezt mondta: „Ne sírjatok, nem halt meg, csak alszik.“ ");
INSERT INTO hun_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Erre kinevették, mert tudták, hogy meghalt. ");
INSERT INTO hun_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ekkor mindenkit kiküldött, megfogta a leány kezét, és kiáltott: „Leányom, kelj fel!“ ");
INSERT INTO hun_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ekkor visszatért abba a lélek, azonnal felkelt, és ő megparancsolta, hogy adjanak neki enni. ");
INSERT INTO hun_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","És álmélkodtak annak szülei, de ő megparancsolta, hogy senkinek se mondják el, ami történt. ");
INSERT INTO hun_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Miután összehívta Jézus tizenkét tanítványát, erőt és hatalmat adott nekik minden ördög felett, és betegségek gyógyítására is. ");
INSERT INTO hun_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Aztán elküldte őket, hogy prédikálják Isten országát, és betegeket gyógyítsanak. ");
INSERT INTO hun_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ezt mondta nekik: „Semmit ne vigyetek az útra, se botot, se táskát, se kenyeret, se pénzt, két-két ruhátok se legyen. ");
INSERT INTO hun_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Amelyik házba bementek, ott maradjatok, és onnan induljatok tovább. ");
INSERT INTO hun_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ha nem fogadnak be titeket, amikor kimentek abból a városból, még a port is verjétek le lábatokról, bizonyságul ellenük.“ ");
INSERT INTO hun_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Azok tehát útra keltek, bejárták a falvakat, hirdették az evangéliumot, és gyógyítottak mindenütt. ");
INSERT INTO hun_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Heródes, a negyedes fejedelem meghallotta mindazt, ami történt, és zavarban volt, mert némelyek azt mondták, hogy János támadt fel a halálból. ");
INSERT INTO hun_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Mások szerint Illés jelent meg, ismét mások pedig, hogy a próféták közül támadt fel valaki. ");
INSERT INTO hun_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Heródes ezt mondta: „Jánost lefejeztettem, kicsoda hát ez, akiről én ilyen dolgokat hallok?“ És látni akarta őt. ");
INSERT INTO hun_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Amikor visszatértek, az apostolok elbeszéltek neki mindent, amit cselekedtek. Akkor maga mellé vette őket, és elvonult velük egy magányos helyre, egy Bétsaida nevű városba. ");
INSERT INTO hun_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Amikor a sokaság ezt megtudta, követte őt, és ő örömmel fogadta őket, Isten országáról beszélt nekik, és akiknek gyógyulásra volt szükségük, azokat meggyógyította. ");
INSERT INTO hun_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Amikor a nap már hanyatlani kezdett, a tizenkettő odament hozzá, ezt mondták neki: „Bocsásd el a sokaságot, hogy menjenek el, és a környező falvakban és majorokban megszálljanak, és élelmet találjanak, mert itt puszta helyen vagyunk.“ ");
INSERT INTO hun_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ő pedig ezt mondta nekik: „Adjatok nekik ti enni!“ Azok így válaszoltak: „Nekünk sincs több öt kenyérnél és két halnál, ha csak el nem megyünk, és nem veszünk eledelt az egész sokaságnak.“ ");
INSERT INTO hun_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Mert mintegy ötezer férfi volt ott. Így szólt tanítványaihoz: „Ültessétek le őket csoportokban ötvenenként.“ ");
INSERT INTO hun_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Így cselekedtek, és leültették valamennyit. ");
INSERT INTO hun_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ő pedig vette az öt kenyeret és két halat, égre emelte szemét, megáldotta azokat, és megszegte, és a tanítványoknak adta, hogy a sokaság elé tegyék. ");
INSERT INTO hun_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Mindnyájan ettek és jóllaktak, és összeszedték a megmaradt darabokat, tizenkét kosárral. ");
INSERT INTO hun_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Történt, hogy amikor egyszer magában imádkozott, és csak a tanítványok voltak vele, megkérdezte őket: „Kinek mond engem a sokaság?“ ");
INSERT INTO hun_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Azok így válaszoltak: „Keresztelő Jánosnak, mások Illésnek, mások pedig azt mondják, hogy a régi próféták közül támadt fel valaki.“ ");
INSERT INTO hun_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ő ekkor ezt mondta nekik: „Hát ti kinek mondtok engem?“ Péter így válaszolt: „Az Isten Krisztusának!“ ");
INSERT INTO hun_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ő pedig rájuk parancsolt, és meghagyta nekik, hogy ezt senkinek se mondják. ");
INSERT INTO hun_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Majd így szólt: „Az Emberfiának sokat kell szenvednie, és megvettetnie a vénektől, a főpapoktól és az írástudóktól, és meg kell öletnie, és harmadnapon feltámadnia.“ ");
INSERT INTO hun_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Azután így szólt mindnyájukhoz: „Ha valaki utánam akar jönni, tagadja meg magát, és vegye fel keresztjét mindennap, és kövessen engem. ");
INSERT INTO hun_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Mert aki meg akarja tartani életét, elveszti azt, aki pedig elveszti életét énérettem, megtartja azt. ");
INSERT INTO hun_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Mert mit használ az embernek, ha az egész világot megnyeri is, önmagát pedig elveszti, vagy kárt vall? ");
INSERT INTO hun_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Mert aki szégyell engem és az én beszédemet, az Emberfia is szégyellni fogja azt, amikor eljön a maga, az Atya és az angyalok dicsőségében. ");
INSERT INTO hun_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Bizony mondom nektek, hogy vannak az itt állók között, akik nem ízlelnek halált, míg meg nem látják Isten országát.“ ");
INSERT INTO hun_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Történt e beszédek után mintegy nyolc nappal, hogy maga mellé vette Pétert, Jánost és Jakabot, és felment a hegyre imádkozni. ");
INSERT INTO hun_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Imádkozás közben arckifejezése megváltozott, és ruhája fehér és fénylő lett. ");
INSERT INTO hun_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","És íme két férfi beszélt vele: Mózes és Illés, ");
INSERT INTO hun_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","akik dicsőségben jelentek meg, és az ő haláláról beszéltek, amelyet Jeruzsálemben kell beteljesítenie. ");
INSERT INTO hun_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pétert és a vele lévőket elnyomta az álom, de amikor felébredtek, látták az ő dicsőségét és azt a két férfit, akik ott álltak vele. ");
INSERT INTO hun_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Történt, hogy amikor azok távozóban voltak, Péter ezt mondta Jézusnak: „Mester, jó nekünk itt lennünk. Csináljunk azért három sátrat: egyet neked, egyet Mózesnek és egyet Illésnek.“ De nem tudta, mit beszél. ");
INSERT INTO hun_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Amikor ezeket mondta, felhő támadt, és beárnyékolta őket, ők pedig megijedtek, amikor felhőbe kerültek. ");
INSERT INTO hun_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Szózat hallatszott a felhőből: „Ez az én Fiam, akit kiválasztottam, őt hallgassátok!“ ");
INSERT INTO hun_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Miközben a szózat hallatszott, Jézus már egyedül maradt ott. Ők pedig hallgattak, és azokban a napokban semmit sem mondtak el abból, amit hallottak és láttak. ");
INSERT INTO hun_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Történt a következő napon, amikor lementek a hegyről, nagy sokaság ment eléje. ");
INSERT INTO hun_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","És íme, egy ember így kiáltott a sokaságból: „Mester, kérlek téged, tekints a fiamra, mert ő az én egyetlenem. ");
INSERT INTO hun_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","És íme, valami lélek szokta megragadni őt, és hirtelen kiáltozni kezd, és rázza őt annyira, hogy tajtékzik, és nehezen távozik tőle, miután gyötörte. ");
INSERT INTO hun_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Kértem tanítványaidat, hogy űzzék ki, de nem tudták.“ ");
INSERT INTO hun_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jézus így szólt: „Ó, hitetlen és elfajult nemzedék, meddig leszek közöttetek, és meddig tűrlek titeket? Hozd ide a fiadat!“ ");
INSERT INTO hun_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Amíg odament, az ördög leteperte, és megrázta. De Jézus ráparancsolt a tisztátalan lélekre, meggyógyította a gyermeket, és visszaadta atyjának. ");
INSERT INTO hun_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ekkor elámultak mindnyájan Isten nagyságán. Amikor mindnyájan csodálkoztak mindazon, amit Jézus cselekedett, ezt mondta tanítványainak: ");
INSERT INTO hun_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","„Jegyezzétek meg jól ezeket a szavakat: mert az Emberfia az emberek kezébe adatik!“ ");
INSERT INTO hun_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","De ők nem értették ezt a mondást, és el volt rejtve előlük, hogy ne értsék meg, és féltek őt megkérdezni e mondás értelme felől. ");
INSERT INTO hun_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Majd az a gondolat támadt bennük, hogy ki a nagyobb közöttük. ");
INSERT INTO hun_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jézus látva szívük gondolatát, kézen fogott egy kis gyermeket, maga mellé állította, ");
INSERT INTO hun_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","és ezt mondta nekik: „Aki egy kisgyermeket befogad az én nevemben, engem fogad be, és aki engem befogad, azt fogadja be, aki engem elküldött, mert aki a legkisebb mindnyájatok között, az a nagy.“ ");
INSERT INTO hun_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Megszólalt János, és ezt mondta: „Mester, láttunk valakit, aki a te nevedben ördögöket űz, és eltiltottuk, mert nem követ minket.“ ");
INSERT INTO hun_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jézus azonban ezt mondta neki: „Ne tiltsátok el, mert aki nincs ellenünk, mellettünk van.“ ");
INSERT INTO hun_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Történt, amikor már közeledett felemeltetésének ideje, elhatározta, hogy Jeruzsálembe megy. ");
INSERT INTO hun_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Követeket küldött maga előtt. Azok elindultak, és betértek egy samáriai faluba, hogy neki szállást készítsenek. ");
INSERT INTO hun_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","De nem fogadták be őt, mivel Jeruzsálembe ment. ");
INSERT INTO hun_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Amikor ezt látták tanítványai, Jakab és János, ezt mondták: „Uram, akarod-e, hogy ezt mondjuk: Tűz szálljon le az égből, és égesse meg őket, amint Illés is tette?“ ");
INSERT INTO hun_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Jézus azonban megfordulva megdorgálta őket, és ezt mondta: „Nem tudjátok, hogy milyen lélek van bennetek, ");
INSERT INTO hun_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","mert az Emberfia nem azért jött, hogy elveszítse az emberek életét, hanem hogy megtartsa.“ Elmentek azért más faluba. ");
INSERT INTO hun_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Történt pedig, amikor mentek az úton, valaki ezt mondta neki: „Követlek téged, Uram, bárhová mégy.“ ");
INSERT INTO hun_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jézus azonban így felelt: „A rókáknak barlangjuk van, és az égi madaraknak fészkük, de az Emberfiának nincs fejét hová lehajtania.“ ");
INSERT INTO hun_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Egy másikhoz így szólt: „Kövess engem!“ Az pedig ezt mondta: „Uram, engedd meg nekem, hogy előbb elmenjek, és eltemessem az atyámat!“ ");
INSERT INTO hun_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jézus így válaszolt neki: „Hadd temessék el a halottak az ő halottaikat, te pedig menj el, és hirdesd Isten országát.“ ");
INSERT INTO hun_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Egy másik is ezt mondta: „Követlek, Uram, de előbb engedd meg nekem, hogy búcsút vegyek házam népétől.“ ");
INSERT INTO hun_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jézus így felelt: „Aki az eke szarvára veti kezét, és hátratekint, nem alkalmas Isten országára.“ ");
INSERT INTO hun_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ezek után pedig az Úr hetvenkét tanítványt választott ki, és elküldte őket maga előtt kettesével minden városba és helységbe, ahová menni készült. ");
INSERT INTO hun_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ezt mondta nekik: „Az aratni való sok, a munkás kevés. Kérjétek az aratás Urát, hogy küldjön munkásokat az ő aratásába. ");
INSERT INTO hun_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Menjetek el, íme, én elküldelek titeket, mint bárányokat a farkasok közé. ");
INSERT INTO hun_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ne vigyetek magatokkal erszényt, se táskát, se sarut. Az úton senkit se köszöntsetek. ");
INSERT INTO hun_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ha bementek egy házba, először ezt mondjátok: Békesség e háznak! ");
INSERT INTO hun_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","És ha van ott valaki, aki a békesség fia, nyugodjék meg azon a ti békességetek. Ha nincs, rátok tér vissza. ");
INSERT INTO hun_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ugyanabban a házban maradjatok, és azt egyétek, igyátok, amit adnak. Mert méltó a munkás az ő jutalmára. Ne járjatok házról házra. ");
INSERT INTO hun_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ha egy városba bementek, és befogadnak titeket, azt egyétek, amit elétek tesznek. ");
INSERT INTO hun_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","És gyógyítsátok a betegeket, és mondjátok nekik: Elközelített hozzátok Isten országa. ");
INSERT INTO hun_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ha egy városba bementek, és titeket nem fogadnak be, menjetek ki annak utcáira, és ezt mondjátok: ");
INSERT INTO hun_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","A port is, amely reánk tapadt városotokból, lerázzuk, de azt tudjátok meg, hogy Isten országa elközelített hozzátok. ");
INSERT INTO hun_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Mondom pedig nektek, hogy Sodomának állapota tűrhetőbb lesz ama napon, mint azé a városé. ");
INSERT INTO hun_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Jaj neked, Korazin! Jaj neked, Bétsaida! Mert ha Tíruszban vagy Szidónban történtek volna azok a csodák, amelyek benned történtek, zsákban és hamuban ülve régen megtértek volna. ");
INSERT INTO hun_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","De Tírusznak és Szidónnak tűrhetőbb lesz a dolga az ítéletkor, mint nektek. ");
INSERT INTO hun_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","És te, Kapernaum, talán az égig magasztalnak fel? A pokolig fogsz levettetni. ");
INSERT INTO hun_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Aki titeket hallgat, engem hallgat, és aki titeket megvet, engem vet meg, és aki engem vet meg, azt veti meg, aki engem küldött.“ ");
INSERT INTO hun_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Visszatért pedig a hetvenkét tanítvány örömmel, és ezt mondták: „Uram, a te nevedre még az ördögök is engedelmeskednek nekünk.“ ");
INSERT INTO hun_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ő pedig ezt mondta nekik: „Láttam a sátánt, mint villámlást lebukni az égből. ");
INSERT INTO hun_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Íme, adok nektek hatalmat, hogy kígyókon és skorpiókon tapodjatok és az ellenség minden erején, és hogy semmi se ártson nektek. ");
INSERT INTO hun_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","De ne annak örüljetek, hogy a lelkek engedelmeskednek nektek, hanem inkább annak örüljetek, hogy a ti nevetek fel van írva a mennyben.“ ");
INSERT INTO hun_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Abban az órában Jézus örvendezett a Szentlélek által, és ezt mondta: „Hálát adok neked, Atyám, mennynek és földnek Ura, hogy elrejtetted ezeket a bölcsek és értelmesek elől, és a gyermekeknek kijelentetted. Igen, Atyám, mert így volt kedves előtted. ");
INSERT INTO hun_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Mindent nekem adott az én Atyám, és senki sem tudja, kicsoda a Fiú, csak az Atya, és kicsoda az Atya, csak a Fiú, és az, akinek a Fiú akarja kijelenteni.“ ");
INSERT INTO hun_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","És a tanítványokhoz fordulva, ezt mondta nekik: „Boldog az a szem, amely látja azt, amit ti láttok. ");
INSERT INTO hun_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Mert mondom nektek, sok próféta és király kívánta látni, amit ti láttok, de nem látták, és hallani, amit ti hallotok, de nem hallották.“ ");
INSERT INTO hun_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","És íme, egy törvénytudó előállt, és kísértve őt ezt mondta: „Mester, mit cselekedjem, hogy az örök életet elnyerjem?“ ");
INSERT INTO hun_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ő pedig ezt mondta neki: „A törvényben mi van megírva? Hogyan olvasod?“ ");
INSERT INTO hun_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Az pedig ezt válaszolta: „»Szeresd az Urat, a te Istenedet, teljes szívedből, teljes lelkedből, minden erődből és teljes elmédből, és a te felebarátodat, mint magadat.«“ ");
INSERT INTO hun_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ezt mondta neki: „Jól feleltél. Ezt cselekedd, és élsz.“ ");
INSERT INTO hun_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Az pedig igazolni akarva magát, így szólt Jézushoz: „De ki az én felebarátom?“ ");
INSERT INTO hun_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jézus ezt mondta neki: „Egy ember ment Jeruzsálemből Jerikóba, és rablók kezébe esett, akik kifosztották, és megsebesítették, aztán elmentek, és otthagyták félholtan. ");
INSERT INTO hun_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Történetesen egy pap ment lefelé az úton, aki azt látva, elkerülte. ");
INSERT INTO hun_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Hasonlóképpen egy lévita is, amikor arra a helyre ért, és azt látta, elkerülte. ");
INSERT INTO hun_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Egy samáriai pedig, amikor az úton odaért hozzá, és meglátta, könyörületességre indult. ");
INSERT INTO hun_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Odament hozzá, bekötözte sebeit, és olajat és bort öntött azokra. Aztán feltette saját barmára, és a vendégfogadó házhoz vitte, és gondját viselte. ");
INSERT INTO hun_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Másnap pedig elmenőben két dénárt vett elő, a gazdának adta, és ezt mondta neki: Viselj gondot reá, és ha valamit még ezen felül ráköltesz, amikor visszatérek, megadom neked. ");
INSERT INTO hun_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Mit gondolsz: e három közül ki volt a felebarátja annak, aki a rablók kezébe esett?“ ");
INSERT INTO hun_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Az pedig ezt mondta: „Az, aki könyörült rajta.“ Jézus ezt mondta neki: „Eredj el, és te is hasonlóképpen cselekedj.“ ");
INSERT INTO hun_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Történt pedig, hogy amikor az úton mentek, bement egy faluba, egy Márta nevű asszony pedig befogadta házába. ");
INSERT INTO hun_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ennek volt egy Mária nevű testvére, aki Jézus lábához ülve hallgatta beszédét. ");
INSERT INTO hun_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Márta pedig el volt foglalva a házimunkában. Ezért odaállt, és ezt mondta: „Uram, nem törődsz azzal, hogy az én testvérem magamra hagyott a szolgálatban? Mondd hát neki, hogy segítsen!“ ");
INSERT INTO hun_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Jézus ezt válaszolta neki: „Márta, Márta, szorgalmas vagy, és sokra igyekezel. ");
INSERT INTO hun_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","De egy a szükséges dolog. Mária a jó részt választotta, amelyet el nem vesznek tőle.“ ");
INSERT INTO hun_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Történt egyszer, hogy amikor egy helyen imádkozott, miután befejezte, egyik tanítványa így szólt hozzá: „Uram, taníts minket imádkozni, amiképpen János is tanította az ő tanítványait.“ ");
INSERT INTO hun_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ő pedig ezt mondta nekik: „Amikor imádkoztok, ezt mondjátok: »Mi Atyánk, aki a mennyekben vagy, szenteltessék meg a te neved. Jöjjön el a te országod. Legyen meg a te akaratod, amint a mennyben, úgy a földön is. ");
INSERT INTO hun_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Mindennapi kenyerünket add meg nekünk naponként, ");
INSERT INTO hun_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","és bocsásd meg a mi bűneinket, mert mi is megbocsátunk mindenkinek, aki nekünk adósunk. És ne vígy minket kísértésbe.«“ ");
INSERT INTO hun_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Azután így szólt hozzájuk: „Ki az közületek, akinek van egy barátja, és ha az elmegy hozzá éjfélkor, és ezt mondja neki: Barátom, adj nekem kölcsön három kenyeret, ");
INSERT INTO hun_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","mert egy barátom útközben hozzám tért be, és nincs mit adnom neki enni, ");
INSERT INTO hun_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","ő így válaszolna belülről neki: Ne zavarj engem, mert az ajtó be van zárva, és gyermekeim is velem vannak az ágyban, nem kelhetek fel, hogy adjak neked. ");
INSERT INTO hun_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Mondom nektek, ha nem is fog felkelni, és adni neki azért, mert barátja, de annak tolakodása miatt fel fog kelni, és ad neki annyit, amennyi kell. ");
INSERT INTO hun_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Én is azt mondom nektek: Kérjetek, és adatik, keressetek, és találtok, zörgessetek, és megnyittatik nektek, ");
INSERT INTO hun_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","mert aki kér, mind kap, aki keres, talál, és a zörgetőnek megnyittatik. ");
INSERT INTO hun_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Melyik apa az közületek, akitől ha a fia kenyeret kér, követ ad neki? Vagy ha halat kér, hal helyett kígyót ad neki? ");
INSERT INTO hun_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Vagy ha tojást kér, skorpiót ad neki? ");
INSERT INTO hun_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Azért ha ti gonosz létetekre tudtok a ti gyermekeiteknek jó ajándékokat adni, mennyivel inkább ad a ti mennyei Atyátok Szentlelket azoknak, akik tőle kérik.“ ");
INSERT INTO hun_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Egyszer kiűzött egy ördögöt, amely néma volt. Történt, hogy amikor kiment az ördög, megszólalt a néma, és csodálkozott a sokaság. ");
INSERT INTO hun_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Közülük némelyek ezt mondták: „Belzebubbal, az ördögök fejedelmével űzi ki az ördögöket.“ ");
INSERT INTO hun_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Mások meg kísértették, és mennyei jelt kívántak tőle. ");
INSERT INTO hun_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ő pedig ismerve azok gondolatát, ezt mondta nekik: „Minden ország, amely meghasonlik önmagával, elpusztul, és ház házra omlik. ");
INSERT INTO hun_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ha a sátán meghasonlik önmagával, hogyan állhatna fönn országa? Mert azt mondjátok, hogy én Belzebubbal űzöm ki az ördögöket. ");
INSERT INTO hun_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","És ha én Belzebubbal űzöm ki az ördögöket, a ti fiaitok kivel űzik ki? Azért ők maguk lesznek a ti bíráitok. ");
INSERT INTO hun_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ha viszont én Isten ujjával űzöm ki az ördögöket, akkor kétségkívül elérkezett hozzátok Isten országa. ");
INSERT INTO hun_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Amikor az erős ember fegyverrel őrzi a maga palotáját, javai biztonságban vannak. ");
INSERT INTO hun_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","De amikor a nála erősebb megy oda, és legyőzi, akkor elveszi fegyverét, amiben bízott, és amit tőle zsákmányolt, szétosztja. ");
INSERT INTO hun_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Aki nincs velem, ellenem van, és aki nem gyűjt velem, az tékozol. ");
INSERT INTO hun_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Amikor a tisztátalan lélek kimegy az emberből, víz nélküli helyeken jár, nyugalmat keresve. És amikor nem talál, ezt mondja: visszatérek az én házamba, ahonnan jöttem, ");
INSERT INTO hun_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","és odamenve kisöpörve és felékesítve találja azt. ");
INSERT INTO hun_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Akkor elmegy, maga mellé vesz még más hét lelket, magánál is gonoszabbakat, bemennek, és ott laknak. És annak az embernek a végső állapota rosszabb lesz az elsőnél.“ ");
INSERT INTO hun_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Történt pedig, amikor ezeket mondta, egy asszony a sokaságból így kiáltott hozzá: „Boldog az az anyaméh, amely téged hordozott, és az emlők, amelyeket szoptál.“ ");
INSERT INTO hun_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ő pedig ezt mondta: „Még boldogabbak azok, akik hallgatják Isten beszédét, és megtartják azt.“ ");
INSERT INTO hun_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Amikor a sokaság hozzá gyülekezett, ezt mondta: „Ez a gonosz nemzedék jelt követel, de nem adatik neki, csak Jónás próféta jele. ");
INSERT INTO hun_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Mert amiképpen Jónás jelül volt a niniveiek számára, úgy lesz az Emberfia is e nemzedéknek. ");
INSERT INTO hun_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Dél királynője fel fog támadni az ítéletkor e nemzedéknek férfiaival, és kárhoztatja őket. Mert ő eljött a föld széléről, hogy hallhassa Salamon bölcsességét, de íme, nagyobb van itt Salamonnál. ");
INSERT INTO hun_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ninive férfiai az ítéletkor együtt támadnak fel e nemzedékkel, és kárhoztatják majd őket, mert ők megtértek Jónás beszédére, de íme, nagyobb van itt Jónásnál. ");
INSERT INTO hun_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","„Aki gyertyát gyújt, nem teszi rejtett helyre, sem a véka alá, hanem a gyertyatartóba, hogy akik bemennek, lássák a világosságot. ");
INSERT INTO hun_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","A test lámpása a szem. Ha azért a szemed őszinte, az egész tested világos lesz. Ha pedig a szemed gonosz, a tested is sötét. ");
INSERT INTO hun_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Vigyázz tehát, hogy a világosság, amely benned van, sötétség ne legyen. ");
INSERT INTO hun_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ha tehát az egész tested világos, és nincs benne sötét rész, akkor egészen világos lesz, mint amikor a lámpás megvilágít téged világosságával.“ ");
INSERT INTO hun_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Beszéd közben egy farizeus arra kérte, hogy ebédeljen nála. Bement, és leült enni. ");
INSERT INTO hun_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","A farizeus, amikor ezt látta, elcsodálkozott, hogy ebéd előtt nem mosdott meg. ");
INSERT INTO hun_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Az Úr ezt mondta neki: „Ti, farizeusok a pohárnak és tálnak külső részét megtisztítjátok ugyan, de a belsőtök tele van nyereségvággyal és gonoszsággal. ");
INSERT INTO hun_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Bolondok! Aki azt teremtette, ami kívül van, nem ő teremtette-e azt is, ami belül van? ");
INSERT INTO hun_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Azt adjátok oda alamizsnaként, ami belül van, és akkor minden tiszta lesz nektek. ");
INSERT INTO hun_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","De jaj nektek, farizeusok, mert megadjátok a tizedet a mentából, a kaporból és minden zöldségféléből, de mellőzitek az igazságot és az Isten szeretetét. Pedig ezeket kellene cselekedni, és amazokat sem elhagyni. ");
INSERT INTO hun_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Jaj nektek farizeusok! Mert szeretitek az első helyet a zsinagógában és a köszöntéseket a piacon. ");
INSERT INTO hun_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Jaj nektek, képmutató írástudók és farizeusok, mert olyanok vagytok, mint a sírok, amelyek nem látszanak, és az emberek, akik azokon járnak, nem tudnak róla.“ ");
INSERT INTO hun_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ekkor megszólalt valaki a törvénytudók közül: „Mester, amikor ezeket mondod, minket is megbántasz.“ ");
INSERT INTO hun_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ő pedig így válaszolt: „Jaj nektek is, törvénytudók, mert elhordozhatatlan terhekkel terhelitek meg az embereket, de ti magatok egy ujjal sem érintitek a terheket. ");
INSERT INTO hun_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Jaj nektek, mert építitek a próféták síremlékeit, a ti atyáitok pedig megölték őket. ");
INSERT INTO hun_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Tehát bizonyítjátok, és jóváhagyjátok atyáitok cselekedeteit, hogy ők megölték őket, ti pedig síremlékeiket építitek. ");
INSERT INTO hun_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ezért mondja Isten bölcsessége is: Küldök hozzájuk prófétákat és apostolokat, és azok közül némelyeket megölnek, és némelyeket elüldöznek, ");
INSERT INTO hun_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","hogy számon kéressék ettől a nemzedéktől minden próféta vére, amelyet e világ kezdetétől kiontottak ");
INSERT INTO hun_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ábel vérétől kezdve Zakariás véréig, aki az oltár és a templom között pusztult el. Bizony mondom nektek, számot kell adni ennek a nemzedéknek! ");
INSERT INTO hun_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Jaj nektek, törvénytudók, mert elvettétek az ismeret kulcsát: ti magatok nem mentek be, és azokat is megakadályoztátok, akik be akarnak menni.“ ");
INSERT INTO hun_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Amikor ezeket mondta nekik, az írástudók és farizeusok elkezdték hevesen támadni, és sok dolog felől kérdezgették, ");
INSERT INTO hun_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ólálkodtak utána, hogy szavaiból elkapjanak valamit, amivel vádolhatják. ");
INSERT INTO hun_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Miközben sok ezerből álló sokaság gyűlt össze úgy, hogy majd letaposták egymást, elkezdett beszélni tanítványaihoz: „Mindenekelőtt óvakodjatok a farizeusok kovászától, ami a képmutatás. ");
INSERT INTO hun_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Mert nincs olyan rejtett dolog, amely napfényre ne jönne, és olyan titok, amely ki ne tudódnék. ");
INSERT INTO hun_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Amit sötétségbe mondtatok, azt a világosságban fogják meghallani. Amit fülbe súgva mondtatok rejtett helyen, azt a házak tetejéről fogják hirdetni. ");
INSERT INTO hun_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Mondom nektek, az én barátaimnak: Ne féljetek azoktól, akik a testet ölik meg, és aztán többet nem árthatnak. ");
INSERT INTO hun_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","De megmondom nektek, kitől féljetek: Féljetek attól, aki ha megöl, arra is van hatalma, hogy a gyehennára vessen. Bizony mondom nektek: Tőle féljetek! ");
INSERT INTO hun_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ugye öt verebet meg lehet venni két fillérért? De azok közül egy sincs Istennél elfelejtve. ");
INSERT INTO hun_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Nektek pedig még hajatok szálai is mind számon vannak tartva. Ne féljetek tehát: Ti sok verébnél értékesebbek vagytok. ");
INSERT INTO hun_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Mondom nektek: Ha valaki vallást tesz rólam az emberek előtt, az Emberfia is vallást tesz arról Isten angyalai előtt. ");
INSERT INTO hun_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Aki pedig megtagad engem az emberek előtt, azt én is megtagadom Isten angyalai előtt. ");
INSERT INTO hun_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","És ha valaki valamit mond az Emberfia ellen, bocsánatot nyer, de aki a Szentlelket káromolja, nem nyer bocsánatot. ");
INSERT INTO hun_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Amikor a zsinagógákba és a fejedelmek és hatalmasságok elé hurcolnak titeket, ne aggodalmaskodjatok, hogyan vagy mit szóljatok védelmetekre, vagy mit mondjatok. ");
INSERT INTO hun_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Mert a Szentlélek abban az órában megtanít titeket, hogy mit kell mondanotok.“ ");
INSERT INTO hun_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ekkor így szólt hozzá valaki a sokaságból: „Mester, mondd meg az én testvéremnek, hogy ossza meg velem az örökséget!“ ");
INSERT INTO hun_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ő pedig így válaszolt: „Ember, ki tett engem bíróvá vagy végrehajtóvá közöttetek?“ ");
INSERT INTO hun_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Azután ezt mondta nekik: „Vigyázzatok, és őrizkedjetek a telhetetlenségtől, mert nem a vagyonban való bővölködés jelenti az életet.“ ");
INSERT INTO hun_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Mondott nekik egy példázatot: „Egy gazdag embernek bőségesen termett a földje ");
INSERT INTO hun_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","ezért így okoskodott magában: Mit cselekedjem? Mert nincs hová betakarítanom termésemet. ");
INSERT INTO hun_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","És ezt mondta: Ezt cselekszem: csűreimet lebontatom, és nagyobbakat építek, és azokba gyűjtöm be gabonámat és javaimat. ");
INSERT INTO hun_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","És ezt mondom lelkemnek: Én lelkem, sok javad van sok esztendőre eltéve, tedd magad kényelembe, egyél, igyál, és élvezd az életet! ");
INSERT INTO hun_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Isten ezt mondta neki: Bolond! Még az éjjel elkérik tőled a te lelkedet, akkor kié lesz mindaz, amit felhalmoztál? ");
INSERT INTO hun_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Így jár mindenki, aki kincset gyűjt magának, és nem Istenben gazdag.“ ");
INSERT INTO hun_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Tanítványainak ezt mondta: „Ezért mondom nektek, ne aggodalmaskodjatok a ti életetek miatt, mit egyetek, se a testetek miatt, mibe öltözködjetek, ");
INSERT INTO hun_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Mert az élet több, mint az eledel és a test, mint az öltözet. ");
INSERT INTO hun_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Nézzétek meg a hollókat! Nem vetnek és nem aratnak, nincs éléskamrájuk, sem csűrük, és Isten eltartja azokat. Mennyivel értékesebbek vagytok ti a madaraknál! ");
INSERT INTO hun_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ki az közületek, aki aggodalmaskodásával akár egy arasznyival is megnövelheti termetét? ");
INSERT INTO hun_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ha pedig ilyen csekélységet sem tudtok megtenni, mit aggodalmaskodtok a többi miatt? ");
INSERT INTO hun_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Nézzétek meg a liliomokat, hogyan növekednek! Nem szőnek és nem fonnak, de mondom nektek, Salamon teljes dicsőségében sem öltözködött úgy, mint egy ezek közül. ");
INSERT INTO hun_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ha pedig a füvet, amely ma a mezőn van, és holnap a kemencébe vetik, így öltözteti Isten, mennyivel inkább titeket, ti kicsinyhitűek! ");
INSERT INTO hun_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ne kérdezzétek tehát: mit egyetek, vagy mit igyatok, és ne nyugtalankodjatok. ");
INSERT INTO hun_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Mindezeket a pogányok kérdezik. A ti Atyátok pedig tudja, hogy nektek szükségetek van ezekre. ");
INSERT INTO hun_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Inkább keressétek Isten országát, és ezeket mind megkapjátok. ");
INSERT INTO hun_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Ne félj, te kicsiny nyáj, mert úgy tetszett a ti Atyátoknak, hogy nektek adja az országot! ");
INSERT INTO hun_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","„Adjátok el, amitek van, és adjátok oda alamizsnaként. Szerezzetek magatoknak erszényeket, amelyek nem avulnak el, kifogyhatatlan kincset a mennyországban, ahol a tolvaj nem fér hozzá, és a moly sem emészti meg. ");
INSERT INTO hun_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Mert ahol a ti kincsetek, ott lesz a szívetek is. ");
INSERT INTO hun_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","„Legyen derekatok felövezve, és lámpásotok meggyújtva. ");
INSERT INTO hun_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ti pedig legyetek hasonlók az olyan emberekhez, akik várják, mikor jön meg uruk a menyegzőről, hogy amint megérkezik és zörget, azonnal ajtót nyissanak neki. ");
INSERT INTO hun_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Boldogok azok a szolgák, akiket az úr, amikor hazamegy, ébren talál. Bizony mondom nektek, hogy felövezi magát, leülteti őket, hozzájuk megy, és felszolgál nekik. ");
INSERT INTO hun_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","És ha a második vagy harmadik őrváltáskor jön meg, és úgy találja őket, boldogok azok a szolgák! ");
INSERT INTO hun_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Azt pedig jegyezzétek meg, hogy ha tudná a ház gazdája, hogy mikor jön a tolvaj, vigyázna, és nem engedné, hogy házába törjön. ");
INSERT INTO hun_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ti is legyetek tehát készen, mert amely órában nem is gondoljátok, abban jön el az Emberfia.“ ");
INSERT INTO hun_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Péter erre megkérdezte: „Uram, nekünk mondod ezt a példázatot vagy mindenkinek?“ ");
INSERT INTO hun_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Az Úr így válaszolt: „Kicsoda hát a hű és bölcs sáfár, akit az úr gondviselővé tett háza népén, hogy idejében adja ki nekik élelmüket? ");
INSERT INTO hun_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Boldog az a szolga, akit az ő ura, amikor hazajön, ilyen munkában talál! ");
INSERT INTO hun_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Bizony mondom néktek, hogy egész vagyona gondviselőjévé teszi. ");
INSERT INTO hun_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ha pedig a szolga így szólna szívében: Halogatja még az én uram a hazajövetelt, és verni kezdi a szolgákat és szolgálóleányokat, és elkezdene enni, és inni és részegeskedni, ");
INSERT INTO hun_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","megjön annak a szolgának az ura, amely napon nem várja, és amely órában nem gondolja, és kettévágatja, és a hitetlenek sorsára juttatja. ");
INSERT INTO hun_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Az a szolga, aki ismerte ura akaratát, és nem teljesítette, és nem cselekedett akarata szerint, sok verést kap. ");
INSERT INTO hun_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Aki pedig nem ismerte, és büntetésre méltó dolgokat cselekedett, az kevés verést kap. Akinek sokat adtak, attól sokat követelnek. Akire sokat bíztak, attól többet kívánnak. ");
INSERT INTO hun_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Azért jöttem, hogy tüzet bocsássak a világra. Mennyire szeretném, ha már lángolna! ");
INSERT INTO hun_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Keresztséggel kell még megkereszteltetnem, és mennyire szorongok, míg végbe nem megy. ");
INSERT INTO hun_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Azt gondoljátok, hogy azért jöttem, hogy békességet hozzak a földre? Mondom nektek: egyáltalán nem, sőt inkább ellentétet. ");
INSERT INTO hun_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Mert mostantól fogva, ha öten lesznek egy házban, ellentétbe kerülnek egymással: három kettő ellen és kettő három ellen. ");
INSERT INTO hun_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ellentétbe kerül az apa a fiával és a fiú az apjával és az anya a leányával és leány az anyjával, az anyós a menyével és a meny az anyósával.“ ");
INSERT INTO hun_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","A sokaságnak ezt mondta: „Amikor látjátok, hogy napnyugatról felhő támad, azonnal ezt mondjátok: Záporeső jön, és úgy lesz. ");
INSERT INTO hun_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","És amikor halljátok fújni a déli szelet, ezt mondjátok: Hőség lesz, és úgy lesz. ");
INSERT INTO hun_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Képmutatók! Az égnek és földnek jeleit felismeritek, ezt az időt pedig miért nem tudjátok felismerni? ");
INSERT INTO hun_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","„Miért nem ítélitek meg magatoktól is azt, hogy mi a helyes? ");
INSERT INTO hun_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Amikor pedig ellenfeleddel a hatóság elé mégy, igyekezzél még az úton megszabadulni tőle, hogy ne hurcoljon a bíró elé, és a bíró át ne adjon a börtönőrnek, a börtönőr tömlöcbe ne vessen. ");
INSERT INTO hun_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Mondom neked, hogy nem jössz ki onnan, amíg meg nem adod az utolsó fillért is.“ ");
INSERT INTO hun_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Éppen abban az időben jöttek oda néhányan, akik neki hírt hoztak a galileaiakról, akiknek vérét Pilátus áldozatukéval elegyítette. ");
INSERT INTO hun_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jézus ezt mondta nekik: „Gondoljátok, hogy ezek a galileaiak bűnösebbek voltak valamennyi galileainál, mert ezt szenvedték el? ");
INSERT INTO hun_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Mondom nektek: Nem! Sőt, ha meg nem tértek, mindnyájan hasonlóképpen elvesztek. ");
INSERT INTO hun_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Vagy az a tizennyolc, akikre rászakadt a torony Siloámban, és megölte őket, gondoljátok, hogy bűnösebbek voltak minden más Jeruzsálemben lakó embernél? ");
INSERT INTO hun_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Mondom nektek: Nem! Sőt, ha meg nem tértek mindnyájan hasonlóképpen elvesztek.“ ");
INSERT INTO hun_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","És ezt a példázatot mondta: „Egy embernek volt egy fügefája szőlőjében, és elment, hogy azon gyümölcsöt keressen, de nem talált. ");
INSERT INTO hun_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ezt mondta a vincellérnek: Íme, három esztendeje, hogy ide járok gyümölcsöt keresni ezen a fügefán, és nem találok. Vágd ki, miért foglalja a földet is hiába? ");
INSERT INTO hun_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","De az így válaszolt neki: Uram, hagyd meg még ebben az esztendőben, míg köröskörül megkapálom és megtrágyázom. ");
INSERT INTO hun_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Hátha jövőre terem. Ha pedig nem, azután vágd ki.“ ");
INSERT INTO hun_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Egy zsinagógában tanított szombaton, ");
INSERT INTO hun_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","és íme, volt ott egy asszony, akiben betegség lelke volt tizennyolc esztendő óta, és meg volt görnyedve, és egyáltalán nem tudott felegyenesedni. ");
INSERT INTO hun_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Amikor Jézus meglátta, odahívta, és ezt mondta neki: „Asszony, megszabadultál betegségedtől!“ ");
INSERT INTO hun_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","És rátette kezét, mire az nyomban felegyenesedett, és dicsőítette Istent. ");
INSERT INTO hun_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Megszólalt a zsinagóga elöljárója felháborodva azon, hogy Jézus szombatnapon gyógyított, ezt mondta a sokaságnak: „Hat nap van, amelyen munkálkodni kell. Tehát azokon jöjjetek gyógyíttatni magatokat és ne szombatnapon.“ ");
INSERT INTO hun_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Az Úr így válaszolt neki: „Képmutatók, vajon szombatnapon nem oldja-e el mindegyikőtök ökrét vagy szamarát a jászoltól, és nem vezeti-e itatni? ");
INSERT INTO hun_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Hát Ábrahámnak ezt a leányát, akit a sátán megkötözött tizennyolc esztendeje, nem kellett-e feloldani ebből a kötelékből szombatnapon?“ ");
INSERT INTO hun_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Amikor ezeket mondta, ellenfelei mindnyájan megszégyenültek, és az egész sokaság örült azoknak a dicsőséges dolgoknak, amelyek általa történtek. ");
INSERT INTO hun_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Azután így szólt Jézus: „Mihez hasonló Isten országa? Mihez hasonlítsam? ");
INSERT INTO hun_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Hasonló a mustármaghoz, amelyet fogott egy ember, és elvetette a kertjében, és az felnőtt, és nagy fává lett, és az égi madarak fészket raktak ágain.“ ");
INSERT INTO hun_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Majd ismét szólt: „Mihez hasonlítsam Isten országát? ");
INSERT INTO hun_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Hasonló a kovászhoz, amelyet fogott egy asszony, három mérce lisztbe keverte, míg végül az egész megkelt.“ ");
INSERT INTO hun_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Városokon és falvakon ment át, úton Jeruzsálem felé, miközben tanított. ");
INSERT INTO hun_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ezt mondta neki valaki: „Uram, kevesen vannak-e, akik üdvözülnek?“ Ő pedig ezt mondta neki: ");
INSERT INTO hun_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","„Igyekezzetek bemenni a szoros kapun, mert mondom nektek, sokan igyekeznek majd bemenni, de nem mehetnek. ");
INSERT INTO hun_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Amikor fölkel a gazda, és bezárja az ajtót, ti kívül álltok, és kezditek zörgetni az ajtót, és így szóltok: Uram! Uram! Nyisd ki nekünk! Ő így felel nektek: Nem tudom, honnan valók vagytok! ");
INSERT INTO hun_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Akkor majd elkezditek mondani: Előtted ettünk, ittunk, és az utcáinkon tanítottál. ");
INSERT INTO hun_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Erre ő így szól: Mondom nektek, nem tudom, honnan valók vagytok. Távozzatok tőlem mindnyájan, ti gonosztevők! ");
INSERT INTO hun_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Akkor lesz sírás és fogcsikorgatás, amikor látjátok Ábrahámot, Izsákot, Jákóbot és a prófétákat mind Isten országában, magatokat pedig kirekesztve onnan. ");
INSERT INTO hun_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","És jönnek napkeletről és napnyugatról, északról és délről, és Isten országában letelepednek. ");
INSERT INTO hun_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","És íme, vannak utolsók, akik elsők lesznek, és vannak elsők, akik utolsók lesznek.“ ");
INSERT INTO hun_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ugyanabban az órában néhány farizeus ment hozzá, akik így szóltak: „Eredj el, és távozz innen, mert Heródes meg akar téged ölni.“ ");
INSERT INTO hun_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ő ezt mondta nekik: „Menjetek, és mondjátok meg annak a rókának: Íme, ördögöket űzök ki és gyógyítok ma és holnap, és harmadnapra befejezem. ");
INSERT INTO hun_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","De ma, holnap és azután úton kell lennem, mert nem lehet, hogy a próféta Jeruzsálemen kívül vesszen el. ");
INSERT INTO hun_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","„Jeruzsálem! Jeruzsálem, aki megölöd a prófétákat, és megkövezed azokat, akik hozzád küldettek, hányszor akartam egybegyűjteni gyermekeidet, mint a tyúk kiscsirkéit a szárnya alá, de ti nem akartátok! ");
INSERT INTO hun_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Íme, elhagyott lesz a házatok. Bizony mondom néktek, hogy nem láttok engem, amíg el nem jön az az idő, amikor ezt mondjátok: »Áldott, aki jön az Úr nevében!«“ ");
INSERT INTO hun_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Történt, amikor bement a farizeusok egyik vezetőjének házába szombaton ebédelni, azok figyelték őt. ");
INSERT INTO hun_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","És íme, egy vízkóros ember volt előtte. ");
INSERT INTO hun_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ekkor Jézus megszólalt, és megkérdezte a törvénytudóktól és farizeusoktól: „Szabad-e szombatnapon gyógyítani?“ ");
INSERT INTO hun_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Azok pedig hallgattak. Erre megfogta azt, meggyógyította és elbocsátotta. ");
INSERT INTO hun_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Nekik pedig ezt mondta: „Ki az közületek, akinek szamara vagy ökre szombatnapon kútba esik, és nem húzza ki azt azonnal?“ ");
INSERT INTO hun_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","De azok nem tudtak erre mit felelni. ");
INSERT INTO hun_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Egy példázatot is mondott a meghívottaknak, amikor észrevette, hogyan válogatják a főhelyeket. Ezt mondta nekik: ");
INSERT INTO hun_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","„Amikor valaki lakodalomba hív, ne ülj a főhelyre, mert talán nálad nagyobb tiszteletben álló embert is meghívott. ");
INSERT INTO hun_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","És odamegy az, aki mind téged, mind azt meghívta, ezt mondja majd neked: Engedd át ennek a helyet! És akkor szégyenkezve az utolsó helyre fogsz ülni. ");
INSERT INTO hun_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Hanem ha meghívnak, menj el, és ülj le az utolsó helyre, hogy amikor odamegy, aki téged meghívott, ezt mondja neked: Barátom, ülj feljebb! Akkor becsületed lesz azok előtt, akik veled együtt ülnek. ");
INSERT INTO hun_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Mert mindenki, aki magát felmagasztalja, megaláztatik, aki pedig megalázza magát, felmagasztaltatik.“ ");
INSERT INTO hun_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Szólt akkor annak is, aki őt meghívta: „Amikor ebédet vagy vacsorát készítesz, ne barátaidat, testvéreidet, rokonaidat, gazdag szomszédaidat hívd meg, hogy majd azok is viszonzásul meghívjanak téged. ");
INSERT INTO hun_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Hanem amikor lakomát készítesz, hívd meg a szegényeket, csonkabonkákat, sántákat, vakokat, ");
INSERT INTO hun_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","és boldog leszel, mert azok nem tudják viszonozni, de majd viszonozzák neked az igazak feltámadásakor.“ ");
INSERT INTO hun_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Amikor ezeket meghallotta valaki, aki vele együtt ült, ezt mondta neki: „Boldog az, aki kenyeret eszik Isten országában.“ ");
INSERT INTO hun_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ő pedig ezt mondta annak: „Egy ember nagy vacsorát készített, és sokakat meghívott. ");
INSERT INTO hun_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","És elküldte szolgáját a vacsora idején, hogy mondja meg a meghívottaknak: Jöjjetek, mert már minden kész! ");
INSERT INTO hun_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","És mindnyájan egyformán kezdték magukat kimenteni. Az első ezt mondta neki: Szántóföldet vettem, és ki kell mennem, hogy megnézzem, kérlek téged, ments ki engem! ");
INSERT INTO hun_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","A másik ezt mondta: Öt iga ökröt vettem, és elmegyek, hogy azokat kipróbáljam, kérlek téged, ments ki engem! ");
INSERT INTO hun_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Megint egy másik ezt mondta: Most nősültem, és azért nem mehetek. ");
INSERT INTO hun_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Amikor a szolga hazament, megmondta ezeket az ő urának. Akkor megharagudott a gazda, és ezt mondta szolgájának: Eredj hamar a város utjaira, és utcáira és hozd be ide a szegényeket, csonkabonkákat, sántákat és vakokat. ");
INSERT INTO hun_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","És szólt a szolga: Uram, meglett, amint parancsoltad, és mégis van hely. ");
INSERT INTO hun_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Akkor ezt mondta az úr a szolgának: Eredj el az utakra és a kerítésekhez, és kényszeríts bejönni mindenkit, hogy megteljék az én házam. ");
INSERT INTO hun_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Mert mondom nektek, hogy azok közül, akiket meghívtam, senki sem kóstolja meg a vacsorámat.“ ");
INSERT INTO hun_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Nagy sokaság ment vele, és amikor megfordult, ezt mondta nekik: ");
INSERT INTO hun_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","„Ha valaki hozzám jön, és meg nem gyűlöli az atyját és anyját, feleségét és gyermekeit, fitestvérét és nőtestvérét, sőt még a maga lelkét is, nem lehet az én tanítványom. ");
INSERT INTO hun_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","És aki nem hordozza keresztjét, és nem jön utánam, nem lehet az én tanítványom. ");
INSERT INTO hun_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","„Mert ki az közületek, aki tornyot akar építeni, és először nem ül le, hogy kiszámítsa a költségeket, hogy van-e, amiből befejezze? ");
INSERT INTO hun_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Nehogy, miután fundamentumot vetett, és nem tudja befejezni, csúfolni kezdje őt mindenki, aki csak látja. ");
INSERT INTO hun_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","És ezt mondják: Ez az ember elkezdte az építkezést, de nem tudta befejezni! ");
INSERT INTO hun_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Vagy ha egy király, amikor háborúba megy, hogy egy másik királlyal harcba szálljon, nem ül-e le először tanácskozni, hogy tízezerrel szembeszállhat-e azzal, aki húszezerrel jön ellene? ");
INSERT INTO hun_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Mert különben, amikor az még távol van, követséget küld, és megkérdezi a békefeltételeket. ");
INSERT INTO hun_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Így tehát, ha valaki búcsút nem vesz minden vagyonától, nem lehet az én tanítványom. ");
INSERT INTO hun_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Jó a só, de ha a só ízét veszti, mivel sózzák meg? ");
INSERT INTO hun_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Sem a földre, sem a trágyára nem alkalmas, tehát kidobják. Akinek van füle a hallásra, hallja!“ ");
INSERT INTO hun_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","A vámszedők és a bűnösök mindnyájan hozzá mentek, hogy hallgassák őt. ");
INSERT INTO hun_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","A farizeusok és az írástudók pedig így zúgolódtak: „Bűnösöket fogad magához, és velük együtt eszik.“ ");
INSERT INTO hun_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ő pedig ezt a példázatot mondta nekik: ");
INSERT INTO hun_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","„Kicsoda az közületek, akinek ha száz juha van, és egyet azok közül elveszít, nem hagyja ott a kilencvenkilencet a pusztában, és nem megy az elveszett után, míg meg nem találja azt? ");
INSERT INTO hun_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","És ha megtalálta, örömében felveszi vállára. ");
INSERT INTO hun_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","És hazamenve, összehívja barátait és szomszédait, és ezt mondja nekik: Örüljetek velem, mert megtaláltam juhomat, amely elveszett. ");
INSERT INTO hun_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Mondom nektek, hogy ugyanígy nagyobb öröm lesz a mennyben egy megtérő bűnösön, mint kilencvenkilenc igaz emberen, akinek nincs szüksége megtérésre. ");
INSERT INTO hun_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","„Vagy ha egy asszonynak tíz drahmája van, és elveszít egy drahmát, nem gyújt-e lámpást, nem söpri-e ki a házat, és nem keresi-e gondosan, míg meg nem találja? ");
INSERT INTO hun_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","És ha megtalálta, összehívja barátnőit és szomszédait, és így szól: Örüljetek velem, mert megtaláltam a drahmát, amit elveszítettem! ");
INSERT INTO hun_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Mondom nektek, ugyanígy öröm van Isten angyalainak színe előtt egy bűnös ember megtérésén.“ ");
INSERT INTO hun_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Azután ezt mondta: „Egy embernek volt két fia. ");
INSERT INTO hun_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","És az ifjabb azt mondta atyjának: Atyám, add ki a vagyonból a rám eső részt. És ő megosztotta közöttük a vagyont. ");
INSERT INTO hun_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Nem sok nap múlva a kisebbik fiú összeszedte mindenét, és messze vidékre költözött, és ott eltékozolta minden vagyonát, mert kicsapongó életet élt. ");
INSERT INTO hun_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Miután mindenét elköltötte, nagy ínség támadt azon a vidéken, úgyhogy nélkülözni kezdett. ");
INSERT INTO hun_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ekkor elment, és elszegődött annak a vidéknek egyik polgárához, aki elküldte őt mezőjére disznókat legeltetni. ");
INSERT INTO hun_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ő pedig szívesen megtöltötte volna gyomrát azzal a moslékkal, amit a disznók ettek, de senki sem adott neki. ");
INSERT INTO hun_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Amikor magába szállt, ezt mondta: Az én atyámnak milyen sok bérese bővölködik kenyérben, én pedig éhen halok! ");
INSERT INTO hun_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Felkelek, és elmegyek az én atyámhoz, és ezt mondom neki: Atyám, vétkeztem az ég ellen és teellened, ");
INSERT INTO hun_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","és nem vagyok méltó, hogy fiadnak nevezz. Tégy engem olyanná, mint a te béreseid közül egy! ");
INSERT INTO hun_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Felkelt, és elment atyjához. Amikor pedig még távol volt, meglátta őt az ő atyja, és megesett rajta a szíve, és hozzáfutott, nyakába borult, és megcsókolta. ");
INSERT INTO hun_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","A fiú ezt mondta neki: Atyám, vétkeztem az ég ellen és teellened. Nem vagyok immár méltó, hogy fiadnak nevezz. ");
INSERT INTO hun_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Atyja pedig ezt mondta szolgáinak: Hozzátok ki a legszebb ruhát, és adjátok föl rá, és húzzatok gyűrűt a kezére és sarut a lábára! ");
INSERT INTO hun_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","És hozzátok elő a hízott tulkot, és vágjátok le, és együnk és vigadjunk. ");
INSERT INTO hun_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Mert az én fiam meghalt és feltámadott és elveszett és megtaláltatott. Elkezdtek azért vigadozni. ");
INSERT INTO hun_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Az ő nagyobbik fia pedig a mezőn volt. És amikor hazajött, és közeledett a házhoz, hallotta a zenét és a táncot. ");
INSERT INTO hun_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Előhívott egyet a szolgái közül, és megtudakolta, mi történt. ");
INSERT INTO hun_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Mire az így felelt: A te öcséd jött meg, és atyád levágatta a hízott tulkot, mivel egészségben kapta vissza. ");
INSERT INTO hun_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Erre ő megharagudott, és nem akart bemenni. De az Atyja kiment, és kérlelni kezdte. ");
INSERT INTO hun_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ő pedig így válaszolt atyjának: Íme, én ennyi éve szolgálok neked, és soha át nem hágtam parancsaidat, és nekem egy kecskefiat sem adtál, hogy az én barátaimmal vigadjak. ");
INSERT INTO hun_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Amikor pedig ez a te fiad megjött, aki paráznákkal tékozolta el a vagyonodat, levágattad neki a hizlalt tulkot. ");
INSERT INTO hun_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ő pedig azt mondta neki: Fiam, te mindenkor velem vagy, és mindenem a tied! ");
INSERT INTO hun_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Vigadnod és örülnöd kellene, hogy a te testvéred meghalt és feltámadt, elveszett és megtaláltatott.“ ");
INSERT INTO hun_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Azután ezt mondta tanítványainak: „Volt egy gazdag ember, akinek volt egy sáfára, akit bevádoltak nála, hogy javait eltékozolja. ");
INSERT INTO hun_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Hívatta azért, és ezt mondta neki: Mit hallok felőled? Adj számot sáfárságodról, mert nem lehetsz többé sáfár. ");
INSERT INTO hun_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","A sáfár ezt mondta magában: Mit tegyek, mert az én uram elveszi tőlem a sáfárságot? Kapálni nem tudok, koldulni szégyellek. ");
INSERT INTO hun_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Tudom már, mit tegyek, hogy amikor a sáfárságtól megfosztanak, befogadjanak házukba az emberek. ");
INSERT INTO hun_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Magához hívatta urának minden adósát, és ezt mondta az elsőnek: Mennyivel tartozol az én uramnak? ");
INSERT INTO hun_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Az így felelt: Száz korsó olajjal. Erre ezt mondta neki: Vedd az adósleveledet, ülj le gyorsan, és írj ötvenet. ");
INSERT INTO hun_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Aztán szólt a másiknak: Te pedig mennyivel tartozol? Az pedig így felelt: Száz mérő búzával. Így szólt hozzá: Vedd az adósleveledet, és írj nyolcvanat. ");
INSERT INTO hun_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","És megdicsérte az Úr a hamis sáfárt, hogy eszesen cselekedet, mert e világnak fiai a maguk nemében eszesebbek a világosság fiainál. ");
INSERT INTO hun_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Én is mondom nektek: szerezzetek magatoknak barátokat a hamis mammonnal, hogy amikor elfogy, befogadjanak titeket az örök hajlékokba. ");
INSERT INTO hun_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Aki kevesen hű, a sokon is hű az. Aki kevesen hamis, a sokon is hamis az. ");
INSERT INTO hun_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ha a hamis mammonon nem voltatok hűek, ki bízná rátok az igazi kincset? ");
INSERT INTO hun_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ha a másén nem voltatok hűek, ki adja oda nektek azt, ami a tiétek? ");
INSERT INTO hun_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","„Egy szolga sem szolgálhat két úrnak, mert vagy az egyiket gyűlöli, és a másikat szereti, vagy az egyikhez ragaszkodik, és a másikat megveti. Nem szolgálhattok Istennek és a mammonnak.“ ");
INSERT INTO hun_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Hallották mindezt a farizeusok is, akik pénzsóvárak voltak, és kigúnyolták őt. ");
INSERT INTO hun_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ezt mondta nekik: „Ti vagytok azok, akik az emberek előtt igaznak tartjátok magatokat, de Isten ismeri szíveteket, mert ami az emberek előtt magasztos, az Isten előtt utálatos. ");
INSERT INTO hun_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","A törvény és a próféták Keresztelő Jánosig tartottak. Azóta Isten országát hirdetik, és mindenki erejét megfeszítve törekszik feléje. ");
INSERT INTO hun_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","De hamarább elmúlik a menny és a föld, mint hogy a törvényből egyetlen vessző elveszhetne. ");
INSERT INTO hun_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Ha valaki elbocsátja feleségét, és mást vesz el, házasságtörő, és aki férjétől elbocsátott asszonyt vesz feleségül, az is házasságtörő. ");
INSERT INTO hun_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","„Volt egy gazdag ember, aki bíborba és gyolcsba öltözködött, és minden nap dúsan lakmározott. ");
INSERT INTO hun_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","És volt egy Lázár nevű koldus, aki kapuja előtt feküdt, és fekélyekkel volt tele, ");
INSERT INTO hun_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","és szeretett volna jóllakni a gazdag asztaláról lehulló morzsákkal, de csak a kutyák jöttek hozzá, és nyaldosták sebeit. ");
INSERT INTO hun_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Történt pedig, hogy meghalt a koldus, és az angyalok Ábrahám ölébe vitték. Meghalt a gazdag, is és eltemették. ");
INSERT INTO hun_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","És a pokolban kínok között föltekintett, meglátta távol Ábrahámot és kebelén Lázárt. ");
INSERT INTO hun_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Felkiáltott, és ezt mondta: Atyám, Ábrahám! Könyörülj rajtam, és küldd el Lázárt, hogy mártsa ujja hegyét vízbe, és hűsítse meg nyelvemet, mert gyötrődöm ebben a lángban. ");
INSERT INTO hun_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ábrahám így válaszolt: Fiam, emlékezz arra, hogy te megkaptad javaidat életedben, hasonlóképpen Lázár is bajait. Most ő vigasztalódik, te pedig gyötrődsz. ");
INSERT INTO hun_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ezenfelül köztünk és közöttetek nagy szakadék van, úgyhogy akik innen hozzátok akarnának menni, nem mehetnek, sem azok onnét hozzánk nem jöhetnek. ");
INSERT INTO hun_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Mire az így szólt: Kérlek azért téged, atyám, hogy küldd el őt az én atyám házához. ");
INSERT INTO hun_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Mert van öt testvérem, hogy bizonyságot tegyen nekik, hogy ők is ide, a gyötrelem helyére ne kerüljenek. ");
INSERT INTO hun_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ábrahám így szólt: Van Mózesük, és vannak prófétáik, hallgassanak azokra! ");
INSERT INTO hun_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","De erre az ezt mondta: Nem úgy, atyám, Ábrahám, de ha a halottak közül megy valaki hozzájuk, megtérnek! ");
INSERT INTO hun_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ő pedig így válaszolt: Ha Mózesre és a prófétákra nem hallgatnak, az sem győzi meg őket, ha valaki a halottak közül feltámad.“ ");
INSERT INTO hun_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ezt mondta a tanítványoknak: „Lehetetlen, hogy botránkozások ne történjenek, de jaj annak, aki ilyeneket okoz. ");
INSERT INTO hun_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Jobb annak, ha malomkövet kötnek a nyakára, és a tengerbe dobják, mintha csak egyet is megbotránkoztat e kicsinyek közül. ");
INSERT INTO hun_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Vigyázzatok magatokra!“ „Ha pedig a te atyádfia vétkezik ellened, fedd meg, és ha megbánja, bocsáss meg neki. ");
INSERT INTO hun_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","És ha egy napon hétszer is vétkezik ellened, és egy napon hétszer tér vissza hozzád ezt mondva: Megbántam – bocsáss meg neki.“ ");
INSERT INTO hun_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Az apostolok ezt mondták az Úrnak: „Növeld hitünket!“ ");
INSERT INTO hun_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ezt mondta az Úr: „Ha annyi hitetek volna, mint a mustármag, és ezt mondanátok ennek az eperfának: Szakadj ki gyökerestől, és gyökerezz meg a tengerben, az engedelmeskedne nektek. ");
INSERT INTO hun_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","„Ki az közületek, akinek ha van egy szolgája, és az szánt vagy legeltet, és megjön a mezőről, mindjárt azt mondja neki: Jöjj, és ülj az asztalhoz? ");
INSERT INTO hun_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Nem azt mondja-e inkább neki: Készíts vacsorát, és övezd fel magad, és szolgálj nekem, míg én eszem és iszom, te pedig azután egyél és igyál!? ");
INSERT INTO hun_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Vajon megköszöni-e annak a szolgának, hogy azt tette, amit neki parancsolt? Nem gondolom. ");
INSERT INTO hun_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Hasonlóképpen ti is, ha mindazt megtették, amit parancsoltak nektek, mondjátok: Haszontalan szolgák vagyunk, mert csak azt tettük, ami kötelességünk volt.“ ");
INSERT INTO hun_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Történt, amikor útban volt Jeruzsálem felé, átment Samária és Galilea között. ");
INSERT INTO hun_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Amikor egy faluba ért, tíz leprás férfi jött elé, akik távol megálltak, ");
INSERT INTO hun_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","és hangosan ezt kiáltották: „Jézus, Mester, könyörülj rajtunk!“ ");
INSERT INTO hun_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Amikor meglátta őket, ezt mondta: „Menjetek el, mutassátok meg magatokat a papoknak.“ És történt, hogy míg odamentek, megtisztultak. ");
INSERT INTO hun_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Egy pedig közülük, amikor látta, hogy meggyógyult, visszatért, és hangosan dicsőítette Istent. ");
INSERT INTO hun_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Lába elé borulva adott hálát. Ez pedig samáriai volt. ");
INSERT INTO hun_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jézus ekkor így szólt: „Nem tízen tisztultak meg? Hol van a többi kilenc? ");
INSERT INTO hun_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Nem akadt más, aki visszatért volna dicsőséget adni Istennek, csak ez az egy idegen?“ ");
INSERT INTO hun_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","És ezt mondta neki: „Kelj fel, menj el, a te hited megtartott téged.“ ");
INSERT INTO hun_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Amikor megkérdezték a farizeusok, hogy mikor jön el Isten országa, így felelt nekik: „Isten országa nem szemmel láthatóan jön el. ");
INSERT INTO hun_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Sem azt nem mondják: Íme, itt, vagy íme, ott van, mert Isten országa bennetek van!“ ");
INSERT INTO hun_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","A tanítványoknak pedig ezt mondta: „Eljön az idő, amikor szeretnétek egyet látni az Emberfia napjai közül, de nem láttok. ");
INSERT INTO hun_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Mondják majd nektek: Íme, itt, vagy íme, ott van, de ne menjetek oda, és ne fussatok utána. ");
INSERT INTO hun_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Mert amint a felvillanó villámlás az ég aljától az ég aljáig fénylik, úgy jön el az Emberfia az ő napján. ");
INSERT INTO hun_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","De előbb sokat kell szenvednie és megvettetnie ettől a nemzedéktől. ");
INSERT INTO hun_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","És amint Nóé napjaiban történt, úgy lesz az Emberfia napjaiban is. ");
INSERT INTO hun_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ettek, ittak, megnősültek, férjhez mentek addig a napig, amíg Nóé be nem ment a bárkába, és eljött az özönvíz, és elpusztított mindenkit. ");
INSERT INTO hun_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Hasonlóképpen, ahogy Lót napjaiban is volt: ettek, ittak, vettek, adtak, ültettek, építettek, ");
INSERT INTO hun_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","de azon a napon, amikor Lót kiment Sodomából, tűz és kénkő esett az égből, és elpusztított mindenkit. ");
INSERT INTO hun_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Így lesz azon a napon is, amelyen az Emberfia megjelenik. ");
INSERT INTO hun_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Azon a napon, aki a háztetőn lesz, holmija pedig a házban, ne menjen le, hogy elvigye. És aki a mezőn lesz, ne forduljon vissza. ");
INSERT INTO hun_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Emlékezzetek Lót feleségére! ");
INSERT INTO hun_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Aki meg akarja tartani életét, elveszti azt, és aki elveszti, megtartja azt. ");
INSERT INTO hun_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Mondom nektek: azon az éjszakán ketten lesznek egy ágyban, az egyik felvétetik, a másik ott hagyatik. ");
INSERT INTO hun_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Két asszony őröl együtt, az egyik felvétetik, a másik otthagyatik. ");
INSERT INTO hun_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ketten lesznek a mezőn, az egyik felvétetik, a másik otthagyatik.“ ");
INSERT INTO hun_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Azok ezt mondták neki: „Hol, Urunk?“ Ő pedig így válaszolt: „Ahol a tetem, oda gyűlnek a saskeselyűk.“ ");
INSERT INTO hun_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Egy példázatot is mondott nekik arról, hogy mindig imádkozni kell, és nem szabad belefáradni. ");
INSERT INTO hun_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ezt mondta: „Volt egy bíró egy városban, aki Istent nem félte, az embereket nem becsülte. ");
INSERT INTO hun_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Abban a városban volt egy özvegyasszony is, aki elment hozzá, és ezt mondta: Szolgáltass nekem igazságot ellenfelemmel szemben. ");
INSERT INTO hun_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Az egy ideig nem akarta, de azután ezt mondta magában: Noha Istent nem félem, az embereket sem becsülöm, ");
INSERT INTO hun_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","mégis mivel terhemre van nekem ez az özvegyasszony, igazságot szolgáltatok neki, hogy ne járjon ide, és ne gyötörjön engem.“ ");
INSERT INTO hun_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ezt mondta az Úr: „Halljátok, mit mond a hamis bíró? ");
INSERT INTO hun_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Vajon Isten nem szolgáltat-e igazságot az ő választottainak, akik hozzá kiáltanak éjjel és nappal? És várakoztatja-e őket? ");
INSERT INTO hun_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Mondom néktek, hogy igazságot szolgáltat nekik hamar. De amikor eljön az Emberfia, talál-e hitet a földön?“ ");
INSERT INTO hun_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Némelyeknek, akik elbizakodtak, hogy ők igazak, és a többieket semmibe se vették, ezt a példázatot mondta: ");
INSERT INTO hun_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","„Két ember ment a templomba imádkozni. Az egyik farizeus, és a másik vámszedő. ");
INSERT INTO hun_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","A farizeus megállt, és így imádkozott magában: Isten! Hálát adok neked, hogy nem vagyok olyan, mint a többi ember, rabló, gonosz, parázna, vagy mint ez a vámszedő is. ");
INSERT INTO hun_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Böjtölök kétszer egy héten, tizedet adok mindenből, amit szerzek. ");
INSERT INTO hun_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","A vámszedő pedig távol állva, még szemét sem akarta az égre emelni, hanem mellét verte, és ezt mondta: Isten, légy irgalmas nekem, bűnösnek. ");
INSERT INTO hun_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Mondom nektek, ez megigazulva ment haza, nem úgy, mint amaz. Mert aki felmagasztalja magát, megaláztatik, aki pedig megalázza magát, felmagasztaltatik.“ ");
INSERT INTO hun_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Kisgyermekeket is vittek hozzá, hogy kezét rájuk tegye. Amikor a tanítványok ezt látták, rájuk szóltak. ");
INSERT INTO hun_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","De Jézus magához hívta őket, és ezt mondta: „Engedjétek, hogy a kisgyermekek hozzám jöjjenek, és ne tiltsátok el őket, mert ilyeneké az Isten országa. ");
INSERT INTO hun_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Bizony mondom néktek, aki nem úgy fogadja Isten országát, mint gyermek, semmiképpen nem megy be abba.“ ");
INSERT INTO hun_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Egy előkelő ember megkérdezte őt: Jó Mester, mit cselekedjem, hogy az örök életet elnyerjem? ");
INSERT INTO hun_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jézus ezt mondta neki: „Miért mondasz engem jónak? Senki sem jó, csak egy, az Isten. ");
INSERT INTO hun_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","A parancsolatokat tudod: »Ne paráználkodj, ne ölj, ne lopj, hamis tanúbizonyságot ne tégy, tiszteld atyádat, anyádat!«“ ");
INSERT INTO hun_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ő pedig ezt mondta: „Mindezeket ifjúságomtól fogva megtartottam.“ ");
INSERT INTO hun_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jézus ezt hallva, ezt mondta neki: „Még egy fogyatkozásod van: Add el minden vagyonodat, oszd szét a szegényeknek, és kincsed lesz a mennyben, jöjj, és kövess engem.“ ");
INSERT INTO hun_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Az pedig, amikor ezt meghallotta, elszomorodott, mert igen gazdag volt. ");
INSERT INTO hun_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Amikor Jézus látta, hogy elszomorodott, ezt mondta: „Milyen nehezen mennek be Isten országába azok, akik gazdagok. ");
INSERT INTO hun_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Mert könnyebb a tevének a tű fokán átmenni, mint a gazdagnak Isten országába bejutni.“ ");
INSERT INTO hun_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Akik pedig ezt hallották, ezt mondták: „Ki üdvözülhet akkor?“ ");
INSERT INTO hun_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ő pedig ezt mondta: „Ami embereknél lehetetlen, Istennél lehetséges!“ ");
INSERT INTO hun_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ekkor Péter így szólt: „Íme, mi mindent elhagytunk, és követtünk Téged!“ ");
INSERT INTO hun_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ő pedig ezt mondta nekik: „Bizony mondom nektek, hogy senki sincs, aki elhagyta házát vagy szüleit, vagy testvéreit, vagy feleségét, vagy gyermekeit az Isten országáért, ");
INSERT INTO hun_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","hogy ne kapná vissza sokszorosan ebben az időben, a jövendő világban pedig az örök életet.“ ");
INSERT INTO hun_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Maga mellé vette a tizenkettőt, és ezt mondta nekik: „Íme, felmegyünk Jeruzsálembe, és beteljesedik minden az Emberfián, amit a próféták megírtak. ");
INSERT INTO hun_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Mert a pogányok kezébe adják, megcsúfolják, meggyalázzák és megköpdösik, ");
INSERT INTO hun_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","és miután megostorozták, megölik, de harmadnap feltámad.“ ");
INSERT INTO hun_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ők azonban ezekből semmit sem értettek. Ez a beszéd rejtve maradt előttük, és nem fogták fel a mondottakat. ");
INSERT INTO hun_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Történt pedig, hogy amikor Jerikóhoz közeledett, egy vak ült az út mellett, és koldult. ");
INSERT INTO hun_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","És amikor hallotta a mellette elmenő sokaságot, kérdezősködött, hogy mi az. ");
INSERT INTO hun_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Megmondták neki, hogy a názáreti Jézus megy arra. ");
INSERT INTO hun_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ekkor így kiáltott: „Jézus, Dávid Fia, könyörülj rajtam!“ ");
INSERT INTO hun_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Akik pedig elől mentek, rászóltak, hogy hallgasson. De ő annál inkább kiáltott: „Dávid Fia, könyörülj rajtam!“ ");
INSERT INTO hun_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jézus megállt, és megparancsolta, hogy vigyék hozzá. Amikor közelébe ért, megkérdezte tőle: ");
INSERT INTO hun_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","„Mit akarsz, mit tegyek veled?“ Az így szólt: „Uram, hogy a szemem világa megjöjjön.“ ");
INSERT INTO hun_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jézus ezt mondta neki: „Láss, a te hited téged megtartott!“ ");
INSERT INTO hun_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","És azonnal megjött szeme világa, és követte őt, dicsőítve Istent. Az egész sokaság ezt látva dicsőséget adott Istennek. ");
INSERT INTO hun_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Ezután Jerikóba ért, és átment rajta. ");
INSERT INTO hun_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Íme, volt ott egy ember, akit Zákeusnak hívtak, aki fővámszedő volt és gazdag. ");
INSERT INTO hun_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Igyekezett meglátni Jézust, hogy ki az, de a sokaságtól nem láthatta meg, mert kis termetű ember volt. ");
INSERT INTO hun_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ezért előrefutott, és felmászott egy eperfügefára, hogy lássa őt, mert arra kellett elmennie. ");
INSERT INTO hun_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Amikor arra a helyre jutott, Jézus feltekintett, és meglátta, és ezt mondta neki: „Zákeus, hamar jöjj le, mert ma nekem a te házadnál kell megszállnom.“ ");
INSERT INTO hun_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ekkor sietve leszállt, és örömmel befogadta. ");
INSERT INTO hun_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Amikor ezt látták, mindnyájan zúgolódtak, és ezt mondták: „Bűnös emberhez ment be szállásra.“ ");
INSERT INTO hun_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zákeus pedig előállt, ezt mondta az Úrnak: „Uram, íme, minden vagyonomnak felét a szegényeknek adom, és ha valakitől valamit kizsaroltam, négyszer annyit adok helyébe.“ ");
INSERT INTO hun_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jézus ezt mondta neki: „Ma lett üdvössége ennek a háznak, mert ő is Ábrahám fia. ");
INSERT INTO hun_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Mert azért jött az Emberfia, hogy megkeresse és megtartsa, ami elveszett.“ ");
INSERT INTO hun_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Amikor pedig ezeket hallották, még egy példázatot is mondott, mert közel volt Jeruzsálemhez, és azok azt gondolták, hogy azonnal megjelenik Isten országa. ");
INSERT INTO hun_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ezt mondta tehát: „Egy nemesember egy messzi tartományba ment, hogy ott királyságot szerezzen magának, azután majd visszatérjen. ");
INSERT INTO hun_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Hívatta azért tíz szolgáját, és adott nekik tíz minát, és ezt mondta nekik: Kereskedjetek, amíg visszajövök. ");
INSERT INTO hun_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Alattvalói pedig gyűlölték őt, és követséget küldtek utána, és ezt üzenték: Nem akarjuk, hogy ő uralkodjék rajtunk. ");
INSERT INTO hun_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Történt, amikor megszerezte a királyságot, megparancsolta, hogy szolgáit, akiknek a pénzt adta, hívják oda hozzá, hogy megtudja, ki mint kereskedett. ");
INSERT INTO hun_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Eljött az első, és ezt mondta: Uram, a te minád tíz minát nyert. ");
INSERT INTO hun_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ő pedig ezt mondta neki: Jól van, jó szolgám, mivel hű voltál a kevesen, legyen hatalmad tíz város felett. ");
INSERT INTO hun_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","És jött a második, és ezt mondta: Uram, a te minád öt minát nyert. ");
INSERT INTO hun_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Így szólt ennek is: Neked is legyen hatalmad öt város felett. ");
INSERT INTO hun_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","És eljött a harmadik is, és ezt mondta: Uram itt van a te minád, amelyet kendőbe kötve tartottam. ");
INSERT INTO hun_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Mert féltem tőled, mert kemény ember vagy, azt is elveszed, amit nem te tettél el, és learatod, amit nem te vetettél. ");
INSERT INTO hun_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ezt mondta annak: A te szavaid szerint ítéllek meg téged, gonosz szolga. Tudtad, hogy én kemény ember vagyok, aki elveszem, amit nem én tettem el, és learatom, amit nem én vetettem. ");
INSERT INTO hun_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Miért nem tetted azért az én pénzemet a pénzváltók asztalára, hogy amikor megjövök, kamatostul kapjam vissza? ");
INSERT INTO hun_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Az ott állóknak ezt mondta: Vegyétek el ettől a minát, és adjátok annak, akinek tíz minája van. ");
INSERT INTO hun_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","És mondták neki: Uram, annak már van tíz minája! ");
INSERT INTO hun_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","De ő ezt mondta: Mondom nektek, hogy mindenkinek, akinek van, adatik, akinek pedig nincs, még amije van, az is elvétetik tőle. ");
INSERT INTO hun_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ellenségeimet pedig, akik nem akarták, hogy rajtuk uralkodjam, hozzátok ide, és öljétek meg előttem.“ ");
INSERT INTO hun_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Miután ezeket elmondta, továbbment Jeruzsálem felé. ");
INSERT INTO hun_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","És történt, hogy amikor Betfagéhoz és Betániához közeledett, a hegynél, amelyet Olajfák hegyének neveznek, elküldött kettőt tanítványai közül, ");
INSERT INTO hun_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","és ezt mondta nekik: „Menjetek el az átellenben lévő faluba, amelybe beérve találtok egy megkötött szamárcsikót, amelyen még ember nem ült, oldjátok el, és hozzátok ide. ");
INSERT INTO hun_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ha pedig valaki megkérdezi, hogy miért oldjátok el, ezt mondjátok annak: Az Úrnak van szüksége rá.“ ");
INSERT INTO hun_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","A küldöttek elmentek, és mindent úgy találtak, amint megmondta nekik. ");
INSERT INTO hun_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Amikor a szamárcsikót eloldották, annak gazdái ezt mondták: „Miért oldjátok el a szamárcsikót?“ ");
INSERT INTO hun_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ők pedig ezt mondták: „Az Úrnak van szüksége rá.“ ");
INSERT INTO hun_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Elvitték azért azt Jézushoz, és felsőruhájukat a szamárcsikóra tették, és felültették rá Jézust. ");
INSERT INTO hun_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Amint tovább ment, az emberek felsőruhájukat az útra terítették. ");
INSERT INTO hun_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Amikor már az Olajfák lejtőjéhez közeledett, a tanítványok egész sokasága örvendezve, fennhangon kezdte dicsérni Istent mindazokért a csodákért, amelyeket láttak, ");
INSERT INTO hun_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","és ezt mondták: „Áldott a Király, aki az Úr nevében jön! Békesség a mennyben, és dicsőség a magasságban!“ ");
INSERT INTO hun_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","A sokaságból néhány farizeus ezt mondta neki: „Mester, utasítsd rendre tanítványaidat!“ ");
INSERT INTO hun_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ő így válaszolt nekik: „Mondom nektek, ha ezek elhallgatnak, a kövek fognak kiáltani.“ ");
INSERT INTO hun_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Amikor közelebb ért, és meglátta a várost, megsiratta azt. ");
INSERT INTO hun_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ezt mondta: „Bár felismerted volna ezen a napon te is, ami békességedre szolgál. Most azonban el van rejtve szemed elől. ");
INSERT INTO hun_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Mert jönnek majd rád napok, amikor ellenségeid körülötted sáncot építenek, körülvesznek, és mindenfelől szorongatnak; ");
INSERT INTO hun_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","a földre tipornak téged és fiaidat, és nem hagynak benned követ kövön, mert nem ismerted fel meglátogatásod idejét.“ ");
INSERT INTO hun_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Azután bement a templomba, és kezdte kiűzni azokat, akik ott adnak és vesznek, ");
INSERT INTO hun_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","és ezt mondta nekik: „Meg van írva: »Az én házam imádságnak háza, ti pedig azt latrok barlangjává tettétek.«“ ");
INSERT INTO hun_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Aztán naponként tanított a templomban. A főpapok, az írástudók és a nép előkelői azon voltak, hogy elpusztítsák. ");
INSERT INTO hun_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","De nem találtak megoldást arra, hogy mit cselekedjenek, mert az egész nép rajongva hallgatta őt. ");
INSERT INTO hun_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Történt az egyik napon, amikor a népet tanította a templomban, és az evangéliumot hirdette, odaléptek a főpapok és az írástudók a vénekkel együtt, ");
INSERT INTO hun_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","és megkérdezték tőle: „Mondd meg nekünk, micsoda hatalommal cselekszed ezeket? Vagy ki az, aki neked ezt a hatalmat adta?“ ");
INSERT INTO hun_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ő pedig így válaszolt nekik: „Én is kérdezek egy dolgot tőletek; mondjátok meg nekem: ");
INSERT INTO hun_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","János keresztsége a mennyből való vagy emberektől?“ ");
INSERT INTO hun_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Azok pedig tanakodtak maguk között: Ha azt mondjuk, hogy a mennyből, azt fogja mondani: Akkor miért nem hittetek neki? ");
INSERT INTO hun_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ha pedig azt mondjuk, hogy emberektől, akkor az egész nép megkövez minket, mert meg vannak győződve, hogy János próféta volt. ");
INSERT INTO hun_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Azt válaszolták tehát, hogy ők nem tudják, honnan való. ");
INSERT INTO hun_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Erre Jézus ezt mondta nekik: „Én sem mondom meg nektek, hogy milyen hatalommal cselekszem ezeket.“ ");
INSERT INTO hun_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Azután ezt a példázatot kezdte mondani a népnek: „Egy ember szőlőt plántált, és kiadta azt munkásoknak, és hosszú időre elutazott. ");
INSERT INTO hun_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Amikor eljött az ideje, elküldte szolgáját a munkásokhoz, hogy adjanak neki a szőlő gyümölcséből. A munkások pedig megverték azt, és üresen küldték el. ");
INSERT INTO hun_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Akkor egy másik szolgát küldött, de azok azt is megverték és meggyalázták, és üresen küldték el. ");
INSERT INTO hun_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","És még egy harmadikat is küldött, de azok azt is megsebesítették, és kidobták. ");
INSERT INTO hun_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Akkor így szólt a szőlőnek ura: Mit cselekedjem? Elküldöm szeretett fiamat, talán őt megbecsülik. ");
INSERT INTO hun_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Amikor meglátták a munkások, így tanakodtak egymás között: Ez az örökös. Jöjjetek, öljük meg, hogy mienk legyen az örökség! ");
INSERT INTO hun_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","És kidobták a szőlőből, és megölték. Mit cselekszik a szőlőnek ura azokkal? ");
INSERT INTO hun_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Elmegy, elveszti ezeket a munkásokat, és a szőlőt másoknak adja.“ Amikor ezt hallották, ezt mondták: „Szó sem lehet róla!“ ");
INSERT INTO hun_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ő pedig rájuk tekintett és ezt mondta: „Akkor mi az, ami meg van írva: »Amely követ az építők megvetettek, az lett szegletkővé«? ");
INSERT INTO hun_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Na valaki erre a kőre esik, összezúzódik, akire pedig ez esik rá, szétmorzsolja azt.“ ");
INSERT INTO hun_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","A főpapok és írástudók még abban az órában el akarták fogni, de féltek a néptől, mert megértették, hogy róluk mondta ezt a példázatot. ");
INSERT INTO hun_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ezután állandóan szemmel tartották őt, és kémeket küldtek utána, akik igaznak tetették magukat, hogy szaván foghassák, és átadják a hatóságnak és a helytartó hatalmának. ");
INSERT INTO hun_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Megkérdezték tőle: „Mester, tudjuk, hogy helyesen beszélsz és tanítasz, és nem vagy személyválogató, hanem Isten útját igazán tanítod. ");
INSERT INTO hun_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Szabad-e nekünk a császárnak adót fizetnünk vagy nem?“ ");
INSERT INTO hun_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ő azonban észrevette álnokságukat, és ezt mondta nekik: ");
INSERT INTO hun_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","„Mutassatok nekem egy dénárt. Kinek a képe és felirata van rajta?“ Ezt mondták: „A császáré.“ ");
INSERT INTO hun_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ő pedig ezt mondta nekik: „Adjátok meg a császárnak azt, ami a császáré, és Istennek, ami Istené.“ ");
INSERT INTO hun_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Nem tudtak belekötni szavaiba a nép előtt, és csodálkozva feleletein, elhallgattak. ");
INSERT INTO hun_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Hozzámentek a szadduceusok közül néhányan, akik tagadják, hogy van feltámadás, és megkérdezték őt: ");
INSERT INTO hun_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","„Mester, Mózes megírta nekünk, hogy »ha valakinek meghal a testvére, akinek volt felesége, de gyermeke nem, akkor annak a testvére vegye el annak a feleségét, és támasszon utódot testvérének.« ");
INSERT INTO hun_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Volt hét testvér, és az első megnősült, és gyermektelenül halt meg. ");
INSERT INTO hun_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ekkor a második vette el annak feleségét, és az is gyermektelenül halt meg. ");
INSERT INTO hun_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Akkor a harmadik vette el, és ugyanígy mind a hét, de nem hagytak gyermeket, és meghaltak. ");
INSERT INTO hun_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ezután meghalt az asszony is. ");
INSERT INTO hun_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","A feltámadáskor vajon melyiküknek a felesége lesz? Mert mind a hétnek felesége volt.“ ");
INSERT INTO hun_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jézus így válaszolt nekik: „Ennek a világnak fiai nősülnek, és férjhez mennek. ");
INSERT INTO hun_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","De akiket méltónak ítélnek arra, hogy az eljövendő világnak és a halálból való feltámadásnak részesei legyenek, azok majd nem nősülnek, és férjhez sem mennek. ");
INSERT INTO hun_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Azok meg sem halhatnak, mert hasonlók lesznek az angyalokhoz, és Isten gyermekei lesznek, hiszen a feltámadás gyermekei. ");
INSERT INTO hun_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Azt pedig, hogy feltámadnak a halottak, már Mózes is kijelentette a csipkebokornál, amikor az Urat Ábrahám Istenének, Izsák Istenének és Jákób Istenének nevezte. ");
INSERT INTO hun_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Isten pedig nem a holtak Istene, hanem az élők Istene. Mert az ő számára mindenki él.“ ");
INSERT INTO hun_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Néhány írástudó ekkor így szólt: „Mester, jól mondtad.“ ");
INSERT INTO hun_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","És többé semmit sem mertek tőle megkérdezni. ");
INSERT INTO hun_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Akkor így szólt hozzájuk: „Hogyan mondhatják azt, hogy Krisztus Dávid Fia? ");
INSERT INTO hun_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Hiszen maga Dávid mondja a Zsoltárok könyvében: »Így szólt az Úr az én Uramnak, ülj az én jobb kezem felől, ");
INSERT INTO hun_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","míg ellenségeidet lábad zsámolyává nem teszem.« ");
INSERT INTO hun_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Dávid tehát »Urának« nevezi őt, hogyan lehet akkor Fia?“ ");
INSERT INTO hun_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Az egész nép hallatára ezt mondta tanítványainak: ");
INSERT INTO hun_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","„Óvakodjatok az írástudóktól, akik hosszú köntösökben szeretnek járni, és szeretik, ha piacokon köszöntik őket, szeretik az első helyeket a zsinagógában és a főhelyeket a lakomákon, ");
INSERT INTO hun_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","akik az özvegyek házát felemésztik, és színből hosszan imádkoznak. Ezekre súlyosabb ítélet vár.“ ");
INSERT INTO hun_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Amikor feltekintett, látta, hogy a gazdagok hogyan dobálják ajándékaikat a perselybe. ");
INSERT INTO hun_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Látott egy szegény özvegyasszonyt is, hogy két fillért dobott abba, ");
INSERT INTO hun_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","és így szólt: „Bizony mondom néktek, hogy ez a szegény özvegy mindenkinél többet adott. ");
INSERT INTO hun_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Mert azok mind a fölöslegükből adtak Istennek ajándékot, ez pedig az ő szegénységéből minden vagyonát, amije volt, odaadta.“ ");
INSERT INTO hun_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Amikor némelyek azt mondták a templomról, hogy az szép kövekkel és ajándékokkal van felékesítve, ő így szólt: ");
INSERT INTO hun_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","„Jönnek majd napok, amikor ezekből, amiket láttok, nem marad kő kövön, amelyet le nem rombolnának.“ ");
INSERT INTO hun_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ekkor ezt kérdezték tőle: „Mester, mikor lesz ez, és mi lesz annak a jele, hogy ez beteljesül?“ ");
INSERT INTO hun_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ő pedig ezt mondta: „Vigyázzatok, hogy meg ne tévesszenek titeket, mert sokan jönnek az én nevemben, akik ezt mondják: Én vagyok! – meg azt: Az idő elközelgett! De ti ne menjetek utánuk. ");
INSERT INTO hun_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Amikor hallotok háborúkról és lázadásokról, ne rettenjetek meg, mert ezeknek előbb meg kell történniük, de nem jön mindjárt a vég.“ ");
INSERT INTO hun_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Aztán így folytatta: „Nemzet nemzet ellen és ország ország ellen támad, ");
INSERT INTO hun_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","és mindenfelé nagy földindulások, járványok és éhínségek lesznek, rettenetes dolgok történnek, és nagy jelek tűnnek föl az égen. ");
INSERT INTO hun_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","De mindezek előtt kezet emelnek rátok, és üldöznek titeket. Átadnak titeket a zsinagógáknak, és börtönbe vetnek, és királyok és helytartók elé visznek az én nevemért. ");
INSERT INTO hun_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","De ez alkalom lesz nektek a bizonyságtételre. ");
INSERT INTO hun_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Határozzátok el azért szívetekben, hogy nem gondoltok előre, hogy mit feleljetek védelmetekre, ");
INSERT INTO hun_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","mert én adok nektek szájat és bölcsességet, amelynek nem tud ellenállni vagy ellene mondani egyetlen ellenfeletek sem. ");
INSERT INTO hun_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Elárulnak titeket szülők és testvérek, rokonok és barátok is, és némelyeket megölnek közületek, ");
INSERT INTO hun_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","és gyűlöletesek lesztek mindenki előtt az én nevemért, ");
INSERT INTO hun_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","de fejetek hajszála sem vész el. ");
INSERT INTO hun_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Béketűrésetek által nyeritek meg lelketeket. ");
INSERT INTO hun_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Amikor látjátok, hogy Jeruzsálemet hadsereg keríti be, akkor tudjátok meg, hogy elközelített pusztulása. ");
INSERT INTO hun_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Akkor, akik Júdeában lesznek, fussanak a hegyekre, és akik a városban vannak, költözzenek ki onnan, és akik a mezőn vannak, ne menjenek be oda. ");
INSERT INTO hun_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ezek ugyanis az ítéletnek napjai, hogy beteljesedjenek mindazok, amelyek meg vannak írva. ");
INSERT INTO hun_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Jaj azokban a napokban a terhes és szoptatós asszonyoknak, mert nagy nyomorúság lesz a földön, és harag e népre. ");
INSERT INTO hun_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Elhullnak a kard élétől, és foglyul vitetnek minden pogány nép közé, és Jeruzsálemet pogányok tapossák, míg be nem teljesedik a pogányok ideje. ");
INSERT INTO hun_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","„És lesznek jelek a napban, holdban és csillagokban, a földön népek rettegnek tanácstalanul a tenger zúgása és forrongása miatt, ");
INSERT INTO hun_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","és az emberek megdermednek a félelem és annak várása miatt, amik e föld kerekségére következnek, mert az egek erői megrendülnek. ");
INSERT INTO hun_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Akkor meglátják az Emberfiát eljönni a felhőben hatalommal és nagy dicsőséggel. ");
INSERT INTO hun_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Amikor pedig ezek elkezdődnek, nézzetek fel, és emeljétek fel a fejeteket, mert közeledik megváltásotok.“ ");
INSERT INTO hun_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Mondott nekik egy példázatot is: „Tekintsétek meg a fügefát és minden fát. ");
INSERT INTO hun_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Amikor már hajtanak, és ezt látjátok, ti magatok is tudjátok, hogy közel van már a nyár. ");
INSERT INTO hun_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Így ti is, amikor látjátok, hogy mindezek bekövetkeznek, tudjátok meg: közel van Isten országa. ");
INSERT INTO hun_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Bizony mondom néktek: nem múlik el ez a nemzedék, míg mindez meg nem lesz. ");
INSERT INTO hun_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Az ég és a föld elmúlnak, de az én beszédeim nem múlnak el. ");
INSERT INTO hun_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Vigyázzatok magatokra, hogy szívetek el ne nehezedjék mámortól, részegségtől vagy a megélhetés gondjaitól, és váratlanul ne lepjen meg titeket az a nap. ");
INSERT INTO hun_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Mert mint valami csapda, úgy lep meg mindenkit, akik e föld színén laknak. ");
INSERT INTO hun_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Vigyázzatok azért mindenkor, és kérjétek, hogy kimenekülhessetek mindabból, amik bekövetkeznek, és megállhassatok az Emberfia előtt.“ ");
INSERT INTO hun_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Napközben a templomban tanított, éjszakánként pedig kiment az Olajfák hegyére. ");
INSERT INTO hun_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","És kora reggel az egész nép hozzáment, hogy őt hallgassa a templomban. ");
INSERT INTO hun_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Közeledett már a kovásztalan kenyerek ünnepe, amelyet húsvétnak neveztek. ");
INSERT INTO hun_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","A főpapok és írástudók keresték a módját, hogyan öljék meg őt, mert féltek a néptől. ");
INSERT INTO hun_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Bement a sátán Júdásba, akit Iskáriótesnek neveztek, és aki a tizenkettő közül való volt. ");
INSERT INTO hun_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Elment, és megbeszélte a főpapokkal és az elöljárókkal, hogyan adja őt kezükbe. ");
INSERT INTO hun_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Azok megörültek, és megígérték, hogy pénzt adnak neki. ");
INSERT INTO hun_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ő megígérte, hogy jó alkalmat keres, hogy őt kezükbe adja a nép tudta nélkül. ");
INSERT INTO hun_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Elérkezett a kovásztalan kenyerek napja, amikor fel kellett áldozni a húsvéti bárányt. ");
INSERT INTO hun_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jézus elküldte Pétert és Jánost, és ezt mondta: „Menjetek, készítsétek el nekünk a húsvéti bárányt, hogy megehessük.“ ");
INSERT INTO hun_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ezt mondták neki: „Hol akarod, hogy elkészítsük?“ ");
INSERT INTO hun_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ő ezt mondta nekik: „Íme, amikor bementek a városba, szembejön veletek egy ember, aki egy korsó vizet visz. Kövessétek őt abba a házba, amelybe bemegy, ");
INSERT INTO hun_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","és ezt mondjátok a ház gazdájának: Ezt üzeni a Mester: Hol van a szállás, ahol megeszem tanítványaimmal a húsvéti bárányt? ");
INSERT INTO hun_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","És ő mutat nektek egy nagy, berendezett felsőszobát, ott készítsétek el.“ ");
INSERT INTO hun_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Elmentek, és úgy találták, ahogy mondta nekik, és elkészítették a húsvéti bárányt. ");
INSERT INTO hun_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Amikor eljött az idő, asztalhoz ült, és vele együtt a tizenkét apostol. ");
INSERT INTO hun_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ezt mondta nekik: „Vágyva vágytam, hogy megegyem a húsvéti bárányt veletek, mielőtt szenvedek. ");
INSERT INTO hun_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Mert mondom néktek, hogy többé nem eszem abból, míg be nem teljesedik Isten országában.“ ");
INSERT INTO hun_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Azután vette a poharat, minekutána hálát adott, ezt mondta: „Vegyétek, és osszátok el magatok között, ");
INSERT INTO hun_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","mert mondom néktek, hogy nem iszom a szőlőtőkének gyümölcséből, míg el nem jön Isten országa.“ ");
INSERT INTO hun_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","És vette a kenyeret, hálát adott, megszegte, nekik adta, ezt mondván: „Ez az én testem, amely értetek adatik: ezt cselekedjétek az én emlékezetemre.“ ");
INSERT INTO hun_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Hasonlóképpen vette a poharat is, miután megvacsoráztak, és ezt mondta: „E pohár az új szövetség az én véremben, amely tiérettetek kionttatik. ");
INSERT INTO hun_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","De íme, annak a keze, aki engem elárul, az enyémmel együtt van az asztalon. ");
INSERT INTO hun_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","És az Emberfia elmegy ugyan, amint el van rendelve, de jaj annak az embernek, aki elárulja őt.“ ");
INSERT INTO hun_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Erre kezdték kérdezni egymás között, hogy vajon ki lehet az közöttük, aki ezt meg fogja tenni. ");
INSERT INTO hun_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Versengés is támadt közöttük, hogy ki tekinthető köztük nagyobbnak. ");
INSERT INTO hun_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Erre ő ezt mondta nekik: „A pogányokon uralkodnak királyaik, és akiknek hatalmuk van felettük, jótevőknek hívatják magukat. ");
INSERT INTO hun_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Közöttetek azonban ne így legyen. Hanem aki a legnagyobb közöttetek, olyan legyen, mint aki a legkisebb, és aki vezet, mint aki szolgál. ");
INSERT INTO hun_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Mert ki a nagyobb? Az, aki az asztalnál ül, vagy aki szolgál? Ugye az, aki az asztalnál ül? De én olyan vagyok közöttetek, mint aki szolgál. ");
INSERT INTO hun_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ti vagytok azok, akik megmaradtok velem kísértéseimben, ");
INSERT INTO hun_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","és én nektek adom az országot, amint az én Atyám nekem adta, ");
INSERT INTO hun_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","hogy egyetek és igyatok az én asztalomnál az én országomban, és királyi széken üljetek, ítéletet tartva Izrael tizenkét törzse felett.“ ");
INSERT INTO hun_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ezt mondta az Úr: „Simon! Simon! Íme, a sátán kikért titeket, hogy megrostáljon, mint a búzát, ");
INSERT INTO hun_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","de én imádkoztam érted, hogy el ne fogyatkozzék a te hited. Ha majd megtérsz, erősítsd atyádfiait.“ ");
INSERT INTO hun_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ő pedig ezt mondta: „Uram, veled kész vagyok mind börtönbe, mind halálra menni!“ ");
INSERT INTO hun_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","És ő ezt mondta: „Mondom neked, Péter, ma nem szólal meg addig a kakas, míg te háromszor meg nem tagadod, hogy ismersz engem.“ ");
INSERT INTO hun_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Aztán ezt mondta nekik: „Amikor elküldtelek benneteket erszény, táska és saru nélkül, volt-e valamiben hiányotok?“ Ők pedig ezt mondták: „Semmiben sem.“ ");
INSERT INTO hun_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ezt mondta nekik: „De most, akinek erszénye van, vegye elő, hasonlóképpen a táskát, és akinek nincs kardja, adja el felsőruháját, és vegyen. ");
INSERT INTO hun_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Mert mondom nektek, hogy be kell teljesednie rajtam annak, ami meg van írva: »És a gonoszok közé sorolták.« Mert ami rám vonatkozik, az mind beteljesedik.“ ");
INSERT INTO hun_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Azok ezt mondták: „Uram, íme, van itt két kard.“ Ő pedig ezt mondta: „Elég!“ ");
INSERT INTO hun_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ezután kiment, és szokása szerint az Olajfák hegyére ment. Követték a tanítványai is. ");
INSERT INTO hun_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Amikor odaért, ezt mondta nekik: „Imádkozzatok, hogy kísértésbe ne essetek.“ ");
INSERT INTO hun_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Aztán eltávolodott tőlük, mintegy kőhajításnyira, és térdre esve imádkozott: ");
INSERT INTO hun_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","„Atyám, ha akarod, vedd el tőlem ezt a poharat, mégis ne az én akaratom legyen meg, hanem a tiéd.“ ");
INSERT INTO hun_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Akkor egy angyal jelent meg a mennyből, és erősítette őt. ");
INSERT INTO hun_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Haláltusájában még buzgóbban imádkozott, és verítéke olyan volt, mint a nagy vércseppek, amelyek a földre hullanak. ");
INSERT INTO hun_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Miután imádkozása után fölkelt, tanítványaihoz ment, akiket alva talált a szomorúságtól. ");
INSERT INTO hun_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ekkor így szólt hozzájuk: „Miért alusztok? Keljetek fel és imádkozzatok, hogy kísértésbe ne essetek.“ ");
INSERT INTO hun_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Miközben ezeket mondta, íme, sokaság közeledett, amelynek élén Júdás ment, aki egy a tizenkettő közül, és Jézushoz lépett, hogy megcsókolja. ");
INSERT INTO hun_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Jézus ezt mondta neki: „Júdás, csókkal árulod el az Emberfiát?“ ");
INSERT INTO hun_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Amikor akik körülötte voltak, látták, hogy mi következik, ezt mondták neki: „Uram, vágjunk közéjük karddal?“ ");
INSERT INTO hun_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","És valaki közülük máris rásújtott a főpap szolgájára, és levágta annak jobb fülét. ");
INSERT INTO hun_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Jézus azonban megszólalt, és ezt mondta nekik: „Elég!“ És megérintve annak fülét, meggyógyította. ");
INSERT INTO hun_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Jézus így szólt azokhoz, akik hozzámentek, a főpapoknak, a templom elöljáróinak és a véneknek: „Mint egy latorra, úgy jöttetek kardokkal és botokkal. ");
INSERT INTO hun_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Amikor mindennap veletek voltam a templomban, kezeteket nem vetettétek rám. De ez a ti órátok, és a sötétségnek hatalma.“ ");
INSERT INTO hun_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Akkor elfogták őt, elvezették, és elvitték a főpap házába. Péter távolról követte. ");
INSERT INTO hun_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Amikor tüzet raktak az udvar közepén, és körülülték, Péter is leült velük. ");
INSERT INTO hun_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Meglátta őt egy szolgálólány, amint a világosságnál ült, szemügyre vette, és ezt mondta: „Ez is vele volt!“ ");
INSERT INTO hun_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ő pedig letagadta, és ezt mondta: „Asszony, nem ismerem őt.“ ");
INSERT INTO hun_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Rövid idő múlva más valaki látta meg, és mondta: „Te is azok közül való vagy!“ Péter pedig ezt mondta: „Ember, nem vagyok!“ ");
INSERT INTO hun_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","És úgy egy óra múlva más valaki is bizonygatta, és ezt mondta: „Bizony ez is vele volt, mert Galileából való ő is.“ ");
INSERT INTO hun_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Péter ezt mondta: „Ember, nem tudom, mit beszélsz!“ És azonnal, amikor még beszélt, megszólalt a kakas. ");
INSERT INTO hun_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Hátrafordult az Úr, és rátekintett Péterre. És Péter visszaemlékezett az Úr szavára, amit neki mondott: „Mielőtt a kakas megszólal, háromszor megtagadsz engem.“ ");
INSERT INTO hun_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Aztán kiment, és keservesen sírt. ");
INSERT INTO hun_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Azok a férfiak, akik fogva tartották Jézust, csúfolták és verték, ");
INSERT INTO hun_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","és szemét betakarva arcul csapták őt, és ezt kérdezték: „Prófétáld meg, ki az, aki megütött téged!“ ");
INSERT INTO hun_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","És sok mással is szidalmazták őt. ");
INSERT INTO hun_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Amint nappal lett, egybegyűlt a nép véneinek tanácsa, főpapok és írástudók, és gyülekezetükbe vitték őt, ");
INSERT INTO hun_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","és ezt mondták: „Ha te vagy a Krisztus, mondd meg nekünk.“ Ő pedig ezt mondta nekik: „Ha meg is mondanám, akkor sem hiszitek el, ");
INSERT INTO hun_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ha pedig én kérdezlek, nem feleltek. ");
INSERT INTO hun_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","De mostantól fogva ott ül az Emberfia Isten hatalmának jobbja felől.“ ");
INSERT INTO hun_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Erre mind ezt mondták: „Te vagy tehát Isten Fia?“ Ő pedig ezt mondta: „Ti mondjátok, hogy az vagyok!“ ");
INSERT INTO hun_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Azok ezt mondták: „Mi szükségünk van még tanúkra? Hiszen mi magunk hallottuk saját szájából!“ ");
INSERT INTO hun_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ezután fölállt az egész testület, és elvitték őt Pilátushoz. ");
INSERT INTO hun_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Elkezdték vádolni, és ezt mondták: „Úgy találtuk, hogy ez a népet félrevezeti, és tiltja, hogy a császárnak adót fizessünk, mert Krisztus-királynak mondja magát.“ ");
INSERT INTO hun_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilátus megkérdezte őt: „Te vagy-e a zsidók királya?“ És ő ezt felelte: „Te mondod!“ ");
INSERT INTO hun_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilátus pedig ezt mondta a főpapoknak és a sokaságnak: „Semmi bűnt nem találok ebben az emberben.“ ");
INSERT INTO hun_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","De azok erősködtek, és ezt mondták: „A népet fellázítja tanításával egész Júdeában, Galileától kezdve egészen idáig.“ ");
INSERT INTO hun_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilátus ezt hallva, megkérdezte, hogy Galileából való ember-e ő. ");
INSERT INTO hun_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","És amikor megtudta, hogy Heródes fennhatósága alá tartozik, Heródeshez küldte, mert az is Jeruzsálemben volt azokban a napokban. ");
INSERT INTO hun_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Heródes pedig látva Jézust, igen megörült, mert régóta kívánta őt látni, mert sokat hallott felőle, és remélte, hogy valami csodát lát, amelyet ő tesz. ");
INSERT INTO hun_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Sok beszéddel kérdezgette, de ő semmit sem felelt neki. ");
INSERT INTO hun_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ott álltak a főpapok és az írástudók, és hevesen vádolták őt. ");
INSERT INTO hun_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Heródes pedig katonáival együtt megvetően bánt vele, és kicsúfolta, miután fényes ruhába öltöztette, és visszaküldte Pilátushoz. ");
INSERT INTO hun_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Azon a napon Heródes és Pilátus barátok lettek, azelőtt ugyanis ellenségeskedésben voltak egymással. ");
INSERT INTO hun_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ekkor Pilátus a főpapokat, a főembereket és a népet összehívta, ");
INSERT INTO hun_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","és ezt mondta nekik: „Idehoztátok nekem ezt az embert, mint aki a népet félrevezeti, és íme, én tielőttetek kihallgattam, és semmi olyan bűnt nem találtam ebben az emberben, amivel őt vádoljátok. ");
INSERT INTO hun_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","De még Heródes sem, mert ő is visszaküldte hozzám, és íme, semmi halálos vétséget nem cselekedett. ");
INSERT INTO hun_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Megfenyítem tehát, és elbocsátom.“ ");
INSERT INTO hun_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ünnepenként egy foglyot kellett elbocsátania. ");
INSERT INTO hun_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Akkor felkiáltott az egész sokaság: „Ezt öld meg, és bocsásd el nekünk Barabást!“ ");
INSERT INTO hun_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ezt a városban kitört lázadásért és gyilkosságért vettették tömlöcbe. ");
INSERT INTO hun_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilátus ismét szólt hozzájuk, mert szabadon akarta bocsátani Jézust. ");
INSERT INTO hun_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","De azok egyre kiáltoztak: „Feszítsd meg! Feszítsd meg őt!“ ");
INSERT INTO hun_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ő pedig harmadszor is szólt hozzájuk: „De hát mi rosszat tett ez? Semmi halálra való bűnt nem találtam benne. Megfenyítem és elbocsátom.“ ");
INSERT INTO hun_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Azok pedig hangos szóval sürgették, és követelték, hogy feszítsék meg, és az ő szavuk győzött. ");
INSERT INTO hun_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","És Pilátus úgy döntött, hogy legyen meg, amit kértek. ");
INSERT INTO hun_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Elbocsátotta tehát nekik azt, aki lázadásért és gyilkosságért volt tömlöcbe vetve, és akit kértek, Jézust, kiszolgáltatta akaratuknak. ");
INSERT INTO hun_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Amikor elvezették őt, megragadtak egy bizonyos cirénei Simont, aki a mezőről jött, és arra tették a keresztfát, hogy vigye Jézus után. ");
INSERT INTO hun_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","A népnek és asszonyoknak nagy sokasága követte, akik gyászolták és siratták őt. ");
INSERT INTO hun_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jézus hozzájuk fordulva ezt mondta: „Jeruzsálem leányai, ne miattam sírjatok, hanem magatokat sirassátok és a ti gyermekeiteket. ");
INSERT INTO hun_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Mert íme, jönnek napok, amelyeken ezt mondják: Boldogok a meddők, és az anyaméhek, amelyek nem szültek, és az emlők, amelyek nem szoptattak! ");
INSERT INTO hun_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Akkor »kezdik mondani a hegyeknek: Essetek ránk, és a halmoknak: Borítsatok el minket!« ");
INSERT INTO hun_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Mert ha a zöldellő fával ezt teszik, mi lesz a szárazzal?“ ");
INSERT INTO hun_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Két gonosztevőt is vittek ővele, hogy kivégezzék azokat is. ");
INSERT INTO hun_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Amikor elértek arra a helyre, amelyet Koponya-helynek hívtak, ott megfeszítették őt és a gonosztevőket, egyiket jobb kéz felől, a másikat bal kéz felől. ");
INSERT INTO hun_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jézus ezt mondta: „Atyám! Bocsáss meg nekik, mert nem tudják, mit cselekszenek.“ Azután sorsot vetettek, hogy megosztozzanak ruháin. ");
INSERT INTO hun_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","A nép ott állt, és nézte. Azokkal együtt a főemberek is csúfolták őt, ezt mondták: „Másokat megtartott, tartsa meg magát, ha ő a Krisztus, Istennek választottja!“ ");
INSERT INTO hun_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Csúfolták őt a katonák is, odamentek hozzá, és ecettel kínálták, ");
INSERT INTO hun_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","és ezt mondták neki: „Ha te vagy a zsidók királya, szabadítsd meg magad!“ ");
INSERT INTO hun_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Felirat is volt fölötte, görög, római és zsidó betűkkel írva: Ez a zsidók királya. ");
INSERT INTO hun_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","A megfeszített gonosztevők közül pedig az egyik szidalmazta őt: „Ha te vagy a Krisztus, szabadítsd meg magadat és minket is!“ ");
INSERT INTO hun_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","De a másik megdorgálta, és ezt mondta neki: „Nem féled az Istent? Hiszen te is ugyanazon ítélet alatt vagy! ");
INSERT INTO hun_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Mi ugyan méltán, mert a mi cselekedeteink méltó büntetését kapjuk, ő pedig semmi rosszat nem cselekedetett!“ ");
INSERT INTO hun_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Jézusnak ezt mondta: „Uram, emlékezz meg rólam, amikor eljössz a te országodba!“ ");
INSERT INTO hun_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jézus ezt mondta neki: „Bizony mondom néked, ma velem leszel a paradicsomban.“ ");
INSERT INTO hun_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Mintegy hat óra volt, és sötétség lett az egész tartományban egészen kilenc óráig. ");
INSERT INTO hun_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","A nap elhomályosodott és a templom kárpitja középen kettéhasadt. ");
INSERT INTO hun_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Jézus hangos szóval így kiáltott: „Atyám, a te kezedbe teszem le az én lelkemet.“ És ezt mondva meghalt. ");
INSERT INTO hun_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Amikor a százados látta, mi történt, dicsőítette Istent, és ezt mondta: „Bizony ez az ember igaz volt.“ ");
INSERT INTO hun_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","És az egész sokaság, amely azért ment oda, hogy lássa mindezeket, amikor látta, mi történt, mellét verve ment haza. ");
INSERT INTO hun_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Az ő ismerősei mind és az asszonyok, akik Galileából követték őt, távolabb álltak, és nézték ezt. ");
INSERT INTO hun_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Íme, egy ember, akit Józsefnek hívtak, a tanács tagja, jó és igaz férfi, ");
INSERT INTO hun_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","aki nem volt részes tanácsukban és cselekedeteikben, aki Arimátiából, a júdeaiak városából való volt, és aki maga is várta Isten országát, ");
INSERT INTO hun_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Pilátushoz ment, és elkérte Jézus testét. ");
INSERT INTO hun_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Aztán levette, gyolcsba göngyölte, és egy sziklába vágott sírba helyezte, amelyben még senki sem feküdt. ");
INSERT INTO hun_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","És az a nap péntek volt, és szombat virradt rá. ");
INSERT INTO hun_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Az őt követő asszonyok is, akik Galileából jöttek vele, megnézték a sírt, és hogy hogyan helyezték el testét. ");
INSERT INTO hun_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Aztán visszatértek, illatszereket és keneteket készítettek. ");
INSERT INTO hun_vpl VALUES ("LK23_57","072_23_57","LUK","23","57","57","Szombaton azonban pihentek a parancsolat szerint. ");
INSERT INTO hun_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","A hét első napján kora reggel elmentek a sírhoz, és magukkal vitték az elkészített keneteket. ");
INSERT INTO hun_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","A követ a sírról elhengerítve találták, ");
INSERT INTO hun_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","és amikor bementek, nem találták az Úr Jézus testét. ");
INSERT INTO hun_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Történt, hogy amikor ők ezen megdöbbentek, íme, két férfiú állt melléjük fényes öltözetben. ");
INSERT INTO hun_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ők pedig megrémülve arcukat a földre hajtották, azok ezt mondták nekik: „Miért keresitek a holtak között az élőt? ");
INSERT INTO hun_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Nincs itt, hanem feltámadott. Emlékezzetek rá, hogyan beszélt nektek, amikor még Galileában volt: ");
INSERT INTO hun_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Az Emberfiának bűnös emberek kezébe kell adatnia, és megfeszíttetnie, és a harmadik napon feltámadnia.“ ");
INSERT INTO hun_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ekkor visszaemlékeztek az ő szavaira, ");
INSERT INTO hun_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","és visszatérve a sírtól, elmondták mindezt a tizenegynek és a többieknek. ");
INSERT INTO hun_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Velük volt a magdalai Mária, Johanna és a Jakab anyja Mária és más asszonyok is, akik mindezt elmondták az apostoloknak. ");
INSERT INTO hun_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","De az ő szavukat csak üres beszédnek tartották, és nem hittek nekik. ");
INSERT INTO hun_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Péter azonban felkelt, elfutott a sírhoz, és behajolva látta, hogy csak a lepedők vannak ott. Erre elment, és magában csodálkozott a történteken. ");
INSERT INTO hun_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Tanítványai közül ketten ugyanazon a napon egy faluba mentek, amely Jeruzsálemtől hatvan futamnyira volt, amelynek neve: Emmaus. ");
INSERT INTO hun_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Maguk között arról beszélgettek, amik történtek. ");
INSERT INTO hun_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","És történt, hogy amint beszélgettek, és egymástól kérdezősködtek, maga Jézus hozzájuk szegődött, és velük együtt ment az úton. ");
INSERT INTO hun_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","De látásukat mintha valami akadályozta volna, nem ismerték fel őt. ");
INSERT INTO hun_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ő pedig ezt mondta nekik: „Miről beszélgettek egymással útközben?“ Erre szomorúan megálltak. ");
INSERT INTO hun_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Megszólalt az egyik, akinek neve Kleopás, és ezt mondta neki: „Csak te vagy egyedül jövevény Jeruzsálemben, aki nem tudja, hogy mi történt ott ezekben a napokban?“ ");
INSERT INTO hun_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ő így szólt: „Mi történt?“ Azok ezt mondták neki: „Az, ami a názáreti Jézussal történt, aki próféta volt, cselekedetben és beszédben hatalmas Isten, és az egész nép előtt, ");
INSERT INTO hun_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","és mi módon adták őt a főpapok és főembereink halálos ítéletre, és megfeszítették őt. ");
INSERT INTO hun_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Pedig mi azt reméltük, hogy ő az, aki meg fogja váltani Izraelt. De mindezek már három napja történtek. ");
INSERT INTO hun_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ezenfelül néhány közülünk való asszony is megrémített minket, akik kora reggel a sírnál voltak, ");
INSERT INTO hun_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","és amikor nem találták ott a testét, hazajöttek, és azt mondták, hogy angyalok jelenését látták, akik azt mondták, hogy ő él. ");
INSERT INTO hun_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","El is mentek néhányan, akik velünk voltak, a sírhoz, és úgy találták, ahogy az asszonyok mondták. Őt azonban nem látták.“ ");
INSERT INTO hun_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Akkor ő így szólt hozzájuk: „Ó, balgatagok és rest szívűek arra, hogy elhiggyétek, amiket a próféták szóltak! ");
INSERT INTO hun_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Hát nem ezeket kellett szenvednie a Krisztusnak, és így megdicsőülnie?“ ");
INSERT INTO hun_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","És Mózestől meg valamennyi prófétától kezdve elmagyarázta nekik mindazt, ami az Írásokban felőle megírattak. ");
INSERT INTO hun_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Így értek el ahhoz a faluhoz, amelybe igyekeztek. Ő azonban úgy tett, mintha továbbmenne. ");
INSERT INTO hun_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","De azok unszolták, és kérték: „Maradj velünk, mert immár beesteledik, és a nap is lehanyatlott már.“ Bement tehát, hogy velük maradjon. ");
INSERT INTO hun_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","És történt, amikor leült velük, vette a kenyeret, megáldotta és megszegte, és nekik adta. ");
INSERT INTO hun_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Erre megnyílt a szemük, és felismerték őt, de ő eltűnt előlük. ");
INSERT INTO hun_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ekkor ezt mondták egymásnak: „Nem melegedett-e fel szívünk, amikor beszélt hozzánk az úton, és magyarázta nekünk az Írásokat?“ ");
INSERT INTO hun_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Még abban az órában útra keltek, és visszatértek Jeruzsálembe, és egybegyűlve találták a tizenegyet és azokat, akik velük voltak. ");
INSERT INTO hun_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Akik ezt mondták: „Valóban feltámadott az Úr, és megjelent Simonnak.“ ");
INSERT INTO hun_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Erre ők is elbeszélték, mi történt az úton, és hogyan ismerték őt fel a kenyér megszegéséről. ");
INSERT INTO hun_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Miközben erről beszélgettek, Jézus maga megállt közöttük, és ezt mondta nekik: „Békesség néktek!“ ");
INSERT INTO hun_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Rémületükben és félelmükben azt hitték, hogy valami szellemet látnak. ");
INSERT INTO hun_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ezt mondta nekik: „Miért rémültetek meg, és miért támad kétség szívetekben? ");
INSERT INTO hun_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Nézzétek meg kezemet és lábamat, hogy valóban én vagyok. Tapintsatok meg, és lássatok, mert a szellemnek nincs húsa, csontja, s amint látjátok, nekem van!“ ");
INSERT INTO hun_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ezeket mondva megmutatta nekik kezét és lábát. ");
INSERT INTO hun_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Amikor pedig még mindig nem hittek örömükben, és csodálkoztak, ezt mondta nekik: „Van-e valami ennivalótok?“ ");
INSERT INTO hun_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ők pedig adtak neki egy darab sült halat. ");
INSERT INTO hun_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Elvette, és előttük megette. ");
INSERT INTO hun_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ezután ezt mondta nekik: „Ezek azok a beszédek, amelyeket szóltam nektek, amíg veletek voltam: Be kell teljesedni mindannak, amik megírattak énfelőlem Mózes törvényében, a prófétáknál és a zsoltárokban.“ ");
INSERT INTO hun_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Akkor megnyitotta értelmüket, hogy megértsék az Írásokat. ");
INSERT INTO hun_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","És ezt mondta nekik: „Így van megírva, így kellett szenvedni a Krisztusnak, és feltámadni a halálból harmadnapon. ");
INSERT INTO hun_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","És hirdetni kell az ő nevében a megtérést és a bűnbocsánatot minden népnek, Jeruzsálemtől elkezdve. ");
INSERT INTO hun_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ti vagytok ennek tanúi. ");
INSERT INTO hun_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","És íme, én elküldöm nektek, akit Atyám ígért, ti pedig maradjatok Jeruzsálem városában, míg fel nem ruháztattok mennyei erővel.“ ");
INSERT INTO hun_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ezután kivezette őket Betániáig, és felemelte kezét, és megáldotta őket. ");
INSERT INTO hun_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","És történt, hogy miközben áldotta őket, elszakadt tőlük, és felvitetett a mennybe. ");
INSERT INTO hun_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ők pedig imádták őt, és visszatértek nagy örömmel Jeruzsálembe. ");
INSERT INTO hun_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","És mindenkor a templomban voltak, dicsérve és áldva Istent. Ámen.");
INSERT INTO hun_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Kezdetben volt az Ige, és az Ige az Istennél volt, és Isten volt az Ige. ");
INSERT INTO hun_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ez kezdetben az Istennél volt. ");
INSERT INTO hun_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Minden őáltala lett, és nélküle semmi sem lett, ami lett. ");
INSERT INTO hun_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Őbenne volt az élet, és az élet volt az emberek világossága. ");
INSERT INTO hun_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","És a világosság a sötétségben fénylik, de a sötétség nem fogadta be azt. ");
INSERT INTO hun_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Volt egy Istentől küldött ember, akinek a neve János volt. ");
INSERT INTO hun_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ő tanúbizonyságul jött, hogy bizonyságot tegyen a világosságról, hogy mindenki higgyen őáltala. ");
INSERT INTO hun_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Nem ő volt a világosság, azért jött, hogy bizonyságot tegyen a világosságról. ");
INSERT INTO hun_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Az igazi világosság eljött már a világba, amely megvilágosít minden embert. ");
INSERT INTO hun_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","A világban volt, és a világ általa lett, de a világ nem ismerte meg őt. ");
INSERT INTO hun_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Az övéi közé jött, és az övéi nem fogadták be. ");
INSERT INTO hun_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Akik pedig befogadták, azokat felhatalmazta arra, hogy Isten fiaivá legyenek, mindazokat, akik az ő nevében hisznek. ");
INSERT INTO hun_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Akik nem vérből, sem a testnek akaratából, sem a férfiúnak indulatából, hanem Istentől születtek. ");
INSERT INTO hun_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","És az Ige testté lett, és lakozott miközöttünk (és láttuk az ő dicsőségét, mint az Atya egyszülöttjének dicsőségét), aki teljes volt kegyelemmel és igazsággal. ");
INSERT INTO hun_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","János bizonyságot tett őróla, és kiáltott, ezt mondva: „Ez volt az, akiről mondtam: Aki utánam jön, előttem lett, mert előbb volt nálam.“ ");
INSERT INTO hun_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","És az ő teljességéből vettünk mindnyájan kegyelmet is kegyelemért. ");
INSERT INTO hun_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Mert a törvény Mózes által adatott, a kegyelem pedig és az igazság Jézus Krisztus által lett. ");
INSERT INTO hun_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Az Istent soha senki nem látta, az egyszülött Fiú, aki az Atya kebelén van, az jelentette ki őt. ");
INSERT INTO hun_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","És ez János bizonyságtétele. Amikor a zsidók papokat és lévitákat küldtek Jeruzsálemből, hogy megkérdezzék őt: „Kicsoda vagy te?“ ");
INSERT INTO hun_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Megvallotta és nem tagadta, megvallotta, hogy: „Nem én vagyok a Krisztus.“ ");
INSERT INTO hun_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Megkérdezték őt: „Kicsoda tehát? Illés vagy te?“ Ezt mondta: „Nem vagyok.“ „A próféta vagy te?“ És ő felelte: „Nem.“ ");
INSERT INTO hun_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Mondták azért neki: „Kicsoda vagy? Hogy megfelelhessünk azoknak, akik minket elküldtek: Mit mondasz magad felől?“ ");
INSERT INTO hun_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ő ezt mondta: „Én kiáltó szó vagyok a pusztában. »Egyengessétek az Úrnak útját!«, amint megmondta Ézsaiás próféta.“ ");
INSERT INTO hun_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","A küldöttek a farizeusok közül valók voltak. ");
INSERT INTO hun_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Megkérdezték őt, és ezt mondták neki: „Miért keresztelsz tehát, ha nem te vagy a Krisztus, sem Illés, sem a próféta?“ ");
INSERT INTO hun_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","János így felelt nekik: „Én vízzel keresztelek, de köztetek van, akit ti nem ismertek. ");
INSERT INTO hun_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ő az, aki utánam jön, aki előttem lett, akinek én nem vagyok méltó, hogy saruja szíját megoldjam.“ ");
INSERT INTO hun_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ezek Betániában történtek, a Jordánon túl, ahol János keresztelt. ");
INSERT INTO hun_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Másnap látta János Jézust hozzámenni, és ezt mondta: „Íme, az Istennek ama báránya, aki elveszi a világ bűneit! ");
INSERT INTO hun_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ez az, akiről én ezt mondtam: Utánam jön egy férfiú, aki előttem lett, mert előbb volt nálam. ");
INSERT INTO hun_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Én nem ismertem őt, de hogy megjelentessék Izraelnek, azért jöttem én, aki vízzel keresztelek.“ ");
INSERT INTO hun_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","És bizonyságot tett János, ezt mondva: „Láttam a Lelket leszállni az égből, mint egy galambot, és megnyugodott őrajta. ");
INSERT INTO hun_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Én nem ismertem őt, de aki elküldött engem, hogy vízzel kereszteljek, az mondta nekem: Akire látod a Lelket leszállni és rajta megnyugodni, ő az, aki Szentlélekkel keresztel. ");
INSERT INTO hun_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Én láttam, és bizonyságot tettem, hogy ez az Isten Fia.“ ");
INSERT INTO hun_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Másnap ismét ott állt János és kettő az ő tanítványai közül, ");
INSERT INTO hun_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","ránézve Jézusra, amint ott járt, mondta: „Íme, az Isten Báránya!“ ");
INSERT INTO hun_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Hallotta őt a két tanítvány, amint szólt, és követték Jézust. ");
INSERT INTO hun_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jézus pedig hátrafordult, és látva, hogy követik azok, ezt mondta nekik: ");
INSERT INTO hun_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","„Mit kerestek?“ Azok pedig mondták neki: „Rabbi – ami azt jelenti: Mester – , hol laksz?“ ");
INSERT INTO hun_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Mondta nekik: „Jöjjetek, és lássátok meg.“ Elmentek, meglátták, hol lakik, és nála maradtak azon a napon: akkor pedig körülbelül tíz óra volt. ");
INSERT INTO hun_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","A kettő közül, akik Jánostól ezt hallották, és őt követték, András volt az egyik, Simon Péter testvére. ");
INSERT INTO hun_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ő találkozott először a saját testvérével, Simonnal, és mondta neki: „Megtaláltuk a Messiást“ – (ami azt jelenti: Krisztus). ");
INSERT INTO hun_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","És Jézushoz vezette őt. Jézus pedig reátekintve, mondta: „Te Simon vagy, Jóna fia, téged Kéfásnak fognak hívni“ – (ami azt jelenti: Kőszikla). ");
INSERT INTO hun_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","A következő napon Galileába akart menni Jézus, találkozott Fülöppel, és mondta neki: „Kövess engem!“ ");
INSERT INTO hun_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Fülöp pedig Betsaidából, András és Péter városából való volt. ");
INSERT INTO hun_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Fülöp találkozott Nátánáellel, és mondta neki: „Akiről Mózes írt a törvényben, és a próféták, megtaláltuk, a názáreti Jézust, Józsefnek fiát.“ ");
INSERT INTO hun_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Mondta neki Nátánáel: „Názáretből támadhat-e valami jó?“ Fülöp ezt mondta neki: „Jöjj, és lásd meg!“ ");
INSERT INTO hun_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Látta Jézus Nátánáelt őhozzá menni, és azt mondta róla: „Íme, egy igazán izraelita, akiben hamisság nincsen.“ ");
INSERT INTO hun_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nátánáel ezt mondta neki: „Honnan ismersz engem?“ Jézus így felelt neki: „Mielőtt hívott téged Fülöp, láttalak téged, amint a fügefa alatt voltál.“ ");
INSERT INTO hun_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Nátánáel így felelt neki: „Rabbi, te vagy az Isten Fia, te vagy az Izrael Királya!“ ");
INSERT INTO hun_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Jézus így felelt neki: „Azért, mert azt mondtam neked: láttalak a fügefa alatt, hiszel? Nagyobbakat látsz majd ezeknél.“ ");
INSERT INTO hun_vpl VALUES ("JN1_52","073_1_52","JHN","1","52","52","És mondta neki: „Bizony, bizony mondom néktek: Mostantól fogva meglátjátok a megnyílt eget és az Isten angyalait, amint felszállnak és leszállnak az Emberfiára.“ ");
INSERT INTO hun_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","A harmadik napon menyegző volt a galileai Kánában. Ott volt Jézus anyja. ");
INSERT INTO hun_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jézust is meghívták az ő tanítványaival együtt a menyegzőre. ");
INSERT INTO hun_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Mikor elfogyott a bor, Jézus anyja ezt mondta neki: „Nincs boruk.“ ");
INSERT INTO hun_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jézus ezt mondta neki: „Mi közöm nekem hozzád, ó, asszony? Nem jött még el az én órám.“ ");
INSERT INTO hun_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Az anyja a szolgáknak ezt mondta: „Bármit mond néktek, tegyétek meg.“ ");
INSERT INTO hun_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Volt pedig ott hat kőveder elhelyezve a zsidók tisztálkodási módja szerint, melyek közül egyenként két-három métréta fért. ");
INSERT INTO hun_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jézus ezt mondta nekik: „Töltsétek meg a vedreket vízzel.“ És megtöltötték azokat színültig. ");
INSERT INTO hun_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Azután mondta nekik: „Most merítsetek, és vigyetek a násznagynak.“ És vittek. ");
INSERT INTO hun_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Amint pedig megízlelte a násznagy a borrá lett vizet, nem tudta, honnan van (de a szolgák tudták, akik a vizet merítették), szólította a násznagy a vőlegényt, ");
INSERT INTO hun_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","és mondta neki: „Minden ember a jó bort adja fel először, és mikor megittasodtak, akkor az alábbvalót: te a jó bort ekkorra tartottad.“ ");
INSERT INTO hun_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ezt az első jelt a galileai Kánában tette Jézus, megmutatta az ő dicsőségét, és hittek benne a tanítványai. ");
INSERT INTO hun_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Azután lement Kapernaumba, anyjával, testvéreivel és tanítványaival együtt, és ott maradtak néhány napig. ");
INSERT INTO hun_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Közel volt a zsidók húsvétja, felment Jézus Jeruzsálembe. ");
INSERT INTO hun_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ott találta a templomban az ökrök, juhok és galambok árusait és a pénzváltókat, amint ott ültek. ");
INSERT INTO hun_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ekkor kötélből ostort csinálva, kiűzte mindnyájukat a templomból, az ökröket is a juhokat is, és a pénzváltók pénzét kiöntötte, az asztalokat pedig feldöntötte, ");
INSERT INTO hun_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","a galambárusoknak pedig ezt mondta: „Hordjátok el ezeket innen, ne tegyétek az én Atyámnak házát kalmárság házává.“ ");
INSERT INTO hun_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Tanítványai pedig emlékeztek, hogy meg van írva: „A te házadhoz való féltő szeretet emészt engem.“ ");
INSERT INTO hun_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","A zsidók ezt felelték és mondták neki: „Micsoda jelt mutatsz nékünk, hogy ezeket cselekszed?“ ");
INSERT INTO hun_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jézus ezt felelte és mondta nekik: „Rontsátok le a templomot, és három nap alatt megépítem azt.“ ");
INSERT INTO hun_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","A zsidók erre ezt mondták: „Negyvenhat esztendeig épült ez a templom, és te három nap alatt megépíted azt?“ ");
INSERT INTO hun_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ő pedig az ő testének templomáról szólt. ");
INSERT INTO hun_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Mikor pedig feltámadt a halálból, emlékeztek a tanítványai, hogy ezt mondta, és hittek az Írásnak és a beszédnek, amelyet Jézus mondott. ");
INSERT INTO hun_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Amikor pedig Jeruzsálemben volt húsvétkor az ünnepen, sokan hittek az ő nevében, látva azokat a jeleket, amelyeket cselekedett. ");
INSERT INTO hun_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Jézus azonban nem bízta magát reájuk, mert ismerte mindnyájukat, ");
INSERT INTO hun_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","és nem szorult rá, hogy valaki bizonyságot tegyen az emberről, mert magától is tudta, mi lakik az emberben. ");
INSERT INTO hun_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Volt pedig a farizeusok közt egy ember, a neve Nikodémus, a zsidók főembere. ");
INSERT INTO hun_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Eljött Jézushoz éjjel, és mondta neki: „Mester, tudjuk, hogy Istentől jöttél tanítóul, mert senki sem teheti azokat a jeleket, amelyeket te teszel, hacsak nem az Isten van vele.“ ");
INSERT INTO hun_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jézus így felelt, és mondta neki: „Bizony, bizony mondom néked: ha valaki újonnan nem születik, nem láthatja meg az Isten országát.“ ");
INSERT INTO hun_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodémus ezt mondta neki: „Mi módon születhetik az ember, ha vén? Vajon bemehet-e az anyjának méhébe, és megszülethetik-e ismét?“ ");
INSERT INTO hun_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jézus így felelt: „Bizony, bizony mondom néked: Ha valaki nem születik víztől és Lélektől, nem mehet be az Isten országába. ");
INSERT INTO hun_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ami testtől született, test az, és a mi Lélektől született, lélek az. ");
INSERT INTO hun_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ne csodálkozz, hogy azt mondtam neked: Szükséges néktek újonnan születnetek. ");
INSERT INTO hun_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","A szél fúj, ahová akar, és annak zúgását hallod, de nem tudod, honnan jön, és hová megy: így van mindenki, aki Lélektől született.“ ");
INSERT INTO hun_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodémus így felelt neki: „Hogyan lehetnek ezek?“ ");
INSERT INTO hun_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jézus így felelt: „Te Izrael tanítója vagy, és nem tudod ezeket? ");
INSERT INTO hun_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Bizony, bizony mondom néked, amit tudunk, azt mondjuk, és amit látunk, arról teszünk bizonyságot, és a mi bizonyságtételünket nem fogadjátok el. ");
INSERT INTO hun_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ha a földiekről szóltam nektek, és nem hisztek, mi módon hisztek, ha a mennyeiekről szólok nektek? ");
INSERT INTO hun_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Senki sem ment fel a mennybe, csak az, aki a mennyből szállt alá, az Emberfia, aki a mennyben van. ");
INSERT INTO hun_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Amiképpen felemelte Mózes a kígyót a pusztában, úgy kell az Emberfiának felemeltetnie, ");
INSERT INTO hun_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","hogy aki hisz őbenne, el ne vesszen, hanem örök élete legyen. ");
INSERT INTO hun_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Mert úgy szerette Isten e világot, hogy az ő egyszülött Fiát adta, hogy aki hisz őbenne, el ne vesszen, hanem örök élete legyen. ");
INSERT INTO hun_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Mert nem azért küldte az Isten az ő Fiát a világra, hogy kárhoztassa a világot, hanem hogy megtartsa a világot általa. ");
INSERT INTO hun_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Aki hisz őbenne, el nem kárhozik, aki pedig nem hisz, immár elkárhozott, mivelhogy nem hitt az Isten egyszülött Fiának nevében. ");
INSERT INTO hun_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","A kárhoztatás pedig az, hogy a világosság e világra jött, és az emberek inkább szerették a sötétséget, mint a világosságot, mert az ő cselekedeteik gonoszak voltak. ");
INSERT INTO hun_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Mert mindenki, aki hamisan cselekszik, gyűlöli a világosságot, és nem megy a világosságra, hogy az ő cselekedeteit fel ne fedjék. ");
INSERT INTO hun_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Aki pedig az igazságot cselekszi, az a világosságra megy, hogy az ő cselekedetei nyilvánvalókká legyenek, hogy Isten szerint való cselekedetek.“ ");
INSERT INTO hun_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ezután elment Jézus az ő tanítványaival a Júdea földére, ott időzött velük, és keresztelt. ");
INSERT INTO hun_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","János pedig szintén keresztelt Ainonban, Szálimhoz közel, mert ott sok volt a víz. És odajárultak és megkeresztelkedtek, ");
INSERT INTO hun_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","mert Jánost még nem vetették tömlöcbe. ");
INSERT INTO hun_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Vetekedés támadt azért János tanítványai és a júdeaiak között a mosakodás miatt. ");
INSERT INTO hun_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Odamentek Jánoshoz, és ezt mondták neki: „Mester! Aki veled volt a Jordánon túl, akiről te bizonyságot tettél, íme, az keresztel, és hozzá megy mindenki.“ ");
INSERT INTO hun_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","János így felelt: „Az ember semmit sem vehet, csak ha a mennyből adatott neki. ");
INSERT INTO hun_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ti magatok vagytok a bizonyságaim, hogy megmondtam: Nem én vagyok a Krisztus, hanem őelőtte küldettem el. ");
INSERT INTO hun_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Akinek jegyese van, vőlegény az, a vőlegény barátja pedig, aki ott áll, és hallja őt, örvendezve örül a vőlegény szavának. Ez az én örömöm immár betelt. ");
INSERT INTO hun_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Annak növekednie kell, nekem pedig alább szállanom. ");
INSERT INTO hun_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Aki felülről jött, feljebb való mindenkinél. Aki a földről való, földi az, és földieket szól, aki a mennyből jött, feljebb való mindenkinél. ");
INSERT INTO hun_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","És arról tesz bizonyságot, amit látott és hallott, és az ő bizonyságtételét senki sem fogadja be. ");
INSERT INTO hun_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Aki az ő bizonyságtételét befogadja, az megpecsételte, hogy az Isten igaz. ");
INSERT INTO hun_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Mert akit az Isten küldött, az Isten beszédeit szólja, mivelhogy az Isten nem mérték szerint adja a Lelket. ");
INSERT INTO hun_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Az Atya szereti a Fiút, és az ő kezébe adott mindent. ");
INSERT INTO hun_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Aki hisz a Fiúban, örök élete van, aki pedig nem enged a Fiúnak, nem lát életet, hanem az Isten haragja marad rajta.“ ");
INSERT INTO hun_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Amint azért megtudta Jézus, hogy a farizeusok meghallották, hogy ő több tanítványt szerez és keresztel, mint János – ");
INSERT INTO hun_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","jóllehet Jézus maga nem keresztelt, hanem a tanítványai – , ");
INSERT INTO hun_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","elhagyta Júdeát, és elment ismét Galileába. ");
INSERT INTO hun_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Samárián kellett pedig átmennie. ");
INSERT INTO hun_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Elment tehát Samáriának Sikár nevű városába, annak a teleknek szomszédjába, amelyet Jákób adott fiának, Józsefnek. ");
INSERT INTO hun_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ott volt pedig Jákób forrása. Jézus, az utazástól elfáradva, azonnal leült a forráshoz. Mintegy hat óra volt. ");
INSERT INTO hun_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Odajött egy samáriai asszony vizet meríteni, és Jézus ezt mondta neki: „Adj innom!“ ");
INSERT INTO hun_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","A tanítványai ugyanis elmentek a városba, hogy ennivalót vegyenek. ");
INSERT INTO hun_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","A samáriai asszony pedig ezt mondta neki: „Hogyan kérhetsz inni zsidó létedre tőlem, aki samáriai asszony vagyok?!“ Mert a zsidók nem barátkoznak a samáriaiakkal. ");
INSERT INTO hun_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jézus így felelt neki: „Ha ismernéd az Isten ajándékát, és hogy ki az, aki ezt mondja neked: Adj innom!, te kérted volna őt, és adott volna neked élő vizet.“ ");
INSERT INTO hun_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Mondta neki az asszony: „Uram, nincs mivel merítened, és a kút mély: honnan vennéd tehát az élő vizet? ");
INSERT INTO hun_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Talán nagyobb vagy te a mi atyánknál, Jákobnál, aki nekünk adta ezt a kutat, és ebből ivott ő is, a fiai is és jószágai is?“ ");
INSERT INTO hun_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jézus így felelt neki: „Mindenki, aki ebből a vízből iszik, ismét megszomjazik, ");
INSERT INTO hun_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","aki pedig abból a vízből iszik, amelyet én adok neki, soha többé meg nem szomjazik, mert az a víz, amelyet én adok neki, örök életre buzgó víznek forrása lesz ő benne.“ ");
INSERT INTO hun_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Mondta neki az asszony: „Uram, add nekem azt a vizet, hogy meg ne szomjazzam, és ne jöjjek ide meríteni!“ ");
INSERT INTO hun_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Mondta neki Jézus: „Menj el, hívd a férjedet, és jöjj ide!“ ");
INSERT INTO hun_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Az asszony így felelt: „Nincs férjem.“ Jézus ezt mondta nekik: „Jól mondod, hogy nincs férjed, ");
INSERT INTO hun_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","mert öt férjed volt, és a mostani nem férjed: ezt igazán mondtad.“ ");
INSERT INTO hun_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Mondta neki az asszony: „Uram, látom, hogy te próféta vagy. ");
INSERT INTO hun_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","A mi atyáink ezen a hegyen imádkoztak, és ti azt mondjátok, hogy Jeruzsálemben van az a hely, ahol imádkozni kell.“ ");
INSERT INTO hun_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Mondta neki Jézus: „Asszony, hidd el nekem, hogy eljön az óra, amikor sem ezen a hegyen, sem Jeruzsálemben imádjátok az Atyát. ");
INSERT INTO hun_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ti azt imádjátok, amit nem ismertek, mi azt imádjuk, amit ismerünk: mert az üdvösség a zsidók közül támadt. ");
INSERT INTO hun_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","De eljön az óra, és az most van, amikor az igazi imádók lélekben és igazságban imádják az Atyát: mert az Atya is ilyen imádókat keres magának. ");
INSERT INTO hun_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Az Isten Lélek: és akik őt imádják, szükséges, hogy lélekben és igazságban imádják.“ ");
INSERT INTO hun_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Mondta neki az asszony: „Tudom, hogy Messiás jön, akit Krisztusnak mondanak, és amikor eljön, megjelent nekünk mindent.“ ");
INSERT INTO hun_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Mondta neki Jézus: „Én vagyok az, aki veled beszélek.“ ");
INSERT INTO hun_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Eközben megjöttek a tanítványai, és csodálkoztak, hogy asszonnyal beszélt, de egyik sem mondta: „Mit keresel, vagy mit beszélsz vele?“ ");
INSERT INTO hun_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Az asszony pedig otthagyta a vedrét, és elment a városba, és ezt mondta az embereknek: ");
INSERT INTO hun_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","„Gyertek, lássatok egy embert, aki megmondott nekem mindent, amit cselekedtem. Nem ez-e a Krisztus?“ ");
INSERT INTO hun_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Kimentek tehát a városból, és odamentek hozzá. ");
INSERT INTO hun_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Eközben pedig kérték őt a tanítványok, ezt mondva: „Mester, egyél!“ ");
INSERT INTO hun_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ő pedig mondta nekik: „Van nekem eledelem, amit egyek, amiről ti nem tudtok.“ ");
INSERT INTO hun_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","A tanítványok ezt mondták egymásnak: „Hozott neki valaki enni?“ ");
INSERT INTO hun_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jézus ezt mondta nekik: „Az én eledelem az, hogy annak akaratát cselekedjem, aki elküldött engem, és az ő munkáját bevégezzem. ");
INSERT INTO hun_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ti nem azt mondjátok-e, hogy még négy hónap, és eljön az aratás? Íme, mondom néktek: Emeljétek fel szemeiteket, és nézzétek meg a tájakat, már fehérek az aratásra. ");
INSERT INTO hun_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Aki arat, jutalmat nyer, és az örök életre gyümölcsöt gyűjt, hogy mind a vető, mind az arató együtt örvendezzen. ");
INSERT INTO hun_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Mert ebben az a mondás igaz, hogy más a vető, más az arató. ");
INSERT INTO hun_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Én annak az aratására küldtelek titeket, amit nem ti munkáltatok, mások munkálták, és ti a mások munkájába álltatok.“ ");
INSERT INTO hun_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Abból a városból pedig sokan hittek benne a samáriaiak közül annak az asszonynak beszédéért, aki bizonyságot tett: „Mindent megmondott nekem, amit cselekedtem.“ ");
INSERT INTO hun_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Amint azért odamentek hozzá a samáriaiak, kérték őt, hogy maradjon náluk, és ott maradt két napig. ");
INSERT INTO hun_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Még sokkal többen hittek az ő beszédéért, ");
INSERT INTO hun_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","és azt mondták az asszonynak: „Nem a te beszédedért hiszünk immár, hanem magunk hallottuk, és tudjuk, hogy bizonnyal ő a világ üdvözítője, a Krisztus.“ ");
INSERT INTO hun_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Két nap múlva pedig kiment onnan, és elment Galileába. ");
INSERT INTO hun_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Mert Jézus maga tett bizonyságot arról, hogy a prófétának nincs tisztessége a maga hazájában. ");
INSERT INTO hun_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Mikor azért bement Galileába, befogadták őt a galileabeliek, mert látták mindazt, amit Jeruzsálemben cselekedett az ünnepen, mert ők is elmentek az ünnepre. ");
INSERT INTO hun_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ismét a galileai Kánába ment Jézus, ahol a vizet borrá változtatta. És volt Kapernaumban egy királyi ember, akinek a fia beteg volt. ");
INSERT INTO hun_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Mikor meghallotta, hogy Jézus Júdeából Galileába érkezett, odament hozzá, és arra kérte, hogy menjen el, és gyógyítsa meg az ő fiát, mert halálán volt. ");
INSERT INTO hun_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jézus ez mondta neki: „Ha jeleket és csodákat nem láttok, nem hisztek.“ ");
INSERT INTO hun_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","A királyi ember ezt mondta neki: „Uram, jöjj, mielőtt a gyermekem meghal.“ ");
INSERT INTO hun_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jézus ezt mondta neki: „Menj el, a te fiad él.“ És hitt az ember a szónak, amit Jézus mondott neki, és elment. ");
INSERT INTO hun_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Amint pedig már ment, elébe jöttek az ő szolgái, és hírt hoztak, mondván: „A te fiad él.“ ");
INSERT INTO hun_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Megtudakozta azért tőlük az órát, amelyben jobban lett, és mondták neki: „Tegnap hét órakor hagyta el őt a láz.“ ");
INSERT INTO hun_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Megértette ekkor az atya, hogy abban az órában, amelyben azt mondta neki Jézus: „A te fiad él.“ És hitt ő, és az ő egész háza népe. ");
INSERT INTO hun_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ezt pedig második jel gyanánt tette Jézus, mikor Júdeából Galileába ment. ");
INSERT INTO hun_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ezek után ünnepük volt a zsidóknak, és felment Jézus Jeruzsálembe. ");
INSERT INTO hun_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Van pedig Jeruzsálemben a Juh-kapunál egy tó, amelyet héberül Betesdának neveznek. Öt tornáca van. ");
INSERT INTO hun_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ezekben feküdtek a betegek, vakok, sánták, sorvadásosak nagy sokasága, várva a víznek megmozdulását. ");
INSERT INTO hun_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Mert időnként angyal szállt a tóra, és felkavarta a vizet: aki pedig először lépett bele a víz felkavarása után, meggyógyult, akármilyen betegségben volt. ");
INSERT INTO hun_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Volt pedig ott egy ember, aki harmincnyolc esztendőt töltött betegségében. ");
INSERT INTO hun_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Amint látta Jézus, hogy ott fekszik, és megtudta, hogy már sok idő óta úgy van, ezt mondta neki: „Akarsz-e meggyógyulni?“ ");
INSERT INTO hun_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","A beteg ezt felelte: „Uram, nincs emberem, hogy amikor a víz felkavarodik, bevigyen engem a tóba, és mire én odaérek, más lép be előttem.“ ");
INSERT INTO hun_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Mondta neki Jézus: „Kelj fel, vedd fel az ágyadat, és járj!“ ");
INSERT INTO hun_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","És azonnal meggyógyult az ember, és felvette ágyát, és járt. Aznap pedig szombat volt. ");
INSERT INTO hun_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","A zsidók pedig ezt mondták a meggyógyultnak: „Szombat van, nem szabad neked az ágyadat hordanod!“ ");
INSERT INTO hun_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ő ezt felelte nekik: „Aki meggyógyított engem, az mondta nekem: Vedd fel az ágyadat, és járj!“ ");
INSERT INTO hun_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Megkérdezték tőle: „Ki az az ember, aki ezt mondta neked: Vedd fel az ágyadat, és járj?“ ");
INSERT INTO hun_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","A meggyógyult pedig nem tudta, hogy ki az, mert Jézus félrevonult, mert sokaság volt azon a helyen. ");
INSERT INTO hun_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ezek után Jézus találkozott vele a templomban, és mondta neki: „Íme, meggyógyultál, többé ne vétkezzél, hogy rosszabbul ne legyen dolgod!“ ");
INSERT INTO hun_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Elment az az ember, és hírül adta a zsidóknak, hogy Jézus az, aki őt meggyógyította. ");
INSERT INTO hun_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Emiatt üldözőbe vették a zsidók Jézust, és meg akarták őt ölni, hogy ezeket művelte szombaton. ");
INSERT INTO hun_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Jézus pedig felelte nekik: „Az én Atyám mind ez ideig munkálkodik, én is munkálkodom.“ ");
INSERT INTO hun_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Emiatt aztán még inkább meg akarták őt ölni a zsidók, mivel nemcsak a szombatot törte meg, hanem az Istent is saját Atyjának mondta, egyenlővé téve magát az Istennel. ");
INSERT INTO hun_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jézus ezt felelte nekik: „Bizony, bizony mondom néktek: a Fiú semmit sem tehet önmagától, csak ha látja cselekedni az Atyát, mert amiket ő cselekszik, ugyanazokat hasonlatosképpen a Fiú is cselekszi. ");
INSERT INTO hun_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Mert az Atya szereti a Fiút, és mindent megmutat neki, amiket ő maga cselekszik, és ezeknél nagyobb dolgokat is mutat majd neki, hogy ti csodálkozzatok. ");
INSERT INTO hun_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Mert amint az Atya feltámasztja a halottakat és megeleveníti, úgy a Fiú is akiket akar, megelevenít. ");
INSERT INTO hun_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Mert az Atya nem ítél senkit, hanem az ítéletet egészen a Fiúnak adta, ");
INSERT INTO hun_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","hogy mindenki úgy tisztelje a Fiút, miként tisztelik az Atyát. Aki nem tiszteli a Fiút, nem tiszteli az Atyát, aki elküldte őt. ");
INSERT INTO hun_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Bizony, bizony mondom néktek, hogy aki az én beszédemet hallja, és hisz annak, aki engem elküldött, örök élete van, és nem megy a kárhozatra, hanem átment a halálból az életre. ");
INSERT INTO hun_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Bizony, bizony mondom néktek, hogy eljön az idő, és az most van, amikor a halottak hallják az Isten Fiának szavát, és akik hallják, élnek. ");
INSERT INTO hun_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Mert amiként az Atyának élete van önmagában, akként adta a Fiúnak is, hogy élete legyen önmagában: ");
INSERT INTO hun_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","És hatalmat adott neki az ítélettételre is, mert ő az Emberfia. ");
INSERT INTO hun_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ne csodálkozzatok ezen: mert eljön az óra, amelyben mindazok, akik a koporsókban vannak, meghallják az ő szavát, ");
INSERT INTO hun_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","és kijönnek. Akik a jót cselekedték, az életre támadnak fel, akik pedig a gonoszt művelték, a kárhozatra támadnak fel. ");
INSERT INTO hun_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Én semmit sem cselekedhetem magamtól, amint hallok, úgy ítélek, és az én ítéletem igazságos, mert nem a magam akaratát keresem, hanem annak akaratát, aki elküldött engem, az Atyáét. ");
INSERT INTO hun_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","„Ha én teszek bizonyságot magamról, az én bizonyságtételem nem igaz. ");
INSERT INTO hun_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Más az, aki bizonyságot tesz rólam, és tudom, hogy igaz az a bizonyságtétel, amellyel bizonyságot tesz rólam. ");
INSERT INTO hun_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ti elküldtetek Jánoshoz, és bizonyságot tett az igazságról. ");
INSERT INTO hun_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","De én nem embertől nyerem a bizonyságtételt, hanem ezeket azért mondom, hogy ti megtartassatok. ");
INSERT INTO hun_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ő az égő és fénylő szövétnek volt, ti pedig csak egy ideig akartatok örvendezni az ő világosságában. ");
INSERT INTO hun_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","De nekem nagyobb bizonyságom van Jánosénál: mert azok a dolgok, amelyeket rám bízott az Atya, hogy elvégezzem azokat, azok a dolgok, amelyeket én cselekszem, azok tesznek bizonyságot rólam, hogy az Atya küldött engem. ");
INSERT INTO hun_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Aki elküldött engem, maga az Atya is bizonyságot tett rólam. Sem hangját nem hallottátok soha, sem ábrázatát nem láttátok. ");
INSERT INTO hun_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Az ő igéje sincs maradandóan bennetek: mert akit ő elküldött, ti annak nem hisztek. ");
INSERT INTO hun_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Tudakozzátok az Írásokat, mert azt hiszitek, hogy azokban van a ti örök életetek, és ezek azok, amelyek bizonyságot tesznek rólam, ");
INSERT INTO hun_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","és nem akartok hozzám jönni, hogy életetek legyen! ");
INSERT INTO hun_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Dicsőséget emberektől nem nyerek. ");
INSERT INTO hun_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","De ismerlek benneteket, hogy az Istennek szeretete nincs meg bennetek: ");
INSERT INTO hun_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Én az én Atyám nevében jöttem, és nem fogadtatok be engem, ha más jönne a maga nevében, azt befogadnátok. ");
INSERT INTO hun_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Mi módon hihettek ti, akik egymástól nyertek dicsőséget, és azt a dicsőséget nem keresitek, amely az egy Istentől van? ");
INSERT INTO hun_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ne állítsátok, hogy én vádollak majd benneteket az Atyánál, van, aki vádol titeket, Mózes, akiben ti reménykedtetek. ");
INSERT INTO hun_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Mert ha hinnétek Mózesnek, nekem is hinnétek, mert rólam írt ő. ");
INSERT INTO hun_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ha pedig az ő Írásainak nem hisztek, mi módon hisztek az én beszédeimnek?“ ");
INSERT INTO hun_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ezek után elment Jézus a Galileai-tengeren, a Tiberiáson túl. ");
INSERT INTO hun_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","És nagy sokaság követte őt, mert látták az ő csodatételeit, amelyeket cselekedett a betegeken. ");
INSERT INTO hun_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Felment pedig Jézus a hegyre, és leült ott a tanítványaival. ");
INSERT INTO hun_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Közel volt pedig húsvét, a zsidók ünnepe. ");
INSERT INTO hun_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Mikor azért felemelte Jézus a szemeit, és látta, hogy nagy sokaság jön hozzá, mondta Fülöpnek: „Honnan vegyünk kenyeret, hogy ehessenek ezek?“ ");
INSERT INTO hun_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ezt pedig azért mondta, hogy próbára tegye őt, mert ő maga tudta, mit akar cselekedni. ");
INSERT INTO hun_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Felelt neki Fülöp: „Kétszáz dénár árú kenyér nem elég nekik, hogy mindegyikük kapjon valami keveset.“ ");
INSERT INTO hun_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Egyik az ő tanítványai közül, András, Simon Péter testvére ezt mondta neki: ");
INSERT INTO hun_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","„Van itt egy gyermek, akinek van öt árpakenyere és két hala, de mi az ennyinek?“ ");
INSERT INTO hun_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jézus pedig mondta: „Ültessétek le az embereket.“ És nagy fű volt azon a helyen. Leültek azért a férfiak, szám szerint mintegy ötezren. ");
INSERT INTO hun_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jézus pedig vette a kenyereket, és hálát adva adta a tanítványoknak, a tanítványok pedig azoknak, akik ültek, hasonlóképpen a halakból is, amennyit akartak. ");
INSERT INTO hun_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Amint pedig jóllaktak, mondta a tanítványainak: „Szedjétek össze a megmaradt darabokat, hogy semmi el ne vesszen.“ ");
INSERT INTO hun_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Összeszedtek azért és megtöltöttek tizenkét kosarat az öt árpakenyérből való darabokkal, amelyek megmaradtak azok után, akik ettek. ");
INSERT INTO hun_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Az emberek azért látva a jelt, amelyet Jézus tett, ezt mondták: „Bizonnyal ez az a próféta, aki eljövendő volt a világra.“ ");
INSERT INTO hun_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jézus pedig, amint észrevette, hogy érte akarnak jönni, és el akarják ragadni, hogy királlyá tegyék, ismét elvonult egymaga a hegyre. ");
INSERT INTO hun_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Mikor pedig beesteledett, lementek az ő tanítványai a tengerhez, ");
INSERT INTO hun_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","és beszállva a hajóba, elmentek a tengeren túlra Kapernaumba. Már sötétség volt, és még mindig nem ment oda hozzájuk Jézus. ");
INSERT INTO hun_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","A tenger a nagy szél fúvása miatt háborgott. ");
INSERT INTO hun_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Mikor azért huszonöt, vagy harminc futamnyira beeveztek, meglátták Jézust, amint jár a tengeren, és a hajóhoz közeledik, megrémültek. ");
INSERT INTO hun_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ő pedig mondta nekik: „Én vagyok, ne féljetek!“ ");
INSERT INTO hun_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Be akarták azért őt venni a hajóba, de a hajó azonnal annál a földnél volt, amelyre mentek. ");
INSERT INTO hun_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Másnap a sokaság, amely a tengeren túl állott, látták, hogy nem volt ott más hajó, csak az az egy, amelybe Jézus tanítványai szálltak, és hogy Jézus nem ment be az ő tanítványaival a hajóba, hanem csak az ő tanítványai mentek el. ");
INSERT INTO hun_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","De jöttek más hajók Tiberiásból közel ahhoz a helyhez, ahol a kenyeret ették, miután hálákat adott az Úr: ");
INSERT INTO hun_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Mikor azért látta a sokaság, hogy sem Jézus, sem a tanítványai nincsenek ott, beszálltak ők is a hajókba, és elmentek Kapernaumba, keresve Jézust. ");
INSERT INTO hun_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","És megtalálva őt a tengeren túl, mondták neki: „Mester, mikor jöttél ide?“ ");
INSERT INTO hun_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jézus így felelt nekik: „Bizony, bizony mondom néktek: nem azért kerestek engem, mert jeleket láttatok, hanem azért, mert ettetek abból a kenyerekből, és jóllaktatok. ");
INSERT INTO hun_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ne azért az eledelért munkálkodjatok, amely elvész, hanem azért az eledelért, amely megmarad az örök életre, amelyet az Emberfia ad majd nektek, mert őt pecsétjével igazolta az Isten.“ ");
INSERT INTO hun_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ők pedig ezt mondták neki: „Mit csináljunk, hogy az Isten dolgait cselekedjük?“ ");
INSERT INTO hun_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jézus így felelt nekik: „Az az Isten dolga, hogy higgyetek abban, akit ő küldött.“ ");
INSERT INTO hun_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Erre megkérdezték: „Micsoda jelt mutatsz tehát te, hogy miután láttuk, higgyünk neked? Mit cselekszel? ");
INSERT INTO hun_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Atyáink a mannát ették a pusztában, amint meg van írva: »Mennyei kenyeret adott enniük.«“ ");
INSERT INTO hun_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Mondta azért nekik Jézus: „Bizony, bizony mondom néktek: nem Mózes adta néktek a mennyei kenyeret, hanem az én Atyám adja majd néktek az igazi mennyei kenyeret. ");
INSERT INTO hun_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Mert az az Istennek kenyere, amely mennyből száll alá, és életet ad a világnak.“ ");
INSERT INTO hun_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Erre ezt mondták neki: „Uram, mindenkor add nékünk ezt a kenyeret!“ ");
INSERT INTO hun_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jézus pedig azt mondta nekik: „Én vagyok az életnek kenyere, aki énhozzám jön, semmiképpen meg nem éhezik, és aki hisz énbennem, meg nem szomjazik soha. ");
INSERT INTO hun_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","De mondtam néktek, hogy noha láttatok engem, még sem hisztek. ");
INSERT INTO hun_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Mindenki, akit nekem ad az Atya, énhozzám jön, és azt, aki hozzám jön, semmiképpen ki nem vetem. ");
INSERT INTO hun_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Mert azért szálltam le a mennyből, hogy ne a magam akaratát cselekedjem, hanem annak akaratát, aki elküldött engem. ");
INSERT INTO hun_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Annak, aki elküldött engem, az az akarata, hogy amit nekem adott, abból semmit el ne veszítsek, hanem feltámasszam azt az utolsó napon. ");
INSERT INTO hun_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Az Atyának az az akarata, hogy mindaz, aki látja a Fiút, és hisz ő benne, örök élete legyen, és én feltámasszam azt az utolsó napon.“ ");
INSERT INTO hun_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Zúgolódtak azért a zsidók őellene, mert azt mondta: „Én vagyok az a kenyér, amely a mennyből szállott alá.“ ");
INSERT INTO hun_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","És mondták: „Nem Jézus ez, a József fia, akinek mi ismerjük atyját és anyját? Akkor hogyan mondhatja: A mennyből szálltam alá?“ ");
INSERT INTO hun_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jézus ezt felelte nekik: „Ne zúgolódjatok egymás között! ");
INSERT INTO hun_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Senki sem jöhet én hozzám, hacsak nem az Atya vonzza, aki elküldött engem, én pedig feltámasztom azt az utolsó napon. ");
INSERT INTO hun_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Meg van írva a prófétáknál: »És mindnyájan Istentől tanítottak lesznek.« Aki azért az Atyától hallott és tanult, én hozzám jön. ");
INSERT INTO hun_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Nem mintha az Atyát valaki látta volna, csak az, aki Istentől van, az látta az Atyát. ");
INSERT INTO hun_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Bizony, bizony mondom néktek: Aki énbennem hisz, örök élete van annak. ");
INSERT INTO hun_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Én vagyok az életnek kenyere. ");
INSERT INTO hun_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","A ti atyáitok a mannát ették a pusztában, és meghaltak. ");
INSERT INTO hun_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ez az a kenyér, amely a mennyből szállt alá, hogy ki-ki egyen belőle, és meg ne haljon. ");
INSERT INTO hun_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Én vagyok az élő kenyér, amely a mennyből szállt alá: ha valaki eszik ebből a kenyérből, él örökké. És az a kenyér pedig, amelyet én adok, az én testem, amelyet én adok a világ életéért.“ ");
INSERT INTO hun_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Tusakodtak azért a zsidók egymás között, mondván: „Hogyan adhatja ez nékünk a testét, hogy azt együk?“ ");
INSERT INTO hun_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jézus ezt mondta nekik: „Bizony, bizony mondom néktek: ha nem eszitek az Emberfiának testét, és nem isszátok az ő vérét, nincs élet bennetek. ");
INSERT INTO hun_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Aki eszi az én testemet, és issza az én véremet, örök élete van annak, és én feltámasztom azt az utolsó napon. ");
INSERT INTO hun_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Mert az én testem bizony étel, és az én vérem bizony ital. ");
INSERT INTO hun_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Aki eszi az én testemet, és issza az én véremet, az énbennem lakik és én is abban. ");
INSERT INTO hun_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ahogyan elküldött engem az élő Atya, és én az Atya által élek: úgy az is, aki engem eszik, él énáltalam. ");
INSERT INTO hun_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ez az a kenyér, amely a mennyből szállt alá, nem úgy, amint a ti atyáitok ették a mannát, és meghaltak: aki ezt a kenyeret eszi, él örökké.“ ");
INSERT INTO hun_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Ezeket mondta a zsinagógában, amikor tanított Kapernaumban. ");
INSERT INTO hun_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Sokan azért, akik hallották ezeket az ő tanítványai közül, ezt mondták: „Kemény beszéd ez, ki hallgathatja őt?“ ");
INSERT INTO hun_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jézus pedig magában tudta, hogy emiatt zúgolódnak az ő tanítványai, ezt mondta nekik: „Titeket ez megbotránkoztat? ");
INSERT INTO hun_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Hát ha meglátjátok az Emberfiát felszállni oda, ahol előbb volt?! ");
INSERT INTO hun_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","A lélek az, ami megelevenít, a test nem használ semmit: a beszédek, amelyeket én szólok nektek, lélek és élet. ");
INSERT INTO hun_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","De vannak némelyek közöttetek, akik nem hisznek.“ Mert kezdettől fogva tudta Jézus, kik azok, akik nem hisznek, és ki az, aki elárulja őt. ");
INSERT INTO hun_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","És ezt mondta: „Azért mondtam néktek, hogy senki sem jöhet énhozzám, hacsak nem az én Atyámtól van megadva neki.“ ");
INSERT INTO hun_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ettől fogva sokan visszavonultak az ő tanítványai közül, és nem jártak többé ővele. ");
INSERT INTO hun_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Mondta azért Jézus a tizenkettőnek: „Vajon ti is el akartok menni?“ ");
INSERT INTO hun_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simon Péter így felelt: „Uram, kihez mehetnénk? Örök életnek beszéde van tenálad. ");
INSERT INTO hun_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","És mi elhittük és megismertük, hogy te vagy a Krisztus, az élő Istennek Fia.“ ");
INSERT INTO hun_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jézus így felelt nekik: „Nem én választottalak ki titeket, a tizenkettőt? És egy közületek ördög.“ ");
INSERT INTO hun_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ezen pedig Júdás Iskáriótest értette, Simon fiát, mert ez akarta őt elárulni, noha egy volt a tizenkettő közül. ");
INSERT INTO hun_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","És ezek után Galileát járta Jézus, mert nem akart Júdeában tartózkodni, mivel azon voltak a júdeabeliek, hogy őt megöljék. ");
INSERT INTO hun_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Közel volt pedig a zsidók ünnepe, a sátoros ünnep. ");
INSERT INTO hun_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Testvérei ekkor azt mondták neki: „Menj el innen, és térj Júdeába, hogy a tanítványaid is lássák azokat, amiket cselekszel. ");
INSERT INTO hun_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Mert senki sem cselekszik titokban semmit, aki maga ismeretté akar lenni. Ha ilyeneket cselekszel, mutasd meg magadat a világnak.“ ");
INSERT INTO hun_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Mert az ő testvérei sem hittek benne. ");
INSERT INTO hun_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ekkor azt mondta nekik Jézus: „Az én időm még nincs itt, a ti időtök pedig mindig készen van. ");
INSERT INTO hun_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Titeket nem gyűlölhet a világ, de engem gyűlöl, mert én bizonyságot teszek arról, hogy az ő cselekedetei gonoszak. ");
INSERT INTO hun_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ti menjetek fel erre az ünnepre: én még nem megyek fel erre az ünnepre, mert az én időm még nem jött el.“ ");
INSERT INTO hun_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ezeket mondva nekik, ott maradt Galileában. ");
INSERT INTO hun_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Amint azonban felmentek az ő testvérei, akkor ő is felment az ünnepre, nem nyilvánosan, hanem mintegy titokban. ");
INSERT INTO hun_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","A zsidók azért keresték őt az ünnepen, és ezt mondták: „Hol van ő?“ ");
INSERT INTO hun_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","És a sokaságban nagy zúgás volt őmiatta. Némelyek azt mondták, hogy jó ember, mások pedig azt mondták: „Nem, hanem a népnek hitetője.“ ");
INSERT INTO hun_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Mindamellett senki sem beszélt nyíltan őróla a zsidóktól való félelem miatt. ");
INSERT INTO hun_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Már-már az ünnep közepén azonban felment Jézus a templomba, és tanított. ");
INSERT INTO hun_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","És csodálkoztak a zsidók, ezt mondva: „Honnan tudja ez az Írásokat, holott nem tanulta?!“ ");
INSERT INTO hun_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jézus erre így felelt nekik: „Az én tudományom nem az enyém, hanem azé, aki elküldött engem. ");
INSERT INTO hun_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ha valaki cselekedni akarja az ő akaratát, megismerheti e tudományról, vajon Istentől van-e, vagy én magamtól szólok? ");
INSERT INTO hun_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Aki magától szól, a maga dicsőségét keresi, aki pedig annak dicsőségét keresi, aki küldte őt, igaz az, és nincs abban hamisság. ");
INSERT INTO hun_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Nem Mózes adta-e néktek a törvényt? Ám senki sem teljesíti közületek a törvényt. Miért akartok engem megölni?“ ");
INSERT INTO hun_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","A sokaság felelt, és ezt mondta: „Ördög van benned. Ki akar téged megölni?“ ");
INSERT INTO hun_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jézus válaszolt, és ezt mondta nekik: „Egy dolgot tettem, és mindnyájan csodálkoztok. ");
INSERT INTO hun_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mózes adta néktek a körülmetélkedést (nem mintha Mózestől való volna, hanem az atyáktól): és szombaton körülmetélitek az embert. ");
INSERT INTO hun_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ha körülmetélhető az ember szombaton, hogy Mózes törvényét meg ne szegjék, akkor rám miért haragusztok, hogy egy embert teljesen meggyógyítottam szombaton? ");
INSERT INTO hun_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ne ítéljetek a látszat után, hanem igaz ítélettel ítéljetek!“ ");
INSERT INTO hun_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ekkor némelyek a jeruzsálemiek közül ezt mondták: „Nem ez-e az, akit meg akarnak ölni? ");
INSERT INTO hun_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","És íme, nyíltan szól, és semmit sem szólnak neki. Talán bizony megismerték a főemberek, hogy bizony ez a Krisztus? ");
INSERT INTO hun_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","De róla jól tudjuk, honnan való, amikor pedig eljön a Krisztus, senki sem tudja, honnan való.“ ");
INSERT INTO hun_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jézus a templomban tanított, és kiáltva ezt mondta: „Ti ismertek engem, azt is tudjátok, honnan való vagyok, és én nem magamtól jöttem, de igaz az, aki engem elküldött, akit ti nem ismertek. ");
INSERT INTO hun_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Én azonban ismerem őt, mert őtőle vagyok, és ő küldött engem.“ ");
INSERT INTO hun_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","El akarták ezért őt fogni, de senki sem vetette rá a kezét, mert nem jött még el az ő órája. ");
INSERT INTO hun_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","A sokaságból pedig sokan hittek benne, és ezt mondták: „A Krisztus, amikor eljön, tehet-e majd több csodát azoknál, amelyeket ez tett?“ ");
INSERT INTO hun_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Meghallották a farizeusok, amint a sokaság ezeket suttogta róla, és szolgákat küldtek a farizeusok és a főpapok, hogy fogják el őt. ");
INSERT INTO hun_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ekkor azt mondta nekik Jézus: „Egy kevés ideig még veletek vagyok, és majd elmegyek ahhoz, aki elküldött engem. ");
INSERT INTO hun_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Kerestek majd engem, és nem találtok meg, ahol én vagyok, ti nem jöhettek oda.“ ");
INSERT INTO hun_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","A zsidók maguk között ezt mondták: „Hová akar ez menni, hogy mi majd nem találjuk meg őt? Vajon a görögök közé szétszórtakhoz akar menni, és a görögöket tanítani? ");
INSERT INTO hun_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Micsoda beszéd ez, amelyet mondott: Kerestek majd engem, és nem találtok meg, ahol én vagyok, ti nem jöhettek oda?“ ");
INSERT INTO hun_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Az ünnep utolsó nagy napján pedig felállt Jézus, és kiáltva ezt mondta: „Ha valaki szomjazik, jöjjön énhozzám, és igyon. ");
INSERT INTO hun_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Aki hisz énbennem, amint az Írás mondta, annak belsejéből élő víznek folyamai ömlenek.“ ");
INSERT INTO hun_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ezt pedig a Lélekről mondta, akit a benne hívők fognak venni: mert még nem volt Szentlélek, mivelhogy Jézus még nem dicsőíttetett meg. ");
INSERT INTO hun_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Sokan azért a sokaság közül, amint hallották e beszédet, ezt mondták: „Bizonnyal ez a Próféta.“ ");
INSERT INTO hun_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Némelyek ezt mondták: „Ez a Krisztus.“ Mások pedig azt mondták: „Csak nem Galileából jön el a Krisztus? ");
INSERT INTO hun_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Nem az Írás mondta-e, hogy a Dávid magvából és Betlehemből, abból a városból jön el a Krisztus, ahol Dávid volt?“ ");
INSERT INTO hun_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ellentét támadt azért őmiatta a sokaságban. ");
INSERT INTO hun_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Némelyek pedig közülük el akarták őt fogni, de senki sem vettette reá a kezét. ");
INSERT INTO hun_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Elmentek azért a szolgák a főpapokhoz és farizeusokhoz, és mondták azok nekik: „Miért nem hoztátok el őt?“ ");
INSERT INTO hun_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","A szolgák így feleltek: „Soha ember úgy nem szólott, mint ez az ember!“ ");
INSERT INTO hun_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","A farizeusok így feleltek nekik: „Vajon ti is meg vagytok tévesztve? ");
INSERT INTO hun_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Vajon a főemberek vagy a farizeusok közül hitt-e benne valaki? ");
INSERT INTO hun_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","De ez a sokaság, amely nem ismeri a törvényt, átkozott!“ ");
INSERT INTO hun_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ezt mondta nekik Nikodémus, aki éjjel ment őhozzá, és aki egy volt közülük: ");
INSERT INTO hun_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","„Vajon a mi törvényünk elítéli-e az embert, ha előbb ki nem hallgatja, és nem tudja, hogy mit cselekszik?“ ");
INSERT INTO hun_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Azok így feleltek neki: „Vajon te is galileai vagy-e? Nézz utána, és lásd meg, hogy Galileából nem támadt próféta.“ ");
INSERT INTO hun_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","És mindnyájan hazamentek. ");
INSERT INTO hun_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jézus pedig elment az Olajfák hegyére. ");
INSERT INTO hun_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Korán reggel azonban ismét ott volt a templomban, az egész nép hozzáment, és leülve tanította őket. ");
INSERT INTO hun_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Az Írástudók és a farizeusok pedig egy asszonyt vittek hozzá, akit házasságtörésen kaptak, és a középre állítva azt, ");
INSERT INTO hun_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","mondták neki: „Mester, ezt az asszonyt tetten érték, mint házasságtörő. ");
INSERT INTO hun_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","A törvényben pedig megparancsolta nékünk Mózes, hogy az ilyeneket kövezzék meg: te azért mit mondasz?“ ");
INSERT INTO hun_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ezt pedig azért mondták, hogy megkísértsék őt, hogy legyen mivel vádolniuk. Jézus pedig lehajolva, az ujjával írt a földre. ");
INSERT INTO hun_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","De mikor ismételten kérdezték őt, felegyenesedve mondta nekik: „Aki közületek nem bűnös, az vesse rá először a követ.“ ");
INSERT INTO hun_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","És újra lehajolva, írt a földre. ");
INSERT INTO hun_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Azok pedig ezt hallva és a lelkiismeret által vádolva, egymás után kimentek a vénektől kezdve mind az utolsóig, és egyedül Jézus maradt, és az asszony középen állva. ");
INSERT INTO hun_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Mikor pedig Jézus felegyenesedett, és senkit sem látott az asszonyon kívül, azt mondta neki: „Asszony, hol vannak a te vádlóid? Senki sem kárhoztat téged?“ ");
INSERT INTO hun_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ő pedig ezt mondta: „Senki, Uram!“ Jézus pedig mondta neki: „Én sem kárhoztatlak, eredj el, és többé ne vétkezzél!“ ");
INSERT INTO hun_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ismét szólt hozzájuk Jézus, és ezt mondta: „Én vagyok a világ világossága: aki engem követ, nem járhat a sötétségben, hanem övé lesz az életnek világossága.“ ");
INSERT INTO hun_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","A farizeusok pedig ezt mondták neki: „Te magadról teszel bizonyságot, a te bizonyságtételed nem igaz.“ ");
INSERT INTO hun_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jézus felelt, és ezt mondta nekik: „Ha magam teszek is bizonyságot magamról, az én bizonyságtételem igaz, mert tudom honnan jöttem, és hová megyek, ti pedig nem tudjátok, honnan jövök, és hová megyek. ");
INSERT INTO hun_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ti test szerint ítéltek, én nem ítélek senkit. ");
INSERT INTO hun_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","De ha ítélek is, az én ítéletem igaz, mert én nem egyedül vagyok, hanem én és az Atya, aki küldött engem. ");
INSERT INTO hun_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Márpedig a ti törvényetekben is meg van írva, hogy két ember bizonyságtétele igaz. ");
INSERT INTO hun_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Én vagyok, aki bizonyságot teszek magamról, és bizonyságot tesz rólam az Atya, aki küldött engem.“ ");
INSERT INTO hun_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ekkor azt mondták neki: „Hol van a te Atyád?“ Jézus így felelt: „Sem engem nem ismertek, sem az én Atyámat, ha engem ismernétek, az én Atyámat is ismernétek.“ ");
INSERT INTO hun_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ezeket a beszédeket mondta Jézus a kincstartó helyen, amikor tanított a templomban, és senki sem fogta el őt, mert még nem jött el az ő órája. ");
INSERT INTO hun_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ismét mondta nekik Jézus: „Én elmegyek, és kerestek majd engem, de ti a bűneitekben fogtok meghalni: ahová én megyek, ti nem jöhettek oda.“ ");
INSERT INTO hun_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","A zsidók pedig ezt mondták: „Talán megöli magát, hogy azt mondja: Ahova én megyek, ti nem jöhettek oda?“ ");
INSERT INTO hun_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","És mondta nekik: „Ti innen lentről valók vagytok, én onnan fentről való vagyok, ti e világból valók vagytok, én nem e világból való vagyok. ");
INSERT INTO hun_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Azért mondtam néktek, hogy a bűneitekben haltok meg: mert ha nem hiszitek, hogy én vagyok, meghaltok a bűneitekben.“ ");
INSERT INTO hun_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Mondták azért neki: „Ki vagy te?“ És mondta nekik Jézus: „Amit eleitől fogva mondok is nektek. ");
INSERT INTO hun_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Sok beszélni és ítélni valóm van felőletek: de igaz az, aki küldött engem, és én azokat beszélem a világnak, amiket tőle hallottam.“ ");
INSERT INTO hun_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Nem vették észre, hogy az Atyáról szólt nekik. ");
INSERT INTO hun_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Mondta azért nekik Jézus: „Amikor felemelitek az Emberfiát, akkor megismeritek, hogy én vagyok, és semmit sem cselekszem magamtól, hanem amint az Atya tanított engem, úgy szólok. ");
INSERT INTO hun_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","És aki küldött engem, velem van. Nem hagyott engem az Atya egyedül, mert én mindenkor azokat cselekszem, amelyek neki kedvesek.“ ");
INSERT INTO hun_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Amikor ezeket mondta, sokan hittek őbenne. ");
INSERT INTO hun_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Mondta azért Jézus a benne hívő zsidóknak: „Ha ti megmaradtok az én beszédemben, bizonnyal az én tanítványaim vagytok, ");
INSERT INTO hun_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","megismeritek az igazságot, és az igazság szabaddá tesz titeket.“ ");
INSERT INTO hun_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Így feleltek neki: „Ábrahám magva vagyunk, és nem szolgáltunk soha senkinek: hogyan mondhatod hát, hogy szabaddá lesztek?“ ");
INSERT INTO hun_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jézus így felelt nekik: „Bizony, bizony mondom néktek, hogy aki bűnt cselekszik, szolgája a bűnnek. ");
INSERT INTO hun_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","A szolga pedig nem marad mindörökké a házban: a Fiú marad ott mindörökké. ");
INSERT INTO hun_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Azért, ha a Fiú megszabadít titeket, valósággal szabadok lesztek.“ ");
INSERT INTO hun_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","„Tudom, hogy Ábrahám utódai vagytok, de meg akartok engem ölni, mert az én beszédemnek nincs helye nálatok. ");
INSERT INTO hun_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Én azt beszélem, amit az én Atyámnál láttam, de ti is azt cselekszitek, amit a ti atyátoknál láttatok.“ ");
INSERT INTO hun_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ezt mondták neki: „A mi atyánk Ábrahám.“ Jézus ezt mondta nekik: „Ha Ábrahám gyermekei volnátok, Ábrahám dolgait cselekednétek. ");
INSERT INTO hun_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ámde meg akartok engem ölni, olyan embert, aki az igazságot beszéltem nektek, amelyet az Istentől hallottam. Ábrahám ezt nem cselekedte. ");
INSERT INTO hun_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ti az atyátok dolgait cselekszitek.“ Ők pedig ezt mondták neki: „Mi nem paráznaságból születtünk, egy Atyánk van, az Isten.“ ");
INSERT INTO hun_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jézus pedig ezt mondta nekik: „Ha az Isten volna a ti Atyátok, szeretnétek engem: mert én az Istentől származtam és jöttem, mert nem magamtól jöttem, hanem ő küldött engem. ");
INSERT INTO hun_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Miért nem értitek az én beszédemet? Mert nem hallgatjátok az én szavamat. ");
INSERT INTO hun_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","A ti atyátok az ördög, és a ti atyátok kívánságait akarjátok teljesíteni. Ő emberölő volt kezdettől fogva, és nem állt meg az igazságban, mert nincsen ő benne igazság. Mikor hazugságot szól, a sajátjából szól, mert hazug, és hazugság atyja. ");
INSERT INTO hun_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Mivel pedig én igazságot szólok, nem hisztek nekem. ");
INSERT INTO hun_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ki vádol engem közületek bűnnel? Ha pedig igazságot szólok: miért nem hisztek nekem? ");
INSERT INTO hun_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Aki az Istentől van, hallgatja az Isten beszédeit, azért nem hallgatjátok ti, mert nem vagytok az Istentől valók.“ ");
INSERT INTO hun_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","A zsidók így feleltek neki: „Nem jól mondjuk-e mi, hogy te samáriai vagy, és ördög van benned?“ ");
INSERT INTO hun_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jézus így felelt: „Nincs énbennem ördög, hanem tisztelem az én Atyámat, és ti gyaláztok engem. ");
INSERT INTO hun_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Pedig én nem keresem a dicsőségemet: van, aki keresi, és megítéli. ");
INSERT INTO hun_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Bizony, bizony mondom néktek, ha valaki megtartja az én beszédemet, nem lát halált soha.“ ");
INSERT INTO hun_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","A zsidók pedig ezt mondták neki: „Most értettük meg, hogy ördög van benned. Ábrahám meghalt, a próféták is, és te azt mondod: ha valaki megtartja az én beszédemet, nem kóstol halált soha. ");
INSERT INTO hun_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Vagy pedig nagyobb vagy te atyánknál, Ábrahámnál, aki meghalt? A próféták is meghaltak: kinek állítod magadat?“ ");
INSERT INTO hun_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jézus így felelt: „Ha én dicsőítem magamat, az én dicsőségem semmi: az én Atyám az, aki dicsőít engem, akiről ti azt mondjátok, hogy a ti Istenetek, ");
INSERT INTO hun_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","és nem ismeritek őt: de én ismerem, és ha azt mondom, hogy nem ismerem őt, hozzátok hasonlóvá, hazuggá leszek: de ismerem őt, és az ő beszédét megtartom. ");
INSERT INTO hun_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ábrahám a ti atyátok örvendezett, hogy meglátja az én napomat, látta is, és örült.“ ");
INSERT INTO hun_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","A zsidók pedig ezt mondták neki: „Még ötvenesztendős sem vagy, és Ábrahámot láttad?“ ");
INSERT INTO hun_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Mondta nekik Jézus: „Bizony, bizony mondom néktek: mielőtt Ábrahám lett volna: én vagyok.“ ");
INSERT INTO hun_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Erre köveket ragadtak, hogy reáhajigálják. Jézus pedig elrejtőzködött, és kiment a templomból, átmenve közöttük, és ilyen módon eltávozott. ");
INSERT INTO hun_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","És amint eltávozott, látott egy embert, aki születésétől fogva vak volt. ");
INSERT INTO hun_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","És kérdezték őt a tanítványai, ezt mondva: „Mester, ki vétkezett, ez vagy ennek szülei, hogy vakon született?“ ");
INSERT INTO hun_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jézus így felelt: „Nem ő vétkezett, nem is a szülei, hanem azért van ez így, hogy nyilvánvalókká legyenek benne az Isten dolgai. ");
INSERT INTO hun_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Nekem cselekednem kell annak dolgait, aki elküldött engem, amíg nappal van: eljön az éjszaka, amikor senki sem munkálkodhat. ");
INSERT INTO hun_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Míg e világon vagyok, e világ világossága vagyok.“ ");
INSERT INTO hun_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ezeket mondva, a földre köpött, és a nyálából sarat csinált, és rákente a sarat a vak szemeire, ");
INSERT INTO hun_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","és mondta neki: „Menj el, mosakodj meg a Siloám-tavában“ – ami azt jelenti: küldött. Elment tehát és megmosakodott, és mire megjött, látott. ");
INSERT INTO hun_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","A szomszédok, és akik korábban látták azt, hogy vak volt, ezt mondták: „Nem ő-e az, aki itt szokott ülni és koldulni?“ ");
INSERT INTO hun_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Némelyek azt mondák, hogy ez az, mások pedig azt, hogy hasonlít hozzá. De ő kijelentette: „Én vagyok az.“ ");
INSERT INTO hun_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ekkor ezt mondták neki: „Hogyan nyíltak meg a te szemeid?“ ");
INSERT INTO hun_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ő így felelt, és ezt mondta: „Egy ember, akit Jézusnak hívnak, sarat készített, és rákente a szemeimre, és ezt mondta nekem: Menj el a Siloám-tavára, és mosakodjál meg. Miután pedig elmentem és megmosakodtam, megjött a látásom.“ ");
INSERT INTO hun_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ekkor ezt mondták neki: „Hol van ő?“ Ő pedig mondta: „Nem tudom.“ ");
INSERT INTO hun_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ekkor elvitték őt, aki előbb még vak volt, a farizeusokhoz. ");
INSERT INTO hun_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Mikor pedig Jézus a sarat csinálta, és felnyitotta a szemeit, szombat volt. ");
INSERT INTO hun_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","A farizeusok szintén megkérdezték, hogyan jött meg a látása? Ő pedig ezt mondta nekik: „Sarat tett a szemeimre, megmosakodtam, és látok.“ ");
INSERT INTO hun_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Mondták azért némelyek a farizeusok közül: „Ez az ember nincsen Istentől, mert nem tartja meg a szombatot.“ Mások ezt mondták: „Hogyan tehet bűnös ember ilyen jeleket?“ És meghasonlás támadt köztük. ");
INSERT INTO hun_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Újra mondták a vaknak: „Te mit mondasz róla, hogy megnyitotta a szemeidet?“ Ő pedig mondta: „Hogy próféta.“ ");
INSERT INTO hun_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","A zsidók pedig nem hitték róla, hogy vak volt, és megjött a látása, mígnem előhívták annak szüleit, akinek megjött a látása. ");
INSERT INTO hun_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","És megkérdezték őket, ezt mondva: „Ez a ti fiatok, akiről azt mondjátok, hogy vakon született? Mi módon lát hát most?“ ");
INSERT INTO hun_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","A szülei ezt felelték, és mondták nekik: „Tudjuk, hogy ez a mi fiunk, és hogy vakon született: ");
INSERT INTO hun_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","de miképpen lát most, nem tudjuk, vagy ki nyitotta meg a szemeit, mi nem tudjuk. Elég idős már, őt kérdezzétek, ő beszéljen magáról.“ ");
INSERT INTO hun_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ezeket mondták az ő szülei, mivel féltek a zsidóktól, mert megegyeztek már a zsidók, hogy ha valaki Krisztusnak vallja őt, ki kell rekeszteni a gyülekezetből. ");
INSERT INTO hun_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ezért mondták a szülei, hogy elég idős, őt kérdezzétek. ");
INSERT INTO hun_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Másodszor is odahívták az embert, aki vak volt, és mondták neki: „Dicsőítsd az Istent: mi tudjuk, hogy ez az ember bűnös.“ ");
INSERT INTO hun_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ő pedig így válaszolt: „Hogy bűnös-e, nem tudom: egyet tudok, hogy noha vak voltam, most látok.“ ");
INSERT INTO hun_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ekkor újra megkérdezték tőle: „Mit csinált veled? Hogyan nyitotta meg a szemeidet?“ ");
INSERT INTO hun_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ő így felelt: „Már mondtam nektek, és nem hallottátok meg: miért akarjátok újra hallani? Vagy ti is az ő tanítványai akartok lenni?“ ");
INSERT INTO hun_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Szidalmazták őt, és ezt mondták: „Te vagy az ő tanítványa, mi pedig Mózes tanítványai vagyunk. ");
INSERT INTO hun_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Mi tudjuk, hogy Mózessel beszélt az Isten: erről pedig azt sem tudjuk, honnan való.“ ");
INSERT INTO hun_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Az az ember így válaszolt nekik: „Bizony az a csodálatos, hogy ti nem tudjátok honnan való, pedig az én szemeimet megnyitotta. ");
INSERT INTO hun_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Pedig tudjuk, hogy az Isten nem hallgatja meg a bűnösöket, hanem ha valaki istenfélő, és az ő akaratát cselekszi, azt hallgatja meg. ");
INSERT INTO hun_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Örök időktől fogva nem hallotta senki, hogy vakon szülöttnek szemeit valaki megnyitotta volna. ");
INSERT INTO hun_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ha ő nem Istentől volna, semmit sem tudott volna cselekedni.“ ");
INSERT INTO hun_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ekkor ezt mondták neki: „Te mindenestől bűnben születtél, és te tanítasz minket?“ És kiközösítették őt. ");
INSERT INTO hun_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Meghallotta Jézus, hogy kiközösítették őt, és amikor találkozott vele, ezt mondta neki: „Hiszel-e az Isten Fiában?“ ");
INSERT INTO hun_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Az így válaszolt: „Ki az, Uram, hogy higgyek benne?“ ");
INSERT INTO hun_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jézus pedig ezt mondta neki: „Láttad őt, és aki beszél veled, ő az.“ ");
INSERT INTO hun_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Erre azt mondta: „Hiszek, Uram.“ És imádta őt. ");
INSERT INTO hun_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jézus pedig azt mondta: „Ítélet végett jöttem én e világra, hogy akik nem látnak, lássanak, és akik látnak, vakok legyenek.“ ");
INSERT INTO hun_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Némely farizeus meghallotta ezt, akik vele voltak, és mondták neki: „Talán mi is vakok vagyunk?“ ");
INSERT INTO hun_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jézus azt mondta nekik: „Ha vakok volnátok, nem volna bűnötök, ámde azt mondjátok, hogy látunk: ezért a ti bűnötök megmarad.“ ");
INSERT INTO hun_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","„Bizony, bizony mondom néktek: Aki nem az ajtón megy be a juhok aklába, hanem máshonnan hatol be, tolvaj az és rabló. ");
INSERT INTO hun_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Aki pedig az ajtón megy be, az a juhok pásztora. ");
INSERT INTO hun_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ennek az őr ajtót nyit, és a juhok hallgatnak szavára, és a maga juhait nevükön szólítja, és kivezeti őket. ");
INSERT INTO hun_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","És mikor kiereszti a juhait, előttük megy, és a juhok követik őt, mert ismerik az ő hangját. ");
INSERT INTO hun_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Idegent pedig nem követnek, hanem elfutnak attól: mert nem ismerik az idegenek hangját.“ ");
INSERT INTO hun_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ezt a példázatot mondta nekik Jézus, de ők nem értették, mi az, amit mondott nekik. ");
INSERT INTO hun_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Újra mondta azért nekik Jézus: „Bizony, bizony mondom néktek, hogy én vagyok a juhoknak ajtaja. ");
INSERT INTO hun_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Mindazok, akik előttem jöttek, tolvajok és rablók: de nem hallgattak rájuk a juhok. ");
INSERT INTO hun_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Én vagyok az ajtó: ha valaki énrajtam megy be, megtartatik, bejár és kijár majd, és legelőt talál. ");
INSERT INTO hun_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","A tolvaj nem egyébért jön, hanem hogy lopjon, öljön és pusztítson, én azért jöttem, hogy életük legyen, és bővölködjenek. ");
INSERT INTO hun_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Én vagyok a jó pásztor: a jó pásztor életét adja a juhokért. ");
INSERT INTO hun_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","A béres pedig nem igazi pásztor, neki a juhok nem tulajdonai. Amikor látja a farkast jönni, elhagyja a juhokat, és elfut: a farkas elragadja azokat, és elszéleszti a juhokat. ");
INSERT INTO hun_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","A béres pedig azért fut el, mert béres, és nincs gondja a juhokra. ");
INSERT INTO hun_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Én vagyok a jó pásztor, ismerem az enyéimet, és engem is ismernek az enyéim. ");
INSERT INTO hun_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Ahogyan ismer engem az Atya, én is ismerem az Atyát, és életemet adom a juhokért. ");
INSERT INTO hun_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Más juhaim is vannak nekem, amelyek nem ebből az akolból valók: azokat is elő kell vezetnem, hallgatnak majd az én szavamra, és lesz egy akol és egy pásztor. ");
INSERT INTO hun_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Azért szeret engem az Atya, mert én leteszem az én életemet, hogy újra felvegyem azt. ");
INSERT INTO hun_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Senki sem veszi azt el éntőlem, hanem én adom oda azt magamtól. Van hatalmam odaadni, és van hatalmam ismét visszavenni azt. Ezt a parancsolatot kaptam az én Atyámtól.“ ");
INSERT INTO hun_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Újra meghasonlás támadt a zsidók között e beszédek miatt. ");
INSERT INTO hun_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Sokan mondták közülük: „Ördög van benne, és bolondozik, mit hallgattok reá?“ ");
INSERT INTO hun_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Mások azt mondták: „Ezek nem megszállott ember beszédei. Vajon az ördög megnyithatja-e a vakok szemeit?“ ");
INSERT INTO hun_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Jeruzsálemben pedig a templomszentelés ünnepe és tél volt. ");
INSERT INTO hun_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jézus a templomban, Salamon tornácában járt. ");
INSERT INTO hun_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Körülvették azért a zsidók, és mondták neki: „Meddig tartasz még bizonytalanságban bennünket? Ha te vagy a Krisztus, mondd meg nékünk nyíltan!“ ");
INSERT INTO hun_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jézus így felelt: „Megmondtam néktek, és nem hiszitek: a cselekedetek, amelyeket én cselekszem az én Atyám nevében, azok tesznek bizonyságot rólam. ");
INSERT INTO hun_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","De ti nem hisztek, mert ti nem az én juhaim közül vagytok, amint megmondtam néktek. ");
INSERT INTO hun_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Az én juhaim hallják az én szavamat, én ismerem őket, és követnek engem. ");
INSERT INTO hun_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Örök életet adok nekik, soha el nem vesznek, és senki ki nem ragadja őket az én kezemből. ");
INSERT INTO hun_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Az én Atyám, aki őket adta nekem, nagyobb mindennél, senki sem ragadhatja ki őket az Atyámnak kezéből. ");
INSERT INTO hun_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Én és az Atya egy vagyunk.“ ");
INSERT INTO hun_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ekkor ismét köveket ragadtak a zsidók, hogy megkövezzék őt. ");
INSERT INTO hun_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jézus így felelt nekik: „Sok jó dolgot mutattam nektek az én Atyámtól, azok közül melyikért köveztek meg engem?“ ");
INSERT INTO hun_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","A zsidók így feleltek neki: „Jó dologért nem kövezünk meg téged, hanem káromlásért, tudniillik, hogy te ember létedre Istenné teszed magadat.“ ");
INSERT INTO hun_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jézus így felelt nekik: „Nincs-e megírva a ti törvényetekben: »én mondtam: istenek vagytok«? ");
INSERT INTO hun_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ha azokat isteneknek mondta, akikhez az Isten beszéde szólt, márpedig az Írást nem lehet érvénytelenné tenni, ");
INSERT INTO hun_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","akkor arról ti azt mondjátok, akit az Atya megszentelt és elküldött e világra: Káromlást szólsz, mivelhogy azt mondtam: az Isten Fia vagyok?! ");
INSERT INTO hun_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ha az én Atyám dolgait nem cselekszem, ne higgyetek nekem, ");
INSERT INTO hun_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","ha pedig azokat cselekszem, ha nekem nem hisztek is, higgyetek a cselekedeteknek: hogy megtudjátok és elhiggyétek, hogy az Atya énbennem van, és én őbenne vagyok.“ ");
INSERT INTO hun_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ismét meg akarták azért őt fogni, de kiment a kezük közül. ");
INSERT INTO hun_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Jézus újra elment, túl a Jordánon, arra a helyre, ahol János először keresztelt, és ott maradt. ");
INSERT INTO hun_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","És sokan mentek oda hozzá, és mondták, hogy János nem tett ugyan semmi csodát, de mindaz, amit János felőle mondott, igaz volt. ");
INSERT INTO hun_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","És sokan hittek ott ő benne. ");
INSERT INTO hun_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Volt pedig egy beteg ember, Lázár, Bethániából, Máriának és az ő testvérének, Mártának falujából. ");
INSERT INTO hun_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Az a Mária volt az, aki megkente az Urat kenettel, és a hajával törölte meg annak lábait: az ő testvére, Lázár volt beteg. ");
INSERT INTO hun_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Testvérei tehát hozzá küldtek, s ezt üzenték: „Uram, íme, akit szeretsz, beteg.“ ");
INSERT INTO hun_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jézus pedig, amikor ezt meghallotta, ezt mondta: „Ez a betegség nem halálos, hanem az Isten dicsőségére való, hogy dicsőíttessék általa az Istennek Fia.“ ");
INSERT INTO hun_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jézus pedig szerette Mártát és annak nővérét és Lázárt. ");
INSERT INTO hun_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Mikor tehát meghallotta, hogy beteg, akkor két napig maradt azon a helyen, ahol volt, ");
INSERT INTO hun_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","de azután ezt mondta tanítványainak: „Menjünk ismét Júdeába.“ ");
INSERT INTO hun_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","A tanítványok ezt mondták neki: „Mester, most akartak téged megkövezni a júdabeliek, és újra odamégy?“ ");
INSERT INTO hun_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jézus így felelt: „Vagy nem tizenkét órája van-e a napnak? Ha valaki nappal jár, nem botlik meg, mert látja a világnak világosságát. ");
INSERT INTO hun_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","De aki éjjel jár, megbotlik, mert nincsen abban világosság.“ ");
INSERT INTO hun_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ezeket mondta nekik, és hozzátette: „Lázár, a mi barátunk, elaludt, de elmegyek, hogy felköltsem őt.“ ");
INSERT INTO hun_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","A tanítványai azt mondták erre: „Uram, ha elaludt, meggyógyul.“ ");
INSERT INTO hun_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Pedig Jézus a haláláról beszélt, de ők azt hitték, hogy álomba merülésről szól. ");
INSERT INTO hun_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ekkor aztán Jézus nyíltan megmondta nekik: „Lázár meghalt, ");
INSERT INTO hun_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","és örülök, hogy nem voltam ott, tiértetek, hogy higgyetek. De menjünk el őhozzá!“ ");
INSERT INTO hun_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tamás, akit Ikernek hívtak, azt mondta tanítványtársainak: „Menjünk el mi is, hogy meghaljunk vele.“ ");
INSERT INTO hun_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Jézus pedig elment, és úgy találta, hogy Lázár már négy napja van a sírban. ");
INSERT INTO hun_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betánia pedig közel volt Jeruzsálemhez, mintegy tizenöt futamnyira, ");
INSERT INTO hun_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","ezért a zsidók közül sokan mentek Mártához és Máriához, hogy vigasztalják őket az ő testvérük miatt. ");
INSERT INTO hun_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Márta, amint meghallotta, hogy Jézus jön, elébe ment, Mária pedig otthon ült. ");
INSERT INTO hun_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Márta ekkor ezt mondta Jézusnak: „Uram, ha itt lettél volna, nem halt volna meg a testvérem. ");
INSERT INTO hun_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","De most is tudom, hogy amit csak kérsz az Istentől, megadja neked az Isten.“ ");
INSERT INTO hun_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jézus ezt mondta neki: „Feltámad a testvéred.“ ");
INSERT INTO hun_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Márta ezt mondta neki: „Tudom, hogy feltámad a feltámadáskor, az utolsó napon.“ ");
INSERT INTO hun_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jézus ezt mondta neki: „Én vagyok a feltámadás és az élet: aki hisz énbennem, ha meghal is, él, ");
INSERT INTO hun_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","és aki él és hisz énbennem, soha meg nem hal. Hiszed-e ezt?“ ");
INSERT INTO hun_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Márta így felelt: „Igen, Uram, én hiszem, hogy te vagy a Krisztus, az Istennek Fia, aki e világra jövendő.“ ");
INSERT INTO hun_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Amint ezeket mondta, elment, és titkon szólította az ő testvérét, Máriát, mondván: „A Mester itt van, és hív téged.“ ");
INSERT INTO hun_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mihelyt ez meghallotta, felkelt hamar, és hozzáment. ");
INSERT INTO hun_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jézus pedig nem ment még be a faluba, hanem azon a helyen volt, ahová Márta elébe ment. ");
INSERT INTO hun_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","A zsidók azért, akik ővele otthon voltak, és vigasztalták őt, látva, hogy Mária hamar felkelt és kiment, utánamentek, ezt mondva: „A sírhoz megy, hogy ott sírjon.“ ");
INSERT INTO hun_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mária pedig, amint odaért, ahol Jézus volt, meglátva őt, a lábaihoz esett, ezt mondva neki: „Uram, ha itt lettél volna, nem halt volna meg az én testvérem.“ ");
INSERT INTO hun_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jézus pedig, amint látta, hogy sír, és sírnak a vele jött zsidók is, elbúsult lelkében, és igen megrendült. ");
INSERT INTO hun_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","És mondta: „Hová helyeztétek őt?“ Mondták neki: „Uram, gyere, és lásd meg!“ ");
INSERT INTO hun_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Könnyekre fakadt Jézus. ");
INSERT INTO hun_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Mondták azért a zsidók: „Íme, mennyire szerette őt!“ ");
INSERT INTO hun_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Némelyek pedig ezt mondták közülük: „Ő, aki a vaknak szemét felnyitotta, nem tehette volna-e meg, hogy ez ne haljon meg?“ ");
INSERT INTO hun_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jézus pedig újra felindulva magában, odament a sírhoz. Az pedig egy üreg volt, és kő feküdt rajta. ");
INSERT INTO hun_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jézus ezt mondta: „Vegyétek el a követ.“ A megholtnak nőtestvére, Márta ezt mondta neki: „Uram, immár szaga van, hiszen negyednapos.“ ");
INSERT INTO hun_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jézus ezt mondta neki: „Nem mondtam neked, hogy ha hiszel, meglátod majd az Istennek dicsőségét?“ ");
INSERT INTO hun_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Elvették azért a követ onnan, ahol a megholt feküdt. Jézus pedig felemelte szemeit az égre, és mondta: „Atyám, hálát adok neked, hogy meghallgattál engem. ");
INSERT INTO hun_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Tudtam is, hogy te mindenkor meghallgatsz engem, csak a körülálló sokaság miatt mondtam, hogy elhiggyék, hogy te küldtél engem.“ ");
INSERT INTO hun_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","És mikor ezeket mondta, fennhangon kiáltott: „Lázár, jöjj ki!“ ");
INSERT INTO hun_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","És kijött a megholt, lábain és kezein kötelékekkel megkötözve, és az orcája kendővel volt leborítva. Mondta nekik Jézus: „Oldozzátok el, és hagyjátok elmenni.“ ");
INSERT INTO hun_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Sokan hittek őbenne azok közül a zsidók közül, akik Máriához mentek, és látták, amiket cselekedett. ");
INSERT INTO hun_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","De némelyek azok közül elmentek a farizeusokhoz, és elbeszélték nekik, amiket Jézus cselekedett. ");
INSERT INTO hun_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Egybegyűjtötték azért a papi fejedelmek és a farizeusok a főtanácsot, és mondták: „Mit cselekedjünk? Mert ez az ember sok csodát művel. ");
INSERT INTO hun_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ha ekképpen hagyjuk őt, mindenki hinni fog ő benne: és eljönnek majd a rómaiak, és elveszik tőlünk mind a helyet is, mind a népet is.“ ");
INSERT INTO hun_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Egy pedig közülük, Kajafás, aki főpap volt abban az esztendőben, mondta nekik: „Ti semmit sem tudtok. ");
INSERT INTO hun_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Még arra sem gondoltok, hogy jobb nékünk, hogy egy ember haljon meg a népért, és ne az egész nép vesszen el.“ ");
INSERT INTO hun_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ezt pedig nem magától mondta: hanem mivel abban az esztendőben főpap volt, jövendőt mondott, hogy Jézus meg fog halni a népért, ");
INSERT INTO hun_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","és nemcsak a népért, hanem azért is, hogy az Istennek elszéledt gyermekeit egybegyűjtse. ");
INSERT INTO hun_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ama naptól azért azon tanakodtak, hogy őt megöljék. ");
INSERT INTO hun_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Jézus tehát nem járt többé nyilvánosan a zsidók között, hanem elment onnan a vidékre, a pusztához közel, egy Efraim nevű városba, és ott tartózkodott az ő tanítványaival. ");
INSERT INTO hun_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Közel volt pedig a zsidók húsvétja: vidékről sokan mentek fel Jeruzsálembe húsvét előtt, hogy megtisztuljanak. ");
INSERT INTO hun_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","A templomban állva keresték Jézust, és így szóltak egymáshoz: „Mit gondoltok, hogy nem jön-e fel az ünnepre?“ ");
INSERT INTO hun_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","A papi fejedelmek pedig és a farizeusok is parancsot adtak, hogy ha valaki megtudja, hogy hol van, jelentse, hogy megfogják. ");
INSERT INTO hun_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Jézus azért hat nappal a húsvét előtt elment Betániába, ahol a meghalt Lázár volt, akit feltámasztott a halálból. ");
INSERT INTO hun_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Vacsorát készítettek ott neki, Márta szolgált fel, Lázár pedig egy volt azok közül, akik együtt ültek ővele. ");
INSERT INTO hun_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mária ekkor elővett egy font igazi, drága nárdusból való kenetet, megkente Jézus lábait, és megtörölte saját hajával, a ház pedig megtelt a kenet illatával. ");
INSERT INTO hun_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Egy az ő tanítványai közül, Iskáriótes Júdás, Simonnak fia, aki őt majd elárulja, ezt mondta: ");
INSERT INTO hun_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","„Miért nem adták el ezt a kenetet háromszáz dénárért, és miért nem adták a szegényeknek?“ ");
INSERT INTO hun_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ezt pedig nem azért mondta, mintha neki a szegényekre volna gondja, hanem mivel tolvaj volt, nála volt az erszény, és amit abba tettek, elcsente. ");
INSERT INTO hun_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jézus erre ezt mondta: „Hagyj békét neki, az én temetésem idejére tartogatta ezt. ");
INSERT INTO hun_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Mert szegények mindenkor vannak veletek, én pedig nem mindenkor vagyok.“ ");
INSERT INTO hun_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","A zsidók közül nagy sokaság értesült arról, hogy ő ott van, és odamentek, nemcsak Jézus miatt, hanem hogy Lázárt is lássák, akit feltámasztott a halálból. ");
INSERT INTO hun_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","A papi fejedelmek pedig tanácskoztak, hogy Lázárt is megöljék, ");
INSERT INTO hun_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","mivel a zsidók közül sokan miatta mentek oda, és hittek Jézusban. ");
INSERT INTO hun_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Másnap a nagy sokaság, amely az ünnepre jött, hallván, hogy Jézus Jeruzsálembe jön, ");
INSERT INTO hun_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","pálmaágakat vett, kiment elé, és így kiáltott: „Hozsánna! Áldott, aki jön az Úrnak nevében, az Izraelnek Királya!“ ");
INSERT INTO hun_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jézus pedig talált egy szamarat, felült rá, amint meg van írva: ");
INSERT INTO hun_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","„Ne félj, Sionnak leánya! Íme, királyod jön, szamárcsikón ülve.“ ");
INSERT INTO hun_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ezeket pedig nem értették eleinte az ő tanítványai: hanem amikor Jézus megdicsőült, akkor emlékeztek vissza, hogy azokat művelték vele, amik róla meg vannak írva. ");
INSERT INTO hun_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","A sokaság pedig, amely vele volt, amikor kihívta Lázárt a koporsóból, és feltámasztotta őt a halálból, bizonyságot tett. ");
INSERT INTO hun_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Azért is ment elébe a sokaság, mivel hallotta, hogy ezt a csodát művelte. ");
INSERT INTO hun_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","A farizeusok egymás között ezt mondták: „Látjátok-e, hogy semmit sem értek? Íme, a világ őutána megy.“ ");
INSERT INTO hun_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Néhány görög is volt azok között, akik felmentek, hogy imádkozzanak az ünnepen. ");
INSERT INTO hun_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ezek a galileai Bétsaidából való Fülöphöz mentek, és kérték őt, ezt mondván: „Uram, látni akarjuk Jézust.“ ");
INSERT INTO hun_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Fülöp elment, és szólt Andrásnak, András és Fülöp pedig szólt Jézusnak. ");
INSERT INTO hun_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jézus pedig ezt felelte nekik: „Eljött az óra, hogy megdicsőüljön az Emberfia. ");
INSERT INTO hun_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Bizony, bizony mondom néktek: ha a földbe esett gabonamag el nem hal, csak egymaga marad, ha pedig elhal, sok gyümölcsöt terem. ");
INSERT INTO hun_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Aki szereti a maga életét, elveszti azt, és aki gyűlöli a maga életét e világon, örök életre tartja meg azt. ");
INSERT INTO hun_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Aki nekem szolgál, engem kövessen, és ahol én vagyok, ott lesz az én szolgám is: és aki nekem szolgál, megbecsüli azt az Atya. ");
INSERT INTO hun_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Most háborog az én lelkem, és mit mondjak: Atyám, ments meg engem ettől az órától? De hiszen éppen ezért jutottam erre az órára. ");
INSERT INTO hun_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Atyám, dicsőítsd meg a te nevedet!“ Szózat jött azért az égből: „Meg is dicsőítettem, és újra megdicsőítem.“ ");
INSERT INTO hun_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","A sokaság azért, amely ott állt, és hallotta, azt mondta, hogy mennydörgött, mások mondták: „Angyal szólt neki.“ ");
INSERT INTO hun_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jézus ezt mondta: „Nem énértem szólt ez a hang, hanem tiértetek. ");
INSERT INTO hun_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Most van e világ kárhoztatása, most vettetik ki e világ fejedelme: ");
INSERT INTO hun_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Én pedig, ha felemeltetem e földről, mindeneket magamhoz vonzok.“ ");
INSERT INTO hun_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ezt pedig azért mondta, hogy megjelentse, milyen halállal kell meghalnia. ");
INSERT INTO hun_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","A sokaság ezt felelte neki: „Mi azt hallottuk a törvényből, hogy a Krisztus örökké megmarad: hogyan mondhatod hát te, hogy az Emberfiának fel kell emeltetnie? Kicsoda ez az Emberfia?“ ");
INSERT INTO hun_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jézus azt mondta nekik: „Még egy kevés ideig veletek van a világosság. Járjatok, amíg világosságotok van, hogy sötétség ne lepjen meg titeket: mert aki a sötétségben jár, nem tudja, hová megy. ");
INSERT INTO hun_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Míg a világosságotok megvan, higgyetek a világosságban, hogy a világosság fiai legyetek.“ Ezeket mondta Jézus, és elmenve, elrejtőzködött előlük. ");
INSERT INTO hun_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","És noha ő ennyi jelt tett előttük, mégsem hittek őbenne, ");
INSERT INTO hun_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","hogy beteljesedjék Ézsaiás próféta beszéde, amelyet mondott: „Uram, ki hitt a mi tanításunknak, és az Úr karja kinek jelentetett meg?“ ");
INSERT INTO hun_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Azért nem hihettek, mert Ézsaiás ezt is mondta: ");
INSERT INTO hun_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","„Megvakította a szemeiket, és megkeményítette a szívüket, hogy szemeikkel ne lássanak, és szívükkel ne értsenek, meg ne térjenek, és meg ne gyógyítsam őket.“ ");
INSERT INTO hun_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ezeket mondta Ézsaiás, amikor látta az ő dicsőségét, és őróla beszélt. ");
INSERT INTO hun_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Mindazáltal a főemberek közül is sokan hittek őbenne, de a farizeusok miatt nem vallották be, hogy ki ne rekesszék őket a gyülekezetből, ");
INSERT INTO hun_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","mert inkább szerették az emberek dicséretét, mintsem az Istennek dicséretét. ");
INSERT INTO hun_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jézus pedig kiáltva ezt mondta: „Aki hisz énbennem, nem énbennem hisz, hanem abban, aki elküldött engem; ");
INSERT INTO hun_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","és aki engem lát, azt látja, aki küldött engem. ");
INSERT INTO hun_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Én világosságul jöttem e világba, hogy senki ne maradjon a sötétségben, aki énbennem hisz. ");
INSERT INTO hun_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ha valaki hallja az én beszédeimet, és nem hisz, én nem kárhoztatom azt; mert nem azért jöttem, hogy kárhoztassam a világot, hanem hogy megtartsam a világot. ");
INSERT INTO hun_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Aki megvet engem, és nem fogadja el az én beszédeimet, annak van, aki őt elítélje: a beszéd, amelyet szólottam, az ítéli el őt az utolsó napon. ");
INSERT INTO hun_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Mert én nem magamtól szóltam, hanem az Atya, aki küldött engem, ő parancsolta nekem, hogy mit mondjak, és mit beszéljek. ");
INSERT INTO hun_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","És tudom, hogy az ő parancsolata örök élet. Amiket azért én beszélek, úgy beszélem, amint az Atya mondta nekem.“ ");
INSERT INTO hun_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","A húsvét ünnepe előtt tudta Jézus, hogy eljött az ő órája, hogy átmenjen e világból az Atyához, pedig szerette az övéit e világon, mindvégig szerette őket. ");
INSERT INTO hun_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","És vacsora közben, amikor az ördög belesugallta már Iskáriótes Júdásnak, Simon fiának szívébe, hogy árulja el őt, ");
INSERT INTO hun_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","tudta Jézus, hogy az Atya mindent hatalmába adott neki, és hogy ő az Istentől jött, és az Istenhez megy, ");
INSERT INTO hun_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","felkelt a vacsorától, levette a felsőruháját, és egy kendőt véve, körülkötötte magát. ");
INSERT INTO hun_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Azután vizet töltött a medencébe, és mosni kezdte a tanítványok lábait és megtörölni a kendővel, amellyel körül van kötve. ");
INSERT INTO hun_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Mikor pedig Simon Péterhez ment oda, az azt mondta neki: „Uram, te mosod meg az én lábaimat?“ ");
INSERT INTO hun_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jézus válaszolt neki, és ezt mondta: „Amit én cselekszem, te azt most nem érted, de később majd megérted.“ ");
INSERT INTO hun_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Péter ezt mondta neki: „Az én lábaimat nem mosod meg soha!“ Jézus így felelt: „Ha meg nem moslak téged, semmi közöd sincs énhozzám.“ ");
INSERT INTO hun_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simon Péter ezt mondta: „Uram, ne csak lábaimat, hanem a kezeimet és a fejemet is!“ ");
INSERT INTO hun_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jézus ezt mondta neki: „Aki megfürdött, nincs másra szüksége, mint a lábait megmosni, különben egészen tiszta, ti is tiszták vagytok, de nem mindnyájan.“ ");
INSERT INTO hun_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Tudta ugyanis, hogy ki árulja el őt, azért mondta: „Nem vagytok mindnyájan tiszták!“ ");
INSERT INTO hun_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Mikor azért megmosta lábukat, és a felsőruháját felvette, újra leülve, mondta nekik: „Értitek-e, hogy mit cselekedtem veletek? ");
INSERT INTO hun_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ti engem így hívtok: Mester és Uram. És jól mondjátok, mert az vagyok. ");
INSERT INTO hun_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Azért, ha én az Úr és a Mester megmostam a ti lábaitokat, néktek is meg kell mosnotok egymás lábait. ");
INSERT INTO hun_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Mert példát adtam néktek, hogy amiképpen én cselekedtem veletek, ti is akképpen cselekedjetek. ");
INSERT INTO hun_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Bizony, bizony mondom néktek: a szolga nem nagyobb az ő Uránál, sem a követ nem nagyobb annál, aki azt küldte. ");
INSERT INTO hun_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ha tudjátok ezeket, boldogok lesztek, ha így cselekszetek. ");
INSERT INTO hun_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Nem mindnyájatokról szólok, én tudom, kiket választottam ki, hanem hogy beteljesedjék az Írás: »aki velem ette a kenyeret, a sarkát emelte fel ellenem.« ");
INSERT INTO hun_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Most mondom meg nektek, mielőtt megtörténne, hogy mikor meglesz, higgyétek majd, hogy én vagyok. ");
INSERT INTO hun_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Bizony, bizony mondom néktek: aki befogadja, ha valakit elküldök, engem fogad be, aki pedig engem befogad, azt fogadja be, aki engem küldött.“ ");
INSERT INTO hun_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Mikor ezeket mondta Jézus, igen nyugtalankodott lelkében, s bizonyságot tett, és mondta: „Bizony, bizony mondom néktek, hogy egy közületek elárul engem.“ ");
INSERT INTO hun_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","A tanítványok ekkor bizonytalankodva egymásra tekintettek, hogy kiről szól. ");
INSERT INTO hun_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Egy pedig az ő tanítványai közül Jézus keblén nyugodott, akit Jézus szeretett. ");
INSERT INTO hun_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Intett neki Simon Péter, hogy tudakozza meg, ki az, akiről szól. ");
INSERT INTO hun_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Az pedig Jézus kebelére hajolva, mondta neki: „Uram, ki az?“ ");
INSERT INTO hun_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jézus így felelt: „Az, akinek én a bemártott falatot adom.“ És bemártva a falatot, adta Iskáriótes Júdásnak, Simon fiának. ");
INSERT INTO hun_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","És akkor a falat után belement a Sátán. Jézus pedig ezt mondta neki: „Amit cselekszel, hamar cselekedd.“ ");
INSERT INTO hun_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Azt pedig senki sem értette az ott ülők közül, hogy miért mondta neki. ");
INSERT INTO hun_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Némelyek ugyanis azt állították, mivel az erszény Júdásnál volt, hogy azt mondta neki Jézus: „Vedd meg, amire szükségünk van az ünnepre“, vagy azt, hogy adjon valamit a szegényeknek. ");
INSERT INTO hun_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Az pedig, mihelyt a falatot elfogadta, kiment. Ekkor éjszaka volt. ");
INSERT INTO hun_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Mikor pedig kiment, ezt mondta Jézus: „Most dicsőült meg az Emberfia, az Isten dicsőült meg őbenne; ");
INSERT INTO hun_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","ha pedig az Isten dicsőült meg őbenne, az Isten is megdicsőíti őt önmagában, és azonnal megdicsőíti őt. ");
INSERT INTO hun_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Fiaim, egy kevés ideig még veletek vagyok. Kerestek majd engem, de amiként a zsidóknak megmondtam, hogy ahová én megyek, ti nem jöhettek, most néktek is mondom. ");
INSERT INTO hun_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Új parancsolatot adok néktek, hogy egymást szeressétek, amint én szerettelek titeket, úgy szeressétek ti is egymást. ");
INSERT INTO hun_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Erről ismeri meg mindenki, hogy az én tanítványaim vagytok, ha egymást szeretni fogjátok.“ ");
INSERT INTO hun_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simon Péter megkérdezte tőle: „Uram, hová mégy?“ Jézus így felelt: „Ahová én megyek, most énutánam nem jöhetsz, de később utánam fogsz jönni.“ ");
INSERT INTO hun_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Péter ezt mondta neki: „Uram, miért nem mehetek most utánad? Az életemet adom érted!“ ");
INSERT INTO hun_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jézus így felelt: „Az életedet adod értem? Bizony, bizony mondom neked, nem szólal meg addig a kakas, amíg háromszor meg nem tagadsz engem.“ ");
INSERT INTO hun_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","„Ne nyugtalankodjék a ti szívetek: higgyetek Istenben, és higgyetek énbennem. ");
INSERT INTO hun_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Az én Atyámnak házában sok lakóhely van, ha pedig nem volna, megmondtam volna néktek. Elmegyek, hogy helyet készítsek néktek. ");
INSERT INTO hun_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","És ha majd elmegyek, és helyet készítek néktek, ismét eljövök, és magamhoz veszlek titeket, hogy ahol én vagyok, ti is ott legyetek. ");
INSERT INTO hun_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Tudjátok, hogy hová megyek, és az utat is tudjátok.“ ");
INSERT INTO hun_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Mondta neki Tamás: „Uram, nem tudjuk, hová mégy, mi módon tudhatjuk akkor az utat?“ ");
INSERT INTO hun_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Mondta neki Jézus: „Én vagyok az út, az igazság és az élet, senki sem mehet az Atyához, csakis énáltalam. ");
INSERT INTO hun_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ha megismertetek volna engem, megismertétek volna az én Atyámat is, és mostantól fogva ismeritek őt, és látjátok őt.“ ");
INSERT INTO hun_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Mondta neki Fülöp: „Uram, mutasd meg nékünk az Atyát, és az elég nékünk!“ ");
INSERT INTO hun_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jézus erre azt mondta: „Annyi idő óta veletek vagyok, és mégsem ismertél meg engem, Fülöp? Aki engem látott, látta az Atyát, mi módon mondod azért te: Mutasd meg nekünk az Atyát? ");
INSERT INTO hun_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Nem hiszed-e, hogy én az Atyában vagyok, és az Atya énbennem van? A beszédeket, amelyeket én mondok néktek, nem magamtól mondom, hanem az Atya, aki énbennem lakik, ő cselekszi ezeket a dolgokat. ");
INSERT INTO hun_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Higgyetek nekem, hogy én az Atyában vagyok, és az Atya énbennem van, ha pedig másért nem, magukért a cselekedetekért higgyetek nekem. ");
INSERT INTO hun_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","„Bizony, bizony mondom néktek: Aki hisz énbennem, az cselekszi is majd azokat a cselekedeteket, amelyeket én cselekszem, és nagyobbakat is cselekszik azoknál, mert én az én Atyámhoz megyek. ");
INSERT INTO hun_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Akármit kértek majd az én nevemben, megcselekszem azt, hogy dicsőíttessék az Atya a Fiúban. ");
INSERT INTO hun_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ha valamit kértek az én nevemben, én megcselekszem azt. ");
INSERT INTO hun_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Ha szerettek engem, az én parancsolataimat tartsátok meg. ");
INSERT INTO hun_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","És én kérem az Atyát, és más Vigasztalót ad néktek, hogy veletek maradjon mindörökké. ");
INSERT INTO hun_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Az igazságnak ama Lelkét: akit a világ be nem fogadhat, mert nem látja őt, és nem ismeri őt, de ti ismeritek őt, mert nálatok lakik, és bennetek marad. ");
INSERT INTO hun_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Nem hagylak titeket árvákul, eljövök tihozzátok. ");
INSERT INTO hun_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Még egy kevés idő, és a világ nem lát engem többé, de ti megláttok engem: mert én élek, és ti is élni fogtok. ");
INSERT INTO hun_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Azon a napon megtudjátok majd ti, hogy én az én Atyámban vagyok, és ti énbennem, és én tibennetek. ");
INSERT INTO hun_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Aki ismeri az én parancsolataimat, és megtartja azokat, az szeret engem, aki pedig engem szeret, azt szereti az én Atyám, én is szeretem azt, és kijelentem magamat annak.“ ");
INSERT INTO hun_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Mondta neki Júdás (nem az Iskáriótes): „Uram, miért van az, hogy nékünk jelented ki magadat, és nem a világnak?“ ");
INSERT INTO hun_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jézus így felelt: „Ha valaki szeret engem, megtartja az én beszédemet: és az én Atyám szereti azt, és elmegyünk hozzá, és nála lakunk. ");
INSERT INTO hun_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Aki nem szeret engem, nem tartja meg az én beszédeimet: és az a beszéd, amelyet hallotok, nem az enyém, hanem az Atyáé, aki küldött engem. ");
INSERT INTO hun_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Ezeket beszéltem nektek, amíg veletek voltam. ");
INSERT INTO hun_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","A Vigasztaló pedig a Szentlélek, akit az én nevemben küld az Atya, mindenre megtanít majd titeket, és eszetekbe juttatja mindazokat, amiket mondtam nektek. ");
INSERT INTO hun_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Békességet hagyok nektek, az én békességemet adom nektek: nem úgy adom nektek, amint a világ adja. Ne nyugtalankodjék a ti szívetek, se ne féljen! ");
INSERT INTO hun_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Hallottátok, hogy én azt mondtam nektek: Elmegyek, és eljövök hozzátok. Ha szeretnétek engem, örvendeznétek, hogy azt mondtam: Elmegyek az Atyához, mert az én Atyám nagyobb nálam. ");
INSERT INTO hun_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Most mondom ezt nektek, mielőtt megtörténik, hogy amikor majd megtörténik, higgyetek. ");
INSERT INTO hun_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Nem sokat beszélek már veletek, mert jön a világ fejedelme, de énbennem nincsen semmije. ");
INSERT INTO hun_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","De hogy megtudja a világ, hogy szeretem az Atyát, és úgy cselekszem, amint az én Atyám parancsolta nekem: keljetek fel, menjünk el innen.“ ");
INSERT INTO hun_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","„Én vagyok az igazi szőlőtő, és az én Atyám a szőlőműves. ");
INSERT INTO hun_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Minden szőlővesszőt, amely énbennem gyümölcsöt nem terem, lemetsz, mindazt pedig, amely gyümölcsöt terem, megtisztítja, hogy több gyümölcsöt teremjen. ");
INSERT INTO hun_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ti már tiszták vagytok az által a beszéd által, amelyet szóltam néktek. ");
INSERT INTO hun_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Maradjatok énbennem és én is tibennetek. Miképpen a szőlővessző nem teremhet gyümölcsöt magától, ha nem marad a szőlőtőkén, akképpen ti sem, ha nem maradtok énbennem. ");
INSERT INTO hun_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Én vagyok a szőlőtő, ti a szőlővesszők: Aki énbennem marad, én pedig őbenne, az terem sok gyümölcsöt: mert nélkülem semmit sem cselekedhettek. ");
INSERT INTO hun_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ha valaki nem marad énbennem, kivettetik, mint a szőlővessző, és megszárad, és egybegyűjtik ezeket, és a tűzre vetik, és megégnek. ");
INSERT INTO hun_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ha énbennem maradtok, és az én beszédeim bennetek maradnak, kérjetek, amit csak akartok, és megadatik néktek. ");
INSERT INTO hun_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Abban dicsőül meg az én Atyám, hogy sok gyümölcsöt teremtek, és tanítványaim lesztek. ");
INSERT INTO hun_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","„Amiképpen az Atya szeretett engem, én is úgy szerettelek titeket: maradjatok meg ebben az én szeretetemben. ");
INSERT INTO hun_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ha az én parancsolataimat megtartjátok, megmaradtok az én szeretetemben, amiképpen én megtartottam az én Atyámnak parancsolatait, és megmaradok az ő szeretetében. ");
INSERT INTO hun_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Ezeket beszéltem néktek, hogy megmaradjon bennetek az én örömöm, és a ti örömötök teljessé legyen. ");
INSERT INTO hun_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Az az én parancsolatom, hogy úgy szeressétek egymást, amiképpen én szerettelek titeket. ");
INSERT INTO hun_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Nincsen senkiben nagyobb szeretet annál, mint ha valaki életét adja az ő barátaiért. ");
INSERT INTO hun_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ti az én barátaim vagytok, ha azokat cselekszitek, amiket én parancsolok nektek. ");
INSERT INTO hun_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Nem mondtalak többé titeket szolgáknak, mert a szolga nem tudja, mit cselekszik az ő ura, titeket pedig barátaimnak mondtalak, mert mindazt, amit az én Atyámtól hallottam, tudtul adtam nektek. ");
INSERT INTO hun_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Nem ti választottatok engem, hanem én választottalak titeket, és én rendeltelek titeket, hogy ti elmenjetek, és gyümölcsöt teremjetek, és a ti gyümölcsötök megmaradjon, hogy akármit kértek az Atyától az én nevemben, megadja nektek. ");
INSERT INTO hun_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ezeket parancsolom nektek, hogy egymást szeressétek. ");
INSERT INTO hun_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","„Ha gyűlöl titeket a világ, tudjátok meg, hogy engem előbb gyűlölt, mint titeket. ");
INSERT INTO hun_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ha e világból volnátok, a világ szeretné azt, ami az övé, de mivel nem vagytok e világból, hanem én választottalak ki magamnak titeket e világból, azért gyűlöl titeket a világ. ");
INSERT INTO hun_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Emlékezzetek meg arról a beszédről, amelyet én mondtam nektek: Nem nagyobb a szolga az ő uránál. Ha engem üldöztek, titeket is üldöznek majd, ha az én beszédemet megtartották, a tiéteket is megtartják majd. ");
INSERT INTO hun_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","De mindezt az én nevemért cselekszik veletek, mivel nem ismerik azt, aki küldött engem. ");
INSERT INTO hun_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ha nem jöttem volna, és nem beszéltem volna nekik, nem volna bűnük: de most nincs mivel menteniük bűnüket. ");
INSERT INTO hun_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Aki engem gyűlöl, gyűlöli az én Atyámat is. ");
INSERT INTO hun_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ha azokat a cselekedeteket nem cselekedtem volna közöttük, amelyeket senki más nem cselekedett, nem volna bűnük, de most láttak is, gyűlöltek is, mind engem, mind az én Atyámat. ");
INSERT INTO hun_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","De azért lett így, hogy beteljesedjék a mondás, amely megíratott az ő törvényükben: »Ok nélkül gyűlöltek engem.« ");
INSERT INTO hun_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Mikor pedig eljön majd a Vigasztaló, akit én küldök néktek az Atyától, az igazságnak Lelke, aki az Atyától származik, az tesz majd énrólam bizonyságot. ");
INSERT INTO hun_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","De ti is bizonyságot tesztek, mert kezdettől fogva énvelem vagytok. ");
INSERT INTO hun_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Ezeket azért mondtam nektek, hogy meg ne botránkozzatok. ");
INSERT INTO hun_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","A gyülekezetekből kirekesztenek titeket, sőt eljön idő, hogy aki megöl titeket, mind azt hiszi, hogy Istennek tetsző dolgot cselekszik. ");
INSERT INTO hun_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","És ezeket azért cselekszik veletek, mert nem ismerték meg az Atyát, sem engem. ");
INSERT INTO hun_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ezeket pedig azért mondom nektek, hogy amikor eljön az az idő, megemlékezzetek rá: én megmondtam nektek.“ „De ezeket kezdetben nem mondtam nektek, mivel veletek voltam. ");
INSERT INTO hun_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Most pedig elmegyek ahhoz, aki elküldött engem, és senki sem kérdezi tőlem közületek: Hová mégy? ");
INSERT INTO hun_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Hanem mivel ezeket mondom nektek, szomorúság töltötte el a szíveteket. ");
INSERT INTO hun_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","De én az igazat mondom nektek: Jobb nektek, ha én elmegyek; mert ha nem megyek el, nem jön el hozzátok a Vigasztaló: ha pedig elmegyek, elküldöm őt hozzátok. ");
INSERT INTO hun_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","És amikor eljön, megfeddi a világot a bűn, az igazság és az ítélet tekintetében: ");
INSERT INTO hun_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","a bűn az, hogy nem hisznek énbennem; ");
INSERT INTO hun_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","az igazság az, hogy én az én Atyámhoz megyek, és többé nem láttok engem; ");
INSERT INTO hun_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","az ítélet pedig az, hogy e világ fejedelme megítéltetett. ");
INSERT INTO hun_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Még sok mondanivalóm van hozzátok, de most nem tudjátok elhordozni. ");
INSERT INTO hun_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","De mikor eljön ő, az igazság Lelke, elvezérel majd titeket minden igazságra. Mert nem önmagától szól, hanem azokat mondja, amiket hall, és az eljövendőket jelenti ki nektek. ");
INSERT INTO hun_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ő engem dicsőít majd, mert az enyémből vesz, és azt jelenti ki nektek. ");
INSERT INTO hun_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Mindaz, ami az Atyáé, az mind az enyém; ezért mondtam, hogy az enyémből vesz, és azt jelenti ki nektek. ");
INSERT INTO hun_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","„Egy kevés idő, és nem láttok engem, és ismét egy kevés idő, és megláttok majd engem: mert én az Atyához megyek.“ ");
INSERT INTO hun_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","A tanítványai közül ezt mondták egymásnak: „Mi az, amit nekünk mond: Egy kevés idő, és nem láttok engem, és ismét egy kevés idő, és megláttok majd engem, és ez: Mert én az Atyához megyek?“ ");
INSERT INTO hun_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ezért ezt mondták: „Mi az a kevés idő, amiről szól? Nem tudjuk, mit mond.“ ");
INSERT INTO hun_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Megértette azért Jézus, hogy őt akarják megkérdezni, és ezt mondta nekik: „Arról kérdezősködtök-e egymás között, hogy azt mondtam: Egy kevés idő, és nem láttok engem, és ismét egy kevés idő, és megláttok majd engem? ");
INSERT INTO hun_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Bizony, bizony mondom néktek, hogy ti sírni és jajgatni fogtok, a világ pedig örül; ti szomorkodtok, de szomorúságotok örömre fordul. ");
INSERT INTO hun_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Az asszony, amikor szül, szomorúságban van, mert eljött az ő órája: de mikor megszüli az ő gyermekét, nem emlékezik többé a kínra az öröm miatt, hogy ember született e világra. ");
INSERT INTO hun_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ti is azért most ugyan szomorúságban vagytok, de ismét meglátlak majd titeket, és örülni fog a ti szívetek, és senki el nem veszi tőletek a ti örömötöket. ");
INSERT INTO hun_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","És azon a napon nem kérdeztek majd engem semmiről.“ „Bizony, bizony mondom néktek, hogy amit csak kérni fogtok az Atyától az én nevemben, megadja néktek. ");
INSERT INTO hun_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Mostanáig semmit sem kértetek az Atyától az én nevemben: kérjetek és megkapjátok, hogy a ti örömötök teljes legyen. ");
INSERT INTO hun_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Ezeket példázatokban mondtam nektek, de eljön az idő, mikor nem példázatokban beszélek majd nektek, hanem nyíltan beszélek nektek az Atyáról. ");
INSERT INTO hun_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Azon a napon az én nevemben kértek majd: és nem azt mondom nektek, hogy én fogom kérni az Atyát érettetek, ");
INSERT INTO hun_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","mert maga az Atya szeret titeket, mivel ti szerettetek engem, és elhittétek, hogy én az Istentől jöttem. ");
INSERT INTO hun_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Én az Atyától jöttem, és eljöttem a világba; de most elhagyom e világot, és elmegyek az Atyához.“ ");
INSERT INTO hun_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Tanítványai ekkor ezt mondták neki: „Íme, most nyíltan beszélsz, és nem példázatot mondasz. ");
INSERT INTO hun_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Most tudjuk, hogy te mindent tudsz, és nincs szükséged arra, hogy valaki téged megkérdezzen: ezért hisszük, hogy az Istentől jöttél.“ ");
INSERT INTO hun_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jézus így felelt: „Most hiszitek? ");
INSERT INTO hun_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Íme, eljön az óra, és immár el is jött, hogy elszéledjetek, ki-ki az övéihez, és engem egyedül hagyjatok, de nem vagyok egyedül, mert az Atya velem van. ");
INSERT INTO hun_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ezeket azért mondom néktek, hogy békességetek legyen énbennem. E világon nyomorúságotok lesz, de bízzatok: én legyőztem a világot.“ ");
INSERT INTO hun_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ezeket beszélte Jézus, és felemelte szemeit az égre, és ezt mondta: „Atyám, eljött az óra, dicsőítsd meg a te Fiadat, hogy a te Fiad is dicsőítsen téged, ");
INSERT INTO hun_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","mivel hatalmat adtál neki minden test felett, hogy örök életet adjon mindazoknak, akiket neki adtál. ");
INSERT INTO hun_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Az örök élet pedig az, hogy megismerjenek téged, az egyedül igaz Istent, és akit elküldtél, a Jézus Krisztust. ");
INSERT INTO hun_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Én dicsőítettelek téged e földön: elvégeztem a munkát, amelyet reám bíztál, hogy elvégezzem. ");
INSERT INTO hun_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","És most te dicsőíts meg engem, Atyám, önmagadnál azzal a dicsőséggel, amely enyém volt tenálad, mielőtt a világ lett. ");
INSERT INTO hun_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Kijelentettem a te nevedet az embereknek, akiket e világból nekem adtál. Tieid voltak, és nekem adtad őket, és a te beszédedet megtartották. ");
INSERT INTO hun_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Most tudták meg, hogy mindaz, amit nekem adtál, tőled van; ");
INSERT INTO hun_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","mert azokat a beszédeket, amelyeket nekem adtál, őnekik adtam, ők befogadták, és igazán megismerték, hogy én tőled jöttem, és elhitték, hogy te küldtél engem. ");
INSERT INTO hun_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Én őértük könyörgök: nem a világért könyörgök, hanem azokért, akiket nekem adtál, mert a tieid. ");
INSERT INTO hun_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Az enyémek mind a tieid, és a tieid az enyémek: és megdicsőíttetem őbennük. ");
INSERT INTO hun_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Én nem vagyok többé e világban, de ők a világban vannak, én pedig tehozzád megyek. Szent Atyám, tartsd meg őket a te nevedben, akiket nekem adtál, hogy egyek legyenek, mint mi! ");
INSERT INTO hun_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Amikor velük voltam a világon, én megtartottam őket a te nevedben, akiket nekem adtál, megőriztem őket, és senki el nem veszett közülük, csak a veszedelemnek fia, hogy az Írás beteljesüljön. ");
INSERT INTO hun_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Most pedig tehozzád megyek, és ezeket beszélem a világban, hogy az én örömöm teljes legyen bennük. ");
INSERT INTO hun_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","A te igédet adtam nekik, és a világ gyűlölte őket, mivelhogy nem e világból valók, amint én sem vagyok e világból való. ");
INSERT INTO hun_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Nem azt kérem, hogy vedd ki őket e világból, hanem hogy őrizd meg őket a gonosztól. ");
INSERT INTO hun_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Nem e világból valók, amint én sem e világból vagyok. ");
INSERT INTO hun_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Szenteld meg őket a te igazságoddal: A te igéd igazság. ");
INSERT INTO hun_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Amiképpen te küldtél engem e világba, úgy küldtem én is őket e világba: ");
INSERT INTO hun_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","én őérettük odaszentelem magamat, hogy ők is megszenteltekké legyenek az igazságban. ");
INSERT INTO hun_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","De nemcsak őérettük könyörgök, hanem azokért is, akik az ő szavukra hisznek majd énbennem, ");
INSERT INTO hun_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","hogy mindnyájan egyek legyenek, amint te énbennem, Atyám, és én tebenned, hogy ők is egyek legyenek mibennünk: hogy elhiggye a világ, hogy te küldtél engem. ");
INSERT INTO hun_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Én azt a dicsőséget, amelyet nekem adtál, őnekik adtam, hogy egyek legyenek, amiképpen mi egyek vagyunk: ");
INSERT INTO hun_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","én őbennük és te énbennem: hogy tökéletesen eggyé legyenek, és hogy megismerje a világ, hogy te küldtél engem, és szeretted őket, amiként engem szerettél. ");
INSERT INTO hun_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Atyám, akiket nekem adtál, akarom, hogy ahol én vagyok, azok is velem legyenek, hogy megláthassák az én dicsőségemet, amelyet nekem adtál: mert szerettél engem e világ kezdete előtt. ");
INSERT INTO hun_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Igazságos Atyám! A világ nem ismert téged, de én ismertelek téged, és ezek megismerik, hogy te küldtél engem, ");
INSERT INTO hun_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","És megismertettem ővelük a te nevedet, és megismertetem, hogy az a szeretet legyen őbennük, amellyel engem szerettél, és én is őbennük legyek.“ ");
INSERT INTO hun_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Mikor ezeket mondta Jézus, kiment az ő tanítványaival együtt túl a Kedron-patakon, ahol egy kert volt, ahova bementek, ő és az ő tanítványai. ");
INSERT INTO hun_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Azt a helyet Júdás is ismerte, aki elárulta őt, mivel gyakran ott gyűltek össze Jézus és a tanítványai. ");
INSERT INTO hun_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Júdás tehát maga mellé vette a katonai csapatot, a papi fejedelmektől és a farizeusoktól a szolgákat, odament fáklyákkal, lámpásokkal és fegyverekkel. ");
INSERT INTO hun_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jézus pedig tudva mindazt, ami reá következik, előrement, és mondta nekik: „Kit kerestek?“ ");
INSERT INTO hun_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ők így feleltek neki: „A názáreti Jézust.“ Jézus ezt mondta nekik: „Én vagyok.“ Ott állt pedig ővelük Júdás is, aki elárulta őt. ");
INSERT INTO hun_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Amikor pedig azt mondta nekik: „Én vagyok“ – hátratántorodtak, és földre estek. ");
INSERT INTO hun_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ismét megkérdezte őket: „Kit kerestek?“ És azok ezt mondták: „A názáreti Jézust.“ ");
INSERT INTO hun_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jézus így felelt: „Mondtam néktek, hogy én vagyok az. Azért, ha engem kerestek, ezeket bocsássátok el.“ ");
INSERT INTO hun_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Hogy beteljesedjen a beszéd, amelyet mondott: „Azok közül, akiket nekem adtál, senkit sem vesztettem el.“ ");
INSERT INTO hun_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simon Péter pedig, akinek szablyája volt, kirántotta azt, és megütötte a főpap szolgáját, és levágta annak jobb fülét. A szolga neve pedig Málkus volt. ");
INSERT INTO hun_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jézus erre ezt mondta Péternek: „Tedd hüvelyébe a szablyádat! Vagy nem kell-e kiinnom a poharat, amelyet az Atya adott nekem?“ ");
INSERT INTO hun_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","A csapat pedig, az ezredes és a zsidók szolgái megfogták Jézust, és megkötözték őt, ");
INSERT INTO hun_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","és először Annáshoz vitték, mert ő apósa volt Kajafásnak, aki abban az esztendőben főpap volt. ");
INSERT INTO hun_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kajafás volt az, aki azt tanácsolta a zsidóknak, hogy jobb, hogy egy ember vesszen el a népért. ");
INSERT INTO hun_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simon Péter és egy másik tanítvány követte Jézust. Ez a tanítvány ismerőse volt a főpapnak, és bement Jézussal együtt a főpap udvarába; ");
INSERT INTO hun_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Péter pedig kívül állt az ajtónál. Kiment tehát az a másik tanítvány, aki a főpapnak ismerőse volt, és szólt az ajtóőrzőnek, és bevitte Pétert. ");
INSERT INTO hun_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Az ajtóőrző leány így szólt Péterhez: „Nemde te is ennek az embernek tanítványai közül való vagy?“ De ő így válaszolt: „Nem vagyok.“ ");
INSERT INTO hun_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","A szolgák és a poroszlók ott álltak, szították a tüzet, mivel hűvös volt, és melegedtek. Ott állt Péter is ővelük együtt, és melegedett. ");
INSERT INTO hun_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","A főpap pedig tanítványai és tanítása felől kérdezte Jézust. ");
INSERT INTO hun_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jézus így felelt: „Én nyilvánosan szóltam a világhoz: mindenkor a zsinagógában és a templomban tanítottam, ahol a zsidók mindenünnen összegyülekeznek, és titkon semmit sem szóltam. ");
INSERT INTO hun_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Miért kérdezel engem? Kérdezd azokat, akik hallották, mit beszéltem nekik: íme, ők tudják, amiket nekik mondtam.“ ");
INSERT INTO hun_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Amikor pedig ezeket mondta, egy a poroszlók közül, aki ott állt, arcul ütötte Jézust, és ezt mondta: „Így felelsz a főpapnak?“ ");
INSERT INTO hun_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jézus így felelt neki: „Ha gonoszul szóltam, tégy bizonyságot a gonoszságról, ha pedig jól, miért versz engem?“ ");
INSERT INTO hun_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Annás ezután elküldte őt megkötözve Kajafáshoz, a főpaphoz. ");
INSERT INTO hun_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Simon Péter pedig ott állt, és melegedett. Ekkor ezt mondták neki: „Nemde te is ennek a tanítványai közül való vagy?“ Ő tagadta, és azt mondta: „Nem vagyok.“ ");
INSERT INTO hun_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","A főpap szolgái közül az egyik, annak rokona, akinek a fülét Péter levágta, ezt mondta: „Nem láttalak-e én téged vele együtt a kertben?“ ");
INSERT INTO hun_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Péter ismét tagadta, és akkor azonnal megszólalt a kakas. ");
INSERT INTO hun_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Jézust pedig Kajafástól a törvényházba vitték. Kora reggel volt. Ők nem mentek be a törvényházba, hogy ne legyenek tisztátalanná, és megehessék a húsvéti bárányt. ");
INSERT INTO hun_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Pilátus ekkor kiment hozzájuk, és mondta: „Milyen vádat hoztok fel ez ellen az ember ellen?“ ");
INSERT INTO hun_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ezt felelték neki: „Ha ez nem volna gonosztevő, nem adtuk volna őt a te kezedbe.“ ");
INSERT INTO hun_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilátus erre azt mondta nekik: „Vigyétek el őt ti, és ítéljétek el a ti törvényeitek szerint.“ A zsidók így feleltek: „Nékünk senkit sem szabad megölnünk.“ ");
INSERT INTO hun_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Hogy beteljesedjék Jézus szava, amelyet mondott, amikor jelezte, hogy milyen halállal kell majd meghalnia. ");
INSERT INTO hun_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ismét bement Pilátus a törvényházba, szólította Jézust, és mondta neki: „Te vagy a zsidók királya?“ ");
INSERT INTO hun_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jézus így felelt: „Magadtól mondod-e ezt, vagy mások beszélték neked rólam?“ ");
INSERT INTO hun_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilátus így felelt: „Talán zsidó vagyok én? A te néped és a papi fejedelmek adtak téged az én kezembe: mit cselekedtél?“ ");
INSERT INTO hun_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jézus ezt felelte: „Az én országom nem e világból való. Ha e világból való volna az én országom, az én szolgáim harcolnának, hogy át ne adjanak a zsidóknak. De az én országom nem innen való.“ ");
INSERT INTO hun_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilátus ezt mondta neki: „Király vagy-e hát te csakugyan?“ Jézus így felelt: „Te mondod, hogy én király vagyok. Én azért születtem, és azért jöttem e világra, hogy bizonyságot tegyek az igazságról. Mindenki, aki az igazságból való, hallgat az én szavamra.“ ");
INSERT INTO hun_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilátus ezt mondta neki: „Mi az igazság?“ És amint ezt mondta, újra kiment a zsidókhoz, és mondta nekik: „Én nem találok benne semmi bűnt. ");
INSERT INTO hun_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Szokás pedig nálatok, hogy szabadon bocsássak nektek valakit a húsvét ünnepén: akarjátok-e azért, hogy elbocsássam nektek a zsidók királyát?“ ");
INSERT INTO hun_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ekkor ismét mindnyájan kiáltozni kezdtek: „Nem ezt, hanem Barabbást.“ Ez a Barabbás pedig tolvaj volt. ");
INSERT INTO hun_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Akkor Pilátus elvitette Jézust, és megostoroztatta. ");
INSERT INTO hun_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","A vitézek tövisből koronát fontak, a fejére tették, bíbor köntöst adtak reá, ");
INSERT INTO hun_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","és ezt mondták: „Üdvözlégy, zsidók királya!“ És arcul csapdosták őt. ");
INSERT INTO hun_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Majd ismét kiment Pilátus, és mondta nekik: „Íme, kihozom őt nektek, hogy értsétek meg, hogy nem találok benne semmi bűnt.“ ");
INSERT INTO hun_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Kiment azért Jézus a töviskoronát és a bíborköntöst viselve. És mondta nekik Pilátus: „Íme, az ember!“ ");
INSERT INTO hun_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Mikor meglátták őt a papi fejedelmek és a szolgák, így kiáltoztak: „Feszítsd meg, feszítsd meg!!“ Pilátus ezt mondta nekik: „Vigyétek el őt ti, és feszítsétek meg, mert én nem találok bűnt őbenne.“ ");
INSERT INTO hun_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","A zsidók így feleltek neki: „Nekünk törvényünk van, és ami törvényünk szerint meg kell halnia, mivel Isten Fiává tette magát.“ ");
INSERT INTO hun_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Mikor pedig ezt a beszédet hallotta Pilátus, még inkább megrémült, ");
INSERT INTO hun_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","ismét bement a törvényházba, és szólt Jézusnak: „Honnan való vagy te?“ De Jézus nem felelt neki. ");
INSERT INTO hun_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilátus ekkor ezt mondta neki: „Nekem nem felelsz? Nem tudod, hogy hatalmam van arra, hogy megfeszíttesselek, és hatalmam van arra, hogy szabadon bocsássalak?“ ");
INSERT INTO hun_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jézus így felelt: „Semmi hatalmad sem volna rajtam, ha felülről nem adatott volna neked: nagyobb bűne van azért annak, aki a te kezedbe adott engem.“ ");
INSERT INTO hun_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ettől fogva igyekezett Pilátus őt szabadon bocsátani, de a zsidók így kiáltoztak: „Ha ezt szabadon bocsátod, nem vagy a császár barátja: aki magát királlyá teszi, az ellene szegül a császárnak!“ ");
INSERT INTO hun_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Amikor pedig Pilátus meghallotta ezeket a szavakat, kihozta Jézust, és leült a bírói székbe azon a helyen, amelyet Márványkövezetnek hívtak, héberül pedig Gabbatának. ");
INSERT INTO hun_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Akkor a húsvét péntekje volt, és mintegy hat óra. És mondta a zsidóknak: „Íme, a ti királyotok!“ ");
INSERT INTO hun_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Azok pedig kiáltoztak: „Vidd el, vidd el, feszítsd meg őt!“ Mondta nekik Pilátus: „A ti királyotokat feszítsem meg?“ A papi fejedelmek így feleltek: „Nem királyunk van, hanem császárunk!“ ");
INSERT INTO hun_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Akkor átadta őt nekik, hogy megfeszítsék. Átvették tehát Jézust, és elvitték. ");
INSERT INTO hun_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","És felemelve a keresztfáját, elment az úgynevezett Koponya-hegyre, amelyet héberül Golgotának hívnak, ");
INSERT INTO hun_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","ahol megfeszítették őt, és ővele másik kettőt, egyfelől és másfelől, középen pedig Jézust. ");
INSERT INTO hun_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilátus pedig feliratot is készíttetett, és feltétette a keresztfára. Az írás pedig ez volt: a názáreti Jézus, a zsidók királya. ");
INSERT INTO hun_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Sokan olvasták ezt a feliratot a zsidók közül, mivel közel volt a városhoz az a hely, ahol Jézust megfeszítették, héberül, görögül és latinul volt írva. ");
INSERT INTO hun_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","A zsidók papi fejedelmei akkor azt mondták Pilátusnak: „Ne azt írd: A zsidók királya! – hanem ahogy ő mondta: A zsidók királya vagyok.“ ");
INSERT INTO hun_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilátus így felelt: „Amit megírtam, megírtam.“ ");
INSERT INTO hun_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","A vitézek pedig, amikor megfeszítették Jézust, elvették felsőruháit, és négy részre osztották, egy-egy részt mindegyik vitéznek. A köntös pedig varratlan volt, felülről végig egybeszőve. ");
INSERT INTO hun_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ekkor azt mondták egymásnak: „Ezt ne hasítsuk el, hanem vessünk sorsot rá, kié legyen.“ Hogy beteljesedjen az Írás, amely ezt mondja: „Megosztoztak ruháimon, és a köntösömre sorsot vetettek.“ A vitézek tehát ezeket tették. ");
INSERT INTO hun_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Jézus keresztje alatt pedig ott állt anyja, és anyjának nőtestvére, Mária, a Klópás felesége és a magdalai Mária. ");
INSERT INTO hun_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Amikor Jézus meglátta, hogy ott áll az ő anyja és az a tanítvány, akit szeretett, ezt mondta az anyjának: „Asszony, íme, a te fiad!“ ");
INSERT INTO hun_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Azután ezt mondta a tanítványnak: „Íme, a te anyád!“ És ettől az órától magához fogadta őt az a tanítvány. ");
INSERT INTO hun_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Jézus ezek után tudva, hogy immár minden elvégeztetett, hogy beteljesedjék az Írás, ezt mondta: „Szomjazom.“ ");
INSERT INTO hun_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Volt pedig ott egy ecettel, teli edény. Egy szivacsot megtöltve ecettel izsópra téve, odavitték a szájához. ");
INSERT INTO hun_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Mikor pedig elvette Jézus az ecetet, ezt mondta: „Elvégeztetett!“ És lehajtva fejét, kibocsátotta lelkét. ");
INSERT INTO hun_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","A zsidók pedig, hogy a testek szombaton át ne maradjanak a keresztfán, mivel péntek volt (mert annak a szombatnak napja nagy nap volt), kérték Pilátust, hogy törjék el azoknak lábszárait, és vegyék le őket. ");
INSERT INTO hun_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Eljöttek ekkor a vitézek, és eltörték az elsőnek lábszárait és a másikét is, akit vele együtt feszítettek meg. ");
INSERT INTO hun_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Amikor pedig Jézushoz értek, és látták, hogy ő már halott, nem törték el a lábszárait, ");
INSERT INTO hun_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","hanem egy a vitézek közül dárdával döfte át az oldalát, és azonnal vér és víz jött ki abból. ");
INSERT INTO hun_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","És aki látta, bizonyságot tett, és igaz az ő tanúbizonysága, és ő tudja, hogy igazat mond, hogy ti is higgyetek. ");
INSERT INTO hun_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Mert azért történtek ezek, hogy beteljesedjen az Írás: „Csontja ne töressék meg.“ ");
INSERT INTO hun_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Másutt ismét így szól az Írás: „Néznek majd arra, akit átszegeztek.“ ");
INSERT INTO hun_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ezek után az arimatiai József (aki Jézus tanítványa volt, de csak titokban, a zsidóktól való félelem miatt), megkérte Pilátust hogy levehesse Jézus testét. Pilátus megengedte. Elment tehát, és levette Jézus testét. ");
INSERT INTO hun_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Eljött Nikodémus is (aki éjszaka ment Jézushoz először), hozva mirhából és aloéból való kenetet, mintegy százfontnyit. ");
INSERT INTO hun_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Fogták tehát Jézus testét, lepedőkbe göngyölték illatos szerekkel együtt, amint a zsidóknál szokás temetni. ");
INSERT INTO hun_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Azon a helyen pedig, ahol megfeszítették, volt egy kert, és a kertben egy új sír, amelybe még senkit sem helyeztek. ");
INSERT INTO hun_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","A zsidók péntekje miatt, mivel az a sír közel volt, abban helyezték el Jézust. ");
INSERT INTO hun_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","A hétnek első napján pedig korán reggel, amikor még sötét volt, odament a magdalai Mária a sírhoz, és látta, hogy a kő el van véve a sírról. ");
INSERT INTO hun_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Elfutott tehát, és elment Simon Péterhez és a másik tanítványhoz, akit Jézus szeretett, és mondta nekik: „Elvitték az Urat a sírból, és nem tudjuk, hová tették őt!“ ");
INSERT INTO hun_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Elment tehát Péter és a másik tanítvány, és elmentek a sírhoz. ");
INSERT INTO hun_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Együtt futottak mindketten: de a másik tanítvány hamar megelőzte Pétert, és előbb jutott a sírhoz, ");
INSERT INTO hun_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","és lehajolva látta, hogy ott vannak a lepedők, de mégsem ment be. ");
INSERT INTO hun_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Nyomban utána megjött Simon Péter is, bement a sírba, és látta, hogy a lepedők ott vannak. ");
INSERT INTO hun_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","És a keszkenő, amely a fején volt, nem együtt van a lepedőkkel, hanem külön összegöngyölítve egy helyen. ");
INSERT INTO hun_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Akkor aztán bement a másik tanítvány is, aki először jutott a sírhoz, és látott és hitt. ");
INSERT INTO hun_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Mert nem értették még az Írást, hogy fel kell támadnia a halálból. ");
INSERT INTO hun_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","A tanítványok ezután visszamentek az övéikhez. ");
INSERT INTO hun_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Mária pedig kinn állt a sírnál és sírt. Amíg azonban siránkozott, behajolt a sírba, ");
INSERT INTO hun_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","és látott két angyalt fehér ruhában ülni, egyiket fejtől, másikat lábtól, ahol Jézus teste feküdt. ");
INSERT INTO hun_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Azok ezt mondták neki: „Asszony, miért sírsz?“ Azt mondta nekik: „Mert elvitték az én Uramat, és nem tudom, hova tették őt.“ ");
INSERT INTO hun_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","És mikor ezeket mondta, hátrafordult, és látta, hogy Jézus ott áll, de nem tudta, hogy Jézus az. ");
INSERT INTO hun_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Mondta neki Jézus: „Asszony, miért sírsz? Kit keresel?“ Ő pedig azt gondolva, hogy a kertész az, ezért azt mondta neki: „Uram, ha te vitted el őt, mondd meg nekem, hová tetted, és én elviszem.“ ");
INSERT INTO hun_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jézus ezt mondta neki: „Mária!“ Az megfordult, és ezt mondta neki: „Rabbuni!“ – ami azt jelenti: Mester! ");
INSERT INTO hun_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jézus azt mondta neki: „Ne érints engem, mert nem mentem még fel az én Atyámhoz, hanem menj az én atyámfiaihoz, és mondd meg nekik: Felmegyek az én Atyámhoz és a ti Atyátokhoz, és az én Istenemhez és a ti Istenetekhez.“ ");
INSERT INTO hun_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Elment a magdalai Mária, hírül adva a tanítványoknak, hogy látta az Urat, és hogy ezeket mondta neki. ");
INSERT INTO hun_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Mikor azért este lett, azon a napon, a hétnek első napján és mikor az ajtók a zsidóktól való félelem miatt zárva voltak ott, ahol egybegyűltek a tanítványok, eljött Jézus, megállt középen, és ezt mondta nekik: „Békesség néktek!“ ");
INSERT INTO hun_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","És ezt mondva megmutatta nekik a kezeit és az oldalát. Örvendeztek azért a tanítványok, hogy látják az Urat. ");
INSERT INTO hun_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ismét mondta nekik Jézus: „Békesség néktek! Amiképpen engem küldött az Atya, én is küldelek titeket.“ ");
INSERT INTO hun_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","És mikor ezt mondta, rájuk lehelt, és mondta nekik: „Vegyetek Szent Lelket. ");
INSERT INTO hun_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Akiknek bűneit megbocsátjátok, megbocsáttatnak azoknak, akikéit megtartjátok, megtartatnak.“ ");
INSERT INTO hun_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tamás pedig, egy a tizenkettő közül, akit Ikernek hívtak, nem volt ővelük, amikor eljött Jézus. ");
INSERT INTO hun_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","A többi tanítvány ezt mondta neki: „Láttuk az Urat.“ Ő pedig azt mondta nekik: „Ha nem látom a kezein a szegek helyeit, és be nem teszem ujjaimat a szegek helyébe, és kezemet be nem teszem az oldalára, semmiképpen el nem hiszem.“ ");
INSERT INTO hun_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","És nyolc nap múlva ismét benn voltak a tanítványai, Tamás is ő velük volt. Noha az ajtó zárva volt, bement Jézus, és megállt középen, és mondta: „Békesség néktek!“ ");
INSERT INTO hun_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Azután mondta Tamásnak: „Hozd ide az ujjadat, és nézd meg a kezeimet, és hozd ide a kezedet, és tedd az én oldalamra, és ne légy hitetlen, hanem hívő.“ ");
INSERT INTO hun_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tamás pedig így felelt: „Én Uram és én Istenem!“ ");
INSERT INTO hun_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jézus ezt mondta neki: „Mivel láttál engem, Tamás, hittél: boldogok, akik nem látnak és hisznek.“ ");
INSERT INTO hun_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Sok más jelt is tett ugyan Jézus az ő tanítványai előtt, amelyek nincsenek megírva ebben a könyvben. ");
INSERT INTO hun_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ezek pedig azért vannak megírva, hogy higgyétek, hogy Jézus a Krisztus, az Istennek Fia, és hogy ezt híve, életetek legyen az ő nevében. ");
INSERT INTO hun_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ezek után ismét megjelentette magát Jézus a tanítványoknak a Tibériás-tengernél. Így jelent meg: ");
INSERT INTO hun_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Együtt voltak Simon Péter és Tamás, akit Ikernek hívtak, Nátánáel, a galileai Kánából és Zebedeus fiai és másik kettő is az ő tanítványai közül. ");
INSERT INTO hun_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Mondta nekik Simon Péter: „Elmegyek halászni.“ Ők erre ezt mondták neki: „Elmegyünk mi is veled.“ Elmentek, és azonnal hajóra szálltak, de azon az éjszakán nem fogtak semmit. ");
INSERT INTO hun_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Mikor pedig immár reggel lett, megállt Jézus a parton, a tanítványok azonban nem ismerték meg, hogy Jézus van ott. ");
INSERT INTO hun_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Jézus pedig ezt mondta: „Fiaim! Van-e valami ennivalótok?“ Így feleltek neki: „Nincsen!“ ");
INSERT INTO hun_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ő pedig ezt mondta nekik: „Vessétek ki a hálót a hajónak jobb oldala felől, és találtok.“ Oda vetették ki tehát, de kivonni már nem bírták a rengeteg hal miatt. ");
INSERT INTO hun_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Az a tanítvány pedig, akit Jézus szeretett, így szólt Péternek: „Az Úr van ott!“ Simon Péter pedig, amikor meghallotta, hogy ott van az Úr, magára vette az ingét (mert mezítelen volt), és bevetette magát a tengerbe. ");
INSERT INTO hun_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","A többi tanítvány pedig a hajón ment (mert nem messze voltak a parttól, hanem mintegy kétszáz könyöknyire), és kivonták a hálót a halakkal. ");
INSERT INTO hun_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Amint azért a partra kiszálltak, látják, hogy parázs van ott, rajta hal és kenyér. ");
INSERT INTO hun_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jézus ezt mondta nekik: „Hozzatok a halakból, amelyeket most fogtatok.“ ");
INSERT INTO hun_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simon Péter beszállt, és kivonta a hálót a partra, amely tele volt nagy halakkal, százötvenhárommal, és noha ennyi volt, nem szakadozott a háló. ");
INSERT INTO hun_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jézus erre azt mondta nekik: „Gyertek, ebédeljetek.“ A tanítványok közül pedig senki sem merte tőle megkérdezni: „Ki vagy te?“ Mivelhogy tudták, hogy az Úr ő. ");
INSERT INTO hun_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Odament tehát Jézus, vette a kenyeret, és adta nekik; és hasonlóképpen a halat is. ");
INSERT INTO hun_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ekkor már harmadszor jelent meg Jézus a tanítványainak, miután feltámadt a halálból. ");
INSERT INTO hun_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Mikor aztán megebédeltek, Jézus ezt mondta Simon Péternek: „Simon, Jóna fia, jobban szeretsz-e engem ezeknél?“ Mondta neki: „Igen, Uram, te tudod, hogy szeretlek téged!“ Jézus azt mondta neki: „Legeltesd az én bárányaimat!“ ");
INSERT INTO hun_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Másodszor is mondta neki: „Simon, Jóna fia, szeretsz-e engem?“ Mondta neki: „Igen, Uram, te tudod, hogy én szeretlek téged.“ Jézus ezt mondta neki: „Őrizd az én juhaimat!“ ");
INSERT INTO hun_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Harmadszor is mondta neki: „Simon, Jóna fia, szeretsz-e engem?“ Megszomorodott Péter, hogy harmadszor is mondta neki: „Szeretsz-e engem?“ És mondta neki: „Uram, te mindent tudsz, te tudod, hogy én szeretlek téged.“ Jézus azt mondta neki: „Legeltesd az én juhaimat! ");
INSERT INTO hun_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Bizony, bizony mondom néked, amikor ifjabb voltál, felövezted magadat, és oda mentél, ahova akartál, mikor pedig megöregszel, kinyújtod a kezedet, más övez fel téged, és oda visz, ahova nem akarod.“ ");
INSERT INTO hun_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ezt pedig azért mondta, hogy jelezze, milyen halállal dicsőíti majd meg az Istent. És ezt mondva, így szólt hozzá: „Kövess engem!“ ");
INSERT INTO hun_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Péter pedig megfordulva, látja, hogy követi az a tanítvány, akit szeretett Jézus, aki a vacsora közben is az ő keblén nyugodott, és mondta: „Uram! Ki az, aki elárul téged?“ ");
INSERT INTO hun_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Őt látva Péter, mondta Jézusnak: „Uram, ezzel pedig mi lesz?“ ");
INSERT INTO hun_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jézus ezt mondta neki: „Ha akarom, hogy ő megmaradjon, amíg eljövök, mi közöd hozzá? Te kövess engem!“ ");
INSERT INTO hun_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Elterjedt tehát e beszéd az atyafiak között, hogy az a tanítvány nem hal meg. Pedig Jézus nem azt mondta neki, hogy nem hal meg, hanem ezt: „Ha akarom, hogy megmaradjon, amíg eljövök, mi közöd hozzá?“ ");
INSERT INTO hun_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ez az a tanítvány, aki bizonyságot tesz ezekről, és aki megírta ezeket, és tudjuk, hogy az ő bizonyságtétele igaz. ");
INSERT INTO hun_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","De van sok egyéb is, amiket Jézus cselekedett, amelyeket, ha egyenként megírnák, úgy vélem, hogy maga a világ sem fogadhatná be a könyveket, amelyeket megírtak. Ámen.");
INSERT INTO hun_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Első könyvemet, Teofilus, azokról írtam, amiket Jézus elkezdett cselekedni és tanítani, ");
INSERT INTO hun_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","egészen addig a napig, melyen fölvitetett, miután parancsolatokat adott a Szentlélek által az apostoloknak, akiket magának választott. ");
INSERT INTO hun_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Nekik az ő szenvedése után sok jel által megmutatta, hogy él, negyven napon át megjelent nekik, és szólt az Isten országára tartozó dolgokról. ");
INSERT INTO hun_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Velük összejött és meghagyta nékik, hogy ne menjenek el Jeruzsálemből, hanem várják be az Atyának ígéretét, melyet úgymond, „hallottatok tőlem: ");
INSERT INTO hun_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","hogy János ugyan vízzel keresztelt, ti azonban Szentlélekkel fogtok megkereszteltetni nem sok nap múlva.“ ");
INSERT INTO hun_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Mikor azért ők egybegyűltek, megkérdezték tőle: „Uram, nem most állítod helyre Izraelnek országát?“ ");
INSERT INTO hun_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ezt felelte nekik: „Nem a ti dolgotok tudni az időket vagy alkalmakat, amelyeket az Atya a maga hatalmába helyezett. ");
INSERT INTO hun_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Hanem, miután a Szentlélek eljön hozzátok, erőt kaptok: és tanúim lesztek nekem úgy Jeruzsálemben, mint egész Júdeában, és Samáriában és a földnek mind a végső határáig.“ ");
INSERT INTO hun_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","És miután ezeket mondta, szemük láttára felemeltetett, és felhő takarta el őt szemeik elől. ");
INSERT INTO hun_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Amint szemeiket az égre függesztették, amikor ő elment, íme két férfiú állott meg mellettük fehér ruhában, ");
INSERT INTO hun_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","És így szóltak: „Galileabeli férfiak, miért álltok itt felnézve a mennybe? Ez a Jézus, aki felvitetett tőletek a mennybe, úgy jön el, amikképpen láttátok őt felmenni a mennybe.“ ");
INSERT INTO hun_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ezután visszatértek Jeruzsálembe a hegyről, melyet Olajfák hegyének hívnak, mely Jeruzsálem mellett van, egy szombatnapi járóföldre. ");
INSERT INTO hun_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Amikor megérkeztek, felmentek a felsőházba, ahol megszálltak: Péter és Jakab, János és András, Fülöp és Tamás, Bertalan és Máté, Jakab, az Alfeus fia, és Simon, a zelóta és Júdás, a Jakab fia. ");
INSERT INTO hun_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Mindnyájan egy szívvel-lélekkel, az imádkozással és a könyörgéssel voltak elfoglalva, az asszonyokkal és Máriával, Jézusnak anyjával, és az ő testvéreivel együtt. ");
INSERT INTO hun_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Azokban a napokban felkelve Péter a tanítványok között – volt ott együtt mintegy százhúsz főnyi sokaság – , ezt mondta: ");
INSERT INTO hun_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","„Atyámfiai, férfiak, szükséges volt, hogy beteljesedjen az Írás, melyet megjövendölt a Szentlélek Dávid szája által Júdásról, aki vezetőjük lett azoknak, akik megfogták Jézust. ");
INSERT INTO hun_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Mert közénk tartozott, és elnyerte ennek a szolgálatnak az osztályrészét. ");
INSERT INTO hun_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Mezőt szerzett hamisságának béréből, és lezuhanva, elhasadt középen, és minden belső része kiomlott. ");
INSERT INTO hun_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","És ezt megtudták mindazok, akik Jeruzsálemben laknak, úgyhogy azt a mezőt tulajdon nyelvükön Akeldamának, azaz Vérmezőnek nevezték el.) ");
INSERT INTO hun_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Mert meg van írva a Zsoltárok könyvében: »Legyen az ő lakóhelye puszta és ne legyen lakó abban.« És: »Az ő püspökségét más vegye át.« ");
INSERT INTO hun_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Szükséges azért, hogy azok közül a férfiak közül, akik velünk együtt jártak minden időben, míg az Úr Jézus közöttünk járt-kelt, ");
INSERT INTO hun_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","a János keresztségétől kezdve mind addig a napig, melyen fölvitetett a mennybe tőlünk, azok közül még valaki az ő feltámadásának tanúja legyen velünk együtt.“ ");
INSERT INTO hun_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ezért előállítottak kettőt, Józsefet, akit Barsabbásnak hívnak, akinek mellékneve Jusztusz volt, és Mátyást, ");
INSERT INTO hun_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","és így imádkoztak: „Te, Uram, ki mindenkinek szívét ismered, mutasd meg a kettő közül azt, akit kiválasztottál, ");
INSERT INTO hun_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","hogy elnyerje az osztályrészét e szolgálatnak és apostolságnak, melytől eltévelyedett Júdás, hogy az ő helyére jusson.“ ");
INSERT INTO hun_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Sorsot vetettek azért közülük, és a sors Mátyásra esett, és így a tizenegy apostol közé számlálták. ");
INSERT INTO hun_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Amikor a pünkösd napja eljött, mindnyájan egy akarattal együtt voltak. ");
INSERT INTO hun_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","És nagy hirtelenséggel az égből mintegy sebesen zúgó szélnek zendülése keletkezett, és eltöltötte az egész házat, ahol ültek. ");
INSERT INTO hun_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Kettős tüzes nyelvek jelentek meg előttük, és mindegyikükre ráereszkedtek. ");
INSERT INTO hun_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Megteltek mindnyájan Szentlélekkel, és kezdtek más nyelveken szólni, amint a Lélek adta nékik, hogy szóljanak. ");
INSERT INTO hun_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ekkor Jeruzsálemben laktak zsidók, istenfélő férfiak, minden nép közül valók, melyek az ég alatt vannak. ");
INSERT INTO hun_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Miután pedig ez a zúgás keletkezett, egybegyűlt a sokaság, és megzavarodott, mivelhogy mindegyik a maga nyelvén hallotta őket szólni. ");
INSERT INTO hun_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Mindnyájan elálmélkodtak, és csodálkozva mondták egymásnak: „Nem Galileából valók-e ezek mindnyájan, akik beszélnek? ");
INSERT INTO hun_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Hogyan halljuk hát őket, ki-ki közülünk a saját nyelvén, amelyben születtünk? ");
INSERT INTO hun_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Pártusok, médek és elámiták, és akik Mezopotámiában, Júdeában és Kappadóciában, Pontuszban és Ázsiában, ");
INSERT INTO hun_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frígiában és Pamfíliában, Egyiptomban és Líbiának tartományaiban lakunk, mely Ciréné mellett van, és a Rómából jöttek, akár zsidók, akár prozeliták, ");
INSERT INTO hun_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","krétaiak és arabok, halljuk, amint a mi nyelvünkön hirdetik az Istennek felséges dolgait.“ ");
INSERT INTO hun_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Elálmélkodtak mindnyájan, és zavarban voltak, és egymásnak ezt mondták: „Vajon mi akar ez lenni?“ ");
INSERT INTO hun_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Mások pedig csúfolódva ezt mondták: „Édes bortól részegedtek meg.“ ");
INSERT INTO hun_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Péter azonban előállt a tizeneggyel, felemelte hangját, és így szólt hozzájuk: „Zsidó férfiak, és mindnyájan, akik Jeruzsálemben laktok, vegyétek tudomásul, és hallgassátok meg beszédemet! ");
INSERT INTO hun_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Mert nem részegek ezek, amint ti állítjátok, hiszen a napnak harmadik órája van, ");
INSERT INTO hun_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","hanem ez az, amit megmondott Jóel próféta: ");
INSERT INTO hun_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","»És az utolsó napokban, – ezt mondja az Isten – , kitöltöm az én Lelkemet minden testre: és fiaitok és leányaitok prófétálnak, ifjaitok látomásokat látnak, és a vének álmokat álmodnak. ");
INSERT INTO hun_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Az én szolgáimra és szolgálóleányaimra is kitöltöm Lelkemet azokban a napokban, és prófétálni fognak. ");
INSERT INTO hun_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","És csodákat teszek az égben odafenn, jeleket a földön idelenn: vért, tüzet és füstnek gőzölgését. ");
INSERT INTO hun_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","A nap sötétséggé változik, a hold vérré, mielőtt eljön az Úrnak nagy és fényes napja. ");
INSERT INTO hun_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","És mindenki, aki az Úrnak nevét segítségül hívja, megtartatik.« ");
INSERT INTO hun_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Izraelita férfiak, halljátok meg ezeket a beszédeket: A Názáreti Jézust, azt a férfiút, aki Istentől bizonyságot nyert előttetek erők, csodatételek és jelek által, melyeket általa cselekedett Isten közöttetek, amint magatok is tudjátok, ");
INSERT INTO hun_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","azt, aki Istennek elhatározásából és rendeléséből adatott halálra, megragadva, gonosz kezeitekkel keresztfára feszítve megöltétek. ");
INSERT INTO hun_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","De az Isten feltámasztotta, a halál fájdalmait megoldva, mert lehetetlen volt, hogy az őt fogva tartsa. ");
INSERT INTO hun_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Mert Dávid ezt mondja róla: »Magam előtt láttam az Urat mindenkor, mert ő nékem jobb kezem felől van, hogy meg ne tántorodjam. ");
INSERT INTO hun_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ezért örvendezett a szívem, és vígadott a nyelvem; sőt még az én testem is reménységben nyugszik. ");
INSERT INTO hun_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Mert nem hagyod a lelkemet a sírban, és nem engeded, hogy szented rothadást lásson. ");
INSERT INTO hun_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Megjelentetted nékem az életnek útjait; betöltesz engem örömmel a te orcád előtt.« ");
INSERT INTO hun_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Atyámfiai férfiak! Szabad nyíltan szólnom előttetek Dávid pátriárkáról, hogy ő meghalt és eltemették, és az ő sírja mind a mai napig nálunk van. ");
INSERT INTO hun_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Mivel próféta volt, és tudta, hogy az Isten neki esküvéssel megesküdött, hogy majd az ő magvának gyümölcséből támasztja a Krisztust test szerint, hogy helyezze az ő királyi székibe, ");
INSERT INTO hun_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","előre látva ezt, szólt a Krisztus feltámadásáról, hogy az ő lelkét nem hagyta a sírban, sem a teste rothadást nem látott. ");
INSERT INTO hun_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ezt a Jézust feltámasztotta az Isten, aminek mi mindnyájan tanúi vagyunk. ");
INSERT INTO hun_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ezért az Istennek jobbja által felmagasztaltatva, és a megígért Szentlelket megnyerve az Atyától, kitöltötte ezt, amit ti most láttok és hallotok. ");
INSERT INTO hun_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Mert nem Dávid ment fel a mennyországba, hiszen ő maga mondja: »Mondta az Úr az én Uramnak: Ülj az én jobb kezem felől, ");
INSERT INTO hun_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","míg a te ellenségeidet lábaid alá zsámolyul vetem.« ");
INSERT INTO hun_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Bizony tudja meg azért Izraelnek egész háza, hogy Úrrá és Krisztussá tette őt az Isten, azt a Jézust, akit ti megfeszítettetek.“ ");
INSERT INTO hun_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Amikor pedig ezeket hallották, szívükben megkeseredtek, és ezt mondták Péternek és a többi apostoloknak: „Mit cselekedjünk, atyámfiai, férfiak?“ ");
INSERT INTO hun_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Péter pedig ezt mondta nekik: „Térjetek meg, és keresztelkedjetek meg mindnyájan a Jézus Krisztusnak nevében, a bűnöknek bocsánatára, és megkapjátok a Szentlélek ajándékát. ");
INSERT INTO hun_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Mert nektek szól az ígéret, és a gyermekeiteknek és mindazoknak, akik messze vannak, akiket csak elhív magának az Úr, a mi Istenünk.“ ");
INSERT INTO hun_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Sok egyéb beszéddel is buzgón kérte, és intette őket: „Szakítsátok el magatokat ettől a gonosz nemzetségtől!“ ");
INSERT INTO hun_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Akik pedig örömmel vették az ő beszédét, megkeresztelkedtek, és hozzájuk csatlakozott azon a napon mintegy háromezer lélek. ");
INSERT INTO hun_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","És foglalatoskodtak az apostolok tudományában és a közösségben, a kenyérnek megtörésében és az imádságban. ");
INSERT INTO hun_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Minden lélekben pedig félelem támadt, és az apostolok sok csodát és jelt tettek. ");
INSERT INTO hun_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Mindnyájan pedig, akik hittek, együtt voltak, és mindenük közös volt. ");
INSERT INTO hun_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Jószágukat és marháikat eladogatták, és szétosztogatták azokat mindenkinek, kinek-kinek amint szüksége volt rá. ");
INSERT INTO hun_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","És minden nap egy akarattal kitartva a templomban, és megtörve házanként a kenyeret, részesedtek az eledelben örömmel és tiszta szívvel. ");
INSERT INTO hun_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Dicsérték az Istent, és az egész nép kedvelte őket. Az Úr pedig minden napon gyarapította a gyülekezetet az üdvözülőkkel. ");
INSERT INTO hun_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Péter és János egyszer együtt mentek fel a templomba, a kilenc órai imádkozásra. ");
INSERT INTO hun_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ekkor odahoztak egy embert, aki születésétől fogva sánta volt, és akit minden nap le szoktak tenni a templom kapujánál, melyet Ékesnek neveznek, hogy alamizsnát kérjen azoktól, akik bemennek a templomba. ");
INSERT INTO hun_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Amikor meglátta, hogy Péter és János a templomba akarnak bemenni, alamizsnát kért tőlük. ");
INSERT INTO hun_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Péter pedig rátekintett Jánossal együtt, és ezt mondta: „Nézz reánk!“ ");
INSERT INTO hun_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ő pedig rájuk figyelt, remélve, hogy valamit kap tőlük. ");
INSERT INTO hun_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Péter pedig ezt mondta: „Ezüstöm és aranyam nincsen nekem, hanem amim van, azt adom neked: a Názáreti Jézus Krisztus nevében, kelj fel és járj!“ ");
INSERT INTO hun_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","És jobb kezénél fogva felemelte őt, és azonnal megerősödtek a lábai és bokái, ");
INSERT INTO hun_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","és felugorva megállt, és járt. Bement velük a templomba is, járkálva, és szökdelve, és dicsérte az Istent. ");
INSERT INTO hun_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","És látta az egész nép, hogy jár, és dicséri az Istent. ");
INSERT INTO hun_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Megismerték, hogy ő volt az, aki alamizsnáért ült a templomnak Ékes kapujában, és megteltek csodálkozással, és álmélkodtak, hogy mi történt vele. ");
INSERT INTO hun_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Amikor pedig a sánta, aki meggyógyult ragaszkodott Péterhez és Jánoshoz, az egész nép álmélkodva futott hozzájuk a csarnokba, melyet Salamonénak neveztek. ");
INSERT INTO hun_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Amikor pedig ezt látta Péter, ezt mondta a népnek: „Izrael férfiai, miért csodálkoztok ezen, vagy miért néztek reánk, mintha tulajdon erőnkkel vagy jámborságunkkal műveltük volna azt, hogy járjon? ");
INSERT INTO hun_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ábrahámnak, Izsáknak és Jákobnak Istene, a mi atyáinknak Istene megdicsőítette az ő Fiát, Jézust, akit ti elárultatok, és megtagadtatok Pilátus előtt, noha ő úgy ítélt, hogy elbocsátja. ");
INSERT INTO hun_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ti pedig azt a szentet és igazat megtagadtátok, és azt kívántátok, hogy a gyilkos embert bocsássa szabadon nektek, ");
INSERT INTO hun_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","az életnek fejedelmét pedig megöltétek, akit az Isten feltámasztott a halálból, aminek mi vagyunk tanúi. ");
INSERT INTO hun_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Az ő nevébe vetett hit, az ő neve erősítette meg ezt, akit láttok és ismertek, és a hit, mely ő általa van, adta neki ezt az ép egészséget mindannyiótok szeme láttára. ");
INSERT INTO hun_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","De most, atyámfiai, tudom, hogy tudatlanságból cselekedtetek, amikképpen a ti elöljáróitok is. ");
INSERT INTO hun_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Az Isten pedig, ekképpen töltötte be, amit előre megmondott prófétái által, hogy a Krisztus szenvedi fog. ");
INSERT INTO hun_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Bánjátok meg azért, és térjetek meg, hogy eltöröltessenek a ti bűneitek, hogy így eljöjjön az Úrtól a felüdülés ideje, ");
INSERT INTO hun_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","és elküldje a Jézus Krisztust, akit nektek előre hirdetett. ");
INSERT INTO hun_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Akit az égnek kell magába fogadnia mind addig az időkig, míg újjá teremtetnek mindazok, amelyekről az Isten kezdettől fogva szólott szent prófétái által. ");
INSERT INTO hun_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Mert Mózes ezt mondta az atyáknak: »Prófétát támaszt nektek az Úr, a ti Istenetek, atyátokfiai közül, mint engem: őt hallgassátok mindenben, amit csak szól nektek. ");
INSERT INTO hun_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Mindazokat pedig, akik nem hallgatnak arra a prófétára, ki fogják irtatni a nép közül.« ");
INSERT INTO hun_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","De a próféták is mindnyájan Sámueltől, és a következőktől fogva, akik csak szóltak, ezekről a napokról jövendöltek. ");
INSERT INTO hun_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ti vagytok a prófétáknak és a szövetségnek fiai, melyet Isten szerzett a mi atyáinkkal, Ábrahámnak ígérve: A te magodban áldást nyer a földnek valamennyi nemzetsége. ");
INSERT INTO hun_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Az Isten az ő Fiát, Jézust első sorban nektek támasztotta fel, elküldte őt, hogy megáldjon titeket, mindegyikőtöket megtérítve bűneitekből.“ ");
INSERT INTO hun_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Amíg ők a néphez szóltak, odaléptek hozzájuk a papok, a templom felügyelője és a szadduceusok. ");
INSERT INTO hun_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Nehezteltek amiatt, hogy ők a népet tanítják, és hirdetik a halálból való feltámadást Jézusban. ");
INSERT INTO hun_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Rájuk vetették kezüket, és őrizetbe vették őket másnapig, mert már este volt. ");
INSERT INTO hun_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Sokan pedig azok közül, akik hallgatták az igét, hittek, szám szerint mintegy ötezer férfi. ");
INSERT INTO hun_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Történt pedig, hogy másnapra egybegyűltek a vének és az írástudók fejei Jeruzsálembe. ");
INSERT INTO hun_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","És Annás, a főpap, Kajafás és János, Sándor és akik csak főpapi nemzetségből származtak. ");
INSERT INTO hun_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Amikor pedig őket középre állították, faggatták őket: „Micsoda hatalommal, vagy kinek a nevében cselekedtétek ezt?“ ");
INSERT INTO hun_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Akkor Péter, Szentlélekkel megtelve, ezt mondta nekik: „Népnek fejedelmei és Izraelnek vénei! ");
INSERT INTO hun_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Ha minket a mai napon egy nyomorék emberrel való jótett miatt hallgattok ki, hogy mitől gyógyult meg, ");
INSERT INTO hun_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","mindnyájan tudjátok meg, Izrael egész népével együtt, hogy a Názáreti Jézus Krisztusnak neve által, akit ti megfeszítettetek, akit Isten feltámasztott halottaiból: őáltala áll ez előttetek épségben. ");
INSERT INTO hun_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","»Ez az a kő, amelyet ti építők megvetettetek, mégis szegletkő lett.« ");
INSERT INTO hun_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Nincsen senki másban üdvösség, mert nem is adatott más név az emberek között az ég alatt, amely által üdvözülhetnénk.“ ");
INSERT INTO hun_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Amikor pedig látták, hogy Péter és János milyen bátran szólnak, és megtudták, hogy írástudatlan és közönséges emberek, elcsodálkoztak. Föl is ismerték őket, hogy a Jézussal voltak. ");
INSERT INTO hun_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Amikor azonban látták, hogy az az ember, amelyik meggyógyult, velük együtt ott áll, semmit nem bírtak ellenük szólni. ");
INSERT INTO hun_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Miután kiküldték őket a gyűlésből, maguk közt tanácskoztak, s ezt mondták: ");
INSERT INTO hun_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","„Mit cselekedjünk ezekkel az emberekkel? Mert nyilvánvaló, hogy csoda történt általuk, mindenki, aki Jeruzsálemben lakik tudja, és le nem tagadhatjuk. ");
INSERT INTO hun_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","De hogy tovább ne terjedjen a nép között, fenyegessük meg őket, hogy többé egy emberhez se szóljanak az ő nevében.“ ");
INSERT INTO hun_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ezért beszólították őket, és megparancsolták nekik, hogy egyáltalán ne szóljanak, és ne tanítsanak a Jézus nevében. ");
INSERT INTO hun_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Péter és János pedig ezt felelte: „Vajon igaz dolog-e Isten előtt, hogy rátok hallgassunk inkább, mintsem Istenre, ítéljétek meg magatok! ");
INSERT INTO hun_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Mert nem tehetjük, hogy amiket láttunk és hallottunk, azokról ne beszéljünk.“ ");
INSERT INTO hun_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ők pedig nem találtak semmi módot arra, hogy megbüntessék őket, megfenyegették, és elbocsátották őket a nép miatt, mert mindnyájan dicsőítették az Istent azért, ami történt, ");
INSERT INTO hun_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","mert több mint negyven esztendős volt az az ember, akivel a gyógyításnak ez a csodája történt. ");
INSERT INTO hun_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Amikor pedig elbocsátották őket, elmentek az övéikhez, és elbeszélték, amiket a főpapok és a vének mondtak nékik. ");
INSERT INTO hun_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ők pedig mikor ezt hallották, egy szívvel-lélekkel felemelték szavukat az Istenhez, és ezt mondták: „Urunk, te vagy az Isten, aki teremtetted a mennyet és a földet, a tengert és minden azokban levő dolgot, ");
INSERT INTO hun_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","aki, a te szolgádnak Dávidnak szája által ezt mondtad: »Miért zúgolódtak a pogányok, és gondoltak a népek hiábavalóságot? ");
INSERT INTO hun_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Fölkeltek a földnek királyai, és a fejedelmek egybegyűltek az Úr ellen, és az ő Krisztusa ellen.« ");
INSERT INTO hun_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Mert bizony a te szent Fiad, Jézus ellen, akit felkentél, megegyezett Heródes és Poncius Pilátus a pogányokkal és Izrael népével, ");
INSERT INTO hun_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","hogy véghezvigyék, amiről a te kezed és a te tanácsod előre elhatározott, hogy megtörténjenek. ");
INSERT INTO hun_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Most azért, Urunk, tekints a fenyegetéseikre, és add meg a te szolgáidnak, hogy teljes bátorsággal szólják a te beszédedet; ");
INSERT INTO hun_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","nyújtsd ki kezedet gyógyításra, hogy jelek és csodák történjenek a te szent Fiad, Jézusnak neve által.“ ");
INSERT INTO hun_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Miután könyörögtek, megmozdult a hely, ahol egybegyűltek, és beteltek mindnyájan Szentlélekkel, és az Isten beszédét bátorsággal szólták. ");
INSERT INTO hun_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","A hívők sokaságának pedig szíve-lelke egy volt. Senki semmi jószágát nem mondta magáénak, hanem mindenük közös volt. ");
INSERT INTO hun_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Az apostolok pedig nagy erővel tettek bizonyságot az Úr Jézus feltámadásáról, és nagy kegyelem volt mindnyájukon. ");
INSERT INTO hun_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Mert szűkölködő sem volt közöttük senki, mert akik földek vagy házak birtokosai voltak, eladták azokat, elhozták az eladott javak árát, ");
INSERT INTO hun_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","és letették az apostolok lábai elé, azután elosztották egymás között, amint kinek-kinek szüksége volt rá. ");
INSERT INTO hun_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","József is, akit az apostolok Barnabásnak neveztek el (ami azt jelenti, hogy Vigasztalás fia), Lévita, származása szerint ciprusi, ");
INSERT INTO hun_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","neki mezője volt, eladta azt, a pénzt elhozta, és az apostolok lábai elé letette. ");
INSERT INTO hun_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Egy ember azonban, név szerint Anániás, Szafirával, az ő feleségével együtt, eladta birtokát. ");
INSERT INTO hun_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","És félre tett az árából, feleségének is tudtával, és egy részét elvitték, az apostoloknak lábai elé letették. ");
INSERT INTO hun_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Péter pedig ezt mondta: „Anániás, miért foglalta el a Sátán a te szívedet, hogy megcsald a Szentlelket, és a mezőnek árából félre tégy? ");
INSERT INTO hun_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ha megmaradt volna, neked maradt volna meg, és miután eladtad, nem te rendelkeztél-e vele? Miért cselekedted ezt a dolgot szívedben? Nem embereknek hazudtál, hanem Istennek.“ ");
INSERT INTO hun_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Amint Anániás meghallotta ezeket a szavakat, lerogyott és meghalt. Erre mindenkiben nagy félelem támadt, akik ezeket hallották. ");
INSERT INTO hun_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Az ifjak pedig felkeltek, begöngyölték őt, kivitték, és eltemették. ");
INSERT INTO hun_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Történt aztán mintegy három óra múlva, hogy az ő felesége, nem tudva mi történt, bement. ");
INSERT INTO hun_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Péter pedig ezt mondta neki: „Mondd meg nekem, vajon ennyiért adtátok-e el a földet?“ Ő pedig ezt mondta: „Igen, ennyiért.“ ");
INSERT INTO hun_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Péter pedig ezt mondta néki: „Miért egyeztetek meg, hogy az Úrnak lelkét megkísértsétek? Íme, a küszöbön vannak azoknak lábai, akik eltemették férjedet, és kivisznek téged.“ ");
INSERT INTO hun_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","És azonnal összerogyott lábainál, és meghalt. Az ifjak pedig bementek, és halva találták, kivitték, és eltemették férje mellé. ");
INSERT INTO hun_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Erre nagy félelem támadt az egész gyülekezetben és mindazokban, akik ezeket hallották. ");
INSERT INTO hun_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Az apostolok kezei által pedig sok jel és csoda történt a nép között. Egy akarattal mindnyájan a Salamon csarnokában tartózkodtak. ");
INSERT INTO hun_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Mások közül senki sem mert közéjük elegyedni. A nép azonban magasztalta őket. ");
INSERT INTO hun_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Hívők pedig egyre többen csatlakoztak az Úrhoz, férfiak és asszonyok sokasága. ");
INSERT INTO hun_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Az utcákra hozták ki a betegeket, letették ágyakon és nyoszolyákon, hogy az arra menő Péternek csak árnyéka is érje valamelyiket közülük. ");
INSERT INTO hun_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","A szomszéd városok sokasága is Jeruzsálembe gyűlt, betegeket és tisztátalan lelkektől gyötörteket hoztak, akik mind meggyógyultak. ");
INSERT INTO hun_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ekkor felkelt a főpap és mind, akik vele voltak, azaz a szadduceusok felekezete, megteltek irigységgel, ");
INSERT INTO hun_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Elfogták az apostolokat, és közönséges tömlöcbe tették őket. ");
INSERT INTO hun_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Azonban az Úr angyala éjszaka megnyitotta a tömlöc ajtaját, és kihozta őket, s ezt mondta: ");
INSERT INTO hun_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","„Menjetek el, és álljatok ki, a templomban a nép elé, és hirdessétek ez életnek minden beszédét!“ ");
INSERT INTO hun_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ők pedig ezt hallva, bementek korán reggel a templomba, és tanítottak. Amikor pedig főpap megérkezett és a vele levők, összehívták a gyűlést és Izrael fiainak egész tanácsát, és elküldtek a tömlöcbe, hogy hozzák elő őket. ");
INSERT INTO hun_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Amikor azonban a poroszlók oda mentek, nem találták őket a tömlöcben; visszatérve tehát, jelentették: ");
INSERT INTO hun_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","„A tömlöcöt ugyan nagyon erősen bezárva találtuk, és az őrök kívül az ajtó előtt álltak; azonban mikor kinyitottuk, ott benn senkit sem találtunk.“ ");
INSERT INTO hun_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Amint pedig hallották ezeket a szavakat a pap, és a templom felügyelője és a főpapok, zavarba estek ezek miatt, hogy mi lehet ez? ");
INSERT INTO hun_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Valaki pedig eljött, s hírül adta nekik: „Íme, azok a férfiak, akiket a tömlöcbe vetettetek, a templomban állnak, és tanítják a népet.“ ");
INSERT INTO hun_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Akkor elment a felügyelő a poroszlókkal, elővezette őket erőszak nélkül, ugyanis féltek a néptől, hogy megkövezi őket. ");
INSERT INTO hun_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Elővezették hát, és a tanács elé állították őket, a főpap pedig megkérdezte tőlük: ");
INSERT INTO hun_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","„Nem parancsoltuk-e meg nektek szigorúan, hogy ne tanítsatok annak nevében? És íme, betöltöttétek Jeruzsálemet tanításotokkal, és mi reánk akarjátok hárítani annak az embernek vérét.“ ");
INSERT INTO hun_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Péter és az apostolok pedig ezt felelték: „Istennek kell inkább engedni, mintsem az embereknek. ");
INSERT INTO hun_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","A mi atyáinknak Istene feltámasztotta Jézust, akit ti fára függesztve megöltetek. ");
INSERT INTO hun_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Az Isten fejedelemmé és megtartóvá emelte jobbjával, hogy Izraelnek bűnbánatot, és bűnöknek bocsánatát adja. ");
INSERT INTO hun_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Mi vagyunk tanúi, e beszédek felől, és a Szentlélek is, akit Isten azoknak adott, akik neki engedelmeskednek.“ ");
INSERT INTO hun_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Amikor pedig azok ezeket hallva fogukat csikorgatták, arról tanácskoztak, hogy megölik őket. ");
INSERT INTO hun_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Azonban a tanácsban egy farizeus felállt, név szerint Gamáliél, aki az egész nép előtt tisztelt törvénytudó volt, és megparancsolta, hogy egy kis időre vezessék ki az apostolokat. ");
INSERT INTO hun_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","És ezt mondta a többieknek: „Izrael férfiai, fontoljátok meg, hogy mit akartok ezekkel az emberekkel tenni! ");
INSERT INTO hun_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Mert ezelőtt felkelt Teudás, és azt mondta, hogy ő valaki, és mintegy négyszáz embernyi tömeg csatlakozott hozzá, de megölték, és mindnyájan, akik csak követték őt szétszéledtek, és semmivé lettek. ");
INSERT INTO hun_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ezután felkelt az a bizonyos galileai Júdás az összeírás idején, és sok embert maga után csábított: ez is elveszett, és mindazok, akik őt követték, szétszóródtak. ");
INSERT INTO hun_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Mostanra nézve is azt mondom nektek, engedjétek el ezeket az embereket, és hagyjátok őket békén, mert ha emberektől van ez a szándék, vagy ez a dolog, akkor megsemmisül, ");
INSERT INTO hun_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","ha pedig Istentől van, ti meg nem szüntethetitek azt, és esetleg Isten ellen harcolóknak is találnak titeket.“ ");
INSERT INTO hun_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Azok engedtek neki, majd beszólították az apostolokat, megverték őket, megparancsolták, hogy a Jézus nevében ne szóljanak, és elbocsátották őket. ");
INSERT INTO hun_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ők pedig örömmel mentek el a tanács elől, hogy méltók voltak arra, hogy az ő nevéért gyalázatot szenvedjenek. ");
INSERT INTO hun_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","És mindennap a templomban és házanként nem szűntek meg tanítani, és hirdetni Jézust, a Krisztust. ");
INSERT INTO hun_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Azokban a napokban pedig, amikor a tanítványok száma szaporodott, a görög zsidók közt panaszkodás támadt a héberek ellen, hogy a közülük való özvegyasszonyokat mellőzik a mindennapi szolgálatban. ");
INSERT INTO hun_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ezért a tizenkettő egybegyűjtve a tanítványok sokaságát, ezt mondták: „Nem helyes, hogy mi az Isten igéjét elhanyagoljuk, és az asztalok körül szolgálunk. ");
INSERT INTO hun_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Válasszatok ezért, atyámfiai, magatok közül hét férfit, akiknek jó hírük van, akik Szentlélekkel és bölcsességgel vannak megtelve, hogy őket erre az elfoglaltságra beállítsuk. ");
INSERT INTO hun_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Mi pedig foglalatosok maradunk az imádkozásban, és az igehirdetés szolgálatában.“ ");
INSERT INTO hun_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Tetszett ez a beszéd az egész gyülekezetnek, és kiválasztották Istvánt, aki hittel és Szentlélekkel telt férfi volt, Fülöpöt, Prokhoroszt, Nikánórt, Timónt, Parmenászt és Nikoláoszt, aki Antiókhiából való prozelita volt; ");
INSERT INTO hun_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Őket az apostolok elé állították, és miután imádkoztak, kezeiket rájuk tették. ");
INSERT INTO hun_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","És az Isten igéje növekedett, és sokasodott a tanítványok száma Jeruzsálemben, és a papok közül is nagyon sokan követték a hitet. ");
INSERT INTO hun_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","István pedig – hittel és erővel telve – , nagy csodákat és jeleket cselekedett az emberek között. ");
INSERT INTO hun_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Néhányan azonban eljöttek, akik ahhoz a zsinagógához tartoztak, amelyet a szabadosok, a ciréneiek, az alexandriaiak, a Ciliciából és Ázsiából valókénak neveztek, és Istvánnal vitatkoztak. ");
INSERT INTO hun_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","De nem tudtak ellenállni annak a bölcsességnek és a Léleknek, amellyel szólt. ");
INSERT INTO hun_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ekkor felbujtottak néhány embert, akik ezt mondták: „Hallottuk őt káromló beszédeket szólni Mózes ellen és az Isten ellen.“ ");
INSERT INTO hun_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","És fellázították a népet, a véneket és az írástudókat; és reá rohanva, magukkal ragadták őt, és elvitték a tanács elé. ");
INSERT INTO hun_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Hamis tanúkat állítottak, akik azt mondták: „Ez az ember nem szűnik meg káromló beszédeket szólni e szent hely ellen és a törvény ellen. ");
INSERT INTO hun_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Hallottuk, amint azt mondta, hogy az a Názáreti Jézus ezt a helyet lerombolja, és megváltoztatja a szertartásokat, amelyeket Mózes adott nékünk.“ ");
INSERT INTO hun_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","A tanácsban ülők mindnyájan tekintetüket reá vetették, és olyannak látták az arcát, mint egy angyalé. ");
INSERT INTO hun_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","A főpap pedig megkérdezte: „Vajon tényleg így vannak-e ezek a dolgok?“ ");
INSERT INTO hun_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ő pedig ezt mondta: „Férfiak, atyámfiai és atyák, halljátok meg! A dicsőségnek Istene megjelent a mi atyánknak, Ábrahámnak, amikor Mezopotámiában volt, mielőtt Háránban lakott, ");
INSERT INTO hun_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","és mondta neki: »Eredj ki a földedből és a te nemzetséged közül, és gyere arra a földre, amelyet mutatok neked.« ");
INSERT INTO hun_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Akkor kiment a káldeusok földjéből, és Háránban lakott. Miután pedig meghalt az atyja, kihozta onnan erre a földre, amelyen ti most laktok. ");
INSERT INTO hun_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Nem adott neki abban örökséget, még egy talpalatnyi földet sem, de azt ígérte, hogy neki adja azt birtokul, és utódainak, holott nem is volt neki gyermeke. ");
INSERT INTO hun_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Az Isten pedig azt mondta neki, hogy az utódai zsellérek lesznek idegen földön, és szolgaság alá vetik, és nyomorgatják négyszáz esztendeig őket. ");
INSERT INTO hun_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","De azt a népet, amelynek szolgálnak, megítélem, mondta az Isten, ők pedig ezek után kijönnek, és szolgálnak nekem ezen a helyen. ");
INSERT INTO hun_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","És a körülmetélés szövetségét adta neki: és így nemzette Izsákot, és körülmetélte őt a nyolcadik napon, és Izsák Jákobot, és Jákob a tizenkét pátriárkát. ");
INSERT INTO hun_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","A pátriárkák pedig irigységből eladták Józsefet Egyiptomba, de Isten vele volt, ");
INSERT INTO hun_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","megszabadította őt minden nyomorúságából, kedvességet és bölcsességet adott neki a fáraó, Egyiptom királya előtt, aki őt Egyiptom fölé és az ő egész háza fölé kormányzóul állította. ");
INSERT INTO hun_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Egyiptom és Kánaán egész földjére pedig éhínség következett, és nagy nyomorúság, és a mi atyáink nem találtak eledelt. ");
INSERT INTO hun_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Amikor pedig meghallotta Jákob, hogy Egyiptomban van gabona, elküldte először a mi atyáinkat. ");
INSERT INTO hun_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Második alkalommal fölismerték Józsefet testvérei, és a fáraó megtudta József származását. ");
INSERT INTO hun_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","József elküldve, magához hívatta atyját, Jákobot és az egész hetvenöt lélekből álló rokonságát. ");
INSERT INTO hun_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Elment tehát Jákob Egyiptomba, és meghalt ő és a mi atyáink is. ");
INSERT INTO hun_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Elvitték őket Sikembe, és abba a sírba helyezték el, melyet Ábrahám vett ezüstpénzen, Emórnak, a Sikem atyjának fiaitól. ");
INSERT INTO hun_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Amikor pedig közeledett az ígéret ideje, melyet Isten esküvel ígért Ábrahámnak, megnövekedett a nép, és megsokasodott Egyiptomban. ");
INSERT INTO hun_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Egészen addig, míg egy másik király nem lett, aki nem ismerte Józsefet. ");
INSERT INTO hun_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ez a mi nemzetségünkkel álnokul bánt, nyomorgatta atyáinkat, hogy csecsemőiket tegyék ki, hogy életben ne maradjanak. ");
INSERT INTO hun_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ekkor született Mózes, aki ékes volt az Isten előtt. Három hónapig atyja házában tartották. ");
INSERT INTO hun_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Amikor pedig kitették, a fáraó leánya vette fel, és nevelte fel őt a saját fia gyanánt. ");
INSERT INTO hun_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Mózest az egyiptomiak minden bölcsességére megtanították, és hatalmas volt beszédben és cselekedetben. ");
INSERT INTO hun_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Amikor pedig a negyvenedik évét betöltötte, eszébe jutott, hogy meglátogassa atyjafiait, az Izrael fiait. ");
INSERT INTO hun_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Amikor látta, hogy egyiket bántalmazzák, oltalmába vette, és az egyiptomi embert megölve, bosszút állt azért, akit bántottak. ");
INSERT INTO hun_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Azt gondolta, hogy atyjafiai megértik, hogy az Isten az ő keze által ad nekik szabadulást, de azok nem értették meg. ");
INSERT INTO hun_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Másnap meg olyankor jelent meg köztük, mikor összevesztek, és békességre intette őket: Férfiak, ti testvérek vagytok, miért bosszantjátok egymást? ");
INSERT INTO hun_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","De az, aki felebarátját bántalmazta, elutasította őt magától, ezt mondva: »Kicsoda tett téged fejedelemmé és bíróvá mi rajtunk? ");
INSERT INTO hun_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Csak nem akarsz engem is megölni, ahogyan megölted tegnap az egyiptomit?« ");
INSERT INTO hun_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Erre a beszédre azután Mózes elmenekült, és jövevény lett Midján földjén, ahol két fia született. ");
INSERT INTO hun_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Negyven esztendő elteltével az Úr angyala megjelent neki a Sínai hegy pusztájában csipkebokornak tüzes lángjában. ");
INSERT INTO hun_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Mózes pedig mikor meglátta, elcsodálkozott azon, amit látott. Amikor pedig oda ment, hogy megszemlélje, az Úr szava szólt hozzá: ");
INSERT INTO hun_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","»Én vagyok a te atyáidnak Istene, Ábrahámnak Istene, Izsáknak Istene, és Jákobnak Istene.« Mózes pedig megrémült, és nem mert odanézni. ");
INSERT INTO hun_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Az Úr pedig ezt mondta neki: »Oldozd le sarudat lábaidról, mert a hely, amelyen állsz, szent föld. ");
INSERT INTO hun_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Megláttam népemnek nyomorúságát, mely Egyiptomban van, és fohászkodásukat meghallgattam, és azért szálltam le, hogy őket megszabadítsam. Most azért jöjj, elküldelek téged Egyiptomba.« ");
INSERT INTO hun_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Ezt a Mózest, akit megtagadtak ezt mondva: Ki tett téged fejedelemmé és bíróvá? – ezt az Isten fejedelmül és szabadítóul küldte el angyala által, aki megjelent neki a csipkebokorban. ");
INSERT INTO hun_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ez hozta ki őket, csodákat és jeleket téve Egyiptom földjén, és a Vörös tengeren és a pusztában negyven esztendeig. ");
INSERT INTO hun_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Ez az a Mózes, aki Izrael fiainak ezt mondta: »Prófétát támaszt nektek az Úr, a ti Istenetek, testvéreitek közül, mint engem: őt hallgassátok.« ");
INSERT INTO hun_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ez az, aki ott volt a gyülekezetben, a pusztában a Sínai hegyen vele beszélő angyallal és atyáinkkal, aki az élő igéket vette át, hogy nekünk adja. ");
INSERT INTO hun_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Neki nem akartak engedni atyáink, hanem eltaszították maguktól, és szívükben Egyiptom felé fordultak, ");
INSERT INTO hun_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","és ezt mondták Áronnak: »Csinálj nekünk isteneket, akik előttünk járjanak, mert ezzel a Mózessel, aki minket Egyiptom földjéről kihozott, nem tudjuk, mi történt.« ");
INSERT INTO hun_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","És borjút csináltak azokban a napokban, és áldozatot vittek a bálványnak, és gyönyörködtek kezeik alkotásában. ");
INSERT INTO hun_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Az Isten pedig elfordult tőlük, és hagyta, hogy az ég seregének szolgáljanak, amint meg van írva a próféták könyvében: »Vajon áldozati állatokat És áldozatokat hoztatok-e nékem negyven esztendeig a pusztában, Izraelnek háza? ");
INSERT INTO hun_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ellenkezőleg, inkább hordoztátok a Molok sátrát, és a ti isteneteknek, Romfának csillagát, a képeket, melyeket csináltatok, hogy azokat imádjátok: elviszlek azért titeket Babilonon túlra.« ");
INSERT INTO hun_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","A Szövetség sátra a mi atyáinknál volt a pusztában, amint parancsolta az, aki azt mondta Mózesnek, hogy azt arra a mintára csinálja, amelyet látott. ");
INSERT INTO hun_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Amelyet atyáink átvéve, be is hoztak Józsuéval, mikor birtokba vették a pogányok földjét, akiket kiűzött az Isten atyáink színe elől, egészen Dávid idejéig. ");
INSERT INTO hun_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Ő kegyelmet talált az Isten előtt, és könyörgött, hogy hajlékot találhasson Jákób Istenének, ");
INSERT INTO hun_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","de a házat Salamon építette neki. ");
INSERT INTO hun_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","A Magasságos azonban nem kézzel épített templomokban lakik, amint a próféta mondja: ");
INSERT INTO hun_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","»A menny nékem a trónom, a föld pedig az én lábaimnak zsámolya. Milyen házat építhettek nékem? – azt mondja az Úr, vagy melyik az én nyugodalmamnak helye? ");
INSERT INTO hun_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Nem az én kezem alkotta-e mindezeket?« ");
INSERT INTO hun_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Kemény nyakú és körülmetéletlen szívű és fülű emberek, ti mindenkor ellenálltok a Szentléleknek, ugyan úgy, mint atyáitok. ");
INSERT INTO hun_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","A próféták közül kit nem üldöztek atyáitok? Megölték azokat, akik eleve hirdették annak az Igaznak eljövetelét, akinek most árulóivá és gyilkosaivá lettetek. ");
INSERT INTO hun_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","A törvényt angyalok közvetítésével vettétek, de nem tartottátok meg.“ ");
INSERT INTO hun_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Amikor pedig ezeket hallották, szívüket elöntötte a düh, és fogaikat vicsorgatták ellene. ");
INSERT INTO hun_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Mivel pedig eltelt Szentlélekkel, föltekintett a mennybe, és látta Isten dicsőségét, és Jézust az Istennek jobbja felől állni, ");
INSERT INTO hun_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","és ezt mondta: „Íme, látom az egeket megnyílni, és az Emberfiát az Isten jobbja felől állni.“ ");
INSERT INTO hun_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ekkor hangosan felkiáltottak, füleiket bedugták, és egy akarattal rárohantak, ");
INSERT INTO hun_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","kiűzték a városon kívül, és megkövezték. A tanúk pedig felsőruháikat egy Saul nevezetű ifjú lábaihoz rakták le. ");
INSERT INTO hun_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Megkövezték tehát Istvánt, aki így imádkozott: „Uram Jézus, vedd magadhoz az én lelkemet!“ ");
INSERT INTO hun_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Térdre esett, és hangosan felkiáltott: „Uram, ne tulajdonítsd nekik ezt a bűnt! És ezt mondva, elaludt.“ ");
INSERT INTO hun_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saul pedig szintén javasolta megölését. Azon a napon nagy üldözés támadt a jeruzsálemi gyülekezet ellen, és mindnyájan szétszéledtek Júdeának és Samáriának tájaira, az apostolokat kivéve. ");
INSERT INTO hun_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Istvánt pedig eltemették kegyes férfiak, és nagyon megsiratták. ");
INSERT INTO hun_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Saul pedig pusztította az anyaszentegyházat: házról-házra járva férfiakat és asszonyokat elhurcolt, és tömlöcbe vetett. ");
INSERT INTO hun_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ők azonban szétszéledve, ahol csak jártak, hirdették az igét. ");
INSERT INTO hun_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Fülöp lement Samária városába, és prédikálta nekik a Krisztust. ");
INSERT INTO hun_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","A sokaság pedig egy szívvel-lélekkel figyelt azokra, amiket Fülöp mondott, hallva és látva a jeleket, amelyeket cselekedett. ");
INSERT INTO hun_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Mert sokakból, akikben tisztátalan lelkek voltak, nagy hangon kiáltva kimentek, sok gutaütött és sánta pedig meggyógyult, ");
INSERT INTO hun_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","és nagy öröm lett abban a városban. ");
INSERT INTO hun_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Egy Simon nevű ember pedig már korábban gyakorolta abban a városban az ördögi tudományt, és elámította Samária népét, magát valami nagynak állítva. ");
INSERT INTO hun_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Mindnyájan figyeltek rá, kicsinytől nagyig, és ezt mondták: „Ez az Istennek a nagy ereje!“ ");
INSERT INTO hun_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Azért figyeltek fel rá, mert hosszú időn át az ördögi mesterkedésekkel elámította őket. ");
INSERT INTO hun_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","De miután hittek Fülöpnek, aki az Isten országára és a Jézus Krisztus nevére vonatkozó örvendetes dolgokat hirdette, megkeresztelkedtek, férfiak és asszonyok is. ");
INSERT INTO hun_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simon maga is hitt, és megkeresztelkedve Fülöppel tartott, és látva, hogy jelek és nagy csodák történnek, elálmélkodott. ");
INSERT INTO hun_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Amikor pedig meghallották a jeruzsálemi apostolok, hogy Samária elfogadta az Isten igéjét, elküldték hozzájuk Pétert és Jánost. ");
INSERT INTO hun_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Ők amikor lementek, könyörögtek értük, hogy vegyenek Szentlelket, ");
INSERT INTO hun_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","mert még senkire közülük nem szállt rá, csak meg voltak keresztelve az Úr Jézus nevére. ");
INSERT INTO hun_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Akkor kezeiket reájuk tették, és Szentlelket vettek. ");
INSERT INTO hun_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Amikor pedig látta Simon, hogy az apostolok kézrátétele által adatik a Szentlélek, pénzt kínált nekik, ");
INSERT INTO hun_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","és ezt mondta: „Adjátok nekem is ezt a hatalmat, hogy akire ráteszem kezeimet, az vegye a Szentlelket.“ ");
INSERT INTO hun_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","De Péter ezt mondta neki: „A pénzed veled együtt vesszen el, mivel azt gondoltad, hogy az Istennek ajándéka pénzen megvehető. ");
INSERT INTO hun_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Nincs neked részed, sem örökséged ebben a dologban, mert a szíved nem igaz az Isten előtt. ");
INSERT INTO hun_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Térj meg azért ebből a gonoszságodból, és kérjed az Istent, talán megbocsátja neked szívednek gondolatát. ");
INSERT INTO hun_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Mert látom, hogy keserű méregben és álnokság fogságában vagy.“ ");
INSERT INTO hun_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simon pedig így felelt: „Könyörögjetek érettem az Úrhoz, hogy semmi azokból, amiket mondtatok, rám ne jöjjön.“ ");
INSERT INTO hun_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Ők pedig, miután bizonyságot tettek, és hirdették az Úrnak igéjét, visszatértek Jeruzsálembe, és sok samáriai faluban prédikálták az evangéliumot. ");
INSERT INTO hun_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Az Úr angyala pedig így szólt Fülöphöz: „Kelj fel, és menj el dél felé, arra a járatlan útra, amely Jeruzsálemből Gázába megy alá.“ ");
INSERT INTO hun_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","És elment. És íme, egy szerecsen férfi, Kandakénak, a szerecsenek királyasszonyának hatalmas komornyikja, aki az egész kincstárának felügyelője volt, és feljött imádkozni Jeruzsálembe; ");
INSERT INTO hun_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","visszatérőben a szekerén ült, és olvasta Ézsaiás prófétát. ");
INSERT INTO hun_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","A Lélek pedig ezt mondta Fülöpnek: „Menj oda, és csatlakozzál ehhez a szekérhez!“ ");
INSERT INTO hun_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Amikor Fülöp odafutott, hallotta, amint Ézsaiás prófétát olvassa, és megkérdezte tőle: „Vajon érted-e, amit olvasol?“ ");
INSERT INTO hun_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ő pedig így felelt: „Hogyan érthetném, hacsak valaki meg nem magyarázza nekem?“ És kérte Fülöpöt, hogy szálljon fel, és üljön mellé. ");
INSERT INTO hun_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Az Írás helye pedig, melyet olvasott, ez volt: Mint juhot vitték mészárszékre, és mint a bárány néma a nyírója előtt, úgy nem nyitotta meg a száját. ");
INSERT INTO hun_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","A megaláztatásában az ítélet elvétetett róla, az ő nemzetségét pedig kicsoda sorolja fel? Mert elvétetik a földről az ő élete. ");
INSERT INTO hun_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","A komornyik pedig ezt mondta Fülöpnek: „Kérlek téged, kiről mondja ezt a próféta? Magáról-e, vagy más valakiről?“ ");
INSERT INTO hun_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Fülöp pedig megnyitotta száját, és kiindulva ebből az Írásból, hirdette neki Jézust. ");
INSERT INTO hun_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Amikor pedig az úton mentek, egy vízhez jutottak, és ezt mondta a komornyik: „Íme, itt a víz! Mi akadálya van, hogy megkeresztelkedjem?“ ");
INSERT INTO hun_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Fülöp pedig ezt mondta: „Ha teljes szívből hiszel, akkor lehet.“ Ő pedig így felelt: „Hiszem, hogy Jézus Krisztus az Isten Fia.“ ");
INSERT INTO hun_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","És megállította a szekeret, és leszálltak mindketten a vízbe, Fülöp és a komornyik, és megkeresztelte őt. ");
INSERT INTO hun_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Amikor pedig a vízből feljöttek, az Úrnak Lelke elragadta Fülöpöt, és többé nem látta őt a komornyik, de örömmel ment tovább az útján. ");
INSERT INTO hun_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Fülöp pedig Azótoszba találta magát, és szertejárva hirdette az evangéliumot minden városnak, amíg Cézáreába nem jutott. ");
INSERT INTO hun_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Saul pedig még fenyegetéstől és öldökléstől lihegve az Úrnak tanítványai ellen, elment a főpaphoz, ");
INSERT INTO hun_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","leveleket kért tőle Damaszkuszba a zsinagógákhoz, hogy ha talál olyanokat, akik ennek az útnak követői, akár férfiakat, akár asszonyokat, elfogva Jeruzsálembe vigye őket. ");
INSERT INTO hun_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","És amint ment, és közeledett Damaszkuszhoz, nagy hirtelenséggel fény sugározta őt körül a mennyből, ");
INSERT INTO hun_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","leesett a földre, szózatot hallott, mely ezt mondta neki: „Saul, Saul, miért üldözöl engem?“ ");
INSERT INTO hun_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ő pedig megkérdezte: „Kicsoda vagy, Uram?“ Az Úr pedig ezt mondta: „Én vagyok Jézus, akit te üldözöl. Nehéz neked az ösztöke ellen rugódoznod.“ ");
INSERT INTO hun_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Erre remegve és ámulva kérdezte: „Uram, mit akarsz, hogy cselekedjem?“ Az Úr pedig ezt mondta neki: „Kelj fel, és menj be a városba, és majd megmondják neked, mit kell cselekedned.“ ");
INSERT INTO hun_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","A vele utazó férfiak pedig némán álltak, hallották ugyan a hangot, de senkit sem láttak. ");
INSERT INTO hun_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saul pedig felkelt a földről, de mikor kinyitotta szemeit, senkit sem látott, ezért kézen fogva vezették be őt Damaszkuszba. ");
INSERT INTO hun_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Három napig nem látott, nem evett és nem ivott. ");
INSERT INTO hun_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Volt pedig egy tanítvány Damaszkuszban, név szerint Anániás. Látomásban ezt mondta neki az Úr: „Anániás!“ Ő pedig ezt mondta: „Ímhol vagyok Uram!“ ");
INSERT INTO hun_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Az Úr pedig ezt mondta neki: „Kelj fel, menj el az úgynevezett Egyenes utcába, és keress föl a Júdás házában egy Saul nevű tarzuszi embert, mert imádkozik.“ ");
INSERT INTO hun_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","És látta Saul látomásban, hogy egy Anániás nevű férfiú bemegy hozzá, és kezét reá teszi, hogy lásson. ");
INSERT INTO hun_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Anániás pedig így felelt: „Uram, sok embertől hallottam e férfiú felől, milyen sok bosszúsággal illette szentjeidet Jeruzsálemben, ");
INSERT INTO hun_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","és itt is hatalma van a főpapoktól, hogy mindazokat megkötözze, akik a te nevedet segítségül hívják.“ ");
INSERT INTO hun_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Az Úr pedig ezt mondta neki: „Eredj el, mert ő nekem választott eszközöm, hogy hordozza az én nevemet a pogányok, királyok és Izrael fiai előtt. ");
INSERT INTO hun_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Mert én megmutatom neki, mennyit kell az én nevemért szenvednie.“ ");
INSERT INTO hun_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Elment tehát Anániás, bement a házba, és kezeit reá tette, és ezt mondta: „Saul atyámfia, az Úr küldött engem, Jézus, aki megjelent neked az úton, amelyen jöttél, hogy szemeid megnyíljanak, és megteljél Szentlélekkel.“ ");
INSERT INTO hun_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","És azonnal mintha pikkelyek estek volna le szemeiről, mindjárt visszanyerte látását; és felkelt és megkeresztelkedett, ");
INSERT INTO hun_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","majd miután evett, megerősödött. Saul pedig néhány napig együtt volt a damaszkuszi tanítványokkal, ");
INSERT INTO hun_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","és azonnal prédikálni kezdte a zsinagógákban a Krisztust, hogy ő az Isten Fia. ");
INSERT INTO hun_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Mindnyájan elálmélkodtak, akik hallották és ezt mondták: „Nem ő az, aki pusztította Jeruzsálemben azokat, akik ezt a nevet hívják segítségül, és ide is azért jött, hogy őket elfogja, és a főpapokhoz vigye őket?“ ");
INSERT INTO hun_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Saul pedig annál inkább bátrabb lett, és zavarba hozta a Damaszkuszban lakó zsidókat, bebizonyítva nekik, hogy Jézus a Krisztus. ");
INSERT INTO hun_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Több nap elteltével azonban a zsidók tanácsot tartottak, hogy megöljék őt. ");
INSERT INTO hun_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Saulnak azonban tudomására jutott leselkedésük. Még a kapukat is őrizték nappal és éjjel, hogy megöljék őt. ");
INSERT INTO hun_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","A tanítványok pedig őt éjjel a kőfalon lebocsátották, leeresztve egy kosárban. ");
INSERT INTO hun_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Mikor pedig Saul Jeruzsálembe ment, próbált a tanítványokhoz csatlakozni, de mindnyájan féltek tőle, mert nem hitték, hogy tanítvány. ");
INSERT INTO hun_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Barnabás azonban maga mellé vette őt, elvitte az apostolokhoz, és elbeszélte nekik, amint látta az úton az Urat, és hogy beszélt vele, és mint tanított Damaszkuszban nagy bátorsággal a Jézus nevében. ");
INSERT INTO hun_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ki és bejáratos lett köztük Jeruzsálemben, és nagy bátorsággal tanított az Úr Jézusnak nevében, ");
INSERT INTO hun_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","beszélt, sőt vitatkozott a görög zsidókkal, azok pedig igyekeztek megölni őt. ");
INSERT INTO hun_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Amikor ezt azonban megtudták az atyafiak, levitték őt Cézáreába, és elküldték Tarzuszba. ");
INSERT INTO hun_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Az egyháznak tehát egész Júdeában, Galileában és Samáriában békessége volt, épültek és sokasodtak az Úrnak félelmében, és a Szentlélek vigasztalásában jártak. ");
INSERT INTO hun_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Történt pedig, hogy Péter, amikor mindnyájukat körbejárta, lement a Liddában lakó szentekhez is. ");
INSERT INTO hun_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Talált ott egy Éneász nevű embert, aki nyolc esztendeje ágyban feküdt, gutaütött volt. ");
INSERT INTO hun_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","És mondta néki Péter: „Éneász, gyógyítson meg téged a Jézus Krisztus: kelj föl, magad vesd be az ágyadat!“ És azonnal felkelt. ");
INSERT INTO hun_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","És látták őt mindnyájan, akik Liddában és Sáronban laktak, és megtértek az Úrhoz. ");
INSERT INTO hun_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Joppéban pedig volt egy nőtanítvány, név szerint Tábita, amely megmagyarázva Dorkász, azaz zerge: gazdag volt jó cselekedetekben és alamizsnákban, melyeket osztogatott. ");
INSERT INTO hun_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Történt pedig azokban a napokban, hogy megbetegedett, és meghalt. Miután megmosták, kiterítették a felső házban. ");
INSERT INTO hun_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Mivel pedig Lidda Joppéhoz közel volt, a tanítványok meghallották, hogy Péter ott van, két férfiút küldtek hozzá, s kérték, hogy késedelem nélkül menjen át hozzájuk. ");
INSERT INTO hun_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Péter felkelt, és elment azokkal. Mihelyt oda ért, felvezették a felső házba, az özvegyasszonyok mind elébe álltak, sírtak és mutogatták a ruhákat és öltözeteket, amelyeket Dorkász csinált, míg velük együtt volt. ");
INSERT INTO hun_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Péter pedig mindenkit kiküldött, térdre esve imádkozott; azután a holttesthez fordulva mondta: „Tábita, kelj fel!“ Ő pedig felnyitotta szemeit, és meglátva Pétert, felült. ");
INSERT INTO hun_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ő kezét nyújtva neki felemelte őt; majd beszólította a szenteket és az özvegyasszonyokat, eléjük állította őt elevenen. ");
INSERT INTO hun_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","És megtudták egész Joppéban, és sokan hittek az Úrban. ");
INSERT INTO hun_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Ő pedig több napig Joppéban maradt egy Simon nevű tímárnál. ");
INSERT INTO hun_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Volt pedig Cézáreában egy Kornéliusz nevű férfi, százados, az úgynevezett itáliai seregből. ");
INSERT INTO hun_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Jámbor és istenfélő volt egész házanépével együtt, sok alamizsnát osztogatott a népnek, és szüntelen könyörgött Istenhez. ");
INSERT INTO hun_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Látomásban világosan látta, a napnak kilencedik órája körül, hogy az Istennek angyala bement hozzá, és ezt mondta néki: „Kornéliusz!“ ");
INSERT INTO hun_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Ő pedig szemeit reá függesztette, és megrémülve mondta: „Mi az, Uram?“ Ő pedig ezt mondta neki: „Könyörgéseid és alamizsnáid felmentek Isten elé, és ő emlékszik rájuk. ");
INSERT INTO hun_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Most azért küldj Joppéba embereket, és hivasd magadhoz Simont, akit Péternek neveznek. ");
INSERT INTO hun_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ő egy Simon nevű tímárnál van megszállva, akinek háza a tenger mellett van. Ő megmondja neked, mit kell cselekedned.“ ");
INSERT INTO hun_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Amint pedig elment az angyal, aki Kornéliusszal beszélt, szólított a szolgái közül kettőt, és egy kegyes vitézt azok közül, akik rendelkezésére álltak. ");
INSERT INTO hun_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Elmondott nekik mindent, és elküldte őket Joppéba. ");
INSERT INTO hun_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Másnap pedig, miközben ők az úton mentek, és a városhoz közeledtek, felment Péter a háznak felső részére imádkozni hat óra tájban. ");
INSERT INTO hun_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Azonban megéhezett, és enni akart. Amíg pedig azok ételt készítettek, elragadtatás szállt reá, ");
INSERT INTO hun_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","és látta, hogy az ég megnyílt, és leszállt hozzá valami edény, mint egy nagy lepedő, négy sarkánál fogva felkötve és leeresztve a földre. ");
INSERT INTO hun_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Mindenféle földi négylábú állat volt benne, vadak, csúszómászó állatok és égi madarak. ");
INSERT INTO hun_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","És szózat szólt hozzá: „Kelj fel Péter, öld és egyél!“ ");
INSERT INTO hun_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Péter pedig ezt mondta: „Semmiképpen sem, Uram, mert sohasem ettem semmi közönségest, vagy tisztátalant.“ ");
INSERT INTO hun_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ismét szózat szólt hozzá, másodszor is: „Amiket az Isten megtisztított, te ne mondd tisztátalanoknak.“ ");
INSERT INTO hun_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ez pedig három ízben történt, és ismét felvitetett az edény az égbe. ");
INSERT INTO hun_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Amint pedig Péter magában tűnődött, hogy mi lehet az a látomás, amelyet látott, íme, azok a férfiak, akiket Kornéliusz küldött, kérdezősködtek Simon háza után, odaérkeztek a kapuhoz, ");
INSERT INTO hun_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","bekiáltottak, és megkérdezték, vajon Simon, akit Péternek neveznek, ott van-e szálláson? ");
INSERT INTO hun_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","És amíg Péter a látomás felől gondolkodott, ezt mondta neki a Lélek: „Íme három férfiú keres téged: ");
INSERT INTO hun_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","nosza kelj fel, eredj le, és minden kételkedés nélkül menj el velük, mert én küldtem őket.“ ");
INSERT INTO hun_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Lement tehát Péter a férfiakhoz, akiket Kornéliusz küldött hozzá, és ezt mondta: „Íme, én vagyok, akit kerestek. Mi az, amiért jöttetek?“ ");
INSERT INTO hun_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ők pedig ezt mondták: „Kornéliusz századost, aki igaz és istenfélő férfiú, aki mellett a zsidók egész népe jó bizonyságot tesz, szent angyal megintette, hogy hívasson téged házához, és halljon tőled bizonyos dolgokról.“ ");
INSERT INTO hun_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Erre behívta őket, és szállására fogadta. Másnap pedig elment Péter velük, és a joppébeli testvérek közül is néhányan elmentek vele együtt. ");
INSERT INTO hun_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Másnap eljutottak Cézáreába. Kornéliusz pedig várta őket, összegyűjtötte rokonait és jó barátait. ");
INSERT INTO hun_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Amint Péter bement, Kornéliusz elébe ment, lábaihoz borult, és imádni akarta. ");
INSERT INTO hun_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Péter azonban felemelte, s ezt mondta: „Kelj fel, én magam is ember vagyok!“ ");
INSERT INTO hun_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","És beszélgetve, bement vele, és sokakat talált ott összegyűlve. ");
INSERT INTO hun_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","És ezt mondta nekik: „Ti tudjátok, hogy tilos zsidó embernek más nemzetbelivel barátkozni, vagy hozzámenni. De nékem az Isten megmutatta, hogy senkit se mondjak közönséges, vagy tisztátalan embernek. ");
INSERT INTO hun_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ezért ellenkezés nélkül el is jöttem, miután meghívtak. Azt kérdezem tehát, mi okból hivattatok engem?“ ");
INSERT INTO hun_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kornéliusz ekkor ezt mondta: „Négy napja ebben az órában, kilenc órakor böjtöltem, és imádkoztam a házamban, és íme, egy férfiú állt meg előttem fényes ruhában, ");
INSERT INTO hun_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","és ezt mondta: Kornéliusz, a te imádságod meghallgatásra talált, és a te alamizsnáidra emlékezett az Isten. ");
INSERT INTO hun_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Küldj el azért Joppéba, és hívasd magadhoz Simont, akit Péternek neveznek. Ő Simon tímár házában van szálláson a tenger mellett, s miután eljön, szólni fog neked. ");
INSERT INTO hun_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ezért azonnal elküldtem hozzád, és te jól tetted, hogy eljöttél. Most azért mi mindnyájan az Isten előtt állunk, hogy meghallgassuk mindazokat, amiket Isten neked parancsolt.“ ");
INSERT INTO hun_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Péter pedig megnyitotta száját, és ezt mondta: „Bizony látom, hogy nem személyválogató az Isten, ");
INSERT INTO hun_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","hanem minden nemzetben kedves előtte, aki őt féli, és igazságot cselekszik. ");
INSERT INTO hun_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ezt az igét, küldte Izrael fiainak, békességet hirdetve a Jézus Krisztus által. Ő a mindenség Ura! ");
INSERT INTO hun_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Ti ismeritek azt a dolgot, mely az egész Júdeában történt, Galileától kezdve, azután a keresztség után, melyet János prédikált, ");
INSERT INTO hun_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","a Názáreti Jézust, hogyan kente fel őt az Isten Szentlélekkel és hatalommal, aki szertejárt jót téve, és meggyógyítva mindenkit, akik az ördög hatalma alatt voltak, mert az Isten volt ő vele. ");
INSERT INTO hun_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","És mi vagyunk bizonyságai mindazoknak, amiket mind a zsidók tartományában, mind Jeruzsálemben cselekedett. Őt azonban megölték, keresztfára feszítve, ");
INSERT INTO hun_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","de az Isten feltámasztotta harmadnapon, és megadta neki, hogy nyilvánosan megjelenjen; ");
INSERT INTO hun_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","de nem az egész népnek, hanem az Istentől eleve választott tanúknak: nekünk, akik együtt ettünk, és együtt ittunk vele, miután feltámadott halottaiból. ");
INSERT INTO hun_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","És megparancsolta nekünk, hogy hirdessük a népnek, és tegyünk bizonyságot, hogy ő az Istentől rendelt bírája élőknek és holtaknak. ");
INSERT INTO hun_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Róla tesznek bizonyságot a próféták mind, hogy az ő neve által bűneinek bocsánatát veszi mindenki, aki hisz ő benne.“ ");
INSERT INTO hun_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Mikor még ezeket az igéket mondta Péter, leszállt a Szentlélek mindazokra, akik hallgatták e beszédet. ");
INSERT INTO hun_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Elálmélkodtak a zsidóságból való hívek, mindazok, akik Péterrel együtt mentek, hogy a pogányokra is kitöltetett a Szentlélek ajándéka. ");
INSERT INTO hun_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Mert hallották, hogy ők nyelveken szólnak, és magasztalják az Istent. Akkor ezt mondta Péter: ");
INSERT INTO hun_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","„Vajon megtagadhatja-e valaki a vizet ezektől, hogy megkeresztelkedjenek, akik ugyanúgy vették a Szentlelket, mint mi is?“ ");
INSERT INTO hun_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","És megparancsolta, hogy keresztelkedjenek meg az Úrnak nevében. Akkor kérték őt, hogy maradjon náluk néhány napig. ");
INSERT INTO hun_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Meghallották azonban az apostolok és a Júdeában élő atyafiak, hogy a pogányok is elfogadták az Istennek beszédét. ");
INSERT INTO hun_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Amikor azért felment Péter Jeruzsálembe, vitatkoztak vele a zsidóságból valók, ezt mondva: ");
INSERT INTO hun_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","„Körülmetéletlen emberekhez mentél be, és együtt ettél velük.“ ");
INSERT INTO hun_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Péter ekkor elkezdte megmagyarázni nekik: ");
INSERT INTO hun_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","„Én Joppé városában imádkoztam, és elragadtatásban egy látomást láttam, valami leszálló edényt, mint egy nagy lepedőt, négy sarkánál fogva leeresztve az égből, és egészen énhozzám szállt. ");
INSERT INTO hun_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Szememet rávetve megnéztem, és láttam a földi négylábú állatokat, a vadakat, a csúszómászókat és az égi madarakat. ");
INSERT INTO hun_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Hangot is hallottam, amely ezt mondta nekem: Kelj fel Péter, öld és egyél! ");
INSERT INTO hun_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Azonban én ezt mondtam: Semmiképpen sem, Uram, mert soha semmi közönséges vagy tisztátalan nem ment be az én számba. ");
INSERT INTO hun_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","A szózat pedig másodszor is felelt nekem az égből: Amiket az Isten megtisztított, te ne mondd tisztátalanoknak. ");
INSERT INTO hun_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ez pedig három ízben történt, és ismét felemelkedett az egész az égbe. ");
INSERT INTO hun_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","És íme, azonnal három férfiú érkezett a házhoz, amelyben voltam, akiket Cézáreából küldtek énhozzám. ");
INSERT INTO hun_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","A Lélek pedig azt mondta nekem, hogy menjek el velük minden kételkedés nélkül. Eljött azonban velem ez a hat atyafi is, és bementünk annak az embernek a házába. ");
INSERT INTO hun_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","És ő elbeszélte nekünk, hogyan látta, amint az angyal megállt az ő házában, és ezt mondta neki: Küldj embereket Joppéba, és hívasd magadhoz Simont, akit Péternek neveznek. ");
INSERT INTO hun_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ő olyan igéket fog hirdetni neked, melyek által megtartatsz mind te, és mind az egész házad népe. ");
INSERT INTO hun_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Mikor pedig elkezdtem beszélni, leszállt a Szentlélek rájuk, miképpen reánk is kezdetben. ");
INSERT INTO hun_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Eszembe jutott akkor az Úrnak mondása, amint mondta: János ugyan vízzel keresztelt, ti azonban Szentlélekkel fogtok megkereszteltetni. ");
INSERT INTO hun_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Ha tehát az Isten hasonló ajándékát adta nekik is, mint nekünk is, akik hittünk az Úr Jézus Krisztusban, kicsoda voltam én, hogy az Istent eltilthattam volna?“ ");
INSERT INTO hun_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Mindezek hallatára aztán megnyugodtak, és dicsőítették az Istent ezt mondva: „Eszerint hát a pogányoknak is adott az Isten megtérést az életre!“ ");
INSERT INTO hun_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Azok tehát, akik szétszóródtak az üldözés miatt, amely István miatt támadott, eljutottak Föníciáig, Ciprusig és Antiókhiáig, senkinek nem prédikálták az igét, hanem csak a zsidóknak. ");
INSERT INTO hun_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Volt azonban közöttük néhány ciprusi és cirénei férfi, akik amikor Antiókhiába bementek, szóltak a görögöknek, hirdetve az Úr Jézust. ");
INSERT INTO hun_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","És az Úr keze volt velük, úgyhogy nagy sokaság tért meg az Úrhoz, s hívőkké lettek. ");
INSERT INTO hun_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Eljutott ennek a híre a jeruzsálemi gyülekezet fülébe, ezért kiküldték Barnabást, hogy menjen el egészen Antiókhiáig. ");
INSERT INTO hun_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Amikor oda jutott, és látta az Isten kegyelmét, örvendezett, és arra intette mindnyájukat, hogy állhatatos szívvel maradjanak meg az Úrban. ");
INSERT INTO hun_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Mert jámbor, Szentlélekkel és hittel teljes férfiú volt ő. És nagy sokaság csatlakozott az Úrhoz. ");
INSERT INTO hun_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Elment azután Barnabás Tarzuszba, hogy felkeresse Sault, és amikor rátalált elvitte őt Antiókhiába. ");
INSERT INTO hun_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Így történt, hogy egy egész esztendeig forgolódtak a gyülekezetben, és tanítottak nagy sokaságot. A tanítványokat először Antiókhiában nevezték keresztyéneknek. ");
INSERT INTO hun_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ez időtájt pedig próféták mentek Jeruzsálemből Antiókhiába. ");
INSERT INTO hun_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Felkelt pedig egy közülük, név szerint Agabosz, megjelentette a Lélek által, hogy az egész földkerekségen nagy éhínség lesz; amely be is következett Klaudiusz császár idejében. ");
INSERT INTO hun_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","A tanítványok pedig elhatározták, hogy aszerint, amint kinek-kinek közülük módjában áll, küldenek valami segítséget a Júdeában lakó testvéreknek. ");
INSERT INTO hun_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ezt meg is tették, és Barnabással és Saullal elküldték a vénekhez. ");
INSERT INTO hun_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Abban az időben pedig Heródes király kegyetlenkedni kezdett némelyekkel, a gyülekezetből valók közül. ");
INSERT INTO hun_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Fegyverrel ölette meg Jakabot, Jánosnak testvérét. ");
INSERT INTO hun_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Amikor látta, hogy ez tetszik a zsidóknak, elhatározta magában, hogy elfogatja Pétert is. (Akkor pedig a kovásztalan kenyerek napjai voltak.) ");
INSERT INTO hun_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","El is fogatta, tömlöcbe vettette, átadta négy négyes katonai szakasznak, hogy őrizzék, mert húsvét után akarta a nép elé vezettetni. ");
INSERT INTO hun_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Pétert tehát a börtönben őrizték, a gyülekezet pedig szüntelen könyörgött az Istennek ő érte. ");
INSERT INTO hun_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Amikor pedig Heródes elő akarta vezettetni, azon az éjszakán Péter két vitéz között aludt, megkötözve két lánccal, és őrök őrizték az ajtó előtt a tömlöcöt. ");
INSERT INTO hun_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","És íme, az Úrnak angyala eljött, és világosság fénylett a tömlöcben: meglökte Péter oldalát, felkeltette őt, és ezt mondta: „Kelj föl hamar!“ És leestek a láncok a kezeiről. ");
INSERT INTO hun_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ezt mondta neki az angyal: „Övezd fel magadat, és kösd fel saruidat.“ És úgy cselekedett. Azután pedig ezt mondta neki: „Vedd fel felsőruhádat, és kövess engem!“ ");
INSERT INTO hun_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Ekkor kiment, és követte őt, de nem tudta, hogy valóság-e az, ami történik az angyallal, hanem azt hitte, hogy látomása van. ");
INSERT INTO hun_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Amikor pedig átmentek az első őrsön és a másodikon, a vaskapuhoz jutottak, amely a városba visz, az magától megnyílt előttük. Kimentek rajta, és egy utcán előrementek, és az angyal hirtelen eltávozott tőle. ");
INSERT INTO hun_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Péter pedig magához térve ezt mondta: „Most tudom igazán, hogy az Úr elküldte az ő angyalát, és megszabadított engem Heródes kezéből, és attól, amit az egész zsidó népnek várt.“ ");
INSERT INTO hun_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Miután ezt megértette, elment Máriának, János, más néven Márk anyjának házához, ahol sokan voltak összegyűlve, és imádkoztak. ");
INSERT INTO hun_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Mikor Péter zörgetett a tornác ajtaján, egy Rodé nevű szolgálóleány ment oda, hogy hallgatózzék. ");
INSERT INTO hun_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Megismerte Péter hangját, és örömében nem nyitotta ki a kaput, hanem befutott, és hírül adta, hogy Péter áll a kapu előtt. ");
INSERT INTO hun_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Azok pedig azt mondták neki: „Elment az eszed.“ Ő azonban erősítgette, hogy úgy van. Azok pedig azt mondták: „Az ő angyala az.“ ");
INSERT INTO hun_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Péter pedig szüntelen zörgetett. Amikor aztán kinyitották, meglátták őt, és elálmélkodtak. ");
INSERT INTO hun_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Miután pedig kezével intett nekik, hogy hallgassanak, elbeszélte nekik, hogyan hozta ki őt az Úr a tömlöcből. És ezt mondta: „Adjátok tudtára ezeket Jakabnak és az atyafiaknak.“ És kiment, és elment egy más helyre. ");
INSERT INTO hun_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Amikor megvirradt, nem csekély háborúság támadt a vitézek között, hogy mi történt Péterrel. ");
INSERT INTO hun_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Heródes pedig mikor előhívatta őt, és nem találta, kivallatta az őröket, és megparancsolta, hogy végezzék ki őket. Azután lement Júdeából Cézáreába, és ott időzött. ");
INSERT INTO hun_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Heródes pedig ellenséges indulattal volt a tírusziak és szidóniak iránt. De azok egy akarattal eljöttek hozzá, és Blásztuszt, a király kamarását megnyerték, és békességet kértek, mivel az ő tartományukat a királyéból élelmezték. ");
INSERT INTO hun_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Egy kitűzött napon pedig Heródes királyi ruhájába felöltözött, és székében ülve nyilvánosan szólt hozzájuk. ");
INSERT INTO hun_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","A nép pedig felkiáltott: „Isten szava ez és nem emberé.“ ");
INSERT INTO hun_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","És azonnal megverte őt az Úrnak angyala, azért, hogy nem az Istennek adta a dicsőséget. Férgek emésztették meg, és meghalt. ");
INSERT INTO hun_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Az Istennek igéje pedig növekedett és terjedt. ");
INSERT INTO hun_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Barnabás és Saul pedig betöltve szolgálatukat visszatértek Jeruzsálemből, maguk mellé vették Jánost is, akinek másik neve Márk volt. ");
INSERT INTO hun_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antiókhiában az ott levő gyülekezetben volt néhány próféta és tanító: Barnabás és Simeon, akit Nigernek hívtak, és a cirénei Lucius és Manaén, akit Heródessel, a negyedes fejedelemmel együtt neveltek, és Saul. ");
INSERT INTO hun_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Amikor pedig ők szolgáltak az Úrnak és böjtöltek, ezt mondta a Szentlélek: „Válasszátok ki nekem Barnabást és Sault arra a munkára, amelyre őket elhívtam.“ ");
INSERT INTO hun_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Akkor, miután böjtöltek és imádkoztak, kezeiket rájuk tették, és elbocsátották őket. ");
INSERT INTO hun_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Ők pedig, miután elküldte őket a Szentlélek, lementek Szeleukiába, és onnan eleveztek Ciprusba. ");
INSERT INTO hun_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Mikor Szalamiszba jutottak, hirdették az Isten igéjét a zsidók zsinagógáiban. János is velük volt, mint segítőtárs. ");
INSERT INTO hun_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Miután bejárták a szigetet egészen Páfoszig, találkoztak egy ördöngös hamispróféta zsidóval, akinek neve Barjézus volt, ");
INSERT INTO hun_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","aki együtt volt Szergiusz Paulusz tiszttartóval, ezzel az okos emberrel. Magához hívatta Barnabást és Sault, és hallani akarta az Isten igéjét. ");
INSERT INTO hun_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Elimás, az ördöngös (mert az ő neve ugyanis ezt jelenti) azonban ellenkezett velük, igyekezve a tiszttartót elfordítani a hittől. ");
INSERT INTO hun_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","De Saul, aki Pál is, megtelve Szentlélekkel, szemeit reá vetette, ");
INSERT INTO hun_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","és ezt mondta: „Ó minden álnoksággal és minden gonoszsággal teljes ördögfajzat, minden igazságnak ellensége, nem szűnsz meg az Úrnak igaz útjait elferdíteni? ");
INSERT INTO hun_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Most azért íme, az Úrnak keze van rajtad, és vak leszel, és nem látod a napot egy ideig!“ És azonnal homály és sötétség szállt reá, és botorkálva keresett vezetőket magának. ");
INSERT INTO hun_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","A tiszttartó, amikor látta, hogy mi történt, elálmélkodott az Úrnak tudományán, és hitt. ");
INSERT INTO hun_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pál és kísérői elhajóztak Páfoszból, Pergébe, és Pamfiliának városába mentek. János azonban elvált tőlük, és visszatért Jeruzsálembe. ");
INSERT INTO hun_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Ők Pergéből tovább mentek, és eljutottak Antiókhiába, Pizidiának városába, és bementek szombatnapon a zsinagógába és leültek. ");
INSERT INTO hun_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","A törvény és a próféták felolvasása után a zsinagóga elöljárói odaküldtek hozzájuk, és ezt mondták: „Atyánkfiai, férfiak, ha van valami intő beszédetek a néphez, szóljatok.“ ");
INSERT INTO hun_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Pál akkor felkelt, kezével intett, és ezt mondta: „Izrael férfiai és ti, akik félitek az Istent, halljátok meg! ");
INSERT INTO hun_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Ennek a népnek, Izraelnek Istene kiválasztotta a mi atyáinkat, és e népet fölemelte, amikor Egyiptom földjén jövevények voltak, és onnan kihozta őket hatalmas karja által. ");
INSERT INTO hun_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Azután közel negyven esztendeig tűrte az ő erkölcsüket a pusztában. ");
INSERT INTO hun_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","És miután eltörölt hét népet a Kánaán földjén, azoknak földjét sorsvetéssel elosztotta közöttük. ");
INSERT INTO hun_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Azután mintegy négyszázötven esztendeig adott bírákat egészen Sámuel prófétáig. ");
INSERT INTO hun_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Azután pedig királyt kértek maguknak, és az Isten Sault adta nekik, a Kis fiát, a Benjámin nemzetségéből való férfiút negyven esztendeig. ");
INSERT INTO hun_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","És amikor őt elvetette, Dávidot emelte nekik királyul; akiről bizonyságot is tett, és ezt mondta: »Szívem szerint való férfiút találtam, Dávidot, Isai fiát, aki minden akaratomat véghez viszi.« ");
INSERT INTO hun_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Az ő utódából támasztott Isten, ígérete szerint, Izraelnek szabadítót, Jézust, ");
INSERT INTO hun_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","miután János az ő eljövetele előtt a megtérésnek keresztségét prédikálta Izrael egész népének. ");
INSERT INTO hun_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Amikor pedig be akarta fejezni János az ő tisztét, ezt mondta: Akinek ti gondoltok engem, nem az vagyok, hanem íme, utánam jön, akinek nem vagyok méltó megoldani lábainak saruját sem. ");
INSERT INTO hun_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Atyámfiai, férfiak, Ábrahám nemzetének fiai, és akik köztetek félik az Istent, az üdvösségnek ez az igéje nektek küldetett. ");
INSERT INTO hun_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","De akik Jeruzsálemben laknak, és azoknak vezetői, nem ismerték fel őt, és a prófétáknak szavait, melyeket minden szombaton felolvasnak, ítéletükkel betöltötték. ");
INSERT INTO hun_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","És bár semmi halálra való okot nem találtak, kérték Pilátustól, hogy ölesse meg. ");
INSERT INTO hun_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Amikor mindazokat elvégezték, ami róla meg van írva, a fáról levéve sírba helyezték. ");
INSERT INTO hun_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","De az Isten feltámasztotta őt halottaiból, ");
INSERT INTO hun_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","és megjelent több napon át azoknak, akik együtt jöttek fel vele Galileából Jeruzsálembe, akik az ő tanúi a nép előtt. ");
INSERT INTO hun_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Mi is hirdetjük nektek az atyáknak tett ígéretet, hogy azt az Isten betöltötte nekünk, az ő fiainak feltámasztotta Jézust. ");
INSERT INTO hun_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Amint a második zsoltárban is meg van írva: »Fiam vagy te, ma nemzettelek téged.« ");
INSERT INTO hun_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Azt pedig, hogy feltámasztotta őt halottaiból, úgy hogy nem is fog többé az enyészetbe visszatérni, így mondta: »Nektek váltom be a Dávidnak szóló biztos, szent ígéreteket.« ");
INSERT INTO hun_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Azért mondja másutt is: »Nem engeded, hogy a te Szentedet rothadás érje.« ");
INSERT INTO hun_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Mert Dávid, miután a saját idejében szolgált az Isten akaratának, meghalt, és eltemették az ő atyái mellé, és utolérte a rothadás. ");
INSERT INTO hun_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","De akit Isten feltámasztott, azt nem érte rothadás. ");
INSERT INTO hun_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Tudjátok meg hát, atyámfiai, férfiak, hogy őáltala hirdetjük nektek a bűnök bocsánatát, ");
INSERT INTO hun_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","és mindazokból, amikből a Mózes törvénye által nem nyerhettek megigazulást, őáltala mindenki megigazul, aki hisz. ");
INSERT INTO hun_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Vigyázzatok tehát, hogy rajtatok ne teljesedjen be, amit a próféták megmondtak: ");
INSERT INTO hun_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","»Lássátok meg, ti megvetők, és csodálkozzatok, és semmisüljetek meg, mert én olyan dolgot cselekszem napjaitokban, olyan dolgot, amelyet nem hinnétek, ha valaki elmondaná nektek.«“ ");
INSERT INTO hun_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Amikor pedig mentek ki a zsinagógából, kérték a pogányok, hogy a következő szombaton is prédikálják nekik ezeket a beszédeket. ");
INSERT INTO hun_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Amikor pedig szétoszlott a gyülekezet, sokan a zsidók közül, és az istenfélő prozeliták közül követték Pált és Barnabást, akik beszéltek velük, és biztatták őket, hogy maradjanak meg az Isten kegyelmében. ");
INSERT INTO hun_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","A következő szombaton aztán majdnem az egész város összegyűlt az Isten igéjének hallgatására. ");
INSERT INTO hun_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Amikor pedig látták a zsidók a sokaságot, elteltek irigységgel, és ellenkezve és káromlást szólva ellene mondtak azoknak, amiket Pál mondott. ");
INSERT INTO hun_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Akkor Pál és Barnabás nagy bátorsággal ezt mondták: „Először nektek kellett hirdetnünk az Isten igéjét, de mivel ti megvetitek azt, és nem tartjátok méltóknak magatokat az örök életre, íme, a pogányokhoz fordulunk. ");
INSERT INTO hun_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Mert így parancsolta nekünk az Úr: »Pogányok világosságául rendeltelek téged, hogy üdvösségükre légy a földnek széléig.«“ ");
INSERT INTO hun_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","A pogányok pedig mikor ezeket hallották, örvendeztek és magasztalták az Úr igéjét, és mindazok, akik örök életre választattak, hittek. ");
INSERT INTO hun_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Az Úrnak igéje pedig elterjedt az egész tartományban. ");
INSERT INTO hun_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","A zsidók azonban felbujtották az istenfélő és tisztességes asszonyokat, a városnak vezetőit, és üldözést szítottak Pál és Barnabás ellen, és kiűzték őket határukból. ");
INSERT INTO hun_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Azok pedig lábuknak porát lerázva ellenük, elmentek Ikóniumba. ");
INSERT INTO hun_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","A tanítványok pedig beteltek örömmel és Szentlélekkel. ");
INSERT INTO hun_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Történt pedig Ikóniumban, hogy együtt mentek be a zsidók zsinagógájába, és úgy prédikáltak, hogy mind a zsidókból, mind a görögökből is nagyon sokan lettek hívővé. ");
INSERT INTO hun_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Akik azonban a zsidók közül nem hittek, felingerelték, és megharagították a pogányok lelkét az atyafiak ellen. ");
INSERT INTO hun_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Mégis sok időt töltöttek ott, bátran prédikálva az Úrban, aki bizonyságot tett az ő kegyelmének beszéde mellett, és megadta, hogy jelek és csodák történjenek a kezeik által. ");
INSERT INTO hun_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","De a város sokasága meghasonlott, és némelyek a zsidók mellett, mások pedig az apostolok mellett voltak. ");
INSERT INTO hun_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Akkor a pogányok és zsidók a főembereikkel együtt támadást indítottak, hogy bosszút álljanak, és megkövezzék őket. ");
INSERT INTO hun_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Ők ezt megtudták, és elmenekültek Likaóniának városaiba, Lisztrába, Derbébe és a körülötte lévő tartományba, ");
INSERT INTO hun_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","és ott hirdették az evangéliumot. ");
INSERT INTO hun_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Lisztrában élt egy béna lábú ember, aki születésétől fogva sánta volt, és soha nem tudott járni. ");
INSERT INTO hun_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Ő hallotta Pált beszélni, aki rátekintett, és látta, hogy van hite, hogy meggyógyuljon, ");
INSERT INTO hun_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","és hangosan ezt mondta neki: „Állj fel lábaidra egyenesen!“ És az felszökött, és járt. ");
INSERT INTO hun_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","A sokaság pedig, amikor látta, amit Pál cselekedett, így kiáltott likaóniai nyelven: „Az istenek jöttek le hozzánk ember képében!“ ");
INSERT INTO hun_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Barnabást Jupiternek, Pált pedig Merkúriusnak mondták, mert ő volt a szóvivő. ");
INSERT INTO hun_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Jupiter papja pedig, akinek az ő városuk előtt volt temploma, felkoszorúzott bikákat hajtott a kapukhoz, és a sokasággal együtt áldozatot akart bemutatni. ");
INSERT INTO hun_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Amikor azonban ezt meghallották az apostolok, Barnabás és Pál, köntösüket megszaggatták, a sokaság közé futottak és ezt kiáltották: ");
INSERT INTO hun_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","„Férfiak, miért művelitek ezeket? Mi is hozzátok hasonló természetű emberek vagyunk, és azt az örvendetes üzenetet hirdetjük nektek, hogy ezektől a hiábavaló dolgoktól az élő Istenhez térjetek, aki teremtette a mennyet, a földet, a tengert, és mindent, ami azokban van. ");
INSERT INTO hun_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Ő az elmúlt időkben hagyta, hogy a pogányok mind a maguk útján haladjanak, ");
INSERT INTO hun_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","bár nem hagyta magát tanúbizonyság nélkül, mert jótevőnk volt, a mennyből esőt és termő időt adott nekünk, és betöltötte eledellel és örömmel a szívünket.“ ");
INSERT INTO hun_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Ezeket mondva, nagy nehezen lecsendesítették a sokaságot, hogy nekik ne áldozzanak. ");
INSERT INTO hun_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Azonban Antiókhiából és Ikóniumból zsidók jöttek oda, és a sokaságot úgy fellázították, hogy megkövezték Pált, kivonszolták a városból, és azt gondolták, hogy meghalt. ");
INSERT INTO hun_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","De amikor a tanítványok körülvették őt, felkelt, bement a városba, és másnap Barnabással elment Derbébe. ");
INSERT INTO hun_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Miután annak a városnak hirdették az evangéliumot, sokakat tanítvánnyá tettek, visszatértek Lisztrába, Ikóniumba és Antiókhiába. ");
INSERT INTO hun_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Erősítették a tanítványok lelkét, intve őket, hogy maradjanak meg a hitben, mivel sok háborúságon keresztül kell nekünk az Isten országába bemennünk. ");
INSERT INTO hun_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Miután pedig gyülekezetenként elöljárókat választottak nekik, imádkozva és böjtölve az Úrnak ajánlották őket, akiben hittek. ");
INSERT INTO hun_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","És Pizidián átmenve elmentek Pamfiliába, ");
INSERT INTO hun_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","majd miután Pergében hirdették az igét, lementek Attáliába. ");
INSERT INTO hun_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Onnan elhajóztak Antiókhiába, ahonnan az Isten kegyelmére bízták őket, arra a munkára, melyet el is végeztek. ");
INSERT INTO hun_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Amikor pedig megérkeztek, és a gyülekezetet egybehívták, elbeszélték milyen nagy dolgokat cselekedett az Isten ő velük, és hogy a pogányoknak kaput nyitott a hitre. ");
INSERT INTO hun_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Ott aztán nem kevés időt töltöttek a tanítványokkal. ");
INSERT INTO hun_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Némelyek pedig, akik Júdeából jöttek le, így tanították az atyafiakat: „Ha körül nem metélkedtek Mózes rendelése szerint, nem üdvözülhettek.“ ");
INSERT INTO hun_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Amikor pedig Pálnak és Barnabásnak nagy viszálya és vitája lett velük, azt határozták el, hogy Pál és Barnabás, és néhányan mások közülük, menjenek fel az apostolokhoz és a vénekhez Jeruzsálembe, e kérdés ügyében. ");
INSERT INTO hun_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Kikísérte tehát őket a gyülekezet, és átmentek Fönícián és Samárián, elmondták a pogányok megtérését, és nagy örömet szereztek az összes atyafiaknak. ");
INSERT INTO hun_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Amikor pedig megérkeztek Jeruzsálembe, a gyülekezet, az apostolok és a vének fogadták őket, és ők elbeszélték, milyen nagy dolgokat cselekedett az Isten velük. ");
INSERT INTO hun_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Előállt azonban néhány hivő, akik a farizeusok szerzetéből valók voltak, és azt mondták, hogy körül kell metélni őket, és meg kell parancsolni, hogy Mózes törvényét megtartsák. ");
INSERT INTO hun_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Az apostolok és a vének ezért egybegyűltek, hogy e felől a dolog felöl határozzanak. ");
INSERT INTO hun_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Amikor nagy vita támadt, felkelt Péter, és ezt mondta nekik: „Atyámfiai, férfiak, ti tudjátok, hogy az Isten régóta kiválasztott engem közülünk, hogy a pogányok az én számból hallják az evangélium beszédét, és higgyenek. ");
INSERT INTO hun_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","A szíveket ismerő Isten pedig bizonyságot tett mellettük, mert Szentlelket adott nekik, amint nekünk is. ");
INSERT INTO hun_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Semmi különbséget nem tett közöttünk és ő közöttük, a hit által tisztította meg szívüket. ");
INSERT INTO hun_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Most azért mit kísértitek az Istent, hogy a tanítványok nyakába olyan igát tegyetek, amelyet sem a mi atyáink, sem mi el nem hordozhattunk? ");
INSERT INTO hun_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Sőt inkább az Úr Jézus Krisztus kegyelme által hisszük, hogy megtartatunk, miképpen ők is.“ ");
INSERT INTO hun_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Erre elhallgatott az egész sokaság, és hallgatták Barnabást és Pált, amint elbeszélték, mennyi jelt és csodát tett az Isten általuk a pogányok között. ");
INSERT INTO hun_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Miután pedig elhallgattak, Jakab ezt mondta: „Atyámfiai, férfiak, hallgassatok meg engem! ");
INSERT INTO hun_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simon elmondta, hogyan gondoskodott az Isten arról, hogy a pogányok közül vegyen népet az ő nevének. ");
INSERT INTO hun_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","És ezzel egyeznek a próféták mondásai, amint meg van írva: ");
INSERT INTO hun_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","»Ezek után megtérek és felépítem Dávidnak leomlott sátrát; Omladékait helyreállítom, és ismét felépítem, ");
INSERT INTO hun_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","hogy megkeresse az emberek többi része az Urat, és a pogányok mindnyájan, akik az én nevemről neveztetnek. Ezt mondja az Úr, ki mindezeket megcselekszi. ");
INSERT INTO hun_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Tudja az Isten öröktől fogva minden cselekedetét.« ");
INSERT INTO hun_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Ezért én azt mondom, hogy nem kell háborgatni azokat, akik a pogányok közül térnek meg az Istenhez. ");
INSERT INTO hun_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Hanem írjuk meg nekik azt, hogy tartózkodjanak a bálványok tisztátalanságától, a paráznaságtól, a megfojtott állattól és a vértől. ");
INSERT INTO hun_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Mert Mózesnek régi nemzedékek óta minden városban megvannak a hirdetői, hiszen a zsinagógákban minden szombaton olvassák őt.“ ");
INSERT INTO hun_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Akkor az apostoloknak és a véneknek az egész gyülekezettel együtt úgy tetszett, hogy férfiakat válasszanak ki maguk közül, és elküldjék Antiókhiába Pállal és Barnabással: Júdást, akinek mellék neve Barsabbás és Szilászt, akik az atyafiak között vezető emberek voltak. ");
INSERT INTO hun_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ezt az írást küldték velük: „Az apostolok, a vének, és az atyafiak az Antiókhiában, Szíriában és Ciliciában élő, pogányok közül való atyafiaknak üdvözletüket küldik! ");
INSERT INTO hun_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Mivel meghallottuk, hogy némelyek közülünk, akiknek mi parancsot nem adtunk erre, kimentek és megzavartak titeket beszédeikkel, feldúlták lelketeket, azt mondva, hogy metélkedjetek körül, és a törvényt tartsátok meg, ");
INSERT INTO hun_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","úgy gondoltuk, miután egyetértésre jutottunk, hogy kiválasztunk férfiakat, és elküldjük hozzátok a mi szeretteinkkel, Barnabással és Pállal, ");
INSERT INTO hun_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","olyan emberekkel, akik életüket tették kockára a mi Urunk Jézus Krisztus nevéért. ");
INSERT INTO hun_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Elküldtük azért Júdást és Szilászt, akik élőszóval szintén tudtotokra adják ugyanezeket. ");
INSERT INTO hun_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Mert tetszett a Szentléleknek és nekünk, hogy semmi több terhet ne tegyünk reátok ezeken a szükséges dolgokon kívül: ");
INSERT INTO hun_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","hogy tartózkodjatok a bálványoknak áldozott dolgoktól, a vértől, a megfojtott állattól és a paráznaságtól, amelyektől ha megóvjátok magatokat, jól dolgotok lesz. Legyetek egészségben!“ ");
INSERT INTO hun_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Ők tehát, miután elbocsátották őket, elmentek Antiókhiába, egybegyűjtötték a sokaságot, átadták a levelet. ");
INSERT INTO hun_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Amikor elolvasták, örültek az intésnek. ");
INSERT INTO hun_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Júdás és Szilász pedig mivel maguk is próféták voltak, sok beszéddel intették és erősítették az atyafiakat. ");
INSERT INTO hun_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Miután pedig egy bizonyos időt eltöltöttek ott, az atyafiak elbocsátották őket békességgel az apostolokhoz. ( ");
INSERT INTO hun_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","De Szilásznak tetszett ott maradni.) ");
INSERT INTO hun_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pál és Barnabás is Antiókhiában időztek, tanították és prédikálták a többiekkel az Úrnak igéjét. ");
INSERT INTO hun_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Néhány nap múlva pedig Pál ezt mondta Barnabásnak: „Most, hogy visszatértünk, látogassuk meg atyánkfiait minden városban, amelyben hirdettük az Úrnak igéjét, lássuk: hogy vannak.“ ");
INSERT INTO hun_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnabás azt tanácsolta, hogy vegyék maguk mellé Jánost, akit Márknak hívnak. ");
INSERT INTO hun_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Pál azonban azt tartotta méltónak, hogy aki elszakadt tőlük Pamfiliától fogva, és nem ment velük a munkára, ne vegyék maguk mellé. ");
INSERT INTO hun_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Meghasonlás támadt közöttük, úgyhogy elszakadtak egymástól, és Barnabás maga mellé vette Márkot, elhajózott Ciprusba. ");
INSERT INTO hun_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pál pedig Szilászt választotta maga mellé, és az atyafiaktól az Isten kegyelmére bízva útra kelt. ");
INSERT INTO hun_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Bejárta Szíriát és Ciliciát, és erősítette a gyülekezeteket. ");
INSERT INTO hun_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Eljutott Derbébe és Lisztrába is. És íme volt ott egy Timóteus nevű tanítvány, egy hívő zsidó asszonynak, de görög atyának fia, ");
INSERT INTO hun_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","akiről jó bizonyságot tettek a Lisztrában és Ikóniumban élő atyafiak. ");
INSERT INTO hun_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Őt Pál magával akarta vinni, és körülmetélte őt a zsidókra való tekintettel, akik azokon a helyeken voltak: mert mindnyájan ismerték atyját, hogy görög volt. ");
INSERT INTO hun_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Amint átmentek a városokon, meghagyták nekik, hogy tartsák meg azokat a rendeleteket, amelyeket a Jeruzsálemben levő apostolok és vének hoztak. ");
INSERT INTO hun_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","A gyülekezetek pedig erősödtek a hitben, és számuk naponként gyarapodott. ");
INSERT INTO hun_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Mivel a Szentlélek megtiltotta, hogy az igét Ázsiában hirdessék, körbejárták Frígiát és Galácia tartományát. ");
INSERT INTO hun_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Mízia felé mentek, és igyekeztek Bitíniába jutni, de nem eresztette őket a Lélek. ");
INSERT INTO hun_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Áthaladtak azért Mízián, lementek Tróászba. ");
INSERT INTO hun_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Azon az éjszakán látomás jelent meg Pálnak: egy macedón férfiú állt előtte, kérve őt: „Gyere át Macedóniába, és légy segítségül nekünk!“ ");
INSERT INTO hun_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Mihelyt pedig a látomást látta, azonnal igyekezett elmenni Macedóniába, megértve, hogy oda hívott minket az Úr, hogy azoknak prédikáljuk az evangéliumot. ");
INSERT INTO hun_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Elhajózva Tróászból, egyenesen Szamothrákéba mentünk, másnap meg Neápoliszba. ");
INSERT INTO hun_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Onnét pedig Filippibe, amely Macedónia azon részének első gyarmatvárosa. Ebben a városban töltöttünk néhány napot. ");
INSERT INTO hun_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Szombatnapon kimentünk a városon kívül egy folyóvíz mellé, ahol az imádkozás szokott lenni, és leülve beszélgettünk az egybegyűlt asszonyokkal. ");
INSERT INTO hun_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Egy Lídia nevű, Thiatíra városbeli bíborárus asszony, aki félte az Istent, hallgatott ránk. Az Úr megnyitotta szívét, hogy figyeljenek azokra, amiket Pál mondott. ");
INSERT INTO hun_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Amikor pedig megkeresztelkedett egész házanépével együtt, kért minket: „Ha az Úr hívének ítéltetek engem, gyertek az én házamhoz, és maradjatok ott. És unszolt minket.“ ");
INSERT INTO hun_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Történt pedig, hogy amikor a könyörgésre mentünk, egy szolgálóleányka jött elénk, akiben jövendőmondásnak lelke volt, és az ő urainak nagy hasznot hajtott jövendőmondásával. ");
INSERT INTO hun_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Követte Pált és minket, és így kiáltott: „Ezek az emberek a magasságos Istennek szolgái, akik nektek az üdvösségnek útját hirdetik.“ ");
INSERT INTO hun_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","És ezt több napon át művelte. Pál azonban megharagudott és hátrafordulva, ezt mondta a léleknek: „Parancsolom neked a Jézus Krisztus nevében, hogy menj ki belőle.“ És kiment abban az órában. ");
INSERT INTO hun_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Amikor látták urai, hogy keresetüknek a reménysége elveszett, megfogták Pált és Szilászt, a piacra vonszolták őket a hatóságok elé. ");
INSERT INTO hun_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Odavezették őket a bírákhoz és ezt mondták: „Ezek az emberek zsidó létükre megháborítják a mi városunkat. ");
INSERT INTO hun_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Olyan szertartásokat hirdetnek, amelyeket nem szabad elfogadnunk, sem cselekednünk, mivel rómaiak vagyunk.“ ");
INSERT INTO hun_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","És velük együtt támadt a sokaság ellenük. A bírák pedig letépették ruháikat, megvesszőztették őket. ");
INSERT INTO hun_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Miután sok ütést mértek rájuk, börtönbe vetették őket, megparancsolva a börtönőrnek, hogy gondosan őrizze őket. ");
INSERT INTO hun_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Ezt a parancsot megfogadva, a belső tömlöcbe vetette őket, és lábaikat kalodába szorította. ");
INSERT INTO hun_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Éjféltájban pedig Pál és Szilász imádkozott, és énekkel dicsőítették az Istent. A foglyok pedig hallgatták őket. ");
INSERT INTO hun_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Hirtelen nagy földindulás lett, annyira, hogy megrendültek a börtön alapjai, és azonnal megnyílt az összes ajtó, és mindnyájuknak lehulltak bilincsei. ");
INSERT INTO hun_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","A börtönőr pedig fölserkent, és látta, hogy nyitva vannak a börtönajtók, kivonta kardját, és meg akarta magát ölni, mert azt gondolta, hogy elszöktek a foglyok. ");
INSERT INTO hun_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Pál azonban hangosan kiáltott: „Semmi kárt ne tégy magadban, mert mindnyájan itt vagyunk!“ ");
INSERT INTO hun_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Ő pedig világosságot kérve beugrott, és remegve borult Pál és Szilász elé; ");
INSERT INTO hun_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","majd kihozta őket, ezt és mondta: „Uraim, mit kell cselekednem, hogy üdvözüljek??“ ");
INSERT INTO hun_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Azok pedig ezt mondták: „Higgy az Úr Jézus Krisztusban, és üdvözülsz mind te, mind a te házad népe!“ ");
INSERT INTO hun_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","És hirdették az Úr igéjét neki és mindazoknak, akik a házánál voltak. ");
INSERT INTO hun_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Ekkor magához vette őket az éjszakának abban az órájában, megmosta sebeiket, és azonnal megkeresztelkedett egész háza népével együtt. ");
INSERT INTO hun_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Azután bevitte őket házába, asztalt terített nekik, és egész háznépével együtt örvendezett, hogy hitt az Istennek. ");
INSERT INTO hun_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Amikor pedig megvirradt, a bírák elküldték a szolgákat ezt üzenve: „Bocsásd el azokat az embereket.“ ");
INSERT INTO hun_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","A börtönőr pedig tudtatta ezeket Pállal: „A bírák ide küldtek, hogy bocsássalak el titeket: most azért távozzatok, menjetek el békességgel!“ ");
INSERT INTO hun_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Pál pedig ezt mondta nekik: „Megvesszőztek minket nyilvánosan, ítélet nélkül, holott római emberek vagyunk, és börtönbe vetettek: és most alattomban akarnak bennünket elküldeni? Nem úgy, hanem jöjjenek ők maguk, és vezessenek ki minket.“ ");
INSERT INTO hun_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","A szolgák pedig megmondták a bíráknak ezeket a beszédeket. Azok pedig megijedtek, amikor meghallották, hogy rómaiak, ");
INSERT INTO hun_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","odamentek, megkövették és kivezették őket, kérték, hogy menjenek el a városból. ");
INSERT INTO hun_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Amint kijöttek a börtönből, bementek Lídiához. Amikor meglátták az atyafiakat, vigasztalták őket, és eltávoztak. ");
INSERT INTO hun_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Miután pedig átmentek Amfipoliszon és Apollónián, Thesszalonikába érkeztek, ahol a zsidóknak zsinagógájuk volt. ");
INSERT INTO hun_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pál pedig, amint szokása volt, bement hozzájuk, és három szombaton át vitatkozott velük az Írásokról. ");
INSERT INTO hun_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Megmagyarázta és kimutatta, hogy Krisztusnak szenvednie kellett, és fel kellett támadnia a halálból; és hogy ez a Jézus a Krisztus, akit én hirdetek nektek. ");
INSERT INTO hun_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Némelyek közülük hittek, és csatlakoztak Pálhoz és Szilászhoz, úgyszintén az istenfélő görögök közül is igen sokan, valamint az előkelő asszonyok közül is nem kevesen. ");
INSERT INTO hun_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","De a zsidók, akik nem hittek, irigységtől felindulva maguk mellé vettek a piaci népségből néhány gonosz férfit, csődületet támasztottak és felizgatták a várost. Jázon házát megostromolták, s igyekeztek őket kihozni a nép elé. ");
INSERT INTO hun_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Mikor pedig nem találták őket, Jázont és néhány atyafit a város elöljárói elé vonszoltak, azt kiáltozva, hogy ezek a felforgatók itt is megjelentek. ");
INSERT INTO hun_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Akiket pedig Jázon házába fogadott, mindnyájan a császár parancsolatai ellen cselekszenek, mivelhogy mást tartanak királynak, Jézust. ");
INSERT INTO hun_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Fel is indították a sokaságot és a város elöljáróit, akik hallották ezeket. ");
INSERT INTO hun_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","De amikor Jázon és a többiek kezességet vállaltak értük, elbocsátották őket. ");
INSERT INTO hun_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Az atyafiak pedig azonnal, azon az éjszakán elküldték Pált Szilásszal együtt Béreába. Amikor odaérkeztek, elmentek a zsidók zsinagógájába. ");
INSERT INTO hun_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Ezek pedig nemesebb lelkűek voltak a thesszalonikaiaknál, mert az igét teljes készséggel fogadták, naponként tudakozva az Írásokat, hogy úgy vannak-e. ");
INSERT INTO hun_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Sokan pedig hittek közülük, sőt az előkelő görög asszonyok és férfiak közül is nem kevesen. ");
INSERT INTO hun_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Mikor azonban tudtára jutott a Thesszalonikából való zsidóknak, hogy Béreában is prédikálta Pál az Istennek igéjét, elmentek, és a sokaságot ott is felháborították. ");
INSERT INTO hun_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","De akkor mindjárt elbocsátották az atyafiak Pált, hogy utazzon a tenger felé. Szilász és Timóteus azonban ott maradtak. ");
INSERT INTO hun_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Ők pedig elkísérték Pált, egész Athénig, és parancsát Szilászhoz és Timóteushoz vitték, hogy minél hamarább menjenek hozzá. ");
INSERT INTO hun_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Athénben pedig, amikor Pál várta őket, háborogott a lelke, látva, hogy a város bálványokkal van tele. ");
INSERT INTO hun_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Vitatkozott a zsinagógában a zsidókkal, az istenfélő emberekkel, és a piacon minden nap, azokkal, akikkel találkozott. ");
INSERT INTO hun_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Némelyek pedig az epikureus és sztoikus filozófusok közül összeakadtak vele. Néhányan azt mondták: „Mit akarhat ez a csacsogó mondani?“ Mások meg: „Idegen istenségek hirdetőjének látszik“, mivel Jézust és a feltámadást hirdette. ");
INSERT INTO hun_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Megragadták őt, az Areopágoszra vitték, s ezt mondták: „Vajon megérthetjük-e mi az az új tudomány, melyet te hirdetsz? ");
INSERT INTO hun_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Mert füleinknek idegen dolgokat mondasz: meg akarjuk érteni, miről is van szó.“ ");
INSERT INTO hun_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Az athéniek pedig és az ott lakó jövevények semmi mással nem voltak elfoglalva, mint újságok megbeszélésével és hallgatásával. ");
INSERT INTO hun_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Pál pedig kiállt az Areopágosz közepére, és ezt mondta: „Athéni férfiak, minden tekintetben nagyon istenfélőknek látlak titeket. ");
INSERT INTO hun_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Mert amikor bejártam és megszemléltem szentélyeiteket, találkoztam egy oltárral is, amelyre ez volt ráírva: Ismeretlen Istennek. Akit azért ti nem ismerve tiszteltek, azt hirdetem én nektek. ");
INSERT INTO hun_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Az Isten, aki teremtette a világot és mindazt, ami abban van, mivelhogy ő mennynek és földnek ura, nem lakik kézzel készített templomokban. ");
INSERT INTO hun_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Nem szorul emberi kéz segítségére, mintha szüksége volna valamire, mert ő ad mindenkinek életet, leheletet és mindent. ");
INSERT INTO hun_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Az egész emberi nemzetséget egy vérből teremtette, hogy a földnek egész színén lakjanak, meghatározva eleve rendelt idejüket és itt lakásuknak határait, ");
INSERT INTO hun_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","hogy keressék az Urat, hátha kitapinthatják és megtalálhatják, mert bizony nincs messze egyikünktől sem; ");
INSERT INTO hun_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","mert őbenne élünk, mozgunk és vagyunk, amiképpen a költőitek közül is némelyek mondták: Mert az ő nemzetsége is vagyunk. ");
INSERT INTO hun_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Mivel azért az Istennek nemzetsége vagyunk, nem kell azt gondolnunk, hogy aranyhoz, vagy ezüsthöz, vagy kőhöz, emberi mesterséghez vagy elképzeléshez hasonlatos az istenség. ");
INSERT INTO hun_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","E tudatlanságnak idejét eddig elnézte az Isten, most megparancsolja az embereknek, mindenkinek mindenütt, hogy térjenek meg, ");
INSERT INTO hun_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","mert rendelt egy napot, amelyen megítéli majd a föld kerekségét igazságban egy férfiú által, akit erre kiválasztott, bizonyságot téve róla mindenkinek azzal, hogy feltámasztotta őt halálból.“ ");
INSERT INTO hun_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Amikor pedig a halottak feltámadásáról hallottak, némelyek gúnyolódtak, mások pedig ezt mondták: „Majd még meghallgatunk téged e felől.“ ");
INSERT INTO hun_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Így aztán Pál elment közülük. ");
INSERT INTO hun_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Néhány férfi azonban csatlakozott hozzá és hittek, ezek között az areopágita Dioniziosz is, és egy Damarisz nevű asszony, és mások is. ");
INSERT INTO hun_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Ezek után Pál Athénből eltávozva, elment Korinthusba. ");
INSERT INTO hun_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Amikor pedig egy Akvila nevű, pontuszi származású zsidóra talált – aki nem régen jött Itáliából – , és feleségére Priszcillára (mivel Klaudiusz megparancsolta, hogy a zsidók mind távozzanak Rómából): hozzájuk csatlakozott. ");
INSERT INTO hun_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Mivel ugyanolyan mestersége volt, náluk maradt, és dolgozott, ugyanis sátorkészítők voltak. ");
INSERT INTO hun_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Minden szombaton pedig a zsinagógában vitatkozott, és igyekezett mind zsidókat, mind görögöket meggyőzni. ");
INSERT INTO hun_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Amikor pedig megérkezett Macedóniából Szilász és Timótheus, a lélek szorongatta Pált, és bizonyságot tett a zsidóknak, hogy Jézus a Krisztus. ");
INSERT INTO hun_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Amikor pedig azok ellene szegültek és káromlásokat szóltak, ruháiról lerázva a port, ezt mondta nekik: „Véretek szálljon fejetekre, én tiszta vagyok! Mostantól fogva a pogányokhoz megyek.“ ");
INSERT INTO hun_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","És elmenve onnan, elment egy Jusztusz nevű, istenfélő ember házához, akinek háza szomszédos volt a zsinagógával. ");
INSERT INTO hun_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Kriszpusz pedig, a zsinagógának feje hitt az Úrban egész háza népével együtt. A korinthusiak közül is sokan, akik hallgatták őt, hittek és megkeresztelkedtek. ");
INSERT INTO hun_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Az Úr pedig éjszaka látomásban Pálnak ezt mondta: „Ne félj, hanem szólj, és ne hallgass: ");
INSERT INTO hun_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","mert én veled vagyok, és senki sem támad reád, hogy neked ártson, mert nekem sok népem van ebben a városban.“ ");
INSERT INTO hun_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","És ott lakott egy esztendeig és hat hónapig, tanítva közöttük az Isten igéjét. ");
INSERT INTO hun_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Amikor pedig Gallió volt Akhája tiszttartója, a zsidók egy akarattal Pálra támadtak, a törvényszék elé vitték, ");
INSERT INTO hun_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","és ezt mondták: „A törvény ellen való istentiszteletre csábítja az embereket.“ ");
INSERT INTO hun_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Amikor pedig Pál szólásra akarta nyitni száját, Gallió a zsidóknak ezt mondta: „Ha valóban valami bosszútételről, vagy gonosz cselekedetről volna szó, zsidók, igazság szerint meghallgatnálak benneteket. ");
INSERT INTO hun_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","De ha tanításról, nevekről és a törvényetekről van vita, ti magatok intézzétek el, mert én ezekben bíró nem akarok lenni.“ ");
INSERT INTO hun_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","És elűzte őket a törvényszék elől. ");
INSERT INTO hun_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","A görögök pedig mindnyájan megragadták Szószthenészt, a zsinagóga fejét, és verték a törvényszék előtt, de Gallió semmit sem törődött velük. ");
INSERT INTO hun_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pál pedig, miután még több napig ott maradt, elbúcsúzott az atyafiaktól, Szíriába hajózott, és vele együtt Priszcilla és Akvila, miután fejét Kenkreában megnyírta, mert fogadalmat tett. ");
INSERT INTO hun_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Mikor pedig Efezusba jutott, őket ott hagyta, bement a zsinagógába, s vitatkozott a zsidókkal. ");
INSERT INTO hun_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Amikor pedig azok kérték, hogy hosszabb ideig maradjon náluk, nem állt rá, ");
INSERT INTO hun_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","hanem búcsút vett tőlük, s ezt mondta: „Nekem mindenesetre Jeruzsálemben kell a következő ünnepet töltenem, de ismét eljövök hozzátok, ha Isten akarja.“ És elhajózott Efezusból. ");
INSERT INTO hun_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Miután Cézáreába érkezett, felment Jeruzsálembe, köszöntötte a gyülekezetet, majd lement Antiókhiába. ");
INSERT INTO hun_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Miután ott bizonyos időt eltöltött, elment, sorra végigjárta Galácia tartományát és Frígiát, erősítve a tanítványokat mind. ");
INSERT INTO hun_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Efezusba pedig egy Apollós nevű, alexandriai származású zsidó érkezett, ékesen szóló férfiú, aki az írásokban tudós volt. ");
INSERT INTO hun_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Őt már megtanították az Úr útjára, és mivel lélekben buzgó volt, nagyon szorgalmasan hirdette, és tanította az Úrról szóló dolgokat, bár csak János keresztségéről tudott. ");
INSERT INTO hun_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Nagy bátorsággal kezdett beszélni a zsinagógában. Mikor pedig meghallgatta őt Akvila és Priszcilla, maguk mellé vették, és világosan kifejtették előtte az Istennek útját. ");
INSERT INTO hun_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Amikor pedig Akhájába akart átmenni, buzdították őt az atyafiak, írtak a tanítványoknak, hogy fogadják be őt. Amikor megérkezett, sokat segített azoknak, akik a kegyelem által hittek. ");
INSERT INTO hun_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Mert hatalmasan meggyőzte a zsidókat, a nyilvánosság előtt bebizonyítva az Írásokból, hogy Jézus a Krisztus. ");
INSERT INTO hun_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Történt pedig aközben, amíg Apollós Korinthusban volt, hogy Pál, bejárva a felsőbb tartományokat, Efezusba érkezett. Amikor néhány tanítványra talált, ");
INSERT INTO hun_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","ezt mondta nekik: „Vajon vettetek-e Szentlelket, miután hivőkké lettetek?“ Azok pedig ezt mondták neki: „Még azt sem hallottuk, hogy van Szentlélek.“ ");
INSERT INTO hun_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Ekkor megkérdezte tőlük: „Mire keresztelkedtetek meg tehát?“ Azok pedig azt mondták: „A János keresztségére.“ ");
INSERT INTO hun_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pál pedig ezt mondta: „János megtérésnek keresztségével keresztelt, azt mondva a népnek, hogy aki ő utána jön, abban higgyenek, tudniillik a Krisztus Jézusban.“ ");
INSERT INTO hun_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Amikor pedig ezt hallották, megkeresztelkedtek az Úr Jézus nevére. ");
INSERT INTO hun_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","És mikor Pál reájuk tette kezét, a Szentlélek szállt reájuk, nyelveken szóltak és prófétáltak. ");
INSERT INTO hun_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","A férfiak pedig összesen mintegy tizenketten voltak. ");
INSERT INTO hun_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Bement a zsinagógába, három hónapon át vitatkozva bátorsággal szólt, és igyekezett meggyőzni őket az Isten országára tartozó dolgokról. ");
INSERT INTO hun_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Amikor pedig néhányan megkeményítették magukat és nem hittek, sőt gonoszul beszéltek az Úr útjáról a sokaság előtt, otthagyta őket, elszakította a tanítványokat tőlük, s mindennap egy bizonyos Tirannus iskolájában prédikált. ");
INSERT INTO hun_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Ez pedig két esztendeig tartott, úgy, hogy mindazok, akik Ázsiában laktak, mind zsidók, mind görögök, hallgatták az Úr Jézusnak igéjét. ");
INSERT INTO hun_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Isten pedig nem mindennapi csodákat cselekedett Pál keze által, ");
INSERT INTO hun_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","úgyhogy még a testéről is elvitték a kendőket vagy kötényeket a betegekhez, és eltávoztak tőlük a betegségek, és a gonosz lelkek kimentek belőlük. ");
INSERT INTO hun_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Néhányan pedig a lézengő zsidó ördögűzők közül elkezdték az Úr Jézus nevét hívni azokra, akikben gonosz lelkek voltak, és ezt mondták: „Kényszerítünk titeket arra a Jézusra, akit Pál prédikál.“ ");
INSERT INTO hun_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Közöttük voltak pedig Szkévának, egy zsidó főpapnak fiai heten, akik ezt művelték. ");
INSERT INTO hun_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","A gonosz lélek pedig ezt mondta: „A Jézust ismerem, Pálról is tudok, de ti kicsodák vagytok?“ ");
INSERT INTO hun_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","És rájuk ugrott az az ember, akiben a gonosz lélek volt, és leteperte őket, hatalmat vett rajtuk annyira, hogy meztelenül és megsebesülve szaladtak ki abból a házból. ");
INSERT INTO hun_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Ezt pedig megtudták mindannyian, zsidók és görögök, akik Efezusban laktak, félelem szállta meg mindnyájukat, és magasztalták az Úr Jézusnak nevét. ");
INSERT INTO hun_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Sokan a hívők közül is eljöttek, bevallották és föltárták mesterkedéseiket. ");
INSERT INTO hun_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Sokan pedig azok közül, akik ördögi mesterségeket űztek, könyveiket összehordták, és mindenki szeme láttára megégették. Összeszámlálták a könyvek árát, és azok ötvenezer ezüstpénzt tettek ki. ");
INSERT INTO hun_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Így az Úrnak igéje erősen növekedett és hatalmas lett. ");
INSERT INTO hun_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Amikor pedig ezek megtörténtek, Pál eldöntötte magában, hogy elmegy Macedóniába és Akhájába, majd Jeruzsálembe, és ezt mondta: „Ottlétem után Rómát is meg kell látnom.“ ");
INSERT INTO hun_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Macedóniába pedig elküldött kettőt azok közül, akik neki szolgáltak, Timóteust és Erásztoszt, ő maga pedig még egy ideig Ázsiában maradt. ");
INSERT INTO hun_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Az időtájt azonban nem csekély háborúság támadt az Úr útja miatt. ");
INSERT INTO hun_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Mert egy Demeter nevű ötvös, ezüstből Artemisz-templomokat készített, és a mesterembereknek nem csekély nyereséget juttatott. ");
INSERT INTO hun_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Összegyűjtötte őket, és az ilyenfélékkel foglalkozó műveseket, s ezt mondta: „Férfiak, tudjátok, hogy ebből a mesterségből van a mi jólétünk. ");
INSERT INTO hun_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Látjátok és halljátok, hogy ez a Pál nemcsak Efezusnak, hanem közel az egész Ázsiának sok népét eláltatta és félrevezette, mivel azt mondja, hogy nem istenek azok, amelyeket kézzel csinálunk. ");
INSERT INTO hun_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Nemcsak az a veszély fenyeget bennünket, hogy ez a mesterség tönkre megy, hanem hogy a nagy istenasszonynak, Artemisznek templomát is semmibe veszik, elvész az ő nagysága is, akit egész Ázsia és a világ tisztel.“ ");
INSERT INTO hun_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Amikor pedig ezeket hallották, elteltek haraggal és ezt kiáltották: „Nagy az efezusi Artemisz!“ ");
INSERT INTO hun_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Az egész város háborúsággal telt meg, és egy akarattal a színházba rohantak, megfogták Gájuszt és Arisztarkhoszt, akik Macedóniából valók, és Pálnak útitársai voltak. ");
INSERT INTO hun_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pál pedig amikor a nép közé akart menni, nem eresztették a tanítványok. ");
INSERT INTO hun_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Az ázsiai főpapok közül is néhányan, akik barátai voltak neki, hozzá küldtek és kérték, hogy ne menjen a színházba. ");
INSERT INTO hun_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Ott pedig az egyik ezt, a másik azt kiáltozta, mert a népgyűlés összezavarodott és a többség nem tudta, miért gyűltek össze. ");
INSERT INTO hun_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","A sokaság közül pedig előállították Sándort, akit a zsidók előretuszkoltak. Sándor pedig intett a kezével, hogy védekezni akar a nép előtt. ");
INSERT INTO hun_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Azonban felismerték, hogy zsidó, kiáltozás tört ki mindnyájukból, mintegy két óra hosszáig kiabálva: „Nagy az efezusi Artemisz!“ ");
INSERT INTO hun_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Miután pedig a városi jegyző lecsendesítette a sokaságot, ezt mondta: „Efezusbeli férfiak, ugyan ki az az ember, aki ne tudná, hogy Efezus városa a nagy Artemisz istenasszonynak, és a Jupitertől leszállt képének templomőrzője? ");
INSERT INTO hun_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Mivel ezek ellen senki nem szólhat, szükséges, hogy elcsendesedjetek, és semmi vakmerő dolgot ne kövessetek el. ");
INSERT INTO hun_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Mert idehoztátok ezeket az embereket, akik sem nem szentségrontók, sem a ti istenasszonyotok ellen káromlást nem szóltak. ");
INSERT INTO hun_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Ha tehát Demeternek és a hozzátartozó mesterembereknek valaki ellen panaszuk van, vannak törvényszékek, és vannak helytartók, pereljenek ott egymással. ");
INSERT INTO hun_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ha pedig egyéb dolog miatt van valami panaszotok, a törvényes népgyűlésen majd elintézitek. ");
INSERT INTO hun_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Mert félő, hogy lázadással vádolnak meg a mai nap miatt; ugyanis semmi ok nincs, amellyel számot tudnánk adni ezért a csődületért.“ ");
INSERT INTO hun_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Ezeket mondva, feloszlatta a gyűlést. ");
INSERT INTO hun_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Miután pedig megszűnt a háborúság, magához hívta Pál a tanítványokat, és tőlük búcsút véve elindult, hogy Macedóniába menjen. ");
INSERT INTO hun_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Miután pedig azokat a tartományokat bejárta, és intette őket számos beszéddel, Görögországba ment. ");
INSERT INTO hun_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Ott töltött három hónapot, és mivel a zsidók cselt szőttek ellene, amint Szíriába készült hajózni, úgy döntött, hogy Macedónián át tér vissza. ");
INSERT INTO hun_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Ázsiáig pedig elkísérte őt a béreai Szópatér, a thesszalonikaiak közül pedig Arisztarkhosz, Szekundusz és a derbei Gájus, Timóteus és az ázsiaiak közül Tükhikosz és Trofimosz. ");
INSERT INTO hun_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Ezek előrementek, és megvártak minket Tróászban. ");
INSERT INTO hun_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Mi pedig a kovásztalan kenyerek napjai után kieveztünk Filippiből, és elmentünk hozzájuk Tróászba öt nap alatt, ahol hét napot töltöttünk. ");
INSERT INTO hun_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","A hét első napján pedig a tanítványok összegyűltek a kenyér megszegésére, Pál prédikált nekik, és mivel másnap el akart menni, a tanítást megnyújtotta egészen éjfélig. ");
INSERT INTO hun_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Abban a házban pedig elegendő lámpás volt, ahol összegyűltek. ");
INSERT INTO hun_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Egy Eutikhosz nevű ifjú pedig az ablakban ült, mély álomba merült, mivel Pál hosszú ideig prédikált, elnyomta az álom, és leesett a harmadik emeletről, és holtan szedték föl. ");
INSERT INTO hun_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Pál pedig lement, ráborult és magához ölelve ezt mondta: „Ne háborogjatok, mert a lelke benne van.“ ");
INSERT INTO hun_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Azután fölment, megszegte a kenyeret, evett, és sokáig, egészen virradatig beszélgettek, s úgy indult el. ");
INSERT INTO hun_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Az ifjat pedig élve hozták fel, és nagyon megvigasztalódtak. ");
INSERT INTO hun_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Mi pedig előrementünk a hajóra, Asszoszba eveztünk, s ott akartuk fölvenni Pált, mert így rendelkezett, mert ő maga gyalog akart jönni. ");
INSERT INTO hun_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Mikor pedig Asszoszban összetalálkozott velünk, felvettük, és elmentünk Mitilénébe. ");
INSERT INTO hun_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Onnan elhajózva, másnap eljutottunk Khiosz elé, a következő nap pedig áthajóztunk Számoszba. Trogilliumban megszálltunk, s másnap mentünk Milétoszba. ");
INSERT INTO hun_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Mert elhatározta Pál, hogy Efezus mellett elhajózik, hogy ne kelljen időt töltenie Ázsiában, mert sietett, hogy ha lehetséges, pünkösd napjára Jeruzsálemben legyen. ");
INSERT INTO hun_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Milétoszból azonban elküldött Efezusba, magához hívatta a gyülekezet véneit. ");
INSERT INTO hun_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Amikor pedig odamentek hozzá, ezt mondta nekik: „Ti tudjátok, hogy az első naptól fogva, melyen Ázsiába jöttem, hogyan viselkedtem közöttetek az egész idő alatt, ");
INSERT INTO hun_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","szolgálva az Úrnak teljes alázatossággal, sok könnyhullatás és zaklatások között, melyeket a zsidók cselszövései miatt szenvedtem. ");
INSERT INTO hun_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Semmitől sem vonakodtam, ami hasznos, hogy prédikáljak nektek, és tanítsalak titeket nyilvánosan és házanként, ");
INSERT INTO hun_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","bizonyságot téve mind zsidóknak, mind görögöknek az Istenhez való megtérés, és a mi Urunk Jézus Krisztusban való hit felől. ");
INSERT INTO hun_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","És most, íme, a Lélektől kényszerítve megyek Jeruzsálembe, nem tudva, mi vár ott énreám. ");
INSERT INTO hun_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Csak azt tudom, hogy a Szentlélek városonként bizonyságot tesz, hogy reám fogság és nyomorúság vár. ");
INSERT INTO hun_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","De semmivel sem törődök, még az életem sem drága nékem, csakhogy elvégezhessem futásomat örömmel, és azt a szolgálatot, melyet vettem az Úr Jézustól, hogy bizonyságot tegyek az Isten kegyelmének evangéliumáról. ");
INSERT INTO hun_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","És most, íme, tudom, nem látjátok többé az én orcámat, egyikőtök sem, akik között jártam, prédikálva az Istennek országát. ");
INSERT INTO hun_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Azért bizonyságot teszek előttetek a mai napon, hogy én mindenkinek vérétől tiszta vagyok. ");
INSERT INTO hun_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Mert nem vonakodtam, hogy hirdessem nektek az Istennek teljes akaratát. ");
INSERT INTO hun_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Viseljetek gondot azért magatokra és az egész nyájra, amelyben a Szentlélek titeket vigyázókká tett, az Isten anyaszentegyházának legeltetésére, melyet tulajdon vérével szerzett. ");
INSERT INTO hun_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Mert én tudom azt, hogy távozásom után közétek gonosz farkasok jönnek, akik nem kedveznek a nyájnak. ");
INSERT INTO hun_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Sőt magatok közül is támadnak férfiak, akik fonák dolgokat beszélnek, hogy a tanítványokat magukhoz vonzzák. ");
INSERT INTO hun_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Azért vigyázzatok, emlékezve arra, hogy én három esztendeig éjjel és nappal meg nem szűntem könnyhullatással inteni mindenkit. ");
INSERT INTO hun_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Most pedig, atyámfiai, ajánlak titeket az Istennek és az ő kegyelme igéjének, aki felépíthet benneteket, és örökséget adhat nektek minden megszenteltek között. ");
INSERT INTO hun_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Senkinek ezüstjét, vagy aranyát, vagy ruháját nem kívántam, ");
INSERT INTO hun_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","sőt magatok tudjátok, hogy magam szükségleteiről, és a velem lévőkéről kezeim gondoskodtak. ");
INSERT INTO hun_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Minden tekintetben megmutattam nektek, hogy ily módon munkálkodva kell az erőtlenekről gondot viselni, és megemlékezni az Úr Jézus szavairól, mert ő mondta: Jobb adni, mint kapni.“ ");
INSERT INTO hun_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Mikor ezeket elmondta, térdre esve imádkozott velük együtt. ");
INSERT INTO hun_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Mindnyájan pedig nagy sírásra fakadtak, Pálnak nyakába borultak és csókolgatták őt. ");
INSERT INTO hun_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Kiváltképpen azon a szaván keseredtek el, amelyet mondott, hogy többé az ő orcáját nem fogják látni. Aztán elkísérték őt a hajóra. ");
INSERT INTO hun_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Amint pedig, tőlük elszakadva, elindultunk, egyenesen haladva Kószba érkeztünk, másnap pedig Rodoszba, és onnan Patarába. ");
INSERT INTO hun_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Amikor pedig találtunk egy hajót, mely Föníciába ment át, abba beültünk, és elhajóztunk. ");
INSERT INTO hun_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Miután megláttuk Ciprust, és elhagytuk balkéz felől, Szíriába eveztünk, és Tíruszban kötöttünk ki, mert a hajó ott rakta ki a terhét. ");
INSERT INTO hun_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Ott maradtunk hét napig, miután megtaláltuk a tanítványokat, akik a Lélek által mondták Pálnak, hogy ne menjen fel Jeruzsálembe. ");
INSERT INTO hun_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Mikor pedig eltöltöttük azokat a napokat, és elindultunk, hogy elutazzunk, mindnyájan feleségestől, gyermekestől egészen a városon kívülre kísértek bennünket, és a tenger partján térdre esve imádkoztunk. ");
INSERT INTO hun_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Ezután egymástól elbúcsúztunk, beültünk a hajóba, ők pedig visszatértek övéikhez. ");
INSERT INTO hun_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Mi pedig a hajózást befejezve, Tíruszból eljutottunk Ptolemaiszba. Köszöntöttük az atyafiakat, és náluk maradtunk egy napig. ");
INSERT INTO hun_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Másnap pedig elment Pál és mi, akik vele voltunk, s Cezáreába érkeztünk, és bementünk Fülöp evangélista házába, aki ama hét közül való volt, és nála maradtunk. ");
INSERT INTO hun_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Neki pedig volt négy szűz leánya, akik prófétáltak. ");
INSERT INTO hun_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Mialatt pedig mi több napig ott maradtunk, eljött egy Júdeából való próféta, név szerint Agabosz. ");
INSERT INTO hun_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Mikor odajött hozzánk, elvette Pálnak az övét, megkötözte kezeit és lábait, s ezt mondta: „Ezt mondja a Szentlélek: A férfiút, akié ez az öv, ekképpen kötözik meg a zsidók Jeruzsálemben, és adják a pogányok kezébe.“ ");
INSERT INTO hun_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Amikor pedig ezeket hallottuk, kértük, mind mi, mind az odavalósiak, hogy ne menjen fel Jeruzsálembe. ");
INSERT INTO hun_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","De Pál így felelt: „Miért sírtok, és keserítitek a szívemet? Mert én nemcsak megkötöztetni, hanem meghalni is kész vagyok Jeruzsálemben az Úr Jézusnak nevéért.“ ");
INSERT INTO hun_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Mikor pedig nem engedett, megnyugodtunk és azt mondtuk: „Legyen meg az Úr akarata!“ ");
INSERT INTO hun_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Ezek után a napok után pedig felkészültünk, és felmentünk Jeruzsálembe. ");
INSERT INTO hun_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","A tanítványok közül is jöttek velünk együtt Cézáreából, akik elvezettek egy bizonyos ciprusi Mnázónhoz, egy régi tanítványhoz, hogy nála szálljunk meg. ");
INSERT INTO hun_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Mikor azután megérkeztünk Jeruzsálembe, örömmel fogadtak minket az atyafiak. ");
INSERT INTO hun_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Másnap pedig Pál velünk együtt bement Jakabhoz, ahol a vének is mindnyájan ott voltak. ");
INSERT INTO hun_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Köszöntötte őket, majd sorjában elbeszélte, amiket az Isten a pogányok között az ő szolgálata által cselekedett. ");
INSERT INTO hun_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Azok pedig ezt hallgatva, dicsőítették az Urat, és ezt mondták neki: „Látod, atyámfia, milyen sok ezren vannak zsidók, akik hívőkké lettek, pedig mindnyájan buzgón tartják a törvényt. ");
INSERT INTO hun_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Felőled pedig azt hallották, hogy te mindazokat a zsidókat, akik a pogányok között vannak, Mózestől való elszakadásra tanítod, azt mondva, hogy ne metéljék körül fiaikat, se a zsidó szokások szerint ne járjanak. ");
INSERT INTO hun_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Mit tegyünk tehát? Mindenesetre sokan összegyűlnek, ha meghallják, hogy ide jöttél. ");
INSERT INTO hun_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Azt tedd tehát, amit mondunk neked: Van köztünk négy férfiú, akik fogadalmat tettek. ");
INSERT INTO hun_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Ezeket magad mellé véve, tisztulj meg velük, költs rájuk, hogy megnyírják fejüket, hogy mindannyian megtudják, hogy semmi sincs azokban, amiket felőled hallottak, hanem te magad is úgy jársz, hogy a törvényt megtartod. ");
INSERT INTO hun_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","A pogányokból lett hívők felől pedig mi írtunk, azt határozva, hogy ők semmi ilyenfélét ne tartsanak meg, hanem csak tartsák távol magukat mind a bálványoknak áldozott hústól, mind a vértől, mind a megfulladt állattól, és a paráznaságtól.“ ");
INSERT INTO hun_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Akkor Pál maga mellé vette azokat a férfiakat, másnap velük megtisztult, bement a templomba, és bejelentette a tisztulás napjainak elteltét, amikor mindegyikükért bemutatják az áldozatot. ");
INSERT INTO hun_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Amikor pedig a hét nap már eltelőben volt, az Ázsiából való zsidók, meglátták őt a templomban, fellázították az egész sokaságot és rávetették kezüket, ");
INSERT INTO hun_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","ezt kiáltva: „Izraelita férfiak, segítsetek! Ez az az ember, aki a nép ellen, a törvény ellen és e hely ellen tanít mindenkit mindenütt; ezen felül még görögöket is hozott be a templomba, és megfertőztette ezt a szent helyet.“ ");
INSERT INTO hun_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Mert látták vele korábban az efezusi Trofimoszt a városban, akiről azt vélték, hogy Pál bevitte a templomba. ");
INSERT INTO hun_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Az egész város megmozdult, és a nép összecsődült, Pált megragadták, kivonszolták a templomból, és azonnal bezárták az ajtókat. ");
INSERT INTO hun_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Amikor pedig meg akarták ölni, eljutott a hír a sereg ezredeséhez, hogy az egész Jeruzsálem felzendült. ");
INSERT INTO hun_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Ő azonnal vitézeket és századosokat vett maga mellé, lefutott hozzájuk. Amikor pedig meglátták az ezredest és a vitézeket, abbahagyták Pál verését. ");
INSERT INTO hun_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Akkor odaért az ezredes, elfogatta őt, és megparancsolta, hogy kötözzék meg két lánccal, majd kérdezősködött, hogy kicsoda ez, és mit követett el. ");
INSERT INTO hun_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","De ki ezt, ki azt kiáltotta a sokaságból, és miután nem érthette meg a bizonyos valóságot a zajongás miatt, megparancsolta, hogy vigyék el a várba. ");
INSERT INTO hun_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Amikor pedig a lépcsőkhöz jutott, a vitézeknek vinniük kellett őt a nép erőszakossága miatt, ");
INSERT INTO hun_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","mert az egész sokaság követte őket, és kiáltozott: „Öld meg őt!“ ");
INSERT INTO hun_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Amikor pedig már a várba akarták bevinni Pált, ezt mondta az ezredesnek: „Szabad-e valamit mondanom neked?“ Az pedig ezt mondta: „Tudsz görögül? ");
INSERT INTO hun_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Hát nem te vagy az az egyiptomi, aki néhány nappal ezelőtt fellázította, és kivitte a pusztába azt a négyezer orgyilkos férfiút?“ ");
INSERT INTO hun_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Pál pedig ezt mondta: „Én ugyan tarzuszi zsidó ember vagyok, Cilicia nem ismeretlen városának polgára, de kérlek téged, engedd meg nekem, hogy szóljak a néphez.“ ");
INSERT INTO hun_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Amikor aztán megengedte, Pál a lépcsőkön állva intett kezével a népnek, és mikor nagy csend lett, megszólalt zsidó nyelven: ");
INSERT INTO hun_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","„Atyámfiai, férfiak és atyák, hallgassátok meg beszédemet, amellyel most magamat előttetek mentem.“ ");
INSERT INTO hun_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Mikor pedig hallották, hogy zsidó nyelven szól hozzájuk, még inkább nyugalmat tanúsítottak. És ezt mondta: ");
INSERT INTO hun_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","„Én zsidó ember vagyok, a ciliciai Tarzuszban születtem, éspedig ebben a városban nevelkedtem, s Gamáliel lábainál tanítottak az atyák törvényének pontossága szerint, buzgó voltam az Istenhez, miként ti mindnyájan vagytok ma. ");
INSERT INTO hun_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Ezt a tanítást üldöztem mindhalálig, megkötöztem és börtönbe vetettem mind férfiakat, mind nőket. ");
INSERT INTO hun_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","A főpap is bizonyságom nekem, és a vének egész tanácsa, akiktől leveleket is kaptam a testvérekhez mikor Damaszkuszba mentem, hogy az odavalósiakat is elfogva Jeruzsálembe hozzam, hogy bűnhődjenek. ");
INSERT INTO hun_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Történt pedig, hogy amint mentünk, és közeledtünk Damaszkuszhoz, déltájban nagy hirtelenséggel az égből nagy világosság sugárzott körül engem. ");
INSERT INTO hun_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Leestem a földre, és hangot hallottam, amely azt mondta nekem: Saul, Saul, miért üldözöl engem? ");
INSERT INTO hun_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Én pedig megkérdeztem: Kicsoda vagy, Uram? És ő ezt mondta nekem: Én vagyok a Názáreti Jézus, akit te kergetsz. ");
INSERT INTO hun_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Akik pedig velem voltak, a világosságot ugyan látták és megrémültek, de annak hangját, aki nekem szólt, nem hallották. ");
INSERT INTO hun_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Én pedig ezt mondtam: Mit tegyek, Uram? Az Úr pedig ezt mondta nekem: Kelj fel és menj el Damaszkuszba, ott megmondják neked mindazt, amit Isten elrendelt, hogy véghez vigyed. ");
INSERT INTO hun_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Mivel pedig nem láttam annak a világosságnak a ragyogása miatt, akik velem voltak kézen fogva vezettek, és elmentem Damaszkuszba. ");
INSERT INTO hun_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Egy bizonyos Anániás pedig, aki a törvény szerint istenfélő férfiú, aki mellett az ott lakó zsidók mind jó bizonyságot tesznek, ");
INSERT INTO hun_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","eljött hozzám, mellém állt, és ezt mondta nekem: Saul atyámfia, nyerd vissza szemed világát. És én abban a szempillantásban reá tekintettem. ");
INSERT INTO hun_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Ő pedig ezt mondta: A mi atyáinknak Istene választott ki téged, hogy megismerd az ő akaratát, és meglásd az Igazat, és hangot hallj az ő szájából. ");
INSERT INTO hun_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Mert tanúbizonysága leszel neki minden embernél arról, amiket láttál és hallottál. ");
INSERT INTO hun_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Most azért miért késlekedsz? Kelj fel, keresztelkedj meg, és mosd le bűneidet, segítségül hívva az Úrnak nevét. ");
INSERT INTO hun_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Történt pedig, hogy mikor Jeruzsálembe visszatértem, és imádkoztam a templomban, elragadtattam lélekben, ");
INSERT INTO hun_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","és láttam őt, aki ezt mondta nekem: Siess és menj ki hamar Jeruzsálemből, mert nem fogadják el a rólam szóló tanúbizonyságtételedet. ");
INSERT INTO hun_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Én pedig ezt mondtam erre: Uram, ők maguk tudják, hogy én börtönbe vetettem, és zsinagógáról zsinagógára járva megverettem azokat, akik hittek benned. ");
INSERT INTO hun_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","És amikor a te mártírodnak, Istvánnak vérét kiontották, én is ott álltam, és helyeseltem az ő megölését, és azoknak köntösét őriztem, akik őt megölték. ");
INSERT INTO hun_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","De ő azt mondta nekem: Eredj el, mert én messze küldelek téged a pogányok közé.“ ");
INSERT INTO hun_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Eddig a szóig hallgatták őt, de most felemelték szavukat: „Töröld el a föld színéről az ilyet, mert nem illik neki élnie.“ ");
INSERT INTO hun_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Amikor pedig azok kiabáltak, köntösüket elhányták és port szórtak a levegőbe, ");
INSERT INTO hun_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","megparancsolta az ezredes, hogy vigyék a várba, s korbácsütésekkel vallassák ki, hogy megtudhassa, miért kiabáltak úgy reá. ");
INSERT INTO hun_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Amint azonban lekötötték őt a szíjakkal, Pál az ott álló századosnak ezt mondta: „Vajon szabad-e nektek római embert, akit el nem ítéltek, megostorozni?“ ");
INSERT INTO hun_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Miután pedig ezt meghallotta a százados, elment és jelentette az ezredesnek ezt mondva: „Vigyázz, hogy mit akarsz tenni, mert ez az ember római.“ ");
INSERT INTO hun_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Erre odament hozzá az ezredes, és ezt mondta neki: „Mondd meg nekem, te római vagy-e?“ Ő pedig mondta: „Az vagyok.“ ");
INSERT INTO hun_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Az ezredes erre így felelt: „Én nagy összegért vettem meg ezt a polgárjogot.“ Pál pedig mondta: „Én pedig benne is születtem.“ ");
INSERT INTO hun_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Ekkor azonnal félreálltak tőle azok, akik vallatni akarták. Sőt az ezredes is megijedt, amikor megértette, hogy római, és megkötöztette őt. ");
INSERT INTO hun_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Másnap aztán meg akarta tudni a valóságot, hogy mivel vádolják a zsidók, feloldatta bilincseiből, és megparancsolta, hogy a főpapok az egész tanácsukkal együtt menjenek hozzá. Pált pedig levezettette és eléjük állította. ");
INSERT INTO hun_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Mikor pedig Pál a nagytanácsra emelte szemét, ezt mondta: „Atyámfiai, férfiak, én teljesen jó lelkiismerettel szolgáltam az Istennek mind e mai napig.“ ");
INSERT INTO hun_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Anániás főpap pedig megparancsolta azoknak, akik mellette álltak, hogy üssék szájon. ");
INSERT INTO hun_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Akkor Pál azt mondta neki: „Megver az Isten téged, te kimeszelt fal! Te leülsz a törvény szerint engem megítélni, és törvényellenesen cselekedve parancsolod, hogy engem verjenek?“ ");
INSERT INTO hun_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Az ott állók pedig ezt mondták: „Az Istennek főpapját szidalmazod?“ ");
INSERT INTO hun_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Pál pedig azt mondta: „Nem tudtam, atyámfiai, hogy főpap, mert meg van írva: »A te néped fejedelmét ne átkozd!«“ ");
INSERT INTO hun_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Amikor pedig Pálnak eszébe jutott, hogy az egyik részük a szadduceusok, a másik pedig a farizeusok közül való, felkiáltott a tanács előtt: „Atyámfiai, férfiak, én farizeus vagyok, farizeus fia: A halottak reménysége és feltámadása miatt vádolnak engem.“ ");
INSERT INTO hun_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Amikor pedig ezt mondta, meghasonlás támadt a farizeusok és a szadduceusok között, és a sokaság megoszlott. ");
INSERT INTO hun_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Mert a szadduceusok azt mondják, hogy nincs feltámadás, sem angyal, sem lélek, a farizeusok pedig mind a kettőt vallják. ");
INSERT INTO hun_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Erre nagy kiáltozás támadt, és a farizeusok pártjából néhány írástudó felállt, és tusakodott, és ezt mondták: „Semmi rosszat nem találunk ebben az emberben. Ha pedig Lélek szólt neki, vagy angyal, ne tusakodjunk Isten ellen.“ ");
INSERT INTO hun_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Mikor pedig nagy meghasonlás támadt közöttük, félt az ezredes, hogy Pált szétszaggatják, és megparancsolta, hogy a sereg jöjjön le, és ragadja ki őt közülük, és vigye el a várba. ");
INSERT INTO hun_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","A következő éjszakán pedig mellé állt az Úr, és ezt mondta: „Bízzál, Pál! Mert amiképpen bizonyságot tettél az én rólam szóló dolgokról Jeruzsálemben, úgy kell néked Rómában is bizonyságot tenned.“ ");
INSERT INTO hun_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Amikor pedig reggel lett, a zsidók közül néhányan összeszövetkeztek, és átok alatt kötelezték magukat, hogy sem nem esznek, sem nem isznak addig, amíg meg nem ölik Pált. ");
INSERT INTO hun_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Negyvennél is többen voltak azok, akik ezt az összeesküvést szőtték. ");
INSERT INTO hun_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Ezek elmentek a főpapokhoz és a vénekhez, és ezt mondták: „Átok alatt megesküdtünk, hogy semmit nem ízlelünk addig, amíg meg nem öljük Pált. ");
INSERT INTO hun_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Most azért ti jelentsétek be az ezredesnek a tanáccsal együtt, hogy holnap hozza le őt hozzátok, mintha az ő dolgának tüzetesebben végére akarnátok járni. Mi pedig, mielőtt ide érne, készek vagyunk megölni őt.“ ");
INSERT INTO hun_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Azonban Pál nővérének fia meghallotta ezt a cselszövést, megjelent, bement a várba és tudtára adta Pálnak. ");
INSERT INTO hun_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Pál pedig a századosok közül magához hívatott egyet, és ezt mondta: „Vezesd ezt az ifjat az ezredeshez, mert valamit jelenteni akar neki.“ ");
INSERT INTO hun_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Ezért maga mellé vette őt, és elvitte az ezredeshez, és ezt mondta: „A fogoly Pál magához hivatott engem, és kért, hogy ezt az ifjat vezessem hozzád, mert valamit mondani akar neked.“ ");
INSERT INTO hun_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Az ezredes pedig kézen fogta, és félrevonulva megkérdezte tőle: „Mi az, amit jelenteni akarsz nekem?“ ");
INSERT INTO hun_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Ő pedig ezt mondta: „A zsidók eldöntötték, hogy megkérnek téged, hogy Pált holnap vidd le a tanács elé, mintha valamit tüzetesebben meg akarnának tudni tőle. ");
INSERT INTO hun_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","De te ne engedj nekik, mert közülük negyvennél több férfiú leselkedik rá, akik átok alatt kötelezték el magukat, hogy sem nem esznek, sem nem isznak addig, amíg meg nem ölik őt. Már készen is vannak, a te üzenetedre várakoznak.“ ");
INSERT INTO hun_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Az ezredes ekkor elbocsátotta az ifjút, meghagyva neki: „Ne mondd el senkinek, hogy ezeket jelentetted nekem.“ ");
INSERT INTO hun_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Ezután magához hívatott kettőt a századosok közül, és ezt mondta: „Készítsetek föl kétszáz vitézt, hogy induljanak Cézáreába, hetven lovast és kétszáz parittyást, az éjszakának harmadik órájától fogva. ");
INSERT INTO hun_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Adjatok hátas állatokat is melléjük, hogy Pált felültetve békességben vigyék Félix tiszttartóhoz.“ ");
INSERT INTO hun_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Levelet is írt, melynek tartalma ez volt: ");
INSERT INTO hun_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","„Klaudiusz Liziász, a nemes Félix tiszttartónak üdvözletét küldi! ");
INSERT INTO hun_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Ezt a férfiút, a zsidók elfogták, és meg akarták ölni, odamenve a sereggel, kiszabadítottam, megértve, hogy római. ");
INSERT INTO hun_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Meg akartam tudni az okát, miért vádolják őt, levittem a tanácsuk elé. ");
INSERT INTO hun_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","És úgy találtam, hogy az ő törvényüknek kérdései miatt vádolják, de semmi halálra vagy fogságra méltó vétke nincs. ");
INSERT INTO hun_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Mivel pedig nekem megjelentették, hogy a zsidók ezután a férfiú után ólálkodni akarnak, azonnal hozzád küldtem, s meghagytam vádlóinak is, hogy ami dolguk ellene van, előtted mondják meg. Légy jó egészségben!“ ");
INSERT INTO hun_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","A vitézek tehát, amint nekik megparancsolták, Pált felvették, és elvitték azon az éjszakán Antipatriszba. ");
INSERT INTO hun_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Másnap pedig hagyták a lovasokat tovább menni vele, és visszatértek a várba. ");
INSERT INTO hun_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Ők pedig eljutottak Cézáreába, és átadták a levelet a tiszttartónak, és Pált is eléállították. ");
INSERT INTO hun_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Amikor pedig elolvasta a tiszttartó, és megkérdezte, melyik tartományból való, és megértette, hogy Ciliciából, ");
INSERT INTO hun_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","ezt mondta: „Majd kihallgatlak, amikor vádlóid is eljönnek.“ És megparancsolta, hogy Heródes palotájában őrizzék őt. ");
INSERT INTO hun_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Öt nap múlva aztán elment Anániás főpap a vénekkel és egy Tertullusz nevű prókátorral, akik panaszt tettek a tiszttartónál Pál ellen. ");
INSERT INTO hun_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Amikor pedig előszólították, Tertullusz vádolni kezdte: ");
INSERT INTO hun_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","„Nagyságos Félix, teljes hálával ismerjük el, hogy általad nagy békességet nyerünk, és gondoskodásod folytán igen jó intézkedések történnek erre a népre nézve, minden tekintetben és mindenütt. ");
INSERT INTO hun_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","De hogy téged sok ideig ne tartóztassalak, kérlek hallgass meg minket röviden kegyelmességed szerint. ");
INSERT INTO hun_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Mi ugyanis úgy találtuk, hogy ez veszedelmes ember, és meghasonlást támaszt a föld kerekségén levő valamennyi zsidó között, és a názáretiek felekezetének feje, ");
INSERT INTO hun_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","aki a templomot is meg akarta szentségteleníteni, de elfogtuk őt, és a mi törvényünk szerint akartuk elítélni. ");
INSERT INTO hun_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Liziász ezredes azonban, nagy karhatalommal oda jött, és kivette őt kezünkből, ");
INSERT INTO hun_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","és azt parancsolta, hogy az ő vádlói hozzád jöjjenek. Tőle te magad, ha kihallgatod, értesülhetsz mindezekről, melyekkel mi őt vádoljuk.“ ");
INSERT INTO hun_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","A zsidók is helybenhagyták ezt, és bizonygatták, hogy mindez valóban így van. ");
INSERT INTO hun_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Miután intett neki a tiszttartó, hogy szóljon, Pál így felelt: „Mivel tudom, hogy te sok esztendő óta vagy ennek a népnek bírája, bátrabban védekezem a magam ügyében, ");
INSERT INTO hun_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","mert megtudhatod, hogy nincs tizenkét napnál több, mióta feljöttem imádkozni Jeruzsálembe. ");
INSERT INTO hun_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","De a templomban sem láttak úgy, hogy valakivel vitatkoztam volna, vagy hogy a népet egybecsődítettem volna, sem a zsinagógákban, sem a városban. ");
INSERT INTO hun_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Rám sem bizonyíthatják azokat, amikkel most engem vádolnak. ");
INSERT INTO hun_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Azt pedig vallom, hogy én aszerint az út szerint – amelyet eretnekségnek mondanak – , úgy szolgálok az atyáim Istenének, mint aki hiszek mindabban, ami a törvényben és a próféták könyvében meg van írva. ");
INSERT INTO hun_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Reménységem van az Istenben, hogy amit ők maguk is várnak, lesz feltámadásuk a halottaknak, mind az igazaknak, mind a hamisaknak. ");
INSERT INTO hun_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Ebben gyakorlom magamat, hogy botránkozás nélkül való lelkiismeretem legyen az Isten és emberek előtt mindenkor. ");
INSERT INTO hun_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Sok esztendő múltán pedig eljöttem, hogy népemnek alamizsnát hozzak és áldozatokat. ");
INSERT INTO hun_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Eközben találtak rám a templomban megtisztulva, néhány Ázsiából való zsidó, nem csődületben, sem pedig háborúság támasztása közben. ");
INSERT INTO hun_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Nekik kellett volna eléd jönni, és vádolni engem, ha valami panaszuk volna ellenem. ");
INSERT INTO hun_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Vagy ők maguk mondják meg, vajon találtak-e bennem valami hamis cselekedetet, amikor a tanács előtt álltam, ");
INSERT INTO hun_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","ha csak nem annak az egy mondatnak tekintetében, amelyet közöttük állva kiáltottam, hogy: A halottak feltámadása miatt vádoltok a mai napon.“ ");
INSERT INTO hun_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Amikor pedig Félix ezeket hallotta, elhalasztotta az ügyet, mivel tüzetesebb tudomása volt ennek a szerzetnek a tanítása felől, és ezt mondta: „Amikor Liziasz ezredes eljön, dönteni fogok ügyetekben.“ ");
INSERT INTO hun_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Megparancsolta a századosnak, hogy őrizzék Pált, de enyhébb fogságban legyen, és senkit ne tiltsanak el az övéi közül attól, hogy szolgálatára legyen, vagy bemenjen hozzá. ");
INSERT INTO hun_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Néhány nap múlva pedig Félix megjelent feleségével Druzillával együtt, aki zsidó asszony volt, és maga elé hívatta Pált, és meghallgatta a Krisztusban való hit felől. ");
INSERT INTO hun_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Amikor pedig az igazságról, önmegtartóztatásról és az eljövendő ítéletről beszélt, megrémülve, ezt mondta Félix: „Most eredj el, de mikor alkalmam lesz, ismét magamhoz hívatlak“. ");
INSERT INTO hun_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Ugyanakkor azt is remélte, hogy Pál pénzt ad neki, hogy szabadon bocsássa, ezért is gyakrabban hívatta magához, és beszélgetett vele. ");
INSERT INTO hun_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Két esztendő elmúltával, Félix utóda Porciusz Fesztusz lett. A zsidóknak kedveskedni akart Félix, és Pált fogságban hagyta. ");
INSERT INTO hun_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Fesztusz tehát, miután bement a tartományba, három nap múlva felment Jeruzsálembe Cézáreából. ");
INSERT INTO hun_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","A főpap és a zsidók főemberei pedig panaszt tettek neki Pál ellen, és kérték ");
INSERT INTO hun_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","jóindulatát, hogy Pált hozassa át Jeruzsálembe, hogy lest vetve megölhessék őt az úton. ");
INSERT INTO hun_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Fesztusz azonban azt felelte, hogy Pált Cézáreában őrzik, ő maga pedig hamarosan el fog menni. ");
INSERT INTO hun_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","„Akik pedig köztetek, úgymond, főemberek, jöjjenek velem, és ha valami gonoszság van abban a férfiban, emeljenek vádat ellene.“ ");
INSERT INTO hun_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Miután pedig tíz napnál tovább időzött közöttük, lement Cézáreába. Másnap beült a bírói székbe, és előhozatta Pált. ");
INSERT INTO hun_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Amikor pedig megjelent, körülállták a zsidók, akik lementek Jeruzsálemből, és sok súlyos vádat hoztak fel Pál ellen, melyeket nem bírtak bebizonyítani. ");
INSERT INTO hun_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Pál a maga mentségére ezt felelte: „Sem a zsidók törvénye ellen, sem a templom ellen, sem a császár ellen, nem vétettem semmit.“ ");
INSERT INTO hun_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Fesztusz azonban a zsidóknak kedveskedni akart, és ezt mondta Pálnak: „Akarsz-e Jeruzsálembe felmenni, hogy ott ítélkezzem ezekről ebben az ügyben?“ ");
INSERT INTO hun_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Pál azonban ezt mondta: „A császár ítélőszéke előtt állok, itt ítéljenek meg. A zsidóknak semmit sem vétettem, miként te is jól tudod. ");
INSERT INTO hun_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Mert ha vétkes vagyok, és valami halálra méltót cselekedtem, nem vonakodom a haláltól, ha azonban semmi sincs azokban, amikkel ezek vádolnak engem, senki sem szolgáltathat ki engem nekik. A császárhoz föllebbezek!“ ");
INSERT INTO hun_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Akkor Fesztusz tanácsával értekezett, és ezt felelte: „A császárhoz föllebbeztél, a császár elé fogsz menni!“ ");
INSERT INTO hun_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Néhány nap múlva pedig Agrippa király és Berniké érkezett Cézáreába, hogy köszöntsék Fesztuszt. ");
INSERT INTO hun_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Amikor pedig több napig ott időztek, Fesztusz előadta a királynak Pál ügyét: „Van itt egy fogoly, akit Félix hagyott itt. ");
INSERT INTO hun_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Amikor Jeruzsálembe mentem, jelentést tettek róla a főpapok és a zsidók vénei, kérve ellene ítéletet. ");
INSERT INTO hun_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Nekik azt feleltem, hogy nem szokásuk a rómaiaknak, hogy egy embert halálra adjanak, mielőtt a vádlottat nem szembesítenék vádlóival, és alkalmat nem kap a vád felől való védekezésre. ");
INSERT INTO hun_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Amikor aztán ide gyűltek, késedelem nélkül másnap az ítélőszékbe ültem, előhozattam azt a férfit, ");
INSERT INTO hun_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","aki ellen – amikor vádlói előálltak – , semmi bűnt nem hoztak fel azok közül, amiket én sejtettem, ");
INSERT INTO hun_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","hanem valamilyen vitás kérdéseik voltak vele a tulajdon vallásuk felől, és egy bizonyos meghalt Jézus felől, akiről Pál azt állította, hogy él. ");
INSERT INTO hun_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Én pedig bizonytalanságban voltam erre a vitára nézve, s megkérdeztem, vajon nem akar-e Jeruzsálembe menni, hogy ott mondjanak ítéletet ezek felől. ");
INSERT INTO hun_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Pál azonban föllebbezett, hogy őt tartsák fenn Augustus döntése számára, én pedig megparancsoltam, hogy tartsák fogva őt, amíg a császárhoz nem küldhetem.“ ");
INSERT INTO hun_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Agrippa erre ezt mondta Fesztusznak: „Szeretném magam is azt az embert hallani.“ Ő pedig ezt felelte: „Holnap hallani fogod őt.“ ");
INSERT INTO hun_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Másnap tehát eljött Agrippa és Berniké nagy pompával, bementek a kihallgatási terembe az ezredesekkel, és a város előkelőségeivel együtt. Fesztusz parancsára elővezették Pált. ");
INSERT INTO hun_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Fesztusz pedig ezt mondta: „Agrippa király és ti férfiak mindnyájan, akik velünk együtt itt vagytok! Látjátok őt, aki miatt a zsidóknak egész sokasága keresett meg engem, mind Jeruzsálemben, mind itt, azt kiáltva, hogy nem szabad neki életben maradni. ");
INSERT INTO hun_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Én pedig, ámbár megértettem, hogy semmi halálra méltó dolgot sem cselekedett, de mivel éppen ő maga föllebbezett Augustushoz, úgy határoztam, hogy elküldöm hozzá. ");
INSERT INTO hun_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Mivel nem tudok semmi bizonyosat írni róla az én uramnak, ezért hoztam elétek, és kiváltképpen te eléd, Agrippa király, hogy a kihallgatás megtörténtével tudjak mit írni. ");
INSERT INTO hun_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Mert esztelen dolognak tartom, hogy aki foglyot küld, ne jelentse az ellene való vádakat is.“ ");
INSERT INTO hun_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Agrippa erre ezt mondta Pálnak: „Megengedjük neked, hogy szólj a magad mentségére.“ Akkor Pál kinyújtotta a kezét, és védőbeszédet tartott: ");
INSERT INTO hun_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","„Agrippa király! Boldognak tartom magam, hogy mindazok felől, amikkel a zsidók vádolnak, előtted fogok védekezni e mai napon, ");
INSERT INTO hun_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","mivel te nagyon jól ismered a zsidók minden szokását és vitás kérdését. Azért kérlek, hallgass meg engem türelmesen! ");
INSERT INTO hun_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Életemet, amely kezdettől fogva az én népem között Jeruzsálemben folyt le, ifjúságomtól fogva ismerik a zsidók mindnyájan. ");
INSERT INTO hun_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Ők tudják rólam kezdettől fogva, tanúsítani is tudnák, hogy én a mi vallásunk legszigorúbb felekezete szerint éltem, mint farizeus. ");
INSERT INTO hun_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Most is az Istentől a mi atyáinknak tett ígéret reménysége miatt állok itt vád alatt. ");
INSERT INTO hun_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Éjjel és nappal buzgón szolgálva, a mi tizenkét nemzetségünk is reméli, hogy ez beteljesül. E miatt a reménység miatt vádolnak a zsidók, Agrippa király. ");
INSERT INTO hun_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Miért tűnik nektek hihetetlen dolognak, hogy Isten halottakat támaszt fel? ");
INSERT INTO hun_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Én is elhatároztam magamban, hogy sok ellenséges dolgot kell cselekednem a Názáreti Jézus neve ellen. ");
INSERT INTO hun_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Ezt meg is tettem Jeruzsálemben, és a szentek közül sokat börtönbe vettettem, melyre a főpapoktól felhatalmazást kaptam. Sőt amikor megölték őket, szavazatommal hozzájárultam. ");
INSERT INTO hun_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","A zsinagógákban mindenfelé gyakran büntettem, káromlásra kényszerítettem, és féktelen dühömben egészen az idegen városokig kergettem őket. ");
INSERT INTO hun_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Amikor egyszer éppen ilyen ügyben útban voltam Damaszkusz felé, a főpapok felhatalmazásával és engedélyével, ");
INSERT INTO hun_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","délben az úton azt láttam, király, hogy a mennyből a napnak fényességét is meghaladó világosság sugárzott körül engem és azokat, akik velem együtt haladtak. ");
INSERT INTO hun_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Amikor pedig mindnyájan leestünk a földre, szózatot hallottam, mely hozzám szólt, és ezt mondta zsidó nyelven: Saul, Saul, mit kergetsz engem? Nehéz neked az ösztöke ellen rugódoznod. ");
INSERT INTO hun_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Erre én ezt kérdeztem: Kicsoda vagy, Uram? Az Úr ezt felelte: Én vagyok Jézus, akit te kergetsz. ");
INSERT INTO hun_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","De kelj fel, és állj lábaidra, mert azért jelentem meg neked, hogy téged szolgává és bizonysággá rendeljelek azokban, amiket láttál, és azokban, amelyekben meg fogok neked jelenni. ");
INSERT INTO hun_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Megoltalmazlak téged e néptől és a pogányoktól, akik közé most küldelek, ");
INSERT INTO hun_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","hogy nyisd meg a szemeiket, hogy sötétségből világosságra, és a Sátán hatalmából az Istenhez térjenek, hogy bűneiknek bocsánatát, és a megszenteltek között osztályrészt nyerjenek az én bennem való hit által. ");
INSERT INTO hun_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Ezért, Agrippa király, nem lettem engedetlen a mennyei látás iránt, ");
INSERT INTO hun_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","hanem először a damaszkusziaknak és jeruzsálemiaknak, majd Júdea egész tartományában és a pogányoknak hirdettem, hogy bánják meg bűneiket, és térjenek meg az Istenhez, megtéréshez méltó cselekedeteket cselekedve. ");
INSERT INTO hun_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Ezekért akartak engem megölni a zsidók, amikor megfogtak a templomban. ");
INSERT INTO hun_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","De Istentől segítséget kaptam, s mind e mai napig itt állok, és bizonyságot teszek mind kicsinynek, mind nagynak, és semmit nem mondok azokon kívül, amikről a próféták és Mózes megmondták, hogy be fognak teljesedni, ");
INSERT INTO hun_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","hogy a Krisztusnak szenvednie kell, hogy elsőnek támad fel a halottak közül, és világosságot fog hirdetni ennek a népnek és a pogányoknak.“ ");
INSERT INTO hun_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Mikor pedig ezeket hozta fel a maga mentségére, Fesztusz hangosan mondta: „Bolond vagy te, Pál! A sok tudomány téged őrültségbe visz.“ ");
INSERT INTO hun_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Pál azonban ezt mondta: „Nem vagyok bolond, nemes Fesztusz, hanem igaz és józan beszédeket szólok. ");
INSERT INTO hun_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Mert tud ezekről a király, akihez bátran is szólok: mert éppen nem gondolom, hogy ezek közül előtte bármi is ismeretlen volna, mert nem valami zugban történt dolog ez. ");
INSERT INTO hun_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Hiszel-e, Agrippa király, a prófétáknak? Tudom, hogy hiszel.“ ");
INSERT INTO hun_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Agrippa pedig ezt mondta Pálnak: „Majdnem ráveszel engem, hogy keresztyénné legyek.“ ");
INSERT INTO hun_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Pál pedig mondta: „Kívánnám Istentől, hogy ne csak majdnem, hanem nagyon is, és ne csak te, hanem mindazok, akik ma engem hallgatnak, lennétek olyanok, amilyen én is vagyok, de e bilincsek nélkül.“ ");
INSERT INTO hun_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Mikor ezeket mondta, felkelt a király, a tiszttartó, Berniké és akik velük együtt ültek. ");
INSERT INTO hun_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Visszavonultak, beszélgettek egymással és ezt mondták: „Semmi halálra, vagy fogságra méltó dolgot nem tett ez az ember.“ ");
INSERT INTO hun_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agrippa pedig ezt mondta Fesztusznak: „Ezt az embert szabadon lehetett volna bocsátani, ha a császárhoz nem föllebbezett volna.“ ");
INSERT INTO hun_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Amikor pedig eldöntötték, hogy mi Itáliába hajózzunk, átadták mind Pált, mind néhány más foglyot egy Juliusz nevű századosnak a császári seregből. ");
INSERT INTO hun_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Beszálltunk hát egy Adramittiumból való hajóba, és az Ázsia mentén fekvő helyeket akarva behajózni, elindultunk. Velünk tartott a macedóniai Arisztárkhosz, aki Thesszalonikából való. ");
INSERT INTO hun_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Másnap megérkeztünk Szidónba. Juliusz emberséggel bánt Pállal, megengedte, hogy barátaihoz elmenjen, és azok gondoskodjanak róla. ");
INSERT INTO hun_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Onnan elindulva Ciprus alatt eveztünk el, mivel ellenszél volt. ");
INSERT INTO hun_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","A Cilicia és Pamfília mellett levő tengeren átevezve eljutottunk a líciai Mirába. ");
INSERT INTO hun_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Mivel ott a százados egy Itáliába menő alexandriai hajót talált, abba szállított be minket. ");
INSERT INTO hun_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Több napon át azonban lassan hajóztunk, és nehezen érkeztünk el Knidosz elé. Mivel nem engedett bennünket odajutni a szél, elhajóztunk Kréta alatt, Szalmóné mellett, ");
INSERT INTO hun_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","és nagy üggyel-bajjal elhajózva mellette, eljutottunk egy helyre, melyet Szépkikötőknek neveznek, melyhez közel volt Lázea városa. ");
INSERT INTO hun_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Mivel pedig sok idő múlt el és a hajózás már veszedelmes volt, mivel a böjt is elmúlt már, Pál intette őket: ");
INSERT INTO hun_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","„Férfiak, látom, hogy nemcsak a teherre és a hajóra, hanem a mi életünkre nézve is veszélyes lesz ez a hajózás.“ ");
INSERT INTO hun_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","De a százados inkább hitt a kormányosnak és a hajótulajdonosnak, mint annak, amit Pál mondott. ");
INSERT INTO hun_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Mivel pedig az a kikötő telelésre nem volt alkalmas, a többség azt határozta, hogy hajózzanak el onnan is, hátha valami módon eljutnak Főnixbe, Kréta kikötőjébe, mely délnyugat és északnyugat felé néz, ahol áttelelhetnének. ");
INSERT INTO hun_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Mivel pedig déli szél kezdett lassan fújni, azt gondolták, hogy feltett szándékuknak uraivá lettek, elindultak s Kréta közelében hajóztak el. ");
INSERT INTO hun_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Nem sokára azonban viharos szélvész csapott le oda, amelyet észak-keleti szélnek neveznek. ");
INSERT INTO hun_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Mikor pedig az a hajót magával ragadta, és nem bírt a széllel szembe menni, nekieresztve sodortattunk tovább. ");
INSERT INTO hun_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Mikor pedig egy kis sziget alá futottunk, melyet Klaudának hívnak, alig bírtuk hatalmunkba keríteni a csónakot. ");
INSERT INTO hun_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Miután ezt felvonták, védőintézkedéseket tettek: alul átkötözték a hajót, és mivel féltek, hogy zátonyra bukkannak, leeresztették a vitorlát, és úgy sodródtak tovább. ");
INSERT INTO hun_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Amikor pedig a szélvész nagyon hányt-vetett bennünket, másnap a hajóterhet kidobálták. ");
INSERT INTO hun_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Harmadnap tulajdon kezeinkkel szórtuk ki a hajó felszerelését. ");
INSERT INTO hun_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Amikor pedig több napon át sem nap, sem csillagok nem látszottak, és nem kis vihar szorongatott, életben maradásunk minden reménysége elveszett. ");
INSERT INTO hun_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Amikor pedig már hosszú ideje nem ettek, akkor Pál felállt közöttük, és ezt mondta: „Az lett volna a jó, ó férfiak, hogy engedelmeskedve nekem, nem indultunk volna el Krétából, és elkerültük volna ezt a bajt és kárt. ");
INSERT INTO hun_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Én azonban mostanra nézve is intelek benneteket, hogy jó reménységben legyetek, mert egy lélek sem vész el közületek, csak a hajó. ");
INSERT INTO hun_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Mert ma éjjel mellém állt az Istennek az angyala, akié vagyok, akinek szolgálok is, ");
INSERT INTO hun_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","és ezt mondta: Ne félj Pál, neked a császár elé kell állnod. És íme az Isten ajándékba adta neked mindazokat, akik veled hajóznak. ");
INSERT INTO hun_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Ezért jó reménységben legyetek, férfiak! Mert hiszek az Istennek, hogy úgy lesz, amint nekem megmondta. ");
INSERT INTO hun_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Egy szigetre kell kivetődnünk.“ ");
INSERT INTO hun_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Amikor pedig eljött a tizennegyedik éjszaka, amióta az Adrián hányódtunk, éjféltájban észrevették a hajósok, hogy valami szárazföldhöz közeledünk. ");
INSERT INTO hun_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Lebocsátották a vízmérő ónt, és húsz ölnyinek találták. Majd egy kissé tovább menve ismét lebocsátották a vízmérő ónt, és tizenöt ölnyinek találták. ");
INSERT INTO hun_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Mivel féltek, hogy szirtes helyekre vetődhetnek, a hajónak hátulsó részéből négy vasmacskát vetettek ki, s alig várták, hogy nappal legyen. ");
INSERT INTO hun_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","A hajósok pedig amikor el akartak menekülni a hajóból, a csónakot lebocsátották a tengerre, színlelve, mintha a hajó orrából vasmacskákat akarnának leereszteni. ");
INSERT INTO hun_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Pál azonban ezt mondta a századosnak és a vitézeknek: „Ha ezek nem maradnak a hajóban, akkor ti sem menekülhettek meg.“ ");
INSERT INTO hun_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Ekkor a katonák elvágták a csónak köteleit, és hagyták hogy kiessen. ");
INSERT INTO hun_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Addig pedig, amíg nappal nem lett, Pál bíztatta mindnyájukat, hogy egyenek, és ezt mondva: „Ma tizennegyedik napja, amióta étlen várakoztok, és semmit sem vettetek magatokhoz. ");
INSERT INTO hun_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Ezért intelek benneteket, hogy egyetek, mert ez a ti javatokra szolgál. Mert közületek senkinek sem esik le egyetlen hajszál sem a fejéről.“ ");
INSERT INTO hun_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Mikor pedig ezeket mondta, kezébe vette a kenyeret, hálát adott Istennek mindnyájuk előtt és megtörve, enni kezdett. ");
INSERT INTO hun_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Erre felbátorodtak mindnyájan, és szintén vettek magukhoz táplálékot. ");
INSERT INTO hun_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","A hajóban lélekszám szerint összesen kétszázhetvenhatan voltak. ");
INSERT INTO hun_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Miután pedig megelégedtek az eledellel, a hajót megkönnyebbítették, a gabonát kiszórták a tengerbe. ");
INSERT INTO hun_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Amikor pedig megvirradt, a szárazföldet nem ismerték fel, hanem egy öblöt vettek észre, amelynek sima partja volt, és elhatározták, hogy kihajtják rá a hajót, ha bírják. ");
INSERT INTO hun_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","A vasmacskákat körös-körül elvagdalták, és a tengerben hagyták, egyszersmind eloldották a kormányrudak köteleit, és felvonva a nagy vitorlát a szélfúvás felé, igyekeztek a part felé haladni. ");
INSERT INTO hun_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Amikor azonban egy zátonyos helyre találtak, ráhajtották a hajót. Az első része ugyan megakadt és mozdíthatatlanul maradt, a hátulsó része azonban szakadozott a hullámok ereje miatt. ");
INSERT INTO hun_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","A katonáknak pedig az volt a szándékuk, hogy a foglyokat vágják le, hogy senki el ne szaladhasson, miután kiúszott. ");
INSERT INTO hun_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","De a százados meg akarta tartani Pált, megtiltotta nekik e szándékot és megparancsolta, hogy akik úszni tudnak, először azok ugorjanak a tengerbe, és meneküljenek ki a szárazföldre, ");
INSERT INTO hun_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","a többiek pedig ki deszkákon, ki a hajó egyéb darabjain. Így történt, hogy mindnyájan szerencsésen kimenekültek a szárazföldre. ");
INSERT INTO hun_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Miután szerencsésen megmenekültek, megtudták, hogy Máltának nevezik azt a szigetet. ");
INSERT INTO hun_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","A barbárok pedig nem mindennapi emberséget tanúsítottak irántuk, mert tüzet raktak, és befogadtak mindnyájunkat, a bennünket ért zápor és hideg miatt. ");
INSERT INTO hun_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Amikor pedig Pál sok venyigét szedett, és a tűzre tette, egy vipera a melegből kimászva, a kezére ragadt. ");
INSERT INTO hun_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Amikor pedig látták a barbárok a kezéről függeni a mérges kígyót, azt mondták egymásnak: „Nyilván gyilkos ez az ember, akit nem hagyott élni a bosszúállás, noha a tengerből megszabadult.“ ");
INSERT INTO hun_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","De neki, miután a kígyót lerázta a tűzbe, semmi baja sem lett. ");
INSERT INTO hun_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Azok pedig azt várták, hogy meg fog dagadni, vagy nagy hirtelenséggel halva rogyik le. Mikor azonban sok ideig várták, és látták, hogy semmi baja nem lesz, megváltoztatták véleményüket, és istennek mondták őt. ");
INSERT INTO hun_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Annak a helynek a környékén voltak a sziget főemberének, név szerit Publiusznak mezei jószágai, aki befogadott minket és három napig nagy emberségesen vendégül látott. ");
INSERT INTO hun_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Történt pedig, hogy Publiusz atyja hideglelésben és vérhasban betegen feküdt. Pál bement hozzá, és miután könyörgött, kezeit rátéve meggyógyította őt. ");
INSERT INTO hun_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Miután ez megtörtént, mások is, akik betegek voltak a szigeten, odajöttek hozzá, és meggyógyultak. ");
INSERT INTO hun_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Így nagy tisztességben álltunk, és amikor elindultunk, elláttak minden szükséges dologgal. ");
INSERT INTO hun_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Három hónap múlva azután egy alexandriai hajón elindultunk, amely a szigeten telelt, és amelynek címere Kásztor és Pollux volt. ");
INSERT INTO hun_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Szirakuzába eljutva, ott maradtunk három napig. ");
INSERT INTO hun_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Onnan körülkerülve, eljutottunk Régiumba és mivel egy nap múlva déli szél támadt, másnap megérkeztünk Puteoliba. ");
INSERT INTO hun_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Ahol amikor atyafiakat találtunk, kértek minket, hogy maradjunk náluk hét napig, és úgy mentünk Rómába. ");
INSERT INTO hun_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Onnan is az atyafiak, amikor a dolgainkat meghallották, elénk jöttek Appii Forumig és Tres Tabernaeig. Mikor Pál meglátta őket, hálát adott az Istennek, és eltelt bizalommal. ");
INSERT INTO hun_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Amikor pedig Rómába érkeztünk, a százados átadta a foglyokat a testőrség parancsnokának, Pálnak azonban megengedték, hogy külön lakjon az őt őriző vitézzel. ");
INSERT INTO hun_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Történt pedig, hogy három nap múlva magához hívatta Pál a zsidók ottani vezetőit. Mikor pedig összegyűltek, ezt mondta nekik: „Atyámfiai, férfiak, én jóllehet semmit sem vétkeztem a nép ellen, vagy az ősi szokások ellen, mégis foglyul adtak át Jeruzsálemből a rómaiak kezébe. ");
INSERT INTO hun_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Miután ezek kihallgattak, el akartak bocsátani, mert semmi halálra méltó vétek nincs bennem. ");
INSERT INTO hun_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","De mivel a zsidók tiltakoztak ez ellen, kénytelen voltam a császárhoz föllebbezni, nem mintha a népem ellen volna valami vádam. ");
INSERT INTO hun_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Ezért hívattalak tehát titeket, hogy lássalak benneteket, és beszéljek veletek, mert Izrael reménységéért vettek körül ezzel a lánccal.“ ");
INSERT INTO hun_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Azok pedig ezt mondták neki: „Mi felőled sem levelet nem kaptunk Júdeából, sem pedig az atyafiak közül nem jött ide senki, és nem jelentett, vagy mondott rólad semmi rosszat. ");
INSERT INTO hun_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Szeretnénk azért tőled hallani, milyen véleményen vagy. Mert e felekezet felől tudjuk, hogy mindenütt ellene beszélnek.“ ");
INSERT INTO hun_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Kitűztek tehát neki egy napot, és sokan eljöttek hozzá a szállására, akiknek nagy bizonyságtétellel szólt az Isten országa felől, reggeltől estig igyekezve meggyőzni őket a Jézus felől való dolgokról, úgy a Mózes törvénye, mint a próféták alapján. ");
INSERT INTO hun_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Némelyek hittek az ő beszédének, mások nem hittek. ");
INSERT INTO hun_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Mivel pedig nem egyeztek meg egymással, szétoszlottak, miután Pál ezt a mondatot mondta nekik: „Jól szólott a Szentlélek Ézsaiás próféta által a mi atyáinknak ezt mondva: ");
INSERT INTO hun_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","»Eredj el a néphez és mondd: Hallván halljatok, és ne értsetek; és nézvén nézzetek, és ne lássatok! ");
INSERT INTO hun_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Mert megkövéredett e népnek szíve, és füleikkel nehezen hallanak, és szemeiket behunyják, hogy szemeikkel ne lássanak, füleikkel ne halljanak, szívükkel ne értsenek, és meg ne térjenek, és meg ne gyógyítsam őket.« ");
INSERT INTO hun_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Tudjátok hát meg, hogy a pogányoknak küldetett az Istennek ez üdvössége, és ők meg is hallgatják.“ ");
INSERT INTO hun_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Mikor ezeket mondta, a zsidók maguk között sokat vitatkozva elmentek. ");
INSERT INTO hun_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Pál pedig két egész esztendeig maradt az ő saját bérelt szállásán, és fogadta mindazokat, akik odamentek hozzá. ");
INSERT INTO hun_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Hirdette az Isten országát, és teljes bátorsággal, minden akadály nélkül tanított az Úr Jézus Krisztusról.");
INSERT INTO hun_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Pál, Jézus Krisztusnak szolgája, elhívott apostol, kiválasztva Isten evangéliumának hirdetésére, ");
INSERT INTO hun_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","amelyet eleve megígért az ő prófétái által a szent írásokban, ");
INSERT INTO hun_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","az ő Fia felől, aki Dávid utóda volt test szerint, ");
INSERT INTO hun_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","de aki a szentség Lelke szerint, a halálból való feltámadása által, Isten hatalmas Fiának bizonyult, a mi Urunk Jézus Krisztus felől, ");
INSERT INTO hun_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","aki által kegyelmet és apostolságot kaptunk az ő nevéért, hogy hitre és engedelmességre hívjuk a pogányokat. ");
INSERT INTO hun_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Ezek közé tartoztok ti is, Jézus Krisztus elhívottai. ");
INSERT INTO hun_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Mindenkinek, akik Rómában vagytok, Isten szeretteinek, az elhívott szenteknek: Kegyelem néktek és békesség Istentől, a mi Atyánktól, és az Úr Jézus Krisztustól. ");
INSERT INTO hun_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Először is hálát adok az én Istenemnek, a Jézus Krisztus által, mindnyájatokért, hogy a ti hiteteknek az egész világon híre van, ");
INSERT INTO hun_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","mert tanúm az Isten, akinek lelkem szerint szolgálok az ő Fiának evangéliumával, hogy imádságomban szüntelenül megemlékezem rólatok, ");
INSERT INTO hun_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","könyörögve, hogy egyszer, Isten akaratából, jó szerencsés út adódna nekem, hogy hozzátok mehessek. ");
INSERT INTO hun_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Mert látni kívánlak titeket, hogy valamilyen lelki ajándékot adjak nektek megerősödéstekre, ");
INSERT INTO hun_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","hogy megvigasztalódjunk nálatok egymás hite által, a tiétek, meg az enyém által. ");
INSERT INTO hun_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Nem akarom pedig, atyámfiai, hogy ne tudjátok, hogy sokszor feltettem magamban, hogy elmegyek hozzátok, (de mindeddig megakadályoztattam), hogy közöttetek is nyerjek valami lelki gyümölcsöt, mint más pogány népek között. ");
INSERT INTO hun_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Mind a görögöknek, mind a barbároknak, mind a bölcseknek, mind a tudatlanoknak adósa vagyok. ");
INSERT INTO hun_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Azért, ami rajtam áll, kész vagyok nektek is, akik Rómában vagytok, az evangéliumot hirdetni. ");
INSERT INTO hun_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Mert nem szégyellem a Krisztus evangéliumát, mert Istennek hatalma az, minden hívő üdvösségére, első sorban zsidóknak, de görögöknek is. ");
INSERT INTO hun_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Mert Isten igazsága nyilvánul meg abban hitből hitbe, amiképpen meg van írva: „Az igaz ember hitből él“. ");
INSERT INTO hun_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Mert Isten kinyilvánítja haragját a mennyből az emberek minden hitetlensége és hamissága ellen, akik az igazságot hamissággal feltartóztatják. ");
INSERT INTO hun_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Mert ami Isten felől tudható, az nyilvánvaló előttük, mert Isten nyilvánvalóvá tette számukra. ");
INSERT INTO hun_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Mert ami Istenben láthatatlan, tudniillik az ő örökkévaló hatalma és istensége, a világ teremtése óta alkotásaiból megérthető és látható. Ezért menthetetlenek. ");
INSERT INTO hun_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Mert bár Istent megismerték, mégsem mint Istent dicsőítették, hálát sem adtak neki, hanem okoskodásaikban hiábavalóságokra jutottak, és balgatag szívük elsötétedett. ");
INSERT INTO hun_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Magukat bölcsnek vallva, balgává lettek. ");
INSERT INTO hun_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Az örökkévaló Isten dicsőségét felcserélték mulandó embereknek, madaraknak, négylábú állatoknak és csúszó-mászó állatoknak képmásával. ");
INSERT INTO hun_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Ezért Isten kiszolgáltatta őket szívük kívánságai szerint a tisztátalanságnak, hogy egymás testét megbecstelenítsék. ");
INSERT INTO hun_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Mint akik Isten igazságát hazugsággá változtatták, és a teremtett dolgokat tisztelték és szolgálták a Teremtő helyett, aki mindörökké áldott! Ámen. ");
INSERT INTO hun_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Ezért Isten kiszolgáltatta őket tisztátalan indulatoknak. Asszonyaik a természet rendjét természetellenesre cserélték fel. ");
INSERT INTO hun_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Hasonlóképen a férfiak is elhagyták az asszonyokkal való természetes érintkezést, egymás iránt gerjedtek fel bujaságukban, férfiak férfiakkal fajtalankodtak. El is vették önmagukban tévelygésük méltó büntetését. ");
INSERT INTO hun_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Ahogyan Istent nem méltatták arra, hogy ismeretükben megtartsák, úgy Isten is kiszolgáltatta őket romlott gondolkodásuknak, hogy alávaló dolgokat cselekedjenek. ");
INSERT INTO hun_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Ezért tele is vannak mindenféle hamissággal, paráznasággal, gonoszsággal, kapzsisággal, rosszasággal, irigységgel, gyilkos indulattal, versengéssel, álnoksággal, rossz erkölccsel. ");
INSERT INTO hun_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","Besúgók, rágalmazók, istengyűlölők, dölyfösek, kevélyek, dicsekedők, rosszban mesterkedők, szüleiknek engedetlenek, ");
INSERT INTO hun_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","balgatagok, összeférhetetlenek, szeretet nélkül valók, engesztelhetetlenek, irgalmatlanok. ");
INSERT INTO hun_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Noha ismerik Isten végzését, hogy akik ilyeneket cselekesznek méltók a halálra, mégis megteszik mindezt, sőt egyet is értenek azokkal, akik ugyancsak így cselekszenek. ");
INSERT INTO hun_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Ezért menthetetlen vagy, ó, ember, bárki légy, aki ítélsz, mert amiben mást megítélsz, abban önmagadat is kárhoztatod, mert ugyanúgy cselekszel te is, aki ítélsz. ");
INSERT INTO hun_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Tudjuk pedig, hogy Isten igazságosan ítéli meg azokat, akik ilyeneket cselekszenek. ");
INSERT INTO hun_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Vagy azt gondolod, ó, ember, aki megítéled azokat, akik ilyeneket cselekszenek, és te is azokat cselekszed, hogy te elkerülöd Isten ítéletét? ");
INSERT INTO hun_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Vagy megveted Isten jóságának, elnézésnek, hosszútűrésének gazdagságát, nem tudva, hogy Isten jósága téged megtérésre indít? ");
INSERT INTO hun_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","De te, meg nem tért szíved keménysége szerint haragot gyűjtesz magadnak a haragnak napjára, amikor Isten igazságos ítélete nyilvánvalóvá lesz. ");
INSERT INTO hun_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Isten mindenkinek cselekedete szerint fizet meg. ");
INSERT INTO hun_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Örök élettel azoknak, akik állhatatosan jót cselekedve dicsőséget, tisztességet és halhatatlanságot keresnek. ");
INSERT INTO hun_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Azoknak pedig, akik viszálykodók és nem engednek az igazságnak, hanem engednek a hamisságnak, megfizet majd ítéletének haragjával. ");
INSERT INTO hun_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Nyomorúság és szorongattatás lesz része mindenkinek, aki gonoszságot cselekszik, első sorban zsidónak, de görögnek is. ");
INSERT INTO hun_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Dicsőség, tisztesség és békesség mindenkinek, aki jót cselekszik, elsősorban zsidónak, de görögnek is. ");
INSERT INTO hun_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Isten nem személyválogató. ");
INSERT INTO hun_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Akik a törvény ismerete nélkül vétkeztek, azok a törvény nélkül vesznek el. Akik pedig a törvény ismeretében vétkeztek, a törvény által ítéltetnek meg. ");
INSERT INTO hun_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Mert nem azok igazak Isten előtt, akik a törvényt hallgatják, hanem azok fognak megigazulni, akik a törvényt betöltik. ");
INSERT INTO hun_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Mert amikor a pogányok, akiknek törvényük nincsen, akik nem ismerik a törvényt, mégis természetszerűleg teszik azt, amit a törvény követel, akkor ők, bár törvényük nincsen, önmaguknak lettek a törvénye. ");
INSERT INTO hun_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Ezzel megmutatják, hogy a törvény által követelt cselekedet a szívükbe van írva. Erről tesz bizonyságot lelkiismeretük. Egymást kölcsönösen vádoló vagy felmentő gondolataik is erről tanúskodnak majd ");
INSERT INTO hun_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","azon a napon, amelyen Isten megítéli az emberek gondolatait, az én evangéliumom szerint Jézus Krisztus által. ");
INSERT INTO hun_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","De te zsidónak mondod magad, és Isten törvényére támaszkodsz, és Istennel dicsekszel, ");
INSERT INTO hun_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","hogy ismered az ő akaratát, és választást tudsz tenni jó és rossz között, mert ismered Isten akaratát, mert törvényéből ezt megtanultad. ");
INSERT INTO hun_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Azt gondolod magadról, hogy te vakok vezetője, a sötétségben lévőknek világossága, ");
INSERT INTO hun_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","a balgatagok tanítója, a kiskorúak mestere vagy, mert tied a törvény ismerete és igazsága. ");
INSERT INTO hun_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Ha mást tanítasz, magadat nem tanítod-e? Aki azt hirdeted, hogy ne lopj, nem lopsz-e? ");
INSERT INTO hun_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Aki azt mondod, ne paráználkodj, nem paráználkodol-e? Aki utálod a bálványokat, nem vagy-e szentségtörő? ");
INSERT INTO hun_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Aki a törvény ismeretével dicsekedsz, nem gyalázod-e Istent a törvény megszegésével? ");
INSERT INTO hun_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Amint meg van írva: „Miattatok káromolják Isten nevét a pogányok között.“ ");
INSERT INTO hun_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","A körülmetélkedés használ, ha a törvényt megtartod. De ha a törvényt áthágod, a te körlülmetélkedésed körülmetéletlenséggé lett. ");
INSERT INTO hun_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Ha tehát a körülmetéletlen pogány megtartja a törvény parancsait, az ő körülmetéletlensége nem számít-e körülmetéltségnek? ");
INSERT INTO hun_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","A körülmetéletlen ember, aki a törvényt megtartja, megítél téged, aki a törvény betűjének ismerete és a körülmetélkedés ellenére is a törvény megrontója vagy. ");
INSERT INTO hun_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Mert nem az a zsidó, aki külsőképpen az. Nem az a körülmetélés, ami a testen külsőképpen látszik. ");
INSERT INTO hun_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Az a zsidó, aki belsőképpen az. A szívnek lélekben, nem betű szerint való körülmetélése az igazi körülmetélkedés. Ennek dicsérete nem embertől, hanem Istentől van. ");
INSERT INTO hun_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Mennyiben különb hát a zsidó? Vagy micsoda haszna van a körülmetélkedésnek? ");
INSERT INTO hun_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Minden tekintetben sok. Mindenek előtt az, hogy Isten rájuk bízta beszédét. ");
INSERT INTO hun_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","De hát, ha némelyek nem hittek? Vajon azoknak hitetlensége nem teszi-e hiábavalóvá Isten hűségét? ");
INSERT INTO hun_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Semmiképpen! Sőt, Isten az igaz, minden ember pedig hazug, amint meg van írva: „(az Úr) igaznak bizonyul minden beszédében és győzedelmes, amikor vádolják őt.“ ");
INSERT INTO hun_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Ha pedig a mi igazságtalanságunk Isten igazságát mutatja meg, akkor mit mondjunk? Vajon igazságtalan-e Isten, hogy minket büntet? Emberi módon szólok. ");
INSERT INTO hun_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Semmiképpen! Mert akkor hogyan ítélhetné meg Isten a világot? ");
INSERT INTO hun_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Mert ha Isten igazságát az én hazugságom fokozza az ő dicsőségére, miért kárhoztattatom én mégis, mint bűnös? ");
INSERT INTO hun_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Ne cselekedjünk-e akkor inkább a rosszat, hogy abból jó származzék? – amint rágalmaznak minket és mondogatják, hogy mi így beszélünk. Ezeknek kárhoztatása igazságos. ");
INSERT INTO hun_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Hogyan van tehát? Különbek vagyunk? Semmiképpen. Hiszen az előbb már nyilvánvalóvá tettük, hogy zsidók és görögök egyaránt mind bűnben vannak, ");
INSERT INTO hun_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","amint meg van írva: „Nincs egyetlen igaz ember sem. ");
INSERT INTO hun_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Nincs, aki megértse, nincs, aki keresse Istent. ");
INSERT INTO hun_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Mindnyájan elhajlottak, valamennyien haszontalanokká lettek. Nincs, aki jót cselekedjék, egyetlen egy sem. ");
INSERT INTO hun_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Nyitott sír a torkuk, nyelvükkel álnokságot szólnak. Áspis kígyó mérge van ajkuk alatt. ");
INSERT INTO hun_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Szájuk tele van átkozódással és keserűséggel. ");
INSERT INTO hun_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Lábuk gyors a vérontásra. ");
INSERT INTO hun_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Útjaikon romlás és nyomorúság van. ");
INSERT INTO hun_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","A békesség útját pedig nem ismerik. ");
INSERT INTO hun_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Nincs Isten félelme a szemük előtt.“ ");
INSERT INTO hun_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Azt pedig tudjuk, hogy amit a törvény mond, azoknak mondja, akik a törvény alatt vannak, hogy elnémuljon minden száj, és az egész világ Isten ítélete alá kerüljön. ");
INSERT INTO hun_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","A törvény cselekedeteiből tehát senki sem igazulhat meg Isten előtt. A törvény csak a bűn felismerésére való. ");
INSERT INTO hun_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Most pedig törvény nélkül jelent meg Isten igazsága, amelyről tanúbizonyságot tesznek a törvény és a próféták. ");
INSERT INTO hun_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Istennek ebben az igazságában a Jézus Krisztusban való hit által részesülnek mindazok, akik hisznek. Mert nincs különbség: ");
INSERT INTO hun_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Mindnyájan vétkeztek és nincs részük Isten dicsőségében. ");
INSERT INTO hun_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","De megigazulnak Isten ingyen kegyelméből a Krisztus Jézusban való váltság által, ");
INSERT INTO hun_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","akit Isten engesztelő áldozatul rendelt, hogy akik vérében hisznek, meglássák igazságát. Isten a korábban elkövetett bűnöket elnézte ");
INSERT INTO hun_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","hosszútűrésében, hogy e mostani időben bizonyítsa igazságát, hogy ő igaz, és megigazítja azokat, akik Jézusban hisznek. ");
INSERT INTO hun_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Hol van tehát a dicsekedés? Lehetetlenné lett. Milyen törvény által? A cselekedeteké által? Nem, hanem a hit törvénye által. ");
INSERT INTO hun_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Azt tartjuk tehát, hogy az ember hit által igazul meg, a törvény cselekedete nélkül. ");
INSERT INTO hun_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Vagy Isten csak a zsidóké? Nem a pogányoké is? Bizony a pogányoké is. ");
INSERT INTO hun_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Mert egy az Isten, aki megigazítja a zsidót hitből, a pogányt pedig hit által. ");
INSERT INTO hun_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","A törvényt tehát hiábavalóvá tesszük a hit által? Semmiképpen. Sőt inkább a törvényt megerősítjük. ");
INSERT INTO hun_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Mit mondjunk tehát, hogy Ábrahám, a mi atyánk nyert volna valamit, test szerint? ");
INSERT INTO hun_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Mert ha Ábrahám cselekedetekből igazult meg, van mivel dicsekedjék, de nem az Isten előtt. ");
INSERT INTO hun_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Mert mit mond az Írás? Ábrahám hitt Istennek, és ez tulajdoníttaték neki igazságul. ");
INSERT INTO hun_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Annak pedig, aki munkálkodik, a jutalom nem tulajdoníttatik kegyelemből, hanem tartozás szerint. ");
INSERT INTO hun_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Ellenben annak, aki nem munkálkodik, hanem hisz abban, aki az istentelent megigazítja, az ő hite tulajdoníttatik igazságul. ");
INSERT INTO hun_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Amint Dávid is boldognak mondja azt az embert, akinek Isten cselekedetek nélkül tulajdonít igazságot. ");
INSERT INTO hun_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","„Boldogok, akiknek hamissága megbocsáttatott, és akiknek vétke elfedeztetett. ");
INSERT INTO hun_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Boldog ember az, akinek az Úr bűnt nem tulajdonít.“ ");
INSERT INTO hun_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Vajon ez a boldogság csak a zsidóké, vagy a pogányoké is? Hiszen azt mondjuk, hogy Ábrahámnak a hit tulajdonítatott igazságul. ");
INSERT INTO hun_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Tehát miképpen tulajdoníttatott? Körülmetélt vagy körülmetéletlen állapotában? Nem körülmetélt, hanem körülmetéletlen állapotában. ");
INSERT INTO hun_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","És a körülmetélkedés jegyét körülmetéletlenségében tanúsított hite igazságának pecsétjéül nyerte, hogy atyja legyen mindazoknak, akik körülmetéletlen létükre hisznek, hogy azoknak is tulajdoníttassék igazság. ");
INSERT INTO hun_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","És atyja legyen a körülmetélteknek is, azoknak is, akik nemcsak körülmetélkednek, hanem követik is Ábrahámnak körülmetéletlenségében tanúsított hite nyomdokait. ");
INSERT INTO hun_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Mert nem a törvény által adatott az ígéret Ábrahámnak vagy az ő utódának, hogy a világ örököse lesz, hanem a hitnek igazsága által. ");
INSERT INTO hun_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Mert ha azok az örökösök, akik a törvényből valók, akkor hiábavalóvá lett a hit, és haszontalanná az ígéret. ");
INSERT INTO hun_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Mert a törvény haragot szül. Ahol azonban nincs törvény, ott törvény ellen való cselekedet sincs. ");
INSERT INTO hun_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Azért, hitből, hogy kegyelemből legyen, és bizonyos legyen az ígéret Ábrahám minden utódjának. Nemcsak a törvényből valóknak, hanem Ábrahám hitéből valóknak is, aki mindnyájunknak atyja, ");
INSERT INTO hun_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","(Amint meg van írva: „Sok nép atyjává tettelek téged“) az előtt az Isten előtt, akiben hitt, aki a halottakat megeleveníti, és létre hívja a nem létezőket. ");
INSERT INTO hun_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Aki reménység ellenére reménykedve hitte, hogy sok nép atyjává lesz, ahogyan megmondatott: Ennyi utódod lesz! ");
INSERT INTO hun_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","És hitében erős volt, nem gondolt életerejét elvesztett testére, pedig már száz esztendős volt, sem Sárának elhalt méhére, ");
INSERT INTO hun_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","az Isten ígéretében sem kételkedett hitetlenséggel, hanem erős volt a hitben dicsőséget adva Istennek, ");
INSERT INTO hun_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","teljesen elhitte, hogy amit ő megígért, azt meg is cselekedheti. ");
INSERT INTO hun_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Ezért is tulajdoníttatott ez neki igazságul. ");
INSERT INTO hun_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","De nemcsak őérette íratott meg, hogy „tulajdoníttatott neki igazságul“, ");
INSERT INTO hun_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","hanem miértünk is, akiknek majd tulajdoníttatik, azoknak tudniillik, akik hisznek abban, aki feltámasztotta a mi Urunkat, Jézust a halálból, ");
INSERT INTO hun_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","aki a mi bűneinkért halálra adatott, és feltámasztatott a mi megigazulásunkért. ");
INSERT INTO hun_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Megigazulván azért hit által, békességünk van Istennel, a mi Urunk Jézus Krisztus által, ");
INSERT INTO hun_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","aki által utunk nyílt a hitben ahhoz a kegyelemhez, amelyben állunk, és dicsekszünk az Isten dicsőségének reménységével. ");
INSERT INTO hun_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","De dicsekedünk még a háborúságokban is, tudva, hogy a háborúság béketűrést szül, ");
INSERT INTO hun_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","a béketűrés próbatételt, a próbatétel pedig reménységet. ");
INSERT INTO hun_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","A reménység pedig nem szégyenít meg, mert az Isten szeretete kitöltetett a mi szívünkbe a Szentlélek által, aki adatott nekünk. ");
INSERT INTO hun_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Mert Krisztus, amikor még erőtlenek voltunk, a rendelt időben meghalt a gonoszokért. ");
INSERT INTO hun_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Bizonyára az igazért is aligha halna meg valaki. Ám a jóért talán még meg merne halni valaki. ");
INSERT INTO hun_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Isten pedig az irántunk való szeretetét abban mutatta meg, hogy amikor még bűnösök voltunk, Krisztus értünk meghalt. ");
INSERT INTO hun_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Miután azért most megigazultunk az ő vére által, sokkal inkább megtartatunk a harag ellen általa. ");
INSERT INTO hun_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Mert ha amikor ellenségei voltunk, megbékéltünk Istennel az ő Fiának halála által, sokkal inkább megtartanunk az ő élete által, miután megbékéltünk vele. ");
INSERT INTO hun_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Sőt ezen túl még dicsekszünk is az Istenben a mi Urunk Jézus Krisztus által, aki által most megbékélést nyertünk. ");
INSERT INTO hun_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Ahogyan tehát egy ember által jött be a világra a bűn és a bűn által a halál, úgy a halál minden emberre elhatott, mivel mindnyájan vétkeztek. ");
INSERT INTO hun_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Volt ugyan bűn a törvény előtt is. A bűn azonban nem számíttatik be, ha nincsen törvény. ");
INSERT INTO hun_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Mégis a halál uralkodott Ádámtól Mózesig, azokon is, akik nem Ádám esetéhez hasonlóan vétkeztek, aki az Eljövendőnek előképe volt. ");
INSERT INTO hun_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","De a kegyelmi ajándék nem úgy van, mint a bűneset. Mert ha annak az egynek bűnesete miatt sokan haltak meg, az Isten kegyelme és ajándéka, az egy embernek, Jézus Krisztusnak kegyelméből sokkal inkább elhatott sokakra. ");
INSERT INTO hun_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","És az ajándék sem ugyan olyan, mint az egy ember bűnesete. Az ítélet ugyanis egy ember bűnesete miatt lett kárhozattá, az ajándék pedig sok bűnből lett megigazulásra. ");
INSERT INTO hun_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Mert ha az egynek bűnesete miatt uralkodott a halál az egy által, sokkal inkább az életben uralkodnak az egy Jézus Krisztus által azok, akik kegyelmének és az igazság ajándékának bőségében részesültek. ");
INSERT INTO hun_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Bizonyára azért, ahogyan egynek bűnesete által minden emberre elhatott a kárhozat, úgy egynek igazsága által minden emberre elhatott az élet megigazulása. ");
INSERT INTO hun_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Mert ahogy egy embernek engedetlensége által sokan bűnösökké lettek, úgy egynek engedelmessége által sokan igazakká lesznek. ");
INSERT INTO hun_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","A törvény pedig közbejött, hogy a bűn megnövekedjék. De ahol megnövekedik a bűn, a kegyelem sokkal inkább bőségesen árad, ");
INSERT INTO hun_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","hogy amiképpen uralkodott a bűn a halálra, úgy a kegyelem is uralkodjék az igazság által az örök életre, a mi Urunk Jézus Krisztus által. ");
INSERT INTO hun_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Mit mondjunk tehát? Megmaradjunk-e a bűnben, hogy a kegyelem annál nagyobb legyen? ");
INSERT INTO hun_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Semmiképpen! Ha meghaltunk a bűnnek, hogyan élhetnénk még benne? ");
INSERT INTO hun_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Vagy nem tudjátok, hogy akik megkeresztelkedtünk a Krisztus Jézusba, az ő halálába keresztelkedtünk meg? ");
INSERT INTO hun_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Eltemettettünk azért ő vele együtt a keresztség által a halálba, hogy amiképpen feltámasztatott Krisztus a halálból az Atyának dicsősége által, azonképpen mi is új életben járjunk. ");
INSERT INTO hun_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Mert ha az ő halálának hasonlatossága szerint vele eggyé lettünk, bizonyára a feltámadásáé szerint is azok leszünk. ");
INSERT INTO hun_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Tudva azt, hogy a mi óemberünk vele együtt megfeszítetett, hogy megerőtlenüljön a bűnös test, hogy ezután ne szolgáljunk a bűnnek. ");
INSERT INTO hun_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Mert aki meghalt, felszabadult a bűn alól. ");
INSERT INTO hun_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Hogyha pedig meghaltunk Krisztussal, hisszük, hogy élünk is vele. ");
INSERT INTO hun_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Tudva, hogy Krisztus feltámadott a halálból, többé meg nem hal, a halál többé rajta nem uralkodik. ");
INSERT INTO hun_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Mert hogy meghalt, egyszer s mindenkorra meghalt a bűnnek, hogy pedig él, az Istennek él. ");
INSERT INTO hun_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Így gondoljátok ti is, hogy meghaltatok a bűnnek, de éltek Istennek, a mi Urunk Jézus Krisztusban. ");
INSERT INTO hun_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Ne uralkodjék tehát a bűn a ti halandó testetekben, hogy engedjetek kívánságainak. ");
INSERT INTO hun_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","És ne szánjátok oda tagjaitokat a hamisságnak fegyvereiül a bűnnek, hanem szánjátok oda magatokat Istennek, mint akik a halálból életre keltetek, és tagjaitokat adjátok az igazság fegyvereiül az Istennek. ");
INSERT INTO hun_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Mert a bűn rajtatok nem uralkodik, mert nem vagytok a törvény alatt, hanem a kegyelem alatt. ");
INSERT INTO hun_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Mi következik ebből? Vétkezzünk-e, mivel nem a törvény alatt, hanem a kegyelem alatt vagyunk? Semmiképpen! ");
INSERT INTO hun_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Nem tudjátok-e, hogy akinek odaadjátok magatokat szolgákul az engedelmességre, annak vagytok a szolgái: vagy a bűnnek a halálra, vagy az engedelmességnek az igazságra? ");
INSERT INTO hun_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","De hála az Istennek, hogy jóllehet a bűn szolgái voltatok, de szívetek szerint engedelmeskedtetek annak a tanításnak, amelyre oktattatok. ");
INSERT INTO hun_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Felszabadulva pedig a bűn alól, az igazságnak szolgáivá lettetek. ");
INSERT INTO hun_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Emberi módón szólok erőtlenségetek miatt. Ahogyan odaszántátok magatokat a tisztátalanságnak és hamisságnak, a hamisság szolgálatára, úgy szánjátok oda most magatokat az igazság szolgálatára, hogy szentek legyetek. ");
INSERT INTO hun_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Mert amikor a bűn szolgái voltatok, az igazságtól szabadok voltatok. ");
INSERT INTO hun_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Micsoda gyümölcsöt termett ez akkor nektek? Most csak szégyenkeztek miatta! Mert azoknak a vége halál. ");
INSERT INTO hun_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Most pedig, hogy felszabadultatok a bűn alól és Isten szolgáivá lettetek, megvan a gyümölcsötök, a szent élet, amelynek vége az örök élet. ");
INSERT INTO hun_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Mert a bűn zsoldja a halál, Isten kegyelmi ajándéka pedig az örök élet a mi Urunk Jézus Krisztus által. ");
INSERT INTO hun_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Vagy nem tudjátok, atyámfiai, – mert a törvényt ismerőkhöz szólok – hogy a törvény uralkodik az emberen, amíg él? ");
INSERT INTO hun_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Mert a férjes asszony, amíg él férje, hozzá van kötve a törvény szerint, de ha meghal a férje, felszabadul az asszony a törvény alól, amely férjéhez kötötte. ");
INSERT INTO hun_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Azért tehát paráznának mondják, ha férje életében más férfihoz megy, ha azonban a férje meghal, szabaddá lesz a törvénytől, úgy hogy nem lesz parázna, ha más férfihoz megy. ");
INSERT INTO hun_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Azért, atyámfiai, ti is meghaltatok a törvénynek a Krisztus teste által, hogy máséi legyetek, azéi, aki a halálból feltámasztatott, hogy gyümölcsöt teremjünk Istennek. ");
INSERT INTO hun_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Mert amikor testben voltunk, a törvény által ébresztett bűnös indulatok uralkodtak rajtunk, hogy a halálnak gyümölcsözzenek. ");
INSERT INTO hun_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Most pedig megszabadultunk a törvénytől, minthogy meghaltunk arra nézve, ami eddig fogva tartott, hogy szolgáljunk a Lélek újságában és nem a betű óságában. ");
INSERT INTO hun_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Mit mondunk tehát? A törvény bűn? Semmiképpen! Hiszen a bűnt csak a törvény által ismertem meg, mert a gonosz kívánságról sem tudtam volna, ha a törvény nem mondaná: „Ne kívánd!“ ");
INSERT INTO hun_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","De a bűn a parancsolat által alkalmat talált arra, hogy bennem gonosz kívánságot ébresszen, mert törvény nélkül a bűn halott. ");
INSERT INTO hun_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Régen törvény nélkül éltem, de a parancsolat eljöttével, felelevenedett a bűn, ");
INSERT INTO hun_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","én pedig meghaltam. Így az a parancsolat, amely életre való, nekem halálomra lett. ");
INSERT INTO hun_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Mert a bűn felhasználta az alkalmat és a parancsolat által megcsalt és megölt. ");
INSERT INTO hun_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","De azért a törvény szent, és a parancsolat is szent és igaz és jó. ");
INSERT INTO hun_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Tehát ami jó, az lett halálommá? Semmiképpen! Inkább a bűn, hogy bűn volta nyilvánvalóvá legyen, hogy a jó által szerez nekem halált, hogy felettébb bűnös legyen a bűn a parancsolat által. ");
INSERT INTO hun_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Mert tudjuk, hogy a törvény lelki, de én testi vagyok a bűn alá rekesztve. ");
INSERT INTO hun_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Mert amit cselekszem, nem ismerem. Mert nem azt teszem, amit akarok, hanem amit gyűlölök, azt cselekszem. ");
INSERT INTO hun_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Ha pedig azt cselekszem, amit nem akarok, megegyezem a törvénnyel, hogy jó. ");
INSERT INTO hun_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Most azért már nem én cselekszem azt, hanem a bennem lakozó bűn. ");
INSERT INTO hun_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Mert tudom, hogy nem lakik bennem, azaz az én testemben jó. Mert az akarás megvan ugyan bennem, de a jót véghez vinni nem tudom. ");
INSERT INTO hun_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Mert nem a jót cselekszem, amit akarok, hanem a gonoszt cselekszem, amit nem akarok. ");
INSERT INTO hun_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Ha pedig azt cselekszem, amit nem akarok, nem én teszem azt, hanem a bennem lakó bűn. ");
INSERT INTO hun_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Megtalálom azért magamban ezt a törvényt: noha a jót akarom cselekedni, mégis a rosszat teszem. ");
INSERT INTO hun_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Mert gyönyörködöm ugyan Isten törvényében a belső ember szerint, ");
INSERT INTO hun_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","de látok egy másik törvényt tagjaimban, amely ellenkezik elmém törvényével és rabul ad a bűn törvényének, amely tagjaimban van. ");
INSERT INTO hun_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Ó, én nyomorult ember! Kicsoda szabadít meg engem e halálra ítélt testből? ");
INSERT INTO hun_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","De hálát adok Istennek, a mi Urunk Jézus Krisztus által. Bár elmémmel az Isten törvényének, testemmel azonban a bűn törvényének szolgálok. ");
INSERT INTO hun_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Nincsen azért már semmi kárhoztatásuk azoknak, akik a Krisztus Jézusban vannak, akik nem test szerint járnak, hanem Lélek szerint. ");
INSERT INTO hun_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Mert az élet Lelkének törvénye megszabadított engem Jézus Krisztus által a bűn és halál törvényétől. ");
INSERT INTO hun_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Mert ami a törvénynek lehetetlen volt, mivel erőtlen volt a test miatt, Isten az ő Fiát elküldte a bűnös testhez hasonló formában a bűn miatt, és kárhoztatta a bűnt a testben. ");
INSERT INTO hun_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Hogy a törvény igazsága beteljesüljön bennünk, akik nem test szerint járunk, hanem Lélek szerint. ");
INSERT INTO hun_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Mert akik test szerint élnek, a test dolgaira gondolnak, akik pedig Lélek szerint élnek, a Lélek dolgaira. ");
INSERT INTO hun_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Mert a test törekvése halál. A Lélek törekvése pedig élet és békesség. ");
INSERT INTO hun_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Mert a test törekvése ellenségeskedés Istennel, mert Isten törvényének nem engedelmeskedik, mert nem is teheti. ");
INSERT INTO hun_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Akik test szerint élnek nem lehetnek kedvesek Isten előtt. ");
INSERT INTO hun_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","De ti nem test szerint éltek, hanem Lélek szerint, ha ugyan Isten Lelke lakik bennetek. Akiben pedig nincs a Krisztus Lelke, az nem az övé. ");
INSERT INTO hun_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Ha pedig Krisztus bennetek van, bár a test halott a bűn miatt, a lélek ellenben él a megigazulás által. ");
INSERT INTO hun_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Ha annak Lelke lakik bennetek, aki feltámasztotta Jézust a halálból, akkor az, aki feltámasztotta Jézust a halálból, megeleveníti a ti halandó testeteket is az ő bennetek lakó Lelke által. ");
INSERT INTO hun_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Ezért, atyámfiai nem vagyunk adósok a testnek, hogy test szerint éljünk. ");
INSERT INTO hun_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Mert ha test szerint éltek meghaltok, de ha a test cselekedeteit a Lélekkel megölitek, élni fogtok. ");
INSERT INTO hun_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Mert akiket Isten Lelke vezérel, azok Isten gyermekei. ");
INSERT INTO hun_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Mert nem a szolgaság lelkét kaptátok, hogy ismét félnetek kelljen, hanem a fiúság Lelkét kaptátok, aki által kiáltjuk: Abbá, Atyám! ");
INSERT INTO hun_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Maga a Lélek tesz bizonyságot a mi lelkünkkel együtt, hogy Isten gyermekei vagyunk. ");
INSERT INTO hun_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Ha pedig gyermekek, akkor örökösök is, örökösei Istennek és örököstársai Krisztusnak, ha vele együtt szenvedünk, hogy vele együtt dicsőüljünk is meg. ");
INSERT INTO hun_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Mert azt tartom, hogy amiket most szenvedünk nem hasonlíthatók ahhoz a dicsőséghez, amely majd nyilvánvalóvá lesz rajtunk. ");
INSERT INTO hun_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Mert a teremtett világ sóvárogva várja az Isten fiainak megjelenését. ");
INSERT INTO hun_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Mert a termetett világ hiábavalóság alá vettetett, de nem önként, hanem az által, aki alávetette, ");
INSERT INTO hun_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","azzal a reménységgel, hogy maga a teremtett világ is megszabadul a romlandóság rabságából az Isten gyermekeinek dicsőséges szabadságára. ");
INSERT INTO hun_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Mert tudjuk, hogy az egész teremtett világ együtt nyög és vajúdik mind ez ideig. ");
INSERT INTO hun_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","De nemcsak ez a világ, hanem maguk a Lélek zsengéjének birtokosai, mi magunk is fohászkodunk magunkban várva a fiúságot, testünk megváltását. ");
INSERT INTO hun_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Mert reménységben tartattunk meg, a reménység pedig, ha látható, nem reménység, mert amit lát valaki, miért remélné azt? ");
INSERT INTO hun_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Ha pedig, amit nem látunk, azt reméljük, békességes tűréssel várjuk. ");
INSERT INTO hun_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Hasonlóképen a Lélek is segítségére van a mi erőtlenségünknek. Mert azt, amit kérnünk kell, nem tudjuk úgy, ahogy kellene, de maga a Lélek esedezik értünk kimondhatatlan fohászkodásokkal. ");
INSERT INTO hun_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Aki pedig a szíveket vizsgálja, tudja, mi a Lélek gondolata, mert Isten szerint esedezik a szentekért. ");
INSERT INTO hun_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Tudjuk pedig, hogy azoknak, akik Isten szeretik, minden javukra van, mint akik az ő végzése szerint elhívottak. ");
INSERT INTO hun_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Mert akiket eleve kiválasztott, azokat eleve el is rendelte, hogy hasonlók legyenek Fia képmásához, hogy ő legyen az elsőszülött sok atyafi között. ");
INSERT INTO hun_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Akiket pedig eleve elrendelt, azokat el is hívta; és akiket elhívott, azokat meg is igazította, akiket pedig megigazított, azokat meg is dicsőítette. ");
INSERT INTO hun_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Mit mondjunk azért ezekre? Ha Isten velünk, kicsoda ellenünk? ");
INSERT INTO hun_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Aki az ő tulajdon Fiának nem kedvezett, hanem őt mindnyájunkért odaadta, hogyne ajándékozna vele együtt mindent nekünk? ");
INSERT INTO hun_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Kicsoda vádolja az Isten választottait? Isten az, aki megigazít. ");
INSERT INTO hun_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Kicsoda az, aki kárhoztat? Krisztus az, aki meghalt, sőt aki fel is támadott, aki az Isten jobbján van, aki esedezik értünk. ");
INSERT INTO hun_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Kicsoda szakít el minket Krisztus szeretetétől? Nyomorúság vagy szorongattatás, vagy üldözés, vagy éhség, vagy mezítelenség, vagy veszedelem, vagy fegyver? ");
INSERT INTO hun_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Amint meg van írva: „Éretted gyilkoltatunk minden napon, úgy tekintenek minket, mint vágó juhokat.“ ");
INSERT INTO hun_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","De mindezekben diadalmaskodunk, az által, aki minket szeretett. ");
INSERT INTO hun_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Mert meg vagyok győződve, hogy sem halál, sem élet, sem angyalok, sem fejedelemségek, sem hatalmasságok, sem jelenvalók, sem következendők, ");
INSERT INTO hun_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","sem magasság, sem mélység, sem semmi más teremtmény nem szakíthat el minket Isten szeretetétől, amely a mi Urunkban, Jézus Krisztusban van. ");
INSERT INTO hun_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Igazságot szólok Krisztusban, nem hazudok, lelkiismeretem velem együtt tesz bizonyságot a Szent Lélek által, ");
INSERT INTO hun_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","hogy nagy az én szomorúságom és szüntelen való az én szívem fájdalma, ");
INSERT INTO hun_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","mert kívánnám, hogy inkább én lennék átkozott, Krisztustól elszakítva, az én atyámfiaiért, test szerint való rokonaimért, ");
INSERT INTO hun_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","akik izraeliták, akiké a fiúság és a dicsőség és a szövetségek, meg a törvényadás és az istentisztelet és az ígéretek ");
INSERT INTO hun_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","akiké az atyák, és akik közül való test szerint a Krisztus, aki mindenekfelett örökké áldandó Isten, Ámen. ");
INSERT INTO hun_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Az pedig nem lehet, hogy Isten beszéde meghiúsuljon. Mert nem mindnyájan izraeliták, akik Izraeltől valók, ");
INSERT INTO hun_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","és nem mindnyájan Ábrahám gyermekei, akik az ő utódai, hanem amint meg van írva: „Aki Izsáktól származik, azt nevezik majd utódodnak.“ ");
INSERT INTO hun_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Azaz nem a testi származás szerinti utódok az Isten gyermekei, hanem az ígéret gyermekei számítanak az ő utódainak. ");
INSERT INTO hun_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Mert az ígéretnek beszéde ez: „abban az időben eljövök és Sárának fia lesz.“ ");
INSERT INTO hun_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","De nemcsak ő, hanem Rebeka is példa, aki egytől fogant méhében, Izsáktól, a mi Atyánktól. ");
INSERT INTO hun_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","Még amikor meg sem születtek fiai, és semmi jót vagy gonoszt nem cselekedtek, – hogy Istennek kiválasztás szerint való végzése megálljon, nem cselekedetekből, hanem az elhívó akarata szerint, – ");
INSERT INTO hun_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","megmondatott neki, hogy a nagyobbik szolgál majd a kisebbnek, ");
INSERT INTO hun_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","amint meg van írva: „Jákobot szerettem, Ézsaút pedig gyűlöltem.“ ");
INSERT INTO hun_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Mit mondjunk tehát? Vajon nem igazságtalanság ez Istentől? Semmiképpen! ");
INSERT INTO hun_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Mert Mózesnek ezt mondja: „Könyörülök azon, akin könyörülök és kegyelmezek annak, akinek kegyelmezek.“ ");
INSERT INTO hun_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Ezért nem azé, aki akarja, és nem azé, aki fut, hanem a könyörülő Istené. ");
INSERT INTO hun_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Mert az Írás azt mondja a fáraónak: „Arra rendeltelek téged, hogy megmutassam rajtad az én hatalmamat, és hogy hirdessék az én nevemet az egész földön.“ ");
INSERT INTO hun_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Ezért, akin akar, könyörül, akit pedig akar, megkeményít. ");
INSERT INTO hun_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Azt mondod erre nekem: Akkor miért vádol hát engem? Hiszen az ő akaratának kicsoda állhat ellen? ");
INSERT INTO hun_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","De hát kicsoda vagy te, ó, ember, hogy perbe szállsz Istennel? „Mondhatja-e a készítmény a készítőnek: miért formáltál engem így?“ ");
INSERT INTO hun_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","A fazekasnak nincs-e hatalma az agyagon, hogy ugyanabból az anyagból az egyik edényt ékességre, a másikat pedig közönséges használatra készítse? ");
INSERT INTO hun_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","Isten pedig nem a haragját akarta-e megmutatni, és hatalmát megismertetni, és ezért nagy béketűréssel szenvedte el a harag edényeit, amelyek pusztulásra készültek, ");
INSERT INTO hun_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","és nem az ő dicsőségének gazdagságát akarta-e megismertetni az irgalom edényein, amelyeket eleve dicsőségre készített? ");
INSERT INTO hun_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","Ilyenekké hívott el minket is, nemcsak a zsidók, hanem a pogányok közül is, ");
INSERT INTO hun_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","amint Hóseásnál is mondja: „Hívom a nem-népemet népemnek és a nem-szeretettet szeretettnek. ");
INSERT INTO hun_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","És úgy lesz, hogy azon a helyen, ahol ezt mondták neki: ti nem vagytok népem, ott az élő Isten fiainak fogják őket hívni“. ");
INSERT INTO hun_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Ézsaiás pedig ezt hirdeti Izraelről: „Ha Izrael fiainak száma annyi volna is, mint a tenger fövenye, csak a maradék tartatik meg, ");
INSERT INTO hun_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","mert az Úr bevégzi és gyorsan valóra váltja beszédét a földön.“ ");
INSERT INTO hun_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","És amint Ézsaiás előre megmondta: „Ha a Seregek Ura nem hagyott volna utódot nekünk, olyanná lettünk volna, mint Sodoma, és Gomorához lennénk hasonlók.“ ");
INSERT INTO hun_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Mit mondjunk tehát? Azt, hogy a pogányok, akik az igazságot nem követték, az igazságot elnyerték, mégpedig a hitből való igazságot. ");
INSERT INTO hun_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","Izrael ellenben, amely az igazság törvényét követte, nem jutott el az igazság törvényére. ");
INSERT INTO hun_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Miért? Azért, mert nem hitből keresték, hanem úgy, mintha a törvény cselekedetei révén volna elérhető. Beleütköztek a megütközés kövébe, ");
INSERT INTO hun_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","amint meg van írva: „Íme, a megütközés kövét és a megbotránkozás szikláját teszem Sionba, és aki hisz benne, nem szégyenül meg.“ ");
INSERT INTO hun_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Atyámfiai, szívem szerint kívánom és könyörgök Izrael üdvösségéért. ");
INSERT INTO hun_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Mert bizonyságot teszek arról, hogy Isten iránti buzgóság van bennük, de nem a helyes ismeret szerint. ");
INSERT INTO hun_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Mert Isten igazságát nem ismerték, és az ő saját igazságukat igyekeztek érvényesíteni, és az Isten igazságának nem engedelmeskedtek. ");
INSERT INTO hun_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Mert a törvény végső célja Krisztus, minden hívőnek megigazulására. ");
INSERT INTO hun_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Mózes ugyanis a törvényből való megigazulásról azt írja, hogy aki azt megcselekszi, élni fog az által. ");
INSERT INTO hun_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","A hitből való igazság pedig így szól: „Ne mondd a szívedben: ki megy fel a mennybe?“ hogy Krisztust lehozza. ");
INSERT INTO hun_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","Vagy: „Ki száll le a mélységbe?“ Azért tudniillik, hogy Krisztust a halálból felhozza. ");
INSERT INTO hun_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","De mit mond? „Közel van hozzád az ige, a szádban és szívedben van,“ tudniillik a hit igéje, amelyet mi hirdetünk. ");
INSERT INTO hun_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","Mert ha száddal vallást teszel az Úr Jézusról, és szívedben hiszed, hogy Isten feltámasztotta őt a halálból, akkor üdvözülsz. ");
INSERT INTO hun_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Mert szívvel hiszünk, hogy megigazuljunk, és szájjal teszünk bizonyságot, hogy üdvözüljünk. ");
INSERT INTO hun_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Mert ezt mondja az Írás: „Aki hisz benne, meg nem szégyenül“. ");
INSERT INTO hun_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Mert nincs különbség zsidó meg görög között. Mert ugyanaz mindenkinek az Ura, aki kegyelemben gazdag mindenkihez, aki őt segítségül hívja; ");
INSERT INTO hun_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","amint meg van írva: „Mindenki, aki segítségül hívja az Úr nevét, üdvözül.“ ");
INSERT INTO hun_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Hogyan hívják segítségül azt, akiben nem hisznek? Hogyan hisznek abban, aki felől nem hallottak? Hogyan hallhatnának igehirdető nélkül? ");
INSERT INTO hun_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","Hogyan prédikálnak, ha nem küldettek el? Ahogy meg van írva: „Milyen kedvesek léptei a békességhirdetőknek, azoknak, akik az evangéliumot hirdetik“. ");
INSERT INTO hun_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","De nem mindenki engedelmeskedett az evangéliumnak. Ézsaiás ezt mondja: „Uram, ki hitt a mi beszédünknek?“ ");
INSERT INTO hun_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","A hit tehát hallásból van, a hallás pedig Isten igéje által. ");
INSERT INTO hun_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","De kérdem: Nem hallották? Hiszen az egész földre elhatott hangjuk, és a lakóföld véghatáráig az ő beszédük! ");
INSERT INTO hun_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Tovább kérdem: Talán nem értette meg Izrael? Már Mózes ezt mondja: „Féltékennyé teszlek titeket egy olyan népre, amely nem népem, és egy értelmetlen néppel haragítlak meg titeket.“ ");
INSERT INTO hun_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Ézsaiás pedig nyíltan ezt mondja: „Megtaláltak azok, akik engem nem kerestek, nyilvánvalóvá lettem azoknak, akik felőlem nem kérdezősködtek.“ ");
INSERT INTO hun_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","Izraelről pedig ezt mondja: „Egész nap kiterjesztettem kezemet az engedetlenkedő és ellenszegülő nép felé.“ ");
INSERT INTO hun_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Kérdem tehát: Elvetette Isten az ő népét? Semmiképpen! Hiszen én is izraelita vagyok, Ábrahám utódai közül és Benjámin törzséből való. ");
INSERT INTO hun_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Nem vetette el Isten az ő népét, amelyet kiválasztott. Vagy nem tudjátok, mit mond az Írás Illésről, amikor vádat emel Istennél Izrael ellen: ");
INSERT INTO hun_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","„Uram a te prófétáidat megölték, és a te oltáraidat lerombolták, és csak én maradtam egyedül, és nekem is életemre törnek.“ ");
INSERT INTO hun_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","De mit mond neki az isteni felelet? „Meghagytam magamnak hétezer embert, akik nem hajtottak térdet a Baálnak.“ ");
INSERT INTO hun_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Így tehát most is van maradék a kegyelemből való kiválasztás szerint. ");
INSERT INTO hun_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","Ha pedig kegyelemből, akkor nem cselekedetekből. Különben a kegyelem nem volna kegyelem. Ha pedig cselekedetekből, akkor nem kegyelemből. Különben a cselekedet nem volna cselekedet. ");
INSERT INTO hun_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Mi tehát a helyzet? Amire Izrael törekedett, azt nem nyerte el. A választottak ellenben elnyerték, a többiek pedig megkeményíttettek. ");
INSERT INTO hun_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","Amint meg van írva: „Isten a kábultság lelkét adta nekik: szemeket, hogy ne lássanak, füleket, hogy ne halljanak, mind e mai napig.“ ");
INSERT INTO hun_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","Dávid is ezt mondja: „Legyen az ő asztaluk számukra csapdává, hálóvá, megbotlássá és megtorlássá. ");
INSERT INTO hun_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Sötétüljön el szemük, hogy ne lássanak, és hátukat mindenkorra görbítsd meg.“ ");
INSERT INTO hun_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Kérdem tehát: Azért botlottak meg, hogy elessenek? Semmiképpen! Hanem az ő elesésük miatt lett a pogányoké az üdvösség, hogy féltékennyé tegye Izraelt. ");
INSERT INTO hun_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Ha pedig elesésük a világ gazdagsága lett, és az ő vereségük a pogányok gazdagsága, mennyivel inkább az lesz, ha teljes számban megtérnek. ");
INSERT INTO hun_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Mert nektek mondom, pogányoknak: mivel én a pogányoknak apostola vagyok, szolgálatomat azzal dicsőítem, ");
INSERT INTO hun_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","ha féltékennyé teszem az én atyámfiait, és így megtarthatnék közülük némelyeket. ");
INSERT INTO hun_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Mert ha az ő elvettetésük a világ békességét szolgálta, mi mást jelenthetne befogadásuk, ha nem életet a halálból? ");
INSERT INTO hun_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","Ha pedig a tészta zsengéje szent, akkor a kenyér is az, és ha a gyökér szent, akkor az ágak is azok. ");
INSERT INTO hun_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Ha pedig egyes ágak kitörettek, te pedig vadolajfa létedre beoltattál azok közé, és részese lettél az olajfa gyökerének és nedvének, ");
INSERT INTO hun_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","ne kevélykedj az ágakkal szemben. Ha pedig kevélykedsz, tudd meg: nem te hordozod a gyökeret, hanem a gyökér téged. ");
INSERT INTO hun_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Azt mondod erre: Azért törettek ki az ágak, hogy én oltattassam be. ");
INSERT INTO hun_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Úgy van: hitetlenségük miatt törettek ki, te pedig hit által állsz. Fel ne fuvalkodjál, hanem félj. ");
INSERT INTO hun_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","Mert ha Isten a természetes ágaknak nem kedvezett, majd neked sem fog kedvezni. ");
INSERT INTO hun_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Lásd meg tehát Isten jóságát és keménységét: keménységét azok iránt, akik elestek, irántad pedig jóságát, ha ugyan megmaradsz jóságában, mert különben te is kivágatol. ");
INSERT INTO hun_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","Viszont azok, ha nem maradnak meg hitetlenségükben, beoltatnak, mert Isten ismét beolthatja őket. ");
INSERT INTO hun_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Mert ha te a természetes vadolajfából kivágattál, és a természet rendje ellenére beoltattál a szelíd olajfába, mennyivel inkább beoltatnak azok saját olajfájukba! ");
INSERT INTO hun_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Nem akarom, hogy ne tudjátok, atyámfiai, azt a titkot, – bölcsnek tartva magatokat – , hogy a megkeményedés Izraelre nézve csak rész szerint való, amíg a pogányok teljes számban be nem jutnak, ");
INSERT INTO hun_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","és így üdvözülni fog az egész Izrael, ahogy meg van írva: „Eljön Sionból a Szabadító, és eltörli Jákób gonoszságát, ");
INSERT INTO hun_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","és én ezt a szövetségemet adom nekik, amikor eltörlöm bűneiket.“ ");
INSERT INTO hun_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","Az evangéliumra nézve ugyan ellenségek – tiértetek, de a kiválasztásra nézve szeretettek az ősatyákért. ");
INSERT INTO hun_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Mert visszavonhatatlanok Isten ajándékai és az ő elhívása. ");
INSERT INTO hun_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Mert ahogyan ti egykor nem engedelmeskedtetek Istennek, most pedig irgalmasságot nyertetek az ő engedetlenségük révén, ");
INSERT INTO hun_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","úgy ők is most engedetlenek, hogy a nektek jutott irgalom révén ők is irgalmasságot nyerjenek. ");
INSERT INTO hun_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Mert Isten mindenkit engedetlenségbe zárt, hogy mindenkin megkönyörüljön. ");
INSERT INTO hun_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","Ó, Isten gazdagságának, bölcsességének és tudásának mélysége! Milyen kikutathatatlanok az ő ítéletei és kinyomozhatatlanok az ő útjai! ");
INSERT INTO hun_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","Ugyan „ki ismerte meg az Úr gondolatait? Vagy ki volt neki tanácsadója? ");
INSERT INTO hun_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","Vagy ki adott előbb neki, hogy vissza kellene fizetnie?“ ");
INSERT INTO hun_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Mert tőle, általa és érte van minden. Övé a dicsőség mindörökké. Ámen. ");
INSERT INTO hun_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","Kérlek azért titeket, atyámfiai, Isten irgalmasságára, hogy szánjátok oda testeteket élő, szent és Istennek kedves áldozatul, mint a ti okos istentiszteleteteket. ");
INSERT INTO hun_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","És ne szabjátok magatokat e világhoz, hanem változzatok meg értelmetek megújulásával, hogy megítélhessétek, mi az Isten jó, neki tetsző és tökéletes akarata. ");
INSERT INTO hun_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","A nekem adott kegyelem által mondom mindenkinek közöttetek, hogy ne gondoljon magáról többet, mint amit kell, hanem józanon gondolkodjék, amint Isten adta kinek-kinek a hit mértékét. ");
INSERT INTO hun_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","Mert ahogyan egy testnek sok tagja van, de nem minden tagnak ugyanaz a feladata, ");
INSERT INTO hun_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","úgy sokan egy test vagyunk a Krisztusban, egyenként pedig egymásnak tagjai vagyunk. ");
INSERT INTO hun_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","Mivel pedig különböző ajándékaink vannak a nekünk adott kegyelem szerint, így is szolgálunk: ha írásmagyarázás, a hit szabályai szerint teljesítsük; ");
INSERT INTO hun_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","ha más szolgálat adatott, akkor abban a szolgálatban munkálkodjunk: a tanító a tanításban, ");
INSERT INTO hun_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","az intő az intésben, az adakozó szelídségben, az elöljáró szorgalommal, a könyörülő vidámsággal tegye. ");
INSERT INTO hun_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","A szeretet képmutatás nélkül való legyen. Iszonyodjatok a gonosztól, ragaszkodjatok a jóhoz. ");
INSERT INTO hun_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","Atyafiúi szeretettel egymás iránt gyöngédek, a tiszteletadásban egymást megelőzők legyetek. ");
INSERT INTO hun_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","Az igyekezetben ne legyetek restek, lélekben buzgók legyetek, az Úrnak szolgáljatok, ");
INSERT INTO hun_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","A reménységben örvendezők, a háborúságban tűrők, a könyörgésben állhatatosak, ");
INSERT INTO hun_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","a szentek szükségeire adakozók legyetek, a vendégszeretetet gyakoroljátok. ");
INSERT INTO hun_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","Áldjátok azokat, akik titeket üldöznek, áldjátok, és ne átkozzátok. ");
INSERT INTO hun_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","Örüljetek az örülőkkel, és sírjatok a sírókkal. ");
INSERT INTO hun_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","Egymással egyetértésben éljetek, ne kevélykedjetek, hanem az alázatosokhoz tartsátok magatokat. Ne legyetek bölcsek önmagatok szemében. ");
INSERT INTO hun_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","Senkinek gonoszért gonosszal ne fizessetek. A tisztességre gondotok legyen minden ember előtt. ");
INSERT INTO hun_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","Ha lehetséges, amennyire rajtatok áll, minden emberrel békességben éljetek. ");
INSERT INTO hun_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","Magatokért bosszút ne álljatok, szeretteim, hanem adjatok helyt az ő haragjának, mert meg van írva: „Enyém az igazságszolgáltatás, én megfizetek! – ezt mondja az Úr.“ ");
INSERT INTO hun_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","Azért, ha éhezik a te ellenséged, adj ennie, ha szomjazik, adj innia, mert ha ezt teszed, parazsat gyűjtesz a fejére. ");
INSERT INTO hun_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","Ne győzzön le téged a gonosz, hanem a gonoszt jóval győzd meg. ");
INSERT INTO hun_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","Minden lélek engedelmeskedjék a felettes hatalmaknak, mert nincs hatalom mástól, csak Istentől. Ami hatalom pedig van, az Istentől rendeltetett. ");
INSERT INTO hun_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","Aki tehát ellenszegül a hatalomnak, Isten rendelése ellen támad. Akik pedig ellene támadnak, ítéletet vonnak magukra. ");
INSERT INTO hun_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","Az elöljárók nem a jó, hanem a rossz cselekedeteket büntetik. Akarod, hogy ne kelljen félned a hatalomtól? Cselekedd a jót, és dicséretet kapsz tőle, ");
INSERT INTO hun_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","hiszen Isten szolgája az a te javadra. Ha pedig gonoszt cselekszel, félj, mert nem ok nélkül viseli a fegyvert, hiszen Isten szolgája és az ő haragjával sújtja azt, aki gonoszt cselekszik. ");
INSERT INTO hun_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","Ezért tehát engedelmeskedni kell, nemcsak a harag miatt, hanem a lelkiismeret miatt is. ");
INSERT INTO hun_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","Ezért fizettek adót is, mert ők Isten szolgái, akik ugyanabban a szolgálatban fáradoznak. ");
INSERT INTO hun_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","Adjátok meg azért mindenkinek, amivel tartoztok: akinek adóval, az adót, akinek a vámmal, a vámot, akinek a félelemmel, a félelmet, akinek a tisztességgel, a tisztességet. ");
INSERT INTO hun_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","Senkinek semmivel ne tartozzatok, hanem csak azzal, hogy egymást szeressétek, mert aki szereti felebarátját, a törvényt betöltötte. ");
INSERT INTO hun_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","Mert ez: „Ne paráználkodjál, ne ölj, ne lopj, hamis tanúbizonyságot ne tégy, ne kívánd“ és minden más parancsolat ebben az igében foglalható össze: „Szeresd felebarátodat, mint magadat!“ ");
INSERT INTO hun_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","A szeretet nem tesz rosszat a felebarátnak. Ezért a törvény betöltése a szeretet. ");
INSERT INTO hun_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","Ezt cselekedjétek tehát, tudva az időt, itt az ideje már, hogy az álomból felébredjetek, mert most közelebb van hozzánk az üdvösség, mint amikor hívőkké lettünk. ");
INSERT INTO hun_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","Az éjszaka elmúlt, a nappal pedig már egészen közel van. Vessük le tehát a sötétség cselekedeteit, és öltözzük fel a világosság fegyvereit. ");
INSERT INTO hun_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","Ahogy nappal illik, tisztességben járjunk, nem dorbézolásban és részegségben, nem fajtalankodásban és kicsapongásban, nem viszálykodásban és irigységben, ");
INSERT INTO hun_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","hanem öltözzétek fel az Úr Jézus Krisztust, és ne úgy gondozzátok testeteket, hogy bűnös kívánságokra gerjedjen. ");
INSERT INTO hun_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","A hitben erőtlent fogadjátok be, nem ítélgetve vélekedéseit. ");
INSERT INTO hun_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","Van, aki azt hiszi, hogy mindent megehet. A hitben erőtlen pedig csak zöldséget eszik. ");
INSERT INTO hun_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","Aki eszik, ne vesse meg azt, aki nem eszik; és aki nem eszik, ne ítélje el azt, aki eszik, hiszen az Isten őt is befogadta. ");
INSERT INTO hun_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","Ki vagy te, hogy más szolgáját megítéled? Tulajdon urának áll, vagy esik. De meg fog állni, mert az Úr megerősítheti, hogy megálljon. ");
INSERT INTO hun_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","Ez az egyik napot különbnek tartja a másiknál, az pedig minden napot egyformának tart. Mindegyik a maga meggyőződésében legyen bizonyos. ");
INSERT INTO hun_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","Aki az egyik napot megkülönbözteti, az Úrért különbözteti meg. Aki nem különbözteti meg a napot, az Úrért nem különbözteti meg. Aki eszik, az Úrért eszik, hiszen hálát ad Istennek. Aki nem eszik, az Úrért nem eszik és szintén hálát ad Istennek. ");
INSERT INTO hun_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","Mert közülünk senki sem él önmagának és senki sem hal meg önmagának; ");
INSERT INTO hun_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","Mert ha élünk, az Úrnak élünk, ha meghalunk, az Úrnak halunk meg. Ezért akár élünk, akár meghalunk, az Úréi vagyunk. ");
INSERT INTO hun_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","Mert azért halt meg és támadt fel Krisztus, hogy mind holtakon, mind élőkön uralkodjék. ");
INSERT INTO hun_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","Te pedig miért ítéled el a te atyádfiát? Vagy te is miért veted meg a te atyádfiát? Hiszen mindnyájan odaállunk majd Krisztus ítélőszéke elé. ");
INSERT INTO hun_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","Mert meg van írva: „Élek én, ezt mondja az Úr, bizony előttem hajol meg majd minden térd, és minden nyelv Istent magasztalja.“ ");
INSERT INTO hun_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","Tehát mindegyikünk maga ad számot önmagáról Istennek. ");
INSERT INTO hun_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","Azért többé ne ítéljük el egymást, hanem inkább azt tartsátok jónak, hogy a ti atyátokfiának ne okozzatok megütközést vagy elbotlást. ");
INSERT INTO hun_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","Tudom és meg vagyok győződve az Úr Jézusban, hogy semmisem tisztátalan önmagában, csak annak tisztátalan, aki tisztátalannak tartja. ");
INSERT INTO hun_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","De ha a te atyádfia az étel miatt megszomorodik, akkor te nem szeretet szerint cselekszel. Ne okozd vesztét ételeddel annak, akiért Krisztus meghalt. ");
INSERT INTO hun_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","Ne engedjétek, hogy káromolják azt a jót, amiben részesültetek. ");
INSERT INTO hun_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","Mert Isten országa nem evés, nem ivás, hanem igazság, békesség és Szentlélek által való öröm. ");
INSERT INTO hun_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","Aki így szolgál a Krisztusnak, az kedves Isten előtt, és az emberek megbecsülik. ");
INSERT INTO hun_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","Törekedjünk tehát azokra, amik a békességre és egymás építésére valók. ");
INSERT INTO hun_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","Étel miatt ne rontsd le Isten munkáját. Minden tiszta ugyan, de rossz annak az embernek, aki megütközéssel eszik. ");
INSERT INTO hun_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","Jó tehát nem enni húst és nem inni bort, sem semmit nem tenni, amiben a te atyádfia megütközik. ");
INSERT INTO hun_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","Te azt a hitet, amely benned van, őrizd meg Isten előtt. Boldog, aki nem ítéli el magát abban, amit helyesel. ");
INSERT INTO hun_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","Aki pedig kételkedik, ha eszik, elítéltetett, mert nem hitből eszik. Ami pedig nincs hitből, az bűn. ");
INSERT INTO hun_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","Mi az erősek tartozunk azzal, hogy az erőtlenek erőtlenségeit hordozzuk, és ne a magunk javát keressük. ");
INSERT INTO hun_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","Mindegyikünk az ő felebarátjának kedvezzen, annak javára és épülésére. ");
INSERT INTO hun_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","Mert Krisztus sem önmagának kedvezett, hanem amint meg van írva: „A te gyalázóidnak gyalázásai hullottak rám.“ ");
INSERT INTO hun_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","Mert amelyek régen megírattak, a mi tanulságunkra írattak meg, hogy béketűrés által és az Írás vigasztalása által reménységünk legyen. ");
INSERT INTO hun_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","A béketűrés és vigasztalás Istene pedig adja meg nektek, hogy egyetértés legyen közöttetek Jézus Krisztus akarata szerint, ");
INSERT INTO hun_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","hogy egy szívvel és szájjal dicsőítsétek Istent, a mi Urunk Jézus Krisztus Atyját. ");
INSERT INTO hun_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","Azért fogadjátok be egymást, amint Krisztus is befogadott minket Isten dicsőségére. ");
INSERT INTO hun_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","Azt mondom ugyanis, hogy Jézus Krisztus szolgája lett a körülmetélkedésnek az Isten igazságáért, hogy megerősítse az atyáknak adott ígéreteket. ");
INSERT INTO hun_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","A pogányok pedig irgalmasságáért dicsőítik Istent, amint meg van írva: „Vallást teszek azért rólad a pogányok között, és dicséretet éneklek a te nevednek!“ ");
INSERT INTO hun_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","Ezt is mondja: „Örüljetek pogányok az ő népével együtt.“ ");
INSERT INTO hun_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","És ismét: „Dicsérjétek az Urat mind, ti pogányok, és magasztalja őt minden nép.“ ");
INSERT INTO hun_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","Ézsaiás pedig így szól: „Hajtás sarjad Isai gyökeréből, aki felemelkedik, hogy uralkodjék a pogányokon; őbenne reménykednek a pogányok.“ ");
INSERT INTO hun_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","A reménység Istene pedig töltsön be titeket minden örömmel és békességgel a hitben, hogy bővölködjetek a reménységben a Szentlélek ereje által. ");
INSERT INTO hun_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","Meg vagyok pedig győződve, atyámfiai, én magam is felőletek, hogy telve vagytok minden jósággal, telve vagytok minden ismerettel, hogy egymást is képesek vagytok inteni. ");
INSERT INTO hun_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","Merészebben is írtam nektek, atyámfiai, részben hogy emlékeztesselek titeket arra, hogy az Istentől nekem adott kegyelem által ");
INSERT INTO hun_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","Jézus Krisztus szolgája lettem a pogányok között, munkálkodva Isten evangéliumának ügyében, hogy a pogányok áldozata kedves és a Szentlélek által megszentelt legyen. ");
INSERT INTO hun_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","Van azért mivel dicsekedjem a Jézus Krisztusban, az Istenre vonatkozó dolgokban. ");
INSERT INTO hun_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","Mert nem mernék szólni semmiről sem, amit ne Krisztus cselekedett volna általam a pogányok megtérítéséért szóval és tettel, ");
INSERT INTO hun_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","jelek és csodák által, az Isten Lelkének ereje által: úgyhogy én Jeruzsálemtől és környékétől Illíriáig elvégeztem a Krisztus evangéliumának szolgálatát. ");
INSERT INTO hun_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","Így tehát az a tisztességes, hogy ne ott hirdessem az evangéliumot, ahol Krisztus neve már hirdettetett, hogy ne idegen alapra építsek. ");
INSERT INTO hun_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","Hanem amint meg van írva: „Akiknek még nem hirdettetett, azok meglátják, és akik még nem hallották, azok megértik.“ ");
INSERT INTO hun_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","Ezért akadályoztattam is gyakran, hogy hozzátok elmenjek. ");
INSERT INTO hun_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","Most pedig, hogy nincs már munkaterületem ezekben a tartományokban, és sok esztendő óta vágyódom, hogy elmenjek hozzátok, ");
INSERT INTO hun_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","ha Hispániába utazom, elmegyek hozzátok. Mert remélem, hogy átutazóban meglátlak titeket, és ti is elkísértek oda, ha előbb egy kissé felüdültem nálatok. ");
INSERT INTO hun_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","Most pedig megyek Jeruzsálembe a szentek szolgálatára. ");
INSERT INTO hun_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","Mert Macedónia és Akhája jónak látta, hogy a jeruzsálemi szentek szegényei részére valamit adakozzanak. ");
INSERT INTO hun_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","Így látták jónak, de tartoznak is ezzel. Mert ha a pogányok azoknak a lelki javaiban részesültek, ők is tartoznak ezt viszonozni anyagiakkal. ");
INSERT INTO hun_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","Azért ha ezt majd elvégeztem, és az eredményt nekik átadtam, titeket útba ejtve, megyek Hispániába. ");
INSERT INTO hun_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","Azt pedig tudom, hogy amikor hozzátok megyek, Krisztus evangéliuma áldásának teljességével megyek. ");
INSERT INTO hun_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","Kérlek pedig titeket, atyámfiai, a mi Urunk Jézus Krisztusra és a Lélek szerelmére, tusakodjatok velem együtt imádságotokban, én értem, Isten előtt, ");
INSERT INTO hun_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","hogy megszabaduljak azoktól, akik engedetlenek Júdeában, és hogy a Jeruzsálemben való szolgálatom legyen kedves a szentek előtt, ");
INSERT INTO hun_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","hogy örömmel menjek hozzátok Isten akaratából, és veletek együtt megújuljak. ");
INSERT INTO hun_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","A békesség Istene pedig legyen mindnyájatokkal! Ámen. ");
INSERT INTO hun_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","Ajánlom nektek nőtestvérünket, Fébét, aki a kenkhreai gyülekezetben szolgál, ");
INSERT INTO hun_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","hogy fogadjátok őt az Úrban a szentekhez illően, és legyetek mellette, ha valami dologban rátok szorul. Mert ő is sokaknak pártfogója volt, és nekem magamnak is. ");
INSERT INTO hun_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","Köszöntsétek Priszkát és Akvilát, akik nekem munkatársaim Krisztus Jézusban, ");
INSERT INTO hun_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","akik értem életüket kockáztatták; s akiknek nemcsak én mondok köszönetet, hanem a pogányok minden gyülekezete is. ");
INSERT INTO hun_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","És köszöntsétek azt a gyülekezetet is, amely az ő házukban van. Köszöntsétek az én szeretett Epainetoszomat, aki Akhája zsengéje a Krisztusban. ");
INSERT INTO hun_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","Köszöntsétek Máriát, aki sokat munkálkodott körülöttünk. ");
INSERT INTO hun_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","Köszöntsétek Andronikoszt és Juniászt, az én rokonaimat és az én fogolytársaimat, akiknek jó híre van az apostolok között, akik nálam is előbb lettek hivők a Krisztusban. ");
INSERT INTO hun_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","Köszöntsétek az Úrban szeretett Ampliátuszomat. ");
INSERT INTO hun_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","Köszöntsétek Urbánuszt, a mi munkatársunkat a Krisztusban, és az én szeretett Sztakhüszomat. ");
INSERT INTO hun_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","Köszöntsétek Apellészt, Krisztus kipróbált emberét. Köszöntsétek Arisztobulosz házanépéből valókat. ");
INSERT INTO hun_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","Köszöntsétek Heródiont, az én rokonomat. Köszöntsétek a Narcisszusz házanépéből azokat, akik az Úrban vannak. ");
INSERT INTO hun_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","Köszöntsétek Trüfainát és Trüfónászt, akik munkálkodnak az Úrban. Köszöntsétek a szeretett Persziszt, aki sokat munkálkodott az Úrban. ");
INSERT INTO hun_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","Köszöntsétek az Úrban kiválasztott Rufuszt és az ő anyját, aki az enyém is. ");
INSERT INTO hun_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","Köszöntsétek Aszünkritoszt, Flegónt, Hermészt, Patrobászt, Hermászt és az atyafiakat, akik velük vannak. ");
INSERT INTO hun_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","Köszöntsétek Filologoszt és Júliát, Néreuszt és az ő nénjét. És Olümpászt és minden szentet, akik velük vannak. ");
INSERT INTO hun_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","Köszöntsétek egymást szent csókkal. Köszöntenek titeket a Krisztus gyülekezetei. ");
INSERT INTO hun_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","Kérlek pedig titeket atyámfiai, vigyázzatok azokra, akik szakadásokat és botránkozásokat okoznak a tanítás körül, amelyet tanultatok. Forduljatok el az ilyenektől. ");
INSERT INTO hun_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","Mert az ilyenek a mi Urunk Jézus Krisztusnak nem szolgálnak, hanem az ő hasuknak, és nyájas beszéddel, meg hízelkedéssel megcsalják az ártatlanok szívét. ");
INSERT INTO hun_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","Mert a ti engedelmességeteknek híre mindenkihez eljutott. Örülök azért nektek; de azt akarom, hogy bölcsek legyetek a jóban, ártatlanok pedig a rosszban. ");
INSERT INTO hun_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","A békesség Istene megrontja hamarosan a Sátánt a ti lábatok alatt. A mi Urunk Jézus Krisztus kegyelme legyen veletek. Ámen. ");
INSERT INTO hun_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","Köszönt titeket Timoteus, az én munkatársam, valamint rokonaim Luciusz, Jázon és Szoszipatrosz. ");
INSERT INTO hun_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","Köszöntlek titeket az Úrban én, Terciusz, aki ezt a levelet írtam. ");
INSERT INTO hun_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","Köszönt titeket Gájus, aki nekem és az egész gyülekezetnek gazdája. Köszönt titeket Erásztosz, a város kincstartója és Kvártusz atyafi. ");
INSERT INTO hun_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","A mi Urunk Jézus Krisztus kegyelme legyen veletek. Ámen. ");
INSERT INTO hun_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","Annak pedig, aki titeket megerősíthet az én evangéliumom és Jézus Krisztus hirdetése alapján, annak a titoknak kijelentése alapján, amely örök időktől fogva el volt rejtve, ");
INSERT INTO hun_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","de most megjelentetett a prófétai írások által, az örök Isten parancsolata szerint, hogy a pogányok is eljussanak a hitben való engedelmességre, ");
INSERT INTO hun_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","az egyedül bölcs Istennek a Jézus Krisztus által legyen dicsőség mindörökké Ámen.");
INSERT INTO hun_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","Pál, Jézus Krisztusnak Isten akaratából elhívott apostola, és Szószthenész, az atyafi, ");
INSERT INTO hun_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","az Isten gyülekezetének, amely Korinthusban van, a Krisztus Jézusban megszentelt, elhívott szenteknek, mindazokkal együtt, akik a mi Urunk Jézus Krisztus nevét segítségül hívják bármely helyen, a magukén vagy a miénken. ");
INSERT INTO hun_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","Kegyelem nektek és békesség Istentől, a mi Atyánktól és az Úr Jézus Krisztustól. ");
INSERT INTO hun_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","Hálát adok az én Istenemnek mindenkor azért a kegyelemért, amely néktek Krisztus Jézusban adatott, ");
INSERT INTO hun_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","mert őbenne mindenben, mind beszédben, mind ismeretben meggazdagodtatok, ");
INSERT INTO hun_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","amint a Krisztusról szóló bizonyságtételben is megerősödtetek. ");
INSERT INTO hun_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","Úgyhogy nincs hiányotok semmiféle kegyelmi ajándékban, várva a mi Urunk Jézus Krisztusnak megjelenését, ");
INSERT INTO hun_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","aki meg is erősít titeket mindvégig feddhetetlenségben, a mi Urunk Jézus Krisztus napján. ");
INSERT INTO hun_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","Hű az Isten, aki elhívott titeket az ő Fiával, a mi Urunk Jézus Krisztussal való közösségre. ");
INSERT INTO hun_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","Kérlek azonban titeket, atyámfiai, a mi Urunk Jézus Krisztus nevére, hogy mindnyájan egyféleképpen szóljatok, és ne legyenek közöttetek szakadások, de legyetek teljesen egyek ugyanazon értelemben és ugyanazon véleményben. ");
INSERT INTO hun_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","Mert megtudtam felőletek, atyámfiai, a Khloé embereitől, hogy viszálykodások vannak közöttetek. ");
INSERT INTO hun_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","Ezt úgy értem, hogy mindnyájan így beszéltek: „Én Pálé vagyok, én meg Apollósé, én Kéfásé, én meg Krisztusé.“ ");
INSERT INTO hun_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","Vajon részekre osztatott-e a Krisztus? Vajon Pált feszítették meg értetek, vagy Pál nevére keresztelkedtetek meg? ");
INSERT INTO hun_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","Hálát adok az Istennek, hogy senkit sem kereszteltem meg közületek, kivéve Kriszpuszt és Gájuszt, ");
INSERT INTO hun_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","nehogy azt mondja valaki, hogy a magam nevére kereszteltem. ");
INSERT INTO hun_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","Megkereszteltem azonban még Sztefanász háza népét is. Ezen kívül nem tudom, hogy valaki mást is megkereszteltem volna. ");
INSERT INTO hun_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","Mert nem azért küldött engem a Krisztus, hogy kereszteljek, hanem hogy az evangéliumot hirdessem, de nem szólásban való bölcsességgel, nehogy a Krisztus keresztje hiábavaló legyen. ");
INSERT INTO hun_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","Mert a keresztről való beszéd bolondság ugyan azoknak, akik elvesznek, de nekünk, akik megtartatunk, Istennek ereje. ");
INSERT INTO hun_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","Mert meg van írva: „Elvesztem a bölcseknek bölcsességét, és az értelmesek értelmét elvetem“. ");
INSERT INTO hun_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","Hol a bölcs? Hol az írástudó? Hol e világ vitázója? Nem tette-e Isten bolondsággá e világnak bölcsességét? ");
INSERT INTO hun_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","Mert miután a világ bölcsessége által nem ismerte fel Istent a maga bölcsességében, úgy tetszett Istennek, hogy az igehirdetés bolondsága által tartsa meg a hivőket. ");
INSERT INTO hun_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","Egyfelől a zsidók jelt kívánnak, másfelől a görögök bölcsességet keresnek. ");
INSERT INTO hun_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","Mi pedig a megfeszített Krisztust prédikáljuk, zsidóknak ugyan botránkozást, a görögöknek pedig bolondságot. ");
INSERT INTO hun_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","Ámde maguknak az elhívottaknak mind zsidóknak, mind görögöknek Krisztust, Istennek hatalmát és Istennek bölcsességét. ");
INSERT INTO hun_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","Mert az Isten „bolondsága“ bölcsebb az embereknél és az Isten „erőtlensége“ erősebb az embereknél. ");
INSERT INTO hun_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","Gondoljatok csak elhivatásotokra atyámfiai: emberi szempontból nem sokan vagytok bölcsek, hatalmasak, előkelők, ");
INSERT INTO hun_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","mert a világ szerint bolondokat választotta ki az Isten, hogy megszégyenítse a bölcseket, és a világ szerint erőtleneket választotta ki Isten, hogy megszégyenítse az erőseket. ");
INSERT INTO hun_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","A világ szerint alacsonyrendűeket, lenézetteket választotta Isten, a „semmiket,“ hogy a „valamiket“ semmivé tegye, ");
INSERT INTO hun_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","hogy senki se dicsekedjék előtte. ");
INSERT INTO hun_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","Általa vagytok Jézus Krisztusban, akit Isten bölcsességünkké, megigazulásunkká, megszentelődésünkké és váltságunkká tett, ");
INSERT INTO hun_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","hogy amint meg van írva: „Aki dicsekedik, az Úrban dicsekedjék“. ");
INSERT INTO hun_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","Én is, amikor hozzátok mentem atyámfiai, nem úgy mentem, hogy nagy ékesszólással vagy bölcsességgel hirdessem nektek az Isten bizonyságtételét, ");
INSERT INTO hun_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","mert elhatároztam, hogy egyébről ne tudjak köztetek, csak Jézus Krisztusról, mégpedig a megfeszítettről. ");
INSERT INTO hun_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","És én erőtlenség, félelem és nagy rettegés között jelentem meg közöttetek. ");
INSERT INTO hun_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","És az én beszédem és prédikálásom nem emberi bölcsesség megtévesztő szavaiból állt, hanem a Léleknek és erőnek megmutatásában, ");
INSERT INTO hun_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","hogy a ti hitetek ne emberek bölcsességén, hanem Isten erején nyugodjék. ");
INSERT INTO hun_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","A (hitben) nagykorúak között mi is bölcsességet hirdetünk, de nem e világnak, sem e világ letűnt fejedelmeinek bölcsességét, ");
INSERT INTO hun_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","hanem Istennek titkon való bölcsességét szóljuk, azt az elrejtettet, amelyet Isten öröktől fogva elrendelt a mi dicsőségünkre, ");
INSERT INTO hun_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","amelyet e világ fejedelmei közül senki sem ismert fel, mert ha felismerték volna, nem feszítették volna meg a dicsőség Urát. ");
INSERT INTO hun_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","Hanem, amint meg van írva: „Amit szem nem látott, fül nem hallott és embernek szíve meg sem gondolt, azt készítette Isten az őt szeretőknek“. ");
INSERT INTO hun_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","Nekünk azonban Isten kinyilatkoztatta az ő Lelke által, mert a Lélek mindent megvizsgál, még Isten mélységeit is. ");
INSERT INTO hun_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","Mert ki ismeri az ember gondolatait? Csak az embernek lelke, amely benne lakik. Azonképpen az Isten dolgait sem ismeri senki, csak az Isten Lelke. ");
INSERT INTO hun_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","Mi pedig nem e világnak lelkét kaptuk, hanem az Istenből való Lelket, hogy megismerjük mindazt, amit Isten ajándékozott nekünk. ");
INSERT INTO hun_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","Ezeket prédikáljuk is, de nem emberi bölcsességből tanult szavakkal, hanem úgy, ahogy a Lélek tanít, lelkieknek lelkieket adva. ");
INSERT INTO hun_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","A nem lelki ember pedig nem foghatja fel Isten Lelkének dolgait, mert bolondságnak tűnik neki, nem is érti, mert ezeket csak a Lélek szerint lehet elbírálni. ");
INSERT INTO hun_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","A lelki ember azonban mindent elbírál, de őt nem bírálja felül senki. ");
INSERT INTO hun_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","Mert ugyan, „Ki ismerte meg az Úr gondolatait, hogy őt kioktathatná?“ Mi pedig Krisztus gondolataiban részesülünk. ");
INSERT INTO hun_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","Én sem szólhattam nektek, atyámfiai, mint lelkieknek, hanem mint testieknek, mint a Krisztusban kiskorúaknak. ");
INSERT INTO hun_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","Tejjel tápláltalak titeket és nem kemény eledellel, mert ezt nem bírtátok volna el, sőt még most sem bírnátok el, ");
INSERT INTO hun_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","mert még testiek vagytok. Amikor irigykedés, viszálykodás, és egyenetlenkedés van közöttetek, vajon nem testiek vagytok-e és nem emberi módon viselkedtek-e? ");
INSERT INTO hun_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","Mert amikor az egyik ezt mondja: „Én Pálé vagyok“, a másik meg: „Én Apollósé“ nem emberi módon viselkedtek-e? ");
INSERT INTO hun_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","Hát kicsoda Pál? És kicsoda Apollós? Csak szolgák, akik által hívőkké lettetek, mégpedig úgy, amint kinek-kinek az Úr megadta. ");
INSERT INTO hun_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","Én ültettem, Apollós öntözött, de az Isten adta a növekedést. ");
INSERT INTO hun_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","Azért nem az számít, aki ültet, sem az, aki öntöz, hanem a növekedést adó Isten. ");
INSERT INTO hun_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","Az ültető és az öntöző egyformák, és mindegyik a maga jutalmát kapja meg munkája szerint. ");
INSERT INTO hun_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","Mert Isten munkatársai vagyunk, ti pedig Isten szántóföldje és épülete vagytok. ");
INSERT INTO hun_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","Az Istennek nekem adott kegyelme szerint, mint bölcs építőmester fundamentumot vetettem, de más épít rá. Vigyázzon azonban mindenki, hogy mit épít rá. ");
INSERT INTO hun_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","Mert más fundamentumot senki sem vethet azonkívül, amely vettetett, amely a Jézus Krisztus. ");
INSERT INTO hun_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","Ha pedig valaki aranyat, ezüstöt, drágakövet, fát, szénát, szalmát épít erre a fundamentumra, ");
INSERT INTO hun_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","kinek-kinek a munkája nyilvánvaló lesz, mert az (Úr) napja majd nyilvánvalóvá teszi, mert tűzzel jön el, és azt tűz fogja megvizsgálni. ");
INSERT INTO hun_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","Ha valakinek megmarad munkája, amelyet ráépített, jutalmát veszi. ");
INSERT INTO hun_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","De ha valakinek munkája megég, kárt vall. Ő azonban megmenekül, de csak úgy, mint aki tűzön ment át. ");
INSERT INTO hun_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","Nem tudjátok, hogy ti az Isten temploma vagytok, és az Isten Lelke lakik bennetek? ");
INSERT INTO hun_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","Ha valaki az Isten templomát beszennyezi, elveszti azt az Isten, mert Isten temploma szent, és az a templom ti vagytok. ");
INSERT INTO hun_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","Senki se csalja meg magát. Ha valaki azt hiszi, hogy bölcs ti köztetek e világon, bolond legyen, hogy bölccsé lehessen. ");
INSERT INTO hun_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","Mert e világ bölcsessége bolondság Isten előtt. Mert meg van írva: „Megfogja a bölcseket csalárdságukban“. ");
INSERT INTO hun_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","És ismét: „Tudja az Úr, hogy a bölcsek gondolatai hiábavalók“. ");
INSERT INTO hun_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","Azért senki se dicsekedjék emberekkel, mert minden a tiétek: ");
INSERT INTO hun_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","akár Pál, akár Apollós, akár Kéfás, akár a világ, akár az élet, akár a halál, akár a jelenvalók, akár a következendők, minden a tiétek. ");
INSERT INTO hun_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","Ti pedig a Krisztusé, Krisztus pedig Istené. ");
INSERT INTO hun_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","Úgy tekintsen minket az ember, mint Krisztus szolgáit és Isten titkainak sáfárait. ");
INSERT INTO hun_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","Márpedig a sáfároktól azt kívánják meg, hogy mindegyikük hűséges legyen. ");
INSERT INTO hun_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","Nekem pedig vajmi keveset számít, hogy ti vagy mások hogyan ítélkeztek felettem. Hiszen én sem ítélkezem magam felett. ");
INSERT INTO hun_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","Semmi sem terheli lelkiismeretemet, de nem ez igazol engem. Felettem ugyanis az Úr ítélkezik. ");
INSERT INTO hun_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","Ti se ítélkezzetek hát idő előtt, míg el nem jön az Úr, aki megvilágítja a sötétség titkait, leleplezi a szívek szándékát. Akkor majd Isten részesít mindenkit elismerésben. ");
INSERT INTO hun_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","Ezeket, testvéreim, miattatok alkalmaztam magamra és Apollósra, hogy rajtunk tanuljátok meg, nem szabad túllépni azon, ami meg van írva. Senki se lelkesedjék tehát egyvalakiért, a másik rovására. ");
INSERT INTO hun_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","Mi tesz téged másnál különbbé? Mid van ugyanis, amit nem kaptál volna? Ha pedig úgy kaptad, mit dicsekszel, mintha nem kaptad volna? ");
INSERT INTO hun_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","Ti már jóllaktatok, meggazdagodtatok, nélkülünk uralomra jutottatok. Bár csakugyan uralomra jutottatok volna, hogy mi is veletek együtt uralkodhatnánk. ");
INSERT INTO hun_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","Mert úgy vélem, hogy Isten minket, apostolokat utolsó helyre állított, mintegy halálra szánt, mert látványossága lettünk a világnak, mind angyaloknak, mind embereknek. ");
INSERT INTO hun_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","Mi bolondok vagyunk a Krisztusért, ti pedig bölcsek a Krisztusban. Mi erőtlenek, ti pedig erősek. Ti megbecsültek, mi pedig megvetettek. ");
INSERT INTO hun_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","Mind ez ideig éhezünk is, szomjazunk is, ruhánk sincs, bántalmaznak minket, és otthonunk sincs, ");
INSERT INTO hun_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","fáradozunk is, tulajdon kezünkkel munkálkodva. Ha szidalmaznak, jót kívánunk, ha üldöznek, békésen tűrünk, ");
INSERT INTO hun_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","Ha gyaláznak, áldást mondunk. Szinte a világ szemetjévé lettünk, mindenkinek söpredékévé egész mostanig. ");
INSERT INTO hun_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","Nem azért írom ezeket, hogy megszégyenítselek titeket, hanem hogy mint szeretett gyermekeimet intselek. ");
INSERT INTO hun_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","Ha tízezer tanítómesteretek lenne is a Krisztusban, de nem sok atyátok, mert én vagyok a ti atyátok a Krisztus Jézusban az evangélium által. ");
INSERT INTO hun_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","Kérlek azért titeket, legyetek az én követőim. ");
INSERT INTO hun_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","Azért küldtem hozzátok Timóteust, az én szeretett és hű fiamat az Úrban, hogy juttassa eszetekbe az én útjaimat a Krisztusban, hogy miként tanítok mindenütt, minden gyülekezetben. ");
INSERT INTO hun_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","De némelyek úgy fölfuvalkodtak, mintha el se mennék hozzátok. ");
INSERT INTO hun_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","Pedig, ha az Úr akarja, hamarosan elmegyek hozzátok, és akkor megismerem a felfuvalkodottaknak nem a beszédét, hanem az erejét. ");
INSERT INTO hun_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","Mert nem beszédben áll az Isten országa, hanem erőben. ");
INSERT INTO hun_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","Mit akartok? Vesszővel menjek-e hozzátok, vagy szeretettel és a szelídség lelkével? ");
INSERT INTO hun_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","Az a hír járja, hogy paráznaság fordul elő köztetek, mégpedig olyan, amilyen még a pogányok között sincs, hogy valaki apja feleségével él. ");
INSERT INTO hun_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","És ti felfuvalkodtok, ahelyett, hogy megkeseredve kivetnétek magatok közül azt, aki ezt cselekedte! ");
INSERT INTO hun_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","Mert én, bár testileg ugyan távol, lelkileg azonban jelen vagyok, mint jelenlévő, ítélkezem afelett, aki így cselekedett. ");
INSERT INTO hun_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","A mi Urunk Jézus Krisztus nevében összegyűlve, ti és az én lelkem, a mi Urunk Jézus Krisztus hatalmával ");
INSERT INTO hun_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","átadjuk az ilyet testének vesztére a sátánnak, hogy lelke megtartassék az Úr Jézus napján. ");
INSERT INTO hun_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","Nem jó a ti dicsekedésetek. Nem tudjátok, hogy egy kis kovász az egész tésztát megkeleszti? ");
INSERT INTO hun_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","Ki a házból a régi kovásszal, hogy új tésztává legyetek! Mert ti kovász nélkül valók vagytok, hiszen Krisztus, a mi húsvéti bárányunk megáldoztatott értünk. ");
INSERT INTO hun_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","Azért ne a régi kovásszal ünnepeljünk, se a rosszaságnak, se a gonoszságnak kovászával, hanem a tisztaságnak és igazságnak kovásztalanságával. ");
INSERT INTO hun_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","Előző levelemben már megírtam nektek, hogy ne tartsatok kapcsolatot paráznákkal, ");
INSERT INTO hun_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","de nem általában e világ paráznáival, csalóival, rablóival, vagy bálványimádóival, mert hiszen akkor ki kellene mennetek a világból. ");
INSERT INTO hun_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","Valójában azt írtam nektek, hogy ne tartsatok kapcsolatok olyannal, aki bár testvérnek mondja magát, mégis parázna, csaló, bálványimádó, rágalmazó, részeges vagy rabló. Az ilyennel még együtt se egyetek. ");
INSERT INTO hun_vpl VALUES ("C15_12","076_5_12","1CO","5","12","12","Mert mit tartozik rám, hogy a kívül valókról ítélkezzem? Nem a belüllévők fölött ítélkeztek-e ti is? ");
INSERT INTO hun_vpl VALUES ("C15_13","076_5_13","1CO","5","13","13","A kívül valókat pedig majd Isten ítéli meg. Vessétek ki azért a gonoszt magatok közül! ");
INSERT INTO hun_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","Hogyan merészel közületek bárki is, ha peres dolga van valakivel, a hitetlenek előtt pereskedni és nem a szentek előtt? ");
INSERT INTO hun_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","Nem tudjátok, hogy a szentek a világot fogják megítélni? És ha ti ítélitek meg a világot, vajon méltatlanok vagytok-e, hogy jelentéktelen ügyekben ítélkezzetek? ");
INSERT INTO hun_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","Nem tudjátok-e, hogy angyalokat fogunk ítélni? Mennyivel inkább ítélhetünk mindennapi ügyekben! ");
INSERT INTO hun_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","Azért ha mindennapi ügyekben pereskedtek, azokat ültetitek-e le a bírói székbe, akiket semmibe sem vesznek a gyülekezetben? ");
INSERT INTO hun_vpl VALUES ("C16_5","076_6_5","1CO","6","5","5","Megszégyenítésetekre mondom: Hát nincs közöttetek egy bölcs ember sem, aki igazságot tudna tenni az ő atyafiai között? ");
INSERT INTO hun_vpl VALUES ("C16_6","076_6_6","1CO","6","6","6","Sőt atyafi atyafival pereskedik méghozzá hitetlenek előtt! ");
INSERT INTO hun_vpl VALUES ("C16_7","076_6_7","1CO","6","7","7","Egyáltalán már az is gyarlóság bennetek, hogy egymással pereskedtek! Miért nem szenveditek el inkább a sérelmet? Miért nem tűritek el inkább a kárt? ");
INSERT INTO hun_vpl VALUES ("C16_8","076_6_8","1CO","6","8","8","Sőt még ti okoztok sérelmet és kárt, méghozzá atyafiaknak! ");
INSERT INTO hun_vpl VALUES ("C16_9","076_6_9","1CO","6","9","9","Vagy nem tudjátok, hogy gonoszok nem örökölhetik Isten országát? Ne tévelyegjetek: sem paráznák, sem bálványimádók, sem házasságtörők, sem kéjelgők, sem fajtalankodók, ");
INSERT INTO hun_vpl VALUES ("C16_10","076_6_10","1CO","6","10","10","sem tolvajok, sem telhetetlenek, sem részegesek, sem szidalmazók, sem rablók nem örökölhetik Isten országát. ");
INSERT INTO hun_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","Néhányan bizony ilyenek voltatok, de megtisztultatok, megszenteltettetek és megigazíttatok az Úr Jézusnak nevében és a mi Istenünk Lelke által. ");
INSERT INTO hun_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","Minden szabad nekem, de nem minden használ. Minden szabad nekem, csak ne váljék úrrá rajtam semmi. ");
INSERT INTO hun_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","Az étel a gyomorért van, a gyomor pedig az ételért, de Isten mind ezt, mind amazt semmissé teszi. A test azonban nem a paráznaságért van, hanem az Úrért, és az Úr pedig a testért. ");
INSERT INTO hun_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","Isten pedig, aki az Urat feltámasztotta, minket is feltámaszt hatalmával. ");
INSERT INTO hun_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","Nem tudjátok, hogy a ti testetek a Krisztusnak tagja? Elszakítva tehát Krisztus tagjait egy parázna nő tagjaivá tegyem? Semmiképpen! ");
INSERT INTO hun_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","Vagy nem tudjátok, hogy aki paráznával egyesül, egy testté lesz vele? Mert – ahogy az Írás mondja – ketten lesznek egy testté. ");
INSERT INTO hun_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","Aki pedig az Úrral egyesül, egy Lélek ővele. ");
INSERT INTO hun_vpl VALUES ("C16_18","076_6_18","1CO","6","18","18","Kerüljétek tehát a paráznaságot! Minden bűn, amelyet az ember elkövet, a testen kívül van, de aki paráználkodik, a maga teste ellen vétkezik. ");
INSERT INTO hun_vpl VALUES ("C16_19","076_6_19","1CO","6","19","19","Vagy nem tudjátok, hogy a ti testetek a bennetek lakó Szentlélek temploma, amelyet Istentől kaptatok, és így nem a magatoké vagytok? ");
INSERT INTO hun_vpl VALUES ("C16_20","076_6_20","1CO","6","20","20","Mert áron vétettetek meg, dicsőítsétek tehát Istent testetekben és lelketekben. ");
INSERT INTO hun_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","Amikről írtatok nekem, szerintem jó, ha a férfi nem érintkezik nővel. ");
INSERT INTO hun_vpl VALUES ("C17_2","076_7_2","1CO","7","2","2","De a paráznaság veszélye miatt, minden férfinak saját felesége és minden nőnek saját férje legyen. ");
INSERT INTO hun_vpl VALUES ("C17_3","076_7_3","1CO","7","3","3","A férj teljesítse házastársi kötelességét felesége iránt, s ugyanígy a feleség is férje iránt. ");
INSERT INTO hun_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","A feleség nem ura a maga testének, hanem a férje. Hasonlóképpen a férj sem ura a maga testének, hanem a felesége. ");
INSERT INTO hun_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","Ne fosszátok meg egymást, legfeljebb közös akaratból egy bizonyos ideig, hogy legyen időtök a böjtölésre és az imádkozásra, azután ismét egymáshoz térjetek, hogy a sátán meg ne kísértsen titeket, mivel nem tudjátok magatokat megtartóztatni. ");
INSERT INTO hun_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","Ezt pedig kedvezésképpen mondom, és nem parancsként. ");
INSERT INTO hun_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","Mert szeretném, ha minden ember úgy volna, mint én magam is, de kinek-kinek saját kegyelmi ajándéka van Istentől, egyiknek így, a másiknak amúgy. ");
INSERT INTO hun_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","A nem házasoknak és az özvegyasszonyoknak azt mondom, hogy jó nekik, ha úgy maradnak, amint én is. ");
INSERT INTO hun_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","De ha magukat nem tartóztathatják meg, inkább házasságban éljenek, mert jobb házasságban élni, mint égni. ");
INSERT INTO hun_vpl VALUES ("C17_10","076_7_10","1CO","7","10","10","Azoknak pedig, akik házasságban vannak, nem én rendelem, hanem az Úr, hogy az asszony a férjétől el ne váljék. ");
INSERT INTO hun_vpl VALUES ("C17_11","076_7_11","1CO","7","11","11","Ha pedig elválik, maradjon házasság nélkül vagy béküljön meg férjével. A férj se bocsássa el feleségét. ");
INSERT INTO hun_vpl VALUES ("C17_12","076_7_12","1CO","7","12","12","A többieknek pedig én mondom, nem az Úr, hogy ha egy atyafinak hitetlen felesége van, és az vele akar élni, ne bocsássa el őt. ");
INSERT INTO hun_vpl VALUES ("C17_13","076_7_13","1CO","7","13","13","És ha egy asszonynak hitetlen férje van, és az vele akar élni, ne hagyja el férjét. ");
INSERT INTO hun_vpl VALUES ("C17_14","076_7_14","1CO","7","14","14","Mert a hitetlen férfit megszenteli felesége, a hitetlen asszonyt pedig a férje. Különben gyermekeitek tisztátalanok volnának, így azonban szentek. ");
INSERT INTO hun_vpl VALUES ("C17_15","076_7_15","1CO","7","15","15","Ha pedig a hitetlen elválik, ám váljék el. Ilyen esetben sem a férfi, sem a nőtestvér nincs elkötelezve. De békességre hívott el minket az Isten. ");
INSERT INTO hun_vpl VALUES ("C17_16","076_7_16","1CO","7","16","16","Honnan tudod te, asszony, hogy nem mentheted-e meg férjedet, és honnan tudod te, férj, hogy nem mentheted-e meg feleségedet? ");
INSERT INTO hun_vpl VALUES ("C17_17","076_7_17","1CO","7","17","17","Éljen mindenki úgy, ahogy az Úr megadta neki, és ahogy az Isten elhívta. Minden gyülekezetben így rendelkezem. ");
INSERT INTO hun_vpl VALUES ("C17_18","076_7_18","1CO","7","18","18","Körülmetélten hívatott el valaki? Ne takargassa. Körülmetéletlenül hívatott el valaki? Ne metélkedjék körül. ");
INSERT INTO hun_vpl VALUES ("C17_19","076_7_19","1CO","7","19","19","Ahogy a körülmetéltség, úgy a körülmetéletlenség sem ér semmit, csak Isten parancsolatainak megtartása (lényeges). ");
INSERT INTO hun_vpl VALUES ("C17_20","076_7_20","1CO","7","20","20","Mindenki abban a hivatásban maradjon, amelyben elhívatott. ");
INSERT INTO hun_vpl VALUES ("C17_21","076_7_21","1CO","7","21","21","Rabszolgaként hivattattál el? Ne gondolj vele! De ha szabad lehetsz, inkább élj azzal! ");
INSERT INTO hun_vpl VALUES ("C17_22","076_7_22","1CO","7","22","22","Mert az Úrban elhívott rabszolga, az Úrnak szabadosa. Hasonlóképpen, aki szabadságban hívatott el, az Krisztus rabszolgája. ");
INSERT INTO hun_vpl VALUES ("C17_23","076_7_23","1CO","7","23","23","Áron vétettetek meg, ne legyetek emberek rabszolgái. ");
INSERT INTO hun_vpl VALUES ("C17_24","076_7_24","1CO","7","24","24","Ki-ki, amiben elhívatott, atyámfiai, abban maradjon meg Isten előtt. ");
INSERT INTO hun_vpl VALUES ("C17_25","076_7_25","1CO","7","25","25","A hajadonok felől ugyan nincs rendelkezésem az Úrtól, de tanácsot adok úgy, mint aki irgalmasságot nyertem az Úrtól, hogy hitelre méltó legyek. ");
INSERT INTO hun_vpl VALUES ("C17_26","076_7_26","1CO","7","26","26","Úgy ítélem tehát, hogy jó az embernek úgy maradnia a közeli megpróbáltatások miatt. ");
INSERT INTO hun_vpl VALUES ("C17_27","076_7_27","1CO","7","27","27","Feleséghez vagy kötve? Ne keress elválást. Feleség nélkül maradtál? Ne keress feleséget. ");
INSERT INTO hun_vpl VALUES ("C17_28","076_7_28","1CO","7","28","28","De ha megnősülsz is, nem vétkezel. Ha férjhez megy is a hajadon, nem vétkezik. Ám az ilyenek testileg szorult helyzetbe kerülnek (testi gyötrődésben lesz részük), pedig én szeretnélek titeket ettől megkímélni. ");
INSERT INTO hun_vpl VALUES ("C17_29","076_7_29","1CO","7","29","29","Ezt pedig azért mondom, atyámfiai, mert az idő rövidre van szabva. Ezért akiknek feleségük van, éljenek úgy, mintha nem volna. ");
INSERT INTO hun_vpl VALUES ("C17_30","076_7_30","1CO","7","30","30","Akik sírnak, mintha nem sírnának. Akik vigadnak, mintha nem vigadnának. Akik vásárolnak, mintha nem birtokolnának. ");
INSERT INTO hun_vpl VALUES ("C17_31","076_7_31","1CO","7","31","31","Akik élnek e világgal, mintha nem vennék igénybe, mert elmúlik ennek a világnak mostani formája. ");
INSERT INTO hun_vpl VALUES ("C17_32","076_7_32","1CO","7","32","32","Azt akarnám pedig, hogy ti gond nélkül legyetek. Aki nem házas, arra visel gondot, ami az Úré, hogyan járjon az Úr kedvében. ");
INSERT INTO hun_vpl VALUES ("C17_33","076_7_33","1CO","7","33","33","Aki pedig megházasodott, a világi dolgokra visel gondot, hogyan járjon feleségének kedvében, ");
INSERT INTO hun_vpl VALUES ("C17_34","076_7_34","1CO","7","34","34","így kétfelé elkötelezett. Aki nem ment férjhez, a hajadon az Úr dolgaira visel gondot, hogy szent legyen mind testében, mind lelkében. Aki pedig férjhez ment, a világ dolgaira visel gondot, hogy férje kedvében járjon. ");
INSERT INTO hun_vpl VALUES ("C17_35","076_7_35","1CO","7","35","35","Ezt pedig javatokra mondom, nem azért, hogy tőrbe csaljalak titeket, hanem hogy feddhetetlenek legyetek, és állhatatosan ragaszkodjatok az Úrhoz. ");
INSERT INTO hun_vpl VALUES ("C17_36","076_7_36","1CO","7","36","36","De ha valaki szégyennek tatja, hogy a rábízott hajadon virágzó idejét múlja, és mégis pártában kell maradnia, tegye, amit akar, nem vétkezik: kössenek házasságot. ");
INSERT INTO hun_vpl VALUES ("C17_37","076_7_37","1CO","7","37","37","Aki pedig szilárdan áll szívében és nincs kényszerhelyzetben, mert hatalma van saját akarata fölött, és úgy döntött szívében, hogy a rábízott leány maradjon hajadon, jól cselekszik. ");
INSERT INTO hun_vpl VALUES ("C17_38","076_7_38","1CO","7","38","38","Aki tehát férjhez megy, jól cselekszik, de aki nem megy férjhez, még jobban cselekszik. ");
INSERT INTO hun_vpl VALUES ("C17_39","076_7_39","1CO","7","39","39","Az asszonyt törvény köti, amíg férje él, de ha férje meghal, szabadon férjhez mehet, akihez akar, de csak az Úrban. ");
INSERT INTO hun_vpl VALUES ("C17_40","076_7_40","1CO","7","40","40","Véleményem szerint azonban boldogabb lesz, ha (özvegyen) marad. Én pedig úgy vélem, hogy bennem is Isten Lelke van. ");
INSERT INTO hun_vpl VALUES ("C18_1","076_8_1","1CO","8","1","1","Ami a bálványáldozati húst illeti, tudjuk, mindnyájunknak van ismerete. Az ismeret azonban felfuvalkodottá tesz, a szeretet viszont épít. ");
INSERT INTO hun_vpl VALUES ("C18_2","076_8_2","1CO","8","2","2","Aki úgy véli, hogy ismer valamit, ezzel még semmit sem ismert meg úgy, ahogy ismernie kell. ");
INSERT INTO hun_vpl VALUES ("C18_3","076_8_3","1CO","8","3","3","Ám ha valaki Istent szereti, az már ismert az Istennél. ");
INSERT INTO hun_vpl VALUES ("C18_4","076_8_4","1CO","8","4","4","Ami tehát a bálványáldozati hús evését illeti, tudjuk, hogy egy bálvány sincs a világon, és hogy nincs Isten senki más, csak egy. ");
INSERT INTO hun_vpl VALUES ("C18_5","076_8_5","1CO","8","5","5","Mert ha vannak is úgynevezett istenek akár az égben, akár a földön, mint ahogyan van sok isten és úr, ");
INSERT INTO hun_vpl VALUES ("C18_6","076_8_6","1CO","8","6","6","nekünk csak egy Istenünk van, az Atya, akitől van a mindenség és mi is őbenne, és egy Urunk, Jézus Krisztus, aki által van a mindenség, és mi is általa. ");
INSERT INTO hun_vpl VALUES ("C18_7","076_8_7","1CO","8","7","7","De nem mindenkiben van meg ez az ismeret. Némelyek lelkiismerete mind a mai napig a bálványokhoz kötődik, és a húst mint áldozati húst eszik. Így lelkiismeretük, mivel erőtlen beszennyeződik. ");
INSERT INTO hun_vpl VALUES ("C18_8","076_8_8","1CO","8","8","8","Pedig nem az étel visz közelebb minket Istenhez, mert ha eszünk, nem lesz belőle hátrányunk, ha nem eszünk, nem lesz belőle előnyünk. ");
INSERT INTO hun_vpl VALUES ("C18_9","076_8_9","1CO","8","9","9","Arra azonban ügyeljetek, hogy a ti szabadságotok valamiképpen ne legyen az erőtlenek botránkozására. ");
INSERT INTO hun_vpl VALUES ("C18_10","076_8_10","1CO","8","10","10","Mert ha valaki téged, akinek ismerete van, meglát, hogy a bálványtemplomnál vendégeskedsz, annak erőtlen lelkiismerete nem bátorítja-e arra, hogy megegye a bálványáldozatot? ");
INSERT INTO hun_vpl VALUES ("C18_11","076_8_11","1CO","8","11","11","Így ismereteddel romlásra juttatod erőtlen atyádfiát, akiért Krisztus meghalt. ");
INSERT INTO hun_vpl VALUES ("C18_12","076_8_12","1CO","8","12","12","Ha tehát így vétkeztek az atyafiak ellen, és erőtlen lelkiismeretüket megsértitek, a Krisztus ellen vétkeztek! ");
INSERT INTO hun_vpl VALUES ("C18_13","076_8_13","1CO","8","13","13","Ha az étel megbotránkoztatja az én atyámfiát, inkább sohasem eszem (áldozati) húst, hogy őt meg ne botránkoztassam. ");
INSERT INTO hun_vpl VALUES ("C19_1","076_9_1","1CO","9","1","1","Nem vagyok apostol? Nem vagyok szabad? Nem láttam Jézus Krisztust, a mi U