﻿USE sofia;
DROP TABLE IF EXISTS sofia.hui_vpl;
CREATE TABLE hui_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES hui_vpl WRITE;
INSERT INTO hui_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Bamba piganengiore Ngode Datagaliwabehanda dindi haribi wabialu uruni karu ngarubi bibahendeore wabiai hene. ");
INSERT INTO hui_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Anigo dindini áyu ngagobi ndo mbiraleru nahe tara mbira wini. Aruma holeneme iba timbuni bereago dambi haiho wiagola Ngode Datagaliwabenaga Dinini ibu ibani yuluyu pu íbu bialu hene. ");
INSERT INTO hui_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Ai Ngode Datagaliwabehanda lalu, Wá ha layagola wá hene. ");
INSERT INTO hui_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Wá hayago hondowa Ngode Datagaliwabe ibugua bayaleoreyane hendene. Ani hondowa aruma holene wá holenela mo tuwia hene. ");
INSERT INTO hui_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Ani buwa aruma hayago mbiraga lalu wá hayago horo lalu mini wini. Mbiraga piai halu ega bi layagola horo mbira pigane ogoni hene. ");
INSERT INTO hui_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","7","Mani Ngode Datagaliwabehanda lalu, Iba halu kirani berelo tubari mbira íbu ha layagola tubari ogoni hene. Ibugua iba hari daligaha biralu dindihabi berelo lowa tubari ogoni wini. ");
INSERT INTO hui_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Ani buwa hanuni tubari wiyadagoni hari mini wini. Mbiraga piai halu ega bi layagola horo mende ogoni hene. ");
INSERT INTO hui_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Ani heagola mani Ngode Datagaliwabehanda lalu, Dindi yobi pani helo iba dindiha bedamiruni mbiraoreha hangu birumogo bidaba, lene. Ani layagola dindi yobi pani hene. ");
INSERT INTO hui_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Dindi yobi pani hayago Ngode Datagaliwabehanda dindi mini wini. Ani bialu iba mbiraoreha birumogo biyagola ibugua iba solowara mini wini. Ani buwa Ngode Datagaliwabe ibunime o biyaruni bibahende bayaleoreyane hendene. ");
INSERT INTO hui_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Ani hondowa ibugua lalu, Ai dindini ira dataniru tomo nolene alerubi bibahende anda hai ha, layagola ");
INSERT INTO hui_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","bibahende ira datani tomo nolene alerubi anda hai hene. Ngode Datagaliwabe ibugua mbirale uruni bibahende ani anda hai hayago bayaleoreyane hendene. ");
INSERT INTO hui_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Mbiraga piai halu ega bi layagola horo tebone ogoni hene. ");
INSERT INTO hui_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Mani howa Ngode Datagaliwabe ibugua lalu, Harini wá holene aleru hadaba, lene. Ani lowa ibugua mbi horola tu wuleneru horo malirunaga pongo yuleneru wigi bilonaga helene. ");
INSERT INTO hui_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Ani bialu nde harini howa wá haragome dindiha wá hadali helobi ani hadaba layagola wá holene ale harini hene. ");
INSERT INTO hui_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Ibugua wá holene timbuni kira harini helene. Horongi wá timbuni hondo helonaga ni helalu mbiraga wá emene hondo helonaga ege helowa yapibiyarubi hela dege bini. ");
INSERT INTO hui_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","18","Uruni bibahande tigua harini howa dindiha wá hadali helonaga Ngode Datagaliwabehanda helene. Ani helowa horongibi mbiragabi wá haame helonaga horo mbila mo tu wia hene. Ibugua uruni bibahende ani hai heagola bayaleoreyane hendene. ");
INSERT INTO hui_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Mbiraga piai halu ega bi layagola horo mane ogoni hene. ");
INSERT INTO hui_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Mani Ngode Datagaliwabehanda lalu, Ai iba solowaraha buhe̱ lagaru bibahende birai helo. Ani bialu egaru harini yagalo yu ibaga bulene biralu bilo, lene. ");
INSERT INTO hui_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Ani lowa ibugua, Iba wena timbuniru nogombi timbunirubi buhe̱ laga emene marubi bibahende iba solowaraha biralu egarubi nde yagalo yu ibaga bule biradaba, layadagua birai hayago Ngode Datagaliwabehanda bayaleoreyane hendene. ");
INSERT INTO hui_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Ani bereagola ibugua ti mo hongo halu lalu, Ibaha biraga bedamiru tígua hono dame bialu ibaha biru to̱lalimu. Egaru tíguabi nde dindi bibahendeha ega birai hole hono dame bialu biralimu, lene. ");
INSERT INTO hui_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Mbiraga piai halu ega bi layagola horo dauni ogoni hene. ");
INSERT INTO hui_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Maha Ngode Datagaliwabehanda lalu, Ai dindiha howa buhe̱wi tara tara dewaore birulene nga. Buhe̱wi uruni andaga hinu holenebi tayandaha minana birulenerubi bibahende emene timbunibi birai hadaba, layagola ani birai hene. ");
INSERT INTO hui_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Ibugua buhe̱wi andagaha hinu holenerubi tayandaha gabua yamo minana birulenebi bibahende hadaba layadagua naina íbu hai heagola ibuni bayaleoreyane hendene. ");
INSERT INTO hui_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Lone mani Ngode Datagaliwabe ibugua lalu, Áyu inane ale helonaga wali agali wabimi̱ya. Libugua buhe̱wi tara tara irabuha bedarubi andagani hinini bedarubi ibaha wena bedarubi dindi bibahendebi handaya ho helo wali agalila wabu helami̱ya, lene. ");
INSERT INTO hui_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Ani lowa Ngode Datagaliwabehanda wali agali wabu heleagola libubi ibuni ale dege ona hene. Ibugua walibi agalibi wabu helene. ");
INSERT INTO hui_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Ani hebigola Ngode Datagaliwabehanda libu mo hongo halu bi bayale mbira ogodagua lamini. Ibugua lalu, Dindi bibahende ngaruha wali agali hai howa dindini ngaru baya hangu handaya ho hai helo waneigini hono wialu halibu. I̱na ega bedaru ibaha wena bedarubi dindini buhe̱wi timbuni emene bedarubi uruni bibahende libugua haru hai halibulo ngerogoni. ");
INSERT INTO hui_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Libu nalibulo ira lini daganeru tani lini daganeru i̱na libu ngerogo tomo uruni nalu halibu. ");
INSERT INTO hui_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Anigo ai nogo egarubi buhe̱wi tara tara bedaru ti datani yuni bu karuni nalu helo merogoni, lene. Ai henene Ngode Datagaliwabehanda layagodagua aniore bini. ");
INSERT INTO hui_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Ibunime handalu hearia mbirale bibahende bayaleoreyane hendene. Mbiraga piai halu ega bi layagola ogoni horo waragane hene. ");
INSERT INTO hui_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Ogonidagua bialu Ngode Datagaliwabehanda dindi haribi bibahende uruniha karu ngarubi wabiai hene. ");
INSERT INTO hui_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Horo kane hayagola ibunaga biabe bibahendeore bu maro biruyane hondowa horo kaneni ibuni ha̱lo hene. ");
INSERT INTO hui_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Ibunime horo kaneore tara wubagi helowa lalu, Sarere bibahendenaga horo kane i̱ninaga ngelarogoni, lene. ");
INSERT INTO hui_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Horo marungi mbirale bibahende wabu helalu hayago ai horo kane ogoningi ibuni ha̱lo birulene wubagiho ngelene. Anduane Homogo Ngode Datagaliwabehanda dindi haribi wabu ngelenego ");
INSERT INTO hui_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","dindi ogoriani dalu ibulene mbira ibugua wabia nabi wiagola ai datani irarubi mbira anda nahaga wini. Dindini tomo hongolene wali agalibi nahe dege wini. ");
INSERT INTO hui_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Dalu naibagago dindiha howa iba dugu daga haga biagagome dindi bibahendeni iba birai hene. ");
INSERT INTO hui_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Mani howa Anduane Homogo Ngode Datagaliwabehanda dindi duguwa dindi ogonime agali mbira wabini. Naina wabu ngelowa ngui harigaha buhe̱ lolene pulaanda hayagola agali biago ibu buhe̱ lolenewi hene. ");
INSERT INTO hui_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Ani bialu Anduane Homogo Ngode Datagaliwabe ibugua mabu mbira ni tagira ibiragohayagi Ideneni hengene. Ani buwa ibugua agali wabiyago mabu ogoniha helene. ");
INSERT INTO hui_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Ani helowa ibugua dindiha howa tomo anda helayagola ira lini baya dagaru mabuni andaho helene. Ira lini daga uruni bibahende bayale dege dege hene. Ai mabu dombeni haabo holene miaga ira mbira hene. Ani bialu ogoriani dege ira mende ko bayalela manda bulenenaga mabu ogoniha hene. ");
INSERT INTO hui_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Idene dindini mabu winidagoni mo bayale halu dindi mo gomba helonaga iba mbira mabu ogoniha ibilene. Iba ogoni ibu gene maria pugupugu bini. ");
INSERT INTO hui_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","12","Iba mbirago mini Pisono ogonime dindi Habila pu mabu bialu peda. Dindi Habila ogoniha ngolo dewa wialu ira ibane ngabiaga ale dewa ogoniha halu bida. Ai ege to̱le̱ dege baya tara mbira muni dewaoreme miaganego ogoni mini kaniliana lagago ogonialebi dindi ogoniha wialu bida. ");
INSERT INTO hui_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Iba mendego mini Gihono pedago ogonime dindi Kusi mbira ngago pu mabu bialu peda. ");
INSERT INTO hui_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Iba tebone porago mini Taigirisi ogoni ibu ni tagira ibiragohayagi Asiria dindiha pupe halu peda. Iba manego mini Yuberedisi peda. ");
INSERT INTO hui_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Anduane Homogo Ngode Datagaliwabe ibugua agali wabiyago haru puwa Idene mabu biagoha howa handaya ho helo helene. ");
INSERT INTO hui_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Ani buwa ibugua agali biagohondo lalu, Ira o karuni bibahendenaga lini do naga bibe. ");
INSERT INTO hui_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Anigo ira mbiraore ko bayalela manda bibelonaga mini dugua haga o kagonaga lini dege do noleni nadonabe. Nanabe laro do nariyagua í̠ni abaleore homolebere, lalu lamini. ");
INSERT INTO hui_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Ani lowa Anduane Homogo Ngode Datagaliwabe ibugua lalu, Ainde agali ibuni hangu holene nakarulapedago. Ibu biamogo bilonaga ibuni aleore mbirali wabuliya, lene. ");
INSERT INTO hui_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","20","Ani lowa ibugua dindime nogo egarubi ema bialu piaga bibahende wabiniru agali biago bereagoria tinaga mini hangu hangu wigi bilo haru ibuwa helene. Ani biyagola agali biagome uruni bibahende mini wiai hene. Ema bialu piaga gabua tagiraha biragabi andagaha hinagabi ega bedarubi bibahendeore mini wiai hene. Bibahendenaga mini agali ogoni ibugua winidaruni áyu wiaabo ka. Anigo ema bialu piaga uruni aria mbiraoremebi Adamala bi te lo halu ibu biamogo bulene ibuni ale mbira nahe wini. ");
INSERT INTO hui_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Ani heagola Anduane Homogo Ngode Datagaliwabehanda agali biago mo paliahondo helowa agali ogoninaga kuabene kuni mbira gilila muwa dongone heneyadagua hadai bilene. ");
INSERT INTO hui_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Ani buwa kuabene kuni biagome ibugua wali mbira wabu helowa mani agali biago hearia haru pene. ");
INSERT INTO hui_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Agali biagome wali biago hondowa bi ogodagua lene. Agua i̱ni aleore ogonida. I̱naga kunime ibunaga kuni heneda. I̱naga tinginime ibunaga tingini hela howa Ngode Datagaliwabehanda i̱naga kuabene kunime wabiyadago. Ai i̱na ibu mini wali wero, lene. ");
INSERT INTO hui_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Ani binigome mana ogobi winigo ngagoni. Agali ibugua ibu aba ai̱ya helalu ibu onela mandagi howa libu ho mbiraore holebira lenego nga. ");
INSERT INTO hui_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Wali agali libu hura dambale payaburu nabi howa libu taga nahaga hene. ");
INSERT INTO hui_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Anduane Homogo Ngode Datagaliwabehanda ema bialu piagaru bibahende wabiai howa berelenego uruni ti puyame ohaga berenegobi mbira naberene. Puya ibugua wali biagohondo ogodagua hale halu lalu, Ngode Datagaliwabehanda mabuha ira lini bibahende dedaruni mbira donabe nale mbauleda, lene. ");
INSERT INTO hui_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Ani layagola wali biagome ladai bialu lalu, Iyame ira bibahende karunaga lini do nolene karulapego. ");
INSERT INTO hui_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Ibugua ira mbiraore hangu amu mabu hanuni kagonaga lini dege nado nalibu. Libu homoligo elabi nahalibu laya, lene. ");
INSERT INTO hui_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Ani layagola puya biagome ke̱ howa wali biagohondo ladai bialu lalu, Bi ogoni henene ndo. Libu nahomoleberabi. ");
INSERT INTO hui_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Libugua ira ogoninaga lini do naribiyagua libunaga de ngalalu Ngode Datagaliwabe ibuni ale dege howa ko bayaleru tale bulene miniha tagira ibai holebira ndobe. Anidagua bulebirago manda buwa Ngode Datagaliwabehanda libu ira lini ogoni nadonalibu layada, lene. ");
INSERT INTO hui_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Ani layagola wali biagome ira ogoninaga lini bayaleore nolene karulape dewa dearia hondowa ibu mini dewa wialu hene. Aniore buwa wali biagome manda bialu, I̱na ira lini ogoni do nowa miniru dingidangialeore biraruyagua karulapedago manda bini. Ani manda buwa wali biagome ira ogoninaga lini mbira do nalu maru ibu agalini nelo miyagola agali ibubi nene. ");
INSERT INTO hui_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Nai howa libunaga de ngala hayagola handalu hebira libu tibabe haribayane hendene. Ani hondowa libugua ira yuni mbalape lebumaga howa aga biagadagua buwa hene. ");
INSERT INTO hui_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Ani bu hebira alendo hayagola Anduane Homogo Ngode Datagaliwabe uyu mabuha ibagabu hayuago hale halu libu irabu teha puwa ha do hene. ");
INSERT INTO hui_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Ani hebira Anduane Homogo Ngode Datagaliwabe ibugua agali biago olowa lalu, Í̠ agoha kebe, lene. ");
INSERT INTO hui_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Ani layagola agali biago ibugua ladai bialu lalu, Í̠ mabuha ibayuago hale howa i̱ tibabe haruyagola gi howa ogoha ha do ko, lene. ");
INSERT INTO hui_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Ani layagola Ngode Datagaliwabehanda ibuhondo hale halu lalu, Í̠ tibabe haruda lowa agua handaribe. Í̠ ani kegoni lalu langiyadago aiwabe. Ira lini nadonabe larugo donaribe, lene. ");
INSERT INTO hui_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Ani layagola agali biago ibugua ladai bialu lalu, Í̠na wali i̱ni ale dege i̱la holobaya ngirigome ira lini ogoni do ngiyagola naru, lene. ");
INSERT INTO hui_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Ani layagola Anduane Homogo Ngode Datagaliwabehanda wali biagohondo lalu, Í̠na ogoni biridago aginagabe, layagola wali biago ibugua ladai bialu lalu, Puyame ohowa nolenego do na layagola i̱na ira ogoninaga lini do naru, lene. ");
INSERT INTO hui_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Anduane Homogo Ngode Datagaliwabehanda puya biagohondo lalu, Áyu i̱na í̠ ha halu mo ko howa bi hongoheore laro. Genda timbuniore í̠na yulebere. Genda ema bialu piaga maru bedarume yulebiraru emene lowa í̠naga genda timbuni bolanguahe yulebere. Ai áyu ogoni howa í̠ tombeme pialu dindi himu abalu ngaru dugu naga bima piaga birulebere. ");
INSERT INTO hui_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","I̱na í̠ walila mo waitigi helowa ibunaga aguanene í̠naga aguaneneru baba waitigi haabo holebira. Wali aguanene mbiru ibugua í̠naga haguane tagada hengeda haragola í̠na ibunaga ge ayuendeni hayulebere, lalu lene. ");
INSERT INTO hui_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Wali biagohondobi nde Ngode Datagaliwabehanda ogodagua lalu, Ai í̠na wali gali bere biruwa ndelaheore handalu birabelo mo ngero. Ani biruwa nde waneigini taba hanarengi tandaga timbuniore habe. Anigo uruni embeda howa í̠na í̠ agalini hame lalu biraabo howa ibu andaneha birulebere, lene. ");
INSERT INTO hui_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Ani lowa Ngode Datagaliwabe ibugua Adamahondo ogodagua lalu, Í̠na í̠ onenaga bi hale howa ira lini nadonabe larugo do naridago. Anidagua biridagonaga i̱na tomo bayuwa anda hai nahelo dindi ogo mo ko harogoni. Ani berogola tomo karulape anda helonaga horo bibahendengi erekui biabe biaabo holebere. ");
INSERT INTO hui_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","19","Tomo hangaregola mamunali aniheru datani ko bu karu í̠ mabuha anda holebira. Ani biragola í̠na tomo bayale mbira hongowa bialu nole lo manda buwa hanga dege bialu keria poboyogo giligalalo howa hangalu holebere. Biabe ndelahe dege bialu kene í̠ homalu i̱na í̠ dindime wabirugo ai lone dindiha dai beregola í̠naga tingini dindi hodai bulebira, lene. ");
INSERT INTO hui_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Adama ibugua ibu one wali agali mani dewa holebirarunaga ai̱ya birulebirago manda buwa ibu mini Iba wini. ");
INSERT INTO hui_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Mani howa Anduane Homogo Ngode Datagaliwabe ibugua libunaga aga bilo nogo dongoneme wabu miyagola libu ogoni karulo hene. ");
INSERT INTO hui_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Mani Anduane Homogo Ngode Datagaliwabehanda lalu, Ai wali agalime ko bayalela manda bialu ina ale dege hayadago. Anigo iname libu haabobo holene miaga ira kagoria nahelami̱ya. Libugua ira ogoninaga linibi do nowa nahome haabobo holigo, lene. ");
INSERT INTO hui_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Ani lowa Ngode Datagaliwabe ibugua dindi mbira wali agali biago Idene mabuha howa bo batagi halu dindi ibuni wabiyagoha biabe bialu tomoru hangalu helo pelene. Ani biyagola wali agali libugua dindi tombalu biabe bialu tomo hongolene wini. ");
INSERT INTO hui_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Ibugua wali agali talia tagi howa lone dai buligonaga dahuliyali hongoherume Idene mabunaga gibuni ni tagira ibiragohayagi mamage helene. Ani buwa wai biagane ayu tibu ne gadele mbirani ira hungu bialu hego ogonime mabu bibahendeha mamage ibaga bialu helo helene. Wali agali haabobo holene miaga ira ogoni kagoria dai bulilono dahuliyali o biarubi ayu tibu ne gadele biagobi mabu ogoniha mamage haabo helene. ");
INSERT INTO hui_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adamahanda ibu onela mandagi hebigola wali ibu gali bere berene. Ani biralu ibugua igiri mbira taba hanayagola Adamahanda lalu, Anduane Homogohanda i̱ biamogo bialu igiri mbira ngiya, lowa igiri gali biago mini Keni wini. ");
INSERT INTO hui_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Mani Keni hamene Abele taba henene. Ai libu anda howa Keni ibu mabuha tomo hangaga halu Abele ibu nogo sibi hinaga hene. ");
INSERT INTO hui_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Horo mbirungi Keni ibugua ibu mabuni tomo wiaru maru bu yalu puwa Anduane Homogohondo lomabu mini. ");
INSERT INTO hui_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Ani biyagola Abele ibubi nde Anduane Homogohondo mbirale bo lomabu mule nogo sibi hungubaluaore habahe nogo angibuni piganeme igini wiyago ogoniore haru halu puwa bo delene. Ani biyagola Abele ibugua nogo sibi bo lomabu miyago handalu Anduane Homogo ibu turu hene. ");
INSERT INTO hui_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Kenihanda tomo Anduane Homogohondo bu lomabu miyago turu nahe hene. Ani biyagola Keni ibugua keba timbuni howa ngui higi bu hene. ");
INSERT INTO hui_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Ani bu heagola Anduane Homogohanda Kenihondo hale halu lalu, Í̠ keba howa ngui higi bu kegoni aginaga. ");
INSERT INTO hui_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Í̠na mana tigabi bulene ngadagua bidele nde i̱na ogoni karulape birida larogola í̠ni turuho kelego. Ai í̠na mana ko ngaruni biridago kome í̠ mo ko hole ka. Mana kome í̠ bope halu wayali hole hame lalu kago ai í̠nabi ibu bope halu wayali hole habe lene. ");
INSERT INTO hui_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Mani howa Kenihanda ibu hamene Abelehondo lalu, Ainde ibaga bialu mba, lene. Ani puwa Kenihanda ibu hamene Abele bo homelene. ");
INSERT INTO hui_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Ani bu hearia Anduane Homogohanda Kenihondo hale halu lalu, Í̠ hamene Abele agoha kabe, layagola Keni ibugua lalu, I̱ tobara. Agua biya í̠na manda beregola i̱ hamene haru haga i̱ harudabe, lene. ");
INSERT INTO hui_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Ani layagola Anduane Homogohanda Kenihondo ogodagua lalu, Í̠na mana ko ogoni aginaga biribe. Í̠ hamenenaga darama dindini wiagome i̱hondo agali ogoni pani mia lalu dugu biyago hale harugo. ");
INSERT INTO hui_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Áyu bi hongohe mbira í̠hondo ogodagua laro. Ai í̠ hamene balu homelarigonaga darama dindi ogome nelarigoni ndobe. Ani biridagonaga i̱na dindi ogonaga tomo anda holenego mo waharogola í̠na tomo hangalu nanolebere. ");
INSERT INTO hui_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Í̠na tomo hangariyagua dindime tomo bayale anda helo biamogo nabulebira. Ani biragola í̠naga dindi anda henene nga lene mbira nawi howa í̠ni tiga biragoha palia edede biaga holebere, lalu lamini. ");
INSERT INTO hui_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Keni ibugua bi ogoni hale howa Anduane Homogohondo ogodagua ladai bialu lalu, Genda í̠na áyu i̱ mo ngeregoni timbuoredago. ");
INSERT INTO hui_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Mabu e nahangabe lalu í̠ni kegoria nahe dindi kaundiaha hole pobe larida. Ani bialu i̱naga dindi anda henene mbira nawi howa i̱ni tiga biragoha palia edede biaga agali habe larida. Ani laridago nde agali mbiragome i̱ ngola hayagua i̱ homoliya bo waholobadago. Aiore gi ho kogoni, lene. ");
INSERT INTO hui_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Ani layagola Anduane Homogohanda Kenihondo lalu, Í̠na gi nahabe. Agali mbirame í̠ bayagua heneneore i̱na genda timbuniore mo mialu o bayagonaga pani agali karia homelo bolene wulebira, lene. Ani lowa Anduane Homogo ibugua agali mbirame Keni ngola howa nabelonaga manane mbira Keninaga tinginini helene. ");
INSERT INTO hui_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Ani biya handala Keni ibugua Anduane Homogo helalu dindi mbira mini Ibagadegebiaga Idene mabunaga ni tagira ibiragohayagi winigoha hole pene. ");
INSERT INTO hui_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Keni ibu onela mandagi howa wali ibu gali bere berene. Ani biruwa ibugua igiri mbira taba hanayagola igiri ogoni mini Inogo wini. Mani howa Keni ibugua tano mbira bu winigo ogoni mini ibu igini Inogonaga mini wialu Inogo dege lene. ");
INSERT INTO hui_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Mani howa Inogo igini Irada hene. Irada igini Mehuyale hene. Mehuyale igini Medusale hene. Medusale igini Lamege hene. ");
INSERT INTO hui_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamege ibu wali kira dabu binigo. Mbiragonaga mini Ada biralu mendego ibu mini Sila berene. ");
INSERT INTO hui_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada ibu igini Yabala taba henenego. Yabala ogoni ibu balai andaru bia howa nogo bulumaga hinaga karunaga aguanene hene. ");
INSERT INTO hui_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Yabala ibu hamene Yubala henego ogoni ibu ngida ga̱wa̱ hiliyularu laga karunaga aguanene hene. ");
INSERT INTO hui_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Mani howa Sila ibugua nde igiri mbira taba honowa ibu mini Tubala Keni wini. Igiri ogoni ibugua ege to̱le̱ boronosi aeanerume mbirale wabiaga hene. Tubala Keni ibu mbalini mbira berenego ogoni ibu mini Nama berene. ");
INSERT INTO hui_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Horo mbirungi Lamegehanda ibu one kira biago labohondo ogodagua lene. Ada Silala-o libuore Lamege i̱ oneore bedabigonigo áyu i̱na bilarogoore baya hangu hale hadaba. Agali mbirame i̱ balu hearia i̱na ibu bo tongolo milaru. Igiri daliahe mbirame i̱ to̱a balu hearia i̱na ibu bo tongolo milaru. ");
INSERT INTO hui_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Ai agali mbirame Keni homelo bayagonaga pani agali karia homelo bolene nga manda biyagua agali mbirame i̱ bayagua ogoninaga pani agali ngui laa̱i̱ bo waholene wulebira, lalu lene. ");
INSERT INTO hui_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Mani howa Adama ibu onela mandagi howa wali ibu gali bere berene. Ani biruwa ibugua igiri tebone taba henene. Taba honowa wali biagome lalu, Kenihanda ibu hamene Abele bo wahayagonaga aribia halu Ngode Datagaliwabehanda igiri mbira ngiyago. Ai Abele holene winigoria igiri ogoni ibu ho aribia holebirago, lowa ibunaga mini Sede wini. ");
INSERT INTO hui_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Mani Sede ibu igini mbira hayagola ogoni ibu mini Inoso wini. Ogoningi howa wali agalime Ngode Datagaliwabe mitangi bialu lotu lalu howa ibunaga mini mende Anduane Homogo lalu lotu lalu hene. ");
INSERT INTO hui_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Adama waneigini aguaneneru hama ibinigo uru. Ngode Datagaliwabe ibugua wali agali wabialu ibuni aleore helo wabini. ");
INSERT INTO hui_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Ibugua walibi agalibi wabu helowa mo bayale holenaga bi lamialu libu mini wali agalila lene. ");
INSERT INTO hui_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Mani Adama ibu dindini heagola ibunaga mali handari mbirani pira tebira (130) hayagola ibu oneme igiri mbira Adama ibuni ale taba hanayagola ibugua igiri ogoni mini Sede wini. ");
INSERT INTO hui_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Ani wialu mani Adama ibu waneigini maru hono wigi bialu heane mali handari halira (800) pene. ");
INSERT INTO hui_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Ibu dindini heane dege mali hama ibinigo lamaga howa handari dirani pira tebira (930) hayagola Adama ibu homene. ");
INSERT INTO hui_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Adama igini Sede ibu mali handari mbirani duria (105) heangi ibu oneme igiri mbira mini Inoso taba hanayagola Sede ibu igiri ogoninaga aba hene. ");
INSERT INTO hui_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Ani howa Sede ibu waneigini marubi heagola ibunaga mali handari halirani karia (807) hene. ");
INSERT INTO hui_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Ani howa nde Sede ibu mali handari dirani homberia (912) bibahende halu homene. ");
INSERT INTO hui_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Ainde Inoso ibu mali hama ibinigo pira dira (90) hayagola ibu igini Kenana hene. ");
INSERT INTO hui_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Mani Inoso ibu waneigini marubi heagola mali handari halirani pira mbirani duria (815) hene. ");
INSERT INTO hui_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Inoso ibu dindini heane dege mali bibahende handari dirani duria (905) halu homene. ");
INSERT INTO hui_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenana ibu mali pira karia (70) hayagola ibu igini mini Mahalalele hene. ");
INSERT INTO hui_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Ani howa mani ibu waneigini marubi halu ibu mali handari halirani pira maria (840) hene. ");
INSERT INTO hui_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Kenana ibu dindini heane dege mali handari dirani huniane pira mbira (910) hayagola ibu homene. ");
INSERT INTO hui_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalalele ibu mali pira waragariani duria (65) hayagola ibu igiri Yarede aba hene. ");
INSERT INTO hui_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Mahalalele ibu waneigini marubi heagola mali handari halirani pira tebira (830) ha dege bini. ");
INSERT INTO hui_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Ani howa Mahalalele ibu mali handari halirani pira dirani huniane duria (895) hayagola homene. ");
INSERT INTO hui_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Anigo nde Yarede ibu mali handari mbirani pira waragariani kira (162) hayagola ibu igini mbira Inogo hene. ");
INSERT INTO hui_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Yarede ibu waneigini marubi heagola mali handari halira (800) hene. ");
INSERT INTO hui_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Ibu mali henego bibahende lamaga halu handari dirani pira waragariani kira (962) hayagola ibu homene. ");
INSERT INTO hui_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Inogo ibu mali pira waragariani duria (65) hayagola ibu igiri mbira Medusela henego aba hene. ");
INSERT INTO hui_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Inogo ibu Ngode Datagaliwabela nenegeore ho hene. Ani henego ibu waneigini marubi heagola mali handari tebira (300) hene. ");
INSERT INTO hui_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Inogo ibu mali bibahende henego daga lamaga halu handari tebirani pira waragariani duria (365) howa ");
INSERT INTO hui_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Ngode Datagaliwabehanda ibu mo yu ereba hayagola wali agalime ibu lone handa walia nahene. Ibu abale dindini hayangi Ngode Datagaliwabela nenege haaboore henegome ani bini. ");
INSERT INTO hui_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Medusela ibu mali handari mbirani pira halirani karia (187) hayagola ibu igini mbira mini Lamege hene. ");
INSERT INTO hui_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Medusela ibu waneigini marubi heagola mali handari kariani pira halirani kira (782) ha dege bini. ");
INSERT INTO hui_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Ani henego ai ibu dindini heane dege mali daga lamaga halu handari dirani pira waragariani dira (969) halu homene. ");
INSERT INTO hui_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Medusela igini Lamege ibu mali handari mbirani pira halirani kira (182) hayagola ibu igiri mbira aba hene. ");
INSERT INTO hui_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Ibu igini ogoni mini Noa wuwa ibugua lalu, Bamba Anduane Homogohanda bi hongohe mbira lo wialu lalu, Dindi ogo mo ko holebero, layago ai dindi ogoniore mo ko hene ngagoni. Iname tomo bayaleore anda helo biabe erekuibi bialu haabo harimagoni. Ainde igiri ogoni ibugua dindini tomo mo anda helonaga malia howa emene tigimbira hanguni ha̱lo holeberema, lene. ");
INSERT INTO hui_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Lamege ibu waneigini marubi heagola mali handari duriani pira dirani duria (595) hene. ");
INSERT INTO hui_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Ani henego ai Lamege ibu dindini heane dege mali bibahende daga lamaga halu handari kariani pira kariani huniane karia (777) halu ibu homene. ");
INSERT INTO hui_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Noa ibu mali handari duria (500) hayagola howa ibu igini tebira henego mini Seme Hama Yabede imaru hene. ");
INSERT INTO hui_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Dindini wali agali dewaore ho dame bialu uruningi wandari dewa berene. ");
INSERT INTO hui_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Dahuliyali tara tigua handalu hemiria wandari baya birama pearia hendene. Ani hondowa tini hame layadagua haru pugu buwa dabu bigi bini. ");
INSERT INTO hui_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Ani biyagola Anduane Homogohanda lalu, I̱naga dinini wali agali uruni tiha helo mialu holene tiha pulanda harugo. Ai nde ti dindi tawe hangu haragonidago wahalu i̱naga dinini tiha haho wia nabilonaga tinaga mali mo tubagi halu handari mbirani pira kira (120) hangu halu homelo, lene. ");
INSERT INTO hui_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Uruningi howabi maha howabi agali ndo timbu gibiru dindini haga bini. Agali timbuni uruni wandari berearume dahuliyali hearu baba kayu yuwa hono wini. Agali timbuni uruni ti mini lene howa tigua biabe dewa tara tara wiaru biai haga hene. ");
INSERT INTO hui_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Anduane Homogo ibugua handalu hearia wali agali dindi bibahendeha hearume mana koore wiaru bialu howa tigua mana ko ngubi wiaru hangu bule manda bu hearia hendene. ");
INSERT INTO hui_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Ani biyago hondowa ibugua lo mitangi bialu lalu, Ainde wali agali uruni nawabidole nde bayale ngaleda, lowa Anduane Homogohanda ibu miniha genda ho hene. ");
INSERT INTO hui_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Genda howa ibugua lalu, Wali agali uruni i̱nime wabu helene biarunidago ai dindi bibahendeha wali agali karu bibahendeore bo wahai holiya. Ega tia nogobi bibahende ema bialu piaga irabuha biraga gabua bedarubi andagaha wali agalime hinaga karubi bibahende i̱nime wabirugo nabidole nde bayale kaleda. Ai uruni bibahendeore bo hilo wahai holiya, lene. ");
INSERT INTO hui_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Ani la lowa Anduane Homogo ibugua Noahondo dege turuho hene. ");
INSERT INTO hui_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","10","Noa ibu igini tebira henego urunime tinaga mini Seme Hama Yabede imaru hene. Noa ibu agali bayale howa Ngode Datagaliwabenaga deni ibu tigabiore howa ibuni Ngode Datagaliwabenaga nenegeore hene. ");
INSERT INTO hui_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Anigo Anduane Homogo ibugua handalu hearia dindi bibahendeni wai hangu bigibigi bialu mana ko timbuni dewaore biyaria hendene. ");
INSERT INTO hui_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Ibugua dindi bibahendeha mana ko bulene timbuni tagira ibalu wali agali bayale tigabi dindi mbirani heane nahende. Bibahendeme mana ko wiaru hangu bule de buyu hearia hendene. ");
INSERT INTO hui_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Ngode Datagaliwabehanda Noahondo ogodagua lalu, Dindi bibahendeni wali agalime mine howa tini bagabaga bialu wai dege bialu karuni mangabago ai bo wahai holebero. Wali agali dindini yu wahene mbira naholebira. ");
INSERT INTO hui_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Anigo í̠na irabuha ira bayaleoreru handalu dibu pelowa iba talu mbira wabibe. Iba talu ogoniha hobane maru helalu tamuha tagiraha howabi diri nawilo wagayame ndibu lelo para hai habe. ");
INSERT INTO hui_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Iba talu ogoni ogodagua wabibe. Luninaga mida magi handari mbirani pira tebira (130) wialu aranenaga mida magi pira kirani kira (22) wibe. Bima iraga hole mida magi pira mbirani tebira (13) wibe. ");
INSERT INTO hui_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Iba talunaga danginihayagi bule howa dangini ibu háila bu ndibu nale hái danginila hengeneha henge wá anda ibilonaga ngelabe. Tamuha hobane tebira helo. Hobane mbira dindiha mendego obeneni tebonego danginila tubariha helabe. Ani buwa panga haraba mbira abenehayagi dugu wibe. ");
INSERT INTO hui_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Ani bidegola i̱na dalu timbuni ibilowa dindini ema bialu piagaru bibahende bo wahai hole iba li timbuni ibilolebero. Ani berogola dindini karubi ngarubi bibahende homaiore holebira. ");
INSERT INTO hui_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Anigo í̠la dege habo nalolene bi lo werogo. Í̠ one waneiginibi í̠ igini ti onerubi tí bibahende í̠ni heba iba taluha anda puwa biralimu. ");
INSERT INTO hui_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Ai ema bialu piaga dameneru mbira mbira angibuni taubi kira kira haru halu tini heba iba taluha anda pilimu. ");
INSERT INTO hui_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Ega tia bedarubi nogo damene bibahendebi ema bialu piagaru bibahendeore angibuni wangabela kira dege dege tini heba homa nabi berelo iba taluha haru anda pilimu. ");
INSERT INTO hui_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Ani buwa tininaga tomo nolenebi ema bialu piaga uruninaga tomo karulape nalu berelobi tíni nagane alego iba taluha bu ngelalimu, lalu lamini. ");
INSERT INTO hui_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Ani layagola Noa ibugua Ngode Datagaliwabehanda lamiyadagua bibahende biai hene. ");
INSERT INTO hui_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Mani Anduane Homogohanda Noahondo lalu, Í̠ hangu wali agali dindini karubi ndo tigabi harigoni handarugo. Ai í̠ one waneiginirubi iba taluha anda piai halimu. ");
INSERT INTO hui_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Ani bialu ema bialu piaga i̱naga deni bayale karu arianaga angibuni karia wangabe karia lowa haru anda pilimu. Anigo ema bialu piaga i̱naga deni bayale ndo karu angibuni wangabebi mbiraore dege dege haru anda pobe. ");
INSERT INTO hui_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Anidagua dege ega bedarubi nde angibuni wangabebi karia dege dege haru anda poregola ti homa nabi biruwa mani dindini bira aribia holene tigua hono wilo ani bibe. ");
INSERT INTO hui_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Horo karu howa dalu timbuniore mbiraga horombebi lamaga halu pira mariani (40) dalu hangu ibiloleberogo iba dalu timbuni ogoni mbirale bibahende i̱nime wabiruruni iba lime nai helolebero, lene. ");
INSERT INTO hui_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Ani layagola Noa ibugua Anduane Homogohanda bibe layadagua biai hene. ");
INSERT INTO hui_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Noa ibunaga mali hama ibinigo handari waragaria (600) hayagola dindini iba li timbuni ogoni ibini. ");
INSERT INTO hui_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Noa ibu onebi libu iginiru tinaga onerubi bibahende iba li timbuni ibiragome nayilo abale iba taluha anda piai hene. ");
INSERT INTO hui_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Ani bialu ema bialu piaga Ngode Datagaliwabenaga deni bayale hearu ariabi ibunaga deni ko hearu ariabi angibuni wangabela kira dege dege minu baanda ");
INSERT INTO hui_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","halu ega berearubi ema bialu piaga bibahendeorebi minu baanda haiore howa Noa ibuni heba Ngode Datagaliwabehanda bibe layadagua iba taluha anda pu berene. ");
INSERT INTO hui_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Horo karu biago piai hayagola dindini iba li timbuni ibiyagome dindi bibahende namu lama iraga hene. ");
INSERT INTO hui_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Noa ibunaga mali handari waragaria (600) hayagola howa mali ogoninaga dege ege mendegonaga horo pira mbirani karia (17) hayagola horo ogoningi dindi andaneha panga dugua hayagola iba timbuni bereago peago pu daga hene. Ani bialu iba hari daligaha bereago panga dugua hayagola iba timbuni pugulope hene. ");
INSERT INTO hui_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Horo pira mariani (40) mbiraga horombebi dalu ibaho wiaabo hene. ");
INSERT INTO hui_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Horo pigane dalu ibiyadangi Noabi ibu onebi libu igini tebirali Seme Hama Yabede imarubi ti onerubi bibahende iba taluha anda piai hene. ");
INSERT INTO hui_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Ema bialu piaga irabuha biraga emene timbunibi andagaha biraga emene timbunibi bibahendeore Noa ibu damene biaru heba iba taluha anda puwa birai hene. ");
INSERT INTO hui_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","16","Ngode Datagaliwabehanda layadagua ema bialu piaga angibuni wangabela kira dege dege Noa heba iba taluha anda piai hene. Ani bereagola Anduane Homogohanda iba talunaga panga payini. ");
INSERT INTO hui_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Dalu iba libi íbu dege bialu heagola horo pira maria (40) hene. Iba biradaga hayagome talu yaraga halu dindi yu wahene. ");
INSERT INTO hui_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Iba bira timbu howa talu biago ibani yu ibagabu hene. ");
INSERT INTO hui_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Iba biradaga halu hari bare wiaru namu lai hene. ");
INSERT INTO hui_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Maniore hayagola iba bira timbuore halu hari bare uruni yu wahai halu bolangua howa ge mandanaga karia birama iraga hene. ");
INSERT INTO hui_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Ani biyagola ema bialu piaga irabuha biraga emene timbunibi andagaha biraga emene timbunibi ega berearubi wali agali bu hearubi bibahendeore homai hene. ");
INSERT INTO hui_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Dindini anda holene damene wiaru homaiore hene. ");
INSERT INTO hui_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Anduane Homogohanda dindini buhe̱wibi anda haga alebi wali agali bibahendeore dindi hangu ngelalu bo hilo wahai henego. Noabi ibu damenerubi ema bialu piaga biarubi ega biarubi bibahende iba taluha anda pu birayaru ti dege iba li timbuni ibiyagome nai nahe tamuha bereagome yo pene. ");
INSERT INTO hui_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Iba biagome nde birama iraga dege halu heane horo handari mbirani pira duria (150) pene. ");
INSERT INTO hui_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Ngode Datagaliwabe ibugua Noa halu bibahende iba taluha birayaru mitangi hene. Ani mitangi howa Ngode Datagaliwabehanda puyabu iba bereagoria ibilayagola iba emene birama dalidali bini. ");
INSERT INTO hui_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Iba dindiha howa dugua daga hayago hundialu daligaha howa pugulope helo panga dugua hene biago payiyagola ai iba birayago hundiama dalini. ");
INSERT INTO hui_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Iba hundiama dalia dege bialu heane horo handari mbirani pira duria (150) pene. ");
INSERT INTO hui_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Ani bialu dege howa ege kanegonaga horo pira mbirani karia (17) hayagola iba talu biago hari mbira Ararada dindini weagoria yu paga hene. ");
INSERT INTO hui_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Iba wene hundiama dalia dege bialu heane ege pinigonaga horo mbira layagola hari wearunaga nene pani hai hene. ");
INSERT INTO hui_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Horo pira maria (40) peagola Noa ibugua windo mbira dugua howa ");
INSERT INTO hui_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","ega mbira minu batagi hene. Ega ogoni minu batagi hayagola yagalo yalu pene. Ani puwa lone dai nabi iba hundialu dindi yo biai helo ibu yagaloyu ibaga bialu hene. ");
INSERT INTO hui_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Ani biyagola Noa ibugua iba hundialu dindi pani hayadabe hondole ega mende mini malibu minu batagi hene. ");
INSERT INTO hui_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Ani biyagola ega biago ibu birulene henge nawi dindini iba biraho wiagola ibu iba taluha lone dai bini. Ani dai biyagola Noahanda gi yatagi howa ega malibu biago iba taluha minu yamini. ");
INSERT INTO hui_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Ani bialu Noa ibugua horo karia biruwa ega malibu biago lone minu batagi hene. ");
INSERT INTO hui_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Ega biagome pialu alendo hayagola ira olibenaga yuni gahenge mbira ibunaga neme gilo yalu Noa berearia taluha lone dai bini. Ani biyagola Noa ibugua iba hundiai hayidalo manda bini. ");
INSERT INTO hui_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Ani manda buwa ibugua horo karia howa ega malibu biago lone minu batagi hene. Ani biyagola ega biago ibu dai nabi puabo hene. ");
INSERT INTO hui_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Noa ibunaga mali handari waragariani mbira (601) howa mali ogoninaga ege mbiranaga horo mbira hayagola iba biago wene dege hundialu hene. Noa ibugua iba talu biagonaga dangini mbira gialowa handa tagi hene. Handa amu nana bialu hearia iba wene dege yo bialu hearia hendene. ");
INSERT INTO hui_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Ai ege mendegonaga horo pira kirani karia (27) hayagola dindi bibahende yobiai hene. ");
INSERT INTO hui_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","16","Ani biyagola Ngode Datagaliwabehanda Noahondo bi ogodagua lalu, Ai áyu í̠ onebi í̠ iginirubi tinaga onerubi tí bibahende iba taluha howa tagira pudaba. ");
INSERT INTO hui_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Ega bibahende bedarubi nogo tara tara biarubi bibahende tíni heba haru tagira pilimu. Tigua dindi bibahende ngaruha purogo lalu hono dame bilo, lene. ");
INSERT INTO hui_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Ani laya handala Noabi ibu one iginirubi ti onerubi ti bibahende iba taluha howa tagira pene. ");
INSERT INTO hui_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Nogo tararubi egarubi ema bialu piaga bibahendebi ti nde tini aria dege dege piyadagua mandagi wabuni pugupugu bialu iba taluha howa tagira piai hene. ");
INSERT INTO hui_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Noa ibugua mbirale bo lomabu delaga dabu mbira naina bu helene. Ani bia howa nogo egaru Ngode Datagaliwabenaga deni ko nabi bayale damenerunaga mbira dege dege ibunihondo bo lomabu delole bene. Bowa dabu bia hayagoria lomabu delene. Ani bo lomabu delayagola ");
INSERT INTO hui_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Anduane Homogohanda loma biagonaga ngaore baya tara dendebiore biyagola ibugua lalu, Wali agalime ko biragonaga mani pani mialu dindi ogo halu mende mo ko naholebero. Wene wandari igiri emene ko howa mana ko bulenela haru anda hagago. Nde wali agalibi ema bialu piaga bedarubi ti halu mende naboleore. ");
INSERT INTO hui_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Ai mani tu wigi buwa tomo hongolene henge wialu tomo bulene hengebi wulebira. Ani bialu dindi ogoria ni bayale poboyogobi dolenebi dagarengi holenebi henge wulebira. Dalu ibalu gaea bulene hengebi wia dege bulebira. Dindi ogo mo ko halu ereba nahe ngaha horo uru anidaguaore wiaabobo bu wulebira, lalu Anduane Homogohanda lene. ");
INSERT INTO hui_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Ngode Datagaliwabehanda Noabi ibu iginirubi ti bayale helonaga bi ogodagua lalu, Dindi bibahendeni wali agali palu to̱lelo tígua waneigini dewa hono wialu halimu. ");
INSERT INTO hui_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Nogo tara tara karubi iba wena ega tia bedarubi ema bialu piaga bibahende irabuha gabua biragarubi andagaha hinini bedarubi uruni bibahende tígua handameho halimulo helarogoni. Uruni tigua wali agali hondowa gi halu birulebira. ");
INSERT INTO hui_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Ai tígua ema bialu piaga dindini biraga bedaru bowa nema bayale andaho ngaru heba tínaga tomo dawa nalu halimulo i̱na ngero. ");
INSERT INTO hui_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Mbiraore hangu nanolene ngago ogo. Nogo egaru bowa darama bedaore nanalimu. Darama ogonime dére holene ngiaga tene nga. ");
INSERT INTO hui_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Mbiralime wali agali maru balu homelayagua i̱na ibu biragonaga pani genda timbuniore yu helolebero. Nde ema bialu piaga bedagomebi wali agali mbirago balu homelayagua i̱na ibuniore bo waholebero. ");
INSERT INTO hui_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Mbiralime wali agali mbira Ngode Datagaliwabehanda ibuni ale helo wabinigo balu homelayagua wali agali maru karume baga kago ibunibi bo waholene nga, lene. ");
INSERT INTO hui_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Ngode Datagaliwabehanda lalu, Dindi bibahendeni tínaga aguanene palu to̱lelo tígua waneigini dewaore hono wilimu, lene. ");
INSERT INTO hui_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Ani lowa Ngode Datagaliwabehanda Noabi ibu igini biaruhondobi ogodagua lalu, ");
INSERT INTO hui_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","Áyu howa tínibi tínaga aguanene mani hama polebiraruhondobi i̱na habo nalolene bi mbira lo ngero. ");
INSERT INTO hui_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Ani bialu ema bialu piaga nogo egarubi tia bedarubi ema bialu piaga iba talu biagoha berene tagira ibiyaru bibahendehondo habo nalolene bi mbira lo wialu bulebero. ");
INSERT INTO hui_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Tí baba habo nalolene bi ogoni ogodagua lo ngelaro. Aiore iba lime ema bialu piagaru lone bo wa naholeore. Iba lime dindi ogobi halu mende namulai naholebiraore laro, lene. ");
INSERT INTO hui_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","13","Ngode Datagaliwabehanda lalu, Ai i̱na tí bababi ema bialu piaga bedaru bababi habo nalolene bi lo werogo heneneore lowa walia halu ni domo mbira harini helolebero. Ni domo ogonime dindini ngarubi karubi bibahendeore baba habo nalolene bi lo werogoni heneneore lalu walia holene manane ogoni holebira. ");
INSERT INTO hui_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","I̱na ginu hagua harini íbu helarogola ni domo ogonibi íbu holebira. ");
INSERT INTO hui_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","Ani íbu kago hondowa i̱na wali agalibi dére ale ema bialu piagarubi iba lime halu mende nai nahelole lalu habo nalolene bi hongohe lo wirugo lone mitangi bu dai bulebero. ");
INSERT INTO hui_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Ai i̱na ni domo naina harini kagola hondowa i̱na nde wali agalibi ema bialu piaga damenerubi bibahende lone naboleore lalu habo nalolene bi hongohe lo wirugoni mitangiore bulebero, lene. ");
INSERT INTO hui_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Ani lowa ibugua Noahondo bi ogodagua lamialu, Ni domo ogoni i̱na dindi bibahendeni ema bialu piagaru heba habo nalolene bi lo wirugoninaga manane ogoni holebira, lene. ");
INSERT INTO hui_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Noa igini ibuni heba iba taluha biralu tagira ibinidaru ti Seme Hama Yabede imaru hene. Hama ibu Kenana aba hene. ");
INSERT INTO hui_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Noa igini uruni ti wali agali dindi bibahendeha hama pedarunaga mamali hene. ");
INSERT INTO hui_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noa ibu agali e hangaga howa pu mbira mini gerebi lini dagane mabuha hangaga pigane ibu hene. ");
INSERT INTO hui_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Ani biaga henego horo mbirungi ibu waini iba hambu na timbu bialu luluyu howa ibuninaga balai anda tamuha agaru golo wahai halu mo koho palu wini. ");
INSERT INTO hui_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Ani palearia Kenana aba Hama ibugua ibu aba aga nabi tibabe paleago hondowa ibu hamene kirali biago labo lamule pene. ");
INSERT INTO hui_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Lamiyagola Seme Yabede libugua aga mbira libu aba aga nabi paleago hondoligonaga libuni de geho yalu tigibebege pialu libu abanaga balai anda ibuni tibabe paleagoha anda puwa agame bu dambi hene. Libu aba tibabe paleago nahende handa taraho yalu dai bini. ");
INSERT INTO hui_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Ai Noa ibu palenego heyuwa lulu ereba hayagola hale halu hearia ibu igini heyogone biagome aga nabi paleago handaya layagola hale hene. ");
INSERT INTO hui_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Ani hale howa Noahanda lalu, Kenana ibu genda timbunioreme dambi hene íbu holebira. Ibuore ibu hamenerunaga garabaya biabe ale biaga holebira. ");
INSERT INTO hui_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Semenaga Ngode Datagaliwabe Anduane Homogo ibunaga mini yaraga hama. Kenana ibu Semenaga garabaya biabe ale bia haga holebira. ");
INSERT INTO hui_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Yabede waneigini Ngode Datagaliwabehanda mo dewa helo. Ibunaga aguanene ti Seme waneiginiru heba mandagi helo. Kenana ibu Yabedenaga garabaya biabe ale biaga dege holebira, lalu Noahanda lene. ");
INSERT INTO hui_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Iba li timbuni biago ibini lo howa Noa ibu mali handari tebirani pira duria (350) hene. ");
INSERT INTO hui_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Ibunaga mali lamaga halu handari dirani pira duria (950) halu nde homene. ");
INSERT INTO hui_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Mini ogoha ngaruni Noa igini tebirali Seme Hama Yabede imaru henegonaga waneigini aguaneneru ogodagua hene. Wali agali uruni ti iba li timbuni ibiyago ibalu peaha mani ho aribia hene. ");
INSERT INTO hui_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Yabede ibu igini ogodagua hene. Gome Magogo Madai Yabana Tubala Mesege Tirasa imaru ti wali agali maha ha aribia hayarume tinaga mamali mini mo hameigini mini henego wiaabo ka. ");
INSERT INTO hui_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Ani henego Gome ibunaga aguanene Asagenasa Libada Togama imaru ti dindi uruninaga wali agali hene. ");
INSERT INTO hui_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Yabana ibunaga aguanene Elisali Sebenali Saibarasali Lodesealiru ti dindi uruni wali agali hene. ");
INSERT INTO hui_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Wali agali uruni ti áyu unu iba solowara bedago ange angeha paluyu pialu iba dege dombeneha dindi wupe haga bidaruha hearunaga mamali hene. Wali agali uruni ti Yabede aguanene hene. Wali agali uruni ti nde tini dindi wigiwigi binidadagua haga haga bialu tinaga bi lole bi nde tara tara lagalaga biaga hene. ");
INSERT INTO hui_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Hama ibu igini henego uru. Kusuali Iyibiali Libiali Kenanali haga biniru ti wali agali maha ha aribia hayarume mini uruni tinaga mamali mo hameigini mini laga bima ibinigo nga. ");
INSERT INTO hui_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kusu ibu aguanene Sebali Habilali Sabadali Lamali Sabadegaliru hene. Lama ibu aguanene Seba hameiginibi Dedana hameiginibi howa tinaga dindi minibi ogoni labo dege wini. ");
INSERT INTO hui_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kusu ibu igini mbirabi ha dege binigo ibu mini Nimirodo henego ibu dindi bibahendeha agali pari wayali haguane mbira nahe wiangi piganeore ibu hene. ");
INSERT INTO hui_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Anduane Homogohanda Nimirodo ibuhondo hongo miyagola ibugua nogo gabua ega yáriru ta nabi taya bialu baga hongohe mbira hene. Ani henego mitangi bialu wali agaliru ti mbirame nogo gabua egaru mbira pigane bayagua tigua lalu, Ogoni ibu Anduane Homogohanda Nimirodohondo taya bulenenaga hongo miyadagua ibubi taya bialu holenenaga hongo miyada, laga biaga wini. ");
INSERT INTO hui_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Nimirodo ibugua dindi handayaho kagoha tano timbuni mini lene maru uru Babilonobi Eregebi Agadabi tano tebira uruni Babilonia dindiha nga. ");
INSERT INTO hui_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Anigo Nimirodo ibu Babilonia wahalu Asiria dindihayagi puwa ibugua Ninibabi Lehobodiabi Kalabi ");
INSERT INTO hui_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","Lesenebi tano uruni mo heya halu bu helaga bini. Lesene tano ogoni Niniba tanola tano dunini timbuni Kala tanola hengene wiagoha wini. ");
INSERT INTO hui_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Iyibinaga aguanene Lidia hameiginirubi Anama hameiginirubi Lehaba hameiginirubi Nabadu hameiginirubi ");
INSERT INTO hui_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Padarusu hameiginirubi Kasalu hameiginirubi Kiridi hameiginirubi hene. Pilidia wali agali ti Kiridi hameiginime hono winigo Kiridi aguanene hene. ");
INSERT INTO hui_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kenana igini wahene Saidonobi ibu igini mende Hidibi libu wali agali maha ha aribia hayarume mini uruni tinaga mamali mo hameigini mini laga bima ibinigo nga. ");
INSERT INTO hui_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Yabusu hameiginirubi Amora hameiginirubi Giagasa hameiginirubi ");
INSERT INTO hui_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Hibi hameiginirubi Aga hameiginirubi Sini hameiginirubi ");
INSERT INTO hui_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Abada hameiginirubi Semara hameiginirubi Hamada hameiginirubi ti bibahendenaga mamali Kenana ibu hene. Kenanali uruni ti dindi wiagoha pugupugu bialu dindi tara tara wiaruha hai hene. ");
INSERT INTO hui_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Kenana ibunaga dindi arane timbuni Saidono tano howa wima pialu Gasa tanoha tano mbira mini Gera wiagoha wiairi hene. Mendehayagi wima pialu ni tagira ibiragohayagi Sodomo tano Gomora tanola wiagoria howa wima pialu Adama dindiha wima pialu Seboimi dindi pialu Lasa dindi wiago kawareni wiairi hene. ");
INSERT INTO hui_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Hameigini uruni ti bibahende Hama aguanene hangu hama ibinigo ti nde tininaga dindi haluni wigiwigi bialu tinaga bi tara tara lagalaga biaga hene. ");
INSERT INTO hui_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Seme ibu Yabede hamene wahene howa Hiburuali Ebe aguaneneru bibahendenaga mamali hene. ");
INSERT INTO hui_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Seme igini uru hene. Elama Asua Abagasada imaru Ludu Arama ti nde wali agali maha ha aribia hayarume mini uruni tinaga mamali mo hameigini mini laga bima ibinigo nga. ");
INSERT INTO hui_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Arama ibu aguanene urudagua hene. Usualibi Hulualibi Gedealibi Mesegealibi uruni ti Arama aguanene hene. ");
INSERT INTO hui_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Abagasada igini Sela halu Sela igini Ebe hene. ");
INSERT INTO hui_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Ebe ibu igini kira henego mende mini Pelege hene. Pelege ibu heangi wali agali dindi bibahendeha hearu ti tini headagua hoba migimigi bialu hagahaga bini. Ebe igini mendego mini Yogodana hene. ");
INSERT INTO hui_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yogodanahanda hono wini ibu aguanene urudagua hene. Alamodadalibi Selebealibi Hasamabedealibi Yaralibi ");
INSERT INTO hui_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoramalibi Usalalibi Digilalibi ");
INSERT INTO hui_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obalalibi Abimaelealibi Sebalibi ");
INSERT INTO hui_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Obialibi Habilalibi Yobabalibi uruni bibahendeore Yogodanahanda hono winiru howa ibu aguanene dege bu hene. ");
INSERT INTO hui_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Hameigini uruni ti Mesa dindi wiagoria howa palima pialu amuraore ni tagira ibiragohayagi hari bare bare Seba dindi wiagoria paliairi hene. ");
INSERT INTO hui_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Hameigini uruni ti bibahende Seme aguanene hangu hama ibinigo ti nde tininaga dindi haluni wigiwigi bialu tinaga bi tara tara lagalaga biaga hene. ");
INSERT INTO hui_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Hameigini uruni bibahendeore Noanaga aguanene howa ti dindi bibahendeha purogolo hagahaga bini. Ani binidaruni iba li timbuni ala wiyago hundiai hayagola iba taluha howa tagira ibini biaruni purogo lalu dindi tara taraha hameigini maha heneru ti bibahende Noa aguanene hangu hene. ");
INSERT INTO hui_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Bambaore dindini wali agali heneru ti bi mbiraore laga hene. ");
INSERT INTO hui_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Ti ni tagira ibiragohayagi howa yu dindi wiagohayagi hama pialu dindi mini Babilonia anda puwa ogoriani hene. ");
INSERT INTO hui_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Ani biruwa tini lala bialu lalu, I̱name abaleore dindi dugu mbera buwa ege timeni helo irani delami̱ya, lene. Ani lowa tigua ogonidagua bialu anda bule ege timeni wabu bila hene. Ege timeni uruni ndibu laga bulene wagaya tararu manda bu ngela dege bini. ");
INSERT INTO hui_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Ani ngelowa lalu, Ainde iname anda dewa bu helowa tano timbuni mbira ngelami̱ya. Tano ogoni dombeneni anda timbuni mbira bugimbu bu migi bima iraga howa hari damindini ela helo mbira bimi̱ya. Ani birimayagua iname bibahende dindi tara tarani hama purogo nale holeberamago. Ogoni hondowa wali agali maru karume inanaga mini yaraga helo ani bimi̱ya, lene. ");
INSERT INTO hui_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Ani bialu hemiria Anduane Homogo ibu daluwa tigua anda dewa buwa tano ngeleagobi tano ogoni dombeneha anda bima iraga heagobi hendene. ");
INSERT INTO hui_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Ani hondowa ibugua lalu, Ai áyu wali agali uruni ti hameigini mbiraore halu bi mbiraore laga karuni howa tano timbuni mbira bu heledago handa nabere. Ani bialu howa ai tinime hame ledadagua bialu mbirale bulene bibahende ngaru biai holobadago. ");
INSERT INTO hui_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Ani biyadagoni lehedago iname dalialu puwa wali agali tininaga bi hale nahene lagalaga bilo bi mo tara tara bimi̱ya ma, lene. ");
INSERT INTO hui_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Anduane Homogohanda tinaga bi mo tara tara lagalaga bialu dindi tara tarani hama purogo lelene. Ani biya handala tigua tano biago bumaro nabi wahalu purogo lene. ");
INSERT INTO hui_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Tano bialu henedagoni mini Babele. Irane Anduane Homogohanda wali agali uruni tinaga bi tara tara lagalaga bialu tinibi dindi bibahendeha hama purogo lalu pelene. Babele mini ogoni inanaga bi lalu Bi Mo Tara Tara Laga. ");
INSERT INTO hui_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Seme ibu aguanene hama ibinidaruni ogodagua hama ibini. Iba li timbuni biago hundiyagola mali kira howa Seme ibunaga mali handari mbira (100) hayagola ibu igini mbira mini Abagasada hene. ");
INSERT INTO hui_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Abagasada helowa Seme ibu mali handari duria (500) hama ibalu heagola ibunaga waneigini marubi hene. Ani ho helowa ibuni homene. ");
INSERT INTO hui_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Abagasada ibunaga mali pira tebirani duria (35) hayagola ibu igini mbira mini Sela hene. ");
INSERT INTO hui_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Sela helowa Abagasada ibu mali handari mariani tebira (403) hama ibalu heagola ibunaga waneigini marubi ha dege bini. Ani ho helowa ibuni homene. ");
INSERT INTO hui_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Sela ibunaga mali pira tebira (30) hayagola ibu igini mbira mini Ebe hene. ");
INSERT INTO hui_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Ebe helowa Sela ibu mali handari mariani tebira (403) hama ibalu heagola ibunaga waneigini marubi hene. Ani ho helowa ibuni homene. ");
INSERT INTO hui_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Ebe ibunaga mali pira tebirani maria (34) hayagola ibu igini mbira mini Pelege hene. ");
INSERT INTO hui_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Pelege helowa Ebe ibu mali handari mariani pira tebira (430) hama ibalu heagola ibunaga waneigini marubi ha dege bini. Ani bu helowa ibuni homene. ");
INSERT INTO hui_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Pelege ibunaga mali pira tebira (30) hayagola ibu igini mbira mini Leu hene. ");
INSERT INTO hui_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Leu helowa Pelege ibu mali handari kirani huniane dira (209) hama ibalu heagola ibunaga waneigini marubi hene. Ani helowa ibuni homene. ");
INSERT INTO hui_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Leu ibunaga mali pira tebirani kira (32) hayagola ibu igini mbira mini Serugu hene. ");
INSERT INTO hui_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Serugu helowa Leu ibu mali handari kirani huniane karia (207) hama ibalu heagola ibunaga waneigini marubi hadege bini. Ani bu helowa ibuni homene. ");
INSERT INTO hui_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Serugu ibunaga mali pira tebira (30) hayagola ibu igini mbira mini Naho hene. ");
INSERT INTO hui_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Naho helowa Serugu ibu mali handari kira (200) hama ibalu heagola ibunaga waneigini marubi hene. Ani helowa ibuni homene. ");
INSERT INTO hui_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Naho ibunaga mali pira kirani dira (29) hayagola ibu igini mbira mini Tera hene. ");
INSERT INTO hui_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Tera helowa Naho ibu mali handari mbirani pira mbirani dira (119) hama ibalu heagola ibunaga waneigini marubi hadege bini. Ani bu helowa ibuni homene. ");
INSERT INTO hui_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Tera ibunaga mali pira karia (70) hayagola howa ibu igini tebira henego mbirago mini Abarama mendego Naho tebonego Harana laga biyaru hene. ");
INSERT INTO hui_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Tera ibunaga igini Abarama Naho Harana imaru hene. Harana ibu igini Lode hene. ");
INSERT INTO hui_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Harana ibuni dindi Kaladiaha dindi emene mbira Ua winigoria ibu aba Tera nahome wene daliahe helalu ibu ala homene. ");
INSERT INTO hui_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abarama ibugua Sarai dabu biyagola Naho ibugua Harana wane Miliga dabu bini. Harana ibu igini Isagabi hene dege. ");
INSERT INTO hui_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Ainde Sarai ibu waneigini mbira taba hanabe naheore berene. ");
INSERT INTO hui_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Ani howa Tera ibugua Kaladia dindiha dindi emene mbira Ua winigo ogoni yu wahalu Kenana dindiha pole pene. Ibu heba penedaruni uru. Tera ibugua ibu igini Abaramabi ibu one Saraibi Tera aguane Harana igini Lodebi ti bibahende puwa Harana tanoni pu hene. ");
INSERT INTO hui_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Ani pu howa Tera ibu mali handari kirani duria (205) howa tano ogoriani homene. ");
INSERT INTO hui_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Anduane Homogohanda Abaramahondo lalu, Í̠naga dindibi í̠ hamenerubi í̠ aba ai̱ya damene karubi bibahende helalu dindi gahenge mbira i̱na walia holeberogoha pobelo. ");
INSERT INTO hui_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Ani poregola i̱na í̠naga aguaneru mo dewaore helolebero. I̱na í̠ biamogo bialu mini leneore helolebero. Wali agali mani holebirarume mendealihondo bi bayale lalu, Anduane Homogohanda Abarama biamogo binigodagua í̠bi nde biamogo bilo, laga bulebira. ");
INSERT INTO hui_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Wali agalime í̠ biamogo biyagua nde i̱nabi ti biamogo bulebero. Mbiralime í̠hondo mo ko holene bi layagua nde i̱nabi ti mo ko holebero. Anigo í̠ha howa wali agali bibahende dindi tara tarani mani holebiraru i̱na ti biamogo bialu mo bayale helolebero, lene. ");
INSERT INTO hui_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Ani laya handala Abarama ibugua Anduane Homogohanda Harana dindi wahalu pobe layadagua pene. Horo ogoningi Abarama ibu mali hama ibinigo pira kariani duria (75) hayagola Lode libu haru pene. ");
INSERT INTO hui_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Pole howa Abarama ibugua ibu one Saraibi ibu hamene igini Lodebi ibuni haru halu wali agali biabe bia hagabi tinaga dabudabu wiarubi bibahende Harana dindini wu heneru mo yai halu Kenana dindi pole pene. ");
INSERT INTO hui_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abaramabi ibunaga wali agali biarubi bibahende Segeme tano wiagoria anda pene. Ogoniha dindi mbira mini More laga winiyagoria ira mbira hada bia heneyago ogoriani anda pene. Dindi ogoriani Kenana wali agali tini heaore dege pene. ");
INSERT INTO hui_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Anduane Homogo ibu Abarama hearia ibuwa lalu, Dindi ogoni í̠nibi í̠naga waneigini aguane holebirarubi tihondo ngulebero, lene. Ani layagola Abarama ibugua mbirale bo lomabu mulene dabu mbira Anduane Homogonaga ibuni íbu hearia hapani hayagoria howa bia hene. ");
INSERT INTO hui_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Ani bialu mani Abarama ibu dindi ogoni ngelalu unurahayagi pene. Puwa Bedele dindi ni paliragohayagi Ai dindi ni tagira ibiragohayagi ngela buwa dombeni ibu balai anda bu hene. Ogoriani howa Abarama ibugua Anduane Homogohondo mbirale lomabu mulene dabu mbira bia hene. Ani buwa ibugua ogoriani howa Anduane Homogo mitangi bialu lotu lalu hene. ");
INSERT INTO hui_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Ani bialu howa emene mani hayagola ti dindi ogoni ngelalu unurahayagi pene. Tigua balai anda bu palia gelo ya bigi bima pu dege bialu Negebe dindini anda pene. ");
INSERT INTO hui_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Ani bialu heagola hina gari timbuniore biyagola Kenana dindini tomo noleneore nawi hene. Ani biyagola Abaramabi ibu damene biarubi ti bibahende Iyibi dindiha togolo yalu pene. ");
INSERT INTO hui_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Pialu Iyibi dindini anda puwa Abaramahanda ibu one Saraihondo lalu, Hale ha. Í̠ore wali baya mbira bedegoni. ");
INSERT INTO hui_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Iyibiali karume í̠ hondowa ti dimagoliore holebira. Tigua i̱ onedalo handayagua nde í̠ berelo wahalu i̱ bolobadago. ");
INSERT INTO hui_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Ai í̠na tihondo i̱ mbalini lariyagua nde i̱hondo mana tigabi dege bialu i̱ bo wa nahe baya hangu haru holebira, lene. ");
INSERT INTO hui_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Ani lowa Abarama halu ibu dameneru ti Iyibi dindi tagira pialu hemiria o layagodagua Iyibiali hearume handalu hearia Abarama one Sarai ibu wali bayaore bereago hendene. ");
INSERT INTO hui_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Iyibiali haguane hearume Sarai hondowa tinaga kini berearia puwa lalu, Wali bayaore mbira íbu beda, lene. Ani lowa tigua Sarai kini berearia haru piyagola kini ibu andaga haru pene. ");
INSERT INTO hui_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Kini ibugua Sarai hondowa hamelo howa Abarama mo turu halu ibugua nogo sibiru memerubi bulumaga dongi kamelerubi wali agali biabe bia hagarubi bibahende Abarama mini. ");
INSERT INTO hui_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Anigo kini ibugua Sarai dabu bule heagola Anduane Homogohanda kini damene bu heagoha warago timbuni tara tara dewa tagira ibilene. Irane kini ibugua Abarama one Sarai ibu aribia halu ibu one berelonaga ibilene. ");
INSERT INTO hui_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Ani biyagola kini ibugua Abarama olowa lalu, Í̠na Sarai í̠ one nale howa liahe ogonidagua biridagoni irane agibe. Nde Sarai ibu í̠ one beda lalu langia nabirigo. ");
INSERT INTO hui_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Ibu i̱ mbalini beda larigola nde i̱ dabu bule harugo. Ai mana kagua ogonidagua biridagoni irane aginaga. Í̠na kagua ogonidagua biridago ai í̠ ogoria nahe í̠ one haru halu pudaba, lene. ");
INSERT INTO hui_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Ani lowa kinihanda ibunaga agali haguane hearuhondo, Abarama Iyibi dindini nahelo talia tagi hadaba layagola agali haguane biaru tigua Abaramabi ibu onebi ibunaga dabudabu wiarubi nogo tara tara hearubi bibahende ibuni heba talia tagi hene. ");
INSERT INTO hui_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","2","Abarama ibu mbirale dewawi hene. Ibunaga nogo sibi meme bulumagarubi ngolo silibarubi dewawi howa Iyibi dindi yu wahalu tagira puwa Negebe dindi wiagoha pene. Ibunaga nogo bibahendebi dabudaburubi yai halu Lode libu haru pene. ");
INSERT INTO hui_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Mani Abarama halu ibu damene biaru ti dindi Negebe ogoni wahalu uyurahayagi pene. Balai andaru bu haga bima pialu Bedele tano anda pene. Anda puwa Bedele tano Ai tanola hengene abale Abarama ibuni balai anda bu hene biagoria lone puwa ogoriani hene. ");
INSERT INTO hui_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Pu howa ibugua abale lomabu delaga dabu bia hayagoria puwa Anduane Homogo mitangi bialu lotu lalu hene. ");
INSERT INTO hui_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lode ibubi nde nogo meme sibi bulumagarubi dewaore hinalu wali agali biabe biagarubi dewa dege henego Abarama libu haru mandagi hene. ");
INSERT INTO hui_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Abarama Lodela libunaga nogobi dabudaburubi mandagi ngelo habe nahe dindi henge emene ko wini. ");
INSERT INTO hui_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Ani biyagola Abaramanaga nogo haru haga hearubi Lodenaga nogo haru haga hearubi tini keba hagahaga buwa lai lalu hene. Ogoningi Kenana wali agalibi Perese wali agalibi dindi ogoriani hene. ");
INSERT INTO hui_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Anigo Abarama ibugua Lodehondo lalu, Iya agali mbiraore igini darama mandagiore kabagonigo ai nde iyanaga biabe bia haga karubi iyanebi mo keba holene wuligo. ");
INSERT INTO hui_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Dindi timbuni nai ngago handa. Í̠nime hameledegoria nigohayagi í̠ hariyagua nde i̱ ligohayagi holiya. Í̠ ligoha holene hame lariyagua nde i̱ mendehayagi holiya, lene. ");
INSERT INTO hui_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Ani layagola Lode ibu heyuwa handa amu halu hearia iba Yodana angehayagi dindi wuyu pialu amuraore Soa tano wia tagi heago hendene. Dindi ogonihayagi bayaleore dindi gede ibane bere Anduane Homogo ibuni mabu aleni howa Iyibi dindi wiagobi dege wini. Anduane Homogohanda Sodomo Gomorala bo wa naheha ogonibi wini. ");
INSERT INTO hui_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Ani wiagola Lode ibu amu ni ibiragohayagi iba Yodana ange ange dindi uliuli ibane bere uruni bibahende ibugua, I̱ hai haro, lowa Lode ibu amu ni tagira ibiragohayagi hole Abarama helalu pene. Ani pialu Abarama Lodela mandagi nahole ogoningi purogo lene. ");
INSERT INTO hui_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Ani buwa Abarama ibu Kenana dindi hene. Lode ibu nde pialu iba Yodana angeni dindi uliuli tano dewa buhe wiagoha pialu Sodomo tano kaware ngelowa balai anda bu hene. ");
INSERT INTO hui_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Tano ogoniha wali agali koorene koru hangu howa Anduane Homogonaga deni mana ko ngubi wiaru hangu bialu haga hene. ");
INSERT INTO hui_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Lode ibu peagola Anduane Homogohanda Abaramahondo ogodagua lalu, Ai heyuwa í̠na ni tagira ibiragohabi ni paliragohabi gi tigahabi gi lehabi bibahendeha handa amunana bialu handa. ");
INSERT INTO hui_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Dindi áyu o de hendedegoni í̠nibi í̠naga aguanene mani holebirarubi tí bibahendehondo ngulebero. Ani ngerogola dindi ogoni tínagaore wiaabobo wulebira. ");
INSERT INTO hui_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Ani bialu í̠ waneigini aguaneneru daga labe nahe iba mu ngarubi holebira. Mbiralime iba mu daga lagayagua nde í̠ waneigini aguaneneru daga labehe holebira. ");
INSERT INTO hui_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Ai heyalu puwa dindi i̱ ngule larugoni handama ibaga bia. Uruni bibahendeore í̠hondo ngiai holebero, lene. ");
INSERT INTO hui_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Ani laya handala Abarama ibu dindi o hayago wahalu Heberono tanoni hole pene. Dindi ogoriani Mamerenaga ira timbuniru buhe mbira wiagoria puwa anda bu hene. Ani buwa ibugua Anduane Homogonaga lomabu delaga dabu mbira dindi ogoriani bia hene. ");
INSERT INTO hui_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","9","Bera ibu Sodomo tanonaga kini heagola Bisa ibu nde Gomora tanonaga kini hene. Sinaba ibu Adema tanonaga kini halu Semebe ibu Seboiminaga kini halu tano Bela mini mende Soa lagago ogoninaga kinibi hene. Kedolaome ibu dindi hobane mbira Elama kini howa ibugua kini duriali uruni mali homberiani (12) handaya ho henego ai mali halene (13) hayagola tigua Kedolaomenaga bi mo wahalu muni dagisi nami wahene. Ani bialu hemiria mali dene (14) hayagola Kedolaome ibugua ibunaga nenege kini tebirali mo mogo bu hene. Ibugua Babilonia dindi Kini Amarabelebi Elasa dindi Kini Ariagobi Goima dindi Kini Tidala imarubi ti mo mogo bu halu kini mariali uruni bibahende ami agaliru haru halu wai bule pene. Puwa Lebaimi hameigini Asederodo Kanaimu tanoni hearu baba wai bialu bo podo hana hene. Ani bialu puwa Susi hameigini Hama tanoni hearubi Emimi hameigini dindi tigabi yu dindi Kiriadaimi tanoni hearubi bo podaiore halu bini. Ani bialu Ho hameigini Hari Idomo heagoha hene hearubi bo podama pialu dindi Elebarana wiagoha piaho wialu amuraore wali agali napale wiagoha bo poda hanaho ngelalu Kadese tano dai bini. Kadese ogoni abale Enemisibada lagago ogoriani ibini. Ani bialu tigua Amalege hameigini bibahendeore mbira wanahe bo podaiore hene. Ani buwa Amoro hameigini Hasasono Tamara tanoha hearu baba wai bialu tigua bo poda dege bini. Tigua ani bo podai halu Kedolaome ibubi ibunaga nenege kini tebira biarubi tigua tano Sodomobi Gomorabi Ademabi Seboimi Belarunaga kini duriali hearu baba wai bule ibini. Ani ibiyagola kini duriali biarume tinaga wai biaga ami agaliru haru puwa Sidimi dindi ulini mbira wiagoria mo ngoai howa tidiyu howa Kedolaomebi ibu nenege kini tebira biaru heba wai bule manda manda buwa wai hanalu tidiyu haga haga bini. Ani anda ibiyagola kini duriali hene biarume kini maria ibiyaru baba wai timbuniore bialu hene. ");
INSERT INTO hui_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Sidiminaga nira ulinihayagi wagaya duguaga gundu uli dewa wini. Ogoriani wai bialu howa Sodomonaga kinibi Gomoranaga kini biagobi libu ibida pole pialu hebiria gundu uli wagaya duguaga biagoha pilo wia handala kini tebira biaru ti ibida hari heagoha piai hene. ");
INSERT INTO hui_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Kedalaomebi ibunaga nenege kini tebirali biarubi tigua wai hongo howa bialu tinaga waitigi hearu bo podai hene. Ani bialu tigua Sodomo Gomorala bo podalu uruni tinaga dabudabu wiarubi tomo bu wiarubi bibahende mo hilu yai halu pene. ");
INSERT INTO hui_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Lode ibu Abarama hamene Harana igini biago ibubi Sodomo dindini dege henego nde wai ibiyarume Lodebi ibunaga mbirale bibahende wiarubi mo yai halu pene. ");
INSERT INTO hui_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Ani biyagola agali mbira ibu wai hamani howa ibida pialu Hiburuali Abarama hearia puwa ibugua Abaramahondo mbirale biyaruni bibahende lamiai hene. Abarama ibu Amoroali Mamerenaga ira timbuni bu heagoha balai anda bu henego. Mamere ibu hamenebi nde kirali Esegolo Anela henego tebirali uruni ti bibahende Abaramanaga nenegeore heneya. ");
INSERT INTO hui_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Ani howa Abarama ibugua hale halu hearia ibu igini Lode waitigime minu yalu piya layago hale howa ibuni agali hongohe hearu handari tebirani pira mbirani halira (318) mo mogo buwa naina tidiyalu pene. Puwa agali kini maria biaru piyiyadagua haruru talima pialu Dana tanoni tagira pene. ");
INSERT INTO hui_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Ani buwa Abarama ibugua ibunaga agali wai biaga ibiyaru halu kira tagalaki howa mbiraga ogoningi dege kini mariali biaru baba wai bialu Abarama ibugua hongo howaore wai bialu bo podama pialu uyu Damasagasa tano bolangua halu pu dege bialu uyura tano mende Hobani bo poda anda hene. ");
INSERT INTO hui_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Bo poda anda howa agali kini mariali urunime wai labu halu mbirale mo yalu piyaru Abaramahanda lone mo yalu dai bini. Abarama ibu igini Lodebi Lodenaga dabudaburubi ibu one wanerubi wali agali marubi bibahendeore wai bialu bo gingila miai hene. ");
INSERT INTO hui_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Abarama ibugua Kini Kedolaome ibunaga nenege kini tebirali biarubi bibahendeme wai biyagola Abarama ibu wayali howa ibugua bo podai halu harigani dai bialu hene. Ani biyagola Sodomonaga kini ibugua Kininaga Harigaore laga mbira yu dindi tigabi wiagoha winigo ogoriani Abarama ngola hole pene. ");
INSERT INTO hui_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Salemenaga kini howa Ngode Datagaliwabe Daligaorene Daliga kagonaga loma binigo mo miaga agali mbira Melegesedege heneyago. Ogoni ibugua mberedi waini ibala Abarama hearia yalu ibini. ");
INSERT INTO hui_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Ani buwa Melegesedege ibugua Anduane Homogohanda Abarama biamogo bilo bi ogodagua lene. Ibugua lalu, Dindi hariru wabiaga Ngode Datagaliwabe Daligaorene Daliga kago ogoni ibugua í̠ mo bayaleore helo. ");
INSERT INTO hui_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Ai í̠naga wai tigiru bo podalu mbirale mo yalu piyaru lone mo yu dai bibelonaga hongo ngiyidago. Áyu iname ibunaga mini yaraga hama, lene. Ani layagola Abarama ibugua wai bialu mbirale gingilo yalu dai biyaru pi halu tale buwa pinigo Melegesedege mini. ");
INSERT INTO hui_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Mani Sodomonaga kini biagome Abaramahondo lalu, Mbirale í̠nime haruru puwa wai bialu gingila miridaruni í̠ni hai halu i̱naga wali agali dege daibi labe, lene. ");
INSERT INTO hui_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Ani layagola Abaramahanda ladai bialu lalu, Anduane Homogo Ngode Datagaliwabe Daligaorene Daliga dindi hariru wabiaga kagonaga minini howa i̱na heneneore bulego laro. ");
INSERT INTO hui_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","I̱na mbirale mbira emene ko aga pu aleyaguabi pu dini emeneoreyaguabi mbira nayuleore. Mani í̠na Abarama i̱na mo homogo hene lowa wai bi lalu holeberegodagonaga laro, lene. ");
INSERT INTO hui_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Ani lowa ibugua lalu, Ai i̱na agali karume tomo nolene aleru nayago dege i̱ haradagua uruni harogoni. I̱naga nenege tebirali Anebi Esegolobi Mamarebi tigua dege dabudabu uruni aria maru mo yilo, lene. ");
INSERT INTO hui_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Mani Abaramahanda de gandeba mbira handalu Anduane Homogohanda ibuhondo bi ogodagua lalu, Abarama-o i̱na í̠naga humbi ale howa í̠ horo bibahendengi handaya ho haabo kogonigo gi nahabe. I̱na í̠ agali timbuni mini leneore helolebero, lene. ");
INSERT INTO hui_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Ani layagola Abarama ibugua lalu, Anduane Homogo Bibahende Haru Haame Ho Haga-o i̱naga waneigini mbira naheore kogodago. Ai í̠na agua beregola i̱ agali mini lene holeberodabe. Mani i̱ homarogola i̱naga paluni Damasagali Eliasa ibu hai holebiragodago. ");
INSERT INTO hui_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Í̠na i̱ waneigini mbira nangi kegonidago ai i̱naga paluni bibahendeore agali i̱naga biabe bia haga Eliasa ogoni ibu karulai holobadago, lene. ");
INSERT INTO hui_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Ani layagola Anduane Homogohanda Abaramahondo lalu, Í̠naga paluni agali í̠naga biabe bia haga ogoni ibugua nayulebira. Í̠ igini mbira holebirago ogoni ibuniore í̠ henegoria ha aribia howa ibuni karulai holebira, lene. ");
INSERT INTO hui_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Ani lalu Anduane Homogohanda Abarama haru tagira puwa lalu, Ai hari daligaha yapibiya li bu karuni handa. Ainde í̠na uruni daga labehedabe. Mani í̠naga waneigini aguaneneru dewaore yapibiya bu karunidagua holebira, lene. ");
INSERT INTO hui_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abarama ibugua Anduane Homogohanda bi layago hale halu mini dunu biaho hene. Ani biyagola Anduane Homogohanda, Ibu agali mini tigabiorewi kagoni, lene. ");
INSERT INTO hui_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Ani lowa Anduane Homogohanda lalu, I̱ Anduane Homogo í̠ Kaladia dindinaga Ua tano howa haru tagira ibirugoni. Ani birugo irane dindi ogo í̠ ngerogola mani í̠ damenerunaga wiaabo helonaga biru, lene. ");
INSERT INTO hui_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Ani layagola Abaramahanda Anduane Homogohondo lalu, Anduane Homogo Bibahende Haru Haame Ho Haga-o i̱na dindi ogo i̱nagaoreda lalu agua hondoliyadabe, lene. ");
INSERT INTO hui_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Ani layagola Anduane Homogohanda ladai bialu lalu, Ai nogo bulumaga angibuni mbirabi nogo meme angibuni mbirabi nogo sibi wangabebi bibahende mali tebira henego hondowa haru halu ega malibu kirabi minu yalu ibabe, lene. ");
INSERT INTO hui_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Ani layagola Abarama ibugua o layaruni ale bibahende haru halu ibuwa helene. Ani buwa nogo biaruni bibahende balu daga bigi buwa obeneni halu kira yabuloki buwa duguni kirani ngelama pene. Ega biago labo dege podaki nabi ngelene. ");
INSERT INTO hui_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Ani ngelearia ega hariawe alerume ibalu mo nolebiyagola Abarama ibugua tibu yu howa talialu hene. ");
INSERT INTO hui_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Ani bialu hearia Abarama ibuni alendo ni dadai biyagome de umu layagola emene ona de mugu lalu palia hondo hene. Ani paluwa emaga handalu hearia aruma timbuni mbirame íbu dambi hayagola mogo lene. ");
INSERT INTO hui_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Ani biyagola Anduane Homogohanda Abaramahondo lalu, Ai mani í̠naga waneigini ti dindi tara nalene mbiraha pu holebira. Ani pu howa ti mali handari mariani (400) wali agali tara uruni tigua ti mo ko howa garabaya biabe ale bialu helolebira. ");
INSERT INTO hui_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Ani biragola wali agali urunidagua biaga karu i̱na ti mo ko halu pani migi bulebero. Ani berogola í̠naga aguanene dindi mende ogoniha wahalu tigua mbirale dabudaburu dewaore dindi tara ogoniha howa mo yalu dai bulebira. ");
INSERT INTO hui_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Anigo í̠niha ko gendaru mbira naanda ibi bayale dege luore howa homaregola tigua í̠ hora holebira. ");
INSERT INTO hui_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Anigo í̠naga aguanene uruni tigua tininaga dindi dai nabi lu dege holebira. Ani kagola Amoroali karu tigua mana ko ngaru bialu ha holebira. Ti ko timbuni bia timbu hayagua i̱na ti mana bialu bo batagi harogola ai í̠naga aguanene uruni waneigini aguanene dabane maria agima halu nde dai bulebira, lene. ");
INSERT INTO hui_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Ni palialu aruma hayagola manane kira ogodagua walia hene. Todobene be ira hagua bialu heaore mbirabi ira hale hungu dalu heaore mende lowa nai nogoru bo podo daga bigi buwa talebuki bu wima piyago dombeni henge wiadagua damadama piyaria hendene. ");
INSERT INTO hui_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Horo ogoningi Anduane Homogohanda Abaramahondo habo nalolene bi hongohe mbira lo wialu lalu, Ai i̱na dindi ogoni í̠naga aguaneneru ti mulebero. Tubari iba emene Iyibi dindi kawareha pedagoni puabo halu amuraore Yuberedisini hende holebira. ");
INSERT INTO hui_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Ani buwa tigua hameigini kira Keniali dindibi Kenisiali dindibi karulalu Kadamonoali dindibi karu dege lolebira. ");
INSERT INTO hui_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Ani bialu Hidi hameigininaga dindibi Perese hameigini dindibi Lebaimi hameigininaga dindi ngarubi ");
INSERT INTO hui_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amoro dindi Kenana dindi wima pedarubi Gigasa hameigininagabi Yabusu hameiginirunaga dindi ngaru bibahendeore í̠naga aguanenerume karu laiore holebira, lalu Anduane Homogohanda Abaramahondo lamini. ");
INSERT INTO hui_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Abarama one Sarai ibu waneigini mbira nataba hene dege biraabo hene. Anigo Iyibi wandari mbira mini Hega ibu Sarainaga biabe bia haga berene. ");
INSERT INTO hui_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Saraihanda Abaramahondo lalu, Anduane Homogohanda i̱naga waneigini mbira nataba honoliya tombe mo hangai hayadago ai waneigini mbira taba honole ndo o bedogonidago. Ai i̱naga biabe bia haga wandari o bedagonime i̱naga waneigini mbira taba hana harabe hondoliya í̠na ibu haru palibe, lene. Ani layagola Abaramahanda ibu one Sarainaga bi layago hale hene. ");
INSERT INTO hui_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Sarai ibugua ibunaga biabe bia haga wandari Hega berenego ogoni ibu Abarama one biraradagua berelo haru pene. Ogoni biyago Abarama ibu Kenana dindiha mali pira howa ani bini. ");
INSERT INTO hui_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Hega Abaramala libu haru mandagi palu heagola Hega ibu wali gali bere berene. Anidagua buwa Hega ibu gali bere bedolo manda buwa ibugua Saraihondo mine haga bialu yo handalu berene. ");
INSERT INTO hui_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Ani biyago hondowa Saraihanda Abaramahondo lalu, Hega ibugua i̱hondo mine halu bedagoni tene í̠ni howa hangu birigoni. Ibu i̱nime henemane í̠ ngirugo ai ibu wali gali bere bedogodalo manda buwa ibugua mine halu bedagoni. Anigo nde Anduane Homogo ibunime iyanaga bi henenego tale bilo, lene. ");
INSERT INTO hui_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Ani layagola Abarama ibugua Saraihondo ladai bialu lalu, Hega ibu í̠naga biabe bia haga birayagonidago. Ibuhondo í̠nime hame ledegoale ogobi berogola karulapeda lalu bibe, lene. Ani layagola Sarai ibugua Hegala waitigi halu handabe mangaho berene. Ani biyago hondowa Hega ibu nde tagira pialu ibida pene. ");
INSERT INTO hui_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Hega ibu ibida pialu dindi mini Sura wiagoria pialu wali agali nahaga wiagoha anda pene. Ani buwa iba hambiaga uli mbira wiagoria berearia Anduane Homogonaga dahuliyali mbira ibini. ");
INSERT INTO hui_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Ibuwa ibugua Hegahondo lalu, Sarainaga biabe bia haga Hega-o í̠ agoha howa ibalu ai pu agoha pole bedebe, lene. Ani layagola Hega ibugua ladai bialu lalu, I̱ Sarai wahalu ibida pialu hewariago, lene. ");
INSERT INTO hui_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Ani layagola dahuliyali biagome Hegahondo lalu, Ai Sarai ibugua bi larago hale halu bule dai bia, lene. ");
INSERT INTO hui_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Ani lowa dege lone ogodagua lalu, Í̠naga waneigini aguaneneru wali agalirume daga labe nahe aulolebe tobaheore holebira. Ai í̠na gi nahe dai bibe, lalu dahuliyali biagome lene. ");
INSERT INTO hui_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Ani lowa ibugua lone la dege bialu lalu, Áyu ogoni dege waneigini taba honole bedegonigo í̠na igiri mbira taba honolebere. Ai í̠na tandaga halu genda yu beregoni hondowa igiri ogoni ngirugo. Anidagua birudagonaga igiri ibu mini Isimale wibe. Mini Isimale ogoni irane í̠na genda yu biruwa Anduane Homogohondo dugu birigonaga hale haya. ");
INSERT INTO hui_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Ai í̠ igini ibuore nogo dongi gabua ale howa wali agali maru karu baba waitigi hai haragola tiguabi nde ibuhondo waitigi holebira. Ani bialu ibu damene karu baba mandagi naholebira, lalu dahuliyali biagome lene. ");
INSERT INTO hui_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Mani Hega ibu mitangi bu dai buwa bi ogoni Anduane Homogohanda layadago lowa ibugua Anduane Homogonaga mini Ngode Datagaliwabe i̱ Handaga Kago lene. ");
INSERT INTO hui_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Irane ogoninaga wali agali tigua iba hambiaga uli ogoni mini Ngode Datagaliwabe Haluhe Kagome I̱ Handaga ka laga nga. Iba hambiaga uli ogoni tano Kadesela Beredela hengene wiagoria nga. ");
INSERT INTO hui_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Hegahanda Abarama igini mbira taba hanayagola Abaramahanda igiri gali ogoni mini Isimale wini. ");
INSERT INTO hui_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Ogoningi Abarama ibu ibunaga mali pira halirani waragaria (86) hene. ");
INSERT INTO hui_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Abarama ibunaga mali henego lamaga halu pira dirani dira (99) hayagola Anduane Homogohanda ibuhondo bi ogodagua lene. I̱ Ngode Datagaliwabe Hongo Haiheore Kogoni. I̱naga tuha í̠ haabo howa i̱ninaga deni mana bayale tigabi ngaru dege biaabo halu habe. ");
INSERT INTO hui_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Ai i̱na í̠la habo nalolene bi mbira lo wialu lalu í̠naga waneigini mani dewaore ngulebero, lene. ");
INSERT INTO hui_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Ani layagola hale howa Abarama ibu ge duli hanga howa bulu paluwa dengui dindiniore ela ho bereagola Ngode Datagaliwabehanda ogodagua lamini. ");
INSERT INTO hui_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","Áyu i̱na habo nalolene bi ogo lo werogo ai wali agali hameigini tara tara dewaorenaga mamali í̠ holebere. ");
INSERT INTO hui_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Anigo ai í̠naga mini Abarama ndo holebere. Í̠ hameigini dewaorenaga mamali holeberegodane ai i̱na í̠naga mini Abarahama werogoni. ");
INSERT INTO hui_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Mani í̠ waneigini aguaneneru ti dewa helarogola uruni aria marume handame haga kiniru haga bulebira. ");
INSERT INTO hui_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Í̠nilabi í̠naga aguanene mani holebiraru bababi habo nalolene bi ogoni áyu lo werogoniore wiaabobo bu wulebira. Ai habo nalolene bi ogoni ogodagua lo wero. Í̠naga Ngode Datagaliwabebi í̠naga waneigini aguaneneru tinaga Ngode Datagaliwabebi i̱ hanguore kogoni. ");
INSERT INTO hui_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Kenana dindi áyu kegoni bibahende hameigini mende taranaga ngagoni. Mani howa dindi ogoni bibahende í̠nibi í̠naga waneigini aguanene holebirarubi tí ngiai harogola tínaga dindi ogoniore wiaho wiaaboboore halu i̱nibi tínaga Ngode Datagaliwabe haabo holebero, lene. ");
INSERT INTO hui_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Ngode Datagaliwabehanda Abarahamahondo lalu, Í̠nibi í̠naga waneigini mani holebirarubi tígua i̱na habo nalolene bi lo werogo baya hangu talialu biaore bilimu. ");
INSERT INTO hui_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Habo nalolene bi lo werogo wiaabo helonaga mana agalinaga dongone poda mabu bilimu lalu langirugobi anidagua bialu haabo halimu. ");
INSERT INTO hui_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","12","Igiri galiru tinaga horo halira pedagola podalimu. Ani bialu agali tínaga garabaya biabe ale bia haga karubi igiri emene gali garabaya biabe ale bia helo walime ti tí andagaha howa taba hanararubi garabaya biabe ale bia helo tinaga dindi taraha howa agali yolo bini karubi bibahendenaga dongone podaiore halimu. Ogonidagua buleberemigo irane habo nalolene bi lo weremago mo embeda nahe manda bu wiaabo helonaga anidaguaore bilimu. ");
INSERT INTO hui_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Agali tara mende bu karume habo nalolene bi ogoni tigua yu wanahe manda bu haabo kamigo manane tinaga dongone podo mabu bidamigoria hondolebira. ");
INSERT INTO hui_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Ai bi ogo hale howa agali mbirame talialu bia nabiyagua nde agali ogoni ibu i̱naga habo nalolene bi ti baba lo werogo talia nabi mo wahaga kago. Agali ogonibi kago ti haru mandagi nahe dindi tara ngaruha hama puwa helo bo batagi halimu, lene. ");
INSERT INTO hui_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Ani lowa Ngode Datagaliwabehanda Abarahamahondo lalu, Ai í̠ one ibubi nde ibunaga mini Sarai wahalu ibu mini Sara wibe. ");
INSERT INTO hui_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Ainde Sara ibugua í̠naga igiri mbira taba henelo i̱na ibu biamogo bulebero. Ani berogola Sara ibunaga aguaneneru dewaore halu marume handame haga kini holebira, lene. ");
INSERT INTO hui_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Bi ogoni hale howa Abarahama ibu bulu paluwa ibugua denguime dindi ela howa ibuni oba halu mitangi bu dai buwa lalu, Agali wahe mali handari mbira heneme waneigini agua hono wuledabe. Ainde Sara ibubi mali pira dira (90) penedago ai ogonibime waneigini hono wibehedabe, lowa ");
INSERT INTO hui_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Abarahama ibugua Ngode Datagaliwabehondo lalu, Isimale ibu bayale helo handaya ho ha nabiridago, lene. ");
INSERT INTO hui_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Ani layagola Ngode Datagaliwabehanda Abarahamahondo lalu, Í̠na ogonidagua larego agi. Í̠ one Sarahanda igiri mbira taba honolebirago í̠na igiri ogoni ibu mini Aisaga wibe. I̱na ibunaga aguaneneru bababi habo nalolene bi wiaabobo bilo lo wulebero. ");
INSERT INTO hui_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Ai í̠na i̱hondo Isimale biamogo bibe larigonaga nde i̱na ibu biamogo berogola ibunaga aguanenerubi dewa dege holebira. Ibunaga hameiginirunaga haguane agali homberia (12) holebiraru ai i̱na ti mo hongo holebero. ");
INSERT INTO hui_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Anigo i̱na habo nalolene bi ogoni Aisagala lo wulebero. Mali edegonaga horo áyu ogodaguani Sarahanda igiri ogoni taba honolebira, lene. ");
INSERT INTO hui_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Abarahamala bi ogoni lai howa Ngode Datagaliwabe ibu Abarahama helalu pene. ");
INSERT INTO hui_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Ani biyagola Abarahama ibugua Ngode Datagaliwabehanda bibe lalu layadagua agali damene bibahende hearunaga dongone poda mabu bini. Ibu igini Isimalenagabi agali biabe bia haga ibu andagani taba henene hearubi garabaya biabe ale bia helonaga agali marume muni tagule haru ibiyagola Abarahama ibu yolo bini biarunagabi bibahende dongone poda mabu biai hene. ");
INSERT INTO hui_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","25","Abarahamanaga mali pira dirani dira (99) heangi ibu igini Isimale ibunaga mali haleria (13) heangibi tigua libunaga dongone podabe layadagua podene. ");
INSERT INTO hui_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Dongone podabe lalu Abarahamahondo horo lamiyangiore abale puwa libunaga dongone podalu, ");
INSERT INTO hui_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","agali Abarahamanaga garabaya biabe ale bia haga hearunagabi horo ogoningi dege poda mabu biai hene. ");
INSERT INTO hui_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Anduane Homogo ibu Mamerenaga ira te biagoha Abarahama hearia hapani hene. Ni hongoheore dayagola Abarahama ibu nde ibunaga balai anda haneni berene. ");
INSERT INTO hui_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Ani biruwa handalu hearia agali tebirali ona íbu hearia hendene. Ani hondowa abaleore heyalu agali tebirali biaru lola hole puwa ibu ge duli hanga howa ibunaga dengui dindini elaore howa ibugua tihondo lalu, ");
INSERT INTO hui_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Agali timbuniru-o ai tínaga biabe bia haga agali i̱ andaga ibalimulo hamelo kogoni. I̱ andaga helalu pu bolangua halimulo hame naledogoni. ");
INSERT INTO hui_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Ai tínaga ge wayawaya bilimulo agali mbirame iba hambu yalu íbu laro. Tígua ira te gumba ogoria hondo biralimu. ");
INSERT INTO hui_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","I̱na tí tomo nalu hongo kagola pole pirimidagoria pilimulo tomo maru mo yalu ibule porogo. Ai tígua i̱ andaga ibirimidagonaga i̱na nde tí biamogo buleberogo, lene. Ani layagola tigua ladai bialu lalu, Karulapego ani bia, lene. ");
INSERT INTO hui_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Ani layagola Abarahama ibu abaleore ibunaga balai anda biagoha puwa Sarahondo lalu, Balawa bayale nu biagoha hono ngelaribagoni aria maru haealowa mberedi wabuwa abale hirabe, lene. ");
INSERT INTO hui_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Ani lalu Abarahama ibugua ibunaga nogo bulumaga hagaha hearia puwa igini hungubalua habatigi mbira heago bo yalu ibuwa ibunaga biabe bia haga agali mbira heagome abale dawelo podo mini. ");
INSERT INTO hui_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Nogo mbirini maru podo dawayago dai hayagola Abarahama ibugua nogo mbirinibi nogo andu ibanebi ti bereagoria nelo yalu íbu mini. Ti tomo uruni ira gumba heago teneha nalu bereagola Abarahama ibu handaya ho hene. ");
INSERT INTO hui_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Tigua tomo nai howa Abarahamahondo lalu, Í̠ one Sara agoha bedabe, lene. Ani layagola Abarahama ibugua ladai bialu lalu, Ibu amu balai anda tamuha beda, lene. ");
INSERT INTO hui_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Anidagua layagola agali tebonego ibugua lalu, Mali mende edegonaga ege áyu kagodagua haragola í̠ dai bulebero. Dai berogola í̠ one Sara ibugua igiri mbira taba honolebira, lene. Sara ibu agali ogoninaga erembirahayagi balai anda tamuha biruwa agali ogonime bi layago hale hene. ");
INSERT INTO hui_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Abarahama Sarabi libu haru waheore howa waneigini mbira hono wibe naheore hene. Sara ibunaga waneigini holene tu biba hene berene. ");
INSERT INTO hui_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Agali ibiyagome bi ogoni layuagola Sara ibu miniha ibuni hangu mitangi bialu lalu, I̱naga agalinibi i̱nibi iyane waheore tinginiru hongo naheore kabagodago. Ai agua bialu i̱ agalinila turu hagabu howa waneigini agua hono wuliyadabe, lowa ibu oba halu berene. ");
INSERT INTO hui_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Ani bereagola Anduane Homogohanda Abarahamahondo hale halu lalu, Sara ibu i̱ waheore biruwa waneigini hono wibe nahe bedogodago lowa oba halu bedago agibe. ");
INSERT INTO hui_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Abarahama-o hale harene. Anduane Homogo ibugua nabibehe mbira nawiore. Anigo mali mende edegonaga ege áyu kamadagua haragola i̱ dai bulebero. Dai berogola Sara ibugua igiri mbira taba honolebirago laro, lene. ");
INSERT INTO hui_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Ani layagola Sara ibu gi halu ke̱ howa lalu, I̱ oba nahe, layagola Anduane Homogohanda lalu, Í̠ oba haore birigoni, lene. ");
INSERT INTO hui_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Tomo nai halu agali tebirali biaru pole heyalu piyagola Abarahama ibugua harigani ngua hole ti haru mandagi pene. Pialu howa Sodomo dindiha wá handa amu hene. ");
INSERT INTO hui_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Ani hondowa Anduane Homogo ibuni lo mitangi bialu lalu, Agua mbirale i̱na bule ngogo Abarahama ibu manda bilo mo do holene nakarulapedago lowa manda bini. ");
INSERT INTO hui_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Mani ibunaga waneigini aguaneneru dewaore hongohe bu holebira. Ani biragola ibuni howa hameigini dindi tara tara bibahendeha karu biamogo bialu mo bayale helolebero. ");
INSERT INTO hui_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","I̱na ibu waneigini aguaneneru bibahendeme Anduane Homogo i̱ninaga bi larogo hale howa talialu helobi mana tigabi bulene ngaru bialu helobi Abarahama ibugua lamialu helonaga ibu dabo heledogoni. Ai i̱na bilimu larugo tigua hale halu biyagua i̱na nde tihondo bule lalu lo wirugoni biaore bulebero, lo mitangi bini. ");
INSERT INTO hui_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Ani lowa Anduane Homogohanda Abarahamahondo lalu, Bi lolene dewaore Sodomo Gomorala tanoni mana ko timbuni ngagonaga lolene nga. ");
INSERT INTO hui_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Anidago ai wali agali uruni tigua mana agobi bialu henedabe handama poro, lene. ");
INSERT INTO hui_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Ani bialu agali kirali biago libu Sodomo tano pole piyagola Anduane Homogo ibu Abarahamala emene hondo hene. ");
INSERT INTO hui_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Ani howa Abarahama ibugua Anduane Homogo heagoria hapara howa bi maru ogodagua hale halu lalu, Í̠na agali maru bayale heagua uruni heba wali agali ko biaga karu heba bo wahai holeberebe. ");
INSERT INTO hui_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Agali bayale pira duria (50) tano ogoniha heagua urunibi bibahende ko biaga karu heba bo waholebe. Agali pira duria uruni mitangi halu tano ogoni ngelo waholebe. ");
INSERT INTO hui_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Agali bayale tigabi karu ko biaga karu heba bamaga holenego liaheda. Agali bayale biaga ko biagabi mana mbiraoregome dambi hai holene nakarulape. Dindi bibahendenaga Dabaga kagome mana tigabi ngadagua tale bulene nga, lene. ");
INSERT INTO hui_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Ani layagola Anduane Homogohanda ogodagua ladai bini. Sodomo tanoha agali tigabi pira duria (50) uruni heagua ti bibahende mbirago ereba nahe hai holebira, lene. ");
INSERT INTO hui_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Ani layagola Abarahama ibugua lone hale halu lalu. Anduane Homogo-o i̱na í̠hondo bi dewa hale harogonaga manga nahabe. I̱ galone nabulene bame nahabane kogoni. I̱na ogoale bibeheda lalu mbira labe naheore kogoni. ");
INSERT INTO hui_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Ai agali bayale pira duria (50) nahe pira mariani duria (45) heagua nde duriali nigome tubagi haruago wahalu uruni heba bo waharo loleberebe, lene. Ani hale hayagola Anduane Homogo ibugua ladai bialu lalu, Agali bayale pira mariani duria (45) heagua i̱na tano ogoni mo ko naholebero, lene. ");
INSERT INTO hui_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Abarahamahanda lone lalu, Agali pira maria (40) hangu bayale heagua nde agua buledabe, lene. Ani hale hayagola Anduane Homogohanda ladai bialu lalu, Agali pira maria (40) bayale heagua nde i̱na tinaga tano mo ko halu tini heba ba nabulebero, lene. ");
INSERT INTO hui_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Ani layagola Abarahama ibugua lone lalu, Anduane Homogo-o i̱na bi lone hale harogo keba nahabe. Ainde agali pira tebira (30) heagua agua buleberebe, lene. Ani layagola Anduane Homogohanda ladai bialu lalu, Agali pira tebira (30) hangu bayale heagua nde tano mo ko naholebero, lene. ");
INSERT INTO hui_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Abarahamahanda lone dege hale halu lalu, Anduane Homogo-o i̱na bi dewa laabo harogonaga keba nahabe. Ai agali pira kira (20) hangu bayale heagua nde agua buleberebe, lene. Ani layagola Anduane Homogohanda ladai bialu lalu, Pira kira (20) bayale heagua tano mo ko naholebero, lene. ");
INSERT INTO hui_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Ani layagola Abarahama ibugua lone lalu, Anduane Homogo-o aiore nde keba nahabe. Bi mbiraore hangu hale harogo agali pirali bayale heagua nde agua buleberebe, lene. Ani layagola Anduane Homogohanda ladai bialu lalu, Pirali bayale heagua nde tinaga tano mo ko naholebero. Agali bayale uruni tibi ereba naholebira, lene. ");
INSERT INTO hui_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Anduane Homogo ibu bi uruni lai halu piya handala Abarahama ibu nde ibuni andaga dai bini. ");
INSERT INTO hui_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Lode ibu nde Sodomo tanonaga panga haraba wali agali ngoai haga hama wiagoha berearia dahuliyali kirali ala Anduane Homogo heba Abarahama berearia ibiyago labo ibini. Lode ibugua abale heyalu libu ibiyago ngola hole pene. Puwa ibu ge duli hanga ho biruwa bulu palialu denguime dindi ela ho biruwa lalu, ");
INSERT INTO hui_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Agali timbuni-o aiore i̱ libunaga biabe bia haga kogo i̱ andaga ma. Libunaga geru wayawaya balu mbiraga i̱ andaga palialu ega bi laragola nde pilibulo, lene. Ani layagola libugua ladai bialu lalu, Ani ndo iya wali agali ngoai hagagoria palueberaba, lene. ");
INSERT INTO hui_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Ani layagola Lode ibugua hongo howaore ma laabo hayagola nde ti haru Lode andaga pene. Puwa Lodehanda agali ibunaga biabe bia haga hearuhondo lamialu, Mberedi yidi nahe hiralu tomo dendebi maru libu nelo dawalimu, lene. Ani layagola tigua tomo ani dawa yalu ibiyagola libugua tomo biago nalu berene. ");
INSERT INTO hui_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Libu palia nabiaore dege Sodomoali hearume anda libu bereago tagiraha ho mabu biai hene. Igiribi agali wahebi Sodomo tanoni hearuni bibahendeore ibai hene. ");
INSERT INTO hui_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Ani ibuwa tigua Lode olowa lalu, Agali kirali í̠ andaga palima ibiyago labo agoha padabe. Libu iname yuluma̱ya tagira ibila, lene. ");
INSERT INTO hui_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Ani layagola Lode ibu tagira puwa panga hongo howa paya tagi halu ");
INSERT INTO hui_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","ibugua tihondo ogodagua lamialu lalu, I̱naga nenegeru-o hale halimu. Tígua mana ko ogonidaguaore bulene nawi. ");
INSERT INTO hui_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","I̱ wane kirali agali baba nahene bedago ogoni labo nde tínaga hame ledamigo ale libuha bia halimulo i̱na libu haru tagira ibuliyago. Agali kira ogolabo dege i̱ andagaha palelowa i̱nime handaya halu mamage holebero. Anigo tígua libuhondo mana ko mbira nabilimu, lene. ");
INSERT INTO hui_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Sodomoali biarume Lodehanda layago hale howa lalu, Lode í̠ dindi haluni tarali howa inahondo mana labe nahego í̠ habagi halu pu. Í̠ habagi habe laramago hale nahariyagua iname agali ogoni libu mo ko halu í̠bi nde mo ko timbuni howa mo ngubiaore holeberama, lene. Ani lowa tigua Lode he̱la dai bialu anda panga bo gialole bini. ");
INSERT INTO hui_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Ani bialu helowa agali kirali biago labome gi yatagi howa Lode tamuha gililo yamialu panga hongo howa payatagi hene. ");
INSERT INTO hui_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Ani bialu libugua agali tagiraha hayarunaga de bibahende ndibulowa helayagola tigua anda panga biago handabe nahe hene. ");
INSERT INTO hui_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Agali kirali biago labome Lodehondo hale halu lalu, Í̠ damene maru tano ogoha kabe nahebe. Í̠ waneiginirubi í̠naga imane balibuni karubi í̠naga damene karubi bibahendeore tano ogo yu wahalu piai halimu. ");
INSERT INTO hui_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Tano ogoha mana ko mbira mbirale ngaru biai halu bi mbira tara ale ngaru lalu biagadago iyame tano ogoni mo ko howa bo tangu delaraba. Anduane Homogo ibugua dindi ogoha ogonidagua bialu ka layago hale halu iyame tano ogo bo tangu wahole pudaba lenego íbu kaba, lene. ");
INSERT INTO hui_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Ani laya handala Lode ibugua agali kirali ibu wane biago labo dabu bule lowa lawu henego ogoni labo hearia puwa lalu, Ai dindi ogo mo ko haragonigo abale tagira pialu ma. Anduane Homogohanda tano ogo áyu ogoniore mo ko haragoni, lene. Ani layagola libugua manda bialu hebiria Lode ibu tabirene hayabe toba hene. ");
INSERT INTO hui_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Ega bi layagola dahuliyali biago labome Lodebi ibu one wane kirabi abaleore pudaba lowa mo daila halu lalu, Abale gerai ladaba. Wali agali o karu ereba hai holebiradagua tíbi ereba hai holigo í̠ onebi í̠ wanego labobi tí haru tano ogo abale wahalu pilimu, lene. ");
INSERT INTO hui_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Ani layagola Lode ibunaga miniha yaleyale howa hendore bigi bialu hene. Ani bialu hearia dahuliyali biago labome tinaga gini gililo yalu tano yu wahalu tagira pene. Anduane Homogohanda Lode dara hayago hondowa ani bini. ");
INSERT INTO hui_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Ani buwa dahuliyali mende biagome lalu, Tíbi nde homoligo abaleore pilimu. Pialu howa handa dai nabilimu. Dindi ulini amu ngaruha nape tí homa nabuleyagua gerai lalu uyu hari bare ngagoha iraga halu puabo halu pilimu, lene. ");
INSERT INTO hui_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Ani layagola Lodehanda lalu, Agali timbuni-o í̠na bibe laregonidagua bibe nahedago. ");
INSERT INTO hui_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Ainde hale habe. Í̠na i̱ dara halu biamogo beregonigo hari bare amuraoredago wene harigani pialu kamaore tano abale bo tangu delaragola ina heba homamaga holigo agua buledabe. ");
INSERT INTO hui_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Ai tano emene ko mbira amu ngago handa. Tano ogoni kawaredago ogoniha dege abale anda puwa bira do kamagola wali agali maru tandaga nararudagua namaga holeberama badago i̱ ogoniha poloma̱ya pudaba la, lene. ");
INSERT INTO hui_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Ani layagola dahuliyali biagome lalu, Ogoniha karulapego pudaba. Tano ogoni bo de nalolebero. Ai dai ladaba. ");
INSERT INTO hui_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Tí wene pialu kamiore i̱na mbirale mbira nabuleberogo pudaba, lene. Ti puwa Lodehanda lalu, Tano ogoni emene kooredago, lowa tano ogoni mini Soa wini. ");
INSERT INTO hui_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Ni wene tagira ibalu heaore dege Lode ibu Soa tano abale anda pene. ");
INSERT INTO hui_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Ani piyagola abaleore Anduane Homogohanda ege to̱le̱ ambuabi mini soloba kundibi heba ira deaore tano Sodomo Gomorala wiagoria ibira helene. ");
INSERT INTO hui_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Ani biyagola tano ogoninaga dindi ulini wiago labo heba do mundulo wa helene. Wali agali tano ogoniha hagadarubi mbirale mbirale bibahendeore uruniha hearubi do mundu lai helene. ");
INSERT INTO hui_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Anigo Lode heba ibu one wanerubi ti harigani pialu howa Lode one ibu handadai bialu hearia abaleore mo ibikui bu hinalu naina ema nabi ira tili haradagua bini. ");
INSERT INTO hui_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Egerebagiore Abarahama ibu abe dege Anduane Homogola bi lalu haribigoria pene. ");
INSERT INTO hui_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Puwa Sodomo tano Gomora tanobi ogonihayagi yu dindi wu banga biaruha handape halu hearia hagua timbuniore biyago hendene. ");
INSERT INTO hui_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Ngode Datagaliwabehanda yu dindi uruniha tano wiaru bibahende bo hilo delai halu Lode dege Abarahama mitangi howa bo dela nabi yo pialu tagira pelene. ");
INSERT INTO hui_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lode ibu tano emene Soa biagoha holene gi biyagola tano ogoni wahalu ibu wane biago labo haru halu uyu hari bare wiagoha hole pene. Ti pialu egeanda mbira hearia handa walia howa ogoniha hene. ");
INSERT INTO hui_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Ani howa wandari wahene biagome mende heyogone biagohondo ogodagua lamialu, Ai iya aba wahe hayadago abale biaga wiyadagua iya dabu bulene dindi bibahende ngaruha agali mbira naheda. ");
INSERT INTO hui_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Ainde iya aba waini iba dewa nowa mo luluya helo hambu mibiya. Ibuni luluyu ngelowa iyane haru palerabagola nde waneigini holebira. Ani biragola dindi bibahendeha wali agali lone haame helo, lene. ");
INSERT INTO hui_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Ani lowa mbiraga hayagola wandari biago labome libu aba waini iba dewaore nelo hambu miyagola nowa bu luluyu palene. Palearia wandari wahene biago puwa ibu abala mandagi palene. Waini iba dewa biagome agali biago mo luluya heagola ibu waneme biradago manda nabi hene. ");
INSERT INTO hui_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Horo mendengi wandari wahene biagome lalu, Abale mbiraga i̱ abala paliribago ai áyu mbiraga nde iya aba ogonidagua luluyu ngagola í̠la paliribadagua libu palilibulo. Ogonidagua berabagola iya waneigini mani dindi bibahendeha lone haame holebira, lene. ");
INSERT INTO hui_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Ani lowa mbiraga mendengi wandari biago labome libu aba waini iba dewa nelo hambu muwa luluyu paleagola wandari heyogone biagola palene. Ani biyagola libu aba ibu mini naibi abale mbiraga paliyadagua dege paluwa ibu wane biagome biaruago manda nabi palene. ");
INSERT INTO hui_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Libugua ogonidagua bialu libuni waneigini libu abanaga taba honole gali bere berene. ");
INSERT INTO hui_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Wandari wahene biago ibugua igiri mbira taba honowa igiri ogoni ibu mini Moaba wini. Ani wiyagola Moaba wali agali áyu karunaga mamali ogoni ibu hene. ");
INSERT INTO hui_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Wandari mende biago ibuguabi igiri dege taba honowa igiri ogoninaga mini Benami wini. Áyu wali agali Amono hameigini karuni tinaga mamali ogoni íbu hene. ");
INSERT INTO hui_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abarahama ibu Mamere dindi wahalu puwa Negebe dindiha Kadese Suala hengene wiagoria pu hene. Ani buwa mani ibu one Sara libu pialu Gera tano wiagoria anda pene. ");
INSERT INTO hui_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Ogoniha pu howa Abarahamahanda Gera wali agali bu hearuhondo lalu, Sara ibu i̱ mbalini beda, lene. Ani layago hale howa Geranaga Kini Abimelege ibunaga biabe bia haga hearuhondo lamialu lalu, Sara ibu i̱ dabu buliya haru ibule pudaba, lene. ");
INSERT INTO hui_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Ani lowa mbiraga Ngode Datagaliwabehanda Abimelege palearia ibu emagaha ha pani howa lalu, Wali o haru ibirigoni agali onego í̠ homolebere, lene. ");
INSERT INTO hui_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Ai Abimelege ibu Sarala mandagi palia nabi heariago ibugua lalu, Anduane Homogo-o i̱ ko mbira nabigo í̠na agali mbirame mana ko mbira nabi kagola agali ogonibi ibu damenerubi bo waholeberebe. ");
INSERT INTO hui_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Abarahama ibunime wali ogoni ibu mbalini lalu langiyago. Wali ogo ibuguabi Abarahama ibu mbalini lalu langia dege biya. I̱na wali ogoni damu pirudago tigabi birudalo manda bido. Kagua mbira i̱na nabi kogoni, lene. ");
INSERT INTO hui_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Ani layagola emagaha dege Ngode Datagaliwabehanda ladai bialu lalu, Ogoni henene. Í̠na mana tigabi wiadagua birigola i̱nime í̠ wali ogonila mandagi palia nabibelo mo habo larugoni. ");
INSERT INTO hui_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Wali ogoni i̱naga bi mana latagi haga agali mbira onego áyu ogoni abale dai bilabe. Ibugua í̠ homoligonaga bi la helo ani bibe. Anigo í̠na wali ogoni ibu agalini andaga daibi nalariyagua í̠nibi wali agali í̠ damene bu karubi bibahende homaiore holeberemi, lene. ");
INSERT INTO hui_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Ega bi layagola Abimelegehanda ibunaga agali haguane hearu olo ngoai howa Anduane Homogohanda bi lamiyago bibahende tihondo lamiai hene. Bi uruni layago hale howa ti bibahendeme giore hene. ");
INSERT INTO hui_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Ani howa Abimelege ibugua Abarahama olalu íbu lowa hale halu lalu, Í̠na mana ogonidagua biridagoni agiale biribe. I̱na í̠hondo agi birugonaga i̱ damenerubi i̱nibi bibahendeore pani nai holoma̱ya mo pe haribe. Í̠na mana ogonibi biridagoni tiga nabialu nabiore biridagoni, lene. ");
INSERT INTO hui_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Ani lowa Abimelege ibugua bi laabo halu lalu, Í̠na mini agua wuwa mana ogonidagua biribe, lene. ");
INSERT INTO hui_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Ani layagola Abarahamahanda ladai bialu lalu, Agali dindi ogoha kamiru tígua Ngode Datagaliwabehondo gi nahaga howa i̱ one aribia halu i̱ bo waholigonaga gi haru. ");
INSERT INTO hui_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Bi ogoni henene dege Sara ibu i̱ mbalinigo iyanaga ai̱ya tara tara howa iya aba mbiraore hangugo nde iyane dabu bini. ");
INSERT INTO hui_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Ngode Datagaliwabehanda i̱naga dindi andaru i̱naga damenerubi bibahende wahai halu pobe laya handala tagira pialu howa i̱na Sarahondo ogodagua laruli, Dindi mbiraha porabago pialu howa í̠na i̱hondo mana tigabiore bulene hame lariyagua nde Abarahama mbalini bedo labe, laru, lene. ");
INSERT INTO hui_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Ani layagola Abimelegehanda Abarahama ibuni hearia Sara haru dai bini. Ani haru dai buwa ibugua nogo sibiru bulumagaru wali agali garabaya biabe ale bia hagaru dewaore Abarahama mini. ");
INSERT INTO hui_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Ani mialu howa ibugua Abarahamahondo lalu, Ai dindi o ngaruni handa. Dindi uruni bibahende i̱ninaga ngogonigo í̠ dindi uruni hobane mbiragoha hole hame lariyagua nde karulape, lene. ");
INSERT INTO hui_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Ani lowa ibugua Sarahondo lalu, Ainde mana liahe birugonaga taga domalu muni kuni siliba daosini mbira (1,000) í̠ mbalini Abarahama mule manda bido. Anidagua berogola wali agali í̠ baba mandagi haga karu tigua í̠na kagua mbira biridalo manda nabulebira, lene. ");
INSERT INTO hui_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Anduane Homogohanda Abimelege ibu damene wali berearu bibahendenaga tombeha waneigini biraga mugube mo wahayagola wali uruni waneigini taba hanabe nahe berene. Abarahama one Sara Abimelegehanda yamo haru piyagonaga Anduane Homogohanda ogoni miadai bini. Ani biyago hondowa Abarahamahanda Ngode Datagaliwabehondo bi la hayagola nde ibugua Abimelegebi ibu onebi wali garabaya biabe ale bia haga berearubi ti mo bayale howa wali urunime waneigini lone taba hanabehe berene. ");
INSERT INTO hui_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Anduane Homogohanda Sara biamogo bulebero lalu abale lo wiyadagua bialu biamogo bini. ");
INSERT INTO hui_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Sara ibu gali bere biruwa ibugua Abarahamabi agali wahe heagola igiri mbira taba henene. Ngode Datagaliwabehanda horo ogoningiore taba honolebere lalu abale lo wiyagongiore igiri ogoni taba henene. ");
INSERT INTO hui_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Taba hanayagola Abarahamahanda igiri gali ogoni mini Aisaga wini. ");
INSERT INTO hui_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Sarahanda Aisaga taba hono bereane horo halira piyagola Ngode Datagaliwabehanda bibe lalu mana lamiyadagua bialu igiri gali ogoninaga dongone poda mabu bini. ");
INSERT INTO hui_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Abarahama ibunaga mali handari mbira (100) hayagola ibu one Sarahanda Aisaga taba henene. ");
INSERT INTO hui_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Taba honowa Sarahanda lalu, Ngode Datagaliwabehanda i̱ dara halu biamogo biyadagonaga turu ho biruwa oba halu bedogoni. Ainde wali agali mani holebirarume i̱naga bi te ogoni hale howa ti i̱na turu harogoha turu hatago holebira, lene. ");
INSERT INTO hui_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Sarahanda la dege bialu lalu, Abale wali agalime Abarahamanaga waneigini mbira Sarahanda taba hono birulubada lagago ai áyu Abarahama ibuni agali wahe kangi i̱na ibu igini mbira taba honowa andu mialu bedogoni, lene. ");
INSERT INTO hui_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Igiri biago ibu anda halu wahe howa ibu ai̱ya andu waho heagola Abarahama ibugua turu howa ibu igininaga tomo timbuniore dawene. ");
INSERT INTO hui_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Iyibi wali Hega ibugua igiri mbira Abarahamanaga ala taba henene. Horo mbirungi igiri ogoni ibu Sara igini Aisagala gini bialu hearia Sara ibu hendene. ");
INSERT INTO hui_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Ani hondowa Abarahamahondo lalu, Wali biabe bia haga ogoni ibu igini heba talu pelabe. Garabaya biabe ale bia haga ogoni iginime í̠naga paluni í̠ igini Aisaga ibu hangu hai holene ngago maru ibu mo holigo talu pelabe, lene. ");
INSERT INTO hui_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Bi ogoni layagola Abarahama ibu Isimalebi nde ibu igini dege biagoha ibu miniha genda ho hene. ");
INSERT INTO hui_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Ani heagola Ngode Datagaliwabehanda Abarahamahondo lalu, Wali garabaya biabe ale bia haga Hega ibu iginilanaga genda nahabe. Wahalu Sarahanda bi larago hale halu bia laradagua bibe. Í̠naga waneigini aguaneru Aisagaha howa hama tagira polebira. ");
INSERT INTO hui_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Ainde wali garabaya biabe ale bia haga ogoni igini ibunaga damenebi nde dewa dege holebiragonaga mamali ibu holebira. Ibubi nde í̠ igini dege kagoni, lene. ");
INSERT INTO hui_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Horo mendengi egerebagiore Abarahama ibugua tomoru iba be nogo meme dongoneme wabini mbiraha iba hambu to̱lowa Heganaga payani mo ya hene. Ani buwa Abarahama ibugua igiri biago Hega mialu, Libu pudaba, lene. Ani biya handala Hega ibu dindi ko wali agali nahaga Beaseba dindi wiagoha puwa ogoniha ibaga bialu berene. ");
INSERT INTO hui_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Ani bialu howa iba biba hayagola Hega ibugua igiri ira tene wiagoha berelene. ");
INSERT INTO hui_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Ani berelalu ibu igini homarago nahondole lowa mabu tu mbira ale birule pene. Ani biruwa nde Hega ibu dugu bialu biru wini. ");
INSERT INTO hui_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Ngode Datagaliwabehanda igiri biagome dugu biyago hale hene. Hale hayagola dahuliyali mbira dahuliya andaga howa Hegahondo oladali howa lalu, Hega-o agua biyabe. Í̠na gi holene nawi. Ngode Datagaliwabehanda igiri dugu biayuago hale hayago ");
INSERT INTO hui_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","ai í̠ heyalu puwa igiri gini mule pu. I̱na ibunaga waneigini aguaneneru mo dame bia halu dewaore helolebero, lalu lene. ");
INSERT INTO hui_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Ani lowa Ngode Datagaliwabehanda Heganaga de mo ngala hayagola handa amu halu hearia iba biraga uli mbira wiaria hendene. Ani wiaria handalu Hega ibugua abale puwa iba be nogo dongoneme wabini biagoha iba hambu yalu dai buwa ibu igini nelo mini. ");
INSERT INTO hui_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Igiri biago Ngode Datagaliwabehanda amu wali agali nahaga wiagoha dege halu anda howa hongoheore hene. Ogoniha howa ibuguaore danda timuru yulenenaga dolomini howa pari wayali hene. ");
INSERT INTO hui_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Ibu Parana dindi ko wali agali nahaga ogoniha halu anda hayagola ibu ai̱yahanda Iyibi wandari mbira ibu dabu bilo haru ibini. ");
INSERT INTO hui_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Horo ogoningi Abimelegebi ibunaga ami agali haru haga haguane mbira mini Pigolo heagobi libu haru Abarahama hearia puwa ibuhondo lalu, Í̠na bialu keruni damene bibahendeha Ngode Datagaliwabe ibu í̠ heba dege bialu haga kegoni. ");
INSERT INTO hui_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Ani haga kegonigo ai í̠na Ngode Datagaliwabenaga deni howa heneneore i̱bi i̱ waneigini aguaneneru bababi mo hondo nahe bayale tigabi bulene ngadagua bialu holebero lalu bi ogoni lo wibe. I̱na í̠hondo mana bayale dege bialu haabo harugoni. Anidagua dege í̠na i̱hondobi nde dindi í̠ bai nale o íbu kegoriani howa mana bayale dege bialu holebero lalu lo wibe, lene. ");
INSERT INTO hui_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Ani layagola Abarahamahanda ladai bialu lalu, Í̠na bi o laregonidaguaore bulebero, lalu lowini. ");
INSERT INTO hui_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Ani lowiyagola howa Abarahama ibugua iba hambiagane uli mbira winigo Abimelegenaga biabe bia haga agali bu hearume ti karulenego ogoni nakarulape biya lalu Abimelege lamini. ");
INSERT INTO hui_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Ani lamiyagola Abimelegehanda ladai bialu lalu, Ogoni biyago i̱ manda nabi haruda. Í̠na abale langia nabi áyu dege laregoni hale haro, lene. ");
INSERT INTO hui_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Ani layagola Abarahamahanda nogo sibi bulumagaru tale buwa maru Abimelege mialu libugua habo nalolene bi lowini. ");
INSERT INTO hui_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Ani lo wialu howa Abarahamahanda ibunaga sibi angibuni hinu hearu aria dalua hearu karia sibi maru heba hearia tale bialu naina dababagi ho helene. ");
INSERT INTO hui_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Ani heleagola Abimelegehanda ibuhondo hale halu lalu, Uruni agi bulenaga talebu dababagiho helarebe, lene. ");
INSERT INTO hui_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Ani layagola Abarahamahanda ladai bialu lalu, I̱na nogo sibi dalua hinulene egene o ngerogoni irane iba hambiagane uli ogoni heneneore i̱nime wa winigo mo walia halu ngerogoni haru ha, lene. ");
INSERT INTO hui_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Nogo sibi biaru mialu howa libu haru habo nalolene bi ogoriani howa lowini. Ani lo winidagoni mitangi bialu dindi ogoni mini Beaseba wini. ");
INSERT INTO hui_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Libugua habo nalolene bi ogoni Beaseba dindi ogoriani howa lai halu Abimelegebi ibunaga ami agali haru haga haguane Pigolobi libu haru Pilidia dindiha dai bini. ");
INSERT INTO hui_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Ani piyagola Abarahama ibu nde Beaseba dindini howa ira mbira hengene. Ani hongowa Anduane Homogo ibu Ngode Datagaliwabe Haluhe Haabobo Haga kago mitangi bialu lotu lalu hene. ");
INSERT INTO hui_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Ani bialu howa Abarahama ibu luore Pilidia dindiha haabo hene. ");
INSERT INTO hui_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Mani Ngode Datagaliwabehanda Abarahama ba hondole ibu olowa lalu, Abarahama-o, layagola Abarahama ibugua ladai bialu, Ya-o i̱ kogoni, lene. ");
INSERT INTO hui_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Ani layagola Ngode Datagaliwabehanda lalu, Í̠ igini mbiraore hangu gubalini hariligoni haru halu Moraia dindiha hari mbira i̱na walia holeberogoha pobe. Hari ogoriani í̠na Aisaga i̱hondo loma bialu irani bo delabe, lene. ");
INSERT INTO hui_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Ani laya handala egerebagiore hayagola Abarahamahanda nogo dongibi ibunaga biabe bia haga igiri kiralibi Aisaga heba pole manda manda bini. Ani bialu tigua ira maru lomabu mulenaga delole gabu mandabu yalu hari nene mbira Ngode Datagaliwabehanda pobe layagoha pole pene. ");
INSERT INTO hui_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Pialu howa horo tebonengi hari nene pole piyago kaundia dege wiaria hendene. ");
INSERT INTO hui_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Ani hondowa Abarahama ibugua igiri biabe bia haga biago labohondo lalu, I̱ igini iyame Ngode Datagaliwabe mitangi bialu lotu lole amugoha porabago libugua nogo dongi heba ogoria halibu. Emene howa abale dai bulubago, lene. ");
INSERT INTO hui_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Ani lalu lomabu delolene ira Aisaga ibugua yilo gabu mialu Abarahama ibunime ira dene hede yalu ayu nabi mbira ya bialu pene. ");
INSERT INTO hui_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Libu harigani pialu howa Aisagahanda lalu, Aba-o, layagola Abarahamahanda lalu, Igini-o agua biyabe, lene. Ani layagola Aisagahanda hale halu lalu, Aba-o ira hede yalu delolene gabu yalu bidabago lomabu delolene nogo sibi igini hungubalua mbira ago haru kabagobe, lene. ");
INSERT INTO hui_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Ani layagola Abarahamahanda ladai bialu lalu, Igini-o iyame lomabu delabiya nogo sibi igini hungubalua Ngode Datagaliwabe ibunime ngulebirago, lene. ");
INSERT INTO hui_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Ani lalu libu hari nene polebiribigoria anda puwa lomabu delaga dabu mbira abale bu helowa ira gabu yaribigo ogoriani manda mandabu ngelene. Ani ngelowa Abarahamahanda ibu igini Aisaganaga gi ge pume minu kabu buwa ira gabu manda mandabu ngelayagoria wia dambi hene. ");
INSERT INTO hui_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Ani buwa Abarahamahanda ibu igini Aisaga ayu nabime bole manda bini. ");
INSERT INTO hui_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Bole manda bialu heaore Anduane Homogonaga dahuliyali mbirame dahuliya andagaha howa olalu lalu, Abarahama-o Abarahama-o, layagola Abarahamahanda ladai bialu lalu, Ya-o i̱ kogoni, lene. ");
INSERT INTO hui_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Ani layagola dahuliyali biagome lalu, Í̠naga igini mbiraore ogoni hangu mo ko halu ba nabulego ibu pume dabaho ngeledegoni hadapeha. Í̠na ogonidagua beregome Ngode Datagaliwabenaga andaneha ko lalu walia harigo manda bidogoni, lene. ");
INSERT INTO hui_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Ani laya handala Abarahama ibu handa amu nana bialu hearia nogo sibi wangabe mbira ira gini gene dewa heagoha hanaho wiaria hendene. Ibugua Aisaga loma bialu bo delole biyadagua nogo sibi ogoni aribia halu bo delene. ");
INSERT INTO hui_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Ani buwa dindi ogoni, Anduane Homogohanda Ngiaga ka, lalu Abarahamahanda mini ogoni wini. Wali agali áyu karu tiguabi, Anduane Homogonaga hari ogoriani mbirale buru palego ngiaga ka, laga nga. ");
INSERT INTO hui_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Anduane Homogonaga dahuliyalime Abarahama halu mende olowa bi ogodagua lamini. ");
INSERT INTO hui_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","Anduane Homogo i̱na i̱ninaga minini howa bi heneneore mbira agua laro. Í̠naga igini mbira hanguda lowa wa naharigodago i̱na í̠hondo mana bayaleore bulebero. ");
INSERT INTO hui_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Ai i̱na í̠hondo mana bayale dege berogola í̠naga waneigini aguanebi aguanalirubi ti dewaore harini yapibiya kaligobi halu iba angeniha ibamu ngaligobi holebira. Ani buwa mani tigua tinaga waitigi karu bo podalu uruninaga dindini tano ngaru ti aribia howa karulo holebira. ");
INSERT INTO hui_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Í̠na i̱naga bi hale halu bia larudagua birigonaga i̱na í̠nibi í̠naga aguanene mani holebirarubi tí bibahende biamogo bialu kogo hondowa wali agali dindi bibahendeha karu tigua nde i̱hondo lalu, Inabi biamogo biahabe, lalu holebira, lene. ");
INSERT INTO hui_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Ani layagola howa Abarahama Aisagala igiri biabe bia haga biago labo hearia dai bialu ti haru mandagi Beaseba dindi dai bialu Abarahama ibu dindi ogoniha haabo hene. ");
INSERT INTO hui_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Mani howa Abarahama ibu hale halu hearia wali Miligahanda igiri halira taba hanaya, layane hale hene. Wali Miliga ogoni ibu Abarahama hamene Naho one berene. ");
INSERT INTO hui_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Igiri uruni tinaga mini uru. Wahene Usu hene. Ani bialu igiri mende mini Busu ibu hamene Kemuelela hene. Kemuele ibu Arama aba hene. ");
INSERT INTO hui_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Igiri marubi nde uru hene. Kesedebi Hasobi Pilidasabi Yidilababi Beduelebi ha dege bini. ");
INSERT INTO hui_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Beduele ibu wandari Lebega aba hene. Igiri halira uruni Abarahama hamene Naho one Miligahanda taba henene. ");
INSERT INTO hui_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Naho ibu one wali mende mini Leuma berenego ogoni ibuguabi nde igiri maria taba henenego mini uru Teba Gahama Tahasa Maga imaru taba hanaga bini. ");
INSERT INTO hui_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Abarahama one Sara ibu mali handari mbirani pira kirani huniane karia (127) hayagola ");
INSERT INTO hui_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","ibu Kenana dindini Kiriada Araba tano mini mende Heberono laga wiagoria homene. Ani homayagola Abarahamahanda dara timbuni howa dugu bialu hene. ");
INSERT INTO hui_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Ani bialu Abarahama ibugua Sara ani tongolomu wia handala Hidiali hearu baba bi lole pene. Ani puwa ibugua tihondo lalu, ");
INSERT INTO hui_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","I̱ dindi tarali tí baba íbu harugoni. Ani harugo ai i̱ one homayagola hora holenaga dindi mbira ibunaga homali ngelo yolo bule hameledogoni, lene. ");
INSERT INTO hui_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Ani hale hayagola Hidiali hearu tigua lalu, ");
INSERT INTO hui_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","Agali haguane-o inanaga bi hale ha. Í̠ agali haguane dunini mbira kegoni laga kamagoni ndobe. Í̠ one inanaga homali bayale ngamaruha hora habelo. Ainde í̠nime homali ogoha hora hole lalu ngi laregola homali anduane kagome í̠ one ogohaore hora habelo ngulebira, lene. ");
INSERT INTO hui_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Ani layago hale howa Abarahama ibugua wali agali bu hearuhondo ma podalu ");
INSERT INTO hui_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","lalu, Tígua i̱ one ogoha hora holene karulape larimiyagua nde Soha igini Eberono hale hadaba. ");
INSERT INTO hui_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","Ani hale haramigola ibunaga homali mini Magabela Egeanda laga amu Eberono dindi gibuni mbira ngagoria hora holiya ngilo. Tígua dindi ogoni i̱ mia lalu lamilimu. Ani lameramigola i̱na tínaga deni howa dindi ogoni i̱ damenerunaga homali wiaabo helonaga ti yolo tiga tiga bulene ngadagua buliya, lene. ");
INSERT INTO hui_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Ani bialu Eberono ibunibi nde bi layaruni hale howa ti haru mandagi tanonaga pabe panga haraba wiagoria biruwa dege lalu hene. Ani berearia Hidiali bu hearu bibahende hale hai helo ibugua Abarahamahondo lalu, ");
INSERT INTO hui_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Agali haguane-o i̱na bi larogo hale ha. I̱naga egeanda ogoni í̠na yolo nabibelo. Egeanda ogonibi dindi egeanda ogoriani ngarubi í̠ ngerogoni. I̱ damene bu karunaga deni howa dindi ogoni í̠ one hora habelo turu howa ngero, lene. ");
INSERT INTO hui_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Ani layago hale howa Abarahama ibugua wali agali bu hearuhondo ibunaga ma podalu bulu palene. ");
INSERT INTO hui_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Ani bialu wali agali bu hearunaga deni howa ibugua Eberonohondo lamialu lalu, Eberono-o í̠hondo bi langerogo hale habelo hameledo. Ai i̱na i̱ one dindi ogoriani hora holiya áyu í̠ yolo berogoni, lene. ");
INSERT INTO hui_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Ani layagola Eberono ibugua Abarahamahondo ladai bialu lalu, ");
INSERT INTO hui_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","Agali haguane-o i̱na bi larogo nde hale ha. Dindi ogoninaga muni siliba genda magi kilo pira duria (50) hangu yolo karulapego. Ainde uruninaga galone iyame bi mbira lolene nawigo wahalu dindi ogoni í̠ halu í̠ one ogoniha hora habe, lene. ");
INSERT INTO hui_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Ani layagola Abarahama ibugua hale halu harugo lowa muni siliba tale buwa agali biyinaya biaga hearunaga siliba genda magi handagadagua ibunime Hidiali hearunaga deni howa muni siliba pira duria (50) karulape dindi biago yolo bialu Eberono mini. ");
INSERT INTO hui_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Anidagua bialu Eberononaga dindi Magabela ogoni Mamere dindi kaware dege winigo Abarahama ibu mini. Dindi ogoniha egeanda homali ogonibi dindi wiagobi ira bu hearubi Abarahama ibu hai hene. ");
INSERT INTO hui_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Horo ogoningi howa Hidiali bi lalu henedarume dindi ogoni Abarahama ibunagaore wiragoni lalu manda biai ho hene. ");
INSERT INTO hui_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Ani bialu Abarahama ibugua Kenana dindiha dindi emene Mamere wiagoha dege Magabela wiagoria ibu one Sara egeanda homali wiagoha hora hene. Dindi Mamere ogoni Heberono dindiha wini. ");
INSERT INTO hui_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Ani binigo dindi ogonibi homali egeanda ogonibi Hidi hameigini tinaga ala winigo ai Abarahama ibu damenerunaga homali wia aribia hene. ");
INSERT INTO hui_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Anduane Homogohanda Abarahama biamogo biyagola ibugua biyago bayale dege bialu heane ai ibuni agali waheore hene. ");
INSERT INTO hui_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Ani howa Abarahama ibuni waheore haruyane handalu agali mbira ibunaga biabe luore bialu haga henego ogoni olowa bi ogodagua lalu, Í̠na i̱naga ge dulini yaniho biruwa bi mbira buleore lalu hongo howa lowia. ");
INSERT INTO hui_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Anduane Homogo dahuliya andaganagabi dindi bibahendenagabi Ngode Datagaliwabe kago ibunaga minini howa i̱ igini Aisaganaga waliore Kenana dindi ogoha bedago nadabu bia hole lalu lowiaore bia, lene. ");
INSERT INTO hui_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Ani lowa lalu, Ai i̱ninaga dindi henene wirugoha dai buwa wali mbira i̱ igini Aisaga dabu bilo taya bibe, lene. ");
INSERT INTO hui_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Ani layagola agali biagome ladai bialu lalu, Walime ibuni dindi andaru yu wahalu naibule layagua agua buledabe. Í̠ igini ibuni í̠ni dindi ogoniha haru dai biaguadabe be agua buliyadabe, lene. ");
INSERT INTO hui_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Ani layagola Abarahamahanda ladai bialu lalu, I̱ igini i̱naga dindi ogoniha haru daiore nabibe laro. ");
INSERT INTO hui_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Anduane Homogo dahuliya andaganaga Ngode Datagaliwabe kago ibunime i̱naga aba ai̱ya damenerubi i̱naga dindibi bibahendeore bu hea handala i̱ hangu haru tagira ibuwa dindi ogoore i̱naga waneigini aguanene holebiraru tihondo muleore lo nga. Ibugua ibunaga dahuliyali í̠ poleberegoha bamba halu pelaragola í̠na i̱ igininaga wali mbira bedaria handa walia halu haru dai bulebere. ");
INSERT INTO hui_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Anigo walime manga layagua nde í̠na bi habo nalole lalu lo wirigome dariba naholebirago. I̱ igini dege ibuni dindi haru daiore nabibe laro, lene. ");
INSERT INTO hui_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Bi lai heagola agali biabe bia haga biagome ibunaga gi Abarahama ge dulini yani howa bi habo nalolene hongohe lo wialu ibugua aniore biai hole, lene. ");
INSERT INTO hui_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Bi lo ngelalu nde agali biabe bia haga biagome Abarahamanaga nogo kamele hearu aria pirani yári dabudabu wiaru maru mo paga howa yalu Mesebodemia dindiha Naho hearia pole pene. ");
INSERT INTO hui_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Horo dewaore puabo halu alendo hayagola iba hambu ngoai haga mbira winiyagoria anda puwa ibunaga nogo kamele biaru mo palia howa berene. Alendo ogonidagua haragola walime iba hambu ibaga winiyago. ");
INSERT INTO hui_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Ainde agali biago ibugua biruwa lalu, Anduane Homogo-o i̱naga agali haguane kagonaga Ngode Datagaliwabe í̠na i̱naga agali haguane kago nde daraore halu biabe áyu i̱na buleberogo bayale helo biamogo bibe. ");
INSERT INTO hui_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Áyu i̱ ogoria bedoria wandari maru iba hambu ibulebira. ");
INSERT INTO hui_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Ibiragola i̱na mbiragohondo lalu, Í̠naga be yidegonime iba noliya hambu ngi, larogola ibugua iba noliya hambu ngialu i̱naga nogo kamelerubi nelo hambu miyagua ogoni ibu í̠naga biabe bia haga Aisaga one berelo dabaridalo manda bulebero. Ani manda buwa i̱naga agali haguane biagohondo dara halu biamogo biridago hondolebero, lalu lene. ");
INSERT INTO hui_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Agali biagome bi ogoni lalu bereaore dege wandari mbira Beduele wane Lebega berenego iba be payani yalu iba hambu ibini. Beduele ibu Miliga Nahola igini. Naho ibu Abarahama hamene hene. ");
INSERT INTO hui_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Wandari Lebega ogoni ibu baya buruguleore mbira biruwa agalila mbira mandagi napaleneya. Ibu abale iba be payani yalu ibuwa iba hambu pialu dai bini. ");
INSERT INTO hui_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Ani biyagola agali biabe bia haga biagome heyuwa gerai lalu abale Lebega ibiyago ngola howa lalu, Aiore í̠naga iba be ogoniha howa iba noliya hambu ngiaore bia, lene. ");
INSERT INTO hui_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Ani layagola Lebega ibugua agali biagohondo lalu, Agali timbuni-o iba hambu ngerogo na, lowa iba hambu miyagola iba biago nene. ");
INSERT INTO hui_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Agali biago ibu iba nai howa heagola Lebegahanda lalu, Í̠naga nogo kamele tibi nde iba karulape nalu nabe mangaore helo hambu muliya dege, lene. ");
INSERT INTO hui_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Ani lowa Lebega ibugua iba hambu yu tone bialu nogo kamele iba naga wabu wini wiagoha odo berelayagola nogo biaru tibi nde iba karulape nene. ");
INSERT INTO hui_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Ani biyagola agali biago ibu nde bi nale Anduane Homogo ibunaga biabe bibe layago agua birabe hondole berene. ");
INSERT INTO hui_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Nogo kamele ti iba nai hayagola agali biagome nguira mbira ngolome wabini heneneyago Lebeganaga nguini da halu gi pagida ngolome wabini kira heneneyago gini wia halu bini. Gi pagidabi nguirabi muni dewaoreme yolo mibehe. Nguira o biagonaga genda magi garama duria wialu gi pagida genda magi garama pira pira (100) labolabo mialu bini. ");
INSERT INTO hui_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Ani buwa agali biabe bia haga biagome Lebegahondo lalu, Aiore í̠ ai wanebe. I̱ damene ibirimadaru áyu mbiraga hangu í̠ aba andaga paluene henge mbira ngabe, lalu hale hene. ");
INSERT INTO hui_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Ani layagola Lebegahanda ladai bialu lalu, Miliga Nahola igini Beduele ibu wane Lebega i̱ bedogoni. ");
INSERT INTO hui_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Í̠naga nogo kamele ti tani nolenebi tí anda paluenebi henge dewa karulapeore nga, lene. ");
INSERT INTO hui_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Ani layago hale howa Abarahamanaga biabe bia haga biagome dindini bulu paluwa Anduane Homogo mitangi bialu lotu lalu hene. ");
INSERT INTO hui_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Ibugua lalu, Anduane Homogonaga mini yaraga haro. Ibu i̱naga agali haguane Abarahamanaga Ngode Datagaliwabe kago ibugua i̱naga agali haguane dara halu biamogo biaore biyadane hendedo. Dara kago walia halu i̱bi nde tiga tigaore i̱naga agali haguane Abarahama ibu dameneore andagani haru anda ibiyadagonaga turuore howa ibunaga mini yaraga haro, lene. ");
INSERT INTO hui_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Ani lai hayagola wandari biago ibugua gerai lalu ibu ai̱ya berearia andaga abale puwa o biyaruni lamiai hene. ");
INSERT INTO hui_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Lamiyagola Lebega mbalini Labana ibu nde bi layaru hale ha nguira gi pagidaru ngolome wabini wiaru handa bialu ibugua abale gerai lalu tagira pene. Puwa handalu hearia agali Abarahamanaga biabe bia haga biago ibu nde nogo kameleru helowa unu iba hambiaga biagoria hearia hendene. ");
INSERT INTO hui_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Hondowa Labanahanda lalu, Agali haguane-o Anduane Homogohanda í̠hondo bayale biyadago. Í̠ ogoria nahe i̱na mbirale manda manda bialu í̠naga nogo kamele ti palelobi anda mo tiga bialu birugo mba, lene. ");
INSERT INTO hui_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Ani laya handala Labana abale andaga pene. Andaga puwa Labanahanda ibunaga biabe bia haga agali hearuhondo lalu, Abarahamanaga biabe bia haga agali biago ibu heba ibiyadarubi tinaga ge waya waya bilo iba hambu midaba. Ani bialu nogo kameleni dabudabu yidaru mo pe halu bidaba, lene. ");
INSERT INTO hui_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Ani biai halu ti tomo nelo dawa yalu ibalu hearia agali Abarahamanaga biabe bia haga biagome lalu, Tomo nane howa bi mbira ala lolebero, lene. Ani layagola Labanahanda lalu, Karulapego latagi harene, lene. ");
INSERT INTO hui_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Ani layagola ibugua lalu, I̱ Abarahamanaga biabe bia haga kogoni. ");
INSERT INTO hui_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Anduane Homogohanda i̱naga agali haguane Abarahama biamogo bialu bayale heleagola ibu áyu mbirale dewawi homogoore ka. Nogo sibi memebi bulumagabi dewa hinalu siliba ngolobi dewa dege wialu nogo dongi kamelerubi wali agali biabe bia hagarubi dewa dege halu bida. ");
INSERT INTO hui_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Ibu one Sarahanda wali daguaheoreni igiri mbiraore hangu taba henenego ai i̱naga agali haguane ogoni ibugua ibunaga mbirale uruni bibahende ibu igini ogonihondo miai haya. ");
INSERT INTO hui_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","38","Ani binigo i̱naga agali haguane ogoni ibugua i̱hondo bi hongo howa lalu, I̱ igininaga waliore dindi áyu Kenana o kogoniha berene nadabu bia habe. I̱ninaga dindi teneore dai bialu i̱ni aba hamene karuha wandari bereagua i̱ igini dabu bilo damu dai bibe, laya. Ani lowa ibugua i̱hondo lalu, Ani buleore lalu bi habo nalole lalu hongo howa lowia, laya. ");
INSERT INTO hui_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Ani layagola i̱na nde i̱naga agali haguane ogonihondo ogodagua laru. Ai wali ogoni ibugua i̱la haru dai bua nahayagua agua buledabe laru. ");
INSERT INTO hui_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Ani larugola ibugua ogodagua laya. I̱ Anduane Homogonaga bi laragoore taliaga agali kogo ibunime ibunaga dahuliyali mbira í̠la haru poragola í̠na biabe berego bibahende bayale dege holebira. Ai i̱ igininaga wali mbira i̱ni damene haruagoha bedaria handa walia holebere. ");
INSERT INTO hui_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Ani bialu i̱naga damene karia poregola tigua wandari mbira nanguleberama layagua nde bi habo nalole lalu lo wirigome í̠ dariba ho wiaabo naholebira laya, lene. ");
INSERT INTO hui_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Agali biabe bia haga biagome laabo halu lalu, Áyu alendo iba hambiaga biagoria anda íbu howa i̱na i̱naga agali haguane Abarahama kagonaga Ngode Datagaliwabehondo ogodagua bi laru. Anduane Homogo-o í̠na i̱naga biabe berogo mo bayale helabe. ");
INSERT INTO hui_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Áyu alendo ogoria bedoria wandari mbira ibiyagua i̱na ibuhondo lalu, I̱ iba noliya í̠naga iba be ogoniha hambu ngiaore berene, lolebero. ");
INSERT INTO hui_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Ani larogola ibugua lalu, E̱ iba nabelo hambu ngerogo na. Í̠naga nogo kamele karunibi iba nelo hambu muliya, layagua í̠nime i̱naga agali haguane kagonaga wali ogoniore dabarida manda bulebero. ");
INSERT INTO hui_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Bi ani lalu berewaria Lebega ibiya. Iba be payani yiniyago abale hambule ibaha dalipe halu piyagola i̱na lalu, Ainde iba i̱ noliya hambu ngiaore bia, laru. ");
INSERT INTO hui_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Ani larugola ibugua abaleore iba be yupe halu iba hambu ngialu howa lalu, Agali haguane-o iba ogo na. Í̠naga nogo kamele karubi nelo hambu muliya, laya. Ai iba nai harugola ibugua nogo kamelerubi hambu miya. ");
INSERT INTO hui_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Ani biyagola i̱na ibuhondo lalu, Í̠ ai wanebe, lalu hewaria ibugua lalu, Miliga Nahola igini Beduele ibu wane i̱ bedo, laya. Ani layagola i̱na ibunaga nguirabi gi pagidabi wia haru. ");
INSERT INTO hui_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Ogonidagua buwa i̱na Anduane Homogo Ngode Datagaliwabe mitangi bialu ge duli hanga howa lotu lalu haru. I̱naga agali haguane Abarahamanaga Ngode Datagaliwabe ibugua Abarahama ibuni hameneore andagani haru ibiyadago manda buwa ibunaga mini yaraga harugoni. Ai wandari ogoni i̱naga agali haguane ibu igininaga dabu bia hole haru holiya lo manda biru. ");
INSERT INTO hui_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Ai tígua i̱naga agali haguanehondo mana bayale tigabi bule lo manda birimiyagua nde bi áyu ogoniore ladai bilimulo hame ledo. Ndo ogonidagua bulene hame nalarimiyagua nde i̱na mbirale mbira agoale bibehedabe hondoliya, lene. ");
INSERT INTO hui_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Ani leagola Beduele Labanala libugua ladai bialu lalu, Anduane Homogo ibunime urunidagua binidago iname bi mbira lolene nawida. ");
INSERT INTO hui_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Lebega o bedagoni Anduane Homogohanda layadadagua bialu ibu í̠naga agali haguane igini dabu bilo haru pu, lene. ");
INSERT INTO hui_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Agali biabe bia haga biago ibugua bi bayale layago hale halu ibu bulu palialu Anduane Homogo mitangi buwa lotu lene. ");
INSERT INTO hui_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Ani buwa ibugua mani yári bayale damene ngolome silibarume wabinirubi aga bayalebi Lebega ibu karulelo mialu maru wandari aba ai̱yala mialu yári maru nde wandari mbalini Labana mialu bini. ");
INSERT INTO hui_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Bi lai halu Abarahamanaga biabe bia haga biagobi agali maru ibu heba ibiyarubi ti biruwa tomo ibabi nalu bialu palene. Egerebalene palu heyuwa Abarahamanaga biabe bia haga biagome lalu, Áyu ogoningi dege i̱naga agali haguane karia dai bulene hamelo kogoni, lene. ");
INSERT INTO hui_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Ani layagola wandari ai̱ya mbalinilame lalu, Wandari ogoni horo piru agima nde inane biruluma̱ya berelo. Mani nde pilimulo, lene. ");
INSERT INTO hui_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Ani layagola agali biabe bia haga biagome lalu, Anduane Homogo ibunime biabe timbuniore biyago. I̱naga agali haguane karia abale dai buleberogo tígua hapai nahalimu, lene. ");
INSERT INTO hui_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Ani layagola tigua ladai bialu lalu, Iname wandari ibuninaga hame hale hami̱ya ibuni olowa íbu lama, lene. ");
INSERT INTO hui_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Ani lowa tigua Lebega olalu íbu lowa ibuhondo hale halu lalu, Í̠ agali ogola polebe, layagola, E̱ polebero, lene. ");
INSERT INTO hui_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Ani laya handala Lebegabi ibunaga biabe bia haga wali mbirabi libu haru agali Abarahamanaga biabe bia haga biagobi agali ibu heba ibiyarubi ti haru pole pene. ");
INSERT INTO hui_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Pole pialu hearia tigua Lebega mo turu halu bi lalu, Mbalibuni-o í̠ore waneigini daga aulolebe tobahe daosini dewa ai̱ya birabelobi í̠naga aguanenerume tinaga waitigi karunaga wai buwa wayali halu tinaga dindi tano ngaru karulai helobi hamelo kama, lene. ");
INSERT INTO hui_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Ani laya handala Lebega ibunaga wandari biabe biahaga marubi ti haru nogo kameleni biralu Abarahamanaga biabe bia haga agali biago heba pene. ");
INSERT INTO hui_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Tigua hariga ibalu hea tambu Aisaga ibu iba gorene bere mbira mini, Ngode Datagaliwabe Haluhe Kagome I̱ Handaga Kagonaga, lagago ogoni ngelalu ibu bolangua halu Negebe dindini íbu hene. ");
INSERT INTO hui_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Horo mbirungi alendo hayagola Aisaga ibu ibaga bialu datani tilitilia hangu buhe wiagoria howa handa amu halu hearia nogo kamele dewa ibiyaria hendene. ");
INSERT INTO hui_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Lebega ibuguabi nde Aisaga hondowa ibu nogo kamelenaga erembirani berenego dalipe hene. Dalipe howa agali biabe bia haga biagohondo hale halu lalu, ");
INSERT INTO hui_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Agali amu ina poleberemagoha howa ibiragoni aibe, lene. Ani layagola agali biabe bia haga biagome ladai bialu lalu, I̱naga agali haguane o ibiragoni, lene. Ani layagola Lebega ibunaga aga mbira emboneni tangi henenego yamuwa ibuninaga dengui buyi hene. ");
INSERT INTO hui_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Aisaga ngola howa agali biabe bia haga biagome Aisagahondo o biyaruni bibahende ogodagua biya lalu lamiai hene. ");
INSERT INTO hui_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Ani lalu Aisaga ibugua Lebega ibu ai̱ya Saranaga balai anda paluni heagoha haru puwa ibu dabu bini. Abale Aisaga ibu ai̱ya Sara homayagola dara dege howa henego ibu one Lebega dabu bialu dara holene embeda halu ibu oneore gubalini halu bu miniha dungulo hene. ");
INSERT INTO hui_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abarahama ibu mani wali mende mini Kedura dabu bini. ");
INSERT INTO hui_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ani dabu buwa wali ogoni ibugua igiri Simirana Yogosana Medana Midiana Isibaga Sua imaru taba hanaga bini. ");
INSERT INTO hui_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yogosana ibu Seba Dedanala aba hene. Dedana ibu Asurimi Ledusimi Lemimi uruninaga mamali hene. ");
INSERT INTO hui_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Midiana ibu iginiru Ebabi Ebebi Hanogobi Abidabi Eledabi haga binigo uruni ti Kedura aguane hene. ");
INSERT INTO hui_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abarahama ibugua ibunaga paluni bibahende Aisagahondo miai hene. ");
INSERT INTO hui_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Abarahama ibuni homa nabi howa ibu one mani dabu binigo igini bu henedaruni mo turu haga bialu mbirale migi biaga hene. Ani biaga henego ainde igiri uruni ti ibu igini Aisaga kagoria mandagi nahelo ti dindi kaundia ni tagira ibiragohayagi hole pudaba lene. ");
INSERT INTO hui_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","8","Abarahama ibu turu haga bialu waheore howa mali handari mbirani pira kariani duria (175) hayagola ibu homene. ");
INSERT INTO hui_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Ani homayagola ibunaga tingini ibu igini Aisaga Isimalelame Mamere dindini homali Magabela egeanda biagoha hora hene. Homali ogoni Hidi hameigini Soha igini Eberononaga egeanda winigo ogoniha hora hene. ");
INSERT INTO hui_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Dindi ogoni Abarahama ibugua Hidialinaga yolo bini wini. Ani bini winigoha Aisaga Isimalela libugua homali Sara hora hene wiagoha dege Abarahama hora hene. ");
INSERT INTO hui_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Abarahama homayagola Ngode Datagaliwabehanda Aisaga bayuwaore biamogo bialu hene. Anigo Aisaga ibu nde iba uli wene mini Ngode Datagaliwabe Haluhe Kagome I̱ Handaga kagonaga laga iba bereagoria dindi mbira kaware wiagoria ibu haabo hene. ");
INSERT INTO hui_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Isimale ibu Saranaga garabaya biabe ale bia haga Iyibi wali mini Hega Abarahamala libu igini hene. ");
INSERT INTO hui_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Ani henego Isimale igini waheneni howa daga lama pialu heyogone henego lamaro uru dege hene. Nebaiodo ibu igini wahene howa igini mende Keda tebone Adabele mane Mibisama ");
INSERT INTO hui_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","dauni Misima waragane Duma kane Masa hene. ");
INSERT INTO hui_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Igini halini Hadada dini Tema pini Yadua beane Nabisi hombeane Kedema uruni haga bini. ");
INSERT INTO hui_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Ani henego Isimale igini o biaruni ti hameigini hombearia (12) mani henerunaga mamali pigane ti hene. Tinaga mini dindi ti henedaruninaga mini winigo nga. ");
INSERT INTO hui_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Isimale ibu mali handari mbirani pira tebirani karia (137) hayagola ibu homene. ");
INSERT INTO hui_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Isimale aguaneneru ti Habila dindi Sua dindila hengeneha dindi wupe kagoha paluyu peda. Dindi Sua ogoni Asiria dindi pole hariga peagoria Iyibi dindi kaware ngelowa dege wia. Anigo hameigini uruni tini Abarahama aguanene maru hearu heba mandagi nahaga hene. ");
INSERT INTO hui_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Abarahama igini Aisaganaga bi te ogo. ");
INSERT INTO hui_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Aisaga ibuni mali pira maria (40) howa ibu one Lebega dabu bini. Lebega ibu hameigini Aramia aria Mesobodemia dindini agali mbira Beduele henego wane biruwa Labana mbalini berene. ");
INSERT INTO hui_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Aisagahanda ibu oneme waneigini nataba hanayagola ibu one biamogo bia lalu Anduane Homogohondo bi layagola Lebega ibu wali gali bere berene. ");
INSERT INTO hui_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Lebega tombeha waneigini kira biruwa gungu biayuane handalu ibugua Anduane Homogohondo bi ogodagua lene. I̱ha ogonidagua biaruagoni agidabe, lene. Ibugua Anduane Homogohondo bi layadagoni aginaga binidabe hondolenaga lene. ");
INSERT INTO hui_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Ani layagola Anduane Homogohanda bi ogobi ladai bini. Wali agali hameigini kira í̠naga tombeha bedabigo í̠na hameigini kira ogoni taba hanarengi libu hongo haga haga buleberabi. Hameigini mbiragome mendego bope holebira. Pigane taba hanarego ibu maha halu maha taba hanarego ibu mo wahene haragola wahene ibugua lone heyogonenaga biabe bia haga holebira, lene. ");
INSERT INTO hui_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Lebega waneigini taba honolene tu hayagola heneneore igiri kira taba henene. ");
INSERT INTO hui_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Igiri pigane taba hanayidago ibunaga tingini daramabioreni iri dewaheyagola ibunaga mini Iso wini. ");
INSERT INTO hui_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Hamene mende taba hanayagola ogonime ibu hamene Isonaga ge ayuendeni yaniho yalu ibini. Ani binigonaga ibu mini Yagaba wini. Aisaga ibuni mali pira waragaria (60) heagola Lebegahanda igiri ogoni labo taba henene. ");
INSERT INTO hui_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Igiri biago labo wahe halu Iso ibu tayanda irabuha taya haga mugubeyi hene. Yagaba ibu ibagaru nabi andaga hangu haga hene. ");
INSERT INTO hui_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Aisaga ibugua ibu igini Isohanda nogo ega bo yalu ibiraru nolenaga turu howa ibu Iso dege gubalini haga hene. Anigo Lebega ibu nde Yagaba gubalini haga berene. ");
INSERT INTO hui_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Horo mbirungi Iso ibu irabuha howa dai bialu hearia Yagaba ibu nde paboro subu bayale ngabiore dawaho berearia hendene. ");
INSERT INTO hui_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Iso ibu tomo garibi timbuniore lama ibalu heariago ibugua lalu, Yagaba í̠na tomo subu iba baya daramabi dawedegoni maru abale noliya ngi, lene. Irane ogoninaga tigua Iso mini mende Idomo wini. ");
INSERT INTO hui_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Ani layagola Yagabahanda ladai bialu lalu, Í̠na nde í̠ wahene holene henge yidegoni i̱ holiya ngiriyagua nde ngi larego ngulebero, lene. ");
INSERT INTO hui_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Ani layagola Iso ibugua lalu, Ogoni karulape. Áyu garime tongo labehe kogodago. Wahenenaga holene henge ogonime i̱ biamogo agua bulubadabe, lene. ");
INSERT INTO hui_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Ani layagola Yagabahanda lalu, Heneneore í̠naga henge i̱hondo ngule la, lene. Iso ibugua lalu, I̱na heneneore larogo i̱naga henge í̠ haore bibe, lene. ");
INSERT INTO hui_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Ani laya handala Yagabahanda mberedi maru mialu paborome dawene subu baya ngabi dawa wiyarubi nelo miyagola Iso ibu nene. Nai halu Iso ibu heyalu pene. Ogoni binidagonime Iso ibuninaga holene henge bame nagaloneda manda bialu anidagua bini. ");
INSERT INTO hui_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Kenana dindini gaea timbuni bialu bamba Abarahama heangi hina gari penedagua dege pene. Ani piya handala Aisaga ibu Kenana wahalu Pilidia dindiha Gera tano pialu Kini Abimelege hearia pene. ");
INSERT INTO hui_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Ani piyagola Anduane Homogohanda Aisaga hearia ibuwa ibuhondo lalu, Í̠ Iyibi dindiha pu nabi dindi mbira i̱na í̠ habelo nguleberogoria pu habe. ");
INSERT INTO hui_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Í̠ dindi ogoriani pu kegola i̱na í̠ baya hangu handayaho howa í̠ biamogo bialu holebero. Dindi ogoni bibahende í̠hondo ngialu í̠naga aguanene mani holebiraru tihondobi mulebero. I̱na í̠ aba Abarahamahondo lo wirugo lola helo ani ngulebero. ");
INSERT INTO hui_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Ani bialu mani í̠ waneigini aguaneneru dewaore harini yakundi dagalabe nahe bu karunidagua i̱na mo dewa holebero. Dindi o kegonibi bibahende tihondo miai holebero. Ani berogola hameigini dindi tara tarani bibahende holebirarume i̱hondo hale halu í̠ waneigini aguaneneru biamogo bialu mo bayale harudagua tibi nde ani biamogo bialu mo bayale ha lalu i̱hondo bi lolebira. ");
INSERT INTO hui_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Abarahama ibugua i̱naga bi hale halu bi mana wiwaru baya hangu talialu bialu hayagonaga i̱na í̠ biamogo bialu mo bayale holebero, lene. ");
INSERT INTO hui_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Ani layagola nde Aisaga ibu Gera tano wiagoha haabo hene. ");
INSERT INTO hui_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Ani heagola agali tano ogoniha hearume Aisaga one bereago hondowa ibu aibe lalu hale halu hearia Aisagahanda ladai bialu lalu, Wali ogoni ibu i̱ mbalini beda, lalu hene. Ani layagonaga irane ibu gi howa wali ibu one beda nalene. Ibugua mitangi bialu Lebega ibu i̱ one beda laruyagua agali urunime Lebega ti holenaga i̱ bo waholebada manda bialu ani lene. Lebega ibu wali bayaore berenego manda buwa ani lene. ");
INSERT INTO hui_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Aisaga ibu dindi ogoniha lu dege howa horo mbirungi Pilidialirunaga Kini Abimelege ibugua ibu andaga windoha howa handatagi halu hearia Aisagahanda ibu one Lebega yu hubi layane de hendene. ");
INSERT INTO hui_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Ani biyago hondowa Abimelege ibugua Aisaga olalu íbu lowa ibuhondo lamialu lalu, Áyu heneneore wali ogoni í̠ oneoredane hendedogoni. Ai irane aginaga ibu í̠ mbalini beda laribe, lene. Ani lamiyagola Aisagahanda ladai bialu lalu, I̱na wali ogoni i̱ one beda laruyagua agali bu karume i̱ bo wahalu wali ogoni ti holobada manda buwa laru, lene. ");
INSERT INTO hui_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Anidagua layagola Abimelege ibugua ladai bialu lalu, Í̠na inahondo mana agilego o biridagoni. Inanaga agali bu karu aria mbirame í̠ one kayu binidale nde inaha genda timbuni anda ibidalego. Ainde genda ogoni mo yu anda ibaga tene í̠niore kele, lene. ");
INSERT INTO hui_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Ani lowa mani Abimelegehanda wali agali bu hearuhondo bi hongo howa lamialu lalu, Agali mbirame agali ogo mo ko harimiyaguabi ibu one o bedago mo ko harimiyaguabi agali ogonidagua biaga kago ibuni homelo bo waholene wulebira, lene. ");
INSERT INTO hui_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Aisaga ibu dindi ogoniha howa e bialu tomo dewa hangalu hene. Ani hangalu heagola Anduane Homogohanda Aisaga biamogo bialu mo bayale hayagola ibu mabuha tomo anda hagadagua ndo dewaore anda hene. ");
INSERT INTO hui_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Ibugua bibahende biyago bayaleore biaabo hayagola ibunaga dabudabu dewaore wuwa ibu agali homogo hene. ");
INSERT INTO hui_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Ibunaga nogo sibi bulumagaru dewaore hinalu ibunaga biabe biaga agaliru dewa dege heago hondowa Pilidiali bu hearume henge lalu hene. ");
INSERT INTO hui_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Ani lalu howa tigua iba hambiaga uli dewa abale Abarahamanaga biabe biaga agali hearume wa winigo uruni dindi alu mogo bini. ");
INSERT INTO hui_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Ani biyagola mani Abimelege ibugua Aisagahondo lamialu lalu, Í̠ hongoheore halu ina bolangua haridago ai ina baba holene nakarulapedago dindi ogoriani nahe tagira pobelo hameledo, lene. ");
INSERT INTO hui_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Ani laya handala Aisaga ibugua ti helalu puwa Gera dindiha dindi tigabi ulini wiagoha puwa balai anda bu hene. ");
INSERT INTO hui_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Ani buwa bamba Abarahamahanda iba hambiaga uli dindi ogoniha wa wigi binidaruni Abarahama homeha Pilidiali hearume uli uruni dindi alu mogo biai hayaru Aisaga ibugua lone mo tiga bini. Ani buwa ibugua iba uli uruni ibu aba Abarahamahanda mini abale wini wiago lone lalu hene. ");
INSERT INTO hui_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Horo mbirungi Aisaganaga biabe biaga agali bu hearu tigua iba uli mbira walu hearia uli ogoniha howa iba duguadaga hene. ");
INSERT INTO hui_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Ani biyagola Gera agali maru nogo sibi haru haga hearume Aisaganaga nogo sibi haru haga hearu baba lai lalu howa lalu, Iba uli ogoni inanaga ngama, lene. Anidagua layagola Aisagahanda tihondo lai layago manda buwa ibugua iba uli ogoni mini Lai Laga wini. ");
INSERT INTO hui_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Ani bialu Aisaganaga biabe biaga agali biarume iba uli mende wene. Ani wa wiagola Gera agali biarume lone ibalu lai lene. Anidagua layagola Aisagahanda iba uli ogoni mini Waitigi Haga Iba laga wini. ");
INSERT INTO hui_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Ani buwa Aisaga ibu dindi ogoni wahalu puwa iba uli tebone wene. Ani walu heagola agali biaru tigua lone lai nale hene. Ani wiyago lai nale heagola hondowa Aisagahanda iba uli ogoni mini Bayale Holene laga wini. Wialu howa ibugua lalu, Anidagua larogoni irane Anduane Homogo ibugua ina dindi ogoniha bayale halubi mbirale bayalerubi yu holoma̱ya ngiyada, lene. ");
INSERT INTO hui_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Mani howa Aisaga ibu dindi ogoni wahalu dindi mende Beaseba wiagoria pu hene. ");
INSERT INTO hui_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Horo ogoningi mbiraga Anduane Homogo ibu Aisaga hearia ibuni hapani howa lalu, Í̠ aba Abarahamanaga Ngode Datagaliwabe i̱ kogonigo í̠ gi nahabe. Í̠ heba mandagi i̱ haabo ko. I̱na i̱ninaga biabe biaga agali Abarahama mitangi bialu ibuhondo bi lo wirugonaga lola helo í̠ biamogo bialu mo bayale halu í̠naga waneigini aguanenerubi mo dewaore holebero, lene. ");
INSERT INTO hui_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Ani layagola Aisaga ibugua lomabu delaga dabu mbira dindi o hayadagoriani bia howa Anduane Homogo mitangi bialu lotu lalu hene. Ani bialu ti dindi ogoriani balai anda bu howa ibunaga biabe biaga agali bu hearume iba uli mbira wene. ");
INSERT INTO hui_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Abimelege ibu Gera tano howa Aisaga hondo pene. Abimelege mini mandaru talebu miaga agali mbira Ahusada henegobi kininaga ami agaliru haru haga haguane mbira Pilogo henegobi ti haru mandagi Aisaga hearia pene. ");
INSERT INTO hui_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Ani hondo ibiyagola Aisagahanda tihondo lalu, Abale i̱ tínaga dindiha nahole lowa taliatagi harimigodago ai áyu agi taya ibirimibe, lene. ");
INSERT INTO hui_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Ani layagola tigua ibuhondo ladai bialu lalu, Iname handalu hemaria Anduane Homogo ibu í̠ heba kago manda bu kama. Ani manda buwa ai í̠ baba habo nalolene bi mbira lo wimi̱ya lalu ibirima. Habo nalolene bi ogoni ogodagua. ");
INSERT INTO hui_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Iname í̠hondo mana ko mbira nabiore harimago ai í̠na nde ina mo ko holene mitangi nabi habelo. Abale iname í̠hondo mana bayale wiaru dege bialu harimagoni ndobe. Ina helalu tagira piriangi í̠ genda nahe pirigoni. Áyubi nde ogonidagua dege Anduane Homogohanda í̠ heba howa biamogo bialu mo bayale halu kago hendedemagoni, lene. ");
INSERT INTO hui_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Ani layagola Aisagahanda tomo timbuni dawa hayagola ti tomo ibabi nalu berene. ");
INSERT INTO hui_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Egerebagiore heyuwa tini hangu hangu howa ina mini mbiraore hami̱ya laga bialu habo nalolene bi hongohe lowini. Ani lowa Aisaga ibugua lalu, Ai mo palia holene tí heba pudaba, laya handala tigua Aisaga helalu turu halu tini dalu dai bini. ");
INSERT INTO hui_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Horo ogoningi dege Aisaganaga biabe biaga agali hearume ibu hearia ibuwa lalu, Iname uli mbira walu hemaria iba bayaleore berearia abale handa walia harima, lalu lamini. ");
INSERT INTO hui_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Ani lamiyagola Aisaga ibugua iba uli ogoni mini Seba lalu wini. Ani lenedagoni wiaabo henegonaga tigua tano ogoni mini Beaseba wini. ");
INSERT INTO hui_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Iso ibu mali pira maria (40) hayagola ibugua Hidi wali kira dabu bini. Wali mbira ibu Hidi agali mini Beri henego wane Yudidi bereago dabu bini. Ani bialu Iso ibu wali mende Hidi agali dege mini Elono henego wane Basemada bereago dabu bini. ");
INSERT INTO hui_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Wali kira ogoni libugua Aisaga Lebegala mo tandaga haabo haga berene. ");
INSERT INTO hui_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Aisaga ibu agali waheore halu de au halu mbirale handabe nahe hayagola berene. Ani biruwa ibu igini wahene Iso olowa lalu, Igini-o, layagola Iso ibu ladai bialu lalu, Ya-o i̱ kogoni, lene. ");
INSERT INTO hui_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Ani layagola Aisagahanda lalu, Ai i̱ waheore halu angi homolebe tobahe bedogonidago. ");
INSERT INTO hui_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Áyu í̠naga danda timu wiridaru yalu irabuha taya puwa nogo mbira babe. ");
INSERT INTO hui_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Bo yalu dai buwa tomoore dendebi i̱na noa haruligobiore dawa yalu ibabe. Eberegola i̱naga paluni bi lalu i̱ nahome howa Anduane Homogohanda í̠ biamogo bialu mo bayale helo bi lamaro bulene yidogo la holiya, lene. ");
INSERT INTO hui_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Aisagahanda ibu igini Isola bi ogoni lalu birayuago Lebega ibu nde haleho berene. Libu bi ogoni lai halu Iso ibu irabuha taya pole tagira pialu piyagola ");
INSERT INTO hui_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Lebegahanda Yagabahondo lalu, Áyu ogoningi í̠ abahanda Isohondo mbira ogodagua layuane hale haru. ");
INSERT INTO hui_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","Nogo mbira bo yalu ibuwa dawale pu. Dawa yalu eberegola nowa nde i̱ nahome howa Anduane Homogohanda í̠ biamogo bialu mo bayale helo bi lamaro bulene yidogo la holiya, layuago hale haru. ");
INSERT INTO hui_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Aiore i̱ igini-o bi larogoore hale halu bibelonaga larogoni. ");
INSERT INTO hui_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Ai í̠ nogo pabeha puwa tomo í̠ aba ibu hame lagagobiore i̱na dawa holiya. Nogo meme igini hungubalua kira bo yalu ibule pu. ");
INSERT INTO hui_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Nogo ogoni dawa yalu poregola í̠ aba ibugua nowa nde Anduane Homogohanda í̠ biamogo bialu mo bayale helonaga bi lamaro bulene winigo lolebirago, lene. ");
INSERT INTO hui_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Ani layagola Yagabahanda ibu ai̱yahondo ladai bialu lalu, Anigo Iso ibu iri dewahe halu i̱ nahedago nde ");
INSERT INTO hui_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","abahanda i̱ ela halu karia tingini iri nahedane hondowa ibu mo hondo hole ibiridalo manda buwa ibugua Anduane Homogohondo i̱ mo ko habe lalu bi laragola i̱ biamogo bialu mo bayale naholebirago, lene. ");
INSERT INTO hui_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Ani layagola ibu ai̱yahanda lalu, Igini-o í̠ mini burugu nalabe. Genda mbira ibiyagua nde i̱niha ibilogo. Áyu i̱na larudagua bialu nogo meme igini hungubalua larugo bo yalu ibule pu, lene. ");
INSERT INTO hui_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Ani laya handala Yagaba ibugua nogo meme igini hungubalua biago labo bo yalu ibuwa ibu ai̱yahondo mini. Ani biyagola Lebegahanda nde Yagaba aba ibu tomo ogobiore hame lagago lowa manda bialu dawene. ");
INSERT INTO hui_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Ani buwa Isonaga aga bayale maru Lebega andagaha ngeleneyago muwa Yagaba karula hene. ");
INSERT INTO hui_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Ani karula heagola Lebegahanda Yagabanaga mabi gi kirabalibi nogo meme irini heba dongone lagalo wiyagome biadambi helene. ");
INSERT INTO hui_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Ogonidagua bia howa Lebega ibugua tomo baya dendebiore dawa wiyagobi mberedi maru hiru wia binigo Yagaba ibu yalu pelo mini. ");
INSERT INTO hui_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Miya handala ibu aba berearia yalu puwa lalu, Aba-o, lene. Ani layagola Aisagahanda lalu, Ya igini-o í̠ aibe, lene. ");
INSERT INTO hui_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Ani layagola Yagabahanda ladai bialu lalu, I̱ Iso í̠ igini wahene biagonigo. Ai í̠nime bibe larigodagua bialu tomo dendebi dawa yidogo nole heya. Nowa nde Anduane Homogohanda i̱ biamogo bialu mo bayale helonaga bi lamaro bulene labelo, lene. ");
INSERT INTO hui_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Ani layagola Aisagahanda lone hale halu lalu, Igini-o í̠na nogo ogoni nde abaleore agua handa walia halu baribe, lene. Ani layagola Yagabahanda ladai bialu lalu, Anduane Homogo í̠naga Ngode Datagaliwabehanda biamogo biyagola i̱na nogo ogoni abale handa walia howa balu dawarudagoni, lene. ");
INSERT INTO hui_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Ani layagola Aisagahanda lalu, Ai kaware ogoria hapara halu íbu. I̱na gime ela halu í̠ i̱ igini Isooredabe be taradabe hondoliya, lene. ");
INSERT INTO hui_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Ani layagola Yagaba ibu aba bereagoria hapara halu pu heagola Aisagahanda gime baya hanguore yahandaga bialu biruwa lalu, Í̠na bi larego Yagaba aledago í̠naga gi ge Isoda, lene. ");
INSERT INTO hui_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Irane Yagabanaga gi meme dongoneme kabu buwa heagola Aisaga ibugua ogoda lalu handabe nahe berene. Ibu handabe nahe berenedago tene Yagabanaga gi nogo meme dongoneme kabu buwa heagola ibu gi irihe Isodalo manda bu berene. Ani manda buwa dege Aisagahanda ibu biamogo bialu mo bayale hole howa ");
INSERT INTO hui_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","lone hale halu lalu, Í̠ henene i̱ igini Isoore íbu kebe, lene. Yagabahanda ladai bialu lalu, E̱ i̱ Isoore, lene. ");
INSERT INTO hui_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Aisagahanda lalu, Nogo dawa yaridagoni noliya ogoria yalu íbu. Nowa í̠ biamogo bialu mo bayale helo bi lamaro bulene yidogo loliya, layagola Yagaba ibugua tomo dawa yalu waini ibabi hambu yalu binigo ibu aba nelo miyagola Aisaga ibu nene. ");
INSERT INTO hui_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Nai howa lalu, Igini ai kaware birapara howa i̱ nu̱nu̱ la, lene. ");
INSERT INTO hui_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Ani layagola Yagabahanda ibu aba nu̱nu̱ lole birapara halu hearia Aisaga ibugua Yagabanaga aga ngahene. Ani buwa Aisagahanda Anduane Homogohondo ibu igini biamogo bialu mo bayale habe lowa lalu, I̱ iginiha nga bayale o biaruago Anduane Homogohanda mabu mbira mo bayaleore hene mbauleda, lowa lalu, ");
INSERT INTO hui_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Ngode Datagaliwabehanda dadimba mbiraga ibira helaragome í̠naga maburuha tomo bibahende bayale hangu anda hai helo. Ibugua widibi waini iba berelo pu mbira mini gerebi lini delobi dewaore í̠ mabuha bayale anda hai helelo. ");
INSERT INTO hui_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Ani bialu wali agali bibahende karuni í̠naga biabe biaga hai halu wali agali dindi tara tarani hagahaga bidarubi í̠ andaneha hai helo. Í̠ ai̱ya ibu waneigini aguanene mani holebiraru tibi nde í̠ andaneha hai helo. Agali marume Anduane Homogohanda í̠ mo ko helo bi lalu karu tini mo ko helo. Marume Anduane Homogohanda í̠ biamogo bialu mo bayale helonaga bi la halu karu tibi nde Anduane Homogohanda tini biamogo bialu mo bayale helo laro, lalu Aisagahanda lai hene. ");
INSERT INTO hui_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Áyu ogoni dege Aisaga ibu Yagaba biamogo bialu mo bayale helonaga Anduane Homogohondo bi lalu berenego Yagaba ibu tagira pialu piyagola ibu hamene Iso irabuha taya penego dai bini. ");
INSERT INTO hui_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Ibuguabi nde tomo bayale dendebiore dawa yinigo ibu aba berearia yalu puwa lalu, Aba-o Anduane Homogohanda i̱ biamogo bialu mo bayale helo bi lahabelo nogo dendebiore dawa yidogo nole heya, lene. ");
INSERT INTO hui_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Ani layagola Aisagahanda lalu, Be í̠ aibe, lene. Ani layagola Isohanda ladai bialu howa lalu, I̱ Iso í̠ igini wahene biago eberogoni, lene. ");
INSERT INTO hui_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Ani layago hale howa Aisaga ibu mogo timbuni lowa duru lalu biruwa ogodagua hale halu lalu, Agali abale i̱ berewaria nogo bo dawa yalu ibiyadagoniore aidabe. I̱na biamogo bialu mo bayale helonaga bi lamaro bule wirugo abale lai harugo. Ai ogoni ibuha helo lalu mirudago lone mo yu daibulene nakarulape, lene. ");
INSERT INTO hui_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Iso ibu abahanda bi ogoni layago hale howa dugu timbuni bialu lalu, Aba-o i̱bi nde Anduane Homogohanda biamogo bialu mo bayale helo bi lahabelo, lene. ");
INSERT INTO hui_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Ani layagola Aisagahanda lalu, Í̠ hamenehanda i̱ mo hondo halu í̠ biamogo bialu bayale holenego ibu hole mo yalu piyada, lene. ");
INSERT INTO hui_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Ani layagola Isohanda lalu, Áyu ogoni i̱naga paluni halu mende mo kayu biyada. Ani biyadagome ibu mini Yagaba ogoni henene tagira poragoni. Aba-o ai̱yahanda i̱ ala taba henene howa wahene i̱ harugo. Ai wahenenaga henge ogoni ibu miyagola waharugoni. Áyu i̱niore biamogo bialu mo bayale helonaga Anduane Homogohondo bi lolene winigobi ibu degeme palu bialu piaruago agua binidabe. Áyu i̱ biamogo bialu mo bayale helo bi halu mende labe nahedabe. Lolene wiagua nde labehedago, lene. ");
INSERT INTO hui_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Ani layagola Aisagahanda ladai bialu lalu, Ibu í̠naga haguane dabo helalu ibunaga dameneru ti ibunaga biabe biaga helo lalu helaru. Ibunaga mabuha widiru waini ibaru berelobi pu mbira lini daga mini gerebi dewa dege anda hai helo larugo ai í̠ore Anduane Homogohanda biamogo bialu mo bayale helo agialeore loabe, lene. ");
INSERT INTO hui_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Ani layagola Isohanda lone dege hale halu lalu, Aba-o i̱la mo turu ho holene nde mbiraore hangubi nayiorebe. Anduane Homogohondo i̱bi nde biamogo bialu mo bayale habe lalu mbira laharene, lene. Iso ibugua ani dege lalu biruwa dugu bia timbu hene. ");
INSERT INTO hui_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Ani biyago hondowa Aisagahanda lalu, Í̠ dalu dindi kaundiaha ko mbirale anda habe naheore wulebira. Mbiraga dadimbabi í̠ mabuni ibira naholebira. ");
INSERT INTO hui_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Í̠na tomo bayale nalu í̠ni bayale holenaga wai biaga áyu tibu yuwa taya bialu wai dege bialu holebere. Ani bialu howa í̠ hamenenaga biabe bia haga holebere. Ani ha holeberego mani í̠ hamene yu wahalu í̠ni hangu ha tara holebere, lalu lene. ");
INSERT INTO hui_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Iso ibu abahanda Yagaba biamogo bialu mo bayale helo bi layiyagonaga keba timbuniore Yagabaha ho wia halu lalu, Tigimandi hangu howa i̱ aba homolebirago. Homaragola dugu andaru hai howa dara embeda kagola Yagaba bo waore holiya haro, lene. ");
INSERT INTO hui_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Ibugua bi ogonidagua lalu heago Lebega hale howa berene. Ani hale howa ibugua Yagabahondo lalu, Bi ogo baya hangu hale habe. Í̠ hamene Isohanda í̠na biriruninaga ibu bu miniha tandaga timbuniore ho howa í̠ homabelo bo wahole manda bialu kago. ");
INSERT INTO hui_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","I̱ igini-o aiore i̱na mbira bia larogo bibelo. Áyu ogoningi Harana dindi ibida pialu i̱ mbalini Labana karia pobelo. ");
INSERT INTO hui_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Í̠ hamenenaga bu miniha tandaga ho kago ereba halu ");
INSERT INTO hui_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","í̠na biriruni embeda hai helo tagi hole pu. Embeda ho kagola mani í̠ dai bibelo i̱na mbiralihondo damu pu lolebero. Ani larogoni tene libu kirabali nahomalibulonaga larogoni, lene. ");
INSERT INTO hui_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Lebegahanda Aisagahondo lalu, Iso one Hidi wali libugua mana bialu kagoniore manga kogoni. Mani Yagabahanda Hidi wali kirali o bedagolabo ale dege dabu biyagua i̱ ogoria bira ndo homoleneore karulape, lene. ");
INSERT INTO hui_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Ani layagola Aisagahanda Yagaba olalu íbu lowa ibuhondo ogodagua lene. Í̠ Kenana dindi ogo wali nadabu buleore. ");
INSERT INTO hui_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Ai í̠ ai̱ya ibu aba Beduele dalu Mesobodemia pobelo. Puwa í̠ ababuni Labana wane mbira birulebirago ogoni dabu bule pobelo, lene. ");
INSERT INTO hui_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Ani lowa ibugua lalu, Ngode Datagaliwabe Hongo Haiheore Kagome í̠ biamogo bialu mo bayale howa í̠ hameigini dewali aba habelo ibugua í̠ waneigini dewaore ngilo hamelo ko. ");
INSERT INTO hui_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Ai Ngode Datagaliwabehanda Abarahama biamogo bialu mo bayale dege henedagua í̠bi í̠naga aguanene mani holebirarubi ti biamogo bialu mo bayale dege helo. Mani dindi ogo Ngode Datagaliwabehanda Abarahama minigo ogoni í̠ karulo habelo, lene. ");
INSERT INTO hui_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Aisagahanda Aramia hameigini aria agali mbira Beduele igini Labana ibu Yagaba Isola ai̱ya Lebega mbalini Harana dindini kago ogoni ibu andaga, Yagaba í̠ pole pu, lene. ");
INSERT INTO hui_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Aisagahanda Yagaba biamogo bialu mo bayale helo ibu Mesobodemia wali mbira dabu bule pu layiyago Iso ibu hale hene. Aisagahanda Yagaba biamogo bialu mo bayale helonaga Anduane Homogohondo bi layangi howa Yagaba ibu Kenana wali nadabu bibe layadalo manda bini. ");
INSERT INTO hui_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Iso ibugua manda bialu hearia ai Yagaba ibugua ai̱ya abalanaga biore hale halu Mesobodemia piyidalo manda bini. ");
INSERT INTO hui_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Ani biyago hondowa Isohanda ibu aba Aisaga ibugua Iso one Kenana wali berearu hame nale kagonidalo manda bini. ");
INSERT INTO hui_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Ani biyago hondowa Iso ibugua Abarahama igini Isimale aria wandari mbira ibu mini Mahalada Nebaiodi mbalini berenego ogoni dabu bini. ");
INSERT INTO hui_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Yagaba ibu Beaseba dindi wahalu Harana dindi pole pene. ");
INSERT INTO hui_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Alendo halu mbi layagola Yagaba ibu hariga obeneni ege to̱le̱ mbira mo haguanda howa palene. ");
INSERT INTO hui_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Ani paluwa emaga handalu hearia egageria mbiranaga tene dindini howa nguni uyura dahuliya andagahayagi paga hearia hendene. Ngode Datagaliwabenaga dahuliyalirume egageria ogoriani iri dali bigi bialu hearia hendene. ");
INSERT INTO hui_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Ani hondowa handalu hearia Anduane Homogo kaware íbu howa ibugua lalu, I̱ Anduane Homogo Abarahama Aisagalanaga Ngode Datagaliwabe kogoni. Dindi áyu o padegoni í̠bi í̠naga waneigini aguaneneru ti ngulebero. ");
INSERT INTO hui_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Í̠naga waneiginiru dewaore himu dudumbu ale halu ti ho yanga lowa dindi tu ni tagira ibiragoha howa ni paliragoha polebira. Palu yanga lalu uyuraha howa palu yalu unuraha polebira. I̱na ti biamogo bialu mo bayale halu kogo hondowa wali agali dindi bibahendeni holebirarume ti nde biamogo bialu bayale holoma̱ya mo biaha lalu i̱hondo hale halu holebira. ");
INSERT INTO hui_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Ai i̱na í̠ yu wanahe í̠ poregoha i̱nime haru haabo halu mani bi o larogo tagira piai helo dindi ogoria lone haru dai bulebero, lalu Anduane Homogohanda Yagabahondo emagaha lamini. ");
INSERT INTO hui_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Yagaba ibu palenego heyuwa lalu, Aiore Anduane Homogo ogoria heneda manda nabi harudago. Heneneore ibu ogoria heneda, lene. ");
INSERT INTO hui_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Ibugua gi taraore howa lalu, Ai dindi ogo gi ho kogoni. Ogoriani Ngode Datagaliwabe andagabi dahuliya andaga harababi ogoni degeda, lene. ");
INSERT INTO hui_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Egerebalene Yagaba ibugua ege to̱le̱ haguanda howa paliyago yamuwa mani mitangi bu dai bulenenaga o biagoriani hengene. Ani buwa olibe lininaga weli ege to̱le̱ biagoria odoba halu ogoni Ngode Datagaliwabenagaore nga lowa ani bini. ");
INSERT INTO hui_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Ogonidagua buwa dindi ogoni mini Bedele wini. Abale dindi ogoniha tano mbira winidagoni mini Lusi laga wini. ");
INSERT INTO hui_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Yagabahanda bi heneneore mbira Anduane Homogohondo lo wialu lalu, Í̠ áyu i̱ poleberogoha baya hangu handaya ho halu hariga lu porogoha haru pialu tomo agabi ngialu ");
INSERT INTO hui_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","nde bayale anda pialu i̱ aba dindini dai buliya handaya ho hariyagua í̠ i̱naga Ngode Datagaliwabeore holebere. ");
INSERT INTO hui_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Áyu ege to̱le̱ ogoriani hangarugo í̠ andaga ogonioreda lalu manane o helarogoni. Ai í̠na mbirale ngerego bibahende pi halu tale buwa pinigo í̠nihondo ngigi bulebero, lene. ");
INSERT INTO hui_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Yagaba ibu pu dege bialu wali agali ni tagira ibiragohayagi haga hearunaga dindini anda pene. ");
INSERT INTO hui_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Dindi ogoriani anda pu howa naina handa amunana bialu hearia iba hambiaga uli mbira winiyagoria nogo sibi ti iba ogoniha nagayago naina wabuni tebira palearia hendene. Iba ulidagoha to̱le̱ timbuni mbirame panga payaria hendene. ");
INSERT INTO hui_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Nogo sibi bibahende íbu hai kagola nogo sibi haru haga karume ege to̱le̱ timbuni panga payiyago dugua haragola nogo sibi ti iba naga wini. Nogo sibi ti iba nai kagola haru haga biaru tigua iba hambiaganaga panga ege to̱le̱me paya dai biagaya. ");
INSERT INTO hui_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Ani bialu heagola Yagaba ibugua tihondo hale halu lalu, Nenegeru-o tí ani howa dege íbu kamibe, layagola tigua ladai bialu lalu, Ina Harana tano howa íbu kama, lene. ");
INSERT INTO hui_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Ani layagola Yagabahanda lone hale halu lalu, Tígua agali Naho aguane Labana hendedamibe, lene. Ani layagola tigua ladai bialu lalu, E̱ ina hendedama, lene. ");
INSERT INTO hui_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Yagabahanda lone hale halu lalu, Ibu karulape kabe, lene. Ani layagola tigua lalu, Ibu bayale ka. Ai ibu wane Leselo ibu abanaga nogo sibi nai haru ibiragoni, lene. ");
INSERT INTO hui_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Yagabahanda lalu, Áyu wene horombedago nogo tani nalu emene helo haru dai bule iba nelo midaba, lene. ");
INSERT INTO hui_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Ani layagola nogo sibi haru haga biarume lalu, Ani nabule nogo bibahende ibai haragola iba nelo dugupe holeberama, lene. ");
INSERT INTO hui_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Yagaba ibu nogo sibi haru haga agali biaru heba bi lalu hearia Leselo ibu nde ibu aba Labananaga nogo sibiru ibuni haru haga henego iba nelo haru halu ibini. ");
INSERT INTO hui_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Yagaba ibu Leselo ibiyago hondowabi ibu ababuninaga sibi Leselohanda haru ibiyago hondowabi ibugua nogo sibiru iba nelo ege to̱le̱ panga dugua hene. ");
INSERT INTO hui_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Ani buwa Yagabahanda Leselo yu nu̱nu̱ lalu turu howa dugu bini. ");
INSERT INTO hui_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Dugu bialu howa lalu, I̱ í̠ aba Labana mbalini Lebega igini kogoni, lene. Ani laya handala Leselo ibugua gerai lalu andaga ibu aba lamule pene. ");
INSERT INTO hui_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Labana ibugua ibu ababuni íbu ka layago hale howa gerai lalu hondole pene. Ani puwa ibunaga ababuni abale yu hubi lalu turuore howa nu̱nu̱ lalu andaga haru pene. Andaga pu biruwa Yagabahanda ibuni bialu heneru bibahende te tihondo lamiai hene. ");
INSERT INTO hui_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Ani layagola Labanahanda lalu, Heneneore iya darama mbiraore kabagoni, layagola Yagaba ibu ege mbira Labana andaga ho hai hene. ");
INSERT INTO hui_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Labanahanda Yagabahondo lalu, Iyaore darama mbiraore howa i̱naga biabe í̠na bame buwa habelo hame naledogo. Í̠ore yolo hame ledego i̱na nguliya. Agile hame ledebe, lene. ");
INSERT INTO hui_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Labana ibu wane kira berene. Wahenego Lia biralu mendego Leselo berene. ");
INSERT INTO hui_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lia ibu de bayale ndo berenego Leselo ibu wandari bayaleore berene. ");
INSERT INTO hui_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yagabahanda Leselo gubalini ho howa Labanahondo lalu, Í̠ wane Leselo i̱ dabu buliya ngibelonaga mali karia í̠naga biabe bia holiya, lene. ");
INSERT INTO hui_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Ani layagola Labanahanda ladai bialu lalu, Nde agali maru tara karu nami í̠niore nguliya karulapego ai iya haba, lene. ");
INSERT INTO hui_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Ogonidagua lalu, Yagaba ibugua Leselo hame timbuniore leagome mali karia uruni lu ndo yamo horo tebira maria ale hene. ");
INSERT INTO hui_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Mali uruni piai heagola Yagabahanda Labanahondo lalu, Ai mali karia piai hayago Leselo i̱ dabu buliya ngi, lene. ");
INSERT INTO hui_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Ani layagola Labana ibugua tomo timbuni dawalu wali agali dindi ogoniha hearu tomo nalu turuho birami̱ya ibalimu laga bini. ");
INSERT INTO hui_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Tomo no biralu mbiraga hayagola Labanahanda Leselo wahalu Lia Yagaba paleagoha haru puwa pale layagola libu haru mandagi palene. ");
INSERT INTO hui_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Labanahanda wandari biabe bia haga mbira mini Siliba berenego Lianaga biabe bia haga berelo mini. ");
INSERT INTO hui_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Egerebalene Yagaba ibu handalu hearia abale mbiraga wali haru paliyago Leselo ndo Lia haru paleneyane mogolo hendene. Ani biniyagola ibugua Labana hearia puwa lalu, Í̠na o biridagoni tene aginaga biribe. I̱na mali lu í̠naga biabe bialu harugoni Leselo dabu bule lowa bialu harugo ai i̱ aginaga mo hondo haribe, lene. ");
INSERT INTO hui_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Ani layagola Labanahanda ladai bialu lalu, Inanaga mana ngagome wandari wahene ibugua ala agali pedagola mani heyogoneme piaga ngago ");
INSERT INTO hui_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","ainde dabu bini tomo ala nai hami̱ya sarere mbira hondo harene. Ani howa nde Leselobi dabu bibelo nguluma̱ya. Ngeramagola ogoninaga mali karia mende biabe bialu habelo, lene. ");
INSERT INTO hui_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Yagabahanda bi ogoni hale halu e̱ lowa tomo nai halu sarere mbira piyagola Labanahanda Leselo Yagaba miyagola Leselo ibu Yagaba one berene. ");
INSERT INTO hui_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Ani birayagola Labanahanda wandari biabe bia haga mbira mini Bila berenego Leselonaga biabe bia haga berelo mini. ");
INSERT INTO hui_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Ogonidagua biyagola Yagaba ibu Leselola mandagi palialu ibu oneore gubalini timbuni hene. Anigo Yagaba ibugua Lia gubalini emene dege hene. Ani howa Yagaba ibugua mali karia mende lone biabe bialu hene. ");
INSERT INTO hui_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Anduane Homogohanda handalu hearia Yagaba ibu Lia gubalini nahe heane hondowa ibugua Lia dara halu biamogo biyagola ibu wali gali bere berene. Anigo Leselo ibu gali nabere berene. ");
INSERT INTO hui_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Emene howa Lia ibugua igiri mbira taba henene. Taba hono biruwa lalu, Anduane Homogohanda i̱naga bu miniha genda ho berewago hondowa igiri mbira ngiyadago ai i̱ agalinihanda i̱hondo gubalini timbuni holebira, lene. Ani lowa igiri ogoni ibu mini Lubene wini. ");
INSERT INTO hui_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Mani Lia ibugua igiri mende taba honowa lalu, Yagabahanda i̱ hame lalu gubalini nahe kago hondowa Anduane Homogohanda i̱ dara hayadago ai ibugua igiri mende ngiyada, lowa ibu mini Simiono wini. ");
INSERT INTO hui_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Lia ibugua igiri tebone taba honowa lalu, Ai i̱na igiri tebone taba hanarogonaga Yagabahanda i̱ gubalini halu turu howa ai i̱na haru mandagi holeberama, lowa ibugua igiri mini Libai wini. ");
INSERT INTO hui_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Lone dege Liahanda igiri mane taba hono biruwa lalu, Ai áyu i̱na Anduane Homogonaga mini yaraga holebero, lowa igiri mini Yuda wini. Mani Lia ibu nde waneigini maru taba hana nabi biraabo hene. ");
INSERT INTO hui_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Leselo ibugua waneigini mbira taba hana nabi biruwa ibu hagibuni Liahanda waneigini taba hanalu bereago hondowa ibu dimagoli ho biruwa ibu agalini Yagabahondo lalu, Í̠na nde waneigini mbira ngerene. Nangiriyagua nde i̱ homolebero, lene. ");
INSERT INTO hui_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Ani layagola Yagabahanda ibuhondo talialu lalu, Ngode Datagaliwabehanda í̠naga waneigini taba honolene mo wahayadagoni. I̱ Ngode Datagaliwabe ndo kogoni. I̱na waneigini agua bialu í̠ nguliyanaga larebe, lene. ");
INSERT INTO hui_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Ani layagola Leselohanda Yagabahondo lalu, I̱naga biabe bia haga wandari Bila bedagome i̱naga waneigini mbira taba hana helo mandagi haru palibe. Ibugua i̱naga waneigini dewa taba hanaragola mani i̱ waneigini dewali ai̱ya dege biruliya, lene. ");
INSERT INTO hui_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Ani lowa Leselohanda ibunaga biabe bia haga wandari Bila biago Yagaba hearia ibu dabu bilo haru ibini. Ani biyagola Yagaba Bilala libu mandagi palu hene. ");
INSERT INTO hui_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Ani paluwa Bila ibugua Yagabanaga igiri mbira taba henene. ");
INSERT INTO hui_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Ani biyagola Leselohanda lalu, Ngode Datagaliwabehanda i̱naga hame wiwago hondowa i̱ birugobi nde tigabi dege biruyane handayada. I̱na bi larugobi nde hale halu igiri mbira ngiyada, lowa igiri mini Dana wini. ");
INSERT INTO hui_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Wali biago ibugua Yagabanaga igiri mende taba henene. ");
INSERT INTO hui_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Taba heneagola Leselohanda lalu, I̱ hagibunila keba halu harugo ai áyu karulapeore bedogoni, lowa igiri mini Nabadali wini. ");
INSERT INTO hui_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Lia ibugua handalu hearia ibuni nde waneigini lone taba hanabe naheyane hondowa ibunaga biabe bia haga wandari mini Siliba berenego Yagabala helo miyagola ibu one ho berene. ");
INSERT INTO hui_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Ani biruwa ibugua Yagabanaga igiri mbira taba henene. ");
INSERT INTO hui_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Ani taba hanayagola Liahanda lalu, Áyu ina bolangua kogoni, lowa igiri mini Gada wini. ");
INSERT INTO hui_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Mani Silibahanda Yagabanaga igiri mende taba henene. ");
INSERT INTO hui_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Taba hanayagola Liahanda lalu, Áyu i̱ turu timbuniho bedogoni. Wali maru bedarume i̱ turuho beda lolebira, lene. Ani lowa ibugua igiri mini Ase wini. ");
INSERT INTO hui_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Widi lini gandulo wulenengi hayagola Lubene ibu mabuha ibaga bialu hearia ira lini baya mbira gamugamu biaga ale dearia hendene. Ibugua ira lini ogoni ibu ai̱ya Lia berearia do yalu pene. Ani biyago hondowa Leselo ibugua Liahondo lalu, Í̠ iginime ira lini mbira do yalu ibiyago handarugo ai maru i̱ ngerebe, lene. ");
INSERT INTO hui_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Ani lalu hearia Liahanda ladai bialu lalu, I̱ agalini nde í̠ haru pu waharigo ai í̠na manda bialu keria ogoni nagalonedabe. Áyu i̱ iginime ira lini do yidagobi nde í̠ dege nguabe, lene. Ani layagola Leselohanda ladai bialu lalu, Í̠na ira lini ogoni ngiriyagua áyu mbiragaore Yagabala palialibulo, lene. ");
INSERT INTO hui_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Ogoningi alendo Yagaba ibu mabuha howa dai bialu hearia Lia ibu harigani ngola ho puwa lalu, Áyu mbiraga iya haru mandagi palibiya. Iya palibiyanaga i̱ iginime ira lini mabuha howa do yalu ibiyagome í̠ yolobu ngeledogo, lene. Ani layagola horo ogoningi mbiraga libu haru mandagi palene. ");
INSERT INTO hui_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Ngode Datagaliwabehanda Lianaga bi hale halu biamogo biyagola ibugua igiri dauni taba henene. ");
INSERT INTO hui_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Honowa Liahanda ogodagua lene. Wandari i̱naga biabe bia haga i̱ agalini hado mirugola Ngode Datagaliwabehanda i̱ yolo bayaleore ngia dai biyada, lowa ibugua igiri mini Isaga wini. ");
INSERT INTO hui_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Mani Lia ibu wali gali bere biruwa igiri waragane taba henene. ");
INSERT INTO hui_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Taba honowa lalu, Ngode Datagaliwabehanda i̱ mo turu halu igiri waragane ngiyidagome i̱ agalinihanda i̱naga mini yaraga halu turuore holebira. Ani lowa ibugua igiri mini Sebulunu wini. ");
INSERT INTO hui_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Mani Liahanda wandari mbira taba honowa ibu mini Daina wini. ");
INSERT INTO hui_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Ainde Ngode Datagaliwabehanda Leselo mitangi bialu dara howa waneigini taba hanabehe berelene. ");
INSERT INTO hui_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Ani biyagola Leselo ibu wali gali bere biruwa mani igiri mbira taba henene. Taba hono biruwa lalu, Aiore Ngode Datagaliwabehanda i̱ biamogo bidagonime i̱ lone taga holene nawi. Ibugua i̱naga genda bibahendeore mo wahai haya. ");
INSERT INTO hui_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Ai Anduane Homogohanda igiri mendebi ngilo hame ledo, lowa ibugua igiri mini Yosebe wini. ");
INSERT INTO hui_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","26","Yagaba one Leselohanda Yosebe taba hono bereagola Yagaba ibugua Labanahondo lalu, I̱ one waneigini o bu karuni helonaga í̠naga yolo biabe luore bia halu harugoni. Ai i̱ni dindi polene hamelo kogo pu larene. Í̠naga biabe bulene wiaruni bibahende baya hanguore bialu harugo í̠ manda bidegoni, lene. ");
INSERT INTO hui_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Ani layagola Labanahanda ladai bialu lalu, Karulapego i̱na bi mbira ala langerogo hale habe. Ai ala i̱na Anduane Homogonaga hame wiago hondole handalu hewaria í̠ iya haru mandagi kabagome Anduane Homogo ibugua i̱ biamogo bialu mo bayale halu heneyane handa walia haru. ");
INSERT INTO hui_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Ani birugo í̠na i̱hondo yolo ngi laredagua nguliyago agiraore nguliya hameledebe, lene. ");
INSERT INTO hui_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Ani layagola Yagabahanda ladai bialu lalu, I̱na í̠naga biabe bialu harugo ogodagua biri lalu í̠nime manda bidegoni. Í̠naga nogo sibi haru harugome ai nogo sibi biaru bayale dewaore bu kagoni. ");
INSERT INTO hui_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Bamba í̠ nogo sibi dewa ndo emene hangu hinu heneyagoni. Ai i̱ íbu hewagola Anduane Homogohanda i̱ mitangi bialu í̠ biamogo biyagome í̠naga nogo sibi dewaore henego kagoni. Anigo áyu i̱ mbirale i̱ninagaore handaya ho holene hamelo kogoni, lene. ");
INSERT INTO hui_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Ani layagola Labanahanda ibuhondo hale halu lalu, I̱naga biabe birigonaga yolo agileore nguliya hamelo kebe, lene. Ani hale hayagola Yagabahanda ladai bialu lalu, I̱ muni ngibelo hame nale kogo ai i̱na mini ngogo karulape lariyagua nde i̱na í̠naga nogo meme sibiru hinalu holiyago i̱naga hame ngogo ogo. ");
INSERT INTO hui_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Áyu i̱na í̠naga nogo meme sibiru kagoha pialu baya hanguore hondole polebero. Ani puwa sibi igini mindi karu bibahende i̱ hai halu meme mindi pagabua pehagabi karubi i̱ holene hameledo. Ainde i̱naga biabe berogonaga yolo ogoni karulape holebira. ");
INSERT INTO hui_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Ani berogola mani howa í̠nime hondoa birangi sibi memeru haru harugonaga yolo i̱ harugo handalu ai i̱na bi larugo tiga tiga larudabe yole larudabe handalu manda bulebere. Ani handalu keria nogo meme mindi mbira pagabua bu gombedaga nabi mbira i̱naga kagoha heaguabi sibi mindi ndo mbira heaguabi nde i̱na í̠naga nogo kayu biyada lolebere, lalu lai hene. ");
INSERT INTO hui_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Ani layagola Labana ibugua ladai bialu lalu, Karulapego í̠na laregonidagua bibiya, lene. ");
INSERT INTO hui_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Ani lowa horo ogoningiore Labana ibu meme pagabua pehagabi hearubi sibi mindi hearubi ibu hai hene. Ani howa ibu igini hearuhondo lalu, Nogo uruni haru pubagi halu mendehayagi hinule haru pudaba, lene. ");
INSERT INTO hui_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Ani bialu Labana ibu ti haru pene. Tigua nogo sibi meme uruni haru halu pialu dindi tara mbiraha pialu heane dege horo tebiru pene. Ani biyagola Yagaba ibu nde Labananaga nogo sibi memeru maru helo wahayaru hinalu hene. ");
INSERT INTO hui_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Mani howa Yagaba ibugua ira gahenge tara tara hearunaga magane podo yuwa dongone lagalo wahowa irane pele pana helaga bini. ");
INSERT INTO hui_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Ani buwa nogo meme biaru iba nole ibaga wiagoria ibalu hendelo lowa handabehe wiagoria ira magane uruni bibahende wa haga bini. Nogo meme ti iba nole ibalu meme wangabe karume angibuni karu hendelelo manda buwa ani bini. ");
INSERT INTO hui_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Ani wa heagoria ibuwa meme wangabe hearume angibuni hearu ira magane dongone bu wahowa wayagoria howa hendelaga biyagola meme angibuni urunime igini mindi pagabua bu gombedagabi hono yu haga bini. ");
INSERT INTO hui_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Ani heagola Yagaba ibugua Labana nogo sibi wangabe hearume sibi angibuni meme igini mindini pagabua bu gombedagabi heagoria kaware helowa hendelaga bilo helene. Ibugua ogonidagua bialu ibunaga meme sibi hearubi Labananaga heba mandagi hela nabi ibunaga haru pu bagiho helene. ");
INSERT INTO hui_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Meme sibi hearubi mandagi iba nalu hearia wangabe bayale hongohe kagome angibuni hendelarangi Yagaba ibugua ira magane podo wiyago yu puwa nogo uruni iba naga biagoria de tiga tiga ngelaga bini. Ngelayagola nogo ti ogoniha howa hendelaga bini. ");
INSERT INTO hui_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Ani bialu howa meme sibirubi hongo nahe nogo damene bu karu hendelarangi ira magane ogoni nawi wahaga bini. Ani biyagola nogo sibi memebi Labananaga hearu bibahende ko hongo nahe damene hene. Yagaba ibunaga sibi memerubi bibahende hongohe bayale dege hene. ");
INSERT INTO hui_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Anidagua biyadagome Yagaba ibu mbirale dewa wuwa homogo hene. Ibunaga nogo sibirubi memerubi dewaore hinu halu ibunaga biabe bia haga wali agalirubi dewaore bu halu nogo kamele dongibi dewaore hinu haga bini. ");
INSERT INTO hui_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Yagaba ibu hale halu hearia Labana igini bu hearume lalu, Yagaba ibugua ina abanaga mbirale wiaru ibu mo hai halu kagome ibu mbirale dewawi homogo haragonida, laga bira layane hale hene. ");
INSERT INTO hui_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Yagaba ibu bi ogoni hale ho hearia dege Labanahandabi nde ibuhondo ala turuho hagadagua ndo ai mini mende ale wu hearia hendene. ");
INSERT INTO hui_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Ani bu heago hondowa Anduane Homogohanda Yagabahondo lamialu lalu, Áyu ogoni í̠ aba dindiha í̠ni dameneru bu karia dai bialu pobe. I̱nime í̠ baya hangu handayaho holeberogo ani bibe, lene. ");
INSERT INTO hui_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Ani layagola hale halu Yagaba ibugua ibu one Lia Leselola ibuni nogo sibi memeru haru haga biagoha ibilo libuhondo bi lawia hene. ");
INSERT INTO hui_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Libu ibiyagola Yagaba ibugua libuhondo lamialu lalu, Libu abahanda i̱hondo abale bayale bialu hagadagua ndo bialu ka. Anigoyu i̱ abanaga Ngode Datagaliwabe ibu i̱ni heba haabo ka. ");
INSERT INTO hui_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Ai i̱na libu abanaga biabe luore biaabo halu harugoni libu manda bidabigoni. ");
INSERT INTO hui_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Ibugua bia layago i̱na hongo howa bialu hewagola ibugua i̱hondo ke̱ halu i̱ yolo bule layadagua nabi mo hondo howa pi halu mo iriari biaabo haga biya. Ani bialu heago helowa Ngode Datagaliwabe ibugua Labanahanda i̱ mo ko helo yupe nahaya. ");
INSERT INTO hui_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Abale howa Labana ibugua nogo meme pagabua gilimugalimubi harago yolo ogonigo í̠ habelo layagola ai meme igini gilimugalimubi dege dewa hono yu haya. Ani heagola mani howa nogo pagabua luni giligilibi bupe hagabi kago í̠ habelo layagola meme biarume pagabua luni giligilibi bupe hagabi dewa hono yu haya. ");
INSERT INTO hui_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Ai Ngode Datagaliwabe ibugua libu abanaga nogo hearu anidagua bialu i̱ mo ngiai haya. ");
INSERT INTO hui_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Horo mbirungi emaga handalu hewaria nogo meme angibuni bu hearu wangabe pagabua giligili bigibime hendelalu hearia handaru. ");
INSERT INTO hui_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Ani hondo hewagola Ngode Datagaliwabenaga dahuliyali mbirame lalu, Yagaba-o, layagola i̱na, Ya i̱ o kogoni, laru. ");
INSERT INTO hui_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Ani larugola ibugua i̱hondo lalu, Nogo meme gilimugalimubime hendelalu kagoni í̠ de handa. Ogoni i̱nime ani mo bia harogoni. Ani berogoni irane Labana ibugua í̠hondo mana liahe bialu heago hondowa i̱na ani bero. ");
INSERT INTO hui_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Ala í̠ Bedele dindini paleria Ngode Datagaliwabe i̱na hapani harugonaga í̠na mani mitangi budai bule ege to̱le̱ haguanda harigo weli odoba halu loma bia harigoni. Ani bialu habo nalolene bi mbira i̱hondo lo wialu birigoni. Ai áyu ogoni heyalu mbirale wu haridaruni mo manda manda bialu í̠ni dalu dai bibe, laya, lene. ");
INSERT INTO hui_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Lia Leselola libugua bi ogoni hale howa ladai bialu lalu, I̱ya aba andagaha howa mbirale mbira mo yulene nawi. ");
INSERT INTO hui_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Iya abahanda iya wali tara berelaradagua biya. Ibugua iya dabuni dewa taguiyagoyu bibahende ibuni mo hole biai haya. ");
INSERT INTO hui_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Mbirale bibahendeore Ngode Datagaliwabehanda iya abanaga giha howa yamialu í̠ mo ngiai hayagoni. Anigo uruni bibahende iyanebi iya waneigini bu karubi ina harunaga ngago ai Ngode Datagaliwabehanda bibe lalu langiyadadagua bibe, lene. ");
INSERT INTO hui_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Ani layagola Yagabahanda ibu one waneiginiru nogo kamele erembirani berelai halu ");
INSERT INTO hui_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","ibunaga nogo sibi memeru haru hai halu mbirale yári damene Mesobodemiaha howa mo yiniru ya bialu ibu bamba halu pene. Anidagua bialu ti dindi ogoni wahalu ibuni dindi ibu aba Aisaga hearia Kenana dai bini. ");
INSERT INTO hui_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Ti pole howa Labana ibu ibunaga nogo sibi irini podama piyago hondowa ti pene. Pole howa Leselo ibugua ibu abanaga mbirale dama mitangi bialu bi pupu wule gime wabini mbira anda mamage helo mo do ho wiago mo yalu pene. ");
INSERT INTO hui_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Yagaba ibugua nde ina anidagua poleberema lalu Aramiali Labana lamia nabi ti ohalu ");
INSERT INTO hui_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","ibunaga mbirale wiyadaru bibahende kabu biai halu yalu pene. Ibugua Labana dalu wahalu puwa iba Yuberedisi doma ede halu Gileadaha hari barebare wiago hondo yalu pupe hene. ");
INSERT INTO hui_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Ti ani peaha horo kiru howa horo teboneni agali marume Labana lamialu lalu, Yagaba togo lalu abale piyago ndobe, lene. ");
INSERT INTO hui_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Ani layago hale howa Labanahanda ibu damene bu hearu haru halu Yagaba talima pialu horo karu harigani handa paligi bima pene. Ani pialu tigua Yagaba ibu Gileada dindiha dindi barebare wiagoria anda pu hearia ibini. ");
INSERT INTO hui_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Ibiyagola Ngode Datagaliwabehanda mbiraga mbirungi emagaha howa Labanahondo lamialu lalu, Í̠na Yagaba mo gi hole mbirale mbira nabibe, lalu lamini. ");
INSERT INTO hui_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Yagaba ibu hari hombene wiagoria balai anda bu hearia Labana ibu hendene. Ani hondowa Labana halu agali ibuni damene haru hayaru tibi nde Gileada dindiha hari hombene wiagoria dege balai anda bini. ");
INSERT INTO hui_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Ani bialu Labana ibugua Yagaba hearia puwa ibuhondo lalu, Irane aginaga í̠na i̱ mayongo bia halu i̱ wane biago labo wai bialu garabaya haru poradagua bialu pu yola harigo agibe. ");
INSERT INTO hui_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Í̠ ani pole kogoni lalubi i̱ nalangi howa yola halu ibiriyago irane agi. Í̠ pole kogoni lalu i̱ abale biago langidele nde i̱na i̱ dameneruhondo lamialu tigua iba gana lalu ngida balu í̠ baya hanguore turu hama pobe ledole. ");
INSERT INTO hui_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Ai ani ndo í̠na i̱ wane biago labohondobi i̱ aguaneruhondobi tí pilimu lalu i̱nime yu nu̱nu̱ loliya ha nabi piriyagoni mana koore biriya. ");
INSERT INTO hui_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","I̱na tí mo ko holene karulapeore kogo ainde í̠ abanaga Ngode Datagaliwabehanda áyu mbiraga emagaha howa i̱ langialu lalu, Í̠na Yagaba mo gi holene ale mbirale mbira nabibe, laya laro. ");
INSERT INTO hui_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Ainde i̱ yu wahalu í̠ni dalu dai buleore hame laridane manda bidogo. Anigo irane aginaga mbirale dama mitangi bialu bi pupu wule gime wabinigo i̱ andaga mamage helonaga ngelarugo tí mo hilo yai halu ibirimida agibe, lene. ");
INSERT INTO hui_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Ani layagola Yagabahanda ladai bialu lalu, I̱ ohalu í̠ handa nabini ibirudagoni irane í̠ wane biaruni í̠ni haru dai bibeheyane biru. ");
INSERT INTO hui_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Ani birugo ai ina ibirimadago aria mbirame í̠naga mbirale bi pupu wiaga ogoni mbira mo yiniyagua ogoni ibuni homelo bo wahabe. Ainde í̠ damene bu kamaru bibahendenaga deni howa mbirale iname mo yalu ibirimadaruni handai hole íbu. Handalu keria mbirale mbira í̠naga lenego wiagua ogoni í̠ni mo yu dai bibelo, lene. Anigo Leselohanda ibu abanaga mbirale bi pupu wule gime wabini uruni mo do ho bereago manda nabi howa Yagaba ibugua anidagua lene. ");
INSERT INTO hui_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Ani laya handala Labana ibugua Yagabanaga balai anda heagoha anda puwa mbirale wiaru baya hangu handai hene. Handai halu Lianaga balai anda heagohabi anda puwa handai hene. Ani bialu biabe bia haga wali kirali bereagonaga balai andahabi handalu hearia ibunaga bi pupu wule gime wabini biaruni mbira wiaria handa walia nahe dege hene. Nawioreya handala ai uruninaga balai anda helalu Leselonaga balai anda heagoha taya bule anda pene. ");
INSERT INTO hui_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Anda puwa mbirale bi pupu wule gime wabini ogoni Leselo ibu mo page buwa nu ale mbira nogo kamele erekunini mo pagaho biraga wiagoha hanado ho ngelowa ibuni bira dambiho berene. Ani bereagola Labana ibugua balai anda tamuha anda puwa taya bialu hearia uruniha nawi degeyane hendene. ");
INSERT INTO hui_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Ani handalu hearia Leselohanda lalu, Aba-o í̠na i̱ heya nalabe. Áyu i̱na walinaga horongi bedogo, lene. Ani layagola Labanahanda taya bialu heariabi mbirale dama mitangi bialu bi pupu wule gime wabini biagoni mbira handa walia nahe dege hene. ");
INSERT INTO hui_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Ani handa walia nahe dege heagola Yagaba ibugua Labanahondo keba howa lalu, I̱na í̠hondo mana ko liahe mbira agi birugonaga í̠na i̱ haruru talima ibiribe. ");
INSERT INTO hui_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Í̠na mbirale i̱naga wiwaruni bibahende handai harigonidago ai mbirale agilego mo yiwaria handa walia haribe. Í̠naga mbirale mbirale wiaria handa walia hariyagua nde wali agali í̠ aria bu karubi i̱ aria bu karubi bibahendenaga deni ti hendelo mo pani ha. Ani beregola tigua iyanaga bi hale hai howa ái ibunaga bi tigabidabe hendelo ani bia nabere. ");
INSERT INTO hui_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Ai i̱na mali pira kira (20) í̠la haabo harugo. Ani hewagola í̠naga nogo sibi memeru bibahende igini bayale wialu haya. Ani howa í̠naga nogo sibi uruni aria wangabe hearu mbira balu na nabi dege haru. ");
INSERT INTO hui_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Ani handayaho hewagola ai gabua tara tara karume í̠naga nogo sibi memeru mbira balu naragola ogoale biya lalu í̠ni langia nabi i̱nime nogo dege aribia haruli. Í̠naga sibi memeru mbirale mbira ngamiru mbiraga horombeyaguabi mbiralime page bu yalu piyiyagua minalu biyada nale howa i̱hondo í̠naga nogo aribia habe larili. ");
INSERT INTO hui_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Horo bibahendengi ni tandagabi dayagome i̱ do yogo biyagola i̱na harugo lowa biabe bialu haruli. Mbiragabi dagare nde timbuni biyagola u napale harugo lalu haruli. ");
INSERT INTO hui_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Ogonidagua i̱na mali pira kirani (20) í̠naga biabe biaabo halu haru. Í̠ wane kira biago labo dabu bule mali pira mbirani maria (14) í̠naga biabe bialu nogo meme sibiru ngibelonaga i̱na mali waragaria biabe bialu haru. Ani bialu hewagola í̠na yolo ogoore nguliya lalu lo wirigo wahalu mende ale mo iriari biaabo haga birili. ");
INSERT INTO hui_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Ani biriligo ainde i̱ mamali Abarahama Aisagabi libugua Ngode Datagaliwabe mo tene howa ibu mitangi bialu lotu lalu haga kago ibugua i̱ heba nahenedale í̠na i̱ mbirale mbira giha nayi bame dai bia ledelego. Ainde Ngode Datagaliwabe ibugua i̱naga bu miniha genda yu hewago handalu biabe ndelahe bialu harugo mitangi bialubi ibunime bi hongohe mbiraga í̠ talialu bi langiyada, lene. ");
INSERT INTO hui_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Labana ibugua Yagabanaga bi layarunaga ladai bialu lalu, Wali kira o bedagoni labo libu i̱ wane biralu libu waneigini bu karunibi nde i̱ aguane bu ka. Ani bialu nogo sibi meme bu karunibi nde i̱ nogo dege bu ka. Mbirale bibahende o ngaruni i̱naga wini biaruni degedago. Ainde i̱ wane kira ogolabo baba libunaga waneigini bu karunibi ina mandagi holoma̱yanaga tihondo mbirale mbira agilego buliyabe. ");
INSERT INTO hui_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Mbira bulene nawidago ainde habo nalolene bi mbira dege lo wibiya. Ani lo wialu bi ogoni mo mitangi bia helonaga ege to̱le̱ dugu hangabiya, lene. ");
INSERT INTO hui_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Ani layagola Yagaba ibugua bi ogoni mitangi biaabo holenaga tubari ege to̱le̱ mbira dugu hengene. ");
INSERT INTO hui_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Ani hongowa ibu damene bu hearuhondo lamialu, Ege to̱le̱ dewaore dugu yu ibalu wima irigi hadaba, layagola tigua ani biai hene. Mani ani biai howa Yagaba ibu damenerubi Labana ibu damenerubi bibahende ege to̱le̱ dewa dugu wima irigi ho heagoria tomo timbuniore dawalu ti mandagi biruwa nene. ");
INSERT INTO hui_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Ani biruwa Labana ibugua ege to̱le̱ dugu wima irigi hene wiago mini Yaga Sahaduda wialu Yagabahanda ege to̱le̱ uruni mini Galede laga wini. ");
INSERT INTO hui_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Labana ibugua lalu, Ege to̱le̱ dugu wima irigi ho ngago ogoni habo nalolene bi áyu lo wiribagonaga tubari ogoni iya mitangi biaabo holobaya wiaabo helo, lene. Ani lene winigo wali agali heneru tigua ege to̱le̱ dugu wima irigi hene ogoni mini Galede laga wini. ");
INSERT INTO hui_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Ani wialu Labana ibugua lalu, Iya haru mandagi nahe haga hagabu kabago iyame mana bialu kabaruni Anduane Homogo ibunime handape halu helo hameledo, lene. Ani layagola dindi ogoni mini mendebi wialu nde Misiba laga hene. ");
INSERT INTO hui_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Labana ibugua la dege bialu, Í̠na i̱ wane kira o bedago labohondo mana ko bialu hariyaguabi wali maru biru ngaruni dabu bialu piriyaguabi bi áyu lo wiribago wali agalime manda nabi heaguabi mana iyame bialu kabaruni bibahende Ngode Datagaliwabe kagome handai ho kagoni manda bibe, lene. ");
INSERT INTO hui_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Ani lowa Labanahanda Yagabahondo laabo halu lalu, Ege to̱le̱ uruni iya kabago hengeneha dugu wima irigi hene ngaru handalu ege to̱le̱ mbiraore luni amu heyu kagobi handabe. ");
INSERT INTO hui_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Ainde ege to̱le̱ luni amu heyu kagobi maru o dugu wima irigi haribagobi ogonilabo kirabali habo nalolene bi lo wiribagonaga tubari ogoni holebira. I̱na ege to̱le̱ ogoni bolangua halu í̠ kegohayagi wai bule naibaguago í̠nabi nde ogoni bolangua halu i̱ kogohayagi wai bule naibabe, lene. ");
INSERT INTO hui_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Ani lowa lalu Labana ibugua ibu mamalirunaga Ngode Datagaliwabenaga minini howa lalu, Abarahamanaga Ngode Datagaliwabe kagomebi Nahonaga Ngode Datagaliwabe kagomebi mana iyame bialu kabaru tiga tigaore ngadagua mo tale bilo, lene. Ani layagola Yagaba ibuguabi nde ibu aba Aisagahanda Ngode Datagaliwabe kago mitangi bialu lotu laga henegonaga minini howa lalu, Í̠na laredagua i̱na buleorebero, lalu bi lo wini. ");
INSERT INTO hui_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Ani lo wialu ibugua hari bare ogoriani Anduane Homogohondo nogo mbira bo lomabu delene. Nogo bo lomabu delayagonaga mbirini wiaru ibu dameneru nole ibidaba lene. Ogoni nalu mbiraga ogoningi ti bibahende hari bare ogoriani ho palu hene. ");
INSERT INTO hui_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Palialu gao layagola Labana ibu heyalu ibu wane kira biagobi ibu aguane hearubi yu nu̱nu̱ lai halu hondo halimu lalu ibuni dalu dai bini. ");
INSERT INTO hui_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Yagababi ibu damene biarubi ti harigani pole pialu hemiria Ngode Datagaliwabenaga dahuliyaliru lola hene. ");
INSERT INTO hui_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Ti ani hondowa ibugua lalu, Dindi ogoni Ngode Datagaliwabe ibu hagahadago, lowa ibugua dindi ogoni mini Mahanaima wini. ");
INSERT INTO hui_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Mani Yagabahanda agali maru tale buwa bi yalu Sia dindi mini mende Idomo mbira ngagoria ibu hamene Iso lola hole pudaba lene. ");
INSERT INTO hui_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Ani pialu bi ogodagua lalimu laya. Agali haguane Iso-o í̠naga biabe bia haga Yagabahanda ogodagua laya. I̱ Labanala luore howa harugo ai dai bulene hame ledogoni. ");
INSERT INTO hui_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","I̱na nogo bulumagaru dongiru sibiru memeru dewa hinalu wali agali i̱naga biabe bia hagabi dewaore kago. Ai áyu i̱naga agali haguane-o í̠na i̱ha mini yaleyale holani nahe howa miniha dungulo habelonaga laro labe, lalu bi ogoni yalu pudaba, lene. ");
INSERT INTO hui_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Agali bi yalu piyarume dai bialu howa lalu, I̱name í̠ hamene Iso hearia bi yalu pirimago ai ibu harigani í̠ lola hole agali handari maria (400) heba ibira, lene. ");
INSERT INTO hui_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Bi ani layago hale howa Yagaba ibu gi timbuni howa mini burugulo hene. Ani howa ibugua ibunaga biabe bia haga wali agalibi nogo bulumagaru dongiru memeru sibiru kamelerubi bibahende halu kirani talebuki howa halu kirani anda bu paligi paligi bini. ");
INSERT INTO hui_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Isohanda ibalu wabuni mendegola wai biyagua nde wabuni mendego ibida pelo manda buwa ani talebuki hene. ");
INSERT INTO hui_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Ani talebu helowa Yagabahanda Ngode Datagaliwabehondo bi ogodagua lene. I̱ mama Abarahamanagabi i̱ aba Aisaganagabi Ngode Datagaliwabe-o i̱naga bi larogo hale ha. Anduane Homogo-o abale í̠na i̱hondo lalu mani i̱naga dindi dai berogola í̠na i̱ mo bayale holebero larigoni. ");
INSERT INTO hui_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","I̱ agali baya biaga ndo hewaria í̠nime dara halu i̱hondo bayale dege biaabo hariligoni. Abale iba Yodana domalu Labana hearia pole pirungi i̱naga giha mbirale nayiore halimbu hangu yalu pirugoni. Ai áyu mbirale bibahende talebuki buwa wabuni kira ngelo kogoni. ");
INSERT INTO hui_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","I̱ hamene Isohanda wai biba loligo í̠na mamage habe lalu i̱ onene waneiginirubi bibahende bai holigonaga í̠hondo bi larogoni. ");
INSERT INTO hui_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Abale í̠na i̱hondo lalu, Í̠ waneigini aguanenebi daga labe nahe dewaore iba mu ngaligobi holebira, larigonidane laro, lene. ");
INSERT INTO hui_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Yagabahanda mbiraga palialu heyuwa egerebalene hayagola ibunaga nogo uruni maru ibu hamene Iso talebu mule manda manda bini. ");
INSERT INTO hui_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Ibugua nogo meme angibuniru handari kira (200) wangaberu pira kira (20) nogo sibi angibuniru handari kira (200) wangaberu pira kira (20) lowa helene. ");
INSERT INTO hui_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","Nogo kameleru pira tebira (30) tinaga iginiru heba nogo bulumaga angibuniru pira maria (40) wangaberu pira mbira lowa talebu helene. Dongi angibuniru pira kira (20) wangaberu pira mbira tale bigibu helowa ");
INSERT INTO hui_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","nogo uruni damene mbira mbira haru helonaga agali biabe bia haga mbira mbira helowa lalu, Ai tígua ala bamba halu pudaba. Pialu howa nogo ti biamagamaga nabi tini aria degedege wabuni pugupugu bilalimu, lene. ");
INSERT INTO hui_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Ani lowa Yagabahanda ibunaga biabe bia haga haguane biagohondo bi ogodagua lamini. I̱ hamene Iso í̠ harigani lola haregola ibugua í̠hondo hale halu lalu, Í̠ agali ainaga biabe biagabe. Í̠ ani pore. Nogo uruni ainaga haru kebe, laga biyagua ");
INSERT INTO hui_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","í̠na ogodagua ladai bibe. Uruni í̠naga biabe bia haga Yagabanaga. Ibugua uruni í̠naga wia haya. Yagaba ibuni wene mani ibira, lalu lamibe. ");
INSERT INTO hui_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Ani lowa Yagabahanda ibunaga biabe bia haga mende tebonehondobi bi mbiraore ogonidagua dege lalimu lalu bi endeho mini. ");
INSERT INTO hui_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Bi maru urunibi ladege bilimu. I̱naga biabe bia haga Yagaba ibuni maha ibira lalimu. Yagaba ibugua Iso mo gede harogola ibugua ala keba ho hayago wahalu turu howa ibu lola helo manda buwa ani bini. ");
INSERT INTO hui_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Nogo biarubi agali nogo haru piyarubi ti pudaba lowa ibuni horo mbira ogoningi ho palene. ");
INSERT INTO hui_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Ogoningi dege mbiraga hayagola Yagaba ibugua ibu one kiralibi wali biabe bia haga kirali biago labobi ibu waneigini beriali (11) biarubi ti ibuwa iba mini Yabogo domade hene. ");
INSERT INTO hui_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Domade howa edeyagi berelalu ibuni ibunaga biabe bia haga agali biaru hearia dai buwa ibunaga dabudabu yarimiru yalu ma lama pene. ");
INSERT INTO hui_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Ti piyagola ibuni hangu ederayagi hondo hene. Ani hearia agali mbira iraga howa gi gungu bialu hebine ega bi lene. ");
INSERT INTO hui_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Gungu bialu dege hebine agali biagome Yagaba bope habe naheyane hondowa Yagabanaga ge mendeyagi bo yolope hene. ");
INSERT INTO hui_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Libu gungu bialu howa agali biagome Yagabahondo lalu, Ai ega bi layadago i̱ poliya yu peha, lene. Ani layagola Yagabahanda lalu, Í̠na i̱ biamogo bialu mo bayale helonaga bi mbira ala labe. Bi la kegola pobelo yupe holiya, lene. ");
INSERT INTO hui_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Ani layagola agali biagome Yagabahondo lalu, Í̠ mini ai kebe, lene. Ani layagola Yagabahanda ladai bialu lalu, I̱ mini Yagaba kogoni, lene. ");
INSERT INTO hui_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Ani layagola agali biagome lalu, Í̠na agalirubi Ngode Datagaliwabebi baba gungu bialu í̠ wayali harigodago ai í̠naga mini Yagaba wahalu í̠ mini Isaraele lolebira, lene. ");
INSERT INTO hui_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Ani layagola Yagabahanda lalu, Í̠ nde aibe mini langerene, layagola agali biagome ladai bialu lalu, I̱naga mini agi bule languliyabe, lowa ibugua Ngode Datagaliwabehanda Yagaba biamogo bialu mo bayale helonaga bi lene. ");
INSERT INTO hui_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Ani biyagola Yagabahanda lalu, I̱ Ngode Datagaliwabe dengui hondowa ai homa nabi kogoni, lowa ibugua dindi ogoni mini Peniele wini. ");
INSERT INTO hui_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Ni tagira ibiyagola Yagaba ibu dindi Peniele ogoni ngelalu pene. Pialu ibunaga ge tigatiga piagadagua ndo pene. Tene agi ge mendegonaga wabene dugupe hayagome ge kohe hene. ");
INSERT INTO hui_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Ani binidago manda buwa Isaraele wali agali tigua nogonaga ge kuni mbirini nanaga winigo nga. ");
INSERT INTO hui_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Yagaba ibugua handalu hearia Isonaga agali handari maria (400) haru halu ibiyaria hendene. Ani ibiyago handalu Yagaba ibu waneigini bu hearuni, Tí ai̱ya baba hagahaga bu hole pudaba, lene. ");
INSERT INTO hui_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Ani lalu wali biabe bia haga bereago labo libu waneigini heba bamba halu Lia ibu waneiginiru heba mani pialu Yosebela ibu ai̱ya Leselola maniore pumaro bini. ");
INSERT INTO hui_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Ani piyagola Yagaba ibuni ibu dameneru piyadagua mo bamba halu puwa ibugua dindini ge duli hanga halu dengui dindini ela helo bulu paligi bialu kahalu ani dege bima pialu ibu hamene Iso heagoria hapara hene. ");
INSERT INTO hui_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Ani biyagola Iso ibu abale gerai ibalu ibu hamene yu hubi lalu nu̱nu̱ lene. Ani bialu libu haru dugu bigibigi bialu hene. ");
INSERT INTO hui_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Ani dugu bialu howa Iso ibugua handa amu howa handalu hearia wali waneigini ibiyaru hondowa ibugua Yagabahondo hale halu lalu, Í̠ heba ibiraru ti aibe, lene. Ani hale hayagola Yagabahanda ladai bialu lalu, Ngode Datagaliwabehanda í̠naga biabe bia haga agali i̱ mo bayale halu wali waneigini uruni ngiya, lene. ");
INSERT INTO hui_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Ani leagola wali biabe bia haga biagolabo libunaga waneigini heba ala ibalu Isonaga wanakuihayagi ge duli hanga howa denguime dindi ela helo bulu palene. ");
INSERT INTO hui_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Ani biyagola Lia ibu nde ibuni waneigini heba ibalu Isonaga wanakuihayagi bulu palialu dengui dindini ela helene. Yosebe Leselola mani íbumaro bialu libubi ge duli hanga howa denguime dindi ela hene. ");
INSERT INTO hui_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Ani biyagola Iso ibugua lalu, Agali maru nogo sibiru haru ha mbiraleru ya bigi bialu bamba halu pu lariyaruni lola harugo ai irane aginaga yalu pudaba laribe, lene. Ani layagola Yagaba ibugua ladai bialu lalu, Agali haguane-o mbirale uruni i̱la í̠naga bu mini hado habelonaga ibilarugoni, lene. ");
INSERT INTO hui_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Ani layagola Isohanda ladai bialu lalu, Hamene-o i̱ mbirale wiai kogo í̠naga wia hariyaruni í̠ni holene karulape, lene. ");
INSERT INTO hui_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Ani layago lelowa dege Yagabahanda lalu, Anigo í̠na i̱la bu miniha hado heyagua nde mbirale uruni i̱na talebu ngerogoni mo ya. Ai í̠naga wanakui handalu koria dengui wálalu Ngode Datagaliwabenaga dengui handalehe hendedogo. Í̠na i̱la bu miniha hado kene hendedogoni. ");
INSERT INTO hui_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Ani hendedogo ainde mbirale i̱na bame í̠ ngerogoni harugo mo yarene. Ngode Datagaliwabehanda i̱ mo turu halu mbirale bayale dege ngiyagola i̱ni karulapeore yu kogo ai uruni í̠ mo ya, lene. Ani dege lalu lo hongo halu mo yaore laya handala nde Iso ibugua mbirale Yagabahanda miyadaruni mo yini. ");
INSERT INTO hui_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Ani mo yuwa Iso ibugua lalu, Ai i̱bi nde ina haru mali̱ya heyalu ma, lene. ");
INSERT INTO hui_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Ani layagola Yagaba ibugua ladai bialu lalu, Agali haguane-o waneiginiru ge hongo halu gerai labe nahedago nogo sibi igini áyu dege hono wini gali bu karubi nde ani degedagola horo mbira hanguni gerai lalu abale anda pobe nahedago í̠ manda bide. Abale pialu horo mbiru hanguni anda polene manda buwa nogo bu karu wara daila harimayagua nde nogo uruni bibahende homai holebira. ");
INSERT INTO hui_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Anigo agali haguane-o ainde í̠na bamba halu ala pialu ha. I̱na nde mani nogo waneigini bu karuni haru halu hendore ibugu bialu eberogoni. Ani ibalu amu Idomo dindini lola habiya, lene. ");
INSERT INTO hui_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Ani layagola Isohanda lalu, Aniyagua nde i̱naga agali bu karu maru tí haru mandagi ibalimulo heloliya, lene. Ani layagola Yagabahanda lalu, Agali haguane-o í̠na i̱hondo mana bayaleore berego nde wahalu i̱naga agali bu karuni tini karulape haru ibulebirago wahadaba, lene. ");
INSERT INTO hui_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Ani laya handala Iso ibu horo ogoningi pialu Idomo dindi pole pene. ");
INSERT INTO hui_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Yagaba ibu nde pialu Sugodo dindi wiagoria anda puwa ibugua ibunaga balai anda bia halu balai anda emene emene maru ibunaga nogo sibi bulumagaru bu hearunaga bia hene. Ani binigo manda bialu tigua dindi ogoni mini Sugodo wini. ");
INSERT INTO hui_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Yagaba ibu Mesobodemia yu wahalu Kenana dindiha dai buwa Segeme tano kaware wiagoria balai anda bu hene. ");
INSERT INTO hui_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Ani pu howa dindi ogoni Segeme aba Hamo aguanenerunaga winigo ibugua dindi ogoninaga muni siliba handari mbirame (100) yolo bini. ");
INSERT INTO hui_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Ani buwa Yagaba ibugua lomabu delaga dabu mbira dindi ogoriani bu helene. Ani bu helowa dabu ogoni mini Ele Isaraele wali agalirunaga Ngode Datagaliwabe lalu bu helene. ");
INSERT INTO hui_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Yagaba Liala wane mbira mini Daina berenego ibu nde horo mbiru Segeme tanoha Kenana wali berearu nenege pene. ");
INSERT INTO hui_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Hibiali mbira mini Hamo henego ibu nde Kenana dindiha tano ogoninaga agali haguane hene. Agali ogoni ibu igini Segeme henegome Daina ibalu hearia hondowa ibugua minu yania halu kayu bini. ");
INSERT INTO hui_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Ani binidagoni Daina ibu wandari bayaleore bereago hondowa hame timbuni lowa binigo ai ibu Dainahondo ibu hame lelonaga bi gedaoreme ladebodebo bialu hene. ");
INSERT INTO hui_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Ani lalu puwa Segeme ibu abahondo lamialu lalu, Aba-o wali ogoni i̱ dabu buliya í̠na damu pu ha, lene. ");
INSERT INTO hui_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Yagaba ibu nde ibu wane Daina Segemehanda kayu biya layago hale ho hene. Anigo ibu igini bu hearu ti tagiraha nogo sibi bulumagaru haru hama peaha hale howa Yagaba ibugua nde bi mbira labe naheyagola wahowa ibu iginiru andaga dai bilo lowa hondo hene. ");
INSERT INTO hui_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Ani hearia Segeme aba Hamo ibu Yagabala bi lole ibini. ");
INSERT INTO hui_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Libu bi lalu hebira Yagaba igini biaru ti andaga dai buwa bi layalaya hale halu hearia Segemehanda ti mbalini biago kayu biya layago hale howa tigua tandaga timbuni halu keba hai hene. Ainde Isaraele hameigini tinaga deni Segeme ibugua Yagaba wane Daina kayu biyadagoni mana koorene ko mbira bini. Isaraele hameigini tigua mitangi bialu mana ogonidagua bulene nawiore mitangi bu haga wini. ");
INSERT INTO hui_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Hamohanda Yagabahondo lalu, I̱ igini Segeme ibugua í̠ wane bedago hame timbuniore lo kago ai libu dabu bilo karulapedabe be nakarulapedabe. ");
INSERT INTO hui_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Ainde ina haru mandagi howa wandari ina wane bedaru nde tí dabu bialu tí wane bedaru nde ina dabu bigi bimi̱ya hamelo ko. ");
INSERT INTO hui_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Ani bialu tínibi nde ina dindi ogoha mandagi dege hami̱ya. Tí dindi lene mbira tíni holene hame ledamigoriani howa tomo hanga nogo sibi bulumagaru hina bialu biyinayaru bialu tíni halimulo, lene. ");
INSERT INTO hui_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Segeme ibu nde ibu abala haru mandagi dege ibinigo ibugua Daina aba mbalini hearuhondo bi lamialu lalu, Tígua i̱naga bi larogoni hale halu karulape larimiyagua nde tínime i̱hondo ngi laramigo ngiai holebero. ");
INSERT INTO hui_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Tínime nogo wariabu ogodagua hende habe lalu langeramidagua hende holiya. Aniore buliyago wali ogoniore i̱ dabu buliya ngiaore bilimu, lene. ");
INSERT INTO hui_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Anigo Yagaba igini biaru tigua Segemehanda ti mbalini Dainahondo mana ko timbuni biyago miniha mo pehowa mitangi bu hene. Ani mitangi bu howa tigua Segemela ibu aba Hamolahondo ke̱ howa mo hondo halu ");
INSERT INTO hui_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","tigua ogolabohondo lalu, Agali mbira ibunaga dongone podo mabu nabi kagohondo ina mbalini namuleberema. Iname ogonidagua dabu bilo mirimayagua ina tagabi holeberema. ");
INSERT INTO hui_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Ai tígua mbiraore hangu bulene ngago ogoni ala bule pudaba. Ani bialu tí nde ina kamagobi dege hole agali tí bibahendenaga dongone podo mabu biai hole pudaba. Tígua ogonidagua bidamigola nde mani tígua bi laramigo hale halu karulape loleberema. ");
INSERT INTO hui_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Anidagua birimiyagua nde ina wane bedarubi tí dabu bilimulo ngialu tí wane bedarubi nde iname dabu buleberema. Ani buwa inanebi tí heba mandagi halu ina hameigini mbiraore hangu holeberema. ");
INSERT INTO hui_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Ainde tígua tínaga dongone podo mabu nabirimiyagua nde inanaga wali ogoni haru halu tínaga dindi ogobi wahalu tagira poleberema, lene. ");
INSERT INTO hui_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Ani layagola Hamo ibu igini Segemelame bi ogoni karulapeda lo manda bini. ");
INSERT INTO hui_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Ani manda bialu Segeme ibugua Yagaba wane Dainaore hame timbuni lo howa tigua bibe layadagua ibugua bule pene. Segeme ibu damene dindi ogoniha bu hearume ibunaga mini mo yaraga hene howa tinaga deni ibu agali mini lene mbira ona hene. ");
INSERT INTO hui_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Ani howa Hamo ibu igini Segemela libuni dalu pialu tanoha ubanda tagi biaga pabe haraba wali agali ngoai haga wiagoria pu howa agali maru hearu heba bi lalu hene. Libugua tihondo lamialu lalu, ");
INSERT INTO hui_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Agali íbu hearuni ti bayaleore heneyago howa ai ina baba mandagi holene hamelo hea. Inanaga dindi timbuni ngamagoniha howa tinime hoa biragoha ta nabi ibagabu helo wahami̱ya. Ani howa iname ti wane bedaruni dabu bialu tiguabi nde ina wane bedaruni dabu bilo. ");
INSERT INTO hui_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Ani bimi̱yanaga iname mbirale mbira bulenego tigua bilimu laya. Ti kamagobi dege hole agali bibahendenaga dongone podo mabu biai halimu laya. Tigua lalu, Ogonidagua birimayagua nde tígua ina heba mandagi howa hameigini mbiraore ho holene karulapeda, lo manda biya. ");
INSERT INTO hui_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Ani bialu tinaga nogo sibi bulumagarubi tinaga mbirale tara tara yu karubi bibahende inanaga hangu wiai holebira ndobe. Ani bulebirago ai tigua inahondo bi mbira langiyago hangu bimi̱ya. Ani beremagola bibahende tigabi wiai holebira, lene. ");
INSERT INTO hui_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Ani layagola agali tanoha hearu tigua Hamo Segemelame bi layagoni karulapeda lowa tinaga dongone podo mabu biai hene. ");
INSERT INTO hui_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Horo kiru peagola agali dongone podo mabu bini biaruni ti tandaga howa dege hene. Ani heagola horo tebonengi Daina mbalini kirali Simiono Libailame wai biaga ayu tibu yalu tanoha anda pene. Ani anda puwa mbiralime libu hapai habe naheore pialu agali tanoha bu hearuni bibahendeore homelo bo wahaiore hene. ");
INSERT INTO hui_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Ani bialu libugua Hamo igini Segemebi homelo bo wahalu Daina ibu Segeme andagaha berearia libuni haru halu dai bini. ");
INSERT INTO hui_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Simiono Libailame Segemenaga tanoha agali hearu bibahende bo wahai heagola Yagaba igini maru hearume tanoha anda puwa dabudabu bayale damene bu wiaruni bibahende mo yai hene. Ani binidagoni irane ti mbalini Dainahondo mana ko biyagonaga bene. ");
INSERT INTO hui_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Tigua nogo sibi meme bulumaga dongiru bibahende haru piai hene. Ani bialu mbirale bibahende tano tagirahayagi wini wiarubi tano tamuha wini wiarubi bibahende mo yalu piai hene. ");
INSERT INTO hui_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Ani bialu mbirale muni timbunime yolo biaga ale dewaore mo yalu wali waneigini biru wiarubi ti haru haga bini. Ani haru howa anda bu hearuha wiaruni damenego bibahendeore mo yaiore halu pene. ");
INSERT INTO hui_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Mani howa Yagaba ibugua Simiono Libailahondo lamialu lalu, Libugua genda timbuniore i̱ha mo ya haribida. Dindi ogoha padaru Kenana wali agalirubi Perese wali agalirubi wali agali maru bibahendebi ai tigua i̱ore agali kooredane hondolobada. I̱ agali dewa nahe kogo ainde agali bu karume mo mogo bialu wai ibiyagua nde i̱bi i̱naga waneigini bu karunibi ina bibahende bo wahai holobada, lene. ");
INSERT INTO hui_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Ani layago lelowa dege libugua lalu, Agilego o lalu kegonibe. Wali iya mbalini ogoni wahalu bayanda wali biralu ibu agali kayu yama ibagabu berelo wahama lalu laribe, lene. ");
INSERT INTO hui_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Ngode Datagaliwabehanda Yagabahondo lamialu lalu, Áyu ogoni heyalu Bedele dindini hole pu. Ani pu howa i̱naga lomabu delaga dabu mbira ogoriani bu helabe. Horo mbiru í̠ hamene Isohondo gi halu ibida pole pialu heria Ngode Datagaliwabe hapani harugo i̱ kogoni, lene. ");
INSERT INTO hui_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Ani lamiya handala Yagaba ibu one waneiginirubi ibunaga biabe biaga hearubi bibahendehondo lamialu lalu, Tígua mbirale dama mitangi bialu gime wabini yu kamiruni bibahende wahai halimu. Ani bialu mana bayale tigabi holenenaga ngago bialu howa aga dodo nahe bayale ngaru karulo halimu. ");
INSERT INTO hui_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Ai ina dindi ogo yu wahalu Bedele mali̱ya kamagoni. Bedeleni pu howa i̱na lomabu delaga dabu mbira Ngode Datagaliwabenaga bia holiya. Ngode Datagaliwabe ogoni ibugua i̱ genda yu hewangi i̱ heba haabo howa i̱ ibaga bialu porogo bibahendeha i̱la mandagi haabo haga kagoni, lene. ");
INSERT INTO hui_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Ani layagola tigua mbirale dama mitangi bialu bi pupu wule gime wabini dindi taraha howa mo yu ibini tinime yu haga biniyaruni bibahende Yagabahondo mo miai hene. Ani mialu mbirale haleria daga wiarubi heba golo mialu bini. Ani biyagola Yagaba ibugua mbirale uruni bibahende Segeme dindi kawareni ira mbira mini oga laga heago teneha hora hene. ");
INSERT INTO hui_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Anidagua bialu Yagababi ibunaga one waneiginibi wali agali biabe bia haga hearubi bibahende tano yu wahalu piai hene. Ngode Datagaliwabe ibunime tano bibahende wiaruha hearu ti gi holene timbuni mo wia hayagola tigua Yagaba halu ibu damene piyaruni talima pobe nahe hene. ");
INSERT INTO hui_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Ani hea handala Yagaba halu ibu damene biaru heba pialu Kenana dindiha Lusu tano mbira wiagoria anda pene. Lusu tano ogoni mani mini Bedele laga winigo ogoriani pene. ");
INSERT INTO hui_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Ani pu howa dindi ogoriani lomabu delaga dabu mbira Yagabahanda bu helene. Ani bu helowa dindi ogoni Ngode Datagaliwabenaga lalu mini Bedele wini. Ani winidagoni irane Yagaba ibu horo mbirungi ibu hamene Iso gi halu ibida pialu hearia Ngode Datagaliwabe ibuni Yagaba hearia hapani henego mitangi bialu wini. ");
INSERT INTO hui_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Ti dindi ogoniha hemigola Lebeganaga biabe bia haga wali mbira mini Debora berenego ogoningi ibu homene. Homayagola tigua ibunaga tingini Bedele tanonaga abene ni tagira ibiragohayagi ira timbuni mbira mini oga heago teneha hora hene. Ani hora howa tigua ira ogoni mini Dugu Bulene Oga Ira ka, laga hene. ");
INSERT INTO hui_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Yagaba ibu Mesobodemia dindi wahalu Kenana dindiha daibu heagola Ngode Datagaliwabe ibu Yagaba hearia ibuwa ibuhondo lalu, I̱na í̠ biamogo biaabo holebero, lalu lamini. ");
INSERT INTO hui_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Ngode Datagaliwabehanda lalu, Áyu í̠naga mini Yagaba lene kegonigo mani howa tigua í̠naga mini Yagaba nalolebira. Tigua í̠naga mini Isaraele lolebira, lene. Anidagua lalu Ngode Datagaliwabehanda Yagabanaga mini Isaraele lalu wini. ");
INSERT INTO hui_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Anigo Ibugua Yagabahondo lalu, I̱ Ngode Datagaliwabe Hongo Haiheore kogoni í̠ waneiginiru dewaore helo hono wibe. Ani beregola wali agali hameigini dewaorenaga mamalibi maru kini holebirarunaga mamalibi í̠ holebere. ");
INSERT INTO hui_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Dindi ogo i̱na abale Abarahama Aisagala libuhondo minigo áyu í̠hondo ngero. Mani howa í̠naga waneigini aguaneneru bu holebiraruhondo mulebero, lene. ");
INSERT INTO hui_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Ani lowa Ngode Datagaliwabe ibu Yagaba helalu pene. ");
INSERT INTO hui_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Ani peagola Yagaba ibugua ege to̱le̱ luni mbira duguwa Ngode Datagaliwabela bi lalu haribigoria hengene. Ani hongowa ibugua olibe lini ibanemebi waini ibamebi ege to̱le̱ ogoni Ngode Datagaliwabehondo loma bia halu o hangayagoriani odo wini. ");
INSERT INTO hui_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Yagaba ibugua Ngode Datagaliwabela bi lalu haribidagoni dindi mini Bedele wini. ");
INSERT INTO hui_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Ani bu howa Yagababi ibu dameneru ti Bedele wahalu Ebarada pole pialu hene. Harigani pialu heaore dege Leselo ibu gali taba honolene tu hayagola ibu tandaga timbuniore hendene. ");
INSERT INTO hui_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Ani tandaga handalu berearia tidawali ibu biamogo biaga bereagome Leselohondo lalu, Gi halu mogo nalabe. Áyu ogoni í̠ igiri gali mende taba hanarigoni, lene. ");
INSERT INTO hui_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Ani taba honowa nde Leselo ibuni homole howa buhe̱ emeneore wuwa bi mbira hangu lalu igiri biago mini Benoni lene. Mani howa igiri biago abahanda ibu mini Beniyamini lene. ");
INSERT INTO hui_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Leselo homayagola tigua ibunaga tingini Ebarada polene hariga gibuni wiagoria hora hene. Ebarada ogoni mani mini Bedeleheme winigo áyu nga. ");
INSERT INTO hui_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Ani hora howa Yagaba ibugua homali biagoria ege to̱le̱ mbira homali lalu mo walia helonaga duguwa Leselonaga homali biagoriani hengene. Ani hengenego ege to̱le̱ ogoni áyu wiaabo ka. ");
INSERT INTO hui_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Ani hora howa nde Yagaba halu ibu dameneru ti pialu Ede dindini anda bu gimbu bu migi bialu bima iraga hene heago hapara howa dege balai anda bu hene. ");
INSERT INTO hui_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Yagaba ibu dindi ogoniha heangi ibu igini Lubenehanda ibu aba one wali mende mini Biliha bereago kayu yini. Lubene ibugua ogonidagua biya layago Yagaba ibu nde hale howa keba timbuniore hene. Yagaba ibu igini hombearia (12) hene. ");
INSERT INTO hui_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Ibu one Lia igini uru hene. Wahene Lubene halu mende Simiono hene. Tebone Libai halu mane Yuda hene. Dauni Isaga waragane Sebulunu imaru haga bini. ");
INSERT INTO hui_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Ibu one mende Leselo berenego ibu igini kira hangu Yosebe Beniyaminila hene. ");
INSERT INTO hui_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Wali mbira Leselonaga biabe bia haga Biliha berenegome igiri kira Dana Nabadalila taba henene. ");
INSERT INTO hui_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Wali mende Lianaga biabe bia haga Siliba berenegome igiri kira Gada Asela taba henene. Yagaba ibugua Mesobodemia heangi igiri uruni hono wini. ");
INSERT INTO hui_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Yagaba ibugua ibu aba Aisaga berearia Mamere dindi mbira Kiriada Araba tano laga winigo mini mende Heberono laga ogoni kaware wiagoria pene. Bamba Abarahama Aisagala libu dindi ogoniha haga winigo ogoniha berearia hondo pene. ");
INSERT INTO hui_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Aisaga ibunaga mali hama ibinigo bibahende handari mbirani pira halira (180) halu ");
INSERT INTO hui_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","ibu agali waheore biru wialu homene. Ani homayagola ibu igini Iso Yagabala libunime ibu hora hene. ");
INSERT INTO hui_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Iso ibunaga mini mende Idomo henego ogoni ibunaga aguanene ogodagua hama ibini. ");
INSERT INTO hui_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Iso ibu Kenana wali dabu binigo mbirago Hidiali Elono henego wane mini Ada bereago dabu bini. Wali mende agali Ana wane mini Oholibama berenego dabu bini. Ana ogoni ibu Hibiali Sibeono igini hene. ");
INSERT INTO hui_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Wali tebone Isimaele wane mini Basemada ibu Nebaiodo mbalini bereago dabu bini. ");
INSERT INTO hui_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ani dabu bu howa Adahanda igiri Elibasa taba henene. Basemada ibugua nde igiri Luele taba henene. ");
INSERT INTO hui_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oholibama ibugua Yausu Yalama Kora imaru taba henene. Iso ibu Kenana dindiha hearia igiri uruni hono wigi bini. ");
INSERT INTO hui_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Mani howa Iso ibugua ibu hamene Yagaba helalu dindi kaundiaha hama pene. Pialu ibu one waneiginiru bibahendebi wali agali ibu baba haga hearubi ibunaga nogo sibi bulumaga bu hearubi haru hai halu mbirale bibahende Kenana dindiha wu hene wiarubi mo yai halu pene. ");
INSERT INTO hui_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Iso ibugua Yagaba helalu penedagoni irane libunaga nogo tara tara hebigo dindi mbiraore ogoriani hinu hai habe nahe dewaore halu to̱layagola Iso ibu pene. ");
INSERT INTO hui_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Iso ibu pialu Sia dindi barebare wiagoha pu hene. ");
INSERT INTO hui_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Iso ibu Idomo hameigini Sia dindi barebare wiagoha palearunaga mamali hene. Iso ibu igini aguanene ogodagua hene. ");
INSERT INTO hui_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Iso one Ada ibu igini mbira mini Elibasa hene. Wali mende Basemada berenego ibu igini Luele hene. ");
INSERT INTO hui_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Elibasa igini uru mbira Temana mende Oma tebone Sebo mane Gadama dauni Kenasa imaru hene. ");
INSERT INTO hui_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Iso igini Elibasa ibu one mende mini Timina berenego ibugua igiri mbira mini Amalege taba henene. Iso one Ada ibugua taba hanayagome ibu aguane hama penego uruni. ");
INSERT INTO hui_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Iso one mende mini Basemada ibu igini mbira Luele taba henenego ogoni ibu igini maria henego uru Nahadabi Serabi Samabi Misabi uruni hene. Igiri uruni ti Iso one Basemada aguane hene. ");
INSERT INTO hui_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Iso one tebone Oholibama bereago ibu igini tebirali Yausu Yalama Kora imaru hene. Oholibama ogoni ibu Sibeono igini Ana wane berene. ");
INSERT INTO hui_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","16","Iso aguane maru agali haguane haga binigo mini uru. Iso igini wahene Elibasa ibu igini Temanabi Omabi Sebobi Kenasabi Korabi Gadamabi Amalegebi uruni tigua Idomo dindiha agali haguane howa dindi mbira mbira wiagoria haru haga bini. Uruni ti Iso one Ada aguane bu hene. ");
INSERT INTO hui_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Iso igini mende Luele ibu Idomo dindiha igini ogodagua hene. Nahadabi Serabi Samabi Misabi tibi nde agali haguane dege howa Idomo dindi maruha haru hene. Uruni ti Iso one Basemada aguane bu hene. ");
INSERT INTO hui_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Ana wane Oholibama ibu Iso one bereagome ibu igini ogodagua hene. Yausubi Yalamabi Korabi tibi nde Idomo dindiha agali haguane dege howa haru hene. ");
INSERT INTO hui_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Iso iginirume hono winigo ibu aguane uruni hene. Ani howa tininaga hameigini headagua haru haga haga biaga agali haguane hama ibini. ");
INSERT INTO hui_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Sia ibu iginiru ogodagua hene. Sia ibu Hoali howa ibuni Idomo dindiha dege haga hene. Sia ibu igini Lodanabi Sobalabi Sibeonobi Anabi ");
INSERT INTO hui_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Disonobi Esebi Disanabi henego tibi Sia igini agali haguane dege howa Idomo dindiha Hoali hearu haru haga hene. ");
INSERT INTO hui_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lodana ibu Hori Hemanala hameigininaga mamali hene. Lodana ibu mbalini mbira Timina berene. ");
INSERT INTO hui_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Ani bialu Sobala ibu Alabanabi Manahadabi Ebalabi Sebobi Onamabi hameigininaga mamali hene. ");
INSERT INTO hui_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Sibeono ibu igini kira Aia Anala hene. Agali mbira dindi ko wali agali nahaga wiagoha ibu aba Sibeononaga nogo dongi haru hearia iba pobohe mbira duguadaga halu ibiyaria handa walia heneyagoni agali Ana ogoni ibugua hendene. ");
INSERT INTO hui_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","26","Ana ogoni ibu igini Disono ibu wane Oholibamala hene. Ai Oholibama ibu Ana wane berene. Disono ibu Hemedanabi Esebanabi Idiranabi Keranabi hameigini uruninaga mamali hene. ");
INSERT INTO hui_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Ese ibu nde Bilihanabi Sabanabi Aganabi hameigini tebira uruni tinaga mamali hene. ");
INSERT INTO hui_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Disana ibu Usu Aranala hameigini kira ogoninaga mamali hene. ");
INSERT INTO hui_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","30","Hoali hameigini hearume Idomo dindiha agali haguane howa haru haga uru hene. Lodanabi Sobalabi Sibeonobi Anabi Disonobi Esebi Disanabi uruni ti Hoali howa Idomo dindiha agali haguane haga bini. ");
INSERT INTO hui_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Isaraele wali agalinaga kini mbira naheangi Idomo dindiha agali uru ti kini ala hene. ");
INSERT INTO hui_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bero igini Bela ibugua kini howa Dinihaba tano wiagoria haru hene. ");
INSERT INTO hui_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Ani howa Bela homayagola Bosora tanoali Sera igini Yobaba ibu kini ha aribia hene. ");
INSERT INTO hui_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Yobaba homayagola nde Temanali dindi wiagoha agali Husama henego ibu kini ha aribia howa haru hene. ");
INSERT INTO hui_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Ani howa Husama homayagola nde Bedada igini Hadada henego ibu kini ha aribia hene. Hadada ibugua Moaba dindiha puwa Midianali hearu baba wai bialu ti bo poda hana hene. Hadada ibu kini howa Abidi tanoha hene. ");
INSERT INTO hui_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadada halu homayagola Masarega tanoali mbira Samala henego ibu kini ha aribia hene. ");
INSERT INTO hui_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samala halu homayagola iba Yuberedisi pedago kawareha Lehobodo tanoali Saulu mbira henego ibugua kini ha aribia hene. ");
INSERT INTO hui_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Saulu halu homayagola Agabo igini Balahanana mbira henego ibu kini ha aribia hene. ");
INSERT INTO hui_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Ani halu Balahanana homayagola Hadada mbira henego ibu kini ha aribia howa Pau tano wiagoria haru hene. Hadada ibu one Maderede wane Mesahaba aguane Mehedabele berene. ");
INSERT INTO hui_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","Iso ibu Idomoali haga binidarunaga mamali henego ti mini uru. Timina Alaba Yadede Oholibama Ela Pinono Kenasa Temana Mibisa Magadiele Irama imaru hene. Agali uruni ti Idomo dindiha hameigini mbira mbiranaga agali haguane haga bini. Idomo ogoni Isonaga mini mende winigo nde ibu agali haguane uruninaga mamali hene. Agali haguane uruni mbira mbira headagua tinaga dindi wigiwigi bialu tini hameigini headagua haru haga agali haguane haga bini. ");
INSERT INTO hui_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yagaba ibu Kenana dindi ala ibu aba Aisaga hene wiagoria hene. ");
INSERT INTO hui_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Yagababi ibu iginirubi ti bialu henegonaga bi te ogo. Yosebe ibu igiri hagua dehe mali pira mbirani karia (17) hayagola ibu aba one Bili Silibalanaga igini ibu hamene biaru baba nogo sibi memeru haru haga hene. Ani haru howa ibu hamenerume ko mbira birago hondowa abale puwa ibu abahondo lamiaga hene. ");
INSERT INTO hui_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Yagaba ibu mini mende Isaraele ibugua wahe howa ibu igini Yosebe hono winigonaga igini maru gubalini emene nira lowa Yosebe gubalini timbuni haga hene. Ani bu howa ibugua aga bayale dagarenaga gi lu biagimbu biaga mbira wabuwa ibu igini Yosebe mini. ");
INSERT INTO hui_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Yagaba igini maru hearume handalu hearia ti abahanda Yosebe gubalini timbuni halu ti emene mangaho heago hondowa tigua Yosebehondo keba timbuniore howa ibuhondo bi bayale nalaga hene. ");
INSERT INTO hui_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Mbiraga mbirungi Yosebe ibugua emaga mbira handayago ibu hameneru lamini. Lamiyagola tigua hale howa keba timbuni hene. ");
INSERT INTO hui_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Yosebehanda ti lamialu lalu, I̱na emaga mbira handarugo loliya hale hadaba. ");
INSERT INTO hui_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Ina bibahende mabuha hai howa widiore kabu bigibigi bialu hemaria ai kabuni i̱naga biago ibu tigabi heyu heagola tínaga biaru bibahendeoreme i̱naga heyu heagoha ho mabu buwa bulu paliai hearia handaru, lene. ");
INSERT INTO hui_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Ani layagola ibu hamene biarume lalu, Ai í̠ inanaga handame haga kini haregola ina bibahende í̠na haru holebedabe, lowa ti bibahendeme handabe manga hai hene. ");
INSERT INTO hui_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Yosebehanda ibu hameneruhondo emaga halu mende hondowa tihondo lamialu lalu, I̱na emaga handalu hewaria nibi egebi yakundi beriarubi bibahende i̱naga wanakuihayagi ibuwa ma podalu bulu paliai hayaria handaru, lalu lamini. ");
INSERT INTO hui_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Emaga ogoni handayago ibugua ibu ababi lamini. Lamiyagola ibu abahanda lalu, Ogoni agile emagadabe. Í̠na manda beregola i̱bi í̠ ai̱yabi í̠ hamene karubi ina bibahende í̠ kegoria ibuwa í̠naga wanakuihayagi ma podalu ge duli hanga holeberamadabe, lene. ");
INSERT INTO hui_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Ibu hamene biarume keba timbuniore ho heagola ibu aba ibunime emaga ogoni agoale handayadabe lowa mitangi tangi bialu berene. ");
INSERT INTO hui_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Horo mbirungi Yosebe hamene biaru ti Segeme dindi wiagoria ti abanaga nogo sibi haru hole pene. ");
INSERT INTO hui_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Ti ani peagola Yagaba ibugua Yosebehondo lalu, Í̠ hameneru Segeme dindini nogo sibi haru kago hondo pu, lene. Ani layagola Yosebe ibugua ladai bialu lalu, I̱na hondo porogo, lene. ");
INSERT INTO hui_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Ani layagola ibu abahanda lalu, Áyu í̠na puwa í̠ hameneru tibi nogo sibirubi agua kabe handabe. Handalu ti agua hea lalu abale langule dai bibe, lene. Ogoningi Isaraele hameigini ti Heberonoha dindi ulini wiagoria hene. Yosebe ibu abale Segeme dindi wiagoria anda pialu ");
INSERT INTO hui_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","abale ibaga bialu hearia agali mbirame hondowa lalu, Í̠ agile tai berebe, lene. ");
INSERT INTO hui_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Ani layagola Yosebe ibugua lalu, I̱ hameneru tai berogo í̠na ti mbirani nogo sibi haru hearia handaribe, lene. ");
INSERT INTO hui_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Ani layagola agali biagome ladai bialu lalu, Ti oali nahe Dodana dindi piya, lene. Ani laya handala Yosebe ibu hameneru piyiyadagua abale pialu Dodana dindi anda puwa ti handa walia hene. ");
INSERT INTO hui_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Yosebe ibu kaundia ibalu heago de hondowa ibu hamene biarume Yosebe homelo bo wahami̱ya lowa lo manda bialu berene. ");
INSERT INTO hui_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Tini degedege ladene bialu lalu, Handa naberego emaga handaga biago amu ibiragoni. ");
INSERT INTO hui_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Ai homelo bowa ibunaga tingini iba biraga uli nai ngaruniha bape hami̱ya. Iname ibu nogo gabuame bo nayiya lami̱ya. Ani beramagola ibugua emaga handaraligo agua birabe handami̱ya, lene. ");
INSERT INTO hui_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Tigua ogonidagua larimigo hale howa Lubene ibugua Yosebe bo waholene hame nale howa lalu, Ibu homelo nabami̱ya. ");
INSERT INTO hui_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Inanenaga giha howa homelo bolene nakarulapego. Ibu dindi wali agali nahaga ogoha iba biraga uli yobi o ngagoha minu bape hami̱ya, lene. Ani lenedagoni tene ibugua Yosebe ibu aba karia haru dai bule manda buwa lene. ");
INSERT INTO hui_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Yosebe ti bereagoria ibiyagola tigua abaleore minuwa ibunaga aga ibu abahanda mini baya biagimbu biaga biago minu golene. ");
INSERT INTO hui_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Golo ngelalu Yosebe minu yalu puwa iba biraga uli mbira iba nabere yobi wiagoha bape hene. ");
INSERT INTO hui_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Ani bialu ti daibu biruwa tomo nalu beramiore dege Isimale hameigini maru Gileada dindi howa tinaga nogo kameleni dabudabu bayaleore ira lini ibaneme wabini marasinirubi weli ngabiorebi muni dewaoreme yolo biagago uruni Iyibi dindiha muni tagu pole ibiyaria hendene. ");
INSERT INTO hui_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Ani ibiyagola Yudahanda ibu hameneruhondo lalu, I̱na hamene inaneme ogoha bo do holene nakarulapedago ");
INSERT INTO hui_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","ibu wali agalinaga biabe bia haga helo muni miagadagua áyu agali urunime muni ngi lowa Yosebe muni taguimi̱ya. Ina hamene darama mbiraorego nde inaneme bo waholene nakarulapedago, layagola ti bibahendeme ogoni karulapego ani bimi̱ya lowa berene. ");
INSERT INTO hui_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Igiri biaru ti bi ogoni lalu berearia agali Midiana howa maru nde tinaga dabudabu maru muni tagu pole harigani pialu howa handalu hearia Yosebe uliha berearia hondowa dugu yamini. Ani biyagola Yosebe hamene biaru tigua Isimale aria biaruha muni taguini. Isimale aria biarume muni kuni siliba pira kira (20) Yosebe hamenehondo mialu Yosebe Iyibi dindi haru pene. ");
INSERT INTO hui_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Mani Lubene ibu iba uli biagoha Yosebe berelayago hondo dai bialu hearia Yosebe nabereyane hondowa ibu dara timbuniore howa ibuninaga aga lerelene. ");
INSERT INTO hui_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Ani bialu ibu hameneru hearia dai buwa lalu, Yosebe iba uli biagoha nabereyago. Aiore agua buabe, lene. ");
INSERT INTO hui_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Ani layagola tigua nogo meme mbira bowa Yosebenaga aga biagoria darama wai hene. ");
INSERT INTO hui_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Ani bialu tigua aga darama bagabi biago ti aba berearia yalu dai buwa lalu, Aga ogo namugoha winiyago ogoni í̠ igininaga mbauledago de handa bia, lene. ");
INSERT INTO hui_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Ani layagola ti abahanda aga biago hondowa lalu, Ogoni i̱ igini Yosebenaga agaoredago. Ai ibu nogo gabua mbirame balu naore biyadagoni, lene. ");
INSERT INTO hui_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Ani lowa Yagabahanda ibu iginiore dara timbuniore halu ibunaga aga lerelalu dara howa aga biagane ale bu berene. Horo dewaore ibu igininaga dara howa dugu bialu biraabo hene. ");
INSERT INTO hui_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Ani bialu bereagola ibu waneigini maru hearume ti abanaga bu mini mo palia hole lowa bi layagolabi nahondoleore biruwa lalu, I̱na dugu bialu kone dege i̱nibi homalu homene dindiha puwa ibuni iya haru lola halu waholebero, lene. Ani lowa Yagaba ibu dugu dege bialu bira ho wiaabo hene. ");
INSERT INTO hui_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Midianali biaru tigua Yosebe Iyibi dindiha haru halu puwa muni taguini. Iyibi dindi kini kagonaga wai biaga ami agali karu haru haga mbira ibu mini Podiba hene. Podiba ogoni ibunaga biabe bia haga Yosebe helo Midianali biaru ti muni mialu Yosebe ibu andaga haru pene. ");
INSERT INTO hui_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Horo uruningi Yuda ibugua ibu hameneru helo wahalu Adulama tanoha agali mbira mini Hira henego ibula hama pene. ");
INSERT INTO hui_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Ani pu howa Kenanali mbira mini Sua heago wane mbira berearia hendene. Ani hondowa ibugua wandari ogoni ibu dabu bialu libu dindi ogoniha hene. ");
INSERT INTO hui_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Mani wali o biagome igiri mbira taba hono bereagola Yuda ibugua igiri gali ogoni mini Ere wini. ");
INSERT INTO hui_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Emene howa nde wali biagome igiri mende taba hanayagola ibu mini Onana wini. ");
INSERT INTO hui_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Wali biagome igiri tebonebi taba hanayagola ibu mini Sela wini. Yuda ibu Kesibi dindi wiagoria heangi walime igiri Sela ogoni taba henene. ");
INSERT INTO hui_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Maniore howa igiri uruni andaho hai heagola Yudahanda ibu igini wahene Erenaga wali mbira mini Tama bereago dabu bia hene. ");
INSERT INTO hui_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Ere ibugua Anduane Homogonaga deni howa mana ko bialu hearia Anduane Homogohanda ibu bo wahene. ");
INSERT INTO hui_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Ani homaya handala Yudahanda ibu igini mende Onanahondo lamialu lalu, Inanaga mana ngamagome í̠ hamene waneigini mbira nahonowi kaore ibu one dalo berelalu homayagua nde hamene mende kago ibula bira aribia holene nga. Ani biruwa ibu hamene homayagonaga waneigini ibuni henegoria ha aribia helonaga hamene kagome hono wia holene nga lo wini ngago ai wali dalo Tama bedago í̠la biralibu, lene. Ani biruwa ibugua waneigini í̠ hamene homayagonaga hono wia helo, lene. ");
INSERT INTO hui_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Ani layagola Onana ibugua waneigini ibuninaga helo ndoyagola ibu anidagua bulene turu nahe hene. Ani howa ibugua wali dalo ogonila mandagi padabira ibu hamenenaga waneigini holilono Onana ibu ohaga hene. ");
INSERT INTO hui_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Onana ibugua anidagua bialu henedagoni Anduane Homogonaga deni howa mana ko wiago biyagola Anduane Homogohanda Onanahondo keba halu Onanabi bo wahene. ");
INSERT INTO hui_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Ani biyagola mani Yuda ibugua ibu aruni Tamahondo lamialu lalu, Ainde í̠ agalini homayagonidago mani i̱ igini Sela anda halu wali dabu bibehe kagola ogonila dabu bilibulo áyu ibu anda helo tagi í̠ aba andagaha birule pu, lene. Yuda ibugua bi o layadagoni henene ndo ohowa ibu igini kirali biagolabo homayadagua Selabi homolilono ani lene. Ani pu laya handala Tama ibu nde ibu aba andaga pu berene. ");
INSERT INTO hui_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Luore ho wahowa Yuda one Sua wane biago homene. Ani homayagola hora howa duguandaru hai halu horo mbirungi agali marume Timina dindi wiagoria ibunaga nogo sibi irini podalu heagola ogoni handama Yuda ibu pole pene. Pialu ibu nenege Adulama tanoali Hira libu haru mandagi pene. ");
INSERT INTO hui_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Ani pole pialu heagola agali mbirame Tamahondo lalu, Í̠ aruni biago Timina dindiha ibunaga nogo sibi irini podole ibira, lalu lamini. ");
INSERT INTO hui_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Tama ibugua lo mitangi bialu ai Sela wahe karulape kagoyu libu dabu bulene mo tiga nabi hearia hendene. Ani hondowa ibugua dalo nu hono bereago dugu ngelene. Ngelowa aga bu aribia halu aga emene mbirame ibunaga dengui buyi halu Enaimi dindi mbira Timina dindi polene hariga kaware wiagoria handatagiho berene. ");
INSERT INTO hui_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Ani berearia Yuda ibu ibuwa handalu hearia wali biago ibu labolabo emene mbirame dengui buyiho bereago hondowa wali ogoni bayanda wali bedabe toba hene. ");
INSERT INTO hui_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Ani hondowa Yuda ibugua wali hariga gibuni wiagoria bereago ibu aruni biago bereago nahende wali tara bedabe toba howa ibugua wali biagohondo lalu, Iya kayu bibiya hameledogo kayu biba, lene. Ani layagola wali biagome ibuhondo lalu, Ani bibiya dege í̠na i̱ agile nguleberebe, lene. ");
INSERT INTO hui_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Ani layagola Yudahanda lalu, I̱ nogo meme bu kogo igini mbirago í̠naga ibilolebero, lene. Ani layagola wali biago ibugua lalu, Ogoni bayale larigo í̠na bi laregoni heneneore buleyagua walia halu áyu mbirale mbira i̱ giha yu biruliya ngerene. Mani nogo meme igini ogoni haru eberegola í̠ni ngiadai buliya ngi, lene. ");
INSERT INTO hui_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Ani layagola Yuda ibugua hale halu lalu, Bi larogoni henene bulebero lalu mbira agile nguliya hameledebe, lene. Ani hale hayagola wali biago ibugua lalu, Mbirale í̠naga magibi ogoni hende howa pu mani ngegobi ngialu í̠naga halimbu yidegonibi ngi, lene. Ani layagola mbirale ngi layaruni mialu Yuda ibu wali biagola palene. Ani biyagola wali biago mani ibu gali bere berene. ");
INSERT INTO hui_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Tama ibu andaga dai buwa aga emene ibunaga dengui buyi hayago golo ngelalu ibu agalini homene dara howa dalo nu hanaga dugu wini biago lone hono berene. ");
INSERT INTO hui_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Mani howa Yuda ibugua Hirahondo lalu, Nogo meme igini mbira haru halu puwa wali biago mialu i̱naga mbirale wali biagome mo yu birayago yu dai bule pu, laya handala Hira ibu pene. Pialu hearia wali biago handa walia nahe taya bu wahene. ");
INSERT INTO hui_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Ani taya bu wahowa Hira ibugua agali maru dindi ogoniha haga hearuhondo lalu, Bayanda wali mbira Enaimi harigani biragayago agoha bedabe, lene. Ani layagola tigua ladai bialu lalu, Bayanda wali mbira ogoha nabiraga, lene. ");
INSERT INTO hui_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Ani laya handala Hira ibu Yuda hearia dai buwa lalu, Wali biagoni nabere tayabu waharu. Agali dindi ogoniha haga hearumebi bayanda wali mbira dindi ogoniha nabiraga laya, lene. ");
INSERT INTO hui_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Ani layagola Yudahanda lalu, Wahalu taya nabi mbirale uruni wali ogoni ibu yu berelo waha. I̱naga bi larugo la hondo naholenaga nogo meme ogoni haru pu larugo ai wali agali bu karume iya hondo oba holigo nde í̠na ibu handa walia naharidago wahalu waha, lene. ");
INSERT INTO hui_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Ani lalu ege tebira agima peagola maru hearume Yudahondo lamialu lalu, Í̠ aruni Tama ibugua agali kayu bialu bereneyago ai áyu ibu gali bere beda, lalu lamini. Anidagua lamiyago hale howa Yudahanda hongo howa lalu, Wali ogoni balu irani delole pudaba, lene. ");
INSERT INTO hui_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Ani layagola tigua Tama irani bo delole haru pialu hearia Tama ibugua Yudanaga mbirale biaruni yalu pudaba lalu bi ogodagua lawia hene. I̱ mbirale uruni ngiaga agali kagonaga gali bere bedogo ai mbira ibuninaga magibi ogoninaga pu hende howa mani wiagabi halimbu ogonibi ainagadabe dabo handabe, lalu wia hene. ");
INSERT INTO hui_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Ani layiyago hale howa Yuda ibugua mbirale biaruni hondowa lalu, Mana ko ogoni wali ogonime bini ndo i̱na birudagoni. Ani birudago ainde wali ogoni i̱ igini Sela ibu dabu bilonaga mo tiga nabi dege harudago ai dabu bilo, lene. Ani lalu Yuda ibu wali ogonila mani lone napale wahene. ");
INSERT INTO hui_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Tama ibu gali taba honolene tu bereagola handalu hearia ibu tombeha gali labo laboli bereyane hendene. ");
INSERT INTO hui_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Anigo ibugua gali taba honole biyagola mbira gi ala pani hayagonaga tidawali Tama biamogo bialu bereagome pu daramabi mbira gini pongo bia hene. Ani pongobia howa ibugua lalu, Gali ogoni ibu ala pani haya, lene. ");
INSERT INTO hui_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Ani lo berearia gini pu helayago yamialu dai biyagola ibu hamene mendego ala taba henene. Ani biyagola wali biago ibugua lalu, Í̠ mani taba honolene winigo ai í̠ni hongome í̠ ala ibirida, lene. Ani lowa ibu mini Perese wini. ");
INSERT INTO hui_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Mani ibu hamene pu daramabi gini pongo bia hayago taba henene. Taba hanayagola ibu mini Sera wini. ");
INSERT INTO hui_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Isimaleali biaru tigua Yosebe Iyibi dindini haru pu heleagola Podibahanda agali biaru muni mialu Yosebe haru pene. Podiba ogoni ibu kini mamage haga ami agali hearunaga hondo haga haguane howa ibuni Iyibiali dindi tene hene. ");
INSERT INTO hui_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Anduane Homogohanda Yosebe baya hangu handaya ho heagola ibugua Podiba andagani howa biyago bibahende bayale hangu hai hene. ");
INSERT INTO hui_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Podibahanda handalu hearia Yosebe ibuha Anduane Homogo ibula haru howa ibugua biyago bibahende bayale dege hayago hendene. ");
INSERT INTO hui_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Ani biyago hondowa ibugua Yosebehondo lalu, I̱ andagaha bibahende ngoruni handameho habe, lene. ");
INSERT INTO hui_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Ogonidagua biyagola Podiba ibu andagaha wiaru bibahende bayale hai hene. Anduane Homogohanda Yosebe handaya ho heagola ani bini. Ibunaga mabu andabi maruale wiarubi ani dege bini. ");
INSERT INTO hui_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Aniore biyagola Podiba ibunaga mbirale wiaruni Yosebenaga giha ya hai halu ibu tomo nolenego hangu mitangi biaga hene. Yosebe ibunibi nde baya henene baya mbira halu hongo pururuleore heneya. ");
INSERT INTO hui_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Ani heagola Podiba one ibu Yosebe dimagoli ho biruwa lalu, Iya palibiya íbu, lene. ");
INSERT INTO hui_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Ani layagola Yosebehanda ladai bialu lalu, I̱naga agali haguane ibugua ibu andagaha ngaru bibahende i̱na hondo holiya ngiai hayago tene i̱ha ko mbira bulubada manda nabi howa ani biyagoni. ");
INSERT INTO hui_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Áyu ibunaga mbirale ngaru bibahende ibuni handaya ho holenedagua i̱na kogoni. Ibugua i̱hondo ogo bibe nabibe lalubi mbira nale. Bibahende i̱na hondo hai kogoni. Ai í̠ dege ibuni hangu one bedego. Ibugua i̱hondo í̠la palilibu lalu mbira nalego. Ngode Datagaliwabenaga deni howa i̱na mana ko ngubi ogoni bulene nawiore, lene. ");
INSERT INTO hui_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Horo bibahendengi howa wali ogoni ibugua Yosebehondo kayu yaba lalu laho wiyagola Yosebe ibu walila mandagi napale ohalu haabo hene. ");
INSERT INTO hui_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Horo mbirungi Yosebe ibu andaga tamuha biabe mbira bulene wiyagola anda pene. Ogoningi agali biabe biaga mbira nahe ibuni hangu hene. ");
INSERT INTO hui_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Yosebe ibu tamuha anda pu heagola Podiba one biagome aga biagoria minu yani howa lalu, Ai palibiya íbuore bia, lene. Ani lalu hea handala Yosebe ibunaga aga biago wali ogoninaga giha golo ya helalu ibuni ibida tagira pene. ");
INSERT INTO hui_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Wali biagome handalu hearia Yosebenaga aga yu wahalu tagira piyagola ");
INSERT INTO hui_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","ibugua agali biabe bia haga maru hearu olowa lalu, Uru-o ai handadaba. I̱ agalini ibugua Hiburuali haru ibiyagome i̱na mo taga hole o bialu hayadago handadaba. Ibugua i̱ tamu paliagaha anda ibuwa mandagi paliba layagola i̱na hongo howa koaba larugoni. ");
INSERT INTO hui_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","I̱na hongo howa koaba larugola ibunaga aga i̱ tamuni wia handala gerai lalu ibida piya, lene. ");
INSERT INTO hui_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Ani lowa ibugua Yosebenaga aga biago ibu agalini andaga ibiragola walia hole lalu yu biraabo hene. ");
INSERT INTO hui_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Ibu agalini andaga ibiyagola bi ala layadagua dege lone lalu, Hiburu igiri biabe bia haga í̠na haru ibirigonime i̱ tamuha anda ibuwa i̱ minulebiya. ");
INSERT INTO hui_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Ani biyagola i̱na hongo howa koaba laru handala ibunaga aga i̱ tamuha ibira halu gerai ibida piya, lene. ");
INSERT INTO hui_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Yosebenaga agali haguane biagome bi uruni layago hale howa ibu keba gibiore hene. ");
INSERT INTO hui_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Ani howa ibugua ami agali hearuhondo lalu, Yosebe minu yalu puwa kininaga garabaya anda wiagoha garabaya helo heladaba, layagola tigua haru puwa helene. ");
INSERT INTO hui_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Anigo Anduane Homogo ibu Yosebela haabo howa Yosebehanda biyago mo bayale haga bialu hene. Ani bialu Anduane Homogohanda agali garabaya haru haga heagome Yosebe mitangi bialu hame lelo biamogo bigi bialu hene. ");
INSERT INTO hui_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Agali ogoni ibugua Yosebehanda garabaya hearu bibahende handameho helo dabo helene. Ani biyagola Yosebehanda garabaya andaha biabe bulene wiaru bibahende ibugua dege hondo hai helene. ");
INSERT INTO hui_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Anduane Homogohanda Yosebe bayuwaore haru heagome biabe ibugua biyaruni aria mbira lone agali haguane biago ibuni handa dai bibe nahe hene. ");
INSERT INTO hui_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Yosebe ibu lu dege heagola kininaga waini iba hambu miaga heneyagobi kininaga mberedi anda hondo haga heneyagobi libugua mana kinihanda hame naleadagua mbira biribiya. ");
INSERT INTO hui_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Iyibi dindi kini heagome keba timbuniore howa ");
INSERT INTO hui_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","agali kirali biago labo garabaya haru haga haguane mbira andagaha Yosebe garabaya hayagoha dege helene. ");
INSERT INTO hui_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Garabaya haru haga haguane biagome agali kirali ogoni labobi Yosebehanda haruha dege bibe layagola libu garabaya andaha luore hene. ");
INSERT INTO hui_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Horo mbirungi agali kininaga waini iba hambu miaga biagobi kininaga mberedi anda hondo haga biagobi libu harume emaga mbira hendene. Libunaga emaga ogoni labo mbiraore ale ndo tara tara handaribiya. ");
INSERT INTO hui_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Egerebagi Yosebe ibu hondo ibalu hearia libugua genda timbuniore ho bereria hendene. ");
INSERT INTO hui_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Ani hondowa Yosebehanda libuhondo hale halu lalu, Libu handalu koria genda yu berene mbauledago agua biyabe, lene. ");
INSERT INTO hui_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Ani layagola libugua Yosebehondo ladai bialu lalu, Iyame emaga mbira hendenego. Ai mbiralime irane ogoaleda lalu langulene nahedagola mini burugulo bedabagoni, lene. Ani layago hale howa Yosebehanda libuhondo ogodagua lamini. Ngode Datagaliwabehanda hangu agalime manda nabibehe ngaru manda biaihe kago. Ai libugua emaga handaribidago langidaba, lene. ");
INSERT INTO hui_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Ani layagola kininaga waini iba hambu miaga biago ibugua ogodagua lene. I̱na pu lini daga mini gerebi mbira hearia handaru. ");
INSERT INTO hui_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Pu ogoninaga magane tebira hea. Ai abaleore yuni anda halu pabua baya. Pabua balu lini abale do girigere laya. Ani dowa abale ibiri ndigi ndugu laya. ");
INSERT INTO hui_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Ai i̱na Iyibi kini kagonaga gabo be yu howa lini deago daga bialu ibane gabo be yarugoniha pingido baanda howa kini ibuni nelo migi bialu haruya, lene. ");
INSERT INTO hui_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Ani layagola Yosebehanda lalu, Ira magane tebira handarigo ogoni horo tebira ale. ");
INSERT INTO hui_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Horo tebira howa kinihanda í̠ haru dai buwa í̠ninaga biabe biaga wiyadagoha bialu helolebira. Ani biragola í̠ni abale biagadagua kininaga waini iba hambu mialu holebere. ");
INSERT INTO hui_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Ani hambu mialu howa i̱ mitangi bialu dara habe. Luore garabaya ogoha haho wirugo. Ai nde i̱ golope halu tagira pu lelo kiniore lamia habe. ");
INSERT INTO hui_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Bambaore i̱ Hiburu dindiha hewaria i̱ hamenerume agali tara ndelo miyagola minu yalu ibinigo. Ai oali Iyibi dindini kagua mbira nabi hewaria tigua bameore ogoha garabaya helenego kogoni, lene. ");
INSERT INTO hui_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Agali mende kininaga mberedi anda hondo haga biago ibugua agali kininaga waini iba hambu miaga biagonaga emaga handayago baya hangu latagi hayago hondowa ibunagabi nde Yosebe ogodagua lamini. I̱bi nde emaga handalu hewaria mbasigedi nu tebira mberedi hono to̱lego haguani yaruya. ");
INSERT INTO hui_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Mbasigedi nu daligaore yarudagoha mberedi mbisigedibi kini ibuore gubalini haga ale dege yiwaria egame ibuwa nalu hearia handaru, lene. ");
INSERT INTO hui_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Ani layagola Yosebehanda lalu, Emaga ogoni irane ogodagua. Mbasigedi tebira ogoni irane horo tebira. ");
INSERT INTO hui_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Horo tebira ogoni howa kinihanda í̠ garabaya golalu haru tagira polebira. Ani puwa ibunaga ami agali karume í̠naga ma puguadaba lolebira. Ani lowa í̠naga tingini ira mbira wa howa ogoriani mo pagaho ngeledagola egarume buduyu togolowa nalu holebira, lene. ");
INSERT INTO hui_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Horo tebira layago hai howa kini taba henenego horo mitangi bialu ibunaga biabe biaga agali haguane hearunaga tomo timbuni dawene. Ani buwa agali kirali biago labo haru ibuwa agali haguane biarunaga deni íbu helene. ");
INSERT INTO hui_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Ani íbu heagola kini ibugua lalu, Waini iba hambu miaga biago ibu biabe ala biagadagoha bule pelo, lene. ");
INSERT INTO hui_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Ani lowa kinihanda lalu, Agali mberedi anda hondo haga biago irani bo derela hole pudaba, lene. O biyadaruni Yosebehanda ogonidaguaore bulebira lalu libugua emaga handaribingi layago lola hene. ");
INSERT INTO hui_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Agali kininaga waini iba hambu miaga biago ibugua Yosebehanda kini lamibe layago embedaho waore hene. ");
INSERT INTO hui_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Mali kira piyagola Iyibinaga kini ibugua emaga mbira hendene. Ibuni iba Naili angeni howa handalu hearia ");
INSERT INTO hui_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","nogo bulumaga kariaore bayale habanehe timbuni dege degeru ibaha howa tagira ibalu iba angeni tani bayale heago nalu hearia hendene. ");
INSERT INTO hui_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Ani hondowa handalu hearia nogo bulumaga karia mende tingini ko hongo nahe kuni hanguhe ibaha howa tagira ibiyaria hendene. ");
INSERT INTO hui_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Nogo ko urunime nogo bayale karia ala íbu hayaru bo hengeda howa nai hayaria hendene. Ani hondowa dege kini ibuni dengala halu heyini. ");
INSERT INTO hui_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Lone palia dai buwa kini ibugua emaga halu mende handalu hearia ladi ale mini widi irane mbira hangume lini karia dearia hendene. Widi o dayadaruni timbuni bayale dowa nolene dewa pale dearia hendene. ");
INSERT INTO hui_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Mani widi iraneni lini karia mende dearia hendene. Ogoni bayale ndo dindi ko ni daho wiaga wiagoha howa puyabu poboyogobi ibiyagome do yogobu wahene howa lini deago emene ko habane napale hadogoe ale de hendene. ");
INSERT INTO hui_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Widi lini ko girali de biarume widi bayale ala dayaru bo nalu mbedogo biai hayaria hendene. Kini ibu heyuwa emaga handaruyane hendene. ");
INSERT INTO hui_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Ani hondowa kini ibugua mini burugulo biruwa agali mandabi dewa hearubi agali mini bogabi mbirale wiado kago handa walia haga hearubi bibahende olo ngoai hene. Ibai hayagola ibunaga emaga handayago lamiyagola mbiralime ogoni irane ogo aleda lalu lamibe nahe hene. ");
INSERT INTO hui_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Ani biyagola mani agali kininaga waini iba hambu miaga biagome kinihondo lalu, Áyuore mana tiga nabi mbira bu harudago latagi haro. ");
INSERT INTO hui_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Ala halu mbiru kini í̠na agali í̠naga mberedi anda handaya ho haga biago iya í̠naga garabaya haru haga haguane í̠ni mamage haga biago andagaha garabaya helarigoni. ");
INSERT INTO hui_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Ani birigola garabaya andaha howa iya harume emaga mbira hendenego ogoni kirabali galone tagira piya. ");
INSERT INTO hui_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Hiburu igiri mbira í̠naga garabaya haru haga haguane kago ibunaga biabe bia haga heneyago ina haru mandagi garabaya henego ogoni hondo lamiriba. ");
INSERT INTO hui_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Ani lamiribagola ibugua langiyago henene layadaguaore biai hayagoni. I̱ biabe bialu haga wirugoria bule dai bialu agali mberedi anda handaya ho haga biago tigua bo derela harimigoni, lene. ");
INSERT INTO hui_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Iyibi dindi kini biagome bi ogonidagua layago hale howa Yosebe garabaya andaha hearia hondo pudaba layagola tigua abale garabaya andaha Yosebe hearia puwa lamini. Ani lamiyagola Yosebe ibu angari mialu aga bayale karula bigi biyagola agali ibiyaru tigua kini andaga abale haru pene. ");
INSERT INTO hui_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Haru piyagola kini ibugua Yosebehondo lalu, I̱na emaga mbira hendenego agali bu hearume ogoaleda lalu mbira nalangiyagola howa agali marume lalu, Í̠na emaga hendenego ogoaleda lalu bulebiragoore tiga tiga latagi harili laya, lene. ");
INSERT INTO hui_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Ani layagola Yosebehanda kini biagohondo lalu, I̱nime latagi habe nahe kogo. Ngode Datagaliwabehanda emaga ogoni irane ogoaleda lalu latagi haragola í̠na hale howa turu holebere, lene. ");
INSERT INTO hui_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Ani layagola kinihanda lalu, Ai i̱na emagaha iba Naili angeni pu haruya. ");
INSERT INTO hui_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Ogoriani howa handalu hewaria nogo bulumaga timbuni hongoheni habanehe dege dege karia ibaha howa tagira ibuwa iba angeni tani nalu hearia handaru. ");
INSERT INTO hui_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Mani nogo bulumaga karia ko tingini hongo nahe kuni hanguhe kooreru Iyibi dindini nogo urunibi mbira hearia handa nabinigo ibaha howa tagira ibiyaria handaru. ");
INSERT INTO hui_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Ani bialu nogo ko urunime nogo bayale ala hayaru bo nai haya. ");
INSERT INTO hui_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Tigua nogo bayale biaru bo nai hearia tinaga tingini nogo biaru bo nene mbaule bayale ndo koore dege hearia handaru. Ogoni handalu dengala haru. ");
INSERT INTO hui_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Mani palia dai bialu hewaria emaga halu mende handaru. Ogoni i̱na ogodagua handaru. Widi irane mbirani lini karia dearia handaru. Ogoriani widi bayaleore dowa nolene dewa palu to̱laiheni do nole tu dearia handaru. ");
INSERT INTO hui_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Ogoni hondo hewaria dege widi mende bayale ndo dindi ko ni dege daho wiaga wiagohayagi howa puyabu poboyogobi ibiyagome do yogobu wahene howa lini habane napale hadogoe ale dearu handaru. ");
INSERT INTO hui_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Ai widi ko yogobi habane napale dayadagonime widi bayale lini timbuni de heago bo nalu mbedogo biai hayaria handaru. Ani hondowa agali mandabi dewa hearubi agali maru mini bogabi mbirale marume handabe nahe ngaru handa walia haga hearubi bibahende íbu ngoai hadaba lowa tihondo lamialu hewaria mbiralime ogoaleda lalu handa walia nahaya, lene. ");
INSERT INTO hui_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Ani lai hayagola Yosebehanda Iyibi dindi kinihondo lalu, Emaga ogoni kirabali galone mbiraore hangunaga. Ngode Datagaliwabehanda mbirale mani bule ngagonaga mo walia hayadago. ");
INSERT INTO hui_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Nogo bulumaga karia handaridagobi widi lini karia handaridagobi uruni mali karia ale. Uruni manane mbiraore ale dege walia haya. ");
INSERT INTO hui_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Ani bialu nogo bulumaga karia ko ibiyadarubi widi ko habane napale puyabu poboyogobime do yongo bini dayadarubi uruni bibahende mali kariani hina gari timbuni polebiragonaga walia haya. ");
INSERT INTO hui_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Uruni mani ogodagua bulebira lalu Ngode Datagaliwabehanda í̠ni walia hayada lalu langerogoni. ");
INSERT INTO hui_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Ai mali kariani Iyibi dindi bibahende tomo timbuni bu payabu wulebira. ");
INSERT INTO hui_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Ani buwa mani mali karia mendeni hina gari timbuniore polebira. Ogoningi Iyibi wali agalime tomo dewa payabu wiyaruni mitangi bu dai bibe nahe mo ko howa homolebira. ");
INSERT INTO hui_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Iyibi wali agalime mali dewani tomo bayale dewa bu payabu nalu hayaru mitangi bu dai bibe naheore mo ko holebira. ");
INSERT INTO hui_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Ai áyu ogoni mani Ngode Datagaliwabehanda ogodagua bulebero lalu í̠ manda bibelonaga emaga kira ogoniha howa walia hayago. Áyu í̠na nde gibi ogoni mani tagira ibulubada lowa mandaore buwa holene nga. ");
INSERT INTO hui_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Ai áyu í̠na agali manda timbunibi howa bogabi mbira Iyibi dindi bibahendeni biabe bialu helo dabo helolene nga. ");
INSERT INTO hui_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Ani helowa agali marubi dabo helolene nga. Agali uruni tigua mali kariani tomo bayale anda haragoha tomo uruni dau halu tale buwa daunigo gabumanehondo dagisi mulene nga. ");
INSERT INTO hui_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Tomo dagisi mini uruni agali dabo helene biaru tigua mo ngoai halu tano mbira mbirani tomo mo ngoaiho wulene anda buwa uruniha mo ngelolene nga. ");
INSERT INTO hui_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Ani biragola mali kariani hina gari ibirangi Iyibi wali agali ti hina tomo agali haguane uruni tigua mo ngoai howa tomo andaha wiyaru karulape nalu howa ti nahomolebirago, lalu Yosebehanda kinihondo ani lamini. ");
INSERT INTO hui_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Iyibi dindi kinibi ibunaga agali haguane hearubi tigua Yosebehanda bi layagoni karulape laya manda buwa ani bimi̱ya lai hene. ");
INSERT INTO hui_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Ani lowa Iyibinaga kini ibugua lalu, Ngode Datagaliwabenaga Dinini agali ogo ibuha kago. Ai iname agali mende biabe ogoni bilo abiale taya bimi̱yabe, lene. ");
INSERT INTO hui_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Ani lowa kini ibugua Yosebehondo lalu, Ngode Datagaliwabe ibunime í̠hondo mbira ogoni walia hayagoni. Ai iname agali maru manda timbunibibi boga timbunibirubi lone abiale daboloma̱yabe. ");
INSERT INTO hui_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Áyu í̠na biabe ogoni hondo habelobi Iyibi dindi bibahende handaya ho habelobi i̱na í̠ gabumane haguane habelo dabo helolebero. Kini i̱nime dege bolangua ho holiya. Maru bibahende í̠naga andaneha hai helo, lene. ");
INSERT INTO hui_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Ani lowa kinihanda Yosebehondo lalu, Ai hale habe. Áyu i̱na Iyibi dindi bibahende handame ho habelo gabumane haguane í̠ dabo helarogoni, lene. ");
INSERT INTO hui_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Ani lowa kini ibunaga gi hondoneni wiaga magi wiago Yosebenaga gi hondoneni golo karula halu aga bayaleore wiagobi Yosebe karula howa pu seni ngolome wabini mbira Yosebe mani wia halu bini. ");
INSERT INTO hui_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Ani buwa kininaga garo ale mini karisi nogo hosime gili laga dewa winigo mbira kini ibuninaga mende wiyadagoria Yosebe berelowa harigani agali biabe biaga hearume bamba halu lalu, Wali agali karunaga haguane ibirago habagi hadaba, laga bima pene. ");
INSERT INTO hui_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Ani lowa kini ibugua Yosebehondo lalu, Ai i̱na bi ogodagua larogoni. Iyibi dindini karu ti bibahende í̠ hale nahe howa tini hangume mbirale mbira nabulebiraore. Tigua í̠hondo hale ala holene wulebira, lene. ");
INSERT INTO hui_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Ani lowa kinihanda Yosebenaga mini aribia halu ibu mini Sabanada Panea wini. Ani bialu loma binigo mo miaga agali mbira Heliobolisi dindi wiagoria henego mini Podibera ogoni ibu wane mbira Asenada berenego Yosebe ibu dabu bilo mialu bini. Ani bigi biya handala Yosebe ibu Iyibi dindi bibahendeha de handama ibaga biai hole pene. ");
INSERT INTO hui_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Yosebe ibuni mali pira tebira (30) hayagola Iyibi dindini kini kagonaga biabe ogoni bilo dabo helene. Ani biya handala Yosebe ibu Iyibi dindi bibahendeore handai hole kini ibu helalu pene. ");
INSERT INTO hui_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Mali kariani tomo bayale Iyibi dindini anda hai hene. ");
INSERT INTO hui_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Ani anda hayagola Yosebehanda dindi tano mbira mbirani tomo anda timbuni heagoha widi mo mogobu wialu hene. ");
INSERT INTO hui_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Tomo mo mogo binidaruni daga aulolebe tobahe. Daga labe nahe ibamu ale mo mogobu wini. ");
INSERT INTO hui_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Mali hina gari timbuni polene wiyago tagira naibi dege howa Yosebe one Asenadahanda igiri kira taba henene. ");
INSERT INTO hui_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Ani taba hanayagola Yosebehanda lalu, Ngode Datagaliwabehanda i̱ biamogo biyagola i̱na i̱naga aba ai̱ya damenerubi i̱ni tandaga timbuni handalu harugobi bibahende embeda harugoni, lowa ibu igini mbiragonaga mini Manase wini. ");
INSERT INTO hui_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Ani lowa lalu, Ai Ngode Datagaliwabehanda dindi ogoha genda yu hewagola i̱ biamogo bialu waneigini ngiyadago, lowa ibu igini mendego mini Eberaimi wini. ");
INSERT INTO hui_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Ani lowa hearia mali bayale debengi karia biago piai hene. ");
INSERT INTO hui_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Ani bialu ko hina garingi tagira ibulene abale Yosebehanda lo wiyago tagira ibini. Dindi bibahendeha hina gari timbuni tagira piyago Iyibi dindiha dege hina gari nahe tomo dewa ngelo hene. ");
INSERT INTO hui_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Maniore hayagola Iyibi dindi bibahendeha hina gari timbuni tagira piyagola kinihondo ti tomo ngi lowa dugu bialu hene. Ani biyagola kinihanda lalu, Yosebe ibugua bidaba laradagua bule ibuni karia pudaba, lene. ");
INSERT INTO hui_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","57","Iyibi dindiore bibahendeni hina gari timbuni pialu mo luluya hayagola Yosebehanda tomo anda timbuni biagoha wali agali ti ibalu widi do wiyaru munime yolo bini. Ani binigo nde hina gari tagira piyadagoni Iyibi dindi hangu ndo dindi bibahendeni hina gari timbuni tagira piai hayagola wali agali dindi bibahendeha howa Yosebe hearia muni yalu tomo yolo bule ibugu bini. ");
INSERT INTO hui_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Yagaba ibugua Iyibi dindiha widi dewa nga layago hale howa ibu iginiruhondo lalu, Tí ogoria darabini ale howa ogoria bame biru ngamigo agi. ");
INSERT INTO hui_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Iyibi dindiha widi dewa bu nga layago ai ina hina garime homoligo maru yolo bule pudaba, lene. ");
INSERT INTO hui_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Ani laya handala Yosebe hamene pirali biaru ti Kenana dindi wahalu Iyibi dindiha tomo widi bu nga layago yolo bule pene. ");
INSERT INTO hui_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Yosebe hamene Beniyamini libu ai̱ya mbiraorego manda buwa ibubi bolilono Yagabahanda ti haru mandagi pelo yupe nahe ibu andaga helene. ");
INSERT INTO hui_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Kenana dindiha gaea bialu hina gari timbuni biyagola agali maru Iyibi dindiha tomo yolo bu piyadagua Yagaba igini biaru tibi nde tomo yolo bule pene. ");
INSERT INTO hui_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Horo ogoningi Yosebe ibu gabumane haru haga haguane heagola agali dindi tara taraha howa Iyibi dindi widi yolo bule pialu ti Yosebe hearia ibiyadagua ibu hamene biaru tibi widi yolo bule ibalu ibu heagoria ge duli hanga howa wanakuime dindi ela halu Yosebenaga geha bulu paliai hene. ");
INSERT INTO hui_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Ani bulu paliai heagola Yosebehanda ibu hamene biaruoreyane hendene. Ani hondowa ibu agali tara hetingi howa tihondo bi hongo howa lalu, Tí dindi ani ali íbu kamibe, lene. Ani layagola tigua ladai bialu lalu, Ina Kenana dindiha howa tomo widi yolo bule íbu kama, lene. ");
INSERT INTO hui_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Ani lowa Yosebe ibugua ibu hamene biaruniore kagonida manda biai henego ibu hameneru tigua dege Yosebeda manda nabi hene. ");
INSERT INTO hui_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Ani howa Yosebe ibugua emaga mbira ala hendene biago mitangi bu dai bialu hearia ibu hamene biarume ibunaga geha bulu paliai hene biaru mitangi bu dai bini. Ani manda buwa ibugua tihondo lalu, Tí dindi diri mbira agohayagi ngabe hondo wule ibirimida. Inanaga dindi ogo gibuni lene mbirahayagi henge mbira au ngabe hondole ibirimida, lene. ");
INSERT INTO hui_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Ani layagola tigua ladai bialu lalu, Agali haguane-o anidagua mitangi nabiore. Ina í̠naga biabe bia haga agaliru howa tomo henene yolo bu ibirima lalu tiga tigaore laramagoni. ");
INSERT INTO hui_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Ina bibahende agali mbiraore ibu hangu igini kamago agali hondo wule ibini ndo ina agali heneneore íbu kama, lene. ");
INSERT INTO hui_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Ani layagola Yosebehanda hongo howa tihondo lalu, Ndoore tí inanaga dindi ogonaga gibuni lene mbirahayagi anda ibulene henge mbira agoha ngabe hondo wule ibirimidane hendedogoni, lene. ");
INSERT INTO hui_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Ani layagola tigua ibuhondo ladai bialu lalu, Agali haguane-o ina homberiali (12) hamenema agali mbiraoreali igini Kenana dindiha henego. Ai ina hamene heyogonego ibu abala andaga ka. Ina hamene mbirago pu ereba henego homaya bada, lene. ");
INSERT INTO hui_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Ani layagola Yosebehanda tihondo lone lalu, I̱na tí ke̱ howa dindi hondo wule ibirimida larugoni ndobe. ");
INSERT INTO hui_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Anigo i̱na tí ba hondolene hariga mbira manda bidogo. Áyu Iyibi kini kagonaga minini howa heneneore bulego laro. Tí hamene heyogone ogoni i̱naga deni íbu ha nabiyagua tí bibahende tíni dalu dai nabuleberemi. ");
INSERT INTO hui_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Áyu kamiruni aria mbiragome tí hamene heyogone andaga haruago haru halu ibule pu ladaba. Ai maru tínaga bi larimigo tiga tiga larimidabe be ke̱ harimidabe daba hondoloma̱ya tíni garabaya andaha halimulo helolebero. Mani handalu kamaria tígua bi larimigo henene ndoyagua nde Iyibinaga kini kagonaga minini howa heneneore larogo tí ohowa dindi ogo hondo wule ibirimida lolebero, lene. ");
INSERT INTO hui_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Yosebe ibugua bi lai howa agali uruni ti horo tebiru garabaya andaha helene. ");
INSERT INTO hui_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Ani helowa horo tebonengi Yosebe ibugua tihondo lamialu lalu, Ainde i̱ Ngode Datagaliwabenaga andaneha haabo haga henego kogo tígua i̱naga bi larogo talialu birimiyagua nde tí bayale holeberemi. ");
INSERT INTO hui_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Anigo tí agali bi heneneore laga kamiyagua nde agali mbiraoreali dege garabaya anda tí harimidagoha heladaba. Ani bialu tí marume tínaga wali waneiginiru hina garime homoligo widiru yolobu hanalu pole pudaba. ");
INSERT INTO hui_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Anigo tínaga bi larimigo heneneore larimida lo manda buliyanaga tí hamene heyogone andaga haruagoni haru halu dai bilimu. Tígua bi o larodagua birimiyagua nde tí homa nabi holeberemi, lene. Ani lamiyago hale howa tigua bi ogoni karulapeda lo manda bini. ");
INSERT INTO hui_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Yosebe hamene biaru ti Yosebe ibu heba mandagi howa tinime bi lagalaga bialu howa lalu, Heneneore ina hamenehondo koore timbuni birimagonime ai inane pani nolene áyu wiragonida. Ibugua ga̱ lalu dugu bialubi ibu biamogo bidaba layago hale nahe tingi harimagoni. Anidagua birimagonime pani ngiadai binigo áyu nami̱yaore kamagoni ndobe, lalu hene. ");
INSERT INTO hui_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ani lowa Lubenehanda ibu hamenemahondo lalu, Áyu pani nolene íbu ngagoni irane ala tígua i̱naga bi larugoni hale howa nahe tingi halu i̱na mbira nabuleore lalu hewago helowa igiri emene biago homayagonaga pani nalu kamagoni, lene, ");
INSERT INTO hui_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Yosebe hamene biaru tigua tinaga bi layago hale nahe bedabe toba howa ti Hiburu bi lowa lalu berenego Yosebe ibunime hale howa dege nahalehe tingiho hene. Ani binigo pigane ti Yosebe baba bi layangi Yosebe ibugua Iyibi bi lalu lamiyagola bi lo beregedaga mbira heagome Yosebe hameneruhondo Hiburu bi lalu lamiyagola tigua bi lalu bereago hale naholobadalo manda buwa ani lalu berene. ");
INSERT INTO hui_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Tigua bi urunidagua lalu bereago Yosebe ibu hale howa dara halu mini tigilaya handala ha do howa dugu bule pene. Yosebe ibu dugu biai halu ti baba bi lone lole dai bini. Dai bu howa ibunaga biabe bia haga agali mbira heagohondo lamialu lalu, Simiono minu yania ha, lene. Minu yania howa ibu hamene biaru tini handayaho heaore dege pu hongohe wiagome minu kabu bigi bini. ");
INSERT INTO hui_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Mani howa Yosebehanda ibunaga biabe biaga agali hearuhondo lalu, Tomo tale buwa tininaga nuha hana hagahaga bialu tinaga munibi tini nuha hanadai bilimu. Ani buwa harigani ti tomo nelobi milimu, lalu lamini. Ani lamiyago hale howa Yosebenaga biabe biaga agali bu hearume bibe layadagua biai hene. ");
INSERT INTO hui_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Ani miai haya handala Yosebe hamene biaru tigua tomo nu heba hono wiaruni nogo dongi erekunini mo paga halu andaga pole pene. ");
INSERT INTO hui_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Pialu hariga obeneni handa palue lowa balai anda bia howa hamene mbiragome ibunaga nogo dongi tomo nelo mule lowa ibugua nuha tomo taguini. Taguialu hearia ibunaga muni nu poneni henearia hendene. ");
INSERT INTO hui_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Ani hondowa ibu hamene biaruhondo lalu, Ai handadaba i̱naga muni mirugo ngiadai biyadago i̱ninaga nuha heneneda, lene. Hamene maru biarume bi ani layago hale howa ti mogo lowa gi hai hene. Ani gi hai howa tini dege dege laedene bialu howa lalu, Ngode Datagaliwabehanda agilego o biyadagonida, lene. ");
INSERT INTO hui_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Ani lalu Kenana dindi anda pu howa ti aba Yagabahondo mbirale biyaruni bibahende lamiai hene. ");
INSERT INTO hui_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Tigua lalu, Iyibinaga gabumane agali haguane heagome inahondo bi hongoheore laede halu lalu, Tí dindi diri handaga mbira ibirimida, laya. ");
INSERT INTO hui_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Ani layagola iname ibuhondo ladai bialu, Ina agali dindi diri hondole ndo ina bi henene laga íbu kama. ");
INSERT INTO hui_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Ina agali mbiraore igini hombearia hamenema henego ai mbira pu ereba henego mendego heyogone igiri emenego ogoni ibu abala andaga Kenana dindiha ka, larima. ");
INSERT INTO hui_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Ani larimagola gabumane agali haguane biagome inahondo lone lalu, Tí agali bi henene lagadalo hondoliya mbiraligo i̱ baba halu tí marume widiru hanalu tí damene garibilo holebirago andaga pudaba. ");
INSERT INTO hui_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Ani pialu tí hamene heyogone haruagoni i̱ koria haru halu dai bilimu. Anidagua birimiyagua tí dindi diri handaga ndo agali bi tiga tiga laga ibirimida lolebero. Ani bialu tí hamenebi golope halu tí Iyibi dindiha tínime hoa biragoha ta nabi halimulo helo waholebero laya, lene. ");
INSERT INTO hui_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Ani lalu mani widi nuha hanayaru taguialu hemiria tinaga muni biaruni bibahendeore hanai hearia hendene. Ani hondowa tinibi ti ababi bibahende gi howa mogo lalu mini burugulo hene. ");
INSERT INTO hui_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Ani bu howa Yagaba ibugua tihondo lamialu lalu, Tígua dege binime ai i̱ igini kira ereba hayada. Bamba Yosebebi ereba hayago ai áyu Simionobi ereba dege hayada. Ani biyago ai áyu Beniyaminibi nde haru halu kaundiaha pole degebe. I̱naga genda uruni angi ereba holobadabe, lene. ");
INSERT INTO hui_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Ani layagola Lubenehanda ibu aba lamialu lalu, Aba-o i̱na Beniyamini í̠ni keria haru halu dai nabiruyagua nde i̱ igini kirali o kagoni labo bo wahabelo. Ai i̱na baya hangu handayaho halu í̠ni keria haru dai bule poloma̱ya waha, lene. ");
INSERT INTO hui_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Ani layago hale howa dege Yagaba ibugua lalu, I̱ igini ogoni ibu tí baba napolebira larugoni ndoyabe. Ai ibu hamene biago homayagola ibuni hanguore kagoni ndobe. Ibu harigani pialu kamiria ibuha mo ko holene mbira wuligo napoleorebira. Áyu i̱ agali waheore bedogonidago ai tígua haru pialu kamiria harigani mo ko holene mbira lola hayiyagua nde tígua dara holene timbuniore i̱ mo ngeramigola uruni yalu nde homenerunaga dindiha hama polebero, lene. ");
INSERT INTO hui_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Kenana dindiha gaea bialu hina gari timbuniore pene. ");
INSERT INTO hui_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Ani biyagola Yagaba ibu mini mende Isaraele winigo ibu damene biaru tigua tomo Iyibi howa mo henene biago nai hene. Nai howa Yagaba ibugua ibu igini biaruhondo lamialu lalu, Tígua lone Iyibi dai bialu inanaga tomo yolo bule pudaba, lene. ");
INSERT INTO hui_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Ani layagola Yudahanda ibu abahondo lalu, Aba-o Iyibi gabumane agali haguane heagome inahondo bi hongoheore langiya lalu larimagoni. Ibugua ina hamene naharuhe pirimayagua inanaga dengui nahondoleore laya. ");
INSERT INTO hui_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Ina hamene haru halu pudaba lariyagua nde iname í̠naga tomoru yolobu poleberema. ");
INSERT INTO hui_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Anigo í̠na ina hamene napole lariyagua nde inabi napoleberama. Iyibinaga agali haguane biagome lalu, Tínaga hamene haru naibirimiyagua nde tínaga dengui nahondoleorebero laya, lene. ");
INSERT INTO hui_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Ani layagola Yagaba ibugua lalu, Tígua agali haguane ogoni tí hamene mbira ka lalu agua bulenaga lamirimibe. Tígua ogonidagua larimidagonime i̱ genda timbuniore mo ngirimida, lene. ");
INSERT INTO hui_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Ani layagola tigua ibuhondo lalu, Agali ogonime inahondo bi dewa hale haga biya. Ibugua ina dameneru aguaore kabe lalubi baya hanguore hale haga biya. Ibugua lalu, Tí aba kabe homayabe, laga biya. Tí hamene mbira kabe nahebe, lalu hale haya. Ani hale hayagola inamebi nde tiga tiga lamiai harima. Ina hamene ogoni haru ibalimu lolenaga layago nahende howa lamirimaya, lene. ");
INSERT INTO hui_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Ani lowa Yudahanda ibu aba Yagabahondo lamialu lalu, Beniyamini ibu i̱laore poleberebago ibilo yupe hariyagua nde poleberema. Ani poramagola í̠bi inanaga waneigini bu karubi ina bibahende hina garime nahome bayale holeberema. ");
INSERT INTO hui_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","I̱na ibu baya hanguore handayaho holebero. I̱na í̠ni keria haru dai nabiruyagua ko timbuni ogoni i̱ha wiaabo holebira. ");
INSERT INTO hui_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Ai ina napole nale abale poloma̱ya wahenedale nde halu ki agima pialu dai bidamaleda, lene. ");
INSERT INTO hui_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Ani layagola Isaraele ibugua tihondo lalu, Tígua bulene hariga mende nawiyagua nde ogonidagua bidaba. Tomo bayale maru ina dindini ngaru nuha mo hanalu puwa gabumane agali haguane o haruagoni mo turu halu bame mule hanadaba. Tomo bayale uru mone ibanebi marasini ngabi ira ibaneme wabini tara tara bu ngarubi ira lini dendebi anga ale tara mini pitasio dedaru ariabi anga mende amono ngarubi hanalu pialu bidaba. ");
INSERT INTO hui_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Muni abale hanalu pirimigo heba marubi mo tago howa hanalu pudaba. Muni abale tínaga nuha hanadai biyiyarubi tigua embeda howa ani bini badago urunibi heba hanalu pilimu. ");
INSERT INTO hui_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Ai tí hamene haru halu agali haguane ogoni karia áyu ogoni abale gerai lalu pudaba. ");
INSERT INTO hui_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Agali haguane ogoni ibugua tí dara halu biamogo bilonaga i̱na Ngode Datagaliwabe Hongo Haiheore kagohondo bi lalu kogo tí pudaba. Agali haguane ogonime tí hamene minu yu haruagobi Beniyaminibi libu haru mandagi i̱ni koria haru dai bidaba lelonaga bi lalu ko. Anigo Ngode Datagaliwabe ibunime i̱ igini bibahende ereba hai helo hamelo heagua nde bibahende ereba hai helo, lene. ");
INSERT INTO hui_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Isaraele ibugua ani laya handala tigua tomo tara tara biarubi ira lini ibane ngabi tara tara biarubi manda mandabu hanalu muni ala nuha hanadai biyiyarubi tomo yolo bulenebi hanaga bigi bialu pene. Tigua Beniyaminibi haru halu Iyibi anda puwa Yosebe hondole abale pene. ");
INSERT INTO hui_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Yosebe ibugua handalu hearia tigua Beniyamini haru ibiyago hondowa ibunaga biabe biaga agali mbira heagohondo lamialu, Agali uruni i̱ andaga haru puwa nogo bulumaga mbira balu dawalimu. Agali uruni ti áyu horombenaga tomo i̱ni heba mandagi noloma̱ya ani manda manda bilimu, lene. ");
INSERT INTO hui_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Yosebenaga biabe biaga agali biagome Yosebehanda lamiyadagua bialu agali biaru Yosebe andaga haru pene. ");
INSERT INTO hui_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Anigo Yosebe hamene biaru tigua Yosebe andaga polene gi howa tini dege dege lalu, Tigua ala ibirimangi muni inanaga nuha hana hayiyagonaga lara bada. Tigua ina anda ogoha haru anda puwa minu yania holebira bada. Ina minu yania howa tinaga garabaya biabe ale bialu helonaga helolebira bada. Ani bialu inanaga nogo dongi haru kamarunibi ti dege holebira bada, lene. ");
INSERT INTO hui_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Ani lalu howa tigua Yosebenaga biabe bia haga agali biago Yosebenaga anda harabani heago hondowa ibuhondo lamialu, ");
INSERT INTO hui_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Agali haguane-o bi laramago hale habe. Ala halu mbira iname tomo yolo bu ibirimangi ");
INSERT INTO hui_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","tomo yolo bu ibinigo hanalu puwa ha obeneni palue balai anda bialu howa handalu hemaria ina bibahendenaga muni mbira mbira tomo yolo birimarubi bibahende henearia handarima. Ani handalu muni uruni bibahende hanalu dai birimago. ");
INSERT INTO hui_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Muni ogoni aiwa henelenedabe ina manda nabi kamago ai tomo yolo bule muni marubi henedema, lene. ");
INSERT INTO hui_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Ani layagola biabe biaga agali biagome hale howa ladai bialu lalu, Tígua gi halu mini dege dindiho nahalimu. Tínagabi tí abanagabi Ngode Datagaliwabe ibunime muni uruni tínaga nuha hanadai biyabe tobaheda. Ai muni abale tígua tomo yolo birimiruni i̱ mo yarugoni ndobe, lene. Ani lalu ibugua Simiono damu pialu ti hearia haru ibini. ");
INSERT INTO hui_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Ani bialu mani agali biago ibugua Yosebe hamene biaru Yosebe andagaha haru anda pene. Haru anda puwa tinaga ge wayawaya bilo iba hambu mialu tinaga nogo dongibi tomo nelo mini. ");
INSERT INTO hui_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Ani biyagola Yosebe hamene biaru tigua hale halu hearia Yosebe ibu horombe ti heba tomo mandagi nole ibulebira layago hale howa mbirale Yosebe mo turu halu mule hanalu ibiyaruni tagu manda mandabu ngelo berene. ");
INSERT INTO hui_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Yosebe ibu anda ibiyagola tigua mbirale biaruni Yosebe ibu mo turu halu mini. Ani mialu howa tigua Yosebenaga wanakuihayagi ge duli hanga howa bulu palialu tinaga wanakuime dindi elaore hene. ");
INSERT INTO hui_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Ani biyagola Yosebe ibugua tihondo, Ibirimidago turuba. Tí aba agali wahe beda lalu abale i̱ langirimigo ai ibu karulape bedabe, lalu hale hene. ");
INSERT INTO hui_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Ani hale hayagola tigua ladai bialu lalu, Agali haguane-o ina aba bayale beda, lene. Ani lalu tigua Yosebe deni howa lone bulu palene. ");
INSERT INTO hui_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Yosebe ibu Beniyamini hondowa libu ai̱ya mbiraore igini haribada lo mitangi bialu ibugua lalu, Igiri daliahe ogoni abale tí hamene andaga ka lalu langirimigoni mbauleda, lene. Ani lowa ibugua ibu hamene Beniyaminihondo lalu, Igini-o Ngode Datagaliwabehanda í̠ biamogo bilo laro, lene. ");
INSERT INTO hui_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Ani lalu Yosebe ibu hamene heyogone biago handalu dara timbuniore howa ibuni dugu bule manda bialu hene. Ani biyagola ti helalu ibu abale tamuha anda puwa dugu bialu hene. ");
INSERT INTO hui_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Dugu bu wahalu de iba domalu tagira ibuwa biabe bia haga agali hearuhondo lalu, Tomo dugu tale bialu tomo dagiani ngeladaba, lene. ");
INSERT INTO hui_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Ani layagola tigua Yosebenaga tomo dagia mbirani manda mandabu ngelalu ibu hamenerunaga mendeni wia hene. Ani bialu Iyibiali bu hearu ti nde Hiburualiru baba tomo mandagi nanaga howa tibi nde dagia tebone wiagoria biruwa nalu berene. Tigua tomo mandagi nanagadagoni irane Iyibiali ti daligaore kama manda buwa nanaga hene. ");
INSERT INTO hui_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Yosebe ibunime ibu hamene biarunaga biragane dagia tini taba henenedagua waheneni howa birama pialu heyogoneni bira maro bilo ibunaga biabe biaga agali hearunihondo lalu, Mo manda manda bia halimu, lalu lamini. Hamene biaru tigua o biyadagoni hondowa tini mogo lalu mini dege dindiho biruwa tini handaya hagahaga bialu berene. ");
INSERT INTO hui_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Ani bialu bereagola biabe biaga agali hearume Yosebe hamene biarunaga tomo Yosebenaga dagiani wiago mo yalu ibuwa talebu tahaga bini. Ti tomo karulapeore nelo talebu migi bini. Anigo Beniyamini dege dewaore agali durialimebi nolene karulape talebu mini. Ani miyagola tigua Yosebe baba tomobi ibabi nalu biruwa turu timbuni howa nalu berene. ");
INSERT INTO hui_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Ti tomo nai heagola Yosebehanda ibunaga biabe biaga agali bu hearuhondo lamialu lalu, Ai tomo dewaore tinaga nuha hono to̱latagi helo talebu hana halimu. Ani hono to̱lai howa tinaga munibi tininaga nu poneni hana halimu. ");
INSERT INTO hui_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Ani bialu i̱naga gabo be silibame wabini ngogobi ti hamene heyogone biagonaga nuha ibunaga widi yolo bule muni yu ibiyagobi hanaramigoha dege hana halimu, lene. Ani layagola biabe biaga agali hearume Yosebehanda ogonidagua bilimu lalu lamiyadagua biai hene. ");
INSERT INTO hui_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Ani biai howa horo mendengi gao layagola biabe biaga agali biarume Yosebe hamene biarunaga nogo dongi heba pelo biamogo bialu pudaba lene. ");
INSERT INTO hui_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Pu lu nabi wene pialu heaore dege Yosebe ibugua ibunaga biabe biaga agali anda mamage haga heagohondo lalu, Agali o piyaru haruru talima puwa tihondo ogodagua labe. Iname tíhondo mana bayale dege birimagola tígua inahondo mana ko wiago birimiyago irane aginaga birimibe. ");
INSERT INTO hui_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","I̱naga agali haguane biagonaga gabo be mbira mo hanarimiya. Ani bialu ibugua mbirale manda bulene wiado hene ngarunaga gabo be ogoniha howa galone handa walia hagago ai tígua mana ko liaheore bialu mo hanarimiya labe, lene. ");
INSERT INTO hui_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Ani laya handala Yosebenaga biabe biaga agali biagome Yosebe hamene biaru piyadagua talima pene. Ibugua pialu ti tali minuwa Yosebehanda bi labe layarunidagua lamini. ");
INSERT INTO hui_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Ani layagola tigua ladai bialu lalu, Agali haguane-o í̠na inahondo bi uruni ale aginaga larebe. Iname mbirale í̠na lareruni mbira bibe nahe kamagoni ndobe. ");
INSERT INTO hui_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Iname abale tomo yolobu ibirimangi muni inanaga nu poneni hana heneyago Kenana dindiha howa halu mende dai bialu howa hanalu dai birimagoni í̠ manda bide. Ai áyu í̠naga agali haguane andagaha wini ngolo silibaru iname agua bialu mo page biyada lo manda bidebe. ");
INSERT INTO hui_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Agali haguane-o ina o kamaruni aria mbiralime gabo be ogoni mo heneagua ogoni ibuni homelo bo wahabe. Ani beregola ina bibahende í̠naga garabaya biabe ale bia haga holoma̱ya, lene. ");
INSERT INTO hui_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Ani layago hale howa Yosebenaga biabe biaga agali biago ibugua ladai bialu lalu, Tígua bi tiga tiga dege larimigo gabo be ogoni mbiralinaga nuha henedaria handa walia haruyagua agali ogoni ibu hangu i̱naga garabaya biabe ale bia haga holebira. Tí bibahende andaga piai holeberami, lene. ");
INSERT INTO hui_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Ani layagola tigua Yosebenaga biabe biaga biagome tinaga nu handai helo dindini dugu ibira hai hene. ");
INSERT INTO hui_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Ani biyagola Yosebenaga biabe biaga agali biago ibugua Yosebe hamene wahenenaga nuha ala hondowa mani tini taba hanayagola hama ibinidagua handama pialu heyogone biagonaga nu handa maro bini. Ani handalu hearia gabo be biago Beniyamininaga nuha henearia handa walia hene. ");
INSERT INTO hui_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Yosebe hamene biaru ti gabo be biago Beniyamininaga nuha heneneyago hondowa tigua daraore ho kama lowa walia halu tinaga aga bu hearu minu lerelene. Ani lerelowa tinaga nu lone nogo dongi erekunini mo paga halu Yosebe hearia dai bini. ");
INSERT INTO hui_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Yuda ibu hamene biarubi tigua Yosebe andaga lone dai buwa handalu hemiria Yosebe ibu mbiraha nape ibuni andagaha bereneyane hendene. Ani hondowa ti gi timbuniore halu tigua Yosebenaga wanakuihayagi dindini bulu paliai hene. ");
INSERT INTO hui_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Ani biyagola Yosebehanda tihondo lamialu lalu, Mana agialego o birimidagonibe. I̱na oholene mbirale wiado hene ngaru handa walia nahaga kabe toba harimibe, lene. ");
INSERT INTO hui_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Ani layagola Yudahanda ladai bialu lalu, Agali haguane-o iname í̠hondo bi ladai bulene mbira nayi kamagoni ndobe. Iname ko nabi kama labe nahe kamagoni. Ai Ngode Datagaliwabehanda inanaga ko wu hemago mo pani hayago. Áyu agali í̠naga gabo be mo page biyago hangu ndo ina bibahende í̠naga garabaya biabe ale bia haga hai holeberema, lene. ");
INSERT INTO hui_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Ani layagola Yosebehanda lalu, Ani ndo i̱na tí bibahende hai hadaba nalolebero. Agali mbiraore i̱naga gabo be mo hanalu piyadago ibu hangu i̱naga garabaya biabe ale bialu helo helolebero. Tí bibahende miniha genda nahe tí aba karia andaga dai bidaba. I̱ tí baba bi lolene nawigo áyu ogoni pudaba, lene. ");
INSERT INTO hui_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Yuda ibugua Yosebe heagoria kaware puwa ibuhondo lalu, Agali haguane-o i̱naga bi larogo nde hale harene. Í̠ agali timbuni Iyibinaga kini kagobi dege kegonigo ainde harugo i̱naga biore hale halu i̱hondo keba nahabe. ");
INSERT INTO hui_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Ai abale biago í̠na inahondo hale halu tí aba hamenebi mbira kabe nahebe lalu hale harigoni. ");
INSERT INTO hui_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Ani hale harigola iname lalu, E̱ ina aba agali waheore beda. Ina hamene heyogonebi aba ibu agali wahe daguaheore howa hono winigo andaga ka larima. Wali mbiragome igiri kira hono winigo mende homayagola mendego hangu ka. Anigo ibu abahanda ibu igini mbiraore ogoni hangu gubalini ho haga ka lalu abale langirimagoni. ");
INSERT INTO hui_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Ai agali haguane-o í̠nime lalu ina hamene heyogone ogoniore i̱ hondoliya haru ibule pudaba lari. ");
INSERT INTO hui_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Ani larigola igiri ogonime ibu aba helalu naibulebirago nde helalu ibiyagua ina aba homolebira larimagoni. ");
INSERT INTO hui_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Anidagua larimagola í̠na bi mbira ogodagua lari. Tí hamene heyogone ogoni helo wahalu i̱naga deni halu mende naibuleberemiore, lalu abale biago langirigoni ndobe. ");
INSERT INTO hui_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Ai agali haguane-o iname í̠naga bi uruni hale hai halu puwa ina abahondo bi uruni bibahende lamiai harima. ");
INSERT INTO hui_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Ani larimagola ina abahanda lalu, Tomo lone yolo bule pudaba, laya. ");
INSERT INTO hui_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Ani layagola iname lalu, Ina hamene heyogone kago naharu pirimayagua Iyibinaga agali haguane kagome inanaga dengui lone nahondoleore layagodago ina napoleberama, larima. ");
INSERT INTO hui_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Ani larimagola aba ibugua inahondo lalu, I̱ one Leselo ibugua igiri kira hangu hono wiyagoni tí manda bu kamigoni. ");
INSERT INTO hui_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Igiri mbirago ereba hayagola i̱ nahende waore harugoni. Ogoni ibu laiono gabuame balu nedabe be agua biyabe tobara. ");
INSERT INTO hui_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Anigo áyu tígua i̱ helalu i̱ igini mende ogobi dindi kaundiaha haru pole kamigoni. Ai tí heba harigani pialu kamiria mo ko holene mbira ibuha anda ibiyagua nde i̱ha dara holene timbuniore wiragome i̱ bo homelaramigola homenerunaga dindiha hama polebero, lalu laya. ");
INSERT INTO hui_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","Ainde agali haguane-o i̱ aba ibu igiri ogoni ibuninaga gubaliniore hagago i̱ aba karia ibu haru dai nabiruyagua nde ibu homolebira. Ina aba agali waheore bedago ai igiri ogoni haru dai nabirimayagua nde iname ibuha genda timbuniore mo mialu dara holene timbuni dege yalu homolobada. ");
INSERT INTO hui_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","I̱ abahondo bi mbira buleore lalu hongohe ogodagua lamiru. I̱na igiri ogo ibuni karia haru dai nabiruyagua nde ina abahondo bia ko timbuniore harogola ogoninaga genda i̱niha wiaabo holebira lalu lamiru. ");
INSERT INTO hui_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Ani larugo ai i̱na igiri ogonaga henge mialu í̠naga garabaya biabe ale bialu holiya ibu hameneru baba ibu aba karia andaga dai biaore la. ");
INSERT INTO hui_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Igiri ogo naharuhe i̱na i̱ aba karia andaga dai nabulebero. I̱ aba ibugua genda timbuni holobadago i̱ hondole hame nale kogo andaga napolebero, lalu Yudahanda lene. ");
INSERT INTO hui_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Yosebe ibugua dara timbuniore howa dugu bua biyagola ibunaga biabe biaga agali hearuhondo lalu, Tí tagira piai hadaba, lene. Piai hayagola ibu hamene biaru baba tini hangu hene. Ani howa ibugua tihondo lamialu lalu, I̱ Yosebe tí hamene biago kogoni, lene. ");
INSERT INTO hui_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Ani lowa Yosebe ibugua dugu hongo howa biayuago Iyibi wali agali tagira hearume hale halu tigua agali kini andagaha haga hearu lamule pene. ");
INSERT INTO hui_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Yosebehanda ibu hamene biaruhondo lamialu lalu, I̱ Yosebeore kogonigo i̱ aba bayale kabe, lene. Ani layagola ibu hamene biarume mogo timbuniore lowa bi mbira ladai bibe nahe hene. ");
INSERT INTO hui_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Ani hemigola Yosebe ibugua laabo halu lalu, Tí gi nahe i̱ kogoria kaware ibidaba, lene. Ani layagola ti kaware hapara ho heagola ibugua tihondo lamialu lalu, I̱ tí hamene Yosebe kogoni. Bamba tígua biyinaya biabe biaga agali hearume yolo bilo i̱ minu mirimigola tigua i̱ Iyibi dindiha minu yalu ibiya. ");
INSERT INTO hui_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Anigo áyu tígua mana ko ogoni birimigonaga tí bu miniha genda howa holene nawigo wahalimu. Ngode Datagaliwabe ibunime tí homoligonaga i̱na ala manda manda bialu holiya i̱ dindi ogoha ibilaya. ");
INSERT INTO hui_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Ai gaea timbuni bialu hina gari pialu heane mali kira hangu piyagoni. Mali duria wene hole ngago nde agalime tini mabuha tawe tomo mbira bialu nanolebiraore. ");
INSERT INTO hui_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Gaea hangu bialu hina gari timbuni nahendene ale áyu o tagira poragoningi Ngode Datagaliwabehanda i̱ha howa tí biamogo bulenaga i̱ ala ogoha íbu helaya. ");
INSERT INTO hui_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Ani biyago tígua i̱ ibilarimi ndo Ngode Datagaliwabe ibunime minu ibilayagola ibirugoni. Ani íbu hewagola Ngode Datagaliwabe ibunime i̱ Iyibi kini kagonaga aba haradagua haguane daligaore helaya. Ani helayagola i̱na kini andagaha wali agali bibahende bu karu handayaho halu Iyibi dindi bibahendenaga agali haguanebi i̱ dege kogoni. ");
INSERT INTO hui_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Ai áyu ogoni abale ina aba karia dai bialu ibuhondo bi ogodagua lamilimu. Í̠ igini Yosebe i̱na bi ogo lawia harogo. Ngode Datagaliwabehanda i̱ Iyibi dindi bibahendeha handameho holiya agali haguane helenego kogo ai í̠na emene hondo ha nabi abaleore ibabe laro. ");
INSERT INTO hui_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Ibalu i̱ni kogoria Gosene dindi kaware ngagoriani habelo. Í̠nibi í̠ waneiginirubi í̠ aguanerubi í̠naga nogo sibirubi memerubi bulumagarubi í̠naga mbirale wiridarubi uruni bibahendeore Gosene dindi ngagoria hole ibaiore halimu. ");
INSERT INTO hui_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Í̠ Gosene dindini íbu bedegola i̱na handayaho holebero. Ai gaea timbuni bialu hina gari timbuni áyu poragoni biaho ngane dege mali duria polene ngago. Mali duria ogoniha í̠nibi í̠ waneigini aguanerubi í̠naga nogo tara tara bu karubi bibahende garibilo halimulo i̱ hame nalego abale ibalimu laya lalimu, lalu Yosebe ibugua lene. ");
INSERT INTO hui_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Ani lowa Yosebe ibugua ibu hamene biaruhondo lamialu lalu, Tígua i̱ baya hangu manda bialu áyu bi lalu kogoni tara ndo. I̱ tí hamene Yosebe biagoniore kogoni. Beniyamini í̠ nde i̱ni hamene heyogoneore biago í̠na i̱ manda bibehe dege kegoni. ");
INSERT INTO hui_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Ai tígua i̱ aba bedaria dai bialu i̱ Iyibi dindiha agali mini lene timbuni mbira hea lalu lamilimu. Ani lamialu tígua mbirale handarimigo damene bibahende lamiai halimu. Ibu haru ibule áyu ogoni gerai lalu abale pudaba, lene. ");
INSERT INTO hui_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Yosebe ibu bi uruni lai halu ibu hamene Beniyamini yu hubi lalu dugu biyagola Beniyamini ibubi nde dugu dege bini. ");
INSERT INTO hui_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Ani bialu Yosebe ibugua ibu hameneru bibahende yu hubi laga bialu nu̱nu̱bi lalu dugu bia dege bini. Ani biyagola ibu hamene biaru tigua Yosebe baba bi lole manda bini. ");
INSERT INTO hui_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Ani biyagola Iyibinaga kinibi ibunaga agali haguane bu hearubi tigua hale halu hearia Yosebe ibu hameneru ibuni heba íbu ka layago hale howa ti turu ho hene. ");
INSERT INTO hui_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Ani hale howa kini ibugua Yosebehondo lalu, Í̠ hameneru ti nogo dongiru mo manda manda bialu Kenana dindi abale dai bidaba labe. ");
INSERT INTO hui_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Dai bialu ti ababi ti one waneiginirubi bibahende haru halu dindi ogoriani abale dai bilimu labe. Ani bialu haru halu ibiragola i̱nime Iyibi dindiha dindi bayaleore ngago ti ogoriani helo tu wu mulebero. Ani merogola dindi ogoniha tomo baya tara tara hangararu damene bibahende anda hai holebirago ti karulapeore nalu holebira. ");
INSERT INTO hui_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Ai ti pialu Iyibinaga garo ale mini karisi ngaruni ti one waneiginiru biralu tini heba mandagi ibule mo yalu pilimu. Ti ababi haru halu íbu dege bilimu. ");
INSERT INTO hui_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Tinaga mbirale Kenana dindiha howa ngelo henedaru yu wahalu ibuleda lo manda nabilimu. Mbirale baya tara tara Iyibi dindiha wini ngaru ti wu helo talebu miai holeberogo ibalimu labe, lalu kini biagome Yosebehondo lamini. ");
INSERT INTO hui_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Yagaba igini biaru tigua kini ibugua bilimu lalu lawia hayadagua bini. Yosebehandabi nde kini ibugua bibe lalu lamiyadagua karisi wiaruni aria maru mo mini. Mo mialu ti harigani pialu howa tomo nelobi maru mo wia halu bini. ");
INSERT INTO hui_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Yosebehanda aga mbira dege dege ibu hamene biaru tahalu Beniyamini dege duria mini. Ani mialu muni siliba handari tebirabi (300) Beniyamini mialu bini. ");
INSERT INTO hui_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Ani mialu Yosebe ibugua mbirale bayale damene Iyibi dindiha wini wiaru aria dewaore nogo dongi wangabe piranaga erekunini mo paga howa ibu abanaga yalu pudaba lene. Ani bialu widiru mberedirubi tomo tara tara maru wiarubi bibahende ibu aba harigani ibalu howa nelonaga biamogo bialu nogo dongi angibuni piranaga erekunini mo paga halu yalu pudaba lalu bini. ");
INSERT INTO hui_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Yosebe ibugua ibu hameneru pelo lowa ibugua tihondo lamialu lalu, Tí harigani pialu howa tíni dege dege keba nahe laibi nale baya hangu pilimu, lalu lamini. ");
INSERT INTO hui_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Ani laya handala Yosebe hamene biaru ti pialu ti aba Yagaba hearia Kenana dindi anda pene. ");
INSERT INTO hui_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Anda puwa ti abahondo lamialu lalu, Aba-o Yosebe ibu nahome heneyago ai ibugua Iyibi dindi bibahende handameho hea, lene. Yagaba ibu bi o layadagoni hale halu ibu mini naibi dege howa bi ogoni mo henene nahe hene. ");
INSERT INTO hui_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Ani heagola tigua Yosebehanda bi lawia hayaruni bibahende lamiai hene. Ani bialu Yosebehanda ibu aba Yagaba Iyibi ibilonaga karisi mo wia hayiyago hondowa ibunaga miniha wálo dege berene. ");
INSERT INTO hui_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Ani wálo biruwa Yagaba ibugua lalu, Heneneore i̱ igini Yosebe homa nabi harua lo manda bido. Ai i̱ Yosebe nahende koore homoligo ina abale Iyibi ma, lene. ");
INSERT INTO hui_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Yagaba ibunaga mbirale wiarubi waneigini aguanene hearubi bibahende mo ngoai halu Iyibi dindi pole hariga peadagua pialu hene. Ani pialu howa dindi mbira mini Beseba wiagoria anda puwa Yagaba ibugua ibu aba Aisaganaga Ngode Datagaliwabehondo mbirale bo loma bu mini. ");
INSERT INTO hui_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Ani buwa mbiraga Yagaba ibu paluwa de gandeba handalu hearia Ngode Datagaliwabe ibu ibuwa lalu, Yagaba-o Yagaba-o, lalu olene. Ani layagola Yagabahanda lalu, Ya i̱ o kogoni, lene. ");
INSERT INTO hui_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Ani layagola Ngode Datagaliwabehanda lalu, Í̠ aba Aisaganaga Ngode Datagaliwabe kogonigo ai í̠naga waneigini aguaneneru mo dewaore heloleberogo í̠na Iyibi dindi gi nahe pobe. ");
INSERT INTO hui_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","I̱na í̠ heba Iyibi dindi pialu mani Kenana dindi lone haru dai bulebero. Í̠ homaregola í̠naga tingini Yosebe ibunime hora holebira, lene. ");
INSERT INTO hui_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Egabi layagola Yagaba ibu igini biarume ti aba Yagaba tinaga one waneiginiru baba garo ale nogo hosime gili laga kini ibugua Iyibi howa ti yalu dai bilo ibilene biagoria berelowa yalu pene. ");
INSERT INTO hui_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Yagaba ibunaga yári dabudabu wiaruni bibahendeore tinaga nogo bulumagarubi mbirale bibahende Kenana dindi yu hene wiaruni yaiore halu Iyibi dindi pene. ");
INSERT INTO hui_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Yagaba waneiginirubi aguanerubi bibahendeore Iyibi dindi pole Yagaba ibuni heba piaiore hene. ");
INSERT INTO hui_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Yagaba damene bibahendeore Iyibi dindiha ibu heba mandagi penerunaga mini uru. Yagaba igini wahene Lubene ibubi ");
INSERT INTO hui_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Lubene iginiru Hanogobi Palubi Heseronobi Kami imaru ti pene. ");
INSERT INTO hui_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simiono ibu iginiru nde Yamuelebi Yaminibi Ohadabi Yaginibi Sohabi Saulubi uruni ti pene. Saulu ibu ai̱ya Kenana wali mbira berene. ");
INSERT INTO hui_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Libai ibu iginiru nde Gesonobi Kohadabi Merari imaru pene. ");
INSERT INTO hui_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Yuda ibu iginiru nde Selabi Peresebi Sera imaru pene. Yuda igini maru Ere Onanala kirabali Kenana dindi hemingi homene. Perese ibu igini Heserono Hamulula pene. ");
INSERT INTO hui_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isaga ibu igini Tolabi Puabi Yasububi Simirono imaru pene. ");
INSERT INTO hui_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Ani bialu Sebulunu ibu igini nde Serede Elono Yalele imaru pene. ");
INSERT INTO hui_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Yagaba one Lia ibu igini uruni bu hene. Lia ibugua igiri uruni Mesobodemia dindini hemingi taba hanaga bini. Liahanda wandari mbiraore hangu mini Daina taba henenego ogoni berene. Yagabanaga waneigini aguanerubi Liaha howa henego aria pira tebirani huniane tebira (33) ti bibahende Iyibi dindi pene. ");
INSERT INTO hui_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Yagaba igini Gada ibu igini nde Sebonobi Hagibi Sunibi Esebonobi Eribi Arodobi Areli imaru henego tibi pene. ");
INSERT INTO hui_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Ase iginiru nde Iminabi Isibabi Isibibi Beria imaru halu ibu wane Sera berenegobi uruni pene. Ani pialu Beria igini nde Hebe Malagielela libubi pene. ");
INSERT INTO hui_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Wali agali uruni bibahende ti wali mbira mini Siliba ibu Lianaga biabe bia haga berelo Labanahanda ibu wane Lia minigo o biago Yagabala libu waneigini hene. Ti bibahende daga lamaga halu pira mbirani waragaria (16) pene. ");
INSERT INTO hui_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Yagaba one mende Leselo ibugua Yagaba igini Yosebe Beniyaminila taba henene. ");
INSERT INTO hui_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Anigo Yosebe ibu Iyibi dindiha heangi loma binigo mo miaga agali mbira mini Podibera ibu Heliobolisi tanoha henego ibu wane Asenada bereago ibu Yosebe one biruwa ibugua igiri kira Manase Eberaimila taba henene. ");
INSERT INTO hui_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Beniyamini igini nde Belabi Begebi Asabelebi Gerabi Namanabi Ehibi Losobi Mubimibi Hubimibi Ada imaru hene. ");
INSERT INTO hui_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Agali uruni pira mbirani maria (14) ti Yagaba Leselola libu aguaneru ti bibahende Iyibi dindi pene. ");
INSERT INTO hui_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Dana ibu igini mbiraore hangu mini Husimi hene. ");
INSERT INTO hui_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Nabadali ibu iginibi nde Yaselebi Gunibi Yasebi Sileme imaru hene. ");
INSERT INTO hui_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Agali karia uruni bibahende Yagaba Bilihala libu waneigini aguaneru bu hene. Wali Biliha ogoni Labanahanda ibu wane Leselonaga biabe bia haga berelo minigo berene. ");
INSERT INTO hui_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Yagaba ibu aruniru daga nale howa ibuni waneigini hangu Iyibi dindi pole peneru daga pira waragariani waragaria (66) pene. ");
INSERT INTO hui_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Anigo Yosebe oneme igiri kira Iyibi dindini taba hanayago heba lamaga halu Yagaba ibu damene pira karia (70) Iyibi dindi pu hene. ");
INSERT INTO hui_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Yagabahanda Yuda abale bamba halu Yosebe Gosene dindini ngola hole ibilo, Lamima pu, lene. Ani bialu Yagaba dameneru Gosene dindini anda íbu heagola ");
INSERT INTO hui_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yosebehanda ibunaga agali biabe bia haga hearuhondo lalu, Gosene dindini i̱ aba lola hole poliya i̱naga garo ale mini karisi mo manda manda bidaba, lene. Ani bialu Yosebe ibu puwa ibu aba wanakuiore handalu dugu timbuni luore biaho wini. ");
INSERT INTO hui_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Ani biyagola Yagabahanda Yosebehondo lalu, Áyu í̠ore homaribe toba harugo ndo henedago áyu hendedogo ai homaruyagua karulape kogoni, lene. ");
INSERT INTO hui_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Ani layagola Yosebehanda ibu hameneru ibu aba waneigini bu hearuhondo lalu, Ai áyu ogoni kinihondo i̱ aba hameneru tinaga dindi andaru Kenana dindi ngelo wahalu oali anda íbu ka lalu lamule porogo. ");
INSERT INTO hui_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Agali uruni ti nogo sibi hinaga howa ai tinaga mbirale wu hearu bibahende yalu ibai haya. Tinaga nogo bulumaga sibirubi bibahende haru ibiya lolebero. ");
INSERT INTO hui_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Ani larogola kini ibugua tíhondo, Biabe agi dege biaga kamibe, lalu hale hayagua ");
INSERT INTO hui_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","tígua ibuhondo ogodagua ladai bilimu, Agali haguane-o inanaga biabe nogo sibi bulumagaru hinaga kamagoni. Inanaga aba mamarume biagadagua inabi nde igiri emeneni howa biabe ogoni biaga kamagoni, lalimu. Tígua ani larimiyagua ibugua, Tí dindi Gosene ogoria halimu, lalu dindi ogo tí ngulebirago ani lalimu, lene. Yosebehanda ibu hameneruhondo ani lalimu layago irane Iyibi wali agali tigua agali nogo sibi hinaga karu handabe manga hagago manda buwa ani lene. ");
INSERT INTO hui_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Ani lalu Yosebe ibugua ibu hamene duriali kini hearia haru puwa kinihondo lalu, I̱ aba hameneru tinaga nogo tara tararu haru hai halu Kenana yu wahalu ibuwa ai Gosene dindini íbu ka, lene. ");
INSERT INTO hui_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Ani lowa Yosebe ibugua ibu hameneruhondo, Kininaga wanakuini íbu hadaba, lene. ");
INSERT INTO hui_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Ani íbu heagola kini ibugua tihondo hale halu, Tí biabe agile dege biaga kamibe, lene. Ani layagola igiri biarume ladai bialu lalu, Inanaga agali haguane-o inanaga aba mamarume biagadagua inamebi nogo sibiru hinaramali. ");
INSERT INTO hui_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Ai ina dalu Kenanaha hina gari timbuni biyagome ina habe naheyagola oali íbu kamago. Inanaga sibiru tibi nde tani nolene nahe degego. Ai hina gari piai kagola inane dalu dai bulego í̠na karulape lariyagua nde ina dindi Gosene ogoriani holene hame ledama, lene. ");
INSERT INTO hui_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Ani layagola kini ibugua Yosebehondo lalu, Ai í̠ hameneru í̠ni haru mandagi hole ibiyadagonigo ");
INSERT INTO hui_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","í̠nime Iyibi dindi bibahendeha manda beregola ti holene karulape mbira wiagua dindi ogoriani ti hole pudaba labe. Ti Gosene dindini berelo hame lariyaguabi nde ogoni karulape dege. Ani bialu agali uruni mbirago ibu nogo bulumaga hinaga mandabi heagua nde ogoni ibugua i̱naga nogo bulumagaru hinalu helo hame ledogoni, lene. ");
INSERT INTO hui_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Ani layagola Yosebehanda ibu aba kini hearia haru ibiyagola Yagabahanda kini mo bila hene. ");
INSERT INTO hui_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Ani biyagola kini ibugua Yagabahondo hale howa, Í̠ áyu mali agira hene kegonibe, lene. ");
INSERT INTO hui_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Ani layagola Yagabahanda ladai bialu lalu, I̱ dindi ogoria hewane dege mali handari mbirani pira tebira (130) hangu piyago. Ogoni mali lu ndo howa genda dewaore yidogoni. I̱naga mamaliru tigua i̱ bolangua halu ti mali dewore hene, lene. ");
INSERT INTO hui_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Ani lalu te lai halu Yagaba ibugua kinihondo lalu, Hondo birabe, lalu ibu tagira pene. ");
INSERT INTO hui_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Mani Yosebe ibu kinihanda layadagua bialu ibu aba hameneru Iyibi dindi helo mo tiga biai hene. Ti Lamese tano dindi mbira Gosene dindiha winigo ogoniha nogo hinulene bayale dataniru dewa buhe Iyibi dindi maruha wiarubi ndo dindi ogoni bayaleore wiago hondowa ti ogoriani helo walia hene. ");
INSERT INTO hui_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Ani íbu heagola Yosebehanda ibu ababi ibu hamenerubi tinaga one waneiginiru ti tomo nelo karulapeore mialu baya hanguore handaya ho hene. ");
INSERT INTO hui_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Hina gari timbuniore piyagola dindi bibahendeha tomo nolene emeneorebi mbira nawi hene. Hina gari ogonime Kenana wali agalibi Iyibi wali agalibi kirabali mo ko hene. ");
INSERT INTO hui_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Ani biyagola Iyibi wali agali hearubi Kenana wali agali hearubi tigua tinaga muni emene wiago tomo anda Yosebehanda hondo hayagoha yalu ibalu tomo yolo bigi biyagola tinaga muni bibahende biba hene. Muni uruni Yosebe ibugua mo yuwa kini andagaha ngelaga bini. ");
INSERT INTO hui_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Ani bialu Iyibi wali agalibi Kenana wali agalibi tinaga muni bibahende bibaore hayagola Iyibi wali agali tigua Yosebe hearia puwa lalu, Ai nde í̠na ina tomo hangu bame ngibelo ibirima. Inanaga muni bibahendeore tomo yolo biai harimagola ai nawiore kamago. Ina tomo noloma̱ya nangiriyagua nde í̠naga deni ina homai haramagoni, lene. ");
INSERT INTO hui_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Ani larimigola Yosebehanda tihondo lalu, Tínaga muni biba hayagua nde tínaga nogo tara tara hinu kamirume tomo yolo bule haru ibalimu, lene. ");
INSERT INTO hui_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Ani layagola wali agali tinaga nogo hosi sibiru memeru bulumagaru dongiru bibahende haru halu Yosebe hearia puwa tomo yolo bu naga bialu hemiria dege mali mbira pene. ");
INSERT INTO hui_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Mali mbira piai hayagola tigua Yosebe hearia lone ibuwa lalu, Agali haguane-o ina genda timbuniore yu kamagoni. Inanaga muni bibahendebi inanaga nogo tara tara bibahendebi í̠ ngiai harimago ai nde mbirale yu wahene mbira í̠hondo ngulene nayiore kamagoni. Inanaga dindibi inane wali agalirubi uruni hangu yuwa kamagonidago ");
INSERT INTO hui_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","ai ina wali agali homoloma̱ya wahariyagua nde inanaga dindi mo koore holobadago. Ai wahalu inane kini ibunime tomo ngialu handaya ho helonaga ina bibahende ibunaga biabe bia haga holeberama. Inanaga dindibi kini ibu hai helo. Anigo aiore ina tomo nolene egene heba ngiaore bia. Ina tomo egene ngeregola inane homa nabi howa inanaga dindi ogobi mo ko naholebira, lene. ");
INSERT INTO hui_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Horo hina gari piyadagoningi howa Yosebehanda Iyibi wali agalinaga dindi wiaru bibahendeore yolo biai howa kininaga mo ngelai hene. ");
INSERT INTO hui_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Ani buwa Yosebehanda wali agali bibahende kininaga garabaya biabe ale bia haga helo helai hene. ");
INSERT INTO hui_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Anigo loma binigo mo miaga hearunaga dindi dege yolo nabi muni kinihanda bame migi biyagola ti tomo ogonime yolo bu naga bialu hene. ");
INSERT INTO hui_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Ani buwa Yosebehanda wali agalihondo lalu, Hale hadaba. Áyu tínibi tínaga dindi ngamirubi bibahende munime yolo biai harugoni. Ai áyu tí wali agali kininaga biabe bia haga kamigonigo tomo egene o ngaru mo yalu mabuha hongole pudaba. ");
INSERT INTO hui_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Tomo hangaramigo boga biragola buyu mogobu ngelowa dau halu tale bilimu. Tale buwa daunigo kini mialu maria tíni howa lini maru mani hongole egene ngelalu maru tí one waneigini heba tíni nole ngelalimu, lene. ");
INSERT INTO hui_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Ani layagola wali agali tigua lalu, Agali haguane-o í̠na inahondo biamogo timbuniore buwa ina homa nabi helaregonagabi ina kininaga biabe bia haga holoma̱ya henge ngeledogonagabi í̠hondo ka̱i̱ore laramagoni, lene. ");
INSERT INTO hui_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Ani buwa Yosebehanda mana mbira ogobi wabu wini. Wali agali bibahende ti mabuha tomo boga bialu nolene tu haragola buyu ngoai howa dau halu tale buwa daunigo kini mulene nga, lalu lo winigo áyu wiaabo ka. Loma binigo mo miaga agali biarunaga dindi dege yolo nabi tini helo wahene. ");
INSERT INTO hui_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Isaraele wali agali biarume ti dindi Goseneha mialu ogoniha hene. Ani howa waneigini dewaore hono wialu ti ho damebi dewaore hene. ");
INSERT INTO hui_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yagaba ibu mali pira mbirani karia (17) Iyibi dindi pu hene. Ibunaga mali lamaga halu handari mbira pira mariani karia (147) hene. ");
INSERT INTO hui_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Ani howa ibu homolene tu kaware harudalo manda bialu ibu igini Yosebe íbu lowa bi ogodagua lamini. Í̠na i̱hondo gubalini howa keyagua nde í̠naga gi i̱naga ge dulini yaniho biruwa i̱hondo mana bayale ogonidagua bule lalu bi mbira hongohe i̱ Iyibi dindini hora nahole lalu áyu lo wia. ");
INSERT INTO hui_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Ai i̱naga de mugulalu i̱naga mamaliru heba mandagi hole porogola i̱naga tingini Iyibi dindi wahalu i̱ni aba mamaru hora haga wiyagoria hora hole yalu dai bibe, lene. Ani layagola Yosebe ibugua, Nde i̱na aniore biagua, lalu ladai bini. ");
INSERT INTO hui_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Yagabahanda lone lalu, Í̠na heneneore ani bule lalu bi heneneore la, lene. Yosebehanda, Heneneore larogoni lalu aniore bulebero, layagola Yagaba ibugua Yosebehondo, Turuore ko, lowa walia halu ibu dagiani biruwa ma podalu bulu palene. ");
INSERT INTO hui_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Yosebe ibu emene howa hale halu hearia ibu aba warago bo nga layago hale hene. Ani laya handala ibu igini kirali Manase Eberaimila haru halu ibu aba Yagaba hondole pene. ");
INSERT INTO hui_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Piyagola agali maru hearume Yagabahondo lalu, Í̠ igini Yosebe ibu í̠ warago bo ngego hondole ibiragoni, lene. Ani layago hale howa Yagaba ibu heyulene hongo emene hayagola ibuni heyuwa dagiani berene. ");
INSERT INTO hui_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Yagaba ibugua ani heyu biruwa Yosebehondo lalu, Ngode Datagaliwabe Hongo Haiheore ibuni i̱ Kenana dindiha tano emene Lusi ngagoria hewaria ibuwa bi galone mbira langialu lalu, Í̠ biamogo bialu mo bayale holebero, layagoni. ");
INSERT INTO hui_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Ibugua ogodagua laya, I̱na waneigini dewaore ngulebero. Ani berogola í̠ aguanene dewaore daga labe nahe holebira. Dindi ogo tihondo merogola tinaga dindi ogoniore wiaabo holebira, laya lene. ");
INSERT INTO hui_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Yagaba ibugua laho wialu lalu, I̱ Iyibi dindi naibi hewaha í̠ one ibugua igiri kira taba hanayadago. Ai ogoni labo i̱ iginiore haradagua holebira. Eberaimi Manasela i̱ni iginiore Lubene Simionola baba ogobi dege dege holebira. ");
INSERT INTO hui_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Anigo í̠ waneigini mani holebiraru ti í̠ninaga holebira. Ani howa mani tini hameiginiru dege dege dindi tu wa ta holene wiragola waneigini maru ti Eberaimi Manasela libu dagalalu tale biragola tigua tinaga hamene wahene Eberaimi Manaselanaga erembiraha holebira. ");
INSERT INTO hui_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","I̱na áyu bi larogoni í̠ ai̱ya Leseloore mitangi bialu dara ho haabo kogonaga laro. I̱ Mesobodemia wahalu Kenana dindi íbu dai bule harigani ibalu hemaria homaya. I̱na dindi emene mbira Eberada winigo anda ibule dege ibalu hemaria homayagola dindi Eberada ogoni kawareni dege hora kama, lalu lene. Áyu dindi Bedeleheme ngagoni abale Eberada laga wini. ");
INSERT INTO hui_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Ani lowa Yagaba ibugua handalu hearia igiri emene kirali Yosebe igini biagolabo hondowa lalu, Igiri emene ogolabo ai iginibe, lalu Yosebehondo hale hene. ");
INSERT INTO hui_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Ani hale hayagola Yosebehanda ladai bialu lalu, Ogonilabo i̱ igini. Iyibi dindiha hewaria Ngode Datagaliwabehanda ngiya, lene. Ani layagola Yagabahanda lalu, I̱na Ngode Datagaliwabehondo libuore biamogo bialu mo bayale habe lalu bi laholiya i̱ bedogoria kaware haru íbu, lene. ");
INSERT INTO hui_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Yagaba ibuni nde waheore biruwa ibugua mbirale deme baya hangu handabe nahe berene. Ani bereagola Yosebehanda ibu igini biagolabo Yagaba bereagoria kaware haru ibini. Haru íbu heleagola Yagaba ibugua igiri biagolabo yania howa nu̱nu̱ lalu howa ");
INSERT INTO hui_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Yosebehondo lalu, Abale howa i̱na í̠ wanakui nahondoleda mandabu henego. Ai áyu í̠nibi í̠ igini kirali ogolabobi handaore buliya Ngode Datagaliwabehanda henge ngiyada, lene. ");
INSERT INTO hui_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Ani leagola Yosebehanda igiri emene biagolabo Yagabanaga bani berenego minu yamialu dindini helene. Helowa Yosebe ibu abanaga mini yaraga halu ibu ma podalu dindini bulu palene. ");
INSERT INTO hui_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Yosebe ibugua ani bialu ibu igini Manase Yagabanaga gi tigahayagi helalu Eberaimi gi lehayagi helo Yagaba bereagoria kaware helene. ");
INSERT INTO hui_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Ani biyagoyu Yagabahanda ibunaga gi wia iriari buwa gi tiga heyogone Eberaiminaga haguaneni wialu gi le wahene Manasenaga haguaneni wia aribia hene. ");
INSERT INTO hui_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Ani buwa Yagaba ibugua Yosebenaga damene Ngode Datagaliwabehanda mo bayale helo bi lahalu howa lalu, Ngode Datagaliwabe-o i̱ mama Abarahamahandabi i̱ aba Aisagahandabi libu harume í̠ andanehaore hayagoni. Ai i̱bi nde i̱ ai̱yahanda taba hanayangi howa í̠na baya hanguore handaya ho hama ibirigoni. ");
INSERT INTO hui_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Í̠na dahuliyali ibiradagua bialu i̱ ko gendabi wiagoha pu hewaria haru dai birigonigo áyu igiri ogolabo libunaga waneigini aguaneneru dewaore helo libu mo bayale habe. Mani holebirarume Abarahama Aisagalanaga minibi i̱ninaga minibi ereba nahe manda biaabo helonaga aniore bibe, lalu Yagabahanda lene. ");
INSERT INTO hui_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Yosebe ibu handalu hearia Yagabahanda ibunaga gi tiga Eberaiminaga haguaneni wialu gi le Manasenaga haguaneni wiyagola ogoni nakarulapeda manda buwa ibu abanaga gi tiga yamuwa Manasenaga haguaneni wialu howa ");
INSERT INTO hui_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","ibu abahondo lalu, Aba-o ogonidagua ndo. Igiri ogo ibu wahenego í̠naga gi tiga ibunaga haguaneni wulene karulape, lene. ");
INSERT INTO hui_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Ani layagola ibu abahanda ogonidagua bulene hame nale biruwa Yosebehondo lalu, Igini-o ogoni i̱ manda bidogoni. Mani howa Manase ibu waneigini dewa dege holebiragoyu ibu hamene heyogone ogo ibunaga waneigini aguanene dewaore howa Manase waneigini ho bolangua holebira. Ani howa wali agali dewaore dindi maru ngaruha karubi dege holebira, lalu Yagabahanda lene. ");
INSERT INTO hui_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Yagaba ibugua igiri biagolabo Ngode Datagaliwabehanda libu mo bayale helonaga bi lalu howa lalu, Isaraele wali agalirume Ngode Datagaliwabehondo ti mo bayale helonaga bi lalu howa libunaga minini lalu ogodagua lolebira. Ngode Datagaliwabe-o í̠na bamba Eberaimi Manasela mo bayale harigodagua áyu urubi nde ani dege bibe lolebira, lene. Yagabahanda anidagua lalu howa Eberaimi mo bamba halu wahene Manase mo maha helene. ");
INSERT INTO hui_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Ani buwa mani Yagabahanda Yosebehondo lalu, Hale ha. Ai i̱ áyu dege homole bedogoni. Anigo Ngode Datagaliwabe ibugua tí biamogo bialu tí baba mandagi haabo halu tíninaga dindi haru dai bulebirago laro. ");
INSERT INTO hui_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Dindi baya gibiore Segeme tanoha ngago i̱na abale Amoroaliru baba ayu tibu danda timurume wai buwa dindi ogoni i̱ karulenego ai dindi bayale ogoni í̠ hamene maru karu wahalu í̠ hangu ngerogoni, lene. ");
INSERT INTO hui_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Yagabahanda ibu iginiru olalu ibidaba lowa tihondo bi ogodagua lene. Tí ogobiore holeberemi lalu languliya i̱ bedogoria kaware íbu hapara hadaba. ");
INSERT INTO hui_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Ai Yagaba iginiru-o tígua tí aba Isaraele i̱na bi áyu larogoore baya hangu hale hadaba, lene. ");
INSERT INTO hui_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ai Lubene í̠ore i̱ni huliya igirini hono wini wahene howa í̠ agali timbuni gibi halu i̱ igini maru hongohe karubi ndo í̠na ti bolangua halu hongo gibiorehe kegoni. ");
INSERT INTO hui_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Mana í̠na berego hongohe agali mendealime hapai habe nahe iba li ale holebere. Anigo í̠ waheneme holene henge ngagoria naholebere. Mana í̠na í̠ aba one haru paliriyagome i̱ kogoha mana tiga nabi taga holene mo yu anda ibiriyago lehe biriyagoni. ");
INSERT INTO hui_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simiono Libaila libu hamenela kabigoni. Libugua danda timu abale gilila mialu mendeali kago balu wai bule abale tungu laga. ");
INSERT INTO hui_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Libugua ogonidagua bule bialu kagola i̱nime libu heba mini mbiraore nahe halu ogoni karulape bidabida nalolebero. Ani larogoni tene libugua keba ho kabingi agali abale homelo balu turu ho kabingi nogo bulumaganaga ge minu libulaki hagayago. ");
INSERT INTO hui_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Libuha keba holene daligaore wialu tandaga harabigome libuni bo waholene wulebira. Ani bilodago i̱na libu Isaraele dindini wali agali karuha hopebe bu helo helarogoni. ");
INSERT INTO hui_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Ai Yuda-o í̠ nde í̠ hamene karume í̠naga mini yaraga holebira. Í̠naga waitigi bu karu mani minuwa balu kegola í̠ hamene maru karume ibuwa í̠ni deni tinaga ma podalu bulu paligi bialu holebira. mini ");
INSERT INTO hui_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Yuda ibu pudi gabua laiono hungubalua ale kagoni. Ibugua nogo tara tara balu nowa hongo howa hagadagua kagoni. Ibu emaru nabi laionome biragadagua hendore damboya bedagola agali mbirame ibunaga deni howa mine naholebiraore. ");
INSERT INTO hui_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Ibugua handame haga kini manda bialu yaga halimbu ngago yu biruwa ibu kini haabo holebira. Ibu agali mini lene dege haho wialu Silo dindi anda puwa wali agali bibahende handame ho holebira. ");
INSERT INTO hui_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Ibugua ibunaga pu mini gerebi lini dagane dewaore howa ibunaga nogo dongi dariba hole howa ira ogoni bayaleni dariba holebira. Ibunaga waini iba dewaore hambu bila kagola agalime nai habe nahe bu payabu wulebira. Ani wiragola ibugua ibuninaga agaru waini ibaneha wayawaya bulebira. ");
INSERT INTO hui_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Ibu waini iba dewaore naga kalo mandabi ibunaga de daramabi halu nogo bulumaga andu ibane dewa naga kalo mandabi ibunaga ne peleore holebira, lene. ");
INSERT INTO hui_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Sebulunu ibu iba solowara timbuni bedago angeni iba sibiru anda ibulene henge bayale wialu bidagoha holebira. Ani bialu ibula dindi tubaria amuraore puabo halu Saidono tanoni wulebira. ");
INSERT INTO hui_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isaga ibu nogo dongi hongohe ale howa ibuni nu dabudabu ngaru dombeneha yamo palima ibagabu holebira. ");
INSERT INTO hui_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Ani howa mani handalu karia ibunaga dindini mbirale anda habe nahedane hondowa tomo hongole biabe hongo howaore bialu holebirago. Ani bialu howa mani agali mendenaga garabaya biabe ale erekuibi ndelaheore bia halu holebira, lene. ");
INSERT INTO hui_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dana ibugua ibunaga wali agali baya hangu handaya ho kagola ti Isaraele wali agali maru karubi dege holebira. ");
INSERT INTO hui_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Ani howa ibu nogombi ko ale howa hariga gibunini bedaria agali nogo hosini biralu ibiragola harigani yu berenego abale porabu tagi howa nogo hosinaga ge ayundeni hayulebira. Hayaragola hosi mogo laragome agali nogo hosini biralu ibiyago mo para holebira. ");
INSERT INTO hui_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Anduane Homogo-o í̠na i̱ biamogo bialu gini ngibelo kogoni. ");
INSERT INTO hui_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gada í̠ baba pageali karume wai bule ibalu karia í̠na wai hongo howa bialu ti bo talu pelolebere. ");
INSERT INTO hui_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Ase í̠ daluha dindi bayaleni tomo dewa anda holebira. Anda haragola í̠na tomo bayale ngabiore handame haga kinime gubalini hagagobiore dawa wigi bulebere. ");
INSERT INTO hui_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Nabadali í̠ nogo meme ale mini dia gabua ibunime hoa hagadagua hopebe bu howa igini baya dege degeru honoyu hagadagua holebere. ");
INSERT INTO hui_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Yosebe ibu pu mbira gerebi lini dagane iba angeni dindi bayale ngagoria howa lini dewa do hagagobi holebira. Ani howa gene maganerume yuluyu pialu gana paberu dambi holebira. ");
INSERT INTO hui_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Agali danda timu yuwa wai biaga karume hongo howa Yosebela wai bialu mo koore halu holebira. ");
INSERT INTO hui_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Ani holebiragoyu Yosebe ibunaga danda hibuni gede nahe hongo haho wiaabo holebira. Yagabanaga Ngode Datagaliwabe Hongo Gibihe kagome ibu mo hongo haragola Yosebenaga gi hongo emeneorebi ibira naholebira. Ngode Datagaliwabe ogoni ibu Isaraele wali agali tinaga bira do hagane anda wia do hene ale ngelo kagola ibugua ti handaya ho haga ka. ");
INSERT INTO hui_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Í̠ abanaga Ngode Datagaliwabe ogoni íbu howa ibu Hongo Haiheore kago ibugua hangu í̠ biamogo bialu mo bayale halu mbirale bayale dege ngaru ngiaga kagoni. Ibugua dege hariha howa iba dalu ibilalu dindiha howa iba dewa dugua dagadaga bilaga kagoni. Ibugua í̠naga aguanenerume waneigini dewaore taba henelo ngulebira. ");
INSERT INTO hui_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Ai Yosebe-o i̱ni í̠ abahandaore larogo. Áyu í̠ biamogo bialu bayale habelonaga bi larogo heneneore mbirale bayale ngaru bibahende mibelonaga larogoni. Í̠na dewa aulolebe tobehe dewa dege lalu abale í̠naga mamalirume yu henegobi ndo dewaore hari wedaru bolangua howa yu habelo hame ledo. Ai Yosebe í̠ni hamene karunaga agali haguane mini lene í̠ni kegonidago. Bi áyu laruruni heneneore í̠na mo yai habelo larugoni. ");
INSERT INTO hui_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Beniyamini ibu biango dudu timbuni ale mbira howa tia nogo egaru bo ngelowa egerebagi nalu birulebira. Ani buwa alendo ibugua mo yiniru talebu migi bialu holebira, lalu Yagabahanda lai hene. ");
INSERT INTO hui_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Isaraele hameigini homberia (12) biaru uruni. Ti aba Yagaba ibuni kaware dege homole biruwa ibu iginiruhondo bi lolene winigo ti hangu hanguhondo lamigi bini. ");
INSERT INTO hui_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Yagabahanda ibu iginiruhondo mani bulebirarunaga bi lai howa lalu, Tí lone ibidaba, lalu, Ai nde i̱ damene ala homayaru heba áyu dege tigi mbira hangu biralu mandagi hama pole bedogoni. Ani pedogola i̱naga tingini uyu Hidi hameigini Eberononaga dindini egeanda mbira ngago ogoniha i̱ dameneru hora hene biagoha yalu puwa ogoniha dege hora halimu. ");
INSERT INTO hui_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Egeanda ogoni Kenana dindiha dindi emene Mamere mbira ngago kaware ngelowa dege dindi emene mbira Magabela ngagoria egeanda kagoha homali ogoniha nga. Abarahamahanda ala egeanda ogoni ibuninaga homali ngelonaga yolo binigo nga. ");
INSERT INTO hui_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Homali ogoniha Abarahama hora halu ibu one Sarabi hora ka. Ani bialu Aisagabi ibu one Lebegabi ogoniha dege hora halu Liabi nde homayagola i̱na homali ogoniha dege ibu hora ko. ");
INSERT INTO hui_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Dindi ogoni Abarahama ibugua Hidi hameigini hearunaga wiaria yolo bini ngago ogoniha tígua i̱bi hora halimu, lalu Yagabahanda ani lene. ");
INSERT INTO hui_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Yagaba ibu bi urunidagua ibu iginiruhondo lai howa ibunaga ge dagiahayagi paulo yamialu homene. Homalu ibu damene ala homene biaru baba mandagi hora hole pene. ");
INSERT INTO hui_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Yosebe ibugua handalu hearia ibu aba homaore biyiyagola ibuni Yagaba tongolomu wiagoria palia paga howa ibu aba nu̱nu̱ lalu dugu bialu hene. ");
INSERT INTO hui_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Ani bialu mani Yosebe ibunaga anogoda hearume ibu abanaga tingini togo nabilo marasini tara ale wiaru ha̱i̱ hadaba layagola tigua ha̱i̱ howa ngelene. ");
INSERT INTO hui_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Agali homenenaga tingini bayale wiaabo helonaga marasini horo pira mariani (40) ha̱i̱ halu hagadagua Yagabanaga tinginibi nde anogoda biarume horo pira mariani (40) ha̱i̱ halu howa biai hene. Iyibi wali agali hearu tigua horo pira kariani (70) Yagaba dara howa dugu bialu hene. ");
INSERT INTO hui_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Dara howa dugu bialu duguandaru hai howa Yosebehanda kininaga agali haguane hearuhondo lalu, Aiore nde agaliru-o tígua kini bedaria puwa bi ogo lamule pudaba. Kinihondo agua lamilimu. ");
INSERT INTO hui_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Ai kini-o i̱ aba ibuni nahome biruwa i̱hondo ibunaga tingini Kenana dindi homali ibuni wabu ngagoria hora hole yalu dai buleore lalu bi heneneore la layagola i̱na e̱ aniore bule larugo. Ai i̱ aba hora halu dai bule poabe laya lalimu, lene. ");
INSERT INTO hui_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Kini ibugua Yosebenaga bi ogoni hale howa lalu, Karulapego ani bule í̠ abahondo bi lo wiridadagua bialu ibunaga tingini hora hole yalu pobe, lene. ");
INSERT INTO hui_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Ani laya handala Iyibi dindi howa agali haguane bibahendebi agali ami haru haga timbuni hearubi ti bibahende Yosebe heba Yagaba hora hole pene. ");
INSERT INTO hui_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Yosebe hamenerubi ti one waneiginirubi bibahendeore piai hene. Ti pialu howa tinaga nogo sibiru memeru bulumagaru dege waneigini emene galiru baba Gosene dindini helalu pene. ");
INSERT INTO hui_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Nogo hosime gili laga garo ale mini karisibi nogo hosi erekuninibi agali biralu wali agali dewaliore Yosebe heba pole pialu hene. ");
INSERT INTO hui_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Pialu dindi mbira Adada amu iba Yodana angeha ni tagira ibiragohayagi widi iraneru lini hondo ibira ibira bilo dagia mbira winiyagoria anda puwa dugu timbuniore agali homene dara howa dugu biagadaguaore bialu hene. Yosebe ibuni nde daraore howa horo karu dugu biaga wiadagua bialu hene. ");
INSERT INTO hui_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Kenana wali agali hearume handalu hearia Adada dindini wali agali bu hearu dara howa dugu bialu heago hondowa tigua lalu, Iyibi wali agalirume dara timbuni howa dugu bialu kagonida, lene. Ani lowa tigua dindi ogoni mini Abele Misiraimi wini. ");
INSERT INTO hui_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Yagaba igini biaru tigua ti abahanda layagoore talialu bilimu lenegodagua bialu ");
INSERT INTO hui_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Abarahama ibugua egeanda mbira ibuninaga homali helo dindi emene mbira mini Magabela Mamere dindi kaware ngelowa Kenana dindini winigo. Egeanda ogoni agali Eberono Hidi hameigini heneyagonaga winigo ogoni yolobu ngelenego. ");
INSERT INTO hui_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Ai Yosebehanda ibu aba egeanda ogoniha hora halu ibu hamenerubi wali agali ibu heba ibini biarubi ti bibahende Iyibi dindi dai bini. ");
INSERT INTO hui_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Ti aba homayagola Yosebe hamene biaru tigua bi ogodagua lalu hene. Abale iname Yosebehondo mana kagua dewa birimaruni áyu ibugua mo wiaho howa inaha biadai bule manda buligo agua bimabe, lalu hene. ");
INSERT INTO hui_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Ani lowa tigua Yosebe ibuni hearia bi mbira ogobi loyalu pelene. Tigua lalu, Ina aba ibuni nahome biruwa bi mbira inahondo langinigo yu kama. ");
INSERT INTO hui_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","Ibugua bi ogodagua laya. Aiore Yosebe í̠naga hamenerume í̠hondo koore timbuni biyaruni í̠na la nabi embeda halu pani biadai nabibe laro, laya. Ibugua ani layadagua áyu ina abanaga Ngode Datagaliwabenaga biabe biaga agali kamagonigo iname í̠hondo ko timbuni birimago la nabi embeda halu wahabelo hamelo kama, lene. Ani larimiyago Yosebe ibuni hale howa dugu bialu berene. ");
INSERT INTO hui_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Ani berearia ibu hamene biaru ti Yosebe bereagoria ibuwa ibunaga geha bulu palialu howa lalu, Ina bibahende í̠naga biabe bia haga haradagua bule ibirima, lene. ");
INSERT INTO hui_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Ani layagola Yosebehanda ladai bialu lalu, Tígua i̱hondo gi holeneore nawi. Tígua beramigo dabagane Ngode Datagaliwabe i̱ ndo kogoni. ");
INSERT INTO hui_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Henene tígua mini mo mbiraore howa i̱ mo ko hole bia ani birimigo nde mani wali agali bu karu homa nabilonaga Ngode Datagaliwabehanda henemane bero lalu tíha howa binigo ai ogo ale binida lalu tínime hendedamigoni. ");
INSERT INTO hui_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Anigo tígua gi holene nawi. Tínaga one waneiginirubi tínibi heba i̱na baya hanguore handaya ho holebero, lene. Ani laga bialu Yosebe ibugua ibu hameneru giho holigonaga ti gi nahe embedaho helo ibugua tinaga bu mini mo palia haga bialu hene. ");
INSERT INTO hui_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Yosebe ibu hameneru heba Iyibi dindini howa ibu ai̱yahanda taba hanayangi mali hama ibinigo ibunaga mali handari mbirani pira mbira (110) howa ibu homene. ");
INSERT INTO hui_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Ani nahome biruwa ibu igini Eberaimi igini aguanenerubi hendene. Ani bialu Manase igini Magia ibu iginirubi Yosebe berearia haru ibiyagola ibugua ibunaga pani berelaga bialu ibu aguaneneru hendene. ");
INSERT INTO hui_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Yosebehanda nahome howa ibu hameneruhondo lalu, Ainde i̱ áyu dege homole bedogonidago tí nde Ngode Datagaliwabehanda dindi ogoha kamigoni wahalu tínaga dindi bamba Abarahama Aisagalahondobi Yagabahondobi ngulebero lalu habo nalolene bi lo wiyagoria haru dai bulebira, lene. ");
INSERT INTO hui_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Ani lowa Yosebehanda Isaraele igini aguanene biaru ibidaba lowa tihondo lalu, Ai Ngode Datagaliwabehanda tí tíninaga dindi haru dai birangi i̱naga kuniru tíni heba yalu dai bule lalu bi heneneore hongohe ladaba, lene. ");
INSERT INTO hui_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Ani lalu Yosebe ibuni mali handari mbirani pira mbira (110) howa homene. Homayagola tingini togo nabilo marasini tara tararu ha̱i̱ howa mbogoyi mbiraha Iyibi dindini ngelo hene. ");
INSERT INTO hui_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Yagaba iginiru ti one waneigini heba Iyibi dindi pole Yagaba heba peneru uru. ");
INSERT INTO hui_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Lubene Simiono Libai Yuda ");
INSERT INTO hui_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isaga Sebulunu Beniyamini ");
INSERT INTO hui_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dana Nabadali Gada Ase imaru pene. ");
INSERT INTO hui_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Wali agali o penedaruni Yagaba ibunioreha howa tagira penego pira karia (70) pene. Ibu igini Yosebe ibu Iyibi dindi abale pu heaha ti mani pene. ");
INSERT INTO hui_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Ani pu howa Yosebe ibu hamenerubi wali agali dabane ogoni aria ti mandagi henerubi homai hene. ");
INSERT INTO hui_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Tini homalu tigua hono wiyagome Isaraele hameigini palene. Isaraele hameiginime hono tawe hama piyagola dewaore hapaya bialu Iyibi dindi ti dege ho namulene. ");
INSERT INTO hui_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Ani bialu heagola agali gahenge mbira Yosebe manda nabinime Iyibi wali agalinaga kini ho aribia hene. ");
INSERT INTO hui_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Ani howa ibugua ibunaga Iyibi wali agalihondo lalu, Isaraele wali agali o íbu karuni ti hongo gibihe ina dindi wirimagoni ti dege dindi halu hapaya bidagome ina babehe hiriribi kama. ");
INSERT INTO hui_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Ina agali baba wai beramangi tigua ina napele ngulebira. Ti wai mendegoha anda puwa ina badai bialu dindi wahalu pole o íbu karuni. Ani bule kago manda buwa o karuni ti ho timbu halu ho dame nabilonaga iname mbira agi bibehedabe handami̱ya, lene. ");
INSERT INTO hui_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Ani lowa Iyibi wali agalime agali ko handabe mangabi wali agali garabaya biabe ale bilo mo miaga hearu dabowa urunime haru helo helene. Biabe wiarunime Isaraele wali agalinaga mini tinginibi bo gangu lelonaga biabe erekuibiore mo mini. Ani mo miyagola Isaraele wali agalime anda dewa buhe tano timbuni kira Pidomo Lamesela kini biago ibu dabudabu wilonaga bia hene. ");
INSERT INTO hui_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Iyibi wali agalime Isaraele wali agali hengedalu mo emene hole biyagola Isaraele wali agali ti ho dame biaho wialu Iyibi dindi wiagoriani ti dege ho yu lama pene. Ani biyagola hondowa Iyibi wali agali ti Isaraele wali agali handalu gi howa ");
INSERT INTO hui_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","14","Isaraele wali agali mo genda halu hengedapeore holenaga garabaya biabe ale koore mangabiru mo bia hene. Iyibi wali agali tinaga ege timeni andaru biaha mabu biaberu biaha bigi bilalu dara naheore garabaya biabe ale gibiru mo migi bini. ");
INSERT INTO hui_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Ani bialu howa Iyibinaga kini biagome wali kira Pua Sibarala libu Isaraele wali waneigini gali taba henelo biamogo biaga berenego ogonilabo lamialu lalu, ");
INSERT INTO hui_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","Isaraele wali gali taba henelo biamogo bigi berabingi igiri taba hanayagua bo wahaga bialu wandariyagua berelalibu lene. ");
INSERT INTO hui_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Ani lamiyagoyu wali biago libu Anduane Homogohondo giho biraga berenegome kini biagome layadagua nabi igiri taba hanaga biyago nabe wahene. ");
INSERT INTO hui_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Ani bira layago hale howa kini biagome wali biago labo hondo pudaba lowa ibiyagola libuhondo lalu, Igiri taba hanarago bo wahaga bilibu larugo nabe wahalu helaga biribiyago aginagabe, lene. ");
INSERT INTO hui_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Ani layagola libugua ladai bialu lalu, Hiburu waliru ti Iyibi wali ale ndo beda. Ti waneigini baya hanguore mbira mo ko nahe taba hanaga biaga. Iyame biamogo bule lowa pialu kabaria abale tini taba hono bedaria pugu berabali. ");
INSERT INTO hui_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","21","Wali gali biamogo biaga biagolabo libu Ngode Datagaliwabe ibuhondo gi howa mana tigabi bialu bereago hondowa Ngode Datagaliwabehanda libuhondo bayale bialu libuni nde waneigini helo biamogo bini. Ani bialu Isaraele wali agali ti timbuni halu hongohe hene. ");
INSERT INTO hui_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Aniore biyago hondowa kini biagome ibunaga wali agali bibahendehondo, O larogodaguaore bilimu, lowa lalu, Hiburu walime wandari taba hanarago berelowa igiri taba hanarago bibahende abale minuwa iba Nailiha bape halimu, lene. ");
INSERT INTO hui_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Odangi Libai hameigini aria agali mbirame Libai wali dege wali tagini mbira dabu bini. ");
INSERT INTO hui_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Dabu biyagola agalidagonaga igiri mbira taba henene. Taba honowa handalu hearia hulu igiri baya gibioreyagola taba hono do howa ege tebira berene. ");
INSERT INTO hui_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Ani biruwa handalu hearia taba hono doho biraabo habe naheyagola mbasigedi nu mbira dambe aleme bini wiago muwa iba anda polilono golodame hirame howa ndibu lene. Ani buwa igiri gali biago nu o biagoniha mo pale lowa dunduyame bu heagoha mo ngelene. ");
INSERT INTO hui_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Ani ngelowa igiri gali biago mbalini mbirame agi birabe hondole madia hondo hene. ");
INSERT INTO hui_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Ani madia hondo hearia kini wane mbira ibaha wayawaya bule ibini. Wandari maru ibunaga biabe biagaru ti iba angeange ibagabu hene. Kini wane biago ibu wayawaya bule lowa handalu hearia mbasigedi nu mbira ibu heagoha wiaria hondowa ibunaga biabe biaga wandari mbirahondo, Mo pu, lene. ");
INSERT INTO hui_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Mo yu ibiyagola panga duguwa handalu hearia igiri emene gali mbira dugu bialu wiago hondowa dara hene. Dara howa lalu, Igiri gali ogo Hiburu wali mbiragonagada, lene. ");
INSERT INTO hui_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Ani layagola igiri gali mbalini mbira madiahondo hayagome lalu, I̱na igiri gali ogoni mondo bia helo Hiburu wali mbira hondo poabe, lene. ");
INSERT INTO hui_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Ani layagola kini wane biagome ladai bialu, E̱ aniore bia, lene. Ani layagola wandari biagome puwa igiri gali biago ibuninaga ai̱ya haru ibini. ");
INSERT INTO hui_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Ibiyagola kini wane biagome wali biago lamialu lalu, Í̠na igiri gali ogo i̱naga mondo bia habe. Ani beregonaga i̱ yolo nguliya, lene. Ani layagola wali biagome ibu igini biago ibuni andu mialu mondo bini. ");
INSERT INTO hui_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Ani bialu howa mani igiri emene biago boga bialu wahe hayagola ibu ai̱yahanda kini wane biago berearia haru pene. Haru piyagola kini wane biagome ibuni iginiore mondo biradagua bini. Ani bialu howa manda bialu hearia igiri ogo ibaha wiaria gililo mirugodago ibu mini gililo mini lalu Mosese wibeheda manda buwa mini Mosese wini. ");
INSERT INTO hui_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Horo mbiru Mosese ibu igiri wahe heangi ibu aria Isaraele wali agali hearia nenege pene. Puwa handalu hearia ibunaga wali agaliru biabe erekuibi ndelaheore mo bia halu harayago hendene. Ani bialu Iyibiali mbirame Isaraeleali Mosese ibuni aria mbirago bo wahalu hearia de hendene. ");
INSERT INTO hui_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Ogoni biyago hondowa Mosese ibu ala handade̱le̱ bialu hearia mbirali naheyagola Iyibi agali biago bowa iba muha bo hora hene. ");
INSERT INTO hui_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Ogoni bialu puwa horo mendengi lone dai bialu hearia Isaraeleali labolabo kira gungu bialu hearia hendene. Hondowa agali mende kagua biniyagohondo lalu, Í̠ni aria ogo nde dara nahe aginaga minu barebe, lene. ");
INSERT INTO hui_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Ani layagola agali biagome ladai bialu lalu, Í̠na ogoria de hondo howa dabaki bule ibabe layadago aiwa. Abe Iyibiali biago bo waharigo ai áyu i̱ bo wahole íbu kebe, lene. Bi ogonidagua ladai biyago hale howa Mosese ibu gi howa ibuni minime lo manda bialu ai i̱na birugo wali agalime handa walia hayadago lo manda bini. ");
INSERT INTO hui_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","16","Mosesehanda ogonidagua biya layago hale howa Iyibinaga handame haga kini biagome Mosese bo wahole manda bini. Ani bialu heago hondowa Mosese ibu Midiana dindiha ibida pene. Pu howa horo mbiru Mosese ibu iba uli mbira wiagoria berearia Midiana dindinaga loma binigo mo miaga agali Yadero henego ogoni wane kariali berenego uruni ti iba nolenebi ti abanaga nogo sibi memerunagabi hambu yule lowa hambu ibini. ");
INSERT INTO hui_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Ibalu hearia nogo sibi haru haga agali tara maru hearume wandari biaru tali pelene. Tali pelalu hearia Mosesehanda heyuwa lalu, Ogoni nabidababe, lowa wandari biaru biamogo bialu tinaga nogo haru hearubi iba nelo ibugua dege hambu mini. ");
INSERT INTO hui_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Ani biya handala wandari biarume ti aba hearia dai bialu hemiria ti abahanda lalu, Tí eberamilidagua ndo áyunde abaleore ibirimidago agua birimibe, lene. ");
INSERT INTO hui_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Ani layagola tigua ladai bialu lalu, Nogo sibi haru haga hearume ina talima ibalu hearia Iyibiali mbirame ina biamogo biya. Ina biamogo bialu inanaga ibabi ibugua hambu ngialu inanaga nogo sibi memeru ibabi ibugua dege hambu ngiya, lene. ");
INSERT INTO hui_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Ani layagola Yaderohanda ibu wane biaruhondo lalu, Be-e áyu agalidago ibuni abiyabe. Agi bule helalu ibirimi. Tomo ina haru nami̱ya agalidago hondo pudaba, lene. ");
INSERT INTO hui_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Ani layagola tigua Mosese hondo puwa tomo ti haru mandagi nene. Tomo nalu Mosese ibu pu nabi o biagoria hearia dungu leneni Yaderola hadali hene. Hadali halu libu howa Yaderohanda ibu wane Sibora Mosese ibu dabu bilo mini. ");
INSERT INTO hui_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Miyagola wali biagome Mosesenaga igiri taba henene. Taba hanayagola Mosese ibuni manda bialu hearia ibu dindi tarali bame igiri yango íbu harugoda lo manda buwa ibu igini mini Gesomo wini. ");
INSERT INTO hui_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Mosese ibu uruni bialu heaha ege pu mali pu bigi biyagola Iyibi dindini kini hayago homene. Isaraele wali agali u̱lu̱ lalu garabaya biabe ale bialu genda hayagoni haabo howa Ngode Datagaliwabehondo biamogo bia lalu hene. Gendaho howa bi layago Ngode Datagaliwabe ibu hale hene. ");
INSERT INTO hui_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Hale howa ibugua Abarahama Aisaga Yagaba imaruhondo habo nalolene bi lo wigi biniru mitangi bini. ");
INSERT INTO hui_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Ani mitangi bialu Isaraele wali agali garabaya biabe ale darabi bialu heago hondowa ibugua ti mitangi bialu mandabu hene. ");
INSERT INTO hui_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Horo mbirungi Mosesehanda ibu imane Yaderonaga nogo sibi memeru haru halu dindi ko wali agali nahe wiagoria haru bolangua halu pialu Hari Sainai heagoria haru anda pene. Hari Sainai odago Ngode Datagaliwabenaga lowa loma bini hene. Ibu imane Yadero ibu Midiana dindinaga loma binigo mo miaga agali henego ogoninaga nogo sibi haru hene. ");
INSERT INTO hui_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Odagoriani haru hearia Anduane Homogonaga dahuliyalime ira emene heagonaga yuni maganeruha howa ira hungu datagi helene. Ani biyagola Mosese ibu hearia ira emene dombedene biagoha howa hungu biatagi hayagoyu ira denego hondole ndo dalu hearia de hendene. ");
INSERT INTO hui_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","De ogoni nde abu tobahedago agua binidabe. Ira dombeneha ogoni do mina nabi dalu kagoni aube tobahedago kaware hapara howa hondoliya lo manda bini. ");
INSERT INTO hui_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Ani manda buwa kaware hapara hole ibiyago hondowa Ngode Datagaliwabehanda ira hungu biagoha howa olalu, Mosese-o Mosese-o, lalu olene. Ani layagola Mosesehanda ladai bialu lalu, Yao i̱ o ko, lene. ");
INSERT INTO hui_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Ani layagola Ngode Datagaliwabehanda lalu, Kaware hapara nahe ogoriani hondoha. Í̠ dindi kegoriani Anduane Homogonaga loma bini kegonigo í̠ ge su hadalu wibe. ");
INSERT INTO hui_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","I̱ í̠ mamali Abarahama Aisaga Yagaba imarunaga Ngode Datagaliwabe kogoni, lene. Ani layago hale howa Mosese ibu Ngode Datagaliwabe de handaya helenego gi howa ibunaga dengui yi hene. ");
INSERT INTO hui_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Yi hayagola Anduane Homogohanda lalu, I̱naga wali agali Iyibi dindini garabaya biabe ale bilo mo miagane karume handabe manga halu mo ko howa kagoni hendedo. Mo ko howa haru haruagoni nahelo gi mia lalu dugu biayuago hale haru. Ti tandaga nalu kagoni ogobiore nara i̱ manda bido. ");
INSERT INTO hui_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Ani manda buwa i̱na ti gi mule Iyibi wali agali andaneha kago nahelo gi mialu Iyibi dindi wahalu haru tagira pialu polenaga i̱ dalipe ho ko. Haru tagira puwa dindi henge timbuniwi mbira tomo bayale anda holenenaga dindi homogoore dindi ogoni áyu Kenanali Hidiali Amoroali Pereseali Hibiali Yabusuali imaru hameigini uruni ti kagoria haru pu helolebero, lene. ");
INSERT INTO hui_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","I̱naga wali agalinaga dugu biyago hale haore bialu Iyibi wali agalime minu hengeda mbaralo wahalu kago i̱ hondo ko. ");
INSERT INTO hui_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Ani hendedogo ai Mosese í̠na Isaraele wali agali Iyibi dindi howa haru tagira pole í̠ áyu polebere, lene. ");
INSERT INTO hui_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Ani layagola Mosesehanda Ngode Datagaliwabehondo lalu, I̱ agali mbira abogo ka nalene kogo i̱ alegome kini kagoria puwa Isaraele wali agali Iyibi dindi howa haru tagira ibule au poledabe, lene. ");
INSERT INTO hui_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Ani layagola Ngode Datagaliwabehanda ladai bialu lalu, I̱na í̠ heba holebero. Isaraele wali agali Iyibi dindi howa haru tagira ibuwa hari o kagoria tígua i̱ mitangi bialu mo dunini howa lotu loleberami. Nde ogonidagua buleberamigo bialu howa i̱na heneneore biamogo bulenaga pu leneda lalu ogoningi manda bulebere, lene. ");
INSERT INTO hui_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Ani layagola Mosesehanda ladai bialu lalu, I̱na Isaraele wali agali kagoria puwa tihondo, Tí mamalinaga Ngode Datagaliwabe bamba heneyagome i̱ tí kamiria pu laya handala ibiru, larogola tigua odagoni ibu mini aibe lolebirago ani laragola ai laguadabe, lene. ");
INSERT INTO hui_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Ani layagola Ngode Datagaliwabehanda lalu, I̱ I̱ni Haluhe Henego Haabo Hole Kogoni. Mbirali mini I̱ Haluhe Kogo ibugua ti kamiria pu laya handala ibiru lamibe, lene. ");
INSERT INTO hui_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Isaraele wali agali lamialu au labe. Tínaga mamali Abarahama Aisaga Yagaba imaru heneyarunaga Anduane Homogo Ngode Datagaliwabehanda i̱ tí kamiria pu laya handala ibiru labe. I̱ mini wia̱i̱ a̱i̱ bulebirago o langirugoni. Wali agali dabane mani hararumebi i̱ mini ogoni dege lalu lolebira. ");
INSERT INTO hui_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Ani lolebirago i̱ pialu Isaraele wali agalinaga haru haga haguane karu mo ngoai howa ti mamali Abarahama Aisaga Yagaba imarunaga Anduane Homogo Ngode Datagaliwabe i̱ hewaria hapani haya lalu lamibe. Ibu ti hemiria ibalu Iyibi wali agalime tihondo bialu kagoni i̱ handaru laya lamibe. ");
INSERT INTO hui_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Ani hondowa Iyibi dindini howa mo tandaga gibi haragola tandaga naabo halu kamigo nanalimulo haru tagira pole manda biru laya lalu lamibe. Dindi Kenanali Hidiali Amoroali Pereseali Hibiali Yabusuali urunaga dindi ngagoria haru tagira polebero laya, labe. ");
INSERT INTO hui_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","I̱naga wali agalime í̠na tihondo bi larego hale holebirago lamibe. Wali agalihondo ani lamialu Isaraelenaga agali haguane hangu haru halu Iyibi dindinaga kini bedagoria puwa ibuhondo agua lamilimu. Anduane Homogo Hiburu wali agalinaga Ngode Datagaliwabe kagome ibuni inahondo hapani haya handala eberama. Ani beramago ina dindi ko wali agali nahaga ngagoria puwa inanaga Anduane Homogo Ngode Datagaliwabehondo mbirale bo delo muluma̱ya horo tebiru henge ngerebe lalimu, lene. ");
INSERT INTO hui_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Iyibinaga kini kagome tígua ani laramigo hale halu mo henene halu haru pudaba nalolebiralo manda bidogo menaga hangu hale halimu. ");
INSERT INTO hui_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Ani nale mini giambe harago hondowa i̱na i̱naga hongome mbirale hiriribiru bialu Iyibi wali agali pani merogo hondowa tí pudaba lolebira. ");
INSERT INTO hui_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Ani bialu Iyibi wali agali tigua Isaraele wali agali mo yo handabe nahedane hondolebira. Ani biragola i̱naga wali agali ti giha mbirale mbira nayiore natagira polebira. ");
INSERT INTO hui_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Ani nabi howa Isaraele wali hangu hangume Iyibi wali anda be mendeha padaruhondo ainde porogo agabi ngolobi silibabi mbira ngia naberego lalu hale holebira. Ani laragola Iyibi wali agalime bu hombedo miragola Isaraele wali agali ti mbirale uruni ti waneiginibi hombedo yalu Iyibinaga dabudabu bibahende ti hombedo yai halu polebira. ");
INSERT INTO hui_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Ani layagola Mosesehanda Anduane Homogohondo ladai bialu lalu, Ogoni karulapego Isaraele wali agalime i̱na bi lamerogo hale halu henene lara lowa yu tiga nabi bi lamerogobi hale hoa naholebira. Ani howa Anduane Homogo í̠ heria hapani haya laregoni ke̱ harego waha layagua i̱na agua laguadabe, lene. ");
INSERT INTO hui_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Ani layagola Anduane Homogohanda ibuhondo lalu, Í̠ giha o yidegoni agilebe, lene. I̱na gewa halimbu yido, ladai bini. ");
INSERT INTO hui_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Ani layagola Anduane Homogohanda lalu, Gewa halimbu ogoni dindini ibiraha, lene. Dindini ibira hayagola mo nogombi hene. Nogombi hayagola Mosese ibu gi howa ibida pene. ");
INSERT INTO hui_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Ibida piyagola Anduane Homogohanda Mosesehondo lalu, Bulu paluwa ereneni minuwa yamia, lene. Ani layadagua ereneni minayagola lone mo gewa halimbu hodai bini. ");
INSERT INTO hui_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Ani biyagola Anduane Homogohanda Mosesehondo lalu, Isaraele wali agalime Anduane Homogo ti mamali Abarahamabi Aisagabi Yagababi tinaga Ngode Datagaliwabe kago ibu í̠ heria hapani haya larego henene ani biyadalo hendelo manane ogoni walia habe, lalu lamini. ");
INSERT INTO hui_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Ani lowa Anduane Homogohanda Mosesehondo lone lalu, Í̠naga gi aga bidegoni pogediha gambira, lene. Mosese ibu hale halu layadagua gi pogediha gambirini. Gambiruwa yamialu hearia gi hamuabi ale pewele hari beraliba ale yamini. ");
INSERT INTO hui_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Ani biyagola Anduane Homogohanda Mosesehondo lalu, Ai í̠naga gi lone pogedi biagoha gambira, lene. Ani layagola gambiruwa yamialu hearia gi hamua ale biniyago nabi bayale tingini maru heagobi dege yamini. ");
INSERT INTO hui_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Ani biyagola Anduane Homogohanda Mosesehondo lalu, Isaraele wali agali tigua í̠na bi lamerego hale halu yu tiga nabiyaguabi nahendene ale hiriribi pigane biago berego hondowa miniha hiri nalayagua nahendene ale mende ogoni berego hondowa henene larida manda bulebira. ");
INSERT INTO hui_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Ai manane kira ogonilabo berego hondowabi ti miniha hiri nalole bi lameregobi hale habe manga dege hayagua o iba Naili porago hambu yuwa ti de hendelo dindini odope habe. Odope haregola iba ogoni mo darama holebira, lene. ");
INSERT INTO hui_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Ani layagola Mosesehanda lalu, Anduane Homogo-o i̱ ndogo pu nalabe. I̱ wali agali deni howa bi bayuwa nalene ko. Bi uruniale mbira i̱na lole kogoni lo mandabu henebi ndo ko. Bi bayuwa hege bebenabu nalaruli loa naloalo howa hendore laga biruli, lene. ");
INSERT INTO hui_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Ani layagola Anduane Homogohanda Mosesehondo lalu, Wali agalinaga ne hambu wabu heledagoni aiwabe. Wali agalinaga hale mo tuluha bi mo ndibula bigi biaganego aiwabe. Wali agalinaga de mo angalaha mo ndibula bigi biaganego aiwabe. Anduane Homogo i̱na ani biaga ndoyabe. ");
INSERT INTO hui_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Ani biruligo í̠ áyu ogoni pu. Bi ogo la lalubi i̱na dege langulebero, lene. ");
INSERT INTO hui_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Ani layagola Mosesehanda bi ladai bialu lalu, Anduane Homogo i̱ ndogo mbirali pu labe, lene. ");
INSERT INTO hui_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Ani ladai biyagola Anduane Homogohanda Mosesela keba howa lalu, Aniyagua í̠ hamene Arono Libaiali biago abiyabe, lene. Ibugua bi bayuwa lolebira lo manda bidogo. Arono ibuni í̠ keria ibule áyu ogoni harigani ibalu kago ibugua í̠ hondowa turu holebira, lene. ");
INSERT INTO hui_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Í̠na Aronohondo bi ogoale labiya kaba lalu ibuhondo lamibe. I̱na libu harume bi lalibulonaga biamogo bialu ogoale bidaba lalubi libu haru biamogo bulebero, lene. ");
INSERT INTO hui_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Í̠na bi endeho meregola Arono ibugua wali agali deni howa í̠na lolenegodagua lolebira. Í̠na Ngode Datagaliwabehanda lolenedagua ibuhondo ogoale labe lalu bi endeho migi berego yuwa ibugua lamigi bulebira. ");
INSERT INTO hui_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Ani buleberabigo gewa halimbu ogo yalu pobe ogonime agalime nabiagane ale hiriribi bigi buleberego giha ogoni yalu pobe, lene. ");
INSERT INTO hui_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Anduane Homogohanda ani lamiya handala Mosese ibuni ibu imane Yadero hearia dai buwa lalu, Imane-o ainde i̱ hameigini biaru Iyibi dindini bu hayago uruni kabe handama pole manda bidogo poabe, lene. Ani layagola Yaderohanda lalu, Nde abini mbiru handa degego pobe, lene. ");
INSERT INTO hui_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Mosese pole lo dege Midiana dindini hearia Anduane Homogohanda ibuhondo lalu, Agali í̠ bo wahole lowa tai bialu hayaruni bibahende homai hayago áyu í̠ Iyibi dindi dai bia, lene. ");
INSERT INTO hui_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Ani laya handala Mosesehanda ibu onebi ibu igini kira biago labobi nogo dongini berelalu ibuni giha Ngode Datagaliwabehanda halimbu yabe layago yalu Iyibi dindi pole pene. ");
INSERT INTO hui_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Pole piyagola Anduane Homogohanda Mosesehondo lone lalu, Iyibi dindi anda puwa kini kagonaga deni howa manane walia habelo hongo ngirugo yuwa manane biaruni bihende biai habe. Uruni berego hondowabi ibu miniha mogo lalu hiri nalelo ibunaga bu mini i̱na mo giambe holebero. Bu mini mo giambeore harogola i̱naga wali agali yupe halu pudaba nalolebira. ");
INSERT INTO hui_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Ani biragola í̠na kini ogonihondo lamialu, Anduane Homogohanda lalu, Isaraele ibu i̱naga igini wahene ale ndoyabe, laya labe. ");
INSERT INTO hui_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Anigo i̱ igini ibuni i̱ mitangi bialu mo dunini howa lotu lelo tagira pialu pela larugo napelolebero larigoni. Ani birigodago i̱na nde í̠ igini wahenego áyu barogoni laya, lalu lamibe. ");
INSERT INTO hui_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Ani laya handala hale halu Mosese ibu Iyibi pole pialu hariga handa paliagani palearia Anduane Homogo ibu puwa Mosese bo wahole bini. ");
INSERT INTO hui_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Ani biyagola Mosese ibuni one Siborahanda are ne gadele mbira muwa ibu igininaga dongone podowa Mosesenaga ge mbarianeni ela hene. ");
INSERT INTO hui_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Ela halu lalu, Darama ogonime iya mo bimaga kagola í̠ i̱ agalini kegoni, lene. Ani layagola Anduane Homogohanda Mosese ba nabi wahene. ");
INSERT INTO hui_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Ogoni bialu heaha Anduane Homogohanda Aronohondo lamialu, Mosese ibirago lola hole dindi ko wali agali nahe ngagoria pobe, lene. Ani layagola dindi ko wali agali nahe biagoria Arono ibu Mosese lola hole Ngode Datagaliwabenaga hari loma bini heagoria pialu hearia Mosese ibiyagola lola howa yu nu̱nu̱ lene. ");
INSERT INTO hui_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Ani buwa Mosese ibugua Aronohondo bi bibahende Anduane Homogohanda ibuhondo Iyibi dindi dai bia lalu lamiyago lamiai hene. Ani bialu Anduane Homogohanda manane maru Mosese ibugua bibe layagobi lamiai dege hene. ");
INSERT INTO hui_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Ani bialu Mosese Arono libu haru Iyibi dindi puwa Isaraele wali agalinaga agali haguane hearu mo ngoai hene. ");
INSERT INTO hui_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Mo ngoaiho helowa Arono ibugua Anduane Homogohanda Mosesehondo bi laminiyago bibahende agali biaruhondo lamiai hene. Lamialu howa Mosese ibugua wali agali bu hearu deni howa agalime nabiagane ale manane bibe laya ale bibahende biai hene. ");
INSERT INTO hui_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Uruni biyago hondowa wali agali biarume heneneda lowa mini mbiraore wiai hene. Wialu Anduane Homogo ibu ti hearia ibalu Iyibi wali agalime ti handabe mangaore howa haru kagoni de handaru laya lalu lamiyagola hale hene. Aniore layago hale howa ti bulu palialu Anduane Homogo mitangi bialu ibu mo dunini howa lotu lalu hene. ");
INSERT INTO hui_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Ani bialu halu Mosese Aronola libu Iyibinaga kini hearia puwa ibuhondo au lene. Anduane Homogo Isaraele wali agalinaga Ngode Datagaliwabe kagome lalu, I̱naga wali agalime dindi ko wali agali nahaga ngagoria puwa i̱naga mini yaraga helo áyu ogoni pudaba la, lene. ");
INSERT INTO hui_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Ani layagola kini biagome ladai bialu lalu, Anduane Homogo haruagoni aibe. I̱na ibunaga bi hale halu Isaraele wali agali pudaba larodago aginagabe. Anduane Homogo o haruadagoni i̱ manda nabidogo Isaraele wali agali pudaba nalolebero, lene. ");
INSERT INTO hui_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Ani layagola Mosese Aronolame ladai bialu lalu, Hiburu wali agalinaga Ngode Datagaliwabe ibuni iya hebaria hapani haya. Ani biyago inanaga Anduane Homogo Ngode Datagaliwabe kagohondo mbirale bo delo mule dindi ko wali agali nahaga ngagoria poloma̱ya horo tebiraore henge ngi. Iname anidagua nabirimayagua ibugua agali wai waragorume ina bo home lolebirago, lene. ");
INSERT INTO hui_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Ani layagola kini biagome Mosese Aronolahondo lalu, Ogoni wali agalime biabe birago hado wahelonaga hawa larabidago bi nale pudaba. Wali agali garabaya biabe ale bia haga o kamiruni biabe bule áyu ogoni pudaba. ");
INSERT INTO hui_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Iyibi wali agali kagobi ndo dindi o ngagoniha tí hangu paliame kamigo agua. Ani kamigo howa ai áyu biabe biari holenaga larimidago be, lene. ");
INSERT INTO hui_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Ani lowa horo odangiore kini biagome garabaya biabe ale hondo haga Iyibiali hearubi biabe haru haga Isaraele agali hearubihondo lamialu au lene. ");
INSERT INTO hui_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","Ibugua lalu, Isaraele wali agali ege timeni wabilonaga tani yobi meramilidagua yawi namilimu. Tini mbirani taya bima pialu mo yu ibilo nami wahalimu, lene. ");
INSERT INTO hui_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Ai biabenaga mbira gadia dai buwa ndo ege timeni o wabiralidaguaore bilo bidaba lalimu. Áyu tinaga Ngode Datagaliwabe kagoria puwa mbirale bo delo mule poloma̱ya henge ngi lalu i̱hondo hale haabo halu kagoni irane biabe mo mirugo emene hameleyane ai maru mo tagoha layadago mo tago harogoni. ");
INSERT INTO hui_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Agali karuni biabe erekuibiore bilo mo mialu mbirali bame holani. Agalime dugu tindule lama ibuwa o lalu kago hale haganego biabeniore helai halimu, lene. ");
INSERT INTO hui_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Ani layagola garabaya biabe ale hondo hagabi Isaraelenaga haru hagabi tigua puwa Isaraele wali agalihondo lalu, Kini ibugua tí ege timeni wabilimulonaga tani yobi ngirulidagua ai nangulebero laya. Nanguleberogo ti ege timeninaga mbira gadu wanahe waberamilidaguaore wabuleberami laya. ");
INSERT INTO hui_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Ani bulenaga tani biagoni ale tínime tai bima ibaga bialu mo yalu ibuwa bulene ngago ege timeni mbira gadu wanahe daga ngirudaguaore wabuleberami laya, lene. ");
INSERT INTO hui_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Ani laya handala Isaraele wali agali biaru Iyibi dindiha pume halu tani yobi biago taya bima pugu pugu bini. ");
INSERT INTO hui_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Ani bialu Iyibiali garabaya biabe ale hondo haga biarume biabe gendabiore mo bia halu tani yobi kini biagome miyagola wabiyadagua dege tani yobi tinime taya bialu ogonidagua dege wabilo mo bia haabo halu hene. ");
INSERT INTO hui_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Ani bialu Iyibi garabaya biabe ale hondo haga hearume Isaraeleali tini aria haru helo maru dabo helayaru minu baga bini. Minu baga bialu howa lalu, Tínaga wali agalime ege timeni ala wabiralidagua ndo áyu mani emene wabiragoni agua binidabe tígua langi handadaba, laga bialu baga bini. ");
INSERT INTO hui_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Ani bigi biya handala Isaraeleali tini yangone de hondo helo dabo helene biarume kini heagoria puwa genda heagobi agua lamini. Inanaga kini daligaore í̠ kego inahondo tandagabi o bialu kegoni aginaga berebe, lene. ");
INSERT INTO hui_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Ina tani yobi biago nangi inaneme taya bialu bilimu lariyago lalu ege timeni mbira gadia dai nabi howa waberamilidaguaore bilimu lalu kago ogonidagua karulapedabe. Ogonidagua wa nabirimida lowa ina minu baga bialu kagoni mana liahe kini í̠naga agalime inahondo bialu kagoni, lene. ");
INSERT INTO hui_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Ani layagola kini biagome ladai bialu lalu, Ogoni ke̱ ti mangani biabe nabulenaga bi larimidago. Tínaga Anduane Homogohondo mbirale bo delo mule poramabe lowa hale harimigo tindule biabe manganiore larimida mandabu kogoni, lene. ");
INSERT INTO hui_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Bayuwa birimidago áyu ogoni biabe bule dai bidaba. Tani yobi ngirudagua nanguleberogoyu ege timeni waberamilidaguaore wabulene nga, lene. ");
INSERT INTO hui_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Ani layago hale howa Isaraeleali haru haga biarume ai hiriribioreni harimada lo manda bini. Horo bibahendengi ege timeni mbira gadu wanahe waberamilidaguaore wabilimu layago hale howa ai hiriribini harimada lo manda bima pene. ");
INSERT INTO hui_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Pole pialu hearia Mosese Aronola ti ibilonaga hondo hearia pene. ");
INSERT INTO hui_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Libu hearia puwa tigua libuhondo lalu, Libugua bi o lama ibiribigonime hawa ina belonaga kinibi ibunaga biabe biaga karumebi ina belonaga minu miradagua biribiyago. Libugua o biribigoni Anduane Homogo ibugua hendedago ibugua libu pani ngulebira. Ibugua ina irane agini boabe tabaho hayago ai irane libugua mo miribigoriani geho howa ina bo waholebira, lene. ");
INSERT INTO hui_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Ani layagola Mosesehanda Ngode Datagaliwabehondo lalu, Í̠naga wali agali mo genda haregoni agonaga berebe. Í̠na i̱ wali agali uru hearia pu larigoni aginaga laribe. ");
INSERT INTO hui_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Kini biago hearia puwa í̠na langiridagua lamule pirungi howa ibugua wali agaliruhondo handabe manga howa kebabi dege biaabo haya. Ani biyago hondowa í̠na ti mbira biamogo bule manda nabi í̠ handayaho kegoni, lene. ");
INSERT INTO hui_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Ani layagola Anduane Homogohanda Mosesehondo lalu, Ai i̱na kini ogonihondo bigi berogo hondolebere. I̱naga wali agali tagira pialu pelo i̱ninaga hongome he̱latagi halu pudaba lolebero. Iyibi dindi wahalu pudaba lelonaga i̱ninaga hongome mo bia holebero, lene. ");
INSERT INTO hui_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Ani lowa Ngode Datagaliwabehanda Mosese lamialu lalu, I̱ Anduane Homogo kogoni. ");
INSERT INTO hui_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Abarahamabi Aisagabi Yagababi hearia hapani haga birugoni. Ani bialu harugoni i̱ Ngode Datagaliwabe Hongo Haiheore Ko, lalu hapani haga birugoni. Ai i̱ninaga mini baya burugule Anduane Homogo kogoni ti manda bilo mo walia nahene ko. ");
INSERT INTO hui_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","I̱na ti baba habo nalolene bi lowialu Kenana dindi ti bai nale haluni hameigini tara dindini kamigoni ti dindi teneore ogoni buhinu halimulo ngulebero lowini ngo, lene. ");
INSERT INTO hui_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Ai áyu Isaraele wali agaliru Iyibiali tigua tinaga garabaya biabe ale biahe layago bialu howa tandaga howa u̱lu̱ lalu haabo hayuago i̱ hale haru. Hale howa habo nalolene bi ala lo wirudagoni mitangi biru. ");
INSERT INTO hui_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Ani mitangi bu kogo ai áyu Isaraeleali lamialu i̱na au laya lamibe. I̱ Anduane Homogo kogo. I̱na tí gi mialu Iyibialinaga garabaya biabe ale bialu kamigoni nahalimulo golope halu pudaba lolebero. I̱na i̱ninaga gi hongohe kogo yaraga halu Iyibi wali agali pani hiriribiore mialu tí pele ngulebero, laya labe. ");
INSERT INTO hui_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Ani bialu i̱na tí mo i̱naga wali agali bu hinalu i̱ nde tínaga Ngode Datagaliwabe holebero. Tí Iyibi dindini garabaya biabe ale bialu kamigo nahalimulo golope harogola tagira poramingi i̱ Anduane Homogo tínaga Ngode Datagaliwabe heneda manda buleberami, laya lamibe. ");
INSERT INTO hui_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","I̱na tí haru tagira pialu bamba i̱na Abarahama Aisaga Yagaba imaruhondo dindi ogoni ngulebero lo winidagoriani haru puwa helolebero. Ani bialu dindi odagoni tíni dindioreni bu hinu halimulo ngulebero. I̱ Anduane Homogohanda ani laya lamibe, lene. ");
INSERT INTO hui_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Ani laya handala puwa Mosese ibugua Anduane Homogohanda labe layadagua Isaraele wali agali lamini. Lamiyagoyu Isaraele wali agali biaru biabe erekuibi biaabo hayagome mini dininila bo gangu leagola bi layaruni hale nahene. ");
INSERT INTO hui_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Ani bu heagola Anduane Homogohanda Mosesehondo lalu, ");
INSERT INTO hui_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","Áyu ogoni Iyibinaga kini kagoria puwa ibuhondo lalu, Isaraele wali agali Iyibi dindi wahalu pudaba labe laya, lalu lamule pu, lene. ");
INSERT INTO hui_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Ani layago lelowa dege Mosesehanda ladai bialu lalu, Isaraele wali agalime i̱na bi lamirugo hale nahayagoria kini agalidagome i̱na bi lamerogo hale holebadalo manda nabido. I̱ bi uruniale bayuwa nalagane ko, lene. ");
INSERT INTO hui_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Ani layagola Anduane Homogohanda Mosese Aronolahondo lalu, Libugua bi olarogo bilibu, lowa lalu, Áyu ogoni Isaraele wali agalihondobi Iyibinaga kini kagohondobi lamialu, Anduane Homogohanda iyame Isaraele wali agali Iyibi dindi howa haru tagira pialu pilibu laya, lalu lamilibu, lene. ");
INSERT INTO hui_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Yagaba igini wahene Lubene ibugua igini maria hene. Uruni ti mini Hanogo Palu Hesorono Kami imaru hene. Mariali uruni hono winidaruni áyu hameigini mini urunile palu ngagoni. ");
INSERT INTO hui_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Yagaba igini mende Simionohanda igiri waragaria hono winigo odaruni mini Yamuele Yamini Ohada Yagini Soha imaru hene. Mbira Solo henego ibu Kenana wali igini hene. Ani binigo uruni tigua hono winime hameigini áyu mini urunile palu ngagoni. ");
INSERT INTO hui_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Yagaba igini tebone Libai ibugua igini tebira Gesono Kohada Merari imaru hene. Igiri tebira uruni tigua hono winime áyu hameigini mini urunile palu ngaruni. Libai ibuni mali handari mbirani pira tebirani karia (137) halu homene. ");
INSERT INTO hui_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Gesono ibu igini kira mini Libini Simaila henego libugua hono winigome dewaore hoyu lene. ");
INSERT INTO hui_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Kohada igini maria hene. Amarama Isa Heberono Usile imaru hene. Kohada ibuni mali handari mbirani pira tebirani tebira (133) halu homene. ");
INSERT INTO hui_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Merari igini kirali Mali Musila hene. Ani binigo agali uruni bibahende tiha howa Libai hameigini tagira penego ka. ");
INSERT INTO hui_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amaramahanda ibu aba mbalini Yogobede dabu bini. Yogobedehanda igiri kira Mosese Aronola hono wini. Amarama ibuni mali handari mbirani pira tebirani karia (137) halu homene. ");
INSERT INTO hui_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Isa ibu igini tebira hene. Kora Nebege Sigiri imaru hene. ");
INSERT INTO hui_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Usile ibubi igiri tebira dege hene. Misaele Elisabana Sidiri imaru hene. ");
INSERT INTO hui_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Arono ibu Aminadaba wane Nasono mbalini Eliseba dabu bini. Dabu biyagola wali ogonime Arononaga igiri Nadaba Abihu Eleasa Idama imaru hono wini. ");
INSERT INTO hui_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Korahanda igiri tebira hono wini. Asiri Elegana Abiasa imaru hene. Igiri tebira urunime hono winime áyu Kora hameigini tu wigi buwa palu ngagoni. ");
INSERT INTO hui_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Arono igini Eleasa ibugua Pudile wane mbirago dabu bini. Wali odagome Piniasa hono wini. Agali uruni Libai hameigininaga agali haguane haga bini. ");
INSERT INTO hui_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Ani binigo agali marudaru helowa Mosese Aronolahondo Ngode Datagaliwabehanda lalu, Isaraele wali agali Iyibi howa haru tagira pudaba, lene. ");
INSERT INTO hui_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Agali ogonilabo libugua Iyibinaga kinihondo, Isaraele wali agali golope halu pela, lene. ");
INSERT INTO hui_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Anduane Homogohanda Mosese ibu Iyibi dindini hearia bi lamiyangi lalu, ");
INSERT INTO hui_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","I̱ Anduane Homogo kogoni. Iyibinaga kini kagohondo bi i̱na langirugo damene bibahende lamiai habe, lene. ");
INSERT INTO hui_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Ani layagola Mosesehanda ladai bialu lalu, I̱ bi bayuwa nalagaore bi uruni ale laroria liaheore kogoni í̠ manda bidegoni. Kini biago ibugua i̱ aleme bi larogo hale au holobadabe, lene. ");
INSERT INTO hui_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Ani layagola Anduane Homogohanda Mosesehondo lalu, I̱na í̠ kininaga deni mo Ngode Datagaliwabe ale bu hini lalu í̠ hamene Arono ibu í̠naga bi mana latagi haga ale helolebero. Ani berogola Arono ibugua mbiwia hagane lamiradagua kinihondo lamulebira. ");
INSERT INTO hui_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Ani buleberogo mbirale o bibe langerogo damene bibahende Arono lamiai habe. Arono ibugua kini biagoni lamialu Isaraele wali agali Iyibi dindi wahalu pela lalu lamulebirago. ");
INSERT INTO hui_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Ani lamiragola kome miniwi tingi howa giambe helo i̱na kini ogoninaga mini mo giambe helarogola ibugua libunaga bi hale naholebira. ");
INSERT INTO hui_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","I̱na Iyibi dindini mbirale hiriribi dewa bigi berogo hondowabi ibu miniha hiri nalolebira. Ani haabo kagola i̱na Iyibi wali agalibi kini ogonihondobi pani hiriribiore mialu i̱naga wali agali damenego bibahendeore dindi ogoni wahalu haru tagira polebero. ");
INSERT INTO hui_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","I̱na i̱ninaga gi yaraga howa Iyibi wali agali ti i̱naga gime balu Isaraele wali agali haru tagira polebero. Ani berongi Iyibi wali agalime i̱ Anduane Homogo henedalo ogoningi manda bulebira, lene. ");
INSERT INTO hui_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Ani laya handala Mosese Aronolame Anduane Homogohanda bilibu layadagua bialu kini biago hearia puwa bi lalibu layadagua lamini. ");
INSERT INTO hui_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Ogoningi Mosese ibu mali pira halira (80) Arono ibu mali pira halirani tebira (83) lowa hebingi lamialu hene. ");
INSERT INTO hui_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Anduane Homogohanda Mosese Aronolahondo lalu, ");
INSERT INTO hui_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","Kini agali ogonime libuhondo lalu, Libugua bi o larabigoni heneneda loliyayagua agalime nabiagane ale manane mbira bidaba layagua manane walia holenaga Arono ibunaga halimbu biago libu pialu howa mo ya labe. Halimbu ogoni kini bedagoria pialu ibu deni howa ibira haragola halimbu ogoni mo nogombi bu hinulebira, lene. ");
INSERT INTO hui_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Ani laya handala Mosese Aronola libu kini biago hearia puwa Anduane Homogohanda bilibu layadagua bini. Arono ibugua ibunaga halimbu biago kini biagobi ibunaga biabe biaga hearubi tinaga deni yu ibira hayagola halimbu biago mo nogombi bu hinini. ");
INSERT INTO hui_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Ani biyago hondowa kini biagome ibunaga agali miniwi gamugamu biaganeru ti nde tininaga halimbu yiniyago ibira hayagola ogolabome biyadagua dege bini. ");
INSERT INTO hui_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Ti nde tininaga halimbu yiniyaru dindini ibira hayagola bibahende mo nogombi hai hene. Ani biyagoyu Arononaga halimbu nogombi biagome nogombi marunaga biago bo mbedogo biai hene. ");
INSERT INTO hui_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Ani biyagola hondowa dege kini biago ibu doga howa Anduane Homogo ibugua Mosese Aronola libugua bi lamerabigo hale naholebira layadagua doga tagiho hene. ");
INSERT INTO hui_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Ani bu heagola Anduane Homogohanda Mosesehondo lalu, Kini biagonime mine gibiore halu Isaraele wali agali yupe halu pudaba nalole kagoni. ");
INSERT INTO hui_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Ani bu kago yawi egerebagi kini ogoni uyu iba Naili poragoria dalipe halu polebirago lola hole pobe. Halimbu mo nogombi hene biago yalu puwa ibu maha ibilo í̠ ala puwa unu iba angeni pu habe. ");
INSERT INTO hui_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Pu keria ibiragola au labe. Anduane Homogo Hiburu wali agalinaga Ngode Datagaliwabe kagome lalu ibunaga wali agalime ibu mitangi bialu mo dunini howa lotu lole dindi ko wali agali nahegoria pelo pudaba labe layagoni. Ani layago hale howa pudaba nalole hahowine dege áyu haabo kegoni. ");
INSERT INTO hui_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Mosese ibugua lalu, Ai Agali Haguane-o Anduane Homogohanda lalu, I̱na bigi berogoria hondowa ibu ogo heneda hondole hondo habe, laya. I̱na halimbu yidogome iba o poragoni barogola iba ogoni darama bulebira. ");
INSERT INTO hui_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Wena bibahende homai halu iba ngu timbuniore biragola Iyibi wali agali ti iba nabe nahe holebira, lalu Mosesehanda lene. ");
INSERT INTO hui_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Anduane Homogohanda Mosesehondo lalu, Arono lamialu ibugua halimbu biago mo yalu puwa Iyibi dindini iba porarubi iba ganaha bedarubi iba birape hene bedarubi iba lenego bibahendeore halimbu ogonime ya angua hai habe. Ani ya angua haragola iba bibahende darama bia halu dindi bibahendeni darama biame howa iba nole beha hambu ngarubi ira guabiniha hambu ngarubi bibahende darama biai holebira, lene. ");
INSERT INTO hui_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Ani layagola Mosese Aronolame Anduane Homogohanda bilibu layadagua bini. Libugua kini agali biagobi ibunaga biabe biaga biarubi deni howa Arono ibugua ibunaga halimbu biago yaraga howa iba Naili bene. Ani biyagola iba Nailibi iba maru berearubi bibahende darama biai hene. ");
INSERT INTO hui_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Ani darama biyagome wena ibaha bereago bibahende homa hai hene. Ani biyagola wena ngu timbuniore biame hayagome iba nabe naheyagola wahene. Ani bialu Iyibi dindi bibahendeni iba berearu darama biame hene. ");
INSERT INTO hui_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Ani biyagola kini biagonaga gamugamu biaga hearumebi Aronohanda biyadagua dege tininaga gamugamume ani bini. Ani biyagola kini biago ibu bu mini giambeho hayagobi dege haabo hene. Anduane Homogohanda ani bulebira layadagua kini biagome Arono Moseselame layago hale holene hame nalene. ");
INSERT INTO hui_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Ani nale howa bu mini giambeore halu ogolabome bi layago hale nahole lalu erembira mialu ibu andaga dai bini. ");
INSERT INTO hui_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Ani bialu bibahende darama biai hayagome iba nolene nabereyagola Iyibi wali agalime iba Naili biago angeange iba berelo uli wama ibaga bini. ");
INSERT INTO hui_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Ani bialu iba Naili iba marudarunibi darama dege bu wiaabo heane horo karu pene. ");
INSERT INTO hui_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Ani buwa Anduane Homogohanda Mosesehondo lalu, Kini biago karia puwa Anduane Homogohanda ibunaga wali agalime ibu mitangi bialu mo dunini howa lotu lelo tagira pialu pelabe laya lamibe. ");
INSERT INTO hui_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Olarogo hale halu nabirayagua i̱na í̠ pani ngialu í̠ dindi ogoni yago degeme dungume helolebero laya lamibe. ");
INSERT INTO hui_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Iba Nailiha yago biru to̱ore lalu birulene henge nawidagola í̠ andagani ibalu í̠ paliagahabi í̠ tamunibi birame halu í̠naga biabe biaga karunaga andaganibi í̠naga wali agali bibahendenaga andaganibi yago birame halu tomo dawaganehabi tomo dawa wiagane behabi biru to̱lotagi holebira laya lalu lamibe. ");
INSERT INTO hui_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Ani bialu porabu daga daga buwa í̠ni birame hama pialu í̠naga wali agalini birame halu í̠naga biabe biaga karu bibahendeni birame hai holebira laya lamibe, Anduane Homogohanda lene. ");
INSERT INTO hui_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Ani lowa Anduane Homogo ibugua Mosesehondo lalu, Arono lamialu ibunaga gi dogo lowa halimbu biagome iba porarubi iba ganaha bedarubi iba goreyane timbuni bedarubi iba bibahende bedago ya angua hai ha labe. Ani biragola yago bibahende tagira ibalu Iyibi dindi bibahende yago birame holebirago helo ani bia labe, lene. ");
INSERT INTO hui_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Ani layadagua Aronohanda ibunaga halimbu biagome iba bereago bibahende ya angua hai hayagola yago dewaore tagira ibalu Iyibi dindi bibahendeni yago birame hene. ");
INSERT INTO hui_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Ani biyagola kini biagonaga gamugamu biaga biarume nde tininaga gamugamu yiniyago biyagola lone yago ibaha berearu dindini haru íbu berelene. ");
INSERT INTO hui_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Ani biyagola kini biagome Mosese Aronola ibilo oladaba lowa ibiyagola ogolabohondo lalu, Anduane Homogohondo bi lalu yago o biru ngago mo erebaha lalibu. Mo ereba haribiyagua libunaga wali agalime Anduane Homogohondo mbirale bo delo milo tí pudaba lolebero laya lamilibu, lene. ");
INSERT INTO hui_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Ani layagola Mosesehanda ladai bialu lalu, Ogoni bayale Anduane Homogohondo í̠naga bi laholene turuho kogo la holebero. Ani buliyago ogoni í̠nagabi í̠naga biabe biaga karunagabi í̠naga wali agali bihendenagabi Anduane Homogohondo bi laholeberogo horo ogongi lahabe lalu pongo dege ngi. Ani laharogola Anduane Homogohanda yago o bedaruni bibahende mo ereba haragola mbira nabere iba Nailiha dege birulebira, lene. ");
INSERT INTO hui_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Ani layagola kini biagome ladai bialu lalu, Yawi bi ogoninaga lahabe, lene. Ani layagola Mosesehanda ladai bialu lalu, Í̠na bibe laregonidagua buleberogo Anduane Homogo ibugua hale halu birago handaregola inanaga Anduane Homogo Ngode Datagaliwabe ale mendeali nahedane hondolebere. ");
INSERT INTO hui_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Ani buleberogo áyu í̠bi í̠naga biabe biaga karubi í̠naga wali agali bibahende karubi yago o biru ngaruni yamiragola mbira nabere iba Nailiha dege birulebira, lene. ");
INSERT INTO hui_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Ani lalu Mosese Arono libu kini biago berelalu puwa Mosese ibugua Anduane Homogohanda yago íbu berelearu yamilonaga ibuhondo bi lene. ");
INSERT INTO hui_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Ani lamiyagola Anduane Homogohanda hale halu Mosesehanda layadagua bialu yago anda tamuha berearubi pabe tamuha berearubi mabuha berearubi bibahande homai helene. ");
INSERT INTO hui_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Homa payapayabu wiago Iyibi wali agali tinime hilu mo mogo buwa alugumu ngelaga bima piyaru togo biyagola ngu hiriribiore biame hene. ");
INSERT INTO hui_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Ani biyagola kini biagome handalu hearia yago bereago bibahende homahi layiyago hondowa ibu bu mini lone giambe hodai bini. Anduane Homogohanda Mosese Aronola lamialu bu mini giambe howa libunaga bi hale naholebira layadagua ani bini. ");
INSERT INTO hui_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Ani biyagola Anduane Homogohanda Mosesehondo lalu, Arono lamialu ibunaga halimbu biagome dindini ba labe. Ani baragola Iyibi dindi bibahendeha abalu wima pedago mo hinabibi bu hinulebirago, lene. ");
INSERT INTO hui_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Ani layadagua lamiyagola Aronohanda ibunaga halimbu biagome dindini bene. Bayagola Iyibi dindi bibahendeni abalu wiame heago bibahende mo hinabibi bu hinayagola nogo wali agalila bibahendeore hinabibime mbulope howa dugu neme hondole ndo hayume hene. ");
INSERT INTO hui_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Ani biyagola kininaga gamugamu biaga biaru tiguabi tinaga gamugamume hinabibi tagira íbu berelole bialu hearia ani nabibeheore hene. Ani buwa hinabibi birame howa nogo wali agalila hinabibime yalu hanalu bini. ");
INSERT INTO hui_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Ani biyagola kininaga gamugamuyi biarume kinihondo lalu, O biradagoni hinabibi o biru ngaruni Ngode Datagaliwabehanda ibuoreme ibilayadago, lene. Ani layagola kini biago ibu bu mini giambeore halu abale Anduane Homogohanda Mosese Arono libunaga bi hale naholebira layadagua hale nahe mini giambe hatagiho hene. ");
INSERT INTO hui_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Ani heagola Anduane Homogohanda Mosesehondo lalu, Yawi egerebagiore kini biago unu iba biagoha polebirago lola hole pobe. Lola howa Anduane Homogohanda au laya lamibe. I̱naga wali agalime i̱ mitangi bialu mo dunini howa lotu lelo golope halu pelabe laya lamibe. ");
INSERT INTO hui_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Ani napelolebero lariyagua áyu langerogo i̱na í̠ pani lone ngialu bunguna í̠ kegoriabi í̠naga biabe biaga biaru kagoriabi í̠naga wali agali kagoriabi ibilolebero. Iyibi wali agalinaga anda bibahendeha bunguna birame halu Iyibi dindi bibahende bunguname birame helolebero laya lamibe. ");
INSERT INTO hui_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Ti pani ani ngialu ai i̱naga wali agali kagoria Gosene dindini bunguna mbira birulani hondolebero. I̱na ogonidagua buleberogo irane Anduane Homogo i̱na dindi ogoriani biabe bialu kagonidalo handalimulonaga ani bulebero. ");
INSERT INTO hui_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Ani buleberogo i̱na i̱naga wali agalila í̠naga wali agalila mo tale buwa tu ngelolebero. Bi olarogonidagua yawi buleberogo handabe laya lamibe, lene. ");
INSERT INTO hui_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Ani layagola kini biagome bu mini giambeho haabo hayagola Anduane Homogohanda bunguna gibiore mberane tidu yalu ibuwa kini biago andaga heagoha haeala anda hene. Kini biagonaga biabe biaga hearu andagahabi ogonidagua dege bini. Ani bialu Iyibi dindi lenego bibahendeoreha bunguname mo ngubia hene. ");
INSERT INTO hui_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Ani biyagola kini biagome Mosese Aronola ibilo olowa ibiyagola ibugua libuhondo lalu, Tígua Iyibi dindini dege mbirani puwa tínaga Ngode Datagaliwabehondo mbirale bo loma bu delole pudaba, lene. ");
INSERT INTO hui_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Ani layagola Mosesehanda ladai bialu lalu, Ogonidagua bulene emene karula napolebirago irane ina Isaraele wali agalime nogo tara tararu Anduane Homogo inanaga Ngode Datagaliwabehondo bo delo meramagome Iyibi wali agali ti mo genda holebira. Iname ti de hendedaore nogo tara uruni delarimayagua tigua ina handabe manga howa ina to̱le̱me bo home lolebira. ");
INSERT INTO hui_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Ani bulebirago ina horo tebiruni dindi ko wali agali nahegoria puwa Anduane Homogo inanaga Ngode Datagaliwabehondo mbirale bo lomabu delo muleberama. Ibunime inahondo ani bilimu lenedagua buleberama, lene. ");
INSERT INTO hui_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Ani layagola kini biagome lalu, Karulapego tígua Anduane Homogo tínaga Ngode Datagaliwabehondo mbirale bo lomabu delo mule dindi ko wali agali nahegoria pudaba loleberogoyu kaundiaore napilimu. Ani bialu tíguabi Anduane Homogohondo i̱naga bi lahalimu, lene. ");
INSERT INTO hui_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Ani layagola Mosesehanda ladai bialu lalu, Áyu o kabago halu puwa ina Anduane Homogohondo bi lalu, Yawi bunguna o biru ngaruni yamiai habe laguago. Ani bia buleberogo áyu í̠na ina lone mo guya halu inanaga Anduane Homogohondo mbirale bo lomabu delo mule napudababe lone naloleberegoni, lene. ");
INSERT INTO hui_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Ani lalu bialu Mosese ibu kini biago helalu puwa Anduane Homogohondo bi lene. ");
INSERT INTO hui_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Mosesehanda bi ani layagola Anduane Homogohanda bi layago hale halu bunguna bibahende kini andagani birayarubi ibunaga biabe biaga biarunaga andagani birayarubi ibunaga wali agali biarunagabi mbira yu wanahe ereba haiore hene. ");
INSERT INTO hui_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Ani biyagola kini ibu mini giambe halu Isaraele wali agali wahalu pudaba, nalene. ");
INSERT INTO hui_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Ani mini giambe ho wiaabo hayagola Anduane Homogohanda lalu, Áyu kini biago karia puwa ibuhondo ogodagua lalu, Anduane Homogo Hiburu wali agalinaga Ngode Datagaliwabehanda ibunaga wali agalime ibu mitangi bialu mo dunini howa lotu lole pelo pudaba labe laya, lole pu. ");
INSERT INTO hui_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Áyu ogonibi lone mini giambeho wiaabo dege hariyagua ");
INSERT INTO hui_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","i̱na í̠ pani ngialu í̠naga nogo tara tara hinideruni bibahendeni warago hiriribi tara mbira ibilolebero. Ani ibilarogola nogo hosibi dongibi kamelebi bulumagabi sibibi memebi nogo lenego bibahende warago ogonime bo homo lai holebira laya, lamibe. ");
INSERT INTO hui_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","I̱nime dabalu Isaraele wali agalinaga nogo ogoda Iyibi wali agalinaga nogo ogoda lowa mo tale bialu Isaraele wali agalinaga nogogo mbira homolani hondolebero. ");
INSERT INTO hui_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","I̱ Anduane Homogo i̱nime horo yawi biabe ogoniore bule ngo laya labe, lene. ");
INSERT INTO hui_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Mosesehanda ani lamiyagolabi kini biago ibu mini giambeore hene. Ani biyagola egerebalene Anduane Homogohanda bulebero layadagua bialu Iyibinaga nogo bibahende homai helene. Isaraele wali agalinaga nogo mbiraorebi heba nahomene. ");
INSERT INTO hui_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Ani biyagola kini biagome maru hearuhondo hale halu Isaraele wali agalinaga nogo homayiyabe nahomeyabe lowa hale halu hearia tigua lalu, Mbiraorebi nahomeoreya, ladai bini. Ani biyiyago hondowabi kini biago ibu bu mini giambeoreho haabo hene. ");
INSERT INTO hui_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Ani biyagola Anduane Homogohanda Mosese Aronolahondo lalu, Libugua anda mbira ege timeni hirule ira delaradagoha puwa be abalu ogoriani bu wulebirago libu gi tahe labolabo dugu yalibu. Dugu yalu puwa kini biagonaga deni pu howa Mosese í̠na be abalu ogoni uyu hariha haealo baraga habe. ");
INSERT INTO hui_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Baraga haregola be abalu ogoni Iyibi dindi bibahendeha pu yulume halu abale ti taulome henego yalu yaga laradagua bulebira. Ani buwa be abalu ogoni nogo wali agalila bu kagoria ibira ibira bialu tinginini ela haragola moge buwa mani togodalu mo ti̱wa̱ howa nogo wali agalilanaga tingini nalu guabima anda polebira, lene. ");
INSERT INTO hui_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Anduane Homogohanda ani lamiya handala puwa libugua be abalu wiago dugu yalu puwa kini biagonaga deni pu hene. Pu howa Mosesehanda be abalu dugu yayago uyu hariha baraga hene. Baraga hayago ibira halu nogo wali agalilanaga tinginini ela hayagola moge buwa mani togodalu ti̱wa̱ biame hene. ");
INSERT INTO hui_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Ani biyagola kini biagonaga gamugamuyi biarubi Mosese hearia ibabe nahe mogeme bogopai layagola andaga wiaabo hene. ");
INSERT INTO hui_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Ani biyagolabi Anduane Homogohanda kini biagonaga bu mini mo giambeore hayagola Anduane Homogohanda Mosese Aronolahondo lalu kini ogonime libugua bi larabigo hale naholebira layadagua hale nahene. ");
INSERT INTO hui_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Ani biyagola Anduane Homogohanda Mosesehondo lalu, Yawi egerebagiore kini biago karia puwa Anduane Homogo Hiburu wali agalinaga Ngode Datagaliwabe kagome lalu, I̱naga wali agalime i̱ mitangi bialu mo dunini howa lotu lelo pelabe laya, lamibe. ");
INSERT INTO hui_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Ai mini giambe halu napelole lalu hariyagua áyu í̠naga biabe biaga karubi í̠naga wali agali karubi hangu pani mule ndo i̱na í̠nibi heba pani ngulebero. Dindi bibahendeni mbirali i̱ ale nahedane handabelo walia holebero laya, lamibe. ");
INSERT INTO hui_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","I̱na i̱ninaga gi yaraga howa warago mbira ibiledole í̠bi í̠naga wali agalibi bibahende warago ogonime bo paya biragola bibahende homaiore kamile. ");
INSERT INTO hui_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Ani nabi i̱naga hongo í̠hondo walia harogola dindi bibahende ngaruha bu karume i̱ hongohe ogoni ka lowa i̱naga mini loyogo lelonaga í̠ ba nabi habelo waharugoni. ");
INSERT INTO hui_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Ani birugo bilowa í̠ mine halu dogatagi howa i̱naga wali agali napelolebero lalu kegoni. ");
INSERT INTO hui_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Ani bialu kegonigo ai hale habe. Yawi ogodaguaore haragola dalu dindiguni gibiore ala Iyibi dindini naibinidagua yawi ibilolebero. ");
INSERT INTO hui_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Ani buleberogo nogo walila minu kabu bialu tamuni hangu payanda habe. Mbirale mbirale tagirani ngelama pedamigo bibahende tamuha mo baanda hai halimu. Nogo tara tarabi wali agalibi tagirani tuha ndo kago dalu damuyu karia dindiguni ogonime bo baya biragola homai holebira laya, lamibe lene. ");
INSERT INTO hui_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Mosesehanda puwa anidagua lamiyagola kini biagonaga biabe biaga biarume Anduane Homogohanda anidagua layiyago hale howa ti gi hene. Gi howa ti tinaga garabaya biabe ale bia haganebi nogobi anda tamuha haru anda piai hene. ");
INSERT INTO hui_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Ani biyagola maru ti Anduane Homogohanda o bulebero layadagoni ani bila lowa hada hole bialu tinaga garabaya biabe ale bia hagabi nogobi tagirani helowa ti embedaho hene. ");
INSERT INTO hui_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Ani bu hearia Anduane Homogohanda Mosesehondo lalu, Í̠naga gi uyu hariha yaraga habe. Ani beregola dalu dindiguni Iyibi dindi bibahendeni ibume halu wali agalibi nogobi tomo mbirale mbirale mabuni karubi bibahende damiai holebirago, lene. ");
INSERT INTO hui_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Ani bulebira layagola Mosesehanda ibunaga halimbu biago uyu hariha yaraga hene. Yaraga hayagola Anduane Homogohanda hariha howa dalu dindigunibi hari dababi gibiore dindi tawa balu ibilene. ");
INSERT INTO hui_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Anduane Homogohanda dalu dindiguni heba ibilalu harini kulu mege lalu hari dabaru tulade lalu gibiore buyu pu íbu daibu bilene. Iyibi dindini ala hama ibinidagoriani dalu dindigunibi naibinidaguaore odangi ibilene. ");
INSERT INTO hui_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Ibalu dalu dindiguni heba biagome Iyibi dindi bibahende wali agalibi nogobi tagirani haga biarubi dindigunime bo mbala pialu damia dege bialu damu tongolomi lene. Mabuni tomo hengearu bibahende dindi heba bapara helalu ira hearu bibahendeore podai helene. ");
INSERT INTO hui_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Iyibi dindini ani bialu heagola Gosene dindi Isaraele wali agali ti heagohayagi dege dalu dindigunibi mbira hondole ndo howa hada payabu hene. ");
INSERT INTO hui_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Ani bialu heagola kini biagome, Ai Mosese Aronola hondo pudaba, lene. Ogolabo ibiyagola ibugua lalu, Ai koore bialu harudane hendedogo Anduane Homogo ibugua mana bayale bialu heagola i̱bi i̱naga wali agalirubi iname ko bialu harimadane áyu hendedogoni. ");
INSERT INTO hui_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Ani birimadago ai dalu dindiguni hari dabala gibi biagome ina bowa kago ainde harula lalu Anduane Homogohondo bi lamilibu. I̱na heneneore buledagua larogo dalu ogoni tohayagua tí i̱naga dindi ogoria holene nawigo pudaba lolebero, lene. ");
INSERT INTO hui_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Ani layagola Mosesehanda ladai bialu lalu, I̱ anda dewa buhe ogo yu wahalu tagira pialu i̱na i̱naga gi yaraga howa Anduane Homogohondo bi lolebero. Ani berogola dalu o ibiragoni naibi tohalu dindiguni hari dabala o biragonibi nabulebira. Dindi timbuni ogo bibahende Anduane Homogo ibunagada lo manda bibelonaga ani bulebira, lene. ");
INSERT INTO hui_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Ani bia bulebiragoyu í̠bi í̠naga biabe biaga kamirubi tígua Anduane Homogo Ngode Datagaliwabe hondowa gi nahe dege kamigoni manda bido, lene. ");
INSERT INTO hui_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Dalu dindiguni gibi ibiyagome ira emene dewa bu henego dambialu ogoni aga wabiaga pu mini palagasi bu henego urunibi ladi ale mini bali dewa hongo winigo urunibi bibahende mo koore hene. Balidaru bogabi dolenengi ai palagasi ira emene dambialu aga wabiaga hongone anda halu heaorego uruni bibahende dindigunime dindi heba bapara helene. ");
INSERT INTO hui_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Widi tomo nagane do wiaru dege mani boga biaganegome widi mo ko nahene. ");
INSERT INTO hui_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Mosese ibu kini biago helalu anda dewa buhe biagoha howa tagira pialu pene. Puwa ibunaga gi hariha yaraga howa Anduane Homogohondo bi lene. Ani layagola dalubi dindigunibi hari dababi bibahende biyago abale nimulo mini. ");
INSERT INTO hui_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Ani biyago handayagola kini biagome lone ko bini. Ibuguabi ibunaga biabe biaga hearumebi bu mini giambe halu dogatagiho ala haralidagua hene. ");
INSERT INTO hui_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Anduane Homogohanda Mosese Aronolahondo ala lamialu kini biago bu mini giambe howa Isaraele wali agali pudaba nalolebira abale layadagua nalene. ");
INSERT INTO hui_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Kini biagome ibu mini ani giambeho heagola Anduane Homogohanda Mosesehondo lalu, Ai kini biago hondo pobe. I̱na kinibi ibunaga biabe biaga karubi bihendenaga mini mo giambe halu helarugo. Uruni ti de hendelo i̱na agalime nabibehe bigi bulenaga ani mo giambe haru, lene. ");
INSERT INTO hui_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Ani bialu tíguabi tínaga waneiginirubi aguanerubi tigua hono wima poraruhondo ladalidali bialu Anduane Homogohanda Iyibi wali agali agua bialu mo luluya halu mo taga haya lalu lamigi buleberami. Tí bibahendemebi i̱ Anduane Homogoore kagoni lo manda buleberami, lene. ");
INSERT INTO hui_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Ani laya handala Mosese Aronola kini biago hearia puwa ibuhondo lalu, Anduane Homogo Hiburu wali agalinaga Ngode Datagaliwabe kagome lalu, Í̠na i̱naga bi mo wa dege howa doga dege halu kene lu agua hole kebe. I̱naga wali agalime i̱ni mitangi bialu mo dunini howa lotu lelo ti tagira pialu pelabe, laya. ");
INSERT INTO hui_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Ani nabi napelole lalu haabo hariyagua o yawi í̠naga dindini pagaya ale birame helo ibilolebero, laya. ");
INSERT INTO hui_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Pagaya aleme dindini biru dungume kagola dindi de handabe nahe holebere, laya. Ani bialu pagaya ale urunime tani irabi dalu dindiguni biagome ba nabi yu wahayaru namaro bulebira, laya. ");
INSERT INTO hui_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Birama ibalu kini í̠ andaga tamuhabi birame halu í̠naga biabe biaga karu andagahabi birame halu Iyibi wali agali bibahende andagahabi ani dege biru to̱lome holebira. Ala tínaga mamali hama ibiyarumebi áyu tínimebi nahendenegobi koorene ko ogoni hondoleberami laya, lene. Ani lalu bialu Mosese ibu beregedalu kini biago erembira mialu tagira pene. ");
INSERT INTO hui_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Ani tagira piyagola kininaga biabe biaga biarume kini biagohondo lalu, Agali ogonime ina genda hangu mo ngialu kagoni. Ani ngialu haabo helole ke agini. Harugo Isaraele agali hangume Anduane Homogo tinaga Ngode Datagaliwabe mitangi bialu ibu mo dunini howa lotu lole pelo agali hangu pudaba la. Áyu Iyibi mo koore haro lalu o kagoni í̠ nahendedebe, lene. ");
INSERT INTO hui_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Ani layagola nde kini biagome Mosese Aronola hondo pudaba lowa ibiyagola ibugua libuhondo lalu, Tígua Anduane Homogo tínaga Ngode Datagaliwabe mitangi bialu ibu mo dunini howa lotu lole polene karulapego poleberami. Pu pole dege polebirago ibuni ai polebirabe, lene. ");
INSERT INTO hui_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Ani layagola Mosesehanda ladai bialu lalu, Ina bibahende poleberama. Inanaga waneiginibi wali agali wahebi heba poleberama. Inanaga waneiginibi haru halu nogo sibibi memebi bulumagabi haru hai holeberama nde i̱nanaga Anduane Homogohondo mbirale bo lomabu delo mialu ibu mitangi bialu mo dunini howa lotu loledago ani buleberama, lene. ");
INSERT INTO hui_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Aniore layagola kini biagome lalu, Be-e o Anduane Homogo mini lalu larogo tínaga one waneiginiru haru pudaba naloleberoore. Ai tindule tí hameigini paluenaga ina bodai bule o harimidane hendedogoni. ");
INSERT INTO hui_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Ani birimidago napolego tí agali hangume pialu Anduane Homogo mitangi bialu ibu mo dunini howa lotu lole wirimidadagua lole pudaba, lene. Ani lowa kini biagome ibunaga biabe biaga biaruhondo lalu, Mosese Aronola i̱ deni naholego tagira bo batagi hadaba, layagola tagira bo batagi hene. ");
INSERT INTO hui_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Ani biyagola Anduane Homogohanda Mosesehondo lalu, Í̠naga gi dogolo amu halu Iyibi dindi ya anguaha. Ani beregola pagaya ale ibulebirago ibilo. Pagaya urunime ibalu mbirale bibahende andaho kago damene no mundu lalu dalu dindiguni biagome ba nabi yu wahene karu tigua namaro bulebira, lene. ");
INSERT INTO hui_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Ani layagola Mosesehanda ibunaga halimbu biago yaraga hene. Yaraga hayagola Anduane Homogohanda puyabu ni ibiragohayagi howa puloyu tagira ibilowa pu lame dege halu heane alendo halu mbiragabi pu lame dege halu gao lene. Gao lopaya biyagola pagaya íbu birume hearia hendene. ");
INSERT INTO hui_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Pagaya uruni ti tidu yalu ibuwa haealo paya bialu Iyibi dindi bibahendeni birame hene. Pagaya ale wabuni tidu yalu ibuwa ibira haga binidadagua ala nabinigo manibi ogonidagua nabulebiraore. ");
INSERT INTO hui_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Tidu yalu ibalu mberabu pehaga bialu dindi bibahende biru dungume hayagola pagayame dindi bibahende mindi bu gimbu bini. Bira gimbu buwa nagimbu biahini pearia dindigunime yu wahearu tigua namaro bialu irani ira lini dearubi heba do nai hene. Mbirale ira yuni tani bolange yunibi mbira yu waholedago naholeore. Iyibi dindini anda haga heago damenegonaga yuni ti dondolo naiore hene. ");
INSERT INTO hui_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Ani biyago hondowa kini biagome abaleore Mosese Aronola ibilo hondo pudaba lowa ibiyagola ogolabohondo lalu, Ai i̱na Anduane Homogo libunaga Ngode Datagaliwabehondobi libuhondobi koore birugoni. ");
INSERT INTO hui_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Ai harugo halu mbira áyu ogo dege i̱naga ko ogoni domalu Anduane Homogo libunaga Ngode Datagaliwabehondo bi lalu ina balu home lolenaga pani hiriribi o ngidagoni mo yu erebaha lamilibu, lene. ");
INSERT INTO hui_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Ani laya handala Mosese Aronola libu puwa Anduane Homogohondo bi lene. ");
INSERT INTO hui_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Ani layagola Anduane Homogohanda puyabu biago mo aribia halu namu ni paliagahayagi howa pulo dai bilene. Ani pulo dai biyagome pagaya ale biru wiaruni minu yalu yaga lalu Iba Daramabi bereagoha yalu anda pelene. Ani biyagola pagaya o biru wiyaruni aria mbira mbiraorebi heba Iyibi dindini yu wanahene. ");
INSERT INTO hui_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Ani biyago bilowa dege Anduane Homogohanda kini biagonaga bu mini mo giambe hayagola ibugua Isaraele wali agali pudaba nalene. ");
INSERT INTO hui_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Ani buwa Anduane Homogohanda Mosesehondo lalu, Í̠naga gi uyu hariha yaraga habe. Ani beregola aruma dumbilihinu ngane Iyibi dindi bibahendeni aruma hodambi holebira, lene. ");
INSERT INTO hui_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Ani layagola Mosesehanda ibunaga gi hariha yaraga hayagola aruma dumbilinime timulope hayagola Iyibi dindi bibahendeni aruma ndibulope ho wiane horo tebiru pene. ");
INSERT INTO hui_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Iyibi wali agalime tini handaya haga bibe nahe wini. Aniyagola mbirali tagira nape bibahendeore tini andagani birai hene. Isaraele wali agali ti heagoha dege wáni hene. ");
INSERT INTO hui_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Ani biyagola kini biagome Mosese hondo pudaba lowa ibiyagola lalu, Ai tí tínaga Anduane Homogo mitangi bialu ibu mo dunini howa lotu lole polene karulapego pudaba. Tínaga one waneiginibi tíni heba piai halu ai tínaga nogo sibiru memeru bulumagaru dege helalu pudaba, lene. ");
INSERT INTO hui_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Ani layagola Mosesehanda ladai bialu lalu, Aniyagua ina Anduane Homogo inanaga Ngode Datagaliwabehondo nogo bo lomabu delo muluma̱yanaga í̠na bo ngulebedagoni. ");
INSERT INTO hui_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Ndo ina inanaga nogo lenego bibahendeore haru hai holeberama. Homane mbiraorebi mbira hadai nabiloleberama ndobe. Inanaga nogo inaneme dabalu inanaga Anduane Homogohondo bo mibehe ogoda lowa muleberama. Nogo ogoalego bo mule wiyada uyuna Anduane Homogo mitangi bialu ibu mo dunini howa lotu laramagoria pu howa hondolene wulebira, lalu lamini. ");
INSERT INTO hui_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Ani lamiyagolabi Anduane Homogohanda kini biagonaga bu mini mo ndibu layagola giambeho tagiho howa Isaraele wali agali pudaba nalene. ");
INSERT INTO hui_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Bu mini giambeho howa ibugua Mosesehondo lalu, Í̠ i̱ deni nahe pu. Mani o i̱ kogoria bilingi bolanguabu holeni. Í̠naga denguiore mani nahondolego wahalu pobe. Í̠naga dengui lone handaruyagua handarongiore yania howa bo waholiya habe, lene. ");
INSERT INTO hui_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Ani layagola Mosesehanda ladai bialu lalu, Ogoni tiga tiga larigo. Í̠na i̱naga dengui lone nahondolebereore ndobe, lene. ");
INSERT INTO hui_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Ani lalu bialu pu heagola Anduane Homogohanda Mosesehondo lalu, I̱na Iyibinaga kini biagohondobi ibunaga wali agalihondobi pani halu mbiraore hangu miamaro bulebero. Ani berogola ibugua ai ti wahalu pudaba lalu ti mo hibilabala howa ibu dindini naholego abale tagira pialu pudaba lowa ti bo batagi holebira. ");
INSERT INTO hui_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Ani bulebirago ai áyu Isaraele wali agali bibahende lamialu, Iyibi wali agali tí baba mandagi handa a̱i̱ na̱i̱ paliaga karuhondo ai poramago muni ngolobi silibabi mbira ngidaba lalimu, labe. ");
INSERT INTO hui_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Anduane Homogohanda Isaraele wali agali mo yaragaho helayagola Iyibi wali agalime Isaraele wali agali mo yo handabe nahe hene. Ani bialu kininaga biabe biaga hearumebi wali agali bibahendemebi Mosese agali gibiore kagoni lowa ibuha handadagaho hene. ");
INSERT INTO hui_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Ani bu henego Mosesehanda kini biagohondo lalu, Anduane Homogohanda lalu, Áyu mbiraga mbi hanuni haragola i̱ Iyibi dindini ibagabu holebero. Ibaga bialu howa Iyibialinaga igini wahene damenego bibahende homai helolebero, laya. ");
INSERT INTO hui_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Kininaga igini wahene kagome ibu abanaga dagia ibugua mule kago ogoni ala homalu Iyibi wali agalinaga igini wahene damenego bibahende homahi lalu wali garabaya biabe ale biaga widi dambialu bedarunaga igini wahene damenerume homa maro bulebira, laya. Nogo bulumaga igini ala wini karubi homai dege holebira, laya. ");
INSERT INTO hui_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Iyibi dindini wali agalime genda gibiore howa dugu gibiore biame halu dugu ala nabinidaguabi mani nabulebiragodaguabi áyu mbiraga howa bulebira. ");
INSERT INTO hui_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Ai Isaraele wali agali ti kagoriabi tinaga nogo kagoriabi biangomebi heba duabi mbira naloleorebira. Ani birago handaregola Anduane Homogo i̱na Iyibi wali agalila Isaraele wali agalilani tu henemane ngelenedane hondolebere, lalu Anduane Homogohanda laya, lene. ");
INSERT INTO hui_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Ani lowa Mosesehanda lamaro bialu lalu, Ani birago hondowa kini í̠naga biabe biaga karu bibahendeme i̱ kogoria ibuwa i̱ deni bulu paluwa i̱hondo ladeborebo bialu i̱naga wali agali haru halu áyu ogoni pu lolebira. O bulebira laruruni bibahende biai kagola i̱ Iyibi dindi wahalu tagira polebero, lene. Ani lalu bialu Mosese ibu keba gibiore halu kini andaga biagoha howa tagira pene. ");
INSERT INTO hui_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Ani lamiyagolabi Anduane Homogohanda Mosesehondo lalu, Kini ogonime bu mini giambeho dege karia i̱naga hongo lone walia holebero, lamini wiadagua tagira pene. Hongo lone walia holene tawe heariane ibu giambe haabo hene. ");
INSERT INTO hui_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Mosese Arono libugua kini biago deni howa manane tara tara uruni biyagoyu Anduane Homogohanda kini biagonaga bu mini mo giambe heagome o biragoni ogoale bira lole ndo howa Isaraele wali agali Iyibi dindi yu wahalu pudaba nalole hene. ");
INSERT INTO hui_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Mosese Arono libu Iyibi dindini heaore Anduane Homogohanda libuhondo bi agua lamini. ");
INSERT INTO hui_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","Isaraele wali agali tinaga pongo yulenego mali mbiranaga ege pigane áyu kago holebira. ");
INSERT INTO hui_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Ani bulebirago Isaraele wali agali lenego bibahendeore mo ngoai howa tihondo bi ogo lamibe. Ege áyu kagonaga horo pini haragola agali bibahendeme nogo sibi iginiyaguabi nogo meme iginiyaguabi mbira ibu one waneigini baba nama lole dabo bagiho helalimu, lalu lamilibu. ");
INSERT INTO hui_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Ti hangu hangume ani bima poragola agali mbirago ibugua nogo bo ngago ibu one waneigini baba tini hangume nai habe nahe nogo timbuni halu wali agali ndia hayagua o anda be mende handa ai̱ nai̱ padabigola libu haru mandagi nabiya íbu lowa ololene nga. Nogo puguni dagala wali agali dagala buwa baya hangu nai helo manda buwa bulene nga. ");
INSERT INTO hui_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Nogo sibiyaguabi memeyaguabi ngoalia hara alego bolene nga. Nogo igini ogoni wangabe bayago hondowa ko kumburayu mbira para naheore mali mbirani hininigo bolene nga. ");
INSERT INTO hui_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Nogo ogonibigo dabo helowa ege áyu kagonaga horo daga dene (14) haragola alendoore ne̱le̱ni̱ni̱ nogo uruni bama polene nga. ");
INSERT INTO hui_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Bowa nogo ogoninaga darama hambuwa anda nogo ogoni nalu birulenegoria panga harabanibi anda gene lene labolabonibi hirulene nga. ");
INSERT INTO hui_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Ani buwa nogo ibuni irani hiri polowa mberedi yidi nahego mo peha palena aleru kaubigo dugupeha buwa ogoni heba nolene nga. ");
INSERT INTO hui_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Nogo ogoni aria gahenge podo mialu nanalimu todobeneha dawabi nabilimu. Homa hende irani hiri polowa nalimu. Haguanebi gi gebi tini garinibi irani hirahira hangu nalimu. ");
INSERT INTO hui_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Egerebagi nole lowa mbira podo wia nabilimu. Mbira ibira hayagua na nabi wahalu irani hangu delai halimu. ");
INSERT INTO hui_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Ogoni nole howa ala agua bilimu. Aga baya hangu ndibulo bialu ge gamu mo karulalu giha halimbu mo yu howa nolene nga. Hariga lu pole howa narolo manda buwa ala naga bulene nga. Ala naga bulene ngago irane tomo naramigoni Anduane Homogohanda ina nabe bolangua halu pene lalu i̱naga mini yaraga holenaga noleberami, lalu Anduane Homogohanda lene. ");
INSERT INTO hui_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Anduane Homogo ibugua Mosese Aronolahondo laabo halu lalu, Mbiraga o larogoningi i̱na Iyibi dindi bibahendeha pume halu Iyibi wali agalinaga igini wahene bibahende bo wahai halu tinaga nogo igini ala winibi bowa dege holebero. Ani bialu Anduane Homogo mbiraore i̱ hangu kogo de hendelo walia halu tinaga dama tara tara hayadaruni bibahende bo haeala bagabu waholebero. ");
INSERT INTO hui_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Ani bima poleberogo tí anda ogoha ina padama lalu walia halu darama harabani hiridemigome walia holeberami. I̱na mbiraga Iyibialirunaga igini wahene balu wali agali pani merongi tí andagani darama hiridamigo hondowa tíhondo mbira bia nabi i̱na tí bolangua halu polebero. ");
INSERT INTO hui_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Ani buleberogo Anduane Homogo i̱na tí nabe bolangua halu porogoni mitangi biaho wiaabo helonaga horo ogoni baya hangu pongo yuwa ogoningi i̱ mitangi bialu mo dunini howa lotu lalu halimu. Tínaga waneigini maha hama poraruhondobi mana lamialu tibi mugubali helo ogoniore embeda holemini horo ogoni tagira ibirangi biaabo halu i̱na tíhondo berogo mitangi biaabo halimu, lalu lamini. ");
INSERT INTO hui_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Ani lowa Anduane Homogohanda lone ladege bialu lalu, Horo karuni tí mberedi yidi nahe hirinigo nolene nga. Mberedi yidi heba hirinigo mbira nolemini, lene. Ani bialu horo mbirani tí andagani yidi wigi bidamigo bibahende mo wahai halimu. Ai bi o langerogo donge howa mbiralime horo karia uruni andaneha howa mberedi yidihe hirinigo mbira nayagua ogoni narago ibu i̱naga wali agali ndo holebira. Bi mo wahaga ogoni tí heba holemini bo batagi halimu. ");
INSERT INTO hui_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Horo mbira piganegoriabi horo kanegoriabi tí mo ngoai howa i̱ mitangi bialu mo dunini howa lotu lalimu. Horo kiru ogoningiore biabe bulene damenego mbira nabi bame halimu. Tíni tomo nolene dege manda manda bilimu. ");
INSERT INTO hui_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Horo karia uruninaga horo piganegoria i̱na tí Isaraele hameigini bibahende Iyibi dindi howa haru tagira pirugoni. Ogoni birugo mitangi bialu mali bibahendengi horo timbuni mbira Mberedi Yidi Nahe Hirinigo Nalu Holene Horo ogoni mitangi biaabo halu halimu. Tínaga waneigini mani hararu tiguabi ogonidagua dege bia a̱i̱ helo tihondobi mana lamilimu. ");
INSERT INTO hui_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Ani bialu ege piganegonaga horo dene haragola alendo ne̱le̱ni̱ni̱ howa hama pialu horo pira kirani mbiragonaga alendo ne̱le̱ni̱ni̱ howa horo dombene niguniha howa mberedi yidihe hirinigo mbira nanalimu. ");
INSERT INTO hui_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Horo karu ogoniha tí andagani yidi mbira wulene nawiore. ");
INSERT INTO hui_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Tíni aria mbiragomebi ndo dindi tarali mbira tí baba igiri yango ibu henemebi mberedi yidihe hirinigo mbira nalu karia handarimiyagua ogoni ibu i̱naga wali agali kago aria ndo holebira, lalu Anduane Homogohanda ani lene. ");
INSERT INTO hui_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Ani buwa Mosesehanda Isaraele wali agali haru haga hearu olo ngoai howa tihondo lalu, Tí bibahende hangu hangume nogo sibi iginiyaguabi nogo meme iginiyaguabi ngoalia hara ale mbira bowa tí one waneigini baba biruwa Ngode Datagaliwabehanda Isaraele wali agali tí nabe Bolangua Halu Polebiragonaga Horo ogoni mitangi halu tomo nole nogo ogoni balimu, lene. ");
INSERT INTO hui_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Nogo igini ogoni bowa darama ndisiha oda berelalimu. Oda berelowa ira hisobo magane podaga buwa gi mbira agima yuwa nogo darama hambu wirimigoha ibira haga bialu darama nai anda haraba gene labolabonibi uyu harabanibi hiralimu. Tí hangu hangume tí andagani ogonidagua hirama puwa tí mbiraligo mbira andaga yu wahalu tagira polemini nape tamuha biru ngamiore dege gao lelalimu. ");
INSERT INTO hui_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Ani buwa Anduane Homogohanda Iyibiali igini wahene bo wahole Iyibi dindini pume harangi tí andagani darama anda genenibi harabanibi hiridamigo hondowa Anduane Homogohanda ibunaga Homelo Bagane dahuliyalime tí andagaha anda naibi bolangua halu pelolebira. ");
INSERT INTO hui_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Ani bulebirago bi o bilimulo langirugoni damenego baya hanguore bulene horo harangi biaabo halu tí waneigini mani hama porarumebi mana ogoni mo tene howa bima pelo mana milimu. ");
INSERT INTO hui_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Anduane Homogohanda tíhondo dindi mbira tí halimulo ngulebero layago dindi ogoriani pu howabi mana ogoni dege bigi bilimu. ");
INSERT INTO hui_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Tí waneiginime tíhondo mana ogoni aginaga beramabe laga biyagua ");
INSERT INTO hui_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","tígua ladai agua bilimu. Horo ogoni mini Bolangua Halu Penegonaga mitangi bialu ina Anduane Homogo mo dunini howa lotu lalu tomo ogoni naramagoni. Ibugua Iyibialinaga igini wahene damenego bo wahama piyangi ina Isaraele wali agali andaga bolangua halu pialu inanaga igini wahene nabayagonaga mitangi bialu beramagoni lalimu, lene. Mosesehanda ani lamiyagola Isaraele wali agali hale howa ge duli hangaho biruwa Ngode Datagaliwabe mitangi bialu lotu lene. ");
INSERT INTO hui_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Ani bialu heyalu puwa Anduane Homogohanda Mosese laminigo tihondo lamiyaria hale hayadagua bini. ");
INSERT INTO hui_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Mbiraga mbi hanuni hayagola Anduane Homogohanda Iyibialinaga igini wahenego bibahende bo wahai hene. Iyibi kininaga igini wahene ibu abanaga dagia mule heago ala bo wahene. Ani buwa agali hearunaga igini wahenego bo wahama pialu garabaya andaha garabaya hearunaga igini waheneni bairi halu igini wahene damene bibahende bo hilene. Nogo igini ala wini hearu damenebi bibahende bo wahai hene. ");
INSERT INTO hui_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Mbiraga odagoningi kini agali biagobi ibunaga biabe biaga hearubi Iyibiali bibahendebi heyai howa handalu hearia tinaga igini wahene bo wiaria hendene. Hondowa Iyibi wali agali bibahendeme dugu emene ndoore ya yi lalu gibiore bigibigi bini. Nde mbirago igini mbira yu wahenedanego mbirali dugu nabi holebe. ");
INSERT INTO hui_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Ogonidagua biyago hondowa mbiraga odagoningi dege kini biagome Mosese Aronola ibilo hondo pudaba lowa ibiyagola libuhondo lalu, Áyu ogoni libubi tí Isaraele wali agali bibahendebi áyu ogoniore piai hadaba. Tí bibahende i̱naga dindini i̱naga wali agali heba naholego áyu ogoniore pialu tínaga Anduane Homogo mitangi bialu ibu mo dunini howa lotu lole porama larimidagua lole pudaba. ");
INSERT INTO hui_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Tínaga nogo sibirubi memerubi bulumagarubi haru hai halu pole pudaba. Pialu howa Anduane Homogohanda i̱hondo bayale bilonaga i̱nagabi bi lahalimu, lene. ");
INSERT INTO hui_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Ani bialu Iyibi wali agali tinimebi Isaraele wali agali Iyibi tinaga dindi yu wahalu abale pelonaga mo daila hene. Mo daila halu howa lalu, Tí áyu ogoni napirimiyagua ina bibahende áyu bo wahai haragonidago tí áyu ogoni pudaba, lene. ");
INSERT INTO hui_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Ani layagola Isaraele wali agalime abaleore tinaga balawa yidi heba wa nabi wiaru ndisi beha mo gambiruwa agame mo huba buwa payani yagayaga bialu pene. ");
INSERT INTO hui_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Pialu howa Isaraele wali agali biarume Iyibi wali agalihondo lalu, Ainde poramago muni ngolo silibabi agabi mbira ngia naberami, lene. Ani lalimu lalu Mosesehanda ala layadagua lene. ");
INSERT INTO hui_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Anduane Homogohanda Iyibi wali agalinaga deni Isaraele wali agali mo yaraga hayagola Iyibi wali agalime Isaraele wali agalihondo mbirale mbirale ngidaba laya ale bu hombedo mini. Anidagua biyagola Iyibi wali agalinaga mbirale mbirale wiaru Isaraele wali agali ti mo hombedo yalu piyagola Iyibi wali agali bo tabuanda helene. ");
INSERT INTO hui_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Ani bialu Isaraele wali agali ti Lamese tano mo mogo bu halu Sugodo pole pene. Penedagoni agali hangu daga daosini handari waragaria (600,000) pene. Wali wandari igiri emene daga nale wahowa agali hangu daga ogonidagua pene. ");
INSERT INTO hui_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Ani bialu wali agali dindi tarali marubi dewaore Isaraele wali agali heba yamaga halu pialu nogo sibibi memebi bulumagabi dewaore haru pene. ");
INSERT INTO hui_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Pialu Sugodo anda puwa balawa yidi nahe Iyibi dindi howa yarimiru hiruwa nene. Iyibiali biarume hibilaba lalu áyu ogoni pudaba lowa de duguyu mo daila hayagola balawa baya hangu wa nabi piyago ai Sugodo anda puwa bayuwa wabialu hiruwa nene. ");
INSERT INTO hui_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Isaraele wali agali ti Iyibi dindini mali handari mariani pira tebira (430) ogonidagua hene. ");
INSERT INTO hui_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Mali handari mariani pira tebira (430) ogonidaguaore ngau layagola Anduane Homogonaga wali agali wabuni ogoni Iyibi yu wahalu tagira pene. ");
INSERT INTO hui_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Puwa horo odagoningi mbiraga Anduane Homogohanda Isaraele wali agali baya hangu mamage halu Iyibi dindi howa haru tagira pene. Ani binigo mitangi bialu Isaraele wali agali ti mani hama pialu howa mbiraga Anduane Homogohanda mamage henedagoni horo tagira ibigi biragola mbiraga ogoni Anduane Homogohondo lomabia ho ngelalu ibu mitangi bialu lotu lalu haga wini. ");
INSERT INTO hui_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Anduane Homogohanda Mosese Aronolahondo lamialu lalu, Ai i̱na bi larogo hale hadaba. I̱na Isaraele wali agali nabe bolangua halu haru tagira pirugo mitangi bu dai bialu tomo nolene mana ngago baya hangu hale hadaba. Wali agali dindi tara taraha howa ibugu bini tí baba karu tigua Bolangua Halu Penegonaga Tomo ogoni nanolebira. ");
INSERT INTO hui_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Anigo agali maru tínaga munime yolo binigo ti tínaga garabaya biabe ale bialu haga howa tinaga dongone podo mabu bu wahene heagua nde tomo ogoni nolene karulape. ");
INSERT INTO hui_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Wali agali tara tara tí baba tigimandi hangu íbu heneyaguabi ti muni biabe bialu heneyaguabi bibahende tomo ogoni aria nolene nawi. ");
INSERT INTO hui_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Wali agali tigua nogo sibi bo dawale anda manda manda biyadagoria howa dege nolene nga. Nogo sibi ogoni aria podene maru ibira hayagua yu tagira nape anda ogorianiore howa nai holene nga. Ani bialu nogo sibi boleberemigonaga kunibi mbira napodoleore beremi. ");
INSERT INTO hui_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Ani bialu Isaraele hameigini bibahendeoreme nogo sibi balu tomo ogoni dawa nai holene nga. ");
INSERT INTO hui_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Anigo agali maru tinaga dongone podo mabu nabi heagua nde tigua tomo ogoni nolene nawi. Agali tara maru tinaga dindi tene wiyadago wahalu ibuwa tí baba hene karu tibi nde i̱na Isaraele wali agali tí golope hene halimulo haru tagira pirugo mitangi bialu Bolangua Halu Penegonaga Tomo ogoni nolene mana bulene hamelo heagua nde agali ogoni ibunaga dongonebi igiri ibu andagaha haga karunaga dongonebi podo mabu bulene nga. Ani podai howa nde tomo ogoni nolene wulebira. Anidagua bialu karu tí ariaore holebira. ");
INSERT INTO hui_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Isaraeleali tínagabi agali dindi taraha howa ibini uruni tinagabi mana mbiraore ogoni dege nga, lene. ");
INSERT INTO hui_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Ani layagola Isaraelealiru tigua Anduane Homogohanda Mosese Aronolahondo bilimu lalu lamiyadagua biai hene. ");
INSERT INTO hui_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Horo ogoningiore Anduane Homogohanda Isaraele wali agali Iyibi dindi howa haru tagira pene. ");
INSERT INTO hui_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Anduane Homogohanda Mosese lamialu lalu, ");
INSERT INTO hui_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","Tí igini wahene karu bibahende i̱nihondo lomabu ngiai halimu. Isaraeleali tínaga igini wahene damene bibahendebi tínaga nogo bulumaga karume igini pigane wialu wangabe wiyagua uruni bibahendebi i̱ninagaore holebira, lene. ");
INSERT INTO hui_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Mosesehanda wali agaliru lamialu lalu, Tígua Iyibi dindiha garabaya biabe ale bialu haabo ho hemiria Anduane Homogohanda ibuninaga hongo timbuniore kagome tí Iyibi dindiha howa haru tagira piyagoni. Ani biyago mitangi bialu tígua horo ogoniore embeda naholenaga mberedi yidi nahe hirini hangu ngago nalu halimu. ");
INSERT INTO hui_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Ai tígua ege piganego mini Abibi horo áyu kagoningi Iyibi dindi yu wahalu tagira porami. ");
INSERT INTO hui_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Anduane Homogohanda tí mamali hearuhondo bi lowialu Kenana dindiha Hidialibi Amoralibi Hibialibi Yabusualibi uruni karuha dindi ngaru bibahende tí mo ngiai holebero lo wiyagoni. Dindi uruniha dindi benebere ngago tomo bayale anda hai holene bayaleore nga. Ani ngago ai Anduane Homogohanda tí dindi ogoniha haru halu pu heledagola howa tígua Mberedi Yidi Nahe Hirini Nolene ogoni mali bibahendengi ege áyu kamago aleni mitangi biaabo halu halimu. ");
INSERT INTO hui_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Tígua Mberedi Yidi Nahe Hirini Nolene ngaru ege áyu kamago aleni horo karuni nalu halimu. Ani howa horo kanego ogoningi tígua Anduane Homogo ibunihondo mitangi bialu lotu lalimu. ");
INSERT INTO hui_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Horo karu uruningi wali agali bibahendeme mberedi yidi howa hirini nolene nawiore. Horo uruningi tínaga dindi ngamiruha yidibi mberedi yidi howa hirinibi mbira ngela nabi wahai halimu. ");
INSERT INTO hui_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Horo timbuni ogoni tagira ibirangi tí igini karuhondo bi ogodagua lamilimu. Iname mbirale o bialu kamagoni irane ala Anduane Homogohanda ina Iyibi dindiha howa mbirale tara taraore dewa bialu haru tagira pialu ina dindi ogoha haru ibinigo mitangi bialu ani beremali, lalu lamilimu. ");
INSERT INTO hui_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Lotu ogoni ale lolenego mana tínaga gi habenibi wanakuinibi gilibu ngelowa haradagua bu halimu. Ani bu howa Anduane Homogonaga mana lo ngago mo mitangi bia haragola tígua ogoni lalu holeberemi. Irane Anduane Homogohanda ibuninaga hongo timbunioreme tí Iyibi dindiha howa haru tagira puwa dindi ogoria haru ibinigo mitangi bialu ani bulene nga. ");
INSERT INTO hui_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Ainde mali bibahendengi horo ogoni tagira ibiragola tígua tomo ogoni hiru nalu haabo halimu, lalu Mosesehanda lene. ");
INSERT INTO hui_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Mosesehanda lalu, Anduane Homogohanda tí Kenana dindi ngagoha haru polebira. Ani pialu ibugua dindi ogoni bamba tínaga mamali hearuhondobi tínihondobi ngulebero lalu lo wiyadagua ngulebira. ");
INSERT INTO hui_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","Ibugua dindi ogoni tí ngiragola tígua tínaga igini wahene damenego Anduane Homogo ibunihondo lomabu milimu. Ani bialu tínaga nogo hinidamirume igini pigane wiragola wangabe wiyaguabi bibahende Anduane Homogohondo milimu. ");
INSERT INTO hui_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Anigo nogo dongi igini pigane wirago nahomelonaga nogo sibi iginime bo lomabu aribia halimu. Ai tínaga dongi ogoni nogo sibime bo loma budai bibe naheyagua nde wahalu nogo dongi igini wangabe pigane wini biago ma pugualu bo waholene nga. Ani bialu tínaga igini wahene loma biaho helaramigo lone tinime yolo biadai bulene nga. ");
INSERT INTO hui_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Ani beramigola tí igini urunime mana ogoni irane aginaga bialu kamibe lalu tínihondo hale hayagua nde tígua ogodagua ladai bilimu. Bamba ina Iyibi dindiha garabaya biabe bialu hemaria Anduane Homogohanda ibunaga hongo timbunioreme ina haru tagira pialu ogoria haru ibini kamagoni. ");
INSERT INTO hui_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Pigane howa Iyibi dindini kini heagome mine halu ina yupe holene manga hayagola Anduane Homogohanda Iyibiali bu hearu bibahendenaga igini wahene hearubi nogo damenenaga igini pigane winigo wangabe hearubi bibahende bo wahai hene. Ani binigonaga ai iname nde nogo damene bu karunaga igini pigane wini wangabe bibahende Anduane Homogohondo loma buwa bo meremali. Ani buwa iname inane igini wahene haragobi lomabu mialu mani inane yolo biadai beremali. ");
INSERT INTO hui_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Anidagua beremalidagoni irane Anduane Homogohanda ibuninaga hongo timbuniore kagome ina Iyibi dindiha howa haru tagira ibinigo mitangi bialu ani beremali. O binidagoni embeda nahole manane inanenaga gi habenibi wanakuinibi gilibu wiradagua bialu mana ogonidagua beremali, lalu lamilimu, lalu Mosesehanda lene. ");
INSERT INTO hui_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Iyibinaga kini biagome Isaraele wali agali pudaba layagola howa Ngode Datagaliwabehanda Isaraele wali agali haru halu hariga nemandi tongo lalu iba angeange pialu Pilidia dindi tagira pole polene wiago manda buwa dege ibugua hariga ogonidagua naharu pole manda bini. Ibugua manda bialu hearia ogonidagua haru piruyagua Isaraele tinaga waitigi hariga obeneni karia lola howa ogonila wai bule haruda manda buwa wahalu Iyibi dindi ibida dai bule manda bulebira lo manda bini. ");
INSERT INTO hui_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","I̱naga wali agalime mini ogonidagua nawilo manda buwa Anduane Homogo ibugua hariga nemandi ogoni wahalu hariga mende dindi ko wali agali nahaga wiagodagua haru pu mabu bialu iba solowara mini Iba Daramabi bereagoria haru tagira pene. Isaraele agali ti wai bulene danda timu ayagubi giha yalu yalu pene. ");
INSERT INTO hui_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Ani bialu tinaga mamali Yosebenaga kunibi dugu yadege pialu pene. Yosebenaga kuni dugu yinidagoni irane ala ibu nahome howa ibugua Isaraele wali agali lamialu bi ogodagua lene. Awe Ngode Datagaliwabehanda tí gi mialu Iyibi dindi howa haru tagira polebirago ani birangi i̱naga kuniore Iyibi dindini nawulego dugu yalimulo hame ledogo dugu yuleberama ladaba, layagola ina, E̱ dugu yaore buleberama, lenedagua o dugu yinidagoni. Ani bialu Yosebenaga kunidagoni duguwa Mosese ibugua yalu ti pene. ");
INSERT INTO hui_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Pialu Isaraele wali agali biarume Sugodo yu wahalu Edama dindi anda pialu dindi ko wali agali nahaga wiagoria leneha anda puwa haanda palene. ");
INSERT INTO hui_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Anduane Homogohanda ibunaga wali agalihondo hariga walia hole horombeni hariha howa beraliba mberane tigabi timbuni mbira wiadali halu ibuni ogoniha howa hariga bamba hama pialu hene. Ani bialu mbiraganaga hariga walia hole Anduane Homogo ibuni ira hungu mberane timbuni tigabi mbiraha howa ibu bamba halu walia hama pene. Anidagua binigome Isaraele wali agali ti mbiraga horombebi hariga pobehe hene. ");
INSERT INTO hui_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Beraliba mberane tigabi timbuni biagome horombeni hariga bamba halu pugu bialu ira hungu mberane tigabi timbuni biagome mbiraganaga wá hadali hama hariga bamba hama pialu hene. ");
INSERT INTO hui_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Ani buwa Anduane Homogohanda Mosesehondo lalu, ");
INSERT INTO hui_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","Í̠na Isaraele wali agalihondo ogodagua lamialu, Tí ibirimidagua dai bialu haanda paluene anda yuwa unu iba solowara ange Pihahirodini bilimu, lalu lamibe. Dindi o mini larogoni Migido tanola Iba Daramabi bedagola dombeneha Balasebono dindi kaware nga. ");
INSERT INTO hui_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Ti dindi ogoriani anda yagimbu bu palu kamigo hondowa Iyibinaga kini biagome manda bialu karia Isaraele wali agali pu piyago ai agohayagi poabe toba howa dindi ko wali agali nahaga wiagoria tagira puwa nai pu luluyaho kagodalo manda bulebira. ");
INSERT INTO hui_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Ani biragola i̱na kini biagonaga bu mini mo giambe halu ndibulo helolebero. Ibunaga bu mini giambe howa ibugua tí gerai talima ibulebira. Tí minuyu dai bule lowa talima ibalu karia i̱na kini ogoni ibunibi ibunaga ami agalirubi bibahende bope halu i̱ wayali holebero. Ani wayali harogome wali agali biaru tigua i̱naga mini mo yaraga holebira. Ani bialu Iyibi wali agali tigua i̱ Anduane Homogo heneneore henedane hondolebira, lene. Ani layagola Isaraele wali agali biarume bilimu layadagua bialu ti dai bini. ");
INSERT INTO hui_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Ani biyagola agali marume kini biago lamialu lalu, Isaraele wali agali bibahende pu yola haya, lalu lamini. Ani lamiyago hale howa kini biagomebi ibunaga biabe biaga hearumebi lone mini wiadai bialu lalu, Ai o biagoni agua birimayabe. Isaraele wali agali bibahende pelai harimago ai inanaga garabaya biabe ale bia haga wiyagoni lone budai bule ndo ogonida, lene. ");
INSERT INTO hui_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Ani lowa kini biagome ibunaga wai biagane garo ale mini karisi nogo hosime gili lagabi nogo hosi agali berelowa piaga hearubi ibunaga ami agalirubi ho manda bilene. ");
INSERT INTO hui_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Ani ho manda buwa kini ibunibi ibunaga wai bigane karisi biago bibahendebi ogoni heba handari waragariago (600) pari wayali gibi hangugo tinaga wai hanaga agali haguane heba ho manda bialu Isaraele wali agali piyiyadagua haruru pene. ");
INSERT INTO hui_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Isaraele wali agali ti Iyibinaga hongo bolangua halu poramagoni lo mitangi bialu miniha turu timbuniore hama pene. Ani pialu heagola Anduane Homogohanda kini biagonaga bu mini mo giambeho tagi helayagola kini biagome abaleore Isaraele wali agali piyiyadagua haruru pene. ");
INSERT INTO hui_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Iyibinaga ami maru ti nogo hosime gili lelo karisi biagoha halu maru ti nogo hosini biralu maru ti geni pialu Isaraele wali agali talima gerai pene. Gerai talima pialu Isaraele wali agali haanda paleagoria Iba Daramabi bereago ange Pihahirodi dindila Balasebono dindila kaware ngelowa pu palearia tali minini. ");
INSERT INTO hui_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Isaraele wali agalime kini biagobi ibunaga ami biarubi tidu yalu kaware ti heagoria ibiyago hondowa ti gi timbuniore hene. Ani biyagola ti biamogo bilonaga Anduane Homogo olene. ");
INSERT INTO hui_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Ani buwa tigua Mosesehondo lalu, Namuali Iyibi dindini ina hora holenego homali naheyagola dindi ko wali agali nahaga ngagoria homoloma̱ya haru ibiribe. Ina Iyibi dindini harimadagua howa homoloma̱ya waha nabi ibirimagome ogoria hamaramagonida, lene. ");
INSERT INTO hui_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Ina Iyibi dindi howa tagira ibalu íbu nabi hemangi áyu o biradaguaore bulebira langirimagoni ndoyagoda. Aniore bulebira manda buwa ina harugo Iyibi wali agalinaga garabaya biabe ale bialu kamagonidagua bialu haabo holego í̠ wahalu pu larimagoni ndoyabe. Oali dindi ko wali agali nahagagoria homolenego wahowa namuali Iyibi garabaya biabe ale bialu harimago kamale bayale kamaleda, lene. ");
INSERT INTO hui_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Tigua ani layagola Mosesehanda ladai bialu lalu, Tí gi nahalimu. Tí bu mini dungulo daibu hadaba. Ani bidamigola Anduane Homogo ibugua tí pele ngulebirago áyu hondoleberami. Iyibi agali o tidu yalu ibirane hendedamigoni mani lone nahondoleberami. ");
INSERT INTO hui_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Tínaga wai Anduane Homogo ibugua bia holebirago tínime mbira bulene nawigo tí ema nabi holene dege nga, lene. ");
INSERT INTO hui_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Ani leagola Anduane Homogohanda Mosesehondo lalu, Biamogo bia lowa i̱ olalu kamigoni aginagabe. Isaraele wali agali ogodagua lamialu, Gi nahe heyalu pudaba, labe. ");
INSERT INTO hui_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Mosese í̠naga halimbu biago yaraga howa Iba Daramabi bedagoha dogola angua habe. Ani beregola iba o bedagoni bira li ni bulebirago. Ani biragola dombeni hariga ngagola Isaraele wali agali ti dindi yobini hariga uba ede halu pobehe holebira. ");
INSERT INTO hui_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Ani birago hondowa Iyibi ami ti bu mini mo giambe harogola ti mina tagotago porabupe halu ti talima gerai ibalu karia bibahende ibame nai helolebero. Ani bialu i̱na kini agali biagobi ibunaga ami agalirubi ibunaga garo ale mini karisi nogo hosime gili laga ngarubi agali karisi ogoriani heyu piaga karubi bibahende bope halu i̱ wayali holebero. ");
INSERT INTO hui_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","I̱na ti bope halu i̱ wayali harogo hondowa Iyibi wali agalime i̱ Anduane Homogo henedane hondolebira. ");
INSERT INTO hui_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Ngode Datagaliwabenaga dahuliyali mbira Isaraelenaga ami erembiraha helowa ibu ala wai deni pu halu hariga bamba haga henego ogoni ibu dai buwa Isaraele wali agali erembirahayagi hene. Ani biyagola hari beraliba mberane hariga bamba halu piaga biago ibubi hadai buwa erembirahayagi dege hene. ");
INSERT INTO hui_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Ani bialu Isaraele wali agalibi Iyibi ami agalirubi ti hengeneha ogonilabo libu hene. Hari beraliba mberane biagome Iyibiali ibiyagohayagi arumaho mialu Isaraele wali agali heagohayagi wáho mini. Ani biagola mbiraga odangi Isaraelenaga amirubi Iyibinaga amirubi libu handaya halu ngola habe nahe hene. ");
INSERT INTO hui_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Ani bu howa Mosesehanda ibunaga gime halimbu biago yaraga halu iba biagoha dogola angua hayagola Anduane Homogohanda puyabu hongohe ni tagira ibiragohayagi ibilowa pu dege lalu heaore gao lene. ");
INSERT INTO hui_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Ani biyagola iba biago bira li ni biyagola dombeni yobi wiaria Isaraele wali agali ti uba ede hole pene. ");
INSERT INTO hui_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Ibani hariga wiagoria pole pialu hearia Iyibi ami biarume haruru nogo hosini bira nogo hosime gili laga karisi biagoria ha bigi bialu Isaraele wali agali piyadagua haruru pene. ");
INSERT INTO hui_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Talima pialu hearia Anduane Homogo ibu ira hungu mberane biagohabi hari beraliba biagohabi howa egabi lolebiyahayagi handadali halu Iyibinaga ami tidu yalu piyago hondowa ami biarunaga mini mo luluya hene. ");
INSERT INTO hui_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Karisi hosime gili laga biarunaga ge dindi wiagoha bahora helayagola abale dugu mialu pobe nahe ndelahe handalu hene. Ani biyago hondowa Iyibiali biaru tinime lalu, Anduane Homogo ibu wai Isaraelehayagi anda pu howa ina o baragonidago ibida ma nalarimigo. Áyu ogoni ma, lene. ");
INSERT INTO hui_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Ani lalu heaha Anduane Homogohanda Mosesehondo lalu, Iba bedagoha í̠naga gi dogola ede ha. Ani beregola iba o biru migimigi bidagoni lone bira gimbu buwa Iyibiali o tiduyu ibiraruni biranamu lalu iba nai holebirago helo ani bia, lene. ");
INSERT INTO hui_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Ani layagola Mosesehanda ibunaga gi dogo lowa iba biago ya angua hene. Ani buwa egerebagi gao layagola iba biagoni labo biraga biadagua biru gimbu bini. Ani biyagola Iyibiali biaru ibida pole bialu hearia Anduane Homogohanda ibunaga hongome bibahende ibaha mo para howa bai hene. ");
INSERT INTO hui_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Iba biagolabo lone bira gimbu buwa karisi biarubi agali karisi ogoni yagarubi Iyibinaga ami bibahende Isaraele wali agali haruru talima ibini biarubi mbira yu wanahe bibahende iba nai helene. ");
INSERT INTO hui_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Ani biya handala Isaraele wali agali ti dindi yobini iba lene labolabo bira migimigi bilowa dombeneha pialu angeni uba edede bini. ");
INSERT INTO hui_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Horo odangi Anduane Homogohanda Isaraele wali agali Iyibialime balu hearia mo wialu Iyibiali o beadagoni. Ani bialu Isaraele wali agalime handalu hearia Iyibiali biaru homo payapaya buwa ede iba angeni wiaria hendene. ");
INSERT INTO hui_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Anduane Homogohanda ibunaga hongo gibime Iyibiali biaru bibahende bo wahai hayago handayagola Isaraele wali agalime tinaga bi nawiyagola ti gi dege dindi howa Anduane Homogo geha handa daga daga bu hene. Ani bialu tigua Anduane Homogohondobi ibunaga biabe biaga Mosesehondobi mini mbiraore wini. ");
INSERT INTO hui_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Ani biyago hondowa Mosese Isaraele wali agali hearumebi turu howa wai bi lalu iba gana ogo Anduane Homogohondo lo mini. Áyu Anduane Homogohanda wai bialu wayali taraore hayagonaga i̱na Anduane Homogohondo iba gana lo mulebero. Anduane Homogohanda Iyibinaga nogo hosibi nogo hosini agali berearubi ibaha minu bope hayagoni. ");
INSERT INTO hui_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Anduane Homogo ibugua i̱ mo hongo haga kago i̱na ibunaga mini yaraga halu iba gana lolebero. Ibugua i̱ pele ngiaga kago i̱na ibunaga mini mo yaraga halu iba gana lolebero. Ibu i̱naga Ngode Datagaliwabe kago i̱na ibunaga mini mo yaraga holebero. Ibu bamba i̱ abanaga Ngode Datagaliwabe hene kago i̱na ibunaga mini lene daligaore wini ngago mo yaraga halu iba gana lolebero. ");
INSERT INTO hui_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Anduane Homogo ibu wai biaga kago ibunaga mini Anduane Homogo ka. ");
INSERT INTO hui_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Ibugua Iyibi amirubi nogo hosirubi nogo hosirume gili laga karisirubi karisi yaga agali hearubi bibahende iba solowaraha bopebe biai haya. Iba solowara mini Iba Daramabiha bopebe biyagola Iyibi ami haru haga haguane hearu ibame nai haya. ");
INSERT INTO hui_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Bopebe biyagola bibahende ibaha ege to̱le̱ ibira haradagua bialu unura yupebe bialu ibame nai hayagoni. ");
INSERT INTO hui_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Anduane Homogo-o í̠naga gi tigagoore hongo gibioreya. Í̠naga waitigi hearu bame gi mbiraoreme bo gingirulo paya bialu barigoni handarima. ");
INSERT INTO hui_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Hongo gibihegonime í̠naga waitigi bibahende bope harigoni. Í̠naga keba holenego ira hungu kiaulo tagi haradagua bialu gambe aea daradagua í̠naga waitigi karu bo ereba hareya. ");
INSERT INTO hui_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Í̠na puyabu hongohe pu lelarigoni. Puyabu hongohe puloyu ibiyagome iba biago daliga biruyu iraga helaya. Iba biago halu ki bira migimigi buwa gana wa mini hagahaga biradagua biya. Iba kuyamaore unu dindiha bereago giambe hodaga hayagola ege mbaulene. ");
INSERT INTO hui_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Inanaga waitigirume lalu, Ina talima ibalu tigua ina minu yani howa inanaga mbirale bayale yidamaru gingilamu yuwa mo tale bimi̱ya. Ina hame lara alego mo ya dege bimi̱ya. Iname ayu tibu yidamarume balu inanenaga hongome Isaraele wali agaliore mo ko howa bami̱yago ma, lalu hongoho yalu ibirimi. ");
INSERT INTO hui_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Ani bu yalu ibiyago ndo Anduane Homogo í̠na í̠naga buhe̱ halu mbira hangu latagi harigome Iyibiali biaru bibahende iba nai hayagoni. Ibaha to̱le̱ ibira haradagua unuraore ti kuni duguale ndoni yupe hayagoni. ");
INSERT INTO hui_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Anduane Homogo-o dama tara tarahondo bi pupu wiaga bu karuni aria mbirago hongohe í̠ aleore ai kabe. Daligaorebi duninibi baya buruguleorebi í̠ni dege kegoni. Í̠na hongo gibi howa agalime nabiagane ale tara tara bigi berego wali agalime í̠ hondowa gi timbuniho bu kagoni. ");
INSERT INTO hui_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Í̠na í̠naga gi tiga biago dogola amu harigola dindi wiagome ne ha̱lowa inanaga waitigi hearu minu mbedogo biya. ");
INSERT INTO hui_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Í̠nime haru holebero lalu lo wiridagua heneneore wali agali í̠ni pele miriru baya hangu haru halu í̠ninaga hongome ina haru halu dindi mbira wali agali nahaga í̠ni dege haga wiagoha haru ibirigo kamagoni. ");
INSERT INTO hui_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Wali agali dindi tara tarani hearume í̠na bigi biriru hale howa ti gi dege dindi howa duru ala lalu kagoni. Pilidiali karubi gi timbuniore halu kagoni. ");
INSERT INTO hui_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Idomo dindinaga agali haguanerubi gi timbuniore ho ka. Moaba dindinaga agali hongohe karubi gi howa duru ala lalu kagoni. Kenana wali agalinagabi hongo bibahendeore pirilipe hai henego ka. ");
INSERT INTO hui_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Gi holenebi mogo lolenebi ti kagoha ibiraho nga. Anduane Homogo-o tigua í̠naga hongo timbuni kegoni hondowa ti gi dege dindi howa mbirale mbira bibe nahe ka. Ti bame de pigi piagolo ira tili haradagua bu ka handala helalu í̠naga wali agali Iyibi dindi garabaya hemaria golope hene kamaru iname ti bolangua halu pole kamagoni. ");
INSERT INTO hui_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Garabaya hemaria golope halu haru halu ibuwa í̠ninaga hari mbira í̠ni ogoriani hole lowa dabo wini biagoria haru puwa berelo harili. Anduane Homogo-o hari ogoriani í̠nime í̠ninaga anda bulebere. ");
INSERT INTO hui_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Ai Anduane Homogo-o í̠ handame haga kini haluhe haabobo haga kegoni, lalu iba gana lene. ");
INSERT INTO hui_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Iba solowara mini Iba Daramabi biago dombeneha hariga yobi wiyagoria Isaraele wali agali ti dindi ange mendeha howa ange mendeha uba ede hene. Ani uba edede biyaru hondowa Iyibinaga ami biarubi nogo hosini berearubi nogo hosirume gili laga karisini agali heyu hearubi bibahende Isaraele wali agali talima ibaha hariga wiadagua yupebe bialu hearia Anduane Homogohanda iba biago lone biragimbu bilayagola Iyibiali biaru bibahende ibame nai hene. ");
INSERT INTO hui_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Ani biyago hondowa Anduane Homogonaga mana latagi haga wali Arono mbalini Miriamuhanda ibunaga ngilinge̱le̱ laga irabitele ale mbira wiago mo yayagola Isaraele wali maru berearume nde tininaga ngilinge̱le̱ laga wiaru mo yagayaga bialu Miriamu piyadagua haruru pialu irabitele ale balu turu howa ae̱a kae̱a bialu mali lima pialu hene. ");
INSERT INTO hui_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Ani pialu howa Miriamuhanda tihondo iba gana mbira ogo lo mini. Anduane Homogohanda wai bialu wayali taraore hayagonaga ibuhondo iba gana lo midaba. Ibugua nogo hosibi nogo hosini agali berearubi bibahende mo paraho bagabu ibame bo nai helayagonaga Anduane Homogohondo iba gana lo midaba, lalu lama pene. ");
INSERT INTO hui_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Uruni bialu Mosese ibugua Isaraele wali agali Iba Daramabi bere biagoria howa haru halu pialu dindi ko wali agali nahaga mini Sua wiagoria haru anda pene. Puwa horo tebiru dindi ko wali agali nahaga ogoriani pu dege bialu iba nolene mbira nabereoreyane hendene. ");
INSERT INTO hui_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Ani bialu dindi mbira mini Mara wiagoria anda pialu hemiria iba mbira bereago hondowa iba biago nole birimiria nabenahe kau gibiore bini. Dindi ogoriani iba kaubi ogoni bereago hondowa dindi ogoni mini Mara inanaga bi lalu Kaubi wininagaya. ");
INSERT INTO hui_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Wali agalime iba biago nalu hemiria kaubiyago hondowa tigua keba howa Mosesehondo gimigomo lalu lalu, Ina iba agi noledabe, lene. ");
INSERT INTO hui_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Ani layagola Mosese ibu mini burugu lowa ibugua Anduane Homogohondo hongo howa bi lene. Bi layagola Anduane Homogo ibugua Mosesehondo ira gabini mbira wiago mo walia hayagola Mosesehanda ira gabini biagoni muwa ibaha mo bape hayagola iba biago kau biyago ereba halu dendebi hene. Ani bialu dindi ogoriani Anduane Homogohanda Isaraele wali agalihondo ibunaga bi mana lamialu lalu, Langerodagua bilimu, lene. Ani bialu dindi ogoriani dege hearia ibugua ti ba handalu hene. ");
INSERT INTO hui_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Ani bialu ibugua tihondo lalu, Tígua i̱na bi larogo damene bibahende hale halu biaiore halu i̱na mana bayale manda bidogo bilimu larodagua bialu mana maru ko manda bidogo nabilimu laruyagua nabilimu. Aniore birimiyagua i̱na Iyibi wali agalihondo warago tara tara mirugodagua tíhondo nangulebero. I̱ Anduane Homogo i̱na tí mo dabi haga biago kogoni, lene. ");
INSERT INTO hui_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Ani bialu Isaraele wali agali ti dindi ogoni yu wahalu dindi mende mini Elimi iba nairia duguaga duguaga bialu homberia (12) dugualuhe bibi ayage ale mini dedi dege panda pira karia (70) buhe wiagoria anda puwa ogoriani handa palene. ");
INSERT INTO hui_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Isaraele wali agali lenego bibahendeore Elimi dindi yu wahalu pialu dindi ko wali agali nahaga mbira mini Sini wiagoria tagira pene. Dindi Sini ogoni Elimila Sainaila dombeneha wini. Isaraele wali agali ti Iyibi dindi yu wahalu tagira ibuwa heane ege mendegonaga horo nguinini (15) Sini dindi anda pene. ");
INSERT INTO hui_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Ani anda puwa Isaraele wali agali bibahende dindi ko wali agali nahaga wiagoriani howa Mosese Aronolahondo gomogomo lalu hene. ");
INSERT INTO hui_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Tigua gomogomo laga bialu howa ogolabohondo lalu, Inaore Iyibi dindini hemaore Anduane Homogohanda bo wahai nahayada. Ne nalu homabe lene ngago ina Iyibi dindi henedale nogoru bame dawa paya buwa ne tara tara ngaru mo yu ngoai howa inane biru mabu buwa nolenegobiore nowa to̱lotagi halu homedamale karulape. Ai ani bule ndo libugua ina ogoria haru ibiribigome ne noa ha dege bialu noa halu homoleni lenego henene áyu ne noa halu homole o kamagonida, lene. ");
INSERT INTO hui_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Ani lalu heago hondowa Anduane Homogohanda Mosesehondo lalu, Ai áyu i̱na tí bibahende tomo nalimulonaga tomo hariha howa ibira ibira bulebero. Ani buleberogo wali agali ti horo bibahendengi tagira pugu bialu tomo horo mbiru odangi hangu naga bulenedagua migi bulene nga. I̱na bi o lamerodaguaore birabe be o larogoni mo waharabe hondoliya ani bidaba labe. Ti ogoriani ba hondoliya. ");
INSERT INTO hui_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Horo bibahendengi horo mbira ogonaga dege nolenedagua migi bialu horo waraganeni o horo kirunaga nolene mo yu wilimu laya lalu lamibe, lene. ");
INSERT INTO hui_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Ani laya handala puwa Mosese Aronolame Isaraele wali agali bibahendehondo lamialu lalu, Uru-o alendoore tí Iyibi dindini hemira haru tagira ibiyagoni Anduane Homogohanda ani binida lowa manda buleberami. ");
INSERT INTO hui_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Yawi egerebagi tígua Anduane Homogo ibuni tí heba ko lalu walia halu wá holene taraore de mborerebime ina kamagoria hadali holebirago hondoleberami. Tígua ibuhondo gomogomo laga birimiruni ibu hale hai haya. Nde gomogomo larimiruni mbiralihondo larima lolebe ibuhondoore larimigoni ndobe. Arono iyame bame ibugua ogoale bia ogoale ladaba laga biyago bia la bialu kabagoni ndobe, lene. ");
INSERT INTO hui_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Ani lowa Mosesehanda lalu, Ani bigi birimigo áyu Anduane Homogohanda tí tomo nalimulo ngulebira. Tí tomo noa biragobiore alendo nalimulonaga ega de̱wa̱re ale ngulebira egerebagi nalimulonaga mena ngulebira. Tígua ibuhondo gomogomo laga birimiruni aguaore larimi ibu manda biaiho kago ibugua tí tomo noa harimidadagua nalimulo ngiaore bulebira. Tígua Arono iyahondo gomogomo lama hariha bi la bigi birimiyagua ogoni iyahondo ndo tí Anduane Homogohondo larami, lene. ");
INSERT INTO hui_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Ani lowa Mosesehanda Aronohondo lalu, Isaraele wali agali bibahende lamialu tígua gomogomo larimigoni Anduane Homogo ibu hale hayago áyu Anduane Homogo ibu deni tí heyu hole ogoria ibai halimu, laya lamibe. ");
INSERT INTO hui_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Ani layagola Arono ibugua puwa Isaraele wali agali lamiyagola haleho howa Isaraele wali agali ti de amu dindi ko wali agali nahaga wiagohayagi handa amu halu hearia au tobane buwa Anduane Homogonaga wá holene taraore de mborerebigo hari beralibani tagira ibiyaria hendene. ");
INSERT INTO hui_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Ani hondo hearia Anduane Homogohanda Mosesehondo lalu, ");
INSERT INTO hui_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","Isaraele wali agalirume gomogomo lalu hearuni i̱ hale haru. Ani hale harugo Isaraele wali agalihondo ogodagua lamibe. Áyu alendoore ne̱le̱ni̱ni̱ ega de̱wa̱re ale bo dawa nalimulo ngulebero. Ani bialu yawi egerebagi mberedi tí noa biragobiore nalu nama mangaore halimulo ngulebero. Ani ngerogo no howa tígua i̱ Anduane Homogo tinaga Ngode Datagaliwabeore i̱ni henedane hondoleberami, lene. ");
INSERT INTO hui_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Ani layadagua alendo ne̱le̱ni̱ni̱ hayagola ega de̱wa̱re ale wabuni yagalo yalu ibuwa Isaraele wali agali anda bu palu heagoria biru haealome howa dindi namulai hene. Ani bialu egerebalene tani anda hane hane headagua pibira birame hene. ");
INSERT INTO hui_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Pibira biago yo biyagola mbirale emene adadabi mbira ira yuniru gingirulo bigi bini mbaulego o biagoriani haealo payabu wiame hearia hendene. ");
INSERT INTO hui_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Hondowa Isaraele wali agali ti o bu payabu wiagoni agigo wiyabe toba howa tinihondo hale haga haga bialu o bu payabu ngaruni agiledabe lalu hene. Ani lalu hearia Mosesehanda tihondo lalu, Anduane Homogohanda tí tomo nalimulo ngulebero layagoni tíhondo o ngidagoni. ");
INSERT INTO hui_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Ani ngialu howa Anduane Homogohanda au laya. Tí hangu hangume tínibi tí one waneiginibi nolenedagua mo mogobu wilimu, laya. Tí andagaha paliaru daga lowa homane mbiraligo ibunaga todobene be emene mbirago mo to̱lo ba a̱i̱ ho wigi bilimu laya, lene. ");
INSERT INTO hui_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Isaraele wali agalime Mosesehanda lamiyadagua bia binigoyu marume bi layago pugualu dewaore mo bolangua howa ilu mogobu wialu marume emene dege ilu mogobu wialu bini. ");
INSERT INTO hui_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Ani bia binigo nde andagani mo yu puwa magi handalu hemiria minime dewaore bolanguaho mule mandabu mia miyago magini Mosesehanda layago bolangua nahene. Ibugua layagoria ha iri hene. Ai emeneore mo yini hearubi andagani puwa dege magi handalu hearia emene yidamabe toba hearia emene ndo Mosesehanda magi layagoore karulape yarimayane hendene. Ani bialu ti bibahende tini nolenedagua karulapeore mo yagayaga birimayane hendene. ");
INSERT INTO hui_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Ani bialu Mosesehanda tihondo lalu, Tomo ogoni bibahende áyu hangu nai halimu. Yawi nole mbira nangelalimu, lene. ");
INSERT INTO hui_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Ani lamiyago hale howa dege maru ti Mosesehanda bi layago mo wahalu tomo biago maru egerebagi nole lowa mo wini. Mo wiaria tomo mo wiyago bibahende togo buwa himi dibidabu lalu ngu hiriribi biame hene. Ani biyago hondowa Mosese ibu wali agalidaru baba keba gibi hene. ");
INSERT INTO hui_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Ani bigi bialu egerebagi bibahendengi wali agali hangu hangume tagira pugu bialu tini nolenedagua mo wigiwigi bini. Ani mialu peha ni dalu tandaga biyagola tagirani mialu ibira hene bu payabu wigi biaru nime do egege lalu ereba haga bini. ");
INSERT INTO hui_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Ani bigi bialu horo waraganeni ti hangu hangume tomo mo mogo bigi biyadagua dege haluki horo kiru nolene mo mogo bialu todobene be emene mbira to̱lotagi howa mo yagayaga bini. Ani biyago hondowa Isaraele wali agali haru haga agali haguane hearume aguani biyago hondowa tigua wali agalime agua bira lalu Mosese lamule pene. ");
INSERT INTO hui_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Lama pialu hearia Mosesehanda tihondo lalu, Anduane Homogohanda yawi ha̱lo holene horo loma bini wulebira laya. Yawi Sabada horo tara Anduane Homogo ibu hangu mitangi bialu holene wulebira laya. Ani layago ai tomo irani hirule ngamiru áyu howa hirule manda bu wu palialu dawale ngamirubi áyu howa dege dawa mandabu paluene nga. Hira dawa bialu ibira harago yawinaga mo bagiho ngelalimu, lene. ");
INSERT INTO hui_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Ani lamiyagola Isaraele wali agali tigua Mosesehanda lamiyadagua hale halu bialu tomo hira dawa bialu ibira hayago egerebaginaga mo ngelene. Egerebanaga mo wiyaruni egerebagi handalu hearia ngu bialu himi dibidabu nale bayale wiaria hendene. ");
INSERT INTO hui_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Ani handalu Mosesehanda wali agalihondo lalu, Horo áyu Sabada horo biabe nabi ha̱lo howa Anduane Homogonaga mini yaraga halu hami̱ya kamagoni. Ani hami̱ya kamago horo áyu mbirali tomo taya bima putagi halu napoleberami. Mbirali napoleorego ti tomo noa biyagua abe howa áyunaga lalu bagiho wirimigoni noleberami. ");
INSERT INTO hui_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Tí horo waragaruni tomo mo wigi bialu horo kanegoria ha̱lo holenengigo horo ogoningi tomo mbira dindini ibiraho nawulebira, lene. ");
INSERT INTO hui_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Ani layago lelowa wali agali maru ti horo kanengi tomo nawulebirago mo tagira napilimu layago hale howa dege donge halu tomo ngalono mo tagira pialu hearia nawiaria hendene. ");
INSERT INTO hui_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Ani biyago hondowa Anduane Homogohanda Mosesehondo lalu, Wali agali tígua i̱naga bi tí langialu ogoale bilimu laga berogo bule ndo tí dogaho howa mine halu tíni hame ledamidagua bialu kamigoni. Ainde angiore i̱naga bi hale halu bule kamibe. ");
INSERT INTO hui_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Horo áyu Anduane Homogo i̱na howa tí i̱ mitangi bialu ha̱lo halimu langirugoni ndobe. Ani bialu halimulonaga horo waraganengi i̱na tí tomo horo kiru nalimulonaga manda buwa ngiaabo holebero. Ani buleberogo horo kanengi wali agali bibahende mbiraligo mbira tagira pialu nape andagani hai holeberami, lene. ");
INSERT INTO hui_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Anduane Homogohanda ani lamiyagola Isaraele wali agali ti horo kane ogoningi biabe nabi ha̱lo haga hene. ");
INSERT INTO hui_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Ani henego Isaraele wali agalime Anduane Homogohanda miyadagoni mini mena lene. Mena ogoni ibuni pele emene ladi alego dendenaga mone ibane nalehe nelo mini. ");
INSERT INTO hui_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Ani minigo Mosesehanda Isaraele wali agalihondo lalu, Anduane Homogohanda iname be emene mbira dindime wabinigo muwa be ogoniha mena mo gambiru to̱lotagiho ngelalimu, laya. Ani mo gambiru ngelalimu layago irane awe inanaga waneigini aguaneru mani holebirarume tinaga mamaliru Anduane Homogohanda Iyibi dindi howa haru tagira puwa tomo miniyago ogoniore nelo minidalo hendelonaga mo gambiru ngelalimu laya, lene. ");
INSERT INTO hui_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Ani lowa Mosesehanda Aronohondo lalu, Be mbira muwa mena ogoniha mo to̱lo yalu puwa Anduane Homogonaga deni ngelabe. Inanaga waneigini aguane mani holebirarume de handalu manda bilo ani ngelabe, lene. ");
INSERT INTO hui_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Anduane Homogohanda Mosesehondo ani bibe leneyadagua Mosese ibugua Aronohondo bia layagola Arono ibugua hale halu beha mena mo tolo̱tagihe biago yalu puwa Habo Nalolene Bi lo winigonaga Mbogoyi wiago buha wiaabo holeneni wini. ");
INSERT INTO hui_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Ani bialu Isaraele wali agali ti tomo mena ogoni nalu heane mali pira maria (40) pene. Ani nalu howa dege Kenana dindi anda puwa tini tomo hengenego nalu wahene. ");
INSERT INTO hui_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Horo odaruningi mbirale magi hondolenenaga todobene be emene ale karulape handaga wialu magi mende timbuni todobene emene ogonibi pira biamaga howa handabehe wialu bini. ");
INSERT INTO hui_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Isaraele wali agali lenego bibahendeore Anduane Homogohanda lamiyadagua bialu dindi ko wali agali nahaga mini Sini biago yu wahalu pene. Ti pialu dindi mbira mini Lebidimi wiagoria anda puwa ogoriani haanda palu hene. Ogoriani palu howa handalu hearia iba nolene nabereoreyane hendene. ");
INSERT INTO hui_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Ani hondowa tigua Mosesehondo keba howa lalu, Ai iba noloma̱ya ngia nabere, lene. Ani layagola Mosesehanda ladai bialu lalu, Tí aginaga keba howa gomogomo lalu kamibe. Tígua aginaga Anduane Homogo ba handalu kamibe, lene. ");
INSERT INTO hui_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Mosesehanda ani layago lelowa dege wali agali biaru ti iba noa howa hége lebola hayagola Mosesehondo keba howa gomogomo dege lalu hene. Tigua Mosesehondo lalu, Í̠na ina Iyibi dindi hemaria haru tagira ibirigoni irane aginaga haru tagira ibiribe. Inanebi ina waneiginirubi inanaga nogorubi iba noa ha dege bialu tongolo muluma̱yanaga hawa haru tagira ibiru nalarego, lene. ");
INSERT INTO hui_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Tigua ani layago hale howa Mosesehanda Anduane Homogohondo deremola howaore bi lalu, Wali agali o bu karume áyu dege i̱ to̱le̱me bo waharagonidago aiore nde agua buadabe, lene. ");
INSERT INTO hui_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Ani layagola Anduane Homogohanda Mosesehondo lalu, Isaraele wali agali haru haga agali haguane maru karu haru halu tí ala bamba halu pudaba. Pialu howa í̠naga halimbu iba Naili baga yu hariligoni giha yalu pobe. ");
INSERT INTO hui_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","I̱na uyu Hari Sainaini puwa ege to̱le̱ mbirani i̱naga de tiga tiga heyu holebero. Ani buleberogo í̠na o larudagua bialu puwa ege to̱le̱ o larogoni í̠naga halimbume babe. Baregola wali agaliru ti iba nelo ege to̱le̱ ogoniha howa tagira ibulebira, lene. Ani layadagua puwa Mosesehanda Isaraele wali agalinaga haru haga agali biaru handayaho helowa Anduane Homogohanda bibe layadagua bini. ");
INSERT INTO hui_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Ani bialu Isaraele wali agalime Anduane Homogohondo keba howa gomogomo laabo halu lalu, Anduane Homogo biagoni ina heba kabe be pebe tobaneya, layagonaga dindi odagoni mini Masa Meribala wini. ");
INSERT INTO hui_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Ani binigo Isaraele wali agali Lebidimi dindini hearia Amalege agalirume bo anda ibini. ");
INSERT INTO hui_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Tigua Isaraele wali agali bo ibulebira layago hale howa Mosesehanda Yosuahondo lalu, Yawi Amalege agaliru baba wai bu pelonaga í̠na Isaraele agali maru wai bibehego hondowa erelomigi buwa dabo helabe. Agali o dabareruni tigua Amalege agaliru baba wai biragola i̱na bare hombene biagoria heyu howa i̱naga halimbu Ngode Datagaliwabehanda giha yabe layago yu holeberogo, lene. ");
INSERT INTO hui_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Ani lamiyagola Yosua ibugua Mosesehanda lamiyadagua bialu Isaraele agali maru bu̱lu̱migi buwa haru halu Amalege agaliru baba wai bu pene. Ani piya handala Mosesebi Aronobi Huabi tigua hari biago neneni pu hene. ");
INSERT INTO hui_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Ani pu howa Mosesehanda ibunaga gi kirabali hariha yaragaho haga biagola Isaraele tigua Amalege bo podama anda pugu bini. Ani bialu Mosese ibunaga gi yu ibira haga biyagola Amalege tigua Isaraele bo podama dai bigi bini. ");
INSERT INTO hui_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Ani bigi bialu Mosese ibunaga gi hi halu yu ibira habehe haga biyagola Arono Hua libugua to̱le̱ mbira Mosese berelo mo yalu ibuwa Mosese ibu ogoriani bereagola libugua lene labolabo howa Mosesenaga gi yaragaho hene. Ti wai biyago de handape ho biruwa libugua Mosesenaga gi baya hangu ema nabi yaraga howa haabo dege heane ni palene. ");
INSERT INTO hui_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Ani dege bialu Yosuahanda haru howa Isaraele agalirume Amalege agaliru mo ko howaore bo paya paya biai hene. ");
INSERT INTO hui_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Ani buwa Anduane Homogohanda Mosesehondo lalu, Ai áyu Amalege agaliru baba wai bialu bo hana harimigoninaga te mbirani gili bu wibe. Tí mani hama poramiha áyu wai bialu pari wayali harimigoni embeda nahe mitangi biaabo holenaga ani gilibu wibe. Ani bialu í̠na Yosua lamialu, I̱na Amalege agaliruore mbira yu wanahe bibahendeore bo mburi lolebero, laya lamibe, lene. ");
INSERT INTO hui_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Ani layadagua lamuwa Mosesehanda Ngode Datagaliwabenaga lomabu delolene dabu mbira buwa dabu odagoni mini Anduane Homogo ibu i̱naga Humbi ka wini. ");
INSERT INTO hui_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Ani wuwa ibugua lalu, Anduane Homogonaga waibi, daliga ladaga howa ladaba. Anduane Homogohanda Amalegeali baba wai bialu haho wiaaboore holebira, lene. ");
INSERT INTO hui_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Mosese imane ibu Midianalinaga loma binigo mo miaga biago Yadero ibugua Ngode Datagaliwabehanda Isaraele wali agali Iyibi dindi howa haru tagira ibalu Moseseha howa biabe agua biya Isaraele wali agali agua biamogo biya lalubi te laga biyago haleho hene. ");
INSERT INTO hui_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Ani hale howa Yadero ibugua Mosese one Sibora namu Midiana dindi berea handala penego Mosese ibuni hearia haru ibalu ");
INSERT INTO hui_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","libunaga igini kira Gesomo Elieselabi heba haru ibini. Mosese ibuni manda bialu ibu dindi tarali mendeali dindini bame igiri yango íbu harugo manda buwa ibu igini mbirago mini Gesomo wini. ");
INSERT INTO hui_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Ani bialu ibu bamba Iyibi dindinaga kini heagome bo wa kalego ibu abanaga Ngode Datagaliwabehanda ibu biamogo bialu mo wiya manda buwa ibu igini mendego mini Eliese wini. ");
INSERT INTO hui_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Ani binigo Yaderohanda Mosese onebi Mosese igini kira biago labobi haru halu dindi ko wali agali nahaga hari loma biaho wini biagoria Mosese ogoriani hearia haru ibini. ");
INSERT INTO hui_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Yadero ibugua Mosese one iginiru haru ibalu howa ani haru ebero lalu bi ala lo pelene. ");
INSERT INTO hui_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Ani ibira layago hale howa Mosese ibu lolaho pene. Mosese ibugua ibu imane lola howa ibu bulu paluwa ibu imane yu hurubale bini. Ani buwa libuni waragoru mbira balu henedabe nabe henedabe hondole hale haga haga buwa Mosesenaga balai andaha haru pene. ");
INSERT INTO hui_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Ani pu biruwa Mosesehanda ibu imane Yaderohondo Anduane Homogohanda Isaraele wali agali golope halu haru tagira polenaga Iyibinaga kini biagohondobi Iyibi wali agali bibahendehondobi biyaru damenego lamiai hene. Ani lamialu Isaraele wali agali ti haru tagira ibinigo ibalu heariabi harigani gendabi ndelahe tara tara handaga bialu hearia Anduane Homogohanda biamogo biyarunaga bi tebi lamia dege bini. ");
INSERT INTO hui_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Mosesehanda te laga bigi biyagola Yadero hale howa ibu turu timbuniore hene. ");
INSERT INTO hui_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Turuore howa ibugua Mosesehondo lalu, Iyibi wali agalimebi Iyibinaga kini heagomebi í̠ bolene winigo Anduane Homogohanda mo wiyadagonaga Anduane Homogonaga mini yaraga hami̱ya. Anduane Homogohanda ibuninaga wali agali garabaya biabe ale bialu hearia golalu gi miyadagonaga Anduane Homogonaga mini yaraga hama nalaramigo. ");
INSERT INTO hui_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Aiore Anduane Homogo ibu mbirale tara tarahondo bi pupu wiaga ngaru bibahende bope hai howa ibu daligaore haruane hendedo. Iyibi wali agalime Isaraele wali agali handabe manga gibi howa haru hayadagoni haru tagira pole o biyadago handarogola gibiore haruane hendedo, lene. ");
INSERT INTO hui_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Ani lowa Yaderohanda nogo tara mbira homa hende Ngode Datagaliwabehondo loma bialu bo delo mule haru ibalu mbirale marubi heba delole yalu ibini. Ani biyagola Isaraelenaga haru haga hearu bibahende Arono heba puwa nogobi tomobi loma binigo yu íbu wiyadagoni Ngode Datagaliwabe mitangi bialu ibu mo dunini howa lotu lolenaga nole pene. ");
INSERT INTO hui_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Horo mendengi Mosese ibu wali agali tini degedege lai lalu hearu mo tiga bialu hene. Egerebagi howa wali agalinaga genda wiaruni mo tiga bialu heaore dege mbiraga hene. ");
INSERT INTO hui_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Mosese ibugua dege biabe bulene emene ndoore bu payabu wiaru hondowa Yaderohanda Mosesehondo lalu, Í̠na wali agalinaga genda ngaruni mo tiga bialu kegoni agua berebe. Wali agali ho mabubu helowa homane í̠ni hangume erekuibi lo tiga bialu kegoni nde í̠ni hanguoreme lolene ngadagua lo tabalu bede agini. Wali agali egerebagi ho wahalu alendo haga bialu o bu karuni nde í̠ baba dege bi loledago manda bideni, lene. ");
INSERT INTO hui_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Ani layagola Mosesehanda ladai bialu lalu, Wali agali tinime i̱ koria ibugu bialu gendabi ngaru langigi biragola i̱na tihondo Ngode Datagaliwabehanda bilo hame ledago ogodagua bulene ngago agua bilimu lalu lamigi biruli. ");
INSERT INTO hui_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Kirali libu lai lalu mini iriari biyagua i̱na lo tiga buliya i̱ koria ibugu biragoni. Ani ibugu biragola i̱na hale halu tale buwa ogome larago tigabi lara lalu lamialu Ngode Datagaliwabenaga bi lo ngagome ogo ale bibe nabibe lalu ledagobi lamia dege bialu kogoni, lene. ");
INSERT INTO hui_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Ani layagola Yaderohanda ladai bialu lalu, Ogoni tigabi ndo bialu kegoni. ");
INSERT INTO hui_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Ogonidagua biaabo hariyagua í̠nibi wali agali bu karubi binigo ale bia dege bialu kalukalu bialu ngoe̱ ngoe̱ lalu hongo pirilipe hai holeberami. Biabe gendabi ogonibigo homane í̠ni hangume nabibehe kegoni. ");
INSERT INTO hui_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Anidane hendedogodago ai ogodagua bulene nga lalu bi maru langerogo hale habe. O langerodagua bibelo Ngode Datagaliwabe ibunime í̠ heba howa biamogo bulebira. Anigo í̠na wali agali tini degedege lai lalu mini iriari bialu karu Ngode Datagaliwabehondo lamialu kegoni karulape bialu ke. ");
INSERT INTO hui_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Í̠na wali agalihondo Ngode Datagaliwabehanda bilimu nabilimu ledagobi lawai halu ti mana ogodagua bialu halimu lalubi ha ogodagua halimu lalubi lamuleneore ngadagua lamialu kegoni. ");
INSERT INTO hui_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Ani bialu kegonigo áyu ogoni bialu howa dege í̠ biamogo bilonaga agali maru wali agali haru holene mugube karu dabowa uruni tigua wali agali haru helo dabolene nga. Haru haga marume wali agali daosini (1,000) haruha marume handarini (100) haruha marume pira duriani (50) haruha marume pirani howa haru haga haga bigi bialu wali agali wabuni dewaore mo ta howa haru helo haru haga agali urunidagua dabo helolene nga. Agali Ngode Datagaliwabe hondowa giho hagaru mbirale ibugua bulebira lowa hanaho habeherubi ndelalu dange hana habe naherubi hondowa urunibime wali agali haru helo dabolene nga. ");
INSERT INTO hui_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Wali agalinaga godi larago hale halu dabagane agali uruni helolene nga. Ti biabe ogoniale biaga ka lene howa biaabo helo dabo helolene nga. Genda emene ale ngaru tigua lo tiga bigi bialu bi timbuni gendabi tigua hangu lai habe nahe ngaru í̠ keria yalu ibugu bulene nga. Anidagua mo tale birimiyagua í̠ genda yu kegoni maru tigua yamu yu kagola í̠ yabiabi holebere. ");
INSERT INTO hui_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Anigo áyu o langerogoni Ngode Datagaliwabehanda labe ledadagua langerolo manda bidogo o larogonidagua biriyagua í̠ kalukalu bialu ngoe̱ ngoe̱ lowa hongo pirilipe naholebira. Ani bialu wali agali o bu karu tibi nde tinaga genda abale mo tiga berami handala andaga polebira, lalu Yaderohanda lai hene. ");
INSERT INTO hui_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Mosesehanda manda bialu hearia Yaderohanda bi layagoni heneneore layada manda bialu lamiyadagua bule manda bini. ");
INSERT INTO hui_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Ani manda buwa ibugua Isaraele agali hearu bibahende bi libele lo handama pialu agali maru wali agali haru habehe mugubeyi hearu dabo helene. Agali uruni marume wali agali daosinini (1,000) handaya ho hela marume handarini (100) handaya ho hela marume pira duriani (50) handaya ho hela marume pirani handaya ho haga haga bigi bilo dabo helene. ");
INSERT INTO hui_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Ani biyagola agali uruni tigua wali agalime bi laga biyaru hale halu lo tabaga bialu mo tiga bigi bini. Bi tigua hangu lo tababe nahe gendabi ale wiaru Mosese hearia yu pugu bialu emene yabiabi ale tigua labehe wiaru tigua lo tabalu hene. Ti biabe ogoni bia li hole bialu hene. ");
INSERT INTO hui_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Yaderohanda Mosesehondo agua bia lalu lamiyadagua Mosese ibugua hale halu biyago handalu howa nde Yadero ibu ibuni dindi, Dai bero, layagola Mosesehanda, Nde pobe, lene. ");
INSERT INTO hui_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","2","Isaraele wali agali ti Lebidimi dindi wahalu pene. Iyibi dindi howa tagira ibuwa ege tebonegonaga horo mbira pigane ngabu layagola Sainai dindi ko wali agali nahaga wiagoria anda ibini. Anda ibuwa Hari Sainai heago teneha palu hole balai anda ya gimbu bu hene. ");
INSERT INTO hui_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Wali agali biaru ti ani bu hea handala Mosese ibu hari biagoha iraga halu Ngode Datagaliwabela heba bi lole pene. Ani pu hearia Anduane Homogohanda hari biagoha howa bi lamialu Yagabanaga aguanene Isaraele wali agali hearuhondo bi lamilonaga Mosese lamini. ");
INSERT INTO hui_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Mosesehondo Isaraele wali agali lamilo agua lene. Isaraele wali agali tí biamogo bule lowa Anduane Homogo i̱na Iyibi wali agalihondo birugo tí de handarimigoni. Ega bodo hariawe ale ibu igini ibuninaga babaganeni berelowa yalu yaga lagadagua i̱na tí i̱naga payani au yalu ibalu o kamigoriani yupeho heledogoni tí manda bidamigoni. ");
INSERT INTO hui_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Ani birugonigo áyu tígua i̱na bi larodaguaore hale halu bialu i̱na habo nalolene bi lo ngoruni napuguiore harimiyagua tí i̱ninaga wali agaliore holeberemi. Dindini mbirale bibahende ngarubi wali agali bibabende karubi i̱naga degego ai tíore i̱naga wali agali dabeneore holeberemi. ");
INSERT INTO hui_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","I̱naga hanguore hole lowa loma bini tí i̱naga loma binigo mo miagame biabe biradagua bia haga holeberemi laya, lalu lamibe, lene. ");
INSERT INTO hui_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Ani laya handala hale halu Mosese ibu hari biagoha howa dalipe halu puwa Isaraele wali agali haru haga hearu íbu ngoai hadaba lowa Anduane Homogohanda labe layaru bibahende o biaruhondo lamiai hene. ");
INSERT INTO hui_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Ani lamiyago wali agali bibahendeme hale howa tigua ladai bialu lalu, Anduane Homogohanda layadaru damene iname bibahendeore hale halu biai holeberema, lene. Tigua anidagua ladai biyagola wali agalime agua laya lalu Mosese ibugua Anduane Homogo lamini. ");
INSERT INTO hui_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Ani lamiyagola Anduane Homogohanda Mosesehondo lalu, Áyu howa i̱na beraliba timbuni mberane biagoha howa tí kamigoria ibuwa bi laga bulebero. I̱na í̠hondo bi laga berogo hale howa wali agalime í̠na bi laga berego hale halu ti yu tiga bulebira, lene. Isaraele wali agalirume agua laya lalu Mosese ibugua Anduane Homogohondo lamini. ");
INSERT INTO hui_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Ani lamiyagola Anduane Homogohanda Mosese lamialu lalu, Áyu wali agali kagoria puwa lamialu áyu yawila tíha kobi dodobi para karu domo wahalu halimu laya, labe. Wali agali tí ko dodo bagabi howa i̱ mitangi bialu mo dunini howa lotu lole i̱ kogoria ibabe nahe holebira laya, labe. Tinaga aga baya hangu wayawaya bialu ");
INSERT INTO hui_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","yawi howa luma i̱ mitangi bialu i̱hondo lotu lole halimu laya lamibe. I̱na horo ogoningi wali agali bibahende i̱ de handai helo Hari Sainaini dalipe holebero laya, lamibe. ");
INSERT INTO hui_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Ani lamialu wali agali ti hari ogo iraga holemeni hari ogoha ibu haparabi heba holamini laya, lamibe. Ani bialu hari ogo tene tene wali agali ti baba i̱ baba tigi dibu yu mabu bibe. Tigi dibanda kegoha i̱ kohayagi mbirali anda ibulani bibahende tagirayagi hadaba labe. Ani larogoni pugualu mbirali i̱ kogohayagi tigi dibanda kegoha ge yaanda hayagua dogahe ogoni bo tongolomiore lolene nga. ");
INSERT INTO hui_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","To̱le̱me bo tongolo milalimu. Danda timume bogarimiyaguabi karulapego timu heba bogopeho ngagola mbiralime elaore holamini. Nogo agali bogarimiyaguabi mana mbiraore ogoni hangugo timu heba wu ga̱e̱ lalu tongolo milo ela nahe ngelalimu laya, lalu lamibe. Ai mbelo pu larane hale harimiyagua wali agali bibahende hari ogo iraga iraga bialu ibai halimu, laya, lalu lamibe, lene. ");
INSERT INTO hui_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Anduane Homogohanda ani lamigi biya handala hale halu Mosese ibu hari biagoha howa dalipe halu ibuwa wali agali lamialu lalu, Ai Anduane Homogo mitangi bialu ibu mo dunini howa lotu lami̱yago manda manda bidaba, lene. Ani layagola wali agali tinaga aga bibahende bayuwa wayawaya biai hene. ");
INSERT INTO hui_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Ani bu heagola Mosesehanda tihondo lalu, Áyu yawibi bayuwa manda manda bialu howa luma lotu lami̱yago dombene nigoniha howa onene agalinila mandagi napale hangu haga haga bilimu, lene. ");
INSERT INTO hui_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Ai horo tebone biangi egerebagiore hayagola hari daba bialu hari kulu lalu beraliba mberane tohe timbunigo li hari biago neneni pu banga biyagola mbelo hongo howaore halu mbira tolade lene. Ani bigi biyago hondowa wali agali bibahendeme gi hai howa duru ala lalu hene. ");
INSERT INTO hui_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Ani bialu heagola Mosesehanda wali agali bibahende Ngode Datagaliwabe lola helo lowa haru tagira puwa hari biago teneha hope ho helene. ");
INSERT INTO hui_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Ani bu hearia Anduane Homogohanda hagua hungula ala bima bima tagira ibiyagola Hari Sainai emene mbira pana hole ndo ali haguame ndibulo wahene. Hagua timbuni anda dene hagua mbaulego pa̱u̱ lalu iraga iraga biyago hondowa wali agali biaru mogo lowa duru emene agima ndo gangawalu ibani lene. ");
INSERT INTO hui_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Ani bialu mbelo tolade layagobi lama iralu lo hongore hene. Mosese ibugua bi ibuni lalu Ngode Datagaliwabehondo layagola Ngode Datagaliwabehanda hari kulu lalu howa ladai bini. ");
INSERT INTO hui_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Ani bialu Anduane Homogo ibu Hari Sainai neneoreni dalipeho howa, Mosese í̠ hari neneore ogoriani iraga halu íbu, lene. Mosese ibu hari nene biagoriani pu heagola ");
INSERT INTO hui_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Anduane Homogohanda ibuhondo lalu, Í̠ áyu ogoni dalialu wali agali lamialu ti i̱ de hondole manda buwa ti baba i̱ baba tu wirimago bolangua halu i̱ kohayagi naibalimu. Tu wirimago bolangua halu ibirimiyagua ti dewali homa mburi loleberemi laya, lalu lamibe. ");
INSERT INTO hui_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Loma binigo mo miaga karubi heba i̱ kohayagi kaware íbu hapara haramiru tibi dodo bibahende bayuwa mbililo wahene howa ibalimu. Ani nabi dodo bagabigo iraga harimiyagua nde bibahende pani mulebero laya labe, lalu lamini. ");
INSERT INTO hui_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Ani layagola Mosesehanda Anduane Homogohondo lalu, Hari ogoni wali agali ge nahagago ti baba í̠ baba tu tigi dibuyu mabu bibe larigo manda buwa wali agali ti hari ogo iraga halu ibulene gi holebira, lene. ");
INSERT INTO hui_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Ani layagola Anduane Homogohanda Mosesehondo ladai bialu lalu, Í̠ áyu ogoni dalialu Arono damu pialu libu haru ibalibu. Ai wali agali bibahendebi loma binigo mo miagarubi ti bibahende baba ina tu wirimagoni ti tini kamiha hamilimu. Tu biago boladaga halu i̱ koha kaware ibirimiyagua dogahe ogoni pani mulebero laya labe, lalu lamini. ");
INSERT INTO hui_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Ani laya handala Mosese ibu dalialu puwa Anduane Homogohanda layadagua wali agali biaru lamini. ");
INSERT INTO hui_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Ngode Datagaliwabehanda ibuninaga bi lenego ogo. ");
INSERT INTO hui_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","I̱ Anduane Homogo tínaga Ngode Datagaliwabe i̱na tí Iyibi dindini garabaya biabe ale biaga hemiria haru tagira ibirugoni i̱ kogoni, lene. ");
INSERT INTO hui_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Tígua dama tara tarahondo bi pupu wiaga karu mitangi nabi i̱ hangu mitangi bialu mo dunini howa lotu lalu halimu, lene. ");
INSERT INTO hui_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Mbirale mbira hari daligaha winibi dindini winibi ibaha winibi humbirini andagaha winibi uruni mbiragoha winigo Ngode Datagaliwabe handaradagua bule lowa gime wa nabilimu, lene. ");
INSERT INTO hui_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Mbirale gime wabini mbira mo ngelowa ogonihondo tíni bulu palialu bi pupu nawilimu. Ani nawilimu larogo irane tínaga Anduane Homogo Ngode Datagaliwabe i̱ni kogola mbiralime ogonidagua bilo henge namiaga kogoni. I̱ handabe manga halu erembira ngiaga kago pani mialu ogoninaga waneigini mani hama porarubi daba tebone mane daba haragoriabi pani miaho dege ngoria hondolebira. ");
INSERT INTO hui_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Ai i̱ gubalini halu i̱na larodaguabi i̱naga mana lo wirugo ngodaguabi hale halu biaga karu i̱na ti gubalini halu maha ti waneigini dabane hama poraru gubalini haho wiaabo haga kogoni, lene. ");
INSERT INTO hui_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Mana ohowa tara tara bulenenaga i̱ mini lalu labi biabi nabilimu. I̱ tínaga Anduane Homogo Ngode Datagaliwabe kogo mbiralime i̱naga mini mo nagalone haga kago pani miaore bulebero, lene. ");
INSERT INTO hui_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Sabada horo i̱ninaga loma biaho ngeledogo i̱ mitangi bialu halimu. ");
INSERT INTO hui_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Tí horo waragaru tíninaga biabe bulene horo o ngarunigo ");
INSERT INTO hui_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","ai horo kanego i̱ mitangi bialu ha̱lo halimulonaga nga. Horo kane ogoningi biabe bulene nawiore. Tínibi tí waneiginirubi tínaga biabe biaga karubi dindi tarali maru tí heba mandagi kamirubi tínaga nogorubi tí bibahendeme biabeore mbira nabi halimu. ");
INSERT INTO hui_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Horo waragaruni i̱ Anduane Homogo i̱na dindi bibahendebi hari daligabi ibabi mbirale bibahende uruniha ngarubi karubi wabiai harugoni. Ai horo kanengi i̱ ha̱lo hene ko. Anduane Homogo i̱na ani bini kogome Sabada horo ogoni mo bayale halu loma bini ngeledo, lene. ");
INSERT INTO hui_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Tígua aba ai̱yala mo yo handa nabi laradagua hale halu bilimu. Anigo tí dindi i̱na ngerogoni lu haabo holeberemi. ");
INSERT INTO hui_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Wali agali homelo nabalimu. ");
INSERT INTO hui_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Wali agali kayu nayalimu. ");
INSERT INTO hui_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Mbirale page nabilimu. ");
INSERT INTO hui_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Ke̱ howa dibade nahalimu. ");
INSERT INTO hui_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Agali mende ibunaga anda kago hondowa tí hame nalalimu. Ibu one bedago hondowabi tí dimagoli nahalimu. Ibunaga biabe biaga wali agali karubi ibunaga nogo hinidarubi ibunaga nogo dongi karubi ibunaga mbirale maru ngaru bibahendebi tí hame lalu dimagoli nahalimu, lalu lai hene. ");
INSERT INTO hui_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Hari kulu layuagobi mbelo biguli layuagobi kirabalime tolade layuago wali agali tigua hale howa handalu hearia hari daba gibi biayuagobi Hari Sainai biagoha hagua pa̱u̱ lalu tagira ibiyagobi hondowa ti gi timbuniore hene. Gi timbuni howa ibida pugu pugu bialu duru lalu haga haga bini. ");
INSERT INTO hui_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Ani gi howa tigua Mosesehondo lalu, Í̠na inahondo bi lariyagua iname hale holeberamagoyu ai Ngode Datagaliwabehanda inahondo bi langiyagua ina áyu ogoni homolomada manda buwa giho kamagoni, lene. ");
INSERT INTO hui_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Tigua ani layagola Mosesehanda ladai bialu lalu, Tí gi nahalimu. Ngode Datagaliwabehanda áyu tí ba handalu ibugua laradagua hale halu bialu mana ko nabilimulonaga o bigi biyaruni de handalimulo ibunaga hongo walia haya, lene. ");
INSERT INTO hui_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Mosesehanda ani laya hondobi wali agali ti gi howa de pigipiagolo kaundia namu hayagoriani haho wiaabo hene. Ti ani biagola Mosese ibuni dege hari beraliba mberane arumahe wiagoha Ngode Datagaliwabe heagohayagi kaware pu hapara hene. ");
INSERT INTO hui_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Anduane Homogohanda Mosesehondo lalu, Isaraele wali agaliruhondo bi ogo lamibe lowa lalu, I̱ Dahuliya andagaha howa tí baba bi lalu harugoni manda bu kamigoni. ");
INSERT INTO hui_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Ani manda bu howa tígua bi pupu wulenaga mbirale mbira ngolo silibarumebi wabu ngelowa urunihondo bi pupu wulene nawiore. Tígua i̱ni hanguhondo mitangi bialu lotu lalu halimu. ");
INSERT INTO hui_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Tígua dindime lomabu delaga dabu wabu helowa ogoriani nogo bulumaga sibiru bo loma bialu irani dai helo delalu Anduane Homogoi̱nila ho gimbu bulenaga lomabi bo delalimu. Tígua i̱nihondo mitangi bialu lotu lalimulonaga i̱na dindi dabo ngelarugo bibahendeha i̱nime wali agali mo turu halu bayale helonaga íbu holebero. ");
INSERT INTO hui_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Tígua lomabu delaga dabu ege to̱le̱me bulene manda birimiyagua nde ege to̱le̱ agalime podo wini ngagome nabilimu. Ani larogoni irane ege to̱le̱ biabe biaga aeane ngagome podowa dabu birimiyagua nde ogonidagua binime i̱naga dabu bulene tiga nabi nga. ");
INSERT INTO hui_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Ani bialu lomabu delaga dabu daligaore egegeria bima iraga halu bo delole nabilimu. Tígua loma delolenaga iraga howa bo delalu karia wali agali dindiha bu karu we̱ lai holigo daligaore nabilimu laya, lalu lamibe, Anduane Homogohanda Mosesehondo lene. ");
INSERT INTO hui_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Anduane Homogohanda bi laabo halu lalu, Isaraele wali agalihondo bi mana ogo lamibe. ");
INSERT INTO hui_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Isaraele wali agali bu karu aria degeme tíninaga garabaya biabe ale biaga helo yolo mialu helarimiyagua mali waragariani hangu biabe bialu helalimu. Ani bialu mali kane haragola ti pelo golope halimu. Ti pole howa muni mbira ibu anduane kagohondo mia nabi pelo wahalimu. ");
INSERT INTO hui_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Ibugua tínaga garabaya biabe ale bule ibiyangi ibu wali dabu nabi heneyagua nde ibuni hangu polene nga. Abale ibu wali dabubi howa ibu one heba garabaya biabe ale bialu heneyagua nde ibu one heba pelo pudaba lolene nga. ");
INSERT INTO hui_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Anigo ai anduanedago ibugua ibunaga biabe biaga ogoni wali mbira miragola walime waneigini taba hanayagua nde waneiginirubi walibi anduane ibuninaga helo wahalu garabaya biabe ale biaga agali biago ibuni hangu polene nga. ");
INSERT INTO hui_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Ani buwa garabaya biabe ale biaga agali biago ibugua lalu, I̱naga agali anduane kagobi i̱ one waneiginirubi yu wahalu napole layagua ");
INSERT INTO hui_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","nde agali anduane kago ibugua ibunaga garabaya biabe ale biaga agali ogoni Anduane Homogo andagaha haru polene nga. Ani bialu garabaya biabe ale biaga ogoni anda panga harabani helowayaguabi anda haneni helowayaguabi anduane kago ibunime agali ogoninaga hale diri bolo wulene nga. Ani bolo ngagola agali biago ibu anduane biagonaga garabaya biabe ale bialu haabo halu homalu waholebira. ");
INSERT INTO hui_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Agali mbirame ibu wane garabaya biabe ale bilo lowa yolo biragola miyagua wandari ogoni ibugua garabaya biabe ale bialu mali karia howa agali garabaya biabe ale bialu hene golope halu pu laga ngadagua wandari biago golope halu pu nalolebira. ");
INSERT INTO hui_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Agali mbirame wandari ogoni yolo bialu howa mani ibuni dabu bulene manda bialu yolo buwa dege ibugua wandari biago dabu bule manga hayagua nde wandari aba ibunime ibu wane lone yolo biadai bulene nga. Agali anduane biagome mana bayale bulene ngadagua ndo biyago ai ibugua agali dindi taraha howa ibiragohondo yolo bidaba lalu muni tagulene nawi. ");
INSERT INTO hui_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Agali mbirame wandari mbira ibu iginime dabu bilo yolo biyagua nde agali ogoni ibugua ibuni waneore handayaho hagadagua handayaho holene nga. ");
INSERT INTO hui_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Agali wali biago anduane kago ibugua wali mende dabu biyagua wali ala dabu biyago baya hangu handayaho holene nga. Ibugua wali mende biago dabu nabi howa mana ala biaga wiyadagua wali ala dabu binigonaga tomo agabi mialu ala hagadagua holene nga. ");
INSERT INTO hui_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Agali biago ibugua ogonidagua nabiyagua nde wali ala dabu bini biagohondo ibunaga muni ngiadai bia nale wahalu ibuni andaga pu lolene nga, lalu Anduane Homogohanda lene. ");
INSERT INTO hui_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Anduane Homogohanda laabo halu lalu, Kirali gungu bialu karia mendealime mendealigo bo homelayagua nde baga biago ibuni homelo bo waholene nga. ");
INSERT INTO hui_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Anigo agali ogoni ibugua mendeali biago baro lalu ndo bame gungu bialu kabiria mememe bo homayagua nde bagago ibuni tano maru agali mememe bene ogoni ale ibida pialu ha do helo dabo ngeloleberogoha howa hada payabu hole polene nga. ");
INSERT INTO hui_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Anigo agali kirali gungu bialu kabira mendego keba howa homelo henemane bo wahayagua nde baga biago ibunibi nde bo waholene nga. Agali biagome mendealigo bo wahalu ibugua nahomole lowa i̱naga lomabu delolene dabu wabu wiagoha ibida piyagua ibu minalu haru pubagi howa ibuni homelo bo waholene dege nga. ");
INSERT INTO hui_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Mbiralime ibu aba ai̱yabi bayagua ibuni nde homelo bo waholene nga. ");
INSERT INTO hui_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Mbiralime wali agali mende kago minu page buwa yolo ngilo lowa mendealihondo minu miyaguabi ibuninaga garabaya biabe ale bialu helo minu helayaguabi ogonidagua biaga kago ibuni nde homelo bo waholene nga. ");
INSERT INTO hui_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Mbirali ibu aba ai̱yalahondo keba howa ha halu Anduane Homogohanda pani milo layagua ibuni homelo bo waholene nga. ");
INSERT INTO hui_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","Kirali gungu bialu mendego kangomebi gimebi ege to̱le̱mebi benego homa nabiyagua baga hayago ibuni pani mulene nawi. Benedago ibu ibuni andagaha dagiani wuwa ");
INSERT INTO hui_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","mani lone heyalu halimbu yalu tagira poragola agali baga biago ibunime bene warago wiyagonaga muni mbira mulene nga. Muni biabe bulene winigo bayagome ibuni yolo biabe bibe nahedagola buru paluebira manda bialu dabi helo ngatagi yolo miagadagua mialu holene nga. ");
INSERT INTO hui_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Garabaya biabe ale biaganaga anduane mbirame ibunaga garabaya biabe ale biaga wali agaliyaguabi mbirago kangome baragola ogoningiore abale tongolo miyagua nde anduane ogoni ibuni pani nelo milimu. ");
INSERT INTO hui_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Anigo mbirali biabe bia haga bayagua abale barangiore homa ndo horo kiru tebirubi wuwa homayagua nde ogoni anduanedago ibuninaga munime yolo bialu ibunime hameleda ale bulenaga ani yolo bu helenego ai mani ibuni hame handa walia holebira. Hame handa walia holebiragome pani ogoni karulapego tigua pani lone namilimu. ");
INSERT INTO hui_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Kirali gungu bialu karia wali nuyi mbira bedagoha gungu buya howa wali ogoni hengedaragola gali tombeha bedago mo ko haragola yu wahalu wali ibuni mo ko nahe bayale bereagua nde wali hengedene biago agalini kagome hengedayagohondo yolo bia laradagua bulene nga. Anigo tinaga mana dabaki haga karume karulape ogodagua mibeheda laradagua wali agalini biago ibu mo yulene nga. ");
INSERT INTO hui_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Ai wali biago hengedayagome mo ko hayagua nde hengedayago ibuni pani ogodagua mulene nga. Wali biago homayagua nde agali hengedayago ibunibi homelo bo waholene nga. ");
INSERT INTO hui_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Ani bialu de bo hundia hayagua nde ibuninaga debi bo hundia halu ne bo hondayagua ibuninaga ne bo hondalu gi bo podayagua nde ibuninaga gi bo podalu ge bo podayagua nde ibuninaga ge bo podalu bulene nga. ");
INSERT INTO hui_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","Ani bialu wali irame heda hayaguabi tingini maruha mo ko haragola tingini dere timbuni biyaguabi gewame bo baulo wahayaguabi uruni biyadagua agali ogoni ibunihondo biadai biai holene nga. ");
INSERT INTO hui_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Agali mbirame wali agali ibunaga garabaya biabe ale biaga karu aria mbiragonaga de bo hundia halu mo ko hayagua nde anidagua biyagome ibu garabaya biabe ale biyagonaga yolo biadai biradagua ibu bame golope halu andaga pu lolene nga. ");
INSERT INTO hui_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Wali agali garabaya biabe ale bialu haga karu aria mbirago anduane kagome baragola ibunaga ne bo hondayagua nde ibunaga anduane kagome ne bo hondayagonaga yolo biradagua ibu bame golope halu ibuni andaga pu lolene nga, lalu Anduane Homogohanda Mosesehondo, Isaraele wali agaliruhondo lamibe, lalu lene. ");
INSERT INTO hui_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Anduane Homogohanda laabo halu ogodagua laya. Bulumaga mbirame ibunaga haguaneni ne gayane kagome wali agali balu homelayagua nde tigua bulumaga ogoni homelo bo waholene nga. Ani bialu nogo bulumaga ogoni nanalimu. Bulumaga aba kagohondo abi bia lalubi nalalimu. ");
INSERT INTO hui_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Ai nogo bulumaga ogonime ala keba haabo halu wali agali bama ibaga biaabo haga kago hondowa wali agalime bulumaga anduane kagohondo bi hongo howa lamiaabo haragola ibugua bi hale nahe tingi halu ibunaga bulumaga pabeha hela nabiyaguabi nde ogodagua bilimu. Nogo bulumaga biagome waliyaguabi agaliyaguabi bo wahayagua nde ibunibi nogo aba kagobi kirabali homelo ege to̱le̱me bo wahalimu. ");
INSERT INTO hui_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Bulumaga aba biagome ibuni nahomolenaga muni yolo mule manda biyagua nde muni yolo ogodagua bulene nga larago laradaguaore yolo biyagua nde karulape ogoni. Ani biragome ibu homa nabi helolebira. ");
INSERT INTO hui_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Bulumagame wandari igiribi mbira bayaguabi nde mana mbiraore ogonidagua dege bulene nga. ");
INSERT INTO hui_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Bulumaga mbirame wali agali garabaya biabe ale biaga karu aria mbirago balu homelayagua nde bulumaga aba kagome wali agali homayagonaga anduane kagohondo muni kina handari tebira ale (300) mialu nogo bulumaga biago ibuni homelo wali agali tigua ege to̱le̱me bo waholene nga. ");
INSERT INTO hui_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Agali mbirame gundu uli bu yi hene ngago mo wabia howa duguaho ngelayaguabi gundu uli gahenge timbuni tombowa bu yi nahe ngagoha nogo bulumaga dongiru mbira pilalu ");
INSERT INTO hui_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","homayagua nde agali o biagome nogo homayago anduane kago yolo bialu nogo homene biago ibuni dawa nolene nga. ");
INSERT INTO hui_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Ai mbiralinaga bulumaga hinidago mendealinaga bulumaga kagome balu homelayagua nde nogo hayaga kago anduanebi homene ngago anduane kagobi libu haru nogo hayaga kago muni taguialu muni libuni talebu ki halu nogo homene ngagobi libuni bo daga bulene nga. ");
INSERT INTO hui_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Ai nogo bulumaga hayaga biagome ogonidagua biaabo haganego manda buwa anduane kagome bulumaga ogoni pabeha hela nabiyagua nde bulumaga homene anduane kago nogo mbira hada aribia halu nogo homene ngago ibuni dawa nolene nga, lalu Anduane Homogohanda lene. ");
INSERT INTO hui_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Agali mbiralime mendealinaga bulumaga mbirayaguabi nogo sibi mbirayaguabi page bialu bayagua haru halu puwa muni miyaguabi nde nogo anduane kago hado aribia holene nga. Bulumaga mbiranaga bulumaga duria hado aribia holene nga. Nogo sibi mbiranaga sibi maria hado aribia holene nga. ");
INSERT INTO hui_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","4","Mbirale page biragonaga miadai bulene nga. Pageali kago ibugua miadai bulene mbira nawi heayagua nde ibuni nogo mbirale page biyadago anduane kagonaga garabaya biabe ale biaga holene nga. Ai nogo bulumaga dongi sibiyaguabi mbira page binidagoni balu nane ibu daluha heagua nde pageali kago ibugua nogo kira miadai bulene nga. Mbiraga pagealime mbiralinaga anda gialalu anda pialu karia anda anduaneme hondowa pageali ogoni homelo bo tongolo milayagua nde anda anduane biago ibuha ko nawi. Anigo horombe bayagua anda anduane biago ibuhabi nde bia ko hene dege wulebira. ");
INSERT INTO hui_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Mbiralime ibunaga nogo bulumagaru yupe howa ibuni daluhayagibi ibunaga pu mbira mini gerebi lini dagane mabuhabi nalu heledagola bulumaga biarume agali mende daluhabi mendealinaga gerebi mabuhabi anda puwa nayagua nde nogo anduane kagome gerebi linibi tomo bayaleore ibuni mabu tawe bialu mabu anduane kago yolo bulene nga. ");
INSERT INTO hui_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Mbiralime ibuni dalu dangi teha bo delalu karia datimbu howa mendeali dalu ngagohayagi dama pialu tomo hengedarubi widi lini gandulo ngarubi dalu biyagua nde bo delaga kago ibugua tomo dayadago damene bibahende bu aribia holene nga. ");
INSERT INTO hui_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Agali mbirame ibunaga muni dabudaburu agali mende ibu nenege kagome ngelo handayaho habe lalu mialu pedagola pagealime mo pagebu yalu pialu karia handa walia hayagua pageali ogoni ibugua mbirale mo page binigo aleore kira kira mo aribia holene nga. ");
INSERT INTO hui_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Anigo pageali biago handa walia nahayagua nde agali mbirale uruni handayaho hagadago ibuni wali agali ngoai howa lotu laga ngagoria haru pu helolene nga. Ani haru pu heledemigola agali mbirale handayaho haga kago ibu i̱ninaga deni howa ibugua lalu, Heneneore larogo i̱na mbirale uruni mo page nabiore, lalu latagi holene nga. ");
INSERT INTO hui_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Anidagua dege mbiralime nogo bulumagayaguabi dongiyaguabi sibiyaguabi agabi yári tara tarabi mbirago ibunaga nenege mende kagola í̠naga i̱naga lowa garere bialu hebiyagua nde kirabali i̱naga deni wali agali ngoai howa lotu laga ngagoria haru polene nga. Ogoriani howa daba handalu kamiria mendealime ke̱ howa laya lalu i̱na dababagi harogo ibugua mende henene laga kago mbira mbira uruninaga haluki dege dege miadai bulene nga. ");
INSERT INTO hui_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","Mbiralime nogo bulumagayaguabi dongiyaguabi sibiyaguabi mbirago ibu nenege mbira kagome hinu habe lalu pedaria nogo uruni mbirago homayaguabi mo ko hayaguabi wai tigirume wai anda ibuwa haru halu piyaguabi mbiralime handa nabiyagua ");
INSERT INTO hui_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","nde libu haru i̱ninaga deni wali agali mo ngoai howa lotu laga ngagoria puwa Anduane Homogo i̱ninaga minini howa bi heneneorego latagi holene ngago ogo. Heneneore larogo í̠naga nogo ogoni i̱na bo pagebi hado pagebi nabiore kogoni, lolene nga. Anidagua laragola nogo aba hayadago ibugua mememe ereba hayadago hado aribia nahe wahabe lolene nga. ");
INSERT INTO hui_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Anigo mbiralime hado page biniyagua nde nogo hinu hayadagome nogo anduanedago nogo hado aribia holene nga. ");
INSERT INTO hui_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Nogo ogoni nogo gabuame balu nayagua nde naya lalu anduane kago ibuni mo walia hole nalu ibira henedago mo yalu anduane karia polene nga. Ani bialu nogo gabuame nogo bo nayadagonaga miadai bulene nawi. ");
INSERT INTO hui_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Agali mbirame ibu agali nenege kagonaga nogo bulumagame biabe bulenaga haru pialu karia mo koha homa biyagua nogo anduane ibuni nahende heagua nde agali o biagome ibu nogo anduane kagohondo yolo mulene nga. ");
INSERT INTO hui_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Anigo ai bulumaga anduane libu haru mandagi kabiria homayagua nde mememe biyada lalu waholene nga. Ai nogome biabe bilo haru polenaga nogo aba biago muni marume yolo bialu haru peneyagua nde mo koha homa bidagola yolo miadai bulene nawi. Yolo ala biyadagoni karulape, lene. ");
INSERT INTO hui_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Anduane Homogohanda laabo halu lalu, Agali mbirame wandari mbira ibu agalila nahene biruwa mbirame dabu bule lo berelenebi ndo mbira bedago kayu biyagua nde agali ogoni ibugua wandari aba ala yolo bialu wariabu hende holene nga. Ani bialu ibu dabu bulene nga. ");
INSERT INTO hui_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Anigo wandari aba biagome ibu wane agali ogonime dabu nabule layaguabi nde karulape. Ani layagua agali ogoni ibugua wandari hibaria berene yolo biagadagua wandari aba biago nogo tawa bo mulene nga. ");
INSERT INTO hui_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Wali mbirame wali agali maru tomia biyagua ogoni ibu homelo bo waholene nga. ");
INSERT INTO hui_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Wali agalime nogo biango karu baba kayu biaga heagua ogonidagua biaga kago homelo bo waholene nga, lene. ");
INSERT INTO hui_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Wali agalime mbirale loma bialu Anduane Homogo i̱hondo hangu ngulene nga. Anidagua nabi howa mbirale dama mitangi bialu gime wabini ngaruhondo lomabu miaga mbira heagua ogoni ibu homelo bo wahalimu. ");
INSERT INTO hui_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Wali agali dindi tara tara ngaruha howa íbu hene karuhondo mo ko halubi genda mo mialubi mbira nabiore halimu. Ani larogoni irane tínibi nde bamba Iyibi dindiha anidagua dege harimigo mitangi bialu halimu. ");
INSERT INTO hui_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Wali dalo ti agalini homene bedarubi waneigini ti aba ai̱yala homene bu karubi uruni mo ko nahalimu. ");
INSERT INTO hui_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Tígua uruni mo ko harimiyagua nde tigua biamogo bia lalu i̱hondo bi laragola Anduane Homogo i̱na tinaga bi larago hale halu biamogo bulebero. ");
INSERT INTO hui_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Ani bialu tíhondo keba timbuni howa tínaga waitigi bu karume tí baba wai bialu tí mo ko howa bo hilo wahelo ibilolebero. Anidagua berogola tí one bedaru agalini nahe dalo biralu tínaga waneigini bu karu aba nahe hono wahene halu bulebira. ");
INSERT INTO hui_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","I̱naga wali agali bu karu aria mbiraligo ibu muni nawi yagibano howa agali ogonibi kagome tínaga muni mo dano hayagua nde tí biyinaya biagame muni bolangua howa bo yudai bule lowa mendealiha wia hagadagua nabilimu. Tínaga dano harimigo tiga tiga ngiadai birangi bolangua howa ngi lolene nawiorego nalalimu. ");
INSERT INTO hui_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Mbiralime tínaga dano harimigo hongoleore lalu manane ibunaga dagare bulilono biaga aga tohe ngago tíhondo ngiyagua nde horo ogoningi dege mbiraga ni palia nabidaore abale yu daibu milimu. ");
INSERT INTO hui_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Ani larogoni irane mbiraga dagare biragola tongobu paluene aga mende nawi howa mbiraore ogoni hangu wuwa dagare holebiragonaga laro. Ibunaga aga tohe dagarenaga biaga ogoni tí mo yu haabo harimiyagua nde ibuni mbiraga dagare biragola aga agome tongobu paluebadabe. Anidagua beramigola yagibano uruni tigua i̱hondo bi laragola i̱na wali agali tanabi dara hai haga kogome tinaga bi larago hale halu biamogo bulebero. ");
INSERT INTO hui_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Ngode Datagaliwabe i̱niore kogohondo bi ko nalalimu. Ani bialu tínaga agali haguane kago ha halu ibu karia mo ko holene wilo lalu nalalimu. ");
INSERT INTO hui_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Tínaga mabuha widi linirubi gerebi lini ibanerubi olibe lini ibanerubi pigane boga birago i̱nihondo lomabu ngulene manga nahalimu. Tí igini wahene taba hanaragobi i̱nihondo lomabu ngilimu. ");
INSERT INTO hui_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Ani bialu tínaga nogo bulumaga sibirume igini pigane wiragola horo karu angibuni baba helo wahowa horo halini haragola i̱nihondo bo lomabu ngilimu. ");
INSERT INTO hui_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","Tíore i̱ninaga wali agali kamigo manda bialu nogo tara tara bu karu aria mbira gabua karume bo wahene irabuha wiagua ogoni nolene nawiorego manda bialu nanalimu. Wahalu biango karume nelo mo milimu, lalu Anduane Homogohanda lene. ");
INSERT INTO hui_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Anduane Homogonaga bi mana Mosesehanda latagi halu lalu, Tígua hale halu kamiria ogoale mbira biyada lowa diburibu mbira lalu kane hale howa henene ndoyagua bi te ogoninaga latimbu nahalimu. Mbiralime mana pugualu nabulene nga lowini mbira biyane deme handarimiyagua nde godi deni ke̱ howa biamogo bialu la nahe tigatiga latagi halimu. ");
INSERT INTO hui_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Agali dewalime mana ko ngago bialu hai heagua nde ko biaga uruni talialu mana ko biradagua tígua nabilimu. Agali dewalime godi deni howa godi larago la ko helonaga bi mo lingilungu biyagua mana ogoni biradagua nabilimu. ");
INSERT INTO hui_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Mbiralime agali ko yagibano kago godini haru íbu helayagua nde ko ogoninaga bi lahalu mo wulenaga godi ke̱ howa bi nalalimu. ");
INSERT INTO hui_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Tínaga waitigi kagonaga nogo dongi bulumagayaguabi mbirago pora bialu tí daluha íbu heagua nde nogo anduane ibu karia haru dai bilimu. ");
INSERT INTO hui_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Ani bialu waitigi kagonaga nogo dongi mbiragonaga erekunini dabudabu yu kaore harigani pilo wiagua nde tínaga waitigi hayadago biamogo bialu nogo pilo ngago mo heya halimu. Ibu harigani pilo ngelalu napilimu. ");
INSERT INTO hui_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Agali yagibano mbira godi lole lowa lalu karia tígua bime bope halu mo hondo howa mo luluya nahalimu. ");
INSERT INTO hui_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Agali mende kago baba ke̱ howa no̱a taini godi nalalimu. Agali ko nabi mbira kago bameore godi deni íbu helarimiyagua ibu helowa homelo bo wa nahalimu. Mana ko ogonidagua birago ibu i̱na dabaki harogola ke̱ howa godi laga kago ibu ke̱ hayagonaga pani nolebira. ");
INSERT INTO hui_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Mbiralime ke̱ godi lolenaga ke̱ halu bi lahabe lowa muni ngiyagua muni ogoni mo yulene nawi. Mana ko ogonibi biragome agali ko mbira nabi kago bi degeme mo luluya halu godi lolene ngago ndo la ko helaga ka. ");
INSERT INTO hui_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Wali agali dindi tara taraha howa tí daluha íbu hene maru heagua nde urunihondo mana ko nabi bayuwa helo halimu. Anidagua bulene ngago irane tínibi nde Iyibi dindiha hemiria Iyibialime tíhondo biyago mitangi bialu ani nabilimu. ");
INSERT INTO hui_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Tínaga mabu ngamiruha mali waragaruni tomo hangarimigo bialu tíni nolenaga ngelaga bilimu. ");
INSERT INTO hui_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Anigo mali kane haragola dindi ibu emene ngelo wahowa mabuha tomo minana andaho karu nabilimu. Mabuha hangabi nabule dege. Dindi ibu emene bame ngelo wahalimu. Pu mbira lini daga mini gerebi mabu ngamiruhabi olibe mabu ngamiruhabi ani dege bilimu. Anidagua bidamigola wali agali yagibano karu ti tomo uruni bu nalu helo. Ti bu nalu howa ibira harago nogo ega biru karu ti nalu helo yupe halimu. ");
INSERT INTO hui_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Sarere bibahendeangi horo waragaru biabe bialu halimu. Anigo horo kaneni biabe damenego bibahende nabi ha̱lo hai halimu. Tínaga wali agali biabe bia haga bu karubi hongo mialu horo ogoningi ha̱lo helo. Wali agali dindi taraha howa íbu hene karubi bibahende ha̱lo haga bilo helalimu. Horo ogoningi tínaga nogo dongi bulumagarubi biabe nabi dege ha̱lo helo helalimu. ");
INSERT INTO hui_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Anduane Homogo i̱nime bi o larogo baya hangu hale howa taluwa bialu halimu. Mbirale dama mitangi bialu bi pupu wule gime wabini ngaruhondo bi pupu nawi halimu. Mbirale uruninaga minibi naloleore lalu hongo howa larogoni, lalu Anduane Homogohanda Moseseha howa latagi hene. ");
INSERT INTO hui_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Anduane Homogohanda lalu, Mali mbira mbiranaga andaneha horo timbuniore i̱hondo mitangi bialu lotu lolenaga halu tebira daba bagiho ngelalimu. ");
INSERT INTO hui_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Horo timbuni mbirago Mberedi Yidi Nahe Hirini Nolenengi tíni mo mogobu howa i̱nihondo mitangi bialu lotu lalu holene nga. Ege Abibi haragola i̱na bilimu lalu langirudagua tí mo mogobu howa horo karu mberedi yidi nahe hiru nalu halimu. Bi ani larogoni irane ege ogoningiore i̱nime tí Iyibi dindiha howa haru tagira ibirugoni. Tígua i̱ mitangi bialu lotu lole eberemingi mbirale i̱hondo ngulenaga lomabu wirimigo mo yalu ibugu bilimu. ");
INSERT INTO hui_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Horo timbuni mendego tínaga mabuha tomo hengedemigo liniru pigane daramiangi horo uruni mini Mabuha Widi Lini Bogabi Gandulo Winigonaga Horo lalu uruningi i̱ mitangi bialu lotu lalu holene nga. Horo timbuni tebonego Anda Nemandaha Palu Holenengi tínaga mabuha ira lini dedaru boga birangi tagira ibulebira. Horo uruni tagira ibirangi tínaga ira olibe lini dedarubi gerebi lini dedarubi dalu kamingi anda nemandaha ho halimu. ");
INSERT INTO hui_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","I̱ Anduane Homogo tínaga Ngode Datagaliwabe kogo i̱na mali mbira mbirago andaneha horo timbuniore halu tebira uruni i̱hondo mitangi bialu lotu lalu halimulo daba bagiho ngelarogo uruningi Isaraele agali bibahendeore i̱ mitangi bialu lotu lole íbu ngoai ho halimu. ");
INSERT INTO hui_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Tígua i̱hondo nogo mbira bo lomabu ngialu howa mberedi yidihe hirini nangilimu. Mbirale bo lomabu delaramigonaga abene habaneru horo mendengi nangelalimu. Ogoningiore delai halimu. ");
INSERT INTO hui_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Tínaga tomo hengedemiru ariame lini pigane bogabi bayaleore daramirunaga maru Anduane Homogo tínaga Ngode Datagaliwabe i̱nihondo lomabu ngule i̱naga anda yalu ibalimu. Tígua nogo meme igini sibi iginiyaguabi mbirago ibu angibuni andu ibane beha hambu yu delaramigoha delamaga nahalimu, lene. ");
INSERT INTO hui_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Anduane Homogohanda laabo halu lalu, Bi o larogo hale halimu. Tí poleberemigoha i̱naga dahuliyali tí mamage helonaga ala mo bamba halu pelolebero. Ani bialu tí dindi mbira i̱na ngulenaga manda mandabu ngeledo larugoha haru polebira. ");
INSERT INTO hui_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Tígua ibunaga bi larago hale howa talialu bilimu. I̱nimeore ibu tí heba helo ibilarugo ai i̱nibi ibu heba mandagi kogo wali agalime ibunaga bi mo wahalu mana ko birago hondowa ibugua ko ogoni wa naholebira. ");
INSERT INTO hui_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Anigo tígua ibunaga bi hale halu i̱na bilimu ledodagua biai halu harimiyagua nde i̱na tínaga waitigi bu karu baba wai bialu bope holebero. ");
INSERT INTO hui_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","I̱naga dahuliyali kago ibugua tí haru halu Amoro dindibi Hidi dindibi Perese dindibi Kenana dindibi Hibi dindibi Yabusu dindibi dindi uruniha pialu biragola i̱na wali agali uruniha karu bibahende bo amo lolebero. ");
INSERT INTO hui_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Tígua dindi uruniha puwa mbirale dama mitangi bialu gime wabini ngaruhondo ge duli hanga howa bi pupu nawilimu larogoni. Tígua bi pupu wialu howa biagane mana ngarubi nabuleore larogoni. Tí puwa tinaga bi pupu wiaga anda bu heledaru bo gialo wahai halu mbirale bi pupu wulenaga wabu ngeledaru bibahende dambu gingirulobaga bu wahai halimu. ");
INSERT INTO hui_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","I̱ Anduane Homogo tínaga Ngode Datagaliwabe kogo nde tígua i̱ mitangi bialu i̱hondo hangu lotu lalu halimu. Anidagua bialu harimiyagua nde i̱na tí mo bayale halu tomo ibabi nalu halimulo ngialu tínaga warago tara tara ngaru mo wahai holebero. ");
INSERT INTO hui_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Tí dindiha wali tí one bedarume waneigini nataba hene berelo mbira i̱na mo wa naholebero. Bibahendeme waneigini gali taba hanaiore holebira. Tínibi nde dindini luore howa hodagua halu homoleberemi. ");
INSERT INTO hui_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","I̱nime tí poleberemigoha pu bamba halu puwa wali agali tara tara bu karu i̱hondo gi helo mo gi holebero. Tínaga waitigi bu karu tibi tíhondo gi helo mo gihaga bialu mo luluya ho helolebero. Ani berogola tí handalu ibida piai helolebero. ");
INSERT INTO hui_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Dindi tí poleberemigoha wali agali hayaga aleru bamba halu pelolebero. Anidagua pelarogola wali agali hayaga ale urunime Hibialibi Kenanalibi Hidialibi bibahende wara pelai holebero. ");
INSERT INTO hui_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Anigo wali agali uruni mali mbira hanguni waratagi hai naholebero. Ani waratagi hai haruyagua nde nogo gabuabi ega tara tarabi dewa bedarume dindi ti karulai halu tí mo ko holobadago ");
INSERT INTO hui_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","i̱na ti hendore waratagi haga bulebero. Ani buwa tí ho dewa halu dindi emene karula dindi aba emene bo taliatagi ha bigi bialu dindi tí karulo halimulo mo ngiai holebero. ");
INSERT INTO hui_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Tí halimulonaga dindi tubari iba solowara mini Iba Daramabi laga bedago angeha Agaba dindi ngagoria howa pialu iba solowara timbuni Meditereniana bedagoria tagira polebira. Ani bialu tubari uyurayaginaga iba timbuni mini Yuberedisi poragoria howa daliape halu dindi abene unurayagi dindi ko wali agali nahaga ege kelekele ngagoria tagira polebira. Dindi uruniha agali dindi aba bu karu baba wai bilimulo hongo karulapeore ngerogola tígua dindi ogoniha anda puwa wali agali uruniha karu bo taliatagi hai holeberemi. ");
INSERT INTO hui_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Ani anda puwa tígua wali agali dindi ogoniha hene karu bababi tinaga bi pupu wiaga gime wabini ngaru bababi habo nalolene bi mbira buleore lalu lo wia nabilimu. ");
INSERT INTO hui_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Ani bialu wali agali ogoniha hene karu tínaga dindi ogoriani helo nahelalimu. Helarimiyagua wali agali urunime tí mo hondo harago nahende henene larabe toba howa tígua i̱nihondo ko buligonaga laro. Tígua tinaga bi pupu wulenaga gime wabini ngaruhondo bi pupu wialu harimiyagua tí mo ko halu piloleberemi, lalu Anduane Homogohanda Moseseha howa bi ogoni latagi hene. ");
INSERT INTO hui_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Ani biyagola Anduane Homogohanda Mosesehondo lalu, Mosese-o hari ogoni iraga halu i̱ kogoria íbu. Í̠ ibalu Aronobi Nadababi Abihubi tígua Isaraele wali agali haru haga agali pira karia (70) biarubi tí haru ma lalu ibalimu. Ani bule ai áyu ibalu howa tí o kaundia kamigoriani howa bulu paluwa i̱ mitangi bialu mo dunini howa lotu lalimu. ");
INSERT INTO hui_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Maru o mini laruruni mbira i̱ kogoria hapara hole ndogo homane í̠ hanguore i̱ kogoria kaware ibabe. Ai wali agali bibahende hari ogoha mbira ge haraga halu ibulani handabe, lene. ");
INSERT INTO hui_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Ani laya handala Mosesehanda wali agali hearia puwa Anduane Homogohanda bilimu lalu bi layagobi ogo nabilimu lalu mana lamiyagobi bibahende Isaraele wali agali lamiai hene. Ani lamiyago hale howa wali agali bibahendeme ladai bialu lalu, Iname Anduane Homogohanda layadadagua bibahendeore hale halu biai holeberama, lai hene. ");
INSERT INTO hui_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Anduane Homogohanda bilimu lalu bi layago Mosese ibugua bibahendeore gilibu wiai hene. Ani bialu horo mendengi egerebagiore ibugua lomabu delagane dabu mbira hari biago teneha bu helene. Ani buwa ibugua to̱le̱ homberia (12) Isaraele hameigini homberia (12) hayago ta howa ibugua hongo mabu bini. ");
INSERT INTO hui_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Ani buwa ibugua igiri daliahe hearume nogo bulumagaru Anduane Homogola ho gimbu bulenaga bo delo mule pudaba, lene. ");
INSERT INTO hui_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Ani bialu Mosese ibugua nogo biaru darama hanuni yabu lowa halu mende ibu beha hambu ngelowa halu mendego dabu biagoha odo bade hene. ");
INSERT INTO hui_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Ani buwa ibugua habo nalolene bi lowini mbuga Anduane Homogohanda bi lenego gilibu wini biago muwa bi dalimu lowa wali agali hale hai helo dagalope hene. Dagalope hai heagola hale howa wali agalime Mosesehondo lalu, Iname Anduane Homogohanda bi olayadagoni damenego bibahendeore hale halu biai holeberama, lai hene. ");
INSERT INTO hui_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Ani layagola Mosesehanda nogo darama beha hambu wiyago muwa wali agali bu hearuni tandala ba hene. Tandala ba halu howa lalu, Anduane Homogohanda tí baba ibu baba i̱e̱ lalu habo nalolene bi lowinigo lo yu tiga birimigonaga mo hongo hagane darama ogoni, lene. ");
INSERT INTO hui_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Ani lalu bialu Mosesebi Aronobi Nadababi Abihubi tigua Isaraele wali agali haru haga agali pira karia (70) biaru ti hari biagoha iraga halu pene. ");
INSERT INTO hui_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Ani puwa tigua Isaraele wali agalinaga Ngode Datagaliwabe biago hearia de hendene. Ngode Datagaliwabe ibunaga ge habe yaraga howa nira buguni hari damindinigobi ku tagalitaya ale domodomobi wuyu pearia hendene. ");
INSERT INTO hui_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Isaraelenaga agali haguane uruni ti Ngode Datagaliwabe de handayagonaga ibugua ti mbira mo ko nahene. Ti ibu de hondowa agali biaru tini mandagi biruwa tomobi ibabi mandagi nene. ");
INSERT INTO hui_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Ani buwa Anduane Homogohanda Mosesehondo lalu, Hari ogoni iraga halu i̱ kogoria ibabe. Í̠ ogoria íbu kegola i̱na ege to̱le̱ mbalape kirani i̱naga mana lo wirugo Isaraele wali agalime bilonaga gilibu ngogo ogoni nguliya, lene. ");
INSERT INTO hui_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Ani layagola Mosesebi ibunaga biamogo biaga Yosuabi libu harume Mosese ibu hari loma bini biagoha iraga halu pelonaga manda manda bini. Manda manda biai howa Mosese ibu hari biagoha iraga halu pialu hene. ");
INSERT INTO hui_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Pialu howa Mosese ibugua Isaraele wali agali haru haga biaruhondo lalu, Iyame pialu dai bulubago tígua anda birimaru o karunigo uruniha palu halimu. Arono Huala libu tí heba o haramigonigo bi lo tabolene mbira wigi birangi ogolabo karia pugu bilimu, lene. ");
INSERT INTO hui_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Ani lalu bialu Mosese ibu Hari Sainai iraga halu pialu hearia beralibame hari biago dambi ho hene. ");
INSERT INTO hui_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","17","Anduane Homogo ibuni íbu howa ibunaga wá holene de mborerebi hiriribigo hari biagoria hope hene. Wá hope hayadagoni Isaraele wali agali tigua handalu hearia hari biago neneni ira daradagua biyaria hendene. Ani bialu horo waragaru hari beraliba biagome hari biago dambi ho wiaabo hene. Ani buwa horo kanegoria Anduane Homogohanda beraliba biagoha howa Mosese olene. ");
INSERT INTO hui_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Ani olayagola Mosese ibu hari biagoha iraga halu piaho wialu beraliba biagoha anda pene. Anda puwa o biagoniha horo mbi heba pira maria (40) ho haabo hene. ");
INSERT INTO hui_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Anduane Homogohanda Mosesehondo lamialu lalu, ");
INSERT INTO hui_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","Isaraele wali agali bu karuhondo lamialu, Tígua mbirale i̱hondo loma bialu ngulene manda bu kamiru tanabi loma bialu ngilimu, labe. Tigua ngiraru ale bibahende mo ya dege bibe. ");
INSERT INTO hui_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Lomabu ngiraru ngolobi silibabi boronosibi uruni lomabu ngulene nga. ");
INSERT INTO hui_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","Ani bialu nogo sibi irinime pu wabini mindibi hari mindini handalehebi tagalitayabi mo daramabi hene ngarubi aga baya taraore ngarubi nogo meme irinime wabini labolabo baya taraore ngarubi uruni lomabu ngulene nga. ");
INSERT INTO hui_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","Ani bialu nogo sibi wangabenaga dongone mo daramabi hene ngarubi wena timbuni iba tia alenaga dongone bayale ngarubi ira bayale mini agasia laga kagonaga gabini bayale ngarubi loma bulene nga. ");
INSERT INTO hui_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","Ani bialu lamu hale delolenaga olibe lini ibanebi mbirale i̱ninaga wiabagi hene ngelonaga padua ngabi tara tara ngaru heba biamaga hene ngarubi ira hagua ngabilo delaga inisenesi ngarubi lomabu ngulene nga. ");
INSERT INTO hui_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","Ani bialu ege to̱le̱ muni dewaoreme yolo miaga tara tara ngarubi loma binigo mo miaga agali haguane timbuninaga aga mini ebodi mo yáribia halu labolabo galuhombeni karulaga ngagobi mo yári bia holenaga migi bulene nga. ");
INSERT INTO hui_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Ani bialu i̱ni tí heba mandagi holiya i̱naga Balai Anda mbira tínaga balai anda bu kamiru dombeneha bia halimu, lalu wali agali lamibe. ");
INSERT INTO hui_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Ai i̱naga anda ogoni ogobi helo lalu andanaga magi manda i̱na í̠hondo mo walia harodagua bilimu, lene. ");
INSERT INTO hui_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Anduane Homogohanda laabo halu lalu, Wali agali tígua Mbogoyi mbira ira agasia dibu pelowa mbaraleore ngagome wabilimu. Mbogoyi ogoni luninaga magi sendimida emene handari mbirani pira mbira (110) arane timbuninaga magi sendimida emene pira waragariani waragaria (66) manda bima iraga halu magi sendimida emene pira waragariani waragaria (66) helo wabilimu. ");
INSERT INTO hui_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Ani bialu ngolo bayaleore irani do taulo wahene ngarume Mbogoyi ogoni tagira tamuhabi baya hangu paraho dambi halu bu gimbu bini nene pugu bidadagua ngolo baya uruni ariame mo homane howa paraho mabu bilimu. ");
INSERT INTO hui_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Ani bialu Mbogoyi ogoni iraho yulenenaga gi pagida ale holene gimbuni maria ngadagua mabubi maria ngolome dege wabuwa gene maria dindiha karu ta howa wabu helalimu. Gene mende mendehabi kira labolabo helalimu. ");
INSERT INTO hui_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Ani biai howa Mbogoyi iraho yulenenaga ira agasiame ira kira wabu ngelalimu. Ani ngelowa ira ogoni labobi ngolome para hadambi dege halimu. ");
INSERT INTO hui_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Ogoni biai howa ira ogoni labo Mbogoyinaga gene dindiha mbirale mabubi gi pagida ale ngolome wabu helarimigoha Mbogoyi iraho yalu polenedagua abe tale buwa mo karulalimu. ");
INSERT INTO hui_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Ira kira Mbogoyi iraho yulene ogoni labo golo wia nabi Mbogoyi heba kaore ani wiaabo helo helalimu. ");
INSERT INTO hui_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Mani ege to̱le̱ mbalape kirani i̱naga bi mana wabu nguleberogo Mbogoyi ogoniha wilimu. ");
INSERT INTO hui_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Ani bialu mbogoyi ogoninaga panga ngolo bayaleore ngagome wabuwa luninaga magi sendimida emene handari mbirani pira mbira (110) wialu arane timbuninaga sendimida emene pira waragariani waragaria (66) ngelo wabu helalimu. Ogoriani howa wali agalime mana ko biniru domo waholene wulebira. ");
INSERT INTO hui_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Ani buwa tígua dahuliyali handalehe kira ngolo bayaleorerume baya hangu hamame bo dambu tiga bigi buwa wabilimu. ");
INSERT INTO hui_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Ani wabuwa Mbogoyinaga daligani mendego gi tigaha mendego gi lehayagi lowa talebu helalimu. Tígua ngolome Mbogoyinaga pangabi dahuliyali handalehe ogonilabobi wabilimu. Mbirale uruni ti hangu hangu wabia ndo Mbogoyi pangabi dahuliyali handalehebi bibahende mbiraoreha wabu gimbu bini ngelo wabilimu. ");
INSERT INTO hui_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Dahuliyali handalehe kira ogonilabo libuni handa edene buwa Mbogoyinaga panga daligani wali agalinaga ko domaga laga ngagoria helalimu. Libunaga babaganeme Mbogoyinaga panga yula dambi hai helo helalimu. ");
INSERT INTO hui_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Ani biai kamigola ege to̱le̱ mbalape kirani i̱naga bi mana gilibuwi nguleberogo Mbogoyi biagoha ogonilabo mo ngelowa panga payalimu. ");
INSERT INTO hui_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Ani bu ngeledemigola i̱ni ibalu í̠la Mbogoyi panga wali agalinaga ko domaga ngagoria lola holebero. I̱ni dahuliyali handalehe kira handa edene bu heledamigoria hanuni íbu howa i̱na í̠hondo i̱naga bi mana latagi halu holebero. Anigo bi mana uruni Isaraele wali agalime taluwa bialu helo í̠na tihondo lamulene nga, lalu Anduane Homogo ibugua Mosesehondo lamini. ");
INSERT INTO hui_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Anduane Homogohanda ogodagua laya. Tebolo dagia mbira ira agasia dibu pelowa ogonime wabilimu. Tebolo dagia ogoni luninaga magi sendimida emene pira halirani halira (88) aranenaga sendimida emene pira mariani maria (44) wialu daliganaga sendimida emene pira waragariani waragaria (66) helo wabilimu. ");
INSERT INTO hui_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Ani wabu ngelowa ngolo bayaleme paraho dambi halu tebolonaga gibuni nene ngadagua ngolo mo homane howa paraho dambi halimu. ");
INSERT INTO hui_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Ani buwa tebolo neneni ngolome paraho mabu bulenego tohenaga magi sendimida emene halira helowa ogonime tebolo neneni ngolome para hayago lone paraho dambi halu tebolo nene bibahendeni paraho mabu bupe halimu. ");
INSERT INTO hui_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Ani buwa tebolo biago iraho yulenenaga ngolome wabini mabubi maria gi pagida ale wabuwa gene maria kagoha ta howa wabu helolene nga. ");
INSERT INTO hui_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Ani bialu tebolo iraho yulenenaga mabubi uruni gi pagida ale ogoni tebolo gene maria kago tiga tiga nene ngolome paraho dambi hayago andaneha dege haparaho helolene nga. ");
INSERT INTO hui_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Ani buwa ira agasiame tebolo iraho yulene kira manda mandabu ngelowa ngolome paraho dambi halimu. ");
INSERT INTO hui_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Ani bialu waini iba loma binigo odo delolene ndisibe mbira wabialu beledibi be marubi wabia dege bilimu. Be uruni bibahende ngolo bayale hangume wabiai halimu. ");
INSERT INTO hui_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Ani bialu tígua mberedi i̱hondo lomabu ngeremigo bibahende i̱ninaga deni tebolo dagia ngagoria yu puwa ngelalimu, lalu Anduane Homogohanda lene. ");
INSERT INTO hui_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Anduane Homogohanda laabo halu lalu, Tígua ngolo bayaleorerume lamu hale wiagane irane wabu helalimu. Hamame ngolo baya hangu dambu tiga bigi buwa lamu hale gene helolene tene baya hangu ngelowa irane ogoriani mo karulo helalimu. Ani buwa lamu halenaga gene kagoria ginigene helowa wabupe halimu. Ani buwa ngolome dege balawaya wabuwa lamu hale gene ogoniha wabu gimbu bigi bilimu. ");
INSERT INTO hui_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Lamu halenaga irane ogoriani ginigene waragaria wabuwa abene mendeha tebira mendehabi tebira dege dege wabu helalimu. ");
INSERT INTO hui_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Lamu hale gebagene biarunaga mbira mbirani balawaya ira amononaga lini ale tebira dege dege wabu helalimu. ");
INSERT INTO hui_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Lamu halenaga iraneni balawaya bayale ira amononaga lini dedaligobi mitangi bialu maria wabu helalimu. ");
INSERT INTO hui_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Ani biai howa lamu hale gebagene biaruni andanehayagi balawaya yuni ale mbira mbira wabuwa helaga bilimu. ");
INSERT INTO hui_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Ani bu ngelowa hamame bo ndibulaga bialu mo mbiraore howa wabu gimbu biai halimu. ");
INSERT INTO hui_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Ani biai howa lamu halenaga dolene karia wabuwa irane manda mandabu wirimigoria berelaga bilimu. Ani buwa lamu hale wá haragome i̱naga Balai Anda kagoha daanda helonaga baya hangu mo dabadaba howa mo tiga bu ngelalimu. ");
INSERT INTO hui_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Ani buwa ira dedago tabolene pero mbira ngolo bayaleoreme wabialu beledi marubi wabilimu. ");
INSERT INTO hui_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Lamu hale wabulenenaga gene biagobi bibahende wabulenenagabi ngolo genda magi kilogarama pira tebirani duria (35) mo ngelowa bulene nga. ");
INSERT INTO hui_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Tígua mbirale uruni wabule howa i̱na ogobiore bilimu lalu hari nene biagoria howa walia harugoni manda buwa langirudagua bilimu, lalu Anduane Homogohanda Mosesehondo lamini. ");
INSERT INTO hui_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Anduane Homogohanda laabo halu lalu, Tígua i̱naga Balai Anda bule anda dangi labolabo pu payini bayaleore mindibi hari mindini handalehe ngarumebi tagalitaya handalehe ngarumebi daramabi ngarumebi wabini ogobi dege dege labolabo pirame bulene nga. Ani bialu aga lebiaga pume dahuliyali handalehe labolaboni lebiamaga halimu. ");
INSERT INTO hui_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Labolabo pira bibahendego ogobi dege dege wabu ngelalimu. Luninaga magi mida homberia (12) yangalenaga mida kira lowa wabu ngelalimu. ");
INSERT INTO hui_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Ani buwa duria halu mbira lebumaga halu duria mendego halu mende lebumaga halimu. ");
INSERT INTO hui_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Ani buwa labolabo ogonilabo mo gimbu bulenaga aga mindibime mabubi gi pagida ale wabuwa lene leneha mo gimbu bulenedagua helaga bilimu. ");
INSERT INTO hui_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Gi pagida ale uruni labolabo ogoni kirabalinaga arane mende mendehayagi dege pira duria (50) labolaboni helaga bilimu. ");
INSERT INTO hui_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Ani bu helowa ai labolabo timbuni biagolabo kirabali mo gimbu bulenaga ngolome wangobi pira duria (50) wabilimu. ");
INSERT INTO hui_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Ani biai howa mani Balai Anda dangi timbuni mbira wabuwa i̱naga Balai Anda ogoni bu dangila dambi hai halimu. Anda dangi ogoni aga nogo meme irinime wabini bearia (11) bibahendeme bulene nga. ");
INSERT INTO hui_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Uruni bibahende ogobi dege dege helo wabilimu. Luninaga ge magi manda bialunaga mida haleria (13) helo. Arane yangalenaga mida kirame bulene nga. ");
INSERT INTO hui_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Ani buwa labolabo duria halu mbira lebu gimbu bialu labolabo waragaria halu mende lebu gimbu beramigola labolabo timbuni luni kira holebira. Ani bialu labolabo halu mende waragaria lebu gimbu bini biagonaga waraganego pau ladai buwa balai anda biagonaga harabahayagi dambi helalimu. ");
INSERT INTO hui_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Ani buwa mbirale gi pagida ale pira duria (50) anda dangi mendegonaga gibuniha wabu helalu pira duria (50) anda dangi mendegonaga gibuniha wabu helalimu. ");
INSERT INTO hui_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Ani biai howa boronosime mbirale yania helolene wangobi pira duria (50) wabuwa Balai Anda dangi timbuni kira biago laboha wabu helaramigoha yaniaho helaga beramigola labolabo biago lebumaga hene mbiraore mbaule wulebira. ");
INSERT INTO hui_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Ani buwa anda dangi lalu kamiria luni bolangua holebirago ogoni i̱naga Balai Anda ogoninaga anda tibihayagi paulope howa luni helo wahalimu. ");
INSERT INTO hui_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Ani bialu anda manda mende mendehayagibi luni bolangua ho kagome anda ibiduba helo gulatagi ho helo wahalimu. Anidagua biragome Balai Anda dangilo yi hai hene holebira. ");
INSERT INTO hui_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Ani buwa Balai Anda dambi holenenaga kirabi wia dege bida. Mbirago nogo sibi wangabenaga dongone mo daramabi ho ngarume wabuwa mendego wena timbuni iba tia alenaga dongone ngagome wabulene nga. ");
INSERT INTO hui_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Anda háinaga ira generu gimbu gimbu bulene ira mini agasiame bilimu. ");
INSERT INTO hui_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Anda ira uruni luninaga ge magi manda bialu mida maria mbalapenaga sendimida emene pira waragariani waragaria (66) helo helalimu. ");
INSERT INTO hui_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Ira anda háinaga gene uruni maru dindihayagi gimbu bilo manda bialu luniale tigi halimu. Ira bibahende luni tubagi lolani hondowa ogobi dege degeore tigi haga bilimu. ");
INSERT INTO hui_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Anda háinaga ira kira kira dege dege daba hamagamaga buwa daga lamaga halu pira kira (20) mende mende lowa abene unurayaginaga wabilimu. ");
INSERT INTO hui_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Ani buwa silibame mbogoyi emene dege dege pira maria (40) anda gene biaru berelaga bule wabilimu. Ai anda gene kira mbogoyi mbiraha helaga bilimu. Ani beramigome mbogoyi mo hongo holebira. ");
INSERT INTO hui_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","21","Anda gene maru anda manda uyurayagi karubi nde ani dege bulene nga. Ani bialu anda gene pira kira (20) wabu manda mandabu ngelalu anda gene berelolene mbogoyi pira maria (40) silibame wabu ngelalimu. Silibame wabini mbogoyi kira kirani anda gene berelolene nga. ");
INSERT INTO hui_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Ani buwa anda gene ni paliragohayagi waragaria helalu ");
INSERT INTO hui_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","anda gene kira mende manda tibila gimbu biragoha helolene nga. ");
INSERT INTO hui_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Anda háinaga gene manda tibila gimbu biragoha kira ogonilabo ho pagu pagubi lowa gimbu bima iraga helolene nga. Manda tibila gimbu birago bibahendeha ani dege bulene nga. ");
INSERT INTO hui_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Ani biragola anda tibihayagi anda gene halira halu siliba mbogoyi pira mbirani waragaria (16) anda gene dindiha mo hongo holene wialu mbogoyi kirame anda gene mbira mo hongo holene wulebira. ");
INSERT INTO hui_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Ani buwa anda hái libu banga bulenaga ira mini agasia dibalu lunioreru pelo mbaralowa wilimu. ");
INSERT INTO hui_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","Ira luni mbalape uruni aria duria anda hái manda abene unurayagi libu para halu duria mende uyurahayagi libu para halu duria tebone ni paliragohayagi libu para halu bulenaga ani dibu pelo manda bilimu. ");
INSERT INTO hui_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Anda hái libu para holenaga ira dibu pelaramigo lunaga anda magi manda buwa anda ibuniore karulape puguwa pelalimu. ");
INSERT INTO hui_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Ani buwa anda genebi anda ira karubi ngolome paraho dambi halimu. Ani buwa mandaha hái para haramigo yaniaho helonaga ngolome yania holene mabubi gi pagida ale maru wabuwa ira hái libu para kamigo yaniho helaga bilimu. Anda hái para holene ogoni ngolome paraho dambi halimu. ");
INSERT INTO hui_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Urunidagua biai howa Balai Anda ogoni i̱na ogobiore bilimu lalu hari nene biagoria howa walia harugoni manda buwa langirudagua bu helalimu. ");
INSERT INTO hui_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Uruni biai howa aga labolabo baya taraore mbira anda tamuha hobaki holene wabilimu. Aga timbuni ogoni pu tara tarame mo yári biahaga bialu howa nogo sibi irinime payini mo mindibi howa hari mindini handalehe ngarumebi mo tagalitaya ale hene ngarumebi mo daramabi ho ngarumebi mo yári bia halimu. Ani buwa dahuliyali handaleheru labolabo ogoriani lebialu yári bia halimu. ");
INSERT INTO hui_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Ani buwa ira agasia mbira dibuwa anda gene ale maria wabuwa ngolome para hadambi halimu. Anidagua buwa silibame mbogoyi maria wabilimu. Ani wabuwa ira gene biago mbogoyi ogoriani helalimu. Ani helowa ira ogoriani aga yani helonaga wangobi mbira ngolome wabuwa ira maria ogoriani ta howa helaga bilimu. ");
INSERT INTO hui_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Ani buwa labolabo biago ogoriani mo gerela halimu. Mo gerela kamigola anda biago hobaki bulebira. Ani hobaki bu kagola Habo Nalolene Bi lo winigonaga Mbogoyi biago hobane tamuhayagi mo yalu puwa ogoniha ngelalimu. Labolabo biagome anda biago mo hobaki kagola Hobane mbirago Loma Bia Hene halu Hobane mendego Loma Bia Heneore holebira. ");
INSERT INTO hui_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Ani kagola Habo Nalolenenaga Bi ege to̱le̱ kirani gilibu winigonaga Mbogoyi biago tamu Hobane Loma Bia Heneore laga ngagoha mo wilimu. Ani buwa panga ngolome wabu wini biagome payalimu. Panga ogoriani ko binigo domo waholene wulebira. ");
INSERT INTO hui_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Ani bialu tebolo dagia biago anda Hobane Loma Bia Heneore hayago tagirahayagi mo wilimu. Anda hái abene uyurahayagi kagoria wiapara howa ngelalimu. Anda manda abene unurahayagi lamu hale manda mandabu wini biago mo ngelalimu. ");
INSERT INTO hui_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Ani biai howa labolabo timbuni mbira anda ogoninaga panga helole wabilimu. Panganaga labolabo ogoni pu tara tarame mo yári biahaga bialu nogo sibi irinime payini mo mindibi howa hari mindini handalehe ngarumebi mo tagalitaya ale hene ngarumebi mo daramabi ho ngarumebi labolabo wabini ngaruni yári bia halimu. ");
INSERT INTO hui_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Ira agasia mbira dibuwa gene duria wabuwa ngolome paraho dambi halimu. Boronosime mbogoyi duria anda gene uruni helole wabu ngelalimu. Ani buwa mbogoyi duria uruniha ira gene duria biaru hanga howa labolabo gerela holene wangobi maru ira ogoriani helalu buwa labolabo biago ogoriani mo gerela halimu, lalu Anduane Homogohanda lene. ");
INSERT INTO hui_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Anduane Homogohanda laabo halu lalu, Tígua ira agasia dibuwa lomabu delaga dabu mbira wabilimu. Gibuni gibuni bibahendeha ge magi manda bialu mandanaga ogobi dege dege mida kirani sendimida emene pira kira (20) helo. Daliganaga mida mbirani sendimida emene pira tebira (30) halu bilo wabilimu. ");
INSERT INTO hui_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Ani buwa nogo bulumaganaga ne gayane ale maria ira agasia biagome dege wabuwa gimbuni mariani helalimu. Ani buwa mbirale bulumaganaga ne gayane ale biarubi lomabu delaga dabu ogonibi bibahende boronosime paraho dambi hai halimu. ");
INSERT INTO hui_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Ani buwa ndisibe marubi ira pungaru hilo yulenaga wabilimu. Ani bialu nama tabuli ale emene marubi nama dege mende genehe mini pogobi beledibi bibahende ira punga hilo waholene ale uruni boronosime dege wabiai halimu. ");
INSERT INTO hui_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Ani buwa mbirale ira delagane dagia diri dewawi dabu ogoninaga gene maria kagoria helole boronosime dege wabilimu. Ani buwa dabu ogoni iraho yulenaga mabubi mbira gi pagida ale dabu iraho yulenenaga ira helolene maria gene maria kagoha tahowa wabu helalimu. ");
INSERT INTO hui_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Ani buwa ira delolene dagia biago dabunaga gene obeneni bapara howa hama pialu lina obeneni dege hairi helalimu. ");
INSERT INTO hui_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Ani buwa mbirale mabubi gi pagida ale maria iraho yulenaga ira nguni pelolene biago nira dindihayagi gene maria biagoria bu gimbu buwa helalimu. Ira agasia pelowa kirago boronosime paraho dambi halimu. ");
INSERT INTO hui_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Lomabu delaga dabu biago yalu pole howa ira kira ogonilabo mabubi gi pagida ale yulene dindiha manda bu helarimidagua mo karulalu yu pilimu. ");
INSERT INTO hui_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Tígua lomabu delaga dabu ogoni ira pelene mbalapeme mbogoyi ale dege wabilimu. Ani buwa dindiha henge ngelo wahalimu. Abale ogodagua bilimu lalu amu hari nene wiagoria howa langirudagua bilimu, lene. ");
INSERT INTO hui_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Anduane Homogohanda laabo halu lalu, Tígua labolabo bayaleoreru wabuwa i̱naga Balai Anda kagoha pabe bu yanda holenaga bilimu. Labolabo ogoni unurahayagi aranenaga ge magi manda bialunaga mida pira mariani maria (44) wabilimu. ");
INSERT INTO hui_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Ani buwa gene pira kira (20) boronosime wabu wialu gene uruni helolenenaga mbogoyibi pira kira (20) dege boronosime wabu ngelalimu. Ani bialu bubigi homane luni banga bulene silibame wabuwa gene wiaru bibahende daba ho gimbu gimbu bigi bilimu. Ani buwa labolabo bubigi homane luni banga bini biaruni gerela holenaga ta howa silibame wangobi wabu helalimu. ");
INSERT INTO hui_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Anda manda abene uyurahayagibi ogonidagua dege wabu helalimu. ");
INSERT INTO hui_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Ai ni paliragohayaginaga pabe labolabo aranenaga ge magi manda bialunaga mida pira kirani kira (22) wabuwa gene boronosime pira wabialu mbogoyibi pira dege gene uruni helolenenaga diriwi wabu helalimu. ");
INSERT INTO hui_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Ani bialu anda panga haraba abene ni tagira ibiragohayagi ngagoha helolenenaga labolabo aranenaga ge magi manda bialunaga mida pira kirani kira (22) dege wabialu helalimu. ");
INSERT INTO hui_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","15","Labolabome pabe bu yanda ho helolenego aranenaga ge magi manda bialunaga mida waragariani sendimida emene pira waragaria (60) lowa panga haraba anda pu íbu bulenegoria lene labolaboni tale bu helalimu. Boronosime mbogoyi wabu ngelayagoria gene manda manda bu wiyago mendehayagi tebira mendehabi tebira dege lowa helalimu. ");
INSERT INTO hui_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Pabe buyu mabu bulenenaga labolabo bibahende baya taraoreme wabu helalimu. Labolabo ogoni ge magi manda bialunaga mida dira wabialu pu bayale nogo sibi irinime payini mindibiha guyini hari mindini handalehe ngarumebi tagalitaya aleha guyini ngarumebi daramabiha guyini ngarumebi yári bia halimu. Ani buwa boronosime mbogoyi maria diriwi wabuwa gene mariabi wabia dege buwa diri ogoniha mo karula ho helowa labolabo ogoni ira gene ogoriani mo gerelape halimu. ");
INSERT INTO hui_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Gene helama pedamigo bibahende daligahayagi bubigi homane luni banga bulene silibame wabuwa bu gimbu gimbu bigi bu helalimu. Gene uruni ta howa silibame wangobi wabu helaga bilimu. Gene uruninaga helolene mbogoyi boronosi degeme wabu helaga bilimu. ");
INSERT INTO hui_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Pabe ogoni luninaga ge magi manda bialunaga mida pira mariani maria (44) aranenaga ge magi manda bialunaga pira kirani kira (22) daliganaga ge magi manda bialunaga mida kirani sendimida emene pira kira (20) helo bilimu. Labolabo ogoriani gerela holene pu bayaore ngarume wabilimu. ");
INSERT INTO hui_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Balai Anda ogoni bulenego bibahende boronosime hangu biai halimu. Ani bialu tígua Balai Anda dangini paulape kagoha mo hongo halu dariba holenaga dindiha gelo helama polene karubi bibahende boronosi hangume wabiai halimu. Labolabome pabe bidago mo hongo halu daba holenebi nde boronosime dege wabilimu, lalu Anduane Homogohanda lene. ");
INSERT INTO hui_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Anduane Homogohanda Mosesehondo lamialu lalu, Í̠na Isaraele wali agali lamialu Anduane Homogonaga Balai Anda kagoha lamu hale karia wiagane irane mbiraoreni daho wiaabo helonaga weli bayaleore olibe linime wabiniru yalu ibalimu labe. ");
INSERT INTO hui_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Arono halu ibu igini karu tigua lamu hale uruni mo yalu puwa i̱naga Balai Anda biago labolabome hobaki hene biagonaga tamu hobane Habo Nalolene Bi lo winigonaga Mbogoyi wiyagoha ndo hobane mende tagirani hayagonaga ngelelo. Horo pigane eberamiangi weli yalu ibuwa lamu haleha berelalu lamu hale hungubia howa tamuha ngelalu horo bibahendeni ne laragola howa gao lelo ani daho wiaabo helo ngelalimu. Horo bibahendengi weli berelaabo halu lamu hale biaru ogonidagua daho wiaabo heloleberemi. Ani bialu howa tínaga waneigini aguanene mani holobadarumebi mana ogonidagua bialu haabo holene nga. ");
INSERT INTO hui_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Anduane Homogohanda laabo halu lalu, Mosese-o í̠ andaga dai bialu í̠ hamene Arono halu ibu igini Nadababi Abihubi Eleasabi Idamabi bibahende ibai hadaba labe. Ani íbu hai kagola Isaraele wali agali bu karu aria lenego ai ti i̱naga loma binigo mo miaga agaliru helo dabo helabe. ");
INSERT INTO hui_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Ani helowa wali agali tigua ibunaga aga bayale tara mo yári bia howa Arono milimu. Ani meremigola ibu mo karulo ho helo. Ani howa ibu maru karu aria ndo ibu dabo helene howa mini lene mbira holebira. ");
INSERT INTO hui_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Agali maru tigua aga bayale tara tara wabigi bilonaga manda tara tara i̱na talebu migi biruruni ti ibilo olabe. Íbu ngoaiho kagola Arono ibu loma binigo mo miaga howa i̱naga biabe bulene ngaru bialu howa mo karulo helo aga loma binigo mo miaga agalime biaga lene ngelo maru wabilimu. ");
INSERT INTO hui_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Ani buwa labolabo emene mbira yári tara tarabi galuhombeni mo karulelo wabia halimu. Ani buwa labolabo mbira mo yáribia howa mini ebodi wabialu mbira luni biagimbu bilo wabialu mbira giha bulene yári biahe wabialu mbira emboneni bobu mabu bilo wabialu mbirago mandibu wilo wabilimu labe. Loma binigo mo miaga agalinaga aga uruni Aronobi ibu igini karubi tigua mo karula howa i̱naga biabe bia halu helo ani bilimu labe. ");
INSERT INTO hui_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Aga wabiaga agali tigua aga uruni wabulenaga pu nogo sibi irinime payini ngaru mialu maru mindibiha guyini hari mindini handalehe ngarumebi maru tagalitaya aleha guyini ngarumebi maru daramabiha guyini ngarumebi maru pu ngolo handaleheme payini ngarumebi labolabo bayale tara tara ngarumebi loma binigo mo miaga agalinaga aga labolabo uruni wabilimu. ");
INSERT INTO hui_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","Ani bialu aga mini ebodi pu sibi irinime payini ngago mialu maru mindibiha guyini hari mindini handalehe ngarumebi maru tagalitaya aleha guyini ngarumebi maru daramabiha guyini ngarumebi pu maru tarame payini ngolo handalehe ngarumebi loma binigo mo miaga agalinaga labolabo ogoni mo yáribia haga bulene nga. ");
INSERT INTO hui_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Ani buwa aga payani erembiraha buhabi paulape kago yania helonaga pu nogo sibi irinime payini ngagome nu ene ale mabu bo bidagoria lebumaga halimu. ");
INSERT INTO hui_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Ani bialu pu nogo sibi irinime payini ngago mialu maru mindibiha guyini hari mindini handalehe ngarumebi pu maru tagalitaya aleha guyini ngarumebi pu maru daramabiha guyini ngarumebi aga mini ebodi ngagoria mo yáribia howa labolabo karulayagoria dege lebu para halimu. ");
INSERT INTO hui_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Ani buwa ege to̱le̱ kira mini kaneliana ngagoria Isaraele hameigini homberia (12) karunaga mini gilibu wilimu. ");
INSERT INTO hui_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Mini gili bule howa Yagaba igini waheneni howa mini gilibu wima pialu heyogone henegonaga mini gilibu maro bilimu. Ege to̱le̱ni mini gili bialu howa ai ege to̱le̱ mbirani mini waragaria gili bialu ege to̱le̱ mendeni mini waragaria mende gili bigi bilimu. ");
INSERT INTO hui_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Í̠na agali mbira ege to̱le̱ni mini gili biaga mandabi kagome Yagaba igini homberia (12) biarunaga mini ege to̱le̱ kira ogoni laboni gilibu wiai helo biabe ogoni agali mbira kagohondo mo mibe. Ege to̱le̱ kira ogoni yania helonaga ngolome paraho dambi haga bialu mo yáribia halimu. ");
INSERT INTO hui_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Anidagua biai howa ege to̱le̱ni mini gilibuwi biago pume hende howa aga mbira mini ebodi nu ene ale payani mo paulaki howa lebumaga halu erembirahabi ani dege bini biagonaga tombehayagi ege to̱le̱ Isaraele hameiginirunaga manane biago pongobia halimu. Ani buwa Aronohanda Isaraele hameiginirunaga mini ibunaga payani pongo biaho kagola hondowa Anduane Homogo i̱na i̱naga Isaraele wali agali mitangi bu haabo holebero. ");
INSERT INTO hui_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Tigua ngolome mo yáribia hene kirabi ");
INSERT INTO hui_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","seni pu ngolo bayaleme wabini kirabi mo lu howa pu payaradagua buwa ngolome yári biahe biagoria pongobia halimu, lalu Anduane Homogohanda Mosesehondo lamini. ");
INSERT INTO hui_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Anduane Homogohanda laabo halu lalu, Loma binigo mo miaga agali haguane timbuni kago ibugua aga mbira galuhombeni karula dambi helonaga wabulene nga. Aga ogoni Ngode Datagaliwabenaga hame ngago hondolenaga karulagane. Aga mini ebodi emene mbira ala wabirimigo mendebi ogonibi dege wabulene nga. ");
INSERT INTO hui_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Aga ogoni luninaga magi sendimida emene pira mariani maria (44) wabialu yangalenaga magi sendimida emene pira kirani kira (22) wabilimu. Ani wabuwa hau hanuniore mo paulaki beregola nguni ogobi labolabo helo ani bilimu. ");
INSERT INTO hui_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Ani buwa ege to̱le̱ muni dewaoreme yolo miaga ngaru ariame duguni maria helalimu. Duguni mbirago ibu ege to̱le̱ mini lubibi tobasabi ganedebi uruni helalimu. ");
INSERT INTO hui_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Duguni mendegoria ege to̱le̱ mini emeralabi sabaiabi daimonobi uruni helalimu. ");
INSERT INTO hui_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Ani bialu duguni tebonego ege to̱le̱ mini tegoisibi agedebi amedisibi helalimu. ");
INSERT INTO hui_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Ani bialu duguni manenaga ege to̱le̱ mini berilibi kanelianabi yasababi helaga bilimu. Ege to̱le̱ uruni ngolome mo yáribia haga buwa mani pongobilo pu helo ngelalimu. ");
INSERT INTO hui_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Ege to̱le̱ homberia (12) uruni mbira mbirani Isaraele hameigini mbira mbira karu mitangi bialu Yagaba igini homberia (12) biarunaga mini gili biai halimu. ");
INSERT INTO hui_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Ani buwa ngolo bayaleme seni pu kira wabuwa ogonime labolabo galuhombeni karulolenenaga hende howa pongo bia hole wabilimu. ");
INSERT INTO hui_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Labolabo galuhombeni karulagane biagola mo barobia holenenaga ngolome mabubi kira wabuwa ogoriani helalimu. ");
INSERT INTO hui_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Ani buwa seni pu ngolome wabini biagolabo mabubi kira ngolome wabini ngagoria mo pongo bia halimu. ");
INSERT INTO hui_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Ani buwa seni pu kira biagolabo nguni mende ege to̱le̱ kira Isaraele hameigini mini gilibuwi biagolabo aga mini ebodinaga nu ene ale payani lebu winigoria pongo bia halimu. ");
INSERT INTO hui_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Anigo ngolome mabubi gi pagida ale kira lone wabuwa labolabo galuhombeni karulaga biagonaga dindihayagi nguni kira kagoria pongo bia halimu. ");
INSERT INTO hui_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Ngolome mabubi gi pagida ale kirabi lone wabuwa aga mini ebodinaga nu ene ale dindiha lebumaga halimu. ");
INSERT INTO hui_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Ani buwa pu mindibiha guyini hari mindini handaleheme mabubi kira biagolabo galuhombeni karulaga biago hayagoriani pongobia howa aga mini ebodi biagonaga mabubi hayagoria pongo bumaga halimu. Anidagua beremigome labolabo galuhombeni karulagane ogoni hado ibira habe nahe mandibu hongohe ndibule bidagola barobia hene hadabe nahe hongohe holebira. ");
INSERT INTO hui_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Ani bialu Arono ibu Balai Anda biagonaga Hobane Loma Bia Hene biagoha anda pole howa aga galuhombeni karulaganego Isaraele hameigini homberia (12) biarunaga mini gilibuwi biago karulalu anda polene wulebira. Anidagua bu kagola de hondowa Anduane Homogo i̱nime i̱naga Isaraele wali agaliru mitangi biaabo holebero. ");
INSERT INTO hui_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Ani bialu Arono ibu Anduane Homogo i̱naga anda Hobane Loma Bia Hene biagoha i̱ni kogoria anda ibule howa ege to̱le̱ kira mini Urimu Tumimula aga galuhombeni karulagane biago ibuninaga mani paulaki bini biagoha yalu anda polene wulebira. Ani bulene ngago irane Anduane Homogo i̱na tigua bialu helo hamelo kogo lamulenaga ani bulebira, lalu Anduane Homogohanda Mosesehondo lamini. ");
INSERT INTO hui_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Anduane Homogohanda laabo halu lalu, Aga luni biagimbubi aga mini ebodi dindiha karulaga biago ogoninaga wabulene pu nogo sibi irinime payini ngago mindibiha guyini hari mindini handalehe hene ngagome wabilimu. ");
INSERT INTO hui_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Wabuwa loma binigo mo miaga agali kago ibunaga haguane anda pelolenedagua manda buwa hanuni wabu ngelalimu. Ani wabu ngelowa aga lerela timbu holigonaga aga podene mbirame ngunidago paula dai buwa aga lebiagadagua lebulene nga. ");
INSERT INTO hui_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","34","Ani buwa aga ogoni nguni dindihayagi pu nogo sibi irinime payini mindibiha guyini hari mindini handalehe ngarumebi tagalitaya aleha guyini ngarumebi daramabiha guyini ngarumebi mo yári bia halu ira pomegaranade lini aleru wabu helaga bilimu. Ani buwa ira pomegaranade lini ale yári bu ngagoria dombeni mbelo emene emeneru ngolome wabuwa nguni ogoriani dege pongo bia haga bima pilimu. ");
INSERT INTO hui_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Anidagua buwa Arono ibugua loma binigo mo miaga biabe bialu howa aga ogoni mo karulo howa bulene nga. Anda Hobane Loma Bia Hene biagoha i̱ni kogoria anda tamuha íbu howa tagira pugu biragola wali agali bu karume mbelo aga biagoria pongo bia hayaru ngi̱li̱nge̱le̱ laga laga birago hale holebira. Arono ibugua anidagua biyagua nde ibuni homolene nawulebira. ");
INSERT INTO hui_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Ani buwa ngolo bayale mbirame mani magagua wulenedagua mo mbalapuwa bi mbira Anduane Homogonaga Loma Biaho Nga lalu gilibuwi wabilimu. ");
INSERT INTO hui_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Ani wabuwa mendebi pu mindibiha guyini hari mindini handalehe ngarume pongobia howa loma binigo mo miaga agali haguane biagonaga wanakuini dombo heda wiradagua wia halimu. ");
INSERT INTO hui_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Horo bibahendengi Arono ibugua aga manda ogoriani dombo heda ale wanakuini karulo haabo holebira. Ani biragola Anduane Homogo i̱na Isaraele wali agalime i̱nihondo lomabu ngiraru yamulebero. Anigo tígua mbira bulene ngaru bia ko harimiyagua nde ogoninaga genda Arono ibugua yu howa ibunaga wanakuini karulo kago hondowa tígua i̱hondo ngirimiru i̱na yamule dege kogoni. ");
INSERT INTO hui_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Ani buwa Arononaga aga mbira giha bulene pu bayale mbirame wabilimu. Ani bialu Arononaga aga manda mbira labolabo bayaleoreme wabilimu. Ani buwa ogoni bobu dambi holenenaga aga yáribi bayale degeme wabuwa mandibu wiradagua karula habe. ");
INSERT INTO hui_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Ani buwa Arono igini bu karunaga aga giha karulolenebi mandibu biradagua aga luni bo bia dambi holenebi haguaneni karulaga tangi labolabome wabinibi uruni bibahende Arono igini karunaga wabiai halimu. Ani beramigola nde tigua aga uruni karulo kagola wali agali maru bu karunaga deni howa ti agali loma bia heneore mbira henedane hondowa wali agalime ti mini leneore holebira. ");
INSERT INTO hui_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Anidagua buwa Mosese í̠na í̠ hamene Aronobi ibu iginirubi agali uruninaga agabi yárirubi bibahende mo karula howa ti loma binigo mo miaga agaliore howa i̱naga biabe bialu helonaga loma bialu weli bayale olibe linime wabini ngago tinaga haguaneni odo wiahalu bibe. ");
INSERT INTO hui_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Tigua biabe bulene ngaru bialu karia wali agali we̱ loligo tinaga darasibi wabu milimu. ");
INSERT INTO hui_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Arono halu ibu igini ti i̱naga Balai Anda i̱ni kogoha ibiragolabi Hobane Loma Bia Hene ngagoha loma binigo mo miaga biabe bule lomabu delaga dabu ngagoria pialu howabi darasi ogoni bialu polene nga. Anidagua nabiyagua tini ko ogoni biragonaga homolene wulebira. Arono ibunaga igini aguanene maniore hama polobadarumebi mana ogoni dege talialu haabo holebira, lene. ");
INSERT INTO hui_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Anduane Homogohanda laabo halu lalu, Arono halu ibu igini bu karu ti i̱naga loma binigo mo miaga agali helo dabo helabelonaga mana maru bibelogo languliya. Nogo bulumaga wangabe mbirabi sibi wangabe kirabi uruni dere durubi mbira nabiore kago hondowa haru ibabe. ");
INSERT INTO hui_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Ani buwa balawa widi dambini bayaleore ngagobi mo yalu ibabe. Balawa uruni yidi nahe howa mberedi maru olibe lininaga weli odo biamaga howa wabialu mberedi maru olibe lininaga weli naberele howa wabibe. Balawa marume mbisigediru wabialu olibe lininaga welime ha̱i̱ habe. ");
INSERT INTO hui_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Ani buwa nogo bulumaga wangabe mbira sibi wangabe kira lowa haru halu i̱hondo loma bialu bo delalu howa mberedi mbisigedibi wabiriru mbasigedi nu mbiraha honowa i̱nihondo lomabu ngibe. ");
INSERT INTO hui_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Arono halu ibu igini biaru i̱ kogoha i̱naga Balai Anda haneni haru halu ibuwa ilili bialu wayawaya bia halimu. ");
INSERT INTO hui_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Ani biai howa loma binigo mo miaganaga aga biaru Arononi mo karula habe. Aga giha biagabi aga luni biagimbu biagabi aga mini ebodi biagobi labolabo emene galuhombeni karulaga biagobi mandibu biagobi bibahende mo karula hai habe. ");
INSERT INTO hui_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Ani buwa labolabo emboneni bobu mabu bilo karulaga biago karulalu ogoriani mbirale ngolome wabinigo ogo Anduane Homogonaga Loma Biaho Nga lalu gilibuwi biago wanakuini heda wiradagua bilo mialu bibe. ");
INSERT INTO hui_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Ani buwa dabene helonaga weli emboneni odo wiaga ngagome ibu loma binigo mo miaga helo ibunaga emboneni weli odo wia halu dabo helabe. ");
INSERT INTO hui_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Arono ibuni loma binigo mo miaga helo dabo helowa ibu igini biaru aga giha biaga biaru mo karula halu ");
INSERT INTO hui_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","labolabo bo bia dambi holene mandibu wiyago ale mo karula halu tinaga emboneni tangi labolabome wabinigo karulaga wiyago mo karula halu bibe. Arono ibunibi ibu iginirubi ti bibahende loma binigo mo miaga agali helonaga dabalu ani bibe. Anidagua beregome tinibi ti igini aguane mani hama polobadarubi bibahendeore loma binigo mo miaga howa i̱naga biabe ogoni bialu haabo holebira. ");
INSERT INTO hui_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Ani buwa nogo bulumaga mbira i̱ kogoha Balai Anda biagonaga haneni haru íbu helabe. Ani helowa í̠na Arono halu ibu igini biaruhondo lalu, Tígua nogo bulumaga ogoninaga haguaneni gi wilimu, labe. ");
INSERT INTO hui_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Ani bidagola nogo ogoni i̱ninaga deni howa Balai Anda haraba ngagoria bope habe. ");
INSERT INTO hui_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Ani buwa nogo bulumaga ogoninaga darama maru hambu yuwa lomabu delaga dabu ngagonaga gibuni maria ngagoria nogo bulumaganaga ne gayane ale maria karu í̠ninaga gi hondoneme ha̱i̱ habe. Ani bialu darama maru ibira ho ngago mo yalu puwa dabu ogoninaga dindiha odo paya biai habe. ");
INSERT INTO hui_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Ani biai howa nogo abenebi habane damenebi kabaneha hene bu karubi gubalini bunibi luhabene lilini kirabi maru podaga buwa i̱hondo loma bialu lomabu delaga dabu biagoriani delabe. ");
INSERT INTO hui_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Ani bialu mbirinibi dongonebi tini damenebi bibahende yu tagira puwa tínaga balai anda karu tagirahayagi delabe. Anidagua bulenego irane loma binigo mo miaga agali biarume ko biyagonaga domo wahelo loma ogonigo tagirani delabe. ");
INSERT INTO hui_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Ani bialu nogo sibi wangabe mbirago haru anda ibabe. Ani haru ibuwa í̠na Arono halu ibu iginiruhondo lalu, Tígua nogo sibi ogoni haguaneni gi wiai hadaba, labe. ");
INSERT INTO hui_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Ani biragola sibi biago balu darama hambu yalu puwa lomabu delaga dabu biagonaga gibuni maria ngagoha ta̱la̱ ba amu nana bibe. ");
INSERT INTO hui_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Ani buwa nogo sibi ogoni podo baga buwa gebi tinirubi wayawaya bialu sibi haguanebi mbirini podene maru ngarubi heba mo paga howa ngelabe. ");
INSERT INTO hui_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Ani bialu lomabu delaga dabu ngagoria irani lomabu delai habe. Ani beregola i̱ Anduane Homogo kogo i̱na loma ogoni irani dai heledegonaga ngabirago hondowa turu timbuni holebero. ");
INSERT INTO hui_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Ani buwa nogo sibi wangabe mende mbirale lomabu mulenaga biagobi haru anda ibuwa í̠na Arono halu ibu igini biaruhondo lalu, Tígua nogo sibi ogoninaga haguaneni gi wiai hadaba, labe. ");
INSERT INTO hui_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Ani bialu nogo bowa darama emene hambu yuwa Arononaga hale tigahayagi teneha darama ogonime ha̱i̱ habe. Ani bialu ibu igini bu karunagabi hale teneha ani dege biai habe. Ani buwa tinaga gi hondone angibiyane ge hondone angibiyanebi tigahayagi ha̱i̱ habe. Ani bialu darama maru ngagome lomabu delaga dabu ngagonaga gibuni maria ngagoha ta̱la̱ ba amu nana bibe. ");
INSERT INTO hui_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Mani darama maru lomabu delaga dabuni bedago mialu loma binigo mo miaga agali dabo helole haguaneni odo wiaga weli biagobi mialu Aronobi ibunaga aga biarubi Arono igini biarubi tinaga agabi bibahende darama ogonime tandala ba habe. Anidagua beregome Arono ibunibi ibu igini karubi tinaga aga bidarubi bibahende i̱ninaga loma bia hene dege wiai holebira. ");
INSERT INTO hui_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Ani bialu loma binigo mo miaga agali helonaga nogo sibi loma bini biago podabaga bialu habane abene damene kagobi erene tohe kagobi buni dara buwa darakibi luhabane lilini kirabi ge tigahayagi mbirini tohe kagobi podo wiai halimu. ");
INSERT INTO hui_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Ani bialu mbasigedi nuha mberedi tara tara i̱hondo lomabu ngini wabu hanarigo aria mbira mbira yamigi bialu olibe lininaga weli heba biamaga howa wabini biago mbirabi mberedi mende olibe lininaga weli bere nale howa wabini biago mbirabi mbisigedi biaru aria mbirabi mo yabe. ");
INSERT INTO hui_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Ani buwa nogo sibi ogonibi mberedi biarubi Arono halu ibu igini biaru mo mibe. Tigua mo yuwa i̱ deni howa gi dogolalu wigiwaga lalu yu helo mibe. ");
INSERT INTO hui_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Ani buwa mberedi uruni tigua yu hayaruni bibahende yamialu lomabu delaga dabu ngagoria irame dai helo delabe. Ani biragola i̱ Anduane Homogo i̱na loma ogoni irani dai heledegonaga nga birago hondowa i̱na turu timbuni holebero. ");
INSERT INTO hui_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Ani bialu nogo sibi mende mani bene biagonaga galukuni yuwa i̱ deni howa gi dogolalu i̱hondo yu wigiwaga lowa ogoni í̠nagago í̠ nabe. ");
INSERT INTO hui_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Agali mbira loma binigo mo miaga helo gahenge dabo helole howa nogo sibinaga galukunibi ge tigahayaginaga modawane mbirinibi lomabu yuwa i̱ deni howa wigiwaga lalu loma binigo mo miaga agali dabo helolebere. Ani biai howa nogo sibi mbirini odagoni loma binigo mo miaga agali karu ti nelo mo milimu. ");
INSERT INTO hui_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","I̱naga Isaraele wali agali tigua Anduane Homogo i̱la ho gimbu bulenaga tomo nolenengi nogo mbirale bo lomabu mialu howa nogo ogoninaga galukunibi ge tigahayaginaga modawane mbirinibi loma binigo mo miaga agali karu miaabo holene nga. Isaraeleali tigua Anduane Homogo i̱ni kogohondo loma urunidagua bu ngiaabo holebira. ");
INSERT INTO hui_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","Mani Arono homaragola ibunaga loma binigo mo miaga agalinaga aga damene bibahende ibu igini karuhondo mulebira. Arono igini mbirali ibu loma binigo mo miaga helo dabo helarangi ibugua aga uruni mo karulo holebira. ");
INSERT INTO hui_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Arono igini mbirame loma binigo mo miaga agali haguane ha aribia howa i̱ kogoha i̱naga Balai Anda Hobane Loma Bia Hene biagoha biabe bule ibalu howa ibugua aga uruni horo karu karulo haabo holene nga. ");
INSERT INTO hui_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Aronobi ibu igini biarubi ti loma binigo mo miaga helo dabo helarengi nogo sibi wangabe baregonaga mbirini ngaru Balai Anda pabe bu ya anda hene tamu ngagoria todobene behe dawabe. ");
INSERT INTO hui_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Ani buwa loma binigo mo miaga agali tigua mberedi mbasegedi nuha henene maru ibira hayagobi nogo sibi mbirini urunibi i̱ kogoha i̱naga Balai Anda haneni howa nolene nga. ");
INSERT INTO hui_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Ti loma binigo mo miaga agali helonaga dabalu nogo sibi biago bowa tinaga ko domo waholenaga loma bo delene biagonaga mbirini ngarubi heba nolebira. Ani buwa loma bini uruni wali agali bibahendeme nolene nawigo loma binigo mo miaga agali karu ti degeme nolene nga. ");
INSERT INTO hui_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Ani buwa nogo sibibi mberedibi uruni ti karulape nalu maru ibira hayagua horo mendeni nole nangelalimu. Nogo sibibi mberedi uruni loma binigo horo ogoningi dege nolene nga. Wia dege biyagua nde wahalu irani dai helo delolene nga. ");
INSERT INTO hui_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Í̠na Aronobi ibu iginirubi loma binigo mo miaga helo dabo helalu howa abale bibe lalu langirudagua bialu horo karu bialu habe. ");
INSERT INTO hui_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Horo karu bibahendengi nogo bulumaga mbira tígua ko birimigo domo wahelonaga loma bialu bo ngilimu. Ani bialu loma ogonime dege i̱ninaga lomabu delaga dabu kagobi ko mbira para nahe bayale dege wulebira. Ani buwa lomabu delaga dabu biago i̱naga loma biahene wilo olibe lininaga weli odo ba habe. ");
INSERT INTO hui_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Horo karu anidagua biaabo habe. Ani biai kegola lomabu delaga dabu ogoni i̱ninaga loma biaho wubagi heneore wiaabo holebira. Agali mbirame lomabu delaga dabu ogoni ela hayaguabi maru ale ngarume karumebi ela hayaguabi ela harago ibuni loma bini aria bu hinalu wubagi hene dege bu hinulebira, lalu Anduane Homogohanda Mosesehondo lamini. ");
INSERT INTO hui_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Anduane Homogohanda laabo halu lalu, Horo bibahendengi nogo sibi igini mali mbira pene kago kira bo loma buwa lomabu delaga dabu kagoria delaga biaabo halimu. ");
INSERT INTO hui_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Nogo sibi igini ogonilabo mendego egerebagi bo lomabu delalu mendego alendo bo lomabu delalimu. ");
INSERT INTO hui_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Nogo sibi igini mbira egerebaginaga ogoni heba balawa widime wabini genda magi kilogarama mbirabi olibe lininaga weli mbodoli be mbirabi odo biamaga howa bo lomabu delalimu. Ani bialu howa waini iba mbodoli be kira alebi loma bialu odo wilimu. ");
INSERT INTO hui_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Ani bialu nogo sibi igini mendego alendo bo lomabu delalimu. Balawa widime wabinibi olibe lininaga welibi waini ibabi loma bialu egerebaginaga lomabu delaridagua dege delabe. Tígua tomo uruni loma bialu Anduane Homogo i̱nihondo lomabu delaga dabu ngagoria deledemigola ngabirago hondowa i̱na turu timbuni haruli. ");
INSERT INTO hui_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Nogo sibi igini irani dai helo lomabu delolene ogoni horo bibahendengi delaho wiaabo halu i̱naga Balai Anda haneni i̱ deni howa delaabo holene nga. Ani bule lowa hama ogoriani mo ngoai ho kamigola i̱nime i̱naga wali agali bu kamiruni tí heba mandagi howa tíhondo bi langigi bulebero. ");
INSERT INTO hui_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Ogoningi i̱na Isaraele wali agali heba mandagi howa i̱naga wá taraore holeneme i̱naga Balai Anda ogoniha daluwa kogola tamu ogoniha i̱ninagaore wubagi helolebira. ");
INSERT INTO hui_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","I̱naga Balai Anda ogoni kagobi lomabu delaga dabu ngagobi kirabali i̱ninagaore lomabia howa wubagi heneore ngelolebero. Ani ngelowa Arono halu ibu igini karubi tigua i̱naga biabe bia halu loma binigo mo miaga helo dabo helolebero. ");
INSERT INTO hui_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Ani bialu i̱na Isaraele wali agali heba mandagi howa tínaga Ngode Datagaliwabeore holebero. ");
INSERT INTO hui_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Ani kogola tígua i̱niore Anduane Homogo tínaga Ngode Datagaliwabe kogome tí heba mandagi haabo holenaga i̱na tí Iyibi dindiha howa haru tagira pialu ogoria haru ibirudane hondoleberami. I̱ni Anduane Homogo tínaga Ngode Datagaliwabeore kogoni, lalu Anduane Homogohanda lene. ");
INSERT INTO hui_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Anduane Homogohanda laabo halu lalu, Ira agasia mbira dibu pelowa ira hagua ngabiaga mini inisenesi lomabu delolene dabu mbira bilimu. ");
INSERT INTO hui_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Dabu ogoni luninaga magi sendimida emene pira mariani duria (45) wialu aranenaga sendimida emene pira mariani duria (45) dege wialu daliganaga magi sendimida emene pira dira (90) helo bu helalimu. Gibuni maria ngagoria nogo bulumaganaga ne gayane ale maria ta howa wabu helalimu. ");
INSERT INTO hui_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Ani buwa gibuni maria bibahende ngolome para halu ngolome dege mo homabia howa dabunaga nene nene ngagoria ndibulo mabu bialu nogo bulumaganaga ne gayane handalehe maria kagobi ngolome dege paraho dambi halimu. ");
INSERT INTO hui_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Ani buwa ngolome dege mabubi kira wabuwa abene kirabaliha tale buwa iraho yalu polene gibu kira manda mandabu helalimu. Mbirale mabubi ogoni ngolo homane paraho mabu birimigo andaneha kaware dege wabu para halimu. ");
INSERT INTO hui_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Ani buwa ira agasia kira dabu ogoni iraho yule mo manda manda buwa ngolome paraho dambi howa ngelalimu. ");
INSERT INTO hui_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Ani bialu ogoni mo yalu i̱naga Balai Anda tamuha puwa lomabu delolene dabu ogoni labolabo gerela kagome tu ngago tamuha i̱naga Habo Nalolene Bi lo winigonaga Mbogoyi biago ngagonaga tagirahayagi ngelalimu. Ani bialu ko binigo domaga mbogoyinaga daliga ngagoria i̱ni ibalu tí heba holeberema. ");
INSERT INTO hui_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Horo bibahendengi egerebagi Arono ibugua lamu hale mo tiga bule ibalu ira hagua nga bilonaga mini inisenesiru lomabu delaga ngagoria delaga bulebira. ");
INSERT INTO hui_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Alendobi Arono ibugua lamu hale ngago mo tiga bule ibalu howa nde ira hagua nga bilonaga inisenesiru lomabu delaga ngagoria delaga bulebira. Tígua inisenesiru Anduane Homogo i̱nihondo lomabu delalu manibi ani delaabo halimu. ");
INSERT INTO hui_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Dabu ogoriani inisenesi ngabi maru ale tara tara lomabu nadelalimu. Ani bialu nogo bo lomabu delolenebi widi lomabu delolenebi waini iba lomabu odo delolenebi uruni bibahende damenego dabu ogoriani nadeloleore larogoni. ");
INSERT INTO hui_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Mali bibahendenaga horo mbiru mbirungi Arono ibugua i̱naga deni dabu ogoni ko nahe ngelonaga mo gini bulene nga. Ani bialu howa ibugua ko binigo domolenenaga nogo bo lomabu delaramigonaga darama hambu yalu puwa dabu ngagonaga bulumaga ne gayane handalehe maria ngago ha̱i̱ haga bulebira. Mali bibahendengi ogonidagua biaabo halimu. Ani bialu dabu ogoni loma bia howa wiabagi heneore Anduane Homogo i̱ninagaore wiaabo holebira, lalu Anduane Homogohanda Mosesehondo lene. ");
INSERT INTO hui_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Mani Anduane Homogohanda Mosese lamialu lalu, ");
INSERT INTO hui_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","Isaraele wali agalinaga mini bibahende gili bialu daga laramingi ti dagalalu katambu homolenenaga warago ko mbira tiha anda naibilo ti bayale holenaga agali bibahende hangu hangume i̱nihondo dagisi muni ngulene nga. ");
INSERT INTO hui_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Agali mini gilibu ngaru bibahendeme muni dagisi kina duria ale dege dege i̱nihondo lomabu ngulene nga. ");
INSERT INTO hui_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Agali mali pira kira (20) bolangua hene karu bibahende mini gilibu wulene nga. Ani bialu agali uruni bibahendeme i̱nihondo muni dagisi ogoni ngulene nga. ");
INSERT INTO hui_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Muniwi karu tigua dewa mia tago halu mulene nawi. Ani bialu yagibano karu tiguabi nde emene wulene nawi dege. Tigua kina duria ale dege dege tini holenenaga yolo muni biadai bulene nga. ");
INSERT INTO hui_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Muni ogonime i̱naga Balai Anda kagoha biabe bulene ngaru handayaho helonaga ngulene nga. Ani ngiragola muni uruni handalu i̱na tinaga holene handayaho holebero, lene. ");
INSERT INTO hui_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Anduane Homogohanda Mosesehondo lamialu lalu, ");
INSERT INTO hui_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","Boronosime ndisi be mbira wabialu ndisi be ogoni wulene dagia boronosime dege wabilimu. Ani buwa lomabu delaga dabu ngagola Balai Anda kagola hengene ngagoriani mo ngelowa ndisi be ogoniha iba hambu berelalimu. ");
INSERT INTO hui_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Ani bu ngagola Arono halu ibu igini karu tinaga gi geru waya bilonaga ani ngelalimu. ");
INSERT INTO hui_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Tigua i̱naga Balai Anda kogoha anda poleyaguabi lomabu delaga dabu kagoria mbirale lomabu delole poleyaguabi i̱na ti bo wa naholiyanaga tinaga gi geru waya ala bialu polene nga. ");
INSERT INTO hui_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Heneneore larogo tigua tininaga gi geru waya bialu piyagua nde ti homa nabulebira. Mana ogoni tinimebi tinaga aguaneneru mani hama polebirarumebi talialu bialu haabo holene nga, lene. ");
INSERT INTO hui_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Anduane Homogohanda Mosesehondo laabo halu lalu, ");
INSERT INTO hui_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","Mbirale tara tara bayaleore ngabiaga ngago damene bibahende miai habe. Pigane muwenaga ibane genda magi kilogarama waragaria ngago mibe. Ani bialu mbirale ngabiaga ale dege mini sinamono genda magi kilogarama tebira ngago mibe. Ani mialu gambe hale handalehe nga bayale taraore biaga ngago genda magi kilogarama tebira dege ngago mibe. ");
INSERT INTO hui_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","Ani bialu padua maru ira kasia dongoneme wabini ngabi kilogarama waragaria ngago mibe. Uruni mo mogo bu ngelowa olibe lininaga weli bedago aria mbodoli be maria odo mogo bibe. ");
INSERT INTO hui_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Ani bialu mo beregeda beregeda buwa mo bimaga hai halu mbirale mbira dongoneni wai haga mini sanda ngago ale wabibe. Anidagua bialu weli baya tara ogonime mbirale uruni i̱ninaga wiabagi hene wilo dabalu odo ba haga bulene ngelabe. ");
INSERT INTO hui_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Ani buwa weli nga biagane ogonime i̱naga Balai Anda kagoha emene odo ba hama ibaga bialu Habo Nalolene Bi lo wini ngagonaga Mbogoyi ngagobi odo ba halu ");
INSERT INTO hui_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","dagia tebolo biago heba mbirale uruniha wiaga ngarubi lamu hale irane ngagobi odo ba habe. Ani bialu ira hagua ngabilo delaga mini inisenesi lomabu delaga dabu kagobi odo ba halu bibe. ");
INSERT INTO hui_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","Ani bialu mbirale irame dai helo lomabu delaga dabu kagobi dabu ogoriani biabe biaga dabudabu ngarubi gi geru waya biaga ndisi bebi ndisi be ogoni wiagane dagia ngagobi bibahendeore weli ogonime odo ba hai habe. ");
INSERT INTO hui_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Mbirale mbirale uruni bibahende i̱ninaga wiabagi heneore wialu wali agali mbiralime ela holene nawiore. Ela hayaguabi maru ale ngaru aria mbirame ela hayaguabi mbirale bibahende uruni wiabagi hene ngaru aria dege holebira. ");
INSERT INTO hui_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Ani biai howa mani í̠na Arono halu ibu igini karu ti i̱naga biabe biaga helo loma binigo mo miaga agali dabo helalu weli ogonime ti odo wia habe. ");
INSERT INTO hui_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Ani bialu Isaraele wali agali bu karuhondo bi ogodagua lamibe. Tíguabi tínaga waneigini aguanene mani hama polebirarumebi mbirale i̱ninaga leneore wiabagi helo weli ogonime odo wia holene nga. ");
INSERT INTO hui_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Agali kago ta nabi bame odo wia holene nawi. Weli ogoni ale tíninaga ngelobi mbira wa nabilimu. Weli ogoni Anduane Homogo i̱ninaga hangu ngelo tígua mbira wabu wulene nawiore laro. ");
INSERT INTO hui_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Agali mbirame weli ogoni ale mbira wabiyaguabi agali loma binigo mo miaga ndo ta nabi karuni bame odo wiyaguabi agali ogoni ibu i̱naga wali agali karu baba mandagi nahe ibu tagira helo, lalu Anduane Homogohanda lene. ");
INSERT INTO hui_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Anduane Homogo ibugua Mosesehondo laabo halu lalu, Tígua mbirale bayaleore ngabiaga ngaru mo yuwa ira hagua ngabilo delaga mini inisenesi wabilimu. Inisenesi ogoni wabulenaga padua urunaga genda magi ogobi dege degeme karulape holebira. Padua uru mini muwebi tara ale mbirame wabini mini onigabi tara dege balawaya mbiranaga ibane mini galabanumubi inisenesi ibuni ngagobi mo wigi bilimu. ");
INSERT INTO hui_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Ani buwa uruni bibahende mo biamaga haga buwa ira hagua nga bayale bilo delaga mini inisenesi wabilimu. Ani buwa inisenesi ogoni bayale loma bia heneore wiaabo helo ibi emene mbira ogoniha ibira haga bilimu. ");
INSERT INTO hui_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Mbirale uruni be aleore helo baya hangu dambilimu. Ani buwa Balai Anda kagoha i̱ninaga deniore ngelo yu puwa Habo Nalolene Bi lo winigonaga Mbogoyi biago ngagoria wanakuihayagi ngelabe. Hagua ngabilo delaga inisenesi ogoni nagalone ngaru ale ndo ogoni i̱ninaga loma bia heneore wiaabo holebira. ");
INSERT INTO hui_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Inisenesi ogoni tíni hangunaga ogonidagua mbira wabulene nawiore larogoni. Ogonidagua wabiniru Anduane Homogo i̱ninagaore loma bia henego ngelo tíninaga mbira wabu wulene nawiore laro. ");
INSERT INTO hui_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Agali mbiragome padua ngabiaga mini sanda ngago wabulenaga mbirale biamaga haga buwa ogonidagua wabiyagua agali ogonidagua biagago ibu i̱naga wali agali baba mandagi nahelo tagira helolene nga, lalu Anduane Homogohanda lene. ");
INSERT INTO hui_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Anduane Homogohanda Mosese lamialu lalu, ");
INSERT INTO hui_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","Bi larogo hale habe. I̱na agali mbira Yuda hameigini karu aria Hua aguane Uri igini Besalele dabo heledo. ");
INSERT INTO hui_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","4","Ani helalu i̱na i̱naga Dinini kagonaga hongo ibuha karula ko. Ani heledogo ibugua ngolo siliba boronosimebi mbirale bayale tara tara ngaru wabilonaga manda bulenebi mugubebi karulape mido. ");
INSERT INTO hui_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","Ibugua ege to̱le̱ muni dewaoreme miaga alerume podaga bialu mbirale tara tara ngaru wabilobi ira ngaru podaga bialu bage tara tara ngaru podalu mbirale tara tara ngaru bulenebi ibugua bilo dabo heledo. ");
INSERT INTO hui_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Ani bialu agali mende Dana hameigini aria Ahisamaga igini Oholiaba dabalu ibugua Besalelela biabe mandagi bialu helonaga dabo heledo. Ani bialu agali marubi dabo hela dege bidogo uruni ti haru mandagi howa biabe bulene o langirugoni damenego biai helo dabo heledogoni. ");
INSERT INTO hui_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Agali uruni tigua i̱naga Balai Andaha bulene langirugoni bibahende biai holebira. Balai Andabi Habo Nalolene Bi lo winigonaga Mbogoyi larugobi Mbogoyi ogoninaga panga ngagoria wali agalime ko binigo domaga laga biagobi bibahendeore Balai Anda biagonaga mbirale wabulene ngarubi biai holebira. ");
INSERT INTO hui_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","Tigua dagia tebolo wabialu ogoriani wulene damenego bibahendebi lamu hale irane ngolome wabulenebi mbirale mbirale lamu halenaga biabe bulene ngarubi wabulene nga. Ani bialu ira hagua ngabilo delolene mini inisenesi lomabu delolene dabubi wabulene nga. ");
INSERT INTO hui_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","Ani bialu nogo mbirale irani dai helo bo lomabu delolene dabubi wabialu ogoninaga biabe bulene damenego bibahendebi wabiai holebira. Ani bialu gi geru waya bulenenaga iba hambu wulene ndisi bebi ndisi be ogoni wiagane dagiabi tigua wabulene nga. ");
INSERT INTO hui_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","Tigua Arono halu ibu igini karume loma binigo mo miaga biabe bialu howa aga karulo helo wabulene nga. ");
INSERT INTO hui_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","Ani bialu mbirale mbirale ngaru i̱ninaga wiabagi hene wilo olibe lininaga weli odo ha̱i̱ holene biago wabialu Hobane Loma Bia Hene ngagoha ira hagua ngabilo delolene mini inisenesi biagobi wabu wulebira. Ani buwa tigua mbirale uruni bibahende wabialu howa i̱na ogobi wabilimu lalu langirugonidagua biai halu wabilimu, lalu Anduane Homogohanda Mosesehondo lamini. ");
INSERT INTO hui_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Anduane Homogohanda Mosese lamialu lalu, ");
INSERT INTO hui_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","Isaraele wali agaliruhondo au labe. Sabada horo i̱naga ha̱lo holene horo ngago ai Sabada horo bibahendengi ha̱lo haabo holene nga lalu lamibe. Sabada horo ogoni áyu kamingibi mani holebiragonagabi i̱ baba tí baba manane mbira wiaabo helonaga ngelarogoni. Ani ngelarogome i̱ Anduane Homogo i̱nime tí i̱naga wali agali dabeneore kami lalu mo walia holenaga ngelaro. ");
INSERT INTO hui_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Horo ogoni Anduane Homogo i̱ninaga ngogo mitangi bialu ogoningi tí ha̱lo halimu. Horo ogoningi mbiralime biabe biyagua ogoni ibugua i̱naga mana pugualu ka manda bialu ogoni ibu homelo bo wahalimu. ");
INSERT INTO hui_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Sarere mbiranaga horo waragaru tíninaga biabe bulene ngaru bialu halimu. Ani bialu horo kanego i̱ninaga Sabada horo loma bia hene ngago manda bialu ogoningi ha̱lo holene nga. Wali agalime horo ogoningi biabe bialu hayagua uruni ti homelo bo wahai halimu. ");
INSERT INTO hui_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Isaraele wali agali tí horo ogoningi ha̱lo holenego irane habo nalolene bi lowinigo mitangi bialu tígua talialu buleore lalu lowinigo ogoniha ngagoni. ");
INSERT INTO hui_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Ani bialu i̱ni Anduane Homogo kogome dindi haribi bibahende horo waragaruni wabialu howa horo kaneni i̱ni ha̱lo berenego manda bialu ani bilimu. Ani birugonaga horo ogoni i̱ baba tí baba manane mbirale wiaabo helonaga ngelarogoni, lene. ");
INSERT INTO hui_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Ngode Datagaliwabe ibuni Mosesela Hari Sainaini howa bi lai halu ibugua ege to̱le̱ kirani ibuninaga bi leneru ibunime gilibu winigo Mosesehondo mo mini. ");
INSERT INTO hui_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Ani binigo Mosese ibu ogoni bialu heaha wali agalime handalu hearia Mosese ibu hari biagoha howa dalipe halu íbu nabi uyu hari biagoha haabo hayuane hendene. Ani hondowa tigua Arono hearia ibuwa Arono ho mabubupe howa ibuhondo lalu, Ina Iyibi dindi hemaria haru tagira ibinigo agali Mosese biago mbiraha pu tagalayadago mbira biya hendedeni. Ibu ani biyadagonigo ina haru helonaga Arono í̠na inanaga mbirale mbira bi pupu wuluma̱ya wabu ngibe, lene. ");
INSERT INTO hui_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Ani layagola Aronohanda wali agali biaruhondo lalu, Haleira ngamigo bibahende tí oneme ngagobi tí iginime ngagobi tí waneme ngagobi haleria ngolome wabinigo bibahende goloyu ngoai howa i̱hondo ngidaba, lene. ");
INSERT INTO hui_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Aronohanda ani layago hale halu wali agali bibahendeme tinaga haleira goloyu ngoai howa Aronohondo mini. ");
INSERT INTO hui_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Goloyu ngoai hayagola Arono ibugua haleira biaru irame do gedaore helowa dodo do gundulo wahalu ngolo ibuniore do ibira hayagola dindi uli wuwa odo berelowa ngolo ogonime nogo bulumaga igini ale mbira wabini. Arono ibugua ani wabu heleagola wali agalime tini aria maruhondo lalu, Isaraele wali agaliru o inanaga dama ina Iyibi dindi hemaria haru tagira ibiyago o kagomego de handadaba, lene. ");
INSERT INTO hui_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Ani buwa Arono ibugua bo lomabu miaga dabu mbira wabialu nogo bulumaga igini ale biago tiga tiga handade̱le̱ bu helowa ibugua bi dalimu lowa lalu, Ai ina Anduane Homogonaga mini yaraga halu yawi nogo bami̱ya, lene. ");
INSERT INTO hui_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Ani layagola horo mendengi egerebagiore wali agalime nogo maru bo lomabu miaga dabuni emene podowa bo delalu maru tini Anduane Homogola ho gimbu bulenaga hiruwa mandagi nole berene. Ani nalu biruwa tigua lulu iba no erelo muwa wali agali tini o biagoniha kayu yu wima pene. ");
INSERT INTO hui_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Ani bialu heago hondowa Anduane Homogohanda Mosesehondo lalu, Í̠naga wali agali Iyibi dindini howa í̠na haru tagira ibirirume ai i̱ erembira ngialu ko timbuni biyago í̠ áyu ogoni dalialu unu wali agali karia pobe. ");
INSERT INTO hui_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","I̱na ti agua bialu holeberami laga bialu i̱naga mana mirugo mo wahowa ti tinime hame ledadagua bialu kagoni. Tigua muni ngolo irame hiru gedaore howa nogo bulumaga igini ale mbira wabu helowa ogonihondo mbirale bo delalu ogoni mitangi bialu kagoni. Ti Iyibi dindi hemaria haru tagira ibiyagoni tinaga dama ogonioreme haru tagira ibiyagoni lalu ka. ");
INSERT INTO hui_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Wali agali uruni mini dogahe kane hendedogo. ");
INSERT INTO hui_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Ai áyu wali agali uruni baba keba emene ndoore kogo wali agali bu mini giambe damene uruni áyu ogo bo mburi lai holeberogo ani nabibe nalolebere. Wali agali ko damene ogoni bo hilu wahai howa Mosese í̠bi í̠ aguane maha hararubi mo timbu halu hameigini timbuni paluyu lelolebero, lalu Anduane Homogohanda lene. ");
INSERT INTO hui_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Ani layagola Mosesehanda Anduane Homogo ibunaga Ngode Datagaliwabe la deborebo bialu Ngode Datagaliwabenaga mini mo hada hole bi lene. Mosese ibugua lalu, Í̠naga wali agali uruni nde Iyibi dindini hearia gi mialu haru tagira ibirigodago í̠naga hongo gibiru walia halu ani birigodago uruni baba keba gibiore kego nde aginagabe. ");
INSERT INTO hui_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Í̠na henene halu ani bo mburi lariyagua Iyibi wali agali ti hale howa, Ae Anduane Homogohanda Isaraele wali agali haru tagira piyago hari wearu teneha howa bo hilu wahai holenaga haru penenagada, lolebira ndobe. Ani laga bulebirago keba haridagoni wahalu bu mini hadabe. Mini wiadai bialu í̠naga wali agalihondo hiriribi o bule mandabu wiridagonidagua nabi wahabe. ");
INSERT INTO hui_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Í̠naga biabe bia haga Abarahama Aisaga Yagaba ima hayaru nde mitangi bibe. Agali urunihondo habo nalolene bi lo wialu tinaga waneigini ho dame bialu daga labe nahe yakundi li hariha bu kagobi holebira larigoni. Ani bialu tinaga waneigini ti dindi i̱na mulebero lo wirigoria anda pu howa ogoriani haho wiaabo holebira lalu bi urunibi lo wigi biriruni nde manda bibe, lene. ");
INSERT INTO hui_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Mosesehanda bi aniore layagola nde Anduane Homogohanda bu mini hadalu keba howa ibunaga wali agalihondo pani mulebero layagoni nde pani nami wahalu wahene. ");
INSERT INTO hui_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Ani biya handala Mosese ibu ege to̱le̱ mbalape kira bi mana leneru kirabalini gilibuwi biago yalu wali agali hearia dai bule hari biagoha howa dalini. ");
INSERT INTO hui_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","To̱le̱ mbalape kiradagoni Ngode Datagaliwabe ibunime ogonibi mo mbalape lenego odagolaboni bi mana leneru gilibu winidagoni. ");
INSERT INTO hui_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Yosua libu haru dalialu hebirago Yosuahanda wali agali bi ladagadagabu layuago hale howa ibugua Mosesehondo lalu, Wali agali ni andabu palu hayagoniha wai bialu puromo laruane hale ko, lene. ");
INSERT INTO hui_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Ani layagola Mosesehanda lalu, O laruagoni wai buwa agali bo hana halu pialu ali iwa mambolola laradagua ndo biarua agua. Wai anda ibuwa bo paya biragola ga̱ kobala laradaguabi ndo dege biarua. Olaruagoni wali agalime iba ganaore laruagoni, lene. ");
INSERT INTO hui_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Ani lalu bialu libu hari biagoha howa dalialu Mosese ibu kaware wali agali heagoria íbu hapara howa handalu hearia nogo bulumaga igini ngolome wabini biago mo ngelowa tini luyu mabu bialu dawe halu heago hondowa Mosese ibu keba gibiore hene. Kebaore howa ege to̱le̱ mbalape kira bi mana leneru gilibuwi yayago dindini ibira hayagola poda gingilu baga bini. ");
INSERT INTO hui_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Ani bialu puwa ibugua nogo bulumaga igini ale gime wabini heyu heleago muwa irani hiru gedaore howa do iba heagola be abalu ale ti taulo wiagoha odope hene. Ani buwa iba o bagoniha odope howa mo bimaga hene. Ani bu ngelowa ogoni Isaraele wali agalihondo lalu, Ogoni tíni nole ibidaba, lowa mo nahalu ibuni handayaho hene. Ani biyagola wali agalime nde wahole ndoyagola o biagoni naore bini. ");
INSERT INTO hui_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Ani buwa ibugua Aronohondo lalu, O biridago nde gibidago wali agalime í̠hondo agi biyagola í̠na wali agali o bu karume ko timbuniore hiriribi o biyadagoni bilo mo bia haribe, lene. ");
INSERT INTO hui_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Ani layagola Aronohanda ladai bialu lalu, Í̠ i̱la keba nahabe. Wali agali o bu karuni tinime mana ko buleore lalu de daramabu kaligoni í̠ manda bidegoni. ");
INSERT INTO hui_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Tigua i̱hondo lalu, Agali Mosese mbaria ina Iyibi dindi hemaria haru tagira ibini ogoria hayagoni agoha piyabe tobane biyadago ina manda nabidamago ina haru hoari bia helonaga inanaga mbirale bi pupu wulenaga mbira wabu ngibe, laya. ");
INSERT INTO hui_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Ani layagola i̱na tihondo tinaga haleria ngolome wabini ngamiru goloyu ngoai hadaba larugola wiarume golalu i̱hondo ngigi biya. Ani ngiyagola ina haleria odaruni ira deagoha haealo baamu howa delarugola ira biagoha howa nogo bulumaga igini ale o ngagoni ibuni minalu tagira ibiya, lene. ");
INSERT INTO hui_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Mosese ibugua handalu hearia Aronohanda wali agali bame tini hame layadagua bu helo yupeho heleneyane hendene. Ani bialu tinaga waitigirume tinaga dongone handalu bame mo yobu wahabehe heleneyane hendene. ");
INSERT INTO hui_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Ani biyiyago hondowa Mosese ibu wali agali ubanda tagi bulene panga paya dugua biaga wiagoria pu howa bi dalimu ga̱ lowa lalu, Anduane Homogonaga kamigo bibahende o i̱ kogoria ibai hadaba, lene. Ani layagola hale howa Libai aria hearu bibahende ibalu Mosese heagoha ho mabubu hene. ");
INSERT INTO hui_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Ani íbu heagola ibugua Libai aria biaruhondo lalu, Isaraele wali agalinaga Anduane Homogohanda áyu tí hangu hanguhondo au laya. Tínaga ayu tibu mo yagayaga bialu puwa tí hamenebi tí damenebi tí baba handa a̱i̱ na̱i̱ padamigobi homelo bo wahalimu layago bo wahama pole pigane o harabani howa bama pialu namu tibini palimaro bidagoria bairi hole áyu ogoni badaba, laya lene. ");
INSERT INTO hui_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Ani layadagua Libai aria biarume nde hale halu bama pialu horo ogoningi Isaraele agali hangu daosini tebira (3,000) bibahende bo wahai hene. ");
INSERT INTO hui_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Ani beagola Mosesehanda Libai aria biaruhondo lalu, Horo áyu tí tíni dabo bagi hene halu maru karubi ndo tí tara halu tínaga iginibi tí hamenebi bo waharimigome Anduane Homogonaga biabe bulenehayagi tí loma binigo mo miaga hole kamigoni. Ani birimigonaga Anduane Homogohanda áyu tí biamogo bialu mo bayale holebira, lene. ");
INSERT INTO hui_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Ani bialu horo mendengi Mosesehanda wali agali biaruhondo lalu, Tígua ko hiriribiore i̱na bulile wiago birimigoni. Ani birimigonigo nde abule i̱na hari o kagoha lone iraga halu Anduane Homogo karia porogo. Anduane Homogo ibugua tígua ko birimigoni domo waharo loloba badago í̠na domarebe lalu haleho porogo, lene. ");
INSERT INTO hui_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Ani lalu bialu Mosese ibuni lone hari biagoha iraga halu puwa Anduane Homogohondo lalu, Wali agali o biarume ko hiriribiore i̱na bulile wiago biya. Tigua muni ngolome nogo bulumaga igini ale mbira tini gime wabuwa tinaga dama ogoni lowa ogonihondo bi pupu wialu heneya. ");
INSERT INTO hui_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Ani bialu heneyago ainde harugo agua bule ndodago tinaga ko o biyadagoni domo wahabe. Ai domo wa naholeyagua nde wahalu i̱ninaga mini ebere í̠naga mbugani gilibu wirigoni nde í̠naga waneigini marunaga mini ngelalu i̱naga minigo wahalu domo wahabe laro, lene. ");
INSERT INTO hui_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Mosesehanda ani layagola Anduane Homogohanda ladai bialu lalu, I̱hondo ko biyadarunaga minigo i̱naga mbugani nawilo domo waholebero. ");
INSERT INTO hui_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Ani buleberogo ai í̠ áyu ogoni pialu wali agali haru halu dindi mbaria nga lalu i̱na langirugoria haru pole áyu ogoni pu. I̱naga dahuliyalime í̠ biamogo bialu í̠ mo tiga bule holebira. O larogoniore manda biaabo habe. Ai wali agalime ko biya ebere larigonaga ko biaga uruni tigua ko biyagonaga pani mulene horo ibirangi pani mulebero, lene. ");
INSERT INTO hui_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Ani layadagua wali agalime Aronohondo bia bia degeni nogo bulumaga igini ale biago wabilo mo bia hayagonaga Anduane Homogohanda wali agali biaru pani mialu warago tara mbira ti heagoria ibilene. ");
INSERT INTO hui_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Anduane Homogohanda Mosesehondo lalu, Wali agali Iyibi dindi hearia haru tagira ibirigoni o bu kagonigo uruni haru halu dindi o kamigoni wahalu pudaba. Pialu dindi mbira i̱na Abarahama Aisaga Yagaba imaruhondobi tinaga waneigini aguanene maha hama poraruhondobi karulelo mulebero lo wirugo dindi ogoriani haru pole pobe. ");
INSERT INTO hui_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Dahuliyali mbira tí hariga walia hama mandagi pilimulonaga pu lagua. Ani bialu Kenanaliru Amoroaliru Hidialiru Peresealiru Hibialiru Yabusualiru uruni bibahende i̱na bo batagi hai holeberogo dindi landaneha ngaria tí karuloleberami. ");
INSERT INTO hui_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Ani buleberogo tí dindi ibane bere tomo anda holene bayaoreha hole poramigoni. Ai i̱na dege tí heba naibulebero irane tí i̱naga bi laga berogoni ogoale laralo manda bule ndo ora luluanda hope howa tí miniha ibira alego bia dege dindi halu hagayago. Ani bialu kamiria i̱na ti hariga obeneni howa bo wahai hoa biaganego i̱ naibulebero laya lalu wali agali lamibe, lene. Mosesehanda puwa wali agali lamibe layadagua lamini. ");
INSERT INTO hui_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Aniore layago hale howa wali agali biarume mini burugu lalu gendaore ho hene. Genda ho howa ti tinginini yári biagane damene dongone ganuni wule bu heagoni bibahende golo ngelai howa tini dara howa mini hulula bu hene. ");
INSERT INTO hui_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Mosesehanda Anduane Homogonaga bi agua laya lalu, Wali agali tí luluanda i̱na bi larogo ogoale lara lole ndo tini bua bira ale bupe haga bialu kamigoni. I̱ni tí heba ibiruyagua hariga lu pu lu nabi howa nai hariga obeneni dege howa tígua tínaga mana biagane egene wini biago bialu kamiria tí bibahendeore bo hilu wahai harogonidago i̱ naibagua. Ani biaguago tínaga tinginini yári tara tara karu ledamigoni damenego bibahende golo ngelai halimu. Ani bidamigola i̱na tíhondo agi bibehedabe hondoliya, Anduane Homogo ani lalu lamibe laya, lene. ");
INSERT INTO hui_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Ani layagola nde Isaraele wali agalime Hari Sainai yu wahalu tagira pialu peadangi howa tinaga tinginini yári biagane damene bibahende nabi wahai hene. ");
INSERT INTO hui_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Isaraele wali agalime dindi mbirani puwa palue anda bigi bialu howa Mosese ibugua nde Balai Anda mbira wali agali ta nabime anda napiaga mbira haluni amura bu helaga biaga wini. Dindi mbiragoha pole howa gialo yalu pialu anda pu paligi beramigoria anda ogoni ibu hangu haluni bu helaga biaga wini. Anda ogoni mini Anduane Homogo Ina Heba Ka manda bulenenaga anda laga wini. Ani biaga winigo wali agali ti mbiraligo ibu Anduane Homogonaga hame hale holebi mbirale ogo buabe nabuabe lalu Anduane Homogo hale hole manda biyagua Anda ogoniha howa haleho piaga hene. ");
INSERT INTO hui_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Mosese ibu Balai Anda odagoniha pugu biragola wali agalime tinaga anda harabani howa Mosese porago baya hangu deme handayaho wialu anda odagoni tamuha anda pora handala wahaga biaga hene. ");
INSERT INTO hui_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Ani bialu Mosese ibu Anda biago tamuha anda pu kagola hari beraliba timbuni mberane biago dalipe haga wini. Dalipe howa Balai Anda biago harabani gerelapeho ngagola Anduane Homogohanda hari beraliba timbuni mberane biagoniha howa Mosesehondo bi lamigi biaga wini. ");
INSERT INTO hui_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Wali agalime handalu karia beraliba mberane ogoni Balai Andadago panga harabani wiape kago hondowa ti bulu paliaga wini. ");
INSERT INTO hui_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Anda odagoniha howa Anduane Homogohanda Mosesela bi la de̱le̱ bialu agali yangonela mini hana hagabu howa bi lo haralidagua lo haga biaga wini. Anduane Homogola bi ani lo halu Mosese ibu wali agali bu karia dai bigi biaga wini. Mosese ibugua bi lo pialu dai bigi bilo lowa igiri daliahe mbira Nunu igini Yosua hayago ibugua Mosese biamogo bule Mosese geha ibagabu howa Balai Anda biago tamuha haga hene. ");
INSERT INTO hui_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Mosesehanda Anduane Homogohondo lalu, Í̠na i̱hondo wali agali o bu karuni haru halu dindi o biagoria haru anda pobe larigonigo i̱la polobayago mbirali ogola polebere nalarigoni. Í̠na i̱ ogobiore ka lo manda bialu i̱hondo turuho ko larigoni. ");
INSERT INTO hui_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Ani larigo ai í̠na henene halu i̱hondo turuho keyagua o Anduane Homogo í̠na bule manda bu wiaruago ogo ale bule manda bu ngo lalu i̱ langi. Langerego hale howa i̱na í̠ ani bule manda bu wiridago hangu bialu í̠ mo turu haabo holiya langi, lene. Ani bialu hameigini áyu karu í̠ninaga wali agaliore helo dabarigoni í̠ni manda bibe, lene. ");
INSERT INTO hui_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Ani layagola Anduane Homogohanda ladai bialu lalu, I̱ni í̠ heba ibalu í̠na waitigi karu baba wai bigi beregola wayali habelo biamogo bigi bulebero, lene. ");
INSERT INTO hui_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Ani layagola Mosesehanda ladai bialu lalu, Í̠ ina heba namali̱yayagua o ina dindi o kamago wahalu nape ogoria holeberamago ina pudaba nalabe, lene. ");
INSERT INTO hui_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Í̠ni ina heba naibiriyagua wali agali bu karume manda bialu karia Anduane Homogo í̠ wali agali ti bababi Moseselabi turuho ndo harua manda bulebira. Ani bialu í̠ni ina heba ibagabu mandagi harimayagua ogonime ina wali agali maru karubi ndo ina mo tara holebira, lene. ");
INSERT INTO hui_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Ani layagola Anduane Homogohanda Mosesehondo lalu, I̱na í̠ ogobiore ke lo manda bialu í̠hondo turuho kogodago í̠na o larigonidaguaore bulebero, lene. ");
INSERT INTO hui_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Ani layagola Mosesehanda Anduane Homogohondo hale halu lalu, Í̠ni íbu ko lalu wá holene de mborerebiore handaya habe nahe walia hagayago wá holene de mborerebi o biagoni dege halu mbira hondoliya waliaha, lene. ");
INSERT INTO hui_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Ani layagola Anduane Homogohanda ladai bialu lalu, I̱naga wá holene í̠ handabelo í̠ deni pu bolangua helalu i̱naga mini wali agalime nalaga tua mbaria wia do hene ngogo áyu mini tua ogoni hale habelo í̠ deni howa loliya, lene. I̱ Anduane Homogo kogo darabi gubalinibi hoa birago haga kogoni. ");
INSERT INTO hui_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Ani buleberogo áyu í̠na i̱naga dengui handabelo walia naholebero. Irane mbirali i̱naga dengui handaya harago homaganego í̠ walia haruyagua í̠ homoleberegodago walia naholebero, lene. ");
INSERT INTO hui_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","I̱naga dengui walia naholeberogo í̠ heyu holene karulape mbira o i̱ kogohayagi to̱le̱ni heyu holene ngago ogoriani hole ibabe. ");
INSERT INTO hui_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Í̠ ani heyu kegola i̱naga wá holene de mborerebi biago bolangua haragola i̱na í̠ minu muwa ege ogoniha kaba mbira ngagoha í̠ minu berelowa i̱naga gime í̠ yi holebero. I̱ bolangua halu poleberogo i̱ porogo í̠ nahandabelonaga ani bulebero. ");
INSERT INTO hui_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Ani buwa i̱ bolangua halu puwa i̱naga gi yamerogola í̠na i̱naga dengui nahende erembira dege de hondolebere, lene. ");
INSERT INTO hui_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Ani lowa Anduane Homogohanda Mosesehondo lalu, Ege to̱le̱ mbalape kira abale biagobi labolabo kambulo yalu ibabe. Kambulo yalu eberegola bi mana ala i̱na to̱le̱ mbalape kira biagoria gilibu wiwaria í̠na minu podarigoni ai lone gilibu aribia holiya to̱le̱ mbalape kira kambulo pobe. ");
INSERT INTO hui_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","To̱le̱ mbalape kira ogoni manda mandabu yalu egerebagiore Hari Sainai iraga halu ibabe. I̱ hari neneoregoria haguago lola habiya egerebagiore ibabe larogoni. ");
INSERT INTO hui_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Í̠ kirali ibuleni í̠ni hangu ibabe. Wali agali mbirali mbira hari ogoniha hapara howabi holani handabe. Nogo sibi bulumagabi mbira hari ogoni teneha tani nalu holani wara peladaba labe, lene. ");
INSERT INTO hui_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Ani laya handala Mosese ibuni hale halu puwa ege to̱le̱ mbalape kira kambulo manda mandabu ngelene. Horo mendengi egerebagiore to̱le̱ mbalape kira biagoni yalu Anduane Homogohanda ibabe layadagua Hari Sainai yalu iraga hene. ");
INSERT INTO hui_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Yalu iragaho heagola Anduane Homogo ibuni hari beralibaha howa dalialu Mosese heagoria mandagi libu haru hene. Howa ibugua ibunaga mini loma bini lalu, Anduane Homogo i̱ Henego Hole Ko, lamini. ");
INSERT INTO hui_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Ani lamuwa Anduane Homogo ibugua Mosese denguini bolangua halu pua̱i̱ howa bi ladaga howa lalu, I̱ Anduane Homogo dara holenebi biamogo bulenebi to̱lo tagihe keba ala awane nahaga gubalini holenebi mini bilinahe holenebi deremolahebi gibi Ngode Datagaliwabe kogoni, lene. ");
INSERT INTO hui_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","I̱na bule lo winiru heneneore bigi biruria hendene wali agali dabane daosini au lolebe tobaheme handaga bialu homaga bini nga. I̱na bule lo wiruru lo beregeda nabi dabane dewa halu homayaguabi lo ngogo biaore biaga kogoni. Ani bialu wali agali tigua mana ko haragobi hale ko tara tara bigi biragobi domaga i̱ kogoni. Ani domalu dege ai aba ai̱yalame ko biragonaga pani ti waneiginibi aguanebi maha hama poraruhondo mialu daba tebone mane daba hama poraruhondobi pani mia dege bialu haga ko, lene. ");
INSERT INTO hui_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Ani layago hale howa Mosese ibu dindini bulu palialu Anduane Homogo mitangi bialu ibu mo dunini howa lotu lalu hene. ");
INSERT INTO hui_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Anduane Homogo mitangi halu ibugua lalu, Anduane Homogo-o í̠na henemanenaga i̱hondo turuho keyagua o ina haruore mali̱ya ibulebere larogoni. Isaraele wali agali uruni minila haru ndo luluanda haradagua hope howa laragoni ogo ale lara lole ndo kagoni í̠ manda bidegoni. Nde abule harugo í̠naga wali agalime ko birimaru domo wahalu í̠ni buha ina yamibe, lene. ");
INSERT INTO hui_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Ani layagola nde Anduane Homogohanda Mosesehondo lalu, Ainde áyu i̱na Isaraele wali agali baba habo nalolene bi lo wulebero. I̱na tí bibahendenaga deni biabe taraoreru wali agali dindi bibahendeha karume de nahendene ale i̱na Isaraele wali agali tíore de hondole bigi bulebero. Wali agali bibahende i̱na mbirale gibioreru i̱ Anduane Homogo i̱na tínaga bia haga beroru tí de handalu duru loleberami. ");
INSERT INTO hui_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Ani buleberogo i̱naga mana áyu lo ngeroruni baya hangu handalu bi o ledorunidagua hale halu biai halimu. I̱na hameigini Amoroaliru Kenanaliru Hidialiru Peresealiru Hibialiru Yabusualiru bibahende bo batagi halu balu puabo helarogola dindi bame landaneha ngaria tígua karulama hama anda pugu buleberami. ");
INSERT INTO hui_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Ani bigi buleberamigo tí dindi gahenge mbira anda poramigoha wali agali uruniha karu baba nenege hinu ndi bu holene mbira manda bulamini. Uruni baba nenege hinu tí ndi bu harimiyagua ogoni gono bu hinaragola gundulo mialu pobe tobahe mbaria ogoniha do wuleberamigo ti baba haru hinu mandagi nahalimu. ");
INSERT INTO hui_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Mandagi nahe ti hobamu howa wali agali uruni tinaga mbirale gime wabiniruhondo mbirale bo delo miaga dabu bidaru gelo labailo bagabu wahalimu. Tinaga to̱le̱ ira giambe waradagua berelama pedaruni ela nahaga lowa hogaralebu haga to̱le̱ uruni bibahende podobagabu langu wahai halu mbira wulani handalimu. Ani bialu tinaga dama wali Asera dengui handaradagua bule lowa mbirale irame wabu wu hama pedaru bibahende ayume dibu gingirulo bagabu wahai halimu, lene. ");
INSERT INTO hui_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","I̱ Anduane Homogo tínaga kogonigo i̱ hangu mitangi bialu mo dunini howa lotu lalimu. Ani bialu tígua mbirale gime wabini ngaru mbirago ogonihondo bu pupu nawilimu. Ani nawilimu larogo irane mbiralime i̱la í̠ abi i̱ abi laba lole manda birago bilo i̱ nde handayaho nahaga ogoni birago bo ereba haga kogonaga laro. ");
INSERT INTO hui_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Ani biaga kogo wali agali dindi uruniha karu baba ndi bu mbirale doborobo bu nahalimu. Ani nahalimu larogo irane tigua dama tara tarahondo bi pupu wialu nogo egaru loma bialu urunihondo bo minigo dawawa tí nami̱ya ibidaba lolebira. Ani laragola nde tí wahalu pobe tobahe nolene kaware wulebirago ani nenege hinu nahalimu larogoni. ");
INSERT INTO hui_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Ani nenege hinu harimiyagua tínaga iginime wandari dindi tara uruniha bedaru dabu bu karia wali urunime haru gili lenego pialu i̱ erembira ngialu ti one urunime dama tara tarahondo bi pupu wiradadagua wima yupe holigo wali agali uruni heba mandagi huru hinu nahalimu larogoni, lene. ");
INSERT INTO hui_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Mbirale tara tara aeaneme wabuwa tinaga dama lowa urunihondo bi pupu nawilimu. ");
INSERT INTO hui_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Horo mbira Mberedi Yidi Nahe Hirinigo mo yu ngoai howa nagane horo biagoni embeda nahe horo ogoni tagira ibirangi naabo halimu. Ani nalimu lalu i̱na ala pongo bo ngirudagua ege mini Abibi haragola ege ogoninaga horo karuni mberedi yidi nahe ogoni nalu halimu larugoni. Ani nalimu larugo irane tí Iyibi dindi howa ege ogoningi tagira ibirimigo manda buwanaga nalimu larugoni. ");
INSERT INTO hui_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Tí igini wahene hono weramigo bibahende i̱naga dege dege holebira. Ani bialu tínaga nogo dameneru tanabi bibahendeme igini pigane wangabe wirago dameneru bibahende i̱naga dege dege holebira. ");
INSERT INTO hui_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Ani bulene wulebirago ai nogo dongi igini pigane winigo i̱naga heleneyagua nde nogo dongi ogoni wahalu í̠ni holeyagua i̱naga nogo sibi igini mbira kango hela aribia holene nga. Ai kango nangibeheyagua wahalu nogo dongi ogoni ibuninaga ma minu taga lolene nga. Ani bialu igini wahene damenego aba ai̱ya tini holeyagua i̱hondo maru ale lomabu ngigi bulene nga. Mbirali i̱hondo mbirale mbira ngule giha nayi bame ibirimiyagua i̱ denguini bilingi bolanguabu holene nawi. ");
INSERT INTO hui_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Horo waragaru tíninaga biabe bilimulo wiyagoni. Ai horo kanegoria biabe mbira nabilimu. Tomo hongole dindi aluene ngangibi tomo bu wulene ngangibi nabilimuore larogoni. ");
INSERT INTO hui_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Tomo bu wialu howa widi lini hini dedagola Mabuha Widi Lini Pigane Denegonaga mana pigane wirimadagua bilimu. Ani bialu dagare bulene tu harangi Anda Nemandaha Palu Holene Hororu bu henego mitangi bialu mana pigane wirimigonidagua ira lini pigane hini dedago daramingi ani bilimu. ");
INSERT INTO hui_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Ani bialu Isaraele agali damenego bibahendeme mali mbira mbirani halu teboore Anduane Homogo i̱niore Isaraele wali agalinaga Ngode Datagaliwabe kogo i̱ mitangi bialu mo dunini howa lotu lole ibugu bulene nga. ");
INSERT INTO hui_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","I̱na tínaga waitigiru tí hariga polenegoha palipai haga bidaru bo batagi haga bialu balu pelarogola dindi dabulu ngaria tí karulalu ho yanga laga bima ibugu buleberami. Ani bigi berogola wali agali maru karume tí baba wai bialu tínaga dindi karulolene manda nabulebira. Tí bibahende tínaga mini tomo halu tebo nolene larimagoha puwa nalu kamigohabi mbirame tínaga dindi karulalu tí bo anda naibulebira. ");
INSERT INTO hui_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Tígua i̱hondo nogo mbira bo ngialu dela howa mberedi yidi heba mo biamaga henego i̱hondo nangilimu. Ani bialu Bolangua Halu Penego Horonaga Tomo mitangi buwa nogo bo dawenego aria mbira egerebagi nolenaga podo wia nabilimu. ");
INSERT INTO hui_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Ani bialu mali bibahendengi tí mabuni tomo hangaramigo hini damenego Anduane Homogonaga andaha bu yu íbu wilimu. Tígua nogo sibi igini meme iginiyaguabi mbirago ibu angibuni andu ibane beha hambu yu delaramigoha delamaga nahalimu, lene. ");
INSERT INTO hui_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Ani lamigi buwa Anduane Homogohanda Mosesehondo lalu, Bi o laroruni baya hanguore bebani gilibu wibe. Irane bi o laga berogoriani mo tene howa Mosese í̠labi Isaraele wali agali bibahende bababi i̱na habo nalolene bi lo wigi berogoni, lene. ");
INSERT INTO hui_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Mosese ibu Anduane Homogohanda bi lamiyago hale halu tomobi ibabi mbira naneore uyu hari biagoniha Anduane Homogola heane dege horo pira maria mbi pira maria (40) lowa pene. Ani bialu Anduane Homogohanda ege to̱le̱ mbalape kira biagoria Habo Nalolene Bi gilibu wini. Bi gilibu winidaruni Ngode Datagaliwabe Bi Mana Pira gilibu wini. ");
INSERT INTO hui_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Mosese ibu howa Bi Mana Pira biago gilibu yalu Hari Sainai biagoha howa daliyagola nde ibu Anduane Homogo heba bi lalu hene biagome ibunaga dengui biagoni wá haamehe huailo yalu dalini. Ibunaga dengui wá haame howa huailo yalu daliyadagoni ibuni de nahende manda nabi dalini. ");
INSERT INTO hui_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Mosese ibuni de nahende manda nabi ani hearia Arono halu Isaraele wali agali ti bibahendeme Mosese ibiyago handalu hemiria ibunaga denguiha wá haameho huailo yalu ibiyago hondowa ti bibahendeme Mosese heagoria hapara holene giho hagahaga bini. ");
INSERT INTO hui_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Ti ani bu hemiria Mosesehanda wali agali biaru olayagola Aronobi Isaraele wali agali haru haga biarubi ti bibahende Mosese ibu hearia ibiyagola ibugua ti baba bi lalu hene. ");
INSERT INTO hui_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Agali uruni baba bi lalu hemiria Isaraele wali agali bibahende íbu ngoai howa Mosese ho mabubupe hene. Ani biyagola Mosese ibugua tihondo Anduane Homogohanda Hari Sainai howa mana damene ibuhondo lamiyaruni Isaraele wali agali biaruhondo lamiaiore hene. ");
INSERT INTO hui_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Ani lamiai howa Mosese ibu ibunaga dengui agame buyi hene. ");
INSERT INTO hui_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Ani bialu Mosese ibu Balai Anda Anduane Homogo Isaraele wali agali ti heba ka manda bule bu helene biagoha Anduane Homogo heba bi lole anda pugu bialu howa aga ibunaga dengui buyi hayagoni golo wigi bini. Ani buwa Anduane Homogo heba bi lalu howa tagira ibugu bialu Isaraele wali agalihondo Anduane Homogohanda lamibe layada ale bibahendeore lamiai haga bini. ");
INSERT INTO hui_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Ani bialu Isaraele wali agali tigua handaga bialu hearia Mosese ibu Anda biagoha howa Anduane Homogo heba bi lalu hene tagira ibugu biyagola ibunaga dengui biago wá haame howa huailo yu tagira ibugu buwa tihondo bi lamigi biyaria hendene. Mosesehanda wali agalihondo bi lamiai howa aga biagome ibunaga dengui lone yiho haga bini. Ibunaga dengui ani yiho haabo howa Anduane Homogola bi lole anda biagoha anda pugu bialu howa golo wigi biaga hene. ");
INSERT INTO hui_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Mosesehanda Isaraele wali agali bibahende íbu ngoai hadaba lowa tihondo lamialu lalu, Anduane Homogohanda bi mana tígua taluwa bialu halimu layago ogo, ");
INSERT INTO hui_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Tígua horo waragaru biabe tara tara ngaru bialu halimu. Horo kanego Anduane Homogo i̱ kogonaga horo loma bia hene ngago ogoningi biabe damene bibahende wahai howa ha̱lo holene nga. Wali agaliyaguabi mbiralime horo kaneni biabe mbira bialu kane handarimiyagua tígua ibu homelo bo wahalimu. ");
INSERT INTO hui_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Biabe emene bame tíninaga andagani ira hangubi bo delolenego ogoni biabe degego ha̱lo holene horo ogoningi biabe damenego nabuleore larogoni laya, lalu Mosesehanda lene. ");
INSERT INTO hui_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Mani Mosesehanda Isaraele wali agali bu hearuhondo lamialu lalu, Anduane Homogohanda tígua ogodagua bilimu laya. ");
INSERT INTO hui_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Tígua loma maru yalu ibuwa ngilimu, laya. Wali agali bibahendeme lomabu mulene manda bu kamiyagua nde ngolobi silibabi boronosibi yalu ibuwa ibuhondo mialu ");
INSERT INTO hui_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","labolabo bayaleorebi pu sibi irinime payini mindibiha guyini hari mindini handalehe ngarubi tagalitaya aleha guyini ngarubi daramabiha guyini ngarubi labolabo meme irinime wabini ngarubi milimu. ");
INSERT INTO hui_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","Nogo sibi wangabenaga dongone daramabiha guyini ngarubi yalu ibalimu. Wena timbuni iba tia alenaga dongonebi ira agasia kambulene marubi yalu ibalu ");
INSERT INTO hui_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","lamu halenaga olibe lini welibi mbirale wiabagi holenaga odo ha̱i̱ holene weli wabulene padua alebi ira hagua ngabilo delaga inisenesi tarabi wabulene paduabi yalu ibugu bilimu. ");
INSERT INTO hui_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","Ege to̱le̱ bayale kanelianaru tara tararubi loma binigo mo miaga agali haguane timbuni kagonaga aga mini ebodi hela dambi bulenebi aga emene galuhombeni karulaga biagoria helaga bulenebi mo yalu ibalimu, lene. ");
INSERT INTO hui_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Mosesehanda laabo halu lalu, Agali bu kamiru aria maru biabe tara tara biaga mugubeyi kamiru Anduane Homogohanda bilimu lalu langiyago bibahende bule ibai halimu. ");
INSERT INTO hui_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Balai Anda bialu daligani dambi holene biagobi wabilimu. Anda hongo helonaga daba haga bulene wangobi biarubi anda háinaga ira generubi anda hái libu banga bulenaga irabi generubi gene helolene mbogoyirubi wabialu helolene nga. ");
INSERT INTO hui_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","Tigua Habo Nalolene Bi lo winigonaga Mbogoyi biagobi wabialu Mbogoyi ogoni iraho yulenenaga ira kirabi dibu wabialu wali agalime ko binigo domo waholenenaga Mbogoyi ogoninaga panga ngolome wabulene nga. Tígua Habo Nalolene Bi lo winigonaga Mbogoyi biago mo ge holenaga labolabo gerela holene wabulene nga. ");
INSERT INTO hui_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","Ani bialu dagia tebolobi dagia ogoni iraho yulenenaga ira kirabi biabe ogoninaga bulene mbirale marubi wabulene nga. Ani bialu mberedi hiruwa Ngode Datagaliwabenaga deni dagia tebolo o biagoriani hiru wilimu. ");
INSERT INTO hui_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","Lamu halenaga wiagane irane helolenebi ogoninaga biabe bulene mbirale marubi wabulene nga. Lamu halerubi uruninaga welibi wabulene nga. ");
INSERT INTO hui_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","Ira hagua ngabilo delaga mini inisenesi lomabu delolene dabubi wabulene nga. Ani bialu dabu ogoni iraho yulene ira kirabi manda mandabu ngelolene nga. Tigua mbirale Anduane Homogonagaore wiabagi helonaga weli odo ha̱i̱ holenebi inisenesi bayaleore nga tarabi wabulene nga. Ani bialu Balai Anda biagonaga panga harabani labolabo gerela ho wule wabulene nga. ");
INSERT INTO hui_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","Mbirale bo lomabu delolenenaga dabu mbira bu helalu mbirale ira delolene dagia diri dewawi dabu ogoninaga gene maria kagoria helole boronosime dege wabilimu. Ani wabialu lomabu delaga dabu ogoriani biabe bulene alego damene wabu wiai holene nga. Ani bialu dabu ogoni iraho yule ira kira manda manda bu ngelalu bulene nga. Gi geru waya bulenenaga iba hambu wulene ndisi be mbira wabialu be ogoni wulene dagiabi bia holene nga. ");
INSERT INTO hui_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","Balai Anda kago pabe bu yanda hole labolabobi gerela holene wabialu ogoninaga generubi gene helolene mbogoyirubi pabe harabanaga panga labolabobi wabulene nga. ");
INSERT INTO hui_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","Balai Anda dangini yulupe kagonagabi Balai Anda pabe bu mabu bu kagonagabi dindini dariba holene pu hongohe heba gelo holene biarubi uruni bibahende wabulene nga. ");
INSERT INTO hui_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","Ani buwa Arono halu ibu iginirunaga aga bayale tini Balai Anda biagonaga tamu Hobane Loma Bia Hene biagoha biabe bialu howa mo karulo helobi wabulene nga, lalu Mosesehanda Isaraele wali agaliruhondo lamini. ");
INSERT INTO hui_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Ani laya handala Isaraele wali agali ti Mosese helalu tini andaga pugu pugu bini. ");
INSERT INTO hui_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Mosesehanda bi layagome wali agalinaga gubaliniha nogoba hayagola tigua ogonidagua bule lo manda bialu pugu pugu bini. Wali agali biabe bulene mugube tara tarayiru íbu ngoai hene. Ani bialu tigua Anduane Homogonaga mbirale tara tararu yalu ibunaga Balai Anda biago bilonaga mule yalu íbu ngoai haga bini. Tigua Anduane Homogo mitangi bialu lotu lolenenagabi Balai Anda bulenenagabi loma binigo mo miaga agalinaga aga wabulenebi mo yalu ibini. ");
INSERT INTO hui_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Wali agali tinime yalu ibulene hame leadagua yári tara tara biniru haleiraru gi magibi ma gaguabi yári tara tara ngolome wabinirubi yalu íbu dege bini. Yalu ibalu uruni bibahende Anduane Homogohondo lomabu mule yalu ibugu bini. ");
INSERT INTO hui_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Ani bialu wali agali marume labolabo bayale wiaru mo yu ibalu nogo sibi irinime pu payini mindibiha guyini hari mindini handalehe wiarubi tagalitaya aleha guyini wiarubi daramabiha guyini wiarubi bibahende wabiniru mo yalu ibugu bini. Ani bialu meme irinime labolabo wabinibi nogo sibi wangabenaga dongone daramabiha guyini wiarubi wena timbuni iba tia alenaga dongonebi bibahende mo yu ngoai hene. ");
INSERT INTO hui_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Wali agali maru tigua siliba boronosiru wiago mo yalu ibugu bialu Anduane Homogohondo lomabu migi bini. Agali maru ira agasia wu hearu tigua ira uruni Anduane Homogonaga Balai Anda biago bule mo yalu ibugu bini. ");
INSERT INTO hui_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Wali pu payaga berearume pu payini bayale wiarubi nogo sibi irinime pu payini mindibiha guyini hari mindini handalehe wiarubi tagalitaya aleha guyini wiarubi daramabiha guyini wiarubi uruni bibahende mo yalu ibini. ");
INSERT INTO hui_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Wali maru nogo meme irinime pu payaga mugube berearu tigua nogo meme irinime pu payiniru yalu ibini. ");
INSERT INTO hui_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Ani bialu agali haguane hearu tigua ege to̱le̱ mini kanelianabi maru baya tara tara wiaru uruni loma binigo mo miaga agali haguane timbuni heagonaga aga mini ebodibi aga emene mende galuhombeni karulaga biagoria pongobu helaga bulebi mo yalu ibugu bini. ");
INSERT INTO hui_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Ani buwa tigua padua tara tarabi welibi urunime lamu biaruha berelolebi mbirale Anduane Homogonaga wiabagi holenaga weli wabulebi mbirale ngabi sanda ale ira hagua nga biaga inisenesi wabulebi mo yalu ibugu bini. ");
INSERT INTO hui_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Isaraele wali agali tigua mbirale wiaru bibahende Anduane Homogohondo lomabu mule hame leadagua mo yalu Anduane Homogohanda ogoale bibe lalu Mosesehondo lamiyago bilo mo yu ibai hene. ");
INSERT INTO hui_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Mosesehanda Isaraele wali agali lamialu lalu, Anduane Homogohanda Uri igini Besalele ibu Yuda hameigini aria Hua aguane heago dabaya. ");
INSERT INTO hui_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Ibugua biabe bayale tara tara ngaru biai holene mugubeyi Anduane Homogohanda ibunaga Dinini Besalele ibuha helalu biabe uruni bilonaga mini manda bogaru bulenebi ibuhondo miya. ");
INSERT INTO hui_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","Ibugua ngolomebi silibamebi boronosimebi giligili tara tara bulene mugube ibuhondo miya. ");
INSERT INTO hui_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","Ani bialu ege to̱le̱me mbirale ngaru bule bage tara tara podalu ira dibu pelowa bage tara tarabi bialu yári tara tara marubi bilo ibuhondo mugube miya. ");
INSERT INTO hui_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Anduane Homogohanda manda tara tarabi agali Besalelebi Dana hameigini aria Ahisamaga igini Oholiababi libuhondo miya. Manda uruni yu howa libugua agali maru karubi biabe uruni bilo biawai holene mugube miya. ");
INSERT INTO hui_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Anduane Homogohanda agali ogoni labohondo ege to̱le̱ ngaru podalu yári tara tara bilobi giligili tara tara mo yáribia halu aga bayale tara tararu wabilobi nogo sibi irinime pu payini mindibiha guyini hari mindini handalehe ngarumebi tagalitaya aleha guyini ngarumebi daramabiha guyini ngarumebi labolaboni yári tara tara wabu helolenebi manda biai ka. Libugua giligili bulene tara tara libunime hameleda ale wabu helalu biabe uruni biai habeheore kagoni, lalu Mosesehanda lene. ");
INSERT INTO hui_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Mosese ibugua laabo halu lalu, Anduane Homogohanda Besalele Oholiabala libuhondobi agali maru hearuhondobi mandabi mugube bayale tara tarabi miyagome tigua biabe tara tara ngaru bulene manda biai howa Anduane Homogonaga Balai Anda biago bulene nga. Ani bibehe howa agali uruni tigua Anduane Homogo ibugua ogoale bilimu layadaguaore biai holene nga, lene. ");
INSERT INTO hui_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Mani howa Mosesehanda Besalelebi Oholiababi agali maru Anduane Homogohanda manda bulene mini biarubi olalu íbu ngoai hadaba lene. Ani layagola agali biabe buahe hearu íbu ngoai hayagola Mosesehanda tihondo lalu, Ai biabe bidaba, lene. ");
INSERT INTO hui_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Balai Anda ogoni bilonaga Mosese ibugua Isaraele wali agalime mbirale yu ibiyaruni bibahende yu howa tigua biabe bilo tihondo mo mini. Ani bialu heagola egerebagi bibahendengi Isaraele wali agali tigua mbirale marubi Anduane Homogohondo lomabu mule hamelo hearu yalu ibugu biaabo hene. ");
INSERT INTO hui_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Agali Balai Anda bialu hayaru tigua wali agalime mbirale dewaore yalu ibiyago hondowa tigua biabe bialu hayago bialaho ngelalu ");
INSERT INTO hui_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","Mosese hearia puwa tigua Mosesehondo lamialu lalu, Wali agalime mbirale dewaore yu ibaabo haragoni. Anduane Homogohanda biabe bilimu layago bulene mbirale karulapeore wiatago ho ngamago ai maru dewaore bame bu paya bulubada, lene. ");
INSERT INTO hui_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Ani layagola Mosesehanda wali agali bibahende tinaga balai anda bu hearuha bi lo pelalu lalu, Ai wali agalime Anduane Homogonaga Balai Anda bulenenaga mbirale biaru lone yalu naibalimu, lalu lamiyagola tigua lone yalu naibi wahene. ");
INSERT INTO hui_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Anduane Homogonaga Balai Anda bule wali agalime mbirale yalu ibiyaru dewaore anda bulene damenego bu karula pialu huniane maru ibira hene. ");
INSERT INTO hui_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Agali biabe biaga mugubeyi hearu tigua Anduane Homogonaga Balai Anda bialu hene. Tigua labolabo bayaleore timbuniru pirame bialu hene. Tigua labolabo bayaleore uruni muwa pu nogo sibi irinime payini maru mindibiha guyini hari mindini handaleherubi maru tagalitaya aleha guyinirubi maru daramabiha guyinirubi urunime labolabo uruni yári bia haga bini. Pu payini urunime labolabo biagoria dahuliyali handaleheru pigiya ale wabu helaga bini. ");
INSERT INTO hui_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Labolabo pira uruninaga luni ge magi manda bialu mida homberia (12) aranenaga ge magi manda bialu mida kira wigi buwa labolabo bibahende ogobi dege dege wini. ");
INSERT INTO hui_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Ani bialu labolabo duria halu mbira lebumaga halu duria mende halu mende lebumaga halu bini. ");
INSERT INTO hui_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Ani buwa labolabo mindibime kirabali mo gimbu buwa barobia haga bulenedagua haleira ale mabubi labolabo mbira mbirani wabu helaga bini. ");
INSERT INTO hui_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Tigua mo gimbu bialu barobia holenedagoria haleira ale mabubi pira duria (50) labolabo pira duria (50) mbiranaga piganeni lebialu labolabo pira duria (50) mendenagabi labolabo maro biagoria haleira mabubi pira duria (50) dege helene. ");
INSERT INTO hui_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Ani manda bu helowa mo yania helaga bulene wangobi pira duria (50) ngolome wabuwa urunime yania helaga biyagola labolabo biaru mo gimbu bialu timbuni mbiraore hene. ");
INSERT INTO hui_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Ani buwa labolabo timbuni mbira Balai Anda biago bu dangila dambi hole wabini. Labolabo ogoni nogo meme irinime wabinigo bibahende lamaga halu bearia (11) lebumaga howa wabini. ");
INSERT INTO hui_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Labolabo bearia (11) uruninaga luni ge magi manda bialu mida haleria (13) wialu aranenaga ge magi manda bialu mida kira dege dege winigo bibahende ogobi dege dege wini. ");
INSERT INTO hui_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Ani buwa labolabo duria uruni lebumaga howa luni timbuni mbiraore hene. Ani bialu labolabo halu mende waragaria wiyarubi anidagua dege bini. ");
INSERT INTO hui_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Ani buwa labolabo luni ogoni labonaga lene leneha mo gimbu bialu barobia holenedagua mbirale haleira ale mabubi pira duria (50) labolabo maro biagoria helalu labolabo timbuni mendegonagabi ani dege helene. ");
INSERT INTO hui_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Ani bu helowa ogoni barobia howa yaniaho helolene wangobi pira duria (50) boronosime wabu wini. Wabiai howa mo gimbubu wiagola labolabo timbuni mbiraore wini. ");
INSERT INTO hui_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Ani biai howa mani nogo sibi wangabenaga dongone daramabiha guyinigome Balai Anda biago lone dambi dege holenaga mo wini. Ani buwa halu tebone wena timbuni iba tia alenaga dongenemebi dangila dambi dege hene. ");
INSERT INTO hui_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Anda háinaga ira generu gimbu gimbu bulene ira mini agasiame bini. ");
INSERT INTO hui_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Anda ira uruni luninaga ge magi manda bialu mida maria mbalapenaga sendimida emene pira waragariani waragaria (66) helo helene. ");
INSERT INTO hui_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Anda háinaga ira gene uruni maru dindihayagi gimbu bilo manda bialu emene luni ale tigi haga bini. Ira bibahende luni tubagi lolani hondowa ogobi dege degeore tigi haga bini. ");
INSERT INTO hui_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Anda háinaga ira kira kira dege dege daba hamagamaga buwa daga lamaga halu pira kira (20) mende mende lowa abene unurayaginaga wabini. ");
INSERT INTO hui_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Ani buwa silibame mbogoyi emene dege dege pira maria (40) anda gene biaru helaga bule wabini. Ani buwa anda gene mbira mbogoyi kiraha helaga buwa mbogoyi mo hongo ho helene. ");
INSERT INTO hui_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Anda gene maru pira kira (20) anda manda uyurayagi hearubi nde ani dege bini. ");
INSERT INTO hui_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","Ani bialu anda gene pira kira (20) uruni wabu manda mandabu ngelalu anda gene helolene mbogoyi pira maria (40) silibame wabuwa mbogoyi kiraha anda gene mbira helaga bini. ");
INSERT INTO hui_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Ani buwa anda gene ni paliragohayagi waragaria helalu ");
INSERT INTO hui_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","anda gene kira mende manda tibila gimbu biragoha helene. ");
INSERT INTO hui_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Anda háinaga gene manda tibila gimbu biragoha kira ogonilabo ho pagupagu bilowa gimbu bima iraga ho helene. Manda tibila gimbu birago bibahendeha ani dege bini. ");
INSERT INTO hui_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Ani biyagola anda tibihayagi gene halira halu siliba mbogoyi pira mbirani waragaria (16) anda gene dindiha mo wialu mbogoyi kirame anda gene mbira mo hongo ho helaga bini. ");
INSERT INTO hui_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Ani buwa anda hái libu banga bulenaga ira mini agasia pira mbirani duria (15) dibalu lunioreru pelo mbaralowa wini. Ira luni mbalape uruni aria duria anda hái manda abene unurayagi libu para halu ");
INSERT INTO hui_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","duria mende uyurahayagi libu para halu duria tebone ni paliragohayagi libu para halu bulenaga ani dibu pelo manda bini. ");
INSERT INTO hui_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Anda hái libu para holenaga ira dibu pelenego dombeni para holenego lunaga anda magi manda buwa anda ibuniore karulape tigi howa pelene. ");
INSERT INTO hui_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Ani buwa anda hái gene biaru ngolome paraho dambi hene. Mandaha hái para howa yaniaho helonaga ngolome yania holene gi pagida ale mabubi maru wabuwa ira hái libu para hayago yaniaho helaga bini. Anda hái para holene ogoni ngolome paraho dambi hene. ");
INSERT INTO hui_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Uruni biai howa labolabo baya taraore mbira anda tamuha hobaki holene wabini. Labolabo timbuni ogoni pu tara tarame mo yári biahaga bialu howa nogo sibi irinime pu payini mindibiha guyini hari mindini handalehe wiarumebi tagalitaya aleha guyini wiarumebi daramabiha guyini wiarumebi mo yári bia halu dahuliyali handaleheru pigiya labolabo ogoriani yári bia hene. ");
INSERT INTO hui_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Ani buwa ira agasia mbira dibuwa anda gene maria wabuwa ngolome paraho dambi hene. Anidagua buwa silibame mbogoyi maria wabuwa ira gene biaru mbogoyi ogoriani helene. Ani helowa ira ogoriani labolabo yani helonaga wangobi ngolome wabuwa ira maria ogoriani ta howa helaga bini. ");
INSERT INTO hui_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Ani biai howa labolabo timbuni mbira anda ogoninaga panga helole wabini. Panganaga labolabo ogoni pu tara tarame mo yári biahaga bialu nogo sibi irinime pu payini mindibiha guyini hari mindini handalehe wiarumebi tagalitaya aleha guyini wiarumebi daramabiha guyini wiarumebi labolabo wabini wiaruni yári bia hene. ");
INSERT INTO hui_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Ira agasia mbira dibuwa gene duria wabuwa ngolome paraho dambi howa boronosime mbogoyi duria anda gene uruni helole wabu wini. Ani buwa mbogoyi duria uruniha ira gene duria biaru helowa labolabo gerela holene wangobi maru ira ogoriani helalu buwa labolabo biago ogoriani mo gerelape ho wini. ");
INSERT INTO hui_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Besalelehanda Habo Nalolene Bi lo winigonaga Mbogoyi mbira ira agasia dibu pelowa mbaraleore winigome wabini. Mbogoyi ogoni luninaga magi sendimida emene handari mbirani pira mbira (110) wialu aranenaga magi sendimida emene pira waragariani waragaria (66) wialu daliganaga magi sendimida emene pira waragariani waragaria (66) dege wialu wabini. ");
INSERT INTO hui_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Ani bialu ibugua ngolo bayaleore irani do taulo wahene ngarume Mbogoyi ogoni tagira tamuhabi baya hangu paraho dambi hene. Ani buwa bu gimbu bini nene pugu bidadagua ngolo baya uruni ariame mo homane howa paraho mabu bini. ");
INSERT INTO hui_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Ibugua ani bialu Mbogoyi ogoni iraho yulenenaga gi pagida ale mabubi ira holene gimbuni maria wiadagua mabubi maria ngolome dege wabuwa gene maria dindiha hearu ta howa wabu helene. Gene mende mendehabi mabubi kira labolabo helene. ");
INSERT INTO hui_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Ani biai howa Mbogoyi iraho yulenenaga ira agasiame ira kira wabu wialu ira ogoni labobi ngolome paraho dambi dege hene. ");
INSERT INTO hui_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Ogoni biai howa Besalele ibugua ira ogoni labo Mbogoyinaga gene dindiha mbirale mabubi gi pagida ale ngolome wabu helayagoha Mbogoyi iraho yalu polenedagua abe tale buwa mo karulelene. ");
INSERT INTO hui_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Ani bialu Mbogoyi ogoninaga panga ngolo bayaleore wiagome wabuwa luninaga magi sedimida emene handari mbirani pira (110) wialu aranenaga magi sendimida emene pira waragariani waragaria (66) wilo wabu helene. Ogoriani howa wali agalime mana ko biniru domo waholene wini. ");
INSERT INTO hui_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Ani buwa ibugua dahuliyali handalehe kira ngolo bayaleorerume baya hangu hamame bo dambu tiga bigi bialu wabini. ");
INSERT INTO hui_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Ani wabuwa Mbogoyinaga pangani mbirago gi tigaha mendego gi lehayagi lowa talebu helene. Mbirale uruni ti hangu hangu wabia ndo Mbogoyi pangabi dahuliyali handalehebi bibahende mbiraoreha wabu gimbu bigi bini wilo wabini. ");
INSERT INTO hui_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Dahuliyali handalehe kira ogonilabo libuni handa edene buwa Mbogoyinaga panga daligani wali agalinaga ko biniru domaga laga wiagoria helene. Libunaga babaganeme Mbogoyi biagonaga panga yula dambi hai helo helene. ");
INSERT INTO hui_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Besalele ibugua tebolo dagia mbira ira agasia dibu pelowa ogonime wabini. Dagia tebolo dagia ogoni luninaga magi sendimida emene pira halirani halira (88) aranenaga sendimida emene pira mariani maria (44) wialu daliganaga sendimida emene pira waragariani waragaria (66) helo wabini. ");
INSERT INTO hui_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Ani wabu ngelowa ngolo bayaleme paraho dambi halu dagia tebolonaga nene gimbuni wiadagua ngolo mo homane howa paraho dambi hene. ");
INSERT INTO hui_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Ani buwa dagia tebolo neneni ngolome paraho mabu bulenego tohenaga magi sendimida emene halira helowa ogonime dagia tebolo neneni ngolome para hayago lone paraho dambi halu nene bibahendeni paraho mabu bupe hai hene. ");
INSERT INTO hui_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Ibugua ani buwa dagia tebolo biago iraho yulenenaga ngolome wabini mabubi gi pagida ale maria wabuwa gene maria kagoha ta howa wabu helene. ");
INSERT INTO hui_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Ani bialu dagia tebolo iraho yulenenaga mabubi gi pagida ale uruni dagia tebolo gene maria kagoha tigatiga nene ngolome paraho dambi hayago andaneha dege hapara ho helaga bini. ");
INSERT INTO hui_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Ani buwa ira agasiame ira kira dagia tebolo iraho yulenenaga manda mandabu ngelowa ngolome paraho dambi hene. ");
INSERT INTO hui_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Ani bialu dagia tebolo ogoriani ngelolenenaga ndisi bebi beledibi iba bebi be marubi waini iba loma binigo odo mulenaga ndisi bebi uruni bibahende ngolome dege Besalelehanda wabiai hene. ");
INSERT INTO hui_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Besalele ibugua lamu hale wiagane irane ngolo bayaleoreme wabu helene. Ibugua hamame ngolo baya hangu dambu tiga bigi buwa lamu hale wiagane tene baya hangu ngelowa irane ogoriani mo karulaga bini. Ani buwa lamu halenaga irane heagoria dege gebagane helowa lamu hale wabupe haga bini. Ani buwa ibugua ngolome dege balawaya lini dole pabua baradaguabi ale wabuwa lamu hale irane ogoriani wabu gimbu bigi bini. ");
INSERT INTO hui_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Lamu halenaga irane ogoriani gebagane waragaria wabuwa abene mendeha tebira mendehabi tebira dege lowa wabu helaga bini. ");
INSERT INTO hui_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Lamu hale gebagane waragaria biarunaga tebira mbira mbirani balawaya ira amononaga lini dole pabua baradaguabi ale ginigene wabu helaga bini. ");
INSERT INTO hui_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Lamu halenaga iraneni balawaya bayale ira amononaga lini dedaligobi mitangi bialu maria wabu helene. ");
INSERT INTO hui_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Ani biai howa lamu hale gebagane biaruni andanehayagi balawaya lini dole pabua baradaguabi ale mbira mbira wabuwa helaga bini. ");
INSERT INTO hui_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Ani bu ngelowa gebaganebi balawayanaga lini dole pabua baradaguabi ale biaru hamame bo ndibulaga bialu mo mbiraore howa wabu gimbu biai hene. ");
INSERT INTO hui_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Ani biai howa lamu hale iranenaga gebaganeni ira dolene karia wabuwa helaga bini. Ani buwa ira dedago tabolene pero mbira ngolo bayaleoreme wabialu beledi marubi wabini. ");
INSERT INTO hui_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Ani wabuwa lamu hale iranenaga gebagane maru biaru bibahende wabulenenagabi ngolo genda magi kilogarama pira tebirani maria (34) winigome wabini. ");
INSERT INTO hui_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Besalelehanda ira agasia mbira dibu pelowa ira hagua nga biaga mini inisenesi lomabu delolene dabu mbira wabini. Dabu ogoni luninaga magi sendimida emene pira mariani duria (45) wialu aranenaga magi sendimida emene pira mariani duria (45) dege wialu daliganaga magi sendimida emene pira dira (90) helo bu helene. Gibuni maria ngagoria nogo bulumaganaga ne gayane handalehe maria ta howa wabu helene. ");
INSERT INTO hui_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Ani buwa gibuni maria bibahende ngolome para halu ngolome dege mo homane howa dabunaga nene nene wiagoria ndibulo mabu bialu nogo bulumaganaga ne gayane handalehe maria heagobi ngolome dege paraho dambi hai hene. ");
INSERT INTO hui_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Ani buwa ngolome dege gi pagida ale mabubi kira kira wabuwa abene mende mendeha lowa tale buwa iraho yalu polenenaga gibu kira manda mandabu helene. Gi pagida ale mabubi ogonilabo ngolo homane paraho mabu biyago andaneha hapara helowa dege wabu para hene. ");
INSERT INTO hui_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Ani buwa ibugua dabu ogoni iraho yulenaga ira agasiame ira kira mo manda manda buwa ngolome paraho dambi ho wini. ");
INSERT INTO hui_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Besalele ibugua weli mbira baya taraore Anduane Homogo ibuninagaore wiabagi helo odope haga biago wabini. Ani buwa ira hagua ngabilo lomabu delaga inisenesi bayale taraore wabialu padua mbira ngabiore sanda ale wiarume mo biamaga howa dambiyagola ngabi baya taraore wabu wini. ");
INSERT INTO hui_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Besalele halu biabe biaga agali bu hearu tigua ira agasia mbira dibuwa lomabu delolene dabu mbira wabini. Dabu ogoni gibuni gibuni bibahendeha ge magi manda bialu ogobi dege dege mida kirani sendimida emene pira kira (20) manda bialu wabini. Daliganaga ge magi manda bialu mida mbirani sendimida emene pira tebira (30) halu bilo wabini. ");
INSERT INTO hui_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Ani buwa nogo bulumaganaga ne gayane handalehe maria ira agasia biagome dege wabuwa gibuni mariani helene. Ani helowa mbirale bulumaganaga ne gayane handalehe biarubi lomabu delolene dabu urunibi bibahende boronosime paraho dambi hai hene. ");
INSERT INTO hui_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Ani buwa ndisi be marubi ira pungaru hilo yulenaga wabini. Ani bialu nama tabuli ale emene marubi ndisi be marubi pogorubi belediru ira punga hiliyu waholenaga alebi uruni bibahende boronosi degeme wabiai hene. ");
INSERT INTO hui_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Ani buwa mbirale ira delolene dagia diri dewawi dabu ogoninaga gene maria heagoria helole boronosime dege wabini. Ani buwa ira delolene dagia biago dabunaga gene obeneni bapara hama pialu lina obeneni dege hairi helene. ");
INSERT INTO hui_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Ani buwa dabu ogoni iraho yulenaga gi pagida ale mabubi maria gene maria heagoha ta howa wabu helene. ");
INSERT INTO hui_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Ani wabu helowa dabu ogoni iraho yulenenaga ira kira ira agasiame manda manda buwa boronosime paraho dambi howa ngelene. ");
INSERT INTO hui_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Ani buwa mbirale gi pagida ale mabubi maria taho helayagoha ira biagolabo anda pelowa ngelene. Lomabu delolene dabu ogoni mbogoyi ale dege wabinigoyu tibiniha dege payadaga nahe ngelene. ");
INSERT INTO hui_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Wali maru Anduane Homogonaga Balai Anda kago harabani biabe biaga berearume boronosi maru Besalele tagu mini. Boronosi uruni wali tinaga iba wa̱yu̱ ale wini. Biabe biaga hearu tigua boronosi ogonime gi geru waya bulene ndisi be mbira wabialu ndisi be ogoninaga wiagane dagiabi boronosi degeme wabu wini. ");
INSERT INTO hui_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Tigua labolabo bayaleoreru wabuwa Anduane Homogonaga Balai Anda kago pabe bu yanda holenaga bini. Labolabo ogoni unurahayagi aranenaga ge magi manda bialu mida pira mariani maria (44) wabini. ");
INSERT INTO hui_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Ani buwa gene pira kira (20) boronosime wabu wialu gene uruni helolenenaga mbogoyibi pira kira (20) dege boronosime wabu wini. Ani buwa bubigi homane luni silibame wabiniru gene mbira mbira helearuni bibahende dabaho gimbu bigi bini. Ani buwa labolabo luni banga bini biaruni gerela holenaga ta howa silibame wangobi wabu helaga bini. ");
INSERT INTO hui_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Anda manda abene uyurahayagibi nde anidagua dege wabu helene. ");
INSERT INTO hui_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Pabe ni paliragohayagi labolabome aranenaga ge magi manda bialu mida pira kirani kira (22) wialu gene boronosime wabini pira wabialu mbogoyibi pira dege wialu gene uruni helolenenaga diriwi wabu ngelene. Lu bubigi banga bini biarunibi wangobi biarubi silibame dege wabuwa labolabo gerela holenaga wangobi biaruni ta howa helaga bini. ");
INSERT INTO hui_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Ani bialu anda panga haraba abene ni tagira ibiragohayagi wiagoha helolene labolabo aranenaga ge magi manda bialu mida pira kirani kira (22) dege wini. ");
INSERT INTO hui_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","15","Labolabome pabe bu yanda ho helolenego aranenaga ge magi manda bialu mida waragariani sendimida emene pira waragaria (60) lowa panga haraba anda pu íbu bulenegoria lene labolaboni tale bu helene. Boronosime mbogoyi wabu ngelayagoria gene manda mandabu wiyago mendehayagi tebira lowa mendehabi tebira dege lowa helene. ");
INSERT INTO hui_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Pabe buyu mabu bulenaga labolabo bibahende baya taraoreme wabu helene. ");
INSERT INTO hui_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Gene bibahende boronosime wabiniru helolene mbogoyi boronosi degeme wabini. Labolabo gerela holenaga wangobi wiarubi bubigi homane luni banga binirubi uruni bibahende silibame wabu helene. Gene bibahende nguni daligahayagi siliba degeme paraho dambi hai howa bubigi homane luni banga bulene silibame wabiniru gene mbira mbira helearuni bibahende dabaho gimbu bigi buwa helene. ");
INSERT INTO hui_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Ani buwa anda panga haraba pu íbu bulenegoria labolabo baya tara tarame wabu helaga bini. Labolabo ogoni pu nogo sibi irinime payini maru mindibiha guyini hari mindini handalehe wiarumebi tagalitaya aleha guyini wiarumebi daramabiha guyini wiarumebi bayuwaore mo yári bia hene. Labolabo ogoni aranenaga ge magi manda bialu mida dira lowa lu daliganaga ge magi manda bialu mida kirani sendimida emene pira kira labolabo maru biarubi helayadagua dege helene. ");
INSERT INTO hui_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Ani bialu labolabo yaniaho helolene gene mariabi gene helolene mbogoyi mariabi boronosime wabu helene. Ani helowa labolabo gerela holenaga wangobi helearubi bubigi homane luni banga binirubi uruni bibahendeore silibame wabini. Gene bibahende nguni daligahayaginaga silibame paraho dambi hene. ");
INSERT INTO hui_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Balai Anda biago nguni pume dariba holenaga dindiha gelo holene wabuwa pabe gelo holenenagabi boronosime dege wabu wia dege bini. ");
INSERT INTO hui_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Tigua Anduane Homogonaga Balai Anda ege to̱le̱ kirani ibunaga bi pira gilibuwi biagolabo wulenaga ala bini biagoha ngolo siliba boronosirubi uruni tigua mo yu ngoai henedaruni bibahende dagalai hene. Mosese ibunime Libaiali hearuhondo lamialu lalu, Ngolobi mbirale uruni bibahende dagalai howa bebani gili bilimu, lene. Tigua dagaleagola loma binigo mo miaga agali Arono igini Idama ibugua hondo haga hene. ");
INSERT INTO hui_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Yuda hameigini aria Hua aguane Uri henego igini Besalele heago ibugua mbirale Anduane Homogohanda Mosesehondo bibe lalu laminiyago bibahende biaiore hene. ");
INSERT INTO hui_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Agali mende ibula biabe mandagi biaga mbira Dana hameigini aria Ahisamaga igini Oholiaba ibugua ege to̱le̱ni bage ale podaradagua bialu bi gilibu wiaga howa biabe uruni manda mandabu haga hene. Ibugua agani pume yári tara tara bulenebi nogo sibi irinime pu payini mindibiha guyini hari mindi handalehe wiarubi tagalitaya aleha guyini wiarubi daramabiha guyini wiarubi yári tara tara lebiaga hene. ");
INSERT INTO hui_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Anduane Homogonaga Balai Anda biago bulenaga wali agalime ngolo yu ibiyaru lomabu wiabagi ho winiru bibahendenaga genda magi manda bialu kilogarama handari dirani pira dirani halira (998) yalu ibiniyane hendene. ");
INSERT INTO hui_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","26","Tigua siliba dagalo handalu hemiria genda magi manda bialu kilogarama daosini tebirani handari mariani pira tebira (3,430) mo mogo biniyane hendene. Muni siliba uruni agali mali pira kira (20) ho bolangua hene hearu tinaga mini bebani gilibu wigi biyarume muni kina duria ale yu ibugu biyago dagalalu hemiria agali daosini dege handari waragariani tebira handari duriani pira duria (603,550) bibahende ibiniyane hendene. ");
INSERT INTO hui_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Tigua siliba uruni marume Anduane Homogonaga Balai Anda biagonaga anda gene helolene mbogoyi handari mbira (100) wabini. Mbogoyi mbira mbiranaga siliba genda magi manda mialu kilogarama daosini tebirani handari maria (3,400) wabu wini. ");
INSERT INTO hui_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Ani bialu siliba maru ibira hene genda magi manda bialu kilogarama pira tebira (30) wini. Ani wiagola ibira hene urunime labolabo yania holenenaga nguni kirabali wangobi helayarubi bubigi homane lu banga binirubi gene damene helearu daligahayagi daba hogimbu bigi bulenebi siliba urunime wabini. ");
INSERT INTO hui_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Tigua Anduane Homogonaga boronosi wiabagi henego genda magi manda bialu kilogarama daosini kira handari mariani pira kirani duria (2,425) mini. ");
INSERT INTO hui_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Boronosi urunime Anduane Homogonaga Balai Anda biago haraba pu íbu bulenegoria gene helolene mbogoyi wabini. Ani bialu lomabu delaga dabu biagonibi mbirale diri dewawi helenegobi mbirale tara tara lomabu delaga dabu biagonaga bibahendebi boronosime wabiai hene. ");
INSERT INTO hui_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","Ani bialu Balai Anda pabe bu mabu biyagonaga gene helolene mbogoyi biarubi pabe biago haraba pu íbu bulenegoria gene helolene mbogoyibi boronosime dege wabu helene. Balai Anda biago nguni pume dariba holenaga dindiha gelo boronosime wabuwa pabenaga gelobi boronosime dege wabu wia dege bini. ");
INSERT INTO hui_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Loma binigo mo miaga agali hearu ti Balai Anda Hobane Loma Bia hene heagoha biabe bialu howa aga karulelonaga wabini. Tigua pu tara tara bayaleoreru nogo sibi irinime payini mindibiha guyini hari mindini handalehe wiarumebi tagalitaya aleha guyini handalehe wiarumebi daramabiha guyini wiarumebi urunime baya hangu yári bia halu aga wabini. Arononaga aga Anduane Homogohanda ogobiore wabibe lalu Mosesehondo lamiyadagua wabini. ");
INSERT INTO hui_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Tigua loma binigo mo miaga agalinaga aga mini ebodi karulaga wabini. Ani wabuwa aga ogoni lebialu pu ngolo ale bayale wiagomebi nogo sibi irinime payini mindibiha guyini hari mindini handalehe wiarumebi tagalitaya aleha guyini wiarumebi daramabiha guyini wiarumebi wabini. ");
INSERT INTO hui_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Tigua ngolo wiago hamame balu bo mbalape lowa beba ale ngelene. Ani buwa ngolo emeneore ogoni podaga bialu pu dini emeneme helowa pu maru mindibiha guyini wiarumebi tagalitaya aleha guyini wiarumebi daramabiha guyini wiarumebi uruni heba payamaga halu aga lebulene pu ale helowa agani yári maru lebu helaga bini. ");
INSERT INTO hui_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Tigua aga mini ebodi pu dini lunime payani paulaki holenedagua kira wabuwa loma binigo mo miaga agalinaga aga karulaga biago baba ndibu lelonaga lebumaga hene. ");
INSERT INTO hui_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Ani buwa labolabo bayale mbira pu bayaleorerume aga mini ebodi yári tara tara wabiyadagua bialu mo yári bia haga bialu lebigi bini. Labolabo ogoni loma binigo mo miaga agalinaga aga ebodi biago mandibu leneha lebu paraho mabu bini. Ani bialu abale Anduane Homogohanda Mosesehondo bibe lalu lamiyadagua bini. ");
INSERT INTO hui_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Ani biai howa ege to̱le̱ kira mini kaneliana wiago labo mo yuwa Yagaba igini homberia (12) biarunaga mini ege to̱le̱ o biago laboni bage ale podaradagua bialu podo wigi bini. Ani buwa ege to̱le̱ ogo laboni ngolome mo yári bia hene biagoriani mo wini. ");
INSERT INTO hui_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Ani buwa aga mini ebodi biagoni pu dini emeneme payinigo payani paulaki hayagoriani Isaraele hameigini homberia (12) mitangi bulenaga ege to̱le̱ kira biago labo paraho dambi hene. Anduane Homogohanda anidagua bibe lalu Mosesehondo lamiyadagua ani bini. ");
INSERT INTO hui_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Tigua aga emene galuhombeni karulolene ogoni loma binigo mo miaga agali karunaga aga mini ebodi wabiyagobi dege wabini. Aga ogoni pu payini ngolo alemebi pu mindibiha guyini hari mindini handalehe wiarubi pu tagalitaya aleha guyini wiarubi pu daramabiha guyini wiarubi urunime yári bia haga bini. ");
INSERT INTO hui_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Ani buwa aga biago hanuni paulaki biyagola luninaga magibi aranenaga magibi sendimida emene pira kirani kira (22) dege hene. ");
INSERT INTO hui_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Ani buwa ege to̱le̱ muni dewame miaga wiaru duguni maria aga ogoriani helaga bini. Duguni mbirago ege to̱le̱ mini lubibi tobasabi ganedebi uruni mbira mbiraha dabaho helaga bini. ");
INSERT INTO hui_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Ani bialu duguni mendegoria ege to̱le̱ mini emeralabi sabaiabi daimonobi uruni mbira mbiraha dabaho helaga bini. ");
INSERT INTO hui_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Duguni tebonego ege to̱le̱ mini tegoisibi agadebi amedisibi uruni mbira mbiraha dabaho helaga bini. ");
INSERT INTO hui_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Ani bialu duguni manego ege to̱le̱ mini berilibi kanelianabi yasabebi mbira mbiraha dabaho helaga biai hene. Ege to̱le̱ uruni mbira mbirago ala ngolome mo yári bia haga buwa mani aga biagoria helaga bini. ");
INSERT INTO hui_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Ege to̱le̱ homberia (12) uruni mbira mbirani Yagaba igini homberia (12) biarunaga mini bage ale podaradagua bialu podo wigi bini. Isaraele hameiginiru mitangi bialu ani bini. ");
INSERT INTO hui_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Ani buwa aga ogoni galuhombeni mo karulolenaga ngolo pume hendehope helonaga seni pu aleme wabu helene. ");
INSERT INTO hui_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Ani buwa ngolome wabini yáribi haleira ale mabubi kira kirabi wabu helene. Ani buwa tigua haleira ale mabubi kira ngolome wabini biagolabo aga galuhombeni biagonaga lene gimbuni kirabalini daligahayagi pongobia hene. ");
INSERT INTO hui_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Ani buwa ngolome seni pu ale kira wabu helayagonaga ngunini haleira ale mabubi kira ngolome dege wabini ogoriani pongobu mini. ");
INSERT INTO hui_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Ani bialu seni pu ngolome wabini biago labonaga nguni mende mendehayagi ngolome yári bia hene kira biagoha pongobia halu ngolome mo yári biahe ogoni aga mini ebodi biagonaga pu dini emeneme payinigo payani paulaki hene biagoha barobia hene. ");
INSERT INTO hui_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Ani buwa tigua ngolome haleira ale mabubi kira mende wabuwa aga galuhombeni karulolene biagonaga lene gimbuni kirabalini dindihayagi aga mini ebodi biagoriani pongobia hene. ");
INSERT INTO hui_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Ani bialu ogoniale dege haleira ale mabubi kira lone ngolome dege wabuwa nguni aga mini ebodi biago dindiha ndibulaga mandibu biagoria pongobia hene. ");
INSERT INTO hui_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Ani biai howa pu mindibi hari mindini handalehe mbirame haleira ale mabubi ngolome wabini kira biagolabo aga emene galuhombeni karulolene biagoria pongobu hayagoria pongobia howa aga mini ebodi biagonaga haleira ale mabubi helayagola pongo bumaga haga bini. Ani biyadagome aga galuhombeni karulolene biago mandibu dariba haga biagola aga emene ogonila golo wahabe naheore bayale wiaabo hene. Anidagua bibe lalu Anduane Homogohanda Mosese laminidagua bini. ");
INSERT INTO hui_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Loma binigo mo miaga agali hearunaga aga mini ebodi biago dindiha karulolenenaga aga mende biagimbu bulene pu nogo sibi irinime payini mindibiha guyini hari mindini handalehe wiarume wabini. ");
INSERT INTO hui_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Wabuwa loma binigo mo miaga agali kago ibunaga haguane anda pelolenedagua manda buwa hanuni wabuwa ngelene. Ani wabu ngelowa aga lerela timbu holigonaga aga podene mbirame ngunidago paula dai buwa lebini. ");
INSERT INTO hui_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","26","Ani buwa aga ogoni nguni dindihayagi pu nogo irinime payini mindibiha guyini hari mindini handalehe wiarumebi tagalitaya aleha guyini wiarumebi daramabiha guyini wiarumebi mo yári bia halu ira pomegaranade lini aleru wabu helaga wini. Ani buwa ira pomegaranade lini ale yári bu ngagoria dombeni mbelo emene emeneru ngolome wabiniru nguni ogoriani dege pongo biahaga bima pene. Anduane Homogohanda ani bilimu lalu Mosesehondo laminigodagua bini. ");
INSERT INTO hui_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","29","Ani bialu Arono ibu igini biarubi tinaga aga giha karulolenebi labolabo emboneni bobu mabu bulene mandabi wabialu tangi haguaneni karulaganegobi wabialu darasi aga bayaleoreme wabuwa bobia dambi holene aga mandibu biradagua nogo sibi irinime pu payini mindibiha guyini hari mindini handalehe wiarumebi tagalitaya aleha guyini wiarumebi daramabiha guyini wiarumebi o biago mo yári bia halu wabini. Anidagua bilimu lalu Anduane Homogohanda Mosesehondo laminigodagua bini. ");
INSERT INTO hui_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Ani bialu mbirale dombo heda wiradagua ngolome wabuwa ogoriani bi ogo Anduane Homogonaga Loma Biahene Ka lalu gilibu wini. ");
INSERT INTO hui_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Ani buwa dombo heda bi gilibuwi biago pu payini mindibiha guyini hari mindini handalehe wiarume hende howa loma binigo mo miaga agali biagonaga aga emboneni bobu mabu bini biagoria pongobia hene. Anidagua bibe lalu Anduane Homogohanda Mosesehondo lamiyadagua ani biai hene. ");
INSERT INTO hui_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Anidagua bialu Balai Andanaga biabe bulene wiaru biai hene. Anduane Homogohanda bilimu lalu Mosesehondo lamiyadagua Isaraelealirume biaiore hene. ");
INSERT INTO hui_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Ani buwa tigua mbirale uruni Mosese hearia mo yalu pene. Tigua Balai Anda bulene damene bibahendebi anda háinaga labolabo gerela ho wulenenaga wangobi biarubi anda háinaga ira generu gimbu gimbu bulenebi anda hái libu banga bulenagabi anda generubi gene helolene mbogoyirubi ");
INSERT INTO hui_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","Balai Anda dangini nogo sibi wangabe dongone daramabiha guyinime dangila dambi holene wabu wiyagobi wena timbuni iba tia ale biraganaga dongoneme dangila dambi holene wabu wiyagobi yalu ibini. Ani ya bialu labolabo timbuni anda Hobane Loma Bia Heneore hoba yanda hene biagoha gerela holene biagobi mo yalu ibini. ");
INSERT INTO hui_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","Ani bialu Habo Nalolene Bi lo winigonaga Mbogoyi biagobi ogoninaga panga daligani wali agalinaga ko domaga laga biagobi ege to̱le̱ kirabi ira kira Mbogoyi ogoni iraho yulene biagolabobi mo yalu ibini. ");
INSERT INTO hui_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","Ani bialu dagia tebolo biagobi mbirale bibahende dagia ogoriani biabe bulene wiarubi mberedi Ngode Datagaliwabenaga deni dagia tebolo ogoriani wiaga biarubi mo yalu ibini. ");
INSERT INTO hui_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","Ani bialu lamu hale wiagane irane ngolome wabini biago heba lamu hale ogoriani helolene biarubi lamu halerume biabe bulene wiarubi uruniha weli berelolene wiarubi ");
INSERT INTO hui_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","inisenisi lomabu delolene dabu ngolome wabini biagobi mo yu ibini. Ani bialu mbirale Anduane Homogo ibuninagaore wiabagi helonaga odo ha̱i̱ holene weli baya taraore wiagobi ira hagua ngabilo delaga inisenesi biagobi Balai Anda panga harabani gerela haga labolabo wabini biagobi mo yalu íbu dege bini. ");
INSERT INTO hui_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","Ani bialu lomabu delolene dabu boronosime wabini biago heba ira delolene dagia diri dewawi boronosi degeme wabu wiagobi ogoni iraho yulene ira manda mandabu wiyagobi dabu ogoriani biabe bulene damene bibahendebi gi geru waya bulenaga iba hambu wulene ndisi be heba ndisi be wiagane dagia biagobi mo yu íbu dege bini. ");
INSERT INTO hui_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","Tigua Balai Anda biago pabe bu yanda howa gerela holenenaga labolabo lebu wiyagobi generubi gene helolene mbogoyi biarubi pabe harabanaga pangani helolene labolabo wabu wiyagobi pu Balai Anda dangi yulupe kago dindini dariba holene gelo biarubi yalu ibugu bini. Balai Anda biagonaga biabe bulene damenego bibahendeore wabiai howa mo yalu ibini. ");
INSERT INTO hui_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","Loma binigo mo miaga agalime Anda Hobane Loma Biahene biagoha biabe bialu howa aga karulo helonaga wabiyarubi bibahende mo yalu ibini. Aga uruni Aronobi ibu igini biarubi ti mo karulelo lalu lomabu wiabagi ho wiyago mo yalu íbu dege bini. ");
INSERT INTO hui_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Anidagua bialu Isaraelealihondo Anduane Homogohanda uruni bilimu lalu Mosesehondo bi lamiyadagua biaiore hene. ");
INSERT INTO hui_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Ani yalu íbu wiai heagola Mosese ibugua baya hangu handalu hearia mbirale bibahende Anduane Homogohanda bibe lalu lamiyagobiore biai hayiyane hendene. Mbirale uruni de handai howa ibugua lalu, Anduane Homogohanda tí biamogo bilo hameledo, lalu Mosesehanda lene. ");
INSERT INTO hui_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Anduane Homogohanda Mosesehondo lamialu lalu, ");
INSERT INTO hui_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","Bi larogo hale habe. Ege pigane haragonaga horo mbira laragola tígua i̱naga Balai Anda bu helalimu. ");
INSERT INTO hui_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Anda bu helowa Habo Nalolene Bi lo winigonaga Mbogoyi ege to̱le̱ kirani Bi Pira gilibuwi yu wiaga biago anda ogoniha mo ngelowa labolabome tamuha hái bu yanda halu mo ge howa wilimu. ");
INSERT INTO hui_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Ani bialu dagia tebolo mbira mo yu anda pu ngelowa mbirale tara tara dagia tebolo ogoriani wiagaru mo wigi bilimu. Ani bialu lamu hale wiagane irane ngagobi lamu hale ngarubi mo yu anda puwa mo tiga bialu wilimu. ");
INSERT INTO hui_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Ani buwa ira hagua ngabilo inisenesi delolene lomabu delaga dabu ngolome wabu wini biago mo yalu anda puwa Habo Nalolene Bi lo winigonaga Mbogoyi biago ngagoria wanakuihayagi wialu labolabo lebu ngagome Balai Anda harabahayagi panga helo gerela peho wilimu. ");
INSERT INTO hui_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Lomabu delolene dabu Balai Anda ogoninaga haneni ngelalimu. ");
INSERT INTO hui_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Ani bialu lomabu delolene dabu kagola Balai Anda kagola hengeneha gi geru waya bulene ndisi be mo ngelalimu. Mo ngelowa ndisi be ogoniha iba hambu berelalimu. ");
INSERT INTO hui_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Ani buwa Balai Anda kagoha pabe bu mabu buwa ogoninaga panga harabani labolabo timbuni biago gerela peho wilimu. ");
INSERT INTO hui_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Uruni biai howa mani Balai Anda ogonibi anda ogoniha mbirale ngarubi i̱ninaga loma bia heneore wilo weli tara mbirale wiabagi holenaga odo wiaga biago mo yalu puwa ogonime mbirale ngarunagabi andanibi bibahendeni odope hai haga bilimu. Anidagua beremigola mbirale uruni bibahende i̱ninaga lomabia heneore wulebira. ");
INSERT INTO hui_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Ani buwa lomabu delolene dabu boronosime wabini ngagobi ogoriani biabe bulenaga wini ngarubi bibahende i̱ninagaore loma bia hene wilo weli ogoni degeme odope hai halimu. ");
INSERT INTO hui_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Gi geru waya bulenaga iba hambu wiaga ndisi be biagobi be ogoni wiagane dagia biagobi i̱ninaga loma bia hene dege wilo anidagua bilimu. ");
INSERT INTO hui_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Ani biai howa mani Aronobi ibu iginirubi Balai Anda ogoninaga harabani haru ibuwa ti ilili bialu wayawaya bia holene nga. ");
INSERT INTO hui_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Wayawaya biai howa Arono ibu loma binigo mo miaganaga aga karulaga ngago mo karula howa ibu i̱naga loma binigo mo miaga howa biabe ogoni bialu helo odo wiaga weli biagome ibunaga haguaneni odo wialu loma biaho helolene nga. ");
INSERT INTO hui_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Ani bialu mani ibu iginiru kawareni haru halu ibuwa loma binigo mo miaga agalime aga giha bulene ngaru mo karula habe. ");
INSERT INTO hui_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Ani karula halu igiri uruni ti aba lomabu helaridagua tibi i̱naga loma binigo mo miaga agali howa biabe ogoni bialu helo tinaga haguaneni weli biago odo wiai habe. Í̠na tinaga haguaneni weli odo wiai kegola ti loma binigo mo miagaore haabo holebira, lene. ");
INSERT INTO hui_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Anduane Homogohanda Mosesehondo bibe lalu lamiyadagua ibugua biaiore hene. ");
INSERT INTO hui_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Ani binigo Balai Anda mbira Anduane Homogonaga anda biago bini. Anda ogoni binidagoni Isaraele wali agali tini Iyibi dindi howa tagira íbu heane mali mbira puwa mali mendegonaga ege pigane mbira ngabu layagola ege mbira ogoninaga horo mbira dege pigane tehinayagola ani bini. ");
INSERT INTO hui_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Mosesehanda anda ogoni bialu howa ala dindiha anda hái gene helolene mbogoyi ala wima pene. Ani buwa anda hái gene helowa hái libu banga bulene ira helalu ira gene helaga bini. ");
INSERT INTO hui_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Ani biai howa Balai Anda ibuni muwa dangilo dambi hene. Ani dangilo dambi howa Balai Anda ogoni kabubu yaga andane winigome lone dangilo dambi hene. O binidagoni Anduane Homogohanda Mosesehondo ani bibe lenedagua bini. ");
INSERT INTO hui_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Ani buwa ege to̱le̱ mbalape kira Bi Mana Pira gilibuwi biago labo Habo Nalolene Mbogoyi biagoha mo wini. Ani buwa iraho yulene kira Mbogoyi biagoha gi pigida mabubi heagoha mo hana hene. Ani mo hana howa Habo Nalolene Mbogoyi biagonaga panga daligani bini. ");
INSERT INTO hui_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Ani buwa Mbogoyi biago Balai Anda biyagoha mo ngelowa aga gerelape heagome dogolo a̱i̱ na̱i̱ buwa tamuha handabe nahe geho ngelene. Aga dungu gimbu buwa gerela peho ngelenedagome Mbogoyi biago hoba muwa tamuha ngelene. Ani binidagoni Anduane Homogohanda Mosesehondo ani bibe lenedagua bini. ");
INSERT INTO hui_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Ani buwa dagia tebolo muwa Balai Anda biago tamuha uyurayagi aga gerelape hayago tagirahayagi mo ngelene. ");
INSERT INTO hui_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Anduane Homogo ibunime Mosesehondo ani bibe lenedagua dagia tebolo ogoriani mberedi ibunihondo loma bialu minigo mo wini. ");
INSERT INTO hui_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Ani buwa lamu hale wiagane irane gimbu bini biago muwa Balai Anda tamuha mo yu anda puwa dagia tebolo biago unurayagi ngelowa lamu hale wiagane iranedagoni dagia tebolo biago handadaga howa ngelene. ");
INSERT INTO hui_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Ani mo ngelowa Mosese ibugua Anduane Homogo deni odagoriani howa lamu hale dagane biaru delene. O delenedagoni Anduane Homogohanda ani delabe lenedagua delene. ");
INSERT INTO hui_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Ani delowa ibugua inisenesi lomabu delolene dabu ngolome wabini biago Balai Anda tamuha mo yu anda puwa aga luni gerelape hayago tigatiga mo wini. ");
INSERT INTO hui_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Ani mo ngelowa dabu biagoria ira hagua ngabilo delaga mini iniseneni o biagoria delene. O delenedagoni Anduane Homogohanda Mosesehondo ani delabe lenedagua delene. ");
INSERT INTO hui_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Ani buwa aga luni biago Balai Anda ubanda tagi bulene panga harabani gerelape hene. ");
INSERT INTO hui_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Ani buwa aga o gerelape hayadagoniore tigatiga mbirale mbirale Anduane Homogohondo lomabu delolenenaga dabu ogoriani mo wini. Ani mo ngelowa ogoriani mbirale irame dai helo delolene winigobi widi lini do winigobi odagoriani mo delene. Anduane Homogohanda bibe lenedagua ani bini. ");
INSERT INTO hui_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Ani buwa ibugua gi ge wayawaya bulene ndisi be Balai Anda biagola dabu biagola dombeneha mo ngelowa iba hambu to̱lotagiho ngelene. ");
INSERT INTO hui_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Ani buwa Mosese ibubi Aronobi Arono iginirubi tinaga gi gebi ogoniha wayawaya biaga wini. ");
INSERT INTO hui_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Agali uruni ti Balai Anda biago tamuha anda pole howabi lomabu delaga dabu biagoha pole howabi tinaga gi geru ala wayawaya bilimu lalu Anduane Homogohanda ani lenedagua bini. ");
INSERT INTO hui_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Mosesehanda Balai Anda biagoni bu helowa anda o biagonibi lomabu delolene dabu wiagobi hobanda hole lowa manda manda pabe buyu mabu bini. Ani hobandaho ngelowa pabe ogoni ubanda tagi bulene harabani aga luni mbira gerelape hene. Ani bigi bialu Mosesehanda Balai Andaha biabe bulene winigo biaiore hene. ");
INSERT INTO hui_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Mosesehanda Balai Anda biagoni biaiore howa bu heleagola nde hari beralibame ibalu Balai Anda biagoni buyi hai hene. Ani biyagola Anduane Homogonaga wá holene de mborerebi agiore loabe tobahegome Balai Anda biagoni to̱lotagi hene. ");
INSERT INTO hui_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Ogonidagua biyago handayagola Mosese ibu Balai Anda biago tamuha ubanda halu pobe nahe gibioreyagola nape wahene. ");
INSERT INTO hui_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Ani binigo Isaraele wali agali ti dindi o hemidagoriani haabo howa hari beraliba Balai Anda biagoria wiadali hayago iraga halu poragola dege tibi anda gialo yalu dindi mendeni anda bu hama pugu bialu hene. ");
INSERT INTO hui_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Hari beraliba biago ibu ema nabi wiagola ti nde ema nabi odagoriani ho palu haga bini. ");
INSERT INTO hui_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Ani bigi bialu henego Isaraele wali agali ti ibaga bialu anda geleyu palima ibagabu headangi Anduane Homogo ibuni ti heba ko lalu manane walia halu hari beraliba biago horongi Balai Anda biagoria wiape halu mbiraganaga Balai Anda biago yarali howa ogoni tiga tiga ira hungu bialu daho wiaabo halu hene. Ti ani dege bialu howa Anduane Homogohanda dindi tí nguliya lenegoria anda piyagola beraliba biago ereba hene. ");
INSERT INTO hui_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Anduane Homogo ibuninaga Balai Anda biagoha howa ibugua Mosese olalu íbu lowa lalu, ");
INSERT INTO hui_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","Isaraele wali agaliruhondo ogodagua lamibe. Tí kamiru aria mbirago ibu Anduane Homogohondo nogo lomabu mule ibuleyagua nde ibunaga bulumagayaguabi sibiyaguabi memeyaguabi mbira hangu haru ibalimu, lene. ");
INSERT INTO hui_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Mosese ibugua Anduane Homogohanda lamibe layadagua lalu, Agali mbirame nogo bulumaga mbira irame dai helo bo lomabu delole lowa haru halu ibiyagua nde bulumaga wangabe habatigiore tingini mo ko nahe dere durubi nabiore kago haru ibulene nga. Mbirali lomabu yalu ibirago ibuhondo Anduane Homogohanda turu helo hame ledayagua nde ibugua loma ogonidagua bu yalu ibulene nga. Ibugua Anduane Homogonaga Balai Anda kago haneni yu pialu ");
INSERT INTO hui_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","bulumaganaga haguaneni gi wialu biragola Anduane Homogohanda ibuhondo miniha dungulo howa ibunaga ko wiyadaru domo wahai holebira. ");
INSERT INTO hui_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Ani bialu Anduane Homogonaga deni howa agali loma haru ibiyago ibunime bulumaga biago baragola Arono aria loma binigo mo miaga agali karu tigua bulumaga ogoninaga darama Anduane Homogohondo lomabu mulebira. Tigua darama hambu yalu lomabu delaga dabu Balai Anda kago haneni puwa dabu gibuni maria ngagoha odo baamu nana bulebira. ");
INSERT INTO hui_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Ani bidagola agali ogoni ibugua bulumaga biagonaga dongone bo lagalalu mbirini podobaga bulebira. ");
INSERT INTO hui_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","9","Ani bialu nogo tini baya hangu halialu gi geru wayawaya biai holene nga. Ani biragola loma binigo mo miaga agali karu tigua lomabu delaga dabu biagoria ira dene hedo delolene nga. Ani delowa ira da timbu kagola bulumaga biagonaga haguanebi abenebi habanebi nogo bo podo paya biyago damene bibahende irani dai halu do ira punga helo delolene nga. Anidagua biragola Anduane Homogohanda loma ogoninaga tumutumu nga bayaleore birago nga halu ibuni miniha turu timbuni howa dungulo holebirago ani bulene nga, lalu Mosesehanda lene. ");
INSERT INTO hui_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Mbiralime nogo sibi memeru mbirago loma bialu bo delole haru ibiyagua nde sibiyaguabi memeyaguabi ogoni wangabego hondowa dere durubi nabi bayale kago hondowa haru ibulene nga. ");
INSERT INTO hui_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Ani haru halu ibuwa ibugua sibibi memebi ogoni lomabu delaga dabu kagonaga abene uyurayagi howa ogoriani bolene nga. Ani bope kagola loma binigo mo miaga agali karu tigua sibibi memebi ogoninaga darama hambuwa lomabu delaga dabu kagonaga gibuni maria ngagoha odo baamu nana bulene nga. ");
INSERT INTO hui_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","13","Ani buwa agali ogoni ibugua sibi biago podowa tini baya hangu haluwa gi geru wayawaya bo wahai howa ngeledagola loma binigo mo miaga kagome lomabu delaga dabuni ira dedagoria sibi haguanebi abenebi habanebi bibahende delai holebira. Loma binigo mo miaga kagome irani dalu do ira punga helo lomabu delolebira. Anidagua biragola Anduane Homogohanda loma ogoninaga tumutumu bayaleore birago nga halu ibuni miniha turu timbuni howa dungulo holebirago ani bulene nga, lalu Mosesehanda lene. ");
INSERT INTO hui_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Mbiralime ega Anduane Homogohondo lomabu mule minu yalu ibiyagua nde ega malibu ale bedago minu yalu loma binigo mo miaga agali kagohondo mule yalu polene nga. ");
INSERT INTO hui_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Ani miragola loma binigo mo miaga agali kago ibugua ega biago mani yuwa yu tinditanda laragola ega homolebira. Homaragola haguane pundulo muwa lomabu delaga dabuni ira dedagoha lomabu delolene nga. Ani bialu ibugua ega darama lomabu delaga dabunaga lenelene ngagoha odope hai holebira. ");
INSERT INTO hui_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Ani buwa ega nema yaga magini kagobi dugualu lomabu delaga dabu ngago abene ni tagira ibiragohayagi be ira punga hilo wiaga ngagoha bape holene nga. ");
INSERT INTO hui_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Ani bialu ega ibuni loma binigo mo miaga agali kago ibugua babaganeni gi talebu yuwa minu dogaki holene nga. Ani bialu irani dalu do ira punga helo lomabu delolebira. Mana ogonidagua biragola Anduane Homogohanda loma ogoninaga tumutumu bayaleore birago nga halu ibu miniha turu timbuni howa dungulo holebirago ani bulene nga, lalu Mosesehanda lene. ");
INSERT INTO hui_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Anduane Homogo ibugua Mosesehondo lamialu lalu, Isaraele wali agali karume i̱hondo widi lomabu ngule yalu ibiyagua nde tígua widi andane bu wahowa widi ibuni dambuwa balawa bayaleore ogoni yalu ibalu i̱nihondo lomabu ngulene nga. Balawa ogoniha olibe lininaga weli maru odo wialu ira hagua nga bilo delaga ale inisenesibi maru ogoni biamaga howa ");
INSERT INTO hui_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Arono aria loma binigo mo miaga agali karu ti karia yalu puwa mulene nga. Ani biragola loma binigo mo miaga agali kago aria mbiragome ibunaga gi balawa biagoha ibira halu balawa emene maru gime yamialu olibe lininaga welibi hagua nga bilo delaga mini inisenesibi heba lomabu delaga dabu ngagoria ira dedagoha delolebira. Balawa emene ogonime nuha dewa henedaruni delai holenedagua emene ogoni dege Anduane Homogohondo lomabu mulebira. Ani loma buwa delaragola Anduane Homogo ibugua widi lomabu deledagonaga tumutumu baya birago nga halu ibugua turu timbuni halu miniha dungulo holebira. ");
INSERT INTO hui_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Ani buwa balawa maru wirago loma binigo mo miaga agali karu ti nolene nga. Balawa wali agalime Anduane Homogohondo lomabu yalu ibini ogoni wali agali ta nabi nai haga ndo loma binigo mo miaga agali karu tinaga hangu wulebira. ");
INSERT INTO hui_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Tígua mberedi abeneha hiralu howa ogoni aria maru Anduane Homogohondo lomabu mule lowa hirayagua nde mberedi ogoni yidi nahe howa hirulene nga. Balawa biago hanguha olibe lininaga weli ibira howa mberedi wabuwa ogoni yalu puwa lomabu mulene nga. Mberedi nawabuleyagua nde mbisigedi hangu hiruwa olibe lininaga weli ngagome ha̱i̱ howa lomabu yalu polene nga. ");
INSERT INTO hui_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Balawa lomabu yalu polenaga parabane ngagoria hirarimiyagua nde balawa bayaleore yidi nahe hiralimu. Balawa ogoni olibe lininaga weli ngago odo biamaga howa hiralimu. ");
INSERT INTO hui_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Ani buwa balawa ogoni emene budabaga buwa olibe lininaga weli odo wialu Anduane Homogohondo lomabu milimu. ");
INSERT INTO hui_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Tígua mberedi lomabu mulenaga todobene be timbuni ngagoha hirarimiyagua nde balawa bayaleorebi olibe lininaga weli odo biamaga howa yidi nahe hiralimu. ");
INSERT INTO hui_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Anidagua bialu hiru yalu Anduane Homogohondo lomabu mule loma binigo mo miaga agali kago mule yalu pilimu. Ani beramigola loma binigo mo miaga agali kago ibugua lomabu delaga dabu kagoria yalu polebira. ");
INSERT INTO hui_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Ani buwa mani loma binigo mo miaga agali biagome mberedi mbisigediyaguabi ogoninaga budini mbira yalu puwa tomo dewa uruni miradagua mo loma bialu irani dai helo lomabu delaga dabu kagoria delolebira. Ani biragola nga bayaleore howa Anduane Homogohanda turu halu ibuni miniha dungulo holebira. ");
INSERT INTO hui_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Ani buwa mberedi mbisigediyaguabi maru ngago loma binigo mo miaga agali karu tinaga wulebira. Tígua mberedi mbisigedibi Anduane Homogohondo mule lomabu yalu pirimigo ibira hayagua loma binigo mo miaga agali karu ti nolebira. Agali maru karu ti loma binigo mo miaga ndo heagua tomo ogoni aria mbira ti nolene nawi. ");
INSERT INTO hui_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Mberedi balawaru mbira Anduane Homogohondo lomabu mulene yalu polenaga hirarimiyagua nde yidiru mone tara mbiranaga ibaneru biamaga howa hirinigo Anduane Homogohondo lomabu delolene nawigo manda bilimu. ");
INSERT INTO hui_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Uruni tígua widiru tínaga mabu hengedemigoha pigane denegonaga Anduane Homogohondo lomabu mialu yalu eberemingi lomabu milimu. Anigo Anduane Homogo ibugua loma uruni irame dai haragola nga howa turu halu miniha dungulo helo manda buwa irani nadelalimu. ");
INSERT INTO hui_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Widi lomabu delaramigo bibahendengi ibi howa delalimu. Ibi howa delaramigo irane Anduane Homogo heba habo nalolene bi lo wirimigo mo tene halu anidagua bilimu. Lomabu delalu howa bibahendengi widi heba ibi haabo halimu. Widi bali damenego bibahende ibi naheore howa nadelalimu. ");
INSERT INTO hui_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Tínaga mabuha widibi balibi pigane denegonaga gandulalu howa Anduane Homogohondo lomabu mule lini uruni maru hiruwa maru dambu gingirulo baga buwa emene halu balawa kagola Anduane Homogonaga yu pilimu. ");
INSERT INTO hui_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Tígua widi irani dai helonaga ani lomabu delalu howa olibe lininaga weli biamaga halu ira hagua ngabilo delaga inisenesibi daligani wialu delalimu. ");
INSERT INTO hui_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Tínaga loma ogoni lomabu delaradagua widi ogoni ariabi olibe lininaga welibi inisenesibi emene mbira yamigi bialu irani do dapelo loma binigo mo miaga agali kago ibugua lomabu delolebira. Ogoni tínaga widi gandulowa dambinigo loma bialu Anduane Homogohondo mirimigoni irani do ira punga helonaga ani lomabu delolebira, lene. ");
INSERT INTO hui_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Anduane Homogo ibugua Mosesehondo Isaraele wali agaliru lamilonaga bi lamialu lalu, Mbiralime Anduane Homogola ho gimbu bulenaga lomabu delolene manda biyagua nde ibunaga nogo bulumaga angibuni wangabeyaguabi mbirago dere durubi mbira nabi tingini bayale habatigi kago hondowa lomabu mulene nga. ");
INSERT INTO hui_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Ibugua nogo bulumaga biagonaga haguaneni gi wialu Anduane Homogonaga Balai Anda kago haneni bolebira. Ani baragola nogo darama ngago Arono aria loma binigo mo miaga agali karu tigua hambu yalu puwa lomabu delaga dabu kagonaga gibuni maria ngagoha odo baamu nana bulebira. ");
INSERT INTO hui_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Ani bialu agali o biago ibunime nogo ogoni podalu mbirini maru loma binigo mo miaga agali kago ibugua Anduane Homogohondo lomabu delelo mo mulene nga. Ibugua nogo ogoninaga tinibi habane abenerubi ");
INSERT INTO hui_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","luhabane lilini kira abenebi heba bunibi mulene nga. ");
INSERT INTO hui_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Ani miragola loma binigo mo miaga agali karu tigua mo yalu puwa lomabu delaragola Anduane Homogo ibugua nga bayaleore birago hondowa ibu turu halu bu miniha dungulo holebira. ");
INSERT INTO hui_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Agali mbirame nogo sibi memeru angibuni wangabeyaguabi Anduane Homogola ho gimbu bulenaga lomabu mulene manda biyagua nogo sibibi memebi ogoni ibu dere durubi mbira nabigo hondowa bo lomabu mulene nga. ");
INSERT INTO hui_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Agali mbirame nogo sibi mbira Anduane Homogohondo lomabu mule manda bu heagua nde nogo sibi ogoni Anduane Homogo ibuninaga deni haru halu ibulene nga. ");
INSERT INTO hui_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","Haru íbu helowa ibugua nogo sibi ogoninaga haguaneni gi wialu Anduane Homogonaga Balai Anda kago haneni haru halu puwa bolene nga. Ani biragola loma binigo mo miaga agali kagome nogo sibi darama ngago hambu yalu puwa lomabu delaga dabu kagonaga gibuni maria ngagoha odo baamu nana bulebira. ");
INSERT INTO hui_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Ani biai howa sibi podowa loma binigo mo miaga agali kagome Anduane Homogonaga lomabu delelo mulene nga. Ibugua sibi abene habanebi bayale damene bu karubi ereneha habane kagobi mulene nga. Erene mbolombolone unura modawenehayagi gaibu dali holene nga. Ani bialu abene gugunibi bu mulene nga. ");
INSERT INTO hui_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","Ani bialu nogo sibi luhabane lilini kirabali heba abene kagobi buni kagobi lomabu mulene nga. ");
INSERT INTO hui_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Ogoni bibahende loma binigo mo miaga agali kagome mo yalu puwa lomabu delaga dabu kagoria delai holebira. ");
INSERT INTO hui_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Mbiralime nogo meme mbira lomabu mulene manda biyagua Anduane Homogonaga deni haru halu polene nga. ");
INSERT INTO hui_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","Haru puwa agali biago ibugua meme haguaneni ibunaga gi wialu Anduane Homogonaga Balai Anda kago haneni bolene nga. Bope kagola meme darama ngago loma binigo mo miaga agali kago ibugua hambu yalu puwa lomabu delaga dabu gibuni maria ngagoha odo baamu nana bulebira. ");
INSERT INTO hui_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Ani bialu agali ogoni ibugua nogo podowa Anduane Homogohondo lomabu miragola loma binigo mo miaga agali kagome Anduane Homogonaga lomabu delaga dabu kagoria lomabu delolebira. Agali biago ibugua nogo ");
INSERT INTO hui_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","luhabane lilini kirabalibi abene habanebi bunibi bibahende lomabu delolene nga. ");
INSERT INTO hui_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Loma binigo mo miaga agali kago ibugua nogo meme ogoni mo yalu puwa lomabu delaga dabu kagoria irame dai helo lomabu delaragola Anduane Homogohanda turu halu bu miniha dungulo holebira. Nogo meme habane abene damene bibahende Anduane Homogonaga dege nga. ");
INSERT INTO hui_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Isaraele wali agali tígua nogo habane daramaru nolene nawigo nanalimu. Nanolenego nanalimuore laro. Tíguabi tínaga waneigini aguaneneru mani hama polobadarubi tínaga mana ogoni wia a̱i̱ helonaga ani bilimu. Tígua dindi tara ngaruha pu howabi mana ogoni dege yu tiga biaabo halimu, lalu Anduane Homogohanda lene. ");
INSERT INTO hui_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Anduane Homogo ibugua Mosesehondo lalu, ");
INSERT INTO hui_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","Isaraele wali agali bu karu ogodagua lamibe. Wali agali mbirame ibu minime ko bero mitangi nabi howa Anduane Homogonaga mana lowini ngago mbira puguayagua ogoni mana ko biyagoni. Anidagua biyadagonaga ibugua ibunaga ko ngago Anduane Homogohanda domo wahelo biagane mana ngago talialu mbirale lomabu mulene nga, lene. ");
INSERT INTO hui_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","Mosesehanda laabo halu lalu, Loma binigo mo miaga agali haguane timbuni kago ibunime mana ko ngago biyagua ibugua hangu binime wali agali bibahende mo ko hai holebira. Anidagua biyadagonaga ibugua nogo bulumaga wangabe dalua mbira ibunaga tingini dere durubi nabi habatigiore kago haru halu puwa ibuninaga ko domo wahelo Anduane Homogohondo loma bialu bo delolene nga. ");
INSERT INTO hui_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Ibugua bulumaga ogoni haru halu Anduane Homogonaga Balai Anda kagonaga haneni pu helowa nogo biago haguaneni ibunaga gi wialu Anduane Homogonaga deni howa nogo bolebira. ");
INSERT INTO hui_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Ani bowa loma binigo mo miaga agali haguane timbuni kago ibugua bulumaga biagonaga darama hambu yalu Balai Anda kagoha anda polebira. ");
INSERT INTO hui_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Yalu puwa ibugua darama biagoha ibunaga gi hondone mbirani wai howa Balai Anda tamuha Hobane Loma Bia Heneore helo hobaki bini labolabo timbu gerela kagoria daramame kahalu tandala ba haragola Anduane Homogo de hondolebira. ");
INSERT INTO hui_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Ani biai halu hagua nga bilo inisenesi lomabu delaga dabu Anduane Homogonaga deni kagoria polebira. Puwa lomabu delaga dabu ogoninaga gibuni mariani nogo bulumaganaga ne gayane ale maria kago nogo darama yayagome ha̱i̱ holebira. Ani bialu nogo bulumaga bo wiyagonaga darama maru ngaru mo yalu puwa lomabu delaga dabu li tagirani Balai Anda kagoha haneni yalu puwa lomabu delaga dabu kago dindiha odope hai holebira. ");
INSERT INTO hui_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Ani buwa ibugua nogo bulumaga ogoninaga habane abenebi tinibi ");
INSERT INTO hui_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","luhabane lilini kirabi bunibi bu yai holebira. ");
INSERT INTO hui_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","Ani bialu loma binigo mo miaga agali kagome nogo uruni lomabu delaga dabu kagoria irame dalu do ira punga helo delolebira. Anduane Homogola ho gimbu bulenaga loma bini irani dai helaga ngadagua dege dai helolebira. ");
INSERT INTO hui_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Anigo nogo ogoninaga dongonebi kuni mbirini ngarubi gi gebi haguanebi nogoni henego bibahende mo yalu ");
INSERT INTO hui_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","balai anda bu karu helalu tagira puwa ira punga hilo yu pu wahaga ngagoria dindi ogoni Anduane Homogonaga deni bayale ngago ogoriani ira bo delowa nogo podene uruni irame dalu do ira punga helo delolebira, lene. ");
INSERT INTO hui_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Anduane Homogo ibugua Mosesehanda Isaraele wali agali lamilonaga ogodagua lene. Isaraele wali agalime ko bero mitangi nabi howa Anduane Homogonaga mana mbira puguayagua nde tigua mana ko dege biya. ");
INSERT INTO hui_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","Anigo mani howa tigua ko ogoni birimada lo manda biyagua nde nogo bulumaga wangabe dalua mbira haru halu puwa ko domo wahelonaga bo lomabu delolene nga. Tigua nogo ogoni Anduane Homogonaga Balai Anda kagoria haru halu ibulene nga. ");
INSERT INTO hui_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Ani buwa Anduane Homogonaga deni Isaraele agali haguane karu tigua nogo bulumaga ogoninaga haguaneni gi wialu nogo bolene nga. ");
INSERT INTO hui_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Ani bo ngagola loma binigo mo miaga agali haguane timbuni kago ibugua bulumaganaga darama Anduane Homogonaga Balai Anda kagoha yalu anda polebira. ");
INSERT INTO hui_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Yalu puwa ibugua darama biagoha ibunaga gi hondone mbirani wai howa Balai Anda tamuha Hobane Loma Bia Heneore helo hobaki bini labolabo timbu gerela kagoria daramame kahalu tandala ba haragola Anduane Homogo de hondolebira. ");
INSERT INTO hui_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Ani bialu bulumaganaga darama gi hondoneme wai howa ira hagua ngabilo inisenesi lomabu delaga dabu Anduane Homogonaga deni kagonaga gibuni mariani nogo bulumaganaga ne gayane ale maria wabu helene kago ha̱i̱ holebira. Ani bialu bulumaga biagonaga darama maru ibira harago mo yalu puwa lomabu delaga dabu kago dindiha odope hai holebira. ");
INSERT INTO hui_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Ani bialu mani nogo ogoninaga habane abenebi kago damene lomabu delaga dabu kagoria lomabu delai holebira. ");
INSERT INTO hui_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Loma binigo mo miaga haguane kago ibugua bulumaga ogoni ibuninaga ko biyago domo wahelo lomabu bo delayadagua dege delolebira. Anidagua bialu loma binigo mo miaga haguane timbuni kago ibugua wali agalime ko biyago domo wahelonaga loma bialu delolebira. ");
INSERT INTO hui_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Ani bialu mani nogoni hene damenego bibahende balai anda bu karu helalu mo yalu tagira puwa ibuninaga ko domo wahelo lomabu delaga wiyadagua dege ira bo delowa bulumaga biago irani dai helo lomabu delolebira. Wali agalime bulumaga haru ibiyago tinaga ko ngago domo wahelonaga lomabu bo delole haru ibulebira, lene. ");
INSERT INTO hui_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Anduane Homogo ibugua Mosesehanda Isaraele wali agali lamilonaga ogodagua lene. Agali haguane mbirame ibu ko bero mitangi nabi howa Anduane Homogonaga bi mana lowini ngago puguayagua nde ibugua mana ko biyagoni. ");
INSERT INTO hui_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","Mani howa ibugua mana ko biruda lo manda biyagua nde nogo meme wangabe mbira dere durubi nabi bayaleore kago lomabu bo delole haru halu ibulene nga. ");
INSERT INTO hui_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Haru halu ibuwa Anduane Homogonaga deni howa nogo biagonaga haguaneni ibunaga gi wialu nogo bo lomabu delole bagane ngagoria haru halu ibuwa bolene nga. Nogo meme ogoni agali haguane biagome ko biyago domo wahelonaga loma binigo mo miaga agali kagome bo delelo anidagua bulene nga. ");
INSERT INTO hui_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Ani bo ngagola loma binigo mo miaga agali kagome nogo meme darama ngagoha ibunaga gi hondone mbira hanguni wai howa lomabu delaga dabu kagonaga gibuni mariani nogo ne gayane ale kago daramame ha̱i̱ holene nga. Ani bialu darama maru ibira haragome lomabu delaga dabu ogoninaga dege dindiha odope hai holene nga. ");
INSERT INTO hui_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Ani bialu nogo habane abene damene ngago lomabu delolebira. Ani bialu nogo maru Anduane Homogola ho gimbu bulenaga bo lomabu delaga mana wiyadagua dege lomabu delolene nga. Anidagua bialu loma binigo mo miaga kago ibugua agali haguane biagonaga ko biyago domo wahelo loma ogonidagua bu delaragola Anduane Homogohanda agali haguane biagonaga ko biyago domo waholebira, lene. ");
INSERT INTO hui_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Anduane Homogohanda Mosesehondo wali agali lamilonaga bi lamialu lalu, Wali agali mbiragome ko bero mitangi nabi howa Anduane Homogonaga mana lo ngago mbira puguayagua ibuha ko wu holebira. ");
INSERT INTO hui_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","Mani howa ogoni mana ko biruda lo manda birangi ibunaga ko ogoni biyadago domo wahelo ibugua nogo meme angibuni mbira dere durubi nabi bayaleore kago haru halu bo lomabu mule haru ibulebira. ");
INSERT INTO hui_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Haru ibuwa ko domo wahelo nogo loma bialu irame dai helo bo delagane ngagoria íbu helowa ibunaga gi nogo meme haguaneni wialu nogo ogoni bolebira. ");
INSERT INTO hui_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Ani baragola loma binigo mo miaga agali kago ibugua meme darama gi hondone mbirame wai howa lomabu delaga dabu kagonaga gibuni mariani nogo bulumaganaga ne gayane ale maria wabu heledagoria ha̱i̱ holebira. Nogo meme darama maru ibira haragome lomabu delaga dabu kago dindiha odope hai holebira. ");
INSERT INTO hui_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Ani bialu nogo meme ogoninaga habane abeneru lomabu delaga ngagoria lomabu delolebira. Loma binigo mo miaga agali kagome nogo maru ngago Anduane Homogola ho gimbu bulenaga lomabu delagadagua dege delolebira. Ibugua nogo habane abeneru dabuni lomabu delaragola Anduane Homogohanda nga bayaleore birago nga howa turu halu dungulo holebira. Anidagua bialu loma binigo mo miaga agali kago ibugua wali agalime ko biyagonaga loma bo delaragola ko binidagoni Anduane Homogohanda domo waholebira. ");
INSERT INTO hui_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","Wali agali mbirame ibunaga ko domo wahelonaga nogo sibi mbira bo lomabu mulene manda biyagua nde ibugua nogo sibi angibuni mbira igini nawini dere durubi nabi kago haru ibulene nga. ");
INSERT INTO hui_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Ani haru ibuwa ibugua sibi haguaneni ibunaga gi wialu irani dai helo bo lomabu delole baga ngagoria howa bolene nga. ");
INSERT INTO hui_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Bo ngagola loma binigo mo miaga agali kago ibugua sibi darama gi hondone mbirani ha̱i̱ howa lomabu delaga dabu kagonaga gibuni mariani nogo bulumaganaga ne gayane ale kagoria ha̱i̱ holebira. Darama maru ibira haragome lomabu delaga dabu kagonaga dindihayagi odope hai holebira. ");
INSERT INTO hui_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Ani bialu nogo habane abeneru lomabu delaga dabu ngagoria lomabu delolebira. Loma binigo mo miaga agali kago ibugua Anduane Homogola ho gimbu bulenaga lomabu delaga mana ngadagua bo delolebira. Ibugua habane abeneru lomabu delaga dabu kagoria loma marubi heba Anduane Homogohondo lomabu mialu irame dalu do ira punga helo lomabu delolene nga. Anidagua bialu loma binigo mo miaga agali kagome wali agali ogonime ko biyagonaga loma bo delaragola ibugua ko ogoni binidagoni Anduane Homogohanda domo waholebira, lene. ");
INSERT INTO hui_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Anduane Homogo ibugua Mosesehondo Isaraele wali agaliru lamilonaga bi lamialu lalu, Agali mbira kagohondo mendealime ko biyago hendeneyaguabi bi layago hale heneyaguabi uruni godini latagi hole íbu laragola ibugua latagi hole napeyagua nde agali ogoni ibu mana puguayagome ibuha ko ngelo holebira. ");
INSERT INTO hui_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Agali mbiragome mini pu taraho howa mbirale ko nga lalu lowinigo ela hayagua nde ibubi Anduane Homogonaga deni ko henego ka. Mana ogonidagua bialu nogo tara tarabi ema bialu piaga bedarubi uruni aria mbirago Anduane Homogohanda ko dodohe lenego ogoni homo ngaria mbiralime de nahende ibalu hengedayagua nde agali biago ibubi dodohe ho ka. Ibugua ogoni biyago mitangibu dai biyagua nde ibuha ko para hayadane hondolebira. ");
INSERT INTO hui_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Agali mbira ibu mitangi nabi howa wali agali mendenaga mbirale ko dodohe lene ngaru ela hayagua nde ibubi Anduane Homogonaga deni dodohe ka. Agali ogoni ibu mani mitangibu dai bialu karia nde mana ko birudane handa walia holebira. ");
INSERT INTO hui_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Mbiralime ibu mini baya hangu haru ha nabi howa bi bame abale latagi halu heneneore laro lalu gi do larogoni layagua nde ibugua Anduane Homogonaga deni koore biragoni. Mani howa o biagome mana ko biruda lo mitangi biyagua nde ibuha ko ngelo ka. ");
INSERT INTO hui_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Mbiralime ibuha ko ogonibi ngelo ko lo mitangi bu heagua nde ko ogoni ngelo dongeho ha nabi latagi hai holene nga. ");
INSERT INTO hui_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","Ani bialu ibugua ko ogoni biyagonaga nogo sibi memeyaguabi angibuni mbira loma bialu bo delole haru halu ibulene nga. Ani haru ibiragola loma binigo mo miaga agali kago ibugua agali o biagome ko biyago domo wahelonaga bo lomabu delaragola Anduane Homogohanda ko biyadagoni domo waholebira. ");
INSERT INTO hui_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Agali mbirago ibu nogo meme sibiru bo lomabu mulenaga muni nawiyagua nde ibu ega malibu ale bedaru aria kira minu yalu Anduane Homogohanda ibunaga ko biyago domo wahelo lomabu mule yalu ibulene nga. Anidagua biragola ega mendego ko domo wahelonaga loma bialu bo delalu mendegobi nde loma bialu irani dai helo delolene nga. ");
INSERT INTO hui_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Ani bialu ega kira ogonilabo yalu ibuwa loma binigo mo miaga kagohondo miragola ibugua ega mendego agali ogoni ibunaga ko ngago domo wahelo lomabu mulebira. Ani bulenaga loma binigo mo miaga kagome ega haguane pugulani hondowa dege ma minu ndelalu bolebira. ");
INSERT INTO hui_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Ani bialu eganaga darama emene mbira lomabu delaga dabu ngagoria tandala bahalu maru dabu andaneha odope hai holebira. Ko binigo domo wahelonaga ega ogoni loma bialu bo mulebira. ");
INSERT INTO hui_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Mani loma binigo mo miaga agali kago ibugua ega mende biagobi irani dai helonaga loma bialu bo delolebira. Ibugua manani bulene winigo ngadagua talialu bulebira. Ani bialu agali biagome ko biyago domo wahelonaga loma binigo mo miaga agali ibugua bo lomabu delaragola ko biyadagoni Anduane Homogohanda domo waholebira. ");
INSERT INTO hui_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Ainde agali mbira ibu ega yolo bulene muni nakarulapeyagua nde wahalu balawa widinaga dambini bayaleore ngago aria kilogarama mbira ale lomabu mule yalu ibulene nga. Balawa ogoni ko domo wahelonaga ngago widi lomabu delaga ale ndogo manda bialu tígua olibe lini welibi ira hagua nga bilo delaga inisenesibi mo biamaga nahe balawa dege lomabu yalu ibulene nga. ");
INSERT INTO hui_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Ani yalu ibiragola loma binigo mo miaga agali kago ibugua balawa biago lomabu miradagua nuha henenego emene gi mbira yamialu delolebira. Ani bialu loma binigo mo miaga agali kago ibugua loma maru ngaru heba biamaga howa lomabu delolebira. Balawa ogoni ko domo wahelonaga lomabu delolebira. ");
INSERT INTO hui_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Anidagua bialu loma binigo mo miaga agali kago ibugua ko domo wahelonaga lomabu delaga dabu ngagoria lomabu delaragola Anduane Homogohanda agali biagome ko biyadagoni domo waholebira. Ani bialu balawa maru ibira harago loma binigo mo miaga agali karu tinaga wiagadagua dege wulebira, lene. ");
INSERT INTO hui_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Anduane Homogohanda Isaraele wali agaliru Mosesehanda lamilo bi ogodagua lamini. ");
INSERT INTO hui_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","Mbiralime Anduane Homogohondo lomabu mulene winigo mitangi nabi howa mo waho hayagua agali ogonidagua birago ibuha ko ngelo kagoni. Ani ngago mitangi bialu agali ogoni ibugua ibuha ko ngagonaga Anduane Homogohondo dano hangaradagua bialu ibuhondo lomabu mulene nga. Ibugua nogo sibi wangabe bayaleore mbira dere durubi nabi kago yolo ogodaguame bibehe ledago hondowa Anduane Homogohondo lomabu mule loma binigo mo miaga agali biago karia haru ibulene nga. ");
INSERT INTO hui_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Ani bialu agali ogoni ibugua abale Anduane Homogohondo mule lowa lahondo hayagonaga marubi mo tago howa yu ibulene nga. Ibugua duria agima mulene winiyagua nde duria dano hayadago mialu waragane tago howa mulene nga. Ibugua mbirale uruni loma binigo mo miaga agali kagohondo mulene nga. Ani miragola loma binigo mo miaga agali kago ibugua yamialu nogo sibi ogoni agali biagome ko biyadagoni domo wahelonaga loma bialu bo delolebira. Ani biragola Anduane Homogohanda agali biagonaga ko ngago domo waholebira. ");
INSERT INTO hui_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Mbiralime ko bero mitangi nabi howa Anduane Homogonaga mana ngago puguayagua nde Anduane Homogonaga deni ibuha ko ngelo ka lolebira. ");
INSERT INTO hui_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Ani manda bialu ibugua mbirale biako henedago mo tiga bialu ko ngago domo wahelo mbirale loma bialu bo mule loma binigo mo miaga agali kago karia yalu ibulene nga. Agali biago ibugua nogo sibiyaguabi memeyaguabi wangabe bayaleore habatigihe dere durubi mbira nabi kago ibu yolo ogodagua mibehe kagobi hondowa loma binigo mo miaga agali kago mule haru ibulene nga. Haru ibiragola loma binigo mo miaga agali biago ibugua nogo sibi haru ibirago hondowa agali ogoninaga ko domo wahelo loma bialu bo delolebira. Ani biragola Anduane Homogohanda agali biagome ko biyadagoni domo waholebira. ");
INSERT INTO hui_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Nogo sibi ogoni agali biagome Anduane Homogonaga deni mana ko binigonaga loma bialu bo delolene nga, lene. ");
INSERT INTO hui_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Anduane Homogo ibugua Mosesehondo Isaraele wali agali lamilonaga lamialu lalu, ");
INSERT INTO hui_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","Agali mbirame ibunaga nenege mbiranaga mbirale mbira handayaho howa mani mbirale ogoninaga anduane biagohondo yadai nabiyagua nde ibuha ko wulebira. Mendealinaga mbirale mo page biyaguabi mo hondo howa mbirale ibu mo yayaguabi ");
INSERT INTO hui_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","mbirale mbira ibira halu porago hondowa mani ibugua ke̱ howa lalu, Heneneore larogoni i̱ de nahendeore, layaguabi nde ibugua ogoni koore biragoni. ");
INSERT INTO hui_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","5","Mbirali mana ogonibi biaga kago ibu ko bira. Anidagua biyagua ibugua page biagadagua bialubi ke̱ howa mo hondo halubi mo yayago ibugua anduane biago yadai bulene nga. Ibugua ko biyadago mo tiga bialu loma bialu bo delarangi mbirale mo page binidaru heba yadai biai holebira. Ibugua duria mo yiniyagua nde waragane tago howa yadai bulene nga. ");
INSERT INTO hui_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Ibugua ko biyadago mo tiga bialu ibunaga ko domo wahelonaga nogo sibi memeyaguabi wangabe mbira Anduane Homogohondo loma bialu bo mule loma binigo mo miaga agali karia haru ibulene nga. Agali ogoni ibugua nogo sibi memeyaguabi dere durubi mbira nabi bayale kago ibu yolo ogodaguame bibehe ledago hondowa loma binigo mo miaga agali kagohondo mulene nga. ");
INSERT INTO hui_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Ani miragola loma binigo mo miaga agali biago ibugua agali biagonaga ko domo wahelonaga nogo biago loma bialu bo delaragola Anduane Homogohanda agali biagome ko biyadagoni domo waholebira, lene. ");
INSERT INTO hui_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Anduane Homogohanda Mosesehondo lamialu lalu, ");
INSERT INTO hui_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","Aronobi ibu igini karubi tihondo mbirale loma bialu irame dai helo loma bialu bo delolenenaga mana lamibe. Tigua loma ngaru lomabu delaga dabu ngagoria delaragola dalu kane dege mbiraga halu gao lolebira. Anidagua bilonaga ira hundia nabi dalu egabi lelolene nga. ");
INSERT INTO hui_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Ani dai kagola mani loma binigo mo miaga agali ibugua ibunaga darasibi aga luni biagimbu bulenebi labolabo baya tara mbirame wabinigo mo karulalu puwa lomabu delayago dai kagola ira pungabi nogo bene dabuni ngarubi bibahende dabu kago andane dindiha hilope holebira. ");
INSERT INTO hui_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Ani biai howa ibugua aga bu hayago golo ngelowa mende karula aribia halu ira punga nogo bene biaru hilo yalu balai anda bu karu helalu tagira puwa dindi mbira mebia nahene i̱naga deni bayale ngagoria haealo ngelalimu. ");
INSERT INTO hui_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Anigo ira lomabu delaga dabuni dedago ibu hundia nabilo daho wiaabo helolene nga. Gao laragola loma binigo mo miaga agali kago ibugua lomabu delaga dabu biagoria ira maru delalu egerebaginaga lomaru irame dai helo lomabu delolebira. Nogo habane abeneru Anduane Homogola ho gimbu bulenaga lomabu delolene nga. ");
INSERT INTO hui_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Lomabu delaga dabu ngagoria ira dene dedago hundia nabilo daho wiaabo helalimu, laya lene. ");
INSERT INTO hui_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Anduane Homogohanda Mosese lamialu lalu, Isaraele wali agalihondo ogodagua lamibe. Widi dambini balawa lomabu delolenenaga mana ogodagua bulene nga. Arono aria loma binigo mo miaga agali karume Anduane Homogo i̱nihondo balawa lomabu delole howa lomabu delaga dabu ngagoria kawareni yalu ibulene nga. ");
INSERT INTO hui_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Loma binigo mo miaga agali kago ibugua balawa gi mbirame yamialu welibi heba biamaga hene ngagobi ira hagua ngabilo delaga inisenesibi heba lomabu delaga dabu ngagoria lomabu delolebira. Balawa emene ani lomabu delolobadagoni i̱nihondo lomabu ngule yalu ibirago bibahende delaradagua emene ogoni dege delolebira. Ani delaragola Anduane Homogo i̱nime hondowa turu halu miniha dungulo holebero. ");
INSERT INTO hui_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Balawa maru ibira hene ngaru loma binigo mo miaga agali karu ti nolebira. Tigua balawa ogoni yidi nahe hiruwa yalu tagira nape i̱naga Balai Anda kagoha howa dege nolene nga. ");
INSERT INTO hui_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Tigua balawa lomabu yu ibini uruni yidi nahe hiruwa nolene nga. Balawa lomabu delalu ibira hene ogoni loma binigo mo miaga agali karu tininagaore ngeledo. Balawa yidi nahe hirulene ngago i̱ninaga loma bia heneore ngagoni. Ogonibi dege ko binigo domo wahelonaga lomabi ko berolo mitangi nabi howa binigonaga lomabi i̱ninaga dege loma bia heneore ngagoni. ");
INSERT INTO hui_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Mani balawa yidi nahe ogoni ale hirarago Arono aguanene mani holebiraru tini hangumeore nolene wulebira. Isaraele wali agalirume i̱hondo mbirale lomabu yalu ibiraru aria loma binigo mo miaga karunagaore ngeledogo tigua naabo holene wulebira. Anigo wali agali karumebi mbirale ngarumebi mbirale loma bia hene ngago ela hayagua ogoni ibu loma bia henegonaga hongome bolebira, lene. ");
INSERT INTO hui_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Anduane Homogohanda Mosesehondo bi ogodagua lamialu lalu, ");
INSERT INTO hui_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","Loma binigo mo miaga agali Arono aria pigane dabo helarangi tigua i̱nihondo loma mbira ala bu ngulene ngago ogo. Tigua widi lomabu delolenenaga balawa maru yuwa egerebagibi alendo ni paliragolabi i̱nihondo lomabu delolene nga. ");
INSERT INTO hui_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Balawa ogoni olibe lini weli biamaga howa parabane ngagoria hirulene nga. Ani hiruwa mani dedagola gaibubaga buwa Anduane Homogo i̱nihondo lomabu ngulene nga. Ani ngiragola i̱na nga howa bayaleoredago hondowa turu halu i̱naga miniha dungulo holebero. ");
INSERT INTO hui_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Maniorebi Arono ariarume loma binigo mo miaga agali Haguane Timbuni howa tigua i̱nihondo loma ogonidagua dege bu ngiaabo holene wulebira. Ani lomabu ngialu irame dai helo delarago bibahende dalu do ira punga helo delolene nga. ");
INSERT INTO hui_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Loma binigo mo miaga agali tinime widi lomabu yalu ibirago aria tini nolene nawi. Irani dai helo lomabu delai holene nga, lene. ");
INSERT INTO hui_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Anduane Homogohanda Mosese lamialu lalu, ");
INSERT INTO hui_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","Aronobi ibu igini loma binigo mo miaga agali karubi tihondo ko domo wahelonaga lomabu delolene mana ogodagua bulene nga, lalu lamibe. Ko domo wahelonaga nogo haru halu ibuwa i̱naga deni howa bolene nga. Nogo irame dai helo lomabu delolenaga bagane ngagoria dege bolene nga. Loma ogoni i̱ninaga wiabagi heneore wulebira. ");
INSERT INTO hui_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Loma binigo mo miaga agali loma ogoni bo delalu kago ibunime nogo ogoninaga mbirini ngago i̱naga Balai Anda pabe bu yaanda hene ngago tamuhayagi howa dege nai holebira. ");
INSERT INTO hui_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Anigo agali mbira loma binigo mo miaga ndo kagobi mbirale tara ngaru ariabi mbiragome i̱naga loma wiabagi hene ogoni ela hayagua nde ogoni ibubi loma bia henegonaga hongome bolebira. Ai nogo ogoninaga darama emene mbira tinaga agani wai hayagua nde aga ogoni darama para hayadagoni i̱naga loma bia hene ngagoria ogoniha dege wayawaya bolene nga. ");
INSERT INTO hui_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Loma binigo mo miaga kagome nogo ogoni aria maru todobene be dindime wabini ngagoha dawayagua nde mani be ogoni pambulo waholene nga. Ai todobene be boronosime wabini ngagoha dawayagua nde be ogoni ibame wayawaya baya hangu bulene nga. ");
INSERT INTO hui_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Loma binigo mo miaga agali hameigini igiri agali hangume nogo ogoni nolene nga. Wali agali maru ta nabi nolene nawigo irane loma ogoni i̱ninaga wiabagi heneore ngago marume nolene nawiore. ");
INSERT INTO hui_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Anigo loma binigo mo miaga agali kago ibugua wali agalinaga ko domo wahelonaga nogo bowa ogoninaga darama maru hambu yalu i̱naga Balai Anda kagoha biabe bulene ngago bulenaga yalu ibiyagua nde loma binigo mo miaga agali karu tigua nogo ogoninaga mbirini nolene nawi. Tigua nogo ogoni irani lomabu delalu do ira punga helolene nga, lalu Anduane Homogohanda lene. ");
INSERT INTO hui_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Anduane Homogo ibugua Mosesehondo lamialu lalu, Isaraele wali agali karuhondo ogodagua lamibe. Wali agali mbirame ko berolo mitangi nabi howa binigo mo tiga bialu lomabu mulene ngagonaga wiabagi heneore nga. Loma ogoninaga mana ngago ogo. ");
INSERT INTO hui_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Tígua nogo sibi loma bialu bo delole haru halu ibuwa sibi irame dai helo delole bagane ngagoria howa bolene nga. Tígua sibi ogoni balu darama lomabu delaga dabu ngagonaga gibuni maria ngagoha odo ba amunana bilimu. ");
INSERT INTO hui_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Ani bialu sibi ogoninaga habane abene kago damene bibahende lomabu delaga dabuni lomabu wulene nga. Ani bialu ere gabone kagobi abene guguni nuni karubi bibahendeore podo lomabu wilimu. ");
INSERT INTO hui_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","Ani bialu luhabane lilini kirabali heba abene kagobi bunibi bibahende lomabu delole dugu yulene nga. ");
INSERT INTO hui_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Yalu puwa loma binigo mo miaga agali kago ibugua lomabu delaga dabuni Anduane Homogohondo lomabu mialu delai holebira. Nogo sibi ogoni mbiralime mana ko berolo mitangi nabi howa biyagua dano hangaradagua bialu lomabu mulenenaga bo delolebira. ");
INSERT INTO hui_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Loma binigo mo miaga karunaga hameigini igiri agalibi karu tigua dege nogo ogoni maru podalu nolene karulape. Nogo sibi ogoni Anduane Homogonagaore lomabu wiabagi hene winigo manda bialu tigua Balai Anda pabe bu yaanda hene ngago tamuhayagi howa nai holene wulebira. ");
INSERT INTO hui_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Ko binigo domo wahelonaga lomabu mulene manabi ko berolo mitangi nabi howa binigonaga mo tiga bialu lomabu mulene manabi kira ogoni labonaga mana mbiraore hangu nga. Ani ngagola loma binigo mo miaga agali biabe ogoni bialu kago ibunime nogo sibi ogoninaga mbirini maru podalu nolene karulape. ");
INSERT INTO hui_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Ani bialu loma irani dai helonaga nogo bo delalu nogo dongone ibira hene ngago loma binigo mo miaga agali biabe bialu kago ibuninaga wulebira. ");
INSERT INTO hui_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Anidagua dege widi dambininaga balawa parabaneni hiriniyaguabi abeneha todobene behabi hiriniyaguabi uruni aria ngago loma binigo mo miaga agali biabe bialu kago ibuni degeme nolene karulape. ");
INSERT INTO hui_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Ani bialu balawa hira nabinigo olibe lininaga weli heba mo biamaga henebi nahenebi lomabu mini ngago loma binigo mo miaga agali Arono aria karu ti bibahendeme nolene wulebira. Loma binigo mo miaga agali bibahende karu ti balawa uruni ogobi degedege talebu taho yulene nga, lalu Anduane Homogohanda Mosesehondo lene. ");
INSERT INTO hui_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Anduane Homogohanda Mosesehondo lalu, Isaraele wali agalihondo ogodagua labe. Tí Anduane Homogola ho gimbu bulenaga ibuhondo loma ogodagua bu milimu. ");
INSERT INTO hui_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Agali mbira ibu Anduane Homogohondo ka̱i̱ lalu ho gimbu bulenaga lomabu delole heagua nde nogo mbira mberedi yidi nahe hirinibi heba lomabu mulene nga. Ibugua balawa olibe lininaga weli heba biamaga howa mberedi hirini ngagobi mbisigedi maru hirini olibe lininaga welime ha̱i̱ hene ngagobi balawa olibe lininaga weli heba biamaga heneme mberedi emene mi̱li̱mo̱lo̱ wabu hirini ngarubi nde uruni yidi nahe dege lomabu mulene ngadagua mulene karulape. ");
INSERT INTO hui_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Anduane Homogola ho gimbu bulenaga lomabu mialu howa mberedi yidihe marubi biamaga howa lomabu mulene nga. ");
INSERT INTO hui_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Ani bialu ibugua mberedi uruni aria mbira mbira Anduane Homogohondo lomabu mulene nga. Mberedi uruni loma binigo mo miaga agali nogo darama lomabu delaga dabu ngagoria dindiha odope hai haga kagonaga wulebira. ");
INSERT INTO hui_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Ibugua Anduane Homogola ho gimbu bulenaga nogo bo lomabu mirago maru ibira hene ngago horo ogoningiore nai holene nga. Horo mendengi nole podo wulene nawiore. ");
INSERT INTO hui_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Agali mbirame Anduane Homogohondo bi lo winidagua bialu ibula ho gimbu bulenaga nogo loma bialu bo delole heaguabi ibunime bo mua biragobiore bo mule heaguabi loma ogoni alenaga nogo bo delarangi mbirini maru nalu maru ibira harago horo mendengi nolenebi karulape dege. ");
INSERT INTO hui_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Anigo ai horo kiru nalu howa horo tebonengibi wia dege biyagua wahalu irame dai helo iraha bape halu delalimu. ");
INSERT INTO hui_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Horo tebonengibi nogo ogoni nalu ha dege biyagua nde Anduane Homogohanda agali ogoninaga loma ogoni nayamulebira. Ani nayami howa ibugua loma ogonidagua binigo ibunaga deni dodohe ko ngubiore nga manda bialu agali horo tebonengi nogo ogoni nalu kagohondo ibuha ko ngelo ka lolene wulebira. ");
INSERT INTO hui_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Anduane Homogola ho gimbu bulenaga lomabu delole yalu ibiragonaga nogo mbirini aria mbirago Ngode Datagaliwabenaga deni ko ngagome ela hayagua nde tigua loma ogoni nolene nawigo nanalimu. Wahalu irame dai helo iraha bape halu delai halimu. Wali agali Ngode Datagaliwabenaga deni tiha ko mbira para nahe kagome ibula ho gimbu bulenaga bo lomabu mini ogoninaga mbirini ngago ibuni dege nolene karulape nga. ");
INSERT INTO hui_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Anigo mbirali ibu bayale ndo Ngode Datagaliwabe deni ko howa loma bini nogo ogoni nayagua nde ogoni ibu Ngode Datagaliwabenaga wali agali bu karu aria ndo ibu ko taraore helolebira. ");
INSERT INTO hui_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Agali mbira ibugua mbirale Ngode Datagaliwabenaga deni ko hene ngaru ela heneyaguabi ema bialu piaga ko hene ngaru ela heneyaguabi wali agali ko bini karu ela heneyaguabi urunidagua bu howa ibugua loma ogoni Anduane Homogohondo bo minigonaga ngago nayagua nde ibu Anduane Homogonaga wali agali bu karu aria ndo ka, lalu Anduane Homogohanda lene. ");
INSERT INTO hui_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Anduane Homogohanda Mosesehondo bi ogo lamialu lalu, ");
INSERT INTO hui_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","Isaraele wali agali bu karuhondo ogodagua lamibe. Tígua nogo sibi bulumaga memebi bu karunaga habane damenego nolene nawiore. ");
INSERT INTO hui_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Nogo gabua karume bulumaga mbira bo wahenebi minana homagadagua homayaguabi ogoninaga habane nolene nawigo nanalimu. Anigo habaneme biabe mende ale bulene ngago bule podo yarimiyagua nde karulape dege. ");
INSERT INTO hui_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Agali mbirame nogo bulumaga mbira Anduane Homogohondo bo lomabu delenego aria habane mbirago nayagua agali ogoni ibu Ngode Datagaliwabenaga wali agali karu aria ndogo ti heba mandagi holene nawi. ");
INSERT INTO hui_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Isaraele wali agali lene kamiru tí dindi taraha pu hemiyaguabi nogo egaru darama heba nolene nawigo nanalimuore laro. ");
INSERT INTO hui_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Mbiralime bi ogoni mo wahalu nogo egaru darama heba nayagua ogoni ibu Ngode Datagaliwabenaga wali agali bu karu aria ndo holebira, lalu Anduane Homogohanda lene. ");
INSERT INTO hui_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Anduane Homogohanda Mosesehondo lalu, ");
INSERT INTO hui_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","Isaraele wali agalihondo ogodagua lamibe. Mbiralime Anduane Homogola ho gimbu bulenaga nogo loma bialu bo delole haru halu ibiyagua nde ibugua Anduane Homogohondo nogo kuni ogo alenelaore mule lowa manda bu yalu ibulene nga. ");
INSERT INTO hui_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Agali ogoni ibuni gime nogo ogo aleore mule lalu lo wiyago lomabu delole habane abenerubi galukuni mbirinibi lomabu yalu ibuwa mulene nga. Ani yalu ibiragola loma binigo mo miaga agali kago ibugua Anduane Homogohondo ogodagua lomabu mulebira. Nogo galukuninaga mbirini biago Anduane Homogonaga deni gi dogolowa wigiwaga lalu holebira. ");
INSERT INTO hui_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Ani bialu habene abene yayaru lomabu delalu galukuni mbirini yayago loma binigo mo miaga agali Arono aria karu tini nolebira. ");
INSERT INTO hui_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Anduane Homogola ho gimbu bulenaga nogo ogoninaga ge tigahayagi loma binigo mo miaga agali kago ibu nelo burulo mulene nga. ");
INSERT INTO hui_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Loma binigo mo miaga agali Arono igini kago ogoni ibugua nogo biagonaga habane abene daramaru lomabu delalu hayago nogo ge tigahayagi ogoni ibunaga wulebira. ");
INSERT INTO hui_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Anduane Homogo ibunime nogo biagonaga galukunibi ge tigahayaginaga burulene biagobi ti Isaraele wali agalime mini biago yamialu loma binigo mo miaga agali Arono aria karu mo mulebira. Anidagua dege manibi wia a̱i̱ halu nogo puguki ogonilabo loma binigo mo miaga agalinaga lene wiaabo holebira. ");
INSERT INTO hui_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Wali agali tígua nogo galukunibi ge burulene biagobi ogonilabo lomabu mirimigo Anduane Homogo ibuninaga dege holebira. Anduane Homogo ibunime Aronobi ibu iginirubi loma binigo mo miaga helo dabo helayangi howa lalu nogo puguki ogonilabo tinaga wulebira lene wiyagoni. ");
INSERT INTO hui_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Horo ogoningi howa Anduane Homogohanda Isaraele wali agaliruhondo lamialu nogo galukunibi ge burulene biagobi ogonilabo bo lomabu mialu loma binigo mo miaga agali kago milimu lenego nga. Ani bialu mana ogoni mani wia a̱i̱ helo talialu bialu halimu, lene. ");
INSERT INTO hui_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Bi uruni loma biniru bibahendeore irani daiore helo lomabu delolenenaga mana ngagobi widi aria lomabu delolenenaga mana ngagobi ko domo wahelonaga lomabu delolene mana ngagobi mbirali ko bero lo mitangi nabi howa binigo dano hangaradagua bilo lomabu delolene mana ngagobinaga lo nga. Ani bialu loma binigo mo miaga agali helonaga loma biaho helolenenaga manabi Anduane Homogola ho gimbu bulenaga lomabu delolene manabi uruninaga lo nga. ");
INSERT INTO hui_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Bi mana uruni Isaraele wali agali ti dindi ko wali agali nahagabi iba dalu naibagabi wiagoha heangi Anduane Homogohanda Hari Sainai neneni howa Mosesehondo laminigo nga. Anduane Homogo ibunime Isaraele wali agali tigua ibuhondo loma uruniale bo mule heagola ibugua bi mana uruni lamigi bialu hene. ");
INSERT INTO hui_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Anduane Homogo ibugua Mosesehondo lalu, ");
INSERT INTO hui_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","Aronobi ibu igini karubi i̱naga Balai Anda kago haneni haru ibuwa helabe. Loma binigo mo miaga agalime aga karulagane biarubi tigua biabe ogoni bialu helo dabo helaga weli biagobi mo yalu wali agalime ko binigo domo wahelonaga nogo bulumaga wangabe mbira loma bialu bo delole haru halu nogo sibi wangabe kirabi heba haru halu mberedi yidi nahe hirini mbasigedi nu mbira heba uruni bibahende i̱naga Balai Anda kago haneni yalu ibalimu. ");
INSERT INTO hui_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Ani bialu mani wali agali bibahende i̱naga Balai Anda haneni íbu ngoai hadaba lalu lamilimu, lene. ");
INSERT INTO hui_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Anduane Homogohanda bi ogoni layago hale halu Mosese ibugua wali agali bibahende Balai Anda haneni mo ngoaiho hene. ");
INSERT INTO hui_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Ani ngoaiho heagola Mosese ibugua tihondo lamialu lalu, Mbirale i̱na áyu buleberogoni Anduane Homogo ibunime bibe lalu langiyadagua bulebero, lene. ");
INSERT INTO hui_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Ani lalu Mosesehanda Aronobi ibu igini biarubi wali agalinaga deni haru íbu helowa ti ilili biagane mana winidagua bialu ibame wayawaya bia hene. ");
INSERT INTO hui_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Ani biai howa ibugua Arononaga aga giha bulene biago ala mo karula halu aga mende luni biagimbu bulene biadambi helalu mandibu biradagua aga mbira bo bia dambi ho mabu bia hene. Ani bialu Mosesehanda aga tebone daligahayagi buha mbirahabi biadambi haga biago mini ebodi winigo Arono mo karula hene. Ani karula howa ebodinaga mandibu ale mo yaribia howa ngelenego obeneni mandibu wia howa aga biago mo ndibu lelene. ");
INSERT INTO hui_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Ani bialu aga emene mbira Arononaga galuhombeni mo karula howa aga emene nu ale ogoni wiagoha ege to̱le̱ kira mini Urimu Tumimula Anduane Homogonaga hame hale haga biagolabo nu ale ogoniha hana hene. ");
INSERT INTO hui_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Ani bialu labolabo emene luni mbira Arononaga emboneni bobu mabu bia hene. Ani buwa labolabo bo bu mabu bini biago wanakuini mbirale ngolome wabini dombo heda wiradagua mo wia halu agali ogoni ibu Anduane Homogonaga Loma Biahene ka lalu gilibu wini. Anduane Homogohanda bibe lalu lamiyadagua Mosesehanda biai hene. ");
INSERT INTO hui_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Ani biai halu mani Mosese ibugua mbirale Anduane Homogo ibunagaore wiabagi helo weli odo wiaga winigo mo yalu puwa Anduane Homogonaga Balai Anda heagobi mbirale anda ogoniha bibahende wiaru odoba hene. Anidagua biyadagonime Balai Andabi mbirale uruniha wiarubi bibahende Anduane Homogo ibuninaga wiabagi heneore wini. ");
INSERT INTO hui_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Ani bialu lomabu delaga dabu wiagobi dabu ogoriani wiaga wiarubi waya bulenenaga iba hambu wiaga ndisi bebi ibunaga wiagane dagia wiagobi weli biagome kahalu dege dege tandalaba haga bini. Anidagua biyadagome mbirale uruni Anduane Homogo ibuninaga loma bia howa wiabagi hai helene. ");
INSERT INTO hui_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Ani biai howa weli biagome Arononaga emboneni emene mbira odo wia halu bini. Anidagua biyadagome Arono ibu Anduane Homogonaga loma binigo mo miaga agaliore hene. ");
INSERT INTO hui_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Mani Mosesehanda Arono igini bu hearu haru ibuwa aga giha bulene wiaru ti mo karula hai halu labolabo luni mandibu biradagua bobu mabu bia hene. Ani bialu tinaga haguaneni tangi emene ale karula haga bini. Anduane Homogohanda anidagua bibe lalu Mosese lamiyadagua Mosesehanda hale halu bigi bini. ");
INSERT INTO hui_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Mosese ibugua uruni biai howa nogo bulumaga wangabe mbira wali agalime ko binigo domo wahelonaga loma bialu bo delole haru halu ibini. Haru íbu helowa Aronobi ibu igini biarubi tigua bulumaga haguaneni gi wiai hene. ");
INSERT INTO hui_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Ani biai heagola Mosesehanda bulumaga biago balu darama maru hambu yalu puwa gi hondoneme daramaha wai howa lomabu delaga dabu wiagonaga gibuni mariani nogo bulumaganaga ne gayane ale hearu nogo darama biagome ha̱i̱ hene. Anidagua biyadagome lomabu delaga dabu ogoni Anduane Homogonaga deni ko mbira para nahe bayaleore ngelene. Mani darama maru wiagome lomabu delaga dabu biagonaga dindiha odope hai hene. Anidagua biyadagome dabu odagoni Anduane Homogonaga wiabagi heneore wini. ");
INSERT INTO hui_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Ani bialu Mosese ibugua nogo bulumaga biagonaga habane abene buni heagobi luhabane lilini kirabalibi bibahende dabu biagoria lomabu delai hayagola dalu do ira punga halu do be hene. ");
INSERT INTO hui_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Ani bialu nogo bulumaga biagonaga podo paya bini maru ibira hene dongonebi mbirinibi tini wiarubi bibahende balai anda bu hearu tagirahayagi yalu pene. Yalu tagira puwa tagirani ira bo delowa nogoni hene damene wiago ogoriani delai hayagola do tauladaga halu ira punga hene. Anduane Homogo ibunime anidagua bibe lalu lamiyadagua bini. ");
INSERT INTO hui_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Ani biai halu mani Mosese ibu nogo sibi wangabe kira tigua haru íbu helayago aria mende heago haru ibini. Sibi ogoni loma bialu irani dai helo haru ibini. Ani haru ibalu Aronobi ibu igini biarubi tigua sibi biago haguaneni gi wiai hene. ");
INSERT INTO hui_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Ani wiyagola Mosesehanda sibi biago bowa daramame lomabu delaga dabu wiagonaga gibuni maria wiagoha odo ba amu nana biai hene. ");
INSERT INTO hui_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","21","Ibugua sibinaga darama biago odo wahalu nogo podowa tinibi baya hangu halialu ge kirabi baya hangu wayawaya biai hene. Ani biai howa uruni bibahende lomabu delaga dabu biagoria lomabu delayagola dalu do ira punga halu do be hene. Anduane Homogohanda bibe lalu lamiyadagua ani bini. Sibi o loma bialu bo delayadagoni irani dai helayagonaga Anduane Homogohanda loma ogoninaga nga baya taraore biyago nga howa ibu turu halu miniha dungulo hene. ");
INSERT INTO hui_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Ani bialu Mosesehanda nogo sibi wangabe mende ala tigua haru íbu helayagobi haru ibini. Nogo sibi ogonime loma binigo mo miaga agali helo dabo helolenenaga loma bialu bo delole Aronobi ibu igini biarubi tigua sibi ogoninaga haguaneni gi wiai hene. ");
INSERT INTO hui_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Ani biyagola Mosesehanda sibi biago bowa darama wiago emene mbira yamuwa Arononaga gi tigahayagi hale teneha ha̱i̱ halu gi tiganaga hondone angibiyanegobi ha̱i̱ halu ge tiganaga hondone angibiyanegobi ha̱i̱ dege hene. ");
INSERT INTO hui_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Ani biai halu mani Arono igini biarunaga gi tigahayagi hale teneha gi tiga hondone angibiyane kagobi ge tigaha hondone angibiyane kagobi bibahende sibi darama biarume ha̱i̱ hene. Ani bialu darama maru ibira hene wiago lomabu delaga dabu wiagonaga gibuni maria wiagoha odo ba amu nana bini. ");
INSERT INTO hui_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Ani biai halu mani Mosese ibugua sibi biagonaga habane abene damenego bibahende podo yai hene. Nogo sibi eregabone tohe heagobi tiniha nuni habane abene damene hearubi buni heagobi luhabane lilini heba abene hearubi ge tigahayaginaga burulenebi bibahende podo wiai hene. ");
INSERT INTO hui_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Ani bialu Mosese ibugua mbasigedi nuha mberedi yidi nahe hirini Anduane Homogohondo lomabu mini heneago aria mbirabi balawa olibe lininaga weli heba biamaga howa hirini mberedi heneago aria mbirabi mbisigedi mbirabi uruni tagu yini. Uruni bibahende yalu sibi biagonaga habane abene damene hearubi ge burulene tigahayaginaga wiago uruni bibahende wiagoriani mberedi mbisigedi biarume wiadambi helene. ");
INSERT INTO hui_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Ani bialu Mosese ibugua mbirale uruni bibahende Aronobi ibu iginirubi tinaga giha mo ya hayagola tigua tomo uruni mo yuwa Anduane Homogohondo gi dogolowa wigiwaga lalu mo loma bialu hene. ");
INSERT INTO hui_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Ani bialu mani tomo yu hayaru Mosesehanda yamialu sibi maru wiyaruni heba lomabu delaga dabu biagoria loma irame dai holene winigo mo paga howa irame dalu do tauladaga halu ira punga hai helene. Loma binigo mo miaga agali dabo helalu loma ogoni delayagonaga nga bayale taraore biyago nga howa Anduane Homogo ibugua turu halu miniha dungulo hene. ");
INSERT INTO hui_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Mosese ibugua sibi biagonaga galukuni biago gime yuwa Anduane Homogonaga deni gi dogolowa wigiwaga lalu hene. Sibinaga galukuni biago loma binigo mo miaga agali helonaga dabo helalu lomabu mini biagonaga Mosese ibuni sibi ogoni nolene karulape wini. Anduane Homogohanda bibe lalu lamiyadagua Mosesehanda biai hene. ");
INSERT INTO hui_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Ani buwa Mosesehanda loma binigo mo miaga agali helo dabo helaganaga weli biagobi nogo sibi biagonaga darama dabuni odo hai hene wiagobi mo yini. Mo yalu puwa ibugua Aronobi ibu igini biarubi tinaga agani tandala bahaga bini. Mosesehanda ogonidagua bialu Aronobi ibu igini biarubi Anduane Homogonaga loma biahene helalu tinaga aga biarubi bibahende Anduane Homogonaga wiabagi heneore wini. ");
INSERT INTO hui_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Ani biai howa Mosesehanda Aronobi ibu igini biarubi tihondo lamialu lalu, Ai sibi mbirini ngaru mo yalu Anduane Homogonaga Balai Anda hane ngagoria puwa todobene beha dawalimu. Ogoni dedagola mberedi mbasigedi nuha hono ngaru heba nalimu. Basigedi nu ogoniha mberedibi mbisigedibi loma binigo mo miaga agali helonaga lomabu mini biagoha hono wini. ");
INSERT INTO hui_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Tígua nogo sibi biagonaga mbirinibi mberedi mbisigedi uruni heba nalu nabe manga biyagua nde wahalu irani dai helo delalimu. ");
INSERT INTO hui_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Ani bialu tígua horo karu Anduane Homogonaga Balai Anda hane kagoria haabo halimu. Horo karu hangu howa tí loma binigo mo miaga agali howa biabe bulenaga mana bulene ngaru biai howa tagira pole hondo halimu. ");
INSERT INTO hui_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Anduane Homogo ibunime tínaga ko birimiru domo wahelonaga ogonidagua bilimu layadagua ina áyu ogoni biai haramagoni. ");
INSERT INTO hui_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Horombe mbiragabi Anduane Homogonaga Balai Anda harabani horo karu ogoni piai helo ani biraabo halimu. Ani bialu Anduane Homogo ibunime tíhondo bilimu lalu langiyaruni biai halimu. Anduane Homogohanda i̱hondo ogodagua laya, Tígua ibunaga bi larago mo waho kamiria tíni homolene wuligo de hondo halimu, laya lene. ");
INSERT INTO hui_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Anduane Homogohanda bi uruni Moseseha howa Aronobi ibu igini biarubi tihondo bulene nga layaruni layadagua tigua hale halu biai hene. ");
INSERT INTO hui_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Horo karu piai hayagola Aronobi ibu igini biarubi loma binigo mo miaga agali helonaga biabe bialu hayaruni biai hene. Ai horo halini hayagola Mosesehanda, Aronobi ibu igini biarubi Isaraele wali agalirubi bibahende íbu ngoai hadaba, lene. ");
INSERT INTO hui_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Ti íbu ngoaiho hai heagola Mosesehanda Aronohondo lamialu lalu, Nogo bulumaga dalua wangabebi nogo sibi wangabebi mbira dere durubi nabi bayaleore kago handa handa buwa haru halu ibabe. Haru ibuwa Anduane Homogonaga deni ko binigo domo wahelonaga bulumaga bo lomabu delalu sibibi irani dai helo bo lomabu delolenaga haru ibabe. ");
INSERT INTO hui_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Ani bialu ko binigo domo wahelonaga nogo meme wangabe mbira lomabu delole haru halu ibalimu lalu Isaraele wali agali lamibe. Ani bialu nogo bulumaga igini mali mbira hangu hene kagobi sibi igini mali mbira hangu hene kagobi haru halu loma buwa irani dai helo bo delole haru ibalimu lalu lamibe. Nogo uruni bayale dere durubi nabi kago hondowa haru halu ibalimu lalu lamibe. ");
INSERT INTO hui_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","Ani bialu wali agali tígua nogo bulumaga wangabebi sibi wangabebi Anduane Homogola ho gimbu bulenaga loma bialu bo delole haru halu ibalimu lalu lamibe. Tígua nogo kira ogoni heba widi dambininaga balawa olibe lininaga weli heba biamaga howa lomabu delole yalu ibalimu lalu lamibe. Ani bulene ngago áyu ogoningiore Anduane Homogo ibuni tí kamigoria tíninaga deni hapani holebirago tígua tínaga loma uruni lomabu delalu holene nga, lene. ");
INSERT INTO hui_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Ani laya handala Aronobi wali agali bu hearubi tigua Mosesehanda yalu ibalimu layaru mo puwa Anduane Homogo mitangi bialu lotu lole ibunaga Balai Anda heagoria íbu ngoai ho hene. ");
INSERT INTO hui_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Ani íbu ngoai ho heagola Mosesehanda tihondo lamialu lalu, Anduane Homogonaga wá taraore tí kamigoria hadali holebirago tí de handalimulonaga Anduane Homogo ibugua ani íbu ngoai hadaba laya, lene. ");
INSERT INTO hui_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Ani lowa Mosesehanda Aronohondo lamialu lalu, Í̠na lomabu delaga dabu ngagoria puwa í̠na ko biriru domo wahelonaga loma bialu bo delalu loma mende irani dai helo lomabu delagadagua bo delabe. Loma kira ogonibi mendego wali agalinaga ko biniru domo wahelonagabi loma bialu bo delolene nga. Ani bialu wali agali tigua lomabu mule yalu ibirarume Anduane Homogohanda layadagua tininaga ko biyadaru domo wahelo lomabu delabe, lene. ");
INSERT INTO hui_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Ani laya handala Arono ibugua ibunime ko biniru domo wahelonaga nogo bulumaga wangabe dalua biago lomabu delaga dabuni bope hene. ");
INSERT INTO hui_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Ani bope hayagola ibu igini biarume bulumaga biagonaga darama hambu miyagola ibugua darama biago gi hondoneni wai howa lomabu delaga dabu heagonaga gibuni mariani bulumaganaga ne gayane ale heago ha̱i̱ hene. Ani bialu darama maru wiago mo yalu puwa lomabu delaga dabu biagonaga dindiha odope hai hene. ");
INSERT INTO hui_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Ani bialu mani Aronohanda nogo biagonaga habane abene hearubi luhabane lilini kirabalibi buni abenebi heba bibahende podo yalu puwa irame dalu do ira punga helo lomabu delaga dabuni lomabu delene. Anduane Homogo ibunime anidagua bibe lalu Mosesehondo lamiyadagua bini. ");
INSERT INTO hui_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Ani bialu nogo podene maru wiarubi dongonebi bibahende balai anda bu hearu pabe tagirahayagi mo yalu puwa irame dai helo delene. ");
INSERT INTO hui_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Arono ibugua uruni biai halu ibuninaga sibi wangabe biago balu irani dai helo lomabu delole bene. Ani bayagola Arono igini biaru tigua nogo bayagonaga darama hambu miyagola ibugua yalu puwa lomabu delaga dabu biagonaga gibuni maria wiagoha odo ba amu nana bini. ");
INSERT INTO hui_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Ani bialu ibu igini biarume nogo haguanebi podene bibahendebi ibuhondo miai hayagola ibugua lomabu delaga dabuni irame dai helo delene. ");
INSERT INTO hui_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Ani delowa ibugua nogo tini baya hangu halialu wayawaya bo wahai halu ge kirabi wayawaya bo wahai howa bibahende daligani mo dambi howa lomabu delaga dabuni delayagola irame dalu do ira punga halu do amolaiore hene. ");
INSERT INTO hui_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Ani biai howa mani Arono ibugua wali agali tinaga loma yu ibiyaru yamialu Anduane Homogohondo lomabu migi bini. Wali agalime ko biyago domo wahelonaga lomabu bo delole nogo meme haru ibiyago yamini. Ani yamialu Arono ibugua ala bulumaga wangabe ibuninaga ko biniru domo wahelonaga lomabu bo delayadagua dege meme ogoni wali agalinaga bo lomabu delene. ");
INSERT INTO hui_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Ani buwa Arono ibugua loma irame dai helo delolene winidagua wali agalinaga loma yalu ibiyaru lomabu delene. ");
INSERT INTO hui_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Ani delalu ibugua widi dambinigonaga balawa lomabu delole yalu ibiyaru lomabu delaga winidagua delaga bini. Mana winidagua loma mende egerebaginaga ala delenego delowa ibugua widinaga balawa emene mbira gime mo yuwa irame dai helo lomabu delaga bini. ");
INSERT INTO hui_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Ani bialu mani Arono ibugua wali agalime nogo bulumaga sibi wangaberu Anduane Homogola ho gimbu bulenaga lomabu delole haru ibiyaru yamigi bialu bene. Ani bayagola ibu igini biaru tigua nogo kira ogoni labonaga darama wiago hambu miyagola ibugua mo yalu puwa lomabu delaga dabu heagonaga gibuni maria wiagoha odo ba amu nana bini. ");
INSERT INTO hui_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Ani bialu Arono ibugua nogo biago labonaga eregabone tohe wiagobi abene guguni bunibi luhabane lilinibi podo wiai hene. ");
INSERT INTO hui_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","Mbirale uruni damene nogo kirabalinaga galukunini mo dambi hai howa lomabu delaga dabu wiagoria mo yalu pene. Ani bialu habane abene podo yayago damene bibahende lomabu delaga dabuni delai hene. ");
INSERT INTO hui_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Ani buwa nogo bulumaga sibi biagobi kirabalinaga galukunila ge tigahayagi burulene mbirala podo yuwa Mosesehanda bibe lalu lamiyadagua Anduane Homogonaga deni gime yuwa wigiwaga lalu mini. ");
INSERT INTO hui_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Ani bialu Arono ibugua loma uruni bibahende Anduane Homogohondo lomabu miai howa lomabu delaga dabu biagoria howa ibunaga gi kirabali wali agali heagoha dogola amu halu lalu, Anduane Homogohanda tí mo bayale helo, lowa ibu lomabu delaga dabu biagoria howa dalipe hene. ");
INSERT INTO hui_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Ani bialu Mosese Aronobi libu haru Anduane Homogonaga Balai Anda biagoha anda pene. Anda puwa tagira ibalu howa libugua wali agalihondo Anduane Homogohanda tí mo bayale helo lalu hebiore Anduane Homogonaga wá taraore hapani hayagola wali agali bibahende bu hearume de handai hene. ");
INSERT INTO hui_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Ani bialu abaleore aube tobane buwa Anduane Homogohanda hari daligaha howa ira timbuni hungu bialu dalipe helowa lomabu delaga dabu biagoria mbirale lomabu wiago damene bibahendeore dai helene. Anidagua biyago wali agali bu hearume de hondowa tigua turu timbuni halu ku lowa bi dalimu lalu dindini bulu palene. ");
INSERT INTO hui_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Horo ogoningi Arono igini kirali Nadaba Abihulame ira hagua ngabilo lomabu delaga inisenesi wiago libuninaga parabane ale wiago mo yalu puwa ogoriani delaga bialu hene. Libugua ira denebi inisenesibi parabane aleni mo ngelowa Anduane Homogonaga lomabu yalu pugu bialu hene. Ani biyagola Anduane Homogo ibugua mana ogonidagua bilibu lalu mbira nalenego libugua biyago ibunaga ndoyane handalu ibu turu nahe hene. ");
INSERT INTO hui_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Ani biyagola Anduane Homogohanda ibuha howa libu hearia ira abaleore bape hayagola ira biagome igiri biagolabo dalu Anduane Homogonaga deni howa do homelene. ");
INSERT INTO hui_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Ani biyagola Mosesehanda Aronohondo lalu, Bamba Anduane Homogohanda ogodagua laya. I̱naga biabe biaga howa i̱ni kogoria kaware ibiraru tigua i̱ habane nabulene ale ndo i̱ Anduane Homogoore kogo manda bialu ibulene nga. Tigua anidagua biyagua nde i̱na i̱ninaga hongo holene timbuni gibiore ngogobi wá taraore holene ngogobi wali agalihondo mo walia holebero, laya, lene. Ani layagola Arono ibugua hale howa bi mbira ladai nabi hene. ");
INSERT INTO hui_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Ani buwa Mosesehanda Arono aba hamene heyogone Usiele igini kirali Misaele Elesabanala heago ibilo olene. Ibiyagola Mosesehanda libuhondo lamialu lalu, Libu hamenenaga tingini o ngago mo ibalu Anduane Homogonaga Balai Anda kago yu wahalu wali agalinaga balai anda bu kago tagirahayagi yalu pilibu, lene. ");
INSERT INTO hui_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Ani layago hale halu libugua agali biagolabonaga tingini mo puwa Mosesehanda bilibu lalu lamiyadagua balai anda bu hearu yu wahalu tagiraha yalu pene. Ani buwa libugua homene biago labonaga aga golo wa nahe aga karuleaore aga heba yalu pene. ");
INSERT INTO hui_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Ani biyagola Mosesehanda Aronobi ibu igini Eleasa Idamalabi tihondo lalu, Tígua agali kirali homayagonaga dara howa biaga ale nabi wahalu tínaga mandariru pere nabi ha ndo pere biaabo halu agaru minu lere nale dara ho nahalimu. Tígua dara ho howa biaga ngago mbira birimiyagua nde Anduane Homogohanda tíhondo keba timbuni halu tí homalimulo bo wahalu ina Isaraele wali agali kamaru bibahendehondobi keba hai dege holebirago ani nabilimu. Isaraele wali agali tínaga damene maru karu tigua dege Anduane Homogo ibuni ira hedo bape halu agali kira bo heda hayagolabo dara halu helo. Tíni dara nahalimu. ");
INSERT INTO hui_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","I̱na tí Anduane Homogo ibunagaore habagi halimulonaga weli oda wiaga biagome tíni odo wialu helarugo ai ibunagaore loma bini kamigoni. Anigo Balai Anda o kago wahalu tagira nape anda ogoha haabo halimu, lene. Tigua Mosesehanda bi ogoni layago hale howa ti tagira nape tamuha haabo hene. ");
INSERT INTO hui_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Anduane Homogohanda Arono lamialu lalu, ");
INSERT INTO hui_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","Í̠nibi í̠ igini karubi tígua waini ibabi mbiabi nalu i̱naga Balai Anda o kagoha anda polene nawigo napilimu. Anda pirimiyagua nde homoleberemigo manda bilimu. Tínaga igini aguanenebi mani hama polobadaru tiguabi nde mana ogoni dege talialu haabo holene wulebira. ");
INSERT INTO hui_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Tígua i̱naga Balai Anda kagoha biabe bialu howa mbirale bibahende i̱naga ogoore ngagoni wali agalinaga ogoore ngagoni lalu minime mo tale buleberemi. Ani bialu i̱naga deni mbirale ngaru ko bayale lalu tale bulene nga. ");
INSERT INTO hui_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Ani bialu i̱naga bi mana Mosesehondo lamirugo damene bibahende tígua Isaraele wali agali karu baya hangu lawai halimu, lene. ");
INSERT INTO hui_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Mosesehanda Aronobi ibu igini kirali Eleasa Idamalabi ti tebiralihondo lamialu lalu, Tígua widi dambini balawa Anduane Homogohondo lomabu minigo maru ibiraho ngaru mo yuwa mberedi yidi nahe wabilimu. Balawa ogoni Anduane Homogo ibuninagaore wiabagi ho ngagoni. Anigo ai tígua mberedi wabuwa lomabu delaga dabu ngagoria kaware biruwa nalimu. ");
INSERT INTO hui_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Tí Anduane Homogonaga Balai Anda kagoha pabe bu yaanda hene tamuhayagi howa nalimu. Wali agalime widi Anduane Homogohondo lomabu minigo ogoni tínibi tí iginibi tínaga leneore wiaa̱i̱ holebirago nalimu. Anidagua bulene nga, lalu Anduane Homogohanda i̱hondo abale langiya. ");
INSERT INTO hui_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Tínibi tínaga waneiginirubi tígua nogo galukunibi ge tiganaga ge burulenebi Anduane Homogonaga deni howa gime yuwa wigiwaga lenego ogoni tínaga ngago nalimu. Anduane Homogonaga deni dindi mebia nahene daba bagi hene mbira ngane hendedemigoria nogo mbirini lomabu mini uruni yu puwa nalimu. Mbirini uruni Anduane Homogola ho gimbu bulenaga Isaraele wali agalime loma binigo mo miaga agali tí kamirubi tí waneiginirubi tí nalimulonaga talebu wini nga. ");
INSERT INTO hui_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Anduane Homogohanda lenedagua wali agalime nogo bulumagaru sibirunaga galukunibi ge tigahayaginaga burulenebi habane abene guguni nuni karubi lomabu ngirago yamialu Anduane Homogonaga deni gime yuwa wigiwaga lalu halimu. Anidagua biai howa habane abene podo yarimigo irani lomabu delalu galukunibi ge burulene biagobi tíni nole mo yalimu. Anduane Homogo ibunime nogo puguni kira ogonilabo tíbi tí aguanene mani holobadarubi tínaga wiaa̱i̱ holebira lalu laya, lene. ");
INSERT INTO hui_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Mani howa Mosesehanda hale halu lalu, Nogo meme ko biniru domo wahelonaga bo lomabu delolene biago agua biyabe, layagola tigua ladai bialu lalu, Abale irani lomabu delai harima, lene. Ani ladai biyagola Mosese ibugua Eleasa Idamalahondo keba howa lalu, ");
INSERT INTO hui_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","Ai ko biniru domo wahelonaga nogo meme loma bialu bene biago tígua Anduane Homogonaga Balai Anda kagoha nolene ngago nanarimigo irane agibe. Loma ogoni Anduane Homogo ibunime wali agalinaga ko ngago domo wahelonaga loma bo delene biago tí mo ngiyagoni ndobe. ");
INSERT INTO hui_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Nogo meme ogoninaga darama Balai Anda biagoha hobane loma biahene kagoha i̱na bialu halimu lalu langirudagua nabi nogo meme darama yalu anda nape howabi nolenego tamu hobane ogoniha howa nolene ngagobi nane dege harimiyago irane agibe, lene. ");
INSERT INTO hui_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Ani layagola Aronohanda Mosesehondo ladai bialu lalu, Hale harene. Áyu ogoni wali agalime tinaga ko ngaru domo wahelonaga lomabi irani dai helonaga lomabi Anduane Homogohondo lomabu miyagoni. Ani birugoni bilowa gendabi ogoni i̱ha anda ibiyago aginagadabe. Iname nogo áyu bo miyagonaga mbirini nedamale nde Anduane Homogohanda turu ho kaledabe, lene. ");
INSERT INTO hui_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Aronohanda bi ani layago hale howa Mosese ibugua bi ogoni karulapeda lo manda bialu ibunaga miniha dungulo hene. ");
INSERT INTO hui_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Anduane Homogohanda Mosese Aronola lamialu lalu, ");
INSERT INTO hui_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","3","Isaraele wali agali bu karuhondo ogodagua lamilibu. Ema bialu dindini piaga damene tí nolene ngago ogo. Nogo tinaga gi ge giba kira hanguhe tomo datani hangu naga nogo bulumaga aria kago balu nalimu. ");
INSERT INTO hui_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","6","Anigo ai nogo kamelebi huru ale mini labidibi pagana ale egeha paliaga bedarubi nolene nawi. Urunime datani naga degego tinaga gi ge giba kira ndo tara tara ka. Anigo i̱naga deni uruni ti bayale ndo dodohe kago manda bialu tígua nolene nawiore. ");
INSERT INTO hui_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Nogo ibuniore kagobi tinaga ge bulumaga ale degegoyu ti tomo maginiha yuwa nanagayagodago uruni balu nolene nawi laro. Nogo ibuni i̱naga deni ko dodohe kagonida lo manda bilimu. ");
INSERT INTO hui_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Ema bialu piaga uruni ti balu nolenebi nawi uruni ale mbirago homo ngagola ela holenebi nawiore irane ti i̱naga deni ko dodohe kagodane, laro. ");
INSERT INTO hui_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Ibaha iba wena bedaru damene bibahende dongone harenehe bedarubi babaganehe bedarubi iba emeneha bedarubi solowaraha bedarubi uruni ale bibahende nai holene karulapego balu nalimu. ");
INSERT INTO hui_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Anigo wena marubi ema biaga alebi iba emenehabi solowarahabi bedaru tinaga dongoneni harene nahebi babagane nahebi bedaru bibahende ko beda lo manda bialu bo nolene nawi. ");
INSERT INTO hui_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Anigo uruni ti i̱naga deni ko dodohe manda bialu tígua balu nabi homene ngago elabi heba holene nawiore larogoni. ");
INSERT INTO hui_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Baya hanguore lone hale hadaba. Ibaha wena bedaru aria maru harene nahe babaganebi nahe bedaru ko bedago nolene nawiore, larogoni. ");
INSERT INTO hui_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","19","Ega tara tarabi nde tígua nanolene bedaru uru. Ega parambaguabi bodo hariawe tara tara emene timbuni bedaru bibahendebi ega umi damenego ale bibahendebi ega nene bedarubi ega yári timbuni tara karubi ega dindiha biraga bedarubi ibaha biraga ega habo ale tara tara bedarubi ega ge luhe ngui luhe gabiago ale tara tara bedarubi nolene nawi. Ani bialu dalagamiabi dumaniabi ti aria tara tara bedaru bibahende nolene nawiore laro. ");
INSERT INTO hui_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Ema bialu piaga maru gi ge waragariahe babaganehe bedaru nolene bayale ndogo nanalimu laro. ");
INSERT INTO hui_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Anigo ai mbirale uruni aria maru geme pogolama piagayagua nde balu nolene karulape. ");
INSERT INTO hui_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Uruni gonalia alebi pagaya damene bedago bibahende emene timbunibi nai holene karulape laro. ");
INSERT INTO hui_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Ani bialu maru gi gebihe howa babaganebihe bedaru ko bedago nolene nawigo nanalimu. ");
INSERT INTO hui_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","Ema bialu piaga tara maru bedarubi nde i̱naga deni tí mo dodo holigo nanalimu. Tígua mbirale ema bialu piaga ko urunialenaga tingini homene ngago ela harimiyaguabi ");
INSERT INTO hui_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","mbirale uruni mbirago mo yalu pirimiyaguabi nde ani biragome ibu i̱naga deni dodohe kane dege alendo halu ni anda polebira. Agali mbirame uruniale mbira homo ngaria mo yayagua nde ibunaga aga bu kago wayawaya bo waholene nga. Ani biragome ibu i̱naga deni dodohe kane dege alendo halu ni anda polebira. ");
INSERT INTO hui_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Ema bialu piaga damenego tinaga ge giba kirahe ndoyaguabi bulumagame datani maginiha yuwa nagadagua nanagayaguabi ogonialego koore nga lo manda bilimu. ");
INSERT INTO hui_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Nogo tara tara ge giba kira nahe kago damene bibahende balu nolene nakarulapeore laro. Mbiralime mbirale homene uruni alegonaga tingini ela hayagua nde ti ko kamine dege alendo halu ni anda polebira. ");
INSERT INTO hui_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Mbiralime ogoni ale mbira homenego mo yalu piyagua ibunaga aga wayawaya bolene nga. Ani wayawaya bayaguabi ibuni dodohe ko kane dege alendo halu ni anda polebira. Ema bialu piaga urunialeme tí mo dodo haga bedagoni. ");
INSERT INTO hui_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","30","Ema bialu piaga ale marubi nde tia mali bedarubi huru bedarubi guruwalibi gau tara tara bedarubi nolenebi ela holenebi nawiore. ");
INSERT INTO hui_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Tígua uruni ale mbira homo ngaria ela harimiyagua nde tí i̱naga deni dodohe kamine dege alendo halu ni anda polebira. ");
INSERT INTO hui_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Ema bialu piaga dodohe uruni aria mbirago mbirale ngagoriani homo wiagua ogoni ela hayadago nde i̱naga deni dodohe dege wulebira. Ai mbirale irame wabini tara tara ngagoria homo wiaguabi labolaboni homo wiaguabi nogo bulumaga dongone lagalo wini ngagoria homo wiaguabi nuni homo wiaguabi uruni ale bibahende mbirago ibu biabe tara biaga wiaguabi bibahende homene ela hayadagome i̱naga deni ko dodohe wulebira. Anigo mbirale ela hayadago ibame wayawaya bo waharimiyaguabi i̱naga deni ibu dodohe wiaho ngane dege alendo halu ni anda polebira. ");
INSERT INTO hui_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Uruni ale mbira todobene be dindime wabini ngamigoha anda puwa homo ibiraho wiagua nde todobene be ogoniha ngamigo damene i̱naga deni ko dodohe dege wulebirago todobene be ogoni pambulo wahalimu. ");
INSERT INTO hui_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Tomo nolene ale mbira kaware ngagola iba todobene be ogoniha berenegome odoba hayagua nde tomo ogoni i̱naga deni ko dodohe hayagoni. Iba todobene be ogoniha bedagobi ko dodohe dege birulebira. ");
INSERT INTO hui_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Mbirale bayale tara tara ngagoria ema bialu piaga uruni mbirago homo paga hayagua nde mbirale uruni i̱naga deni ko dodohe hayagoni. Ai ira delowa mberedi balawaru hiragane dindime wabini ngagoha homo wiyagua nde mberedi hiragane dindime wabini ogoni mo pambulo wahalimu. ");
INSERT INTO hui_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Anigo ai ema bialu piaga i̱naga deni dodohe uruni aria mbira iba hambiaga uli iba bedagoha homo wiagua nde iba ogoni i̱naga deni mo dodo naholebira. Anigo maru tara ale ngaru ela hayagua nde ela harago i̱naga deni ko dodoheore wulebira laro. ");
INSERT INTO hui_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Ai tomo egene wene nahenge ngamigoha mbirale biago homo ibira hayagua nde egene ogoni i̱naga deni dodo nahe bayale wiaabo holebira. ");
INSERT INTO hui_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Anigo ai tomo egene uruni ibaha ngaore dege ema bialu piaga mbira iba ogoniha homo wiagua nde tomo egene biago i̱naga deni ko dodohe wulebira. ");
INSERT INTO hui_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","Ema bialu piaga maru i̱na tíhondo nolene karulape larugo uruni aria mbirago bame homene ngaria wali agali mbirame ela hayagua o ela harago ibu i̱naga deni dodohe holebira. Ani dodohe dege kane alendo halu ni anda polebira. ");
INSERT INTO hui_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Mbiralime homene biagonaga mbirini ngago podalu nayaguabi homo ngaria mo ya hangu biyaguabi nde o biyagonaga ibu aga karulo kago wayawaya bulene nga. Anigo ibuni i̱naga deni dodohe kane dege alendo halu ni anda polebira. ");
INSERT INTO hui_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Ema bialu dindini ibagabu biraga emene ko biru ngaru tígua uruni minalu nolene nawigo nanalimu. Uruni ti bayale ndo bedago nanalimu laro. Dereparia ale uruni ti i̱naga deni koore beda lo mitangi bilimu laro. ");
INSERT INTO hui_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Tombeme piaga uruni ale bedarubi gi ge bibahendeme piaga bedarubi gi ge dewahe bedarubi bibahende ta nabi nanalimu laro. ");
INSERT INTO hui_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Ainde ema bialu piaga uruni balu narimiyagua tígua i̱naga deni tíni ko mo dodo holeberemigo nanalimu larogoni. ");
INSERT INTO hui_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","I̱ Anduane Homogo tínaga Ngode Datagaliwabeore kogonigo ai tígua mana tiga nabi ngago yu wahalu tíni i̱hondo ngialu mana bayale ngago bialu howa i̱naga deni baya buruguleore halimu. Irane i̱ni hangu baya burugule howa mana i̱na talialu biaga ngogo bayalebi tigabiorebi biaga kogo manda bialu mbirale tombeme piaga bedarubi nolene nawi laro. Tí i̱naga deni ko dodohe holigo ani bilimu. ");
INSERT INTO hui_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","I̱ Anduane Homogo i̱nime tí Iyibi dindiha hemiria i̱ni tínaga Ngode Datagaliwabeore holenaga haru tagira ibirugoni ndobe. Anidagua birugo mitangi bialu tígua mana tigabi ngaru dege bialu haabo howa wali agali baya buruguleore hole halimu. Ani larogoni irane i̱ni baya buruguleore howa mana i̱nime berogo bayalebi tigabibi bialu kodagua tíguabi bialu halimu larogoni. ");
INSERT INTO hui_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Mana áyu dege langirugoni ema bialu piaga damene bibahende ega bedarubi ibaha wena tara tara biru ngarubi dindini ibaga bialu piaga bedarubi uruni bibahendenaga laro. ");
INSERT INTO hui_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Ani larogo manda bialu tíni bayale holenebi tíni i̱naga deni ko dodohe holenebi ngago baya hangu manda bialu mo tale bialu halimu. Ani bialu mbirale ema bialu piaga uruni bibahende baya hanguore tígua nalu holenebi nanaga alebi mo tale bialu halimu, lalu Anduane Homogohanda lene. ");
INSERT INTO hui_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Anduane Homogohanda Mosesehondo lamialu lalu, ");
INSERT INTO hui_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","Í̠na Isaraele wali agali lamialu wali mbirame yamu ko biruwa igiri mbira taba hanayagua ibu horo karu i̱naga deni dodohe wali ti horo kongi biragagobi beda. ");
INSERT INTO hui_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Anidagua bialu horo halini haragola igiri gali biagonaga dongone podo mabu bulene nga. ");
INSERT INTO hui_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Wali igiri gali ai̱yadago ibuni horo pira tebirani tebira (33) bolangua haragola ibu i̱ninaga deni dodo nahe birulebirago irane ibugua waneigini taba hanayangi darama dewaore piai hayagonaga anidagua bulebira. Ani biruwa mbirale i̱ninaga mo loma biahene ngaru aria mbira ela naholebiraore. Ani buwa i̱naga Balai Anda kagoha anda nape biraabo halu ibunaga horodago bolangua haragola i̱ninaga deni dodo nahe biruwa anda polebira. ");
INSERT INTO hui_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Walime wandari gali taba hanayagua nde ibu horo pira mbirani maria (14) i̱naga deni dodohe wali ti horo kongi biragagobi beda. Ani biralu ibugua darama dewaore wahayagonaga horo pira waragariani waragaria (66) bira dege bialu mani i̱naga deni dodo nahe birulebira. ");
INSERT INTO hui_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Horo uruni piai haragola waneigini ai̱ya mo bayale holenaga wali ibugua nogo sibi bayale karu aria igini hungubalua mali mbira pene kagobi ega malibu ale mbirabi loma bule yalu ibulene nga. Ani bialu nogo sibi igini ogoni irani dai helo lomabu bo delalu ega minu yayago ibu ko berenego mo tiga bilonaga loma bialu bo delolene nga. Anidagua bule loma kira ogonilabo yalu i̱naga Balai Anda kago haneni loma binigo mo miaga agali kagoria yalu ibulene nga. ");
INSERT INTO hui_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Ani yalu ibiragola loma binigo mo miaga agali kago ibugua nogo ega biagolabo yamialu Anduane Homogo i̱nihondo loma bialu bo delaragola wali biago ibu i̱naga deni dodo nahe bayale birulebira. Walime wandari taba hanayaguabi igiri taba hanayaguabi mana ogonidagua dege bulene nga. ");
INSERT INTO hui_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Anigo ai wali ogoni ibu nogo sibi igini mbira hende holenego muni nayi bereagua nde ibugua ega malibu ale bayale kira minu yalu ibulene nga. Ani biragola loma binigo mo miaga agali kago ibugua ega ogonilabo yamialu mendego irani dai helo loma bialu bo delalu mendego ko berenego mo tiga bilonaga loma bialu bo delolebira. Anidagua bo deledagola i̱naga deni wali biago ibu dodo nahe bayale birulebira, lalu Anduane Homogohanda lene. ");
INSERT INTO hui_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Anduane Homogohanda Mosese Aronolahondo lamialu lalu, ");
INSERT INTO hui_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","Wali agali mbirago ibu dere biyaguabi tinginini to halu moge biyaguabi tinginini ge hamua bulenaga pagaya tagira ibiyaguabi urunidagua birago ibu Arono kariayaguabi loma binigo mo miaga agali mbirago kariayaguabi abale haru polene nga. ");
INSERT INTO hui_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Ani haru poramigola loma binigo mo miaga agali kago ibugua de handalu karia dere bidagoria irini kago pele halu dere tinginiha gua bima anda piyagua nde ogoni ge hamua ale bulenaga bidaria hondolebira. Ani hondowa loma binigo mo miaga biago ibugua de handalu karia mbira derebi kago hondowa ibu Anduane Homogo deni bayale ndo dodohe ka lolebira. ");
INSERT INTO hui_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Anigo ai ge hamua ale biatagi nahe bulenaga pagaya bidago hondowabi derebi biago tinginini dere bidagoria irini karubi pele nabidaore tinginiha gua bima anda napedaore loma binigo mo miaga agali kago ibugua derebi biago anda mbira kagoha horo karu ibuni hangu ho palu helolebira. ");
INSERT INTO hui_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Ani helowa loma binigo mo miaga agali biago ibugua horo kaneni lone handalu karia dere bia timbu nahe abale biyagobi dege bidaria handayagua nde horo karu mende hadai bilolebira. ");
INSERT INTO hui_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Ani bilowa loma binigo mo miaga agali biago ibugua lone horo waragaru howa kanengi handalu karia dere biago bia timbu nahe bu emene hama dai bialu dabi habehe degeyagua nde bame dere damene bidagoni lo manda bulebira. Anidagua manda bialu ibugua mbirali derebi hayago lamialu, Í̠ Anduane Homogonaga deni dodo nahe bayale kegoni, lalu lamulebira. Anidagua lamiragola agali biago ibugua ibunaga aga wayawaya bialu ibu Anduane Homogonaga deni dodo nahe bayale holebira. ");
INSERT INTO hui_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Anigo mani howa dere ogoni lone biyagua agali biago ibugua loma binigo mo miaga agali kagome lone hendelo ibu karia polene nga. ");
INSERT INTO hui_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Ani poragola loma binigo mo miaga agali kago ibugua de handalu karia dere lone bia timbu hayadane handayagua nde ogoni ge hamua ale bida manda bulebira. Ani manda buwa loma binigo mo miaga agali kago ibugua lalu, Ogoni ge hamua ale biyadago ai í̠ Anduane Homogonaga deni dodohe kegoni, lalu lamulebira. ");
INSERT INTO hui_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Mbirali ibu dere timbuni mbira bu heagua nde loma binigo mo miaga agali karia haru polene nga. ");
INSERT INTO hui_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Ani haru poragola loma binigo mo miaga agali kago ibugua dere ogoni baya hangu hondolebira. Ani handalu karia dere bidago pele halu dere bidagoria irini kagobi pele dege howa dere ibuni angibu tugudatagi halu heagua ");
INSERT INTO hui_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","ogoni ge hamua aleore bu wiaabo heneyane manda bulebira. Ani manda buwa loma binigo mo miaga kago ibugua, Í̠ Anduane Homogonaga deni dodohe kegoni, lolebira. Loma binigo mo miaga ibugua agali ogoni dodoheoredane handalu wali agali heba mandagi helolene nawi. ");
INSERT INTO hui_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Ani bialu emene howa dere ogoni bia timbu taraore halu agali biagonaga tingini bibahendeha biame hayagua nde ");
INSERT INTO hui_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","loma binigo mo miaga kagome agali ogoninaga tingini lone baya hangu hondolebira. Ani handalu agali biagonaga tingini bibahendeha pagaya biame heagua nde loma binigo mo miaga biago ibugua agali pagayabi biagohondo lamialu lalu, Í̠ Anduane Homogonaga deni dodo nahe bayale ke, lolebira. Ani laragola agali ogoni ibu dodo nahe bayaleore holebira. ");
INSERT INTO hui_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Ani lo karia mani howa agali biagonaga tinginiha howa dere timbuni tugudatagi hayagua nde agali ogoni ibu lone dodoheore holebira. ");
INSERT INTO hui_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Loma binigo mo miaga ibugua lone handalu karia agali biagonaga dere biago bia timbu kane handayagua nde ibugua agali ogoni lamialu, Í̠ Anduane Homogonaga deni dodoheore kegoni, lalu lamulebira. Mbirali dere timbuni bialu tinginiha bidago dombeni tugudatagi heagua nde ogonidagua bidago ibu dodohe ka lolebira. Dere ogoni alego ko taraore mbira nga. ");
INSERT INTO hui_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Mani howa agali dere bu hayago ibunaga dere biago dabi halu hununu bidagoria pagabua biyagua nde agali ogoni ibu loma binigo mo miaga biago karia lone dai bulene nga. ");
INSERT INTO hui_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Ani dai biragola loma binigo mo miaga kagome de handalu karia dere bini hununu biagoria pagabua bialu dabi hayadane hondowa dodo nahe ka manda bulebira. Ani manda buwa loma binigo mo miaga ibugua agali biagohondo, Í̠ Anduane Homogonaga deni dodo nahe bayale harida, lalu lamulebira. ");
INSERT INTO hui_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Agali mbiranaga tingini moge ala binigo dabi ho kayagua ");
INSERT INTO hui_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","nde mani howa dere hununu biagoriani tohoyu tagira ibalu darama bialu pagabua biyagua agali o biago ibu nde loma binigo mo miaga mbira kagome hendelo ibu karia polene nga. ");
INSERT INTO hui_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Ani poragola loma binigo mo miaga kago ibugua agua biyadabe hondole moge bini biagoria hondolebira. Ani handalu karia dere biago bia timbu howa kabaneha bima anda pialu dere bidagoria irini pele kago hondowa ibugua agali o biagohondo lalu, Í̠ Anduane Homogonaga deni dodohe kegoni, lalu lamulebira. Moge binidagoria dere bia aribia hene ogoni koorene ko nga. ");
INSERT INTO hui_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Anigo loma binigo mo miaga kago ibugua handalu karia dere biago emene karulapeni irini kago pela nabi howa dere bidago gua bima anda pobe nahe mani bayale habehedane handayagua nde agali ogoni ibuni hangu anda mbiraha horo karu helo helolebira. ");
INSERT INTO hui_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Horo waragaru howa kanengi loma binigo mo miaga kagome lone handalu karia dere biago bia timbu hayadane handayagua nde ogoni koore bidago manda buwa ibugua lamialu lalu, Í̠ Anduane Homogonaga deni ko dodohe kegoni, lalu lamulebira. ");
INSERT INTO hui_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Anigoyu dere hununu biago timbu nahedane handayagua nde bame moge binigonaga motudu nga hondowa loma binigo mo miaga kagome ibuhondo lamialu lalu, Ai í̠ Anduane Homogonaga deni dodo nahe bayale kegoni, lalu lamulebira. ");
INSERT INTO hui_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Anigo mbiralinaga tingini irame denegoria tingini darama bialu pagabua biyaguabi ");
INSERT INTO hui_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","nde loma binigo mo miaga kagome baya hanguore hondolene nga. Ani handalu karia irame dene biagoria irini kago pelayaguabi dere bidago bima anda piyaguabi nde dere koore mbira bidaria hondolebira. Ani bidago hondowa loma binigo mo miaga kago ibugua lamialu lalu, Í̠ Anduane Homogonaga deni bayale ndo ko dodohe kegoni, lolebira. ");
INSERT INTO hui_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Anigo ai dere binigoria irini karu penale bayale halu derebi timbu naheyagua nde agali ogoni ibuni hangu anda mbiraha horo karu helo helolene nga. ");
INSERT INTO hui_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Ani helowa horo waragaru howa kanengi loma binigo mo miaga ibugua dere lone agua biyadabe hondolene nga. Ani handalu karia dere bia timbu hayayagua nde dere ogoni koore bidago hondowa ibugua agali ogoni Anduane Homogonaga deni dodohe kagoni lolebira. ");
INSERT INTO hui_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Ainde dere ogoni timbu nahe biyagobi bu haabo heagua nde agali irame dene hununu bidago handalu motudu dege ngago manda buwa loma binigo mo miaga ibugua lamialu lalu, Ai í̠ Anduane Homogonaga deni dodo naheore bayale kegoni, lolebira. ");
INSERT INTO hui_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Wali agali mbiralinaga embonenibi yanga andanehabi duru dere biyagua ");
INSERT INTO hui_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","loma binigo mo miaga kagome baya hangu hondolebira. Ani handalu karia dere kabaneha bima anda pialu dere bidagoria irini kago emene hangu howa ambua biyagua nde ibugua dere ogoni kooredane manda bulebira. Ani manda buwa ibugua waliyaguabi agaliyaguabi lamialu lalu, Í̠ Anduane Homogonaga deni bayale ndo dodohe kegoni, lolebira. ");
INSERT INTO hui_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Ai loma binigo mo miaga ibugua handalu karia dere ogoni kabaneha bima anda nape dere binidagoria irini bayale nahe dege heagua nde waliyaguabi agaliyaguabi ogoni ibu horo karu anda mbiraha ibuni hangu palu helolebira. ");
INSERT INTO hui_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Horo waragaru howa kanengi loma binigo mo miaga ibugua dere bini biago agua biyadabe lone hondolebira. Ani handalu karia dere bia timbu halu bima andapu nabiyagua irini ambua nabi bayale heagua ");
INSERT INTO hui_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","nde o biago ibugua ibunaga mandari angariyaguabi kago podo wahai halu dere binidagoria dege poda nabi helolene nga. Ani bialu loma binigo mo miaga ibugua agali biago horo karu lone ibuni hangu helo helolene nga. ");
INSERT INTO hui_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Ani bialu horo waragaru howa kanengi loma binigo mo miaga ibugua dere biyago lone handalu karia emene halu timbu bima anda napeyaguabi nde ibugua o biagohondo lamialu, Ai í̠ Anduane Homogonaga deni dodo nahe bayale kegoni, lalu lamulebira. Ani laragola ibugua ibunaga aga bu hayago wayawaya bialu ibu bayale holebira. ");
INSERT INTO hui_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Mani dere biago lone bia timbu hayiyagua ");
INSERT INTO hui_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","nde loma binigo mo miaga ibugua lone hondolene nga. Ani handalu karia dere biago biatimbu hayadane hondowa loma binigo mo miaga kagome waliyaguabi agaliyaguabi ogoni dere bidagoria irini kago lone ambua biyadabe hondolene nawi. Ibugua o biago ibu Anduane Homogonaga deni lone dodoheore hayada manda bulebira. ");
INSERT INTO hui_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Ai loma binigo mo miaga ibugua hondowa walibi agalibi ibunaga dere emene biyagobi dege biaabo halu timbu nahebi dere bidagoria irini bayale ibiyagua nde dere ogoni dabi hayada lo manda bulebira. Ani manda buwa ibugua o biagohondo lamialu lalu, Ai í̠ Anduane Homogonaga deni dodo nahe bayale kegoni, lalu lamulebira. ");
INSERT INTO hui_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Wali agali maru tinaga tinginini pagaya biyagua nde ");
INSERT INTO hui_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","loma binigo mo miaga ibugua agua biyadabe hondole baya hangu begelo hondolebira. Ani handalu karia pagayadago peleore ndoyagua nde bame dege binidane manda bulebira. Ani manda bialu karia walibi agalibi ibu dodo nahe bayaleda lolebira. ");
INSERT INTO hui_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","41","Agali mbirago ibunaga mandari kago bame piai halu mandari nahe heagua ogoni ibu dodohe ndo bayale ka. Ani bialu agali ogoninaga mandari wanakuihayagi piai hayagua nde agali ogoni ibu dodohe ndo bayale ka. ");
INSERT INTO hui_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Anigo agali ogoninaga haguaneni mandari nahe ngagoria dere biyago darama bialu pelayagua nde dere ogoni koore biyada manda bulebira. ");
INSERT INTO hui_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Ani manda bialu loma binigo mo miaga ibugua baya hangu begelo hondolene nga. Ani handalu karia ge hamua ale biagadagua dere darama bialu peledago handayagua ");
INSERT INTO hui_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","nde dere emboneni bidago koorene ko binidane hondowa ibugua agali dere bu kagohondo, Í̠ Anduane Homogonaga deni bayale ndo dodohe kegoni, lalu lamulene nga. ");
INSERT INTO hui_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Wali agali mbira ibu dere ko ogoni ale bu heagua ibu aga ko budabagabi ngago mo karulo halu mandari pere nabi helalu ibunaga gime ne hariga pai howa ibugua hongo howa lalu, I̱ ko ge hamuabi kogoni. I̱ ko ge hamuabi kogoni, laga bialu holene nga. ");
INSERT INTO hui_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Wali agali dere ogonibi bu karu bibahendeore Anduane Homogonaga deni ti bayale ndo dodohe dege haabo holebira. Ani biragola ibugua ibunaga damene bu karu ti tini haga balai anda bu kagoha helalu ibu tagiraha pubagi ho holebira, lalu Anduane Homogohanda lene. ");
INSERT INTO hui_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","48","Anduane Homogohanda Mosese Aronolahondo laabo halu lalu, Aga labolabo mbirale ngamirubi nogo sibi irinime wabini ngarubi pu payini baya tara mbirame wabini ngarubi nogo bulumaga dongoneme wabini ngarubi nogo maru maru dongoneme wabini ngarubi uruni ale ngamiruha hagama ho ngane handarimiyagua ");
INSERT INTO hui_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","mbirale ogoni ira yuni dongomi hayaguabi daramabi hayaguabi uruni tígua loma binigo mo miaga karia mo yalu puwa walia holene nga. ");
INSERT INTO hui_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Ani bialu loma binigo mo miaga ibugua aga ogoni yamialu horo karu anda mbiraha mo ngelolebira. ");
INSERT INTO hui_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Ani ngelo howa horo waragaru howa kanengi lone handalu karia aga labolabonibi nogo dongone biagoriayaguabi hagama ha timbu hayane handayagua nde ogoni ko dodohe ngagonida manda bulebira. ");
INSERT INTO hui_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Ani manda buwa loma binigo mo miaga ibugua mbirale uruni hagama hayadago hondowa ge hamua wai hole biagadagua biyadane hondowa wahalu irani dai helo delolebira. ");
INSERT INTO hui_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Loma binigo mo miaga agali kagome aga biago handalu karia ko timbu nahe ala wiyagobi dege ngane handayagua ");
INSERT INTO hui_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","nde aga mbirale uruni baya hangu wayawaya bo wahowa horo karu lone mo bagi howa ngelolene nga. ");
INSERT INTO hui_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Ani ngelowa horo waragaru howa kanengi lone handalu karia aga biagoni buhayagibi mbirahayagibi hagama hayago ha timbu nahe ala wiyagobi dege wiagua ira yuni dongomi hayagobi daramabi hayagobi ereba nahe wiaabo hayagua nde ogoni bayale ndo dodohe dege ngagoni. Anigo loma binigo mo miaga ibugua aga uruni mialu iraha dai helo delolene nga. ");
INSERT INTO hui_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Anigoyu ibugua horo waragaru howa horo kanengi lone handalu karia aga labolabobi nogo dongoneme wabini agayaguabi wayawaya bu wini biago hagama hayago ereba habehe wiane handayagua nde emene mo ko hayadago hangu podo waholene nga. ");
INSERT INTO hui_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Ani biragola mani howa hagama ala hayagobi lone hadai biyagua nde wahalu mbirale ogoni anduane kago ibunime irani do tauladaga helo delolene nga. ");
INSERT INTO hui_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Ai aga hagama hayago wayawaya buwa bayale hayiyagua nde halu mende lone wayawaya bialu aga labolaboyaguabi nogo dongoneme wabini agayaguabi ko nahe bayaleore wulebira. ");
INSERT INTO hui_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Mana ogoni aga mbiraleru nogo bulumaga dongoneme wabini ngarubi labolabo ngarubi pu nogo sibi irinime payini ngarubi bibahende mo ko haga biragola bulenego mana ogoni dege ngagoni. Mana ogoni Anduane Homogo i̱naga deni ogo dodoheda ogo dodo naheda lalu dabolene mana nga, lalu Anduane Homogohanda lene. ");
INSERT INTO hui_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Anduane Homogohanda Mosese lamialu lalu, ");
INSERT INTO hui_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","Mana o larodagua wali agali lamibe. Mbirali ibu ge hamua ale bu henego dabi haragola i̱ninaga deni ibu ko dodohe ndo bayale kagoni lelo ibu loma binigo mo miaga agali kago walia hole ibu karia polene nga. ");
INSERT INTO hui_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Ani poragola loma binigo mo miaga ibugua tínaga balai anda bu karuha tagirahayagi haru pialu baya hangu begelo hondolebira. Ani hondowa ge hamua ale biyago ereba hayiyagua ");
INSERT INTO hui_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","nde ibugua ibuhondo uruale mo yalu ibule pobe lolebira. Uruni ega kira i̱ninaga deni bayaleorebi ira tamia emene gabini mbirabi pu payini daramabi mbirabi ira hisobonaga magane mbirabi yalu ibalimu lolebira. ");
INSERT INTO hui_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Ani bialu loma binigo mo miaga ibugua wali agali biaruhondo, Iba duguaraga haragoha howa iba hambu yalu dai bialu todobene be dindime wabini ngagoha berelabe, lolebira. Ani bialu mani ega biago darama todobene be biagoha anda pelo nene daligani ega mendego bolebira. Ani baragola darama todobene be biagoha anda polebira. ");
INSERT INTO hui_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Ani buwa loma binigo mo miaga ibugua ega mende biagobi ira tamia gabini biagobi pu payini daramabi biagobi ira mini hisobonaga magane biagobi bibahende yamialu iba ega darama birayagoha ibira holebira. ");
INSERT INTO hui_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Ani buwa mani loma binigo mo miaga biagome agali ge hamua ale bu hene bayale helonaga ibiyago ega darama biagome kahalu tandala ba holebira. Ani biai howa loma binigo mo miaga biago ibugua agali biago lamialu lalu, Áyu í̠ Anduane Homogonaga deni dodo mbira para nahe bayaleore kegoni, lolebira. Ani lowa ibugua ega mende biago yalu tagira puwa yagalo yalu pelo yupe holebira. ");
INSERT INTO hui_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Ani biragola wali agali ge hamua ale bu hene biago ibugua ibunaga aga wayawaya balu mandaribi angaribi podo wahai halu ibunibi wayawaya bulene nga. Anidagua biyagua nde o biago ibu i̱ninaga deni dodo mbira para nahe holebira. Ani howa ibugua balai anda bu karuha dai buwa ibuninaga balai anda biagoha abale anda pu nabi horo karu tagirani holene nga. ");
INSERT INTO hui_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Ani bialu horo waragaru howa kanengi ibunaga mandari angari de hambolene iribi ibu tingininaga iri bibahende podo wahai halu ibunaga agabi ibuni tinginibi wayawaya biai haragola ibu i̱ninaga deni ko mbira para nahe bayale holebira. ");
INSERT INTO hui_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","Ani bialu horo haliningi o biago ibugua nogo sibi igini wangabe kirabi nogo sibi angibuni mali mbira hangu hene kago mbirabi haru halu ibulene nga. Nogo sibi uruni dere durubi mbira nabi bayale tigabi kago hondowa haru halu ibulene nga. Ani bialu balawa bayaleoreru genda magi kilogarama tebira olibe lininaga weli heba odo biamaga hene ngagobi yalu olibe lininaga weli maru gabo be kiraha berelo yalu lomabu mule yu ibulene nga. ");
INSERT INTO hui_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Ani yalu ibiragola loma binigo mo miaga kagome i̱naga deni dodo nahe bayale kego lowa ibugua ge hamua ale bu hene biago haru halu mbirale uruni bibahende lomabu mulenaga yalu ibiragobi mo yalu i̱naga Balai Anda kago haneni haru polebira. ");
INSERT INTO hui_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Ani bialu loma binigo mo miaga ibugua nogo sibi igini wangabe mende biago yamialu olibe lininaga weli heba mana ko berolo mitangi nabi howa binigo mo tiga bulenaga loma delolebira. Lomabu delolene uruni bibahende yu howa i̱naga deni gime yuwa wigiwaga lalu holebira. ");
INSERT INTO hui_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Ani bialu loma binigo mo miaga ibugua nogo maru ko binigo domo wahelonagabi nogo maru irame dai helonagabi loma bo delolene ngagoria nogo sibi igini wangabe biago haru halu puwa bolebira. Loma binigo mo miaga kagome anidagua bulebirago irane mana ko binigo domo wahelonaga nogo sibi loma bialu bo delolene loma binigo mo miaga ibuni milo mirugonidagua mana ko berolo mitangi nabi howa binigo mo tiga bulenaga loma bo delolenebi loma uruni ibunaga dege i̱na wiabagi ho ngeledogoni. ");
INSERT INTO hui_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Ani buwa loma binigo mo miaga biago ibugua nogo sibi daramame wali agali biago dodo nahe helonaga gi tigahayagi hale teneha ha̱i̱ halu ge tigahayagi ge angibiyane kago ha̱i̱ halu gi tiganaga gi angibiyane kagobi ha̱i̱ halu bulebira. ");
INSERT INTO hui_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Ani bialu loma binigo mo miaga ibugua olibe lininaga weli emene mbira ibuninaga gi leha habeni odo wulebira. ");
INSERT INTO hui_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","Ani buwa gi tiganaga gi hondoneme weli biagoha ibira halu wai howa Anduane Homogo i̱ninaga deni kahalu tandala ba holene nga. ");
INSERT INTO hui_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Ani buwa ibugua olibe lininaga weli ibuninaga gi habeni wiyago mialu wali agali i̱naga deni dodo nahe bayale helo biagonaga gi tigahayagi hale teneha nogo darama helayagoria hela dambi halu gi angibiyane tigahabi ge angibiyane tigahabi darama wai hayagoria weli biago hela dambi haga bulebira. ");
INSERT INTO hui_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Ani buwa weli emene ibuninaga gi habeni odo wiyago ibiraho ngagome wali agali biagonaga haguaneni dege odo wulebira. Anidagua biragome o biago i̱naga deni ko mbira ibuha para nahe helonaga anidagua bulebira. ");
INSERT INTO hui_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Anidagua biai halu loma binigo mo miaga ibugua wali agali biagonaga ko binigo domo wahelonaga loma biago bo delaragola o biago ibu i̱naga deni ibuha ko mbira para nahe bayaleore holebira. Ani buwa mani loma binigo mo miaga ibugua irame dai helo loma bialu bo delolenenaga nogo sibi igini mende bo delolebira. ");
INSERT INTO hui_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Ani bialu loma binigo mo miaga ibugua nogo sibi igini ogoni loma bo delowa widibi lomabu delaga dabu ngagoria loma bialu delolene nga. Ani bo delowa ibugua wali agali biagonaga ko domo wahelo ogonidagua biragola i̱naga deni o biagoha ko mbira para nahe bayaleore holebira. ");
INSERT INTO hui_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Mbirali ibugua mana ko berolo mitangi nabi howa binigo mo tiga bulenaga loma bo delole munime mulenego muni nawi yagibano kayagua nde nogo sibi igini wangabe mbiraore hangu minu yalu ibulene nga. Wali agali o biagome ko binigo mo tiga bulenaga loma binigo mo miaga kagome nogo sibi igini ogoni podo yuwa i̱ninaga deni gime wigiwaga lalu lomabu ngulebira. Ani bialu balawa bayaleoreru genda magi kilogarama mbira olibe lininaga weli heba odo biamaga hene ngagobi mo yalu olibe lininaga weli maru gabo be kiraha berelowa lomabu mule yalu ibulene nga. ");
INSERT INTO hui_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","Ani bialu ibugua ega malibu ale kira minu yalu ibalu lomabu mulene ngago irane ibu munime nogo sibi kira hende holenego muni ya nabi heagua ani bulene nga. Ega mbirago ko binigo domo wahelonaga loma bialu bo delalu mendego irame dai helo lomabu yalu ibulene nga. ");
INSERT INTO hui_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Horo halini ibuni mo bayale helolene ogoni tagira ibirangi ibugua loma uruni yalu loma binigo mo miaga biago Anduane Homogo i̱naga Balai Anda haneni i̱ninaga deni yalu ibulene nga. ");
INSERT INTO hui_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Ani yalu ibiragola loma binigo mo miaga ibugua nogo sibi biagobi olibe lininaga weli biagobi ibunaga giha mo yuwa Anduane Homogo i̱ninaga deni wigiwaga lalu holebira. ");
INSERT INTO hui_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Ani bialu loma binigo mo miaga kagome wali agali ge hamua ale bu hene biagome mana ko berolo mitangi nabi howa binigo mo tiga bulenaga nogo sibi igini lomabu mialu bolebira. Ani bowa loma binigo mo miaga ibugua nogo sibi darama ngago gime yu howa wali agali ibiyagonaga hale gi tigahayagi kagonaga teneha ha̱i̱ halu gi tiganaga angibiyane kago ha̱i̱ halu ge tiganaga angibiyane kagobi ha̱i̱ dege halu bulebira. ");
INSERT INTO hui_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Ani buwa loma binigo mo miaga kago ibugua olibe lininaga weli biago emene mbira ibuninaga gi leha habeni odo wulebira. ");
INSERT INTO hui_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","Ani odo wialu Anduane Homogo i̱ni deni howa ibugua gi tigahayaginaga gi hondone mbira hangume weli gi habeni odo wiyagoha ibira howa kahalu tandala bahaga bulebira. ");
INSERT INTO hui_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Anidagua biai howa loma binigo mo miaga ibugua olibe lininaga weli biagome wali agali biagonaga hale tenehabi gi angibiyanebi ge angibiyanebi bibahende gi tigaha dege dege abale nogo darama ha̱i̱ hayagoria welime ha̱i̱ hadambi holebira. ");
INSERT INTO hui_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Ani biai howa ibugua weli gi habeni emene ibiraho ngagome wali agali ko domo wahelo ibiyagonaga haguaneni odo wulebira. Ani biragola wali agali ogonime ko binigo domo wahelonaga loma bialu bo delolebira. ");
INSERT INTO hui_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Ani bulenaga loma binigo mo miaga ibugua wali agali ko binigo domo wahelo ibiyagome ega malibu ale kira lomabu mule minu yalu ibiyago mbirago yamulebira. ");
INSERT INTO hui_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","Ani yamuwa ega mbirago ko binigo domo wahelonaga loma bialu bo delalu mendego irame dai helo loma bialu bo delolebira. Ani bialu widi lomabu delolenegobi ega kira biago heba bo delolebira. Anidagua biragome i̱naga deni wali agali biagoha ko mbira para nahe bayaleore hole ibiyagonaga ko domo wahelo loma binigo mo miaga kagome lomabu delolebira. ");
INSERT INTO hui_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Mana ogoni mbirali ibu ge hamua ale binigo dabi halu i̱naga deni bayale holenaga lomabu delole yalu ibulenego yolo mulene muni nawidagola ogonidagua bulene nga, lene. ");
INSERT INTO hui_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Anduane Homogohanda Mosese Aronolahondo lamialu lalu, ");
INSERT INTO hui_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","Mani tí Kenana dindi i̱na mo ngule ngogoria pu holeberemi. Dindi ogoni tínaga lene wiaabobo bu wulebira. Ai tí dindi ogoniha pu kamingi anda maru kago tamuha hagama holene mbira ibilaruyagua ");
INSERT INTO hui_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","tí de handalu anda ogoni anduane hayadago ibunime loma binigo mo miaga agali karia polene nga. Puwa ibuhondo lalu, I̱ andagaha hagama mbira hatagi ho ngago i̱na de handarugoni, lalu lamulene nga. ");
INSERT INTO hui_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Anidagua lamiragola loma binigo mo miaga kagome hale howa anda anduane biagohondo lamialu, Anda ogoni i̱ de hondole ibulebero. I̱ de hondo naibidoha í̠naga dabudabu wiridaruni mo yu tagira piai habe, lolebira. Ani larago hale halu bibahende mo yu tagira napeyagua loma binigo mo miaga ibugua lalu, Anda ogoniha dabudabu yalu tagiraha nape ngaru bibahende Anduane Homogonaga deni ko nga, lolebira. Ani lamialu loma binigo mo miaga biagome anda tamuha de hondole polebira. ");
INSERT INTO hui_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Ibugua anda tamuha anda puwa mbirale anda háini hagamame hatagi halu mo ko hayadago de hondolebira. Ani de handalu mbirale ira yuni handalehebi daramabirumebi anda hái mo togo bia howa diri tombela andatagi bidago hondowa ogoni anda kabaneha bima anda peda lo manda biyagua nde ");
INSERT INTO hui_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","loma binigo mo miaga ibugua tagira puwa lalu, Horo karu wali agali anda ogoniha napale bameore ngelalimu, lolebira. ");
INSERT INTO hui_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Ani lalu puwa horo waragaru howa kanengi loma binigo mo miaga ibugua lone dai bialu anda biago de hondolebira. Ani hondowa anda hái biago mo ko timbuni hayadane dehandayagua nde ");
INSERT INTO hui_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","ibugua tihondo lalu, Anda ogoninaga hái bini ege to̱le̱ mo ko hayadago bo gialalu tano tagirahayagi mbirale Anduane Homogo i̱ninaga deni ko ngaru mo yu wahaga ngagoha yu wahole pudaba, lolebira. ");
INSERT INTO hui_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Ani bialu anda hái biadambi hene ege timeni anda háinaga ege to̱le̱ wabu dambi halu bu mabu bini kago bo dodai holebira. Ani biai halu mo yalu puwa tanonaga tagiraha ko yu wahaga ngagoha mo wahai holebira. ");
INSERT INTO hui_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Anidagua biai howa ege to̱le̱bi timenibi gialo wahayago gahengeme bia aribia holebira. Timeni gahengeme anda hái lone para hadambi halu bulene nga lolebira. ");
INSERT INTO hui_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Anda gialowa lone bia dai bidamigola ala mo ko hayadagua dege lone mo ko hayagua nde ");
INSERT INTO hui_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","loma binigo mo miaga biagome lone de hondole dai bulebira. Ani handalu karia anda biago mo ko habeheoredane handayagua nde ibugua lalu, Anda ogoni i̱naga deni ko kagoni, lolebira. ");
INSERT INTO hui_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Ani kago manda bialu timenibi ege to̱le̱bi irabi bibahende anda ogoni bini damene kago mbira ibira nahelo mo yai halu amura tagiraha mbirale i̱naga deni ko ngaru yu wahaga ngagoha yalu pu waholene nga. ");
INSERT INTO hui_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Anda ogoniha anda napole lalu panga payidaha mbirali anda piyagua ogoni ibubi i̱naga deni ko dege kane alendo holebira. ");
INSERT INTO hui_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Mbirali anda ogoniha napole layago lelowa tomo nalu birayaguabi anda ogoniha paliyaguabi nde ibunaga aga wayawaya bulene nga. ");
INSERT INTO hui_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Anigo mani loma binigo mo miaga biagome anda ogoniha lone anda puwa handalu karia anda hái biago bayale halu hagama biago ha timbu nahedane handayagua nde ibugua lalu, Anda ogoniha hagama biago ereba hayadago ai Anduane Homogonaga deni bayale ka, lolebira. ");
INSERT INTO hui_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","I̱naga deni anda biago mo bayale helonaga mana ogodagua bulene nga. Loma binigo mo miaga biagome ega kirabi ira tamia emene gabini mbirabi pu payini daramabi mbirabi ira hisobonaga magane mbirabi mo yulebira. ");
INSERT INTO hui_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Ani bialu iba duguaraga haragoha howa iba hambialu yu dai bulebira. Ani hambu yudai bialu todobene be dindime wabini ngagoha berelowa ibugua ega mende biago todobene be iba bere biagoha darama anda pelo nene daligani bolebira. Ega ogoni baragola darama todobene be iba birayagoha ibira holebira. ");
INSERT INTO hui_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Ani ibira ho bedagola loma binigo mo miaga ogonime ira tamia emene gabini biagobi ira hisobo magane biagobi pu payini daramabi biagobi ega mende ba nabini biagobi bibahende gime hilamagamaga bu yuwa iba ega darama heba birayagoha abaleore ibira halu yamulebira. Ani buwa iba ega darama heba wai ho yayagome anda biagoha kahalu tandala bahaga bulebira. ");
INSERT INTO hui_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Loma binigo mo miaga biago ibugua anidagua biragome anda ogoni ko nahe i̱naga deni bayale holebira. ");
INSERT INTO hui_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Ani bialu ega mende ba nabi dére minu yu hayago ibu tano yu wahalu amura ibuni biraga dangi te ngagoha yagalalu pelo yupe holebira. Ogonidagua biyagome anda ko hayadago domo wahalu i̱naga deni bayale helonaga bulene mana ogoni. ");
INSERT INTO hui_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","56","Mana uruni wali agalinaga tinginini warago ale tara tara ngarubi ge hamua pagayabi karubi dere durubi karubi moge ti̱wabi karubi nahendene ale tinginini tagira íbu karubi mbiraleme agaru andaru hagama hagarubi uruni damenego tagira ibiragola bulene wini. ");
INSERT INTO hui_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","Mana ogonime i̱ninaga deni mbirale ko nga bayale nga lalu mo walia haga bulebira, lalu Anduane Homogohanda lene. ");
INSERT INTO hui_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Anduane Homogohanda Mosese Aronolahondo lalu, ");
INSERT INTO hui_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","Isaraele wali agali karu lamialu ogodagua lalibu. Agali mbirame warago tara balu ibunaga pinduha howa angibu tagira ibiyagua ogoni biragome agali ogoni i̱naga deni ko ka. ");
INSERT INTO hui_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Angibu ogoni dewa iba poradagua piyaguabi angibu ogoni giambe howa pu tolenego hariga ndibu layaguabi agali ogonidagua bini kago ibu i̱naga deni ko ka. ");
INSERT INTO hui_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Ibu paliagane dagia ngagoriani paliyaguabi biragane dagia ngagoriani birayaguabi bibahende ibugua mo ko hene dege nga. ");
INSERT INTO hui_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","6","Anigo mbiralime agali ogoninaga paliagane dagia ngago ela hayaguabi ibunaga biragane dagia ngagoriani birayaguabi o ani biyadagonaga ibunaga aga tinginibi abale wayawaya bulene nga. Anigo ibu ko kane dege alendo ni anda polebira. ");
INSERT INTO hui_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Wali agali mbirame agali warago ogoniale bu kago ela hayagua nde tinaga agabi tinginibi wayawaya bo waholene nga. Ani bialu ti horo ogoningi dodo ogoni ha ho kane dege alendo ni anda polebira. ");
INSERT INTO hui_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Agali waragowi biagome agali mbira ibu i̱naga deni ko nahe bayale kago hamiaga toloba hayagua nde ibubi i̱naga deni mo ko henego ka ai ibunaga aga wayawaya bialu ibunibi wayawaya bulene nga. Ani bialu ogoni ibu dodo ha ho kane dege alendo ni anda polebira. ");
INSERT INTO hui_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Ani bialu agali warago tara ogoni barago ibu nogo dongi hosirunaga erekunini biragane nogo dongoneme wabini birayagua nde biragane ogonibi ko dodohe dege ho wulebira. ");
INSERT INTO hui_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Agali ogoni ibu birayagoria mbiralime mbirale ngago ela hayagua nde agali ela haga kago ibubi ko dodohe dege kane alendo halu ni anda polebira. Agali mbirame mbirale agali waragowi abale birayago ogoni mo yalu piyagua nde agali ogoni ibubi ko dodohe dege holebira. Anigo ibugua ibunaga aga wayawaya bialu ibuni tinginibi wayawaya bulene nga. Ani bialu ibu ko dodohe kane dege alendo halu ni anda polebira. ");
INSERT INTO hui_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Agali warago tara ogonibiwi kagome ibu gi wayawaya nabi howa agali mende bayale kago ela hayagua nde agali bayale ogoni ibugua ibunaga aga wayawaya balu ibunibi wayawaya bo polene nga. Ani bialu ibuni ko dege kane alendo halu ni anda polebira. ");
INSERT INTO hui_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Agali warago ogonialewi kagome todobene be dindime wabini ngago ela hayagua nde be ogoni bo pambulo waholene nga. Ani bialu ndisi be irame wabini ngago ela hayagua nde ndisi be ogoni baya hangu ibame wayawaya bulene nga. ");
INSERT INTO hui_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Ani buwa agali ogonibi kagome warago tara ogoni dabi hayagua nde ibu horo karu howa mani ibu dodo nahe bayale holenaga mo tiga bulebira. Horo karu piai haragola ibunaga aga wayawaya bo wahalu ibuni tinginibi iba poragoha wayawaya bo poragola nde ibu Anduane Homogonaga deni dodo nahe bayale holebira. ");
INSERT INTO hui_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Horo haliningi agali biago ibugua ega malibu ale kirayaguabi ega mendeale kirayaguabi minu yalu puwa Anduane Homogonaga Balai Anda kagoria yalu puwa anda haneni loma binigo mo miaga kagohondo mulene nga. ");
INSERT INTO hui_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Ani miragola loma binigo mo miaga ibugua ega mbirago ko domo wahelonaga loma bialu bo delalu mendego irani dai helo loma bialu bo delai holebira. Anidagua biragome loma binigo mo miaga ibugua agali ogoni ibu warago dabi halu Anduane Homogo i̱naga deni dodo nahelonaga mana bulebira. ");
INSERT INTO hui_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","Agali mbira ibu mbiraga u̱ padaha emaga handalu karia ibunaga ibane bame tagira piyagua nde agali ogoni ibu dodohe kago manda bialu ibunaga tingini bibahende wayawaya bai holene nga. Ani bialu ibu dodohe dege kane alendo halu ni paliragola bayale holebira. ");
INSERT INTO hui_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Ibunaga ibane ogoni aganiyaguabi mbirale maru ngaruniyaguabi mbirale nogo dongoneme wabini ngagoniyaguabi mbirani ibira hayagua nde mbirale uruni wayawaya biai holene nga. Ani biragola ogoni alendo halu dodohe dege kane ni paliragola bayale holebira. ");
INSERT INTO hui_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Wali agali kirali mandagi padebira agalinaga ibane tagira ibiyagua nde libu haru dodohe holebira. Ani biragola libu haru heyalu wayawaya bo polene nga. Ani bialu libu dodohe dege kane alendo halu ni paliragola bayale holebira. ");
INSERT INTO hui_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","Wali mbira ibu ege habolo bedangi nde ibu horo karu dodohe biraabo holebira. Mbiralime wali ogoni ela hayagua nde ibubi dodohe dege halu ni paliragola bayale holebira. ");
INSERT INTO hui_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Wali ogoni ibu bira palia biaga dagiabi bibahende dodohe dege wiai holebira. ");
INSERT INTO hui_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","22","Mbiralime wali biagonaga biraga paliaganebi dagia ngago ela hayagua nde ela haga biago ibu dodohe holebira. Ani holebirago ai ibunaga aga wayawaya balu ibunibi ibaha wayawaya bo polene nga. Ani bialu ibuni dodohe dege kane alendo halu ni paliragola ibu bayale holebira. ");
INSERT INTO hui_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Aga paliaga hanguyaguabi marualebi wali ogoni ibu biraga ngagobi ela hayagua mbirali ogoni ela harago ibu dodohe howa ni paliragola bayale holebira. ");
INSERT INTO hui_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Agali mbira ibu wali ege habolo bedagola mandagi paliyagua nde agali ogoni ibu dodohe kane horo karu holebira. Ani bialu dagia ibu paliaga ngagobi nde dodohe dege horo karu holebira. ");
INSERT INTO hui_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Wali mbira ibu ege habolo biragadagua ndo mendengi handa aribia hayaguabi ibu horo lu dewa biraabo hayaguabi nde ibu dodohe dege horo lu bedane ereba harangi wahole ibu ege habolo biragadagua biraabo holebira. ");
INSERT INTO hui_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Dagia ibu bira pali biaga ngagobi bibahende dodohe dege wiai holebira. ");
INSERT INTO hui_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Mbiralime dagia uruni ela hayagua nde ibubi dodohe dege holebirago ibunaga agabi ibunibi ibame wayawaya bulene nga. Anigo ibu dodohe dege kane alendo halu ni paliragola bayale holebira. ");
INSERT INTO hui_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Wali ege habolo birayago horo bolangua haragola ibu horo karu biralu mani Anduane Homogonaga deni ibu dodo nahe bayale birulebira. ");
INSERT INTO hui_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Horo halini haragola ega malibu ale kira minu yalu Anduane Homogonaga Balai Anda kago haneni puwa loma binigo mo miaga kagohondo mulene nga. ");
INSERT INTO hui_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Ani miragola loma binigo mo miaga kagome ega mbirago ko domo waholenenaga loma bialu bo delalu mendego irani dai helo loma bialu bo delolene nga. Anidagua biragome wali biago ibu Anduane Homogonaga deni dodo nahe bayale berelo anidagua bulebira. ");
INSERT INTO hui_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Isaraele wali agalirume tini Anduane Homogonaga deni dodohe holigo lowa mo dodo hagane ngagoria polene nawi. Ani polene nawigo irane i̱naga Balai Anda ogoni tinaga balai anda bu kagoria dege dombeneha kago ti i̱naga deni dodohe kangi anda ogoniha piyagua tigua i̱naga Balai Anda kago mo mebia harimigonaga ti homelo bo waholene wulebira, Anduane Homogohanda Mosese Aronolahondo ani lene. ");
INSERT INTO hui_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Mana uruni agalinaga tinginiha howa angibu ale tagira ibiyaguabi agalinaga ibane bame padaha tagira piyaguabi ogonidagua biragome agali mo dodohe haga kago mana urunidagua bulene nga. ");
INSERT INTO hui_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","Ani bialu wali ibu ege habolo bedangibi wali agalibi tinaga tinginiha angibu ale tagira ibiyaguabi agali ibu wali ege habolo bedagola libu haru mandagi paliyaguabi uruningi tigua bayale holenenaga bulene mana uruni lo winigo nga. ");
INSERT INTO hui_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Anduane Homogohanda Arono igini kira biago labome loma bu mulene winingi ndo mana puguwa mbirale loma bialu hearia bo homelene. Ani bu howa Anduane Homogohanda Mosesehondo lamialu lalu, ");
INSERT INTO hui_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Í̠naga hamene Arono lamialu Anduane Homogonaga Hobane Loma Bia Heneore labolabome tu wuwa hoba amu kagoha Habo Nalolene Bi lo winigonaga Mbogoyi ngagoria ibuni hameme poa biradagua polene nawi lamibe. Polene winingi ndo ibuni hameme ibiyiyagua homolebira. Homolebirago irane Habo Nalolene Bi lo winigonaga Mbogoyi ogoni wali agalinaga ko biniru domagane panga ogoriani i̱ni hari beralibaha howa ha pani haruli. Anigo i̱na larogonidagua ibu nabiyagua homolebira lamibe. ");
INSERT INTO hui_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Ibugua Hobane Loma Bia Heneore biagoha ibule harangi nogo bulumaga wangabe mbira ibunibi ibu one waneiginirubi tinaga ko i̱na domo waholiya bo yalu mende nogo meme wangabe mbira irani bo delai hole haru halu ibalu anda polene nga lalu lamibe, lene. ");
INSERT INTO hui_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Anduane Homogohanda bi ogodagua lalu, Arono ibugua Hobane Loma Bia Heneore biagoha anda pu nabi howa ibuni ala wayawaya bulene nga. Ani buwa ibugua loma binigo mo miaga biabe bulenaga darasi tubagibi aga bia gimbubi nogo dongonebi labolabo emboneni bobu mabu bialu karulolene nga. ");
INSERT INTO hui_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Isaraele wali agali tigua nogo meme wangabe kira tinaga ko i̱na domo waholiyanaga haru ibalu nogo sibi wangabe mbirabi irani bo delai helo haru ibuwa Aronohondo mulene nga. ");
INSERT INTO hui_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Ibugua nogo bulumaga wangabe mbira ibuninagabi ibu one waneigininagabi ko domo waholiya bolene nga. ");
INSERT INTO hui_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Ani buwa ibugua nogo meme wangabe biagolabo haru halu Anduane Homogo lola holenaga Balai Anda haneni haru polene nga. ");
INSERT INTO hui_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Anda hane ogoriani howa ibugua to̱le̱ kira hame dabagane biago labome hame dabagane mana wiyadagua dabolene nga. To̱le̱ mbira Anduane Homogonaga dabole howa dabagane mana wiyadagua dabalu to̱le̱ mende Asaselenaga dabole dabagane mana wiyadagua dabolene nga. ");
INSERT INTO hui_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Arono ibugua nogo meme wangabe mendego Anduane Homogonaga lowa to̱le̱ mbira biagome dabene biago wali agalinaga ko i̱na domo waholiya bolene nga. ");
INSERT INTO hui_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Nogo meme wangabe mende Asasalenaga lowa dabene biago dére kaore Anduane Homogo kagoria haru ibulene nga. Ani buwa ogoni haru halu pialu dindi ko wali agali nahaga mbira ngagohayagi puwa wara pelolene nga. Ani biragola wali agalinaga ko biyaru nogo meme wangabe biagome mo yalu puabo helo ani bulene nga. ");
INSERT INTO hui_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Arono ibuninagabi ibu one waneigininagabi ko domo wahelonaga ibugua nogo bulumaga wangabe biago loma bialu bo muwa ");
INSERT INTO hui_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","ibugua lomabu delaga dabu ira do wiaga ngagoria howa ira pungane dedaore duguwa ira hedo yagani tabo wulebira. Ani buwa ira hagua ngabi biaga mini inisenesinaga pauda gi kira yulene mo yulebira. Mo yalu Anduane Homogonaga Hobane Loma Bia Heneore labolabome tu hoba amu ho wiyagoha yalu Aronohanda anda polene nga. ");
INSERT INTO hui_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Ani buwa ibugua Anduane Homogonaga deni hagua ngabilonaga inisenesi ira dedagoria ogoriani delolebira. Ani delaragola hagua ngabi biragome Habo Nalolene Bi lo winigonaga Mbogoyi wali agali ko biniru domagane panga ngagoria dunguame holebira. Anidagua biragome Arono ibu panga biago nahende howa ibu nahomolebira. ");
INSERT INTO hui_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Arono ibugua nogo bulumaga wangabe bayagonaga darama maru yamuwa Habo Nalolene Bi lowinigo Mbogoyi ogoriani yalu puwa wali agalinaga ko biniru domagane pangani ibunaga gi hondoneme darama maru odo tindi tanda lolene nga. Ani buwa Mbogoyi biagoha hapara howa ibunaga gi hondoneme darama maru lone kahalu odo tindi tanda lolene nga. ");
INSERT INTO hui_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Ogoni biai howa wali agalinaga ko biniru domo wahelonaga ibugua nogo meme bole haru ibiyago bowa darama yamuwa Hobane Loma Bia Heneore labolabome tu hoba amuho wiyagohayagi yalu puwa nogo bulumaga wangabe biagonaga daramame ala biyadagua tindi tanda lolene nga. Ibugua wali agalinaga ko biniru domagane panganibi Mbogoyi biago ngagoria hapara howabi ibunaga gi hondoneme darama halu mende tindi tanda lolene nga. ");
INSERT INTO hui_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Arono ibugua anidagua biragome Isaraele wali agalirume ko tara tara biyarubi Hobane Loma Bia Heneore biago tigua mebia hayagobi domolene wulebira. Balai Anda o biago wali agali tini kagoria kago mebia hayarunaga ko domalu mo baya holenaga ogonidagua dege bulene nga. ");
INSERT INTO hui_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Horo ogoningi dege Arono ibu Anduane Homogonaga Hobane Loma Bia Heneore biagoha ko domole anda pu kaha wali agali mbirali Arono kagoria anda polene nawiore. Hobane Loma Bia Heneore ogoniha howa Arono ibuninagabi ibu one waneigininagabi Isaraele wali agali bibahendenagabi ko domo wahai helonaga mana ngadagua biai holene nga. ");
INSERT INTO hui_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Ani biai halu tagira puwa ibugua bo lomabu delagane dabu ngagoria puwa Isaraele wali agalinaga ko binirume mo dodo hene ngago ogoni domole mana biagane wiyadagua bulene nga. Nogo bulumaga biagonaga daramabi meme mbira biagonaga daramabi yamuwa lomabu delaga dabu ngagonaga gibuni maria ngagoria bulumaga ne gayane ale maria karuni daramame ha̱i̱ holene nga. ");
INSERT INTO hui_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Ibugua darama uruni gi hondoneni wai howa dabu tindi tanda la a̱i̱ na̱i̱ bialu kahalu hirulene nga. Ani biragome Isaraele wali agalinaga mana ko tara tara biyarume dabu biago mo dodo ho wiyagoni darama ogonime mo baya halu lomabu dai buwa ngelolebira. ");
INSERT INTO hui_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Aronohanda Anduane Homogonaga Hobane Loma Bia Heneore biagonagabi Balai Anda biagonagabi lomabu delaga dabunagabi ko domai helonaga mana wiyadagua biai howa ibugua nogo meme mbira dére Asaselenaga dabo helayago Anduane Homogo deni haru ibulene nga. ");
INSERT INTO hui_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Ani buwa Arono ibugua meme dére biagonaga haguaneni ibunaga gi kirabali wialu Isaraele wali agalime mana ko biyarubi bi mana mo wahayarubi lapani halu uruni bibahende meme biagonaga haguaneni lo ngelai helo. Ani buwa ibugua meme biago dindi ko wali agali nahaga ngagoha agali biabe ogoni bule dabo helenedagome haru halu puwa wara pelolene nga. ");
INSERT INTO hui_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Meme biagome tinaga ko bibahende lo wiai hayaru mo yai halu dindi ko wali agali nahaga ngagoha dai nabule pu wahalu puabo holebira. ");
INSERT INTO hui_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Arono ibugua uruni biai halu Balai Anda biagoha lone anda puwa Anduane Homogonaga Hobane Loma Bia Heneore biagoha ala pole lowa loma binigo mo miaga agalime karulagane aga horo ogoningi biyago golo ngelolene nga. ");
INSERT INTO hui_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Ani buwa ibuni dongone ogoningi dege wayawaya baga wiyagoria waya bialu dai buwa aga ibuni horombe bu haga wiyago bulene nga. Ani buwa ibuninagabi wali agali bibahendenagabi ko domo wahai helo bo mulene kira dabu wiyagoni irani dai helo delolene nga. ");
INSERT INTO hui_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Ko biyarunaga nogo habane delaga wiyagobi lomabu mini delaga dabuni biagoria delolene nga. ");
INSERT INTO hui_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Agali mbira meme wali agalinaga ko mo yalu porago haru halu puwa wara pelaga biago ibubi ibani puwa ibunaga agabi ibunibi wayaore biai halu wali agali kagoria dai bibehe holebira. ");
INSERT INTO hui_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Bulumaga wangabe meme wangabe bo mini biagolabonaga darama Anduane Homogonaga Hobane Loma Bia Heneore biagoha wali agalinaga ko domo wahelonaga yalu anda ibiyago labo wali agali balai anda bu kagoria howa tagirahayagi yalu tagira polene nga. Ani buwa nogo biago labonaga dongonebi mbirini podo ibira ibira bini ngarubi nogo tinibi bibahende ira dalu do mundulo wahelolene nga. ");
INSERT INTO hui_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Agali ogoni delaga kago ibunibi ibunaga agabi wayaore bayuwa balu howa wali agali kagoria dai bibehe holebira, lalu Anduane Homogohanda lene. ");
INSERT INTO hui_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Anduane Homogohanda, Mana ogodagua biaabo holene nga, lene. Ko domo wahelonaga mana bulene ogo galoneda lowa manda bu haabo halimu. Ege kanegonaga horo pinini Isaraele wali agalirubi dindi tara tara wali agali tí heba mandagi íbu kamirumebi horo ogoningi haragola tomo nane howa biabe nabi halimu. ");
INSERT INTO hui_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Horo ogoningi wali agalime horo bibahendeni ko biyaru Anduane Homogohanda domo wahelonaga loma binigo mo miaga kagome bo lomabu mulene ngadagua miragola tí Anduane Homogo deni dodo nahe holeberemi. ");
INSERT INTO hui_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Horo ogoni dabo bagi hene mbira wuwa ogoningi tomo mbira nane halu biabebi nabi holeberemi. Ani bialu mali bibahendeni horo ogoninaga ko domolene mana ngadagua biaabo holeberami. ");
INSERT INTO hui_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Loma binigo mo miaga haguane timbuni ibu ha aribia holene tu haragola ibu igini dabalu ibu aba henegoria ha aribia helo tígua dabo helalimu. Ani heledamigola ibugua wali agali bibahendenaga ko biyaru domo wahelonaga mana lowini ngadagua biai holene nga. Ani bule ibugua loma binigo mo miaganaga aga karulowa ");
INSERT INTO hui_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Anduane Homogonaga Balai Anda Hobane Loma Bia Heneore biagohabi Balai Andaha bibahende ngarubi lomabu delaga dabu biagobi loma binigo mo miaga agali biarubi wali agali bibahende biarubi i̱naga deni dodo nahe hole biagane mana wiyadagua biai holene nga. ");
INSERT INTO hui_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Mana o lo werogoni tígua bulene horo haragola pugu wanahe bayuwaore handayaho howa biaabo halimu. Loma Binigo Mo Miaga Haguane Timbuni ibugua mali mbira mbira haragola Isaraele wali agalinaga ko biyaru domo waholene mana biai holebira. Anduane Homogohanda bi uruni Mosesehondo lamiyagola layadagua Mosese ibugua biai hene. ");
INSERT INTO hui_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Anduane Homogohanda Mosesehondo lalu, ");
INSERT INTO hui_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","Arono halu ibu iginirubi Isaraele wali agalirubi bibahendehondo bi ogo lamibe. Anduane Homogo i̱na i̱naga bi mana uru tíhondo ngerogoni. ");
INSERT INTO hui_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Isaraele wali agali tígua nogoru balu nole howa nogo bulumagayaguabi sibiyaguabi memeyaguabi tínaga balai anda bu kamigoha howabi tagiraha howabi bame nabalimu. Bame bope harimiyaguabi i̱naga mana puguarami. ");
INSERT INTO hui_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","I̱ninaga Balai Anda kagoha anda haneni i̱hondo ala lomabu ngule yalu naibirimiyagua nde tígua darama bame pelarimigoni. Ani birimiyagua tígua wali agali bo waharadagua beramigo tí i̱naga wali agali karu baba mandagi nahe tí tara ka lalu bo batagi holebero. ");
INSERT INTO hui_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Mana ogoninaga irane ogo. Abale Isaraeleali tígua nogo mbiraleru tíni tagira kamigoha howa loma beramili. Anigo áyu loma binigo mo miaga agali karia i̱ninaga Balai Anda haneni yalu ibuwa Anduane Homogoi̱nila ho gimbu bulenaga bo lomabu delaga bilimulo mana ogoni lo wero. ");
INSERT INTO hui_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Anidagua beramigola loma binigo mo miaga karu tigua nogo uruninaga darama hambu yuwa balai anda biagonaga anda harabani lomabu delaga dabu kagonaga lenelene odo ba haga bulebira. Ani bialu nogo abene habaneru lomabu delaga kagoria delaramigola loma uruninaga tumutumu ngabi bayale birago nga howa Anduane Homogo i̱na miniha turu halu dungulo holebero. ");
INSERT INTO hui_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Isaraele wali agali tígua i̱ erembira ngialu nogo mbiraleru balu dama nogo meme handalehe kagohondo bo mulene nawiore. Ai bibahendengi tínaga damene mbirame loma bini mbira mbira yalu i̱naga Balai Anda kagoria yalu ibulene nga. ");
INSERT INTO hui_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","9","Isaraele wali agaliyaguabi dindi tarali tí baba heneyaguabi tígua loma bini mbira irame dai helo bo delole yalu ibule heaguabi i̱hondo loma maru bu ngule heayaguabi tigua loma uruni i̱naga Balai Anda kagonaga harabani ala yu ibalu loma bulene nga. Anidagua nabiyagua Anduane Homogo i̱ni kogome ogoni ibu i̱naga wali agali bu karu aria ndo ibu tara ka lalu bo taliatagi holebero, lalu bi ogonidagua Anduane Homogohanda Mosesehondo lamini. ");
INSERT INTO hui_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Tígua nogo balu howa nogo ma pugualu darama bibahende pelai helalimu. Ai Isaraele wali agali kamiru aria mbirameyaguabi dindi tarali wali agali karu aria mbirameyaguabi ibugua nogo mbirini darama bedaore nayagua i̱ Anduane Homogo kogo i̱na wali agali uruni baba waitigi halu i̱naga wali agali karu baba mandagi nahelo bo taliatagi holebero. ");
INSERT INTO hui_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Daramame wali agalibi mbirale ema bialu piaga darama bere karubi ti holene miaga ngagonaga i̱na tíhondo bi mbira langerogo. Loma binigo mo miaga agali karu tigua darama hambu yuwa loma biniru bo delaga dabu bidagoria wali agalinaga ko ngaru domo wahelo lomabu mulene nga. ");
INSERT INTO hui_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Ani bulene ngagonaga i̱na Isaraele wali agali tíhondo larogo. Tíguabi dindi tara tara howa tí baba íbu hene karubi bibahendeme nogo darama bedaore nolene nawiore laro. ");
INSERT INTO hui_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Anigo Isaraele wali agali tíguabi wali agali dindi tarali tí baba íbu hene karumebi mbirale nogo memeru egarubi mbira i̱na tí nanalimu nalene bedaru gabua mbira tayandaha taya howa barimiyagua darama baya hangu piai helowa dindi dugu dambi halimu. ");
INSERT INTO hui_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Ani larogoni irane daramame wali agalibi mbirale ema bialu piaga darama bere karubi tinaga holene miaga ngago darama nanalimu. Anidagua miaga ngagonaga i̱na Isaraele wali agali tíhondo nogo egaru darama mbiriniha bedaore nolene nawiore larogoni. Mbirali nogo egaru darama bedaore nalu kago ibu i̱naga wali agali karu baba mandagi nahelo i̱na ibu bo taliatagi holebero. ");
INSERT INTO hui_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Ai nogo egaru minana homene ngarubi nogo gabuame bo wahene ngarubi mbira tíguabi dindi taraha howa ibini tí baba mandagi haga karumebi nayagua ogoni ibu i̱naga deni howa ko dodoheore holebira. Ani holebirago ai ibunaga agaru wayawaya bo wahai halu ibuni tinginibi wayawaya bulene nga. Ani buwa ibu i̱naga deni dodohe kane dege alendo halu ni paliragola ibu ko mbira ibuha para nahe bayale holebira. ");
INSERT INTO hui_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Ibugua ibunaga agabi tinginibi wayawaya nabiyagua nde ibunime bia ko hayagonaga pani genda ngago yu holene wulebira, Anduane Homogohanda laya lalu Mosesehanda lene. ");
INSERT INTO hui_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Anduane Homogohanda Mosesehondo ");
INSERT INTO hui_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","ibunaga bi Isaraele wali agali bu karuni lamibe lowa lalu, I̱ Anduane Homogo tínaga Ngode Datagaliwabe kogoni. ");
INSERT INTO hui_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Tí Iyibi dindiha hene ha kamigonigo Iyibialime mana biaga ngadagua tígua talialu bulene nawiore. Ani bialu áyu tí Kenana dindi haru poleberogo ogoniha howabi mana ti biaga ngagobi nabule dege laro. ");
INSERT INTO hui_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Tígua mana i̱naga ngerogo dege taluwa bialu halu ogoale bilimu lalu i̱nime langerogo dege bialu halimu. I̱ Anduane Homogo tínaga Ngode Datagaliwabe kogo i̱naga bi tíhondo langerogoni. ");
INSERT INTO hui_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Tígua mana i̱na hameledogo bialu haabo halu bi mana ogoale bilimu lalu lo ngogo talialu halimu. Tígua ogonidagua bialu harimiyagua nde bayale holeberemi. Anduane Homogo i̱niore kogo i̱na tí ogonidaguaore bilimu larogoni, lene. ");
INSERT INTO hui_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Anduane Homogo ibugua mana ogodagua bilimu lalu langiya. Wali agali tí damene darama mbiraore bedago kayu bulene nawi. Deme handaya howa dimagoli ha kayu biabi bulene nawiore. ");
INSERT INTO hui_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Í̠ ai̱yala mandagi kayu bu holene nawi. Anidagua biriyagua í̠na í̠ aba mo taga holebere. Ani buleberego í̠ ai̱ya bedago í̠na ibu í̠ ai̱yaore beda manda buwa ko ogoni nabilimu. ");
INSERT INTO hui_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Í̠ aba one mende bedago bababi nde kayu bulene nawi dege. Í̠na ogonidagua beregome í̠ aba mo tagaore timbuni holebere. ");
INSERT INTO hui_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Í̠ mbalini bedago í̠ aba ibu waneyaguabi ai̱ya ibu waneyaguabi uruni alego baba kayu bulene nawiore. Ai̱yahanda í̠ aba andagani taba heneneyaguabi anda mendeha taba heneneyaguabi ta nabi í̠ mbalini degego ti baba kayu nabilimu. ");
INSERT INTO hui_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Í̠ igini ibu wanebi í̠ wane ibu wanebi í̠ aguane ogoni bedagola kayu nabibe. Mana ogonibi beregome í̠ni mo taga holene wulebira. ");
INSERT INTO hui_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Í̠ aba ibu yagini bedago baba kayu nabibe. Ogoni ibu í̠ aba waneore biralu í̠ mbalini bedago manda bibe. ");
INSERT INTO hui_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Í̠ aba ibu mbalini bedago baba kayu nabibe. Ogoni ibu í̠ abala darama yabulene beda. ");
INSERT INTO hui_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Í̠ ai̱ya hagibuni bedago baba kayu nabibe. Ogoni ibu í̠ ai̱yala darama yabulene beda. ");
INSERT INTO hui_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Í̠ aba hamene onela kayu nabibe. Ogoni ibu í̠ ai̱ya ale beda. Wali ogoni alego haru paliriyagua nde í̠ aba hamene kago ibuni taga timbuni holebira. ");
INSERT INTO hui_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Í̠ igini ibu one bedagola kayu nabibe. Ibu í̠ one ndo bedago ani nabibe. ");
INSERT INTO hui_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Í̠ hamene one í̠ kiane bedagola kayu nabibe. Wali ogonila mandagi paliribiyagua í̠ hamene kago ibu taga timbuni holebirago ani bulene nawiore. ");
INSERT INTO hui_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Wali mbira í̠ dabu berego wane ogoni í̠ yagini mbira bereagua í̠na ogoni í̠ kayu bulene nawi. Ani bialu í̠ one ibu igini kago wane bereagua ogonibi í̠ kayu bulene nawi. Ogoni irane wali uruni í̠ one ibu baba darama mbiraore ibu waneigini hangu ka. Í̠na uruni baba page biriyagua nde í̠na mana ko tagabiore wali tagini holene ngago mo pe holebere. ");
INSERT INTO hui_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Í̠ one berelowa ibu hagibuni bedago kayu bulene nawi. Í̠na libu mo keba holeberego mana ogoni bayale ndogo nabibe. ");
INSERT INTO hui_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Wali ege habolo bedagola kayu nabibe. Ogoningi ibu dodohe bedago nabibe. ");
INSERT INTO hui_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Agali í̠naga nenege kago onela kayu nabibe. Anidagua biriyagua Anduane Homogonaga deni í̠ni mo ko hene dodoheore holebere. ");
INSERT INTO hui_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Baya hanguore hale hadaba. Tígua mbirale dama mitangi bialu bi pupu wule gime wabini mini Molegehondo tínaga waneigini lomabu mialu irani bo delolene nawi. Ani birimiyagua Anduane Homogo tínaga Ngode Datagaliwabe kagonaga mini mo dindiha halu holigo ani bulene nawi. ");
INSERT INTO hui_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Tí wali baba mandagi paliagadagua agali dege dege mana ko ngubi ngago bulene nawiore. Mana ogoni ko ngubiore ngago i̱na tí ogonidagua bilimulo hame naleore kogoni. ");
INSERT INTO hui_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Wali agalimebi nogo biango baba mana ko ngubi ngago bulene nawiore. Mana ogonibi bialu kamirume tíni mo ko holeberemi. Mana ogoni ko ngubiore ngago birimiyagua Anduane Homogonaga deni tí dodoheore holeberemi. ");
INSERT INTO hui_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Mana ko urunialego mbira tígua bulene nawiore. Anidagua bialu harimiyagua tí Anduane Homogonaga deni tíni mo ko hene dodoheore holeberemi. Wali agali Anduane Homogo mitangi nabiaga Kenana dindiha hene karu tigua mana ko ngubi urunidagua bialu hayagome tini mo ko halu Anduane Homogonaga deni dodohe ka. Ani kago áyu dindi ogoni tígua karulo halimulonaga Anduane Homogo ibugua wene taliatagi halu ka. ");
INSERT INTO hui_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Tigua mana ko binigome dindi ogoni mo ko hene dodohe ngeleda. Ani ngeledago Anduane Homogo ibugua dindi ogoni pani nelo miragola wali agali mana ko biaga uruni dindi ogonime ti magu taguiatagi halu balu purogo lelolebira. ");
INSERT INTO hui_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Anigo tígua mana bayale Anduane Homogohanda langiyaruni baya hangu taluwa bialu halimu. Isaraeleali tíguabi wali agali tara tí baba hene kamirubi tí bibahendeme mana ko ngubi urunibi nabilimuore. ");
INSERT INTO hui_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Dindi ogoriani wali agali ala heneyaru tigua mana ko ngubi uruni dege bialu haga heneyago tí manda bilimu. Ani bialu henegome dindi ogo mo ko henego ngagoni. ");
INSERT INTO hui_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Tígua ogonidagua mbira bialu holigonaga laro. Tígua mana ko uruniale bialu harimiyagua nde wali agali Anduane Homogo mitangi nahaga ogoriani heneru dindi ogonime ti magu taguiatagi henedagua tíbi nde anidagua dege bulebira. ");
INSERT INTO hui_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Isaraele wali agali bu kamiru aria mbirame mana ko uruniale bialu harimiyagua Anduane Homogonaga wali agali bu karu baba nahelo bo batagi holebira, lalu Mosesehanda lene. ");
INSERT INTO hui_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Anduane Homogohanda ogodagua laya. Tígua i̱naga bi o langerogoni baya hanguore taluwa bialu haabo halimu. Tígua wali agali dindi ogoniha ala henerunaga mana ko ngubiore bini ngadagua bialu holemini de hondowa halimu. Ani bialu harimiyagua nde tínime i̱naga deni mo ko hene dodohe holigonaga nabilimu laro. Hale haramine. I̱ Anduane Homogo tínaga Ngode Datagaliwabe kogome laya, lalu Mosesehanda lene. ");
INSERT INTO hui_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Anduane Homogo ibugua Mosesehondo lalu, ");
INSERT INTO hui_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","Isaraele wali agalihondo bi ogodagua labe, lene. Ibugua lalu, Anduane Homogo tínaga Ngode Datagaliwabe i̱ mini baya burugule taraore kodagua tíbi mini baya burugule taraore halimu. ");
INSERT INTO hui_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Tí bibahende hangu hangume tínaga aba ai̱yabi yohanda nabi laradagua hale halu bilimu. Ani bialu Sabada horo tara ngago pugua nabi bilimu larudagua bialu halimu. I̱ Anduane Homogo tínaga Ngode Datagaliwabe kogonigo i̱na laro. ");
INSERT INTO hui_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Mbirale gime wabini ngaru bi pupu wule i̱ yu wahalu napilimu. Aeanemebi mbira bi pupu wule gime wanabilimu. I̱ Anduane Homogo tínaga Ngode Datagaliwabe kogonigo i̱na laro. ");
INSERT INTO hui_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","Tígua mbirale mbira Anduane Homogo i̱la ho gimbu bulenaga bo ngulene tu haragola mana langirugodaguaore beramigola i̱na turu howa ogoni mo yulebero. ");
INSERT INTO hui_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Mbirale bo loma binigo horo ogoningi degeyaguabi horo mendengiyaguabi noleberami. Horo tebonengi maru nai nahe ibira hayagua ogoni nolene nawiorego irani delai holene nga. ");
INSERT INTO hui_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Horo tebone pedagola loma binigonaga podo ibiraho winigo i̱naga deni dodohe ngago mbiralime nayagua i̱hondo lomabu ngiyago mebia hayada manda buwa nayulebero. ");
INSERT INTO hui_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Mbiralime podo ibiraho wini ogoni nayagua ko timbuni bira. Anidagua biragome ko ibulebirago tene ibuniha nga. Tigua i̱hondo lomabu nginigo mebia hayagonaga ogoni ibu i̱naga wali agali karu aria ndo ka lolebero. ");
INSERT INTO hui_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","Tígua tínaga mabuni tomo mbirale ngaru bialu howa mabu gibuni lenehayagi nabi helalimu. Ani buwa maru yu waharamigobi bu dai nabi ani helo wahalimu. ");
INSERT INTO hui_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Pu mbira mini gerebinaga lini mabuni yu wahenerubi dogolo ibira ibira binirubi mbira ilama dai bulemini. Uruni wali agali yagibano karubi wali agali ti aria ndo karubi ti milo ngelalimu. I̱ Anduane Homogo tínaga Ngode Datagaliwabe kogonigo i̱na laro. ");
INSERT INTO hui_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Mbirale page nabilimu. Mendealinaga yidago mule lalu ke̱ howa nabilimu. Tindule nalalimu. ");
INSERT INTO hui_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Í̠na mbirale mbira nabule mitangi bialu henene buleore bero lalu Anduane Homogo i̱naga mini lalu nalo wilimu. Ani beramigome i̱naga mini mo ko holeberamigo nalalimu. I̱ Anduane Homogo tínaga Ngode Datagaliwabe kogonigo i̱na laro. ");
INSERT INTO hui_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Ko ogobi hayago manda buwa mbiralinaga ngaru guru nole manda bialu pagebi nabilimu. Mendealime í̠naga biabe biaha lowa ibunaga yolo mulenengi í̠na yuha nabi yu paliabi buleni. ");
INSERT INTO hui_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Hale paihe karu hale nahaga ka manda buwa ha nahalimu. De kohe karu pilelo manda buwa mbirale mbira tinaga hariga pu íbu buleneni wiapai nahalimu. I̱ Anduane Homogo tínaga Ngode Datagaliwabe kogonigo i̱hondo giho halimu. ");
INSERT INTO hui_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Godi hale halu howa mana henene tigatiga lolene ngadagua lalimu. Wali agali yagibano karu koda lowa godime ti bolangua helo manda nabilimu. Homogo mini lene karu hondowabi gi howa godi ti bolangua helo biamogobi nabilimu. Godi tigatiga gai bulene ngadagua gai bilimu. ");
INSERT INTO hui_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Mendealigo erembiraha howa ke̱ halubi lo guralubi lama ibaga nabilimu. Mbirali holene homolenela tuni howa godi lalu kagola í̠na ibu biamogo bule bi baya mbira lolene yideyagua labe. I̱ Anduane Homogo tínaga Ngode Datagaliwabe kogonigo i̱na laro. ");
INSERT INTO hui_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Í̠naga nenege mbirame í̠hondo ko biyagua í̠naga gubaliniha handabe manga ho haabo nahabe. Genda wiaruago libuni howa abale lo tiga biba labe. Nabiriyagua mana ko ibunaga wiyagome í̠bi minumaga habehe ke. ");
INSERT INTO hui_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Mana ko birago biadai nabilimu. Wali agali mbira handabe manga haho wiaabo nahe howa í̠ni gubalini ho harilidagua maru karu ta nabi gubalini ho habe. I̱ Anduane Homogo kogoni. ");
INSERT INTO hui_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Mana bilimu lalu langerogo biai halimu. Nogo tara tarabi biango tara tarabi budi tara tarabi igini mende ale hono wilo hendela tagotago nabilimu. Tomo mbira ale lini heba mende alegonaga lini heba mandagi hangamaga nahalimu. Aga nogo tara tara irinimebi mbirale tara pu tondo alemebi heba mandagi wabiniru karulolemini. ");
INSERT INTO hui_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Agali mbirame ibunaga garabaya biabe ale biahaga wandari mbira bedago ogoni agali mendehondo í̠naga garabaya biabe ale biahaga berelo nguliya lalu agali mendegome yolo nami howa yupe nahe. Yupe nahe karia agali anduane ala hayago ibunila onene agalini mana biagadagua bialu wandari biagola mandagi paliyayagua mana ngagome pani nelo ledadagua nelo mulene nga. Anigoyu agali ogonime wandari yupe nahego ibu andaga biraho winidagome homelo nabolebira. ");
INSERT INTO hui_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Agali ogonime ko biyagonaga i̱na domoliya ibugua nogo sibi wangabe mbira dege i̱naga Balai Anda biago harabani haru ibulene nga. ");
INSERT INTO hui_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Ani biragola nogo sibi wangabe ogoni loma binigo mo miaga kago ibugua agali ko biyagonaga dodo para hayago domolene mana ilili bialu bo loma bulebira. Ani biragola ibunaga ko biyago i̱na la nabi waholebero. ");
INSERT INTO hui_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","Dindi i̱na ngule lo wirugoria anda puwa tígua ira tara tara hangaramigonaga lini daragola mali tebirani lini dedaru nanolene manda bilimu. ");
INSERT INTO hui_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Mali manegoria ira lini daragola bibahende tígua Anduane Homogo i̱ kogohondo turu halu lomabu ngiai halimu. ");
INSERT INTO hui_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Anigo mali daunigoria ira lini dedaruni bibahende tíni do nalimu. Larodagua biai harimiyagua tínaga ira hengedamigoria lini daho wiaabo holebira. I̱ Anduane Homogo tínaga Ngode Datagaliwabe kogonigo i̱na laro. ");
INSERT INTO hui_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Nogo tara tarabi egarubi darama bedaore nolemini. Damanaga gamugamu bibahende ngaruni bule lo manda bulemini. ");
INSERT INTO hui_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Mandari halehayagi dambu tigini kago podolemini. Angaribi gandu lalu mo tumagi nahalimu. ");
INSERT INTO hui_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Mbirali homaragola dara howa tínaga tinginini gi pugulebi hale podolebi manda nabilimu. I̱ Anduane Homogo kogoni. ");
INSERT INTO hui_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Wali agali tara tara karume damahondo bi pupu wialu howa tinaga wane mo ko hagadagua tínaga wane bedamiru mo ko halu agali page biaga bayanda wali berelolemini. Tígua i̱ yu wahalu dama karu yu tiga birimiyagua tínaga dindini mana ko ngubiore tagira ibai holebira. ");
INSERT INTO hui_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Tígua i̱ mitangi bulene Sabada horo pongo bo wiruru pugua nabilimu. I̱ mitangi bialu lotu lole lomabia hene anda kagobi mo yo nahandalimu. I̱ Anduane Homogoore kogoni. ");
INSERT INTO hui_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Mbirale maru hale hole homene dinini heba bi laga karu karia napilimu. Pirimiyagua ani beramigome tí i̱naga deni dodohe holeberami. I̱ Anduane Homogo tínaga Ngode Datagaliwabe kogonigo i̱na laro. ");
INSERT INTO hui_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Wali agali wahe karuhondo mana bayale bialu ti mo yo nahandalimu. I̱hondo giho halu i̱na bi larodagua bialu halimu. Anduane Homogo i̱ore kogoni. ");
INSERT INTO hui_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","Wali agali tara tara maru tínaga dindini tí heba mandagi íbu karuhondo mana bia ko halu nabilimu. ");
INSERT INTO hui_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Tíni Isaraele wali agalihondo beramilidagua tihondobi ogonidagua dege bilimu. Ani bialu tíni gubalini haramilidagua dege tibi gubalini halimu. Tínibi Iyibi dindini hemingi ogoni ale dege harimigo mitangi bialu embeda nahalimu. I̱ Anduane Homogo tínaga Ngode Datagaliwabe kogonigo i̱na laro. ");
INSERT INTO hui_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Mbirali mo hondo howa ibunaga mbirale ngago i̱ mo hole lowa luninaga magi handaga ngagobi genda handaga ngagobi timbuni magi handaga ngagobi mbira ke̱ halu nabilimu. ");
INSERT INTO hui_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Anidagua nabi bayuwa tale bialu magi polene ngadagua pelowa dagabi bayuwa lolene ngadagua tigatigaore lalimu. I̱ Anduane Homogo tínaga Ngode Datagaliwabe kogonigo i̱na tí Iyibi dindini hemiria haru tagira ibirugoni. ");
INSERT INTO hui_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","I̱naga mana lo wirugo damenebi bi larurunibi bibahende ledogo biai halimu. I̱ Anduane Homogoore kogoni. ");
INSERT INTO hui_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Anduane Homogohanda Mosese lamialu lalu, ");
INSERT INTO hui_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","Í̠na Isaraele wali agali bu karuhondo ogodagua lamibe. Isaraele wali agali tínimebi wali agali tara tí heba íbu hene kamirumebi tínaga waneigini mbira mbirale gime wabini mini Molege laga ngagohondo loma bialu bo miyagua wali agali ogonidagua birago homelo bo wahalimu. Wali agali bu kamiru bibahendeme ege to̱le̱ dugualu ogoni birago homelo to̱le̱me baga baga bialu bo wahalimu. ");
INSERT INTO hui_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Tí mbiralime ibu waneigini mbirago Molegehondo bo miyagua ibugua i̱naga Balai Anda mo mebia halu i̱naga mini timbuni lene kogoni bope halu mo nagalone haragoni. Anidagua biragola i̱na ogonidagua biaga kagola waitigi halu ibu i̱naga wali agali heba mandagi nahelo bo batagi holebero. ");
INSERT INTO hui_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Anigo wali agali maru karume mana ogonidagua birago hondowa la nabi wahalu tigua agali ogoni birago balu home nalayagua ");
INSERT INTO hui_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","nde i̱na wali agali urunihondo waitigi halu ibu damene lenego bibahende baba waitigi hai ho holebero. Ani bialu wali agali i̱nihondo erembira ngialu dama mitangi bialu gime wabini mini Molege ngagonaga bi pupu wialu karu tihondobi erembira mulebero. Ani bialu ti i̱naga wali agali baba mandagi nahelo bo batagi holebero. ");
INSERT INTO hui_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Mbiralime i̱ wahalu wali agali dama mana biaga kagoha piyagua maru homene dinini baba bi ladobo biaga kagoha piyaguabi nde ogoni ibu wali agali i̱ mitangi nabiaga karu ale dege holebira. Anidagua bialu kagola i̱na ibuhondo erembira mialu i̱naga wali agali baba mandagi nahelo bo batagi holebero. ");
INSERT INTO hui_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Anidagua bule ngogo ai tígua mana bayale tigabi i̱na hameledogo bialu howa tíni bayaleore ani hole halimu. I̱ Anduane Homogo tínaga Ngode Datagaliwabe kogo i̱na bi o ledogoniore laro. ");
INSERT INTO hui_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Anigo i̱ Anduane Homogo kogo i̱na tí i̱naga wali agaliore halimulo dabo bagiho heledogo ai tígua i̱naga bi mana lo ngago baya hangu taluwa bialu halimu, lene. ");
INSERT INTO hui_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Anduane Homogo ibugua, Mana ogodagua bilimu, lene. Wali agali mbirame ibu abahondoyaguabi ibu ai̱yahondoyaguabi ha halu lalu, Ngode Datagaliwabehanda í̠ mo ko helo, layagua wali agali bi ogonidagua laga kago homelo bo wahalimu. Wali agali bi ogonidagua larago ibuniha ko ngagonaga ibuni homolene karulapeore. ");
INSERT INTO hui_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Agali mbirame ibunaga nenege kago onela kayu biyagua nde wali agalibi kirabali homelo bo wahalimu. ");
INSERT INTO hui_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Agali mbirame ibu aba onela mandagi paliyagua nde agali ogoni ibugua ibu aba mo taga halu yo handaragoni. Anidagua birago ai agali ogonibi wali biagobi kirabali homelo bo waholene nga. Libugua mana ko ogonidagua biyagonaga libuni homelo bolene nga. ");
INSERT INTO hui_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Agali mbirame ibu igini one bedagola kayu bialu hayagua wali agalibi kirabali homelo bolene nga. Libugua mana ko biyagonaga libuni homolene ngago bo wahalimu. ");
INSERT INTO hui_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Agali mbirame wali baba paliagadagua agali mendealila palialu mana ko ngubi ngago biyagua libugua mana koorene ko biyagonaga libu kirabali homelo bo wahalimu. ");
INSERT INTO hui_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Agali mbira kagome wali mbira dabu bialu ibu imane wandari ai̱ya bedagobi dabu bu palu biyagua nde ogoni mana ko leheore biragoni. Mana ogonidagua birago mana koorego tí kamigoha ogoniale mbira nawilo wali agali ogoni birago tebirabali ti haru homelo irani bo delalimu. ");
INSERT INTO hui_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Agali mbirame nogo biangorula mana ko biyagua nde agali ogoni homelo bo wahalu nogo biangoyaguabi agali biagome yinidagobi homelo bo wahalimu. ");
INSERT INTO hui_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Wali mbirame nogo biangoru mbira kagoha puwa mana ko biyagua nde wali ogoni homelo bo wahalu nogo biangoyaguabi mbira wali ogoni yaga hayadagobi homelo bo waholene nga. Mana ko ogoni libunime biyagonaga homolene nga. ");
INSERT INTO hui_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Agali mbirame ibu aba wane bedagoyaguabi ibu ai̱ya wane bedagoyaguabi ibu mbaliniore bedago dabu biyagua nde wali agali ogonidagua birago libu mana koore biya. Anidagua biaga kago tí baba mandagi nahelo tígua wali agali bibahendenaga deni wali agali ogonilabo waratagi holene nga. Agali ogonime ibuni mbalini nguniorela mana ko bero lalu mini wuwa biyagonaga genda yu holene wulebira. ");
INSERT INTO hui_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Agali mbirame wali ege habolo bedangi mandagi yu paliribiyagua nde libugua Anduane Homogonaga deni mana ko dodoheore biya. Ani biyago ai wali agali ogonilabo libu haru Anduane Homogonaga wali agali karu heba mandagi nahelo bo talu pelalimu. ");
INSERT INTO hui_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Agali mbirame ibu ai̱ya hagibunibi ibu aba mbalinibi kayu biyagua agali ogoni ibugua ibu dameneore yo handalu mana ko biyago ai libugua mana ko biribigonaga genda libuni yu holebira. ");
INSERT INTO hui_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Agali mbirame ibu aba hamene one bedago kayu biyagua mana ogonibi biragome ibu aba hamene kago mo taga holebira. Anidagua biragome wali agali ogonilabo libunime mana ko biribigonaga genda yu holeberabi. Anigo agali ogoni ibugua wali ogoni dabu biyagua nde libunaga waneigini mbira nahonowi halu homolebira. ");
INSERT INTO hui_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Agali mbirame ibu hamene one haru pubagi halu dabu biyagua nde ibugua Anduane Homogonaga deni mana koore bialu ibu hamene mo taga holebira. Ani biragome libunaga waneigini mbira nahe howa walibi agalibi homolebira. ");
INSERT INTO hui_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","Anduane Homogo ibugua lalu, I̱na tí Kenana dindiha haru poleberogo dindi ogonime tí magu tagu wiatagi nahelo tígua i̱naga bi mana lo werogoni baya hangu manda biaabo halimu. ");
INSERT INTO hui_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Tí Kenana wali agali Anduane Homogo mitangi nabiaga karume mana ko biaga ngaru talialu nabilimu. Tigua mana ko uruni bialu heagola i̱na tihondo turu naheore henego kogoni. Ani howa ai i̱na tí dindi ogoni karulo halimulo Kenana wali agali karu wahalu pelo bo batagi holebero. ");
INSERT INTO hui_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Dindi ogoni bayaleore dindi ibane bere wialu tomo bayale anda hai haga ngago tí karulo halimulo lalu abale ngulebero lo wirugoni. Ani lo wirugo ai dindi ogoni mo nguleberoore larogoni. I̱ Anduane Homogo tínaga Ngode Datagaliwabe kogo i̱na tí wali agali tara tara dewaore heago dombeneha hemiria i̱na tí i̱ninaga wali agaliore halimulonaga dabo bagi ho helene kamigoni. ");
INSERT INTO hui_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Anigo ai ema bialu piaga ariabi ega bedaru ariabi bibahende tígua balu nolene biru ngaru bayale lene agodabe handa i̱naga deni ko dodohe agodabe baya hangu dabo handalu halimu. Egabi ema bialu piaga maru bedarubi pagaya tara tara bedarubi bibahende dodohe ogoale beda lalu langiai harugoni. Tígua balu nolene nawi lalu langirugo bi mo wahalu bo narimiyagua nde tíbi i̱naga deni ko dodohe holeberemi. ");
INSERT INTO hui_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","I̱ni Anduane Homogo kogo i̱na tí wali agali tara tara bu hearu dombeneha hemiria dabo bagi halu i̱ninaga wali agaliore halimulo dabo helarugoni. I̱naga mini tigabiorebi bayalebi howa baya buruguleore kogoni. Ai tíguabi nde mana tigabi bayaleore ngaru talialu bialu howa tíni baya buruguleore hole halimu. ");
INSERT INTO hui_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","Wali agali mbirame homene dinini mo bila haga bialu dininime hame ngago hale halu heagua nde ogonidagua bialu kago ibuni homelo bo waholene nga. Wali agali mana ko ibunime bialu hayadagonaga pani ibuni homolene ngago ai wali agali bibahendeme ege to̱le̱ dugualu bo homelalimu, lalu Anduane Homogohanda Mosesehondo lamini. ");
INSERT INTO hui_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Anduane Homogohanda Mosesehondo lalu, Loma binigo mo miaga agali Arono aria karuhondo bi ogodagua lamibe. Tínaga damene bu karu aria mbirago homayagua dara howa mana biaga ngadagua nabilimu laro. Mana ogonidagua beramigome i̱naga deni tí ko dodohe holeberemigo nabilimu. ");
INSERT INTO hui_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","Anigo í̠ aba ai̱yaoreyaguabi waneiginiyaguabi hameneoreyaguabi ");
INSERT INTO hui_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","mbaliniore mbira agali nape í̠ andaga biragabi uruni homayagua nde dara howa biaga mana ngago ai harugo lowa tí mo ko holene wiaguabi wahalu mana ogoni bilimu. ");
INSERT INTO hui_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Anigo loma binigo mo miaga kago ibu balibuni homayagua nde ibugua dara howa mana biaga ngago ibu mo dodo holigo bulene nawi laro. ");
INSERT INTO hui_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Loma minigo mo miaga kamigome dara holenaga mana biaga ngamigo bialu howa tínaga mandari lene maruha podowa hagadaguabi angari podo tubagi halubi tínaga tingini darama ibilo podolenebi mana uruni bulene nawiore laro. ");
INSERT INTO hui_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Ani larogoni irane loma binigo mo miaga kamiru tí i̱naga dabo bagiho heledogoni ndobe. Ai i̱ tínaga Ngode Datagaliwabeore kogonigo tígua i̱naga mini bope halu mo nagalone nahalimu. Tígua wali agalime mbirale yalu ibiragola mo yalu i̱hondo loma buwa mo ngialu uruni i̱naga tomo bu ngiadai biradagua biaga kamigoni. Ani kamigo tígua mana ko ngagoha erembira mialu tí i̱naga dabo bagiho helene kamigo manda bialu haabo halimu. ");
INSERT INTO hui_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Loma binigo mo miaga kamigo damene tí i̱ninaga agaliore kamigoni. Ani kamigo manda bialu tígua wali mbira agali kayu bima ibaga biaga bedagobi agali heba mandagi palene bedagobi wali ibu agalinime wahene bedagobi uruni ale biaga biraga bidago tígua dabu bulene nawi laro. ");
INSERT INTO hui_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Wali agali bu karume tí i̱naga loma binigo mo miaga kami leneore kalo manda bilo halimu. Irane tí i̱naga tomo lomabu ngiagaore hene kamine de hendelo halimu. I̱ Anduane Homogoore kogoni. I̱ni mini baya buruguleore howa mana bayale tigabiore ngago biaga kogoni. Ani howa i̱ninaga wali agaliore lene karu bibahende mo tara helowa mana bayale tigabi hangu bialu helonaga dabo bagi helaga kogoni. ");
INSERT INTO hui_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Loma binigo mo miaga kamiru tí waneme agali kayu yama ibaga biaga bereagua mana ogonibi bialu bedagome ibu aba mo taga holebira. Anigo wandari ogonidagua birago ibu homelo wali agalime ira bo delowa irame do tauladaga helo irani delolene nga. ");
INSERT INTO hui_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","Loma Binigo Mo Miaga Haguane Timbuni kago ibu biabe tara mbira yu kagoni. Ibunaga emboneni weli baya taraore odo wialu loma binigo mo miaganaga aga karulo kagoni. Ani howa ibu damene mbirago homaragola ibugua dara ho howa biagadagua ibunaga mandari bame helo wahowa manda pere nabi holene nawi. Ibugua mandari baya hangu pere bu holene nga. Ibunaga aga bu kago lerelo waholene nawi. ");
INSERT INTO hui_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Loma Binigo Mo Miaga Haguane Timbuni biagome ibu damene homene tingini moaho ngagoha polene nawigo napolebira. Ibu aba ai̱yaore homayaguabi i̱naga deni ibuni mo dodohe holigo ibu wali agali duguanda kagoha daraho yalu polene nawigo napolebira. ");
INSERT INTO hui_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Ibugua i̱naga Balai Anda Hobane Loma Bia Hene helo wahalu duguanda piyagua nde i̱naga Balai Anda Hobane Loma Bia Hene kago mo mebia halu mo dodo holebira. Ibu Loma Binigo Mo Miaga Agali Haguane Timbuni helo tígua weli baya taraore i̱na ngirugome odo wialu dabo helarimigoni ka. Ani kago ai ibugua homene tingini ngagoha polene nawiore laro. I̱ Anduane Homogo kogoni. ");
INSERT INTO hui_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Loma Binigo Mo Miaga Haguane Timbuni ibugua wali mbira agalila napalene bedago dabu bulene nga. ");
INSERT INTO hui_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Wali mbira ibu agalini homene dalo bedagobi agalinime wahene bedagobi agali kayu yama ibaga biaga bedagobi dabu bulene nawiore. Ibu damene loma binigo mo miaga kago wane mbira mabuage biruwa agalila napalene bedago dege dabu bulene nga. ");
INSERT INTO hui_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","I̱na bi o larogo mo wahalu puwa ibugua wali dabu bulene nawi larogo dabu biyagua nde ibunaga waneigini harago damene i̱naga deni dodohe holebira. I̱ Anduane Homogo kogome agali ogoni ibu i̱ninagaore helo dabo helalu Loma Binigo Mo Miaga Haguane Timbuni helo heledogoni, lene. ");
INSERT INTO hui_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Anduane Homogohanda Mosesehondo lone lamialu lalu, ");
INSERT INTO hui_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","Í̠na Aronohondo ogodagua lamibe. Í̠ damene mbira áyu karu ariabi mani holebirarubi mbirago ibunaga tingini mo ko hene heagua ogoni ibugua tomo mbirale i̱hondo lomabu ngulene nawi. Mana ogonidagua wia a̱i̱ holebira. ");
INSERT INTO hui_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Agali maru tinaga tinginiha mo kohe damene kagome tinaga tomo i̱hondo lomabu ngulene nawiore. Agali o larogoni mbirali de kohebi ge kohebi dengui mo ko henebi ibu ai̱yahanda gi geru tubagi ndindele taba hanayaguabi nde tigua i̱naga lomabu delaga nabulebira. ");
INSERT INTO hui_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","Agali gi ge kuduguheyaguabi ");
INSERT INTO hui_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","erene koheyaguabi agali tubagi gayabogoliyaguabi deha dere biaga heaguabi dongoneni derebi heaguabi agali tinginini haga alego mbira naheyaguabi urunibi damene kagome loma binigo mo miaga agali nahabehe holebira. ");
INSERT INTO hui_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Agali Arono aguanene tí aria kago mbirago ibuha tingini mo ko hene urunibi mbira heagua tigua i̱naga loma binigo mo ngiaga nahelo laro. ");
INSERT INTO hui_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Ani bialu tomo i̱hondo tígua lomabu ngini tíni nolene ngago aria ibubi nolebira. Anigo tomo i̱nagaore lalu lomabu ngini ngago tí nalimulo ngerogo aria ibubi nolebira. ");
INSERT INTO hui_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Agali mbirali tingini kohe ogonibigo ibugua Balai Anda biagonaga tamuha Hobane Loma Bia Heneore biagola hobaki hene labolabo timbuni gerelape ho ngagoria hapara naholebira. Ani bialu lomabu delaga dabu ngagoriabi hapara ho naholebira. Mbirale bayale i̱nagaore wiabagi ho winigo ngagoria kaware ibiyagua ibugua uruni i̱naga deni mo ko holebirago polene nawiore larogoni. Ani larogoni irane i̱ni Anduane Homogo kogoni howa mbirale uruni i̱ninagaore ngelo dabo bagiho winigo ngeledo, lalu Anduane Homogohanda lene. ");
INSERT INTO hui_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Bi uruni anidagua laya, lalu Mosese ibugua bi uruni Aronohondobi Arono igini hearuhondobi Isaraele wali agali hearuhondobi lamiai hene. ");
INSERT INTO hui_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Anduane Homogohanda Mosesehondo lamialu lalu, ");
INSERT INTO hui_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","Arono halu ibu igini karuhondo ogodagua labe. Isaraelealirume mbirale lomabu yalu ibiraru i̱ninagaore ngalo manda bilimu. Ani manda bialu loma bini uruni i̱ninagaore nga lowa baya hangu handayaho halimu. Anidagua handayaho naharimiyagua nde tígua i̱ mini lene timbuni kogo mo nagalone heloleberemi. Anduane Homogo i̱ore kogoni. ");
INSERT INTO hui_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Loma binigo mo miaga kamiru aria áyu karubi mani holebirarubi mbirago ibugua Isaraele wali agali bu karume mbirale i̱hondo lomabu yalu ibiragoria ibu i̱naga deni dodo kaore howa kaware hapara holene nawiore. Ibu kaware pu hayagua nde i̱na agali ogoni ibu loma binigo mo miaga nahelo bo talia tagi holebero. Mana ogoniore baya hangu talialu bialu haabo halimu. Anduane Homogo i̱ore kogoni. ");
INSERT INTO hui_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","5","Loma binigo mo miaga kamirubi mani holebirarubi tí aria mbirago ibu tinginini dere timbuni mbira bidago angibu tuguda tagitagi biyagua nde agali ogoni ibu i̱naga deni dodohe holebira. Ani holebirago ibugua i̱naga biabe biaga howa mbirale loma bini ngaru nolene nawi. Loma binigo mo miaga agalime mbirali homenegonaga mbirale dodohe ngaru ela hayaguabi ibunaga tinginiha ibane bame tagira ibiyaguabi ogoni i̱naga deni dodohe ka. Nogo tarabi ema bialu piagarubi i̱naga deni ko karu aria mbirago ela hayaguabi wali agali i̱naga deni dodohe karu aria mbirago ela hayaguabi uruni damenego bibahende ela hayagua nde ibugua i̱naga tomo loma bini ngago nanolebira. Ibugua bayale hole mana bulene winidagua biyagua nde ibu i̱naga deni dodo nahe howa tomo lomabu minigo mo miaga howa nolene ngaru ta nabi nalu holene karulape nga. ");
INSERT INTO hui_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","Loma binigo mo miaga kamiru aria mbirago ibugua mana mbira biragome ibu mo dodohe hayagua ibu dodohe dege kane alendo halu ni anda polebira. Ani bialu ibuni wayawaya biagane mana ngadagua buwa dodo nahe howa i̱hondo lomabu bo delole ngagonaga mbirini nolene ngadagua nolebira. Anigo ibu wayawaya biagane mana ngadagua nabi hayagua nde tomo ogoni nanolebira. ");
INSERT INTO hui_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Ani howa ni paliragola nde ibu i̱naga deni dodo nahe karulape howa tomo i̱hondo loma bialu loma binigo mo miaga karume nelo winigo ibugua nolene karulape nga. ");
INSERT INTO hui_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Ibugua nogo bame homene ngagobi nogo gabua maru karume bo wahene ngagobi nolene nawi. Uruni nayagua nde ibu i̱naga deni dodohe holebira. Anduane Homogo i̱ore kogoni. ");
INSERT INTO hui_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Loma binigo mo miaga kamiru tígua bi mana ogoni langirugoni baya hangu taluwa bialu holene nga. Tígua bi ogoni mo nagalone halu waharimiyagua nde koore ogoni birimigome nde i̱na tí bo homelolebero. I̱ Anduane Homogo i̱na tí i̱naga loma binigo mo miaga agali halimulo dabalu helarugo i̱nime tíhondo bi ogonidagua laro. ");
INSERT INTO hui_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Loma binigo mo miaga kamiru tínibi tí damene karu hangumebi tomo wali agalime i̱nihondo lomabu yalu íbu ngini ngaru noleberami. Wali agali marubi tínaga yolo biabe biaga karubi tí andagani nenege íbu hene karubi ti tomo ogoni aria nanolebira. ");
INSERT INTO hui_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Anigo garabaya biabe ale bia haga agali waliyaguabi loma binigo mo miaga biago ibunaga munime yolo bini karu tibi tinaga waneigini karubi ti bibahendeme loma binigo mo miaga agalinaga tomo uruni aria nolene nga. ");
INSERT INTO hui_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Loma binigo mo miaga kago ibu wane bedago loma binigo mo miaga ndo agali tara kagome dabu biyagua nde wali ogoni ibu tomo i̱hondo loma bini ngago nanolebira. ");
INSERT INTO hui_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Anigo ibu wane wali ogoni agalini homaragola ibu hibaria bereaguabi ibu agalinime wahene biruwa waneigini nahe bereaguabi nde ibu aba andaga dai buwa loma binigo mo miaga karu ti miaga ngaru aria tomo ibu aba andagaha nolene nga. Anigo loma binigo mo miaga agali ibu damene dege karume tomo ogoni aria nolene nga. ");
INSERT INTO hui_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Mbirali ibu loma binigo mo miaga kago damene ndo howa ibu manda nabi howa tomo i̱hondo lomabu ngini ngago aria mbira nayagua nde tomo o nayadagonidagua loma binigo mo miaga kagohondo dano hongolebira. Ibugua tomo duria neneyagua nde ibugua waragane tago halu dano hongolene nga. ");
INSERT INTO hui_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Anigo loma binigo mo miaga karu tigua i̱hondo tomo lomabu ngini ngaru mo mebia holigo wali agali ta nabi bu karume nanelo bayuwa mamage halu handayaho holene nga. ");
INSERT INTO hui_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","Loma binigo mo miaga kagome wali agali ta nabi mbirago tomo ogoni aria nelo miyagua nde o nayadagonime ibuha mo ko halu genda yu holene anda ibulebira. Ani ibiragola ibugua tomo ogoni nayagonaga dano hongolene wulebira. Ani larogoni irane tomo ogoni nayagonaga Anduane Homogo i̱na i̱ninagaore mo wiabagi hene nga, lene. ");
INSERT INTO hui_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Anduane Homogohanda Mosesehondo lamialu lalu, ");
INSERT INTO hui_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","Í̠na bi ogo larogoni Arono halu ibu igini bu karuhondobi Isaraele wali agali bu karuhondobi lamibe. Agali mbira Isaraeleali kamiru ariabi agali dindi tara howa tí heba íbu hene karubi tí bibahendeme nogo mbira i̱hondo loma bialu irani dai helonaga haru ibiyagua nde ogonidagua bulene nga. Loma ogoni agali biago ibugua ani bule lalu bi lowinigo lola helonaga haru ibiyaguabi ndo ibuni hameme lomabu delole haru ibiyaguabi nogo biago ko ndo dere durubi mbira nabiore bayaleore kago haru ibulene nga. ");
INSERT INTO hui_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","Loma ogoni i̱na turu howa mo yuliyanaga nogo uruni bulumagayaguabi sibiyaguabi memeyaguabi wangabe mbirago dere durubi mbira nabiore kago bo loma bule haru halu ibulene nga. ");
INSERT INTO hui_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Baya hangu hale halimu. Tígua nogo ko derebi kago lomabu bo delole haru halu ibirimiyagua nde Anduane Homogo i̱na tínaga loma ogoni hondowa turu naholebero. ");
INSERT INTO hui_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Agali mbirame Anduane Homogo i̱nila ho gimbu bulenaga loma bo delole haru ibalu loma ogoni ibunime ngule lowa bi lowinigo lola helonaga haru ibiyaguabi ibuninaga hameme lomabu delole haru ibiyaguabi nde nogo ogoni ibu dere durubi nabi bayaleore kago hondowa haru halu ibulene nga. Tígua ogonidagua birimiyagua nde i̱na tínaga loma ogoni hondowa turu howa mo yulebero. ");
INSERT INTO hui_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Tígua nogo de kohebi ge kohebi tingini mo kohebi dere timbunibibi kindubibi uruni ale mbirago i̱hondo lomabu delaga dabu ngagoria ogoni loma bialu bo de nalalimu. ");
INSERT INTO hui_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Tíninaga hameme bo delole haru ibirimiyagua nde nogo gi ge banayaguabi gi geru bereabiyagua nde karulapego bo delalimu. Anigo tígua ala i̱hondo lomabu ngule lowa bi lowinigo lola helonaga loma bo delole haru ibirimiyagua nde nakarulapedago bo de nalalimu larogoni. ");
INSERT INTO hui_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Nogo wangabe pindu mo waheneyaguabi mo ko heneyaguabi ani bini kago i̱hondo bo lomabu nangilimu. Tí daluha nogo kagonaga mbirale ogonidagua mo ko holeneore nawigo nabilimu. ");
INSERT INTO hui_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Agali mbirame dindi taraha howa nogo haru halu ibuwa ngirago i̱hondo bo loma bialu ngulene nawiore larogoni. Nogo ogonibigo i̱ninaga deni bayale ndo holebira. Ani birimiyagua i̱na loma ogoni alego hondowa turu naholebero larogoni, lene. ");
INSERT INTO hui_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Anduane Homogohanda Mosesehondo lamialu lalu, ");
INSERT INTO hui_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","Nogo bulumaga sibi memerume igini yu heagua nde igini ogoni horo karu ibu angibunila mandagi helo helalimu. Ani helowa mani i̱hondo lomabu delaga dabu ngagoria loma bialu bo delole haru halu ibuwa bo delarimiyagua nde i̱na loma ogoni hondowa turu howa mo yulebero. ");
INSERT INTO hui_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Anigo nogo bulumagabi sibibi memebi uruni ale mbirago igini angibuni heba horo mbiru hanguni bo palu buwa loma bo delolene nawigo anidagua nabilimu. ");
INSERT INTO hui_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Tígua Anduane Homogo i̱nihondo ka̱i̱ lolenenaga mbirale loma bialu bo delarimiyagua nde loma bo delaga mana ngadagua talialu bo delaramigola i̱na loma ogoni hondowa í̠hondo turu holebero. ");
INSERT INTO hui_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Ani bialu loma ogoni bo delaramigonaga podo weramigo horo mendengi nole podo ngela nabi horo ogoningi dege nai halimu. ");
INSERT INTO hui_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","Anduane Homogohanda lalu, I̱ Anduane Homogoore kogonigo i̱na mana lo ngogo baya hanguore hale halu taluwa bilimu. ");
INSERT INTO hui_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","I̱naga mini daligaore lene kogo mo yo hondolene nawiore. Isaraele wali agali tígua i̱ mini tigabi baya buruguleore kogoni manda bilimu. I̱ni Anduane Homogoore kogo howa i̱na tí mo tiga bialu bayuwa dabobagi ho helaga kogoni. ");
INSERT INTO hui_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","I̱ tínaga Ngode Datagaliwabeore holenaga i̱na tí Iyibi dindiha hemiria haru tagira ibirugoni. I̱ Anduane Homogo i̱nime anidaguaore biru, lene. ");
INSERT INTO hui_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","2","Anduane Homogohanda Mosesehondo lalu, Isaraele wali agalihondo bi uru lamibe. Horo taratara tuho werogo pugulani hondowa wali agali tigua horo uruni Anduane Homogonaga ngago i̱ mitangi bialu lotu lole ngoai harangi bilo ogo. ");
INSERT INTO hui_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Horo waragaru tíninaga biabe biaga wirimigoni. Horo kane Sabada horo ogoningi ha̱lo holene ngago manda bilimu. Horo ogoningi biabe nabi wahowa i̱naga mini mitangi bialu lotu lole ngoai ho halimu. Dindi mendeha pu harimiyaguabi Sabada horo ogoni Anduane Homogonaga ngalo mandabu halimu. ");
INSERT INTO hui_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Bi langeroruni bayuwa loyogo lalu wali agali lamiai halu horo ogongi ogoale bilimu laruru mo ngoai howa bayuwa bilimu. ");
INSERT INTO hui_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Bolangua Halu Penegonaga Horo Anduane Homogo mitangi howa turu haganenaga lotu ogoni ege mbiranaga horo deneni (14) alendo ni paliragola horo ogoni tenialu holene nga. ");
INSERT INTO hui_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Horo nguini (15) haragola Mberedi Yidi Nahe Hirini Nolenenaga Horo holebira. Ogoningi howa horo karu mberedi yidi nahe hirinigo hangu nolene nga. ");
INSERT INTO hui_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Horo karunaga horo mbira haruagola biabe beramilidagua nabi Anduane Homogo mitangi bialu lotu lole ngoai halimu. ");
INSERT INTO hui_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Horo karuni tígua Anduane Homogo i̱nihondo tomo lomabu ngule yalu ibalimu. Horo kanego haragola biabe beramilidagua nabi Anduane Homogo mitangi bialu lotu lole ngoai halimu, lalu Anduane Homogohanda Mosesehondo lamini. ");
INSERT INTO hui_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","10","Anduane Homogohanda laabo halu lalu, I̱na dindi nguleberogoria anda puwa tígua widi hongowa lini pigane hini dedago huba mbira loma binigo mo miaga agali karia bu yalu ibalimu. ");
INSERT INTO hui_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Ibugua ogoni gime yuwa Anduane Homogo i̱naga deni howa yu wigiwaga lalu loma bulebira. Ani biragola i̱na tíhondo turu holebero. Loma binigo mo miaga ibugua widi lini ogoni Sabada horo bolangua kagola horo mendeni loma bulebira. ");
INSERT INTO hui_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Horo widi lini ogoni lomabu meramingi nogo sibi igini wangabe mali mbira bolangua nahe ko dere durubi nabi mbira bo lomabu dabuni delai hole haru ibalimu. ");
INSERT INTO hui_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Ogoni heba balawa magi kilogarama kira olibe lini ibane hamaga halu tomo loma ogonidagua bu delaramigola Anduane Homogo i̱na nga bayaledane hondowa turu holebero. Ngiyaruni ngiamaga halu waini ibabi magi mbodoli emene kira lita mbira hambu yalu ibuwa ngulene nga. ");
INSERT INTO hui_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Widi lini pigane dedago ogoni gahengeyaguabi hiriniyaguabi daweneyaguabi tí nolene nawi. Ala i̱hondo lomabu nguwa tígua widi lini ogoni aria nalu holene nga. Mana ogoni tínaga aguanene mahaore holebirarumebi ogonidagua dege biaabo holene nga. ");
INSERT INTO hui_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Widi hubua mbira gandulo yalu Anduane Homogo i̱ ngule eberamingi howa sarere karia daga lalimu. ");
INSERT INTO hui_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Ani buwa sarere kane daga lamaro beramigonaga Sabada haragola sarere halinigonaga horo mbira (50) ogoningi widi lini pigane hini denego halu mende Anduane Homogohondo loma bule yalu ibalimu. ");
INSERT INTO hui_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Isaraele agali mbira ibu one waneigini heba bibahendeme mberedi hirini kira degedege i̱hondo lomabu ngule yalu ibalimu. Mberedi ogoni labo balawa genda magi kilo kira muwa ogoni yidi heba minu magamaga bialu hirulene nga. Yalu ibalu loma binigo mo miaga agalihondo miragola ibugua gime yuwa Anduane Homogo i̱naga deni howa wigiwaga lolebira. ");
INSERT INTO hui_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Isaraele wali agali tígua mberedi ogoni labo heba nogo sibi igini karia bibahende mali mbira bolangua naheru haru ibulene nga. Uruni heba nogo bulumaga wangabe mbirabi sibi wangabe kirabi uruni bibahende ko dere durubi mbira nabiore haru ibulene nga. Uruni bibahende Anduane Homogohondo bo lomabu delagane dabuni delai holene nga. Tígua uruni heba widi lini loma bini biarubi waini iba loma bini biarubi ngulene nga. Anduane Homogo i̱na uruninaga nga hondowa turu timbuni holebero. ");
INSERT INTO hui_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Ani buwa ko birimiru i̱na domo waholiyanaga nogo meme wangabe mbira bo loma buwa dabuni delalimu. Ani bialu nogo sibi igini wangabe kira mali mbira bolangua nahego Anduane Homogo i̱la ho gimbu bimi̱yanaga bo lomabu delalimu. ");
INSERT INTO hui_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Loma binigo mo miaga ibugua mberedi kira biago labo heba nogo sibi igini kira biago labobi Anduane Homogo i̱naga deni howa wigiwaga lolebira. Loma binigo ogoni i̱nihondo loma bia henego ngulebadagoni taraorego loma binigo mo miaga agali karu ti nelo mo mulebero. ");
INSERT INTO hui_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Horo ogoningi biabe beramilidagua nabi Anduane Homogo mitangi bialu lotu lole ngoai halimu. Tínaga waneigini maha holebirarume dindi mendeha pu hayaguabi mana o langerogo biaabo halu holene nga. ");
INSERT INTO hui_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Tígua tínaga mabuni tomo mbirale ngaru bialu howa mabu gibuni lenehayagi ngaru nabi helalimu. Ani buwa maru yu waharamigobi bu dai nabi ani helo wahalimu. Uruni wali agali yagibano karubi wali agali tí aria ndo dindi tarali karubi ti milo ngelalimu. Anduane Homogo tínaga Ngode Datagaliwabe i̱ore kogoni, lene. ");
INSERT INTO hui_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","24","Ege kanegonaga horo mbira haragola biabe damene bibahende wahai howa ogoningi horo tara lowa ha̱lo halimu. Ani bu howa mbelo biguli pu laragola Anduane Homogo i̱ kogoni mitangi bialu lotu lole ngoai halimu. ");
INSERT INTO hui_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Ogoningi biabe beramilidagua nabi howa tomo maru loma buwa dabuni delo i̱hondo ngulene nga, lalu Anduane Homogohanda lene. ");
INSERT INTO hui_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","27","Anduane Homogo ibugua Mosesehondo bi ogodagua lamialu lalu, Ege kanegonaga horo pini haragola wali agalime ko biyaru i̱na domo waholiyanaga mana lo wirudagua biai holene nga. Horo ogoningi tomo mbira nane howa Anduane Homogo i̱ mitangi bialu lotu lole ngoai howa i̱hondo tomo maru lomabu ngilimu. ");
INSERT INTO hui_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Wali agalinaga ko biyaru domo waholene horo ogoni duniniorego ogoningi biabe mbira nabilimu. ");
INSERT INTO hui_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Horo ogoningi mbirali ibu tomo mbira nayagua wali agali ogoni ibu Anduane Homogo i̱naga wali agali ka aria ndo ibu tara haluni ka manda bulebero. ");
INSERT INTO hui_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Mbirali ibu biabe mbira horo ogoningi biyagua ogoni ibu Anduane Homogo i̱nime bo homelolebero. ");
INSERT INTO hui_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Mana ogoni tínaga waneigini mani holebiraru tí dindi tarani hayaguabi mana ogoni biaabo halu holene nga. ");
INSERT INTO hui_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Ege kanegonaga horo dininaga alendo ni paliragola howa horo pininaga alendo ni paliragola dombeneha horo ogoni taraore lowa ha̱lo biralu tomobi mbira nane halimu, lalu Mosesehondo lamini. ");
INSERT INTO hui_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","34","Anduane Homogohanda Mosese ibuhondo lamialu lalu, Bi ogo Isaraele wali agalihondo lamibe. Ege kanegonaga horo nguini (15) haragola Anda Nemandaruha Palu Holene Horo ogoningi nemandaruha horo karu palu halimu. ");
INSERT INTO hui_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Horo uruni holenaga horo pigane harangi biabe bibahende beramilidagua nabi Anduane Homogo i̱ mitangi bialu lotu lole ngoai halimu. ");
INSERT INTO hui_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Horo karu nigoniha i̱hondo tomo lomabu dabuni delowa ngiaabo halimu. Horo halini haragola tíni lone íbu ngoai howa i̱ mitangi bialu lotu lalu tomobi dabuni lomabu delowa ngilimu. Ani bialu biabe beramilidagua nabi horo ogoningi i̱ mitangi bialu lotu lole ngoai halimu. ");
INSERT INTO hui_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","Horo uruni i̱nagago i̱ mitangi bialu lotu lole ngoai howa tomo loma binirubi mbirale bo lomabu irani delai helo delolenerubi widi lini lomabu delolenerubi waini iba lomabu odo wulenerubi uruni horo bibahendeni lomabu ngulene wiyadaru ale ngiai halimu. ");
INSERT INTO hui_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Horo o holeberamigonaga irane galone abale Anduane Homogonaga Sabada horo haragola haga wirimidaguaore halimu. Lomabu ngiai halu maru ngiaga wirimirubi ngiai halimu. Ani bialu loma bini maru tara ngule lo wirimiru heba bibahende ngiai halimu. ");
INSERT INTO hui_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Ege kanegonaga horo nguiningi (15) mabuni tomo mbirale hengene ngamiru bialu howa Anda Nemandaruha Palu Holene ogoni horo karuni Anduane Homogo mitangi halu holene wiyadagua bialu halimu. Horo piganego ogoni taraore lowa biabe nabi ha̱lo halimu. ");
INSERT INTO hui_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Horo piganegoria ira lini bayaleore dedaru do yalu ayage ale yunibi ira marunaga magane yuni dewahebi bu yalu ibalimu. Uruni bu yu howa Anduane Homogo tínaga Ngode Datagaliwabe i̱ mitangi bialu lotu lalu i̱naga mini yaraga halimu. ");
INSERT INTO hui_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Anda Nemandaruha Palu howa horo karuni ani bialu halimu. Tínaga waneigini mani holebirarumebi mana uruni biaabo halu holene nga. ");
INSERT INTO hui_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Isaraele wali agali bibahendeore horo ogoningi haragola anda nemandaruha hangu horo karu palu holene nga. ");
INSERT INTO hui_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","Anidagua beramigola tínaga waneigini mani holebirarume mitangi bialu Anduane Homogohanda Isaraele wali agali Iyibi dindini howa haru tagira piyagola anda bame nemanda aleruni bu pale lama haru halu ibinidalo manda bilo ani bilimu. Anduane Homogo i̱ tínaga Ngode Datagaliwabe kogoni. ");
INSERT INTO hui_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Mosesehanda Isaraele wali agalihondo lamibe layadagua Anduane Homogonaga mini yaraga hole horo uruni agua bilimu lalu lamiai hene. ");
INSERT INTO hui_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Anduane Homogohanda Mosesehondo lamialu lalu, ");
INSERT INTO hui_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","Isaraele wali agalime olibe lininaga weli bayaleorego i̱naga Balai Anda biagoha lamu hale ngaruha berelole yalu ibalimu lalu lamibe. Ani yalu ibiragola lamu hale wá haabo helo mbiraga bibahendengi delaho wiaabo hole loma binigo mo miaga karume de hondo haabo holebira. ");
INSERT INTO hui_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Arono ibugua lamu hale uruni alendo dela haragola dalu kane dege gao lolebira. Lamu hale uruni Anduane Homogo i̱naga deni howa Balai Anda Hobane Loma Bia Heneoreha i̱naga Habo Nalolene Bi lo winigonaga Mbogoyi biago ngagola hobane mende Loma Bia Hene kagola tubari labolabo timbuni gerelaho wini biago tagirahayagi ngagoni. I̱naga bi mana ogoni tíhondobi tínaga waneigini aguanene mani hama polobadarumebi bialu haabo helo langerogoni. ");
INSERT INTO hui_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Arono ibugua lamu hale wiagane irane ngolo bayaleme wabini ngagoni lamu hale biaru delaabo helo baya hangu handayaho haabo holebira. Lamu hale uruni mbiraga bibahendengi daho ngane de hondoliya hundulani hondowa handayaho haabo helolene nga, lalu lene. ");
INSERT INTO hui_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Anduane Homogohanda Mosesehondo laabo halu lalu, Í̠na balawa bayaleru genda magi kilogarama homberia (12) muwa ogonime mberedi homberia (12) wabibe. Genda magi kilogarama mbira mbirame mberedi mbira mbira wabigi bibe. ");
INSERT INTO hui_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Ani wabuwa dagia ira agasiamebi ngolo bayalemebi wabini ngago i̱ninaga deni mberedi uruni mo dabadaba howa waragaria halu mbirago duguni mbira wialu waragaria halu mende duguni mende wibe. ");
INSERT INTO hui_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Ani ngelowa mberedi waragaria duguni kira dagia ngagoriani ira hagua ngabilo delaga mini inisenesi heba mo ngelalu tígua mberedi i̱hondo ngiradagua inisenesi ngabi ogoni aribia halu delalimu. ");
INSERT INTO hui_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Sabada horo bibahendengi loma binigo mo miaga karume mberedi i̱hondo loma bialu dagiani i̱ni de hondoliya wiaabo holene nga. Habo nalolene bi mbira tí baba lo werogonigo Isaraele wali agalime mana ogoni bialu haabo holene nga. ");
INSERT INTO hui_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Mberedi ogoni Arono halu ibu aria loma binigo mo miaga holebirarubi tigua nolene wulebira. Isaraele wali agali karume tomo ogoni i̱nihondo lomabu ngini ngago manda bialu loma binigo mo miaga karu tigua Anduane Homogonaga Balai Anda pabe tamuha howa nai holene nga. Tomo ogoni i̱ninagaore ngago i̱na nde loma binigo mo miaga karu ti nelo mulebero, lalu Anduane Homogohanda Mosesehondo bi ogoni lamini. ");
INSERT INTO hui_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","11","Agali mbira henego ibu aba Iyibiali howa ibu ai̱ya Isaraele wali berene. Ibu ai̱ya Dana hameigini aria agali Dibiri mbira henego wane mini Selomidi berene. Agali ogoni ibu balai anda bu harimidaruha ti haru mandagi howa horo mbirungi ibugua Isaraeleali mbira heagola keba howa gungu bini. Gungu bialu howa Selomidi igini ogoni ibugua Anduane Homogo mini lalu bi koore lene. Ani layagola wali agali bu hearume hale howa agali ogoni Mosese hearia haru halu pene. ");
INSERT INTO hui_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Ani haru piyagola Mosese ibu Anduane Homogohanda ogodagua bibe lalu ladai bilonaga ibugua hale ala hole agali ogoni garabaya helo helene. ");
INSERT INTO hui_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Ani heleagola Anduane Homogohanda Mosesehondo lamialu lalu, ");
INSERT INTO hui_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","Agali ogoni balai anda bu karu yu wahalu haru tagira pilimu. Ani buwa wali agali bibahende agali ogonime i̱ mini lalu bi ko layane hale harimidaru tígua agali ogoninaga haguaneni gi wiai halimu. Agali ogoni ibugua bi ko layagonaga ibuniha pani nolene nga lowa wali agali maru bu karu de hendelonaga anidagua bilimu. Ani bialu wali agali bibahendeme ege to̱le̱ dugualu baga baga bialu balu homelalimu. ");
INSERT INTO hui_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Ani bialu mani Isaraele wali agali bu karu lamialu ti mbiralime i̱ mini lalu bi ko mbira layagua nde ibu pani nolene wulebira. ");
INSERT INTO hui_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Ibugua bi ko lalu howa i̱naga mini Anduane Homogo layagua nde ibuni homolene nga. Agali ogoni ibu Isaraelealiyaguabi agali dindi taraha howa tí heba íbu heneyaguabi ibugua i̱naga mini lalu bi ko layagua nde ibuni homoleneore nga. Agali ogoni homelo wali agali bibahendeme ege to̱le̱ dugualu homelo bolene nga, lene. ");
INSERT INTO hui_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","Anduane Homogohanda lalu, Mbiralime wali agali mende kago homelo bo wahayagua nde ibunibi homelo bo wahalimu. ");
INSERT INTO hui_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Mbiralime mendealinaga nogo bulumaga sibirubi hinu kago bame homelo bo wahayagua nde nogo bayagonaga kango aribia holene nga. Mana ogoni ale mo tiga bulenego agali mbirame agali mendenaga nogo kago bo wahayagua ibuni bo wahayago aleme kango hongolene nga. ");
INSERT INTO hui_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Agali mbirame mendeali kago mo ko halu bayagua nde ibunibi o biyadagonidagua dege biadai bilimu. ");
INSERT INTO hui_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Agali mbirago ibugua mendealinaga kuni mbira bo tagalayagua nde ibuninaga kuni mbirabi bo tagalalimu. Mendealinaga de bo halu wahayagua nde ibuninaga debi bo halu wahalimu. Mendealinaga ne bo hondayagua nde ibuninaga nebi bo hondo wahalimu. Agali mbirame mendeali kagohondo birago ale ibuniha biadai biai halimu. ");
INSERT INTO hui_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Agali mbirame mendealinaga nogo kago bayagua nde nogo ogoni aleme dege kango hongolene nga. Anigo mbiralime agali mende kago homelo bo wahayagua nde ibunibi homelo bo waholene nga. ");
INSERT INTO hui_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","I̱na mana ogoni Isaraele wali agali tínagabi wali agali dindi taraha howa tí baba mandagi íbu hene kamirubi tí bibahendenaga lo wero. I̱ Anduane Homogo tínaga Ngode Datagaliwabe kogonigo aniore bilimu laro, lene. ");
INSERT INTO hui_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Anduane Homogohanda bi ogoni layadagua Mosese ibugua Isaraele wali agali bu hearuhondo lamiyagola tigua agali Anduane Homogo mini lalu bi ko laga biago minuwa balai anda bu hearu yu wahalu haru tagira pene. Haru tagira puwa wali agali hearume agali biago ege to̱le̱me homelo bo wahene. Ani bialu Isaraele wali agali tigua Anduane Homogohanda Mosesehondo laminigo hale howa talialu layadagua bini. ");
INSERT INTO hui_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Mosese ibu Hari Sainaini heagola dege Anduane Homogohanda ibuhondo lalu, ");
INSERT INTO hui_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","Bi o larogo Isaraele wali agali lamialu au labe. Tígua dindi i̱na tí nguleberogoria pu howa mali kane haga biragola mabuha tomo damenego nahenge dindi bame ngelo halimu. Tígua Sabada horongi ha̱lo hagadagua dindibi mali kane haragola ha̱lo ngelo wahalimu. Mali kane ogoni ani wiabagi howa i̱ninaga nga lene ngelo wahalimu. ");
INSERT INTO hui_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Mali waragaria haramigo andaneha howa tínaga mabu ngemiruha tomo tara tararu hangalu pu mbira mini gerebi lini dedaru do wialu magane lini bayale dabe nahe karu gandulo wahaga bigi bilimu. ");
INSERT INTO hui_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Anidagua bialu howa mali kane haragola dindi bame ngelo wahalimu. Ani bialu mali ogoni i̱ninaga wiabagi howa ngelalimu. Ani bialu tígua tomobi nahenge gerebi magane karubi gandulo wabia nahe ngelalimu laro. ");
INSERT INTO hui_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Widi minana anda ho heagua nde gandu lowa tínaga tomo wiaga andaha mo wia nabilimu. Pu mbira mini gerebi magane gandu nale karunaga lini deagua nde tígua do pingidalu waini iba wabulene nawi. Mali ogoningi dindi bame ngelo wahalimu. ");
INSERT INTO hui_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Mali ogoningi mabuha tomo minana anda harago bialu nalimu. Tomo wiaga andaha bu yalu puwa ngela nabilimu. Mbirale tomo tara tara wabigi bulene ngago ale wabulene nawi. Ai tínibi wali agali tínaga garabaya biabe ale biahaga karubi wali agali biabe maru biaga karubi wali agali tara tara tí heba mandagi íbu hene kamirubi tí bibahendeme tomo uruni bialu nolene karulape. ");
INSERT INTO hui_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","Ani bialu nogo hinini damene bibahende bulumagabi sibi bu karubi meme karubi ti nolenebi karulape wulebira. Gabua tara tara biru karu tibi na dege bulene karulape, lalu Anduane Homogohanda lene. ");
INSERT INTO hui_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","Anduane Homogohanda laabo halu lalu, Tígua mali karia dege mbira mende laga bialu mali karia dege kahalu dagalamaga harimiyagua nde mali pira mariani dira (49) holebira. ");
INSERT INTO hui_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Ani haragola mali ogoninaga ege kane halu horo pini laragola agali maru Isaraele dindi bibahendeha purogo lalu dindi gibuni lenelene ngaruha pialu tígua mbelo biguli pu lalimu. Horo ogoningi wali agalinaga Ko Domo Waholene Horo ngago Anduane Homogo i̱na wali agalinaga ko ngaru domo wahai holebero. ");
INSERT INTO hui_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Mali pira daunigonaga (50) horo pigane haragola mbelo biguli pu laramingi mali ogoni Anduane Homogo i̱ninagaore wiabagi hene wulebira. Mali ogoningi wali agali bibahende kamiru tínaga genda yu haramiru golope hai hayago ai tí turu howa miniha dungulo holene nga. Mali ogoningi tígua dindi mbira agali mendenaga yolo bu winiyagua nde dindi aba ibunihondobi ibunaga waneigini aguanene bu karuhondobi miadai bilimu. Wali agali maru tínaga garabaya biabe ale biahalu hagayagua uruni bibahende golope halu tini dameneru karia dai bilo pudaba lalimu. ");
INSERT INTO hui_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Mali pira dauni (50) ogoningi wali agali bibahende bu miniha turu howa dungulo holene horo tagira ibulebira. Mali ogoningi tínaga mabu ngamigoha tomo damene hongolene nawi. Ani bialu mabuha widi minana anda halu lini dedago dowa tomo wiaga andaha ngelolenebi nawi dege. Pu karunaga gerebi lini dedaru dowa waini ibabi wabulene nawi. ");
INSERT INTO hui_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Mali ogoni bibahende Anduane Homogo i̱ninagaore ngago manda bialu halimu. Ani howa tínaga mabuha tomo minana andaho karu hangu bu nalu halimu. ");
INSERT INTO hui_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","Tínaga dindi mbira agali mende ibu yolo binigo mali ogoningi dindi ogoni aba ibunihondo bame mia dai bilimu. ");
INSERT INTO hui_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","15","Anidagua bulene ngago ai tígua dindi yolo bilo mule howa agali dindi yolo birago ibu mali ogoniha tomo dabane agira halu hongolobadabe ala manda bialu dindi Yadai Bulenenaga Mali agira wiaruabe manda buwa dindi ogoni mendealime yolo bilo mulene nga. Ani beramigola dindi yolo birago ibuguabi nde dindi ogoni karulape ngadagua yolo bulene nga. ");
INSERT INTO hui_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Yadai Bulenenaga Mali tagira ibilo mali dewaore wiagua nde yolo dewa bulene nga. Mali dewa ndo wiagua nde yolo emene dege bulene nga. Ibugua mali dagalowa dindi ogoniha tomo agira daba hangalu nolobadabe mitangi bialu yolo ogoni karulape mulene nga. ");
INSERT INTO hui_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Wali agali tíni damene karu ke̱ howa mo hondo nahalimu. Tígua Anduane Homogo i̱nihondo dege gi howa mana bayale tigabi bulene ngago bialu halimu. Anduane Homogo tínaga Ngode Datagaliwabe kago i̱na bi o larogonidagua bialu halimu, lene. ");
INSERT INTO hui_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Anduane Homogohanda laabo halu lalu, Tígua i̱na bi áyu langerogobi i̱naga bi mana lowini ngagobi baya hanguore taluwa bialu halimu. Tígua anidagua bialu harimiyagua nde dindi i̱nime tí nguleberogoria howa bayale haabo holeberemi. ");
INSERT INTO hui_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Dindi ogoniha howa tomoru dewaore bayale anda haga biragola tígua nalu howa tínibi bayaleore haabo holeberemi. ");
INSERT INTO hui_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Ani anigo mali kane tagira ibiragola tígua lo manda bialu, Iname tomo hongowa bu mogo bialu andagaha nawirimagodago ai mali ogoningi ina tomo agoha wini nalu holeberamadabe, nalalimu. ");
INSERT INTO hui_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Anduane Homogo i̱nime mali waragane tagira ibirangi tínaga dindi mo bayale harogola tomo dewaore mali tebirani nalu holene karulape bu wuleberemi. Anigo tí gi halu mogo nale halimu. ");
INSERT INTO hui_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Tígua mali halini tagira ibirangi tomo lone hongo aribia halu howa tomo nolene mali waraganeni bu wirimigo naho wiaabo holeberemi. Ani nalu kamine dege tomo hangarimigo boga bulebira, lene. ");
INSERT INTO hui_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","Anduane Homogohanda laabo halu lalu, Agali mbirame tínaga dindi ngamiru yolo bialu ibunaga wiaabo helo yolo bulene nawi. Ani larogoni irane dindi ogoni tínaga ndo ngelo kami. Dindi ogoni Anduane Homogo i̱ninaga ngogoria tí dindi taraha howa mendeali dindini íbu haradagua ibini kamigoni. ");
INSERT INTO hui_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Agali tíni aria kamirume tínaga dindi mbira yolo biyagua nde dindi ogoni ibunagaore lene wiaabo helo ndo laro. Agali dindi aba biago ibunime yolo biadai bulene manda biyagua nde ani bulene karulapeda manda bilimu. ");
INSERT INTO hui_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Agali mbira kago ibu muni mbiralebi nawi howa ibunaga dindi ngago muni miyagua nde ibu damene darama mbiraore ibuni aria hangume biamogo bialu dindidago yolo biadai bulene nga. ");
INSERT INTO hui_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Agali dindi aba ogoni biamogo bulene ibu damene mbira naheyagua nde ibunime yolo biadai bulene mani karulape wulebira manda bialu muni dewaore yu kangi ogonime ibunaga dindi biago ibuni yolo biadai bule holene nga. ");
INSERT INTO hui_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","Ani bialu ibugua dindi ogoni ibuni yadai bulene manda biyagua Yadai Bulenenaga Mali biago tagira ibilonaga mali agira wiaruabe ala manda bu hondolene nga. Ani mandabu handalu mali uruniha howa mabu ogoniha tomo hongolenenaga muni agirame karulape bulubadabe handalu ai uruni biai holene muni karulape wiagua nde agalime ibunaga dindi ogoni yolo biyago ibuni yolo biadai bulene nga. ");
INSERT INTO hui_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Anigo ai ibunaga munime dindi ogoni yolo biadai bulene nakarulapeyagua nde wahalu dindi mbiraleru Yadai Bulenenaga Mali biago dege ibilonaga hondo holene nga. Ani hondo howa mali biago tagira ibirangi dindi yolo bini biago ibugua dindi ogoni dindi aba kagohondo miadai bulebira. ");
INSERT INTO hui_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Agali mbira ibunaga anda tano pabe hongohe kago tamuha henego agali mendeme yolo binigo ai anda ogoni ibuni yolo biadai bule manda biyagua nde mali mbira ogoningi dege yolo biadai bibehe holebira. ");
INSERT INTO hui_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Anda anduane biagome mali mbira ogoniha yolo biadai bibe naheyagua nde mani anda ogoni lone yolo biadai bibe nahe holebira. Mbirale anduane biagohondo Yadai Bulene Mali biago tagira ibiragola ibugua miadai bulenebi nawi dege wulebira. Anda yolo biyago ibunagaore haabo halu ibu waneigini mani hama polobadarunagabi wia a̱i̱ holebira. ");
INSERT INTO hui_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Anigo anda maru tanonaga tagirahayagi heneyagua nde anda uruni yolo biadai bulene karulape. Mabu ogoriani ngagome ibunaga mabu ibuni yolo biadai biagadagua dege anda ogoniha kagobi yolo biadai bulebira. Ani ngago manda bialu anda tano tagiraha hene uruni alego anduane ibunime yolo biadai bulenebi mali biago tagira ibiragola anduane kago ibuni yadai bulenebi karulape nga. ");
INSERT INTO hui_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Anigo Libai hameigini tigua dege mana ogonidagua nabulebira. Tigua tinaga anda tano pabe tamuha henego muni muwa lone yolo biadai bulebi ta nabi ani bulebira. ");
INSERT INTO hui_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Anigo agali Libai aria ogoni ibugua ibunaga anda mbira yolo binigo biadai bulene hame nale heagua nde mbirale Yadai Bulenenaga Mali biago tagira ibirangi ibunaga anda ogoni agali yolo biyagome Libai agali biagohondo miadai bulene wulebira. Ani larogoni irane Isaraele hameigini tí bibahende dindi tu wuwa ta halu Libai aria ti tano hangu tu wuwa mirugodane laro. Anidagua birudagoni Libai hameigini karu tinaga anda tanoha heagua nde anda uruni tinaga leneore haabo holebira. ");
INSERT INTO hui_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Ani bialu dindi emene tanonaga lenelene wigi bidaruni agali marume yolo bulene nawi. Dindi uruni Libai hameigini tinagaore wiaabo holebira, lalu Anduane Homogo ibugua lene. ");
INSERT INTO hui_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","Anduane Homogohanda laabo halu lalu, Tí damene karu aria mbira ibu ala karulape henego mani muni mbirale nawiore yagibano heagua nde tígua agali dindi kaundiaha howa íbu kagola handayaho haga wirimidagua dege agali ogoni baya hangu handayaho holene nga. Ani beramigola tí damene ogoni ibu tíni baba howa bayale holebira. ");
INSERT INTO hui_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","37","Agali ogoni aleme tí baba muni danoho heneyagua tígua muni maru tago howa ngi nalalimu. Tínaga tomo ngamiru aria maru agali biago ibugua yolo bule ibiragola tígua muni yolo mo yaraga howa ngi nalalimu. Tígua Ngode Datagaliwabe ibuni hanguhondo gi halu agali yagibano ogoni ale kago ibu helo wahalimu. ");
INSERT INTO hui_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Bi ogoni i̱ Anduane Homogo tínaga Ngode Datagaliwabe kogoni howa i̱na ledogoniore. I̱niore tínaga Ngode Datagaliwabeore holenaga i̱na tí Iyibi dindiha hemiria haru tagira ibalu Kenana dindi ngago tí mo ngulenaga haru ibirugoni ndobe, lene. ");
INSERT INTO hui_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","Anduane Homogohanda laabo halu lalu, Agali mbira tí aria kago ibu ala karulape henego mani yagibano howa tí kamiru mbiragonaga garabaya biabe ale biahole manda biyagua nde tígua agali ogoniale kagohondo biabe yolonaga ndo bame bia lalu hongo howa nalalimu. ");
INSERT INTO hui_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Tígua ibu yolo biabe biaga haru haradagua bialu mbirale anduane biagohondo Yadai Bulenenaga Mali tagira ibirangi ibu pelo golope halimu. ");
INSERT INTO hui_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Mali ogoningi agali ogoni ibunibi ibu one waneiginirubi bibahende ti golope haramigola tini dalu dai bialu tinaga damene bu karu baba tininaga mamali dindi tene ngagoriani hole polebira. ");
INSERT INTO hui_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Anidagua larogoni irane bamba tínibi nde Iyibi dindiha garabaya biabe ale biahalu hemiria i̱na tí haru tagira ibirugola tígua Iyibi dindi yu wahalu ibirimigoni. Ani ibalu tí Anduane Homogo i̱ninagaore garabaya biabe ale biahaga kamigo ai tígua wali agali tíni aria bu karume garabaya biabe ale biahalu helo hela nabilimu. Mana ogonidagua bulene nawiore laro. ");
INSERT INTO hui_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Ani kago manda bialu tínaga damene degeme biabe biaga karuhondo biabe mangabi hongohe ngaru bialu kagoha bi hongo howa lalu holene nawi. Tínaga Ngode Datagaliwabe i̱ni kogohondo dege gi halu agali ogonibi kago biamogo bialu halimu. ");
INSERT INTO hui_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Wali agali tínaga garabaya biabe ale biahalu helo yolo bule lo manda birimiyagua nde wali agali dindi tara taraha howa tí kamigoha palia para para bidaru aria dege yolo milimu. ");
INSERT INTO hui_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Ani bialu wali agali dindi taraha howa ibini karuni tinaga waneigini garabaya biabe ale biahaga helo minu helolene karulape. Wali agali uruni tínaga dindini howa waneigini hono winiru tigua tínaga garabaya biabe ale biahaga helo helolene karulape kagoni. ");
INSERT INTO hui_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Ani kago minu helowa garabaya biabe ale biahaga kane dege tíni homaramigola tínaga waneigini holebirarunaga garabaya biabe ale biahaga haabo holene karulape holebira. Anigo Isaraele wali agalibi tíni aria karu tíninaga biabe biaga heagua nde uruni mo tandaga nahalimu. Hendore howa biabe bialu helo helalimu. ");
INSERT INTO hui_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","Mbirali dindi taraha howa tí baba íbu hene kago ibu muni dewawi homogo hayagua tí aria karu mbirago ibu yagibano howa ibugua agali ogoninaga garabaya biabe ale biahaga helo yolo biyaguabi ibu damene karunaga helo yolo biyaguabi nde ");
INSERT INTO hui_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","tí Isaraeleali kamiru tí damene ogoni mani tínime yolo biadai bulene wulebira. Ibuni hameneyaguabi ");
INSERT INTO hui_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","ibu aba hameneyaguabi ibu aba mbalini iginiyaguabi ibu damene maru karuyaguabi mbirago ibugua yolo biadai bulene wulebira. Ibunime muni karulape yu heagua nde biabe ko ogoni yu wahalu pole manda buwa agali ibu yolo biaga haruagohondo muni mialu polene nga. ");
INSERT INTO hui_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Agali garabaya biabe ale biahaga helo yolo bini biago ibugua ibunaga agali anduane hayagohondo bi baya hangu lalu mali áyu ogoni howa dagalalu mali agira howa mbirale yolo biniru anduane hayadagohondo Yadai Bulenenaga Mali biago agongi tagira ibulubadabe hondole dabo hondolene nga. Agali anduane biago ibugua agali biagome mali agira halu ibunaga biabe bialu holenego waholobadabe hondole daga lolene nga. Anigo yolo ogonidaguame karulape larago hondowa ibunimeyaguabi ibu damene karu aria marumeyaguabi muni ogonidagua karulapedago hondowa yolo biadai bulene nga. ");
INSERT INTO hui_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Mali dewaore wiagua nde agali ogoni ibugua ibunaga anduane kago muni dewame yolo miadai bulene wulebira. ");
INSERT INTO hui_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Mbirale anduane biago ibuni Yadai Bulenenaga Mali mbira biago tagira ibulene kaware ngelowayagua nde agali anduane biago muni emene degeme yolo biadai bulene nga. ");
INSERT INTO hui_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Agali anduane kago ibugua nde agali ibunaga garabaya biabe ale biahaga kago yolo biabe mali mbira kiraru ale yolo biabe biahaga kaligobi dege bialu kagoni lo manda bialu ibunaga garabaya biabe ale biahaga kago mo tandaga holene nawi. Anduaneme ibu hendore helo helolene nga. ");
INSERT INTO hui_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Agali garabaya biabe ale biahaga biago ibu damene bu karume ibalu ibu yolo ogonidagua biadai nabiyagua nde mbirale anduane kago ibuni Yadai Bulenenaga Mali biago tagira ibirangi ibunibi ibu one waneiginirubi bibahende ti pelo golope holene nga. ");
INSERT INTO hui_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Isaraeleali tígua agali mendealinaga garabaya biabe ale lu bia haabo helolene nawiore. Anidagua larogoni irane i̱ Anduane Homogo tínaga Ngode Datagaliwabeore howa tí Iyibi dindiha garabaya biabe ale biahalu hemiria i̱na tí haru tagira ibalu dindi ogoha haru ibirugoni ndobe. Ani birugo ai tí i̱naga garabaya biabe ale biahaga kamigoni, lalu Anduane Homogohanda lene. ");
INSERT INTO hui_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Anduane Homogohanda lalu, Tígua ira dibu pelowa ogonime pigiya mbira wabu helolenebi ege to̱le̱ mbira muwa ona hanga holenebi ege to̱le̱ timbuni ngagoria bage podagadagua podolenebi uruni alego tínaga dama mitangi bialu bi pupu wulenaga wabu helabi nabilimu. Ani nabi howa i̱ Anduane Homogo tínaga Ngode Datagaliwabe kogo i̱ni hangu mitangi bialu lotu lalu halimu. ");
INSERT INTO hui_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","I̱na horo pongobo wini ngoru tígua pugua nabi i̱ mitangi bialu ha̱lo halimu. Ani bialu i̱naga lotu anda lomabia hene bu kagobi mo yo nahandalimu. Anduane Homogo i̱ore kogoni. ");
INSERT INTO hui_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","Tígua i̱naga bi mana lo ngoru talialu mbirale ogo bilimu lalu langirugo bialu harimiyagua ");
INSERT INTO hui_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","nde tínaga mabuha tomo hengedemiru bayale anda hai helobi ira lini daga karume lini bayale daabo helonagabi i̱na iba dalu ibilolebero. ");
INSERT INTO hui_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Ani berogola tínaga mabuha tomo hengedamiru dewaore bu paya bulebira. Tomo dewaore andaho kagola widi gandulo wialu ha dege bidamine pu mbira mini gerebi lini boga bialu dolene tu holebira. Ani bialu gerebi lini dedago dalu kamine dege widi lone hongo aribia holene tu holebira. Ani biragola tígua tomo dewa nalu tombeho howa tínaga dindi ogoniha bayaleore haabo holeberemi. ");
INSERT INTO hui_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Tínaga dindi nguleberogoria pu kamigola i̱naga mo palia holene tíha wia harogola tí mbiraga paluwa mbirale mbirahondo gi nahe embedaho palueberemi. Mbirale gabua tara tara dindi ogoniha bedaru bo taliatagi hai holebero. Ani bialu tínaga dindi ogoriani waitigi karume tí baba wai bule naibulebira. ");
INSERT INTO hui_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Tígua waitigi baba wai bu puwa tí wayali halu waitigi karu mo ko howa boleberemi. ");
INSERT INTO hui_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Tínaga ami agali duriali hangume waitigi handari mbira (100) baba wai birimiyagua bo waholeberami. Ani buwa tínaga ami agali handari mbira (100) hangume waitigi agali daosini pira (10,000) baba wai birimiyagua tígua waitigi mo ko howa bo poda hana haga buleberemi. ");
INSERT INTO hui_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Ani bialu kamigola i̱na tí mo bayale howa waneigini mo dame bia halu dewaore ngigi bialu howa i̱na habo nalolene bi lo wirugodagua biaore bulebero. ");
INSERT INTO hui_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Tínaga mabu ngamigoha tomo mali mbiranaga bu wirimigo mali mendegonagabi karulape nalu holene wiadege bulebira. Mali mendenaga tomo hengenego boga bidagola tomo bu wiaga andaha tomo ala bu winigo nai habe nahedagola wahalu tomo gahenge bu wia aribia holene wulebira. ");
INSERT INTO hui_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Ani bialu kamigola i̱nibi nde tí dege dombeneha i̱naga Balai Anda biagoha mandagi haabo holebero. I̱na tí wahalu erembira ngialu napolebero. ");
INSERT INTO hui_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Ani bialu i̱ tínaga Ngode Datagaliwabe howa tí dege dombeneha ibaga bialu tí heba mandagi haabo holebero. Ani kogola tí nde i̱naga wali agali leneore holeberemi. ");
INSERT INTO hui_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","I̱ni Anduane Homogo tínaga Ngode Datagaliwabeore kogoni. Bamba tí Iyibi dindiha garabaya biabe ale biahalu hemiria ani nahalimulonaga i̱na tí golope halu haru tagira ibirugoni. Iyibi agali tí garabaya bu helaga hearunaga hongo wiago bope harugola tí garabaya golalu tagira pu howa turu tara ho kamigoni ndobe, lene. ");
INSERT INTO hui_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","Anduane Homogohanda laabo halu lalu, Tígua mana o langiruruni talialu bia nabi harimiyagua nde tí pani noleberami. ");
INSERT INTO hui_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","Tígua i̱naga bi mana lo ngoru erembira ngialu i̱naga bi larogobi mo wahalu pirimiyaguabi habo nalolene bi lo wirugo mo habo larimiyaguabi ");
INSERT INTO hui_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","nde i̱na tí pani nalimulo ngulebero. I̱na tí mo gi timbuni halu warago timbuni tara tara ngaru mo ibilalu berogola tínaga de ndibulai helalu tínaga tinginibi mo ko hai helalu bulebero. Tínaga mabuha tomo hangarami tiraga tomo bialu nanoleberemi. Tínaga waitigi karu ibalu tí mo ko halu tínaga mabuha tomo hengedemiru bialu nolebira. ");
INSERT INTO hui_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","I̱nabi nde tí baba waitigi halu i̱na tínaga waitigi karume tí baba wai bilimulo ibilolebero. Ani ibilarogola waitigime tí bo poda hana halu handayaho holebira. Ani bialu tíhondo handabe manga ho karume tínaga haru haga holebira. Marume tí bama talima ibiragola ndo tígua bame gi timbuni halu ibida poleberemi. ");
INSERT INTO hui_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","I̱na ogonidagua bialu tí pani ngialu kogolabi tígua doga howa mana ko ngaru bialu haabo harimiyagua nde i̱na tíha genda tandagaru timbuni kahalu mo tago howa ngulebero. ");
INSERT INTO hui_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","I̱na anidagua bialu tínaga mine haga mana ngamiru bope holebero. Tínaga dindi ngamiruhabi dalu naibilo minu yania ho kogola dalu naibi wialu dindi giambe halu ege to̱le̱ ale holebira. ");
INSERT INTO hui_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Ani bidagola mabuha tomo hengedemirubi ira lini dagane hengedemirubi bibahende lini nadolebira. Ani hangalu kamiria tínaga biabe uruni erekui bini bame horo mo hole bini bialu holeberemi. ");
INSERT INTO hui_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","Ani bialu genda uruni ibirago ibilowabi tígua i̱naga bi hale habe manga haabo harimiyagua nde tíhondo genda timbuniore kahalu lone mo tago howa ibilolebero. ");
INSERT INTO hui_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Nogo gabua tara tara karu tí kamigoha i̱na ibilolebero. Ani ibilarogola urunime tínaga waneigini bu karubi nogo bulumaga bu karubi bo wahaga bulebira. Ani bialu kagola tí daluha hariga ngaruni wali agali mbira bolangua haga bialu pialu kariabi nahondoleberami. Wali agalibi dewa ndo emene hangu holeberemi. ");
INSERT INTO hui_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","Ani bialu i̱na genda urunibi ngaru tíha ibilaga berogola tígua mini beregeda nabi i̱naga bi mana hale habe manga dege halu i̱hondo mine haabo harimiyagua ");
INSERT INTO hui_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","nde i̱na tínaga ko ngamiru mitangi bialu genda timbuniore ala ibilarudagua ndo lone kahalu mo tago howa ibilolebero. ");
INSERT INTO hui_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Tí baba habo nalolene bi lo wirugo mo habo larimigonaga i̱na nde tínaga waitigi karu tí baba wai hongo howa bilimulo ibilolebero. Ani ibilarogola tígua tano hongohe ege pabe bu mabubi ngagoha howa bayale kamabe toba ho kamiria i̱na warago ko timbuni dabi nahagane ngago ibilarogola wali agali dewaore warago ogonime balu homelolebira. Tí ani mo ko hene kamigola nde i̱na tí waitiginaga giha minu ya haga bulebero. ");
INSERT INTO hui_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","I̱na tínaga tomo mo ndia helarogolabi tínaga wali bedarume irani tomo dawalene dewa nawulebira. Ani biragola ira mbiraore dege dedagoria wali pirame mberedi hirulebira. Ani hiruwa walime mberedi ogoni tale biragola tígua emene budini hangu naga bialu howa tombe nahe dege garibilo haabo holeberemi. ");
INSERT INTO hui_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","Anidagua berogo bilowa tígua mine ha dege bialu i̱naga bi ledogo mo wahalu haabo harimiyagua nde ");
INSERT INTO hui_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","i̱na tíhondo keba timbuniore ho howa tígua ko ogoni biaabo harimigonaga pani abale ngirugobi ndo timbu gibiore lone kahalu mo tago howa ngulebero. ");
INSERT INTO hui_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Ani ngerogola tí kamigoha hina gari timbuni tagira ibiragola tomo nalu holene nawidagola tínaga waneiginiore balu noleberemi. ");
INSERT INTO hui_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","I̱na tí baba miniha gendaore timbuni yu howa tígua dama mitangi bialu bi pupu wulenaga mbirale gime wabini ngarunaga anda hari nene ngaruha bu helaga bidemiruni bibahende bo gialo wahai holebero. Ani bialu ira hagua ngabilo inisenesiru lomabu delaga dabu bu heledemiruni bo gialo wahai holebero. Ani bialu tínibi minu balu tínaga tingini bi pupu wulenaga dama wabu wirimigo gialo waharugoria wia dambi helolebero. ");
INSERT INTO hui_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Tíninaga anda bu kamirubi i̱ mitangi bialu lotu laga anda bu heledamirubi bibahende bo gialo wahai halu tígua mbirale i̱hondo lomabu yalu ibuwa ngeremigobi hondowa turu nahe handabe manga holebero. ");
INSERT INTO hui_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Ani buwa tínaga dindi mo ko hai harogola wali agali tínaga waitigi dindi ogoni karulo karume dindi kodane mogolo hondowa ogoni agile dindidabe laga bulebira. ");
INSERT INTO hui_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","I̱na tínaga waitigi bu karu baba wai bilimulo mo biahaga berogola waitigime tí bo garabaya bu yalu dindi tara tara ngaruha pugupugu bulebira. Anidagua biragola tínaga dindi ngamigoha wali agali mbira nahe dindi dabulu wulebira. Ani bialu tano ngarubi bo gialabaga bini wulebira. ");
INSERT INTO hui_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","35","Anidagua bialu tí dindi tara tínaga waitigiru daluha pu kamitambu tínaga dindi dabulu bameore wulebira. Bamba tígua dindi ogoniha howa mali kaneni tomo nahenge bame ngelalimu lalu i̱na langirugodagua nabi dege haabo harimigonaga anidagua bulebero. Dindi tomo nahenge ogonidagua ngelarogola dindi bayaleore hodai bulebira. ");
INSERT INTO hui_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","37","Tínaga wali agali bibahende homaiore nahe emene yu waheneru tí dindi tara tara ngaruha garabaya bu yalu pene holeberami. Ani kamigola i̱na tí mo gi timbuni halu puyabu pulalu howa ira yuni giligele laga biraru hale howa waitigiru talima ibaruabe toba howa mogo lalu ibida hariga nawiha poleberemi. Waitigi naibi ngagoyu tínime gi howa ibida pugupugu bialu kamiria pu lulu yahalu tíninaga embone degedege mo tilitola lalu ona pilo odo wigiwigi buleberemi. Ani bialu howa tínaga waitigi karume ibalu tí wai bule ibiragola nde tí hongo halu wai bibenahe holeberemi. ");
INSERT INTO hui_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Ani bialu tínaga waitigi karu daluha pu kamiria dindi ogoniha tí pu ereba halu homai holeberemi. ");
INSERT INTO hui_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Anigo wali agali maru hangu waitigi daluha yu wahene kamiru tí nde hangu hangu mo ko haga biragome homo biba halu ereba hai holene kawareore wulebira. Anidagua bulubadagoni irane tínimebi tínaga mamalirumebi mana ko bialu hene ngarume pani nolene ogoni tíha wiaabo holebira. ");
INSERT INTO hui_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","Ani bulebiragoyu mani tínaga aguanene holebirarume ko tiha wiyada lo manda bialu tigua tinaga ko uruni i̱hondo lapani haga bulebira. Tigua lalu, Inamebi inanaga mamalirumebi mana ko dege bialu harima. Ani buwa iname í̠naga bi mana lo wiago mo wahalu mine timbuni harimagoni, laga bialu lapani holebira. ");
INSERT INTO hui_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","Tígua mine tara halu hemigola pani nalimulo i̱na mo ngialu tínaga waitigi bu hearume ti daluha garabaya bu yalu pelarugoni ndobe. Anigo tínaga aguanene uruni tigua tini mo dindiha halu tigua ko biyarunaga pani tandagabi nolene ngaru nalu ");
INSERT INTO hui_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","haragola howa i̱na bamba habo nalolene bi Yagaba bababi Aisaga bababi Abarahama bababi tihondo lo wialu lalu, Kenana dindiore tínaga waneigini aguanene mani holebirarubi tinaga wilo mulebero, lalu lo wirugo mitangi budai bulebero. ");
INSERT INTO hui_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Anigo ala dindi ogoni wali agali nahe dabulu ngelo hondoha nabi tomo hangalu haabo harimigonaga dindi halu mbira embera ngelonaga tí dindi ogoni ngelalu tagira polene nga. Ani howa mana lowini ngagobi bi langirugobi bibahende mo wahai harimigonaga pani nalu genda yu haabo holene nga. ");
INSERT INTO hui_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Tí dindi tara tínaga waitigi dindiha howa tandaga ani nalu kamigolabi i̱na tí yu wa naholebero. Tí yu waharuyagua nde habo nalolene bi lo wirugobi habo lolebira. Anigo i̱ Anduane Homogo tínaga Ngode Datagaliwabeore kogodago anidagua nabulebero. ");
INSERT INTO hui_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","I̱na tí mitangi bialu tínaga mamali i̱nila habo nalolene bi lo wialu lenedarubi bibahende mitangi budai bulebero. Ani bialu tí wali agali dindi bibahendeha bi taratara lagalaga biaga palearu bibahendenaga deni i̱na tínaga mamali Iyibi dindiha howa haru tagira ibalu ogoha haru ibirugola wali agali bibahendeme i̱ninaga hongo timbuni wiwago ti handai haya. I̱ Anduane Homogo howa tí Isaraele wali agalinaga Ngode Datagaliwabeore holenaga i̱na tí haru tagira ibalu ogoha haru ibirugoni, lalu Anduane Homogohanda lene. ");
INSERT INTO hui_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Mana uruni lamiyadagobi bi galone lamiyadagobi uruni bibahende Anduane Homogohanda Hari Sainaiha howa Mosesehondo lamini. ");
INSERT INTO hui_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Anduane Homogohanda Mosesehondo lalu, ");
INSERT INTO hui_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","Isaraele wali agali bu karuhondo ogodagua labe. Mbiralime ibuni i̱hondo lomabu ngulene hame lowa bi lo wu hene heaguabi wali agali mbirago i̱hondo lomabu ngule lowa bi lo wu heaguabi nde urunidagua lomabia ho henedaruni tinaga munime yolo biadai bulene nga. Muni ogoni wali agali mbirago yolo bulene muni karulapedago hondowa loma binigo mo miaga kagohondo muni mule lalu lo wiyago karulapelo mulene nga. ");
INSERT INTO hui_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","7","Wali agalime muni yolo biadai bulene magi ogodagua. Agali mali pira kirala (20) pira waragariala (60) dombeneha hene karu ti muni kina dege handari duriame (500) yolo biadai bulene nga. Wali mali ogonidagua dege bedaru tibi nde muni kina dege handari tebirame (300) yolo biadai bulene nga. Igiri mali duriala pira kirala (20) dombeneha karu ti bibahende muni kina dege handari kirame (200) yolo biadai bulene nga. Wandari mali ogonidagua dege pene bedaru tibi nde muni kina dege handari mbirame (100) yolo biadai bulene nga. Igiri gali mali duria bolangua nahe karu ti muni kina pira duriame (50) yolo biadai bulene nga. Wandari gali emene mali ogonidagua dege bedaru tibi nde muni kina pira tebirame (30) yolo biadai bulene nga. Agali mali pira waragaria (60) bolangua hene karu ti nde muni kina handari mbirani pira duriame (150) yolo biadai bulene nga. Walibi nde mali ogonidagua dege bedaru ti muni kina handari mbirame (100) yolo biadai bulene nga. ");
INSERT INTO hui_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Wali agali mbirago ibuni nde yolo ogoni biadai bulenego manda bu karia muni nakarulape tubagi hayagua nde o biago ibu loma binigo mo miaga kago hondo polene nga. Loma binigo mo miaga kago ibugua muni ogodagua karulapedago manda buwa yolo bialu ngiadai bule í̠na ogodagua yolo bibehedago bia laradagua bulene nga. ");
INSERT INTO hui_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","Mbiralime Anduane Homogo i̱hondo mbirale lomabu ngule lalu lo winidagua áyu lomabu ngiyagua nde nogo egabi ogoaleore lomabu bo ngilimu lalu abale langirudagua bialu bo ngulene nga. Tígua nogo egabi lomabu ngeremigo damene bibahende i̱ninagaore wulebira. ");
INSERT INTO hui_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Mbiralime i̱hondo nogo mbira loma bialu bo ngule lo wiyago nogo mende aribia hole manda biyaguabi nogo bayale i̱hondo bo ngule kago mo aribia howa nogo ko kago i̱hondo lomabu ngulene manda biyaguabi ogoni nakarulapeore. Ani biyagua nde bayale kago lomabu bo delolenaga ko kagome kango henedagobi kirabali Anduane Homogo i̱ninaga dege holebira. ");
INSERT INTO hui_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Mbiralime i̱hondo nogo egaru mbira loma bialu bo ngule karia ogoni i̱naga deni ko dodoheyagua nde wahalu loma binigo mo miaga agali karia yalu polene nga. ");
INSERT INTO hui_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Ani yalu poragola loma binigo mo miaga kagome nogo egabi bayalebe kodabe hondowa muni ogodaguame yolo bibeheda lolebira. Anidagua laragola yolo ogoni gadia dali ha gadia daga ha bulenebi nawiore. ");
INSERT INTO hui_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Nogo egabi anduane biago ibugua muni aribia halu lomabu mulene hamelayagua nde muni nogo yolo bulene karulape mialu marubi tago howa mulene nga. Loma binigo mo miaga kago ibugua kina duriame yolo bibe layagua nde anduane biagome kina mbira tago howa waragariame yolo biadai bulene nga. Kina pirame yolo bibeheda layagua nde kina kira tago howa homberiame (12) yolo biadai bulene nga. ");
INSERT INTO hui_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Mbiralime ibunaga anda i̱hondo lomabu ngule hamelo heagua loma binigo mo miaga kago ibugua anda ogoni kodabe bayaledabe ala hondolene nga. Ani hondowa ibugua anda ogoni muni yolo ogodaguame karulapeda lolebira. Ani laragola muni ledago gadia dali ha gadia daga ha bulene nawi. Muni daga miyadagua yolo bulene nga. ");
INSERT INTO hui_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Ani bialu agali biagome Anduane Homogo i̱nihondo anda lomabu ngiyago ibuni yolo biadai bulene manda biyagua nde agali anda anduane biagome anda biago muni karulapeme yolo bialu muni marubi tago howa mulene nga. Ibugua loma binigo mo miaga kagohondo muni mialu anda ibuninaga holebira. ");
INSERT INTO hui_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Agali mbirame ibunaga dindi mbira Anduane Homogo i̱hondo loma bialu tu wu ngiyagua nde dindi ogoniha widi ale dege mini bali lini egane agirame hongolene karulapedabe hondole loma binigo mo miaga kago ibugua hondo polene nga. Ani handalu karia bali lini egane genda magi kilogarama pira kirame (20) hongolene karulapeyagua nde mabu ogoni muni kina handari mbirame (100) yolo bulene karulape holebira. ");
INSERT INTO hui_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Yadai Bulenenaga Mali biago tagira ayure ibini lowa mali mbira napedaore nde dindi anduanedago ibunime muni kina handari mbira (100) ogonidagua degeme Anduane Homogo i̱ni ngiadai bulene nga. Muni gadia daliha gadia dagaha bulene nawi. ");
INSERT INTO hui_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Anigo agali mbiragome dindi i̱hondo nguledago dindi anduane ibunihondo Yadai Bulenenaga Mali biago mende angi tagira ibulebadabe ala manda buwa loma binigo mo miaga kagome mali ngadagua nde muni ngi lolebira. ");
INSERT INTO hui_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Agali mbirame dindi mbira i̱hondo tu wu ngiyago ibugua nde dindi ogoni ibuni yolo duguadai bulene hamelo heagua nde munime yolo duguadai bulebira. Loma binigo mo miaga kago ibugua muni kina handari mbirame (100) yolo duguadai bulene nga layagua nde agali mabu anduane ogoni ibugua muni kina handari mbirani pira kirame (120) yolo duguadai bulene nga. Ibugua muni ogoni loma binigo mo miaga agali biagohondo mialu dindi ibuni mo yu dai bulebira. ");
INSERT INTO hui_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Agali ogoni ibugua i̱hondo yolo ngiadai nabi ngelowa agali mende kagohondo dindi biagonaga muni mo nayagua nde mani ibunaga dindi Yadai Bulenenaga Mali biago tagira ibirangi miadai nabibehe holebira. ");
INSERT INTO hui_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Yadai Bulenenaga Mali biago mende tagira ibiragola nde agali dindi yolo biyago ibugua i̱nihondo ngiadai bulebira. Ani ngiadai biragola dindi ogoni i̱ninaga wiabagi hene wialu wali agali mbiralime ogoni karulolene nawulebira. Ani ngagola i̱nime i̱naga loma binigo mo miaga karuhondo mo mulebero. ");
INSERT INTO hui_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Agali mbira ibu aba mamalirunaga dindi ndo agali mendenaga ngago yolo buwa Anduane Homogo i̱hondo lomabu ngiyagua ");
INSERT INTO hui_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","nde loma binigo mo miaga kago ibugua mali agira howa dindi ogoni Yadai Bulene Mali angi tagira ibulubadabe ala manda bu hondolene nga. Ani hondowa mabu ogoniha tomo mali uruniha bialu nalu holobadadagua muni yolo bibe lolebira. Ani laragola agali biago ibugua horo ogoningiore muni loma binigo mo miaga kagohondo mulene nga. Ani miragola muni ogoni Anduane Homogo i̱ninagaore wulebira. ");
INSERT INTO hui_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Ani howa mani dindi andaru anduane kago ibunihondo Yadai Bulenenaga Mali biago tagira ibirangi agali dindi ogoni yolo biyagome dindi anduane kago ibuni miadai bulene nga. ");
INSERT INTO hui_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Tígua uruniale damene bibahende yolo tiga tigaore bulene ngadagua latagi haga bilimu. ");
INSERT INTO hui_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Tígua i̱hondo nogo lomabu ngule howa nogo igini pigane wini kago bibahende i̱ninaga hene kago lone ngibe nahego ai maha wini karu lomabu ngilimu. Nogo bulumaga sibiru mbirago hangu ndo nogo damene bibahendenaga igini pigane wini kago damene i̱ninagaore ka. ");
INSERT INTO hui_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Anigo nogo igini pigane wini kago aria mbirago i̱naga deni bayale ndo heagua nde tíni halu i̱ muni aribia halimu. Muni ogoni loma binigo mo miaga agali kagome kina pira agimame mulene ngago layagua nde agali nogo anduanedago ibunime kina kira paga howa homberia (12) mulene nga. Agali ogoni ibu nogo ogoni yolo aribia nahayagua nde loma binigo mo miaga agali kago ibugua muni ogodaguame yolo bibe laradagua agali mendeme yolo bia aribia halu nogo ogoni ibu holebira. ");
INSERT INTO hui_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Agali mbirame ibunaga mbirale ngago mbira Anduane Homogo i̱ninagaore lalu wiabagi ho ngelayagua nde ogonime biabe tara tara ngaru bulene nawi. Ani bialu agali mende kagome yolo bilo mulenebi nawi. Ibunimebi loma binigo mo miaga kagonaga giha howabi yolo biadai bulenebi nawi dege. Mbiralime wali agali lomabia heneyaguabi nogo lomabia heneyaguabi dindi ibu mamalinaga wia a̱i̱ heneyaguabi uruni bibahende Anduane Homogo i̱ninagaore loma bini wiaabo holebira. ");
INSERT INTO hui_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Hale halimu. Tígua waliyaguabi agaliyaguabi mbira loma bia howa heleneyagua nde i̱ninagaore lene haabo holebira. Anduane kago ibunime yolo biadai bulene nawiore. Wali agaliyaguabi ogoni ibu homelo bolene nga. ");
INSERT INTO hui_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","Tí mabuha tomo hengedemiru boga biragola widiyaguabi ira lini dedaru alebi bibahendenaga pinipinigo Anduane Homogo i̱ninagaorego i̱nihondo talebu ngilimu. Pinigo tíni nolene nawigo nanalimu laro. Pinigo i̱ninagaore nga. ");
INSERT INTO hui_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Agali mbirame mbirale uruni ale ibuni yolo biadai buleyagua nde ani bulene karulape degego yolo biadai bulene nga. Mbirale uruni muni kina duriame yolo biadai bulene karulapeyagua nde ibugua muni kina waragane tago howa yolo biadai bialu muni loma binigo mo miaga kagohondo mulene nga. ");
INSERT INTO hui_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Nogo bulumaga pira heaguabi sibi pira heaguabi pinipinigo i̱naga dege holebira. Nogo hinu kamiru damene mo mogobu helowa pira dege halu mbira helaga bialu pira mbiragonaga pini dege dege i̱ni ngilimu. ");
INSERT INTO hui_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Nogo ko bayaleyaguabi pini i̱ninaga kago mbira mo iriari nabilimu. Mbira mo iriari birimiyagua nde mende aribia harimigobi kirabali i̱ninaga dege holebira. Kirabali i̱ninaga dege holebirago tíni yolo biadai bulene nawigo nabilimu, lalu Anduane Homogohanda lene. ");
INSERT INTO hui_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Bi mana uruni Isaraele wali agali hearume talialu biai helo Anduane Homogo ibugua Hari Sainaiha howa Mosesehondo lamiai hene. ");
INSERT INTO hui_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Isaraele wali agali ti Iyibi dindi wahalu tagira penego mali mendegonaga ege mendeni horo mbira hayagola Sainai dindi ko yobi iba dalu naibaga wiagoria Anduane Homogohanda ibunaga Balai Anda heagoha howa Mosesela bi lene. ");
INSERT INTO hui_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","Anduane Homogohanda lalu, Í̠ Aronola libugua Isaraele agali karu dagalalu tinaga mini gilibu wiai halibu. Mini gilibu wialu ti damene mbira mbira hayadagua hameigini hangu hangu dagalalu gilibu wiai halibu. ");
INSERT INTO hui_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Agali maru ami agali habehe mali pira kira (20) bolangua hene karu dagalai halibu. ");
INSERT INTO hui_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Ani bialu libuni biamogo bilonaga agali hameigini kadagua agali haguane mbira mbira dabo helalibu, Anduane Homogohanda lene. ");
INSERT INTO hui_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","16","Ani lowa lalu agali haguane maru libu biamogo bilonaga dabo helenedaruni uru. Lubene aria Sederu igini Elisu helene. Simiono aria Surisadai igini Selumiele helene. Yuda aria Aminadaba igini Nasono helene. Isaga aria Suara igini Nedanele helene. Sebulunu aria Helono igini Eliaba helene. Eberaimi aria Amihudu igini Elisama helene. Manase aria Pedasu igini Gamaliele helene. Beniyamini aria Gidioni igini Abidana helene. Dana aria Amisadai igini Ahiese helene. Ase aria Ogorana igini Pagiele helene. Gada aria Duele igini Eliasaba helene. Nabadali aria Enana igini Ahira helene. ");
INSERT INTO hui_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Ani lamiyagola hale howa Mosese ibugua Isaraele agali hameigini mbira mbiranaga agali haguane uruni ti ibilo olo ngoai hene. ");
INSERT INTO hui_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","Ibiyagola Mosese Aronobi agali haguane homberiali (12) dabo helayarubi tigua ege mendegonaga horo mbira hayagola Isaraele wali agali bibahende íbu ngoai hadaba layagola ti bibahende íbu ngoai hene. Ani ibiyagola agali haguane biaru tigua bibahendenaga mini tini hameigini hayadagua gilibu wigi wigi bini. Ani bialu agali mali pira kira (20) bolangua hene agira kabe hondole dagalalu tinaga mini gilibu wini. ");
INSERT INTO hui_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Anduane Homogohanda ala Sainai dindi ko iba dalu naibaga wiagoria Mosesehondo lamiyadagua ani biai hene. ");
INSERT INTO hui_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","46","Ani bialu agali mali pira kira (20) hayarubi maru pira kira bolangua hene hayarubi bibahende ami agali habehe biaru mini gilibu wialu dagalai hene. Tigua ani bule howa hameigini mbira mbira aba igini mbira mbira headagua agali ami habeheru Yagaba igini wahene Lubene hameigini howa ala dagalalu mini gilibu wini. Agali hameigini headagua tinaga mini ogodagua gilibu wini. Lubene aria daosini dege pira mariani waragaria halu handari duria (46,500) bibahende hene. Simiono aria daosini dege pira duriani dira halu handari tebira (59,300) bibahende hene. Gada aria daosini dege pira mariani duria halu handari waragaria pira duria (45,650) bibahende hene. Yuda aria daosini dege pira kariani maria halu handari waragaria (74,600) bibahende hene. Isaga aria daosini dege pira duriani maria halu handari maria (54,400) bibahende hene. Sebulunu aria daosini dege pira duriani karia halu handari maria (57,400) hene. Eberaimi aria daosini dege pira mariani handari duria (40,500) bibahende hene. Manase aria daosini dege pira tebirani kira halu handari kira (32,200) bibahende hene. Beniyamini aria daosini dege pira tebirani duria halu handari maria (35,400) bibahende hene. Dana aria daosini dege pira waragariani kira halu handari karia (62,700) bibahende hene. Ase aria daosini dege pira mariani mbira halu handari duria (41,500) bibahende hene. Nabadali aria daosini dege pira duriani tebira halu handari maria (53,400) bibahende hene. Anidagua haga binigo ai bibahende daga lamaga halu daosini dege handari waragariani huniane tebira halu handari duriani pira duria (603,550) bibahende hene. ");
INSERT INTO hui_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Tigua agali bibahendenaga mini dagalalu gilibu wiai hayangi hameigini mbiraore Libai ibu aria dege dagalalu nagilibu wini. ");
INSERT INTO hui_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Anidagua binidagoni irane abale Anduane Homogohanda Mosesehondo lamialu lalu, ");
INSERT INTO hui_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","Í̠na ami agali habehe karu dagalalu mini gilibu wialu howa Libai hameigini ti dege mini gili bialu daga lamaga nahabe. ");
INSERT INTO hui_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Ani bulene nawiore. Libai hameigini tigua i̱naga Balai Anda kagoha biabe bialu howa anda ogoni handayaho haga helo helabe. Ani helowa tininaga balai andabi i̱naga bu heledagoria dege mandagi helo lenelene bu mabu bidaba labe. ");
INSERT INTO hui_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Tígua dindi mbirani balai anda bu harimigo gialo yalu dindi mendeha poramingi i̱naga Balai Anda kagobi mbirale i̱ anda ogoniha wini ngarubi bibahende Libai agali karume mo yalu pugu bilo. Agali maru Libai hameigini aria ndo kamiru tígua i̱naga Balai Anda kagoria haparaho harimiyagua nde tíni homolene nga. ");
INSERT INTO hui_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Isaraeleali hameigini maru kamiru tí nde tíninaga hameigini emene hagahaga birimidagua balai anda bu hagahaga buwa tíni hameigininaga pelagi helagalaga bilimu. ");
INSERT INTO hui_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Anigo Libai hameigini tigua dege tinaga balai anda i̱naga Balai Anda kagoria buyu mabu buwa anda ogoni handayaho helo. Ai bi larugo mo wahalu mbirali i̱naga Balai Anda ogoni kagoha pialu karia i̱naga keba holene timbu halu Isaraele wali agali bo wahai holigo Libai aria tigua i̱naga Balai Anda mamage helo helolene nga, lene. ");
INSERT INTO hui_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Ani layagola hale howa Mosese ibugua bi uruni Isaraele wali agaliruhondo lamiyagola tigua Anduane Homogohanda layadagua talialu biai hene. ");
INSERT INTO hui_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Anduane Homogo ibugua Mosese Aronolahondo lamialu lalu, ");
INSERT INTO hui_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","Agali hameigini mbira mbira kamiru tínaga balai anda bule tíninaga pelagi kagoria kaware tí hameigininaga pelagi kago kawarenibi balai anda biapara howa bilimu. Ani buwa i̱naga Balai Anda kagonaga lenelene bu mabu bilimu. Anigo tínaga balai anda i̱naga Balai Anda kago biapara howa kaware nabi emene kaundiani bilimu, lalu lamini. ");
INSERT INTO hui_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","9","Ani layadagua Isaraeleali tigua abene ni tagira ibiragohayagi hameigini tebira Yuda hameigininaga pelagi kago andaneha mo mogo buwa balai anda bialu tinaga agali haguane hearu andaneha hene. Yuda aria Aminadaba igini Nasono daosini dege pira kariani maria halu handari waragaria (74,600) hene. Isaga aria Sua igini Nedanele agali dege daosini pira duriani maria halu handari maria (54,400) hene. Sebulunu aria Helono igini Eliaba daosini dege pira duriani karia halu handari maria (57,400) hene. Ani howa ti dagalamaga howa agali hameigini tebira uruni daosini dege handari mbirani pira halirani waragaria halu handari maria bibahende (186,400) hene. Ti balai anda bu hayaru gialo yalu dindi mendeha polene tu haragola Yudanaga pelagi kagoha hameigini tebira heneru ti ala mo bamba halu piaga hene. ");
INSERT INTO hui_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","16","Dindi abene unurahayagi hameigini tebira Lubene hameigininaga pelagi kago andaneha mo mogo buwa balai anda bialu tinaga agali haguane hearu andaneha hene. Lubene aria Sederu igini Elisu daosini dege pira mariani waragaria halu handari duria (46,500) hene. Simiono aria Surisadai igini Selumiele daosini dege pira duriani dira halu handari tebira (59,300) hene. Gada aria Duele igini Eliasaba daosini pira mariani duria halu handari waragariani pira duria (45,650) hene. Hameigini tebira bibahendenaga agali dagalamaga halu daosini dege handari mbirani pira duriani mbira halu handari mariani pira duria (151,450) hene. Dindi ti balai anda bu hayaru wahalu dindi mendeha pole pialu howa tigua hameigini tebira bamba halu piyaru talima mama pene. ");
INSERT INTO hui_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Tigua pole pialu howa Yuda hameigini tigua bamba halu piaga hene. Ani poragola hameigini maru porago erembiraha pumaga halu pugu biaga hene. Balai anda bu hayagoria mo tiga buwa harimidagua gi tigahayagi hayago tigua ala mo bamba haga bialu tinaga pelagi biago yalu poradagua pugu biaga hene. Ani poragola Libai hameigini tigua Anduane Homogonaga Balai Anda heago gialo yalu hameigini waragaria bamba helalu waragaria mende maha helalu buwa ti dombeneha piaga hene. ");
INSERT INTO hui_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","24","Ni paliragohayagi hameigini tebirali mo mogo buwa Eberaimi hameigininaga pelagi heagoha dege hamaga haga biaga hene. Ani howa ti hameigininaga agali haguane mbira mbira haga biyaru andaneha hagahaga biaga hene. Eberaimi Amihudu igini Elisama daosini dege pira mariani handari duria (40,500) hene. Manase Pedasu igini Gamaliele daosini dege pira tebirani kira halu handari kira (32,200) hene. Beniyamini Gidioni igini Abidana daosini dege pira tebirani duria halu handari maria (35,400) hene. Agali hameigini uruni bibahende dagalamaga howa daosini dege handari mbirani halira halu handari mbira (108,100) hene. Balai anda bu hayaru wahalu dindi mendeha pole howa tigua hameigini tebira halu mende bamba halu piyaru talima mama pene. ");
INSERT INTO hui_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","31","Dindi abene uyurahayagi Dana hameigini heagonaga pelagi heagoria kaware haparaho haga hearu ti nde tinaga agali haguane hearu andaneha haga hene. Dana Amisadai igini Ahiese daosini dege pira waragariani kira halu handari karia (62,700) hene. Ase Ogorana igini Pagiele daosini dege pira mariani mbira halu handari duria (41,500) hene. Nabadali Enana igini Ahira daosini dege pira duriani tebira halu handari maria (53,400) hene. Hameigini uruni bibahende dagalamaga halu daosini dege handari mbirani pira duriani karia halu handari waragaria (157,600) hene. Tigua tinaga pelagi yalu ti maha pumaro biaga hene. ");
INSERT INTO hui_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Isaraele hameigini bibahende dagalamaga halu daosini dege handari waragariani tebira halu handari duriani pira duria (603,550) hene. ");
INSERT INTO hui_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Tigua Anduane Homogohanda layadagua Libai hameigini ti Isaraele hameigini maru baba dagalamaga nahene. ");
INSERT INTO hui_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Anidagua bialu Isaraele wali agali tigua Anduane Homogohanda Mosesehondo bilimu lalu lamiyadagua bibahende biaiore hene. Hameigini mbira mbirame tininaga balai anda pelagi heagoria kawareni bu hayaru ti pole howa gialo yalu tini henedagua pugu biaga hene. ");
INSERT INTO hui_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Anduane Homogo ibugua Mosesela Hari Sainai heagoria bi laribingi howa Mosese Aronola libu damene ogodagua hene. ");
INSERT INTO hui_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Arono igini maria henego wahene Nadaba hene. Mende Abihu halu tebone Eleasa halu mane Idama hene. ");
INSERT INTO hui_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Ani hemigola Mosesehanda tinaga haguaneni weli odo wialu ti agali loma binigo mo miaga helo dabo helene. ");
INSERT INTO hui_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Anigo ti Sainai dindi ko yobi wiagoha hemingi howa Nadaba Abihulame ira hagua ngabiaga inisenesi lomabu delalibu lalu Anduane Homogohanda lamiyagola ndo libuni manda bialu lomabu delalu hene. Ani bialu hebiria Anduane Homogohanda libu homelo bo wahene. Anigo libunaga waneigini mbira nahe homene. Ani biyagola igiri kirali Eleasa Idamala libu aba Arono heangi loma binigo mo miaga agali howa biabe bialu hene. ");
INSERT INTO hui_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Anduane Homogohanda Mosesehondo lamialu lalu, ");
INSERT INTO hui_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","Libai hameigini karu haru ibuwa ti loma binigo mo miaga Arononaga biabe biaga helo dabo helabe. ");
INSERT INTO hui_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Tigua i̱naga Balai Anda kagoha biabe bulene ngago bialu howa loma binigo mo miaga karunaga biabe birago biamogo bialu wali agali karubi biamogo bialu helo dabo helabe. ");
INSERT INTO hui_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","I̱na Isaraele wali agali tihondo lamirudagua Libai hameigini tigua i̱naga Balai Andaha ngaru bibahende baya hangu handayaho holebira. ");
INSERT INTO hui_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Libai hameigini karu tinaga biabe bulene mbiraore hangu nga. Tigua Aronobi ibu iginirubi loma binigo mo miaga karunaga biabe bialu haabo holebira. ");
INSERT INTO hui_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Aronobi ibu iginirubi tigua dege loma binigo mo miaga howa tinaga biabe bulene alego bialu holebira. Anigo agali Arono aria ndo mbirame loma binigo mo miaganaga biabe ngago bialu heagua nde agali ogoni homelo bo wahalimu, lene. ");
INSERT INTO hui_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Ani lowa Anduane Homogohanda Mosese lamialu lalu, ");
INSERT INTO hui_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","13","Áyu Libai hameigini karu ti i̱ninaga wali agaliore helo helarogoni. Bamba i̱na Iyibialirunaga igini wahene hearu damene bibahende bo wahai halu Isaraele wali agali tí igini wahene bibahende i̱ninagaore helo dabalu tínaga nogo tara tara kamirunaga igini wangabe pigane wirago bibahendebi i̱ninaga helo helalimu larugoni. Anigo áyu howa ai uruni bibahende tíninaga helalu Libai hameigini i̱ninagaore helarogoni. Tínaga igini wahene i̱nihondo ngulenedaguabi tínaga nogo tara tara karume igini wangabe pigane wirago i̱hondo ngulenedaguabi uruni bibahendenaga Libai hameigini ti i̱ninagaore hai helarogoni. Anduane Homogo i̱ore kogoni, lene. ");
INSERT INTO hui_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Dindi ko yobi Sainai wiagoria howa Anduane Homogohanda Mosesehondo lamialu lalu, ");
INSERT INTO hui_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","Libai hameigini karu bibahende dagalai halu tinaga one waneiginirubi bibahende daga lalu mini gilibu wibe. Ani bialu igiri gali ege mbira bolangua hene taba yidarunaga minibi gilibu wiai halimu, lene. ");
INSERT INTO hui_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Ani layagola Mosesehanda nde Anduane Homogohanda bibe lalu lamiyago bibahende biai hene. ");
INSERT INTO hui_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Ani bialu Libai igini tebirali Gesonobi Kohadabi Merari imaru hene. ");
INSERT INTO hui_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Gesono igini kira Libini Simeila hene. ");
INSERT INTO hui_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Kohada igini nde maria Amaramabi Isihabi Heberonobi Usielebi uruni hene. ");
INSERT INTO hui_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Merari igini nde kira Mali Musila hene. Libai aria tinaga aguanene mani henerume tinaga hameigini agali uruninaga mini dege laabo haga hene. ");
INSERT INTO hui_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Gesono ibu hameigini kira henego mbirago Libini ibu damene halu mendego Simei damene hene. ");
INSERT INTO hui_vpl VALUES ("NU3_22","005_3_22","NUM","3","2