﻿USE sofia;
DROP TABLE IF EXISTS sofia.hubNT_vpl;
CREATE TABLE hubNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES hubNT_vpl WRITE;
INSERT INTO hubNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jesucristoka David weantu ajakuiti, tura Davidcha Abraham weantu ajakuiti. Tuma asamtai Jesucristo apachri tumain ainaka ju ainawai: ");
INSERT INTO hubNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abrahaman uchiri Isaac, Isaackan uchiri Jacob, Jacobon uchiri Judá, nina yachi ainajai. ");
INSERT INTO hubNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Nui Judá Tamarjai nuweenawaiti. Tuma Faresan Sarajai akiawaiti. Faresan uchiri Esrom, Esroman uchiri Aram, ");
INSERT INTO hubNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Araman uchiri Aminadab, Aminadabpan uchiri Nahasón, Nahasónkan uchiri Salmón ajakuiti. ");
INSERT INTO hubNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón Rahabjai nuweenawaiti, tura Boozan akiawaiti. Booz Rutjai nuweena nui Obedtan akiawaiti. Tura Obedtan uchiri Isaí ajakuiti. ");
INSERT INTO hubNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Tura Isaí Davidtan akiawaiti. David Uríasa nuwen atankinaiti, tura nui Salomónkan akiawaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomónkan uchiri Roboam ajakuiti, Roboaman uchiri Abías, Abíasan uchiri Asá, ");
INSERT INTO hubNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asán uchiri Josafat, Josafatan uchiri Joram, Joraman uchiri Uzías, ");
INSERT INTO hubNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzíasan uchiri Jotam, Jotaman uchiri Acaz, Acazan uchiri Ezequías, ");
INSERT INTO hubNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequíasan uchiri Manasés, Manasésan uchiri Amón, Amónkan uchiri Josías, ");
INSERT INTO hubNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josíasan uchiri Jeconías, tura nina yachi ainajai nitaka akinawaruiti. Babilonianmaya shuar aina nu tsawantin, israelita ainan achirar waitkasartasa nita nugkeen yaruakaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Turamu asar Babilonianam matsamsar Jeconías Salatielan akiawaiti. Salatielan uchiri Zorobabel, ");
INSERT INTO hubNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabelan uchiri Abiud, Abiudtan uchiri Eliaquim, Eliaquiman uchiri Azor, ");
INSERT INTO hubNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azoran uchiri Sadoc, Sadocan uchiri Aquim, Aquiman uchiri Eliud, ");
INSERT INTO hubNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliudtan uchiri Eleazar, Eleazaran uchiri Matán, Matánkan uchiri Jacob. ");
INSERT INTO hubNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacobon uchiri José, Marían aishri ajakua nu, tura Maríanam Jesús, chikich naari Cristo taji nu akinawaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Jesucristo apachri weantu ainaka ju ainawai, tura nuiya Abraham weantu catorce shuar ajakaru ainawai, tura nuiya Davidtai nagkamna nusha catorce shuar David weantu ajakaruiti, tura nui nagkamna Babilonianmaya israelita ainan achirar yaruakarua nui nagkamna nuisha catorce shuar ajakaruiti, nuu weantunam Jesucristo akinawaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jesucristoka juni akinawaiti: José Marían Jesucristo nukuri atinan nuatkatjame tusa chichas pujujakuiti. Turasha nigka tsanigkisha puju jakchauwaiti, tuma pujaun Wakan Pegker ajaprukti tusa timau asa María ajaprukuiti. ");
INSERT INTO hubNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Tumamtai José nekaa, nigka aishmag pegker asa, chikichka nekainatsaig uukan inaisatjai tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Joséka tu enentaimai, karanam nayaimpinmaya shuar wantintuku, tura Josén chicharuk: “David weantu uchiriya, iturchat enentaimtsuk María, ame nuatkattsam chichasuitam nuka jukita. Ni ajapruka auka pegkerchauchawaiti, nigka Wakan Pegkera nu ajaprukti timau asa ajaprukai. ");
INSERT INTO hubNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Nu uchi akinkai Jesús anaikata. Nigka shuar tunau ainan uwemtikatnaiti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","25","Nu tusa tima José shintar nayaimpinmaya timaunka turusag umiak, Marían nina jeen jukinaiti. Turasha Joséka Marían jukisha iwairin jureatsaigkika tsanigka kanarchauwaiti. Tuma pujai uchi akinamtai Jesús anaikauwaiti. Nu tu nagkamakna nuka, yaunchuk Yuusa chichamen etserin Isaías naartin tu aarua nu imanisag uminkauwaiti. Nuka tu aarmau ajakuiti: “Chikichik nuwa muntsurat ajapruktinaiti, nu uchi akinkai Emanuel anaikartinaiti”. Emanuel ta nunaka “Yuuska inii pujawai”, taku tawai. ");
INSERT INTO hubNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Herodes Judea nugkanmaya shuara apuri pujai, nu nugkanmag Jesús yaakat Belénnum akina. Tuma akinamtai chikich nugkanmaya etsa watainmani matsamin aina yaakat Jerusalénnum kaunkaruiti. Nu shuar ainaka yacha asar ya ainan iisar nekau ajakaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Yacha aina Jerusalénnum jeawar inimainak: “¿Uchi judío shuaran apuri atin yama akina nusha tui puja? ina nugkeen etsa watainmani pujusa, ni akinkai wantiinkatnaiti timauwa nu ya wainkamji, tura asar ni ememattasa winaji”. ");
INSERT INTO hubNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Nuna timaun shuar aina etserainakai, apu Herodes antuk kuntuts enentaimrau, tura ashi shuar Jerusalénnumia ainasha nuna antukar kuntuts enentaimraru, tumawar nuna pachis senchi chichaina. ");
INSERT INTO hubNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Nuna antuk apu Herodeska kuntuts enentaimu, tumak sacerdote ainan apurin, chicham umiktin aarmaun pachis etserin ainajaimak untsukuiti, tura inimuk: “¿Apu Cristosha tui akinatnaita?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Tutai nita aimainak: “Nuka yaakat Belénnum Judea nugkanam akinatnaiti. Yuusa chichamen etserin tu aaruiti: ");
INSERT INTO hubNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Judá nugkanam yaakat Belén tutainam apu akinatnaiti. Nuka Israel weantu ainan apuri atinaiti’, tu aarmauwaiti”, tusar tiaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Nu tamaun nekaa apu Herodes ya nekau ainan etsa watainmaya kaunkarun, chikich ainaka nekainatsaig, ima nitanak: “¿Ya wainkarmesha urutma nukapea arusurme?” tusa chichastasa untsukuiti. ");
INSERT INTO hubNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Tura shir aujas nekara, Belénnum akupeak: “Wetaarma, tumarum ¿tuig nu uchi apu atincha puja? nu shir nekaatarma. Turarum waketkurum winasha ujatkatarma, wisha wena nuna uchin ememattajai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Tusa tu akattram wearuiti. Tuma apu jeen ikuki wesar, nita nugkeen matsamsa yaa wainkamun wainkar shir aneasaru, tuma ya eketmaun iisar we wenakua uchi pujamunam yaasha nuig mamikas eketu asamtai jeawaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Tuma jea wayajkama uchin nukurijai pujuttamaun wainkaruiti. Tura uchin tikishmatrar ememataina. Turuinak nita pitakrin urakar warí anenkan wakerumain ainan, oron, shiripik pegker kugkuinan, kugkuin mirra tutaincha uchin susaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Nuna turawar kanuinai, karanam nayaimpinmaya shuar chicharuk: “Herodes pujamunmanigka wakettsuk chikich jintanmani waketkitarma”, tusa tinaiti. Timau asar chikich jintanam wakettraruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Nu shuar yaa wainak kaunkaru waketramtai, Joséncha nayaimpinmaya shuar karanam chicharuk: “Joséya, nantakta, tumam nuwem uchirijai jukim Egipto nugkanam tsekegta. Apu Herodes nina suntaari ainan uchi maatarma tusa ishiaktatui. Tumam ai pujamin, tsawan uminkamtai waketkita tusan ujaktatjame”. ");
INSERT INTO hubNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Tama Josésha nantaki, nu káshik Egiptonam pujustasa tsekegnaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Tuma Herodes jakamtai waketkittsa pujau. Tura nita Egiptonam wearua nuka, Yuusa chichamen aarmauwa nu imanisag uminkauwaiti. Nu aarmaunam Yuus: “Wina uchirun Egiptonmayan untsukmajai” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Apu Herodes enentaimrau, shuar yacha aina ya wainkar kaunkaru aina tsanurawaraipi tusa senchi kajekuiti. Tuma nina suntaari ainan, uchi Belénnumia, tura Belénnum tiiju matsatainasha, ashi uchi yama akina nagkamsarum, uchi yama chichaa nagkamsarum maatarma tusa ishiakuiti. Nunaka Herodes ya wainkar kaunkaru ainan inias: ¿Urutma tsawanta a uchi akinasha? tusa nuna shir nekaa asa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Nuna Herodes uchin tu ijinawa nuka, Yuusa chichamen etserin Jeremías naartin aarua nu imanisag uminkauwaiti. Nuka tu aarmauwaiti: ");
INSERT INTO hubNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Ramánam útainan antukuiti, nunaka Raquel nina uchiri ainaka jinaawaru asamtai, senchi útuk enentai ichichturtaj tamasha nakitmayi”. ");
INSERT INTO hubNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Tura nukap tsawan asa Herodes jakamtai, nayaimpinmaya shuar Josén Egiptonam pujuttamaun karanam chicharuk: ");
INSERT INTO hubNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Joséya, nantakta. Tumam nuwem uchirijai jukim Israel shuar ainan nugkeen waketkita. Yamaika apu Herodes uchin maattsa wakerimia nuka jakayi”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Nu tima Josésha tumasag nantaki nuwen uchirijai juki, Israel shuar ainan nugkeen waketkinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Turasha Israel nugkanam José jeajkama, apu Herodes jakamtai, nina uchiri Arquelao, apu jas pujau tamaun antuku, tuma aranak Judeanam wetasa pujaun, karanam chicharuk: “Judea nugkanam wetsuk, Galilea nugkanam wetá”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Tusa tima yaakat Nazaretnum pujustasa, chikich jintanam we Galileanam jeawaiti. Nu tu nagkamakna nuka Yuusa chichamen etserin aina: “Cristoka Nazaretnumia tutai atinaiti”, tusa tiarua nu imanisag uminkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Jesús eke Nazaretnum pujai, Juan imakratin Judea nugka aya nugkanmag númi atsamunam jintinkartu weká. ");
INSERT INTO hubNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Tumak chicharkartak: “Tunau takatka inaiyakrum Yuus nemarkatarma, ni inamratnuka tsawan ashi jeawai” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Juan jintinkartamuka yaunchuk Yuusa chichamen etserin Isaías aarua nu imanisag uminkauwaiti. Isaías tu aaruiti: “Shuar emak taa, aya nugkanmag wekaas senchi chichaak: Apu jintiya nu tutupin atii tusarum shir umiktarma, japau akaisha nugka yaruakrum aimratarma”. ");
INSERT INTO hubNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Juanka camello ure najanamun nugkujakuiti, akachumtairisha nuap najanamu, manchin yu jakuiti, tura napa yumirin umin ajakuiti. ");
INSERT INTO hubNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Juan aya nugkanmag jintinkartak wekai, Jerusalénnumia shuar aina, Judea nugkanam matsamin aina, tura Jordánnum matsamin ainasha ni jintinkartamun anturkartasa kaunkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Nu chicham jintiamun antukar, nitasha tunau takatairi ainan “Yuusa tsagkurturta” tusar ashi etsertumaina. Tumawarmatai Juan entsa Jordánnum nu shuar ainan imakaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Nuna turakai fariseo aina, saduceo ainasha Juan imatti tusar kaunkaru. Nu imanik kaunkamtai wainak, Juan chichaak: “¿Atumsha tunaurintin ainatirmesha, urukamtai maittsarmesha wakerarme? ¿Atumka ayatik maimuktsuk, Yuus waittan sukartustina nuna uwemturtatja tarumek? ");
INSERT INTO hubNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Antsu uwemrattsa wakerakrumka, tunau takatairam aina inaiyakrum enentaim yapajiatarma, tumakrum uwemmainaitrume. ");
INSERT INTO hubNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Atum enentaimsarmeka, ika Abraham weantu ainaj nui yupichu uwemmainaitji tarume. Turasha wii tajarme: Yuus wakerakka kaya aina junasha Abraham weantu amajmainaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Atumka araka numamtin ainarme. Shuar árak nereachunka ajak tsupir ekeemauwaiti. Yuuscha numamtuk atumi tunauri inait nakitakrumnaka waittan suramsatnaitrume. ");
INSERT INTO hubNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Wika ayatik entsajai imajrume, turasha wina ukuruin wina nagkatasu winittawai. Nigka atum tunau takatairam ainan utsantramak, ji keak tsuatan agkan amajna numamtuk Wakan Pegkeran suramsattarme. Wika niya imanchau asan, nuna zapatorinka atitmaitsujai. ");
INSERT INTO hubNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Shuar arakan arakmau nere pegker ainan yaruak chumpitainam chumpia, numiri ainanka ekeemak ajapna numamtuk, shuar tunauchu ainan akanak yaruaktinaiti. Tura shuar tunau ainan nunashaa akanak ji arumaisha kajinkashtin tuke ke atina nui matsamas waittsarti tusa ishiaktinaiti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Chikich tsawantai Jesús Galileanmaya jiinki, entsa Jordánnum Juan imatti tusa wuwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Tuma jeaamtai Juan imamainchau nekapeak: “Wii amina imatta tusan tumainaitjame, ¿tumaig ame wina imatta tusam winame?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Tama Jesús chichaak: “Ee, amina imatti tusan winitjame. Wika wina akuptuku turata timauwa nuna ashi imatiksanak umiktaj tau asan tajame. Tutai Juansha ayu tusa imainaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Turam Jesús entsanmaya jiinki, wajaig nayaim urannaiti. Tumamtai Yuusa Wakaní yampitsa numamtin taarun Jesús wainkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Nu tumaig Yuus nayaimpinam pujusag chichaak: ‘Ametme wina uchir anetaimka, nui amini shir aneajai’ ”, tusa tamau antukauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","2","Jesús Jordán entsanam maimtai Wakan Pegker egkemturuiti. Tura juki aya nugkanmag shuarsha atsamunam umauwaiti. Nui cuarenta tsawan tura cuarenta káshi pujaun, iwanch Satanás tutai: Tsanuran tunaun takamtiksachainjash tusa tarinaiti. Iman tsawan yurumkan yutsuk pujau asa, Jesúscha tsukama. ");
INSERT INTO hubNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Tuma tsukamtatmaun iwanch wainak chicharuk: “Nekas Yuusa uchiriyaitkumka tsukama pujutsuk, kaya aina ju pan najanam yuata”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Tusa tama Jesús ayak: “Atsaa, turashtatjai. Aarmau awai: ‘Shuarka ima yurumkanak yusagka pujumaitsui, antsu shuarka ima Yuusa chichamejaig pujumainaiti tawai’ ”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Nuna tusa timatai, Jesúsan juki ayas yaakat Jerusalénnum umauwaiti. Tura ejé Yuus ememattasa iruuntai jeanam yaki iwak, ");
INSERT INTO hubNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ataksha chicharuk: “Ame nekas Yuusa uchiriyaitkumka nagkimnam iyaarta. Aarmau awai: ‘Yuus nina inatairin nayaimpinmaya ainan amina kuitamramatnun ishiaktinaiti’, tu aarmauwaiti. Nu tu aarmau asamtai, Yuus ishiakmau aina ame tsekegkim iyaakum kaya aina au tukumkaim tusa igkunmak achirmak juramkiartatui”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Tusa tama Jesús ayak: Atsaa, tumashtatjai. Chikitcha aarmau awai: “Amina Yuusrum tsanuram nekapsattsam wakeripa tawai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Tusa timatai ataksha iwanch Jesúsan juki nain tsakarunam iwakuiti. Tura ju inaktamuik ashi nugkanam warí pegker irununka iwaintukuiti. ");
INSERT INTO hubNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Tura chicharuk: “Tikishmaram emematrita, turutawakmin aminak ashi susatjame”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Tusa tama Jesús ayak: “¡Iwanchi, wetá! Yuusa chichamen aarmau awai: ‘Ima amina apuram Yuusa nuke eme anentsa iiyakum emematta, turakum nigki umirkata tu aarmauwaiti’ ”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Tusa tima iwanch ni tsanumaintrin ashi tujintak ikukin, turamtai nayaimpinmaya shuar aina Jesúsan kuitamawartasa taruawaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Chikich tsawantai Judeanmaya apu Juankan achik cárcelnum egkea. Turawarmatai nuna antuk, Jesús Galilea nugkanam waketkin. ");
INSERT INTO hubNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Turasha nigka Nazaretka pujuschau, ayatik nagkamaki yaakat Capernaúm tutai kucha Galilea uwetas aunam wu, nu nugkanam yaunchuk uun Zabulón, Neftalí naartinjai matsama jakua nuna uchiri nuu weantu aina matsatu. ");
INSERT INTO hubNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Nuna Jesús Capernaúm nugkanam wuwa nuka, yaunchuk Yuusa chichamen etserin Isaías aarua nu imanisag uminkauwaiti. Nuka tu aarmauwaiti: ");
INSERT INTO hubNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Shuar Galileanam matsatu, nugka Zabulón, Neftalí tutaijai kuchan uwetas entsa Jordánkan nagkaiki a nuiyagka judíochu ainawai. ");
INSERT INTO hubNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Nu shuar nui matsata nuka tunaurintin asar, jakaujai metek káshia numamtinnum matsatui, tuma matsatu nita tunaurin utsankatna nuna chikichik Tsaaptinan ishichkisha wainchatain wainkartinaiti”. ");
INSERT INTO hubNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Jesús Capernaúm jeaa jintinkartutan nagkama. Tuma chichaak: “Tunau takatka inaiyakrum Yuus nemarkatarma, Ni inamratnuka tsawan ashi jeayi”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Chikich tsawantai Jesús kucha Galileanam wekama Pedron Simón naartinan, yachi Andrésjai, namakramin asar kuchanam redtan nagkimainak yujattamaun wainkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Tuma Jesús chicharuk: “Yamai nagkamsarmeka namakramat inaiyakrum wina nemartuktarma, tumarum Yuusa chichame shuar aina ujau ataarma”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Tusa tamauwaik nita redtrinka ajapa ikuinak nijai wearuiti. ");
INSERT INTO hubNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Jesús nitajai iruunar ishichik wesag Zebedeon, nina uchiri Jacob, Juan, nu ainajai botenam chumpimas redtrin apainak chumpimtatmaun wainkauwaiti. Tura Jesús chicharuk: “Nuka inaiyakrum wina nemartuktarma”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Tusa tamauwaik nita aparin, boterin tura nitajai takau ainan ajapa ikuinak Jesúsjai wearuiti. ");
INSERT INTO hubNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Tuma nuiya juaki, Jesús Galilea nugkanam pachinak wesa, jinti jintinkartakua wu, tura chiki chikichik yaaktanam jea judío aina iruuntainam chicham pegkeran Yuus tu inamui tusa jintinkartau, turak shuar ja ainancha ashi pegker amaju. ");
INSERT INTO hubNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Jesús pegker amajkartamun pachisar etseraina, tuinamun shuar Siria nugkanmayasha ashi antukaru, tumawar nukap jainan, iwanch egkemtuamun, waurin ainan, jata iyashi ipimturmau ainancha, tura ashi chikich jatajai ja ainancha Jesús pegker amajsati tusar nukap ikaatkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Jesús imatika shuar ja ainan pegker amajkai, shuar Galileanam matsamin aina, yaakat Decápolisnumiasha, tura yaakat Jerusalénnumiasha ashi Judea nugkanam matsamin ainasha, tura entsa Jordánkan amain matsatainasha Jesús chicharkartamun antukartasa ishintuina. ");
INSERT INTO hubNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Imatika tuaram Jesús wainak, chikichik nainnum wakau, tuma nina unuinatairi ainajai ekeemsauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Tuma Jesús jintinkartutan nagkama chichaak: ");
INSERT INTO hubNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Atum Yuus nekaspapita tusarum ima nigki enentaimtin ainatirmeka, Yuus atumin inamratin asamtai, shir aneasrum pujustarma. ");
INSERT INTO hubNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Atum tunauwapitja tusarum Yuus aujkurum útu pujautirmeka, Yuus ichichmamtan amastin asamtai, shir aneasrum pujustarma. ");
INSERT INTO hubNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Atum atumek nagkamaku anenmamchau ainatirmeka, atumnaka Yuus ni anajmatramawa nunaka ashi amastin asamtai, shir aneasrum pujustarma. ");
INSERT INTO hubNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Atum Yuus wakeramu pegker takastasrum wakerin ainatirmeka, atumnaka Yuus yainmaktin asamtai, shir aneasrum pujustarma. ");
INSERT INTO hubNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Atum chikich waitasha wait anentrau ainatirmeka, Yuus atumnasha wait anentramratin asamtai, shir aneasrum pujustarma. ");
INSERT INTO hubNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Atum tunaurum etsertumakrum tsagkurnaru ainatirmeka, Yuus wainkatin asarum, shir aneasrum pujustarma. ");
INSERT INTO hubNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Atum chikich ainajaisha kajernaitsuk pujautirmeka, atumnaka Yuus wina uchiruiti turamtin asamtai, shir aneasrum pujustarma. ");
INSERT INTO hubNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Atum pegker takákrum, chikich nuna nakitainak waitkam, waitu pujautirmeka, atumin Yuus inamratin asamtai, shir aneasrum pujustarma. ");
INSERT INTO hubNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Atum wina nekaspapita tusarum nemartuinatirmeka, atumin pegkerchaun chichartamainak, atum chichakchamuncha aantar tsanumrutmarar juramkiar, shir pujuschamnau amajtamainak waitkarmainakaisha, shir aneasrum pujustarma. ");
INSERT INTO hubNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Atumka nayaimpinmaya pegker aina jukitnaitrume, yaunchuk Yuusa chichamen etserin ainancha atumin waitkarmaina aitkasag waitkajaku ainawai. Tuma asamtai shir aneasrum nakunkut pujustarma”. ");
INSERT INTO hubNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Atumka wea numamtin ainarme. Weka jeajeatnuri aramu asa pegkeraiti, turasha nu jeajeatnuri megkakamtaigka, atakka waketki jeajeatu jamainchau asamtai, chikichik shuarkesha wakerumaitsui, ayatik juki aa ajapmainaiti. Numamtuk atumsha wina nemartin ainatiram pegkeraitkurmeka, chikich ainasha pegker jintinmain ainarme. Tura atum tunau takayatrum tumashtaiya tusarmeka chikichka jintinmaitsurme, ayatik makumattarme, tumakrum Yuus waittan surammau jukittarme”. ");
INSERT INTO hubNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Atumka ju nugka jui matsatkurmesha tsaaptina numamtin ainarme. Chikichik nainnum yaakat akugka umkagka achauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Tura lamparínkan ekeemakarka nukukarka nugka apujchau ainawai, antsu jean tsaaptin amajsamtai shuar ainasha iis yujasarti tusar, yaki ekenin ainawai. ");
INSERT INTO hubNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Atumsha numamtuk chikich shuar ainasha wainainak nitasha Yuusa nuna ashi emematiarti tusarum, pegker ainaka paan takamainaitrume”. ");
INSERT INTO hubNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Wika ju nugka juigka chicham umiktinan Moisés aarmauwa nuna asakartasnaka, tura Yuusa chichamen etserin aina aararua nunasha inaisatarma titasnaka taachuitjai. Antsu Moisés, tura Yuusa chichamen etserin chikich ainasha wina pachitas etserujakaru aina nuna umiktasan wika taawaitjai. ");
INSERT INTO hubNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nekasa tajarme, ashi chicham umiktinan Moisés aarua nuka nayaim nugkajai megkatsaigkika chikichkiksha megkakashtinaiti, antsu ashi metek imanisag uminkatnaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Tuma asamtai chicham shikapchich umiktin aarmauka ashi metek umimainaiti, turaku ekeka au nukap chikich ainasha umikarti tusa jintinkartumainaiti. Nu turakrum Yuusa inamtairia nuisha eme anentam atinaitrume, antsu nu turachkurmeka shuar imanchauch atinaitrume. ");
INSERT INTO hubNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Turasha fariseo aina, chicham umiktinan jintinkartin tunaurintin aina nujai metek pujakrumka, Yuusa inamtairi nayaimpinam a nuigka wayaashtin ainarme”, tusa Jesús tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Chicham umiktinan Moisés aak: ‘Magkartuawairpa, ame chikich maakminka ayamruinak amincha mantamawartatui tu aarmauwaiti’. ");
INSERT INTO hubNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Turasha wii tajarme, yatsumjaigka kajernainirpa, nina yachin kajeraka makumatnaiti. Tura nina yachin chichaman awannusha, ju nugkanmaya apu aina waitat suam atinaiti. Turasha nina yachin kajerak katsekeaka, ji arumaisha kajinkashtina nui egkemas waittsatnaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","Ame chikich shuarjai kajernaikamu arutramaig, Yuus emematku tagku aina maa patasa epetainam Yuus anajmatamu jukim wetsuk, yama nagkamchakmeka amijai kajernaikamua nuwaa werim, yamaika tsagkurnairami tusam titá. Nu tusam chicham epegtuniam nui shir aneasam, ame warí Yuus emematkum susattsam anajmatamu jukim wetá. ");
INSERT INTO hubNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Amina shuarum juramki apu pujamunam ejétamtasa umatmakaigka, apuin jeatsuk jinta wesamek shir chichasam epegtuniata, apu chichaman nekartama nuiyasha juramki, achikratin pujamunam ejétammatai, achikratin achirmak cárcelnum egketmaawai. ");
INSERT INTO hubNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nekasa tajarme, atumin apu achirmak egketmawarmataigka, akikmatskeka jinmaitsurme. Antsu kuitrum ishichik arutramuka ashi akikmakrum jiinmainaitrume”. ");
INSERT INTO hubNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Chicham umiktinan Moisés yaunchuk aarua nuigka: Atumi nuwenchuka takasairpa, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Turasha wii tajarme, shuar nuwan takaschainjash tusa, ayatik enentaimas iiyaamuik, nuwan takasua imanuk jawai. ");
INSERT INTO hubNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Tuma asamtai atumin ji tunau takatnum enentaimtikramkaigka, jiin untsurnumian ukuinak ajapawa numamtuk tunau takat inaisatarma. Chikichik jiijaig iimsar nayaimpinam wayaamuka nekas pegkeraiti, nu turachkurmeka, ashi iyashmijai jinum egkemsarum waitmainaitrume. ");
INSERT INTO hubNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Tura atumin uweje tunaun takamtikramkaigka, tsupik ajapawa numamtuk tunau takat inaisatarma. Chikichik uwejkea numamtuk nayaimpinam tunaurinchau wayaamuka nekas pegkeraiti. Nu tumachkurmeka ashi iyashmijai jinum egkemsarum waitmainaitrume”. ");
INSERT INTO hubNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Junasha Jesús jintinkartak: Nuwa ajapat pachisa aarmauwa nuka yaunchuk nagkamnas yamaikisha awai, nuka tawai: ‘Aishmag nuwen ajapkugka ajapnaiyaku aatain aar: Yamaika nuwarnaka ajapeajai’, tusa tumainaiti tu aarmauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Turasha wii tajarme, shuar nuwen tunaun takatsuk pujaun inaiyakka chikich aishmagnum awemak turawai. Nu nuwa ajapamujai nuwenusha tunaun takak tumawai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Junasha Jesús jintinkartak: Moisés shuar ainan yaunchuk chicharuk: ‘Yuus pachisam turatjai timauka umitskeka inaisaipa tusa tawai’. ");
INSERT INTO hubNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Turasha wii tajarme: Yuusa naariya nu anaikarum: Wii taja nu umiktinnaka Yuus iirkau atatui, tusarmeka tiirpa. Tura nayaimpia ausha Yuusa pujutairi asamtai, au pachisrumsha tiirpa. ");
INSERT INTO hubNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Tura ju nugkanmaya ainasha eme enentaimtirpa, nunaka nigki ashi kuitamu asamtai, ju nugkanmaya aina nuna nagkasau apu pujus inamratin asamtai, aantrarum Jerusalénsha pachisrum chichakairpa. ");
INSERT INTO hubNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Tura atumin wichigsha puju atii, tura mukusa atii tusarum takurmesha turumainchau asarum, atumka pujutrumsha aantrarum warí pachisrum nuna turachkunka wika jamainaitjai, tusarmeka chikich ainasha nekas tumamainapita turutiarti tusarmeka tiirpa. ");
INSERT INTO hubNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Nu aantrarum anajmasrum tu yujatsuk nekas turattakrumka: ‘Turatjai’ titarma. Antsu atum turumainchau akurmeka: ‘Turashtatjai’ titarma. Nu tutsuk iwása chichaamua nuka pegkerchau enentainmaya winawai”, tusa Jesús tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Atumka nekarme, Moisés yaunchuk aak: ‘Shuar jiimin emesturmakaigka, amesha turusmek nina jiisha emesturta, tura naimin akartamkaisha, amesha turusmek nina naisha akarkata’, tu aaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Turasha wii yamai tajarme: Nuka turumaitsui. Atumin nepettamki pegkerchaun chichartamkaisha ikkairpa. Shuar yapimin awattamkaisha atumsha ikkarum awattsuk, juni yapiruisha awattita tusarum titarma. ");
INSERT INTO hubNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Tura shuar nugkutain awiik jurutramkaisha chikishcha jukirum susatarma. ");
INSERT INTO hubNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Tura shuar kijinan suramuk, ‘ju mil metros ejéturata’ tusa turamkaisha, dos mil metros ejétitarma. ");
INSERT INTO hubNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Atsumamun seatmainakaisha surittsuk susatarma, tura atumin warírmin ikattsata turamkaisha, atsaa tutsuk ikastarma”. ");
INSERT INTO hubNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Yaunchuk uun aina chichainak: ‘Atumjai irutkau aina nuke anetarma, tumakrum shuarumka aujsairpa’ tusa tiarua nuka shir nekarme. ");
INSERT INTO hubNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Turasha wii tajarme: Kajertamainasha anetarma, turakrum atumin waitkarmainasha pachisrum Yuus aujtustarma. ");
INSERT INTO hubNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Atum nu turakrumka ina apuri nayaimpinam puja nu wakeramu umiarme, tuma asarum nina uchiri atatrume. Yuuska ashi shuar ainan aneawai, tuma asa etsan, yumincha ima shuar pegker ainanak akuptutsuk shuar pegkerchau ainancha ashi metek akuptawai. ");
INSERT INTO hubNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Atumin anenma nuke ane pujakrumka chikich aina nagkasau pegker takatsrume. Shuar tunaun takau ainasha ni aneniamurijaigka anenain ainawai. Nuka tumatsuk atumin kajertamainasha atumka anetarma. ");
INSERT INTO hubNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Tura atum ima atumin pataim ainajaig chichasan pujustajai tarum nusha ¿urukamtai tarume? Nunaka Yuusa enentaimtichu ainasha tumau ainawai. Nu tumakrumka Yuusan umirchau aina nu nagkasauka takatsrume. ");
INSERT INTO hubNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Atumi apari nayaimpinam puja nuka pegker asamtai, atumsha pegker ataarma”, tusa Jesús tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Kuitammamatarma atum pegker takamuka, chikich ainasha winak eme anentriarti tusarmeka, chikich ainasha ashi wainainamunam takastasrumka wakerirpa. Atum aya shuarnumag iwainmamkattsarum turakrumnaka, ina apari Yuus nayaimpinam pujuwa nuka atum takasmaunka akirmakchatnaittrume. ");
INSERT INTO hubNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Tuma asamtai atum chikichik shuarkesha atsuma yayákrumka, chikich ainasha wii takaj juna nekaawarti tusarmeka etseru yujairpa. Shuar tsanukratin aina chikich ainasha wii takámun ashi wainkarti, tusar kachu umpuar iruuntai jeanam irumkartur, tumachkusha jinta yantam untsumak irumar ashi wainainamunam takau aina tuma yujairpa. Tuma yujau ainaka nugkanmaya shuar aina eme anentu jakmau asar, Yuus eme anentam achartinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Nu tuma asamtai atum shuar atsuma yayákrumsha, wika jutiksan yaimjai tusarmeka, atum shir chichatairmeksha ujakairpa. ");
INSERT INTO hubNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Nuka pachisrum etseru yujatsuk inaisatarma, nunaka ina apari Yuusa nuke wainui. Tuma asa atum nayaimpinam jeakrumin Yuus eme anentramsatnaitrume”. ");
INSERT INTO hubNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Atumka Yuusjai chichakrumsha, nitaka pegkerapi ainawa turutiarti tusar tsanumin aina, ashi waitkarti tusar iruuntai jeanam iruuntramunam wajakiar, tumainachkusha jinta ashi shuar wainainamunam wajakiar, senchi chichakar Yuusan auju yujau aina tumawairpa. Nekasa tajarme: Shuar waitkarti tusa Yuusan tu auju yujainaka anturam ainatsui. ");
INSERT INTO hubNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Atum Yuus aujkurmeka, kanutairmin tumachkurmesha shuar atsamunam ima atumin apari Yuusa nujaig pujusrum aujsatarma. Atum tu aujmaka atumin apari Yuusa nusha waitmarme. Tuma asa atum nijai chichasmaun anturtamak umirtamkattarme. ");
INSERT INTO hubNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Atum Yuus aujkurmesha chikichik chichamak chichakmauk awaigkirmeka shuar Yuusa shir enentaimtichu aina chichaman awe awena chicha yujau aina tumawairpa. ");
INSERT INTO hubNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Nu atum imatruarum ashi ujashmasha, ina Apariya nuka atum atsumamunka nekawai. ");
INSERT INTO hubNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Tuma asamtai atum Yuus aujkurmesha titarma: ‘Apaachi, ameka nayaimpinam pujuwaitme. Pegkeraitam imau asaakmin, chikich ainasha ima aminak ashi emematramiarti. ");
INSERT INTO hubNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ashi shuartin amek inakratta. Tura nayaimpinmaya shuar aina ame wakeramun umirtamin aina aitkasrik, ju nugkanmaya shuar ainatisha ame wakeramua nuke umikarmi. ");
INSERT INTO hubNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ame kashi kashinig ii yuatnusha sukartita. ");
INSERT INTO hubNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Chikich aina pegkerchaun takartamainasha tsagkurin ainaj turusmek ina tunaurisha tsagkurkarturta. ");
INSERT INTO hubNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ina iwanch tunaun takasti tusa nekapramkaisha inaikartusaipa, amek yaigkratkata ii nepetkami’, nu tu aujsatarma. ");
INSERT INTO hubNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Atum chikich pegkerchaun takartamsau tsagkurkurmeka, atumsha atumin apari Yuus nayaimpinam puja nusha tsagkuram atatrume. ");
INSERT INTO hubNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Antsu atum chikich pegkerchaun takartamsau tsagkurchataika, Yuuscha atumin tunaurinka tsagkurtamrashtatrume”. ");
INSERT INTO hubNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Atum Yuus aujsattsarum ijarmakrumsha, shuar tsanukratin aina wii ijarman Yuusan aujmaurnasha chikich ainasha waituk, nigka nekas Yuusan aujkumpapi imani wekawa turutiarti, tusa wake mesekar yujau aina tumawairpa. Nekas tajarme, nuna tuma yujainaka Yuus shir anentam ainatsui. Antsu shuar waitkati tusar tuma yujaina asar, shuar eme anentam ainawai. ");
INSERT INTO hubNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Tuma asamtai Yuus aujkurmeka wake mesekrum yujatsuk, yapim entsajai nijaarum shir nakunkut yujastaarma. ");
INSERT INTO hubNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Chikich shuar ainasha atum ijarma yujasrum, Yuus aujmaurmin nekartamawarai. Atum ijarma yujamunka Yuus nigki waitmak, atsumamu pachisa aujmasha amastatrume”. ");
INSERT INTO hubNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Ju nugka jui warín kaya emesmain nu turachkaisha kasa wayaa kasammain aina nuninnum wiakchamattsarmeka wakerirpa. ");
INSERT INTO hubNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Antsu nayaimpinam kayasha warín emeskamtai megkaamainchau, kasasha wayaa kasammainchauwa nui wiakchamatarma. ");
INSERT INTO hubNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Atumka ju nugka jui imanikrum wiakchamarmeka, nuke enentaimtu pujumainaitrume. Tura nayaimpinam wetasrum wakerakrumsha, nuke enentaimtu pujumainaitrume. ");
INSERT INTO hubNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Lamparín ekeemakam, jean tsaaptin amajna numamtuk atumin iyashi tsaaptin amajuka tunau takatsuk pujamua nuwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Atum tunau takatsuk pujakrumka, ashi atumi iyashigka pujuttrumjai tsaaptinnum awai, antsu atum tunau takat aina nu takákrumnaka káshi jawai. Atumin tsaaptin a nu káshi jatramsairum senchi kuitammamatarma. Tura atumin pujuti káshichuitkaigka, lamparín keekmaunam waintaiya numamtuk pegkerchau ainaka nekamainaitrume. ");
INSERT INTO hubNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Shuarka jimar patrónkrinnuka amaitsui. Chikich patrónkrin ima senchi aneak, chikichan kajermainaiti. Tumachkusha chikich patrónkrin umiruk, chikichan nakita asa umirtsuk inaimainaiti. Numamtuk atumsha Yuus aneakrum nigki umirkattsarum wakerakrumka, kuitjai apatkarmeka anemaitsurme”. ");
INSERT INTO hubNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Junasha tajarme: Atumka warina yuanak, warina umarnak, warina nugkurnak pujustaj tusarmeka, kuntuts enentaima pujuirpa. Yutai tura nugkutai aina nuna nagkasau senchi enentaimtumainka tunau takatsuk shir pujustaj tamauwa nuwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Atumsha chigki agkarunam nanamaina nu enentaimtusrum iistarma. Arakan arawar yuattsagka takainatsui, yutairin irumrattsagsha jeancha jeamainatsui, tumainanak nita yuatnunka Yuus suawai, turam nuna yusar matsatainawai. Turasha chigki nagkasau ainatirmeka atumetrume. Tumau arumnasha ¿urukamtaig Yuuscha atum atsumamuncha amaschati? ");
INSERT INTO hubNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿Atumsha nayau atajai tusarum enentaimtu pujakrumsha nayau amainkaitrum? Nuka chikichkitirmeksha tumamaitsurme. ");
INSERT INTO hubNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","¿Urukamtai atumsha jaanch nekas pegker aina iman nugkuta nuke enentaimtusha matsatrume? Atumsha yagkur enentaimtusrum iistarma. Nitaka nugkutain pegker iwaramun najanawar nugkurar iwarmamrartaska uruchnaksha kutamainatsui. ");
INSERT INTO hubNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Tumainayat yagkuruinak nugkutai pegkeran, chikich shuar aina waitas najanamun, Salomón sumak nugkur chikichan nagkasau iwarmama jakua, nuna nagkasau Yuus iman yagkurmamtikmau asar, pegkeran yagkuruinawai. ");
INSERT INTO hubNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","¿Urukamtai atumsha yagkur yamaikika pegkeran yagkuruk iruuntatmaun aruma nui etsa sukuam kaaktin ainancha Yuus imatikas wakerumainan iwaraisha, winasha nigkiapi imatikrus nekas iwartumainaita tusarmesha tatsurme? ");
INSERT INTO hubNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","32","Nui atum Yuusnau ainatirmeka, shuar Yuusan enentaimtichu urukin aina tumarmeka, ‘warinak yuataj, warinak umartaj, nugkumaintrusha atsurtawapi’ tusarmeka enentaima pujuirpa. Atum atsumainamunka atumin apari Yuusa nu ashi nekartamrume. ");
INSERT INTO hubNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Nui yama nagkamchakrumka Yuus wakeramua nuwaa umirkatarma. Tumainakrumnaka atum atsumamu ainanka Yuus ashi suramsattarme. ");
INSERT INTO hubNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Atum iturchatnum jeaakrumincha Yuus yainmaktin asamtai, atumka chikich tsawantin atinka emtikarum enentaimtu pujuirpa, antsu ima chikichik tsawan tsawamunmayag enentaimtitarma”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Chikich aina tunaun takainakai waitat suakrumnaka, Yuus atumnasha turusag waittan suramsatnaitrume. ");
INSERT INTO hubNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Tura atum chikich aina pegkerchaurisha tsagkurchakrumnaka, Yuuscha atumi tunaurincha tsagkurtamrashtatrume, atum chikich aina pegkerchaunam iiktaika, nisha turusag waittanmag iiktamkattarme. ");
INSERT INTO hubNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Atumka yatsum tunaun imanchaun taká aig atum ima pegkerchau takayatrum auka pegkerchaun takáwai tusarum tarume. Nu tautirmeka shuar nina jiin tsetse uun egketun waintsuk, chikichan jiin tsetse shikapchich egketun wainmaina numamtuk jarme. ");
INSERT INTO hubNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ametme pegkerchau aina nukap takaumka. ¿Tumauwaitiatmesha urukamtai amina yatsumsha pegkerchau takatka inaisata tusamsha tame? ");
INSERT INTO hubNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ameka shir waitrinaitme. Yama nagkamchakmeka pegkerchau takata nu amea inaisata, tumam yatsum pegkerchaun ishichik taká nusha uruk yainmainkitam nu nekam pegkerchau takat inaisata tusam yaigta. ");
INSERT INTO hubNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Tura Yuusa chichame pegkera nuna antutan nakitaka waitkatsuk inaisatarma. Nitaka yawa kajen yutai pegker suamaitak pempenki asakratmaina numamtuk ainawai. Tura warí pegker akik ainaka kuchi najar emesrai tusarum, kuchi matsamtainmagka ikumaitsurme. Numamtuk shuar aina chicham pegkera nuna antutan nakitainakaigka ujamaitsurme. ");
INSERT INTO hubNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Yuus aujsatarma, tumakrum atum atsumamu pachisrum ujaktarma, nu tamaka atum atsumamuncha suramsattarme, winasha uwemtikrurta tusam Yuus titá, tusa tamaka uwemtikramrattame. ");
INSERT INTO hubNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Shuar seamuka suam awaiti, shuar eaka ni eamurinka wainnaiti, waitinam wajas untsumusha waiti uratam awaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","¿Atumsha uchiram yurumkan seatmaig yurumak sutsuk, kaya jukirum sumainkaitrum? ");
INSERT INTO hubNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","¿Turachkurmesha uchiram namakan seatmaig, nápi jukirum sumainkaitrum? ");
INSERT INTO hubNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Atumka shuar tunau ainakrumsha, uchirmeka pegker suwaitrume. Atum tumarmincha Yuus nekas ima Pegkera imausha, ¿urukamtaig atum pegker seamuncha amaschati? ");
INSERT INTO hubNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","‘Atum chikich ainasha shir amajtiarti tusarum wakerakrumka, atumsha chikich ainasha shir amajtarma’. Nuna tusa chicham umiktinan Moisés aarua nuisha tawai, tura nuiyasha Yuusa chichamen etserin chikich ainasha tu aararuiti”. ");
INSERT INTO hubNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","“Nukap shuar aina jinta wagkaram megkaatanam jukarta nuna ima senchi nemarainawai. Tura ujumchikiti shuar jinta tsererach pujut nagkanchaunam jukarta nuna nemarainaka. Tuma asamtai nekasa tajarme, jinta megkaatanam jukarta nu nemartsuk, atumka jinta tsererach turasha pujut nagkanchaunam jukarta nu nemarkatarma”. ");
INSERT INTO hubNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“ ‘Yuusa chichame etserji’ tusar waitan nitak enentaimsar etserin aina nu tsanurmarairum, atum ainatirmeka pe kuitammamatarma. Nitaka kasa shuaran, wisha pegkeraitjai tusa, aruma nui kasarkattsa amikmauwa numamtuk jainawai. ");
INSERT INTO hubNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Tumaina asamtai shuar ainaka nita takainamuri iirsarum nekamainaitrume. Munchigka untukra nerenka neremaitsui, tura untukrasha munchi nerenka neremaitsui. ");
INSERT INTO hubNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Árak ainasha enentaimtusar iisarmi. Árak pegkeran neren ainaka tumasag pegkernak neren ainawai, tura pegkerchaun neren ainasha tumasag pegkerchaunak neren ainawai. ");
INSERT INTO hubNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Tumau asa árak pegkeran nerenka pegkerchaunka neremaitsui, tumasag pegkerchaun nerencha pegkernaka neremaitsui. ");
INSERT INTO hubNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ashi númi pegkerchau ainaka tsupira jinum aestaiyaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Nui atumka nita takainamuri iisrum, chicham waitnasha yáki etseraina nuka nekamainaitrume”. ");
INSERT INTO hubNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Shuar aina wina chichamrun umiachiat: ‘Ametme wina apurmeka’, turutu jaku ainaka wina aparu inamtairinka pegkesha wayaachartinaiti. Antsu wina apar wakeramua nunak umikaru aina nuke wayawartinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Tura wii nayaimpinmayan taakai, nukap shuar turutiartin ainawai. ‘Apu, ika amina chichamrum etserkur shuaran iwanch egkemtua ainasha amina senchirmijai jiira utsankauwaitji, tura ja ainasha pegker amajkur wainchatai ainasha nukap iwainakuitji’. ");
INSERT INTO hubNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Tusar imatainakaisha wii ayakun: ‘¡Atumka winau ainatsrume! ¡Tunaun takau ainata wetaarma!’ tusan titinaitjai. ");
INSERT INTO hubNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Shuar wina chichamrun anturtukar imatiksag umirtuina nuka, chikichik shuar jeen muchignum tai ajiar jeamkauwa numamtuketi. ");
INSERT INTO hubNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Nu imatika jeamkamunka yumi yutuk nujagkraksha, tura nase umpuaksha shir ajiara jeamkamu asamtai yumpuumaitsui. ");
INSERT INTO hubNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Turasha wina chichamrun antuinayat umirtukcharuka, shuar enentaimchau asa, yaikminam tai jeamkauwa numamtuketi. ");
INSERT INTO hubNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Nu tura jeamkamunka yumi yutuk nujagkrak, tura nase umpuak yumpuar ashi utsainaiti”, tusa Jesús tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Nuna tusa Jesús jintinkartua ashimkamtai, nui shuar antu irunuka nuna antukar enentain jearcharuiti. ");
INSERT INTO hubNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Nigka shuar chichame anturtai ainancha nagkasau jintinkartawai, chicham umiktinan jintinkartin ainajaisha metekchauwaiti, tusar tuina. ");
INSERT INTO hubNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Nuna ashi jintinkartua ashimak nainnumia akaiki weakai, nukap shuar aina shimuina. ");
INSERT INTO hubNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Tumainai chikichik shuar lepra tukumu asa, jak pujau. Tuma asa Jesúsan wainak, nugka tikishmar chicharuk: “Apu, ame wakerakmeka shir amajtumainaitme”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Tusa tama Jesús shuar jan achiak: “Wakerajai, yamaika pegker jasta”, tusa tinaiti. Tamauwaik wári ashi chimik pegker jasuiti. ");
INSERT INTO hubNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Tumamtai Jesús chicharuk: “Wetá, turasha chikich shuar ainaka ujakaipa. Moisés timauwa nu metek umiakum, etsertsuk sacerdote pujamunam jeata. Nuka tu aarmauwaiti: Ashi shuar leprajai ja pegker jasuka tuke tumasarke artinaiti. Tura chikich ainasha wainainak nekaspapi pegker jasia tiarti tusa timau asamtai”, tumata tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Nuna tusa ikuak nui jiinki Capernaúm jeastatuk wea, tumattamaun Romanmaya apu igkugkuiti. ");
INSERT INTO hubNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Tura chicharuk: “Apu, wina inatair ashi iyashi ainan najaimak nantakchamnau jas waitu tepemayi”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Tusa tuma Jesúscha chichaak: “Ayu, wii pegker amajsatjai, ijai wemi”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Tusa takai apu chichaak: “Ameka wina nagkatasu apu asaakmin, natsaamakun wina jearuigka wayata tumain nekapeatsjai. Tuma asamtai ayatik juig wajasmeksha: Inatairmeka pegker jastii turutta. Tusa ame timaka wina inatairsha pegker jastatui. ");
INSERT INTO hubNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Wii chicham umirmaincha matsatui, tura suntar wina umirtin ainasha arutui. Nuna wii ‘jiintrarum shiaktarma’ tamaka jiintrar shimumain ainawai, tura wii ‘waketratarma’ tamasha waketar kaunmain ainawai, tura wina takartin wii ‘inamsha’ imatiksag umirtinaiti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Nuna tusa takai Jesús enentai jearchauwaiti. Tumak shuar nijai iruuntra yujamun chicharuk: “Israel shuarkesha apu nekaspapita ta imaunka chikichkinkisha wainchauwaitjai. ");
INSERT INTO hubNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Tuma asamtai nekas tajarme, nukap israelita ainasha wina nekaspapita tusa nemartuinaka Yuusa inamtairin wakartin ainawai. Tumawar Abraham, Isaac, Jacob nu ainajai nayaimpinam iruuntrar yuawartin ainawai. ");
INSERT INTO hubNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Tura israelita ainayat wina nekaspapita turutchau ainaka nayaimpinmagka Yuusa inamtairinka wayaachartin ainawai, ayatik waitat arumaisha nagkankashtin, káshia nui utsagkam senchi waitainak nain takertuinak útu matsamartinaiti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Nuna tusa Jesús apun chicharuk: “Jeemiin waketkita, ame pegker amajtursattawapi tusam tame nuik amina inatairmeka pegker jasai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Nuna tusa ikuak Jesús Pedro jeen wuwaiti, tuma jeaa jeanam wayajkama Pedro tsatsarin senchi tsuer jak peaknum tepaun wainkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Tura nuna wainak uwejnum antigku, turam imanika tsuweamun michatar pegker jas, nantaki yurumkan inarak, shuar Jesúsjai yujan ayurawaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Nu tsawantaik kintamai, chikich shuar ainasha nita patai ja ainan, iwanch egkemtuamu ainancha ikaatkaruiti. Turawarmatai Jesúscha ayatik chichamaik iwanchi jiintrarum shiaktarma, tusa tinaiti. Tama iwanch shuaran egkemtua ainasha jiintrar shiakaru, tura ja ainancha pegker jastarma, tusa tinaiti. Tama ja ainasha ashi pegker jasaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Nuna Jesús ja ainan pegker amajsarua nuka yaunchuk Yuusa chichamen etserin Isaías aarua nu imanisag uminkauwaiti. Nuka tu aarmauwaiti: “Ni ashi ii najaimatai ainanka emegkaartinaiti, turak ja ainancha ashi pegker amajsartinaiti”. ");
INSERT INTO hubNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Nukap shuar aina iruuntuinam wainak, Jesús nina unuinatairi ainan chicharuk: “Kucha amain katigmi umintsatarma”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Tusa eke wetasa uminai, chicham umiktinan jintinkartin Jesúsan jeari chicharuk: “Jintinkartina, ame tuig wekaitam, tumakmincha aminak tuke nemartin atajme tusan wakerajai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Takai Jesús chicharuk: “Kuntin ainan waarigka aruinawai, tura chigkinusha kanumaintrigka pasugke aruinawai, turasha wii shuarnum akinawaitaj nunaka jenchauwaitjai, tepesa ishichik ayamaintrusha atsurtaig wekajai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Nuna tusa chikichnasha nemartukta, tusa tinaiti. Takai: “Ayu apu, jasta, ishichik nakarsata. Wina jearui wena apar jakamtai, ikusan ikuakun nui nemarkatjame”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Tusa takai Jesús chicharuk: “Ameka nuka pachitsuk inaisata, shuar wakaniin jakau aina nu apa jakamtaigka nita ikusarti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Nuna tusa ikuak Jesús nina unuinatairi ainajai amain katigkartasa botenam chumpimraru. ");
INSERT INTO hubNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Tuma wenai Jesúska egkemaa kanaruiti, tuma ai nase nasentan nagkamna, tuma nasentuk botenam entsan senchi yara, imaniak ashammain amaju. ");
INSERT INTO hubNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Imaniakai Jesúsan unuinatairi aina senchi ashamaina, tumainak Jesús kanar egkemtatmaun ishintainak: “¡Apuru, shintaria, nase ukatmittaji!” tusar tuina. ");
INSERT INTO hubNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Tuinakai ni chichaak: “¿Urukamtai imanikrumsha ashamarme? ¿Atumka winaka nekaspapita turuttsurmek?” tusa tinaiti. Tusa nantaki nase imanik nasentatmaun emegkaku, turam kuchasha mijaakuiti, tuma ashi jasa asauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Tumamtai shuar nui chumpirainaka enentai jearcharuiti, tumaina asar nitak chichainak: “¿Ju shuarsha uruku asamtaiya, nasesha, tura nayantsasha ni chichamurincha umirainawa?” tusar nitak tunaiyaina. ");
INSERT INTO hubNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Tuma nase megkakamtai we wenakua kucha amain nugka Gadara tutainam katigkaru, tumattamaun jimar shuar iwanch chumpimtuamu asa, shuar jakau ikutainam pujuina wainkar nitan igkugtasa winittamaun jimar shuaran wainkaruiti. Nuka shuar iwanch chumpimtuamu senchi kajen aina, iman asarmatai chikichik shuarkesha nu jintanmagka wejakcharuiti. ");
INSERT INTO hubNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Tuma asar Jesús anumak winittamaun wainkar senchi untsumainak: “¡Jesúsa, Yuusa uchiriya! Wait aneasam tsawan jeatsaigkika waittaka sukartusaipa”, tusar tuina. ");
INSERT INTO hubNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Nuna tusa kuchisha nuig tiijuch yuak matsatu asamtai, ");
INSERT INTO hubNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","iwanch chichainak: “Ju shuarnumia jiikratkumsha au kuchi iruna ai chumpimatarma tusam tukartita”, tusar tuina. ");
INSERT INTO hubNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Tusa tuinakai Jesús chicharuk: “Ayu, ai wetaarma”, tusa tinaiti. Tima shuarnaka ikuinak kuchinam chumpimawaruiti. Turam kuchika pisarar nugka metsagkrukmaunam kuchanam utsaanawar jinaawaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Tumawarmatai kuchin kuitamin ainasha ashamkaruiti. Tumawar ¿urukakug ainka? tusar tsekearar, shuar yaaktanam matsatainan: “Kuchi tuma jinaayi” tusar ujakartasa wearuiti. Tumawar shuar yaaktanam matsatun ujakaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Turamu asar shuar yaaktanam matsataina antukar, Jesús pujamunam wearuiti. Tuma jeariar chichainak: “Wait aneasam, ina nugkea juigka pujutsuk, yaja chikich nugkanam wetá”, tusar tiaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Nu tusa tama Jesúscha botenam egkemaa ataksha nina yaaktarin katigkuiti. ");
INSERT INTO hubNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Tuma katig nina yaaktarin pujai, shuar wekaichun ayatik tampumruawar ejétiaruiti. Turam Jesús nigkiapi pegker amajsattawa tu enentaimainan nekau asa, wekaichun chicharuk: “Aishmagku, shir enentaimsata, yamaika amina tunaurumnaka tsagkuurajme”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Nuna tusa takai chicham umiktinan jintinkartin aina nitak enentaimsar: “¿Jusha shuarsha uruku asaya tunaurumnaka tsagkuurajme tusasha, Yuusa nagkasausha chichasha wekawa?” tu enentaimaina. ");
INSERT INTO hubNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jesús shuar tu enentaimainan nekaa chichaak: “¿Urukamtai ima pegkerchausha enentaimrume? ");
INSERT INTO hubNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Turasha warí tumainaita? ¿Amina tunaurumnaka tsagkuurajme tachakrisha nantakim, ainka tepetairam jukim wetá tumainkait? ");
INSERT INTO hubNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Wika shuarnum akina asan, shuara tunaurincha tsagkurmainaitjai. Tuma asan atumin yamai iwaintuktajrume”, tusa tinaiti. Tusa inaiyak shuar wekaichun chicharuk: “Nantakim ainka tepetairam jukim jeemin waketkita”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Tusa tamauwaik shuar wekaichu ayatik tepen itaamusha nantaki nina ainka tepetairin juki jeen wuwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ja pegker jasmatai chikich aina wainkar enentai jearcharuiti. Tumawar chichainak: “Nekas Yuusapi ima senchirtinaita, tuma asampapi ju shuarnasha nina senchirin susaya”, tusar Yuusan ememataina. ");
INSERT INTO hubNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Irunmau ashimnakmatai Jesús jiinki weajkama, apunu atinan shuar aina kuitan akikmainakai ekeemsa jutainam eketun Mateon wainkauwaiti. Tura wainak chicharuk: “Weajai, wina nemartukta”, tusa tinaiti. Tusa tama nisha Jesús weakai wuwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Tuma pujus chikich tsawantai nina amikri kuit apunu atinan yarumin ainan chicharuk: Wina jearui taatarma Jesúsjai iruuntura yurumak yuawarmi tusa ashi ipaawaiti. Turamu asar amikri ainasha tawar, Jesúsjai mesanam ekeemsaruiti. Tura Jesúsa unuinatairi ainasha ashi ekeemsaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Tuma Jesús yurumkan yuakai, fariseo aina nuna wainainak Jesúsa unuinatairi ainan chicharainak: “¿Urukamtai atumin jintintramnusha shuar apu kuitri atinan yarumin ainajai, tura shuar tunaurintin ainajaisha iruuntursha yuawa?” tusar tiaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Nu tusa tuinamun Jesús antuk chichaak: “Shuar jachu pegker ainaka tsuakratnunka atsumchau ainawai. Antsu shuar ja aina nu tsuakratnun atsumin ainawai. ");
INSERT INTO hubNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Wika shuar tunaurinchau ainanka taruachuitjai. Antsu shuar tunaurintin aina tunau takatan inaiyainak Yuusnak umirkarti tusan taruawaitjai. Aantrarum tu yujatsuk Yuusa chichamen etserin aina aarmauwa nu aujsarum aneartarma. Nuka tu armauwaiti: ‘Yuus tunaurun tsagkurturti tusarum tagku aina maarum epeakrum ajamnain ainarum nunaka wakeratsjai. Antsu chikich ainancha wait anentrarti tusan wika wakerajai tawai’ ”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Nuna tusa Jesús takai, Juankan unuinatairi aina Jesúsan jeariruiti. Tuma ininak: “¿Urukamtai Juankan unuinatairi ainatika, tura fariseo ainasha yurumkan yutsuk pujusar Yuus aujin armaji? ¿Turasha urukamtai amina unuinatairam ainaka ijarma pujuinatsua?” tusar tuina. ");
INSERT INTO hubNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Tusa tuinakai Jesús nitan ayak: “Shuar nuwenmaunam ipaamu ainaka nu shuar nuweenatin pujaigkika ijarmakarka iruunmaitsui. Antsu nuweenatin jiistamuk ipaman maawarmatai, irar ainasha wake mesemar nekapenak, ijarmamain ainawai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Nuna tusa chikichnasha pachis chichaak: “Jaanch yamaram asa, jaanch mamurun nu senchi jaamain asamtai, jaanch yamarman tsupikar mamurunka anujtichu ainawai. ");
INSERT INTO hubNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Nuap aparmau arutmaraunmagka, umutain vino yama umikmau yara aimka ikukmaka kariak, saurkugka nuap arut asamtai apujmainaiti. Turasha yamarmanmagka tumamaitsui, nuap yamaram asa, ayatik wagkaki weakai, kariak saurkusha pegkerak amainaiti”, tusa Jesús tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Nu ainan tusa Jesús chicharkartak pujai, chikichik apu jea judío ainan iruuntain apuri taawaiti. Tuma Jesúsa emtin tikishmatar chichaak: “Nawantur pegke jan ikukjai, turasha apu, ame winim uwejmijai antintrukta, turam nisha pegker jastii”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Tusa takai ayu tusa jiinki weakai, nina unuinatairi ainasha wearuiti. ");
INSERT INTO hubNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Tuma weenai chikichik nuwa, doce uwí nantu wainu puju, “Jesúsa nugkutairinkisha antinkanka pegker jamainapitja” tau asa, ukunam juarki nugkutairin yantamen antinkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Tura antigkam Jesúscha ayanma iiyajkama nuwan wainkauwaiti. Tuma chicharuk: “Nekas pegker amajtustatuapi tusam antinkaum nui pegker jastatme. Tumatin asam shir aneasta”, tusa tinaiti. Nu tusa tamauwaik pegker jasuiti. ");
INSERT INTO hubNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Tura ikuak Jesúska judío ainan apuri nawantri jarukmaun jeen jeawaiti. Nui jeajkama jakaun ikusartasa tuke turin asar, nu nuwach jakamtai flauta ainan umpuinak pampa matsatun wainkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Imatu pujuinan Jesús jea wayak, nitan chicharuk: “Aantrarum imatu matsamtsuk jiintrarum shiaktarma, nuwachika jakachai kanar tepawai”, tusa tinaiti. Tusa takai, chikich ainaka wishikrar ikuinak jiintrar shiakaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Nuna tura shuaran ishiak inaiyak Jesús wayaawaiti, tuma nuwach jakamtai punuaram tepettamaun jeari uwejnum achik inankinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Nuna tura Jesús nuwan inankimtai, ashi yaaktanam etseraru ainawai. ");
INSERT INTO hubNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Tura nuwan inankimtai ikuinak, jiinki Jesúsjai wenai jimar shuar wainmachu pataakaruiti. Tuma senchi untsumuk: “Apu, ametme David weantunam akinawaitam nuka, tuma asam incha wait anenkarturta”, tusar tiaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Tusar Jesúsjai weakai pataakar we wenakua Jesús jea wayakai, wainmachu ainasha wayawaruiti. Tuma Jesús pujamunam jeantaruiti, tumawarmatai Jesús nitan chicharuk: “¿Atumsha winasha nekaspapi pegker amajtamsattajia turutrumek?” tusa tinaiti. Tusa tama nitasha: “Ee, apu, ika nekaspapi pegker amajtamsattajia taji”, tusar tiaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Tusa tuinakai Jesús nita jiin antintak: “Atum nekaspapita tau asarum, atumsha yamaika pegker jastarma”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Nu tusa tamauwaik pegker jasaruiti. Tumawarmatai Jesús nitan chicharuk: “Chikichkiksha ujakairpa”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Takai nitasha, ayu tusar jiintrar wenak etse etserkauwa nu nugkanmagka wearuiti. ");
INSERT INTO hubNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Nu jiinki wenaig, shuar iwanch egkemtuamu asa chichachun Jesúsan itarawaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Tura itarim Jesús iwanch shuaran egkemtuan jiiki ajapruawaiti, turam shuar chichachusha shir chichakuiti. Tumamtai nui matsatu wainkar enentai jearcharuiti. Tura chichainak: “Israel shuar ainatika chikichkiksha aitka pegker amajmauka wainchauwaitji”, tusa tiaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Turasha fariseo aina chichainak: “Juka iwanchjai takáwai, tuma asa iwanchin apuriya nuna senchirijai iwanchnaka jiiki utsawai”, tusa tiaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Nuiya juaki Jesús nina unuinatairi ainajai ashi yaakat ainanam pachinkar wearuiti. Tumainai chiki chikichik jea judío aina iruuntainam chicham pegkeran Yuus tu inamui tusa jintinkartau. Turak jatai ja ainan, najaimau ainancha ashi pegker amaju. ");
INSERT INTO hubNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Imatika Jesús pegker amajkai, chikich shuar ainasha winasha yainkati tusar winina. Tumainakai Jesús nuna shuaran wainainak ovejan kuitamin atsurmau urukmaina numamtuk jaina asamtai wait anenmain iiya. ");
INSERT INTO hubNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Tumak Jesús nina unuinatairi ainan chicharuk: “Nekas tajarme, shuar Yuusa chichamen antuk umiak Yuusa inamtairin waimain ainaka nukapeti. Turasha shuar Yuusa chichamen etserin ainaka ishichkiti. ");
INSERT INTO hubNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Tuma asamtai atumsha chichaman etserkatin ainan etegkar akupkati tusarum, Yuus aujsatarma”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jesús nina unuinatairi ainan doce ajakarua nuna untsuk irumar shuar iwanch egkemtuamu aina, ja aina, tura najaimau ainasha pegker amajsatarma tusa senchimtikauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Jesús nina unuinatairi atinan etegkauwa nuna naarigka ju ainawai: Simón chikich naari Pedro, Andrés nusha Simónkan yachi Jacob, Juan mai Zebedeo uchiri, ");
INSERT INTO hubNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe, Bartolomé, Tomás, tura Mateo, apu kuitri atinan juu jakua nu, chikich Alfeo uchiri nusha Jacob, Tadeo, ");
INSERT INTO hubNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simón nina nugken agkanmamtikattsa chichamru jakua nu, Judas Iscariote Jesúska tu maatarma tusa shuar ainajai chichaman umirkauwa nujaimak ajakaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jesús nina unuinatairi doce ainan ishimuk: “Shuar judíochu aina matsatmaunmagka weerpa, tura Samaria nugkanmasha weerpa. ");
INSERT INTO hubNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Antsu Israel shuar aina oveja megkarauwa numamtuk aantar yujaina nui wetaarma. ");
INSERT INTO hubNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Tumakrum Yuus ju nugkanam inamratnuka tsawan ashi jeayi tusarum chicharkartuktarma. ");
INSERT INTO hubNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Tura shuar leprajai ja aina, chikich jatai jainasha pegker amajsatarma. Tura jakau ainasha inantratarma, turakrum iwanch shuaran egkemtuasha jiiki utsagtarma. Nu turakrumsha atumka akirkatarma tusarmeka tiirpa, atumnaka wina senchirun amajrume, turamu asarum antrarmek pegker amajsatarma. ");
INSERT INTO hubNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Weakrumsha kuit, tura orosha jukirpa, ");
INSERT INTO hubNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","wampatcha, ushukrutaisha, zapatosha jukirpa, antsu chikichik nugkustinchik jukitarma. Yutaisha atum yuatnuka jukirpa, shuar atum yaigtatrum nu amastatrume. ");
INSERT INTO hubNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Chikichik yaaktanam jeaakrumsha, shuar atumnasha shir aneas jurammain aina eaktarma, tumarum nuig pujusrum jintintaatarma. ");
INSERT INTO hubNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Tura atumin shuar nina jeen juramkai wayakrumsha shir aneastarma, tumakrum Yuus atumnasha yainmakarti tusarum titarma. ");
INSERT INTO hubNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Tura atum nui wayaarum, chicham timaurmin antuk uminakka shir pujusartin ainawai. Turasha atum timaurmin umitan nakitainakka shir pujuschartin ainawai. ");
INSERT INTO hubNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Tura atum yaaktanam tumachkurmesha jea wayarum, chicham pegkera nu etserkurmin nakitramainak anturtamainachkaigka, atumin naween tsetse irunu peatrarum akaketkarum ikuktaarma. Nuka atumka ika chichamka ujamaitiatrum atum nakitrau asaakrumin, Yuus waittan suramsatnaitrume, takurum turatarma. ");
INSERT INTO hubNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nekas tajarme, nu yaaktanam tuma matsatunka Yuus waitat sukartamu tsawan jeaakai, yaunchuk Sodomanmaya tura Gomorranmayajai shuaran waittan susauwa nuna nagkasau senchi waittan susartinaiti”. ");
INSERT INTO hubNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Aneartarma, atumnaka oveja uun yawa kajen matsatmaunam akupmaina numamtuk, shuar pegkerchau aina matsatmaunam akupeajrume. Turasha atumka shir umintsarum yujakrum ashammain igkuakrumsha ashamtsuk, chikich ainaka pegkerchaunam ikkarmeka chichartsuk takamtak yujastaarma. ");
INSERT INTO hubNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Kuitammamatarma, shuar aina achirmak juramkiar apu ainanam surutmakartatui, turutmawarmatai judío aina iruuntairin waitkarmasartatui. ");
INSERT INTO hubNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Atum wina nemartuinatirminka apu judío aina, tura judíochu aina matsatmaunam juramkiartatui, turutmawarmatai nita emtin wina pachittsarum chicharkartuktatrume. ");
INSERT INTO hubNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Tura atumin apu aina matsatmaunam chicham nekarami tusar juramkiar umatmainakaisha, ¿apuncha warituk aujsataj? tuka enentaimsairpa. Atumin apu aina ininmakai, chichamainnaka Yuus yainmaktatrume. ");
INSERT INTO hubNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Tura atum chichaktatrum nuka atumkeka chichakchattarme. Antsu atumnaka Wakan Pegkera nu chichamtikramkattarme. ");
INSERT INTO hubNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Tsawan jeakaigka maawarti tusar shuar aina yachin anagka suriartinaiti. Tura uchirtin ainasha uchirinak juki suriartinaiti, tura apartin ainasha nina aparinak shuarmawar maitin ainawai. ");
INSERT INTO hubNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Atum wina nemartin ainatirminka shuar aina ashi kajertamiartinaiti, turasha imatika kajertamainakaisha, atsantrarum winak nakarutirmeka uwemratin ainarme. ");
INSERT INTO hubNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Shuar aina atumin yaaktanam chicharkartu pujarmin waitkarmainakaisha, yaja chikich yaaktanam weakrum ikuktaarma. Wii ju nugkanam shuarnum akinawaitaj nunaka atum Israel shuar ainan yaaktariya nui pachinkarum wina, chichamur ashi etserkarum umiatsruminig taatnaitjai. Wii taja nuka nekasaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Unuinataigka unuikartinan nagkasauka amaitsui, tura patrónkrin takarnusha patrónkrin nagkasauka amaitsui. ");
INSERT INTO hubNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Unuinataigka unuimaksha unuikartinan nagkasauka unuimamaitsui. Tumasag patrónkri inataisha patrónkrin nagkasauka amaitsui. Tuma asamtai wina pachitas chichainak: Jesúska Beelzebú senchirijai takáwai tusa aujmattruinakka, atumnasha aujmattramainak tiartinaiti”. ");
INSERT INTO hubNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Atumnaksha aujmattramainakaisha shuar ainaka ashamkairpa. Chikichkiksha warí takasmauwa nuka Yuus nekamtiktsuk inaimainka atsawai. Nui atumka chikich aina chichaman awantramainakaisha, urukakug turuta tusarmeka tiirpa. Chikichik warí takasmauka uukrika Yuus nekamtiktsuk inaimainchau asamtai, tsawan jeamtaigka pegkerchau takasa uuka inaisamunka chikich ainasha ashi nekaawartinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Nui wii atumin Yuusnaun uukan jintintiajrum nuka, chikich shuar ainasha nekaawarti tusarum ashi antamunam etseratarma. ");
INSERT INTO hubNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Mantamainakaisha ashamkairpa. Atumin iyashi mainaksha wakanminka maachartinaiti. Antsu atum jakaakrumin Yuus waittan suramuk jinum chumpirmamtai, waitmainaitrum nu ashammain ainarme. ");
INSERT INTO hubNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Atumka chikichik kuitjai, jimar chigki ju ainarme. Turasha nunasha Yuuska wainkau asa kajinmattsuk aneakui. ");
INSERT INTO hubNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","31","Turasha atumka chigki nagkasau ainarme, tumau asaakrumin Yuuska kajinmattramtsurme. Atumin wichi ainasha Yuus ashi nekapmarmauwaiti, tuma asamtai atumka sapijma pujuirpa”. ");
INSERT INTO hubNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Nunasha tajarme, chikichik shuarkesha natsaamtsuk wina pachitas chichaak: Wika Jesúsnauwaitjai tusa etserunka, wisha turusnak wina Apar nayaimpinam puja nunasha nu shuaran pachisan ujaktinaitjai. ");
INSERT INTO hubNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Antsu shuar wina pachitas chichatan nakita asa chichaak: Wika Jesúsnauchuitjai turutunka wisha turusnak wina Apar nayaimpinam puja nunasha uurkatnaitjai”. ");
INSERT INTO hubNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Atumka winaka ashi nugkanam maanitsuk agkan pujusarti tusantsuk taawaitti tusarmeka turutirpa. Wika ashi nugkanam maanitsuk agkan pujusarti tusanka taachuitjai. Antsu wika, wina nemartin aina chikich shuar aina nakitruinajai wina pachitas chichainak nukap kajernaiyak maani matsamtin asamtai taawaitjai. ");
INSERT INTO hubNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Tumainak shuar aina wina nemartuinakai, nina uchirinak kajertinaiti, tura nuwasha nina nukurinak wina nemartau asamtai kajertinaiti, tura nuwasha tsatsarin shuarmatnaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Tura atumnasha wina nemartuinatirminka, atumi pataig shuarmatmawartin ainawai. ");
INSERT INTO hubNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Shuar wina nemartayat wii wakeramua nuna umitsuk, ayatik apari, nukuri, uchiri, nawantri aina wakeramunak anturak umiruka, wina nemartinka amaitsui. ");
INSERT INTO hubNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Tura shuar waitaksha katsuntas pujus nemartutan nakitaka wina nemartinka amaitsui. ");
INSERT INTO hubNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Shuar mantuawarai tusa ashamak, wina nemartutan inaisaru ainaka uwemrachartin ainawai. ");
INSERT INTO hubNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Atumin juramainaka winasha juruinawai, tura wina juruinaksha wina akuptukua nunasha juinawai. ");
INSERT INTO hubNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Shuar Yuusa chichamen etserin asa, chichaman etserkattsa winaun juasha, Yuusa chichamen etserin juamunka nisha jukitnaiti. Tura shuar pegker asamtai juasha, nu shuar pegker juamurinka jukitnaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Shuar wina nemartin, chikich shuar nusha wina nemartinaitiat imanisa eme anentsa enentaimtushtainak entsan shikik suaka nisha pegker suam atinaiti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jesús nina unuinatairi ainan jintinta umik, yaakat ainanam chicharkartuktasa jiinki weakai nina unuinatairi ainasha wearuiti. ");
INSERT INTO hubNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Tuma Cristo chicharkartak wemaun, Juansha achikam cárcelnum pujus antuku. Tuma nina unuinatairin jimaran untsuk ");
INSERT INTO hubNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","chicharuk: Werum Jesús iniastarma: “¿Yuus uwemtikartinan akupkatnaitjai tusa tina nu amekaitam? ¿Amechuitkumnaka chikichak nakastataj?” tusarum titarma tusa akupkau. Tu akattram Juankan unuinatairi ainasha Jesúsan tariar Juan timaunka imatiksag iniasaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Tusa iniam nekaattsa kaunkau ainan Jesús chicharuk: “Waketkitarma tumarum atum wainkamu, tura antukmausha Juan ujaktarma. ");
INSERT INTO hubNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Wainmachu, shutua shutua wekain, leprajai jancha, empekuncha ashi pegker amajmayi. Tura jakauncha inanmayi, tura kuitrinchau ainan chicham pegkeran jintinmayi tusarum ujaktarma. ");
INSERT INTO hubNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Wii takaj juna wainainak nekaspapita turutainaka shir aneasartin ainawai tusa timayi tusam Juan ujaktarma”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Tusa tama waketramtai, nui shuar matsatainan Juankan pachis ujakartasa iniak: ¿Wari wainkattsarmea aya nugkanmagsha wemiarme? ¿Saak nase umpuam muchitna numamtuk, shuar pachimar enentaimnuk wainkattsarum wemiarum? ");
INSERT INTO hubNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Tumachkurmesha shuar pegkeran nugkur pujau wainkattsarmek wemiarum? Turasha shuar imanun nugkuaruka apu pujutainam puju ainawai. ");
INSERT INTO hubNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Turasha wari wainkattsarmea wemiarme? ¿Yuusa chichamen etsernuk wainkattsarum wemiarum? Nuka nekasaiti, Yuusa chichamen etserin chikichan nagkasau Juan imakratin tutaiya nu wainkattsarum wuwaitrume. ");
INSERT INTO hubNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Yuusa chichamen Juankan pachis: “Ame jeakmin nekaspapita tiarti tusa shuar ainan emtika ujakti tusan, wina chichamrun etsernun akupeajai”, tu armauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Nekasa tajarme: Ju nugka juigka Yuusa chichamen etserin Juankan nagkasauka chikichik shuarkesha atsawai. Turasha shuar imanchau Yuusa inamtairin nayaimpinam puja nuka, Juan nugkanam puja nuna nagkasauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Juan imakratin taa chicharkartujakua nui nagkama yamaikisha nukap shuar Yuusan nemarkattsa wakeraka irunui, turasha nita senchirijaig Yuusa inamtairin wayaattsa wakeruinawai. ");
INSERT INTO hubNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","14","Tuma asamtai yaunchuk Yuusa chichamen etserin aina, tura chicham umiktin Moisés aarmaunam Cristo taatnun etseruk, Yuusa chichamen etserin Elías tutai taatnaiti, tina nunaka Juan imakratnun taku tawai. ¿Atumka nuka nekaspapita tatsurmek? ");
INSERT INTO hubNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","nita antutairi aramuka wii taja nuna antukarti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Nuna tusa Jesús shuar entsanam maatan nakitaina asarmatai, shir antumtikattsa wakera asa, chichaak: Chikichik uchi amikri yujattamaun chicharuk: Jui kaunkatarma. ");
INSERT INTO hubNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Tumarum ‘umpuutain wii umpuakai jantsematarma tusa umpunmasha jantsemacharuiti. Tumawarmatai wake mesemar enentaimtikartumainan kantamruan awaniartajai tusa kantamramsha útcharuiti’. Atumka numamtuk ashi nakitarme. ");
INSERT INTO hubNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Juan imakratna nu jiistatin yuinamun, tura umuinamunmasha iruttsuk pujakaisha, iwanch egkemtuamu asa ani pujawai tusarum tarume. ");
INSERT INTO hubNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Tura shuarnum wii akinan pujusan jiistatin ipatainakai wekaasan irutkaisha, ayatik wekaas yu wekawai, nigka shuar tunau aina, tura Romanmaya apu kuitri atinan yarumin ainan amikriyaiti turutrume. Nunaka Yuus nekawai, tura asa Juan takasmau ainan, wii takasmau ainancha mai pegkerak iiyawai”, tusa Jesús tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Nuna tina inaiyak, Jesús nu yaaktanam shuar turumainchau ainan nukap iwainakuiti. Nuna turakaisha shuar ainaka nita tunaurin inaiyakka Yuusnaka nemarkacharuiti. Tumainakai chichaak: ");
INSERT INTO hubNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Corazínnumia, tura Betsaidanmaya shuar ainatirminka wina nekaspapita turutchau asaakrumin, Yuus atumnaka waittan amastin asamtai wait anentajrume. Antsu Sidónnum, Tironam shuar matsamajakarua nuka yaunchuk wainkachmaun Yuus atumin iwainturma imatika nitasha iwaintamuitkugka, tunaurin inaiyainak uwemmain jakaru ainawai. ");
INSERT INTO hubNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Turasha Yuus waitat sukartamu tsawan jeakaigka Corazínnumia ainatirmeka, Betsaidanmaya ainajai ima senchi waitat jukitin ainarme. Tura Tironmaya, Sidónnumiajai imatikagka waittanka jukichartinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Capernaúmnumia ainata, ¿atum enentaimsarmeka ika jakrisha nayaimpinam juam artinaitji tarumek? Atsaa, atumka chikich shuar tunau aina jinaawaru waitu matsata nui juam atinaitrume. Sodomanam shuar matsamajakarua nuisha atumin yaunchuksha wainkachmaun yamai iwainaj imatiksarik iwainakmauwaitkaigka, nita ainasha yamaiya juisha matsammain ainawai. ");
INSERT INTO hubNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Atumka Yuus waittan sukartamu tsawan jeakaigka Sodomanmaya shuar aina nagkasarum waittaka jukiartin ainarme”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Jesús nina unuinatairi ainan, chicharkartuktarma tusa ishiakmau aina kaunkarmatai, nina apari Yuusan emematuk: “Apaachi, ametme nayaimpinam matsamin ainan, tura nugka matsamin ainancha apurimka. Amincha nekaspapita turamaina asarmatai, apaachi, maake tajame. Ame shuar yacha ainaka nekamtiktsuk, shuar imanchauch aina nu etegkram, ame chichamrumsha antumtikme. ");
INSERT INTO hubNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Apaachi, nu wakera asaakmin, anis atii”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Nuna pachis aparin ememati inaiyak nina unuinatairi ainan chicharuk: “Wina aparka nina senchirin ashi surus, niya imanuk amajtus akuptukuiti. Nui nina uchiri asan, chikichkiksha wainainatsaig wina aparnaka shir wainjai. Tumasag aparsha winaka waitui. Tura wii aparun nekamtikmau asar, wina nemartin ainaka aparnasha nekainawai. ");
INSERT INTO hubNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Atum atumin senchirinig pegker ainan takaakun Yuusan pegker enentaimtiksatjai tusarum takákrum pimpiki pujautirmeka, wini winitarma wii ayamtiksatjarme. ");
INSERT INTO hubNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Atum wii tajarum nu imatiksarmek umiakrum wii jintintamajrum nusha unuimakrumka, shir enentaimsarum pujustinaitrume. Wiyaitjai kakakchaunka, iturchatnasha umamkesan nepetnunka. ");
INSERT INTO hubNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Tumau asan atum umiktinan chichaman amajrum nuka yupichu umimain ainarme”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ayamtai tsawantin Jesús nina unuinatairi ainajai trigo arakmau uturar jinta nu nagkamatai asamtai wea, tumai nina unuinatairi aina tsukamainak trigon kupikar jukiar, neren akarar yurkuta wena. ");
INSERT INTO hubNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Tumainan fariseo aina wainkar Jesúsan chicharainak: “Iisiana, ayamtai tsawantinka takantsashti timau aisha, ¿urukamtai ame unuinatairam ainasha nuna umitskesha takainawa?” tusa tiaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","4","Tusa tuinakai Jesús ayak: “¿Atumka yaunchuk ina apachri David tsukamak, tura nijai tsanig yujasha tsukamainakai, Yuus ememattasa iruuntai jeanam wayaa pan pegkermamtikamu ima sacerdote yutainak, ni juki yuak, shuar nijai yujainancha ayurkauwa nuka aujsachuk ainarum? ");
INSERT INTO hubNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Moisés aarmauwa nui: Sacerdote Yuus ememattasa iruuntai jeanam takau ainaka ayamtai tsawan tsawara aigkisha ayamainatsui, turasha nuka pegkeraiti ta nuka atumka aneaktsurmek? ");
INSERT INTO hubNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Tuma asamtai tajarme, Yuus ememattasa iruuntai jea nuna nagkasauka chikichkiti atum umirmainka. ");
INSERT INTO hubNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Juna pachis yaunchuk aarmau chichaak: ‘Wina eme anentrakrum tagku aina main ainarum nunaka wakeratsjai. Antsu wika chikich ainasha wait anentratarma tusan wakerajai’. Tusa tina nu nekaa akurmeka, chikich ainasha pegkerchaun takachuka antrarmeka aujmatmaitsurme. ");
INSERT INTO hubNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Tuma asamtai wika shuarnum akina asan, ayamtai tsawantincha takamainaitjai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Nuna tusa timatai nina unuinatairi aina Jesúsjai judío aina iruuntai jeanam wayawaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Nu jeanam shuar uweje chuiru pujau, tuma asamtai fariseo ainasha Jesúsan kajeraina asar, warittig timatai Jesúska tunaun takáwai timi tusar: “¿Ayamtai tsawan tsawara aisha jasha pegker amajmainkait?” tusar tuina. ");
INSERT INTO hubNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Tuinakai Jesús nitan chicharuk: “¿Atum ainatirmesha ayamtai tsawan aig, ovejarum waanam egkemaa jiinkitajkama waitu pujakaisha iturmainaitrum, werum jiimainchaukaitrum? ");
INSERT INTO hubNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Turasha shuaraiti ovejan nagkasauka, nui ayamtai tsawan tsawara aigkisha, ni waitu pujauka wait anenmainaiti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Tusa shuar uweje chuirun chicharuk: “¡Kunturam nakuekta!” tusa tinaiti. Tama nisha kunturin nakuekma chikich uwejejai metek pegker jasuiti. ");
INSERT INTO hubNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Turamtai fariseo aina wainkar aa jiintraruiti, tuma itursarik chicham umirka Jesús maawaj tusar chichaina. ");
INSERT INTO hubNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Nu tusa chichainamun Jesús nekaa, tuma iruuntramunam pujau jinki weakai nina unuinatairi ainasha wearuiti. Tumainai nukap shuar aina nitasha Jesús weamunam wearuiti. Tura Jesúska ja ainan pegker amaju. ");
INSERT INTO hubNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Tura pegker amajsamuri ainan akateak: “Chikich ainaka nu pegker amajtusmayi tusarmeka ujakairpa”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Nunaka yaunchuk Yuusa chichamen etserin Isaías aarmauwa nuna umia asa tinaiti. Nuka tu armauwaiti: ");
INSERT INTO hubNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Juwaiti nekas wina nemartinan wii etegkawaitaj nuka, ninak aneajai, tumakun shir enentaimsan pujajai. Nina Wakan Pegkeran susatnaitjai, turam shuar ainanam chicham pegkera nuna ashi shuar judíochu ainatirmesha uwemmain ainarme, antsu atum nekaspapita tachautirmeka tsawan jeakai waitat jukitin ainarme tusa ni etserkatnaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Nigka chicham ainanka jianaituka wekaichatnaiti, tura jintanmagsha wajan anturtuktarma tusagka chicharkartuka wekaichatnaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Nigka shuar iwáku pujus tunaun takakaisha, tsawan jeakai waittan susatin asa, pachitsuk inaiyawai, tura shuar wina nekaspapita turutainachuncha nekaspapita tiarti tusa nakawai. Ni pegkeran takak, ashi shuar ainan apuri asa, tunau ainanka nepetkatnaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Shuar judíochu ainasha nuna wainainak nekaspapi incha ni uwemtikramainaita tiartinaiti”. ");
INSERT INTO hubNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Jesús nukap shuar ja ainan pegker amajeakai, shuar iwanch egkemtuamu asa chichachun, tura wainmachuncha ejétuina. Turam Jesús pegker amaju. ");
INSERT INTO hubNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Nuna pegker amajsarmatai, shuar aina wainkar kuntuts enentaimraru ainawai. Tuma chichainak: “Juka Cristo David weantunam akinawa nutsukaitti”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Fariseo aina nuna nekaawar chichainak: “Ju shuarka iwanch Beelzebú tutaiya nujai takáwai. Tuma asa nuna senchirijai nigka iwanch shuaran egkemtuancha jiiyawai”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Nuna tuinakai Jesúska nita chichainamunka nekau asa chichaak: “Shuar aina nuu nugkanmag pujuinayat, nitak maani pujuinakka, megkamain ainawai. ");
INSERT INTO hubNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Tura Satanás nina senchirin wina surak, shuaran iwanch egkemtua ainan jiirati turutkugka, nigki ninurinka tupannaimainaiti, tumak nina senchirigka megkamainaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Wika atum wina chichartakrum: Beelzebú senchirijai iwanch shuaran egkemtuan jiiyawai turutu asaakrumin, junaka tajarme. Wina Beelzebú nina senchirin suraisha ¿atumin unuinatairi ainancha iwanchin jiirti tusasha yaa senchirincha suawa? Tusan takai atum wina airkurum: Yuus nitanka senchirin suawai. Tusarum takurmeka: Atum wina chichartakrum Beelzebú senchirijai iwanchnaka jiiyawai turutrum nuka waitrarme. ");
INSERT INTO hubNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Wii iwanch shuaran egkemtuan Yuusa senchirijai jiyaj nunaka, yamaika Yuus inamuapi tusa nekawarti tusan turajai. ");
INSERT INTO hubNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Chikichik shuar kakaram jeen kuitamuk, waitinam kuchiin takus wajakaisha ¿itursaya kasasha wayasha warírincha jurumainaita? Nuna juruktaj takugka, yama nagkamchakka nu shuar jeen kuitamuk wajaun jigkar ajuan nui jurumainaiti. Nuna turutskeka jurumaitsui. ");
INSERT INTO hubNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Shuar wina anturtachuka wina shuarmatui, tumasag wii Yuusa chichamen etsermauncha yaintainachuka iwanchin yainawai”, tusa Jesús tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","32","“Tura junasha tajarme: Yuus shuar ainan tunaurincha, tura pegkerchau chichamurincha ashi tsagkuratnaiti, tura wii shuarnum akinawaitaj nunaksha aujmattrus pegkerchaun chichartuku ainaka tsagkuram artinaiti. Turasha Wakan Pegkeran nakitainak nina aujmatas pegkerchau chicharkau ainaka yamaiya juisha, tura atakea nuisha tsagkuram achartinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Númi pegkeran nerenka tumasag pegkernak nerenaiti. Tura númi pegkerchaun nerencha tumasag pegkerchaunak nerenaiti. Nui númi ainaka nina nerenig nekanui. ");
INSERT INTO hubNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Atumsha imau tunaurtin ainatirmesha, ¿itursarmea chikich ainasha chicham pegkersha ujamainaitrume? Shuarka ni enentaimmaun chichauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Shuar pegkerka pegkernumag enentaimu asa, chichaaksha pegkernak chichauwaiti. Tura shuar pegkerchausha pegkerchaunak enentaimu asa, chichaaksha pegkerchaunak chichauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Tuma asamtai tsawan jeakaigka, Yuus ashi shuar ainan akankatnaiti. Tura chiki chikichik ni aantra chichakmaurinka imatiksag etserkartinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Tuma asamtai shuar pegkeran chichaa jakunka ameka waittaka jukishtatme. Antsu shuar chicham pegkerchaun chichaa jakunka, ameka waitat jukittame”, tusa titinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Nuna tusa Jesús timatai, fariseo aina, tura chicham umiktinan jintinkartin ainajai chichainak: “Jintinkartina, wainchatai chikichik iwainakta isha wainkarmi”, tusar tiaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Nuna tuinakai Jesús chichaak: “Juka shuar pegkerchau, nekaspapita tichau asar, wainchatai iwainakta turutainawai. Turasha nita wakeramunka turashtatjai. Antsu Yuusa chichamen etserin Jonás urukawaita numamtuk nitancha iwaintukartatjai. ");
INSERT INTO hubNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jonásan nayantsanmaya namak uun wainchatai kujaruiti. Turam nuna ampujen tres tsawan, tura tres káshi pujusuiti. Wisha tumasnak ju nugka jui shuarnum akinawaitaj nuna, shuar aina mantuawarmatai ikuntsan, tres tsawan, tura tres káshi tepestinaitjai. ");
INSERT INTO hubNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Yuus Jonásan Nínive nugkanam chicharkartukta tusa akupkauwaiti. Turam Jonás Yuusa chichamen etserkai, Nínivenmaya shuar ainaka tunau takatan inaiyainak uwemkaru ainawai. Tumawaru asar Yuus nina chichamen umiku ainan yarumkai, Nínivenmaya shuar jinaawaru ainasha nantarartinaiti. Tumawar wii Jonásan nagkasaun pujusan, chicharmasha umikchau asaakrumin, atumin pachitmasar chichainak: Nitaka tunau ainawai tusa turamiartinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Apu nawantri Yuusan pachis etsermaun nekaattsa, Salomónkan jeashtanmaya tarinaiti. Tumamtai Salomón tu awai tusa ujakam pujutin yapajiawaiti. Turasha wii Salomónkan nagkasaun pujusan chicharmasha umikchau asaakrumin, Yuus ni chichamen umiku ainan yarumkai, nu apu nawantri jakau nantaki atumin pachitmas chichaak: Nitaka tunaun takau ainawai, tusa turamtinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Iwanch shuarnum egketu jiiki ajapamka, ni pujumainan eak aya nugkanmag weawai. ");
INSERT INTO hubNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Tuma ni pujumainan wainkach, ‘wii yaunchuk pujuyaj nuig waketkin pujustajai’, tu enentaimui. Tusa waketki ni pujujakmaurin tarua iikma, nu shuarka jea japimkar shir iwaaramua numamtuk pujaun wainui. ");
INSERT INTO hubNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Tuma waketki siete iwanch nina nagkasau pegkerchau ainan yaruak wakettruki egkemtawai. Turam shuarka yaunchuk pegkerchau ajakmaun nu senchi pegkerchau jawai. Atumsha ju shuar imatika iwanch chumpimtuamua numamtuk ainarme”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesús nuna tusa jintinkartak pujai, Jesúsan nukuri, nina yachi ainajai Jesúsan wainkartasa kaunkaruiti. Tuma kaunkar aag wajasaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Tuma irunai chikich shuar aina Jesúsan chicharuk: “Ame nuku, yatsum ainajai waitmakartasa tawar aa irunui”, tusar ujaina. ");
INSERT INTO hubNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","49","Tusa ujam Jesús chichaak: “¿Wina nukursha, tura wina yatsur ainasha yaita?” Nuna tusa ni unuinatairi ainan: “Wina yatsur, tura wina nukur ainaka ju ainawai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Nuiyasha nuna tusa inaiyak: “Shuar wina apar wakeramun uminaka, wina yatsur, wina umaar tura wina nukur ainawai”, tusa Jesús tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Nu tsawantaik Jesús jea pujau jiinki, kuchanam jeaa nuna yantamen ekemsauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Tumamtai shuar aina iruuntraruiti. Tumawarmatai Jesús kanunam egkemar ajapeen nanamas shuar ainaka yaikminam iruuntrarmatai jintintu. ");
INSERT INTO hubNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Turak arakan arakmaun pachis jintinkartutan nagkama chichaak: “Arakan arakmau arakan jigkain juki, ajariin nagkimak ikuuttsa wuwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Tuma araka jigkain ajariin nagkimak ikuknaiti. Nu arakan jigkai nagkimam jintanam kakekaruiti, tumanka chigki kautak amukuiti. ");
INSERT INTO hubNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Araka jigkai nugka kayarnunam ujumak kakekaruiti, nu tumawaruka wári tsapainiaruiti. Turasha nugka nukapchau asamtai, ");
INSERT INTO hubNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","etsa etsantuk kagkape init achimrachu asamtai, aesak ijinawaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Tura chikich ainaka jagki iruunmaunam kakekaruiti, tuma nusha tsapainiartatmaun jagki tsapainak yutuam jinawaruiti. Turamu asar arakka nerekcharuiti. ");
INSERT INTO hubNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Antsu nugka pegkernum kakekaruka shir tsapainiar, chikichik jigkai ainayat nukap nerekaruiti. Chikichka treinta jigkain, tura chikichka sesentan, tura chikichka cien jigkain nerekaruiti”. ");
INSERT INTO hubNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","“Nita antutairi aramuka wii taja nuna antukarti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Nuna tusa jintinkartua ashimkamtai, nina unuinatairi aina ininak: “Apuru, ¿urukamtai arakan arakmau pachismesha shir nekamainchausha jintinkartame?” tusar tuina. ");
INSERT INTO hubNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Tusa tuinakai Jesús nina unuinatairi ainan chicharuk: “Atumnaka Yuus inammaurin pachisan timaj nunasha nekamtikramattsa wakerutmarme. Turasha chikich ainaka nuna takumpapi tawa tusarka nekamain ainatsui. ");
INSERT INTO hubNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Wina chichamrun nekaspapita tusa antaunka nu nukap jintintattajai, turasha wina chichamrun antutan nakitanka ni antukmaurinka kajinmamtikittajai. ");
INSERT INTO hubNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Nui nitanka arakan arakmaun pachisan ayatik jintinjai, nitaka wii pegker takámun wainainaksha, wainmachua numamtuk jainawai. Tura antuinaksha, empekua numamtuk jainawai, tumaina asar nunapi taku tawa tusar nekainatsui. ");
INSERT INTO hubNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Juka yaunchuk Yuusa chichamen etserin Isaías timauwa nu imanisag uminui, ni juna pachis tinaiti: ‘Atumka antutka antuktinaitrume, turasha nekashtinaitrume, waintasha wainkatnaitrume, tumakrumsha nekaspapita tichatnaitrume. ");
INSERT INTO hubNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ju shuar aina juka iturchat enentaimaina asar, nekaspapita tichamnau nekapenawai. Tumaina asar ujamsha shir antuinatsui. Tura jiisha epetkamua numamtin ainawai. Nuna tumainaksha Yuus pegkermamtikramatji tusa tutanka nakitainawai, tumainak nita wakeramun takainawai’. ");
INSERT INTO hubNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","17","Nekas tajarme, yaunchuk Yuusa chichamen etseru jakarua nuka yamai, tura shuar pegker ajakaru ainasha atum waintrum juna wainkartasa wakerujakaru ainawai. Imatika wakeruinaksha wainkacharu ainawai, antutnasha yamai atum antarum juna antukartasa senchi wakeru jakaru ainawai. Tumainaksha nitaka ju chichamnaka antukcharuiti. Atumka nita wina waitkachmaunam waitaina asarum, tura chichaamusha antuku asarum shir aneasrum pujustarma”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Yamaika shir nekaatarma, arakan arakmau taja nunaka juna takun tajai. ");
INSERT INTO hubNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Araka jigkai jinta kakekaun chigki kautak amuku timaj nunaka shuar Yuus tu inamui tamaun antukiat enentaimtutsuk pujaun iwanch tarua, Yuusa chichame antukmaurin kajinmamtika nuna takun timajai. ");
INSERT INTO hubNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","21","Arakan jigkai nugka kayarnunam kakekaruka wári tsapainiartatmaun, etsa etsantuk arakan kagkape, nugka nukapchau asamtai, init achimrachun etsa sukua aeskau timaj nunaka, ujumak shuar yama chichaman antamuik wakerus umiktasa enentaimu waitainak, tura iturchattri aramu asar, Yuusa chichame antukmaurinka pachitsuk inaiyainak, yaunchuk puju jakmaun waketruina nuna takun timajai. ");
INSERT INTO hubNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Araka jigkai jagki iruunmaunam kakekaru timaj nunasha, shuar aina Yuusa chichamenka antuinayat, nitak tsanumainak wiakchamartsuk shir pujumainaitti tu enentaimaina asar, wiakchamattsar ima senchi wakeruina nuna takun timajai. Ashi ju nugkanmaya warí aina nu chicham pegker antukmaunka emegkawai. Tuma asamtai Yuusa chichamenka enentaimtuinatsui. ");
INSERT INTO hubNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Antsu araka jigkai nugka pegkernum kakekaru jinutsuk, ashi imanisag shir tsapainiaru asar, pegker nerekaru timaj nunaka, ujumak shuar Yuusa chichamen shir antukar, nekaspapita tusar iturchat aruinamsha umamkesar nepetak pujuina nuna takun timajai. Ujumak shuar cien jigkai, tura chikich sesenta, tura chikichka treinta jigkai nerekarua numamtincha ainawai”, tusa Jesús tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesús junasha jintinkartak: “Yuus inammauka chikichik shuar nina inatairi ainan araka jigkai pegkeran ajanam araktarma, tusa ishiakam arakmakua numamtinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Tura ishiakam arakmak umikar kanuinak matsatai, chikichik shuar ni shuari ajanam wayaa nupa pegkerchau ainan araawaiti, tura araa ikuak wuwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Turamu ai, arakan arakmauka nekachu asa, pachitsuk pujai trigo aramusha tsapainaiti, tuma nerektasa nere shikapchich nagkamnai, nupa pegkerchau aramusha tsapainaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Tuma nupa pegkerchau tsapaimtai takau aina patrónkrin ujakartasa wearuiti. Tuma jeariar ujainak: ‘Apu, ame araka jigkai araktarma tusam sukartusmam nuka pegker armayi. ¿Turasha nupa pegkerchausha itursag tsapaini?’ ");
INSERT INTO hubNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Tutai chichaak: ‘Aunka chikichik shuar aitkayi’, tusa tinaiti. Tusa tama inatai aina chichainak: ‘¿Turasha amesha uruk enentaimmea, ii ainatincha nupa pegkerchau ainan weri takariarti tatsumek?’ ");
INSERT INTO hubNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","30","Tutai chichaak: ‘Atsaa, nekas inaisatarma, nupa takamka trigosha uwenmainaiti, tuma asamtai trigojai metek tsakakmatai, trigo tsamak uminkamtai, takau ainan chikichan ishiaktajai. Turam nita nupa pegkerchau ainanka uwerar irumrar epeatnun jigkaawarti, antsu trigonka juukar trigo irumtainam irumrarti’ ”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesús junasha jintinkartak: “Yuus shuarnum inammauka mostaza jigkaiya numamtinaiti. Shuar nuna jigkain ajariin araawai. ");
INSERT INTO hubNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Mostaza jigkaiya nuka chikich araka jigkai aina nu shikapchiti. Tumauwaitiat araamka tsapai, chikich númi aina nujai metek jawai. Iman jasmatai nui chigki ainasha nuna kanawen pasugmak jurena numamtuk Yuuscha ishichik shuarnum inamki nukap amajeawai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jesús junasha jintinkartak: “Yuus shuarnum inammauka nuwa pankan najanuk levadura tutain ishichik ajunta pachimar uuntan wampushmamtikna numamtuk, Yuuscha ishichik shuarnum inamki nukap amajeawai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jesúska shuar ainan jintinkugka, aujmatmaun pachis tuke jinti jakuiti. Tura aujmatmaun pachis tutsukka jintinkartu jakchauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Jesús tu jintinkartu jakua nunaka Yuusa chichamen etserin aarua nuna umiak turawaiti. Nuka tu aarmauwaiti: “Yuus nugkan yama najanaigkisha nekaachmaun jintinkartaksha, aujmatmaun pachisan tuke jintinkartitnaitjai”. ");
INSERT INTO hubNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Nuna tusa jinti jintinkartakua, shuar ainan awakear ikuak, nisha waketki jea jeamtai, nina unuinatairi aina jeariaruiti. Tumawar chicharainak: “Unuikartina, ame nupa pegkerchau árak arakmaunam tsapakuiti tusam timam nusha, ¿wari pachisam takumea timame? Shir ujakratkata, isha nekaami”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Tama Jesús nitan chicharuk: “Araka jigkain pegkeran arakmau timaj nunaka, wii shuarnum akinawaitaj nuna wiki tumamkun timajai. ");
INSERT INTO hubNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Tura ajan pachisan timaj nunaka ashi shuar nugkanmaya ainan takun timajai. Araka jigkai pegker timaj nunaka shuar Yuusan nemarainan takun timajai. Antsu nupa pegkerchau timaj nunaka iwanchin umirin ainan pachisan takun timajai. ");
INSERT INTO hubNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Shuar nupa pegkerchaun ara timaj nunaka iwanchin takun timajai. Arak nereku juwamu timaj nunaka atak nugka mesera nagkanmaunam shuar pegker aina pegkerchau ainajai etegkatna nuna takun timajai. Tura araka juu aina timaj nunaka nayaimpinmaya shuar ainan wii ishiaktinaitaj nuna takun timajai. ");
INSERT INTO hubNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","41","Atak nugka mesera nagkanmaunam nayaimpinmaya shuar ainan wii ishiaktinaitjai, turam nupa pegkerchau etegkra uwera yaruakar jinum aestaiya numamtuk, chikichan pegkerchau amajkau ainan, tura tunaun takau ainajai etegkratnaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Tura tunau takau ainaka ji kajinchauwa nui chumpimsar, senchi waitainak útainak nainka takertu matsamtinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Turasha Yuus wakeramurinak umirkau ainaka nayaimpinam Yuusan pujutairiya nui, nita iyashi ainanka yapajiakar shir winchamtin etsa imainchauwa iman jasar, nayaimpinmaya shuar aina nujai metek iruuntrar, shir nakuru matsamtinaiti. Nita antutairi aramuka wii taja nuna antukarti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Yuus shuarnum inammauka oro aimkamu juki nugkanam yutua uukmauwa numamtinaiti. Chikichik shuar nu uukmaun wainak juki, ekesag chikichnaka ujatsuk yutua ikuak waketki pujus, nu nugkan oro uukmaurin ima senchi wakera asa, nuna sumaktasa ashi warí ninu ainanka suruk, ni nugka ima senchi wakeramun sumakua numamtinaiti”. ");
INSERT INTO hubNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Yuus shuarnum inammauka chikichik shuar warín surin nayantsanmaya kayan pegkeran akikan wainkattsa yáki imannasha takaka tusa, ");
INSERT INTO hubNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","ea wekaas, chikichik shuar imanun takakun wainak ikuak, jeen jea ashi ni waríri ainanka surur ashimak perla tutain sumakua numamtinaiti”. ");
INSERT INTO hubNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Shuar redjai namakramin aina kuchanam ajugkar, ashi chikich namak yuchatai ainan irumar achina numamtuk, Yuuscha shuarnumsha inamui. ");
INSERT INTO hubNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Namakan achirar japi japinakua kukar ajuiniar, nui iruunturar namak yutai ainan yarumainak namak yuchatai ainanka entsa ataksha utsain ainawai. ");
INSERT INTO hubNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Numamtuk Yuuscha tsawan nugka mesera nagkanmau jeakaigka, nayaimpinmaya shuar ainan, shuar pegker ainan, tura shuar tunaun takau ainajai irumar ikaankati tusa ashi nugkanam ishiaktinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Nuna juur tunau ainanka ji kajinchaunam tuke waitu matsamtin arti tusa utsawartinaiti. Turawaram senchi waitainak útu matsamtinaiti”, tusa Jesús tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Nuna pachis uja ujakua nitan iniak: “¿Atumsha wii taja nusha shirak antukuram?” tusa iniam nita aimainak: “Ee, apu, shir antukji”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Tuinakai nitan chicharuk: “Chikichik shuar chicham umiktinan, Moisés aarua nuna jintinkartin, tura wii Yuus inammaurin pachisan etseraj nuna shir antuk, nekaspapita tusa nemartauka jeentin warí yaunchuk ikaankamurin, tura chikich warí yamai ikaankamurijai chikichan sumaina numamtuketi”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Nu pachis jintinkartamun Jesús ashimak, ");
INSERT INTO hubNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ni pujusa tsakarmaunam wuwaiti. Tuma nui jeaa, jea judío aina iruuntairin jintinkartutan nagkamawaiti. Tuma nui chicham pegkeran nita nekachmaun jintinkartakai, shuar aina enentai jearcharuiti. Tumawar chichainak: “¿Tuiyana unuimaru asampa wainchatai ainancha iwainawa? ");
INSERT INTO hubNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿José tablan takauwa nuna uchirinchukait, nukurisha Maríachukait, tura Santiago, José, Simón, Judas aina nuna yachiya nuchaukait? ");
INSERT INTO hubNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Tura nina umai ainasha jui matsataisha, ¿tuiyanak nisha junasha imatiksasha nekawa?” tusa nitak tunaiyaina. ");
INSERT INTO hubNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Tusa anturtan nakitaina. Turam Jesús chichaak: “Shuar Yuusa chichamen etserin nina nugkeen, tura nina jeen pujus etserkaigka, anturchau ainawai. Turasha chikich nugkanmagka shir aneas anturkartasa wakerin ainawai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Nuna tusa chikishcha wainkarti tusa, iwainaka takámun wainainaksha nekaspapi senchirtinaita tuinachmau asa, nukapka wainchatai ainanka iwainakchauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Nu uwítin Herodes, Galileanmaya ainan apuri nu Jesúsan pachis chichaina asarmatai, nuna antuk ");
INSERT INTO hubNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","nina inatairi ainan chicharuk: “Nuka Juan imakratin mantamnawa nu senchirtin jas nantakin asa, wainchatai ainancha iwainawai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","5","Nunaka Juan maatarma tusa ni timaunam Juankan maawaru asarmatai tinaiti. Yaunchuk nina yachi Felipen nuwen Herodías naartinan juruki nuatak pujakai, Juan Herodesan chicharuk: “Apu, amina yatsumi nuwe jurukmeka nuatkam pujumaitsume”, tusa tinaiti. Tusa tama Herodes kajek maattsa wakerayat, shuar aina Juanka Yuusnumian chichaawai tuina asarmatai, nitan ashamak, ayatik cárcelnum egkearum cadenajai jigkartaarma tusa inaisauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Tura pujai apu Herodes akinamu tsawaarmatai, Herodíasan nawantri irar aina iruuntramunam ajapeen wajan jantsemkai, Herodes nu nuwa jantsemmaurin senchi wakerukuiti. ");
INSERT INTO hubNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Tura asa chicharuk: “Ashi ame wakeramu seatkumnaka imatiksanak amastajme”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Tusa tama Herodíasa nawantrisha nukurin iniasu, tura nina nukuri akattram Herodesan jeari chicharuk: “Juan imakratna nuna muuke tsupikam platonam egkeram surusta”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Nu tama apu Herodes wake meseku tumayat: “Nekas amastajai ame wakeramu seatkumnaka” tusa tamaun, irar ainasha ashi antukaru asarmatai, ");
INSERT INTO hubNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","suntar ainan chicharuk: “Werum Juan cárcelnum achikam egketa nuna muuke tsupirkarum susatarma”, tusa ishiakuiti. Turamu asar Juankan muuknum tsupikaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Turawar Juankan muuken platonam egkerar juki itantaruiti. Tura Herodíasa nawantrin susaru, turam juki nukurin susauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Turawarmatai Juankan unuinatairi aina taruawar iyashi jukiar, ikusar ikuinak Jesúsan weriar ujakaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jesús nuna nekaamtai, jiinkiar kanunam egkemrar nugka agkantunam wearuiti. Tumawaru ai shuar ainasha nekaawar, amaigkar ni chicharkartamun antukartasa yaaktan ikuinak kukar wearuiti. ");
INSERT INTO hubNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jesús kanunmaya jiinkama nukap shuar iruunar ainan wainkauwaiti. Tura wainak nitan wait anentrauwaiti. Tura jan ikaankarmataisha pegker amajsauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Etsa aka asamtai, Jesúsan unuinatairi aina Jesúsan jeariar chicharainak: “Etsa akawai, juigka ika chikichik shuarkesha pujachmaunam kaunkaji. Tuma asamtai shuarka ishiakta, yaaktanam jeattak jea matsata ai jeawar, nita yuatnun sumakarti”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Tusa tuinakai Jesús nina unuinatairi ainan chicharuk: “Nitaka wemain ainatsui, atum nita yuatnuka susatarma”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Takai nita chichainak: “Juigka atsurtamji, ayatik cinco pan, nuiya jimarchik namak arutramji”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Tusa tuinakai Jesús nitan chicharuk: “Nu wina surustarma”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Takai ejétim shuar ainan chirichrinam matsas, cinco pan aun, tura jimar namakan juki wajas, nayaimpinmani pagkai aparin maaketi, tusa, pankan puur ni unuinatairi ainan tinamkauwaiti. Turawaram shuar ainan nita tinamkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Turawaram ashi yuawar shir aneasaruiti, tura ampintrau aina doce chagkinnum aimkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Nuna yuawaruka nuwa aina, tura uchi ainajai nekapmatsuk, aya aishmag uun ainak nekapmaram, cinco mil shuar ajakuiti. ");
INSERT INTO hubNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Nuna tura nui nigka shuar ainajai chichaak pujak, nina unuinatairi ainan chicharuk: “Atumka botenam egkemarum emkarum kucha amain katigtarma tusa nitanka akupkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Shuar ainan ashi akatar ikuak”, Jesúska aparin aujsattsa, nigki nainnum wakauwaiti. Tuma nui pujus aparin aujuk pujai etsa akaikinaiti. Tumamtaisha nuig pujau. ");
INSERT INTO hubNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Botenam egkemrar kucha ajapeen wena, tuma wenai nase senchi nasentuk umpuamu asa, entsa tsukatuk botenka ukaittak amaju. ");
INSERT INTO hubNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Tsawastatuk jai, imaniamunam pachitkau Jesúscha entsanam wekaas wea. ");
INSERT INTO hubNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Tumattamaun nina unuinatairi aina wainkaru, turasha nekacharu. Tumaina asar wakaniti tusar ashamkaru. Tumainak senchi chichainak: “Juka wakaniti”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Nuna tusa tuinakai Jesús nitan chicharuk: “Wiyaitjai, ashamrukairpa”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Tusa takai Pedro chichaak: “Apuru, nekas ametkumka, winasha entsanam wekasata turutta, wisha wekaasan ame wajam nui taatjai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Tusa takai Jesús chicharuk: “Takumka winita”, tusa tinaiti. Nu tamauwaik Pedrosha botenmaya jiinki entsa najama wekaas, Jesús wajamunam jeantasa wea. ");
INSERT INTO hubNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Turasha nase senchi nasentuk entsa tsukatmamtikmaun iikma ashamkau. Tuma entsanam wayak: “¡Apuru, achirkata!” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Tusa takai Jesús uwejnum achik chicharuk: “¡Winaka imanisam enentaimturtsumek! ¿Urukamtai nekaspapita turuttsume?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Jesús Pedrojai botenam egkemramtai nasegka megkaakauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Tumamtai nina unuinatairi aina botenam chumpiruka Jesúsan tikishmatrar chicharainak: “Ameka nekas Yuusa uchiriyaitme”, tusa tiaru ainawai. ");
INSERT INTO hubNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Kuchanam katigkar nugka Genesaretnum jeawaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Tumainan wainkar nu yaaktanmagka chichaman ashi etseraruiti, turawarmatai ja ainan Jesús pujamunam ashi ikaankaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Turawar chichainak: “Inaikartusta amina nugkutairmin yantamegsha antigkarmi”, tusa tuina. Tura shuar nina nugkutairin antigkuka ashi pegker jasaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Jerusalénnumia fariseo aina, tura chicham umiktinan unuikartin ainasha Jesúsan taruawaruiti. Tumawar ininak: ");
INSERT INTO hubNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“¿Urukamtai amina unuinatairam ainasha yaunchuk ina uuntri aina umijakmauwa nuna metek uminatsua? ¿Urukamtai nitasha ikijmatskesha yuinawa?” tusar tuina. ");
INSERT INTO hubNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Tuinakai Jesús nitan iniak: “¿Urukamtai atumsha chicham umiktarma Yuus timauwa nuke umitskesha atum wakeramuksha takarme? ");
INSERT INTO hubNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Yuusa chichame tu aarmauwaiti: ‘Atumi apari, tura atumi nukurisha chichame umirkatarma. Nina aparin tura nukurincha pegkerchaun chicharuka aya mantamnati’. ");
INSERT INTO hubNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Turasha atumka chichaakrum: Shuarka nina aparinka, tura nina nukurinkisha ‘wika yaimaitsujrume, ashi wina aruta junaka Yuusan anajmatamjai tusa tumainaiti’, tusarum tarume. ");
INSERT INTO hubNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Chikichkiksha nuna tusa tauka nina aparinka, tura nukurinkisha yaimaitsui tarume. Atumka nu tusa takurum chicham umiktarma Yuus turammauwa nuka imanchau umarum inaiyakrum, atumin uuntri chichamea nuke umiarme. ");
INSERT INTO hubNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Tsanumin ainata! Yuusa chichamen etserin Isaías atumin pachitmas aak: ");
INSERT INTO hubNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Ju shuar aina juka winaka ayatik nita chichamenig emematruinawai, turasha winaka enentaimturainatsui. ");
INSERT INTO hubNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Tumaina asar, aantar wina pachittsar emematjai tusa turutainawai. Nita jintinkartuina nunasha chikich ainan ju umiktarma tusa tu jakarua nunak jintinkartuinawai’ ”, tusa Jesús tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jesús nuna tina shuar ainan untsuk chicharuk: “Jusha antukrum shir nekaatarma. ");
INSERT INTO hubNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Shuara weneen waya nuka shuarnaka Yuus iismaka pegkerchauka amajtsui. Antsu katsekmat aina nu, tura pegkerchau chichat aina nuwaiti shuaran pegkerchau amajuka”, tusa tinaiti ");
INSERT INTO hubNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Timatai nina unuinatairi aina Jesúsan jeariar chicharainak: “¿Fariseo aina ame tame nuna antukar kajekara nusha amesha nekamek?” tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Tusa tuinakai Jesús nitan chicharuk: “Nitaka wina aparnauchu asar, árak uwer ashi kagkapeejai ajaptaiya numamtuk amajam artinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Tuma asamtai pachikairpa. Nitaka wainmachua numamtin ainawai. Shuar wainmachu chikich wainmachun jintan inaktustasa weakka, mai metek waanam iyaamainaiti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Tusa takai Pedro Jesúsan chicharuk: “Nu pachisam tame nusha wari takumea tame shir ujakratkata”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Tutai Jesús nitan chicharuk: “¿Atumsha wii taja nu nekatsrumek? ");
INSERT INTO hubNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Ashi wenenam wayaka ampujnum egkemar nagkamaki wakenam wetainam ajapna nuka nekatsrumek? ");
INSERT INTO hubNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Turasha chicham wenenmani jina nu enentainmaya jiinui, nuwaiti shuaran tunau amajuka. ");
INSERT INTO hubNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Magkartuta nu, chikichan nuwe takata nu, nuwa agkantujai tsanirmata nu, kasamta nu, waitruta nu, katsekmata nusha tura pegkerchau enentaimtai aina nuka enentainmaya jinnaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Shuaran tunau amajuka nu ainawai, turasha ikijmarum yuatarma timauwa nu tumatsuk yuamusha shuarnaka pegkerchauka amajeatsui”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jesús nina unuinatairi ainajai nuiya jinki Tiro nugkanam, Sidón nugkanmasha wuwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Nui jeamtai, Canaánnumia chikichik nuwa nui pujau asa, Jesúsan untsukmaikia wea. Tumak chicharuk: “Apu David weantu uchiriya, winasha wait anentrurta. Wina nawantur iwanch egkemtuamu asa, senchi waitawai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Tusa tamasha Jesúska aikchau. Tumakai Jesúsa unuinatairi aina chichainak: “Ina ukurin winis untsu untsumkauwa winajama, aujsam akupkata”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Tusa tuinakai Jesús nuwan chicharuk: “Winaka Yuuska Israel shuar aina oveja megkarauwa numamtuk pujuina nui akuptukuiti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Nuna takaisha nuwaka amainag tikishmatar chicharuk: “Apuru, nawantur iwanch jiiki ajapruata”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Nu tusa tama Jesús ayak: “Uchi pankan yua atanki yawa suamuka pegkerchauwaiti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Tusa tama ni chichaak: “Apuru, nuka nekasaiti. Turasha pegke yawaksha mesa wakenam wajasar, uchi pankan tsaik akakeamun yuwa jama”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Tusa tutai Jesús ayak: “Umaaru, yajau winaka nekaspapita tusam enentaimturamja imanisam enentaimturam nui, ame wakeram nuka imanisag uminkattawai”, tusa tinaiti. Nuna taig nina nawantrisha pegker jasuiti. ");
INSERT INTO hubNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jesús nina unuinatairi ainajai kucha Galilea yantamen nagkamaki wea weakua nainnum wakar nui ekeemsaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Tumawarmatai nukap shuar ja ainan, shutua shutua wekain ainan, uweje chuiru ainan, wainmachu ainan, chichachu ainan, chikich jatajai ja ainancha Jesús pujamunam nukap ikatkaruiti. Turawar Jesúsa naween ayanas matsasaruiti, turawarmatai ja ainanka ashi pegker amajsauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Turawaram shuar chichachu ainasha chichaina, uweje chuiru ainasha pegker jasaru. Shutua shutua wekain ainasha shir wekaina, wainmachu ainasha wainmaina. Tumainan shuar aina wainkar enentai jearcharuiti. Tumawar “Israel shuar ainan Yuusriya nuna nekas ememataina”. ");
INSERT INTO hubNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Tumawarmatai Jesús nina unuinatairi ainan untsuk irumar chicharuk: “Ju shuar aina juna wait anentainajai. Tres tsawan wijai tuke matsatainawai, turasha yumaintri atsurainawai. Nita jeenka jeatsuk jinta shimus tsukai jinawai tau asan, yurumkan ayurtsukka ishimmaitsujai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Takai nina unuinatairi aina chichainak: “Turasha ¿chikichik shuarkesha atsamunam kaunkaj nusha tuiyag imajin shuar ayurmaincha yutaisha jumainaita?” tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Tusa tuinakai Jesús nitan chicharuk: “¿Urutma panka takakrume?” tusa tinaiti. Tusa takai nina unuinatairi aina chichainak: “Cuatro pan, tura nuiya ishichik namakjai takakji”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Tusa tuinakai: “Shuar aina akantrarum nugka matsastaarma, tusa inaiyak ");
INSERT INTO hubNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","pankan namakjai juki wajas, aparin aujas maake tina, nuna puur nina unuinatairi ainan chicharuk: Atum nui shuar aina tinamkatarma tusa nitan susauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Turam nita jukiar tinamkaram ashi yuawar shir aneasaruiti. Tura ampintrau ainancha siete chagkinnum aimkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Nuna yuawaruka nuwa aina, uchi ainajai nekapmatsuk aya aishmag uun ainak nekapmaram cuatro mil shuar ajakaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Nuna tura Jesús shuar ainan akatar ikuak nina unuinatairi ainajai botenam egkemar Magdala nugkanam wuwaiti”. ");
INSERT INTO hubNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Fariseo aina saduceo ainajai Jesúsan wainkartasa jeariaruiti. Tura tsanua nekapsartasa chicharainak: “Nayaimpinmaya ii wainkachmau iwainakta”, tusar tuina. ");
INSERT INTO hubNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Turasha nitan chicharuk: “Atumka pegker kintamkai chichaakrum: ‘Kashinka pegker tsawan atatui’ tinu ainarme. ");
INSERT INTO hubNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Antsu káshikmasrum chichaakrum: ‘Yamaika yumi yutuktatui, yuragkim mukusa jasai’, tusarum tinu ainarme. Tsanumin ainata, nayaim iisrum, tsawan tu atatui tusarum nekauwaitiatrum, Yuuscha juisha winasha urukamtaig akuptukuit nuka nekatsrume. ");
INSERT INTO hubNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ju shuar pegkerchau, chichaman metek umichu aina wainchatai chikichik iwainkartukta tusar tuinawai. Turasha wika chikich yamaram iwainamunka iwaintutsuk Jonás urukawaita tumasnak nitanka iwaintuktatjai”, tusa nitanka ikuknaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Jesúsa unuinatairi aina Jesúsjai kucha amain wenak pankan kajinmatkiaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Turawarmatai Jesús nitan chicharuk: “Fariseo aina saduceo ainajai nita pan pachimtairi aina nu shir enentaimrarum iistarma”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Nuna tusa takai nina unuinatairi aina chichainak: “Nunaka ii pan jukichaj nui turamji”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Nu tuinakai Jesús antuk chichaak: “¿Urukamtai yutainmasha ima enentaimainarme? ¿Urukamtai winasha enentaimturtsurme? ");
INSERT INTO hubNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Wii cinco pankan tsaikan, cinco mil shuaran ayuramiaj nuka aneaktsurmek? ¿Urutma chagkinnuma aimkamiarme? ");
INSERT INTO hubNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Nuiyasha wii siete pankan tsaikan, cuatro mil shuaran ayuramiaj nusha aneaktsurmek? ¿Urutma chagkinnuma aimkamiarme? ");
INSERT INTO hubNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Urukamtai atumsha shir enentaimsarmesha antukchamarme? Wika nita pankrin takun tatsujai, antsu ‘fariseo aina saduceo ainajai nita jintinkartutairi aina nu shir enentaimrarum iistarma takun nunaka tajai’ ”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Nuna tusa timatai Jesús nekas pankan tutsuk fariseo aina saduceo ainajai jintinkartutairin pachis taku timaun nekaawaru ainawai. ");
INSERT INTO hubNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jesús Cesarea nugka Filiposnum a nui jeaa nina unuinatairi ainan chicharuk: “¿Shuar ainasha wii shuarnum akinawaitaj junasha wari turutainawa?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Tusa takai nita chichainak: “Chikich ainaka auka Juan imakratin maamua nuwaiti turamainawai. Chikich chichainak: ‘Auka Elíastsukaitti turamainawai’. Tura chikich ainaka ‘auka Jeremíastsukaitti turamainawai, antsu nuchauwaitkugka yaunchuk Yuusa chichamen etserin ajakarua nutsukaitti’ ”, tusa turamainawai tuina. ");
INSERT INTO hubNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Tusa tuinakai nitan chicharuk: “Tura atumsha winasha ¿yaiti turutrumea?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Nuna tusa takai Simón Pedro ayak: “Ameka Cristowaitme, Yuus tuke pujuwa nuna uchiriyaitme”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Tusa tama Jesús nina chicharuk: “Simónka, Jonása uchiriya ameka shir aneasam pujusta. Ame chichakum nuka amek enentaimsamka chichakchaume. Antsu Yuus nayaimpinam puja nu chichamtikramkayi. ");
INSERT INTO hubNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Wisha amina ujaktajme: Ameka yamaika Pedro atatme. Nu Pedro ta nuka kaya taku tawai. Ameka Cristo, Yuusa uchiriyaitme turutainanka nu kayanam ekenir jeamkamua numamtuk, winau amajsartatjai. Tura nuka jaksha tuke jakashtinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Yuusan takatri ju nugka jui a nunaka amina inaitustajme. Turamu asaakmin ame ju nugka jui wina aparu chichame jintiakmin, shuar nuna antuk, nekaspapita tusa tunaurin etsertumakmataigka, Yuuscha yamaika amina tunaurminka tsagkurtamrayi titinaitme. Antsu shuar tunau takatan inaitan nakitanka Yuuscha tsagkuurashtinaiti tusam titinaitme”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Nuna tusa nina unuinatairi ainan chicharuk: Wina pachittsarmeka, auka Cristowaiti tusarmeka, chikichik shuarkesha ujakairpa tusa akattrauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Nuna tusa Jesús nina unuinatairi ainan chicharuk: “Jerusalénnum weartatji, winaka ai jeawakrin, judío apuri aina, sacerdote apuri ainasha, chicham umiktinan jintinkartin ainajai ashi nakitruina asar, senchi waitkarsar mantuawartatui. Nuna turutawarmataisha wika tres tsawan tepesan nantaktatjai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Tusa takai Pedro Jesúsan akanak juki chicharuk: “¿Urukamtai amesha tusha enentaimme? Yuuska aminka turam atii tusagka tsagkamrammaitsujama”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Nu tusa tama Pedro Satanása numamtuk chichaa asamtai, ayanmata chicharuk: “Satanása, wini tantam tu wajatsuk wetá, ameka ayatik utujimtikrukam awake enentaimtikrurtasam wakerame. Tuma asam Yuusjai metekka enentaimtsume, antsu shuar enentaimtai enentaimme”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Nuna tina Jesús nina unuinatairi ainan chicharuk: “Wina nemartuktaj tautirmeka atum wakeramuka inaiyakrum nemartuktarma, tumakrum shuar aina mantamattsa wakerutmainakaisha, wii wakeramua nuka kashi kashinig takastarma. ");
INSERT INTO hubNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Shuar wii wakeramun takainan maattsa wakeruinawai. Tuma asamtai shuar wii wakeramun takatan nakitainawai. Shuar tumau ainaka Yuusjai tuke pujuschartin ainawai. Turasha shuar wii wakeramun takau ainan maataj tamaun nekauwaitiat wii wakeramun takau ainaka, Yuusjai tuke pujusartin ainawai. ");
INSERT INTO hubNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Shuar ashi nugkanmaya warí ainan ashi ninu amajeaksha, ni jakaigka nina waríriya nuka ninka pegkesha uwemtikmaitsui. Antsu nina waríriya nuke waittanmagka umamainaiti. Shuar waittsaij tusa uwemrattsa akikmamainka pegke atsawai. ");
INSERT INTO hubNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Shuarnum wii akinawaitaj nuna, wina aparu senchirijai tura nayaimpinmaya shuar ainajai nugkanam taakun chiki chikichik shuarnaka nita takasmaurin iirsan, ni pegkeran takasunka pujut nagkanchaun susartinaitjai. Tura tunaun takasunka waitat nagkanchaun susartinaitjai. ");
INSERT INTO hubNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nekasan tajarme: Atum jui iruntrum juiyatiram eke jatsuk pujakrumka, shuarnum wii akinawaitaj nuna winau ainanam inamrattsan winamu waitkatin ainarme”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Tura seis tsawan pujus, Jesús Pedron, Jacobon, ni yachi Juanjai juki nitajai nain yaki wajakmaunam wearuiti. ");
INSERT INTO hubNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Nui matsatmaunam Jesús nitasha wainainamunam yapajina. Yapigka winchamtin etsaya numamtuk jasuiti, tura jaanchrisha shir puju tsaaptin jasuiti. ");
INSERT INTO hubNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Iman jasun Elías Moisésjai, Jesúsan taruawar aujainan nita wainkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Nuna Pedro wainak Jesúsan chicharuk: “Apuru, juigka yajau pujatsji. Ame wakerakminka tres aakan aakmaktajai. Chikichik aminu, chikich Moisésnau, tura chikichka Elíasnau atii”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Nuna tusa Pedro chichaak wajai, yuragkim yakiya juarki nitanka amuawaiti. Turam irunai Yuus yuragminmaya chichaak: “Wina uchir nekas anetairka, wii etegkamua nuka juwaiti, nigki anturkatarma” tusa tamaun antukaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Nu tamaun antuinamuik nina unuinatairi aina ashamkar nugka tikishmarar tsuntsumawaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Tumawarmatai Jesús nitan jeaari antiak: “Ashamtsuk wajaktarma”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Tama nitasha wajakiar iikma Jesús nigki wajattamaun wainkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Nuna tuma Jesús nainnumia akak, nina unuinatairi ainan chicharuk: “Atum yamai wainkaurum nu pachisrumka shuarnum wii akinawaitaj nuna mantuawarmatai nantatsaigka, chikichik shuarkesha ujakairpa”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Nuna timatai nina unuinatairi aina Jesúsan ininak: “¿Urukamtai chicham umiktinan jintinkartin ainasha Elías yama nagkamchakka taatnaiti tusasha tuinawa?” tusa iniasaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Tusa iniam Jesús nitan chicharuk: “Nuka nekasaiti, Elías niya emak taa ashi umiktinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Turasha wii tajarme: Elíaska taawaiti, tumanak nekacharu asar, nita wakeruinamun uminak pegkerchau amajkaruiti. Nujai metek wisha chikichnum suruka waitkam atinaitjai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Nuna takai nina unuinatairi tres aina nijai wekaina: Jesúska Juan imakratnun pachis takumpa tawa tusar enentaimraruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Jesús nainnumia juaki shuar irunmaunam jeawaiti, tumattamaun chikichik shuar jeari Jesúsan tikishmatar chicharuk: ");
INSERT INTO hubNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Apu, wina uchirun iwanch egkemtur waitkarta nu wait anentrata. Iwanch yama egkemtakka ashammain amajeawai, imatikak jinumsha jiataj tinayi, tura entsanmasha ajug maataj tinayi. ");
INSERT INTO hubNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Turin asamtai amina unuinatairam ainan itarin iwanch uchin waitkarta nu jiikim ajaprutatarma tusan timajai. Tutaisha jiiktajkama tujinkarmayi”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Nu tusa tama Jesús chichaak: “¡Nekaspapita turutchau ainata! ¿Wini enentaimtan unuimararti tusancha, urutma nukapea atumjai iruuntrancha pujumainaitja?” tusa tinaiti. Nuna tusa inaiyak: “Uchiram jui itanta”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Uchi juki itantam Jesús iwanchin jiyak: “Iwanchi, ju uchika jinkim weakum ikukta”, tusa tinaiti. Nu tusa tamauwaik iwanchka jiinki weak uchin ikuknaiti. Turam uchisha pegker jasuiti. ");
INSERT INTO hubNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Nuna turamtai nina unuinatairi aina Jesúsan akanki jukiar ininak: “¿Urukamtaig isha iwanch jiiktajkamarsha tujinkamji?” tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Tusa tuinakai Jesús nitan chicharuk: “Atumka imanisrum winaka enentaimturainatsrum nui tujinkaurme. Nekas tajarme, atum ishichkiksha nekaspapita tamaurum mostaza jigkai shikapchichia annuksha arutramkaigka, au nain chicharkurum: ‘Aigka atsuk yaja chikich yantamnum wetá’, tamaka naincha tumasag megkamainaiti. Atum wina nekaspapita tamaurum arutramkaigka iturchatka atsurtammainaitrume. ");
INSERT INTO hubNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Turasha iwanchka junisrik pujusrika jiishtaiya, yurumak ijarma pujusa, Yuus aujkur jiitia”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Nuiya jiinki Galilea nugkanam wesa Jesús nina unuinatairi ainan chicharuk: “Shuarnum akinawaitaj junaka achirkar surutkartatui. ");
INSERT INTO hubNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Turutawarmatai winaka mantuawartatui. Turasha tres tsawan asan, ataksha nantaktatjai”, tusa ujakaruiti. Nuna tusa takai nuna antukar, senchi wake mesemar nekapena. ");
INSERT INTO hubNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Nuiya juakiar Jesúsjai yaakat Capernaúmnum jeawaruiti. Tuma nui jeawarmatai, Yuus emematku iruuntai jeanam shuar takau aina akiktinan kuitan yarumin aina Pedron jeariaruiti. Tura ininak: “¿Atumin jintintramnuk Yuus ememattasa iruuntai jeanam takau ainan akiktinnaka nigka akikmaktata?” tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Tama ni ayak: “Ee, ni akikmaktatui”, tusa tinaiti. Nuna tusa ikuak jea wayawaiti. Tumamtai Jesús iniak: “¿Simónka amesha uruk enentaimme? ¿Au apu ainasha tu shuarnauna kuitnasha juinawa? ¿Nitanunkek juina, turuinachkusha chikich shuar aina nunak akikmakta tusa tuina?” tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Tutai Pedro ayak: “Yajaya ainan akikmakta tuinawai”, tusa tinaiti. “Tutai Jesús chichaak: Isha nuigka Yuusnau asar akikmamaitsuji. ");
INSERT INTO hubNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Turasha nita ina kajertamkaraij, ame anzuelo jukim entsa weme nagkiata, turam namak yama nagkamchakum japiktatam nuna wene iwankam iista. Nu namaknum chikichik kuit egkemtatui. Nu kuit jukim Yuus ememattasa iruuntai jeanam weme aminusha, tura winausha akikmakam ikuuta”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Nu tamaunam Jesúsa unuinatairi aina Jesúsan jeariar chicharainak: “Ii ainaj juiyasha Yuusa inamtairiya nuisha ¿yáki apusha atinaita?” tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Tuinakai Jesús chikichik uchin untsuk juki ajapeen awajas, ");
INSERT INTO hubNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","chichaak: “Nekas tajarme, atum pegkerchau enentaimtai yapajiarum uchi chichaman umina numamtuk umiachkurmeka, Yuusan inamtairinka wayaashtin ainarme. ");
INSERT INTO hubNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Yuusan inamtairiya nui apu atinka shuar emematsuk, ju uchia jujai metek enentaimturaina nu apu artinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Shuar wina anentuk ju uchia juninchinkisha shir anentas juinaka winasha imanisag juruinawai”. ");
INSERT INTO hubNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Uchi wina nemartuktasa enentaimturaina nuna tunaun takamtikainaka, kaya uun jigkaar kuntejnum netua, nayantsa kunarin ajapeamua numamtuk artinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Turasha shuar aina tunaun takainak chikich ainancha tunaun takamtikainaka nukap irunui. Chikichan tunaun takamtika nu waittan ima senchi jukiartin ainawai. ");
INSERT INTO hubNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Tumawartin asarmatai atumin uweje, turachkurmesha atumin nawegsha tunaun takamtikramkaigka, tsupikrum ajapawa numamtuk tunau takat inaisatarma. Chikichik uwejek, tura chikichik nawek nayaimpinam shutus wayaawa numamtuk tuke pujutia nui tunaurtichu wayaamuka pegkeraiti. Nu tumachkurmeka ashi iyashmijai jinum egkemsarum waitmainaitrume. ");
INSERT INTO hubNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Tura atumin ji tunau takatnum enentaimtikramkaigka, nusha turusrumek chikichik jiimi ukuinkarum ajapawa numamtuk tunau takat inaisatarma. Chikichik jiijaig iimsa waimaina numamtuk pujut tuke atina nui tunaurtinchau wayaamuka nekas pegkeraiti. Nu turachkurmeka ji tuke ke a nui egkemsarum waitmainaitrume”, tusa Jesús tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Chikichik shuartirmeksha ju uchi shikapchich aina juka nakitrairpa. Nayaimpinmaya shuar uchin kuitamin aina nuka aparjai tuke irutkau pujuinawai. ");
INSERT INTO hubNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Shuarnum akinawaitaj nunaka shuar megkarau ainan uwemtikattsan taawaitjai. ");
INSERT INTO hubNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Chikichik shuar cien oveja aramu chikichik megkak noventinueve juakmataisha ¿urukmainaita? Chikich ainanka shir kuitamak matsas ikuak, chikichik megkaakaun eak wemainaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Tuma wekaas wainkagka, noventinueve juakua nuna nagkasau shir anenmainaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Numamtuk ina apari nayaimpinam puja nusha chikichkiksha ju shikapchich aina ju megkaakati tusagka wakeratsui”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Amina yatsum tunaun takartamkaisha, nijaig kanakim chichasta, turakum, ni tunaun takasmaurisha iwaintukam ujakta. Ame turam anturtamak tunau takatan inaiyakaigka, amina yatsum tunau inaitanam yaigkume. ");
INSERT INTO hubNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Antsu amina anturtamchakaigka, chikichik shuar turachkumsha jimarkesha untsukam nujaisha iruunturum, ni tunaun takasmauri pachisrum aujsatarma. ");
INSERT INTO hubNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Nitajai iruuntra tamasha tunaun takatan inaiyachkaigka, shuar Cristonam surumankau aina ashi iruuntramunam jukim awayaatarma, turakmin ni tunau takasmaurin pachis nitasha aujas nekapsarti. Antsu nuna anturchakaigka, chikich shuar Yuusan enentaimtichu aina nujai metek, apu kuitri atin juaji tusar shuaran tsanua yarurin aina tumau amajsarum inaisatarma. ");
INSERT INTO hubNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Nekas tajarme, atum chicham ujamaitak tunau takatan inaisacharunka wina Aparsha tsagkuurashtinaiti. Antsu atum wina aparu chichame jintiakrumin, shuar nuna antuk, nekaspapita tusa tunau takatan inaisamtaigka, yamaika amina tunaurumnaka Yuus tsagkurtamrayi tusarum titinaitrume. ");
INSERT INTO hubNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Nunasha tajarme, atum jimartirmeksha nekas suramsattawapi tu enentaimsarum ju nugka jui pujusrum, atum atsumamu pachisrum aujmaka, wina apar nayaimpinam puja nu suramsatnaitrume. ");
INSERT INTO hubNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Atum tuig jimarchiksha, tumachkurmesha tres shuartirmeksha iruuntsarum wina pachittsarum chichakrum pujutnaittrum nuigka wisha atumjai irutkau pujutnaitjai”, tusa Jesús tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Nuna tutai Pedro Jesúsan jeari iniak: “Apuru, wisha wina yatsur pegkerchau amajtakaisha ¿urutma tsagkurmainaitja, sieteya imaanik tsagkurmainaitaj?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Tusa tama Jesús ayak: “Sieteya junikka tsagkuurata tatsujme, junik tsagkuratjai tutsuk tuke tsagkursamke atá”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Nuna tusa inaiyak nina unuinatairi ainan ashi chicharuk: Yuusan inamtairiya nuka chikichik apu shuar yuwimmau asa, akirkata tusa tina nujai metekmamtinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Apun yuwimun akikmamaintri pegkesha atsurmaun shuaran juki awayawaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Turam nu shuar apun aujuk: ‘Wii akikmamainka pegke atsurtawai’, tusa tinaiti. Tusa tama apu chicharuk: ‘Antsu akikmamain atsurtamu asamtai, amina nuwem, uchiram ainancha, ashi warí aminu arutramaina nujai suruktajrume. Turam antrarum yujasrum chikich aina inaku waitkatai ataarma, tu amina yuwirmeka uminkati’, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Tusa tama, apun tikishmatar chichaak: ‘Apu, wait aneasam nuka turuttsuk ishichik tsawan nakarsata, wii amina yuwimjam nunaka ashi imatiksanak akiktatjame’, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Tusa tama apusha wait anentar: Antsu yuwiram a nunaka akirkata tichattajme, nuka junisag atii tusa inaisauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Turam jiinki weajkama shuar nina yuwimkaun wainkauwaiti. Tura suwenam achik emeta awajas chicharuk: ‘Ame yuwimram nuka wári akirkata’, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Imatram yuwimkartausha tikishmatar chicharuk: ‘Wait aneasam imatikrutsuk ishichik tsawan nakarsata, wii amina yuwimjam nunaka ashi imatiksanak akiktatjame’, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Tusa tamaitiat wait anentsuk achik juki cárcelnum pujus yuwirin akikmakti tusa egkeawaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Nu wait anenmain amajeamun wainkar chikich apun inatairi ainasha apurin jeariar ashi nita wainkamunka imatiksag ujakaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Turam apusha senchi kajek shuaran ishitak juki itantarmatai chicharuk: ‘Ameka pegkerchauwaitme, wika ame seatkumnaka wait anentran, ashi ame yuwimramunka akirkaipa tusan inaitusmajme. ");
INSERT INTO hubNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Turamu asam amesha amina yuwimramuka wii inaitusmajam aitkasmek inaimainaitam jama, ¿urukamtai aitkamsha wait anentsuksha waitkame?’ tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Nuna tusa apuka senchi kajek chichaak: ‘Jusha achikrum jukirum cárcelnum egkea ikuutaarma, nisha nui pujus wina yuwimrukma nunaka ashi akikmakti’ ”, tusa inamrauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Jesús nuna pachis jintinkartua inagnak: “Wina apar nayaimpinam puja nusha tumasag, atumi yachi enentaimtairmijai tsagkurchataika, nisha tsagkurtamrashtinaitrume”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jesús jintinkartamun umik Galileanam pujamunka ikuak, Judea nugkanam jeaa atu amain Jordánnum katigkuiti. ");
INSERT INTO hubNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Tumamtai nukap shuar ja ainan yaruakar Jesúsan utsantuawaruiti, turam ja ainancha pegker amaju. ");
INSERT INTO hubNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Nuna imatikakai fariseo aina chichainak: “Iniasar nekapsami warittig timatai chicham tsanumrurarmi tusar Jesúsan jeariaruiti. Tura ininak: ¿Shuar nuwen nagkamsasha ajapmainkait?” tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Tusa tuinakai Jesús nitan chicharuk: “Atumka Yuusa chichame aarmauwa nuka aujchauk ainarum, nuka tu aarmauwaiti: ‘Yama nagkamchakka Yuus aishmagkun nuwajai najanawaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Turamu asar shuar nuwenkugka chikichik iyashia numamtin artinaiti’. Tuma asa aparinka nukurijai ikuak nuwejaig pujustinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Nu timau asamtai shuar nuwenaka jimara tumauchauwaiti, antsu chikichkia numamtinaiti. Nui Yuus nuwemtikamu asar nuwejaigka ajapnaimain ainatsui”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Tusa takai nita chichainak: “¿Turasha urukamtai Moiséscha ajapnaiyaku aatain aar nuwan susa ikumainaiti tusasha tinaita?” tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Tusa tuinakai Jesús nitan chicharuk: “Nunaka Moiséska atum iturchat enentaimkurmin, Yuusa chichame umiachkurmin turawaiti. Turasha yama nagkamchakka tu ajakchauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Tuma asamtai wii tajarme, shuar nuwen pegkerchaun takachunak inaiyak, chikich nuwajai nuwenkugka, tunaun takak tumawai. Tumasag nuwa shir pujau ajapamujai nuwenusha tunaun takak tumawai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Nuna Jesús tusa takai, nina unuinatairi aina chichainak: “Nekas tu akaigka nuwentasha nuwenmaitsujama”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Tusa tuinakai Jesús nitan chicharuk: “Junaka ashi shuarka imatiksagka nekamain ainatsui, Yuus nekamtikmau aina nuke nekamain ainawai. ");
INSERT INTO hubNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Shuar tuke tumauk akina asa nuwenmainchausha ainawai. Tura chikich shuar kaamtikamu asar nuwenmainchausha ainawai. ‘Antsu shuar nuweentsuk pujusan Yuusa takatrinak takarsatjai tusa wakera nuwentancha nakitmainaiti’. Nunaka ni tuma tumamainaiti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Nuna tusa ashimkamtai shuar uchirtin aina uchirin yaruakar: Ame achikam amina apa Yuus aujtursata wina uchirsha pegker pujutan jukiarti tusar Jesúsan ikaatkaruiti. Imatika ikaatainakai nina unuinatairi aina chichainak: ¿Urukamtai Jesúscha imatikarme? tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Tusa tuinakai Jesús nina unuinatairi ainan chicharuk: “Tutsuk inaisatarma, atum tusarum nuig uchi awakearairpa. Ashi uchika wini winiarti. Shuar un ainasha ju uchi wina nekaspapita turutaina jumamtuk, nekaspapita turutainakaigka nitaincha Yuuska inamrattsa wakerawai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Nuna tusa inaiyak ashi uchi ainanka shir anentas chiki chikichkinak antigkuiti, nuna tura ikuak Jesús wuwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Shuar natsa Jesúsan wainkattsa tari iniak: “Jintinkartina Pegkera ¿wisha pujut nagkanchaun jukimij tusancha wari pegkerna takamainaitja?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Tusa tama Jesús ayak: “¿Urukamtai Pegkera turutme? Ima Yuusketi Pegkerka, chikich pegkerka atsawai. Ame pujut nagkanchau jukittsam wakerakmeka, Yuus umiktarma timauwa nu imatiksamek umirkata”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Tusa tama natsa chichaak: “¿Nusha tuwa tame?” tusa inimkai Jesús anaitak: “Magkartuawairpa, atumi nuwenchuka takasairpa, kasamkairpa, chikich shuarkesha chicham aantrarum tsanumrurairpa, ");
INSERT INTO hubNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","atumi apari, tura atumi nukurisha chichame umirkatarma. Turakrum atumek anenmamsarum chikich shuar ainasha anetarma”, tusa tawai tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Tusa tama natsa wiakach chichaak: “Ame tame nunaka wika uchichik ashi umikuitjai. ¿Warina nuiyasha umimainaitja?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Tusa tama Jesús chicharuk: “Ame pegker atasam wakerakmeka weme, amina waríram aina nuka ashi surakum, kuitrinchau aina nu antramek tinamkam inaisata. Nu turamka nayaimpinam shir aneasam pujustinaitme. Tuma asamtai wina nemartukta”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Nu tama natsaka shir wiakach asa, wake mesek jiinki wuwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Tumamtai Jesús nina unuinatairi ainan chicharuk: “Nekas tajarme, shuar wiakach Yuusa inamtairin wayaataj, tamauka shir iturchataiti. ");
INSERT INTO hubNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ataksha awentsanak tajarme: Camelloka auja warinka yupichu waig nagkamainaiti. Turasha shuar wiakach ainaka nayaimpinam Yuusa inamtairinka yupichu waimainka nekapenatsui”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Nuna antukar Jesúsa unuinatairi aina enentai jearcharuiti. Tumaina asar nitak chichainak: “¿Turasha yáki uwemratnaita?” tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Tuinakai Jesús nitan iis chichaak: “Shuar tujintaku turumainchaunka Yuuska ashi turumainaiti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Tusa takai Pedro Jesúsan chicharuk: “Apuru, ii ainatika inuka ashi ikuakur ame nemarkamji. ¿Isha wari pegkera jukitnaitji?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Takai Jesús ayak: “Nekasa tajarme, nu tsawan ashi yamaram amajeamu atina nuigka shuarnum akinawaitaj nuna wina ekeemtairuin ekeemsan inamkai, atum wina nemartuku ainatirmesha wijai metek doce shuaran ekeemtairi a nui Israelan uchiri doce ajakarua nuna apuri jasrum, nita kuitamkurum ekeemsatnaittrume. ");
INSERT INTO hubNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ashi shuar wina nemartuinak, yachin, umain, aparin, nukurin, uchirin, tura nugkencha ikukiaru ainaka nuna nagkasau pujut nagkanchaun jukiartinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Nu tsawantaika yamai shuar eme anentai aina nuka aantar juakartinaiti. Antsu yamaiya jui shuar eme anentsarsha iishtai aina nu ima senchi eme anentam artinaiti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Jusha Yuusa inamtairi pachisa jintinkartumain awai. Chikichik shuaran ajari un arujakuiti, nu ajanam aya uvanak árak jamaruiti. Imatikamuri tsamak juuktintri jeamtai, shuar nuna juuktin ainan eaktasa káshikmas jiinki wuwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Tuma wekas shuar nuna juutan wakeruinan wainkauwaiti. Tura chicharuk: ‘Atum juuktarma, turakrumin chikichik tsawantai akimainan kuit denario tutain amatjarme’ tusa tama, nitasha ayu tuinakai ajanam ishiakuiti. ");
INSERT INTO hubNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Nuna ishiak ikuak etsa yaki takuni ai, chikich ainancha eaktasa yaaktanam wuwaiti. Tuma yaaktanam jeawaiti. Tuma wekas shuar aantar takatsuk yujan wainkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Tura chicharuk: ‘¿Atumsha wina ajarui árak juurtumaitsurmek? Atumnasha shir akiktajrume’, tusa tinaiti. Tusa tama nitasha ayu tuinakai, nitancha chikich aina arakan juwainak yujainamunam ishiakuiti. ");
INSERT INTO hubNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Nuna ishiak pujus etsa tutupin jasa aisha wuwaiti, tuma takamainan yaruak ishiakuiti. Ataksha etsa teenta aisha, tumasag wuwaiti, tuma chikich shuar ainan yaruak nunasha ishiakuiti. ");
INSERT INTO hubNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Tura inagnamun etsa pegke akai, yaaktanam wekak wuwaiti. Tuma iima wekaas shuar takatsuk aantar pujuinan wainak chicharuk: ‘¿Urukamtai atumsha ishichkisha takatskesha etsasha akatmarme?’ tusa inia. ");
INSERT INTO hubNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Tusa ininam: ‘Chikichik shuarkesha nu takasta tusagsha inatmarcharu asarmatai ika aantra pujaji’, tusa tuina. Tuinakai: ‘Antsu atumsha wina ajarui takastarma, wii ima shir akiktajrume’ tusa takainak matsatmaunam ishiakuiti. ");
INSERT INTO hubNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Tura takaun ishiak pujus, pegke kiakai, nina inatairin takau ainan ashi iinan chicharuk: ‘Weme takau aina untsukam ashi irumrata. Turam takat inagnaktatku amajeamunam jeaunam nagkamam, akia akiakuam yama nagkamchak takatan nagkamanam inagnakta’, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Takai takau ainan untsukuiti, turam kaunkamtai inagnamunam jeaunam nagkama chiki chikichik denarion akikuiti. ");
INSERT INTO hubNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Tura káshik nagkama takasu ainaka ii ima nukap akiam atatji tu enentaimaina. Turasha nitancha chikichik denarionak akikuiti. ");
INSERT INTO hubNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Turawaram káshik nagkama takasu ainaka ajartinan kajerkaruiti. Tumawar ajartinan jeariar ");
INSERT INTO hubNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","chicharainak: ‘¿Urukamtai ii yama nagkamchaku takasmaj nuti ima nukap akikratmain aisha, takat inagnaktatku jamunam kaunkau ainajai meteksha akikratkaume? Ii ima senchi waittsau ainati ima nukap akiam amainaitji’, tusar tuina. ");
INSERT INTO hubNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Tuinakai ajartin nitan chicharuk: ‘Amikur ainata, tunatuksha akiatsjarme. Wii yama nagkamchakun chikichik denarion akiktajrume tama, atumsha ayu tinu asaakrumin turusnak akikjarme. ");
INSERT INTO hubNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Atum takasmaunam jumainaitrum nuka juwaiti, yamaika ju jukirum wetaarma. Juna atumin amaj jutiksanak shuar takat inagnamunam taawaru ainancha akiktatjai. ");
INSERT INTO hubNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Wina kuitur asamtai, wii wakeramun takamainaitjai. Wii pegker asan wait anenkartakun ashi metek akikmakai, kajeakrum nuka tu yujarme’, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Numamtuk yamai shuar eme anentai aina nuka aantar juakartinaiti. Antsu yamaiya jui shuar eme anentsarsha iishtai aina nu ima senchi eme anentam artinaiti. Nukap shuar Yuusa chichamen antuinawai, turasha uwemkartin ainaka ujumchikiti”, Jesús tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jesús Jerusalénnum wesa, nina unuinatairi ainan akanak ni mantamnatnurin pachis ujakuiti. Tura chichaak: ");
INSERT INTO hubNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Yamai ju weaj junisrik Jerusalénnum wetatji. Ai jeamunam shuarnum akinawaitaj junaka jurukiar sacerdote apuri ainanam, tura chicham umiktinan jintinkartin ainanam ejétiar surutkartatui. ");
INSERT INTO hubNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Turutawarmatai mantuawartasa emettuawar judíochu ainanam surutkartatui. Nita aina wishikriartatui, tura awattutnasha awattiartatui, ima imatikruinakua numinam achiirar mantuawartatui. Turasha tres tsawan tepesan nantaktatjai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Nuna tusa wetatmaun Zebedeo uchiri Jacob, Juan aina nuna nukuri Jesúsan jeari tikishmatrauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Turam Jesús chicharuk: “¿Warina iturtukti tusamea wakerutame?” tusa tinaiti. “Tusa tama ni chichaak: Amina pujutairmin wakam apumam pujakmesha, wina uchir jimara ju, nitasha apumtikam chikichka amina untsurumini eketrakum, chikichka menarmini eketrusta titasan wakerajme”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Tutai Jesús nitan chicharuk: “¿Atumsha wii waittsataj imanisrumkek waitmainaitrum?” tusa tinaiti. Tusa tama nita chichainak: “Ee, isha imanisrik waitmainaitji”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Tuinakai Jesús nitan chicharuk: “Wii waittsataj imanisrumek waittsatnaitrume. Turasha wika ju wina untsuruini, tura chikicha ju menaruini ekeemsati tusanka tumaitsujrume. Antsu wina apar ya ekeemsati tusag umikuita nuke ekeemsartin ainawai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Nuna tusa tu chichainamun Jesúsa unuinatairi chikich aina antukaruiti. Tumawar Jacobon Juanjai kajerkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Tumainan Jesús wainak untsuk ashi irumar chicharuk: “Atumka ju nugka juiya apu aina shuar ainan nitanu amajsar ina matsamin aina nuka nekarme. Nuna turuinak aya apuk chichamnasha anturnain ainawai. ");
INSERT INTO hubNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","27","Turasha atum ainatirmeka nuka tumashtin ainarme. Atum apu atasrum wakerakrumka, chikich umirin amainaitrume. Tura atum chichame anturtai atasrum wakerakrumka, chikich inatai amainaitrume. ");
INSERT INTO hubNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Shuarnum akinawaitaj nunaka shuar aina umirtukarti tusanka tumachuitjai. Antsu wika nita umirkun takarsattsan, nuna tumakun nita pujutincha uwemtikattsan, nita ayamrakun wii mantamnattsan taawaitjai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jericónmaya jiinki Jesús weakai nukap shuar nemarkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Nui weai jimar shuar wainmachu jinta yantamchirin eketu Jesús nagkamawai tuinamun antukar, senchi untsumainak: “Apuru, David weantu uchiriya, incha wait anenkarturta”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Tuinakai shuar nui irunu chichainak: “Imattsuk takamtak wajasua tusar imatruinamsha, nitaka nu senchi untsumainak: Apuru, David weantu uchiriya, incha wait anenkarturta”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Tuinakai Jesús wajan jimar shuaran wainmachun untsuk chicharuk: “¿Winasha uruk wait anentrurti turutrumea?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Tama nita chichainak: “Ika paan iimtikramti tusar wakeraji”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Tusa tuinakai Jesúscha nitan wait anentar jinum antigkuiti. Nu turamuik wainmachu ainaka paan iimiar, nitasha Jesúsan nemarkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jerusalénnum jeattak yaakat Betfagé Olivosan naintrijai iinias a nui Jesús jeawaiti. Tuma nina unuinatairi doce ajakarua nuiyan jimaran juki ");
INSERT INTO hubNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","chicharuk: “Au yaakat a ai wetaarma. Tumarum jeakmarum burro un jigkaam wajamunam nui burro yama tsaka ayaamas wajau wainkattarme. Nu wainkarum atia jukirum itartitarma. ");
INSERT INTO hubNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Nu turarmin chikichik shuarkesha ¿urukamtai juarme? tusa takaisha: ‘Ina apuri atsuma asamtai juaji, turasha wári itaattaji, tusarum titarma’ ”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Yuusa chichamen etserin aarmauwa nuka tu uminkauwaiti: ");
INSERT INTO hubNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“¡Yaakat Jerusalénnumia shuar ainata senchi shir aneastarma! ¡Shir aneakrum kantamatarma! ¡Atumi apuri metek umina nu tura nepetmauwa nu turasha nigka kakakchau asa, burro uchirin ekeemas winitramrum nu iistarma!” tusa titarma timauwa nu metek uminkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Takai nina unuinatairi ainasha wear, Jesús timaun imatiksag umirkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Burron uchirijai wainkar jukiar itantar, Jesús ekeemsatnun burro uchirin nita nugkutairin aitkaruiti, tura umirkam burro uchiriin ekeemsauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Tumamtai Jesúsan eme anentas iiyainak nukap shuar asar, Jesús wetinnumka jaanchrin aitaina, nuna turuinai chikich ainaka nukan tsupirar jintanmagka aitar umaina. (Nunaka ina apuri winawai, tusar emematainak turawaruiti.) ");
INSERT INTO hubNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Imatikainak ashi shuar nina emematainak senchi pampantainak: “¡Apu David weantunam akinawa nu shir anentsarmi! ¡Apu akupkam wina auka pegkeraiti! ¡Yuuscha imatiksarik emematiarmi!” tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jesús Jerusalénnum wayaamtai, nu yaaktanmaya shuar aina ashi pampantainakai chikich aina chichainak: “¿Ya asamtaiya imatruinawa?” tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Tusa tuinakai chichainak: “Juka Jesús Yuusa chichamen etserin, Nazaret Galileanam pujuwa nuwaiti”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jesús ni apari ememattasa iruuntai jeanam wayajkama, shuar tagku surin ainan, tura nuna sumau ainajaimak wainak aa jiir, kuitan yapajin aina mesarincha shitaki akakek, tura pauman surinan ekeemtairincha turusag akaketak wajan, ");
INSERT INTO hubNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","nitan chicharuk: “Yuusa chichame tu aarmauwaiti: ‘Wina jearka shuar wijai chichasartasa iruuntaiyaiti’, tusa timau aig, atumka Yuus emematku epeatin tagku chikich aina tsanuarum suakrum kuit atumnau atin jua asarum, shuar kasa matsamtaiya numamtuk amajsaurme”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Nuna tusa ishiak inaiyak nui wajaig shuar wainmachu aina tura shutua shutua wekain ainajai utsantuawaruiti. Tumawarmatai Jesús nitan ashi pegker amajsauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Sacerdote apuri aina, chicham umiktinan jintinkartin ainajai, Jesús pegker amajeamun wainkar, tura uchi shikapchich ainasha nu jeanmag wayaawar senchi untsumainak: “Apu David weantunam akinawa nu emematiarmi amajainamun antukar kajekaruiti”. ");
INSERT INTO hubNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Tumawar Jesúsan chicharainak: “¿Nuna imatrutmaina nusha antamek?” tusa tuina. Tusa tama Jesús nitan chicharuk: “Ee, antajai. ¿Atumka Yuusa chichamen juna pachis: ‘Uchi aina, tura uchi kuirach muntsuaku ainajai Yuus emematmamtikkum kantamtikme tu aarmauwa nuka aujsachukaitrum?’ ” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Nuna tusa ikuak yaakat Betanianam jeaa nui kanaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Jesús nui kanar tsawaar yaakat Jerusalénnum waketeak jinta wesa tsukaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Tumakma jinta yantamchirin númi higuera tutai wajattamaun wainak, nere atsuash tusa jeari iikma, aya nukak jas atatmaun wainak numin pegkerchau chicharuk: “Ameka tuke nerekchatnaitme tusa tamauwaik”, jaka kukar wajasuiti. ");
INSERT INTO hubNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Tumamtai nina unuinatairi aina enentai jearchar Jesúsan chicharainak: “¿Urukakua higuerasha imaniksha jakasha kukaria?” tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Tusa iniam Jesús nitan chicharuk: “Nekas tajarme, atum iturchat enentaimtsuk chikichkinmag enentaimsarum, ju nain a jusha chicharkurum: Jui atsuk nayantsanam wajaata tamaka ju higueran iturkaja jutikmainaitrume. ");
INSERT INTO hubNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ashi atum Yuus surustatuapi tu enentaimsarum aujkurmeka jukitnaitrume”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Tusa Jesús Yuus ememattasa iruuntai jeanam wayaa, nui jintinkartak pujai, sacerdote apuri aina, judío apuri ainajai iruunar jeariar, ininak: “¿Ya amincha shuar jiira iishiakta tusa turamkaiya aitkame?” tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","25","Tusa tuinakai ni chichaak: “Wisha atumin iniastajrume: ¿Ya Juan imakratnuncha akupkauwaita? ¿Yuusak akupkauwait, turachkusha shuar ainak akupkauwait? Winasha nu ujatkatarma, turutawakrumin yana chichamenia wisha jutikaja nunasha ujaktajrume”, tusa tinaiti. Nuna tusa takai utujimkar nitak chichainak: “Wari titajik, Juannaka Yuus akupkauwaiti tusa takurincha, turasha urukamtai umirkachuitrum”, tusa turamtatji. ");
INSERT INTO hubNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Tura shuar akupkauwaiti tusa takurincha, ashi ju shuar aina Juanka Yuusnumian chicharkartu jakuiti tuina asar, nita mantammain ainaji, tusa tunaiyaina. ");
INSERT INTO hubNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Nuna tusar pegke utujimkar Jesúsan jeariar chichainak: Yatsuk Juannasha akupkauwait nekatsji tusa tuina. Nuna tuinakai Jesúscha chichaak: “Antsu wisha yana chichamenia aitkaja nunaka ujakchattajrume”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Nuna tusa Jesús chichaak: Ju jintinkartamunmasha shir enentaimsarum antuktarma. Chikichik shuaran jimar uchi arujakuiti. Tuma asamtai nu shuar chikichkinak chicharuk: Uchiru, ajanam weme uva juukta tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Tusa tama nu uchi chichaak: Wika, apaachi, wechattajai tinaiti. Nuna tinaitiat atak enentaimar chichaak: Antsu nekas wetajai tusa wuwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Tumamtai uchirin chikichan chicharuk: Amesha ajanam uva juwakum wetá tinaiti. Tama nuka: Ayu, apaachi, wetajai, tusa tinu ayat wechauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Nu jimar uchin pachisan taja nuiyasha, ¿tuwa nekas pegkersha ajakuita? tusa inimsauwaiti. Tuinam nita aimainak: Uchi wechattajai tusa tinaitiat wuwa nuwaiti nekas pegkerka tusa tiaruiti. Tuinakai Jesús nitan chicharuk: “Nekas tajarme, shuar apunu atinan kuitan yarumin aina nu, tura nuwa akika takatai aina nujai, atumin nagkatamsau nekas Yuusa inamtairin waimaintrigka aruinawai. ");
INSERT INTO hubNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Juan imakratin atumin pujuti yapajiarum uwemmain ainarme turamkurmincha, atumka nekaspapi tumamain asaakriniapi turamjia tusarmeka umirkachuitrume. Atum tumarmin apunu atinan kuitan yarumin aina nu, tura nuwa shuar tuartai aina nujai, nita chichamnasha antukar nekaspapita tiaru ainawai. Turasha atumka Juanka wainkau ainayatrum, ni chichamesha anturkarum pujutrumsha yapajiachuitrume”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ju jintinkartamusha antuktarma: Chikichik shuar nina ajariin uvan arakmak shir tanishar apak, uva juuka ijuraa yumiri jukitnurincha umik, tura yaki waka árak iistintrincha watain najanawaiti. Imatika ashi shir umik, chikich shuaran eakuiti. Tura atum juka kuitamrutatarma tusa ikuak, ajartinka chikich nugkanam wuwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Tuma nigka imanai pujusag, uva juut tsawan jeaamtai, ujumak shuaran nina inatairi ainan chicharuk: Werum wina ajarui takainak matsataina nu uva winau amaina nu searum uturtitarma tusa akuprauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Turam jeartatmaun ajan kuitamin aina nu achikar, chikichnaka ayatik suimawaruiti, chikichnaka maawaruiti. Antsu chikichnaka kayajai tukurar akupkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Turawarmatai ataksha ajartin nu nukap nina inatairi ainan akuprauwaiti. Turamtaisha ajan kuitamin ainaka yama nagkamchak shuar turamun turusarag umikaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Nuna turawarmatai inagnamun nina uchirin junaka araantuspa iisartatua tusa akupkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Apari akupkam uchi winittamaun ajan kuitamin aina wainkar chichainak: “Auwaiti ju aja juna jukitnuka, maa ajapar juka inu amajsami tusa tiaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Tusar achik jukiar ajan ikumtikiar maawaruiti”, tusa Jesús jintinkartuawaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Nuna tusa Jesús sacerdote apuri ainan, judío shuara apuri ainajai iniak: ¿Atumsha uruk enentaimrumea, ajartin winaksha, ajan kuitamin tuma matsatuncha iturmainaita? tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Takai nita aimainak: “Nunaka wait anentsuk kajeg utsaamainaiti. Tura chikich takau ainan atak árak uminkamtai, juwainaksha winau amaina nunaka surustin arti tusa sumainaiti”, tusa tiaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Tuinakai Jesús nitan chicharuk: ¿Atumka chicham aarmauwa nuka ishichkisha aujsachukaitrum? Nuka tu aarmauwaiti: “Jea jeamin aina chikichik kayan nakitrar, pegkerchauwaiti tusar ajapamua nu kaya nekas ima wakerumain jasai. Nunaka apu Yuus turayi, tuma asamtai ika shir enentaimtuinaji”. ");
INSERT INTO hubNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Tuma asamtai nekas tajarme, shuar wina chichamrun antukar metek umikaru ainan Yuus ni inamtairin yarumuk, atumnaka inaitamsatnaitrume. ");
INSERT INTO hubNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Nuna kaya ukurin shuar iyakka pujamainaiti. Antsu nu kaya shuarnum iyakka nachakamainaiti, tusa Jesús tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Nuna Jesús pachis jintinkartamun sacerdote apuri aina, fariseo ainajai antukar, ina turamji tu enentaimaina. ");
INSERT INTO hubNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Tuina asar achikartasa wakeruinayat, Jesúska nekas Yuusnumian chichawai tuina asarmatai, shuar ainan ashamainak inaisaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ataksha Jesús chikichnasha pachis jintinkartak: ");
INSERT INTO hubNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Yuuska shuar aina nina chichamen metek umina nuna Apuriyaiti tusa jintinkartamuka: Chikichik apu nina uchiri nuwan nuatkai jiistamawa nujai metekmamtinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Nina inatairi ainan shuar ipaamu aina untsuktarma tusa ishiakuiti. Turasha ipaamu ainaka nuwenmaunam wetanka nakittraru ainawai. ");
INSERT INTO hubNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Nu tumawarmatai inatairi ainan ataksha akupeak: Ipaamu aina ujaktarma: ‘Nita yumainnaka ashi umikjai, wina vacar nuweram ainan, chikich tagku nuweku ainancha maatarma timajai, imatika ashi umikmau asamtai, ipamu aina nuwenmaunam taatarma, tusarum titarma’, tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Timayi tusa ujainamsha ipamu ainaka pachitsuk inaiyainak, chikichka ajariin wuwaiti, nu tumai chikichka warírin surak wuwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Tura chikich ainaka apu inatairi aina chichaman etserainak yujan achikar, sui suimainakua waitkas maawaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Nina inatairi turutam apusha kajek suntaari ainan chicharuk: Shuar pegkerchau aina nu maarum, ashi nita yaaktariya nujai ekeemakrum ikuktaarma tusa ishiakuiti. ");
INSERT INTO hubNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Nuna tura ishiak inaiyak, chikich nina inatairi ainan chicharuk: Nuwenmaunam yuatnuka ashi uminkayi. Turasha wii yaunchuk ipamu ainaka winimain ainatsui. ");
INSERT INTO hubNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Tuma asamtai yaaktanam jinta iruna nui werum, ashi shuar atum wainmauka nuwenmaunam kaunkarti tusarum ipaatarma”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Tama inatai ainasha shiakar, ashi shuar nita wainmaunka shuar pegker ainan, pegkerchau ainajaimak ipaawaruiti. Imatikamu asar shuar ainaka jeanmagka shir piakaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Tumamtai ipaamuri ainan apu iistasa wayaawaiti. Tuma wajas ii wajatu tumakma, chikichik shuar nuwenmaunam weaku nugkutain nugkutsuk wayaa eketun wainak chicharuk: ");
INSERT INTO hubNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","‘¿Urukamtai amesha nuwenmaunam nugkutai nugkutskesha juisha taume?’ tusa tinaiti. Tamasha nu shuarka aimtsuk eketu. ");
INSERT INTO hubNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Tumattamaun apu nina inatairi yurumkan mesanam ekenainan chicharuk: ‘Juka nawenam, uwejnumsha jigkaarum jukirum, aa káshia ai apujsatarma, nui pujus senchi waitak útuk, nain takertu pujuti’ tusa tinaiti. (Numamtuk shuar: Wina tunaurusha tsagkurturta tusa tichau ainaka Yuusan inamtairinka wayaachartin ainawai taku tinaiti.) ");
INSERT INTO hubNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Nukap shuaran Yuus: Wina inamtairuin wayawarti tusa untsukuiti, turasha ujumchik shuar wayawartin ainawai”, Jesús tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Nuna Jesús timatai, fariseo aina antukar, nitak kanakar iruuntraru, tumawar Jesús tsanumrumainan shuar Jesúsan iniasarti tusar tuina. ");
INSERT INTO hubNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Tumawar nui chichaman umikar nuiyanak shuaran etegkawar, tura Herodes shuar ainancha etegkawar chicharainak: “Jesús chikichik inimmau pachisrum iniastarma, turamsha warituk aimkat timatai, Jesúska tu chichawai tusar achika apu ainanam surukmi tusar akupkaruiti. Turawaram Jesúsan jeariar chicharainak: Jintinkartina, ika ame nekas pegkera nuke jintinkartakum, Yuusan jinti uruk awa nu jintinkartam nuka shir nekainaji. Shuar aina ashi metek enentaimtam nuka nekainaji. ");
INSERT INTO hubNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Nui amina iniajme: ¿Romanmaya apusha shuara kuitrin yarurna ausha akimainashit? ¿Amesha uruk enentaimmea, atsaa akimainchaukait?” tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Tuinakai Jesúska anagkeaku tamaunka nekau asa chichaak: “Tsanukratin ainata ¿urukamtai winasha tsanura nekaprustasrumsha wakerutarme? ");
INSERT INTO hubNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Kuitcha urukua apusha suarme nu inaktursatarma”, tusa tinaiti. Tutai kuit denario tutain inaktusaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Turam nuna wainak: “¿Jusha yana yapiya nakumrukmauwaita, tura jusha yana naarimpa aarmauwaita?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Tama nita chichainak: “Juka Romanmaya apu Césara nunauwaiti tusa tuina. Tuinakai Jesús nitan chicharuk: ‘Romanmaya apu Césarnauwa nuka nigki susatarma, tura Yuusnauwa nusha nigki susatarma’ ”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Nu tusa tama enentai jearchar waketainak ikukiaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Nu tsawantaik saduceo ainasha Jesúsan wainkartasa tariaruiti. Tumawar nitaka shuar jakaru aina nuka nantarchartin ainawai tusar tinu asar, Jesúsan ininak: ");
INSERT INTO hubNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Jintinkartina, Moisés chichaak: ‘Shuar nina yachi nuweena uchin akiitsuk jakamtaigka, ni wajen juki, uchin akinmainaiti. Tura nina yachi uchiriya nunin amajmainaiti’, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Nu timau ai chikichik shuar siete yachigmau chikichik nuweenawaiti, turasha uchin akiitsuk jakauwaiti. Tumamtai nina yachi nuwe ajakun wajen jukinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Tuma nisha uchinka akiitsuk jakauwaiti. Nu tumamtai chikitcha juki, tura nusha uchinka akiitsuk jakauwaiti. Tuma tumainakua, sieteya nuka ashi jinaawaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Tumawaru ai ishichik pujus nuwasha jakauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Nu chikichik nuwanak nua nuatainakua jinaawarua nusha, ¿atak nantainamunmasha yáki jukitnaita?” tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Nuna tuinakai Jesús chichaak: “Atumka Yuusa chichamegka nekachu asarum, tura nina pujutairiya nusha wainchau ainarum nui tu chichakurme. ");
INSERT INTO hubNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Jinaawaru aina nantarartina nuigka nuweenachartin ainawai. Nayaimpinmaya shuar aina Yuusjai tuke matsamin aina nujai metek artinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Atumka Yuusa chichame aarmauwa nui, ¿jinaawaru aina nantartintrin pachis turamna nuka aujsachukaitrum? Nuka tu aarmauwaiti: ");
INSERT INTO hubNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Wiyaitjai Abraham, Isaac, Jacob aina nuna Yuusrinka. Yuuska jakau ainan Yuusrinchuiti, antsu iwáku ainan Yuusriyaiti’ ”. ");
INSERT INTO hubNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Nuna tusa Jesús jintinkartua ashimkamtai, nui shuar antu matsatu nuna antukar ashi enentai jearcharuiti. ");
INSERT INTO hubNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Jesús saduceo shuar ainan itatmamtikamun, fariseo aina antukar nitasha iruuntraruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Tumawar chicham umiktinan jintinkartin chichaak: Wii nekas anagkan chichaman nekaratjai tusa, Jesúsan jeari iniak: ");
INSERT INTO hubNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Jintinkartina, ¿chicham umiktin aina nuiya yama nagkamchaku umimaincha tuwaita? nu ujatkata”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Tusa tama Jesús chicharuk: “Amina apuram Yuusa nu ima senchi aneta. Turakum ima niinig enentaimsam pujusta. Yuusnau pegker aina nuke takasta. Yuus wakeramua nuke takasta. ");
INSERT INTO hubNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Chicham umiktin aina nuiya yama nagkamchaku umimainka nuwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Chikitcha nujai metekmamtinaiti nuka juwaiti: Atumek anenmamsarum chikich shuar ainasha anetarma, tu aarmauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Chicham umiktinan Moisés, tura Yuusa chichamen etserin chikich ainasha aararua nuna nagkasauka, jimara nuwaiti”, tusa Jesús tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Fariseo iruunar matsatun, Jesús chicharuk: ");
INSERT INTO hubNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“¿Cristosha atumsha uruk enentaimtarmea, ya weantuiti tarumea?” tusa tinaiti. Tusa takai nita aimainak: “Cristoka David weantuiti”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Tuinakai Jesús chichaak: “¿Tumaisha urukamtai Davidcha Wakan Pegkera nu chichamtikmasha: Apuru, tusa tinaita? Tura junasha David tu aaruiti: ");
INSERT INTO hubNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Apu Yuus, wina apurun chicharuk: Wina untsuruini ekeemsata, tumawakmin wii amina shuarum ainanka nepetkan, amini ikaankan matsastinaitjai’ ”, tusasha tinaita. ");
INSERT INTO hubNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“David, wina apur tujaku aisha, ¿Cristosha uruk asaya David weantusha amainaita?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Nuna takai nita tumaintrigka atsurainamu asar pegkesha chichakcharuiti. Nuna tumawaru asar, atakka awenagka iniascharuiti. ");
INSERT INTO hubNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Tumawarmatai Jesús shuar ainan, tura nina unuinatairi ainajaimak chicharuk: ");
INSERT INTO hubNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Chicham umiktinan jintinkartin ainaka, fariseo ainajai, chicham umiktarma Moisés timauwa nunaka nita jintinkartumain ainawai. ");
INSERT INTO hubNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Tuma asamtai nita umirkatarma. Tumakrum ashi nita turammauka imatiksarmek umirkatarma. Turasha nita pujutiya nuka atumka unuimarairpa. ");
INSERT INTO hubNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Nitaksha chicham umiktinnaka uminachiat, chikich shuar ainan ishichkisha yainachiat: Ju umiktarma, tusar shuar kijin ayanka umasa chicharmaina numamtuk amajainawai. ");
INSERT INTO hubNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Tura nita nijaincha senta wagkarman jukiar, chicham umiktarma Moisés timau ainan aar jigkaama yujainawai. Kunturincha turusag pempemarar yujainawai. Jaanchnasha pegker iwara neturmaun, chikicha jaanchri nagkasaun asarman nugkuinawai. Ashi chikich ainasha winaka emematrus iirsarti tusar nunaka turuinawai. ");
INSERT INTO hubNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Yurumak yuamunmasha ekeemtai shir iwaramunam ekeemsartasa wakerin ainawai. Iruuntai jeanam wainaksha, apu ekeemtai pegker iwaramunam ekeemsartasa wakerin ainawai. ");
INSERT INTO hubNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Nitaka shuar jintanam igkuntainaksha emematrus amikmatainak jintinkartina turutiarti tusar wakerin ainawai. ");
INSERT INTO hubNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Turasha atumka nitajai metekka ‘jintinkartina’ turutiarti tusarmeka waketsuk, ashi chikich ainajaisha ‘yatsuru’ tunaimain ainarme. Atumin jintintramuka chikichkiti. ");
INSERT INTO hubNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Tuma asamtai atum ainatirmeka ju nugka juiyagka aparimawairpa. Atum aparimmainka Yuus nayaimpinam puja nuketi. ");
INSERT INTO hubNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Tura ‘apu’ tamaksha atasrumka wakerirpa, antsu wii Cristo asan atumin apurinka wikitjai. ");
INSERT INTO hubNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Atum ainarum nuiya chikichan takarna nuwaiti nekas ima nagkamakuka. ");
INSERT INTO hubNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Shuar iman anenmamuka aantar juaktinaiti, antsu iman anenmamchauwa nu nekas imanuka atinaiti tusa tinaiti”. ");
INSERT INTO hubNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Chicham umiktinan jintinkartin ainata, atumnaka fariseo aina nujai metek wait anentajrume, atumka shuar uwemrarai tusarum, Yuusa inamtairiya nuisha tu uwemra waimainaiti tusarum shir jintintiatsrume. Tura atumkesha tu uwemmainapita tusarmesha nekatsrume. Shuaran tsanu ainata, atumka Yuusa inamtairiya nuisha wayaashtin asarum, chikich shuar uwemrattsa wakeruinakaisha ayatik tsanuarme. ");
INSERT INTO hubNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Chicham umiktinan jintinkartin ainata atumnaka fariseo aina nujai metek wait anentajrume. Atumka nuwa waje jee atankurum, shuar iruuntramunam wajakrum, Yuus yaigti tusarum Yuus au aujkuwarum iku yujau asaakrumin, Yuus atumnaka waittan senchi suramsatnaitrume. ");
INSERT INTO hubNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Chicham umiktinan jintinkartin ainata, atumka fariseo aina nujai metek waittsatin ainarme. Atumka tsanumin asarum, ii uminaj juwaiti ima pegkerka tusarum, ashi nugkanam wekasarum etserearme. Turasha atumnau chicham umiktin jintinkurmeka ayatik makuarme, turamu asar atum waitat jumaina nuna nagkasar jukiartinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Atumka wainmachujai metek ainayatrum, chikich aina jintinkurum, ‘Yuusa jeen pujus nuna jean pachis ni turatnurin anajmas chichaaka nekas anajmatchayat tawai, nekas anajmatuka oro Yuusa jeen a nuna pachis turatjai ta nu nekas anajmatui’, tinu asarum atumka waittsatin ainarme. ");
INSERT INTO hubNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Enentaimkachu tura wainmachujai metek ainata, atum iismasha ¿wari nekas imanuita? ¿Oro Yuusa jeen a nukait, tumachkusha Yuusan jee oron pegkermamtika nukait? ");
INSERT INTO hubNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Atumka shuar Yuusnau atii tusa ‘tagku aina maa patasa epetainam tagkun patak pachis anajmata nuwaiti nekas anajmatuka’, tuinarme. ‘Turasha shuar ayatik tagku aina maa patasa epetia nunak pachis anajmatuka nekas anajmattsui’, tarume. ");
INSERT INTO hubNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Wainmachujai metek ainata, ¿wari nekas imanuita? ¿Yuusnau atii tusa tagku itaamu tagku aina maa patasa epetainam pataimua nukait, tumachkusha tagku aina maa epetai Yuusnau atin anajmamun pegkermamtika nukait? ");
INSERT INTO hubNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Shuar tagku aina maa patasa epetain pachis tuina nuka ima nunakka tuinatsui, nunaka tagku aina maa patasa epetainam patatujai ashi taku tuinawai. ");
INSERT INTO hubNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Yuusa jea nuna pachis tuinasha ima jeanak taku tuinatsui, nunaka Yuus nui puja nujai taku tuinawai. ");
INSERT INTO hubNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Tura shuar nayaimpin pachis chichainasha ima nayaimpinkeka taku tuinatsui, nunaka Yuusa pujutairiya nunasha ashi taku tuinawai. ");
INSERT INTO hubNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Chicham umiktinan jintinkartin ainata, atumnaka fariseo aina nujai metek wait anentajrume. Atumka tsanumin asarum, atumin ajariin árak menta, anís, comino aina nu tsapakmataigka, kajinmattsuk ishichik akanka, Yuusnau atinka ikuwaitrume. Nu turayatrum Yuus wait anenkartina nu, winig pegker enentaimin arti tusa wakerutma nuka pachitsuk inaiyarme. Nekas turumainaitrum nuka nuwaiti. Turasha Yuusnau atin suamua nusha kajinmatmaitsurme. ");
INSERT INTO hubNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Wainmachujai metekaitiat, chikichan jintintaattsa wakerin ainata, atumka chikich shuar umartintrin tsetse shikapchich egkemtuamtai ajaprayat, ni umartintrin yunch egketunak umumaina numamtuk jarme. ");
INSERT INTO hubNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Chicham umiktinan jintinkartin ainata, fariseo aina nujai metek wait anentajrume. Atumka shikika umutai, tura platosha inittrigka nijattsuk, ukurig nijatkarum iku ainarme. Atumin pujutincha, nujai metekmamtin ainarme. Iyashmiin wapik auka shir nijarme, turayatrum atum chikich kasarkattsa enentaimtai, tura surimat enentai aina nuka utsatsrume. ");
INSERT INTO hubNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Fariseo wainmachujai metek ainata, yama nagkamchakrumka inittriya nijatkatarma, turam ukurisha wapikchau atatui. ");
INSERT INTO hubNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Chicham umiktinan jintinkartin ainata, atumnaka fariseo aina nujai metek tajarme: Atumka tsanumin asarum, shuar jakamtai ikusmau patatkerinka pegker pujujai ukatkamu asa, pegker wakerumain jas ayat, uraka iiyam shuar kauru ni ukunchi ainajai tsummaina numamtuk asaakrumin wait anentajrume. ");
INSERT INTO hubNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Shuar atumin yapin iirmasarka pegkera iman iirmainawai, turasha shuar tsanumin pegkerchau ainarme. ");
INSERT INTO hubNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Chicham umiktinan jintinkartin ainata, atumnaka fariseo aina nujai metek wait anentajrume. Atumka tsanumin asarum, yaunchuk Yuusa chichamen etserin aina kajegka ikusmau aina nu iwarume, turakrum shuar pegker kajegmauwa nu ikusmaunam kaya un jukirum pegker iwaararum, nitasha pegkertsuk ajakaruita tumain iwainmamrume. ");
INSERT INTO hubNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Turarum chichaakrum: Ii ina uuntri pujujakarua nui pujujakuitkurka, Yuusa chichamen etserin ainaka maawairpa, tusar ayamruku amainaitji tusarum tarume. ");
INSERT INTO hubNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Atum nu tusa tautirmeka, Yuusa chichamen etserin ainan majakarua nu weantuapi ainajia tusarum nekamarme. ");
INSERT INTO hubNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","¡Atumi uuntri tuma jakarua nuka yamaisha turusrumek inaitsuk umiktarma! ");
INSERT INTO hubNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Iwanch nápi najanar shuaran tsanu jakua nujai metek ainata ¿atumsha waitat juakrum jinum weakrum uruk uwemturtatrumea? ");
INSERT INTO hubNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Wii Yuusa chichamen etserin ainan, shuar yacha ainan, jintinkartin ainancha akupkattajai. Nuna turamtaisha atumka maattarme. Chikichka numinam achiirum maattarme, chikichka atum iruuntairmin juki ejérum nui asuttrattarme, tura nita pujutairi ikumtikirum chikich yaaktanam ejérum nui suim amajtinaitrume. ");
INSERT INTO hubNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","36","Tuma asarum, yama nagkamchakka Abel shuar pegker mantamnawa nui nagkamnasrum, Berequíasan uchiri Zacarías naartinan atumi uuntri Yuus ememattasa iruuntai jeanam, tagku aina maa patasa epetai amaunam maawarua nujai, shuar pegker ainan maawarua nusha, ashi yamai atum turamua nujai ashi irumra atumka waitat suam atinaitrume. Wii taja nunaka nekas tajarme”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“¡Jerusalénnumia shuar ainata, atumka Yuusa chichamen etserin ainasha main ainarme. Tura Yuus chicharkartinan akupturmakmataisha, kayajai tukui tukuinakuarum main ainarme! Tuma asarum ¡atash uchirin irumar nanapejai nukuwa numamtuk wisha atumi uchirin irumrattsan wakeraig, atumka nuka nakitramarme! ");
INSERT INTO hubNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Junasha tajarme, atumin jeegka itarak ikuktatrume. ");
INSERT INTO hubNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Wii tajarum nunaka, winaka awenarmeka waittsuk pujautiram, tsawan wii tatin jeatsaig: ¡Apu akupkam wina juka pegkeraiti! turutchakrumka winaka waitkashtin ainarme”, tusa Jesús tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jesús Yuus ememattasa iruuntai jeanmaya jiinki weakai, nina unuinatairi aina jeariar, jea jeamkamu pachisar iniasaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Tama Jesús nitan chicharuk: “¿Jea jeamkamua ju ashi waintrumek? Nekas tajarme, juigka chikichik kayaksha chikich kayanam patatuka achatnaiti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Nuna tusa inaiyak Jesús nina unuinatairi ainajai Olivosan naintrin wuwaiti. Tuma nui wakar Jesús ekeemsamtai, nina unuinatairi aina jeariar ininak: “Nusha urutia tumatnait, tura ame taattakum jakmincha warig wantiniartinait, nu nekattsar wakeraji, ujakratkata”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Tuinakai Jesús nitan chicharuk: “Chikich aina tsanurmarairum pe aneartin ataarma. ");
INSERT INTO hubNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Nukap shuar wina naarun pachisar: ‘Wiyaitjai Cristonka’, tusar nukap shuaran tsanurartinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Atumka maaniawartasa pampannaiyamu, maniamu ashammain antitnaitrume. Tumakrumsha ashamkatin airpa. Yama nagkamchak nagkamartin ainaka nu ainawai, turasha nugka mesera nagkanmauka nuchauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Nugka unnum matsamin ainasha mai imannumiag maaniartinaiti, nu iman tumainai, nugka shikapchinmaya apusha mai tumaunumiag maaniartinaiti. Tura tsukasha tepeatnaiti, jata wári shuaran tukur ijinmausha atinaiti, tura ashi nugkanam senchi urtinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Waitat yama nagkamnamuka nu atinaiti”, tusa Jesús nina unuinatairi ainan tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Nu tumamunam atumnasha achirmak surutmakartinaiti, turutmawarmatai wai waitkarmainakua mantamawartinaiti. Tura wina nemartuina asaakrumin, ashi shuar aina kajertamiartinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Tura nu tsawantinka nukap shuar wina enentaimturmaunka inaisartinaiti. Tumainak kajernainiartinaiti, imanina asar nitak surunainiartinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Tura shuar wait ainasha wantintratnaiti, tumainak Yuusnumian chichaajai, tusar nukap shuaran tsanuartinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Pegkerchausha shir nukap atinaiti, imania asamtai nukap shuar chikichjai anenaitnasha inaisartinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Turasha ni kuitammama pujus ashimnamunam jeaka uwemratnaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ashi nugka ainanmayasha nekaawarti tusa, yamaram chicham Yuus inammau pachisa etserna juka ashi nugkanam chicharkartukmau atinaiti. Nekas nagkanmauka tu atinaiti”. ");
INSERT INTO hubNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Jesús chikichnasha pachis nina unuinatairi ainan ujak: “Yuusa chichamen etserin Daniel ak, Yuus ememattasa iruuntai jea pegkera nui shuar wayainak, nita yuusrimtairin nakumkamun shir pegkerchaun awayawartinaiti”, tusa tina nuna turuinan wainainakka, ");
INSERT INTO hubNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Judea nugkanam pujuinaka muranam tsekemain ainawai. ");
INSERT INTO hubNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Tura jea jimara ekeni jeamkamunam pujuinasha warírin jukittsagka nugkagka akaamain ainatsui. ");
INSERT INTO hubNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Tura ajanam takainak yujainasha jaanchin jukitjai tusarka jeenka waketmain ainatsui. ");
INSERT INTO hubNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Nu tsawan atina nui nuwa ajapruktin aina nunaka, nuwa uchin yama jureru ainajai wait anentainajai! ");
INSERT INTO hubNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Tsetsek tepeamunam tumachkurmesha sábado tsawan aigkisha etsekeam airum nu pachisrum Yuus aujsatarma. ");
INSERT INTO hubNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Yuus nugkan najanawa imanai nagkamsa yamaiya juisha imanika waitchatain, tura atakea nuisha imanika waittsashtinan nagkasau shir senchi waitamu atinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Yuus nu waitat imanian imijtsuk imatiksag inaiyakaigka, chikichik shuarkesha uwemmain ainatsui. Turasha Yuus winau arti tusa shuar ainan etegkramurin wait anenta asa imijkatnaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Atum ainatirmin chikichik shuarkesha chichartamuk: ‘Jui Cristo pujawai, iistarma, ai Cristoka pujumai amajtamainakaisha nekaspapita titin airpa’. ");
INSERT INTO hubNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Nukap shuar ‘wiyaitjai Cristonka’ tuinasha artinaiti. Tura chikich chichaak, ‘wiyaitjai Yuus akatturmatai chichaman etsernunka’, tusa tinu ainasha wininak, shuar wainchatai ainan nukap iwaintuinak, Yuus etegkramu ainancha tsanumain akaigka, chikich shuar ainajai ashi tsanurartin ainawai. ");
INSERT INTO hubNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Junaka emtikan ujajrume. ");
INSERT INTO hubNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Wii timau asarum chichainak: ‘Au nainta ai Cristoka pujawai iistarma’ turamainakaisha, werirum iistin airpa, nuna turamainachkusha ju jea yaki tesamua jui pujawai iistarma turamainakaisha, atumka nekaspapita titin airpa. ");
INSERT INTO hubNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Shuarnum akinawaitaj nuna winaknaka pem etsa wataiya aiya newat etsantar etsa akaataiya atuni petna numamtuk jaktinaitjai. ");
INSERT INTO hubNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Chuag tuak irunun wainainakka juigka jakau tepawai”, tusa nekau ainawai. ");
INSERT INTO hubNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Nu waitamu nagkamaig, etsa etsantsuk káshi jastinaiti. Tura nantusha etsantrashtinaiti, tumai nayaimpinmaya ya aina puunar kakeniartinaiti. Imanina asarmatai, nayaimpinmaya senchirtin ainasha ashi muchitrartinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Nu imani ai wii shuarnum akinawaitaj nuna nayaimpinmaya wina senchirjai, shir tsaaptin jasan yuragminam pachitkau winai waitkartin ainawai. Tumawar ashi shuar nugkanmaya aina ashamrukar útiartin ainawai. ");
INSERT INTO hubNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Wii winaknaka, wii etegkamur ashi nugka nagkatramunam pujuina nuna trompetan umpuntar irumrarti tusan, nayaimpinmaya shuar ainan ishiaktinaitjai”. ");
INSERT INTO hubNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Númi higuera tutai enentaimtusrum iistarma. Nu ‘higuera nukarkamtai, atumka wári asat tepeattawai’ tusarum nekau ainarme. ");
INSERT INTO hubNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Numamtuk wii tajarum nu imanisag ashi uminkaigka, yamaika shuarnum akinawa nu tatinka ashi jeawapi titin ataarma. ");
INSERT INTO hubNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nekas tajarme, atak shuar matsamiartin aina nusha eke ashi jinuinatsaig juka uminkatnaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Nayaimpia auka nugkajai megkakatnaiti, turasha wii taja nuka imanisag uminkatnaiti”. ");
INSERT INTO hubNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Turasha wari tsawantaik, tura etsasha urutam aig tatinaitaj nunaka chikichkiksha nekainatsui. Nayaimpinmaya shuar tuke matsamin aina nukesha nekainatsui, tura wii Yuusan uchirinkisha nekatsjai. Antsu nunaka wina aparuk nekawai. ");
INSERT INTO hubNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Noé pujamunam shuar urukawa aina numamtuk wii winamunmasha jakartinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Nu tsawan ajakua nuisha eke yumi yutatsaig matsamsarka, yutain shir yuinak, umutain umarar nampenak, nuwenainak tura nawantrin suru ja pujuinai tsawan jeaamtai, Noé nina kanuriin egkemrauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Nuna tumamtaisha pachitsuk pujusar tuke imani pujuinaig, yumi senchi yutuk nujagkrak ashi shuaran ijinawaiti. Numamtuk shuar pachitsuk pujuinai, wii shuarnum akinawaitaj nunaka taatnaitjai. ");
INSERT INTO hubNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Wii winamu tsawan atina nuigka, shuar wina nemartin wina nemartichujai ajanam takak wekaka, chikichik juaku chikichka ikuam atinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Jimar nuwaksha wina nemartin wina nemartichujai araka jigkain nekeak pujausha, chikichik juaku chikichka ikuam atinaiti”. ");
INSERT INTO hubNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Atumka kajinmakrum pujutsuk aneakuk pujustarma. Etsasha urutam aig wii tatinaitaj nuka nekatsrume. ");
INSERT INTO hubNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ju enentaimtusrum iistarma, chikichik shuar jeentin kasa kasaram atintrin nekakka, wayan wainkattsa, káshisha kanutsuk pujumainaiti, imaniakka utua kasaram amaitsui. ");
INSERT INTO hubNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Atumsha numamtuk aneakuk pujustarma. Atum imanisrum nakamchamunam shuarnum wii akinawaitaj nunaka winitnaitjai”. ");
INSERT INTO hubNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Inatai uminnaka, patrónkri chikich inatai ni jeen matsatu yuatnuri iin atii tusa apumtika ikuknaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Tura apujkimu nina patrónkri chichamencha shir umiak pujauka nina patrónkri winakaisha shir anemainaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Imatikas uminnaka patrónkrisha ashi ninu aina nunaka amek iista tusa inaitumainaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Antsu inatai turata tusa timauncha metek umichuka: ‘Wina patrónkruka wári tachattawapi’, ");
INSERT INTO hubNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","tusa nina patrónkri inatairi ainanka senchi waitkak, nampen ainajai yutain shir yuak, umutnasha imanik umu pujaun, ");
INSERT INTO hubNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","pachiachmau tajkama tuma pujaun wainkagka, ");
INSERT INTO hubNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","chikich shuar wait ainajai metek waittsati tusa waittan susa inaimainaiti. Turam senchi útuk nainka takertu pujumainaiti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Yuuska shuar aina nina chichamen umiraina nuna Apuriyaiti tusa diez nuwa agkantu lamparinkrin jukiar, nuwenatin taamtai nijai wayatin asar nakasarua numamtinaiti tusa jintinkartak: ");
INSERT INTO hubNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Cinco nuwa shir umintsacharu ainawai, tura cinco nuwa chikich aina shir umintsaru ainawai. ");
INSERT INTO hubNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Nuwa umintsacharu ainaka lamparínkrin juinaksha, lamparínnumia ashimnakai yaratnunka jukicharu ainawai. ");
INSERT INTO hubNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Antsu nuwa umintsar pujuinaka lamparínkrin juinak, ashimnakai yaratnuncha botellanam aimkar chiki chikichik jukiaru ainawai. ");
INSERT INTO hubNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Nuwenatin tatsuk megkaak akai, nakai nakainakua kari pujarainam ashi kanararu ainawai. ");
INSERT INTO hubNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Tuma kanarar tepenai, ajampek jasa ai: ‘Yamaika nuwenatnuka winawai, jiintrarum igkugtarma’, tusa untsumainamun antukaru ainawai. ");
INSERT INTO hubNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Untsumainamun antukar nuwa aina ashi nantarar, lamparínkrin ekeemakartasa uminainai, ");
INSERT INTO hubNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","cinco nuwa nita yara ekeemamaintrinka umitsuk pujuina asar, chikich nuwa nita ekeemamaintrinka shir umis pujuinan, lamparínkri kajinkai yaramaintri atsurmau asar, kajinkai yaramij tusar seaina. ");
INSERT INTO hubNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Tuinakai nuwa ashi shir umis pujuina chichainak: ‘Atsaa, turumaitsuji, akanka jukimka wári amukattawai. Antsu atumka surutainam werum sumaktarma’, tusa tiaru ainawai. ");
INSERT INTO hubNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Tuinam surutainam sumakartasa wearu ai, shuar nuwenatnusha ukunam taawaiti. Tumamtai nuwa umintsar nakaa pujuinaka nuna jukiar jeanam utsaanawar waitin pegkesha waimainchau epeniaru ainawai. ");
INSERT INTO hubNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Tumawaru ai, nuwa surutainam wearusha kaunkar, waiti pegkesha waimainchau epenmau asamtai, tujigkar chichainak: ‘Apu, waiti uraita, apu waiti uraita’ amajaina. ");
INSERT INTO hubNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Imatram ni ayak: Nekas tajarme atumsha yatsuk ainarum nekatsjarme”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Jesús nuna pachis jintinkartua ashimak nina unuinatairi ainan chicharuk: “Atumsha numamtuk kajinmakrum pujutsuk aneakuk pujustarma. Warí tsawantinig, tura etsasha urutam aig, wisha tatinaitaj nuka nekatsrume”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Yuuska shuar aina nina chichamen metek umina nuna Apuriyaiti tusa Jesús jintinkartak: Chikichik shuar wiakach chikich nugkanam wetatuk pujus, nina inatairi ainan untsuk ikaanak chicharuk: Kuitur kuitamatarma tusa ikukna numamtinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Chikichik shuaran kuitan cinco mil susauwaiti, tura chikichnaka kuitan dos mil susauwaiti, antsu chikichnaka kuitan mil susauwaiti. Nunaka chiki chikichik nita enentaimmaurin iiras tu takamaina ainawa, tusa turawaiti. Tura ikuak nigka chikich nugkanam wuwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Inatai kuitan cinco mil jukinka nu kuitjai warí ainan sumar nuna surak, nuiyasha kuitan cinco mil ikaugkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Inatai kuitan dos mil jukincha, nisha turusag nu kuitjai warí ainan sumar nuna surak, nuiyasha kuitan dos mil ikaugkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Antsu inatai kuitan mil jukinka ayatik nugkan tai yutua nina patrónkri kuitrinka uuk inaisauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Tuma nukap tsawan pujus patrónsha waketki taawaiti. Tuma nina inatairi kuit susamuri ainan kuitrusha iturkamarum tusa iniastasa untsukuiti. ");
INSERT INTO hubNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Turam shuar kuitan nukap jukina nu yama nagkamchakka wayaawaiti. Tuma yama nagkamchaku cinco mil kuit jukimun patrónkrin susauwaiti. Tura nu kuitjai warí sumaka suraku chikich cinco mil kuit jukimun suak: ‘Juna ikauntukmajme jukita’, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Tama patrónkri chichaak: ‘Ayu, ameka inatai pegker chicham uminaitme. Ishichik susamaitiatam imatikam ikaugkaume. Jutika asaakmin yamaika ju nukap susattajme. Wina jearui wayata, tumawakmin ijai nakurusmi’, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Nuna tusa timatai kuitan dos mil jukincha wayaawaiti. Tuma chichaak: ‘Apu winaka ayatik dos mil surusmame, tura nu kuitjai warí sumakan surakun, nuiyasha kuitan dos mil ikauntukmajme, turamun jui itaj nu jukita’, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Tama patrónkrisha chichaak: ‘Ayu, maake, ameka inatai pegker chicham uminaitme. Ishichik susamjame, turamaitiatam imatikam ikaugkaume. Jutika asaakmin yamaika ju nukap susatjame. Wina jearui wayata, tumawakmin ijai nakurusmi’, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Nuna tusa inaisamtai, mil kuitan jukincha wayaawaiti. Tuma chichaak: ‘Apu, ame shuar suri, chikitcha wait anenchau asam, árak araachiatam juukam yarumin asaakmin, wika nuna nekau asan, ");
INSERT INTO hubNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","amina ashamakun kuitrumnaka nugka tain shir kuitaman uukan inaisamjai. Turamun yamai jui itarjame jukita’, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Tutai patrónkri chicharuk: ‘¡Ameka inatai nakitme! Wii wina inatair ainan senchi takamtikkun waitkau, tura arakan arachiatan juurtuktarma tinu aisha, ");
INSERT INTO hubNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","¿urukamtai kuit kawegti tusa egketainam egkea ikurtutskesha ameksha ayatik uukmesha inaisamame? Nui egkeamuitkugka kawe ai wisha tamain jakjai’, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Nuna tusa inaiyak, nui shuar irunun chicharuk: ‘Kuitan mil takaka nu atankirum shuar kuitan diez mil takaka nu susatarma’, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","‘Shuar nukap ara nuka nu nukap suam atinaiti, turamu asa ninu amaincha ampinturtinaiti. Antsu ishichik ara nuka náki asa, ashi atantam atinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ju inatai atsumachmau waja juka jukirum, aa káshia ai apujsatarma, nui pujus waitak senchi útuk nain takertu pujuti’, tusa tinaiti”. ");
INSERT INTO hubNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Shuarnum akinawaitaj nuna apu jasan nayaimpinmaya shuar aina ajapeen etentawarmatai winaknaka, ekeemtai nekas tsaaptin jas a nui ekeemsatnaitjai. ");
INSERT INTO hubNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Tumamtai shuar ashi nugkanmaya ainaka winak tuartukartinaiti. Imanikarmatai chikichik shuar ovejan kuitamin cabran ovejajai akanna numamtuk, ");
INSERT INTO hubNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","winau ainan untsurnumani irumkun, shuar tunau takatan inaisacharu ainanka menanmani irumratnaitjai. ");
INSERT INTO hubNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Turan wii apu asan, wina untsuruini irumran chicharkun: Atum wina Apar shir anentsa yaigmau ainatirmeka wini winitarma, tumarum tuke pujustinan Yuus nugkan najantsaig umikmauwa nu jukitarma. ");
INSERT INTO hubNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Wii tsukamakaisha atum winaka yutai surusmiarme, tura kitamakaisha umutai surusmiarme, tura jeenchau wekakaisha, atum wii pujumainka jea surusmiarme. ");
INSERT INTO hubNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Jaanch atsurtakaisha atum surusmiarme. Jakun tepakaisha taarum iirmiarme. Achirkarmatai cárcelnum egketaisha, waitkattsarum tarutmiarme tusan titinaitjai. ");
INSERT INTO hubNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Nuna tusan takai winau ainatiram chichartakrum: ‘Apuru, ¿urutia isha ame tsukama pujamincha yurumkasha amasmiaji? ¿Urutia ame kitamakmincha umutaisha amasmiaji? ");
INSERT INTO hubNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Urutia ame irakum wekamincha, ina jeencha ikantramiajme? ¿Tura urutia jaanch atsurtamkaisha amasmiaji? ");
INSERT INTO hubNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Cárcelnum achinkam pujamincha isha urutia ame iistasrisha tamiaji? ¿Tura urutia ame jakum tepamincha tamiaji?’ tusarum turuttin ainarme. Turutkurmin, ");
INSERT INTO hubNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Wii apu asan chichaakun: ‘Nekas tajarme, wina nemartin aina ju imanchauch aigkisha turawaitrum nuka wina turuta ainarme tusan titinaitjarme’. ");
INSERT INTO hubNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Nuna tina inaiyakun, wina menaruini irunun chicharainakun: Tunaun takatan inaisachu ainata, wini iruuntsuk ji kajinchau iwanchnau, tura ninu aina nujai pujustin umirkamua nui wetaarma. ");
INSERT INTO hubNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Wii tsukamakaisha suruschamiarme, kitamakaisha suruschamiarme. ");
INSERT INTO hubNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Jeenchau wekakaisha, pujumainka suruschamiarme, jaanchin atsumakaisha suruschamiarme, jakun tepakaisha tura achinkan pujakaisha, iirsachmiarme tusan titinaitjai. ");
INSERT INTO hubNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Tusa tama nita chichartuinak: ‘Apu ¿urutia ame tsukama pujamincha, jeenchau wekamincha, jaanch atsurtamaisha, jakum tepamincha, achinkam cárcelnum egketmincha pachitskesha isha inaisamiajme?’ tusa turutiartinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Turutainakai wii ayakun: ‘Nekas tajarme, atum ju shuar imanchauch aina turachu ainarum, nuka wina turutawaitrume’, tusan titinaitjai. ");
INSERT INTO hubNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Timatai nu shuar ainaka waitat nagkankashtina nui weartin ainawai. Antsu wini wayaatarma tusa timau ainaka pujut tuke atina nui wayawartin ainawai”, tusa Jesús tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jesús nuna ashi tina nina unuinatairi ainan chicharuk: ");
INSERT INTO hubNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Jimarchik tsawan asa jiisat Pascua atata nuka atumka nekarme, tura wii shuarnum akinawaitaj nunaka nu tsawantin achirak surutkartatui”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Nuna tusa tinu ai nu tsawantin sacerdote apuri ainasha chicham umiktinan jintinkartin aina tura judío apuri ainajai, Caifás sacerdote apuri ajakua nuna jeen iruuntraruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Tumawar Jesús tsanumrura achika maami tusar chichaman umikaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","“Turasha jiisat aigkika turachmi, shuar aina nuna akasmatainak jianaimain ainawai”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jesús nina unuinatairi ainajai yaakat Betanianam Simón jata lepra tukumu pegker amajsamua nuna jeen pujau. ");
INSERT INTO hubNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Nui pujaun chikichik nuwa botella alabastro najanamunam kugkuin aun shir akikan juki, Jesús mesanam eketun jeari, muuknum ashi ukatkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Turakai nina unuinatairi aina wainkar kajekaruiti, tuma chichainak: “¿Urukamtai kugkuinnasha antrasha ajapeawa? ");
INSERT INTO hubNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Au surukar nukap kuit jukir kuitrinchau aina yaimainajama”, tusar nitak tunaiyaina. ");
INSERT INTO hubNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Tusa tunaiyainakai Jesús nuna antuk nitan chicharuk: “¿Urukamtai atumsha ju nuwasha kajerarme? Juna ni aitka juka pegkeraiti. ");
INSERT INTO hubNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Kuitrinchau ainaka atumjai tuke pujuartinaiti. Antsu wii atumjaigka tuke pujuschatnaitjai. ");
INSERT INTO hubNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ju nuwa wina iyashrui kugkuinjai ukatrura junaka wii ikuntsatin asamtai aitkarayi. ");
INSERT INTO hubNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nekas tajarme, ju nuwa wina aitkara junaka chicham uwemtikartina juna ashi nugkanam yujasar etserainaksha, pachisar chichaartin ainawai”, tusa Jesús nina unuinatairi ainan tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Nu tsawanta nuik Jesúsa unuinatairi doce ajakarua nuiya chikichik, Judas Iscariote naartin, sacerdote apuri ainajai chichastasa jiinki wuwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Tuma nui jeaa chichaak: “Wii Jesúsan atumin amakaisha, ¿winasha urutma akirmainaitrume?” tusa tinaiti. Takai treinta kuitnak susaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Nu turam Judascha Jesúsan uruk anagkanak surukaj tusa enentaimtu weká. ");
INSERT INTO hubNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Jiisat yama nagkamnai, pan levadurajai pachimtsuk inarkamu yutai jeau asamtai, nina unuinatairi aina Jesúsan jeariar chicharainak: “Apuru, ¿jiisat Pascuatin yuatnusha tui umiktatji?” tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Tusa tama ni chichaak: “Yaaktanam wetaarma. Tumarum chikichik jeanam wayaarum, ina jintintramin chichartamuk: ‘Wina tsawantruka ashi jeayi, tuma asamtai amina jeemin wina unuinatair ainajai iruuntsan jiisat Pascuan inagkastajai’ ”, tusa tawai titaarum tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Jesúsa unuinatairi aina ni timaunka imatiksag umikaru ainawai. ");
INSERT INTO hubNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Tura káshi jasmatai Jesúsa unuinatairi doce aina mesanam nijai ekeemsaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Nui yurumkan yuak ekeemas nitan chicharuk: “Nekas tajarme, atum ainarum juiyag chikichik winaka surutkattawai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Tusa takai senchi wake mesekar chiki chikichik chichainak: “¿Apuru, wikaitaj?” tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Tusa tuinakai Jesús nitan chicharuk: “Wina surutkatnuka chikichik platonmag wijai jimarak yua juwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Shuarnum wii akinawaitaj nunaka wina pachittsar aararua nuna umiktasan werajai. Turasha shuar wina surutkatta nunaka wait anentajai. Nekas nigka akinmainchauntsuk akinawaitti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Nuna tusa takai Judas ni suruktin chichaak: “Jintinkartina, ¿yaita nusha? ¿wikaitaj?” tusa tinaiti. Tusa takai Jesús ayak: “Ee, ametme”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Nuna tina inaiyak eke yuinak eketainai, Jesús pankan juki, Yuusan maaketi tina puur, ni unuinatairi ainan tinamak chichaak: “Ju yuatarma. Juka wina iyashrua numamtinaiti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Nuna tina nuiyasha umutain shikikam eketun juki, nunasha turusag Yuusan aujas maaketi tina nitan chicharuk: “Jusha ashi umartarma. ");
INSERT INTO hubNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Juka wina numparua numamtinaiti, juka Yuus yamaram chichaman ashi atum ainatirmin anajmatramawa nuwaiti. Wina numparjai nukap shuar ainan tunaurin tsagkuurattajai. ");
INSERT INTO hubNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Yamai atumin tajarme, wika uva neren yumirinka atak awenanka umarchatnaitjai, antsu tsawan uminkamtai, wina Aparu inamtairin atumjai iruuntran umartinaitjai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Nuna timatai kantamtai kantamawar Olivosan naintrin wearuiti. ");
INSERT INTO hubNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Tuma nui jeawarmatai Jesús nitan chicharuk: “Yamai ju káshia juik atum ainatirmeka winaka ashi ajapa ikurkittarme, chicham aarmaunmasha aitkasag nunaka tawai: ‘Ovejan kuitamnun maawartinaiti, turawarmatai oveja ainaka kanarartin ainawai’, tu aarmauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Turasha Yuus ataksha inantukmatai, atumka Galileanam weatsruminig wiyaa wetatjai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Tusa takai Pedro chichaak: “Chikich aina ashi ajapa ikurmainakaisha, wika aminka ikukchattajme”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Tusa takai Jesús chicharuk: “Nekasa tajame, ju káshia jui atash shinatsaig, wika au shuarnaka wainchauwajai tusam, tresa imajnia waitruattame”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Tusa tamasha Pedro chichaak: “Amina mantamainakaisha, amijai jakamij tusan waitruashtatjai”, tusa tinaiti. Pedro nuna takai, chikich ainasha chichainak ashi mantamnami, tusa tiaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Nuna tusar Jesúsjai wear númi arakmau Getsemaní tutainam jeawaruiti, nui Jesús nina jintintairi ainan chicharuk: “Jui atumka ekeema jatarma, tumarmin ai wena aparun aujsatjai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Tusa weak Pedron, tura Zebedeo uchirin mai juki wesa, senchi wake mesemar nekapeak kuntuts enentaimu. ");
INSERT INTO hubNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Imania asa chichaak: “Senchi wake mesemar nekapeakun jamain nekapeajai. Atumka jui pujusrum, wijai metek kanutsuk pujutarma”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Nuna tusa ikuak, Jesúska ishichik kuwasag tikishmar, tsuntsumaa pujus Yuusan aujeak: “Apaachi, turumainaitkumka wait aneasam ju nekapkartamua jui waittsaij tsagkamrukaipa. Turasha wii wakeramuka achati, antsu ame wakeramua nu atii”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Tusa ikuak nina unuinatairi tres apujkimurin wakettruki tanta iikma, kanar tepenan wainak, Pedron chicharuk: “¿Atumka wijai metek ishichkisha shintagkrum matsammainchauk nekapearum? ");
INSERT INTO hubNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Iwanch nekapramkai tunau takasairum, kanú tepetsuk shintarum Yuus auju pujutarma, nekas atumi wakanigka pegkera nunak takastasa senchi wakerawai, tumaig atumi iyashi ima kakakchau ainawai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Tusa tina ikuak ataksha waketki nina aparin aujeak: “Wina Aparu, wii waitmaina nu yupichu yapajimainchau akaigka, ame uruk wakeramea nu turusmek umikta”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Nuna tusa ikuak ataksha waketki iikma kari senchi pujainakai, kanar tepenan wainkau. ");
INSERT INTO hubNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Tura iis ikuak ataksha waketki nuik timaurinak turusag aujsauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Nuna tusa ikuak nina unuinatairi tres ikukmaurin jeari chicharuk: “Yamaika kanakrum ayama pujutarma. Shuarnum wii akinawaitaj nuna shuar tunaun takau ainanam surutkartata nuka tsawan uminkayi. ");
INSERT INTO hubNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Nantartarma wearmi, wina surutkatta nuka winawai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Nuna tusa Jesúska eke chichaa wajai, Jesúsan unuinatairi doce ainanmaya chikichik, Judas nukap shuaran kuchii ainan tura númi ainajai takarun yaruak winau. Nuka sacerdote apuri aina judío apuri aina akupkamu asar winina. ");
INSERT INTO hubNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judas ni suruktin ayatik iwijran, “wii kugkuastataj nu Jesúska atatui, shir achikrum jukitarma” tusa chichaman umiku ajakuiti. ");
INSERT INTO hubNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Tu chichaman umiku asa, Jesúsan jeari chicharuk: “Jintinkartina pujamek”, takug kugkuasuiti. ");
INSERT INTO hubNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Turam Jesús chicharuk: “Amikru, ame turattsam winam nuka turata”, tusa taunak shuar aina achikaru ainawai. ");
INSERT INTO hubNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Nuna turuinakai, Jesúsa unuinatairi ainanmaya chikichik, kuchiirin juakug sacerdote apuri inatairin kuishin awatti asankauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Turamtai Jesús chicharuk: “Aitkatsuk inaisatarma, kuchiirumka egketairmin egkeata. Shuar kuchiijai maaninaka, kuchiijaig maam artinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Ameka wina apar aujmaka, yamaiya juik doce mil shuar maanin ainan nayaimpinmayan akupturmaina nuka nekatsmek? ");
INSERT INTO hubNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Turasha wina mantuinachkaisha, ¿itursag Yuusa chichamen etserin aina yaunchuk aararua nusha uminkati?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Nuna tusa shuar ainan chicharuk: “¿Urukamtai kasa achiktasa winitmaina imatikruarmesha kuchii aina, tura númi ainasha takaru winitrarme? Wii atumin jintinkun, Yuus ememattasa iruuntai jeanam atumjai kashi kashinig tuke pujuwaj nuika jutikruarum achirchau ayarme. ");
INSERT INTO hubNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Turasha ju aitkararum juka Yuusa chichamen etserin timau chicham aarmaunam ta nu uminu asamtai aitkararme”, tusa tinaiti. Nuna tusa timatai ashi nina unuinatairi ainaka tsekenak ninak ikukiaru ainawai. ");
INSERT INTO hubNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Jesúsan achikar jukiaru aina Caifás, sacerdote ainan apurin jeen, apu aina tura chicham umiktinan jintinkartin ainajai matsatmaunam ejéniaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Turuinakai Pedrosha ikag patatus wea weakua sacerdote apuri Caifása jeen nuna aarin nisha jeawaiti. Tuma Yuus ememattasa iruuntai jean kuitamin ainajai nisha iruunar jina anamuk, iturkartig tusa ekeemas ii eketu. ");
INSERT INTO hubNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Sacerdote apuri ainaka, judío apuri ainajaimak ashi iruuntrar Jesúsan pachisar aantar tsanumruina. Nunaka maattaj tuina asar, tukeneas imatruina. ");
INSERT INTO hubNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Nukap shuar imatrua tsanumruinaksha, ni makumamaintrinka etsertuinachu. Turasha inagnamunam jimar shuar tsanumrurtin tawaru. ");
INSERT INTO hubNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Tumawar ii nekas anturkamji, tusar wajakiar chichainak: “Ju shuar chichaak, ‘wika Yuusa jea juna yumpugkan tres tsawantaik ataksha jeammainaitjai’ ”, tusa timayi tuina. ");
INSERT INTO hubNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Tuinakai sacerdote apuri wajaki Jesúsan chicharuk: “¿Urukamtai nuna imatrutmainakaisha ishichkisha aimtsume? ¿Nunasha waritmauna ame timaurmin pachisarsha imatrutmainawa?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Tamasha Jesúska aikchauwaiti. Tumakai sacerdote apuri ataksha chicharuk: “Yuus tuke pujuwa nusha waitmai tajame, nekasa nu ujatkata. ¿Ame nekas Cristo, Yuusa uchirigkaitam?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Tusa tu iniam ni ayak: Ee, ame tame nuka nekasaiti. Tuma asan junasha tajarme: “Shuarnum wii akinawaitaj nuna, Yuus senchirtina nuna untsuruini eketun tsawan uminkamtai, yuragminam pachitkau winamu waitkatin ainarme”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Nuna tusa takai sacerdote apuri kajek nina jaanchrin japiki jak chichaak: “¡Juka Yuusan akajeak tu chichaawai! ¿Nuiyasha ya nakajia? ¡Atumsha ni Yuusan pegkerchaun chichara nu antukurme! ");
INSERT INTO hubNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Atumsha uruk enentaimrumea?” tusa tinaiti. Takai nita chichainak: “Nekas tame, aya mantamnati”, tusar tuina. ");
INSERT INTO hubNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Tusar usukinak, awattan nagkamawaru. Turuinakai chikich aina yapinam ijuinak: ");
INSERT INTO hubNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“Ame nekas Cristowaitkumka, ya ijutma nu nekaata”, tusar imatruina. ");
INSERT INTO hubNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Nuna imatikainai Pedroka aa eketun nuwa apu inatairi jeari chicharuk: “Amesha Galileanmaya shuar Jesúsjai wekain ayam nuwapitmea”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Tusa tama Pedro ashi shuar antuinamunam chichaak: “Wika nekatsjai nusha warintsuk turutam”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Nuna tusa ikuak waitinam wetatmaun chikich shuar nui irunun nuwa ujak: “Ju shuara juka Jesús Nazaretnumiaya nujai wekainayi”, tusa etsertau. ");
INSERT INTO hubNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Tusa tama Pedro chichaak: “Yuuscha waitai tajai: Wika au shuarnaka wainchauwajai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ishichik asag shuar nui eketaina Pedron jeariar chicharainak: “Nekas amesha au weantuitme, ame chichamminig nekanme”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Tusa tama senchi kakaar chichaak: “Wika au shuarnaka wainchauwajai”, tusa tinaiti. Nuna tusa chichai atash shinukuiti. ");
INSERT INTO hubNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Tumakai Pedrosha Jesús chichaak: “Atash eke shinatsaig, wika au shuarnaka wainchauwajai tusam uurtakum tresa imajnia waitruattame timaun anear, nui pujamunka ikuki, aa jiinki senchi wake mesemar nekapeak útnaiti”. ");
INSERT INTO hubNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Tsawaarmatai ashi sacerdote uuntri aina, judío apuri ainajai Jesúska nekas mantamnati tusar chichaman umirkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Turawaru asar jigkar jukiar Romanmaya shuara apuri Poncio Pilaton ejétiaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judas Iscariote Jesúsa surukua nu, Jesúsan senchi waitkainak wait anenmain amajainakai, pegkerchau enentaimar treinta jiru kuit aina jukimun sacerdote apuri ainan, tura judío apuri ainancha awagtak, ");
INSERT INTO hubNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","nitan chicharuk: “Wika chikichik shuar pegkeran maatarma tusa suruku asan, tunau jasjai”, tusa tinaiti. Takai nita chichainak: “¿Isha nusha iturkattajia? Nuka aminua jama”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Tuinakai Judas Yuus ememattasa iruuntai jeanam kuitan nagkima ikuak we neakan jigkama jakauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Turamtai sacerdote apuri aina kuitan jukiar: “Shuar maattsa akikmatkamu asamtai, ju kuita juka Yuusnau atii tusa, ni anajmatku egkenaj aigka egkemaitsui tusar tiaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Nuna tiar chichaman umikar: Ju kuita jujaigka nugka Nuwe tutaiya nu sumakmi, tura chikich shuar juiyanchu aina jainakaisha, nuig tuke iku ami”, tusa tiaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Nui yamaiya juisha nu nugkanka numpa ukarmau tinu ainawai. ");
INSERT INTO hubNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Yuusa chichamen etserin Jeremías aarua nuka tu uminkauwaiti: “Israelita aina tu akikmaktarma, tusar treinta jiru kuitan jukiar, ");
INSERT INTO hubNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","nu kuitjai nuwen najannun nugken sumakarai, apu wina turutna nunaka metek umikarai”. ");
INSERT INTO hubNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jesúsnaka jukiar apu Pilaton ejétiaru ainawai. Turawarmatai Pilato iniak: “¿Nekas amekaitam judío ainan apurim?” tusa tinaiti. “Tusa tama Jesús ayak: Ame turutam nuka nekasaiti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Sacerdote apuri aina judío apuri ainajai tsanumruinamsha Jesúska pegkesha chichakchauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Tumakai Pilato chicharuk: “¿Amina aujmattramas imatrutmaina nuka antatsmek?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Turasha Jesúska ishichkisha aikchauwaiti. Tumakai apuka enentai jearchauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Tuma asa apu Pilatoka nu jiistatinka achikmaun shuar aina nu jiinkiti tusa tuinakai, chikichkinak tuke jiin asa, ");
INSERT INTO hubNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","nui chikichik shuar chicham aepruniamunam shuaran maa asa, Barrabás naartin achikam egketu asamtai, ");
INSERT INTO hubNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","nui shuar aina irunun Pilato iniak: “¿Atumsha yana jiikti tusarmea wakerarme, Barrabásnak jiiktataj, turachkursha Jesús Cristo tuina auwash jiiktaj?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilato tina nunaka, sacerdote apuri ainaka tukeneas kajerainakpapi wina itartiaria, tusa nekau asa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Nuna tusa Pilato nina ekeemtairin ekeemsamtai, nina nuwe shuaran akuptak: “Shuar tunaurtichun aitkaina nuigka pachinkaigka. Káshi karanam auna aitkawartin asamtai, ashammainan karamrajai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Turasha sacerdote apuri aina judío apuri ainajai shuar ainan chicharainak: “Atumsha Barrabás jiinkiti, tumakai Jesúska achintrati tusarum titarma”, tusar akattraruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Apu ataksha awentsag chichaak: “Ju jimar shuara junasha tuna nekascha jiiktatja, atumsha waritrumea tusa inimu. Takai nita chichainak: Barrabás jinkiti”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Tuinakai Pilato nitan iniak: “¿Turasha Jesús Cristo tuina ausha iturkattajia?” tusa tinaiti. Tutai ashi chichainak: “¡Auka numinam achinar mantamnati!” tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Tuinakai Pilato chichaak: “¿Turasha wari tunauna takasia?” tusa tinaiti. Nuna tusa takaisha senchi chichainak: “¡Achintrati! ¡Achintrati!” amajaina. ");
INSERT INTO hubNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Tusar Pilatonka ishichkisha anturtsuk imatruinam ni chichaak: “Turasha wika au shuarnaka mantamnamaintrinka nekartsujai, nuka atumnauwaiti, takug entsan ikijmaru”. ");
INSERT INTO hubNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Tumamtai ashi shuar senchi chichainak: “Au shuar mantamnamunmagka ii ainati, tura ina uchiri ainajai makumamain ainaji”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Tuinakai Pilatoka Barrabásan jiiyak, Jesúsan asutia, numinam achirar maawarti tusa suntar ainanam surukuiti. ");
INSERT INTO hubNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Tumamtai nui apu suntaari aina Jesúsan jukiar apu jeen aarin ejéniar, suntar ainan ashi ipawar Jesús wajamunam iruuntraru. ");
INSERT INTO hubNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Nui Jesúsan nugkutairin awitkar, apu nugkutairin jaanchin anugkraruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Etsegkrutaincha jagkin najatawar etsegkrumtikar, tura untsurnumani numin ataksaruiti. Turawar nina tikishmatrar aantar wishikainak: “Judío ainan apuri emematiarmi”, tusar tuina. ");
INSERT INTO hubNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Nuna tuinak usukina, imatikainak númi takakmaun atankiar muuknum awatainak, ");
INSERT INTO hubNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","wishi wishikainakua apu nugkutai anugkramunka awitak juruinak, ni nugkutairinak anugkar numinam achirartasa jukiaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Jesús ni achintratin númi yapajiamun yanak wesa, kakaarchamnau nekapeakai, Cirenenmaya shuar Simón naartinan wainkaru. Turawar Jesús achirtin númi yapajia achirmaun: Ju ame yanakta tusar ayankar jukiar, ");
INSERT INTO hubNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","nain Gólgota tutainam ejéniaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Tura najaimakchati, tusar Jesúsan umutain vino tagku tsagkejai pachimramun umarti tusar susaruiti. Turam apas nekapas nakitrauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Jesúsan achirarmatai, nepetmaku jukiti tusar suntar aina nakurutain nakuruawaruiti. Yuusa chichamen etserin aak: “Wina jaanchrunka jukiartasa yáki nepetmakat nu jukiti tusar nakurutain nakuruawartinaiti”. Tusa timauwa nuka tu uminkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Tumawar ii matsamiartasa ekeemsaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Tumau asamtai achiaji tusar Jesúsa chaikin tablanam aatar anujtukaruiti. Nu aarmaunam chichaak: Juwaiti judío shuara apurigka tu aatramu ajakuiti. ");
INSERT INTO hubNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Jesúsan númi yapajiamunam achinak nuiyasha jimar shuaran shir pegkerchau ainan achiraru ainawai. Chikichnaka Jesúsa untsurini, tura chikichnaka menarini netuawaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Jesús achinar netai shuar nagkamainak: Junaka nekas tunauwa nunapi achiraria, tusar muuken peas pegkerchaun chicharainak: ");
INSERT INTO hubNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Ame Yuus ememattai jea nu yumpugkam, tres tsawantaik jeammainaitjai tinam nusha, ¿urukamtai anisha netame? Ame Yuusa uchiriyaitkumka, ani nematsuk, akaikim uwemrakia”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Turusag sacerdote apurisha, chicham umiktinan jintinkartin ainasha, judío apuri ainajai iruunar wishikainak: ");
INSERT INTO hubNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Chikichnaka uwemtiknayi, tumauwaitiat nigka uwemeatsui. Israel shuar ainan nekas apuriyaitkugka, achinar neta au akaikiti, tumamtai isha nekaspapita tiarmi. ");
INSERT INTO hubNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Yuusnaka enentaimtinayi, ni nekas aneakka yamai uwemtikrati. Wika Yuusan uchiriyaitjai tinayi”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Magkartin achiram netuinasha, Jesúsnaka pegkerchau chicharaina. ");
INSERT INTO hubNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Etsa tutupnira ai, ashi nugkanam káshi jasu, tuma nukap asa etsa teenta ai, ataksha tsaaptin jasuiti. ");
INSERT INTO hubNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Eke imanik káshi jas aig, Jesús senchi untsumuk: “Elí, Elí, ¡Lema sabactani!” Nunaka: “Yuusru, ¿urukamtai winasha inaitusume?” taku tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Shuar nui iruunainaka nuna antukar chichainak: “¡Antu jakua, Elías Yuusa chichamen etserin ajakua nuna untsuawai!” tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Tuinakai chikichik shuar tsekegki umutain vino tutai churuin pujuttamaun, entsa mukuntai esponja tutain juakug ajug inijar, númi ichipkamunam etea Jesúsan umarti tusa inaktau. ");
INSERT INTO hubNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Turakai chikich aina chichainak: “¡Inaisata! Elías uwemtikrattsa winitchatpash, nu wainkarmi”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Nuna tuinai, awentsag Jesús senchi untsumak jakau. ");
INSERT INTO hubNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Tumamtai Yuus ememattasa iruuntai jeanam jaanch ajaamu auka yakini nagkamna jimapetuk achinakuiti. Nugkasha senchi uru, imania asamtai kaya un ainasha puuntraruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Imanikmatai shuar jakamtai ikusmau ainaka nitak urantraru. Tumamtai Yuusan nemarin jakamtai ikusmau ainaka nukap nantararuiti. ");
INSERT INTO hubNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Tura ikusmau aina nantararuka Jesús nantakmatai, yaakat pegkera nui Jerusalénnum wearuiti. Nu tuman nukap shuar wainkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Tura capitán nijai irunas Jesúsan iiyak irunuka, imanik urkamtai, nuiyasha ashammain ainan nukap wainkar, senchi ashamkar chichainak: “Ju shuarka nekas Yuusa uchiri ajakuiti”, tusa tiaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Nui nukap nuwa Galileanam nagkama, Jesúsan nemarsar yai jaku ainasha ikag ii iruuntuina. ");
INSERT INTO hubNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Nui María Magdalena, chikich María Jacobon nukuri, Joséncha nukuriya nu, tura Zebedeo nuwe chikich nuwa ainajai wajaina. ");
INSERT INTO hubNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Kintamai chikichik shuar wiakach José naartin Arimateanmaya nisha Jesúsan nemarin asa taawaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Tuma ni Pilaton weri Jesúsan iyashi ikustajai tusa seawaiti. Tusa takai susatarma tusa Pilato tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","José Jesúsa iyashin juki jaanch pegker pujujai punuaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Tura ni ikumasmij tusa, pampa wa yama tai umikmaunam egkea, kaya uunjai shir epeni ikuak wuwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Nui María Magdalena chikich Maríajai Jesús ikusmaun ii eketaina. ");
INSERT INTO hubNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Kashinia nui jiisat tsawaartin asamtai, uminmaunam sacerdote apuri aina fariseo ainajai Pilato jeen wearu. ");
INSERT INTO hubNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Tumawar jeariar chichainak: “Apu, Jesús wait aya nu iwáku pujus chichaak, wika jakancha treschik tsawan asan nantaktinaitjai, tu wekain aya nu aneakji. ");
INSERT INTO hubNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Tuma asamtai nu ikusmaun tres tsawan kuitamatin shuar aina akupkata. Nina unuinatairi aina káshi weriar iyashi jukiar shuar ainan chichaarainak: ‘Jakama nuka aneantai tiarai’. Nuna tusa tuinakka yama nagkamchaku waitruamun nagkasar, ima pegkerchau jamain ainawai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Tusa tuinakai Pilato chichaak: “Suntar aina atumin iruuna nu akuptukrum, Jesús ikusmauka atum uruk kuitamattsarmea wakerarmea turusrumek kuitamatarma”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Tusa timatai sacerdote apuri aina fariseo ainajai wear, Jesús ikusmaun urakaraig tusar kaya apujtuamunka sello tutain anujtukar, suntar ainan atum kuitamatarma tusar matsatkiaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ayamtai tsawan nagkamakmatai, kintamar kashin tsawak María Magdalena chikich Maríajai Jesús ikusmaun iisartasa wearu. ");
INSERT INTO hubNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Tura wenai pachiachmau senchi urkau. Nunaka nayaimpinmaya shuar Jesús ikusmaunam akak imatmawaiti. Nu akaiki kaya apujtua ikukmaun nuna urai ekek, nui kayanam ekeemsauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Nu nayaimpinmaya shuarka pem etsanna numamtuk etsantu, tura jaanchrisha puju yuragmia numamtuk ajakuiti. ");
INSERT INTO hubNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Tura imanun wainkar, suntar ainaka ashamkar kurainak jakaujai metek iyaantaru. ");
INSERT INTO hubNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Tumawaru ai, nayaimpinmaya shuar nuwa ainan chicharuk: “Ashamrukairpa, wika nekajai, atumka Jesús numinam achinar mantamnama nu earme. ");
INSERT INTO hubNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Turasha nuka juigka atsawai, ni tima nunisag nantaki. Taatarum ikusmauwa nu iistarma. ");
INSERT INTO hubNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Tumarum wári werum, nina unuinatairi aina ujaktarma, yamaika nantaki. Tuma nitaka jeainatsaig, niyaa Galileanam jeattawai. Tumamtai ai wainkartatui. Wii atumin titaj tamauka juketi”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Nu tusa tima nuwa ainasha ikusmau ajakunka iis ikuinak ashamainayat shir nakunkut aneasar, chichaman Jesúsan unuinatairi ainan ujakartasa tseketaik shimau. ");
INSERT INTO hubNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Tumainan Jesús wantiintuk amikma. Nuwa ainasha Jesúsan jeantar nawenam pagkuk ememataina. ");
INSERT INTO hubNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Turam nitan chicharuk: “Ashamrukairpa, wetaarma, tumarum wina yatsur aina ujaktarma, wári Galileanam wearti, ai winaka waitkartatui”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Nuwa wenai Jesús ikusmaun kuitamawaru aina yaakat Jerusalénnum wear, sacerdote apuri ainan nita wainkamunka tumamai tusar ashi ujakuru. ");
INSERT INTO hubNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Tusa ujakaram judío apuri ainanam nui nitajai chichaman shir umikartasa wearu. Tura umikar nukap kuitan suntar ainan susaru. ");
INSERT INTO hubNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Turawar chicharainak: “Ika kanara teparin Jesúsa unuinatairi aina káshi kaunkar, nina iyashinka kasamak jukiarmayi tusarum tu etserkatarma. ");
INSERT INTO hubNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Apu nekamtaisha ii ainati nepetkiartatji, ii turatin asamtai, atumnaka imanik iturchatcha atsurtamtattrume”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Tuinam suntar ainasha ayu tusar kuitan jukiar, nita tiarmaunka imatiksag umikartasa wearu. Judío ainaka yamaiya juisha turusag etserin ainawai. ");
INSERT INTO hubNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Jesúsa unuinatairi once aina Galileanam Jesús nu nainnum winiarti timaunam wearuiti. ");
INSERT INTO hubNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Tumawar Jesúsan wainkar, chikichka iturchat enentaimainaig ememataina. ");
INSERT INTO hubNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jesús nina unuinatairi ainan jeari chicharuk: Winaka Apar chichartak: “Ame nayaimpinmayasha, nugkaya ainajaimak ashi metek iista”, tusa turutnaiti. ");
INSERT INTO hubNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Turutin asamtai ashi nugkanam wetaarma. Tumarum shuar ainaka wina nemartin amajsatarma. Tura wina Aparu naari pachisrum, wina pachittsarum tura Wakan Pegker pachisrum imaitarma. ");
INSERT INTO hubNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Turakrum atumin wii jintintawaitjarum nuka nitasha umikarti tusarum ashi jintintaatarma. Wika atumjaigka ashi tsawantai tuke pujutnaitjai. Tura nugka mesera nagkanmaunmasha atumjaig pujutnaitaj nusha kajinmatkirpa, tusa tinaiti. Maake, nunis atii.");
INSERT INTO hubNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Jesucristo Yuusa uchiriya nuna chichame pegkera nuka junii nagkamnawaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Yuusa chichamen etserin Isaías tu aaruiti: “Wina chichamrun etsernun emtikan, ni jintan umirtamkati tusan akupeajai”. ");
INSERT INTO hubNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Shuar emak taa aya nugkanmag wekaas senchi chichaak: “Apu jintiya nu tutupin atii tusarum shir umiktarma, japau akaisha nugka yaruakrum aimratarma”. ");
INSERT INTO hubNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Nu tusa timau asamtai, Juanka aya nugkanmag entsa Jordánnum shuarnaka ima imakua taawaiti. Shuar ainan Juan chicharuk: Atum tunau takasmauncha Yuus tsagkurtamrarti, tunau takat inaiyakrum enentaim yapajiatarma, tumarum maitarma tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Nuna antukar Judea nugkanmaya ainaka, yaakat Jerusalénnumia ainasha ashi kaunkaruiti. Tuma kaunkar nita tunau takatairi ainan etsertumakarmatai, entsa Jordánnum Juan imakaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Juanka camello ure najanamun nugkujakuiti, akachumtairisha nuap najanamu ajakuiti, manchin yu jakuiti, tura napa yumirincha umin ajakuiti. ");
INSERT INTO hubNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Shuar ainan chicharuk: “Wina ukuruin wina nagkatasu winittawai. Wika niya imanchau asan, nuna zapatorinka atitmaitsujai. ");
INSERT INTO hubNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Wika ayatik entsajai imajrume, turasha nigka Wakan Pegkeran suramsattarme”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Chikich tsawantai Jesús yaakat Nazaret Galilea nugkanmaya jiinki Juan pujamunam wuwaiti. Tuma jeamtai Juan entsa Jordánnum imain. ");
INSERT INTO hubNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Tura imaim entsanmaya jiinkama, nayaim uranmatai pauma numamtinan ninii taarun Wakan Pegkeran wainkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Nu tumaig Yuus nayaimpinam pujusag chichaak: “Ametme wina uchir anetaimka, nui amini shir aneajai” tusa tamau antukauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Nuna timatai Wakan Pegker egkemtur wári juki aya nugkanmag shuarsha atsamunam umauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Nui Jesús cuarenta tsawantai uun yawa kajen aina matsatmaunam pujaun, iwanch Satanás tsanur tunaun takaamtiksattsa nekapsau. Turamtai nayaimpinmaya shuar aina kuitamawartasa taruawaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Juankan achikar cárcelnum egkeawaru ai, Jesús chichaman pegkeran Yuusan pachis etserkattsa Galileanam wuwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Tuma chicharkartak: “Yuus timauwa nuka tsawan jeayi, tura Yuus shuarnum inamratnuka tsawan ashi jeawai. Tuma asamtai pujutrum yapajiarum, chicham uwemtikartina nu nekaspapita titarma”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jesús Galileanam kucha tsukintrin wekajkama, Simónkan ni yachi Andrésjai, namakramin asar, kuchanam redtan nagkimainak yujattamaun wainkau. ");
INSERT INTO hubNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Tuma chicharuk: “Yamai nagkamsarmeka namakramat inaiyakrum wina nemartuktarma, tumarum Yuusa chichame shuar aina ujau ataarma”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Tusa tamauwaik nita redtrin ajapa ikuinak nijai wearuiti. ");
INSERT INTO hubNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Jesús nitajai iruunar ishichik wesag Zebedeo uchirin, Jacobon ni yachi Juanjai, boterin chumpimsar redtrin apainak chumpimtatmaun wainkau. ");
INSERT INTO hubNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Tura nunasha chicharuk: “Wina nemartuktarma”, tusa tama, nita apari Zebedeonka nitajai takau ainan botenam ajapa ikuinak Jesúsjai wearuiti. ");
INSERT INTO hubNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Tumawar yaakat Capernaúmnum jeawaruiti. Nui jeawar ayamtai tsawan tsawarmatai, iruuntai jeanam wayaa Jesús jintinkartutan nagkamawaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Tura chicham umiktinan jintinkartin ainan nagkas, Yuusa senchirijai jintinkartau asamtai, shuar ainaka nuna antukar enentai jearcharuiti. ");
INSERT INTO hubNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Nui iruuntai jeanam iwanch egkemtuamu shuar eketu asa senchi chichaak: ");
INSERT INTO hubNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“¡Jesús Nazaretnumiaya! ¿Urukamtai amesha ii pujamunmasha winame? ¿Ameka ina jiikratkittsamek winam? Inaikartusta. Wika nekajme, ameka Yuusnumia winau asam, nekas Pegkeraitme”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Tusa tama iwanchin ayak: “Takamtak jiinkim weakum nu shuar ikukta”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Tusa tamauwaik nitasha ashi wainainaig, shuaran nugkanam ajiaruiti. Turasha ishichkisha najaimamtiktsuk jiinki weak ikuknaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Tumamtai ashi wainkar senchi ashamkar enentai jearcharu. Tumawar nitak chichainak: “¿Chichamesha uruku asamtaiya iwancha anturainawa? ¡Apu chichamaina imatak chichakaimpa iwancha umirainawa!” tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Nu turamun wainkar, shuar ainaka ashi Galileanam Jesús turayi tusar etseraruiti. ");
INSERT INTO hubNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Tura iruuntai jeanmaya Jesús, Santiago Juanjai jiinkiar, Simón Andrésjai pujamunam wearuiti. ");
INSERT INTO hubNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Nui Simónkan tsatsari tsuweak tepau, tuma asamtai Jesúsan chicharainak: “Simónka tsatsari tsuweak tepawai”, tusar ujakaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Nu tama Jesús jeari uwejnum achik inankin. Nu turamuik tsuweamun michatar pegker jas, nantaki yurumkan inarak shuar Jesúsjai yujan ayurawaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Nu tsawantaik kintamai, ja ainan, tura iwanch egkemtuamu ainajaimak Jesúsan ashi ikaatkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Turawar ashi shuar ainaka waitinam iruuntraruiti. ");
INSERT INTO hubNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Tumawarmatai ja ainan pegker amaju, tura iwanch ainancha jiintra shiaktarma tusa tinaiti. Iwanchka Criston nekaina, turamu asa chichakcharti, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Yama tsawak eke suamut aig nantaki, yaaktan ikuak kanaki shuar atsamunam aparin aujsattsa wuwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Tumamtai Simón ni amikri ainajai eainak wearuiti. ");
INSERT INTO hubNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Tumawar Jesúsan wainkar chicharainak: “Ashi shuar eatmainawai”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Nu tusa tama ni chichaak: “Yaakat jeashtachu aina aisha wearmi, tumar Yuusa chichame etserkarmi, wika juna etserkattsan juigka tawaitjai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Jesúska ashi Galileanam weká jakuiti, tura chiki chikichik yaaktanam jeakka, nita iruuntairin wayaa Yuusa chichamen etsereak, iwanch ainancha jiir ishimajakuiti. ");
INSERT INTO hubNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Shuar lepra tukumau jak pujau Jesúsan wainak tikishmatar chicharuk: “Apu, ame wakerakmeka winasha pegker amajtumainaitme”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Tusa tama Jesús wait anentar, uwejejai jan achiak: “Wakerajai, yamaika pegker jasta”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Tamauwaik wári ashi iyashigka chimik pegker jasuiti. ");
INSERT INTO hubNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Tumamtai Jesús ikuak akateak: ");
INSERT INTO hubNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Wetá, turasha chikich shuar ainaka ujatsuk Moisés timauwa nu metek umiakum sacerdote pujamunam jeata. Nuka tu aarmauwaiti: Ashi shuar leprajai ja pegker jasuka tuke tumasarke artinaiti. Tura chikich ainasha wainainak nekaspapi pegker jasia tiarti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Nu tusa timaitiat, ni pegker jasmaurin pachis ashi shuar ainan ujaku. Nuna imatika etserkau asamtai, Jesúska wantinak yaaktanmasha waimainchau jas, nigka ayatik yaaktan arinig shuar atsamunam weká. Turasha chikich yaaktanmaya ainasha Jesúsan wainkartasa iruuntuina. ");
INSERT INTO hubNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Nuna tura ujumchik tsawan pujus, Jesús waketki ataksha Capernaúmnum jeau, tumamtai nukap shuar ni pujamurin nekaawar, ");
INSERT INTO hubNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","wári iruuntrar jeanmagka waitinam nagkamsar, chikichkiksha wayaachminu piakaru. Imanikarmatai Yuusa chichamen nita ainan ujakuiti. ");
INSERT INTO hubNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Nuna tumai cuatro shuar wekaichun Jesús pegker amajsati tusar jukiar itariaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Tumawar waitin waimainchau akirawarmatai, tujigkar jea tuntupeen wakar jean chigkainiar, jaanchin tampumruawar Jesús pujamunam akakiaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Nuna turuinak nigkiapi pegker amajsattawa tusar enentaimainan Jesús nekau asa, wekaichun chicharuk: “Aishmagku, yamaika amina tunaurumnaka tsagkuraujme”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","7","Nuna takai, chicham umiktinan jintinkartin aina irunu asar nitak enentaimsar: “¿Urukamtaig nunasha tusha chichaawa? Yuusan pegkerchau chicharuk tu weká jama shuara tunaurin tsagkurmainka chikichka atsawai. Antsu ima Yuusketi tunaurumnaka tsagkuurajme tusa tukartumainka”, tu enentaimaina. ");
INSERT INTO hubNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Turasha Jesúska nita enentaimmaurin nekau asa chicharuk: “¿Urukamtai atumsha tusha enentaimrume? ");
INSERT INTO hubNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Shuar ja chicharkur: Amina tunaurum ainanka yamaika tsagkurajme tusa tuta nuka yupichuiti. Turasha shuarka nantaki jaanchrin juki weti tusarka pegker amajmaitsui. ");
INSERT INTO hubNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Wika shuarnum akina asan, ju nugkanam shuara tunaurincha tsagkurmainaitjai. Tuma asan atumin yamai iwaintuktajrume tusa”, wekaichun chicharuk: ");
INSERT INTO hubNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Nantakim jaanchrum jukim jeemin waketkita”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Tusa tamauwaik wekaichu itaamusha nantaki jaanchrin juki ni jeen waketkin. Nu wekaichau pegker jasmatai, chikich ainasha wainkar, enentai jearcharuiti. Tumawar Yuusan emematainak: “Juna jutikaka pegke wainkachuitji”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Tura nuna inagkaki Jesús ataksha kucha tsukintrin wuwaiti, nuisha shuarka imanik iruunturaru, turam jintintu. ");
INSERT INTO hubNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Tuma nagkamajkama Leví, chikich naari Mateo, Alfeo uchiri, apunu atinan akikmamun kuitan yarumin asa, kuit juaku ekeemtainam eketun wainkau. Tura wainak: “Weajai, wina nemartukta”, tusa tinaiti. Tusa tutai Levísha ni takaamurinka ikuak, Jesúsan nemarkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Tuma nu tsawantaik Leví ashi amikri apunu atinan kuitan yarumin ainan chicharuk: Wina jearui kaunkatarma yurumak Jesúsjai iruuntura yuawarmi tusa ipa. Nuna timatai amikri ainasha kaunkaru, tumawarmatai Jesús mesanam ekeemas ashi ni unuinatairi ainajai chikich shuar tunaurintin aina nukap saatukmau asa, iruunar mesanam jeantar ekeemsaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Tuma chicham umiktinan jintinkartin aina, fariseo ainajai Jesús nu shuarjai iruuntur yuan wainkar, Jesúsan unuinatairi ainan chicharainak: “¿Urukamtai atumin jintintramnusha au shuar apu kuitri atinan yarumin ainajaisha, chikich shuar tunaurintin ainajai iruuntursha yurumkan yuawa?” tusa tiaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Nu tusa tuinamun Jesús antuk chichaak: “Shuar jachu pegker ainaka tsuakratnunka atsumchau ainawai, antsu shuar ja aina tsuakratnunka atsumin ainawai. Wika shuar tunaurinchau ainanka taruachuitjai, antsu shuar tunaurintin aina tunaurin inaiyainak pegkermakati tusan taruawaitjai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Chikich tsawantai, Juankan unuinatairi aina, tura fariseo unuinatairi ainajai Yuusa seartasa ijarmawar matsataina. Nuna tumaina ujumak shuar Jesúsan jeariar ininak: “¿Urukamtai Juankan unuinatairi aina, tura fariseo unuinatairi ainasha ijarmainaisha, ame unuinatairam ainasha ijarmainatsua?” tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Nu tusa tama Jesús nitan ayak: “Shuarka nuwa nuatku ipaamu irar ainaka shuar nuweenatin pujaigkika, yutsukka iruunmaitsui. ");
INSERT INTO hubNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Antsu ipaamu ainasha nuwenatin jiistamuk ipaaman tsawan jeamtai jukiartata nui, wake mesemar nekapenak ijarmawartin ainawai. ");
INSERT INTO hubNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Tusa tina chikichnasha pachis chichaak: Jaanch yamaram asa nijam jujuak sumpeak, jaanch mamurun nu senchi jaamain asamtai, jaanch yamarman tsupikar mamurunka anujtichu ainawai. ");
INSERT INTO hubNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Nuap aparmau arutmaraunmagka, umutai vino yama umika yara aimka ikukmaka kariak, saurkusha nuap arut asa wagkaki weachu asamtai apujmainaiti tusa Jesús tinaiti”. ");
INSERT INTO hubNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ayamtai tsawantin Jesús nina unuinatairi ainajai trigo arakmaunam uturar jinta nu nagkamatai asamtai wenak, ni unuinatairi aina tsukamainak, trigon kupik jukiar, neren akarar yurkuta wena. ");
INSERT INTO hubNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Tumainan fariseo aina wainkar chichainak: “Iisiana, ayamtai tsawantinka takantsashti timau aisha, ¿urukamtai amina unuinatairam ainasha, nuna umitskesha takainawa?” tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Nu tama ni ayak: “¿Atumka Yuusa chichamen aarmauwa nuka aujsachuk ainarum, Abiatar sacerdote apuri jas pujai, yaunchuk ina apachri David tsukamak, tura nijai tsanig yujasha tsukamainakai, Yuus ememattasa iruuntai jeanam wayaa pan pegkermamtikamu ima sacerdote yutainak, ni juki yuak, shuar nijai yujainancha ayurkauwa nuka aneaktsurmek? ");
INSERT INTO hubNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ayamtai tsawanta nuka shuar aina ayamrarti tusa aitkamuiti. Yuuska shuar ainanka ayamtai tsawanta nuna umirainak waittsarti tusagka tichauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Tuma asamtai wika Yuusan uchiriyaitiatan shuarnum akina asan, ayamtai tsawan tsawarmataisha urukmainkit nuna tumainnaka wikitjai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jesús iruuntai jeanam ataksha wayaawaiti, tuma shuar uweje chuiru pujaun wainkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Turamtai fariseo aina ayamtai tsawanta juisha, iturkatig pegkerash amajsat, pegker amajsamtaigka Jesúska tunaun takáwai tiartasa ii iruuntuina. ");
INSERT INTO hubNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Tumainaig Jesús shuar uweje chuirun chicharuk: “Wajakta, tumam ajapeen wajasta”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Nuna tina shuar ainan iniak: “¿Ayamtai tsawan tsawaru aisha iturmainaita? ¿Pegkerchau takaakrik pegker takatsuk inaimainkait? ¿Ayamtai tsawan tsawarai tusarik, shuar jakaisha jakati tusarik inaimainait? ¿Pegker amajmainchaukait?” tusa tinaiti. Nu tusa tamasha nitaka aikcharu. ");
INSERT INTO hubNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Nuna taku Jesúska shuar ainanka kajek iisu, turayat shuar antutan nakitaina asarmatai, wake mesemar nekaprau. Nuna tumayat shuar uweje chuirun chicharuk: “Kunturam nakuekta”, tusa tinaiti. Nu tama kunturin nakueku. Nu turamuik uwejegka pegker jasuiti. ");
INSERT INTO hubNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Nuna turamtai, fariseo ainaka Jesús mantamnati, tusar Herodes weantu ainajai chichaman umikartasa jiintraruiti. ");
INSERT INTO hubNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Tumainai Jesúska ni unuinatairi ainajai iruunar kucha tsukintrin wuwaiti. Tumamtai Galileanmaya shuar aina tura Judeanmaya shuar ainasha nukap patatukaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jesús nui wekaas nukap iwainaka takámun antukar Judeanmaya, Jerusalénnumia, Idumeanmaya, Jordán amain matsamin aina, Tironam, tura Sidónnum tiiju matsamin ainasha nitasha wainkartasa winitaina. ");
INSERT INTO hubNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Imanina asamtai shuar aina chanuntawarai tusa, Jesús ni unuinatairi ainan chicharuk: “Bote shir umikrum inanastarma”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Jesús shuar ja ainan nukap pegker amajsau asamtai, ashi shuar ja ainaka nina antigkartasa kakanmamaina. ");
INSERT INTO hubNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Iwanch egkemtuamu aina Jesúsan wainkar ni emtin tikishmatrar, senchi chichainak: “Ameka Yuusa uchiriyaitme”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Turasha Jesús nitan chicharuk: Shuar aina ashi antuinamunmagka turutirpa tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Nuna tura Jesús nain waka ni wakeramu ainan etegkar yaruaku, turam nitasha nijai nainnum wakaru. ");
INSERT INTO hubNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Nui nainnum doce shuaran yaruak: Atumka winau unuimartarma, tumarum wina chichamur etserkatarma tusa akupkatnurin etegkrauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Tura iwanch shuaran egkemtuasha jiiktarma tusa senchimtikkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Jesúsa unuinatairi doce ajakarua nuka ju ainawai: Simón, Jesús Pedro atá tina nu, ");
INSERT INTO hubNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jacob, Juan, mai Zebedeo uchiri, Boanerges tutai ajakarua nu, (Boanerges ta nunaka ipamta uchiri taku tawai). ");
INSERT INTO hubNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Tura Andrés, Felipe, Bartolomé, Mateo, Tomás, chikich Jacob Alfeo uchiriya nu, Tadeo, chikich Simón ni nugken agkanmamtikattsa chichamru jakua nu, ");
INSERT INTO hubNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Judas Iscariote Jesúska tu achikrum maatarma tusa shuar ainajai chichaman umirkauwa nu, imajin ajaku ainawai. ");
INSERT INTO hubNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Nuna umik nainnumia akaiki, Jesúska ni unuinatairi ainajai jea waya. Tumamtai ataksha imanisag shuar iruunturar, yurumkancha yumain amajainachu. ");
INSERT INTO hubNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Nuna antukar ni patai aina enentaimkachu jas wekatsuash, tusar jukiartasa weriaru. ");
INSERT INTO hubNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Nuiyasha chicham umiktinan jintinkartin Jerusalénnumia kaunkar, Jesúsan pachisar chichainak: “Iwanchi apuri Beelzebú naartina nuna senchirijai iwanchnaka jiiyawai”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Tuinakai Jesús nuna antuk, nitan untsuk aujmatmaun pachis chichaak: “¿Urukakug mai iwanchkisha jinaimainaita? ");
INSERT INTO hubNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Shuar nuu nugkanmag matsatiat, nitak maani matsatkugka, megkamain ainawai. ");
INSERT INTO hubNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Tura chikichnasha titajai: Shuar nu jeanmag iruunar matsatiat, maani matsatkusha nitak megkamain ainawai. ");
INSERT INTO hubNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Numamtuk iwancha ni senchirin wina surak, shuaran iwanch egkemtua ainan jiirati turutkugka, nigki ninurinka tupanmainaiti, tumak ni senchirinka megkamainaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Chikichik shuar kakaram, jeen kuitamuk, waitinam wajakaisha, ¿itursaya kasa wayasha warírincha jurumainaita? Nuna juruktaj takugka, yama nagkamchakka shuar jeen kuitamuk wajaun jigkar ajuan, nui jurumainaiti, nuna turutskeka jurumaitsui”. ");
INSERT INTO hubNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Nekasa tajarme: “Shuar aina tunaun takainak, tura pegkerchau chichainasha nuka ashi tsagkuram artinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Turasha Wakan Pegkeran pachisar pegkerchau chicharainaka, nuka pegkesha tsagkuram achartin ainawai, tuma asar nuna tiaruka waittan jukiartin ainawai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Nunaka Jesúska Wakan Pegkera nujai takaanak, iwanchin senchiriya nujai takaawai, tamau asa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Nuna tusa inagnaka ai, Jesúsa nukuri ni yachi ainajai Jesúsan wainkartasa kaunkaru, tumawar aag iruuntsar nui ujatruktarma tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Nu tama nui irunu Jesúsan ujainak: “Amina nuku, yatsum aina tura umaim ainajai eatmainak tawar, aa irunui”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Tusa ujam ni chichaak: “¿Wina nukur tura yatsur ainasha nekascha yaita?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Nuna tina nui irunun iis chichaak: “Wina nukurka, tura wina yatsur ainasha ju ainawai. ");
INSERT INTO hubNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Wina yatsur, wina umaar tura wina nukur ainaka Yuus wakeramua nunak takaina nu ainawai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Nuiya jiinki Jesús shuar ainan jintintaattsa kucha tsukintrin wuwaiti. Tumakai shuar ni pujamunam nukap kaunkaru. Tumawarmatai Jesús botenam egkemar nui ekeemsamtai, nu imanik shuar kaunkaruka yaikminam iruuntraru. ");
INSERT INTO hubNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Tumawarmatai aujmatmaun pachis jintinkartau asa, arakan arakmaun pachis chichaak: ");
INSERT INTO hubNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Jusha shir antuktarma. Arakan arakmau arakan jigkain juki, ajariin nagkimak ikuuttsa wuwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Tuma we ajariin araka jigkain nagkimak ikuknaiti. Nu arakan jigkai nagkimam jintanam kakekaruiti. Tumanka chigki kautak amukuiti. ");
INSERT INTO hubNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Chikichka nugka kayarnunam kakekaruiti, nu tumawaruka wári tsapakaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Turasha etsa etsantuk kagkape init achimrachu asamtai, aesak ijinawaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Tura chikich ainaka jagki irunmaunam kakekaruiti, tuma nusha tsapainiartatmaun jagki tsapainak yutuawaruiti turam jinawaruiti. Turamu asa arakka nerekcharuiti. ");
INSERT INTO hubNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Turasha nugka pegkernum kakekaruka shir tsapainiar, chikichik jigkai iyaaruitiat nukap nerekaruiti. Tuma asa chikichkitak treinta jigkain, tura sesenta jigkain, tura cien jigkain nerekaruiti, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Nuna ashi jintinkartua ashimak chichaak: Wii taja nuka shir enentaimsarum iistarma”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Nuna tina inagnakmatai chikichka shimuinai ujumak shuar juakaru. Tumawaru ai ni unuinatairi aina ininak: ¿Arakan arakmau pachisam jintinkartam nusha wari takumea timame? isha shir nekaattsar wakeraji, ujakratkata tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Nu tama Jesús nitan chicharuk: “Atumka winau asaakrumin, Yuus inammaurin pachisan timaj nunasha nekamtikramattsa wakerutmarme. Turasha chikich ainaka nuna takumpapi tawa tusarka nekamain ainatsui. ");
INSERT INTO hubNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Wii nukap iwainaran pegker takámun wainainaksha, wainmachua numamtuk jainawai. Tura antuinaksha nunapi taku tawa tusarka enentaimas iiyainatsui. Nuna tumainak nita tunaurin inaitan nakitaina asar, tsagkurachmau ainawai”. ");
INSERT INTO hubNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Junasha chichaak: “¿Atum ju aujmattsa tamausha antatsrum aniatirmesha wii chikichan aujmattsan takaisha, uruk antuktatrumea? ");
INSERT INTO hubNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Yuusa chichamen etserna nuka arakan arakmauwa numamtinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Araka jigkai jinta kakekaun chigki kautak amuku timaj nunaka, shuar Yuusa chichamen antukiat, enentaimtutsuk pujaun iwanch tari Yuusa chichamen antukmaurin kajinmamtika nuna takun timajai. ");
INSERT INTO hubNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","17","Arakan jigkai nugka kayarnunam kakekaruka nugka nukapchau amaunam wári tsapainiartatmaun, etsa etsantuk arakan kagkape init achimrachu asamtai, etsa sukua aeskau timaj nunaka, ujumak shuar aina Yuusa chichamen antukariat inaiyaina nuna takun timajai. ");
INSERT INTO hubNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","19","Tura araka jigkai jagki iruunmaunam kakekaru timaj nunasha, shuar aina Yuusa chichamenka antuinayat, nitak tsanumainak wiakchamartsuk shir pujumainaitti tu enentaimaina asar, wiakchamattsar ima senchi wakeruina nuna takun timajai. Ashi ju nugkanmaya warí aina nu chicham pegker antukmaunka emegkawai. Tumau asamtai wakannumsha tsakatsuk tunaamainawai. ");
INSERT INTO hubNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Antsu araka jigkai nugka pegkernum kakekaru jinutsuk, ashi imanisag shir tsapainiaru asar, neretnasha imanik nerekaru timaj nunaka, ujumak shuar Yuusa chichamen shir antukar nekaspapita tuina asar, iturchat aruinamsha umamkesar, nepetak pujuina nuna takun timajai. Ujumchik shuar treinta, sesenta, cien jigkain nerekarua numamtincha ainawai”. ");
INSERT INTO hubNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Junasha chichaak: “Lamparín ekeemakrika peaka awamtakrin apujsattsarka ekeemashtaiya. Ekeemakrika jean ashi tsaaptin amajsati tusa, yaki ekentaiya. ");
INSERT INTO hubNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Numamtuk tunau takasa uukmau ainaka wantintsukka asashtin ainawai. Chikichik uukmauksha tuke nekaachmauka asashtin ainawai. ");
INSERT INTO hubNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Atum antutairi aramutirmeka antuktarma”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Nuna tajarum nu shir antuktarma. “Shuar nuna chichaman antukar, nekaspapita tuinanka chicham antukmaunka Yuuska emegkaattsuk nu nukap nekamtikatnaiti. Antsu shuar chicham pegker etsermaun antukaruitiat, uminachunka emegkaatkatnaiti”. ");
INSERT INTO hubNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Nukap aramunka Yuuscha nu nukap susatnaiti. Antsu ishichik aramuka ashi atantra inaiyam atinaiti, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesús junasha chichaak: “Yuusa inamtairiya nuka shuar arakan arakmaujai meteketi. ");
INSERT INTO hubNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Arakan árak ikuak pachitsuk kaninaiti, tuma tsawaar nui kintamar, araka jigkai araamuka pugkai tsakauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Nugka nigki tsapamtikmau asa nuka tumauwaiti. Yama nagkamchakka kagkajiya tsapauwaiti. Tumamtai wachiri jinnaiti. Wachiri takiarmatai payagkrinak nui jigkairinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Jigkai katsuar tsamakmatai, tsawan juumain jeaamtai juuwaiti”. ");
INSERT INTO hubNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Junasha Jesús jintinkartak: “¿Atumnasha Yuus inammaurincha warijai apatkana Yuuska tu inamui tusancha ujamainaitjarme? ");
INSERT INTO hubNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Yuus inammauka mostaza jigkai nugka aratia numamtinaiti. Ashi nugkanmaya araka jigkai aina nuiya ima shikapchichika mostaza jigkaiya nuwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Tumauwaitiat tsakak uun kanaknarin tsakauwaiti. Tumamtai chigki nanamainaksha nuna wakentin mikintunam ayamainawai. Numamtuk Yuuscha ishichik shuarnum inamtan nagkama nukap amajeawai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Nuna tusa Jesúska chikichan pachis ju aina jumamtinjai nita antumainan nukap jintinkartu jakuiti. ");
INSERT INTO hubNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Aujmatmaun pachis tutsukka jintinkartu jakchauwaiti. Turasha ni unuinatairi ainan nuna takun tajai tusa ashi uja jakuiti. ");
INSERT INTO hubNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Nu tsawantaik kintammaunam, ni unuinatairi ainan chicharuk: “Kucha amain wearmi”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Tusa takai Jesúsan jukiar, amain wenak chikich ainanka ajapa ikukiaru. Jesús amain ni unuinatairi ainajai weakai, shuar aina chikich botenmasha nemarkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Tuma wenai, nase senchi nasentuk kuchancha imanik tsukatmamtikuk, botenam entsan senchi yara. ");
INSERT INTO hubNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Turasha Jesúska bote sukiin jaanchin atamruk kanar egkemtatmaun ishintainak: “¡Jintinkartina! ¿Ameka ii wayaj nuka pachikrattsumek?” tusar tuina. ");
INSERT INTO hubNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Tusa tuinakai nantaki nasen kuchajai chicharuk: “¡Mijaakta!” tusa tinaiti. Nu tutai nasegka kuchajai ashi mijaakuiti. ");
INSERT INTO hubNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Nuna tura ni unuinatairi ainan chicharuk: “¿Urukakrumea imanikrumsha ashamarme? ¿Atumka winaka nekaspapita turuttsurmek?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Nu tama antukar nuiya sapijmakar, nitak chichainak: “¿Ju shuarsha uruku asamtaiya, nasesha, tura nayantsasha ni chichamurincha umirainawa? tusar nitak”, tunaiyaina. ");
INSERT INTO hubNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jesús ni unuinatairi ainajai kucha Galilea tutai amain nugka Gadaranam katigkaru. ");
INSERT INTO hubNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Nui anumak kanunmaya jinai, shuar iwanch chumpimtuamu jakau ikutainmaya taruntu. ");
INSERT INTO hubNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Nu shuarka jakau ikutainam puju, cadenajai jigkaar emetatajkama tujinkamu. ");
INSERT INTO hubNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Cadenajai uwejnum, tura nawenam jigkarmasha imatiksag tsuriakai ashi tujinkamu. Tuma asa pegkesha emetmainchau jas weká. ");
INSERT INTO hubNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Tuma asa tsawaisha, káshisha jakau ikutainam, tura nainnumsha wekaas, tuke shinu weká, kayajaisha ijuuma weká. ");
INSERT INTO hubNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Imani wekainaitiat Jesúsan wainak tsekenki jeari, ni emtin tikishmatar, ");
INSERT INTO hubNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","senchi untsumuk: “Jesúsa, Yuus ashi nagkakartakua nuna uchiriya, ¡Yuus antai tajame, wait aneasam waitkarsaipa!” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Nigka nunaka Jesús chicharuk: “Iwanchi, jiinki weakum nu shuarka agkan ikukta”, tamau asa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Nuna takai Jesús chicharuk: “¿Amina naarmesha yaita?” tusa iniam, ni ayak: “Ika untsuri asar, ina naarigka Untsuriyaiti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Iwanch ainaka Jesúsan senchi seainak: “Wait aneasam, jiikratkumsha, yaja chikich nugkanmagka ishikrattsuk, ii pujaj juig inaikartusta”, tusar tuina. ");
INSERT INTO hubNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Tusa nui tiijuch nainnum kuchi untsuri yutairin yuinak irunu asamtai, ");
INSERT INTO hubNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","iwanch aina chichainak: “Ju shuarnumia jiikratkumnaka, au kuchi iruna ai utsaanatji”, tusar seaina. ");
INSERT INTO hubNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Tusa tama Jesúscha: “Ayu, wetaarma”, tusa tinaiti. Nu tusa tima, shuarnaka ikuinak, dos mil kuchi irununam utsaanawaru. Tura iwanch utsantuam, kuchisha pisarar metsagkrukmaunam utsaana kuchanam iiyagkar ashi jinaawaru. ");
INSERT INTO hubNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Tumawarmatai kuchi kuitamin shuar yaaktanam matsatun, jeashat matsamin ainancha: kuchi tuma jinayi tusar ujakartasa shiakaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Tumawar Jesús pujamunam kaunkama, iwanch chumpimtuamu asa, yaunchukka aya wekain jaanchin nugkur, shir enentaimkau jas Jesúsai ayaamas eketun wainkar senchi ashamkaru. ");
INSERT INTO hubNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Tura nuna wainkaru aina iwanch chumpimtuamu pegker jas ekeemmayi, tura kuchisha jinaawarmai, tusar chikich ainancha ashi ujakaru. ");
INSERT INTO hubNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Nuna antukar Jesúsan jeariar chicharainak: “Wait aneasam, chikich nugkanam wetá”, tusar tuina. ");
INSERT INTO hubNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Tusa tama Jesús weak botenam egkemkai, iwanch chumpimtuamu pegker amajsamusha chichaak: “Wisha Ame weam nui winitjai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Turasha Jesús chicharuk: “Yuus amina wait anentramra nu pachisam, pujutairmin waketkim pataim aina ujakarta”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Nu tima waketki, Decápolisa yaaktarin Jesús ni pegker amajsamun pachis etsertan nagkama. Tumakai ashi shuar nuna antukar enentai jearcharu. ");
INSERT INTO hubNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jesús ni unuinatairi ainajai botenam chumpimar, kucha Galilea amain katigkarmatai, nukap shuar iiyaku tuarkaram, kucha tsukintrinig pujusaru. ");
INSERT INTO hubNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Nui pujai judío iruuntai jea apuri, Jairo naartin, tajkama Jesúsan wainak, jeari tikishmatar, ");
INSERT INTO hubNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","senchi aujeak: “Wina nawantur pegke mayai ishinki tepaun ikukjai. Wina jearuisha wemi. Wait aneasam, ame ai tame wina nawantrusha uwejmijai antintrukta, turam nisha pegker jatrusti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Nu tama Jesús Jairojai wuwaiti. Tumakai chikich ainasha nukap shimuina asar, Jesúsnaka chanuina. ");
INSERT INTO hubNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","26","Nui chikichik nuwa nantu wainuk tsuakratin ainanam doce uwí wekaas, tsuwamak ashi ninu ainanka ashimak senchi waitaksha, pegker jaschau ayatik nu senchi ja wekain pachitkau. ");
INSERT INTO hubNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Tuma asa Jesúsan pachis chichainamun antuk, shuar irununmag eteemki, Jesúsa jaanchri tsakarin antigku. ");
INSERT INTO hubNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ni enentaimas, “wika Jesúsa jaanchrinkisha antinkanka pegker jamainapitja, tu enentaimu”. ");
INSERT INTO hubNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Tau asa nuna antiamuik numpa puwamunka nagkanak, ashi ni iyashi jamunka pegker jasu. ");
INSERT INTO hubNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Nu tumamtai, Jesúscha ni antigka pegker jasmaun nekapmamar, shuar ukunam wininan ayanmata chichaak: “¿Ya wina nugkutairuisha antinka?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Nuna takai ni unuinatairi aina chicharainak: “Shuar aina chanunmaina nuka wainchau asamek ¿wina nugkutairuisha ya antinkayi tusamsha tame?” tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Nu tamasha Jesúska yáki antinka tusa wainkattsa, ukurin ayanmata ashi iiya. ");
INSERT INTO hubNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Tumakai nuwa nuna nugkutairin antig pegker jasuka, senchi ashamak kurakmaikia Jesúsan jeari tikishmatar, waitrutsuk chichaak: Wii antigmajme tusa uja. ");
INSERT INTO hubNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Nu tusa ujam chicharuk: “Nawanta, ameka ayatik antiamuikiapi pegker jastatja tu enentaimu asam, pegker jasume. Tuma asam shir aneasam wetá. Yamai nagkamsamka jatsuk pujustatme”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Nuna tusa chichaa wajai, judío iruuntai jea apuri jeen matsamin tariar, Jairon chichaman ujainak: “Amina nawantrumka yamaika jakamai. Jintinkartinka aantram waitka wekaatsuk ikukta”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Nuna tuinakaisha Jesúska pachitsuk inaiyak, nawantrinnun chicharuk: “Kuntuts enentaimipa, antsu wina nekaspapita turutta”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Nuna tusa shuar ainanka ikuak, Pedron, Jacobon, Juankan Jacobo yachiya nujaig juki wuwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Tuma apu jeen jeak, nukap shuar senchi pampainai, úttancha imanik útu matsatun wainkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Imatu amaunam jea wayak: “¿Urukamtai ima pampainarme? Imanikrumka útirpa, nuwachika jakachai, ayatik kanar tepawai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Nuna takai chikich ainaka Jesúsan wishikraruiti. Turasha ashi nui matsatainanka aa jiir, nuwach jakaun nukuri nuna aparijai juki, nuiyasha ni unuinatairi ainan yaruak, nitajai nuwa jaka tepamunam utsaana. ");
INSERT INTO hubNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Tuma uwejnum achik chichaak: “¡Talita cum!” tinaiti. (“Nunaka nuwachi amina tajame nantakta”, taku tinaiti.) ");
INSERT INTO hubNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Nu tusa tamauwaik nuwa, doce uwí aramu jakausha nantakug weká. Nuna tumamtai shuar ainaka enentai jearcharu. ");
INSERT INTO hubNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Turasha Jesús: “Chikichik shuarkesha ujakairpa tusa akattrau, tura yutai susatarma yuati”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jesús apu Jairo jeenia jiinki, Nazaretnum ni nugkeen waketkai, ni unuinatairi ainasha Jesúsjai shiakaru. ");
INSERT INTO hubNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Tuma ayamtai tsawan tsawaru ai, Jesús judío aina iruuntai jeanam Yuusa chichamen etserkattsa waya. Tuma etserkai, nukap shuar ni etsermaun antukar enentai jearchar chichainak: “¿Ju imatiksa jintinkartuatnuncha tuiyanak unuimaruita? ¿Tuiyana unuimaru asampa wainchatai ainancha iwainawa? ");
INSERT INTO hubNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ju shuar tablan takau, Marían uchiri, Santiagon, Josén, Judasan, Simónkan yachiya jama, juna umaisha jui ijai pujuina jama”, tusa tuina. Nuna tuina asar, iturchat enentaimaina asar, Jesúsan nekaspapita tumain nekapenachu. ");
INSERT INTO hubNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Tumainakai Jesús chichaak: “Yuusa chichamen etserna nunaka ashi shuar ainaka shir anentas anturin ainawai, antsu ni patai ni pujutairiya nuiyagka anturchau ainawai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Nuna tusa nuigka wainchatai ainanka iwainatsuk, ujumchik shuar ja ainan aya achikag pegker amajsau. ");
INSERT INTO hubNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Nita nekaspapita ticharu asarmatai, enentai jearchauwaiti. Nuna tuma nu nugkanmag tiiju yaakat iruunmaunam jintinkartu weká. ");
INSERT INTO hubNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Jesús nina unuinatairi doce ainan etegkar untsuk irumar chicharuk: Yujasrum chicham etserkatarma, tusa jimar jimaran apatak ishimuk, iwanch aina jiirtinnasha senchimtikauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Tura asa: “Jinta wesa atsumainka jutsuk, ima ushukrutaig jukitarma. Tura wampatcha, pansha, kuitcha jukirpa. ");
INSERT INTO hubNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Antsu zapatoka jukitarma, nugkutaisha jimarka jutsuk chikichik jukitarma”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Atum yujasrum yama nagkamchakrum chikichik jeanmag jeaakrumka nuig pujusrum, chikich yaaktanam weakrum ikuktaarma. ");
INSERT INTO hubNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Antsu chikichik yaaktanam jearmin atumin nakitramainak, atum chicham etsermauncha nakitainakaigka, jiinkirum ikuakrum, atumi naween tsetse irunu peatrarum nita wainai akaketkarum ikuktaarma. Nuka atumka ika chichamka ujamaitiatrum atum nakitrau asaakrumin, Yuus waittan suramsatnaitrume takurum turatarma, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Nuna timatai shiakar yujas shuar ainan chicharainak: Pujutrum yapajiatarma tusar tuina. ");
INSERT INTO hubNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Tura iwanch shuaran egkemtua ainancha jiirar ishimainak, ja ainancha muuknum aceitejai yakarar pegker amajaina. ");
INSERT INTO hubNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ashi chikich nugkanmaya ainajai, Jesúsan pachisar chichaina. Tumaina asarmatai, apu Herodes chichaak: “Juan imakratin mantamnawa nu senchirtin jas, nantakin asa wainchatai ainancha iwainawai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Herodes nuna takai, chikich chichainak: “Nuka Elías” yaunchuk “Yuusa chichamen etserujakua nu nantaki wekawai tuina. Tura chikich chichainak: Nuka yaunchuk Yuusa chichamen etseru jakarua numamtinaiti” tusar tuina. ");
INSERT INTO hubNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Tuinakai Herodes antuk chichaak: “Chichaman etsera nuka Juankaiti. Wii muuke tsupirkatarma tima, muuken tsupirak maawarmia nu nantaki tu wekawai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Nunaka nigki Juan maatarma timaunam Juankan maawaru asarmatai tinaiti. Yaunchuk Herodes ni yachi Felipe nuwen Herodías naartinan juruki nuatak pujakai, ");
INSERT INTO hubNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Juan chicharuk: “Apu, amina yatsumi nuwe jurukmeka nuatkam pujumaitsume”, tusa tutai, ");
INSERT INTO hubNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Herodías antuk kajek Juankan maattsa wakerayat, ");
INSERT INTO hubNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herodes: Juanka Yuusnumian chichaawai tusa ashamak, ni chichame wakerus antayat, nuna takumpapi tawa tusagka nekachuiti. Tuma asa ayatik cadenajai jigkar cárcelnum egkea inaisauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Tura asamtai Herodías Juankan yamaikiash maawaintaj tu enentaima pujai, Herodes ni akinamuri tsawarmatai jiistamuk, apu nijai takau ainan, suntara apuri ainancha, Galileanmaya apu ainajai ipa iruunar, yutai umikmaun yuinak eketainamunam, ");
INSERT INTO hubNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Herodíasan nawantri nui wayaa jantsemkai, Herodes nuna wainak senchi wakerukuiti. Tura irar ainasha imatiksag wakerukaruiti. Tumawaru asarmatai Herodes nuwan chicharuk: “Ame wari wakeram nu seatkumnaka, imatiksanak amastajme. ");
INSERT INTO hubNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ju nugkanam pujusan inamaj jukesha seatkumnaka, jimapetuk akankan amastajme”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Tusa tama jiinki we, nukurin jeari chicharuk: “¿Warinak seatja? tusa tinaiti. Tusa tama Juan imakratna nuna muuke seata”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Tusa tama nuwaka wári wakettsag wayaa chichaak: “Wári Juan imakratna nuna muuke tsupikam, platonam egkeram surusta”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Tusa tama apu Herodes wake mesemar nekapeayat, ashi ame wakeramu seatmaunka imatiksanak amastajme tau asa, ni ipaamurisha nu tusa anajmatmaurinka antukaru asarmatai, yapajimainchau nekapeak, ");
INSERT INTO hubNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","wárimas chikichik suntaran chicharuk: Weme Juankan muuke tsupikam, platonam egkeram itaata tusa akupkau. ");
INSERT INTO hubNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Tama cárcelnum Juan pujau asamtai, weri muuken tsupik platonam egker itaamtai, Herodes nuwan susau. Turam nuwa juki ni nukurin susauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Nu turamun Juankan unuinatairi aina antukar taruawar, iyashi jukiar ikusaru. ");
INSERT INTO hubNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Juankan turawaru ai, Jesúsan unuinatairi aina Jesúsjai iruuntrar, nita takasmauri ainan tura jintinkartuamuri ainancha Jesúsan ujaina. ");
INSERT INTO hubNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Shuar nuik kautkaruka waketainai, aya kautam yurumkasha yumainchau amajmau asa, Jesús nitan chicharuk: “Wearmi tumar agkan ik kanakiara ishichik ayamrarmi”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Turamu asa ni unuinatairinka yaruak botenam chumpimar nugka agkantunam wearu. ");
INSERT INTO hubNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Tuma Jesús weamun yaaktanmaya shuar ainasha wainkar, shimui shimuinakua, Jesús anumkatnunam, utsaanawar iruuntraru. ");
INSERT INTO hubNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jesúscha anumak botenmaya jiinkama nukap shuar tuak iruuntatmaun wainak, oveja nitak kuitamsacham yujauwa numamtukeapi ja yujainawa tusa wait anentrau. Tura asa Yuusa chichamen nukap jintintawaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Kia asamtai, ni unuinatairi aina jeariar chicharainak: “Etsa kiawai, juigka ika chikichik shuarkesha pujachmaunam kaunkaji. ");
INSERT INTO hubNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Tuma asamtai shuarka iishiakta, yaaktanam jeattak jea matsata ai jeaawar nita yuatnun sumakarti”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Tuinakai Jesús nitan ayak: “Atum nita yuatnuka susatarma”, tusa tinaiti. Tama nita aimainak: “¿Ii ainatik ai shiakar, jui nita yuawartin doscientos tsawan takasar jumainjai pan sumakar itamainait?” tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Nuna tusa tuinakai, Jesús nitan chicharuk: “¿Urutma panka takakrume? Nu iistarma”, tusa tinaiti. “Tutai shiakar pan cinco, jimarchik namakjai aun iisar ikuinak, Jesúsan jeariar chichainak: Cinco pan awai, tura namakka jimarchik awai”, tusar ujaina. ");
INSERT INTO hubNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Nu tusa ujakam: “Shuar aina yaruakrum chirichri iruna nui akantrarum shir matsastaarma”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Jesús tusa takai shuaran cien, cien irumar matsaina, tura cincuenta, cincuenta irumrasha matsaina. ");
INSERT INTO hubNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jesús cinco pankan jimar namakjai juki wajas, nayaimpinmani pagkai Yuusan maaketi tusa, pankan puur, ni unuinatairi ainan shuar tinamkatarma tusa susau. Jimarchik namakan nunasha turusag puur ashi shuaran tinamkatarma tusa susau, turam shuar ainan tinamkaru. ");
INSERT INTO hubNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Tura tinamkaram shuar ainasha ashi yuawar ejémakaru. ");
INSERT INTO hubNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Tura pan namakjai ampintrauncha doce chagkinnum aimkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Nunaka cinco mil shuar aina yuawaru ainawai. ");
INSERT INTO hubNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Nuna ashi umikarmatai wárimas ni unuinatairi ainanka: “Botenam chumpir, kucha amain Betsaidanam katigtarma. Tusa ishimuk, nigka shuar ainan aujas ikuktasa juaku. ");
INSERT INTO hubNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Tura shuaran aujas ikuak aparin aujsattsa, nigki nainnum wakau. ");
INSERT INTO hubNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Tura kintamramtai, Jesús nigki kukar wajas, boteka kuchanam ajapean wean, ");
INSERT INTO hubNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","nase senchi nasentuk umpui aya awakeam, nasen nepetkiartasa senchi wiantainak waitainan wainkau. Tuke ima imaninakua tsawastatuk jai, nisha entsanam wekaas: Ayamsan tutupnik nagkamaktajai tusa wea. ");
INSERT INTO hubNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Tumattamaun wainkar chichainak: Wakaniapi winawa, tusar ashamainak untsumaina. ");
INSERT INTO hubNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ashi metek wainkaru asar ashamainam Jesús chichaak: Wiyaitjai, ashamrukairpa”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Tusa botenam egkemramtai nasesha megkakau. Nu tumamtai wainkar enentai jearcharu. ");
INSERT INTO hubNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Nunaka Jesús pankan namakjai puur ikaugka ajamamuncha shir enentaimtur iischaru asar tumawaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Kucha amain Genesaretnum jeaawar, boten jigkaawar aepenak, ");
INSERT INTO hubNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","botenmaya jinainaig Jesúsan wainkar, ");
INSERT INTO hubNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","ashi nu yaaktanmayan shimutkar, ja ainanka tepetairin patainiar, Jesús pujamunam ikaataina. ");
INSERT INTO hubNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Nita yama wayaamunmag yaakat shikapchichinam matsamnusha, yaakat uun ainanmayasha, jan yaruakar ikaatak jintanam matsasaru. Turawarmau asar Jesúsan chicharainak: Wait anenkarturta, amina nugkutairmin tsakarigsha antigka pegker jastasa wakeruinaji tusar tuina. Tura nuna antinaka pegker jasaru. ");
INSERT INTO hubNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Fariseo aina tura chicham umiktinan jintinkartin aina Jerusalénnumia kaunkaujai Jesúsan jeariaru. ");
INSERT INTO hubNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Tumakma tuke ikijmatai atii tusa timaun, Jesúsa unuinatairi aina umitsuk yuinan wainkaru. Turawar ikijmatsuk yuinawai tusar aujmataina. ");
INSERT INTO hubNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Fariseo ainaka, ashi judío ainajai nita uuntri, yurumak yutsuk shir ikijmara nui yutaiya tusa tu unuinarmau asar, ina uuntri turammauwa nuka sakatmatsuk, yamaiya juisha tuke turunati tuina asar nunaka tuina. ");
INSERT INTO hubNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Nitanka yutai surutainam wutiram jea taakrumsha, tuke ikijmasrumke ataarma timaunka, tuke umirsarke au ainawai. Nita umitairi ainaka ju nukapeti. Shikika umutai tsapa ainan, umutai yara ekentaincha, yurumak inartaincha, yutai chumpia ekentai jiru najanamuncha, peakri ainancha, ashi tuke shir nijasarke ajaku ainawai. ");
INSERT INTO hubNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Nitaka imatikaina asar, fariseo aina chicham umiktinan jintinkartin ainajai Jesúsan jeariar ininak: “¿Urukamtai amina unuinatairam ainasha, yaunchuk ina uuntri aina umijakmauwa nuna metek umitskesha, nitasha ikijmatskesha yuinawa?” tusar tuina. ");
INSERT INTO hubNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Tusa tama ni aimuk: “Yuusa chichamen etserin Isaías atum tsanumin ainatirmin pachis juna aak: ‘Ju shuar aina juka winaka ayatik nita chichamenig emematruinawai, turasha winaka enentaimturainatsui. ");
INSERT INTO hubNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Tumaina asar aantar wina pachittsar emematjai tusa turutainawai, nita jintinkartuina nunasha, chikich aina ju umiktarma tusa tu jakarua nunak jintinkartuinawai’. ");
INSERT INTO hubNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Atumka chicham umiktarma Yuus timauwa nuka umirtsuk inaiyakrum, atum timaurmek umiarme. ");
INSERT INTO hubNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Tuma matsatu asarum, chicham umiktarma Yuus turammauwa nuka imanchauch amajsa inaiyakrum, atumi uuntri timauwa nuke umiarme. ");
INSERT INTO hubNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moisés chichaak: ‘Atumi apari, tura atumi nukurisha chichame umirkatarma. Nina aparin, tura ni nukurincha pegkerchaun chicharuka, aya mantamnati’, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Turasha atum chichaakrum: ‘Shuarka ni aparinka, ni nukurinkisha: Wika yaimaitsujrume, ashi wina aruta juka Yuus anajmatamu asa, “Corbánkaiti”, tusa tumainaiti tarume’. (Corbán ta nuka warí ashi ima Yuusnau atii timau taku tawai.) ");
INSERT INTO hubNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Nu atum tarum nuka wika aparnaka nukurjai yaimaitsujai takurum tarume. ");
INSERT INTO hubNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Nu tuma asarum, chicham umiktarma Yuus timauwa nuka imanchau amajsarum inaiyakrum, atumin uuntri umitairi aina nuke umiarme, tura numamtuk chikich aina nusha takaarme”. ");
INSERT INTO hubNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Nuna tina shuar ainan untsuk, Jesús ataksha chichaak: “Shir enentaimsarum anturtuktarma. ");
INSERT INTO hubNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ashi yutai aina yuamua nuka shuarnaka ishichkisha tunauka amajmaitsui. Antsu shuaran tunau amaja nuka enentainmaya jina nuwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Atum antutairi aramutirmeka shir antuktarma”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Nuna tusa chikich ainanka ikuki jea wayaamtai, ni unuinatairi aina jeariar: ¿Ame yamai tame nusha wari takumea tame? tusar inina. ");
INSERT INTO hubNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Nu tusa iniam Jesús nitan chicharuk: “¿Atumsha chikich shir antuinatsu antsarmekek shir antatsrum? ¿Ashi yutai aina nuka enentainmagka waitsuk ampujnumag egkemaa, iyashnumia jiinu asa, shuarnaka tunau amajtsu nuka nekatsrumek?” tusa tinaiti. Yutai aina nuka ashi pegker ainawai taku tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","“Nuna tusa tina chichaak: Shuaran tunau amajuka enentainmaya jina nuwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Shuaran enentainia jina nuka ju ainawai: Pegkerchau enentaimat, nuwa wakerut, kasamat, magkartut, ");
INSERT INTO hubNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","nuwa nuatkamu takat, chikichnau aina wakerut, tunau aina nuke takastasa wakerut, anagkartut, nampektasa wakerut, chikichnau wakeraku kajerkartut, chikich aina tsanumrut, ememat, shir enentaimas pujuchu. ");
INSERT INTO hubNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Juka enentaimtainmaya ashi jinaina asar, shuarnaka tunau amajainawai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Nuiya jiinki yaakat Tiro Sidónjai jeantatak a nui wuwaiti. Tuma uumkataj tau asa jeanam waya, turasha ummainchau nekapea. ");
INSERT INTO hubNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Nu jeanam Jesús pujai, chikich nugkanmaya, Sirofenicianmaya nuwa nawantri iwanch egkemturmau Jesúsan tari tikishmatar chicharuk: “Wina nawantrun iwanch egkemtua nu jiirturkita”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Tusa tama Jesús ayak: “Yama nagkamchakka Israel shuar ainan uchiriya yuawarti, uchi pankan yuina atankir, yawa suamuka pegkerchauwaiti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Nu tama nuwa ayak: “Ee, nuka nekasa tame, Apuru, turasha pegke yawaksha mesa wakenam wajasar, uchi pankan tsaik akakeamun yuwa jama”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Nuwa nuna tusa timatai Jesús ayak: “Yajau nuka tatsume. Yamaika jeemin wemainaitme. Iwanch amina nawantrumin pujurma nuka yamaika jiinki ikukni”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Nu tusa tama nuwasha waketki jeen jeaakma, nawantri iwanch egkemtuamuka pegker jas peaknum eketun wainkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jesús Tiro nugkanam pujau jiinki, Sidónnum weak, Decápolis nugkanam yaakat irununam nuke nagkamaki kucha Galileanam jeawaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Tumamtai nuiya shuar empekun chichachu pujun itariar chichainak: “Wait aneasam uwejmijai ju antintrukta”, tusar tuina. ");
INSERT INTO hubNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Tusar tuinakai Jesús nu shuaran akanak juki, ni uwejen kuishnum inua, usukijai inain antinkau. ");
INSERT INTO hubNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Tura wajan nayaimpinmani iimas mayairuk chichaak: “Efata” tinaiti. Nunaka “shuara kuishin uranta” taku tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Nuna timatai shuar empekusha kuishi uranin, tura inaisha nunisag pegker chichamain jasu. ");
INSERT INTO hubNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Nuna tura shuar ainan akupeak: “Chikichik shuarkesha ju pachisrumka ujakairpa”, tusa akatar akupkaru. Tura akupkarmaitiat nu nukap etseraru. ");
INSERT INTO hubNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Nuna tusar etserainakai, nukap shuar iruunturar shir enentaimsar iiyainak: “Ashi pegkeran takáwai, empekuncha pegker amajui, chichachuncha chichamtikui”, tusar tuina. ");
INSERT INTO hubNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Nu tsawantin nukap shuar iruuntraru. Turasha yumaintri atsurainakai, Jesús ni unuinatairi ainan untsuk ikaanak chicharuk: ");
INSERT INTO hubNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ju shuar ainaka yurumkan yutsuk tres tsawan wijai matsataina asarmatai, wait anentainajai. ");
INSERT INTO hubNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Wii yurumkan ayurtsuk nita jeen ishimmaka, jeashtanmaya kaunkaru asar, jeen jeatsuk pimpikiar jinumain ainawai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Tusa takai nina unuinatairi aina chichainak: “Turasha shuar atsamunam matsatutisha, ¿tuiya sumakria shuar ainasha ayurmainaitji?” tuina. ");
INSERT INTO hubNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Tusa tuinakai Jesús chichaak: “¿Atumsha urutma panka takakrume?” tusa tinaiti. “Takai: Ika ayatik siete pan takakji”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Tuinakai: “Shuar ainan nugkanam pujustarma”, tusa tinaiti. Tusa Jesús pankan juki, Aparin maaketi tusa aujas, puur ni unuinatairi ainan: Atum tinamkatarma tusa susaram, nita jukiar shuar ainan tinamkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Namaksha ishichik au asamtai, turusag Yuusan maaketi tina, nunasha tinamkatarma tusa takai shuar ainan tinamkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Turawaram ashi shuar metek yuawar shir aneasaruiti. Tumawarmatai pan, namakjai ampintraun siete chagkinnum aimkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Nuna yuawaruka cuatro mil shuar tumain ajakaruiti. Iman ainan ashi ayurak nui atak wainimi tusa ikuknaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Tura ikuki Jesús nina unuinatairi ainajai botenam chumpimar nugka Dalmanuta tutainam wearuiti. ");
INSERT INTO hubNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Nui jeaamtai fariseo aina tawar, Jesúsjai chichatan nagkamawaru. Tumaina asar anagkawar nekapsartasa chicharainak: “Nayaimpinmaya ii wainkachmau chikichik iwainakta”, tusar tuina. ");
INSERT INTO hubNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Tusa tuinakai Jesús mayairuk wajan chichaak: “¿Urukamtai ii wainkachmau iwainakta tusarmesha seatrume? Nekasan tajarme, atumnaka chikichik iwainamunkesha iwaintukchattajrume”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Tusa ikuak, ni unuinatairi ainajai kucha amain wetasa botenam chumpimraruiti. ");
INSERT INTO hubNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Nui wenak nita yumaintrinka kajinmatkiar, chikichik pannak jukiaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jesús nitan chicharuk: “Fariseo aina pan pachimtairi, tura Herodesa pan pachimtairi aina nusha shir enentaimrarum iistarma”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Nuna tusa takai nitak chichainak: “Ii pan jukichaj nui nunaka turamji”, tusar tuina. ");
INSERT INTO hubNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Nu tuinamun Jesús nekaa chichaak: “¿Urukamtai aya yutainmagsha enentaimrume? ¿Atumka eke antachu asarmek, shir enentaimsarmeksha iiyaatsrum? ¿Urukamtai shir enentaimtsurme? ");
INSERT INTO hubNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿Atumka, wainkurmesha nekatsrumek, tura antakrumsha unuimatsrumek? ");
INSERT INTO hubNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Wii cinco pankan jukin, cinco mil shuaran ayuramiaj nuisha, ¿urutma chagkinnuma aimkamiarme?” Nu tusa tama nita chichainak: “Doce chagkinnum aimkamiaji”, tusar tuina. ");
INSERT INTO hubNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Nuna tuinakai: “Wii siete pankan jukin, cuatro mil shuar ayuram, ¿ampintrausha urutma chagkinnuma aimkamiarme? Tutai nita aimainak: Siete chagkinnum aimkamiaji”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Nuna tusa tuinakai ni chichaak: “¿Nu turamu wainkayatrumsha eke nekatsrumek?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Nuna tusa wear Betsaidanam jeawaruiti. Nui jeawarmatai shuar wainmachun itariar chichainak: Uwejmijai ju antintrukta tusar tuina. ");
INSERT INTO hubNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Turam uwejnum achik juki, ninak akanki usukin juruki jinum yakar, jiin epetak awajas chicharuk: “¿Ishichkisha wainmamek?” tusa inia. ");
INSERT INTO hubNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Tusa iniam wainmachusha iimas chichaak: “Shuar aina númia nunin wekainan wainjai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Takai Jesús ataksha jiin epetkau, turam wainmachusha shir esetar iimas ashi shir paan wainmakuiti. ");
INSERT INTO hubNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Tumamtai ni jeen akupeak: “Yaaktanmagka wetsuk, amina wii pegker amajsajam nusha chikichik shuarkesha ujatsuk wetá”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jesús ni unuinatairi ainan yaruak, Cesareanam Filipos a nuna yaaktari aina nui wearu. Jinta wesa, ni unuinatairi ainan iniak: “¿Shuar ainasha winasha wari turutainawa?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Nuna tusa Jesús inimkai, nita aimainak: “Aminka Juan imakratin ajakua nuwaiti tusa turamainawai”. Tura chikich aina chichainak: “Elías” yaunchuk puju jaku nutsukaitti turamainawai, tura chikich aina chichainak: “Auka yaunchuk Yuusa chichamen etserin jina aina nuiya chikichik nantaki wekawai”, tusa turamainawai tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Tusa tama nitan iniak: “Turasha ¿atumsha winasha wari turutrumea?” tusa tinaiti. Jesús nuna takai, Pedro ayak: “Ameka Cristowaitme”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","“Nuna timatai Jesús chichaak: Wina pachittsarmeka chikichik shuarkesha ujakairpa”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jesús jintinkartutan nagkama chichaak: “Wika shuarnum akina asan, judío apuri aina, sacerdote apuri ainasha, tura chicham umiktinan jintinkartin ainasha ashi nakitainaku senchi waitkasa maam atinaitjai. Turasha tres tsawan asan nantaktinaitjai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Jesús nunaka paan iwainak takai, Pedro Jesúsan akanki chicharuk: “¿Urukamtai amesha tusha enentaimme?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Nu tusa tama Jesús ni unuinatairi ainan iis, Pedro Satanása numamtuk chichaa asamtai jiyak: “¡Satanása, jui wijai wajatsuk wetá!, ameka Yuusjai metekka enentaimtsume, antsu shuar enentaimtai enentaimme”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Nuna tusa ni unuinatairi ainan, chikich shuar ainajai ashi irumar chicharuk: “Wina nemartuktaj tautirmeka atum wakeramuka inaiyakrum nemartuktarma, tumakrum shuar aina mantamattsa wakerutmainakaisha, wii wakeramua nuka kashi kashinig takastarma. ");
INSERT INTO hubNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Shuar wii wakeramun takainan maattsa wakeruinawai. Tuma asamtai shuar wii wakeramun takatan nakitainawai. Shuar tumau ainaka Yuusjai tuke pujuschartin ainawai. Turasha shuar wii wakeramun takau ainan maataj tamaun nekauwaitiat wii wakeramun takau ainaka, Yuusjai tuke pujusartin ainawai. ");
INSERT INTO hubNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Shuar ashi nugkanmaya warí ainan ashi ninu amajeaksha, ni jakaigka ni waríriya nuka wakaninka uwemtikrumaitsui, antsu ni waríriya nuke waittanmagka umamainaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Shuar wakanin waittsai tusa uwemtikrattsa akikmamainka pegke atsawai. ");
INSERT INTO hubNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Atum wina chichamur pachisa chichat natsantrau akurminka wisha turusnak wina aparun tsaaptintrijai, nayaimpinmaya shuar pegker ainajai winaknasha natsantratnaitjarme”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Nekasa tajarme: “Atum jui iruntrum juiyatiram eke jatsuk pujakrumka, Yuus ninu ainanam uruk inamratnukit nu wainkatin ainarme”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Seis tsawan pujus, Jesús Pedron, Jacobon ni yachi Juanjai juki, nitajai iruunar nain wakaru, tuma nita emtin Jesús nina iimigka yapajina. ");
INSERT INTO hubNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Nina jaanchrigka wincha jasu. Ju nugka juiya shuarkesha imatika puju amamainchau puju jasu. ");
INSERT INTO hubNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Iman jasun Elías Moisésjai Jesúsan taruawar aujainan nita wainkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Nuna Pedro wainak Jesúsan chicharuk: “Jintinkartina, juigka yajau pujatsji, tres aak aakmakmi, chikichik aminu, chikich Moisésnau, tura chikichka Elíasnau atii”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Nunaka nigka wakerumainan wainak shir enentaimtsuk tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Nuna tusa taig, yuragkim yakiya juarki nitanka amuawaiti. Turam irunai Yuus yuragminmaya chichaak: “Wina uchir nekas anetairka juwaiti, nigki anturkatarma”, tusa tamaun antukaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Nuna taig iikma Jesús nigki wajattamaun wainkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Jesús ni unuinatairi ainajai nainnumia akak nitan chicharuk: “Atum yamai wainkaurum nu pachisrumka, wii shuarnum akinawaitaj nuna mantuawarmatai, nantatsaigka chikichik shuarkesha ujakairpa”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Nuna timatai nunak antukar chikichnaka ujatsuk inaisaru. Tumainayat nitak chichainak: ¿Mantuawarmatai jakau ayatan nantaktinaitjai ta nunasha uruk takug tawa? tusar ininaina. ");
INSERT INTO hubNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Tusar Jesúsan ininak: “¿Urukamtai chicham umiktinan jintinkartin ainasha, Elías yama nagkamchakka taatnaiti tusasha tuinawa?” ");
INSERT INTO hubNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Nuna tusa tuinakai Jesús aimuk: “Nunaka nekas tuinawai, Elías niya emak taa ashi umiktinaiti. ¿Chicham umiktin aarmausha shuarnum inamratnun pachischa waritu aarmauwaita aneaktsurmek? Nui chichakka waittsatnaiti, tura nakitam atinaiti tu aarmauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Turasha wii nekasa tajarme: Elíaska tayi, tumamtai chicham aarmaunam ta nunaka imatiksag shuar aina wakeruinamunka umirkarai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Jesús ni unuinatairi tres jukimujai waketkinaiti. Tuma jeajkama chicham umiktinan jintinkartin ainajaimak nukap shuar iruuntrar, ni unuinatairi ainajai jianinan Jesús wainkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Tuma irunu Jesúsan wainkar amikmawartasa tsekenkiar weruina. ");
INSERT INTO hubNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Tumainakai Jesús nu shuar ainan chicharuk: “¿Atumsha wari pachisrumea nitajaisha jianiarme?” tusa inia. ");
INSERT INTO hubNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Nuna takai nu shuar irununmaya chikichik ayak: “Jintinkartina, jui wina uchirun iwanch egkemtua chichachu amajtursamtai itaajai. ");
INSERT INTO hubNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Wina uchirua juna iwanch egkemtakka saun aapak, nain aesi, chichiptin amajmayi. Imatika asamtai amina unuinatairam ainan itarin chicharkun: Iwanch jiikrum ajaprakrum, uchi pegker amajtursatarma tusan timajai. Turasha nitaka jiiktajkama tujinkarmayi”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Nu tusa tama Jesús chichaak: “Nekaspapita turutchau ainata, ¿Wini enentaimtan unuimararti tusancha, urutma nukapea atumjai iruuntrancha pujumainaitja? Uchi jui itartitarma”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Takai uchin ejétiaru. Turai iwanch nu uchin pujurusha Jesúsan wainak, uchinka waurmamtikak nugka senchi ajiar, saun aapkau. ");
INSERT INTO hubNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Imatikakai Jesús uchin aparin chicharuk: “¿Urutma tsawanta junasha imatika pujurnaita?” tusa inia. Takai uchirtin ayak: “Uchichinak tuke imatika pujurnaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Iwanch auna aitkak jinumsha epeamnau amajnayi. Tura entsasha ajug maamnau amajnayi. Ame yaintrumainaitkumka, iwanch jiiki akupeakum pegker amajtursata”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Nuna takai Jesús chicharuk: “Yaintrumainaitkumka tusamka tiipa, shuar nekas Yuusapi turumainaita”, tusa taunka ashi turumainaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Nu tusa tutai uchi aparisha senchi chichaak: “Wika nunaka nekaspapita tajai. Tura wii imanisan nekaspapita tichamnau nekapeakaisha, ame yainkata wisha amini nekaspapita titajai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Nukap shuar iruunkai wainak, Jesús iwanchin jiyak: “Iwanch chichachu empeku wii yamai tajame. Jinkim weakum ju uchi ikuktá, tumamka atakka waketrukmeka egkemtuawaipa”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Tusa tama iwancha senchi chichaak jinki weak, uchinka waurmamtikak jakaujai metek ikukin. Turamtai shuar aina uchika jakayi, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Turasha Jesús uwejnum achika inankim uchisha wajasu. ");
INSERT INTO hubNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Nuna tura Jesús shuar ainan ikuak jeanam waya. Nui wayaamtai ni unuinatairi aina akanki jukiar ininak: “¿Urukamtaig isha iwanch jiiktajkamarsha tujinkamji?” tusar tuina. ");
INSERT INTO hubNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Nuna tusa tuinakai Jesús chichaak: “Iwanchka, junisrik pujusrika jiishtaiya, antsu yurumak yutsuk pujusa, Yuus aujkur jiitia”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Nuna tusa ikuak Galileanmani wearu. Nu weaksha Jesúska chikichik shuarkesha nekarawai tusa nakitu jakuiti. ");
INSERT INTO hubNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Tumak wekaas ni unuinatairi ainan chicharuk: “Wii shuarnum akinawaitaj junaka achirkar surutkartatui. Turutawarmatai winaka mantuawartatui, turasha jakancha tres tsawan asan, ataksha nantaktinaitjai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Nu tusa tamasha, nuna takumpapi tawa tusarka nekainachu. Tumainaksha arantuina asar iniascharuiti. ");
INSERT INTO hubNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Tumawar yaakat Capernaúmnum jeawar, Jesús ni unuinatairi ainan iniak: ¿Jinta winisrumsha wari chichamrimarme? tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Takaisha ¿ii ainaj juiyasha yáki apusha atinait? tusar jinta winisar tunainiaru asar, aimkacharuiti. ");
INSERT INTO hubNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Tumawarmatai ni unuinatairi ainan ashi untsuk, ikaanak chicharuk: Shuar chikichan nagkakau, ni apumataj tauka, chikich ainan ashi umirin amainaiti, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Nuna taku chikichik uchin juki achik wajas chichaak: ");
INSERT INTO hubNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Shuar wina anentuka ju uchia juninchinkisha shir anentas juaka, winasha turusag jurawai. Turasha ima winakka juratsui, antsu wina Apar akuptukua nunasha juawai. ");
INSERT INTO hubNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Nuna tusa takai Juan chichaak: “Jintinkartina, shuar amina pachitmas shuaran iwanch egkemtuamu ainan iwanchin jiiru wainkamji. Tura wainkar ijai iruunar wekaichu asamtai chichaakur: Ameka aitkatsuk inaisata, timaji”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Nuna tusa takai Jesús ayak: “Shuar wina naarun pachis iwanchin jiyaaka inaisata tiirpa. Chikichik shuarkesha wina naarun pachis iwanchin jiiki akupeayat, winaka pegkerchauka chichartumaitsui. ");
INSERT INTO hubNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Shuar ina kajertamchauka ina yainmaji. ");
INSERT INTO hubNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Atum wina nemartin ainatirmin chikichik shuarkesha entsan shikik umarta tusa, amasuka, nisha aantra suam atinaiti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Uchi wina nemartuktasa enentaimturaina nuna tunaun takamtikainaka, kaya uun jigkaar kuntejnum netua, nayantsa kunarin ajapeamua numamtuk artinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Atumin uweje tunaun takamtikramkaigka, tsupikrum ajapawa numamtuk tunau takat inaisatarma. Chikichik uwejek nayaimpinam wayawa numamtuk, tuke pujutia nui tunaurtinchau wayamuka pegkeraiti. Antsu jima uwejtin akurmeka ji kajinchaunam, akasha jinichunam pujusrum waitmainaitrume. ");
INSERT INTO hubNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Tumamain asarum atumi nawegsha tunaun takamtikramkaigka, tsupikrum ajapawa numamtuk tunau takat inaisatarma. Chikichik nawek nayaimpinam shutus wayawa numamtuk, tuke pujutia nui tunaurtinchau wayaamuka pegkeraiti. Antsu jima nawentin akurmeka ji kajinchaunam, akasha jinichunam pujusrum waitmainaitrume. ");
INSERT INTO hubNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","48","Tura atumin ji tunau takatnum enentaimtikramkaigka, nusha turusrumek chikichik jiimi ukuinkarum ajapawa numamtuk tunau takat inaisatarma. Chikichik jiijaig iimsa nayaimpinam wayawa numamtuk, Yuusa inamtairiya nui tunaurtinchau wayamuka pegkeraiti. Antsu jima jiintin akurmeka ji kajinchaunam akasha jinichunam pujusrum waitmainaitrume. ");
INSERT INTO hubNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Shuar yutain kaurai tusa weejai salamna numamtuk, Yuuscha pegkermamtikattsa ninu ainatincha nekapramas iirmastinaitji. ");
INSERT INTO hubNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Weeka jea jeatnuri aramu asa pegkeraiti. Turasha jea jeatnuri megkakamtaigka, chikichik shuarkesha wakerumaitsui. Ataksha waketki, jea jeatu wemainchau asamtai, ayatik juki aa ajapeam amainaiti. Atum wina nemartautirmeka weea numamtin ataarma. Tumau asarum chikich ainajaisha agkan shir anenaisrum pujustarma”, tusa Jesús tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jesús Capernaúmnumia jiinki, Judeanam jeaa entsa Jordán amaincha katigku. Tumamtai nuiya shuar tuarkam, ni jintinkartutairinka turusag jintinkartau. ");
INSERT INTO hubNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Nui jintinkartak wajattamaun, ujumchik fariseo aina ju iniasmi, warituk chichakat, tumamtai tsanumrurmi tusar jeariar ininak: ¿Uruk awa, shuarsha nuwencha ajapmainkait? tusar tuina. ");
INSERT INTO hubNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Nu tama Jesús nitan ayak: “¿Moisés aarmausha waritua?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Nu tama nita aimainak: “Moiséska atum nuwem ajapattsarum wakerakrumka, nuwa ajapeaku aatai aarum, nuwa susarum ikuktarma tusa turamnaitji”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Tuinakai Jesús nitan chicharuk: “Moisés turatarma turamiarua nunaka atum iturchat enentaimkurmin turamiaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Turasha yama nagkamchakka ‘Yuus aishmagkun nuwajai najanawaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Turamu asar shuar nuwenkugka, aparin nukurijai ikuak, ni nuwejaig pujumainaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Nu aishmag nuwajai apatnak chikichik iyashia numamtin jasartinaiti’. Nu timau asamtai shuar nuwenaka jimara tumauchauwaiti, antsu chikichkia numamtinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Yuus aishmagkun nuwajai apatkauwaiti, turamu asa shuarka nuwejaigka ajapnaimain ainatsui, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Nuna tusa ikukmatai jea jeawar Jesúsa unuinatairi aina Jesúsan ininak: ¿Nusha wari takumea timame?” tusar tuina. ");
INSERT INTO hubNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Nu tusa iniam Jesús chichaak: “Shuar nuwenawaitiat nuwen ajapa pujus, chikich nuwan nuatkugka, tunaun takak tumawai. ");
INSERT INTO hubNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Tura nuwasha aishrin ikuki, chikich shuarjai aishrinkugka, tunaun takak tumawai, tusa Jesús”, tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Nuna ashi tina inagnai, Yuus pujut pegkernum yaintrukti, tusar shuar uchirtin aina uchirin ni antintrukti tusar ikaatkaru. Turuinakai Jesúsan unuinatairi aina shuar ainan chicharainak: ¿Urukamtai Jesúscha waitkarme? tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Tuinakai Jesús wainak kajek chicharuk: “Tutsuk inaisatarma. Atum tusarum nuig uchi awakearairpa. Uun ainasha ju uchi wina nekaspapita turutaina jumamtuk, nekaspapita turutainakaigka nitaincha Yuuska inamrattsa wakerawai. ");
INSERT INTO hubNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Shuar Yuusa inamtairiya nui wayaattsa wakeruinaka uchi aina iturchat enentaimtsuk wina enentaimturaina imanisag enentaimturmain ainawai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Nuna tusa Jesús uchin yaruak ninii irumar chiki chikichik uchin achiak: “Yuus pujut pegkernum yainmakti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Tina ikukmatai shuar natsa tsekegki tari tikishmatar aujuk: “Jintinkartina Pegkera, ¿wisha pujut nagkanchaun jukimij tusancha urukmainaitja?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Nu tusa tama Jesús ayak: “¿Urukamtai winasha Pegkera turutme? Ima Yuusketi Pegkerka. ");
INSERT INTO hubNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","¿Chicham umiktin aarmauwa nui chichaak: Atumi nuwenchuka takasairpa, magkartuawairpa, kasamkairpa, chikich shuarkesha chicham tsanumrurairpa, atumi apari tura atumi nukurisha umirkatarma, tusa ta nusha nekamek? tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Tama shuar natsa chichaak: Jintinkartina, ame tame nunaka wika uchiich asanak ashi umikuitjai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Takai Jesús wait anenmain iisu, tura chicharuk: “Chikichik umimain arutramui. Ame jeemin wetá, tumam amina waríram arutrama nuka ashi surakum, kuitrinchau aina antramek tinamkam inaisata. Ame turamka nayaimpinam shir aneasam pujustinaitme. Tumatin asam wina nemartukta”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Tusa tama antuk nigka shir wiakach asa, wake mesek jiinki wuwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Tuma wematai Jesús nui irunun ayanmata iis, ni unuinatairi ainan chicharuk: “Shuar wiakach aina Yuusa inamtairin wayaataj tamauka shir iturchataiti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Nuna takai ni unuinatairi aina enentai jearcharu. Tumawarmatai Jesús awentsag chichaak: “Uchir ainata, shuar Yuusa inamtairin wayaattsa wakerayat, ni warírin ima senchi enentaimtauka shir iturchataiti. ");
INSERT INTO hubNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Auja waarin camello waig nagkamamainaiti. Turasha shuar wiakach aina nayaimpinam Yuusa inamtairinka yupichu waimain nekapenatsui”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Nuna takai ni unuinatairi ainaka enentai jearchar chichainak: “Iturchata imau aisha ¿yáki uwemratnaita?” tusar ininaina. ");
INSERT INTO hubNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Nuna tuinakai Jesús ni unuinatairi ainan iis chichaak: “Shuar iismaka juka iturchataiti, turasha shuar tujintaku turumainchaunka Yuus ashi turumainaiti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Nuna tusa takai Pedro ayak: “Turasha ii ainatika ina warí arutramainasha ashi ikuakur ame nemarkamji”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Nuna takai Jesús ayak: “Nekasa tajarme, shuar wina nemartak chicham uwemtikartina nuna etserkattsa, jeen, yachi ainan, umai ainan, aparin, nukurin, uchiri ainancha tura nugkejai ashi ikukin ainaka, ");
INSERT INTO hubNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","yamai ju nugka jui pujusar, waitainaksha jee ainan, yachi ainan, umai ainan, nukurin, uchiri ainancha ashi nita nugke ainajai nita ikukmaun inagkasar, cienka imania nukap jukiartinaiti. Antsu nugka meser nagkantina nui, pujut nagkanchaun jukiartinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Turasha yamai shuar eme anentai aina nuka aantar juakartinaiti, antsu yamaiya jui shuar eme anentsarsha iishtai aina nu ima senchi eme anentam artinaiti”. ");
INSERT INTO hubNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jesús ni unuinatairi ainajai Jerusalénnum wesa, ni emak wea. Tumakai nina unuinatairi ainaka enentai jearchamnau nekapena, tura chikich ukunam shimauka ashamaina. Tumainakai Jesús ni unuinatairi ainanka ashi yaruak, winaka turutawartatui tusa ujak: ");
INSERT INTO hubNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Yamai ju shimaj junisrik Jerusalénnum weaji. Ai jeamunam wii shuarnum akinawaitaj junaka jurukiar, sacerdote apuri ainanam, tura chicham umiktinan jintinkartin ainanam ejétiar surutkartatui. Turutawarmatai nita jurukiar, maawarti tusa judíochu ainanam surutkartatui. ");
INSERT INTO hubNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Tura wishikruinak, awattutnasha imanik awattuinak, usukruinak waitkaras mantuawartatui. Turasha tres tsawan tepesan, ataksha nantaktatjai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Nuna tusa timatai, Zebedeo uchiri aina, Jacob, Juanjai Jesúsan jeantar chicharainak: “Jintinkartina, wait aneasam ii seamtataj nuka, turusmek umikta”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Nuna tusa tuinakai Jesús chichaak: “¿Wari seattasrumea wakerarme?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Nu tutai nita chichainak: “Ame inamtairmin wakam ekeemsakmincha ii jimarti, chikich amina untsurmini eketai, chikich amina menarmini ekeemsar, ame etea ekeemsartasa wakeraji”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Nuna tuinakai Jesús ayak: “Atum wina seatrum nuka nekachiatrum seatrume. ¿Atumin nekapramainak waitkarmainakaisha, wii waittsataj imanisrumkek waitmainaitrum? ¿Tura wii jakattaj imanisrumkek jamainaitrum?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Nu tusa tamasha chichainak: “Ee, isha waitmainaitji”, tusa tuina. Nuna tuinakai Jesús nitan chicharuk: “Wii waittsataj imanisrumek waittaka waittsatnaitrume. ");
INSERT INTO hubNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Turasha wika ju wina untsuruini, tura chikicha ju menaruini ekeemsati tusanka tumaitsujrume. Antsu wina Apar ya ekeemsati tusag umikuita nuke ekeemsartin ainawai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Nu tusa tamaun Jesúsan unuinatairi chikich aina antukar Jacobon, Juanjai senchi kajerkaru. ");
INSERT INTO hubNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Nuna tumainakai ashi untsuk irumar chicharuk: “Atumka nekarme, ju nugka juiya apu ainaka, shuar ainan nitanu amajak ina matsamin ainawai. Nuna turuinak chichamnasha aya apuk anturnain ainawai. ");
INSERT INTO hubNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Turasha atum ainatirmeka nuka tumashtin ainarme. Atum apu atasrum wakerakrumka, chikich shuar umirin amainaitrume. ");
INSERT INTO hubNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Tura chichame anturtai atasrum wakerakrumka, chikich inatai amainaitrume. ");
INSERT INTO hubNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Wii shuarnum akinawaitaj nunaka shuar aina umirtukarti tusanka taachuitjai, antsu wika nita umirkun takarsattsan, nuna tumakun nita pujutincha uwemtikattsan tura nita ayamrakun wii mantamnattsan tawaitjai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Nuna tusa nui juakiar Jericónam jeawaru, nuiya shuar aina saatukam, Jesúscha nina unuinatairi ainajai iruunas weai, shuar wainmachu Bartimeo naartin, Timeo uchiri, jinta yantamen tanta, shuar nagkamainakai, winasha antrarmek kuit surustarma tusa seama eketu. ");
INSERT INTO hubNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Jesús Nazaretnumiaya nu jui tiiju winawai tamaun antuk, wainmachusha senchi untsumtan nagkama. Tumak: “¡Jesúsa, David weantu uchiriya, winasha wait aneasam wait anentrurta!” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Imatkai nui shuar irunu chichainak: Imattsuk takamtak wajasia tusar tuina. Nu tusa tamasha, nu senchi untsumuk: “¡Jesúsa, David weantu uchiriya, winasha wait anentrurta!” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Imatkai Jesúscha nui wajan chichaak: “Jui tantati untsuktarma”, tusa tinaiti. Nuna takai: “Pai, yamaika untsurmawai, arantsuk wajakim jui tantata”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Nu tama ni nugkuarmaunka awiik, nugka ajuan aepeak wajaki tsekegki Jesús wajamunam jeantu. ");
INSERT INTO hubNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Nui jeanmatai Jesús chicharuk: “¿Winasha warinma wait anentrurti tusamea wakerutame?” tusa inia. Tusa iniam wainmachu ayak: “Jintinkartina, wika paan iimtikriti tusan wakerajai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Nu tusa tama Jesús ayak: “Ameka wina nekaspapita turutu asam, pegker jasume. Tuma asam yamaika wetá”, tusa tinaiti. Nu tamauwaik, wainmachusha paan iimnaiti. Tuma Jesús weakai nisha nemarkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jerusalénnum jeattak yaakat Betfagé Betaniajai Olivosa naintri iinias a nui jeaa, Jesús ni unuinatairi jimaran akupeak: ");
INSERT INTO hubNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“Au yaakat a ai wetaarma. Tumarum jeaarum burro entsamkachmau yama tsaka waitinam jigkaam wajau wainkattarme. Turarum atia jukirum itartitarma”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Nu juarmin chikichik shuarkesha ¿urukamtai juarme? Tusa takaisha: Ina apuri atsuma asamtai juaji, turasha wári itattaji tusarum ikuktaarma, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Nu tusa tima, nitasha weriar iikma jinta yantamchirin waitinam tiiju jigkaam wajattamaun wainkar atina. ");
INSERT INTO hubNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Turuinakai nui shuar irunu chichainak: ¿Burrosha urukamtai atiarme? tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Nu tuinam nitasha, Jesús turamkurmincha titarma tusa timaunka imatiksag ujakaru. Turawaram pachitsuk inaisaru. ");
INSERT INTO hubNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Atia jukiar Jesús wajamunam ejéniar, nita nugkutairin burro tuntupeen ainkar shir umikarmatai, Jesús waka ekeemsauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Tuma weakai Jesúsan eme anentas iiyainak shuar nukap asar, nita nugkutairin awikar jintanam aitar umainai, chikich ainaka nukan tsupirar jintanam aitar umaina. ");
INSERT INTO hubNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Turuinakai shuar emak shimau, tura ukunam wininasha emematainak senchi chichainak: “¡Yuus akupturmakmau winitrama juka shir aneasa emematiarmi! ");
INSERT INTO hubNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Apu David weantunam akinawa nu shir anentsarmi. Turakur Yuuscha emematiarmi!” amajaina. ");
INSERT INTO hubNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jesús imatrusam Jerusalénnum jea, Yuus ememattasa iruuntai jeanmasha waya. Tuma etsa pegke aka asamtai, ni unuinatairi ainanka ashi yaruak Betanianam wuwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Tuma Betanianam kanar, tsawarmatai jiinkiar weamunam Jesús tsukaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Tuma wesa higueran shir nukarak wajaun wainak: Nere atsuash tusa jeari iiyajkama, nereti jeaachu asamtai, aya nukak jas atatmaun wainak, ");
INSERT INTO hubNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","chicharuk: “Amina neremnaka chikichik shuarkesha pegke yuashtin ainawai”, tusa tinaiti. Nuna tusa titatmaun ni unuinatairi ainasha antukaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Nuna timatai ikuinak Jerusalénnum jeaa Yuus ememattasa iruuntai jeanam waikma, shuar tagku surin ainan, tura nuna sumau ainajaimak aa jiir kuitan yapajin aina mesarincha shitaki akakek, pauman surin ainan ekeemtairincha turusag akakekuiti. ");
INSERT INTO hubNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Tura chikichik shuarkesha jutika suruinakka, juigka wayaawaraigka tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Tura jintinkartak chichaak: “Nina chichame aarmauwa nui Yuus chichaak: ‘Wina jearka ashi nugkanmaya ainasha wina seatainak iruuntai atinaiti tawai’. Nu tu aarmau aig, atumka Yuus emematku epeatin tagku chikich aina tsanuarum suakrum kuit atumnau atin jua asarum, shuar kasa matsamtaiya numamtuk amajsaurme”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Nuna timatai sacerdote apuri aina, chicham umiktinan jintinkartin ainajai nuna antukar, Jesús uruk achikrik maawaj tusar chichamruina. Turuinayat ni jintinkartamun shuar aina wakerusar anturaina asarmatai, nuna ashamaina. ");
INSERT INTO hubNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Turasha etsa pegke akakai, Jesúska ni unuinatairi ainan ashi yaruak yaaktanka ikuak wuwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Nui kanarar káshikmasar nagkamakma higuera kagkapeejai ashi kukar wajattamaun wainkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Tuman Pedro wainak Jesús nu numin chicharuk: Ame neremnaka chikichik shuarkesha pegke yuachartin ainawai timaun anearuiti. Tuma chichaak: “Jintinkartina, ame higuera nerekchatnaitme tusam ikukmam nu kukar waja au iisiana”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Pedro tusa tama Jesús ayak: “Yuusa nuke shir enentaimtustarma. ");
INSERT INTO hubNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ju nainta juna chikichik shuarkesha chicharuk: ‘¡Nainta, jui atsuk, nayantsanam wajata!’ tusa iturchat enentaimtsuk, nekas tumattawapi tusa tamaka tumamainaiti. Nunaka wika nekasa tajarme. ");
INSERT INTO hubNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Nui atum Yuus aujkurmesha, Yuusapi nekas ashi turattawa tusarum, ishichkisha iturchat enentaimtsuk takurmeka jukittarme tusan tajarme. ");
INSERT INTO hubNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Wina tunaur ainancha tsagkurturti tusarum Yuus seakrumka, atumjai kajernaikamu akaisha tsagkuratarma. Nu tumakrumnaka atumin apari nayaimpinam puja nusha seamka atumin tunaurincha tsagkurtamrattarme. ");
INSERT INTO hubNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Turasha atum kajernaikamujai tsagkurnaiyachkurminka, atumi apari nayaimpinam puja nusha atumin tunauri ainancha tsagkurtamrashtin ainarme”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Nuna tusa Jerusalénnum waketkiaruiti. Nui jeawar Yuus ememattasa iruuntai jeanam Jesúsan pujaun wainkar, sacerdote apuri aina, chicham umiktinan jintinkartin aina, judío apuri ainajai iruunar jeariar, ");
INSERT INTO hubNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ininak: “¿Ya amincha shuar jiira ishiakta tusa turamkaiya aitkame?” tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Nuna tuinakai Jesúscha chichaak: “Wisha atumin iniastajrume: ¿Ya Juan imakratnuncha akupkauwaita, Yuusak akupkauwait, turachkusha shuar ainak akupkauwait? ");
INSERT INTO hubNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Winasha nu ujatkatarma. Turutawakrumin yana chichamenia wisha jutikaja nunasha ujaktajrume”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Nu tusa tama utujimkar, nitak chichainak: “¿Wari titajik? Juannaka Yuus akupkauwaiti takurincha, ‘¿turasha urukamtai umirkachuitrume?’ turamtatji. ");
INSERT INTO hubNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Tura shuar akupkauwaiti” takurincha, ju shuar aina Juanka Yuusnumian chicharkartu jakuiti tuina asar, nita mantammain ainawai tunaina. ");
INSERT INTO hubNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Nuna tusar utujimkar Jesúsan chicharainak: “Yatsuk Juannasha akupkauwait nekatsji”, tusar tuina. Nuna tuinakai Jesúscha chichaak: “Antsu wisha yana chichamenia aitkaja nunaka ujakchattajrume”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Nuna tusa inaiyak, Jesús ataksha shuar ainan jintintiak: “Chikichik shuar ajariin uvan arakmak umik, shir tanishrauwaiti. Uva juuka ijuraa yumiri jukitnurincha najanawaiti, tura yaki waka árak iistintrincha watain najanawaiti. Imatika ashi shir umik, chikich shuaran eak: Atum juka kuitamrutatarma tusa ikuak, nigka chikich nugkanam wuwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Tuma pujus, uva juut jeaamtai, ni inatairin akatar akupeak: Ame weme jeaam uva winau amaina nu ajan kuitamin aina seata, tusa akupkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Turam jeattamaun aja kuitamainak matsatu achikar awa awatainakua pegke sutsuk awaigkiaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Turawarmatai ajartin inatairin chikichan ataksha akupkau, turam ajanam jeattamaun, nunasha muuknum kayajai tukurar, apujkar tura pegkerchau chicharkar awaigkiaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Nuna turawarmatai ajartinka chikichnasha inatairin akupkauwaiti. Turam ajanam jeattamaun nunaka maawaruiti. Antsu nuna maawarmatai, ataksha shuaran nukap ishiakuiti. Turawaram ajanam jearmatai, ujumchik shuaran ayatik awattrar awakenak, chikichnaka maawaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Nuna turawarmatai ima ni uchirig, ni anetairi juakuiti. Tuma asamtai junaka araantusartsuk iirtusarainta tusa akupkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Tura akupkam nusha ajanam winittamaun ajan kuitamin aina wainkar chichainak: ‘Auwaiti ju aja juna jukitnuka, nekas maa ajapar, juka inu amajsami’, tusar tuina. ");
INSERT INTO hubNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Tusar chichaman umikaru asar, apu uchiri winittamaun achikar maawar, ajan ikumtikiar ajapawaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Nuna tusa turawarua nusha ¿atumsha uruk enentaimrumea? Ajan kuitamin aina tuma matsatuncha, ¿ajartin winaksha iturmainaita? Ajartin winitkugka nunaka kajeg utsak, nu ajanka chikichan susa inaimainaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","¿Atumka chicham aarmauwa nuka ishichkisha aujsachukaitrum? Nuka tu aarmauwaiti: ‘Jea jeamin aina chikichik kayan nakitrar pegkerchauwaiti tusar ajapamua nu ima wakerumain jasai. ");
INSERT INTO hubNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Nunaka apu Yuus turayi, tuma asamtai ika shir enentaimtuinaji’. ");
INSERT INTO hubNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Nuna tusa timatai, judío apuri aina chichainak: Ina aujmattramas turamuk tu wekawai, tusar kajerainak achikar jukiartasa wakeruinayat, shuar nuna anturainak nukap tuakaru asarmatai ashamainak ikukiaru”. ");
INSERT INTO hubNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Tura ikukiar fariseo shuaran, tura Herodes shuar ainajai: Atum anagkeakrum Jesús chikichik inimmau pachisrum iniastarma, turamsha warituk aimkat timatai, chicham tsanumrurarmi tusar akupkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Turawaram Jesúsan jeariar chicharainak: “Jintinkartina, ameka chicham nekasa nuke etserme, chikich aina jintinkartamun pachisar pegkerchau chichainakaisha pachitsuk inaiyakum, shuar aina ashi metek enentaimtam nuka nekaji. Tuma asar amina iniajme: ¿Romanmaya apusha shuaran kuitrin yarurna ausha akimainashit? ¿Amesha uruk enentaimmea, atsaa akimainchaukait?” tusar tuina. ");
INSERT INTO hubNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Nu tama Jesúska anagkeaku tamaunka nekau asa chichaak: “¿Urukamtai winasha tsanura nekaprustasrumsha wakerutarme? Kuitcha urukua apusha suarme nu inaktursatarma, wisha iistajai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Nuna takai juki itarim wainak chichaak: “¿Jusha yana yapiya nakumkamuita, tura jusha yana naarimpa aarmauwaita?” tusa tinaiti. Jesús takai nita chichainak: “Juka Romanmaya apu Césara nunauwaiti”, tusar tuina. ");
INSERT INTO hubNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Nuna tuinakai, Jesús chichaak: “Apu Césarnauwa nuka nigki susatarma, tura Yuusnauwa nusha nigki susatarma”, tusa tinaiti. Nuna tusa takai enentai jearcharuiti. ");
INSERT INTO hubNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Nuna tuma waketrarmatai, saduceo ainasha Jesúsan weriaruiti. Nitaka shuar jakaru aina nuka nantarchartin ainawai, tusar tinu asar Jesúsan ininak: ");
INSERT INTO hubNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Jintinkartina, Moisés papiin aar ikurtamuk: ‘Shuar ni yachi nuweena uchin akiitsuk jakamtaigka, ni wajen juki, uchin akinmainaiti, tura ni yachin uchiriya nunin amajmainaiti’, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Chikichik shuar siete yachigmau ajakuiti. Tuma chikichik nuweenawaiti, turasha uchin akiitsuk jakauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Tumamtai ni yachi nuwen wajen jukinaiti. Tuma nusha uchinka akiitsuk jakauwaiti. Tumamtai chikishcha juki, uchinka akiitsuk jakauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Tuma tumainakua, sieteya nuka ashi jinaawaruiti. Imatikainaksha, chikichkiksha uchinka akiacharuiti. Tura aishmag ashi jinaamtai, nuwasha jakauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Nu chikichik nuwanak nua nuatainakua jinaawarua nusha, ¿atak nantainamunmasha yáki jukitnaita?” tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Nuna tuinakai Jesús chichaak: “Atumka Yuusa chichamegka nekachu asarum, nina pujutairiya nusha wainkachu ainarum nui tu chichakurme. ");
INSERT INTO hubNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Jinaawaru nantarartin aina nuigka nuweenachartin ainawai. Nayaimpinmaya shuar aina Yuusjai tuke matsamin aina nujai metek artinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","¿Atumka jinaawaru aina nantartintri pachisrumka, númi keamunam Yuus wajas Moisésan wantiintuk chicharuk: ‘Wiyaitjai Abraham, Isaac, Jacob aina nuna Yuusrinka’, tusa tina nu Moisésan papirin aarmauwa nuka aujsachukaitrum? ");
INSERT INTO hubNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Nuna tau asamtai, jinaawaru taji nuka iwákuapi matsatua tuinaji, Yuuska jakau ainan Yuusrinchuiti, antsu iwáku ainan Yuusriyaiti. Tumau aig atum aantrarum chichau ainarme”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Chikichik shuar, chicham umiktinan jintinkartin, Jesús shuar ainan nuka tu awai tusa itatmamtikamun antuku asa jeari iniak: “¿Chicham umiktin aina nuiya yama nagkamchaku umimaincha tuwaita?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Nu tutai Jesús ayak: “Chicham umiktarma timau aina nuiya yama nagkamchaku umimainka juwaiti: ‘Israel shuar ainatiram, apu ina Yuusriya nuke anturkatarma, apua nuka chikichkiti. ");
INSERT INTO hubNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Tuma asamtai atumi apuri Yuusa nu ima senchi anetarma. Turakrum ima niinig enentaimsarum pujustarma, Yuusnau pegker aina nuke nekatarma, Yuus wakeramua nuke takastarma’. Yama nagkamchaku chicham umimainka nuwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Chikishcha nujai metekmamtinaiti. Nuka juwaiti: ‘Atumek anenmamsarum chikich shuar ainasha anetarma tu aarmauwaiti’. Chicham umiktin nuna nagkasauka chikichka atsawai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Nu tusa tima, chicham umiktinan jintinkartincha chichaak: “Jintinkartina, yajau turutchaume, ame wina turutam nuka nekasaiti. Ima chikichik Yuusak awai, chikich Yuus niya imauka atsawai. ");
INSERT INTO hubNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Amina apuram Yuusa nu ima senchi aneta. Turakum ima niinig enentaimsam pujusta. Yuusnau pegker aina nuke takasta. Yuus wakeramua nuke takasta. Tura chikich shuar ainasha ina iyashi aneaj turusrik aneta nuwaiti, ina tunaurin Yuus tsagkurtamratji, tusar tagkun maawar aesu jakaru aina nuna nagkasauka”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jesús nu shuar shir enentaimsa chichaamun anturak chicharuk: “Ameka Yuusa inamtairiya nui waitka namput jatsme”, tusa tinaiti. Nuna takai chikichkiksha Jesúsan inimain nekapsacharuiti. ");
INSERT INTO hubNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesús Yuus ememattasa iruuntai jeanam wayaa unuikartak pujus chichaak: “¿Urukamtai chicham umiktinan jintinkartin ainasha Cristoka David weantuiti tusarsha tuinawa? ");
INSERT INTO hubNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","David, Wakan Pegker chichamtikam: ‘Apu Yuus wina apurun chicharuk: Wina untsuruini ekeemsata, tumawakmin wii amina shuarum ainanka nepetkan, amini ikaankan matsastinaitjai’. ");
INSERT INTO hubNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","David Criston wina apur tujaku aisha ¿uruk asaya David weantusha amainaita?” tusa tinaiti. Nuna takai nukap shuar nui irunusha shir aneasar anturaina. ");
INSERT INTO hubNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesús shuar ainan jintintuk: “Atumka chicham umiktinan jintinkartin aina, jaanch asarman nugkurar yujatan wakerin aina tumau airum pe aneartarma. Nitaka yujainaksha, shuar ainasha emematrus shir amikmatawarti tusar wakerin ainawai. ");
INSERT INTO hubNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Iruuntai jeanam utsaanainaksha, ekeemtai pegker ainan etegkawar ekeemsattsa wakerin ainawai. Tura yurumak yuamunmasha pegker umikmaun yuattsar wakerin ainawai. ");
INSERT INTO hubNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Nuwa waje ainan jeencha atankiar, shuar iruuntramunam ajapeen wajasar, Yuus aujeaji, tusar nukap sea seainakua iku yujau ainawai. Nuna tuma yujau ainaka chikichan nagkasau Yuus waitat suam artinaiti”. ");
INSERT INTO hubNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yuus ememattasa iruuntai jeanam Jesús wayaa Yuusnau atii tusa kuit egketainam ikatsek ekeemas, shuar kuitan egkenakai iiyak eketu. Tuma eketai wiakach ainasha kuitan nukap chumpina. ");
INSERT INTO hubNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Tumainai nuwa waje wayaa nisha jimarchik jiru kuit cobre najanamun, imanis akikchaun egkea. ");
INSERT INTO hubNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Nuwa nuna egkeamtai wainak, Jesús ni unuinatairin untsuk ikaanak chicharuk: “Ju nuwa waje kuitrinchauwaitiat, ashi shuar egkena auna nagkasau egkeayi. ");
INSERT INTO hubNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Chikich egkena auka, kuit ampintraun egkenawai, turasha ju nuwa waje kuitrinchauwaitiat, ni sumasa yumaintrinkisha ampir ikutsuk, ashi egkeayi”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yuus ememattasa iruuntai jeanmaya jiinki Jesús wetatmaun nina unuinatairi aina chicharainak: “Jintinkartina, amesha kaya pegker ainajai jeamkamua ju iisiana”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Tuinakai Jesús nitan ayak: “Ju jeamkamu pegker waintrum juka imaniskeka achatnaiti, tura kaya aina auka chikichik kayaksha chikich kayanam patatuka achatnaiti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Nuna tusa ikuak, nain Olivos tutai, Yuus ememattasa iruuntai jeajai iinias aunam wearuiti. Jesús nui waka ekeemsamtai, Pedro, Jacob, Juan, Andrés nu aina jeariar ininak: ");
INSERT INTO hubNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Wait aneasam ujakratkata, ame timam nusha urutia nekascha tumatta, nu tsawan jeattak jakaisha, ¿wari wantiniartinaita?” tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Tuinakai Jesús chicharuk: “Chikichkiksha tsanurmarairum, pe aneartin ataarma. ");
INSERT INTO hubNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Nukap shuar wina naarun pachisar chichainak: ‘Wiyaitjai Cristonka’, tusar nukap shuaran tsanurartin ainawai. ");
INSERT INTO hubNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Maaniawartasa pampannaiyamu, tura maaninamu ashammain antitnaitrume. Tumakrumsha ashamkatin airpa. Yama nagkamchak nagkamartinka nu ainawai, turasha nugka mesera nagkanmauka nuchauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Nugka unnum matsamin ainasha mai imannumiag nagkamnaiyawar maaniartinaiti, nu iman tumainai nugka shikapchinmaya apusha mai tumaunumiag nagkamnaiyawar maaniartinaiti. Tura urtancha ashi nugkanam senchi urtinaiti. Tura tsukasha tepeatnaiti. Waitat yama nagkamnamuka nuwaiti”, tusa Jesús tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“¡Aneaku atin ataarma! Atumnaka judío iruuntairi jea aina nui awaintamawar asuttamawartinaiti. Apu chichaman epegkin ainanam, chikich apu ainanmasha, atum wina nemartuina asaakrumin, nui ejétamawarmatai, wina pachittsarum nitasha ujaktinaitrume. ");
INSERT INTO hubNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Nugka mesera nagkanmau jeatsaig, wina chichamur uwemtikartina nunaka, ashi nugkanam etserkartin ainawai. ");
INSERT INTO hubNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Atumin apunam juramainakaisha, apuncha warituk aujsataj tuka enentaimsairpa. Atumnaka nui ejétamawarmatai, nu titá tusa Yuus turamtatui, turamkai atum chichaktatrum nuka atumkeka chichakchattarme, antsu Wakan Pegkera nu chichamtikramkattarme. ");
INSERT INTO hubNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Tsawan jeakaigka maawarti tusar shuar aina ni yachinak anagka suriartinaiti, tura uchirtin ainasha ni uchirinak suriartinaiti, tura apartin ainasha ni aparinak shuarmawar maitin ainawai. ");
INSERT INTO hubNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Atum wina nemartin ainatirminka shuar aina ashi kajertamiartinaiti. Imatika kajertamainakaisha, atsantrarum winak nakarutirmeka uwemratin ainarme”. ");
INSERT INTO hubNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Yuusa chichamen etserin Daniel naartin, shir ashammainan pachis aarua nuna aujuka nekamainaiti. Nuka juwaiti: Atum nuna ashammainan pachis aarua nu Yuus ememattasa iruuntai jea pegkera nui waya wainkurmeka, Judeanam matsatutirmeka mura tsekemain ainarme. ");
INSERT INTO hubNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Jea jimara ekeni jeamkamunam pujuinasha, jenianka warírinka jutsuk jiinmain ainawai. ");
INSERT INTO hubNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Tura ajanam takainak yujainasha jaanchin jukitjai tusar jea wakettsuk, kuamkag tsekemain ainawai. ");
INSERT INTO hubNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Nu tsawan atina nui, nuwa ajapruktin aina nuna tura nuwa uchin jurertin aina nujai wait anentainajai. ");
INSERT INTO hubNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Tsetsek tepeamunam etsekeam airum Yuus aujsatarma. ");
INSERT INTO hubNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Yuus yama nugkan najanawa imanaisha imanika waitujakchamun, atakea nuisha imanika waittsashtinan nagkasau shir senchi waitamu atinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Nu waitat imanian Yuus imijtsuk imatiksag inaiyakaigka, chikichik shuarkesha uwemmain ainatsui. Turasha Yuus ni shuar etegkramu ainan wait anentak, waitat aya weanak imijkatnaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Atum ainatirmin chikichik shuarkesha chichartamuk: ‘Jui Cristo pujawai iistarma’, ‘ai Cristoka pujumai’ amajtamainakaisha nekaspapita titin airpa. ");
INSERT INTO hubNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Nukap shuar chichainak: ‘Wiyaitjai Cristonka’ tuinasha artinaiti. Tura chikich wiyaitjai chichaman ‘Yuus akatturmatai etsernunka’, tusa tinu ainasha wininak, shuar wainchatai ainan nukap iwaintuinak, shuar Yuus etegkramu ainancha tsanumain akaigka, chikich shuar ainajai ashi tsanurartin ainawai. ");
INSERT INTO hubNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Pe anearum pujustarma tusan, nunaka emtikan ujajrume”. ");
INSERT INTO hubNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Nu waitamu nagkamaig, etsa etsantsuk káshi jastinaiti, tura nantusha etsantrashtinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Tumai nayaimpinmaya ya aina kakeniartinaiti. Imanina asarmatai, nayaimpinmaya senchirtin ainasha ashi muchitrartinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Nu imani ai wii shuarnum akinawaitaj nuna wina senchirjai, shir tsaaptin jasan nayaimpinmaya yuragminam pachitkau winakai, shuar aina ashi waitkartin ainawai. ");
INSERT INTO hubNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Wii winaknaka wii etegkramur ashi nugka nagkattramunmaya aina yaruakrum ikaatruktarma tusan nayaimpinmaya shuar ainan ishiaktinaitjai”. ");
INSERT INTO hubNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Númi higuera tutai enentaimtusrum iistarma. Nu higuera nukarkamtai, atumka wári asat tepeattawai tusarum nekau ainarme. ");
INSERT INTO hubNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Numamtuk wii tajarum nu imanisag ashi uminkaigka, yamaika shuarnum akinawa nu tatinka ashi jeawapi titin ataarma. ");
INSERT INTO hubNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nekasa tajarme atak shuar matsamiartin aina nusha eke ashi jinuinatsaig juka uminkatnaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Nayaimpia auka nugkajai megkakatnaiti, turasha wii tajarum nuka imanisag uminkatnaiti”. ");
INSERT INTO hubNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Turasha wari tsawantaik, tura etsasha urutam aig tatinaitaj nunaka chikichkiksha nekainatsui. Tura nayaimpinmaya shuar tuke matsamin ainaksha nekainatsui. Tura wii Yuusan uchirinkisha nekatsjai, antsu wina aparuk nunaka nekawai. ");
INSERT INTO hubNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Nu uminkatnuka nekachu asarum, atumka enentaimkauk matsamsarum, Yuus auju matsamtarma. ");
INSERT INTO hubNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Nuka shuar chikich nugkanam wetin asa, eke wetsuk inatairi ainan yaruak ikaanak takatan akantur tinamak, waitin kuitamnuncha chicharuk: Shir aneaku pujusam kuitamata, tusa ikuak wuwa numamtinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Iimkau pujutarma, jennusha urutiak, etsasha uruka aig tati, kintamkumpash tati, tumachkusha ajampek jasa aimpash tati, tumachkusha atash shinaimpash, káshikmaspash tati nuka nekatsrume. ");
INSERT INTO hubNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Kanú matsatutirmin pachiachmau winak awaktamkairum, ");
INSERT INTO hubNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","junaka ima atumnakka tatsujrume, ashi shuaran takun tajai: ¡Iimkau, aneaku matsamsatarma!” tusa Jesús tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Jimarchik tsawan asa, jiisat Pascua, pan levadurajai pachimtsuk inaraamu yutaiya nu jiisat jeatin ai, sacerdote apuri aina, chicham umiktinan jintinkartin ainajai, Jesúsan anagka achikar maawartasa chichamruina. ");
INSERT INTO hubNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Turasha jiisat aigkika turachmi, shuar aina nuna akasmatainak jianaimain ainawai tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jesúska yaakat Betanianam Simón lepra tukumu pegker amajsamua nuna jeen pujau. Nui pujaun chikichik nuwa, botella alabastro najanamunam kugkuin pachimrachmau nardo tutai senchi ukugkuarmaun shir akikan sumak takus, Jesús mesanam eketun jeari, muuknum ashi ukatkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Nu turamun ni unuinatairi aina wainkar kajekaru, tumawar chichainak: “¿Urukamtai shir akiknasha aantrasha wasureawa? ");
INSERT INTO hubNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Au surukar trescientos kuit denario juki kuitrinchau ainan yaimainajama tusar nuwan pegkerchau chicharaina. ");
INSERT INTO hubNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Jesús nuna antuk nitan chicharuk: ‘¿Urukamtai atumsha ju nuwasha kajerarme? Juna ni aitka juka pegkerchaunka aitkatsui. ");
INSERT INTO hubNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Kuitrinchau ainaka atumjai tuke pujuartinaiti, nui nitaka atum wakeramuka tuke yaimainaitrume, antsu wii atumjaigka tuke pujuschatnaitjai. ");
INSERT INTO hubNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ju nuwa wina iyashrui kugkuinjai ukatrura junaka wii ikuntsatin asamtai aitkarayi. ");
INSERT INTO hubNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nekasa tajarme, ju chicham uwemtikartina juna ashi nugkanam yujasar etserainaksha, ju nuwa wina aitkara junaka ashi pachisar chichaartin ainawai’ ”, tusa Jesús tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Nuna tusa tinu ai, Jesúsa unuinatairi doce ainanmaya Judas Iscariote naartin, chikichik jiinki sacerdote apuri ainajai chichaman umik, Jesúsan suruktasa wuwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Tuma sacerdote matsatun jeari, tu achimainaitrume tusa shir etserkai, shir anenak kuitan akiktajme tusar tiaruiti. Tuinakai Judascha, uruk anagkanak surukaj tusa, enentaimtu weká. ");
INSERT INTO hubNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Pascua jiistamat nagkamnamunam, pan levadurajai pachimtsuk inarkamu yutai oveja maar aeseaku Yuus ememattai jeau asamtai, ni unuinatairi aina Jesúsan ininak: “¿Ju jiisat inagkakur, aagkuantai yuatnusha tui umiktatjia?” tuina. ");
INSERT INTO hubNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Tuinakai ni unuinatairi ainan jimaran akupeak chicharuk: “Wetarma, tumarum yaaktanam jeaakrum shuar ichignanam entsa shikik waketu wainkattarme, turarum nu nemarkirum, ");
INSERT INTO hubNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ni jea wayakai, jeentin chicharkurum: Jintinkartin chichaak: ¿Wina unuinatair ainajai iruuntran jiisat Pascuatin yumaintrusha tuwait?” tusa turamui titarma. ");
INSERT INTO hubNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","“Tusa tama ni jea yaki tesamu uuntan shir umikmaun isha ashi metek utsaanmainan inakturmastattrume, turutmamtai nui umiktarma”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Jesús takai nitasha ayu tusar wear, yaaktanam jeaakma ni timaunka ashi imatiksag wainkar, Pascuatin yuatnunka nui umikaru. ");
INSERT INTO hubNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Káshi jasmatai Jesúscha nina unuinatairi ainajai nu jeanam utsanawaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Tumawar yuinak iruunmaunam Jesús chichaak: “Nekasa tajarme, atum ainarum juiyag wijai yua nuke winaka surutkattawai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Nuna takai ashi nitaka senchi wake mesekar iruuntsar chiki chikichik chichainak: “¿Apuru, wikaitaj?” tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Nuna tuinakai Jesús chichaak: “Wina surutkatnuka chikichik platonmag wijai jimarak yua juwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Turasha wii shuarnum akinawaitaj nunaka wina pachittsar aararua nuna umiktasan werajai. Turasha shuar wina surutkatta nunaka wait anentajai. Nekas nigka akinmainchauntsuk akinawaitti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Eke yurumak yuaku iruunmaunam Jesús pankan juki, Yuusan maaketi tina puur nitan tinamak chichaak: “Ju yuatarma juka wina iyashrua numamtinaiti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Nuna tusa tinamak inaiyak, umutain shikikam eketun juki, nunasha turusag Yuusan maaketi tina nitan susau, turam ashi metek umararuiti. ");
INSERT INTO hubNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Tura ashi umararmatai chicharuk: “Juka shuar ainan nukap uwemtikrattsan wii mantamnakun numparun puartataj nuna iwainawai. Tura wina numparun puaran wii yamaram chichaman etseraj nunaka ashi umiktatjai. ");
INSERT INTO hubNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nekasa tajarme, wika ju uva neren yumiri ijuramua junaka atak awenanka umarchatnaitjai. Antsu tsawan uminkai, Yuusa inamtairin atumjai iruunkun umartinaitjai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Nuna tusa kantamtain kantamawar inagnak Olivosan naintrin wearuiti. ");
INSERT INTO hubNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Tumawar nui jea Jesús chichaak: “Yamai ju káshia juik atum ainatirmeka winaka ashi ajapa ikurkittarme, chicham aarmaunmasha aitkasag nunaka tawai: ‘Ovejan kuitamnun maawartinaiti, turawarmatai oveja ainaka kanarartin ainawai’ tu aarmauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Turasha ataksha nantakin, atumka Galileanam weatsrumnak wiyaa wetatjai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Nuna takai Pedro ayak: “Chikich aina ashi ajapa ikurmainakaisha, wika aminka turashtatjame”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Takai Jesús chicharuk: “Nekasa tajame, ju káshia juik atash jimara shinatsaig, wika au shuarnaka wainchauwajai tusam tresa imajnia waitruattame”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Tamasha Pedro chichaak: “Amina mantamainakaisha, amijai jakamij tusan waitruashtatjai”, tusa tinaiti. Pedro nuna takai, chikich ainasha ashi nunisag tuina. ");
INSERT INTO hubNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Tuinakai juakiar Jesús nina unuinatairi ainajai númi arakmau Getsemaní tutainam jeawaruiti. Tura nitan chicharuk: “Jui atumka ekeema jatarma, tumarmin ai wena Aparun aujsatjai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Tusa weak Pedron, Jacobon Juanjai juki nitajai wesa, senchi wake mesemar nekapeak kuntuts enentaimu. ");
INSERT INTO hubNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Imania asa chichaak: “Senchi wake mesemar nekapeakun jamain nekapeajai, atumka jui pujusrum wijai metek kanutsuk pujutarma”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Tusa ikuak Jesúska ishichik kuwasag tikishmar, tsuntsumaa Yuusan aujeak: “Apaachi, turumainaitkumka wii waitmaina nuka inaimamtikrusta. ");
INSERT INTO hubNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Wina Aparu, ameka ashi turumainaitme. Wait aneasam wii waitmainaitaj nuka inaisata. Turasha wii wakeramuka achati, antsu ame wakeramua nu atii”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Tusa Yuusan aujas ikuak, ni apujkimurin jeari iikma kanarar tepenan wainak, Pedron chicharuk: “Simónka ¿ameka kanuk tepam? ¿Chikichik horaksha kanutsuk pujumainchauk nekapeam? ");
INSERT INTO hubNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Iwanch nekapramkai tunau takasairum, kanú tepetsuk shintagkrum, Yuus auju pujutarma. Atumi wakanigka pegkera nunak takastasa senchi wakerawai, tumaig atumi iyashi ima kakakchau ainawai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Nuna tusa ikuak ataksha waketki, nuik timaurinak turusag Yuusan aujsauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Tuma ataksha waketki iikma, kari senchi pujainakai, kanar tepenan wainkau. Imanik kanú tepena asar, Jesús aujmasha aimainchau nekapraru. ");
INSERT INTO hubNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Tumaina asarmatai tresa jui waketruki tari chichaak: “Yamaika kanakrum ayama pujutarma. Wii shuarnum akinawaitaj juna achirkar shuar tunaun takau ainanam surutkartata nuka tsawan uminkayi. ");
INSERT INTO hubNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Yamaika nantartarma wearmi, wina surutkatta nuka winawai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Nuna tusa Jesúska eke chichaak wajai, Jesúsa unuinatairi doce ainanmaya chikichik, Judas nukap shuaran yaruak, kuchiin, númi ainajai takaru jeariaru. Nitaka sacerdote apuri aina, chicham umiktinan jintinkartin aina judío apuri ainajaimak akupkamu asar winina. ");
INSERT INTO hubNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judas Jesúsan suruktin, shuar ainan chicharuk: “Wii iwijran kugkuastataj nu Jesúska atatui, achikrum shir emetarum jukitarma tusa, chichamnaka umirkauwaiti”. ");
INSERT INTO hubNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Tura asa wári Jesúsa jeari chicharuk: “¡Jintinkartina pujamek!” takug pagkuk kugkuasuiti. ");
INSERT INTO hubNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Tusa tai shuar ainaka achikar shir emetawaru. ");
INSERT INTO hubNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Nuna tumainakai, Jesúsa unuinatairi ainanmaya chikichik ni kuchiirin juakug, sacerdote apuri inatairin kuishin awatti asankauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Turamtai Jesús, nu shuar ainan chicharuk: “¿Urukamtai kasa achikartasa iturin aina imatikruarmesha, kuchii aina, númi ainajaimak takaru winitrarme? ");
INSERT INTO hubNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Wii atumin jintinkun káshi kashinig Yuus ememattasa iruuntai jeanam atumjai tuke pujuwaj nuika jutikruarum achirchau ayarme. Turasha juka yamaika Yuusa chichame aarmauwa nu uminu asamtai aitkararme”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Nuna tusa Jesúska chichaig, ni unuinatairi ainaka Jesúsnaka ashi ajapa ikukiaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Tumaig chikichik natsa ayatik jaanch wagkarman punumar ukunam pataas wetatmaun achikaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Tura shir emetataj tama jaanchnaka awiik ikuak misu tsekegnaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Jesúsan jukiar sacerdote apuri pujamunam ejéniaruiti. Tumawarmatai ashi sacerdote apuri ainaka, judío apuri ainasha tura chicham umiktinan jintinkartin ainajaimak iruuntraruiti. ");
INSERT INTO hubNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pedrosha ikag patatus wera werakua sacerdote apuri jeen aarin jeaan, Yuus ememattasa iruuntai jean kuitamin ainajai iruunar jina anamuk eketu. ");
INSERT INTO hubNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Tumai sacerdote apuri aina, judío apuri ainajaimak ashi iruuntrar Jesús makumakur mantamnamainan eataina, imatruinaksha ni makumainka atsau asamtai nekarainachu. ");
INSERT INTO hubNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Nukap shuar imatrua Jesúsan aantar tsanumruinakai, nui irunuka nuka antrarum tarume tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Tuinakai chikich shuar wajakiar aantar waittruinak: ");
INSERT INTO hubNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Nekas antukmaji ni chichaak: ‘Shuar aina Yuus ememattasa iruuntai jean jeamkarua juna wii yumpugtatjai. Turan tres tsawantai ataksha imatiksanak shuar ainasha takaschamun jeamkattajai’ ”, tusa timayi tuina. ");
INSERT INTO hubNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Nuna tuinakaisha chikich ainaka yupichu nekaspapita tichamnau nekapena. ");
INSERT INTO hubNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Sacerdote apuri nitajai eketu wajatki Jesúsan chicharuk: “¿Urukamtai nuna imatrutmainakaisha ishichkisha aimtsume? ¿Nunasha waritmauna ame timaurmin pachisarsha imatrutmainawa?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Tamasha Jesúska aimtsuk wajau. Tumakai sacerdote apuri ataksha iniak: “¿Ame nekas Cristo Yuusa uchirigkaitam?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Tusa tama Jesús ayak: “Ee, wiyaitjai, atum wii shuarnum akinawaitaj nuna, Yuus ashi senchirtina nuna untsurini eketun nayaimpinmayan jui winakun, yuragminam pachitkau winamu waitkatin ainarme”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Nuna takai sacerdote apuri jaanchrin japiki jak chichaak: “¡Ashi antuinamunam ta jama! ¿Nuiyasha ya nakajia? ");
INSERT INTO hubNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ashi atumsha ni Yuusan pegkerchaun chichara nuka anturkaurme. ¿Atumsha uruk enentaimrume? Takai ashi aimainak: ¡Aya mantamnati!” tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Tusa tuinakai, chikich aina Jesúsa usuktan nagkamawaru. Nuna chikich turuinakai, jiin epetkar yapinam awatainak: “¡Ya awattamin nekaakia!” tusa tuina. Yuus ememattasa iruuntai jean kuitamin ainasha Jesúsnaka yapinam awataina. ");
INSERT INTO hubNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Nuna imatikainai Pedroka apu jee aarin eketun, nuwa sacerdote apuri inatairi jearin. ");
INSERT INTO hubNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Tuma wainak, jina anamuk ekeemtatmaun wajas ii wajatu. Tura chicharuk: “¿Amesha Jesús Nazaretnumia nujaimpapi wekainaitmea?” tusa inia. ");
INSERT INTO hubNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Tama Pedro chichaak: “Wika nekatsjai nusha warintsuk turutam”, tusa tinaiti. Tusa inaiyak wayaamunmani jiinkin, tumai atash shinukuiti. ");
INSERT INTO hubNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Apun takarnusha ataksha waketruki iis, nui chikich irunun chicharuk: “Ju shuara juka Jesúsjai wekainayi”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Tutai ataksha waitrak: “Wika wainchauwajai”, tusa tinaiti. Ishichik asag awentsag nui shuar matsatu Pedron ininak: “Nekas amesha au weantuitme. Ameka Galileanmaya shuaraitme, chichaakmesha aiya chichau arma nujai metek chichame”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Imatruinam Pedro Jesúsan shir pegkerchaun chicharuk: Yuuscha waitai tajai: “Wika au shuarnaka wainchauwajai ¿Ya pachisrumtsuk nusha tuinarum?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Nuna taig atash jimara shinukuiti. Tumamtai Pedro Jesús chichaak: “Atash jimara shinatsaig, wika au shuarnaka wainchauwajai tusam tresa imajnia waitruattame”, timaun anear senchi útnaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Tsawaarmatai sacerdote apuri aina, judío apuri aina, chicham umiktinan jintinkartin aina, apu ainajai ashi iruuntrar, Jesúsa jigkarar jukiar apu Pilaton ejétiaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Nu tura ejétim Pilato iniak: “¿Judío ainan apurim nekas amekaitam?” Tusa iniam Jesús ayak: “Ame turutam nuka nekasaiti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Sacerdote apuri ainaka aantar nekaschaunak tsanumruina asarmatai, ");
INSERT INTO hubNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilato ataksha waketrusag iniak: “¿Ameka nuna imatrutmainakaisha ishichkisha aimtsumek?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Turasha Jesúska ishichkisha aikchauwaiti. Tumakai Pilatoka enentai jearchauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Jiisat Pascuatin shuar aina nu jiinkiti tuinakai, achikmaun chikichkinak Pilato tuke jiiskee ajakuiti. ");
INSERT INTO hubNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Cárcelnum chikichik shuar Barrabás naartin, yaunchuk chicham aepruniamunam shuaran maa asamtai, achikam egketu. ");
INSERT INTO hubNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Tuma asamtai nukap shuar aina Pilaton jeariar chicharainak: Ii iturnaj nuka yamaisha aitkasmek chikichik shuar akupkata tusar tuina. ");
INSERT INTO hubNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Tuinakai Pilato shuar ainan iniak: “¿Jesús, judío apuriya nu, jiinkiti tusarmesha atumsha wakerarmek?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilato tina nunaka sacerdote apuri ainaka tukeneas kajerainakpapi wina itartiaria tusa nekau asa nunaka tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Turasha sacerdote apuri ainaka, Jesús jiinki tusar senchi nakitaina asar, shuar ainan chicharainak: “Atumsha Barrabás jiinkiti tusarum titarma”, tusar akattraruiti. ");
INSERT INTO hubNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilato shuar ainan iniak: “¿Atum judío apuri tarum nunasha iturkati turutrumea?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Tusa inimkai senchi chichainak: “Auka numinam ¡achinar mantamnati!” tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Tusa tuinakai Pilato chichaak: “¿Turasha wari tunauna takasia?” Nuna takaisha nitaka senchi chichainak: “¡Achintrati! ¡Achintrati!” amajaina. ");
INSERT INTO hubNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Imatruina asamtai Pilatosha shuar ainajai kajernaitan nakita asa, Barrabásan jiiyak, Jesús asutiarum numinam achiirum maatarma tusa suntar ainanam surukuiti. ");
INSERT INTO hubNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Turamtai Jesúsan suntar aina jukiar apu jeen aarin ejéniar, suntar ainan ashi ipawar iruuntraruiti. ");
INSERT INTO hubNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Turawar ni nugkutairin awitkar, apu nugkutairin yamakaitkaun anugkrar, etsegkrutai jagki najanamun etsegkrumtikaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Tura wishikainak emematainaji tusar senchi chichainak: “Judío ainan apuri emematiarmi”, tusar imatruina. ");
INSERT INTO hubNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Imatruinak numijai muuknum awatainak usukina, tura emematji tusar tikishmataina. ");
INSERT INTO hubNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Tusa wishi wishikainakua, nugkutai yamakaitkaunka awitak juruinak, ni nugkutairinak anugkar, nui numinam achirar maawartasa jukiaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Jesús ni achintratin númi yapajiamun yanak wesa, kakaarchamnau nekapeakai, Cirenenmaya shuar Simón naartin, Alejandro, Rufo apariya nuna, ajan takak wu yama taanak wainkar, nuke nagkamaina asar chicharainak: Ju ame yanakta tusar ayanak jukiaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Jesúsan jukiar nain Gólgota tutainam ejéniaruiti. Chicham “Gólgota ta nunaka muka nain” taku tawai. ");
INSERT INTO hubNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Nui ejéniar najaimakchati, tusar umutain vino tutain, mirra puari pachimramujai Jesúsan susaru, turamsha umarchauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Tumamtai Jesúsan númi yapajiamunam achiraruiti. Turawarmatai suntar aina Jesúsa jaanchrin jurukiar, yáki nepetmakat nu jukiti tusar nakurutain nakuruina. ");
INSERT INTO hubNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Jesúsnaka etsa nueve jasa ai achiraru ainawai. ");
INSERT INTO hubNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Jesúska tumau asamtai achiaji, tusar ni chaikin tablanam aak: judío shuara apurigka juwaiti, tusa aatar anujtuku ainawai. ");
INSERT INTO hubNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Jesúsan númi yapajiamunam achinak jimar shuaran shir pegkerchau ainan achirar, chikichnaka ni untsurini, tura chikichnaka nina menarini achirar nenasaru ainawai. ");
INSERT INTO hubNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Yuusa chichame aarmaunam chichaak: “Tunau ainajai irumra nekapmam atinaiti timauka”, tu uminkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Shuar aina nu ayaamas nagkamainaka muuken peasar, pegkerchau chichaarainak: “Yuus ememattasa iruuntai jean yumpugkan tres tsawantaik jeammainaitjai tinam nusha ¿urukamtai anisha netame? ");
INSERT INTO hubNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","¡Ani nematsuk akaikim uwemrakia!” tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Sacerdote apuri ainasha, chicham umiktinan jintinkartin ainajai iruunar Jesúsan wishikainak: “Chikichnaka uwemtiknayi, tumauwaitiat nigkika uwemtikmameatsui. ");
INSERT INTO hubNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Nekas Israel shuar ainan apuriyaitkugka, achinar neta au akaikiti, tumamtai isha nekaspapita tiarmi”, tusa tuina. Jesúsjai metek achiram netuinasha tumasag pegkerchau chicharaina. ");
INSERT INTO hubNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Etsa tutupnira ai ashi nugkanam káshi jasu, tuma nukap asa etsa teenta ai, ataksha tsaaptin jasuiti. ");
INSERT INTO hubNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Eke imanik káshi jas ai Jesús senchi untsumuk: “Eloi, Eloi, ¿lema sabactani?” tusa tinaiti. Nunaka: “Wina Yuusru, wina Yuusru, ¿urukamtai winasha inaitusume?” taku tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Shuar nui iruunainaka nuna antukar chichainak: “¡Antu jakua, Elías Yuusa chichamen etserin ajakua nuna untsuawai!” tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Tuinakai chikichik shuar nui wajau, tsekegki umutain vino tutai churuin pujuttamaun, yumi mukuntai esponja tutain juakug ajug inijar, númi ichipkamunam etea, Jesúsan umarti tusa suak: “Iismi, Elías juna akaktasa winitchatpash, nu wainkarmi”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Nuna tai, Jesús senchi untsumak jakauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Tumamtai Yuus ememattasa iruuntai jeanam jaanch ajaamu auka yakini nagkamna jimapetuk achinakuiti. ");
INSERT INTO hubNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Tumamtai Romanmaya suntara capitánkri Jesús achirmaunam ayaamas wajau, Jesús imatak untsumka jamun wainak chichaak: “Ju shuarka nekas Yuusa uchiri ajakuiti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Nuwa ainasha ikag ii iruuntuina. Nui María Magdalena, chikich María Jacob ekeuwa nuna Joséncha nukuriya nu, chikich nuwa Salomé, nu aina ii wajaina. ");
INSERT INTO hubNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Nu nuwa ainaka Jesús Galileanam pujakai, nemarainak umiru jakaruiti, nuiyasha nukap nijai iruunar Jerusalén kaunkarua nujaimak ii iruuntuina. ");
INSERT INTO hubNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Nu tsawan kintamai kashinia nui ayamtai tsawan atin asamtai, takatan umikartasa ashi takainai, ");
INSERT INTO hubNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","shuar José naartin Arimateanmaya taawaiti, nisha apu aina iruunainamunam iruunin, Yuus inammauncha wainkattsa wakerin asa, arantsuk Pilaton weri, Jesúsan iyashi ikustajai tusa seawaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Nu tusa seam, Pilato enentai jearchauwaiti. Tuma capitánkan untsuk itan: “Jesús nekas jakamka”, tusa iniasuiti. ");
INSERT INTO hubNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Tutai capitán ayak: Jakamai tusa tinaiti. Tama Pilato Josén chicharuk: “Jesúsa iyashigka jukita”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Tama Josésha Jesús jaka yaki nemattamaun akaki, jaanch puju pegker sumakmaujai punuaruiti. Tura pampanam wa taimunam egkea, tura kaya uuntan juki shir apujtua ikuknaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Nui ikuamun María Magdalena, María Josén nukurijai wainkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ayamtai tsawantan inagkakiar, nu tsawantaik etsa akaikin ai, María Magdalena, María Jacobon nukuri, Saloméjaimak Jesúsa iyashi ukatkatnun perfume ainan sumakaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Tura kanar tsawainak, domingo tsawantin, etsa yama wakai, Jesús ikusmaunam wearuiti. ");
INSERT INTO hubNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Tuma wesar chichainak: “¿Yáki kaya uuntan apujtuawarma nunasha uratramtaji?” tusar tuina. ");
INSERT INTO hubNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Tusar jeariar iikma kaya uun apujtuamuka ekemak atatmaun wainkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Tura utuawar iikma, shuar natsa jaanch pujun nugkuaru untsurnumani eketun wainkar ashamkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ashamam nui eketu nuwa ainan chicharuk: “Ashamrukairpa. Atumka Jesús Nazaretnumian maawarma nu earme. Ikusarma nu taarum iistarma. Nigka aneantu asa, juigka atsawai. ");
INSERT INTO hubNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Wári werum Jesúsa unuinatairi aina nu ujaktarma. Turakrum Pedrosha ujaktarma. Jesúska nitan tina nunisag niya eemak Galileanam wetatui. Tumamtai ai wainkartatui”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Nu tusa tama nuwa ainasha jinar nuna wainkaru asar, kurakmaikia tseketaik shiakaruiti. Imanik sapijmakaru asar, chikichik shuarnaksha tumayi tusarka ujakcharuiti. ");
INSERT INTO hubNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jesús maamu domingotin, káshikmas nantaki yama nagkamchakka María Magdalenan siete iwanch egkemtuamun jiir utsantak agkanmamtikawa nunaa wantintukuiti. ");
INSERT INTO hubNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","11","Turam Jesúsan nemarin aina wake mesemar nekapenak, útu matsatun jeari ujak: “Yamaika Jesúska nantaki, wina wantinturkamtai, wii ima shir wainkamjai”, tusa tinaiti. Nu tamaun antukarsha nekaspapita ticharu ainawai. ");
INSERT INTO hubNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Aruma nui ni nemarin aina jimarchik kanakiar, jinta wetatmaun wantintukuiti. Turasha nitanka María Magdalenan wantintukmaun tumaska wantintutsuk nisha iimtin jas wantintukuiti. ");
INSERT INTO hubNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Tuma wantintukam, nitasha waketar kaunak jea matsatun ujainak: Jesús wainkaji tusar tiaruiti. Tuinamsha nunasha nekaspapi tuinawa ticharu ainawai. ");
INSERT INTO hubNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Tumainakai Jesús maamu nantakin wainkaji tusar tuinakaisha, nekaspapita ticharu asarmatai, Jesús ni unuinatairi mesanam eketainan wantiintuk chicharuk: “¿Urukakrumea wina waitkau aina ujatmainakaisha nekaspapita turuttsurme?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Nuna tina chichaak: “Chicham pegkera nu ashi nugkanam werum, shuar aina ashi ujaktarma. ");
INSERT INTO hubNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Turakrumin nita nuna antukar nekaspapita tusar nemartuinak entsanam mainaka uwemrartin ainawai. Antsu shuar nu etsermaun antuinayat, nekaspapita tuinachuka waittanam weartin ainawai. ");
INSERT INTO hubNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ju iwainamua juka wina nekas pujawapi tusar umirtau ainajai atinaiti. Iwanch shuaran egkemtua pujuruncha wina chichamrujai jiirar ishimtin ainawai, tura chicham nita chichashtairincha chichaartin ainawai. ");
INSERT INTO hubNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Atum wina nemartautirmeka nápi asatmiarmataisha jakashtin ainarme. Tura umutain tseasan egketramawar amasarmatai umakrumsha jakashtin ainarme. Ja ainasha atum achiarminig Yuus pegker amajiartinaiti”, tusa Jesús tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Nuna tina inaiyak, nayaimpinam weak takunnaiti. Tuma Apari pujamunam waka, Yuusa untsurini ekeemsauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Jesús nayaimpinam wematai, ni unuinatairi ainasha ashi nugkanam yujasar, chicham nekas pegkera nuna etseraina. Tumainakai apu Jesús nitan yayák, shuar ainancha chicham etsermaun paan nekamtikuk, nita wainchatai ainancha nukap iwaintukuiti. Maake, nunis atii.");
INSERT INTO hubNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","3","Wina anetair Teófilo, Jesús yama nagkamchak jintinkartak uruk pujusiawak nuna pachisar, chikich wainkau etsermaun nitasha antukaru asar, nukap shuar aaru ainawai. Tura wisha aitkasnak shir nekaan Jesús jui nugka pujus turawapita tusan nunak pachisan aatjame. ");
INSERT INTO hubNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Amina nekasa nuna jintintramawaru aina nu shir nekaata tusan aatjame. ");
INSERT INTO hubNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Yaunchuk Herodes Judeanmaya shuaran apuri pujai, nui sacerdote Zacarías, nisha Abíasjai takau ainajai iruunar takak pujau. Zacaríasa nuwesha sacerdote Aarón weantu, nuna nuwa naarigka Isabel ajakuiti. ");
INSERT INTO hubNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Chicham umiktin ainanka nina nuwejai umin ajakaruiti. Tumau asarmatai Yuuska mai pegkerak ii jakuiti. Iman asarmatai chikichik shuarkesha pegkerchauwaiti tumainchau ajakaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Turasha Isabel uchin jurechu asamtai, nigka uchi akiitsuk nuwejai ashanmaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Sacerdote Abíasjai takau aina nu nita takastin tsawan jeawaiti. Tuma asamtai, Zacaríascha nitajai takastasa wuwaiti. Tuma jeawar yáki kugkuinan Yuus ememattasa iruuntai jeanmasha epeat tusa nekawartasa kaya ainan chumpiawaruiti. Tura yáki juna jukit, shuar juna jukin Yuusa jee tesamu pegkernum wayaa incienson epeati, tusar kaya pujun pachikaruiti. Nu turamunam Zacarías jukinaiti. Turamtai ame Yuus ememattasa iruuntai jeanam wayaam incienso epeata, tusa tiaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Tusa tama nigki wayaa incienson epeakai, chikich ainaka aa iruuntsar Yuusan aujaina. ");
INSERT INTO hubNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Zacarías incienson epetainam incienson epeak wajattamaun, nayaimpinmaya shuar Yuus akupkamu wantintukuiti. Tuma incienso epetai yantamen untsurnumani wajattsauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Tumattamaun wainak, Zacaríaska senchi ashamkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Tumakai nayaimpinmaya shuar chichaak: “Zacaríasa, ashamrukaipa. Yuus ame seammaunka anturtamkayi, nuwem Isabelka uchi aishmagkun jurertatui. Tumamtai Juan anaikattame. ");
INSERT INTO hubNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Nu akinamtaigka ameka shir aneasam nakunkut pujuttame, tura chikich ainasha shir aneniartatui. ");
INSERT INTO hubNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Nunaka pegker ainan takasti tusa Yuus yaigtinaiti. Umutain karia ainancha umichu atinaiti. Akintsaigsha Wakan Pegker arittawai. ");
INSERT INTO hubNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Tsakar pujus Yuusa chichamen etserkai antuinak, Israel shuar ainasha, tunau takatan inaiyainak Yuusan umirkartin ainawai. ");
INSERT INTO hubNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Yaunchuk shuar Elías naartin Wakan Pegkera nuna senchirijai Yuusa chichamen etseruk umirujakua tumasag, ame uchirmesha Wakan Pegkera nuna senchirijai nukap iwainak, Elías takasua imatiksag takastinaiti. Chichaman etserkai un ainasha uchiri ainajai tsagkurnairar shir pujusartinaiti. Tura chikich shuar Yuus anturtan nakitin ainasha nina umiriartinaiti. Tumainak apu Cristo takai jukiarti wakerus tusa amina uchiram shuar ainan nekamtikatnaiti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Tusa tama Zacarías nayaimpinmaya shuaran chicharuk: “Wina nuwarjai unchitaj junasha, ¿uruk nekaspapita titajak?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Tusa takai nayaimpinmaya shuar chicharuk: “Wika Gabrielaitjai, Yuusa inatairiyaitjai. Tuma asan ni akuptukmatai wika chicham pegkeran amina uchiram akinatnun pachisan ujaktasan tarijme. ");
INSERT INTO hubNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Turasha ame nekaspapi turutua tatsum nui uchiram akinamtai chichaktasam, yamaika chichachu jastatme. Wii ujakjam juka uchiram akinkai nekas uminkattawai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Tusa tama nujai chichaak, “Yuus ememattasa iruuntai jeanam nukap megkakau. Tumamtai shuar aa irunuka, ¿urukakug ima megkaka?” tusar nakaa iruntuina. ");
INSERT INTO hubNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Tuma irunai nukap arus, Zacarías jiinkin. Tuma chichachu amajsamu asa, shuar aa irunun iwijas auju. Tumamtai ¿urukakug ainka, Yuus iwaintukchaish? tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Tsawan jeamtai, ni takasti timaunka ashi umik ikuak Zacarías nina jeen waketkinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Tuma nukap pujatsaig, nuwe Isabel ajapruku, tuma wantiintsuk nina jeenig cinco nantu pujusuiti. ");
INSERT INTO hubNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Iman nantu wantiintsuk pujaksha, nigka shir aneas pujau. Tuma asa chichaak: “Yuus wait anentruru asamtai uchirmaktatjai. Yamaika chikich shuar ainasha eme anentrusar iirsartatui”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Isabelka ajapruk seis nantu pujai, Yuus ataksha Gabrielan Galilea nugkanam yaakat Nazaret tutainam, ");
INSERT INTO hubNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","nuwa agkantu María naartin pujaun chichaman ujakti tusa akupkauwaiti. Maríaka shuar takashtai ajakuiti. Turasha nu nuwanka apu David weantu shuar José naartin, nuatkattsa chichas pujau. ");
INSERT INTO hubNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Nayaimpinmaya shuar María pujaun jeari chicharuk: “Yuusa anetairi María, ¿pujamek? Ashi nuwa aina nuiya Yuus eme anentsa iitaimka ametme. Turutma asa amina ima senchi kuitamramui”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Nu tusa tama: ¿Urukakug turuta? tusa kuntuts enentaimrauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Tumakai nayaimpinmaya shuar chicharuk: “María, kuntuts enentaimipa. Amina Yuus etegtama asa, ima senchi shir anentramawai. ");
INSERT INTO hubNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Antukta, uchi ajaprukam aishmag jurertatme, turam Jesús anaikattame. ");
INSERT INTO hubNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Nu Uchinka Yuus ashi nagkakartakua nuna uchiri asamtai, yaunchuk ni weantun Davidtan apu atii tusa anaikauwa turusag Yuus apu amajsattawai. ");
INSERT INTO hubNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Atum Israel shuar ainatirminka ni inatmau atinaiti Tura nina inamtairigka tuke atinaiti”. ");
INSERT INTO hubNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Nu tusa tama María nayaimpinmaya shuaran chicharuk: “¿Wii aishrinchauwaitaj nunasha urukaknak antrancha uchincha jurertaja?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Takai nayaimpinmaya shuar chicharuk: “Aishmagka enentaimtipa. Wakan Pegker egkemturmarmatai, Yuus ashi nagkakartakua nuna senchirijai ajapruktatme. Nu uchi akinatta nuka tunaurinchau atinaiti. Tumau asa ‘Yuusa uchiri’, tama atinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Tura ame ika kaim Isabel uchin jurechu tinu arma nu unchitak uchin jurertatui, nigka ajapruk seis nantu pujawai. ");
INSERT INTO hubNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Yuus tujinmainka pegkesha atsawai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Tusa tama chichaak: “Nekas wika Yuusan inatairiyaitjai. Wika Yuusnaka ni wakeramunka ashi umirkattajai. Ame turutam nusha imanisag uminkati tusa timatai, ikuak nayaimpinam waketkinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Nukap tsawan pujutsuk María chikich yaakat Judea nugka murari aunam, Isabel pujau asamtai, wainkataj tusa wuwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Tuma Zacarías pujamunam María jeawaiti. Tuma Isabelan wainak chicharuk: ¿Amesha pegkerak pujam? Wisha amina iistasan winitjame”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Nuna María tusa chichaamun Isabel antaig, uchi shir aneak ampujnumia muchitkauwaiti. Wakan Pegker ");
INSERT INTO hubNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Isabelan paan jiik chichamtikiak: “Ametme nuwa ainanmaya etegka Yuus pegkermamtikamumka, tumasag ame uchirmesha pegkermamtikamuiti. ");
INSERT INTO hubNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ameka wina Apuru nukuriyaitiatam, wii imanchau aig wina waitkattsam taume. ");
INSERT INTO hubNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ame jea wayakum aujtam nuna uchi antuk shir aneak muchitkayi. ");
INSERT INTO hubNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Nekaspapi Yuus turattawa tusam tame nui amesha shir aneasam pujuttame”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Tama Maríasha chichaak: “Wika nui wina enentaimtairjai Yuusan emematjai. ");
INSERT INTO hubNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Yuus wina uwemtikrin asamtai, wika shir aneajai. ");
INSERT INTO hubNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Wii imanchau aig, nina inatairi asamtai, ni etegtauwaiti. Atakea nuisha shuar ainaka wina pachittsar chichainak: Yuus pegkernum yaigkuiti, turamu asa shir aneas pujawai tusa turutiartin ainawai. ");
INSERT INTO hubNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Nunaka Yuus pegker ashi senchirtina nu shir pegkeran turuta asamtai tiartinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Yuuska shuar aina umirmaka jutiksag wait anentsagke atinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Nigka nekas senchirtinaiti, tumau asa shuar ememau ainancha nepetkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Apu ainan shuar imanchauch amajak, shuar imanchauch ainan chichame anturtai amajsauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Shuar atsumin ainanka nukap susauwaiti, turasha wiakach ainanka susachuiti. ");
INSERT INTO hubNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Yaunchuk ina apachrin anajmatawa nunaka, Nigka ashi umikuiti. Tura asa ii Israel shuar ainatinka nina inatairi asaakrin yainmakuitji, tura nugkancha suramsauwaitji. Abraham weantu ainan wait anentratnaitjai tusa tina nunaka kajinmattsuk metek umikuiti”. ");
INSERT INTO hubNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Nuna tusa pachis chichai chichainakua ashimak Maríaka Isabelan jeen tres nantu pujus, nina jeen waketkinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Tsawan jeaamtai Isabel uchi aishmagkun jureruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Tura Isabel Yuus wait anentram uchirmakmaun nina patai aina, tura ashi nitajai irutkau ainajaimak antukar shir aneasaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Uchi akina ocho tsawan ejémtai, chikich shuar nui irutkau aina, uchi aishmag akinamtai, kati mushuke tuke tsupirsagke au asar, nincha turusag tsupirkartasa kautkaruiti. Tura kautkar uchika apari naarig anaikami, nisha Zacaríasak atii tuina. ");
INSERT INTO hubNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Tusa tuinakaisha Isabel chichaak: “Atsaa, nekas Juan atii”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Tusa takai ¿urukamtai Juan atii tame? ¡Amina pataimiksha tu naartinka chikichkiksha atsajama! tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Uchi nukuri takai, aparisha warittig nekaami, tusar chichamainchau asamtai, uchirmesha ya anaikattam, tusar iwijas inina. ");
INSERT INTO hubNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Tusa tama aamain surustarma tusa Zacarías inakmakai juki susaruiti. Turam nuna juki: Uchi naarigka Juan atii tusa aaruiti. Tu aarmatai wainkar chichainak: ¿Urukamtaig uchincha tusha anaiyainawa? tusar enentai jearcharuiti. ");
INSERT INTO hubNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Zacarías chichachu amajsam pujau, nuna aar ashimmauwaik ataksha chichaku, tuma Yuusan emematnaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Tumamtai ni irutkamuri aina enentai jearcharuiti. Nu tumamun shuar wainkar, Judea nugka murariin matsamin ainasha tumamai tusar etseraina. ");
INSERT INTO hubNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Nu tusa etsermaun antukar nitak ininainak: ¿Nu uchisha urukuk atinaita? Nita enentaimsarka uchinmatsuk Yuusan senchiri atai tu enentaimtuina. ");
INSERT INTO hubNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zacarías uchi apari, Wakan Pegker chichamtikam, Yuusa chichamen etseruk: ");
INSERT INTO hubNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Israel shuar ainatika, uwemtikramrattsa tarutrama asamtai, ina apuri Yuus emematiarmi. ");
INSERT INTO hubNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Yuusa inatairi David weantunam akinati tusa, ina uwemtikramratnun senchirtinan akupturmakji. ");
INSERT INTO hubNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","71","Nuka ina shuarin nepetak, ina kajertamin ainancha ashi senchirtinchau amajak uwemtikramkatnaitji, tusar yaunchuk shuar pegker Yuusa chichamen etserin aina juna pachisar etserkaru ainawai. ");
INSERT INTO hubNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","73","Ina apachri ainan Yuus wait anentrau asa, ina apachrin Abrahaman pegkeran anajmatawa nuna kajinmattsuk imatiksag umikai. ");
INSERT INTO hubNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Tura asa ina shuarin ashi nepetak, ashamkartutsuk shir matsamsar wina chichamrunak umirtukarti tusa agkanmamtikramattaji. ");
INSERT INTO hubNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Nitaka pegkermakar matsamsar ashi tsawantai wii wakeraj nunak takasarti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Nuna tina ashimak uchirin chicharuk: “Uchiru, ameka apu Yuus akupkam, amina ukurmin winitta nu taa takastin umirkum, Yuus ashi nagkakartakua nuna chichamen etsernaiti tama atinaitme. ");
INSERT INTO hubNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Tura atum tunau takatairmin tsagkurtamar uwemtikramratnuka winittawai tusam, Israel shuar aina nekamtikattame. ");
INSERT INTO hubNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Yuus wait anentramrau asa, ina uwemtikramkatnun akupka nuka káshikmas etsa etsantuk tsaaptin amajna numamtinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Shuar tunaun takaina nuka Yuusan tuke tupantraru asar sapijma matsatainawai. Turasha ina apuri winak inka pegker amajtamsattaji. Tura uruk pujakrik agkancha pujumainait nunasha ni jintintramattaji”, tusa Zacarías tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Uchi tsakar Yuusnasha aneak shir enentaimu. Tuma asa aya nugkanmag shuar atsamunam nui pujus, Yuusa chichame etserkatnuri tsawan jeaakai, israelita ainan chicharkataj tusa wuwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Chikich tsawantai apu Augusto ashi nugkanmaya shuar aina nekapmantrati tusa inamrauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Nu shuar nekapmamunka yaunchuksha turushtain Cirenio, Sirianmaya apu pujai turawaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Nuna tusa apu timatai, shuar ainaka nita apachri akinamu yaaktanam wear naarin aatmamaina. ");
INSERT INTO hubNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","Ashi shuar umikarti timau asamtai, shuar José naartin Galilea nugkanam yaakat Nazaret tutainam pujau, nina nuwe atinan ajamtinan ayas, David weantu asa, Davidcha nu yaaktanmag akina asamtai, Judea nugkanam yaakat Belén tutainam wuwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Nui Belénnum nina naari aatmamratnunam jeai, María uchi jurertin tsawan jeawaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Turasha jea nita pujumainka atsau, irar kanutai jeasha ashi piakaruiti. Tuma asamtai tagku matsamtainam nui nuwen apujas uchin ujerauwaiti. Tura uchi iwairin jurermatai, jaanchjai punuar tagku tuntuiparin egkeawaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Nui María uchin jurermatai, José Belénnum pujai, ovejan kuitamin aina yaakat tiijuch asamtai, káshi ovejarin kuitamainak matsataina. ");
INSERT INTO hubNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Tuma matsatai Yuus akupkamu nayaimpinmaya shuar tara, Yuusa tsaaptintri nita matsatmaunam tsaaptin amajsauwaiti. Tumamtai nuna wainkar senchi ashamkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Tumainakai nayaimpinmaya shuar Yuus akupkamu chichaak: “Ashamrukairpa. Wika atumin chicham pegkeran ujaktasan winitjarme. Tura shuar ainasha juna antuinak shir aneas nakunkut matsamsartinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Yaunchuk apu David akinawa nuu yaaktanam yamai káshia jui atum apurimatin, uwemtikartin Cristo akinayi. ");
INSERT INTO hubNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Yaaktanam jearum tagku tuntuiparin uchi punuaram egketu wainkattarme, turarum nekas junapi tawa titatrume”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Nu chichaak wajai chikishcha nayaimpinmaya shuar aina untsuri tarar, Yuusan emematainak: ");
INSERT INTO hubNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“¡Yuus yaki nayaimpinam pujuwa nuna ashi shuar emematiarti! Shuar nugka matsamsar, Yuusan umirin ainaka shir agkan nakunkut matsamsarti”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Nuna etserkar nayaimpinmaya shuar ainaka wakettraruiti. Nu waketramtai ovejan kuitamin aina nitak chichainak: “Nayaimpinmaya shuar etserka nu Belénnum jear wainkami”, tusar tuina. ");
INSERT INTO hubNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Tusar wári shiakar, jeaakma nayaimpinmaya shuar timaunka imatiksag José Maríajai uchin punuarar, tagku tuntuiparin egkesar pujurainan wainkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Tura nayaimpinmaya shuar uchin pachisa timaun etseraina. ");
INSERT INTO hubNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Tusar ovejan kuitamin etserainakai, chikich aina nuna antukar enentai jearcharu. ");
INSERT INTO hubNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Nuna ashi tusar etserainakai, María antuk sakatmamainchau nekapeak, nuig enentaimu. ");
INSERT INTO hubNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ovejan kuitamin aina oveja matsatmaunam waketainak, nayaimpinmaya shuar timaun uchi wainkamun pachisar, Yuusan emematainak chichaki shimuina. ");
INSERT INTO hubNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ocho tsawan ejémtai, uchin kati mushuken tsupirkaruiti. Turawar Jesús anaikaruiti. María ajapratsaig uchiram akinamtai, tu anaikattame nayaimpinmaya shuar tusa timaunka imatiksag umikaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","23","Chicham umiktinan Moisés aak: Nuwa uchin aishmagkun jureruka cuarenta tsawan ejé uchin jureak tunamarmaurin pegkermati tina nunisag, iwairi uchi aishmag akinamtaigka Yuusan tuke su arti timau asamtai, Yuusan uchin susartasa Jerusalénnum wearuiti. ");
INSERT INTO hubNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Tumainak chicham umiktarma timaunka turusag Yuus susatnun jimar paum uun tura nu atsakaigka, jimar pauma uchiri itatarma timauwa turusag jukiaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","27","Nu tsawantaik María nina aishrijai uchin jukiar, Yuus ememattasa iruuntai jeanam awayawara ai, shuar Simeón naartin, nekas pegker Yuusan umirin Jerusalénnum puju, Wakan Pegker nekamtikam chichaak: Wika jatsuk pujusan, Yuus Israel shuaran uwemtikati tusa akupkam, apu Cristo taatna nunaka wainkatnaitjai, tusa tu puju. Wakan Pegker enentaimtikam, nisha Yuus ememattasa iruuntai jeanam wayaawaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Tumakma uchin wainkauwaiti. Tura uchin winakki juki wajas Yuusan emematuk: ");
INSERT INTO hubNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Apuru, ame uwemtikartin wainkatnaitme turutnaitam nuna wainkaj nui, yamaika jaknasha shir aneasan jakatjai. ");
INSERT INTO hubNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Yamaika shuar ainatin uwemtikramratna nunaka wainkajai. ");
INSERT INTO hubNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Nuka ashi nugkanmaya shuar aina wainmaunam umikume. ");
INSERT INTO hubNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Nigka tsaaptina numamtinaiti, tumau asa ashi shuar ainan nekatan susattawai. Nigka ii weantu asamtai, Israel shuar ainatin pachitmasar pegker chichartinaiti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simeón takai, María Joséjai nuna antukar, urukakug ta tusar enentai jearcharuiti. ");
INSERT INTO hubNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Tumainakai Marían aishrijai chicharuk: “Atumnasha Yuus pegkernum yainmakarti”, tusa tinaiti. Tura Marían chicharuk: “Ju uchia junaka Israel shuar aina juiyag nakitrartinaiti, tura nemarainak uwemainasha nukap artinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Yuus ashi shuar aina enentaimmaurin paan iwainattawai. Amina uchirmin senchi waitkainakai, ameka nagkijai ijuam waitmaina imanikam waittsattame, tusa ujak ikuak Simeónka wuwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Tumai nuwa uuntach, ochenta y cuatro uwí aramu, Yuusa chichamen etserin, Aná naartin pujau. Nu nuwaka Aser weantu, Fanuela nawantri ajakuiti. Tsakat asag aishrinawaiti. Tuma siete uwí pujus, aishri jakamtai wajemawaiti. Wajema pujus Yuus ememattasa iruuntai jeanam pujustasa wayaawaiti. Tuma ishichkisha jiintsuk tsawai káshisha yurumkan yutsuk Yuusan tuke auju pujau. ");
INSERT INTO hubNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Tuma pujau asa, Anásha uchin wainak Yuusan maaketi tusa, ashi Israel shuar uwemtikartinan nakau aina nui irunun chicharuk: ‘Israel shuar ainatin uwemtikramratin nakamuka juwaiti’ ”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","María Joséjai Yuus ememattasa iruuntai jeanam chicham umiktinan Moisés aarmaunka imatiksag umikar, Galilea nugkanam nita yaaktarin Nazaretnum waketkiaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Tura ataksha Nazaret ejém pujus, uchika tsakak senchimaki wea, tura Yuus wakeramuncha shir nekau, tura Yuuscha nina shir enentaimtau. ");
INSERT INTO hubNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","42","Ashi uwítin jiisat Pascua jeaakai, Yuus tumawarti timaun uminak, Jerusalénnum tuke wesarke au asar, nu tsawan jeakai wenak, Jesúsan doce uwí aramun ayasar wearuiti. ");
INSERT INTO hubNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Nui jeawar matsamsar jiisat ashimnakmatai, Nazaretnum ataksha waketainai Jesúska Jerusalénnum juaku. Tuma ai, uchika chikichjaintsuk iruunar winatai tusar pachitsuk wena. ");
INSERT INTO hubNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Tuma jinta chikichkia kanararu, nui kanamunam Jesús wantinkachmatai, nina waintairi ainan tura patai ainancha ashi iniasar, ");
INSERT INTO hubNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","waintsuji tuinakai, yaaktanam juakchamashi tusar eainak Jerusalénnum ataksha waketrukiaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Tumawar yaaktanam jimar tsawantai eakaruiti. Tura tresa juna kanar tsawaar eajkama, Yuus ememattasa iruuntai jeanam, chicham umiktinan jintinkartin aina matsatmaunam nisha nui pachinak nita chichainamun antak, tura inimuk pujaun Jesúsan wainkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Nitasha turusag Jesúsan inina, turam nisha tu awai tusa aimu. Imanik yacha ainan nagkas aimkai, chichatnasha imanisag chichaakai antuinaka: Itursag junincha imatiksasha nekawa tusar enentai jearcharuiti. ");
INSERT INTO hubNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Tuma pujaun apari nukurijai wainkar enentai jearcharuiti. Tura nukuri uchirin chicharuk: “Uchiru, ¿urukamtai aani wekainaitme? Megkakachiash tusan, wii apajai wake mesersan eakjame”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Tama ni aimuk: “¿Urukamtai winasha imatikarmesha eatrume? ¿Wina Apar wakeramun takakun, wina aparun jeen pujumainaitaj nuka atumka nekatsrumek?” ");
INSERT INTO hubNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Nuna takai urukakug ta tusar nekamainchau nekapena. ");
INSERT INTO hubNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Jesúsan jukiar Nazaretnum waketkiaru. Jesús nui pujus ashi nita takamunka metek umia. Turasha nukurigka Jesús Jerusalénnum wekasamunka kajinmattsuk nunak enentaimtu pujau. ");
INSERT INTO hubNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Tura Jesúska nu senchi tsaka, tura nekatnumsha tumasag, Yuuscha tura shuar ainasha shir anentaina. ");
INSERT INTO hubNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Tiberio César, uwí quincetin Romanmaya apu ainan apuri ajakuiti. Nina atutairi ainasha nu nugkanmag inamaina, apu Poncio Pilato Judea nugkanam inamu, Herodes Galileanam inamu. Tura nuna yachi Felipe Iturea nugkanam, Traconitenmasha inamu. Chikich apu Lisanias naartin Abilinianam inamu. ");
INSERT INTO hubNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ashi ju apu matsatainaig, sacerdote apuri jimar Anás, Caifásjai pujujaku ainawai. Imajin apu matsatainai, Zacaríasa uchiri Juan aya nugkanmag pujuttamaun Jordánnum Yuus akupkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Tura akupkam entsa Jordánnum jeawaiti. Tuma shuar matsatainan chicharuk: Atum tunau takasmaurmincha Yuus tsagkurtamrarti, tunau takat inaiyakrum maitarma. ");
INSERT INTO hubNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Juan tusa etsermauka, yaunchuk Yuusa chichamen etserin Isaías aarua nu imanisag uminkauwaiti. Isaías tu aaruiti: “Chikichik shuar aya nugkanmag wekaas, senchi chicharkartak: Apu jintiya nu tutupin atii tusarum shir umiktarma. ");
INSERT INTO hubNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Japau akaisha nugka yaruakrum aimratarma, nainnum jinta weakaisha, yumpuarum pakamarum jinta tunin akaisha, pegker tutupin amajsatarma. ");
INSERT INTO hubNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Turamu asamtai uwemtikartinan Yuus akupkatta nuna ashi shuar wainkarti”, tusa Isaías yaunchuk Juankan pachis tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Juan imakratu tamaun antukar, shuar aina winasha imatti tusar wena. Turasha shuar ainaka tunau takatan inaitan nakitaina asarmatai Juan chichaak: Tsanumin ainata ¿atumka aya maimuktsuk Yuus waittan sukartustina nuka uwemtumainaita tarumek? ");
INSERT INTO hubNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Nekas uwemrattsa wakerakrumka, tunau takatairam inaiyakrum, enentaimtairam yapajiatarma, tumakrum uwemmainaitrume. Atum enentaimsarmeka ika Abraham weantu ainaj nui yupichu uwemmainaitji tarume. Turasha wii tajarme: “Yuus wakerakka, kaya aina junasha Abraham weantu amajmainaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Atumka araka numamtin ainarme. Shuar árak nereachunka ajak tsupir ekeemauwaiti. Yuuscha numamtuk atumi tunauri inait nakitakrumnaka waittan amastinaitrume”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Nuna takai chichainak: ¿Isha urukmainaitji? tusar shuar aina Juankan inina. ");
INSERT INTO hubNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Tuinakai Juan chichaak: “Nugkutairam jimar arutramkaigka, shuar waita chikichik susata. Yumain arutramkaigka shuar tsukai waitaina susata”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Nuna tusa jintinkartak pujai, apunu atinan kuitan yarumin aina winasha imatti tusar jeariaruiti. Tuma chichainak: “Unuikartina, ¿ame enentaimsamsha isha urukmaina ainaji?” tusar tuina. ");
INSERT INTO hubNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Tuinakai Juan chichaak: “Apu akuptamuk, shuar akikmamu kuit jukita timauka turusrumek umiktarma. Nu inagkakrumka kuit antrarum shuar jurukirpa”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Suntar aina nitasha nui irunaina asar chichainak: “¿Turasha isha urukmainaitji? tusa tuina. Tusa tama chichaak: Shuar aina awakkarum nita waríri antrarum atankirpa. Tura shuar pegkerchaun takaschausha chicham tsanumrurairpa. Tura kuitan akirmainakaisha, chichamrutsuk shir aneasrum jukitarma”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Tusa takai shuar aina chichainak: ¿Yuus Criston akupkatnaitjai tina nuka juchauwashit? tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Nu tusa tuinamun Juan antuk chichaak: “Wika shuar tunau takatan inaisau aina nuna entsajai imajai. Turasha wina ukuruin wina nagkataku tatta nuka entsajai imakrattsuk shuar tunau takatan inaisaru ainanka Wakan Pegkera nuna susattawai. Antsu shuar tunau takatan inaisacharu ainanka waittan jijai susattawai. Nigka wina nagkatakuiti. Tuma asamtai wika nina inatairi amainaitjai, turasha wika ninka senchi arantusan iiya asan nunaka tumamaitsujai. ");
INSERT INTO hubNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Nigki tunauchu ainan tunau ainajai akantrattawai. Shuar arakan arakmau nere pegker ainan yarumuk, numirin ekeemak ajapna numamtuk, shuar tunauchu ainanka yaruak nina pujutairin kuitamak matsastinaiti. Turasha tunau ainanka nunashaa akanak, ji arumaisha kajinkashtin tuke ke atina nui matsamas waittsarti tusa ishiaktinaiti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Tusa shuar ainan chicham pegkeran jintintuk: “Yuus tu uwemtikartawai”, tusa etseru. ");
INSERT INTO hubNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Tusa jintinkartu weká asa, Herodesan, Judeanmaya apun igkua chicharuk: “Ame yatsumi Felipe nuwe Herodías nuatkaum nuka shir pegkerchauwaiti. Tura chikitcha pegkerchau aina nukap takam nuka inaisata”, tusa Juan tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Juan tusa tima Herodes senchi kajek, nu inagkas tunaun taká. Tumak Juannasha cárcelnum egkea inaisauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Eke achintsuk Juan pujus, Jordán entsanam nukap shuaran imaak pujai, Jesúscha imatti tusa tamatai imain. Jesús Juan imaim Yuusan aujeak wajai, nayaim urannaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Tumamtai Wakan Pegker yampitsa numamtin Jesúsan taruruiti. Nu tumai Yuus nayaimpinam pujusag chichaak: “Ametme wina uchir anetaimka, nui amini shir aneajai”, tusa tamau antukauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Juanka Jesúsnaka treinta uwí ejémtai imainaiti. Tura imaim pujus, nisha Yuusa chichamen jintinkartutan nagkama. Shuar ainaka Jesúsnaka José uchirinchuashit tu enentaimtu jakaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elí aparigka Matat, Matata aparigka Leví, Leví aparigka Melqui, Melqui aparigka Jana, Jana aparigka José, ");
INSERT INTO hubNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José aparigka Matatías, Matatíasa aparigka Amós, Amósa aparigka Nahúm, Nahúma aparigka Esli, Esli aparigka Nagai, ");
INSERT INTO hubNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai aparigka Maat, Maata aparigka Matatías, Matatíasa aparigka Semei, Semei aparigka José, José aparigka Judá, ");
INSERT INTO hubNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá aparigka Joanán, Joanána aparigka Resa, Resa aparigka Zorobabel, Zorobabela aparigka Salatiel, Salatiela aparigka Neri, ");
INSERT INTO hubNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri aparigka Melqui, Melqui aparigka Adi, Adi aparigka Cosam, Cosama aparigka Elmadam, Elmadama aparigka Er, ");
INSERT INTO hubNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Era aparigka Josué, Josué aparigka Eliezer, Eliezera aparigka Jorim, Jorima aparigka Matat, Matata aparigka Leví, ");
INSERT INTO hubNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Leví aparigka Simeón, Simeónka aparigka Judá, Judá aparigka José, José aparigka Jonám, Jonáma aparigka Eliaquim, ");
INSERT INTO hubNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquima aparigka Melea, Melea aparigka Mena, Mena aparigka Matata, Matata aparigka Natán, ");
INSERT INTO hubNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natánka aparigka David, Davidta aparigka Isaí, Isaí aparigka Obed, Obedta aparigka Booz, Booza aparigka Sélah, Sélah aparigka Nahasón, ");
INSERT INTO hubNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nahasónka aparigka Aminadab, Aminadabpa aparigka Admin, Adminka aparigka Arni, Arni aparigka Esrom, Esroma aparigka Fares, Faresa aparigka Judá, ");
INSERT INTO hubNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá aparigka Jacob, Jacobo aparigka Isaac, Isaacka aparigka Abraham, Abrahama aparigka Taré, Taré aparigka Nacor, ");
INSERT INTO hubNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacora aparigka Serug, Serugka aparigka Ragau, Ragau aparigka Péleg, Pélegka aparigka Heber, Hebera aparigka Sélah, ");
INSERT INTO hubNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sélah aparigka Cainán, Cainánka aparigka Arfaxad, Arfaxadta aparigka Sem, Sema aparigka Noé, Noé aparigka Lamec, ");
INSERT INTO hubNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamecka aparigka Matusalén, Matusalénka aparigka Enoc, Enocka aparigka Jared, Jaredta aparigka Mahalaleel, Mahalaleela aparigka Cainán, ");
INSERT INTO hubNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainánka aparigka Enós, Enósa aparigka Set, Seta aparigka Adán, Adánka Yuus najanamu ajakuiti. ");
INSERT INTO hubNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesús Jordán entsanam maimtai, Wakan Pegker egkemturuiti. Tura aya nugkanmag shuarsha atsamunam juki umauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Nui cuarenta tsawan pujaun, iwanch tsanuran tunaun takamtiksachainjash tusa jearnaiti. Iman tsawan yurumkan yutsuk pujau asa, Jesúscha tsukama. ");
INSERT INTO hubNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Tuma tsukamtatmaun iwanch wainak chicharuk: “Nekas Yuusa uchiriyaitkumka, tsukama pujutsuk kaya aina ju pan najanam yuata”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Tusa tama Jesús ayak: “Atsaa, turashtatjai. Aarmau awai. ‘Shuarka ima yurumkanak yusagka pujumaitsui, antsu shuarka ima Yuusa chichamejaig pujumainaiti’ ”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Tusa timatai iwanch Jesúsan juki nain tsakarunam iwakuiti. Tura ju inaktamuik ashi nugkanam warí pegker irunun iwaintukuiti. ");
INSERT INTO hubNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Tura chicharuk: “Ju nugka juigka nukap warí pegker aina irunui, tura apu senchirtin ainasha matsatui. Juka ashi winauk ainawai, tuma asamtai wika wii wakeramun sumainaitjai. ");
INSERT INTO hubNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Tikishmaram emematrita, turutawakmin ashi aminuk atii tusan amastajme”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Tama Jesús ayak: “Yuusa chichame aarmau awai: ‘Ima amina apuram Yuusa nuke eme anentsa iiyakum emematta, turakum nigki umirkata tu aarmauwaiti’ ”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Nuna tusa timatai, ataksha Jesúsan ayas yaakat Jerusalénnum umauwaiti. Tura ejé, Yuus ememattasa iruuntai jeanam yaki iwak chicharuk: “Ame nekas Yuusa uchiriyaitkumka nagkimnam iyaarta. ");
INSERT INTO hubNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Aarmau awai: ‘Yuus nina inatairi nayaimpinmaya ainan amina kuitamramatnun ishiaktinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ame tsekegkim iyakmincha, Yuus ishiakmau aina igkunmak achirmakti, iyaakum kaya aina au tukumkaim tu aarmauwaiti’ ”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Tusa tama Jesús ayak: “Chikitcha aarmau awai: ‘Amina Yuusrum tsanuram nekapsattsam wakeripa tu aarmauwaiti’ ”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Tusa tima iwanch ni tsanumaintrinka ashi tujintak: Chikich tsawantai nekapsatjai tusa ikuknaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jesús Wakan Pegker egkemturmau asa, iwanch ikukim Galileanam waketkinaiti. Tuma Galileanam jeamtai, nu nugkanmaya ainaka nina pachisar chichaina. ");
INSERT INTO hubNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Jesúscha chiki chikichik yaaktanam judío iruuntairi jeanam wayaa jintinkartau. Tuma jintinkartakai nukap shuar aina nina pachisar pegker chichaina. ");
INSERT INTO hubNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jesús Nazaretnum ni pujusa tsakarmaunam waketki pujuscha, ayamtai tsawan jeakaigka, judío iruuntainam tuke wesagke au. Tuma asa wayaa Yuusa chichamen aujsattsa wajaknaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Tumamtai Yuusa chichamen etserin Isaías aarmaun ju aujsata tusar susaruiti. Turam urak aujeak: ");
INSERT INTO hubNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Wakan Pegker wini pujawai. Tuma asa Yuus uwemtikarta nuna shuar nekainachu asar kuitrinchauwa numamtin pujuina nu, Yuusa chichame pegkera nu shuar aina ujakarta tusa etegtuawaiti. Tura shuar tunau takatan inaiyainachu asar, achikmauwa numamtuk pujuina nusha agkanmamtikawarta tusa akuptukuiti. Nuiyasha shuar wainmachu aina nu iimtikiarta, turakum shuar pegkerchau amajkur waitkam pujuina nusha agkanmamtikawarta tusa akuptukuiti. ");
INSERT INTO hubNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Yamai uwíya jui ashi shuar ainan Yuus wait anentawai tusam jusha etserkata”, tusa akupkamuitjai. ");
INSERT INTO hubNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Nu tu aarmaun aujas nukuk, papiin kuitamnun susa ekeemsauwaiti. Tura iruuntramunam matsatuka nuna aujmaun antukar, ekeemas ii irunu. ");
INSERT INTO hubNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Tumainakai Jesús ataksha chichaak: “Ju aarmauwa juka yamai tsawanta jui uminkayi”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Jesús pegkeran etserkai, shuar antuinaka yajau etseraja tusar enentai jearcharuiti. Tura nitak chichainak: “¿Ju José uchirinchuka?” tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Tusa tuinakai, Jesús nitan chicharuk: “Jusha timau awai. Tsuakratnu amek tsuamarta tusa ta numamtuk, Capernaúmnum iwainakmiam turusmek amina nugkemia juisha iwainakta tusarum turuttin ainarme. ");
INSERT INTO hubNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Turasha nekasa tajarme, Yuusa chichamen etserin nina nugken pujus etserkaigka, shir anturchau ainawai. ");
INSERT INTO hubNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Atumsha aneakrumestai: Yaunchuk Yuusa chichamen etserin Elías naartin pujai, tres uwítin nuiya seis nantu Yuus yumin yutumtikachuiti. Tuma asamtai ashi nugkanmayagka tsukai waitaina. Nu uwítin Israel nuwa waje aina nukap matsataina. Iman waje waitainakaisha Yuuska chikichkinkisha wait anentrachuiti. ");
INSERT INTO hubNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Turasha chikichik nuwa waje yaakat Sareptanam nugka Sidón tutainam tiiju aunam judío nuwachu pujaun yaigti tusa Elíasan akupkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Nukap uwí nagkamasa ai, Israel shuar aina matsatmaunam nukap shuar leprajai jaina irunu. Nu jataka yaunchuk nagkamas Yuusan chichamen etserin Eliseo naartin pujai ajakuiti. Turasha Israel shuarka chikichkiksha shir jaschau ainawai. Tuma aig, Siria nugkanmaya shuar judíochu Naamán naartin nu jatanak tukum ja pegker jasuiti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Tusa etserkai Israel shuar aina iruuntai jeanam matsamas anturu matsatuka Jesúsan ashi kajerkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Turawar Jesúsan jiikiar yaaktan ikumtikiar, nain metsagkrukunam shita ajuami tusar jukiaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Nain metsagkrukunam iwaktatku umam, Jesús nita wininamunmag ajapeen eteema waketak nuke ikuknaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Nazaretnum pujamun ikuki, Galilea nugkanam yaakat Capernaúmnum wuwaiti. Tuma ayamtai tsawan tsawaarmatai, judío iruuntairi jeanam wayaa shuar ainan jintintu. ");
INSERT INTO hubNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Jesúska yacha asa shir jintinkartakai, nuna antuinak shuar ainaka enentai jearcharuiti. ");
INSERT INTO hubNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Nui iruuntai jeanam shuar iwanch egkemtuamu pujau. Tuma senchi chichaak: ");
INSERT INTO hubNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“¡Jesús Nazaretnumiaya! ¿Urukamtai amesha ii pujamunmasha winame? ¿Ameka ina jiikratkittsamek winam? inaikartusta. Wika nekajme, ameka Yuusnumia winau asam, nekas Pegkeraitme”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Tusa tama iwanchin ayak: “Takamtak jiinkim weakum nu shuar ikukta. Tusa tamauwaik nitasha ashi wainainaig, shuaran nugkanam ajiaruiti. Turasha ishichkisha najaimamtiktsuk jiinki weak ikuknaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Tumamtai wainkar senchi ashamkar, nitak chichainak: ¿Chichamesha uruku asamtaiya iwancha anturainawa? ¡Apu chichamaina imatak chichakaimpapi iwanch jiinki weak shuaran ikuawa!” tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Nu turamun wainkar, shuar ainaka Jesús turayi, tusar ashi nugkanam etseraruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Iruunmau ashimnakmatai, Simón Pedro jeen Jesús wuwaiti. Tura jea waikma Simónkan tsatsari senchi tsuer peaknum tepaun wainkauwaiti. “Tuma wayaamtai wait aneasam pegker amajsata jakai”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Tusa tama, nuwa ja tepaun jeari chicharuk: Tsuemuya ikukta michatrati, tusa tamauwaik nuwa senchi tsuwe tepau wári michatar pegker jasuiti. Tuma nantaki shuar Jesúsjai yujan yurumkan inarak ayurawaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Nu tsawantai kintamai, chikich shuar aina patai jakai Jesús pegker amajsati tusar ikaatkaruiti. Turam Jesúscha ayatik achik pegker amaju. ");
INSERT INTO hubNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Jaina kaunkauka pegke jataikika jainachu, iwanch egkemtuam jainasha irunu asar chichainak: “Ameka Yuusa uchiriyaitme”, tusa tuina. Tusar imatainakaisha Jesúska chichakarti tusagka inaisachuiti. Shuaran iwanch egkemtua ainasha, nimpapita Cristoka tusar nekamu asa Jesús nitan chicharuk: “Takamtak asatarma”, tusa tinaiti. Tusa jiir ishimuk shuarnaka pegker amaju. ");
INSERT INTO hubNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Kanar tsawaar káshikmas yaaktan ikuki, nugka agkan shuar pujachmaunam wuwaiti. Turasha shuar ainaka eatan nagkamawar eajkama wainkaruiti. Tura wainkar chicharainak: “Weepa juig pujusmi”, tusar emetawartasa wakeruina. ");
INSERT INTO hubNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Tusa tama Jesús chichaak: “Yuus wina chichamur etserkata tusa akuptuku asamtai, wika juigkika pujumaitsujai, Yuus shuar ainan Winau arti tusa inama nuna pachisan chicham pegkeran etserkun, chikich yaaktanmasha wetaj tajai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Nuna tusa Galilea nugkanam wekaas, ashi yaaktanam judío iruuntai jeanam Yuusa chichamen etseruk weká. ");
INSERT INTO hubNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Chikich tsawantai Jesús kucha Genesaret tutai yantamen Yuusa chichamen etseruk pujaun, nukap shuar anturkartasa iruuntraru asar Jesúsan chanuina. ");
INSERT INTO hubNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Imaniku asamtai iimsatajkama Simónkan nina amikri ainajai redtrin nijainak, jimar boten aepsar pujuinan wainkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Tura Simónkan boterin Jesús egkemaa botertinan ishichik ajapeen inananta, tusa tinaiti. Tusa tama ajapeen inananmatai nui egkemas shuar ainan jintintu. ");
INSERT INTO hubNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Shuar ainan jintinta ashimak, Jesús Simónkan chicharuk: “Simónka, wiankam ajapeen inananta, turam kuna iisam redtrum nagkimam namak achikta”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Tusa tama Simón ayak: “Unuikartina, namak achiktasar red nagki nagkimkauwa tsawakrisha ishichkisha achikchaji. Turasha ame turutu asaakmin nagkimatjai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Tusa ajapeen redtan nagkimawaru, tura nukap namak chumpima asamtai, redtan jiiktajkama tujinkaruiti. Imanik chumpima asa, redtan jaaktatuk amajaina. ");
INSERT INTO hubNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Nitakka jiimainchau nekapenak, nita amikri jimar chikich botenam egketun, namak jiikmi tataarma tusa iwiju. Turam ishiintukar yaigkar redtan jinak, nukap namakan juukar botenmagka mai aimkaruiti. Tura entsaka botenmagka yaranaig anumkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simón imatika namakan achir wainak, Jesúsan tikishmatar chicharuk: “Apu, ikurkita. Wika shuar shir tunauwaitjai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simón nina boterin egkemawaru ainajaimak namakan nukap achikaru asar, senchi ashamkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Tura chikich amikri Santiago, Juan, Zebedeo uchiri aina Simónjai nitasha yujaina asar ashamkaruiti. Tumawarmatai Jesús Simónkan chicharuk: “Ashamkaipa, namak achiktasrum yujarum numamtuk yamai nagkamsarmeka, Yuusa chichame etsereakrum shuar aina Yuusnau arti tusam winau amajsatarma tusan wii jintintattajrume”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Tusa tama bote ainanka anugkaruiti, tura namak maatnaka inaiyainak Jesúsan nemarkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jesús chikich yaaktanam jeawaiti. Tumamtai nu yaaktanam chikichik shuar lepran achiimak jak pujau. Tuma asa Jesúsan wainak, tikishmar nugkanam tsuntsumaa aujuk: “Apu, ame wakerakmeka pegker amajtumainaitme”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Tusa tama Jesús jan antiak: “Wakerajai, pegker jasta tusa tamauwaik wári ashi iyashigka chimik pegker jasuiti. ");
INSERT INTO hubNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Tumamtai Jesús chicharuk: ‘Wetá, turasha chikich shuar ainaka ujakaipa. Moisés timauwa nu metek umiakum, etsertsuk sacerdote pujamunam jeata. Nuka tu aarmauwaiti: Ashi shuar lepran achiimaku pegker jasuka tuke tumasarke artinaiti. Tura chikich ainasha wainainak nekaspapi pegker jasia tiarti’ ”, tusa timauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Nu tusa etsermaun antuinak, nukap shuar nina chichamen anturkartasa tuaraina. Tura jainancha pegker amajsati tusar ikataina. ");
INSERT INTO hubNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Turuinakaisha nigka ikuak, shuarsha atsamunam Yuusan aujsattsa nigki wuwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Chikich tsawantai Jesús jintinkartakai, fariseo aina chicham umiktinan jintinkartin ainajai, Galilea nugkanmaya tura Judea nugkanmaya, tura Jerusalénnumiasha kaunkar, jea wayaawar eketaina. Tura jaina ikaankamuncha Yuus yayasam, ashi pegker amajsau. ");
INSERT INTO hubNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Shuar nukap iruuntrau asamtai, ishichkisha waimainka atsau. Tumamunam shuar wekaichun, Jesús pegker amajsati tusar jaanchin tampumrua egkeawar itariaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Turasha waitin waimainchau akirawarmatai, tujigkar jea tuntupeen wakar, jean chigkainiar, jaanchin tampumruawar Jesús pujamunam akakiaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Shuar wekaichun itaaru aina junasha pegker amajsattawapi tusar enentaimainan nekau asa, wekaichun Jesús chicharuk: “Aishmagku, yamaika ame tunaurumnaka tsagkuraujme”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Tusa Jesús timatai, chicham umiktinan jintinkartin aina, fariseo ainajai iruuntramunam matsatu nitak enentaimsar: “¿Urukamtaig nunasha tusha chichawa? Yuusan pegkerchau chicharuk tu weká jama shuaran tunaurin tsagkurmainka chikichka atsawai. Antsu ima Yuusketi tunaurumnaka tsagkuurajme tusa tukartumainka”, tu enentaimaina. ");
INSERT INTO hubNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Tu enentaimainan Jesús nekau asa chicharuk: “¿Urukamtai atumsha tusha enentaimrume? ");
INSERT INTO hubNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Shuar ja chicharkur: Amina tunaurum ainanka yamaika tsagkurajme tusa tuta nuka yupichuiti. Turasha shuarka nantaki jaanchrin juki weti tusarka pegker amajmaitsui. ");
INSERT INTO hubNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Wika shuarnum akina asan, ju nugkanam shuara tunaurincha tsagkurmainaitjai. Tuma asan atumin yamai iwaintuktajrume tusa wekaichun chicharuk: ‘Nantakim jaanchrum jukim jeemin waketkita’ ”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Tusa tamauwaik wekaichu itaamusha nantaki, jaanchrin juki jeen weak Yuusan emematuk chichaa chichaakua wuwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Wekaichu pegker jasmatai, chikich aina wainkar enentai jearcharuiti. Tumawar Yuusan emematainak: “Juna jutikaka pegke wainkachuitji”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Nuna tura ikuak jiinki wekama, shuar akikmamun apunu atinan kuitan yarumin, Leví chikich naari Mateo, kuit juaku ekeemtainam eketun wainkauwaiti. Tura chicharuk: “Weajai, wina nemartukta”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Tusa tama Levísha, ni takamurinka ashi ikuak wajaki, Jesús weakai wuwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Tuma nu tsawantaik Leví ashi amikri apunu atinan kuitan yarumin ainan chicharuk: Wina jearui kaunkatarma, yurumak Jesúsjai iruuntura yuawarmi tusa ipaawaiti. Timatai amikri ainasha wearuiti. Tuma jeanam jeawar mesanam ekeemsar, Jesúsjai yurumkan yuinak pujuina. ");
INSERT INTO hubNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Tumainan fariseo aina, chicham umiktinan jintinkartin ainajai wainkar, pegkerchauna takáwa tu enentaimaina asar Jesúsa unuinatairi ainan chicharainak: “¿Urukamtai apunu atinan kuitan yarumin ainajaisha, tura chikich shuar tunaurintin ainajai iruuntrarmesha yutai yuakrum umutaisha umarme?” tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Nuna tusa tuinamun Jesús antuk chichaak: “Shuar jachu pegker ainaka tsuakratnunka atsumchau ainawai. Antsu shuar ja aina tsuakratnunka atsumin ainawai. ");
INSERT INTO hubNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Wika shuar tunaurinchau ainanka taruachuitjai, antsu shuar tunaurintin aina tunaurin inaiyainak pegkermakati tusan taruawaitjai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Jesús tusa takai, ujumak shuar aina chichainak: “¿Urukamtai Juankan unuinatairi aina, tura fariseo ainasha yurumkan yutsuk pujusar Yuusan aujin armayi? ¿Turasha urukamtai amina unuinatairmesha yurumkan yuinak, tura umutaincha tuke umuinawa?” ");
INSERT INTO hubNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","35","Tusa tama Jesús nitan ayak: “Shir aneasa nakunkut matsatkurka ijarmakrika matsammaitsuji. Nuwenmaunam ipaamu ainaka shuar nuweenatin pujaigkika yutsukka iruunmaitsui, antsu ipaamu ainasha nuweenatin jiistamuk ipaman tsawan jeamtai jukiartata nui, wake mesemar nekapenak ijarmawartin ainawai”. ");
INSERT INTO hubNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Tusa tina chikichnasha pachis chichaak: “Jaanch yamaram asa nijam jujuak sumpeak, jaanch mamurun nu senchi jaamain asamtai, jaanch yamarman tsupikar mamurunka anujtichu ainawai. ");
INSERT INTO hubNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Nuap aparmau arutmaraunmagka, umutain vino yama umikmau yara aimka ikukmaka kariak, saurkugka nuap arut asa wagkaki weachu asamtai apujmainaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Turasha yamarmanmagka tumamaitsui, nuap yamaram asa ayatik wagkaki weakai, kariak saurkusha pegkerak amainaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Tura umutain vino yaunchuk najanamun umin ainaka yama najanamun umutan nakitainak: Yaunchuk najanamu aina au ima pegker ainawai”, tusar tinu ainawai. ");
INSERT INTO hubNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ayamtai tsawantin Jesús nina unuinatairi ainajai trigo arakmaun uturar jinta nu nagkamatai asamtai wena. Tumainak nina unuinatairi aina tsukamainak trigon kupik jukiar neren akarar yurkuta wena. ");
INSERT INTO hubNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Tumainan fariseo aina wainkar ininak: “¿Urukamtai ayamtai tsawantinka takantsashti timau aisha atumsha takarme?” tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","4","Tusa tuinakai Jesús ayak: “¿Atumka yaunchuk ina apachri David tsukamak, tura nijai yujainasha tsukamainakai, Yuus ememattasa iruuntai jeanam wayaa pan pegkermamtikamu ima sacerdote yutainak juki yuak, shuar nijai yujainancha ayurkauwa nuka aujsachuk ainarum? ");
INSERT INTO hubNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Tuma asamtai wika Yuusan uchiriyaitiatan shuarnum akina asan, ayamtai tsawan tsawarmataisha urukmainkit nuna tumainnaka wikitjai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ataksha ayamtai tsawan tsawaarmatai, Jesús judío iruuntai jeanam wayaa shuar aina iruuntramtai jintintu. Nui iruuntramunam shuar untsur uweje chuiru pujaun wainkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Turamtai fariseo aina, tura chicham umiktinan jintinkartin ainasha: Ayamtai tsawan aig, pegker amajsamtaigka Jesúska pegkerchaun takáwai tiartasa ii iruuntuina. ");
INSERT INTO hubNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Turasha Jesúska shuar enentaimainamunka nekau asa, uweje chuirun chicharuk: “Wajakim, jui ajapeen wajasta, chikich ainasha ashi waitmakarti”, tusa tinaiti. Tusa tama wajaki ajapeen wajasmatai, ");
INSERT INTO hubNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Jesús shuar ainan chicharuk: “Chikichkinak atumin iniastajrume: ¿Ayamtai tsawan tsawaaru aisha iturmainaita? ¿Pegkerchau takakrik pegker takatsuk inaimainait? ¿Ayamtai tsawan tsawarai tusarik, shuar jakaisha jakati tusa inaimainait? ¿Antsu pegker amajmainchaukait?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Nuna tina yáki aimkat tusa ishichik nakasu, turasha chikichkiksha aimkacharuiti. Tumainakai Jesús uweje chuirun chicharuk: “Kunturam nakuekta”, tusa tama kunturin nakuekuiti. Nu turamuik uweje pegker jasuiti. ");
INSERT INTO hubNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Nuna turamtai, fariseo aina tura chicham umiktinan jintinkartin ainajai senchi kajekaruiti. Tumawar itursarik Jesús maawaj tusar chichamruina. ");
INSERT INTO hubNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Chikich tsawantai Jesús Yuusan aujsattsa nainnum wuwaiti. Tuma nui waka pujus, Yuusan au aujeakua tsawaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Tuma shuar nina nemaras yujainanmayan ayatik doce shuaran ni akupkatnuri ainan anairauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Nuka ju ainawai: Simónkan Jesús naarin Pedro anaikauwa nu, Andrés, Simónka yachi, Jacob, Juan, Felipe, Bartolomé, ");
INSERT INTO hubNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, Tomás, Jacob Alfeo uchiri, chikich Simón nina nugken agkanmamtikattsa Romanmaya shuar ainajai chicha jakua nu, ");
INSERT INTO hubNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas Jacobo yachi, Judas Iscariote naartin Jesúska tu achikrum maatarma tusa shuar ainajai chichaman umirkauwa nu, imajin ajaku ainawai. ");
INSERT INTO hubNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jesús nainnum pujus, ni akupkatin ainan etegkar umik, nainnumia pakanam taamtai, nina nemarin aina chikich shuar ainajai iruuntraruiti. Tumamtai Judeanam matsamin aina, yaakat Jerusalénnumia ainasha, Tironmaya, Sidónnumia shuar ainasha, ni chicharkartamurin antukartasa, tura ja ainancha pegker amajsati tusar kaunkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Tuma nui kaunak iwanch egkemtua waitkatai ainasha pegker jasaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Jesús nina senchirijai nukap shuaran pegker amajkai, shuar jaina kaunkaruka itursarik isha ni antigka pegker jasaj tusar wakeruina. ");
INSERT INTO hubNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jesús nina unuinatairi irunun iis chichaak: “Atum ina senchirinig Yuusjai pegker pujuta nuka jumaitsuapi tusarum Yuus aujin ainatirmeka, Yuusa inamtairin pujustin asarum, shir aneasrum pujustarma. ");
INSERT INTO hubNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Shuar tsukamaka yuattsa senchi wakerinaiti, numamtuk shuar Yuus wakeramun takastasa wakeranka shir aneas pujusti, tusa Yuus yaigtatui. Yamai útu pujautirmesha, atakeapi nayaimpinam pujakun shir nakunkut enentaimsan pujutnaitja tusarum, shir aneasrum pujustarma. ");
INSERT INTO hubNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Wii shuarnum akinawaitaj nui atum wina nekaspapita turutkurmin, shuar aina kajertamainak atumka yaja wetaarma tusar jiirmainakaisha, tura atumin pachitmasar pegkerchau chichartamainakaisha, wina nemartin asarum shir aneasrum pujustarma. ");
INSERT INTO hubNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Atum jukitnuka nayaimpinam shir nukap arutramaina asarmatai, shir aneasrum pujustarma. Nita uuntri matsama jakarua nusha, Yuusa chichamen etsertin yaunchuk matsama jakarua nunasha turusag waitkasaru ainawai. ");
INSERT INTO hubNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Wiakach ainatirminka wait anentajrume. Yamaikika ju nugka jui pujusrumka, shir aneasrum nakunkut pujarme, turasha atak waittsatin ainarme. ");
INSERT INTO hubNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Atum yamaika shir yuarum ejemarum pujautirmeka, atak tsukai waittsatin ainarme. Atum wishi matsatutirmeka atak waitakrum úttin ainarme. ");
INSERT INTO hubNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Yaunchuk shuar anagkartin aina Yuusa chichamen etsernaitjai tuinakai, shuar aina shir anentu jaku aina numamtuk atumnasha ashi shuar tu chichartamainakai, shir aneatirmeka atak waittsatin ainarme”. ");
INSERT INTO hubNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Atum wina anturtautirmin tajarme: Atumin kajertamainasha anetarma. Turakrum pegkernum yaigtarma. ");
INSERT INTO hubNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Atumin pegkerchau chichartamainakaisha, pegkernum yaigtarma. Tura katsekkramainakaisha, Yuus yaigti tusarum, Yuus aujtustarma. ");
INSERT INTO hubNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Chikichik yapimin awattamkaisha, atumsha iikkarum awattsuk, juni yapiruisha awattita tusarum ayanmatatarma. Tura nugkutairmin awiik jurutramkaisha, chikishcha susatarma. ");
INSERT INTO hubNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Atsumak seatmainakaigka surittsuk susatarma. Tura atumi warírmin seatmatsuk jurutramkaisha, awagturkita tutsuk inaisatarma. ");
INSERT INTO hubNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Atum chikich ainasha shir amajtiarti tusarum wakerin ainarum tumasrumek, chikich ainasha shir amajtarma. ");
INSERT INTO hubNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Atumin anenma nuke ane pujakrumka, chikich aina nagkasau pegker takatsrume. Shuar tunaun takau ainasha nita aneniamujaigka anenain ainawai. ");
INSERT INTO hubNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Atumin yainmaina nujaig yainia pujakrumka, chikich aina nu nagkasau pegker takatsrume. Shuar tunaun takau ainasha ni yayámka yainain ainawai. Nuka tumatsuk, atumin kajertamainasha atumka yaigtarma. ");
INSERT INTO hubNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Atum amikrum ainajaig kuit ikania pujakrumka, chikich aina nagkasau pegker takatsrume. Shuar tunaun takau ainasha amikrin tsagkatkar, metekeapi awagturkittawa tusa nakau ainawai. ");
INSERT INTO hubNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Pegker ataj takurmeka atumin kajertamainasha anetarma, tumakrum pegkernum yaigtarma. Nita atsumamu tsagkatkarmesha metekeash awagturkit tusarmeka enentaimtu pujuirpa. Atum jukitnuka warí shir pegker aina nayaimpinam arutramainawai. Nu tu takakrumka nekas Yuus ashi nagkakartakua nuna uchiri atinaittrume. Yuuscha nina enentaimtichu ainan tura tunaun takainancha wait anentawai. ");
INSERT INTO hubNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Atumi apari Yuusa nu wait anenkartin asamtai, atumsha chikich ainasha wait anentin ataarma”. ");
INSERT INTO hubNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Chikich aina tunaun takainakai waitat sumainapita tu enentaimainanka, nita chikich ainan waittan uruk susattsan enentaimrauwaita turusag Yuus waittan nitan susatnaiti. Tuma asamtai atumka chikich ainan Yuus uruk waittan susatnukit tusarmeka enentaimtirpa. Atum chikich ainasha tsagkurkurminka atumnasha Yuus tsagkurtamrattarme. ");
INSERT INTO hubNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Shuar atsuma wainkurmeka susatarma, turakrumnaka Yuuscha turusag suramsattarme. Atum chikich aina uruk yayármea turusag Yuuscha atumnaka yainmaktatrume. ");
INSERT INTO hubNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jesús nunasha shir antumtikattsa chichaak: ¿Shuar mai wainmachuk jintan inaktunaimainkait? ¿Mai wainmachuk weakka, chikich tampetnum iyaakai, nisha tumasag iyaamainchaukait? ");
INSERT INTO hubNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Unuinatai ainaka jintinkartinan nagkasauka unuimamaitsui. Antsu shir unuimaru akusha, jintinkartinjai metek nekamainaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Atumka yatsum tunaun imanchaun taká aig atum ima pegkerchau takayatrum auka pegkerchaun takáwai tusarum tarume. Nu tautirmeka shuar nina jiin tsetse uun egketun waintsuk, chikichan jiin tsetse shikapchich egketun wainmaina numamtuk jarme. ");
INSERT INTO hubNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ametme pegkerchau aina nukap takaumka. ¿Tumauwaitiatmesha urukamtai amina yatsumsha pegkerchau takatka inaisata tusamsha tame? Ameka shir waitrinaitme. Yama nagkamchakmeka pegkerchau takata nu amea inaisata, tumam yatsum pegkerchaun ishichik taká nusha uruk yainmainkitam nu nekam pegkerchau takat inaisata tusam yaigta. ");
INSERT INTO hubNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Árak pegkeran nerenka pegkerchaunka neremaitsui, tura árak pegkerchaun nerencha pegkernaka neremaitsui. ");
INSERT INTO hubNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Tuma asamtai árak ainaka nina nerenig, juwapi pegkeraita tura juka pegkerchauwapita tusar nekanui. Higueraka untukra nerenka neremaitsui, tumasag untukrasha higonka neremaitsui, tura uvasha jagkinmayagka juumaitsui. ");
INSERT INTO hubNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Shuarsha numamtinaiti. Shuar pegkerka pegkernumag enentaimu asa, chichaaksha pegkernak chichauwaiti. Tura shuar pegkerchausha pegkerchaunmag enentaimu asa, chichaaksha pegkerchaunak chichauwaiti. Shuarka ni enentaimtamun chichauwaiti”. ");
INSERT INTO hubNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“¿Wii chichaamu umirtachiatrumsha urukamtai Apuru turutrume? ");
INSERT INTO hubNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Shuar wina chichamrun anturtukar umirtuina nuka, tura wini winina nuka numamtin ainawai tusan yamai titajrume: ");
INSERT INTO hubNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Wina chichamrun anturtukar umirtuinaka shuar jeen jeamuk nugka pegkernum shir init tai, kayajai pachimar jeamkauwa numamtinaiti. Nu jeanka pegker jeamkamu asamtai, yumi yutuk nujagkraksha yumpuumaitsui. ");
INSERT INTO hubNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Turasha wina chichamrun antuinayat umirtuinachuka shuar jeen jeamuk yaikminam init tautsuk jeamkauwa numamtinaiti. Nu tura jeamkamunka yumi yutuk nujagkrak, yumpug ashi utsaamainaiti. Nu jea nujag yumpuaram megkaamaina numamtuk, wina chichamrun umirtukcharuka megkaaratin ainawai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Nuna ashi etserak umik ikuak Jesús Capernaúmnum waketkinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Nui Romanmaya suntara apuri pujau. Nuna inatairi nina anetairi jakattak tepau. ");
INSERT INTO hubNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Imani tepai Jesús shuar ainan pegker amajmaun apu antukuiti. Tuma judío apuri ainan chicharuk: Jesús jearim wait aneas jui taa wina inatair ja junasha pegker amajtursati timayi tusam ujatrukta tusa akupkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Apu timatai ishiintukar Jesúsan jeariar ujainak: “Romanmaya apu pegker asa, judío ainatincha anegkratnaiti. Tuma asa nigki yainmasmatai iruuntai jeasha jeamkamji. Nuna inatairi senchi jaawai. Tuma asamtai ame shuar ja pegker amajmaun anturtamak, wina inatairnasha pegker amajtursati”, tusa turamui tuina. ");
INSERT INTO hubNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Tusa tama Jesúscha nitajai iruunar wuwaiti. Tuma jea jeattak wenai, apu nina amikri ainan igkugkrum ujaktarma tusa ishiakuiti. Tima nitasha Jesúsan igkugkar apu akattramun ujainak: Apun waitkaschatjai. Nigka wina nagkatasu asamtai, natsaamakun wina jearuigka wayata tumain nekapeatsjai. ");
INSERT INTO hubNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Tuma asan wiki eamain ayatkun eakchamjai, jearui waitskesha pegker jastii tusa tamaka wina inatairka pegker jastatui. ");
INSERT INTO hubNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Wii chicham umirmaincha matsatui, tura suntar wina umirtin ainasha arutui. Nuna wii jiintrarum shiaktarma tamaka, jinar shimumain ainawai, tura waketrarum kaunkatarma tutaisha, waketar kaunmain ainawai. Tura wina takartin ainasha wii inamka, imatiksag umin ainawai, tusa turammayi tusar ujaina. ");
INSERT INTO hubNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Tusa ujam Jesús enentai jearchauwaiti. Tuma shuar nijai iruuntra yujamun chicharuk: “Chikichik Israel shuarkesha apu nekaspapita ta imaunka wainchauwaitjai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Timatai waketar jeawar jeanam waikma shuar jasha pegker jas eketun wainkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Nuna tura ikuak Jesús yaakat Nain tutainam weakai nina unuinatairi chikich shuar ainajai iruunar weriaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Tuma yaaktanam jeajkama nuwa waje uchiri chikichik aramu jakamtai ikustasa weakai, nuna uyuunainak nukap shuar wenan wainkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Jesús nuwa wait anenmain uuttsauwa wetatmaun wainak wait anentrau, tuma chicharuk: “Utipa”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Nuna tusa ikuak natsa jakaun tuntuipanam egkeawar yanas umaina wajasarmatai, tuntuipan antiak: “Natsa, amina tajame, nantakta”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Tusa tamauwaik natsa jakausha anean nantaki ekeemas chichaa. Tumamtai uchirtinan chicharuk: Uchiram jukita, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Tura jakaun inankimtai, shuar aina wainkar, ashamkar Yuusan emematainak: “Yuusa chichamen etserin ina yainmaktin tarutramaji”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Jesús natsa jakau inankimun, Judea nugkanam matsamin aina, tura jeashtachunam matsamin ainasha ashi anturaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jesús shuar jakaun inankimun tura wainchatai aina nukap turamun Juankan unuinatairi aina antukar Juannasha ujakaruiti. Tura ujakam Juan nina unuinatairin jimaran untsuk chicharuk: ");
INSERT INTO hubNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","¿Yuus uwemtikartinan akupkatnaitjai tina nu amekaitam, tura amechuitkumnaka chikichak nakastataj? tusarum Jesús iniastarma tusa akupkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Tusa akupkam Jesúsan jeariar chicharainak: “Juan imakratna nu Yuus uwemtikartinan akupkatnaitjai tina nu nekas nimpashit nekaatarma tusa akuptamkamtai winaji. ¿Amechuitkumnaka chikichak nakastataj?” tusar inina. ");
INSERT INTO hubNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Juankan unuinatairi aina kaunkaru aisha, Jesúska pegke jatajai jainan, iwanch egkemtuamuncha tura wainmachu ainancha ashi pegker amaju. ");
INSERT INTO hubNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Tura asa jimar shuar taawaru ainan chicharuk: “Waketkitarma, tumarum atum wainkamu tura antukmausha pachisrum Juan ujakrum: Wainmachu ainan, shutua shutua wekain ainan, lepran achiimak ja ainan, empeku ainancha ashi pegker amajmayi. Tura jakau ainancha inanmayi, tura kuitrinchau ainan chicham pegkeran jintinmayi tusarum ujaktarma. ");
INSERT INTO hubNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Wii takaj juna wainainak nekaspapita turutainaka, shir aneasartin ainawai timayi tusam Juan ujaktarma”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Waketramtai, nui shuar matsatainan Juankan pachis ujakartasa iniak: “¿Wari wainkattsarmea aya nugkanmagsha wemiarme? ¿Saak nase umpui umuchiamua numamtuk, shuar pachimar enentaimin pujau wainkattsarmek wemiarum? ");
INSERT INTO hubNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Tumachkurmesha shuar pegkeran nugkur pujau wainkattsarmek wemiarum? Turasha shuar imanun nugkuaruka apu pujutainam puju ainawai. ");
INSERT INTO hubNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Turasha wari wainkattsarmea wemiarme? ¿Chikichik Yuusa chichamen etsernuk wainkattsarmek wemiarum? Nuka nekasaiti, Yuusa chichamen etserin chikichan nagkasau Juan imakratin tutaiya nu wainkattsarum wuwaitrume. ");
INSERT INTO hubNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Yuusa chichamen Juankan pachis tu aarmauwaiti: ‘Shuar ainan ame jeakmin nekaspapita tiarti tusa emtika ujakti tusan, wina chichamrun etsernun akupeajai’. ");
INSERT INTO hubNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Nekasa tajarme: Ju nugka juigka Yuusa chichamen etserin Juankan nagkasauka chikich shuarka atsawai. Turasha shuar imanchau Yuusa inamtairin nayaimpinam puja nuka, Juan nugkanam puja nuna nagkasauwaiti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","“Tusa timatai ashi shuar Juankan chichamen antukaru aina, apunu atinan kuitan yarumin ainasha Juan imaimu asar, Yuuska pegkeraiti tusar ememataina. ");
INSERT INTO hubNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Turasha fariseo aina, tura chicham umiktinan jintinkartin ainasha Yuus nitan yaigtasa wakeramaitiat Yuusan umirtan nakitaina asar, nitaka maicharu ainawai”. ");
INSERT INTO hubNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","32","Jesús nitan chicharuk: “Chikichik uchi umpuutain shir umpuin ajakuiti. Iman asa, amikri yujattamaun untsuak: Jui kaunkatarma, tumarum umpuutain wii umpuakai, jantsematarma tusa umpunmasha jantsemacharuiti. Tumawarmatai wake mesemar enentaimtikartumainan kantamruan awaniartajai tusa kantamramsha útcharuiti. Atumka numamtuk ashi nakitarme. ");
INSERT INTO hubNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Juan imakratna nu jiistatin yuinamun, tura umuinamunmasha iruttsuk pujakaisha, iwanch egkemtuamu asa ani pujawai tarume. ");
INSERT INTO hubNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Tura wii shuarnum akinan pujusan, jiistatin ipatainakai wekaasan irutkaisha, ayatik wekaas yu wekawai, umutnasha umu wekawai, shuar tunau ainan, tura Romanmaya apu kuitri atinan yarumin ainan amikriyaiti turutrume. ");
INSERT INTO hubNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Nunaka Yuus nekawai tura asa Juan takasmau ainan, tura wii takasmau ainancha mai pegkerak iiyawai”, tusa Jesús tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Fariseo, Simón naartin, Jesúsan wina jearui yurumak yuami tusa ipaawaiti. Turamu asa yurumkan yuattsa wayaa ekeemsauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Mesanam eketainai nuwa akika takatai Jesús yurumkan yuattsa Simónka jeen wemaun nekau asa, botellanam kugkuin shir akikan yaramun takus wayawaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Tuma Jesús mesanam eketun jeari naween pujuras senchi útu. Tumak nawen kugkuntuk neajkirijai ukatu, tura wiichijai ujujtur perfumejai Jesúsa nawen nijatrauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Turakai yurumak yuami tusa Jesúsan ipaka: “Ju shuar Yuusa chichamen nekas etsernaitkugka, nuwa akika takatai achia auna nekattawapi tusa enentaimas ii eketu”. ");
INSERT INTO hubNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Tu enentaimkai Jesús chicharuk: “Simónka, chikichik aujmattsa timaun ujaktajme”. Tusa tama Simónsha chichaak: “Ayu jintinkartina, ujatkata”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jesús nagkama ujak: “Shuar wiakach kuitan ikakratin ajakuiti. Nu shuar jimar shuaran kuitan tsagkatkauwaiti. Chikichan quinientos tsawan takasa akikmamainan ikasuiti, tura chikichnaka cincuenta tsawan takasa akikmamainan ikasuiti. ");
INSERT INTO hubNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Tura asa chikich tsawantai ni kuit ikasmaun kuitan awagturkiti tusa mai untsukuiti. Tura taawarmatai wiakach chicharuk: Wii kuitan ikasmiajrum nu yamai awagturkitarma, tusa tinaiti. Apu tama shuar ainasha chichainak: Apu, kuitka atsurtamji. ¿Warig amastaji? tusar tuinakai, wiakach wait anentar chicharuk: Antsu nekas awagturkirpa, tusa inaisauwaiti. ¿Amesha jimar shuaran kuitka awagturkirpa tusa apu inaisauwa nusha uruk enentaimtame? ¿Tuwa apuncha ima senchi anemainaita?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Tusa iniam Simón chichaak: “Nukap kuitan jukina nu ima senchi apunka anemainaiti. Simón takai Jesús ayak: Nuka nekas tame”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Tusa nuwan iis, Simónkan chicharuk: “Wii amina jeemin wayamtaisha, nawer nijamainka entsaka suruschaume. ¿Turasha ju nuwa wainmek? nigka ni neajkirijai nawerun ukatar, wiichijai ujujturayi. ");
INSERT INTO hubNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Tura ameka yama wayaig aujtakmesha kugkuntsachume, turasha ju nuwaka wii yama wayaig nagkama naweruigka kugkuntu pujawai. ");
INSERT INTO hubNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Mukaruisha kugkuin jukimkesha nijatkachume, turasha ju nuwaka perfumaijai nawerun nijatrurai. ");
INSERT INTO hubNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Nui tajame: ‘Nigka senchi anentui’, imania asamtai tunaurisha ashi tsagkurnarai. Tunauri nukap aramu tsagkuuramu ima senchi anentui, tura tunauri imanis atsurmau tsagkuramuka imanis anentsui. ");
INSERT INTO hubNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Nuna tusa inaiyak nuwan chicharuk: ‘Ame tunaurumka tsagkurnarai’ ”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Jesús nuwan tusa takai, ipaamu chikich aina Jesúsjai nuu mesanmag eketaina chichainak: “¿Nekas nisha tunaun tsagkurkartumainashit? tusa tunaiyaina. ");
INSERT INTO hubNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Turasha Jesús nuwan chicharuk: Ameka wina nekaspapita turutu asam yamaika uwemraume. Tuma asam shir enentaimsam amina jeemin wetá”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Jesús nina unuinatairi doce ainajai yaakat ainan irarsattsa wuwaiti. Tuma yaaktanam jeakka Yuus tu inamui tusa jintinkartuki wea. ");
INSERT INTO hubNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Tumainakai nuwa iwanch egkemtuam waitu matsatu utsanka agkanmamtikamuka, pegke jatajai jaina pegker amajsamujai Jesús chikich yaaktanam weakaisha tuke uyunaina. Nuwa Jesúsan uyuuntsau ainaka ju ainawai: María Magdalanmaya. Nuna siete iwanch egkemtuamun Jesús jiir utsantak pegker amajsamua nu, ");
INSERT INTO hubNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","tura Cuza Herodesan takarujakua nuna nuwe Juana, Susana tura chikich nuwa ainan eakar, nitajai iruunar Jesúsan yaijakaru ainawai. ");
INSERT INTO hubNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Tura yaakat ainanmaya, nukap shuar Jesúsan wainkartasa kaunaina. Tumaina asar nukap shuar tuakaruiti. Tumawarmatai Jesús nitan jintintuk arakan arakmaun pachis chichaak: ");
INSERT INTO hubNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Arakan arakmau arakan jigkain juki ajariin nagkimak ikuuttsa wuwaiti. Tuma ajariin jeaa arakan jigkain nagkimak ikuknaiti. Tura ikukmaun chikich shuar wininak, arakan jigkai jintanam kakekaun najatraruiti. Turamun chigki kautak jinta kakekaunka amukuiti. ");
INSERT INTO hubNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Chikichka nugka kayarnunam kakekar tsapainiaruiti, turasha nugka jujuptin asamtai jinaawaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Tura chikichka jagki jigkai irunmaunam kakekar tsapainiaru, tumayat jagki aina tsapainak yutuam jinawaruiti. Turamu asar arakka nerekcharuiti. ");
INSERT INTO hubNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Antsu nugka pegkernum jigkai kakekaruka tsapainiar chikichik jigkai iyaaruitiat cien jigkain nerekaruiti. Nuna ashi tina ashimak senchi chichaak: Nita antutairi aramuka wii taja nuna antukarti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Nuna tusa jintinkartua ashimkamtai, nina unuinatairi aina Jesúsan ininak: “¿Wari pachisam jintinkartakmea arakan arakmau pachismesha tame?” tusar tuina. ");
INSERT INTO hubNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Tusa tuinakai Jesús nitan ayak: “Atumnaka Yuus inammaurin pachisan timaj nunasha nekamtikramattsa wakerutmarme. Turasha chikich ainaka nuna takumpapi tawa tusarka nekamain ainatsui. Wii nukap iwainaran pegker takámun wainainaksha, wainmachua numamtuk jainawai. Tura antuinaksha nunapi taku tawa tusarka enentaimas antuinatsui. ");
INSERT INTO hubNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Arakan arakmaun pachisan taja nuka taku tawai: ‘Yuusa chichamea nuka arakan jigkaiya numamtinaiti’. ");
INSERT INTO hubNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Araka jigkai jinta kakekaun chigki amuku timaj nusha juna taku tawai: ‘Shuar Yuusa chichamen antukar nekaspapita tuinak uwemraraig, tusa iwanch juarki Yuusa chichame enentaimtamunka juruki ujumak shuar ainan emegkata nuna takun timajai’. ");
INSERT INTO hubNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Araka jigkai nugka kayarnunam kakekauka wári tsapakiat, nugka jujuptin asamtai, ujumak jina timaj nuka shuar yama Yuusa chichamen antuinakka wakerus antukariat, iturchat akai inaiyainan pachis taku tawai. ");
INSERT INTO hubNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Tura araka jigkai jagkinam kakekau timaj nuka ujumak shuar aina Yuusa chichamenka antuinayat, nitak shir amajmamkattsa wakeruinak, wiakchamattsar ima senchi wakeruina nuna takun timajai. ");
INSERT INTO hubNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Tura araka jigkai nugka pegkernum kakekaru jatsuk shir tsapai nukap nerekaru timaj nunaka, ujumak shuar pegker enentaimin Yuusa chichamen antukar nekaspapita tusar wakerus surumankar, iturchat akaisha inaitsuk pujusar, chikich shuar ainan chicham nekas pegkeran ujainak, Yuusai surumamtikainan pachis takun timajai tusa tinaiti”. ");
INSERT INTO hubNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Nuna tusa chikichan pachis jintinkartak: Chikichik shuarkesha lamparínka ekeemak nukukka inaichau ainawai. Turachkusha peak awamtakkesha apujchau ainawai. Antsu lamparínka ekeemakar, chikich ainasha tsaaptinan wainainak wayawarti, tusar yaki ekenin ainawai. ");
INSERT INTO hubNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Numamtuk atakea nui ashi shuarnau iwainakmau atinaiti, tura chikichik pegkerchauksha uukmauka atsutnaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Nuna tajarum nu shir antuktarma. Shuar nuna chichaman antukar, nekaspapita tuinanka chicham antukmaunka Yuuska emegkaattsuk nu nukap nekamtikatnaiti. Antsu shuar chicham pegker etsermaun antukaruitiat, uminachunka emegkaatkatnaiti”. ");
INSERT INTO hubNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jesús nuna tusa jintinkartak pujai, Jesúsan nukuri, tura yachi ainajai Jesúsan wainkartasa kaunkaruiti. Turasha nukap shuar tuarkar iruntuina asamtai, waitsuk aag irunu. ");
INSERT INTO hubNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Tumai chikichik shuar Jesúsan ujak: Ame nuku tura yatsum ainajai waitmakartasa kaunkar aa wajainawai tusa ujakuiti. ");
INSERT INTO hubNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Tusa tama Jesús chichaak: “Yuusa chichamen antukar umiraina jusha wina nukur, tura wina yatsur ainawai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Chikich tsawantai Jesús nina unuinatairi ainajai botenam chumpimar kucha amain katigkartasa weena. ");
INSERT INTO hubNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Nina unuinatairi aina botenka amain ikankiartasa umainai nigka kanaruiti. Tuma egketai, senchi nasentan nagkamnawaiti. Tuma senchi nasentuk botenam entsan senchi yara. Imatikak ukaimnau amajkai, senchi ashamainak, ");
INSERT INTO hubNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Jesúsan ishintainak: “Jintinkartina, nase ukatmittaji”, tusa tuina. Tama nantaki nasen chicharuk: “¡Mijaakta!” tusa tinaiti. Tusa tamauwaik nase imaniaka mijaakuiti, tuma ashi jasa asauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Tura nina unuinatairi ainan chicharuk: “¿Urukamtai ashamarme? ¿Atumka winaka nekaspapita tusarmeka turuttsurmek?” tusa tinaiti. “Tusa tama ashamkar enentai jearcharuiti”. Tumaina asar chichainak: “¿Ju shuarsha uruku asamtaiya, nasesha, tura nayantsasha ni chichamurincha umirainawa?” tusar nitak tunaiyaina. ");
INSERT INTO hubNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Nase mijaakmatai, we wenakua, Galilea amain nugka Gadara tutainam jeawaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Tuma nui anumkamtai, Jesús jiinki wean, shuar iwanch egkemtuam nukap uwí pujau Jesúsan jearnaiti. Nuka misu wekain, jeagka pujutsuk shuar jakau ikutainam puju. ");
INSERT INTO hubNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Nu shuarnaka iwanch juki, shuarsha atsamunam jeashat umau. Turam waitu wekakai, shuar aina emeta apujsartasa achikar uwejnum, tura nawenmasha cadenajai jigkararsha tujintaina. Imani wekainun Jesús wainak, iwanch nu shuarnum chumpirun chicharuk: Jiinkirum yaja shimakrum shuar ikuktaarma tusa tinaiti. Tusa tama nu shuar iwanch egkemtuamu Jesúsan jeari tikishmatar senchi chichaak: “Jesúsa, Yuus ashi nagkakartakua nuna uchiriya, wait aneasam waitkarsaipa”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Tusa takai Jesús iniak: “¿Amina naarmesha yaita?” tusa tinaiti. Tama ni ayak: “Wina naarka Untsuriyaiti”, tusa tinaiti. Nuna tina nunaka shuarnum nukap iwanch chumpiru asar tuina. ");
INSERT INTO hubNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ataksha iwanch Jesúsan chicharainak: “Wait aneasam wa nagkatkachu a nuigka chumpikratawaipa”. ");
INSERT INTO hubNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Antsu kuchi iruna ai chumpimatarma tusam titá tusar tuina. Tusa tama Jesúscha: “Ayu”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Tama shuarnaka ikuinak kuchinam chumpimawaruiti. Turam kuchisha pisarar nugka metsagkrukmaunam utsaana kuchanam iyagkar ashi jinaawaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Tumawarmatai kuchin kuitamin ainasha shuar yaaktanam matsatun, tura jeashat matsamin ainancha: Kuchi tuma jinayi tusar ujakartasa shiakaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Tuma jeawar: Kuchi tuma jinayi tusa tuina. Tusa tuinakai nuna antukar yaaktanmaya aina Jesús pujamunam wearuiti. Tumawar nui jeajkama, shuar iwanch egkemtuamu misu pujujaku, jaanchin nugkur shir enentaimkau jas Jesúsain ayaamas eketun wainkaruiti. Tura nuna wainkar senchi ashamkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Tumainakai iwanch jiirmaun wainkaruka, tu jiiramai, tusar chikich ainancha ujakaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Tusa ujainam ashi Gadaranmaya shuar ainaka senchi ashamainak Jesúsan chicharainak: “Ameka chikich nugkanam wetá”, tusar tuina. Tuinakai ayu tusa, nina unuinatairi ainajai botenam egkemaa weakai, ");
INSERT INTO hubNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","shuar iwanch chumpimtuamu jiiramusha chichaak: “Winasha Jesúsa, jurukta. Wisha ame weam nui winitjai”, tusa tinaiti. Tusa takai Jesús chicharuk: “Ameka juakta, ");
INSERT INTO hubNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","tumam Yuus iwanchin uruk jiirtamraya agkanmamtikrama nu pachisam amina pataim ainasha ashi ujakta”, tusa tinaiti. Tusa tuma ayu tusa juak nina patai aina matsatmaunam wuwaiti. Tuma ashi yaaktanmagka Jesús iwanch ainan jiirtur pegker amajtusmayi tusa etserauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Shuar aina nakaa matsatu asar, Jesús ataksha waketki Galileanam katigmatai shir aneasar jukiaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Tumainai judío iruuntai jea apuri, Jairo naartin, jeari tikishmatar wake mesek Jesúsan chicharuk: “Wina jearui wemi. ");
INSERT INTO hubNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Wina nawantur chikichik akina, doce uwí aramu jakattak tepaun ikukmaj nu pegker amajtursamnum”, tusa tinaiti. Tusa tama ayu tusa weakai, nukap shuar shimuina asar, tuarainak Jesúsnaka chanuina. ");
INSERT INTO hubNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Nu imatikainamunam chikichik nuwa nantun wainuk senchi waitak tsuakratin ainanam doce uwí wekaas tsuamak ashi ninu ainanka ashimkasha pegker jaschau, ayatik nu senchi ja wekain pachitkau. ");
INSERT INTO hubNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Tuma asa, Jesúsan wainak shuar irununmag eteemki, Jesúsa jaanchri tsakarin antinkauwaiti. Turamuik numpanka nagkanak, ashi nina iyashiin jamunka pegker jasuiti. ");
INSERT INTO hubNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Tumamtai Jesús chichaak: “¿Ya jaanchruisha antinkayi?” tusa tinaiti. Takai shuar aina chichainak yatsuk antinmaka nekatsji, tusar tuina. Tusa tuinakai Pedro wajau chichaak: “Jintinkartina, ¿ameka shuar nukap tuartamkaru asar, chanunmaina nuka waintsumek? ¿imaninaisha urukamtai ya wina jaanchruisha antinkayi, tusamsha tame?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Takai Jesús chichaak: “Chikichik shuar ja weká wina antintak, wina senchirjai pegker jasun nekaajai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Takai nuwaka wii antigkaj nunapi nekaraya, tusa kurakmaikia Jesúsan jeari tikishmatar shuar antuinai ujak: “Numpan senchi ajapeakun ja weká asan antigjame, tuman yamaika pegker jasjai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Tusa tama Jesús nuwan chicharuk: “Nawanta ameka ayatik antiamuikiapi pegker jastatja tu enentaimu asam, pegker jasume. Tuma asam shir aneasam wetá”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Eke wetsuk chichaa wajai, Jairo nawantri jakamtai, nina takarin Jairon tari ujak: “Ame nawantrumka jakamai, jintinkartinka aantram waitka wekainipa”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Tusa tamaun Jesús antuk Jairon chicharuk: “Kuntuts enentaimipa. Antsu wina nekaspapita turutta, nawantrumka nantaktatui”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Nuna tina, Jairo jeen wuwaiti. Tuma jea jeaa shuar nijai kaunkau ainanka: Atumka wayaawairpa tusa nitanka aag ikuak, Jairo jeen Jesús wayak, Pedron, Juankan, Jacobon tura Jairon nina nuwejai nawantri jaka tepamunam awayawaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Tuma shuar útu matsatun Jesús chicharuk: “¡Utirpa! nuwachika jakachai, ayatik kanar tepawai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Tusa takai: Chikich ainaka Jesúsan wishikraru. ");
INSERT INTO hubNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Tumainaig nuwach jaka tepaun jeari uwejnum achik chicharuk: “¡Nuwachi, nantakta!” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Tusa tamauwaik jaka tepau nantaki ekeemsauwaiti. Tumamtai Jesús nawantrinnun chicharuk: “Nawantrum yurumak susatarma yuati, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Tura nawantri jakau inantukim, nitaka enentain jearcharuiti. Tumainakai Jesús nawantrinnun chicharuk: Chikichik shuarkesha ju pachisrumka ujakairpa”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","2","Chikich tsawantai Jesús nina unuinatairi ainan doce etegkar untsuk irumar chicharuk: “Yamaika wina senchirun atumin amajrume. Wetaarma, tumarum chicham pegker Yuus tu inamui tusarum chikich ainasha ujaktarma. Tumakrum shuar ja ainasha, iwanch shuaran egkemtua ainasha jiirtarma tura ja ainasha pegker amajsatarma”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Tura ishimuk chichaak: “Yutaisha jinta yuatnuka jukirpa, ushukrutaisha, wampatcha, kuitcha, tura nugkutaisha jutsuk nugkuasmaujaig wetaarma. ");
INSERT INTO hubNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Tumasrumek yaaktanam jeakrumin, shuar nina jeen juramkimtaigka nuig pujusrum, chikich yaaktanam weakrum ikuktaarma. ");
INSERT INTO hubNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Antsu atum chikich yaaktanam jearum chicham etserkurmin, nuiya shuar aina nuna antutan nakitainakaigka, nu yaaktanmagka pujutsuk jiinkirum, chikichnum weakrum atumi naween tsetse irunu peatrarum nita wainmaunam akaketkarum ikuktaarma. Nuka atumka ika chichamka ujamaitiatrum atum nakitrau asaakrumin, Yuus waittan suramsatnaitrume takurum turatarma”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Tusa timatai wearu ainawai, tumawar chikich yaakat ainanam jeawar yujasar, chicham pegkeran etseraina, tura ja aina ikaatainamsha pegker amajaina. ");
INSERT INTO hubNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Apu Herodes, ashi chikich nugkanmaya ainajai, Jesúsan pachisar chichaina asarmatai, Herodes chichaak: “Juan imakratin mantamnawa nu senchirtin jas, nantakin asa wainchatai ainancha iwainawai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","9","Apu Herodes chichaak: “Turasha wii muuke tsupirkarum maatarma tima maawarmajama ¿nuiyasha yáki ainta?” tusa tinaiti. Chikich chichainak: Yaunchuk Yuusa chichamen etserin Elías tutai ajakua nu ataksha nantaki wekawai tuina. Tura chikich chichainak: Juka yaunchuk Yuusa chichamen etserin jinaawaru aina nu chikichik ataksha nantaki wekawai tusar pachimrar chichaina. Nuna tusar etserainakai, apu Herodes: Wisha itursanak Jesúsan wainkaj tusa wakera. ");
INSERT INTO hubNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Jesús akupkamu aina waketar kaunkar, nita takasmaunka Jesúsan ashi ujakaru, turam nitan ashi yaruak, yaakat Betsaidanam wuwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Tura Jesús wemaun shuar ainasha nekaawar, nitasha ishiintukar Jesús aya nugkanmag pujaun jeariaru. Turam jintinkartak chichaak: Yuuska tu inamui tusa, shuar kaunkau ainan jintintu. Turak ja ainancha pegker amaju. ");
INSERT INTO hubNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Nui pujus tuke etse etserkauwa etsa akatmakai, nina unuinatairi aina jeariar chichainak: “Ika aya nugkanmag pujaji, shuar ainaka iishiakta, nitasha waketar ayamainak yaakat tiiju a aiyan yurumkan sumak yuawarti”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Tuinakai Jesús nitan ayak: “Nuka tutsuk nita yuatnuka atum susatarma”, tusa tinaiti. Tusa tama nita chichainak: “Shuar untsuri ayurmainka atsurtamji. Antsu jimar namak, tura cinco panchik takakji. Ju shuar aina ashi ayuramij takurka, yutai sumaktasar ii wechatjiash”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Aya aishmagkuk cinco mil iruuntraruiti. Nuna tuinakai Jesús nina unuinatairi ainan chicharuk: “Shuar aina cincuenta cincuenta akantrarum chirichrinam matsastaarma”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Takai nitasha turusag shuar tuakunka akanar, ashi matsasaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Turawarmatai Jesús cinco pankan tura jimar namakan juki takus wajas, nayaimpinmani pagkai iimas, Yuusan maaketi tusa pankan namakjai puur, nina unuinatairi ainan shuar tinamkatarma tusa susauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Turawaram shuar tuakarunka ashi tinamkaruiti, turam nitasha shir yuawar ejémakaruiti. Tura pan namakjai ampintrauncha doce chagkinnum aimkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Chikich tsawantai Jesús nina unuinatairi ainajai shuar atsamunam wear, Yuusan aujainak pujuina. Nui pujus nina unuinatairi ainan iniak: “¿Shuar ainasha winasha wari turutainawa?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Nuna tusa takai, nita aimainak: “Aminka Juan imakratin ajakua nuwaiti”, tusa turamainawai. Tura chikich aina chichainak: “Elías yaunchuk puju jakua nutsukaitti turamainawai”. Tura chikich aina chichainak: “Auka yaunchuk Yuusa chichamen etserin jina aina nuiya chikichik nantaki wekawai turamainawai”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Tusa tama nitan iniak: “¿Turasha atumsha winasha wari turutrumea?” tusa tinaiti. Tusa takai Pedro ayak: “Ameka Cristowaitme, Yuus akupkamuitme”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Tusa tama wina pachittsarmeka chikichik shuarkesha ujakairpa tusa akattrau. ");
INSERT INTO hubNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","“Nuna tina ataksha chichaak: Wika shuarnum akina asan, judío apuri aina, sacerdote apuri ainasha tura chicham umiktinan jintinkartin ainasha ashi nakitainaku, senchi waitkasa maam atinaitjai. Turasha tres tsawan asan nantaktinaitjai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Nuna tusa nina unuinatairi ainan, tura chikich shuar ainajai ashi irumar chicharuk: “Atum wina nemartuktaj tautirmeka atum wakeramuka inaiyakrum nemartuktarma. Tumakrum shuar aina mantamattsa wakerutmainakaisha, wii wakeramua nuka kashi kashinig takastarma. ");
INSERT INTO hubNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Shuar wii wakeramun takainan maattsa wakeruinawai. Tuma asamtai shuar wii wakeramun takatan nakitainawai. Shuar tumau ainaka Yuusjai tuke pujuschartin ainawai. Turasha shuar wii wakeramun takau ainan maataj tamaun nekauwaitiat wii wakeramun takasaru ainaka, Yuusjai tuke pujusartin ainawai. ");
INSERT INTO hubNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Shuar ashi nugkanmaya warí ainan ninu amajeaksha, ni jakaigka nina waríriya nuka ninka pegkesha uwemtikmaitsui. Antsu nina waríriya nuke waittanmagka umamainaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Atum wina chichamur pachisa chichat natsantrau akurminka wisha turusnak, wina aparun tsaaptintrijai nayaimpinmaya shuar pegker ainajai tsaaptin kinarpatin jasan winaknasha natsantratnaitjarme. ");
INSERT INTO hubNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nekasa tajarme: Atum jui iruntrum juiyatiram eke jatsuk pujakrumka, Yuus ninu ainanam uruk inamratnukit nu wainkatin ainarme”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Nuna ashimak ocho tsawan pujus, nina unuinatairi Pedron, Jacobon, nina yachi Juanjai juki, nitajai iruunar Yuusan aujsattsa nain wakauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Tuma Jesús Yuusan aujeak pujus nina iimigka yapajinawaiti, tura jaanchrisha shir puju winchamtin jasuiti. ");
INSERT INTO hubNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Nuna tumaig jimar shuar Elías Moisésjai tsaaptin winchamtin tenteamunam pujusar Jesúsan Jerusalénnum waitkasa maam atinan pachis chichaina. ");
INSERT INTO hubNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Nuna tuma irunai Jesúsa unuinatairi tres yujainasha kara maam kanú matsatu shintajkama, Jesús tsaaptin jas wajamunam jimar shuar wajaun wainkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Tura jimar shuar Jesúsan taruaka nayaimpinam waketkittak jai Pedro Jesúsan chicharuk: “Jintinkartina, yajau juigka pujatsji. Tres aak aakmakmi, chikichik aminu, chikich Moisésnau, tura chikichka Elíasnau atii”, tusa tinaiti. Turasha Pedroka enentaimtsuk shir nekachiat tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Nuna tusa chichai, yuragkim yakiya juarki ashi nitajai irumar amuawaiti, tumakai Jesúsa unuinatairi nuna wainkar senchi ashamkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Yuragkim amuam irunai Yuus yuragminmaya chichaak: “Wina uchir nekas etegkamurka juwaiti, nigki umirkatarma”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Nuna tina inagnai, yuragmisha megkarau. Tumamtai iiyajkama Jesúsan nigki wajattamaun wainkaruiti. Nu tumamun wainkarsha chikichkiksha chikich ainanka nu tumamai tusarka ujatsuk inaisaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Kashin tsawak, nain wajakunmaya akan nukap shuar Jesúsan wainkar igkugkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Tumai chikichik shuar senchi chichaak: “Jintinkartina, wait aneasam wina uchir chikichik akinawa nu pegker amajtursata. ");
INSERT INTO hubNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Uchin iwanch egkemtua nukap waurmamtikak senchi untsumtiknayi. Ataksha taramka waurak tsekegki iyainayi, turak wenenam saun aapnayi. Turak akuptsuk waitkartinayi. ");
INSERT INTO hubNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Imatikakai amina unuinatairam ainan uchin iwanch waitkarta nu jiirturkitarma tusa tamasha tujintrutkarmayi”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Tusa ujam, Jesús chichaak: “¡Nekaspapita turutchau ainata! ¿Wini nekaspapita tutan unuimararti tusancha, urutma nukapea atumjai iruuntrancha pujumainaitja?” tusa tinaiti. Nuna tusa inaiyak: Uchiram jui itanta, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Tama uchirin juki Jesúsai ejéttak umamun, iwanch waurmamtikak uchin nugkanam ajiaruiti. Turamtai Jesús iwanchin chicharuk: “Jiinkim weakum uchi ikukta”, tusa tinaiti. Tama iwanch uchin egkemtausha jiinki weak ikuknaiti. Turam uchi pegker jasmatai: Uchirmeka yamaika jukita tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Tura uchi pegker amajsamun wainkar, nekas Yuusan senchiriniapi aitkawa tusar enentai jearcharuiti. Chikich ainaka uchi pegker amajeamun wainkaru asar, nuna pachisar chichainai, Jesús nina unuinatairi ainan chicharuk: ");
INSERT INTO hubNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Shir antuktarma, tumarum kajinmattsuk aneaku ataarma. Wii shuarnum akinawaitaj junaka achirkar shuar tunau ainanam surutkartin ainawai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Tusa takaisha nitaka nuna takumpapi tawa tusarka nekamain nekapenachu. Tumainaksha arantuina asar iniascharuiti. ");
INSERT INTO hubNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Jesúsa unuinatairi aina nitak chichainak: “Atakea nuisha ii ainaj juiyasha ¿yáki araantusa iitaisha atinaita?” tusar tuina. ");
INSERT INTO hubNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Tu enentaimainamun Jesús nekawaiti. Tuma uchin juki awajas, nina unuinatairi ainan untsuk ");
INSERT INTO hubNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","chicharuk: “Shuar wina nemartin aina, ju uchia jumamtin ainan shir anentas juinaka, wina jurak turuinawai. Turasha ima winakka juratsui, antsu wina Apar akuptukua nunasha juawai. Tura wii chikichan nagkasau achainjash tu enentaimtumauka imanuka achatnaiti. Antsu shuar iman atan enentaimtu pujuchua nu chikichan nagkasauka atinaiti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Tusa takai ni unuinatairi Juan chichaak: “Jintinkartina, shuar amina pachitmas shuaran iwanch egkemtuamu ainan iwanchin jiiru wainkamji. Tura wainkar ijai iruunar wekaichu asamtai, ameka aitkatsuk inaisata”, tusar timaji tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Tusa takai Jesús chicharuk: “Shuar wina naarjai iwanchin jiyaaka inaisata tiirpa. Shuar ina kajertamchauka ina yainmaji”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Maam nantaki nayaimpinam wetintri tsawan jeatin asamtai, ashi jintinkartamun ashimak, Jesús Jerusalénnum wuwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Tumak nina unuinatairin Samarianam jeawar kanumainan eakarti tusa jimaran emtika akupkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Turasha Samarianmaya shuar aina: Jerusalénnumia shuar ainawapi wenak, jui kanarar nagkamaktasa tuinawa tuina asar, juigka kanumaitsurme tusar suritkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Turam Jacob Juanjai waketkiar Jesúsan jeariar ujainak: “Apuru, kanumainnaka suritramkarmaji tuina. Nuna tusar chichainak: ¿Apuru, jina nayaimpinmayan akuptuk Samarianmaya shuar ainan ijinati, tusar Yuus aujmaitsujik?” tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Tusa tuinakai Jesús nitan chicharuk: “¿Atumsha uruk enentaimkurmea tarume? ");
INSERT INTO hubNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Wika shuaran ijinattsanka taachuitjai, antsu uwemtikattsan taawaitjai”, tusa tinaiti. Nuna tusa inaiyak chikich yaaktanam wearuiti. ");
INSERT INTO hubNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Nuna yaaktan ikukiar wenai shuar Jesúsan jeari chicharuk: “Apu wisha ame tuig wekaitam tumakmincha aminak tuke nemarin atajai tusan wakerajai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Takai Jesús nuna chicharuk: “Kuntin ainan waarigka aruinawai, chigkinusha kanumaintrigka pasugkesha aruinawai. Turasha wii shuarnum akinawaitaj nunaka jenchauwaitjai tura tepesa ishichik ayamaintrusha atsurtaig wekajai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Nuna tusa chikichnasha chicharuk: “Nemartukta”, tusa tinaiti. Tusa tama ni chichaak: “Apu ayu. Turasha ishichik nakarsata. Wina jearui wena, apar jakamtai ikusan ikuakun nui nemarkatjame”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Tusa takai Jesús chicharuk: “Ameka nuka pachitsuk inaisata, shuar Yuusan nekaspapita tichau asar, jakauwa numamtin aina nu apa jakamtaigka nita ikusarti tusa tinaiti. Ameka yamaika chicham pegker Yuuska tu inamui tusam etserkata”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Tusa takai chikich chicharuk: “Apu wisha amina nemarkattsan wakerajme. Turasha yama nagkamchaknaka wina jearuiya wena, wina aparun wika nu weajai tusan aujsan ikuakun, nui nemarkatjame”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Takai Jesús chichaak: “Shuar wii wakeramun takastasa wakerayat, ni wakeramun takastasa wakeraka Yuus etegkamuka amaitsui”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Chikich tsawantai Jesús nina unuinatairi ainanmayan setenta y dos shuaran ashi yaakat ainanam wii wetataj nunii wetaarma tusa jimar jimar shuaran akantrauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Tura nitan chicharuk: “Nekasa tajarme, nukap shuar Yuusan wina Apur atii tusa wakeruina matsatui. Turasha Yuusa chichamen etserin ainaka ishichkiti”. Tuma asamtai shuar chichaman etsermain ainan etegkar akupkati tusarum, Yuus aujsatarma. ");
INSERT INTO hubNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Wetaarma, turasha aneakuk wekasatarma. Atumnaka uun yawa kajen aina matsatmaunam oveja akupmaina numamtuk, shuar kajen aina matsatmaunam akupjarme. ");
INSERT INTO hubNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Weakrumsha kuitka jukirpa, wampatcha, tura zapatosha jimarka jutsuk weamasmaujaig wetaarma. Jinta wesarum shuar igkuakrumsha, nukap chichaa wajatsuk wári nagkaikitarma. ");
INSERT INTO hubNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Tura yaaktanam jeawakrumin shuar wina jearui wemii tusa ipatmakai, nui wayaatarma. Tumakrum Yuus atumnasha yainmakarti tusa titarma. ");
INSERT INTO hubNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Tura nui pujuinasha pujut pegkeran wakeruinakka, nitasha jukiartinaiti. Antsu shuar aina nuna wakeruinachuka nu pujutnaka jukichartin ainawai. ");
INSERT INTO hubNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Shuar takaka akiam awaiti. Atumsha takákrum yuja asarum, shuar nina jeen awaintamamtaigka, nuig pujusrum nita yutain amainamuka ashi yutarma, tura umutain amainakaisha umitarma. Atum takamunam nita akirmamuka nuwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Tumakrum chikich yaaktanam jeawakrumin jeentin wakerutmas jeen juramkurminka nuig pujutarma, tumarum nita yutain ajamramainakaigka yutarma. ");
INSERT INTO hubNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Tumakrum ja ainasha pegker amajkurum: “Yuus shuarnum inamratnuka tsawan ashi jeawai”, tusarum titarma. ");
INSERT INTO hubNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Tura chikich yaaktanam jeawakrumin nakitramainak, atum chicham etsermauncha anturtamainachkaigka, aa jiinkirum chichaakrum: ");
INSERT INTO hubNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Ika chichamka ujamaitiatrum, atum nakitrau asaakrumin, atumi yaaktariya tsetse ina naween irunu pearar ikuaj jusha nekaatarma: Yuus shuarnum inamratnuka tsawan ashi jeawai”, tusarum titarma. ");
INSERT INTO hubNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nu yaaktanam matsamas tuma matsatunka, shuar tunau ainan Yuus waittan susatin tsawan jeaamtai, yaunchuk Sodomanmaya shuaran waittan susauwa nu senchi waittan nitanka susartinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Corazínnumia tura Betsaidanmaya shuar ainatirminka wina nekaspapita turutcharu asaakrumin, wait anentajrume. Yaunchuk shuar Sidónnum tura Tironam matsama jaku aina nuka imatika Yuusa senchiri iwainamun wainkaru ainakka, nita tunaurinka inaiyainak uwemmain jaku ainawai. ");
INSERT INTO hubNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Turasha Yuus waitat sukartamu tsawan jeakaigka atumin ima senchi waittan suramuk, Tironmayanka, Sidónnumiajai imatikagka waittanka susashtinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Yaakat Capernaúmnum matsamin ainata, ika jakrisha nayaimpinam wetin ainaji tarume. Turasha atumka jinum egkemsarum, waittsatin ainarme. ");
INSERT INTO hubNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","“Atumin nakitramtsuk atum chicham etsermauncha anturtamainaka, winasha imanisag wakerutas anturtuinawai. Tura atumin nakitramainaka, winasha wina akuptukujai nakitruinak turutmawartatui” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Yuusa chichamen etsersauwa waketar, shir aneasar nakunkut Jesúsai kaunkaruiti. Tumawar chichainak: “Apuru, iwanch shuaran egkemtua ainasha Jesús turata tusa tinu asamtai tajame, jinkita tusa tamaka incha anturtamak shuarnaka jiinkiar ikuarmayi”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Tuinakai Jesús nitan ayak: “Iwanchnaka pem urukna numamtuk nugkanam akan wainkamiajai. ");
INSERT INTO hubNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Atumnaka iwanchin senchiri nagkasaun wina senchirun susamjarme, nui atumnaka nápi asatmainaksha, titigkisha ijutmaksha najautamaitsurme. ");
INSERT INTO hubNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Turasha iwanch anturtamainakai shir aneasairpa. Antsu atum uwemrau asarum, atumin naarigka nayaimpinam aarmau a nui, shir aneastarma”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Nuna tusa taku Wakan Pegker shir enentaimtikam, Jesús Yuusan emematuk: “Apaachi, nayaimpinmaya ainan, tura nugkanmaya ainan apurimka ameketme, iman asaakmin wika emematjame. Apaachi, shuar yacha ainaka nekamtiktsuk, shuar imanchauch aina nu etegkram amina chichamrum nekamtikamu asar, amincha nekaspapita turamiaru aina nui, maaketi tajame. Ame nu wakera asaakmin anis atii”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Nuna tusa inaiyak, nina unuinatairi ainan chicharuk: Wina aparjaigka meteketjai. Wina apar nekaa imatiksanak nekajai. Wisha yakitaj nunaka nisha nekarui, tura wisha nincha nekajai. Shuar ainaka inka nekarmainatsji, turasha wii yanak nekamtikattsan wakekauwaitja nuke inka nekarmainaji tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","24","Nuna tusa inaiyak, nina unuinatairi ainan chicharuk: Atumka wina waitkarum, wina chichamrusha anturtuinarme. Turasha yaunchuk Yuusa chichamen etserin aina tura apu ainasha wina waitkar, chichamruncha anturtukartasa wakeru jaku ainaka waitkacharu ainawai tajarme. Atumka nu wainkau asarum shir aneastarma tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Takai shuar chicham umiktinan jintinkartin Jesúsan nekapsattsa iniak: “Jintinkartina, ¿wisha pujut nagkanchaun jukittsancha urukmainaitja?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Tusa tama Jesús ayak: “¿Chicham umiktinan Moisés aarua nusha warita aarmauwaita? ¿Aujkumsha warita antame?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Tusa tama ni ayak: “Chicham umiktinka tu aarmauwaiti: Atumi apuri Yuusa nu ima senchi anetarma. Turakrum ima niinig enentaimsarum pujustarma, Yuusnau pegker aina nuke nekatarma, Yuus wakeramua nuke takastarma. Tumakrum nuiyasha atum anenmamsarum chikich shuar ainasha anetarma tawai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Takai Jesús chicharuk: “Nekas tame. Ame tame nuka metek umikta. Nu tumakum pujut nagkanchauka jukittame”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Tusa tama chicham umiktinan metek umiachu asa Jesúsan iniak: “¿Wina iyashrun aneaj turusnak wii anemain ainasha yaa aina?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Takai Jesúscha Samarianmaya shuaran pachis jintinkartak: “Jerusalénnumia shuar nigki yaakat Jericónam wetatmaun kasa aina igkugkaruiti. Turawar achikar awa awatainakua mayai jiirkiar, ashi ni takakmaurinka yarurkar, nugkuarmaurincha awitkar jurukiar wenak misu aipkiaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Turam jinta yantamen jak tepai, sacerdote nu tsawantaik nagkamajkama wainak tentaki nagkaikinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Tura ai, Leví weantu, Yuus ememattasa iruuntai jeanam takau, nisha nuke nagkamak wainkau. Turasha wajas iis tentaki weak nagkaikinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Tumai Samarianmaya shuarsha nuke nagkamajkama, shuar ashi jaka tepettamaun wainak wait anentrauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Tura asa akaatuki jeari, kasa aina awattramun vinojai nijar, aceite takusa weamun juruki, tsuamar, jaanchjai punuar, nina ekeemtairin ekeni, juki jea irar kanutainam ejé kuitamawaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Kashin tsawak nigka weak jennun akik ikuak chicharuk: ‘Ju shuar kuitamata. Wii waketkai ju nukap akirkata turutkumnasha akiktajme’ ”, tusa nigka wuwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","¿Amesha tres shuar ajakua nu pachismesha uruk enentaimam? ¿Shuar kasamin suimam tepauncha nina iyashin anemaina numamtuksha ya wait anentrauwaita? ");
INSERT INTO hubNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Tusa tama ni ayak: “Shuar suimam tepaun wainak wait anentar jukina nuwaiti”, tusa tinaiti. Takai Jesús chicharuk: “Nekas tame. Amesha amijai chikich ainasha amina iyashim aneam turusmek wait anentrata”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Nuna ashi ujak nagkamaki yaakat shikapchich aunam jeawaiti. Tumamtai nuwa Marta naartin nu yaaktanam pujau asa, Jesúsan juki nina jeen ejénaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Tura Marta kai María naartin pujau. Nu Maríaka Jesús chichakai, ninii ayaamas antu eketu. ");
INSERT INTO hubNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Tumakai Marta Jesúsan jeari chicharuk: “Apuru, wii imatikan taká pujai, wina kair ayatik eketa nu, kaim yaigta tusam akupturkata”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Tusa tama Jesús ayak: “Martaya, yurumak nukap pegker umiktasmeka imatikam enentaimtu pujuripa. ");
INSERT INTO hubNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Antsu nekas ima senchi enentaimtumainka wina chichamur antuta nuwaiti. Imanun etegka Maríaka antak eketui, tuma asamtai juka antukaipa tusanka akupmaitsujai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Chikich tsawantai Jesús Yuusan aujeak pujuttamaun, nina unuinatairi aina wainkaruiti. Tura nuna ashimkamtai, chikichik nina unuinatairi chicharuk: “Apuru, Juan nina unuinatairin jintintu jakua turusmek, Yuuscha uruk aujmainaita nu incha jintinkartuata”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Tama Jesús chichaak: “Atum Yuus aujkurmeka titarma: Apaachi, ameka nayaimpinam pujuwaitme. Pegkeraitam imau asaakmin, chikich ainasha ima aminak ashi emematramiarti. Ashi shuartin amek inakratta. ");
INSERT INTO hubNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ame ii yuatnusha kashi kashinig sukartita. ");
INSERT INTO hubNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ina tunaurisha, ii chikich aina pegkerchau takartamainasha tsagkurtaiya turusmek tsagkurkarturta. Iwanch tunaun takasti tusa ina nekapramkaisha inaikartusaipa, tura amek yaigkratkata ii nepetkami”. ");
INSERT INTO hubNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Tu aujsatarma tusa jintinta inaiyak: “Atum ainarum juiyatirmin chikichik amikrum arutramainaiti. Tuma asa nu amikrum jeashtanmaya káshi ajampek jasa ai, tsukamak tamtai, nu shuar ajammain atsurtamkai, chikich amikrumi jeen káshi jearim chicharkurum: Amikru, tres pan surusta. ");
INSERT INTO hubNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Wina amikur yajaya taruti, nu ajammain atsurtau asamtai tajame tusa tama, ");
INSERT INTO hubNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","ni chichartamuk: Waitkarsaipa, wika waitinka epenin tepajai. Tuma asan nantakin sumaitsujme ¿tumainkait? ");
INSERT INTO hubNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Nunaka tutsuk sea pujurmaka amikri asamtai nantaki sumainaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Nui tajarme, Yuuscha aujsatarma, turamka suramsattarme. Eaktarma, eakrumka wainkattarme. Untsuktarma, untsuamka waitin uratramtatrume. ");
INSERT INTO hubNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Shuar seamuka suam awaiti, tura eaka ni eamurinka wainnaiti. Tura waitinam wajas untsumusha waiti uratam awaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Atumka uchiram namakan seatmaig namak sutsuk, nápi jukirum sumainchau ainarme. ");
INSERT INTO hubNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Nu turachkurmesha uchiram nujintan seatmaig titig jukirum sumainchau ainarme. ");
INSERT INTO hubNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Atumka tunau ainayatrumsha, uchirmeka pegker suu ainarme. Atum tumarmincha Yuus nekas Pegkera imau asa, Wakan Pegker surusta tusa aujmaka surammainaitrume”, tusa Jesús tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Tura shuar iwanch egkemtuam chichachu jas pujuttamaun, Jesús iwanchi jiirki chichamtikauwaiti. Turamun wainkar shuar tuak irunuka enentai jearcharuiti. ");
INSERT INTO hubNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Tumainaig shuar nui irunu chichainak: “Juka iwanchi apuri Beelzebú naartina nuna senchirijai iwanchnaka jiiyawai”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Nuna tusar tuinaig, chikich aina Jesúsan nekas Yuus akupkamuashit tusar nekapsartasa chicharainak, wainchatai iwainakta tuina. ");
INSERT INTO hubNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Nigka shuar enentaimainamun nekau asa chichaak: “Shuar aina nuu nugkanmag matsatiat, nitak maani matsatkugka megkamain ainawai. Tura shuar nuu jeanmag iruunar matsatiat maani matsatkusha nitak megkamain ainawai. ");
INSERT INTO hubNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Tumasag iwancha nina senchirin wina surak shuaran iwanch egkemtua ainan jiirati turutkugka, nigki ninu ainajaigka tupannaimainaiti. Atum wina chichartakrum, Beelzebú senchirijai shuaran iwanch egkemtuan jiiyawai turutu asaakrumin, junaka tajarme. ");
INSERT INTO hubNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Wina iwanch nina senchirin suraisha, atumin nemartamin ainancha iwanchin jiirti tusasha, ¿ya senchirincha suawa? Tusan takai atum wina airkurum: Yuus nitanka senchirin suawai tusarum turutkurmeka: Atum wina chichartakrum iwanchin senchirijai iwanchnaka jiiyawai tusarum turutrum nunaka atumin nemartamin ainaka atum newaku tamaunka nekarmawartatui. ");
INSERT INTO hubNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Wii Yuusa senchirijai iwanch shuaran egkemtuan jiyaj nunaka, yamaika Yuus juisha shuar ainan ni inamunka inau asamtai turajai. ");
INSERT INTO hubNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Shuar kakaram nina jeen kuitamuk nagkin takus waitinam wajakaigka, warírigka metek amainaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Turasha chikich shuar nina nagkasau kakaram winituk ni nepetki, nagkin takusa wajamun atanki jea wayagka, warírinka ashi yarurak ikumainaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Shuar wina anturtachuka wina shuarmatui, tumasag wii Yuusa chichamen etsermauncha yaintainachuka iwanchin yayák tumainawai. ");
INSERT INTO hubNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","‘Iwanch shuarnum egketu jiiki ajapamka shuar atsamunam ni pujumainan eak weawai. Tuma ni pujumainan wainkachka, wii pujaun jiinkimiaj nuig waketkitjai tu enentaimui. ");
INSERT INTO hubNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Tuma waketki ni pujujakmaun tari iikma, jea shir japimka iwaramua numamtuk jas pujaun wainui. ");
INSERT INTO hubNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Tuma waketki siete iwanch nina nagkasau pegkerchau ainan yaruak wakettruki egkemtawai. Turam shuarka yaunchuk ajakmaun nu senchi pegkerchau jawai’ ”, tusa Jesús tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Nuna pachis Jesús chichaa wajai, shuar iruuntramunmaya nuwa senchi chichaak: “Nuwa amina juretmar, muntsurin amustama tsakatmarmaruka shir aneastinaiti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Tusa tama Jesús chicharuk: “Yuusa chichamen antukar uminaka nu senchi shir aneasartinaiti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Shuar aina aya tuaram, Jesús nitan chicharuk: “Yamaiya shuar aina juka tunau ainawai, tumau asar wainchatai iwainakta. Nu wainkar nekaspapita tiarmi tusa tuinawai. Turasha nita wakeramunka turashtatjai. Antsu Yuusa chichamen etserin Jonás urukawaita numamtuk nitancha iwaintukartatjai. ");
INSERT INTO hubNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Nínivenmaya shuar ainaka Jonásnaka Yuusapi akupkauwaita tusar nekawaru ainawai. Tura yamai shuar matsataina nusha wii shuarnum akinawaitaj nunasha Yuus akupkamuiti tusar nekarawartin ainawai. ");
INSERT INTO hubNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Salomón apu jas inamuk pujai, nuwa Sabánmaya shuar ainan apuri jeashat pujayat, Salomón yacha jasai tamaun antuk jearnaiti. Wii yamaika Salomónkan nagkasaun atumjaigka pujajai. Turasha wina anturtutka atumka nakitarme. Tuma asaakrumin shuar aina tunaun takasu asarmatai Yuus waittan suakai nuwa atumnasha Yuus waittan suramsattarme tusa turamtinaitrume. ");
INSERT INTO hubNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Nínivenmaya shuar ainasha turusag atumnaka Yuus waittan suramsattarme tusa turamtin ainawai. Nitanka Jonás Yuusa chichamen ujakuiti, turamu asar nitaka tunau takatan inaisaru ainawai. Turasha Jonásan nagkasaun wii yamaika atumin pujusan Yuusa chichamen ujajrume. Turasha atumka tunau takatka inaiyatsrume”. ");
INSERT INTO hubNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Chikichik shuarkesha lamparínka ekeemak nukukka inaichau ainawai. Turachkusha ukka inaichau ainawai. Antsu lamparínka ekeemakarka, chikich ainasha tsaaptinan wainainak wayawarti tusar yaki ekenin ainawai. ");
INSERT INTO hubNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ina enentaimtairiya nuka jiya numamtinaiti, jijai tsaaptin iisar shir wekatainti. Ina enentaimtairi pegkeraitkaigka ashi pegker aina nuke takamainaitji. Antsu ina enentaimtairi pegkerchauwaitkaigka pegker aina nu takatka nekamaitsuji. Nu tumakrika wainmachua numamtin amainaitji. ");
INSERT INTO hubNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Pegkerchauwa nu nekayaitkum pegkerchau takasaim kuitammamata. ");
INSERT INTO hubNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Shuar pegkera nuna nekau asa, pegkera nunak tuke takau akugka, pegkerchauwa nunaka takamaitsui. Shuar tsaaptinnum shir wainmauwa numamtuk, pegker enentaimat Yuusnumia wina nujai pegker aina nunak takamainaiti”. ");
INSERT INTO hubNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Tusa nuna jintinkartak pujai, chikichik fariseo wina jearui yurumak yuami tusa Jesúsan ipaawaiti. Turam nigka fariseo aina turutainka umitsuk fariseo jeen mesanam yurumkan yuattsa ekeemsauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Tuman wainak yuattsarum ekemkurmeka tuke ikijmasrumke ataarma timauwa nunasha umitskesha ekeemua, tusa fariseo shuarka enentai jearchauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Fariseo tu enentaimmaun Jesús nekawaiti. Tuma chicharuk: “Atum fariseo shuar ainatirmeka, shikika umutai tura plato aina nuna inittrigka nijattsuk, ukurig nijatkarum wapik ishitin ainarme. Atumin pujutincha numamtuketi. Atumka iyashmin ukunam wapik auka nijakrum ishimrume. Turasha atumin enentain chikich kasartai, surimtairam arutramaina nuka utsatsrume. ");
INSERT INTO hubNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Enentaimkachu ainata! ¿Yuus iyashin najanawa nu, ii enentaimratnun ina mutsuken najanawa nuka nekatsrumek? ");
INSERT INTO hubNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Atum pegker atasrum wakerakrumka atumin arutramaina nu shuar atsumaina susatarma. ");
INSERT INTO hubNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Fariseo shuar ainatirminka wait anentajrume. Atumka Yuus wina anenkurmeka atumin arutramuka akankarum surustatrume timaun umiaji tusarum, atumi ajariin árak menta tutai rúdajai, yurumak inarku ajunta ukugkutai tsapakmataigka, kajinmattsuk dieznumia chikichik akankarum, Yuusnau atinka iku ainarme. Nu turayatrum Yuus wait anenkartina nu, winig pegker enentaimin arti tusa wakerutma nuka pachitsuk inaiyarme. Nekas turumainaitrum nuka nuwaiti. Turasha Yuusnau atin suamua nusha kajinmatmaitsurme. ");
INSERT INTO hubNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Atum fariseo ainatirminka judío iruuntairin wayakrumsha, apu ekeemtai pegker aina imannum ekeemsattsa wakerin asaakrumin wait anentajrume. Tura jintanam wekakrum, shuar igkuntainaksha, eme anentrus amikmatainak jintinkartina turutiarti tusarum wakerin ainarme. ");
INSERT INTO hubNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Atumka shuar pegkerchau ainarme. Turasha chikich ainaka atumnaka pegkera iman iirmainawai. Atumka shuar jakau ikuakur yutuamuri panchau asa nekamainchauwa numamtin ainarme. Shuar jakau ikusmaunam nekainachu asar wekain aina numamtuk, shuar ainaka atumnaka pegkerchauwa ainawa tusarka nekarmainatsui”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Tusa Jesús tamaun chicham umiktinan jintinkartin antuk chichaak: “Jintinkartina, ame tu chichakmeka, ina pachikrattsam nitaka pegkerchau ainawai tukartakum tame”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Tusa tama Jesús ayak: “Chicham umiktinan jintinkartin ainatirmin tajarme. Chicham umiktarma tusa timauwa nuka yupichu umimainchau aig, umiktarma tusarum tarume. Atumka chikich ainaka umiktarma tusa tayatrum, atumka ishichkisha umiatsrume. Atumka shuar nigkisha juachiat chikich shuaran kijinan ayanmaina numamtuk ainarme. ");
INSERT INTO hubNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Atumi apachri aina Yuusa chichamen etserin ainan maawar ikusmaunam atum kaya irumrarum uun najanarum awajsarum matsamtuinatirmin wait anentajrume. ");
INSERT INTO hubNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Chikich shuar ainasha Yuusa chichamen etserin pegker ajaku aina imankeapi ainawa turutiarti tusarum, kaya irumrarum uun najanarum, nitaka pegkertsuk ajakuitti tumain iwainarme. Turasha atumka Yuusa chichamen etserin ainan atumin apachri maa jakarua nujai metek ainarme. ");
INSERT INTO hubNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Tumau asaakrumin Yuus ashi nekamna nu atumin pachitmas chichaak: Wina chichamrun etserin ainan, wina pachittsar shuaran chicharin ainajai ishiaktinaitjai. Turamtai ni mamunka maawartin ainawai, turuinak chikich ainanka waitkasartin ainawai tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Tuma asamtai nugka yama najanamunmag atum weantu shuar Yuusa chichamen etserin ainan kajegku aina nui atumsha nu weantuk asarum makumatin ainarme. ");
INSERT INTO hubNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Yama nagkamchak Abelan nina yachig maawa nui nagkama, Yuusa chichamen etserin ainan ni mamunka maawaru ainawai. Tura inagnamunam Zacarías naartinan Yuus ememattasa iruuntai jeanam tagku aina maa patasa epetai amaunam maawaru ainawai. Nu turamunam atumka waitat suam atinaitrume. ");
INSERT INTO hubNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Atum chicham umiktinan jintinkartin ainatirmin tajarme: Atumka Yuusa chichamea nuka nekarme, tura uruk pujakrik Yuusnau amainait nusha nekarme. Turasha atumkesha Yuusa chichamea nuka metek umiatsrume, tuma asarum chikich aina Yuusnau artasa wakeruinakaisha shir jintintsurme”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Jesús jintinkartua ashimkamtai, fariseo aina chicham umiktinan jintinkartin ainajai senchi kajerkaruiti. Tumawaru asar Jesúsan warittig timatai, apunam etsertuka achika maami, tusar Yuusa chichamen pachisar ininak waitkaina. ");
INSERT INTO hubNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Tumainai shuar ainaka nukap tuaraina asar nitak najatnaiyaina. Jesús nina unuinatairi ainan chicharuk: “Fariseo aina chikich shuar ainan chicham pegker etserji tusar tsanuina nu atumnasha tsanurmarairum aneartarma tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Chikichik uukmauksha tuke nekaachmauka asashtin ainawai. Tura nekachmau ainasha ashi nekamu artinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Tuma asamtai ashi atum káshi pujusa chichasmau aina, tura atumin kanutairmin pujusrum chikich aujmattsa chichasmau ainasha ashi shuar iruuntramunam tsaaptinnum antukartin ainawai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Nuna tusa nina unuinatairi ainan chicharuk: Amikur ainata, shuar aina atumin mantamattsa wakerutmainakaisha ashamkairpa. Atumi iyashi mainaksha wakanminka maachartin ainawai. ");
INSERT INTO hubNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Antsu atum jakaakrumin, Yuus waittan suramuk jinum chumpirmamtai, waitmainaitrum nu ashammain ainarme. ");
INSERT INTO hubNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“¿Atum ishichik kuit juakrum, cinco chigki surichuk ainarum? Turasha nunasha Yuuska wainkau asa, kajinmattsui. ");
INSERT INTO hubNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Turasha atumka chigki nagkasau ainarme, tuma asaakrumin Yuuska kajinmattramtsurme. Atumin wichi ainasha Yuus ashi nekapmarmauwaiti, tuma asamtai atumka sapijma pujuirpa. ");
INSERT INTO hubNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Nunasha tajarme: Shuar natsaamtsuk wina pachitas chichaak: Wika Cristonuitjai tusa tiarunka, wisha turusnak wii shuarnum akina asan, nayaimpinam Yuusan inatairi aina matsataina nusha antuinai, nu shuar ainan pachisan nitaka winau ainawai titinaitjai. ");
INSERT INTO hubNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Antsu shuar wina pachitas chichatan nakitak: Wika Jesúsnauchuitjai turutunka wisha aitkasnak nayaimpinam Yuusan inatairi matsataina nusha antuinai, ju shuar ainaka winauchu ainawai, tusan titinaitjai. ");
INSERT INTO hubNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Tura wii shuarnum akinawaitaj nuna aujmattrus pegkerchau chichartuku ainaka, tsagkurturta tusa tuinakka tsagkuram artinaiti. Turasha Wakan Pegkeran pachisar pegkerchau chicharainaka arumaisha tsagkuram achartin ainawai. ");
INSERT INTO hubNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Atum wina nemartin ainatirmin, achirmak judío iruuntainam ejétamawar, apu chichaman iwarin matsatmaunam tura chikich apu irunmaunam chicham nekarami tusar juramkiar umatmainakaisha, waritu chichaknak ayamrumaktaj tuka enentaimirpa. ");
INSERT INTO hubNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Apu aina atumin ininmainakai, atum chichamainnaka Wakan Pegker nekamtikramatnaitrume”. ");
INSERT INTO hubNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Jesús chichaak pujai, shuar iruuntramunmaya chikichik chichaak: “Jintinkartina, wina yatsur chicharkum apa jak warín yatsumjai akanka jukita turammauka, turusmek akanka jukita tusam”, titá tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Tusa tama Jesús ayak: “¿Ya winasha atumin apuri umatisha, ame shuar warín suritnainakaisha akantukam suu atá tusasha anaitukma?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Tusa inaiyak, shuar ainan ashi chicharuk: “Atumka waríka ashi winauk achaintash tusarum enentaimin airum pe aneartarma. Warí ainaka aantar ainawai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Nuna tusa inaiyak chikichan jintinkartak: “Shuar wiakach nukap warírtin ajakuiti. Tura ajarisha uun ainanam árak arakmauka nukap nerekaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Tuma asamtai ¿iturkatjak? Chikichik jeaksha árak juuka irummainka atsurtawapi, tu enentaimu. ");
INSERT INTO hubNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Tuma pujus enentaimrau. Tuma chichaak: ¡Yamaika enentaimrajai! Árak irumtai jea yairach aina aunka saakin nu uuntan jeamkartajai. Turan warí aina auncha nuig ashi irumratjai. ");
INSERT INTO hubNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Turan yamaika warí ainan, tura yutai ainancha nukap uwítin yumainan irumrajai. Tura asan yamaika jeag pujusan, yurumkan shir yuakun, tura umutain umakun, shir ane pujutjai tusan tumamtajai, tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Tu enentaima pujaun, Yuus chicharuk: Enentaimkachu, ameka yamai ju káshia juik jakattame. ¿Ame waríram imatikam irumraum ausha, ame jakaakmincha yanauwa atata? tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Shuar wiakchamattsa wakeruina asar, ima kuitnak enentaimtu pujuinaka Yuus iismaka atsurainawai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Nuna tusa inaiyak nina unuinatairi ainan chicharuk: “Atumnasha tajarme. Atumka warina yuanak pujustaj, warinak nugkurtaj tusarmesha imanikrum uyuma pujuirpa. ");
INSERT INTO hubNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Yuus atumin pujutan suramsauwaiti. Tura asa atum nugkurtinan tura yuatnurisha ashi ariarti tusa ni yainmaktatrume. ");
INSERT INTO hubNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Atumsha chigki enentaimtusrum iistarma. Nitaka arakan arawar yuattsagka takainatsui, tura yutairin irumrattsagsha jeancha jeamainatsui. Tumainanak nita yuatnunka Yuus suawai, turam nuna yusar matsatainawai. ¡Turasha atumetrume chigki nagkasau ainatirmeka! ");
INSERT INTO hubNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","¿Atumsha nayau atajai tusarum enentaimtu pujakrumsha nayau amainkaitrum? Nuka chikichkitirmeksha tumamaitsurme. ");
INSERT INTO hubNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Nu tumamainchau ainayatrumsha ¿urukamtai yutai tura nugkutai ainasha enentaimtu pujarme? ");
INSERT INTO hubNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Yaunchuk apu Salomón chikich shuar aina waittsa najanamun nugkutai pegker iwaramun sumak nugkur chikichan nagkasau iwarmamajakuiti. Turasha atumsha yagkur enentaimtusrum iistarma. Yagkur ainaka takainatsui, nugkutai pegker iwaramun najanawar iwarmamrartaska uruchnaksha kutamainatsui. Tumainayat yagkurukar Salomónkan nagkasau pegker iwaramu ainawai. ");
INSERT INTO hubNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","¿Urukamtai atumsha yagkur yamaikika pegkeran yagkuruk iruuntatmaun aruma nui etsa sukuam kaaktin ainancha imatikas wakerumainan Yuus iwaraisha, winasha nigkiapi wii nugkurtinan surumainaita tusarmesha nekaspapita tatsurme? ");
INSERT INTO hubNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","30","Yuusan enentaimtichu urukin aina tumarmeka warinak yuataj, tura warinak umartaj tu enentaima pujuirpa. Atum atsumainamunka atumin Apari Yuusa nu ashi nekartamrume. ");
INSERT INTO hubNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Nui yama nagkamchakrumka Yuus wakeramua nuwaa umiktarma. Tumakrumka atum atsumamusha ashi jukitnaitrume. ");
INSERT INTO hubNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Wina nemartin ainatirmeka ashamkartukairpa. Atumka ujumchik ainarme, turasha atumin Apari Yuus inatmartasa wakerutmarme. ");
INSERT INTO hubNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Atumin waríri akaigka, surukrum chikich atsumaina nu susatarma. Atum turakrumnaka Yuus nayaimpinam, kasammainchaunam kayasha emesmainchaunam ikurtamsattarme. ");
INSERT INTO hubNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Atumin waríri akaigka, nuke enentaimtu pujumainaitrume”. ");
INSERT INTO hubNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Apu inatairi, nuwenmaunam patrónkri wematai, nigka shir uminas pujus, urutma asag taat, ni taa waitin awatkai, wári urattajai, tusa, lamparínka ekeemak pujumaina numamtuk, atumsha shir umintsarum atumi apuri nakastarma. ");
INSERT INTO hubNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Patrónkri waketki tamatai shuar nuna nakaa pujuinaka shir aneasar waitin uratiar awaimainaiti. Nekasan tajarme: Nisha jea wayaa nina inatairi ainan mesanam pekak yurumkan ayurmainaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Apu inatairi ainaka ajampek aigkisha, kajinmattsuk matsamas tsawanmainak, patrónkri winaun igkugku ainaka shir anemain ainawai. ");
INSERT INTO hubNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","40","Atumsha numamtuk aneakuk matsamsatarma. Atum imanisrum nakamchamunam wii shuarnum akinawaitaj nunaka winitnaitjai tusa tinaiti. Atumsha ju enentaimtusrum iistarma: Shuar jeentin yamaiyapi kasa taa kasartuktatua tusa nekakka, kasa waya kasartukaig tau asa kanumaitsui. Kasaka ni wayatnurin pachis etserchauwa numamtuk, wisha pachiachmau tatnaitjai. ");
INSERT INTO hubNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Nuna Jesús tusa inagnakmatai, nina unuinatairi Pedro chichaak: “Apuru ¿ame jintinkartam nusha ima inkik tukartam? ¿Shuar aina ashi takumek tame?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Tusa takai Jesús ayak: “Anturtukta. Apu chikich nugkanam weaksha, takata shir inamnun chicharuk: ‘Ame jui pujusam chikich takau ainajai iruunturam takákum yutaisha ajamsarta tusa ikuwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Nu shuar patrónkri takat ikurkimunka metek umik pujakka, patrónkri tamatai shir anemainaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Nekasa tajarme, nu shuar imanis uminnaka apusha nu inagkas ninu ainanka ame kuitamkata, tusa, ninak ashi inaitumainaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Turasha nu shuar, ame ju takasta tusa shir akattra ikukmaitiat, wina apurka wári tachattawapi tusa takatsuk inaiyak, apu inatairi ainan nuwan aishmagjai senchi suimuk waitkak, apu yutai aina ikukmaun yuak tura nigka umutain umar nampeak, ");
INSERT INTO hubNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","apunka nakatsuk pujai tsawan pachiachmau taakka nincha turusag chikich inatai chichaman umichu ainajai waittan senchi sumainaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Shuar nina apuri wakeramunka shir nekayat umikchauka shir nukap waittan jumainaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Antsu shuar nina apuri nu takasta timauncha antukchau asa, pegkerchau takaksha imanik waittanka jumaitsui’. Antsu takamainan shir nekau ainanka metek takasarti tusa apuka wakerinaiti. Numamtuk Yuuscha nina chichamen shir nekaunka metekeash umikara”, tusa iistinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Wika shuar tunaun takau aina nuna waittan suakun ekemaktasan nugkanam tawaitjai. Wika waittan jukiarti tusan tumainaitjai. ");
INSERT INTO hubNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Wika itursag senchi waittsatnaitaj nu tsawan wári nagkatukia tusan senchi wakerajai. ");
INSERT INTO hubNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Atumka winaka ashi nugkanam maanitsuk agkan pujusarti tusantsuk taawaitti turutrumestai? Turasha wii tajarme, wika ashi nugkanam maanitsuk agkan pujusarti tusanka taachuitjai. ");
INSERT INTO hubNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Chikichik jeanmag cinco shuar pujuina nuiya jimar shuar wina nemartuinakai, tres shuar wina nemartutan nakitruina nitanka kajeriartinaiti, tumachkusha tres shuar wina nemartuinakaisha, jimar shuar wina nakitruinak nitan kajeriartinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Uuncha nina uchirijai kajernaiyak tupannainiartinaiti. Tura nuwasha nawantrijai kajernaiyak tupannainiartinaiti. Tura nuwasha nina tsatsarijai kajernaiyak tupannainiartinaiti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jesús nuna tina inaiyak, shuar iruuntraun chicharuk: “Atumka etsa akaatairiya atuni kiarmataigka, yumi yutuktinka shir nekarme. Atum timauka imanisag yutawai. ");
INSERT INTO hubNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Tura nase nugkaniya nasenkaisha, asat tepeattawai tarume. Atum timauka imanisag asatka tepeawai. ");
INSERT INTO hubNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Tsanumin ainata! Atumka nayaimpinmaya tura nugkanmaya iisrum, yamaika tumattawai tusarum nekau ainarme. Tumau akurmesha Yuuscha juisha winasha urukamtaig akuptukuit nuka nekatsrume”. ");
INSERT INTO hubNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“¿Urukamtai atumka nekas pegkera nuke takastasrum eatsrume? ");
INSERT INTO hubNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Amina shuarum juramki apu pujamunam ejétamtasa umatmakaigka, apuin jeatsuk, jinta wesamek shir chichasam esetuniatarma. Apu chichaman nekartama nuiyasha juramki, achikratin pujamunam ejéttammatai, achikratin achirmak cárcelnum egketmaawai. ");
INSERT INTO hubNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Nekasa tajarme, atum yuwimkartau asaakrumin apu achirmak egketmamtaigka, yuwiram akikmatskeka jiinmaitsurme. Antsu kuitrum arutramuka ashi akikmakrum jiinmainaitrume”. ");
INSERT INTO hubNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Nu tsawantaik shuar aina Jesúsan jeariaruiti. Tumawar Galileanmaya shuar aina oveja ainan maa epenak pujuinan Pilato suntaari kautak maawarmayi tusa Jesúsan ujaina. ");
INSERT INTO hubNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Tuinakai Jesús nitan chicharuk: “¿Atum enentaimsarmeka auka nita ima pegkerchau asar aitkam ainawai tarumek? ");
INSERT INTO hubNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Atsaa, turasha wii tajarme, nita ima senchi tunau asarkesha jinaacharuiti. Tura atumsha tunau takat inaiyakrum, pujutrum yapajiarum shir pujachkurmeka Yuusjaigka pujuschatin ainarme. ");
INSERT INTO hubNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","¿Atumka shuar yaunchuk Siloénam jea uun yaki jiikmau kupinak iyak, dieciocho shuaran ijinawa nusha nitaka shuar Jerusalénnum matsama jakua nuna nagkasau ima tunau asar, waittan juinak jinawaitti tarumek? ");
INSERT INTO hubNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Atsaa, turasha wii tajarme, nita ima senchi tunau asarkesha jinaacharuiti. Atumsha tunau takat inaiyakrum, pujutrum yapajiarum shir pujachkurmeka Yuusjaigka pujuschatin ainarme” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Nuna tusa inaiyak, chikichnasha jintinkartak: “Shuar nina ajariin árak higuera tutain arawaiti. Tura asa nereatsuash tusa iistasa wuwaiti. Tura jeari iikma neretsuk wajattamaun wainkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Tura wainak nina inatairin ajan kuitamuk pujuttamaun chicharuk: Tres uwítin nereatsuash tusan tarin iiyajai, turasha ju arakka nereatsui, juniayat chikich árak aramainnumka wajamaitsui. Tuma asamtai juka tsupikam ajapata tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Tusa takai inatai chichaak: Apu, yamaikika tsupitsuk nerekchatpash, chikichik uwí nakasmi. Wii nugka pegkeran yaruakan irutratjai. ");
INSERT INTO hubNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Turam nerekchatpash, turamsha nereachkai tsupikmi”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Chikich tsawantai Jesús, ayamtai tsawan tsawaarmatai, judío iruuntairin shuar iruuntrarmatai jintinkartuattsa wayaa pujau. ");
INSERT INTO hubNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Tura jintinkartak pujai, nuwa iwanch jata susamu asa, dieciocho uwítin ishichkisha tutupin jas wekaatsuk, punus wekaas waitu wekain nisha Jesús jintinkartamunam wayawaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Tuman Jesús wainak untsuk chicharuk: “¡Umaru, yamaika ame jamurmeka pegker jastatme!” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Tusa nuwan iyashi achiamuik, shir nakuek tutupin amajsauwaiti. Tura pegker amajsam Yuusan ememattan nagkamawaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ayamtai tsawan aig, nuwan pegker amajsamtai, iruuntai jea apuri senchi kajek, shuar irunun chicharuk: “Takamainka seis tsawan awai, pegker jastasrum wakerakrumka, ayamtai tsawan tsawaarmatai winitsuk nu tsawanta nui winitarma”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Takai Jesús ayak: “¡Tsanukratin ainata! Atumka ayamtai tsawan aig vacaram burrojai atiarum, entsan umarti tusarum ju ainarme. ");
INSERT INTO hubNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Wisha numamtuk iwanch jata susamu asa, ju nuwa Abraham weantu dieciocho uwí punus wekaas tuke waitu wekainun wainkan, ayamtai tsawan tsawaaru aig pegker amajsajai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Jesús tusa takai shuar nina kajerainaka ashi natsaararuiti. Turasha chikich shuar aina Jesús pegker amajkartamun wainkaru asar, ashi shir enentaimaina. ");
INSERT INTO hubNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jesús jintinkartak: “¿Atumsha Yuus inammaurisha uruk enentaimtarme? ¿Warijai apatkana Yuuska tu inamui tusancha ujamainaitjarme?” ");
INSERT INTO hubNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","“Yuus inammauka mostaza jigkaiya numamtinaiti. Mostaza taja nuka arakaiti, nuna jigkai ima shikapchiti, ajuarika wainmainchau tumau ayat araamka, uun tsakauwaiti. Tumamtai chigki ainasha nuna kanawen pasugmak juren ainawai. Yuuscha numamtuk ishichik shuarnum inamki nukap amajeawai”. ");
INSERT INTO hubNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Jesús junasha jintinkartak: “¿Warina pachisna Yuuska tu inamui tusancha ujamainaitjarme? ");
INSERT INTO hubNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Yuus shuarnum inammauka nuwa pankan najanuk, levadura tutain ishichik pachimar, uuntan wampushmamtikna numamtuk, Yuuscha ishichik shuarnum inamki nukap amajeawai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jesús Jerusalénnum wesa, yaakat uun tura shikapchich irununam Yuusa chichamen jintinkartuki wea. ");
INSERT INTO hubNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Tumai chikichik shuar iniak: “Apuru, shuar uwemrartin ainaka ishichkiapi ainawa”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Takai Jesús ayak: “Nekas tame, turasha atumka pe kakaasrum waiti menakua nui wayaatarma. Shuar nukap nui wayaawartasa wakeruinawai, turasha ashi wayaachartin ainawai. ");
INSERT INTO hubNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Wiyaitjai jeennunka, tumau asan tajarme: ‘Yamaika waitika urani awai’. Turasha tsawan jeatnaiti, tumamtai wii jennun, waitin epentinaitjai. Turanka atum aa wajasrum waiti uratrita tusa takurmincha, wii ayakun: ‘¿Tuiyantsuk ainarum? Atumnaka wainchauwaitjarme tusan titinaitjarme’. ");
INSERT INTO hubNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Tusa wii takai atum chichartakrum: ‘Apuru, ¡ii amijai yurumak iruuntura yuaku, umutcha amijai iruuntura umin ayashi! ¿Urukamtai nekakrattsume? ¡Ame jinta ewekakrattsamsha jintinkartuyame! tusarum turuttin ainarme’. ");
INSERT INTO hubNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Tusarum turutkurmincha wii ayakun: ¡Atumka winau ainatsrume! Jui matsamtsuk tunaun takau ainata wetaarma tusan titinaitjarme. ");
INSERT INTO hubNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Atumka waiti epetim aa iruuntsarum senchi útkurum, naika takertitin ainarme. Tumakrum pagkai iimsatajkamarum Abraham, Isaac, Jacob tura shuar Yuusa chichamen etserin ajaku aina nujai iruunar nayaimpinam wijai shir wara irunu wainkatin ainarme. ");
INSERT INTO hubNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ashi nugkanmaya shuar aina wina umirtukaru ainaka, Yuusa pujutairin nayaimpinam iruuntrartinaiti, tumawar wijai yurumkan yuawartasa ekeemsartinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Nu tsawantaika yamai shuar eme anentsa iitai aina nuka aantar juakartinaiti. Antsu yamaiya jui shuar eme anentsarsha iishtai aina nu ima senchi eme anentsa iiyam artinaiti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Nuna Jesús tusa jintinkartak pujai, ujumak fariseo shuar Jesúsan jeariar chicharainak: “Jintinkartina, yaja wetá, apu Herodes mantamattsa wakerutmawai”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","33","Tusa ujam, Jesús nitan chicharuk: “Apu shuar ainan tsanutan shir nekau puja nu werirum ujakrum: Wika yamaisha, kashincha tura nu kashincha shuaran iwanch egkemtuanka jiirkun, ja ainancha pegker amajkini, tsawantur jeaamtai nui inaisattajai. Yuusa chichamen etserin ainaka chikich nugkanmagka maamka amaitsui, tuma asamtai wisha Jerusalénnumag mam atasan weaj junisnak Jerusalénnum jeattsan wetatjai timayi tusarum titarma”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Jesús tusa Jerusalénnumia shuar ainan pachis chicharuk: ¡Jerusalénnumia shuar ainaka, Yuusa chichamen etserin ainancha main ainawai, tura Yuus chicharkartinan akuptukmasha, kayajai tukui tukuinakua main ainawai! ¡Tumau ainakaisha atash nina uchirin irumar nanapejai nukuk pujurna numamtuk, wisha chichamrun umirtukarti tusan irumrattsan wakerukuitjai. Turasha nitaka nunaka nakitraruiti! ");
INSERT INTO hubNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Junasha tajai: Nitan kuitamuka atsuttawai. Wii taja nunaka winaka aweta waittsuk pujuina ¡apu akupkam wina juka pegkeraiti! tusa turutainak winaka waitkartin ainawai” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","2","Ayamtai tsawan tsawaaru ai, Jesús fariseo shuaran apuri jeen yurumkan yuattsa wuwaiti. Tuma jeaakma shuar ashi iyashnum ear jak tepettamaun wainkauwaiti. Tumamtai fariseo shuar ainasha: Ayamtai tsawan aisha iturkatig, pegkerash amajsat tusar iiyaina. ");
INSERT INTO hubNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Tumainakai Jesúscha chicham umiktinan jintinkartin ainan, fariseo shuar ainajaimak chicharuk: “¿Atumsha uruk enentaimrumea, ayamtai tsawan aisha, shuar jasha pegker amajmainkait? Atsaa, ¿pegker amajmainchaukait?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Tusa takaisha aikcharuiti. Tumawarmatai shuar ear jak tepettamaun achik inanteak pegker amajsauwaiti. Tura chicharuk: “Jeemiin waketkita”, tusa akupkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Nuna tura fariseo shuar iruunar atatmaun chicharuk: “¿Ya atum ainarum nuiyasha nina uchirin, tumachkusha vacarinkisha ayamtai tsawan aig, waanam egkemaa jiinkitajkama tujig egketun wainkusha, yamaika ayamtai tsawantaiti, tuma asamtai kashin jiiktajai tusasha inaimainaita?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Jesús tama nitaka aimainchau nekapraru. ");
INSERT INTO hubNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Fariseo apuri ipaamu aina ekeemtai pegker ainan etegka ekeemainakai, Jesús wainak chicharuk: ");
INSERT INTO hubNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Atumin shuar nuwenuk jiistammaunam ipatmawarmataisha, atumka apu ekemtai etegkarmeka ekeemsattsa wakerirpa. Atum imannum ekettrumin atumin nagkatamsau chikich tamtai, ");
INSERT INTO hubNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","shuar atumin ipatma tarutrami chichartamuk: Ameka wajakta. Ju shuar ekeemsati, tusa turamkai natsaamakmaikia wajakrum shuar imanchau ekeemtairin ekeemmainaitrume. ");
INSERT INTO hubNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Nu tumawairum, atumin shuar ipatmainakaisha, atumka ekeemtai pegker aina etegtsuk ekeemsatarma. Tumakrumin atumin ipatma waitmak chichartamuk: ¿Urukamtai juninnumsha eketrume? ‘Atumka ekeemtai pegker aina ai ekeemsatarma’ tusa, shuaran emtin eketmasarmataigka chikich ainasha araanturmas iirmasartatui. ");
INSERT INTO hubNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Shuar iman anenmamuka aantar juaktinaiti. Antsu iman anenmamchauwa nu Yuus eme anentam atinaiti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Nuna tusa inaiyak, fariseo apurin chicharuk: “Shuar aina yurumak yuami tusam ipakmeka, shir ame amikrumek, ame yatsumek, ame pataimek, amijai irutkau wiakach ainak winasha aitkasag ipataati tusamka ipaawaipa. Ame nu shuar iman aina ipamka nitasha tumasag amincha yurumak yuami tusar ipatmawartatui. Turamu asam ju nugka jui akikmau atinaitme. ");
INSERT INTO hubNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Turasha ame atak jiistammaunam shuar ipakmeka, kuitrinchau aina, takamainchau aina, shutua shutua wekain aina wainmachu ainajai ipaata. ");
INSERT INTO hubNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Nitaka akirmakchartin asamtai, ame nu turakmeka atak shir aneasam pujuttame. Antsu Yuus ni pegkermamtikamu ainan inantratin tsawan jeaamtai atumin akirmakartinaiti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Jesús nuna tusa takai, mesanam shuar eketu Jesúsan chicharuk: “Yuusan inamtairin matsamsar yurumkan yuinaka shirapi aneasartin ainawa”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Nuna takai Jesús ayak: “Shuar jiistamuk yutain nukap umiktin asa, nina inatairi ainan chicharuk: Atum werum shuar nukap ipaatarma, nitasha jui kaunkar ijai yurumkan yuawarti tusa ishiakuiti. ");
INSERT INTO hubNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Turam shuar ainan ipaawaruiti, tumawar waketar kaunkamtai, jennusha yutain umik, nina inatairin chicharuk: Yamaika yutaigka uminkayi, ipaamu aina kaunkarti tusa inatairin akupkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Apu akupkamu tusa ujainam, ipamu aina ashi chichainak: ‘Wait aneasam tsagkurkarturta, ika winimainchau nekapeaji’, tusa tuina. Tura yama nagkamchakka chikichik shuar chichaak: ‘Wika winimaitsujai, yamai nugkan sumakaj nuna iistasan weajai’, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Nuna takai chikishcha chichaak: Wisha nugka tsaitai netura takamtiktai ainan, diez vacan sumakjai. Tura asan nuna nekapsattsan weajai. Tuma asan winishtatjai. Wait aneasam tsagkurturta, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Tura chikishcha chichaak: Wika yama nuweena asan winimaitsujai tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Tusar nuik ipaamu ainaka ashi nakiakarmatai, apurin jeari, nita tiarmaunka imatiksag ujakuiti. Tusa ujam, apu kajekuiti. Tuma nina inatairin ataksha chicharuk: Yamaik wári weme, shuar kuitrinchau aina, takamainchau aina, wainmachu tura shutua shutua wekain aina yaaktan aarin, tura jinta ainanam yujaina wainkam ipaam ikaankata tusa akupkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Turam nisha shuar tumau ainan yaruak ikaanak apurin ujak: ‘Apuru, ame turutmam nunaka imatiksanak ikaankajai, turasha ekeemtainka ashi enetkacharai’, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Tama ataksha apu chicharuk: Wetá, tumam yaaktan aarin shuar wekaina wainkam, weajai ai yurumak yuami tusam nakimakaisha kakantsam jukita. Wina jearui ekeemtai agkan aina auna ashi enetkarti tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Nunasha tajarme, wii yama nagkamchakun shuaran ipaamaj nuka wina jearui wayawarka yurumkanka yuachartatui”, tusa Jesús tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Jesús weakai nukap shimuina tumaina asarmatai, Jesús nitan chicharuk: ");
INSERT INTO hubNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Shuar wina nemartayat aparin, nukurin, nuwen, uchirin, yachin, umain nu aina nuna aneak, wina anenmaina nuna inagkas aneakka, wina nemartinka amaitsui. ");
INSERT INTO hubNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Atum wina nemartuktaj tautirmeka atum wakeramuka inaiyakrum nemartuktarma. Tumakrum shuar aina mantamattsa wakerutmainakaisha, wii wakeramua nuka kashi kashinig takastarma. Nuna tumatan nakitaka wina nemartinka amaitsui. ");
INSERT INTO hubNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Atum ainarum nuiya jea uuntan jeamkattsa wakerakka ¿yama nagkamchakka jea iman jeammaincha kuitcha arutuash tusa enentaimtana enentaimainchaukait? ");
INSERT INTO hubNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Shuar tumatsuk waurtuk jeen nagkama ayatik ukur, ashi umitsuk kuitrin ashimak inaisamtaigka, shuar aina nuna wainainak wishikmain ainawai. ");
INSERT INTO hubNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Turuinak: ‘Junaka nu shuar jeamkatjai tusa yamaikika nagkama, ayatik ukur jeamchamnau nekapeak inaisamiaka’, tusar tumain ainawai. ");
INSERT INTO hubNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Tura apu chikich nugkanam shuar matsamnun apurijai maaniattsa wakeraka, yama nagkamchakka nina suntarin irumar nekapmar, diez milkesha akaigka, shuar veinte mil winitruina aujaisha igkuniakan maanimainashitaj tusa ¿enentaimainchaukait? ");
INSERT INTO hubNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Tura nekapmar iis ninu ima ujumchik asamtai, shuarijai maanimainchau nekapeakka, maanitan nagkamtsuk maanitka atsuti tusa chichaman esemainaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Tuma asamtai atum ainarum nuiya ni aramun ashi inaiyachuka wina nemartinka amaitsui”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Weka jeajeatnuri aramu asa pegkeraiti. Turasha we jeajeatnuri megkakamtaigka, chikichik shuarkesha wakerumaitsui. ");
INSERT INTO hubNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","We tuma mesermataigka, ataksha waketki jeajeatu wemainchau asamtai, ayatik juki aa ajapeam amainaiti. Ni antutairi aramuka wii taja nuna shir antukarti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Jesús jintinkartakai chichamen anturkartasa nukap shuar, apunu atinan kuitan yarumin, tura chikich shuar tunau ainajai iruntuina. ");
INSERT INTO hubNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Imatikainakai, fariseo shuar aina chicham umiktinan jintinkartin ainajai iruunar Jesúsan pachisar chichainak: “Auka shuar tunau ainan amikma, nitajai iruuntur yu wekainayi”, tusar aujmataina. ");
INSERT INTO hubNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Tuinakai Jesús jintinkartak: ");
INSERT INTO hubNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Atum ainarum nuiyatiram cien oveja arutramu chikichik megkak noventinueve juakmataigka, chikich ainaka matsaakrum, chikichik megkakau eamainaitrume. ");
INSERT INTO hubNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Tura wainkarmeka shir aneasrum yanaki jukirum, ");
INSERT INTO hubNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","jea ejérum atumin amikri aina, chikich shuar atumjai tiiju matsamin ainajai chicharkurum: Oveja winau megkaakaunka yamaika wainkajai. Tuma asamtai wijai shir aneastarma tumain ainarme. ");
INSERT INTO hubNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Numamtuk chikichik shuar Yuusan umirchau asa nuikka megkaak puju, imatmam ni tunau takatairinka inaiyak pegker jas Yuusan umirkaigka, nayaimpinmaya shuar ainasha yamaika uwemrayi tusar shir anenawai. Turasha noventinueve shuar chichainak: Ika pegker ainaji. Tumau asar ina pujutigka yapajimaitsuji, tusar aantar tuinanka shir anentainatsui tajarme”, tusa Jesús tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Chikichnasha pachis jintinkartak: “Nuwa diez kuitan takaku, chikichkinak káshi jeanam ajuar, wainkattsa jina ekeematak, japimkun juruki mamikmas japimiak eamainaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Turu wekaas wainkagka shir aneas juki, nuwa tiiju matsatainan, nina amikri ainancha ashi untsuk chicharuk: Kuitnaka wainkajai. Tuma asamtai yamaika atumsha wijai shir aneastarma tusa tumainaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Numamtuk shuar tunau takatairin inaiyak, Yuusan umirkaigka, nayaimpinmaya shuar aina nusha shir anenawai”, tusa Jesús tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Chikichnasha pachis Jesús jintinkartak: Chikichik shuaran jimar uchiri arujakuiti. ");
INSERT INTO hubNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Nuna uchiri ekeu aparin chicharuk: Apaachi, warí winau amaina nuka yamaik ashi surusta tusa tinaiti. Tama aparisha uchiri ainanka nitanu amainnaka mai akantuk susauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Tura susam ishichik tsawan pujus, uchi ekeuka nina warírinka ashi surukuiti. Tura aparin ikuak, nigka yaja chikich nugkanam wuwaiti. Imanai pujus pujut pegkerchaunam kuitrinka warírijai ashi ashimkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Tura pujai, ni pujamunam tsuka tepeawaiti. Tumamtai warijaig sumak yuat nui nisha senchi tsukama. ");
INSERT INTO hubNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Tsukai senchi waitak, shuaran takarkun yurumkan irutkatjai, tusa shuar pujamunam wuwaiti. Tuma takatan inimkai, shuarsha kuchirtin asa: Ameka wina kuchir kuitamin atá tusa, kuchi matsatmaunam akupkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Turam kuchin ayuruk pujus, senchi tsukamak nita yuinamun yuattsa wakera. Turasha chikich shuarkesha yutainka suinachu. ");
INSERT INTO hubNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Turamu asa senchi tsukamak kuchi yuinakai, nigka ekeemas enentaima eketu. Tuma ekeemas: Wina aparu inatairi ainaka yutainka atsumkas yu matsataimpa, wika jui pujusan tsukai waitaja tu enentaimrauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Wina apar pujamunam waketkitjai. Tuman aparun chicharkun: Apaachi, wika yamaika Yuusnasha tunaun takarsajai, tura amincha tunaun takarsajme. ");
INSERT INTO hubNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Tuma asan wika amina uchirmeka amaitsujai. Antsu amina inatairam atajai, tuman wisha amina takartamin ainajai iruuntran takarsatjame tusan titajai, tu enentaimrauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Tu enentaimar, nina apari jeen waketkinaiti. Tuma apari pujamunam jeastatuk wetatmaun aparisha uchiri winittamaun wainkauwaiti. Tura uchirin wainak wait anentrauwaiti. Tuma tsekenki uchirin pagkuk kugkuas shir anentsauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Turam uchi aparin chicharuk: Apaachi, wika Yuusnasha tunaun takarsajai, tura amincha tunaun takarsajme. Tuma asan wika amina uchirmeka amaitsujai tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Uchiri tusa tamasha, aparigka nina inatairi ainan untsuk chicharuk: Jaanch pegker etegkarum wári anugkratarma, turakrum tsara uwejnum patakemtai patakeatarma, nawenmasha zapato weamtikatarma. ");
INSERT INTO hubNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","24","Turarum vaca yama tsaka shir nuweram iisrum, maarum inarkarum umiktarma. Uchir jakauwa numamtuk pujuwa nu yamaika iwáku tayi. Tura megkakauwa numamtuk pujuwa nu yamaika wainnakai. Tuma asamtai yutai umikaakrumin, nu yuakur jiistamawarmi tusa tinaiti. Jeentin timatai inatai ainasha ni timaurinka imatiksag umikaruiti. Turawar shir anenak jiistamtan nagkamawaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Tumainai uchiri emkauka takak wuwaiti, tuma waketki jea ashi jeattak jas jiistamainak umpuutai ainan umpuinak pampainamun antukuiti. ");
INSERT INTO hubNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Tuma inatai nui wekan untsuk chicharuk: ¡Urukakua nunasha imatruinawa! tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Tusa iniam inataisha chichaak: Amina apa yatsum taamtai, uchir jatsuk iwáku tarutmatai, waitmakjai tusa inatairi ainan vaca tsakat shir nuweram iisrum maarum inarkarum umiktarma timau asar, nuna umikar yuinak jiistamainak imatruinawai, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Tusa ujakam, uchiri emkauka senchi kajekuiti, tuma asa jea waitnaka nakitak aag wajasuiti. Tumamtai apari jiintuki chicharuk: Weajai, jea wayaami tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Tama aparin chicharuk: Apaachi, urutma uwíya wii juig pujusan, amina takarkun chichamrumnasha imatiksanak umikja nuka nekame. Tura wii imatikamaitiatmesha winaka aitkam nina amikrijai jiistamati tusamka, chikichik cabraksha suruschauwaitme. ");
INSERT INTO hubNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Winaka turutnaitiatam, ame uchiram kuitrumin aantar nuwanam ashimrutmak yamai tamatai, vaca tsakat shir nuweram mantuam ayurkum jiistamme tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Tusa tama apari ayak: ‘Uchiru, ameka wijai iruuntram tuke pujuwaitme, warí winau aina auka ashi aminu ainawai. ");
INSERT INTO hubNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Tumau aig uchir jakauwa numamtuk pujuwa nu yamaika iwáku tayi. Tura megkakauwa numamtuk pujuwa nu yamaika wainnakai. Tuma asamtai, ju jiistammauka shir anenaku jutikaji’ ”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesús chikichnasha pachis nina unuinatairi ainan jintintuk: “Chikichik shuar wiakach warírtin ajakuiti. Tuma asa chikichik shuaran wina warírun kuitamrutkati tusa eak apujsauwaiti. Nuna chikich aina wiakchan weriar chicharainak: ‘Ame shuar warí kuitamrutkata tusam apujsamam nuka warírminka ashimrutmame’, tusa ujakaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Tusa ujakam wiakchasha warí kuitamrutkata tusa apujsamun untsuk iniak: ‘¿Uruk taká asakminia amina pachitmasarsha shir takatsui, tusarsha ujatainawa? Yamaika ameka winigka takaschattame, tumatin asam wina kuitruka ashi wina warír aina nujai papiinum aaram surusta’, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Tusa tama chichaak: ¿Apur wina jiira nunasha wisha uruk takasnak pujustaja? Wii imanikan nugka tautnasha takamaitsusha, shuar ainan chicharkun: Winasha kuit antrarum surustarma tusan seama wekatancha wika natsaamajai, tu enentaima eketu. ");
INSERT INTO hubNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Tuma chichaak: Chikich ainasha wina jearui taam pujusta tusa turutcharaintash, apu ju takatnumia jiirkaisha, antsu juna turatjai tu enentaimrauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Tusa nina patrónkrin yuwimu ainan untsutan nagkamawaiti. Tura chiki chikichik shuaran untsuk itaa chicharuk: ¿Amesha wina patrónkrusha urutma yuwimam? tusa inia. ");
INSERT INTO hubNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Tama ni ayak: Wika ame patrónkrumnaka dieciseis cilindronam aceite aimkamun jukimiaj nuna yuwimjai tusa tinaiti. Takai chicharuk: Ameka nuka imatiksamkeka akikchattame. Wári jui ekeemsata. Tumam wika ocho cilindronam aceite jukimaj nuna yuwimjai tusam papiinum tu aarta, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Nuna tusa inaiyak, chikichnasha untsuk chicharuk: ‘¿Amesha urutma wina patrónkrusha yuwimam?’ tusa inia. Tusa tama nusha chichaak: ‘Wisha cien saconam trigo aimramun jukimiajai, tura asan nuna imatiksanak yuwimjai’, tusa tinaiti. Tusa takai nunasha aitkasag chicharuk: ‘Amesha wári jui ekeemsata. Tumam wika ochenta saconam trigo aimramun jukimiaj nuna yuwimjai tusam papiinum tu aarta’, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Nu tu enentaimra takamurin patrónkri nekaawaiti. Tura ju shuar tsanuma ninu atina nu jutanka yachapita tusa tinaiti. Nu jintinkartamun inaiyak Jesús chichaak: Shuar Yuusa umirchau aina nuka kuitri atsurmasha, nita amikri ainajaisha uruk pujumainkit nuna enentaimtuinawai. Turasha Yuusa umirin aina nuka nitashaa enentaimainawai, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Numamtuk atumsha atumin waríram arutramainaka, shuar atsumaina nu susatarma. Atum nu tura akurmeka nayaimpinam pujut tuke atina nui atumi amikri nukap atinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Shuar warí ishichik akaisha kuitama takatan nekaunka, apusha nu shuarnaka warín kuitamati tusa nu nukap sumainaiti. Turasha shuar warí ishichik aunkesha kuitamtan nekachunka nuiyagka sumaitsui. ");
INSERT INTO hubNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Atumnaka ju nugkanmaya warí ainaksha shir kuitama takachu asaakrumin Yuuska warí pegker nayaimpinam iruna nunaka amamaitsurme. ");
INSERT INTO hubNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Tura atum chikichan waríri shir kuitamtsuk takákrumnaka, Yuus atumin suramsattsa wakera nunaka suramsashtinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Shuarka jimar patrónkrinnuka amaitsui. Chikich patrónkrin ima senchi aneak, chikichan kajermainaiti. Tumachkusha chikich patrónkrin umiruk, chikichan nakita asa umirtsuk inaimainaiti. Numamtuk atumsha Yuus aneakrum nigki umirkattsarum wakerakrumka, kuitka anemaitsurme”. ");
INSERT INTO hubNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Jesús takai fariseo aina antukar, nita ima senchi kuitan enentaimtin asar, Jesúsan wishikaina. ");
INSERT INTO hubNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Tumainakai Jesús nitan chicharuk: “Atumka chikich shuar aina nitaka shuar pegker ainawai turutiarti tusarum tsanuarme. Turasha Yuus atum enentaimmaunka nekartamrume. Tuma asa atum imatiksa eme anentam ainatirminka Yuus kajertamainarme”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Moisés pujus shuar aina chicham umiktinan aaruiti. Turamu ai Yuusa chichamen etserin ainasha turusag Yuusa chichamen etserkaru ainawai. Tura nu chicham etsermauka Juankai nagkankauwaiti. Tumamtai Juankai nagkamnas yamaram chicham Yuus uruk inamua nu pachisa yamaika etsernawai. Tuma asamtai shuar chicham yamarman antuinak, Yuus winasha inatrati tusa senchi wakeruinawai. ");
INSERT INTO hubNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","“Ashi chicham umiktinan Moisés aarua nuka nayaim nugkajai megkatsaigkika chikichkiksha megkakashtinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Shuar nina nuwen inaiyak, chikich nuwan nuatkugka, nunaka tunaun takak tumawai. Tura nuwa ajapamun nuatusha tunaun takak tumawai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Nuna ashimak chikichnasha jintinkartak: Chikichik shuar wiakach ajakuiti, iman asa, nugkutain akikan pegkeran nugkur pujus káshi kashinig yutain yuak tuke jiistamsagke ajakuiti. ");
INSERT INTO hubNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Imani pujai shuar Lázaro naartin kuchap amuamu wiakchan waitirin ayaamas nugka pujau. ");
INSERT INTO hubNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Tuma wiakach yurumkan yuakai, nisha tsukamak mesa awamtakrin yutai kakean yuattsa wakera. Tuma pujaun yawa ainasha kuchaprin nukatainak waitkaina. ");
INSERT INTO hubNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Lázaro tuma pujau jakauwaiti. Tumamtai Yuusa inatairi nayaimpinmaya tariar, Abraham pujamunam Abrahamjai pujusti tusar jukiaruiti. Lázaro jakamu ishichik tsawan nagkamaig, wiakchasha jakauwaiti, tumamtai ikusaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Wiakach jakagka nigka shuar tunau aina matsamsa waittairin imanai wuwaiti. Tuma nui pujus senchi waitak pagkas iimsatajkama Abrahaman wainkauwaiti. Tumakma Lázaroncha Abrahamjai tsanias eketun wainkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Tura wainak Abrahaman senchi untsuak: ‘Apaachi, Abrahama winasha wait anentrurta. Tumakum ji keak imajniamunam pujusan waitaj nuna, nina tsara uwejejai entsanam inijaar, wina inairun antintruk winasha ishichik michatmamtikruati. Lázaro jui akupturkata’, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Tusa takai Abraham ayak: ‘Uchiru, ame nugka pujusmaurum anearta. Nugka pujusmeka waittsuk shir aneasam pujumiame, tumamin ju Lázaroka senchi waitmiayi. Imani jaku asa yamaika nigka jui ayamuk shir pujawai, tumai ame ima senchi waitame. ");
INSERT INTO hubNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Juiyati nui winitaj takursha japau init aka asamtai winimaitsuji. Tura nuiyatirmesha jui winittsarum wakerakrumsha juigka winimaitsurme’, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Tusa tama shuar wiakach jakau chichaak: ‘Antsu apaachi, Abrahama wait aneasam, Lázaro nugka akupkata, ni wina aparun jeen jeaa, ");
INSERT INTO hubNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","wina yatsur cinco matsama nuna shir ujakti, turam nuna antukar metek uminak nitaka ju imaj waittaiya juigka winicharti’, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Takai Abraham ayak: ‘Nitanka Moisés aarmau, tura Yuusa chichamen etserin aina aarmausha aruinawai. Nuna aujsar imatiksag uminak waittanmagka winimainchau ainawai’, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Tusa tama wiakach ayak: ‘Apaachi, Abrahama nekas tame, turasha shuar jakau nantaki chicham ujamka, nitasha nuna shuaran anturkar pujutincha yapajimain ainawai’, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Tusa takai ataksha Abraham chicharuk: Moisés Yuusa chichamen etserin ainajai aararua nuna metek umitan nakitaina asar, jakau nantaki ujamsha nekaspapita tumain ainatsui”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesús nina unuinatairi ainan chicharuk: “Shuar aina chikich ainan tunaun takamtikainaka nukap irunui. Turasha shuar ni tunaun takau asa, chikichan tunau takatnum umar tunaun takamtikainan ima senchi wait anentajai. ");
INSERT INTO hubNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Uchi wina nemartuktasa enentaimturaina nuna tunaun takamtikainaka, Yuus atak waittan sumaina nu ima pegker kaya uun jigkaar kuntejnum netua, nayantsa kunarin ajapmain ainatai”. ");
INSERT INTO hubNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","¡Pe aneartarma! “Amina yatsum tunaun takartamkaisha, yama nagkamchakmeka amek shir chicharkata. Tusa tama amina chichamin anturtamak pujutin yapajiakaigka amesha tsagkuurata. ");
INSERT INTO hubNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Tura chikichik tsawantaik sieteya imani tunaun takartamas nuu tsawantaik chichaak: Yamaika tunaunka takarsashtatjame, tusa sieteya imani tarutrama turamkaisha tsagkurata”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Tusa tama nina unuinatairi aina Jesúsan chicharainak: “Apuru, Yuusan nu senchi nekaspapita tiarti tusam yaigkratkata”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Tusa tuinakai, Jesús nitan ayak: “Atum Yuus nekaspapita tamau mostaza jigkaiya anuchiksha arutramainakaigka, ju númi waja ju chichareakrum: Yamaika nayantsanam wajasta, tusa tamaka, numisha tumasag atumin chichamen anturtamak nayantsanam wajamainaiti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Atum ainarum nuiyatirmesha, atumin inatairi nugkan tsayak wekatau, tumachkusha vacarmin kuitamuk pujau waketki jea taamtaisha, ¿urutmatirmea: ‘Amesha jui tantam ekeemsam yurumak yuata tusarmesha tumainaitrume?’ ");
INSERT INTO hubNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Nuka tutsuk: ‘Jaanchrum yapajmamam etsa akai yurumak yuatin inarkum, jui wajasam yurumkan amuakai surita, turakum umutaisha shikikam surita. Ameka wiyaa yuamtai, arum yuakum umarminam tusarum tumainaitrume’. ");
INSERT INTO hubNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Tura inatai atum timaunka imatiksag umirtamuk ajamramsamtaisha, atumka maake ame umikmaun yuaj nui tusarmesha tichau ainarme. ");
INSERT INTO hubNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Numamtuk Yuus atumin wina chichamur umirtuktarma tusa timauwa nu metek umiakrumsha, Yuus eme anentrusti tuka enentaimirpa. Antsu atum ainatiram Yuus yainmasmatai umikji tusarum tumain ainarme”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jesús Jerusalénnum weak, Samaria nugkan nagkaikinaiti tura Galilea nugkancha nagkaikinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Nuna nagkar wesa, yaakat yairach aunam jeawaiti. Tuma ai diez shuar lepra tukumu asa, ja matsamin aina Jesúsan wainkar ikag iruunas, ");
INSERT INTO hubNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","senchi untsumainak: “Jintinkartina, Jesúsa, incha wait anenkarturta”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Tusa tuinakai Jesús nitan wainak chicharuk: “Sacerdote aina Yuus ememattasa iruuntai jeanam pujuinamunam wetaarma”, tusa tinaiti. Tusa Jesús tama nitasha sacerdote aina pujuinamunam jeawartasa wesar, eke jeatsuk jintag pegker jasaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","16","Tuma chikichik Samarianmaya shuar nitajai iruunar weká nisha iimastajkama pegker jasmaun wainmamkauwaiti. Tuma nigka Jesús wajamunam wesa, Yuusan senchi emematuk Jesúsan jeari tikishmar tsuntsumaa chicharuk: Maake, ame pegker amajtusume tusa emematu. ");
INSERT INTO hubNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Tumakai Jesús chichaak: “¿Diez shuar ainan pegker amajsachmakja? ¿Nueve shuara nusha urukawarma? ");
INSERT INTO hubNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Ju chikich nugkanmaya shuar Yuusan maake taku emematuk taa jukek pegker jasma?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Tura nu shuar pegker jasun Jesús chicharuk: “Nantakim wetá. Ameka wina nekaspapita turutu asam pegker jasume”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Fariseo shuar aina Jesúsan ininak: “Jintinkartina ¿urutma asaya Yuus ina inatmamusha atinaita?” tusar tuina. Tusa tuinakai ni ayak: “Yuus inammauka chikich warí wainmain aina annuchuiti. ");
INSERT INTO hubNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Tuma asamtai chikichik shuarkesha chichaak: ‘Jui Yuuska inamui, tura ai Yuuska inammayi, tusarka tumain ainatsui. Yuuska yamaikisha atum ainarum nuiyatirminka inatmarme’ ”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Tusa inaiyak nina unuinatairi ainan chicharuk: “Atum wii shuarnum akinawaitaj nuna waketkimtai, itursarik chikichik tsawantinkisha wainkaj tusarum wakeruktinaitrum nu tsawan jeatnaiti. Tusarum takurmesha winaka waitkashtin ainarme. ");
INSERT INTO hubNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Shuar aina chichartamainak: Shuarnum akinawa nuka jui pujawai tusar turamiartinaiti. Chikishcha chichartamainak: Auka ai pujus inammayi tusar imatrutmainakaisha, atumka nekastsuk turutainatai iistajai tusarmeka, nu shuarjai tsanigkrumka wetin airpa. ");
INSERT INTO hubNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Shuarnum wii akinawaitaj nuna winaknaka, pem peteak nayaimpin ashi tsaaptin amajna numamtuk jaktinaitjai. ");
INSERT INTO hubNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Turasha yamaikika nu tsawan jeatsaigka, shuar ainasha nakitruinakai, ju nugka jui pujusan senchi waittsattajai. ");
INSERT INTO hubNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Noé pujamunam shuar urukawa ainawa numamtuk wii winamunmasha jakartinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Nu tsawantinka yumi yutatsaig matsamsarka, yutain shir yuinak, umutain umarar nampenak tura nuwentan nuwen ja matsatai, tsawan jeaamtai, Noé arcarin egkemrauwaiti. Tumamtai yumi senchi yutuk nujagkrak ashi shuaran ijinawaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Numamtuk Lot puju jakua nuisha jakaruiti. Shuar ainaka yurumkan shir yuinak, umutnasha umuinak, warí ainan sumarar suruinak, arakan arakmainak tura jeancha jeam ja matsatu. ");
INSERT INTO hubNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Turasha Lot yaakat Sodomanmaya jiinki wematai, nayaimpinmaya ji azufrejai pachimramu yumia numamtin yutuk, shuar nui matsamin ainanka aesak ashi ijinawaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Numamtuk atak shuar matsamartina nusha wina nakartsuk, nita wakeramun taká matsatainai, shuarnum akinawaitaj nunasha tatnaitjai. ");
INSERT INTO hubNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Nu tsawantinka jea tuntupe paka asamtai, nui waka pujuinaka jeanam waríri aunka akaikigka jumain ainatsui. Tura ajanam takainak yujainasha jaanchin jukitjai tusarka jeanka waketmain ainatsui. ");
INSERT INTO hubNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lotan nuwe ukurin ayanmata iikma kaya kachi najanarua nu enentaimsa iistarma. ");
INSERT INTO hubNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Shuar waittan nakitak wina nemartukcharu ainaka pujut pegker nagkanchauwa nunaka jukishtin ainawai. Antsu wina nemartak waittsaru aina nu, pujut pegker nagkanchauwa nuna jukiartin ainawai. ");
INSERT INTO hubNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Nunasha tajarme, wina nemartin wina nemartichujai jimar tsanias kanú tepausha, chikichik juaku chikichka ikuam atinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Jimar nuwaksha wina nemartin wina nemartichujai araka jigkain nekeak pujausha, chikichik juaku, chikichka ikuam atinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Jimar aishmag, wina nemartin wina nemartichujai ajanam takak wekasha, chikichik juaku chikichka ikuam atinaiti”. ");
INSERT INTO hubNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Nuna takai Jesúsan ininak: “Apuru, ¿nusha tuig nekascha tumatnaita?” tusar tuina. Tusa tuinakai Jesús ayak: “Chuag tuak irunun wainainakka juigka jakau tepawai, tusa nekau ainawai”. ");
INSERT INTO hubNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jesús nitasha Yuus aujtanka mijaatsuk tuke aujsagkee arti tusa, nina unuinatairi ainan chikichnasha pachis jintintuk: ");
INSERT INTO hubNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Chikichik yaaktanam apu chichaman iwarin puju jakuiti. Turasha nu apuka Yuusnasha enentaimtichu, chikich shuar ainancha araantus enentaimtichu ajakuiti. ");
INSERT INTO hubNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Nu yaaktanmag nuwa wajesha puju jakuiti. Tuma shuarijai chichaman aeprunia asa, shuari waitkam apu chichaman iwarin pujaun jeari chicharuk: Wait aneasam yainkata, juna esetunian shir agkan pujustajai tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Tusa tamasha apu chichaman iwarnuka nuwa waje yaitnaka nakita. Turamaitiatcha nuwaka mijatrutsuk apunka tuke wakettrusag pujuru. Imatikam apusha enentaimar chichaak: Yuusnaka enentaimtichuitjai, tura chikich shuar ainancha araantusan enentaimtichuitjai. ");
INSERT INTO hubNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Turasha ju nuwa waje shuari waitkam aru arumag taak waitkara junaka wii yaigkan, chichaman iwarturan agkan inaisatjai, turam agkan inaitusti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Jesús nuna pachis chichaak: “Apu tunau ayatcha nuwa wajen tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","¿Yuuska ni etegkamuri aina iturchatnum pujusar waitainak tsawai tura káshisha aujmasha, yaitskek inaimainait? ¿Tura wári yainmatskek nukap asan yaigtajai tusa inaitammainaitrum? ");
INSERT INTO hubNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nekas tajarme, Yuuska imatika aujmaka, wári yainmamainaitrume. Turasha wii shuarnum akinawaitaj nuna ataksha ju nugkanam winaknaka ¿shuar ainasha winig nekaspapita tu enentaima matsatunash wainkatnaitaj?” tusa Jesús tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jesús, shuar nita ima pegker anenmamainak, chikich shuar ainanka tunau ainawai tusar nakitin ainan shir antumtikattsa junasha pachis jintintuk: ");
INSERT INTO hubNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Jimar shuar Yuusan aujsattsa Yuus ememattasa iruuntai jeanam wearuiti. Chikichka fariseo shuar ajakuiti, tura chikichka apunu atinan kuitan yarumin ajakuiti. ");
INSERT INTO hubNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Yuus ememattasa iruuntai jeanam jeawar, fariseowa wajaki Yuusan aujeak: ‘Yuusa, wika chikich shuar kasa, shuar tunau, nuwa nuatkamujaisha puju aina annuchu asan, maake tajame. Wika ju shuar apunu atinan kuitan yarumin waja juninchauwaitjai. ");
INSERT INTO hubNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Tumau asan, wika aminka chikichik semanatin jimar tsawan yurumkan yutsuk pujusan, ima aminak ememattsan aujnaitjame. Tumakun wina akirainakaigka dieznumian akankan, ju Yuusnau atii tusan tuke ikusnake awajai’, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Turasha apunu atinan kuitan yarumnuka ika wajas, tsuntsumaa nayaimpinka pagkaisha iitsuk kuntuts enentaimas, netsepen uwejejai ijuak: Yuusa, wika tunauwaitjai, tuma asamtai winasha wait anentrurta”, tusa Yuusan tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Nu shuar apunu atinan kuitan yarumin tu aujeam, Yuuscha anturak tunaurincha tsagkuurauwaiti. Turam nigka shir aneas nina jeen waketkinaiti, turasha fariseoka tumachuiti. Shuar eme anenmamunka Yuuska eme anentsashtinaiti, antsu eme anenmamchauwa nuna Yuuska eme anentsatnaiti, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Nuna tusa ashimkamtai, shuar uchirtin aina uchirin yaruakar, winasha ni antintrukti tusar Jesúsan ikataina. Turuinakai Jesúsan unuinatairi aina chichainak: ¿Urukamtai Jesúscha waitkarme? tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Tuinakai Jesús nitan untsuk chicharuk: “Tutsuk inaisatarma, atum tusarum nuig uchi awakerairpa. Uun ainasha ju uchi wina nekaspapita turutaina jumamtuk, nekaspapita turutainakaigka nitaincha Yuuska inamrattsa wakerawai. ");
INSERT INTO hubNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Nekas tajarme, shuar Yuusa inamtairiya nui wayaattsa wakeruinaka uchi aina iturchat enentaimtsuk wina enentaimturaina imanisag enentaimturmain ainawai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Apu aina iruuntramunmaya chikichik apu Jesúsan iniak: “Jintinkartin Pegkera, ¿wisha pujut nagkanchaun jukimij tusancha urukmainaitja?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Tusa tama Jesús ayak: “¿Urukamtai winasha Pegkera turutme? Ima Yuusketi Pegkerka chikich Pegkerka atsawai. ");
INSERT INTO hubNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ameka chicham umiktin aarmauwa nuka nekame. Tuma asam amina nuwemchauka takasaipa, magkartuawairpa, kasamkairpa, aantram chikich shuarkesha chicham tsanumruraipa, ame apasha nukujai umirkata”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Jesús tusa tama apu chichaak: “Wika ame chicham umiktin tame nunaka uchiich asanak ashi umikuitjai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Takai Jesús ayak: “Chikichik umimain arutramui. Ame jeemin wetá. Tumam amina waríram arutrama nuka ashi surakum, kuitrinchau aina antramek tinamkam inaisata. Ame turamka pegker aina nu nayaimpinam jukitnaitme. Tumatin asam yamaika wina nemartukta”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Tusa tama nuna antuk, nu apuka shir wiakach asa wake mesek wajasuiti. ");
INSERT INTO hubNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Tumamtai Jesús wainak chichaak: “Shuar wiakach aina Yuusa inamtairin wayaataj tamauka shir iturchataiti. ");
INSERT INTO hubNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Auja waarin camelloka waya nagkamamainaiti. Turasha shuar wiakach Yuusa inamtairin wayaataj tamauka shir iturchataiti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Jesús tusa takai shuar nui irunusha nuna antukar chichainak: Ima iiturchata imau aisha, ¿yáki uwemratnaita? tusar tuina. ");
INSERT INTO hubNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Tusar tuinakai Jesús chichaak: “Shuar turumainchau aina nunaka Yuus ashi turumainaiti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Tusa takai Pedro chichaak: “Apuru, ii ainatika ina waríri ashi ikuakur ame nemarkamji”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Tusa Pedro tama Jesús chicharuk: “Nekas tajarme, shuar wina nemartak, nina jeen, nuwen, yachi ainan, umai ainan, aparin nukurijai tura uchiri ainan, Yuus tu inamui tusa etserkattsa weak utsag ikuaka, ");
INSERT INTO hubNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ju nugka jui pujuscha ni ikukmaurin nagkasau jukitnaiti. Tuma asa jainaksha Yuusjai tuke pujusartin ainawai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesús nina unuinatairi doce ainan untsuk akanak chicharuk: “Yaunchuk Yuusa chichamen etserin aina shuarnum akinan pachisar aararu aina nu uminkati tusar yamaika Jerusalénnum weaji. ");
INSERT INTO hubNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ai wii jeakaigka achirkar jurukiar judíochu ainanam surutkartatui. Turutawarmatai wishikruinak, imanchau chichartuinak usukriartatui. ");
INSERT INTO hubNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Tura numijaisha awattiartatui, tura waitkaras mantuawartatui. Turasha tres tsawan tepesan, ataksha nantaktatjai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Jesús tusa etserkaisha, nina unuinatairi ainaka shir enentaimtura nekachminun tau asamtai, nuna takumpapi tawa tusarka nekacharuiti. ");
INSERT INTO hubNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jesús yaakat Jericónam jeattak weai, shuar wainmachu jinta yantamen ekeemas, shuar nagkamainakai, winasha antrarmek kuit surustarma tusa seama eketu. ");
INSERT INTO hubNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Tura nukap shuar ni eketmaunam nagkamainak pampainamun antukuiti. Tuma nuna antuk, ¿urukakua nunasha imatainawa? tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Tusa inimkai nui shuar irunu ujainak: “Jesús Nazaretnumiaya nu weakai, nemarsar shimuinak imatainawai”, tusar tuina. ");
INSERT INTO hubNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Tusa ujam nuna antuk senchi untsumuk: “¡Jesúsa, David weantu uchiriya, winasha wait anentrurta!” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Tusa imatkai, imattsuk asakia tusar tuina. Tusa tamasha nu senchi Jesúsan untsuak: “¡Jesúsa, David weantu uchiriya, winasha wait anentrurta!” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Imatkai Jesús antuk wajan chichaak: “Jukirum jui itantarma tusa shuaran akuptukuiti. Tusa akupkam shuar wainmachun juki itantarmatai Jesús iniak: ");
INSERT INTO hubNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","‘¿Winasha warinma wait anentrurti tusamea wakerutame?’ Tusa iniam wainmachu ayak: ‘Apuru, wika pan iimtikrita tusan wakerajai’ ”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Nuna takai Jesús chicharuk: “Ameka wina nekaspapita turutu asam, pan iimta”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Tusa tamauwaik wainmachusha pan iimnaiti. Tuma Yuusan emematki Jesús weakai wuwaiti. Tura shuar pan iimtikmaun wainkaruka Yuusnaka ashi ememataina. ");
INSERT INTO hubNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Tura Jesús yaakat Jericónam jeawaiti, tuma nuke nagkamau. ");
INSERT INTO hubNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Nu yaaktanam shuar wiakach, Romanmaya apunu atinan kuitan yarumin ainan apuri Zaqueo naartin pujau. ");
INSERT INTO hubNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Nu shuar Jesúsan wainkattsa wakera. Turaksha nukap shuar tuarkar wena asarmatai, sutarach asa wainmainchau nekapea. ");
INSERT INTO hubNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Jesúsan wainkattsa ni wetinnumani niyaa emak tsekegki númi wajamunam yaki wakauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Zaqueo nui waka eketai, Jesúscha nuke ayaamas nagkak pagkai iis chicharuk: “Zaqueowa, wári akaikita, yamaika amina jeemin kanartasan winajai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Tusa tama Zaqueo wári akaikinaiti, tuma Jesúsan shir anentas nina jeen juki umauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Nu turamun wainkar Jesúska shuar tunaun jeen weyi tusar nukap shuar aina, aujmattan nagkamawaru. ");
INSERT INTO hubNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zaqueo Jesúsjai chichas umik wajaki chichaak: “Apuru, yamai nagkamsanka shuar kuitrinchau aina auna wina warírun jimapetuk tinamkatjai, turakun wii shuar chikichik kuit kasarkamur ainanka cuatro kuitan susartajai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Tusa takai Jesús chicharuk: “Yamaika ju jea juiyagka ameka uwemraume. Tuma asam yamaika amesha nekas Abraham weantu jasume. ");
INSERT INTO hubNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Wii shuarnum akinawaitaj nunaka shuar Yuusan tupantraru aina nuna uwemtikattsan taawaitjai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Jesús Jerusalénnum jeattak weakai, shuar nina nemaras shimuinaka ni chichaamurin anturaina asar, Yuus inatmamuka ai jearintsuk nagkamnatti tu enentaimainakai, Jesús chikichnasha pachis jintinkartak: ");
INSERT INTO hubNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","“Chikichik shuar eme anentsa iitai ajakuiti. Iman asa apu anaikam taattsa nina nugken ikuak, chikich nugkanam jeashat wuwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Eke wetsuk, diez shuaran nina inatairi ainan untsukuiti. Tura ikaanak chiki chikichik shuaran nukap kuitan susauwaiti. Tura chicharuk: ‘Ju kuita jujai warí sumakrum surakrum ikaugkatarma, tumarmin wisha waketkin taatjai’, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Tusa shir akatar ikuak chikich nugkanam wuwaiti. Tumamtai shuar nina kajeraina asar, chichaman apun akuptuinak: ‘Ika ame ina apuri atá tusarka wakeratsji’, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Tusa timau ayat apu anaikam ataksha nina nugkeen waketki jeawaiti. Tuma ni kuit susa ikukmauri ainan urutmak ikaugkara tusa nekaattsa untsukuiti. ");
INSERT INTO hubNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Turam chikichik shuar niyaa emak apun jeari chicharuk: ‘Apuru, ame diez kuit surusam ikurkimiam nunaka, warí ainan sumakan surakun cien kuitan ikauntukjame’, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Tusa ujam apusha chichaak: ‘Shir pegkeraiti, ameka inatai pegker asam, ishichik ikurkimsha shir kuitamam nu nukap ikaugkau asaakmin, yamaika aminka diez yaaktanmaya shuar ainan apuri atá tusan anaikatjame’, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Tusa takai chikich shuarsha jeari chichaak: ‘Apuru, ame kuit surusam ikurkimiam nunaka, warí ainan sumakan surakun cincuenta kuitan ikauntukjame’, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Tusa ujam apusha chichaak: ‘Ayu, amesha yamaika cincuenta yaaktanmaya shuar ainan apuri atá tusan anaikatjame’, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Nuna tusa takai chikich shuarsha jeari chichaak: ‘Apu, wika amina ashamakun kuitrumnaka takarsachmajme, ayatik jaanchjai shir ijian ikursamjame, jui awai, yamaika jukita. ");
INSERT INTO hubNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Takarmain ayatan ameka senchi inakratin asaakmin, árak aratarma time ame araachiatam juukam yarumin asaakmin, amina ashamakun ayatik ikursamjame’, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Tusa tama apusha chicharuk: Ameka inatai pegkerchauwaitme. Wisha ame wina chichartam tumasnak amijaigka atatjai. Shuar ainan inakun waitkau aisha tura wii arachiatan arakan juukan yarumin waitiatmesha, ");
INSERT INTO hubNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","jeen waketki taak kawegkun jukiti tusam ¿kuit egketainam egkeam ikurtuschamam? tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Tusa inaiyak chikich shuar nui iruuntatmaun untsuk chicharuk: ‘Chikichik kuitan takaka ju jurukrum, shuar kuitan cien takaka nu susatarma’, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Takai nita chichainak: ‘Apuru ¿cien kuitan takakusha urukamtai sumainaita?’ tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Tusa tuinakai apu chichaak: ‘Shuar pegker takasuka nu nukap suam atinaiti. Antsu shir takaschauka ashi atanteam atinaiti’, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Nuna tusa ashimak ataksha chikich shuar nui irunun chicharuk: Yamaika shuar wina kajertuina asar, apu jasai tusar nakitruru aina nu yaruakrum jui itaarum, wisha wainaig ijinatarma”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Nuna tusa inaiyak Jesús Jerusalénnum wuwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Tuma wea weakua jimar yaakat Betfagé tutai Betaniajai nain Olivosnum tiiju amaunam jeantatak wesa, nina unuinatairin jimaran akupeak: ");
INSERT INTO hubNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Au yaakat a ai wetaarma. Tumarum jeaakmarum burro entsamkachmau jigkaam wajau wainkattarme. Turarum atia jukirum itartitarma. ");
INSERT INTO hubNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Atiarum juarmin, chikichik shuarkesha waitmak chichartamuk: Urukamtai juarum tusa takaisha: Ina apuri atsuma asamtai juaji, tusarum titarma, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Tusa takai Jesúsa unuinatairi ainasha ayu tusa wearuiti. Tuma jeawar Jesús timaunka imatiksag wainkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Tura jeariar atinak irunai, burrortin aina wainkaruiti. Turawar chichainak: “¿Burrosha urukamtai atiarme?” tusar tuina. ");
INSERT INTO hubNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Tuinakai nita aimainak: “Ina apuri atsumakai atiar juaji”, tusar tuina. ");
INSERT INTO hubNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Burron atia jukiar, Jesús wajamunam ejéniar nugkutairin aitkar, Jesúsan ekeniar jukiaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Tuma weakai Jesúsan eme anentas iiyainak, shuar aina jintanam jaanchrin aitar umaina. ");
INSERT INTO hubNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Tura Olivosan naintri awagkenmaunam wesar, Jesúsan nemarin aina Jesús iwainamun ashi wainkaru asar, shir anenak tura Yuusan emematainak senchi pampaina. ");
INSERT INTO hubNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Tumaina asar chichainak: “¡Shuarti apuri atinan Yuus akupturmakmau wina ju ashi shuarti ememattai atii! ¡Nayaimpinmaya ainasha agkan shir aneasar matsamsarti! ¡Ashi shuar aina Yuus senchirtina nuna nekamain ainawai!” tusar tuina. ");
INSERT INTO hubNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Nuna tusar imatainakai, fariseo shuarsha ujumak nui pachittrau asar chichainak: “Jintinkartina, amina nemartamin aina imataina au itatmamtikata”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Tuinakai Jesús ayak: “Nekas tajarme, wii nitan itatmamtikainakaigka kaya aina ju chichainak senchi pampainiartatui”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jesús Jerusalénnum tiiju wesa nuna wainak, shuar nui matsamin ainan enentaimtus útuk ");
INSERT INTO hubNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","chichaak: “Jerusalénnumia shuar aina, ju tsawanta juik juwapita ina uwemtikramainka tusar nekarainakka, agkan shir enentaimsar pujumain ainawai. Turasha yamaika wainmachua numamtuk asar, nunaka nekamain ainatsui. ");
INSERT INTO hubNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Atumnasha tsawan shir ashammain arutramtinaitrume. Tura atumi shuari aina kaunkar, yaaktarminka ashi tentenmakar atumjai maaniktasar winitramiartinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Atumka Yuusapi ina uwemtikramratnun akupturmakjia tusarum nekachu asaakrumin, yaaktarmin utsaanturmawar atumnaka ashi mantamainak, jeancha yumpuarartinaiti, imatikamu asa chikichik kayaksha chikich kayanam ekenmauka tumasag juakuksha achatnaiti”. ");
INSERT INTO hubNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jesús nuna tusa inaiyak, Yuus ememattasa iruuntai jeanam waikma, shuar tagkun surin ainan wainkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Tura nitan chicharuk: “Yuusa chichamen tu aarmauwaiti: ‘Wina jearka shuar aina wijai chichasartasa iruuntaiyaiti’, tusa timau aig, atumka Yuus eme anentsa iiyaku epeatin chikich aina tsanuarum tagku suakrum kuit atumnau atin jua asarum, shuar kasa matsamtaiya numamtuk amajsaurme”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Tusa Yuus ememattasa iruuntai jeanam wayaa pujus, kashi kashinig shuar ainanka Yuusa chichamen pachis jintintu. Jesús tumakai sacerdote apuri aina, chicham umiktinan jintinkartin aina, apu ainajai iruuntrar itursarik Jesús maawaj tusar chicham tsanumrura achimainan eataina. ");
INSERT INTO hubNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Imatikainaksha Jesús chichaman etserkai, ashi shuar shir aneasar anturaina asarmatai, maamain nekapenachu. ");
INSERT INTO hubNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Jesús Yuus ememattasa iruuntai jeanam wayaa chicham uwemtikartinan shuar ainan jintintuk pujurai, sacerdote apuri aina, chicham umiktinan jintinkartin ainasha judío apuri ainajai utsanawaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Tumawar Jesúsan ininak: “¿Ya amincha jintinkartuata tusa akuptamkauwaita? ¿Yana chichamenia jusha aitkame?” tusar tuina. ");
INSERT INTO hubNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Tuinakai ni chichaak: “Wisha chikichkinak iniastajrume tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Juannasha imakratta tusasha ya akupkauwaita? ¿Yuusak akupkauwait, turachkusha shuar ainak akupkauwait? Winasha nu ujatkatarma”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Takai utujimkar nitak chichainak: “¿Wari titajik? Juannaka Yuus akupkauwaiti tusa takurincha, ‘turasha ¿urukamtai umirkachuitrume?’ tusa turamtatji. ");
INSERT INTO hubNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Tura shuar akupkauwaiti tusa takurincha, Juanka Yuusnumian chicharkartu jakuiti tuina asar, nita kayajai tukurmar mantammain ainaji”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Nuna tusar utujimkar, Jesúsan jeariar chichainak: “Yatsuk Juannasha akupkauwait nekatsji”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Nuna tuinakai ni ayak: “Antsu wisha yana chichamenia aitkaja nunaka ujakchattajrume”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Nuna tusa inaiyak, Jesús ataksha shuar ainan chicharuk: “Ju jintinkartamusha antuktarma. Chikichik shuar ajariin uvan arawaiti. Tura asa nuna kuitamkatin ainan ujumak shuaran eakuiti, tura atum ju kuitamrutkatarma tusa ikuak, nigka chikich nugkanam wuwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Tuma pujus, uva juut jeaamtai nina inatairin chicharuk: Ame weme jeaam uva winau amaina nu ajan kuitamin aina seam utita tusa akupkauwaiti. Turam wuwaiti, tuma jeattamaun ajan kuitamainak matsatu achikar awa awatainakua pegke sutsuk awaigkiaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Turawarmatai chikichnasha nina inatairin ataksha akupkauwaiti. Turamtai nunasha jiya jiyainakua awatar pegke sutsuk awaigkiaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Nuna turawarmatai nina inatairin chikichan ataksha akupkauwaiti. Turamtaisha ajan kuitamin ainaka awa awatainakua jiiki akupkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Nuna turawarmatai ajartin chichaak: ‘¿Yamaisha iturkatjak? Antsu yamaika uchirun wina anetairun akupkatjai, turamtai ninka araantus iischaraintash, tu enentaimas akupkauwaiti’. ");
INSERT INTO hubNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Tusa akupkam wetatmaun aja kuitamin aina wainkar chichainak: ‘Auwaiti ju aja juna jukitnuka, nekas maa ajapar, ju nugka juka inu amajsami’, tusar tuina. ");
INSERT INTO hubNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Tusar apu uchiri winittamaun achik jukiar, ajan ikumtikiar maawaru ainawai”. Nuna tusa Jesús shuar irunun iniak: “¿Atumsha uruk enentaimrumea, ajartin winaksha ajan kuitamin tuma matsatuncha iturmainaita? ");
INSERT INTO hubNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ajartin winitkugka nunaka kajeg utsak nu ajanka chikich ainan susa inaimainaiti”, tusa tinaiti. Jesús tusa tamaun antukar, chichainak: “Nunaka pegke turumaitsui”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Tuinakai Jesús chichaak: “Jea jeamin aina chikichik kayan nakitrar pegkerchauwaiti tusar ajapamua nu, kaya nekas ima wakerumain jasai”, tusa Yuusa chichamen tu aarmauwa nusha ¿warina pachis takua tawa? tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Shuar nuna kaya ukurin iyakka kupinmainaiti, antsu nu kaya shuarnum iyakka shuaran nachakamainaiti tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Sacerdote apuri aina chicham umiktinan jintinkartin ainajai Jesús tu jintinkartamun antukar, ina pachitmas turamuk tu wekawai, tusar Jesúsan achikartasa wakeruina. Turasha ni jintinkartamun nukap shuar shir aneas anturainak tuaraina asarmatai, nitan ashamaina. ");
INSERT INTO hubNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Tura shuar anagkartin ainan chicharainak: Atum werum Jesús chikichik inimmau pachisrum iniastarma. Turamsha warituk aimkat timatai, chicham tsanumrura achika apunam surukmi tusar akupkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Turawaram Jesúsan jeariar chicharainak: “Jintinkartina, ameka nekasa nuke jintinkartame. Tuma asam ashi shuar aina metek enentaimtam nuka nekainaji. ");
INSERT INTO hubNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Nui amina iniajme: ¿Romanmaya apu shuara kuitrin yarurna ausha akimainashit, amesha uruk enentaimmea, atsaa akimainchaukait?” tusar inina. ");
INSERT INTO hubNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Tuinakai Jesúska anagkeaku tamaunka nekau asa chichaak: ");
INSERT INTO hubNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Kuitcha urukua apusha suarme nu inaktursatarma, tusa tinaiti. Takai kuit denario tutai susam wainak chichaak: “¿Jusha yana yapiya nakumkamuita, tura jusha yana naarimpa aarmauwaita?” tusa tinaiti. Takai nita chichainak: “Juka Romanmaya apu Césara nunauwaiti”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Tuinakai Jesús chichaak: Romanmaya apunua nuka ni wakeramua turusrumek takastarma, tura Yuusnauwa nusha ni wakeramua turusrumek takastarma, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Nuna tusa takai shuar Jesúsan tsanurar chichaman nekarawar achikartasa yujarusha enentai jearchar chichatsuk inaisaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Nuna tuma waketrarmatai, saduceo shuar ainasha Jesúsan weriaruiti. Nitaka shuar jakaru aina nuka nantarchartin ainawai tusar tinu asar, Jesúsan ininak: ");
INSERT INTO hubNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Jintinkartina, Moisés papiin aar ikurtamuk: ‘Shuar nina yachi nuwena uchin akiitsuk jakamtaigka, ni wajen juki, uchin akinmainaiti, tura nina yachi uchiriya nunin amajmainaiti’, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Shuar siete yachigmau ajakuiti. Tuma yama nagkamchak iwairi nuweena, tuma uchin akiitsuk jakauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Tumamtai yachi nuwen wajen jukinaiti, tuma nusha uchinka akiitsuk jakauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Tumamtai chichitcha juki uchinka akiitsuk jakauwaiti. Tuma tumainakua, sieteya nuka uchinka akiitsuk ashi jinaawaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Tumamtai nui pujus nuwasha jakauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Nu chikichik nuwanak nua nuatainakua jinaawarua nusha, ¿atak nantainamunmasha yáki jukitnaita?” tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Tusa tuinakai Jesús ayak: “Ju nugka jui matsamsar aishmag aina tura nuwa ainasha nuwenin ainawai. ");
INSERT INTO hubNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Turasha shuar pegker jinaawaru aina nantarar nayaimpinam weartin aina nuka nuweenachartin ainawai. ");
INSERT INTO hubNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Nuigka jakashtin ainawai. Antsu jakau nantainakka nayaimpinmaya shuar aina numamtin artinaiti, nitaka jakauwaitak nantakiaru asar, Yuusa uchiri artinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Yuus númi zarza tutai keamunam pachinak wajas Moisésan wantiintuk chicharuk: ‘Wiyaitjai Abraham, Isaac, Jacob aina nuna Yuusrinka’, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","¡Yuuska jakau ainan Yuusrinchuiti, antsu iwáku ainan Yuusriyaiti. Yuus iismaka jakau ainasha ashi iwáku matsatainawai!” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Nuna tusa takai nui fariseo irunu chichainak: “Jintinkartina, yajau tatsume”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Jesús nuna timatai araantukar awenawarka iniascharuiti. ");
INSERT INTO hubNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jesús shuar ainan iniak: “¿Urukamtai Cristoka David weantuiti tusarsha tuinawa? ");
INSERT INTO hubNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Davidcha kantamtain Salmosnum aak: ‘Wina apurun, apu Yuus chicharuk: Wina untsuruini ekeemsata, ");
INSERT INTO hubNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","tumawakmin wii amina shuarum ainanka nepetkattajai’, tusa titinaiti tu aaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","¿David wina Apur tujaku aisha, Cristosha uruku asaya David weantusha amainaita? ");
INSERT INTO hubNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Jesús ashi shuar antu iruunmaunam nina unuinatairi ainan chicharuk: ");
INSERT INTO hubNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Chicham umiktinan jintinkartin aina jaanch asarman nugkurar yujatan wakerin aina tumau airum atumka aneartarma. Nitaka yujainaksha shuar ainasha emematrus shir amikmatawarti tusar wakerin ainawai. Tura iruuntai jeanam utsaanainaksha, apu ekeemtai pegker ainan etegkawar ekeemsattsa wakerin ainawai. Tura yurumak yuamunmasha ekeemtai pegker ainan etegkawar ekeemas yuattsa wakerin ainawai. ");
INSERT INTO hubNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Tura nuwa waje ainan tsanuawar jeen atankiar, pegkerna takáwa turutiarti, tusar ajapeen wajantar Yuusan au aujainakua iku yujau ainawai. Nuna tuma yujau ainanka chikich ainan nagkasaun, Yuus waittan susatnaiti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yuus ememattasa iruuntai jeanam Jesús wayaa Yuusnau atii tusa shuar wiakach aina kuitan egkenakai iiyak pujau. ");
INSERT INTO hubNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Tuma pujai nuwa waje kuitrinchau jimarchik jiru kuit cobre najanamun imanis akikchaun egkean wainkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Tura Jesús nina unuinatairi ainan chicharuk: “Nekas tajarme, ju nuwa waje kuitrinchauwaitiat, chikich egkena auna nagkasau egkeayi. ");
INSERT INTO hubNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Chikich ainaka kuit ampintrau ainan egkenawai, turasha ju nuwa waje kuitrinchauwaitiat, ni sumasa yumaintrinkisha ampir ikutsuk ashi egkeayi. Tura asa chikich ainan nagkasau pegkeran takasai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Jesúska nuna tusa chichaa wajai, chikich shuar aina Yuus ememattasa iruuntai jea shir iwara jeamkamu asamtai, kaya ainancha pegker ainanak etegkrampapi jeamkaruita, tura warí Yuusnau atii tusa ikaankamu ainajaimpa pegker iwaramuita, tusar nuna pachisar chichaina. Tuinakai Jesús nitan chicharuk: ");
INSERT INTO hubNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Atum ju jea imaj iwaramu waintrum junaka, tsawan uminkamtai shuar aina utsantuawar ashi yumpuarartin ainawai. Imatikamu asa au kaya aina auka chikichik kayaksha chikich kayanam patatuka achatnaiti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Nuna tusa takai nina unuinatairi aina chichainak: “Jintinkartina, ¿nusha urutiak tumatnaita? ¿Nu tumatin tsawan uminkaisha warig wantinkatnaita?” tusar iniasaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Tuinakai Jesús nitan chicharuk: “Chikich aina tsanurmarairum, pe aneartin ataarma. Tsawan uminkaigka wina naarun anaisar chichainak: ‘Wiyaitjai Cristonka’, yamaika tsawanka uminkayi tusa tuinasha artinaiti, nuna tusa tuinakaisha nuka anturkatin airpa. ");
INSERT INTO hubNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Maaniawartasa pampannaiyamu, tura maaninamu antakrumsha ashamkatin airpa. Yama nagkamchak nagkamartinka nu ainawai, turasha nugka mesera nagkanmauka nuchauwaiti”. ");
INSERT INTO hubNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Nugka uunnum matsamin ainasha mai imannumian nagkamnaiyawar maaniartinaiti, nu iman tumainai nugka shikapchinmaya apusha mai tumaunumiag nagkamnaiyawar maaniartinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ashi nugkanam senchi urtinaiti, tura tsukasha tepeatnaiti. Tura jatasha imanisag ashi nugkanam atinaiti. Tura nayaimpinmayasha ashammain aina wantiiniartinaiti tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Nu imaniatsaigsha atumnaka wini surumankau asaakrumin, achirmakar waitkarmasartasa aintamiartinaiti. Imatikramaina asar achirmak juramkiarsha chicham nekarami tusar judío iruuntai jeanmasha ejétamiartinaiti. Nui ejétamiar cárcelnum egketmawartinaitrume. Tura egketmawarsha judío apuri matsatmaunam tura Romanmaya apu ainanmasha awaintamawartinaitrume. ");
INSERT INTO hubNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Wina pachittsarum chikich aina ujamainka tu arutramtinaitrume. ");
INSERT INTO hubNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Tura atumin apunam juramainakaisha apuncha warituk aujsan ayamrumaktaj tusarmeka enentaimsatin airpa. ");
INSERT INTO hubNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Wii atumnaka nekamtikatnaitjarme. Turamu asaakrumin atumin kajertamainasha: Nuka tu amaitsu jama tusarka turamchartin ainawai. ");
INSERT INTO hubNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Atumi apari aina, atumi yachi aina, atumi patai aina tura atumi amikri aina nuke anagka achiam atinaitrume. Turutmaina asarmatai atum ainarum nuiyatirmesha maam atinaitrume. ");
INSERT INTO hubNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Atum wina nemartin asaakrumin, ashi shuar aina kajertamiartinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Turasha wii atumnaka pegkesha inaisashtinaitjarme. ");
INSERT INTO hubNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Imatikramainakaisha uwemramij takurmeka, atum wini nekaspapita tamauka inaisairpa”. ");
INSERT INTO hubNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Atumka yaakat Jerusalénkan suntar tenteawaru wainkurmeka, wáriapi yaaktan yumpugkartatua tusarum nekatin ataarma. ");
INSERT INTO hubNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Nuna tumainakaigka Judeanam matsatainaka yaaktan ikuinak, nainnum wári shimumain ainawai. Tura Jerusalénnum matsatusha nuigka matsamtsuk yaaktanka ikuinak wári shimumain ainawai. Tura shuar ajanam takainak yujasha Jerusalénnum wakettsuk tsekemain ainawai. ");
INSERT INTO hubNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Nu imanika waitamu atina nuka Yuusa chichamen aarmauwa nu uminuk tumatnaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Nu tsawan atina nui nuwa ajapruktin aina nunaka, nuwa uchin yama jureru ainajai Yuus ashi shuar nui matsatunka waittan sua asamtai, nitasha waittsatin asarmatai, wait anentainajai! ");
INSERT INTO hubNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Tura shuar ni maamusha artinaiti, tura shuar ni achira ashi nugkanam yarumam ausha artinaiti. Tura shuar judíochu ainaka yaakat Jerusalénnaka shir yumpuararmatai, nita apuri anik atii tima nui inaisartinaiti”. ");
INSERT INTO hubNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Nuna tumai etsanmaya, nantunmaya tura yaanmaya ainasha, yaunchuksha wainkachmau wantiiniartinaiti. Nayantsasha senchi tsukattinaiti, imatmak senchi uuttinaiti. Nu imatmamun antuinak, ashi nugkanmaya ainaka ashamainak urukawajig tusar tiartinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Nu imanian shuar ainaka wainainak: Nugka yamaika meseawapi, tusar senchi ashamainak tuke jachiat weetak jaka iyaake artinaiti. Nu tsawantinka etsa, nantu tura ya ainasha ashi muchitrartinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Nu imani amaunam wii shuarnum akinawaitaj nuna shir tsaaptin jasan nayaimpinmaya yuragminam pachitkau winamun, ashi waitkartin ainawai. ");
INSERT INTO hubNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Nu tsawan uminuk imaniakaigka, atum waitkam matsatutirmeka wári agkanmarum ayamsatin asarum, shir aneastin ataarma”. ");
INSERT INTO hubNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Jesús númi higuera tutain pachis jintinkartak: “Númi higuera, tumachkurmesha chikich númi asat nekatai aina nu enentaimtusrum iistarma. ");
INSERT INTO hubNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Númi higuera nukarkamtai, atumka wári asat tepeattawai tusarum nekau ainarme. ");
INSERT INTO hubNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Numamtuk wii taja nu imanisag uminkaigka, yamaika shuar ainan Yuus inartinka tsawan ashi jeawapi titin ataarma. ");
INSERT INTO hubNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Nekas tajarme, atak shuar matsamiartin aina nusha eke ashi jinuinatsaig juka uminkatnaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Nayaimpia auka nugkajai megkakatnaiti. Turasha wii tajarum nuka metek uminkatnaiti”. ");
INSERT INTO hubNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Pe anearum pujustarma. Tumakrum tunau aina, nampet ainasha, tura ju nugkanmaya pujuta nusha enentaimtu pujuirpa. Pachiachmau wii winakai waurkairum, shir pujustarma. ");
INSERT INTO hubNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Yarag nenarmaunam kuntin nekachu asa, achimak ashamna numamtuk shuar wina pachittsuk pujuinaka tsawan pachiachmau wii winakai ashamrukartin ainawai. ");
INSERT INTO hubNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Atumka wii taja nu jeakai waittsairum, shir umintsarum pujusrum, ashi tsawantin Yuus auju pujutarma. Shuarnum wii akinawaitaj nuna winakai igkunkamnuram”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Jesúska tsawai Yuus ememattasa iruuntai jeanam Yuusa chichamenka jintinkartu pujayat, nain Olivos tutai a nui káshi pujustasa we jakuiti. ");
INSERT INTO hubNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Tuma asamtai shuar ainaka káshikmasar nina chichamen antukartasa Yuus ememattasa iruuntai jeanmagka iruna jakaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Jiisat Pascua pan levadurajai pachimtsuk inaraamu yutai nuu jiisat jeattak jai, ");
INSERT INTO hubNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","sacerdote apuri aina, chicham umiktinan jintinkartin ainajai iruuntraruiti. Tumawar Jesús uruk maawajig tusar chichamruina. Tumainaksha nukap shuar nina nemaraina asarmatai, ashamainak utujimena. ");
INSERT INTO hubNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","4","Tura utujimtuk irunai, shuar Judas Iscariote naartin, Jesúsan unuinatairiyaitiat, iwanch egkemtuam, nita irunmaunam wayaa sacerdote apuri aina Yuus ememattasa iruuntai jean kuitamnun apuri ainajai tuak irunun chicharuk: Wii anagkamtai, atum achiktarma tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","6","Tusa takai shir anenak: Akiktajme tusar tiaruiti. Turam nitajai chichaman shir umik ikuknaiti. Tura Judas wesa, uruk shuar atsamunam ninak surukajag tusa enentaimtau. ");
INSERT INTO hubNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Judío ainan jiistari Pascua tutai, pan levadurajai pachimtsuk inarkamu yutai, Yuuscha tunau tsagkurtamratji tusa oveja maar aeseaku jiistamtai jeawaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Tuma asamtai Jesús nina unuinatairi ainan, Pedron Juanjai chicharuk: “Werum jiisat Pascuatin yuatin umiktarma”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Takai nita chichainak: “¿Apuru, nunasha tui umikarti tusamea wakeramea?” tusar inina. ");
INSERT INTO hubNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Tuinakai Jesús nitan ayak: “Yaaktanam wetaarma, yaakat amaunam shuar ichignanam entsan shikik waketu wainkattarme. Turarum nu nemarkirum, ");
INSERT INTO hubNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ni jea wayakai, nui wayaarum jeentin chicharkurum: Jintinkartin chichaak: ¿Wina unuinatair ainajai jiisat Pascuatin iruuntra yumaintrusha tuwait? tusa turamui titarma. ");
INSERT INTO hubNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Tusa tama jeentin jea yaki tesamu uuntan shir umikmaun, isha ashi metek utsanmainan inakturmastattrume, turutmamtai nui umiktarma”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Jesús takai nitasha ayu tusar wear, yaaktanam jeaakma ni timaunka ashi imatiksag wainkar, Pascuatin yuatnunka umikaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Káshi jasmatai Jesús yuattsa nina unuinatairi ainajaimak mesanam ekeemsauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Tuma Jesús nitan chicharuk: “Wika mantuinatsaig ju jiistatin atumjai iruuntran yuattsan senchi wakerimjai. ");
INSERT INTO hubNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Junasha tajarme: Yamaika ju jiistatinka inagnamun atumjai iruuntran yuajai. Turasha atak nayaimpinam wina Aparun inamtairin atumjai iruuntran yuatnaitjai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Nuna tusa inaiyak umutain shikikam mesanam eketun juki Yuusan maaketi tina chichaak: “Ju jukirum tinamnaikarum umartarma. ");
INSERT INTO hubNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Tura junasha tajarme: Wika ju uva neren yumirinka atak awenanka umarchatnaitjai. Antsu tsawan uminkamtai, wina Aparun inamtairin nayaimpinam atumjai iruuntrar umartinaitji”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Tusa inaiyak pannasha juki, Yuusan maaketi tina, puur nitan tinamak chichaak: “Ju yuatarma, juka wina iyashrua numamtinaiti. Jutika yuakrumka wini tuke enentaimsarmeke atin ataarma”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Nuna ashi yuawarmatai umutain shikikam eketun juki, nunasha turusag Yuusan maaketi tina, juka wina numparua numamtinaiti, Yuus yamaram chichaman ashi atum ainatirmin anajmatramawa nuwaiti. Wina numparjai nukap shuar ainan tunaurin tsagkurattajai tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Nuiyasha ashi nuna ashimak chichaak: “Ii eketainaj juiyag winaka maawarti tusa anagka surutkattawai. ");
INSERT INTO hubNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Wii shuarnum akinawaitaj nunaka wina pachittsar aararua nuna umiktasan werajai. Turasha shuar wina surutkatta nunaka wait anentajai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Jesús takai nina unuinatairi aina nitak chichainak: “¿Yáki nunasha surukti?” tusar tunaiyaina. ");
INSERT INTO hubNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Jesúsan unuinatairi aina chichainak: ¿Yáki ii ainaj juiyasha apusha atinaita? tusar nitak tunaiyaina. ");
INSERT INTO hubNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Tusa nuna chichamruinakai, Jesús chichaak: Ju nugka juiya apu ainaka shuar ainan, nitanu amajak ina matsamin ainawai. Tumainayat ameka pegker yaigkratme, tusa eme anentsa iiyam au ainawai. ");
INSERT INTO hubNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Turasha atum ainatirmeka nuka tumashtin ainarme. Atum apu atasrum wakerakrumka shuar eme anentsa iishtaiya numamtuk anenmamainaitrume. Tura atum eme anentai atasrum wakerakrumka, chikich ainasha yaimainaitrume. ");
INSERT INTO hubNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Atumsha uruk enentaimrumea, shuar mesanam eketa nukait eme anentsa iitai, atsa yurumkan ajama nukait? Eme anentsa iitaigka mesanam eketa nuwaiti. Turasha wika ayatik shuar yurumkan ajamauwa numamtuk ajameajrume. ");
INSERT INTO hubNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Atumka wii senchi waitakaisha winaka inaitutsuk nemartusrum yujau ainarme. ");
INSERT INTO hubNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Tuma asaakrumin wina Apar apu amajtusua turusnak wisha atumin apu amajsatnaitjarme. ");
INSERT INTO hubNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Wijai iruuntrarum wina mesaruin ekeemsarum, yurumak yuakrum umutaisha umartin ainarme. Tura nuiyasha Israela uchiri doce ajakua nuna apuri amajsatnaitjarme”, tusa Jesús tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Jesús nunasha Pedron ujak: “¡Simónka, anearta! Satanás amina nekapramsattsa Yuusan aujsayi. ");
INSERT INTO hubNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Turasha wisha wina inaitutsuk nekaspapita tamaunka inaitutsuk ataksha waketki wina nemartak, wina nemartin ainan enentai ichichturti tusan aujsamjai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Takai Simón Pedro chichaak: “Apuru, amina mantamawartasa achirmak, cárcelnum egketmainakaisha wisha amijai egkemattsan wakerajai, tura amina mantamainakaisha, wisha amijai jakattsan wakerajai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Tusa takai Jesús chicharuk: “Pedro, ju káshia jui atash shinatsaig, wika au shuarnaka wainchauwajai tusam, tresa imajnia waitruattame tajame”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Nuna tusa inaiyak, Jesús ataksha nitan iniak: “¿Chicharkartuktarma tusan ishimkun, wampatcha, kuitkisha, zapatosha jutsuk wetaarma tusan wii ishiakmiajrum nuisha ishichkisha waittsauk ainarum?” tusa tinaiti. Tusa takai nita aimainak: “Atsaa, apuru, waittsachuitji”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Tuinakai Jesús nitan chicharuk: “Turasha yamaika wampatcha, kuitcha jukitarma. Tura kuchii atsurtamkurminka, nugkutairam surukrum sumaktarma. ");
INSERT INTO hubNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Yaunchuk Yuusa chichamen etserin aina wina pachittsar aainak: ‘Magkartin iturtaiyaita numamtuk achiam atinaiti tiaru aina nuka uminkatnaiti’ ”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Tusa takai nita chichainak: “Apuru, jui jimar kuchii arutramji”, tusa tuina. Tuinakai, Jesúscha chichaak: “Ayu maaketi, atumka nu pachisrumka nekachu asaakrumin nuig atii”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Nuna tusa Jesús ashimak, nui pujamun ikuak Olivosan murariin waka, nui pujus tuke Yuusan aujin asa weakai, nina unuinatairi ainasha nemarsar wearuiti. ");
INSERT INTO hubNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Tuma jeaa Jesús nina unuinatairi ainan chicharuk: “Iwanch waitkarmakai tunau takasairum jui pujusrum Yuus auju pujutarma”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Tusa nitanka nui ikuak nigki kanaki ishichik aran kuwak tikishmar Yuusan aujeak: ");
INSERT INTO hubNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Apaachi, turumainaitkumka ju nekapkartamua jui waittsaij tsagkamrukaipa. Turasha wii wakeramuka achati, antsu ame wakeramua nu atii”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Tusa tu aujeak pujai, nayaimpinmaya shuar Jesúsan enentain ichichturtasa tarinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Jesús ni mantamnatnurin enentaimtus senchi waita, imaniak nu senchi Yuusan aujeak pujus numpan searuiti. Imaniku asamtai numpa seejkijai pachimnaik nugkanam kita. ");
INSERT INTO hubNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Yuus aujmaun inagnak wajaki nina unuinatairi pujuinamunam wu. Tura jeaan iikma, wake mesemar nekapenak ene enentaimainakua kanú tepenan wainkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Tura wainak nitan chicharuk: “¿Urukamtai kanúsha teparme? Nantartarma, tumarum Yuus aujsatarma, iwanch waitkarmakai tunau takasairum”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesús nuna tusa chichaak wajai, nukap shuar nina unuinatairi Judas naartinjai kautawaruiti. Tura Judas niya emak Jesúsan jeari kugkuasuiti. ");
INSERT INTO hubNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Turam Jesús chicharuk: “Judasa, ¿shuarnum akinaka kugkuasmeapi suramea?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Shuar Jesúsjai yujasha nu tumamun wainkar chichainak: “Apuru ¿kuchiijai maaniashtatjik?” tusar inina. ");
INSERT INTO hubNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Nuna tusa tuinai, shuar nui wajau kuchiirin juakug sacerdoten apuri inatairin untsur kuishin awati asankauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Turamtai Jesús chichaak: “Aitkatsuk inaisatarma”, tusa tinaiti. Tusa, kuishi asankamun juki ataksha anujtuk pegker amajsauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Nuna tura inaiyak, sacerdote apuri ainan, achikratnun apuri ainan tura judío apuri ainancha chicharuk: “¿Urukamtai atumsha kasa achiktasa iturmainaita imatikruarmesha kuchii aina tura númi aina takakusha winitrarmea? ");
INSERT INTO hubNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Yuus ememattasa iruuntai jeanam kashi kashinig atumjai wii irunnaj nuika, chikichkitirmeksha winaka achirchau ayarme. Tumau ayatrum yamaika tsawan jeau asamtai, iwanch wakeramu umiakrum winaka aitkararme”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Jesúsan achikar jukiar sacerdote apuri jeen umainakai, Pedrosha ukunam patatus ikag wea. ");
INSERT INTO hubNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Jesúsan sacerdote apuri jeen awayaawarmatai Pedrosha jea aarin suntar aina jina ikaparar anamainak matsatmaunam, nitajai iruunar jina anamuk ekeemsauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Tuma ekeemtatmaun nuwa apu jeen takau jeari ii wajakma wainak chicharuk: “Jusha Jesúsjai wekainayi”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Tusa takai Pedro chichaak: “Atsaa, aunka wainchauwajai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Nuna tusa ishichik eketaig shuar chikitcha jeari nusha chicharuk: “Amesha aujai wekainaitme”, tusa tinaiti. Takai Pedro chichaak: “Atsaa, wichauwaitjai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Timatai inaisam chikichik hora eketaig, chikitcha jeari chicharuk: “Amesha Galileanmaya shuaraitme, ameka nekas aujai wekainaitme”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Tusa imatram Pedrosha chichaak: “Wika ame tame nunaka wainchauwaitjai, yatsuk nusha tame”. Tusa chichai atash shinukuiti. ");
INSERT INTO hubNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Tumakai Jesúscha ayanmata iisuiti, turam Pedrosha nuik Jesús achintsuk pujus chichaak: Atash shinatsaig, wina pachittsam au shuarnaka wika wainchauwajai tusam tresa imajnia waitruattame, tusa timaun anearuiti. ");
INSERT INTO hubNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Tuma nuna anear Pedro aa jiinki wake mesemar nekapeak, senchi útnaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","64","Suntar Jesúsan kuitamainak matsamtau Jesúsan wishikainak, jaanchin jukiar jiin epetak awajsar, yapinam awatainak: “¡Ya awattami nekaakia!” tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Tusar senchi waitkainak, nukap pegkerchaun chicharainak senchi wishikaina. ");
INSERT INTO hubNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Tsawaarmatai judío apuri aina, sacerdote apuri aina chicham umiktinan jintinkartin ainajai, tura apu aina ashi iruuntramunam chichaman nekarawartasa Jesúsan ejéniaruiti. Turawar ininak: ");
INSERT INTO hubNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“¿Ame nekas Cristokaitam?” tusar tuinakai, Jesús nitan ayak: “Wiyaitjai takaisha, atumka winaka nekaspapita turutchattarme. ");
INSERT INTO hubNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Tura wii inimkaisha, atumka airmaitsurme. ");
INSERT INTO hubNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Turasha ishichik asan, shuarnum wii akinawaitaj nuna nayaimpinam wakan, apu Yuus senchirtina nujai ekeemsattajai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Nuna timatai ashi tuarak ininak: “¿Yuusa uchirimka amekaitam?” Tuinakai Jesús chichaak: “Atumek nuwaiti tusarum turutrume”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Tusa nuna timatai shuar nui irunuka chichainak: “Ii antarin wiyaitjai nekas Yuusan uchirinka ta jama. ¿Warí ima nakaji?” tusar tuina. ");
INSERT INTO hubNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Tuina asar judío apuri ainaka ashi wajarar apu Pilato pujamunam Jesúsan jukiar umaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Tura ejéniar Jesúsan tsanumruinak: “Ju shuara juka ina apuri ainanka umirtan nakitnayi, tura apu César Romanam puja auka akimaitsurme tinayi. Tura nuiyasha wiyaitjai Cristonka, judío ainan apurinka, tusa tumama wekainayi”, tusar tuina. ");
INSERT INTO hubNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Tuinakai apu Pilato iniak: “¿Nekas amekaitam judío ainan apurim?” tusa tinaiti. Takai Jesús ayak: “Ame turutam nuka nekasaiti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Tusa timatai apu Pilato sacerdote apuri ainan, tura chikich shuar aina irunun chicharuk: Wika ju shuar waitkamainnaka tunaunka waittsujai, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Takai nu senchi chichaman tsanumruinak: “Turasha ju shuar ashi shuar ainan jintintuk, apu ainaka umirkairpa tu wekainayi. Tura Galileanam nagkama, Judeanmaya ainancha tura ii ainatincha turusag tsanurmaji”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Nuna tuinakai apu Pilato antuk: “¿Nekas ju shuar Galileanmayagkait?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Takai nita chichainak: “Ee, auka nekas Galileanmayayaiti”, tusa tuina. Tuinakai, apu Herodes Galileanmaya shuaran apuri asa, Jerusalénnum taa irak weká asamtai, ni ejétitarma tusa takai, Jesúsan jukiar Herodesan ejétiaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Turam apu Herodescha nigka yaunchuk nagkamas ni pachisa etserainamun antak, itursanak wisha ni iwainaka takámun wainkaj tu enentaima puju asa, Jesúsan wainak shir aneasuiti. ");
INSERT INTO hubNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Tuma Jesúsan nukap iniasuiti. Turasha Jesúska ishichkisha aikchauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Tura sacerdote apuri aina, chicham umiktinan jintinkartin ainajai matsatu asar, chichaman tsanumruina. ");
INSERT INTO hubNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Turuinakai Herodescha nina suntaari ainajai iruuntur Jesúsnaka pegkerchau chicharaina asar, wishikainak apu nugkutairi pegkeran jukiar anugkar, apu Pilato pujamunam ataksha akupkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Herodeska yaunchukka Pilatojaigka kajernaikaru asar, wainnaitsuk pujuwaitiat, ataksha amikmaniawaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Jesúsan awaigki itaarmatai apu Pilato, judío apuri ainan, sacerdote apuri ainancha tura chikich shuar ainajaimak irumrauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","15","Tura chichaak: “Atum shuar ainan jintintuk apu ainaka umirkairpa tinayi tusarum itartin asaakrumin, atumsha antarmin chichaman nekaratajkamancha, ni makumamaintrinka nekarachmajai. Tura apu Herodesan nisha nekarati tusan akuptukmajai. Turasha nisha turusag ni tunau takasmaurincha nekarachai. Tura ataksha awaigki akupturkayi. Tura yamaika atumsha ni makumaku mantamnamaintri atsura nuka waintrume. ");
INSERT INTO hubNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Tuma asamtai waitat suakrum asuttratarma turarum inaisatarma tusan titatjai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Uwí nukapek jiisat Pascua nagkamakai judío apuri ainajai iruunar chichas, Pilatoka shuar achikmau ainanmaya chikichkinak tuke jiiskee au asa nunaka tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Tusa takai shuar nui tuak irunuka ashi chichainak: “¿Urukamtai ausha akupkatam? Auka akuptsuk Barrabás akupkata”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barrabáska Jerusalénnum pujus Romanmaya apun nakitainak shuar ainajai jianainamunam chikichik shuaran maa asamtai, achikmau egketu. ");
INSERT INTO hubNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Tuinakaisha Pilatoka Jesúsnaka akupkattsa wakera asa chichaak: “Atsaa nekas Jesúsan akupkatjai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Nuna takai, nu senchi chichainak: “Atsaa, ¡achintrati! ¡achintrati! amajaina”. ");
INSERT INTO hubNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Imatruinakai Pilato tresa jui chichaak: “Turasha ¿wari tunauna takasia? Wika ni makumaku mantamnamaintrinka waitkachjai. Tuma asamtai ayatik asuttratarma tusan titatjai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","24","Tusa takaisha, nu senchi chichainak: “Ayatik achintrati amajaina. Tura shuar aina iruuntur imatruina asar ninka nepetkiaruiti. Turam nisha achintrati tusa tsagkamkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Tura Barrabáska Jerusalénnum pujus Romanmaya apun nakitainak shuar aina jianainamunam chikichik shuaran maa asamtai, achikmau egketu. Nuna jiiki akupeak suntar ainan chicharuk: Yamaika jukirum, judío aina nita wakeruina turusag umikarti tusa Jesúsan nitain surukuiti”. ");
INSERT INTO hubNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Tusa timatai Jesúsan jukiar achir maawartasa umasar, Cirenenmaya shuar Simón naartin, ajan takak wu wakettatmaun wainkaruiti. Tura nuna wainkar, Jesús achirtinan ayankar, Jesúsan ukurin ayasar weena. ");
INSERT INTO hubNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Turuinakai nukap shuar aina nuwa ainajaimak ukunam saatus shimusar, wake mesemar nekapenak, senchi untsumas útaina. ");
INSERT INTO hubNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Imatainakai Jesús ayanmata nuwa ainan chicharuk: “Jerusalénnumia nuwa ainata, atumka wina anenkurmeka útirpa, atumek eamartarma, tumakrum atumin uchiri enentaimtusrum úttarma. ");
INSERT INTO hubNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Atum senchi waittsatin tsawan jeatnaiti. Nu tumakai uchirtinchau aina pachisrum, tura nuwa uchin jurechu aina pachisrum, nitaka yajau aneas matsatainatsuapi titin ainarme. ");
INSERT INTO hubNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Imanik senchi waitainak, nain ainan chicharainak: ‘Nain ainata, yumpunkarum ijikratakia’, tusar tiartin ainawai. ");
INSERT INTO hubNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Wii tunaun takaschau aig senchi waitkarsaru asarmatai, nitanka nu senchi waittan Yuus susatnaiti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Tura jimar shuar shir pegkerchau ainan Jesúsjai achir maattsar jukiaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Turawar nain Gólgota tutainam ejéniar, Jesúsan númi yapajiamunam achinak, jimar shuar shir pegkerchau ainancha turusag achirar, chikichan menanmani awajainak, chikichnaka untsurnumani númi yapajiamunam jigkaawar awajsaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Turam Jesús Yuusan aujeak: “Apaachi, nekainachu asar jutikruina nuka tsagkuurarta”, tusa tinaiti. Nuna takai suntar aina Jesúsan jaanchrin jurukiar, yáki nepetmakat nu jukiti tusar nakurutain nakuruina. ");
INSERT INTO hubNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Turuinakai shuar ainaka tuarak ii iruuntuina. Tumainai sacerdote apuri ainasha Jesúsan wishikainak: “Chikichnaka uwemtiknayi, yamai nisha nekas Cristo, Yuus etegkamuitkugka, nigki akaiki uwemrati”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Tura suntar ainasha turusag wishikainak, vino churuinan jukiar, umarti tusar suinak: ");
INSERT INTO hubNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","“Ame nekas judío ainan apuriyaitkumka, ani nematsuk akaikim uwemrakia”, tusar tuina. ");
INSERT INTO hubNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Tura nina chaikin tablanam: juwaiti judío ainan apurigka, tusa tu aatar anujtuku ainawai. ");
INSERT INTO hubNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Jimar shuar shir pegkerchau achiram netaunmaya chikichik Jesúsan pegkerchaun chicharuk: “Ame nekas Cristowaitkumka amea akaikim uwemeakum, incha uwemtikarturia”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Nuna takai chikich netau chicharuk: “¿Ameka nijai metek achiram nemasmesha ishichkisha Yuuska ashamatsmek? ");
INSERT INTO hubNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ika ina tunaurinig achira nenaam waitaji, turasha ju shuarka ishichkisha tunaunaka takaschau aig, jutika achiram nemas ijai metek waitawai. ");
INSERT INTO hubNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Tusa inaiyak, Jesúsan chicharuk: Jesúsa, ame apu jasam inamrattam nuisha kajinmattrukipa”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Tusa takai Jesús ayak: “Nekas tajame, ameka yamai tsawanta juik wijai Yuusa umirin jakaru aina matsatmaunam pujustatme”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Etsa tutupnira ai, ashi nugkanam etsa etsantsuk káshi jasuiti. Tuma etsa teenta ai ataksha tsaaptin jasuiti. Nu tuma ai, Yuus ememattasa iruuntai jeanam jaanch nuparam ajaamu yakini nagkamna jimapetuk achinakuiti. ");
INSERT INTO hubNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Nu tuma ai Jesús senchi chichaak: “Apaachi, ame wina wakantruka kuitamrutkata”, tusa tinaiti. Nuna tusa nui Jesús jakauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Nu tumamun Romanmaya suntara capitánkri wainak: “Ju shuarka nekas pegker ajakuiti”, tusa Yuusan emematu. ");
INSERT INTO hubNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ashi shuar nui ii iruuntuinaka Jesús tuma jakamtai wainkar, wake mesemar nekapenak netsepen awatki shimuina. ");
INSERT INTO hubNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Tumainai Jesúsan waintairi ainaka, ashi nuwa Galileanam nagkamas uyuunas kaunkau ainajai ikag ii iruuntuina. ");
INSERT INTO hubNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","54","Kashinia nui ayamtai tsawan tsawaartin asamtai, shuar ainaka nita takamaintrinka ashi umikaruiti. Tumainai apu José naartin Judea nugkanam yaakat Arimatea tutainam puju, nisha nu tsawantaik Jesúsan iyashi juki ikustasa apu Pilaton seattsa werinaiti. Tuma apun jeari chicharuk: Jesúsan iyashinka wii jukin ikustajai tusa tinaiti. Tusa takai ayu tima Jesús achiram yaki nemattamaun akaki jaanch pujujai punuar juki, shuar ikustin pampa taimu, chikichik shuarkesha ikushtainam ejé ikusuiti. José Arimateanmayagka shuar pegker asa, Yuus inammaun wainkattsa nakaa puju. Tumau asa judío apuri ainajai iruuntramunam Jesús maami tusar tuinakaisha, nigka nakitrauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","José Jesúsa iyashi ikustasa juki wematai, Galileanmaya nuwa aina Jesúsan nemarsar kaunkaruka, Jesúsan iyashin uruk aepsag ikusiawa nuna wainkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Tumawar waketar jeawar, Jesúsan iyashi ukatkatnun perfume ainan sumakaruiti. Nuiyasha ayamtai tsawan tsawaarmataigka, chikichik shuarkesha takascharti tusa, Moisés tu aarmau asamtai, nuna uminak jeag kintamraruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Domingo tsawan tsawaaru ai etsa yama waakai, nuwa aina Jesús ikusmaun jeariar, kugkuin pachimramujai Jesúsa iyashin ukatkartasa shiakaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Tumawar Jesús ikusmaunam jeaakma, kaya uunjai epenmauka ekemak atatmaun wainkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Turawar nuwa ainasha utuawaru, turasha nita apuri Jesúsan iyashinka wainkacharuiti. ");
INSERT INTO hubNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Tumawar urukamki tusar enentaima iruunas, nayaimpinmaya shuar jimar jaanch pujun wincha nugkuarun nitai wajainan wainkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Nuwa aina nuna wainkar ashamainak, nugka tsuntsumaa iruuntsamtai, nayaimpinmaya shuar aina nitan chicharuk: “¿Urukamtai atumsha iwáku pujaisha, jakau ikutainmasha eakrumsha yujarme? ");
INSERT INTO hubNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","7","Juigka atsawai. Nigka nantaki. Ni Galileanam pujus atumin chichartamuk: ‘Wii shuarnum akinawaitaj nunaka achirak, shuar tunau ainanam surutkartatui. Turutawarmatai numinam achirar mantuawarmatai, tres tsawantai ataksha nantaktatjai tina nu aneartarma’ ”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Tusa takai Jesús tumatnaitjai timaun aneararuiti. ");
INSERT INTO hubNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Tumawar nuwa ainasha waketar, Jesúsa unuinatairi once juakaru ainan chikich shuar ainajaimak nuna turammaji, tusar ashi ujakaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Nuna chichaman Jesúsa unuinatairi ainan ujakaruka ju ainawai: María Magdalena, Juana, María Jacobo nukuri, nuiyasha chikich nuwa ainajaimak ajakaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Jesúsan unuinatairi ainaka nuwa tusa etserainakaisha, waurainak tu yujainatsuash, tusar nitaka nekaspapita tuinachu. ");
INSERT INTO hubNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Chikichka tuinaig Pedro ni jiinkug tseketaik Jesús ikusmaun jeari utua iikma, jaanch Jesús punuarmauka chikich yantamnum matsamtatmaun wainkauwaiti. Tura nuna wainak Pedroka enentain jeaachu, tuma jea waketkinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Nu tsawantaik Jesúsa nemarin jimar shuar Jerusalénnumia jiinkiar, once kilómetros aunam yaakat Emaús tutainam weena. ");
INSERT INTO hubNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Tumainak yaakat Jerusalénnum iturchat nagkamasmaun pachisar chichaki weena. ");
INSERT INTO hubNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Tumainai Jesúscha wantiintuk nitajai wea. ");
INSERT INTO hubNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Turasha nitaka Jesúsapita tusarka nekainachu asar, pachitsuk weena. ");
INSERT INTO hubNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jesús nitajai wesa iniak: “¿Jinta wesarmesha wari aujmatkirmesha wearme?” tutai wake mesekar wajasaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Tumayat Cleofas naartin ayak: “Ashi shuar Jerusalénnum iturchat a nuna nekainaisha ¿urukamtai ameksha nekatskesha pujame?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Tusa takai ayak: “¿Wari iiturchata awa?” tusa inimkai nita aimainak: “Jesús Nazaretnumia Yuusa chichamen etserin, shir chicharkartina nuna, shuar jainancha chichamenig pegker amajuk, jakauncha turusag inantuk, shuar ainaka shir anentsa wakeram, Yuuscha wakerutai pujuwa nu maamu asamtai taji. ");
INSERT INTO hubNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","21","Iman asamtai ika niimpapi apu jas Israel shuar ainatinka agkanmamtikramattajia tinaji. Tu pujurmaun sacerdote apuri aina ina apuri ainajaimak nakitainak numinam achirar maawarti tusar surukarmayi. Nu turamuka tres tsawan nagkamaki weawai. ");
INSERT INTO hubNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","Tumai yamai káshikmas nuwa aina Jesús ikusmaun iistasa wearu. Taawar chichainak: Yuus akupkamu nayaimpinmaya shuar jimar wainkaji. Nu chichartamuk Jesúska nantaki pujawai, turamji tusar kaunak etserainakai, enentai jearchaji. ");
INSERT INTO hubNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Tumainarin ijai iruunar yujau aina, nuwasha nekaspash tuina tusar weriar iikma, nuwa timaunka imatiksag wainkarai. Turasha Jesúsnaka wainkacharai”, tusar ujaina. ");
INSERT INTO hubNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","26","Tuinakai Jesús nitan chicharuk: Shuar enentaimchau ainata. Yaunchuk Yuusa chichamen etserin ainasha nuna pachisar Cristoka senchi waitkasa maam ataksha nantaki, nui apuma pujus inamratnaiti tusar tiaru aina nuka ¿urukamtai nekaspapita tichamnausha nekapearme? ");
INSERT INTO hubNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Moisés Criston pachis tu aaruiti. Tura Yuusa chichamen etserin ainasha turusag Cristoka waitkasa maamsha tumatnaiti tusar tu aaru ainawai, tusa shir antumtikattsa jintintas uja. ");
INSERT INTO hubNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Tumayat Jesúska yaakat Emaúsnum jeak, nitan ikuak emak weakai ");
INSERT INTO hubNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","chicharainak: Etsasha akawai juig kanarta tusar emetawaruiti. Tusar tuinakai nita jeen wayawaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Tuma yuawartasa mesanam ekeemsarmatai, Jesús pankan juki, Yuusan maaketi tusa puuk akantsag susauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Turam juka nekas Jesúsapita tusar nekaawaruiti. Tumaig Jesúscha nitajai eketiat megkaakauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Tumamtai nitak chichainak: ¿Urukakrik jinta winis Yuusa chichamen tu awai tusa ujatmakai, shir aneasa winimaj nuisha ima enentaimrarsha iischamji? tusar tunaiyaina. ");
INSERT INTO hubNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Tusar nekapsar wári Jerusalénnum waketrar, Jesúsa unuinatairi aina chikich shuar ainajaimak iruunar matsatmaunam jeawaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Tumawarmatai jea matsatu chichainak: Ina apuri Jesúska nekas nantaki, tuma Simónkan wantintukai tusa ujaina. ");
INSERT INTO hubNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Tuinakai nitasha chichainak: “Incha jinta wearin amaintamak Yuusa chichamen etserin aina aarmaun pachis ujatmakai wainkamji. Tura yaakat Emaúsnum jeaar, jea wayar mesanam ekeemsakrin, ni pankan juki, Yuusan aujas maaketi tusa puuk ina suramkai, nantakiapi tusar nekamji”, tusar nitancha ujaina. ");
INSERT INTO hubNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Nu jeanmak iruunar matsamas Jesúsan pachisar chichaa matsatai, Jesús ataksha nitan wantintak: “Agkan shir enentaimsarum pujustarma”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Takai Jesúsan wainkar, wakanchauwashit tusar senchi ashamkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Tumainakai Jesús nitan chicharuk: “¿Urukamtai ashamrarme? ¿Urukamtai winasha nekaspapita turutchamnausha nekapearme? ");
INSERT INTO hubNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Wiyaitjai. Tantarum wina uwejur, tura nawersha achisrum iirtustarma, wakanka ukunchtinchauwaiti, tura iyashtinchauwaiti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Nuna takug ni achintramun uwejen nawejai inakmasuiti. ");
INSERT INTO hubNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Turam wainkar shir anenayat nekaspapita tumainchau nekapena. Tumainakai nitan chicharuk: “¿Yumain atsuak? surustarma”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Takai namak uchuramun kupikar susaruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Turam nitasha wainainaig namakan yuawaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","46","Jesús nina unuinatairi ainan chicharuk: “Moisés aarmaun, Yuusa chichamen etserin ainasha, tura Davidcha wina pachitas kantamtain aaksha, Cristoka waitkasa maamsha tres tsawan asa, ataksha nantaktinaiti tusa tu aaru ainawai, tusan atumjai pujumiaj nui jintintawaitjarme. Nunaka mantuawarmatai nantakin ashi umikjai tusa tinaiti. Jesús nuna tusa pachis taku nina unuinatairi ainan shir antumtikauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Tura nuiyasha chichaak: Shuar awake enentaimrar nita tunaurin inaiyainakai, Yuuscha nita tunaurincha tsagkurati, tusa wina pachittsarka Jerusalénnum nagkama chikich nugkanmasha ashi etserartin ainawai. ");
INSERT INTO hubNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Atum ainarme nu tusa etserkatnutirmeka. ");
INSERT INTO hubNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Turasha jui Jerusalénnumag matsamsatarma, tumarmin wina Apar Wakan Pegkeran anajmatramawa nuna akuptuktatjarme”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Nuna tina inaiyak, nina unuinatairi ainajai iruunar Jerusalénnumia jiinkiar Betania jintanam wearuiti. Tuma nina unuinatairi ainan irumar, uwejen takui chicharuk: “pujumatarma, Yuus yainmakarti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Tusa yaki takuni, nayaimpinam waketkinaiti. ");
INSERT INTO hubNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Tumamtai ememattsar ikuinak shir aneasar Jerusalénnum wakettraruiti. ");
INSERT INTO hubNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Tumawar Jerusalénnum jeawar, Yuus ememattasa iruuntai jeanam iruuntrar Yuusan kashi kashinig ememataina. Maake, nunis atii.");
INSERT INTO hubNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Cristoka yaunchuk nugkasha najanatsaig Yuusjaigka puju jakuiti, nigka Yuusketi. ");
INSERT INTO hubNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Nigka Yuusjaig yama nagkamchaksha tuke puju jakuiti. ");
INSERT INTO hubNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ashi najankamu iruna nunaka Yuusjaig najankauwaiti. Chikichkiksha nitak najanakuka atsawai. Ashi ni najankamuk ainawai. ");
INSERT INTO hubNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Jesucristowaiti shuar ainatin Yuusjai pujusarti tusa pujut nagkanchaun sukartauka. Tura nigkiti shuar ainatin Yuusnumian nekasa nuna nekamtikartauka. ");
INSERT INTO hubNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Shuar Jesucriston umirainaka tsaaptina numamtinnum pujuina asar, tunaunka takachu ainawai. Tumau asar nitaka Yuus wakeramuncha nekainawai. Shuar Yuusan umirchau ainaka tunaun takau ainawai. Tumau asar nitaka káshia numamtinnum pujuinawai. ");
INSERT INTO hubNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Yuus chikichik shuaran Juan naartinan entsajai imakratna nuna akupkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Nuka Cristo winitnurin pachis etserkati, turakai shuar ainasha antukar nekaspapi tawa, tusar pujutin yapajiawarti, tusa akupkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Turasha Juanka Cristo ajakchauwaiti. Antsu ninka Yuus etegka, ame weme Cristo pachisam shuar aina ujakarta tusa akupkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ashi shuar ainan Yuusan pachis nekamtikatin, shuar ju nugkanam taawaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Cristoka shuar ainajai pujustin asa, ju nugkanam shuarnum akinawaiti. Yuuska Cristojai nugkan najanawaiti. Turasha shuar ainaka yakit tusarka nekacharu ainawai. ");
INSERT INTO hubNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ju nugkanam Israel weantunam akinawaiti, nitajai metek ajakuiti. Turasha nina patai ainaka nekaspapita ticharu ainawai. ");
INSERT INTO hubNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Turawarmatai chikich aina nekaspapita tiaru ainawai. Nu ainanka Yuus nina uchiri amajkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Nitaka Yuusa uchiri ainawai, nitaka shuaran uchiriya nuninka ainatsui. Antsu nitanka Yuusak nina uchiri amajkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Cristo shuarnum akina inii pujus, pegker ainan takasua nuka ii wainkau ainaji. Pegker ainan takasua nunaka, nina Apari nijai pujau asamtai turawaiti. Yuusa uchiri chikichkia nuka nijai meteketi. Ina senchi anenmamun ni iwainturmakuitji, tura Yuusnasha nekamtikramawaitji. ");
INSERT INTO hubNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Juan, Jesúsan wainkau asa pachis chichaak: “Wii atumin ujakun wina ukuruin winitta nu nigka yaunchuksha tuke puju asa, nekas wina nagkatakuka atatui, timaj nuka juwaiti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ashi nina anenkari nuiyag pegker pujutka jukinaitji, tuma asaakrin kashi kashinig yainmaji. ");
INSERT INTO hubNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Shuar aina iruuntsar shir pujusarti, tusa chicham umiktinan Moisésan yaunchuk Yuus susauwaiti. Turasha chicham umiktinan uminachu asar, waittan jumainan Jesucriston nekaspapita tuina asarmatai uwemtikauwaiti. Yuus ina anenmaj nunasha iwainturmakuitji, tura nigki chicham nekasa nunasha jintintramawaitji. ");
INSERT INTO hubNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Chikichik shuarkesha Yuusnaka pegke wainchau ainawai, turasha uchiri chikichkia nu nina aparinka nekamtikramaji. ");
INSERT INTO hubNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Judío apuri aina Jerusalénnum pujuina asar, nekas Cristokaitam tusarum shir nekaatarma, tusar sacerdote ainan Leví weantu ainajai Juankan akuptukaruiti. ");
INSERT INTO hubNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Nu turamu aina jeawar Juankan ininak: Nekas ame Cristokaitam tusar tuina. Tusa tama Juan chichaak: “Wika Cristochuitjai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Tusa timatai awentsag ininak: “¿Turasha yaitam? ¿Yuusa chichamen etserin Elías ajakua nukaitam?” Tama Juan chichaak: “Atsaa wika Elíaschauwaitjai”, takaisha ataksha awentsag ininak: “¿Yuusa chichamen etserin taatna nukaitam?” Nu tamasha chichaak: “Atsaa wika nuchauwaitjai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Takai ashi tujinkar chichainak: “Wait aneasam amesha yaitam nu shir ujakratkata, nita amina nekarmawartasa wakerutmaina asarmatai, shir nekaar ina akuptamkarmaj nu ujaktasar taji”, tusa tiaruiti. ");
INSERT INTO hubNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Tama Juan nitan ayak: “Wika chikichik shuar aya nugkanmag wekaas chicharkartak: Apu taatin asamtai, jinta pegker iwartia numamtuk tunau takatai aina nu inaisatarma, titinaiti tusa Yuusa chichamen etserin Isaías tina nuwaitjai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Fariseo aina ishiakmau ataksha Juankan chicharainak: ");
INSERT INTO hubNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","“Turasha ame Cristochu, tura Elíaschau, tura Yuusa chichamen etserin taatnaiti timauwa nukesha achayatmesha ¿urukamtai shuarsha entsanmasha imame?” tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Tusa tuinakai Juan nitan ayak: “Wika shuar tunau takatan inaisau aina nuna entsajai imajai. Turasha atum ainarum nuiya chikichik pujawai, nuka juwapita tusarmeka nekatsrume. Nuka wii entsajai imakrataj jutikagka imakratchattawai. ");
INSERT INTO hubNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Nigka yaunchuk nagkamas tuke pujuwaitiat yamaika wina ukuruin taattawai. Nigka wina nagkatakuiti. Tuma asamtai wika nina senchi arantusan iiya asan, nina inatairigsha amaitsujai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Nunaka nugka Betania tutaiya nui, entsa Jordán amain Juan imakratkur pujamunam tumawaruiti. ");
INSERT INTO hubNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Kashin tsawak Juan, Jesús winittamaun wainak shuar ainan chicharuk: Iistarma, Ovejaya numamtinan Yuus nekas ina akupturmakmauka auwaiti. Niyaiti ashi nugkanmaya shuar aina nekaspapita tuinan tunauri tsagkurnartinan mantamnak numpen puartinka. ");
INSERT INTO hubNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Atumin chicharkun yaunchuksha tuke puju jaku asa, wina nagkataku wina ukuruin taattawai timaj nuka auwaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Israel shuar ainaka, ni wantinkai shir nekaawarti tau asan, wisha ninka wainchauwaitkun nekaspapita tuinak tunau takatan inaisarti tusan entsajai imakratmajai. ");
INSERT INTO hubNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Wisha ninka nekachmajai, tumai wina entsajai imakratta tusa akuptukua nu chichartak: “Nayaimpinmaya Wakan Pegker yampitsa numamtin nanaaki tara, nu shuaran ekeemtuktatui, tumakai juwapita Wakan Pegkeran sukartustinka tusam nekata turutin asamtai, ");
INSERT INTO hubNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","wika yamai ju shuaran turan wainkan, juwapita Yuusa uchirigka tusan shir nekaajai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Kashi tsawak Juan ataksha jimar shuar nina nemarin ainajai wajajkama, ");
INSERT INTO hubNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Jesús nagkamattamaun wainkauwaiti. Tuma chichaak: “Iistarma, Ovejaya numamtinan Yuus nekas ina akupturmakmauka auwaiti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Nu jimar shuar Juanjai yujaina, ni tamaun antukar Jesúsan nemarainak ninka ikukiaruiti. ");
INSERT INTO hubNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Nu tumainakai Jesús ukurin ayanma iimsatajkama nitan wainak chichaak: “¿Atumsha wari earme?” tusa tinaiti. Takai nita chichainak: “Unuikartina, ¿amesha tui pujame?” tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Tama Jesús nitan chicharuk: “Weajai, ai wainkatarma”, tusa tinaiti. Takai nijai iruuntrar Jesús pujamunam jea wayawaruiti, tuma etsa pegke aka asamtai, nui kanaru ainawai. ");
INSERT INTO hubNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Nu jimar shuar Juan timatai, Jesúsan nemarkaru aina nuka: “Andrés Simón Pedro tutaiya nuna yachi ajakuiti. ");
INSERT INTO hubNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andrés nuna wainak, chikichnaka ujatsuk nina yachi Simónna weri, yamaika Mesías wainkaji”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Nuna tusa nui Andrés Simónkan juki Jesús pujamunam ejémtai, Jesús chicharuk: “Ameka Simón, Jonása uchiriyaitme, yamaika ame naarmeka Pedro atatme”. ");
INSERT INTO hubNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Kashi tsawak Jesúsjai Galileanam wenajkama Felipen wainkaruiti. Tura Jesús chicharuk: “Wina nemartukta”, tusa tinaiti. Tama ayu tusa nemarkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Felipeka yaakat Betsaidanam Andrés Pedrojai puju jakua nuiya ajakuiti. ");
INSERT INTO hubNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Tura Felipesha Natanaelan ujaktasa wuwaiti, tura jeari chicharuk: “Chicham umiktinan Moisés yaunchuk aak: ‘Chikichik shuar nugkanam taatnun pachis aarua nu nekas wainkamji’, Yuusa chichamen etserin chikich ainasha turusag aararu ainawai. Nu shuarka Jesúsaiti, José yaakat Nazaretnumiaya nuna uchiriyaiti tuina nuwaiti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nu tusa ujam Natanael chichaak: “¿Nazaretnumiasha chikichik shuar pegkersha amainkait?” tusa tama Felipe chicharuk: “Weajai, ai iisminam”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Takai Felipejai juakiar Jesús pujamunam wearuiti. Tumattamaun ikag Jesús wainak Natanaelan pachis chichaak: “Au israelita waitrichu Yuus wakera tumasag pujuwa nu winawai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Takai Natanael anturmamak chichaak: “¿Winasha nusha tui waitkamame?” Tama Jesús ayak: “Wika aminka Felipesha tarutrami ujatmatsaig ame númi higueranam wakenam weamkam pujumam nuik wainkamjame”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Tusa tutai Natanael chichaak: “Unuikartina, ameka Yuusa nuna uchiriyaitme, ametme Israel shuar ainan apurimka”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Tutai Jesús ayak: “Ameka wii higueranam wakenam weamkam pujamin wainkamjame taja nuik, Yuusa uchirimpapita tusamsha ¿tu enentaimturam? Nuna tajam nu nagkamasam atum wainkachmaun iwainamusha wainkatnaitrume. ");
INSERT INTO hubNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Nuna tusa nuiyasha Jesús chichaak: ‘Nekasa tajarme, nayaimpinmaya shuar aina nu, Yuusa uchiri shuarnum akina pujamunam akaarar waketainai chikich aka jainai, mai yapajin ja ausha atumka wainkatin ainarme’ ”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","2","Tresa imajnia tsawan tsawaarmatai Galilea nugkanam yaakat Caná tutainam nuwa nuatmau atin asamtai, Jesúsan ipainak nina unuinatairi ainancha ipaawaruiti. Turamu asar Jesús weakai nitasha wearuiti. Nina nukurisha nu jiistammaunam pujau. ");
INSERT INTO hubNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Nuwa nuatmau nagkamnamtai utsaanawar umuinamunam umutai vino tutai amukau. Tumamtai nina nukuri Jesúsan chicharuk: Vinonka amukarai, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Tusa tama Jesús ayak: “Amesha, ¿urukamtai winasha nusha turutme? Wii takamaintruka eke tsawanka jeatsui”. ");
INSERT INTO hubNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Takaisha María nui shuar ajamau irunun chicharuk: “Atumka ni waritrutmatig nuka imatiksarmek umirkatarma”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Timatai seis muits kaya uun najankamunam, judío aina pegker jasmi tusar entsan aimak nijaama jaku aina nu matsatu. Nu muits ainanmagka “cincuenta, setenta litros” tumain entsan aima jakaruiti. ");
INSERT INTO hubNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesús inatai ainan chicharuk: “Nu muits aina nui entsa shikikrum aimratarma, tusa takai aimraruiti”. ");
INSERT INTO hubNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Turawarmatai nitan chicharuk: Yama nagkamchakrumka nuwenmaun chichamra nu shikikrum susatarma tusa takai, nuna susaruiti. ");
INSERT INTO hubNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Turam nuwenmaun chichamrauka entsan vino amajsamunka nekatsuk umar, pegker nekaprauwaiti. Inatai entsan shikikar aimraru ainaka, entsanapi aitkawa tusar shir nekaina. Tumainaig nu nuwenmaun chichamrau shuar nuwan nuatun untsuk ");
INSERT INTO hubNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","chicharuk: “Chikich aina nuwan nuatainakka yama nagkamchak pegkeran ajamasar shuar nukap umararmatai, umutain pegkerchaun ajamau armayi. Turasha ameka nuka turutsuk yama nagkamchakum pegker ajamasmesha, aruma nuisha imanuk ajamame”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Galileanam yaakat Caná tutai a nui, Jesús yama nagkamchak nina senchirin iwainaktasa, entsan vino amajsauwaiti. Nuna turamtai, nina unuinatairi aina juka Yuusa uchirimpapita tusar shir nekaawaruiti. ");
INSERT INTO hubNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Nuna tura Jesús nukurin, yachi ainan juki ashi nina unuinatairi ainajaimak yaruak, nijai iruuntsar yaakat Capernaúmnum jeawaruiti. Tuma ishichik tsawan nu yaaktanam pujusaruiti. ");
INSERT INTO hubNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Judío ainan jiistari Pascua tutai jeastatuk jasmatai, Jesúsjai Jerusalénnum jeawaruiti. ");
INSERT INTO hubNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Tuma Yuus ememattasa iruuntai jeanam Jesús wayajkama, shuar vacan, oveja ainan, paum ainajaimak utsaawar suruinak, tura kuitan yapajinak matsatun wainkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Tura wainak nuap chapikmarmau atatmaun juki, shuar suruinak nui utsaana matsatunka, nita tagkuri ainajai iwijar aa ishimuk, kuitan yapajinancha nagkimruk nugka akaketak, mesarincha nagkimrukuiti. ");
INSERT INTO hubNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Tura pauma surin ainan chicharuk: “Ju aina juka ashi aa jiirtaarma. Wina Aparu jea juka yutai surutaigka amajsairpa”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Nuna takai nina unuinatairi ainasha Yuusa chichame aarmaunam chichaak: “Amina jeemin akasmatakun senchi waitajai”, tu aarmauwa nuna aneararuiti. ");
INSERT INTO hubNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Judío apuri aina chichainak: “¿Urukamtai, shuar chichame anturtai uruka imanikmesha shuarsha aitka jiirmesha ishimme?” tusa tiaruiti. ");
INSERT INTO hubNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Tuinakai Jesús nitan ayak: “Jea puja ju yumpuarakrumnasha, tres tsawantaik ataksha wii jeamkattajai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Nuna takai judío apuri chichainak: “Cuarenta y seis uwítin jeamkamua nuka ¿tres tsawantaik jeamkattam?” tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Jesúska nunaka jean taku tichauwaiti, antsu nina iyashin pachis taku tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Jesús nuna tina nunaka, ni mantamna nantakmatai, nigkiapi pachimas tinaita tusar nekaawaru ainawai. Tumainak Yuusa chichamen aarmauwa nuna, tura Jesús timauncha nekaspapita tiaru ainawai. ");
INSERT INTO hubNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jesús jiisat Pascua tutain inagkastasa Jerusalénnum jeaa pujus, shuar turumainchaun iwainak takakai, nukap shuar aina nekaspapi Yuusa uchiriyaita tusar tiaruiti. ");
INSERT INTO hubNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Tumainakaisha Jesúska nita enentaimmaurinka shir nekau asa, nekaspapi enentaimturainawa tusagka tichauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Nigka shuaran enentaimmaurinka shir nekau asa, chikich shuar aina, ju shuarka tu enentaimainawai tusar ujatkarti tusagka tichauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Fariseo shuar Nicodemo naartin judío ainan apuri ajakua nu, ");
INSERT INTO hubNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Jesúsan iistasa káshi jeari chicharuk: “Unuikartina ika nekainaji, ii ainatin jintintati tusa aminka Yuus akuptamkauwaiti. Yuusjai pujachuka ame ii wainchatai aina nukap iwainakam takam imatikagka takamainchau ainawai”. ");
INSERT INTO hubNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Tusa tama Jesús ayak: “Nekas tajame, shuar ataksha akinachuka Yuusa pujutairiya nuigka pegkesha wayaashtin ainawai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Tusa tama Nicodemo Jesúsan iniak: “¿Nusha urukaya shuar ima uuncha ataksha waketkisha uchimasha akinmainaita? ¿Ataksha nukurin ampujenig egkemar akinmainait?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Tusa takai Jesús ayak: “Nekas tajame, shuar akiamusha Wakan Pegkera nu egkemtura pujuti yapajtuachmauka Yuusa pujutairinka wayashtinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Shuar akiamuka shuaran uchirigketi, antsu Wakan Pegkera nu egkemturmauka, Yuusa uchiriyaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Juna taja nuka urukarik tumamainait tusamka iturchat enentaimipa, ashi metek ataksha akinmainaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Nasegka ni wakeramunam umpuawai, turak uutmaurisha anturnaitji, turakrisha tuiyag wina, tura tuki wea nuka nekatsji. Numamtuk Wakan Pegkersha shuaran yamaram shuar amajeawai. Nu turamunka shuar ainasha wainmain ainawai, turasha uruk turawak nunaka nekainatsui”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Tama Nicodemo chichaak: “¿Nusha urukag tumatnaita?” tusa iniasuiti. ");
INSERT INTO hubNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Takai Jesús ayak: “¿Ame Israel shuar aina nu unuinachukaitam, imanuitiatmesha urukamtai nusha nekatsme? ");
INSERT INTO hubNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nekas tajame, ika nekamu chichaaji, tura ii wainkamua nuke etserji. Turasha atumka ii etsermauka antayatrum nekaspapita tatsurme. ");
INSERT INTO hubNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ju nugka juiyan pachisan wii etserkaisha nekaspapita tachautirmesha, ¿itursarmek nayaimpinmayan pachisan etserkaisha nekaspapita titarme? ");
INSERT INTO hubNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ju nugka juiya shuarka chikichkiksha nayaimpinam wakagka tachau ainawai, antsu wikitjai nayaimpinmayan akaikin shuarnum akinanka. ");
INSERT INTO hubNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Moisés napin najana aya nugkanmag numinam nenawa numamtuk, wii shuarnum akinawaitaj nunasha, numinam netuawartin ainawai. ");
INSERT INTO hubNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Ashi shuar wii tumamun juwapi uwemtikrurtatua, tusa winak shir enentaimturainaka waittanam wetsuk, pujut tuke atina nuna jukiartin ainawai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Yuuska ashi shuar ainatin shir senchi anenmau asa, wina uchir chikichkia nuna nekaspapita tusa umiruka waittan jukichartin arti, antsu pujut tuke atinan jukitin arti, tusa nina uchiri chikichkia nunaka suramsauwaitji. ");
INSERT INTO hubNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Yuuska shuar ainatin makuti tusagka ju nugkanmagka uchirinka akupturmakchauwaitji, antsu uwemtikati tusa akupturmakuitji. ");
INSERT INTO hubNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Tura asamtai Yuusa uchirin nekaspapita tauka waittanmagka wechartin ainawai. Antsu Yuusa uchiri chikichkia nuna nekaspapita tuinachuka waittanam weartin ainawai. ");
INSERT INTO hubNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ju nugka jui Yuusa uchiri taawaiti. Tuma shuar aina tunau takaina asar, káshia numamtinnum pujuinan nita tunauri paan iwaintukuiti. Turasha shuar ainaka tunau takatan ima senchi wakeruina asar, Yuus wakeramun takainak tsaaptinnum pujumaina numamtuk pujutnaka nakitraru ainawai. Tumawaru asar Yuusnaka tuke tupantraru ainawai. ");
INSERT INTO hubNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Shuar tunaun takainaka Yuusa uchiri Tsaaptina numamtina nunaka, Tsaaptinnum wayaan tunau takatai ainan iwainakaij, tusar nakittraru ainawai. ");
INSERT INTO hubNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Turasha pegkeran takainaka Yuus wakeramun takasaru asar, nita takasmaurin iwainakartasa, Yuusa uchiri Tsaaptina numamtina nui tainawai”. ");
INSERT INTO hubNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Nui Jesúsjai wenak Judea nugkanam jeawaruiti, tura entsanam imakratainak nukap tsawan pujusaruiti. ");
INSERT INTO hubNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Tumainai Juansha Enón, Salimnum jeattak a nui imakratuk pujau, tuma asamtai ashi shuar aina chicham etsermaun nekaspapita tusa anturak ninii jeaka entsanam maakaru ainawai. ");
INSERT INTO hubNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Nunaka Herodes Juankan cárcelnum eke egkeatsaig tumajakuiti. ");
INSERT INTO hubNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Juankan nemarin aina judío apurijai shuar pegkerchaurinnusha uruk pegkermamainaita, tusar chichainamun inagnakar, ");
INSERT INTO hubNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Juankan jeariar chicharainak: “Unuikartina, Jordán amain pujarin ame wina ukuruin winittawai tusam etsermam nu yamai imakratui, tumakai nukap shuar tuarainawai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Tuinakai Juan chichaak: “Yuus turata tusa tichamuka aunka pegkesha aitkamaitsui. ");
INSERT INTO hubNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Wii atumsha ashi antuinarmin paan iwainakan, wika Cristochuitjai, antsu nina pachis etserkati tusa emtika akupkamuitjai, tusan timiaj nuka atumka shir nekarme. ");
INSERT INTO hubNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Chikichik shuar nuwenkai wayaa iiyam, nuwa aishri atintrin ayaamas wajas, ni chichaakai anturak shir anena numamtuk, Cristo pachisa chichainamun antaknaka wisha shir aneajai. ");
INSERT INTO hubNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ninak kashi kashinig shuar tuarainak eme anentiartinaiti, tumainak winaka ayatik ikurkiartinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Yakiya taawa nu ashi nagkakartakuiti. Antsu wii nugkaya asan, nugkanmayanak pachisan chichaajai. ");
INSERT INTO hubNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Nayaimpinmaya taawa nu, ashi ni wainkamun, tura antukmauriya nuna pachis etserui, turasha shuar ainaka nekaspapi tawa tusarka tuinatsui. ");
INSERT INTO hubNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Antsu ni etsermaun anturaina Yuus akupkamu asampapi tawa tuinaka, Yuusnasha nekaspapita tuinawai. ");
INSERT INTO hubNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Yuus Wakan pegkeran susa akupkamu asa, nina chichamencha shir etsertawai. ");
INSERT INTO hubNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Yuuska nina uchirin anea asa, ashi nugkanmaya ainanka nigki iistii, tusa senchirinka susauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Shuar Yuusa uchirin nekaspapita tusa umiruka pujut tuke atina nui wetinaiti. Turasha Yuusa uchirin nekaspapita tuinachu asa umiriachuka pujut tuke atina nuigka wechatnaiti, nu shuarnaka waitat tuke atina nuna Yuus susatnaiti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Nukap shuar Juankan nagkasau Jesúsan nemarainawai, tura Juankan nagkasau imakratui tuinamun fariseo aina antukaruiti. ");
INSERT INTO hubNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Turasha Jesúska imakratchauwaiti, antsu nina unuinatairi ainan imakrattarma tusa inaruiti. ");
INSERT INTO hubNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Fariseo shuar aina nuna antukarai tamaun Jesús anturmamkamtai, Jesúsjai Judea nugkanmaya ataksha Galileanam wearuiti. ");
INSERT INTO hubNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Tumawar Samaria nugkanmani nagkamakiartasa wearuiti. ");
INSERT INTO hubNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Tuma Samaria nugkanam jeattak, nugkan yaunchuk Jacob nina uchirin Josén susauwa nui yaakat Sicár tutainam jeawaruiti. ");
INSERT INTO hubNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Tuma Jesúscha weká wekakua senchi pimpikin asa, etsa tutupin jasa ai, Jacob yaunchuk nugkan tai yumirma jakmaunam ayaamas ekeemsauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Turasha nina unuinatairi ainaka yutain sumakartasa yaaktanam wearuiti. Tuma nui eketai Samarianmaya nuwa entsan shikiktasa jeamtai, Jesús chicharuk: “Winasha entsa shikikam surusta, umartajai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Tama Samarianmaya nuwasha Jesúsan ayak: “¿Urukamtai wii Samarianmaya nuwa aisha ame judíowaitiatmesha entsa shikikam surusta, umartajai tusamsha turutme? Judío ainaka Samarianmaya shuarjaigka pegkesha aujnaichau ainawai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Takai Jesús ayak: “Yuus aantra amasmauwa nu, entsa surusta umartajai tusa amina seatma nu nekaam, amesha turusmek seamka nigka entsa chuchuwe pujut tuke atinan sukartina nuna amamainaiti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Tutai nuwa chichaak: “Apu, ame entsa shikitai takaktsumjama, entsasha warijaiya shikiktatam, entsaka init ajama, ¿ame entsa chuchuwe tame nusha tuiya tame? ");
INSERT INTO hubNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","¿Ame ina uuntri Jacob ajakua nu nagkasaukaitam? ina uuntri Jacob ajakua nu juna yumirmatain ikurtamkinaitji. Nisha junak yumirma jakuiti, tura nina uchiri ainasha junak yumirma jakaruiti, tura tagkuri ainasha junak yumirma jakaru ainawai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Tusa tama Jesús chichaak: “Ju entsa juna umauka ataksha kitaarartin ainawai. ");
INSERT INTO hubNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Antsu wii susam entsan umaru ainaka nita enentain entsa chuchuwe tuke aramu asar, atakea nuisha kitaarchartin ainawai. Nu shuarnumka entsa chuchuwe pujutan sukartina nuka megkaatsuk arumaisha tuke atinaiti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Nu tama nuwa chichaak: “Apu, winasha nu entsa surusta wisha umartajai atakka kitaarchamij, entsa shikiakun waketraj juni pujuij”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Tutai Jesús ayak: “Weme aishrum untsuka jukim jui nijai taata”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Tutai nuwa chichaak: “Wika aishrinchauwaitjai”, tusa tinaiti. Takai Jesús ayak: “Wika aishrinchauwaitjai tame nuka nekas tame. ");
INSERT INTO hubNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Turasha amina aishrumka cinco ajakuiti, tura yamai aishrum aa nusha amina aishrumchauwaiti. Ame aishrinchauwaitjai tame nuka nekas tame”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Takai nuwa chichaak: “Apu, ameka nekas Yuusa chichamen etserin iiyajme. ");
INSERT INTO hubNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ina uuntrigka Yuusnaka eme anentas iiyainak, ju nainta jui emematu jakaru ainawai. Turasha atum judío ainatirmeka, Yuus emematmainka Jerusalénka auwaiti tinu ainarme”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Takai Jesús ayak: “Nuwa, nekaspapita turutta, tsawan jeamtaigka ju nainta juigka, tura Jerusalénnumkesha Yuuska emematchatin ainarme. ");
INSERT INTO hubNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Atumka nekachiatrum emematrume, turasha ika nekau asar uwemtikartinka judío ainanmaya taatin asamtai, Yuuska emematji. ");
INSERT INTO hubNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Yamaika tsawan uminui, ju tsawantai wina Aparun emematin ainaka, ninak enentaimtus, juwapita tusar emematiartatui. Aparka iman ainanak emematriarti tusa eawai. ");
INSERT INTO hubNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Yuuska Wakaniti, nuna emematuk ninak enentaimtus juwapita tusar emematin aina nuka, tumasag emematmain ainawai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Tutai nuwa chichaak: “Mesías Cristo tutai taatna nunak nekajai. Ni taak ashi ujatmaktinaitji”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Takai Jesús ayak: “Wii amijai chichaj nunaka Tuke pujuwa nuwaitjai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Nuna tusa nuwan auju pujurai, Jesúsa unuinatairi ainasha kaunkaruiti. Tuma nuna wainkar enentai jearcharuiti. Tumawarsha ¿wari iniame? tusarka nuwanka ticharuiti. Tura Jesúsnaksha ¿wari pachismea au nuwajaisha chichame? tusarkesha ticharuiti. ");
INSERT INTO hubNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Jesúsa unuinatairi aina kaunkarmatai nuwaka entsa shikitairinka ajapa ikuak yaaktanam wuwaiti, tuma jeaa patai ainan chicharuk: ");
INSERT INTO hubNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Weajai, atumsha ai shuar pujuma nu iistarma, wii tuma jakmaunka ashi ujatkamai. ¿Yakit, Cristochuashit?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Takai yaaktanmaya ainasha Jesúsan iisartasa weriaru ainawai. ");
INSERT INTO hubNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Nuwa yaaktanam waketkimtai Jesúsan chicharainak: “Unuikartina, amesha yuata”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Tusa tuinakai Jesús nitan chicharuk: “Wina yutairuka atum wainchamu arutui, auna yuattajai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Nuna takai nina unuinatairi aina nitak ininainak: “¿Chikichash yuatnurincha itariarma?” tusa tunaiyaina. ");
INSERT INTO hubNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Tusa tuinakai Jesús nitan chicharuk: “Wina yutairua nuka wina akuptuku wakeramu, tura nina takatriya ashimmauwa nuwaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Atumka chichaakrum cuatro nantu nagkamakmatai, árak juuktin jeattawai tusarum tinu ainarme. Turasha wii tajarme, shir enentaimsarum iistarma. Ju shuar ainaka Yuusa chichamen etsermaun antuk uwemrartasa wakeruinawai. ");
INSERT INTO hubNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ju shuar aina chicham ujamun yainkaru ainanka, pujut tuke atina nuna Yuus susatnaiti. Turam nisha wina yainkau asa, wijai metek shir aneas pujustinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Chikichik timau awai: Chikich arakmawai, turamtai chikich juwawai ta nuka nekas tawai. ");
INSERT INTO hubNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Atumnasha numamtuk atumka chichamka etserchau aruminig, shuar aina chicham ujaktarma tusan ishiakmajrume. Turamu asarum atumsha chikich aramunmayan juumaina numamtuk, yaunchuk Yuusa chichamen etserin ajakarua nu ujakmau aina, atumsha ujakrum Yuusain nekaspapita tumamtikiarme”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Nuna tusa yumirmatnum pujus nina unuinatairi ainan chicharuk pujai, nuwa yaaktanam wu ashi wii tuma jakmaun turutmayi, tusa etserkai nukap Samarianmaya shuar aina nuka Cristowapita tusar Jesúsan tiaru ainawai. ");
INSERT INTO hubNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Tumawar Jesús pujamunam kaunak: Jui pujusam kanaram wetá tusar emetawarmatai, nui jimara tsawan pujusaru ainawai. ");
INSERT INTO hubNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Tumamtai chikich shuar ainasha Jesúsa chichamen antukar nitasha nekaspapita tiaru ainawai. ");
INSERT INTO hubNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Tumainak nuwan chicharainak: “Yamaika ame chichamrumea nukeka nekaspapita tichattaji, isha anturka nekaspapita tuina asar, yamaika nekaaji. Juwaiti ju nugka juiya shuar aina nuna uwemtikatnuka”, tusar tiaruiti. ");
INSERT INTO hubNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Tura nui Samarianam jimara tsawan kanarar Jesúsjai jiinkiar Galileanam wearuiti. ");
INSERT INTO hubNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Jesúska chichaak: “Yuusa chichamen etserin nina nugkeen pujus etserkaigka shir anturchau ainawai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Jerusalénnum pujus takámun nitasha nu jiistanam jeawar ashi wainkaru asar, Galileanam jeaamtai nuiya shuar ainaka shir anentas jukiaru ainawai. ");
INSERT INTO hubNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ataksha Jesúsjai Galilea nugkanam, yaakat Caná tutainam yaunchuk ni entsan vino amajsauwa nui jeawaruiti. Nui yaakat Capernaúmnum apu pujau, nuna uchiri jak tepau. ");
INSERT INTO hubNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Nu apu Jesús Judeanmaya jiinki Galileanam taayi tamaun antuk, wetatmaun igkug chicharuk: “Wina jearui wemi, wina uchir pegke jan ikukij nu ai jeaam pegker amajtursata”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Tusa tama Jesús ayak: “Iwainaka takámu waintsukka nekaspapita turutmaitsurme”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Tutai Jesúsan apu ayak: “Apu, wait aneasam, wina uchir pegke jamayi, nu jatsaig jeaam pegker amajtursakia”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Tama Jesús nu apun chicharuk: “Waketkita, amina uchirmeka jakashtatui”, tusa tinaiti. Tutai Jesús tamaun nekaspapita tusa apu waketkinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Tuma wesa nina inatairi ainan winittamaun jinta igkugkuiti. Tura apurin chicharainak: “Amina uchirmeka pegker jasmayi”, tusa ujaina. ");
INSERT INTO hubNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Tusa ujam chichaak: “Etsasha uruka aiya pegker jasma”, tusa tinaiti. Tusa takai inatai ainasha aimainak: “Yau etsa teenta ai tsuweamunka michatramai”, tusar ujaina. ");
INSERT INTO hubNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Tusa ujam uchi apari Jesús etsa tumaimpapi uchirmeka jakashtatui turutmaya tu enentaimrauwaiti. Tuma nu apu nina nuwe, tura uchiri ainajaimak Jesúska nekas Cristowapita tusa nekaspapita tiaru ainawai. ");
INSERT INTO hubNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Jesús wainchatai ainan jimaraa iwainakua nunaka, Judeanam pujau Galileanam jeaa turawaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Nu tumainai, judío aina chikichik jiistan iyagkainakai Jesús nina unuinatairi ainajaimak Jerusalénnum ataksha waketkinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalén yama wayamunam, Oveja aina Waitiri tutainam tiijuch maatai entsa piaku hebreo chichamjaigka Betesda tutai amaunam, nuna yantamen cinco jea pekamu amiayi. ");
INSERT INTO hubNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Nu jeanam nukap shuar wainmachu aina, shutua shutua wekain aina, iyashi tampemaru ainajaimak, nugka tepesar entsa muchitkati tusar nakainak iruunu. ");
INSERT INTO hubNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Yuus akupkamu, nayaimpinmaya shuar ni taak nu entsa piakun umuchiakai, shuar niya iyagkuka ni jamuncha pegker ja jaakaruiti. ");
INSERT INTO hubNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Tumau asarmatai entsa muchitkamtai iyagtasa nakak chikichik shuar treintiocho uwí ja pujuwa nu tepau. ");
INSERT INTO hubNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Tuma tepettamaun wainak, nukap uwítin tumasag tepen asamtai, Jesús jeari chicharuk: “¿Pegker jastasmesha wakeramek?” tusa iniasuiti. ");
INSERT INTO hubNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Tusa tama ni ayak: “Apu, entsa muchitkamtai maatainam ejétumain atsawai. Wika weatsaig chikich ima iiyainawai, wina entsa muchitkamtai japiki ajunkamnauka atsau asamtai, wika wea weai chikich aina iiyainawai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Takai Jesús chicharuk: “Nantakim amina ainka tepetairam jukim jeemin wetá”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Nu tusa tamauwaik shuar jasha pegker jas nantaki nina ainka tepetairin juki jeen wuwaiti. Nunaka ayamtai tsawantin turawaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Tura judío apuri aina shuar pegker jasun chicharainak: “Yamaika ayamtai tsawantaiti, tuma asamtai ainka tepetairam jukimka wemaitsume”, tusar tiaruiti. ");
INSERT INTO hubNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Tutai nu shuar ja pegker jasu chichaak: “Turasha wina pegker amajtusu chichartak, ainka tepetairam jukim wetá turutma jama”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Tusa takai nita ininak: “¿Amina ainka tepetairam jukim wetá turamnusha shuarsha yaita?” tusa tiaruiti. ");
INSERT INTO hubNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Tamasha nigka shuar nukap asamtai nekachu asa, nu pegker amajtusmayi tumain nekapeachu. Tura Jesúscha yaja wu asamtai, nigka auwapi pegker amajtusmaya tusagka nekaachuiti. ");
INSERT INTO hubNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Turamu aruma nui shuar ni pegker amajsamurin, Yuus ememattasa iruuntai jeanam pujaun Jesús wainkauwaiti. Tura chicharuk: “Iisiana, yamaika pegker jasume, jamiam nu nagkamasam jata jurumakim atakka awaigkimka tunauka takasaipa”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Nu tusa tama shuar ja pegker jasusha judío apuri ainan weri chicharuk: “Wina pegker amajtusunka yamaika wainkajai, nuka Jesúsaiti”, tusa ujakuiti. ");
INSERT INTO hubNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Tusa ujakam judío apuri ainasha Jesús ayamtai tsawan aig, pegker amajkartusai tusar maawartasa eaina. ");
INSERT INTO hubNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Turasha Jesús nitan chicharuk: “Wina aparsha yamai tsawanta ju tsawantincha pegkernak iwainak takasu asamtai, wisha turusnak takajai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Nuna takai judío apuri ainaka, ayamtai tsawantinka takantsashti timaunmag pegker amajsasha, nuiyasha wika Yuusjai metek takajai, tura wina aparka Yuusaiti, tusasha tau asamtai maattsa nu senchi wakeruina. ");
INSERT INTO hubNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Nu imatruinam Jesús chichaak: “Nekas tajarme, wika Yuusa uchiri asan, wii wakeramunka takamaitsujai, ashi wina apar takámun wainaj nunak takamainaitjai, wina Apar wakeramuka nuwaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Nunaka wina apar anentu asa, eme anentas iisarti turutu asa, wainchatai ainan ju nukap iwainturmaktatrume. ");
INSERT INTO hubNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Wina aparka shuar jakauncha inanki ataksha pujutan susa apujna imanu asamtai, wisha wii wakeramurnaka pujutan suajai. ");
INSERT INTO hubNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Aparka ju uwemrati, tura juka uwemrashti tusagka shuarnaka etegkrashtinaiti, nunaka ame turata, tusa wina ashi surusuiti. ");
INSERT INTO hubNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Tura asa wina anturtin aina turutmasag amincha emematramiarti, tusa ashi winak surusuiti. Turuta asamtai wina anturtuinachuka apar wina akuptukua nunasha anturainatsui. ");
INSERT INTO hubNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Nekas tajarme, wii juna tajarum nuna nekaspapita tusa antauka, wina akuptukua nunasha nekas niimpapi akupkauwaita tauka, pujut tuke atina nuna jukiartinaiti. Tumak ni waitat juaku waitmaintrinka ikuak pujut tuke atina nuna jukiar pujusartinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Nekas tajarme junasha: Shuar yamai tsawanta jui iwáku pujuinasha wakaninka jakau ainawai, turasha Yuusa uchiriyaitaj nuna winakun untsummaunka paan antukartin ainawai. Tuma asamtai yamaiya jui winak umirtu pujuinaka tuke pujusartin ainawai. ");
INSERT INTO hubNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Wina Aparka tuke pujutnaiti, iman asa nigkisha pujutnaka chikichnasha suawai. Ni imam asa, wii nina uchiri asamtai, chikichnasha pujutan susati tusa senchirin surusuiti. ");
INSERT INTO hubNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Turusag shuarnum wii akina asamtai, ameka shuar ainasha yáki uwemmain aina nu etegkrata, tusa tu chichartukmiayi. ");
INSERT INTO hubNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Juna wii tajarum juka enentai jearchamnau enentaimtirpa. Tura shuar jina aina wii untsuam antukar, ");
INSERT INTO hubNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","aneantartata nuka, tsawan jeatnaiti. Shuar pegkeran takasu ainaka pujut tuke atina nuna jukiartasa nantartin ainawai. Antsu shuar tunaun takasu ainaka waittan jukiartasa nantartin ainawai”. ");
INSERT INTO hubNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Wika wii wakeramunka takamaitsujai. Antsu wina apar turata turutmaunak turusnak etegkartajai, wii etegkartamua nuka nekas pegkeraiti. Wii wakeramunka takastasan wakeratsjai, wina Apar akuptuku wakeramunak takajai. ");
INSERT INTO hubNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Antsu wiki pachimasan etsertumakaigka, aantar tawai turutmainaitrume. ");
INSERT INTO hubNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Turasha chikich wina pachitas shir etserturmain awai, nuka Juan imakratna nuwaiti. Nunaka wika shir nekajai, ni wina pachitas etsereak shir nekamtikrammain ainarme. ");
INSERT INTO hubNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Atum wina nekarattsarum shuar aina Juan akuptukuitrume, turam ni atum akupkamun ujakua nuka nekasaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Wika shuar wina pachitas etserturkarti tusanka wakerichuitjai, tumau aig atumsha Juan timau nekaspapita tusarum uwemramnuram tau asan tajai. ");
INSERT INTO hubNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juanka ji ekeemakam keak tsaaptin amajna numamtinak ajakuiti. Tuma asamtai ujumak tsawantaik atumsha wakerusrum Yuusa chichame nekasa nuna etserkai ni tsaaptintrigka shir ane jakuitrume. ");
INSERT INTO hubNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Juan etseru jakmauwa nu wina iwaintawai, turasha nu nagkamas wii takasmau iwaintawai. Wii takaj nunasha wina Apar turata turutmauwa nunak takajai, nu wina apar akuptukua nunaka nekamtikramrume. ");
INSERT INTO hubNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Nuiyasha wina apar, wina jui akuptukua nusha, wina pachitas shir etserturui. Antsu atumka ni chichamurigka anturchau, tura wainchau ainarme. ");
INSERT INTO hubNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Turasha atumka nekas Yuus akupkamuapita turutchau asaakrumin ni chichamea nuka atumnaka pegke atsurtamrume. ");
INSERT INTO hubNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Atumka Yuusa chichame aarmauwa nu shir kuitamsarum aujrum nuiya pujutan jukitjai tarume, turasha nu aarmauwa nuigka wina pachitas chichaawai. ");
INSERT INTO hubNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Tumaig atumka wini winirum pujut tuke atina nu jutaka nakitarme. ");
INSERT INTO hubNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Turasha wika shuar aina wina emematriarti tusanka wakeratsjai. ");
INSERT INTO hubNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Wika atum enentaimmaunka, tura Yuus aneatsrum nunasha nekajrume. ");
INSERT INTO hubNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Wina apar akuptuku asamtai juigka taawaitjai, tumau aig atumka wina nakitrarme. Wina turutayatrum antsu chikich nigki nagkami, akupeachmau winau ima shir anentsarum juinarme. ");
INSERT INTO hubNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Atumka atumek eme anennaiyakrum, Yuus atumin enentaimturma nuka pachiatsrume. ¿Aniatirmesha itursarmek wina chichamrusha nekaspapita titarme? ");
INSERT INTO hubNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Atumka nina apari ujatramak makurmattaji, tusarmeka enentaimturirpa wika makumaitsujrume. Atumin makurmatnuka Moisésaiti. Atumka Moisés chicham aarmau aujrum nuka uwemrattsarum aujrume. ");
INSERT INTO hubNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Moisés wina pachitas Yuus akupkatnaiti tusa aaruiti. Moisés aarmauwa nusha nekaspapita takurmeka, winasha nekaspapita turutmain ainarme. ");
INSERT INTO hubNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Turasha chicham umiktinan Moisés aarmauwa nu nekaspapita tachautirmesha ¿itursarmek wina chichamrusha nekaspapita titarme?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Nuna timatai nuiya juakiar Jesúsjai kucha Galilea, Tiberias tutainam amain katigkaru ainawai. ");
INSERT INTO hubNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Shuar jainan pegker amajmaun wainkaru asar, nukap shuar patakaru ainawai. ");
INSERT INTO hubNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Tuma Jesús nina unuinatairi ainan yaruak, chikichik nainnum waka nui ekeemsaru ainawai. ");
INSERT INTO hubNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Nuka judío aina jiistari Pascua tutai jeastatuk jasa ai tumawaru ainawai. ");
INSERT INTO hubNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Tuma nui eketainai shuar aina nukap wininan Jesús wainak Felipen chicharuk: “¿Shuar imanik winina au ayurmaincha yutaisha tuiya sumaktatji?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Nunaka Felipesha warituk aimkat, tusa nigka ni turumaintrinka nekayat iniasuiti. ");
INSERT INTO hubNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Nu tama Felipe ayak: “Kuit doscientos denariojai yutai sumakrisha, chiki chikichik shuar ishichik yumainkisha tinammaitsuji”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Nuna takai Jesúsa unuinatairi Andrés, Simón Pedro yachi ajakua nu aina chichaak: ");
INSERT INTO hubNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Jui chikichik uchi cinco pankan cebadajai najanamun, tura jimarchik namakjai takakui. ¿Turasha junakka iman shuar aina auka metek yumain ainatsujama?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Tusa takai Jesús nitan chicharuk: “Shuar aina nu shir pekakrum matsastaarma tusa tinaiti. Tusa takai nina unuinatairi aina chirichri nukap au asamtai nuig metek pekakaruiti. Aya aishmagkuk nekapmaram cinco mil shuar ajakuiti. ");
INSERT INTO hubNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Nuna umikarmatai Jesús pankan juki wajas Yuusan maaketi tusa tina, nina unuinatairi ainan susauwaiti, turam nu shuar ainan ashi imatiksan tinamkaruiti. Turusag namaknasha shuar ainan tinamkaruiti, turam shuar ainaka nita wakeramunka imatiksan shir yuawaru ainawai. ");
INSERT INTO hubNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ashi shuar aina shir yuawarmatai Jesús nina unuinatairi ainan chicharuk: Yutai ampintrau aina aantar utsaankarai, juuktarma”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Takai nu cinco pan puura tinamkartukmau ampintraun yaruakar doce chagkinnum aimkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Turamtai shuar ainasha, nuna wainkaru asar chichainak: “Juka nekas Yuusa chichame aarmaunam chichaak: Yuusa chichamen etserin taatnaiti ju nugka jui timauwa nuwaiti”, tusa tiaruiti. ");
INSERT INTO hubNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Nuna tuina asar, shuar ainaka Jesús nakitakaisha iruuntura juki ina apuri amajsa apujsami tusar tuinamun nekama, nina unuinatairi ainanka ikuki, nain yaki wajakmaunam imanai wakauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Kintamramtai Jesúsa unuinatairi aina nayantsanam wearuiti. ");
INSERT INTO hubNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Tumawar jeawar botenam chumpimrar Capernaúmnum katigtasar wearuiti. Tumainai káshi jasuiti, turasha Jesúska eke taachu. ");
INSERT INTO hubNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Tuma asamtai nitak wenai nase senchi nasentuk, entsan senchi tsukatmamtiku. ");
INSERT INTO hubNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Imatikamaitiat kucha ajapeen cinco tumachkusha seis kilómetros jasar wenai, Jesús entsanam wekaas botenmani wean wainkar yakit tusar ashamkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Tumainakai Jesús nitan chicharuk: “Wika Tuke pujuwa nuwaitjai, ashamrukairpa”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Takai shir aneas egkerar jukiar ishichik wesag nita jeattsa weamunam anumkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Kashi tsawainak shuar yauwa nui juaru aina Jesúsa unuinatairi aina chikichik bote tepaun jukiar nitak chumpimrar Jesúsnaka jutsuk wemaun aneararu. ");
INSERT INTO hubNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Nuna chichamru irunai, botejai Tiberiasnumia shuar aina Jesús pankan juki Yuusan aujas puur shuar ainan ayurkauwa nui tiijuch anumkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Tumawar Jesús tura nina unuinatairi ainasha nui atsuinakai, nu bote anumkamunam chumpimrar Capernaúmnum Jesúsan eakartasa wearuiti. ");
INSERT INTO hubNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Kucha amain katigkar Jesús nina unuinatairi ainajai pujuttamaun wainkar chicharainak: “Unuikartina, ¿amesha juisha urutia katigmame?” tusar tuina. ");
INSERT INTO hubNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Tusa tama Jesús nitan ayak: “Nekas tajarme, atum wina eatainarum nuka, shuar turumainchaun wii iwainakan turamaj nuka nuna nekamtikramatsampapi aitkarmajia tusarmeka nekachiatrum, wii pan tinamkartamu shir yuarum ejémaku asarum nui eatrume. ");
INSERT INTO hubNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Yutai nukap atsuk wári ashimnauwa nuka enentaimtirpa. Antsu yutai amuichau, tura pujut tuke atina nuna sukartina nu jukittsarum enentaimtitarma. Yuus wina aparua nu ame nuka turata tusa inattrau asamtai, nunaka shuarnum wii akina asan amastatjarme”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Tusa takai shuar aina chichainak: “¿Yuus wakeramu umirkattsarsha wari turumainaita? tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Tuinakai Jesús ayak: Yuuska atumnaka wii akupeaj juna nekas Yuusapi akupkauwaita tusar ninak enentaimtusarti turamrum nuwaiti ni wakeramuka”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Tutai nitasha Jesúsan chicharainak: “¿Turasha amesha wari iwainakmea ii wainka Yuus akupkamu asampapi aitkawa tumaincha takame? tusar tiaruiti. ");
INSERT INTO hubNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Yaunchuk ina uuntri matsama jakarua nusha yutai maná tutain yu jaku ainawai. Yuusa chichamencha tu aarmauwaiti: Nayaimpinmayan, yutai maná tutain akaketak Yuus ayurujakuiti tawai”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Tuinakai Jesús ayak: “Nekas tajarme, Moiséschauwaiti shuaran yutain nayaimpinmayan akaketkauka, antsu wina apar yutain nayaimpinmayan sukartak turawaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ashi shuar nugkaya ainan pujutan susatnuka, Yuus yutain akupkamu nayaimpinmaya akaiki ju nugka jui taa puja nuwaiti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Nuna takai nita chichainak: “Apu, nu yutai pujutan sukartin tame nuke tuke sukartita”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Tuinakai Jesús ayak: Yutaiya numamtinnaka, wii Tuke pujuwaitaj nuwaitjai. Shuar wina nekaspapita turutuka tsukarchatnaiti, tura kitaarchatnaiti nuka wijaig shir aneas pujustinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Turasha yaunchuk timajrum turusnak yamaisha tajarme: Atumka winaka waitiatrum nekas Yuus akupkamuapi taawaita tusarmesha nekaspapita turuttsurme. ");
INSERT INTO hubNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ashi wina apar ikanmau winigka kaunainawai, shuar wini kaunainanka jiiknaka akupkashtinaitjai. ");
INSERT INTO hubNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Wii nayaimpinmayan ju nugka jui taawaitaj, junaka wii wakeramun iwainaktasnaka taachuitjai. Antsu wika wina akuptuku wakeramun iwainaktasan taawaitjai. ");
INSERT INTO hubNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Wina akuptuku wakeramua nuka juwaiti: Ni wina shuaran surusmauwa nunaka chikichkinkisha emegkattsujai, ashi imatiksanak shir kuitamjai, tura jakamtaisha tsawan nugka mesera nagkanmaunmasha nigki inankitin atii tusa wakerawai. ");
INSERT INTO hubNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Wina apar ni akuptukua nu wakeramuka juwaiti: “Wii nina uchiriyaitaj juna ashi nekaspapita tusa winak enentaimturuka tuke pujutnaiti. Nu shuar ainanka jakarmataisha tsawan nugka mesera nagkanmaunam, wii inankitnaitjai”, tusa Jesús tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Judío ainan apuri pujut tuke atinan yutain sukartinan nayaimpinmaya taanka wii Tuke pujuwaitaj nuwaitjai, tusa Jesús timaun chichamrutan nagkamawaruiti. ");
INSERT INTO hubNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Nuna pampantainak: “Ju Jesús José uchiriya nuchaukait, nuna apari nina nukurijai ii wainnaj nuwa jama, nuna uchiriyaitiatcha ¿urukamtai nayaimpinmayan nugka taawaitjai tusasha tawa?” tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Tuinakai Jesús chichaak: Nuka atumek pampannaitsuk inaisatarma. ");
INSERT INTO hubNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Chikichik shuartirmeksha wina apar waketan suramchakaigka, winaka nemartumain ainatsrume. Antsu shuar winak enentaimturas nemartaunka nugka nagkanmaunmasha inankin uwemtikratnaitjai. ");
INSERT INTO hubNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Yuusa chichamen etseru jakaru aina aarmaunmasha chichaak: Yuus ashi unuikartitnaiti. Nu timau asamtai wina aparuiyan unuimaru aina winaka nemartuinawai. ");
INSERT INTO hubNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Wina aparun wainkaru asagsha tumainatsui, antsu Yuusnumia taawa nu, Yuusnumia winin asa, nigki Yuusnaka wainkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Nekas tajarme: “Yuusa uchirimpapita tusa wina nekaspapita turutuka, pujut tuke atina nuna jukiartin ainawai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Yutai pujutan sukartina nunaka, wii Tuke pujuwaitaj nuwaitjai. ");
INSERT INTO hubNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Yaunchuk atumin uuntri aina aya nugkanmag matsamsar yutai maná nayaimpinmaya kakean juuk yu jakarusha ashi metek jinaawaru ainawai. ");
INSERT INTO hubNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Turasha yutain nayaimpinmayan pachisan taja nuka wiyaitjai. Shuar yurumkan yumaina numamtuk, nekaspapita tusa turutainaka jakachartin ainawai. ");
INSERT INTO hubNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Yutai iwákun nayaimpinmaya taanka, wii Tuke pujuwaitaj nuwaitjai. Nu yutaiya nuna yuaka tuke pujutnaiti, wii yutain sukartittaj nuka wina iyashruketi. Ashi shuar juiya ainasha pujut tuke atina nuna jukiarti tau asan, nunaka turattajai. ");
INSERT INTO hubNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Nu tamaun judío aina antukar nitak chichainak: ¿Iturkaya nunasha nina iyashiniancha yuatarma tusasha sukartumainaita? tusar nitak tunaiyaina. ");
INSERT INTO hubNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Tuinakai Jesús nitan chicharuk: Nekas tajarme, atum shuarnum akinawa nuna iyashinia yuachkurmeka, tura wina numpar enentaimtusrum umachkurmeka pujut tuke atina nuka jukishtinaitrume. ");
INSERT INTO hubNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Shuar wina iyashrun enentaimtus yuak, tura wina numparun enentaimtus umauka pujut nagkanchau tuke atina nuna jukiartinaiti, tuma ainanka tsawan nugka mesera nagkanmaunmasha wii inankiartinaitjai. ");
INSERT INTO hubNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Yurumak nekas yutaiya nuka, wina iyashrua nuwaiti. Tumasag wina numparua nusha nekas umutaiya nuwaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Wina iyashrun enentaimtus yua, tura wina numparnasha enentaimtus umauka wini pujawai, tura wisha ninii pujajai. ");
INSERT INTO hubNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Wina apar tuke pujuwa nu winaka akuptukuiti, tura wisha wina aparui pujajai, tura wina iyashrun enentaimtus yuinasha antsag wijai tuke pujusartinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Wika nunaka nayaimpinmaya pan taawa nuna pachisan chichaajai. Nu pankan atumin uuntri yaunchuk maná tutain yuawariat jinaawaru aina tumauchauwaiti. Nuna pankan yuawaruka Yuusjai metek tuke pujusartinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jesús nuna pachis jintinkartuawa nunaka yaakat Capernaúmnum judío aina iruuntai jeanam wayaa jintinkartuawaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Tu jintinkartamun nina nemaras yujaina antukar chichainak: ¡Natsan chichaawai! ¿Yáki nunasha anturkat? tusar ishishmataina. ");
INSERT INTO hubNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Nuna tusar tuinakai Jesús nekaa chichaak: “¿Wii tajarum nuka atumnaka shir amajtamtsurmek? ");
INSERT INTO hubNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Atumsha shuarnum wii akinawaitaj juna yaunchuk puju jakmauruin yaki nayaimpinam ataksha wakan pujai waitkurmesha ¿uruk enentaimturmainaitrume? ");
INSERT INTO hubNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Yuusa Wakaniyaiti pujut nagkanchauwa nuna sukartauka, turasha iyashka aantar awai. Wakan pujutan sukartina nuka wii atumin chichaman timajrum nuwaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Tumau aigkisha atum nu nekaspapita tichamnau enentaimainatirmesha ainarme”, tusa tinaiti. Jesúska nunaka yaunchuk yama nugka najanmaunmag, au ainawapi wina umirtiartinaita, tura auwapi maawarti tusa wina surutkatnaita, tusa shir nekajakuiti. ");
INSERT INTO hubNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Nuna tusa chikichnasha chichaak: “Atumka wina nakitruina asaakrumin, wika chikichkitirmeksha wina apar wakerumtikramchakaigka, winigka tamaitsurme timajrume”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Nuna timatai nukap shuar nina nemaras yujainaka tuke tupantainak ikukiaruiti. ");
INSERT INTO hubNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Tumawarmatai Jesús nina unuinatairi doce ajakarua nuna chicharuk: “¿Atumsha wina ikurki wetasrum wakerarmek?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Nuna takai Simón Pedro ayak: “Apuru, ¿isha tuig wetaji? Ame jintinkartam nuiya Yuusjai pujustasar pujut nagkanchauwa nuka juinaji. ");
INSERT INTO hubNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ika Yuusapi nina uchirin nekas akupkauwaita tusar nekaspapita tuina asar nekaji”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Nuna takai Jesús nitan chicharuk: “Wii atumin doce shuartirmin etegkawaitjarme. Turasha atum ainarum nuiya iwanchi enentain enentaimkau chikichik pachitkawai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Nuna Jesús tina nunaka Judas Iscariote Simónkan uchiri ajakua nu, ni ayasa ewekamtaitiat suram atina nuna taku, tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Chikich tsawantin, Yuusa chichamen etseruk, Jesús Galilea nugkanmag weká. Judea nugkanmagka judío apuri aina maataj tamau asa, wechauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Judío ainan jiistari, tura yaunchuk uun aak aakmarmauri pachisa jiistamtairi tsawan jeattak jai, ");
INSERT INTO hubNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","nina yachi aina chicharainak: “Ameka juigka pujutsuk Judea nugkanam amina nemartamin aina matsata nui wetá, nitasha ame iwainamun waitmakarti. ");
INSERT INTO hubNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Shuar aina ni iwainamun chikichan iwaintuktasar wakeruinaka uukar iwainachu ainawai. Ju ame iwainam imaj iwainakmeka ashi chikich ainasha wainainamunam iwainakta”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Nina yachigsha juka nekas Yuus akupkamuapita tusar eke nekainachu asar tiaru ainawai. ");
INSERT INTO hubNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Nu tama Jesús chichaak: “Wii ai wemainka eke tsawan jeatsui. Turasha atumka atum wakeramunam wemainaitrume. ");
INSERT INTO hubNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Atumnaka ju nugkaya shuar ainaka kajertammain ainatsui, turasha wika nita tunau takainamun wainu asan, pegkerchauwaiti tamau asar, winaka kajertuinawai. ");
INSERT INTO hubNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Atumka jiistanmasha wetaarma, tumakrumnasha wina tsawantruka eke uminchau asamtai, wika winishtatjai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Nuna tusa timatai nina unuinatairi aina nijai Galileanam juakaruiti. ");
INSERT INTO hubNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Tuma juakiat nina yachi shiakarmatai, nisha jiistammaunam uumas weakai, unuinatairi ainasha nijai wearuiti. ");
INSERT INTO hubNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ii shuar aina nu jiistanam matsamsar Jesúsan wainkartasa eainak: “¿Nusha tuig pujawa?” tusar tuina. ");
INSERT INTO hubNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Nu imatu yujainai, nu shuar tuakmaunmaya ishichik shuar nina pachisar chichainak: “Nu shuarka nekas pegkeraiti”, tusa tuina. Tura chikich chichainak: “Nuka pegkerchauwayi, shuaran aantar tsanu wekainayi”, tusar tuina. ");
INSERT INTO hubNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Nuna tusar tuinaksha apuri ainan ashamaina asar, paan iwainak chichainachu. ");
INSERT INTO hubNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Jiistamtai tsawan ajapeantu ai, Jesúscha Jerusalénnum Yuus ememattasa iruuntai jeanam wayaa jintinkartau. ");
INSERT INTO hubNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Tuma nui jintinkartakai, apu ainaka wake mesersar inak: “Imanik papiin aujsachua ausha, ¿itursaya imatikasha nekawa?” tusar tuina. ");
INSERT INTO hubNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Nu tusa tuinamu asa Jesús chichaak: Wii jintinkartaj junaka winaunak jintinkartatsjai, wika wina akuptukua nunaun jintinkartajai. ");
INSERT INTO hubNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Shuar aina Yuusan umirkattsa wakeruinaka, nekas Yuusa chichamen jintintramji, nigka ninunka jintintramtsuji tusar nekamain ainawai. ");
INSERT INTO hubNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Shuar nigki emematmamsar chichainaka anturtuina eme anentriarti tusar tumainawai. Antsu shuar wina akuptukua nuna eme anentiarti tusa chichaaka waitrutsuk nigka nekasa nunak chichaawai. Wisha nui aparnak emematiarti tusan etserjai. ");
INSERT INTO hubNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","¿Yuus timauwa nuna chicham umiktinan Moisés atumin amaschaukait? Nuka atumka chikichkitirmeksha umiatsrume. Tumayatrum winaka mantuattsarum wakerutarme. ");
INSERT INTO hubNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Tusa takai shuar nui irunu chichainak: “Aminka iwanchia nu pujurtamui, ¿Ya amincha mantamataj tawa?” tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Tuinakai Jesús nitan chicharuk: “Wii ayamtai tsawan aig shuaran pegker amajsamaj nui ashi atum ainatirmeka wake mesekrum iiyarme. ");
INSERT INTO hubNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moisés atumin uchi aishmag akinkaigka ocho tsawan ejémtai kati mushuke tuke tsupirtarma tusa turamiaru asamtai, atumka ayamtai tsawan tsawaaru aigkisha turin ainarme. Moiséska nu turutnaka nagkamachuiti, antsu nina uuntri ajaku aina nu nagkamawaru ainawai. ");
INSERT INTO hubNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Nuka nekasaiti, atumka Moisés timauwa nuna inagkakij tusarum ayamtai tsawan tsawaaru aigkisha uchi aishmagka kati mushuke tsupirin ainarme. Tumau ayatrumsha, wii pegker amajkartakaisha ¿urukamtai winasha kajertarme? ¿Wii ayamtai tsawan aig, shuaran pegker amajsaj nuik aniarum? ");
INSERT INTO hubNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Atumka shuara iimi iisrum, tura pegkeran iwainakai iisrum aujmattrume. Antsu shir wainkarum aujmattarma”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Nuna tusa takai Jerusalénnum matsamin aina ujumak shuar aina chichainak: “¿Auchukait maattsa ea yujariarma nu? ");
INSERT INTO hubNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","¿Urukamtai yamaisha imanik iruuntramunam wajaki chichaakaisha achiskesha ayatkisha iiyainawa? Apu ainasha nigka nekas Cristowaiti tuina asartsuk ayatik iiyainatai. ");
INSERT INTO hubNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ika ju shuar tuiyampaita nuka shir nekaji, turasha Cristo winamurinka chikichkiksha nekarachartinaiti Cristoka taawa jama”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Nu tuinamun Jesús antuk Yuus emematku iruuntainam, senchi chichaak: “Wii Tuke pujuwaitaj nuka atumka shir nekarme. Turasha wii wakeramun takastasnaka taachuitjai, wika atumin wainchatairiya nu akupkamuitjai. ");
INSERT INTO hubNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Wika nijai pujaun juigka taa asan, tura nigki winaka akuptuku asamtai, wika ninka shir nekajai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Nuna takai achik jukiartasa wakeruina, imatikainaksha ni achinkatnurigka eke tsawan jeaachu asamtai, chikichik shuarkesha achikcharuiti. ");
INSERT INTO hubNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Nukap shuar Jesúska nekas akupkamuapi taawaita tuina asar chichainak: “¿Wainchatai ainan iwainamaincha chikitcha awak? Chikichka atsawai”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Jesúsan pachisar tu chichaamun fariseo aina antukar, sacerdote apuri ainajai nita iruunar chichasar, Yuus ememattasa iruuntai jean kuitamin ainan chicharainak: “Jesús achikrum itatarma tusar akuptukaruiti. ");
INSERT INTO hubNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Tuinakai Jesús chichaak: Wika atumjaigka ujumchik tsawan pujusan wina akuptukua nu pujamunam wetatjai. ");
INSERT INTO hubNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Atumka wina eatkatnaitrume, tumakrumsha waitkashtin ainarme, tuma asarum wii pujamunmagka winimaitsurme”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Timatai judío aina nitak ininainak: “¿Ausha tuig ii wemainchaunmasha weti? ¿Ii shuar chikich yaaktanam shiakaru aina nuimpash weti? ¿Tuma Yuusa chichamen antichu aina nuna jintintatin asampash tawa? ");
INSERT INTO hubNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Nunasha urukamtaig wii pujamunmagka winimainchau asarum, atumka wina eatkurmesha waitkashtin ainarme. Tusa turamaj nunasha ¿urukamtaig turamji?” tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Jiisat ashimnamua nu tsawan ima wake mesersa enentaimtutai tsawantin Jesús wajaki senchi chichaak: “Shuar kitamaka wini taa entsan umarti. ");
INSERT INTO hubNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Wina nekas Yuusa uchirimpapita tusa tu enentaimturainaka, Yuusa chichame aarmauwa tumasag, nina enentainka Entsa Chuchuwe pujutan sukartina nu aritnaiti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Nuna tina nunaka nina nemarainaka Wakan Pegkeran jukiartinan pachis taku tinaiti. Nu tsawantinka Jesús mantamna anean nayaimpinam weachu asamtai, Wakan Pegker eke taachu. ");
INSERT INTO hubNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Nu tamaun shuar antukar chichainak: “Juka nekas Yuusa chichamen etserin taatnaiti timauwa nu taayi”, tusa tiaruiti. ");
INSERT INTO hubNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Nuna tuinai chikich chichainak: “Atsaa nuchauwaiti, nuka nekas Cristowaiti”, tuinai, chikich chichainak: “Atsaa, ¿Cristo Galileanmaya amainkait? ");
INSERT INTO hubNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Yuusa chichame tu aarmauwaiti: Apu Davidcha Belénnum akina asamtai, ‘Cristosha David weantu asa, Belénnum akinatnaiti’. ");
INSERT INTO hubNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Shuar ainaka Jesúsan pachisar nitak kanakaruiti. ");
INSERT INTO hubNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Tumai shuar aina Jesúsan Cristochuiti tusar achik jukiartasa wakeruinaksha chikichkiksha achikcharuiti. ");
INSERT INTO hubNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Yuus ememattasa iruuntai jean kuitamainak matsataina, fariseo aina, tura sacerdote apuri aina matsatmaunam jeawarmatai chicharainak: ¿Urukamtai Jesúscha jui itaachurme?” tusa tiaruiti. ");
INSERT INTO hubNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Tusa tama nita aimainak: “Shuartika imau paanka chichashtaiyaiti, auka chichamesha shir paantaiti, tuma asamtai ikukmaji”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Tuinakai fariseo chichainak: “¿Atumka tsanuamak yujainarum? ");
INSERT INTO hubNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Urukamtai enentaimsarum iiyaatsrume, ina apurincha nuna turachkusha fariseo apuri ainancha ni umiruk iiyarum? ");
INSERT INTO hubNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Au shuar chicham umiktinan nekatsu nuka shir pegkerchauwaiti”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Tuinakai nui Nicodemo nisha fariseowaitiat Jesúsan aujsattsa káshi jearna nu chichaak: ");
INSERT INTO hubNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Ii chicham umiktin aarmau awai. Nuka nuwaiti: ‘Shuar chichaamuri anturtsukka waittaka sumaitsui, yama nagkamchakrika chichaamuri anturka, nui shir ni takamurisha nekarar turumainaiti. Nu tau asamtai nina chichame anturtsukka turumaitsuji’ ”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Tusa takai nita chichainak: “¿Amesha Galileanmayagkaitam? Papi aujsam unuimarta, nu tumam nui nekaata, chikichik shuarkesha Yuusa chichamen etsernuka Galileanmayagka amaitsui”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Nuna tusa ikuinak chiki chikichik nita jeen wearu ainawai. ");
INSERT INTO hubNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Tumawarmatai Jesús nina unuinatairi ainajaimak chikichik nainnum númi olivo tutai iruunmaunam wuwaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Tuma kashin káshikmas waketki Yuus ememattasa iruuntai jeanam Jesús jeawaiti. Tumamtai nukap shuar iruuntraruiti, tumawarmatai ekeemas jintinkartau. ");
INSERT INTO hubNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Tuma eketai chicham umiktinan unuikartin aina fariseo ainajai, chikichik nuwan shuarjai wainmakar jukiar itariaruiti. Turawar shuar iruuntramunam ajapeen awajsar, ");
INSERT INTO hubNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Jesúsan ininak: “Unuikartina, ju nuwa shuarjai wainmakar jukir jui itaaji. ");
INSERT INTO hubNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moisés chicham umiktarma timauwa nuka, nuwa juninka kayajai tuka tukakuarum maatarma, tusa tinaiti. Turasha amesha nusha ¿turumainaiti tamek?” tusar tuina. ");
INSERT INTO hubNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Nunaka warittig ni timatai nui chicham tsanumrurmi tusar nekarawartasa tiaruiti. Nu tama Jesús tsuntsumaa uwejejai nugkanam aak pujau. ");
INSERT INTO hubNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Tumakaisha nu senchi inina, imatram Jesús pagkai chichaak: “Yaita atum ainarum nui ishichkisha tunaurinchau nu yama nagkamchak nuwan kayajai tukuti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Nuna tina ataksha tsuntsumaa nugkanam aak pujau. ");
INSERT INTO hubNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Nuna timatai nitasha tunaurintin asar, jinar ashi shimuinak Jesúsan nuwajaig ikukiaruiti. ");
INSERT INTO hubNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Tumawarmatai Jesús wajaki iimkama shuar atsuinakai nuwan chicharuk: “Nuwa, ¿amina shuar itarmawarma nusha urukawarma? ¿Chikichkiksha tukurmacharaik?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Tusa tama nuwa ayak: “Apu, chikichkiksha tukurcharai”, tusa tinaiti. Tusa takai Jesús chicharuk: “Wisha aminka waittanka amaschattajai, jeemin wetá, turasha yamai nagkamsamka chikich shuarjaigka tsanirmawaipa”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Shuar aina ataksha iruuntramtai, Jesús chicharuk: “Shuar nekaawarti tusan ju nugka jui tsaaptin taanka, wii Tuke pujuwaitaj nuwaitjai. Tuma asamtai wina nemartauka káshinmaka pujuschartinaiti, antsu pujut tuke atina nuna jukiar Yuusjaig tsaaptinnumak pujusartinaiti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Nuna takai fariseo aina chichainak: “Ameka amina imantrumek pachisam chicham nuka nekaschauwaiti”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Tuinakai Jesús ayak: “Wiki pachimasan takaisha, wii taja nuka aantrachuiti. Wii tuiyana jui taawaitja nunaka wika nekajai. Tuma asan wii tui wetatja nunasha shir nekajai, tumaig atumka wii tuiyana taawaitja nusha, tura wii tui wetatja nujai pegkesha nekatsrume. ");
INSERT INTO hubNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Atumka ju nugkaya shuar aina shuaran aujmatin aina tumasrumek shuarka aujmattrume, tumakrumnasha wika chikichik shuarnaksha auka tumauwaiti tusanka aujmattsujai. ");
INSERT INTO hubNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Wiki etegkeaknasha nekasa turusnak etegmainaitjai. Turasha wiki etegtsuk wina Apar akuptukua nujaig jimarkan nunaka turajai. ");
INSERT INTO hubNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Atum chicham umiktin timau papiinum aarmau awai: Shuar jimar mai nunak pachis etserainakai, nui nekaspapita takurmesha titarma tusa timau. ");
INSERT INTO hubNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Wii Tuke pujuwaitaj nunaka, chicham nekasa nunapi etserja tajai. Tura wina Apar akuptukua nusha aitkasag chicham nekasa nunak etserui turutui”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Nuna takai nita chichainak: “¿Ame apasha tui pujawa?” tusar iniasaruiti. Tusa tuinakai Jesús nitan ayak: “Atumka winaksha nekartsurme, tuma asarum wina aparsha nekamaitsurme. Atum winasha nekarkurmeka wina aparsha nekamain ainarme”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Nunaka Jesúska Yuus ememattasa iruuntai jeanam Yuusnau atii tusa suaku chumpitaisha nuig amaunam jintinkartak pujus tinaiti. Ni achinkatnurigka eke tsawanka jeaachu asamtai, chikichik shuarkesha achikcharuiti. ");
INSERT INTO hubNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jesús ataksha chichaak: “Wika wetatjai, tumamtai atum wina eatkatin ainarme. Tumakrumsha atumka wii weamunmagka winimaitsurme, atumka wina nekaspapita turutchau asarum atumi tunaurinig jakatin ainarme”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Nuna takai judío apuri aina chichainak: “¿Atumka wii weamunmagka winimaitsurme turamaj nunasha, nigki maamatin asampash tawa?” tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Nuna tusa tuinakai Jesús nitan ayak: “Atumka ju nugka juiya shuar ainarme, turasha wii Tuke pujuwaitaj nunaka ju nugka juiya shuarchauwaitjai. ");
INSERT INTO hubNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Tuma asan atumka nekas Tuke pujuwa nuwapita turutchakrumka, atumi tunaurinig jakatnaitrume tusan tajarme”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Nuna takai nita ininak: “¿Turasha amesha nekascha yaitme?” tusa tuina. Tusa tama Jesús nitan ayak: “Wika nunaka atumnaka yama nagkamchakun ujakmajrume. ");
INSERT INTO hubNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Atumnau pachisa tumainka nukap arutui, tura wina akuptukua nusha nekasa nunak chichaawai, wii ju nugka juiya ainatirmin tajarum nunasha wika ni chichaamun antukmaurun tajarme. ");
INSERT INTO hubNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Nuna tusa nina Aparin Yuusan pachis chichaakaisha, judío ainaka nunapi taku tawa tusarka nekacharuiti. ");
INSERT INTO hubNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Tumaina asarmatai, Jesús nitan chicharuk: Atumka shuarnum wii akinawaitaj nuka yaki numinam achiirarum netusrum, juka nekas Tuke pujuwa nuwaiti tusarum nekaratnaitrume. Wika winaunak pachisnaka tatsujrume, antsu wina Apar jintintruawa nuna atumnasha tajarme. ");
INSERT INTO hubNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Wina Apar akuptukua nuka wijai tuke pujawai, wika ashi ni wakeramua nunak tuke taká asamtai, winaka inaitatsui. ");
INSERT INTO hubNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Nuna takai nukap shuar aina Jesúsan nekaspapita tiaruiti”. ");
INSERT INTO hubNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Nina nekaspapita tuinan Jesús chicharuk: “Atum wii tajarum nuke antukrum metek umiakrumka nekas wina nemartin amainaitrume. ");
INSERT INTO hubNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Tumakrum chicham nekasa nusha nekamainaitrume, tura chicham nekasa nu agkanmamtikramatin ainarme”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Nu tama nita aimainak: “Ika Abrahaman uchiri weantu ainaji, tumau asar chikichkitiksha chikich aina inaku waitkataigka ainatsji. Tumau ainarincha, ¿amesha urukakmea agkanmamainaitrume tukartame?” tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Tuinakai Jesús nitan ayak: “Nekas tajarme, shuar tunaun takaina nuka tunauwa nu waitkatai ainawai. ");
INSERT INTO hubNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Inataigka nina uchirinchu asa, inamnun jeenka tuke pujuchuiti. Antsu inamnun uchiriya nu nina uchiri asa, jeagka tuke pujuwaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Tuma asamtai atumin Yuusa uchiri agkanmamtikramkaigka, tunau takat inaisau asarum, shir agkanmakatin ainarme. ");
INSERT INTO hubNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Atum Abraham weantuitrum nunaka nekajrume, tumauwaitiatrumsha ¿urukamtai wii chichaakaisha nekaspapita turuttsuksha mantuattsarmesha wakerarme? ");
INSERT INTO hubNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Wina Apar jintintramunak wika chichaajai, atumsha tumasrumek atumin apari timauka umirin ainarme”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Nuna takai nita aimainak: “Ina uuntrigka nekas Abrahamaiti, chikichka atsawai”, tusa tuina. Tuinakai Jesús chichaak: “Atum Abraham ajakua nuna uchiri ainakrumka, ni Yuusa umiru jakua turusrumek umirmain ainarme. ");
INSERT INTO hubNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Wina Apar jintintruamun turusnak jintinmasha winaka ayatik mantuattsarum wakerutarme. Abrahamka, atum aniarum aunka pegke ainkachuiti, nigka Yuusa chichamea nuna anturkattsa wakeru jakuiti. ");
INSERT INTO hubNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Atumka atumi aparijai metek takarme”, tama nita chichainak: “Ika antrar akinaka ainatsji. Ina apariya nuka chikichik Yuusa nuwaiti”, tusar tuina. ");
INSERT INTO hubNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Tuinakai Jesús nitan ayak: “Atumi apari nekas Yuusaitkaigka winasha anenmain ainarme, wii wakeraknaka juigka taachmajai, antsu wina apar akuptakai taan jui yamai pujajai. ");
INSERT INTO hubNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Atum wii chichaamusha nekamain nekapeatsrum nuka wina chichamruka anturtut nakitaina asarum aniarme. ");
INSERT INTO hubNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Atumi apariya nuka iwanchia nuwaiti. Atumka ninu asarum, ni takamua turusrumek takastasrum wakerarme. Iwanchia nuka yama nagkamchatinig magkartutan nagkamawaiti, tura nekasa nunaka nakitak waitruta nuna shir waitrin jasuiti. Nigka waita nuna apari asa, nu ima shir amajeamu asa, waitrutan pujurnaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Atumka iwanchnau asarum, wii nekasa nuna etserkaisha nekaspapita turuttsurme. ");
INSERT INTO hubNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Atum ainatirmincha wii tunau takasmaurnasha ya nekamtikramainaitrume? ¿Urukamtai chicham nekasa nuna etserkaisha nekaspapita turuttsurme? ");
INSERT INTO hubNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Yuusa uchiri ainaka Yuusa chichamen anturin ainawai. Turasha atumka Yuusa uchirinchu asarum nina chichame antutka nakitarme”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Nuna tusa takai judío aina Jesúsan chicharainak: “Ameka Samarianmaya shuar asam, iwanch egkemturmarmatai tu wekame timajam nuka jui timajme, nuka nekasaiti”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Tusa tama Jesús nitan ayak: “Chikichik iwanchkisha winaka atsurtawai. Wii takaj junaka Aparun emematkun aitkajai, turaig atumka winaka eme anentrusrum iirtsurme. ");
INSERT INTO hubNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Wika emematriarti tusanka wakeratsjai, tumaig Yuus chikich ainasha emematiarti turutu asa, nigki nunaka eak wina emematrumainnaka iwainawai. ");
INSERT INTO hubNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Nekas tajarme, shuar wii taja nuna nekaspapita tauka arumaisha jakashtinnum tuke pujustinaiti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Nuna takai nuiyasha judío aina chichainak: “Yamaika amina iwanch pujurtama nuka shir nekaaji. Abrahamsha tura Yuusa chichamen etserin chikich ajakaru aina nujai jinaawaru ainawai. Tumawaru aig ame yamai chichaakum: ‘Wii taja nuna nekaspapi tauka arumaisha jakashtinnum tuke pujustinaiti tau asaakmin nekaaji’. ");
INSERT INTO hubNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Ameka nekas ina uuntri Abrahama nu nagkasau asamek nusha tame? Abrahamsha, tura Yuusa chichamen etserin chikich ainasha ashi jinaawarua tumaisha ¿amesha uruku asamea nusha tame?” tusar tuina. ");
INSERT INTO hubNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Tusa tuinakai Jesús nitan ayak: “Wiki emematmamkun winaunak pachisa chichaamuka pegke aantar amainaiti. Turasha nunaka tumatsjai. Antsu wina Apar, atum chichaakrum ina Yuusri tusarum tarum nu winaka emematrawai. ");
INSERT INTO hubNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Atum ainatirmeka nigka wainchauwaitrume. Turasha wika wainjai, wainchauwajai takunka atum wait ainarum nunin asan tumainaitjai. Wika shir wainu asan, ni turutmauncha metek umirjai. ");
INSERT INTO hubNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Atumin uuntri Abraham yaunchuk puju jakua nuka wii taakai waitkattsa senchi wakeru pujau asa, wina waitak shir aneasuiti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Nuna takai judío apuri aina Jesúsan chicharainak: “¿Ame cincuenta uwíksha pujachiatmesha urukamtai Abrahaman wainkamiajai tame?” tusar tuina. ");
INSERT INTO hubNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Tusa tama Jesús nitan ayak: “Wika Abrahamsha akiintsaig tuke puju jakuitjai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Nuna tusa takai shuar aina kayajai tukuttsa wakeruina. Nu turam Jesúska Yuus ememattasa iruuntai jeanmaya uumak jiinki weak nitan ikuknaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Nuiya Jesús jinki chikich tsawantai wekama shuar tuke wainmachuk akinan wainkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Nuna wainkar nina unuinatairi aina Jesúsan ininak: “Unuikartina, ¿urukakua jusha wainmachusha akinawaita? ¿Nina apari tunauriniash ankauwait? ¿Nuna tumachkusha nina tunauriniash ankauwait?” tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Nu tusa tama Jesús chichaak: “Juka nina tunaurinkisha ainkachuiti, tura apari tunaurinkisha ainkachuiti, ju junin akinawa juka, ju pegker amajeamunam Yuusa senchiriya nu iwainaktin asamtai ankauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Eke tsawan a juik wina akuptuku turata turutmauwa nunaka turattajai, káshi jasmataigka chikichik shuarkesha takachu ainawai. ");
INSERT INTO hubNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Yamai nugka pujaj juikka wiyaitjai nugkan Tsaaptintrinka. Tumau asan shuar ainan chicham nekas Yuusnumiaya nuna nekamtikjai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Nuna tusa Jesús nugkanam usukmawaiti, tuma nina usukijai nugkan uchupar juki, wainmachun jinum anujtukuiti. ");
INSERT INTO hubNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Tura chicharuk: “Entsa piaku Siloé tutaiya ai weme nijaamarta”, tusa tinaiti. Tusa tama we nijaamar paan iimi waketkinaiti. (Siloé ta nunaka Yuus akupkamu taku tawai.) ");
INSERT INTO hubNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Tuma jeamtai shuar nu wainmachu pujamunam tiiju matsamas tuke wainin asar chichainak: “¿Jinta ekeemas kuit surustarma tusa seama ekemna nu juchaukait?” tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Nuna tuinakai chikich shuar chichainak: “Ee, nuwaiti”, tusa tuinai chikich chichainak: “Nuchauwaiti, auka ayatik nujai metekmamtinaiti”, tusa tuina. Tuinakai nu shuar pegker jasu nigki etsertumak: “Wika Tuke pujuwaitjai”, tusa tumamnaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Nuna tusa nita chichainak: “¿Turasha uruksamea ima shirsha iimmame?” tusar tuina. ");
INSERT INTO hubNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Tusa tama ni etseruk: “Shuar Jesús naartina nu, nina usukijai nugkan ishichik pachimar, jiirui anujturak chichartak: ‘Au entsa piaku Siloé tutaiya ai weme nijaamarta’, tusa akuptukmayi. Turutmatai wena nijaamaran paan iimmajai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Nuna takai chichainak: “¿Nu shuarsha tui pujawa?” tama ni ayak: “Nekatsjai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Nu shuar yaunchukka wainmachu ajakun jukiar apu matsatainamunam ejéniaruiti. ");
INSERT INTO hubNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Jesús shuar wainmachun usukijai nugkan uchupar jinum anujtuk pegker amajsauwa nunaka ayamtai tsawantin turawaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Tura asamtai fariseo aina nuna shuaran chicharainak: “¿Yaunchukka wainmachu ayam nusha yamaisha itursamea iimme?” tusar inina. Tama ni aimuk: “Winaka Jesús usukijai nugkan uchupar jiirui anujturak entsa nijaamarta turutmatai, entsan nijaamaran paan iimmajai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Tusa etserkai ujumak fariseo aina chichainak: “Nu shuar turutma nuka Yuus akupkamuka amaitsui, nekas Yuus akupkamuitkugka ayamtai tsawantinka nutikmaitsui”, tusa tuina. Tuinai chikich chichainak: “Nu shuar tunaurinnaitkugka, wainchatain iwainak taká junaka jutikmaitsui, tusa tunaiyaina”. Nuna tuina asar kanakaru. ");
INSERT INTO hubNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Tumawar wakettrusag wainmachu pegker jasun jeariar chicharainak: “¿Amesha shuar amina pegker amajtamsausha yaiti tame?” tusa tuina. Tusa tama ni chichaak: “Wika Yuusa chichamen etserna nuwaiti tajai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Nuna takaisha apu ainaka ju wainmachua nuwapi paan iimnia tumain nekapenachu asar, wainmachu aparin nukurijai untsukaruiti. ");
INSERT INTO hubNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Turawar taawarmatai nitan ininak: “¿Atumi uchirin wainmachu akina pujuwayi tuina nu jukait? ¿Turasha yamaisha itursaya wainmausha jasia?” tusar tuina. ");
INSERT INTO hubNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Tuinakai nuna apari chichaak: “Wina uchir, wainmachu akinawa nuka juwaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Tuma asamtai tajai, antsu yáki nekascha iimtikin nunaka nekartsujai. Atum nekaattsarum wakerakrumka ni iniastarma. Nigka uchichichuiti, ni urukaya paan iimni nunaka ujatmamainaitrume”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Nu apari tina nunaka judío apuri ainan ashamak tinaiti. Jesús Cristowa nu pegker amajsayi tuinaka iruuntai jeanmaya jiikir akupkatai, tusar judío apuri aina chichaman umikaru asarmatai, nuna turutawarai tusa tu chichakuiti. ");
INSERT INTO hubNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Tuma asa wainmachu aparisha chichaak: “Nigki iniastarma, nigka uchichichuiti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Apari timatai fariseo aina wainmachu ajakun untsukar itantar ininak: “Yuusa emtin tajame, waitrutsuk nekasa nuke etserkata: Ii iismaka shuar amina pegker amajtamsa nuka tunaurtinaiti”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Tuinakai ni chichaak: “Wika yaunchukka wainmachu ajakuitiatan yamai paan imaj junak nekajai. Antsu nisha tunaurtinashit nunaka nekartsujai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Nuna takai ataksha ininak: “¿Iimtikramtatkusha iturtamkama?” tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Tusa tama nitan ayak: “¿Urukamtai pegker amajtusmayi tusa etserkaisha, nekaspapi tawa turutchayatrumsha, ataksha nunak awaigki etserkati tusarmesha wakerarme? ¿Atumsha ni nemarkattsarum wakera asarmek tarum?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Nuna tusa takai pegkerchau chicharainak: “Ameka nu shuar umirme, turasha ika Moisés ajakua nuke umirji. ");
INSERT INTO hubNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Moisésan Yuus auju jakua nuka nekaji, turasha nu shuar amina pegker amajtamsa nuka ishichkisha nekantsui, nusha tuiyagkit tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Nuna tusa tuinakai ni aimuk: Atum wii wainmachu wekainun paan iimtikrimtai wainmaj jusha waitiatrum, tuiyantskait tarum nuka enentai jearmain tatsurme. ");
INSERT INTO hubNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Yuuska shuar tunaurintin aina wakeramunka anturtsui, antsu nina emematainak ni wakeramun umina nuna anturui. ");
INSERT INTO hubNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Atumka, shuar wainmachu akinan pegker amajmainka pegke atsawai tamauka antukchauk ainarum. ");
INSERT INTO hubNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Shuar wina pegker amajtusa nu, Yuus akupkam taachuitkugka aunka pegkesha aitkamaitsui”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Nuna tusa takai nita chichainak: “Ame yama akinmauwaik nagkamsam tunau ajakuitiatmek ¿ina jintintramattsam wakeram?” tusa tuina. Nuna tusar iruuntainmaya jiikiar aa akupkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Nu tura aa jiikir akupkamun Jesús nekaawaiti, tura wainak chicharuk: “¿Amesha shuarnum akinawa nusha nekas Yuusa uchirimpapita tamek?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Tusa tama nu shuar chichaak: “¿Apu nusha yaita? wisha nuna wainkan nunak enentaimtitjai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Takai Jesús ayak: “Ameka nuka wainkamame, wii amijai chichaaj nuwaitjai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Nuna takai nu shuarsha tikishmatar Jesúsan chicharuk: “Apu yamaika ame tame nunaka nekaspapita tajame”, tusa emematnaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Nuna takai Jesús chicharuk: “Wika shuar ainan enentaimmaun ashi nekau asan etegkan akantrattsan, tura wainmachu ainasha ashi paan iimiarti, tumainai shuar wainmau aina wainmachua numamtuk jasarti, tusan ju nugka juigka taawaitjai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Nuna tusa takai fariseo shuar aina irunu chichainak: “Ika wainmachuka ainatsji ika nekasa nusha nekainaji”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Tusa tuinakai Jesús nitan chicharuk: “Atum wainmachu ainakrumka, atumin tunaurisha tsagkuram amainaitrume. Turasha atum wainmau ainaji tarum nui nekas makumatin ainarme”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Nuna tina Jesús chichaak: “Nekas tajarme, shuar ovejan wenuken waitirini waitsuk yaja chikich yantamnum waya nuka kasa tumauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Antsu shuar ovejan kuitamna nuka, oveja wenuke waitirini wainaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Tura waitin kuitamnuka nigka waitinak kuitamin asa, ovejartin winakai waitin urati inainaiti, turam ovejasha nina chichamen shir anturin asar ashi tuarnaiti. Tumamtai jiyaaksha chiki chikichik nina naarin anai anaitus jinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Nuna tura ashi ninunka aa jiir juki ni emtuk ovejan ukunam yaruas wekainaiti. Ovejasha nuna chichamenka shir anturu asa nemarnaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ovejaka nina wainchatairinka chichamenkesha shir nekarchayatka nemarchauwaiti, ayatik pisarar yaja shiminaiti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesús fariseo ainan nuna pachis jintintawaiti, turamsha nitaka nuna takumpapi turamjia tusarka nekacharuiti. ");
INSERT INTO hubNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Tumainakai Jesús ataksha ujak: “Nekas tajarme, ovejan wenuken waitiriya numamtinnaka, wii Tuke pujuwaitaj nuwaitjai. ");
INSERT INTO hubNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Wika taatsaig tsanukratin aina winiarmiayi, nuka ovejan kasamna numamtin armiayi. Antsu Yuusa uchiri ainaka oveja numamtin asar, Yuus akupkachmau asarmatai nita chichamenka anturkacharuiti. ");
INSERT INTO hubNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Wiyaitjai ovejan wenuken waitiriya numamtinnaka, oveja waitinam waina numamtuk wina chichamrun nekaspapita tuinaka uwemrartin ainawai. Oveja wenuken utsaanawar, tura jiintrar chirichirin yuwa numamtuk jartinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Kasaka kasamak kajegkar emegkartasa wininawai, turasha wika turattsanka taachuitjai. Pujuta nuna jukiar ashi shir atsumtsuk matsamsarti tusan taawaitjai. ");
INSERT INTO hubNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ovejan shir kuitamnunka wii Tuke pujuwaitaj nuwaitjai. Wina ovejarun shir kuitamin asan, wika oveja uwemkarti tusan mantamnattajai. ");
INSERT INTO hubNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Antsu shuar kuitamrutata tusa akika ikukmau ainaka uun yawa ovejan winitkaisha, ovejanka ninuchu asarmatai, tsekeak ikukmatai, uun yawa yuak ipisar ishimnaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Nu shuar tsekea nuka, nina tagkurinchu asamtai, antsu akiam takau asa tumauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Ovejan shir kuitamnunka wii Tuke pujuwaitaj nuwaitjai, tura wika wina ovejar ainanka nekajai, tura nitasha antsag winaka nekarainawai. ");
INSERT INTO hubNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Turusag wina aparsha winaka nekarui, tura wisha wina aparnaka nekajai, wika nui mantamnattajai. ");
INSERT INTO hubNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Tura chikich oveja aina wenuknum pujachusha arutui, nunasha jukin nu wenuknumag chumpiatnaitjai, turawaram iruuntrar wina chichamrunak umirtuinakai, wiki nitanka kuitamtinaitjai”. ");
INSERT INTO hubNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Wika wina ovejarun ayamrakun mantamnan ataksha nantaktin asamtai, wina aparka anentui. ");
INSERT INTO hubNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Winaka nitak enentaimsarka mantumain ainatsui. Wika wiki surumankattajai. Wiki surumankan jakan ataksha wiki nantaktatjai. Wina apar tu chichartuku asamtai, wii tumamain arutui”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Judío apuri aina Jesús tusa chichaamun antukar nitak jianaina. ");
INSERT INTO hubNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Nukap shuar chichainak: “¿Urukamtai chichamesha anturearme? Aunka iwanch egkemtawai turam netsemawai”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Tura chikich aina chichainak: “Chikichik shuarkesha iwanch egkemtuamuka juna imatiksagka chichamaitsui. ¿Itursaya iwanch egkemtuamusha shuar wainmachuncha paan iimtikmainaita?” tusar tuina. ");
INSERT INTO hubNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Yuus ememattasa iruuntai jea jeamkamu tsawan jeau asamtai, tsetsek tepea ai Jerusalénnum jiistamaina. ");
INSERT INTO hubNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jesús nui wayaa Salomón waiti urarmaunmani weká. ");
INSERT INTO hubNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Tumattamaun judío apuri aina iruuntur tentea awajsar ininak: “¿Urutia shirsha etserkattame? Ame nekas Cristowaitkumka yamai shir etserkata”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Tuinakai Jesús nitan ayak: “Wika yaunchuk atumnaka timajrume. Turasha atum wii nuna etserkaisha nekaspapita turuttsurme. Wina Apar turata tusa inatramunka wika paan atumnasha iwaintajrume. ");
INSERT INTO hubNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Turasha atumka nu wainkurmesha wina ovejarchau asarum yaunchuk timajrum tumasrumek nekaspapita turuttsurme. ");
INSERT INTO hubNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Wina ovejar ainaka wina chichamruncha shir anturtuina asar nemartuinawai. Tumaina asarmatai nitanka wisha shir nekainajai. ");
INSERT INTO hubNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Wii nitanka pujut nagkanchau arumaisha tuke atina nuna suajai, turamu asar, nitaka pegke waittsashtin ainawai. Wini matsatunka chikichkiksha atantrukchartin ainawai. ");
INSERT INTO hubNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Wina Apar ashi chikich ainancha nagkasauwa nu winaka kuitamkata tusa surusuiti, ni takakmaurinka chikichkiksha atanmain ainatsui. ");
INSERT INTO hubNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Wii wina aparjai atukanka chikichkitjai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Nuna takai judío apuri aina ataksha kayan jurukiar tukuttsa wakeruina. ");
INSERT INTO hubNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Nu turuinam Jesús chichaak: “Wika nukap pegker ainan wina aparu senchirijai atumin iwaintukmajrume. Turamaitiatrumsha ¿wari pegkerchau iwainakmaunma winasha kayajaisha tukurtasrumsha wakerutarme?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Nuna takai judío apuri aimainak: “Ika ame pegker iwainaram takasum nujaigka kajerakur kayajaigka tukumaitsujme, ameka Yuusa imanuk chicharmamu asam kayajaigka tukuntatme. Ameka nekas shuaraitiatam Yuusa imanuka chicharmammaitsume”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Nuna tuinakai Jesús chichaak: “Atum chicham umiktin aarmauwa nui Yuus atumin chichartamuk: ‘Atumetrume Yuus ainatirmeka’ timau awai. ");
INSERT INTO hubNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Yuusa chichamen aarmau inaimaitsuj nuka shir nekainaji. Yuus nina chichamen shuar antuinan chicharuk: ‘Atumetrume yuus ainatirmeka tinaiti’, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Wina Yuus akantuk ju nugka jui akuptukmatai taa asan wika Yuusa uchiriyaitjai takaisha ¿uruk enentaimsarmea Yuus pegkerchau chicharkum nijai metek jame tusarmesha turutrume? ");
INSERT INTO hubNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Wina apar taká turusnak iwainakan wii takatsaigkika nekaspapita turutirpa. ");
INSERT INTO hubNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Wina nekaspapita turutchamnau nekapeakrumsha, wina Apar takasta turutmauwa nuna iwainakan takakai nekaspapita turuttarma. Tumakrum apar winai pujai, wii nijai pujaj nusha nekaarum nekaspapita timintrum”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Nuna takai ataksha achikar jukiartasa wakeruina, imatikainam Jesús ataksha jiinki wuwaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Tuma Jesús waketki entsa Jordán amain Juan yaunchuk imakratu jakmaunam jeaa pujusuiti. ");
INSERT INTO hubNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Nui pujaun nukap shuar winitaina Jesús iwainara takámu wainainak: “Juan ii wainchatain jutika chikichkinkisha iwainachkusha, ju shuaran pachis chichaya nuka nekasaiti”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Nuna tuina asar nui matsatainaka Jesús chichaakai, nukap shuar nekaspapita tusar anturkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Yaakat Betanianam shuar Lázaro naartin, María tura Marta umai jak tepau, nu yaakat Betaniaka María tura Marta yaaktari ajakuiti. ");
INSERT INTO hubNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Nu Maríaka Lázaro umai, nuka Jesúsan perfumejai nawenam ukatar nina wiichijai ujujturua nuwaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Nu umaintin aina Jesúsan chichaman akuptuinak: “Apu, ame amikrum anetairmia nu senchi jawai”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Nu tusa timaun Jesús antuk chichaak: “Nu ja nuka nagkamas jaka megkakattak aniatsui. Antsu Yuusan senchirin tura wii Yuusa uchiriyaitaj nunasha wina senchirun iwainaktin asamtai aniawai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesús Martan kaijai, tura Lázaroncha ane jakuiti. ");
INSERT INTO hubNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Imatika anenaitiat Lázaro jawai tamaun antuksha wetsuk, ni pujamunmag jimaraa kanaruiti. ");
INSERT INTO hubNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Nuna tuma nui nina unuinatairi ainan chicharuk: “Judea nugkanam ataksha waketkimi”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Nuna takai nina unuinatairi aina chichainak: “Unuikartina judío ainan apuri kayajai tuku mantamawartasa eatmarma tumaigkik ai ataksha wemii tusamsha tame”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Nu tusa tama Jesús nitan chicharuk: “¿Chikichik tsawanta nui doce hora asa etsa akaichauka? Shuar tsawai wekaka, tsaaptinnum iimas weká asa tukumrumamaitsui. ");
INSERT INTO hubNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Antsu káshinam weká, tsaaptinnum iimas wekachu asa, tukumrumamainaiti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Nuna tusa inagnak, nuiyasha chikichan chichaak: “Ina amikri Lázaro yamaika kanak tepawai, turasha wii werin ishintartatjai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Nuna takai nina unuinatairi aina chichainak: “Apu nekas kanaruitkugka shintartatui”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jesúska nunaka Lázaro jakaun tinaiti, turasha nitaka nekas kanar tepauntsuk tatai tu enentaimraruiti. ");
INSERT INTO hubNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Pegkesha nekainachkai Jesús paan iwainak chichaak: “Lázaroka shir jatan jakayi. ");
INSERT INTO hubNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Atum aig juakchaurum nui wika shir aneajai, nekaspapita titin asaakrumin, turasha weri iisarmi”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Nuna takai Tomás, Jimamramu tutai ajakua nu, Cristo unuinatairi ainan chicharuk: “Isha nijaig wearmi, mainaksha iijaimak mantamawarti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Lázaro jakamtai ikusam cuatro tsawan tsawara ai Jesús yaakat Betanianam jeawaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betanianmaya juaki Jerusalénnum jeatnuka tres kilómetros ajakuiti. ");
INSERT INTO hubNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Marta Maríajai umai jakamtai útainak, senchi wake mesemar matsatainakai, enentain ichichtuinak judío aina nukap ishiintukaruiti. ");
INSERT INTO hubNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Nu tumainai Jesús taattak winawai tamaun antuk, Marta Jesúsan igkugtasa jinai Maríaka jeag juaku. ");
INSERT INTO hubNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Tuma Marta Jesúsan igkug chichaak: “Apu, ame jui pujakminka wina umaaruka jamainchau ayat jakayi. ");
INSERT INTO hubNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Turasha wika, ame Yuus aujmaka imatiksag anturtamaina nunaka nekajai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Nu tusa tama Jesús ayak: “Ame umaimika aneantatui”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Tama Marta chichaak: “Nekas tame, tsawan nugka mesera nagkanmau atina nui aneantina nunaka wika nekajai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Nuna takai Jesús chicharuk: “Wika Tuke pujuwaitjai, jakauncha inannaitjai, tura wikitjai pujutnasha sukartinnaka, shuar wina nekaspapita turutainaka jakasha ataksha nantakiartin ainawai, tuma tuke pujusartin ainawai. ");
INSERT INTO hubNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Tura yamai iwáku matsataina nusha wina nekas Yuusa uchirimpapita tusar winak enentaimturainaka waitat nagkanchau atina nuigka wechartin ainawai. ¿Nusha amesha nekaspapita tamek?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Tusa tama ni ayak: “Ee apu, wika ame tame nunaka nekaspapita tajai. Ameka Cristowaitme, Yuusa uchiri ju nugka jui taatna nuwaitme”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Nuna tina ikuak kai Marían untsuk ninak akanki chicharuk: “Unuikartin aranta ai pujus untsurmawai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Nu tusa tamauwaik Maríasha wári wajakug Jesúsan wainkattsa wuwaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesúska eke yaaktanmagka jeatsuk, Marta igkugmaunmag pujau. ");
INSERT INTO hubNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","María wárimas jiinki weakai, judío aina María enentain ichichtak kaunak matsamtausha umai ikusmaunam pujus útuttsa weatsuash tusar patatukaru. ");
INSERT INTO hubNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Tuma María Jesús pujamunam jeawaiti. Tuma Jesúsan wainak tikishmatar pujus chicharuk: “Apu, ame jui pujakminka wina umaaruka jamainchau ayat jakayi”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Nuna tusa María útkai, tura shuar aina nuna patatukar kaunkausha útainakai, nuna wainak Jesús senchi wake mesemar nekaprauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Nuna tuma chichaak: “¿Tui ikusmarme?” tusa tinaiti. Tusa takai nita chichainak: “Apu, jui ikusmaji tantam iista”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Tusa tama iistasa werinaiti, tuma ikusmaunam jeawaiti. Tuma wainak Jesús útnaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Nuna tuman judío aina wainkar chichainak: “Iisuana yait ane jakuaja”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Nuna tusar tuinakaisha chikich chichainak: “Ju wainmachuncha paan iimtikna imausha, ni pujaksha Lázaroncha iturkatnuki, ni pujakaisha jakampash”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jesús ataksha senchi wake mesemar nekaprau, tuma wa uun taimunam egkea kaya apujtuamun jearnaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Nu kaya apujtuamun wainak Jesús chichaak: “Kaya jurustaarma”, tusa tinaiti. Takai Marta shuar jakauwa nuna umai chichaak: “Apu, mejeawastai, ikusam cuatro tsawan kanarai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Nuna takai Jesús chicharuk: “¿Ame nekaspapi turumainaita takumka Yuusa senchiri iwainamu wainkattame tichamkajam? ¿Nunaka nekaspapi turumainaita tatsumek?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Timatai kayan jurusaruiti. Turawarmatai Jesús nayaimpin pagkai iis chichaak: “Apaachi, ame anturtau asaakmin, maaketi tajame. ");
INSERT INTO hubNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ame wii aujmaka tuke anturtusmeke ame nunaka, wika shir nekajai. Tumayatan yamaisha tajame, ame wijai pujamusha ju shuar shir nekamtikata, nitasha nuna wainkar nekas Yuus akupkamuapita turutiarti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Nuna tusa inaiyak senchi untsuak: “¡Lázaro, nantakim jinkita!” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Tusa untsuam Lázaro jakau ikusmausha, uwejnum, nawenam, tura yapinam jaanchjai punuarmaunka imanisag jiinkinaiti. Tumamtai Jesús chichaak: “Atiirum akupkatarma”, tusa tinaiti. Nuna takai shuar aina atirar akupkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Judío aina Marían uyuunainak yujainaka, Jesús Lázaron inanmaun wainkar juka Yuusan uchirimpapita tusa tiaruiti. ");
INSERT INTO hubNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Antsu chikich ainaka fariseo ainan nuna turayi tusar ujakartasa weriaruiti. Tumawar jeariar ujakaru ainawai. ");
INSERT INTO hubNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Turam fariseo aina, sacerdote apuri ainajai iruuntrar chikich apu nitan nagkakau ainajaisha iruuntrar chichainak: “¿Nu shuar aitka nukap iwainak takak shuaran inakta nusha iturkattajia? ");
INSERT INTO hubNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ayatik inaisakrinka imatika iwainakai ashi shuar ainaka ninak anturkar nekaspapi tiartatui”, tusa tuina. “Tusa tuinakai Romanmaya apu aina kaunkar Yuus ememattasa iruuntai jean yumpuntramainak juiya shuar ainatinka ashi ijitmattaji”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Nuna tuinakai nuiyag sacerdote apuri Caifás naartin ni nu uwítin apu naamak pujau asa chichaak: “Atumka ishichkisha enentaimtsurme. ");
INSERT INTO hubNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ashi shuar aina jinumainnum chikichik shuarak mantamnatna nuka nekatsrume”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Nunaka Caifáska nigki enentaimsagka tichauwaiti, antsu nunaka nu uwítin ni sacerdote apuri ainan apuri asamtai, Yuus tu enentaimtikam chichaa asa, Jesúsaiti judío ainanam nigki mantamnatnuka taku, tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Nuka judío ainatinmag mantamnashtinaiti, nina nekaspapita tauka uwemkaru arti tau asa, ashi shuar nugkanam matsataina nui enentaimas mantamnatnaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Nu tsawanta nui nagkama judío apuri aina Jesús maami tusar chichaman umirkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Turamu asa Jesúska paan wantinak wekaatsuk, Judea nugka ikuak chikichik yaakat shikapchich Efraín tutai nugka aya nugkanmag tiiju aunam wuwaiti. Tuma nui jeaa ashi nina unuinatairi ainajaimak iruunar pujusuiti. ");
INSERT INTO hubNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Judío ainan jiistari Pascua tutai tsawan jeastatuk jasmatai, nui jeawar nu jiisat tsawakai pegkermakara nui jiistamami tinu asar nuna umikartasa, nukap shuar Jerusalénnum shimuina. ");
INSERT INTO hubNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Jesúsan wainkar achikartasa kashi kashinig ea yujaina. Imatika yujaina asar, Yuus ememattasa iruuntai jea jeamkamunam wayaa ekeemsarsha nitak chichainak: “¿Atumsha uruk enentaimtarmea, Jesúscha ju jiistanmasha taashtimpash tatsukeash asat?” tusar tuina. ");
INSERT INTO hubNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Imatika eaina asar, fariseo aina sacerdote apuri ainajai nekaawar achikartasa, atum ni pujamuri nekakrumka ujakratkatarma tusar shuaran akattraru. ");
INSERT INTO hubNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Jiisat Pascua tsawaartin seis tsawan ai, Jesús nina unuinatairi ainajai yaakat Betanianam Lázaro jakau inankimua nuna pujutairin wuwaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Nui jeamtai Jesúsan eme anentas iiyainak yurumak yuami tusa ipaawaru ainawai. Turawarmatai Marta yutain ekentrauwaiti, turamtai Jesús Lázarojaimak mesanam jeantar ekeemsar yuinak eketaina. ");
INSERT INTO hubNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Tumainai María kugkuin nardo tutain chikichjaisha pachimtsuk aya nuke najanamun, shir akikan juki jeaari, Jesúsa nawen ukatak, nina wichijaig ujujturuiti. Nu tura ukatkamu nuna kugkunti jeanka akirawaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Nuna turakai Judas Iscariote Simónkan uchiri, Jesúsa unuinatairiyaitiat Jesúsan suruktin chichaak: ");
INSERT INTO hubNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“¿Urukamtai kugkuinnasha, suruk kuitan trescientos denarion juki kuitrinchau ainan yaitskesha aitkawa?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Turasha nunaka Judaska kuitrinchau ainan yaigtasa enentaimtakka tichauwaiti. Nigka kuit kuitamata, tusa kuit chumpitai susamaitiat kasa asa, nui shuar chumpiamuncha kasamak yaruma wekain asa, nunaka turattsa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Nuna takai Jesús chicharuk: “Takamtak inaisata. Junaka wina mantuawar ikursartin asarmatai jutikrawai. ");
INSERT INTO hubNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Kuitrinchau ainaka atumjaigka tuke pujuartinaiti, antsu wii atumjaigka tuke pujuschatnaitjai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Tura judío aina Jesús Betanianam pujawai tuinamun antukar nukap shuar nina wainkartasa, tura Lázaro jakaunak Jesús inankimuncha iisartasa weriaruiti. ");
INSERT INTO hubNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Nuna tumainakai sacerdote apuri ainasha Lázaro maami tusar chichaman umiraina. ");
INSERT INTO hubNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Ni nantakmaurin wainainak nukap judío aina Jesúsan nemarkartasa tupaina asarmatai nunaka tuina. ");
INSERT INTO hubNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Jiisat Pascua atin asamtai, nukap shuar Jerusalénnum wearuiti. Tuma nui kanar tsawarar Jesús tatatui tuinamun antukaruiti. ");
INSERT INTO hubNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Tumawaru asar nukan tsupirar jiintraruiti, tura igkuinak: “¡Yuusa nuke ememattai atii! Apu akupkam wina juka shir pegker chicharam atatui. Israel shuar ainan apuri wina juka pegker chicharam atii”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesús burron wainak nui ekeemsauwaiti. Yuusa chichame aarmauwa nunaka metek umikuiti. ");
INSERT INTO hubNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Siónnumia shuar ainatirmeka ashamkairpa, atumin apuri burronam ekeemas wina nu iistarma. ");
INSERT INTO hubNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Yama nagkamchakka Jesús burronam ekemi weakaisha nina unuinatairi ainasha Yuusa chichamen aarmauwa nunapi metek umiawa tusarka nekacharuiti. Turasha mantamna nantakmatai aarmau ajakua nuka nina taku timau asamtaimpapi metek uminkaya tusar nekaawaruiti. ");
INSERT INTO hubNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Shuar aina Jesúsan nemarsar wekaina, Lázaro jakaun Jesús untsuk inantun wainkaru asar, tumamai tusar ashi nita wainkamurinka chikich ainan ujakaruiti. ");
INSERT INTO hubNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Nu etsermaun antukar shuar ainasha Jesúsan igkugkartasa jiinturaruiti. ");
INSERT INTO hubNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Tumainakai fariseo aina chichainak: “¡Pai! ¡imatrakrisha antumtikacharji! ¡Iisuana nina ishiintana!” tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Jiisat tsawantin Yuusan eme anentas iiyainak emematiartasa, Jerusalénnum wearua nuiyasha griego shuar ainasha ishichik wearuiti. ");
INSERT INTO hubNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Nu aina Felipe Betsaidanmaya Galilea nugkanam puju jakua nuna jeariar chichainak: “Yatsuru, Jesús wainkattsar wakeraji”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Tuinakai Felipe, Andrésan weri nijai tsanintak Jesúsan jeariar, wainkattsar wakeraji turamainawai tusar ujaina. ");
INSERT INTO hubNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Nu tusa ujam Jesús chichaak: “Wii shuarnum akinawaitaj juna mantuawartinka yamaika tsawanka uminui. ");
INSERT INTO hubNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Wika trigo jigkaiya numamtinaitjai, trigo jigkai akaka nugka arachmaka chikichkiti, antsu araamka tsapai nukap nerenaiti, numamtuk wisha mantamnachkunka chikichkitjai. Antsu wii mantamnan nantakmatai, nukap shuar yamaram pujutan jukiartinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Shuar ni wakeramurinak enentaimtus umi pujauka waittanam wetinaiti. Antsu shuar Yuus wakeamun umirnuka pujut nagkanchau tuke atinan jukitnaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Wina umirtuktaj tauka nemartukarti, wina umirtauka wijai pujusartinaiti. Tura wina umirtaunka wina aparsha nunaka eme anentinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","‘Yamaika senchi kuntuts nekapeajai. ¿Wari titajak? Apaachi, ¿wina mantuawartata nunaka turuttsuk inaitusarti ayamrutkata titajash? Antsu nekas nunaka tichatjai, turutawarti tusan wika ju nugka juigka taawaitjai’. ");
INSERT INTO hubNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Apaachi, shuar ainasha aminak emematramiarti”, tusa tinaiti. Nuna taig nayaimpinmaya chichaak: Yaunchuk emematramiarti tusan timajme, awentsankesha titajme. ");
INSERT INTO hubNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Nu tamaun nui shuar irunu antukar chichainak: “Ipamtaiti”, tusa tuina. Chikich chichainak: “Nayaimpinmaya shuar chichakai”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Tuinakai Jesús chichaak: “Nu chichaa nunaka wina antumtikruktasa tatsui, antsu atumin antumtikramkattsa tawai. ");
INSERT INTO hubNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Yamai tsawan jeawai, shuar ju nugkaya aina etegkratnuka, tura yamaiya juik ju nugka juna apuri iwanchia nusha nepetkimu atatui. ");
INSERT INTO hubNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Wina mantuawartasa yaki takuriarmatai, shuar wina nekaspapita turutainanka winig ashi ikaankattajai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Nunaka ni mantamnatnurin shuaran nekamtikuk tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Jesús nuna takai shuar aina aimainak: Ii chicham umiktinnum aarmauwa nuiyan aujainak: Cristoka jatsuk tuke pujutnaiti, tusar tu aujainamu antinaji. Nu tu aarmau aisha: “¿Amesha urukamtai shuarnum akinaka maattsa yaki takuam atinaiti tame? ¿Shuarnum akinasha yaita?” tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Nuna tuinakai Jesús nitan chicharuk: “Atumin káshinam pujusairum, tusa winaka Yuus akuptuku asamtai, tsaaptina numamtin yamaikika ishichik tsawan atumjaigka pujustatjai. Tuma asamtai atumsha Yuusa uchiri aina tsaaptinnum wekaina numamtuk winak enentaimtursatarma. Káshinam wekainaka nita wekamurinka nekainatsui. ");
INSERT INTO hubNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Atumsha tsaaptinnum pujusmintrum, wii atumjai puja juik nekaspapita turuttarma”, tusa tinaiti. Nuna Jesús tusa we nitan uumrukuiti. ");
INSERT INTO hubNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Nuna tusa taku Jesús nitasha wainmaunmag, shuar wainchatain iwainak takakaisha nekaspapita ticharuiti. ");
INSERT INTO hubNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Nunaka Yuusa chichamen etserin Isaías aarmauwa nu imanisag uminkauwaiti. Nuka tu aarmauwaiti: “Apu ¿ya ina chichamencha nekaspapita tawa? ¿Apusha yana nina senchirincha iwaintawa?” ");
INSERT INTO hubNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Nu tau asamtai, nekaspapita tumain nekapenachu, junasha Isaías tu aaruiti: ");
INSERT INTO hubNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Yuus nitanka wainmachua numamtin amajkarai, tura enentaimtancha enentaimchau, nunaka iwainamun wainin ainayat wainchauwa numamtin, etsermauncha antin, turasha enentai nitanunka yapajimainchau asarmatai, Yuus agkan inaisauwaiti”. ");
INSERT INTO hubNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Nunaka Isaías Jesúsan senchirin wainkau asa, nina pachis chichaak tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Nuna takai nukap shuar aina Jesúsan nekaspapita tuinakai, apu ainasha nekaspapita tiaruiti. Nuna tumainaksha fariseo ainan ashamainak, iruuntai jeanmaya jiirmakiaraij tusar iwainmamkacharuiti. ");
INSERT INTO hubNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Nunaka shuar eme anenmamna nuna ima senchi wakeruinak, Yuus eme enentaimtuta nunaka imanchau enentaimtuinak tumawaruiti. ");
INSERT INTO hubNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jesús senchi chichaak: “Shuar wina nekaspapita tusa umirtuina nuka shir winak nekaspapita turutainatsui, wina akuptukua nunasha nekaspapita tusar umirainawai. ");
INSERT INTO hubNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Wina waitainaka wina akuptukua nunasha aitkasag wainuk tumainawai. ");
INSERT INTO hubNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Shuar ainan chicham nekasa nuna nekamtikattsan, tura wina nekaspapita turutaina káshinam wekawa numamtuk tunaunak matsamtiaraig, tusan wika ju nugka jui Tsaaptina numamtuk taawaitjai. ");
INSERT INTO hubNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Shuar wina chichamrun anturtayat, umirtachunka wikisha makushtinaitjai, nigki nunaka makumatnaiti. Wika shuar ainan makuttsan juigka taachuitjai, antsu shuaran uwemtikattsan taawaitjai. ");
INSERT INTO hubNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Wina nakitrak, chichamruncha metek umiachun makutnuka awai. Tura tsawan nugka mesera nagkanmaunam makukrattinka, chichaman wii tukartimaj nuwaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Wii wakeramurnakka chichaatsjai, wii chichaktinnasha, tura jintinkartuatnuncha akatturuka wina Apar akuptukua nuwaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Tuma asamtai wina Apar umiktarma turammauwa nuka pujut nagkanchau tuke atina nunapi sukartawa tusan wika nekajai. Tura asan wii atumin ujajrum nunasha wina Apar turutmauwa turusnak ujajrume”, tusa Jesús tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Jiisat Pascua jeatsaig Jesús nina Aparin weak ju nugka jui nina unuinatairi ainan ikuktin tsawan jeattak jasun nekau asa, ninu ainan senchi anea. Tuma asa nitan aneamurin iwaintak ima senchi ashammainnum jeawaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","4","Tuma asamtai Judas Iscariote, Simónka uchiri ajakua nuna Jesús surukta tusa iwanch enentaimtikrauwaiti. Jesúska nina Aparijai pujau taamurinka shir nekajakuiti, tura ataksha nina Apari pujamunam waketkitnurincha shir nekajakuiti. Nina Apari senchimtikam winimurincha nekau asa, etsa akakai yurumkan yuinak eketainai jaanch uku nugkuarmaurinka awiik awagkeak, jaanch ujujmamtain juki akachuma wajasuiti. ");
INSERT INTO hubNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Tuma entsan juki ikijmatainam yara ashi nina unuinatairi ainan nawen nijatkauwaiti. Tura ni ujujmamtai akachumamurijai ujujkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Simón Pedroncha nawen nijatrattsa jearnaiti, turam Simón Pedro chichaak: “Apuru, ameka wina nawerka nijatrumaitsume”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Nuna takai Jesús ayak: “Yamaikika wii juna jutikaj juka shir nekatsme, turasha nui pujusam shir nekattame”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Tamasha Pedro chichaak: “Apuru, ameka wina nawerka pegke nijatrumaitsume”, tusa tinaiti. Tama Jesús ayak: “Amina nawemin wii nijachkaigka ameka wina nemartinka amaitsume”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Nu tusa tama Simón Pedro chichaak: “Antsu Apuru, ima naweruk nijatrutsuk, uwejrusha nijatrakum mukaruisha nijatrata”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Tusa tama Jesús ayak: “Yama mainka wapikchau asamtai ataksha nijamka amaitsui, antsu nawen nijatam amainaiti. Atumsha numamtuk ashi metek atumi tunauri tsagkurachmau akurmesha atumin tunaurigka tsagkuramu ainarme”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ashi metek atumi tunauri tsagkurachmau akurmesha tina nunaka shuar nina suruktincha pachitkau asamtai, nuna wainuk, tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ashi nina unuinatairi ainan nawen nijatak umik, Jesús ataksha ni jaanch uku nugkutairin juki nugkur mesanam ekeemas nitan chicharuk: “¿Wii juna jutikajrum jusha atumsha nekarmek? ");
INSERT INTO hubNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Atum wina chichartakrum Unuikartina, apuru, amajtarum nuka wisha nu asamtai, nekas turutrume. ");
INSERT INTO hubNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Wii unuikartin, tura apu ayatnak, atumin nawen nijatrajrum turusrumek atumsha naweka nijatnairatarma. ");
INSERT INTO hubNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Wika junaka atumin iwaintakun, nitasha juna wainkar jutiksag takasarti tusan aitkajrume. ");
INSERT INTO hubNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Nekas tajarme, chikichan takarin aina nuka inakratnunka nagkakatsui, tura akupkamua nusha tumasag akupkartaunka nagkakatsui. ");
INSERT INTO hubNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Wii tajarum ju Yuus yainmasmatai shir nekaarum, atumsha umiktasrum kakanmamkurmeka shir aneasrum pujustinaitrume. ");
INSERT INTO hubNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Junaka ashi atumin tunaurinka tsagkurnaru ainawai takun tatsujrume. Wii atumin etegkrau asan, wika shir nekajrume. Yuusa chichamen etserin yaunchuk tu aaruiti: ‘Wijai yua nuke winaka shuarmatattawai’, timau umiktin a nuna nekajai. ");
INSERT INTO hubNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Nu tsawan jeaakai nekas Tuke pujuwa nuwapita turutmintrum, tusan nunaka yamaik emtikan ujajrume. ");
INSERT INTO hubNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Nekas tajarme, wii akupeamun nakittsuk juaka, wina jurak turuinawai, tura wina jurausha wina akuptukua nuna juinak tumainawai”, tusa Jesús tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jesús nuna tusa tina senchi wake mesemar nekapeak, shir paan iwainak chichaak: “Nekas tajarme, atum ainarum nuiyag chikichik winaka surutkatnaiti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Nuna tusa takai nina unuinatairi ainasha nekainachu asar, yana takug ta tusar mai inia jaina. ");
INSERT INTO hubNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Tura Jesúsa anetairi ninii ayaamas yuak eketu. ");
INSERT INTO hubNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Tumattamaun Simón Pedro uwejejai inakmas, nunasha yana takug ta iniasta, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Nuna takai Jesúsan iniak: “¿Apuru, nusha yaita?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Nu tusa iniam Jesús chicharuk: “Jasta, pankan puukan inijaaran susattaj nu atatui, tusa tinaiti. Nuna tusa pankan puuk inijaar Judas Iscariote Simónkan uchiri ajakua nuna susauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Tura aig Judasan iwanch wári egkemturuiti. Turamtai Jesús chicharuk: ‘Judasa, ame turataj tame nuka wári turata’ ”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Nuna takaisha nui yuinak pekarainasha, nuna turattakaimpapi tawa tusarka chikichkiksha nekacharu ainawai. ");
INSERT INTO hubNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judas kuitan kuitamin asamtai, nita enentaimsarka jiistatin atsumakur sumaktin takukta tusampash ta, nuna tachaksha, kuitrinchau aina susata tusampash ta tu enentaimaina. ");
INSERT INTO hubNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judas nuna pankan yua wári jinkina nunaka káshi tumawaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas jiinki wematai, nui Jesús chichaak: Wii shuarnum akinawaitaj nunaka yamai emematriartatui, turusag wina Aparnasha emematiartatui. ");
INSERT INTO hubNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Shuarnum akinawa nu Yuus ememattarma tusa iwainakaigka, Yuuscha: “Uchirun emematiarti tusasha wári umiktatui. ");
INSERT INTO hubNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Uchir ainata, atumjaigka imanikan nukap tsawanka pujuschattajai. Atum winaka eatkattarme, judío ainan timaj aitkasnak atumnasha tajarme, atumka wii weamunmagka winimain ainatsrume. ");
INSERT INTO hubNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Yamai ju yamaram chicham umiktinan tajarme. Ashi metek anenaitarma. Wii atumin aneajrum tumasrumek, atumsha chikichjaisha anenain ataarma. ");
INSERT INTO hubNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Atum chikich ainasha aneakrumnaka, Jesúsan nemarnapi ainawa tusar nekarmawartatui”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Takai Simón Pedro Jesúsan iniak: “Apuru, ¿ii winimainchaunmasha tuwa wetatme?” tusa tinaiti. Takai Jesús ayak: “Wii wetataj nuigka yamaikika winimaitsume, turasha nukapech arusam winittame”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Takai Pedro chichaak: “Apuru, ¿urukamtai yamaikisha winimaitsuja? Wisha amijai mantamnattsan wakerajai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Takai Jesús ayak: “¿Nekas ame wijai mantamnattsam wakerakmek tame? Nekas tajame, atash shinatsaig aunka wainchauwajai tusam tresa imajnia waitruattame”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Atumka wake mesemar kuntuts enentaima pujuirpa, Yuusai nekaspapita tusarum enentaimsatarma, tura winasha nekaspapita turuttarma. ");
INSERT INTO hubNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Wina Apar pujamunam nayaimpinam atum pujumain nukap agkan awai. Nu atsakaigka atumnaka ujamaitsujrume, nu iman au asamtai wii atum pujustinnaka umirkatjarme tusan weajai. ");
INSERT INTO hubNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Yamai wii wena atum pujustinan umikan, ataksha wakettsanak atumin jukin, wii pujamunmag pujustarma, tusan jukittsan taruattajrume. ");
INSERT INTO hubNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Atumka wii tui weaja nuka nekarme, tuma asarum jintasha nekarme”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Nuna takai Tomás chichaak: “Apuru, ame weamu nekatsuj aniatisha, ¿itursarik jintasha nekatji?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Nuna takai Jesús ayak: “Jinta numamtinnaka wii Tuke pujuwaitaj nuwaitjai, tura chicham nekasa nuna etserin, tura pujut tuke atina nuna sukartinaitjai. Winig wininak nekaspapita tuina nuke aparuigka jeatin ainawai. ");
INSERT INTO hubNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Atum wina waitkurmeka wina aparsha wainmain ainarme, tura atumka wainkau asarum yamaikisha waintrume”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Nuna takai Felipe chichaak: “Apuru, apa iwainkartukta, nu wainka isha shir enentaimsarmi”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Nuna takai Jesús ayak: “Felipe, wii atumjai iruuntran nukap tsawan pujaj nusha ¿eke shir waittsurmek? Wina waituka aparnasha wainui, tumau aisha, ¿urukamtai winasha apa iwainkartukta tusamsha turutme? ");
INSERT INTO hubNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Wina aparjai wii pujau asamtai ¿wina aparsha wijai puja nuka nekaspapita tatsumek? Wii chichaaj nunaka wii wakeramunka chichaatsjai. Antsu apar wini puja nu ni wakeramurinak chichamtikrawai. ");
INSERT INTO hubNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Wii wina aparjai pujau asamtai, wina aparsha wijai puja nuka nekaspapita titarma, nu nekaspapita tichamnau nekapeakrumsha, wii iwainamu wainkurmeka nekaspapita titarma. ");
INSERT INTO hubNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Nekas tajarme, wina nekaspapita turutainaka, nitasha wii takaj junaka imatiksag takasartin ainawai. Wii aparui wea asamtai, wii takajakmauncha nagkasar takasartin ainawai. ");
INSERT INTO hubNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Atum wina seatkurminka, wina aparnasha shir emematiarti, tusan imatiksanak umiktajai. ");
INSERT INTO hubNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Atum atsumamu seatkurminka, imatiksanak umiktatjai”. ");
INSERT INTO hubNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Atum wina anenkurmeka, chicham umiktarma tajarum nu metek umiktarma. ");
INSERT INTO hubNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","17","Tura nu umirtakrumnaka atumin yainmaktinan, Wakan Pegker nekasa nu akuptukarta tusan Aparun aujsattajai, wii tama atumjai tuke pujustinan akupturmaktatrume. Shuar wina nemartichu ainaka nekainachu asar, Wakan Pegkera nunaka jumain ainatsui. Turasha nigka atumjai pujau asamtai, atumka nekarme, pujurtamrum antsag atuminka tuke pujutnaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Atumnaka mitaika numamtukka ikukchatnaitjarme, wakettrusnak ataksha taruatnaitjarme. ");
INSERT INTO hubNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ishichik asag chikich ainaka waitkachartatui, turasha atumka mantuawarmatai nantaktataj nui waitkattarme. Tuma asarum atumka wijaig tuke pujutin ainarme. ");
INSERT INTO hubNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Turasha nu tsawan jeaakai wina aparjai chikichkia numamtinaitaj nuka nekaattarme, tumakrum wii atumjai pujamusha shir nekaattarme. ");
INSERT INTO hubNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Wii chicham umiktarma tinaitaj nuna umiaka wina anentuk tumattawai, wina anentunka aparsha anettawai, tura wisha ninka anettajai. Turakun wantintuktatjai”, tusa Jesús tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Nuna takai Judas (Iscariotechu) chichaak: “Apuru, ¿shuar amina nemartamchau aina wantintutskesha urukamtai ima inkisha wantinkartuktatme?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Takai Jesús ayak: “Wina anentuka wii taja nuna umiktatui, tuman wina aparka anettawai, turakai wisha wina aparjai ninii pujustasan taruattajai. ");
INSERT INTO hubNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Antsu wina anenchau wii taja nuna antaksha umirtukchattawai, atumin tajarum nuka wina chichamruchuiti, wina apar akuptukua nuna chichameyaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Junaka atumjai pujaj juik ashi ujajrume. ");
INSERT INTO hubNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Turasha Wakan Pegkera nuna akupturmakti tusan wina aparun wii aujsattajai. Nu atumin jintintramattarme, nuiyasha wii timajrum nunasha ashi anemtikramrattarme”. ");
INSERT INTO hubNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Iturchat akai, tura sapijmakrum uyuma pujuirum, wii enentaimaj imajuk arti, tusan atumin enentaimtairincha pegker amajeajai. Ju nugkanmaya shuar ainaka, wii atumin pegker enentaimtan suajrum nunaka surammain ainatsui. ");
INSERT INTO hubNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Wika weajai, tumancha atumjai pujustasan wakettsanak taruattajrume tusa tamausha antukmarme. Nekas wina shir anenkurmeka, wina apar wina nagkatasu asamtai nui weajai tamau anturtukrumka shir aneasrum pujumain ainarme. ");
INSERT INTO hubNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Nu uminu wainkarum nekaspapita timintrum, tusan nunaka emtikan tajarme. ");
INSERT INTO hubNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ju nugkanam inamna nu winau asamtai, atumjaigka nukap chichaa pujushtatjai, wina nagkataku senchirtinchau aigkisha, ");
INSERT INTO hubNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ni wakeramun nutikati tusan inaitustatjai. Turam nunaka turusag umiktatui, tura shuar juiya ainasha wii aparun aneakun, ni turata tusa inatramun takaj nuna nekaawartatui”. “Juka ikuaku wearmi wajaktarma”, tusa Jesús tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Wii Tuke pujuwaitaj nuwaitjai arakan numiriya numamtinnaka, antsu wina Aparka arakan kuitamna numamtinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Wina kanawer nereachunka tsupiawai, antsu nereanka jeamurin asantak au nukap nerekti tusa kuitamui. ");
INSERT INTO hubNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Atumka wii timajrum nu umia asarum shir asantramua numamtin ainarme. ");
INSERT INTO hubNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Wii atumjai iruuntsan pujaj tumasrumek atumsha wijaigka irutkau pujutarma. Arakan kanawe numirin achitkachu, nigki kanaki auka neremaitsui. Atumsha numamtuk wijai irutkau pujachkurmeka pegker aina nuka iwainamaitsurme. ");
INSERT INTO hubNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Wiyaitjai nekas arakan numiriya numamtinnaka, atumka ayatik wina kanawer ainarme. Wijai achitkauwa nu pegker aina nunak iwainamainaiti. Wijainchuka atumka ishichkisha nuka turumain ainatsrume. ");
INSERT INTO hubNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Wini iruunas pujachuka, numi kanawe tsupikmau kukarmatai juki aestaiya numamtuk, jiiki ajapeam artinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Atum winig iruuntsarum pujakrumka, tura wii jintintawaitjarum nusha kajinmattsuk pujakrumnaka, atum atsumamu seatkurminka, tura wina Aparsha wakerakaigka metek umiktatjai. ");
INSERT INTO hubNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Atum pegkera nuke takákrumnaka chikich ainasha wina Aparun emematiartatui, tumakrumka nekas wina unuinatair amainaitrume”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Wina apar, wina anenta aitkasnak atumnasha aneajrume. Wii aneajrum tumasrumek atumsha anenai matsamtarma. ");
INSERT INTO hubNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Chicham umiktinan wii ikurjarum nu umiakrumka, wii aneajrum tumasrumek anenaitarma. Wina aparun chichamen umiru asan, ni anenta aitkasnak nincha aneajai. ");
INSERT INTO hubNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Wii juna chichaman tajarum nunaka wijai shir aneasrum tuke pujusmintrum tusan ujajrume. ");
INSERT INTO hubNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Wii chicham umiktarma tajarum nuka, chikich ainajaisha anenaitarma, wii atumin aneajrum tumasrumek tajarum nuwaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Nina amikrin ayamrak makuma nu ima nekas anegkratui. ");
INSERT INTO hubNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Atum wii tajarum nu umiatirmeka wina amikur ainarme. ");
INSERT INTO hubNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Inatai ainarme tumaitsujrume, inatai ainaka apuri takamurinka nekachu ainawai. Wina apar turutmaunka ashi ujaku asan, atumnaka amikur ainarme tusan tajarme. ");
INSERT INTO hubNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Winaka atumka etegtuachu ainarme, antsu wiyaitjai atumin pegkeran takasarti tura nita pegker takamurisha tuke atii tusan etegkraunka, atum atsumamu wina pachittsarum seamkurminka, wina apar ashi suramsatnaitrume. ");
INSERT INTO hubNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Wina chichamur umirtuktarma tusan tajarum nuka: “Chikich ainajaisha anenaitarma timajrum nuwaiti”, tusa Jesús tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Shuar wina nemartichu aina atumin kajertamainakaisha aneartarma, yama nagkamchakka winaa kajertuku ainawai. ");
INSERT INTO hubNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Atum nitajai metek akurminka, nita anenaina tumasarag atumnasha anenmamain ainawai. Turasha atumnaka nitajai metek arumin wii etegkran winau amajsamu asarum, nitajai metekchau asaakrumin kajertamiartin ainawai. ");
INSERT INTO hubNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Tura inatai ainaka apurin nagkasachuiti, tusan wii timajrum nuka aneaku ataarma. Wina waitkarsaru aina numamtuk atumnasha waitkarmasartinaiti, winasha anturtukcharu asar, atum etsermauncha anturtamkachartinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Nunaka atum wina nekaspapita turutu asaakrumin, tura wina Apar akuptukua nunasha nekainachu asar, imatikramiartinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Wii taruan imatika chichaman ujakchamu ainakka, nitaka makumamain ainatsui. Turasha yamaika nita tunaurigka tsagkuram achartinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Wina kajertuinaka wina Aparnasha kajerainawai. ");
INSERT INTO hubNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Wii chikishcha iman iwainara takaschamun turachuitkaigka imanikar makumamainchau ainawai. Tumamain ainayat wii iwainara takámun waitainayat, winaka kajertuinawai, tura wina Aparnasha kajeraina asar makumartinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Nuna tumaina nunaka nita papirin tu aarmauwaiti: ‘Winaka aantar kajertiarmiayi’, ta nuna umikartasa nitaka aitkarainawai. ");
INSERT INTO hubNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Turasha wina aparuiyan Wakan Pegkera nuna wii akupkamu atumin yainmak enentain ichichturmartattrum nu, wina pachitas tuke chichattawai. ");
INSERT INTO hubNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Atum yama nagkamchakrum wijai matsamsau asarum, atumsha wina pachittsarum tuke chichatnaitrume”. ");
INSERT INTO hubNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Wii taja nunaka aantrarum iturchat enentaimiakrum wii jintintamjarum nu kajinmatkirum tusan tajarme. ");
INSERT INTO hubNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Tsawan jeakaigka judío iruuntai jeanam wayakrumnasha aa jiirmartin ainawai. Tura atumin mantamainak: ‘Juka Yuus wakeramu asamtai jutikainaji tusar tiartinaiti’. ");
INSERT INTO hubNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Nunaka wina Aparnasha wijai waitkacharu asar turutmawartin ainawai. ");
INSERT INTO hubNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Wii tajarum nunaka, nu tsawan jeakaisha wii timauwa nu anearmintrum tusan tajarme”. ");
INSERT INTO hubNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Junaka wii atumjai pujau asan, yama nagkamchaknaka tichamjarme. Turasha yamaika wina akuptukua nujai pujustasan weajai, nuna takaisha chikichkitirmeksha tui weam tusarmeka inintsachurme. ");
INSERT INTO hubNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Antsu wii nuna tau asamtai, ayatik wake mesekrum iruntrume. ");
INSERT INTO hubNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Turasha nekasa nuna tajarme, wii jui pujutsuk weamua nu ima pegkeraiti. Wii weachkaigka atumin yainmak enentain ichichturmamaina nuka tamaitsui. Nunaka wii weakun atumnaka akuptuktatjarme. ");
INSERT INTO hubNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Turam ni taa ashi shuar nugkanmaya ainan: Tunaurintin ainarme tusa nekamtikattawai, tura nigki pegker aina nunasha nekamtikattawai. Tura shuar waittanam wemainan uwemtumainnasha nigki nekamtikattawai. ");
INSERT INTO hubNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Wina nekas Yuusa uchirimpapita turutchau aina nunaka tunaurintin ainarme tusa nekamtikattawai. ");
INSERT INTO hubNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Wika apar pujamunam weajai. Tuma asamtai atumka winaka waitkashtatrume. ");
INSERT INTO hubNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Tura waitat uwemtumaina nunasha nigki nekamtikattawai, tura ju nugka juna apuri iwanch senchirtin aina nuna waittan susatna nunasha nekamtikattawai. ");
INSERT INTO hubNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Atum ujamaintruka ju nukap awai, turasha atumka yamaikika nekamain ainatsrume. ");
INSERT INTO hubNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Wakan Pegker chicham nekasa nunak chichauwa nu wina aparnaun antukmaun waitchauwa nunak jintintramatnaittrume, atak artina nuna jintintramatnaittrume. ");
INSERT INTO hubNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ni wina pachitas auk ememattarma tusa turamtinaitrume. Winauwa nunak jua asa atumnasha wina chichamur antukmauncha shir nekamtikramatnaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ashi wina aparnauwa nuka winau ainawai. Wakan Pegker winau ainan juki atumnaka nekamtikramattawai taja nunaka nui tajarme”, tusa Jesús tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Ishichik asarmek winaka waitkashtatrume, turasha wika wina apar puja nui wea asamtai, ishichik asarmek ataksha waitkattarme”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Nuna takai nina unuinatairi aina nitak ininainak: “¿Nunasha uruk takua, wika apar pujamunam weajai. Tuma asamtai ishichik asarmek winaka waitkashtatrume, turasha nukapech asarmek ataksha waitkattarme, ta nunasha turamjia? ");
INSERT INTO hubNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Warina pachisag tawa? nekarmain chichatsui”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Nuna tusar Jesús iniasmi tusa chichainamun nekawaiti. Tuma nitan chicharuk: “Atumin wii chicharkun ishichik asarmek waitkashtatrume, turasha ishichik asarmek ataksha waitkattarme tajarum nuka atumek ininiarum. ");
INSERT INTO hubNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Nekas tajarme, atumka wii mantamnamtai útkurum wake mesemar pujuttarme, tumarmin shuar wina nemartuinatsu nuka shir aneasar pujuartatui. Tumainakaisha atum wake mesemar pujamuka sakatmarum ataksha wina waitkarum shir aneastatrume. ");
INSERT INTO hubNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Nuwa uchin jurertasa jateemaa najaimakka wake mesemar pujuwaiti. Turasha uchin jurerka, nuna uchin shir anentak, najaima jakmaurinka pachichuiti. ");
INSERT INTO hubNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Numamtuk atumsha yamaikika wake mesemar nekaptinaitrume, turasha ataksha wantintuktatjarme, turam waitkarum shir aneastatrume. Nunaka chikichkiksha emegkatrammain ainatsui. ");
INSERT INTO hubNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Nu tsawantaika atum ininmarum nuka chikichkitirmeksha inintsashtin ainarme. Nekas tajarme, wina pachittsarum apar aujmaka imatiksag umiktatui. ");
INSERT INTO hubNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Nuikka wina pachittsarum aparka aujsachu ainarme. Turasha yamaika aujsatarma shir aneasmintrum, tumakrumin wina apar suramsatnaitrume”. ");
INSERT INTO hubNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Wika yaunchuk atumin ujaknaka aujmatmau ainan pachisan ujamjarme. Turasha yamaika tsawanka ashi jeayi, tuma asamtai yamaika aujmatmau ainan pachisnaka ujatsuk wina aparun pachisan shir ujaktatjarme. ");
INSERT INTO hubNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Nu tsawan jeakaigka, atumka winak eme anentrusrum apar aujsatnaitrume, wika atumin pachisnaka aparnaka aujtuschatnaitjarme. ");
INSERT INTO hubNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Atum wina anentu asarum, aparijai pujauwapi tarutramawaitjia turutu asaakrumin, wina aparsha atumnaka anenmarme. ");
INSERT INTO hubNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Wika aparjai pujaun jiinkin ju nugkanmagka taawaitjai. Tuma asan yamaika ju nugkanka ikuakun ataksha aparui weajai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Nuna takai nina unuinatairi aina chichainak: “Yamaika chikich pachisam chichatsuk paan antumain chichakume. ");
INSERT INTO hubNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Tura asaakmin isha antukji, ame ashi nekam nunaka chikichkiksha amina ininmamainnaka atsumainatsui. Ika nui yamaika Yuusnumiampa taawaita tusar taji”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Nu tusa tuinakai Jesús nitan chicharuk: “¿Yamai nu antukrumek Yuusnumiampa taawaita turutrum? ");
INSERT INTO hubNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Yamaika tsawan uminkayi, yamaiya juika atumka chiki chikichik kanarum shimakrum winak ikurkittarme. Turasha wina apar wijaigka pujau asamtai wikika juakchattajai. ");
INSERT INTO hubNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Juna tajarum nunaka winig enentaimkurum atumsha shir aneasrum agkan pujusmintrum tau asan tajarme. Ju nugka jui pujusrumka atumka waittsattarme, imaniakrumsha ichichmamratarma, wii ju nugkanmayanka ashi nepetkajai”, tusa Jesús tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Nuna tusa inaiyak Jesús nayaimpinmani pagkai chichaak: “Apaachi, winaka tsawanka uminturkayi. Winasha amina senchirmea nu iwainturkata, winasha nekaspapi Yuusa uchiriyaita turutiarti. Tura shuar aina emematramiarti, tusan wisha amina senchirmin iwaintukartajai. ");
INSERT INTO hubNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ame winaka ashi shuar aina inararta, tura shuar wina nekaspapita turutaina pujut nagkanchauwa nu susarta, tusam senchimtikruawaitme. ");
INSERT INTO hubNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Nu pujut nagkanchauwa nunaka, amina nekarmawar jukeapita Yuusa nuka turamainak, tura winasha Jesucristoka Yuus akupkamuapita turutainak jukiartinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Wika ju nugka jui pujusnaka aminak tuke emematjame, tumakun umikta tusam ame turutnaitam nunasha imatiksanak umikjai. ");
INSERT INTO hubNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Apaachi, nui yamaika amijai apatka ememattai amajtusta, yaunchuk nugka najantsuk wii amijai pujai, emematrin armia turusag emematriarti. ");
INSERT INTO hubNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Ame ju nugkanmaya shuar aina juka etegkram surusuitme, nunaka wisha amina pachisnasha shir jintintawarjai. Nuka aminu ainak surusuitme, turamu asar nitasha chichamrumnaka metek umirtamainawai. ");
INSERT INTO hubNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Yamaika tumaina asar ame wina surusuitam nuka ashi aminuk ainawai. ");
INSERT INTO hubNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ame wina chicham etserturkata tusam turutmaunka imatiksanak ujakarmajai, turam nitasha antukar wakerukarmayi. Nekas Yuusnumiampa taawaita, ni akupkamuapita tusar nunasha tuinawai. ");
INSERT INTO hubNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Aminu asarmatai, ame wina surusmiam juna pachisan tajame: Chikich ju nugkaya aina nuna pachisnaka tatsujme. ");
INSERT INTO hubNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ashi shuar aminu ainaka winau ainawai, tura winau ainaka aminu ainawai, nu wina emematruinawai. ");
INSERT INTO hubNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Wika amini winitin asan, nitanka ju nugka jui ikukiartatjai. Apaachi Pegkera, ame wina surusmauwa juka, amina senchirmea nujai kuitamawarta, ii chikichik enentaimaj tumasag nitasha chikichkinak enentaimiarti. ");
INSERT INTO hubNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Nitajai pujaknaka ame senchiram surusmauwa nujai wii kuitamnajai, wii kuitammaunka chikichkinkisha emegkaakchajai, turasha chikichik nigki megkakatnaiti, tusa yaunchuk tu aarmauwa nu uminu asamtai megkakayi. ");
INSERT INTO hubNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Yamaika ame pujamunam winajai, tumayatan eke ju nugka jui pujau asan tajame: Yamaika wii senchi shir aneaj imanisag nitasha shir aneasarti. ");
INSERT INTO hubNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Amina chichamrumnaka wii ujakarmajai, turakaisha shuar amina nakitramin aina nitaka ju nugkanmayanchu asarmatai kajerainawai, tura winasha ju nugkanmayanchu asamtai kajertuinawai. ");
INSERT INTO hubNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Nugkanam matsamsaraig yaruakta tusanka tatsujme, antsu iwanch waitkainakaisha ayamrukta tusan tajame. ");
INSERT INTO hubNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Wisha ju nugkanmayanchu asamtai, nitasha ju nugkanmayagka ainatsui. ");
INSERT INTO hubNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ame chichamrum nekasa nujai aminu aina juka pegkermamtikata, ame chichamrumea nuka nekasaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Shuar nakitramin aina matsatmaunam wina akuptukuitam, turusnak wisha nitancha shuar amina pachitmachu matsatmaunam akupenajai. ");
INSERT INTO hubNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Wika nitan ayamrakun mantamnattajai, nitasha wina chichamur nekasa nuna antuinak pegker arti tusan tajame”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Ima nitanunak pachisnaka aujtsume, nita chicham etserainamun antuinak wina nekaspapita turutiartin ainan pachisnasha tajame. ");
INSERT INTO hubNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ashi ju aina juka iruunas pujusarti, ijai iruunas pujuinak, wii Apaachi amijai tsaniasan pujau asamtai, amesha wijai pujau asaakmin chikichkia numamtinaitaj, tumasarag nitasha arti tusan tajame. Shir iruunas pujuinakai, nuna wainainak chikich shuar ainasha nekas Yuus akupkamuapita turutiarti. ");
INSERT INTO hubNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Amina senchiram wina surusuitam nunaka nitancha imatiksanak susarmajai, turamu asar nitasha wii amijai chikichkia numamtinaitaj tumauk arti. ");
INSERT INTO hubNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Wii nitajaigka atajai, ame wijai atá, nitasha chikichkia numamtin arti, nita tumainamun wainainak shuar amina nakitramin ainasha, Jesúsnaka Yuusapi akupkauwaita, tura nina anea imatiksagkeapi incha anenmajia tiarti. ");
INSERT INTO hubNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Apaachi, ame surusmau aina nuka, wii pujutnaitaj nuig nitasha pujusar amina senchiram wina surusuitam nunasha wainkartin arti tusan wakerajai. Ame winaka nugkasha najantsuk anentu jaku asam, senchiram surusuitme. ");
INSERT INTO hubNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Apaachi Pegkera, shuar amina pachitmainachuka nekarmainatsui, turasha wika aminka wainjame, tura ju ame surusmau aina jusha ame wina akuptukuitam nunaka nekainawai. ");
INSERT INTO hubNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Wii amina pachisan nitanka nekamtikamjai, nuna nagkasancha tuke nekamtiksanke atatjai. Ame wina anentam tumasarag nitasha aneniarti, tumainakai wisha nitajaig pujutjai tusan tajame”, tusa Jesús nina Aparin tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jesús nuna tusa ashimak, nina unuinatairi ainajaimak jiinki entsa shikapchich Cedrón tutai amain katig númi olivo tutai arakmaunam jeawaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Nunaka Judascha yaunchuk Jesúsjaimak iruuntrar weká jaku asa, nu nugkanka shir nekau. ");
INSERT INTO hubNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Tumau asa sacerdote apuri ainan, tura fariseo apuri ainajaimak aujuk: Suntarum tsagkattrukta atutkarti tusa seawaiti. Tusa takai suntaran untsurin nagkin tinamak, tura Yuus ememattasa iruuntai jean kuitamin ainancha aitkasag lámparan tinamkar tura shiripkincha tinamak ishiakaruiti. Turamu asar nuna ekeemarar Jesúsan jeariaruiti. ");
INSERT INTO hubNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Imaninaig Jesúska ni turam atintrinka nekau asa, jiintuki chichaak: “¿Ya earme?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Tusa takai nita aimainak: “Jesús Nazaretnumiaya nu eaji”, tusa tuina. Tuinakai Jesús chichaak: “Wiyaitjai nunaka”, tusa tinaiti. Nui Judas Jesúsan suruktasa nitajai irutkau weká. ");
INSERT INTO hubNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Jesús chichaak: “Wiyaitjai”, tusa takai kuntuts enentaimrar wakettsarag nugka tepesaruiti. ");
INSERT INTO hubNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Tumawarmatai ataksha awentsag chichaak: “¿Ya earme?” Tama nita aimainak: “Jesús Nazaretnumiaya nu eaji”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Tuinakai Jesús nitan ayak: “Wiyaitjai Tuke pujunka timajrume, wina nekas achirkattsa eatkurmeka chikich aina juka inaisatarma wearti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Nuna tina nunaka Jesús yaunchuk chichaak: “Apar wina surusmaunka chikichkinkisha emegkaakchajai”, tusa tina nuna umiktasa, Jesúska tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Nuna tusa tai Simón Pedro, kuchiin takaku asa, kuchiirin juakug sacerdote apuri inatairin untsur kuishin awatti asankauwaiti. Nu shuara naarigka Malco tutai ajakuiti. ");
INSERT INTO hubNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Turakai Pedron Jesús chicharuk: “Kuchiirum jukim egketairmin egkeata. ¿Ameka, wina apar waittsati tusa turutmauwa nunaka umimainchauk enentaimturam?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Nuna tusa takai Romanmaya suntar aina, nita apuri, Yuus ememattasa iruuntai jean kuitamin ainajai, iruunturar Jesúsan achikar jigkararuiti. ");
INSERT INTO hubNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Turawar Anás Caifásan weari, nu uwítinka ni sacerdote apuri asamtai, Anása jeen ejéniaruiti. ");
INSERT INTO hubNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Nu Caifás judío ainan chicharuk: “Ashi shuaran ayamruk uwemtikratnuka chikichik mantamnatnaiti”, tusa tina nuwaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Jesúsan jukiar umainakai, Simón Pedro tura nina unuinatairi chikishcha ukunam pataas wuwaiti. Tuma jeanam Jesúsan awayainakai, nigka sacerdote apuri waintai asa, apu aarin pegkramunam Jesúsan awayawarmataisha nisha wayawaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Turasha Pedroka aag juakuiti. Tumamtai aa jiintuki waiti kuitamnun aujas awayawaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Turamtai waitin kuitamin Pedron iniak: “¿Amesha achikara juna unuinatairinchukaitam?” tusa tuina. Tama Pedro chichaak: “Atsaa, wika aunka wainchauwajai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Nuna tusa ikuak sacerdote apuri inatairi aina, Yuus ememattasa iruuntai jean kuitamin ainajai jina ikaparar anamainamunam Pedrosha tsetsek asamtai, nui jeaan anamuk wajau. ");
INSERT INTO hubNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Nuna tumainai sacerdote apuri Jesúsan jeari chicharuk: ¿Amina unuinatairmesha ya ainawa? ¿Tura nitasha wari jintinname? tusa iniasuiti. ");
INSERT INTO hubNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Tama Jesús ayak: “Wika ashi shuar antuinamunam chichauwajai, iruuntai jeanam, tura Yuus ememattasa iruuntai jeanam wayaancha jintinkartinajai. Tura ashi shuar aina iruunainamunmasha uuknaka chichatsuk paan iwainakan chichauwajai. ");
INSERT INTO hubNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Urukamtai winasha ininme? Winaka inintsuk wii chichaamun antuku aina nu, warina pachisa jintinkartina tusam iniasarta, nita wii timaunka shir nekainawai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Jesús nuna takai Yuus ememattasa iruuntain jean kuitamin chikichik shuar yapinam awatuk: “¿Ameka sacerdote apurig tu ainam?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Turam Jesús chicharuk: “Tuna pegkerchauncha chichaj nu ujatkata. Wii pegkerchaun chichatsaisha, ¿urukamtai awattame?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Nuna takai Anás, sacerdote shir apurin Caifás pujamunam akupeaksha jigkarmautak akupkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Nuna turuinai Pedroncha jina anamuk wajattamaun chicharainak: “¿Amesha shuaran achikara juna unuinatairinchukaitam?” tusa tuina. Nu tama Pedro chichaak: “Atsaa, wika aunka wainchauwajai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Tusa titatmaun sacerdote shir apuri inatairi, kuishin Pedro asankauwa nuna patai iniak: “¿Wii amina, númi arakmaunam nijai wajamin wainkachmakjam?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Nu tamasha Pedro ataksha waitrak: “Atsaa, wichauwaitjai” tai atash shinukuiti. ");
INSERT INTO hubNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Turawarmatai Jesúsan Caifása jeen pujaun jukiar, apu Pilato pujamunam yama tsawai ejéniaruiti. Tura ejéniar awayaawarmataigka, pegkerchau utsumakar jiisat Pascuatin yurumak yuachaij tuina asar, shuar ainaka wayacharuiti. ");
INSERT INTO hubNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Tumaina asarmatai Pilato jiinki wajas chichaak: “¿Jusha wari pegkerchauna takasu asamtai jutikarme?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Nuna takai nita chichainak: “Pegkerchaun takachkaigka juki itarmaitsujme”, tusar tuina. ");
INSERT INTO hubNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Tuinakai Pilato chichaak: “Atumek juka jukirum atum uruk shuar waitat suwa ainarme turusrumek waitkastarma”, tusa tinaiti. Takai judío apuri chichainak: “Ii judío ainatika Romanmaya apu ainatiram nu turatarma tichamu asar, shuarka maamain ainatsji. ");
INSERT INTO hubNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Jesús yaunchuk chichaak: Tu mantuatin ainawai timau uminu asamtai nunaka”, tiaru ainawai. ");
INSERT INTO hubNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Tuinakai Pilato nina jeen untsuk Jesúsan awayawaiti. Tura chicharuk: “¿Judío ainan apurim amekaitam?” tusa inia. ");
INSERT INTO hubNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Tusa tama Jesús ayak: “¿Nusha amek enentaimsamkek inintam, atsaa chikich aina wina pachitas turamiarmataig turutam?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Takai Pilato ayak: “¿Wii judíokaitaj? Amina pataim, sacerdote apuri ainajai, aminka juramkiar wini itarmarai. ¿Wari pegkerchauwa takasmam?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Tusa tamasha Jesús ayak: “Wina inamtairua nuka ju nugka juinchuiti. Wii juiya akaigka wina unuinatair aina judío achikarai tusasha maanimain ainawai. Tumamain ainayat juiyanchu asamtai inaitusarai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Nuna takai Pilato iniak: “¿Nuiyagka ameka apukaitam?” tusa tinaiti. Tusa tama Jesús ayak: “Ame turutam nuka nekasaiti. Wiyaitjai apunka. Wika chicham nekasa nuna etserkattsan, jui tana akinawaitjai. Ashi shuar chicham nekasa nuna uminaka wina aparu inamtairin pujusartinaiti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Nuna tu chichaakai Pilato iniak: “¿Nekasa nu tame nusha warimpaita?” tusa tinaiti. Nuna tusa ikuak Pilato aa jiinki Jesúsan itaawaru ainan apurin aujeak: “Wika ju shuar makumaku mantamnamaintrinka nekarachjai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Atum jiisat Pascua jeakaigka shuar achikmau tuke jiin ainarme. ¿Atumsha uruk enentaimrum, atumin apurinak akupkattaj? tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Tusa takai ataksha senchi ashi chichainak: “¡Nu shuarka akupkaipa. Antsu Barrabás jiikta!” Barrabáska magkartin ajakuiti. ");
INSERT INTO hubNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Nuna tuinakai Pilato Jesúsan asutiatarma tusa suntarnum surukuiti. ");
INSERT INTO hubNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Turamtai suntar aina jagki najanamun etsegkrumtikar jaanch yamakaitkaun anugkraruiti. ");
INSERT INTO hubNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Nuna turawar jeariar chichainak: Judío ainan Apuriya juke emematiarmi tuina, tuinak uwejejai yapinam awataina. ");
INSERT INTO hubNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Imatikainakai Pilato ataksha jiintuki nitan chicharuk: Ataksha jui itanmatai iistarma, wika ni makumaku mantamnamaintrinka nekarachmajai. ");
INSERT INTO hubNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Tusa Jesúsan untsuku, turam Jesúscha etsegkrutai jagki najanamun etsegkraku, tura jaanch yamakaitkau anugkramunka imanisag jiinkinaiti. Tumamtai Pilato chichaak: “Yamaika taayi, iistarma”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Tuma jiinkimtai sacerdote apuri aina, Yuus ememattasa iruuntai jean kuitamin ainajai iruunar senchi chichainak: ¡Achirtarma! ¡Achirtarma! amajaina. Imatainakai Pilato chichaak: “Imatrakrumka atum jukirum achirtarma. Wika ju makumaku mantamnamaintrinka nekarachmajai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Nuna takaisha achikaru aina chichainak: “Ii chicham umiktin aarmauwa turusrik umiakur, nisha Yuusa uchiriyaitjai tumamu asamtai, maamainaitji”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Nuna tusar tuinakai Pilato nuna antuk nu senchi ashamkau. ");
INSERT INTO hubNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Tuma nina jeen wayaa Jesúsan iniak: ¿Amesha tuiyampaitam? tusa tinaiti. Tusa iniamsha Jesúska aikchau. ");
INSERT INTO hubNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Tumakai Pilato chichaak: “¿Urukamtai winasha airtsume? ¿Wiki achirtarma takuncha tumainaitjam nu, tura nuna tachaknasha jiiki akupkatarma tusancha jiikin agkanmamtikmainaitjam nusha nekatsmek?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Nu tusa tama Jesús ayak: Wina apar turata tusa turamchakaigka, turumaitsume. Amina tunaurumka shir imanchauwaiti, antsu wina amini surutkara nu ainawai amina nagkatamas ima tunaurintin jasaruka, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Nuna takai Pilatoka Jesúsan itursanak jiikiaj tusa kakantu, tumakaisha shuar Jesúsa itaawaru aina senchi chichainak: “Ame nu akupeakmeka Romanmaya apu Césara nuna amikrigka achattame. Shuar nigki apua iman jumamuka Romanmaya apua nuna shuari jak tumamainaiti”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Nu tuinamun antuk Pilato, Jesús aa jiiktarma tina inaiyak, chicham iwarku ekeemtai hebreo chichamjaigka Gabatá tutainam ekeemsauwaiti. (Gabatá ta nunaka kayajai pachimra najanamu taku tawai.) ");
INSERT INTO hubNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Jiisat Pascua kashin atin ai, etsa tutupnistatuk jasa ai, Pilato nui ekeemas judío ainan chicharuk: “Pai yamaika atumin apurin jui itaajai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Nuna takaisha nitaka senchi chichainak: “¡Mantamnati! ¡Mantamnati! ¡Achirtarma! amajaina. Imatainakai Pilato chichaak: Atumin apurinkeash achiiratjarum”, tusa tinaiti. Tusa takaisha sacerdote apuri aina chichainak: Ina apurigka chikichka atsawai, chikichik apu César puja nuketi, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Tusa imatainakai Pilatosha, achirtarma tusa suntarnum suruk inaisau, turamtai nita Jesúsan jukiaruiti. ");
INSERT INTO hubNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Tura juam Jesús ni achintratin númi yapajia achirmaun juki yanaki jinkinaiti. Tuma nugka ukunch nain tutai, hebreo chichamjaigka Gólgota tutainam wuwaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Nui jeanmatai jimar kasan achirar, Jesúsan ajapeen achirar nenasaruiti. ");
INSERT INTO hubNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Turawarmatai Pilato tablanam: juka Jesús Nazaretnumia, judío ainan apuriyaiti, tusa tu aar Jesúsa chaikin anujkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Jesús yaaktanam tiiju achirmau asamtai, nuna tura aar anujkamtai, nukap judío aina nagkamainak aujaina. Nuka hebreo chichamnum, griego chichamnum, tura latín chichamnumsha aarmau ajakuiti. ");
INSERT INTO hubNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Nu turamu asamtai sacerdote apuri aina, judío ainan apuri ainajai Pilaton chicharainak: “Judío ainan apuriyaiti tusam aarum auka aitkatsuk, juka wika judío ainan apuriyaitjai tumamna nuwaiti tusam tu aarta”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Tuinakai Pilato chichaak: “Wii aarmaj nuka tumasag atatui”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Suntar aina Jesúsan achirarmatai, jaanchrin jurukiar cuatrowa imajin achiarar chiki chikichik tinamnaikaruiti. Nuna turawar patatek nugkutairi ajakua nunasha jukiaruiti, nuka yakini nagkama apara nugkani inagnakmau ajakuiti. ");
INSERT INTO hubNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Suntar aina nitak chichainak: “Nekas juka jaakcharmi, antsu yáki nepetmakat nu jukiti”, tusa tuina. Yaunchuk aarmau ajakua nuka tu uminkauwaiti. “Wina jaanchrun jukiar chiki chikichik tinamnaikarmayi, tura patatek nugkutairun yáki jukit tusar chikichik nakurutain nakuriarmayi”, timauwa nuna suntar aina metek umikaruiti. ");
INSERT INTO hubNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Jesúsa nukuri nina kai, Cleofasa nuwea nujai, chikich María Magdalena nu aina Jesús achirmaunam tiijuch jeantar wajaina. ");
INSERT INTO hubNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Tumainan Jesús nina nukurin wainkauwaiti, nina unuinatairi ni anetai ajakua nunasha wainkauwaiti. Tura nukurin chicharuk: “Nukuru, yamaika nu amina uchiram atatui”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Nuna nukurin tina, nina unuinatairi nekas ni anetairin chicharuk: “Wina nukurka amina nuku atatui”, tusa tinaiti. Tusa tama Jesúsa nukurinka nina jeen ni jukinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Nuna tina Jesús ashi umikjapi, tusa yaunchuk aarmaun umiktasa chichaak: Kitamajai tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Nuna takai suntar, muits shikapchichinam umutain vino churuin yara apujsamun, uruchjai inijar, númi hisopo tutain kanawejai ayai, takuri aapawaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Turam Jesús vino churuinnak mukunaa chichaak: “Ashi umikjai”, tusa tsuntsumaa jakauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Nunaka tsawan Pascua jeatsaig turawaru asar, nu tsawan ayamtaiya nuka nekas eme anentsa iitai asamtai, judío ainaka shuar numinam achirmau ainaka achirmaunumkeka acharti tusar tuina. Iman tsawaartin asamtai Pilaton chicharainak: “Shuar achiram netuina auna kagkajin kupirar, ashi kuerar yaruakarti suntar ishitkata”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Tusa tama suntarnaka imatiksag ishitkau, turam suntarsha shuar Jesúsjai ayaantsa achiram netuinan nekatkaun kagkajinaa kupirkar chikichnasha turusag kupirkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Nuna turawar Jesúsan jeantar iikma jaka netakai nunaka kupirtsuk inaisaruiti. ");
INSERT INTO hubNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Turawaru aig chikichik suntar nagkijai Jesúsan mijarnum ijuwaiti. Turam numpan entsajai puaruiti. ");
INSERT INTO hubNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Nunaka wika nekas wainkau asan etserjai, wainkachuitkunka etsermaitsujai. Wii wainai turawaru asarmatai, atumsha shir nekaarum nekaspapita titarma tusan ujajrume. ");
INSERT INTO hubNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Jesúsa ukunchin kupirkacharua nunaka, Yuusa chichamen etserin aarmaunam chichaak: “Chikichik ukunchinkisha kupirkachartinaiti”, timauwa nuna uminak turawaru ainawai. ");
INSERT INTO hubNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Yuusa chichamen etserin chikich aarmauwa nuisha chichaak: “Nagkijai ijumun wainkartin ainawai”, tusa tawai tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Nuna turawarmatai, José yaakat Arimateanmaya nisha Jesúsan nemaras weká jaku asa, judío apuri ainan ashamayat uumak Pilaton jeari chicharuk: Jesúsa iyashi jukin ikustajai, tusa tinaiti. Tusa tama Pilato chichaak: “Jukita”, tusa tinaiti. Tusa tama José we Jesúsa iyashin kueki jukinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nuna tura ai, Nicodemo yaunchuk Jesúsan káshi aujsattsa jearna nusha, treinta kilo kugkuin mirra, áloe tutaijai pachimramun takus jearnaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Nu jeaamtai Josésha nijai jimartuk Jesúsan iyashi jukiar, kugkuin itaamujai jaanchin ukatak, judío aina shuar jakau ikuaku turutainka metek umikar punuararuiti. ");
INSERT INTO hubNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Jesús achirmaunam ayaamas, númi arakmaunam shuar ikustin pampa yamaram taimu, chikichik shuarkesha ikuschamu au. ");
INSERT INTO hubNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Judío aina ayamtai tsawan ashi jeaa asamtai, ikumastin taimu tijuch amaunam nui Jesúsan ikusaruiti. ");
INSERT INTO hubNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Domingo tsawantin shir káshikmas, suamut aig María Magdalena Jesús ikusmaunam wuwaiti. Tuma jeari iiyajkama kaya uun apujtua ikukmau urani atatmaun wainkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Tuma Simón Pedro pujamunam tsekegki jeawaiti, Jesúsa anetairi ajakua nusha nui pujau asamtai chichaak: “Ina apurinka jukiarai, turasha tuintsuk ikusara nekachjai”, tusa nitan ujakuiti. ");
INSERT INTO hubNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Tusa takai Jesúsa anetairi ajakua nu, Pedrojai jiinkiar Jesús ikusmau iismi tusar wearu ainawai. ");
INSERT INTO hubNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Tsanig tsekeayat Pedron nagkaiki Jesús ikusmaunam niyaa jeawaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Tumasha, Jesús punuarmauka jaanch imanisag akai, ututsuk ayatik tekena ii wajatu. ");
INSERT INTO hubNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Tuma wajai Simón Pedro ukunam tawaitiat Jesús ikusmaun utuawaiti. Tura Jesús punuarmauka jaanch imanisag atatmaun wainkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Nuiyasha Jesúsa muuke jaanch pununtramuka nushaa akanka shir apijra aepkimun wainkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Nuna tumai niyaa emki jeawa nusha ukunam wayawaiti. Tuma nisha wainkauwaiti, tuma nekaspapi nantakia tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Nitaka Yuusa chichame aarmaunam Jesúska maamsha nantaktinaiti tusa timauwa nunaka enentaimtuinachu. ");
INSERT INTO hubNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Nuna tuman wainkar ikuinak nita jeen waketkiaru ainawai. ");
INSERT INTO hubNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Nu tumaig Maríaka ataksha Jesús ikusmaunam útkamaikia waketki ayaamas wajas nui tekeema iiyajkama, ");
INSERT INTO hubNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","nayaimpinmaya shuar jimar jaanch pujun nugkuaru Jesús mukmamtika aepsamu ajakmaunmani chikichik eketai, chikichka Jesús nawemtika aepsamu ajakmaunmani eketun wainkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Nu tuma eketaina ininak: “Umaaru ¿urukamtai útme?” tusa tuina. Tusa tama ni ayak: “Wina apuru iyashin jurutkiarmatai, tuig ikusarma tusan nekachu asan útjai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Nuna tusa ayanmakma shuar wajattamaun wainkau, turasha Jesúsapita tusagka nekachuiti. ");
INSERT INTO hubNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Turamaitiat Jesús nina iniak: “Umaaru ¿urukamtai uutusha wajame? ¿Ya eame?” tusa tinaiti. Nu tusa tama ni enentaimsagka juka númi arakmaun kuitamnutskaitti tau asa chichaak: “Umaaru, ame Jesúsa iyashi jukinaitkumka ujatkata. Tui ikusum, nu ujatkakmin wii jukitjai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Tusa tama Jesús chicharuk: “¡María!” tusa tinaiti. Nu tusa tama Maríasha ayanmata iiyak hebreo chichamjai: “Raboni”, tusa tinaiti. (Nunaka unuikartina) taku tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Nuna taku achiktaj tama Jesús chichaak: “Achirkaipa, eke wina aparui weatsjai. Antsu wina yatsur matsatmaunam wetá, tumam yamaika wina Apar tura atumnasha Apariya nu, ina Yuusri pujamunam weajai turammarme tusam ujakarta”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Nu tusa tama María Magdalena, jeaa nitan chicharuk: “Wii nekas ina apurinka wainkajai”, tusa Jesús akatmamramunka Jesúsa unuinatairi ainan ashi ujakuiti. ");
INSERT INTO hubNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Nu tsawantaik etsa akai domingotin nina unuinatairi aina judío ainan ashamainak waiti shir epeniar matsatainaig pachiachmau Jesús wayawaiti. Tuma ajapeen wajan chichaak: “Yuus agkan shir enentaimsa pujutan atumnasha amasti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Nuna tina uwejen, tura mijarincha nitan inaktusuiti. Nu turam nina unuinatairi aina nita apurin wainkar shir aneasaru ainawai. ");
INSERT INTO hubNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Nuna tura iwaintuk Jesús ataksha nitan chicharuk: “Yamaika sapijmatsuk shir enentaimsarum agkan pujustarma. Wina apar jui akuptukua aitkasnak wina aparu chichame nekasa nu jintiatarum tusan atumnasha akupeajrume”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Nuna takug nitaini umpumi chichaak: “Yamaika Wakan Pegker jukitarma, nu senchimtikramattarme wina aparu chichame jintiamunmasha”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Atum ju nugka jui wina aparu chichame jintiakrumin, shuar nuna antuk nekaspapita tusa tunaurin etsertumakmatai atumsha chichaakrum: “Yuuscha yamaika amina tunaurminka tsagkurtamrayi titinaitrume. Antsu shuar tunau takatan inaitan nakitakaigka chicharkurum: Yuus tsagkurtamrashtinaiti tusarum titinaitrume”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Nu Jesús tuma wayaamunmagka Tomás Jimamramu tutaiya nuka atsau asa wainkachuiti. ");
INSERT INTO hubNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Tuma asamtai Jesúsan wainkaru aina chichainak: “Apu wainkamji”, tusar ujaina. Tama Tomás chichaak: “Wika Jesúsa uwejen clavojai ajintramun wainkan, mijarnum nagkijai ijuarmia nunasha uyuraan iisan nekaspapi nantaknia tusan tumainaitjai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Nuna tinu ai chikich domingotin, Jesúsa unuinatairi aina ashi iruuntraruiti, nuigka Tomáscha pujau. Waitinka shir epeniar pujuina, tumainai ataksha Jesús wayaa ajapeen wajas nitan chicharuk: “Yatsuru, matsatrumek”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Nuiyasha chichaak: “Tomása, jui tantam yamaika uwejur shir iirtusta, tura mijarusha uyuata, tumam yamai nagkamsamka iturchat enentaima pujutsuk nekaspapita turutta”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tama Tomás ayak: “Wina Apuru, ameka wina Yuusruitme”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Nuna takai Jesús nina chicharuk: “Tomása, ¿yamai wina waitkamek nekaspapita turutam? Wina waittsuk nekaspapita turutainaka shir aneasartinaiti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jesúska nuiyasha shuar aina nutikmainchaun ashi iwainak nina unuinatairi aina wainmaunam nukap takasuiti. Turasha nuka ju papiinumka ashika aarchamuiti. ");
INSERT INTO hubNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Tumaig juka atumsha Jesúska Cristo, Yuusa uchirimpapita, tusarum nekaspapita takurum, pujut tuke atina nu jukimnuram tusa aarmauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Nuna tina inais ataksha chikichik tsawantin Jesús nina unuinatairi ainan nayants Tiberiasa tsukintrin matsatun wantintukuiti. Nuigka juni wantintukuiti: ");
INSERT INTO hubNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Nui Simón Pedro, Tomás Jimamramu tutai, Natanael Caná Galileanam a nuiya, Zebedeo uchiri aina Santiagojai, tura chikich jimar Jesúsa unuinatairijaimak iruuntrar matsataina. ");
INSERT INTO hubNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Tumainan Simón Pedro chicharuk: “Namakan redjai achiktajai tusa takai, iijaimak wearmi”, tusa tuina. Tusa botenam chumpimrar shiakaruiti, tumawar káshi redtan nagkimainaksha pegkesha achikcharu. ");
INSERT INTO hubNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Tuma yama tsawai Jesús namaka yantam wajau, tumakaisha Jesúsapita tuinachu. ");
INSERT INTO hubNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Turamaitiat Jesús nitan untsuak: “Uchir ainata, ¿namakka achikchaurmek?” tusa tinaiti. Takai nita chichainak: “Chikichkiksha pegke achikchaji”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Tusa tuinakai Jesús chichaak: “Yamaika untsurnumani redtrum nagkimatarma. Turakrum namak achirtattrume”, tusa tinaiti. Tusa takai nagkimawar namakan nukap achirar jiiktajkama tujinkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Nui Jesúsa nekas anetairi ajakua nu Pedron chicharuk: “¡Auka apu Jesúsaiti!” tusa tinaiti. Takai nuna antuk nugkutairin awiik ikusmaurin juki nugkur entsanam iyagkuiti. ");
INSERT INTO hubNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Chikich ainaka namak achimraun japisar botenam wena, anumkatin cien metros au asamtai, japisar we wenakua tsukin anumkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Tumawar kukar jiinkama ji ikaparmaunam chikichik namak jiamu panjai aun wainkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jesús nitan chicharuk: “Namak achiruram nu ishichik itatarma”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Nuna takai Simón Pedro namak uun ainan ciento cincuenta y tres achirmaun japiki kukar jiiknaiti. Iman chumpimkusha rednaka tsuriarchauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Nuna jiikmatai Jesús chicharuk: “Jui taarum yurumak yuatarma”, tusa tinaiti. Nuna takaisha juka apuapita tuina asar, chikichkiksha amesha yaitam tusarka iniascharu ainawai. ");
INSERT INTO hubNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jeawarmatai Jesús pankan namakjai juki tinamkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Nunaka Jesúska maamu nantaki tresa imajnia nina unuinatairi ainan wantintukuiti. ");
INSERT INTO hubNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Nuna yurumkan yuawarmatai Jesús, Simón Pedron iniak: “Simónka, Jonásan uchiriya ¿winasha namak achiruram au nagkasamek anentam?” tusa tinaiti. Tama Pedro ayak: “Ee apuru, ameka wii aneajam nuka nekame”. Tusa takai Jesús chicharuk: “Oveja kuitamkur ayurtaiya numamtuk, wina nekaspapita tusa nemartuina nusha jintintawarta”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Tusa ataksha iniak: “Simónka, Jonásan uchiriya, ¿winasha anenmek?” tusa tinaiti. Tama Pedro ayak: “Ee Apuru, ameka wii aneajam nuka nekame. Takai Jesús chicharuk: Tumakmeka oveja kuitamkur ayurtaiya numamtuk, wina nekaspapita tusa nemartuina nusha jintintawarta”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Tusa ataksha iniak: “Simónka Jonásan uchiriya, ¿winasha anenmek?” tusa tinaiti. “Tama Pedro tresa imajnia winasha anenmek tamau asa, wake mesekuiti”, nu tamasha Pedro ayak: “Apuru, ameka wii aneajam nuka ashi nekame”. Tutai Jesús ayak: “Oveja kuitamkur ayurtaiya numamtuk, wina nekaspapita tusa nemartuina nusha jintintawarta. ");
INSERT INTO hubNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Nekas tajame, ame natsach asamka, amek nugkuram ame wakeramunam weká jakuitme, turasha ame untach jasaakminka, kunturam nakuekakmin chikich anugtamrar ame wetaj tachamunam juramkiar umatmartinaiti. Nu nunis atin akaisha wii wakeramu umirtukta”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Nunaka Pedro ni mantamnaku Yuusan shir enentaimtiksatna nuna taku tinaiti. Nuna tina inaiyak: “Nemartukta”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Tama Pedro ayanmakma Jesúsa anetairi, chikich tsawantin yurumak yuamunam ninii ayaamas pujau asa iniak: Apuru, yaita amina surutmaktincha tusa iniasua nu winittamaun wainkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Tura Pedro nuna pachis Jesúsan iniak: “Apuru, ¿jusha urukatnaita?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Tama Jesús ayak: “Wii wakeraknaka iwákuk pujaig taatin atajai tumainaitjai. ¿Amesha nusha urukamtai uyumame? Ameka nemartukta, tumakum wii wakeramu umirtukta”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Nu tamaun Jesúsa unuinatairi chikich ainasha antukaruiti. Tumawar “nekas jakashtinaiti tawapi”, tusa tuina. Turasha “Jesúska juka jakashtinaiti” tusagka tichauwaiti. Nigka “wii wakeraknaka iwáku pujaig taatin atajai tumainaitjai, amesha nusha urukamtai uyumame”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Junaka Jesúsa unuinatairi ajakua nu, ni wainkamuri ainan pachis ashi aaruiti. Tura asamtai nuka nekaspapita tusa tuinaji. ");
INSERT INTO hubNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jesús takasmausha nukap awai, nu chiki chikichik pachisa aamka ju nugka juigka aya papik aimnamainaiti. Maake nunis atii.");
INSERT INTO hubNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Teófilo, wina anetairu, wii yama nagkamchakun papiin aatramiajam nunaka Jesús nayaimpinam wakettsuk jui pujusa takasmaurin, ashi ni unuikartu jakmaurijai pachisan ujakun aatramiajme. Nayaimpinam wetatuk pujus, ni wina chichamur etserturkatarma tusa ishiaktin aina etegkramun chicharuk: Jutika takastarma, tusa Wakan Pegker turata tamau asa, jintintawaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Jesús waitkasa maam nantaki nina chichame etserkatin etegkramu ainan iwáku paan wantiintukuiti. Tura wantintuk cuarenta tsawan Yuusa inamtairin pachis jintintuk pujusuiti. ");
INSERT INTO hubNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Nui nina unuinatairi ainajai iruunar pujus, Jesús nitan chicharuk: “Jerusalénnum nakastarma, nui nakarmin wina Apar Wakan Pegkeran amastajrume tusa anajmatramamu ujakmajrum nuna amasarti. ");
INSERT INTO hubNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Juanka entsajai imakratujakuiti, turasha wina Aparka atumnaka Wakan Pegkeran amastatrume”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Nuna tusa takai nina unuinatairi aina ininak: “¿Apuru, Israel shuar ainati apuri yamaikiash atam?” tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Tuinakai ni chichaak: “Atumka nuka nuiyapi atatua tusarmeka nekamaitsurme, nunaka wina aparuk nekawai, nu tsawan jeaakai turumainaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Antsu ni Wakan Pegkeran amastatrume, turutmawarmatai atumsha nuna senchiri jukirum, jui Jerusalénnum, Judeanam, Samarianmasha, tura ashi chikich nugka ainanmasha wina pachittsarum etserkatarma”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Nuna tina Jesús nayaimpinam weak, nitasha iima irunaig agkarunam takunnaiti. Tuma ishichik yakiantaig yuragkim ajakuiti. Turamtai atak awenagka wainkacharuiti. ");
INSERT INTO hubNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Tumawar iiyak wajainai, jimar shuar jaanch pujun nugkuaru nitain ayaamas wajasuiti. ");
INSERT INTO hubNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Tuma nitan chicharuk: “Galileanmaya shuar ainata, ¿urukamtai nayaimpisha iisha wajatrume? Yamai Jesús nayaimpinam weak takunin wainkaurum antsag atak taksha taattawai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Nu tusa tama Olivosa naintrin matsatu Jerusalénnum waketainak, sábado tsawaarmataigka, chikichik kilómetro nagkasarka wekachatai atii tusa chicham umikmau asamtai, jinta tutupnik chikichik kilómetro Jerusalén jeaantunam nunii waketkiaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Tuma jeawar jea jimaraa ekeni jeamkamunam nui tuke iruunin asar utsaniaruiti. Nui wakarua nuna naarigka ju ainawai: Pedro, Juan, Jacob, Andrés, Felipe, Tomás, Bartolomé, Mateo, Jacob Alfeo uchiri, Simón maanitnak wakerin ajakua nu tura Judas Jacobo yachi. ");
INSERT INTO hubNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Nui tuke iruunin asar, Yuusan aujsattsa iruunainak, Jesúsa yachi ainajai, Jesúsa nukuri Maríajai, nuiyasha chikich nuwa ainajaimak ashi metek iruuntraruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Nuna inagkaki pujusar, chikich tsawantai ciento veinte shuar Jesúsai surumankau aina iruuntramunam Pedro wajaki chichaak: ");
INSERT INTO hubNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Yatsur ainata, yaunchuk Wakan Pegker aarta tama David aak, shuar Jesúsa suruk menaktinaiti, tumamtai nu shuar ajakmaunam chikich wayaatnaiti ta nu yamai uminu asamtai, Judas menakmaunmasha yáki yapajinat nu iismi. ");
INSERT INTO hubNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Nu shuarsha ijai metek unuinajakmauwaiti, takatnasha tumasag ijai iruunas takayayi. ");
INSERT INTO hubNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Tumauwaitiat tupar wekaas Jesúsan suruk, kuitan juki, nu kuit jukimun awaigki ikuak we suwenam jigkaama, tsurimak achapai iiyak ampujen apujkauwaiti. Nu tumamtai sacerdote aina nu kuit pegkerchau takak jukimu awaigki ikukmaujai nugkan sumakaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Tuma Judas jakamtai, Jerusalénnumia shuar aina antukar nu nugkan nita chichamejai Acéldama anaikaru ainawai. Nunaka Numpa Nugka taku tuinawai. ");
INSERT INTO hubNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Nuna tumawa nunaka yaunchuk David Salmosan aak: “Nina jeegka itarak atinaiti, chikichik shuarkesha nuigka pujuschatnaiti, ni takatrinka chikich takastinaiti” tusa tina nu uminkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Nu timau asamtai chikich eamainaitji. Turasha nuka Juan Jesúsan imaina nui nagkamas tuke Jesúsjai wekaas ni nayaimpinam weakai juakarua nuiya amainaiti. Tumau ima shir Jesús maamu nantakmaurin pachischa ijai metek etsermainaiti, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Nuna tusa Pedro takai, José Barsabás tutai Justo tuuta amajtaiya au atii tuina. Tura chikich chichainak: Antsu nekas Matías atii tuina. ");
INSERT INTO hubNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Nuna tuinakai Yuusan aujainak: Apuru, ame chiki chikichik nita enentai waitme, tura asam yaita ame shuar etegkamusha nu juwaiti tusam titá tuina. ");
INSERT INTO hubNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Judas Jesúsan unuinatairiyaitiat ni tunaurinig takatrin ikuak, ni waittsatnunam wuwaiti tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Nuna tusa yana kayarig jiinkit nu atii tusar nekaattsa, José kayarin Matíasa kayarijai egkea peararuiti. Nu turamunam Matíasa kayari jiinkinaiti. Tumamtai Jesúsa unuinatairi menakmaunam awayawar metek jasaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Tsawan jiisat Pentecostés tutai tsawaarmatai, Jerusalénnum nita iruuntairi jea aunam Jesúsai surumankau ainaka ashi iruuntraruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Tuma nui utsaniar iruunkama nase winak uruka imatuk senchi uutun nayaimpinmayan antukaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Nu imatmaunmaya jiya numamtin keek nui irununka chiki chikichik shuara muukeen ekeemturu. ");
INSERT INTO hubNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Tumamtai Wakan Pegkersha tumasag ashi shuaran egkemturuiti. Turawaram yaunchukka chikich chichaman chichachu ainayat, Wakan Pegker chichamtikmau asar chichaina. ");
INSERT INTO hubNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Tumainakai judío aina chikich nugkanam matsamin ainasha nu jiisat asamtai, urukainakug imataina tusar nekaawartasa Jerusalénnum iruuntraruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Tuma iruuntrar antukma chikich iruuntraru aina chiki chikichik nita chichamejai chichainan antukar enentain jearcharuiti. ");
INSERT INTO hubNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Tumawar chichainak: “Ju shuar ina chichamen chichaina juka Galileanmaya ainawai. ");
INSERT INTO hubNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Tumau ainayatcha ¿itursaya imatiksasha ina chichamencha chichainawa? ");
INSERT INTO hubNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ika chiki chikichik nugkanmayati iruuntrarji, antsu chikich aina auka: Partianmaya, Medianmaya, Elamnumia, Mesopotamianmaya, Judeanmaya, Capadocianmaya, Pontonmaya, Asianmaya, ");
INSERT INTO hubNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frigianmaya, Panfilianmaya, Egiptonmaya, nuka nitaka Libia yaakat Cirene tutaiya nuna nagkaikiar jeashat matsamin ainawai. Tura chikichka irainak Romanmayasha kaunkarai. ");
INSERT INTO hubNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Judíoke, antsu chikich ainaka judío weantuke ainawai. Cretanmaya ainasha Arabianmaya ainajai kaunkarai. Isha Yuus pegker takasmauri ainan pachisar etseraina nuka shir antuinaji. Aitkasag chikich ainasha nita chichamen etserainakai shir antuinawai. ");
INSERT INTO hubNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Nuna tusar enentai jeachar, ¿urukakug ainkara? tunaiyaina. ");
INSERT INTO hubNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Nuna tusa tuinakai, chikich shuar nusha nui irunuk, tukeneas wishikainak: Namperara jama”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Nuna tusa tuinakai Pedro Jesúsa unuinatairi chikich ainajai iruuntrar eketu wajaki senchi chichaak: “Judío ainata, tura Jerusalénnum matsamin ainata, wii etserkai shir antuktarma”. ");
INSERT INTO hubNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Nampekarai tukartarme, turasha ika nampekcharji, yamaika eke kashikiti. ");
INSERT INTO hubNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ii juniaj juka yaunchuk Yuus tumatnaiti timaun Joel etserkamua nu uminkai juniaji. Juna pachis Joel Yuus tawai tusa aak: ");
INSERT INTO hubNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“Nugka mesertin jeattak jakaigka, Wakan Pegkeran ashi nugkanmaya ainan akuptuktinaitjai. Turamu asar atumin uchiri, tura atumin nawantri ainasha wina pachittsar etseriartinaiti. Natsa ainanka paantak iwaintakun, untach ainanka karanam iwaintuktinaitjai. ");
INSERT INTO hubNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Wakan Pegkeran wina nemartin aishmag ainan tura nuwa ainajai metek akuptuktinaitjai. Turamu asar wina pachittsar etseriartinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Nayaimpinmayan ashammainan iwaintuktinaitjai. Tura nugkanmasha maaniaku numpa ukamu, yaakat aestuniamu ji senchi mukuintamujai atinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Nu imatiknaiyamunam etsa etsantrashtinaiti, nantusha numpa kapantua imanu jastinaiti. Nu imanikmaunam Yuus ni etegkramu ainan, shuar waittan jukitin ainajai akaneamu atinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Turasha ashi shuar apu Jesúsan aujainaka uwemrartin ainawai”. ");
INSERT INTO hubNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Israelita ainatirmesha wii chichakai antuktarma: Jesús Nazaretnumia Yuusa senchirijai atum wainchatai ainan iwainak takakmasua nuna pachisan ujaktatjarme. Yuus nu shuaran atumsha wainmaunam pegkeran takamtiksauwa nuka atumka shir nekarme. ");
INSERT INTO hubNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Imatika iwainamu wainiayatrum atumka achikrum, numinam achirar maawarti, tusarum shuar tunau ainanam surukuitrume. Atum ni turam atintrinka Yuuska yaunchuk nekaawaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Turawakrumnasha Jesúsnaka jamua nuka nepetmainchau asamtai, Yuus ninka ataksha inankinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Davidcha Jesúsan pachis aak: ‘Wina apurka tuke wijai pujaun wainjai. Tura wina untsuruini ayaamrutas pujurtau asamtai, chikichkiksha winaka pegke awaktumaitsui. ");
INSERT INTO hubNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Tuma asamtai wina enentairui shir aneasan nakunkut pujajai. Chichaknasha shir aneasan chichaajai. Tura mantuawarmataisha nantaktinapitja tau asan, shir aneasan pujajai. ");
INSERT INTO hubNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Wina wakantruka ikukrattainmagka ameka inaitursashtinaitme. Tura wina inatair Pegkera nuka kaurtii tusamka wina iyashruka inaitursashtinaitme. ");
INSERT INTO hubNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ame jinta tuke pujustinnum jea nu inaktursauwaitme. Turutam ame wini pujau asaakmin, shir aneasan pujajai. Tura amijai pujaknaka, tuke pujustinaitjai’. ");
INSERT INTO hubNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Yatsur ainata, ii ainatika ina uuntri David ajakua nu jakamtai, ikusmauwa nuka shir nekaji. Nu ikusmauka yamaikisha wainmainaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Davidka Yuusa chichamen juki etserujakuiti. Tumau asa ni weantunam akina apuma pujustinnaka Yuus tumatnaiti tusa ujamu asa nekajakuiti. ");
INSERT INTO hubNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Nu tusa ujam nekau asa, Criston maawarmatai, ikusmaunmayan Yuus iwaatsuk inankim iyashi kaurchatnuncha tumatnaiti tusa etserujakuiti. ");
INSERT INTO hubNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","33","Jesúska ashi wainkaru asar, Yuus inanki yaki nayaimpinam iwak, ninii ayaanas ekentsauwa nuka shir nekainaji, ni nayaimpinam wakettsuk chichaak: Wina Apar Wakan Pegkeran akupturmaktatrume tusa tinaiti. Nu timauwa nuna Yuus akupturmamu Wakan Pegker winamu antukurme, yamaika wainkaurme. ");
INSERT INTO hubNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Nayaimpinam wakauwa nuka Davidchauwaiti, antsu Cristowaiti. David junasha chichaak: ‘Yuus wina Apurun wina untsurui ekeemsata, ");
INSERT INTO hubNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","tumawakmin wii amina shuarum ainan ashi nepetkan amini yaruakan ikankatjai’, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","David tina nunaka apu Jesúsan pachis taku tinaiti. Ashi ii Israel shuar ainatika shir nekamain ainaji, atum maawaitrum nuna Yuus: Ju apu Cristo atii tusa apumtikawaiti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Nu tamaun antukar senchi wake mesemar enentaimrar, Pedron chikich Jesúsa unuinatairi ainajai ininak: “Yatsur ainata, ¿turasha isha urukmainaitji?” tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Tuinakai Pedro ayak: “Atum ainatirmesha chiki chikichik pujutrum Yuusjai iwaratarma. Tumakrum Jesucristo enentaimtusrum maitarma. Tumakrumin Yuus tsagkurtamar Wakan Pegkeran amastatrume. ");
INSERT INTO hubNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Nunaka atumnasha yaunchuk anajmatrama asa turutmattarme, atumi uchiri weantuncha tura chikich shuar Yuus ni etegkramu, jeashat chikich nugkanam matsatuncha turusag akuptuktinaiti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Nuna tusa tina chikichnasha chicharkartak: “Jesúska Yuusa uchirimpapita tichau aina waittsatin aina atumsha nuninka atsuk, nekaspapita takurum uwemratarma”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Pedro tamaun antukar nekaspapita tusar nukap shuar maakaru ainawai. Nuna tumawarmatai Jesúsai surumankau aina nu tsawantaik tres mil shuar jasaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Jesús wina chichamur etserkatarma tusa akupkamu aina jintintam, nitasha nuna umina asar, chikich ainajaisha shir anenainak nitanu ainancha sunaiyaina. Nuna tumainak Yuus iruuntra aujsarmi, tumaku Jesús winak enentaimtursarum yuatarma timauwa nusha turawarmi tusar iruunaina. ");
INSERT INTO hubNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Jesús wina chichamur etserkatarma tusa akupkamu aina Yuusa senchirijai wainchatain iwainakar takainakai, shuar ainaka enentai jearcharuiti. ");
INSERT INTO hubNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Tumainak Jesúsai surumankau ainaka ashi metek enentaimaina, tumaina asar nita atsumainamun iknaikar sunaina. ");
INSERT INTO hubNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Nuna turunaina asar, nita waríri ainanka surukar, nu suraku kuit jukimun nita atsumaina susami tusar ikaanaina. ");
INSERT INTO hubNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Tumainak kashi kashinig Yuus ememattasa iruuntai jeanam iruun, tura nita jeencha iruun jaina. Imaninak Jesús yuamu turusrik isha yuawarmi, tusar shir anenaisar yutain yuina. ");
INSERT INTO hubNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Yuusan imatikas emematainakai, chikich shuar ainasha Jesúsai surumankau ainan shir anentaina. Tumaina asarmatai Yuuscha shuar uwemkartin ainanka kashi kashinig ikawea. ");
INSERT INTO hubNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Chikichik tsawantai Yuus aujtai jeau asamtai, aagkuantai Pedro tura Juanjai Yuus ememattasa iruuntai jeanam wearuiti. ");
INSERT INTO hubNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Nuna jea waitiri naari Shiram tutai ajaku. Nu waitinam shuar wekaichun tuke tumauk akinan juki, jui pujus shuar utsaniartai kuitan seamti, tusar tuke apujin asar itaawar apujkiaruiti. Turam nui pujus shuar utsaniartai kuitan seama pujau. ");
INSERT INTO hubNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Tuma pujau asa, Pedro tura Juanjai winittamaun wainak, kuit antramek surusta tusa uwejen inaktau. ");
INSERT INTO hubNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Turam Pedro nuna wainak chicharuk: “Iimsata”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Tusa tama wekaichusha surustatkumpapi turutua tu enentaimas ii pujau. ");
INSERT INTO hubNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Tu enentaimu ai Pedro chicharuk: “Kuitruka atsurtawai, tura orosha atsurtawai, turasha wii tumain aruta nuna tajame: Jesucristo Nazaretnumiaya nu pegker amajtamu asamtai, wajakim wekasata”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Nuna tusa taku uwejnum achik awajkinaiti. Turam nawesha tura wanusesha pegker jasaru. ");
INSERT INTO hubNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Tuma tsekegki wajaki nitajai iruuntrar Yuus ememattasa iruuntai jeanam wayaattsa weak, tsekeas nekapki wea. Imaniak Yuusnasha emematu. ");
INSERT INTO hubNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","10","Nu tuman chikich shuar wainkar, yaunchukka waitinam pujaun tuke wainin asar ashamainak: ¡Itursaya ausha pegkersha jasa! tusar enentai jearcharu. ");
INSERT INTO hubNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Tumainakaisha shuar wekaichu pegker amajsamuka Pedronka Juanjai akupkachu. Tuma asamtai Pedro tura Juanjai nu shuar pegker jasua nujai, Yuus ememattasa iruuntai jea Salomón tesamu tutainam pujuttamaun, shuar aina tsekegki kautkar enentai jearchar ii wajataina. ");
INSERT INTO hubNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Imatikam Pedro nuna shuaran chicharuk: “Israelita ainata, ¿urukamtai imanikrumsha iikratrume? Juka iikka aitkachji. Ii ima pegker asar aitkaji tutaksha tumaitsuji. ");
INSERT INTO hubNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Junaka ina uuntri Abrahaman, Isaackan tura Jacobon Yuusri yamaikisha ina Yuusriya nu, wina inatairun Jesúsan juna wainainak emematiarti tusa aitka pegker amajsayi. Turasha atumka maawarti tusarum apu ainanam surukuitrume. Turawakrumin apu Pilato akupkatjai takaisha, nakitrau ainarme. ");
INSERT INTO hubNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Antsu shuar pegker, tura tunau takachu ayamrutsuk, shuar magkartin ayamrakrum jiiknaitrume. ");
INSERT INTO hubNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Nu turakrum Jesús pujutan sukartina nu maawaitrume. Atum turawakrumin Yuus ataksha inankina nuka ika wainkaru asar, ashi shir nekainaji. ");
INSERT INTO hubNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Nu Jesúsak nekaspapita tusa enentaimtuinamunam ju shuarka pegker jasai. Atumsha ju shuar pegker jasa juka waintrume. Shuar nekas Jesucristowapita wina pegker amajtumainka tusa ninak shir enentaimtauka junii pegker jawai. ");
INSERT INTO hubNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Wina yatsur ainata, atumin apuri aina Yuusa uchirimpapita tusa nekatsuk maa aina nunaka wika shir nekajai. Atumsha nuka nekaachu ainarme. ");
INSERT INTO hubNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Jesúsan turawarua nunaka yaunchuk Yuusa chichamen etserin aina ashi etserainak, Cristonka waitkasartinaiti tiaru aina nuna umirkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Tuma asamtai ni atumin tunaurincha tsagkurtamrachaintrumeash, atumi tunauri inaiyakrum Yuus nemarkatarma, tumakrum chiki chikichik atum ainatirmesha Yuusa tsagkurturta tusarum titarma. ");
INSERT INTO hubNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","21","Jesucristo ataksha ni taamurinig nigka nayaimpinmag pujustinaiti. Tuma yaunchuk Yuusa chichamen etserin aina tumatnaiti tiaru aina nu uminkatnaiti. Ashi warí ainan Yuus yamarmamtikatnaiti. Tura ni chichaak: Yamaika ashi yamaram amajsajai tusa takai Cristosha taatnaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Tura junasha Moisés ina uuntrin chicharuk: ‘Apu Yuus atum ainarum nuiyan chikichik shuaran wina chichamur etserin atá, tusa wina iturtukuita turusag etegkatnaiti. Nu Yuus turamu chichaakaigka nuke umirkatarma. ");
INSERT INTO hubNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Antsu nuna chichamen umirtsuk pujauka Israel shuar ainajaisha iruuntrashtinaiti’, tusa Moisés tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Yuusa chichamen etserin Samuelsha aitkasag tinaiti. Tura Yuusa chichamen etserin chikich aina chichainaksha, yamai tsawanta juna tiaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ii ainatika yaunchuk Yuusa chichamen etserujakarua nuu weantu ainaji. Pujut pegkera nuna jukitin arti turamu asa, Yuus ina uuntrin Abrahaman anajmatuk: ‘Amina tiragkrum weantu aina ju nugka jui matsamin ainanka pegkernum yainkartinaiti’, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Yuus nina uchirin maawarmatai inankina nunaka atumin pegker amajtamsarti tusa turawaiti. Turamu asar tunaurincha inaisar pegker jasarti tusa emtika akupturmakuitrume”. ");
INSERT INTO hubNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pedro Juanjai shuar iruuntramunam chichaa wajai, sacerdote aina, Yuus ememattasa iruuntai jean kuitamnun apuri, saduceo ainajai kautkaru. ");
INSERT INTO hubNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Tumawar Pedro Juanjai shuar iruuntraun chicharuk: Jesús maam nantakna tumasarag shuar ainasha nantartin ainawai, tamaun antukar senchi kajerkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Tumawaru asar, achikar jukiar cárcelnum egkeawaruiti. Turawar kia asamtai, kashin chicham nekarami tusar ikukiaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Pedro chichaman etserkai, antuinaka nukap shuar nekaspapita tiaruiti. Tumaina asar Jesúsai surumankau ainaka, aya aishmagkuk nekapmaram cinco mil shuar jasaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Kashi tsawak judío apuri aina, tura uun aina, tura chicham umiktinan jintinkartin ainajaimak Jerusalénnum iruuntraruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Tura sacerdote apuri Anás, chikich sacerdote ainasha, Caifás, Juan, Alejandro tura sacerdote apuri patai ainasha iruuntraruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Tuma Pedron Juanjai jui itatarma tusa shuaran akuptukaruiti. Tura Pedron Juanjai itantarmatai, ajapeen awajsar chicharainak: “¿Yana senchirinia jusha aitkarme?” tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Nu tusa iniam Pedrosha, Wakan Pegker chichamtikmau asa chichaak: “Apu tura uun ainata: ");
INSERT INTO hubNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Atumka shuar wekaichu pegker jasmatai, yáki nekas pegker amajsa tusarum, nekaattsarum wakerarme. ");
INSERT INTO hubNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Israel shuar ainasha ashi nekaawarti tau asan, yamai shir ujaktajrume. Ju shuar wekaichu pegker jasa junaka, atum Jesucristo Nazaretnumia numinam achiirum maawakrumin Yuus inankina nu, junaka aitka pegker amajsayi. ");
INSERT INTO hubNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jea jeamin kaya etegkar: Juka pegkerchauwaiti tusa ajapna numamtuk atum ajapawaitrume, turasha Jesúska yamaika ni nekas jea naintiya numamtin jasai. ");
INSERT INTO hubNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ju nugka juigka chikich uwemtikartumainka pegke atsawai. Yuus chikich anaika, shuar juna nemarainak uwemrarti tusa akupkamuka atsau asamtai, ima nigkiti”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Pedro tura Juanjai tu chichainakai, apu ainasha enentai jearcharuiti. Tumawar chichainak: ¿Urukakug imanik yachachu ainayatcha arantsuksha chichainawa? ¿Jesúsjai iruuntrar nukap pujusarua aiyash, jusha imattsasha chichainawa? tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Tura shuar pegker jasusha nuig wajaun wainaina asar, nuka tu atsu jama tusarkesha tumain nekapenachu. ");
INSERT INTO hubNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Tumainak Pedron Juanjai aa jiikiaru, turawar nitak iruuntrar chichainak: ");
INSERT INTO hubNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“¿Au shuarsha iturkattajia? Au shuar pegker jasmaunka ashi Jerusalénnumia shuar ainaka wainkara jama. Imatikawaru asarmatai, auka pegker amajsachai tusarkesha tumaitsuji. ");
INSERT INTO hubNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Turasha ‘yamai nagkamsamka chikich shuar ainasha antukarai, Jesús pachisrumka chicharkartirpa timi’ ”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Tusa nuna chichaman shir umikar, Pedron Juanjai untsukar awayawar chicharainak: “Yamai nagkamsarmeka Jesús pachisrumka chicharkartirpa”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Nu tusa tama nita aimainak: “¿Turasha atum wakeramu umiakriash Yuuska umirtsuk inaisatjia? ");
INSERT INTO hubNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ika ii wainkamuka tura antutcha ii antukmauka pachisa etsertsukka inaimaitsuji”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Tusa tuinakai ayatik chichaman awantainak: Maake wetaarma, tusar akupkaruiti. Nuiyasha shuar wekaichun pegker amajeamun wainkaru aina Yuusnasha ememataina asarmatai, nita makumamaintrinka waitainachu asar, apu ainasha suimmainchau nekapena. ");
INSERT INTO hubNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Nu shuar pegker jasua nuka cuarenta uwí aramu pegker jasuiti. ");
INSERT INTO hubNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Pedro Juanjai jiiki akupkam, Jesúsa unuinatairi chikich aina matsatmaunam jeawar, ashi sacerdote apuri tura uun ainajai chicharkarmaunka nuna turamiarmaji tusar ujaina. ");
INSERT INTO hubNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Tusa ujainam ashi metek Yuusa aujainak: “Apuru, ameketme nayaim, nugka tura nayantsasha najankaumka, tura nu ainanam iruna nusha ashi najankauwaitme”. ");
INSERT INTO hubNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Wakan Pegkera nu ina uuntrin David amina inatairam ajakua nuna chichamtikuk: “¿Urukamtai shuar ainasha kajekarsha shinuinawa? ¿Urukamtai shuar ainasha antrasha chichamnasha najanainawa? ");
INSERT INTO hubNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Apu aina chikichan apuri ainajai Yuusan kajeraina asar, iruunar ni apu etegkamurin Cristoncha kajerainawai”. Nuna tumatnaiti tusa David aaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Nu tusa timau asamtai, apu Herodes, apu Poncio Pilatojai, israelita ainajai, Romanmaya shuar ainajaimak Jerusalénnum iruuntrar amina inatairam Jesús nekas Pegkera nu, ame Cristo atii tusam etegkawaitam nuna nekas kajerkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ame tumatin atii timaurmin uminak. ");
INSERT INTO hubNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Apuru, ame wina chichamrun etserkarti tusa etegkramurmin chichaman awantaina nuka amesha nekame. Tura asam nitasha arantsuk yujas chichamrun etserkarti tusam senchiram susarta. ");
INSERT INTO hubNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Tumainak wina inatair Jesús, nekas pegkera nuna naarin pachisar, shuar ja ainancha wina senchirjai pegker amajainak, shuar yaunchuk wainkachmauncha iwainakarti tusam senchiram susarta”. ");
INSERT INTO hubNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Nuna tusa Yuusa aujsar nagkanai jea muchitkauwaiti. Nuna tumaig Wakan Pegker shuar nui irununka egkemturu, turamu asar arantsuk Yuusa chichamenka etseraina. ");
INSERT INTO hubNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ashi shuar Jesúsai surumankau ainaka nukap ainaksha, metek enentaimaina. Tumaina asar: Ina waríri aina juka ashi iruuntura takasarmi tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Apu Jesúsa unuinatairi ainasha, Jesús maamu nantakmayi tusar shir etseraina. Imanis etseraina asarmatai, chikich shuar ainasha wakerus anturaina. Imatikiartai Yuuscha ninii surumankau ainanka senchi yayá. ");
INSERT INTO hubNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Turamu asar nita jeen, tura ajari ainan surukar, kuit jukimun jukiar, Jesúsa unuinatairi ajakarun shuar atsumainan nita susarti tusar ikaataina. Nuna turuina asarmatai, ashi Jesúsai surumankauka chikichkiksha atsumainakka waitainachu. ");
INSERT INTO hubNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Nui chikichik Leví weantu José naartin, Chiprenam akina Jesúsa unuinatairi aina Bernabé anaikarua nu nui pachitkau. Bernabé ta nuka “ichichkartin” taku tawai. ");
INSERT INTO hubNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Nu shuar nui pachitkau asa, nina nugken suruk, kuitan juki itaa Jesúsa unuinatairi ajaku ainan susauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Nu turamtai Ananías nina nuwe Safirajai nugken surukaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Tura kuita juki nuwejai chichaak: Akanka inu atin ikuaku isha Jesúsan unuinatairi ajakaru susami tusar shir chichasu asar, kuitan akanak ikuak, chikich kuit akankamun juki Jesúsa unuinatairi ajakaru matsatun tari, wisha wina nugkarun surakun kuit jukimurun ashi jui itaajai tusa susauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Turam Pedro chicharuk: “Ananíasa ¿aminu atin akankam ikuakmesha, urukamtai iwanch wakeramu takakmesha, Wakan Pegker tsanurtasmesha wakerame? ");
INSERT INTO hubNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Nugka surukum nuka aminuiti. Tuma asamtai nugka surakum kuit jukinam nusha aminuketi. Tumau aisha ¿urukamtai jui itaamsha antramsha waitrame? Ameka shuar ainaka tsanuachume, antsu Yuus tsanuame”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","6","Tamaun antamuik, Ananías jaka iiyaantuiti. Tumamtai natsa aina taaruawar ikusartasa punuar jukiaruiti. Nu shuar tumamun chikich aina antukar senchi ashamkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Nuna ikustasa matsatai nukap atsuk tres hora asa, nuwasha aishri jakamunka nekatsuk wayaawaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Tumamtai Pedro nuwan chicharuk: “¿Nugkemsha urutma akika surukmarme? ¿Nekas nugkem surakrumsha, ju kuita jukek jukimarum?” tusa inia. Nu tusa iniam nuwa chichaaksha: “Ee, nu kuita auk jukimji”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Nuwa takai Pedro chicharuk: “¿Urukamtai aishrumjai meteksha Wakan Pegkera nusha tsanurtasmesha wakerame? Amina aishrumin ikusar ikuinak waitinam kaunkattak winina au iista. Au ainak amincha juramkiar ikurmasartatui”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Nu tusa tamauwaik Safirasha Pedro eketmaunam ayaamas jaka iyaantuiti. Tuman nunasha natsa aina wayajkama tepettamaun wainkar jukiar, aishri ikusmaunmag ayaanas ikusaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Nu tumamun Jesúsai surumankau ainaka chikich shuar ainajai antukar senchi ashamkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Tumaina asar Yuus ememattasa iruuntai jeanam, Salomón tesamu tutainam iruuntrarmatai, Jesúsa unuinatairi ajaku aina wainchatai ainan nukap iwainaina. ");
INSERT INTO hubNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Antsu Jesúsai surumanainachu aina nitasha shir anentainayat, aranainak nitajaigka iruuntrachu ainawai. ");
INSERT INTO hubNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Jesús pachisa etsermaun antukar, Jesúsai surumankachu ainasha aishmag aina nuwajaimak Jesúsan nekaspapita tusar surumankaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Imaninak Pedro nagkamamu nina mikinturi wajantati, turam pegker jasarti, tusar shuar ja ainan jukiar jintanam tepetairin aitak aepaina. ");
INSERT INTO hubNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Yaakat Jerusalénnum jeashtachunam matsamin ainaka shuar ja ainanka Pedro pegker amajsati, tusar Jerusalénnum ikaanaina. Turuinak shuar iwanch egkemtuamu ainancha iwanchin jiirkiti tusar itaina. ");
INSERT INTO hubNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","18","Imatikiartai sacerdote apuri ni iruuntra chichatairi saduceo ainajai iruuntrar, Jesúsa unuinatairi aina shir takainakai kajerainak, achikar cárcelnum egkeawaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Turawarmatai nayaimpinmaya shuar káshi tari waitin urati chicharuk: ");
INSERT INTO hubNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Yuus ememattasa iruuntai jeanam werum, ashi ju chicham pujutan sukartina ju pachisrum shuar aina ujaktarma tusa akupkauwaiti”. ");
INSERT INTO hubNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Turamu asar kashi tsawak káshikmas Yuus ememattasa iruuntai jeanam wayawar, shuar ainan utuwak Jesúsan pachisar jintinkartuinak matsatu. Tuma matsatai sacerdote apuri chikich apu ainajai chicham iruuntutai ainan ashi ipaa, israelita uuntri aina kaunkarmatai, achika egkea ikukmaj nu utitarma tusar Yuus ememattasa iruuntai jean kuitamin ainan akupkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","23","Nu tusa akupkaram jeariar jukiartajkama uwetar atsakai ikuinak, waketar kaunak etserainak: “Waitika shir epentramuayi, achikmaun kuitamainasha iruuniarmayi, turasha wayaa iiyam atsuarmayi”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Nuna tusa tu etserainakai, shuar Yuus ememattasa iruuntai jean kuitamnun apuri sacerdote apuri ainajai iruuntrar chichainak: “¿Turasha nunasha urukakug tumawainta?” tusar enentai jearcharuiti. ");
INSERT INTO hubNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Nuna tu irunai chikich tawar chichainak: “Atum shuar achikrum egkeamarum nu ai, Yuus ememattasa iruuntai jeanam wayawar, shuar ainan utuwak, jintintu matsamajama”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Tuinakai Yuus ememattasa iruuntai jean kuitamnun apuri achikratin ainajai weriar, shuar juna anturaina kayajai tukurmar mantamawaraij tuina asar, shir kuitamsar waitkatsuk ejéniaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Turawarmatai apu iruuntramunam ajapeen awajsarmatai, sacerdote apuri wajaki chicharuk: ");
INSERT INTO hubNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“¿Ii yamai nagkamsarmeka Jesús pachisrumka shuar ainaka ujakairpa timajrum nuka antukchamkarum? ¿Urukamtai antatsrume? Atum nu jintinmau asar, shuar aina ii ainatin: Nitapi Jesúsan inamar maa ainawa turamainaji”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Nu tusa tu chicharam Pedro ayak: “Shuar wakeramuka umirtsuk, Yuus wakeramu nekas umirmainaitji. ");
INSERT INTO hubNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","31","Atum Jesús achikrum numinam achiirum maawakrumin, ina uuntri Yuusri yamaiya juisha ina Yuusriya nu, ni ashi uwemtikartin atii, tura ashi Israel shuar ainati pujutin yapajiawar tunaurincha tsagkurnararti, tusa ni inanki nayaimpinam yaki iwak, nina untsurini ekentsauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ika nekas wainkau asar, juka tau asaakrin Wakan Pegkera nusha shir imatikas chichamtikramji. Yuus ni umirmau asa, ii ainatin Wakan Pegkeran suramsauwaitji. ");
INSERT INTO hubNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Nu tusa tuinam kajerkar maataj tuina. ");
INSERT INTO hubNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Tuinakai nui fariseonmaya chikichik apu chicham umiktinan jintinkartin, chichamesha umirtai Gamaliel naartin wajaki chichaak: Atumka aa jiinkirum ishichik wajastarma tusa inaiyak, ");
INSERT INTO hubNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","chikich apu ainajai chichaak: Israelita apuri ainata, atum ju shuar maattsarum enentaimtuinarum nuka turawairpa. ");
INSERT INTO hubNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Atumka aneatsrumek, Teudas nigki chichamrumak wii nekas apu atajai takai, ayu tusar apu anaikar cuatrocientos shuar nemaras yujaraina, nitak maawar aantar kanarar megkakaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Nu tumawaru ai, shuar nekapmantrati tusa inamramunam, chikich Galileanmaya shuar Judas naartin nisha numamtuk jakmatai, nunasha nitak maawar kanarar megkakaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Tuma asamtai tajarme: Au shuar ainaka inaisatarma. Aantar nitak tu yujainakka megkaaratin ainawai. ");
INSERT INTO hubNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Antsu nekas Yuusnau akaigka atumka nepetmaitsurme. Nitajaigka tunaiyaka pujumaitsurme”, tusa tinaiti. Nu tama apu ainasha: Ayu, nekas inaisami tuina. ");
INSERT INTO hubNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Nuna tusar Jesúsa chichamen etserainak yujan untsuk awayawar asuttraruiti. Tura chicharainak: “Yamaika wetaarma. Tumakrumsha Jesús pachisrumka shuar ainaka ujakairpa tusar akupkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Tuinam nitasha apu matsatun ikukiar wenaksha, Yuus atumsha Jesús waittsauwa tumasrumek waitmainaitrume timau asar, shir aneasar nakunkut weena. ");
INSERT INTO hubNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Tumaina asar Jesús pachisa etsertanka inaitsuk, kashi kashinig shuar ainan Yuus ememattasa iruuntai jeanam, turachkusha chikich jeanam utsaawarsha tuke ujaina”. ");
INSERT INTO hubNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Imatikainam Jesúsai surumankau ainaka nu senchi kawena. Tumainaksha judío ainaka griego nuwa waje ainanka kashi kashinig yurumkan ajamainaksha shir ajamenachu. Tumainakai griego shuar aina chichainak: Ii nuwa waje ainanka shir ajamenatsui tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Tuinakai Jesúsa unuinatairi ajakaru doce aina nui matsatu asar, ashi shuar Jesúsai surumankau ainan irumraruiti. Tura chichainak: “Yatsur ainata, ika shuar yurumak shir tinamkartasa Yuusa chichame jintinkartamuka umitskeka inaimaitsuji. ");
INSERT INTO hubNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Tuma asamtai yatsur ainata, atum yurumkan ajamastin aina Wakan Pegker aramu, yacha, shir enentaimas takamain iisrum, siete shuar ju takatan shir takasarti tusarum etegkratarma. ");
INSERT INTO hubNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Nita nuna turuinai, ii Jesúsa unuinatairi ajaku ainatika Yuus aujsattaji, nu tumainaku Yuusa chichamea nusha etserkattaji”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Nuna tusar tuinakai, shuar nui tuak iruunainaka shir aneasaruiti. Tura Estebankan Yuusa shir enentaimtinan, Wakan Pegkersha aramun, Felipen, Prócoron, Nicanoran, Timónkan, Parmenasan, Nicolásan, Antioquíanmaya judíomawa nuna anaikaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Nuna etegkrar jukiar, Jesúsa unuinatairi ajakaru matsatmaunam ejéniaruiti. Turawarmatai nita nui chiki chikichik muuknum achikar iruunas: Yuusru, ju aina yaigta, amina takatrumin shir takartamsarti tusar tuina. ");
INSERT INTO hubNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Nu turawaram jinar Yuusa chichamen chicharkartuina, Jerusalénnumsha Jesúsai surumainak nukap kawegkaru, tura sacerdote ainasha Jesúsan umiraina. ");
INSERT INTO hubNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Esteban Yuus yayámu asa, yaunchuksha wainkachmaun shuar ainan nukap iwaintau. ");
INSERT INTO hubNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Judío aina iruuntairi jea Aagkamu tutainumia shuar ainajai iruuntraruiti. Cirenenmaya aina, Alejandríanmaya, Cilicianmaya, Asianmayasha, ashi iruuntrar Estebankan igkuawar urukamtai tame, juka tusarka tumaitsui tiartasa weriaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Turasha Wakan Pegker chichamtikmau asa, nigka senchi nekau asamtai, Estebankan nepetkiarka chicharmain nekapenachu. ");
INSERT INTO hubNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Tumainak chikich shuaran chicharainak: “Atum ii anturkamji ni Moisésan nakitak pegkerchau chicharuk, Yuusnasha turusag pegkerchau chicharmayi tusarum titarma”, tusar akikaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Nuna tuinak shuar ainan judío apuri ainancha, chicham umiktinan jintinkartin ainajai ishitkauwaiti. Turawaram Estebankan achikar, apu iruuntramunam ejéniaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Nui ejéniarmatai shuar aantar tsanumruina wajaki chichainak: “Ju shuarka Yuusa jee pegker tutaiya nuna pachis pegkerchau chicharuk, chicham umiktarma Moisés timauncha aitkasag pegkerchau chicharnayi. ");
INSERT INTO hubNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Tura ni chichaak: ‘Jesús Nazaretnumiaya nu, ju jea Yuusnauwa juna yumpuar ajapeak, chicham umiktarma Moisés timaurincha inagnaktatui tusa tamauri ii nekas antukmaji’ ”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Nuna tuinakai, ashi apu iruuntramunam iruuntraruka, shir esettsar Estebankan iikma, nayaimpinmaya shuaran yapijai metek jas eketun wainkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Tumattamaun sacerdote apuri chicharuk: Nekasmek timam tusa iniasuiti. ");
INSERT INTO hubNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Tama ni ayak: “Yatsur ainata tura uun ainata, wii chichaakai antuktarma. Ina Yuusri nekas senchirtina nu, ina uuntri Abrahaman nugka Haránnum wetsuk, Mesopotamianam pujuttamaun wantiintuk ");
INSERT INTO hubNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","chicharuk: ‘Nugkem ikuakum, tura pataim ainasha ikuakum wetá, tuma jiinkiakmincha wii ame nugka pujustinnum jeaakmin ujaktajme’, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Nu tusa tamau asa, nugka Caldea tutain ikuak, nugka Harán tutainam pujustasa wuwaiti. Antsu apari jakamtai, Yuus ii yamai pujuinaj ju nugkanam akupkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Turasha nigka ishichkisha nugka ni pujumaintrinkisha susachuiti, tura uchirmatnasha uchirtinchau aig, ");
INSERT INTO hubNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Yuus Abrahaman chicharuk: ‘Wii amina uchiram, nuiyasha amina tiragkrum weantu aina matsamsatnun ju nugkanka amastajai, turasha chikich nugkanam cuatrocientos uwí yujas, aantra inaku waitkainam nugkenchau uruka nunii yujartinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Imatikam yujainakai, wii nuna waittan sukartaun waittan suakun nita ayamrukan jui ikaankan wina umirtukarti tusan matsastinaitjai’. ");
INSERT INTO hubNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Atum weantunam ashi shuaran uwemtikatin akinatnaiti. Tumamtai atum uchi aishmag kati mushuke tsupirin ainarum, turusrumek tsupirkatarma tusa timau asa, Abraham uchiri Isaac akina ocho tsawan ejémtai tsupirkauwaiti, ni turamu asa, Isaacsha Jacobon akia turusag tsupirkauwaiti. Nunaka uchi aishmagnaka tuke turujaku ainawai. Antsu Jacob doce uchin akigkuiti, tura nita ashi nugkanam pampagkaru ainawai. ");
INSERT INTO hubNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Jacobo uchiri aina nuka ina uuntri ajakaruiti. Tura yachi aina Josén kajeraina asar, ismaelita ainanam surukar, Egiptonam akupkau ainawai. Yachi turawarmataisha Yuuska inaisachuiti. ");
INSERT INTO hubNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Tura asa ni waitakaisha agkanmamtikawaiti. Turak nekatnasha susauwaiti. Turamu asamtai Egiptonmaya apusha Josénka wakerukuiti. Tura asa ni apu jas pujamunka Josén chicharuk: Ame yamaika wina jearui pujuinaka amek inata, tusa ninka Egiptonmaya shuaran apuri amajsauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Tuma pujai Egiptonam ashi Canaán nugkanmasha tsuka tepeawaiti. Tumamtai ina uuntri Jacobsha yutairin ashi amukar senchi waitaina. ");
INSERT INTO hubNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Imani pujukma Egiptonam yutai suramu awai tamaun antukuiti. Nuna antuk, nina uchiri ainan yutai sumaktarma tusa ishiakuiti. Turam jeawar yutain sumakar waketkiaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Tumawar ataksha yutairin amukar Egiptonam wearuiti. Tumawarmatai José ni apuma pujau asa, yachi ainan wainak chicharuk: Wika atumin yachiyaitjai tusa ujakuiti. Tura José yachi aina kaunkayi tamaun, faraón antuk, Joséka hebreo shuaraiti tusa nekaawaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Tura José nina yachi ainan akateak: Yatsur ainata, waketkirum ina apari, ashi ina patai ainajai yarumakrum jui kaunkatarma tusa tinaiti. Nina patai ainaka ashika setenta y cinco shuar ajakuiti. ");
INSERT INTO hubNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Yachi tima, waketar ashi yarumas Egiptonam jeawar, nui pujus Jacobsha jakauwaiti. Tumamtai chikich ainasha uchin akigkar ikuinak jinaawaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Tumawarmatai ima Jacobo iyashinak Siquemnum jukiaruiti. Tura yaunchuk Jacobo apachri Abraham ni iwáku pujus ikumatain yaakat Siquemnum Hamora uchirinun sumakmaunam ejéniar ikusaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Jacob chikich naari Israel ajakua nuna uchiri weantu aina, Egiptonam matsamsar aki akinainakua untsuri shuar pampagkuiti. Yuus yaunchuk Abrahaman imaniktinaiti, tusa timaurigka imanisag uminkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Tuma José jaka ai, chikichik shuar Josén wainkachu Egiptonmaya apu jasuiti. ");
INSERT INTO hubNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Nu pujus ina uuntri ajakarua nu weantu ainan tsanuak waitkaina. Imatika asa uchi aishmag akinuka tsakatmatsuk maatarma tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Apu tinu ai, chikichik uchi Moisés Yuusa shir enentaimtiksatin akinawaiti. Tumamtai apari nukurijai uchin maa ajapmainchau nekapenak, jiitsuk nita jeenig tres nantu apujsaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Tura uumainchau jakai, egkeatnurin shir najata nui egkea entsa inanaknaiti. Turamun apu nawantri wainak juki, ni uchirima tsakatmaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Turamu asa Egiptonmaya jintinkartamunka ashi unuimaruiti, imaniku asa nigka shuar yacha, chicharkartutnasha chicharkartin ajakuiti. ");
INSERT INTO hubNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Moisés akinamurin cuarenta uwí ejé, nina patai israelita weantu aina matsatmaunam wuwaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Tumakma Egiptonmaya shuar israelita shuaran suimun wainkauwaiti. Tura nisha nuna ayamrak Egiptonmaya shuaran maawaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moiséska amina pataim israelita ainaka ame agkanmamtikawarta, tusa Yuus turuttata nunaka nitasha nekainawastai tu enentaimu. Turasha nitaka ishichkisha nunaka nekainachu. ");
INSERT INTO hubNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Tumainai Moisés kanar tsawaar ni weantu takainak yujainan weri iikma, mai nitak maanittamaun wainkauwaiti. Tura wainak jeari chicharuk: ¿Urukamtai atumkesha maanisha yujarme? tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Tusa tama Moisésan chicharuk: Ina apurim amekaitam ¿ya amincha chicham iwarin atá tusa turammataiya tame? ");
INSERT INTO hubNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Winasha yau Egiptonmaya shuar maamam turusmek mantuattsamek turutam? tusa imatra. ");
INSERT INTO hubNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Nu tusa imatram Moiséscha chikich nugka Madián tutainam wuwaiti. Tura yajayayaitiat nui jeaa nukap uwí pujus, uchin jimaran akiawaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Nui cuarenta uwí pujus, mura númi atsamunam Sinaí tutainam wuwaiti, tuma nui jeantatak wesa, númi shikapchik kanaknarin wajaunam ji ke atatmaun wainkauwaiti. Nu ji keamunam nayaimpinmaya shuar chikichik wantiintukuiti. ");
INSERT INTO hubNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Tura nui wajattamaun wainak, shir wainkattsa ji kean jeantataj takai, Yuus ji keamunam wajau asa chichaak: ");
INSERT INTO hubNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Wiyaitjai, amina uuntrum Abraham, Isaac, Jacob aina nuna Yuusrinka’, tusa tinaiti. Nuna takai Moisés senchi ashamak, iimain nekaprachu. ");
INSERT INTO hubNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Tumakai chicharuk: ‘Zapatoram ukuintrata. Wii jui pujau asamtai, ame wajam nuka nugkaka pegkeraiti. ");
INSERT INTO hubNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Wika winau ainan Egiptonmaya shuar waitkainam útainakai nuna antukan, nitan ayamruktasan taajai, tuma asamtai ame umintsata, Egiptonam akupkatjame’, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Yaunchuk Israel shuar aina Moisésan chicharainak: ‘¿Ya amincha ame apu jasam chicham iwarin atá tusasha turammame?’ tusar nakitramunak Yuus ni chicharuk: Ame yamaika apu jasam Israel shuar aina ayamrukta, tusa nayaimpinmaya shuar ji keamunam wajas Moisésan tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Nu tama Moisés we ina uuntri weantu ainan Egiptonmaya jiir uwemtikauwaiti. Tura shuar wainchatain nukap iwainak takak, Nayants Kapantu tutain Yuus kuyumtikamtai shuar ainan ikatiaruiti. Tura aya nugkanmag cuarenta uwí pujusuiti, tura nui pujus wainkachmaun iwainak nukap taká jakuiti. ");
INSERT INTO hubNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Moisés israelita ainan chicharuk: Yuus, atum ainarum nuiyan chikichik shuaran wina etegturua aitkasag ame wina chichamur etserin atá tusa etegkatnaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Chikich tsawantai, Moisés ni weantu ainanka ashi yaruak, mura Sinaí tutainam nui nitajai iruuntrar matsamsartasa wuwaiti. Nu nainnum wakamtai, shuar chicham umiktina nuna Yuus susauwaiti. Turam ina uuntri ajaku aina nuna nitasha juna umikarti tau asa susaruiti. Nu turamu asamtai yamaiya juisha ii ainatisha papiinum aarmauka takakji. ");
INSERT INTO hubNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Turamu ainayat shuar ainaka chicham umitnaka nakitainak, ayatik Egiptonam wakettrartasa enentaimajakaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Tumaina asar Moisésa yachi Aarónkan chicharainak: Ame chikichik nakumkam najanata, nu ina yuusri atii, tuma ni nekas inka emrutmakti, ni tumakai nu nemarsa wearmi. Moisés ina Egiptonam pujarin itarmawa nuka megkakayi tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Nu tama vaca uchirin najanamtai, tagku ainan mantuawar: Ju jutikam yainmaktaji tusar epena. Tumainak shuar najanamun aujainak, nitaka shir anentaina. ");
INSERT INTO hubNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Tumainakai Yuuscha nita wakeruinamun takasarti tusa inaisauwaiti. Turamu asar shuar ainaka yaan eme anentas iiyainak aujujakaruiti. Yuusa chichamen etserin tumatnaiti tusa tu aaruiti: Israelita ainata, atum aya nugkanmag cuarenta uwí wekakrumsha, chikichkitirmeksha tunaurum tsagkurnartasrumka tagku aina maarum epeakrumka ajamnaisachu ainarme. ");
INSERT INTO hubNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Tumayatrum yuus Moloc naartin ememattai jaanch jeamkamu takusrum yujainarme. Tura chikich yuus Renfán tutai yaari ememattasrum nakumkarum najanawaitrume. Nu tuma asaakrumin atum weantu ainanka yaruakan, Babilonia nugkanam jeashat umattajai. Yuus timaun nina chichamen etserin tu aaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Moisésan Yuus chicharuk: Wina emematrittsa iruuntai jea jaanch jeamkata timau asa, muranam wainkamujai metek turusag aya nugkanmag jeamkauwaiti. Nu jeanam jimar kayanam chicham umiktin aarmau ajakuiti. Nu jeanka ina uuntri aina yaunchuk yujainaksha tuke takus yujajaku ainawai. ");
INSERT INTO hubNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Nunak tuke takus yujas nita iwáku yujainan susa ikujakaruiti. Nutika yujatain nita apuri Josuéjai ishiintukar, jukiar nugka Canaánnum ejeawaruiti. Tumaina asarmatai Yuus yayák, nui matsamin ainanka jiir utsagkuiti. Eke kuitama matsamtuinai, apu Davidcha akinawaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Apu Davidka Yuusnaka shir enentaimtusuiti. Tuma asa Yuus emematku iruuntai jean jeamkattsa wakerukuiti. ");
INSERT INTO hubNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Imanik wakeraksha nigka jeamkachuiti. Antsu nina uchiri Salomón Yuus emematku iruuntai jeanka jeamkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Yuus ashi nagkakartakua nuka shuar jea jeamkamunmagka pujumaitsui. Nuna pachis Yuusa chichamen etserin aaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Yuus chichaak: ‘Wina ekeemtairka nayaimpiti, antsu wii najamtairua nuka nugka auwaiti. ¿Winasha wari jeak jeartitarme? ¿Wii ayammaintrusha tuwaita? ");
INSERT INTO hubNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿Atumka wii ashi najankauwaitaj nuka nekatsrumek?’ ” tusa Yuus tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Esteban nuna ashi tina inagnak shuar ainan chicharuk: “Atumka Yuusa chichame antut nakita asarum, Wakan Pegkera nusha kajerainarme. Atumka ina uuntri ajakarua nujai metek ainarme. ");
INSERT INTO hubNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Nu ina uuntri ajakarua nuka Yuusa chichamen etserainancha waitkainak, Cristo taatnurin pachis etserainancha majaku ainawai. Atumsha tumasrumek Cristo Pegkera nu tarutramamtaisha, tsanu tsanumrakuarum maa ainarme. ");
INSERT INTO hubNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Atum nekas nayaimpinmaya chicham umiktarma timaun Moisés ikurtamkimusha takaku ainarme, tumayatrum nuka umiatsrume”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Esteban nuna tusa chichaakai, apu aina senchi kajerainak nain esainiar wajasaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Imaninaig Esteban Wakan Pegker aramu asa nayaimpin pagkai iikma Yuus tsaaptin jas wajai, Jesucristosha nuna untsurini, nisha imanisag wajattamaun wainkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Tura nuna wainak shuar irunun chicharuk: “Atumsha nayaim pagkairum iisuana, nayaim uranmatai, Cristo shuarnum akinawa nusha Yuusa untsurini wajaun wika wainjai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Nuna takai shuar ainaka antukaij tusar kuishin epenkaruiti. Tumamuik pampantrar tsekenkiar achikaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Tura jukiar yaaktan ikumtikiar maattsa kayajai tukuina. Antsu mantamnati tusa tuinaka nita nugkutairin awikar natsa Saúlo naartinan ame juka kuitamata tusa susaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Imatika kayajai tukuinam Esteban Jesúsan aujeak: “Apuru Jesúsa, wina wakanur kuitamrutkata” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Nuna tina tikishmar senchi chichaak: Apuru, ju shuar tunaun takaina jusha ayatik tsagkuurata. Nuna tusa tina nui jakauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saulosha Estebanka mantamnati, tusa tinaiti. Jerusalénnum Jesúsai surumankau aina senchi waitkatan nagkamawaruiti. Imatikainam Jerusalénnaka ikukiar Judea nugkanam, tura Samaria nugkanmasha pampag shiakaruiti. Nuka tumaig Jesúsa unuinatairi ajakaru ainaka Jerusalénnumag juakaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Tumaina nui Estebankan maawarmatai, shuar Yuusnak shir enentaimtin aina Estebankan iyashi jukiar, eai eainakua ikusaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Nuna turawarmatai, Saulo jea nukapek utua utuakua weak, aishmag ainan nuwa ainajai achir japiki yaruak cárcelnum egke jakuiti. ");
INSERT INTO hubNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Imatmainaig chikich tsekegkiaru ainaka yaja yujasar nita jeainamunam chichamnaka etseraina. ");
INSERT INTO hubNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Tumaina asar Felipe Samaria nugka yaaktarin uunta nui jeaa, Criston pachis etserkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Turak wainchatai ainan Felipe iwainak takakai, nuna wainkar nuiya shuar ainaka ashi shir aneas antukaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Felipeka nui chicharkartak pujus, nukap shuaran iwanch egkemtuamuncha jiiruk senchi chichamtik jiya. Tura shuar emearu ainan wekaichu ainajai nukap pegker amaju. ");
INSERT INTO hubNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Tura asamtai nu yaaktanmaya shuar ainasha shir aneas matsataina. ");
INSERT INTO hubNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Tura shuar yaunchuk iwishin ajaku Simón naartin pujau. Nu pujau asa, Samarianmaya shuar ainan tsanuak: Wiyaitjai nekas imannaka tusa tu wekatau. ");
INSERT INTO hubNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Nu iwishin ajakun ashi uun aina, chikich ainajaimak shir anturainak: “Juwaiti nekas Yuus senchimtika akupkamuka”, tusa imatruina. ");
INSERT INTO hubNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Nu shuarka iwishnuma nukap uwí pujau asa, nuna tusa shuar ainanka tsanu pujau. ");
INSERT INTO hubNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Tuma pujai Felipe, Yuus Jesucristojai inammaun pachis etserkai nukap shuar nuwa ainajai shir aneas antukar, nekaspapita tuina asar entsanam mainiaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Nuna tura nui nita wainkachmaun nukap iwainar takakai, Simónsha senchi kuntuts enentaimar, nekaspapi tusa entsanam main, tuma Felipen nemarkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Nuna tuma wekai Jesúsa unuinatairi ajakaru ainasha, Jerusalénnum matsamas: Samarianmaya shuar aina Yuusa chichamen shir nekaawartasa wakeruinawai tamaun antukaruiti. Tura Pedron Juanjai atum ai jearum Yuusa chichame etserkatarma tusa akupkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","16","Turamu asar Samarianam jeawar, apu Jesúsai surumankar nina pachisar entsanam mainiaru ainaksha, Wakan Pegkernaka juinachu asarmatai, Jesúsai surumanaina nu Wakan Pegker akuptukta tusar Yuusan aujsaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Nuna turawar Pedro Juanjai nita muukeen achikaruiti. Turakai Wakan Pegkersha egkemturaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Nuna turuinakai Simónsha wainak chichaak: “Kuitan akiktajrume. ");
INSERT INTO hubNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Winasha atum chikichan muuke achikrum Wakan Pegker egketrum aitkamaina nu senchi surustarma. Turutawakrumin wisha chikich shuar ainan muuknum achikan, Wakan Pegkeran egketin atajai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Nuna takai Pedro chicharuk: “Ameka kuitrumjai megkakatnaitme. ¿Urukamtai amesha Yuus sukartusmaujai takaj nusha kuitjai sumaktasmesha wakerame?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ameka ii yujainaj juninchauwaitme, tumau asam ameka ishichkisha juka jutikamka takamaitsume, ame enentaimmauwa nusha Yuusaigka maaktakuka wantintsui. ");
INSERT INTO hubNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Amina tunaurum inaiyakum, ame tu enentaimam nuna tsagkurtamrachaintash Yuus aujsata. ");
INSERT INTO hubNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Wika wainjame, ameka shir kajen asam chikitcha kajernaitme, imaniakum tunau takata nuke inaisachminu pujurme. ");
INSERT INTO hubNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Nu tusa tama Simón ayak: “Atum winaka Yuus aujtursatarma, atum turutrum nu imanisag uminturkaig”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Nuna tusa timatai, nita pujutin pachis etserkar, tura Yuusa chichamea nunasha pachis chichasar ikuinak, Pedro Juanjai jinar, Samarianam yaakat shikapchich iruunmaunmasha yujasar, Jesús tu uwemtikartawai, tusar chicha chicharkartuinakua Jerusalénnum wakettraruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Tuma ai nayaimpinmaya shuar apu Yuus akupkamu Felipen tari chicharuk: “Felipe, yaakat ikukim wári wetá, nu weakmesha Jerusalénnumia juaki Gaza wetaiya nu wetá, nu jinta nuka aya nugkanmag tsupia weawai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","28","Nu tusa tima Felipesha juaki wuwaiti. Tuma wekama jintanam Etíopenmaya apu Jerusalénnum Yuusan eme anentas iiyak ememattasa wu. Ni nugkeen waketuk carretenam egkemas Yuusa chichamen etserin Isaías aarmaun aujki winittamaun wainkauwaiti. Nuka Etíopenmaya apu nawantri Candace naartin ajakua nuna kuitrin kuitamrin ajakuiti. ");
INSERT INTO hubNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Nu winittamaun Felipe wainkamtai, Wakan Pegker chicharuk: “Shuar carretenam wea au jeantata”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Nu tusa tama Felipesha carretenam wean jearkama, Yuusa chichamen etserin Isaías aarmaun aujki winittamaun antuk chicharuk: “¿Aujam nusha nuna takumpapi tawa tusamsha nekamek?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Nu tusa tama ni chichaak: “¿Nunaka taku tawai tusa ujachmauncha uruk wisha nekatjak?” tusa tinaiti. Nuna tusa Felipen chicharuk: “Jui wakam, amesha wijai ekeemsam ujatkata”, tusa tinaiti. Tusa tama nisha wakauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Isaías aarmaun apu aujki wuwa nuka juwaiti: “Oveja maattsa juki umatia numamtuk maawartasa jukiar umarmayi. Oveja ure tsupirmasha takamtak tepena numamtuk nisha chichakchamai. ");
INSERT INTO hubNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ayatik weamkamai, chichaman shir nekaatjai tusagsha tichamai, ni nugkanam pujaun maawara aitkamuncha patai atsausha ¿yáki chichamaincha atii?” tusa tu aarua nuna aujki wea. ");
INSERT INTO hubNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Tuma asa Felipen apu iniak: “Wait aneasam winasha ujatkata, ¿juna Yuusa chichamen etserin tina nunasha yana pachis takua tinaita? ¿Nigkik tumamnait, turachkusha chikichan pachisag tinait?” tusa tinaiti, ");
INSERT INTO hubNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Nuna takai Felipesha apu aujmaun pachis: Ame tame nunaka Jesúsan ni turam atintrin pachis tawai tusa uja. ");
INSERT INTO hubNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Nu tusa ujam entsa aunam jeak: “¿Ju entsa a jui winasha imatmainchaukaitam?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Nuna takai Felipe ayak: “Ame nekas nuke enentaimtakminka imamainaitjame”, tusa tinaiti. Nu tusa tama apu chichaak: “Wika Jesúska nekas Yuusa uchirimpapita tajai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Nuna tusa takai caballoram juig emetata tama emetamtai, mai akaikiar entsanam jeaa, nui Felipe apun imainaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Tura entsanmaya jiinkimtai, Wakan Pegker Felipenka jukin, turamtai apuka awenagka wainkachuiti. Turasha shir aneas nina nugkeen wuwaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Felipeka Azotonam jeawaiti, tuma yaakat ainanka nagkatsuk, Jesúsaiti uwemtikartauka, tusa chichaa chicharkartakua Cesareanam jeawaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Nuna imaninai Saulosha Jesúsai surumanainan maattsa chicham awantanka inaiyachu. Imania asa sacerdote apuri matsatun jeari, ");
INSERT INTO hubNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","papi aaram surusta. Damasconam judío apuri iruuntairiya nui wayaknasha nuna inakmasan, ashi Jesúsai surumankaunka aishmag ainan nuwa ainajaimak achiran jui Jerusalénnum ikankatjai tusa seawaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Nu tusa tama papiin aatar susauwaiti. Turam nuna takus yaakat Damasconam jeattak weai, pachiachmau Saulo weamunam nayaimpinmaya etsantar tsaaptin awajsauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Turam Saulo nugka iyaar tepesmatai chicharuk: “Saulo, Saulo, ¿urukamtai winau ainasha waitkartame?” tusa tamaun antukuiti. ");
INSERT INTO hubNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Nuna antuk Saulo chichaak: “Apu, ¿amesha yaitam?” tusa tinaiti. Nu tusa tama ni ayak: “Wika Jesúsaitjai, ame winau aina waitkainam nuwaitjai”, tusa tinaiti. Tusa tama Saulosha kurakmaikia chicharuk: “Apu, ¿winasha urukati tusamea wakerutame?” tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Takai apu Jesús chicharuk: “Nantakim yaaktanam wetá, ai jeawakmin ame turumaintrumnaka turamiartatui”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Shuar Saulojai shimuinaka chichaamunka antuinayat wainainachu asar senchi ashamkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Nuna tina inagnakmatai, Saulo nugka iiyaan tepau nantaki iimtajkama wainmamainchau jasuiti. Tumamtai shuar aina uwejnum egkesar Damasconam ejéniaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Nui tres tsawan ishichkisha iimtsuk, yurumkancha yutsuk tura umutnasha pegke umutsuk pujau. ");
INSERT INTO hubNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Tumai Damasconam shuar Jesúsa umirin Ananías naartin pujau. Nuna Jesús paan wantiintuk chicharuk: “¡Ananíasa!” tusa tinaiti. Tama ni ayak: “Apuru, jui pujajai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Tusa takai Jesús chicharuk: Jinta Tuninchau tutaiya nunii wetá. Nuni weme Judasa jeen jeaam, chikichik shuar Tarsonmaya Saulo naartina nu inimsata. Nui Yuusan auju pujau wainkattame. ");
INSERT INTO hubNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Wii karanam timajai: “Shuar Ananías naartin taa, ataksha paan iimti, tusa uwejejai muukmin antinmaktatui, turutmamtai iimtatme timajai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Nu tusa tama Ananías chichaak: “Apuru, nu Jerusalénnum pujus, Amina nemartamin ainan waitkamun pachis wina ujatiarma jama. ");
INSERT INTO hubNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Nu yamai sacerdote apuri aina inaram, juiya amina pachitmasar pegkeran chichaina nunasha ashi yaruaktasa winak aniajama”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Nuna takai Yuus chicharuk: “Tutsuk wetá, aunka wina pachitas ashi chikich nugka ainanmasha nita apurijai, israelita ainajai ujakti tusan etegkajai. ");
INSERT INTO hubNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Tura wina pachitas shuar ainan ujak, senchi waittsatnurinka wii nekamtikattajai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Nu tusa tama Ananías Saulo pujamunam wuwaiti. Tuma Saulo pujamunam wayaawaiti, tuma uwejejai muuknum achiak: “Yatsur Sauloya, wina Apur jinta winamin amina wantinturmakchamkam nu, winasha amina ataksha paan iimti, tuma Wakan Pegkera nunasha jukiti tusa turamu asa, akuptukmatai winajai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Nu tura achika tamauwaik, ni jiinia namaka saepea nunin kakekamtai paan iimnaiti. Tumamtai Ananías imainaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Turam pimpira pujamuncha yurumkan yua chichiar, Damasconmagka ishichik tsawantai Jesúsai surumankaujai iruunar pujusuiti. ");
INSERT INTO hubNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Nui pujus judío iruuntairi ainanam wayaa chicharkartak: “Jesúska Yuusa uchiriyaiti tusa etseru. ");
INSERT INTO hubNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Nuna tusa etserkai shuar ainaka enentai jearcharuiti. Tuma chichainak: ¿Jerusalénnum wekaas aiya shuar Jesúsa pachis chichainan achir yaruaktasa patatu wekaina nu auchukait? ¿juiyatin achirmak juramkiar sacerdote apurin surutmaktasa taa wekaima nu auchukait?” tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Nuna tuinakaisha Sauloka shir aneas wakerumain chicharkartak, Jesúska nekas Cristowaiti tusa imatu asamtai, judío Damasconam matsatainasha nina nagkasagka chichamainchau nekapena. ");
INSERT INTO hubNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Tuma inaisar nukap tsawan ai, itursarik Saulo maawaj tusar chichaman umiraina. ");
INSERT INTO hubNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Turuina asar tsawaisha káshisha imanisag yaakta waitirin jiinkai maami tusar nakaa matsamtuinamun Saulo nekawaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Imatikaina asarmatai Jesúsai surumankau aina Saulon chagkin uunnum egkeawar, yaakta taniishrin yantamen iwakar káshi jiikiar akupkaruiti. Tu uwemrauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Saulo Jerusalénnum jeaa chikich shuar Jesúsai surumankau ainajai iruuntrattsa wakekauwaiti. Tumakaisha nitaka Sauloka Jesúsai nekas surumankachutskaitti tuina asar ashamaina. ");
INSERT INTO hubNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Tumainai Bernabé Saulon juki, Jesúsa unuinatairi ajakaru matsatmaunam ejénaiti. Tura Saulo jinta wesa apu Jesús wainkamurin, Jesús Saulo aujsamun, Saulo Damasconam jeaa arantsuk Jesús pachisa chichasmaujai nitasha shir nekaawarti tusa ashi etsertau. ");
INSERT INTO hubNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Nuna tusa ashi etseramtai, Saulo Jerusalénnum juak nitajai iruuntrar yujaina. Tuma pujus apu Jesúsan pachischa ashamkartutsuk chicharkartau. ");
INSERT INTO hubNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Tumakaisha judío aina griego chichaman chichau aina, nitaka ayatik maattsa chichaman umirkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Turuinakai chikich yatsut Jesúsai surumankau aina, nuna antukar Saulon jukiar Cesareanam ejéniar, nui inagkakiar Tarsonam akupkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Nuna turawarmatai Jesúsai surumankau aina ashi Judeanmaya, Galileanmaya, Samarianmaya ainajai, shir agkan matsatainak Jesúsnak eme anentsar umiraina. Tumaina asar Wakan Pegkera nu yayasaram matsatainak nu nukap kawena. ");
INSERT INTO hubNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pedro yatsut Jesúsai surumankau ainan iiyak weká asa, Lidanam shuar Jesúsai surumankau matsatuncha iistasa werinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Nu yaaktanam shuar Eneas naartin, emearu asa, wekaatsuk peaknum ocho uwí tepaun wainkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Tura Pedro chicharuk: “Eneasa, Jesucristo pegker amajtamui. Nantakim tepetairam iwarata”, tusa tinaiti. Nu tamauwaik Eneascha nantaknaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Tumamtai ashi Lidanam pujuinaka, tura Sarónnum puju ainasha shuar pegker amajsamun wainkar, nitasha yaunchuk tunau takatairi ainanka inaiyainak, apu Jesúsain surumankaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Nu tsawantin yaakat Jopenam nuwa Tabita naartin chikich naari Dorcas tutai Jesúsan nemarin pujau. Nu nuwaka shir pujus pegkeran takak, chikich atsumainancha yaijakuiti. ");
INSERT INTO hubNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Imani pujau jata tukum Dorcas jakauwaiti, tumamtai iyashi shir nijattrar, jea jimaraa ekeni jeamkamunam iwakar, chikichik tesamunam awayaa aepsaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Jopeka Lidanam tiiju au asamtai, shuar Jesúsai surumankausha Pedro nui pujamurin nekaawar, jimar shuaran akupenak: “Jearum Pedro chicharkurum: Jopenmaya megkaatsuk taati turamiarmayi tusa ujaktarma tusa akupkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Turamu asar jeari ujakam, Pedrosha nitajai iruunar wuwaiti. Tuma jeaamtai jukiar jakau tepamunam awayawar, ashi nuwa waje aina tenteawar útainak, Dorcas iwáku pujus jaanch nugkutai najankamuri ainan inaktuina. ");
INSERT INTO hubNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Turam Pedrosha nuwa ainan ashi aa jiir, nigki juak tikishmar Yuusan aujas umik nuwa jakaun iis chicharuk: Tabita, nantakta”, tusa tinaiti. Nu tusa tama nuwa jakausha iimi Pedron wainak nantaki ekeemsauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Tumamtai Pedro uwejnum achik awajas, Jesúsai surumankau ainan, waje ainajai untsuk ikaanak iwákun iwaintukaru. ");
INSERT INTO hubNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Nu turamun Jopenmaya aina ashi nekaawar, apu Jesúsai nekaspapita tusar nukap shuar surumankaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Tumawarmatai Pedrosha nuape apau Simón naartin ajakua nuna jeen nukap tsawan pujusuiti. ");
INSERT INTO hubNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Yaakat Cesareanam Italianmaya suntara apuri Cornelio naartin pujau. ");
INSERT INTO hubNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Nuka nina nuwe, tura uchiri ainajaimak ashi iruunas shir enentaimsar Yuusan emematin ajakaruiti. Tumau asar judío atsumainan yayák nukap kuitan suinak, Yuusnaka tuke aujsarkee ajakaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Tuma puju asamtai, tsawai etsa teenta ai, karanam waintaiya numamtuk, nayaimpinmaya shuar shir paan ni pujamunam wayan wainkauwaiti. Nu wayak: “¡Corneliowa!” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Nu tusa tama Cornelioka ashamak wajas ii wajatu, tumasag chicharuk: “¿Apu urukamtai turutme?” tusa tinaiti. Nu tusa tama nayaimpinmaya shuar ayak: “Ame seammaun Yuus anturtamak, ame judío atsumaina yayámuncha ashi waitramak wina akuptukai. ");
INSERT INTO hubNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Yaakat Jopenam, Simón Pedro tutaiya nu utita tusam shuar akupkata. ");
INSERT INTO hubNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Nigka chikich Simón nuapen apau tutaiya nuna jeen nayantsan uwetas a nui pujawai. Ni tarutrami ame turumaina nunaka ujatmaktatme”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Nayaimpinmaya shuar chichaman ujakuka waketkimtai, Cornelio inatairin jimaran, tura chikichik suntar nekas Yuusnak enentaimtus wekainun untsuk, nina shir enentaimtin asa, ");
INSERT INTO hubNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","ashi ujak Jopenam akupkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Turam kashinia nui jinta eke Jopenam jeattak wenai, Pedrosha etsa tutupin jastatuk jai, jea tuntupe paka asamtai, nui pujus Yuusan aujsattsa yaki wakauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","11","Nui pujus senchi tsukamak yuattsa wakerayat, yurumkan eke inarainachkai pujau. Tuma pujai nayaim uranmatai, nayaimpinmaya jaanch wagkaram nagkattramurin chiki chikichik jigkakmaun wainkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Turamunam ashi cuatro nawentin aina, nápi aina chuag ainajai pachimka chumpiamu yakiya akaiki nugkanam tarauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Tumamtai Pedro, ju aina maam yuata, tusa nayaimpinmaya chichamun antukuiti. ");
INSERT INTO hubNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Nu tusa tama Pedro ayak: “Apuru, turashtatjai, wika tsumain pegkerchau aina aunka yuchauwajai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Nuna takai awentsag nayaimpinmaya chichaak: “Yuus pegkermamtikamua nuka ameka tsumainaiti tumaitsume”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Tresa imajnia iwaintuk, nui nayaimpinam ataksha jukinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Nu tuman wainak: “¿Urukanak au anuncha wainkaj?” tusa enentaima pujai, Cornelio akupkamu aina: Simónkan jee tui puja, tusar inii inimainakua waitinam jeantaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Tumawar senchi chichainak: “¿Ju jea jui Simón naartin chikich naari Pedro tutaiya nu pujatsuak?” tusa inimaina. ");
INSERT INTO hubNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pedroka ni wainkamurin enentaimtu pujaun Wakan Pegker chicharuk: “Pedro, tres shuar eatmainawai. ");
INSERT INTO hubNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Tuma asamtai nugka akaikim, iturchat enentaimtsuk nitajai iruuntram wetá, wii nitanka akupkamjai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Nu tusa tama Pedro akaiki, Cornelio akupkamu ainan jeari chicharuk: “Atum earum nuka wiyaitjai. ¿Urukamtai wina eatkurmesha winarme?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Nu tusa tama nita chichainak: “Ika Cornelio shuar pegker, Yuusan shir aneas emematin, ashi judío ainasha anenak wakerin aina nu, nayaimpinmaya shuar: Pedron utiti tusam shuar akupkata, turam ni taa ame turumaintrumnaka ujatmakti tusa tama akuptamkakrin winaji”, tuina. ");
INSERT INTO hubNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Nu tusa ujam Pedro jea awayaa nitajai kanararuiti. Tuma tsawaar Pedro shuar kaunkaujai weakai, Jopenmaya shuar Jesúsai surumankau aina ishichik uyuuniaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Tumawar Cesareanam Cornelio, ashi nina patai ainan, nekas nina amikri ainajai ipaa iruuntrar nakainak pujuinai jeawaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Tuma Pedro jea jeawaiti. Tumattamaun Cornelio wainak jiintuki igkug ememattasa tikishmatrauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Turam Pedro chicharuk: “Winaka emematripa, wajakta, wisha amea annuketjai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Nuna tusa chichaki waikma Cornelio ipaamu aina tuak atatmaun wainkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Tura Pedro chichaak: “Atumka nekarme, ii judío ainatika judíochu ainajaigka iruunchau ainaji. Tura nita jenkesha utuchu ainaji. Turasha Yuus wina chichartak: ‘Wii pegkermamtikamuka tsumain ainawai tiipa’, turutmayi. ");
INSERT INTO hubNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Turutin asamtai, tarutti turammayi turutainakaisha, iturchat enentaimtsuk wári winimjai. ¿Urukamtai winasha untsurkamam? Nuna yamai nekaattsan wakerajai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Nuna takai Cornelio ayak: “Cuatro tsawan nuna wainkan pujajai, ju aagkua juni ai wina jearui pujusnak ijarman pujusan Yuusa aujkun pujumjai. Tuma pujai nayaimpinmaya shuar jaanch kinarpatnun nugkuaru wantinturkamayi. ");
INSERT INTO hubNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Tuma chichartak: ‘Cornelio ame Yuus aujeam nunaka anturtamak, tura ame shuar atsumaina yayámurmincha nekartamayi. ");
INSERT INTO hubNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Turutma asamtai Jopenam shuar akupkata, turam Simón Pedro tutaiya nuna utiti. Nigka chikich Simón nuapen apau tutaiya nuna jeen nayantsa uwetas a nui pujawai, nu jui taa amijai chichasti’, tusa turutmayi. ");
INSERT INTO hubNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Nuna turutin asamtai wári uturtitarma tusan akuptukmajme. Turamu asam amesha taume, tuma asaakmin shir anenaji. Yamai Yuuscha waitmai jui iruuntraji, tumaina asar ashi amina Yuus turammau isha ame etserkumin, antukartasa wakeruinaji”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Nu tusa tama Pedro nagkama chichaak: “Nekasaiti wisha yamaika shir nekaajai, Yuuska shuar ainanka jushaa awai tutsuk, ashi metek iiyawai. ");
INSERT INTO hubNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Tura ashi nugkanmaya shuar ainasha ninak shir aneasar enentaimtuinak, pegkeran takainakaigka nunaka nakitatsui. ");
INSERT INTO hubNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Yuus Israel weantu ainan ujak: Jesucristo ashi shuaran apuri asamtai, shir agkan matsamsatnaittrume, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Atumka Juan Judea nugkanam Galileanam nagkama, chichaman etseruk, entsanam maitarma tu jakua nuka shir nekarme. ");
INSERT INTO hubNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Tura nuiyasha Jesús Nazaretnumia ajakua nuna Wakan Pegkeran Yuus akuptuk ichichmamtikam wekaas pegkeran takak, shuar iwanch egkemtuam waitu matsatuncha Yuus ninii pujau asamtai, pegker amaju jakua nusha nekarme. ");
INSERT INTO hubNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Nuka nekas isha Jesús Judea nugkanam, yaakat Jerusalénnumsha ni turawa nuka wainkauwaitji. Imatika wekan numinam achirar maawaru ainawai. ");
INSERT INTO hubNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Turawarmatai tres tsawan asa, Yuus inanki incha iwainturmakuitji. ");
INSERT INTO hubNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Turasha ashi shuarnaka wantintukchauwaiti, antsu Yuus yaunchuk nagkamas ni etegkramu ainatin nita etserkarti turamu asa wantinturmakuitji. Ii ainatika nekas maamu nantakmataisha, nijaimak yurumak yuaku umutcha umararmiaji. ");
INSERT INTO hubNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Inka: Werum chicham etserkurum, yamaika Yuus Jesúsnaka shuar iwáku, tura jakau ainajai etegkin amajas apujsayi tusarum titarma tusa ni akuptamkauwaitji. ");
INSERT INTO hubNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Yaunchuksha Yuusa chichamen etserin ajakarua nusha Jesúsan pachisar chichainak: Shuar ninii surumanainaka nita tunaurisha Jesúsa nuke tsagkuram artinaiti tusar chicha jakaru ainawai”. ");
INSERT INTO hubNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pedro tusa eke chichaa wajai, Wakan Pegkera nuka ashi shuar nu chichaman antuinanka egkemturaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","46","Judío aina Jesúsai surumankau Pedrojai kaunkaru ainasha judíochu ainanak Wakan Pegker egkemturarmatai, tura chikich chichamjai chichasar Yuusan emematainakai, enentai jearcharuiti. ");
INSERT INTO hubNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Tumainakai Pedro chichaak: “Atumsha ijai metek Wakan Pegker jukin asaakrumin, ika atumka entsanmagka maishtatrume tumaitsuji. ");
INSERT INTO hubNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Tau asa Jesucristo naari anaisarum imaitarma tusa tinaiti. Tusa timau asar entsanam maakar Pedron jui ishichik tsawankesha pujusam wetá”, tusar tuina. Nu tusa tama juakuiti. ");
INSERT INTO hubNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Nuna tumawaru ai, Jesúsa unuinatairi ajakaru aina, Judeanmaya shuar Jesúsai surumankau aina matsatujai, judíochu ainayat, Yuusa chichamen shir wakerus antuinawai tusa tamaun antukaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","3","Turasha Pedro Jerusalénnum waketki jeaamtai, judío Jesúsai surumankau aina chicharainak: “¿Urukamtai amesha judíochu ainanam wemesha, nita ainajai iruuntramsha yurumkasha yuamame?” tusar tuina. ");
INSERT INTO hubNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Tusa tuinakai nisha wetatku pujusa wainkamun nagkama, pachis nitan ujak: ");
INSERT INTO hubNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Wika yaakat Jopenam pujusan Yuusa auju pujukman, nayaimpinmaya jaanch wagkaram nagkatramuri chiki chikichik jigkattramu wii pujamunam ayaamrutas iyantrurun wainkamjai. ");
INSERT INTO hubNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Turan warig aisha a tusan esettsan iikman, ii yuchatai aina, kuntin cuatro nawentin aina, nápi aina chuag ainajai chumpiamu atatmaun wainkamjai. ");
INSERT INTO hubNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Tumai Pedro ju aina maam yuata, tusa nayaimpinmaya chichamun antukmajai. ");
INSERT INTO hubNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Turutkai wii ayakun: Apuru, turashtatjai, wika tsumain pegkerchau aina aunka yuchauwajai tusan timajai. ");
INSERT INTO hubNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Nuna tusan tai awentsag chichartak: ‘Yuus pegkermamtikamua nuka ameka tsumainaiti tusamka tumaitsume tusa turutmayi’. ");
INSERT INTO hubNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Tresa imajnia iwainturak nui nayaimpinam ataksha jukimai. ");
INSERT INTO hubNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Nuna tumamtai enentaima pujai, Cesareanmaya apu akupkamu tres shuar wii pujamunam jea tarutiarmayi. ");
INSERT INTO hubNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Tumawarmatai Wakan Pegker chichartak: ‘Antram judíochu ainawai, tusam iturchat enentaimtsuk nitajai iruuntram wetá’, tusa turutmayi. Ni turutu asamtai, wisha nu shuar ainajai weakai, seis shuar Jesúsai surumankau aina wina uyuuntuinak winiarmayi. Tumawarmatai nitajai iruuntsan Cornelio jeen wayamjai. ");
INSERT INTO hubNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Nui wayawakrin nayaimpinmaya shuar ni jeen tari chicharuk: ‘Yaakat Jopenam Simón Pedro tutaiya nu utita tusam shuar akupkata. ");
INSERT INTO hubNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Turam ni jui tarutrami, ame tura amina pataimijai uwemratnurmin shir ujatmakti’, tusa timau asa shuaran akupturkamtai wisha wemajai. ");
INSERT INTO hubNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Tuman nita matsatmaunam jeaan nitajai chichai, ina yama nagkamchak iturtamkamiaj nitancha turusag Wakan Pegker egkemturarmayi. ");
INSERT INTO hubNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Nuna tumamtai, yaunchuk Jesús chichaak: ‘Juanka entsajai imakratu jakuiti, turasha wika Wakan Pegkera nuna susatnaitjarme’, tusa turamnaitaj nu anearmaji. ");
INSERT INTO hubNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Nu uminu asamtai, wii chicham ujam apu Jesucristonam surumanainakai, Wakan Pegker egkemtauncha ¿wisha urukamtaig: Ameka juka aitkawaipa tusancha Yuusnasha titaja?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Nuna tusa tamaun Jerusalénnumia judío Jesúsai surumankau, aina antukar itattraru, tumawar Yuusan emematainak: “Yuus yamaika judíochu ainancha pujutin yapajiawar, nekas pujut nagkanchauncha jukiarti tusa aitkawai”, tuina. ");
INSERT INTO hubNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Estebankan maawarmatai, nui nagkamsar chikich shuar Jesúsai surumankau ainan waitkatan nagkamawaruiti. Turuinamu asar kanarar chikich nugkanam wenak Fenicianam, Chiprenam, Antioquíanmasha shiakaruiti. Tura nui matsamsar Jesúsa chichamenka judíochu ainanka ujatsuk, ima judío ainanak ujakaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Tumainai chikich shuar Chiprenmaya, chikich Cirenenmaya aina yaakat Antioquíanam jeawaruiti. Tumawar nita judíochu ainancha apu Jesúsa chichame uwemtikartina nuna ujaina. ");
INSERT INTO hubNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Turuinakai apu Jesúscha nitanka senchimtikawaru, turamu asarmatai shuar aina nita yaunchuk enentaimtairinka inaiyainak, Jesúsain nukap shuar surumanaina. ");
INSERT INTO hubNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Nu tumainamun shuar Jesúsai surumankau aina Jerusalénnum matsatu antukar, Bernabén Antioquíanam akupkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","24","Bernabéka shuar pegker, Wakan Pegker aramu asa yacha ajakuiti. Tura Criston nekaspapita tamaurisha imanisag arujakuiti. Tuma asa Antioquíanam jeaa, Yuus nuiya shuar ainan yayámun wainak shir aneasuiti. Tuma chicharuk: Kakaarum pujusrum apu Jesúscha nemarkatarma tusa tinaiti. Takai shuar aina apu Jesúsai nukap surumanaina. ");
INSERT INTO hubNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Nuna tura nui Bernabéka Tarsonam Saulon eak wuwaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Nui jeaakma Saulon wainak Antioquíanam jukinaiti. Nui jintinkartuinak chikichik uwí pujusaruiti. Antioquíanam nekas yama nagkamchak yaunchuk tuchatain shuar Jesúsai surumanainan Cristonu ainawai tuina. ");
INSERT INTO hubNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Nu tsawantin shuar Yuusa chichamen etserin Jerusalénnumia aina Antioquíanam wearuiti. ");
INSERT INTO hubNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Nu ainamunmaya chikichik shuar Agabo naartin Jesúsai surumankau aina iruuntramunam wajaki, Wakan Pegker chichamtikam chichaak: “Tsuka ashi nugkanam tepeattawai”, tusa tinaiti. Nu timauka Romanmaya apu Claudio pujai uminkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Nu tsuka tepeamtai Judeanmaya Jesúsai surumankau aina waitainakai, Antioquíanmaya shuar Jesúsai surumankau aina yainak, chiki chikichik shuar nita sumaintrinka turusag irumraruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Nuna turawar Bernabé Saulojai wenakai: Atum ju jukirum aiya shuar Jesúsai surumankau aina nuna apuri susatarma tusa akupkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Nu tsawantin apu Herodes nina suntaari ainan shuar Jesúsai surumankau aina achirtarma tusa ishitkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Tura asa “Jacobon” Juankan yachiya nuna kuchiijai ijurum maatarma tusa inamrauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","4","Nu turamu judío ainan shir amajkarmatai, nuna wainak Pedroncha maattsa wakera asa, Herodes suntarin chicharuk: Pedro achiktarma, turarum shir kuitamatarma jiisat Pascuaya ju nagkamasmatai, nui shuar iruuntramtai, chicham nekarami tusa ishitkauwaiti. Tura achikar cárcelnum egkeawaruiti. Nui nukap suntar cárcelan kuitamin aina cuatro akantramunmaya, cuatro suntar kuitamainak matsataina. Nunaka jiisat pan levadurajai pachimtsuk inaraamu yutai tsawaaru ai turawaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Turamu asa Pedroka shir kuitamam pujai, shuar Jesúsai surumankau aina mijamtsuk Yuusa tuke auju matsatu. ");
INSERT INTO hubNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Herodes kashin ashi shuar wainmaunam jiiktajai tusa timauka tsawatsaig, Pedroka jimar suntar eteam, tura jimar cadenajai jigkaam kanú tepai, chikich ainaka waitin kuitamaina. ");
INSERT INTO hubNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Tumainai nayaimpinmaya shuar wayawaiti, tumamtai cárcelka tsaaptin jasuiti. Tuma Pedro kanar tepettamaun mijarnum antiak: “Wári nantakta”, tusa tinaiti. Nuna taig Pedro cadenajai jigkarmauka nigki atinawaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Tumamtai nayaimpinmaya shuar chichaak: “Shir kaki akachumam zapatormesha weamakta”, tusa tinaiti. Nu tama Pedrosha turusag umikmatai, nayaimpinmaya shuar chicharuk: “Nugkutairam nugkuram, wii weakai nemartukta”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Nu tusa tama Pedrosha nigka nayaimpinmaya shuar jutikra junasha nekasash juniaj tusa shir nekachiat, ni weakai nemaras jiinkinaiti. Nigka ayatik karanam juniatsjash tusa wea. ");
INSERT INTO hubNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Tuma nekatkau kuitamkartak wajaunka nagkaikiar, nuiya chikich wajauncha turusag nagkaikiar, tresa juna waiti nekas aya jiruk epenmaunam jeantaruiti. Tumai nu waiti nigki urannaiti, tumamtai jiinkiaruiti. Tuma nayaimpinmaya shuar jinta yaaktanam weamunam kuak nigka waketuk Pedronak ikuknaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Turam Pedro nigki chichaak: “Nekaspapi wina Herodes achirak mantuataj tau asamtai, Yuus nayaimpinmaya shuaran akupturak jutikruaya tu enentaimrauwaiti”. ");
INSERT INTO hubNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Tuma Juan, chikich naari Marcosa nuna nukuri María pujamunam, nukap shuar iruuntrar Pedron pachisar Yuusa aujainak matsatmaunam jeawaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Tuma waitin uratriarti tusa awatkai, nuwa Rode naartin yakit tusa iistasa werinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Tuma waitinam jeaa wajas antukma, Pedro chichamen anturak waitinka uratsuk shir aneas tsekegki waketkinaiti. Tuma chichaak: “Pedro taayi”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Nuna takai nita chichainak: “¡Waurtsumek!” tusa tuina. Tusa tama, atsaa, nekas nina chichamen anturkajai, tusa tinaiti. Takaisha nita chichainak: “Pedroka amaitsui, nina wakanitskaitti”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Nuna tuinai ataksha waitin awatu, turakai waitin urakma Pedron wainkar ashamkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Tumainaig jea wayaa mitat asatarma tusa uwejen takuin, nui nagkama, Yuus tu winaka jiirkiyi tusa etserkauwaiti. Tura atum Santiago chikich yatsut ainajai ujaktarma tusa ikuak, nigka chikich nugkanam wuwaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Pedro tuma ai tsawaarmatai, suntar ainaka nuna emegkaakar chichainak: “¿Nusha urukamki?” tusar senchi pampaina. ");
INSERT INTO hubNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herodes suntar ainan chicharuk: Werum eaktarma tusa ishitkauwaiti. Turam eainaksha waintsuk waketar jeawarmatai: ¿Nusha urukama? tusa nuna kuitamainan inina. Turamsha nitasha wainkacharu asar etserainachkai, kajerak ju ainaka maatarma tusa inamar ikuknaiti. Tura Judea nugkanka ikuak Cesareanam pujustasa wuwaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herodes Tironmaya ainan, tura Sidónnumia ainancha kajerkauwaiti. Turamaitiat nuiyan yutain sumak juina asar, chichaman epegtuniawartasa wakekaruiti. Tumaina asar apu jeen kuitamin Blastojai shir chichasar, ikuinak nukap shuar Herodesan jearawar: “Yamaika chichamka epegtuniami”, tusar tuina. ");
INSERT INTO hubNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Tuinakai nu tsawan jeaakai kaunkatarma, tusa tsawantan nekapmawaiti. Nu tsawan nekapmamuri jeaamtai, apu nugkutairi shir pegkeran nugkur shuar iruuntramtai, ni ekeemtairi yaki aunam ekeemas chichaa. ");
INSERT INTO hubNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Tumakai shuar ainaka senchi chichainak: “Juka shuar chichaa jatsui, nekaska yuus chichaa jawai”, tusar imatruina. ");
INSERT INTO hubNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Nu imatruinamsha: Wika Yuuschauwaitjai tusagka tachau asamtai, Yuus nayaimpinmaya shuaran: Ame waitat susata tama, waittan suak akan ishitkau, turam Herodesnaka iwákunak aka amukuiti. ");
INSERT INTO hubNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Nuna tumamtai Jesúsai surumankau agkan chikich yaaktanam yujasar chichamnaka ashi etseraina. Tumainakai nuna chikich ainasha antukar Jesúsai surumanainakai, nu senchi kawegkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Tumainak Bernabésha Saulojai nita takamurinka ashimkar, Jerusalénnum waketainak Juan, Marcos tutaiya nuna jukiaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Yaakat Antioquíanam iruuntramunam Jesúsai surumankau aina Yuusa chichamen etserin tura jintinkartin aina matsamsaru. Nuka ju ainawai: Bernabé, Simón Negro tutai, Lucio Cirenenmaya shuara nu, Manaén Galileanmaya shuar Herodesjai pujus tsakarua nu, Saulo nu aina. ");
INSERT INTO hubNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Nui matsamsar, yurumkan ijarmawar Yuusa aujainak matsataina, tuma matsatun Wakan Pegker chicharuk: “Bernabéka Saulojai chikich nugkanam Yuusa chichamen etserkarti tusarum akupkatarma, turawakrumin wii etegka asan, nita wekaasa takastintrinka iwaintuktatjai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Nu tusa tama yutsuk pujamunka inaiyainak, muuknum achikar Yuusan aujtusar akupkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Tura Wakan Pegker akupkam yaakat Seleucianam jeawar, botenam egkemrar nayantsa ajuntairi Chipre tutainam katigkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Tuma yaakat Salamina tutainam jeawaruiti, tumawar nui Yuusa chichamen judío iruunmaunam etseraina. Turuinak Juan Marcos tutaiya nunasha nita ayakaina. ");
INSERT INTO hubNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Nu yaaktanmaya jiinkiar ajuntainmag ashi wekaatusar chicharkartukar tura nagkamakiar yaakat Pafos tutainam jeawaruiti. Tumakma judío iwishin Barjesús naartin griego chichamnum Elimas tuuta amajtai pujaun wainkaruiti. Nu iwishnuka Yuusnumian chichaajai, tusa tsanumin ajakuiti. ");
INSERT INTO hubNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Nigka shuara apuri Sergio Paulo tutaijai wekajaku. Nu apuka nekas yacha iman asa: “Bernabé Saulojai taati. Wisha nita Yuusa chichamen etserkai antuktajai”, tusa tinaiti. Nu tusa tama Bernabésha Saulojai jeariar, nu apun Yuusa chichamen ujaina. ");
INSERT INTO hubNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Nuna ujainak matsamtai, iwishin Elimascha jeari apu Sergion chicharuk: “Auna ujatmaina nuka nekaschauwaiti, waitan ujatmainawai, ameka auka anturmaitsume”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Nuna tusa takai Saulo, Pablo tutaiya nusha, Wakan Pegker chichamtikam iwishnun iis ");
INSERT INTO hubNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","chicharuk: “Ameka shir pegkerchau, iwanchin uchiri asam, ashi pegker aina nu pegkerchau amajnaitme. ¿Urukamtai Yuusa chichame nekas tuke pegkera nusha pegkerchauwa nunin amajsattsamsha tu wekame? ");
INSERT INTO hubNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Yamai nekaata, Yuus amina waittan suramuk, wainmachu amajtamsattawai. Turutmamtai etsa etsanmausha waintsuk nukap tsawan pujustatme”, tusa tinaiti. Nu tusa tamauwaik iwishnusha wainmachu jasuiti. Tuma shuaran eak: “Ame egkersam ewekattsata”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Nuna tumamtai apu Sergiosha Yuusa chichamen etsermaun antuk enentain jearchauwaiti. Tuma asa, Yuusan nekaspapita, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pablo ni tsaniasa yujamun metek botenam egkemar, Pafosa ikuki yaakat Pergenum, Panfilia nugkanam katigkuiti. Turasha Juanka takatan inaiyak Jerusalénnum waketkinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Tumamtai nitaka jimarchik Pablo Bernabéjai Pisidia nugkanam, yaakat Antioquíanam wearuiti. Tuma nui pujuinai, ayamtai tsawan tsawaarmatai judío iruunmaunam wayaa ekeemsaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Tumawarmatai iruuntai jean apuri aina Moisés aarmaun aujsar, Yuusa chichamen etserin aarmauncha aujsar ashimkar chichainak: “Yatsur ainata, atum chichamaintrum arutramkaigka, yamai chichaktarma”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Nu tusa tama Pablosha wajaki, uwejen takui chichaak: “Israelita ainata, tura judíochu ainatirmesha, Yuus enentaimtakrum pujakrumka, wii chichaakai shir anturtuktarma. ");
INSERT INTO hubNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Ina uuntri Israel shuar aina Egiptonam pachinak matsamajakua nunaka ina Yuusri etegkauwaiti, tura ju nekas shuar iman arti tusa ni senchirinig jiiruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Tura yaruak, aya nugkanmag cuarenta uwí matsasuiti. Tura pegkerchaun takainakai waittan sumain akusha kuitamkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Tura nugka Canaán tutainam, nukap shuar siete yaaktanmaya chiki chikichik nitasha chichaaku matsamnun ashi ijina ina uuntri ainan matsasuiti. ");
INSERT INTO hubNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Turamu asar nui nita akinak matsamsaruiti. Turasha nita apurigka atsau, ayatik chichaman epegkin ainak pujuina. Tumasag matsamas cuatrocientos cincuenta uwí matsatai, chikichik uchi Yuusa chichamen etserin atin, Samuel akinawaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Nuna Samuelan Israel shuar aina chicharainak: Ame ina apuri atin anaikata tusa tuina. Nu tusa tama Samuelsha Yuusan aujsauwaiti. Turam Yuus: Saúl, Cisa uchiri, ju apu atii tusa tinaiti. Nuka Saúlka Benjamín weantu ajakuiti. Nu Saúlka apuma cuarenta uwí pujusuiti. ");
INSERT INTO hubNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Tumattamaun Yuus Saulon inaiyak, ju apu atii tusa Davidtan anaikauwaiti. Tura chichaak: ‘David, Isaí uchiri, wii wakeramun turusag umirtin asa, wina wakerutairuiti’, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Nuna timatai nukap pujus, nu David weantunam Israel shuar ainan uwemtikati, tusa Yuus akupkamu Jesús akinawaiti. Nunaka yaunchuk timaurin imatiksag umikuiti. ");
INSERT INTO hubNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Turasha nuka akintsaig Juankaa akinawaiti. Nu ashi Israel shuar ainan chicharuk: ‘Tunaurum inaiyakrum entsanam maitarma’, tusa tu chicharujakuiti. ");
INSERT INTO hubNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Tumak mantamnattak pujus chichaak: ‘Wika atum enentaimtarum nuchauwaitjai. Nuka wina ukuruin winittawai. Turasha wika nijaigka pegkesha tunaimaitsujai’, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Yatsur Abraham weantu ainata, tura judíochu ainatirmesha, Yuus enentaimtakrum pujautiram, ju chicham uwemtikartin pachisa etsermaun Yuus akupturmakua juka atumnauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Turasha Jerusalénnumia ainaka, nita apuri ainajai nekas Jesúsapi uwemtikartinaita tusar ticharuiti. Nitasha ayamtai tsawantinka Yuusa chichamen etserin aina yaunchuk aarmaunka tuke aujsarkee ainayat, nuna takumpapi tawa tusarka nekacharuiti. Tumaina asar yaunchuk Yuusa chichamen etserin aina aarmaun uminak, Jesúsan mantamnati tiaru ainawai. ");
INSERT INTO hubNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ni makumamaintrigka atsuraig, mantamnati tusar Pilaton seawaru ainawai. ");
INSERT INTO hubNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Nuna tura yaunchuk aarmau tumatnaiti timaun ashi umikuiti. Nu tuma uminkamtai Jesúsa iyashi numinam achirmaun kueki jukiar, shuar ikustin taimunam egkea ikusu ainawai. ");
INSERT INTO hubNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Turawarmataisha Yuus inankinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Tura inankim nijai Galileanmaya Jerusalénnum weaku iruuntsa yujajakmau ainan nukap wantiintukuiti. Turamu asar yamai ni pachisar shuar aina antukarti tusar chicharkartuinawai. ");
INSERT INTO hubNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Nui isha chicham pegkera nu pachisar atum ujaktasar taaji. Yuus ina apachrin anajmatawa nuka ");
INSERT INTO hubNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","ii waintrin maam jaka nantaki yamaika umikai. Nuna pachis David Salmosnum tu aaruiti: ‘Wii shuarnum akinati tima akina asam, ameka wina uchiruitme’. ");
INSERT INTO hubNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Yuus inankim iyashi kaurchatnuncha yaunchuk emtika chichaak: ‘Wii nekas pegkeran Davidtan anajmatawaitaj nuna umiktajai’, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Tura chikishcha Salmosnum David aarmau awai: ‘Wina inatair Pegkera nu kaurtii tusamka wina iyashruka inaitursashtinaitme’. ");
INSERT INTO hubNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Nunaka Davidtan taku tichauwaiti, antsu Jesúsan taku tinaiti. David jui pujus Yuus turata timaun ashi umik nui jakauwaiti. Tumamtai ikusam kauruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Turasha Jesúsa iyashigka Yuus inankimu asa kaurchauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","Yatsur ainata, atumka shir nekamain ainarme, tunau yamaika tsagkurnarurme tamau pachisa atum ujajrum nu, Jesús nina senchirinig ina tunaurinka tsagkurtamrauwaitji. Turutma asamtai chicham umiktarma tusa Moisés timauriya nuna ashi umiachkaisha, ashi shuar nina shir enentaimtaunka Yuus nita tunaurincha tsagkuratnaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Yuusa chichamen etserin Habacuc naartin aarmauwa nu uminkai tusarum kuitammamatarma, nu chichaak: ");
INSERT INTO hubNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Wishikkartin ainata antuktarma. Wii Yuus asan atum wainkachmaun nekas wake mesersa iimain ainan iwaintuktinaitjarme. Turamsha nuka pachitsuk inaiya asarum, chikich shuarkesha nuna ujatmainakaisha, pegke pachikchatin ainarme. Tumaina asarum wina ashamrukrum nekas megkaaratnaitrume’ ”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Nuna tusa ashimak Pablo ni tsaniasa yujamu ainajai judío iruuntairinia jinainakai, shuar judíochu ainayat, nui nitasha utsaana irunu asa, wait aneasam chikich sábado tsawan tsawaitta nuisha, jui tame ataksha junismek ame etseram nu etserkata tusar tuina. ");
INSERT INTO hubNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Iruunmau ashimnakmatai iruuntai jeanmaya weakai nekas judío aina, tura judíomawaru aina umirmaun umirina ainajai, imatiksag chichaman umina asar, Pablo Bernabéjai jiinki weakai nita patatukaru. Tumawarmatai nu wininan chicharainak: “Atumka Yuus aneakrum, shir kakaarum pujustarma”, tusar chicharkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Sábado tsawan ataksha jeaamtai, Yuus ememattasa iruuntai jeanam ashi nu yaaktanam matsatainaka Yuusa chichame etsermaun antukartasa iruuntraruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Nu tumawarun judío aina wainkar senchi kajekar chichainak: “Pabloka aantar tu chichawai”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Tuinam Pabloka Bernabéjai ashamkartutsuk chichainak: Yuus turatarma turamin asamtai, yama nagkamchakrika ni chichamea nuka atumea ujamain ainaji. Turamaitiatrum atum nu antutka nakitainakrum, pujut nagkanchau jutaka nakitakrumin, yamaika ju chichamka judíochu aina ujaktasa wetatji. ");
INSERT INTO hubNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Apu Yuus chichartamuk: “Wii aminka wina chichamrun ashi nugkanam etserkati, tusan tsaaptina numamtin amajsan akupkauwaitjarme” tusa turamnaitji tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Nuna tusa tuinakai judíochu ainaka shir aneasaruiti, imaninak Yuusa chichamegka nekas pegkeraiti tuina asar, shuar pujut nagkanchaun jukiarti tusa Yuus etegkramu ainaka nekaspapita, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Tuina asarmatai nu nugkanmayanka ashi shuaran Yuusa chichamenka ujakaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Turuina asarmatai judío aina nita nuwarijai Moisésa chichamencha umirin, chikich apu ainajai chichasar, ina nugkeen tu yuja au jiikiarmi tusar senchi waitkaina. ");
INSERT INTO hubNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Imatikainam yaakat Iconionam wenak nita zapatorin ukuinkar jukiar, nui tsetse irunun peatrar akaketak ikukiaruiti. Nunaka atumka ika chichamka ujamaitiatrum nakitraurme taku turawaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Nuna tumawarmataisha, nuiya shuar Jesúsai surumankau ainaka Wakan Pegker aramu asar, shir aneasar nakunkut matsataina. ");
INSERT INTO hubNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Pablo Bernabéjai Iconionam jeawar, judío iruuntairin wayaawar, Jesúsan pachisar shir etseraina. Tumainakai nuna antukar nukap judío aina, griego shuar ainajai nekaspapita tuina. ");
INSERT INTO hubNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Turasha judío nekaspapita tichau aina, Jesúsan nemarin ainan kajerkarti, tusar judíochu ainan tsanuina. ");
INSERT INTO hubNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Turuinakaisha Jesúsapi yainmaktatjia tuina asar, nukap tsawan arantsuk chicharkartu pujuina, yaunchuksha wainkachmaun shuar ainasha nuna wainainak nekaspapita tiarti tusar nukap iwainaina. ");
INSERT INTO hubNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Tumainakai Iconionmaya Jesús chicharkartukta tusa akupkamun atuinasha aina, tura judío aina nu chichaman antutan nakitainan atuinasha aina tumainak kanakaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Tumaina asar shuar Jesúsa enentaimtichu ainaka nita apurin aujainak: “Shuar Jesúsa chichamen pachis etseraina nuka waitkakur kayajai tukuarmi”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Nu tuinamun antukar Pablo Bernabéjai Licaonianmaya yaakat Listra, Derbe, tura nuiyasha chikich yaakat jeashtachu ainanam wearuiti. ");
INSERT INTO hubNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Tuma nui jeawar chicham uwemtikartina nuna etseraina. ");
INSERT INTO hubNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Nu Listranam chikichik shuar tuke tumauk akina asa, wekaichu pujuttamaun wainkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Nu shuar nunin Pablo chicharkartakai, antu eketun Pablosha esetas iikma, nekas nigka pegker amajtumainapita tusa tu enentaima eketun wainkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Tura senchi chicharuk: “Wajakim wekasata”, tusa tinaiti. Nu tamauwaik tsekegki wajaki wekatan nagkamawaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Pablo nuna turakai, shuar aina wainkar Licaonia chichamjai chichasar: “Yuus aina shuarnum ina tarutramawarji”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Tuina asar Bernabénka chicharainak: “Juka yuus Júpitraiti”, tuina, tura Pablonka ni chicharkartau asamtai: “Juka yuus Mercuriowaiti”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Yaakat yama wayamunam yuus Júpiter nu ememattai chikichik jea au. Tuma asamtai nuiya sacerdote vaca aishmag ainan juki, nuiyasha yagkur ainajai iwarmamar yaruak nukap shuaran nu tagku maa epeaku emematiarmi tusar yaruak kaunkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Nu tumamun Pablo Bernabéjai wainkar, jaanchrin jaakar shuar tuak iruunmaunmag nitasha wajan senchi chichainak: ");
INSERT INTO hubNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Uun ainata, ¿urukakrumea ausha aitkarme? isha atum ainarum annuketji, nekas Yuus iwáku nayaimpinam puju, ashi nayaimpinam, nugkanmasha, tura nayants aina nuisha matsataina nujai najanawa nu umirkatarma. Ika nu pachisa etserkattsa yujainaji. ");
INSERT INTO hubNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Antsu yaunchuk Yuus ashi shuar ainan nita wakeruinamunak yujarsarti tusa inaisauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Turawaitiat: Wii nekas Yuusaitaj nuna nekarawarti tusa yumin yutumtikauwaiti, ju inijam árak ainasha shir tsapainiar nerekarmatai, shuar ainasha nuna yuinak shir aneasar matsamarti tinaiti”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Nuna tusa tuinakaisha, shuar ainaka vaca maar epeakur, Pablo Bernabéjai emematiarmi tuinayat, inaisatarma tuinamu asar inaisaru ainawai. ");
INSERT INTO hubNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Tumainai judío Antioquíanam matsamin aina, chikich Iconionmaya ainajai kaunkar, shuar ainanka nita nepetkiar Pablon jukiar, kayajai tukui tukuinakua shir maatsuk jakayistai, tusar japiki jukiar yaaktan ikumtiksag aepkiaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Tura aepkiarmatai Jesúsai surumankau aina tenteawar matsamtuinai, Pablosha anean nantaki ataksha yaaktanam wayaa, tuma kashinia nui Bernabéjai Derbenam wearuiti. ");
INSERT INTO hubNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Nui jeawar chicham uwemtikartina nuna chicharkartukar, nukap shuar nuna antukar Jesúsai surumankarmatai ikuinak Listra, Iconio, Antioquía aina nu yaaktanam waketkiaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Nu yaakat ainanam jeawar, shuar Jesúsai surumanainanka enentai ichichtuinak: “Pe kakaarum pujusrum, nigki enentaimtusrum umirkatarma, Yuusa inamtairia nui wayaataj tamauka nekas senchi waitnawai”, tusa ujakaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Turawar chiki chikichik yaaktanam Jesúsai surumankau ainan uuntrincha anaitur, ijarmakar matsamsar, Yuusan aujtus atum nekaspapita tuina asaakrumin, apu Jesúsa nuke atumnasha yainmakarti, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Nuna turawar ikuinak Pisidia nugkanam nagkamakiar, Panfilia nugkanam jeawaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Tumawar yaakat Pergenum chichaman etserkar ikuinak Atalíanam wear, ");
INSERT INTO hubNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","nui botenam egkemrar, Antioquíanam chikich shuar Jesúsai surumankau ainasha nuig matsatu asamtai, yamaika atum Yuus yainmasmatai, nina chichame etserkatarma tusarum timarum nusha ashi umikji tiartasa waketkiaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Tura Antioquíanam jeawar, ashi nui shuar Jesúsai surumankau ainan irumar, Yuus tu yainmakmaji tura judíochu ainasha Yuus yayámu asar, Jesúsnak nekaspapita tiarmayi tusar etseraina. ");
INSERT INTO hubNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Tura umikar Pablo Bernabéjai nu yaaktanam shuar Jesúsai surumankau ainajai iruuntrar nukap tsawan matsamsaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Nu tsawantai Judeanmaya shuar Antioquíanam shiaku aina, nitasha shuar Jesúsai surumankau ainan jintintan nagkamawar, Moisés shuar uwemramij tuinakka nekas kati mushuken tsupimain ainawai tinaiti, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","3","Tuinamun Pablo Bernabéjai antukar, urukakug nunasha tumati tusa senchi pampannaiyaina. Tumainakai nitan chicharuk: Chikich ainajai atum Jerusalénnum werum, ju pachisrum Jesúsa unuinatairi ainajai, tura Jesúsai surumankau apuri ainajaisha chichastaarma tusar Antioquíanmaya shuar Jesúsai surumankau aina Pablon Bernabéjai akupkaruiti. Turamu asar Fenicia nugkanam, Samaria nugkanmasha nagkamainak, yamaika judíochu ainasha nita yaunchuk umirtairinka inaiyainak Yuusan umirainawai, tusa etse etserainakua shimuina. Tumaina asarmatai nuiya shuar ainasha nuna antukar shir aneasaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Pablo Bernabéjai Jerusalénnum jeawar Jesúsai surumankau aina, tura Jesúsa unuinatairi ainasha tura Jesúsai surumankau ainan apuri ainasha, shir anentas jukiaruiti. Turawaram Yuus yayasam nita takasmaurincha imatiksag nitancha ujaina. ");
INSERT INTO hubNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Nuna antukar fariseo shuar aina, Jesúsai nekaspapita tuina wajakiar chichainak: “Nekas judíochu ainasha chicham umiktarma Moisés timauncha uminak, kati mushukencha tsupimain ainawai”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Tuinakai Jesúsa unuinatairi ajakaru aina, Jesúsai surumankau apuri ainajai nusha uruk amainkit, tusar nekaawartasa iruuntraruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Nu pachisa chichamramunam Pedro wajaki chichaak: “Yatsur ainata, Yuus ii ainaj juiyatinak judíochu ainancha chicham uwemtikartina nuna ujakti, turam nitasha Jesúsnak enentaimtusarti tusa turutu asa, wina etegtuawa nuka atumka shir nekarme. ");
INSERT INTO hubNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Shuar enentaimmauncha Yuus ashi nekauwa nu, ina iturtamkamiaj turusag nitancha Wakan Pegkeran egketrarmiayi. ");
INSERT INTO hubNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Yuuska inka chikich shuar ainajaisha akantamar iirmatsuk, ashi metek Jesúsa enentaimtuinanka tunaurincha utsantui. ");
INSERT INTO hubNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Ni nuna turaisha ¿urukamtai atumsha judíochu aina Moisésa chichame ashi umikarti tusha enentaimrume? ¿Yuus kajertamkat tusarum nuka tatsurmeash? Iksha, tura ina uuntri ainaksha umikcharu aisha ¿urukamtai nusha tarume? ");
INSERT INTO hubNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ika nu umitsuk apu Jesúsa nuna anenkari nuke shir enentaimtuina asar uwemrauwaitji. Tura nitasha tumasag uwemainawai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Nuna timatai itattraru. Tumawarmatai Bernabé Pablojai Yuus yainmasmatai, wainchatai ainasha judíochu ainanmasha iwainamji tusar etserainakai, ekeemsar antu iruunaina. ");
INSERT INTO hubNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Chichamun ashimkarmatai Santiago wajaki chichaak: “Yatsur ainata, winasha anturtuktarma: ");
INSERT INTO hubNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simón Pedro judíochu ainancha yamai nagkamsarka wii shuar arti tusa Yuus etegkrayi tusa etserkamai. ");
INSERT INTO hubNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Nuna tuma nuka yaunchuk Yuus akattram etseru jakarua nu tu aararuiti”. ");
INSERT INTO hubNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","“Nu tumamtaisha David weantu aina yaja kanarar matsatunka yaunchuk aya imanisag arti, tusan wii ataksha irumrattajai. ");
INSERT INTO hubNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Tumawar chikich ainasha ashi chikich nugka ainanam wina pachittsar chichau aina nuiyasha ima winak eatiarti. ");
INSERT INTO hubNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Nuna tusa apu Yuus nina chichamen yaunchukiancha nekamtikartina nu tinaiti”. ");
INSERT INTO hubNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Tuma asamtai wika judíochuitiat nita yaunchuk enentaimtutairinka inaiyainak, Yuusa umirkartasa wakeruinaka iturchat enentaimtuscharti tusan tajai. ");
INSERT INTO hubNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Tura papiinum aatkursha, yutai shuar yuusrimamu aina anajmatamua nuka yuawairpa, tura atumi nuwenchuka takasairpa, tura kuntin numpe ajapruachmauka yuawairpa, tusar nuke timi. ");
INSERT INTO hubNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Nitaka yaunchuk nagkamsar ashi yaaktanam chicham umikta tusa Moisés aarmauwa nunaka tuke etserujaku ainawai, nunaka yamaikisha judío iruuntairi ainanmagka ashi sábado tsawantin tuke aujsagkee au asar nekainawai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Tusa takai Jesúsa unuinatairi aina, tura Jesúsai surumankau ainasha, nita uuntri ainajaimak iruuntrar shuaran eakar, Pablo Bernabéjai Antioquíanam wenakai, jimar shuar nekas anturtain Judas Barsabás tutain Silasjai atum nita papiin suruinakai wetaarma tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Tura papi akupkatnun aainak: “Ii Jesúsa unuinatairi ainati Jesúsai surumankau apuri ainajaimak iruuntsa yatsur judíochu ainatirmin Antioquíanam, tura Siria nugkanam, tura Cilicia nugkanam matsatutirmin shir anentsa chichaman papiinum aara akuptajrume. ");
INSERT INTO hubNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Turakur tajarme: Inia shuar ainaka ii akupeachmaitiat nitak kauttramawar, nita chichamenig waitkainak enentaincha pachimruraru tamau antukji. ");
INSERT INTO hubNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Nu antukaru asar, iruuntrar shir chichasar, juiya yatsut ainajai ina wakerutairi yatsur Bernabé Pablojai nui tawar irartamsarti tusa akupenaji. ");
INSERT INTO hubNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Ina apuri Jesucristo chichamen etseraina asarmatai, nitanka maataj tiaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Nu yatsut wininakai Judasan Silasjai akuptajrume, nita nui tawar ii aaraj juna pachisarka shir ujatmakarti. ");
INSERT INTO hubNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Atumnaka Wakan Pegkera nusha atum umikchamnauwa imannaka utuwatramkattsagka wakerutmatsrume. Tuma asamtai isha aitkasrik enentaimtuinajrume: ");
INSERT INTO hubNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Yutai shuar yuusrimamu aina anajmatamua nuka yuawairpa. Tura kuntin numpe ajapruachmauka yuawairpa. Tura atumi nuwenchuka takasairpa. Junak tajarme. Atumnasha Yuus yainmakarti”, tusa tu aararuiti. ");
INSERT INTO hubNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Nu papi aarmaun jukiar Antioquíanam jeawar, Jesúsai surumankau ainan irumar, papi aarmaun susaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Tura nuna papiin jukiar aujenakai, nuna antukar, enentai ichichtuinamu asar, shir aneasaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judas Silasjai Yuusa chichamen etserin asar, nuiya yatsut Jesúsai surumankau ainancha ujainak, enentain ichichtuinak wakerumtikaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Nukap tsawan nui matsatmaunam Judas waketkai: Yamaika isha shir nekaaji, ai jeamsha aiya ainasha chicham ujatrukarta, tusa chichaman shir akattrar akupkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Silaska ni tsaniasa yujamu waketainakaisha wika pujustajai tusa juakuiti. ");
INSERT INTO hubNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Tura Pablo Bernabéjai Antioquíanmag chikich ainajai juakar matsamas jintinkartuinak, apu Jesúsa chichamencha chicharkartu matsataina. ");
INSERT INTO hubNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Ishichik tsawan matsamsar Pablo Bernabén chicharuk: “Ataksha waketkir ashi yaaktanam apu Jesúsa chichame etserkamaj nu weri, nitasha uruk matsatainawak iisarmi”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Nu tamaunam Bernabé Juan Marcos tutaiya nuna jukittsa wakera. ");
INSERT INTO hubNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Turasha Pabloka nunaka Panfilia nugkanam ikuak, nitajai takatnaka inaisau asamtai, jumain enentaimchau. ");
INSERT INTO hubNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Nuna turakai metekchau enentaimrar kanakaruiti. Tumawar Bernabéka Marcosan juki Chiprenam wuwaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Tumai Pabloka Silasan juki weakai, shuar Jesúsai surumankau aina, apu Jesús yainmasmatai wekasatarma tusa shir akattram wenak, ");
INSERT INTO hubNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Siria nugkanam, tura Cilicia nugkanmasha yatsut Jesúsai surumankau matsatun wakemamtikar nagkaikiaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pablo Silasjai yaakat Derbenam jeawar nagkamakiar, Listranam yujakma, judíonmaya nuwa, griegonmaya shuar nuatkam jurermauwa nuna Jesúsai surumankaun Timoteo naartinan wainkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Listranam tura Iconionmasha Jesúsai surumankau pujuinaka nuna pachisar pegker chichaina. ");
INSERT INTO hubNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Tuina asarmatai Pablo wina uyuuntusti tusa jukittsa wakera, turaksha nu yaakat ainanam judío matsatuka Timoteo apari griego shuar ajakunka shir nekaina asar, pegkerchau chicharkarai tau asa, Pabloka Timoteon kati mushuke tsupirkatarma tusa inamrauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Tura nuna juki ashi yaaktanam nita jeamunmagka, shuar Jesúsai surumankau ainanam etseru wekaina, Jesúsa unuinatairi aina, Jesúsai surumanainan apurijai Jerusalénnum matsamas aarmaun pachisar etserkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Nu tusa etserainamun antuinak, nuiya shuar Jesúsai surumankausha shir ichichmamrar Jesúsnak enentaimtuina. Tumainak Jesúsai surumanainaka kashi kashinig kawena. ");
INSERT INTO hubNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Pablo Silasjai Asianam chicham etserkur wemi tusa tuina. Turasha Wakan Pegkerka wearti tusagka agkanka inaisachu. Nu turamu asar nuigka wetsuk Frigia nugkanam jeawar, Galacia nugkan nagkaikiar, ");
INSERT INTO hubNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Misia nugka nagkatramunam tiiju jeawaruiti. Tumawar nuiyasha Bitinia nugkanam jeawartasa enentaimainakaisha, Wakan Pegkerka nu nugkanam wearti tusagka agkan inaisachuiti. ");
INSERT INTO hubNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Turam tutupnik Misian nagkaikiar, yaakat Troas tutainam jeawar anumtainam wearuiti. ");
INSERT INTO hubNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Tumawar Pablo nui kanittamaun káshi kara numamtinnum Macedonianmaya shuar wajas chichaak: “Macedonianam katigkam, incha jintinkartuata” taun wainkauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Nuna Pablo tu wainkau asa, Yuus Jesúsa chichamen nekas Macedonianam etserkarti tusa aitkarayi takai, ii wetin iikma bote wainkar nui wii Lucasaitaj nu, Pablo, Silas, Timoteo nu ainajai iruuntrar chumpimrar shiakmiaji. ");
INSERT INTO hubNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Tumawara Troasnumia botenam egkemrar, tutupnik wea weakuar ajuntai Samotracianam jeaar, kashinia nui Neápolisnum jeamiaji. ");
INSERT INTO hubNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Nui pujusar Filipos Macedonianmaya yaakat nekas uunta nui Romanmaya apu pujamunam jeamiaji. Tuma nui ishichik tsawan pujusmiaji. ");
INSERT INTO hubNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Nui pujarin sábado tsawan tsawaarmatai, yaakat ikukir entsa yantam aa iruuntrar Yuus aujtainam jeawara, nuwa aina iruuntrarmatai, isha nui iruuntsara chicham ujamiaji. ");
INSERT INTO hubNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Nu nuwa ainanam Tiatiranmaya nuwa Lidia naartin jaanch yamakaitkaun pegkeran surin, Yuusnasha nuka emematin asa antu ekemmiayi. Tumattamaun Pablo etsermauncha shir antukti tusa Yuus enentaimtikramiayi. ");
INSERT INTO hubNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Turamu asa Jesúsai surumankamtai, ashi ni pataijaimak imaimiayi. Nu turam ina chichartamuk: Atumsha wii nekas Jesúsai surumankau waitkurmeka, wina jearui taarum kanartarma tusa turamkai, ni pujamunam wemiaji. ");
INSERT INTO hubNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Nui pujusar aa iruuntrar Yuus aujtainam wekamar, nuwa iwanch nekamin egkemtuamu, misatkama jukimu, nu nekamtikam nekamunam nukap kuitan yaruak ni patrónkrin su pujurin wainkamiaji. ");
INSERT INTO hubNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Turam nu nuwa ii Pablojai wearin pataturmak winis senchi untsumuk: “Ju shuar aina juka Yuus nayaimpinam puja nuna umirin asar, chicham uwemtikartina nuna atumnasha ujatmakartasa wininawai”, tusa timiayi. ");
INSERT INTO hubNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Nunaka nukap tsawan imatu wekaimiayi. Imatu wekakai antu anturu Pablo kajerak ayanmata, iwanch nuwanam pujaun chicharuk: “Jesucristo turata tusa turutin asamtai tajame, nu nuwa ikuakum jiinkim wetá”, tusa timiayi. Nu tusa tamauwaik iwancha wári jiinki weak, nuwanka agkan ikukmiayi. ");
INSERT INTO hubNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Nu tumamtai nuwan apujas pujuras ni nekakai, kuitan yaruma puju, turachminu jasmatai kajekar, Pablon Silasjai shuar iruuntai yaakat ajapeen aunam apu ainasha nui irunu asamtai, achikar ejéniarmiayi. ");
INSERT INTO hubNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Tura chichaman epegkin ainanam ejéniar chichainak: “Ju judío ainayat ina yaaktarin tawar itit amajkartuinawai. ");
INSERT INTO hubNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Turukratainak nita umitairin incha jintintramainaji, turasha nuka ika Romanmaya shuar asar umirmaitsuji”, tusa tiarmiayi. ");
INSERT INTO hubNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Nuna tuinakai shuar ainaka Pablon Silasjai senchi kajeraina, turuinakai apu chichaman epegkin ainasha chichainak: “Awikrum numijai asutiatarma”, tusa inamrarmiayi. ");
INSERT INTO hubNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Nuna timatai senchi asu asutainakua cárcelnum egkeawar, achikmaun kuitamnun: “Shir kuitamata”, tusa tiarmiayi. ");
INSERT INTO hubNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Nu tusa tima achikmaun kuitamnusha juki, jea nagkatkamunam tsukin ejé, tabla nekapmasa uyukmaunam nawen wearar shir chanuar ukuinkachminu amajas ikuknaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Imatika ikukmauwaitiat ajampek Pablo Silasjai Yuusan aujainakai, tura kantamainakai, chikich shuar achirmau chumpirusha antu matsataina. ");
INSERT INTO hubNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Tuma matsatai pachiachmau senchi ureak, cárcelan senchi pea, imanitai waitika ashi urantrauwaiti. Tura shuar achika cadenajai jigkakmausha tsurinar kaketuruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Imanikmatai achikmaun kuitamin kanar tepausha shintak iistajkama, waitika ashi uranar aun wainak, shuar achirmau ainaka shiakiapi tusa, kuchiijai maamataj tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Tumakai Pablo senchi untsuak: “Maamawaipa, ika ashi metek matsatji”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Tusa takai ji ekeemakrum itartitarma tinaiti, takai ji ekeemaka itarim juki sapijmak kurakmaikia tsekegki wayaa, Pablo Silasjai wajainan tikishmatrauwaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Tura aa jiiki iniak: “Apu ainata, ¿wisha uwemramij tusancha urukmainaitja?” tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Nu tusa iniam nita aimainak: “Apu Jesúsapita nekas uwemtikartinka titá. Nu tumakum ameka ashi amina pataimisha nunak enentaimtuinakaigka metek uwemrattame. ");
INSERT INTO hubNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Nuna tusa apu Jesúsa chichamencha ashi ni pataijai ujakuiti. ");
INSERT INTO hubNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Turam ajampek aig, achikmaun kuitamnusha Pablon Silasjai asutiaku apujramu numpa waigkun nijatkauwaiti. Turam nui nitasha ashi nuna pataijai imainiaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Nu turamu asar nita jeen jukiar yurumkan ajamsaruiti. Nu shuarka ashi ni pataijai Yuusapita nekas uwemtikartumainka tusa tuina asar, shir aneasaru ainawai. ");
INSERT INTO hubNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Káshikmas apu chichaman epegkin aina achikratin ainan akattrar, yamaika achinkarma nunaka jiikti tusa achikmaun kuitamnun akuptukaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Turam achikmaun kuitamnusha Pablon chicharuk: ‘Yamaika apu chichaman epegkin aina jiikti tusar chichaman akupturkayi’. Turutin asarmatai: Atumsha shir aneasrum jiinkirum wetaarma”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Nu tusa tama Pablo chichaak: “Ika Romanmaya shuar ainarinig chichaman shir nekartamtsuk asuttamrar cárcelnum egketmawarmaji. Turutma ainayatcha, ¿urukamtai yamaisha uurmaksha chikishcha waitmainatsaig jiirmaki akuptamkattsasha wakerutmainaji? isha junisrikka wechattaji. Nekas nita tawar inka jiirmakiartatji”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Nuna tusa timatai, achikratin aina apu chichaman epegkin ainan jeariar, timayi tusar ujaina. Turuinam Romanmaya shuaraitjai tusa timaurin antukar senchi ashamkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Tumainayat weri jeariar, Pablon Silasjai igkuawar chichainak: “Wait aneasrum tsagkurkarturtarma, tusa jukiar akupenak: Yamaika ju yaaktanam pujutsuk wetaarma”, tusa jiiki akupkaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Turamu asar jiinkiar Lidia pujamunam wear, nui jeawar shuar Jesúsai surumankau ainan aujsar, wakemamtikar ikuinak shiakaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Tuma yaakat Anfípolisan tura Apoloniajai nagkaikiar, Tesalónicanam judío iruuntai jeanam jeawaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Tumawar Pabloka nui tres domingo pujus, sábado tsawan jeakaigka, tuke tumau asa judío iruuntai jeanam wayaa, Yuusa chichame aarmaun pachis nitan ujak: ");
INSERT INTO hubNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Yaunchuk Yuusa chichamen etserin aina: “Cristoka waitkasa maam ataksha nantaktinaiti tusa aarmau awai. Nuka Jesúsan pachisan atumin ujajrum nuketi nekas Cristoka”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Nuna takai ishichik judío aina Jesúsai surumankar, nitasha Pablo Silasjai iruuntraru. Tura griego shuar ainasha Yuusa emematin asar, Jesúsain nukap surumankaruiti. Tumainai nu yaaktanmaya nuwa eme anentsa iitai ainasha Jesúsain nukap surumankaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Nuna tumainai judío aina Jesúsa chichamen anturtan nakitaina kajenak, shuar nekas pegkerchau, náki aantar yujau ainan ipawar nitajai iruunar, shuaran itit amajainak, yaaktanmaya ainanka ashi akajkaruiti. Imatikawar Jasónkan jeen Pablo Silasjai pujatsuash, pujakaigka japiki jukir shuar iruuntramunam ejémi tusar eakaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Turasha Pablonka Silasjai uwetrar, Jasónnak chikich yatsut Jesúsai surumankau ainajai irumar jukiar, apu iruuntainam ejéniaruiti. Turawar chichainak: “Ju shuar ainaka ashi nugkanam wekasar, itit amajkartu wekaina nu jui incha tarutramawarmatai, ");
INSERT INTO hubNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Jasón nina jeen awayaa apujsayi. Ju aina juka chikich apu Jesús naartin awai tuina asar, Romanmaya apunka shuarmainawai”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Nu tamaun shuar ainaka ashi apu ainajai antukar senchi pampaina. ");
INSERT INTO hubNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Imaninakai Jasón chikich yatsuk Jesúsai surumankau ainajai chichaak: Jasta, yaja wetaarma tusar akupkatji, tusa apu ainan kuitan suinak: “Pablo Silasjai jiinkiarmatai, awagturkitarma”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Turamu asar káshi aig, Pablonka Silasjai Bereanam wári akupkaruiti. Nuisha jeaamuik judío iruuntairin wearuiti. ");
INSERT INTO hubNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Nuiya shuarka Tesalónicanmaya shuar ainan nagkasau pegker enentaimin asar, chichaman etserkaisha wakerusar anturainak, nita chichaman etseraina nunasha nekas juiyanash tuina tusar nekaawartasa, Yuusa chichamen etserin aina yaunchuk aarmauwa nunasha kashi kashinig aujaina. ");
INSERT INTO hubNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Imanina asar judío ainaka Jesúsan umirtan nagkamawaruiti. Tumainakai griego shuar ainasha nuwa aishmagjai metek enentaimtutai ainajai Jesúsa umirtan nagkamawaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Turasha Tesalónicanmaya shuar aina Pablo Bereanam Yuusa chichamen chicharkartawai tamaun antukar ishiintukar, nuiya shuarnaka shir pujuschamnau amajaina. ");
INSERT INTO hubNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Turuinakai Jesúsai surumankau aina Pablon: Ameka nayants anuasam wetá tusar akupkaruiti. Turuinakai Silas Timoteojai Bereanam juakaruiti. ");
INSERT INTO hubNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Pablon uyuunainaka Atenasnum ejé ikukiaruiti. Nu waketainakai Pablo Silasan Timoteojai chichaman akuptak: “Wári jui taawarti, jui nitajai igkuniaktajai”, tusa tinaiti. ");
INSERT INTO hubNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Nuna tusa Atenasnum akupak nakak pujus, nuiya shuar ainaka Yuusa enentaimtutsuk shuar nitak aantra yuusrimamu aina nuna ima senchi ememataina asarmatai, senchi wake mesemar pujau. ");
INSERT INTO hubNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Nui judío iruuntairin iruuntrar, judío nui matsatainajai tura chikich shuar nekas Yuusa umirainajaisha tuke chichaa. Kashi kashinig yaakat ajapeen aunam wekaas, nui shuar yujan wainkusha imanik nitajaisha chichaa. ");
INSERT INTO hubNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Tumai chikich shuar Epicúreos jintinkartuamun aujin aina, chikich Estoicos jintinkartuamun aujin ainajai kaunkar nitak chichatan nagkamawar: “¿Au shuar imanik chichaa ausha warina pachis chichaakua imatua?” tusa tuina. Tuinakai chikich chichainak: “Auka shuar yuusrimamu aina nuna pachis etserin aina numamtinaiti”, tusa tuina. “Nunaka Pablo Jesús mantamna nantakmaurijai pachis etseru asamtai”, tuina. ");
INSERT INTO hubNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Nuna tuina asar Pablon jukiar, Areópago tutainam jea chicharnaikartasa tuke iruunin asarmatai, ejéniar ininak: “¿Ame yamaram jintinkartam nu incha nekamtikartumaitsumek? ");
INSERT INTO hubNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Ame jintinkartam nuka ii antukchamu jintinkartame. Tuma asaakmin nunasha warina takug ta tusar isha nekaattsa wakeruinaji”, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Ashi shuar Atenasnumia ainaka, chikich shuar jeashtaya kaunkau nui matsatujai, junika yamaram chicham etsermaun antuinakka, nuna shir nekaawar chikichan ujakartasa wakerin ainawai, tusa tuina. ");
INSERT INTO hubNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Nuna tuinakai Pablo Areópagonam ajapeen wajas chichaak: Atenasnumia uun ainata, atumka yuusrimamu ainasha nekas pujuinawapi tusarum enentaimtin ainarme. ");
INSERT INTO hubNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Atum Yuus emematku iruuntairmin iiyakun wekaasan tagku aina maa patasa epetainam: “Yuus wainchatai” tusa tu aara anujkamun wainkamjai