﻿USE sofia;
DROP TABLE IF EXISTS sofia.hrw_vpl;
CREATE TABLE hrw_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES hrw_vpl WRITE;
INSERT INTO hrw_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","I gii e tet lo tanga tumtumlow e Yesus Kristus. Yesus e ta tibungkak ke Dewit, ma Dewit e ta tibungkak ke Abra-am. ");
INSERT INTO hrw_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abra-am e ta tamow e Aisak, Aisak e ta tamow e Jekop ma Jekop e ta tamow e Juda tura tanga tualik. ");
INSERT INTO hrw_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda e ta tamow e Peres ma Sera, tinru gii Tamar. Peres e ta tamow e Esron, Esron e ta tamow e Ram. ");
INSERT INTO hrw_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram e ta tamow e Aminadap, Aminadap e ta tamow e Nason, Nason e ta tamow e Salmon, ");
INSERT INTO hrw_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon e ta tamow e Boas, tinow gii Ra-ap. Boas e ta tamow e Obet, tinow gii Rut, Obet e ta tamow e Jesi ");
INSERT INTO hrw_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Ma Jesi e ta tamow e King Dewit. Dewit e ta tamow e Solomon, famu tinow e ta wok ke Uria, ");
INSERT INTO hrw_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon e ta tamow e Reoboam, Reoboam e ta tamow e Abisa, Abisa e ta tamow e Asa. ");
INSERT INTO hrw_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa e ta tamow e Josefat, Josefat e ta tamow e Joram, Joram e ta tamow e Usia, ");
INSERT INTO hrw_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usia e ta tamow e Jotam, Jotam e ta tamow e A-as, A-as e ta tamow e Esekaiya. ");
INSERT INTO hrw_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Esekaiya e ta tamow e Manase, Manase e ta tamow e Amon, Amon e ta tamow e Josaiya. ");
INSERT INTO hrw_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Ma Josaiya e ta tamow e Jekonaiya tura tanga tualik lo biing fam Babilon ri tungen re fan Israel tura raw una la wina Babilon. ");
INSERT INTO hrw_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Wimi ine rerek una Babilon Jekonaiya e ta tamow e Seltiel, Seltiel e ta tamow e Serubabel. ");
INSERT INTO hrw_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serubabel e ta tamow e Abiut, Abiut e ta tamow e Eliakim, Eliakim e ta tamow e Asor. ");
INSERT INTO hrw_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asor e ta tamow e Sadok, Sadok e ta tamow e Akim, Akim e ta tamow e Eliut, ");
INSERT INTO hrw_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliut e ta tamow e Elisa, Elisa e ta tamow e Matan, Matan e ta tamow e Jekop. ");
INSERT INTO hrw_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Ma Jekop e ta tamow e Josef, antu e Maria. Maria gii ka fasus ine Yesus ri fotngi ini Kristus. ");
INSERT INTO hrw_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Tinglo biing ke Abra-am kala ulo biing ke Dewit e ta sangful ma e fet na inlen, ma e ta sangful ma e fet na inlen tinglo biing ke Dewit ka la muut lo biing rerek una Babilon. Ma sangful ma e fet na inlen tinglo rerek ka muut lo biing ke Kristus. ");
INSERT INTO hrw_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Sinseng lo fuut ke Yesus Kristus e ngo aregii: Tinow Maria e sam ta ulo fagati una tili e Josef, famu ma ru ku melmel tiim, i ka parfailmi ini e sau mel e bo-i singe Tangwa Riis. ");
INSERT INTO hrw_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Anwarow Josef antu e Maria e ta kaltu riis. Iya, ka tibi bur pete maiyai ine Maria na matre tongge. I e su mel e sangsang kia ini eu fin borong kosngi. ");
INSERT INTO hrw_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Safle wimi ine sangsang kia, anggelo ke Taufi e fespuek talo lo numbiil, ma ka peteng tifi, “Josef sikow e Dewit, o tibi soke una onu e Maria wilo keu male are kem wok, anwarow bala gii ka mel e ta singe Tangwa Riis. ");
INSERT INTO hrw_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Maria eu fasus ine ti boron tamat, ma o ku fotngi ini Yesus, anwarow i eu faliungere tongge kia kosnge fan tubiil keri.” ");
INSERT INTO hrw_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Fan mok gii e fespuek una fawetu e fan sa Taufi e sam sesngeni na ngusre fam profet. ");
INSERT INTO hrw_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Wok mapek gii eu mel e bala ma ku fasus ine ti boron tamat ma riu fotngi ini Emanuel.” (Pimpiku: Deo i gii tura kiar.) ");
INSERT INTO hrw_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Biing Josef e kuuf i e gow aregii anggelo ke Taufi ka peteng tifi. I e onu e Maria ka la ulo male kia are ke wok. ");
INSERT INTO hrw_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Safle e tifik bulsi ka la muut lo Maria e fasus ine sikow. Ma Josef ka fotngi ini Yesus. ");
INSERT INTO hrw_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Wimi ine Yesus e fuut una Betle-em ina Judia, lo biing Erot e ta king, fang kaltu parfat ting uweng ri puek una Jerusalem, ");
INSERT INTO hrw_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","ma ri ka gatom, “Iya e boroner wa ka fuut king kere fan Juda? Kemem sau pari e angkeltot kia ting weng ma kemem ka puek una sa nining lo.” ");
INSERT INTO hrw_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Biing King Erot e ong lo mok a, i e sangfuunfuun ma fan Jerusalem ming ri sangfuunfuun. ");
INSERT INTO hrw_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","I ka tau tiim ire tongge gii, fam pris lamlam ma fan titsa lo fafanau ma ka gatom ri use male Kristus eu fuut ilo. ");
INSERT INTO hrw_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ri ka koso, “Ina Betle-em ilo male ina Judia, are profet e sam seti: ");
INSERT INTO hrw_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Safle o Betle-em ilo nal Judia, o tibi ta imi sak ine fanenger fan male e mel e asow ina Judia. Le tinglo o, eu mel e ti kaltu bakir eu fespuek ku ta efefe kere tongge kiang, Israel.’” ");
INSERT INTO hrw_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Kala Erot ka tuleni e sunwar borong tifre fang kaltu parfat a. I e bur parfat lo sese biing tikin angkeltot a e puek. ");
INSERT INTO hrw_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","E tule ri wina Betle-em ma ka war, “Gam u la siksik kausi ine boroner a. Le gam ku la sikseni, gam u mil gam ku sa peteng tif yau, usi yau ming yau la nining lo.” ");
INSERT INTO hrw_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Wimi ini ri sam ong singe king, ri fes ri ka la ma ulo sal angkeltot ri sau pari ting weng e famu mil iri ka muut e la kiis sok ulo male boroner a ulo. ");
INSERT INTO hrw_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Biing ri pari e angkeltot a e la kiis sok, ri fefeal tikin. ");
INSERT INTO hrw_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ri ka puek ulo fel, ri ka pari e boroner tura tinow Maria, ri ka por ma nawen ma nining lo. Wimi ri ka ipki e fan tang keri ma ri ka tow e fam finafen a, gol, insens ma mira. ");
INSERT INTO hrw_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ulo numbiil Taufi e fanauri, ini riu tibi la mil use Erot. Riu usi e neng e sal una la mil ilo kaontri keri. ");
INSERT INTO hrw_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Biing fang kaltu parfat ri sam la, anggelo ke Taufi ka puek talo Josef lo numbiil ma ka war, “Matet, onu e boroner ma tinow gam ku fin wina Ijip. Gam u melmel wa ku muut yau peteng mil tifo, anwarow Erot e mu sik ine boroner una paketmet ini.” ");
INSERT INTO hrw_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Josef ka matet, ka onu e boroner ma tinow lo panambiing a ma ri ka la una Ijip. ");
INSERT INTO hrw_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","I ka melmel wa ka muut lo Erot e met. Mok gii e fawetu e sunwar Taufi e sau peteng ini tifre fam profet: “Tingna Ijip ya tau ine sikuang.” ");
INSERT INTO hrw_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Biing Erot e parfailmi, ini fang kaltu parfat ri sormo, i e balasak, ma i ka fauun una paketmet ine berat fan tamat, tingna Betle-em ma fan male fatat. Berberat nano e u e matamfaim ma ka pu. Anwarow lo biing a e sam ong lo singe fang kaltu parfat. ");
INSERT INTO hrw_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Iya, fan sa Taufi e sau peteng ini tife profet Jeremaiya, e sau fawet: ");
INSERT INTO hrw_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Angkiimkiim ri ongni una Rama, tineng ma sangkuuluung e bakir sak, Reitsel e teng use tanga siksikow ma ka guuluung sak, ini riu war kausi singi, anwarow e sam tam iri.” ");
INSERT INTO hrw_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Wimi ine Erot e sau met, anggelo ke Taufi ka puek lo numbiil talo Josef una Ijip ");
INSERT INTO hrw_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ma ka war, “Matet Josef, onu e boroner ma tinow, ma gam ku la mil ina Israel, anwarow seri a, ri ka bala paketmet ine boroner, ri sau famete.” ");
INSERT INTO hrw_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Tingwa i e matet ka onu e boroner ma tinow, ma ri ka la ulo male ina Israel. ");
INSERT INTO hrw_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Safle biing e ong lo Akelaus e subuk efe lo Judia na pilsi e tamow Erot, i e soke una la wa. Ulo numbiil anggelo ke Taufi e sau fanauri ini i eu la ilo distrik Galili. ");
INSERT INTO hrw_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ma i ka la melmel ulo taon ri fotngi ini Nasaret. Iya, ka fawetu e sunwar fam profet ri sau peteng: “Riu fotngi ini kaltu tingna Nasaret.” ");
INSERT INTO hrw_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ulo bala fam biing a, Jon kaltu na gugu tarawen e sa la ka sesesngeni lala e sunwar ulo bala male e tek ti kaltu ina distrik Judia. ");
INSERT INTO hrw_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ma ka war aregii, “Iksi balbalmi, anwarow kepmale tinglo balambat e sau fatat.” ");
INSERT INTO hrw_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jon e ta kaltu lewa profet Aisaiya ka gongon lo: “Ulo male e tek ti kaltu, angkiimkiim a neng e tautau aregii, ‘Fagati e sal ke Taufi, fariisu e fan sal kia.’” ");
INSERT INTO hrw_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Malu e Jon ri bilseni lo ololow e kamel, ma i e diidiit bingne ine aneueu ri bilseni lo pinumfow e man, tuan aiya gii, angko ma ani tingna mok. ");
INSERT INTO hrw_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Tongge tingna Jerusalem, ma fa Judia nano, tiim tura male kiruur tinglo dan Jodan, ri fespuek tiim usi. ");
INSERT INTO hrw_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ri fabeku e fan tubiil keri, ma Jon ka gu tarawen iri lo Dan Jodan. ");
INSERT INTO hrw_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Safle biing e pari e fam Farasi ma fan Sediusi, ri fespuek usi una kepe amfagu tarawen, i e war singri, “Gam na fan siksikwan sii! Se e uun gam una finngeni e biing sak Deo e bala tuleni? ");
INSERT INTO hrw_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Gam samusu gow e konona fan sinang una fanangsi ini gam sam sangikis. ");
INSERT INTO hrw_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ma gam ku mele sangfi ini gau fasi una war sing gam tibom ini, ‘Abra-am e ta tamrer.’ Ya peteng tif gam, tinglo fatfat gii, Deo e fasi una famtet re berberat ke Abra-am. ");
INSERT INTO hrw_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Palnget e sam ta ilo warow e fang kalut ma mara kalut a ri ka tibi firfira kausi, riu pokufuf ri una bas ilo bala iif. ");
INSERT INTO hrw_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Ya gu tarawen i gam ine dan una fanangsi ini gam sam iksi e balbalmi. Safle wimi i yau, e mu mel e ti kaltu e mu puek, rawas kia e kulfi e rawas kiang, su kia ya tibi ta konona kaltu e fasi una kepe. I eu gu tarawen i gam ine Tangwa Riis ma iif. ");
INSERT INTO hrw_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","I eu puek are kaltu e puse lo saol una kaketiim ine fam piinpiin lo fan wit, ma i ku sartiim ine fan wit ilo felun wit kia, safle fam piin eu bas ini lo iif e tibi metmet.” ");
INSERT INTO hrw_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Yesus ka la tingna Galili una Jodan, usi ini Jon eu gu tarawen ini. ");
INSERT INTO hrw_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Safle Jon e tofo una iksi e sinangu e Yesus ma ka war, “E fasi ini ou gu tarawen i yau, ma areni o ka su sa la usi yau?” ");
INSERT INTO hrw_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yesus e koso, “Taufu ku ngo aiya, e su fasi ini kiar u gow aregii una fawetu e mara mok Taufi e sau fagatiufu.” Ma Jon ka a-uu. ");
INSERT INTO hrw_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Wimi ine Yesus e kepe amfagu tarawen, i ka biik tinglo dan. Lo sumbiing a, balambat e ipiik ma Tangwa Riis ke Deo ka pu talo, are anman, ri fotgni ini ambal. ");
INSERT INTO hrw_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ma ulo balambat neng e angkiimkiim e tau aregii, “I gii, e Sikuang, ya bura tikin; balang e gasgas lo i.” ");
INSERT INTO hrw_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ma lo biing a, Tangwa Riis ka onu e Yesus ka la ulo male e tek ti kaltu ini Satan ku lamu. ");
INSERT INTO hrw_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","I e fel lo e fet e sangful na pam panambiing ma pan siat wimi ini i ka biis. ");
INSERT INTO hrw_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Kaltu na fafalam ka puek usi ka sa war, “Le o ku ta sikow e Deo, peteng tifre fam fatfat gii ku ikis ku ta beret.” ");
INSERT INTO hrw_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yesus ka koso singi, “Sunwar ke Deo e peteng aregii, ‘Kaltu e tibi liu lo tuan tibom, safle lo fan mara warwar e puek tinglo ngusu e Deo.’” ");
INSERT INTO hrw_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Kala Satan ka onu ka la ulo siti tarawen ina Jerusalem ka la fetiufu ulo su e ngo uiyat sekit lo Felun Nining Bakir, ");
INSERT INTO hrw_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ma ka war singi, “Le o ku ta ini o na Sikow e Deo, ofpu ting wagii, anwarow sunwar ke Deo e peteng aregii: ‘Deo eu tulere fan anggelo kia una ules o, ma ri ku sange o ine limlim ri, usi ini eu tek ti fat eu ti lo kekem.’” ");
INSERT INTO hrw_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesus ka koso singi, “Sunwar ke Deo e peteng ming aregii, ‘Ou tibi tofo e Taufi Deo kiam.’” ");
INSERT INTO hrw_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Kala Satan ka onu ka la ulo paklunmale e kiis iyat sak, ma ka fanangsi ine mara kepmale ma finaswen kia e nal. ");
INSERT INTO hrw_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ma ka war, “Mara kepmale ma finaswen yau tow tifo, le o ku por ma nawen ma nining lo yau.” ");
INSERT INTO hrw_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yesus ka war singi, “Tii fasap yau, Satan! Anwarow sunwar ke Deo e peteng aregii: ‘Nining lo Taufi Deo kiam, ma faim singi tibom.’” ");
INSERT INTO hrw_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Kala Satan ka la kosngi. Ma fan anggelo ri ka puek ri ka sa ulsi. ");
INSERT INTO hrw_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Biing Yesus e ong ini ri sam taufu e Jon ulo rerek, i ka la una Galili. ");
INSERT INTO hrw_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","I e matet tingna Nasaret, ka la melmel una Kapernaum fatatu e Salat Galili, ilo irin nal kere fan Sebulon ma Naptali. ");
INSERT INTO hrw_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Usi eu fawetu, e sa, profet Aisaiya e sau peteng ini: ");
INSERT INTO hrw_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Nal kere fan Sebulon ma Natali, e fatatu e salat Galili, ma nal ilo galu lo dan Jodan, ina Galili, fuunfuun lo re fan ses ri melmel ilo distrik a. ");
INSERT INTO hrw_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Tongge a, iri ka melmel bala anor, iri sau pare anten. Tongge ri melmel bala anor na minet, anten e sau puek sing ri.” ");
INSERT INTO hrw_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Tonfnge tinglo biing a, Yesus e sesngeni e sunwar, “Iksi e balbalmi, anwarow kepmale tinglo balambat e sau fatat.” ");
INSERT INTO hrw_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Lo biing Yesus e fesfes lala ulo pisow e salat Galili, i ka pari e latualik Saimon gii ri ka fotngi ini Pita, ma tualik Enru ru basbas ine ubiin ulo balan salat, le ru ta ung kaltu na tuntunii. ");
INSERT INTO hrw_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yesus ka war singru, “Kamun mi nami yau, ma ya ku fatiti kamu una tuuktuuk ire tongge.” ");
INSERT INTO hrw_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Saupesak, ru ka tafu e fan ubiin keru ma ru ka mi nami e Yesus. ");
INSERT INTO hrw_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ri ka la ting wa, ma i ka pari e uneng e latualik, Jeims sikow e Sebedi tura tualik Jon ru ulo bala mon tura tamru Sebedi ru terterngeni e fan ubiin keru, i ka tau iru. ");
INSERT INTO hrw_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Saupesak, ru ka la kosnge buut ma tamru, ma ru ka la nami. ");
INSERT INTO hrw_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","I ka fes fawet una Galili ka fabenge ulo bala e fan felun nining keri ma i ka sesngeni e konona sunwar lo kepmale ma ka faliungere tongge ri mel lo fan mara matmatan minse nano. ");
INSERT INTO hrw_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Sinseng lo Yesus e omsene male kiruur ina Siria, ma tongge ri ka uunpuek ire tongge nano ri mel lo fan matan minse, fa ri kepe singmat na ongker, fa fan tara ri sispi ri, ma fa ri mel lo anminse a, riu luut ri ku la banban saksak, ma fa, fang galgalu lo ri e met. Ma Yesus ka faliungeri. ");
INSERT INTO hrw_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Singmat na galung kaltu tingna Galili ma tingna Dekapolis, Jerusalem ma tingna Judia ma tinglo galu lo Jodan ri ka mi nami. ");
INSERT INTO hrw_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Biing Yesus e pare tongge fuunfuun, i ka kanek ulo paklunmale, ka la kiisuf uwa. Wimi fan disaipel kia ri ka la tiim una isa, ");
INSERT INTO hrw_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ma ka tofnge una fabenge singri ka war: ");
INSERT INTO hrw_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Warfakausi eu ta ilo seri a ri ka parfat ini ri sasngal lo tangwari, kepmale tinglo balambat e ta keri. ");
INSERT INTO hrw_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Warfakausi eu ta ilo seri a ri ka sangkuuluung, Deo eu gongteri. ");
INSERT INTO hrw_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Warfakausi eu ta ilo seri a, ri ka fapor ri, Deo eu tow e nal nano tifri. ");
INSERT INTO hrw_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Warfakausi eu ta ilo seri a, ri ka mel e fabur bakir sak una gow e fabur ke Deo. Deo eu fafonsi ri. ");
INSERT INTO hrw_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Warfakausi eu ta ilo seri a ri ka mel e fatengis use re fa, fatengis ke Deo eu kep ri. ");
INSERT INTO hrw_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Warfakausi eu ta ilo seri a, busbusari ka kalkaliis, le riu pare Deo. ");
INSERT INTO hrw_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Warfakausi eu ta ilo seri a, ri ka fafaim use balamaris, Deo eu foteng ri ini fan siksikow. ");
INSERT INTO hrw_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Warfakausi eu ta ilo seri a, ri ka kepe mafet, anwarow ri gow e sa Deo e bura ini riu gow. Kepmale ke Deo e ta keri. ");
INSERT INTO hrw_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Warfakausi eu ta ilo o na se a tongge ri ka fotpuris o, ma ri ka is o ma ri ka tumar o, anwarow lo yau. ");
INSERT INTO hrw_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Fefeal ma terterer, anwarow fimfiil kemi ilo balambat e bakir tikiin. Le lo tikii ansinang ri bero ire fam profet ri puek famu i gam. ");
INSERT INTO hrw_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Gam ta semek tinglo nal. Le semek kabuk rop e tiif lo are riu gow ku la semek mil? E am tibi kausi wilo ti mok, sakle ri basuu ini ma ri ku pii falek lo. ");
INSERT INTO hrw_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Gam ta anten tinglo nal. Taun ilo paklunmale e tibi fasi una keskum. ");
INSERT INTO hrw_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","E su ngo aregii tongge ri tibi fafakrefu e lam, ma ri ku towtowfu ilo pikliu e dis. E tam, riu towfu iyat ilo tafu ku tow e anten tifre tongge nano ilo bala fel. ");
INSERT INTO hrw_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Lo su tikii sal towfu e anten kiam ku karef famu ire tongge, usi riu pari e konona amfingwam ma ri ku katfarsi e Tamam ilo balambat. ");
INSERT INTO hrw_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Gam u tibi sangfi ini ya puek una peteufu e fam fafanau tam fan warwar kere fam profet, ya tibi puek una peteufri, e tam. Ya puek una fabonti. ");
INSERT INTO hrw_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ya peteng tikin tif gam, ku muut batsok ma nal eu tam iru, eu tek ti boron su sekit lo fafanau eu tam ini. Fan iririn susun siisiit ma fan iririn taftafum pen ri seti ilo fafanau, ri nano riu ngongo aiya ku muut fan mara warwar kia ilo bala fafanau eu fasef. ");
INSERT INTO hrw_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Se a ka tibi usi e ti su lo fam fafanau gii, ma ka partaseni ma ka fatiti re fa una gorot are i, riu kep balik ine asow ilo kepmale tinglo balambat, safle se a ka fes ilo ma ka fatiti re fa ine fam fafanau gii, riu kep bakir lo ilo bala kepmale tinglo balambat. ");
INSERT INTO hrw_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ya peteng tif gam, fabur tikin kiam una usi e Deo e samusu kulfi e fabur kere fan titsa lo fafanau ma fam Farasi una usi e Deo. Le ku tam, o tibi fasi una kaulek ilo kepmale tinglo balambat. ");
INSERT INTO hrw_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Gam sam ongni e sa ri sau peteng ini tifre tongge nangen, ‘Gam u tibi paketmet ine tikas. Ma se ka paketmet ine neng eu ti ilo anganggon.’ ");
INSERT INTO hrw_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Safle ya peteng aregii ini se a ka balasak ine tualik eu ti ilo anganggon. Ming se a ka porau saksak ine tualik, kaltu a eu ti nanmata e medistret. Ma neng a ka war ini, ‘O lomba,’ tubiil a kia, e fasi una tatfeni wilo bala iif. ");
INSERT INTO hrw_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Iya le o ku fafen ine finafen kiam ilo altar ma o ka la sangfi ini e mel e mafet falifu lo o ma tuamlik, ");
INSERT INTO hrw_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","taufsok lo keu finafen ai famu ine altar. La o ku la fafariis tura tuamlik ma o kamu mil o ku sa fafen ine keu finafen. ");
INSERT INTO hrw_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Fariisu saupe e fan mafet kiam tura kaltu na matamfais kiam a ka bala tauf o ilo anganggon, gow lo biing e ta kamu aiwa ilo sal are kam la ta o tife kaltu na fafaikse, ma kam la ta o tife polis ma ri kam tauf o ilo rerek. ");
INSERT INTO hrw_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ya peteng tikin tif gam, gam tibi fasi una suu ku muut gam u faropo e fimfiil ri tow tif gam. ");
INSERT INTO hrw_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Gam sam ongni ri peteng ini gam u tibi gow e ansinang na faet fafalek. ");
INSERT INTO hrw_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Sakle ya peteng tif gam ini, se a ka su mer usi e ti fefin, i e sam gow e ansinang na faet fafalek tura fefin a, ilo ambusbusow. ");
INSERT INTO hrw_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Le anmatam ilo galu mil ka tatfe o wilo tubiil, sipilufu o ku bas ini, e kausi ini o filiwi e ti su lo fom, usi riu tibi bas kiruur i o ilo bala iif. ");
INSERT INTO hrw_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Male galu mil kiam ka tatfe o wilo tubiil, teseufu o ku bas ini, e kausi ini ou filiwi e ti su lo fom usi riu tibi bas i o bala iif. ");
INSERT INTO hrw_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Ri sau peteng ini se a ka finngeni e ke wok e samusu tow e ti pampel na a-uu tifi. ");
INSERT INTO hrw_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Sakle ya peteng tif gam aregii, sese kaltu a ka finngeni e ke wok ma i ka tibi gow e ansinang na faet falek, kaltu a e ta anwarow e ansinang na faet fafalek a, le wok a ku tinaule miil. Ma se a ka tili e wok a, i tiim tura wok a ru gow e ansinang na faet fafalek. ");
INSERT INTO hrw_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Gam sam ongni ming ri sau peteng ini nangen, gam u tibi kere e warkale kemi, safle gam samusu fabonti e warkale kemi tife Taufi. ");
INSERT INTO hrw_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ma gii ya peteng tif gam, mele gam ka limlim sekit: ine balambat, le e ta sia king ke Deo. ");
INSERT INTO hrw_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ma nal, le e ta male ilo pikliu e rawas ma efefe ke Deo, ma Jerusalem, le e ta siti ke Deo, i e ta King Bakir. ");
INSERT INTO hrw_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Gam u tibi limlim ilo pakpaklumi le gam tibi fasi una gow e ti an sianolom ku murmur tam ku mikiit. ");
INSERT INTO hrw_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","E buk su ngo are lea, ‘yow’ eu ta ‘yow’ ma ‘e tam’ eu ta ‘e tam’; sese ti mok ming gam u peteng ini, e fespuek singge tangwaner saksak. ");
INSERT INTO hrw_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Gam sam ongni ri peteng ini ‘anmatam use anmatam’ ma ‘an ngisngissam use an ngisngissam.’ ");
INSERT INTO hrw_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Sakle gii ya peteng tif gam, mele gam ka kokos singe tikas a ka gow e ti tubiil lo gam. Le tikas ka pose o ilo ambanguam ilo galu miil on ikis ine galu ming tifi. ");
INSERT INTO hrw_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Male tikas ku tau i gam wilo fafariis una kepe malum on towfu ming ku kepe kolos tapak kiam. ");
INSERT INTO hrw_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Le tikas ku ting talo gam una fes lo tikii mael gam an la nami gam ku fes lo e u e mael. ");
INSERT INTO hrw_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Le tikas ku gatom gam use timok, tow tifi. Male tikas ku bura ini eu bi kepe ti mok sing gam ma kamu sa tow mil, mala balo ini. ");
INSERT INTO hrw_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Gam sam ongni ri peteng ini bura e fan taltalumi ma gam ku sak lo re fa gii ri ka is gam. ");
INSERT INTO hrw_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Sakle ya peteng tif gam, bura e tongge ri sak lo gam ma gam ku nining use re tongge ri is gam. ");
INSERT INTO hrw_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Usi eu ta gam na fan siksikkow e Taumi ilo balambat, i e gow e pisii una pal re tongge saksak ma re tongge riis, ma e tuleni e bat use re tongge riis ma tongge saksak. ");
INSERT INTO hrw_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Le gam ku bur re tongge a ri ka bur gam e ta sese fimfiil gam u kepe? Tongge na kepkep mani ming ri gorgorot aiya. ");
INSERT INTO hrw_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ma le gam ka su kausi lo re fan tualik mi tibom, sese mok a gam ka gow ini ku kulef re fa? Fan tematan ming ri gowgow e tikii mok. ");
INSERT INTO hrw_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Gam samusu riis fasef, le Taumi ilo balambat e riis fasef. ");
INSERT INTO hrw_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Ate sak ini ou tibi gow e sinang e riis kiam na matre tongge usi ini ri ku pari. Le o ku gorot aiya, eu tek ti fimfiil kiam singe Tamam ilo balambat. ");
INSERT INTO hrw_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Lo biing o tow e mok tifre tongge ri sasngal, ou tibi rerkeni, are tongge na kepkep ri na matam pangkii ri gowgow ilo bala am felun nining ma ilo an sal, ini tongge ri ku resresnge ri. Ya peteng tikin tif gam, ri sam kep kiruurngeni e fimfiil keri. ");
INSERT INTO hrw_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Sakle biing o ka tow e mok tifre tongge ri sasngal, mele towfu e galun limam kais ku parfat lo sa galun limam miil e gowgow. ");
INSERT INTO hrw_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Aregii eu ta mok borong ma Tamam se e alalmi e fan sa e ngo borong kamu tow e fimfiil kiam. ");
INSERT INTO hrw_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Biing o nining, mele gorot are tongge na kepkep ri na matam pangkii. Ri bura una ti ma nining ilo bala fam felun nining ma ilo fan male na tiimtiim singre tongge, usi ini tongge nano ri ku par ri. Ya peteng tikin tif gam, ri sam kep kiruurngeni e fimfiil keri. ");
INSERT INTO hrw_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ma le o ka bur nining, la ilo bala keu fel dukli e matangkon, ma o kamu nining singe Tamam se a ri ka tibi fasi una pari. Ma Tamam se e alalmi e fan sa e ngo borong kamu tow e fimfiil kiam. ");
INSERT INTO hrw_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Biing ou nining o tibi fasi una usi e fan warwar fofoes are fan tematan ri gowgow, iya ri ka sangfi ini deo keri eu ongen ri anwarow lo fan nining tapak keri. ");
INSERT INTO hrw_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ou tibi gorot are ri, anwarow Tamam e sau parfat famu lo fan sa ou gatmo usi. ");
INSERT INTO hrw_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“I gii e sal are o samusu nining: ‘Taumem ilo balambat, Tafu e asam ku ta tarawen. ");
INSERT INTO hrw_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Tafu e kepmale kiam ku puek, tafu e fabur kiam ku fuut lo nal, are ilo balambat. ");
INSERT INTO hrw_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Fen kemem geinggii ine inen amem. ");
INSERT INTO hrw_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Sangintafngi e fan tubiil kemem, are kemeu ming kemem sangintafngi e fan tubiil kere fa ri gow lo kemem. ");
INSERT INTO hrw_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Mele tule kemem tife falam, sakle ong kep kemem konsge fan mok e sak.’ ");
INSERT INTO hrw_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Anwarow le o ku sangintafngi e fan tubiil fa ri sam gow lo o, Tamam iyat ilo balambat eu kepufu ming e fan tubiil kiam. ");
INSERT INTO hrw_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ma le o ku tibi sangintafngi e fan tubiil kere fa, Tamam eu tibi kepufu e fan tubiil kiam. ");
INSERT INTO hrw_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Biing o fel mele gow e matam ku par na sangkuuluung, are tongge na kepkep ri na matam pangkii ri gowgow. Ri ikiksi e matmat ri ka parpar na sangkuuluung una fanangsi re tongge ini ri fel. Ya peteng tikin tif gam, ri sam kepe fimfiil kiruur keri. ");
INSERT INTO hrw_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Sakle biing o fel, wel lo paklum ma o ku gua e matam. ");
INSERT INTO hrw_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Usi tongge riu tibi ilmi ini o fel, sakle tife Tamam tibom se a ri ka tibi fasi pari. Ma Tamam se e alalmi e fan sa e ngo borong kamu tow e fimfiil kiam. ");
INSERT INTO hrw_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Mele angang ine mara mok kausi kiam gii lo nal, iya fam pespes ma fan ros ri ku bero ini, ma iya tongge na kinkinau ri ku paek usi ri ku kinow. ");
INSERT INTO hrw_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Safle ou angang ine kausi usi o, wilo balambat, iya fam pespes ma fan ros ri ku tibi fasi una bero ini ma tongge na kinkinau ri ku tibi fasi una paek usi ri ku kinow. ");
INSERT INTO hrw_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Anwarow le fan mok kausi kiam ri ku ta iya, ambusbusam ming eu ta wa. ");
INSERT INTO hrw_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Anmatang kaltu e ta lam tinglo fow kiruur. Le anmatam ku kausi fom kiruur eu fuun ine anten. ");
INSERT INTO hrw_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Le wan matam ka baf, fom kiruur anor eu afti. Ma le anten ailo ku ta anor, sese anor sekit a ka faf ilo o! ");
INSERT INTO hrw_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“E tek tikas ek fasi una ta kaltu na mus ke e u e kaltu bakir. Ou guuluung ine neng, ma o ku bura e neng. Natkeni e neng ma o ku tibi natkeni e neng. O tibi fasi una faim singe Deo ma singe mani. ");
INSERT INTO hrw_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Anwarow gii ya ka peteng tif gam, mele sangfuunfuun use ninliu kiam, use tuan una en, ma dan una in tam use kolos una los sing o. Ninliu e bakir iyat ine tuan, ma pinumfom e bakir iyat ine fang kolos kiam. ");
INSERT INTO hrw_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Gau par lo talaman ting iyat, ri tibi so e tam firan au, ma ri tibi siktiim ma tauf tiim ilo bala ti fel una en. Safle Taumi ilo balambat e fenfen ri. Ma gam, gau bakir iyat na mata e Deo ine fan talaman. ");
INSERT INTO hrw_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","E fasi ini tikas lo gam eu posmi balik e ninliu kia ine borom pansumbiing, le ku sangfuunfuun use mara mok tingga lo nal? ");
INSERT INTO hrw_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Anwarow lo sa gam ka sangfuunfuun use fan malumi? Gaman par kausi lo fam purpur a ri ka faf aina mok, are ri fespuek. Ri tibi faim fuunfuun, ma ri tibi soksok fang kael. ");
INSERT INTO hrw_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Safle ya peteng tif gam, nangen king Solomon e loslos lo fan finaswen kia, safle fan finaswen kere fan purpur e kulfi tikin e fan finaswen ke Solomon. ");
INSERT INTO hrw_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ma gii fang garas ri faf falek ina mok. Safle na biingbiing tongge riu tetes ma ri ku bas iri ilo iif. Ma fang garas fofoes aregii, bingne Deo e faswen ri, ma gii, gam na tongge gau mel lo boron titinge, gam samusu parfat tikin ini Deo e mu faswen gau ming. ");
INSERT INTO hrw_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Gam u tibi sangsang fuunfuun ma gam ku peteng ini, ‘Kiar u eni e sa, ma kiar u inmi e sese mok, ma kiar u los lo sa?’ ");
INSERT INTO hrw_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Fan tematan ri sangfuunfuun una sik ine fan mok gii. Safle Taumi ilo balambat i e sau parfat ini gam samusu kepe e mara mok. ");
INSERT INTO hrw_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Safle mok baba tikii gam samusu gow e ngo aregii, gam samusu sik famu ine finaswen tinglo bala kepmale ke Deo, ma gam ku usi kono sinangu riis ke Deo, usi i e mu tow e fan mok gii ming tif gam. ");
INSERT INTO hrw_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Gam u tibi sangsang use biing na biingbiing le na biingbiing eu efe lo i tibom. Tikii neng tikii neng e biing e mel e mafet kia tibom. ");
INSERT INTO hrw_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Gau mele ikseni e sinangu e neng e kaltu are Deo kam ikse gau ming. ");
INSERT INTO hrw_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ma lo tikii sal gii o ka ikse re fa ini, i e mu ikse o ming aiya. Lo sese fan sinang a gam ka gowgow lo re fa, Deo eu gow aiya ming lo gam. ");
INSERT INTO hrw_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“E tamu gii o ka pari e amboron mukmuk ilo anmata e tuamlik ma o ka tibi sangfi e sungkalut e ngongo ailo anmatam tibom? ");
INSERT INTO hrw_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Le o ku peteng tife tuamlik, ‘Tagii, ya ku kepufu e anmukmuk ailo anmatam,’ ma e tamu ailo anmatam tibom ka mel e sungkalut ailo bala? ");
INSERT INTO hrw_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","O na kaltu na matam pangkii, ou kepufu famu e sungkalut ailo anmatam tibom, usi ou par ten ma o kamu kepufu e anmukmuk a, tinglo anmata e tuamlik. ");
INSERT INTO hrw_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“O u tibi kepe e mok e tarawen gam ku tow tifre fam puul, are ri kam didiu mil ma ri kau farages iyo. Ma gam u tibi bas ine konona fan eu ami ku la tifre fam bo, are ri ka pii ofofo ine kekek ri.” ");
INSERT INTO hrw_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Yesus e war ming aregii, “Gam u gatom usi Deo eu tow e mok gam gatom usi, gam u sik ine mok ma gam ku pari, gam u tukeni e matangkon, ma Deo ku ipki tif gam. ");
INSERT INTO hrw_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Tongge nano ri gatmo e Deo, riu kepe e mok ri gatom usi; kaltu e sik ine mok, eu pari; ma kaltu e tukeni e matangkon Deo eu ipki tifi. ");
INSERT INTO hrw_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Se lo gam sikow eu gatmo use ti beret ma ku tow subung e ti fat tifi? ");
INSERT INTO hrw_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ma se lo gam sikow eu gatmo use ti fis ma ku tow e ti sii aiya? E tau ming. ");
INSERT INTO hrw_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Gam na tongge saksak. Sakle gau parfat sak una tow e konona fan mok tifre siksikwami. Ma sakle konona sinangu e Deo una tow e konona fan mok tifre tongge ri nining singi e kausi sak iyat ine sinsinangumi. ");
INSERT INTO hrw_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Ilo mara mok nano, sese mok a gam ka bura ini riu gow lo gam, gam samusu gow lo re fa. Ma i mung e mok gii e fasefu e fafanau ma warwar kere fam profet. ");
INSERT INTO hrw_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Gam samusu kau ilo matangkon firfirkut. Le matangkon una la use iif e palpaluk ma sal usi e paumiil sak. Ma fa fuunfuun ri kau ilo. ");
INSERT INTO hrw_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Safle matangkon una la ilo male na ninliu, e firfirkut, ma sal usi e tuntun sak. Ma e tibi fuun e kaltu ri sikseni.” ");
INSERT INTO hrw_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Yesus e war ming aregii, “Gam u ate kausi use fan profet gurgurum. Riu afaf ine sinang kere fan sipsip, ma ri ku puek talo gam. Safle lo balbalri tikin ri ta fan puul rokai. ");
INSERT INTO hrw_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Gam u iliim ri ilo sinsinangu ri areini? Tongge, ri fasi una lus firfiran waen tinglo amfinau saksak, tam, tongge ri fasi una lus firfiram fik tinglo amfinau moseng? ");
INSERT INTO hrw_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Konona au eu fira ine fan firfiran au kausi, safle, au saksak eu fira ine amfiran au saksak. ");
INSERT INTO hrw_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Konona au e tibi fasi una fira ine tiam firan au saksak. Ma au saksak e tibi fasi una fira ine ti konona tiam firan au. ");
INSERT INTO hrw_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Sakle fan tenau nano gii ri ka firfira ine firfiran au saksak, riu pokuf ri, ma ri ku bas iri ilo bala iif. ");
INSERT INTO hrw_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Are lea, gam u iliim ri ilo fingfingua ri. ");
INSERT INTO hrw_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Gam u tibi sang ini tongge nano gii ri ka warwar sing yau ini, ‘Taufi, Taufi’ riu kau ilo kepmale tinglo balambat. E tam. Safle seri mung a ri ka usi e fabur ke Tabuung ilo balambat. ");
INSERT INTO hrw_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Fa fuunfuun riu peteng tif yau lo biing a, ‘Taufi, Taufi, kemem sam gow e fan warwar ke Deo lo asam, ma kemem sam fesi e fan tara saksak lo asam, ma kemem sam gow a fan mok na tibou fuut lo asam. Areini, kemem mu kau ilo kepmale kia, be?’ ");
INSERT INTO hrw_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Wimi ya kamu peteng ten tifri, ‘Ya tibi parfat lo gam. Gaman tii kosing yau, gam na tongge na tumtubiil.’ ");
INSERT INTO hrw_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Tongge nano ri ongni e warwar kiang gii, ma ri ka tofo una usi, ri ngo are kaltu sinangumel, e gow e fel kia ilo poktow e fat kiis. ");
INSERT INTO hrw_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Biing bat eu luut ma dan ku suu ma singmat na kif ka puek, ka doieni. Safle fel a, eu tibi luut, anwarow e feti ulo poktow e fat kiis. ");
INSERT INTO hrw_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Sakle iri nano gii ri ka ongni e kek sunwar ma ri ka tibi usi, ri su ngo are kaltu e lomba, i e feti e ke fel ilo balang kiin. ");
INSERT INTO hrw_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Bat e luut ma dan ka suu, angkif ka puek ka doieni ma fel a ka luut ka la bereng fafalek.” ");
INSERT INTO hrw_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Biing Yesus e gon tikii ine fan mok gii, tongge fuunfuun uwa ri tiin la kuufsak lo fam fabenge kia, ");
INSERT INTO hrw_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","anwarow i e fabenge are kaltu e mel e rawas kia, ma mia e mel. I e tibi fabenge singri are fan titsa keri tinglo fafanau. ");
INSERT INTO hrw_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Biing Yesus e ding mil tinglo galumfow e paklunmale, tongge fuunfuun sak ri minami. ");
INSERT INTO hrw_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ma neng e kaltu e mel e anminse lepra ulo e fespuek ma ka la kiis pukungkek u famu ine Yesus, ma ka war, “Taufi, le o ka bura, o fasi una faliunge yau.” ");
INSERT INTO hrw_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesus e sangau ine limow ka pot lo, ma ka war, “Ya fabur! O samusu kalkaliis.” Ma saupesak, anminse lepra ka rop tinglo ma i ka liu. ");
INSERT INTO hrw_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ma Yesus ka war singi, “Ate kausi! Ou tibi peteng tife tikas ine mok e sau fuut lo o. Safle ou la, o ku la fanangsi o tibom tife pris ma o ku gow e finafen aregii Moses kabuk peteng, una fanangsi re tongge ini o sam kalkaliis.” ");
INSERT INTO hrw_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Biing Yesus e la mil una Kapernaum, kaltu bakir kere fan soldia tingna Rom e la puek talo, ka la gatmo ini eu ulsi, ");
INSERT INTO hrw_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","ka war, “Taufi, kaltu na mus kiang iwa ilo ngiin galumfow e met, ma e ongker bakir sak.” ");
INSERT INTO hrw_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Wimi Yesus ka peteng tifi, “Ya mu la faliungeni.” ");
INSERT INTO hrw_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Safle kaltu bakir kere fan soldia, ka peteng tifi aregii, “Taufi, e tibi ta ya na konona kaltu e fasi ini ou la kaulek ilo kek fel. Safle on su war ma kaltu na mus kiang ku liu. ");
INSERT INTO hrw_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Aregii yau ming, ya na kaltu ilo pikliu e neng e rawas, ma fan soldia iri na pikli yau. Le ya ku peteng tife tikas, ‘On la,’ i eu la. Ma ya ku war singe neng, ‘Kasa,’ ma i eu sala. Ma ya ku peteng singe kaltu na mus kiang, ‘Gow e mok gii,’ ma i eu gow.” ");
INSERT INTO hrw_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesus e ongni e war aiya, ma i ka kuufsak, ma ka war singre tongge ri ususi lala, “Ya peteng tikin tif gam, ya tifik tongeni e tikas gii na Israel e mel lo singmat na titinge aregii. ");
INSERT INTO hrw_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ya peteng tif gam, tongge fuunfuun ting weng ma ting i sif riu keptafu ri ilo en bakir tura Abra-am, Aisak ma Jekop ilo kepmale ilo balambat. ");
INSERT INTO hrw_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Safle tongge Deo e sam wel ri, fan Juda, una tow e kepmale kia tifri, ma ri tibom ri ka onguf, Deo eu bas suu iri wilo male e or, ma ilo male a, riu tengteng ma ri ku ngungut fat.” ");
INSERT INTO hrw_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Wimi Yesus kau peteng tife kaltu bakir a aregii, “Arik on la, ma fan mok eu fuut lo o aregii titinge kiam ka peteng.” Ma kaltu na mus kia, anminse e rop tinglo, lo anmatam pisii a sekit. ");
INSERT INTO hrw_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Biing Yesus e la kau ulo bala fel ke Saimon Pita, i e pari e yanow fefin e Saimon Pita. E ngongo ulo ngiin, e bokor. ");
INSERT INTO hrw_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yesus e puse lo limow, ma ambokor a ka rop tinglo, ma fefin a ka matet, ma ka tofnge una fagati e fan tuan aiya. ");
INSERT INTO hrw_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Lo efef a, ri ka uun puek ire tongge fuunfuun e mel e fan tara saksak ulo ri, ri ka sa la use Yesus, ma i ka tii ire fan tara saksak a ine sunwar, ma ka faliungere tongge nano tura fan minse. ");
INSERT INTO hrw_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ma lo sangsang gii, una fasefu e sunwar profet Aisaiya e sau peteng ini aregii: “I tibom e kepe fan mara minse kiar, ma ka tii iri.” ");
INSERT INTO hrw_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Biing Yesus e par re tongge fuunfuun ri fatie liflifti, i ka peteng tifre fan disaipel kia ini riu la kaupaket salat ri ku la ilo neng e galu. ");
INSERT INTO hrw_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Wimi titsa lo fafanau ka la fespuek talo Yesus ma ka war, “Titsa, sese mok ou la ilo, yau mi nami o ming wilo.” ");
INSERT INTO hrw_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ma Yesus ka peteng tifi aregii, “Fam puul rokai e mel e fam polo keri, ma fan man ting auiyat e mel e fam polpolo ri. Safle Sikow e Kaltu e tek ti mok una famanaungeni e paklu.” ");
INSERT INTO hrw_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ma neng lo re fan disaipel kia ka peteng tifi, “Taufi, ou bi a-uu lo yau, ya ku bi la ofo e tabuung.” ");
INSERT INTO hrw_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Safle Yesus e peteng tifi aregii, “Mi nami yau, tauf re fan minet ri ku ofo e minet keri tibom.” ");
INSERT INTO hrw_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Wimi Yesus ka kau ulo bala buut, ma fan disaipel kia ri ka mi nami. ");
INSERT INTO hrw_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Biing iri ulo balan salat, saupesak kif bakir ka tonge ri, ma panaf ka matet ka keker talo bala buut. Biing a Yesus e masmasun. ");
INSERT INTO hrw_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Fan disaipel ri ka fongni ma ri ka war, “Taufi ules kiar, kerer sau bala maut!” ");
INSERT INTO hrw_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ma Yesus ka koso singri, “Titinge kemi e balik sak, usi e tamu gam ka soke sak?” Ma Yesus ka matet ka porow e kif ma panaf ru ka rop, ma ka la siaro kausi sak. ");
INSERT INTO hrw_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Tongge ri kuufsak, ma ri ka fagatomnge iri tibom, “E ta sese kaltu legii? Kif ma panaf ru ka ong singi!” ");
INSERT INTO hrw_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Biing ri sam kaupakti e galun Salat Galili ulo galu nal kere fang Gerasa, e u e kaltu tangwaner saksak e sispi ru, ru la tinglo balang kenit, ru ka tongeni. Ru rokai tikin e tek tikas ek solsol paket ilo sal a. ");
INSERT INTO hrw_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ru ka tau rawas, “Sikow e Deo, o bala gow e sa lo kemem? O puek una bero i kemem famu ma ka tifik ta biing lo?” ");
INSERT INTO hrw_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","E mel e singmat na amfor na bo ri enenen utapak balik iri. ");
INSERT INTO hrw_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ma fan tangwaner saksak a ri ka guna e Yesus aregii, “Le o ku fesel kemem, tule kemem use amfor na bo lei.” ");
INSERT INTO hrw_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ma Yesus ka war singri, “Gaman la.” Ma ri ka suu tinglo ung kaltu a. Ri ka la sispe re fan bo, ma ri ka fafes pu ulo pimpa-i a ka la bala dan ri ka la famete. ");
INSERT INTO hrw_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Biing fan efefe lo fam bo ri pari e mok gii, ri filau ri ka la ulo taon ri ka la sesgeni e fan mara mok gii ma sa e fuut lo ung kaltu tangwaner saksak e sispi ru. ");
INSERT INTO hrw_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Tongge nano tinglo male a, ri la use Yesus. Biing ri ka la pari, ri ka war rawas singi ini, eu la kosnge male keri. ");
INSERT INTO hrw_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesus e kau ulo mon, ka kaupaket salat, ma ka la mil ulo ke taon tibom. ");
INSERT INTO hrw_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Fa lo re tongge ri kepe kaltu dol ri ka la tow tife Yesus, e ngongo lala ulo ngiin. Biing Yesus e pari ini titinge keri e raw tikin, kam war singe kaltu a aregii, “Sikuang, balamas, ya sam kepufu e fan tubiil kiam.” ");
INSERT INTO hrw_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Lo mok gii fan titsa lo fafanau ri fawar falifu iri tibom aregii, “Kaltu gii e fotpursi e Deo.” ");
INSERT INTO hrw_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesus e sau parfat lo sinangu ri, iya kam war, “Anwarow lo sa gii gam ka mel e sangsang saksak ilo balbalmi? ");
INSERT INTO hrw_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Sese sunwar e paumiil una war ini? ‘Ya sam kepufu e fan tubiil kiam,’ tam, ‘Matet o ku fes’? ");
INSERT INTO hrw_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Sakle ya bura ini gam samusu parfat ini Sikow e Kaltu e mel e mia gii lo nal una kepufu e fan tubiil.” Yesus ka war singi aregii, “Matet, kepe kem ngiin ma o ku la mil ilo keu fel.” ");
INSERT INTO hrw_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ma kaltu a ka matet, ka la mil ulo ke fel. ");
INSERT INTO hrw_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Biing tongge ri pari e mok gii ri kuufsak tura soke, ri ka resngeni e Deo, le i e sam tow e singmat na rawas tifre tongge. ");
INSERT INTO hrw_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Lo biing Yesus e fesfes lala tingwa, i ka pari e kaltu ri fotgni ini Metiu e kiiskiis ulo bala felun mani. Ma Yesus ka war singi aregii, “On minami yau.” Ma ka matet ka minami e Yesus. ");
INSERT INTO hrw_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Lo biing Yesus e enenen ulo bala fel ke Metiu, tongge fuunfuun na kepkep mani, ma tongge na tumtubiil ri kiis ri ka en tiim tura Yesus ma fan disaipel kia. ");
INSERT INTO hrw_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Biing fam Farasi ri pari e mok gii, ri ka sa gatom re fan disaipel ke Yesus, “Usi e tamu titsa kemi ka en tiim tura tongge na kepkep mani ma tongge na tumtubiil?” ");
INSERT INTO hrw_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesus ka ongni e sunwar keri ka war singre tongge parfat a aregii, “Tongge ri tibi mase, ri tibi la use dokta, safle tongge ri mase, ri la use dokta. ");
INSERT INTO hrw_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Gaman la gam ku la lalaf use pimpiku: ‘Ya bura ini tongge riu fatengis faliu iri. Sakle ya tibi bura e fan finafen fofoes.’ Le ya tibi sa la una tau ire tongge riis, e tam. Ya sa la una tau ire tongge na tumtubiil.” ");
INSERT INTO hrw_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Wimi fan disaipel ke Jon ri ka puek talo Yesus, ma ri ka gatmo, “Usi e tamu kemem tura fan Farasi kemem ka fel ma fan disaipel kiam ri ka tibi fel?” ");
INSERT INTO hrw_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ma Yesus ka koso singri aregii, “Gam sang ini fam fenfenngow e kaltu e bala tinaule riu sangkuuluung, ma i ka melmel aiwa tura ri? Ma le biing e mu puek una onu e kaltu e bala tinaule a ku la kosing ri, lo i e biing a, ri kamu fel a. ");
INSERT INTO hrw_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“E tek ti kaltu eng kepkepe ti sung kael fuu una sok kaleni e amfur ilo kolos ting nangen. Le sung kael fuu eu tete ma ku rangsi mil e kolos ting nangen ma amfur a ku la sisi bakir. ");
INSERT INTO hrw_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Aregii ming e tek tikas ek ututfi e ti waen fuu talo bala ti ampinun meme ting nangen, le i ku gow aiya, waen a eu ese paki e ampinun meme a, ma i ru nano ru ku tiin sak. Tongge ri ututfi e waen fuu talo bala ampinun meme fuu, usi ini ru nano ruw tiin ngongo kausi.” ");
INSERT INTO hrw_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesus e gongon uwa singre fan disaipel ke Jon, ma neng e kaltu bakir ka fespuek ka la pukunkek ulo fow e ung kekow ma ka war, “Kek borom fefin e am su met gii sekit, kasa, o ku la tow e limam ilo usi eu liu mil.” ");
INSERT INTO hrw_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yesus ka matet ka la nami ma fan disaipel kia ri ka mi nami. ");
INSERT INTO hrw_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Kala, neng e fefin uwa, ambuunbuunsuu e fuut lo, lo tikii sangful ma e u na matamfaim, e fes tingnami e Yesus ma ka pot lo anisow e kolos tapak kia. ");
INSERT INTO hrw_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Fefin a e war singi tibom, “Le ya kusu pot lo kolos tapak kia, yau liu.” ");
INSERT INTO hrw_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yesus e giliiu mil ka pari, ma ka war, “Balamas kek fefin. Titinge kiam e sau faliunge o.” Ma fefin a ka liu sekit, lo pansumbiing a. ");
INSERT INTO hrw_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Biing Yesus e la fespuek ulo bala fel ke kaltu bakir lo re fa Juda, e pari e tongge na kikif tulal, ma fa ri tengteng ma fafagalo. ");
INSERT INTO hrw_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","I ka war, “Gaman la u tapak, borom fefin gii e tibi met, e su masun.” Ma tongge a ri ka su ruur lo. ");
INSERT INTO hrw_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Biing ri sam uun suu ire tongge a, Yesus ka kau ulo bala fel, ka puse lo limow e borom fefin a ma i ka matet. ");
INSERT INTO hrw_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ma sinseng lo mok gii ka omseni e male kiruur. ");
INSERT INTO hrw_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Biing Yesus e la kosngi male a, e u e kaltu baf ru ka mi nami, ma ru ka tau aregii, “Sikow e Dewit, on tengis kama!” ");
INSERT INTO hrw_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Biing e la kau u lo bala fel, ung kaltu baf a ru la puek talo. Ma Yesus ka gatom ru, “Kamu titinge ini ya fasi una faliunge kamu?” Ma ru ka war aregii, “Yow Taufi, kama titinge.” ");
INSERT INTO hrw_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Wimi Yesus ka pot lo matmat ru ma ka war, “Ususi e titinge kamu, mok gii eu fuut.” ");
INSERT INTO hrw_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ma matmat ru ka par, ma Yesus ka fanau rawas sak iru ka war, “Kamuw tibi la peteng sekit tife tikas ine mok gii.” ");
INSERT INTO hrw_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Sakle ru la ru ka la rerkeni e sunwar lo tifre tongge tinglo male kiruur a. ");
INSERT INTO hrw_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Biing ung kaltu a ru la kosngi e Yesus, tongge ri ka kep puek subung ine kaltu tangwaner saksak e sispi ma e kut e ngusu, tife Yesus. ");
INSERT INTO hrw_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ma lo biing Yesus e tii ine tangwaner saksak a, kaltu a e war sekit. Ma tongge a ri kuufsak ri ka war, “Ting nangen e tifik tek ti mok ek fuut aregii gii na Israel.” ");
INSERT INTO hrw_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Sakle fan Farasi ri war aregii, “Yesus e su tii ine tangwaner saksak a lo rawas ke paklure fan tangwaner saksak.” ");
INSERT INTO hrw_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesus e fes ulo fan male ma fan taon, ma i e fabenge singre tongge ulo bala fan felun nining, ma ka sesngeni e konona sunwar na kepmale, ma ka faliungere tongge ri mel lo mara matmatan minse. ");
INSERT INTO hrw_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","I e pari e galung kaltu bakir sak, bala e la kuuluung sak usi ri, anwarow ri fesel falek iri ka la tek tikas una ules ri, are fan sipsip e tek ti efefe keri. ");
INSERT INTO hrw_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Wimi i ka war singre fan disaipel kia, “Fam palang e fuun una fitiil, sakle e tibi fuun e tongge una fitiil. ");
INSERT INTO hrw_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ilea gam u nining singe Tamow e palang, usi eu tulere tongge fuunfuun na faim una sa fitlii e ke palang.” ");
INSERT INTO hrw_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","I e tau ine tikii sangful ma e u na disaipel kia ka la usi, ma ka tow e rawas tifri una feselufu e fan tangwaner saksak, ma una faliungere tongge, ri mel lo mara matmatan minse. ");
INSERT INTO hrw_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","I gii e asasri e tikii sangful ma e u na apostel kia, neng baba tikii gii Saimon (nenge asow ming gii Pita) ma tualik Enru, ma Jeims, sikow e Sebedi, tura tualik Jon. ");
INSERT INTO hrw_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filip, Batolomius, Tomas, ma Metiu kaltu na kekep mani, ma Jeims sikow e Alfius, ma Tadeus. ");
INSERT INTO hrw_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Ma Saimon kaltu tinglo galung kaltu ri foteng ri ini fan Silot, ma Judas Iskariot, i e kaltu una mu solamufu e Yesus. ");
INSERT INTO hrw_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesus e tule re tikii sangful ma e u na apostel a, ma ka peteng tifri ine fan mok gii, “Gam u tibi la use re fan Jentael ma gam u tibi la kaulek ilo fan taon kere fan Samaria. ");
INSERT INTO hrw_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Gam samusu la use re tongge tingna Israel, ri ngo are fan sipsip ri tal falek. ");
INSERT INTO hrw_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Gam u la sesngeni e sunwar gii, ‘Kepmale tinglo balambat e sau puek fatat.’ ");
INSERT INTO hrw_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Gam u la faliungere tongge ri mase, ma gam ku famtet re fa ri sau met. Ma gam ku fakalkaliisngere fa ri lepra, ma gam ku tii ine fan tangwaner saksak tinglo re tongge. Mok gam kepe gam kep fofoes ini, ma e tek ti fimfiil lo. Iya gam samusu tow fofoes tifre tongge, gam u tibi is fimfiil lo. ");
INSERT INTO hrw_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Gam u tibi kep ti mani are gol, silwa, tam kopa ilo bala fan eueu kemi. ");
INSERT INTO hrw_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ma gam u tibi kep ti tang lo fines kemi, tam e u e kolos, tam su, tam ti tungkan, e tam. Anwarow kaltu a ka fafaim, riu moro ine fan tuan ma fanenger fan mok ming. ");
INSERT INTO hrw_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Ma le gam ku kau ilo ti taon, tam ilo ti male, gam u par kausi ine ti kaltu e sinangumel ma ka sangsang una are gam tinglo male a, usi gam u la melmel tura ku muut lo biing gam u la kosngi e male a. ");
INSERT INTO hrw_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Biing gam u kau ilo fel a gam samusu are ri tura siaro. ");
INSERT INTO hrw_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Le fumberat tinglo fel a ri ku a-uu lo gam, towfu e warfakausi na siaro ku mel ilo ri. Ma le ri ku tibi a-uu lo gam, gau fasi una kepfamila e warfakausi na siaro kemi. ");
INSERT INTO hrw_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Le ku tek tikas eu fabur una are gam, tam una ongni e sunwar kemi, paketufu e ambalbal tinglo kekekmi biing gam la kosingi e fel a tam taon a. ");
INSERT INTO hrw_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ya peteng tikin tif gam, lo biing na anganggon, mafet eu kep re tongge tinglo taon a, eu bakir iyat ine mafet lewa ka kep re tongge tinglo taon Sodom ma Gomora. ");
INSERT INTO hrw_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Ong, ya tule gam ku la are fan sipsip ina balre fam puul rokai. Ma gam samusu sang kausi famu use fan mok gau bala gow, are fan sii. Ma ming, gam samusu usi e sinangu e ambal, ini gam u tibi gow e ti sangsang una bero ine tikas. ");
INSERT INTO hrw_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Gam u atate lo re tongge, riu kot lo gam tifre fan kaonsiil ma ri ku napis gam ilo bala fan felun nining keri. ");
INSERT INTO hrw_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Anwarow le e ta gam kiang, riu tatfe gam tifre fan gapman, ma tifre fang king usi gam u fabeku e asang tifri, ma tifre fan Jentael. ");
INSERT INTO hrw_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ma biing riu bingfamti gam, gam u tibi sang kut use sa gam u sesngeni, tam are gam u sesngeni. Anwarow lo biing a Deo e mu tow e sunwar tif gam una war ini. ");
INSERT INTO hrw_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Anwarow e tibi ta gam tibom gam u sesngeni e sunwar, e tam, Tangwa Riis ke Taumi i eu sesngeni e sunwar ilo ngusngusmi. ");
INSERT INTO hrw_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Kaltu eu solamufu e tualik tibom ri ku paketmet ini. Ma tamtamre berberat eu gow e tikii sinang lo siksikwa ri, ma berat riu sak lo tintinri ma tamtamri ri ku fafen iri, ri ku paketmet iri. ");
INSERT INTO hrw_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Tongge nano riu is gam anwarow lo yau. Sakle seri gii ri ku ti raw tura titinge ku muut lo biing muut, Deo eu faliungeri. ");
INSERT INTO hrw_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ma le ri ku bero i gam, e kausi ini gam u fin tinglo male a, gam ku la ilo tikas ti male. Ya peteng tikin tif gam, gam u tifik ropo e faim ilo fan taon nano tingna Israel, ma Sikow e Kaltu ku mil. ");
INSERT INTO hrw_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Boroner na fabenge e tibi kulfi e titsa kia. Ma kaltu na mus eu tibi kulfi e kaltu bakir kia. ");
INSERT INTO hrw_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","E fasi ini boroner na fabenge eu ngo are titsa kia, ma kaltu na mus eu ngo are kaltu bakir kia. Le ri ka tasa e tamow e fel ini Belsebul, kiar sau parfat ini riu tas saksak sekit ire tongge kia! ");
INSERT INTO hrw_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Gam u tibi soke re tongge ri bur bero saksak i gam. Mara mok borong, e mu fespuek na malal. Ma fan warwar e keskum, tongge riu parfat lo. ");
INSERT INTO hrw_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Sese mok ya peteng tif gam ini lo anor, peteng ini lo siat. Ma sa ya kemes gam ini ilo balbalumi, gam u taungeni tinglo poktow e fel ma gam ku sesngeni tifre tongge. ");
INSERT INTO hrw_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Gam u tibi soke re tongge a ri ku paketmet ine pinumfomi, sakle ri tibi fasi una paketmet ine tangtangwami, e tam. Gam u su sokeni e Deo, sakle i e fasi una bero ine tangwa ma pinumfom ilo iif e tibi metmet. ");
INSERT INTO hrw_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Gau parfat ini tongge ri su felfeli e u e amboron man ine mani e balik sak. Ma Taumi e efefe kausi lo fan man a. E ti fasi ini ti fa lo ri eu luut i faf ilo nal, ma i ku ti parfat. ");
INSERT INTO hrw_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ma ming Deo e sam wese ololmi tinglo pakpaklumi. I e parfat kausi sak lo gam. ");
INSERT INTO hrw_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Aregii gam u tibi soke. Gam kulfi tikin e fan iririn man. ");
INSERT INTO hrw_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Le tikas ku peteng tifre fa ini i kiang, yau ming yau peteng tife Tabuung ilo balambat ini kaltu gii kiang. ");
INSERT INTO hrw_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Sakle tikas ku peteng tifre fa ini i e tibi ta i na disaipel kiang, yau ming yau peteng tife Tabuung ilo balambat ini kaltu gii e tibi ta i na disaipel kiang. ");
INSERT INTO hrw_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Gam u tibi sang ini ya fespuek una wari pakti e fan mara fapaket gii lo nal. Ya tibi puek una pete met ine fapaket, e tam. Ya sa la tura ringgot na fafapaket. ");
INSERT INTO hrw_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ya fespuek una pete fapot ire tongge ‘Kaltu eu sak lo tamow, ma boron fefin ku sak lo tinow, ma fefin e tinawle eu sak lo yanow. ");
INSERT INTO hrw_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Fam fufumberat lo kaltu a tibom riu sak lo.’ ");
INSERT INTO hrw_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Kaltu e bura sak e tamow tam tinow iyat i yau, i e tibi fasi una tiim tura yau. ");
INSERT INTO hrw_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ma kaltu e tibi kepe aupaket kia ma ku usi yau i e tibi fasi una tiim tura yau. ");
INSERT INTO hrw_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Le tikas ku bingfamti e ninliu kia tibom, ninliu kia eu tam ini. Sakle se a ri ku paketmet ini anwarow i e usi yau, i eu kepe ninliu kia. ");
INSERT INTO hrw_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Kaltu e a-uu lo gam, i e a-uu lo yau. Ma kaltu e a-uu lo yau, i e a-uu lo Deo se e tule yau. ");
INSERT INTO hrw_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Kaltu e a-uu lo profet anwarow i na profet i e mu kepe fimfiil ke profet. Ma kaltu e a-uu lo kaltu e ta konona kaltu, anwarow le e ta konona kaltu i e mu kepe fimfiil ke konona kaltu. ");
INSERT INTO hrw_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Kaltu e tow e kap na dan mair tife tikii tikas lo iririm berat gii anwarow le i e ta disaipel kiang, ya peteng tikin tif gam, i eu tibi feliwi sekit e ke fimfiil.” ");
INSERT INTO hrw_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Wimi ine Yesus e fabenge singre tikii sangful ma e u na disaipel kia, i ka la tingwa ka la ulo fanenger fan taon ulo male a, ka la fabenge singre tongge ma ka sesngeni e sunwar ke Deo tifri. ");
INSERT INTO hrw_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Jon e melmel ulo felun rerek ma biing e ong lo fan mara mok Kristus e gow, i ka tuleni e fan disaipel kia ri ka la use Yesus, ");
INSERT INTO hrw_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","una la gatmo aregii, “E sam ta o na kaltu gii Deo ka peteng ini i eu tule o, tam kemem u nene-i e tikas kuriik?” ");
INSERT INTO hrw_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ma Yesus ka koso e gatgatom keri aregii, “Gam la peteng tife Jon ine fan mara mok kemi ongni ma kemi pari: ");
INSERT INTO hrw_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Fam baf ri par mil, tongge kekekri e sak ri fes mil, fofore tongge e mel e anminse lepra ulo e puek kausi mil, ma fam balbaluri kut ri ong mil. Tongge ri sau met ri matet mil, ma fan sasngal ri ongni e konona sunwar. ");
INSERT INTO hrw_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ma tongge ri par yau ma titinge keri ka tibi luut, riu fefeal.” ");
INSERT INTO hrw_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Lo biing fan disaipel ke Jon ri fesfes una la, Yesus ka seseng tifre tongge ine Jon aregii, “Biing gam u la ilo male e tek ti kaltu, gam la una la pari e sa? Ya sang ini gam la una la pari e kaltu warwar kia e ngo are fum fiit kif e kifkifeni? Ma le ku tam, ");
INSERT INTO hrw_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","gam la una la pari e sa? Ti kaltu e los lo konona fang kolos? E tam, tongge ri los lo konona fan kolos ri, ri melmel ilo fel kere fang king. ");
INSERT INTO hrw_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Sakle sa gam la usi una la pari? Gam la una la pari e ti profet, be? Yow. Yau peteng tif gam, i e kulfi e fan mara profet nano. ");
INSERT INTO hrw_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Jon e ta kaltu lewa ri kabuk siisiit nafow aregii, ‘Yau tuleni e ti anunune kiang famu iyo. I eu la fagati e sal kiam.’ ");
INSERT INTO hrw_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ya peteng tikin tif gam, e tifik tek tikas tingna balre tongge gii ri ka fuut tinglo fefin, e sam suupuek ku bakir iyat ine Jon kaltu na gugu tarawen; Sakle se a ka ta imi sekit ire tongge nano ilo bala kepmale tinglo balambat, i e bakir iyat ine Jon. ");
INSERT INTO hrw_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Tinglo biing Jon e sesngeni e ke sunwar ku muut lo biing gii kepmale tinglo balambat eu tupngeni e mafet ma tongge na berbero ri ku tofo una esi. ");
INSERT INTO hrw_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Fan mara profet nano ma fafanau ke Moses ri sam warfot lo ka muut lo biing ke Jon. ");
INSERT INTO hrw_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Le o ku fasi una parfailmi, i e ta Elaija e mu puek. ");
INSERT INTO hrw_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Se a ka mel e ambalbalu, tafu ku ong. ");
INSERT INTO hrw_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Yau fatofo lo kulu tinglo biing gii lo sa? Ri ngo are berberat ri kiiskiis ilo male na tiim ma ri ka tautau singre fa: ");
INSERT INTO hrw_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Kemem kifii e antulal tif gam ma gam tibi guui; kemem seke e seksek na fatengis tif gam, ma gam tibi teng.’ ");
INSERT INTO hrw_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ma Jon e puek e tibi enen fuunfuun, ma ka tibi inin waen. Ma ri ka peteng ini e mel e tangwaner saksak ilo. ");
INSERT INTO hrw_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Sikow e Kaltu e puek ka ininin ma ka enenen, ma ri ka peteng ini, ‘Gau par, kaltu gii e en karef ma e biit waen tikin, ma i e ta fenngorer tongge una kepkep mani ma tongge na tumtubiil.’ Sakle atausimale eu puek ten ilo fan mus na limow.” ");
INSERT INTO hrw_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Wimi Yesus ka tofnge una war namatri e fan taon gii ka fuun lo fan mok na tibou fuut i e gow ulo, anwarow ri tibi sangikis. ");
INSERT INTO hrw_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","I ka war, “Kiskam sing gam na fang Korasin. Ma kiskam sing gam na fam Betsaida. Le tikas enggi sam la ulo taon Tair ma Saidon ek la gow e fan mok na tibou fuut aregii ya ka gow falifu i gam, fan Tair ma Saidon ring gi sam iksi e balbalri, ma rik sam los lo fang kolos na sangkuuluung ma rik sam wili e fofori ine fam pi-iif una fanangsi ini ri sangkuuluung tikin nafow e fan tubiil ri sam gow. ");
INSERT INTO hrw_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Gii ya ka peteng tif gam, lo biing na anganggon, mafet eu kep gam eu kulfi tikin e mafet e kep re fan Tair ma fan Saidon. ");
INSERT INTO hrw_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ma gam na fang Kapernaum, riu akte gam ri ku touf gam iyat ilo batsok? E tam sekit, kemiu la ifaf sekit ilo male kere tongge ri sau met. Le tikas enggi la ulo taon Sodom ma ek la gow e fan mok na tibou fuut aregii ya ka gow falifu i gam, gii Sodom enggi ta uwa. ");
INSERT INTO hrw_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Aregii ya ka peteng tif gam, lo biing na anganggon, mafet eu kep gam eu kulfi tikin e mafet eu kep re fan Sodom.” ");
INSERT INTO hrw_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Lo biing a Yesus ka war aregii, “Tabuung ya katfariis o, Taufi tinglo balambat ma nal. Ya aro sing o anwarow o finufu e fan mok gii ire tongge e mel e konona sangsang ma parfat keri. Ma o ka fanangsi tifre fa ri melmel are iririm berberat. ");
INSERT INTO hrw_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Yow Tabuung! O usi e fabur kiam tibom o ka gorot aiya. ");
INSERT INTO hrw_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Tabuung e sam towfu e mara mok nano ilo limang. Ma e tek ti kaltu ek parfat lo Sikow, sakle Tamow tibom e parfat. Ma e tek ti kaltu ek parfat lo Tamow, Sikow tibom tura tongge Sikow e bura una fanangsi ri ine Tamow. ");
INSERT INTO hrw_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Gam na tongge balbalmi e kut le gam kepe e fan mafet lamlam, gam nano gam kasa usi yau, ma ya ku famanaunge gam. ");
INSERT INTO hrw_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Gam parfailiim yau are Taufi kiam ma gam ku usi yau, ma gam ku kepe fan fabenge kiang, le anwarow ya ta ya na kaltu na balamas ma ya ka kepkepu i yau tibom. Ma gam ku kepe e konona manau. ");
INSERT INTO hrw_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Sa ya tungen gam ini, eu paumil sing gam una usi, ma mok ya tow tif gam una kepe e ti mafet.” ");
INSERT INTO hrw_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Lo sumbiing a Yesus e fes lala ulo bala fam palang na wit lo biing Sabat. Fan disaipel kia ri ka biis ma ri ka kutuul pakti lala e fanenger lo ri, ri ka eni. ");
INSERT INTO hrw_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Biing fam Farasi ri pari, ri ka war singi, “Par! Fan disaipel kiam ri gow e mok e pepe una gow lo biing Sabat.” ");
INSERT INTO hrw_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ma i ka koso singri, “Ka bi ngo areini gam sam wese e pansinseng lo mok Dewit e sam gow nangen lo biing a, i tiim tura tongge kia ri fitol? ");
INSERT INTO hrw_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","I ka kau ulo bala fel ke Deo, ma i tura re tongge kia ri ka la eni e beret e pepe. Fam pris tibom ri fasi una eni, safle e tibi fasi singe Dewit tura tongge kia. ");
INSERT INTO hrw_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ka bi ngo areini gam sam wese ilo fafanau kere fan Judia, ini lo fam biing na Sabat fam pris riu gow e fafen na ongker ilo bala Felun Nining Bakir. Ri kere e fatule lo biing na Sabat, sakle ri tibi gow e mok e sak. ");
INSERT INTO hrw_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ma gii, yau peteng tif gam ine mok gii, gii wa, e bakir iyat ine Felun Nining Bakir. ");
INSERT INTO hrw_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Sunwar ke Deo e war aregii, ‘Ya bura sak ini gam u fatengis faliu i gam. Ya tibi bura e fam finafen fofoes gam gowgow.’ Le keming gi sau parfat kausi lo sunwar gii, keming gi am tibi fasi una peteng ini tongge iri na tongge na tumtubiil, ma ri ka tibi tubiil lo ti mok. ");
INSERT INTO hrw_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ya fasi una war aregii, anwarow Sikow e Kaltu e ta Taufi lo biing Sabat.” ");
INSERT INTO hrw_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesus ka la tinglo male a ma ka la kau ulo bala felun nining keri. ");
INSERT INTO hrw_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ma neng e kaltu galun limow e sau met, i ming uwa. Ma anwarow le fam Farasi ri siksik ine ti sal una bingfamti e Yesus, ri ka gatmo aregii, “Areini, ilo fafanau, ri a-uu lo ini riu faliungeni e kaltu e mase lo biing na Sabat?” ");
INSERT INTO hrw_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ma Yesus ka war singri aregii, “Le tikas lo gam ka mel e ke sipsip ma ka luut ilo bala ampolo lo biing na Sabat, areini, ou tibi puse famti ma o ku sek famila mil tinglo bala ampolo? ");
INSERT INTO hrw_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Sakle kaltu e kulfi e sipsip. Iya ka kausi ini kiar u gow e konona ansinang lo biing na Sabat.” ");
INSERT INTO hrw_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Wimi ka war singe kaltu a, “Fariisu e limam.” Ma i ka fariisu e limow ma ka kausi mil are neng e galu. ");
INSERT INTO hrw_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Sakle fam Farasi ri suu tinglo bala fel, ri ka la gow e fan warwar una sik ine ti sal una paketmeteni e Yesus. ");
INSERT INTO hrw_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yesus e sau parfat lo mok fam Farasi ri fagati una gow lo. I ka matet ma ka la kosnge taon a, ma tongge fuunfuun ri ka minami. Ma i ka la faliungere tongge nano ri mase. ");
INSERT INTO hrw_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ma i ka war singri, ini riu tibi peteng suupuek ini sekit, ini i se. ");
INSERT INTO hrw_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Mok gii e fuut una fawetu e sunwar ke Deo, e tow ulo ngusu e profet Aisaiya, ka war aregii: ");
INSERT INTO hrw_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Igii e kaltu na mus kiang, ya sam wele. Kaltu a ya bura sak ma balang e gasgas sak lo. Ya towfu e tangwang ilo. Ma i e mu sesngeni e sunwar una fariisu e melmel tifre tongge gii lo nal. ");
INSERT INTO hrw_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","I eu tibi gon na balasak singre tongge ma i eu tibi barang singri. Ma i eu tibi gongon bakir lala ilo fan sal. ");
INSERT INTO hrw_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","An ngar e bala karot, sakle i eu tibi kerpakti sekit, ma eu tibi pete met ine lam e ti fuf kausi. Ma i e sau fafaim ku muut eu gow e fan sinang e riis ma fatengis, ma eu kulfi tikin. ");
INSERT INTO hrw_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Usi tongge tinglo mara male riu titinge ma ri ku nene i.” ");
INSERT INTO hrw_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Wimi tongge ri ka kep puek ine neng e kaltu, tangwaner saksak e sispi ka baf ma ka tibi gongon, tife Yesus. Ma Yesus ka faliungeni ma kaltu a ka fasi una par ma una gon mil. ");
INSERT INTO hrw_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ma tongge ri ka kuufsak ma ri ka war, “Kele ma kaltu gii e ta Sikow e Dewit, be?” ");
INSERT INTO hrw_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Sakle fam Farasi ri ong lo mok gii ma ri ka war, “Kaltu gii e fesi e fan tangwaner saksak lo rawas ke Belsebul, le Belsebul e ta paklure fan tangwaner saksak.” ");
INSERT INTO hrw_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yesus e sau parfat lo sangsang keri ma ka war singri, “Le tongge tinglo tikii kaontri ku tapot lo ri, ma ri ku fapaket, kaontri a e tibi fasi una ti raw. Ma fan siti tam fumberat tinglo bala tikii fel eu tapot ku u lo ri, ma ri ku fapaket, fumberat a riu tibi ti raw. ");
INSERT INTO hrw_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Le Satan ku fesi e Satan, eu tapot ku u lo i tibom. Areini, kepmale kia eu ti raw? ");
INSERT INTO hrw_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ma le ya ku feselufre fan tangwaner saksak lo rawas ke Belsebul, ma tongge kemi ri feseluf ri lo rawas ke se? Iya, tongge kemi, riu sesuupuek i gam ini gam tubiil. ");
INSERT INTO hrw_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ma le Tangwa Riis ke Deo ka ules yau una feselufre fan tangwaner saksak, e fanangsi ini kepmale ke Deo e sau puek talo gam. ");
INSERT INTO hrw_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Ma ming kaltu are eu gorot ku kau ilo bala fel ke ti kaltu rawas, ma ku la kepe fan mok kia? I eu bi rek famteni. Wimi i kamu fasi una seleni e fan mok kia a. ");
INSERT INTO hrw_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Le kaltu ka tibi ta ilo yau, i e is yau. Ma kaltu a ka tibi ules yau una keptiim ire tongge e ngo are kaltu e fesel falek ire tongge. ");
INSERT INTO hrw_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ma gii ya peteng tif gam, Deo eu sangintafngi e fan mara tubiil ma fam fotpuris tongge ri gow. Sakle kaltu eu fotpursi e Tangwa Riis, Deo eu tibi sangintafngi e tubiil a. ");
INSERT INTO hrw_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Kaltu e war saksak use Sikow e Kaltu, Deo eu sangintafngi e tubiil kia. Sakle kaltu e war saksak use Tangwa Riis, Deo eu tibi sangintafngi e tubiil kia, geinggii ma bingne. ");
INSERT INTO hrw_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Ou efe kausi lo au, ku fira ine konona amfingow, ma o ku efe saksak lo, eu fira ine amfiran au saksak. Aregii ilo au, riu parfailmi ilo firfirow ini e kausi tam e sak. ");
INSERT INTO hrw_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Gam ngo are fan sii saksak, ma areini gii gam ku war ine fan mok kausi ma ka ta gam na tongge saksak? Anwarow, le sese mok ka fuunuf ilo balang kaltu, eu la suupuek ilo ngusu. ");
INSERT INTO hrw_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Kaltu e fuunuf e bala ine konona fan mok, i eu sesuupuek ine konona fan mok. Ma se a ka fuunuf e bala ine fan mok e sak, i eu sesuupuek ine fan mok e sak. ");
INSERT INTO hrw_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Sakle ya peteng tif gam, lo biing Deo eu anganggon singre tongge, tikii neng tikii neng eu peteng tife Deo ini anwarow lo sa i ka war ine fan mara warwar falek. ");
INSERT INTO hrw_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Le anwarow lo fan warwar kiam tibom Deo e mu foteng o ini o na kaltu riis, tam o na kaltu saksak.” ");
INSERT INTO hrw_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Fa lo re fam Farasi ma fan titsa lo fafanau, ri ka peteng tife Yesus aregii, “Titsa, kemeu bura ini ow gow e ti mok na tibou fuut una fanangsi ini Deo e tule o, usi kemem u pari.” ");
INSERT INTO hrw_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ma i ka peteng tifri, “Tongge tinglo biing gii, ri na tongge saksak, ri ta ilo inlen na fapue. Bingne ri gatom use ti tintof, safle riu tibi par ti tintof. Riu su pari e tintof lo Jona. ");
INSERT INTO hrw_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jona e melmel lo e tuul e biing ma e tuul e panambiing ulo bala fis bakir, aregii Sikow e Kaltu eu melmel lo e tuul e biing ma e tuul e panambiing ilo bala nal. ");
INSERT INTO hrw_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Tongge tingna Niniwe ri ti ilo anganggon tura inlen ting geinggii ma ri ku sesuupuek ine fan sinang saksak kere inlen a, anwarow fan Niniwe ri sam sangikis le ri ongni e fam fabenge ke Jona. Ma gii, neng e bakir iyat ine Jona i gii wa ilo falifu lo gam. ");
INSERT INTO hrw_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Kwin tinglo galu i suu eu ti ilo anganggon tura inlen ting geinggii ma i ku sesuupuek ine fan sinang saksak kere inlen a, anwarow Kwin gii i e fespuek tapak sak una ongni e Solomon eu sesngeni e konona sangsang ma parfat kia. Ma gii, neng e bakir iyat ine Solomon i gii wa ilo falifu lo gam. ");
INSERT INTO hrw_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Le ti tara saksak ku suu tinglo ti kaltu, eu fes fawet ilo mara male mas ku siksik lala ine ti male una manau singi. Ma le ku tibi tongeni, ");
INSERT INTO hrw_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","tara saksak a eu sang aregii, ‘Yau la mil ilo fel ya la tinglo.’ Biing e la puek i e pari ini fel a i ka la kosngi e ngo are fel ri sam saif fakausi ma ri kabuk fagati fakausi e fan mara mok ilo bala, safle e tek tikas ek melmel ilo. ");
INSERT INTO hrw_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Tara saksak a e la ka la onu e neng e baba fis na tara saksak ming, ri sak sekit iyat ini tibom. Ma ri ka la melmel wa, ma melmel ke kaltu a, e la sak sekit iyat ine melmel kia ting famu. Tikii sangsang gii eu fespuek lo re inlen saksak tinglo biing gii.” ");
INSERT INTO hrw_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Lo biing Yesus e gongon uwa singre tongge, tinow ma tanga tualik ri sa fafatie una male. Ri bura ini riu gon singe Yesus. ");
INSERT INTO hrw_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ma neng lo re tongge a ka war aregii, “Ong, tinam tura tanga tuamlik gii ri ka fafatie gii na male, ri bura ini riu gongon singo.” ");
INSERT INTO hrw_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ma i ka koso singi, “Se e ta tiduung ma seri na tanga tuaklik?” ");
INSERT INTO hrw_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Yesus e sisiik usi re fan disaipel kia ma ka war, “Par, igii e tiduung ma tanga tuaklik. ");
INSERT INTO hrw_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Se e usi e fabur ke Tabuung ilo balambat, e ta tuaklik, e ta fefneklik ma e ta tiduung.” ");
INSERT INTO hrw_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ma lo biing a sekit Yesus e suu tinglo bala fel ma ka la kiis ulo pisow e salat. ");
INSERT INTO hrw_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Singmat na galung kaltu ri ka fang liflifti, iya, ka la kau ulo bala mon ka la kiis ulo, ma tongge ri ka fatie una kiin. ");
INSERT INTO hrw_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Kala i kau peteng tifri ine fan mok fuunfuun, lo warwar toftof ma ka war, “Nenge kaltu una fafaim palang e la sabel ine firfiran au kia. ");
INSERT INTO hrw_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Lo sumbiing e samsabel lala ine firfiran au a, fanenger ri rurung ulo sal, ma fan man ri ka sa en tike ri. ");
INSERT INTO hrw_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Fanenger ri rurung ulo male e fatfat nal e tibi bakir, e faf kanek saupe sak anwarow nal e tibi pinut. ");
INSERT INTO hrw_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Sakle biing pisii e fen kanek, fan au a ri met, anwarow e tek ti awawi ri. ");
INSERT INTO hrw_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Fanenger ri rurung ulo bala finfinau soksok. Ri ka faf kanek tura finfinau soksok a ma finfinau soksok a ka pismet iri. ");
INSERT INTO hrw_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Sakle fanenger fam firfiran au e luut ulo konona nal. Ri ka faf ma ri ka fira ine fingfingwa ri. Fanenger ri kepe atis, fanenger ri kepe e on e sangful ma fanenger ri kepe e tuul e sangful. ");
INSERT INTO hrw_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Se a ka mel e ambalbalu una ongong, tafu ku ong.” ");
INSERT INTO hrw_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Wimi fan disaipel ri ka la usi, ri ka la gatmo, “Yesus, kemem tibi ten ini anwarow lo sa gii, o ka gow e fan warwar toftof tifre tongge?” ");
INSERT INTO hrw_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ma Yesus ka koso e sunwar keri aregii, “Fam parfat tinglo fam pindik tinglo kepmale tinglo balambat, i e sam tow tif gam, sakle i e tibi fanangsi ri ini. ");
INSERT INTO hrw_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Le se a kabuk mel, Deo eu fen fuunfuun ini. Ma le se a ka tifik mel, sese mok i e mel lo, Deo eu kep famila singi. ");
INSERT INTO hrw_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ya war singri lo warwar toftof, anwarow tikin riu pari, safle riu tibi parfailmi, ma riu ongni, safle riu tibi ongen ti mok, tam riu tibi ten usi. ");
INSERT INTO hrw_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Sunwar ke profet Aisaiya e sau fespuek tikin ilo ri, ma sunwar a e peteng aregii: ‘Gam u ongen fuunfuun ine fan warwar, safle gam u tibi pauti e bala e ti sunwar. Gam u parpar, safle gam u tibi iliim ti mok. ");
INSERT INTO hrw_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Balbalre tongge gii e kut. Ri tibi bur ong ine balbaluri, ma ri ka fakuta e matmatri. Le enggi tam ring gi par ine matmatri, ma rik ong ine balbaluri ma ri ku iksi e balbalri, ri ku mil ma ya ku faliungeri.’ ");
INSERT INTO hrw_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Sakle warfakausi e sam ta ilo gam, anwarow matmatmi, ri pari e fan mok, ma balbalumi, ri ongni e fan warwar. ");
INSERT INTO hrw_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Safle ya peteng tikin tif gam, nangen fam profet ma tongge riis, ri bura sak una pari e fan mok gau pari, safle ri tibi pari. Ma fan mok gam ongni, ri tibi ongni. ");
INSERT INTO hrw_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Gii gam u ong a ma ya ku peteng ine bala e warwar toftof lo kaltu e sabel ine firfiran au. ");
INSERT INTO hrw_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Le tikas ka ongni e sunwar lo kepmale ma ka tibi kepfamti ma ka tibi ten usi, kaltu saksak eu suupuek ku esufu e sunwar tinglo bala. E buk su ngo are amfiran au ri so ilo sal. ");
INSERT INTO hrw_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Amfiran au e luut ulo male fatfat, e ngo are kaltu e ongni e sunwar ma ka kepe tura fefeal. ");
INSERT INTO hrw_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Sakle biing i tek ti an awiu, i e su melmel lo borom pansumbiing. Biing mafet tam fapaket e fespuek, anwarow lo sunwar e kepe, i eu luut saupesak. ");
INSERT INTO hrw_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Amfiran au e luut ulo falifu lo finfinau soksok, e su ngo are kaltu e ongni e sunwar, safle i e sangfuunfuun use ninliu tinglo nal ma fam fabur bakir una mel e tuba. Fan mok gii e faf ofofo e sunwar ke Deo ka tibi fira. ");
INSERT INTO hrw_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Safle firfiran au e luut ilo konona nal, e ngo are kaltu e ongni e sunwar, ka kep famti ma ka usi. I e fira fuunfuun e fasi una kepe tikii atis tam e on e sangful tam e tuul e sangful.” ");
INSERT INTO hrw_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesus e peteng tifri ine neng e warwar toftof aregii, “Kepmale tinglo balambat e ngo are kaltu e so e konona amfingwan au ilo ke palang. ");
INSERT INTO hrw_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Safle biing tongge nano ri famasunnge, kaltu na matamfais e fespuek ka sabel ine fang garas saksak ulo falifu lo konona fam fingfingwan au ma ka la. ");
INSERT INTO hrw_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Wimi palang na wit ka faf kanek ma ka bala fira. Kala ri ka su pari ming e fang garas saksak e faf kanek ming tura. ");
INSERT INTO hrw_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Tongge na mus ri ka la use tamow e palang, ma ri ka la peteng tifi aregii, ‘Kaltu bakir, kemem kelkeleini o so e konona fam fingfingwan au ilo bala keu palang, ma fang garas saksak lei ri la ting iya?’ ");
INSERT INTO hrw_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Ma i ka koso singri, ‘Kaltu na matamfais e gow e mok gii.’ “Ge na mus ri ka gatmo, ‘Ma areini, o bura ini kemem u la fitufufri?’ ");
INSERT INTO hrw_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“I e koso singri are gii, ‘E tam, anwarow le gam ku fitii e fang garas saksak, gam u fitii e fan wit ming tura ri. ");
INSERT INTO hrw_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Gam towfu ru ku faf tiim, ku la muut lo biing palang eu matuk. Lo i e biing a ya mu peteng tifre tongge na mus: Famu gam u kepe fang garas saksak, gam ku diit ri ku ta fam butbuta una taiif lo ri, wimi gam kamu keptiim ine fan wit ma gam ku la tauf ri ilo bala felun wit kiang.’” ");
INSERT INTO hrw_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","I e peteng tifri ine neng e sunwar toftof: “Kepmale tinglo balambat e ngo are amfiran mastet, kaltu e kepe ma ka so ilo bala ke palang. ");
INSERT INTO hrw_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Amfiran mastet e su balik sak, e tibi ngo are fanenger fam firfiran au. Sakle biing e faf, e kulfi e fan ume nano ilo bala palang, e fespuek ka ta au ma talaman ri puek ri ka sa gow e polpolo ri ilo katkatow.” ");
INSERT INTO hrw_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","I e peteng tifri ming ine neng e sunwar toftof aregii: “Kepmale tinglo balambat e ngo are is, fefin e kepe ma ka iksi ilo bala singmat na sospen falawa, ma wimi falawa kiruur a ka la ese.” ");
INSERT INTO hrw_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesus e gon ine fan mok gii tifre tongge lo warwar toftof. I e gongon bingne lo warwar toftof. ");
INSERT INTO hrw_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ma lo sangsang gii, e fawetu e neng e sunwar neng lo re fam profet e peteng ini nangen: “Yau sesngeni e fan warwar toftof. Ma yau sesuupuek ine fan mok e fifinuf tinglo biing Deo e fafuutngeni e nal ka la muut gii.” ");
INSERT INTO hrw_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ma ka la kosing re tongge ka la kau ulo bala fel. Fan disaipel kia ri ka la usi ma ri ka war, “Peteng ten tif kemem ine warwar toftof, lo fang garas saksak ilo bala palang.” ");
INSERT INTO hrw_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ma Yesus ka koso aregii, “Kaltu e so e konona amfingwan au, i e Sikow e Kaltu. ");
INSERT INTO hrw_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ma palang gii nal, ma konona amfingwan au gii siksikow e kepmale. Fang garas saksak gii siksikuang kaltu saksak. ");
INSERT INTO hrw_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ma kaltu na matamfais e sabel ine garas saksak gii, Satan. Matuk faim gii, biing muut, ma ge na fitfitiil gii, fan anggelo. ");
INSERT INTO hrw_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Fang garas saksak riu fituf ri, ma ri ku bas iri ilo bala iif. Ma igii e biing muut. ");
INSERT INTO hrw_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Sikow e Kaltu e mu tuleni e fan anggelo kia, ri ku tii ine fan mara mok e bero ine titinge kere tongge, ma tongge nano na tumtubiil tinglo kepmale kia. ");
INSERT INTO hrw_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Riu bas iri ilo bala iif bakir ri ku tengteng ma ri ku ngungutfat. ");
INSERT INTO hrw_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Wimi tongge riis ri ku sosok are pisii ilo kepmale ke Tamri. Se a ka mel e ambalbalu una ongong, tafu ku ong. ");
INSERT INTO hrw_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Kepmale tinglo balambat e ngo are bokiis na mani ri finufu ilo bala palang. Biing neng e kaltu e la pari, ma ka su la finufu ming. Ma ilo fefeal kia, i e la ka la umat ine mara mok i e mel lo ma ka la feli e palang a. ");
INSERT INTO hrw_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Ma ming, kepmale tinglo balambat e ngo are kaltu e siksik ine fang konona fan eu. ");
INSERT INTO hrw_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Biing e tongeni e fa fan eu lo singmat na fimfiil, i e su la ka la umat ine fan mara mok nano i e mel lo ma ka la feli.” ");
INSERT INTO hrw_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Ma Yesus ka war ming aregii, “Kepmale tinglo balambat e ngo are ubiin ri bas ini ulo balan salat ma ri ka sele fan mara matmatam fis. ");
INSERT INTO hrw_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Biing ubiin e sam la fuun, tongge na tuntunii ri ka tatfe masa ine ubiin. Wimi ri ka kiis ma ri kau fiteni e fam fis kausi talo bala dik, ma ri ka rarang ine fanenger saksak. ");
INSERT INTO hrw_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Biing muut eu ngo aregii, fan anggelo riu suupuek ma ri ku tii ire tongge saksak kosing re tongge ri riis, ");
INSERT INTO hrw_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ma ri ku bas ire tongge saksak ilo bala iif bakir. Ma ilo bala iif a, riu tengteng ma ri ku ngungutfat.” ");
INSERT INTO hrw_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Wimi Yesus ka gatom re fan disaipel kia, “Areini, gam sam ten lo fan mara mok gii?” Ma ri ka koso singi ma ri ka war, “Yow.” ");
INSERT INTO hrw_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Yesus ka war singri, “Ilea, fan mara titsa nano lo fafanau ri sau parfat lo anwarow e kepmale tinglo balambat, ri ngo are tamow e fel e la kaulek ulo bala sumfel na tatauf ma ka la sele suu ine fan mok fuu tiim tura fanenger tingnangen.” ");
INSERT INTO hrw_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Biing Yesus e seseng tikii ine fan warwar toftof a, i ka la kosngi e male a. ");
INSERT INTO hrw_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ma i ka fespuek mil ulo anwaran male kia, ma ka tofnge una fabenge singre tongge ulo bala felun nining keri ma ri ka kuufsak. Ri ka fagatomnge iri tibom, “Kaltu gii e kepe e parfat ma rawas una gow e fan mok na tibou fuut gii ting iya? ");
INSERT INTO hrw_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Areini, kaltu gii e tibi ta sikow e kapenta? Ma e tibi ta asow e tinow gii Maria? Ma e tibi ta tanga tualik gii Jeims, Josef, Saimon ma Judas? ");
INSERT INTO hrw_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ma areini e tibi ta tanga fefnelik gii tura kiar? Kaltu gii e kepe fan mok gii ting iya?” ");
INSERT INTO hrw_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ri balasak tikin ini. Ma Yesus ka war aregii, “Profet e mel e asow ilo mara male, sakle ilo anwaran male kia, profet e tek ti asow.” ");
INSERT INTO hrw_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","I e tibi gow e ti ton mok na tibou fuut ek fuun uwa, anwarow e tek ti titinge keri. ");
INSERT INTO hrw_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Lo biing a Erot kaltu bakir lo gapman e ong lo fan sinseng lo Yesus, ");
INSERT INTO hrw_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","i ka war singre fan tongge na mus kia, “Kaltu gii e ta Jon kaltu na gugu tarawen, e matet mil kosnge minet. Iya ka fasi una gow e fan mok rawas na tibou fuut.” ");
INSERT INTO hrw_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Famu Erot e sau bingfamti e Jon ka towfu ulo rerek. Anwarow lo Erodias, wok ke tualik e Erot, Filip. ");
INSERT INTO hrw_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Le Jon e sau peteng tifi, ini e tibi riis ususi e fafanau ini i eu tili e Erodias wok ke tualik. ");
INSERT INTO hrw_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Erot e bur paketmeteni e Jon sakle e soke re tongge, anwarow ri pari are profet. ");
INSERT INTO hrw_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Lo biing na sangfi e biing Erot e fuut lo, sikow fefin e Erodias e guui tifri. I ka gow e bala e Erot ka fefeal tibom. ");
INSERT INTO hrw_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Iya Erot ka limlim ini eu tow e sese ti mok a i ka bura sak, le i ku gatom usi. ");
INSERT INTO hrw_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Anwarow le tinow e sau peteng tifi ini sa eu gatom usi, i ka war, “Tow e paklu e Jon kaltu na gugu tarawen tif yau gii, ilo bala ti dis.” ");
INSERT INTO hrw_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Erot e la sangkut, sakle anwarow lo limlim kia namatre tongge lamlam ulo en a, i ka fauun usi e sa fefin a e gatom usi, ku puek. ");
INSERT INTO hrw_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ma ri ka la tesepakti e ankongkongow e Jon ulo bala felun rerek. ");
INSERT INTO hrw_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ma ri ka kepe paklu lo dis ri ka la tow tife fefin a, i kam la tow tife tinow. ");
INSERT INTO hrw_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Wimi fan disaipel kia ri kam sa kepe e pinumfow e Jon ri ka la ofo. Ma ri kam la ri ka la peteng tife Yesus. ");
INSERT INTO hrw_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Biing Yesus e ong lo sa e sau fuut, i e bom awes ka la ulo mok e tek tikas ulo. Sakle tongge ri sam ong lo ri ka fes usi tinglo fan taon. ");
INSERT INTO hrw_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Lo biing Yesus e la masa, i ka pari e singmat na galung kaltu a, ma i ka tengis ri sak. Ma ka faliungere fan tongge ri mase. ");
INSERT INTO hrw_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Biing e lala una la efef, fan disaipel ri ka la use Yesus ri ka la war, “Male gii e sasngal, ma e sau bala biing. Ou tulere tongge ri ku la ilo fan male, usi riu la fiil ton tuan ari ri ku en.” ");
INSERT INTO hrw_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ma Yesus ka koso, “E tam, riu tibi la. Gam u tow e ti tuan una en singri.” ");
INSERT INTO hrw_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ma ri ka koso. “Kemem su mel lo e lim e sumberet ma e u e fis.” ");
INSERT INTO hrw_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ma Yesus ka war, “Kepe wagii tif yau.” ");
INSERT INTO hrw_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ma i ka fauun tongge ri ka kiis ulo garas. Ma ka kepe e baba lim na sumberet a tura um fis, ka par wilo balambat, ka aro singe Deo ma ka bingpapaekri. Wimi ka tow tifre fan disaipel ma ri ka ti lo re tongge ini. ");
INSERT INTO hrw_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Tongge nano ri tiin en ri ka la sut ma fan disaipel ri ka sele tiim ine fan susun tuan e ngosok ri ka siing tiim ini ka puek ka la ta tikii sangful ma e u na dik. ");
INSERT INTO hrw_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","E ngo areini e lim e mar na tamat sekit ri en. Ri tibi wesre gelefin ma berberat. ");
INSERT INTO hrw_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Wimi sekit ini ri en tikii, Yesus ka uunre fan disaipel ri ka kaulek ulo bala mon ri ka la famu ini ulo neng e galu, ma i kabi tulere tongge. ");
INSERT INTO hrw_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Wimi ini e sam tuleri, i ka la kanek ulo paklunmale, ka la nining. I tibom ulo paklunmale a ka la efef talo. ");
INSERT INTO hrw_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Sakle mon e sam la u tapak. Ma kif e la ting famu ini ka pospose ulo. ");
INSERT INTO hrw_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ma enene Yesus ka la usi ri. I e fes ulo poktow e salat. ");
INSERT INTO hrw_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Biing fan disaipel ri pari e fes lala ulo poktow e salat, ri soke sak. Ri ka tau soksoke sak ri ka peteng ini, “Tara!” ");
INSERT INTO hrw_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Sakle Yesus e saupesak ka war singri, “Balamas, yau legii, gau mana soke.” ");
INSERT INTO hrw_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ma Pita ka koso, “Taufi, le ku ta o, peteng tif yau, ya ku fes ilo poktow e salat usi o.” ");
INSERT INTO hrw_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ma Yesus ka war, “Kasa.” Ma Pita ka pu tinglo mon ka fes ulo poktow e salat use Yesus. ");
INSERT INTO hrw_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ma biing e la pari e kif i e soke ma ka tofnge una maut gii ka tau singe Yesus aregii, “Taufi, ules yau!” ");
INSERT INTO hrw_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Saupesak Yesus ka sangau ine limow ka ulsi, ma ka war, “Titinge kiam e balik sak, e tamu o ka sang fa-u?” ");
INSERT INTO hrw_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ma biing ru kau ulo bala mon kif ka la met. ");
INSERT INTO hrw_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Wimi fa a ulo bala mon ri ka nining lo, ri ka war, “Tikin sak o na Sikow e Deo.” ");
INSERT INTO hrw_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Biing ri sam kaupaket ri la ba una Genasaret. ");
INSERT INTO hrw_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ma biing antamat tinglo male a, ri parfailmi e Yesus, ri tuleni e sunwar tifre mara male liflifit ri. Ma tongge ri ka uun puek ire tongge ri mase tifi. ");
INSERT INTO hrw_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ma ri ka sa war fangfangteni ini eu su towfu e tongge mase a ri ku su pot lo anisow e ke kolos. Ma tongge nano a ri ka pot lo anisow e ke kolos, ri liu. ");
INSERT INTO hrw_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Wimi fa lo re fam Farasi ma fan titsa lo fafanau ri la tingna Jerusalem una sa gatmo e Yesus. ");
INSERT INTO hrw_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Usi e tamu fan disaipel kiam ri ka kere ninis kere tuptuprer? Ri tibi gugua e limlim ri famu ma ri kamu en!” ");
INSERT INTO hrw_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesus ka koso, “Ma usi e tamu, gam ka kere e fafanau ke Deo, ma usi e ninis kemi tibom? ");
INSERT INTO hrw_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Deo e sam war, ‘Nawen singe tamam ma tinam.’ Ma ‘Le se a ka sak lo tamow ma tinow, i e samusu met.’ ");
INSERT INTO hrw_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Sakle gau peteng ini e riis, le kaltu ka mel e mani tam sa una ulse tamow ma tinow ma ku su peteng tifru, ini ‘Mani gii ya sau fagati una tow tife Deo.’ ");
INSERT INTO hrw_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","I e kaltu a, e am tibi nawen singe tamow. Lo sinang a, gau par pu ine sunwar ke Deo, ma kep ta iyat ine ninis kere tuptupmi. ");
INSERT INTO hrw_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Aisaiya e sam warwar profet lo gam tikin ini gam na ge na kepkep gam na matam pangkii: ");
INSERT INTO hrw_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Tongge gii ri resresnge yau lo ngusngusri ri, safle balbalri e ngo tapak i yau. ");
INSERT INTO hrw_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ri nining fofoes lo yau, le fam fabenge keri e su ta fam fabenge ke kaltu.’” ");
INSERT INTO hrw_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yesus ka tau ine galung kaltu usi ma ka war, “Ong ma ten usi. ");
INSERT INTO hrw_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Sa e kaulek lo ngusung kaltu e tibi gow e kaltu ka tibi kalkaliis, sakle sa e suu tinglo ngusu, i e mok a e gow e kaltu ka tibi kalkaliis.” ");
INSERT INTO hrw_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Kala fan disaipel kia ri ka puek talo ri ka gatmo, “O parfat ming ini fam Farasi ri ongne kem sunwar ri ka balasak?” ");
INSERT INTO hrw_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yesus ka koso, “Fan mara kalut gii tabuung lo balambat ka tibi so, i eu fitufufri tiim tura auauwi ri. ");
INSERT INTO hrw_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Tauf ri, ri na tongge na famfamu ine sal, sakle ri baf. Le ti kaltu baf e famu ine neng e baf, iru nano ru luut lo ampolo.” ");
INSERT INTO hrw_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pita ka war singe Yesus, “Pete ten ine warwar toftof a tif kemem.” ");
INSERT INTO hrw_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesus ka gatom ri, “Areni, gam tifik ten? ");
INSERT INTO hrw_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Gam tibi parfat ini sese mok e kau lo ngusung kaltu e kaulek lo sakow ma wimi kau pu lo fel balik? ");
INSERT INTO hrw_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Sakle fan mok gii ka suu tinglo ngusung kaltu e la tinglo bala. Ma i e fan mok a, iya ka gow e kaltu ka tibi kalkaliis. ");
INSERT INTO hrw_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ting lo balang kaltu, sangsang saksak, sinang na paketmet ine kaltu, faet falek, bero ine fan tinaule, kinau, sinang na fapin ilo anganggon, ma bero fofoesngeni e asow e neng. ");
INSERT INTO hrw_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","I e fan mok gii, ka gow e kaltu ka tibi kalkaliis. Safle una en tura limam o tibi gua, e tibi ta i lea, ka gow o ka tibi kalkaliis, e tam.” ");
INSERT INTO hrw_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesus ka la kosnge male a, ma ka la ulo galum nal kere fan Tair ma Sidon. ");
INSERT INTO hrw_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ma neng e e fefin tingna Kenan e melmel wa, i e sa la ka tautau, “Taufi Sikow e Dewit, on tengis yau! Kek fefin, tara saksak e sispi ka bero sekit ini.” ");
INSERT INTO hrw_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Safle Yesus e tibi kokos singi. Fan disaipel kia ri ka sa la use Yesus ma ri ka war, “Onu ku la e mi nami kiar ka fagalo.” ");
INSERT INTO hrw_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yesus ka koso, “Deo e su tule yau una kep familre fan sipsip tingna Israel gii ri ka tam falek iri.” ");
INSERT INTO hrw_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Fefin a ka puek ka sa pukungkek u famu ini, ma ka war, “Taufi, ules yau!” ");
INSERT INTO hrw_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yesus ka koso, “E tibi riis ini riu kepe fan tuan are berberat ri ku bas ini tifre fam puul keri.” ");
INSERT INTO hrw_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Fefin a ka war, “E tikin Taufi, safle fam puul ming ri siksikmeru e fang katkatmiran tuan e luut tinglo fam fate na enen kere tamtamri.” ");
INSERT INTO hrw_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Yesus e ongni e sunwar a, ka koso aregii, “Wok, titinge kiam e bakir sak. Sa o bura ini eu puek lo o, eu puek.” Ma lo sum biing sekit a, ke fefin e liu. ");
INSERT INTO hrw_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesus ka la kosnge male a, ma ka la fes lala ulo anisow e Salat Galili. Wimi kam kanek ulo paklunmale ka la kiis uf. ");
INSERT INTO hrw_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ma tongge fuunfuun ri ka puek usi. Ri unpuek ire fa kekek ri e sak, fa ri baf, fa ri dol, fa ngungus ri e kut ma fanenger fan minse ri ka sa toufri fatatu e kekow e Yesus, ma i ka faliungeri. ");
INSERT INTO hrw_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Tongge ri kuufsak lo biing ri pari e ngusngusri kut ri gon, fa ri dol ri kausi, fa kekek ri e sak ri fes ma fam baf ri par mil. Ri ka katfarsi e Deo tingna Israel. ");
INSERT INTO hrw_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesus e tau ine fan disaipel kia, ma ka peteng tifri aregii, “Balang e kuluung use re tongge gii. Ri sau melmel tura yau lo e tuul e biing, ma ka tek ti tuan ari. Ya tibi bur tule biis iri, are matmat ri ka belbelil ma ri ka luut ilo sal.” ");
INSERT INTO hrw_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Fan disaipel kia ri ka koso, “Galu gii e tek ti kaltu gii lo, ma kiar ku kepe fam beret ting iya, una fenre tongge fuunfuun gii?” ");
INSERT INTO hrw_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesus ka gatom ri, “E fis e beret a sing gam?” Ri ka koso, “Baba fis na beret ma tom borom fis.” ");
INSERT INTO hrw_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Yesus ka war singre tongge una kiis lo nal. ");
INSERT INTO hrw_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ma ka kepe baba fis na beret ma fam fis a, ka katfarsi Deo ma ka bingpapaekri ma ka tow tifre fan disaipel kia una fasa ini tifre tongge. ");
INSERT INTO hrw_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Tongge nano ri en ri ka la sut, wimi fan disaipel ri ka sele tiim ine fan susun tuan ari e ngosok talo bala baba fis na dik. ");
INSERT INTO hrw_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Tongge ri en lo biing a, e ta e fet e mar na tamat, ri ti wese e berberat ma gelefin. ");
INSERT INTO hrw_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Biing Yesus e sam tulere tongge ri ka la, wimi kam kau lo mon ka la lo galu lo Magadan. ");
INSERT INTO hrw_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Fam Farasi ma fan Sediusi ri bur sa tofo e Yesus, ri ka puek usi, ri ka gatmo ini eu gow e ti mok na tibou fuut una fanangsi ini Deo e tuleni, usi riu pari. ");
INSERT INTO hrw_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","I ka koso singri, “Biing gau pari e balbal e buuluum lo efef, gam ka peteng a ini na biingbiing eu ta konona biing. ");
INSERT INTO hrw_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ma lo biingbiing e mok, biing gau pari e balbal e mikiit gam ka peteng ini eu kif ma ku bat. Gau parfat una lafu e parpar lo balbal, safle gam tibi parfat una ikseni e fan tintof lo biing gii. ");
INSERT INTO hrw_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Kulu lo biing gii e ta tongge saksak e tek ti balri use Deo. Ri bura ini riu pare fan tintof, safle riu tibi par ti tintof. Riu su pari e tintof lo Jona.” Ma Yesus ka matet kosing ri ka la. ");
INSERT INTO hrw_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Biing ri matet ri ka la lo galu lo salat fan disaipel ri sangintafngi una kepe beret. ");
INSERT INTO hrw_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yesus ka war singri, “Gam u efe kausi ma ate use is kere fam Farasi ma fan Sediusi.” ");
INSERT INTO hrw_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ri ka fagon falifu iri tibom aregii, “I e war aiya, anwarow kiar tibi kepe ti beret.” ");
INSERT INTO hrw_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yesus e parfat lo fawar ri gow ka war singri, “Titinge kemi e balik. E tamu gam ka fagon falifu i gam tibom ini e tek ti beret? ");
INSERT INTO hrw_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Gam tifik ten? Gam tibi sangfi e lim e beret lo e lim e mar na kaltu ma e fis e dik gam sengi ka fuun? ");
INSERT INTO hrw_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ma baba fis na beret lo e fet e mar na kaltu ma e fis e dik gam sengi ka fuun? ");
INSERT INTO hrw_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Areni gii, gam ka tibi ten ini, ya tibi gongon sing gam lo beret? Sakle gam u ate kausi use is kere fam Farasi ma fan Sediusi.” ");
INSERT INTO hrw_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Wimi ri kam ten, ini e tibi gongon singri ini riu ate use is gii ri ka towtow lo beret. Safle riu ate use fam fabenge kere fam Farasi ma fan Sediusi. ");
INSERT INTO hrw_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Biing Yesus e puek ulo galu nal ke Sisaria Filipai, ka gatom re fan disaipel kia ini, “Tongge ri peteng ini Sikow e Kaltu e ta se tikin?” ");
INSERT INTO hrw_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ri ka koso, “Fa ri peteng ini o Jon kaltu na gugu tarawen ire tongge, fa ri peteng ini o Elaija, ma fa ri peteng ini o Jeremaiya tam, neng lo re fam profet.” ");
INSERT INTO hrw_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yesus ka gatom ri, “Ma gam tibom gau peteng ini yau se?” ");
INSERT INTO hrw_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Saimon Pita ka koso singi aregii, “O na Mesaiya. O na Sikow e Deo e mel e ninliu.” ");
INSERT INTO hrw_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yesus ka koso, “Warfakausi eu ta ailo o, Saimon sikow e Jona, fan mok gii e tibi ta kaltu e famalalngeni tifo, safle Tabuung ilo balambat i e famalalu. ");
INSERT INTO hrw_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ma ya peteng tifo ini o Pita, ma lo poktow e fat gii, yau feti e kek sios, ma minet, e tek ti rawas kia una tafngi. ");
INSERT INTO hrw_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Yau tow e fang ki tinglo kepmale tinglo balambat tifo. Sese mok ou kawefamti wagii lo nal riu kawefamti lo balambat, ma sese mok ou pikufu wagii lo nal riu pikufu ilo balambat.” ");
INSERT INTO hrw_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Wimi Yesus ka fanau re fan disaipel kia ini riu tibi peteng tife tikas sekit ini i na Kristus. ");
INSERT INTO hrw_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Tinglo biing a ka la, Yesus e tofnge una peteng ten tifre fan disaipel kia ini i e samusu la ina Jerusalem, usi ini eu kepe mara ongker lo limre tongge lamlam, fam pris lamlam ma fan titsa lo fafanau, ma ri ku paketmet ini. Ma lo biing baba e tuul, Deo eu famtet famila. ");
INSERT INTO hrw_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pita e ongni e fan warwar ka onu ka la ulo galu ma ka tofnge una porow, “Taufi, e tam! Fan mok gii, eu tibi fuut sekit lo o!” ");
INSERT INTO hrw_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yesus ka didiu ma ka war singe Pita, “On la winami yau, Satan! O bala kali e sal kiang, anwarow fan sangsang kiam a, e tibi puek singe Deo, safle singe kaltu.” ");
INSERT INTO hrw_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Kala Yesus ka war singre fan disaipel kia, “Le tikas ka fabur una minami yau, i e samusu faporo e fabur kia tibom, ma kepe aupaket kia ma ku usi yau. ");
INSERT INTO hrw_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Anwarow le sese ti kaltu a ka sangsang una bingfamti e ninliu kia tibom, ninliu kia eu tam ini. Safle se a ku fafen ine ninliu kia usi yau, i eu kepfamila e ninliu kia. ");
INSERT INTO hrw_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Sese kausi le kaltu eu kepe mara mok nano gii lo nal, sakle ninliu kia tibom ku tam ini, tam, sese fimfiil kaltu eu tow una fiil famila e ninliu kia? ");
INSERT INTO hrw_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Anwarow Sikow e Kaltu eu puek tura mia ma finaswen ke Tamow tura fan anggelo kia, ma wimi kamu tow e fimfiil ke tikii neng tikii neng ususi e sa e sam gow. ");
INSERT INTO hrw_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ya peteng tikin tif gam, fa lo re tongge gii ri ka titi gii, riu tifik met, ku muut riu pari e Sikow e Kaltu eu puek are King.” ");
INSERT INTO hrw_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Wimi ine e on e biing, Yesus e onu e Pita, Jeims, ma Jon e ta tualik e Jeims. Ma ka uun ri, ri ka la ulo paklunmale e kiis iyat. Ma ri ka la melmel iri tibom uwa. ");
INSERT INTO hrw_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ma biing ri parpar uwa, pinumfow e Yesus e fespuek ka ngo kuriik. Ma mata e sosok are pisii. Ma kolos kia ka fespuek ka la murmur sak are anten. ");
INSERT INTO hrw_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Moses ma Elaija ru puek ma fan disaipel ri ka par ru gongon tura Yesus. ");
INSERT INTO hrw_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pita e pari e mok gii, ka war singe Yesus aregii, “Taufi, e kausi ini kiar u melmel wagii. Le o ku bura, yau feti e tuul e kak. Neng kiam, neng ke Moses ma neng ke Elaija.” ");
INSERT INTO hrw_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pita e gongon uwa, ma pambalbal e sosok ten sak ka afit ri. Ma angkiimkiim e la tinglo bala pambalbal a e war aregii, “Igii e sikuang, ya bura sak; ma ya fefeal lo. Gam u ongong singi.” ");
INSERT INTO hrw_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Fan disaipel ri ongni e angkiimkiim gii, ma ri ka la soke sak, ri ka luut ulo nal. ");
INSERT INTO hrw_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ma Yesus ka fespuek fatat ri ka pot lala lo ri, ma ka war, “Gau matet, gau mana soke.” ");
INSERT INTO hrw_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Biing ri par wiyat, ri tibi par tikas, safle Yesus tibom. ");
INSERT INTO hrw_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Biing ri fes pu lala tinglo paklunmale, Yesus ka fanauri aregii, “Gam u tibi la seseng tife tikas ine mok gam sau pari ku muut lo biing Sikow e Kaltu eu matet mil kosnge minet.” ");
INSERT INTO hrw_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ma fan disaipel ri ka gatmo aregii, “Anwarow lo sa gii fan titsa lo fafanau ri ka peteng ini Elaija eu puek famu?” ");
INSERT INTO hrw_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesus ka koso aregii, “Yow, sunwar a e tikin. Elaija e samusu puek una fariisu e fan mok nano. ");
INSERT INTO hrw_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Sakle ya peteng tif gam, Elaija e sau puek safle tongge ri tibi parfat lo, e tam, ri usi e sinanguri tibom ma ri ka bero ini, ma sinang mung a riu gow lo Sikow e Kaltu.” ");
INSERT INTO hrw_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Wimi, fan disaipel ri kau parfat ini i e gongon lo Jon, kaltu na gugu tarawen ire tongge. ");
INSERT INTO hrw_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Yesus tura e tuul e disaipel kia ri sa fespuek mil talo singmat na galung kaltu, neng e kaltu ka sa pukungkek u famu ine Yesus, ");
INSERT INTO hrw_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ma ka war, “Taufi! Tengsi e sikuang, i e lomlomba, ka banban ma ka luutluut talo nal, ma i ka kepe ongker bakir sak. Tom biing eu luut talo iif, ma tom biing eu luut talo bala dan. ");
INSERT INTO hrw_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ya onu tifre fan disaipel kiam, safle ri tibi fasi una faliungeni.” ");
INSERT INTO hrw_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ma Yesus ka koso aregii, “Gam na kulu na tibi titinge, sinangumi ma ninis kemi e tibi kausi, e sak sekit. E fis e biing yau melmel tura gam? Ma e fis e biing ming yau kepe mafet tura gam? Kepe e boroner a wagii tif yau.” ");
INSERT INTO hrw_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ma Yesus ka war rawas singe tangwaner saksak a, ma tangwaner saksak a ka la kosngi ma saupesak anminse ulo boroner a ka rop. ");
INSERT INTO hrw_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ma wimi biing ri sam la ta iri tibom, fan disaipel ri ka gatmo e Yesus aregii, “Areini kemem ka tibi fasi una feselufu e tangwaner saksak gii?” ");
INSERT INTO hrw_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Ma i ka koso singri aregii, “Anwarow titinge kemi e balik sak. Ya peteng tikin tif gam, le titinge kemi enggi su balik are amfiran mastet, gau fasi una war singe paklunmale gii ku se ting wagii ku la waleii, ma ku se. E tek ti mok eu kalkala sing gam.” ");
INSERT INTO hrw_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Yesus tura fan disaipel ri tiim una Galili, ma Yesus ka war singri aregii, “Sikow e Kaltu riu solamufu ku la ilo limre tongge, ");
INSERT INTO hrw_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ri ku paketmet ini. Ma lo biing e tuul Deo eu famtete mil.” Fan disaipel kia ri ongni e sunwar kia ma ri ka la sangkuuluung. ");
INSERT INTO hrw_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Wimi Yesus ma fan disaipel kia ri tiim ulo taon Kapernaum, ma tongge una kepkep mani tinglo Felun Nining Bakir ri ka gatmo e Pita aregii, “Titsa kiam, e basbas mani ming wilo felun nining bakir?” ");
INSERT INTO hrw_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ma Pita ka war, “Yow.” Biing e kau ulo bala fel, e tifik war ma Yesus ka gatmo aregii, “Saimon, o sang areini, tongge lamlam tinglo nal ri kepe mani singe se? Sing re siksikwari tam singre fa kuriik?” ");
INSERT INTO hrw_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ma Pita ka war, “Sing re fa kuriik.” Ma Yesus ka peteng tifi aregii, “Siksikwari tibom ri tibi fasi una tow e mani. ");
INSERT INTO hrw_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Sakle usi ini kereu tibi pete balasak iri, ou la ilo bala dan o ku la bas ine keu fan wa, ma fis baba tikii eu liil, ou kepe o ku ipki e ngusu, ma o ku kepe e mani ilo bala. Mani a, e ta kara ou tow tifri.” ");
INSERT INTO hrw_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Lo biing a fan disaipel ri sa la use Yesus ma ri ka gatmo aregii, “Se tikin eu kepe as bakir ilo kepmale tinglo balambat?” ");
INSERT INTO hrw_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ma Yesus ka tau ine boroner ma ka fetiufu ulo falifu lo ri, ");
INSERT INTO hrw_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ma ka war, “Ya peteng tikin tif gam, le gam ka tibi fapor gam are boroner gii, gam tibi fasi sekit una kau ilo kepmale tinglo balambat. ");
INSERT INTO hrw_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Kaltu e faporo are boroner i tibom eu kepe as bakir tikin ilo kepmale tinglo balambat. ");
INSERT INTO hrw_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Le kaltu ka sang usi yau ma ka areni e ti boroner are boroner gii, i e are yau. ");
INSERT INTO hrw_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ma le tikas ka bero ine tikas lo re berberat gii, ma titinge kia ka luut, i eu kepe mafet e bakir iyat, le ri ku kawi e ti fat bakir ilo angkongkongow ma ri ku fauli ina kasap usi eu met. ");
INSERT INTO hrw_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Kiskam singre tongge gii lo nal, anwarow fan mok saksak ri gorot re tongge ri ka luut lo finalam. Tikin sinang saksak gii eu fespuek, sakle kiskam singe se gii ka fafuutngeni. ");
INSERT INTO hrw_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Le galun limam, tam, galun kekem ka tatfe o wilo tubiil, tese pakti o ku bas ini. E kausi ini o tuk ma o ku kau lo male na ninliu bingne, are ka u e kekem ma ka u e limam ma ri ka bas i o lo bala iif a ka tibi metmet. ");
INSERT INTO hrw_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Male, anmatam ka fufte o talo tubiil, ou sipil ufu. E kausi ini eu mel e tikii anmatam ma o ku kau lo male na ninliu bingne, are ka u e anmatam ma ri ka bas o ilo bala iif e tibi metmet. ");
INSERT INTO hrw_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","“Gam u ate kausi are gam ka sangfi ini berberat gii, ri ta fan mok fofoes, e tam. Ya peteng tikin tif gam, ilo balambat fan efefe keri, ri melmel bingne ilo male ke Tabuung. ");
INSERT INTO hrw_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Are gam sang? Le kaltu ka mel e tikii atis na sipsip kia, ma tikii neng ka tam ini, eu tibi sik ini? E tam, eu towfu e siu e sangful ma e siu, ku ngosok ma ku la ku la sik ine tikii neng a ka tam ini. ");
INSERT INTO hrw_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ya peteng tikin tif gam, le ku kep famila, fefeal kia eu bakir sak iyat ine fefeal kia lo e siu e sangful ma e siu uwa. ");
INSERT INTO hrw_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Aregii Taumi ilo balambat e tibi bura ini tikas lo berberat gii, eu tam ini.” ");
INSERT INTO hrw_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Yesus e war, “Le tuamlik ka gow e tubiil lo o, e kausi ini ou la pari, usi ku parfailmi e tubiil kia. Ma biing kamu melmel, ou tofo una fariis kamu tibom. Ma le ku ong sing o, e kausi o sam kep famila mil e tuamlik. ");
INSERT INTO hrw_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ma le ku tibi ong sing o, e kausi ini ou onu e tikii tam e u e kaltu una tiim tura o, una farawasngeni e sunwar, ususi e sunwar ke Deo. ");
INSERT INTO hrw_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ma le ku tibi ong singri e kausi ini ou peteng tife sios. Ma le ku tibi ong singri ming e kausi ini ou pari are tematan, tam kaltu na kepkepe mani. ");
INSERT INTO hrw_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Ya peteng tif gam, sese mok gam u kawefamti wagii lo nal riu kawefamti lo balambat, ma sese mok gam pikufu wagii lo nal riu pikufu ilo balambat. ");
INSERT INTO hrw_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Ma ya peteng tikin mil tif gam, le ka u e kaltu ru tiim lo tikii sangsang gii lo nal, ma ru ka nining usi Tabuung ilo balambat, i eu gow tif ru. ");
INSERT INTO hrw_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Le ilo sese mok ka su u, tam, ka su tuul e kaltu ri tiim lo asang, yau melmel falifu lo ri.” ");
INSERT INTO hrw_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Wimi Pita e fespuek talo Yesus ma ka gatmo aregii, “Taufi, eu fis e biing tuaklik e gow e tubiil lo yau ma ya ku sangintafngi? Baba fis na biing?” ");
INSERT INTO hrw_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ma Yesus ka war singi aregii, “Ya tibi peteng tifo ini ou su fafis sangintafngi e fan tubiil kia, e tam, ya peteng tifo ini ou sangintafngi ku muut lo e fis e sangful na biing, ou wes fafis ini. ");
INSERT INTO hrw_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Ong, kepmale tinglo balambat e ngo are king a, ka bala fariisu e fan mara dinau nano kere tongge na faim kia. ");
INSERT INTO hrw_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","I e fanwaru e faim una fariisu e fan dinau, ma ri ka onu e neng e kaltu ka sa la e mel e dinau kia e muut lo tikii sangful na mar na mar ma mar. ");
INSERT INTO hrw_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Sakle e tek ti mani kia ek fasi una koso e dinau a, iya, king ka tungen re fa, ‘Gam umat ine kaltu a ma ke wok ma siksikow usi, riu fespuek ku ta tongge na faim fofoes ke neng e kaltu. Ma gam samusu umat ine mara mok nano kia. Ma lo ninis mung a, i eu kos famila e dinau.’ ");
INSERT INTO hrw_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Kaltu a, e ongni e sunwar a, e kiis pukungkek ulo fow e kekow e king ma ka war, ‘On tengis yau. Ma o ku nene yau, yau koso e fan mara dinau nano ya kepe sing o.’ ");
INSERT INTO hrw_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ma king ka tengsi ma ka sangintafngi e fan mara dinau nano kia. ");
INSERT INTO hrw_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Biing kaltu a e suu una male ma ka pari e taltalu e mel e dinau kia singi, e ta tikii atis na mani. I ka bingfamti ulo angkongkongow ma ka war singi aregii, ‘O samusu koso e fan mara dinau nano o kepe sing yau.’ ");
INSERT INTO hrw_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Taltalu e ongni e sunwar a, ka kiis pukungkek ma ka war singi aregii, ‘On tengis yau ma o ku nene yau, yau koso e fan mara dinau nano ya kepe sing o.’ ");
INSERT INTO hrw_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Sakle kaltu a e tibi fabur, e tam. E towfu e taltalu ulo rerek ku muut lo eu koso mil e fan dinau nano kia. ");
INSERT INTO hrw_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Fan taltalu ri pari e mok a e gow ma ri ka la balasak ini, ri ka la peteng tife king keri ine fan mara mok nano kaltu a e gow. ");
INSERT INTO hrw_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“King ka tau ini ma ka war singi aregii, ‘O na kaltu saksak, famu o teng ini yau ules o lo fan mara dinau kiam. ");
INSERT INTO hrw_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ya sam tengis o, ma areini o ka tibi tengsi e taltalum?’ ");
INSERT INTO hrw_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ma king ka balasak, ma ka tow ulo limre tongge na efefe lo rerek una tow e mafet tifi, ku muut lo biing eu koso e fan mara dinau nano kia. ");
INSERT INTO hrw_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Aregii, Tabuung ilo balambat eu gow e tikii ninis ming a lo o, le o ku tibi sangintafngi tikin tinglo ambusbusam, e fan tubiil tuamlik e gow lo o.” ");
INSERT INTO hrw_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Biing Yesus e gongon tikii lo fan mok gii, i ka la tingna Galili ka la una Juda ulo galu lo dan Jodan. ");
INSERT INTO hrw_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ma galung kaltu fuunfuun sak ri ka mi nami, ma i ka la faliungeri uwa. ");
INSERT INTO hrw_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Fam Farasi ri ka fespuek use Yesus una sa tofo. Ma ri ka sa gatmo aregii, “Fafanau kiar e a-uu lo kaltu e fasi una kalafeni e wok kia, lo fabur kia tibom?” ");
INSERT INTO hrw_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ma Yesus ka koso aregii, “Gam tifik wese? Ini le tinglo tofnge Deo ‘e bilseni e tamat ma fefin,’ ");
INSERT INTO hrw_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","ma ka war aregii, ‘tamat eu la kosngi e tamow ma tinow ma ku la tiim tura ke wok, ru ku fespuek ru ku ta tikii foru.’ ");
INSERT INTO hrw_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ru am tibi melmel are e u e kaltu, e tam, ru fespuek are tikii kaltu. Sese mok Deo e sam tauftiim ini, kaltu e tibi fasi una sefapot ini.” ");
INSERT INTO hrw_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ma fam Farasi ri ka peteng tifi aregii, “Areini gii Moses ka tow e fafanau tif kiar ma ka peteng ini, kaltu e fasi una seti e pampel na kere antinaule ma fefin ku la?” ");
INSERT INTO hrw_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ma Yesus ka war singri aregii, “Gam na tongge balbalmi e kut, i ya Moses ka a-uu lo gam una fesel re fan wok kemi. Safle e tibi ngo aiya tinglo tofnge. ");
INSERT INTO hrw_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ya peteng aregii tif gam, le wok ke kaltu ka tibi gow e ansinang na faet falek ma ke matuk ka fesi, ma ka tinaule fuu, kaltu a e gow e ansinang na faet falek.” ");
INSERT INTO hrw_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Fan disaipel kia ri ka ongni e sunwar a ma ri ka war singe Yesus aregii, “Le kaltu ku usi e ninis gii, e kausi ini eu tibi su tinaule sekit.” ");
INSERT INTO hrw_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ma Yesus ka war singri aregii, “E tibi ta ini tongge nano ri fasi una kepe e sunwar gii, e tam. Deo e su tow e rawas tifre fa tibom una kepe. ");
INSERT INTO hrw_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ong, e mel e matan tongge gii wa ri tibi fasi una tinaule. Fa fofori e sak biing tintinri ri fasus iri; fa ri pu ri, ri ka tibi fasi una fafuutnge re berberat; ma fa ri faim usi kepmale tinglo balambat, ri ka warkale ri tibom una tibi tinaule. Sakle se a ka fasi una a-uu lo sunwar gii, i e samusu usi.” ");
INSERT INTO hrw_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Kala antamat ma gelefin ri uun puek ire berberat use Yesus. Ri bura ini eu tow e limow ilo ri ma ku nining lo ri. Sakle fan disaipel kia ri porau re tongge a. ");
INSERT INTO hrw_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ma Yesus ka peteng tifre fan disaipel a aregii, “Gam taufre berberat a ri ku sa la usi yau ma gam ku mele kale ri. Anwarow kepmale tinglo balambat e ta kere tongge a ri ka ngo are berberat gii.” ");
INSERT INTO hrw_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ma ka tow e limow ulo ri, ma wimi kala kosnge male a. ");
INSERT INTO hrw_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ma neng e kaltu ka sa la use Yesus ma ka sa gatmo, “Titsa, yau gow e sese konona mok usi yau kepe ninliu bingne?” ");
INSERT INTO hrw_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ma Yesus ka war singi aregii, “Anwarow lo sa gii o ka gatom use konona mok? Deo, e su tikiini tibom e kausi. Sakle le o ku bura e ninliu bingne, ou usi e fam fafanau ke Deo.” ");
INSERT INTO hrw_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ma kaltu a ka gatmo e Yesus aregii, “O war lo sese fam fafanau?” Ma Yesus ka war, “Fam fafanau a ri war aregii. Gam u tibi paketmet ire fa. Gam u tibi gow e ansinang na faet falek. Ma gam u tibi kinau, ma gam u tibi fapin ilo anganggon. ");
INSERT INTO hrw_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Gam samusu natkeni e tamtaumi ma tintinmi. Ma o samusu bura e neng aregii o ka buro tibom.” ");
INSERT INTO hrw_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ma guam a ka war singe Yesus aregii, “Ya sam usi e mara fafanau nano a, safle ya pospos iwa lo sese mok?” ");
INSERT INTO hrw_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ma Yesus ka war singi aregii, “Le o ka bur puek riis sekit, arik la umat ine fan mara mok nano kiam. Ma sese mani a o ka kepe lo, o tow kere fan sasngal. Ou gorot aiya usi ou kepe e konona fan mok ilo balambat. Ma o kamu kasa o ku mi nami yau.” ");
INSERT INTO hrw_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ma kaltu a ka ongni e fan warwar a ma bala ka la mafet gii ka la kosngi Yesus, anwarow e mel e fan mok fuunfuun kia. ");
INSERT INTO hrw_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ma Yesus ka war singe fan disaipel kia aregii, “Ya peteng tikin tif gam, tongge tuba ri e mel eu tuntun sak singri una kau ilo kepmale tinglo balambat. ");
INSERT INTO hrw_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ya peteng ming tif gam, e tibi paumiil singe kamel una los ilo amfur lo nil na somsomap, sakle e tuntun tikin iyat singe kaltu tuba mel una kaulek ilo bala kepmale ke Deo.” ");
INSERT INTO hrw_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Fan disaipel kia ri ongni e war aiya ma ri ka la kuufsak tikin, ma ri ka war, “Le ku ta aiya, se gii ku fasi una kepe e ninliu bingne?” ");
INSERT INTO hrw_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ma Yesus ka par usi ri ma ka war, “Tongge ri tibi fasi, sakle Deo tibom e fasi una gow e mara mok.” ");
INSERT INTO hrw_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Biing e war aiya, Pita ka koso aregii, “Par, kemem la kosngi e mara mok, kemem ka usi o. Kemem u kepe e sese mok?” ");
INSERT INTO hrw_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ma Yesus ka peteng tifri aregii, “Ya peteng tikin tif gam, lo biing fan mara mok riu puek fuu ma Sikow e Kaltu ku kiis ilo sia king na finaswen kia, lo biing a, gam na tongge a gam ka usi yau, gau ming gam u kiis ilo tikii sangful ma u na konona sia, ma gam ku efe lo tikii sangful ma e u na matambia tingna Israel. ");
INSERT INTO hrw_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ma tongge nano a ri ka la kosngi e fam fel, tam fan tualik ri, tam fam fefnelik ri, tam tamtamri, tam tintinri, tam siksikwari, tam fam palang keri anwarow lo yau, riu kepe atis ming ilo poktow e sa a ri kabuk mel lo. Ma ri ku kepe e ninliu bingne. ");
INSERT INTO hrw_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Sakle tongge fuunfuun a ri ka puek baba tikii, riu la mi sekit. Ma fa fuunfuun a ri ka mi sekit, riu puek baba tikii.” ");
INSERT INTO hrw_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Ma Yesus ka war ming aregii, “Kepmale tinglo balambat e ngo are taman nal e la lo biingbiing e mok sak, una uunre tongge una faim lo bala palang na waen kia. ");
INSERT INTO hrw_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","I e peteng tifri ini eu fiilri ine fimfiil tinglo tikii biing ma ri ka tiin a-uu lo, ma kam uun ri una faim lo palang na waen kia. ");
INSERT INTO hrw_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Lo e siu e anmatam pisii e la ma ka pari e fa ri titi ulo male na umumat, e tek ti faim ri gow. ");
INSERT INTO hrw_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","I ka war singri, ‘Gau ming gaman la faim lo palang na waen kiang, ma ya mu fiil gam ku fasi lo faim gam gow.’ ");
INSERT INTO hrw_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ma ri ka la. “I e la mil ming, ma lo 12 kilok ma lo 3 kilok lo efef i e gow e su tikii mok. ");
INSERT INTO hrw_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ma lo e lim e anmatam pisii lo efef i e la ma ka pari e fa ri titi fofoes ka gatom ri, ‘Anwarow lo sa gam ka tibi faim lo biing kiruur geinggii, ma gam ka melmel fofoes?’ ");
INSERT INTO hrw_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Ma ri ka war singi aregii, ‘Anwarow e tek tikas ek tow e ti faim tif kemem.’ “Ma i ka war singri, ‘Gau ming gam la faim ilo bala palang na waen kiang.’ ");
INSERT INTO hrw_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Ma lo efef tamow e palang na waen e war singe kaltu na efefe kia, ‘Tau ire tongge na faim ma tow e fimfiil keri. Tofnge tinglo kaltu ya tau ini wimi sekit ku muut lo kaltu ya tau ini baba tikii.’ ");
INSERT INTO hrw_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Tongge na faim ri tofnge lo e lim e anmatam pisii ri sa la ma ri ka kepe tikii fimfiil. ");
INSERT INTO hrw_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ma biing tongge ri faim famu ri sala, ri sangfi ini riu kepe fimfiil bakir, safle e tam. Ri su kepe tikii matam fimfiil ming. ");
INSERT INTO hrw_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ri pari e fimfiil ri kepe ma balbalri ka sak ine tamow e palang na waen, ");
INSERT INTO hrw_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ma ri ka war, ‘Fa ri faim wimi, ri su faim lo tikii e anmatam pisii, ma areini gii ri ka kepe tikii matam fimfiil are kemem? Safle kemem faim tuntun tinglo biingbiing e mok sak ka muut gii, ma pisii ka pal kemem.’ ");
INSERT INTO hrw_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Safle i e war singe neng lo ri aregii, ‘Fenngong, ya tibi tubiil lo o. Ya sang ini famu kara sam a-uu tinglo tofnge lo tikii fimfiil. ");
INSERT INTO hrw_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Kepe fimfiil kiam ma o ku la. Ya bur tow e tikii matam fimfiil tife neng e faim wimi, aregii ya ka tow tifo. ");
INSERT INTO hrw_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","E tamu, e tibi riis lo ini yau gow e sa ya bur gow lo kek mani? Tam o su mer le ya gow e konona sinang?’” ");
INSERT INTO hrw_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ma Yesus ka war aregii, “Seri a ri ka mi sekit, riu puek baba tikii. Ma seri a ri ka puek baba tikii, riu la mi sekit.” ");
INSERT INTO hrw_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Biing Yesus e fesfes lala wina Jerusalem, i e onu e tikii sangful ma e u na disaipel kia ri ka la tiim iri tibom ulo galumfow e sal, ma ka war singri, ");
INSERT INTO hrw_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Kiar u la ina Jerusalem, aregii Sikow e Kaltu riu solamufu tifre fam pris lamlam ma fan titsa lo fafanau. Ma riu anganggon singi ma ri ku fawar una paketmet ini. ");
INSERT INTO hrw_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ma ri ku tow ilo limlimre fan Jentael ri ku tumar saksak ini, ri ku napsi, ma ri ku tutfamti lo aupaket. Ma lo biing baba e tuul Deo eu famtet famila.” ");
INSERT INTO hrw_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Wimi tinow e Jeims ma Jon un sikow e Sebedi tura un sikow, ri sa la use Yesus, ri ka sa pukungkek u famu ini ma ri ka gatmo use fabur keri. ");
INSERT INTO hrw_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ma Yesus ka gatmo, “Sa tikin o bura?” Ma fefin a ka war aregii, “Ya bura ini un sikuang ruw kiis inais o ilo bala kepmale kiam. Neng ilo galu miil ma neng ilo galu kais.” ");
INSERT INTO hrw_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ma Yesus ka war singi aregii, “O tibi parfat lo sa o gatom usi. Kamu fasi ming una in lo kap gii ya ka bala in lo?” Ma ru ka war singe Yesus, “Kama fasi.” ");
INSERT INTO hrw_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yesus ka peteng tif ru, “Tikin sak, kamuw in lo kap aiyang, safle una kiis ilo galu miil ma galu kais kiang e tibi ta ini yau war lo. Male gii e ta kere tongge Tabuung e sau fagati ri wilo.” ");
INSERT INTO hrw_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Biing tikii sangful na disaipel ri ongni, ri balasak ine re latualik a. ");
INSERT INTO hrw_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Yesus e tau tiim iri ma ka war, “Gau parfat, tongge na efefe kere fan Jentael, ri efefe tikin lo re tongge keri. Ma tongge lamlam keri, ri efefe rawas lo re tongge ini riu usi e fan warwar keri. ");
INSERT INTO hrw_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","E tibi ta aiya usi gam, e tam. Sese kaltu e bur bakir falifu i gam eu ta kaltu na faim kemi. ");
INSERT INTO hrw_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ma se a ka bura ini eu famu, e samusu ta kaltu na faim fofoes kemi. ");
INSERT INTO hrw_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Aregii Sikow e Kaltu e tibi sa la ini tongge ri ku ulsi, e tam. I e sa la una ules re tongge ma una tow e ninliu kia una kepfamilre tongge.” ");
INSERT INTO hrw_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Biing Yesus ma fan disaipel kia ri la kosnge Jeriko, singmat na galung kaltu ri mi nami. ");
INSERT INTO hrw_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ma ung kaltu matmatru e baf ru kiiskiis ulo anisow e sal ma ru ka ong ini Yesus e fespaket, ru ka tau aregii, “Taufi, Sikow e Dewit, on tengis kama!” ");
INSERT INTO hrw_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ma galung kaltu a ri ka poraw ru ma ri ka peteng tif ru ini ruw fakuta e ngusngusru, safle ru tau bakir sak, “Taufi, Sikow e Dewit, on tengis kama!” ");
INSERT INTO hrw_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yesus ka tisok ma ka tau singru, “Kamu bura ini yau gow e sa lo kamu?” ");
INSERT INTO hrw_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ma ru ka koso, “Taufi, kama bur par mil.” ");
INSERT INTO hrw_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yesus e tengis ru ma ka pot lo matmatru, ma saupesak ru ka par mil ma ru ka mi nami. ");
INSERT INTO hrw_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Biing ri puek fatatu e Jerusalem ma ri ka puek ulo male Betfage ulo paklunmale Olif. Yesus ka uun ru e un disaipel kia, ");
INSERT INTO hrw_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ka war singru aregii, “Kamun la ilo male ai famu i kamu, ma saupesak kamu ku pari e dongki ri kaweufu tura sikow ina isa. Kamu ku pikufru kamu ku tatfe ru wagii. ");
INSERT INTO hrw_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Le tikas ku war sing kamu, kamuw peteng tifi aregii, ‘Taufi e bura,’ ma kaltu a ku tule saupesak iru.” ");
INSERT INTO hrw_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Mok gii e fuut una fasefu e sa profet e sau peteng ini: ");
INSERT INTO hrw_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Tau singre tongge tingna Saiyon aregii, ‘Par, king kemi gii ka puek usi gam. I e sa la are kaltu e tek ti asow, ma ka kiis ilo ampoktow e dongki. I e kiis ilo ampoktow e dongki fuu ma ka sala.’” ");
INSERT INTO hrw_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ma un disaipel ru ka la, ru ka gow aregii Yesus kabuk peteng tifru. ");
INSERT INTO hrw_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ru la ru ka la tatfeni e tinan dongki tiim tura boron sikow. Ru ka towfu e fang kolos tapak keru ulo pokpokta ru, ma Yesus ka kiis ulo poktow. ");
INSERT INTO hrw_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ma singmat na galung kaltu ri ka sosol fang kolos tapak keri ulo sal, ma fa ri ka su tetes teltelen au ri ka sosol. ");
INSERT INTO hrw_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Galung kaltu ri famu ma fa ri mi, ri tiin tautau lala aregii, “Akteni e Sikow e Dewit. Warfakausi tife se, i e puek lo asow e Taufi. Akteni e asow e Deo!” ");
INSERT INTO hrw_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Biing Yesus e kaulek una Jerusalem, tongge nano una Jerusalem ri tiin kuufsak ri ka gatom, “Kaltu gii e ta se tikin?” ");
INSERT INTO hrw_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ma tongge ri ka koso, “Yesus legii, profet tingna Nasaret ina Galili.” ");
INSERT INTO hrw_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesus e kau ulo bala balo lo Felun Nining Bakir ma ka fesel suu ire tongge nano ri umumat ma ri fifiil uwa. Ka ikis falek ire fan teibel kere tongge ri pilpiliis mani ma fanenger kere fa ri umumat fan man. ");
INSERT INTO hrw_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ma i ka war, “Ri seti aregii, ‘Kek fel riu fotngi ini fel una nining,’ safle gau bala gow ku puek are male na keskeskum singre tongge na kinkinau.” ");
INSERT INTO hrw_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Fam baf ma fa kekekri e sak ri puek usi ulo bala balo lo Felun Nining Bakir, ma i ka faliungeri. ");
INSERT INTO hrw_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Sakle biing fam pris lamlam ma fan titsa lo fafanau ri pari e konona fan mok e gow ma berberat ri ka tautau ulo bala balo lo Felun Nining Bakir aregii, “Osana tifi e Sikow e Dewit,” balbalri e la sak, ");
INSERT INTO hrw_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ma ri ka gatmo e Yesus aregii, “O ongni ming e sa anrimberat gii ri seseng ini?” Yesus ka koso aregii, “Yow! Ya sam ongni. Safle ya sang ini gam tifik wese e sunwar a, ini ‘Berberat kair ma fa ri lamlam riu akteni e asam, anwarow o sau fagati ini eu puek usi o tibom’ be?” ");
INSERT INTO hrw_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ma i ka la kosing ri tinglo siti a ka la una Betani ka la ngo uwa. ");
INSERT INTO hrw_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Lo biingbiing e mok sak, Yesus e fes ka la mil ulo siti ma ka biis. ");
INSERT INTO hrw_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","I ka pari e au fik e titi fatatu e sal ka la usi, safle e tibi la par ti mok ulo, sakle auauwu. Kala i ka war singi, “O amu tibi fira mil ming wimi.” Ma saupes tikin au fik a ka main. ");
INSERT INTO hrw_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Biing fan disaipel ri pari e mok a, ri kuufsak ma ri ka war, “Areini gii au fik leii ka su main saupe?” ");
INSERT INTO hrw_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesus ka koso, “Ya peteng tikin tif gam, le enggi mel e titinge kemi ma gamak tibi sang fa-u, e tibi ta ini le gam usu fasi una gow e sa e sau fuut lo au fik, sakle ming gam u fasi una war singe paklunmale, ‘La bas i o tibom ilo balang kasap,’ ma ku puek aregii o ka war. ");
INSERT INTO hrw_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Le o ka titinge, ou kepe e sese mok a o ka gatom usi, ilo bala nining kiam.” ");
INSERT INTO hrw_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesus e la kaulek ulo bala balo lo Felun Nining Bakir, ma biing e fafabenge, fam pris lamlam ma tongge lamlam lo re tongge ri ka puek usi, ri ka sa gatmo, “Lo sese rawas gii o ka gowgow e fan mok gii? Ma se e tow e rawas gii tifo?” ");
INSERT INTO hrw_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesus ka koso, “Yau bi gatom gam ming ine tikii gatgatom, le gam ku koso, ya kamu peteng tif gam a, ini ya gow e fan mok gii lo sese rawas. ");
INSERT INTO hrw_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Amfagu gii Jon ka gowgow, e la ting ya? Tinglo balambat tam tinglo nal?” Ri fawar usi u falifu iri tibom, ri ka war, “Le kiar ku peteng ini ‘tinglo balambat’, i eu gatom, ‘Gii ma e tamu gii gam ka tibi titinge lo?’ ");
INSERT INTO hrw_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ma le kiar ku peteng ini ‘tinglo nal,’ kerer sokere tongge, anwarow tongge, ri tiin parfat ini Jon e ta profet.” ");
INSERT INTO hrw_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ma ri ka koso e Yesus ri ka war, “Kemem tibi parfat.” Wimi Yesus ka war, “Yau ming yau tibi peteng tif gam ini sese rawas ya gowgow e fan mok gii lo.” ");
INSERT INTO hrw_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ma Yesus ka war ming singe fam pris lamlam ma tongge lamlam lo re tongge, “Are gam sang? E mel e kaltu e u e sikow. E la usi e neng baba tikii ka la war singi, ‘Sikuang geinggii o la faim ilo palang na waen.’ ");
INSERT INTO hrw_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“I ka koso, ‘Yau tibi la.’ Ma sakle wimi i ka iksi e sinangu ma ka la, ka la faim ulo palang na waen a. ");
INSERT INTO hrw_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Wimi kaltu a ka la usi sikow baba u ka la war singi aregii ka war singe neng baba tikii. I ka koso, ‘Yau la tabuung,’ sakle e am tibi la. ");
INSERT INTO hrw_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Se lo ung kaltu gii e gow e sa tamow e bura?” Ri ka koso, “Neng baba tikii.” Ma Yesus ka war singri, “Ya peteng tikin tif gam, tongge na kepkep mani ma fa tura ansinang na faet falek ri kaulek famu i gam ilo bala kepmale ke Deo. ");
INSERT INTO hrw_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Le Jon e puek usi gam una fanangsi gam ine sal lo sinang e riis, ma gam tibi titinge lo, sakle tongge na kepkep mani ma fa tura ansinang na faet falek ri titinge. Sakle wimi, biing gam sau pari e fan mok gii, gam tibi iksi e balbalmi ma gam ku titinge. ");
INSERT INTO hrw_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Gam ong lo neng e warwar toftof. E mel e neng e taman nal e so e palang na waen. E gow e balo kali, ka kefi e ampolo una musngeni e firfiran waen ku la ta waen una in. Ma ka gow e fel kiis iyat una parpar kali e palang na waen. Wimi ka uunre tongge una faim lo palang na waen ma ka la ulo fines tapak. ");
INSERT INTO hrw_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Biing fan waen ri fatfatat una pim, ka uunre tongge na mus kia use re tongge efefe lo palang na waen una la kepe e ti galu kia. ");
INSERT INTO hrw_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Tongge a ri saupesak ri ka pakti e tikii neng lo re fan tongge na mus ke kaltu a, ri ka paketmet ine neng ma ri ka rangu e neng baba e tuul ine fatfat. ");
INSERT INTO hrw_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Wimi kaltu a ka tule re fa ri fuun ire fa famu use re tongge a, ma tongge a ri ka su la gow e tikii mok lo ri. ");
INSERT INTO hrw_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Wimi sekit, ka tuleni e sikow usi ri, ma ka war, ‘Riu matlawen singe sikuang.’ ");
INSERT INTO hrw_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Biing tongge a ri pari e sikow e puek, ri ka fawar falifu iri, ri ka war, ‘Igii e sikow e kaltu bakir. Kasa kerek paketmet ini ma kerer ku kepe e fan mok kia.’ ");
INSERT INTO hrw_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ma ri ka kepe ri ka bas suu ini una male ine palang na waen ma ri ka paketmet ini. ");
INSERT INTO hrw_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Are lea, biing tamow e palang na waen eu puek sa eu gow lo tongge a?” ");
INSERT INTO hrw_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ma ri ka koso, “Eu paketmet ire tongge saksak a, ma ku tow e palang na waen tifre fa kuriik ri ku efe lo usi riu tow e ti galu kia lo fan waen le ri ku luski.” ");
INSERT INTO hrw_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ma Yesus ka war singri, “Gam tifik wese e sunwar ke Deo? ‘Fat lewa tongge parfat na bilbilse fam fel ri guuluung ini e sau puek ka ta warow e fel, Taufi e bilseni aregii ma e piik sak nan matrer.’ ");
INSERT INTO hrw_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“I ya, ya ka peteng tif gam ini, Deo eu kepe kepmale kia kosing gam ku tow tifre tongge a ri ku fafuutngeni e firfirow. ");
INSERT INTO hrw_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ma sese kaltu e luut ilo poktow e fat gii eu rages falek ini. Ma se a fat gii ka luut talo, eu bero sekit ini.” ");
INSERT INTO hrw_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Biing fam pris lamlam ma fam Farasi ri ongni fan warwar toftof ke Yesus, ri ka parfat ini e warwar lo ri. ");
INSERT INTO hrw_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ri ka sik ine ti sal una bingfamti, sakle ri soke re tongge anwarow tongge ri parfat ini Yesus e ta profet. ");
INSERT INTO hrw_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesus e war mil singri lo warwar toftof aregii: ");
INSERT INTO hrw_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Kepmale tinglo balambat e ngo aregii, neng e king e fagati e inen na tinaule ke sikow. ");
INSERT INTO hrw_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","I e unre tongge na mus kia use re fa ri sam tau iri una sa la wilo inen a, safle, ri tibi bur sala. ");
INSERT INTO hrw_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Wimi e unre fanenger fang kaltu na mus kia ma ka peteng tifri, ‘Peteng tifre fa, seri ya sam tau iri una sa la wilo inen na tinaule gii, fan tamtamatum buuluumakau ma fanenger buit ming, kemem sau paketmet iri. Ma mara mok kemem sau fagatiufu gii wa. Gam sa la wilo en na tinaule.’ ");
INSERT INTO hrw_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Safle ri tibi bur ong, ma ri ka su fes falek. Nenge la wilo ke palang, ma neng e la wilo faim mani kia. ");
INSERT INTO hrw_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Safle fanenger ri bingfamti re fang kaltu na mus ke king, ma ri ka paket saksak iri ma ri kau fismet iri. ");
INSERT INTO hrw_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Aregii king e balasak tibom. Ma i ka unre fan soldia kia, ri ka la paketmet ire tongge a ri ka paketmet ire tongge na mus kia. Ma ri kam taiif lo siti keri. ");
INSERT INTO hrw_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Wimi king kau peteng tifre tongge na mus kia aregii, ‘Inen na tinaule ri sau fagatiufu, safle tongge ya tau iri una sala, ri tibi ta konona tongge ri fasi una sa la wilo inen gii. ");
INSERT INTO hrw_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Aregii gam samusu la ilo fan sal tongge ri fuun ilo, ma seri a gam ka pari, gam tau iri una sa la lo en.’ ");
INSERT INTO hrw_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Aiya tongge na mus kia ri ka la falek ulo fan mara galgalun sal, ma kep tiim ire tongge ri fasi una tupngeri. Fa ri kausi ma fa ri sak. Fel na tinaule a e fuun ire tongge ri uun puek iri. ");
INSERT INTO hrw_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Safle biing king e kaulek una la pari e tongge ri sam uun puek iri, i e pari e tikii kaltu uwa e tek ti kolos na tinaule ulo. ");
INSERT INTO hrw_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ma i ka war singi, ‘Fenngong, are o kau ma ka tek ti kolos na tinaule ailo o?’ Safle kaltu a e tibi koso. ");
INSERT INTO hrw_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Aregii king ka peteng tifre tongge na mus kia, ‘Reke e un limow ma ung kekow, ma basuu ini una male wilo mok e or. Iya ri ku tengteng ma ri ku ngungutfat ilo.’ ");
INSERT INTO hrw_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Le Deo e tau ire tongge fuunfuun, safle e su puis i e wel ri.” ");
INSERT INTO hrw_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Kala fam Farasi ri ka suu ri ka la sik ine ti sal una sormo e Yesus usi eu gow e ti sunwar e tibi riis, ma ri ku anganggon singi lo. ");
INSERT INTO hrw_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ri uun ri e fan disaipel keri usi, tura fa ri ti inami e King Erot. Ma ri ka war singi aregii, “Titsa, kemeu parfat ini o riis tikin, ma o fabenge ine sal ke Deo ususi e mok e tikin. O tibi se singe tikas anwarow o tibi sang usi ri nase ri. ");
INSERT INTO hrw_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Peteng tif kemem gii, sese sangsang kiam. E riis una bas mani tife Sisa, tam e tam?” ");
INSERT INTO hrw_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Safle Yesus e sau parfat lo sangsang saksak keri, ma ka war, “Gam na tongge na matang pangkii! Anwarow lo sa gii gam ka bala sorom i yau? ");
INSERT INTO hrw_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Fanangsi yau ine ti mani gam sagisu felfeli e takiis ini.” Ma ri ka kepe e tikii mani ma ri ka tow tifi. ");
INSERT INTO hrw_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ma i ka gatom ri, “Panta ma as gii lo e ta ke se?” ");
INSERT INTO hrw_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ma ri ka koso, “Ke Sisa.” Ma i ka war singri aregii, “Sa ke Sisa, gam tow tife Sisa. Ma sa ke Deo, gam tow tife Deo.” ");
INSERT INTO hrw_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Biing ri ongni e sunwar kia, ri la kuufsak ma ri ka tii kosngi, ri ka la. ");
INSERT INTO hrw_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Lo tikii biing a, fan Sediusi, seri peteng ini e tek ti matmatet mil, ri ka puek usi tura neng e gatgatom aregii, ");
INSERT INTO hrw_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Titsa, Moses e peteng tif kemem ini, le kaltu ka met ma ka tek ti siksikow, tualik e samusu tili mil e wok a i ka met kosngi, ma ku fafuutngeni e siksikow e tualik. ");
INSERT INTO hrw_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Aregii e mel e baba fis na fatfatualik ri melmel falifu lo kemem. Neng baba tikii e tinaule ma ka met, safle e tek ti sikow. Aregii tualik kam tili e wok kia. ");
INSERT INTO hrw_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","E su tikii mok e fuut lo neng baba e u ma neng baba e tuul, ka la muut lo neng baba e fis. ");
INSERT INTO hrw_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ma wok a kam la met wimi sekit. ");
INSERT INTO hrw_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Gii ou peteng, lo biing na matet mil singre tongge a, eu ta wok ke se sekit lo ri?” ");
INSERT INTO hrw_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesus e koso aregii, “Gam sam tubiil, anwarow gam tibi parfat lo sunwar ma rawas ke Deo. ");
INSERT INTO hrw_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Lo biing tongge ri met ma ri ka matet mil, riu tibi tinaule. Riu su ngo are fan anggelo ilo balambat. ");
INSERT INTO hrw_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Sakle lo biing na matmatet mil kere fan minet, gam tifik wese e sa Deo e peteng ini tif gam? ");
INSERT INTO hrw_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Ya ta Deo ke Abra-am, Deo ke Aisak, ma Deo ke Jekop.’ I e tibi ta Deo kere tongge ri met, e tam. Safle i e ta Deo kere tongge ri liuliu.” ");
INSERT INTO hrw_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Biing galung kaltu a ri ongni e sunwar kia, ri kuufsak lo fabenge kia. ");
INSERT INTO hrw_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Fam Farasi ri kep tiim iri lo biing ri ong ini Yesus e fakuta e ngusngusre fan Sediusi. ");
INSERT INTO hrw_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ma neng lo ri e ta kaltu parfat tikin lo fafanau, i e bala tofo e Yesus ine gatgatom gii: ");
INSERT INTO hrw_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Titsa! Sese fafanau e bakir sak iyat ine fan mara fafanau nano?” ");
INSERT INTO hrw_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ma Yesus ka koso singi aregii, “‘Bura e Taufi se e ta Deo kemi, tura balbalmi kiruur, ma tura tangtangwami ma sinsinangumi nano.’ ");
INSERT INTO hrw_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Fafanau gii e ta fafanau baba tikii ma e bakir iyat ine mara fafanau nano. ");
INSERT INTO hrw_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ma fafanau baba e u e ngo are fafanau baba tikii, ‘Bura e neng aregii o ka buro tibom.’ ");
INSERT INTO hrw_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Um fafanau gii ru ta anwarow e fan mara fafanau nano ma fan warwar kere fam profet.” ");
INSERT INTO hrw_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Fam Farasi ri tiimtiim lo ri uwa, Yesus ka gatom ri aregii, ");
INSERT INTO hrw_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Are gam sang lo Kristus? I e ta sikow e se tikin?” Ma ri ka koso, “Sikow e Dewit.” ");
INSERT INTO hrw_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ma ka war singri aregii, “Areini gii Tangwa Riis ka tow e sangsang tife Dewit ka fotngi ini Taufi? Dewit e war aregii, ");
INSERT INTO hrw_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Taufi e peteng tife Taufi kiang aregii, “Kiis wagii lo galu miil lo yau ku muut yau tauf re fa ri is o ilo pikliu e rawas kiam.” ’ ");
INSERT INTO hrw_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Le Dewit kabuk fotngi ini Taufi, ma areini gii, i ku ta sikow?” ");
INSERT INTO hrw_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","E tek tikas ek war ine ti sunwar una koso. Ma tinglo biing a ka la, ri soke unam gatmo ming ine ti gatgatom. ");
INSERT INTO hrw_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Wimi Yesus ka war singre tongge ma fan disaipel kia, ");
INSERT INTO hrw_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Fan titsa lo fafanau ma fam Farasi ri kep tafu e Moses una sesesngeni e fam fafanau kia. ");
INSERT INTO hrw_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Gam samusu ong singri ma gam ku gow e fan mara mok ri peteng tif gam ini. Sakle gam u tibi gow e fan mok ri gowgow, anwarow ri tibi ususi e fan warwar ri sesesngeni. ");
INSERT INTO hrw_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ri kawe fan mok mafet ri ka tatauf ilo paspasware tongge. Sakle ri tibom ri tibi bura sekit una faules lo fan mok mafet a. ");
INSERT INTO hrw_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Mara mok ri gow, ri su gow ini tongge ri ku pari: Ri los lo fan malmal lamlam una nining singri, ma ri ka kakawe fan susung kael tapak ilo isisow e fang kolos tapak keri. ");
INSERT INTO hrw_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Lo fam biing en bakir ri bura ini riu kiiskiis ilo fan sia baba tikii, ma fan sia kere ge lamlam ilo bala fam felun nining. ");
INSERT INTO hrw_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ri bura sak ini riu arare ri ilo fan male na fafapiik, ma tongge ri ku fotfoteng ri ini fan Rabai. ");
INSERT INTO hrw_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Sakle gam, riu tibi foteng gam ini fan titsa, anwarow e su tikii titsa kemi, ma gam nano, gam ta fatfatualik. ");
INSERT INTO hrw_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ma gam u tibi fotngi e tikas gii lo nal ini ‘tabuung’, anwarow e su tikii Taumi, ma i ilo balambat. ");
INSERT INTO hrw_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Riu tibi foteng gau ming ini kaltu na fafanas, le anwarow e su tikii kaltu na fafanas kemi, i gii Kristus. ");
INSERT INTO hrw_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Se a ka famfamu i gam e samusu fespuek ku ta kaltu na faules kemi. ");
INSERT INTO hrw_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Safle se a ka resngeni e asow, Deo eu faporo e asow. Ma se a ka faporo e asow, Deo eu akteni e asow. ");
INSERT INTO hrw_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","“Kiskam sing gam na fan titsa lo fafanau ma fam Farasi, kemi na tongge na matam pangkii. Gam dukli e matangkon lo kepmale tinglo balambat ilo matmatre tongge. Gam tibom gam tibi kaulek ilo, sakle gam su ti kalere tongge ri bur kaulek ilo. ");
INSERT INTO hrw_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Kiskam sing gam na fan titsa lo fafanau ma fam Farasi, gam na tongge na matam pangkii. Gau fes fawet ilo nal ma balang kasap una su kulfi e tikii kaltu. Ma biing kabuk la ta kemi, gam kabuk gow a ku la ta kaltu una la ilo bala iif e tibi fasi una met ma fan tubiil kia ku la ta iyat i gam tibom. ");
INSERT INTO hrw_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Kiskam sing gam na fan titsa lo fafanau ma fam Farasi, gam na fam baf na fafanas, gau peteng ini ‘le tikas ku limlim ine Felun Nining Bakir, e tek ti bala. Sakle tikas ku limlim ine gol ilo Felun Nining Bakir, e samusu gorot aregii i ka peteng.’ ");
INSERT INTO hrw_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Gam na fam baf lomba. Sa e bakir, gol tam Felun Nining Bakir a ka pete tarawen ine gol a? ");
INSERT INTO hrw_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Gau peteng ming aregii, ‘le tikas ku limlim ine altar, e tek ti bala. Sakle tikas ku limlim ine finafen ilo altar, e samusu fafonsi e sa i e peteng ini.’ ");
INSERT INTO hrw_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Gau baf! Sa e bakir, finafen tam altar a ka pete tarawen e finafen a? ");
INSERT INTO hrw_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","I ya, se a ka limlim ine altar i e limlim ine altar ma mara mok ailo poktow. ");
INSERT INTO hrw_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ma se a ka limlim ine Felun Nining Bakir, i e limlim ine Felun Nining Bakir ma se a ka mel ilo. ");
INSERT INTO hrw_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ma se a ka limlim ine balambat, e limlim ine sia king ke Deo ma se a ka kiiskiis ailo. ");
INSERT INTO hrw_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Kiskam sing gam na fan titsa lo fafanau ma fam Farasi, gam na tongge na matam pangkii. Fan mara iririn mok tinglo fam palang kemi una gowgow e fan tuan ku nul kausi, kemi wese ka tikii sangful na amfor, ma gam ka towtow e tikii amfor tife Deo. Sakle gam ta pokpoktami tife fan susu lamlam lo fafanau, are sunwar lo konona melmel una ikse re tongge, fatengis ma sinang na titinge. E kausi ini gam u rawas una usi e fam fafanau lamlam gii, ma gam ku tibi sangintafngi e fanenger fam fafanau ming. ");
INSERT INTO hrw_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Gam na fam baf na fafanas. Gam ngo are kaltu e tii ine anmengmeng tinglo danun tuan aiya, ma ka tibi parfat ma ka inmi e danun tuan a ka kemi tura kamel. ");
INSERT INTO hrw_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Kiskam sing gam na fan titsa lo fafanau ma fam Farasi, gam na tongge na matam pangkii. Gam su gua e pokpoktow e fang kap ma fan dis. Sakle ilo balbalmi e fuunuf ine sinang na angkoko ma sangsang bakir usi gam tibom. ");
INSERT INTO hrw_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","O na Farasi, o baf, gam u bi gua famu e balbalre fang kap ma fan dis. Ma wimi pokpoktow kamu fuu. ");
INSERT INTO hrw_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Kiskam sing gam na fan titsa lo fafanau ma fam Farasi, gam na tongge na matam pangkii, gam ngo are balang kenit ri fapeteni ine panta murmur, ka par kausi sak ina male. Sakle ilo bala e fuunuf ine tutuang kaltu ma mara mok e du. ");
INSERT INTO hrw_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ilo tikii sal, gau par riis sak ina male na matre tongge, sakle ilo balbalmi e fuunuf ine sinang na gurum ma keker fam fafanau. ");
INSERT INTO hrw_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Kiskam sing gam na fan titsa lo fafanau ma fam Farasi, gam na tongge na matam pangkii. Gau bilse fan matmat kere fam profet, ma gam ka fasfaswenu e fan matmat kere tongge riis. ");
INSERT INTO hrw_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ma gam ka peteng ini, ‘le kemeng gi melmel lo biing kere tumtumlamem, kemeng gi tibi fasi una ules ri una paketmet ire fam profet.’ ");
INSERT INTO hrw_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","I ya gam ka bou peteng suupuek i gam ini gam na ge lo re tongge nangen a ri ka paketre fam profet. ");
INSERT INTO hrw_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Arik, gam la, gam ku la fawetu e sinang gii tumtumlami ri ka gowgow nangen. ");
INSERT INTO hrw_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Gam na fan sii, are gam u ifit ine anganggon ke Deo? Deo eu anganggon sing gam ma ku tauf gam ilo iif e tibi fasi una met. ");
INSERT INTO hrw_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","I ya, ya ka tule re fam profet, tongge parfat ma fan titsa usi gam. Fa lo ri gam u paketmeteri ma fa gam ku tutfamfamti ri ilo fan aupaket. Fa gam u wesbis lo ri ilo bala fam felun nining kemi ma gam ku kalaferi ma fesel ri tinglo neng e taon ku la ilo neng e taon. ");
INSERT INTO hrw_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ma gii mafet kere tongge lo gam nangen, ri paketmet ire tongge riis, eu la ilo pokpoktami. Tofnge tinglo kaltu riis Abel ka la muut ilo Jekaraiya, sikow tamat e Berekaiya, lewa gam ka paketmet ini ulo falifu lo Felun Nining Bakir ma altar. ");
INSERT INTO hrw_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ya peteng tikin tif gam, mara mok gii eu luut ilo pokpokta re kulu gii. ");
INSERT INTO hrw_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Jerusalem, Jerusalem, o paketmet ire fam profet ma o ka siisiimetmet ire fa Deo e tultule ri usi o ine fatfat. Ya sagisu sang ini yau keptiim ire keu berat are ponga porot e keptiim ire siksikow ilo pikliu e um papa-u, sakle gam tibom gam tibi bura. ");
INSERT INTO hrw_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Par, siti kemi e ngo fofoes. ");
INSERT INTO hrw_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ma ya peteng tif gam, gam tibi fasi una par yau mil ku muut gam u war ini, ‘Warfakausi tifi e se, i e puek lo asow e Taufi.’” ");
INSERT INTO hrw_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesus e la kosnge Felun Nining Bakir ma ka fes ka la. Biing fan disaipel kia ri puek usi, ma ri ka fanangsi ine fam mara susu lo Felun Nining Bakir, ");
INSERT INTO hrw_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Yesus ka gatom ri, “Gam sau pari e fan mara mok gii? Ya peteng tikin tif gam, eu tek ti fu lo fatfat gii eu la ngosok ilo poktow e ti neng e fu. Riu rarang pu iri nano.” ");
INSERT INTO hrw_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Biing Yesus e kiiskiis uwa ulo paklunmale Olif, fan disaipel kia ri ka puek usi ri ka sa war borong singi, “Peteng tif kemem ini nangis fan mok gii eu fuut, ma sa eu ta tintof lo milmil kiam ma lo biing muut?” ");
INSERT INTO hrw_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesus ka koso, “Gam sangsangfi are tikas ka sorom gam. ");
INSERT INTO hrw_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Fa fuunfuun riu puek lo asang ma ri ku peteng ini, ‘Yau gii Kristus’ ma ri ku gurum ire fa fuunfuun. ");
INSERT INTO hrw_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Gam u ongni e fan sinseng lo tuui ma fan warwar lo, sakle gam u ate, gam u tibi kuufsak gam ku soke. Fan mara mok gii e sau bala puek, safle biing muut e amu puek. ");
INSERT INTO hrw_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Nenge male eu fapaket tura neng e male, ma neng e matambia eu fapaket tura neng e matambia, ma anggi ilo fanenger fan male ma biis faen. ");
INSERT INTO hrw_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Fan mok gii eu suupuek famu ini are fefin e ongker una fasus. ");
INSERT INTO hrw_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Wimi riu tebek gam ma ri ku touf gam una kepe mafet, ma ri ku touf gam una met. Tongge tinglo mara male riu sak lo gam, anwarow lo yau. ");
INSERT INTO hrw_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Lo biing a titinge kere fa fuunfuun eu luut, ri ku la solamufre fa, ma ri ku sak lo ri. ");
INSERT INTO hrw_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ma fam profet gurgurum riu puek, ri ku sorom ire tongge fuunfuun. ");
INSERT INTO hrw_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ma sinang saksak ku fespuek bakir, i ya tongge ri ku la kosnge sinang na fabur. ");
INSERT INTO hrw_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Sakle seri a, ri ku ti rawas ku muut lo biing muut, Deo eu faliungeri. ");
INSERT INTO hrw_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ma ri ku sesngeni e konona sunwar lo kepmale ke Deo tife nal nano, usi tongge riu ongni ma biing muut kamu fespuek. ");
INSERT INTO hrw_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“I ya, biing gam u pari e ‘mok saksak sekit a una bero ine male’ lewa profet Deniel ka war lo, eu puek ku titi ilo male tarawen, (Kaltu e wese sunwar gii e samusu ten usi,) ");
INSERT INTO hrw_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","tongge ri melmel ina Judia ri samusu fin ri ku la ilo fam pakpaklunmale. ");
INSERT INTO hrw_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Le kaltu ka ta iyat ilo poktow e fel, e mu tibi pu una kepe ti mok tinglo bala ke fel. ");
INSERT INTO hrw_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ma neng ilo bala palang, eu tibi mil una sa kepe kolos. ");
INSERT INTO hrw_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Kiskam singre gelefin tian ma tintinabo-i siksikwari ri liklik iwa, are riu gorot lo biing a? ");
INSERT INTO hrw_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Gam samusu nining usi gam u tibi fin lo biing lo anmair, tam lo biing Sabat. ");
INSERT INTO hrw_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Le lo biing a, eu mel e singmat na mafet. Eu bakir iyat ini mara mafet e sau puek famu ma iyat ming ine sese mafet e mu puek wimi. ");
INSERT INTO hrw_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Le Deo enggi tibi faposposo e fam biing a, enggi tek tikas enggi liu. Safle anwarow lo re tongge a i ka wel ri, i eu faposposo e fam biing a. ");
INSERT INTO hrw_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Lo biing a le tikas ku peteng tif gam aregii, ‘Par, igii e Kristus!’ Tam, ‘I leii!’ Gam u tibi titinge singi. ");
INSERT INTO hrw_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Anwarow fang kristus gurgurum ma fam profet gurgurum, riu fespuek ri ku gow e fan mok na tibou fuut ma fanenger fan mok ming una sorom ire tongge Deo e wel ri, le ku fasi. ");
INSERT INTO hrw_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ong! Ya sau peteng tif gam ine fan mara mok gii, famu ma kamu fespuek. ");
INSERT INTO hrw_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Aregii le ri ku peteng tif gam, ‘Par, i e melmel ilo male e tek tikas ilo,’ gam amu tibi la ilo mok a. Male ri ku peteng, ‘Par, i e melmel ilo bala fel a,’ gam u tibi titinge lo fan warwar keri. ");
INSERT INTO hrw_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Le milmil ke Sikow e Kaltu eu puek malal are ampil a ka piltuut paket ilo batsok kiruur tinglo ngusu i weng ku la ilo ngusu i sif. ");
INSERT INTO hrw_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ma ming, eu puek malal are ilo sese male punumfow e ti kaltu e sau met e ngongo ilo. Le male a, fan talaman ri kep tiim iri ilo. ");
INSERT INTO hrw_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Saupesak wimi ine mafet bakir lo fam biing a, ‘eu or e mata e pisii ma funiil e mu tibi pal. Fang keltot tinglo batsok riu luut ma fan rawas tinglo batsok riu ban.’ ");
INSERT INTO hrw_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Lo biing a, tintof lo Sikow e Kaltu, eu puek ilo batsok ma fan mara male nano ilo nal riu sangkuuluung. Ma ri ku pari e Sikow e Kaltu eu fespuek ilo aumbalbal tinglo balambat tura rawas ma singmat na finaswen. ");
INSERT INTO hrw_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ma i ku tuleni e fan anggelo kia ine duungow e ampung. Ma ri ku keptiim ire tongge e sam wel ri kia tinglo mara male nano gii lo nal, ma tinglo ngusu e balambat ku la rop ilo neng e ngusu. ");
INSERT INTO hrw_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Gam samusu kepe parfat lo au fik, biing e arwan ma ka dur, gam sau parfat ini biing lo konona pisii e sau bala puek. ");
INSERT INTO hrw_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","I lea, le gam ku pari e fan mara mok gii eu puek, gam samusu parfat ini Sikow e Kaltu e sau fatat sekit ailo matangkon. ");
INSERT INTO hrw_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ya peteng tif gam, kulu gii riu tifik famete ma fan mara mok gii ku fuut. ");
INSERT INTO hrw_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Batsok ma nal eu tam iru, sakle sunwar kiang eu tibi fasi sekit una tam ini. ");
INSERT INTO hrw_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“E tek tikas e parfat lo biing, tam lo anmatam pisii. Fan anggelo ilo balambat ming tam aiya Sikow ri tibi parfat, sakle Tamow tibom e parfat. ");
INSERT INTO hrw_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Biing una mil singe Sikow e Kaltu e su ngo are lewa lo biing ke Noa, male e fuun. ");
INSERT INTO hrw_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Le lo biing famu ine male e fuun tongge ri ininin ma enenen, antamat ma gelefin ri tintinaule, ka la muut lo biing, Noa e kaulek ulo sip. ");
INSERT INTO hrw_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Sakle ri tibi parfailmi e sa eu fespuek, ka muut lo male e fuun ka tafing ri nano. Eu ngo aiya ming lo biing Sikow e Kaltu eu puek. ");
INSERT INTO hrw_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Lo biing a e u e kaltu ruw faim ilo bala palang, ma Deo ku kepe e neng lo ru ku la, ma ku touf sok lo neng. ");
INSERT INTO hrw_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","E u e fefin ruw sese firfiran wit wilo falawa ma Deo ku kepe e neng lo ru ku la, ma ku touf sok lo neng. ");
INSERT INTO hrw_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Gam u ate anwarow, gam tibi parfat lo biing Taufi kemi eu puek lo. ");
INSERT INTO hrw_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Gam u ten aregii, le kaltu ine ke fel enggi sau parfat lo sese anmatam pisii lo panambiing, kaltu na kinkinau eu puek, i eu efe ma ku tibi fasi una towfu e ke fel, ri ku ipki ma ri ku kau. ");
INSERT INTO hrw_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Aregii gam samusu melmel ma terer, Sikow e Kaltu eu puek lo biing, gam tibi sangfi ini eu puek lo. ");
INSERT INTO hrw_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Se a ka ta konona kaltu na mus tikin, ma ka ta kaltu parfat tikin una faules, i, kaltu bakir eu towfu una efe lo tongge na mus ilo fel kia. Ma una fenfen ri lo fam biing riis na enen. ");
INSERT INTO hrw_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Eu kausi singe kaltu na mus, le kaltu bakir kia eu mil ku pari ini i e musngeni e fan mus e towfu tifi. ");
INSERT INTO hrw_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ya peteng tikin tif gam, kaltu bakir eu towfu e kaltu na mus a una efe lo fan mara mok kia. ");
INSERT INTO hrw_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Sakle, le kaltu na mus a ku ta kaltu saksak, ma ka su sang ailo bala tibom aregii, ‘Kaltu bakir kiang e tibi fasi una mil saupe,’ ");
INSERT INTO hrw_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ma ka tofnge una paketre fan taltalu, ma ka en ma ka in tura re tongge na inin, ");
INSERT INTO hrw_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","kaltu bakir ke kaltu na mus a, eu puek lo ti biing kaltu na mus kia e tibi sangfi ini eu puek lo, ma lo anmatam pisii e ti ate usi. ");
INSERT INTO hrw_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ma usi, kaltu bakir e bero sekit ine kaltu na mus kia, ma i ku tuleni ku melmel tura tongge na matam pangkii ilo male a ri ku tengteng saksak ma ri ku ngungutfat. ");
INSERT INTO hrw_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Lo biing a, kepmale tinglo balambat eu ngo are tikii sangful na polsom, ri kepe fan lam keri ma ri ka la una tongtong ine kaltu e tinaule fuu. ");
INSERT INTO hrw_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Baba lim lo re gelefin a, ri lomba, ma baba lim ri sinangu mel. ");
INSERT INTO hrw_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Fa lomba a, ri kep puek ine fan lam keri, sakle ri tibi kep ti wel tura. ");
INSERT INTO hrw_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Sakle fa a ri ka sinangu mel ri utfi e fan wel ulo fam botol, ri ka puek tura. ");
INSERT INTO hrw_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Kaltu na tinaule fuu a e tibi puek saupe, gii gelefin a ri ka la masmasun e matmatri, ri ka masun. ");
INSERT INTO hrw_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Ma lo panambiing bakir ri ka ongni e neng e kaltu e tau, ‘Kaltu na tinaule fuu i ya ka puek, gam kasa kerer ku tongtong ini.’ ");
INSERT INTO hrw_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Ma fum polsom a ri ka matet ri ka tererngeni e fan lam keri. ");
INSERT INTO hrw_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Fa lomba a, ri ka peteng tifre fa sinangu mel a, aregii, ‘Gam tow e ton rin wel kemem wilo fan lam kemem ri bala met.’ ");
INSERT INTO hrw_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Sakle fa sinangu mel a, ri koso aregii, ‘Wel gii e tibi fasi lo kerer nano. E kausi ini gam u la ilo ti sto gam ku la feli e ti wel kemi tibom.’ ");
INSERT INTO hrw_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Sakle biing baba lim na fefin lomba a, ri fesfes lala ulo sal una la fifiil fan wel, kaltu na tinaule fuu a e sa fespuek. Ma gelefin sinangu mel a ri ka kau tiim tura ulo en bakir na tinaule, ma ri ka dukli e matangkon. ");
INSERT INTO hrw_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Wimi gelefin lomba a ri ka puek ri ka sa war, ‘Kaltu bakir! Kaltu bakir! Ipki e matangkon fasap kemem!’ ");
INSERT INTO hrw_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Sakle e koso singri aregii, ‘Ya peteng tikin tif gam, ya tibi parfat lo gam.’” ");
INSERT INTO hrw_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Yesus kam war a, “Melmel ma gam ku ate, anwarow gam tibi parfat lo biing ma anmatam pisii Sikow e Kaltu eu puek.” ");
INSERT INTO hrw_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Yesus ka peteng ming aregii, “Kepmale tinglo balambat e ngo are kaltu e rong una gow e fines wilo male i tapak. I ka tau ine tongge na mus kia, ma ka tow e fan mok kia tifri ini ri ku efe lo. ");
INSERT INTO hrw_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ususi e melmel ma rawas ke tikii neng, tikii neng lo ri, i e tow e lim e mar na mani tife neng baba tikii, ka tow e u e mar na mani tifi e neng baba e u ma ka tow e tikii mar tife neng baba e tuul. Wimi kam gow e fines kia. ");
INSERT INTO hrw_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Biing kaltu a e la, kaltu a ka kepe baba lim na mar a, e saupesak ka musngeni ka la fafuutngeni e neng e baba lim na mar na mani ming. ");
INSERT INTO hrw_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Lo tikii sal, neng ming a ka kepe e u e mar na mani e musngeni ka la fafuutngeni e u e mar na mani ming. ");
INSERT INTO hrw_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Sakle kaltu a ka kepe tikii mar na mani e su la ka la kefi e ampolo ka la ofo e mani ke kaltu bakir kia ulo. ");
INSERT INTO hrw_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“E sam la tapak e biing ma kaltu bakir kere tongge na mus a ka mil, ma ka bura ini eu fariisu e sunwar lo fan mani e totouf tifri. ");
INSERT INTO hrw_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ma kaltu a ka kepe e baba lim na mar na mani, e puek tura neng e baba lim na mar ming ma ka sa war, ‘Kaltu bakir, o tow e baba lim na mar tif yau. Par, ya la musngeni ka la fespuek e neng e baba lim na mar na mani ming.’ ");
INSERT INTO hrw_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Ma kaltu bakir a ka peteng tifi aregii, ‘O na konona kaltu na mus, o efefe kausi lo fam faim kiam, o kabuk gow e konona faim. O sam efe kausi lo fan iririn mok, iya, ya ka bura ini ow efe lo fan mok fuunfuun. Kasa o ku gasgas tura yau.’ ");
INSERT INTO hrw_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Ma kaltu a ka kepe e baba u na mar na mani, e puek tura neng e baba u na mar ming ma ka sa war, ‘Kaltu bakir, o tow e u e mar tif yau. Par, ya la musngeni ka la fespuek e neng e baba u na mar na mani ming.’ ");
INSERT INTO hrw_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Ma kaltu bakir kia ka war singi ming aregii, ‘O na konona kaltu na mus, o efefe kausi lo fam faim kiam, o kabuk gow e konona faim. O sam efe kausi lo fan iririn mok, iya, ya ka bura ini ow efe lo fan mok fuunfuun. Kasa o ku gasgas tura yau.’ ");
INSERT INTO hrw_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Wimi kaltu a ka kepe tikii mar na mani ka puek ma ka sa war, ‘Kaltu bakir ya parfat ini o na kaltu na fafaporau, o fitfitiil tinglo fam palang tongge kuriik ri umeni, ma o ka selsele fan tuan tinglo nal tongge kuriik ri sabel ine fan ume ilo. ");
INSERT INTO hrw_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","I ya, ya ka soke, ya ka la finufu e keu mani ulo bala nal. Par, i gii e sa kiam ya kepe.’ ");
INSERT INTO hrw_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Sakle kaltu bakir kia ka war, ‘O na kaltu na mus saksak, o dol sak. Le o ka parfat ini ya fitfitiil tinglo fam palang tongge kuriik ri umumeni, ma ya ka selsele fan tuan tinglo nal tongge kuriik ri sabel ine fan ume ilo, ");
INSERT INTO hrw_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ma usi e tamu o ka tibi towfu e kek mani ulo beng? Usi biing yau mil, eu fasi ini yau sa kepe mil e kek mani tiim tura ton neng ming ilo poktow. ");
INSERT INTO hrw_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Gam kepufu e mani a singi, gam ku tow tife kaltu a tura tikii sangful na mar na mani.’ ");
INSERT INTO hrw_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","“Anwarow se a kabuk mel e fan mok keri, yau tow e ton mok ming tifri usi i eu mel e fan mok fuunfuun kia. Sakle neng a ka tek ti mok kia, boron sa a i ka mel lo, yau kepufu singi. ");
INSERT INTO hrw_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ma kaltu na mus saksak gii, gau bas suu ini ku la ilo male or. Ilo male a ri ku tengteng saksak ma ri ku ngungut fat.” ");
INSERT INTO hrw_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Yesus ka peteng aregii, “Biing Sikow e Kaltu eu puek are King tura fan anggelo, i eu kiis ilo sia king kia, e fuunuf ine finaswen. ");
INSERT INTO hrw_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Fan mara male riu tiim lo ri i famu ini, ma ku ti iri, tikii neng, tikii neng. Are efefe lo fan sipsip e ti ire fan sipsip kosnge fan meme. ");
INSERT INTO hrw_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","I eu tauf re fan sipsip ilo galu miil, ma ku tauf re fan meme ilo galu kais. ");
INSERT INTO hrw_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Wimi King ku war singre fa ilo galu miil, ‘Kasa gam na fa Tabuung e warfakausi gam. Gam sa kepe kepmale Tabuung e sam terngeni kemi, lo biing i e bilseni e nal. ");
INSERT INTO hrw_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Le famu ya biis, ma gam ka tow e tuan aiyang. Ya met dan, ma gam ka tow e dan una in sing yau. Ya na kaltu tinglo neng e male, ma gam ka uun yau wilo bala fel kemi. ");
INSERT INTO hrw_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","E tek kek ti kolos, ma gam ka tow e kolos kiang. Ya mase, ma gam ka sa ules yau. Yau ulo felun rerek, ma gam ka sa par yau.’ ");
INSERT INTO hrw_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Ma tongge riis ri ku koso singi aregii, ‘Taufi, sese biing kemeu paro o biis, ma kemem ka sa fen o, tam o met dan ma kemem ka tow e dan una in sing o? ");
INSERT INTO hrw_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Nangis kemeu par o ini o tinglo neng e male, ma kemem ka uun kaulek i o, tam o bura e ti kolos ma kemem ka tow tifo? ");
INSERT INTO hrw_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Nangis kemeu par o ini o mase, tam o ulo felun rekrek, ma kemem ka la par o?’ ");
INSERT INTO hrw_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Ma king ku koso e sunwar keri aregii, ‘Ya peteng tikin tif gam, sese mok gam gow lo neng lo re tanga tuaklik a, ri ka sasngal sak, gam gow lo yau.’ ");
INSERT INTO hrw_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Ma ku war singre fa ilo galu kais kia, ‘Gam na tongge Deo e sau peteng ini gam u kepe mafet, gam tii kosing yau, gam ku la ilo iif e tibi fasu una met. Iif ri terngeufu ke Satan ma fan anggelo kia. ");
INSERT INTO hrw_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Anwarow, biing ya biis, gam tibi tow e ti mok tif yau, ya ku en, ya met dan, gam tibi tow e ti mok tif yau, ya ku in. ");
INSERT INTO hrw_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ya na kaltu ting tapak, gam tibi uun kau i yau ulo fam fel kemi. E tek ti kolos kiang, ma gam tibi tow e ti kolos kiang. Ya mase, ma yau ulo rerek, ma gam tibi efe lo yau.’ ");
INSERT INTO hrw_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Ma ri ku koso, ‘Taufi, sese biing kemeu paro o biis, tam o met dan, tam o na kaltu ting tapak, tam o sasngal lo kolos, tam o mase, tam o ulo rerek, ma kemem ka tibi ules o?’ ");
INSERT INTO hrw_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“I ku koso, ‘Ya peteng tikin tif gam, sese mok gam tibi gow lo re fa a ri ka sasngal sak, gam tibi gow lo yau.’ ");
INSERT INTO hrw_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Wimi ri ku kepe fimfiil na ongker bingne bingne, sakle fa kausi ri ku kepe ninliu bingne bingne.” ");
INSERT INTO hrw_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Biing Yesus e sam seseng tikii ine fan mara mok nano gii, i e war singe fan disaipel kia. ");
INSERT INTO hrw_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Aregii gam ka parfat, e su u e biing aiwa, famu ine En na Kepsiliwi, ma Sikow e Kaltu ri ku fafen ini una tutfamti ilo aupaket.” ");
INSERT INTO hrw_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Fam pris lamlam ma ge lamlam lo re tongge, ri tiim ulo fel bakir ke paklure fam pris ri fotngi ini Kaiyafas, ");
INSERT INTO hrw_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ri ka fagati e anggurum keri una bingfamti e Yesus ma ri ku paketmet ini. ");
INSERT INTO hrw_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Sakle ri am la fawar aregii, “Eu tibi ta lo En bakir a, are ka mel e ti fagorot bakir falifu ire tongge.” ");
INSERT INTO hrw_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Biing Yesus uwa una Betani ulo fel ke Saimon, e ta kaltu lepra famu, ");
INSERT INTO hrw_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","neng e fefin ka puek talo tura botol ri gow lo alabasta ine sanda e kanek tikin e mata ulo bala, ka sa toto talo paklu e Yesus lo biing e kiiskiis ulo fate. ");
INSERT INTO hrw_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Biing fan disaipel kia ri pari e mok a e fuut, ri la balasak, ma ri fawar falifu iri tibom, “Use tamu ka bero fofoes ine mok gii? ");
INSERT INTO hrw_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Sanda gii e fasi ini enggi umat ini lo singmat na fimfiil, ma ek tow e mani tifre fan sasngal.” ");
INSERT INTO hrw_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yesus e parfat lo sa e fuut una balri ma ka war singri, “Gau mele gow e ti mok lo fefin gii. I e sam gow e konona mok lo yau. ");
INSERT INTO hrw_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Bingne tongge sasngal riu melmel tura gam, sakle yau tibi melmel bingne tura gam. ");
INSERT INTO hrw_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Biing e toto e sanda gii talo fong, i e terngeuf yau, ma ri kamu of yau. ");
INSERT INTO hrw_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ya peteng tikin tif gam, ilo sese male a, gii lo nal ri ka sesngeni e konona sunwar, sa fefin gii e sam gow, riu seseng ming ini una sangsangfi.” ");
INSERT INTO hrw_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Wimi neng lo tikii sangful ma e u na disaipel, ri fotngi ini Judas Iskariot ka la use re fam pris lamlam, ");
INSERT INTO hrw_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ma ka sa gatom, “Gam sangsang una tow e sa kiang, le ya ku tow e Yesus tif gam?” Ma ri ka wese e tuul e sangful na silwa na mani, ri ka tow kia. ");
INSERT INTO hrw_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Tinglo biing a Judas e siksik ine ti sal una tow e Yesus ilo limlim ri. ");
INSERT INTO hrw_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Lo biing baba tikii lo En Bakir lo Beret e tek ti Is, fan disaipel ri ka puek ma ri ka sa gatmo, “O bura ini kemem u la terer salu o iya, una eni e En na Kepsiliwi?” ");
INSERT INTO hrw_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","I ka koso, “La ilo bala siti, usi e neng e kaltu gam ku la peteng tifi, ‘Titsa e war aregii: Biing kiang e sau fatat, ma yau sa gow e En na Kepsiliwi tura fan disaipel kiang ilo keu fel.’” ");
INSERT INTO hrw_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ma fan disaipel ri ka la usi aregii Yesus ka peteng tifri, ma ri ka fagati e En na Kepsiliwi. ");
INSERT INTO hrw_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Biing pisii e sam la sif, Yesus tura fan disaipel kia ri sam la kiis liflifti e tebol. ");
INSERT INTO hrw_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ma biing ri enenen, i ka war aregii, “Ya peteng tikin tif gam, neng lo gam eu solamuf yau.” ");
INSERT INTO hrw_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ri la sangkuuluung sak, gii ri ka tofnge una war singi aregii, neng nami e neng, “Taufi, tikin sak yau e tam.” ");
INSERT INTO hrw_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yesus ka koso, “Neng gii kabuk fasow e limow tura yau ilo bala dis, eu solamuf yau. ");
INSERT INTO hrw_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Sikow e Kaltu eu la are lea sunwar ke Deo kabuk peteng fate ini. Safle kiskam e kaltu a ku solamufu e Sikow e Kaltu, enggi kausi sak singi, le enggi tibi fuut.” ");
INSERT INTO hrw_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Wimi Judas, kaltu a ku solamufu e Yesus ka war, “Titsa, tikin sak e tibi ta ini yau?” Ma Yesus ka koso, “Yow, are lea o kabuk peteng.” ");
INSERT INTO hrw_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Biing ri enenen, Yesus ka kepe beret, ka aro singe Deo ma ka paek paki. Ka tow tifre fan disaipel kia ma ka war, “Kepe gam ku eni, igii e fong.” ");
INSERT INTO hrw_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Wimi kam kepe e kap, ka aro singe Deo ma ka tow tifri, ma ka war, “Gam nano, gam in tinglo, ");
INSERT INTO hrw_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","igii e dakung, e ta war a-uu una keptiim i kiar, eu lengiuf use re tongge, una kepufu e fan tubiil keri. ");
INSERT INTO hrw_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ya peteng tif gam, gii ya tibi fasi una in tinglo amfingwan waen, ku la muut lo biing a ya mu la inmi mil e waen fuu tura gam ilo bala kepmale ke Tabuung.” ");
INSERT INTO hrw_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Wimi ini ri sek tikeni e seksek, ri kam suu a, ri ka la ulo paklunmale Olif. ");
INSERT INTO hrw_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ma Yesus ka peteng tifri aregii, “Lo panambiing gii sekit, titinge kemi eu luut na fong. Anwarow sunwar ke Deo e sau peteng: ‘Yau pakti e efefe lo re fan sipsip ma ri ku fin falek.’ ");
INSERT INTO hrw_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Sakle wimi ine matet mil kiang, yau la famu i gam ina Galili.” ");
INSERT INTO hrw_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ma Pita ka koso, “Le ri nano ku luut e titinge keri lo o, yau, titinge kiang eu tibi luut.” ");
INSERT INTO hrw_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesus ka koso e Pita aregii, “Ya peteng tikin tifo, lo panambiing sekit gii, famu ine porot eu teng, ou fatuul gurum ini o tibi parfat lo yau.” ");
INSERT INTO hrw_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Sakle Pita e su war, “Le antalu ya ku met tura o, yau tibi peteng sekit ini ya tibi parfat lo o!” Ma fan disaipel nano a ri ka tiin war aiya. ");
INSERT INTO hrw_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Wimi Yesus ka la tura fan disaipel kia ulo male ri fotngi ini Getsemeni, ma ka la war singri, “Gam kiis nene yau wagii ma ya ku la waleii, ya ku la nining.” ");
INSERT INTO hrw_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","I e onu e Pita ma un sikow e Sebedi ri ka la nami. Biing a i e sangkut ma bala ka la kuuluung sak. ");
INSERT INTO hrw_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Wimi i ka war, “Singmat na mafet ma fatengis gii e sam afti kiruur e tangwang, fatat ma ya ku met. Gam u melmel wagii gam ku parpar tura yau.” ");
INSERT INTO hrw_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ka fes balik, ma ka luut ka la ngo paktur ufaf ma ka nining, “Tabuung, le ku fasi, kepe mafet gii kosing yau, sakle o tibi usi yau, e tam, o usi e fabur kiam tibom.” ");
INSERT INTO hrw_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ma Yesus ka la use re tuul disaipel a, ma ka la par ri tuul masun. Ka gatmo e Pita aregii, “Areini, gam tibi fasi una parpar tura yau ku muut lo tikii ti anmatam pisii? ");
INSERT INTO hrw_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Gam u parpar ma gam ku nining are gam ka luut singe falam. Tangtangwami e fabur, sakle fofomi e main.” ");
INSERT INTO hrw_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","I ka la mil baba e u ka la nining mil, “Tabuung le ku tibi fasi ini ou kepufu e kap gii kosing yau, ma ini ya samusu inmi, arik ou tibi usi e fabur kiang. Towfu e fabur kiam ku fuut aregii o ka bura.” ");
INSERT INTO hrw_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Biing i e sa mil, ka sa pari ini ri masun uwa, anwarow matmat ri e masmasun sak. ");
INSERT INTO hrw_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Iya i ka la mil baba e tuul kosing ri ka la nining mil ine tikii sun nining le kabuk nining ini famu. ");
INSERT INTO hrw_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Kala ka mil use re fan disaipel ma ka sa war singri, “Gau masmasun ma manau aiwa? Par! Anmatam pisii e sau puek, ma Sikow e Kaltu ri ku solamufu, ku la ilo limlimre tongge na tumtubiil. ");
INSERT INTO hrw_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Gaman matet! Kerek la! Par! I gii kabuk puek e neng una solamuf yau!” ");
INSERT INTO hrw_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Biing e warwar auwa, Judas neng lo re sangful ma e u ka sa fespuek. Ma una isa, singmat na galung kaltu tura fan iriringgot ma fang kepsil, fan titsa lo fafanau ma fam pris lamlam, ma ge lamlam lo re tongge, ri tule ri. ");
INSERT INTO hrw_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Gii kaltu una solamufu e sau fagatiufu e peteng fate tifri, “Neng gii ya ku osngi e sam ta i, bingfamti.” ");
INSERT INTO hrw_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Judas e fespuek sekit use Yesus ka sa war, “Are o Titsa!” ma ka osngi. ");
INSERT INTO hrw_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ma Yesus ka koso singi ka war, “Fenngong gow e sa o fespuek usi.” Kala tongge a ri ka ti kali e Yesus ma ri ka bingfamti. ");
INSERT INTO hrw_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Biing fan taltalu e Yesus ri pari aiya, neng lo ri ka matet ka sangau use ringgot kia ka iifufu ma ka teseufu e ambalbalu e kaltu na faim ke paklure fam pris. ");
INSERT INTO hrw_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yesus ka war singi, “Towfu mil e ringgot kiam ilo tafu! Le tongge nano gii ri ka fafapaket ine ringgot, ringgot eu en familri. ");
INSERT INTO hrw_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Areini, o sang ini ya tibi fasi una tau singe Tabuung ma i ku tule re fan anggelo na fafapaket una ules yau, riu fuun iyat ini e fis e sangful ma e u na mar? ");
INSERT INTO hrw_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Safle, le ya ku gorot aiya, sunwar ke Deo eu tibi fuut aregii sunwar pepe ka peteng ini e samusu fespuek.” ");
INSERT INTO hrw_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Lo sumbiing a Yesus ka war singre galung kaltu a aregii, “Areini, ya na kaltu una fafapaket ma una kinkinau, gii gam ka fespuek tura fan iringgot ma fang kepsil una sa bingfamti yau? Fan mara biing ya kiis, ya ka fafabenge ulo bala pakanmale lo Felun Nining Bakir, ma gam tibi bingfamti yau. ");
INSERT INTO hrw_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Safle fan mok gii e fuut usi ini fan siisiit kere fam profet eu fasef.” Kala fan disaipel kia ri ka tiin la kosngi ma ri ka fin falek. ");
INSERT INTO hrw_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Tongge a ri ka bingfamti e Yesus ri onu use Kaiyafas, i e ta paklure fam pris lamlam, ma fan titsa lo fafanau ma ge lamlam lo re tongge ri tiim lo ri uwa. ");
INSERT INTO hrw_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Sakle Pita e mimi borong lala nami ri ka la muut sekit ulo ampalkanmale lo fel ke paklure fam pris. I e kaulek sekit ka la kiis uf tura fan efefe ini ku par ini sa eu fespuek. ");
INSERT INTO hrw_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Fam pris lamlam tiim tura fang kaonsiil nano ri siksik ine ton sinseng gurgurum lo Yesus, ini ri ku anganggon singi tura, usi ini ri ku paketmet ini. ");
INSERT INTO hrw_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","E tikin ini tongge fuunfuun ri puek ri ka sa pipit gurgurum talo, sakle ri tibi sikseni e ti mok ek fasi ini riu anganggon lo tura. Wimi neng e ung kaltu ru ka sala, ");
INSERT INTO hrw_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ru ka sa peteng aregii, “Kaltu gii e war aregii, ‘Ya fasi una bero ine Felun Nining Bakir ke Deo, ma ya ku feti mil ilo bala e tuul e biing.’” ");
INSERT INTO hrw_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Wimi paklure fam pris ka ti ma ka war singe Yesus aregii, “Areini o ka tibi koso e ti sunwar? Sese fan warwar le gii tongge gii ri ka gow una bero i o?” ");
INSERT INTO hrw_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Sakle Yesus aua e tibi koso e ti sunwar. Paklure fam pris ka war singi, “Lo asow e Deo e mel e ninliu, ya gatom o, Peteng tif kemem le ku ta o na Kristus Sikow e Deo.” ");
INSERT INTO hrw_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ma Yesus ka koso, “Yow, e ngo are lea o ka peteng. Sakle ya peteng tif gam nano: Wimi gam amu pari e Sikow e Kaltu eu kiis ilo galu miil lo Deo, ma ku mil lo aumbalbal tinglo balambat.” ");
INSERT INTO hrw_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Paklure fam pris e rangsi e kolos tapak kia, ma ka war, “I e sau fotpursi e Deo! Ker am tibi bura e ti tong kaltu ming una peteng ten. Par, gii gam sau bom ongni, i e fotpursi e Deo. ");
INSERT INTO hrw_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Are gam sang?” Ma ri nano ri ka tiin koso ini, “I e tubiil, e samusu met.” ");
INSERT INTO hrw_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Kala ri ka kansu ulo mata ma ri ka tutu ine limlim ri. Fa ri posi ma ri ka war singi, ");
INSERT INTO hrw_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“Le ku ta o na profet, peteng tif kemem Kristus, ini se gii ka tut o?” ");
INSERT INTO hrw_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pita e sam la kiiskiis ulo ampalkanmale, ma neng e fefin na mus ka sa la usi, ka sa war singi aregii, “O ming tura Yesus tingna Galili.” ");
INSERT INTO hrw_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Sakle Pita e warfakale lo u famu iri nano ma ka war, “Ya tibi parfat lo sa o petpeteng ini.” ");
INSERT INTO hrw_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Kala i ka suu tingwa ka la use matangkon ma neng e fefin ka pari ma ka war singre tongge uwa, “Kaltu gii e ta tura Yesus tingna Nasaret.” ");
INSERT INTO hrw_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ma Pita ka warfakale lo ming ma ka limlim tifri ka war, “Tikin sak ya tibi parfat lo kaltu a.” ");
INSERT INTO hrw_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Wimi balik ini, fa ri fafatie uwa, ri ka la usi ri ka la war singi aregii, “E tikin! O na neng lo ri. Anwarow angkiimkiim aiyam e sesuupuek iyo.” ");
INSERT INTO hrw_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Kala kabuk wes talo i tibom. Ma ka limlim tifri, “Ya tibi parfat sekit lo kaltu a!” Saupesak, biing e su war tikii aiya, porot e teng, ");
INSERT INTO hrw_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","ma Pita kabuk la sangfi e fan warwar Yesus e sau peteng tifi ini. “Famu ine porot ma ku teng ou fatuul peteng ini o tibi parfat sekit lo yau.” Ma i ka suu una male ka la tengteng na sangkuuluung bakir tikin. ");
INSERT INTO hrw_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Lo biingbiing e mok sak fam pris lamlam nano ma ge lamlam lo re tongge ri puek tura sunwar una paketmet ine Yesus. ");
INSERT INTO hrw_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Biing a, ri kawefamti e unlimow ma ri ka tatfeni ri ka la towfu tife Pailat, kaltu bakir lo gapman. ");
INSERT INTO hrw_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Biing Judas, kaltu a ka solamufu e Yesus, i e pari ini ri bero ine Yesus, bala e la ikis. Kala ka la ta famila e tuul e sangful na silwa na mani tifre fam pris lamlam ma ge lamlam ma ka war, ");
INSERT INTO hrw_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“Ya sam tubiil, ya ka solamufu e kaltu e tek ti tubiil kia.” Ri ka koso, “Kemem, e tek ti mok kemem ilo. E ta mafet kiam tibom.” ");
INSERT INTO hrw_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ma Judas ka sabel ine fan mani a ulo bala Felun Nining Bakir ma ka la. I e la ka bom la pulim. ");
INSERT INTO hrw_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Mani a, fam pris lamlam ri ka subek tiim iri ma ri ka war, “E ti fasi ususi e fafanau ini kiar u kepe e mani gii kiar ku towfu tura fam mani tinglo Felun Nining Bakir, anwarow ri feli e dadak na minet ini.” ");
INSERT INTO hrw_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Mani a, ri la puek tura sangsang ini riu kepe ri ku feli e ti rinal singe ti kaltu na bibing fan sospen ini, usi riu ofofre fan ses ilo. ");
INSERT INTO hrw_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Iya, lo fam biing gii ri ka fotfotngi e rinal a ini, Rinal na Dadak. ");
INSERT INTO hrw_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Gii sunwar profet Jeremaiya e war ini nangen ka la puek tikin a: “Ri kepe e tuul e sangful na silwa na mani, e ta mani tongge na Israel ri sam a-uu lo ini una feli. ");
INSERT INTO hrw_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ma ri ka kepe e mani a ri ka feli e rinal singe kaltu na bibing fan sospen ini, aregii Taufi kabuk peteng tif yau ini.” ");
INSERT INTO hrw_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Biing a, Yesus e ti u famu ine Pailat, kaltu bakir lo gapman ma i ka gatmo aregii, “O ta king kere fan Juda?” Ma Yesus ka koso, “Yow! Are lea o ka peteng.” ");
INSERT INTO hrw_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Biing fam pris lamlam ma ge lamlam ri berbero ini ma ri ka gatgatmo, Yesus e tibi koso e ti sunwar. ");
INSERT INTO hrw_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Wimi Pailat ka gatmo, “O tibi ongni e mara mok gii ri ka berbero i o nafow?” ");
INSERT INTO hrw_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Sakle Yesus e tibi koso balik e ti boron sunwar, gii ka gow e Pailat ka la kuufsak tikin. ");
INSERT INTO hrw_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Lo fam biing na En na Kesiliwi e ta ninis ke kaltu bakir lo gapman una pikufu e tikii kaltu tinglo rerek iya, tongge nano ri ka bura ini riu pikufu. ");
INSERT INTO hrw_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Lo biing a, e mel e kaltu ulo rerek tongge nano ri parfat lo, asow gii Barabas. ");
INSERT INTO hrw_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Biing tongge ri sam la tiim lo ri, Pailat ka gatom ri, “Sese kaltu gau bura ini riu pikufu tif gam? Barabas tam Yesus, i ya ri ka fotngi ini Kristus?” ");
INSERT INTO hrw_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pailat e parfat kausi tikin ini tongge lamlam lo re fan Juda ri tow e Yesus tifi anwarow e pu e matmatri singi. ");
INSERT INTO hrw_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Biing Pailat e kiiskiis uwa ulo sia kere tongge na ongongni e anganggon, ke wok ka tuleni e sunwar gii tifi. “Ou tibi gow e ti mok lo kaltu gii, e tek ti tubiil kia. Fong e mafet singe numbiil kiang lo panambiing.” ");
INSERT INTO hrw_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Sakle fam pris lamlam ma ge lamlam ri war rawas singre tongge ini riu gatom usi e Barabas, ma Yesus ri ku towfu ilo minet. ");
INSERT INTO hrw_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ma Pailat ka gatom re tongge aregii, “Se lo re ung kaltu gii gau bura ini yau pikufu tif gam?” Ri ka koso, “Barabas!” ");
INSERT INTO hrw_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ma Pailat ka gatom ming, “Ma sa gii ya ku gow lo Yesus, gii ri ka fotngi ini Kristus?” Ma ri nano ri ka koso, “Tutfamteni lo aupaket!” ");
INSERT INTO hrw_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ming Pailat ka gatom, “Anwarow lo sa? Sese tubiil e sam gow?” Ma ri ka su tau bakir, “Tutfamteni lo aupaket!” ");
INSERT INTO hrw_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pailat e pari ini ri am tibi fasi una ong singi ma ri ka bala tofngeni e fapaket gii i ka kepe e dan ka gua e limow na matre tongge ma ka war aregii, “Ya feleni e fong lo andaku e kaltu gii, e ta mok kemi tibom.” ");
INSERT INTO hrw_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ma re tongge nano ri ka tiin war, “Towfu e andaku ku ta ilo kemem ma ilo re fan siksikwamem.” ");
INSERT INTO hrw_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Wimi Pailat ka pikufu e Barabas ma ka tafu ka la tifri, ma ka uunre fan soldia ri ka napsi e Yesus ma ka tow ulo limlim re fan soldia usi riu la tutfamti ulo aupaket. ");
INSERT INTO hrw_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Kala fan soldia ke kaltu bakir lo gapman ri ka onu e Yesus ka la ulo fel ke kaltu bakir lo gapman ma fan soldia nano ri ka la tiim una isa. ");
INSERT INTO hrw_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ri kepufu e ke kolos ma ri ka faloski e neng e tapak ulo e buuluum. ");
INSERT INTO hrw_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ri getiim ine amfinau soksok ri ka tow ulo paklu are at king ma ri ka tow e sungkalut ulo galun limow miil. Ma ri ka kiis pukungkek na mata ma ri ka tumaru, ri ka war aregii, “Siaro, king kere fan Juda!” ");
INSERT INTO hrw_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ma ri ka kansu ma ri ka kepe sungkalut ulo limow ri ka fisi e paklu ini. ");
INSERT INTO hrw_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Wimi ini ri sam ropo e fam fatumar keri lo, ri ka kepufu e kolos gii ri ka faloski ulo, ma ri ka falosngeni mil ine ke kolos tibom. Ma ri ka onu una la tutfamti ulo aupaket. ");
INSERT INTO hrw_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Biing ri fesfes lala ulo sal, ri ka tupngeni e neng e kaltu tinglo taon Sairini asow gii Saimon. Ri ka tungni ini eu subung kepe e aupaket ke Yesus. ");
INSERT INTO hrw_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ri la puek ulo male ri fotngi ini Golgota (pimpiku gii: Male ke Antuampaklung Kaltu.) ");
INSERT INTO hrw_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Uwa ri ka la tow e waen ri iksi tura neng e mok e mafi, ri ka tow tifi ini ku inmi. Sakle biing e tofo i e guuluung una inmi. ");
INSERT INTO hrw_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Biing ri sam tutfamti ulo aupaket, ri ka pilai satu falifu iri una ti lo ri ine fang kolos kia. ");
INSERT INTO hrw_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Wimi ri ka la fakiisnge ma ri ka efe rawas lo Yesus ulo aupaket. ");
INSERT INTO hrw_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Wiyat ine paklu e Yesus ulo aupaket ri tutfamti e ansipin au tura sunwar a ri ka anganggon singi nafow. Sunwar a ri seti aregii: I GII E YESUS, KING KE RE FAN JUDA. ");
INSERT INTO hrw_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ri tutfamti e u e kaltu saksak ulo neng e e un aupaket ming tura Yesus. Neng ulo galu miil ma neng ulo galu kais. ");
INSERT INTO hrw_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Fa ri ka sol singi, ri tumar saksak ini, ri belbel ine pakpakluri ma ri ka war, ");
INSERT INTO hrw_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“O lewa o ka peteng ini ou bero ine Felun Nining Bakir, ma o ku feti mil lo bala e su tuul e biing, om bou faliunge o. Pu tinglo aupaket le ku ta o na Sikow e Deo.” ");
INSERT INTO hrw_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Tikii sal gii, fam pris lamlam, fan titsa lo fafanau ma ge lamlam lo re tongge ri tumaru e Yesus. ");
INSERT INTO hrw_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Ma ri ka war, “E su faliungere fa safle i e tibi fasi una faliungeni tibom. I na King tingna Israel, towfu ku pu tinglo aupaket, usi kerer u titinge lo. ");
INSERT INTO hrw_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","I e tafu e titinge kia ilo Deo. Le Deo ku bura, towfu ku ulsi, anwarow i e peteng ini i na Sikow e Deo.” ");
INSERT INTO hrw_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ilo tikii sal, ung kaltu saksak a ri ka tutfamti ru tura ru bas ini e mara warwar saksak talo. ");
INSERT INTO hrw_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Tinglo siat tuntun ka la muut lo anmatam pisii baba e tuul, anor e pu talo male kiruur a. ");
INSERT INTO hrw_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Lo anmatam pisii baba e tuul, Yesus e tau bakbakir sak, “Eloi, Eloi, Lama Sabakatani?” Pimpiku gii, “Kek Deo kek Deo, usi e tamu o ka la kosing yau?” ");
INSERT INTO hrw_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Biing fa ri fafatie uwa ri ongni, ri ka war, “E tautau ine Elaija.” ");
INSERT INTO hrw_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Saupesak neng lo ri ka la kepe spans ka fasifngeni ulo bala waen gin, wimi ka sanga ulo sungkalut ma kam tow tife Yesus ini ku fitfit ini. ");
INSERT INTO hrw_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ma tongge nano ri ka war, “Gii kerer usu towfu ma kerer ku parpar. Le antalu Elaija ku puek una sa ulsi.” ");
INSERT INTO hrw_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ma biing Yesus e sam tau bakir sak mil, i e sek paket manangia. ");
INSERT INTO hrw_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Lo sum biing a sekit sun laplap bakir ulo bala Felun Nining Bakir e rages ka u lo, ting wiyat ka la muut ufaf. Male e gi ma fatfat ri ka tapot. ");
INSERT INTO hrw_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Balbalang kenit ri ipiik ma pinpinumfori e tongge riis a ri kabuk met, ri ka matet mil ri ka liu. ");
INSERT INTO hrw_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ri suu tinglo balbalang kenit, ma wimi ine matmatet mil ke Yesus, ri ka la ulo siti tarawen ina Jerusalem ma tongge fuunfuun ri ka par ri. ");
INSERT INTO hrw_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Biing kaltu bakir kere fan soldia tura fa ri efefe lo Yesus, ri ongni e anggi ma ri ka pari e mara mok gii e fuut, ri la soke sak, ri ka tautau bakbakir, “Tikin sak, ina Sikow e Deo.” ");
INSERT INTO hrw_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","E mel e gelefin ri sam ususi e Yesus ting famu tingna Galili una efefe lala lo fam fabur kia, ri titi u tapak ri ka parpar. ");
INSERT INTO hrw_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Maria Makdalen, Maria tinow e Jeims ma Joses ma tinow e fan siksikow e Sebedi ri ta u falifu ire gelefin a. ");
INSERT INTO hrw_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Biing e lala una biing e mel e kaltu tuba mel tingna Arimatia e puek, asow gii Josef. I tibom e ta neng lo re fan disaipel ke Yesus. ");
INSERT INTO hrw_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","I e la use Pailat ka la gatmo use pinumfow e Yesus. Ma Pailat ka fauun ri ka kepe ri ka tow tifi. ");
INSERT INTO hrw_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Josef e kepe pinumfow e Yesus ka la afti ine laplap e fuu ma e kalkaliis kausi tikin. ");
INSERT INTO hrw_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ma ka towfu ulo bala balang kenit fuu kia tibom, e kefi ulo fam. Wimi ka filiitngeni e neng e e fat kali e anmatow e balang kenit a, ma ka la kosngi. ");
INSERT INTO hrw_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maria Makdalen ma Maria tinow e Jeims ma Joses ru kiiskiis ulo galu lo balang kenit a. ");
INSERT INTO hrw_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Lo biing wimi ine biing una terngeni e fan mok wilo biing na Sabat, fam pris lamlam ma fam Farasi ri ka la use Pailat, ");
INSERT INTO hrw_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ri ka la peteng tifi aregii, “Kaltu bakir, kemem sangfi e kaltu na gurgurum lewa, lo biing i e liu uwa e peteng aregii, ‘Wimi ine e tuul e biing yau matet mil.’ ");
INSERT INTO hrw_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Kemeu bura ini ou tow e sunwar ri ku efe rawas lo balang kenit ku la muut lo biing baba e tuul. Are kuuf ma fan disaipel kia ri ka puek ri ka sa kinow e pinumfow ma ri kamu peteng tifre tongge ini Yesus e sau matet mil kosnge minet. Ma anggurum gii ri ku gow, eu kulfi e anggurum kia lewa ka gow famu.” ");
INSERT INTO hrw_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ma Pailat ka war, “Uunre tong kaltu na efefe, ri ku la efe kausi lo balang kenit aregii, gam ka parfat.” ");
INSERT INTO hrw_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ma ri ka la ri ka la fagati ri una efe lo balang kenit. Ri towfu e anulau ulo fat bakir ulo matow e balang kenit, ma ri ka towfu e tongge na efefe ri ka efe lo. ");
INSERT INTO hrw_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Wimi ine biing na Sabat, lo biingbiing e mok sak lo biing baba tikii lo wik, Maria Makdalen ma neng e Maria ming, ru la una la par lo balang kenit. ");
INSERT INTO hrw_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","E mel e anggi bakbakir sak ma anggelo ke Deo ka pu tinglo balambat ka kau ulo balang kenit. Ma i ka filfiiliit mil ine fumfat ma ka kiis ulo. ");
INSERT INTO hrw_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Fow e fufuf are ampil, ma kolos kia e murmur saksak sekit. ");
INSERT INTO hrw_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Fan efefe ri soke sak ma ri kau banban, ma ri ka la ngo are tongge ri sau met. ");
INSERT INTO hrw_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ma anggelo ka war singre um fefin a, aregii, “Kamun mana soke. Ya parfat ini kamu sik ine Yesus, lewa ri ka tutfamti ulo aupaket. ");
INSERT INTO hrw_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","I e tam ini gii, e sau matet mil, are i e sau peteng. Kamung kasa, kamu ku sa par lo mok ri tafu ulo. ");
INSERT INTO hrw_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Kamun la saupe gii, kamu ku la peteng tifre fan disaipel kia, ini i e sau matet mil kosnge minet. Ma i e sam la famu i gam ina Galili. Wa gam u la pari, aregii ya ka peteng tif kamu.” ");
INSERT INTO hrw_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ma saupesak um fefin a, ru ka la kosnge balang kenit. Ru soke, sakle ru fuunuf ine gasgas ma ru ka filau una la peteng tifre fan disaipel kia. ");
INSERT INTO hrw_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Kala Yesus ka tupnge ru ma ka are ru. Ma ru ka fes usi ru ka puse lo ung kekow ma ru ka por na nawen singi. ");
INSERT INTO hrw_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ma Yesus ka war singru, “Kamu mana soke. La kamu ku la peteng tifre tanga tuaklik, ini riu la ina Galili. Wa gam u la par yau.” ");
INSERT INTO hrw_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Lo biing um fefin ru ta uwa ulo sal, fa lo re fan soldia ri efefe lo balang kenit, ri la ulo siti una la peteng tifre fam pris lamlam, ine fan mara mok e fuut. ");
INSERT INTO hrw_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Fam pris lamlam ri tiim tura re ge lamlam lo re tongge ma ri ka gow e neng e fagati. Ri tow e singmat na mani tifre fan soldia, ");
INSERT INTO hrw_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ma ri ka war singri, “Gam u peteng ini fan disaipel kia ri sa kep borong ine pinumfow lo panambiing, lo biing gau masun. ");
INSERT INTO hrw_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ma le sunwar gii ku kepe e kaltu bakir lo gapman, kemem amu fariisu e sunwar tura ma kemem ku kepuf gam tinglo tubiil.” ");
INSERT INTO hrw_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Fan soldia ri kepe mani ma ri ka gow aregii ri kabuk uun ri ini. Ma pansinseng gii e omseni e fan mara Juda nano tinglo biing a ka la muut gii. ");
INSERT INTO hrw_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Wimi tikii sangful ma e tikii na disaipel ri kala ulo paklunmale ina Galili, lewa Yesus ka peteng tifri ini riu la wilo. ");
INSERT INTO hrw_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Biing ri pari, ri por na nawen singi, safle fa lo ri, ri sang fa-u. ");
INSERT INTO hrw_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Wimi Yesus ka puek talo ri ma ka war singri, “Fan mara rawas tinglo balambat ma nal, Deo e sam tow tif yau. ");
INSERT INTO hrw_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Gii gam la use re tongge nano ilo mara male, gam ku gau ri, ri ku ta fan disaipel kiang. Gu tarawen iri lo asow e Tamow ma Sikow ma Tangwa Riis, ");
INSERT INTO hrw_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ma fabenge singri una usi e fan mara mok ya peteng ini tif gam. Ma yau ta tura gam lo an mara biing, ku muut lo biing muut.” ");
INSERT INTO hrw_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","I gii e tofnge lo konona sunwar lo Yesus Kristus, Sikow e Deo. ");
INSERT INTO hrw_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Profet Aisaiya e sam seti e sunwar Deo e peteng tifi ini aregii, “Yau mu tuleni e ti anunune kiang famu iyo, ku la fagatiufu e sal kiam. ");
INSERT INTO hrw_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ulo male e tek ti kaltu, angkiimkiim a neng e tautau aregii, ‘Fagati e sal ke Taufi, fariisu e fan sal kia.’” ");
INSERT INTO hrw_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ma Jon i e kaltu una musngeni e amfagu tarawen, i e fespuek ulo male e tek ti kaltu ma i ka sesngeni lala e sunwar tifre tongge ini riu sangikis ma kepe e amfagu tarawen una fanangsi ini ri sam iksi e balbalri, usi Deo eu sangintafngi e fan tubiil keri. ");
INSERT INTO hrw_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ma tongge fuunfuun tinglo distrik Judia, ri tiim tura tongge tingna Jerusalem ri la use Jon ma ri ka fabeku e fan tubiil keri ma Jon ka gu tarawen iri lo Dan Jodan. ");
INSERT INTO hrw_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jon bingne e los lo kolos ri bilseni lo ololow e kamel, ma e diidiit ine aneueu kia, ri bilseni lo pinumfow e man. Ma i e enene fang ko ma fan ani tingna mok. ");
INSERT INTO hrw_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","I e sesngeni e sunwar aregii, “Nenge kaltu e mu puek wimi i yau, ma rawas kia e kulfi e rawas kiang. Ya tibi ta konona kaltu e fasi ini yau kis ine ampukangkekeng ma ya ku pikii e amfinau lo su kia. ");
INSERT INTO hrw_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ya gu tarawen i gam ine dan safle i eu gu tarawen i gam ine Tangwa Riis.” ");
INSERT INTO hrw_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Lo biing a, Yesus e la kosnge Nasaret ilo distrik Galili ma Jon ka gu tarawen ini ulo Dan Jodan. ");
INSERT INTO hrw_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ma biing Yesus e biik tinglo dan, i e pari e balambat e rages ma Tangwa Riis ka pu talo are anman e par are ambal. ");
INSERT INTO hrw_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ma neng e angkiimkiim ka tau tinglo balambat aregii, “O na Sikuang ya buro tikin. Balang e gasgas lo o.” ");
INSERT INTO hrw_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ma saupesak Tangwa Riis e tuleni e Yesus ka la ulo male e tek ti kaltu. ");
INSERT INTO hrw_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ma Yesus e melmel ulo male e tek ti kaltu ulo lo e fet e sangful na biing. Ma Satan ka lamu. I e melmel tura fan man rokai ma fan anggelo ri ka ulsi. ");
INSERT INTO hrw_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Biing ri sam tafu e Jon ulo rerek Yesus e sa fespuek ulo distrik Galili ma i ka sesngeni e konona sunwar lo Deo. ");
INSERT INTO hrw_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","I e war aregii, “Biing e sau puek ma Kepmale ke Deo e sau fatat sekit. Gam samusu iksi e balbalmi ma titinge lo konona sunwar.” ");
INSERT INTO hrw_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yesus e fes ulo pisow e salat Galili, ma i ka pari e Saimon tura tualik Enru iru basbas ine ubiin ulo balan salat, le ru ta ung kaltu na tuntunii. ");
INSERT INTO hrw_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ma Yesus ka war singru, “Kamun mi nami yau, ma ya ku fatiti kamu una tuuktuuk ire tongge.” ");
INSERT INTO hrw_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ma saupesak ru ka tafu e fan ubiin keru ma ru ka mi nami. ");
INSERT INTO hrw_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Biing Yesus e sau fes ka la u tapak balik, i e pari e Jeims sikow e Sebedi tura tualik Jon ulo bala mon, ru terterngeni e fan ubiin. ");
INSERT INTO hrw_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ma saupesak i ka tau iru, ma ru ka la kosnge tamru Sebedi ka ngosok ulo mon tura tongge namus keri, ma ru ka la nami e Yesus. ");
INSERT INTO hrw_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yesus tura fanenger fan tongge ri la una Kapenaum, ma lo Biing Sabat e fespuek i e kaulek ulo felun nining ma ka fabenge singre tongge. ");
INSERT INTO hrw_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ri ka ongni e sunwar kia. Ma tongge fuunfuun uwa ri tiin la kuufsak lo fan fabenge kia. Anwarow, i e fabenge singri are kaltu e mel e rawas kia, ma mia e mel. E tibi ngo are fang titsa tinglo fafanau. ");
INSERT INTO hrw_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Lo biing a, neng e kaltu ulo bala felun nining keri e mel e tangwaner saksak ulo, i e kaung bakir tikin aregii, ");
INSERT INTO hrw_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Yesus, tingna Nasaret! O bala sa tamu i kemem? Kele ma o fespuek una sa bero i kemem? Ya parfat lo o. O na Kaltu Pepe ke Deo.” ");
INSERT INTO hrw_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Safle Yesus e porow e tangwaner saksak a, aregii, “On fakuta e ngusum ma ok la kosnge kaltu a.” ");
INSERT INTO hrw_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ma tangwaner saksak ka gaseni e kaltu a ma i ka kaung bakir ma tangwaner saksak ka la kosngi. ");
INSERT INTO hrw_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ma tongge nano ri kuufsak ma ri ka fawar falifu iri tibom aregii, “Sa ka fespuek gii? Kaltu gii e fabenge ine sunwar fuu ma i ka sesngeni e sunwar are kaltu e mel e mia lo matam fabenge aregii. Ma bingne i e tow e fatungen tifre fan tangwaner saksak ri ongne singi.” ");
INSERT INTO hrw_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ma sinseng lo fan mok Yesus e gow e omsene kiruur e distrik na Galili. ");
INSERT INTO hrw_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yesus tura fan disaipel kia, ri la kosnge felun nining ma ri ka suu una male, ma ri ka la ris ulo fel ke Saimon ma Enru. Ma Jeims ma Jon iru la ming. ");
INSERT INTO hrw_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Yanow fefin e Saimon e ngongo ulo ngiin, e bokor. Ma ri ka peteng tife Yesus ini e mase. ");
INSERT INTO hrw_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ma Yesus ka la usi, ka puse lo limow, ka famtete ma ambokor a ka rop tinglo, ma i ka tofnge una fagati e fan tuan ari. ");
INSERT INTO hrw_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Lo biing pisie e la suu lo efef, ri ka uun puek ire tongge nano ri mase tife Yesus ma ri ka uunpuek ming ine tongge nano e mel e fan tara saksak ulo ri. ");
INSERT INTO hrw_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Tongge nano tinglo taon a, ri sa tiin melmel fatatu e matangkon lo fel. ");
INSERT INTO hrw_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ma Yesus ka faliungere fa fuunfuun sak lo re tongge ri mel lo fan matan minse ma i ka tii ine e fuun lo fan tara saksak. Tafen i ka fanau re fan tara saksak ini riu tibi gon, anwarow ri parfat ini i gii se. ");
INSERT INTO hrw_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Lo biingbiing e mok sak, e or uwa e male, Yesus e kuuf ka suu una male ma i ka la ulo galu e tek tikas ulo, ma i ka la nining uwa. ");
INSERT INTO hrw_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ma wimi Saimon tiim tura fan taltalu ri ka sik ine Yesus. ");
INSERT INTO hrw_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ma biing ri la tonggeni, ma ri ka peteng tifi aregii, “Tongge nano ri ngos na sik iyo.” ");
INSERT INTO hrw_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ma i ka peteng tifri aregii, “Kiar u la ilo fanenger fan susun male gii fatat, usi yau la sesngeni e sunwar tifri ming, i e mus mung gii ya ka puek una musngeni.” ");
INSERT INTO hrw_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ma i ka fes fawet ulo distrik Galili, ma ka sesngeni e warwar ulo fan felun nining keri, ma i ka tii ire fan tara saksak. ");
INSERT INTO hrw_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Nenge kaltu e mel e anminse lepra ulo e puek use Yesus ma i ka pukungkek, ma ka peteng tife Yesus aregii, “Le o ka bura, o fasi una faliunge yau.” ");
INSERT INTO hrw_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yesus e tengsi tikin ma i ka sangau ine limow ka pot lo, ma ka war, “Ya fabur! O samusu kalkaliis.” ");
INSERT INTO hrw_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Saupesak anminse lepra e la kosngi ma i ka liu. ");
INSERT INTO hrw_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ma saupe Yesus ka uun ufu ka la, ma ka war rawas singi, ");
INSERT INTO hrw_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Ate kausi! Ou tibi peteng tife tikas ine mok e sau fuut lo o. Safle ou la, o ku la fanangsi o tibom tife pris ma o ku gow e finafen aregii Moses kabuk peteng, una fanangsi re tongge ini o sam kalkaliis.” ");
INSERT INTO hrw_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Safle kaltu gii e la, ka la seseng fawet tifre tongge nano. Sinseng gii e omsene male, iya Yesus kam tibi fasi una fes malal na matre tongge ulo fan taon. Yesus e la subung ulo fan male e tek tong kaltu, safle tongge ri kasu puek talo tinglo fan mara male. ");
INSERT INTO hrw_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","E tibi fuun e biing wimi ma Yesus ka kaulek mil una Kapenaum, tongge ri ong ini e sau puek ulo fel kia. ");
INSERT INTO hrw_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ri ka la tiim ulo fel a, i e fel a e fuunuf tikin, kala muut una male ine matangkon e am tek ti sol. Ma Yesus ka sesngeni e sunwar tifri. ");
INSERT INTO hrw_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ma e fet e kaltu ri ka kepuek ine neng e kaltu e dol, ri ka sa tafu. ");
INSERT INTO hrw_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Fel e fuunuf tikin, ri tibi fasi una taufu e kaltu a fatatu e Yesus. Ri ka kepe ri ka fen tura ulo poktow e fel a, ri ka paek salu ma ri kau fauli e ngiin ine kaltu a e ngongo ulo, ka pu bala fel. ");
INSERT INTO hrw_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Biing Yesus e pari ini titinge keri e raw tikin, kam war singe kaltu a aregii, “Sikuang, ya sam kepufu e fan tubiil kiam.” ");
INSERT INTO hrw_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","E mel e fan titsa lo fafanau ri kiiskiis ming ulo bala fel, ma ulo sinsinangu ri, ri sangsang aregii. ");
INSERT INTO hrw_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Areini gii, kaltu a ka war ine sunwar e ngo aiya? I e fotpursi e Deo! E tek ti kaltu e fasi una kepufu e fan tubiil. Faim ke Deo tibom.” ");
INSERT INTO hrw_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ma saupesak e sau parfat lo bala sinangu ri, i kam gatom aregii. “Usi e tamu ka mel e sangsang aiya ailo sinsinangumi? ");
INSERT INTO hrw_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Sese sunwar e paumiil una war ini tife kaltu dol gii? E paumiil una war ini, ‘Iya sam sangintafngi e fan tubiil kiam,’ tam, e paumiil una war aregii, ‘On matet, ong kepe kem ngiin ma o ku fes?’ ");
INSERT INTO hrw_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Safle ya bura ini gam samusu parfat ini, Sikow e Kaltu e mel e mia gii lo nal una kepufu e fan tubiil.” Yesus ka par use kaltu dol a, ma ka war aregii, ");
INSERT INTO hrw_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ya peteng tifo, matet, kepe kem ngiin ma o ku la mil ilo keu fel.” ");
INSERT INTO hrw_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ma kaltu a ka matet nabalan fan matri nano ka kepe ke ngiin ma ka fes ka la, tongge ri ka kuufsak tikin ri ka resngeni e Deo ma ri ka war aregii, “Kemem tifik par ti mok ek ngo aregii, e tam sekit.” ");
INSERT INTO hrw_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesus ka fes ka la ming ulo pisangkin lo salat ina Galili. Ma singmat na galung kaltu ri ka puek usi. I ka fabenge singri. ");
INSERT INTO hrw_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","I ka fes ka la ma ka pari e Liwai sikow e Alfius e kiiskiis ulo bala felun mani, Yesus ka war singi aregii, “On minami yau.” Ma Liwai ka matet ka minami e Yesus. ");
INSERT INTO hrw_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Lo biing Yesus e enenen ulo bala fel ke Liwai, ma tongge na kepkep mani, ma tongge na tumtubiil ri kiis ri ka en tiim tura Yesus, ma fan disaipel kia. E mel e fuunfuun lo re matang kaltu a, ri mimi nami e Yesus bingne. ");
INSERT INTO hrw_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ma tomfa lo re fan titsa lo fafanau ri ta fam Farasi, ri ka pari e Yesus e kiiskiis ka enenen tura tongge na tumtubiil, ma tongge na kepkep mani. Ri ka gatom re fan disaipel ke Yesus aregii, “Usi e tamu titsa kemi ka en tiim tura re tongge na kepkep mani, ma tongge na tumtubiil?” ");
INSERT INTO hrw_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesus ka ongni e sunwar keri, ka war singre tongge parfat a aregii, “Tongge ri tibi mase, ri tibi la use dokta, safle tongge ri mase ri la use Dokta. E su ngo aregii, ya tibi sa la una tau ire tongge riis, e tam. Ya sa la una tau ire tongge na tumtubiil.” ");
INSERT INTO hrw_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Fan disaipel ke Jon ma fan Farasi, ri feleni e en, ma fa, fang kaltu ri ka sa gatmo e Yesus aregii, “Usi e tamu fan disaipel ke Jon ma fan disaipel kere fan Farasi ri ka feleni e en, ma fan disaipel kiam ri ka tibi feleni e en?” ");
INSERT INTO hrw_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ma Yesus ka koso singri aregii, “Gam sang ini fam fenfenngow e kaltu a ka rong una tinaule ri ku feleni e en, ma i ka melmel iwa tura ri? Biing kaltu a ka melmel aiwa inais ri, ri tibi fasi una fel. ");
INSERT INTO hrw_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Safle e mu mel e biing eu puek una onu e kaltu a ka rong una tinaule ku la kosing ri, lo i e biing a ri kamu fel a. ");
INSERT INTO hrw_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“E tek ti kaltu eng kepkepe ti sung kael fuu una sok kaleni e amfur ailo kolos ting nangen. Le i ku gow aiya, biing riu gua e kolos sung kael a una kaleni e amfur a, eu la tete ma ku sisi mil e kolos ting nangen. Le i ku gow aiya su fuu eu rangsi e su ting nangen ma amfur a ku la sisi bakir. ");
INSERT INTO hrw_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ma e tek tikas en ututfi e ti waen fuu ilo bala ampinun me ting nangen. Le i ku gow aiya, waen a eu ese paki e ampinun me, ma i ru nano ru ku tiin sak. E tam, ri ututfi e waen fuu ilo ampinun me fuu.” ");
INSERT INTO hrw_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Nenge biing Sabat Yesus e fes lala ulo bala fam palang na wit, ma fan disaipel kia ri ka la nami, ri ka kutuul pakti lala e fanenger lo ri. ");
INSERT INTO hrw_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ma fam Farasi ri ka gatmo e Yesus aregii, “Use sa ri ka gow e mok e pepe una gow lo biing Sabat?” ");
INSERT INTO hrw_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yesus ka koso e sunwar keri aregii, “Ya sang ini gam tifik wese e pansinseng lo mok Dewit e sam gow nangen? Yau war lo biing lewa, i tiim tura tongge kia, ri pospos lo tuan ma ri ka fitol. ");
INSERT INTO hrw_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Abiatar e ta paklure fam pris lo biing a, ma Dewit ka kau ulo bala fel ke Deo ka la eni e beret a, e pepe, fam pris tibom ri bom eneni. Sakle Dewit e la eni, ma kau fenre tongge kia ming ini. Gam tifik wese pansingseng gii?” ");
INSERT INTO hrw_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ma Yesus ka war singri ming aregii, “Deo e tibi taufre tongge una ulsi e biing Sabat, e tam, i e taufu e biing Sabat una ules re tongge. ");
INSERT INTO hrw_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Aregii Sikow e Kaltu e ta Taufi lo biing Sabat.” ");
INSERT INTO hrw_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yesus e la kaulek mil ulo bala felun nining, ma neng e kaltu galun limow e sau met i uwa ming. ");
INSERT INTO hrw_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ma tongge ri ka efe kausi sak lo Yesus. Usi e tamu ri bur parfat ini eu faliungeni e kaltu a lo biing na Sabat, tam e tam. Ri sang ini le Yesus ku gow e sinang a, ri u sesuupuek ini. ");
INSERT INTO hrw_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesus ka war singe kaltu a limow ka sak aregii, “Kasa o ku sa ti na matre tongge.” ");
INSERT INTO hrw_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ma Yesus ka gatom ri aregii, “Sese fafanau kiar u usi lo biing Sabat? Una gow e konona sinang, Tam una gow e sinang e sak? Una faliungere tongge, Tam una paketmet iri?” Safle tongge ri tibi kos ti sunwar. ");
INSERT INTO hrw_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yesus ka alal lo ri ma bala ka la tuntun e pari e balbalri e kut, bala ka sak lo mok a. Ka war singe kaltu a aregii, “Fariisu e limam.” I ka fariisu e limow, ma limow ka kausi mil. ");
INSERT INTO hrw_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ma saupesak fam Farasi ri ka suu tinglo bala fel ri ka la, ri ka la tiim tura galung kaltu ke King Erot ri ka la gow e fan warwar una sik ine ti sal una paketmeteni e Yesus. ");
INSERT INTO hrw_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesus tura fan disaipel kia ri la kosngi e male a, ri ka la ulo salat Galili ma tongge fuunfuun sak tingna Galili ri ka mi nami, ri ka la. ");
INSERT INTO hrw_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Tongge nano tingna Judia, tingna Jerusalem, tingna Idumiya, ma tinglo galu ilo anisow e Dan Jodan, ma tinglo galu ina Tair ma Sidon. Ri ong lo sinseng lo fan mok Yesus e gow, ri ka puek usi. ");
INSERT INTO hrw_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Yesus ka war singre fan disaipel kia aregii, “Singmat na galung kaltu gii are ri ka situf yau ma ri kam suleuf yau. Kepe ti mon wagii una nene. Le tongge gii ri ku fasit sak, Yau la kiis ilo mon.” ");
INSERT INTO hrw_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Famu Yesus e sau faliungere tongge fuunfuun, iya tongge ri mase, ri ka bur potlo, ri ka sulsule re fa fasap ri usi ri tibom ri u la fatatu. ");
INSERT INTO hrw_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ma biing fan tangwaner saksak ri ka pari, ri su luut ufaf na mata, ma ri ka tau aregii, “Ona Sikow e Deo.” ");
INSERT INTO hrw_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Sakle Yesus e fanau sak iri ini riu tibi peteng suupuek ini i se tikin. ");
INSERT INTO hrw_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesus e la kanek ulo paklunmale, ka tau ire tongge e bur ri, ri ka puek usi. ");
INSERT INTO hrw_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ka tafu e tikii sangful ma e u na kaltu, usi riu melmel tura, ma ka foteng ri ini fan apostel, usi ini eu tuleri una la sesngeni e sunwar ke Deo. ");
INSERT INTO hrw_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ma ka tow e rawas tifri una feselufu e fan tangwaner saksak. ");
INSERT INTO hrw_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","E tafu e sangful ma e u: Neng asow gii Saimon, Yesus ka fotngi ming ini Pita. ");
INSERT INTO hrw_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Ma ka tafu e Jeims, sikow e Sebedi, tura tualik Jon. Ma ka foteng ru ine as gii Bonages, (pimpiku gii, Un Sikow e ampararak). ");
INSERT INTO hrw_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ma ka tafu ming e Enru, Filip, Batolomius, Mateus, Tomas, Jeims sikow e Alfius, Tadeus, ma Saimon kaltu tinglo galung kaltu ri foteng ri ini fan Silot, ");
INSERT INTO hrw_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ma Judas Iskariot i e kaltu una mu solamufu e Yesus. ");
INSERT INTO hrw_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yesus ka la ulo fel ma singmat na galung kaltu ri ka sa tiim lo ri ming, ma e tek ti boron sumbiing una en singe Yesus ma fan disaipel kia. ");
INSERT INTO hrw_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ma fumberat lo Yesus ri ong lo fan mok Yesus e gow, ri ka puek una sa onu. Ri peteng aregii, “I e lomba.” ");
INSERT INTO hrw_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Fa lo re fan titsa lo fafanau, ri la una Jerusalem ri war aregii, “Belsebul e mel ailo. E fesfesel re fan tangwaner saksak lo rawas ke Belsebul mung, paklure fan tangwaner saksak.” ");
INSERT INTO hrw_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yesus ka tau iri, ri ka puek fatatu, ma ka gow e warwar toftof tifri ka war aregii, “Satan e fasi una fesi e Satan? ");
INSERT INTO hrw_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Le tongge tinglo tikii kaontri eu tapot lo ri, ku u e galung kaltu ma ri ku fapaket, kaontri a eu tibi fasi una ti raw. ");
INSERT INTO hrw_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Le fumberat tinglo bala tikii fel eu tapot ku u lo ri ma ri ka fapaket, fumberat a ri u tibi fasi una ti raw. ");
INSERT INTO hrw_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ma le Satan ku sak lo i tibom ma galung kaltu kia ri ku tapot, e tibi fasi una ti raw, e tam, eu rop sekit. ");
INSERT INTO hrw_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","E tek ti kaltu e fasi una kau bala ti fel ke ti kaltu rawas, ma ku kepe fan mok kia, e tam, i eu bi rek famteni, le i ku gow aiya kamu fasi una seleni e fan mok kia. ");
INSERT INTO hrw_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ya peteng tikin tif gam, Deo eu sangintafngi e fan tubiil ma fan fotpuris tongge ri gow. ");
INSERT INTO hrw_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Sakle kaltu e fotpursi e Tangwa Riis e tibi fasi ini Deo eu kepufu e tubiil kia, geinggii ma wimi ming e tam. Tubiil e sam ngongo bingne.” ");
INSERT INTO hrw_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesus e war aiya, anwarow ri peteng ini i e mel e tangwaner saksak ilo. ");
INSERT INTO hrw_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Lo biing tinow ma tanga tualik e Yesus ri fespuek, ri ti una male ma ri ka tuleni e sunwar usi, ini ri bur pari. ");
INSERT INTO hrw_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Singmat na galung kaltu ri ka fakiisnge liflifti, ri peteng tifi aregii, “Ong, Tinam, ma tanga tuamlik ri gii ina namale, ri bur par o.” ");
INSERT INTO hrw_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","I ka gatom ri. “Se e ta tiduung, ma se e ta tuaklik?” ");
INSERT INTO hrw_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","I e par use tongge ri kiis falifit ini ma i e war, “Par, igii e tiduung ma tanga tuaklik. ");
INSERT INTO hrw_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Se eu usi e fabur ke Deo, e ta tuaklik, fefneklik ma tidung.” ");
INSERT INTO hrw_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ming Yesus ka tofngene fabenge lo pisow e Salat Galili. Tongge ri fang liflifti ri fuun sak. I e kau bala mon ma ka kiis u tapak balik, lo sum biing a, tongge ulo anisow e dan. ");
INSERT INTO hrw_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","I e fabenge ine mara mok lo warwar toftof, ma lo fabenge i e war aregii, ");
INSERT INTO hrw_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Ong! Nenge kaltu una fafaim palang e la sabel ine firfiran au kia. ");
INSERT INTO hrw_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Lo sumbiing e samsabel lala ine firfiran au a, fanenger ri rurung ulo sal, ma fan man ri ka sa en tike ri. ");
INSERT INTO hrw_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Fanenger ri rurung ulo male e fatfat nal e tibi bakir, e faf kanek saupe sak anwarow nal e tibi pinut. ");
INSERT INTO hrw_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Sakle biing pisii e fen kanek fan au a, ri main ma ri ka met anwarow e tek ti awawi. ");
INSERT INTO hrw_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Fanenger ri rurung ulo bala finfinau soksok. Ri ka faf kanek tura finfinau soksok a ma finfinau soksok a ka pismet iri, iya ri kam tibi fira. ");
INSERT INTO hrw_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Sakle fanenger fan firfiran au e luut ulo konona nal e faf kanek, ma e fira, fanenger e tuul e sangul, fanenger e on e sangful ma fanenger e tikii atis.” ");
INSERT INTO hrw_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ma i ka war ming aregii, “Se a ka mel e ambalbalu una ongong, tafu ku ong.” ");
INSERT INTO hrw_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Biing i tibom, tura fa lo re tongge ma tikii sangful ma e u na disaipel kia, ri ka gatom usi e pimpiku e fan warwar toftof. ");
INSERT INTO hrw_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ma Yesus e peteng tifri, “Pindik lo kepmale ke Deo e sam tow tif gam. Safle tifre fa ina male, mara mok ri war ini lo warwar toftof. ");
INSERT INTO hrw_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Usi riu parpar ma riu tibi pari, riu ongongni ma riu tibi ten. Le ring gi gow, ring gi mil use Deo ma i kamu kepufu e fan tubiil keri.” ");
INSERT INTO hrw_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ming Yesus e war singri, “Gam tibi pauti e sunwar toftof gii? Areni gii gam kamu pauti e fanenger fan warwar toftof? ");
INSERT INTO hrw_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Kaltu na umume e su ngo are kaltu e sesngeni e sunwar ke Deo. ");
INSERT INTO hrw_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Fan tongge ri ngo are amfiran au e luut ulo sal. Ri su ongni e sunwar ma saupesak Satan ka gorotufu tinglo balbalri. ");
INSERT INTO hrw_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Fa ri ngo are amfiran au e luut ulo male fatfat, ri ongni e sunwar ma saupe ri kepe tura fefeal. ");
INSERT INTO hrw_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Safle ri su melmel lo borom pansumbiing, anwarow e tek ti awawi ri. Biing mafet tam fapaket e fespuek anwarow lo sunwar ri kepe, ri luut saupesak. ");
INSERT INTO hrw_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Safle fanenger ri ngo are amfiran au e luut falifu lo amfinau soksok, ri ongni e sunwar. ");
INSERT INTO hrw_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Safle ri sangfuunfuun use melmel keri, fam fabur bakir una mel e tuba ri, ma fabur keri lo mara mok tinglo nal, e afti e sunwar ka tibi fira. ");
INSERT INTO hrw_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Fa ri ngo are firfiran au ri so lo konona nal, ri ongni e sunwar ma ri kepe, ma e fafuutngeni e amfirow, fanenger e tul e sangful, fanenger e on e sangful ma fanenger e tikii atis.” ");
INSERT INTO hrw_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesus e gatom ri aregii, “Ou kep kau ine lam una tafu ilo pikliu e piok tam ngiin? E tam. Ou towfu lo poktow e ngiin. ");
INSERT INTO hrw_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Le sese mok e fifinuf e mu fespuek na malal, ma sese mok ri luukbobo e mu suupuek na malal. ");
INSERT INTO hrw_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Le se a ka mel e ambalbalu una ongong, tafu ku ong.” ");
INSERT INTO hrw_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Yesus e war ming aregii, “Kep famti e sunwar gam ongni, se e ikseni e sunwar tikin gii, Deo e mu gow lo, ma e mu tow ku bakir sak. ");
INSERT INTO hrw_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Le se a kabuk mel Deo eu fen fuunfuun ini, ma se a ka tifik mel, sese mok i e mel lo, Deo eu kep famila singi.” ");
INSERT INTO hrw_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesus e war ming aregii, “Kepmale ke Deo e ngo aregii. Nenge kaltu e sabel ine firfiran au ulo nal. ");
INSERT INTO hrw_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Panambiing ma siat, i e masun tam e kuuf, amfiran au e suar ma e faf kanek, tafen i e tibi parfat ini e faf are eni. ");
INSERT INTO hrw_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Lo i tibom nal ka fafuutngeni e amfirow, baba tike e tow e auauwu, kala angkobu, wimi tuan kiruur tinglo angkobu. ");
INSERT INTO hrw_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Lo biing tuan e su matuk, saupesak i e teseni ine ringgot anwarow biing na matukfaim e sau puek.” ");
INSERT INTO hrw_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ming i e war, “Are kiar u war lo kepmale ke Deo, are e ngo, tam sese warwar toftof kiar fasi una fatofo lo? ");
INSERT INTO hrw_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","E su ngo are amfiran mastet, e su balik sak e amfirow o so ilo nal. ");
INSERT INTO hrw_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Lo biing o so, e faf ma ka puek bakir sak ine mara au ilo bala palang, tura katkatow e lamlamsak. Talaman ri fasi una tuutpolpol ilo usi e maluuf.” ");
INSERT INTO hrw_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Biing Yesus e sesngeni e sunwar kia tifre tongge, e gongon ine fan warwar toftof fuunfuun e bala tiin ngo, ku fasi use sinsinangu ri. ");
INSERT INTO hrw_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","I e gongon bingne ine warwar toftof. Biing e ta i tibom tura fan disaipel kia, e pikten ine mara mok tifri. ");
INSERT INTO hrw_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Lo efef lo biing a, e war singre fan disaipel kia, “Kerek la wilo neng e galu.” ");
INSERT INTO hrw_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ri la kosngi e galung kaltu uwa, ri ka la lo mon. E mel e fanenger fan mon ming ri la tura ri. ");
INSERT INTO hrw_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Kif bakir e puek ma panaf e tapii ulo bala mon e sau fatat ma ku fuun ine dan. ");
INSERT INTO hrw_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yesus ulo miu e mon e uriing lo amfatfatar ma ka masun. Fan disaipel kia ri ka fongni ma ri ka war singi, “Titsa o tibi tengis kiar, kiar sau bala maut?” ");
INSERT INTO hrw_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","I e matet ka porow e kif, ma e war singe panaf, “Mele boles, ngo uf.” Kala kif ka met, ma ka la siaro kausi sak. ");
INSERT INTO hrw_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","E war singe fan disaipel kia, “Usi e tamu gam ka soke sak? Gam tibi titinge?” ");
INSERT INTO hrw_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ri soke sak, ma ri ka fagatomnge iri, “Se legii, kif ma panaf ru ka ong singi?” ");
INSERT INTO hrw_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ri kaupakti e Salat Galili, ri ka la ulo nal kere fang Gerasa. ");
INSERT INTO hrw_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Biing Yesus e pu tinglo mon, neng e kaltu tangwaner saksak e sispi, e suu tinglo balang kenit e sa la una tupngeni. ");
INSERT INTO hrw_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Kaltu gii e melmel ilo balang kenit, ma e tek tikas, e fasi una reke ine tiam finau ma sen ming. ");
INSERT INTO hrw_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","E fuunfuun e fam biing ri reke unlimow ma ungkekow ine finfinau ma sen, sakle ambiing nano, i e fusa e finfinau ma sen ilo ungkekow, anwarow i e rawas sak, ma e tek tikas e fasi una bingfamti. ");
INSERT INTO hrw_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Fam panambiing ma fan siat, i e melmel falifu lo balbalamfam ma pakpaklunmale ma ku tengteng kaukaung, ma ku bom tepi e fow ine fatfat. ");
INSERT INTO hrw_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Biing i e pari e Yesus ting tapaksak, i e filau ma ka la kiis pukungkek u famu ini. ");
INSERT INTO hrw_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","I e tau bakir sak, “O bala gow e sa lo yau, Yesus Sikow e Deo aiyat? Limlim ine Deo, ini ou tibi bero yau!” ");
INSERT INTO hrw_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Anwarow Yesus e sau peteng tifi, “Tii tinglo kaltu gii, ona tangwaner saksak!” ");
INSERT INTO hrw_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Kala Yesus ka gatmo, “Sese asam?” I e koso, “Asang gii Mar ma Mar, le kemeu fuunsak.” ");
INSERT INTO hrw_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ma i e ngos lo gatmo e Yesus ini eu tibi tule ri kosngi e male a. ");
INSERT INTO hrw_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Singmat na amfor na bo, ri enen uwa fatatu e mimbet lo paklunmale. ");
INSERT INTO hrw_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ma fan tangwaner saksak a ri ka guna e Yesus aregii, “Tule kemem use re am bo leii. A-uu lo kemem ku kau ilo ri.” ");
INSERT INTO hrw_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","I e a-uu lo ri ma fan tangwaner saksak ri ka suu tinglo kaltu a ri ka la sispi e amfor na bo a, ri ka fafes pu ulo pimpa-i a, ri ka la of pu ulo bala dan ri ka la famautnge. E ngo are e u e mar. ");
INSERT INTO hrw_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Biing fan efefe lo fam bo ri pari e mok gii, ri filau ri ka la peteng tifre tongge ulo taon, ma ulo galu ina male ine taon, ma ri ka sa la una sa par lo sa e sau fuut. ");
INSERT INTO hrw_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Biing tongge ri puek talo Yesus, ri pare kaltu wa, fan tara ri ka sispi ma ka biilbiil e sau pilpiliis, ma kabuk sinangumel, ma ka kiiskiis. Ma biing ri pari, ri soke sak. ");
INSERT INTO hrw_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Fa ri sau pari, ri la peteng tifre tongge ine sa e fespuek lo kaltu tara e sispi. Ma ri ka seseng ming ine fam bo. ");
INSERT INTO hrw_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Biing tongge ri pari e sa e fespuek, ri war rawas singe Yesus ini eu la kosnge male keri. ");
INSERT INTO hrw_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Biing Yesus e bala la lo mon, kaltu lewa tangwaner ka sispi e la guna ini, i eu la tura. ");
INSERT INTO hrw_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Yesus e tibi a-uu lo, safle i e su war singi, “La mil ilo male use keu fumberat, ma o ku la peteng tifri ine sa Taufi e sam gow lo o, ma ine fatengis kia usi o.” ");
INSERT INTO hrw_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ming kaltu a e tofnge una la seseng una Dekapolis ine fan sa Yesus e sam gow lo. Ma tongge ri ka sangfuunfuun. ");
INSERT INTO hrw_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Biing Yesus e la kaupaket mil lo mon ulo neng e galu ilo Salat Galili, singmat na galung tongge ri fang liflifti biing i uwa ulo fow e Salat Galili. ");
INSERT INTO hrw_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Neng lo re fang kaltu bakir lo felun nining asow gii Jairus e fespuek una sa pare Yesus, i e luut ulo fow e ungkekow, ");
INSERT INTO hrw_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ma ka war fangfangteni, “Kek borom fefin e bala met. Kiskam, ya bura ini ou tow e limam ilo usi eu liu.” ");
INSERT INTO hrw_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Kala Yesus ka la nami. Ma tongge fuunfuun ri ka minami, ri fasit liflifti. ");
INSERT INTO hrw_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ma e mel e neng e fefin uwa, ambuunbuunsuu e fuut lo, lo tikii sangful ma e u na matamfaim,. ");
INSERT INTO hrw_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","I e kepe ongker bakir sak, i e ropo e tuba tifre fan dokta ini ku liu, safle anminse e su pupuek bakir sak. ");
INSERT INTO hrw_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Lo biing fefin a e su ong lo Yesus, i e fes tingnami e Yesus falifu lo re tongge ma ka pot lo kolos tapak, ");
INSERT INTO hrw_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","anwarow i e sang aregii, “Le ya ku su pot lo kolos tapak kia yau liu.” ");
INSERT INTO hrw_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ma saupesak ambuunbuunsuu aulo ka rop, ma i ka ongen failmi ulo piramfow ini anminse aulo e sam rop. ");
INSERT INTO hrw_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Saupesak Yesus e parfat ini rawas ulo e sam la. I e didiu mil use re tongge ma ka gatom, “Se e puse lo kolos tapak kiang?” ");
INSERT INTO hrw_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ma fan disaipel kia ri ka war singi, “O pari ini tongge ri fuun a inaisam, ma usi e tamu o ka gatom ini se pot lo o?” ");
INSERT INTO hrw_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Safle Yesus e alal lo ri una par ini se tikin e pot lo. ");
INSERT INTO hrw_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ma fefin a e parfat lo sa e puek lo, i e soke sak ma ka banban ma ka fespuek ka sa luut ulo fow e ungkekow e Yesus, ma ka peteng suupuek ine mara mok e tikin. ");
INSERT INTO hrw_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yesus e war singe fefin a, “Kek fefin, titinge kiam e sau faliunge o. La tura balamaris le mafet kiam e sam rop.” ");
INSERT INTO hrw_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Biing Yesus e gongon uwa fanenger fang kaltu ri fespuek tinglo fel ke Jairus kaltu bakir lo felun nining. Ri ka sa war aregii, “Keu borom fefin e sau met, mele finiilu e titsa.” ");
INSERT INTO hrw_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yesus e ongenufu e sa ri peteng ini tife kaltu bakir lo felun nining ma ka war, “Ou tibi soke, on su titinge.” ");
INSERT INTO hrw_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","I e tibi taufu e tikas una minami sakle Pita, Jeims ma Jon, tualik e Jeims. ");
INSERT INTO hrw_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Yesus e puek ulo male ke kaltu bakir lo felun nining, i e pari e tongge ri selfau ulo male a, tura tineng ulo e bakir sak. ");
INSERT INTO hrw_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","I e kau una fel, ma ka war singri, “Selfau ma tineng gii areini? Boroner gii e tibi met, e su masun.” ");
INSERT INTO hrw_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ma tongge a ri ka su ruur lo. Wimi i e uun suu iri, ma i kam onu e tamow ma tinow e boroner a ma fan disaipel kia, ka la nami, ri ka la kaulek unaisa e boroner a. ");
INSERT INTO hrw_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","I e puse lo limow e borom fefin a ma ka war singi, “Talita Kum,” (pimpiku lo, “borom fefin, ya peteng tifo, matet!”) ");
INSERT INTO hrw_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Saupe sak borom fefin a e ti ma ka fes (i e ta tikii sangful ma eu na matamfaim kia.) Ri sangfuunfuun lo sa ri pari. ");
INSERT INTO hrw_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","I e tow e sunwar rawas tifri, una tibi peteng tife tikas ku parfat lo mok gii, ma i e peteng tifri ini riu tow e ti tuan aiya ku en. ");
INSERT INTO hrw_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesus e la tingwa ma ka la mil ulo anwaran male kia tiim tura fan disaipel kia. ");
INSERT INTO hrw_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Lo biing Sabat e fespuek, i e tofnge una fabenge ulo bala felun nining, fa fuunfuun ri ongni ma ri ka kuufsak ri ka gatom, “Kaltu gii e kepe parfat a ting iya? Sese parfat ri tow tifi, i ka fasi una gow e fan mok na tibou fuut! ");
INSERT INTO hrw_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","E sam ta i ligii e kamda? E sam ta i ligii, sikow e Maria ma tualik e Jeims, Josef, Judas ma Saimon. I e tanga fefnelik ming gii tura kiar?” Ma ri balasak tikin ini. ");
INSERT INTO hrw_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yesus ka war singri, “Profet e mel e asow ilo mara male, sakle ilo anwaran male kia, falifu lo re fesa ma ilo fel kia profet e tek ti asow.” ");
INSERT INTO hrw_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","I e tibi fasi una gow e ti mok na tibou fuut wa, sakle e su tow e limow ulo borom puis kaltu ri mase ka faliungeri. ");
INSERT INTO hrw_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ma i e kuufsak ini e tek ti titinge keri. Ma Yesus ka la fabenge lifit lo fan male. ");
INSERT INTO hrw_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","I e tau ine tikii sangful ma e u na disaipel kia ka la usi, ma i ka uun temtem u iri ma ka tow e rawas tifri una feselufu e fan tangwaner saksak. ");
INSERT INTO hrw_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","I e fatiti ri aregii. “Mele kep ti mok tura o lo fines kiam, sakle tukan. Ma eu tek ti tuan, eu tek ti tang, eu tek ti tubam ilo bala aneueu kiam. ");
INSERT INTO hrw_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ou los lo su kiam, safle ou tibi kepe e u e kolos. ");
INSERT INTO hrw_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ma lo biing ou kau bala ti fel, ou melmel wa kumuut ou la kosngi e male a. ");
INSERT INTO hrw_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ma le tikas ti male ka tibi war a-uu lo gam tam ka tibi ong sing gam, paketufu e ambalbal tinglo kekek mi biing gam la, are peteng fate tifri ini ri guuluung ine sunwar ke Deo.” ");
INSERT INTO hrw_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ri la ma ri ka la sesngeni e sunwar tifre tongge ini ri samusu iksi e balbalri. ");
INSERT INTO hrw_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ri fesel su ire fan tangwaner fuunfuun, ma ri tow e wel ilo tongge fuunfuun ri mase ma ri ka faliungeri. ");
INSERT INTO hrw_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","King Erot e ong lo mok gii, anwarow asow e Yesus e suupuek malal. Fa ri war, “Jon kaltu una gugu tarawen, e mel e rawas ilo una bilseni e fan mok na tibou fuut, anwarow i e sau matet mil kosnge minet.” ");
INSERT INTO hrw_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Fa ri war, “I Elaisa.” Ma fa ri war, “I na profet, e ngo are fam profet tingna ngen.” ");
INSERT INTO hrw_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Safle biing Erot e ong lo mok gii, i e war, “Jon, kaltu ya tespakti e angkiimkiim aiya, e sau matet mil kosnge minet.” ");
INSERT INTO hrw_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Erot tibom e tow e sunwar una pusefamti e Jon ma i e rekfamti ma ri towfu ulo rerek. I e gow e mok gii, anwarow lo Erodias, wok ke tualik Filip, i e tili famu. ");
INSERT INTO hrw_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Jon e war singe Erot, “E tibi riis use fan fafanau ini o tili e wok ke tuamlik.” ");
INSERT INTO hrw_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Erodias e balasak tikin ine Jon e bura ini eu paketmet ini, safle i e tibi fasi una gow, ");
INSERT INTO hrw_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","anwarow Erot e sokeni e Jon, ka fakale lo, i e parfat lo ini e riis ma e ta kaltu pepe. Biing Erot e ongni e Jon e war singi, i e sangfuunfuun, safle i e su fefeal una ongne singi. ");
INSERT INTO hrw_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Wimi e mel e konona biing ke Erodias e puek, ri sangfi e biing Erot e fuut. I e gow e en tura ge lamlam, ma ge lamlam lo re ge na fapaket ma tongge lamlam tingna Galili. ");
INSERT INTO hrw_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Biing fefin ke Erodias e kaulek ka guui, fefin a e terngeni e bala e Erot ma ge lamlam ulo en a. King ka war singe borom fefin a, “Gatom yau use sese ti mok o bura ma ya ku tow tifo.” ");
INSERT INTO hrw_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ma ka limlim tifi, “Tikin sak ow gatom yau ine ti mok, yau tow tifo, le oku peteng ini o bura e ti galu lo ninsiang ilo bala kepmale kiang, yau tow.” ");
INSERT INTO hrw_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","I e la suu ma ka war singe tinow, “Sa yau gatom usi?” Ma tinow ka war, “Paklu e Jon kaltu na gugu tarawen.” ");
INSERT INTO hrw_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Saupe sak fefin a e saupe ka la unaisa e king tura fabur kia. “Ya bura ini ow tow tif yau gii sekit e paklu e Jon ilo bala ti dis.” ");
INSERT INTO hrw_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","King ka sangfuufuun tikin, ma ka sangkuuluung, safle anwarow lo limlim kia na matre ge lamlam kia ulo inen, i e guuluung una onguf singe fefin a. ");
INSERT INTO hrw_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","I e saupesak ka onu e kaltu na tetes pakpaklung kaltu, tura sunwar una kepmil ine paklu e Jon. Kaltu a e la, ka la teseni e paklu e Jon ulo felun rerek, ");
INSERT INTO hrw_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ma ka kepmil ine paklu ulo bala dis. I e tow tife fefin a, ma fefin a ka tow tife tinow. ");
INSERT INTO hrw_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Biing ri ong lo, fan disaipel ke Jon ri puek ri ka la kepe punumfow ma ri ka la towfu ulo ampolo. ");
INSERT INTO hrw_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Fan apostel ri tiim falifit ine Yesus, ma ri ka peteng tifi ine mara mok ri sam gow ma ri sam fabenge ini. ");
INSERT INTO hrw_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","I ka war singri, “Gam kasa nami yau gam tibom kiar ku la ilo ti mok e tek tikas ilo, gam ku la kepe ti boron manau.” Anwarow tongge fuunfuun ri mil faliu ka la tek ti sol keri una en. ");
INSERT INTO hrw_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ri tibom ri ka la lo mon ulo mok e tek tikas ulo. ");
INSERT INTO hrw_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Safle tongge fuunfuun ri la iliim ri, ma ri ka filau tinglo fan male keri, ri ka la puek famu iri. ");
INSERT INTO hrw_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Biing Yesus e masa ma ka pari e galung kaltu bakir sak, bala e la kuuluung sak usi ri, anwarow ri ngo are fan sipsip e tek ti efefe keri. I e tofnge una fabenge singri lo mara mok. ");
INSERT INTO hrw_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Biing pisii e sau bala suu fan disaipel ri ka puek ta lo. Ri ka war singi, “Kiar ilo biilkap legii, ma e sau bala or. ");
INSERT INTO hrw_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Uunre tongge a ri ku la, usi riu la ilo fan male fatat ri ku la feli e ton tuan una en singri.” ");
INSERT INTO hrw_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Safle i e koso singri, “Gam tow e ti mok una en singri.” Ri ka war singi, “Eu kepe e wal e funiil ke kaltu una kepe fimfiil kia una feli e ton tuan are ge gii. Areni, kiar u bas ine fimfiil ming gii lo beret, ma kiar ku tow tifri una en?” ");
INSERT INTO hrw_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yesus e gatom ri, “E fis e beret ami? La par.” Biing ri la sik ri pari, ri kasa peteng, “E lim e beret ma e eu e fis.” ");
INSERT INTO hrw_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Kala Yesus ka peteng tifri una uunre tongge ri ku kiis lo fam forfor ilo garas makrau. ");
INSERT INTO hrw_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ri kiis lo fam forfor lo tikii atis ma fa e lim e sangful. ");
INSERT INTO hrw_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","I e kepe e lim e beret, ma e u e fis ma ka par uiat wilo balambat, ma ka aro singe Deo, bingpaki e beret ka tow tife fan disaipel kia, una ti ini lo re tongge. I e ti ming ine um fis lo ri nano. ");
INSERT INTO hrw_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Tongge nano ri tiin en ri ka la sut. ");
INSERT INTO hrw_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ma fan disaipel ri ka sele tiim ine tikii sangful ma e u na dik e fuun lo fan susun beret ma fis. ");
INSERT INTO hrw_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ma ri westiim ire antamat ri en, e ta e lim e mar, ma gelefin ma berberat fuunfuun ming ri en. ");
INSERT INTO hrw_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Saupesak Yesus e uunre fan disaipel kia ri ka la lo mon ri ka la famu una Betsaida, ma i kabi un familre tongge. ");
INSERT INTO hrw_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Wimi ri la kosngi, i e la kanek ulo galu lo paklunmale una la nining. ");
INSERT INTO hrw_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Biing e sam efef, mon e sam ta ulo falifu lo salat Galili ma i tibom uwa una kiin. ");
INSERT INTO hrw_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","I e pari e fan disaipel kia ri tafiis rawas lo mon, anwarow kif e kife ri. E ngo are e fet anmatam pisii lo enene i e la usi ri. I e fes ulo poktow e salat. I e bala fes soliu ri, ");
INSERT INTO hrw_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","safle biing ri pari i e fes ulo poktow e salat, ri sangfi ini kenit. Ri ka la kaung bakir sak, ");
INSERT INTO hrw_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","anwarow ri nano ri pari, ma ri ka soke sak ini. Saupesak i e gon sing ri. “Balamas, Yau le gii. Gam u tibi soke.” ");
INSERT INTO hrw_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Kala Yesus e kau ulo bala mon tura ri ma kif e met, le ri su la sangfuunfuun, ");
INSERT INTO hrw_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","anwarow ri tibi pauti e bala tikin e fafen a Yesus e gow lo e lim e mar na tamat. Balbalri e kut. ");
INSERT INTO hrw_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Biing ri kaupaket ri of masa una Genasaret ma ri sangfamti e mon wa. ");
INSERT INTO hrw_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Biing ri pu tinglo mon saupesak tongge ri sam ilmi e Yesus. ");
INSERT INTO hrw_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ri filau ka la ulo male kiruur una kepre tongge ri mase lo fan ngiin ri ka la ulo male ri ong ini i ulo. ");
INSERT INTO hrw_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ma sese male i e la ilo, ilo taon, tam keptin male, ri taufre tongge ri mase ulo fan male na tiim. Ri gatom rawas ini riu su puse lo anisow e kolos tapak kia. Ma seri a ri puse lo, riu liu. ");
INSERT INTO hrw_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Fam Farasi ri keptiim iri tura fa lo re fan titsa lo fafanau. Ri ka la tingna Jerusalem, ri kasa puek ri ka la pari e Yesus. ");
INSERT INTO hrw_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ma ri pari e fa lo re fan disaipel kia ri en tura limlimri e tibi kalkaliis. ");
INSERT INTO hrw_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Fam Farasi ma fan Juda nano, ri ususi e ninis kere tumtumlari. Le riu tibi gua fakausi e limlim ri, riu tibi en. ");
INSERT INTO hrw_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Biing ri mil tinglo male na umat ma ri ku tibi fagu, ri tibi fasi una en. Ma ri usi e fan nenger fan sinang fuunfuun ming, ri sam kepe singre tuptup ri, aregii. Riu gugua e fang kap, fan sospen ma fan dis.) ");
INSERT INTO hrw_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ma fam Farasi ma fang titsa lo fafanau, ri ka gatmo e Yesus aregii, “Usi e tamu gii fan disaipel kiam ri ka tibi ususi e fan ninis kere tuptuprer, limlim ri e tibi kalkaliis ma riu su en?” ");
INSERT INTO hrw_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ma Yesus ka peteng tifri aregii, “Aisaiya e sam war warfot lo gam tikin, ini gam na ge na kepkepe na matam pankii. I e sam seti e sunwar kia aregii, ‘Tongge gii ri resresnge yau ilo ngusngusri ri, safle balbalri ma singnanguri e sinsinanguri e ta tapak i yau. ");
INSERT INTO hrw_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ri nining fofoes lo yau, sakle fam fabenge keri, e su ta fam fabenge ke kaltu.’ ");
INSERT INTO hrw_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Gam sangintafngi e fafanau ke Deo ma gam ka puse raw lo ninis kere tongge.” ");
INSERT INTO hrw_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ma Yesus ka war singri ming aregii, “Gau parfat sak una sangeufu e fam fafanau ke Deo. Ma gam ka usi e sinangumi tibom. ");
INSERT INTO hrw_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moses i sam war, ‘O samusu nawen singe tamam ma tinam, ma kaltu e gow e sunwar saksak talo tamow ma tinow e samusu met.’ ");
INSERT INTO hrw_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Sakle gam war aregii, ‘Le ti kaltu ka mel e mani tam sa una ulsi e tamow ma tinow, sakle kusu peteng tifru “mani gii ya sau fagati una tow tife Deo.” ");
INSERT INTO hrw_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Kaltu gii eu tibi gow e ti mok una ulsi e tamow ma tinow.’ ");
INSERT INTO hrw_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Aregii gam ususi e ninis kemi gam kepe singe tumtumlami, ma gam ka par pu ine sunwar ke Deo ma gau parfat una gow e fan mara mok aiya.” ");
INSERT INTO hrw_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ma Yesus ka tau ming ine galung kaltu ma ka peteng tifri aregii, “Gam nano ongni e sunwar kiang ma sang kausi. ");
INSERT INTO hrw_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Mok e mel ina male lo tikii kaltu, ma ka kau ina fel lo, e tibi fasi una gow e kaltu ku tibi kalkaliis. E tam, fan mok e mel ina fel lo kaltu, ma ka suu ina male, i mung gii ka gow e kaltu ka tibi kalkaliis.” ");
INSERT INTO hrw_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Wimi Yesus e la kosnge galung kaltu a, ma ka la ulo fel. Ma fan disaipel kia ri ka gatmo use anwarow e sunwar toftof a. ");
INSERT INTO hrw_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ma i ka peteng tifri aregii, “Kemi ming e tek ti sinangumi be? Ya sang ini gam tibi parfat, fan mok e mel ina male lo kaltu ma ka kau ina fel lo, i e tibi fasi una gow e kaltu ku tibi kalkaliis. ");
INSERT INTO hrw_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ya war aregii, anwarow lo fan mok aiya, e tibi la tikin ilo balang kaltu, e tam. E fes ilo sakow, ma wimi kau pu lo fel balik.” (Lo sunwar gii, Yesus e war aregii, lo fan mara tuan e kalkaliis na mata e Deo.) ");
INSERT INTO hrw_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ma Yesus e war ming aregii, “Mok ilo balang kaltu ma ka suu, eu gow e kaltu ku tibi kalkaliis. ");
INSERT INTO hrw_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Anwarow fan sinang a, e la tinglo balang kaltu, i e fan sinang are sangsang saksak, sinang e du, sinang na kinau, ma sinang na paketmet ine kaltu. ");
INSERT INTO hrw_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Ma sinang e du tura fan tinaule, sinang na mer, sinang na bero, ma sinang na gurum, sinang na kayan falek, ma sinang na balasak ma war saksak talo re fa ma sinang na bom resresgneni ma sinang na lomba. ");
INSERT INTO hrw_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Fan mara sinang saksak e mel ilo bala e kaltu ma ka suu, e gow e kaltu ka tibi kalkaliis na anmata e Deo.” ");
INSERT INTO hrw_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yesus e matet ka la kosngi male a, ma ka la ulo taon Tair ma fan male liflifti, ka la kau ulo bala fel. E tibi bura ini tikas eu parfat lo. Safle e tibi fasi una keskum, e tam. ");
INSERT INTO hrw_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Nenge fefin e ong ini Yesus e sam ta wa. Ma fefin a ke tiner e mel e tangwaner saksak e mel ulo. Fefin a e puek saupesak, kasa punungkek fatatu e kekow e Yesus. ");
INSERT INTO hrw_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Fefin a e ta Jentael. I e fuut una Fonisia ilo kaontri Siria, i e sa gatom rawas ine Yesus ini e samusu fesi e tangwaner saksak tinglo ke fefin. ");
INSERT INTO hrw_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ma Yesus ka war singi aregii, “Kemem samusu tow e tuan are berberat famu. Are kemem kam kepe tuan are berat ma kemem ka bas ini tife fam puul.” ");
INSERT INTO hrw_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ma fefin a e koso e sunwar kia aregii, “Taufi, safle fam puul ri mel ilo pikle fate ri ming, ri sikmeru e fan susuntuan are berat.” ");
INSERT INTO hrw_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ma Yesus e war singi, “O fasi una la, tangwaner saksak a, e sam la kosnge sikuam. Anwarow o sam kos fakausi e sunwar kiang.” ");
INSERT INTO hrw_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ma fefin a ka la mil ulo fel ma ka pari e sikow e ngongo ulo ngiin ma tangwaner saksak a e sam la kosngi. ");
INSERT INTO hrw_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Kala Yesus ka la kosingi e galu ina Tair ma ka la ulo galu lo taon Saidon ma ka la sekit ulo galu ina Dekapolis ma ka puek ulo galun salat Galili. ");
INSERT INTO hrw_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ma ri sa tafu e neng e kaltu tifi ambalbalu e kut ma angkermow e sok, ma i e tibi warwar kausi. Ma ri ka gatmo e Yesus una tow e limow ulo kaltu a. ");
INSERT INTO hrw_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ma Yesus ka unu e kaltu a, kala kosing galung kaltu a, ma Yesus ka tow e uang katan limow ulo uam balbalu. Ma wimi Yesus ka kansu e antelen limow tibom, ma ka pot lo angkermow e kaltu a. ");
INSERT INTO hrw_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ma Yesus ka par wiat ulo balambat, ka mangeuf, ma ka peteng tifi e kaltu a aregii, “Efata!” (pimpiku ipiik.) ");
INSERT INTO hrw_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ma saupesak ambalbalu e kaltu a ka ten, ma mok e kali e angkermow ka tamini ma i ka tofnge una war ten. ");
INSERT INTO hrw_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ma Yesus ka war kale re tongge, ini riu tibi peteng tife tikas ine mok gii ri ka pari. I e war kale ri tikin. Safle e tam. Ri raw tibom una peteng ine sunwar a. ");
INSERT INTO hrw_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ma tongge a ri ka ongni e sunwar a ri kuufsak tikiin ma ri ka war, “Fan mara mok e gow e terernge ri, e gow e balbaluri kut ri ka fasi una ong, ma ngusngusri ri kut ri ka war.” ");
INSERT INTO hrw_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Lo biing a, tongge ri sa tiin mil ma e tek ti tuan ari, ma Yesus ka tau ine fan disaipel kia ri ka puek. Ma ka peteng tifri aregii, ");
INSERT INTO hrw_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ya tengis re tongge gii, anwarow ri melmel tura yau lo e tuul e biing. Ma e tek ti tuan una en sing ri. ");
INSERT INTO hrw_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Le ya ku tule familri wilo fan fel keri ma ri ka biis, matmat ri eu la belbelil ma ri ku luut ailo sal, fa ri sau fes ting tapak ri ka puek.” ");
INSERT INTO hrw_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ma fan disaipel kia ri ka koso aregii, “Safle kiar i tapak ine taon. Ma kiar ku kepe beret ting iya, una fenre tongge gii?” ");
INSERT INTO hrw_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yesus ka gatom ri, “E fis e beret ami aiwa?” Ma ri ka koso, “Baba fis.” ");
INSERT INTO hrw_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Yesus ka war singri una kiis ilo nal. Ma ka kepe baba fis na beret a, ka katfarsi e Deo, ma ka paekpaki ka tow tife fan disaipel kia una fasa ini lo re tongge. ");
INSERT INTO hrw_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ma ri mel lo tom boron fis ming. Ma Yesus ka katfarsi e Deo ma ka uunre fan disaipel kia una fasa ini lo ri. ");
INSERT INTO hrw_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Biing tongge ri en ri kala suut, wimi, fan disaipel ri kam bastiim ine fan susuntuan ari talo baba fis na dik. ");
INSERT INTO hrw_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","E ngo are e fet e mar na tamat ri puek, wimi i kam tulen ri ka la, ");
INSERT INTO hrw_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ma ka kiis ulo mon tura fan disaipel kia. Ma ri ka la ulo galu lo male Dalmanuta. ");
INSERT INTO hrw_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Fam Farasi ri puek ri ka sa tofo e Yesus. Ri ka gatmo ini eu bilseni e ti tintof tinglo balambat. ");
INSERT INTO hrw_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yesus e ongni e mafet ulo bala ma ka war, “Anwarow lo sa kulu lo biing gii, ri ka gatom una pari e ti tintof? Ya peteng tikin tif gam, ri tibi fasi una pari e ti tintof, e tam sekit.” ");
INSERT INTO hrw_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ma i ka la kosing ri ka la kiis mil lo mon, ma ka la ulo galu lo salat Galili. ");
INSERT INTO hrw_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Fan disaipel kia ri sangintafngi una kepe ti tuan ari. Sakle mel e tikii beret uwa ulo bala mon. ");
INSERT INTO hrw_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ma Yesus ka war rawas singri aregii, “Gam u ate use is kere fam Farasi ma Erot.” ");
INSERT INTO hrw_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Fan disaipel ri fagon faliu i ri tibom aregii, “I e gow e sunwar ngan gii, anwarow e tek ti beret.” ");
INSERT INTO hrw_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesus e parfat lo fawar a ri gow. Ma ka war singri aregii, “Areni gam ka fagon aiya? E tek ti beret arer? Ya sang ini gam tifik ten. Ya sang ini balbalmi e kut be? ");
INSERT INTO hrw_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","E mel e matmat mi sakle gam tibi parpar, e mel e balbalumi sakle gam tibi ongong? Gam sam sangintafngi, be? ");
INSERT INTO hrw_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Biing ya pakii e lim e beret lo e lim e mar na tamat, e fis e dik gam sengi lo fan tuan e ngo sok?” Ri ka peteng tifi, “Sangful ma eu.” ");
INSERT INTO hrw_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Ma lo biing ya pakii e baba fis na beret lo e fet e mar na tamat, gam sengi e fis e dik lo fan sun tuan e ngo sok?” Ma ri ka koso, “Baba fis na dik.” ");
INSERT INTO hrw_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","I ka war singri aregii, “Gam tifik parfat?” ");
INSERT INTO hrw_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yesus tura fan disaipel kia ri la fespuek ulo male Betsaida, ma fa fan tongge ri ka tow e neng e kaltu tifi, anmata e kut. Ma ri ka peteng tifi e Yesus ini eu tow e limow ulo kaltu a. ");
INSERT INTO hrw_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesus e puse lo limow e baf a, ma ka onu ru ka la ulo galu una male ine keptin male a, ma biing e kansu e anmata, ma ka tow e limow ulo ma ka gatmo aregii, “O pari e timok, tam e tam?” ");
INSERT INTO hrw_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ma kaltu a ka par ma ka war aregii, “Ya pari e tongge sakle ya pari are fan au ri fes ri kala.” ");
INSERT INTO hrw_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ma Yesus ka tow mil e limow ulo anmata ma kaltu a ka par rawas mil. Ma anmata ka kausi mil ma ka pari e fan mara mok nano e la fespuek ten. ");
INSERT INTO hrw_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ma Yesus ka onu ka la mil ulo ke fel ma ka fanow, “Ou tibi la ilo male a.” ");
INSERT INTO hrw_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesus e matet tiim tura fan disaipel kia, ma ri ka la ulo male fatatu e taon Sisaria Filipai. Ma ulo sal e am la gatmo e fan disaipel kia aregii, “Tongge ri petpeteng ini yau se tikin?” ");
INSERT INTO hrw_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ma ri ka koso singi aregii, “Fa ri peteng aregii, o Jon kaltu una gugure tongge. Ma fa ri ka war, o Elaisa, ma fa ri ka peteng ini o na profet.” ");
INSERT INTO hrw_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ma Yesus ka gatom ri aregii, “Ma gam tibom gau peteng ini yau se?” Ma Pita ka koso e sunwar kia aregii, “O na Mesaiya.” ");
INSERT INTO hrw_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ma Yesus ka fanauri ini riu tibi peteng tife tikas ini i se. ");
INSERT INTO hrw_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Yesus e tofngeni e fabenge kia tifre fan disaipel kia aregii, “Sikow e Kaltu e samusu kepe fan mara ongker. Tongge lamlam, fam paklure fam pris ma fang titsa lo fafanau riu gilmeufu ma ri ku pakti ku met. Ma lo biing baba e tuul i eu matet mil.” ");
INSERT INTO hrw_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","I e peteng ten tifri aregii, ma Pita ka onu e Yesus ka la ulo galu, ma ka la porow. ");
INSERT INTO hrw_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ma Yesus ka didiu mil use fan disaipel kia, ma ka porow e Pita aregii, “Satan on la mil u nami yau. O tibi usi e sinangu e Deo, e tam. O su usi e sinsinangure e tongge mung.” ");
INSERT INTO hrw_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ma Yesus e tau tiim ire tongge tura fan disaipel kia ri ka sa la usi, ma ka peteng tifri aregii, “Le ku mel e tikii tikas eu fabur una mi nami yau, i e samusu faporo e fabur kia tibom. Ma e samusu kepe aupaket kia ma ku usi yau. ");
INSERT INTO hrw_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Anwarow le sese ti kaltu a ka sangsang una bingfamti e ninliu kia tibom, ninliu kia eu tam ini. Safle se a ku fafen ine ninliu kia usi yau tura konona sunwar, i eu kepfamila e ninliu kia. ");
INSERT INTO hrw_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Sese kausi le kaltu ku kepe mara mok nano gii lo nal, sakle ninliu kia tibom eu tam ini? ");
INSERT INTO hrw_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Kaltu e tibi fasi una tow e fimfiil una fiil famila e ninliu kia. ");
INSERT INTO hrw_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Le tikas ku maiyai lo yau ma kek sunwar gii lo inlen na fapue ma tumtubiil gii, Sikow e Kaltu eu maiyai lo, lo biing i eu puek tura finaswen ke Tamow, tiim tura fan anggelo riis kia.” ");
INSERT INTO hrw_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ma Yesus ka peteng aregii tifri, “Ya peteng tikin tif gam. Fa lo re tongge gii ri ka titi gii riu tifik met, ku muut riu pari e Kepmale ke Deo eu fespuek tura singmat na rawas kia.” ");
INSERT INTO hrw_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Wimi ine e on e biing Yesus e onu e Pita, Jeims ma Jon ri ka la ulo paklunmale e kanek sak. Ma ri tibom ri ka melmel. Ma sumbiing a ri pare fow e Yesus e ikis ka puek ka ngo kuriik. ");
INSERT INTO hrw_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Malu e fespuek ka murmur sak are anten. E tek ti kaltu gii lo nal eu fasi una gow e ti kolos ku murmur aregii. ");
INSERT INTO hrw_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ma Elaisa tura Moses ru puek nanmatri, ru ka sa gongon singe Yesus. ");
INSERT INTO hrw_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pita e pari fan mok a ma ka peteng tife Yesus aregii, “Titsa, e kausi kiar ka ta gii. Kemtuul fasi una gow e tuul e kak. Neng kiam neng ke Moses ma neng ke Elaisa.” ");
INSERT INTO hrw_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pita e tibi parfat ini are eu war, usi ri tuul soke sak. ");
INSERT INTO hrw_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Kala pambalbal ka fespuek ka afit ri. Ma neng e angkiimkiim tinglo bala pambalbal a, e war aregii, “I gii e sikuang ya bura sak. Gam u ongong singi.” ");
INSERT INTO hrw_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Saupesak ri ka par falek, ma ri tibi au par tikas tura ri. Safle Yesus tibom tura ri. ");
INSERT INTO hrw_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ri ding tinglo paklunmale, ma Yesus ka fanauri aregii, “Gam u tibi peteng tife tikas ine mok gam sau pari. Ku muut lo biing Sikow e Kaltu eu matet mil kosnge minet.” ");
INSERT INTO hrw_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ri ka kepfamteni e sunwar a, ma iri ka fawar u falifu iri tibom aregii, “Sunwar gii, matet mil kosnge minet, e ta sa?” ");
INSERT INTO hrw_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ma ri ka gatmo e Yesus aregii, “Usi e tamu fang titsa lo fafanau ri ka petpeteng ini Elaisa e buk puek?” ");
INSERT INTO hrw_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yesus ka koso e singri aregii, “Sunwar a e tikin, Elaisa e samusu puek famu una fariis famila e fan mara mok. Sakle areini lo sunwar gii lo buk ke Deo ka peteng Sikow e Kaltu e samusu kepe mara ongker, ma ini tongge ri ku fotpursi? ");
INSERT INTO hrw_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Sakle ya peteng tif gam aregii, Elaisa e sau puek. Ma tongge ri ka usi e fabur keri tibom ri ka gow e fan mara sinang lo, are sunwar e mel ilo buk ke Deo.” ");
INSERT INTO hrw_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Biing Yesus tura e tuul neng lo re fan disaipel kia ri la puek talo re fa lo ri, ri ka pari e singmat na galung kaltu ri fang liflifit ri, ma fa lo re fan titsa lo fafanau ri ka fafatinge tura ri. ");
INSERT INTO hrw_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Biing tongge nano gii ri pari e Yesus e puek, ri la faof sak usi, ri ka filau ri ka la areni. ");
INSERT INTO hrw_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yesus ka gatom ri, “Gau fafatinge use sa?” ");
INSERT INTO hrw_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Nenge kaltu una balri ka koso aregii, “Titsa, ya sa tow e sikuang tifo. Tara saksak e sispi ka tibi warwar. ");
INSERT INTO hrw_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Biing eu fuut lo, eu bas ini lo nal ku la busbus e ngusu, ma ku la gekgek e ngisngisa. Ma kamu la rawas sok. Ya gatom re fan disaipel kiam una pete na tara lo, sakle ri tibi fasi.” ");
INSERT INTO hrw_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yesus e ongni e sunwar a, ka war singri aregii, “Gam na kulu na tibi titinge, sinangumi ma ninis kemi e tibi kausi, e sak sekit. E fis e biing yau melmel tura gam? Ma e fis e biing ming yau kepe mafet tura gam? Gam tow e boroner a wagii!” ");
INSERT INTO hrw_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ri ka tow e boroner a tifi. Ma biing tara saksak e pari e Yesus, i e saupesak ka belbel ine boroner a ka luut ufaf ka la kiitkiit lala, ma ka la suusuu e bus na ngusu. ");
INSERT INTO hrw_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesus ka gatmo e tamow e boroner a, “I e melmel aregii tingnangis?” Ma tamow ka koso aregii, “Tofnge tinglo biing e balik uwa. ");
INSERT INTO hrw_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Toneng tom biing eu bas ini talo bala iif tam bala dan una pete met ini. Ma le o ku fasi una gow e ti mok, on tengis kemem ma o ku ules kemem.” ");
INSERT INTO hrw_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesus ka war aregii, “O gatom ini, le ya ku fasi? E tek ti mok eng kala singe kaltu e mel e titinge kia.” ");
INSERT INTO hrw_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ma saupesak tamow e boroner a ka tau aregii, “Ya titinge, safle titinge kiang e pospos, o samusu ules yau.” ");
INSERT INTO hrw_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Biing Yesus e pari e tongge fuunfuun ri filau una la par, i ka porow e tara saksak a aregii, “Ona tangwan ngusu kut ma balbalu kut Ya peteng tifo, o samusu tii kosnge boroner gii, ma o mu tibi sispi mil.” ");
INSERT INTO hrw_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ma tara saksak a ka la kaung ma ka bele saksak ine boroner a, ma ka la kosngi. Ma boroner a kasu la ngosok are e sau met, iya fa fuunfuun ri ka peteng ini e sau met sekit. ");
INSERT INTO hrw_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Safle Yesus e puse lo limow ma ka famtete ka ti. ");
INSERT INTO hrw_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Wimi Yesus ma fan disaipel kia, ri tibom ri melmel una fel ma ri kam gatmo aregii, “Usi e tamu, kemem ka tibi fasi una feselufu e tara saksak lewa?” ");
INSERT INTO hrw_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ma i ka peteng tifri, “Sinang una nining tibom e fasi una tii ine matan tangwaner aiya, e tek tikas ti sal ming.” ");
INSERT INTO hrw_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ri ka la kosnge male a ma ri ka fes ulo male Galili. Yesus e tibi bura ini tikas ini eu parfat ini ri uya, ");
INSERT INTO hrw_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","anwarow, i e fabenge singre fan disaipel kia, ka peteng tifri aregii, “Sikow e Kaltu riu solamufu ku la ilo limre tongge, ri ku paketmet ini. Ma lo biing baba e tuul i eu matet mil.” ");
INSERT INTO hrw_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Sakle ri tibi pauti e pimpiku e sunwar Yesus e peteng ini tifri, ma ri soke una gatmo usi. ");
INSERT INTO hrw_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ri ka sa puek una Kapenaum. Ma biing ri ka ta ulo bala fel, Yesus ka gatom ri, “Sa lewa leii gau fatinge lala usi ulo sal?” ");
INSERT INTO hrw_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Sakle e tet borong sok lo ri, usi ri fatinge lala use se e bakir. ");
INSERT INTO hrw_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yesus ka kiis uf ma ka tau ine tikii sangful ma eu na disaipel kia usi ma ka war, “Le tikas ku bur famu, i e samusu mi sekit, ma ku ta kaltu na faules singri nano.” ");
INSERT INTO hrw_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","I ka onu e neng e boroner ma ka sa fetiufu falifu iri, ma ka ofeni, ma ka peteng tifre fan disaipel kia aregii, ");
INSERT INTO hrw_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Sese kaltu e areni e boroner are boroner gii lo asang, i e are yau, ma se a ka are yau, e tibi are yau mung, safle i e areni ming e se gii tule yau.” ");
INSERT INTO hrw_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jon e war, “Titsa, kemeu pari e kaltu e fesi e fan tara saksak lo asam, ma kemem ka peteng tifi ini eu manau, anwarow e tibi ta ilo kiar.” ");
INSERT INTO hrw_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yesus ka war singri, “Mele warkali, le tikas ku gow e ti mok na tibou fuut lo asang, wimi i e mu tibi fasi una war ine ti mok saksak saupe una bero yau. ");
INSERT INTO hrw_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Sese kaltu a ka tibi is kiar e ta ilo kiar. ");
INSERT INTO hrw_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ya peteng tikin tif gam, sese kaltu eu tow e dan mair tif gam lo asang, anwarow gam ke Kristus, i eu kepe fimfiil. ");
INSERT INTO hrw_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Le tikas ku gow e ti boroner gii ka titinge lo yau ma ku luut lo tubiil, i eu kepe mafet e bakir iyat, le ri ku kawi e ti fat bakir ilo angkongkongow ma ri ku fauli ina kasap. ");
INSERT INTO hrw_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Le limam ku tatfe o wilo tubiil, tese pakti. E fasi ini ou tuk ma o ku la ilo male na ninliu are ka u e limam ma o ka la ilo male na ongker iya iif e tibi metmet. ");
INSERT INTO hrw_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Le kekem ku tatfe o wilo tubiil tese pakti. E fasi ini ou tuk ma o ku la lo male na ninliu, are ka u e kekem ma o ka la ilo male na ongker. ");
INSERT INTO hrw_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ma le anmatam ku tatfe o wilo tubiil, o samusu sipil ufu. E kausi sak ini eu mel e tikii anmatam ma o ku la lo Kepmale ke Deo, are ka u e anmatam, ma ri kau bas i o lo male na ongker, ");
INSERT INTO hrw_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","iya ‘fang kirkiriaf lo ri ka tibi metmet, ma iif ilo ka tibi fasi una met.’ ");
INSERT INTO hrw_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Ri towtow e semek ilo fan mara finafen una gow ri ku kalkaliis na mata e Deo. Are mafet e puek are iif, una tererngere tongge. ");
INSERT INTO hrw_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Tiif lo semek e kausi, sakle le ku rop e tiif lo, are eu gow ku semek mil? En samusu mel e tiif lo gam, ma gam ku melmel tura balamaris falifu i gam.” ");
INSERT INTO hrw_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesus e matet ka la kosnge male a, ka la ulo galu ulo distrik Judia ma ka la ulo galu lo Dan Jodan. Ma tongge fuunfuun ri kasa tiim mil tura ma ka usi e ninis kia una sesngeni e sunwar kia tifri. ");
INSERT INTO hrw_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ma fam Farasi ri ka sa la use Yesus ri bur sa tofo ri ka gatmo aregii, “Fafanau kiar e awuu lo kaltu e fasi una kalafeni e ke wok, tam e tam?” ");
INSERT INTO hrw_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yesus ka koso e gatgatom keri aregii, “Moses e tow e sese fafanau tif gam?” ");
INSERT INTO hrw_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ri ka war, “Moses e a-uu lo kaltu e fasi una seti e pampel una kere antinaule ku tow tife fefin a ma ku onu ku la.” ");
INSERT INTO hrw_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Sakle Yesus e peteng tifri aregii, “Gam na tongge balbalmi e kut, ilea Moses kam seti e fafanau a ka tow tif gam. ");
INSERT INTO hrw_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ong! Nangen sak biing Deo e fafuutngeni e fan mara mok, i e gow e tamat ma fefin. ");
INSERT INTO hrw_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Aregii kaltu ka la kosnge tamow ma tinow kasa tiim tura ke wok, ");
INSERT INTO hrw_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ma ru ka ta tikii foru, ma ru kamu tibi melmel are ru, E tam. Ru puek are tikii foru. ");
INSERT INTO hrw_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Aregii mok Deo e sam war famti, kaltu e tibi fasi una kere.” ");
INSERT INTO hrw_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Wimi Yesus ma fan disaipel kia ri ka la mil ulo fel, ma ri ka la gatmo use sunwar lo kere antinaule. ");
INSERT INTO hrw_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ma ka peteng tifri aregii, “Le kaltu ka fingeni e ke wok, ma ka la tili e neng e fefin, kaltu e e sam tubiil lo ke wok, ma e sam gow e sinang na faet falek. ");
INSERT INTO hrw_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Male fefin ku fingeni e ke matuk ma ku la tili e neng e kaltu, fefin a e gow e sinang na faet falek.” ");
INSERT INTO hrw_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Tongge ri la tura berberat keri use Yesus. Ri bura ini eu la pose lo ri, sakle fan disaipel kia ri pari, ri ka war paket singri. ");
INSERT INTO hrw_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yesus e pari, ma bala ka sak, ka peteng tifre fan disaipel kia aregii, “Gaman tauf re berat ri ku sa la usi yau. Gam u tibi kale ri. E tam. Kepmale ke Deo e ta kere matang kaltu are berat gii. ");
INSERT INTO hrw_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ya peteng tikin tif gam, le ti kaltu ku tibi kepe e kepmale ke Deo, are berberat gii, eu tibi fasi una la kau ilo. E tam sekit.” ");
INSERT INTO hrw_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ma ka kepe re berberat a ka tow e limow ulo ri ma ka war fakausi ri. ");
INSERT INTO hrw_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesus ka matet ka la, ma neng e kaltu ka filau puek kasa pukungkek na mata, ma ka gatmo aregii, “Konona titsa, yau gow e sa usi yau kepe ninliu bingne?” ");
INSERT INTO hrw_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesus ka peteng tifi aregii, “Usi e tamu o ka foteng yau ini ya kausi? Deo i tibom e kausi. ");
INSERT INTO hrw_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","O sau parfat lo sunwar lo fafanau. Gam u tibi paketmet ire tongge. Gam na fatfat maksi, gam u tibi gow e sinang na faet falek, gam u tibi kinau, gam u tibi gurum ma sesuupuek fofoes ire tongge. Gam u tibi fasorom ma es fofoes ine fan mok kere fa. Gam samusu nawen singi e tautaumi ma tintinmi.” ");
INSERT INTO hrw_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ma kaltu a ka peteng tife Yesus aregii, “Titsa, biing ya boroner uwa ka sa muut gii, ya ususi e fan fafanau nano gii.” ");
INSERT INTO hrw_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesus e bura sak ka par usi ma ka peteng tifi aregii, “O pospos aiwa lo tikii mok. Ou la umat ine fan mok kiam, ma mani o ka kepe o samusu tow tifre tongge sasngal. Ou gorot aiya, usi ou mel e konona tubam tikin ilo balambat, ma o ku usi yau.” ");
INSERT INTO hrw_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Kaltu a ka ongne sunwar gii, ka la par saksak e mata ma ka la sang kut ma ka la, anwarow, tuba e bakir tikin. ");
INSERT INTO hrw_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ma Yesus ka par use re fan disaipel kia ma ka war, “Tongge tuba mel, e tuntun sak singri una la kaulek ilo kepmale ke Deo.” ");
INSERT INTO hrw_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ma fan disaipel ri ka kuufsak lo sunwar kia. Sakle Yesus e peteng tifri ming aregii, “Berat, e tuntun sak singe kaltu una kaulek ilo kepmale ke Deo, eu faim tuntun. ");
INSERT INTO hrw_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","E tikin e tuntun singe kamel una los ilo amfur lo nil na somsomap, sakle e tuntun tikin iyat singe kaltu tuba mel una kaulek ilo bala kepmale ke Deo.” ");
INSERT INTO hrw_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Fan disaipel ri ka kuufsak tikin ri ka fawar falifu iri tibom aregii, “Le ku ngo aiya, ma se gii kamu su fasi una kau ilo ninliu bingne?” ");
INSERT INTO hrw_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ma Yesus ka par usi ri ma ka war, “Kaltu tibom e tibi fasi. Sakle Deo e fasi. Deo e fasi una gow e mara mok.” ");
INSERT INTO hrw_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pita ka peteng tife Yesus aregii, “Par, kemem sam la kosnge mara mok ma kemem ka mi nami o.” ");
INSERT INTO hrw_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ma Yesus ka war, “Ya peteng tikin tif gam, kaltu eu la kosnge fel, tam tanga tualik, tam tanga fefnelik, tam tinow, tam tamow, tam berberat kia, tam fam palang kia, usi yau ma konona sunwar, ");
INSERT INTO hrw_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","kaltu a eu kepe atis ming ilo poktow e fan mok a ka la kosngi biing i e melmel gi wa gii lo nal, anwarow Deo eu feni ine fan mok fuunfuun tikin, iyat ine fan mok i e mel lo famu. I eu kepe fam fel fuunfuun eu fuun e fan tualik fam fefnelik fan tintinow fan siksikow ma fam palang fuunfuun. Ma ming tongge riu isa. Ma lo biing e mu puek wimi, i e mu kepe ninliu kausi bingne. ");
INSERT INTO hrw_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Sakle tongge a ri ka kep bakir lo ri gii, riu mi. Ma seri gii ri ka mi, riu famu.” ");
INSERT INTO hrw_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yesus tura fan disaipel kia ri fes ulo sal una la una Jerusalem ma Yesus e famfamu lala iri. Fan disaipel kia ri sangfuunfuun ma tongge ri mi nami ri, iri soke. Ka uunre tikii sangful ma e u na disaipel kia ri ka la ulo galu, ma ka peteng tifri mil ine fan mok e mu fuut lo. ");
INSERT INTO hrw_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","I e war aregii, “Kiar u la ina Jerusalem, ma ri ku la solamufu e Sikow e Kaltu tifre fam paklure fam pris ma fan titsa lo fafanau, ma ri ku fakutun aiya una met ma ri kamu tow ilo limre fan Jentael. ");
INSERT INTO hrw_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ri ku tumaru ma ri ku kansu ma ri ku napsi ma ri ku paketmet ini. E tuul e biing wimi i eu matet mil kosnge minet.” ");
INSERT INTO hrw_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Jeims ma Jon un sikow e Sebedi, ru ka sa puek ta lo Yesus ru ka peteng tifi aregii, “Titsa, kama bura ini ou gow e mok gii kama ka bura lo kama.” ");
INSERT INTO hrw_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ka gatom ru aregii, “Kamu bura ini yau gow e sese mok lo kamu?” ");
INSERT INTO hrw_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ru ka peteng tifi, “On tauf kama ina isam. Neng ilo galu miil ma neng ilo galu kais, lo biing ou puek ilo keu finaswen.” ");
INSERT INTO hrw_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Sakle Yesus ka peteng tifru aregii, “Kamu tibi parfat kausi lo mok a kamu ka gatom yau usi. Kamu fasi ming una in lo kap gii ya ka bala in lo, ma amfagu gii ya ku kepe?” ");
INSERT INTO hrw_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ru ka koso singi aregii, “Kama fasi.” Ma Yesus ka peteng tifru aregii, “E tikin, kap gii ya ka in lo kamuw in lo, ma amfagu gii ya ka fagu ini kamu ming kamuw kepe. ");
INSERT INTO hrw_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Sakle se una kiis ilo galu miil ma ilo galu kais lo yau, e tibi ta faim kiang una gow, e tam. Male gii e ta kere fa Deo e sau fagatiufu usi ri.” ");
INSERT INTO hrw_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Biing tikii sangful na disaipel uwa ri ong lo mok Jeims ma Jon ru gatom usi, ri ka balasak iru. ");
INSERT INTO hrw_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yesus ka tau tiim iri ma ka peteng tifri aregii, “Gau parfat ini fam paklure fan Jentael, ri bakir iyat iri, ma ge lamlam keri riu tungen ri una melmel lo pikli ri. ");
INSERT INTO hrw_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Safle gam, sinang a eu tibi mel ilo falifu lo gam, e tam. Kaltu e bura ini eu ta i na kaltu bakir lo falifu lo gam, e samusu ta ina kaltu na faim sing gam, ");
INSERT INTO hrw_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","ma kaltu e bura ini eu ta kaltu na famu i gam, e samusu ta kaltu na faim fofoes kere tongge nano. ");
INSERT INTO hrw_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Anwarow Sikow e Kaltu ming e tibi puek ini tongge ri ku faim singi, e tam. I e puek una faim singri ma ku tow e ninliu kia tibom are fimfiil una fiil familre tongge fuunfuun.” ");
INSERT INTO hrw_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yesus tura fan disaipel ri la puek ulo taon Jeriko. Ma Yesus ka la tingwa tura fan disaipel kia, ri ka la tura singmat na galung kaltu ri mi nami. E mel e baf asow gii Batimes, sikow e Times, e kiiskiis ulo anisow e sal ka su farfaran fan mok ma mani singre tongge. ");
INSERT INTO hrw_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ka ong ini Yesus tingna Nasaret e puek, ka tau rawas sak aregii, “Yesus, Sikow e Dewit, o samusu tengis yau!” ");
INSERT INTO hrw_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Tongge fuunfuun ri ka porow ma ri ka war singi aregii, “Om fakuta e ngusum.” Sakle e su tau bakir sak aregii, “Sikow e Dewit, o samusu tengis yau.” ");
INSERT INTO hrw_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ma Yesus ka ti sok ma ka war, “Tau ini wagii.” Ma ri ka tau ine baf a ma ri ka war singi aregii, “Balam eu su raw. On matet! E tau i o!” ");
INSERT INTO hrw_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ka bas ine ke saket ma ka ti saupesak, ma ka la use Yesus. ");
INSERT INTO hrw_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ma Yesus ka gatmo aregii, “O bura ini yau gow e sa lo o?” Ma baf a ka war singi aregii, “Titsa, ya bura ini yau par.” ");
INSERT INTO hrw_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ma Yesus ka war singi, “La, titinge kiam e sau faliunge o.” Ma saupesak anmata ka par. Ma ka mi nami e Yesus. ");
INSERT INTO hrw_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Biing ri fatat una Jerusalem, ri puek una Betfage ma Betani ulo paklunmale Olif. Yesus e tuleni famu e u neng lo re fan disaipel kia, ");
INSERT INTO hrw_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ma ka war singru, “Kamu la ilo sunmale ai famu. Kamuw kau ilo, kamu ku pari e dongki fuu ri kaweufu, e tifik tikas sekit eng kiis ulo. Pikufu ma kamu ku tat feni wagii. ");
INSERT INTO hrw_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Le tikas ku gatom kamu, ‘Usi e tamu kamu ka pikufu?’ Peteng tifi ini Taufi e bura ma i e mu tuleni mil gii sekit.” ");
INSERT INTO hrw_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ru la ma ru ka la pari e dongki fuu una male ulo sal, ri kaweufu fatatu e matangkon. Biing ru pikufu, ");
INSERT INTO hrw_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","e mel e tongge ri titi uwa ri gatom, “Kamu tamu, kamu ka pikii e dongki fuu a?” ");
INSERT INTO hrw_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ru ka koso aregii Yesus e sau peteng tif ru, iya tongge ri kam tauf ru ka la. ");
INSERT INTO hrw_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Biing ru mil tura dongki fuu tife Yesus, ru bas fan saket keru ulo poktow, ma i kam kiis ulo. ");
INSERT INTO hrw_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Mara tongge ri sosol fang kolos tapak keri ulo sal, ma fa ri sosol teltelen au ri sam tetes tingna mok. ");
INSERT INTO hrw_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Fa ri famu ma fa ri mi ri tiin tautau lala, “Akteni, Deo e warfakausi e se e puek lo asow e Taufi. ");
INSERT INTO hrw_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Deo e war fakausi e kepmale gii ku puek, ke tamrer Dewit! Akteni e asow e Deo!” ");
INSERT INTO hrw_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesus e puek una Jerusalem ka kau ulo Felun Nining Bakir, i e alal fawet lo mara mok, safle e sau bala or, iya kasu lamil una Betani tura sangful ma eu na disaipel kia. ");
INSERT INTO hrw_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Lo biing usi ri ka la tingna Betani, ma Yesus ka la biis. ");
INSERT INTO hrw_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","I e manngeni e au fik e tum, ka la pari ini eu fira. E puek ulo warow ka pari ini e tek ti amfirow, sakle awawu, anwarow e tibi ta biing kia una fira. ");
INSERT INTO hrw_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ma Yesus ka war singe au fik, “E mu tek tikas, eu en tiam fingwam mil.” Ma fan disaipel kia ri ka ongni e ke sunwar. ");
INSERT INTO hrw_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Lo fespuek kia una Jerusalem, Yesus e kau ulo bala balo lo Felun Nining Bakir ma ka tofnge una fesel suu ine fa ri fifiil ma fa ri umat. E ikis paktur ine teibel kere fa na pilpiliis fan mani, ma fam fate kere fa ri umat ine fan man. ");
INSERT INTO hrw_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","E tibi a-uu ine tikas eu kepe ti mok una umat ku sol paket tura ilo bala balo lo Felun Nining Bakir. ");
INSERT INTO hrw_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ma ka fabenge singri, “Ri siitufu be? ‘Kek fel ri fotngi ini fel na nining kere mara male’? Sakle gam gow ka ta fel na keskeskum singre tongge na kinkinau.” ");
INSERT INTO hrw_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Fan paklure fan Pris ma fang titsa lo fafanau ri ongni ma ri ka sik ine ti sal una paketmet ini, usi ri soke, le tongge ri kuufsak lo fam fabenge kia. ");
INSERT INTO hrw_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Lo efef oror, ri suu tinglo bala siti. ");
INSERT INTO hrw_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Lo biingbiing e mok, ri fes lala ri ka la, ri ka pari e au fik e main kiruur. ");
INSERT INTO hrw_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pita ka sangfi e sunwar ke Yesus ma ka war singi, “Titsa, par! Au fik le o ka wiim lo, e sau main.” ");
INSERT INTO hrw_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesus ka koso, “O samusu titinge tikin lo Deo. ");
INSERT INTO hrw_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ya peteng tikin tifo, le tikas ku war singe paklunmale gii ini eu of pu ina kasap, ma ku tibi sang fa-u ma ku titinge lo sunwar kia ini eu fuut, eu fuut aregii i ka peteng. ");
INSERT INTO hrw_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Gii ya peteng tifo, sese mok o gatom usi ilo nining, o samusu titinge ini o sam kepe, ma sa a, eu ta kiam. ");
INSERT INTO hrw_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Le o ka ti o ka nining, ma o ka sangfi e tubiil ke neng tura o, ma o ka balasak aiwa ine neng a, sangintafngi, usi Tamam ilo balambat i eu sangintafngi e fan tubiil kiam.” ");
INSERT INTO hrw_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ri la puek mil una Jerusalem, ma lo biing Yesus ka fes kaulek ulo balo lo Felun Nining Bakir, fam paklure fam pris ma fan titsa lo fafanau ma ge lamlam ri ka la usi. ");
INSERT INTO hrw_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ri ka gatmo, “O gow e mara mok gii lo sese rawas? Ma se tow e rawas a tifo?” ");
INSERT INTO hrw_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesus ka koso, “Yau bi gatom gam ine tikii gatgatom. Gam ku koso sing yau, ma ya kamu peteng tif gam ine sese neng e rawas a, ya ka gow e mara mok gii lo. ");
INSERT INTO hrw_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Amfagu tarawen ke Jon e ta tinglo balambat tam singe kaltu, gau peteng tif yau!” ");
INSERT INTO hrw_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ri fawar usi u falifu iri tibom, ri ka war, “Le kiar ku peteng ini ‘Tinglo balambat,’ i eu gatom, ‘Gii ma e tamu gii gam ka tibi titinge lo?’ ");
INSERT INTO hrw_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ma le kiar ku war, ‘Singe kaltu,...’?” (Ri soke re tongge usi ri nano ri sam tiim parfat ini Jon e ta profet tikin.) ");
INSERT INTO hrw_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ma ri ka koso singe Yesus, “Kemem tibi parfat.” Yesus ka war, “Yau ming ya mu tibi peteng tif gam ine sese rawas a, ya ka gow e mara mok gii.” ");
INSERT INTO hrw_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yesus kam tofnge seseng tifri ming lo warwar toftof, “Kaltu e so e palang na waen ka balo liflifti, ma ka kefi e ampolo una pupul waen, ma kam gow e fel e kiis iyat una parpar kale lo, ma ka towfu tifre tongge na efefe lo, ma ka la ulo neng e male u tapak. ");
INSERT INTO hrw_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Biing e matuk faim, ka tuleni e kaltu na faim kia use re tongge na efefe lo ke palang una la sele lo fan fingfingwan waen tinglo ke palang. ");
INSERT INTO hrw_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Sakle ri bingfamti, ri ka fapaket ini ma ri ka tuleni ka la mil fofoes. ");
INSERT INTO hrw_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Wimi ka tuleni ming e neng e kaltu usi ri, ri ka fisi e kaltu gii lo paklu ma ri ka pete maiyai sekit ini. ");
INSERT INTO hrw_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ka tuleni ming e neng, ma i e neng a ri ka paketmeteni, ka su tuleni ming e fa fuunfuun, fa ri paket ri ma fa ri ka fismetmet iri. ");
INSERT INTO hrw_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“I e mel e su tikii neng uwa una tuleni, sikow tibom gii ka bura sak, i e am tuleni wimi iri nano. Ma ka war, ‘Riu natkeni e sikuang.’ ");
INSERT INTO hrw_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Sakle tongge a, ri fawar iri tibom, ‘Kaltu gii eu kepe e ninsiow e tamow. Kerek pakti ku met ma ninsiow e tamow ku ta kiar.’ ");
INSERT INTO hrw_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ma ri kabuk la tatfeni ri ka la paketmet ini, ma ri ka la bas suu ini una male lo palang. ");
INSERT INTO hrw_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Sa ming gii kaltu ine palang na waen kia kamu gow? I eu su puek ku paket metmet ire tongge a, ma ku tow e palang na waen kia tifre fa. ");
INSERT INTO hrw_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Gam tifik wese e sunwar ke Deo? ‘Fat lewa tongge parfat na bilbilse fam fel ri guuluung ini, e sau puek ka ta warow e fel. ");
INSERT INTO hrw_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Taufi e bilseni aregii, ma e piik sak nan matrer.’” ");
INSERT INTO hrw_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Wimi fam paklure fam pris ma fan titsa lo fafanau ma ge lamlam ri ka sik ine ti sal una bingfamti le ri parfat ini e gow e warwar toftof gii lo ri. Sakle ri soke re singmat na galung kaltu a, ri ka su tafu ma ri ka la kosngi. ");
INSERT INTO hrw_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Wimi ri kam tulere fa lo re fam Farasi ma fa ri ti inami e King Erot usi e Yesus una sormo ku bas saef ine ti sunwar ma ri ku bingfamti. ");
INSERT INTO hrw_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ri sa puek talo Yesus ma ri ka sa war singi, “Titsa, kemeu parfat ini o riis tikin. O tibi se singe tikas anwarow o tibi sang usi ri nase ri, sakle o fabenge ine e sal ke Deo ususi e mok e tikin. E riis una bas mani tife Sisa tam e tam? ");
INSERT INTO hrw_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Kiar u bas fimfiil tam e tam?” Sakle Yesus e sau parfat lo ansinang na balri, ka gatom ri aregii, “E tamu gam ka tofo una lam yau? Gam tow e ti mani a wagii ya ku bi par lo.” ");
INSERT INTO hrw_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ri ka sangau ine mani a tifi, ma kabuk gatom ri, “Tangow e se le gii? Ma panta ke se?” Ri ka koso a, “Ke Sisa.” ");
INSERT INTO hrw_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Kala Yesus ka peteng tifri, “Tow e sa ke Sisa tife Sisa, ma sa ke Deo tife Deo.” Ma ri ka kuufsak singi. ");
INSERT INTO hrw_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Kala fan Sediusi, tongge gii ri ka peteng ini e tek ti matet mil, ri ka puek use Yesus tura neng e gatgatom. ");
INSERT INTO hrw_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Ri gatmo aregii, “Titsa, ilo buk, Moses e siisiit uf tif kiar aregii, ini le ti tualik e ti kaltu ku met kosngi e ke wok, ma ku tifik mel e ti sikow, kaltu a e samusu tili e makos a usi eu mel e sikow e tualik. ");
INSERT INTO hrw_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Gii e mel e baba fis na fatualik, neng baba tikii e tinaule ma ka met ma e tifik mel e ti sikow. ");
INSERT INTO hrw_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Neng baba e u ming e tili e makos a, sakle i ming ka su met ma ka tifik mel e ti sikow. Neng baba e tuul ming e su gorot aiya. ");
INSERT INTO hrw_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Tikin lo. Baba fis na fatualik a, e tek tikas lo ri ek mel e ti sikow singe makos a, sakle wimi sekit makos a ka met. ");
INSERT INTO hrw_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Biing na matmatet mil i eu ta wok ke se gii, le baba fis na fatualik gii ri nano ri tiin tili?” ");
INSERT INTO hrw_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesus e koso mil aregii, “Gam tubiil, anwarow gam tibi parfat lo sunwar tam rawas ke Deo. ");
INSERT INTO hrw_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Lo biing na matet mil singre fan minet ri mu tibi tinaule, riu su la ngo are fan anggelo ilo balambat. ");
INSERT INTO hrw_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ma gii lo sunwar lo re tongge una matet mil, gam tibi wese ulo buk ke Moses e sunwar tinglo iif ulo au? Deo e war singi aregii, ‘Iya na Deo ke Abra-am, Aisak ma Jekop.’ ");
INSERT INTO hrw_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","I e tibi ta Deo kere fan minet, e tam. I e ta Deo kere fa ri liu, gam sam tubiil bakir sak.” ");
INSERT INTO hrw_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Neng lo re fang titsa lo fafanau, ka fespuek kasa ongen ri fafatinge, ma ka ongni Yesus e koskos fakausi e fang gatgatom keri ka sa gatmo aregii, “Ilo fam fafanau nano, sese neng lo ri eu bakir iyat iri nano?” ");
INSERT INTO hrw_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesus e koso aregii, “E su tikii neng e ta iyat iri nano, ‘Ong kausi Israel, Deo Taufi kiar, e su tikiin i, ");
INSERT INTO hrw_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","bura e Deo Taufi kiam ine ambusbusam kiruur, tura tanguam kiruur, tura sinangum kiruur, ma mara rawas kiam kiruur.’ ");
INSERT INTO hrw_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Nenge u aregii, ‘Bura e taltalum, are o bur o tibom.’ E sam tek ti fafanau ek bakir iyat ine uneng gii.” ");
INSERT INTO hrw_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Titsa lo fafanau a ka koso, “O sam war riis titsa, e tikin o ka peteng ini Deo e su tikiin i, ma e sam tek tikas ming, sakle i tibom. ");
INSERT INTO hrw_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Una bura ine ambusbusam kiruur tura mara sinangum, ma tura mara rawas kiam, ma una bura e taltalum are o buro tibom e ta iyat ine mara finafen ri taif lo ma fan mara finafen.” ");
INSERT INTO hrw_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesus ka ongni ini e sam kos fakausi, ka war singi aregii, “O am tibi tapak ine Kepmale ke Deo.” Tinglo biing a, e tek tikas e au bura una gatmo ming ine ti gatgatom, anwarow ri soke. ");
INSERT INTO hrw_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesus e fabenge singri ulo bala Felun Nining Bakir, ma ka gatom ri aregii, “Areini gii fan titsa lo fafanau, ri ka peteng ini Mesaiya e ta sikow e Dewit? ");
INSERT INTO hrw_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ma Dewit tibom ka war lo rawas ke Tangwa Riis ka peteng ten. ‘Taufi e peteng tife Taufi kiang aregii: “Kiis wagii lo galu miil lo yau ku muut yau tauf re fa ri is o, ilo pikliu e rawas kiam.” ’ ");
INSERT INTO hrw_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Dewit i tibom e fotngi ini ‘Taufi’ ma areni gii ku ta sikow?” Singmat na galung kaltu a ri ongne singi tura konona fefeal tikin. ");
INSERT INTO hrw_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yesus e fabenge singri ma ka war “Ate use re fan titsa lo fafanau. Ri bur fesfes faliu tura konona fan kolos ma ri kam isa e fan male na umumat una are ri. ");
INSERT INTO hrw_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ma ri ka su burbura e fan fate kausi ilo felun nining, ma ri bur kiis kausi i famu lo fan en bakir. ");
INSERT INTO hrw_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ri es fofoes ma bero ine fam fel kere fan makos, ma ri kam nining taptapak sak, una su fafanas iri. Tongge gii riu kepe ongker bakir sak lo anganggon.” ");
INSERT INTO hrw_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesus e kiis ulo galu lo mok na basbas mani talo, ma ka alal lo re tongge ri basbas mani talo sinatiim ke Felun Nining Bakir, fa fuunfuun lo ri, tongge tuba mel, ri ka bas bakbakir a. ");
INSERT INTO hrw_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Sakle e mel e neng e sasngal na fefin e makos ka fespuek ka sa bas ine um boron mani e ngo are tikii toiya. ");
INSERT INTO hrw_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yesus e tau ire fan disaipel kia usi, kala peteng tifri aregii, “Ya peteng tikin tif gam, boron makos sasngal gii, e bas bakir sak talo sinatiim ke Felun Nining Bakir, iyat ire tongge nano gii. ");
INSERT INTO hrw_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Fa nano gii, ri tow e sa a ka ngo sok lo tuba ri, sakle i e wok makos gii, e tou kiruur tinglo sasngal lo, e mara mok gii ku liu lo.” ");
INSERT INTO hrw_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Biing Yesus e fes tinglo Felun Nining Bakir ka la, neng lo re fan disaipel kia ka war singi, “Titsa, Om bou par lo sese singmat na tom fumfat gii, ma konona tom fel.” ");
INSERT INTO hrw_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesus e koso aregii, “O sau pari e konona fam fel lamlam gii? Eu tek ti fu lo fatfat gii eu la ngosok ilo poktow e ti neng e fu. Riu rarang pu iri nano.” ");
INSERT INTO hrw_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Sum biing Yesus ka la kiiskiis ulo paklunmale Olif, ilo galu wiwang lo Felun Nining Bakir, Pita, Jeims, Jon ma Enru ri kam sa gatom borong ini, ");
INSERT INTO hrw_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Peteng tif kemem nangis fan mok gii eu fuut? Ma sa eu ta tintof una peteng fate ini fan mara mok gii e sau bala puek?” ");
INSERT INTO hrw_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yesus e koso, ma e peteng tifri aregii, “Gam u ate are tikas kasa gurum i gam. ");
INSERT INTO hrw_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Fa fuunfuun riu puek lo asang ri ku peteng ini ‘Yau gii Kristus’, ma ri ku gurum ire fa fuunfuun. ");
INSERT INTO hrw_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ma le gam ku ong lo tuui, ma fan warwar lo tuui, gam u tibi kuufsak. Fan mok gii e samusu puek, sakle biing muut e tifik bala puek. ");
INSERT INTO hrw_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Nenge male eu fapaket tura neng e male, ma neng e matambia eu fapaket tura neng e matambia, ma eu mel e anggi ilo fanenger fan male ma biis faen. Fan mok gii eu suupuek famu ini are fefin e ongker una fasus. ");
INSERT INTO hrw_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Efe kausi lo gam tibom, riu ta gam tifre fang kaonsiil, ri ku paket gam ilo bala fam felun nining, anwarow lo yau. Ma o ku ti namatre fan taufi lo ri, ma fang king, i e sumbiing a e ta biing kiam una sesngeni e sunwar kiang tifri. ");
INSERT INTO hrw_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ma famu tongge nano ilo an mara male riu bi ongni e konona sunwar. ");
INSERT INTO hrw_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ma biing riu bingfamti o ma ri ku tauf o ilo anganggon, mele sangfuunfuun usi e sa a ou peteng ini, su seseng ine sese sunwar Deo eu tow tifo lo biing a, anwarow e tibi ta o lea o war. Tangwariis lea e warwar. ");
INSERT INTO hrw_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Nenge kaltu eu fafen ine tualik tikin ri ku paketmet ini, ma tamabo-i eu gow aiya ming e sikow tikin, ma berberat riu sak lo tamtamri ma tintinri, ri ku fauun iri, ri ku paketmet iri. ");
INSERT INTO hrw_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Tongge nano riu sak lo gam, anwarow lo yau, sakle se eu titi raw ku muut lo biing muut Deo, eu kep famila. ");
INSERT INTO hrw_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Lo biing gam u pari e ‘mok saksak sekit a, una bero ine male’ eu puek ku titi ilo mok e tibi ta tafu, (kaltu na weswes e samusu ten ini,) tongge, ri na Judia, ri samusu fin ri ku la ilo fam pakpaklunmale. ");
INSERT INTO hrw_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ma e tek tikas ilo poktow e fel eu bi pu ku lamil una la kepe ti mok tinglo bala ke fel. ");
INSERT INTO hrw_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ma neng ilo bala palang eu tibi mil una sa kepe e malu. ");
INSERT INTO hrw_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ma kiskam singre gelefin tian, ma fan tintinabo-i. Are riu gorot lo biing a. ");
INSERT INTO hrw_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ma gam u nining rawas usi biing a eu tibi puek lo bala anmair. ");
INSERT INTO hrw_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Anwarow lo biing a eu ta biing lo singmat na mafet, eu tibi ngo are tinglo biing Deo e bilseni e mara mok, ma eu tek ti singmat na mafet, eu ngo aiya ming wimi. ");
INSERT INTO hrw_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Le Taufi enggi tibi faposposo e biing a, tongge nano ring gi tuup. Sakle e sagif re tongge a i ka wel ri, iya ku faposposo e fam biing saksak a. ");
INSERT INTO hrw_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Lo biing a le tikas ku peteng tif gam aregii, ‘Par, igii e Kristus!’ tam ‘Par, i lei!’ Gam u tibi titinge singi. ");
INSERT INTO hrw_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Anwarow fang Kristus gurgurum ma fam profet gurgurum riu suupuek ri ku gow e fan tintof, ma fan mok na tibou fuut. Ma una fabeku e fanenger fan mok ming, una pete luut ire tongge e sam wel ri. Le ku fasi. ");
INSERT INTO hrw_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","O samusu efe kausi lo o. Ya sau peteng tif gam ine mara mok gii, famu ine biing a. ");
INSERT INTO hrw_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Sakle lo fam biing wimi ini e singmat na mafet a, ‘eu or e mata e pisii ma funiil e mu tibi pal. ");
INSERT INTO hrw_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Fang keltot ailo batsok riu luut, ma fan rawas tinglo batsok riu ban.’ ");
INSERT INTO hrw_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Ma lo biing a riu pari e Sikow e Kaltu, eu puek ilo balbal tura singmat na rawas ma finaswen. ");
INSERT INTO hrw_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ma ku tule re fan anggelo kia una keptiim ire tongge e wel ri, tinglo e fet e matang kif lo rorop lo male gii faf ku la muut lo rorop lo balambat. ");
INSERT INTO hrw_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Ma gii gam u sagif famti e fabenge lo au fik. Biing teltelow e arwan ma ka dur, o sau parfat, biing lo pisii e sau fatat. ");
INSERT INTO hrw_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Le o ka pari e fan mok gii eu puek, o sau parfat a, ini i e sau fatat sekit ilo matangkon. ");
INSERT INTO hrw_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ya peteng tikin tif gam, kulu gii riu tifik tam iri, ku muut lo mara mok gii eu fuut. ");
INSERT INTO hrw_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Batsok ma nal eu tam iru, sakle sunwar kiang eu tibi fasi sekit una tam ini. ");
INSERT INTO hrw_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“E tek tikas ek parfat lo biing ma anmatam pisii. Fan anggelo tinglo balambat ri tibi parfat, Sikow ming e tibi parfat, sakle Tamow tibom i e parfat. ");
INSERT INTO hrw_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Gam u parpar ma gam ku efefe, gam tibi parfat lo biing mok gii eu puek. ");
INSERT INTO hrw_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","E su ngo are kaltu e bala fes tapak kosnge ke fel, ma ka ti ine tongge kia lo fam faim. Tikii neng tikii neng eu gow e faim kia, ma ka peteng tife neng e efefe lo matangkon una parpar. ");
INSERT INTO hrw_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Ilea, bingne gam u parpar anwarow gam tibi parfat lo biing Tamow e fel eu mil lo. Eu ta lo efef, tam lo palim e biing, tam lo tengteng e porot tam lo bau e male. ");
INSERT INTO hrw_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ma le ku fakuuf ine puek kia, ou tibi masun lo biing e puek. ");
INSERT INTO hrw_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Sa gii ya ka peteng ini, ya peteng ini tifre tongge nano, ‘Gam samusu efefe!’” ");
INSERT INTO hrw_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","E buk su u e biing uwa ine En na Kepsiliwi, ma En Bakir lo Beret e Tek ti Is. Fam paklure fam pris ma fan titsa lo fafanau ri siksik ine ti sal borong una bingfamti e Yesus, ma ri ku paketmet ini. ");
INSERT INTO hrw_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Sakle ri am la fawar aregii, “Eu tibi ta lo Biing Bakir a, are tongge ri ka fagorot.” ");
INSERT INTO hrw_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Biing i auna Betani ka kiiskiis ulo fate ma ri ka enenen ulo bala fel ke Saimon kaltu lepra. Nenge fefin e fespuek tura botol ri gow lo alabasta ine sanda mata e kanek sak, ri gow lo danu e neng e au. E biwis pakti e anmatow e botol a ma ka tipeni ulo paklu e Yesus. ");
INSERT INTO hrw_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Sakle fa lo ri, lo biing a, ri fawar fa ngungut ulo falifu lo ri aregii, “Usi e tamu ka bero ine sanda gii? ");
INSERT INTO hrw_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","E kausi ini riu umat ini ku fasi lo fimfiil ke kaltu lo tikii matamfaim, ma ri ku tow e mani tifre fan sasngal.” Ma ri ka porow e fefin a. ");
INSERT INTO hrw_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Sakle Yesus e war singri, “Gam taufu, e tamu gam ka bero ine sinangu? Fefin gii e gow e konona mok lo yau. ");
INSERT INTO hrw_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Bingne tongge sasngal riu melmel tura gam, ma gam amu ules ri lo sese biing gau bura. Sakle yau tibi melmel bingne tura gam. ");
INSERT INTO hrw_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Fefin gii e sam gow e sinang e fasi ini i eu gow. E tipeni e sanda ulo fong famu una ternge yau ma ri ku of yau. ");
INSERT INTO hrw_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ya peteng tikin tif gam, ilo sese male gii lo nal riu sesngeni e konona sunwar, sa fefin gii e sam gow riu tet ming ini una sangsangfi.” ");
INSERT INTO hrw_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Wimi Judas Iskariot, neng lo sangful ma e u na disaipel, e la use paklure fam pris una la solamufu e Yesus tifri. ");
INSERT INTO hrw_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ri la terterer sak una ongni e sunwar gii. Ri ka limlim ini riu, feli ine mani. I kau parpar ine ti sal una tow e Yesus ilo limlim ri. ");
INSERT INTO hrw_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Lo biing baba tikii lo fam biing lo En Bakir lo Beret e Tek ti Is, le e ta ninis keri, una fafen ine boron sipsip lo En na Kepsiliwi, fan disaipel ke Yesus ri gatmo aregii, “O bura ini kemem u la terer salu o, una eni e En na Kepsiliwi ilo sese fel?” ");
INSERT INTO hrw_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","I kam tuleni e u e neng lo fan disaipel kia ma ka peteng tifru aregii, “Kamung kau ailo bala siti a, ma neng e kaltu e ufufu lala e botol na dan eu tupnge kamu, kamuw mi nami. ");
INSERT INTO hrw_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Kamu ku la peteng tife kaltu ine ke fel a i ku kau ilo, ma kamu ku peteng tifi aregii, ‘Titsa e gatom ini, iya e keptim fel na melmel gii, ya ku gow e En na Kepsiliwi tiim tura fan disaipel kiang ilo?’ ");
INSERT INTO hrw_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","I e mu fanangsi kamu ine keptim fel bakir iyat. Fan mara mok ri sau fagatiufu ma kamu mu fagati e fan tuan ilo nene kiar.” ");
INSERT INTO hrw_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Un disaipel ru la, ru ka kau ulo bala siti ru ka pari e mara mok aregii, Yesus e sau peteng tifru ini, iya ru ka bilse ulo, wilo En na Kepsiliwi. ");
INSERT INTO hrw_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Kala efef lo biing a Yesus ka fespuek tiim tura sangful ma eu na disaipel kia. ");
INSERT INTO hrw_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Biing ri kiis falifit ri ka enenen ulo ngiin a, Yesus ka war aregii, “Ya peteng tikin tif gam, neng lo gam eu solamuf yau, neng gii ka enen gii tura yau.” ");
INSERT INTO hrw_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ri la sangkuuluung ma tikii neng tikii neng e gatmo, “E ngo areni e tibi ta yau be?” ");
INSERT INTO hrw_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesus e koso, “Eu ta neng lo gam na sangful ma eu na kaltu. Tikii neng a ku fasow e sum beret ilo bala dis tura yau. ");
INSERT INTO hrw_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Sikow e Kaltu eu la are lea sunwar ke Deo kabuk peteng fate ini. Sakle kiskam singe kaltu a ku solamufu e Sikow e Kaltu! Enggi kausi singi le i enggi tibi fuut.” ");
INSERT INTO hrw_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Biing ri enenen, Yesus ka kepe e beret ka katfarsi e Taufi lo, ma ka paek paki, ma ka tow tifre fan disaipel kia ma ka war, “Kepe igii e fong.” ");
INSERT INTO hrw_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Wimi ka kepe e kap, ka katfarsi e Taufi lo, ma i ka tow tifri ri nano ri ka in tinglo. ");
INSERT INTO hrw_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ma ka peteng tifri aregii, “Igii e dakung una keptiim i kiar. I e lingi uf use re tongge. ");
INSERT INTO hrw_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ya peteng tikin tif gam, ya mu tibi in mil lo amfirow e waen ku la muut lo biing a, yau la inmi mil e waen fuu ilo bala Kepmale ke Deo.” ");
INSERT INTO hrw_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ri ka seke e seksek tikii ma ri kam suu ri ka la ulo paklunmale Olif. ");
INSERT INTO hrw_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ma Yesus ka peteng tifri aregii, “Titinge kemi eu luut, anwarow sunwar ke Deo e sau peteng, ‘Yau pakti e efefe lo fan sipsip, ma fan sipsip ri ku fin falek.’ ");
INSERT INTO hrw_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Sakle wimi yau matet mil, yau ku la famu i gam ina Galili.” ");
INSERT INTO hrw_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pita e war rawas aregii, “Le ri nano ri ku tiim luut, yau tibi luut.” ");
INSERT INTO hrw_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesus e koso, “Ya peteng tikin tifo, na panambiing famu ine porot eu fa-u teng o fatuul peteng ini o tibi parfat lo yau.” ");
INSERT INTO hrw_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Sakle Pita e war rawas ini, “Antalu ya ku met tura o, yau tibi la kosing o sekit.” Ma iri nano ri ka tiin war ine tikii sunwar. ");
INSERT INTO hrw_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ri la ulo male ri fotngi ini Getsemeni. Ma Yesus ka peteng tifre fan disaipel kia, “Gam u kiiskiis wagii, ma ya ku la nining.” ");
INSERT INTO hrw_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","I e onu e Pita, Jeims ma Jon ri ka la nami. Ma kabuk tofnge e sangkuuluung aulo bala ma ka la sangkut. ");
INSERT INTO hrw_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","I e war singri tuul, “Singmat na ongker ma fatengis gii e sam afti kiruur e tangwang, fatat ma ya ku met. Gam tuul u melmel wagii ma gam tuul ku parpar.” ");
INSERT INTO hrw_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","E la u tapak balik ka luut ulo nal, ma ka nining ini le ku mel e ti sal, mafet gii eu ifit ini. ");
INSERT INTO hrw_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ma i ka war, “Aba, Tabuung, mara mok e paumil singo. Tii ine kap gii kosing yau, sakle ou tibi usi e fabur kiang, su gow e sa o bura.” ");
INSERT INTO hrw_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Wimi ka mil use tuul e disaipel kia ma ka pari ini ri sau masun. I ka war singe Pita, “Saimon, o masun? E tibi fasi ini gam u parpar lo tikii ti anmatam pisii? ");
INSERT INTO hrw_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Gam u parpar ma gam ku nining are gam ka luut singe falam. Tangtangwami e fabur, sakle fofomi e main.” ");
INSERT INTO hrw_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Yesus ka la mil ming, ka la nining are famu. ");
INSERT INTO hrw_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Biing i e sa mil, ka sa pari ming ini ri masmasun aua, ka fongen ri, sakle matmat ri e mafet sak. Ri am tibi parfat ine are riu war singi. ");
INSERT INTO hrw_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","I ka mil baba e tuul, ka sa war singri, “Gau masmasun ma gam ka manmanau aiwa? E sau muut wa biing e sau puek. Par! Sikow e Kaltu riu solamufu ku la ilo limlimre ge saksak. ");
INSERT INTO hrw_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Gaman matet! Kerek la! I gii kabuk puek e neng una solamuf yau!” ");
INSERT INTO hrw_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Biing e warwar aua, Judas neng lo re sangful ma eu ka suupuek. Ma unaisa, singmat na galung kaltu tura fan iriringgot ma fang kepsil, fan titsa lo fafanau ma fam paklure fam pris, ma fang kaltu bakir keri, ri tule ri. ");
INSERT INTO hrw_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Gii kaltu una solamufu e sau fagatiufu e peteng fate tifri, “Neng gii ya ku osngi e sam ta i, bingfamti, tatfeni ku la ma efe kausi lo.” ");
INSERT INTO hrw_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Judas e fespuek sekit use Yesus ka sa war, “Titsa!” ma ka osngi. ");
INSERT INTO hrw_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ma tongge a ri ka ti kali e Yesus ma ri ka bingfamti. ");
INSERT INTO hrw_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ma wimi tikii neng lo ri e titi u fatat ka efufu e ke ringot ma ka teseufu e ambalbalu e kaltu na faim ke paklure fam pris. ");
INSERT INTO hrw_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yesus ka gatom ri, “Areni, ya na kaltu una fafapaket ma una kinkinau, gii gam ka fespuek tura fan iringgot ma fang kepsil una sa bingfamti yau? ");
INSERT INTO hrw_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Mara biing yau tura gam, ya fafabenge ulo bala pakanmale lo Felun Nining Bakir, ma gam tibi bingfamti yau. Sakle gii, sunwar ke Deo e samusu fasef.” ");
INSERT INTO hrw_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Tongge kia ri nano ri la kosngi, ma ri ka fin falek. ");
INSERT INTO hrw_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Nenge guam e su los lo sakle kolos tapak, e mimi lala nami e Yesus. Biing ri tofo una bingfamti, ");
INSERT INTO hrw_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","i e fin biilbiil kosngi e ke kolos ka ngosok. ");
INSERT INTO hrw_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ri onu e Yesus use paklure fam pris lamlam, ma fam pris lamlam, ge lamlam ma fan titsa lo fafanau ri sa tiim lo ri. ");
INSERT INTO hrw_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pita e mimi lala nami, sakle i aua u tapak balik, ka la kau sekit ulo bala ampalkanmale ke paklure fam pris, Ka la kiiskiis wa tura tongge na efefe, ka la mingmingii ulo iif. ");
INSERT INTO hrw_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Fam paklure fam pris, ma fan kaonsiil ri tau ire tongge una peteng ine fan mok Yesus e sam gow. Ri bala sesuupuek ine ti tubiil kia usi ri ku paketmet ini. Sakle ri tibi sik seni e ti tubiil kia. ");
INSERT INTO hrw_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Fa lo ri, ri seseng gurgurum talo, sakle fan sunwar keri e tibi tiin ngo. ");
INSERT INTO hrw_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Wimi fa ri matet ri ka ti, ma ri ka gow e angurum gii talo. ");
INSERT INTO hrw_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Kemem ongni e peteng aregii, ‘Yau bero ine Felun Nining Bakir gii tongge ri ka gow, ma ilo bala e tuul e biing, yau feti e neng e tibi ta kaltu e gow.’” ");
INSERT INTO hrw_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Sakle awa fan susunwar keri e tifik la tiin ngo. ");
INSERT INTO hrw_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Sakle wimi paklure fan pris ka ti u famu iri ma ka gatmo e Yesus aregii, “Areini ou tibi koso e ti sunwar? Sese fan warwar le gii tongge gii ri ka gow una bero i o?” ");
INSERT INTO hrw_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Sakle Yesus aua e tibi kukueng, e tibi koso e ti sunwar. Kala paklure fam pris ka gatmo, “E sam ta o na Mesaiya, Sikow e Deo aiyat?” ");
INSERT INTO hrw_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesus e war, “Yow, yau mung, ma gam amu pari e Sikow e Kaltu eu kiis ilo galu miil lo Deo, ma eu mil lo aumbalbal tinglo batsok.” ");
INSERT INTO hrw_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Paklure fam pris lamlam e rangsi e kolos tapak kia, ma ka war, “Ker am tibi bura e ti tong kaltu ming una peteng ten. ");
INSERT INTO hrw_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Gam sau bom ongni, i e fotpursi e Deo. Are gam sang?” Ri nano ri tiim peteng, e tubiil, e samusu met. ");
INSERT INTO hrw_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Fa ri tofnge una kansu, ma fa ri ka fis kali e wanmata, ma ri ka tutu ine limlim ri, ma ri ka war, “Peteng tif kemem ini se e paket o.” Ma fan efefe ri kabuk tatfeni ri ka la pakti. ");
INSERT INTO hrw_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Biing Pita e la ulo ampalkanmale, neng lo re gelefin na faim ke paklure fam pris ka fespuek. ");
INSERT INTO hrw_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ma ka pari e Pita e mingmingii, kabi iliim fakausi ma ka war, “O ming lewa tura Yesus tingna Nasaret.” ");
INSERT INTO hrw_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Sakle Pita e alau fofosi, “Ya tibi parfat, ma ya tibi ten lo sa o petpeteng ini.” E su war aiya ma kabuk fes ka la su ulo matangkon. ");
INSERT INTO hrw_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Biing fefin na faim a e pari Pita e titi uwa, ka peteng ming, tife fa ri fafatie uwa, “Kaltu gii e ta lo ri.” ");
INSERT INTO hrw_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ma ka su alau fofosi ming. Wimi balik ini, fa ri fafatie fatatu e Pita, ri ka war singi. “E tikin ini o na neng lo ri be? O tingna Galili.” ");
INSERT INTO hrw_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ma kabuk wes talo i tibom. Ma ka limlim tifri, “Ya tibi parfat sekit lo kaltu a gam ka petpeteng ini.” ");
INSERT INTO hrw_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Wimi sekit ini, porot ka fa-u teng, ma Pita kabuk la sangfi e fan warwar Yesus e sau peteng tifi ini. “Famu ine porot ma ku fa-u teng, ou fatuul peteng ini o tibi parfat lo yau.” Ale, Pita e ururung. ");
INSERT INTO hrw_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Lo biingbiing e mok sak fam pris lamlam tura tongge lamlam, fan titsa lo fafanau, ma mara kaonsiil ri puek tura sangsang, una bingfamti e Yesus, ma ri onu ri ka la tow tife Pailat. ");
INSERT INTO hrw_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pailat e gatmo aregii, “E sam ta o na King kere fan Juda?” Yesus ka koso, “Yow e ngo are le a o ka war.” ");
INSERT INTO hrw_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Fam paklure fam pris ri fotpursi lo mara mok. ");
INSERT INTO hrw_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Wimi Pailat ka gatmo mil, “O tibi su fasi una kokos? Pari e fis e mok ri fotpuris o lo.” ");
INSERT INTO hrw_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Safle Yesus uwa e ti kokos, ma Pailat e sangfuunfuun. ");
INSERT INTO hrw_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Gii e sam ta ninis lo fam biing bakir una pikufu e se tikin ilo rerek, a tongge ri ka bura. ");
INSERT INTO hrw_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Lo biing a, ri taufre tongge ulo rerek. Neng lo ri, asow gii Barabas. Ri fafapaket tura gapman ma ri ka paketmet ire fa lo re tongge. ");
INSERT INTO hrw_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Tongge ri puek ri gatmo e Pailat una gow e ninis gii kabuk gowgow lo ri ting famu. ");
INSERT INTO hrw_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pailat e gatom ri, “Gau bura ini yau pikufu e King kere fan Juda tif gam?” ");
INSERT INTO hrw_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","I e parfat ini e su ta fan songe iya fam paklure fam pris ri ka tow e Yesus ka la tifi. ");
INSERT INTO hrw_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Safle fam paklure fam pris, ri famtete e balbalre tongge una onu e Pailat, ku pikufu e Barabas subung. ");
INSERT INTO hrw_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pailat ka gatom ri, “Ma sa gii ya ku gow lo neng gau fotngi ini King kere fan Juda?” ");
INSERT INTO hrw_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ri ka tiin tau, “Tutfamti lo aupaket!” ");
INSERT INTO hrw_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ma i ka gatom ri, “I e tamu? Sese tubiil i e gow?” Safle ri su tautau bakir, “Tutfamti lo aupaket!” ");
INSERT INTO hrw_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","E bura ini eu fawetu e fabur keri, Pailat ka pikufu e Barabas tifri, ma ka tow e Yesus tifre fan soldia ri ka napsi, ma ri kam tutfamti ulo aupaket. ");
INSERT INTO hrw_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Fan soldia ri onu e Yesus, ka kau ulo bala ampalkanmale ke gapman. Ma ri kam tau tiim ire fan soldia nano. ");
INSERT INTO hrw_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ri tow e kolos e kaukaor ulo Yesus, wimi ri getiim ine amfinau soksok, ma ri ka tow ulo paklu are at king. ");
INSERT INTO hrw_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ma ri tofnge una tau singi, “Siaro, King kere fan Juda!” ");
INSERT INTO hrw_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ri ngos lo fisi ulo paklu ine sungkalut ma ri kankansu. Ri pukungkek ma ri ka tow e nawen tifi. ");
INSERT INTO hrw_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ma biing ri sam tumar falek ini, ri kepufu e kolos kaukaor, ma ri ka tow e neng kia tibom mil ulo. Wimi ri kam onu una la tutfamti ulo aupaket. ");
INSERT INTO hrw_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Nenge kaltu tingna Sairini, Saimon, (tamow e Aleksenda ma Rufus) i e sol paket, e mil wilo siti, ma ri ka tungni una kepe e aupaket. ");
INSERT INTO hrw_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ri onu e Yesus ka la ulo male ri fotngi ini Golgota (pimpiku gii Male ke Antuampaklung Kaltu). ");
INSERT INTO hrw_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Wimi ri ka fainmi ine waen, ri iksi tura marasin lo ongker. Safle Yesus e tibi inmi. ");
INSERT INTO hrw_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ma ri ka tutfamteni ulo aupaket, ma ri ka fasa ine fang kolos kia falifu lo ri tibom, ma ri ka pilai satu una sik ini se eu kepe e sese mok. ");
INSERT INTO hrw_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Lo anmatam pisii baba e siu lo biingbiing e mok, ri tutfamti ulo aupaket. ");
INSERT INTO hrw_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Siisiit una parfailmi lo anganggon kia ulo aupaket e wes aregii; “KING KERE FAN JUDA.” ");
INSERT INTO hrw_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Ri tutfamti e u e kaltu na kinkinau tura ulo neng e un aupaket ming, neng ulo galu miil ma neng ulo galu kais. ");
INSERT INTO hrw_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Fa ri ka sol singi, ri tumar saksak ini, ri belbel ine pakpakluri ma ri ka war, “O lewa o ka peteng ini ou bero ine Felun Nining Bakir ma o ku feti mil lo e su tuul e biing? ");
INSERT INTO hrw_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Pu tinglo aupaket ma ok bou faliunge o.” ");
INSERT INTO hrw_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Lo i e sangsang mung a, fam paklure fam pris ma fan titsa lo fafanau ri fatumar ini ulo falifu lo ri tibom. “I e faliungere fa, lewa. Safle e tibi fasi una faliungeni tibom. ");
INSERT INTO hrw_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Taufu e Mesaiya gii, King kere fan Israel, ku pu tinglo aupaket, usi kiar u pari ma kiar ku titinge.” Uneng ru kulik fapot ini iru ming ru tumaru. ");
INSERT INTO hrw_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Lo siat tuntun, anor e afti e nal kiruur ka muut lo anmatam pisii baba e tuul. ");
INSERT INTO hrw_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ma lo anmatam pisii baba e tuul, Yesus e tau bakbakir sak, “Eloi, Eloi, Lama Sabakatani,” Pimpiku gii: “Kek Deo, kek Deo, usi e tamu o ka la kosing yau?” ");
INSERT INTO hrw_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Biing fa lo re tongge a ri ka fafatie fatat, ri ongni, ma ri ka war, “Ong, e tautau ine Elaisa.” ");
INSERT INTO hrw_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Neng lo ri e filau ka la utfi e spans na waen gin, ka tow ulo sungkalut, ma ka fafen ini tife Yesus ini ku inmi, ma ka war, “Kerek bi par usi, Elaisa ngan e mu sa kepufu.” ");
INSERT INTO hrw_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Tura singmat na tineng, Yesus e sekpaket manangia. ");
INSERT INTO hrw_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Laplap bakir ulo Felun Nining Bakir e rages ka u lo, ting uiat ka la muut ufaf. ");
INSERT INTO hrw_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ma lo biing paklure fan soldia e titi uwa u famu ine Yesus, e ongni e tengteng kia ma ka pari, are e met, i ka war, “Tikin sak, kaltu gii e ta Sikow e Deo!” ");
INSERT INTO hrw_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Fa fang gelefin ri manman ting tapak. Falifu lo ri, Maria Makdalen, Salome ma Maria tinow e Joses ma Jeims balik. ");
INSERT INTO hrw_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Gelefin gii ri minami una Galili, ri ka efe lo fam fabur kia. Fa fuunfuun lo re gelefin ri sa la tura una Jerusalem iri ming uwa. ");
INSERT INTO hrw_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","E sau fatat lala una biing, e ta biing na terer (e ta biing famu ine sabat). ");
INSERT INTO hrw_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Josef tingna Arimatia, e ta neng lo re fang kaonsiil, e ta neng lo re tongge ri natkeni, ming i e nene una pare kepmale ke Deo, e sangtanamia una la gatmo e Pailat use pinumfow e Yesus. ");
INSERT INTO hrw_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pailat e kuufsak le e ong ini Yesus e met saupesak. Ka fauun usi e efefe, kam gatmo ini Yesus e sau met, tam e tam. ");
INSERT INTO hrw_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Biing e ong singe efefe ini ngo aiya, ka a-uu ine pinumfow e Yesus tife Josef. ");
INSERT INTO hrw_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Josef e feli e fan laplap, ka kepu ine pinimfow e Yesus, ma ka afti ine fan laplap ma ka towfu ulo balang kenit, ri sam kefi ulo fam. Wimi kau fiiliitngeni e fumfat kaleni e matangkon lo balang kenit. ");
INSERT INTO hrw_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maria Makdalen ma Maria tinow e Joses ru pari e mok ri fangongi e Yesus ulo. ");
INSERT INTO hrw_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Biing Sabat e rop, Maria Makdalen, Salome ma Maria tinow e Jeims ri tuul la fifiil fan wel e mel a konona sanuu una la mofo e fow e Yesus. ");
INSERT INTO hrw_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Biingbiing e mok sak lo biing baba tikii lo wik, wimi sekit ine pisii e fen, ri tuul fes una la ulo balang kenit. ");
INSERT INTO hrw_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ma ri tuul ka bou fagatomnge iri, “Se eu filiitufu e fat kosngi e matangkon wilo balang kenit?” ");
INSERT INTO hrw_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Sakle biing ri akte matri, ri pari ini fumfat bakir sak ri sau filiitufu. ");
INSERT INTO hrw_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Biing ri kaulek ulo balang kenit, ri pari e guam e los lo kolos murmur tapak e kiiskiis ulo galu miil, ri ka kuufsak. ");
INSERT INTO hrw_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","I ka war singri tuul, “Gam u tibi kuufsak. Kemi sik ine Yesus tingna Nasaret lewa ri ka paketmet ini, e sau matet. Par wagii, e tam ini tinglo tafu. ");
INSERT INTO hrw_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Sakle gam tuul u la peteng tifre fan disaipel ma Pita, ini i e la famu i gam ina Galili. Gam u la pari wa, aregii i kabuk peteng tif gam.” ");
INSERT INTO hrw_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ri banban ma ri sangkut, gelefin a, ri la kosngi e balang kenit. Ri tibi war singe tikas, anwarow ri soke. ");
INSERT INTO hrw_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yesus e matet lo biing baba tikii lo wik, e puek famu talo Maria Makdalen. Lewa ka feselufu e baba fis na tangwaner saksak tinglo. ");
INSERT INTO hrw_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","I e la, ka la peteng fate re tongge, ri sau fesfes tiim tura Yesus. Tongge gii ri melmel tura sangkuuluung ma fatengis. ");
INSERT INTO hrw_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Biing ri ong ini Yesus e sam liu mil, ma ini i e sau pari, ri tibi titinge lo. ");
INSERT INTO hrw_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Wimi Yesus e puek ine neng e puek talo uneng lo ri, biing ru fes lala una la suu tingna Jerusalem. ");
INSERT INTO hrw_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ru mil ru ka la sesngeni tifre fa lo ri, sakle ri tibi su la titinge lo sekit ming. ");
INSERT INTO hrw_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Wimi Yesus e puek talo tikii sangful ma e tikii na disaipel kia, biing ri enen. I e porau ri usi re tibi titinge, ma balbalri e kut una ong singre fa gii, ri kabuk pari ini e sau matet. ");
INSERT INTO hrw_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","I e war singri, “La ilo mara male gii lo nal ma sesngeni e konona sunwar tifre mara tongge. ");
INSERT INTO hrw_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Se a ka titinge, ma ka kepe amfagu tarawen, eu mel e ninliu. Sakle se a ka tibi titinge, Deo eu fakutun aiya. ");
INSERT INTO hrw_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Deo e gow e mara mok na tibou fuut lo limre tongge ri titinge lo. Ma lo asang, riu feselufu e fan tangwaner saksak, ma riu gon tinglo fan warwar fuu kuriik. ");
INSERT INTO hrw_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Riu kepe fan sii ini e limlim ri, ma biing ri inmi e dan saksak sekit, eu tibi bero iri sekit; riu tow e limlim ri ilo tongge ri mase, riu liu.” ");
INSERT INTO hrw_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Wimi ine Taufi Yesus e sam gongon singri, Deo e kep kanek ini wilo balambat, ka kiis ulo galu miil lo Deo. ");
INSERT INTO hrw_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Wimi fan disaipel ri ka la, ma sesngeni e sunwar ulo mara male, Taufi e faim tura ri ma ka farawasngeni e ke sunwar ine fan tintof e fuut tiim tura. ");
INSERT INTO hrw_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Fuunfuun lo re tongge ri sam tofo una siit famteni e fan mok gii Deo kabuk fafuutngeni ilo falifu i kiar. ");
INSERT INTO hrw_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ri usi e fan sinseng kere fa gii ri kabuk melmel are tongge na faim ke sunwar, ri seseng tif kemem ini. Tongge a ri sau pari e fan mok a ine matmat ri riis, tofnge tinglo biing fan mok a e fuut. ");
INSERT INTO hrw_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Iya, biing yau tibom ya sau parfakausi e fan mara mok gii tinglo tofnge, e su kausi sing yau una seti e konona ti sinseng tifo, kaltu bakir Tiofilus, ");
INSERT INTO hrw_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","usi ini o ku bou parfat lo ini konona fan mok gii ri kabuk fabenge sing o ini, e tikin. ");
INSERT INTO hrw_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Lo biing Erot e ta King tingna Judia, e mel e neng e pris asow gii Jekaraiya. I e ta neng lo re fam pris tinglo funmat a Abiya. Ke wok, asow gii Elisabet. I ming e ta tinglo bala matambia a Aron. ");
INSERT INTO hrw_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ru nano ru melmel riis na mata e Deo. Ru ususi fakausi e fam fafanau ma fam fabenge ke Taufi ma e tek ti tubiil keru na mata e Deo. ");
INSERT INTO hrw_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Safle e tek ti sikua ru, anwarow Elisabet e pom ma iru nano ru kabuk matuk. ");
INSERT INTO hrw_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Nenge pansumbiing, e ta biing ke Jekaraiya tura fan taltalu una faim ulo Felun Nining Bakir ma i ka fafaim are pris na mata e Deo. ");
INSERT INTO hrw_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ma ususi e ninis kere fam pris, iri pilai satu ri ka siikii e Jekaraiya una la ilo bala Felun Nining Bakir ke Taufi, una la tunu e insen. ");
INSERT INTO hrw_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ma biing anmatam pisii una tunu e insens e puek, tongge nano a ri ka tiim lo ri una male, ri ninining. ");
INSERT INTO hrw_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ma anggelo ke Taufi ka puek talo, ka sa ti ulo galu miil lo altar na insen. ");
INSERT INTO hrw_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Biing Jekaraiya e pari, i e ginwalwal e fow ma ka soke. ");
INSERT INTO hrw_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Safle anggelo e war singi, “Mangena soke, Jekaraiya, Deo e sam ongni e nining kiam. Kem wok Elisabet eu fasus ine kem ti boron tamat, ma o ku fotngi ini Jon. ");
INSERT INTO hrw_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ou fefeal tikin lo bo-i a ma tongge fuunfuun ri ku fefeal ming anwarow i e fuut, ");
INSERT INTO hrw_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","le i eu bakir na mata e Taufi. I eu tibi fasi una in waen, tam tikas ti dan rawas ming, ma tofnge tinglo biing i e ta ilo bala e tinow, i e sau fuunuf ine Tangwa Riis. ");
INSERT INTO hrw_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Fuunfuun lo re tongge tingna Israel, i eu ikis familri use Taufi Deo keri. ");
INSERT INTO hrw_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ma i eu la famu ine Taufi, lo tangwa ma rawas are Elaija, una tafu e balamaris falifu ire fan tamtamabo-i ma siksikwa ri ma i ku ikis familre tongge ri fasange singe sinang riis use atausimale lo sal e riis, usi ini eu gau re tongge ri ku fagati ri are tongge ri fagati ri nene-i e Taufi.” ");
INSERT INTO hrw_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Jekaraiya ka gatmo e anggelo, “Are ini gii ya ku parfat ini mok gii eu puek tikin? Ya sau matuk ma kek wok ming e sau matuk.” ");
INSERT INTO hrw_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Anggelo ka koso, “Yau Gebriel. Ya sagisu melmel bingne inaisa e Deo, ma i e sam tule yau una peteng tifo ine konona sunwar gii. ");
INSERT INTO hrw_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ma gii, anwarow o tibi titinge lo kek sunwar, a kamu puek tikin lo biing riis lo, ngusum eu kut ma o ku tibi fasi una gon ku muut lo biing mok gii eu fuut.” ");
INSERT INTO hrw_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Sumbiing a, tongge ri nene i uwa e Jekaraiya ma ri ka sangfuunfuun usi, ini e tamu i ka la melmel tapak tikin ilo bala Felun Nining Bakir. ");
INSERT INTO hrw_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Biing i e suu mil, i e tibi fasi una gon sing ri. I e su gowgow e fan tintof tifri, iya ri kau parfat ini i e pari e mok e ngo are numbiil ulo bala Felun Nining Bakir. Safle uwa, i e tifik fasi una war. ");
INSERT INTO hrw_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Biing, sumbiing kia una faim e sam rop, Jekaraiya e la mil ulo male. ");
INSERT INTO hrw_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Wimi ini, ke wok Elisabet ka tian ma lo e lim e funiil, i e su melmel borong. ");
INSERT INTO hrw_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ma i ka war aregii, “Taufi e bilseni e mok gii lo yau. Lo fam biing gii, i e fanangsi e fatengis kia lo yau ma kabuk tii ine an maiyai tinglo yau falifu ire tongge.” ");
INSERT INTO hrw_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Lo funiil baba e on ke Elisabet, Deo e tuleni e anggelo Gebriel wina Nasaret, neng e taon ina Galili, ");
INSERT INTO hrw_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","usi e neng e makos e mapek asow gii Maria. Ri sau fagati ini i eu tili e neng lo re fesa e Dewit, ri fotngi ini Josef. ");
INSERT INTO hrw_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Anggelo e la usi ma ka la war singi, “Siaro sing o, Deo e ta tura o ma i e sam warfakausi o.” ");
INSERT INTO hrw_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maria e ongni e sunwar a ka la kuufsak ma ka la sangfuunfuun ini, aregii, e ta sese mok sekit. ");
INSERT INTO hrw_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Safle anggelo e war singi, “Ou tibi soke Maria, Deo e gasgas tikin lo o. ");
INSERT INTO hrw_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ou tian ma o ku fasus ine ti boron tamat. Ma o ku fotngi e asow ini Yesus. ");
INSERT INTO hrw_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Asow eu bakir tikin ma ri ku fotngi ini Sikow e Deo Aiyat Sekit. Deo Taufi eu tafu ku kiis lo sia king ke an tumlow Dewit. ");
INSERT INTO hrw_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ma i ku ta king bingne kere fesa e Jekop. Ma faim king kia eu tibi fasi una rop.” ");
INSERT INTO hrw_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maria ka gatmo e anggelo, “Are legii mok gii eu fuut ma ka ta ya na makos mapek?” ");
INSERT INTO hrw_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Anggelo ka koso, “Tangwa Riis ke Deo Aiyat sekit eu pu talo o ma rawas kia ku afit o. Iya, kaltu tarawen a ku fuut a, riu fotngi ini Sikow e Deo. ");
INSERT INTO hrw_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Wok lo o ming Elisabet, e sau matuk leii, safle e sam tian. Ma i, se lewa ri ka peteng ini e pom, e sam on e amfuniil kia. ");
INSERT INTO hrw_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Anwarow e tek ti mok eng kala sing e Deo.” ");
INSERT INTO hrw_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maria ka war singi, “Ya na fefin na mus ke Deo. Tafu ku fuut lo yau aregii o ka peteng.” Kala anggelo ka la kosngi. ");
INSERT INTO hrw_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Lo sumbiing a Maria e matet ka la saupe tikin ulo neng e taon ilo pakpaklun male ilo prowins ina Judia. ");
INSERT INTO hrw_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Uwa i e la kaulek ulo fel ke Jekaraiya ma ka la areni e Elisabet. ");
INSERT INTO hrw_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Biing Elisabet e ongni e are ke Maria, bo-i ulo bala e boles ma Elisabet ka la fuunuf ine Tangwa Riis. ");
INSERT INTO hrw_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ma i ka kaung bakir ma ka war, “Deo e warfakausi o iyat ire gelefin nano ma bo-i ming a o ku fasus ini, i e sam kepe ming e warfakausi ke Deo. ");
INSERT INTO hrw_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","E ta yau se sekit legii, gii tinow e Taufi kiang ka sa la usi yau? ");
INSERT INTO hrw_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Sumbiing sekit ya ongni e are kiam, bo-i ilo balang e boles tura fefeal. ");
INSERT INTO hrw_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Deo eu warfakausi o le o sam titinge ini sa Taufi e peteng ini tifo, eu fuut aregii i ka peteng.” ");
INSERT INTO hrw_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ma Maria ka war, “Balang e resngeni e Taufi ");
INSERT INTO hrw_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ma tangwang ka fefeal lo Deo, anwaramfaliunge kiang, ");
INSERT INTO hrw_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Le i e sam tengis yau ma ka su ta ya na fefin na faim kia. Ya na mok fofoes. Geinggii ma wimi ming tongge riu peteng ini Deo e sam tow e singmat na fefeal tif yau, ");
INSERT INTO hrw_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","anwarow Deo se e rawas tikin e sau bilseni e fan mok lamlam tikin lo yau, ma asow e tarawen. ");
INSERT INTO hrw_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Fatengis kia eu ta ilo seri a ri ka soksokeni, tinglo neng e inlen ku la lo ilo neng e inlen. ");
INSERT INTO hrw_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","I e sau bilseni e fam faim rawas tikin ine limow. I e sau fesel falek ire tongge ri akteni e asasri tibom ilo sinsinangu ri. ");
INSERT INTO hrw_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","I e sau feselufu e fang king rawas tinglo fan sia king keri ma ka akte re fa ri fapori. ");
INSERT INTO hrw_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","I e sau fenre tongge ri fitol ine konona fan mok ma ka tule re tongge ri mel e tuba ri, ri ka la fofoes. ");
INSERT INTO hrw_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","I e sam ulsi e kaltu na mus kia Israel, are lewa ka warfot tifri una tengis ri ");
INSERT INTO hrw_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","tife Abra-am ma fan tubtubungkak kia bingne, ma are lewa ka war ming singre tumtumla rer.” ");
INSERT INTO hrw_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria e melmel tura Elisabet lo are e tuul e funiil ma kam la mil wilo male kia. ");
INSERT INTO hrw_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Biing e sam ti lo pansumbiing ke Elisabet una kepe ke bo-i, i e fasus ine boron tamat. ");
INSERT INTO hrw_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Tongge fatatu ma tongge lo, ri ong ini Taufi e sau fanangsi ine singmat na warfakausi, ma ri ka sa gasgas tiim tura. ");
INSERT INTO hrw_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Lo biing baba e wal tongge ri ka puek una sa talsi e pinumfow e bo-i a, ma ini ri ku fotngi ine asow e tamow, Jekaraiya. ");
INSERT INTO hrw_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Safle tinow e peteng aregii, “E tam! Riu fotngi ini Jon.” ");
INSERT INTO hrw_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ri ka peteng tifi, “E tek tikas falifu ire tongge lo gam ek mel e as a.” ");
INSERT INTO hrw_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Kala ri ka gow e fan tintof tife tamow, una sikseni ini sese as i e bura ini eu fotngi ine bo-i. ");
INSERT INTO hrw_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Jekaraiya ka gatom use ti mok una siisiit, ma tongge nano ri kala sangfuunfuun singi e siisiit aregii, “Asow gii Jon.” ");
INSERT INTO hrw_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Saupesak ngusu ka ipiik ma angkermow ka pipik ma ka tofnge una war, ka katfarsi e asow e Deo. ");
INSERT INTO hrw_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Tongge fatatu ri nano ri tiin la soke ma tongge ulo male kiruur ilo pakpaklun male ilo prowins ina Judia ri tiin fafagon use fan mok gii. ");
INSERT INTO hrw_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Tongge nano seri, ri ong lo mok gii ri sangfuunfuun ma ri ka gatom, “Bo-i gii ku puek ku ta sese ti kaltu gii wimi?” Le ri parfat ini rawas ke Taufi e ta tura. ");
INSERT INTO hrw_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Jekaraiya tamow e bo-i a, e fuunuf ine Tangwa Riis, ma ka war ine fan warwar profet: ");
INSERT INTO hrw_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Katfariis tife Taufi, Deo kere fan Israel, anwarow i e sau puek ma ka bung kep familre tongge kia. ");
INSERT INTO hrw_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","I e sau fafuutngeni e neng e kaltu rawas una faliunge kiar, ilo bala funmat a kaltu na mus kia, Dewit, ");
INSERT INTO hrw_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","are lewa i kabuk peteng ini nangen tikin ulo ngus re fam profet tarawen kia. ");
INSERT INTO hrw_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Kaltu una faliunge kiar kosing re tongge na matamfais kiar ma kosing re tongge ri is kiar, ");
INSERT INTO hrw_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","una fanangsi e fatengis kia tifre tumtumlarer, ma una sangfi e war a-uu tarawen kia. ");
INSERT INTO hrw_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","I e limlim ulo poktow e an tumlarer Abra-am ini: ");
INSERT INTO hrw_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","i eu faliunge kiar kosing re tongge na matamfais kiar ma ku ules kiar una musngeni e faim kia ma kiar ku tibi soke. ");
INSERT INTO hrw_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Kiar u musngeni e faim kia tura sinang e kalkaliis ma e riis, i famu ini, lo bala fam biing kiar melmel iwa. ");
INSERT INTO hrw_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ma o, sikuang, riu foteng o ini profet ke Deo Iyat Sekit; le ou la famu ine Taufi una fariisu e sal kia, ");
INSERT INTO hrw_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ma una pete parfat ire tongge kia ini Deo eu faliungeri, biing i e sam sangintafngi e fan tubiil keri, ");
INSERT INTO hrw_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","anwarow Deo kiar e mel e singmat na fatengis ma fabur kia, ma ilo bala fabur kia anten ting aiyat eu pu usi kiar, ");
INSERT INTO hrw_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","una sosok talo seri a, ri ka ta ilo bala anor ma ilo bala an maluuf lo minet, una famu ine kekekrer wilo bala sinang na balamaris.” ");
INSERT INTO hrw_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ma bo-i a ka faf bakir ma tangow ka puek rawas ma i ka melmel ulo bala male e tek ti kaltu kala muut lo biing i e puek malal na matre fan Israel. ");
INSERT INTO hrw_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ulo bala fam biing a, Sisa Augustus e tafu e neng e fafanau, ini ri samusu siitufu e asas re tongge nano ilo bala fam pakpakanmale gii ka ta ilo pikliu e efefe kere fan Rom. ");
INSERT INTO hrw_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","(Gii, e ta senses baba tikii e puek, lo biing Kwairinius e ta gawana tingna Siria.) ");
INSERT INTO hrw_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ma tikii neng, tikii neng lo re tongge e la mil wilo anwaran male kia una la tafu e asow. ");
INSERT INTO hrw_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Iya Josef ming ka kanek mil tinglo taon Nasaret ina Galili wina Judia. I ka la ulo taon ina Betle-em, e ta taon ke Dewit, anwarow i e ta tinglo matambia ke Dewit. ");
INSERT INTO hrw_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","I e la uwa una la tafu e asow tiim tura Maria, seri sam siikii una tili. Lo sumbiing a, Maria e tian. ");
INSERT INTO hrw_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Biing ru sam la ta uwa, biing ke bo-i una fuut e puek, ");
INSERT INTO hrw_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","ma Maria ka fasus ine sikow baba tikii, e ta boron tamat. I e loku ine fang kolos ma ka tafu ulo bala bokiis na enen singre fan buuluumakau, anwarow e tek ti salu ri ulo bala felum pasindia. ");
INSERT INTO hrw_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ma wa, e mel e fan efefe lo re fan sipsip ri melmel fatat ulo galu lo taon, ri ka parpar use re fan sipsip keri lo panambiing. ");
INSERT INTO hrw_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ma anggelo ke Taufi ka puek talo ri, ma finaswen ke Taufi ka sosok liflifit ri, ri ka la soke sak. ");
INSERT INTO hrw_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Safle anggelo e war singri, “Mele soke. Ya tow e konona sunwar tif gam usi eu pete gasgas ire tongge nano. ");
INSERT INTO hrw_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Geinggii ilo taon ke Dewit e mel e anwaramfaliunge e sau fuut usi gam; i e ta Mesaiya, se e ta Taufi. ");
INSERT INTO hrw_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ma tintof tif gam e ngo aregii: Gam u pari e bo-i, ri loku ine fang kolos ma ka ngongo ilo bala bokiis na enen singre fan buuluumakau.” ");
INSERT INTO hrw_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Saupe sak singmat na galung anggelo tinglo balambat ka puek tura anggelo a, ri ka katfarsi e Deo aregii, ");
INSERT INTO hrw_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Finaswen tife Deo aiyat ma balamaris ke Deo eu ta ilo seri a Deo ka fefeal lo ri ilo nal.” ");
INSERT INTO hrw_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Biing fan anggelo ri sam la mil kosing ri wilo balambat, fan efefe lo re fan sipsip ri fagon falifu lo iri tibom aregii, “Kerek la wina Betle-em, kiar ku la par lo mok e fuut, Taufi e peteng tif kiar ini.” ");
INSERT INTO hrw_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Iya ri ka saupe ri ka la ma pari e Maria ma Josef ma bo-i, se e ngongo ilo bala bokiis na enen singre fan sipsip. ");
INSERT INTO hrw_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Biing ri sam la pari, ri rerkeni e sunwar a anggelo e sau peteng tifri ini lo bo-i a, ");
INSERT INTO hrw_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","ma ri nano se e ongni, ka kuufsak ma sangfuunfuun lo sa fan efefe lo re fan sipsip ri peteng ini tifri. ");
INSERT INTO hrw_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Safle Maria e kep famti e fan warwar nano gii ulo bala ma ka sangsang ususi. ");
INSERT INTO hrw_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Fan efefe lo re fan sipsip ri la mil, ma ri ka akteni ma katfarsi e Deo lo fan mara mok ri ongni ma pari. Fan mara mok e sau fuut aregii anggelo kabuk peteng tifri ini. ");
INSERT INTO hrw_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Lo biing baba e wal, e ta biing una keti e pinumfow e bo-i a, ma ri ku fotngi ini Yesus, as anggelo e sau fotngi famu ma tinow ka tifik tian ini. ");
INSERT INTO hrw_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Lo biing biing una famapeknge ru aregii fafanau ke Moses ka peteng e puek, Josef ma Maria ru onu e Yesus wina Jerusalem una la fafen ini tife Taufi, ");
INSERT INTO hrw_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","(are ri sam seti ilo fafanau ke Taufi, “Fan mara bo-i tamat baba tikii ri fuut, riu fafen iri tife Taufi”), ");
INSERT INTO hrw_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","ma ru ku fafen ine wamborom bal, tam neng e wan man fuu e ngo ming are ambal, aregii fafanau ke Taufi ka peteng. ");
INSERT INTO hrw_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Lo sumbiing a e mel e kaltu ri fotngi ini Simion. I e melmel una Jerusalem. I e riis fasef ma e sagisu nining lo Deo. I e nene-i e kaltu Deo eu tuleni una pete balamas ire fan Israel. Ma i e fuunuf ine Tangwa Riis, ");
INSERT INTO hrw_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","iya, Tangwa Riis ka peteng tifi ini famu ma kamu met, i eu bi pari e Mesaiya, se Taufi eu tuleni. ");
INSERT INTO hrw_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Lo rawas ke Tangwa Riis, i e la kau ulo bala balo lo Felun Nining Bakir. Biing tamow ma tinow e boroner Yesus ru kep kaulek ini una gow e sa lo aregii fafanau ka peteng, ");
INSERT INTO hrw_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simion e kepe ine un limow ma ka katfarsi e Deo aregii: ");
INSERT INTO hrw_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Taufi, aregii o kabuk bom limlim, gii e fasi ini ou tule yau, kaltu na mus kiam, ya ku la tura balamaris. ");
INSERT INTO hrw_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Anwarow wan matang e sau pari e sa o sam gow una faliunge kemem, ");
INSERT INTO hrw_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","lewa o kabuk fagatiufu na matre tongge nano tinglo mara male, ");
INSERT INTO hrw_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","i e ta anten una pete malal ine Deo tifre fan Jentael ma una tow e finasuen tifre tongge kiam, Israel.” ");
INSERT INTO hrw_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Tamow ma tinow e bo-i, ru la kuufsak tibom lo sa Simion e war ini usi. ");
INSERT INTO hrw_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Wimi Simion ka warfakausi ri ma ka war singe tinow, Maria, “Bo-i gii Deo e sam wele una bero ma una faliungere fa fuunfuun lo re fan Israel. I eu ta tintof singe Deo, safle tongge fuunfuun riu fasange singi, ");
INSERT INTO hrw_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","usi ini sinsinangure fa fuunfuun eu puek malal. Ma o, o ku ongni ini ri taba e anmatkom ine ringgot faen.” ");
INSERT INTO hrw_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Uwa, e mel e neng e wok ming e ta profet, asow gii Ana. I e ta sikow fefin e Fenuel, tinglo matambia a Eisa. I e sam ta wok matuk. I e melmel tura ke matuk lo baba fis na matamfaim, wimi ine antinaule ke ru. ");
INSERT INTO hrw_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ka la ke matuk ka met ma i ka makos ka muut e la ta e wal e sangfuul ma e fet na matamfaim kia. Wok gii Ana e tibi lala kosnge Felun Nining Bakir. I e su melmel ilo ka felfel ma ka nining lo fan mara panambiing ma fan mara siat. ");
INSERT INTO hrw_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Lo pansumbiing sekit a i ka fespuek talo ri, i e tow e katfariis tife Deo ma ka warwar lo bo-i a tifre tongge nano a ri ka nene ini Deo eu kepfamil re tongge tingna Jerusalem. ");
INSERT INTO hrw_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Biing Josef ma Maria ru sau faropo e mara mok aregii fafanau ke Taufi ka peteng, ri la mil ulo taon riis keri Nasaret, ilo prowins ina Galili. ");
INSERT INTO hrw_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ma bo-i a ka faf ma ka puek rawas, i ka fuunuf ine atausimale ma warfakausi ke Deo ka ta ulo. ");
INSERT INTO hrw_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Tikii neng, tikii neng e matamfaim, tamow ma tinow e Yesus ru lala wina Jerusalem lo fan En na Kepsiliwi. ");
INSERT INTO hrw_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Biing e sam tikii sangful ma e u na matamfaim kia, ri tuul la wilo En, aregii ri ka gowgow. ");
INSERT INTO hrw_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Biing En e sam rop, tamow ma tinow ru tofnge fes una la mil wilo male ma boroner Yesus ka mel sok una Jerusalem, safle ru tibi parfat ini i e mel sok uwa. ");
INSERT INTO hrw_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ri su fes lala ka muut lo biing kiruur, anwarow ru sangfi ini i e sam ta una balri. Kala ru kam tofnge una sik lala ini, falifu ire fan taltaluri ma fan fenfenngori. ");
INSERT INTO hrw_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Biing ru tibi la pari, ru la mil sekit wina Jerusalem una la sik ini. ");
INSERT INTO hrw_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Wimi ine e tuul e biing, ru la sikseni ulo bala balo lo Felun Nining Bakir. I e kiiskiis u falifu ire fan titsa, ka ongongne singri ma ka gatgatom ri ine fang gatgatom. ");
INSERT INTO hrw_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Tongge nano a ri ka ongni e fang kokos kia, ri la kuufsak lo parfat kia. ");
INSERT INTO hrw_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Biing tamow ma tinow ru pari, ru la kuufsak tikin. Tinow ka war singi, “Sikuang, e tamu o ka gau kama aiya? Kama tamam, kama sangkuuluung tikin usi o, anwarow kama sam la met na siksik iyo.” ");
INSERT INTO hrw_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Yesus ka koso, “E tamu kamu ka siksik i yau? Kamu tibi parfat ini eu ta yau ilo bala fel ke Tabuung?” ");
INSERT INTO hrw_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Safle ru tibi pauti e bala e sunwar kia. ");
INSERT INTO hrw_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Kala Yesus ka mi nami ru, ri tuul ka la ding mil una Nasaret ma bingne i e ongong sing ru. Safle tinow e sagifamteni e fan mara mok a. ");
INSERT INTO hrw_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ma Yesus ka faf bakir tura atausimale, ma Deo tiim tura re tongge ri fefeal lo. ");
INSERT INTO hrw_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Lo matamfaim baba tikii sangful ma e lim ke Sisa Taiberius e ta king kere fan Rom, lo fam biing Ponsus Pailat e ta gawana ke prowins Judia, Erot ka ta gawana ke prowins Galili, ma tualik singe Filip ka ta gawana ke e u e prowins, Ituria ma Trakonitis, ma Laisanias ka ta gawana ke prowins Abilien, ");
INSERT INTO hrw_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","lo bala fam biing a Anas ma Kaiyafas ru ta um paklure fam pris, sunwar ke Deo e fespuek talo Jon sikow e Jekaraiya ulo male e tek ti kaltu. ");
INSERT INTO hrw_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","I e fes fawet ulo mara male liflifti e dan Jodan ka sesngeni lala e sunwar tifre tongge ini riu sangikis ma ri ku kepe e amfagu tarawen una fanangsi ini ri sam iksi e balbalri, usi Deo eu sangintafngi e fan tubiil keri. ");
INSERT INTO hrw_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Profet Aisaiya e sam seti e sunwar Deo e peteng ini tifi aregii: “Ulo male e tek ti kaltu, angkiimkiim a neng e tautau aregii, ‘Fagati e sal ke Taufi, Fariisu e fan sal kia. ");
INSERT INTO hrw_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ofo e mara pimpa-i, ilufufu e pakpaklunmale lamlam ma pakpaklunmale balik, ku riis. Fan sal e guut e samusu riis, fan sal e soksok e samusu bilimlim. ");
INSERT INTO hrw_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ma tongge nano ri ku pari e faliunge Deo eu gow lo ri.’” ");
INSERT INTO hrw_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Tongge fuunfuun ri puek use Jon una sa kepe e amfagu tarawen ma i ka war singri aregii, “Gam na fan siksikwan sii! Se e sau fate gam una finngeni e singmat na balasak ke Deo a ka bala puek? ");
INSERT INTO hrw_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Gam samusu gow e konona fan sinang una fanangsi ini gam sam sangikis. Ma gam ku mele tofnge una war sing gam tibom ini ‘Abra-am e ta tamrer.’ Ya peteng tikin tif gam aregii, anwarow tinglo fatfat gii, Deo e fasi una famtet re berberat ke Abra-am. ");
INSERT INTO hrw_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Palnget e sam ta ilo warow e fang kalut ma mara kalut a ri ka tibi firfira kausi, riu pokufuf ri una bas ilo bala iif.” ");
INSERT INTO hrw_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Tongge a ri ka gatmo, “Ma le ku ta aiya, sa sekit kemem samusu gow?” ");
INSERT INTO hrw_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","I ka koso, “Se gii ka mel e e u e kolos kia, i e samusu tow e neng tife se gii ka tek ti kolos kia ma se a ka mel e fan tuan aiya, i e samusu gorot aiya ming.” ");
INSERT INTO hrw_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Fa a ri ka ta tongge na kepkep mani, ri sa la ming una sa kepe e amfagu tarawen, ri ka gatmo, “Titsa, kemem samusu gow e sa?” ");
INSERT INTO hrw_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","I ka peteng tifri, “Gam u tibi awit wiyat ine e fis e mani gapman e a-uu lo gam una faran ini.” ");
INSERT INTO hrw_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Kala galun soldia ri ka gatmo, “Ma kemem samusu gow e sa?” I ka koso, “Mele tungni e tikas una fen fofoes i gam ine ti mani ma mele oteng gurgurum ini una tatfeni e mani kia. Gam samusu balamas use sese fiimfiil ri fiil gam ini.” ");
INSERT INTO hrw_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Tongge ri nene-i e Mesaiya, iya ri ka sangfuunfuun ulo balbalri ini Jon e ta i, tam e tam. ");
INSERT INTO hrw_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Jon ka peteng tifri nano aregii, “Ya gu tarawen i gam ine dan. Safle e mu mel e ti kaltu e mu puek, rawas kia e kulfi e rawas kiang. Ya tibi ta konona kaltu e fasi ini yau pikii e amfinau lo su kia. I eu gu tarawen i gam ine Tangwa Riis ma iif. ");
INSERT INTO hrw_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","I eu puek are kaltu e puse lo saol una tii ine fam piinpiin tinglo fan wit, ma i ku sartiim ine fan wit ku touftiim iri ilo felun wit kia, safle fam piin eu bas ini lo iif e tibi metmet.” ");
INSERT INTO hrw_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ma Jon ka farawasnge ri ine mara warwar ma fabenge, ma ka sesngeni e konona sunwar tifri. ");
INSERT INTO hrw_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Safle biing Jon e war na mata e gawana Erot, le i e sam tili e Erodias wok ke tualik, tura fan mok saksak ming i e sam gow lo, ");
INSERT INTO hrw_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Erot e gow e neng e mok saksak ming ulo poktow e fan sinang saksak kia; i e towfu e Jon ulo felun rerek. ");
INSERT INTO hrw_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Biing tongge ri kepkepe e amfagu tarawen, Yesus ming e kepe e amfagu tarawen. Ma pansumbiing i e nining, balambat e ipiik ");
INSERT INTO hrw_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ma Tangwa Riis ka pu talo are anman e par are ambal. Ma neng e angkiimkiim ka tau tinglo balambat aregii, “O na Sikuang ya bur o tikin. Balang e gasgas lo o.” ");
INSERT INTO hrw_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Gii Yesus e sam ngo are e tuul e sangful na matamfaim kia ma ka tofngeni e fam faim kia. I e ta tamat gii ri ka peteng ini i e ta sikow e Josef. Josef e ta sikow tamat e Eli, ");
INSERT INTO hrw_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli sikow e Metat, Metat sikow e Liwai, Liwai sikow e Melki, Melki sikow e Janai, Janai sikow e Josef, ");
INSERT INTO hrw_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josef sikow e Matatias, Matatias sikow e Amos, Amos sikow e Naum, Naum sikow e Esli, Esli sikow e Nagai, ");
INSERT INTO hrw_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai sikow e Ma-at, Ma-at sikow e Matatias, Matatias sikow e Semein, Semein sikow e Josek, Josek sikow e Joda, ");
INSERT INTO hrw_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda sikow e Joanan, Joanan sikow e Resa, Resa sikow e Serubabel, Serubabel sikow e Sialtiel, Sialtiel sikow e Neri, ");
INSERT INTO hrw_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri sikow e Melki, Melki sikow e Adi, Adi sikow e Kosam, Kosam sikow e Elmadam, Elmadam sikow e Er, ");
INSERT INTO hrw_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er sikow e Josua, Josua sikow e Elieisa, Elieisa sikow e Jorim, Jorim sikow e Matat, Matat sikow e Liwai, ");
INSERT INTO hrw_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Liwai sikow e Simion, Simion sikow e Juda, Juda sikow e Josef, Josef sikow e Jonam, Jonam sikow e Eliakim, ");
INSERT INTO hrw_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim sikow e Melia Melia sikow e Mena, Mena sikow e Matata, Matata sikow e Neiten, Neiten sikow e Dewit, ");
INSERT INTO hrw_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dewit sikow e Jesi, Jesi sikow e Obet, Obet sikow e Boas, Boas sikow e Salmon, Salmon sikow e Nason, ");
INSERT INTO hrw_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason sikow e Aminadap, Aminadap sikow e Ram, Ram sikow e Esron, Esron sikow e Peres, Peres sikow e Juda, ");
INSERT INTO hrw_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda sikow e Jekop, Jekop sikow e Aisak, Aisak sikow e Abra-am, Abra-am sikow e Tera, Tera sikow e Naor, ");
INSERT INTO hrw_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Naor sikow e Seruk, Seruk sikow e Re-u, Re-u sikow e Pelek, Pelek sikow e Eber, Eber sikow e Sela, ");
INSERT INTO hrw_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela sikow e Kainen, Kainen sikow e Arfakat, Arfakat sikow e Sem, Sem sikow e Noa, Noa sikow e Lamek, ");
INSERT INTO hrw_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek sikow e Metusela, Metusela sikow e Enok, Enok sikow e Jaret, Jaret sikow e Ma-alalel, Ma-alalel sikow e Kenen, ");
INSERT INTO hrw_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenen sikow e Enos, Enos sikow e Set, Set sikow e Adam, ma Adam e ta sikow tamat e Deo. ");
INSERT INTO hrw_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesus e fuunuf ine Tangwa Riis, ma i ka la mil tinglo dan Jodan ma Tangwa Riis ka onu ka la ulo male e tek ti kaltu. ");
INSERT INTO hrw_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Uwa, Satan ka lamu lo e fet e sangful na biing. I e tibi en ti tuan ulo bala fam biing a ma wimi ini, i ka biis. ");
INSERT INTO hrw_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Satan ka war singi, “Le ku ta o na Sikow e Deo, war singe fumfat gii ku ikis ku ta beret.” ");
INSERT INTO hrw_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yesus ka koso, “Sunwar ke Deo e peteng aregii: ‘Kaltu e tibi liu lo safle tuan tibom.’” ");
INSERT INTO hrw_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Kala Satan ka onu e Yesus ka la kanek ulo neng e paklunmale ma ka fanangsi saupesak ine fan mara kepmale tingga lo nal, ");
INSERT INTO hrw_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","ma ka war singi, “Yau tow e fam finaswen kere mara kepmale gii tifo ma rawas una efe lo ri, anwarow ri sam tow kiang ma ya fasi una tow tife se ya bura ini yau tow tifi. ");
INSERT INTO hrw_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Iya, le o ku pukungkek ma nining lo yau, fan mok gii eu ta kiam.” ");
INSERT INTO hrw_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ma Yesus ka war singi aregii, “Sunwar ke Deo e peteng aregii: ‘Nining lo Taufi, Deo kiam, ma faim singi tibom.’” ");
INSERT INTO hrw_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Satan ka onu ka la fetiufu ulo su e ngo uiyat sekit lo Felun Nining Bakir ma ka war singi, “Le ku ta ini o na Sikow e Deo, ofpu ting wagii. ");
INSERT INTO hrw_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Anwarow Sunwar ke Deo e peteng aregii: ‘Deo eu tulere fan anggelo kia una fakale lo o, ");
INSERT INTO hrw_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ri ku sange o ine limlim ri usi ini eu tek ti fat eu ti lo kekem.’” ");
INSERT INTO hrw_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yesus ka koso, “Sunwar ke Deo e peteng aregii, ‘Ou tibi tofo e Taufi Deo kiam.’” ");
INSERT INTO hrw_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Biing Satan e sam la rorop una lamu lala e Yesus, i ka la kosnge Yesus ka la nene i e tikas ti biing ming aiwa. ");
INSERT INTO hrw_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yesus e fuunuf ine rawas ke Tangwa Riis ma ka la mil una Galili. Ma saupesak sinseng lo ka omseni kiruur e male a. ");
INSERT INTO hrw_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Bingne, i e fafabenge singre tongge ilo bala fam felun nining keri ma tongge nano ri ka katkatfarsi. ");
INSERT INTO hrw_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","I ka la una Nasaret, lo male e bakir ulo, ma lo Biing Sabat i e la kaulek ulo bala felun nining le e ta ninis kia ma i ka ti una wese e Sunwar ke Deo. ");
INSERT INTO hrw_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ri ka tow e buk lo warwar ke Deo gii profet Aisaiya ka seti tifi, i ka ipki ma ka sik ine galu ri seti e sunwar gii ulo: ");
INSERT INTO hrw_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Tangow e Taufi gii lo yau, anwarow i e sam wel yau una sesngeni e konona sunwar tifre fan sasngal. I e tule yau una sesuupuek ine sunwar ini tongge ilo rerek riu suu, ma fa matmatri e baf, riu par, se ri a ri ka liil ilo bala fan mafet, riu suu kosnge fan mafet a, ");
INSERT INTO hrw_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ma ini biing ke Taufi una bilseni e fabur kia e sau puek.” ");
INSERT INTO hrw_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Wimi Yesus ka batu mil e buk ma ka tow tife kaltu una efefe lo fam buk ma ka kiisuf. Matmatre tongge nano ulo bala felun nining e ngosok ulo, ");
INSERT INTO hrw_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","ma i ka tofnge una war singri aregii, “Geinggii sunwar gii e fawet sekit ilo ongong kemi.” ");
INSERT INTO hrw_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ri resngeni ma ri ka sangfuunfuun singe konona fan warwar e sam suu tinglo ngusu e Yesus ma ri ka war, “Ka bi su ta ini sikow e Josef le gii.” ");
INSERT INTO hrw_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ma Yesus ka war singri aregii, “Ya parfat tikin ini gam u war mil ine sunwar na atausimale gii tif yau: ‘Dokta, bow faliunge o!’ Pimpiku e sunwar toftof a igii, ‘Gow e fan mok na tibou fuut wagii lo male kiam tibom, are fan sa kemem sam ong lo ini o gow una Kapernaum.’ ");
INSERT INTO hrw_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","“Safle ya peteng tikin tif gam, e tek tikas ek ongong singe ti profet ilo anwaran male kia riis. ");
INSERT INTO hrw_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ya peteng tikin tif gam, e mel e fan makos fuunfuun una Israel lo biing ke Elaija, lo biing e pisii faen lo e tuul e matamfaim ma e on e funiil ma biis bakir ka puek ulo male kiruur. ");
INSERT INTO hrw_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Safle Deo e tibi tuleni e Elaija use tikas lo ri. I e tuleni subung use neng e wok makos tinglo taon Serafat ilo bala rijen Saidon ma i e ta Jentael. ");
INSERT INTO hrw_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ma e mel e fa fuunfuun lo re fan Israel ri kepe e anminse lepra lo biing ke profet Elisa, safle Deo e tibi fakalkaliisngeni sekit e tikas lo ri - sakle Naman kaltu tingna Siria ma i e ta nenge Jentael.” ");
INSERT INTO hrw_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Biing tongge nano ulo bala felun nining ri ongni e war aiya, ri la balasak tikin. ");
INSERT INTO hrw_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ri matet ri ka fesel suu ini tinglo bala taon ma ri ka suleni ka la wilo anisow e antinwen gii ri ka gow e taon Nasaret ulo, usi ini riu la suleufu ulo fam, ");
INSERT INTO hrw_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","safle i e su sol falifu iri nano ka la fes lala. ");
INSERT INTO hrw_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Wimi i ka la ding una Kapernaum, neng e taon una Galili ma lo Biing Sabat, i e tofnge una fabenge singre tongge. ");
INSERT INTO hrw_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Uwa ming, tongge ri sangfuunfuun lo fam fabenge kia, anwarow sunwar kia e mel e rawas lo ma e mel e antuntunow. ");
INSERT INTO hrw_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ulo bala felun nining, e mel e neng e kaltu tangwaner saksak e sispi. I e kaung bakir tikin aregii, ");
INSERT INTO hrw_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Uui! Yesus tingna Nasaret! O bala sa tamu i kemem? Kele ma o fespuek una sa bero i kemem? Ya parfat lo o. O na Kaltu Pepe ke Deo!” ");
INSERT INTO hrw_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Safle Yesus e porow e tangwaner saksak a aregii, “Fakuta e ngusum ma o ku suu tinglo kaltu a!” Wimi tangwaner saksak a ka baspu ine kaltu a na matri nano ma ka suu tinglo, safle e tibi bero ini. ");
INSERT INTO hrw_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Tongge nano ri la kuufsak tikin gii ri ka fawar iri tibom aregii, “Sese matang gongon le gii? I e tungen re fan tangwaner saksak ine rawas ma mia ma ri ka suu!” ");
INSERT INTO hrw_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ma sinseng lo Yesus ka omseni kiruur e male a. ");
INSERT INTO hrw_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesus e la kosngi e felun nining ma ka la ulo fel ke Saimon. Yanow fefin e Saimon e bokor tuntun sak, iya ri ka gatmo e Yesus una ulsi. ");
INSERT INTO hrw_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","I ka la, ka la por unaisa ma ka porawufu e anminse a tinglo ma anminse a ka la kosngi e fefin a. Saupe sak i ka matet ma ka tofnge una fagati e fan tuan ari. ");
INSERT INTO hrw_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Biing pisii e sau bala sif, tongge ri ka uunpuek ire tongge gii ri ka mel lo fan matmatan minse use Yesus, ma i ka towfu e un limow uiyat ulo tikii neng tikii neng lo ri, ma ka faliungeri. ");
INSERT INTO hrw_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Fan tara saksak fuunfuun ming ri suu tinglo re tongge fuunfuun, ri ka tautau lala aregii, “O na Sikow e Deo!” Safle Yesus e porau ri ma ka fakuta e ngusngusri usi ini riu tibi gon, anwarow ri parfat ini i e ta Mesaiya. ");
INSERT INTO hrw_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Lo bau uwa e male lo biing usi, Yesus e la ulo neng e sum biilkap. Tongge ri siksik lala ini ma biing ri sa puek ulo male i ulo, ri tofo una kaleufu ini i eu tibi la kosing ri. ");
INSERT INTO hrw_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Safle i e peteng tifri aregii, “Anwarow gii Deo ka tule yau ya ka sa la igii: Ya samusu sesngeni e Konona Sunwar lo kepmale ke Deo tifre fanenger fan taon ming.” ");
INSERT INTO hrw_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ma i ka posmi e faim kia una sesngeni lala e Konona Sunwar ilo bala fam felun nining kere fan Judia. ");
INSERT INTO hrw_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Nenge biing Yesus e titi ulo anisow e salat Genasaret, tura tongge ri fuun liflifti ri ka ongongne lo sunwar ke Deo, ");
INSERT INTO hrw_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","i e pari e um buut ulo anisow e salat, tongge na tuntunii ri tafu ma ri ka la gugua e fan ubiin keri. ");
INSERT INTO hrw_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","I ka kau ulo bala neng lo re um buut a, neng gii ka ta ke Saimon ma i ka onu una soro balik waleii kosnge angkiin. Kala i ka kiisuf ma ka tofnge una fabenge singre tongge a, tinglo bala buut. ");
INSERT INTO hrw_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Biing i e gongon tikii, i e war singe Saimon, “Auseni e buut ku la wilo mok e maut ma gam ku baspu ine fan ubiin una kepe ti tom fis.” ");
INSERT INTO hrw_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Saimon ka war singi, “Kaltu bakir, kemem sau faim tuntun tikin tinglo panambiing ma kemem ka tibi kepe ti mok, sakle anwarow o sau fauun, yau baspu mil ine fan ubiin.” ");
INSERT INTO hrw_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Biing ri sam gow aregii i ka peteng, ri awit fam fis fuunfuun tikin ma fan ubiin keri ka usef una fus fafalek. ");
INSERT INTO hrw_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Iya ri ka kalif ine fan taltalu ri tura neng e buut una sa ules ri. Ri ka puek ma ri ka sengi e um buut nano ka la fuunuf, gii ri ka rong una maut. ");
INSERT INTO hrw_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Biing Saimon Pita e pari e mok gii, i e luut pukungkek ulo fow e ungkekow e Yesus ma ka war, “La kosing yau Taufi, ya na kaltu na tumtubiil!” ");
INSERT INTO hrw_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Anwarow i tura fan taltalu ri la sangfuunfuun singe fam fis ri awit. ");
INSERT INTO hrw_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Nenge un taltalu e Saimon, ru ming ru la sangfuunfuun. Asasru gii Jeims ma Jon, ma ru ta un sikow e Sebedi. Kala Yesus ka war singe Saimon, “O mana soke; ting geinggii ma ku la, ou kep re tongge.” ");
INSERT INTO hrw_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Iya ri ka fufte masa ine fam buut keri, ri ka toufsok lo mara mok ma ri ka mi nami. ");
INSERT INTO hrw_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Biing Yesus e ta ulo bala neng lo re fan taon, neng e kaltu tura anminse lepra e sa la. Biing i e pari e Yesus, i e luut pu ulo nal tura mata wifaf ma ka war fangfangteni, “Taufi le o ku fabur, o fasi una fakalkaliisnge yau.” ");
INSERT INTO hrw_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesus e sangau ine limow ka pot lo ma ka war, “Ya fabur. Ong kalkaliis!” Ma saupesak anminse lepra ka la kosngi. ");
INSERT INTO hrw_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Kala Yesus ka fanow aregii, “Ou tibi peteng tife tikas ine mok e sau fuut lo o, safle ou la, o ku la fanangsi o tibom tife pris ma o ku gow e finafen aregii Moses kabuk peteng, una fanangsi re tongge ini o sam kalkaliis.” ");
INSERT INTO hrw_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Sakle sunwar lo Yesus e omseni kiruur e male, iya tongge fuunfuun ri ka ong lo, ri ka puek usi ini ku faliungeri kosnge fan minse ari. ");
INSERT INTO hrw_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Safle fam biing fuunfuun Yesus e lala kosing ri wilo fan sum biilkap una la nining. ");
INSERT INTO hrw_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Nenge biing Yesus e fafabenge, fam Farasi ma fan titsa lo fafanau gii ri ka sa la tinglo fan male ina Galili ma tingna Judia ma Jerusalem, ri kiiskiis uwa ming. Rawas ke Deo e ta ulo Yesus ma i ka falfaliungere tongge ri mase. ");
INSERT INTO hrw_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Galun tamat ri ka kep puek ine neng e kaltu dol e ngongo lala ulo ngiin, ri bala kep kau ini ulo bala fel use Yesus. ");
INSERT INTO hrw_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Safle biing ri tibi par ti sal una kep kaulek ini, anwarow lo e tek ti sol singre tongge, ri fen tura ulo poktow e fel ri ka la akteufu e galu lo ma ri ka fauli ka pu u famu sekit ine Yesus. ");
INSERT INTO hrw_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Biing Yesus e pari ini titinge keri e rau tikin, i ka war singe kaltu a aregii, “Fenngong, ya sam kepufu e fan tubiil kiam.” ");
INSERT INTO hrw_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Fam Farasi ma fan titsa lo fafanau ri ka tofnge una sangfuunfuun using ri tibom, “Se tikin leleii ka fotpursi e Deo? E tek tikas e fasi una sangintafngi e fan tubiil, safle Deo tibom!” ");
INSERT INTO hrw_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yesus e sau parfat ini sa e ta ulo sinsinangu ri ma ka gatom, “Usi e tamu ka mel e matan sangsang aiya ailo balbalmi? ");
INSERT INTO hrw_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Sese sunwar e paumiil una war ini? ‘Ya sam kepufu e fan tubiil kiam,’ tam ‘Matet o ku fes’? ");
INSERT INTO hrw_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Sakle yau fanangsi gam ini Sikow e Kaltu e mel e mia gii lo nal una kepufu e fan tubiil.” Ma i ka war singe kaltu a aregii, “Ya peteng tifo, matet, kepe kem ngiin ma o ku la mil ilo keu fel.” ");
INSERT INTO hrw_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Saupesak kaltu a e matet na matri, ka kepe ke ngiin ma ka katfarsi lala e Deo ka la mil wilo fel kia. ");
INSERT INTO hrw_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ri nano ri kuufsak ma ri ka katfarsi e Deo. Ri kuufsak tura soke ma ri ka war, “Kiar sau pari e mok fuu ma e piik geinggii.” ");
INSERT INTO hrw_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Wimi ine mok gii, Yesus e la tingwa, ka la pari e neng e kaltu na kepkep mani, ri fotngi ini Liwai. I e kiiskiis ulo bala felun mani ma Yesus ka war singi, “Mi nami Yau.” ");
INSERT INTO hrw_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ma Liwai ka matet ka taufsok lo mara mok ma ka mi nami e Yesus. ");
INSERT INTO hrw_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Wimi, Liwai ka gow e en bakir ulo ke fel tura Yesus ma singmat na galung kaltu na kepkep mani ma fanenger fan tongge ming ri tau iri una sa la lo en, ri en tiim tura ri. ");
INSERT INTO hrw_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Safle fa lo re fam Farasi tura fan titsa keri lo fafanau, ri war fuunfuun singre fan disaipel ke Yesus aregii, “Usi e tamu gam ka en ma gam ka in tiim tura re tongge na kepkep mani, ma tongge na tumtubiil?” ");
INSERT INTO hrw_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesus ka war singri, “Tongge a ri ka tibi mase, ri tibi fasi una la use dokta, safle tongge ri mase ri fasi una la use dokta. ");
INSERT INTO hrw_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ya tibi sa la una sa tau ire tongge riis, e tam. Ya sa la una sa tau ire tongge na tumtubiil una sangikiis.” ");
INSERT INTO hrw_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ri ka war singe Yesus, “Fan disaipel ke Jon ri ngos lo fel ma nining lo an mara biing ma fanenger kere fam Farasi ming, safle fan disaipel kiam, ri su ngos lo en ma in.” ");
INSERT INTO hrw_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesus ka war singri, “Gau fasi ming una gau re tanga fenfenngow e kaltu a ka bala tinaule ri ku feleni e en, ma i ka melmel iwa tura ri? E tam, ");
INSERT INTO hrw_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","sakle e mu mel e biing eu puek una onu e kaltu a ka bala tinaule ku la kosing ri; lo bala fam biing a, ri kamu fel a.” ");
INSERT INTO hrw_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yesus ka peteng tifri ine sunwar toftof gii, “E tek tikas ek sisi e tian sin laplap tinglo neng fuu ma ku soko talo neng ting nangen. Le ku gow aiya, i eu rangsi e su fuu, ma sun laplap fuu a, eu tibi fasi use su ting nangen. ");
INSERT INTO hrw_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ma e tek tikas ek ututfi e ti waen fuu talo bala ti ampinun meme ting nangen. Le ku gow aiya, waen fuu a, eu ese paki e ampinun meme a, ku lingi tikii ma iru nano ru ku tiin la sak. ");
INSERT INTO hrw_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Waen fuu, ri samusu tipeni talo bala ampinun me fuu. ");
INSERT INTO hrw_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ma e tek tikas ek bura una inmi e ti waen fuu wimi ini e sam inmi e neng ting nangen, i eu su war aregii, ‘Neng ting nangen e kausi tikin.’” ");
INSERT INTO hrw_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Nenge Biing Sabat, Yesus e fes lala ulo bala fam palang na wit ma fan disaipel kia ri ka kutuul pakti lala e fanenger lo ri, ri ka goso ulo bala limlim ri ma ri ka eni e firfirow. ");
INSERT INTO hrw_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Fa lo re fam Farasi ri ka gatom, “Usi e tamu gam ka gow e faim e pepe una gow lo Biing Sabat?” ");
INSERT INTO hrw_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesus ka koso singri, “Gam tifik su wese sekit e sinseng lo mok Dewit e sam gow nangen lo biing i tiim tura re tongge kia, ri fitol? ");
INSERT INTO hrw_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","I e kau ulo bala fel ke Deo ka la kepe beret e pepe. I e eni e sa e pepe. E su ta ini are fam pris tibom una enen. Ma ming, i e fenre tongge kia ine fanenger lo ri.” ");
INSERT INTO hrw_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Kala Yesus ka posmi e sunwar kia tifri aregii, “Sikow e Kaltu e ta Taufi lo Biing Sabat.” ");
INSERT INTO hrw_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Lo neng e Biing Sabat ming, i e kau ulo bala felun nining, ka la fabenge singre tongge. Ma e mel e neng e kaltu uwa galun limow miil e met. ");
INSERT INTO hrw_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Fam Farasi ma fan titsa lo fafanau ri siksik ine ti sangsang una anganggon singe Yesus tura. Iya ri ka efe kausi tikin lo Yesus, anwarow ri bur parfat ini i eu faliungere tongge ri mase lo Biing Sabat, tam e tam. ");
INSERT INTO hrw_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Sakle Yesus e parfat lo ini are ri sangsang ma ka war singe kaltu a galun limow miil ka met aregii, “Matet, o ku ti na matre tongge nano gii.” Iya i ka matet ka ti na matri. ");
INSERT INTO hrw_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Kala Yesus ka gatom ri, “Sese sinang e riis ususi e fafanau ini kiar u usi lo Biing Sabat? Una gow e konona sinang, tam una gow e sinang e sak? Una faliungeni e ninliu ke kaltu, tam una bero ini?” ");
INSERT INTO hrw_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Yesus e alal lo ri nano ma kam war singe kaltu a aregii, “Fariisu e limam.” I e usi aregii Yesus ka peteng ma limow ka kausi mil. ");
INSERT INTO hrw_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Safle balbalri e la tuntun tikin ma ri ka tofnge una fawar falifu iri tibom ini sa riu gow lo Yesus. ");
INSERT INTO hrw_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ulo bala tikii neng lo re fam biing a, Yesus e la ulo paklunmale una la nining ma lo pam panambiing kiruur a i e nining singe Deo. ");
INSERT INTO hrw_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Lo biingbiing e mok, i e tau ire fan disaipel kia ma ka wele tikii sangful ma e u lo ri, ma ka foteng ri ini fan apostel. ");
INSERT INTO hrw_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Asasri gii: Saimon (se e fotngi ini Pita), tualik e Pita asow gii Enru, Jeims, Jon, ma Filip, Batolomius, ");
INSERT INTO hrw_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Metiu, Tomas, Jeims sikow e Alfius ma Saimon (tinglo galung kaltu ri foteng ri ini fan Jilot,) ");
INSERT INTO hrw_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas sikow e Jeims, ma Judas kaltu una mu solamufu e Yesus. ");
INSERT INTO hrw_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","I e ding tura ri, ri ka la ti ulo lubun. Galu bakir lo re fan disaipel kia tura singmat na galung kaltu tinglo male kiruur ina Judia, tingna Jerusalem ma tinglo angkiin ina Tair ma Saidon, ri ta uwa. ");
INSERT INTO hrw_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ri sau puek usi una sa ongne singi, ma ini i ku faliungeri kosnge fan mara minse ari. Fa fan tara saksak ri sispi ri, Yesus e faliungeri. ");
INSERT INTO hrw_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Tongge, ri tiin tofo una pot lo, anwarow rawas e la tinglo ma ka falfaliunge ri nano. ");
INSERT INTO hrw_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Kala Yesus ka giliim use re fan disaipel kia ma ka war, “Warfakausi eu ta ilo gam na seri a gam ka sasngal, le kepmale ke Deo e ta kemi. ");
INSERT INTO hrw_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Warfakausi eu ta ilo gam na seri a gam ka biis geinggii, le gam amu sut. Warfakausi eu ta ilo gam na seri a gam ka sangkuuluung geinggii, le gam amu gasgas. ");
INSERT INTO hrw_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Warfakausi eu ta ilo gam, lo biing tongge riu is gam, riu wesuf gam kosing ri, riu porau saksak i gam, ma ri ku pari e asasmi are mok saksak, nafow e Sikow e Kaltu. ");
INSERT INTO hrw_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Fefeal lo biing a. Of ma o ku guui tura gasgas, le fimfiil kiam ilo balambat e bakir tikin. Anwarow lo tikii sal mung gii, tumtumlari, ri gow aiya e fam profet. ");
INSERT INTO hrw_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Safle kiskam sing gam na seri a gam ka mel e tubami, le gam sam kepe e sa una pete balamas i gam. ");
INSERT INTO hrw_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Kiskam sing gam na seri a gam ka sut geinggii, le gam amu biis. Kiskam sing gam na seri a gam ka ruuruur feal geinggii, le gam amu sang kuuluung ma gam ku teng. ");
INSERT INTO hrw_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Kiskam sing gam na seri a, tongge ri ka resnge gam, anwarow lo tikii sal mung a, tumtumlari, ri gow aiya e fam profet gurgurum. ");
INSERT INTO hrw_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Safle ya peteng tif gam na seri gii gam ka bura una ongne sunwar kiang. Gam samusu bura e tongge na matamfais kemi. Gow e konona sinang lo re fa a ri ka is gam. ");
INSERT INTO hrw_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Nining singe Deo ini eu warfakausi e se a ka gatmo e Deo una fakutun aiyam. Nining usi re fa gii ri ka gow e fan sinang e sak lo gam. ");
INSERT INTO hrw_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Le tikas ku pose o ilo ambanguam, ikis ine neng e galu ming tifi. Ma le tikas ku kepe e kolos tapak kiam ku la, tafu ku kepe e neng pospos ming. ");
INSERT INTO hrw_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Fenre tongge nano a ri ka faran sing o. Ma le tikas ku kepe e sa e ta kiam, mele faran mil ini. ");
INSERT INTO hrw_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Sese mok a gam ka bura ini fa riu gow lo gam, gam samusu gow ming lo ri. ");
INSERT INTO hrw_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Le gam ku bur re tongge a ri ka bur gam, se gii ku peteng ini gam na tongge kausi? Tongge na tumtubiil ming, ri sagisu burbur re tongge gii ri ka bur ri. ");
INSERT INTO hrw_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ma le gam ku gow e konona sinang lo re fa a ri ka kausi lo gam, se gii ku peteng ini gam na tongge kausi? Tongge na tumtubiil ming, ri sagisu gowgow e tikii sinang gii. ");
INSERT INTO hrw_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ma le gam ka tow e fan mok tifre tongge gau parfat ini riu koso, se gii ku peteng ini gam na tongge kausi? Tongge na tumtubiil ming, ri sagisu tata fan mok tifre tongge na tumtubiil, ma ri ka sangsang ini riu fiil familri. ");
INSERT INTO hrw_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Safle gam samusu bure tongge na matamfais kemi, gow e konona fan sinang lo ri. Ma gam u fen ri ine fan mok ma mele sangfi ini riu koso mil. Ilea, gam samusu gorot aiya usi fimfiil kemi eu bakir, ma sinang kemi ku ngo are sinang ke Deo se e ta iyat sekit, anwarow i e kausi lo re tongge a ri ka tibi araro singi ma tongge saksak. ");
INSERT INTO hrw_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Gam samusu tengis re fa, aregii Taumi ming ka fafatengis. ");
INSERT INTO hrw_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Gau mele ikseni e sinangu e neng e kaltu are Deo kam ikse gau ming. Ma mele bero ine neng e kaltu are Deo kau bero i gam. Gam samusu sangintafngi e fan tubiil, fa ri gow lo gam, usi Deo eu sangintafngi ming e fan tubiil kemi. ");
INSERT INTO hrw_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Fenre fa ma Deo e amu fen gam. I eu fen fakausi gam, ku tukeni wifaf, ku sagetiim ini ma ku fafonsi ku la ibeluf. Lo sese fan sinang a gam ka gowgow lo re fa, Deo eu gow aiya ming lo gam.” ");
INSERT INTO hrw_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yesus e war singri lo warwar toftof aregii, “E fasi ini ti kaltu e baf eu famu ine neng e baf? Ma ru nano ruw tibi suu ilo ti ampolo, be? ");
INSERT INTO hrw_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Boroner na fabenge e tibi kulfi e titsa kia, safle seri a ri kabuk faropo e fabenge keri, ri su ngo are fan titsa keri. ");
INSERT INTO hrw_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“E tamu gii o ka pari e amboron mukmuk ilo anmata e tuamlik ma o ka tibi sangfi e sung kalut e ngongo ailo anmatam tibom? ");
INSERT INTO hrw_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Le o ku peteng tife tuamlik, ‘Tuaklik, tagii ya ku kepufu e anmukmuk ailo anmatam’ ma o ka tibi pari e singmat na sum palang ailo anmatam tibom. O na kaltu na matam pangkii, ou kepufu famu e sung kalut ailo anmatam tibom usi ou par ten ma o kamu kepufu e anmukmuk ailo anmata e tuamlik. ");
INSERT INTO hrw_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Konona ton au e tibi fasi una fira ine fingfingwan au saksak, ma ming, ton au saksak e tibi fasi una fira ine fingfingwan au kausi. ");
INSERT INTO hrw_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Tikii neng, tikii neng e kalut ri parfailmi ilo fingfingow tibom. Tongge ri tibi luslus firfiram fik tinglo fam finau soksok, tam fingfingwan waen tinglo fam balan tenmok soksok. ");
INSERT INTO hrw_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Konona kaltu eu fanangsi e konona fan sinang e la tinglo konona fan mok a ka fuunuf ilo bala, ma se a ka fuunuf e bala ine fan mok saksak, i eu fanangsi e fan sinang e sak. Anwarow, le sese mok a ka fuunuf ilo balang kaltu, eu la suupuek ilo ngusu. ");
INSERT INTO hrw_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Usi e tamu gii gam ka foteng yau ini ‘Taufi, Taufi,’ ma gam ka tibi gowgow e fan sa ya peteng ini? ");
INSERT INTO hrw_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Yau fanangsi gam ine parpar lo kaltu e sa la usi yau, sinangu are eu ngo, lo biing i e sam ongni e sunwar kiang ma ka usi ilo ninliu kia. ");
INSERT INTO hrw_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","I e ngo are kaltu e bala gow e fel. Kaltu a e kekef ka pu sekit ma ka tofngeni e warow e fel kia ine fam fatfat lamlam ma kam gow e fel ulo poktow. Biing male e fuun ma dan ka suu, anring lo e sa tuktuke ulo fel a, safle fel a e tibi luut, anwarow i e bilse fakausi. ");
INSERT INTO hrw_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Safle se a ka ongni e sunwar kiang ma ka tibi usi, i e su ngo are kaltu e gow e fel kia ilo nal fofoes, ma ka tek ti warow. Biing male e fuun ma dan ka suu, anring lo e sa tukeni e fel a ma fel a ka luut ka la sak sekit.” ");
INSERT INTO hrw_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Biing Yesus e sam sesngeni tikii e fan mok gii tifre tongge, i e la mil una Kapenaum. ");
INSERT INTO hrw_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Wa kaltu na mus ke kaltu bakir kere fan soldia tingna Rom, e mase ma ka bala met. Ma kaltu bakir kia e natkeni tikin. ");
INSERT INTO hrw_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Biing kaltu bakir kere fan soldia e ong lo Yesus, i e tule re ge lamlam kere fan Juda usi, una la gatmo ini eu sa la ku sa faliungeni e kaltu na mus kia. ");
INSERT INTO hrw_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Biing ri sa puek talo Yesus, ri war rawas tikin singi, “Kaltu gii e riis ini ou ulsi, ");
INSERT INTO hrw_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","anwarow i e bur kerer tikin na fan Juda. Ma ming i e sam gow e felun nining kerer.” ");
INSERT INTO hrw_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Iya Yesus ka la tura ri. Safle biing ri sam sa puek fatatu e fel, kaltu bakir lo re fan soldia e tule re fam fenfenngow una la peteng tifi aregii, “Taufi, mele sangfuunfuun tibom una sa la ilo kek fel, anwarow e tibi ta ini ya na kaltu riis ku fasi ini ou sa kaulek ilo kek fel. ");
INSERT INTO hrw_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ilea ya ka par yau tibom ini ya tibi ta kaltu riis una bom sa la usi o. Safle on su war ma kaltu na mus kiang ku liu. ");
INSERT INTO hrw_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Anwarow, yau ming ya ta neng e kaltu ilo e pikliu e neng e rawas, ma e mel e fan soldia ilo pikliu e efefe kiang. Le ya ku war singe tikas lo ri, ‘On la,’ i eu la! Ma ya ku war singe neng, ‘Kasa,’ i eu sala! Tam ya ku war singe kaltu na mus kiang, ‘Gow e mok gii,’ i eu gow.” ");
INSERT INTO hrw_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Biing Yesus e ongni e kaltu a e war aiya, i e la kuufsak lo fan warwar kia. I e giliim use re tongge a ri ka ususi lala ma ka war, “Ya peteng tikin tif gam, ya tifik tongeni e tikas gii na Israel e mel lo matan titinge aregii.” ");
INSERT INTO hrw_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ma biing tongge gii kaltu bakir lo re fan soldia ka tuleri ka la, ri sa mil ulo fel, ri sa pari ini kaltu na mus a e sam liu mil. ");
INSERT INTO hrw_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","E tibi su bafu ini ma Yesus ka la ulo neng e taon ri fotngi ini Nain, ma fan disaipel kia tura singmat na galung kaltu ri ka mi nami. ");
INSERT INTO hrw_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Biing i e fespuek fatatu e sal una kau ilo taon, i ka pari e galung kaltu ri kepkepe lala e neng e kaltu e sau met. Kaltu a e su tikiin i e ta sikow tamat e neng e wok, ma wok a e sau makos. Ma singmat na galung kaltu tinglo taon ri ta tura wok a. ");
INSERT INTO hrw_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Biing Taufi e pari e wok a, i e tengsi tikin ma ka war singi, “O mele teng.” ");
INSERT INTO hrw_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","I e la fatatu e ngiin gii ri ka towfu e kaltu a ulo ma ka la pot lo, iya tongge a ri ka kepkepe lala e kaltu a ri ka la ti sok. I ka war singi, “Guam, ya peteng tifo, on matet!” ");
INSERT INTO hrw_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Kaltu a ka met a, i e matet ka kiis ma ka tofnge una war, wimi Yesus ka tow mil tife tinow. ");
INSERT INTO hrw_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Tongge nano ri la kuufsak ma ri ka tofnge una katfarsi e Deo. Ri war aregii, “Nenge profet bakir e sau puek falifu i kiar! Ma Deo e sam sa la una sa ules re tongge kia!” ");
INSERT INTO hrw_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Sinseng lo mok Yesus e bilseni e omseni kiruur e male Judia ma fan mara male liflifti. ");
INSERT INTO hrw_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Fan disaipel ke Jon ri peteng tifi ine mara mok Yesus e bilseni. I kam tau ine un neng lo ri ");
INSERT INTO hrw_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ma ka tule ru use Taufi una la gatmo, “E sam ta o na kaltu gii Deo ka peteng ini i eu tule o, tam kemem u nene-i e tikas kuriik?” ");
INSERT INTO hrw_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Biing ung kaltu gii ru sa puek talo Yesus, ru sa war singi, “Jon kaltu na gugu tarawen e uun kama usi o, una sa gatom o, ‘E sam ta ini o na kaltu lewa Deo ka limlim ini i eu tule o legii, tam kemem u parpar ine tikas kuriik?’” ");
INSERT INTO hrw_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Lo biing a sekit, Yesus e faliungere tongge fuunfuun e mel e fan matmatan minse ulo ri ma ka tii ine fan tara saksak ulo fofori, ma ka faliungere fam baf ri ka par mil. ");
INSERT INTO hrw_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","I e peteng tifre ung kaltu a aregii, “Kamuw la peteng tife Jon ine fan mara mok kamu sam ongni ma kamu sau pari, fam baf ri par mil, tongge kekek ri e sak ri fes mil, tongge fofori e mel e anminse lepra ri puek kausi mil, tongge balbaluri e kut, ri ong. Tongge ri sau met ri matet mil, ma konona sunwar ri ka sesngeni tifre fan sasngal. ");
INSERT INTO hrw_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Warfakausi e ta ilo se a titinge kia lo yau ka tibi luut.” ");
INSERT INTO hrw_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Wimi ine wan unune ke Jon ru sam la mil, Yesus e tofnge una seseng tifre tongge ine Jon aregii, “Biing gam u la ilo male e tek ti kaltu, gam la una la pari e sa? Ya sang ini gam la una la pari e kaltu warwar kia e ngo are fum fiit kif e kifkifeni? ");
INSERT INTO hrw_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ma le ku tam, gam la una la pari e sa? Ti kaltu e los lo konona fang kolos? E tam, tongge ri los lo fang kolos mata e kanek tibom, ma ri mel lo konona mara mok, ri melmel ilo fam fel kere fang king. ");
INSERT INTO hrw_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Sakle sa gam la usi una la pari? Gam la una la pari e ti profet, be? Yow. Yau peteng tif gam, i e kulfi e fan mara profet nano. ");
INSERT INTO hrw_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Jon e ta kaltu lewa ri kabuk siisiit nafow aregii, ‘Yau tuleni e ti anunune kiang famu iyo. I eu la fagati e sal kiam.’ ");
INSERT INTO hrw_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yau peteng tif gam, falifu ire berberat gii gelefin ri ka fasus iri, e tek tikas ek bakir iyat ine Jon. Sakle se a ka ta imi sekit ire tongge nano ilo bala kepmale ke Deo, i e bakir iyat ine Jon.” ");
INSERT INTO hrw_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","(Tongge nano, tiim tura re tongge una kepkep mani, ri ongni e fan warwar ke Yesus, ri parfailmi ini ninis ke Deo e riis, anwarow ri sam kepe e amfagu tarawen singe Jon. ");
INSERT INTO hrw_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Sakle fam Farasi ma tongge parfat lo fafanau, ri guuluung ine konona sal Deo e sau fanangsi ri ini, anwarow ri guuluung ini Jon eu gu tarawen iri.) ");
INSERT INTO hrw_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesus ka war ming aregii, “Yau fatofo e kulu tinglo biing gii lo sa? Are ri ngo? ");
INSERT INTO hrw_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ri ngo are berberat ri kiiskiis ilo male na tiim ma ri ka tautau faliu singri tibom: ‘Kemem kifii e antulal tif gam ma gam tibi guui. Kemem seke e seksek na fatengis ma gam tibi teng.’ ");
INSERT INTO hrw_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Anwarow biing Jon kaltu na gugu tarawen e puek, i e tibi enen beret ma e tibi inin waen, ma gam ka peteng ini, ‘I e mel e tangwaner saksak ilo.’ ");
INSERT INTO hrw_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Sikow e Kaltu e puek ka ininin ma ka enenen, ma gam ka peteng ini, ‘Gau par, kaltu gii e en karef ma e biit waen tikin, ma i e ta fenngore tongge una kepkep mani ma tongge na tumtubiil.’ ");
INSERT INTO hrw_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Sakle se a ka mel lo atausimale ke Deo, i eu fanangsi ini atausimale ke Deo e tikin.” ");
INSERT INTO hrw_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Neng lo re fam Farasi e tau ine Yesus una sa en faiya tura. Iya Yesus ka la ulo fel kia ka la kiis una en tura. ");
INSERT INTO hrw_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ma biing neng e fefin na tumtubiil ulo taon a e ong ini Yesus e ta ulo fel ke Farasi a, i e kep puek ine neng e botol ri gow lo alabasta ine sanda e nul kausi tikin ulo bala. ");
INSERT INTO hrw_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ma i ka sa ti una mi e Yesus, fatatu e ung kekow ma ka teng. Ma biing i e teng i e tofnge una gua e ung kekow e Yesus ine darun mata. Wimi i kam si ka mas e ung kekow ine ololow, ma ka osngi e ung kekow ma kam tipeni e sanda e nul kausi ulo. ");
INSERT INTO hrw_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Biing Farasi a e pari e sa e fuut, ulo sinangu e war singi tibom aregii, “Le kaltu gii enggi ta profet tiktikin, i enggi parfat lo ini se gii ka pot lo, ma i e ta sese matam fefin, i e ta fefin na tumtubiil!” ");
INSERT INTO hrw_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ma Yesus ka war singi aregii, “Saimon, ya bala peteng tifo ine neng e mok.” Ma Saimon ka war singi, “Peteng tif yau, titsa.” ");
INSERT INTO hrw_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","“E mel e ung kaltu ru dinau mani singe neng e kaltu. Neng e kepe e lim e atis na mani ma neng ka kepe e lim e sangful na mani. ");
INSERT INTO hrw_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","E tek tikas lo ru ek mel e ti mani kia una kos famila e dinau kia. Iya i ka sumiufu e fan dinau ke ru nano. O sang ini se lo ru eu bura tikin e kaltu a?” ");
INSERT INTO hrw_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Saimon ka koso, “Ya sang ini neng gii dinau kia ka bakir ma kaltu a ka sumiufu.” Ma Yesus ka war, “Faikse kiam e riis.” ");
INSERT INTO hrw_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ma kam didiu use fefin a ma ka war singe Saimon, “O sau pari e fefin gii? Biing ya kaulek ulo bala keu fel, o tibi tow e ti dan una gua e ung kekeng. Sakle fefin gii, i e gua e ung kekeng ine darun mata ma kam si ine ololow. ");
INSERT INTO hrw_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","O tibi oseng yau, biing ya kaulek ulo keu fel, safle fefin gii, e tibi manau una osngi e ung kekeng tofnge tinglo pansumbiing ya kaulek. ");
INSERT INTO hrw_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","O tibi tipeni e ti wel ulo paklung, safle fefin gii e tipeni e sanda e nul kausi ulo ung kekeng. ");
INSERT INTO hrw_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ya peteng tikin tifo, singmat na fabur kia lo yau e fanangsi ini Deo e sam sangintafngi e fan mara tubiil kia. Safle se gii fan tubiil kia ka tibi fuun ma Deo ka sangintafngi, fabur kia e su balik.” ");
INSERT INTO hrw_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ma Yesus ka peteng tife fefin a, “Fan tubiil kiam ya sam sangintafngi.” ");
INSERT INTO hrw_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Fanenger fan tongge ri sa la lo tautau wilo en faiya lo biing a, ri tofnge una fawar falifu iri tibom aregii, “Sese kaltu legii, gii ka fasi una sangintafngi e fan tubiil kere tongge?” ");
INSERT INTO hrw_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Yesus ka peteng tife fefin a aregii, “Titinge kiam e sau faliunge o. La tura balamaris.” ");
INSERT INTO hrw_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Wimi ini e fan mok gii, Yesus tura tikii sangful ma e u na disaipel kia ri fes lala ulo fan taon ma fan male, ri ka sesngeni lala e konona sunwar lo kepmale ke Deo. ");
INSERT INTO hrw_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ma fa lo re gelefin ming gii i kabuk feselufu e fan tara saksak tinglo ri ma kabuk faliungeri kosnge fan minse, ri la ming nami. Maria, (ri fotngi ming ini Makdalen, se baba fis na tara saksak ri of suu tinglo), ");
INSERT INTO hrw_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Joana (wok ke Kusa, kaltu bakir kere tongge na mus ke Erot), Susana ma fanenger fang gelefin ming. Gelefin gii ri sagisu ululsi e Yesus tura fan disaipel kia ine fan mok tinglo songsongomfori tibom. ");
INSERT INTO hrw_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Lo sumbiing tongge fuunfuun ri pupuek tinglo fan taon ri ka sa tiim ka ta singmat na galung kaltu unaisa e Yesus, i ka peteng tifri ine sunwar toftof gii, ");
INSERT INTO hrw_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Nenge kaltu una fafaim palang e la sabel ine firfiran au kia. Lo sumbiing e samsabel lala ine firfiran au a, fanenger ri rurung ulo sal, tongge ri ka pii lo ri, ma fan man ting uiyat ri ka sa en tike ri. ");
INSERT INTO hrw_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Fanenger ri rurung ulo poktow e fatfat, ma lo biing ri faf kanek ri main ma ri ka met, anwarow ri tibi kepe e ti dan. ");
INSERT INTO hrw_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Fanenger ri rurung ulo bala finfinau soksok. Ri ka faf kanek tura finfinau soksok a ma finfinau soksok a ka pismet iri. ");
INSERT INTO hrw_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Safle fanenger ri rurung ulo konona nal. Ri faf kanek ma ri ka fira. Tikii amfiran au e fira ine tikii atis na amfiran au.” Biing i e sam ropo e sunwar toftof gii, i ka tau aregii, “Se a ka mel e ambalbalu una ongong, tafu ku ong.” ");
INSERT INTO hrw_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Fan disaipel kia ri ka gatmo use pimpiku e sunwar toftof gii. ");
INSERT INTO hrw_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","I ka koso aregii, “Deo e sam a-uu lo gam una ten use kepmale kia ini are e ngo, safle tifre fa, yau war singri lo warwar toftof usi ini, ‘tikin riu pari, safle riu tibi parfailmi, riu ongni, safle riu tibi ten usi.’ ");
INSERT INTO hrw_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Pimpiku e sunwar toftof a e ngo aregii, firfiran au e ta sunwar ke Deo. ");
INSERT INTO hrw_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Fanenger a ri ka luut ulo sal, ri ta tongge a ri ka ongni e sunwar, ma wimi ini satan ka puek ka kepufu e sunwar a tinglo balbalri usi ini riu tibi titinge ma ri ku tibi ta ilo ninliu. ");
INSERT INTO hrw_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Fanenger a ri ka luut ulo poktow e fatfat, ri ta tongge a ri ka kepe e sunwar tura fefeal biing ri ongni, safle e tek ti awawi ri. Ri su titinge lo boron pansumbiing, safle biing falam e puek, tongge a ri luut singi. ");
INSERT INTO hrw_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Fanenger a ri ka luut ulo falifu lo finfinau soksok, ri ta tongge a ri ka ongni e sunwar, safle biing ri la fes lala, sinang una fabur lo fan mok fuunfuun, una melmel kausi ma sinang una fefeal lo fan mok tinglo nal gii, e pismet ine sunwar a, ma ri ka tibi faf bakir. ");
INSERT INTO hrw_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Safle fanenger a ri ka luut ulo konona nal, ri ta tongge a ri ka ongni e sunwar ma ri ka kepfamti ilo balbalri tura konona sinang ma sinang tikin. Ma ri ti rawas lo sunwar a ka muut ri la fira. ");
INSERT INTO hrw_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“E tek tikas biing i e sau fakrefu tikii e lam, eu finufu ilo pikliu e ti dis tam ku toufu ilo pikliu e ti ngiin. E tam. I eu fakulikngeufu iyat ilo tafu usi ini seri a ri ka kaulek, riu fasi una pari e anten. ");
INSERT INTO hrw_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Anwarow e tek ti mok gii ka fifinuf ini eu tibi suupuek, tam ti pindik ini riu tibi parfat lo ma riu tibi sesuupuek malal ini wilo anten. ");
INSERT INTO hrw_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Iya, gam u ate kausi tikin use sunwar a gam ka ongni. Se a ka mel, Deo eu fen fuunfuun ini. Ma se a ka tibi mel, sese boron mok a i ka sangfi ini i e mel lo, Deo eu kepufu singi.” ");
INSERT INTO hrw_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Kala tinow e Yesus tura tanga tualik ri ka fespuek una sa pari, safle ri tibi fasi una la puek sekit una isa, anwarow lo re tongge fuunfuun. ");
INSERT INTO hrw_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Neng lo re tongge a ka peteng tifi, “Tinam tura tanga tuamlik gii ri ka fafatie gii na male, ri bura ini riu par o.” ");
INSERT INTO hrw_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Yesus ka koso aregii, “Tiduung ma tanga tuaklik e ta seri gii, ri ka ongni e sunwar ke Deo ma ri ka usi.” ");
INSERT INTO hrw_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Nenge biing Yesus ka war singre fan disaipel kia, “Kerek la waleii lo galu lo salat gii.” Iya ri ka la kau ulo bala neng e buut ma ri ka la. ");
INSERT INTO hrw_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Biing ri awes lala ka la, Yesus e luut uf ka masun. Saupe sak morailu ka pu talo ri ulo balan salat a, iya buut ka fuun ine dan, gii ri ka rong una maut. ");
INSERT INTO hrw_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Fan disaipel ri ka la usi ri ka la fongni ma ri ka war, “Kaltu bakir, kaltu bakir, kerer sau bala maut!” I ka matet ka porow e kif ma balan salat uf a ma morailu ka la filau balik ma ka la malmal. ");
INSERT INTO hrw_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ma i ka gatom re fan disaipel kia, “Iya e fan titinge kemi?” Ri ka la kuuf tura soksoke ma ri ka fagatomnge falek iri tibom aregii, “Se le gii, gii ka porow e kif ma balan salat ma ru ka ong singi?” ");
INSERT INTO hrw_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ri ka la ulo nal kere fang Gerasa, e ta ulo galu lo salat Galili. ");
INSERT INTO hrw_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Biing Yesus e fes masa una kiin, i e tongeni e neng e kaltu tinglo taon a tara saksak e sispi. Lo sumbiing e tapak tikin, kaltu a e tibi loslos lo ti kolos ma e tibi melmel ulo ti fel. I e su melmel ulo safle fam balbalang kenit. ");
INSERT INTO hrw_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Biing i e pari e Yesus, i e kaung bakir tikin ma ka luut unaisa e ungkekow e Yesus ma ka tau bakbakir, “Yesus, Sikow e Deo Iyat Sekit, o bala tamu i yau? Ya gatom fangfangte o ini ou tibi bero i yau!” ");
INSERT INTO hrw_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","I e tau aregii, anwarow Yesus e sam tungenufu e tara saksak a tinglo kaltu a. Fam biing fuunfuun tikin tara saksak a, e berbero ini. E tikin riu rekfamti e un limow ma ung kekow ine fan sen ma ri ku efefe rawas lo, safle i eu fuspakti e fan sen ma tara saksak a ku famu ini ku la ilo fan sumbiilkap. ");
INSERT INTO hrw_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesus ka gatmo, “Sese asam?” I ka koso, “Asang gii, Mar ma mar.” Anwarow fan tara saksak fuunfuun ri sam kaulek ilo bala. ");
INSERT INTO hrw_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ma ri ka gatom fangfangteni e Yesus ini eu tibi tule ri, ri ku la wilo bala ampolo e tek ti muut lo. ");
INSERT INTO hrw_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Singmat na amfor na bo ri enen uwa ulo mimbet lo paklunmale, ma fan tangwaner saksak a ri ka gatom fangfangteni e Yesus una a-uu lo ri, ri ku la ilo fam bo a. Ma Yesus ka a-uu lo ri. ");
INSERT INTO hrw_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Biing fan tara saksak a ri suu tinglo kaltu a, ri la sispi re fam bo a ma ri ka fafes pu ulo pimpa-i a ri ka la ulo bala dan ri ka la maut. ");
INSERT INTO hrw_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Biing fan efefe kere fam bo ri pari e mok a, ri filau ri ka la seseng tifre tongge ulo taon ma ulo fang galgalu una male ine taon. ");
INSERT INTO hrw_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ma tongge ri ka sa la una sa par lo sa e sau fuut. Biing ri sa fespuek talo Yesus, ri pari e kaltu lewa fan tara saksak ri kabuk suu tinglo, i e kiiskiis ulo fow e ungkekow e Yesus. I e sau pilpiliis ma kabuk la sinangu mel mil, ri sokeni tikin. ");
INSERT INTO hrw_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Fa ri sau pari sekit e sa e fuut, ri seseng tifre tongge a ini are kaltu lewa tara saksak ka sispi e liu. ");
INSERT INTO hrw_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ma tongge nano tinglo rijen Gerasa ri ka gatmo e Yesus ini i eu la kosing ri, anwarow ansoke e sam wile ri. Iya Yesus ka kau ulo buut ma ka la kosing ri. ");
INSERT INTO hrw_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ma kaltu lewa fan tara saksak ri ka suu tinglo e guna e Yesus ini i eu la tura, safle Yesus e onu ka la ma ka war singi aregii, ");
INSERT INTO hrw_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“La mil ilo keu male ma o ku la seseng ine mara mok Deo e sam gow lo o.” Iya kaltu a ka la kosing ri ka la seseng ulo taon kiruur ine mara mok Yesus e sam gow lo. ");
INSERT INTO hrw_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Biing Yesus e kaupaket mil, singmat na galung kaltu ri areni, le ri nano ri nene-i. ");
INSERT INTO hrw_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Kala neng e kaltu bakir tinglo felun nining, asow gii Jairus, ka sa la ka sa luut ulo fow e ungkekow e Yesus ma ka sa gatom fangfangteni ini eu la ilo ke fel, ");
INSERT INTO hrw_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","anwarow e buk su tikii e boron sikow fefin, e ta tikii sangful ma e u na matamfaim kia, e rong una met. Biing Yesus e fes lala ka la, singmat na galung kaltu ri sita lala. ");
INSERT INTO hrw_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ma e mel e neng e fefin uwa, ambuunbuunsuu e fuut lo, lo tikii sangful ma e u na matamfaim, safle e tek tikas ek fasi una faliungeni. ");
INSERT INTO hrw_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","I e fes ting nami e Yesus ka sa pot lo anisow e kolos tapak kia, ma saupesak ambuunbuunsuu ulo ka rop. ");
INSERT INTO hrw_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yesus ka gatom aregii, “Se e sa pot lo yau?” Biing tongge nano ri tiin peteng ini “E tibi ta yau,” Pita ka war, “Kaltu bakir, tongge gii ri ka fa sit ina is o, ri fuun tikin.” ");
INSERT INTO hrw_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Safle Yesus e war, “Ya parfat ini neng e kaltu e sa pot lo yau, anwarow ya ongen failmi ini galu lo fan rawas, e sam la kosing yau.” ");
INSERT INTO hrw_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Biing fefin a e pari ini mok i e gow e tibi fifinuf, i e banban lala ka sala, ka sa luut ulo fow e ungkekow e Yesus. Na matre tongge nano, i e peteng suupuek ini sese anwarow gii i ka sa pot lo Yesus ma are i e gorot ka liu sekit lo pansumbiing a. ");
INSERT INTO hrw_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Kala Yesus ka war singe fefin a, “Kek fefin, titinge kiam e sau faliunge o, la tura balamaris.” ");
INSERT INTO hrw_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Biing Yesus e gongon uwa, neng e kaltu ka sa la tinglo fel ke Jairus, kaltu bakir lo felun nining, ka sa war aregii, “Keu fefin e sau met, mele au finiilu e titsa.” ");
INSERT INTO hrw_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Biing Yesus e ongni e war aiya, i ka war singe Jairus, “Ou tibi soke, ou su titinge ma keu fefin ku liu mil.” ");
INSERT INTO hrw_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Biing Yesus e la fespuek ulo fel ke Jairus, i e tibi a-uu lo tikas ming una la kaulek tura. I e su a-uu lo safle Pita, Jon ma Jeims tiim tura tamow ma tinow e fefin a. ");
INSERT INTO hrw_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Lo sumbiing a, tongge nano ri fafatengse bakir ma ri ka sangkuuluung tikin usi. Safle Yesus e war singri, “Manau una teng, fefin gii e tibi met. I e su masun.” ");
INSERT INTO hrw_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ma tongge a ri ka su ruur lo, anwarow ri parfat ini fefin a e sau met. ");
INSERT INTO hrw_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Safle Yesus e puse ulo limow e borom fefin a ma ka war, “Sikuang, matet!” ");
INSERT INTO hrw_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Tangow e kaulek mil ulo ma saupe sak ka matet ka ti. Wimi Yesus ka uun ri ini riu tow e ti tuan tifi ku en. ");
INSERT INTO hrw_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Tamow ma tinow ru la kuufsak tikin, safle Yesus e fanau ru ini ruw tibi la seseng tife tikas ine sa e sau fuut. ");
INSERT INTO hrw_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Biing Yesus e sam tau tiim ine tikii sangful ma e u na Disaipel kia, i e tow e rawas ma mia ri una feselufu e fan mara matmatan tangwaner saksak ma una faliungere tongge kosnge fan minse, ");
INSERT INTO hrw_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","ma ka tule ri ka la una la sesngeni e sunwar lo kepmale ke Deo ma una la faliungere tongge ri mase, ");
INSERT INTO hrw_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","i ka peteng tifri, “Biing gam u la, gam u tibi kepe e tikas ti mok ming tura gam lo fines kemi. Eu tek ti tungkan, eu tek ti tang, eu tek ti tuan, eu tek ti tubam, tam ti kolos tapak ming. ");
INSERT INTO hrw_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Sese fel gam u kaulek ilo, gam u su melmel wa ku muut gam u la kosnge taon a. ");
INSERT INTO hrw_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ma le tongge ri ku tibi are gam, paketufu e ambalbal tinglo kekekmi biing gam u la kosngi e taon a are peteng fate tifri ini ri guuluung ine sunwar ke Deo.” ");
INSERT INTO hrw_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Iya ri ka la ri ka la fes lala tinglo neng e male wilo neng e male, ri ka la sesngeni lala e konona sunwar ma ri ka la faliungeri lala e tongge ulo mara male. ");
INSERT INTO hrw_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Biing Erot kaltu bakir lo Gapman e ong lo fan mok e fuut, i e kuufsak tikin, anwarow, fa ri peteng ini Jon kaltu na gugu tarawen e sau matet mil kosnge minet. ");
INSERT INTO hrw_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Fa ri ka peteng ini Elaija e sau mil ma safle fa ri peteng ini neng lo re fam profet ting nangen e sam liu mil. ");
INSERT INTO hrw_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Safle Erot e war, “Ya sam tese pakti e angkiimkiim a Jon. Ma se sekit legii ya ka su ong lo fan warwar lo ming gii?” Ma i ka tofo una sik ine ti sal una tongeni. ");
INSERT INTO hrw_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Biing fan Apostel ri mil, ri sa peteng tife Yesus ine fan sa ri sam la gow. I ka uun ri, ri ka mi nami una tibom la ulo taon ri fotngi ini Betsaida. ");
INSERT INTO hrw_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Safle biing tongge fuunfuun ri ong lo ri, ri ka mi nami. I e su are ri ma ka sesngeni e sunwar lo kepmale ke Deo tifri, ma ka faliungere fa gii ri ka mase. ");
INSERT INTO hrw_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Lo efef sekit, tikii sangful ma e u na disaipel ri ka sa la use Yesus, ri ka sa war singi, “Tule re tongge gii ri ku la, usi ini riu la ilo ton taon fatat ri ku la sik ine ton tuan ari una en ma tom fel una ngo singri, anwarow kiar ta ilo biilkap.” ");
INSERT INTO hrw_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Yesus ka war singri aregii, “Gam tibom gam u tow e ton tuan una en singri.” Ri ka koso, “Sakle kemem su mel e lim e sum beret ma e su u e fis, le ku ta aiya, kemem u la fiil ti ton tuan are tongge nano gii?” ");
INSERT INTO hrw_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Lo biing a e ngo are e lim e mar na tamat ri ta wa. Safle Yesus e peteng tifre fan disaipel kia aregii, “Uun ri, ri ku fakiisnge tiim lala, ma eu lim e sangful na kaltu riu keptiim iri.” ");
INSERT INTO hrw_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Fan disaipel ri ka gow aregii i ka peteng iya tongge nano ri ka fakiisnge lala ufaf. ");
INSERT INTO hrw_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","I ka kepe e lim e beret a ma um fis a, ka par wiyat wilo balambat, ka katfarsi e Deo lo ma kam kere e lim e beret ma um fis a ma ka tow tifre fan disaipel kia una fasa ini lo re tongge. ");
INSERT INTO hrw_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Tongge nano ri tiin en ri ka la sut ma fan disaipel ri ka sele tiim ine fan susun tuan e ngosok ri ka siing tiim ini ka puek ka la ta tikii sangful ma e u na dik. ");
INSERT INTO hrw_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Neng e biing Yesus e la nining borong ma fan disaipel kia ri ta tura. I ka gatom ri aregii, “Tongge ri peteng ini yau gii se?” ");
INSERT INTO hrw_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ri ka koso, “Fa ri peteng ini o gii Jon kaltu na gugu tarawen, ma fa ri ka peteng ini o Elaija, ma fa ri ka peteng ini o ta neng lo re fam profet ting nangen tikin se e sam liu mil.” ");
INSERT INTO hrw_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ma Yesus ka gatom ri aregii, “Ma gam tibom, gau peteng ini yau se?” Pita ka koso, “O na Mesaiya ke Deo.” ");
INSERT INTO hrw_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yesus ka fanauri ini riu tibi peteng tife tikas. ");
INSERT INTO hrw_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ma i ka war, “Sikow e Kaltu e samusu kepe e fan ongker. Ge lamlam, fam pris lamlam ma fan titsa lo fam fafanau riu gilmeufu ma ri ku pakti ku met. Ma lo biing baba e tuul, Deo eu famtet famila tinglo minet.” ");
INSERT INTO hrw_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Kala Yesus ka war singri nano, “Le tikas ku fabur una mi nami yau, i e samusu faporo e fabur kia tibom ma ku kepe e aupaket kia lo an mara biing ma ku usi yau. ");
INSERT INTO hrw_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Anwarow le sese ti kaltu a ka sangsang una bingfamti e ninliu kia tibom, ninliu kia eu tam ini. Safle se a ku fafen ine ninliu kia usi yau, i eu kep famila e ninliu kia. ");
INSERT INTO hrw_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Le kaltu ku kepe e mara mok nano gii lo nal, safle ninliu kia tibom ku tam ini, sese kausi lo fan mok a? ");
INSERT INTO hrw_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Le tikas ku maiyai lo yau ma kek sunwar, Sikow e Kaltu eu maiyai lo ming, lo biing i eu puek tura finaswen kia ma tura finaswen ke Tamow ma tura finaswen kere fan anggelo riis kia. ");
INSERT INTO hrw_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ya peteng tikin tif gam, fa lo re tongge gii ri ka titi gii, riu tifik met ku muut riu pari e kepmale ke Deo.” ");
INSERT INTO hrw_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","E ngo are e wal e biing wimi ine Yesus e sam sesngeni e fan mok gii, i e onu e Pita, Jon ma Jeims ri ka la kanek tura ulo paklunmale una la nining. ");
INSERT INTO hrw_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Biing i e ninining, mata e puek ka la ngo kuriik ma kolos kia ka la ten tikin are ansinsokow e ampil. ");
INSERT INTO hrw_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","E u e kaltu, Moses ma Elaija, ");
INSERT INTO hrw_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","ru puek ulo bala konona finaswen ru ka sa warwar singe Yesus. Ri tuul ka fafawar ine ninla kia tinglo nal, iya i kabuk fatat una faropo ina Jerusalem. ");
INSERT INTO hrw_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pita tura un taltalu ri masun taut, safle biing ri kuuf, ri pari e finaswen kia tura e u e kaltu ru titi unaisa. ");
INSERT INTO hrw_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Biing ung kaltu a ru rong una la kosnge Yesus, Pita e war singe Yesus aregii, “Kaltu bakir, e kausi ini kiar u melmel wagii. Kemem tuul u feti e tuul e ti kak, neng kiam, neng ke Moses ma neng ke Elaija.” (Pita e tibi parfat lo sa i e petpeteng ini.) ");
INSERT INTO hrw_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Lo sumbiing i e gongon, neng e pambalbal e puek ka afit ri. Ma biing ri kau ulo bala pambalbal a, tuul disaipel a, ri tuul soke tikin. ");
INSERT INTO hrw_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ma neng e angkiimkiim e la tinglo bala pambalbal a, e war aregii, “I gii e Sikuang se ya sam wele. Gam u ongong singi.” ");
INSERT INTO hrw_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Biing angkiimkiim a e sam war tikii, ri tuul pari ini Yesus tibom e la ti sok. Fan disaipel ri bingfamti e sinseng lo sa ri pari, ka ta keri tibom. Ri tibi peteng tife tikas lo fan sumbiing a ini. ");
INSERT INTO hrw_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Tikii biing wimi ini ri sam ding tinglo paklunmale, tongge fuunfuun tikin ri sa tupngeni e Yesus. ");
INSERT INTO hrw_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Neng e kaltu una balre tongge a ka tau aregii, “Titsa, ya bura tikin ini ou par lo sikuang, le e su tikiin i na sikuang. ");
INSERT INTO hrw_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Neng e tara saksak e sispi ka kuufkuufsak ka kaukaung. I e sagisu basbas ini ka la metmetor ma bus ka la suusuu tinglo ngusu. E tek ti borom biing sekit ek lala kosngi ma e su berbero sekit ini. ");
INSERT INTO hrw_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ya gatom re fan disaipel kiam ini riu fesel suu ini, safle ri tibi fasi.” ");
INSERT INTO hrw_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ma Yesus ka koso aregii, “Gam na kulu na tibi titinge, sinsinangumi ma ninis kemi e tibi kausi, e sak sekit. E fis e biing yau melmel tura gam? Ma e fis e biing ming yau kepe mafet tura gam? Kepe e sikuam wagii.” ");
INSERT INTO hrw_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Lo biing boroner a e sa la, tara saksak a e baspu ini talo nal ka la banban. Safle Yesus e porow e tara saksak a, ma ka faliungeni e boroner a ma ka tow mil tife tamow. ");
INSERT INTO hrw_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ma tongge nano a ri ka la kuufsak lo singmat na rawas ke Deo. Biing tongge nano ri fafamunge faliu use sa Yesus e gow, i e war singe fan disaipel kia, ");
INSERT INTO hrw_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Ong kausi tikin use sa ya rong una peteng tif gam ini. Sikow e Kaltu riu solamufu ku la ilo limre tongge.” ");
INSERT INTO hrw_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Safle ri tibi ten use bala e sunwar a. Pimpiku e fifinuf iri, iya, ri ka tibi ten usi ma ri ka soke una gatmo usi. ");
INSERT INTO hrw_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Fatinge e tofnge falifu ire fan disaipel ini se lo ri eu bakir iyat iri. ");
INSERT INTO hrw_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yesus e sau parfat lo sangsang keri, iya ka onu e neng e boroner ka sa fetiufu ulo anggalu lo, ");
INSERT INTO hrw_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ma i ka war singri, “Se a ka areni e boroner gii lo asang, i e are yau. Ma se a ka are yau, i e areni ming e se gii ka tule yau. Anwarow se gii ka tek ti asow i falifu i gam nano, i e bakir iyat ire fa.” ");
INSERT INTO hrw_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Kala Jon ka war, “Kaltu bakir, kemeu pari e neng e kaltu e fesi e tara saksak lo asam, ma kemem ka tofo una war kali, anwarow i e tibi ta lo kiar.” ");
INSERT INTO hrw_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yesus ka war singri, “Mele war kali, anwarow sese kaltu a ka tibi fasange sing gam, i e ta lo gam.” ");
INSERT INTO hrw_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Lo biing e sau fatat ma Deo ku kep kanek ini wilo balambat, Yesus e farawasngeni e sangsang kia una la wina Jerusalem. ");
INSERT INTO hrw_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ma i ka tuleni famu e fam finauun, ri ka la ulo neng e palkanmale una Samaria una la terngeni e fan mok nene i. ");
INSERT INTO hrw_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Safle tongge ulo male a ri tibi a-uu lo ini eu bi melmel tura ri, anwarow i e lala wina Jerusalem. ");
INSERT INTO hrw_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Biing un disaipel, Jeims ma Jon ru pari e mok e fuut, ru ka gatom, “Taufi, o bura ini kamau tau ding ine iif tinglo balambat ku bero iri?” ");
INSERT INTO hrw_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Safle Yesus e didiu mil ka porau ru, ");
INSERT INTO hrw_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","ma ri ka la wilo neng e palkanmale. ");
INSERT INTO hrw_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ma lo biing ri fesfes lala ulo sal, neng e kaltu ka war singi, “Sese mok ou la ilo, yau mi nami o ming wilo.” ");
INSERT INTO hrw_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ma Yesus ka peteng tifi aregii, “Fam puul rokai e mel e fam polo keri ma fan man ting auiyat e mel e fam polpolo ri. Safle Sikow e Kaltu e tek ti mok una famanaungeni e paklu.” ");
INSERT INTO hrw_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ma i ka war ming singe neng e kaltu aregii, “Mi nami yau.” Safle kaltu a e koso aregii, “Taufi, ou bi a-uu lo yau, ya ku la ofo e tabung.” ");
INSERT INTO hrw_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ma Yesus ka war singi, “Tauf re fan minet ri ku ofo e minet keri tibom, safle o, ou la o ku la sesngeni e sunwar lo kepmale ke Deo.” ");
INSERT INTO hrw_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ming neng e war, “Yau usi o Taufi, safle famu ou bi tauf yau, ya ku la tulere kek fumberat.” ");
INSERT INTO hrw_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yesus ka koso, “Kaltu a kabuk soleni e limow ilo bala ampolo una awe ma kabi par mil wimi, matang kaltu aiya, e tibi fasi una faim ilo bala kepmale ke Deo.” ");
INSERT INTO hrw_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Wimi Taufi ka sikii e baba fis na sangful ma e u na kaltu ming ma ka tule ri, e u u lala, ri ka la famu ini ulo mara taon ma mara male gii i ka rong una la wilo. ");
INSERT INTO hrw_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","I e war singri aregii, “Fan tuan una fitiil e fuun, safle tongge una faim ri tibi fuun. Gam u nining singe Tamow e palang, usi ini i eu tule re tongge na faim wilo bala palang una fitiil. ");
INSERT INTO hrw_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","La! Ya tule gam are fan iririn sipsip ku la ina balre fam puul rokai. ");
INSERT INTO hrw_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Mele kepe e ti paos, tam ti tang, tam ti sendel; ma mele faiya tanganga tura ti kaltu ilo sal. ");
INSERT INTO hrw_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Biing gam u kau ilo bala tom fel, baba tikii sekit gam u war aregii, ‘Siaro sing gam na tongge tinglo bala fel a’. ");
INSERT INTO hrw_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Le ku mel e ti kaltu e fuunuf ine balamaris ilo fel a, siaro kemi eu ta ilo. Ma le ku tam, siaro kemi eu mil usi gam. ");
INSERT INTO hrw_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Melmel ilo fel a, eni ma inmi e fan sa ri tow tif gam, le kaltu na mus e samusu kepe e fimfiil kia. Mele fes faliu tinglo neng e fel ku la ilo neng e fel. ");
INSERT INTO hrw_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Biing gam u kau ilo bala ton taon, ma ri ka are gam, eni e fan sa ri fen gam ini. ");
INSERT INTO hrw_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Faliungeni e fan mara minse ilo male a ma peteng tifri aregii, ‘Kepmale ke Deo e sau fatat inais gam.’ ");
INSERT INTO hrw_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Safle biing gam kaulek ilo bala ton taon ma ri ka tibi are gam, la ilo fan susun sal ilo taon a ma gam ku war aregii, ");
INSERT INTO hrw_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Fam balbal tibom tinglo bala taon kemi gii ka ngosok ilo pikliu e kekekmem, kemeu paketufu are tintof una fanangsi ini gam gow e sinang e sak lo kemem. Safle, gam u sangsangfi ini: Kepmale ke Deo e sau fatat.’ ");
INSERT INTO hrw_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ya peteng tif gam, lo biing a mafet eu kep re tongge tinglo taon a, eu bakir iyat ine mafet lewa ka kep re tongge tinglo taon Sodom. ");
INSERT INTO hrw_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Kiskam sing gam na fang Korasin. Ma kiskam sing gam na fam Betsaida. Anwarow, le tikas enggi sam la ulo taon Tair ma Saidon ek la gow e fan mok na tibou fuut aregii ya ka gow falifu i gam, fan Tair ma Saidon ring gi sam iksi e balbalri, ma rik sam los lo fang kolos na sangkuuluung ma rik sam wili e fofori ine fam pi-iif una fanangsi ini ri sangkuuluung tikin nafow e fan tubiil ri sam gow. ");
INSERT INTO hrw_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Sakle lo biing na anganggon, mafet eu kep gam eu kulfi tikin e mafet eu kep re fan Tair ma fan Saidon. ");
INSERT INTO hrw_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ma gam na fang Kapenaum, gam sang ini riu akte gam wiyat sekit ku la ilo batsok? E tam! Gam u pu sekit ku la sekit ilo male kere fan minet. ");
INSERT INTO hrw_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","“Se a ka ongne sing gam, i e ongne sing yau. Se a ka guuluung i gam, i e guuluung i yau. Safle se a ka guuluung i yau, i e guuluung ine se gii ka tule yau.” ");
INSERT INTO hrw_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Baba fis na sangful ma e u na kaltu a, ri mil tura fefeal ma ri ka sa war, “Taufi, fan tara saksak ming ri ong sing kemem biing kemem tungen ri lo asam.” ");
INSERT INTO hrw_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ma Yesus ka koso singri aregii, “Ya pari e Satan e luut tinglo balambat are ampil. ");
INSERT INTO hrw_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ya sam tow e rawas tif gam una pii lala lo re fan sii ma fam bowangwang ma una kulfi e rawas ke kaltu na matamfais, ma eu tek ti sak eu kep gam. ");
INSERT INTO hrw_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Safle gam u mana fefeal ini fan tara saksak ri ong sing gam, safle gam u fefeal ini asasmi Deo e sam siitufu ilo balambat.” ");
INSERT INTO hrw_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Lo biing a, Yesus e fuunuf ine fefeal singe Tangwa Riis ma ka war aregii, “Tabuung, Taufi lo balambat ma nal. Ya katfariis o, anwarow o sau finufu e fan mok gii ire tongge atausimale ma tongge parfat, ma o ka sesuupuek ini tifre tongge ri melmel are berberat. Yow Tabuung, o gorot aiya, anwarow e ta konona fabur kiam. ");
INSERT INTO hrw_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Tabuung e sam tow e mara mok nano ilo limang! Ma e tek tikas ek parfat lo Sikow e Kaltu ini i se. Sakle Tamow tibom ma e tek tikas ek parfat lo Tamow ini i se. Sakle Sikow tibom tiim tura re tongge gii Sikow kabuk wel ri ini, i eu fanangsi ri ine Tamow.” ");
INSERT INTO hrw_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Wimi i e didiu use re fan disaipel kia ma ka war borong singri aregii, “Fefeal seri gii ri ka pari e sa gau pari. ");
INSERT INTO hrw_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Le ya peteng tikin tif gam, nangen fam profet ma fang king fuunfuun ri bura tikin ini riu pari e fan mok gii gam ka pari gii, sakle ri tibi pari, ma ri bura tikin ini riu ongni e fan mok gii gam kabuk ongni, sakle ri tibi ongni.” ");
INSERT INTO hrw_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Lo neng e biing, neng e kaltu parfat lo fafanau e matet ka ti una tofo e Yesus, i ka gatmo, “Titsa, sa ya samusu gow, usi ini yau kepe e ninliu bingne?” ");
INSERT INTO hrw_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","I ka koso aregii, “Fafanau ke Moses are e peteng? Biing o wese, are o sang?” ");
INSERT INTO hrw_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","I ka koso, “‘Bura e Taufi Deo kiam ine ambusbusam kiruur, tura tangwam kiruur, tiim tura rawas kiam, ma tura sinangum kiruur’; ma ‘Bura e fan taltalum aregii o ka burow tibom.’” ");
INSERT INTO hrw_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesus ka war, “O sam kos fakausi. Gow e sinang a, aregii o kabuk peteng ini, usi ou liu.” ");
INSERT INTO hrw_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Safle i e bala fakale lo i tibom, aregii i ka gatmo e Yesus, “Ma se gii i na taltalung?” ");
INSERT INTO hrw_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesus ka koso mil singi aregii, “Nenge kaltu e ding tingna Jerusalem wina Jeriko. Ma tongge na kinkinau ri ka bingfamti, ri ka rangsi e fang kolos kia ma ri ka pakti ka la metor ma ri kam la kosngi. ");
INSERT INTO hrw_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Nenge pris e fes ulo tikii sal ma biing i e pari e kaltu a, i e su sol sekit ulo galu. ");
INSERT INTO hrw_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Nenge Liwai ming e sa puek ulo male a, ma biing i e pari e kaltu a, i e su sol sekit ming ulo neng e galu. ");
INSERT INTO hrw_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Safle neng e kaltu tingna Samaria e fes ulo tikii sal mung a, i e sa puek ulo mok gii kaltu a ka ta ulo, ma biing i e pari, i e la tengsi tikin. ");
INSERT INTO hrw_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","I e la usi ka la toto e wel ma waen ulo fam piiu kia ma kam deti ine banis. Wimi i kam kepe e kaltu a, ka tafu ulo dongki kia ma ka kepe wilo neng e felum pasindia ka bom la efe lo. ");
INSERT INTO hrw_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Biing usi, i e kepufu e u e silwa mani ka tow tife kaltu gii ka efefe lo felum pasindia a, ma ka war singi, ‘Efefe lo kaltu gii, ma biing yau mil, yau piliis famila e fis e galun mani kiam o ulsi e kaltu gii ini.’ ");
INSERT INTO hrw_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","“Se lo re tuul kaltu gii, o sangfi ini i e na taltalu e kaltu lewa tongge na kinkinau ri ka pakti?” ");
INSERT INTO hrw_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Kaltu parfat lo fafanau e koso aregii, “Kaltu lewa ka tengsi ma ka ulsi.” Yesus ka war singi, “La, o ku la gow aregii o kabuk peteng.” ");
INSERT INTO hrw_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Biing Yesus tura fan disaipel kia ri ta ulo fines keri, i e la fespuek ulo neng e palkanmale. Palkanmale a, e mel e neng e fefin gii asow Marta, i ka onu e Yesus, ka la kau ulo ke fel. ");
INSERT INTO hrw_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta e mel e kisilik ming, asow gii Maria. I e kiisuf fatatu e ung kekow e Taufi, ma ka ongongne use fan warwar kia. ");
INSERT INTO hrw_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Safle Marta e su sangsang use fan sa i e samusu gow. I ka fespuek use Yesus ka sa war, “Taufi, o tibi pari ini kisiklik e su tafu e mara faim tif yau tibom? Onu ku sa ules yau!” ");
INSERT INTO hrw_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Taufi ka koso, “Marta, Marta, o su sang kut ma o ka sangfuunfuun use mara mok, ");
INSERT INTO hrw_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","safle tikii mok gii o pospos lo. Maria e sam sikseni e sa e kausi, ma eu tek tikas eu fasi una kepufu singi.” ");
INSERT INTO hrw_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Nenge biing Yesus e nining ulo neng e male. Biing i e rorop, tikii neng lo re fan disaipel kia ka war singi, “Taufi, fabenge sing kemem una nining aregii Jon ka fabenge singre fan disaipel kia.” ");
INSERT INTO hrw_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","I ka war singri aregii, “Biing gam nining, gam u war aregii, ‘Taumem, Tafu e asam ku ta tarawen. Tafu e kepmale kiam ku puek. ");
INSERT INTO hrw_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Fen kemem lo tikii neng tikii neng e biing ine inen amem. ");
INSERT INTO hrw_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Sangintafngi e fan tubiil kemem, are kemeu ming kemem sangintafngi e fan tubiil, fa ri gow lo kemem. Mele tule kemem tife falam.’” ");
INSERT INTO hrw_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ma i ka war ming singri, “Le tikii tikas lo gam ku mel e ti fenngow, ma i ku la usi lo panambiing bakir ku la war singi, ‘Fenngong, ules yau ine e tuul e ti sum beret, ");
INSERT INTO hrw_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","anwarow neng e fenngong e fes lala lo an mara male ma ka sa puek talo yau, ma e tek ti mok ini yau feni ini.’ ");
INSERT INTO hrw_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“Kala kaltu ina fel ku koso, ‘Mele fiiniil yau. Matangkon e sam dukel, ma yau tura berberat kiang, kemem sau masun. Ya tibi fasi una matet ya ku la tow e ti mok tifo.’ ");
INSERT INTO hrw_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ya peteng tifo, kaltu una fel e matet ka la tow e beret tifi, e tibi ta ini anwarow i e ta fenngow, iya ini i ku matet ku la tow e beret tifi, safle anwarow kaltu a ka titi una male e tibi soke, i e su ngos lo faran. ");
INSERT INTO hrw_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Ilea, ya peteng tif gam, gam u gatom, usi Deo eu tow e mok gam gatom usi; gam u sik ine mok, ma gam ku pari; gam u tukeni e matangkon, ma Deo ku ipki tif gam. ");
INSERT INTO hrw_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Tongge nano ri gatmo e Deo, riu kepe e mok ri gatom usi; kaltu e sik ine mok, i eu pari; ma kaltu e tukeni e matangkon, Deo eu ipki tifi. ");
INSERT INTO hrw_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Se lo gam na fan tamtamaboi-i, le sikuam ku gatom use ti fis, ma o ku su tow e ti sii tifi? ");
INSERT INTO hrw_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Tam le i ku gatom use ti angkatuul ma o ku su tow e ti bowangwang tifi? ");
INSERT INTO hrw_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Gam na tongge saksak, sakle gau parfat tikin una tow e konona fan mok tifre siksikwami. Safle konona sinangu e Deo e kulef gam tikin. Iya, Taumi ilo balambat eu fefeal tikin una tow e Tangwa Riis tifre seri a ri ka gatom usi singi!” ");
INSERT INTO hrw_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Yesus e feselufu e tara saksak tinglo neng e kaltu gii ka gow e ngusu ka kut. Biing tara saksak a e la, kaltu a e gon, ma tongge fuunfuun ri ka la kuufsak. ");
INSERT INTO hrw_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Sakle fa lo ri, ri war, “I e fesfeseluf re fan tara saksak lo rawas ke Belsebul, paklure fan tara saksak.” ");
INSERT INTO hrw_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Fa lo ri, ri ka tofo e Yesus, ri ka gatmo ini i eu bilseni e ti tintof tinglo balambat una fanangsi ini Deo e tuleni. ");
INSERT INTO hrw_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Safle Yesus e sau parfat lo sangsang keri ma ka war singri, “Le tongge tinglo tikii kaontri ku tapot lo ri, ma ri ku fapaket, kaontri a e tibi fasi una ti raw. Ma le ti fumberat tinglo bala tikii fel ku tapot ku u lo ri, fumberat a riu kiis saksak. ");
INSERT INTO hrw_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Le tongge ke Satan ku tapot ku u lo ri, aregii, kepmale kia ku ti raw? Ya war aregii, anwarow gau peteng ini ya feselufu e fan tara saksak lo rawas ke Belsebul. ");
INSERT INTO hrw_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ma le gam ku peteng ini ya feselufre fan tara saksak lo rawas ke Belsebul, ma anwarow lo sa gii gam ka peteng ini tongge kemi, ri feseluf ri lo rawas ke Deo? Ilea, tongge kemi, ri fanangsi ini faikse kemi e tubiil. ");
INSERT INTO hrw_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ma le ya ku feselufre fan tara saksak tikin lo rawas ke Deo, e fanangsi ini kepmale ke Deo e sau puek talo gam. ");
INSERT INTO hrw_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Le ti kaltu rawas ku mel lo mara mok na fapaket ma ka efe lo ke fel, mara tuba eu ngongo kausi. ");
INSERT INTO hrw_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Safle le tikas ti kaltu kuriik gii ka rawas tikin iyat ine kaltu a ku puek ku fapaket tura, kaltu kuriik a eu kulfi ma ku tii ine fan mok na fafapaket a kaltu a ka tinge lo ma ku faseni e mara tuba. ");
INSERT INTO hrw_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Le kaltu ka tibi ta tura yau, i e is yau. Ma kaltu a ka tibi ules yau una keptiim ire tongge, i e ta kaltu e fesel falek ire tongge. ");
INSERT INTO hrw_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Le ti tara saksak ku suu tinglo ti kaltu, eu fes fawet ilo mara male mas ku siksik lala ine ti male una manau singi. Ma le ku tibi tongeni, tara saksak a eu sang aregii, ‘Yau la mil ilo fel ya la tinglo.’ ");
INSERT INTO hrw_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Biing e la puek i e pari ini fel a i ka la kosngi e ngo are fel ri sam saif fakausi ma ri kabuk fagati fakausi e fan mara mok ilo bala. ");
INSERT INTO hrw_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Tara saksak a e la ka la onu e neng e baba fis na tara saksak ming, ri sak sekit iyat ini tibom, ma ri ka la melmel wa. Ma melmel ke kaltu a, ka la sak sekit iyat ine melmel kia ting famu.” ");
INSERT INTO hrw_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Lo biing Yesus e gongon ine fan mok gii, neng e fefin una balre tongge a ka tau, “Deo e sam warfakausi e fefin gii ka fasus i o ma ka fasfasus o!” ");
INSERT INTO hrw_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Yesus ka koso, “Deo e sam warfakausi re tongge a, ri kabuk ongni e sunwar kia ma ri ka usi.” ");
INSERT INTO hrw_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Biing galung kaltu a ri sam la fuun tikin, Yesus ka war, “Kulu gii, ri ta tongge na tumtubiil. Ri gatom use ti tintof, safle riu tibi par ti tintof. Riu su pari e tintof lo Jona. ");
INSERT INTO hrw_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Are Jona e sam ta tintof tifre fan Niniwe, e su ngo ming aregii Sikow e Kaltu eu ta tintof tifre kulu lo biing gii. ");
INSERT INTO hrw_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Kwin ting i suu eu ti ilo anganggon tura re tongge tinglo kulu ting geinggii, ma ku sesuupuek ine fan sinang saksak keri, anwarow Kwin gii e puek tinglo pitpitow e nal gii una sa ongne use konona sangsang ke Solomon. Ma gii, neng e bakir iyat ine Solomon e sam ta i gii, safle kulu ting geinggii ri tibi bur ongne singi. ");
INSERT INTO hrw_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Tongge tingna Niniwe riu ti ilo anganggon tura re kulu ting geinggii, ma ri ku sesuupuek ine fan sinang saksak keri, anwarow fan Niniwe ri sam sangikis singe fam fabenge ke Jona. Ma gii, neng e bakir iyat ine Jona e sam ta i gii, safle kulu ting geinggii ri tibi sangikis. ");
INSERT INTO hrw_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“E tek tikas eu fakrefu e ti lam ma ku tafu ilo ti mok e ngo borong tam ilo pikliu e ti dis. E tam, i eu towfu iyat ilo tafu, usi ini seri a ri ka kaulek, riu pari e anten. ");
INSERT INTO hrw_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Wan matam e ta lam tinglo fom kiruur. Le wan matam ku kausi, fom kiruur eu fuun ine anten. Safle le ru ku sak, fom kiruur ming eu fuun ine anor. ");
INSERT INTO hrw_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ate are anten ilo balam ka or. ");
INSERT INTO hrw_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ilea, le fom kiruur ku fuun ine anten ma ku tek ti galu ek or, fom eu fasef sekit ine anten, e su ngo aregii ansinsokow e lam ka pal o.” ");
INSERT INTO hrw_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Biing Yesus e warwar tikii, neng e Farasi e gatmo ini i eu la en tura, iya i ka kaulek ka la kiis ulo fow e teibel na enen. ");
INSERT INTO hrw_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Sakle Farasi a e la sangfuunfuun biing e pari ini Yesus e tibi gua famu e un limow ma kamu en. ");
INSERT INTO hrw_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Iya Yesus kau peteng tifi, “Gii, e tikin, gam na fam Farasi gam gugua e pokpoktow e fang kap ma fan dis, sakle ilo balbalmi e fuun ine sinang na koko ma fan sinang saksak. ");
INSERT INTO hrw_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Gam na fan talos! E tamu, gam tibi parfat ini kaltu e bilseni e poktow, e bilseni ming e bala? ");
INSERT INTO hrw_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Sakle tow e sa a ka ta ilo bala dis tifre fan sasngal, ma mara mok kemi ku kalkaliis. ");
INSERT INTO hrw_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Kiskam sing gam na fam Farasi, anwarow fan mok liklik tinglo bala fam palang kemi, are la-i, fan suu, ma fanenger fan iririn mok ming una gowgow e fan tuan ku nul kausi, kemi faseni lo tikii sangful na galu ma gam, kam tow e tikii galu tife Deo. Sakle gam tibi usi e sinang e riis ma sinang una bura e Deo. E kausi tikin ini gam gi usi e sinang una tow e fam finafen tife Deo, ma gam ku tibi sangintafngi ming una usi e konona sinang. ");
INSERT INTO hrw_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Kiskam sing gam na fam Farasi, anwarow gau burbura tikin e fan sia kere ge lamlam ilo bala fam felun nining, ma gam ka burbura ini tongge ilo fan male na fafapiiliis riu arare gam. ");
INSERT INTO hrw_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Kiskam sing gam, anwarow gam ngo are fan matmat ri tibi tow e ti tintof una peteng fate ilo, iya tongge ri ka su fesfes ilo poktow ma ri ka tibi parfat lo.” ");
INSERT INTO hrw_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Nenge lo re tongge parfat lo fafanau ka koso sing e Yesus aregii, “Titsa, biing o sesngeni e fan mok a, o su bero i kemeu ming.” ");
INSERT INTO hrw_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesus ka koso, “Ma gam na tongge parfat lo fafanau, kiskam sing gau ming, anwarow gam tow e fam fafanau tuntun tifre tongge una usi, ma gam tibom gam ka tibi ules ri una usi. ");
INSERT INTO hrw_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Kiskam sing gam, anwarow tumtumlami ri paketmet ire fam profet ma gam kau bilseni e fan matmat wilo ri. ");
INSERT INTO hrw_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Iya, gam ka bom sesuupuek i gam ini gam a-uu lo sa tumtumlami ri gow; ri paketmet ire fam profet ma gam kau bilseni e fan matmat wilo ri. ");
INSERT INTO hrw_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Anwarow lo mok gii, ilo bala konona sangsang ke Deo e war aregii, ‘Yau tule re fam profet ma fan apostel tifri, tongge ri mu paketmet ire fa lo ri, ma fa lo ri, ri mu bero iri.’ ");
INSERT INTO hrw_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ilea, kulu tinglo biing gii, riu kepe mafet nafow e dadaku re fam profet nano lewa ka lengi tinglo tofnge lo nal, ");
INSERT INTO hrw_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","tofnge tinglo andaku e Abel, ka la muut lo andaku e Jekaraiya, seri paketmet ini u falifu ine altar ma Felun Nining Bakir. Yow, ya peteng tif gam, kulu gii riu kepe mafet lo mara mok gii. ");
INSERT INTO hrw_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Kiskam sing gam na tongge parfat lo fafanau, anwarow gam sam kepufu e ki tinglo parfat. Gam tibom gam tifing kau ma gam kabung kaleni e sal kere fa gii ri ka rong una kaulek.” ");
INSERT INTO hrw_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Biing Yesus e la ting wa, fam Farasi ma fan titsa lo fafanau ri tofnge una fatinge tuntun tura Yesus, ma ri ka gatgatmo ine mara gatgatom, ");
INSERT INTO hrw_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ma ri ka nene i ini eu basaef ine ti sunwar. ");
INSERT INTO hrw_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Lo biing a, singmat na mar na kaltu tikin ri puek tiim gii male ka la kut, iya ri ka pii faliu lo kekek ri ma Yesus ka gongon famu singre fan disaipel kia, ka war, “Gam u ate use is kere fam Farasi, le melmel keri e tibi usi e fan warwar keri. ");
INSERT INTO hrw_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Mara mok e fifinuf, e amu puek malal. Ma fan sa e keskum, eu puek ten. ");
INSERT INTO hrw_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Sa gam war ini ilo bala anor, riu ongni lo siat, ma sa gau fakinal ini ilo bala fel, riu taungeni ilo poktow e fel. ");
INSERT INTO hrw_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Ya peteng tif gam tanga fenfenngong, gam u tibi soke re tongge a ri ku paketmet ine pinpinumfomi ma safle wimi, riu tibi fasi una gow e tikas ti mok ming. ");
INSERT INTO hrw_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Safle yau fanas gam ini se gam u sokeni. Gam u sokeni e se a, wimi ini e sau paketmet ine pinumfow e kaltu, i e mel e rawas ma mia una bas ini ilo bala iif. Yow, ya peteng tif gam, gam samusu sokeni. ");
INSERT INTO hrw_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Gau parfat ini tongge ri su felfeli e lim e amboron man ine 2 toiya, safle e tek ti fa lo ri, Deo eu sangintafngi. ");
INSERT INTO hrw_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Safle e tikin, fan mara sisian ololom tinglo paklum, Deo e sam wes famti. Ilea, gam u tibi soke, gam kulfi tikin e fan irin man gii. ");
INSERT INTO hrw_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Ya peteng tif gam, se e sesuupuek i yau na matre tongge, Sikow e Kaltu ming eu sesuupuek ini na matre fan anggelo ke Deo ilo balambat. ");
INSERT INTO hrw_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Safle se a ka peteng tifre tongge ini i e tibi ta lo yau, yau ming yau peteng tifre fan anggelo ke Deo ini i e tibi ta lo yau. ");
INSERT INTO hrw_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ma tongge nano gii ri ku gow e ti sunwar una fotpursi e Sikow e Kaltu, tubiil keri Deo eu sangintafngi, safle se gii ku gow e ti sunwar e sak use Tangwa Riis, Deo eu tibi sangintafngi sekit e tubiil kia. ");
INSERT INTO hrw_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Biing riu uun o ri ku la fetiuf o i famu ine fam felun nining, tam fang kaonsiil ma ge lamlam na famfamu, gam u tibi sangfuunfuun ini are gam u fakale lo gam tibom, tam sa gam samusu peteng ini, ");
INSERT INTO hrw_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","le Tangwa Riis eu fabenge sing gam lo biing a, ine sa gam samusu war ini.” ");
INSERT INTO hrw_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Nenge kaltu ulo falifu ire tongge a ka war singi, “Titsa, tabuung e sau met. Onu e tuaklik ku faseni e tuba e tauma lo kama.” ");
INSERT INTO hrw_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yesus ka koso, “Kaltu, se e sam siik yau una ta medistret tam una ti falifu i kamu?” ");
INSERT INTO hrw_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Wimi i kam war singre tongge a, “Gam samusu ate! Efefe kausi, are gam ka fabur use fan mara matmatan sinang na koko; kaltu e tibi fasi una kepe ninliu singe tuba.” ");
INSERT INTO hrw_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Wimi i ka peteng tifri ine warwar toftof gii, “Palang ke neng e kaltu tuba mel e fafuutngeni e fan tuan fuunfuun. ");
INSERT INTO hrw_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","I ka war singi tibom, ‘Ya ku gow e sa gii? E tek kek ti fel una tatauf fan tuan aiyang.’ ");
INSERT INTO hrw_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“Wimi i ka war, ‘I gii e sa yau gow. Yau paekufu e fan mara felum fitiil kiang ma ya ku feti e ti fanenger lamlam, usi yau tatauf fan mara firfiran wit ma fan mara konona fan mok kiang ilo bala. ");
INSERT INTO hrw_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ma ya ku war sing yau tibom aregii, “E fuun tikin e konona fan mok kiang, ya tatauf wilo mara matmatamfaim. Gii ya su manmanau, ya ku su enenen, ya ku su ininin ma ya ku su gasgas.” ’ ");
INSERT INTO hrw_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Safle Deo e war singi, ‘O lomba tikin! Geinggii na panambiing ou met. Wimi, se gii kamu kepe e fan sa o sau fagatiufu usi o tibom?’ ");
INSERT INTO hrw_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“I legii e mok eu fuut lo re tongge a ri ka taftafngeufu e tuba ri usi ri tibom, safle ri tibom ri sasngal na mata e Deo.” ");
INSERT INTO hrw_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Kala Yesus ka war singe fan disaipel kia, “Ilea ya ka peteng tif gam, gam u mele sangfuunfuun use ninliu kemi, ini sa una en, tam use pinumfomi, ini sa gam u los lo. ");
INSERT INTO hrw_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ninliu e bakir iyat ine tuan una en ma pinumfomi e bakir iyat ine fang kolos. ");
INSERT INTO hrw_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Sang usi re fang kiyaukang, ri tibi umume tam ri tibi fitfitiil, e tek ti felun tuan keri ma e tek ti fel keri una tatauf, safle Deo e fenfen ri. Ma gam, gau bakir iyat ire fan talaman na mata e Deo. ");
INSERT INTO hrw_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Le gam ku sangsang fuunfuun usi e ninliu kemi wagii lo nal, gam sang ini sangsang a e fasi una posmi balik e ninliu kemi ine ti borom pansumbiing? E tam. ");
INSERT INTO hrw_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Le gam ka tibi fasi una gow e tom boron mok aregii, e tamu gam ka sangfuunfuun use fanenger fan mok ming? ");
INSERT INTO hrw_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Gam sang use fam purpur a ri ka faf aina mok. Ri tibi fafaim fuunfuun, tam ri tibi somsomap lo fang kolos. Safle ya peteng tif gam, King Solomon e loslos lo fam finaswen kia, safle fam finaswen kia e tibi kulfi e fam finaswen kere fam purpur gii. ");
INSERT INTO hrw_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ma le ku ta ini Deo e fasfaswenu e fang garas aiya, a ku ta iri geinggii ma na biingbiing tongge ri ku tetes ma ri ku bas iri ilo bala iif, ma gam, gau bakir iyat ine fang garas, Deo eu tow e fang kolos kemi. Kiskam sing gam, titinge kemi e su balik. ");
INSERT INTO hrw_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ma mele sik ini sa gam u eni tam sa gam u inmi, mele sangfuunfuun usi. ");
INSERT INTO hrw_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Anwarow tongge tinglo nal ri siksik tuntun ine fan mok aregii, ma Taumi, i e parfat ini gau bura e fan mok aiya. ");
INSERT INTO hrw_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Safle gam samusu sik ine kepmale ke Deo, ma i kamu tata fan mok ming gii tif gam. ");
INSERT INTO hrw_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“E tikin, gam su ta borong galun sipsip, safle gam u tibi soke, anwarow Taumi e sau fefeal una tow e kepmale kia tif gam. ");
INSERT INTO hrw_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Umat ine fan mok gau mel lo ma gam ku fenre fan sasngal ine fan mani lo. Gam samusu kepe e fam poket gii ka tibi fasi una sak. Ma gam ku kepe e fan mok piik tinglo balambat gii ka tibi fasi una tam ini, ma tongge na kinkinau ri ku tibi fasi una kinow tam fam pespes ri ku tibi fasi una bero ini. ");
INSERT INTO hrw_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Anwarow le fan mok kausi kiam ri ku ta iya, ambusbusau ming eu ta wa. ");
INSERT INTO hrw_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Gam samusu fagati gam una faim. Piilpiiliis ma tafu e fan lam kemi ri ku fufuf, ");
INSERT INTO hrw_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","are tongge ri nene-i e kaltu bakir keri e bala mil tinglo en na tinaule, usi le i ku puek ma ku tukeni e matangkon, riu saupe tikin una ipki e matangkon tifi. ");
INSERT INTO hrw_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Eu kausi singre tongge na mus a, le kaltu bakir keri ku puek ma ku pari ini ri parpar. Ya peteng tikin tif gam, i eu bou faswenu una faim ma ku uun ri, ri ku fakiisnge liflifti e teibel una en ma i ku puek ku fen ri. ");
INSERT INTO hrw_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ma eu kausi singre tongge na mus a, antalu le kaltu bakir keri ku fespuek lo palim e biing, tam lo enene ma ku pari ini tongge na mus kia ri fagati ri una nene-i. ");
INSERT INTO hrw_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Safle gam u ten aregii; le kaltu ine ke fel enggi sau parfat lo sese anmatam pisii kaltu na kinkinau eu puek lo, i enggi tibi fasi una tafu e ke fel ri ku paki ma ri ku kau ilo. ");
INSERT INTO hrw_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Gau ming, gam samusu fagati gam, anwarow Sikow e Kaltu eu puek lo ti anmatam pisii gam tibi sangfi ini i eu puek lo.” ");
INSERT INTO hrw_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pita ka gatmo, “Taufi, areini, o petpeteng ini warwar toftof gii tif kemem, tam tifre tongge nano?” ");
INSERT INTO hrw_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ma Taufi ka koso “Sese kaltu a ka sagisu fafaim kausi ma ka mel e konona sangsang kia? I e ta kaltu a, kaltu bakir kia ku towfu una efefe lo re tongge na mus ilo ke fel ma una fenfen ri riis, lo fam biing una enen. ");
INSERT INTO hrw_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Eu kausi singe kaltu na mus a, le kaltu bakir kia ku mil ma ku sa pari ini i e musmusngeni e faim kia. ");
INSERT INTO hrw_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ya peteng tikin tif gam, kaltu bakir a eu towfu e kaltu na mus a una efe lo fan mara ninsiow. ");
INSERT INTO hrw_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Safle, le kaltu na mus a ku war singi tibom aregii, ‘Kaltu bakir kiang e tibi fasi una puek saupe,’ ma ku tofnge una paket re fan taltalu, antamat ma gelefin, ma i ku su enen ma ku su inin ku bengbeng, ");
INSERT INTO hrw_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Kaltu bakir eu puek lo biing gii kaltu na mus kia ka sangfi ini i eu tibi puek lo, ma lo anmatam pisii gii i ka tibi ateni. Kaltu bakir a eu tese liklik ine kaltu na mus a ma ku taufu ku melmel tura re tongge na tibi titinge. ");
INSERT INTO hrw_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Kaltu na mus gii ka parfat lo fabur ke kaltu bakir kia ma ka tibi fagati una nene-i, tam ka tibi gow e sa kaltu bakir kia e bura ini i eu gow, riu napis fuunfuun ine kaltu a. ");
INSERT INTO hrw_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Safle kaltu na mus gii ka tibi parfat lo fabur ke kaltu bakir kia ma ka tibi fagati una nene-i, tam ka tibi gow e sa kaltu bakir kia e bura ini i eu gow, riu tibi napis fuunfuun ine kaltu a. Se ri a ri ka tow e fan mok fuunfuun tifri, riu gatom ri use fan mok fuunfuun. Ma seri a ri ka tow e fan mok fuunfuun tikin tifri, riu gatom ri ming use fan mok fuunfuun tikin. ");
INSERT INTO hrw_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Ya sau puek una tow e iif ilo nal, ma ya bura tikin ini iif gii enggi sam tofnge una sok. ");
INSERT INTO hrw_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Safle ya samusu kepe e neng e amfagu, ma balang e mafet tikin, ku muut lo biing amfagu a eu rop. ");
INSERT INTO hrw_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Areini, gam sangfi ini ya puek una sa toufu e balamaris ilo nal? E tam. Ya peteng tif gam, ya puek una sa pete fapotpot ire tongge. ");
INSERT INTO hrw_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Tofnge ting geinggii ma ku la, le ka lim ailo bala fumberat, riu tapot ma ri ku fagorot iri tibom. E tuul e neng riu sak lo e u e neng, ma e u e neng ru ku sak lo re tuul neng. ");
INSERT INTO hrw_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Riu tapot, tamow eu sak lo sikow ma sikow tamat ku sak lo tamow. Tinow eu sak lo ke fefin ma ke fefin ku sak lo tinow. Ma tinow e kaltu eu sak lo awow, ma awow ku sak lo tinow e ke matuk.” ");
INSERT INTO hrw_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesus e peteng tifre tongge, “Biing gau pari e pambalbal e kanek ting u sif, saupe tikin gam ku peteng ini bat eu luut, ma eu luut. ");
INSERT INTO hrw_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ma biing gau pari e kif tinglo galu ise e matet, saupe tikin gam ku peteng ini male eu tuntun, ma eu tuntun. ");
INSERT INTO hrw_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Tongge na gurgurum, gam parfat una ikseni e parpar lo nal ma batsok. Ma areini gii gam ka tibi parfat una ikseni e sumbiing gii? ");
INSERT INTO hrw_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Use e tamu gam tibom gam ka tibi ikseni e fan sa e riis? ");
INSERT INTO hrw_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Biing o fesfes lala aiwa ilo sal tura kaltu una la tauf o tife medistret, tofo una fafariis tura, are i enggi am la tauf o tife medistret, ma medistret kam tauf o tifre fam polis ma ri kam tauf o ilo rerek. ");
INSERT INTO hrw_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ya peteng tif gam, gam u tibi fasi sekit una suu ku muut gam u faropo e fimfiil ri tow tif gam.” ");
INSERT INTO hrw_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Lo biing a e mel e fa ri fespuek talo Yesus, ri ka sa peteng tifi ini e mel e fa lo re fang Galili, Pailat e paketmet iri lo biing ri niil na fafen ine fam finafen keri. ");
INSERT INTO hrw_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yesus ka koso, “Areini, gam sang ini fan tubiil kere fang Galili a e sak sekit iyat ine fanenger fang Galili, anwarow ri tupngeni e matan mafet aiya? ");
INSERT INTO hrw_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ya peteng tif gam, e tam! Sakle le gam ku tibi iksi e balbalmi, gam nano ming gam u tuup. ");
INSERT INTO hrw_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Gam sangfi e tikii sangful ma e wal na kaltu lewa ri ka met lo biing fel bakir una Siloam e luut talo ri - gam sang ini ri na tongge a fan tubiil keri e sak sekit iyat ire tongge ri melmel ina Jerusalem? ");
INSERT INTO hrw_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ya peteng tif gam, e tam! Sakle le gam ku tibi iksi e balbalmi, gam nano ming gam u tuup.” ");
INSERT INTO hrw_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Kala Yesus ka seseng ine warwar toftof gii, “Neng e kaltu e mel e au fik e so ulo bala palang na waen kia. I ka la una la sik ine ti amfirow e au fik a, sakle i e tibi la par ti amfirow. ");
INSERT INTO hrw_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ma i ka war singe kaltu na efefe lo palang na waen a, ‘Kabuk la tuul e matamfaim gii a, ya salsala una sa siksik ine tam firow e au gii, safle ya tibi sa parpar ti amfirow. Pokufu, usi e tamu gii ku rop fofoesngeni e fan tuan tinglo nal gii?’ ");
INSERT INTO hrw_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Efefe lo palang a ka koso, ‘Kaltu bakir, tafu kubuk fatikii ti ming lo tikii ti matamfaim, ma ya ku bi kefi e warow ma ya ku of nal lo ine fam piinpiin. ");
INSERT INTO hrw_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Le ku fira lo matamfaim aiyat, kausi! Ma le ku tam, o kamu pokufu a.’” ");
INSERT INTO hrw_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Lo neng e biing Sabat Yesus e fabenge ulo bala neng lo re fam felun nining ");
INSERT INTO hrw_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","ma e mel e neng e wok uwa e fesfes saksak lo tikii sangful ma e wal na matamfaim singe neng e tara saksak. Antow e wok a e su pung sok ma e tibi fasi una ti riis. ");
INSERT INTO hrw_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Biing Yesus e pari e wok a, i e tau ini wi famu ma ka war singi, “Wok, o sam liu kosngi e anminse ailo o.” ");
INSERT INTO hrw_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Kala i ka tafu e limow ulo wok a, ma lo sumbiing a sekit wok a e la ti riis ma ka katfarsi e Deo. ");
INSERT INTO hrw_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Kaltu bakir tinglo felun nining a e la balasak anwarow Yesus e faliungeni mil e wok a lo biing Sabat, ma i ka war singre tongge, “E mel e on e biing una faim. Puek lo fam biing a, ri ku faliunge o, ma e tibi ta ini lo biing Sabat.” ");
INSERT INTO hrw_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Taufi ka koso singi, “Gam na tongge na kepkep gam na matam pangkii. E tamu, e tek tikas lo gam ek pikpikufu e amfinau tinglo ke buuluumakau tam ke dongki tinglo felu lo biing Sabat ma ku tatfeni una la fainmi? ");
INSERT INTO hrw_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Wok gii e ta tiner ke Abra-am, lewa Satan kabuk bingfamti lo tikii sangful ma e wal na matamfaim. E tamu, e tibi kausi ini riu faliungeni lo biing Sabat, kosnge sa i e sam kala ulo bala?” ");
INSERT INTO hrw_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Biing Yesus e war aiya, fa gii ri fatinge tura, ri la kiis borong sok, sakle tongge ri la fefeal tikin lo konona fan mok i e gowgow. ");
INSERT INTO hrw_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Kala Yesus ka gatom, “Kepmale ke Deo are e ngo? Yau fatofo lo sa? ");
INSERT INTO hrw_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Kepmale ke Deo e ngo are amfiran mastet, kaltu e kepe ma ka la so ilo bala palang kia. Amfiran mastet a e faf ka la ta kalut bakir, ma fan talaman ri ka puek ri ka sa tuut polpol ilo teltelow.” ");
INSERT INTO hrw_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Kala i ka gatou mil, “Yau fatofo e kepmale ke Deo lo sa? ");
INSERT INTO hrw_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","I e ngo are is, neng e wok e kepe ma ka iksi tura singmat na falawa, ma wimi falawa kiruur a kala ese.” ");
INSERT INTO hrw_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Wimi Yesus ka fes ka fabenge lala ulo bala fan taon ma fang kepkeptin male, biing i e fesfes lala wina Jerusalem. ");
INSERT INTO hrw_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Neng ka gatmo aregii, “Taufi, Deo eu su faliungeni e su puis e kaltu, be?” Yesus ka war singri aregii, ");
INSERT INTO hrw_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Ropo e songsongomfomi una kaulek ilo matangkon balik, anwarow, ya peteng tikin tif gam, fa fuunfuun riu tofo una kaulek ma riu tibi fasi. ");
INSERT INTO hrw_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Biing kaltu ine ke fel eu matet ma ku dukli e matangkon, gam u tisok ina male, gam ku tuktukeni e matangkon ma gam ku tautau aregii, ‘Kaltu bakir ipki e matangkon fasap kemem.’ “Sakle i eu koso aregii, ‘Ya tibi parfat lo gam ma ya tibi parfat ini gam la ting ya.’ ");
INSERT INTO hrw_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Wimi gam ku war, ‘Kemem en ma in tura o ma o ka fabenge ulo fan sal kemem.’ ");
INSERT INTO hrw_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Sakle i eu koso aregii, ‘Ya tibi parfat lo gam ma ya tibi parfat ini gam la ting ya. Gaman tii kosing yau. Gam na tongge na tumtubiil.’ ");
INSERT INTO hrw_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Eu mel e fatengse ma ngungutfat, biing gam u pari e Abra-am, Aisak ma Jekop ma fam profet nano ilo bala kepmale ke Deo, sakle gam tibom, riu bas suu i gam. ");
INSERT INTO hrw_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Tongge riu puek ting u weng ma ting i sif, ting i se ma ting i suu, ri ku keptafu ri lo en bakir ilo bala kepmale ke Deo. ");
INSERT INTO hrw_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Sunwar tikin i gii, e mel e fa seri a ri ka mi, riu la famu, ma fa a ri ka famu riu la mi.” ");
INSERT INTO hrw_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Lo biing a fa lo re fam Farasi ri puek talo Yesus ri ka war singi, “La tinglo male gii, o ku la ilo tikas ti male. Erot e bala paketmet iyo.” ");
INSERT INTO hrw_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yesus e koso, “Gam la peteng tife puul rokai a, aregii, ‘Yau fesel suu ire fan tara saksak ma yau faliungere tongge geinggii ma na biingbiing, ma lo biing baba e tuul yau faropo e faim kiang.’ ");
INSERT INTO hrw_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Safle, ya samusu posmi e faim kiang geinggii, na biingbiing ma paka-ii, anwarow eu tek ti profet eu met ina male ine male Jerusalem. ");
INSERT INTO hrw_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Jerusalem, Jerusalem o paketmet ire fam profet ma o ka rangmetmet ire fa Deo e tule ri usi o. Fam biing fuunfuun ya bura ini yau kepkeptiim ire fan siksikuam are ponga porot e kepkeptiim ire fan siksikow ilo pikliu e um papa-u, sakle gam tibom, gam tibi fabur. ");
INSERT INTO hrw_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Par! Fel kemi e umum usi gam. Ya peteng tif gam, gam u tibi fasi una par yau mil ku muut gam u war aregii, ‘Warfakausi tife se i e puek lo asow e Taufi.’” ");
INSERT INTO hrw_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Lo neng e Sabat, biing Yesus e la una la en ulo fel ke neng e paklure fam Farasi, tongge fuunfuun ri efe kausi ini i e gow e sa. ");
INSERT INTO hrw_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Wa, u famu ini, e mel e neng e kaltu e ing falek e tom fow. ");
INSERT INTO hrw_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesus ka gatom re fam Farasi ma tongge parfat lo fafanau, “E riis lo fafanau ini riu faliungere tongge lo Biing Sabat, tam e tam?” ");
INSERT INTO hrw_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Sakle e tek tikas lo ri ek gon. Iya i ka puse lo kaltu a, ka faliungeni ma ka tuleni ka la. ");
INSERT INTO hrw_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Kala i ka gatom ri, “Le tikas lo gam ku mel e ti sikow, tam ti buuluumakau kia eu luut ilo bala ampolo lo Biing Sabat, i eu tibi saupesak una tatfe kanek ini tinglo bala ampolo a?” ");
INSERT INTO hrw_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Safle ri tibi koso. ");
INSERT INTO hrw_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Biing i e pari ini tongge ri puek ulo en a, ri su bur la kiis ulo fan sia u famu sekit, i sesngeni e sunwar toftof gii tifri, ");
INSERT INTO hrw_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Le tikas ku fauun usi o una la ilo ti en bakir na tinaule, mangena la kepe e ti sia i famu sekit, are kuuf ma ka mel e tikas aiwa ri sau fauun usi, asow e bakir iyat iyo. ");
INSERT INTO hrw_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Le ku ngo aiya, kaltu bakir se gii ka fauun usi kamu nano eu puek ma ku sa war aregii sing o, ‘Tow e sia kiam tife kaltu gii.’ Wimi o ku maiyai saksak sekit ma o ku la kepe e ti sia imi sekit. ");
INSERT INTO hrw_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Sakle biing riu fauun usi o, ou la kepe e ti sia kere tongge fofoes, usi biing kaltu bakir tinglo en a eu puek, eu sa war sing o, ‘Fenngong, sa kiis lo sia gii famu.’ Le ku ngo aiya, tongge a ri ka sa la gam ka tiim lo en na tinaule a, riu resnge o. ");
INSERT INTO hrw_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Anwarow se a ka bom resngeni, riu faporo. Ma se a ka bou faporo, riu resngeni.” ");
INSERT INTO hrw_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Kala Yesus ka war singe kaltu a ka fauun usi wilo en aregii, “Biing o fagati e ti sun tuan tinglo siat, tam tinglo efef, mele fauun usi re tanga fenfenngom, tam tanga tuamlik, tam tongge lo o, tam tongge tuba mel i fatat o. Le o ku gorot aiya, kuuf ma ri ka subuk fauun usi o, ma ri ku kos famila e fan sa o sam gow lo ri. ");
INSERT INTO hrw_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Sakle biing ou gow e ti en bakir, fauun usi re fan sasngal, tongge fan susu lo fofori e sak, tongge kekek ri e dol, ma tongge ri baf, ");
INSERT INTO hrw_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","ma o ku kepe e warfakausi. E tikin ri tibi fasi una koso sing o, sakle ou kepe fimfiil lo, lo biing una matet mil singre tongge riis.” ");
INSERT INTO hrw_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Biing neng lo re tongge ri kiis tura Yesus ulo teibel e ongni e sunwar gii, i e war singi aregii, “Warfakausi eu ta ilo se gii i ku en lo en bakir ilo bala kepmale ke Deo.” ");
INSERT INTO hrw_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yesus ka koso, “Neng e kaltu e fagati e en bakir ma ka fauun use re tongge fuunfuun una sala. ");
INSERT INTO hrw_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Lo biing bengu e en bakir a eu puek, i eu tuleni e kaltu na mus kia una la peteng tifre tongge i e sau fauun usi ri aregii, ‘Gam kasa, mara mok ri sau fagatiufu.’ ");
INSERT INTO hrw_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Sakle tongge nano a ri tiin fakale lo ri tibom. Neng baba tikii e war aregii, ‘Ya am su fiilufu e neng e palang ma ya samusu la una la pari. Kiskam, tauf yau. Ya tibi fasi una la.’ ");
INSERT INTO hrw_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Neng ka war, ‘Ya am su fiilufu e sangful na buuluumakau una faim ma ya ta ilo sal una la tof ri. Kiskam, tauf yau. Ya tibi fasi una la.’ ");
INSERT INTO hrw_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Ma neng ming ka su war, ‘Ya am su tinaule, iya ya ka tibi fasi una la.’ ");
INSERT INTO hrw_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Iya kaltu na mus kia ka la mil ka la peteng tife kaltu bakir kia ine fan warwar keri. Biing kaltu ine ke fel e ong aiya, i e balasak tikin ma ka war aregii singe kaltu na mus kia, ‘La saupesak ilo fan mara sal bakir ma fan mara sal balik ilo taon, o ku la uunre fan sasngal, tongge fan susu lo fofori e sak, fa ri baf ma fa kekek ri e dol, ri ku sala.’ ");
INSERT INTO hrw_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Kaltu na mus kia ka war, ‘Kaltu bakir, sa o tungen yau una gow, ya sam gow, sakle e mel e sol iwa.’ ");
INSERT INTO hrw_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Kala kaltu bakir a ka peteng tife kaltu na mus kia aregii, ‘Suu kosnge taon o ku la ilo fan sal bakir ma fan sal balik o ku la war rawas singri, ri ku sa la usi ini fel kiang eu fuun. ");
INSERT INTO hrw_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ya peteng tif gam, e tek tikas sekit lo re tongge lewa ya kabuk fauun usi ri, eu tofo e ti boron su lo fan tuan tinglo en kiang.’” ");
INSERT INTO hrw_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Tongge fuunfuun ri mimi lala nami e Yesus ma i ka didiu mil usi ri ma ka war, ");
INSERT INTO hrw_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Le tikii tikas ku sa la usi yau ma ku tibi isa e tamow ma tinow, ke wok ma siksikow, tanga tualik ma tanga fefnelik - yow, ma ming ninliu kia tibou ming - i e tibi fasi una ta disaipel kiang. ");
INSERT INTO hrw_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ma se gii ka tibi kepe e aupaket kia ma ku usi yau, i e tibi fasi una ta disaipel kiang. ");
INSERT INTO hrw_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Ma le tikas lo gam ku bur feti e ti fel e kiis iyat na efefe, e tamu, i e tibi fasi una kiis famu ma ku bi sang ususi ini eu fis sekit e mani una ropo e fel kia? ");
INSERT INTO hrw_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Anwarow le i ku gow e warow e fel a ma ku tibi fasi una faropo, tongge nano seri gii ri ku pari e fel kia, riu tasa. ");
INSERT INTO hrw_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Ri ku war aregii, ‘Kaltu a e tofngeufu e fel gii ma ka tibi fasi una ropo.’ ");
INSERT INTO hrw_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Tam, le ti king ka bala la fapaket singe neng, neng e king, i eu kiis ma ku bi sang kausi famu, ini i e fasi una la tura tikii sangful na mar na soldia kia una la fapaket singe neng e king a ku puek tura e u e sangful na mar na soldia kia, tam e tam? ");
INSERT INTO hrw_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Le i ku tibi fasi, i eu tuleni e ti galung kaltu una la tof gatmo e king a, usi eu tow e ti sunwar na balamaris biing i e ta iwa i tapak. ");
INSERT INTO hrw_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Lo e su tikii sal, se lo gam a ka tibi tii kosnge mara mok kia, i e tibi fasi una ta disaipel kiang. ");
INSERT INTO hrw_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Semek e kausi, safle le ku rop e tiif lo, are riu gow ku semek mil? ");
INSERT INTO hrw_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","E tibi fasi una ulsi e fan tuan ilo palang una faf, tam ini riu iksi tura tektekre fam buuluumakau una tow lo fan tuan ilo palang. Riu su bas ini. “Se a ka mel e ambalbalu, tafu ku ong.” ");
INSERT INTO hrw_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Gii tongge na kepkep mani ma tongge na tumtubiil, ri tiin tiim liflifti e Yesus una ong singi, ");
INSERT INTO hrw_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","safle fam Farasi ma fan titsa lo fafanau ri balasak ini, ri ka war aregii, “Kaltu gii e arare re tongge na tumtubiil ma ka enen tiim tura ri.” ");
INSERT INTO hrw_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Wimi Yesus ka peteng tifri ine warwar toftof gii, ");
INSERT INTO hrw_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Le tikas lo gam ka mel e tikii atis na sipsip kia ma tikii tikas ku tam ini, e tamu, i eu tibi taufsok lo e siu e sangful ma e siu na sipsip a ri ku enen ilo ti mok ma i ku sik lala ine tikii sipsip a ku muut eu la tupngeni? ");
INSERT INTO hrw_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ma biing i e la pari e sipsip a, i eu fefeal tikin ma ku kepe ku towfu ilo pasow ");
INSERT INTO hrw_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ma ku la mil wilo fel kia. Kala i ku tau ire tanga fenfenngow ma tongge fatat ri, ri ku sa tiim ma ku war singri, ‘Fefeal tura yau, ya sau pari mil e kek sipsip lewa ka tam ini.’ ");
INSERT INTO hrw_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ya peteng tif gam, lo e su tikii sal, fefeal ilo balambat lo tikii kaltu na tumtubiil e iksi e sinangu, eu bakir tikin iyat ine fefeal lo e siu e sangful ma e siu na kaltu riis a ri ka tibi fasi una mu iksi e sinsinangu ri. ");
INSERT INTO hrw_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Tam le ti wok ka mel e tikii sangful na mani silwa kia ma tikii neng ku tam ini, e tamu, wok a eu tibi fakrefu e ti lam, ma ku saif fakausi e bala fel ma ku sik kausi ini ku muut i eu sikseni? ");
INSERT INTO hrw_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ma biing wok a e sam sipki mil, i eu fefeal tikin ma ku tau ire tanga fenfenngow ma tongge i fatatu, ri ku sa tiim tura ma ku war singri aregii, ‘Fefeal tura yau; ya sam sipki e mani kiang lewa ka tam ini.’ ");
INSERT INTO hrw_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ya peteng tif gam, lo e su tikii sal eu mel e fefeal na matre fan anggelo ke Deo nafow e tikii kaltu na tumtubiil le ku iksi e sinangu.” ");
INSERT INTO hrw_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesus e posmi e warwar kia aregii, “E mel e neng e kaltu e u e sikow tamat. ");
INSERT INTO hrw_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Neng balik ka war singe tamow aregii, ‘Tabuung, tow e galu kiang lo tubam a o ka sangsang ini ou faseni lo kama.’ Iya tamru ka faseni e tuba lo ru. ");
INSERT INTO hrw_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“E tifik la tapak e biing ini ma sikow balik ka kepe e fan mara mok gii i ka mel lo ma i ka la ulo neng e kaontri u tapak tikin. Uwa, i e la rop fofoesngeni e fan mara mok kia lo panaf na sinang e du. ");
INSERT INTO hrw_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Wimi ini i e sam la ropo e mara mok i e mel lo, singmat na biis bakir e fespuek ulo kaontri kiruur a, ma i ka tofnge una pospos lo fan mok. ");
INSERT INTO hrw_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Iya, i ka la, ka bom la sik fam faim singe neng e kaltu tinglo kaontri a. Kaltu a ka tuleni wilo bala balo kere fam bo kia una la fenfen ri. ");
INSERT INTO hrw_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","I e bura ini i eu siing bala ine fan tuan a fam bo ri ka eneni, sakle e tek tikas ek tow e ti mok tifi. ");
INSERT INTO hrw_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Biing konona sangsang e puek ulo paklu, i e war, ‘E fis sekit e kaltu na mus ke tabuung, sakle fan tuan ari e fuun ma yau gii ya ka rong una met singe biis gii. ");
INSERT INTO hrw_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Yau suu ting wagii, ya ku la mil use tabuung ya ku la war singi aregii, “Tabuung, ya sam tubiil lo Deo ma lo o. ");
INSERT INTO hrw_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ya am tibi riis ku fasi ini ou foteng yau ini ya na sikuam, ou su tauf yau, ya ku faim are kaltu na mus kiam.” ’ ");
INSERT INTO hrw_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Iya, i ka matet ka la mil use tamow. “Sakle biing sikow e ta uwa u tapak, tamow e sau pari ma bala ka la kuuluung usi. I e filau usi ka la ofngi ma ka osngi. ");
INSERT INTO hrw_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Sikow ka war singi, ‘Tabuung, ya sam tubiil lo Deo ma lo o. Ya am tibi riis ku fasi ini ou foteng yau ini ya na sikuam.’ ");
INSERT INTO hrw_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Sakle tamow e war singre tongge na mus kia, ‘Saupe! Kepe wagii e ti kolos tapak a ka par kausi tikin gam ku sa faloski ini. Fasow e ti ring ilo antelen limow ma ti sendel ilo ung kekow. ");
INSERT INTO hrw_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Kepe e ti borong kau a ka buiit ma gam u paketmeteni, kerer ku gow e ti en tura ma kerer ku fefeal tiim. ");
INSERT INTO hrw_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Anwarow sikuang e sau met ma gii e sam liu mil.’ Iya, ri ka tofnge una fefeal. ");
INSERT INTO hrw_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Lo biing a, sikow bakir e ta ulo bala palang. Biing i e puek fatatu e fel, i e ongni e dungwa ri, ri seksek ma ri ka guuiguui. ");
INSERT INTO hrw_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Iya, i ka tau ine neng lo re tongge na mus ka sa gatmo aregii, ‘Sa le leii ri gow leii?’ ");
INSERT INTO hrw_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Kaltu na mus a ka koso aregii, ‘Tuamlik e sau mil, ma taumu ka paketmet ine borong kau e buiit, anwarow i e pari e tuamlik e mil kausi.’ ");
INSERT INTO hrw_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Tualik bakir e balasak ma ka guuluung una kaulek. Iya tamow ka suu usi ka sa gon fangfangteni una kaulek. ");
INSERT INTO hrw_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Sakle sikow e koso singe tamow aregii, ‘Par! Mara matmatamfaim ya fafaim sing o are kaltu na mus kiam ma ya sagisu ususi e fam fatungen kiam. Safle e tifik mel e ti borom biing ini ok tow e ti boron meme tif yau usi ini ya ku fasi una fefeal tura tanga fenfenngong. ");
INSERT INTO hrw_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Sakle biing sikuam gii ka kepe e fan mara mok kiam ka la kiipkiip ini tifre gelefin gii ri ka bom umumat lala ine fofori e mil ilo fel, o kau paketmet ine borong kau e buiit a usi.’ ");
INSERT INTO hrw_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Tamow ka war singi, ‘Sikuang, bingne bingne o melmel tura yau ma fan mara mok ya mel lo e ta kiam. ");
INSERT INTO hrw_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Sakle kiar samusu fefeal ma gasgas, anwarow tuamlik e sau met ma gii i e sam liu mil. I e sam tam ini, sakle gii kiar sam kep famila.’” ");
INSERT INTO hrw_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesus e peteng tifre fan disaipel kia aregii, “E mel e neng e kaltu tuba mel ma e mel e kaltu na efefe lo fan mok kia, gii ri ka otngi ini i e fifiil fafalek ine fan mani ke kaltu bakir kia. ");
INSERT INTO hrw_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Iya, i ka tau kaulek ini ma ka sa gatmo, ‘Sa le gii ya ong lo, lo o? Tow e ti sinseng lo faim kiam tif yau, anwarow o am tibi fasi una ta kaltu una efefe lo fan mok kiang.’ ");
INSERT INTO hrw_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Kaltu na efefe a ka war singi tibom aregii, ‘Ya ku tamu gii? Kaltu bakir kiang e bala kepuf yau tinglo faim kiang. E tek kek ti raw una kekef, ma ya maiyai una farfaran lala. ");
INSERT INTO hrw_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ya parfat ini yau gow e sa, usi ini biing riu farop yau tinglo faim, tongge riu are yau wilo bala fam fel keri.’ ");
INSERT INTO hrw_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Iya, i ka tau kaulek tingtingke ire tongge gii ri ka dinau ine fan mani ke kaltu bakir kia. Ka gatmo e neng baba tikii, ‘E fis e mani ke kaltu bakir kiang o dinau ini?’ ");
INSERT INTO hrw_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Kaltu a ka koso, ‘E ta e wal e atis na galen na wel olif.’ “Wimi kaltu na efefe a ka war, ‘Kepe e kem risit, o ku kiis saupe ma o ku seti ku su fet e atis na galen na wel olif.’ ");
INSERT INTO hrw_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Wimi i ka gatmo e neng baba e u, ‘Ma o e fis e dinau kiam?’ “I ka koso, ‘Tikii mar na bek na wit.’ “I ka war singi, ‘Kepe e kem risit o ku seti ku su ta e wal e atis.’ ");
INSERT INTO hrw_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Wimi kaltu tuba mel a ka resngeni e asow e kaltu na efefe saksak a, le i e gow e fan mok gii are kaltu e sinangumel, anwarow tongge tingga lo nal ri parfat kausi tikin lo mara matmatan sal una musngeni e fan mus keri tinglo nal gii, ma parfat keri e kulfi e parfat kere fa ri musngeni e mus tinglo anten. ");
INSERT INTO hrw_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ya peteng tif gam, faim ine fan mani tingga lo nal una fatfenngo lo re tongge, usi ini biing fan mani a eu rop, riu tau i gam wilo fam fel gii ka tibi fasi una tam ini. ");
INSERT INTO hrw_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Se a ka efefe kausi lo fan iririn mok, i eu efefe kausi ming lo fan mok lamlam. Ma se a ka tibi usi e sinang e riis una efefe lo fan iririn mok, eu tibi usi e sinang e riis ming una efe lo fan mok lamlam. ");
INSERT INTO hrw_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ilea, le ri ka tibi fasi una titinge lo gam ini gam u efefe kausi lo fan mani tingga lo nal, anwarow ri sau pari e sinsinangumi ting wa, se a ku fasi una titinge lo gam ini gam u efe kausi lo fan mok tikin ting iyat? ");
INSERT INTO hrw_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ma le gam ka tibi efe kausi lo fan mok kere fa, se a kamu tow e ti ton mok ku ta kemi? ");
INSERT INTO hrw_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“E tek ti kaltu na mus ek fasi una faim singe e u e kaltu bakir. I eu isa e neng ma ku bura e neng. I eu natkeni e neng ma ku fasange singe neng. Gam tibi fasi una faim singe Deo ma singe mani.” ");
INSERT INTO hrw_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Fam Farasi ri ta tongge ri biit mani tikin, iya ri ka ongni e fang gongon gii ma ri ka tumaru e Yesus. ");
INSERT INTO hrw_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yesus ka war singri, “Gam na tongge una gorgorot fakausi e fan mok namatre tongge ini ri ku peteng ini gam na tongge kausi, sakle Deo e parfat lo fan sa e ngongo borong ilo busbusami. Ma sa a tongge ri ka sangfi ini e ta konona fan mok, e ta fan mok e sak sekit na mata e Deo. ");
INSERT INTO hrw_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Fam fafanau ke Moses ma fam fabenge kere fam profet ri sesngeni ka muut lo biing ke Jon, kaltu na gugu tarawen. Tofnge tinglo biing ke Jon ka sa muut geinggii, ri sesesngeni lala e konona sunwar lo kepmale ke Deo ma tongge nano ri susuk iri una kaulek ilo kepmale a. ");
INSERT INTO hrw_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","E paumiil tikin singe balambat ma nal una tuup, sakle e tuntun tikin singe ti amboron tok lo pen ri seti ine fafanau ini eu tam ini tinglo. ");
INSERT INTO hrw_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Se a ka finngeni e ke wok ma ka la tili e neng e fefin, kaltu a e gow e sinang na faet fafalek, ma se a ka la tili e neng e fefin e kere e antinaule, kaltu a ming e gow e sinang na faet fafalek. ");
INSERT INTO hrw_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“E mel e neng e kaltu tuba mel se e loslos lo fang kolos tapak kaukaor ma e par kausi tikin ma i e su enen kausi bingne. ");
INSERT INTO hrw_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ulo matangkon lo banis kia, ri sa fafangongeufu e neng e kaltu sasngal ulo, asow gii Lasarus, ma fow e fuunuf ine fam piiu. ");
INSERT INTO hrw_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","I e nene una eneni e fam piin lo fan tuan e luutluut tinglo teibel ke kaltu a, ma fam puul ming ri sa demdeme e fam piiu kia. ");
INSERT INTO hrw_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Wimi kaltu sasngal a ka met ma fan anggelo ri ka onu ri ka la towfu unaisa e Abra-am. Kaltu tuba mel ming a e met ma ri ka ofo. ");
INSERT INTO hrw_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","I e kepe singmat na ongker ulo bala iif na imperno. Ma biing i e par kanek, i e pari e Abra-am u tapak tikin tura Lasarus ulo galu lo. ");
INSERT INTO hrw_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Iya i ka tau singi, ‘Tabuung Abra-am, tengis yau ma o ku onu e Lasarus ku toko e ngusu e antelen limow ilo ti dan ma ku sa famaira e angkermeng, anwarow ya ongker tikin ilo bala iif gii.’ ");
INSERT INTO hrw_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Sakle Abra-am e koso singi aregii, ‘Sikuang, ou sangfi aregii, lo biing o liuliu uwa, o sam kepe e konona fan mok, ma Lasarus ka kepe e fan mok saksak, sakle gii, i ka subung kiis kausi, ma o ka kepe e singmat na ongker. ");
INSERT INTO hrw_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ma neng e mok ming, e mel e singmat na anlau Deo e sau bilseufu i falifu i kiar, usi ini se a ka bur la ting wagii usi gam, tam se a ka bur la tingwa usi kemem, i eu tibi fasi.’ ");
INSERT INTO hrw_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Ma i ka koso, ‘Arik, ya gatom fangfangte o tabuung, tuleni e Lasarus ku la ilo fel ke tabuung, ");
INSERT INTO hrw_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","le e mel e baba lim na tuaklik. Onu ku la war rawas singri, ri ku ate, usi ini riu tibi sa la ming ilo male na ongker gii.’ ");
INSERT INTO hrw_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Ma Abra-am ka koso, ‘Fam fafanau ke Moses ma fam fabenge kere fam profet iwa i sing ri. Touf ri, ri ku ong singri.’ ");
INSERT INTO hrw_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Kaltu a ka war, ‘E tam, tabuung Abra-am, le tikas kabuk met, ma ku matet mil kosnge minet, ku la peteng tifri, riu titinge ma ri ku sangikis.’ ");
INSERT INTO hrw_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Ma Abra-am ka war singi, ‘Le ri ku tibi fasi una ongne singe fam fafanau ke Moses ma fam fabenge kere fam profet, ri tibi fasi una titinge ming singe tikas le ku matet mil kosnge minet.’” ");
INSERT INTO hrw_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesus ka war singre fan disaipel kia, “Fan mok una pete luut ire tongge ilo fan tubiil, riu puek, safle kiskam singe kaltu a ka gow e fan mok una fafaluutnge re tongge. ");
INSERT INTO hrw_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Le tikas ku gow e ti mok lo re anrimberat gii ku luut lo tubiil, i eu kepe mafet e bakir iyat, le ri ku kawi e ti fat bakir ilo angkongkongow ma ri ku fauli ina kasap. ");
INSERT INTO hrw_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Iya, ate kausi. “Le tuamlik ka tubiil, porow, ma le i ku sangikis, sangintafngi e tubiil kia. ");
INSERT INTO hrw_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Le i ku fafis tubiil lo o, lo bala tikii biing ma ku fafis mil ku sa war sing o, lo bala tikii biing ini i e sam sangikis, o samusu sangintafngi e tubiil kia.” ");
INSERT INTO hrw_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ma fan apostel ri ka war singe Taufi, “Fabakirngeni e titinge kemem.” ");
INSERT INTO hrw_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ma i ka koso, “Le gam ku mel lo titinge e su balik are amfiran mastet, gau fasi una war singe kalut bakir gii, ‘Fifit ting wagii ma o ku la ti ina kasap,’ ma i ku ong sing gam. ");
INSERT INTO hrw_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Le tikas lo gam enggi mel e ti kaltu na mus kia e so e ke palang tam e efe lo fan sipsip kia, ma kaltu a ku mil tinglo faim, e fasi ini ou war singi aregii, ‘Arik a, kasa wagii o ku sa kiis ma o ku en’? ");
INSERT INTO hrw_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","E tam, ou su war singi aregii, ‘Fagateni e fan tuan aiyang, ma o ku ternge o ma o ku efe use fam fabur kiang ma ya ku enenen ma ininin, wimi o kamu subuk en ma o ku in a.’ ");
INSERT INTO hrw_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Are ini, ou aro singi le i e sam usi e fan sa o onu ini una gow? E tam. ");
INSERT INTO hrw_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ilea, gau ming, biing gam sam ropo e mara mok ri uun gam ini una gow, gam samusu war aregii, ‘Kemem tibi ta konona tongge na mus ku fasi ini riu katfariis kemem. Kemem su gow e fan mus kaltu bakir kemem e sam tow tif kemem.’” ");
INSERT INTO hrw_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Biing Yesus e fes wina Jerusalem, i e fes lala ulo makpaek lo distrik Samaria ma Galili. ");
INSERT INTO hrw_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Biing i e bala kaulek ulo neng e keptin male, tikii sangful na kaltu e mel e anminse lepra ulo ri, ri ka tongeni. Ri ti uwa u tapak, ");
INSERT INTO hrw_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ma ri ka tau bakir tikin singi, “Yesus, Kaltu bakir, tengis kemem!” ");
INSERT INTO hrw_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Biing i e par ri, i ka war, “La, gam ku la fanangsi gam tibom tifre fam pris.” Ma biing ri la, fofori e la kalkaliis. ");
INSERT INTO hrw_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Tikii neng e lo ri, biing e pari ini anminse ulo e sam rop, i e mil ka tautau bakir lala ma ka katkatfarsi lala e Deo. ");
INSERT INTO hrw_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","I e puek ka sa luut ulo fow e ungkekow e Yesus ma ka aro singi - i e ta kaltu tingna Samaria. ");
INSERT INTO hrw_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ma Yesus ka gatom, “E tibi ta ini tikii sangful na kaltu ri sam kalkaliis? Nenge baba siu, iri iya? ");
INSERT INTO hrw_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ya sang ini e sam tek tikas eu mil una sa katfarsi e asow e Deo, be, safle sikin ses gii?” ");
INSERT INTO hrw_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Wimi ka war singe kaltu a aregii, “Matet o ku la, titinge kiam e sau faliunge o.” ");
INSERT INTO hrw_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Neng e biing, fam Farasi ri gatmo e Yesus ini sese biing kepmale ke Deo eu puek, ma i ka koso, “Biing kepmale ke Deo eu puek, tongge ri tibi fasi una pari ine matmatri, ");
INSERT INTO hrw_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","tam ini tongge ri ku peteng ini, ‘I legii,’ tam, ‘I leleii,’ anwarow kepmale ke Deo e sam ta ina balmi.” ");
INSERT INTO hrw_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Kala i ka war singre fan disaipel kia, “Biing eu puek ma gam ku bura tikin ini gam u pari e tikas lo re fam biing ke Sikow e Kaltu, sakle gam u tibi pari. ");
INSERT INTO hrw_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Tongge riu peteng tif gam, ‘I leleii!’ tam ‘I legii!’ Mangena la filau lala nami ri. ");
INSERT INTO hrw_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Anwarow Sikow e Kaltu lo biing kia, eu ngo are ampil, a ka pil ma ka sosok ilo batsok tinglo neng e ngusu ku la muut ilo neng e ngusu. ");
INSERT INTO hrw_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Sakle famu, i e samusu kepe fan mafet fuunfuun, ma kulu tinglo biing gii ri ku guuluung ini. ");
INSERT INTO hrw_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“E su ngo are lewa lo fam biing ke Noa, ma eu su ngo aiya ming gii tura fam biing ke Sikow e Kaltu. ");
INSERT INTO hrw_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Tongge ri ininin ma enenen, antamat ma gelefin ri fatinaule faliu, ka la muut lo biing Noa e kaulek ulo sip. Wimi male ka fuun ma ka bero iri nano. ");
INSERT INTO hrw_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“E su ngo are lo fam biing ke Lot. Tongge ri enenen ma ininin, fififiil ma umumat, umume ma bilbilse fam fel. ");
INSERT INTO hrw_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Safle lo biing Lot e la kosnge taon Sodom, iif ma fam fulful e luut are bat tinglo balambat, ru ka bero sekit iri nano. ");
INSERT INTO hrw_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Eu su ngo aregii lo biing Sikow e Kaltu eu puek. ");
INSERT INTO hrw_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Lo biing a, se a ka ta ilo palkanmale, e mu tibi la kaulek mil ilo bala ke fel use fan mok kia una la kepe. E su ngo ming aregii, se a ka ta ilo bala palang, e mu tibi la mil use ti mok. ");
INSERT INTO hrw_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Sang use wok ke Lot! ");
INSERT INTO hrw_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Se a ka tofo una bingfamti e ninliu kia tibom, ninliu kia eu tam ini. Sakle se a ku fafen ine ninliu kia, i eu kepe e ninliu kia. ");
INSERT INTO hrw_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ya peteng tif gam, lo panambiing a, e u e kaltu ruw fabulis ilo bala ngiin. Neng lo ru, riu kepe ma neng ku ngo sok. ");
INSERT INTO hrw_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","E u e fefin ruw sese firfiran wit wilo falawa, neng lo ru, riu kepe ma neng ku ngo sok.” ");
INSERT INTO hrw_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Fan disaipel kia ri ongni e fan warwar a, ri ka gatmo, “Taufi, mok gii eu fuut iya?” Ma i ka koso, “Mok a ka mel e kaltu e met ilo, ilo mok a, gam u pari e fan man riu la tiim ilo una eni.” ");
INSERT INTO hrw_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Wimi Yesus ka peteng tifre fan disaipel kia ine neng e warwar toftof una fabenge singri, ini ri samusu nining bingne ma ku tibi golgol e fofori. ");
INSERT INTO hrw_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","I ka war singri, “Ulo neng e taon, e mel e neng e medistret. I e tibi soksokeni e Deo ma i e tibi efefe kausi lo re tongge. ");
INSERT INTO hrw_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ma ulo taon a, e mel e neng e wok makos. I e sagisu pupuek use medistret a ka sa petpeteng tifi aregii, ‘O samusu ules yau, anwarow kaltu na matamfais kiang e bala bero i yau.’ ");
INSERT INTO hrw_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Fam biing fuunfuun medistret a e tibi ongong singe wok a. Sakle lo neng e biing i ka war singi tibom, ‘E tikin, ya tibi soksokeni e Deo ma ya tibi sangsang usi re tongge. ");
INSERT INTO hrw_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Sakle anwarow wok makos gii e puek sok talo yau, yau ulsi lo anganggon kia, are wimi kam la golgol e fong singi.’” ");
INSERT INTO hrw_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ma Taufi ka war, “Gam kepe sangsang tinglo sa medistret saksak a e war ini. ");
INSERT INTO hrw_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Deo ming eu ules re tongge kia, le ri ku tengseni lo fan siat ma fam panambiing ma i eu saupe una ules ri. ");
INSERT INTO hrw_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ya peteng tif gam, i eu fariisu e fan mafet keri ma ku ules ri saupe tikin. Safle, lo biing Sikow e Kaltu eu puek, i eu sikseni ini ti tom fa lo re tongge gii lo nal ri titinge, tam e tam?” ");
INSERT INTO hrw_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yesus ka seseng ine neng e warwar toftof tifre tongge a ri ka titinge lo ri tibom ini ri riis fasef ma ri ka parpu ire fa. ");
INSERT INTO hrw_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“E u e kaltu ru la ulo Felun Nining Bakir una la nining. Neng e ta Farasi ma neng e ta kaltu na kepkep mani. ");
INSERT INTO hrw_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Farasi a, e ti ma ka nining aregii, ‘Deo, ya aro sing o, anwarow ya tibi gorot are fanenger fan tongge - tongge na kinkinau, fa una gowgow e fan sinang saksak, tongge na gowgow e ansinang na faet falek - tam ini yau ngo ming are kaltu na kepkep mani gii. ");
INSERT INTO hrw_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ya felfel lo e u e biing lo bala tikii neng, tikii neng e wik. Ma fan mok ya kepkepe, ya fasfaseni lo sangful na amfor ma ya ka fafafen ine tikii amfor.’ ");
INSERT INTO hrw_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Sakle kaltu na kepkep mani e su ti uwa u tapak, ma e tibi par wilo balambat ming, i e su pakti e bala ususu ma ka war, ‘Deo, tengis yau. Ya na kaltu na tumtubiil.’ ");
INSERT INTO hrw_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Ya peteng tif gam, kaltu gii, Deo e pari ini i e ta kaltu riis ma i ka la mil ulo ke fel. E tibi ta ini Farasi a, anwarow tongge nano a ri ka bom resnge ri, Deo eu fapor ri. Ma tongge nano a ri ka fapor ri tibom, Deo eu resnge ri.” ");
INSERT INTO hrw_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Tongge ri kepuek ming ine fam buubuun keri tife Yesus usi ini i eu la pot lo ri. Biing fan disaipel ri pari e mok gii, ri porau ri. ");
INSERT INTO hrw_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Sakle Yesus e tau ire berberat usi ma ka war, “Gaman tauf re berberat ri ku sa la usi yau. Gam u tibi kale ri, anwarow kepmale ke Deo e ta kere matan tongge aregii. ");
INSERT INTO hrw_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ya peteng tikin tif gam, le ti kaltu ku tibi a-uu lo kepmale ke Deo are tom boroner, i eu tibi fasi sekit una kaulek ilo bala kepmale ke Deo.” ");
INSERT INTO hrw_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ma neng lo re tongge lamlam ka gatmo, “Konona titsa, yau samusu gow e sese mok, usi ini yau kepe e ninliu bingne?” ");
INSERT INTO hrw_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesus ka koso singi, “Usi e tamu o ka foteng yau ini konona kaltu? E tek tikas eng kausi, sakle Deo tibom. ");
INSERT INTO hrw_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","O sau parfat lo fam fafanau: ‘Gam u tibi gow e ansinang na faet falek, gam u tibi paketmet ire fa, gam u tibi kinau, gam u tibi gurum talo re fa, gam samusu nawen singre tautaumi ma tintinmi.’” ");
INSERT INTO hrw_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ma kaltu a ka war, “Fan mara mok nano gii ya sam ususi tinglo biing ya balik uwa ka sa muut gii.” ");
INSERT INTO hrw_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Biing Yesus e ongni e war aiya, i ka war singi, “O pospos aiwa lo neng e mok. La o ku la umat ine mara mok nano kiam, ma mani ou kepe lo, ou faseni lo re tongge sasngal. Ou gorot aiya, usi eu mel e fan mok piik kiam ilo balambat. Wimi o kamu mi nami yau a.” ");
INSERT INTO hrw_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Biing kaltu a e ongni e sunwar gii, bala e la mafet, anwarow i e ta kaltu tuba mel. ");
INSERT INTO hrw_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesus ka par usi ma ka war, “Tongge tuba mel, e tuntun tikin singri una kaulek ilo bala kepmale ke Deo. ");
INSERT INTO hrw_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","E tikin e tuntun singe kamel una los ilo amfur lo nil na somsomap, sakle e tuntun tikin iyat singe kaltu tuba mel una kaulek ilo bala kepmale ke Deo.” ");
INSERT INTO hrw_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Fa a ri ka ongni e Yesus e war aiya, ri ka gatom, “Le ku ta aiya, se gii ku fasi una kepe ninliu bingne?” ");
INSERT INTO hrw_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ma Yesus ka koso, “Sa a kaltu ka tibi fasi sekit una gow, Deo e fasi una gow.” ");
INSERT INTO hrw_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ma Pita ka war singi, “Kemem sam la kosngi e fan mara mok nano kemem ma kemem ka usi o.” ");
INSERT INTO hrw_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yesus ka war singri, “Ya peteng tikin tif gam, se gii kabuk la kosngi e ke male, tam ke wok, tam tanga tualik, tam tamow ma tinow, tam berberat kia na fow e kepmale ke Deo, ");
INSERT INTO hrw_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","i eu kep fuunfuunngeni e konona fan mok gii lo biing gii ma wimi, i eu kepe e ninliu bingne, bingne.” ");
INSERT INTO hrw_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesus ka uunre tikii sangful ma e u na disaipel ka la ulo galu ma ka peteng tifri, “Kiar u la kanek ina Jerusalem ma fan mara mok lewa fam profet ri kabuk seti ini eu fuut lo Sikow e Kaltu, riu fabonti. ");
INSERT INTO hrw_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Riu tow ilo limre fan Jentael ri ku tumaru, ri ku bero ini ine fan warwar saksak, ri ku kansu, ri ku napsi ma ri ku paketmet ini. ");
INSERT INTO hrw_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Lo biing baba e tuul i eu matet mil.” ");
INSERT INTO hrw_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Fan disaipel ri tibi kepe e bala e fan warwar gii. Pimpiku e fifinuf iri, ma ri tibi parfat ini sa Yesus e gongon lo. ");
INSERT INTO hrw_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Biing Yesus e puek fatat una Jeriko, neng e baf e kiiskiis ulo anisow e sal ka farfaran fan mok singre tongge. ");
INSERT INTO hrw_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Biing i e ongen re galung kaltu ri sol paket, i e gatom ri ini ri gow e sa. ");
INSERT INTO hrw_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Tongge a ri ka peteng tifi, “Yesus tingna Nasaret legii e sol paket.” ");
INSERT INTO hrw_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","I ka tau, “Yesus, Sikow e Dewit, tengis yau!” ");
INSERT INTO hrw_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Fa ri famfamu lala, ri ka porow ma ri ka war singi ini i eu fakuta e ngusu. Sakle i e su tau bakir tikin mil aregii, “Sikow e Dewit, tengis yau!” ");
INSERT INTO hrw_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yesus ka la tisok ma ka fauun ini riu onu e baf a usi. Biing baf e la puek unaisa, Yesus ka gatmo, ");
INSERT INTO hrw_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“O bura ini yau gow e sa lo o?” I ka koso, “Taufi, ya bura ini yau par.” ");
INSERT INTO hrw_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesus ka war singi, “Par! Titinge kiam e sau faliunge o.” ");
INSERT INTO hrw_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ma saupesak anmata ka par ma i ka mi nami e Yesus ka katfarsi lala e asow e Deo. Biing tongge nano ri pari e mok gii, ri ming ri katfarsi e Deo. ");
INSERT INTO hrw_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesus e kaulek una Jeriko ma ka fes una sol sekit. ");
INSERT INTO hrw_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","E mel e neng e kaltu uwa ri fotngi ini Sakiyas. I e ta kaltu bakir lo re tongge na kepkep mani ma e ta kaltu tuba mel. ");
INSERT INTO hrw_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","I e bur par ini Yesus e ta se, sakle i e pospostuuk tikin gii ka tibi fasi una pari e Yesus, anwarow tongge ri fuun. ");
INSERT INTO hrw_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Iya, i ka filau famu ka la fen ulo neng e au fik ulo mok gii ini Yesus ku sol paket ulo, usi ini i ku par lo. ");
INSERT INTO hrw_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Biing Yesus e la ti sekit ulo mok a, i e tar wiyat ma ka war singi, “Sakiyas, pu saupe wagii! Anwarow ya samusu ta ilo keu fel, geinggii.” ");
INSERT INTO hrw_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Saupesak, Sakiyas ka pu, ka sa areni e Yesus tura singmat na gasgas. ");
INSERT INTO hrw_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Tongge nano ri pari e mok gii, ma ri ka tofnge una famunge, ri ka war, “I e la una la en tura kaltu na tumtubiil.” ");
INSERT INTO hrw_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Safle Sakiyas e ti ma ka war aregii singe Taufi, “Par, Taufi! Gii, yau fenre fan sasngal ine galu lo tubang. Ma le ya kabuk gurum ine tikas ma ya ka kep fofoes ine ti mok kia, yau fiil fafetngeni mil ine fimfiil lo tifi.” ");
INSERT INTO hrw_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ma Yesus ka war singi, “Geinggii, ninliu fuu e sau puek ilo fel gii, anwarow kaltu gii ming e ta sikow e Abra-am. ");
INSERT INTO hrw_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Le Sikow e Kaltu e puek una sik ma una faliungeni e se e sam tam ini.” ");
INSERT INTO hrw_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Biing ri ongongne lo mok gii, i ka seseng ming ine neng e warwar toftof tifri, anwarow i e sau fatat una Jerusalem ma tongge ri ka sangfi ini kepmale ke Deo eu su puek saupe tikin. ");
INSERT INTO hrw_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","I ka war, “E mel e neng e kaltu bakir e rong una la u tapak ini ri ku la feti ku ta king, ma ini kamu mil ilo ke male. ");
INSERT INTO hrw_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Iya, i ka tau ire tikii sangful na kaltu na mus kia, ka tow e 1,000 kina tife tikii neng, tikii neng lo ri ma ka war, ‘Gam u faimngeni e fan mani a ku muut yau mil.’ ");
INSERT INTO hrw_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Sakle tongge tinglo male kia sekit ri tibi bura ini i eu ta king, iya ri ka tule re fa, ri ka mi nami una la peteng aregii, ‘Kemem tibi bura ini kaltu gii eu ta king kemem.’ ");
INSERT INTO hrw_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Safle ri la feti ka ta king ma ka mil. Kala ka tau ire tongge na mus a ka tow e fan mani tifri, usi ini i eu sa parfat singri ini ri sau musngeni e, e fis e mani ming ilo poktow e neng a i kabuk tow tifri. ");
INSERT INTO hrw_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Neng baba tikii e puek ka sa war, ‘Kaltu bakir, ya sau musngeni e 1,000 kina lewa o ka tow tif yau, ka puek ka la ta 10,000 kina.’ ");
INSERT INTO hrw_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Ma kaltu bakir a ka koso, ‘Konona faim. O ta konona kaltu na mus kiang. O sam efefe kausi lo fan iririn mok, gii, ou efe lo tikii sangful na siti.’ ");
INSERT INTO hrw_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Wimi neng baba e u ka puek ka sa war, ‘Kaltu bakir, ya sau musngeni e 1,000 kina lewa o ka tow tif yau ka puek ka la ta 5,000 kina.’ ");
INSERT INTO hrw_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Ma kaltu bakir kia ka koso, ‘Ou efe lo baba lim na siti.’ ");
INSERT INTO hrw_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Kala neng e kaltu na mus ming ka puek ka sa war, ‘Kaltu bakir, 1,000 kina kiam gii, ya afti ine sun laplap ma ya ka finufu. ");
INSERT INTO hrw_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ya soke o, anwarow o ta kaltu na fafaporau. Fan mok o tibi towfu, ou la kepe ma fan mok o tibi so, ou la fitlii.’ ");
INSERT INTO hrw_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Ma kaltu bakir kia ka war, ‘Yau ikse o ine fan warwar kiam tibom. O na kaltu na mus saksak, o parfat be, ini ya na kaltu na fafaporau, ya la kepkepe e fan mok ya tibi towfu ma ya ka la fiitfiitlii e fan mok ya tibi so? ");
INSERT INTO hrw_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ma e tamu o ka tibi towfu e mani kiang ulo beng, usi ini biing ya sau mil, yang gi sa kepufu tura ti ton neng ming ilo poktow?’ ");
INSERT INTO hrw_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Wimi ka war singre fa ri titi u fatat, ‘Gam kepufu e 1,000 kina gii singi ma gam ku tow tife neng a ka mel e 10,000 kina i singi.’ ");
INSERT INTO hrw_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Ri ka war, ‘Kaltu bakir, e sau mel e 10,000 kina i singi.’ ");
INSERT INTO hrw_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Ma i ka koso, ‘Ya peteng tikin tif gam, tongge nano a ri ka mel e fan mok keri, riu tata ming fatalu. Sakle use se a ka tek ti mok kia, boron sa a i ka mel lo, riu kepufu singi. ");
INSERT INTO hrw_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Sakle tongge na matamfais kiang, a ri ka tibi bura ini eu ta ya na king keri, uun ri wagii, gam ku sa paketmet iri na matang.’” ");
INSERT INTO hrw_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Biing Yesus e sesngeni tikii e warwar toftof gii, i e famu iri, ri ka la kanek wina Jerusalem. ");
INSERT INTO hrw_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Biing i e sau fatfatat ma ku puek una Betfage ma Betani, ulo paklunmale ri fotngi ini paklunmale Olif, i e tuleni e un neng lo re fan disaipel kia ka la ma ka war singru, ");
INSERT INTO hrw_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Kamuw la ilo sun male ai famu, ma biing kamuw kaulek ilo, kamuw pari e dongki fuu ri kaweufu, ma e tek tikas ek sam kiis ulo. Pikufu ma kamu ku mil tura. ");
INSERT INTO hrw_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ma le tikas ku gatom kamu ini, ‘Kamu pikii wina tamu?’ Kamuw peteng tifi aregii, ‘Taufi e mel e faim kia lo.’” ");
INSERT INTO hrw_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ung kaltu a Yesus ka tule ru, ru la ru ka la pari ini fan mok e su ngo aregii Yesus ka peteng. ");
INSERT INTO hrw_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Biing ru pikpikufu e amfinau lo dongki fuu a, kaltu kia ka gatom ru, “Kamu pikii e dongki a una tamu?” ");
INSERT INTO hrw_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ru ka koso, “Taufi e mel e faim kia lo.” ");
INSERT INTO hrw_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ru ka tatfeni tife Yesus, ru ka solo e fang kolos tapak ke ru ulo poktow ma ri ka ulsi e Yesus ka kiis ulo. ");
INSERT INTO hrw_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Biing e fesfes lala ka la, tongge ri sosol fang kolos tapak keri ulo sal. ");
INSERT INTO hrw_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Biing i e puek fatatu e male a ine sal ulo ka tofnge pu tinglo paklunmale Olif, singmat na galun disaipel a ri tofnge una kaung na fefeal ma katfarsi e Deo, anwarow lo fan mok na tibou fuut ri sau pari: ");
INSERT INTO hrw_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Warfakausi tife King, se e puek lo asow e Taufi. Balamaris ilo balambat ma akteni e asow e Deo wiyat sekit!” ");
INSERT INTO hrw_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Fa lo re fam Farasi ulo bala galung kaltu a, ri ka war singe Yesus, “Titsa, porau re fan disaipel kiam!” ");
INSERT INTO hrw_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yesus ka war, “Ya peteng tikin tif gam, le ku tek borong lo ri, fam fatfat riu fagalo.” ");
INSERT INTO hrw_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Biing i e puek fatat una Jerusalem ma ka pari e siti, i e teng usi, ");
INSERT INTO hrw_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ma ka war, “Enggi kausi le ong gi sau parfat lo sa a ku tow e balamaris tifo, sakle gii, i e fifinuf ine wan matam. ");
INSERT INTO hrw_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Biing eu puek ma tongge na matamfais kiam, ri ku balo kale o ma ri ku ti kale o ilo fan mara galgalu nano. ");
INSERT INTO hrw_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Riu siiufo ma ri ku bero sekit i o. O tura berberat ilo bala balo kiam. Riu tibi fasi una towfu e tikii ti fumfat ku ngosok ilo poktow e tikas ti fu, anwarow o tibi parfailmi e biing Deo e puek una ules o.” ");
INSERT INTO hrw_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Wimi i ka la kaulek ulo balo lo Felun Nining Bakir ma ka tofnge una fesel suu ire tongge ri umumat. ");
INSERT INTO hrw_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ma i ka war, “Ri seti aregii, ‘Kek fel eu ta fel una nining’, sakle gam sam gow ka la ta, ‘Male na keskeskum singre tongge na kinkinau.’” ");
INSERT INTO hrw_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Fam biing nano i e fafabenge ilo bala Felun Nining Bakir. Sakle fam pris lamlam, fan titsa lo fafanau ma ge lamlam una balre tongge a, ri toftofo una paketmet ini. ");
INSERT INTO hrw_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Safle ri tibi fasi una la sikseni e ti sal una gow e sangsang a, anwarow tongge nano ri bura tikin ini riu ongong lo fan warwar kia. ");
INSERT INTO hrw_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Lo neng e biing, biing Yesus e fafabenge singre tongge ulo bala balo lo Felun Nining Bakir, ma ka sesesngeni e konona sunwar, fam pris lamlam ma fan titsa lo fafanau ma ge lamlam ri ka tiin la usi, ");
INSERT INTO hrw_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ri ka la war, “Peteng tif kemem ini o gowgow e fan mok gii lo sese rawas? Ma se e tow e rawas gii tifo?” ");
INSERT INTO hrw_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ma i ka koso, “Yau gatom gau ming ine neng e gatgatom. Gau peteng tif yau, ");
INSERT INTO hrw_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Amfagu Tarawen ke Jon, e ta tinglo balambat, tam singe kaltu?” ");
INSERT INTO hrw_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ri fawar usi u falifu iri tibom, ri ka war, “Le kiar ku peteng ini ‘tinglo balambat,’ i eu gatom, ‘Gii ma e tamu gii gam ka tibi titinge lo?’ ");
INSERT INTO hrw_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ma le kiar ku peteng ini ‘singe kaltu,’ tongge nano riu rang kiar ine fatfat, anwarow ri titinge tikin ini Jon e ta profet.” ");
INSERT INTO hrw_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Iya ri ka koso aregii, “Kemem tibi parfat ini ting ya.” ");
INSERT INTO hrw_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ma Yesus ka war singri, “Yau ming yau tibi peteng tif gam ini sese rawas ya gowgow e fan mok gii lo.” ");
INSERT INTO hrw_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ma i ka war ka la ka seseng tifre tongge ine neng e warwar toftof ming. “Neng e kaltu e so e palang na waen kia ma ka towfu tifre tongge una efefe lo ma i ka la, ka la melmel u tapak. ");
INSERT INTO hrw_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Biing e matuk faim, i e tuleni e neng e kaltu na mus kia use re tongge a ri ka efefe lo ke palang, usi riu la tow e tom fa lo fam fingfingwan waen tinglo palang a tifi. Sakle tongge na efefe lo palang a, ri pakti ma ri ka tuleni ka la mil fofoes. ");
INSERT INTO hrw_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","I ka tuleni e neng ming, sakle neng a, ri pakti ma ri ka pete maiyai ini ma ri ka tuleni ka la mil fofoes. ");
INSERT INTO hrw_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Wimi i ka tuleni e neng baba e tuul ka la, sakle ri paket bero sekit ini ma ri ka bas suu ini. ");
INSERT INTO hrw_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Kala tamow e palang a ka war, ‘Ya ku tamu gii? Yau tuleni ngan e sikuang, se ya bura tikin. Ya sang ini riu la natkeni.’ ");
INSERT INTO hrw_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Sakle lo biing tongge a ri pari, ri fagon falifu iri tibom ri ka war, ‘Kaltu gii eu kepe e ninsiow e tamow, kerek paketmet ini ma ninsiow e tamow ku ta kiar.’ ");
INSERT INTO hrw_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Iya ri ka la bas suu ini tinglo palang ma ri ka la paketmet ini. “Sa gii tamow e palang na waen a ku subuk gow lo ri? ");
INSERT INTO hrw_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","I eu puek ku sa fis metmet ire tongge nano a ma ku tow e palang na waen a tifre fa kuriik.” Biing tongge ri ongni e mok gii, ri war, “Eu tibi fuut aiya!” ");
INSERT INTO hrw_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yesus ka par riis usi ri ma ka gatom, “A gii ma sese pimpiku e sunwar a ri kabuk seti: ‘Fat lewa tongge na bilbilse fam fel ri ka guuluung ini, e sau puek ka ta warow e fel’? ");
INSERT INTO hrw_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Se ri nano a ri ku luut ilo poktow e fat a, riu tapot fafalek. Ma se a fat gii ku luut talo, fat a eu sii mongmong ini.” ");
INSERT INTO hrw_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Wimi fam pris lamlam ma fan titsa lo fafanau ri ka sik ini ti sal una bingfamti saupe, anwarow ri parfat ini i e war ine warwar toftof gii lo ri. Sakle ri soke re tongge. ");
INSERT INTO hrw_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Fam pris lamlam ma fan titsa lo fafanau ri efe kausi tikin lo Yesus, gii ri ka tule re fa na parpar borong usi, sakle tongge a riu fafanas iri ini ri bura tikin ini riu ong lo fan warwar kia. Ri sangfi ini riu la ongni e ti ton sunwar Yesus eu gon ini, usi ini riu fasi una towfu ilo anganggon na mata e gapman bakir. ");
INSERT INTO hrw_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Tongge a ri ka gatmo, “Titsa, kemeu parfat ini o gon ma fabenge ine fan sa e riis. O tibi fasi una ti lo galu kere fa ma ini fa ku tam, sakle o fabenge ine sinang ke Deo ususi e sa e tikin. ");
INSERT INTO hrw_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","E riis ini kemem u bas mani tife Sisa, tam e tam?” ");
INSERT INTO hrw_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Yesus e par sikii sekit e sinsinanguri ma i ka war, ");
INSERT INTO hrw_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Fanangsi yau ine ti mani. Panta ma asow e se legii, ilo?” ");
INSERT INTO hrw_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ma ri ka koso, “Panta ma asow e Sisa.” I ka war singri, “Le ku ngo aiya, tow e sa ke Sisa, tife Sisa, ma sa ke Deo, tife Deo.” ");
INSERT INTO hrw_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ri tibi fasi una faliilngeni lo sa e sam war ini na mat fuun. Ma ri ka la kuuf singi e koso singri are gii, ka la tek borong sok lo ri. ");
INSERT INTO hrw_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Fan Sediusi ri ta tongge ri peteng ini e tek ti matmatet mil, fa lo ri, ri puek talo Yesus tura neng e gatgatom. ");
INSERT INTO hrw_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Ri ka sa gatmo aregii, “Titsa, Moses e siitufu tif kiar aregii, ‘Le ti kaltu ku met kosngi e ke wok ma ka tifik mel e siksikwaru, tualik e samusu tili e wok a, usi eu mel e siksikow e tualik.’ ");
INSERT INTO hrw_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","E mel e baba fis na fatualik, neng baba tikii e tili e neng e fefin ma ka su met kosngi ma ka tifik mel e siksikwaru. ");
INSERT INTO hrw_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Neng baba e u ka su gorot aiya ming. ");
INSERT INTO hrw_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Neng baba e tuul ming ka tili. Baba fis na fatualik nano a ri tiin tili e wok a ma ri nano, ri ka tiin famete kosngi, sakle e tek tikas lo ri ek fafuutngeni e ti sikow. ");
INSERT INTO hrw_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Wimi, wok ming a ka met. ");
INSERT INTO hrw_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Arik a, lo biing na matet mil, wok a ku ta ke se sekit lo ri a ma baba fis na fatualik a ri ka tiin tili e wok a?” ");
INSERT INTO hrw_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ma yesus ka koso, “Tongge lo biing gii ri tiin tinaule. ");
INSERT INTO hrw_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Sakle fa a Deo ka peteng ini ri fasi una matet mil ma una kiis tura wimi, ri amu tibi tinaule ");
INSERT INTO hrw_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","ma ri amu tibi met, le riu la ngo are fan anggelo. Iri ta fan siksikow e Deo, anwarow i e sau famtet familri. ");
INSERT INTO hrw_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Sakle Moses tibom e sau fanangsi ini tongge ri met riu matet mil. Anwarow lo sunwar lo iif ulo au, Moses e fotngi e Taufi ini ‘Deo ke Abra-am, ke Aisak ma ke Jekop.’ ");
INSERT INTO hrw_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","I e tibi ta Deo kere tongge ri met, e tam. I e ta Deo kere tongge ri liuliu, anwarow na mata e Deo, tongge nano ri liu.” ");
INSERT INTO hrw_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Fa lo re fan titsa lo fafanau ri ka war singi, “Titsa, o kos fakausi tikin.” ");
INSERT INTO hrw_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ma e am la tek tikas e au bura una mu gatmo ming, anwarow ri soke. ");
INSERT INTO hrw_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Wimi Yesus ka peteng tifri, “Are ini gii ri ka peteng ini Mesaiya e ta sikow e Dewit? ");
INSERT INTO hrw_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ma Dewit tibom e sau peteng malal aregii ilo buk Sam: ‘Deo e peteng tife Taufi kiang aregii, “Kiis wagii lo galu miil lo yau, ");
INSERT INTO hrw_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ku muut lo biing yau tauf re tongge na matamfais kiam ilo pikliu e rawas kiam.” ’ ");
INSERT INTO hrw_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Arik, areini gii Dewit kabuk bou fotngi e Mesaiya ini Taufi kia ma Mesaiya ku ta sikow?” ");
INSERT INTO hrw_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Biing tongge nano ri tiin ongong uwa, Yesus ka war singe fan disaipel kia aregii, ");
INSERT INTO hrw_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Ate kausi use re fan titsa lo fafanau. Ri su bur liflifit faliu tura konona fang kolos ma ri ka su isisa e fan male una umumat ini riu arare ri ilo ma ri ka su bur kiiskiis ilo fan sia i famu sekit lo fam felun nining ma ilo fam biing una gowgow e fan tiim bakir. ");
INSERT INTO hrw_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ri gurgurum ine fan makos ma ri ka kinkinow e fam fel keri ma ri ka ngar gowgow e fan nining taptapak tikin. Matang kaltu aiya riu kepe e singmat na ongker lo biing na anganggon.” ");
INSERT INTO hrw_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Biing Yesus e akte mata, i e pari e tongge tuba mel ri basbas fam finafen keri ulo bala sinatiim ke Felun Nining Bakir. ");
INSERT INTO hrw_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","I e pari ming e neng e wok makos sasngal e sa bas ine ke boron 2 toiya. ");
INSERT INTO hrw_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","I ka war, “Ya peteng tikin tif gam, wok makos sasngal gii, i e bas bakir tikin iyat ire tongge nano gii. ");
INSERT INTO hrw_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Tongge nano gii ri fafen ine borong galu lo fan tuba ri ma galu bakir ka ngosok, safle wok gii, i e fafen ine mara mok gii, i ku liu lo.” ");
INSERT INTO hrw_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Fa lo re fan disaipel kia, ri war talo fam finapite tinglo Felun Nining Bakir ini e fapete ine konona fam fatfat ma fam finafen ri fafen ini tife Deo, sakle Yesus e war, ");
INSERT INTO hrw_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Fan mok gii gam ka pari gii, e mu mel e biing eu puek, ma ku la tek ti fu lo ri eu la ngosok ilo poktow e ti neng e fu. Riu tias berbereng iri nano.” ");
INSERT INTO hrw_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ri ka gatmo, “Titsa, nangis fan mok gii eu fuut? Ma sa eu ta tintof una peteng fate ini fan mok gii e sau bala puek?” ");
INSERT INTO hrw_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","I ka koso, “Gam u ate are tikas ka gurum i gam. Anwarow fa fuunfuun riu puek lo asang ri ku peteng ini, ‘Yau gii Mesaiya,’ ma, ‘Biing e sau fatat.’ Mangena usi ri. ");
INSERT INTO hrw_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Biing gam u ong lo fan sinseng lo tuui ma fam fagorot falifu ire tongge tura gapman keri, gam u tibi soke, fan mok gii e samusu puek famu, safle biing muut eu tibi puek saupe.” ");
INSERT INTO hrw_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Kala ka war singri, “Nenge male eu fapaket tura neng e male, ma neng e matambia eu fapaket tura neng e matambia. ");
INSERT INTO hrw_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Eu mel e fanggi lamlam, biis faen, fan minse lamlam, ilo fanenger fan male ma fan mok una pete soksoke ire tongge, ma fan tintof lamlam tinglo balambat. ");
INSERT INTO hrw_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Sakle famu ine mara mok nano gii, riu bi bingfamti gam ma ri ku bero i gam. Riu tatfe gam wilo bala fam felun nining ma fam felun rerek, ma ri ku uun gam, ri ku la fetiuf gam i famu ire fang king ma fang gapman. Fan mok gii eu fuut, nafow e asang. ");
INSERT INTO hrw_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Mok gii eu fuut, usi ini eu ta sol kemi una sesngeni e konona sunwar tifri. ");
INSERT INTO hrw_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Safle famu ine fan mok a, gam u su balamas, usi ini gam u tibi sang kut, ini are gam u fakale lo gam. ");
INSERT INTO hrw_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Anwarow, yau tow e fan warwar ma atausimale tif gam usi ini eu tek tikas eu fasi una fasange singi ma una fatinge tura. ");
INSERT INTO hrw_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Tautaumi ma tintinmi, fan tualikmi, ge lo gam ma fenfenngomi riu solamuf gam, ma ri ku paketmet ire fa lo gam. ");
INSERT INTO hrw_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Tongge nano riu is gam, anwarow lo yau. ");
INSERT INTO hrw_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Sakle eu tek ti an sianolow e tikas lo gam tinglo paklu eu tam ini. ");
INSERT INTO hrw_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Gam samusu ti rawas, usi ini gam u kepe ninliu. ");
INSERT INTO hrw_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Biing gam u pari e fan soldia fuunfuun riu lifti e male ina Jerusalem, gam kamu parfat a, ini biing una bero ini e sau fatat. ");
INSERT INTO hrw_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Biing a, touf re tongge ri melmel ina Juda, ri ku fin ri ku la ilo fam pakpaklunmale. Touf re fa ilo bala siti ina Jerusalem ri ku suu ma fa ina male ine siti riu tibi kau. ");
INSERT INTO hrw_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Anwarow biing a, e ta biing Deo eu tow e fang kokos usi ini eu fasefu e fan mara warwar kia, lewa ri kabuk siitufu. ");
INSERT INTO hrw_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Kiskam singre gelefin tian ma fan tintinabo-i a siksikwari ka liklik iwa. Are riu gorot lo biing a! Eu mel e singmat na mafet ilo male ma balasak ke Deo usi re tongge gii. ");
INSERT INTO hrw_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Fa riu met singe ringgot ma fa ri ku un ri are fang karabus wilo an mara male. Fan Jentael riu pii ofofo e male ina Jerusalem ku muut lo fam biing kere fan Jentael eu fasef. ");
INSERT INTO hrw_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Eu mel e fan tintof ilo bala pisii, funiil ma fang keltot. Singmat na ongker eu ta ilo nal, ma ri ku sangfuunfuun singe dungow e panaf ma kirai ina kasap. ");
INSERT INTO hrw_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Tongge riu met pelpel singi riu sokeni e sa eu puek talo ri wagii lo nal, anwarow fan mok rawas tinglo batsok riu ban. ");
INSERT INTO hrw_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Lo biing a, riu pari e Sikow e Kaltu, eu puek ilo bala pam balbal tura rawas ma singmat na finaswen. ");
INSERT INTO hrw_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Biing fan mok gii eu tofnge puek, ti riis ma o ku par wiyat, anwarow biing una kepfamil gam e sau fatat.” ");
INSERT INTO hrw_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","I ka peteng tifri ine warwar toftof gii, “Par lo au fik ma mara kalut nano. ");
INSERT INTO hrw_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Biing riu dur, o tibom o fasi una pari ma o ku parfat ini biing lo pisii e sau fatat. ");
INSERT INTO hrw_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ilea, e su ngo ming aiya. Le o ku pari e fan mok gii eu fuut, o sau parfat ini kepmale ke Deo e sau fatat. ");
INSERT INTO hrw_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Ya peteng tikin tif gam, kulu gii, riu tibi famete ku muut lo fan mok gii eu fuut. ");
INSERT INTO hrw_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Batsok ma nal eu tam iru, sakle sunwar kiang eu tibi fasi sekit una tam ini. ");
INSERT INTO hrw_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Atate, are fan sinang una sangfoesngeni e melmel, sinang una bengbeng ma sinang una sangfuunfuun use fan mok wilo pinumfow e kaltu ka afit gam ma gam ku tibi parfat ma biing a ku fakuufnge gam are ano. ");
INSERT INTO hrw_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Anwarow biing a eu puek talo re tongge nano a ri ka melmel ilo nal kiruur gii. ");
INSERT INTO hrw_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Bingne gam samusu ate, ma nining usi ini titinge kemi eu kulfi e fan mok a ka rong una fuut, ma ini gam ku fasi una ti na mata e Sikow e Kaltu.” ");
INSERT INTO hrw_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Tikii neng, tikii neng e biing, Yesus e fafabenge ilo bala Felun Nining Bakir, ma lo fan efef i e lala ilo paklunmale Olif, ka la melmel ilo lo fam panambiing. ");
INSERT INTO hrw_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ma tongge nano ri pukpuki, una sa ongongne singi ilo bala Felun Nining Bakir. ");
INSERT INTO hrw_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Biing En Bakir lo Beret e tek ti Is ilo, (ri fotngi ini En na Kepsiliwi) e rong una puek, ");
INSERT INTO hrw_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","fam pris lamlam ma fan titsa lo fafanau ri soke re tongge, iya ri ka sik ine ti sal borong una bingfamti e Yesus una la paketmet ini. ");
INSERT INTO hrw_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Kala Satan ka sispi e Judas ri fotngi ming ini Iskariot. I e ta neng lo re tikii sangful ma e u na disaipel. ");
INSERT INTO hrw_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Judas ka la use re fam pris lamlam ma fam paklure fan efefe lo Felun Nining Bakir ka la fagati tura ri ini are, i eu solamufu e Yesus. ");
INSERT INTO hrw_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ri la terterer tikin ma ri ka a-uu una tow e mani tifi. ");
INSERT INTO hrw_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","I e a-uu lo sunwar keri ma i ka parpar ine ti sal una tow e Yesus ilo limlim ri, lo biing galung kaltu ri tam iri inaisa. ");
INSERT INTO hrw_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Biing En Bakir lo Beret e tek ti Is e puek, i e biing a ri ka sagisu pakpaketmet ine boron sipsip ari una en ma una sangfi e biing lo En na Kepsiliwi, ");
INSERT INTO hrw_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yesus e tuleni e Pita ma Jon ma ka war, “Kamuw la, kamu ku la fagati salu kiar una gow e En na Kepsiliwi.” ");
INSERT INTO hrw_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ru ka gatmo, “O bura ini kamau la terer salu kiar iya?” ");
INSERT INTO hrw_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","I ka koso, “Biing kamuw kau ilo bala siti, neng e kaltu e ufufu lala e botol na dan eu tupnge kamu. Kamuw usi ku la ilo bala fel a, i ku la kaulek ilo bala, ");
INSERT INTO hrw_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ma kamu ku peteng tife tamow e fel a aregii, ‘Titsa e gatom: Iya e keptim fel gii, ya ku fasi una eni e En na Kepsiliwi tiim tura fan disaipel kiang ilo?’ ");
INSERT INTO hrw_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","I eu fanangsi kamu ine neng e keptim fel bakir iyat, ine mara mok ilo bala ri sau fagatiufu. Wa, kamuw la fagati e fan tuan ilo.” ");
INSERT INTO hrw_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Biing ru la, ru pari e fan mara mok e su ngo aregii Yesus kabuk peteng tif ru ini, iya ru ka fagatiufu e fan tuan wilo En na Kepsiliwi ulo. ");
INSERT INTO hrw_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Biing anmatam pisii e sau puek, Yesus tura fan disaipel kia ri la kiis liflifti e teibel. ");
INSERT INTO hrw_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ma i ka war singri, “Ya bura tikin ini famu ma ya kamu kepe ongker yau bi eni e En na Kepsiliwi gii tura gam, ");
INSERT INTO hrw_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","anwarow ya peteng tif gam, ya mu tibi eni mil e en gii, ku muut lo biing En tikin eu puek ilo bala kepmale ke Deo.” ");
INSERT INTO hrw_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Wimi ka kepe e kap ka katfarsi e Deo ma ka war, “Kepe, gam ku faseni falifu i gam. ");
INSERT INTO hrw_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Anwarow, ya peteng tif gam, ya mu tibi in waen mil, ku muut lo biing kepmale ke Deo eu puek.” ");
INSERT INTO hrw_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ma i ka kepe e beret ka katfarsi e Deo lo, ka paek papaki, ka tow tifri ma ka war, “Igii e fong ya tow usi gam; gow aregii una sangsagif famil yau.” ");
INSERT INTO hrw_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Lo tikii sal, wimi ini ri sam en tikii, i e kepe e kap ma ka war, “Igii e kap, e ta war a-uu fuu ilo bala andakung, iya ka lingiuf usi gam. ");
INSERT INTO hrw_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Sakle limow e kaltu a ku solamuf yau, e ta igii ilo teibel, tiim tura limang. ");
INSERT INTO hrw_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Sikow e Kaltu eu la aregii Deo kabuk fagati, sakle kiskam singe kaltu a ku solamufu.” ");
INSERT INTO hrw_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ri ka tofnge una fagatomnge faliu iri tibom ini e ta se sekit lo ri eu gorot aiya. ");
INSERT INTO hrw_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ming, neng e fagorot ka matet u falifu iri ini se lo ri, e bakir iyat ire fa. ");
INSERT INTO hrw_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yesus ka war singri aregii, “Fang king kere fan Jentael, ri akakte ri tibom ma ri ka parparpu ire fa; ma ge lamlam keri, ri bou foteng ri tibom ini ‘fatfatfenngo na faules.’ ");
INSERT INTO hrw_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Safle gam, gam u tibi gorot aiya. Gam u su gorot aregii; se a ka bakir ina balmi, e samusu faporo e i tibom, ma se a ka ta kaltu bakir kemi, i e samusu faim are kaltu na faim faules kemi. ");
INSERT INTO hrw_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Anwarow se e bakir? Kaltu a ka kiis una en tam kaltu a ka tuutuung? Se a ka bakir e ta kaltu a ka kiis una en. Sakle yau, ya faim falifu i gam, are kaltu na faim faules. ");
INSERT INTO hrw_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Gam sau melmel tura yau lo fan mara biing fam fatof e pupuek talo yau. ");
INSERT INTO hrw_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","E su ngo aregii Tabuung ka tow e rawas ma miang una efe ilo bala kepmale, yau ming, yau tow e rawas ma mia mi una efe ilo bala kepmale, ");
INSERT INTO hrw_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","usi ini gam u en ma in ilo kepmale kiang ma gam ku kiis ilo konona fan sia ma gam ku efe lo tikii sangful ma e u na matambia tingna Israel.” ");
INSERT INTO hrw_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yesus ka war aregii, “Saimon, Saimon. Satan e sam kepe e war a-uu una tofo e titinge kemi are tongge ri sageufu e fam piin tinglo fan wit. ");
INSERT INTO hrw_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Sakle Saimon, o, ya sam nining ini titinge kiam eu tibi luut. Ma biing o sam didiu mil usi yau, o samusu faraungeni e tanga tuamlik.” ");
INSERT INTO hrw_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Sakle Pita e koso, “Taufi, ya su nene una la tura o ilo karabus ma una met tiim tura o.” ");
INSERT INTO hrw_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yesus ka koso, “Pita, ya peteng tifo, geinggii, famu ine porot ma ku teng, ou fatuul peteng ini o tibi parfat lo yau.” ");
INSERT INTO hrw_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Wimi Yesus ka gatom ri, “Biing ya tule gam una la sesngeni e Konona Sunwar ma gam ka tibi sele fam poket, tam fam bek tam ti ton su ke mi, gau pospos ming lo ti mok, tam e tam?” Ma ri ka koso, “E tam.” ");
INSERT INTO hrw_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","I ka war singri, “Sakle gii, le ku mel e kem ti poket, tam ti bek, kepe ming, ma le ku tek kem ti bainat, umat ine kem kolos tapak ma o ku feli e kem ti iri. ");
INSERT INTO hrw_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ri sam siitufu aregii, ‘Ri wes tiim ini ming tura re tongge na tumtubiil.’ Ma ya peteng tif gam ini fan mara mok gii e samusu fuut lo yau. Yow, fan mara mok fam profet ri sam seti lo yau e sau puek e bengu una fabonti.” ");
INSERT INTO hrw_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Fan disaipel ri ka war, “Taufi, par, e u e bainat gii.” Yesus ka koso, “E sam ta ilea.” ");
INSERT INTO hrw_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesus ka la kanek ulo paklunmale Olif aregii ka sagisu gowgow, ma fan disaipel kia ri ka minami. ");
INSERT INTO hrw_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Biing ri la fespuek, i e war singri, “Gam u nining usi ini gam u tibi luut lo falam.” ");
INSERT INTO hrw_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","I ka fes ka la u tapak balik are fumfat ri bas ini, ka la kiis pukungkek ma ka nining, ");
INSERT INTO hrw_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Tabuung le o ku fabur, tii ine kap gii kosing yau, sakle ou tibi usi e fabur kiang, ou usi e fabur kiam tibom.” ");
INSERT INTO hrw_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Nenge anggelo tinglo balambat ka puek talo, ka sa faraungeni. ");
INSERT INTO hrw_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yesus e ongni ini fow e mafet tikin gii ka nining rawas tikin ma songsongow ka puek are dadak ma ka riring pu talo nal. ");
INSERT INTO hrw_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Biing i e sam nining tikii, i e ti ma ka la mil usi re fan disaipel kia ka la pari ini ri masun, le ri sang kuuluung tikin. ");
INSERT INTO hrw_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","I ka fongen ri ma ka gatom ri, “E tamu gam ka masun? Matet gam ku nining usi gam u tibi luut singe falam.” ");
INSERT INTO hrw_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Biing i e gongon uwa, neng e galung kaltu ri ka sa puek, ma kaltu ri fotngi ini Judas e ta neng lo re tikii sangful ma e u na disaipel, i e famu puek iri. I e sa la sekit use Yesus una sa osngi, ");
INSERT INTO hrw_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","sakle Yesus e gatmo, “Judas, o bala solamufu e Sikow e Kaltu ine faoseng, be?” ");
INSERT INTO hrw_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Biing fan disaipel ke Yesus ri pari e mok e bala fuut ri ka gatom, “Taufi, e fasi ini kemem u fapaket ine fam bainat kemem?” ");
INSERT INTO hrw_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ma neng lo ri ka sapingufu e ambalbalu miil e kaltu na mus ke paklure fam pris. ");
INSERT INTO hrw_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Sakle Yesus e war, “Mele am gow ming e sinang gii.” Ma i ka puse lo ambalbalu e kaltu na mus a ma ka fasko mil. ");
INSERT INTO hrw_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Wimi Yesus ka war singre fam pris lamlam, tongge na famu kere fan efefe lo Felun Nining Bakir ma tongge lamlam, seri gii ri ka sa la usi, “E tamu, ya famfamu ire ti galung kaltu una gowgow e fan sinang saksak, gii gam ka sa la usi yau tura fam bainat ma fang kepsil? ");
INSERT INTO hrw_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Mara biing ya melmel tura gam ulo bala Felun Nining Bakir ma gam tibi tow e ti liumi ulo yau, sakle gii e ta biing kemi biing ke anor una fakulef.” ");
INSERT INTO hrw_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Kala ri ka bingfamti ma ri ka onu ka la ulo bala fel ke paklure fam pris ma Pita ka ususi ri lala. I e su fesfes lala u tapak balik i ri. ");
INSERT INTO hrw_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Sakle biing fa lo ri, ri gow e iif ulo falifu lo pakanmale lo fel a ma ri ka fakiisnge liflifti, Pita ming e sa kiis tura ri. ");
INSERT INTO hrw_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Nenge fefin na faim ka pari e Pita lo anten lo iif e kiiskiis. I ka iliim fakausi ma ka war, “Kaltu gii e ta i ming tura.” ");
INSERT INTO hrw_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Sakle Pita e gurum kakali ma ka war, “Tiner, ya tibi parfat lo.” ");
INSERT INTO hrw_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Wimi balik neng e kaltu kuriik ka pari ma ka war, “O ming, o ta neng lo ri.” Pita ka koso, “Kaltu, yau e tam.” ");
INSERT INTO hrw_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Kala, are tikii awa wimi, neng e kaltu ka war talo ming, “Tikin, tikin, kaltu gii e ta i ming tura, le i e ta kaltu tingna Galili.” ");
INSERT INTO hrw_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Sakle Pita e war, “Kaltu, ya tibi parfat lo sa o seseng ini.” Ma lo sum biing sekit a, i ka warwar, porot e teng. ");
INSERT INTO hrw_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Lo biing a, Taufi e giliim ka alal sekit lo Pita. Kala Pita ka la sangfi mil e sunwar ke Taufi: “Geinggii na panambiing, famu ine porot ma ku teng, ou fatuul gurum ini o tibi parfat lo yau.” ");
INSERT INTO hrw_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Pita ka la kosing ri ka suu una male ine fel a ka la tengteng kaukaung. ");
INSERT INTO hrw_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Tongge a ri ka efefe lo Yesus, ri tofnge una tumaru ma una pakti. ");
INSERT INTO hrw_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ri ka fis kali e wan mata ine sun laplap ma ri ka gatmo aregii, “Peteng tif kemem! Se gii ka pose o?” ");
INSERT INTO hrw_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ma ri ka gow e fanenger fan warwar saksak ming talo. ");
INSERT INTO hrw_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Biing pisii e fen, ge lamlam, tiim tura fam pris lamlam ma fan titsa lo fafanau ri tiim lo ri, ma fan efefe ri ka onu e Yesus ri ka sa fetiufu u famu iri, ");
INSERT INTO hrw_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","ma ri ka war, “Le ku ta o na Mesaiya, o ku peteng tif kemem a.” Sakle Yesus e koso singri aregii, “Le ya ku peteng tif gam, gam tibi fasi una titinge sing yau. ");
INSERT INTO hrw_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ma le ya ku gatom gam ine ti gatgatom, gam tibi fasi una koso. ");
INSERT INTO hrw_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Sakle tofnge ting geinggii ma ku la, Sikow e Kaltu eu la kiis ilo galu miil lo Deo, se e rawas iyat sekit.” ");
INSERT INTO hrw_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ri nano ri ka tiin gatmo, “O na Sikow e Deo, be?” Yesus ka koso singri aregii, “Sunwar kemi e riis ini ya na Sikow e Deo.” ");
INSERT INTO hrw_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Kala ri ka war, “Usi e tamu gii kiar ku bi fauun usi re ti fa una sa peteng ine ti ton sinseng ming? Kiar tibom, kiar sau bom ongni riis tinglo ngusu.” ");
INSERT INTO hrw_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Kala tongge nano a ri ka tiim lo ri, ri tiin matet ma ri ka onu e Yesus ri ka la tow tife Pailat. ");
INSERT INTO hrw_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ri ka tofnge una otngi ri ka war aregii, “Kemem sam sikseni ini kaltu gii e sau pete taltal falek ire tongge nano kemem ma e tibi a-uu lo kemem ini kemem u bas mani tife Sisa ma i ka bou peteng ini i na Mesaiya, i e ta neng e King.” ");
INSERT INTO hrw_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Iya Pailat ka gatmo e Yesus, “O ta King kere fan Juda?” Yesus ka koso, “Yow, e su ngo are lea o ka war.” ");
INSERT INTO hrw_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Wimi Pailat ka peteng tifre fam pris lamlam ma tifre tongge nano a aregii, “Ya tibi sikseni e ti anwarow gii ini ya ku tafu e kaltu gii ilo anganggon.” ");
INSERT INTO hrw_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Sakle ri tiin war rawas aregii, “I e pete taltal falek ire tongge tingna Judia ine fam fabenge kia. I e tofnge tingna Galili ka sa la ka sa muut sekit gii.” ");
INSERT INTO hrw_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Lo biing Pailat e ong aiya, i ka gatom, “Kaltu gii e ta tingna Galili?” ");
INSERT INTO hrw_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Biing Pailat e sau parfat ini Yesus e ta tinglo galu gii Erot ka efe lo, i ka tuleni e Yesus use Erot, anwarow Erot ming e ta una Jerusalem lo biing a. ");
INSERT INTO hrw_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Biing Erot ka pari e Yesus, i e fefeal tikin, le e sau bura una pari ting wa, anwarow i e sam ongong lo fan sinseng fuunfuun lo ma ka bura ini eu par ma Yesus ku gow e ti ton mok na tibou fuut. ");
INSERT INTO hrw_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Erot e gatmo e Yesus ine fang gatgatom fuunfuun, sakle Yesus e tibi koso e ti sunwar. ");
INSERT INTO hrw_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Fam pris lamlam ma fan titsa lo fafanau ri fafatie ming uwa, ri ka ototngi e Yesus ine fan warwar rawas tikin. ");
INSERT INTO hrw_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Wimi Erot tura fan soldia kia ri ka ruur lo ma ri ka tumaru. Ri ka faloski ine kolos ke king ma ri ka tule famila use Pailat. ");
INSERT INTO hrw_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Lo biing a, Erot ma Pailat ru la fatfenngo, safle famu ini e mok gii, ru fafais iru. ");
INSERT INTO hrw_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pailat ka tau tiim ire fam pris lamlam, ge lamlam kere fan Juda, tura re tongge, ");
INSERT INTO hrw_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ma ka war singri aregii, “Gam sa tow e kaltu gii tif yau are kaltu una famfamtete e fam fapaket i falifu i re tongge. Ya sam gatom ikikseni na matmi ma ya ka tibi sikseni e ti tubiil kia ususi e fam faoteng kemi. ");
INSERT INTO hrw_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Erot ming e tibi sikseni e ti tubiil kia ususi e fam faoteng kemi, iya i ka tule famila usi kiar. Aregii gam kabuk pari, kaltu gii e tibi gow e ti tubiil ku fasi ini eu met somu. ");
INSERT INTO hrw_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Iya, ya ku su fabu-i aiya ma ya ku towfu ku la.” ");
INSERT INTO hrw_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Safle ri nano ri tiin tau aregii, “Paketmet ini e kaltu a, ma o ku pikufu e Barabas tif kemem!” ");
INSERT INTO hrw_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Ri towfu e Barabas ulo rerek anwarow i e famu ine galung kaltu ri ka fapaket tura gapman ulo bala siti ma i ka pakpaketmet ire tongge.) ");
INSERT INTO hrw_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pailat e bura ini eu towfu e Yesus ku la, gii ka gatom ri mil usi. ");
INSERT INTO hrw_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Sakle uwa, ri su tautau, “Tut famti lo aupaket! Tut famti lo aupaket!” ");
INSERT INTO hrw_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","I ka war baba e tuul singri. “Anwarow lo sa? Sese tubiil kaltu gii e sam gow? Ya tibi sikseni e ti tubiil ilo ini ku fasi lo ini eu met somu. Iya, ya ku su fabu-i aiya ma ya ku towfu ku la.” ");
INSERT INTO hrw_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Sakle ri tautau na kokor ini i e samusu met lo aupaket, ma fang kaung keri ka kulfi e sunwar ke Pailat. ");
INSERT INTO hrw_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Iya Pailat ka fagati ini i eu usi e fabur keri. ");
INSERT INTO hrw_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","I e pikufu e kaltu ri gatom usi, kaltu lewa ri ka towfu ulo rerek nafow i e fapaket tura gapman ma ka pakpaketmet ire tongge. Ma Pailat ka usi e fabur keri, ka tow e Yesus tifre fan soldia una paketmet ini. ");
INSERT INTO hrw_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Biing ri onu ka la, ri biing famti e Saimon tingna Sairini, i e fesfes lala una kau ilo bala siti, ri towfu e aupaket ulo pasow ma ka kepe ka minami e Yesus. ");
INSERT INTO hrw_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Singmat na galung kaltu ri usi lala, u falifu iri, e mel ming e gelefin ri tengsi iya ri ka fafatengse lala. ");
INSERT INTO hrw_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yesus ka giliim usi ri ma ka war, “Gelefin tingna Jerusalem, gam u tibi teng usi yau, gam u teng usi gam tibom ma usi e siksikuami. ");
INSERT INTO hrw_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Le e mu mel e biing na onker e mu puek ma gam ku war aregii, ‘Fefeal seri na gelefin a ri ka pom ma seri a ri ka tifik fasus ma seri a ri ka tifik fasusa e ti bo-i.’ ");
INSERT INTO hrw_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Wimi ‘ri amu war singre fam pakpaklunmale, “Luut talo kemem” ma fan tinwen, “Afit kemem!” ’ ");
INSERT INTO hrw_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Anwarow le tongge ri ku gow e fan matan mok aregii lo biing kalut e liuliu iwa, sa gii ku fuut lo biing kalut a eu mang?” ");
INSERT INTO hrw_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","E u ming, e ung kaltu na gowgow e fan sinang saksak, ri uun ru tiim tura Yesus, una la paketmet iru. ");
INSERT INTO hrw_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Biing ri la puek ulo male ri fotngi ini Antuampaklung Kaltu, uwa ri ka tutfamti ulo aupaket tiim tura ung kaltu a, neng ulo galu miil ma neng ulo galu kais. ");
INSERT INTO hrw_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yesus ka war, “Tabuung, sangintafngi e fan tubiil keri, anwarow ri tibi parfat lo sa ri gow.” Ma ri ka pilai satu una faseni e fang kolos kia lo ri tibom. ");
INSERT INTO hrw_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Tongge fuunfuun ri fafatie ri ka alalal ma ge lamlam keri, ri ka su ruuruur lo, ma ri ka war. “I e faliungere fa; towfu ku bou faliungeni tibom, le ku ta i na Mesaiya ke Deo, se Deo e sam wele.” ");
INSERT INTO hrw_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Fan soldia ming ri puek ri ka sa tumaru ma ri ka tow e waen gin tifi, ");
INSERT INTO hrw_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ma ri ka war, “Le ku ta ini o na king kere fan Juda, faliunge o tibom.” ");
INSERT INTO hrw_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","E mel e sunwar ri seti uiyat ini, wewes lo e ngo aregii, “KALTU GII, E TA KING KE RE FAN JUDA.” ");
INSERT INTO hrw_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Neng lo re ung kaltu a ka kulkulik unaisa ka tumaru aregii, “E tibi ta ini o na Mesaiya? Arik, faliunge o tibom, tiim tura kama!” ");
INSERT INTO hrw_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Sakle neng lo ru e porow, ma ka war, “O tibi sokeni e Deo, le e ta o ilo bala tikii mafet? ");
INSERT INTO hrw_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Kara kepe e mafet ususi e fan sinang kara gow. E riis. Sakle kaltu gii, i e tibi gow e ti tubiil.” ");
INSERT INTO hrw_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Wimi i kam war, “Yesus, biing ou kaulek ilo bala kepmale kiam, ou sagif yau.” ");
INSERT INTO hrw_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesus ka koso singi, “Ya peteng tikin tifo, geinggii ou ta tura yau ilo paradaes.” ");
INSERT INTO hrw_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Gii, e ngo are 12 kilok lo siat tuntun ma anor ka afti e nal kiruur ka la muut lo 3 kilok lo efef, ");
INSERT INTO hrw_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","le pisii e am tibi pal. Ma laplap bakir gii ka kep paki e Felun Nining Bakir ka rages ka u lo. ");
INSERT INTO hrw_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yesus e tau bakir tikin aregii, “Tabuung, ya towfu e tangwang ilo limam.” Biing i e sam war tikii aregii, i e sekpaket manangia. ");
INSERT INTO hrw_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Kaltu bakir kere fan soldia e pari e sa e sau fuut, i ka katfarsi e Deo ma ka war, “E tikin, kaltu gii e ta kaltu riis sekit.” ");
INSERT INTO hrw_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Biing tongge nano gii ri ka puek una sa par lo sa eu fuut, ri pari e fan mok e fuut, ri ka pakti e usus ri ma ri ka la. ");
INSERT INTO hrw_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Sakle tongge a ri ka parfat lo, tiim tura re gelefin gii ri kabuk ususi lala tingna Galili, ri fafatie u tapak balik ri ka alalal lo fan mok gii ma ka fuut. ");
INSERT INTO hrw_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Uwa, e mel e neng e kaltu asow gii Josef. I e ta neng lo re fang kaonsiil ma i e ta konona kaltu riis, ");
INSERT INTO hrw_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","i e tibi a-uu lo fam fagati ma fan mok fa lo ri, ri gowgow. I e puek tingna Judia tinglo taon Arimatia, ma i e nene una pari e kepmale ke Deo. ");
INSERT INTO hrw_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","I e la use Pailat ka la gatom use pinumfow e Yesus. ");
INSERT INTO hrw_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Wimi i ka kepu ini, ka afti ine fan laplap ma ka towfu ulo balang kenit ri pesi ulo fam ma e tifik tek ti minet rik sam towfu ulo. ");
INSERT INTO hrw_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","E ta biing una fagati ri use Biing Sabat, le e sam rong una tofnge. ");
INSERT INTO hrw_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Gelefin gii ri ka usi lala e Yesus tingna Galili, ri minami e Josef ka la ulo balang kenit, ri ka la par ini are ri fangongi e pinumfow e Yesus ulo bala ");
INSERT INTO hrw_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","ma wimi ri ka la mil ulo male ri ka la fagati e fan sanda ma fan wel e mel e konona sanow. Safle ususi e fafanau, ri manau lo biing usi, le e ta Biing Sabat. ");
INSERT INTO hrw_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Lo biing baba tikii lo wik, biingbiing e mok tikin, gelefin a ri kepe e fan wel ma sanda e mel e konona sanow lewa ri kabuk fagatiufu, ri ka la tura wilo balang kenit. ");
INSERT INTO hrw_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ri ka pari ini fumfat ulo matow e balang kenit a, ri sau liitufu, ");
INSERT INTO hrw_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","safle biing ri kaulek, ri tibi sikseni e pinumfow e Taufi Yesus. ");
INSERT INTO hrw_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Biing ri niil na sangsang use mok gii, saupesak ung kaltu ru los lo fang kolos e furfurat are ampil, ru sa ti unais ri. ");
INSERT INTO hrw_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Gelefin a ri soke tikin, gii ri ka por ri ka parpu use nal, safle ung kaltu a ru war singri aregii, “Usi e tamu gam ka sa sik ine kaltu e sam liu ina balre fan minet? ");
INSERT INTO hrw_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","I e tam ini gii; i e sau matet mil! Gam sang mil ini are i e peteng tif gam, lo biing i e ta uwa tura gam una Galili: ");
INSERT INTO hrw_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Sikow e Kaltu, ri samusu tow ilo limre tongge na tumtubiil, ri ku tut famti ilo aupaket ma lo biing baba e tuul, i eu matet mil.’” ");
INSERT INTO hrw_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Iya, ri kam sagif famila mil e fan warwar kia. ");
INSERT INTO hrw_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Biing ri mil tinglo balang kenit, ri sa seseng ine mara mok gii tifre tikii sangful ma e tikii na disaipel ma tifre fanenger fan tongge ming. ");
INSERT INTO hrw_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Maria Makdalen, Joana, Maria tinow e Jeims, ma fanenger fang gelefin ming tura ri, iri lea ri seseng ine fan mok gii tifre fan apostel. ");
INSERT INTO hrw_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Safle fan apostel ri tibi titinge singre gelefin a, anwarow ri sangfi ini fan warwar kere gelefin a, e su ta fan warwar na lomba. ");
INSERT INTO hrw_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Safle Pita e matet ka filau ka la ulo balang kenit. Biing i e la kwau, i e pari e safle fan laplap e la ngosok ma i ka la mil ma ka sangsang fuunfuun lala use sa e sau fuut. ");
INSERT INTO hrw_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Lo biing a, un neng lo ri, ru fes lala ulo sal una la ilo neng e taon ri fotngi ini Emaus. Male a e tapak tikin ine male ina Jerusalem, e ngo are tikii sangful ma e tikii na kilomita. ");
INSERT INTO hrw_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ru fafawar lala iru tibom use fan mara mok e sau fuut. ");
INSERT INTO hrw_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Biing ru fafagon lala ma ru ka basbas lala ine fan sangsang ke ru, u falifu iru tibom use fan sa e sau fuut, Yesus tibom e puek, ka sa fes lala tura ru. ");
INSERT INTO hrw_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ru pari safle Deo e kaleni e matmatru, gii ru ka tibi ilmi. ");
INSERT INTO hrw_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yesus ka gatom ru, “Kamu seseng lala ine sa biing kamu fesfes lala?” Ru la ti borong sok ma matmat ru ka fanangsi ini ru sang kuuluung tikin. ");
INSERT INTO hrw_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Neng lo ru, asow gii Kleofas ka gatmo, “O am su puek gii o ka tibi parfat lo fan mok e sau fuut leii na Jerusalem lo bala fam biing gii?” ");
INSERT INTO hrw_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ma Yesus ka gatom ru, “Sese fan mok?” Ma ru ka koso, “Fan mok e fuut lo Yesus tingna Nasaret. I e ta profet, ma i e warwar ine fan warwar rawas ma e gowgow e fam faim rawas na mata e Deo ma na matre tongge nano. ");
INSERT INTO hrw_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Fam pris lamlam ma ge lamlam kerer ri tow ulo limow e gapman, gapman ka anganggon singi, ma ri kam tut famti ulo aupaket; ");
INSERT INTO hrw_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","safle kemem, kemem sam titinge ini i e ta kaltu una kepfamil re fan Israel. Ma neng e mok ming: Geinggii e ta biing baba e tuul, wimi ine fan mok gii e sau fuut. ");
INSERT INTO hrw_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Su ming, fa lo re gelefin kemem, ri pete sangfuunfuun i kemem. Geinggii lo biingbiing e mok tikin, ri la ulo balang kenit, ");
INSERT INTO hrw_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","safle ri tibi la pari e pinumfow. Ri mil ri ka sa seseng tif kemem ini ri pari e fan anggelo, ma fan anggelo ri ka peteng tifri ini Yesus e sau matet mil. ");
INSERT INTO hrw_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Kala fa lo re fan taltalumem ri ka la ulo balang kenit ma ri ka la sikseni aregii gelefin a ri kabuk sa seseng, safle i, ri tibi pari.” ");
INSERT INTO hrw_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ma Yesus ka war singru aregii, “Sinsinangumu e tibi ten ma balbalmu e tibi matet saupe una titinge lo fan warwar fam profet ri sam sesngeni! ");
INSERT INTO hrw_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Are ini, e tibi fasi ini Mesaiya e samusu kepe fan ongker gii, ma wimi kamu kaulek ilo bala ke finaswen?” ");
INSERT INTO hrw_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ma i ka fatenu tif ru, tofnge tinglo Moses ma fan mara profet, e fan sa ri sau peteng ini ulo bala sunwar pepe, lo i tibom. ");
INSERT INTO hrw_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Biing ri tuul rong una puek ulo sun male gii ru ka lala wilo, Yesus e gorot aregii ini i e bala la sekit. ");
INSERT INTO hrw_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Sakle ru war rawas singi, “Melmel tura kama le e sau bala efef. E sau fatat ma anor ku luut.” Iya i ka kaulek ulo bala fel una la melmel tura ru. ");
INSERT INTO hrw_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Biing i e sam ta ulo teibel tura ru, i e kepe e beret, tow e katfariis tife Deo ka paekpaki ma ka tofnge una fen ru ini. ");
INSERT INTO hrw_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Kala matmat ru ka la ipiik ma ru ka ilmi ini i, Yesus, ma i ka tam fofoesngeni na matru. ");
INSERT INTO hrw_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ru ka fagatomnge iru tibom, “E tikin, balbalra e matet saupe tikin, biing i e gongon lala tura kara ulo sal, ma ka pikii e bala e fan sunwar pepe tif kara.” ");
INSERT INTO hrw_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Saupesak, ru matet, ru ka la mil una Jerusalem. Uwa ru la tongeni e tikii sangful ma e tikii na disaipel tura fa gii ri ka ta tura ri, ri tiimtiim lo ri. ");
INSERT INTO hrw_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ri ka war singru, “E tikin! Taufi e sau matet ma i e sau puek talo Saimon.” ");
INSERT INTO hrw_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Wimi ru kam seseng ine sa e fuut lo ru ulo sal ma are ru am ilmi e Yesus lo biing e paekpaki e beret. ");
INSERT INTO hrw_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Biing ri niil na fafagon use fan mok gii, Yesus tibom e sa ti u falifu iri ma ka war singri, “Balamaris tif gam.” ");
INSERT INTO hrw_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ri wi ma ri soke, anwarow ri sangfi ini ri pari e kenit. ");
INSERT INTO hrw_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Yesus ka war singri, “Usi e tamu gam ka soke ma gam ka sang fa-u? ");
INSERT INTO hrw_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Par wagii lo un limang ma ung kekeng. Yau legii! Gau pot lo yau ma gam ku par; kenit e tek ti piramfow ma tutuow, aregii gam ka pari, e mel ilo yau.” ");
INSERT INTO hrw_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","I e war aiya ma ka fanangsi ri ine un limow ma ung kekow. ");
INSERT INTO hrw_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ma biing ri uwa ri tifik titinge, anwarow ri gasgas ma ri ka sangfuunfuun, i e gatom ri, “E mel e ti tuan gii?” ");
INSERT INTO hrw_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ma ri ka tow e sum fis ri pisi tifi, ");
INSERT INTO hrw_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","i ka kepe, ka eni na matri. ");
INSERT INTO hrw_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","I ka war singri, “I legii e sa ya sau peteng ini tif gam lo fam biing e ta yau uwa tura gam: Fan mara mok gii ri kabuk seti lo yau ilo bala fafanau ke Moses, ilo bala fam buk kere fam Profet ma ilo bala buk Sams, e samusu fawet.” ");
INSERT INTO hrw_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Wimi i kau pete ten ine sinsinangu ri, usi ini riu ten use sunwar pepe. ");
INSERT INTO hrw_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","I ka peteng tifri, “Igii e sa ri seti: Mesaiya e samusu kepe ongker ma ku matet mil kosnge minet lo biing baba e tuul. ");
INSERT INTO hrw_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ma sinang una sangikis ma una sangintafngi e fan tubiil, ri ku sesngeni lo asow tifre fan mara male, tofnge tingna Jerusalem. ");
INSERT INTO hrw_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Gam sau bou pari e fan mok gii ma gam u sesngeni e sunwar lo. ");
INSERT INTO hrw_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Yau la tuleni e sa Tabuung e sam limlim ini usi gam, safle gam u su melmel ilo bala siti, ku muut rawas ting uiyat eu afit gam kiruur.” ");
INSERT INTO hrw_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Wimi i ka famu iri, ri ka la una Betani. Uwa, i e akteni e limow ma ka warfakausi ri. ");
INSERT INTO hrw_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Biing i e warwar fakausi ri, i e la kosing ri ma Deo ka kep kanek ini wilo balambat. ");
INSERT INTO hrw_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Wimi ri ka nining lo ma ri ka la mil wina Jerusalem tura singmat na gasgas. ");
INSERT INTO hrw_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Lo an mara biing, ri la melmel ulo bala Felun Nining Bakir, ri ka nining lo Deo. ");
INSERT INTO hrw_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Famu ine mara mok, Sunwar e sau melmel. Ma i e Sunwar e sau melmel tura Deo. Ma Sunwar tibom, i na Deo. ");
INSERT INTO hrw_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ma i e Sunwar e sam ta wa tura Deo, famu ine mara mok. ");
INSERT INTO hrw_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Lo i e Sunwar gii, Deo e gow e fan mara mok nano. Ma e tek ti mok ek fuut lo neng e sal, e tam. Fan mara mok e fuut lo Sunwar tibom. ");
INSERT INTO hrw_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Sunwar e ta anwarow e ninliu, ma lo ninliu a, i e tow e anten tifre tongge. ");
INSERT INTO hrw_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Anten e furat ilo anor, safle anor gii, e tibi raw una afti. ");
INSERT INTO hrw_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Igii e kaltu, Deo e tuleni, asow gii Jon. ");
INSERT INTO hrw_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","I e puek una sesuupuek ine Anten usi tongge nano riu ongni ma ri ku titinge. ");
INSERT INTO hrw_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Jon tibom e tibi ta Anten gii. I e fespuek una sesuupuek ine Anten. ");
INSERT INTO hrw_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Igii e Anten tikin, i e fespuek gii lo nal una tow e anten tifre tongge nano. ");
INSERT INTO hrw_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Sunwar e melmel ulo nal. Ma tikin lo, Deo i e fafuutngeni e nal ine Sunwar, safle tongge gii lo nal ri tibi parfailmi. ");
INSERT INTO hrw_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","I e puek ulo anwaran male kia, safle tongge kia, ri tibi a-uu lo. ");
INSERT INTO hrw_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Safle seri a ri ka a-uu lo, ma ri ka titinge lo asow, i kam war a-uu lo ri una ta fan siksikow e Deo. ");
INSERT INTO hrw_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ri fuut, e tibi ta lo ninis na tinaule, tam lo fabur ke tamat, safle ri fuut lo fabur ke Deo. ");
INSERT INTO hrw_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ma sunwar ka puek ka ta kaltu ma ka melmel falifu i kiar. Kemem sau pari e finaswen ke tikii tingkat na Sikow tibom. I e la tingnaisa e Tamow, ma e fuunuf ine warfakausi ma sinang e tikin. ");
INSERT INTO hrw_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jon e peteng malal ine sunwar gii. I e tau aregii, “Igii e kaltu lewa ya ka peteng tif gam ini aregii, ‘I eu puek wimi yau, rawas kia e kulfi e rawas kiang, anwarow i e melmel famu i yau.’” ");
INSERT INTO hrw_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Warfakausi e fuunuf sak ilo, ma warfakausi kia, e bilbilseni e fang konona fan mok tif kiar. ");
INSERT INTO hrw_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Tikin, Deo e tow e fafanau tif kiar ulo limow e Moses, safle lo Mesaiya Yesus, kiar ka parfailmi e warfakausi ma sinang tikin. ");
INSERT INTO hrw_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","E tek tikas e sau pari e Deo, e tam. Safle tikii tingkat na Sikow tibom e Deo, i e melmel unaisa e Tamow, i tibom e fanangsi e Deo tif kiar. ");
INSERT INTO hrw_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ma fang kaltu bakir kere fan Juda ri tule re fam pris, ma fan Liwai tingna Jerusalem una la gatmo e Jon aregii, “O se?” ");
INSERT INTO hrw_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","I e tibi finufu e ti sunwar, safle e peteng ten, “E tibi ta yau gii Mesaiya.” ");
INSERT INTO hrw_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ri gatmo e Jon aregii, “Ma o se, o gii Elaija?” Ma i ka war singri, “E tam.” Ri ka gatmo, “Ma o se, o na profet lewa Moses ka warfot lo ini eu puek?” Ma i ka koso singri, “E tam.” ");
INSERT INTO hrw_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Wimi ri ka war singi, “O se tikin? On sesuupuek i o tif kemem, usi kemem u la peteng tifre fa gii, ri ka tule kemem, ma ini are o war lo o tibom?” ");
INSERT INTO hrw_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Jon e koso singri, “Ya na kaltu lewa profet Aisaiya kabuk seti e sunwar lo aregii, ‘angkiimkiim a neng e tautau ulo male e tek ti kaltu, “Fariisu e sal ke Taufi.” ’” ");
INSERT INTO hrw_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ma fa fam Farasi, ri tule ri, ");
INSERT INTO hrw_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","ri gatmo e Jon aregii, “Anwarow lo sa gii o ka gu re tongge, ma ka tibi ta ini o na Mesaiya, tam Elaija, tam o na profet lewa Moses ka warfot lo ini eu puek?” ");
INSERT INTO hrw_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Jon e koso singri aregii, “Ya su gu re tongge ine dan, safle e mel e neng ailo falifu lo gam, e ta kaltu gam tibi parfat lo. ");
INSERT INTO hrw_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","I e mu puek nami yau, ma ya tibi ta konona kaltu e fasi una pikii e amfinau lo su kia.” ");
INSERT INTO hrw_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Fan mok gii, e fuut una Betani, ulo galu lo dan Jodan, ulo mok gii Jon ka gugu tarawen ire tongge ulo. ");
INSERT INTO hrw_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Lo biing wimi, Jon e pari e Yesus e fesfes lala usi, ma Jon ka war, “Par. Igii e Sikuan Sipsip ke Deo. I eu kepufu e fan tubiil kere tongge nano gii lo nal. ");
INSERT INTO hrw_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Igii, e kaltu lewa ya ka warwar lo, ‘E mel e neng e kaltu, e mu puek wimi i yau. I e bakir iyat i yau, anwarow i e sau melmel famu i yau.’ ");
INSERT INTO hrw_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Famu yau tibom ya tibi parfat ini i e ta se, safle anwarow gii ya ka gu tarawen ire tongge ine dan, e ta una fabeku ini i e ta se tifre fan Israel.” ");
INSERT INTO hrw_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ma Jon ka peteng suupuek tifre tongge aregii, “Ya pari e Tangwa Riis e pu tinglo balambat are anman (ambal) ma ka ngosok ulo. ");
INSERT INTO hrw_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Yang gi tibi parfat lo i, safle se gii ka tule yau una gu tarawen ire tongge ine dan, i e sau peteng tif yau ini, ‘Kaltu gii o ka pari e Tangwa Riis eu pu ma ku melmel ilo, i e sam ta e kaltu una gu tarawen ire tongge ine Tangwa Riis.’ ");
INSERT INTO hrw_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Yau sau pari ma ya ka peteng ten ini, i e ta Sikow e Deo.” ");
INSERT INTO hrw_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Biing usi, Jon uwa ming tura un neng lo re fan disaipel kia. ");
INSERT INTO hrw_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","I e pare Yesus e fespaket, i ka war, “Par, igii, e Sikuan sipsip ke Deo.” ");
INSERT INTO hrw_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Biing un disaipel ke Jon, ru ongni e war aiya singru, ru ka matet ru ka minami e Yesus. ");
INSERT INTO hrw_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yesus e giliiu mil ma ka pari ini ru mimi lala nami, i kam gatom ru, “Kamu bura e sa?” Ru ka koso, “Rabi, (pimpiku gii titsa) o melmel iya?” ");
INSERT INTO hrw_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","I ka koso, “Kasa kamu ku sa par.” Ma ru ka la pari e male i e melmel ilo. Ru ka melmel tura lo biing kiruur. (E ngo are anmatam pisii baba e fet lo efef fan mok gii e fuut.) ");
INSERT INTO hrw_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Neng lo ru e ta tualik e Saimon Pita, asow gii Enru. ");
INSERT INTO hrw_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Saupesak, i ka sik ine tualik ma ka peteng fateni, “Kemem sau pari e Mesaiya” (pimpiku gii Kristus.) ");
INSERT INTO hrw_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","I ka onu e Saimon tife Yesus. Ma Yesus ka pari ma ka war, “O gii Saimon, sikow e Jon. Riu foteng o ini Sefas” (pimpiku gii Pita). ");
INSERT INTO hrw_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Biing wimi Yesus e sangsang una la una Galili. I ka la use Filip, ka la war singi aregii, “Kasa nami yau.” ");
INSERT INTO hrw_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filip, Enru ma Pita ri tuul nano tinglo taon Betsaida. ");
INSERT INTO hrw_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filip e la use Nataniel, ka la peteng tifi aregii, “Kemem sau pari e kaltu lewa, nangen Moses ka seti e sunwar lo, ulo sunwar pepe. Ma fam profet ming ri siisiit, ma ri ka peteng ini, Yesus tingna Nasaret, sikow e Josef.” ");
INSERT INTO hrw_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nataniel e war, “Ya sang aregii, ini eu tek ti mok kausi eu puek tingna Nasaret.” Filip e koso aregii, “Kasa, ok sa par.” ");
INSERT INTO hrw_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Biing Yesus e pari e Nataniel e fesfes lala usi, i e war talo aregii, “Par, kaltu gii ka puek, i e ta kaltu tikin tingna Israel. Ma e tek ti anggurum ilo.” ");
INSERT INTO hrw_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nataniel ka gatmo, “Are o parfat lo yau?” Yesus e koso ma ka war, “Ya sau par o lo biing o kiiskiis uwa ulo pikliu e au fik, famu ma Filip kamu la un o.” ");
INSERT INTO hrw_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nataniel e ongni e sunwar a, ma i ka war aregii, “Rabi, o na Sikow e Deo, o na King kere fan Israel.” ");
INSERT INTO hrw_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ma Yesus ka war singi, “O am titinge, anwarow ya peteng tifo ini ya par o ulo pikliu e au fik. Wimi, o mu pari e fan mok eu bakir iyat ine sa gii o ka ongni geinggii.” ");
INSERT INTO hrw_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ma Yesus ka war ming aregii, “Ya peteng tikin tif gam, gam u pari e balambat, Deo eu ipki, ma fan anggelo ke Deo ri ku kanek ma ri ku ding faliu ilo Sikow e Kaltu.” ");
INSERT INTO hrw_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Lo biing baba e tuul, e mel e antinaule una Kena, ulo prowins Galili. Tinow e Yesus, i e ta ulo en a, ");
INSERT INTO hrw_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","ma Yesus tura fan disaipel kia ming, ri tau iri una la wilo en na tinaule a. ");
INSERT INTO hrw_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ma biing waen e rop, tinow e Yesus ka war singi, “Waen e sam rop ma e sam tek ti waen keri.” ");
INSERT INTO hrw_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ma Yesus ka koso, “Tiduung, areini o ka sa peteng tif yau ine fan mok a? Biing kiang e tifik puek.” ");
INSERT INTO hrw_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Wimi tinow ka war singre tongge na mus aregii, “Le i ku peteng tif gam ine sese mok, gam usu usi aregii i ku peteng.” ");
INSERT INTO hrw_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","E mel e baba on na sospen una utut dan, una gu ri, ri ku kalkaliis, are lo ninis kere fan Juda ma ri binga lo fatfat. Tiikii neng, tikii neng lo ri e bakir ka fasi una kepe e u e sangful, tam e tuul e sangful na galen na dan. ");
INSERT INTO hrw_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Kala Yesus ka war singre tongge na mus, “Gam ut dan talo bala fan sospen a.” Ma tongge na mus ri ka utfi e fan sospen a ka la fuunuf. ");
INSERT INTO hrw_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Wimi i ka peteng tifri, “Gii, gam utfi e ti ponon dan, ma gam ku kepe, gam ku la tow tife efefe lo en na tinaule.” Ri ka gow aregii i ka peteng. ");
INSERT INTO hrw_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ma efefe lo inen na tinaule a, ka inim tumsi e dan, e sam ikis ka la ta waen. I e tibi parfat lo waen a ini e la ting iya, safle tongge na mus a, ri ka utfi e dan, ri tibom ri parfat. Wimi efefe lo inen a, ka tau ine kaltu na tinaule. ");
INSERT INTO hrw_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Ma i ka war singi, “Tongge ri fafafen ine konona waen famu, ma wimi ine tongge iri ilo en, ri sam in fuunfuun, ri kamu fafen ine waen e tibi kausi a. Safle o, o bingfamti e konona waen ka la muut gii.” ");
INSERT INTO hrw_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","I gii e mok baba tikii na tibou fuut, Yesus e gow una Kena ina Galili. I e fabeku e finaswen kia, ma fan disaipel kia ri ka titinge lo. ");
INSERT INTO hrw_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Wimi ine en a, Yesus tura tinow, ma tanga tualik, ma fan disaipel kia ri matet tingna Kena, ka la una Kapenaum. Ri ka la melmel wa, lo tanga biing. ");
INSERT INTO hrw_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","E sau fatat e biing kere fan Juda una gow e Biing Bakir na Kepsiliwi, iya Yesus ka la una Jerusalem. ");
INSERT INTO hrw_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ma Yesus ka pare tongge ri umumat ine fam buuluumakau, fan sipsip ma fam bal ma fa lo re tongge a, ri kiiskiis ulo fan teibel ri ka fafapiiliis ine fan mani ulo bala balo lo Felun Nining Bakir. ");
INSERT INTO hrw_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Yesus ka kepe amfinau ka gow e an napnapis lo ma ka fesel suu iri nano kosnge Felun Nining Bakir, tiim tura fam buuluumakau ma fan sipsip keri. Ma i ka ikis ufufu lala e fan teibel kere tongge na fafapiiliis ine fan mani ma ka sabel fafalek ine fan mani keri. ");
INSERT INTO hrw_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ma ka war singre tongge na umumat fam bal, “Suu tura fam bal a ting wagii! E tamu gam ka gow e fel ke Tabuung, are fel na umumat?” ");
INSERT INTO hrw_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ma fan disaipel kia ri sagif famila ini Sunwar Pepe e peteng aregii, “Balang use keu fel, Deo, eu tow e singmat na mafet tif yau.” ");
INSERT INTO hrw_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ma tongge lamlam kere fan Juda ri ka sa gatom rawas ini, “Sese ti mok na tibou fuut, o fasi una fanas kemem ini, una fanangsi ini o mel e miam singe Deo, una gow e mara mok gii?” ");
INSERT INTO hrw_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ma Yesus ka koso singri aregii, “Gau paekufu e Felun Nining Bakir gii, ma ya ku feti mil, ilo bala e su tuul e biing.” ");
INSERT INTO hrw_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ma fan Juda ri ka koso singi, “Felun Nining Bakir gii, tongge ri musngeni lo e fet e sangful ma e on na matamfaim, ma gii, o ka peteng ini ou feti mil ilo bala e su tuul e biing?” ");
INSERT INTO hrw_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Safle Felun Nining Bakir gii Yesus ka warwar lo, e ta pinumfow tibom. ");
INSERT INTO hrw_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Wimi ine Yesus e sau matet mil kosnge minet, fan disaipel kia ri ka sagif famila e sunwar i e sau peteng ini ma ri ka titinge lo Sunwar Pepe ma fan sa Yesus e sam war ini. ");
INSERT INTO hrw_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Lo biing Yesus e ta una Jerusalem, ulo Biing Bakir na Kepsiliwi, i e gow e fan mok na tibou fuut. Tongge fuunfuun, ri ka pari ma ri ka titinge lo asow. ");
INSERT INTO hrw_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Sakle Yesus e tibi titinge lo ri, anwarow i e parfat lo balbalri. ");
INSERT INTO hrw_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","E tek tikas e fasi una sesuupuek ine melmel ke tikii neng, tikii neng lo re tongge tifi, anwarow i tibom e parfat lo sa e ta ilo balbalre tongge nano. ");
INSERT INTO hrw_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","E mel e neng e kaltu ri fotngi ini Nikodemus. I e ta neng lo fam Farasi, ma e ta kaltu bakir kere fan Juda. ");
INSERT INTO hrw_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Nikodemus e puek talo Yesus lo panambiing, ka sa war singi aregii, “Titsa, kemeu parfat ini Deo e tule o are titsa, anwarow e tek tikas e fasi una gow e fan mok na tibou fuut are o, le Deo enggi tibi ta tura i.” ");
INSERT INTO hrw_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesus ka koso singi aregii, “Ya peteng tikin tifo, e tek tikas e fasi una pari e kepmale ke Deo, le i ku tibi fuut fuu mil.” ");
INSERT INTO hrw_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ma Nikodemus ka gatmo aregii, “Areini lea, gii kaltu kabuk matuk ku la fuut fuu mil? E tikin sak ini kaltu e tibi fasi una kaulek mil ilo bala e tinow, ma tinow ku fasus mil ini.” ");
INSERT INTO hrw_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesus e war singi, “Ya peteng tikin tifo, e tek tikas e fasi una kaulek ilo bala kepmale ke Deo le i ku tibi fuut fuu mil lo dan ma lo Tangwa Riis. ");
INSERT INTO hrw_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Sa pinumfow e kaltu e fafuutngeni e ta pinumfow. Safle sa Tangwa Riis e fafuutngeni e ta tangwa. ");
INSERT INTO hrw_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ou tibi kuufsak lo sunwar gii, ya ka sesngeni tifo, ‘Gam samusu fuut fuu mil.’ ");
INSERT INTO hrw_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Kif e usi e salu tibom. O ongni e dungow, safle o ti parfat lo ini e puek ting iya, tam e la wiya. E buk su ngo ming aiya usi re tongge nano ri fuut fuu mil lo Tangwa.” ");
INSERT INTO hrw_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ma Nikodimus ka gatmo, “Are legii fan mok gii riu fuut?” ");
INSERT INTO hrw_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesus ka kos famila singi aregii, “O na titsa kere fan Israel ma areini gii o ka tibi pauti e fan mara mok gii? ");
INSERT INTO hrw_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ya peteng tikin tifo, kemem gongon lo sa kemeu parfat lo. Ma kemem sesuupuek ini e fan sa kemem sau pari, safle gam na tongge gii gam tibi bura una kepe fan warwar kemem sesuupuek ini. ");
INSERT INTO hrw_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ya sam gongon sing gam lo fan mok tinglo nal, ma gam tibi titinge, areini gii gam kamu titinge le ya ku gongon sing gam lo fan mok tinglo balambat? ");
INSERT INTO hrw_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","E tek tikas e sam la ulo balambat, safle Sikow tibom e Kaltu, i e puek tinglo balambat. ");
INSERT INTO hrw_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","E buk su ngo are Moses e akteni wiyat e sii e binga lo sun aen ine sungkalut ulo male mas. Aregii Sikow e Kaltu ri samusu akteni wiyat, ");
INSERT INTO hrw_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","usi ini tongge nano a ri ka titinge lo, riu kepe e ninliu bingne. ");
INSERT INTO hrw_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Le Deo e mel e singmat na fabur kia lo kiar na tongge tinglo nal, iya i ka tow e su tikii tingkat na Sikow usi ini tongge nano a ri ka titinge lo, riu tibi met, safle riu kepe ninliu bingne. ");
INSERT INTO hrw_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Le Deo e tibi tuleni e Sikow ka sa la wagii lo nal una anganggon singre tongge tinglo nal, safle i e tuleni una faliungeri. ");
INSERT INTO hrw_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Kaltu e titinge lo, i eu tibi ti ilo anganggon. Ma le kaltu ka tibi titinge lo, e sam ta i ilo anganggon, anwarow i e tibi titinge lo asow e tikii tingkat na Sikow e Deo. ");
INSERT INTO hrw_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ma anganggon eu ngo aregii, anten e sau puek wagii lo nal, safle tongge ri bura sak e anor iyat ine anten, anwarow ri ta tongge na tumtubiil. ");
INSERT INTO hrw_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Tongge nano na tumtubiil ri guuluung sak ine anten. Ri tibi bura ini riu puek ilo anten, le ri soke ini sinsinangu ri eu puek na malal. ");
INSERT INTO hrw_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Sakle seri a, ri ka melmel ususi e sinang e tikin, riu puek ilo anten usi ini anten, eu fanangsi ini ri sam gow e fam faim keri lo rawas ke Deo.” ");
INSERT INTO hrw_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Wimi ine mok gii, Yesus tura fan disaipel kia ri ka la ulo prowins Judia, ka la melmel tura ri uwa, ma ka gu tarawen ire tongge. ");
INSERT INTO hrw_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Jon ming e gugu tarawen ire tongge ulo male Ainon fatatu e male Salim. Tongge ri roprop puek usi una sa kepe amfagu wa, anwarow fan dan e fuun ulo male a. ");
INSERT INTO hrw_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Lo fam biing a Erot e tifik towfu e Jon ulo rerek.) ");
INSERT INTO hrw_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Fa lo re fan disaipel ke Jon ri fatinge tura neng lo re fan Juda ini sese ninis lo amfagu ri samusu gow, usi ini ri ku fasi una nining lo Deo. ");
INSERT INTO hrw_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Wimi fan disaipel ri ka la use Jon ma ri ka la peteng tifi aregii, “Titsa, kaltu le ka ta tura o ulo galu lo dan Jodan, lewa o ka sesuupuek ine sunwar lo, kaltu a leii ka gugu tarawen ire tongge, ma ri ka tiin roprop usi.” ");
INSERT INTO hrw_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Jon ka koso singri aregii, “Le Deo ilo balambat ka tibi tow e ti mok tife tikas, kaltu a e tibi fasi una kepe ti mok. ");
INSERT INTO hrw_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Gam tibom gau fasi una sesuupuek ini ya sam war aregii, ‘E tibi ta ini yau gii Mesaiya, safle Deo e tule yau famu ini.’ ");
INSERT INTO hrw_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Le kaltu ka tili e fefin, fefin a e ta wok ke kaltu a. Ma fenngow e kaltu tinaule a eu titi ma ku ongongni e angkiimkiim a kaltu a, ma i eu fuunuf tikin ine fefeal lo biing e ongni e angkiimkiim a kaltu tinaule a. Aregii fefeal kiang tibom e fafonsi e balang. ");
INSERT INTO hrw_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ri samusu resngeni e asow e Yesus ma faporo e asang. ");
INSERT INTO hrw_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Yesus, kaltu e puek ting uiyat, i e ta iyat i re tongge nano. Kaltu tinglo nal, i e ta tinglo nal, ma eu gongon ming lo fan mok tingga lo nal. Safle kaltu e puek tinglo balambat i e ta iyat i re tongge nano. ");
INSERT INTO hrw_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","I e sesuupuek ine fan mok e sau pari ma e sam ongni, safle e tek tikas eng kepe, ma ek bingfamti e fan warwar i e sesngeni. ");
INSERT INTO hrw_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Kaltu a ka kepe e sinseng kia ma ka bingfamti e fanangsi ini kaltu a e titinge lo sunwar gii, ‘Deo e ta Deo una petpeteng tikin.’ ");
INSERT INTO hrw_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Anwarow Kaltu a Deo kabuk tuleni, i eu sesngeni e fan warwar ke Deo, le Deo e tow e Tangow kiruur tifi. ");
INSERT INTO hrw_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Tamow e bura sak e Sikow, iya ka towfu e fan mara mok nano ilo limow. ");
INSERT INTO hrw_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Se a ka titinge lo Sikow, i eu kepe ninliu bingne, safle se a ka tibi a-uu lo Sikow, i eu tibi kepe ninliu bingne, anwarow balasak ke Deo eu ta ilo.” ");
INSERT INTO hrw_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Fam Farasi ri ong ini Yesus e kawit re fan disaipel fuunfuun ma ka gu tarawen iri, iyat ine Jon. ");
INSERT INTO hrw_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Tikin lo, Yesus e tibi gu tarawen ire tongge, sakle fan disaipel kia, ri gu tarawen ire tongge. ");
INSERT INTO hrw_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Lo biing Yesus e ong lo mok a, i ka matet tingna Judia ka la mil una Galili. ");
INSERT INTO hrw_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Lo fines kia tinglo prowins Judia wilo prowins Galili, i e samusu solpaket famu ilo prowins Samaria ma kamu la wina Galili. ");
INSERT INTO hrw_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Wa, una Samaria Yesus e la puek ulo taon ri fotngi ini Saika fatatu e irin nal gii, Jekop ka tow tife sikow Josef. ");
INSERT INTO hrw_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Anmatan dan a Jekop e ta wa. Yesus e la ngutu e tomfow na fesfes lala, ka la manau ulo fow e anmatan dan a lo siat tuntun. ");
INSERT INTO hrw_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ma neng e fefin tingna Samaria ka sa la una sa ut dan. Yesus ka war singi, “E fasi ini ou tow e ti dan ya ku in?” ");
INSERT INTO hrw_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Lo sum biing a, fan disaipel kia ri la ulo taon una la fifiil fan tuan.) ");
INSERT INTO hrw_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Wok a ka war singi, “O na Juda ma ya na Samaria, areini gii o ka gatom yau use ti dan?” (Wok a e gon aiya sing e Yesus anwarow fan Juda ri tibi tiimtiim tura fan Samaria.) ");
INSERT INTO hrw_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yesus ka koso, “Le ong gi parfat lo finafen ke Deo ma se gii ka gatom o ine ti dan, ong gi sam gatmo ma i ek sam tow e dan na ninliu tifo.” ");
INSERT INTO hrw_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ma wok a ka war singi, “Kaltu bakir, e tek kem ti mok una ut ma anmatan dan gii ka ding sak ma o ku kepe dan na ninliu a ting iya? ");
INSERT INTO hrw_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Antumlamem Jekop e tow e anmatan dan gii tif kemem. I tiim tura berberat kia ma fan man kia ri tiin in tinglo. Areini, o bakir iyat ine taumem Jekop, be?” ");
INSERT INTO hrw_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesus ka koso, “Seri a ri ka in tinglo dan gii riu met dan mil. ");
INSERT INTO hrw_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Sakle se gii ku in tinglo dan gii ya ku tow tifi, i eu tibi met dan mil, e tam. Dan gii, ya ku tow tifi, eu fespuek are anmatan dan e bubuel ma dan a eu tow e ninliu bingne tifi, ma e tibi fasi una rop.” ");
INSERT INTO hrw_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Wok a ka war singe Yesus, “Kaltu bakir, tow e dan a tif yau, usi yau tibi met dan mil ma ya kamu tibi mil una sa ut dan ming.” ");
INSERT INTO hrw_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yesus ka peteng tifi, “La, o ku la un puek ine keu matuk.” ");
INSERT INTO hrw_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Wok a ka koso, “E tek kek ti matuk.” Yesus ka war singi, “O peteng tikin lo biing o war ini e tek kem ti matuk. ");
INSERT INTO hrw_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Tikin lo e ngo aregii, e lim e keu matuk, ma neng a ka melmel tura o e tibi ta keu matuk tikin, sa o peteng ini e tikin sak.” ");
INSERT INTO hrw_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Wok a ka war singi, “Kaltu bakir, ya kau parfat a, ini o na profet. ");
INSERT INTO hrw_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Fan tumtumlamem ri nining singe Deo lo ampaklunmale gii, sakle kemi na fan Juda kemi peteng ini Jerusalem e ta male kiar samusu nining singe Deo ilo.” ");
INSERT INTO hrw_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yesus ka war singe wok a aregii, “O samusu titinge lo sunwar gii ya ku peteng ini tifo, biing eu puek ma gam amu tibi nining singe Tabuung ilo paklunmale gii, tam ina Jerusalem. ");
INSERT INTO hrw_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Gam na fan Samaria gam nining lo sa gam tibi parfat lo, kemem na fan Juda kemem nining lo sa kemeu parfat lo, anwarow faim una faliungere tongge e la tingnais re fan Juda. ");
INSERT INTO hrw_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Sakle biing eu puek ma e sau puek gii, ma seri a ri ka ta tongge una nining tikin singe Tabuung ri samusu nining lo tangwa ma sinang e tikin. Ma Tabuung e parpar ine matan tongge aiya. ");
INSERT INTO hrw_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Deo e ta tangwa, ma seri a ri ka nining singi, ri samusu nining lo tangwa ma sinang e tikin.” ");
INSERT INTO hrw_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Wok a ka war, “Ya parfat ini Mesaiya” (ri fotngi ini Kristus) “eu puek. Biing eu puek, eu fatenngeni e mara mok tif kiar.” ");
INSERT INTO hrw_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yesus ka koso, “E sam ta yau legii, ya ka gongon sing o.” ");
INSERT INTO hrw_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Lo sum biing a, fan disaipel kia ri ka puek, ri kuufsak una pari ini Yesus e gongon tura neng e wok, sakle e tek tikas ek gatom ini “Sa o bura?” tam, “E tamu o ka gongon singe wok a?” ");
INSERT INTO hrw_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Wok a e la kosnge baket na dan aiya, ma ka la mil ulo taon ka la peteng tifre tongge, ");
INSERT INTO hrw_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Kasa, gam ku sa par lo kaltu e peteng ine mara mok ya gowgow. Ya sang ini i e ta Mesaiya ngan?” ");
INSERT INTO hrw_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ri ka la kosnge taon a, ma ri ka fes lala usi. ");
INSERT INTO hrw_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Lo sum biing a, fan disaipel kia ri ka war singi, “Titsa, en ti mok.” ");
INSERT INTO hrw_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Sakle i e war singri, “E mel e tuan aiyang una en, gam tibi parfat lo.” ");
INSERT INTO hrw_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Fan disaipel kia ri ka fawar falifu iri, “Areini, tikas e sa tow e ti tuan aiya?” ");
INSERT INTO hrw_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yesus ka war singri, “Tuan aiyang, e ta una gow e fabur ke se gii ka tule yau ma una faropo e fam faim kia. ");
INSERT INTO hrw_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Gam warwar aregii, ‘E fet e funiil aiwa ma wimi biing una matuk faim kamu puek.’ Ya peteng tif gam, ipki e matmatmi ma gam ku par ilo palang! Palang e sau pim una fitiil! ");
INSERT INTO hrw_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Gii kaltu na fitiil e sam kepe fimfiil kia ma ku sele tiim ine fan tuan e mel e ninliu bingne, usi se a ka so ma se a ka fitiil iru nano ru fefeal. ");
INSERT INTO hrw_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Sunwar gii e tikin, ‘Nenge kaltu eu ume ma neng kuriik ku fitlii.’ ");
INSERT INTO hrw_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ya tule gam una fitlii e sa gam tibi faim lo, fa ri sam gow e faim tuntun a, sakle gam su en tinglo mia ri.” ");
INSERT INTO hrw_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Fa fuunfuun lo re fan Samaria tinglo taon a, ri titinge lo Yesus, anwarow wok a e peteng tifri ini Yesus e potnamata ine mara mok e gowgow. ");
INSERT INTO hrw_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Lo biing fan Samaria ri puek talo Yesus, ri gatmo ini eu bi melmel tura ri. I ka melmel tura ri lo e u e biing. ");
INSERT INTO hrw_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ma fa fuunfuun ming ri ka titinge lo, anwarow lo fan warwar kia. ");
INSERT INTO hrw_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ma ri ka peteng tife wok a aregii, “Kemem titinge e tibi ta ini anwarow lo safle sa o peteng tif kemem ini, sakle anwarow kemem tibom kemem sam ongni e fan warwar kia, ma kemem ka parfat ini e tikin sak, kaltu gii e ta anwaramfaliunge ke nal.” ");
INSERT INTO hrw_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Wimi ine um biing a, Yesus e la una Galili. ");
INSERT INTO hrw_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","(Yesus e sau bou peteng ini, “Ilo anwaran male ke profet, tongge kia ri tibi natkeni.”) ");
INSERT INTO hrw_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Biing i e puek una Galili, tongge una Galili ri areni, anwarow ri pari e fan mok i e gow lo Biing Bakir na Kepsiliwi una Jerusalem, le ri ming ri ta wa. ");
INSERT INTO hrw_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Yesus ka la mil una Kena ina Galili, ulo male lewa i ka iksi e dan ka la ta waen ulo. Ma e mel e kaltu bakir tinglo Gapman e ta wa, sikow e mase una Kapenaum. ");
INSERT INTO hrw_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Biing kaltu a e ong ini Yesus e sau puek una Galili tingna Judia, ka la usi ka la gatmo, ini eu sa la ku sa faliungeni e sikow, le i e sau bala met. ");
INSERT INTO hrw_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yesus ka peteng tifi, “Le gam ku tibi pari e fan tintof ma fan mok na tibou fuut, gam u tibi titinge.” ");
INSERT INTO hrw_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Kaltu a ka war singe Yesus, “Kaltu bakir, ka sa saupe are sikuang kau met.” ");
INSERT INTO hrw_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yesus ka koso singi, “La, sikuam eu liu.” Kaltu a ka titinge lo sunwar ke Yesus ma ka la. ");
INSERT INTO hrw_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Biing i uwa ulo sal, tongge na mus kia ri ka sa tupngeni tura sunwar ini sikow e sam liu. ");
INSERT INTO hrw_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","I ka gatom ri ini lo sese anmatam pisii sikow e liu, ma ri ka peteng tifi ini lo tikii anmatam pisii nabiing, ambokor a e rop. ");
INSERT INTO hrw_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Tamow kala sangfi, ini lo sumbiing sekit a Yesus e war singi ini, “Sikuam eu liu.” Iya i tiim tura fumberat kia ri ka tiin titinge lo Yesus. ");
INSERT INTO hrw_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Mok gii e ta tintof baba e u Yesus e gow una Galili, lo biing e mil tingna Judia. ");
INSERT INTO hrw_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Wimi ine fan mok Yesus e gow una Galili, i e la una Jerusalem ulo neng e en bakir kere fan Juda. ");
INSERT INTO hrw_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Una Jerusalem fatatu e matangkon lo balo ri fotngi ini Matangkon kere fan Sipsip, e mel e anmatan dan bakir uwa. Lo kinen Ibru ri fotngi ini Betesda. Ulo anisow e matan dan a, e mel e, e lim e fel una melmel ma e tek ti fam balo lo ri. ");
INSERT INTO hrw_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","E mel e tongge fuunfuun sak ri mase, ri ngongo ulo fam fel a, fa ri baf, fa kekek ri e sak ma fa tutuamfo ri e met. ");
INSERT INTO hrw_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Nenge kaltu ulo mok a e mel e anminse ulo, lo e tuul e sangfuul ma e wal na matamfaim. ");
INSERT INTO hrw_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesus e pari e kaltu a, ma i ka parfat ini e mase ting nangen sak, Yesus ka gatmo, “Areini, o bura ini ow liu?” ");
INSERT INTO hrw_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Kaltu ine anminse a ulo ka koso, “Kaltu bakir, lo biing dan a ka doi, e tek tikas una ules yau talo bala dan gii, ya bura una la, safle fa ri sam la famu i yau.” ");
INSERT INTO hrw_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yesus ka war singi, “Matet, kepe kem ngiin ma o ku fes.” ");
INSERT INTO hrw_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Saupe sak kaltu dol a ka kausi, ka kepe ke ngiin ma ka fes. Biing mok gii e puek, e ta lo biing Sabat. ");
INSERT INTO hrw_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Lo biing fan Juda ri pari e kaltu gii, ri peteng tifi, “Geinggii e ta biing Sabat. E tibi riis ususi e fafanau ini ou kepe kem ngiin ma o ku fes.” ");
INSERT INTO hrw_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Safle i e koso e sunwar keri aregii, “Kaltu gii ka faliunge yau, i e peteng tif yau, ‘Kepe kem ngiin ma o ku fes.’” ");
INSERT INTO hrw_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ma ri ka gatmo, “Sese kaltu tikin la e un o una kepe kem ngiin ma o ku fes?” ");
INSERT INTO hrw_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Safle kaltu gii ka liu e tibi ten ini se tikin e onu, anwarow tongge fuunfuun sak ri uwa ulo male a, le Yesus e sau fes borong ini una balri. ");
INSERT INTO hrw_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Wimi ine mok Yesus e gow, Yesus ka kau ulo bala balo lo Felun Nining Bakir, ma ka la pari e kaltu a wa. Ma Yesus ka peteng tifi aregii, “Ong, gii o sam liu mil. Ou manau una gorot fan tubiil, are ti mafet e bakir iyat ine mafet lewa o ka kepe, kam tupnge o.” ");
INSERT INTO hrw_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Kaltu gii ka la peteng tifre fan Juda aregii, “Kaltu lewa ka faliunge yau, gii Yesus.” ");
INSERT INTO hrw_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Gii fan Juda ri ka isa e Yesus, anwarow i e gow e fan mok gii lo fam biing Sabat. ");
INSERT INTO hrw_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Yesus ka war singri, “Tabuung, e sagisu fafaim lo mara bing, ma yau ming ya samusu fafaim.” ");
INSERT INTO hrw_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Lo biing fan Juda ri ongni e sunwar a, fabur keri una paketmet ine Yesus e la bakir sak, anwarow i e ofleki e biing Sabat, ma i e war ming aregii ini Deo e ta Tamow. Sunwar a, i e gow e i tibom ka fasi are Deo. ");
INSERT INTO hrw_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yesus ka koso singri, “Ya peteng tikin tif gam: Sikow e Deo e tibi fasi una gow e ti mok lo sinangu tibom, e tam. E su gow e fan sa e pari singe Tamow. Sese mok Tamow e gowgow, Sikow ming eu gow. ");
INSERT INTO hrw_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Tamow e bura sak e Sikow, i gii ka fanangsi ine mara mok i e gowgow. Ma Tamow eu fanangsi e Sikow ine fan mus bakir sak ming, e kulfi e fan mus e sam gow, usi gam u kuufsak. ");
INSERT INTO hrw_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Tamow e famfamtet re tongge ri sau met ka towtow e ninliu tifri. Aregii, Sikow ming eu tow e ninliu tifre tongge ususi e fabur kia tibom. ");
INSERT INTO hrw_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Tamow e am tibi ikse re tongge ilo anganggon, e tam. Mara mus na ikse re tongge ilo anganggon, e sam towfu tife Sikow, ");
INSERT INTO hrw_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","usi tongge nano riu natkeni e Sikow aregii ri ka natkeni e Tamow. Le kaltu ka tibi natkeni e Sikow, e tibi natkeni e Tamow a ka tuleni. ");
INSERT INTO hrw_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Ya peteng tikin tif gam, se a ka ongni e kek sunwar, ma ka titinge lo se gii ka tule yau, i e sau mel e ninliu bingne. I eu tibi ti ilo anganggon, e tam. I e sam la kosnge minet, ma gii ka mel e ninliu. ");
INSERT INTO hrw_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ya peteng tikin, biing e mu puek, ma gii, e sau puek ma tongge ri met riu ongni e ngusu e Sikow e Deo. Ma seri a ri ka ongni, riu kepe ninliu. ");
INSERT INTO hrw_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Tamow e mel e rawas una tow e ninliu. Ma i ka tow e rawas gii tife Sikow, ma i ming ka fasi una tow e ninliu. ");
INSERT INTO hrw_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ma Tamow ka tow tifi e rawas una anganggon singre tongge anwarow e ta Sikow e Kaltu. ");
INSERT INTO hrw_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Gam u tibi sangfuunfuun lo sunwar gam ongni sing yau. Biing eu puek, ma tongge nano a ka ta iri ilo balbalang kenit, riu ongni e ngusu e Sikow, ");
INSERT INTO hrw_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ma ri ku suu. Seri a ri ka gow e konona sinang riu matet mil ma kepe ninliu. Ma seri a ri ka gow e sinang e sak riu matet mil una ti ilo anganggon nafow e mok ri sam gow. ");
INSERT INTO hrw_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ya tibi fasi una gow e ti sangsang kiang tibom. Ya su anganggon aregii Deo ka bura. Ma anganggon kiang e riis, anwarow ya tibi usi e sinangung tibom, e tam. Ya usi e fabur ke se gii ka tule yau. ");
INSERT INTO hrw_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Le ya ku bom sesuupuek i yau, tongge riu tibi fasi una titinge lo sa ya sesngeni. ");
INSERT INTO hrw_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Safle e mel e neng aiwa una peteng suupuek i yau, ma ya parfat ini fan sa e peteng ini e tikin. ");
INSERT INTO hrw_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Gam sam tule re fa use Jon una ongne singe Jon, ma i e peteng suupuek ine sunwar tikin. ");
INSERT INTO hrw_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ya tibi fasi una a-uu lo warwar kere tongge, safle ya peteng ini, usi Deo eu faliunge gam. ");
INSERT INTO hrw_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jon e ngo are lam e furat una tow e anten tifre tongge. Ma lo sum biing pospos balbalmi e fefeal lo anten kia. ");
INSERT INTO hrw_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Safle e mel e neng e rawas iyat ine Jon una peteng suupuek i yau. I e fan mara mus nano Tabuung e sam tow tif yau una gow ma ropo. Fam faim gii ya gowgow e fanangsi re tongge ini Tabuung e tule yau. ");
INSERT INTO hrw_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","“Ma Tabuung gii ka tule yau, i tibom e peteng suupuek i yau. Safle gam tifik ongni sekit e angkiimkiim aiya ma gam tifik su par lo. ");
INSERT INTO hrw_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ma sunwar kia ming e tibi ta ilo gam, anwarow gam tibi titinge lo kaltu a, Tamow ka tuleni. ");
INSERT INTO hrw_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Gam ngos lo wese ma ikseni e mara warwar ilo bala Sunwar Pepe, anwarow gam sang ini Sunwar Pepe eu tow e ninliu bingne tif gam. Sunwar Pepe mung a, i e sesuupuek i yau. ");
INSERT INTO hrw_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Safle gam tibi bura una sa la usi yau, usi ini gam ku kepe ninliu. ");
INSERT INTO hrw_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Ya tibi bura una kepe as bakir singre tongge, ");
INSERT INTO hrw_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","safle ya parfat lo gam. Ilo balbalmi gam tibi bura e Deo. ");
INSERT INTO hrw_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ya puek lo asow e Tabuung ma gam tibi a-uu lo yau. Safle tikas kuriik enggi puek lo asow tibom, gam gi a-uu lo. ");
INSERT INTO hrw_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Gam kepe as bakir falifu lo gam tibom. Safle as bakir gii Deo tibom ka towtow, gam tibi bura ini gam u kepe. Le kemi ka gowgow e fan sinang gii, areini gii gam ku titinge? ");
INSERT INTO hrw_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Gam u tibi sangfi ini yau bero i gam na mata e Tabuung, e tam. Moses e ta kaltu una bero i gam, kaltu gam sangfi ini eu ules gam. ");
INSERT INTO hrw_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Le keming gi titinge lo Moses, gam gi titinge lo yau ming, anwarow fan warwar i e seti e peteng suupuek i yau. ");
INSERT INTO hrw_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Safle, le gam ka tibi titinge lo fan warwar i e sam seti, areini gii gam ku titinge lo sunwar ya peteng ini?” ");
INSERT INTO hrw_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Wimi ine fan mara mok gii, Yesus ka kaupaket ulo Salat Galili (ri fotngi ming ini Salat Taiberias). ");
INSERT INTO hrw_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ma singmat na galung kaltu ri ka mi nami anwarow ri sau pari e fan mok na tibou fuut e sam gow lo fan minse. ");
INSERT INTO hrw_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Kala Yesus ka kanek ulo paklunmale ma ka kiis uf tura fan disaipel kia. ");
INSERT INTO hrw_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Biing Bakir na Kepsiliwi e sau fatat. E ta en kere fan Juda. ");
INSERT INTO hrw_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yesus e akteni e mata ma ka pari e singmat na galung kaltu ri puek usi. Ma i ka gatmo e Filip aregii, “Kiar u fifiil beret ting iya, are tongge gii una en?” ");
INSERT INTO hrw_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","I e gow e sunwar a una tofo e Filip, sakle i tibom e sau parfat lo mok i eu gow. ");
INSERT INTO hrw_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filip e koso singi, “Fimfiil lo e wal e funiil e tibi fasi una fifiil beret ku fasi lo tikii neng tikii neng lo re tongge nano gii una en ti boron iri.” ");
INSERT INTO hrw_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Neng lo re fan disaipel kia gii Enru, i e ta tualik e Saimon Pita, i e war singe Yesus, ");
INSERT INTO hrw_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“E mel e neng e boron tamat gii e mel e lim e beret aiya ri gow lo bali ma e u e fis, safle areini gii ku fawet lo re tongge fuunfuun gii?” ");
INSERT INTO hrw_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yesus e war, “Unri, ri ku kiis.” E mel e sung garas bakir ulo male a, ma antamat ri fakiisnge, e ngo are e lim e mar. ");
INSERT INTO hrw_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yesus ka kepe fam beret ka aro singe Deo, ma ka ti ini, lo re tongge ri kiiskiis. Iri nano ri en ka la fasi lo fabur keri. I e gow e tikii mok ming lo um fis a. ");
INSERT INTO hrw_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Biing ri sam en ri ka la sut, Yesus ka war singre fan disaipel kia aregii, “Gam tauf tiim ine fan warwaran tuan a ka ta aiwa. Kiar u tibi tafu e ti fanenger ku tam fofoes iri.” ");
INSERT INTO hrw_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Iya, ri ka sele tiim ine fan susu e ngosok lo e lim e beret lewa tongge ri ka en lo, ma ri ka siing ri ulo tikii sangful ma e u na dik. ");
INSERT INTO hrw_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Biing tongge ri sau pari e mok na tibou fuut i e gow, ri ka war, “Tikin sak, i e ta profet lewa ini ku sa la wagii lo nal.” ");
INSERT INTO hrw_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yesus e sau parfat lo fagati keri ini iri bala sa la una sa onu ma ri ku tungi una fespuek ku ta king keri. Iya i tibom ka la mil kosing ri ulo paklunmale. ");
INSERT INTO hrw_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Lo efef fan disaipel ke Yesus ri ka ding una kiin. ");
INSERT INTO hrw_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ri kau lo tikii mon ma ri ka kaupakti e Salat Galili wina Kapernaum. E sau biing ma Yesus e tifik puek una is ri. ");
INSERT INTO hrw_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Kif bakir e fespuek rawas ka gow e balan salat gii ka uf. ");
INSERT INTO hrw_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ri awes lo mon ka la muut are e lim tam e on na kilomita ma ri ka pari e Yesus e fes ulo poktow e kasap, ka fes fatat lala usi e mon, ma ri ka soke sak. ");
INSERT INTO hrw_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Safle i e war singri, “Yau legii, gau mana soke.” ");
INSERT INTO hrw_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ri fefeal una un kaulek ini ulo mon. Saupesak mon ka puek una kiin lo male ri la wilo. ");
INSERT INTO hrw_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Biing usi singmat na galung kaltu ri melmel uwa lo galu lo salat, ri parfat ini e tikii mon uwa. Ma Yesus e tibi kau tura fan disaipel kia. Safle ri tibom ri la. ");
INSERT INTO hrw_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Safle fan mon tingna Taiberias ri puek fatat ulo male a, ri en beret ulo, wimi ine katfariis Taufi e sam tow. ");
INSERT INTO hrw_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Biing tongge a ri pari ini Yesus tura fan disaipel kia ri tibi ta wa, ri kau lo fan mon ri ka la una Kapernaum una la sik ine Yesus. ");
INSERT INTO hrw_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Biing ri pari e Yesus ulo galu lo salat, ri ka gatmo, “Titsa, sese biing o fespuek wagii?” ");
INSERT INTO hrw_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yesus e koso, “Ya peteng tikin tif gam, gam siksik i yau, e tibi ta ini anwarow gam sau pari e fan mok na tibou fuut, e tam, safle gam siksik i yau anwarow gam sam eni e beret, gam kabuk sut. ");
INSERT INTO hrw_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Gam u mala faim use tuan eu tibi ngo bingne, safle gam u faim use tuan a ka fasi una tow e ninliu bingne, iya Sikow e Kaltu ku tow tif gam. Deo Tamow e sau fanangsi ini i tikin.” ");
INSERT INTO hrw_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Kala ri ka gatmo, “Deo e bura ini kemem samusu gow e sa?” ");
INSERT INTO hrw_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yesus ka koso, “Deo e bura ini gam samusu titinge lo kaltu i e sam tuleni.” ");
INSERT INTO hrw_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ri ka gatmo aregii, “Sese mok na tibou fuut ou gow, ku ta tintof ini Deo e sam tule o, usi kemem ku titinge lo o? ");
INSERT INTO hrw_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Fan tumtumlarer ri sam eni e mana ulo male e tek ti kaltu, aregii sunwar ka peteng, ‘I e sam tow e beret tinglo balambat tifri una en.’” ");
INSERT INTO hrw_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yesus e war, “Ya peteng tif gam, e tibi ta Moses e sam tow tif gam e beret tinglo balambat. Safle Tabuung i e tow e beret tikin tinglo balambat tif gam. ");
INSERT INTO hrw_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Beret ke Deo e ta se a ka ding tinglo balambat una tow e ninliu tife nal.” ");
INSERT INTO hrw_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Kala ri ka peteng tifi aregii, “Taufi, om fen kemem ine beret a bingne.” ");
INSERT INTO hrw_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ma Yesus ka peteng tifri aregii, “Ya ta beret na ninliu. Seri a ri ka sa la usi yau, ri amu tibi fitol. Ma seri a ri ka titinge lo yau, ri amu tibi met dan. ");
INSERT INTO hrw_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ya sau peteng tif gam, gam sau par yau, safle gam tibi titinge. ");
INSERT INTO hrw_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Tongge nano a Tabuung ka tow tif yau, riu sa la usi yau, ma se a ka sa la usi yau, ya tibi fasi una fesi. ");
INSERT INTO hrw_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Le ya pu tinglo balambat e tibi ta ini una gow e fabur kiang. Ya samusu gow e fabur ke se a ka tule yau. ");
INSERT INTO hrw_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ma e ta fabur ke se a ka tule yau, ini yau tibi sangintafngi e tikas a i ka tow tif yau, safle yau famtet familri lo biing muut. ");
INSERT INTO hrw_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Fabur ke Tabuung e ngo aregii, seri a ri ka pari e Sikow ma ri ka titinge lo, riu kepe ninliu bingne. Ma yau famtet familri lo biing muut.” ");
INSERT INTO hrw_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Tongge ri fawar fuunfuun falifu iri tibom ine Yesus, anwarow i e peteng aregii, “Ya na beret e ding tinglo balambat.” ");
INSERT INTO hrw_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ma ri ka war, “Yesus leleii, i e ta sikow e Josef. Kerer parfat lo tamow ma tinow, ma areini gii ka peteng ini i e ding tinglo balambat?” ");
INSERT INTO hrw_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yesus e koso e sunwar keri aregii, “Gau mana fagon fuunfuun falifu i gam tibom. ");
INSERT INTO hrw_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","E tek ti kaltu e fasi una sa la usi yau, le Tabuung se a ka tule yau, ka tibi onu usi yau. Ma yau famtet famila lo biing muut. ");
INSERT INTO hrw_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Are lewa profet e sam seti: ‘Deo eu fabenge singre tongge nano.’ Seri a ri ka ong singe Tabuung ma ri ka usi, riu sa la usi yau. ");
INSERT INTO hrw_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","E tek ti kaltu e sau pari e Tabuung, safle kaltu e la ting naisa e Deo, i tibom i e pari e Tabuung. ");
INSERT INTO hrw_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ya peteng tikin tif gam, kaltu e titinge lo yau, i eu mel e ninliu bingne. ");
INSERT INTO hrw_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Yau tibom ya na beret na ninliu. ");
INSERT INTO hrw_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Nangen, tumtumlami ri eni e mana ulo male e tek ti kaltu ulo, safle ri sau famete. ");
INSERT INTO hrw_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Igii e beret a ka ding tinglo balambat. Sese kaltu a ka eni e mu tibi met. ");
INSERT INTO hrw_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ya na beret na ninliu, ya pu tinglo balambat. Le tikas ku eni e beret na ninliu gii, i eu mel e ninliu bingne. Beret na ninliu gii, e ta pinumfong. Iya ya ku tow usi tongge gii lo nal riu kepe ninliu.” ");
INSERT INTO hrw_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Fan Juda ri ongni e sunwar a, ma ri ka fatinge falifu iri, ri ka war, “Areini kaltu gii, ka fasi una fafen ine pinumfow tif kiar una eni?” ");
INSERT INTO hrw_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yesus ka peteng tifri aregii, “Ya peteng tikin tif gam, le gam ku tibi eni e pinumfow e Sikow e Kaltu ma gam ku tibi inmi e andaku, eu tek ti ninliu ilo gam. ");
INSERT INTO hrw_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Kaltu e eni e pinumfong ma ka inmi e dakung, i e mel e ninliu kia bingne, ma yau famtet famila lo biing muut. ");
INSERT INTO hrw_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Anwarow pinumfong e ta tuan tikin ma dakung e ta mok tikin una in. ");
INSERT INTO hrw_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Se a ka eni e pinumfong, ma ka inmi e andakung, i eu melmel ilo yau, ma ya ku melmel ilo. ");
INSERT INTO hrw_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Tabuung e mel e ninliu, e sam tule yau, ma ya liu lo rawas ke Tabuung. Aregii kaltu e eni e pinumfong, i eu kepe ninliu tinglo rawas kiang. ");
INSERT INTO hrw_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Igii e beret lewa ka ding tinglo balambat. Tumtumlami ri eni e mana, ma ri sau famete, safle se a ku eni e beret gii, i eu mel e ninliu bingne.” ");
INSERT INTO hrw_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesus e war aregii, lo biing i e fabenge ulo bala felun nining una Kapenaum. ");
INSERT INTO hrw_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Fa fuunfuun lo re fan disaipel kia ri ongni e sunwar kia ma ri ka war, “Fan warwar gii e kalkala sak. Se fasi una kepe?” ");
INSERT INTO hrw_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ulo bala e Yesus, i e parfat ini fan disaipel kia ri fawar fuunfuun use sunwar i e sam gow, iya i ka war singri, “Sunwar gii, e pete luut ine titinge kemi, be? ");
INSERT INTO hrw_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Eu ta areini, le gam ku pari e Sikow e Kaltu, eu kanek mil wilo male e la tinglo? ");
INSERT INTO hrw_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Tangwa Riis e towtow e ninliu, kaltu tibom e tibi fasi una gow e ti mok. Fan warwar ya tow tif gam, e ta tangwa ma e ta ninliu. ");
INSERT INTO hrw_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Safle fa lo gam ri tibi titinge.” (Yesus e sau parfat tinglo tofnge lo sese kaltu e tibi titinge, ma se eu solamufu.) ");
INSERT INTO hrw_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","I e posmi e sunwar kia ka la, “E tek tikas eu fasi una sa la usi yau, ku muut Tabuung e tow e rawas tifi. Ya peteng ine sunwar gii tif gam anwarow fa lo gam ri tibi titinge.” ");
INSERT INTO hrw_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ting lo biing a, fuunfuun lo fan disaipel kia ri didiu mil ma ri am tibi usi. ");
INSERT INTO hrw_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Yesus e gatmo e tikii sangful ma e u na disaipel kia, “Ma gam tibi bur la ming?” ");
INSERT INTO hrw_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Saimon Pita ka koso aregii, “Taufi, kemem u la use se? Sunwar kiam e tow e ninliu bingne. ");
INSERT INTO hrw_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Kemem titinge ma kemeu parfat ini o ta kaltu tarawen ke Deo.” ");
INSERT INTO hrw_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yesus e koso e sunwar keri aregii, “Yau tibom ya bom tauf gam na tikii sangful ma e u na disaipel, safle tikii neng ailo falifu lo gam e ta tara saksak.” ");
INSERT INTO hrw_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","I e warwar lo Judas sikow e Saimon Iskariot. I e ta neng lo re sangful ma e u na disaipel kia, iya wimi kamu solamufu e Yesus. ");
INSERT INTO hrw_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Wimi ine mok gii, Yesus e lifti e prowins Galili, sakle i e am tibi bur la ming ulo prowins Judia, anwarow fan Juda ri siksik ine ti sal una paketmet ini. ");
INSERT INTO hrw_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Sakle lo biing, Biing Bakir una Gorot fang Kak kere fan Juda e sau fatat, ");
INSERT INTO hrw_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","tanga tualik e Yesus ri peteng tifi, “O samusu la ting wagii o ku la ina Judia usi le fan disaipel kiam riu pari e fan mok na tibou fuut ou gow. ");
INSERT INTO hrw_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Le ti kaltu ku bura ini tongge riu parfat lo, i eu tibi gow e ti mus ilo male e fifinuf. Le o ku bura ini ou musngeni e fan mara mok a, e kausi ini ou ti na malal na matre tongge nano.” ");
INSERT INTO hrw_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ma tanga tualik ming ri tibi titinge lo, ma ri ka gow e sunwar a usi. ");
INSERT INTO hrw_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yesus ka koso tifri, “Biing kiang sekit e tifik fespuek, safle gam, mara biing nano e fasi sing gam. ");
INSERT INTO hrw_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Tongge riu tibi fasi una sak lo gam, safle riu sak lo yau, anwarow ya sesuupuek ine fan sinang saksak ri gowgow. ");
INSERT INTO hrw_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Gam la, wilo Biing Bakir ina Jerusalem. Ya tibi fasi una la, usi le biing kiang e tifik puek.” ");
INSERT INTO hrw_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ka war aiya singri, ma ka melmel una Galili. ");
INSERT INTO hrw_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Safle lo biing tanga tualik ri sam la, Yesus ming ka la, safle i e fes borong ka la, ma e tibi fes na malal na matre tongge. ");
INSERT INTO hrw_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Lo biing Biing Bakir na Gorot fang Kak, tongge lamlam kere fan Juda ri siksik ini, ma ri ka gatom, “Kaltu gii iya?” ");
INSERT INTO hrw_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ma tongge ri fakinal usi i falifu lo ri tibom, fa ri ka war, “I e ta konona kaltu.” Ma fa ri ka war aregii, “E tam, i e gurgurum ire tongge.” ");
INSERT INTO hrw_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Sakle e tek ti kaltu ek gow e ti sunwar lo sinangu ku malal, anwarow ri soke re tongge lamlam kere fan Juda. ");
INSERT INTO hrw_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ulo falifu lo En, Yesus e la kaulek ulo Felun Nining Bakir ma ka fabenge singre tongge. ");
INSERT INTO hrw_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Fan Juda ri ongne sunwar e war ini, ri ka sangfuunfuun, ma ri ka gatom, “Areini be, gii kaltu gii ka fuunuf ine mara parfat? Ma ka tibi la ulo ti fabenge.” ");
INSERT INTO hrw_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yesus ka koso e gatgatom keri aregii, “Sunwar gii ya ka war ini tif gam, e tibi ta ini kiang tibom, e tam, e ta ke se gii ka tule yau. ");
INSERT INTO hrw_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Le tikas ku sangsang una usi e fabur ke Deo, i e amu la sikseni ini fam fabenge kiang e puek singe Deo, tam e puek tinglo sinangung tibom. ");
INSERT INTO hrw_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Se a ka fafuutngeni e sunwar lo sinangu tibom, i e bur akteni e asow tibom. Safle se a ka bur akteni e asow e kaltu e tuleni, i e ta kaltu e riis sak. Ma e tibi ta ini kaltu na gurgurum. ");
INSERT INTO hrw_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moses e tifik tow e fafanau tif gam? Safle e tek tikas lo gam en sam usi. Usi e tamu gam ka bala paketmet i yau?” ");
INSERT INTO hrw_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Tongge a ri ka koso, “Tara saksak ailo o. Se bala paketmet i o?” ");
INSERT INTO hrw_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesus e koso e gatgatom keri aregii, “Ya sam gow e tikii mok na tibou fuut, ma gam nano gam ka sangsang fuunfuun. ");
INSERT INTO hrw_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Safle sangfi, Moses e sam tow e sinang una talsi e pinumfong kaltu tif gam. Le ku ta biing na Sabat, gam u gow ming e faim a. (Tikin, e tibi ta Moses e fafuutngeni e sinang gii, safle i e fespuek singe tuptupmi.) ");
INSERT INTO hrw_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Gau bur usi tikin e fafanau ke Moses, ma gam ka parfat una talsi e fow e berberat lo biing Sabat. Yow, le ya ka faliungeni e fow e kaltu lo biing Sabat, usi e tamu gii gam ka balasak i yau? ");
INSERT INTO hrw_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Gam u tibi ikseni e fan mok lo safle matmat mi. Gam samusu ikseni e fan mok nano lo sinang e riis.” ");
INSERT INTO hrw_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Fa lo re tongge tingna Jerusalem ri ka war, “Areini? I e kaltu mung a, gii tongge lamlam ri ka siksik ine ti sal una paketmet ini? ");
INSERT INTO hrw_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Par! I e gongon na matre tongge, ma ri ka tibi gow e ti sunwar tifi. Ya sang ini ri sau parfat ini i e ta Mesaiya ngan? ");
INSERT INTO hrw_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Safle kiar parfat lo anwaran male ke kaltu gii. Lo biing Mesaiya eu puek, eu tek tikas eu parfat ini i ting iya.” ");
INSERT INTO hrw_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yesus e fabenge ulo Felun Nining Bakir ma i ka tau aregii, “Gam sang ini gau parfat lo yau, ma gau parfat lo ini ya la ting iya. Safle ya tibi puek lo fabur kiang tibom. Se gii ka tule yau, sinangu e tikin, safle gam tibi parfat lo. ");
INSERT INTO hrw_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ya parfat lo, anwarow ya sau melmel tura, ma i e tule yau.” ");
INSERT INTO hrw_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ri ongne sunwar gii, ma ri ka bala towfu ulo rerek, safle biing kia e tifik fespuek, iya ka tek tikas ek bingfamti. ");
INSERT INTO hrw_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Safle tongge fuunfuun ri titinge lo, ma ri ka war, “Biing Mesaiya eu puek, kemem tibi sang ini i eu gow e fan mok na tibou fuut e kulfi e fanenger fan mok na tibou fuut gii kaltu gii kabuk gow.” ");
INSERT INTO hrw_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Fam Farasi ri ongen re tongge ri gow e fan matmatan warwar lo fan mok Yesus e gow, iya iri tura fam pris lamlam ri ka tuleni e fam polis ri ka sa la una sa bingfamteni. ");
INSERT INTO hrw_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ma Yesus ka war, “Yau su melmel balik sak tura gam ma ya ku la mil use Tabuung, se e tule yau. ");
INSERT INTO hrw_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ma gam u sik i yau, safle gam u tibi par yau, ma gam u tibi fasi una la ilo male yau la melmel ilo.” ");
INSERT INTO hrw_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ma fan Juda ri ka fagon falifu iri tibom aregii, “Eu la iya legii kerer ku tibi pari? Ya sang ini eu la use fa lo kiar ri melmel ilo fan taon kere fang Grik, ma ku la fabenge singre fang Grik? ");
INSERT INTO hrw_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Sese pimpiku gii ka war aregii? ‘Gam u sik i yau, safle gam u tibi par yau,’ ma ‘gam u tibi fasi una la ilo male yau la melmel ilo.’” ");
INSERT INTO hrw_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Biing na rorop lo Biing Bakir na Gorot fang Kak, e ta biing bakir, Yesus e ti ma ka war rawas, “Le se a ka met dan, towfu ku sa la usi yau ku sa in. ");
INSERT INTO hrw_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Se gii ka titinge lo yau, ‘Dan na ninliu eu filau tinglo bala,’ are sunwar ke Deo e sau peteng.” ");
INSERT INTO hrw_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Lo mok a i e war lo Tangwa Riis, iya ini seri a ri ka titinge lo, ri amu kepe wimi. Lo sumbiing a Tangwa Riis e tifik puek, le Yesus e tifing kepe as bakir. ");
INSERT INTO hrw_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Lo ongong keri lo sunwar kia, fa lo re tongge ri peteng, “E tikin sak kaltu gii e ta Profet lewa Moses ka warfot lo ini eu puek.” ");
INSERT INTO hrw_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Fa lo ri peteng, “I e ta Mesaiya.” Safle fa ri peteng, “E tam, Mesaiya e tibi fasi una puek tingna Galili. ");
INSERT INTO hrw_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Sunwar ke Deo e peteng ini Mesaiya e samusu puek tinglo fumberat ke king Dewit, ma eu fespuek tinglo taon Dewit e melmel ilo. Taon ina Betle-em.” ");
INSERT INTO hrw_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Aregii tongge ri ka mel lo mara sangsang lo Yesus, ri ka tapot ka u lo ri. ");
INSERT INTO hrw_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Fa lo ri bur tafu ulo rerek, safle e tek tikas ek puse lo limow. ");
INSERT INTO hrw_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Biing fam polis ri mil, fam pris lamlam ma fam Farasi ri gatom ri, “Use e tamu gam ka tibi un puek ini?” ");
INSERT INTO hrw_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Fam polis ri ka koso, “Famu e tek ti kaltu ek gon ine matang gongon gii kaltu gii ka gow.” ");
INSERT INTO hrw_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Fam Farasi ri ka gatom ri, “I e sam gurum i gau ming? ");
INSERT INTO hrw_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Gam sau parfat lo tikas lo re fam pakpaklumem tam tikas lo re fam Farasi e titinge lo i? ");
INSERT INTO hrw_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","E tam! Safle galung kaltu gii ri ka titinge lo, ri tibi parfat lo fafanau ke Moses, gii ri sam ta ilo pikliu e mafet ke Deo.” ");
INSERT INTO hrw_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Tikii neng lo re fam Farasi, asow gii Nikodemus, i e ta kaltu e sam la pari e Yesus famu. I e war singre fam Farasi a, ");
INSERT INTO hrw_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Fafanau kerer, e a-uu ini riu tibi tafu e kaltu ilo rerek, famu ma ri ka tifik ong singri ma ikseri nafow e sa ri gow.” ");
INSERT INTO hrw_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ri ka koso, “O ming tingna Galili? Par fakausi e sunwar ke Deo, ma o ku ten ini eu tek ti profet eu puek tingna Galili.” ");
INSERT INTO hrw_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ma ri ka la mil ulo fan male keri. ");
INSERT INTO hrw_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Safle Yesus e la ulo paklunmale Olif. ");
INSERT INTO hrw_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Lo biingbiing e mok sak i e la mil ulo bala balo lo Felun Nining Bakir ma tongge nano ri ka sa fafang liflifti ma i ka kiis una fabenge singri. ");
INSERT INTO hrw_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Tongge parfat lo fafanau ma fam Farasi ri onu e fefin na gowgow e sinang na faet fafalek, ma ri ka fetiufu u famu ire tongge. ");
INSERT INTO hrw_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ma ri ka peteng tife Yesus aregii, “Titsa, fefin gii ri sau pari e gow e sinang na faet fafalek. ");
INSERT INTO hrw_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ilo fafanau ke Moses e war aregii, fefin aiya, kerer samusu rang meteni ine fatfat. Gii, are o ku war a?” ");
INSERT INTO hrw_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ri gow e sunwar a una tofo e Yesus, anwarow ri bura ini eu gow e ti sunwar usi le i eu ti ilo anganggon, safle Yesus e porpu ma ka siisiit ulo nal ine antelen limow. ");
INSERT INTO hrw_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Biing ri ngos lo gatmo, i ka matet ka war singri, “Le se lo gam ka tek ti tubiil kia, i eu bas ine fat baba tikii talo fefin gii.” ");
INSERT INTO hrw_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","I ka porpu mil ma ka siisiit ulo nal. ");
INSERT INTO hrw_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Biing ri ongni e sunwar a, iri nano ri fes tingtingke, tongge lamlam ri la famu, kala muut lo safle Yesus tibom uwa tura fefin a. ");
INSERT INTO hrw_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yesus e ti ma ka gatmo e fefin a, “Tongge wagii ri iya, ka tek tikas una tauf o ilo anganggon?” ");
INSERT INTO hrw_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ma fefin a ka koso, “Kaltu bakir, e tek tikas.” Ma Yesus ka war, “Yau ming yau tibi touf o ilo anganggon. La ma ou tibi gow ming e ti tubiil.” ");
INSERT INTO hrw_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Biing Yesus e peteng mil tifre tongge, i e war, “Ya na anten tife nal. Kaltu ka usi yau, e tibi fasi una fes ilo anor, e tam. I eu kepe anten na ninliu.” ");
INSERT INTO hrw_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Fam Farasi ri fatof singi, “Gii o ka peteng suupuek i o tibom. Sa o peteng ini e tek ti pararu.” ");
INSERT INTO hrw_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesus e koso, “E tikin ya sesuupuek i yau tibom tif gam. Sese mok ya peteng ini tif gam e tikin, anwarow ya parfat ini ya la ting iya, ma yau la wiya. Gam tibi parfat ini ya la ting iya ma yau la wiya. ");
INSERT INTO hrw_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Gam anganggon lo parfat ke kaltu, ma ya tibi anganggon singe tikas. ");
INSERT INTO hrw_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Safle ya anganggon, anganggon kiang e tikin, anwarow e tibi ta yau tibom ya gow e mok gii. Tabuung, se e tule yau, e ta tura yau. ");
INSERT INTO hrw_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ri seti ulo fafanau kemi, le ka u e kaltu ru tiim, sunwar ke ru e tikin. ");
INSERT INTO hrw_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ya sesuupuek i yau tibom, ma Tabuung se e un yau e sesuupuek i yau.” ");
INSERT INTO hrw_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Wimi ri ka gatmo, “Iya e tamam?” Yesus ka koso, “Gam tifik parfat lo yau, tam lo Tabuung. Le gam gi parfat lo yau, gam gi parfat lo Tabuung ming.” ");
INSERT INTO hrw_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","I e war ine fan warwar gii, lo biing e fabenge ulo bala balo lo Felun Nining Bakir, fatatu e mok una basbas mani. Safle e tek tikas ek tow e limow ulo, anwarow biing kia e tifik puek. ");
INSERT INTO hrw_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ming Yesus e war singri, “Ya bala la, ma gam u sik i yau. Gam u met ilo bala fan tubiil kemi. Gam tibi fasi una sa la wilo male ya la wilo.” ");
INSERT INTO hrw_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Fan Juda ri ka fagatomnge falifu iri tibom, “Sese anwarow gii i ka peteng ini kerer tibi fasi una la ilo male e bala la wilo? I eu bou paketmet ini tibom?” ");
INSERT INTO hrw_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ma Yesus ka war, “Gam ting ufaf, yau ting uiyat. Gam tinglo nal, ya tibi ta tinglo nal. ");
INSERT INTO hrw_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ya peteng tif gam ini gam u met ilo bala fan tubiil kemi. Le gam ku tibi titinge ini ya ta yau se gii ya ka peteng ini, gam u met ilo bala fan tubiil kemi.” ");
INSERT INTO hrw_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ri gatmo, “O se?” Yesus e koso, “Sa ya sau peteng tif gam ini tinglo tofnge sekit. ");
INSERT INTO hrw_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ya fuunuf ine fan mok una peteng ini una ikse gam. Se a ka tule yau e tikin sekit, ma yau peteng fate tife nal ine sa ya ongni singi tibom.” ");
INSERT INTO hrw_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ri tibi parfat ini Yesus e petpeteng tifri ine Tamow. ");
INSERT INTO hrw_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Gii ka peteng tifri aregii, “Biing kemiu akteni e Sikow e Kaltu, kemi kamu parfat ini ya ta yau, ma ya tibi fasi una gow e ti mok lo parfat kiang tibom, e tam. Ya sesngeni e sunwar aregii Tabuung ka fanangsi yau. ");
INSERT INTO hrw_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Se a ka tule yau, i e melmel tura yau, ma e tibi tauf yau ini ya ku bou melmel, e tam. Anwarow ya fawetu e fam fabur kia lo an mara biing.” ");
INSERT INTO hrw_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Tongge fuunfuun ri ongni e Yesus e peteng ine fan mok gii ma ri ka titinge lo. ");
INSERT INTO hrw_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ma Yesus ka war singe seri na fan Juda gii ri ka titinge lo, “Le gam ku usi e fan warwar kiang gam ta fan disaipel kiang tikin, ");
INSERT INTO hrw_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","usi gam u parfat lo warwar tikin ma warwar tikin ku fakausi gam tinglo fam faim fofoes.” ");
INSERT INTO hrw_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ri ka koso, “Kemem ta fan tubtubungkak ke Abra-am. Kemem tifik ta tongge una faim fofoes singe tikas ma areini gii o ka peteng ini sunwar tikin eu fakausi kemem?” ");
INSERT INTO hrw_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ma Yesus ka war singri, “Ya peteng tikin tif gam, seri a ri ka gorgorot fan tubiil, ri ta tongge una faim fofoes singe fan tubiil. ");
INSERT INTO hrw_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Tongge na faim fofoes ri tibi melmel bingne ilo bala fumberat, e tam. Safle sikuang kaltu e melmel bingne ilo bala fumberat. ");
INSERT INTO hrw_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Aregii le Sikow ku fakausi gam, gam u kausi fasef. ");
INSERT INTO hrw_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ya parfat ini gam ta fan tubtubungkak ke Abra-am. Safle gau bala tofo una fismet i yau, anwarow gam tibi kepe fam fabenge kiang. ");
INSERT INTO hrw_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ya peteng tif gam ine sa Tabuung e fanangsi yau ini, safle gam gow e sa gam ongni singe taumi.” ");
INSERT INTO hrw_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ri ka koso, “Abra-am e ta taumem.” Ma Yesus ka koso e sunwar keri aregii, “Le gam gi ta fan siksikow e Abra-am tikin, keming gi gow e fan sinang gii Abra-am ka mel lo. ");
INSERT INTO hrw_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ya peteng ine fan mara warwar e tikin ya ongni singe Deo, ma gii gam ka tofo una paketmet i yau. Fan sinang gii e tibi ta ke Abra-am. ");
INSERT INTO hrw_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Gam gow e fan sinang ke taumi tibom.” Ma ri ka peteng tifi aregii, “Fan tintinmem ri tibi fes falek ma ri ka fasus i kemem, e tam, e su tikii Taumem gii Deo tibom.” ");
INSERT INTO hrw_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ma Yesus ka peteng tifri aregii, “Le tikin Deo enggi ta Taumi, keming gi bur yau anwarow ya la ting naisa e Deo ma gii, ya ka ta gii. Ya tibi sa la lo sangsang kiang tibom, e tam, Deo e tule yau. ");
INSERT INTO hrw_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","E tamu gam ka tibi ten lo fabenge kiang? Anwarow gam tibi fasi una parfat lo sinangung. ");
INSERT INTO hrw_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Gam ta fan siksikow e taumi, i e ta Satan. Tinglo tofnge i e ta kaltu una fisfismet ire tongge ma e tibi ta lo galu e tikin, anwarow e tek ti mok e tikin ilo. Biing e sorom, i e sesuupuek ine bala tibom, anwarow i e ta kaltu na sorsorom ma e ta tamow e angurum. ");
INSERT INTO hrw_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Safle gam tibi titinge lo sunwar kiang, anwarow ya sesngeni e sunwar e tikin. ");
INSERT INTO hrw_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Se lo gam e fasi una peteng ine ti tubiil kiang? Le ya sesngeni e sunwar e tikin, ma usi e tamu gam ka tibi titinge lo sunwar kiang? ");
INSERT INTO hrw_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Se e ta ke Deo, eu ongni e sunwar ke Deo. Gam tibi fasi una ong, anwarow gam tibi ta ke Deo.” ");
INSERT INTO hrw_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ma fan Juda ri koso singi aregii, “Warwar kemem e tikin ini o tingna Samaria, ma ka mel e tara saksak ailo o.” ");
INSERT INTO hrw_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yesus e koso, “E tek ti tara saksak ilo yau. Ya natkeni e Tabuung, sakle gam tibi natke yau. ");
INSERT INTO hrw_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ya tibi siksik ine as bakir tif yau tibom, sakle e mel e neng gii e siksik ine as bakir tif yau. Ma i e ta kaltu na anganggon. ");
INSERT INTO hrw_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ya peteng tikin tif gam, seri gii ri ka usi e sunwar kiang riu tibi met.” ");
INSERT INTO hrw_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ma fan Juda ri ka war aregii, “Kemeu parfat sekit ini o mel e tara saksak ailo o. Abra-am e sau met ma fam profet ming ri sau met. Ma areini gii o ka war aregii ini, ‘Se ri a ri ka ongne sunwar kiang ri tibi fasi una met.’? ");
INSERT INTO hrw_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Tumlamem Abra-am e sau met. Areini, o bakir iyat ine Abra-am? Ma fam profet ming ri sau met. O sangfi ini o se?” ");
INSERT INTO hrw_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yesus e koso, “Le ya ku akteni e asang tibom eu ta mok fofoes. Safle se gii ka akte yau e ta Tabuung. Gau peteng ini i e ta Deo kemi. ");
INSERT INTO hrw_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Gam tibi parfat lo, safle yau, ya parfat lo. Le yang gi peteng ini ya tibi parfat lo, yang gi ta kaltu na gurgurum are gam, safle ya parfat lo ma ya usi e sunwar kia. ");
INSERT INTO hrw_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Tumlami gii Abra-am e fefeal lo sangsang una par lo biing kiang eu fespuek. I e sau pari ma ka fefeal.” ");
INSERT INTO hrw_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ri peteng tifi aregii, “E tifik lim e sangful na matamfaim kiam, ma o kabuk pari e Abra-am?” ");
INSERT INTO hrw_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yesus e koso, “Ya peteng tikin tif gam, famu ma Abra-am kamu fuut ya sau melmel.” ");
INSERT INTO hrw_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ma ri ka kepe fam fatfat una basa, safle Yesus e keskum, ma ka la kosnge Felun Nining Bakir. ");
INSERT INTO hrw_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yesus e fes ka la, ma ka pari e kaltu anmata e baf. Anmata e sau bou baf tinglo biing tinow e fasus ini. ");
INSERT INTO hrw_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ma fan disaipel kia ri ka gatmo, “Titsa, se e gow e tubiil? Kaltu gii, tam tamow ma tinow, gii ka fuut tura anmata e baf?” ");
INSERT INTO hrw_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ma Yesus ka koso aregii, “E tibi ta tubiil kia tam ke tamow ma tinow, e tam. Mok gii e fuut usi tongge nano riu parfailmi e mus ke Deo, ilo ninliu kia. ");
INSERT INTO hrw_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Gii, ma ka ten iwa e male, kiar samusu musngeni e faim ke Deo se e tule yau. Anwarow le anor ku puek, e tek tikas e fasi una gow e ti mus. ");
INSERT INTO hrw_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Biing ya melmel gii lo nal, yau tibom ya na anten tife nal.” ");
INSERT INTO hrw_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Wimi ini e war aiya, Yesus e kanus ulo nal, ka iksi e nal tura angkanus kia ma kam tow ulo anmata e kaltu a, ");
INSERT INTO hrw_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","ma ka onu, “La, o ku la fagu ilo anmatan dan Siloam.” (Pimpiku e Siloam gii, Onu.) Biing e la fagu ma ka mil, anmata e fasi una par. ");
INSERT INTO hrw_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Tongge ri melmel tiim tura ma fa ri sau parpari famu e farfaran, ri gatom, “E sam ta kaltu lewa ka kiiskiis ma ka farfaran re tongge ine fan mani legii?” ");
INSERT INTO hrw_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Fa ri ka peteng, “I mung la e kaltu a.” Ma fa ri ka peteng ini, “E tam, e su par are i.” Iya i tibom ka bou peteng tifri aregii, “Yau mung legii.” ");
INSERT INTO hrw_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ma ri ka gatmo, “Areini tikin gii anmatam ka la kausi mil?” ");
INSERT INTO hrw_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","I e koso aregii, “Kaltu ri fotngi ini Yesus e iksi e anmongmong, ka tow ulo anmatang, ma kam tule yau una la fagu ulo anmatan dan Siloam. Biing ya la fagu, anmatang e la kausi mil.” ");
INSERT INTO hrw_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ri ka gatmo, “Kaltu a iya?” Ma i ka war, “Ya tibi parfat.” ");
INSERT INTO hrw_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Wimi ri ka onu e kaltu a anmata e baf usi re fam Farasi. ");
INSERT INTO hrw_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Yesus e terngeni e anmata e kaltu a, ine nal mongmong lo biing Sabat. ");
INSERT INTO hrw_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Iya fam Farasi ri gatmo ming, “Anmatam e kausi areini?” I e koso, “I e towfu e anmongmong ulo anmatang, ya ka fagu, ma gii, ya ka fasi una par.” ");
INSERT INTO hrw_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Fa lo re fam Farasi ri war, “Kaltu gii e tibi la ting naisa e Deo, anwarow i e tibi usi e ninis tinglo biing Sabat.” Sakle fa ri war, “Areini gii kaltu na tumtubiil ku fasi una gow e matan mok na tibou fuut aregii?” Un sangsang gii, e kep paek ri. ");
INSERT INTO hrw_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ma ri gatom famila mil e kaltu a anmata ka baf lewa, “Kaltu gii ka faliunge o, are o war lo?” Ma i ka koso, “E ta i na profet.” ");
INSERT INTO hrw_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","E tikin famu, kaltu a anmata e baf, ma gii anmata e par. Safle fan Juda ri tibi titinge lo, i gii ri kam tau ine tamow ma tinow. ");
INSERT INTO hrw_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ma ri ka gatom ru, “E tikin ini sikuamu legii? I lewa kamu ka peteng ini i e fuut tura anmata e baf? Areini gii ka fasi una par?” ");
INSERT INTO hrw_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ma tamow ma tinow ru ka koso, “Kama parfat ini i e ta sikuama, ma kama parfat ming, ini i e fuut tura anmata e baf. ");
INSERT INTO hrw_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Sakle gii, kama tibi parfat lo ini are anmata e par, ma se e fakausi mil. Gam u bom gatmo, i e sau bakir, e fasi una bou peteng tif gam.” ");
INSERT INTO hrw_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Tamow ma tinow ru war aiya, anwarow ru soke singe fan warwar kere fan Juda, ini le sese kaltu ka peteng ten ini Yesus e ta Mesaiya, riu tii ini tinglo bala felun nining. ");
INSERT INTO hrw_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","I e sangsang mung gii, iya ru ka soke ru ka peteng ini, “I e sau bakir, gam u bom gatmo.” ");
INSERT INTO hrw_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Baba e u, ri tau mil ine kaltu lewa anmata ka baf, ri ka peteng tifi, “Ou bom warkale o na anmata e Deo ini, ou peteng ine sunwar e tikin, anwarow kaltu a ka fakausi o, kemeu parfat lo ini e ta kaltu na tumtubiil.” ");
INSERT INTO hrw_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","E koso aregii, “Ya tibi parfat ini i e ta kaltu na tumtubiil tam e tam, sakle ya su parfat ini famu anmatang e baf, ma gii anmatang e sau par.” ");
INSERT INTO hrw_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ma ri ka gatmo ming, “Sa e gow lo o? Ma are e fakausi o?” ");
INSERT INTO hrw_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ma i ka koso singri aregii, “Ya sau peteng tif gam, sakle gam tibi bur ong. E tamu gam ka bur ongni mil? Ya sang ini gau bur ta fan disaipel kia ming be?” ");
INSERT INTO hrw_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Fam Farasi ri ka fotpursi aregii, “O na disaipel kia, ma kemem na fan disaipel ke Moses. ");
INSERT INTO hrw_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Kemem sau parfat ini Deo e sau peteng tife Moses, sakle kaltu a, kemem tibi parfat ini e la ting iya.” ");
INSERT INTO hrw_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Kaltu a e koso e sunwar keri aregii, “Gam gow e fan warwar kuriik sekit! Gam tibi parfat ini e la ting iya ma ka terengeni e anmatang? ");
INSERT INTO hrw_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Kiar parfat ini Deo e tibi fasi una ong singre tongge na tumtubiil, sakle i e fasi una ong singe kaltu e usi e fabur kia. ");
INSERT INTO hrw_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ting nangen sak ka muut gii, kerer tifik ong lo tikas anmata e baf, ma ti kaltu ku faliungeni ku par. ");
INSERT INTO hrw_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Le Deo enggi tibi tuleni e kaltu gii, i enggi tibi fasi una gow e ti mok.” ");
INSERT INTO hrw_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Fam Farasi ri ongni e sunwar gii ma ri ka koso aregii, “O fuut ma o ka bakir ulo bala tubiil ma areini gii o ka bala fabenge sing kemem?” Ma ri ka fufte suu ini tinglo bala felun nining. ");
INSERT INTO hrw_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesus e ong ini ri fesel suu ine kaltu a, ma biing i e la tupngeni, ka la gatmo, “O titinge lo Sikow e Kaltu?” ");
INSERT INTO hrw_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Kaltu a e gatom, “Kaltu bakir, peteng tif yau, Sikow e Kaltu e ta se, usi yau titinge lo ming.” ");
INSERT INTO hrw_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yesus ka peteng tifi, “O sau pari, i mung e kaltu a gii ka gongon sing o.” ");
INSERT INTO hrw_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Kaltu a ka war, “Taufi, ya titinge lo o.” Ma ka kiis pukungkek ma ka nining lo. ");
INSERT INTO hrw_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ma Yesus ka war, “Ya puek gii lo nal una ikse re tongge, usi le fa matmatri e baf, ri ku par ma fa matmat ri e par, ri ku kut.” ");
INSERT INTO hrw_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Fa lo fam Farasi unaisa ri ongni e sunwar kia, ma ri ka gatmo, “O bala peteng tif kemem ini kemeu ming matmatmem e kut?” ");
INSERT INTO hrw_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ma Yesus ka koso singri aregii, “Le matmatmi enggi kut, gam tibi fasi una melmel lo tubiil, sakle gii gau bou peteng ini matmatmi e par, e peteng fate ine fan tubiil kemi i aiwa.” ");
INSERT INTO hrw_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesus e war, “Ya peteng tikin tif gam, kaltu a ka tibi kau lo matangkon lo balo kere fan sipsip, ma ka su kau ilo fang galgalu, i e ta kaltu na kinkinau ma puse falek. ");
INSERT INTO hrw_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Kaltu a ka kau ilo matangkon, i e ta kaltu na efefe kere fan sipsip. ");
INSERT INTO hrw_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Efefe lo matangkon e ipki e matangkon fasapa e kaltu a. Kaltu a e tau ire fan sipsip kia tibom lo asasri ma ri ka ongen failmi e angkiimkiim aiya. Ma i ka famu iri, ri ka suu. ");
INSERT INTO hrw_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Biing e unsuu iri, e la famu iri ma ri ka usi, anwarow ri ongen failmi. ");
INSERT INTO hrw_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ri tibi fasi una usi e tikas kuriik, riu finngeni, anwarow ri tibi ongen failmi e angkiimkiim aiya.” ");
INSERT INTO hrw_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesus e tow e sunwar toftof gii tifri ma ri ka tibi parfailmi. ");
INSERT INTO hrw_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ma Yesus ka war ming, “Ya peteng tikin tif gam. Yau tibom ya na matangkon kere fan sipsip. ");
INSERT INTO hrw_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Fa ri puek famu i yau, ri ta tongge na kinkinau, ma puse falek, ma fan sipsip ri tibi fasi una ong sing ri. ");
INSERT INTO hrw_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Yau, yau tibom ya na matangkon. Sese kaltu ka kaulek ilo yau, i eu mel e ninliu bingne. Riu kau, ma riu suu, ma riu kepe konona tuan. ");
INSERT INTO hrw_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Kaltu na kinkinau e tibi fespuek una gow e tikas ti mok ming. E tam. I e fespuek una kinau, paketmet, ma bero, sakle yau, ya fespuek usi riu mel e ninliu, ma ninliu gii, eu fuunuf tikin ilo ri. ");
INSERT INTO hrw_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Yau tibom ya na konona efefe kere fan sipsip. Ma konona efefe kere fan sipsip, eu tow e ninliu kia tibom una met una ules ri e fan sipsip kia. ");
INSERT INTO hrw_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Safle kaltu na mus lo sakle mani, e tibi ta konona efefe ma tamow e fan sipsip. Biing eu pari e pol rokai eu puek, i eu finngeri ma pol rokai a ku tebek ri ma ku fesel falek iri. ");
INSERT INTO hrw_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Kaltu a eu finnge re fan sipsip, anwarow i e su sang use mani, e tibi sang usi re fan sipsip. ");
INSERT INTO hrw_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Yau tibom ya na konona efefe kere fan sipsip. Ya parfat lo ri ma ri parfat lo yau. ");
INSERT INTO hrw_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","E su ngo aregii Tabuung e parfat lo yau, ma ya parfat lo Tabuung, ma yau tow e ninliu kiang tibom una met una ules re fan sipsip. ");
INSERT INTO hrw_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","E mel e fanenger fan sipsip kiang ming, sakle ri tibi ta tinglo bala galu gii. Ya samusu un ri ming, ri ku sa ongni e ngusung, usi riu puek ku tikii lo ri, ma ku tikii efefe keri. ");
INSERT INTO hrw_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Tabuung e bur yau tikin, anwarow yau tow e ninliu kiang tibom una met, usi yau fasi una kep famila mil. ");
INSERT INTO hrw_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","E tek ti kaltu e fasi una kepe e ninliu kiang, e tam. Lo fabur kiang tibom, ya tow e ninliu kiang una met. E mel e miang una tow e ninliu kiang tibom una met, ma una kep famila mil. Tabuung e peteng tif yau ini ya samusu gow aregii.” ");
INSERT INTO hrw_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Lo sunwar gii fan Juda ri ka tapot ka u lo ri. ");
INSERT INTO hrw_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Fa fuunfuun ri war, “Tara saksak ilo, igii ka lomba. Usi e tamu gam ka ongni e sunwar kia?” ");
INSERT INTO hrw_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Fa ri war, “Sunwar gii e tibi ta ke kaltu tara saksak ilo. Tara saksak, e tibi fasi una ipki e anmatang kaltu e kut.” ");
INSERT INTO hrw_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Lo biing a, e ta Biing Bakir una Sangfi e biing ri Fakalkaliisngeni mil e Felun Nining Bakir. Biing a e puek una Jerusalem, lo pansumbiing lo anmair, ");
INSERT INTO hrw_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","ma Yesus e ta ulo bala Felun Nining Bakir. I e fesfes lala ulo galum fel ri fotngi ini Galum fel ke Solomon. ");
INSERT INTO hrw_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Fan Juda ri ti liflifti, ma ri ka gatmo, “Are eu bi la ngo e male ma o kamu peteng ten tif kemem ini o se tikin? E sam ta o na Mesaiya? E kausi ini o samusu peteng ten tif kemem.” ");
INSERT INTO hrw_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ma Yesus ka koso aregii, “Ya sau peteng tif gam, sakle gam tibi titinge. Fan mara mus ya gow lo asow e Tabuung, e fanangsi ini yau se tikin. ");
INSERT INTO hrw_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Gam tibi titinge lo yau, anwarow gam tibi ta gam na fan sipsip kiang. ");
INSERT INTO hrw_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Fan sipsip kiang ri ongni e angkiimkiim aiyang, ma ya parfat lo ri, ma ri ususi yau. ");
INSERT INTO hrw_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ya tow e ninliu bingne tifri, ma riu tibi fasi una tam iri. E tek ti kaltu e fasi una kepufri tinglo limang. ");
INSERT INTO hrw_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Tabuung e sam tauf ri tif yau, ma i e bakir iyat ine mara mok, aregii, e tek ti kaltu e fasi una kepuf ri tinglo limow e Tabuung. ");
INSERT INTO hrw_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Yau ma Tabuung, e tikii lo kama.” ");
INSERT INTO hrw_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Biing fan Juda ri ongni e sunwar kia, ri ka sele fatfat mil una rangu ini. ");
INSERT INTO hrw_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ma Yesus ka war singri aregii, “Ya sau fanangsi gam ine fan mok fuunfuun na tibou fuut singe Tabuung. Nafow e sese neng lo re fan mok na tibou fuut gii ya gow, iya gam ka bala rang yau tura ine fatfat?” ");
INSERT INTO hrw_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ma fan Juda ri ka koso singi aregii, “Kemem tibi sang use mok na tibou fuut, e tam. Kemeu pari ini o fotpursi e Deo, i gii, kemem ka bala rang o ine fatfat. Anwarow o su ta kaltu ma o ka bala kepe tafu e Deo.” ");
INSERT INTO hrw_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yesus ka koso aregii, “Ilo fafanau ke Deo, e mel e sunwar aregii, ‘Ya sau peteng ini gam na fan deo.’ ");
INSERT INTO hrw_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Famu Tabuung e sam sesngeni e sunwar tifre tongge, ma ka war singri, ‘gam na fan deo’, (ilo bala sunwar pepe e ti ngo kuriik). ");
INSERT INTO hrw_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Sakle yau, Tabuung e fatarawennge yau ma ka tule yau wagii wilo nal, iya, ya ka peteng ini, ya na Sikow e Deo. Ma areini gii gam ka peteng ini ya fotpursi e Deo? ");
INSERT INTO hrw_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Le yang gi tibi musngeni e fam faim ke Tabuung, e fasi ini gam u tibi titinge lo yau. ");
INSERT INTO hrw_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Sakle ya gow e fam faim ke Tabuung. Le gam ku tibi titinge lo yau, gam u titinge lo mok na tibou fuut, usi gam u parfat ini, Tabuung e melmel ilo yau, ma ya melmel ilo Tabuung.” ");
INSERT INTO hrw_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ri bala puse famti mil, sakle e ifit iri ka la. ");
INSERT INTO hrw_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ma Yesus ka la mil, e kaupakti e dan Jodan, i e la puek ulo male gii Jon ka gugu tarawen ire tongge ulo famu ma ka melmel wa. ");
INSERT INTO hrw_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ma tongge fuunfuun ri puek talo, ma ri ka war, “E tikin, Jon e tifik gow e ti mok na tibou fuut, una ta tintof una farawasngeni e sunwar kia. Sakle fan mara warwar Jon e peteng ini lo kaltu gii, e tikin sekit.” ");
INSERT INTO hrw_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ma ulo male a, tongge fuunfuun sak ri titinge lo Yesus. ");
INSERT INTO hrw_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Nenge kaltu asow gii Lasarus, i tingna Betani ma e mase. Betani e ta male ke Maria ma kisilik. Asow e kisilik gii Marta. ");
INSERT INTO hrw_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Fefin gii Maria, i mung lewa ka tipeni e wel ulo kekow e Yesus ma ka si kamas ine ololow. Ma Lasarus, i gii ka mase e ta fefnelik e Maria. ");
INSERT INTO hrw_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","La kisilik gii ru kam tuleni e sunwar tife Yesus aregii, “Taufi, kaltu gii o ka burbura tibom e mase.” ");
INSERT INTO hrw_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Biing Yesus e ongni e sunwar a, i ka koso, “Anminse gii e tibi ta ini una gow e kaltu a ku met, e tam. Anminse gii e ta una fanangsi e rawas ke Deo, ma tongge nano ri ku katfarsi e Deo. Ma lo sal mung gii, Sikow e Deo eu kepe e as bakir.” ");
INSERT INTO hrw_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesus e bura sak e Marta ma kisilik, ma Lasarus. ");
INSERT INTO hrw_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Safle biing i e ongni e sunwar lo Lasarus ini e mase, i e tibi sa la saupe. I e bi melmel wa lo e u e pansumbiing. ");
INSERT INTO hrw_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Wimi kau peteng tifre fan disaipel kia aregii, “Kiar u la mil ilo prowins Judia.” ");
INSERT INTO hrw_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ma fan disaipel kia ri ka war singi aregii, “Titsa, pansumbiing famu fan Juda ri bala rang o ine fatfat, ma o ka bur la mil ilo male a?” ");
INSERT INTO hrw_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ma Yesus ka koso singri aregii, “Ya sang ini e mel e tikii sangful ma e u na anmatam pisii ilo bala tikii biing be? Le kaltu ka fes lo siat, i e tibi fasi una luut, anwarow e pare anten lo nal. ");
INSERT INTO hrw_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Safle kaltu a ka fes lo panambiing, i eu luut, anwarow e tek ti anten ilo.” ");
INSERT INTO hrw_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yesus e war singri ming aregii, “Fenngorer Lasarus e masun. Sakle yau la, ya ku la fongni mil.” ");
INSERT INTO hrw_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ma fan disaipel kia, ri ka koso aregii, “Taufi, le ka masun, anminse lo e fasi una rop ma ku fespuek kausi mil.” ");
INSERT INTO hrw_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Fan disaipel kia ri tibi parfat ini Yesus e peteng tifri ini Lasarus e sau met. Ri sangfi ini Yesus e peteng tifri ini Lasarus e su masun. ");
INSERT INTO hrw_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Kala Yesus ka peteng ten tifri, “Lasarus e sau met. ");
INSERT INTO hrw_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Sakle ya sang usi gam, ma ya fefeal ini ya tibi ta unaisa, usi gam u titinge. Ma gii, kiar u la usi.” ");
INSERT INTO hrw_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tomas, (nenge asow ming Didimus) i e war sing e fan taltalu, “Kerek minami e titsa, usi kiar u la met tiim tura.” ");
INSERT INTO hrw_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Lo biing Yesus e la puek, e ong ini e sau fet e biing ine Lasarus ulo bala ampolo. ");
INSERT INTO hrw_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betani e su fatatu e Jerusalem, e ngo are e tuul e kilomita. ");
INSERT INTO hrw_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Fuunfuun lo fan Juda ri puek una pete balamas ine Marta ma Maria nami e minet lo fefnelik ru. ");
INSERT INTO hrw_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Biing Marta e ong ini Yesus e fesfes lala uwa ulo sal, i ka la una la tongtong ini. Safle Maria i uwa ulo fel. ");
INSERT INTO hrw_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ma Marta ka peteng tife Yesus aregii, “Taufi, enggi ta o wagii, fefneklik enggi tibi met. ");
INSERT INTO hrw_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Sakle gii ming, ya parfat ini Deo eu tow e sese mok tifo le o ku nining usi.” ");
INSERT INTO hrw_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ma Yesus ka war singi aregii, “Fefnemlik eu matet mil.” ");
INSERT INTO hrw_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta ka koso singi aregii, “Ya parfat ini lo biing muut, lo biing a tongge nano ri ku matet mil, i ming eu matet mil.” ");
INSERT INTO hrw_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ma Yesus ka war singi aregii, “Matet mil e ta yau tibom, ma ninliu e ta yau tibom. Sese kaltu a ka titinge lo yau ma ka met, i eu melmel ilo ninliu bingne. ");
INSERT INTO hrw_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ma sese kaltu a ka liuliu gii wa, ma ka titinge lo yau, i eu tibi met, i eu melmel ilo ninliu bingne. O titinge lo sunwar gii, tam e tam?” ");
INSERT INTO hrw_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ma Marta ka koso aregii, “Yow Taufi, ya titinge lo o, o na Mesaiya, Sikow e Deo, se Deo e sau peteng ini eu tuleni wagii wilo nal.” ");
INSERT INTO hrw_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Wimi Marta e la mil ka tau ine kisilik Maria ma ka peteng borong tifi, “Titsa igii, ma e gatgatom i o.” ");
INSERT INTO hrw_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Biing Maria e ongni e sunwar a, i e matet saupesak una la pari e Yesus. ");
INSERT INTO hrw_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yesus e tifik puek ulo male a, i uwa ulo male gii Marta ka tongeni ulo. ");
INSERT INTO hrw_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Fan Juda lewa ri ka sa la una sa pete balamas iru, ri ulo bala fel, tiim tura Maria. Ri pari e Maria e matet saupesak ka su una male, ri ka minami, anwarow ri sangfi ini i e bala la teng ulo matmat. ");
INSERT INTO hrw_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Maria e la fespuek ulo male Yesus ulo ma ka pari e Yesus, e kiis punungkek lo fow e kekow e Yesus ma ka war, “Taufi, enggi ta o wagii, fefneklik enggi tibi met.” ");
INSERT INTO hrw_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Biing Yesus e pari e Maria tiim tura fan Juda gii ri ka mi nami ri fatengis bakir sak, bala e la kuuluung ming singri, sinangu ma tangow ru tibi ngo kausi. ");
INSERT INTO hrw_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ma Yesus ka gatom ri, “Gam towfu iya?” Ma ri ka koso aregii, “Taufi, kasa o ku sa par.” ");
INSERT INTO hrw_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yesus ka teng. ");
INSERT INTO hrw_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Fan Juda ri pari ma ri ka war, “Pari, i e bura sak e kaltu gii.” ");
INSERT INTO hrw_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Safle fa ri war, “Kaltu gii e ipki e anmata e kaltu e kut ka par mil, ma anwarow lo sa gii ka tibi fasi una ulsi e Lasarus usi eu tibi met?” ");
INSERT INTO hrw_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ulo sinangu e Yesus e tibi ngo kausi, ma ka la ulo matmat. Ma matmat a, ulo balamfam, e mel e fat bakir e kiisiim kaleni e anmatow. ");
INSERT INTO hrw_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ma Yesus ka war, “Kepufu e fumfat bakir a.” Ma Marta fefnelik e kaltu a ka met, ka war singe Yesus aregii, “Taufi, e sau fet e biing e ngo ulo balamfam ma sanow e sam nul mapu.” ");
INSERT INTO hrw_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ma Yesus ka war singi aregii, “Areini, ya tifik peteng tifo lewa ini, le o ku titinge ou pari e rawas bakir ke Deo?” ");
INSERT INTO hrw_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ri kepufu e fumfat a. Ma Yesus ka par wiyat ma ka war, “Ya aro sing o Tabuung anwarow o ong sing yau. ");
INSERT INTO hrw_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ya parfat ini o ongongne sing yau bingne, sakle ya war aregii usi ini tongge gii riu titinge ini o mung gii o ka tule yau.” ");
INSERT INTO hrw_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Wimi ine Yesus e war, e tau bakir, “Lasarus, suu una male.” ");
INSERT INTO hrw_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Lasarus e matet ma ka suu una male. Limow, kekow ma mata ri afti ine laplap, ma Yesus ka war singri, “Kepufu e fan laplap tinglo ma gam ku tafu ku la.” ");
INSERT INTO hrw_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Fuunfuun lo re fan Juda lewa ri ka puek una sa pete balamas ine Maria ri pari e sese mok Yesus e gow ma ri ka titinge lo. ");
INSERT INTO hrw_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Sakle fa lo ri la use fam Farasi ma ri ka la peteng tifri ine sese mok Yesus e sau musngeni. ");
INSERT INTO hrw_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Aregii fam pris lamlam ma fan Farasi ri ka sa tiim tura fang kaonsiil, ma ri ka sa fawar aregii, “Kiar ku gow e sa gii? Kaltu gii e gow e fan mok na tibou fuut. ");
INSERT INTO hrw_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Le kiar ku par tafu tura fan mus kia, tongge nano riu titinge lo, ma fan Rom ri ku bero ine Felun Nining Bakir kerer ma galung kaltu kiar.” ");
INSERT INTO hrw_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Sakle neng falifu lo ri, asow gii Kaiyafas e ta Paklu re fam Pris lo bala matamfaim a, e war singri aregii, “Gam tibi parfat lo ti mok. ");
INSERT INTO hrw_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Gam tibi par failmi ini e kausi sak ini tikii ti kaltu e samusu met una keptafu re tongge nano, are tongge kiar ri ka tup?” ");
INSERT INTO hrw_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kaiyafas e tibi war ine sunwar a use sangsang kia tibom, e tam. Anwarow i e ta Paklure fam Pris lo bala matamfaim a, aregii ka warfot lo Yesus ini e samusu met use re fan Juda. ");
INSERT INTO hrw_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ma eu tibi met use re fan Juda tibom, e tam. I eu met una keptiim ire fan siksikow e Deo ri melmel falek, ini ku tikii lo ri. ");
INSERT INTO hrw_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Lo pansumbiing a ka la, ge lamlam lo re fan Juda ri kiis tiim, ri ka fagati e ti sal una mu pakti e Yesus. ");
INSERT INTO hrw_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Aregii Yesus e am tibi fes na malal na balre fan Juda, e la kosnge male a, ka la u fatatu e male mas, ulo siti asow gii Efraem. Uwa e la melmel tiim tura fan disaipel kia. ");
INSERT INTO hrw_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Biing, Biing Bakir na Kepsiliwi e sau fatat, tongge fuunfuun ri melmel falek, ri sa tiim una Jerusalem una pete kalkaliis iri ususi e ninis kere fan Juda. ");
INSERT INTO hrw_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ri siksik ine Yesus, ma ri ka fagatomnge faliu iri tibom ulo bala balo lo Felun Nining Bakir, “Are gam sang? I eu sa la lo Biing Bakir gii, tam e tam?” ");
INSERT INTO hrw_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Fam pris lamlam ma fam Farasi ri sau peteng fate tifre tongge aregii, “Le se lo gam ka parfat ini Yesus iya, e kausi ini e samusu peteng fate kemem usi kemem u towfu ilo rerek.” ");
INSERT INTO hrw_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","E on e biing famu ine Biing Bakir na Kepsiliwi, Yesus e la una Betani, e ta male ke Lasarus, kaltu lewa Yesus ka famtet famila kosnge minet. ");
INSERT INTO hrw_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ri gow e en bakir ulo male a una fagasgasngeni e Yesus. Marta e faseni e fan tuan lo re tongge, ma Lasarus e la kiis tiim tura Yesus ulo fate na en. ");
INSERT INTO hrw_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Wimi Maria ka kepe e sanda ri fotgni ini nard, mata e kanak sak. I e mofo e ungkekow e Yesus ini, ma kam denge ine ololow. Sanow e sanda gii e seungeni kiruur e bala fel a. ");
INSERT INTO hrw_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Sakle tikii neng lo re fan disaipel kia, asow gii Judas Iskariot. I e ta kaltu gii kamu solamufu e Yesus, e war aregii, ");
INSERT INTO hrw_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“E tamu kiar ka tibi umat ine sanda gii, ma mani lo kiar ku tow tifre fan sasngal? Mata e kanek sak, e fasi lo fimfiil ke kaltu lo tikii matamfaim.” ");
INSERT INTO hrw_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Judas e tibi tengis re fan sasngal, gii ka war aiya, le anwarow, i e ta kaltu na kinkinau. Ma ming i e efe lo tang na mani keri, ma e kinkinau ming tinglo bala. ");
INSERT INTO hrw_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Wimi Yesus ka war singi, “On towfu e tiner a, e sam ta ilo fagati ini fefin gii eu efe lo sanda a, ku la muut lo biing riu of yau. ");
INSERT INTO hrw_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Fan sasngal riu melmel bingne tura gam, sakle yau tibi melmel bingne tura gam.” ");
INSERT INTO hrw_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Tongge fuunfuun tingna Juda ri ong ini Yesus una Betani. Ri ka la una la pari. Sakle ri tibi la una su la pari e Yesus tibom, e tam, ri parfat ini famu Yesus e sau famtet famila e Lasarus tinglo matmat, iya ri ka la una la pari ming e Lasarus. ");
INSERT INTO hrw_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Aregii, fam pris lamlam ri ka fagati e sunwar una paketmeteni e Lasarus ming, ");
INSERT INTO hrw_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","anwarow fa fuunfuun lo re fan Juda ri sangfi e mok Yesus e gow lo Lasarus. Ri ka la kosing re fam pris ma ri ka titinge lo Yesus. ");
INSERT INTO hrw_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Lo biing usi, tongge fuunfuun gii ri sa la wilo en a, ri ong ini e sau fatat ma Yesus ku la puek ina Jerusalem. ");
INSERT INTO hrw_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ri ka kepe fan aum baibai, ri ka la una la tongeni ma ri ka tautau lala, “Akteni! Deo e warfakausi e se e puek lo asow e Taufi! Deo e warfakausi e King kere fan Israel!” ");
INSERT INTO hrw_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ma Yesus ka kepe e dongki fuu ma ka kiis ulo, aregii ri kabuk siitufu ilo buk ke Deo. ");
INSERT INTO hrw_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Gam na tongge tingna Saiyon, gam u tibi soke, par, king kemi gii ka puek, i e kiis ilo dongki fuu.” ");
INSERT INTO hrw_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Famu fan disaipel kia ri tibi sangseni e bala e fan mok gii. Sakle wimi lo biing Deo e faswenu e Yesus, iya ri kau parfat a ini ri sam siitufu nafow, ma ming ri sam gow e fan mok gii lo Yesus. ");
INSERT INTO hrw_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Tongge fuunfuun ri wa tura Yesus ri sau pari e mok Yesus e gow, i e tau ine Lasarus ma ka famtet famila tinglo matmat, iri mung gii ri ka sesuupuek ine fan mok Yesus e gow. ");
INSERT INTO hrw_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Tongge fuunfuun ri ka ong lo ini Yesus e gow e mok na tibou fuut a, iya ri ka la tongtong ini. ");
INSERT INTO hrw_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Lo biing a, fam Farasi ri ka pari ma ri ka fawar falifu iri tibom aregii, “Pari, mok le kiar ka bura ini kiar u gow, e am tibi fasi ini kiar u fawetu, anwarow tongge nano ri sam la nami.” ");
INSERT INTO hrw_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Biing a ming, e mel e fa lo re fang Grik una balre tongge ri la fespuek una la nining lo Biing Bakir a. ");
INSERT INTO hrw_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Fang Grik a ri ka la use Filip, i e ta kaltu tingna Betsaida ina Galili. Ri ka la gatmo aregii, “Kaltu bakir, kemeu bura ini kemem u pari e Yesus.” ");
INSERT INTO hrw_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filip ka la peteng tife Enru. Iya Enru ma Filip ru kam la peteng tife Yesus. ");
INSERT INTO hrw_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ma Yesus ka koso aregii, “Biing e sau puek una faswenu e Sikow e Kaltu. ");
INSERT INTO hrw_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ya peteng tikin tif gam, le ti amfingwan wit ku tibi luut ilo nal ma ku tibi met, i tibom eu su ngosok aiya. Safle, le ku met, i eu fira fuunfuun. ");
INSERT INTO hrw_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Le kaltu ka bura sak e ninliu kia i eu filiwi. Sakle kaltu e ta mi usi e ninliu kia gii lo nal, i eu kepe ninliu bingne. ");
INSERT INTO hrw_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Se a ka bura una gow e fam faim kiang, i e samusu mi nami yau, ma ilo male ya melmel ilo, kaltu na faim kiang ming eu la melmel tura yau ilo. Se a ka gow e fam faim kiang, Tabuung e mu resngeni.” ");
INSERT INTO hrw_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Yesus e war ming aregii. “Gii balang e mafet sak. Ma areini gii ya ku war? Ya sang ini yau war aregii, ‘Tabuung, ong kepufu e biingsak gii ku fespuek talo yau’? E tam. Yau tibi war aiya. Biing una kepe mafet e samusu tonge yau. I e anwarow mung gii ya ka sa la. ");
INSERT INTO hrw_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tabuung, faswenu e asam.” Kala neng e angkiimkiim ka pu tinglo balambat ka war aregii, “Ya sau faswenu e asang ma ya mu faswenu ming.” ");
INSERT INTO hrw_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Tongge ri titi fatat ri ongni e sunwar a ma ri ka war, ampararak e pow, ma fa ri ka peteng ini anggelo e gongon singi. ");
INSERT INTO hrw_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Yesus e koso aregii, “Sunwar gii e ta una ules gam. E tibi ta ini una ules yau. ");
INSERT INTO hrw_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Igii e biing una anganggon singre tongge tinglo nal. Ma gii eu tii ine efefe tinglo nal ku la. ");
INSERT INTO hrw_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Sakle yau, lo biing riu sek kanek i yau tinglo nal, i e biing a, yau kep re tongge nano ri ku sa la usi yau.” ");
INSERT INTO hrw_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yesus e war aiya una fanangsi e sese matan minet, i eu met ini. ");
INSERT INTO hrw_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Wimi tongge ri ka war singi, “Kemem sam ongni e sunwar aregii tinglo fafanau ke Deo, ini Mesaiya eu melmel bingne, ma e tamu gii o ka peteng ini ‘Sikow e Kaltu riu sek kanek ini’? Ma se gii Sikow e Kaltu?” ");
INSERT INTO hrw_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ma Yesus ka peteng tifri aregii, “Gam u melmel ilo anten lo borom pansumbiing. Ma gii, lo biing anten kemi e ta iwa tura gam, gam samusu fes ilo, are anor ka tafing gam. Kaltu e fes ilo anor, i e tibi parfat ini e lala wiya. ");
INSERT INTO hrw_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Gii anten e melmel aiwa tura gam, gam samusu titinge lo, usi gam u puek ku ta fan siksikow e anten.” Biing Yesus e sam gongon tikii singre tongge a, i e la kosing ri, ka la keskum iri. ");
INSERT INTO hrw_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ri sau pari e gow e fan mok na tibou fuut, sakle ri tibi titinge lo. ");
INSERT INTO hrw_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Mok gii e ta una fawetu e warwar ke profet Aisaiya. “Taufi, se e sam titinge lo sunwar kemem? Ma Taufi e sau fanangsi e fan rawas na limow tife se?” ");
INSERT INTO hrw_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ri tibi fasi una titinge lo Yesus, anwarow, profet Aisaiya e war ming aregii, ");
INSERT INTO hrw_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Deo eu fakuta e matmat ri, ma ku gow e sinsinangu ri ku kut, usi matmat ri eu baf ma ri ku tibi par ti mok, ma balbalri ku tibi parfat lo, are ri ka iksi e balbalri ma ri ka mil, ri ka sa liu mil.” ");
INSERT INTO hrw_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aisaiya e peteng ine mok gii, le i e pari e finaswen ke Yesus, gii i ka warwar lo. ");
INSERT INTO hrw_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","E tikin e fuunfuun lo re tongge lamlam kere fan Juda ri titinge lo Yesus. Sakle ri soke re fam Farasi, gii ri ka tibi petpeteng ini na matfuun are ri ka kalafe ri tinglo felun nining keri. ");
INSERT INTO hrw_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ri bura sak ini tongge riu resngeni e asasri. Ri tibi bura ini Deo eu resnge ri. ");
INSERT INTO hrw_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Wimi Yesus ka tau bakir, “Biing kaltu e titinge lo yau, i e tibi titinge lo yau tibom, safle i e titinge ming lo Tabuung se e tule yau. ");
INSERT INTO hrw_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Biing i e par yau, i e pari ming e Tabuung, se e tule yau. ");
INSERT INTO hrw_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ya sam sa la gii lo nal are anten, usi ini tongge ri titinge lo yau, riu tibi melmel ilo anor. ");
INSERT INTO hrw_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Se a ka ongni e sunwar kiang ma le ka tibi usi, yau tibi anganggon singi. Ya tibi fespuek are kaltu na anganggon singre tongge tinglo nal, e tam. Ya puek una faliungeri. ");
INSERT INTO hrw_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Sakle kaltu ka fin kosing yau, ma ka tibi ongne ma usi e fan warwar kiang, eu mel e anganggon una ikseni. Sunwar ya fabeku i e mu ta anganggon ke kaltu a, lo biing muut. ");
INSERT INTO hrw_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ya tibi war ine fan warwar gii ususi sinangung tibom. E tam, Tabuung se e tule yau, i tibom e peteng tif yau ine fan mara warwar ya samusu war ini ma are ya samusu war ini. ");
INSERT INTO hrw_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ya parfat ini sunwar ke Tabuung i e tow e ninliu bingne. Sese sunwar ya peteng ini, e su ta sunwar Tabuung e peteng tif yau ini yau war ini.” ");
INSERT INTO hrw_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Famu ine Biing Bakir na Kepsiliwi Yesus e sau parfat ini biing kia e sau fespuek ma ku la tinglo nal ma ku la mil use Tamow. E buri tikin e tongge kia gii ri ka melmel gii lo nal, ma e bur ri tikin ka la muut lo rorop. ");
INSERT INTO hrw_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Lo efef ri niil na en, Satan e sau fafonsi e bala e Judas Iskariot sikow e Saimon, usi eu solamufu e Yesus. ");
INSERT INTO hrw_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesus e sau parfat ini Tamow e sam tow e mara mok nano ilo limow, ma e parfat ming ini Deo e tuleni ma eu la mil use Deo. ");
INSERT INTO hrw_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Yesus e matet kosnge fan tuan ka kepufu e kolos tapak kia, ma ka diidiit ine taol. ");
INSERT INTO hrw_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Wimi ka tipeni e dan talo bala dis, ma kam tofnge una gua e kekekre fan disaipel, ma kam denge lala ine taol e diidiit ini. ");
INSERT INTO hrw_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ka la use Saimon Pita, ma Pita ka gatmo, “Taufi, o bala gua e kekeng?” ");
INSERT INTO hrw_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ma Yesus ka koso aregii, “Mok ya bala gow ou tibi ten usi gii, sakle wimi o mu ten lo.” ");
INSERT INTO hrw_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ma Pita ka peteng tifi aregii, “Ou tibi gua e kekeng, e tam sekit.” Wimi Yesus ka koso e ke sunwar aregii, “Le ya ku tibi gu o, e tibi fasi ini ou melmel tura yau.” ");
INSERT INTO hrw_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ma Saimon Pita ka peteng tifi, “Taufi, le ku ta aiya ou tibi gua e safle kekeng. O samusu gua e limang tiim tura paklung.” ");
INSERT INTO hrw_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ma Yesus ka peteng tifi, “Kaltu e sau fagu, eu tibi fagu ming. I eu su gua e safle kekow ma kabung kalkaliis sekit, ma gam sam kalkaliis, sakle ya tibi peteng ini gam nano.” ");
INSERT INTO hrw_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yesus e sau parfat lo kaltu eu solamufu, iya kau peteng tifri ini, “E tibi ta gam nano gam kalkaliis.” ");
INSERT INTO hrw_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Yesus e sam gu tekeni e kekekri ma ka los mil lo kolos kia, ma ka kiis ma ka gatom ri aregii, “Gau parfat ming lo anwarow e mok gii ya ka gow lo gam? ");
INSERT INTO hrw_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Bingne gau foteng yau ini titsa ma Taufi, ma e kausi gam ka war aiya. Ya na titsa ma ya na Taufi kemi. ");
INSERT INTO hrw_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ya na Taufi ma ya na titsa ya gua e kekekmi, usi gau ming gam u gua e kekekmi falifu lo gam. ");
INSERT INTO hrw_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ya fanangsi gam ine sinang gii, usi gau ming gam u gow aregii ya ka gow lo gam. ");
INSERT INTO hrw_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ya peteng tikin tif gam, kaltu na faim e tibi kulfi e kaltu bakir kia, tam kaltu gii neng ka tuleni una gow e faim, e tibi kulfi e kaltu a ka tuleni. ");
INSERT INTO hrw_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Gii gam sau parfat lo anwarow e sangsang lo mok gii ya ka gow, ma le gam ku usi, Deo eu warfakausi gam. ");
INSERT INTO hrw_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Ya tibi peteng ini gam nano. Ya parfat lo re tongge ya sam wel ri kiang, ma ya parfat ming ini sunwar e sam ta ilo buk ke Deo eu fespuek tikin. Sunwar igii, ‘Kaltu e eni e beret tura yau, i eu elkek ine kekow una pii famti yau.’ ");
INSERT INTO hrw_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","“Mok gii e tifik fespuek ma gii ya ka peteng tif gam ini, usi lo biing eu fespuek, gam u titinge ini ya ta yau, se gii ka ta yau. ");
INSERT INTO hrw_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ya peteng tikin tif gam, kaltu e a-uu lo kaltu na faim ya tuleni, ma ka efe kausi lo, kaltu a e a-uu lo yau ma ka efe kausi lo yau. Ma kaltu e a-uu lo yau, i e a-uu lo Deo se e tule yau.” ");
INSERT INTO hrw_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesus e gon tikii ine fan mok gii, ma ulo bala e kuuluung sak, ma ka war aregii, “Ya peteng tikin tif gam, tikii neng lo gam eu solamuf yau.” ");
INSERT INTO hrw_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ri fa-alalnge iri tibom le ri tibi parfat ini Yesus e warwar lo se. ");
INSERT INTO hrw_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Neng lo re fan disaipel Yesus e bura tikin, e kiis fatatu e Yesus. ");
INSERT INTO hrw_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Saimon Pita e ares mata tife disaipel a ma ka war, “Ong gatmo ini e warwar lo se.” ");
INSERT INTO hrw_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Wimi disaipel a ka por sekit use Yesus ma ka gatmo aregii, “Taufi, o warwar lo se?” ");
INSERT INTO hrw_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ma Yesus ka koso aregii, “Kaltu gii ya ku toko e sum beret ilo bala dis ma ya ku feni ini, i e sam ta i la e kaltu ya warwar lo.” Wimi kam toko e sum beret ma ka tow tife Judas Iskariot sikow e Saimon. ");
INSERT INTO hrw_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Judas ka kepe e sum beret a, ma Satan kabuk sispi e bala. Ma Yesus kam war singi, “Sese mok o bala gow, ong gow saupe.” ");
INSERT INTO hrw_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Sakle tongge ri fafakiisnge ulo ngiin, ri tibi sangfailmi ini, anwarow lo sa gii Yesus ka war aiya singi. ");
INSERT INTO hrw_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Fan taltalu ri sangfi ini Yesus e peteng tifi ini eu la fiil ti mok e bura wilo en, tam aiya eu la tow e ti mok tifre fan sasngal, anwarow Judas e efe lo tang na mani. ");
INSERT INTO hrw_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Wimi ini e sam kepe e sum beret a, e saupesak ka suu una male. Ma e sau panambiing. ");
INSERT INTO hrw_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Biing Judas e sam suu ka la, Yesus ka war, “Geinggii Sikow e Kaltu e sam kepe finaswen, ma Deo e sam kepe finaswen singe Sikow e Kaltu. ");
INSERT INTO hrw_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Le Deo ku kepe finaswen singi, Deo tibom e mu faswenu e Sikow, ma geinggii sekit i eu fasuenu. ");
INSERT INTO hrw_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Fan siksikuang, yau melmel tura gam lo borom pansumbiing. Ma gam u sik i yau, e buk su ngo aregii ya ka peteng tifre fan Juda, ma ya ka peteng tif gam gii. Sese male yau la wilo, gam u tibi fasi una la ilo. ");
INSERT INTO hrw_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Gii ya tow e fafanau fuu tif gam aregii: Gam samusu bura e neng ma neng. Gam samusu bura e neng ma neng, aregii ya kabuk bur gam tikin. ");
INSERT INTO hrw_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Le gam ku bura e neng ma neng, sinang gii eu fanangsi re tongge nano ini gam ta fan disaipel kiang.” ");
INSERT INTO hrw_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Wimi Saimon Pita ka war singi aregii, “Taufi, o bala la iya?” Ma Yesus ka koso singi, “Male gii ya ku la ilo, o tibi fasi una la ilo nami yau gii, sakle wimi o mu mi nami yau.” ");
INSERT INTO hrw_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ma Pita ka gatmo ming, “Taufi, areini gii ya ku tibi la nami o? Ya fasi una tow e ninliu kiang una ules o.” ");
INSERT INTO hrw_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ma Yesus ka koso singi aregii, “O sang ini o fasi una tow e ninliu kiam una ules yau? Ya peteng tikin tifo, porot eu tifik teng, ma o ku fatuul peteng ini o tibi parfat lo yau.” ");
INSERT INTO hrw_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yesus e peteng ming aregii, “Gam u tibi soke ma sangfuunfuun, gam titinge lo Deo, gam samusu titinge lo yau ming. ");
INSERT INTO hrw_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ilo fel ke Tabuung, fan rum ilo e fuun ma yau la tererngeni e tafumi. Le ku tibi ta aiya, ya tibi fasi una gow e sunwar gii tif gam. ");
INSERT INTO hrw_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ma le ya ku la teregeni e male kemi, yau mil ya ku sa un gam, usi gam u la melmel tura yau, ilo male yau melmel ilo. ");
INSERT INTO hrw_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ma gam sau parfat lo sal una la ilo male gii, ya ka bala la wilo.” ");
INSERT INTO hrw_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomas e war singi, “Taufi, kemem tibi parfat ini o bala la iya, ma areini gii kemem ku parfat lo sal?” ");
INSERT INTO hrw_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ma Yesus ka koso singi aregii, “Yau tibom ya na sal, ma ya na anwarow e sunwar e tikin, ma ya na ninliu, e tek tikas eu puek talo Tabuung lo neng e sal, e tam. Safle lo yau tibom. ");
INSERT INTO hrw_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Le gam gi sau parfat lo yau, gam gi fasi una parfat ming lo Tabuung. Gii, gam sam tofnge una parfat lo, ma gam sau pari.” ");
INSERT INTO hrw_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filip e peteng tife Yesus aregii, “Taufi, fanangsi kemem ine Tamam, usi eu fawetu e fam fabur kemem ma sinsinangumem.” ");
INSERT INTO hrw_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ma Yesus ka peteng tife Filip, “Mara biing fuunfuun tikin ya melmel tura gam ma o tifik parfat lo yau, be? Se a kabuk par yau, i e sau pari e Tabuung. Usi e tamu o ka peteng ini, ‘Fanangsi kemem ine Tamam’? ");
INSERT INTO hrw_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","O tibi titinge lo ini, ya mel ilo Tabuung ma Tabuung e mel ilo yau? Sunwar ya tow tif gam, ya tibi tow ususi e sangsang kiang tibom, e tam. Tabuung e mel gii lo yau e pauti e faim kia. ");
INSERT INTO hrw_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Gam samusu titinge lo sunwar gii, ‘Ya mel ilo Tabuung, ma Tabuung e melmel ilo yau’. Ma le ku tam, gam samusu sangfi e fan mara faim ya gow, ma i mung gii ku famtete e titinge kemi. ");
INSERT INTO hrw_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ya peteng tikin tif gam, kaltu e titinge lo yau, i eu gow e fam faim are ya sam gow. Ma eu kulfi e fam faim ya gow, anwarow yau la usi e Tabuung. ");
INSERT INTO hrw_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ma sese mok gam gatom usi lo asang, yau gow usi Tabuung eu kepe finaswen singe Sikow. ");
INSERT INTO hrw_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Gau fasi una gatom yau use sese ti mok lo asang, ma ya ku fawetu.” ");
INSERT INTO hrw_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Yesus e war ming aregii, “Le gam ka bur yau tikin, gam u usi fakausi e fan warwar kiang. ");
INSERT INTO hrw_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ma ya mu gatmo e Tabuung, usi eu tow e neng e Faules una faraunge gam, usi eu melmel tiim tura gau bingne. ");
INSERT INTO hrw_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Faules gii e ta Tangwa una peteng tikin ine fan mok. Tongge tinglo nal ri tibi fasi una kepe, anwarow ri tibi pari, ma ri tibi parfat lo. Sakle gau parfat lo, anwarow i e melmel tura gam, ma i e ta ilo balbalmi. ");
INSERT INTO hrw_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ya tibi fasi una la kosing gam, ma ya ku tauf gam are fum finang, e tam. Yau mil usi gam. ");
INSERT INTO hrw_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Eu tibi baf, ma tongge gii lo nal ri ku tibi par yau. Safle gam u par yau mil. Anwarow ya liu, gam ming gam u liu. ");
INSERT INTO hrw_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Lo biing a, gam amu parfat ini ya melmel ilo Tabuung, ma gam ku melmel ilo yau, ma ya ku melmel ilo gam. ");
INSERT INTO hrw_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Kaltu e ongni e fafanau kiang ma ku usi fakausi, i e kaltu e bur yau tikin. Ma kaltu e bur yau tikin, Tabuung eu bura sak, ma yau ming yau bura, ma ya ku fafanas i yau tibom tifi.” ");
INSERT INTO hrw_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Judas, (e tibi ta ini Judas Iskariot) i e gatmo e Yesus aregii, “Taufi, areini gii o ku fafanas i o tibom tif kemem ma tongge tinglo nal ku tam?” ");
INSERT INTO hrw_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ma Yesus ka koso e sunwar kia aregii, “Le kaltu ku bur yau tikin, i eu usi fakausi e sunwar kiang. Ma Tabuung ku bura e kaltu a, ma kama ku puek usi, kama ku melmel tiim tura bingne. ");
INSERT INTO hrw_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Kaltu e tibi bur yau, eu tibi fasi una usi fakausi e sunwar kiang. Sunwar gii, gam ka ongni e tibi ta ini sunwar kiang tibom, e tam. E ta sunwar ke Tabuung, se e tule yau. ");
INSERT INTO hrw_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Ya peteng famu ine mara mok gii tif gam, lo biing ya melmel gii wa tura gam. ");
INSERT INTO hrw_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Sakle Faules tikin una farawnge gam gii, Tangwa Riis. Ma lo asang, Tabuung e mu tuleni ma i e mu fabenge sing gam lo mara mok nano. Ma i e mu famtete mil e sinsinangumi, usi gam u sagif famila e mara mok ya peteng ini tif gam. ");
INSERT INTO hrw_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Balamaris gii yau towfu tif gam, e ta balamaris kiang ya tow. Balamaris gii e tibi ngo aregii tongge gii lo nal ri towtow. Ma gam u tibi soke, ma sangfuunfuun. ");
INSERT INTO hrw_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Gam sam ongni e sunwar, ya peteng tif gam ini, ‘Yau la kosing gam, ma wimi yau mil usi gam.’ Le gam ang gi bur yau tikin, gam ang gi fefeal ini ya la mil use Tabuung, anwarow Tabuung i iyat i yau, ma e kulef yau. ");
INSERT INTO hrw_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Mok gii e tifik fespuek, ma ya ka peteng tif gam ini, usi eu fespuek, ma gam u titinge. ");
INSERT INTO hrw_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Yau tibi war fuunfuun sing gam, anwarow efefe lo nal gii, e sau bala puek. I e tek ti rawas kia una gow e ti mok lo yau. ");
INSERT INTO hrw_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Sakle ya bura ini tongge gii lo nal, riu parfat ini ya bura tikin e Tabuung. Ma ya gow e mara mok, Tabuung e peteng ini yau gow. “Kemin matet, ma kiar ku la ting wagii.” ");
INSERT INTO hrw_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Ya na au waen tikin. Ma Tabuung e ta tamow e palang na waen. ");
INSERT INTO hrw_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Eu pokufu e fang katkatow a, ka tibi firfira ine tiam firow, safle katkata a ka firfira, eu terterngeni usi eu fira fuunfuun. ");
INSERT INTO hrw_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Gam sam kalkaliis, anwarow lo sunwar ya sau peteng ini tif gam. ");
INSERT INTO hrw_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Gam samusu sok ilo yau, ma ya ku sok ilo gam, le antelen waen ku tibi sok ilo au waen, eu tibi fasi una fira, aregii, le gam ku tibi sok ilo yau, gam tibi fasi una fira. ");
INSERT INTO hrw_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Yau tibom ya na au waen, ma gam na katkatow e au waen, kaltu eu sok ilo yau ma ya ka sok ilo, i eu fira fuunfuun, ma le gam ku la kosing yau, gam tibi fasi una bom gow e timok. ");
INSERT INTO hrw_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Le kaltu ka tibi tiim tura yau, riu tii ini are anteleng kalut, ku mang, ma ri ku bastiim ini una taiif. ");
INSERT INTO hrw_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Le gam ku sok lo yau, ma sunwar kiang ku mel ailo gam, gam u fasi una gatom lo fabur ma fan mok ku fespuek aregii, gam ka bura. ");
INSERT INTO hrw_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Tabuung eu kepe e finaswen, le gam ku fira fuunfuun, ma eu fanangsi ini gam na fan disaipel kiang. ");
INSERT INTO hrw_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Tabuung e burbur yau tikin, ma lo sinang a, ya ka bur gau ming. Gam samusu melmel ilo sinang na fabur kiang. ");
INSERT INTO hrw_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Le gam ku usi fakausi e fan warwar kiang, gam u melmel ilo fabur kiang, are yau ya usi fakausi e fan warwar ke Tabuung, gii ya ka melmel ilo fabur kia. ");
INSERT INTO hrw_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Fan mok gii ya sam sesngeni tif gam, ini fefeal kiang ku mel ilo balbalmi ma ini fefeal kemi eu afit gam kiruur. ");
INSERT INTO hrw_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Fafanau kiang e ngo aregii, gam samusu bura e neng ma neng, aregii ya ka bur gam. ");
INSERT INTO hrw_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","E tek ti fabur ek bakir ine neng gii, le kaltu eu fafen ine ninliu kia tikin, usi re fam fenfenngow. ");
INSERT INTO hrw_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Gam na tanga fenfenngong, le gam ku usi e sa ya tungen gam ini. ");
INSERT INTO hrw_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Gii ya mu tibi foteng gam ini tongge na mus, e tam, anwarow kaltu na mus e tibi parfat lo fan mok kaltu bakir kia e gowgow. Gii yau foteng gam ini tanga fenfenngong, le fan mara warwar ya sam ongni singe Tabuung, iya, ya ka peteng ini tif gam. ");
INSERT INTO hrw_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Gam tibi wel yau, sakle ya wel gam, ma ya uun gam una la fira fuunfuun ine konona amfingwan au eu ngongo bingne, usi Tabuung eu tow e sa a, gam ku gatom usi lo asang. ");
INSERT INTO hrw_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ya tow e fafanau gii tif gam, gam samusu bura e neng ma neng.” ");
INSERT INTO hrw_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Yesus e war ming aregii, “Le tongge tinglo nal ri ku is gam, gam u sangfi ini famu ri is yau ming. ");
INSERT INTO hrw_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Le enggi ta gam tinglo nal, nal enggi bur gam, le gam ta fa lo ri. Safle ya sam wel gam tinglo nal ma gam tibi ta tinglo nal, iya nal ku is gam. ");
INSERT INTO hrw_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Gam samusu sagif famti e sunwar ya tow tif gam: ‘Kaltu na faules e tibi bakir iyat ine kaltu bakir kia.’ Le ri ka bur is yau, riu is gau ming. Ma le ri kabuk bingfamti e fam fabenge kiang, riu bingfamti ming e fam fabenge kemi. ");
INSERT INTO hrw_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Sakle riu gow e mara sinang saksak lo gam, le gam ta tongge kiang, anwarow ri tibi parfat lo Tabuung, se e tule yau ");
INSERT INTO hrw_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Le yang gi tibi fespuek una sa tow e sunwar tifri, gii, enggi am tek ti anwarow e fan tubiil keri. Safle gii e am tek ti sal una finufu e fan tubiil keri. ");
INSERT INTO hrw_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Kaltu e is yau, i e isa e Tabuung ming. ");
INSERT INTO hrw_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Gii le yang gi tibi melmel falifu lo ri, ma yak tibi gow e fam faim gii ka tek ti kaltu e sam gow nangen, enggi tek ti anwarow e fan tubiil keri. Safle gii ri sau pari e fam faim kiang, gii ri ka is yau tiim tura Tabuung. ");
INSERT INTO hrw_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Sinang a ri ka gow e fespuek una fawetu e sunwar ilo fafanau keri. Sunwar ri gow e ngo aregii, ‘Tongge ri is yau fofoes.’ ");
INSERT INTO hrw_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Ya mu tuleni e Faules una faraunge gam, i eu la singe Tabuung ma e mu puek usi gam. Tangwa una peteng tikin ine fan mok e mu puek tinglo Tabuung. E mu sesuupuek i yau. ");
INSERT INTO hrw_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Safle kemi ming, kemi samusu peteng ten i yau, anwarow kemi melmel tura yau, tinglo tofnge. ");
INSERT INTO hrw_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Fan mok gii ya sau peteng ini tif gam, usi gam u tibi luut kosngi e titinge. ");
INSERT INTO hrw_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Tongge riu tibi a-uu lo gam una kaulek ilo bala fam felun nining, anwarow e mel e biing e mu puek, ma tomfa riu paketmete gam. Ri kele ini ri sam gow e konona fam faim tife Deo. ");
INSERT INTO hrw_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Riu gow e fan sinang gii, anwarow ri tibi parfat lo Tabuung, ma ri tibi parfat lo yau. ");
INSERT INTO hrw_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ya sau peteng tif gam gii, usi lo biing eu puek gam amu sagif famila, ini ya sau peteng fate gam. Ya tibi peteng famu tif gam ine fan mok gii, anwarow ya melmel gii wa tura gam. ");
INSERT INTO hrw_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Gii ya la mil usi e neng gii ka tule yau. Sakle e tek tikas lo gam ek gatom yau, ini, ‘O la iya?’ ");
INSERT INTO hrw_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Anwarow lo fan mok gii ya ka sesngeni, iya balbalmi ka fuunuf ine sangkuuluung. ");
INSERT INTO hrw_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Sakle ya peteng tikin tif gam, kausi lo gam gii ini ya samusu la, usi eu mel e Faules usi gam. Ma le ya ku tibi la, i eu tibi fespuek usi gam, ma le ya ku la, yau tuleni usi gam. ");
INSERT INTO hrw_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Biing i eu fespuek eu fanangsi re tongge tinglo nal, usi riu parfailmi e anwarow e tubiil ma sinang e riis ma anganggon ke Deo. ");
INSERT INTO hrw_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Anwarow e tubiil igii, tongge ri tibi titinge lo yau. ");
INSERT INTO hrw_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Anwarow e sinang riis aregii, yau la mil use Tabuung ma gam amu tibi par yau mil. ");
INSERT INTO hrw_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ma anwarow e anganggon ke Deo gii, efefe tinglo nal, Deo e sam anganggon singi. ");
INSERT INTO hrw_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“E mel e fan warwar ming ya mel lo una peteng tif gam, safle gam tibi fasi una kepe gii. ");
INSERT INTO hrw_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Sakle biing Tangwa una peteng tikin ine fan mok eu puek, eu fabeku e mara mok e tikin. Ma i eu tibi gongon lo sinangu tibom, i eu gongon ine fan mok e ongni ma e mu peteng tif gam ine fan mok eu puek. ");
INSERT INTO hrw_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ma i e mu faswen yau, anwarow, i eu kepe fan warwar kiang, ku fabeku tif gam. ");
INSERT INTO hrw_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Fan mara mok ke Tabuung, e ta kiang. Iya, ya ka peteng ini, i eu kepe fan warwar kiang ku fabeku tif gam. ");
INSERT INTO hrw_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Eu tibi baf ma gam ku tibi par yau, sakle lo borom pansumbiing wimi, gam amu par yau mil”. ");
INSERT INTO hrw_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Fa lo re fan disaipel kia ri fawar falifu iri aregii, “Sese pimpiku e sunwar gii ka war ini? ‘Eu tibi baf ma gam ku tibi par yau, ma borom pansumbiing wimi, gam u par yau mil’, ma e war ming aregii, ‘Anwarow yau la use Tabuung’?” ");
INSERT INTO hrw_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ri ka fagatomnge falifu iri, “E ta sese pimpiku e sunwar gii, ‘Lo borom pansumbiing?’ Kiar tibi ten lo sa e peteng ini.” ");
INSERT INTO hrw_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesus e parfat ini ri bur gatmo use fan mok e peteng ini, iya, ka war singri, “Areini gam ka fagatomnge i gam usi e pimpik lo sunwar gii, ‘eu tibi baf ma gam ku tibi par yau, ma lo borom pansumbiing wimi gam amu par yau mil’? ");
INSERT INTO hrw_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ya peteng tikin tif gam, gam u teng ma sangkuuluung, sakle tongge gii lo nal riu fefeal. Gam u sangkuuluung, sakle sangkuuluung kemi eu ikis ku ta fefeal. ");
INSERT INTO hrw_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Fefin e bala fasus ine boroner, eu bi ongker, anwarow biing kia e sau puek. Sakle lo biing boroner kia kabuk fuut, fefin a e sangintafngi e ongker ma ku fefeal lo boroner e sau fuut gii lo nal. ");
INSERT INTO hrw_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","E buk su ngo are gam, gii e ta biing kemi una sangkuuluung. Sakle ya mu par famil gam ma gam ku fefeal, ma eu tek tikas eu tii ine fefeal kemi kosing gam. ");
INSERT INTO hrw_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ma lo biing a gam u tibi gatom yau usi e ti mok. Ya peteng tikin tif gam, Tabuung e mu fen gam ine sese mok gam u gatom usi lo asang. ");
INSERT INTO hrw_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ting famu ka muut gii, gam tifik gatom use ti mok lo asang. Gam samusu gatom, usi gam u kepe. Ma fefeal kemi ku fasef sekit.” ");
INSERT INTO hrw_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Yesus e war ming aregii, “Ya sam gongon sing gam lo warwar toftof, sakle wimi ya mu tibi gongon lo warwar toftof. Yau peteng ten tif gam ine Tabuung. ");
INSERT INTO hrw_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Lo biing a gam u gatom lo asang, sakle ya tibi peteng tif gam ini yau nining singe Tabuung una ules gam. ");
INSERT INTO hrw_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","E tam. Tabuung tibom e bur gam, anwarow gam sau bur yau ma gam sam titinge lo yau ini, ya puek singe Deo. ");
INSERT INTO hrw_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Famu ya la ting naisa e Tabuung, ya ka sa la ulo nal, ma gii, yau la kosnge nal, ya ku la mil usi e Tabuung.” ");
INSERT INTO hrw_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Wimi fan disaipel kia ri ka war, “Yow, o kau peteng ten a, o am tibi war lo warwar toftof. ");
INSERT INTO hrw_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Gii kemem kau parfat a ini o parfat tikin lo mara mok, o tibi nene ini tikas eu gatom o, use ti mok. Fan mok gii e gau kemem, kemem ka titinge ini Deo e tule o.” ");
INSERT INTO hrw_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yesus e koso singri aregii, “Gam kam titinge legii? ");
INSERT INTO hrw_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Sakle biing e sau bala puek ma e sau puek. Biing a, riu fesel falek i gam nano una la mil ilo fan male kemi. Ma gam ku la kosing yau, ku la ta yau tibom, sakle eu tibi ta yau tibom, anwarow Tabuung e melmel tura yau. ");
INSERT INTO hrw_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“Ya sau peteng tif gam ine fan mok gii, usi lo yau, gam u balamas. Gam u tongeni e fan mafet wagii lo nal, sakle gam u ti raw! Le ya sam kulfi e rawas tinglo nal.” ");
INSERT INTO hrw_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesus e war tikii aregii, ma kau par ulo balambat ma ka war, “Tabuung, biing e sau puek una faswenu e Sikuam, ma Sikuam eu faswen o. ");
INSERT INTO hrw_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Anwarow o sam tow e rawas tifi usi eu ta paklure tongge nano ma e mu tow e ninliu bingne tifre tongge o sam tow ri tifi. ");
INSERT INTO hrw_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","I gii e ninliu bingne: use tongge ri samusu parfat lo o, ini e su tikiin o na Deo tikin, ma lo Yesus Kristus se o sam tuleni. ");
INSERT INTO hrw_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ya sam sa faswen o wagii lo nal, ma ya sau fawetu e faim o sam tow tif yau una gow. ");
INSERT INTO hrw_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Tabuung, faswen yau tiim tura o tibom ine finaswen lewa ya ka mel lo tiim tura o, famu ine nal. ");
INSERT INTO hrw_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Ya sau fanangsi o tifre tongge o ta ri tif yau ting wagii lo nal. Iri kiam, ma o ka ta ri tif yau, ma ri sam usi fakausi e kem sunwar. ");
INSERT INTO hrw_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ma gii ri sau parfat ini fan mara mok o sam tow tif yau ini ri fespuek sing o. ");
INSERT INTO hrw_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Fan warwar o tow tif yau, ya sam tow tifri, ma ri sam kepe ma ri sau parfat tikin ini ya puek tinglo o. Ma ri titinge ini o tule yau. ");
INSERT INTO hrw_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Ya nining usi ri. Ya tibi nining use re tongge nano tinglo nal. Sakle ya nining use re tongge o sau fite ri kiang usi e ta iri kiam. ");
INSERT INTO hrw_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Fan mara mok ya mel lo e ta kiam, ma fan mara mok o mel lo e ta kiang, ma ya mu kepe singmat na faswen lo ri. ");
INSERT INTO hrw_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Gii yau sa la usi o. Ya mu tibi melmel ilo nal, sakle ri, riu melmel wagii lo nal. Tabuung, o tarawen, on efe kausi lo ri ine rawas tinglo asam. I mung e as gii o ka tow tif yau ini, usi eu su tikii lo ri are kara e su tikii lo kara. ");
INSERT INTO hrw_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Biing ya melmel tura ri, ya efe kausi lo ri ine rawas tinglo asam. I e as mung gii o ka tow ilo yau. Ya efe kausi lo ri ma e tek tikas en tam ini singe sak, sakle kaltu una tam ini i tibom eu tam ini usi sunwar pepe eu fasef. ");
INSERT INTO hrw_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Gii ya fespuek talo o, sakle ya peteng ine fan mok gii biing ya melmel gii wa ilo nal, usi fefeal kiang e mu fakausi e balbalri. ");
INSERT INTO hrw_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ya sam tow e kem sunwar tifri, sakle nal e is ri anwarow ri tibi ta tinglo nal, are yau ming ya tibi ta tinglo nal. ");
INSERT INTO hrw_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ya tibi nining sing o ini o ku tii iri tinglo nal, sakle ou kale ri kosnge tangwaner saksak. ");
INSERT INTO hrw_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","E tibi ta ini iri tinglo nal are yau ming ya tibi ta tinglo nal. ");
INSERT INTO hrw_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","O fatarawennge ri ine sunwar e tikin, anwarow kem sunwar e tikin. ");
INSERT INTO hrw_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","O sam tule yau wagii lo nal, are yau ming, ya sam tule ri una fes fawet ilo mara male gii lo nal. ");
INSERT INTO hrw_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ya fatarawennge yau usi ini iri ming riu tarawen ilo bala sunwar tikin. ");
INSERT INTO hrw_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Ya tibi nining una ules ri tibom, e tam. Ya nining usi ri ming gii, ri ku titinge lo yau lo biing ri ongni e sunwar singri, ");
INSERT INTO hrw_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","usi re tongge gii eu tikii balri, are o Tabuung o melmel ilo yau, ma ya melmel ilo o. Ma ri ming riu mel ilo kara usi re tongge tinglo nal riu parfat ini o tule yau. ");
INSERT INTO hrw_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Tabuung, finaswen o tow tif yau, ya sam tow tifri usi eu su tikii lo ri, are e su tikii lo kara. ");
INSERT INTO hrw_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ya melmel ilo ri ma o melmel gii lo yau, ma lo sangsang gii ya bura ini riu tiim tikin lo ri, usi ini tongge nano tinglo nal ri samusu parfat ini o sam tule yau ma o buri tikin, aregii o bur yau tikin. ");
INSERT INTO hrw_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Tabuung, ya bura ini tongge nano gii o kabuk tow tif yau, riu melmel tura yau ilo male gii ya ku la melmel ilo, usi ri mu pari e finaswen kiang o sam tow tif yau, anwarow o sau bur yau famu ine nal e tafik puek. ");
INSERT INTO hrw_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Tabuung, o riis fasef, tongge tinglo nal ri tibi parfat lo o. Sakle ya parfat lo o, ma tongge kiang ri parfat ini o tule yau. ");
INSERT INTO hrw_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ya sam sesuupuek ine asam tifri, ma yau tibi manau una sesngeni e asam, usi riu kepe e sinang una bura e neng e re fa, aregii o ka bur yau, ma yau melmel ilo ri.” ");
INSERT INTO hrw_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesus e ropo e nining kia ma ka matet tura fan disaipel kia ri ka kau pakti e anlau Kidron. Ulo galu e mel e palang, i tura fan disaipel kia ri ka kau ulo bala. ");
INSERT INTO hrw_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judas, kaltu gii kamu solamufu e Yesus, e parfat ming lo male a, anwarow Yesus tiim tura fan disaipel kia ri sagisu tiimtiim ulo male a. ");
INSERT INTO hrw_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Iya Judas ka famu puek ire fan soldia tura fang kaltu bakir kere fam pris lamlam ma fam Farasi ulo bala palang a. Ri kepe fam pelong ma fan lam ma fan mok na fafapaket. ");
INSERT INTO hrw_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yesus e sau parfat lo sa eu fuut lo. I ka fes sekit usi ri ka la gatom ri, “Gam sik ine se?” ");
INSERT INTO hrw_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ri ka koso, “Yesus tingna Nasaret.” Yesus ka war, “Yau gii.” Ma Judas kaltu una solamufu e sam titi fatat tura ri. ");
INSERT INTO hrw_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Biing Yesus e peteng ini, “Yau gii,” ri suaumil, ri ka la faluutnge ulo nal. ");
INSERT INTO hrw_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yesus ka gatou mil, “Gam sik ine se?” Ma ri ka peteng, “Yesus tingna Nasaret.” ");
INSERT INTO hrw_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yesus ka koso, “Ya sau peteng tif gam ini yau gii. Le gam ku siksik i yau, arik, gam tauf re tongge gii ri ku la.” ");
INSERT INTO hrw_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Mok gii e fuut aiya una fasefu e sunwar e sau peteng ini, “Ya tibi tafu e tikas lo re fa o tow tif yau ri ku tam ini.” ");
INSERT INTO hrw_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Kala Saimon Pita i e mel e ke ringgot ka efsuu ini ka sapingufu e ambalbalu miil e kaltu na mus ke Paklure fam pris. Kaltu a, asow gii Malkus. ");
INSERT INTO hrw_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Yesus ka porow e Pita, “Towfu e ringgot kiam walei! E tamu, yau tibi inmi e dan Tabuung e sam tow tif yau?” ");
INSERT INTO hrw_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ma fan soldia tiim tura kaltu bakir keri, tura fang kaltu bakir kere fan Juda ri ka bingfamti e Yesus ma ri ka kawi. ");
INSERT INTO hrw_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ri ka la tow famu tife Anas gii ka ta yanow e Kaiyafas Paklure fam pris lo matamfaim a. ");
INSERT INTO hrw_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kaiyafas i gii ka fatenu tifre tongge ini e kausi ini eu su tikii kaltu eu met somu e re tongge nano. ");
INSERT INTO hrw_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Saimon Pita ma neng e disaipel ru minami e Yesus. Neng lo ru e la nami e Yesus ulo ampalkanmale ke Paklure fam pris, anwarow Paklure fam pris e parfat lo disaipel gii. ");
INSERT INTO hrw_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Sakle Pita e nene una male lo matangkon. Nenge disaipel a, Paklure fam pris ka parfat lo, ka la mil ka la peteng tife fefin e efefe lo matangkon ine eu uun kau ine Pita. ");
INSERT INTO hrw_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Fefin a ka gatmo e Pita, “O ta neng lo re fan disaipel ke kaltu gii?” Pita ka koso, “E tam.” ");
INSERT INTO hrw_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","E mair tikin e male, ma tongge na faim fofoes, ma fang kaltu bakir a ri ka fatie liflifti e bungen a ri gow una mengii sing ri. Pita i ming tura ri, e titi ka mengmengii. ");
INSERT INTO hrw_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Sumbiing a Paklure fam pris e gatmo e Yesus usi e fan disaipel kia ma fam fabenge kia. ");
INSERT INTO hrw_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ma Yesus ka koso singri aregii, “Ya fabenge singre tongge nano na anmangmangel. Ya sagisu fafabenge ilo fam felun nining ma ilo Felun Nining Bakir gii fan mara Juda ri ka tiimtiim ilo. Ya tibi fabenge borong ine ti mok. ");
INSERT INTO hrw_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","O gatom yau una tamu? Gatom re tongge fa ri ongen yau, ma ri parfat lo fan mok ya sesengeni.” ");
INSERT INTO hrw_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Biing Yesus e war aregii, neng lo re fan soldia e titi u fatat ka posi ma ka war aregii, “E tamu o ka fasange aiya singe Paklure fam pris?” ");
INSERT INTO hrw_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yesus ka koso singi aregii, “Le ya ka war ine ti mok e tubiil, peteng ten ini tifre tongge gii. Sakle le ya ka peteng ine mok e tikin, use tamu gii o ka pose yau?” ");
INSERT INTO hrw_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Kala, Anas ka tuleni e Yesus tife Kaiyafas, i e ta Paklure fam pris, ma ri tibi pikii e amfinau ri kawi e un limow ini. ");
INSERT INTO hrw_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Pita e titi uwa ka mengmengi ulo fow e iif, ma ri ka gatmo ming, “E sam ta o na neng e lo fan disaipel ke kaltu gii?” Ma ka fapin lo, ka peteng, “E tam. E tibi ta ya na disaipel kia.” ");
INSERT INTO hrw_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","E mel e neng lo fan tongge na mus ke Paklure fam pris e ta kaltu lo kaltu gii Pita ka teseufu e ambalbalu, ka peteng tife Pita aregii, “E ngo areini ya par o ming tura ulo bala palang waleii be?” ");
INSERT INTO hrw_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pita ka fapin lo mil, “E tam.” Wimi ini, porot ka tofnge una teng. ");
INSERT INTO hrw_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Biingbiing e mok sak fan Juda ri ka onu e Yesus tinglo fel ke Kaiyafas ri ka la tura ulo fel ke Kaltu Bakir lo gapman tingna Rom. Ma fan Juda ri tibi bur kau, le ri soke are ri ka lektekentau ma ri ka tanlam anwarow ri bur kalkaliis usi riu en lo Biing Bakir na Kepsiliwi. ");
INSERT INTO hrw_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ri ka su melmel una male ini Pailat ku suu usi ri, ku sa gatom ri, “Sa gam towfu e kaltu gii ilo anganggon tura?” ");
INSERT INTO hrw_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ri ka peteng tifi, “Le enggi tibi ta kaltu na tumtubiil, kemeng gi tibi sa tow tifo.” ");
INSERT INTO hrw_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pailat ka peteng tifri aregii, “Gam onu gam ku la anganggon singi ususi e fafanau kemi.” Ri ka koso aregii, “Sakle kemem tibi fasi una paketmet ine tikas, ususi e fafanau kere fan Rom.” ");
INSERT INTO hrw_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","E fuut aregii, una fasefu e sunwar ke Yesus e sau peteng ini usi e sese matan minet eu met lo. ");
INSERT INTO hrw_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pailat ka kau mil ulo bala fel bakir a, ma ka tau kau ine Yesus ka la gatmo, “O na king kere fan Juda, be?” ");
INSERT INTO hrw_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yesus ka gatmo, “Sunwar a e ta kiam tibom? Tam eu ta tongge ri seseng tifo, i yau?” ");
INSERT INTO hrw_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pailat ka war, “O sangfi ini ya na Juda? Ma le tongge lo o ma fam pris lamlam kiam ri gii ri ka touf o tif yau, sa o gow?” ");
INSERT INTO hrw_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yesus ka peteng tife Pailat aregii, “Kepmale kiang e tibi ta ting wagii lo nal. Le kepmale kiang enggi ta ting wagii lo nal, tongge kiang ring gi sau fapaket, una fakale lo yau kosinge re fan Juda. Sakle gii kepmale kiang e ta tinglo neng e male.” ");
INSERT INTO hrw_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pailat e gatom, “E sam tikin ini o na king?” Ma Yesus ka peteng tifi aregii, “O tibom, o peteng ini ya na king. Tikin lo gii ya ka fuut gii lo nal una gow e su tikii mok gii una peteng ten ine mok e tikin. Ma se eu melmel ilo mok e tikin eu ong sing yau.” ");
INSERT INTO hrw_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pailat e gatmo, “Sa gii tikin?” Ma ka suu mil ka la peteng tifre fan Juda aregii, “Ya tibi sikseni e ti anwarow gii ya ku bero ine kaltu gii. ");
INSERT INTO hrw_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Sakle e mel e ninis kemi ini yau uun suu ine ti kaltu tinglo rerek lo biing na Kepsiliwi. Ma gii gau bura ini yau uun suu ine king kere fan Juda?” ");
INSERT INTO hrw_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ri ka tau bakir sing e Pailat, “E tam, e tibi ta i, e tam. Kemeu bura e Barabas.” Barabas e ta kaltu na fafapaket ma kinkinau. ");
INSERT INTO hrw_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Pailat ka onu e Yesus ka la ri ka la napsi. ");
INSERT INTO hrw_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ma fan soldia ri ka getiim ine amfinau soksok ma ri kam tow ulo paklu are at king ma ri ka kepe kolos tapak kaukaor ri ka tow ulo. ");
INSERT INTO hrw_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ma ri kam ti unaisa ma ri ka warwar, “Siaro, king kere fan Juda!” ma ri ka posi. ");
INSERT INTO hrw_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pailat ka fatikii suu mil ka la peteng tifre fan Juda, “Par, yau un suu ine kaltu gii tif gam ini gam ku parfat ini ya tibi sikseni e ti anwarow una towfu ilo anganggon.” ");
INSERT INTO hrw_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Biing Yesus e suu tura at king ri gow lo amfinau soksok tura kolos tapak kaukaor ulo, Pailat ka war singri, “Igii e kaltu.” ");
INSERT INTO hrw_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Sumbiing sekit a fam pris lamlam tiim tura fang kaltu bakir ri ka pari ma ri ka tau, “Tutfamti talo aupaket! Tutfamti talo aupaket!” Sakle Pailat e koso singri, “Gam onu, gam ku la tutfamti talo aupaket. Ya tibi sikseni e ti tubiil kia.” ");
INSERT INTO hrw_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Sakle fan Juda ri peteng, “E mel e fafanau kemem, ma una usi e fafanau a e samusu met anwarow e peteng ini i na Sikow e Deo.” ");
INSERT INTO hrw_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Biing Pailat e ongni aregii e la soke sak. ");
INSERT INTO hrw_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ka la kau mil ulo bala fel bakir a ka la gatmo e Yesus, “O puek ting iya?” Sakle Yesus e tibi koso singi. ");
INSERT INTO hrw_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pailat e peteng tifi, “O tibi bura una war sing yau? O tibi parfat ini e mel e raw kiang una falimuf o tam una tutfamti o?” ");
INSERT INTO hrw_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yesus kam koso a, “O tibi fasi una kepe raw una kepuf yau, le ring gi tibi tow tifo ting uyat. Ma gii kaltu gii ka ta yau ailo limam e tubiil ma tubiil kia e bakir iyat ine tubiil kiam.” ");
INSERT INTO hrw_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pailat e ongni aregii ka tofo una sik ine ti sal una falimufu e Yesus ku la. Sakle fan Juda ri tautau, “Le o ku pikufu e kaltu gii ku la, o tibi ta fenngow e Sisa. Neng e peteng ini i na king, i e isa e Sisa.” ");
INSERT INTO hrw_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Biing Pailat e ongni e sunwar gii ka un suu ine Yesus ma ka la kiis ulo sia ke kaltu na ongongni e anganggon ilo male ri fotngi ini Fatfat una Fesfes (lo warwar Aramaik ri fotngi ini Gabata.) ");
INSERT INTO hrw_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","E ta biing na fagati e fan mok lo Biing Bakir na Kepsiliwi. E ngo are tikii sangful ma e u na anmatam pisii lo siat. Pailat ka peteng tifre fan Juda, “Igii e king kemi!” ");
INSERT INTO hrw_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Sakle ri sa tautau, “Onu walei! Onu walei! Tutfamti ilo aupaket!” Pailat ka gatom ri, “Gau bura ini yau tutfamti ilo aupaket e king kemi?” Fam pris lamlam ri ka koso, “E tek ti king kemem sakle Sisa.” ");
INSERT INTO hrw_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Kala Pailat ka tow e Yesus tifri ini ri ku la tutfamti ulo aupaket. Kala fan soldia ri ka onu e Yesus ka la ulo limri. ");
INSERT INTO hrw_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","I ka kepe e aupaket kia tibom ka suu ka la ulo male ri fotngi ini Male ke Antuampaklung Kaltu (ilo warwar Aramaik ri fotngi ini Golgota.) ");
INSERT INTO hrw_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Fan soldia ri ka la tutfamti e Yesus talo aupaket ulo male a. Ma ri tutfamti e u e neng e kaltu ulo neng e e un aupaket ming tura Yesus, neng ulo galu ma neng ulo galu ma Yesus ulo falifu. ");
INSERT INTO hrw_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pailat ka seti e sunwar ka tutfamti ulo aupaket, ri seti aregii, YESUS TINGNA NASARET KING KERE FAN JUDA. ");
INSERT INTO hrw_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Fa fuunfuun lo fan Juda ri wese e sunwar a, anwarow ri tutfamti e Yesus talo aupaket ulo male e ngo fatatu e siti, ma ri seti lo warwar Aramaik, Latin, ma Grik. ");
INSERT INTO hrw_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Fam pris lamlam kere fan Juda ri wese, ri ka tibi bura ini Pailat eu seti aiya. Ri ka peteng tife Pailat, “Ou tibi seti ini ‘King kere fan Juda’, sakle ou seti ini kaltu gii e peteng ini i na king kere fan Juda.” ");
INSERT INTO hrw_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pailat e koso, “Sa ya sam seti, ya sam seti.” ");
INSERT INTO hrw_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Biing fan soldia ri tutfamti e Yesus talo aupaket ri kepe fang kolos kia ma ri ka ti ini ka fet lo. Tikii su ke tikii neng tikii neng. Ma neng e kolos tinglo pikliu ka ngosok, kolos tapak gii ri ka gow lo tikii sun laplap e tek ti mok rik soko ulo. Kolos a e kiruur ting uyat ka la muut ufaf. ");
INSERT INTO hrw_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ri ka fawar falifu iri aregii, “Kiar u tibi sipapaki, e tam. Kiar u pilai satu una sik ine se eu kepe kolos gii kia.” Mok gii e fuut aregii, usi ini sunwar pepe eu fasef. “Ri ti ine kolos kiang falifu iri, ma ri ka pilai satu una kepe fang kolos kiang.” Ma mok gii fan soldia ri gow. ");
INSERT INTO hrw_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Maria tinow e Yesus, kisilik e Maria, ma Maria wok ke Klopas, ma Maria Makdalen, ri titi fatatu e aupaket ke Yesus. ");
INSERT INTO hrw_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yesus e pari e tinow wa ma disaipel gii i ka bura tikin e titi fatat ma ka war aregii singe tinow, “Wok, sikuam gii.” ");
INSERT INTO hrw_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ma ka war singe disaipel gii, “Tinam gii.” Tinglo sumbiing a, disaipel a e onu e wok a ka la ulo ke fel. ");
INSERT INTO hrw_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Wimi i kabuk parfat ini mara mok e sau fawet sekit. Ma Yesus ka war, “Ya met dan,” usi sunwar pepe eu fasef. ");
INSERT INTO hrw_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","E mel e sospen na waen gin e kiiskiis ufaf, ri ka kepe spans ri ka tow ulo waen gin a, ma ri ka kawi talo angkatang kalut ri fotngi ini isop ma ri ka sangau ini ri ka tow ulo ngusu e Yesus. ");
INSERT INTO hrw_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yesus kabuk in lo waen gin a, ma ka war, “E sam rop sekit.” Ma ka faporo e paklu ma i e sek paket manangia. ");
INSERT INTO hrw_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","E ta biing bilse ma biing wimi ini e ta biing bakir lo Sabat. Fan Juda ri ka sa gatmo e Pailat ini riu ker pakti e kekek ri ma ri ku kepuf ri tinglo fan aupaket. Anwarow fan Juda ri tibi bura ini fong kaltu eu kulik lo aupaket lo biing na Sabat. ");
INSERT INTO hrw_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Fan soldia ri ka puek ri ka sa ker pakti e ungkekow e kaltu baba tikii a ri ka tutfamti ulo galu lo Yesus, ma ri ka kere ungkekow e neng ming. ");
INSERT INTO hrw_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Sakle biing ri sa la ri ka pari ini Yesus e sau met, ri am tibi kere e ungkekow. ");
INSERT INTO hrw_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Neng lo re fan soldia ka kepe e iu ka taba e galumfow e Yesus. Ma saupesak ka pues ine dadak ma dan. ");
INSERT INTO hrw_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ma kaltu e pari e fan mok gii e peteng ten ini, ma e parfat lo ini e peteng tikin. Ma fan mok e peteng ini e tikin sak. E seseng ini usi gau ming gam u titinge lo. ");
INSERT INTO hrw_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Mok gii e fuut usi ini sunwar pepe eu fasef, “Riu tibi kere e tikii tiantow.” ");
INSERT INTO hrw_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ma neng e sunwar pepe ming e war aregii, “Riu par ilo kaltu ri taba.” ");
INSERT INTO hrw_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Wimi Josef tingna Arimatia kasa gatmo e Pailat usi e pinumfow e Yesus. Josef e ta disaipel borong ke Yesus anwarow e soke re fan Juda. Pailat ka a-uu singi, i ka la kepe e pinimfow e Yesus. ");
INSERT INTO hrw_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodemus ka fatalnge lo. E ta kaltu lewa ka la puek talo Yesus lo panambiing, i e kepe e sanda ri iksi lo danu e un au aloes ma mira, mafet lo e ta e tuul e sangful na kilogram. ");
INSERT INTO hrw_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ru ka kepe e fow e Yesus ru kala tow e sanda ulo, ma ru kau fisi ine konona fan sisin laplap. Ru gow aregii ususi e ninis kere fan Juda una tererngeni e pinumfow e kaltu famu ma ri kamu ofo. ");
INSERT INTO hrw_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ulo male gii ri ka tutfamti e Yesus talo aupaket ulo e mel e palang fatatu, ma e mel e balamfam una totouf fan minet ulo bala palang a. Ma balamfam a e fuu uwa. Ri tifik tafu e ti kaltu e met ulo. ");
INSERT INTO hrw_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ri ka pari ini e ta biing una bilse wilo Sabat, iya ri ka tofu e Yesus ulo bala balamfam a, anwarow e su fatat ri. ");
INSERT INTO hrw_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Lo biing baba tikii lo wik Maria Makdalen e la lo biingbiing e mok tikin ulo balamfam, gii ri ka tafu e Yesus ulo, ma ka pari ini fat bakir gii ri ka dukli e matow e balamfam a ini, ri sam kepufu. ");
INSERT INTO hrw_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ka filau ka la use Saimon Pita, ma neng e disaipel neng gii Yesus ka bura sak, ka la peteng tifru, “Ri sam kepe Taufi tinglo balamfam, ma kem tibi parfat ini ri towfu iya!” ");
INSERT INTO hrw_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Pita ma neng e disaipel ru ka matet ru ka la ulo balamfam. ");
INSERT INTO hrw_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ru nano ru tiin filau safle neng e disaipel a, e filau famu ine Pita ka la puek famu ulo balamfam. ");
INSERT INTO hrw_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ka por ma ka kwuao ka pari e fan sisin laplap a e ngongo uwa, sakle e tibi kau. ");
INSERT INTO hrw_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Saimon Pita ka puek wimi ka kau sekit ulo balamfam ka pari e fan sisin laplap ri ngongo, ");
INSERT INTO hrw_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ma sun laplap ming gii ri ka fisi e paklu e Yesus ini, sun laplap a e ngo areini ri pitu fakausi ma ri ka towfu kuriik kosnge fanenger fan sisin laplap. ");
INSERT INTO hrw_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Kala neng e disaipel a ka puek famu ulo balamfam a kam kau, i ka pari ma ka titinge. ");
INSERT INTO hrw_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Safle ri tifik ten lo sunwar pepe, ini Yesus eu matet kosnge minet. ");
INSERT INTO hrw_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Kala e u e disaipel a ru ka la mil ulo fel. ");
INSERT INTO hrw_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Sakle Maria e titi una male, ulo matow e balamfam a ka tengteng. E tengteng uwa ma ka por ka kwuao ulo balamfam a. ");
INSERT INTO hrw_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ma ka pari e u e anggelo ru los lo fang kolos murmur kiruur, ru kiiskiis ulo mok gii ri ka fangongi e Yesus ulo, neng ulo paklu ma neng ulo kekow. ");
INSERT INTO hrw_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ru ka gatmo, “Wok, areini gii o ka tengteng?” Wok a ka peteng, “Ri sam kepe Taufi kiang, ma ya tibi parfat ini ri towfu iya.” ");
INSERT INTO hrw_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","E war tikii aiya ma ka didiu ka pari e Yesus e titi, sakle e tibi parfat ini Yesus. ");
INSERT INTO hrw_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yesus ka gatmo, “Wok, e tamu o ka tengteng? Se tikin o siksik ini?” Maria Makdalen ka sangfi ini kaltu e efefe lo palang a. Ka war singi, “Kaltu bakir, le o ku kepe ku la, peteng tif yau ine male o tafu ilo, usi yau la kepe.” ");
INSERT INTO hrw_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yesus ka war singi, “Maria!” I ka giliim ka par usi ma ka war singi lo warwar kere fan Ibru, “Raboni!” (pimpiku gii titsa). ");
INSERT INTO hrw_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yesus ka peteng tifi, “Ou tibi ofeng yau anwarow ya tifik la mil use Tabuung. Ou su la mil use tanga tuaklik o ku la peteng tifri ini yau la mil use Tabuung ma Taumi ma Deo kiang ma Deo kemi.” ");
INSERT INTO hrw_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Maria Makdalen ka la mil use fan disaipel tura sunwar gii, ka la peteng tifri, “Ya sau pari e Taufi!” Ma ka peteng tifri ine fan warwar Yesus e peteng tifi ini. ");
INSERT INTO hrw_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Lo efef lo biing baba tikii lo wik fan disaipel ri dukel patpat lo fan matangkon ma ri ka melmel ulo bala fel, anwarow ri soke re fan Juda. Yesus ka puek ka ti ulo falifu iri ma ka war, “Siaro sing gam!” ");
INSERT INTO hrw_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","E war aiya singri ma ka fanangsi ri ine un limow ma galumfow. Fan disaipel a ri ka la fefeal bakir tikin lo biing ri pari e Yesus. ");
INSERT INTO hrw_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yesus ka war singri ming, “Siaro sing gam. Tabuung e sam tule yau, lo tikii sal gii yau ming, ya tule gam.” ");
INSERT INTO hrw_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","E war aiya ma ka mange talo ri ma ka war, “Gam kepe e Tangwa Riis. ");
INSERT INTO hrw_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Le gam ku sangintafngi e fan tubiil kere tongge, fan tubiil a Deo e sam sangintafngi, ma gam ku tibi sangintafngi e fan tubiil keri, Deo e amu tibi sangintafngi e fan tubiil keri.” ");
INSERT INTO hrw_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Biing a Yesus ka puek talo re fan disaipel kia, Tomas (nenge asow ming gii Didimus), e tibi ta tura ri. ");
INSERT INTO hrw_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Biing ri peteng tifi ini ri sau pari e Taufi, Tomas ka peteng tifri aregii, “Le ya ku tibi pari e fan taftafu e fan nil ulo un limow, ma ya ku tibi tow e limang ilo taftafu e fan nil, ma ya ku tibi fasow e limang ilo galumfow, yau tibi titinge sekit.” ");
INSERT INTO hrw_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Nenge wik wimi fan disaipel ke Yesus ri ka tiim lo ri ming ulo bala fel a ma Tomas ka ta tura ri. Ri dukel patpat lo fan matangkon, sakle Yesus e puek ka ti u falifu iri ma ka war, “Siaro sing gam.” ");
INSERT INTO hrw_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ma ka peteng tife Tomas, “Tow e limam wagii, ma o ku par lo un limang, sangau ine limam o ku fasow ilo galumfong. Mele sang fa-u ma o ku su titinge.” ");
INSERT INTO hrw_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomas ka peteng tife Yesus aregii, “Ona Taufi kiang ma o na Deo kiang!” ");
INSERT INTO hrw_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yesus ka war singe Tomas aregii, “O am titinge, anwarow o au par yau. Sakle seri a ri ka ti par yau, ma ri ka titinge, ri kepe warfakausi.” ");
INSERT INTO hrw_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesus e gow e fan mok na tibou fuut fuunfuun na matre fan disaipel kia, sakle ri tibi siit famti ilo buk gii. ");
INSERT INTO hrw_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Sakle fan mok gii ri siit famti, usi ini ou titinge ini Yesus e ta Mesaiya, Sikow e Deo. Ma ilo titinge kiam lo, ou kepe ninliu lo asow. ");
INSERT INTO hrw_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Wimi ine fan mok gii Yesus e fanangsi i tibou mil tifre fan disaipel kia, ulo anisow e salat Taiberias, ma e fuut aregii. ");
INSERT INTO hrw_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Saimon Pita, Tomas (ri fotngi ini Didimus,) Nataniel tingna Kena ina Galili, ma un sikow e Sebedi, ma uneng ming lo re fan disaipel, ri melmel tiim. ");
INSERT INTO hrw_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Saimon Pita e war aregii, “Ya bala la tunii.” Ma ri ka peteng tifi, “Kemeu ming kem u la nami o.” Ri ka la ma ri ka kau ulo bala buut. Sakle lo panambiing a ri tibi kepe ti fis. ");
INSERT INTO hrw_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Lo biingbiing e mok sak, Yesus e titi una kiin, sakle fan disaipel ri tibi ilmi ini Yesus. ");
INSERT INTO hrw_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Wimi Yesus ka war singri, “Tanga fenfenngong, gam tibi kep ti tom fis?” Ri ka koso singi aregii, “E tam.” ");
INSERT INTO hrw_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ma i kau peteng tifri, “Gam u bas ine ubiin kemi ilo galu miil lo buut, usi gam u tangen.” Ri ka baspu mil ine ubiin a, biing ri am tatfe kanek ini, ri ka telpane ini, anwarow ubiin e fuunuf tikin ine fam fis. ");
INSERT INTO hrw_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Wimi neng lo re fan disaipel gii Yesus ka bura tibom ka peteng tife Pita, “Taufi le lei.” Saimon Pita e kepufu e kolos kia famu usi i e faim tuntun. Ma biing e ongni i e peteng ini, “Taufi le lei,”, Saimon e diidiit ine kolos kia ma ka of ulo bala dan. ");
INSERT INTO hrw_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Sakle fa lo re fan disaipel ri ming ulo buut, ri ka tatfeni e ubiin a, e fuunuf ine fam fis, usi e tibi ta ri u tapak, e su ngo areini tikii atis na mita kosnge angkiin. ");
INSERT INTO hrw_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ri kabuk la masa una kiin ma ri ka pari e bungen e sam la mangen ine fis ulo ma beret ming. ");
INSERT INTO hrw_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yesus ka war singri, “Kepe wagii ti ton neng lo re fam fis a gam ka kepe lo ubiin.” ");
INSERT INTO hrw_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Saimon Pita e la kau ulo buut ma ka tatfe masa ine ubiin ine fan fis lamlam sak ulo, e ta tikii atis ma e lim e sangful ma e tuul. Ubiin e fuunuf ine fam fis lamlam sakle e tibi rages. ");
INSERT INTO hrw_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Wimi Yesus ka peteng tifri aregii, “Gam kasa gam ku sa en.” Sakle e tek tikas lo re fan disaipel ek mel e rawas ma sangsang una gatmo ini, “O se?” Ri sau parfat ini Taufi. ");
INSERT INTO hrw_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yesus e la ka kepe e beret ka tow tifri, ma kam kepe fis ka tow ming tifri. ");
INSERT INTO hrw_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Biing gii, e ta biing baba e tuul Yesus e fespuek talo re fan disaipel, wimi ini e matet mil kosnge minet. ");
INSERT INTO hrw_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Biing ri en tikii, Yesus e war singe Saimon Pita, “Saimon sikow e Jon, areini, o bur yau sak iyat ire tongge gii ri ka bur yau?” Ma i ka koso singi, “Yow Taufi. O parfat ini ya bur o.” Wimi Yesus ka peteng tifi, “Ou fenfen re fan sipsip kiang.” ");
INSERT INTO hrw_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Yesus e war ming singi, “Saimon, sikow e Jon, o bur yau tikin?” Ma i ka koso singi, “Yow Taufi, o parfat ini ya bur o.” Yesus ka koso singi, “Efe kausi lo fan sipsip kiang.” ");
INSERT INTO hrw_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Yesus e gatmo baba e tuul, “Saimon, sikow e Jon, areini o bur yau?” Sakle ulo bala e Pita e ongker ma sangkuuluung anwarow Yesus e fatuul gatmo, “Areini o bur yau?” Ma Pita ka war singi, “Taufi, o parfat lo mara mok, ma o parfat ini ya bur o.” Wimi Yesus ka peteng tifi, “Fenre fan sipsip kiang. ");
INSERT INTO hrw_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ya peteng tikin tifo, biing o guam uwa, o bom los lo kem kolos, ma o ka la ulo mok o bur la wilo. Sakle biing o kabuk matuk omu sangau ine unlimam ma neng e mu faloski o ine kem kolos, ma ri kamu un o wilo male o tibi bura ini ou la wilo.” ");
INSERT INTO hrw_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yesus e war ine sunwar gii una fanangsi ini Pita eu met ine sese matan minet una resngeni e asow e Deo. Wimi kam war singi, “Mi nami yau.” ");
INSERT INTO hrw_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pita e giliiu mil ma ka pari e neng lo re fan disaipel, neng a Yesus ka bura sak, e mi nami ru. (I e neng lewa ka por sekit usi e Yesus lo biing ri en tiim lo efef, ma ka war, “Taufi, se gii ka bala solamuf o?”) ");
INSERT INTO hrw_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Biing Pita e pari, ka gatmo e Yesus, “Areini lo kaltu gii?” ");
INSERT INTO hrw_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yesus ka koso aregii, “Le ya ku bura ini eu liuliu ku muut lo yau mil, ya sang ini e tibi ta mok kiam. O samusu mi nami yau.” ");
INSERT INTO hrw_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Fan warwar fofoes e sam la falek tifre fatfatualik ini disaipel gii eu tibi met, anwarow fa lo re fan disaipel ri tibi ten lo sunwar gii. Sakle Yesus e tibi peteng aiya ini i eu tibi met, e tam. I e peteng aregii, “Le ya ka bura ini eu liuliu ku muut lo biing yau mil, ya sang ini e tibi ta mok kiam.” ");
INSERT INTO hrw_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Disaipel gii e sesngeni e fan mok gii ma i e siit famti. Kiar parfat ini fan mok e fabeku e tikin sak. ");
INSERT INTO hrw_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ma ming Yesus e gow e mara mok fuunfuun. Sakle ring gi siit famti ri nano, ya sang ini enggi tek ti sol gii lo nal salu e fam buk ring gi siisiit. ");
INSERT INTO hrw_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Tiofilus! Ulo bala buk lewa ya kabuk seti famu, ya seti e fan mara mok Yesus e tofnge una gow ma ka fabenge ini, ");
INSERT INTO hrw_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ka muut lo biing Deo e kep kanek ini wilo balambat. Famu ma kamu kanek, i e sau fatiti re fan apostel i e sam wel ri kia, ine rawas ke Tangwa Riis. ");
INSERT INTO hrw_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Wimi ine ongker ma minet kia, i e bou fafanas ini tifre tongge gii lo fam biing fuunfuun ka muut lo e fet e sangful na biing. Ma ka gow e fan mok fuunfuun na matri, usi ini riu parfat ini e liu tikin, ma ka peteng tifri ine kepmale ke Deo. ");
INSERT INTO hrw_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Lo neng e biing, biing Yesus e en tiim tura ri, i ka war rawas singri aregii, “Gau mele la kosnge male ina Jerusalem. Gam u nene i e finafen Tabuung e warfot lo, lewa gam kabuk ongni ya gongon lo. ");
INSERT INTO hrw_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Anwarow Jon e gugu tarawen ine dan, sakle e tibi fuun e biing ma Deo ku gu tarawen i gam ine Tangwa Riis.” ");
INSERT INTO hrw_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ma biing ri tiim lo ri, ri ka gatmo aregii, “Taufi! Kemem sang ini lo biing gii, ou tow mil e rawas tife kepmale tingna Israel?” ");
INSERT INTO hrw_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ma i ka war singri, “E tibi ta mok kemi una parfat lo anmatam pisii ma biing tabuung e sau bou fagati lo parfat ma rawas kia tibom. ");
INSERT INTO hrw_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Sakle gam u kepe rawas biing Tangwa Riis eu pu talo gam, ma gam u sesngeni e sunwar lo yau ina Jerusalem ma ilo bala male kiruur ina Juda ma ina Samaria ma lo rorop lo nal kiruur.” ");
INSERT INTO hrw_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Wimi ini e waruf aregii, ri ka pari e kanek na matri, ma pambalbal ka kaleni e matmatri. ");
INSERT INTO hrw_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ri alalal rawas uwa nami e Yesus, ma saupe sak ung kaltu ru los lo fang kolos murmur ru ka sa titi unais ri. ");
INSERT INTO hrw_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ma ru ka war, “Tongge tingna Galili, e tamu gam ka titi gam ka alalal wiyat? Yesus gii Deo ka kepe kosing gam ka la ilo balambat, e mu mil lo tikii sal gii gam ka pari, Deo e kep kanek ini lo.” ");
INSERT INTO hrw_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Wimi ri ka la mil una Jerusalem tinglo paklunmale ri fotngi ini Olif. E ngo are tikii kilomita tinglo siti ina Jerusalem. ");
INSERT INTO hrw_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Biing ri la puek, ri la fen sekit ulo su una melmel singri ulo fel a. Fa a ri ka tiimtiim lo ri e ta: Pita, Jon ma Jeims, Enru, Filip, Tomas, Batolomius, Metiu ma Jeims sikow e Alfius ma Saimon neng lo re e fan Silot ma Judas sikow e Jeims. ");
INSERT INTO hrw_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Iri nano ri sagisu tiimtiim bingne, ri ka nining tura re gelefin ma Maria tinow e Yesus tura tanga tualik. ");
INSERT INTO hrw_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Lo fam biing a Pita e ti una balre tongge na titinge (e ngo are tikii atis ma e u e sangful na kaltu). ");
INSERT INTO hrw_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Ma ka war, “Tanga tuaklik, sunwar ke Deo e samusu la siim aregii Tangwa Riis kabuk war lo nangen tikin, ulo ngusu e Dewit. I e war lo Judas e ta kaltu e fanangsi re tongge saksak ine Yesus ri ka bingfamti. ");
INSERT INTO hrw_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Famu Judas e ta neng lo kemem, ma e sau musngeni e tikii mus gii, kemem ka musmusngeni.” ");
INSERT INTO hrw_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Judas e kepe mani lo mok saksak sekit e gow ka feli e sunal ini. Wimi kam luut ulo sunal a, ambala ka la pus ma sakow ka la suu fafalek. ");
INSERT INTO hrw_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Tongge nano una Jerusalem ri ong lo mok gii, iya ri ka fotngi e rinal a lo warwar keri ini Akeldama, pimpiku gii, Nal na Dadak.) ");
INSERT INTO hrw_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Pita ka war, “Anwarow ri sam seti ilo buk ke Sams: ‘Towfu e fel kia ku biil, eu tek tikas eu melmel ilo.’ Ma e war ming aregii, ‘Towfu e tikas kuriik ku kepe tafu una famu.’ ");
INSERT INTO hrw_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Ma gii kiar samusu feti e tikas e sam ta tura kiar lo mara biing, biing Taufi Yesus e melmel tura kiar, ");
INSERT INTO hrw_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","tofnge tinglo biing Jon e gu tarawen ire tongge ka la muut lo biing Deo e kep kanek ine Yesus kosing kiar. Kaltu a e samusu ti tura kiar una peteng tikin ine matmatet mil ke Yesus.” ");
INSERT INTO hrw_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Iya ri ka feti e ung kaltu, Josef ri fotngi ini Barsabas (ri fotngi ming ini Jastus) ma neng gii Matias. ");
INSERT INTO hrw_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Wimi ri ka nining, “Taufi, o parfat lo busbus re tongge nano. Fanangsi kemem ine se lo ung kaltu gii o sau feti, ");
INSERT INTO hrw_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","una kepe subung e faim apostel lewa Judas ka la kosngi, una la ilo male a ka ta i tinglo.” ");
INSERT INTO hrw_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Wimi ri ka bas ine fatfat, ma tikii fu fumfat ka peteng ini Matias. I e puek ka ta neng lo e tikii sangful ma e tikii na apostel. ");
INSERT INTO hrw_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ri tiimtiim lo ri ulo tikii mok, biing bengu e Pentekos e puek. ");
INSERT INTO hrw_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ma saupesak dungow e mok e ngo are kif rawas e puek tinglo balambat, ma ka fafonsi kiruur e bala fel a ri ka melmel ulo. ");
INSERT INTO hrw_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ri pari e fan mok e ngo are kerkermen iif, ri la falek ma ri ka la ngo wiyat lo tikii neng, tikii neng lo ri. ");
INSERT INTO hrw_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Iri nano ri fuunuf ine Tangwa Riis ma ri ka tofnge una gon lo fanenger fang kinen kere fa, are Tangwa Riis e sau fafonsi ri, ri ka fasi una war. ");
INSERT INTO hrw_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Lo biing a, e mel e fan Juda ri melmel una Jerusalem, ri ta tongge na nining lo Deo. Ma ri la tinglo fan mara male gii lo nal. ");
INSERT INTO hrw_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Biing ri ongen dung ri, tongge fuunfuun ri sa tiim. Ri kuufsak ma ri ka sangfuunfuun, anwarow tikii neng, tikii neng e ongen ten sekit ine ke kinen tuman. ");
INSERT INTO hrw_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Fan Juda ri kuufsak ma ri ka fagatomnge, “E sam ta tongge nano gii tingna Galili? ");
INSERT INTO hrw_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ma areini gii tikii neng, tikii neng lo kiar ka fasi una ongen ri gon tinglo fang kinen kiar riis? ");
INSERT INTO hrw_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Kiar na fa tingna Patia, Midia ma tingna Elam, ma kiar na fa kiar melmel ina Mesapotemia, ina Judia ma ina Kapadosia, ma ina Pontus ma Eisia, ");
INSERT INTO hrw_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frigia ma Pamfilia, tingna Ijip ma fang galgalu lo male ina Libia fatatu e male ina Sairini, ma tongge ming ri la tingna Rom, ");
INSERT INTO hrw_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Kiar na fan Juda ma fanenger fan tongge a ri ku usi e fan Juda, kiar tingna Krit ma Arabia, kiar ongen ri, ri peteng suupuek ine fam faim bakir ke Deo lo fan kinen kiar riis!” ");
INSERT INTO hrw_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ri kuufsak ma ri ka sangfuunfuun ma ri ka fagatomnge iri tibom, “E ta sese fan mok tikin legii?” ");
INSERT INTO hrw_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Sakle fa ri tumar ri ma ri ka war, “Tongge gii ri sam in waen fuunfuun tibom.” ");
INSERT INTO hrw_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Wimi Pita ka ti tura tikii sangful ma tikii na apostel ma ka tau bakir singre tongge a, “Gam na fan Juda ma gam nano gau melmel gii na Jerusalem, yau fatenu e mok gii tif gam. Gam ong kausi lo sa ya bala peteng ini. ");
INSERT INTO hrw_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Tongge gii ri tibi bengbeng aregii gam ka peteng. Gii e am su ta anmatam pisii baba e siu lo biingbiing. ");
INSERT INTO hrw_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","E tam, igii e ta sa profet Joel e sau peteng ini. ");
INSERT INTO hrw_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Deo e peteng aregii, “Fatfatat lo biing muut, Yau tipeni e Tangwang talo re tongge nano. Siksikuami antamat ma gelefin, riu warfot ine fan warwar kiang. Fungguam kemi riu pari e fan mok e ngo are numbiil ma tanga warwaraner ri ku numbiil ine fan numbiil. ");
INSERT INTO hrw_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ma ilo re tongge na mus kiang ming, antamat ma gelefin lo fam biing a, yau tipeni e Tangwang ilo ri ma ri ku war ine fan warwar are fam profet. ");
INSERT INTO hrw_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Yau fanangsi e fan tintof ilo batsok, ma fan mok na tibou fuut wagii lo nal. Andadak ma iif ma ampuat bakir eu puek. ");
INSERT INTO hrw_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Pisii eu ikis, male ku or. Ma funiil ku ikis ku ta andadak, famu ine biing bakir na finaswen ke Taufi. ");
INSERT INTO hrw_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ma seri a ri ka gatom use faules lo asow e Taufi, i eu faliungeri.” ’ ");
INSERT INTO hrw_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Tongge tingna Israel, ong wagii, Deo e tow e raw tife Yesus tingna Nasaret una gow e fan mok na tibou fuut, fan mok na sangfuunfuun ma fan tintof falifu i gam una fanangsi ini Deo e tuleni, aregii gam tibom gam ka parfat. ");
INSERT INTO hrw_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Kaltu gii, Deo e sam tow tif gam ususi e fabur ma fagati kia. Ma gam tiim tura faules kere tongge saksak, gam tutfamti ulo aupaket ka met. ");
INSERT INTO hrw_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Sakle Deo e famtet famila kosnge minet. I e kepufu kosnge ongker saksak tinglo minet, anwarow, e tuntun tikin singe minet una bingfamti. ");
INSERT INTO hrw_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Dewit e war lo aregii, ‘Ya pari e Deo Taufi kiang e sagisu ta i famu i yau. Anwarow i e ta ilo galu miil kiang, ya tibi fasi una soke. ");
INSERT INTO hrw_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Aregii ambusbusang e gasgas, ya ka gow e fan warwar na fefeal. Pinumfong eu melmel nene-i e konona fan mok, Deo eu gow lo. ");
INSERT INTO hrw_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Anwarow ou tibi toufsok lo yau ilo male kere fan minet. Ma ou tibi tafu e Kaltu Riis kiam ku mapu. ");
INSERT INTO hrw_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","O sau fanangsi yau ine fan sal na ninliu, ou fafuunnge yau ine fefeal lo biing yau ta tura o.’ ");
INSERT INTO hrw_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Tanga tuaklik, ya fasi una peteng tikin tif gam ini tumlarer Dewit, e met ri ka ofo. Ma annal lo iwa ka muut geinggii. ");
INSERT INTO hrw_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Sakle i e ta profet, ma e parfat ini Deo e sam limlim tifi ini eu feti e tikas lo tanga tubtubungkak kia, ku puek ku ta king are i. ");
INSERT INTO hrw_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Dewit e pari e sa eu puek wimi ma ka war lo matmatet mil ke Kristus, ini i e tibi fasi una mel sok ilo male kere fan minet, tam ini pinumfow eu mapu ilo bala annal lo. ");
INSERT INTO hrw_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Deo e sau famtet famila e Yesus gii kosnge minet ma kemem nano kemem ti tura sa e tikin, kemeu pari. ");
INSERT INTO hrw_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Deo e sam akteni e Yesus ka towfu ulo galu miil lo. I e sam kepe Tangwa Riis singe Tamow lewa ka limlim ini eu tow. Ma gii i e sam tipeufu e sa gau pari ma gam kabuk ong lo. ");
INSERT INTO hrw_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Le Dewit e tibi kanek ulo balambat aregii Yesus ka kanek ma sakle i e peteng aregii: ‘Deo e peteng tife kek Taufi: “Kiis ilo galu miil lo yau, ");
INSERT INTO hrw_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ku muut yau towfu e fa ri is o ilo pikliu e rawas kiam.” ’ ");
INSERT INTO hrw_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Aregii toufre fan Israel nano ri ku parfat ini, Deo e sam towfu e Yesus lewa gam ka paketmet ini, kabuk ta Taufi ma Kristus.” ");
INSERT INTO hrw_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Biing ri ongni aiya, fan warwar a e taba e balbalri, ma ri ka war singe Pita ma fan apostel, “Tanga tualikmem, sa kemem u gow?” ");
INSERT INTO hrw_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ma Pita ka koso, “Gam nano gam samusu sangikis, ma gam ku kepe e amfagu tarawen, lo asow e Yesus Kristus. Usi Deo eu sangintafngi e fan tubiil kemi ma gam ku kepe Tangwa Riis are finafen kemi. ");
INSERT INTO hrw_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Limlim gii e ta kemi ma siksikuami, ma fa nano a ka ta iri tapak - Seri a Taufi Deo kerer ku tau iri.” ");
INSERT INTO hrw_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pita e sesngeni e fan warwar fuunfuun tifri ma ka war rawas singri, “Gigi kausi i gam tibom kosngi e inlen saksak gii.” ");
INSERT INTO hrw_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Fa ri titinge lo fan warwar gii ri gu tarawen iri. Lo biing ri wes tiim iri, e la ngo are e tuul e mar na kaltu, ri kaulek una balre fa a, ri kabuk titinge ting famu. ");
INSERT INTO hrw_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Tongge ri ong kausi use fam fabenge kere fan apostel, ma ri ka faules faliu iri, una en tiim ma una nining tiim. ");
INSERT INTO hrw_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ma Deo ka gow e fan mok fuunfuun na tibou fuut ma fan tintof na limlimre fan apostel. Ma tongge nano ri pari ri ka kuufsak ma ri ka soke. ");
INSERT INTO hrw_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Tongge nano na titinge ri tiim lo ri, ma mara mok ke tikii neng, tikii neng lo ri e ta keri nano. ");
INSERT INTO hrw_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ri umumat ine fan nal ma fan mok ri mel lo, ma ri ka tow e mani lo tifre fa a, ri ka sasngal ina balri. ");
INSERT INTO hrw_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Fam biing nano ri sagisu tiim lo ri ilo bala Felun Nining Bakir. Ri enen tiim ilo bala fam fel keri, ma ri en tura gasgas ma fefeal ilo balbalri. ");
INSERT INTO hrw_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Fam biing nano ri sagisu katkatfarsi e Deo, ma tongge nano ri fefeal lo ri. Lo fan mara biing Deo e uunuun kaulek ire fa gii ri kabuk titinge. Ma lo sinang gii, i e gow e wewes lo re tongge na titinge lo Yesus ka faf. ");
INSERT INTO hrw_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Lo neng e biing Pita ma Jon ru lala wilo Felun Nining Bakir lo anmatam pisii baba e tuul lo efef, lo pansumbiing una nining. ");
INSERT INTO hrw_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","E mel e kaltu e dol, e tibi fesfes tinglo biing e fuut. Ri kepe ri ka la towfu ulo matangkon lo Felun Nining Bakir, ri fotngi ini Konona Matangkon. Bingne ri kepkepe, ri ka la tataufu wa una farfaran mani singre tongge, ri lala wilo pakanmale lo Felun Nining Bakir. ");
INSERT INTO hrw_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Biing e pari e Pita ma Jon ru rong una kau, i ka faran mani singru. ");
INSERT INTO hrw_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Pita ma Jon ru ka man riis usi, ma Pita ka war, “Par usi kama.” ");
INSERT INTO hrw_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","I ka man usi ru, e mekelkele ini ruw tow e ti mani tifi. ");
INSERT INTO hrw_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Wimi Pita ka war singi, “Silwa ma gol e tam kiang lo, safle sa ya mel lo, yau tow tifo. Lo asow e Yesus tingna Nasaret, ya peteng tifo, matet o ku fes.” ");
INSERT INTO hrw_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ma Pita ka puse lo galun limow miil ma ka famtete ka ti. Ma saupesak kekow ma anmatangkenit na kekow ka la raw. ");
INSERT INTO hrw_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ma kaltu a ka of ka la ti ma ka fes ka la nami ru ulo pakanmale lo Felun Nining Bakir. I e fes ma ka ofofof ma ka resresngeni e Deo. ");
INSERT INTO hrw_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Biing tongge nano ri pari e fesfes ma ka resresngeni e Deo, ");
INSERT INTO hrw_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ri ilmi ini e sam ta imung e kaltu gii ka kiiskiis ma ka farfaran mani ulo Konona Matangkon lo Felun Nining Bakir. Tongge ri pari ma ri ka kuufsak, ma ri ka sangfuunfuun lo mok e fuut lo. ");
INSERT INTO hrw_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Biing kaltu na farfaran e puse patpat lo Pita ma Jon, tongge nano ri kuufsak ma ri ka fafilaunge usi ri, ulo mok ri fotngi ini Galum Fel ke Solomon. ");
INSERT INTO hrw_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Biing Pita e pari aiya, i ka war singri, “Gam na tongge tingna Israel, sa e gow gam ka kuufsak lo mok gii? Usi e tamu gam ka tunmet i kama? Are ini, gam sang ini kama gow e mok gii lo rawas kama, tam kama melmel riis na mata e Deo, iya kama ka gow e kaltu gii ka fes? ");
INSERT INTO hrw_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","I e ta Deo ke Abra-am, Aisak ma Jekop, ma e ta Deo kere tamtamrer. I e sau faswenu e kaltu na mus kia Yesus. Gau fafen ini, ini ri ku paketmeteni, ma gam ka guuluung ini na mata e Pailat, biing i e sau bura una falimufu ku la. ");
INSERT INTO hrw_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Gam guuluung ine Kaltu Tarawen tikin ma e Riis Sekit ma gam ka gatom ini Pailat eu falimufu e kaltu na pakpaketmet ire tongge, tif gam. ");
INSERT INTO hrw_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Gau paketmet ine kaltu na famu i kiar wilo ninliu, sakle Deo e famtet famila kosnge minet. Kemeu pari sekit e mok gii. ");
INSERT INTO hrw_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Kem tuul titinge lo asow e Yesus, ma i mung gii ka gow e kaltu gii gam ka pari ma gam ka parfat lo. Ma lo asow e Yesus e famtete e titinge kama. Ma lo titinge gii e gow e kaltu gii ka raw, aregii gam nano gam kabuk pari. ");
INSERT INTO hrw_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Ma gii tanga tuaklik, ya parfat ini gam tura ge lamlam kemi, gam tibi parfat kausi lo Yesus, iya gam ka gow e ansinang a lo. ");
INSERT INTO hrw_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Sakle i le gii e sal Deo e fasefu e sa e sau peteng ini famu na ngusre fam profet. I e peteng ini Kristus kia e samusu ongker. ");
INSERT INTO hrw_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Gam samusu sangikis ine fan tubiil kemi ma gam ku mil use Deo, usi i eu kepufu e fan tubiil kemi, ma i ku tow e rawas fuu tif gam. ");
INSERT INTO hrw_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Ma i kamu tuleni e Kristus, i e sam sikii una ules gam - i gii Yesus tibom. ");
INSERT INTO hrw_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Eu buk melmel ilo balambat, ku muut lo biing Deo eu terngeni mil e mara mok, aregii kabuk peteng fate ini ulo ngusre fam profet riis kia. ");
INSERT INTO hrw_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moses e war aregii, ‘Deo Taufi kemi, eu feti e profet kemi eu ngo are yau, tingau na balre tongge kemi tibom. Gam samusu ong singi lo mara mok eu peteng ini tif gam. ");
INSERT INTO hrw_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Le tikas ku tibi ong singi, Deo eu tii ini sekit tingna balre tongge kia.’ ");
INSERT INTO hrw_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Ma fam profet nano tofnge tinglo Samuel ka la muut gii, ri sau peteng famu ine fan mok gii ka fuutfuut geinggii. ");
INSERT INTO hrw_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Gam na fan siksikuare fam profet, gam u kepe e fan mok Deo e sam limlim ini, ini i eu tow tif gam, lo biing e gow e a-uu tura re fan tuptupmi ma ka war aregii singe Abra-am, ‘Lo fan siksikuam mung gii, tongge nano tinglo nal riu kepe e warfakausi.’ ");
INSERT INTO hrw_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Biing Deo e wele kaltu na mus kia, i e tuleni famu usi gam, ku warfakausi gam, ma Deo ku ikis gam kosngi e fan sinang saksak kemi.” ");
INSERT INTO hrw_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Fam pris ma kepten kere tongge na efefe lo Felun Nining Bakir, ma fan Sediusi, ri fespuek use Pita ma Jon, lo biing ru gongon uwa singre tongge. ");
INSERT INTO hrw_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ri balasak tikin anwarow ru fabenge singre tongge, ma ru ka sesuupuek ini Yesus e sau matet mil kosnge minet, ma e mel e matmatet mil tinglo minet lo asow e Yesus. ");
INSERT INTO hrw_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ri bingfamti e Pita ma Jon una anganggon singru, sakle anwarow e sam efef, ri ka su touf ru ulo bala felun rerek ku muut lo biing usi. ");
INSERT INTO hrw_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Sakle fa fuunfuun lo ri, ri ongni e sunwar lo biing a, ri titinge. Ma ri wes lo re tongge ri titinge e ngo are e lim e mar. ");
INSERT INTO hrw_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Lo biing wimi, tongge lamlam tinglo gapman keri, ma tongge lamlam lo re fan Juda, ma fan titsa lo fafanau ri la tiim una Jerusalem. ");
INSERT INTO hrw_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Anas, paklure fam pris e ta i wa, tiim tura Kaiyafas, Jon, Aleksenda, ma fa ming lo amfufumberat lo Anas. ");
INSERT INTO hrw_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ri onu e Pita ma Jon, ri ka la fetiuf ru u famu iri, ma ri ka gatom ru, “Kamu bilseni e mok gii lo sese rawas ma lo asow e se?” ");
INSERT INTO hrw_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Tangwa Riis e fafonsi e Pita, ma i ka war singri, “Fan efefe ma ge lamlam lo re tongge, ");
INSERT INTO hrw_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","gii gam gatom kama usi ini are kama ulsi e kaltu lewa ka dol. Ma gam ka bur parfat ini kaltu gii are e liu. ");
INSERT INTO hrw_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Gii gam samusu parfat, gam ma tongge nano tingna Israel, lo asow e Yesus Kristus tingna Nasaret, lewa gam ka tut famti ulo aupaket, sakle Deo e sam famtet famila kosnge minet. I mung gii, kaltu a ka liu ma ka titi aifamu i gam. ");
INSERT INTO hrw_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yesus e ta fat lewa gam na tongge na bilbilse fam fel gam ka guuluung ini, Sakle fat a, e ta warow e fel una faraungeni. ");
INSERT INTO hrw_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","E tek tikas ek fasi una kepfamil kiar. E tek ti neng e as ilo pikliu e balambat Deo ek tow tifre tongge una kepfamil kiar. Safle Yesus tibom, Deo e sam sikii una kepfamil kiar.” ");
INSERT INTO hrw_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Tongge lamlam ri parfat ini Pita ma Jon ru tibi fabenge, ru su ta ung kaltu fofoes. Sakle ri par ru, ru warwar rawas ma ru tibi soke, ri kuufsak ma ri sangfuunfuun singru, le ri parfat ini famu ru melmel tura Yesus. ");
INSERT INTO hrw_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ma lo biing ri pari e kaltu e dol e sam liu ma ka titi tura ru, e am tek ti sunwar una peteng ini tifru. ");
INSERT INTO hrw_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Tongge lamlam ri ka uun suu iru tingna balri ine fatungen, ma ri ka bou fawar iri tibom. ");
INSERT INTO hrw_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Ri gatom, “Sa gii kiar ku gow lo ung kaltu gii? Tongge nano ri melmel una Jerusalem ri parfat ini ru sau bilseni e mok na tibou fuut, ma parpar lo e bakir tikin. Ma kiar tibi fasi una gurum kali. ");
INSERT INTO hrw_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Sakle una faropo e sunwar gii are enggi am omseni e male ku la ilo falifu lo re tongge, kiar samusu fanau re ung kaltu gii, ini ru mu tibi peteng ming tife tikas ini e as gii.” ");
INSERT INTO hrw_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ri tau kau mil iru ma ri ka fanau ru ine fatungen, ini ru mu tibi war fotngi ming, tam ru mu tibi fabenge lo asow e Yesus. ");
INSERT INTO hrw_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Sakle Pita ma Jon ru koso singri aregii, “Gam sang ini sese sinang e riis na mata e Deo? Kamau usi e fan warwar ke Deo, tam kamau usi e fan warwar kemi? Gam tibom gaman ikseni. ");
INSERT INTO hrw_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Kama tibi fasi una manau. Kama samusu sesngeni e sunwar lo fan mok kama pari ma kama ongni.” ");
INSERT INTO hrw_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Fang kaonsiil ri tow e fan warwar e raw una fasoke ru, ma ri kam tauf ru ka la. Ri tibi sangseni e ti sal una fakutun a ru, anwarow lo re tongge nano ri resngeni e Deo lo sese mok e sau fuut. ");
INSERT INTO hrw_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Le kaltu gii un apostel ru ka gow e mok na tibou fuut lo ma ru ka faliungeni, matamfaim kia e soliwi e e fet e sangful. ");
INSERT INTO hrw_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Biing fang kaonsiil ri falimuf ru, Pita ma Jon ru la mil unais re tongge na titinge, ru ka la seseng ine fan warwar fam pris lamlam ma ge lamlam ri peteng ini tifru. ");
INSERT INTO hrw_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Biing ri ong lo mok gii, ri tikii balri ma ri ka tiin nining singe Deo, “Taufi kere an taufi, o lamlames makrau ine balambat, nal ma balang kasap, ma fan mara mok nano ilo ri. ");
INSERT INTO hrw_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Lo Tangwa Riis o war ulo ngusu e tupmem Dewit, kaltu na mus kiam, ma e war aregii, ‘Usi e tamu an mara male ri ka balasak tuntun tibom, usi e tamu fan tongge gii ri ka fagati e fan warwar fofoes una gow e fan sinang saksak? ");
INSERT INTO hrw_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Fang king tinglo mara galgalu gii lo nal ri sau fagati ri ma tongge lamlam ri sam kep tiim iri una bero ine Taufi, ma una bero ine Kristus kia.’ ");
INSERT INTO hrw_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","E tikin Erot ma Ponsus Pailat ru tiim tura fan ses ma tongge tingna Israel, ilo bala siti gii una poktuui use Yesus, kaltu na mus tarawen kiam, gii o kabuk wele. ");
INSERT INTO hrw_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Biing ri gow e mok gii, ri usi e sinangum ma fabur kiam tibom. Lo rawas kiam, nangen o fagati e sunwar lo fan mok gii e samusu fuut. ");
INSERT INTO hrw_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ma gii Taufi o parfailmi e fan warwar nano ri gow una fasoki kemem. O samusu ules kemem na tongge na mus kiam, usi kemem u titi rawas una sesngeni e kem sunwar, ma kemem ku tibi soke. ");
INSERT INTO hrw_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Sangau ine limam ma o ku faliungere fan minse, ma o ku gow e fan tintof ma fan mok na tibou fuut lo asow e Yesus, kaltu na mus tarawen kiam.” ");
INSERT INTO hrw_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Wimi ine nining keri, fel ri tiim ulo e doi ma Tangwa Riis ka fafonsi ri ma ri ka sesngeni e sunwar ke Deo. Ri gon rawas ma ri tibi soke. ");
INSERT INTO hrw_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Tongge ri titinge lo Yesus e su tikii balri ma sinangu ri. E tek tikas eu peteng ini ninsiow eu ta kia tibom, safle ri faseni e fan mok ri mel lo falifu lo ri nano. ");
INSERT INTO hrw_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Fan apostel ri peteng ten ine matmatet mil ke Taufi Yesus. Ma fan warwar keri e mel e singmat na rawas. Ma Deo ka tow e singmat na warfakausi ulo ri nano. ");
INSERT INTO hrw_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","E tek tikas una balri ek sasngal. Fa lo ri gii ka mel e fan nal ma fam fel keri, ri umumat ini ma ri ka kepkep mil ine fan mani lo, ");
INSERT INTO hrw_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ri ka sa tatafu tifre fan apostel, ri ka titi ini lo re tongge ususi e fan mok ri tibi mel lo. ");
INSERT INTO hrw_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Josef e ta neng lo re fan Liwai tingna Saiprus, igii fan apostel ri ka fotngi ini Barnabas (pimpiku gii: Kaltu na war farawasnge). ");
INSERT INTO hrw_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","E umat ine ke rinal, ka kepe mani lo, ka la tafu unaisa e kekek re fan apostel. ");
INSERT INTO hrw_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ma e mel e neng e kaltu asow gii Ananaiyas, tiim tura ke wok Safaira. Ananaiyas e umat ine rinal kia. ");
INSERT INTO hrw_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","I e puse famti e galu lo mani, e toufsok lo ini ku ta kia tibom. Ma ke wok ming e parfat lo ma ka a-uu lo. I ka kepe galu uwa lo mani a, ka sa towfu unaisa e kekek re fan apostel. ");
INSERT INTO hrw_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Wimi Pita ka war singi, “Ananaiyas, usi e tamu gii o ka tafu e satan ka fafonsi e balam? O ka gurum ine Tangwa Riis, o ka kepufu e galu lo mani o kepe lo nal. ");
INSERT INTO hrw_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Famu ini ma o kamu umat ine nal, nal e ta kiam. Ma mani o kepe e ta mok kiam ming, e fasi ini ou gow e sese mok o bura ini ou gow lo. Sa e gau o, o ka bura ini ou gow e sinang e sak gii, o ka gurum? O tibi gurum ine ti kaltu, o gurum ine Deo.” ");
INSERT INTO hrw_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Biing Ananaiyas e ongni e sunwar a, i e luut ufaf ka la met. Tongge ri ong lo mok e fuut lo Ananaiyas, ri la soke sak. ");
INSERT INTO hrw_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Wimi fung guam ri ka fespuek ri ka afti e pinumfow, ma ri ka kep suu ini ri ka la ofo. ");
INSERT INTO hrw_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","E ngo are e tuul e anmatam pisii wimi, ma ke wok ka kaulek. I e tibi parfat lo sa e sau fuut. ");
INSERT INTO hrw_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ma Pita ka gatmo aregii, “Peteng tif yau, e sam ta i legii e fimfiil o ma Ananaiyas kamu kepe lo nal?” Ma wok a ka koso, “Yow, ilea e fimfiil kiruur.” ");
INSERT INTO hrw_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ma Pita ka war singi, “Usi e tamu kamu lamaksi kamu ka a-uu lo sunwar una tofo e Tangow e Taufi? Par! Tongge ri la ofo e keu matuk iya, ri ka fes kaulek ailo matangkon, ma riu kep suu i o ming.” ");
INSERT INTO hrw_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Lo sumbiing a sekit, wok a e luut ufaf ulo fow e ungkekow e Pita ka la met. Fung guam ri ka kaulek ma ri ka pari ini e sau met, ri ka kep suu ini ri ka la ofo ulo galu lo ke matuk. ");
INSERT INTO hrw_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Tongge tinglo sios ma fa lo re tongge ri ong lo mok e fuut, ri la soke bakir sak. ");
INSERT INTO hrw_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Fan apostel ri gow e fan tintof fuunfuun ma fan mok na tibou fuut ulo falifu lo re tongge. Ma tongge ri titinge lo Deo, bingne ri la tiimtiim ilo Galum Fel ke Solomon. ");
INSERT INTO hrw_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Tongge fuunfuun ri tibi tiimtiim tura ri anwarow ri soke, sakle ri resresngeni e asasri. ");
INSERT INTO hrw_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Fuunfuun lo re antamat ma gelefin ri titinge lo Taufi, ri au fafonsi e wewes lo ri. ");
INSERT INTO hrw_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Tongge ri parfat lo fan mok na tibou fuut fan apostel ri gow, iya ri ka kep re tongge ri mase ka la ulo sal ma ri ka fangonge ri ulo fan ngiin, ma fan awaun ngiin, usi ini eu su ta tangow e Pita eu maluuf re fa lo ri lo biing i eu fespaket singri. ");
INSERT INTO hrw_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Tongge tinglo fan taon fatatu e taon ina Jerusalem, ri ming ri sa tiim. Ri kep puek ine fan minse, ma fa fan tangwaner saksak e sispi e fofori. Ri nano ri tiin liu mil. ");
INSERT INTO hrw_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Paklure fam pris ma fan taltalu e ta fa tinglo galun Sediusi, ri pari e fan mok fan apostel ri gow, ri ka la balasak bakir tikin. ");
INSERT INTO hrw_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ri matet ri ka bingfamti re fan apostel, ma ri kam toufri ulo rerek. ");
INSERT INTO hrw_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Sakle lo panambiing anggelo ke Taufi e ipki e fan matmatangkon lo felun rerek, ka un suu iri ma ka war singri aregii, ");
INSERT INTO hrw_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Gam u la gam ku la ti ilo bala ampalkanmale lo Felun Nining Bakir, ma gam ku sesngeni e sunwar kiruur tifre tongge nano ine ninliu fuu.” ");
INSERT INTO hrw_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Lo biingbiing e mok sak, ri ka la kaulek ulo bala ampalkanmale lo Felun Nining Bakir, ma ri ka tofnge una fabenge singre tongge aregii anggelo ka peteng tifri. Biing paklure fam pris ma fan taltalu ri fespuek, ri ka tau ire fang kaonsiil ma tongge lamlam nano kere fan Israel ri ka la tiim, ma ri kam tuleni e sunwar ka la ulo felun rerek ini ri ku tulere fan apostel tifri. ");
INSERT INTO hrw_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Sakle biing fan ofisa ri la fespuek ulo felun rerek, ri am tibi pari e fan apostel, iya ri ka su la mil ri ka la peteng tifre fang kaonsiil aregii, ");
INSERT INTO hrw_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Kemem la pari e felun rerek e kut kausi tikin, ma fan efefe ri ka fafatie ulo fan matmatangkon, sakle biing kemem ipki e fan matmatangkon, kemem am tibi par tikas una fel.” ");
INSERT INTO hrw_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Biing Kepten kere tongge na efefe lo Felun Nining Bakir ma fam paklure fam pris ri ongni e sunwar gii, ri kuufsak ma ri ka sangfuunfuun ini sa gii ka fuut lo re fan apostel. ");
INSERT INTO hrw_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Wimi neng e kaltu ka fespuek ma ka war singri, “Ong, tongge lewa gam ka toufri ulo rerek, iri leii, ri ka fafabenge singre tongge ilo bala Felun Nining Bakir!” ");
INSERT INTO hrw_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Kepten tura fan ofisa ri la ma ri ka la uun familre fan apostel. Ri am tibi fasi una gow e ti mok lo ri, anwarow fan ofisa ri soke are tongge ri ka rang ri ine fatfat. ");
INSERT INTO hrw_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ri ka uun kaulek ire fan apostel, ri ka sa fetiuf ri na matre fang kaonsiil, ma paklure fam pris ka gatgatom ri, ");
INSERT INTO hrw_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","ma ka war, “Kemem sam warkale gam, ini gam amu tibi fabenge ine asow e kaltu gii. Par lo mok gam sam gow, fam fabenge kemi e sam omseni e male ina Jerusalem. Ma lo sangsang kemi, gam gowgow ini kemem ta anwarow e minet kia.” ");
INSERT INTO hrw_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pita ma fanenger fan apostel ri ka koso aregii, “Kemem samusu ong singe Deo, e tibi ta ini singe kaltu! ");
INSERT INTO hrw_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Deo kere tuptuprer e sau famtet famila e Yesus kosnge minet. Se gii gam ka tut famti talo au, ma gam ka paketmet ini. ");
INSERT INTO hrw_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Deo e sam kep kanek ini ma ka towfu ilo galu miil lo, are Taufi ma Anwaramfaliunge, usi eu ules kiar na fan Israel una sangikis, ma ku kepufu e fan tubiil kiar. ");
INSERT INTO hrw_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Kemem tiim tura Tangwa Riis, kemem tiin pari tikin e mara mok gii, iya kemem ka sesngeni e sunwar lo. Tangwa Riis e ta finafen ke Deo tifre tongge ri ongne singi.” ");
INSERT INTO hrw_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Biing fang kaonsiil ri ongni e sunwar ke Pita ri la balasak bakir tikin, ri kabuk su bura ini riu paketmet ire fan apostel. ");
INSERT INTO hrw_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Sakle e mel e neng lo re fang kaonsiil a, e ta Farasi. Asow gii, Gamaliel. I e ta titsa lo fafanau ke Moses ma tongge nano ri natkeni tikin. I e ti ulo falifu lo re fang kaonsiil ma ka fauun ini riu bi uun suu ire fan apostel lo borom pansumbiing e su pospos. ");
INSERT INTO hrw_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ma ka war singre fang kaonsiil, “Gam na tongge tingna Israel, gam u sangsang kausi tikin use sa gau bur gow lo re tongge gii. ");
INSERT INTO hrw_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Famu Teudas e ti suupuek ka bom kepfeti ini i na kaltu bakir, ma e fet e atis na kaltu ri tiim tura. Sakle ri paketmet ini ma tongge ri mimi nami ri ka bes fafalek, ma fam fagati kia kabuk su la ta mok fofoes. ");
INSERT INTO hrw_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Wimi ini Judas tingna Galili ka ti suupuek lo biing gapman e kepe asasre tongge. E uunre galung kaltu ri ka minami ma ri ka fapaket tura gapman, sakle ri paketmet ini ming ma tongge ri ti tura, ri fin ri ka la falek. ");
INSERT INTO hrw_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ma gii ya peteng tif gam, gam u tibi gow e ti mok lo re tongge gii, gaman su touf ri ku la. Anwarow, le ka ta ini mok gii ri ka gow e ta tinglo sangsang ke kaltu, eu la ta mok fofoes. ");
INSERT INTO hrw_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ma le ku ta fabur ke Deo, gam tibi fasi una faropo e mok gii singre tanga kaltu gii, ma lo sangsang gii, are gam ka fapaket singe Deo.” ");
INSERT INTO hrw_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ri ka ongni e fan warwar kia ma ri ka a-uu lo, ma ri ka tau kau mil ire fan apostel, ri ka napis ri ma ri ka fanauri tura fatungen ini ri mu tibi war fotngi mil e asow e Yesus, ma ri ka uun ri ka la. ");
INSERT INTO hrw_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Fan apostel ri ka la kosing re fang kaonsiil, ri fefeal tikin anwarow Deo e sam gau ri, ri ka fasi una kepe ongker ma tongge ri parpu iri nafow e Asow. ");
INSERT INTO hrw_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Lo fam biing nano ri tibi manau una fabenge ma sesngeni e Konona Sunwar lo Yesus ini i e ta Mesaiya, ilo bala balo lo Felun Nining Bakir ma ilo bala fam fel kere tongge. ");
INSERT INTO hrw_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ulo bala fam biing a, wewes lo re fan disaipel e fespuek fuunfuun. E mel e borom balasak ulo falifu lo re fan Juda. Fa gii ri kinen Grik, ri balasak ire fa tuman gii, ri ka kinen Ibru, anwarow fan makos keri, fan Ibru ri tibi fenfen ri lo fan tuan ri kepkepe lo tikii neng, tikii neng e biing. ");
INSERT INTO hrw_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Iya sangful ma e u na apostel ri ka tau tiim ire fan disaipel nano ma ri ka peteng tifri aregii, “Eu tibi riis sing kemem, le kemem ku touf sok lo faim una sesngeni e sunwar ke Deo ma kemem ku su sangsang use faim una faseni e fan tuan ma mani. ");
INSERT INTO hrw_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ma gii tanga tuaklik, gam u towfu e baba fis na ti kaltu tinglo falifu lo gam, iya gam ka parfat lo ri ini ri fuunuf ine Tangwa Riis ma atausimale. Kemem ku touf ri usi riu efe lo mus gii. ");
INSERT INTO hrw_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ma kemem tibom kemem u tow e sinangumem kiruur ilo nining, ma faim una sesngeni e sunwar ke Deo.” ");
INSERT INTO hrw_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Tongge nano a ri fefeal lo fagati kere fan apostel ma ri ka sikii e Stiwen kaltu titinge kia e raw ma e fuunuf ine Tangwa Riis, ma Filip, Prokorus, Nikanor, Timon, Parmenas ma Nikolaus tingna Antiok. E tibi ta i tingna Juda sakle e kau ulo lotu keri. ");
INSERT INTO hrw_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ri ta ri ka la tifre fan apostel, ri ka nining ma ri ka tow e limlimri ulo ri. ");
INSERT INTO hrw_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ma sunwar ke Deo ka omseni e male kiruur, ma tongge fuunfuun ri ka puek ka ta fan disaipel una Jerusalem. Fam pris fuunfuun ming, ri usi e sunwar ke Deo ma ri ka titinge. ");
INSERT INTO hrw_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Kaltu gii Stiwen e fuunuf ine warfakausi ma rawas ke Deo. E bilseni e fan mok na tibou fuut ma fan tintof bakir tikin ulo falifu lo re tongge. ");
INSERT INTO hrw_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Sakle e mel e galu lo re tongge ri matet ma ri ka fapaket ine fan warwar tura Stiwen. E ta ri na tongge tinglo Felun Nining kere fam Fridman (Ri sau peteng ini.) Tongge a e ta fan Juda tinglo taon Sairini ma Aleksendria, ma tongge tinglo um prowins Silisia ma Eisia. Tongge gii ri fatinge tura Stiwen. ");
INSERT INTO hrw_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Sakle ri tibi fasi una kulfi e Stiwen lo warwar kia, le Tangwa Riis e tow e konona parfat tifi una gon singri. ");
INSERT INTO hrw_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ri war borong ta nabalre fa lo re tongge ini riu peteng aregii, “Kemem ongni e Stiwen e gon ine fan warwar una fotpursi e Moses ma Deo.” ");
INSERT INTO hrw_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ma lo sangsang a, ri bero ine balbalre tongge. Tongge lamlam ma fan titsa lo fafanau, ri ka bingfamti e Stiwen ma ri ka onu ka la ti u famu ire fang Kaonsiil. ");
INSERT INTO hrw_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ri ka feti e fa lo re tongge una seseng gurgurum talo. Tongge a ri seseng aregii, “Kaltu gii, e sagisu warwar una bero ine Felun Nining Bakir ma fafanau ke Moses. ");
INSERT INTO hrw_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Kemem sam ongni e peteng aregii, kaltu gii Yesus tingna Nasaret eu bero ine Felun Nining Bakir, ma ku pilsi e ninis Moses e tow tif kiar.” ");
INSERT INTO hrw_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Tongge nano ri kiiskiis ulo felung Kaonsiil, ri alal rawas lo Stiwen ma ri ka pari e mata e ngo are mata e ton anggelo. ");
INSERT INTO hrw_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Wimi paklure fam pris ka gatmo aregii, “E tikin e fan warwar tongge gii ri gow talo o?” ");
INSERT INTO hrw_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ma Stiwen ka koso aregii, “Tanga tuaklik ma tanga tabuung, gaman ong sing yau! Famu ma tuprer Abra-am kamu la melmel una Aran, Deo na finaswen e sau puek talo una Mesapotemia. ");
INSERT INTO hrw_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Ma Deo ka war aregii singi, ‘La kosnge kem kaontri ma tongge kiam, ma o ku la wilo male yau fanangsi o ini.’ ");
INSERT INTO hrw_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Iya Abra-am ka matet tinglo nal kere fang Kaldia ma ka la melmel una Aran. Ma wimi ine minet lo tamow, Deo kam tuleni wilo nal gii a gam ka melmel ailo. ");
INSERT INTO hrw_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Deo e tibi tow e ti boron iri lo nal a ini eu fasi lo tikii mita tife Abra-am, sakle Deo e limlim ini eu tow e nal a kia, tiim tura re fesa wimi. Lo biing Deo e tow e limlim a, Abra-am e tifik tek ti sikow. ");
INSERT INTO hrw_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Deo e peteng tife Abra-am aregii, ‘Fesam riu la ilo neng e kaontri, usi riu ta tongge na faim fofoes kere neng e fa, ma ri ku bero iri lo e fet e atis na matamfaim. ");
INSERT INTO hrw_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Sakle yau fabu-i re tongge a fesam ka ta tongge na faim fofoes singri. Ma wimi ri ku la tinglo kaontri a, ri ku sa nining ma resngeni e asang ilo male gii.’ ");
INSERT INTO hrw_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Kala Deo ka tow e ninis na tales pinpinumfore, are tintof lo war a-uu e tow tifi. Ma wimi Abra-am ka ta tamow e Aisak, ma ka talsi e pinumfow e Aisak lo e wal e biing wimi ini e fuut. Wimi Aisak kam ta tamow e Jekop, ma Jekop kam ta tamow e tikii sangful ma e u na funmat. ");
INSERT INTO hrw_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Anwarow fam funmat ri balasak ine Josef, ri umat ini are kaltu na faim fofoes tifre fan Ijip. Sakle Deo e melmel tura. ");
INSERT INTO hrw_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Deo e faliungeni kosngi e fan mafet kia. Deo e tow e konona parfat tife Josef, aregii, king tingna Ijip kau bura tikin ma ka towfu ka ta kaltu bakir kere fan Ijip, ma ka efe lo mara mok ilo fel ke king. ");
INSERT INTO hrw_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Wimi singmat na biis bakir e fespuek una Ijip ma una Kenan, ka fafuutngeni e singmat na ongker. Ma tumtumlarer ri ka tibi fasi una tupngeni e ti tuan. ");
INSERT INTO hrw_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ma Jekop ka ong ini e mel e wit una Ijip. I ka tuleni e tanga tumtumlarer una la baba tikii una Ijip. ");
INSERT INTO hrw_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Lo ninla baba e u keri, Josef kau peteng tife tanga tualik ini i gii se. Ma king tingna Ijip, kau parfat kausi lo fumberat lo Josef. ");
INSERT INTO hrw_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Josef ka tow e sunwar ma ka fauun use tamow Jekop ma fumberat kiruur kia. E fis e sangful ma e lim lo ri. ");
INSERT INTO hrw_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Kala Jekop ka la ding una Ijip ma ka la met. Ma siksikow ming ri ka la famete. ");
INSERT INTO hrw_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ma ri ka kepkepfamilre e pinpinumfori, ri ka la mil tura ri una Sekem. Ri ka la ofofri ulo matmat gii Abra-am ka fiilufu singre fan siksikow e Amor ine mani. ");
INSERT INTO hrw_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Biing e sau puek fatat ma Deo ku fawetu e ke warkale e sam tow tife Abra-am, gii wewes lo tongge lo kiar ri melmel una Ijip, ri ka puek ka la fuun tikin. ");
INSERT INTO hrw_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Wimi neng e king e tibi parfat lo Josef e efe lo male na Ijip. ");
INSERT INTO hrw_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","King a e gow e ansinang lo tuptuprer, ma ka gow e sinang saksak ka tow e mafet tifri ma ka tungen ri una bas ine siksikwari ini ri ku met. ");
INSERT INTO hrw_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Lo biing a Moses e fuut, i e par kausi tikin, ma lo e tuul e amfuniil ri fangteni ulo bala fel ke tamow. ");
INSERT INTO hrw_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Biing ri towfu una male, sikow fefin e king tingna Ijip e kepe ma ka fangteni are sikow tibom. ");
INSERT INTO hrw_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ma Moses ka fabenge lo konona fam parfat kere fan Ijip, ma i e rawas tikin una war ine fan warwar, ma una gow e fan mara mok. ");
INSERT INTO hrw_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Biing Moses e sam la fet e sangful na matamfaim kia, i e sangsang una la fu lo re fan taltalu, tingna Israel. ");
INSERT INTO hrw_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ma ka pari e neng lo re fan Ijip e bero ine neng lo re fan Israel. E ulsi e neng tingna Israel ka paketmet ine neng tingna Ijip. ");
INSERT INTO hrw_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moses e sangfi ini fan taltalu tibom riu parfat ini Deo e bur ules ri lo limow, sakle ri tibi parfat. ");
INSERT INTO hrw_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Biing usi Moses e pare un Israel ru fapaket. E tofo ka ti na sol singru ma ka war, ‘Ung kaltu kamu su ta latualik. Usi e tamu kamu ka pete ongker i kamu tibom?’ ");
INSERT INTO hrw_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Sakle kaltu gii ka tofngeni e tubiil, e suleni e Moses ka la ulo galu ma ka war, ‘Se e tauf o ini o ku ta kaltu na efe ma una ikse kemem? ");
INSERT INTO hrw_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","O bala paketmet i yau, are kaltu tingna Ijip lewa o ka paketmet ini nabiing?’ ");
INSERT INTO hrw_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Biing Moses e ongni e war aiya, i e fin ka la ulo nal kere fan Midien ka la melmel are ses. I e la tinaule ma ka mel e un sikow tamat. ");
INSERT INTO hrw_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Wimi ini e fet e sangful na matamfaim e sam la, neng e anggelo ka fespuek talo Moses ulo male mas ma ulo bala iif karef e sok ulo balan mok, fatatu e paklunmale Sainai. ");
INSERT INTO hrw_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Biing Moses e pari e mok gii, i e sangfuunfuun. E bura ini eu par fakausi gii ka la fatatu ma ka ongni e Taufi e peteng tifi aregii, ");
INSERT INTO hrw_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Ya ta Deo kere tanga tumtumlam. Ya ta Deo ke Abra-am, Aisak ma Jekop.’ Ma Moses ka ban ma ka soke una mu par. ");
INSERT INTO hrw_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Kala Taufi ka peteng tifi, ‘Kepufu e sendel kiam, nal gii o ka titi ilo e tarawen. ");
INSERT INTO hrw_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ya sau pari e fan sinang saksak ri gow lo re tongge kiang ina Ijip. Ya sam ongni e tengteng keri, gii ya ka sa la una ules ri usi riu faliufori. Ma gii kasa, yau tule famil o wina Ijip.’ ");
INSERT INTO hrw_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Famu fan Israel ri guuluung ine Moses ma ri ka war, ‘Se e touf o ka ta kaltu una efe ma una ikse kemem?’ Kaltu gii Moses, Deo tibom e kep famila tikin lo anggelo e fespuek talo are angkarfian iif ulo balan mok. I e tuleni ini ku ta efefe ma kaltu una faliungeri. ");
INSERT INTO hrw_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","I e famu iri ka suu tingna Ijip, ma ka gow e fan mok na tibou fuut ma fan tintof una Ijip, ulo sung kasap buuluum, ma lo e fet e sangful na matamfaim ulo male e tek ti kaltu. ");
INSERT INTO hrw_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“I mung e Moses gii ka peteng tifre fan Israel aregii, ‘Deo eu tuleni e ti profet eu ngo are yau tibom tinglo falifu lo re tongge kemi tibom.’ ");
INSERT INTO hrw_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","E sam ta i unais re tongge tingna Israel, ri kep tiim iri ulo male e tek ti kaltu. E ta i tura tumtumlarer, ma anggelo se e war singi ulo paklunmale Sainai, ma ka kepe sunwar na ninliu, ini ku tow tif kiar nano. ");
INSERT INTO hrw_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Sakle tuptuprer ri guuluung una ong singi. Ri su parufu ma ulo balbalri, ri bura ini riu la mil ina Ijip. ");
INSERT INTO hrw_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ma ri ka peteng aregii tife Aron, ‘Gow e ti ton deo kemem, usi riu la famu i kemem. Kemem am tibi parfat lo sa e sam la gow e kaltu gii Moses lewa ka uun suu i kemem tingna Ijip.’ ");
INSERT INTO hrw_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Lo i e biing a, ri gow e deo gurgurum, ma e ngo are tom buuluumakau. Ri ka tow e fam finafen tife buuluumakau a ma ri ka gow e singmat na en tiim una gasgas lo sa ri bom gow ine limlimri. ");
INSERT INTO hrw_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Sakle Deo e la kosingri ma ka toufri, ri ka nining singe pisii, ma funiil ma fang keltot tinglo balambat aregii ri kabuk seti ilo bala buk kere fam profet. ‘Gam na tongge tingna Israel, biing gau melmel lo e fet e sangful na matamfaim ulo male mas, ma gam ka paketmet ine fam buuluumakau ma fan sipsip, gam ka fafen ini. Areini, gam tow e fam finafen gii tif yau? ");
INSERT INTO hrw_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Gam resresngeni lala ming e telsenge lo Molek ma angkeltot lo deo gurgurum kemi Refan. Fan telsenge gii gam ka gow una nining lo ri. Yau mung, ya mu tii i gam, gam ku la melmel ilo galu lo kaontri Babilon.’ ");
INSERT INTO hrw_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Biing fan tuptuprer ri melmel ulo male mas, ri mel e Felun Sel una sesuupuek ine Deo e ta tura ri. Ma biing ri gow e Felun Sel a, ri gow e fan mara mok nano aregii Deo ka peteng tife Moses ini. Ma ri ka usi sekit aregii Moses ka pari. ");
INSERT INTO hrw_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Wimi siksikuare tuptuprer ulo pikliu e efefe ke Josua, ri subung kepkepe lala e Felun Sel, ming tura ri, una kepe nal singre fa fan tongge Deo e tii iri famu. Felun Sel a ka melmel ulo nal a ka muut lo biing ke Dewit. ");
INSERT INTO hrw_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","I e kaltu gii e tongeni tikin e fabur ke Deo, ma ka gatom ini Deo eu towfu ku gow e ti felu e Deo ke Jekop. ");
INSERT INTO hrw_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Sakle e am ta Solomon e gow e fel kia. ");
INSERT INTO hrw_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Are lea, Deo Iyat Sekit e tibi melmel ilo ti fel, ri gow ine limang kaltu, aregii profet ka peteng: ");
INSERT INTO hrw_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Taufi e war aregii, “Balambat e ta sia king kiang, ma nal e ta male una famanaungeni e ung kekeng. Ma sese fel gii o amu gow kiang? Tam iya e male una mu manau sing yau? ");
INSERT INTO hrw_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ka bi su ta ini limang legii e bilseni e fan mara mok gii.” ’” ");
INSERT INTO hrw_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Ma Stiwen ka war ming aregii, “Gam na tongge na ongonguf, balbalmi ma balbalumi e kut are fan aiden. Mingne gam onguf singe Tangwa Riis are tuptupmi ri gow nangen. ");
INSERT INTO hrw_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","E tifik tek ti profet tumtumlami rik bero ini? Nangen ri paketmet ire tongge ri fes tura sunwar ke Deo, lo fespuek ke kaltu Tarawen. Ma gii gam sam solamufu ma gam ka paketmet ini. ");
INSERT INTO hrw_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Imung gam gii, gam sam kepe e fafanau ke Deo tinglo limlimre fan anggelo, sakle gam tifik usi.” ");
INSERT INTO hrw_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Biing ri ongni, ri balasak tuntun tikin, ma ri ka ngungutfat usi. ");
INSERT INTO hrw_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Sakle Tangwa Riis e fafonsi e Stiwen, ka par wiyat wilo balambat, ka pari e finaswen ke Deo ma Yesus e titi ulo galu miil lo Deo. ");
INSERT INTO hrw_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ma Stiwen ka war aregii, “Par! Ya pari e balambat e ipiik, ma Sikow e Kaltu ka titi ilo galu miil lo Deo.” ");
INSERT INTO hrw_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ri ongni e war aiya ri ka fakuta e balbaluri, ri ka fakaunge ma ri ka filau usi, ");
INSERT INTO hrw_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","ri ka tatfe suu ini tinglo siti ma ri ka tofnge una rangu ine fatfat. Tongge a ri ka gow e fan warwar gurgurum talo, ri tatauf fang kolos keri ulo fow e ung kekow e neng e guam ri fotngi ini Sol. ");
INSERT INTO hrw_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Biing ri rangrangu ine fatfat, Stiwen ka nining aregii, “Taufi Yesus, kepe tangwang.” ");
INSERT INTO hrw_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Wimi ka kiis pukungkek ma ka tau bakir, “Taufi mele koso e fan tubiil ri gow!” Stiwen ka war aiya, ma ka luut ka met. ");
INSERT INTO hrw_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sese sinang ri gow lo Stiwen, na mata e Sol, ulo bala e su a-uu lo. Lo biing a ri ka pakti e Stiwen, ri bero ine sios una Jerusalem, ma tongge titinge, ri nano ri ka la falek una Judia ma una Samaria. Sakle fan apostel ri mel sok una Jerusalem. ");
INSERT INTO hrw_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Fa lo re tongge ri usi e sinang Deo e bura, ri ka kepe Stiwen ri ka la ofo, ma ri ka fatengse bakir tikin usi. ");
INSERT INTO hrw_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Safle Sol e tofnge una bero ine sios. E kau ulo bala fam fel ka tatfe suusuu ire antamat ma gelefin ka taufri ulo rerek. ");
INSERT INTO hrw_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Tongge titinge gii ri ka fin falek, ri sesngeni e konona sunwar tifre tongge ulo fan male gii ri ka la ulo. ");
INSERT INTO hrw_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filip e la ulo siti ina Samaria, ma ka sesngeni e konona sunwar lo Kristus tifri. ");
INSERT INTO hrw_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Tongge fuunfuun ri ongni e fan warwar ke Filip, ma ri ka pari e fan mok na tibou fuut e gow, ma ri ka tange fakausi e balbaluri una ongni e fan warwar i e sesngeni tifri. ");
INSERT INTO hrw_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Ri pari e Filip e tii ine fan tangwaner saksak ulo re fa fuunfuun. Fan tangwaner a ri ka la kaung bakir sak ma ri ka la tinglo ri. Ma fa ri dol, ma fa kekekri e sak, ri liu mil. ");
INSERT INTO hrw_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ulo siti a tongge ri fefeal bakir tikin. ");
INSERT INTO hrw_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ting famu e mel e kaltu asow gii Saimon. I e sau fafaimngeni e fam bilbilse kia ulo siti a, ma e pete sangfuunfuun ire tongge nano tingna Samaria. I e bom kep bakir lo ini i e sam ta neng e kaltu bakir ming. ");
INSERT INTO hrw_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Tongge lamlam ma tongge fofoes ri nano ri ongne tikin singe Saimon. Ri peteng ini kaltu gii e ta rawas ke deo, gii ri ka parfat lo, ini Singmat na Rawas. ");
INSERT INTO hrw_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ri mimi lala nami, anwarow ting famu i e sau pete sangfuunfuun iri ine fam bilbilse kia. ");
INSERT INTO hrw_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Sakle biing ri ongni e Filip e sesngeni e konona sunwar lo kepmale ke Deo ma lo asow e Yesus Kristus, antamat ma gelefin, ri nano ri titinge ma ri ka kepe e amfagu tarawen. ");
INSERT INTO hrw_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Ma Saimon tibou ming e titinge ma ka kepe e amfagu tarawen, ma ka la nami e Filip ulo fan male e fes lala ulo. I e la kuufsak le e pari e singmat na fan tintof ma fan mok na tibou fuut. ");
INSERT INTO hrw_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Biing fan apostel ri melmel una Jerusalem, ri ong ini fan Samaria ri kepe sunwar ke Deo, ri ka tuleni e Pita ma Jon usi ri. ");
INSERT INTO hrw_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Biing un apostel ru la fespuek, ru ka nining usi ri ini Deo eu tow e Tangwa Riis tifre fan Samaria, ");
INSERT INTO hrw_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","anwarow Tangwa Riis e tifik puek ulo tikas lo ri. Ri su kepe e amfagu tarawen lo asow e Taufi Yesus. ");
INSERT INTO hrw_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Wimi Pita ma Jon ru ka tow e limlimru uyat ulo ri, ma ri ka kepe Tangwa Riis. ");
INSERT INTO hrw_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Biing Saimon e pari ini un apostel ru tow e limlimru uyat ulo iri, ma ri ka kepe Tangwa Riis, i ka kepe mani ka tow tifru, ");
INSERT INTO hrw_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ma ka war, “Kamun tow e raw a tif yau ming, usi ini seri nano na tongge a, ya ku tow e limang iyat ilo ri, riu kepe Tangwa Riis.” ");
INSERT INTO hrw_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Safle Pita e koso aregii singi, “E fasi ini mani kiam tiim tura o eu tam sekit i kamu, anwarow o sang ini o fasi una feli e finafen ke Deo ine mani. ");
INSERT INTO hrw_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","E tek ti su kiam, tam ti galu kiam ilo bala mus gii, anwarow balam e tibi riis na mata e Deo. ");
INSERT INTO hrw_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Ma gii on sangikis ine sinang saksak kiam, ma o ku nining singe Taufi. Antalu le ku tengis o ma ku sangintafngi e sangsang saksak e mel ailo balam. ");
INSERT INTO hrw_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Le ya pari ini o fuunuf ine fan sinang na mer, ma fan sinang saksak e bingfamti o.” ");
INSERT INTO hrw_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ma Saimon ka koso aregii, “Kamun nining singe Taufi usi yau, usi ini mara mok gii kamu kabuk peteng ini, eu tibi fuut lo yau.” ");
INSERT INTO hrw_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Wimi un apostel ru ka sesngeni e sunwar ke Taufi ma ru ka peteng suupuek ine fan mok Taufi e gow lo ru. Pita ma Jon ru ka la mil una Jerusalem ma lo fines ke ru, ru sesesngeni lala e konona sunwar ulo fan male fuunfuun ina Samaria. ");
INSERT INTO hrw_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Nenge anggelo ke Taufi e peteng tife Filip aregii, “On matet o ku la ilo galu isuu. O ku la ilo sal gii ka pu tingna Jerusalem wina Gasa.” (E ta sal ilo male mas.) ");
INSERT INTO hrw_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","I ka la ma ka la tongeni e neng e kaltu tingna Itiopia. Kaltu gii ri pua ma e ta efefe lo felun mani ke kwin asow gii Kandasi tingna Itiopia, e sam la una Jerusalem kala nining, ");
INSERT INTO hrw_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ma lo biing e la mil e kiis ulo karis kia, ma ulo sal e weswese lala e buk ke profet Aisaiya. ");
INSERT INTO hrw_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ma Tangwa Riis ka peteng tife Filip aregii, “La o ku la fesfes fatatu lala e karis leii.” ");
INSERT INTO hrw_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Iya Filip ka filau fatat ma ka ongni e kaltu a e weswese e buk ke profet Aisaiya. Ma Filip ka gatmo, “Areini, o ten lo sunwar a o ka weswese, tam e tam?” ");
INSERT INTO hrw_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ma i ka war, “Are le yau ten ma ka tek tikas una fatiti yau ini?” Ma i ka gatmo e Filip ini eu fen kanek ku la kiis tura. ");
INSERT INTO hrw_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Su lo buk i e wese e peteng aregii: “Ri tatfeni are sipsip una la pakti. Ma e tek borong sok lo are boron sipsip ri bala keti e ololow. Iya i ka ti ipki e ngusu. ");
INSERT INTO hrw_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ri par pu ini ma ri ka tibi anganggon kausi singi. E tek tikas eu fasi una tet ire fesa wimi, le ninliu kia ri sam tii ini tingga lo nal.” ");
INSERT INTO hrw_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Efefe tinglo felun mani ka koso singe Filip ma ka war, “Peteng tif yau, se tikin legii profet e warwar lo? E warwar lo i tibom, tam lo tikas kuriik?” ");
INSERT INTO hrw_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Kala Filip ka tofnge sekit tinglo borong kepti a lo sunwar ke Deo, ma ka fabenge ine konona sunwar lo Yesus tifi. ");
INSERT INTO hrw_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ma lo fines keru ulo sal, ru la puek ulo fow e dan, ma kaltu a ka war, “Par, dan gii! Sese mok e kale yau una kepe e amfagu tarawen?” ");
INSERT INTO hrw_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Ma Filip ka peteng tifi, “Le o ku titinge tikin ine balam, o fasi.” Ma kaltu a ka koso singi, “Ya titinge ini Yesus Kristus e ta Sikow e Deo.” ");
INSERT INTO hrw_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","I ka tau singe daraiwa lo karis una manau. Ma ru nano ru ka tiin pu wilo bala dan, ma Filip ka gu tarawen ini. ");
INSERT INTO hrw_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Biing ru kanek mil tinglo bala dan, saupe tikin Tangow e Taufi ka kepe Filip ka la ma kaltu a e am tibi pari mil. Safle kaltu a e tofngeni mil e fines kia tura fefeal. ");
INSERT INTO hrw_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filip e kuufsak ini i e sam la ta una Asotus. Ma lo fines kia tingna Asotus wina Sisaria, i e sesngeni lala e konona sunwar ulo fan mara taon. ");
INSERT INTO hrw_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Lo sumbiing a, bala e Sol e tuntun tikin uwa ma ka rawas tikin una paketmet ire fan disaipel ke Taufi. I ka la use paklure fam pris, ");
INSERT INTO hrw_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ka la gatmo use fam pas wilo fam felun nining ina Damaskus, usi ini eu sikse re ti antamat, tam gelefin gii ri ka usi e sal ke Yesus, i eu kawe ri ma ku kep ri, ri ku la ilo rerek ina Jerusalem. ");
INSERT INTO hrw_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Biing i e fespuek fatat una Damaskus, saupesak anten tinglo balambat ka sosok liflifti. ");
INSERT INTO hrw_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","I ka luut ulo nal ma ka ongni e angkiimkiim a neng e kaltu e war singi, “Sol, Sol! Usi e tamu o ka bero i yau?” ");
INSERT INTO hrw_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ma Sol ka koso, “Kaltu bakir, o se?” Ma angkiimkiim a ka koso, “Yau Yesus, se a o ka berbero ini. ");
INSERT INTO hrw_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ma gii on matet ma o ku la ilo siti. Tikas e mu la peteng tifo ine fan mok o samusu gow.” ");
INSERT INTO hrw_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Tongge ri mimi lala nami e Sol, ri titi wa ma ri ka la tek borong sok. Ri ongni e angkiimkiim a neng e gongon, sakle ri tibi par tikas. ");
INSERT INTO hrw_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sol e matet tinglo nal ka ipki e wanmata, sakle i e tibi fasi una par timok. Iya ri ka su puse na limow, ri ka kaulek una Damaskus. ");
INSERT INTO hrw_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Wanmata e baf lo e tuul e biing, e tibi en ma e tibi in. ");
INSERT INTO hrw_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Nenge disaipel e melmel una Damaskus, asow gii Ananaiyas. Ulo mok e ngo are numbiil, Taufi e tau ini aregii, “Ananaiyas!” Ma i ka koso, “Taufi, yau gii.” ");
INSERT INTO hrw_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ma Taufi ka war singi, “Matet o ku la ilo fel ke Judas ilo sunsal asow gii, Sal Riis. O ku la gatom use kaltu tingna Tarsus ri fotngi ini Sol, le i e melmel ka nining. ");
INSERT INTO hrw_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ma ulo mok e ngo are numbiil, Sol e sau pari e kaltu asow gii Ananaiyas, e fespuek ka sa tow e limow ulo, una gow e wanmata ku par mil.” ");
INSERT INTO hrw_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ma Ananaiyas ka koso, “Taufi, ya sam ongni e fan warwar fuunfuun lo kaltu gii. I e gow e fan sinang e tibi riis una bero ire tongge riis kiam ina Jerusalem. ");
INSERT INTO hrw_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ma gii, i e kepe rawas singre fam pris lamlam, una kepre tongge gii ri ka nining ma ri ka taungeni e asam, wilo rerek.” ");
INSERT INTO hrw_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Safle Taufi e peteng aregii tife Ananaiyas, “On la! Kaltu gii, ya sam sikii ini ku ta kaltu na mus kiang. Usi ini i eu sesuupuek ine asang tifre fan Jentael, fang king keri ma tifre tongge tingna Israel. ");
INSERT INTO hrw_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Yau fanangsi ine fan mara mafet ma fan ongker i e samusu kepe nafow e asang.” ");
INSERT INTO hrw_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Wimi Ananaiyas e la, ka la kaulek ulo bala fel, ka la tow e limow ulo Sol ma ka war singi, “Tuaklik Sol, Taufi Yesus lewa ka puek talo o ulo sal lo biing o sa la wi wagii, i gii ka tule yau usi o, usi ini o ku par mil, ma o ku fuunuf ine Tangwa Riis.” ");
INSERT INTO hrw_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ma saupesak mok e ngo are ampinun ngow ka luut tinglo wanmata e Sol, ma ka fasi una par mil. Ma i ka matet ka kepe amfagu tarawen. ");
INSERT INTO hrw_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ma wimi ini i e sam en, i e kep famila e rawas kia. Sol e bi melmel lo fanenger fam biing tura fan disaipel una Damaskus. ");
INSERT INTO hrw_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ma ka la sekit ulo bala fam felun nining kere fan Juda ma ka tofnge una fabenge singri ini, Yesus e ta Sikow e Deo. ");
INSERT INTO hrw_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Tongge nano a ri ka ongni e fan warwar ke Sol, ri kuufsak tikin ma ri ka war aregii, “Kaltu gii lewa ka bero ire tongge ri nining lo asow e Yesus una Jerusalem. Ma i e sa puek gii, una sa kepri are tongge ilo rerek tifre fam pris lamlam.” ");
INSERT INTO hrw_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Safle fan warwar ke Sol e fespuek rawas tibom, ma ka peteng ten tifre fan Juda, ri melmel ina Damaskus, ma ka peteng tikin tifri ini Yesus e ta Kristus. Ma ri am tibi la koso e ti sunwar. ");
INSERT INTO hrw_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Fam biing fuunfuun e sam la, ma fan Juda ri ka kiis tiim ma ri ka poktuui usi, ");
INSERT INTO hrw_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","sakle Sol e sam ong lo fagati keri. Ampanambiing ma ansiat fan Juda ri efefe ini ulo fan matmatangkon lo siti, una paketmet ini. ");
INSERT INTO hrw_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Sakle lo neng e panambiing tongge na ususi e Sol ri sengi ulo kes, ma ri ka fauli tinglo windou lo balo e lifti e siti. ");
INSERT INTO hrw_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Lo biing e la puek una Jerusalem, i e tofo una tiim tura fan disaipel, safle ri nano ri tiin sokeni. Ri tibi titinge lo, ini i e sam ta disaipel tikin. ");
INSERT INTO hrw_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Sakle Barnabas e onu ka la tafu tifre fan apostel. I ka seseng tifri ini are, Sol e pari e Taufi ulo sal, ma ini Taufi e tow e fan warwar tifi. Ma i ka seseng ming, ini are, Sol e fabenge rawas ine asow e Taufi una Damaskus ma e tibi soke. ");
INSERT INTO hrw_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Iya Sol ka melmel tura ri ma ka fes fawet una Jerusalem. I e tibi soke, e su rawas una sesngeni e sunwar lo Taufi. ");
INSERT INTO hrw_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","I e warwar tiim tura fan Juda ri parfat lo kinen tingna Grik ma ka fatinge tura ri. Sakle ri kukseni una paketmet ini. ");
INSERT INTO hrw_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Biing tongge na titinge ri ong lo mok gii, ri onu ka la una Sisaria ma ri kam tuleni ka la una Tarsus. ");
INSERT INTO hrw_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Tongge tinglo sios ilo male kiruur ina Judia, Galili ma ina Samaria ri melmel na fefeal ulo siaro. Ma lo faules ke Tangwa Riis, e farawasnge ri, ri ka la fuun tikin iyat iri famu ma ri ka usi e fan sinang una ta ri tikin tife Deo. ");
INSERT INTO hrw_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Biing Pita e fes fawet ulo mara male, i e la una la fu lo re tongge ke Deo una Lida. ");
INSERT INTO hrw_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ma ulo male a, i e pari e kaltu ri fotngi ini Ainias e dol, usi tutuow nano ri met. I e su ngongo ulo ngiin lo e wal na matamfaim. ");
INSERT INTO hrw_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ma Pita ka war singe Ainias, “Yesus Kristus e faliunge o. On matet, o ku terngeni e kem ngiin.” Ma saupesak i ka matet. ");
INSERT INTO hrw_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ma tongge nano tingna Lida ma tingna Seron ri ka pari ma ri ka mil use Taufi. ");
INSERT INTO hrw_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ma una Jopa e mel e disaipel e ta fefin. Asow gii Tabita ma lo warwar Grik ri fotngi ini Dokas. Lo fan mara biing i e gowgow e konona fam faim una ules re fan sasngal. ");
INSERT INTO hrw_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Lo sum biing a i e kepe anminse, ka met. Ri ka gua e pinumfow ma ri ka towfu ulo bala su uiyat lo fel a. ");
INSERT INTO hrw_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Taon Lida e su fatat sak wina Jopa, iya biing fan disaipel ri ong ini Pita e ta una Lida, ri tuleni e e u e neng lo ri usi ru ka la peteng tife Pita aregii, “Kiskam Pita, on sa la saupe usi kemem.” ");
INSERT INTO hrw_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Pita ka matet ma ka la nami ru. Ma sumbiing ri la puek, ri onu ka la ulo sum fel uiyat. Fan makos nano uwa, ri fatie liflifti e Pita ma ri ka fafatengse ma ri ka fanfanangsi ine fang kolos ma fang kael gii Tabita ka sosok, lo biing i e melmel uwa tura ri. ");
INSERT INTO hrw_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pita e uun suu ire tongge nano tinglo sum fel a, ma ka kiis pukungkek, ma ka nining. Kala i ka didiu ka par use fefin a ka met ma ka war, “Tabita on matet!” Ma fefin a ka ipki e wanmata ma biing i e pari e Pita, i e matet sekit ka la kiis. ");
INSERT INTO hrw_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pita e puse lo limow ma ka famtete ka ti. Kala ka tau ire tongge na titinge tiim tura re fan makos, ma ka tow e Lida tifri, usi le e sam liu mil. ");
INSERT INTO hrw_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Sinseng lo mok na tibou fuut Pita e gow e omseni kiruur e male na Jopa, ma tongge fuunfuun ri ka titinge lo Taufi. ");
INSERT INTO hrw_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pita kabi melmel una Jopa lo tanga biing tura kaltu ri fotngi ini Saimon. I e ta kaltu una terterngeni e pinpinumfom buuluumakau. ");
INSERT INTO hrw_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Nenge kaltu e melmel ulo taon Sisaria asow gii, Kornelius. I e ta kaltu bakir lo e tikii atis na soldia tingna Rom ma i e ta tinglo galun soldia gii ri ka foteng ri ini Galun Soldia tingna Itali. ");
INSERT INTO hrw_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","I tiim tura fumberat kia, ri ususi fakausi e fan ninis Deo e bura ma ri ka melmel ilo pikliu e fabur kia. Ma i e ules fakausi re fan Juda ri sasngal ma ka nining bingne singe Deo. ");
INSERT INTO hrw_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Lo neng e biing, e ngo are e tuul e anmatam pisii lo efef, i e pari e mok e ngo are numbiil. I e pari sekit e anggelo ke Deo, e puek talo ma ka war, “Kornelius!” ");
INSERT INTO hrw_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Kornelius e alal rawas lo tura singmat na soke ma ka gatmo, “Taufi, areini?” Ma anggelo ka koso singi aregii, “Deo e sam ongni e fan nining kiam, ma e sangsang usi e fan ninis o sagisu gowgow, una tow e mani tifre fan sasngal. Ma Deo e bura tikin e fan ninis kiam. ");
INSERT INTO hrw_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Gii ou tuleni e ti tong kaltu ku la ina Jopa, ri ku la onu e neng e kaltu asow gii Saimon, ri fotngi ming ini Pita. Ri ku la onu wagii. ");
INSERT INTO hrw_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Kaltu gii e melmel tura neng e Saimon, e ta kaltu na terterngeni e pinpinumfow e fam buuluumakau. Fel kia e su titi fatatu e semek.” ");
INSERT INTO hrw_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Biing anggelo e sam tow e sunwar tife Kornelius ma ka la, Kornelius e tau ini e u e kaltu na faim kia tura neng lo re fan soldia. I ming e sagisu ususi e fan ninis Deo e bura, ma bingne i e melmel tura Kornelius. ");
INSERT INTO hrw_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Kornelius e peteng tifri tuul ini e mara mok e sau fuut lo ma kam tule ri tuul una la wina Jopa. ");
INSERT INTO hrw_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Lo biing usi, lo siat tuntun, ri tuul fesfes lala uwa, ma Pita ka fen kanek ulo poktow e fel una la nining. Lo pansumbiing a, ri tuul sam sa puek fatatu e taon ina Jopa. ");
INSERT INTO hrw_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","I ka la biis ma ka bur en, ma biing ri bilbilseni e fan tuan uwa, i ka pari e mok are numbiil. ");
INSERT INTO hrw_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","I ka pari e Balambat e ipiik, ma neng e mok ka pu ulo nal are laplap e bakir tibom, ma e mel e mok e puse lo e fet e ngusu e laplap a. ");
INSERT INTO hrw_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ulo laplap a, e mel e mara gemgem e fet e kekek ri, fan sii ma mara talaman ming ulo. ");
INSERT INTO hrw_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ma Pita ka ongni e angkiimkiim e war singi aregii, “Matet, o ku paketmet iri ma o ku en ri.” ");
INSERT INTO hrw_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Safle Pita e koso aregii, “Taufi! Ya tibi fasi, e tifik tek ti biing gii ini ya sam eni e ti tuan e tibi kalkaliis, tam e du.” ");
INSERT INTO hrw_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ma angkiimkiim a ka war baba e u singi aregii, “Sa Deo e sam gow ka kalkaliis, mele peteng ini e du.” ");
INSERT INTO hrw_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Mok gii e fuut baba e tuul, ma saupe sak laplap a ka kanek mil ulo balambat. ");
INSERT INTO hrw_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pita e sangsang uwa use bala e numbiil kia ma tuul kaltu lewa Kornelius ka tule ri, ri fespuek ri ka sa parfat singre tongge, lo fel ke Saimon ma ri ka sa tisok ulo matangkon lo balo kia. ");
INSERT INTO hrw_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ma ri tuul ka tau, ri tuul ka gatom ini e mel e tikas e melmel a, asow gii Saimon Pita? ");
INSERT INTO hrw_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Biing Pita e sangsang uwa use numbiil Tangwa Riis ka war singi aregii, “Saimon, e tuul e kaltu ri siksik i yo. ");
INSERT INTO hrw_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Gii, matet o ku ding ifaf, mele sang fa-u una la tura ri, anwarow yau mung ya tule ri.” ");
INSERT INTO hrw_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Pita e ding ma ka war singe tuul kaltu a aregii, “Yau mung gii, ya na kaltu gam siksik ini. Anwarow lo sa gii, gam ka sala?” ");
INSERT INTO hrw_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ma ri tuul ka koso aregii, “Kemem tuul sa la tingna isa e Kornelius, kaltu bakir kere fan soldia. I e ta kaltu riis ma ming e ta kaltu e sokeni e Deo, ma tongge nano ina Juda ri ka natkeni. Nenge anggelo ke Deo e peteng tifi ini eu tau iyo, o ku sa la ilo ke fel usi eu ong lo sa, o fasi una peteng tifi ini.” ");
INSERT INTO hrw_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Aregii Pita ka uun ri tuul, ri ka kaulek ulo bala ke fel ma ka efe lo ri lo panambiing a. Biing usi Pita e matet tura ri, ma fa lo re tongge na titinge tingna Jopa, ri ka mi nami ri fet. ");
INSERT INTO hrw_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Biing usi i e la fespuek una Sisaria. Kornelius e sam tau tiim ire matambia aiya ma tanga fenfenngow ming ri ka sala, una sa nene i. ");
INSERT INTO hrw_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Biing Pita e rong una kaulek ulo bala fel, Kornelius e areni ma ka luut ufaf fatatu e ungkekow ma ka nawen singi. ");
INSERT INTO hrw_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Sakle Pita e famtete ka ti ma ka war, “Ti! Yau ming ya su ta kaltu legii.” ");
INSERT INTO hrw_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Ma Pita ka gongon lala singe Kornelius ma ru ka kau una fel. Uwa i e pari e singmat na galung kaltu ri tiim lo ri. ");
INSERT INTO hrw_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ma Pita ka war singri aregii, “Gam nano, gau parfat kausi tikin ini e tibi fasi ilo fafanau kemem ini ti Juda eu tiim tura ti Jentael, tam i eu la una la pari. Safle Deo e sau peteng tif yau ini yau tibi fotngi e tikas ini i e tibi kalkaliis tam yau tibi tiim tura. ");
INSERT INTO hrw_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Iya biing gau fatule usi yau, e tek ti sang fa-u, ulo balang ini yau tibi sa la. Ma e fasi ini yau bi gatom gam, anwarow lo sa gii gam ka fatule usi yau?” ");
INSERT INTO hrw_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Ma Kornelius ka koso aregii, “Lo pansumbiing aregii, lo e tuul e biing famu, ya nining ulo bala kek fel, lo e tuul e anmatam pisii lo efef. Saupesak neng e kaltu fang kolos kia e furat ten tikin, i e sa ti u famu i yau, ");
INSERT INTO hrw_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","ma ka war, ‘Kornelius, Deo e sam ongni e fan nining kiam ma e sangfi e fam finafen kiam tifre fan sasngal. ");
INSERT INTO hrw_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Fatule wina Jopa, usi e Saimon ri fotngi ini Pita. I e melmel ilo fel ke neng e Saimon ming, kaltu una terterngeni e pinpinumfow e fam buuluumakau, ma fel kia e ti fatatu e semek.’ ");
INSERT INTO hrw_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Iya ya ka fatule usi o sausaupe, ma e sam kausi o ka sala. Gii e sam ta kiar nano ina mata e Deo una ong lo fan mara mok Taufi e sam tungen o una sa peteng ini tif kemem.” ");
INSERT INTO hrw_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Kala Pita ka tofnge una war, “Gii ya kau parfat ini Deo e su gowgow e tikii ninis lo re tongge nano. O ting ya ma o ting ya, kiar buk su tikii lo kiar na mata e Deo. ");
INSERT INTO hrw_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Safle e bur re tongge nano tinglo mara male seri a ri ka sokeni, ma ri ka gowgow e fan sinang e riis. ");
INSERT INTO hrw_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Gau parfat lo sunwar Deo e tuleni tifre fan Juda una peteng suupuek ine Konona Sunwar lo balamaris i ailo Yesus Kristus, se e ta Taufi kere tongge nano. ");
INSERT INTO hrw_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Gau parfat lo sa e sau fuut ulo mara galgalun male nano ina Judia, tofnge tinglo taon ina Galili, wimi ini e amfagu tarawen le Jon ka sesngeni. ");
INSERT INTO hrw_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Gam sau parfat ini Deo e sam siikii Yesus tingna Nasaret, ma are e tipeni e Tangwa Riis ma rawas ulo. I e lifti lala e mara galgalun male, ka gow lala e mara mok e kausi ma ka faliungeri lala e fa ri ilo pikliu e rawas ke satan, anwarow Deo e melmel tura. ");
INSERT INTO hrw_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Ma kemeu pari sekit e mara mok i e gow ulo kaontri kere fan Juda ma una Jerusalem ine matmatmem. Ma wimi ri ka tut famti ka met ulo aupaket. ");
INSERT INTO hrw_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Safle lo e tuul e biing wimi, Deo e famtet famila kosnge minet, ma ka gow ka fes malal ini tongge nano ri ku pari. ");
INSERT INTO hrw_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","E tibi ta ini tongge nano ri pari, sakle i e puek talo kemem na tongge famu Deo e sam siik kemem una sesngeni e sunwar kia. Ma biing e matet mil kosnge minet, kemem en ma kemem ka in tiim tura. ");
INSERT INTO hrw_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ma i e tungen kemem una sesngeni e sunwar tifre tongge ma una peteng ten ini i e ta kaltu Deo e sam siikii are kaltu na anganggon singre tongge ri liu ma fa ri sau met. ");
INSERT INTO hrw_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Ma fam profet nano ri sau peteng ten ini, ini seri a ri ka titinge lo, i eu sangintafngi e fan tubiil keri lo asow tibom.” ");
INSERT INTO hrw_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Biing Pita e gongon uwa ine fan warwar gii, Tangwa Riis e pu talo re tongge nano a, ri ka ongni e sunwar kia. ");
INSERT INTO hrw_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Tongge ri titinge tingna Juda, lewa ri ka puek tiim tura Pita, ri la kuufsak, le finafen ke Tangwa Riis e pu ming talo re fan Jentael. ");
INSERT INTO hrw_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Le ri ongen ri, ri gongon ine fan warwar tinglo fanenger fan male ma ri ka katkatfarsi e Deo. ");
INSERT INTO hrw_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Ma Pita ka war aregii, “Se e fasi una kale re tongge gii una kepe e amfagu tarawen lo dan? Ri sam kepe e Tangwa Riis aregii kiar kabung kepe.” ");
INSERT INTO hrw_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Ma i kau fauun ini riu kepe e amfagu tarawen lo asow e Yesus Kristus. Wimi ri ka gatmo una melmel tura ri lo fanenger fam biing. ");
INSERT INTO hrw_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Fan apostel ma fatualik ilo bala titinge ilo male kiruur ina Judia, ri ong ini fan Jentael ming ri sam kepe e sunwar ke Deo. ");
INSERT INTO hrw_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Ma biing Pita e la kanek una Jerusalem, fan Juda gii ri ka titinge lo Yesus ri gorteni e Pita. ");
INSERT INTO hrw_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Ma ri ka war singi aregii, “Par, o sam kaulek ulo bala fel kere fan Jentael seri a, ri ka tifing kepe e ninis una tales pinpinumfori, o ka la en tura ri.” ");
INSERT INTO hrw_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Pita e tofnge una peteng ten kausi ine mara mok tifri aregii ka fuut. ");
INSERT INTO hrw_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Ya ta ulo siti ina Jopa, ya niil na nining. Ma ulo mok e ngo are numbiil, ya pari e mok e ngo are laplap bakir, ri fauli tinglo balambat lo e fet e ngusu ma ka pu unais yau. ");
INSERT INTO hrw_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ya par kausi ulo bala ma ya ka pari e mel e mara gemgem e fet e kekek ri, fan man rokai, fan sii ma mara talaman ming ulo. ");
INSERT INTO hrw_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ma ya ka ongni ming e angkiimkiim e war sing yau aregii, ‘Pita, matet o ku paketmet iri ma o ku en ri.’ ");
INSERT INTO hrw_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Sakle ya war aregii, ‘Taufi! Ya tibi fasi. E tifik tek ti mok e du, tam e tibi kalkaliis ek sam kaulek ilo ngusung.’ ");
INSERT INTO hrw_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Wimi angkiimkiim a ka war baba e u tinglo balambat aregii, ‘Ou tibi peteng ini sese mok Deo e sam gow kabung kalkaliis ini e du.’ ");
INSERT INTO hrw_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","E fatuul gorot aiya ma ka tatfe famila e fan mara mok nano ka kanek ulo balambat. ");
INSERT INTO hrw_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Riis lo sumbiing a, e tuul e kaltu ri tule ri usi yau tingna Sisaria, ri sa manau sekit ulo fel gii ya ka melmel ulo. ");
INSERT INTO hrw_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ma Tangwa Riis ka peteng tif yau aregii, ‘Ou tibi sang fa-u una la nami ri.’ E ta baba on na kaltu na titinge ming ri la tiim tura yau, kemem ka la kau ulo fel ke Kornelius, ");
INSERT INTO hrw_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","ma i ka peteng tif kemem ini i are e gorot ka pari e anggelo, e puek talo ulo bala ke fel ma ka war, ‘Tuleni e tikas ku la ina Jopa, usi e Saimon, asow ming gii Pita. ");
INSERT INTO hrw_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","I eu sa tow e warwar tifo, ma lo bala warwar a, Deo eu faliunge o tiim tura re tongge nano ilo keu fel.’ ");
INSERT INTO hrw_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Biing ya tofnge una war, Tangwa Riis ka pu talo ri, are lewa ka pu talo kiar. ");
INSERT INTO hrw_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Wimi ya ka la sagif famila e fan warwar lewa Taufi ka peteng ini, ‘Jon e gugu tarawen ine dan, safle gam, riu gu tarawen i gam ine Tangwa Riis.’ ");
INSERT INTO hrw_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Iya le Deo kabuk fen ri ine tikii matam finafen aregii kabuk fen kiar ini, na tongge a kiar ka titinge lo Taufi Yesus Kristus, yau se tikin gii, ya ku tofo una fasange singe Deo?” ");
INSERT INTO hrw_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Biing ri ongni e fan mok gii, ri am tibi la war, ma ri ka resngeni e Deo ma ri ka war, “Deo e sam a-uu lo re fan Jentael ming, ri ka sangikis ma ka tow e ninliu tifri.” ");
INSERT INTO hrw_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Gii, fa gii ri kabuk fin falek, anwarow lo bero e sasan lo minet lo Stiwen, ri fin ri ka la una Fonisia, Saiprus ma una Antiok. Ri ka sesngeni lala e sunwar tifre fan Juda tibom. ");
INSERT INTO hrw_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Fa lo ri, ri ta tongge tingna Saiprus ma fa ri ta tingna Sairini, ri la una Antiok ma ri ka la sesngeni lala ming e Konona Sunwar lo Taufi Yesus, tifre tongge tingna Grik. ");
INSERT INTO hrw_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Rawas ke Deo e ta tura ri, iya, ka gau re tongge fuunfuun tikin, ri ka titinge ma ri ka didiu mil use Taufi. ");
INSERT INTO hrw_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Tongge tinglo lotu ina Jerusalem ri ong ini tongge fuunfuun ri titinge, iya ri ka tuleni e Barnabas ka la usi ri una Antiok. ");
INSERT INTO hrw_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Biing i e la fespuek una Antiok, i e pari sekit e tikin lo warfakausi ke Deo, e famtet re tongge. Bala e gasgas tikin ma ka war farawasnge ri, ini ri samusu towfu tikin e balbalri ilo Taufi. ");
INSERT INTO hrw_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","I e ta konona kaltu e fuunuf ine Tangwa Riis ma titinge. Ma singmat na galung kaltu tikin, ri ka ta ri tife Taufi. ");
INSERT INTO hrw_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Wimi Barnabas ka la una Tarsus una la sik ine Sol. ");
INSERT INTO hrw_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Ma lo biing i e tongeni e Sol, i e onu ini ru ku la mil una Antiok. Barnabas ma Sol ru melmel una Antiok lo tikii matamfaim kiruur, ru ka tautau tiim ire tongge tinglo Lotu ina Antiok, ma ru ka fafabenge singe singmat na galgalung kaltu. Ma fan mara disaipel a, ri tofngeufu e as gii Kristien ulo ri, una Antiok. ");
INSERT INTO hrw_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Lo sumbiing a, fa lo re fam profet ri ding tingna Jerusalem, ri ka la una Antiok. ");
INSERT INTO hrw_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Neng lo ri asow gii Agabus, i e matet ka ti ma lo rawas ke Tangwa Riis, ka warfot lo biis bakir ini eu fespuek ilo male kiruur gii fan Rom ri ka efe lo. (Mok gii e fuut lo biing Klaodius e ta king.) ");
INSERT INTO hrw_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Lo parpar ke tikii neng, tikii neng lo re fan Disaipel ma lo rawas kia tibom, i e sangsang una tow e ti faules tifre fan tualik ri gii ri ka melmel ina Judia. ");
INSERT INTO hrw_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ma gii, ri gow ma ri ka tuleni e fam finafen keri tife Barnabas ma Sol, usi ini ru mu la tow tifre tongge lamlam keri. ");
INSERT INTO hrw_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ma lo biing a king Erot e tofnge una bero ine fa lo re tongge tinglo bala sios. ");
INSERT INTO hrw_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ma i ka fauun, ri ka paketmet ine Jeims tualik ke Jon ine bainat. ");
INSERT INTO hrw_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Biing Erot e pari ini fan Juda ri fefeal lo mok i e sam gow, ka fauun ini tongge riu bingfamti e Pita ming. (Mok gii e fuut lo biing, En Bakir lo Beret e tek ti Is lo.) ");
INSERT INTO hrw_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Wimi ini ri sam bingfamti e Pita, Erot ka towfu ulo rerek, ma kam tow tifre tikii sangful ma e on na soldia una efe lo. Erot e sangsang una uun suu ini una ti ilo anganggon na matfuun, wimi ine En na Kepsiliwi. ");
INSERT INTO hrw_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Pita e sam ta ulo bala felun rerek, sakle tongge tinglo sios, ri nining rawas tibom singe Deo una ulsi. ");
INSERT INTO hrw_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Lo panambiing famu ini ma Erot kamu tow e Pita tifre tongge, i e masun falifu ini e u e soldia. Ri kawi ini e u e sen, ma e mel e fan efefe ri titi ming ulo matangkon. ");
INSERT INTO hrw_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ma saupesak neng e anggelo ke Taufi ka puek, ma ansinsokow ka ten ulo bala felun rerek. Ma anggelo ka posi e Pita ulo anggalum fow, ka fongni ma ka war, “Matet saupe!” Ma sen ka luut tinglo un limow e Pita. ");
INSERT INTO hrw_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ma anggelo ka war aregii, “Diidiit ine aneueu kiam ma o ku los lo kem su.” Ma Pita ka usi aregii i ka peteng. Ma anggelo ka war ming, “Los lo kolos tapak kiam ma o ku mi naming.” ");
INSERT INTO hrw_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Pita ka fami nami ru ka suu tinglo bala felun rerek, sakle i e tibi parfat lo sa anggelo e gowgow e fespuek tikin. I e sangfi ini i e su parpari e mok e ngo are numbiil. ");
INSERT INTO hrw_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ru sol paket singe efefe baba tikii, ru ka la sol paket singe neng e u, ru ka la puek ulo matangkon una la ilo siti. Matangkon a e bom sasau ma ru ka suu una male. Ru ka usi e neng e sal ru ka la ma saupesak anggelo ka la kosngi. ");
INSERT INTO hrw_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Gii Pita e la ten ma ka war aregii, “Gii ya kau parfat a, ini e tikin, Taufi e tuleni e anggelo kia una kepfamil yau tinglo limow e Erot, ma kosnge fan mara mok fan Juda ri sangfi una gow lo yau.” ");
INSERT INTO hrw_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Biing i e parfailmi e mok gii, i e la ulo fel ke Maria tinow e Jon, neng e asow ming gii, Mak. Tongge fuunfuun ri tiimtiim lo ri wa ma ri ka nining. ");
INSERT INTO hrw_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Pita e sa pakteni e matangkon una male lo fel ma neng e fefin na mus asow gii Roda, ka sa la una la par ini se. ");
INSERT INTO hrw_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Biing e ongen failmi e angkiimkiim a Pita, i e am tibi ipki e matangkon anwarow bala e fefeal tibom, e su la filau mil ka la peteng tifre tongge aregii, “Pita e sam ta i gii na male!” ");
INSERT INTO hrw_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ri ka war singi aregii, “E ngo areini o lomba be?” Sakle i e su tingting rawas tikin singri ini e tikin. Ma ri ka war, “Eu ta ke anggelo la.” ");
INSERT INTO hrw_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Sakle Pita e tuktukeni uwa e matangkon. Ma biing ri ipki e matangkon ma ri ka pari e Pita, ri kuufsak tikin usi. ");
INSERT INTO hrw_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Ma Pita e fanauri ine limow ma ka sesngeni e sinseng lo tifri ini Taufi are kep famila tinglo felun rerek. Ma ka war, “Peteng tife Jeims, ma seri a ri ka titinge,” ma kam la kosing ri ulo neng e male. ");
INSERT INTO hrw_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Lo biingbiing e mok sak fan soldia ri sik pane ine Pita, e mel e singmat na fagalo, ulo falifu lo re fan soldia, ri fafagatomnge iri tibom ini i ya. ");
INSERT INTO hrw_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Erot e ong ini Pita e tam ini, i gii kam uunre tongge ri ka sik ini. Sakle ri am tibi pari, iya ka taufre fan soldia ulo anganggon ma ka fauun ini fan soldia a, ri samusu met. Wimi Erot ka la tingna Judia kabi la melmel lo tanga biing ulo taon Sisaria. ");
INSERT INTO hrw_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Erot e balasak ire tongge tingna Tair ma Saidon, iya ri ka keptiim iri una la pari, anwarow ri kepe tuan tinglo kaontri Erot e efe lo. Ri fawar famu tura Blastus kaltu efefe lo male ke king, iya i kam a-uu lo ri. Wimi ri ka la pari e Erot ma ri ka la gatmo ini eu tengis ri, ku faropo e balasak kia tinglo ri. ");
INSERT INTO hrw_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Erot e tafu e neng e biing, lo biing a, i e tow e fam finaswen ke king ma ka la kiis ulo sia king kia, ma ka warwar singre tongge. ");
INSERT INTO hrw_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ma ri ka tautau aregii, “E ta angkiimkiim a neng e deo legii, e tibi ta ini angkiimkiim a ti kaltu.” ");
INSERT INTO hrw_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Saupesak, anwarow Erot e am tibi bura ini eu akteni e asow e Deo, neng e anggelo ke Taufi ka poseufu, ma fang kirkiriaf ri ka bit lo ka met. ");
INSERT INTO hrw_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Sakle sunwar ke Deo e karkek lala ma ka omseni e male. ");
INSERT INTO hrw_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Barnabas ma Sol ru sam la faropo e fam faim keru una Jerusalem ma ru ka la mil wina Antiok. Ru onu e Jon Mak ka mi nami ru. ");
INSERT INTO hrw_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Ilo sios ina Antiok e mel e fam profet ma fan titsa ri sesngeni e ninis Deo e bura tifre tongge. Asasri gii, Barnabas, Simion ri fotngi ming ini Mikiit, Lusias tingna Sairini, Sol ma Manaen (se ru gawana Erot, ru ta tikii finangte). ");
INSERT INTO hrw_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Lo neng e biing, lo bala fam biing ri nining lo Taufi ma ri ka feleni e tuan, Tangwa Riis e peteng tifri aregii, “Gam samusu tafu e Barnabas ma Sol, ku ta iru kuriik una gow e faim ya sam siik ru una musngeni.” ");
INSERT INTO hrw_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Wimi ini ri sau feleni e tuan, ma ri kabuk nining ma ri kabuk tafu e limlimri ulo ru, ri tule ru ka la. ");
INSERT INTO hrw_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Tangwa Riis e tule ru ka la una Selusia, ma ru ka la kiis lo sip tingwa, ru ka la ulo bit ina Saiprus. ");
INSERT INTO hrw_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Biing ru la puek una Salamis, ru sesngeni e sunwar ke Deo ulo bala fam felun nining kere fan Juda. Jon Mak e la ming tura ru, una la ules ru. ");
INSERT INTO hrw_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Kala ri tuul ka fes tingna Salamis, ri tuul ka la fespuek ulo taon Pafos. Uwa ri la tongeni e neng e kaltu na bilbilse ma una gowgow e fan sinang saksak, asow gii Bar-Yesus. I e ta profet gurgurum tingna Juda. ");
INSERT INTO hrw_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ming, i e ta fenngow e gawana, Sergius Paulus, se e ta kaltu parfat. Gawana e tau ine Barnabas ma Sol ru ka sa la unaisa, anwarow i e bura ini eu ong lo sunwar ke Deo. ");
INSERT INTO hrw_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Sakle kaltu na bilbilse a, (asow tingna Grik gii, Elimas. Pimpiku e Elimas gii, Kaltu na bilbilse) e bala bero ine faim ke Barnabas ma Sol, iya ka tofo una iksi e sinangu e gawana kosngi e titinge tikin. ");
INSERT INTO hrw_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Kala Sol, neng e asow ming gii Pol, bala e fuunuf ine Tangwa Riis, ka par riis use Elimas, ma ka war, ");
INSERT INTO hrw_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“O na sikow e kaltu saksak ma o isa e mara sinang e riis. O fuunuf ine fan mara matmatan sinang saksak una gurgurum ma o ka toftofo una ikiksi e fan sinang e riis ke Taufi, ku la ta anggurum. ");
INSERT INTO hrw_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Gii, limow e Taufi eu paket o. Wanmatam eu kut ma o ku melmel lo borom pansumbiing e tapak balik. O amu tibi fasi una pari e anten lo pisii.” Ma saupesak ka or e wanmata e Elimas ma ka lifit faliu una sik ine tikas una puse lo limow ma ku famu ini. ");
INSERT INTO hrw_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Biing gawana e pari e mok gii e fuut, i e titinge, le i e la kuufsak use fam fabenge lo Taufi. ");
INSERT INTO hrw_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pol ma un taltalu ri fes tiim tura, ri ka la kosnge taon Pafos, ma ri tuul ka la kiis lo sip ri ka la puek una Perga, e ta taon tinglo kaontri Pamfilia. Ma Jon Mak ka la mil kosing ru wina Jerusalem. ");
INSERT INTO hrw_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Ru ka matet tinglo taon Perga, ru ka fes ru ka la puek ulo taon Antiok, ilo kaontri Pisidia. Ma lo Biing Sabat, ru kaulek ru ka la kiis ulo bala felun nining kere fan Juda. ");
INSERT INTO hrw_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Wimi ini ri wese e fafanau ke Moses ma fan warwar kere fam profet, fan efefe lo felun nining, ri tow e sunwar tifri aregii, “Tanga tualikmem, le tikas lo gam ku mel e ti sunwar una farawasnge re tongge gii, e kausi ini eu ti ma ku war.” ");
INSERT INTO hrw_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Pol e ti ka sangau ine limow ma ka war aregii, “Tongge tingna Israel ma gam na fan Jentael seri lo gam a, ri ka nining ming lo Deo, gam u ong sing yau. ");
INSERT INTO hrw_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Deo kere tongge tingna Israel e sam wele e tumtumlarer. Ma ka fafuutngeri, ri ka la fuunfuun tibom lo biing ri melmel una Ijip. Wimi i kam un suu mil iri tingna Ijip ine singmat na rawas kia tibom. ");
INSERT INTO hrw_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ulo male mas i e tibi balasak saupe singe fan tubiil keri lo e fet e sangful na matamfaim. ");
INSERT INTO hrw_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Una Kenan, Deo e bero ine baba fis na funmat ma ka tow e nal a tifre tongge kia tibom, usi ini eu ta nal keri. ");
INSERT INTO hrw_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Fan mok nano gii e ngo areini e kepe e fet e atis ma e lim e sangful na matamfaim. “Wimi ine fan Israel ri sam kepe nal, Deo e taufre fan efefe keri ka muut lo biing ke profet Samuel. ");
INSERT INTO hrw_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Ma biing ri gatom use ti king, Deo e tafu e Sol sikow e Kis, tinglo matambia a Benjamin, ka efe lo ri, lo e fet e sangful na matamfaim. ");
INSERT INTO hrw_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Wimi Deo e kepufu e Sol ma ka tafu e Dewit ka ta king keri, ma ka sesuupuek ten ini tifri, ‘Ya sau pari e Dewit sikow e Jesi ma balang e bura tikin, i eu usi e fan mara fabur kiang.’ ");
INSERT INTO hrw_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Ma tinglo funmat a kaltu gii, Deo e sam tafu e anwaramfaliunge kiar, Yesus una Israel, aregii kabuk limlim ini. ");
INSERT INTO hrw_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Famu ine fespuek ke Yesus, Jon e sesngeni e sunwar tifre tongge nano ina Israel, ini riu iksi e balbalri, ma ri ku kepe e amfagu tarawen. ");
INSERT INTO hrw_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Biing Jon e sam rong una ropo e fam faim kia, i e gatom ri aregii, ‘Gam sang ini yau se? E tibi ta ini ya na kaltu lewa gam ka nene i, e tam, safle i e mu puek wimi i yau. Yau, ya tibi kausi ku fasi una pikufu e amfinau lo su kia.’ ");
INSERT INTO hrw_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Tanga tuaklik tingna Israel, fumberat ke Abra-am, ma gam na fan Jentael a gam ka nining lo Deo. Gam ong, sunwar ke Deo una faliungere tongge, i e sam tuleni usi kiar. ");
INSERT INTO hrw_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Tongge tingna Jerusalem tiim tura tongge lamlam lo ri, ri tibi ilmi e kaltu gii, Yesus, safle biing ri berbero ini, ri fawetu e fan warwar kere fam profet iya ri ka weswese lo fan mara Biing Sabat. ");
INSERT INTO hrw_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","E tikin, ri tibi sikseni e ti tubiil kia ek fasi una ti tura ilo anganggon, safle ri ting rawas tibom singe Pailat ini i e samusu met. ");
INSERT INTO hrw_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ma wimi ine fan mara mok nano gii sunwar ke Deo ka warwar lo, lo i ri sau musngeni, ri kepufu tinglo aupaket ma ri ka la fangongeufu ulo balang kenit. ");
INSERT INTO hrw_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Sakle Deo e sau famtet famila kosnge minet. ");
INSERT INTO hrw_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Ma lo fam biing fuunfuun, i e fespuek talo re tongge gii, ri ka usi lala tingna Galili wina Jerusalem. Tongge a ri ka pari ma ri ka sesngeni e sinseng lo tifre tongge kiar. ");
INSERT INTO hrw_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Ma kemeu puek gii una sesngeni e konona sunwar tif gam: Sa Deo e sam limlim ini tifre tuptuprer, ");
INSERT INTO hrw_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","i e sau fabonti tif kiar na berberat keri, lo matmatet mil ke Yesus. Aregii ri kabuk siitufu ilo bala buk baba e u ke Sams. ‘O na Sikuang geinggii Ya sau puek ka ta ya na Tamam.’ ");
INSERT INTO hrw_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Ma i gii e sa Deo e sau peteng ini, lo matmatet mil ke Yesus kosnge minet ma ini eu tibi ngo sok ku mapu ilo balang kenit: ‘Fan warfakausi, e tarawen ma e tikin sekit, yau tow tif gam aregii ya kabuk limlim ini tife king Dewit.’ ");
INSERT INTO hrw_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","E mel e neng e sunwar ilo bala buk ke Deo ming e peteng aregii, ‘Ou tibi tafu e Kaltu Tarawen kiam, ku mapu ilo balang kenit.’ ");
INSERT INTO hrw_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Le anwarow, biing Dewit e melmel ulo nal, i e usi e fam fabur ke Deo lo fam biing kia tibom, wimi i ka met ri ka ofo unais re tanga tumtumlow, ma pinumfow ka mapu. ");
INSERT INTO hrw_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Safle kaltu Deo e famtet famila tinglo minet, pinumfow e tibi mapu. ");
INSERT INTO hrw_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Aregii tanga tuaklik, ya bura ini gam samusu parfat ini, tikin lo Yesus, igii kemem ka sesngeni e sinseng lo sinang na sangintafngi e fan tubiil tif gam. ");
INSERT INTO hrw_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Lo fafanau ke Moses, e tibi fasi una kepufu e fan tubiil kemi, ma ku foteng gam ini gam na tongge riis. ");
INSERT INTO hrw_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Ate kausi ini sa fam profet ri sau peteng ini, eu tibi fuut lo gam: ");
INSERT INTO hrw_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Ong, gam na tongge na fafatas, gam u kuufsak ma gam ku met, anwarow le Ya ku gow e ti mok e piik falifu i gam, gam u tibi titinge lo, antalu le tikas ku seseng tif gam ini.’” ");
INSERT INTO hrw_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Biing Pol ma Barnabas ru rong una la kosnge felun nining, tongge ri ka la peteng tifru ini ri bura ini ruw sa warwar mil singri lo fan mok gii, lo neng e ti Sabat ming wimi. ");
INSERT INTO hrw_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Biing tongge nano ri sam la tinglo bala felun nining, fa fuunfuun lo re fan Juda ma fan Jentael gii ri ka kaulek ilo bala lotu kere fan Juda, ri mi nami e Pol ma Barnabas. Ma ru ka tow e sunwar tifri una farawasngeni e sinsinangu ri, usi ini riu usi e fabur ma fatengis ke Deo. ");
INSERT INTO hrw_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Lo neng wimi neng e Sabat, fatat ma ku ta tongge nano tinglo taon ri tiim lo ri una ongni e sunwar ke Taufi. ");
INSERT INTO hrw_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Biing fan Juda ri pari e tongge fuunfuun tikin, balbalri e fuunuf ine sinang na mer, ma ri ka war faiu ine sunwar ke Pol ma ri ka fotpursi. ");
INSERT INTO hrw_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Kala Pol ma Barnabas ru ka war na matri aregii, “E riis ini kamau sesngeni famu e sunwar ke Deo tif gam, sakle biing gam guuluung ini, ma gam ka tibi parfailiim gam ini gam riis una kepe e ninliu bingne, gii kama mu tibi sesngeni e sunwar tif gam, kamau sesngeni e sunwar tifre fan Jentael. ");
INSERT INTO hrw_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Anwarow Taufi e sam tungen kemem aregii, ‘Yau feti o are anten una tow e anten tifre fan Jentael, ma o ku faliungeri ku la muut lo rorop lo nal.’” ");
INSERT INTO hrw_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Biing fan Jentael ri ongni e sunwar a, ri terterer ma ri ka resngeni e sunwar ke Taufi. Ma seri gii Taufi kabuk wel ri una kepe ninliu bingne, lo biing a, ri titinge. ");
INSERT INTO hrw_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ma sunwar ke Taufi ka omseni e rijen kiruur. ");
INSERT INTO hrw_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Safle fan Juda ri famtete e balre gelefin gii ri ka mel e as bakir, ma ri ka usi e ninis lo nining ke Deo. Ri famtete e balre tongge lamlam tinglo siti ming, ma ri ka tofnge una bero ine Pol ma Barnabas, ma ri ka fesel suu iru tinglo rijen a. ");
INSERT INTO hrw_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Ma ru ka paketufu e ambalbal tinglo kekekru, are tintof una fanangsi ini e tek ti tubiil keru. Ma ru ka la kosnge taon ina Antiok, ru ka la ulo taon ina Aikonium. ");
INSERT INTO hrw_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ma Tangwa Riis ka fafonsi re tongge nano na titinge ulo taon ina Antiok ma ri ka fefeal. ");
INSERT INTO hrw_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Una Aikonium Pol ma Barnabas ru gow e tikii sinang aregii ru ka gow ulo bala felun nining kere fan Juda. Uwa ru gon kausi tikin ine sunwar, iya singmat na galung kaltu tingna Juda ma fan Jentael ri ka titinge. ");
INSERT INTO hrw_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Safle fa lo re fan Juda gii ri ka tibi bur titinge. Ri famtete e balbalre fan Jentael, ka gow ri ka balasak ire tongge ilo bala titinge. ");
INSERT INTO hrw_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Iya Pol ma Barnabas ru kabi melmel tapak wa. Ru tibi soke una sesngeni e sunwar lo fatengis ke Taufi. I e farawasngeni e sunwar kia na ngusru ine fan mok na tibou fuut ma fan mok na sangfuunfuun. ");
INSERT INTO hrw_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Tongge tinglo siti ri ka tapot ka u lo ri. Fa ri ka usi re fan Juda ma fa ri ka usi re fan apostel. ");
INSERT INTO hrw_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Wimi fan Juda ma fan Jentael tiim tura ge lamlam keri, ri fagati e neng e sangsang una bero ine Pol ma Barnabas ma ri ku rang ru ine fatfat. ");
INSERT INTO hrw_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Safle Pol ma Barnabas ru ong lo mok a, ru ka fin ru ka la ulo fan taon ilo distrik ina Laikonia, ulo taon ina Listra ma una Debe, ma ulo fan male liflifti e un taon gii. ");
INSERT INTO hrw_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Ma uwa ru sesngeni e Konona Sunwar. ");
INSERT INTO hrw_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Una Listra e mel e kaltu e kiiskiis, ungkekow e dol tinglo biing i e fuut ka tibi fasi balik una fes. ");
INSERT INTO hrw_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Kaltu dol a e ongne singe Pol lo sum biing i e gongon. Pol ka par riis usi, ka pari ini e mel e titinge kia e fasi una faliungeni, ");
INSERT INTO hrw_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","ma ka tau singe kaltu dol a aregii, “Matet, o ku ti ine ungkekem!” Lo sum biing a, kaltu a e of ka la ti ma ka tofnge una fes. ");
INSERT INTO hrw_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Biing galung kaltu a ri pari e sa Pol e sam gow, ri tautau lo kinen kere fan Laikonia aregii, “Fan deo ri sau fespuek are fang kaltu ma ri ka pu talo kiar!” ");
INSERT INTO hrw_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ri ka fotngi e Barnabas ini deo Sius ma Pol ini deo Ermes, anwarow i e ta kaltu una famfamu ine fang gongon. ");
INSERT INTO hrw_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Felun nining ke Sius e su ti fatatu e matangkon lo balo e lifti e taon. Pris tinglo felun nining a, ka kepe e fan tamtamatum buuluumakau ma fam bangbang ka la tura ulo matangkon lo siti, anwarow i tiim tura re tongge a, ri bura ini riu fafen ine fam finafen tifru. ");
INSERT INTO hrw_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Biing un apostel ru ong lo fan sangsang keri, ru rangsi e fang kolos keru ma ru ka filau ru ka la ulo falifu lo re tongge ma ru ka tautau lala aregii, ");
INSERT INTO hrw_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Tongge wuui! Anwarow lo sa gii gam ka gow e sinang gii? Kama ming kama su ta ung kaltu are gam. Kama sa tow e Konona Sunwar tif gam, usi gam u tii kosnge fan mok fofoes gii gam ka nining lo, ma gam ku mil use Deo, se e melmel bingne, ma e lamlames makrau ine balambat ma nal, balang kasap, ma fan mara mok nano ilo ri. ");
INSERT INTO hrw_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Lo biing kere fan tuptuprer, i e toufre tongge nano ri ka usi e fam fabur keri tibom. ");
INSERT INTO hrw_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Lo fam biing a, i e tibi keskum ini tongge ri ku tibi parfat lo. Bingne i e gowgow e konona fan sinang lo gam. I e gow e bat ka luut talo gam ting aulo bat aiyat. Fan ume ri fira lo bengu ri, ma ka fen gam ine fan tuan fuunfuun ma i ka fafonsi e balbalmi ine gasgas.” ");
INSERT INTO hrw_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Ru gow e fan warwar, sakle e tuntun sak singru una faropo e sangsang keri una tibi gow e fam finafen tifru. ");
INSERT INTO hrw_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Wimi fa lo re fan Juda ri la tingna Antiok ina Pisidia ma Aikonium ri sa gau re tongge ri ka balasak ine Pol. Ri ka rangu ine fatfat ma ri ka tatfe suu ini tinglo siti. Ri sangfi ini e sau met. ");
INSERT INTO hrw_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Safle biing fan disaipel ri sam la fafatie liflifti, Pol ka matet ka la mil ulo siti. Lo biing usi Pol ma Barnabas ru ka matet ru ka la una Debe. ");
INSERT INTO hrw_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Ru sesngeni e Konona Sunwar tifre tongge ulo siti a ma ru ka gow e singmat na galung kaltu ri ka ta fan disaipel. Wimi ru ka matet ru ka la mil una Listra, Aikonium ma Antiok ina Pisidia, ");
INSERT INTO hrw_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","ru ka faraungeni lala e balbalre fan disaipel fuunfuun ma ru ka war faraungeri ini riu melmel tikin ilo bala titinge. Ma ru ka war singri aregii, “Kiar samusu kepe e fan mafet fuunfuun, una kaulek ilo bala kepmale ke Deo.” ");
INSERT INTO hrw_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Pol ma Barnabas ru feti re tongge na famu ilo tikii neng, tikii neng e sios. Ma ru ka feleni e en ma ru ka gow e fan nining ma ru ka fafen iri tife Taufi, seri sam towfu e titinge keri ilo. ");
INSERT INTO hrw_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Wimi ini Barnabas ma Pol ru sau fespakti e distrik Pisidia, ru ka la fespuek ulo distrik Pamfilia. ");
INSERT INTO hrw_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Ma biing ru sam sesngeni e sunwar ke Deo ulo taon Perga, ru la ding mil ulo taon Atalia. ");
INSERT INTO hrw_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Tingna Atalia ru ka la kau ulo sip, ru ka la mil una Antiok. Ulo taon a, tongge na titinge ri sam ta ru ulo limow e Deo, usi ini i eu warfakausi ru, ru ku fasi una gow e faim, gii ru kabuk fawetu. ");
INSERT INTO hrw_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Biing ru la fespuek uwa ru ka la tau tiim ire tongge tinglo sios, ma ru ka peteng tifri ine fan mara mok Deo e gow ulo limlimru, ma ini are e ipki e matangkon na titinge tifre fan Jentael. ");
INSERT INTO hrw_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Ma ru kabi melmel tapak uwa, tura fan disaipel. ");
INSERT INTO hrw_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Fa lo re tongge ri ding tingna Judia, una la wina Antiok una la fabenge singe fan tualik ri ilo bala titinge aregii, “le gam ku tibi talsi e pinpinumfomi ususi e ninis ke Moses gii ri kabuk fabenge sing gam lo, Deo eu tibi faliunge gam.” ");
INSERT INTO hrw_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pol ma Barnabas ru ka ongni e fan warwar a, ru ka matet ru ka fatinge tuntun tura ri. Iya ri ka a-uu lo Pol ma Barnabas tiim tura fa lo re tongge na titinge ini riu la wina Jerusalem, una la pari e fan apostel ma tongge na famu ine sios tura sangsang gii. ");
INSERT INTO hrw_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Sios ka tule ri ka la, biing ri fespakti lala e distrik Fonisia ma Samaria ri ka peteng fate ri ini Deo, e sam gau re fan Jentael, ri kabuk iksi e balbalri. Sinang gii e gau re tongge na titinge ri ka fefeal tikin. ");
INSERT INTO hrw_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Biing ri la fespuek una Jerusalem, tongge tinglo sios ma fan apostel ma tongge na famfamu ine sios ri ka are ri. Ma ru ka sesngeni e mara mok Deo e sam gow na limru. ");
INSERT INTO hrw_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Safle fa lo re tongge na titinge seri ta lo re fan Farasi ri matet ma ri ka war, “Fan Jentael ri samusu talsi e pinpinumfori ma ri samusu usi e fafanau ke Moses.” ");
INSERT INTO hrw_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Fan apostel ma tongge na famfamu ine sios, ri sa tiim una fariisu e sunwar gii. ");
INSERT INTO hrw_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Wimi ini ri sam gow e fan warwar fuunfuun, Pita ka matet ka peteng tifri aregii, “Tanga tuaklik, gam sau parfat ini nangen Deo e sam siik yau ting auna balmi una tow e Konona Sunwar tifre fan Jentael usi ini ri ku ongni ma ri ku titinge. ");
INSERT INTO hrw_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Deo, se e parfat lo balbalre tongge nano, e tow e Tangwa Riis tifri, e buk su ngo aregii, i ka gow lo kiar. Sangsang gii e fanangsi ini Deo e bur ri. ");
INSERT INTO hrw_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","E tibi gow e ti mok falifu iri ma kiar ku ngo kuriik, lo titinge keri, i e fakalkaliisnge ri. ");
INSERT INTO hrw_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Ma gii, usi e tamu gam ka tofo una fatof tura Deo, gam ka tow e anau mafet ilo poktow e fan disaipel, le nangen tuptuprer ma kiar ming gii, kiar tibi fasi una kepe mafet a. ");
INSERT INTO hrw_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","E tam! Kiar titinge ini tikin lo warfakausi ke Taufi Yesus kiar, Deo e kepfamil kiar, aregii, i eu kepfamil ri ming.” ");
INSERT INTO hrw_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Pita ka war aiya, ma tongge nano ulo tiim a, ka la tek borong sok lo ri. Ma ri ka ongne singe Barnabas ma Pol ma ru ka seseng tifri ini e fan tintof ma fan mok na tibou fuut Deo e sam gow lo re fan Jentael lo limlimru. ");
INSERT INTO hrw_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Biing ru sam gongon tikii, Jeims ka war singri aregii, “Tanga tuaklik, ong wagii sing yau. ");
INSERT INTO hrw_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Saimon e sau peteng, aregii, Deo kau fatikii fanangsi e sinang na fabur kia tifre fan Jentael, iya i kam kepfamil re fa lo ri, ri ka ta kia tibom. ");
INSERT INTO hrw_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Ma sunwar kere fam profet ming e a-uu lo ma ri seti aregii, ");
INSERT INTO hrw_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Taufi e peteng aregii, kepmale ke Dewit e su ngo are fel, e sam luut, sakle wimi ya mu mil ya ku sa terngeni, ma ya ku feti famila, ");
INSERT INTO hrw_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","usi le fa, fan tongge kuriik ming riu siksik i yau, ma fan Jentael nano ya sam wel ri, ini riu ta kiang tibom. ");
INSERT INTO hrw_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","I gii e sunwar ke Taufi, nangen sak i e sau peteng ini.’ ");
INSERT INTO hrw_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Aregii, lo sangsang kiang, kiar u tibi tow e ti mafet una kale re fan Jentael gii ri ka sangikis ma ri ka didiu mil usi e Deo. ");
INSERT INTO hrw_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","E fasi ini kiar u seti e ti pas tifri, una peteng tifri aregii, riu tibi eni e ti ton tuan e tibi kalkaliis, le ri sau fafen ini tifre fan deo gurgurum, riu tibi gow e fan sinang na faet falek, riu tibi eni e ti ton talaman ri pulmi ma riu tibi eni e fang gemgem e mel e andadak ilo. ");
INSERT INTO hrw_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Anwarow kiar sau parfat ini ting famu tikin ka sa muut gii, ri sesesngeni e fam fafanau ke Moses ulo mara siti ma ri ka weswese ulo bala fam felun nining lo fam biing na Sabat nano.” ");
INSERT INTO hrw_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Wimi fan apostel ma tongge na famfamu ine sios ma sios nano ri sangsang una wele e ti tong kaltu keri una tule ri wina Antiok tiim tura Barnabas ma Pol. Ri wele e Judas (asow ming gii Barsabas) ma Sailas, le ru ta ung kaltu una famfamu na balre tongge na titinge. ");
INSERT INTO hrw_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ri ka tuleri tura pas, ri siisiit ulo aregii: ");
INSERT INTO hrw_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Kemem sam ong aregii, ini fa lo kemem tibom, ri la fespuek talo gam ri ka bero ine sinsinangumi ma balbalmi ka matmatet singe fan warwar keri. Safle tongge a, ri tibi kepe war a-uu sing kemem. ");
INSERT INTO hrw_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Iya kemem ka tiim lo tikii sangsang una wele e ti tong kaltu una tuleri usi gam, tiim tura konona um fenngorer, Barnabas ma Pol, ");
INSERT INTO hrw_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","se, ru sau fafen ine fan ninliu keru, una sesngeni e asow e Yesus Kristus Taufi kiar. ");
INSERT INTO hrw_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Aregii, kemem ka uunre ung kaltu gii, Judas ma Sailas una la sesngeni e sunwar kemem sam seti ilo bala pas gii ine ngusngusru. ");
INSERT INTO hrw_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Tangwa Riis ma kemem, kemem sam a-uu aregii, ini kemem u tibi tow e ti ton mafet ming ilo gam ilo poktow e fan sangsang gii una usi: ");
INSERT INTO hrw_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Gam u tibi eni e ti tuan gii ri kabuk fafen ini tifre fan deo gurgurum ma gam u tibi eni e fang gemgem e mel e dadak ilo ma ti ton talaman ri pulmi, gam u tii kosnge fan sinang na faet falek. Eu kausi tibom le gam ku efe kausi lo gam una ifit ine fan ninis a. Siaro ma par gam. ");
INSERT INTO hrw_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Sios ka tule re tongge gii, ri ka la ding una Antiok, uwa ri ka la keptiim ire tongge tinglo sios ma ri ka tow e pas a tifri. ");
INSERT INTO hrw_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Biing ri wese e pas a, ri fefeal tikin una kepe e konona sunwar, una farawasnge ri. ");
INSERT INTO hrw_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judas ma Sailas, se ru tibom ru ta um profet, ru war ine fan warwar fuunfuun una farawasnge ri ma una tow e rawas tifre tongge na titinge a. ");
INSERT INTO hrw_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Wimi ini ru sau melmel tapak uwa, fan tualik ru ri ka tule famil ru una la mil use re tongge lewa ri ka tule ru, tura warfakausi ma balamaris. ");
INSERT INTO hrw_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Safle Pol ma Barnabas ru mel sok una Antiok. Uwa, ru faim tiim tura fa fuunfuun lo re tongge na titinge, ri ka fabenge ma ri ka sesngeni e sunwar ke Taufi. ");
INSERT INTO hrw_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Lo fanenger fam biing wimi, Pol e war aregii singe Barnabas, “Karak la mil, kara ku la fu lo re fan tualikrer ilo fan taon le, kara kabuk sesngeni e sunwar ke Taufi ulo. Ma kara ku la par ini ri su melmel kausi, tam e tam.” ");
INSERT INTO hrw_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnabas e bura ini eu onu e Jon Mak, ku mi nami ru, ");
INSERT INTO hrw_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","safle Pol e sang aregii, ini e tibi riis ini ruw onu e Jon Mak ku mi nami ru, anwarow famu, i e la didiu mil kosing ru ulo prowins ina Pamfilia ma ka guuluung una la nami ru una faropo e fam faim keri. ");
INSERT INTO hrw_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Ru sam la fatinge na balasak tikin, gii ru ka fes fapot. Barnabas ka onu e Mak ru ka tuut ru ka la una Saiprus, ");
INSERT INTO hrw_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","safle Pol e wele e Sailas ini ru, ruw la. Biing ru la, tongge na titinge ri peteng tifru aregii, “Warfakausi ke Taufi e ta tura kamu.” ");
INSERT INTO hrw_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Pol e la fes fawet una Siria ma una Silisia, ka la farawasnge ri lala e fan sios ulo fan male a. ");
INSERT INTO hrw_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pol e la puek famu una Debe ma wimi kam la una Listra. Ulo male a, neng e disaipel ri fotngi ini Timoti, e melmel ulo. Tinow e ta neng lo re fan Juda ma e ta wok e titinge, sakle tamow e ta neng lo re fan Grik. ");
INSERT INTO hrw_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Tongge na titinge nano ina Listra ma ina Aikonium ri tiin peteng ini, i e ta konona kaltu. ");
INSERT INTO hrw_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pol e bura ini eu onu tura lo fines kia, gii i ka talsi e pinumfow, anwarow lo fan Juda ri melmel ulo male a, le ri tiin parfat ini tamow, e ta neng lo re fang Grik. ");
INSERT INTO hrw_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Biing ri fes lala ulo bala fan taon, ri peteng lala tifre tongge na titinge ine sangsang fan apostel ma tongge na famfamu ine sios una Jerusalem ri sau fagati, ma ri ka peteng tifri una usi e sangsang gii. ");
INSERT INTO hrw_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Biing a fan sios ri puek rawas ilo bala titinge ma lo bala tikii neng, tikii neng e biing, wewes lo ri e faf kanek. ");
INSERT INTO hrw_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Pol tura fan taltalu ri fespaket sekit ulo bala rijen ina Frigia ma ina Galeisia, anwarow Tangwa Riis e tibi taufri, una sesngeni e sunwar ulo prowins ina Eisia. ");
INSERT INTO hrw_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Biing ri la puek ulo makpaek lo male ina Misia, ri tofo una kaulek una Bitiniya, sakle Tangow e Yesus e tibi awuu lo ri. ");
INSERT INTO hrw_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Iya ri ka su sol sekit una Misia, ri ka la pu ulo taon ina Toroas. ");
INSERT INTO hrw_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Lo panambiing a, ulo mok e ngo are numbiil, Pol e pari e neng e kaltu tingna Masedonia e titi ka guguna, aregii, “Kasa wagii wina Masedonia, o ku sa ules kemem.” ");
INSERT INTO hrw_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Wimi ine parpar ke Pol, kemem sam su terer saupesak una la wina Masedonia, le kemeu parfat ini Deo e sam tau i kemem una la sesngeni e Konona Sunwar tifre tongge uwa. ");
INSERT INTO hrw_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Tingna Toroas, kemem ka kepe e sip kemem ka tuut riis sekit wina Samotreis ma lo biing wimi kem ka tuut wina Neapolis. ");
INSERT INTO hrw_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Tingwa kemem ka fes wina Filipai, male ilo pikliu e gapman tingna Rom ma e ta siti bakir iyat ine fan mara siti nano ilo distrik ina Masedonia. Kemem ka la melmel wa lo e sam ta tanga biing. ");
INSERT INTO hrw_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Lo Biing Sabat, kemem suu una male ine siti, kemem ka la ulo dan, ulo galu kemem sangfi ini eu ta tafu re fan Juda una nining. Uwa kemem ka la tonge re gelefin ri sam tiim lo ri, kemem ka la kiisuf, kemem ka gongon sing ri. ");
INSERT INTO hrw_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Neng lo re gelefin a ri ka ongongne sing kemem, asow gii Lidia, i e ta wok na umumat ine fang kolos kaukaor ma i e ta tinglo siti ina Taiyataira, i e ta wok e sagisu nining lo Deo. Taufi e ipki e ambusbusow una ongni ma una usi e fan warwar ke Pol. ");
INSERT INTO hrw_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Biing i tura tongge tinglo ke fel ri kepe e amfagu tarawen, i e tau i kemem wilo ke fel, “Le gam kabuk parfailiim yau ini ya na wok titinge tikin lo Taufi, gam kasa gam ku sa melmel ilo kek fel.” Ma i ka farawasngeni e sinsinangumem una mi nami. ");
INSERT INTO hrw_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Lo neng e biing, kemeu fes una la ulo male na nining, ma kemem ka la tongeni e neng e polsom na mus e mel e tangwaner saksak ulo, ka gow ka fasi una peteng suupuek ine sa e amu puek. Tongge lamlam kia ri kepkepe e singmat na fang galgalun mani singi, lo sinang una petpeteng suupuek ine fan sa e amu puek. ");
INSERT INTO hrw_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Fefin a, e usi e Pol tiim tura kemem ma ka tautau lala, “Tongge gii ri ta tongge na mus ke Deo Iyat Sekit! Riu petpeteng tif gam ine sal una kepe ninliu bingne.” ");
INSERT INTO hrw_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Fam biing fuunfuun i e gau kemem aiya. Ma lo neng e biing, Pol e la fomain singe fefin a, iya kam tibi fasi una mu bibing patpat, i ka didiu mil ma ka war singe tangwaner aulo, “Lo asow e Yesus Kristus, ya tungen o una suu tinglo fefin a!” Lo sum biing sekit a, tangwaner a e suu kosnge fefin a. ");
INSERT INTO hrw_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Biing tongge lamlam ke fefin na mus a ri parfat ini e sam tek ti sal keri una kepkep mani, ri ka bingfamti e Pol ma Sailas ri ka tatfe ru ka la ulo male na tiim una la ti na matre ge lamlam. ");
INSERT INTO hrw_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Ri uun ru, ru ka la ti u famu ire fan medistret ma ri ka war, “Un er gii, ru ta un sikin Juda ma ru ka bala famtete e fagorot ilo bala siti kiar. ");
INSERT INTO hrw_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Ri fabenge ine fan ninis e tibi riis ususi e fafanau kiar. Kiar ta tongge tuman tingna Rom ma kiar tibi fasi una a-uu lo fan ninis gii, tam una usi.” ");
INSERT INTO hrw_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Tongge nano ri faules ine fan warwar talo Pol ma Sailas. Wimi fan medistret ri ka fauun ri ka sipapaki e fang kolos keru ma ri ka wesbis lo ru. ");
INSERT INTO hrw_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Wimi ini ri sam wesbis saksak lo ru, ri la tura ru, ri ka la bas kaulek i ru ulo bala felun rerek ma ri ka war rawas singe efefe lo felun rerek una efe kausi lo ru. ");
INSERT INTO hrw_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Biing efefe e kepe e sunwar una efe kausi lo ru, i e la tauf ru ulo bala su una fel sekit ma ka kawefamti e kekek ru ulo falifu lo fan susun kalut lamlam. ");
INSERT INTO hrw_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Are lo panambiing bakir, Pol ma Sailas ru nining ma ru ka seke e fan seksek lo Deo ma fanenger fan tongge rerek ri ka ongongne lo ru. ");
INSERT INTO hrw_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Saupesak, singmat na anggi e puek ka doingeni kiruur e warow e felun rerek. Lo sumbiing a sekit, fan mara matmatangkon lo felun rerek ri tiin ipiik ma fan mara sen nano ulo re tongge rerek ri ka tiin pipik. ");
INSERT INTO hrw_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Efefe lo felun rerek ka kuuf ma biing e pari e fan mara matmatangkon e ipiik, i e iifufu e ke bainat ma ka bou bala taumet ini, anwarow e sangfi ini tongge rerek ri sau fin. ");
INSERT INTO hrw_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Safle Pol e matet ka tau bakir, “Mangena bou bero i yo! Kemem nano gii wa.” ");
INSERT INTO hrw_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Efefe e tau ini riu tow e anten tifi ma ka filau kau saupesak ka la luut ka la banban u famu ine Pol ma Sailas. ");
INSERT INTO hrw_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Wimi ka uun suu iru una male ma ka la gatom ru, “Ung kaltu bakir, ya samusu gow e sese mok una kepe e ninliu bingne?” ");
INSERT INTO hrw_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ru ka koso, “Ou titinge lo Taufi Yesus, ma Deo ku faliunge o, tiim tura tongge nano ilo keu fel.” ");
INSERT INTO hrw_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Wimi ru kam sesngeni e sunwar lo Taufi tifi ma tifre tongge nano ulo bala ke fel. ");
INSERT INTO hrw_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Lo panambiing a sekit, efefe a e uun ru, ka la gua e fam pi ulo ru. Ma ming, lo panambiing a sekit i tura ke fumberat ri kepe e amfagu tarawen. ");
INSERT INTO hrw_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Efefe kam uun kaulek iru ulo bala ke fel ma ka la fen ru ine fan tuan. I e fefeal tikin, anwarow i tiim tura ke fumberat nano ri sam tiin titinge lo Deo. ");
INSERT INTO hrw_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Lo biingbiing e mok usi, fan medistret ri tulere fam polis use efefe lo felun rerek tura sunwar gii, “Taufre tongge a, ri ku la.” ");
INSERT INTO hrw_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Efefe a, e peteng tife Pol aregii, “Fan Medistret ri sam tow e sunwar ka sa la ini kamu Sailas, yau pikuf kamu. Gii kamu sau fasi una la ma kamuw la tura balamaris.” ");
INSERT INTO hrw_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Ma Pol ka war singre fam polis a, “Kama ta un sikin Rom torngon, safle ri sau paket kama na matfuun, ri ka tibi anganggon famu sing kama, ma ri ka bas kaulek i kama ulo bala felun rerek. Ma gii, ri kau bala tule borong i kama? E tibi ngo aiya sekit! La uun ri, ri ku bom sa famu i kama ku suu.” ");
INSERT INTO hrw_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Fam polis a, ri la peteng tifre fan medistret ine sunwar a. Ma biing ri ong ini Pol ma Sailas ru ta ung kaltu torngon tingna Rom, ri la soke tikin. ");
INSERT INTO hrw_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Iya, ri ka la, ri ka la war famasbalru, ri ka la uun suu iru tinglo felun rerek ma ri ka gatom ru una suu tinglo siti. ");
INSERT INTO hrw_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Pol ma Sailas ru suu tinglo felun rerek, ru ka la sekit ulo fel ke Lidia. Uwa, ru la tongeni e tongge na titinge, ru kabi war farawasnge ri ma ru kam la. ");
INSERT INTO hrw_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Biing ri sam soliwi e male ina Amfipolis ma ina Apolonia, ri la puek una Teselonaika ma e mel e felun nining kere fan Juda uwa. ");
INSERT INTO hrw_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Ususi e sinangu gii ka sagisu gowgow bingne, Pol e la ulo bala felun nining. Ma lo bala e tuul e Biing Sabat, i e fagon tura re tongge ma ka weswese sunwar pepe ma ka fatfatenu tifri. ");
INSERT INTO hrw_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","I e fatenu e mara mok tifri ma ka peteng ine sunwar tikin lo Mesaiya, ini i e samusu kepe ongker ma ku matet mil kosnge minet. Ma ka peteng tifri, “Yesus gii ya ka gongon lo tif gam, e ta Mesaiya.” ");
INSERT INTO hrw_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Fa lo re tongge a ri la tikii balri tura Pol ma ri ka kaulek unais ru Sailas. Fa fuunfuun ming lo re gelefin lamlam tura singmat na galu lo re fang Grik a ri ka nining lo Deo, ri ming ri kaulek. ");
INSERT INTO hrw_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Safle fa lo re fan Juda ri songe, ri ka keptiim ire fa fan tongge saksak ulo bala male na umumat ma ri ka tofngeni e fagorot ulo bala siti. Ri la saupesak wilo fel ke Jeisen una la sik ine Pol ma Sailas, usi ini riu la uun suu i ru tifre tongge. ");
INSERT INTO hrw_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ma biing ri tibi la tonge ru, ri ka su tatfe suu ine Jeisen ma fa lo re tongge na titinge, ri ka la fetiuf ri u famu ire fan ofisa tinglo siti, ma ri ka tautau: “Tongge gii ri kabuk tofngeni e tubiil ilo mara male gii lo nal, gii ri sau puek gii. ");
INSERT INTO hrw_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Ma Jeisen e sam uun ri, ri ka melmel ulo ke fel. Iri nano ri sam kere e fafanau ke Sisa, ri ka peteng ini e mel e neng e king kuriik, asow gii Yesus.” ");
INSERT INTO hrw_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Biing ri ongni e sunwar kere tongge a, tongge nano ma ge lamlam tinglo siti ri fakaunge. ");
INSERT INTO hrw_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Kala ge lamlam a ri ka onu e Jeisen ma fan taltalu ri ka fifiil famu una kepuf ri tinglo tubiil a ma wimi ri kam uun ri, ri ka la. ");
INSERT INTO hrw_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","E su la panambiing, tongge na titinge, ri ka tuleni e Pol ma Sailas ru ka la una Beriya. Biing ru la puek uwa, ru la kaulek ulo bala felun nining kere fan Juda. ");
INSERT INTO hrw_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Tongge tingna Beriya, sinsinangu ri e ten iyat ire fa ina Teselonaika, le ri ongne use fan warwar ke Pol tura singmat na fabur ma fam biing nano ri wese e sunwar pepe una pari ini fan sa Pol e seseng ini e tikin. ");
INSERT INTO hrw_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Fa fuunfuun lo re fan Juda ri titinge tiim tura fa lo re gelefin ming tingna Grik e mel e asri ma fa fuunfuun lo re antamat tingna Grik ming. ");
INSERT INTO hrw_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Ma biing fan Juda ina Teselonaika ri ong ini Pol e sesesngeni e sunwar ke Deo una Beriya, ri sa la uwa ming, ri ka sa tofnge una bero ma famtete balbalre tongge. ");
INSERT INTO hrw_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Biing a sekit, tongge na titinge ri tuleni e Pol kala ulo galu una kiin, sakle Sailas ma Timoti ru mel sok una Beriya. ");
INSERT INTO hrw_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Antamat ri la tura Pol ri ka la towfu una Atens. Wimi ri kam la mil tura sunwar tife Sailas ma Timoti ini le are ku gorot ruw la saupe use Pol. ");
INSERT INTO hrw_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Biing Pol e nene i uwa e Sailas ma Timoti una Atens, i e ongen saksak bakir ine fow, anwarow e pari e fam poksenge fuunfuun ulo bala siti a. ");
INSERT INTO hrw_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Iya i ka la ulo bala felun nining ka la fagon tiim tura fan Juda ma fang Grik, gii ri ka titinge lo Deo. E gorot aiya ming ulo fan male na umumat lo fam biing nano tura seri a, i ka tonge ri ilo fan mok a. ");
INSERT INTO hrw_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Fa lo re fan tongge parfat tinglo galun Epikurien ma fan Stoik ri tofnge una fatinge tura Pol. Fa lo ri, ri ka gatom, “Sa le gii kaltu na tibi ongong ma laes karef gii e bala seseng ini?” Fa ri ka koso, “E ngo areini e seseng ine fan deo kuriik.” Ri war aiya, anwarow Pol e sesngeni e konona sunwar lo Yesus ma matmatet mil kia. ");
INSERT INTO hrw_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Wimi ri ka onu e Pol ka la ti u famu ire galung kaonsiil tinglo siti ri foteng ri ini fan Eriopegas ma ri ka la war, “Kemeu bur parfat ini fabenge fuu gii o ka fafabenge ini e ta sa. ");
INSERT INTO hrw_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","O kep puek ine fan sangsang e ngo kuriik sekit talo balbalumem, ma kemeu bur parfat ini sese bala.” ");
INSERT INTO hrw_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Tongge tuman tingna Atens ma fan ses a ri ka melmel ina Atens, ri bura ini riu su melmel, ri ku fafagon ma ri ku ongongne use fan sangsang fuu.) ");
INSERT INTO hrw_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Wimi Pol kam ti ulo bala tiim kere fan Eriopegas ma ka war, “Tongge tingna Atens, ya pari ini ilo mara sal, e ta gam na tongge na nining. ");
INSERT INTO hrw_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Anwarow, biing ya fes fawet ulo bala siti ya ka par lala ulo bala fan male na nining sing kemi, ya la tongeni e altar ri siisiit aregii ulo, ‘TIFE DEO KEMEM TIBI PARFAT LO.’ Iya, sa a gam ka nining lo ma e tikin ini gam tibi parfat lo, i gii yau, ya ka sesesngeni tif gam. ");
INSERT INTO hrw_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“Deo gii ka lamlames makrau ine nal ma mara mok nano ilo, i e ta Taufi lo balambat ma nal. Ma i e tibi melmel ilo fam Felun Nining Bakir tongge ri gow ine limlimri. ");
INSERT INTO hrw_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Ma i e tibi pospos use ti mok, gii ini tongge ri ku faim una ulsi ine limlimri, anwarow i tibom e tow e ninliu, minange ma mara mok nano tifre tongge. ");
INSERT INTO hrw_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Tinglo tikii kaltu i e gow e mara galgalun tongge, ini ri ku mel fawet ilo nal. Famu ine mara mok gii, i e sau fagati riis e biing ma male riis riu la mel ilo. ");
INSERT INTO hrw_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Deo e gow e mok gii usi ini tongge ri ku sa la usi, ma antalu le ri ku siksik ini, riu sikseni, safle Deo e tibi ta i tapak ine tikii neng, tikii neng lo kiar. ");
INSERT INTO hrw_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Ri sam seti aregii, ‘Le lo Taufi, kiar ka liuliu, kiar fasi una doi faliu ma kiar ka melmel.’ Aregii fa lo re tongge parfat kemi ri kabuk peteng ini, ‘Kerer ming, kiar ta fan siksikow.’ ");
INSERT INTO hrw_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“Are lea, le kabuk ta kiar na fan siksikow e Deo, kerer u tibi sangfi ini Deo e ngo are gol, silwa, tam fat, kaltu e poksenge lo parfat ma lo rawas kia. ");
INSERT INTO hrw_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Nangen Deo e tibi fakutun are tongge a, ri ka tibi parfat lo. Safle gii, i e tungen re tongge nano ilo an mara male una sangikis. ");
INSERT INTO hrw_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Anwarow i e sau fagatiufu e neng e biing una anganggon singre tongge nano gii lo nal ine sinang riis kia. I e sam siikii e neng e kaltu una efe lo biing a. I e sau fanangsi e sa e tikin lo mok gii tifre mara tongge, lo sinang i e sam gow. I e sau famtete mil e kaltu a tinglo minet.” ");
INSERT INTO hrw_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Biing ri ongni e Pol e war lo matmatet mil, fa lo ri, ri tumaru, sakle fa ri war aregii, “Kemeu bur ongne lo o ma o ku warwar mil lo mok a.” ");
INSERT INTO hrw_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Ma Pol ka matet kala kosngi e tiim a. ");
INSERT INTO hrw_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Fa ri titinge ma ri ka tiim tura. Ulo falifu lo ri e mel e neng e kaltu, asow gii Daionisius, i e ta neng lo re fan Eriopegas. Una balri, e mel e neng e fefin ming, asow gii Damaris ma fanenger fan tongge ming. ");
INSERT INTO hrw_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Wimi Pol e la tingna Atens ma ka la ulo taon ina Korin. ");
INSERT INTO hrw_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Uwa i e tongeni e neng e kaltu tingna Juda, asow gii Akwila. Anwaran male kia gii Pontus, ma i e am su puek tingna Itali tura ke wok Prisila, anwarow Klaodius se e ta kaltu bakir tingna Rom e sam tungen re fan Juda nano ini riu matet tingna Rom. Pol e la una la par ru, ");
INSERT INTO hrw_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","ma anwarow i e ta kaltu una gorgorot fam fel lo kandis are iru, i e melmel ka fafaim tura ru. ");
INSERT INTO hrw_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Lo fan mara Biing Sabat, Pol e lala ilo bala felun nining una la tofo una tatfe re fan Juda ma fang Grik una titinge lo Yesus. ");
INSERT INTO hrw_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Biing Sailas ma Timoti ru sa la tingna Masedonia ru ka ding una Korin, Pol e fafen kiruur ini una sesuupuek ini Yesus e ta Kristus tifre fan Juda. ");
INSERT INTO hrw_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Safle biing fan Juda ri fasange singe Pol ma ri ka fotpursi, i e salisufu e ambaukif tinglo ke kolos una fanangsi ri ma ka war aregii, “Dadakumi eu ta ilo pakpaklumi tibom! E tibi ta ini ilo paklung. Tofnge ting geinggii ma ku la, yau la ilo male kere fan Jentael.” ");
INSERT INTO hrw_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Kala Pol ka suu kosing ri tinglo bala felun nining, ka la ulo bala fel ke neng e Jentael asow gii Taitus Jastus. I e ta kaltu e nining lo Deo ma fel kia e ti ulo galu lo felun nining. ");
INSERT INTO hrw_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Krispus, kaltu bakir lo felun nining, tiim tura tongge nano ulo ke fel, ri titinge lo Taufi. Fa fuunfuun ming lo re tongge tingna Korin, seri ongne fan warwar ke Pol, ri titinge ma ri ka kepe e amfagu tarawen. ");
INSERT INTO hrw_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Lo neng e panambiing, Taufi e war aregii singe Pol, ulo mok e ngo are numbiil, “Mangena soke, su sesesngeni e sunwar. Mele tet borong lo o. ");
INSERT INTO hrw_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Le e ta yau inais o, ma eu tek tikas eu paket o ma eu bero i o anwarow e mel e tongge fuunfuun kiang ilo bala taon gii.” ");
INSERT INTO hrw_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Iya Pol ka melmel tura ri una Korin, lo tikii matamfaim tura su, ka fafabenge singri ine sunwar ke Deo. ");
INSERT INTO hrw_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Biing Galio e puek ka ta kaltu bakir lo Gapman ulo prowins Akaiya, fan Juda nano ri keptiim ri ma ri ka matet ri ka gow e fan warwar una bero ine Pol ma ri ka tafu ulo anganggon. ");
INSERT INTO hrw_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Ri ka war aregii, “Kaltu gii e sam tofo una tatfe re tongge una nining lo Deo lo neng e sal kuriik gii ka kere e fafanau ke Deo.” ");
INSERT INTO hrw_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Biing Pol e rong una war, Galio e war singre fan Juda aregii, “Le gam na fan Juda gam gi peteng ini kaltu gii e kere e tikas lo fam fafanau, tam enggi gow e ti tubiil bakir sak, ya fasi una ong sing gam. ");
INSERT INTO hrw_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Ma gii, e su ta fang gatgatom use fan warwar, fan as ma fam fafanau kemi tibom. Gam u bou fariisu e fan warwar gii ilo falifu i gam tibom. Ya tibi fasi una anganggon lo fan ninis aiya.” ");
INSERT INTO hrw_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Ma i ka uun suu ri tinglo anganggon. ");
INSERT INTO hrw_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Wimi tongge nano ri ka bingfamti e Sostenes, kaltu bakir lo felun nining kere fan Juda. Ma ri ka pakti fatatu e male ri anganggon ulo. Safle Galio e tibi sangsang sekit use mok a ri ka gow. ");
INSERT INTO hrw_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pol e melmel lo fanenger fam biing una Korin, ma wimi i kam la kosing re tanga tualik ilo bala titinge, ka tuut lo sip ka la una Siria tiim tura Prisila ma Akwila. Famu ma kamu tuut, i e keti e ololow ulo taon Senkria, anwarow lo limlim i e sam war ini. ");
INSERT INTO hrw_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Ri la fespuek una Efeses, uwa Pol ka la kosnge Akwila ma Prisila, i tibom ka bom la kaulek ulo bala felun nining kere fan Juda, ka la fawar tura ri. ");
INSERT INTO hrw_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Wimi ri gatmo ini i eu bi melmel lo ti tom biing tura ri, i ka peteng tifri ini e guuluung. ");
INSERT INTO hrw_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Safle biing i e la, i e limlim tifri ini, “Ya mu mil usi gam le ku ta fabur ke Deo.” Kala i ka tuut ka la tingna Efeses. ");
INSERT INTO hrw_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Biing ri la masa una Sisaria, i e la kanek una Jerusalem ka la are, re tongge tinglo sios ma kam la ding una Antiok. ");
INSERT INTO hrw_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Wimi ine Pol e sau melmel lo fanenger fam biing una Antiok, i e la tingwa ka fes lala ulo fanenger fan male ulo bala rijen ina Galeisia ma Frigia, ka farawasnge ri lala e fan mara disaipel. ");
INSERT INTO hrw_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Lo sum biing a, neng e kaltu tingna Juda asow gii Apolos e ta kaltu torngon tingna Aleksendria e sa puek una Efeses. I e ta kaltu una warwar ine konona fan warwar, ma ming i e ta kaltu parfat kausi tikin lo fan warwar ilo bala sunwar pepe. ");
INSERT INTO hrw_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Ri sau fafabenge singi ine sal una la use Taufi gii ka famtete e bala ka matet tikin una fabenge singre tongge, ma i e peteng riis tifri ine Yesus, safle i e su parfat lo amfagu tarawen lewa Jon ka fabenge singre tongge ini. ");
INSERT INTO hrw_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","I e kaulek ulo bala felun nining kere fan Juda ma i e tibi soke re tongge, e su tofnge una sesngeni e sunwar. Biing Akwila ma Prisila ru ongni e fan warwar kia, ru onu ka la wilo fel ke ru ma ru ka la fabenge kausi singi lo sal use Deo, usi ini eu parfat ma ku ten kausi lo. ");
INSERT INTO hrw_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Wimi Apolos e sangsang una la wilo prowins ina Akaiya, fan tualik tinglo bala titinge ri farawasngeni una la ma ri ka siisiit tifre fan disaipel uwa ini riu areni. Biing Apolos e la fespuek una Akaiya, i e puek are faules bakir tifre seri a, lo fatengis ke Deo, ri kabuk titinge. ");
INSERT INTO hrw_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Le i e ti rawas tibom una koskoso mil e fan warwar kere fan Juda na matre tongge fuunfuun ma e fanangsi ini sinsinangu ri e lomba. Ma i ka sesngeni e sunwar ke Deo tifri una fanangsi ini sunwar kia e tikin ini Yesus e ta Kristus. ");
INSERT INTO hrw_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Biing Apolos e melmel una Korin, Pol e fesfes uwa ulo fan rijen, ma wimi i kam sa puek ulo taon Efeses. Una Efeses i e tongeni e fa lo re fan disaipel. ");
INSERT INTO hrw_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Ma i ka gatom ri, “Lo biing gam titinge, gam kepe ming e Tangwa Riis, tam e tam?” Ma ri ka koso aregii, “E tam, kemem tifik ong ini e mel e ti Tangwa Riis.” ");
INSERT INTO hrw_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Ma Pol ka gatom ri, “Ma sese amfagu a gam ka kepe?” Ma ri ka koso, “Amfagu lewa Jon ka fabenge ini.” ");
INSERT INTO hrw_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Ma Pol ka war aregii, “Amfagu tarawen ke Jon e ta tifre tongge gii ri sangikis. Ma Jon ka peteng tifre tongge ini ri samusu titinge lo kaltu se eu puek nami, i e ta Yesus.” ");
INSERT INTO hrw_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Ri ongni e sunwar gii ma ri ka kepe amfagu tarawen lo asow e Taufi Yesus. ");
INSERT INTO hrw_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Biing Pol e tow e limow ulo ri, Tangwa Riis e pu talo ri ma ri ka gon ine fan matmatang kinen ma ri ka sesngeni e sunwar ke Deo. ");
INSERT INTO hrw_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Lo ri, ri ngo are tikii sangful ma e u na kaltu. ");
INSERT INTO hrw_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Pol e kau ulo bala felun nining. Ma lo e tuul e funiil, i e tibi soke una peteng malal ma ka sesngeni e kepmale ke Deo tifri, ma ka tofo una iksi e sinsinangu ri una titinge lo. ");
INSERT INTO hrw_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Safle fa lo ri, ri tibi bur iksi e sinsinangu ri ma ri ka tibi ong una titinge. Ma namatre tongge nano a, ri fotpursi e Sal Taufi e fabenge ini. Iya Pol ka la kosing ri. I e uunre fan disaipel tura. Ma lo fan mara biing, ri la fafawar ulo bala felum fabenge ke Tairinus. ");
INSERT INTO hrw_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Pol e sesngeni e sunwar ka la muut lo e u e matamfaim, usi ini fan mara Juda ma fang Grik ri melmel ilo prowins ina Eisia, riu ongni e sunwar ke Taufi. ");
INSERT INTO hrw_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Deo e fafuutngeni ming e fanenger fan mok na tibou fuut ulo limow e Pol. ");
INSERT INTO hrw_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Iya anggisiip ma laplap a ri kabuk pot lo Pol ini, ri ka la tow ulo re tongge ri mase ma fan minse lo ri ka rop, ma fan tangwaner saksak ka la kosing ri. ");
INSERT INTO hrw_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Fanenger fan Juda ri fes fawet una feselufre fan tara saksak. Ma ri ka tofo una fotngi e asow e Yesus una feselufu e fan tara saksak tinglo seri a ri ka mel. Ri war, “Lo asow e Yesus lewa Pol ka sesngeni, ya war rawas tikin sing o ini ou suu o ku la.” ");
INSERT INTO hrw_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Skewa e ta pris bakir kere fan Juda. Ma e ta baba fis na sikow, iri gowgow e sinang a. ");
INSERT INTO hrw_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Sakle tara saksak e war singri, “Ya parfat lo Yesus ma ya parfat lo Pol, safle gam, gam se?” ");
INSERT INTO hrw_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Wimi kaltu a ine tangwaner saksak ulo e paket saksak iri ma e kulef ri nano. I e rangsi e fang kolos keri ma ri ka fin suu biilbiil tinglo ke fel tura fam pi ulo ri. ");
INSERT INTO hrw_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Fan Juda nano ma fan Grik lewa ri ka melmel una Efeses, ri ong lo mok gii, ri la soke tibom, ma ri ka nawen singe asow e Taufi Yesus. ");
INSERT INTO hrw_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Fuunfuun lo re tongge a ri ka titinge, ri sa la ma ri ka sesuupuek ine fan tubiil keri namatre tongge nano. ");
INSERT INTO hrw_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Fa lo re tongge a ri ka fafas ine fam bilbilse, ri puek tura fam buk keri ma ri ka tauftiim iri ma ri ka taiif lo ri namatre tongge. Biing ri wese e mata e fam buk a, mata e puek are e lim e sangful na mar na mani. ");
INSERT INTO hrw_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Lo sal a, sunwar ke Taufi e omseni kiruur e male, ma ka faf tura rawas. ");
INSERT INTO hrw_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Wimi ine fan mara mok gii e sau fuut, Pol e fagati e sangsang kia una fespaket una Masedonia ma Akaiya una la wina Jerusalem. I e war, “Wimi ini eu ta yau waleii, ya samusu la fespuek ming ina Rom.” ");
INSERT INTO hrw_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Ma i ka tuleni e ung kaltu na mus kia, Timoti ma Erastus, ru ka la famu ini una Masedonia. Ma i kabi melmel balik ulo prowins ina Eisia. ");
INSERT INTO hrw_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Lo sumbiing a fagorot bakir e matet falifu ire tongge tingna Efeses, anwarow lo Sal ke Taufi. ");
INSERT INTO hrw_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Nenge kaltu asow gii Demetrius, i e fafaim bisnis lo silwa, fam poksenge, i e bilbilseni lo felun nining ke deo gurgurum Atemis e gowgow lo silwa, ma e kepkepe singmat na mani tinglo. Iya ka tow e fam faim fuunfuun, tifre tongge na mus kia. ");
INSERT INTO hrw_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Igii Demetrius e tau tiim ire tongge fam faim keri e tiin ngo, ma ka war singri aregii, “Tanga kaltu, gau parfat lo konona fimfiil kerer e fespuek lo fam faim bisnis kiar gowgow. ");
INSERT INTO hrw_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Aregii gam kabuk pari ma ong ini Pol e tatfere tongge fuunfuun gii tingna Efeses, ma fatat ma ku ropo e male kiruur ina Eisia. I e peteng ini fan deo a kaltu ka bing ri, ri tibi ta fan deo tikin. ");
INSERT INTO hrw_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","E mel e sak ilo sunwar ke Pol. E tibi ta ini una bero ine safle faim bisnis kiar, safle ini eu bero ming ine felun nining ke deo fefin Atemis, ku la fespuek are mok fofoes ilo sinsinangure tongge. Famu tongge nano gii lo prowins Eisia ma gii lo nal nano ri sagisu nining lo, safle gii, sunwar ke Pol e bala bero ine as bakir a kia.” ");
INSERT INTO hrw_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Biing tongge ri ong lo mok gii, ri balasak ma ri ka tofnge una tau bakir aregii, “Deo fefin Atemis kiar na fan Efeses, i e ta iyat sekit!” ");
INSERT INTO hrw_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Aregii, tautau a e la puek bakir tikin ka afit kiruurngeni e siti a. Tongge a ri tatfeni e Gaiyus ma Aristakus, ung kaltu tingna Masedonia, ru taltalngeni lala e Pol. Tongge a ri tiin tiim lo ri ma ri ka filau wilo male na tiimtiim. ");
INSERT INTO hrw_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pol e bura ini eu ti na malal namatri e tongge. Safle fan disaipel ri tibi fasi ini riu taufu ku ti malal namatre tongge. ");
INSERT INTO hrw_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Ma ming fang kaltu bakir lo gapman tinglo prowins Eisia, seri fatatu tikin e Pol, ri tow e sunwar usi ini eu tibi kau ilo male na tiimtiim. ");
INSERT INTO hrw_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Tiim a e am tibi fespuek kausi, sinsinangu ri e am tibi tiim lo tikii ti sangsang. Fa ri tautau ine tikii sangsang, ma fa ri tautau ine fanenger fan sangsang. Fa fuunfuun lo re tongge a ri tibi parfat ini anwarow lo sa ri ka ta wa. ");
INSERT INTO hrw_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Fan Juda ri suleni e Aleksenda wi famu, fa lo re tongge a ri tautau singi ine sa i e samusu gow. Ma Aleksenda e bala tofo una koso e fan warwar kere tongge a ma ka gow e tintof ine limow usi riu fakuta e ngusngusri. ");
INSERT INTO hrw_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Sakle lo biing ri parfailmi ini i tingna Juda, ri ka tautau bakir sak ine tikii sunwar aregii, “Atemis kiar na fan Efeses e ta iyat sekit!” Ri tautau aregii ka la muut lo e u e awa. ");
INSERT INTO hrw_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Wimi kaltu efefe lo taon Efeses ka peteng tifre tongge ini riu tibi gon ma ka war singri aregii, “Gam na tongge tingna Efeses, gam ong, sese ti kaltu e tibi parfat ini Efeses e ta taon una efe lo felun nining ke deo fefin gii Atemis, ma una efe lo, i lewa ka luut tinglo balambat? ");
INSERT INTO hrw_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","E tek tikas e fasi una peteng ini sunwar gii e ta angurum, aregii gau fakuta e ngusngusmi, ma gam ku tibi saupe una gow e ti mok. ");
INSERT INTO hrw_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Gam tibom gam onu e ung kaltu a ru ka sa la, safle ru tibi kinow e ti mok ilo bala felun nining kerer, ma ming ru tibi fotpursi e deo fefin kiar. ");
INSERT INTO hrw_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Le Demetrius tura tongge na faim kia, ri mel e ti sunwar use tikas, e mel e biing una ti lo anganggon. Ma tongge bakir lo gapman, ri gii, riu fariisu e fan warwar keri biing ri kiis una anganggon. ");
INSERT INTO hrw_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ma ming le gam ku mel e ton warwar aiwa, e fasi ini gam u fariisu lo biing gam sam wele una tiim ususi e fafanau ke gapman. ");
INSERT INTO hrw_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Aregii, gam ong, le tongge lamlam lo gapman, ri ong lo fan mok, kerer sam gow gii, ri fasi una touf kerer ilo anganggon, ma riu peteng ini kerer bala famtete e ti mafet bakir, e tek ti anwarow e fan ninis gii kerer ka gow. Ma ming le ri ku gatom kerer, ‘Anwarow lo sa gii gam ka ta ilo fagorot a?’ Ma kerer tibi fasi una koso e ti sunwar.” ");
INSERT INTO hrw_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Wimi ini e fan warwar kia, i kam uunre tongge a ri ka la. ");
INSERT INTO hrw_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Biing fagalo lo re tongge a e la rop, Pol ka fauun usi re tongge na titinge ri ka sa tiim, ma i ka war faraungeri ma wimi ka tule ri ma i ka la una Masedonia. ");
INSERT INTO hrw_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","I e fes fawet ulo fan rijen a ka tow e fan warwar fuunfuun una faraunge re tongge, ma kam la puek una Grik, ");
INSERT INTO hrw_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","ka la melmel ulo lo e tuul e funiil. Ma ka bala kau ulo sip una la ina Siria, sakle i ka ong ini fan Juda ri fagati e tuui una paketmet ini, iya i ka iksi e sinangu ini i eu fes mil una Masedonia ");
INSERT INTO hrw_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Tongge ri fatalnge lo gii, Sopate sikow e Pirus tingna Beriya, Aristakus ma Sekundus, ru tingna Teselonaika, ma Gaiyus tingna Debe, Timoti ming, ma Taisikus ru Trofimus ru tinglo prowins ina Eisia. ");
INSERT INTO hrw_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Tongge gii ri la famu ri ka la nene kemem ulo taon ina Toroas. ");
INSERT INTO hrw_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Kemem melmel una Filipai ka muut lo En Bakir Lo Beret e Tek ti Is e la rop ma kemem ka kiis lo sip kemem ka la kosnge Filipai, e lim e biing wimi kemem ka la tonge re tongge a una Toroas, kemem ka melmel lo baba fis na biing. ");
INSERT INTO hrw_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Lo biing baba tikii lo wik kemem ka sa en tiim ma Pol ka sesngeni e sunwar tifre tongge ka la muut e la palim fapot e biing, anwarow i e bura ini eu la lo biing usi. ");
INSERT INTO hrw_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Keptim fel gii kemem ka tiim ulo e ta uiyat ma e fuun e fan lam ri fufuf ulo. ");
INSERT INTO hrw_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Pol e gon taptapak tikin, gii neng e guam asow gii Yutikus e kiiskiis ulo windou ka la susuiik gii ka masun. Ma biing i e sam la masun taut, ka luut tinglo galum fel baba e tuul ka la ufaf, tongge ri ka la kepe ma e sau met sekit. ");
INSERT INTO hrw_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Pol ka ding, ka la of talo guam a, ma ka ofngi ma ka war aregii, “Gam u tibi sangfuunfuun, i e liuliu iwa!” ");
INSERT INTO hrw_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Kala Pol ka kanek mil uiyat ka la bingpaki e beret ma ka en tiim tura re tongge. Wimi ini i e sam gongon ka la muut lo pisii e fen, i e la kosing ri. ");
INSERT INTO hrw_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Ma tongge ri ka onu e guam a ri ka la mil ulo male. Balbalri e gasgas, anwarow guam a e liu. ");
INSERT INTO hrw_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Kemem ka la famu ine Pol kemem ka la kiis ulo sip ma kemem ka la una Asos ini kemem ku la usngi uwa. I e sau fagati aiya, anwarow ini i eu su fes ilo sal ku la wa. ");
INSERT INTO hrw_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Biing Pol e sa tupnge kemem una Asos, kemem usngi ma kemem ka la una Mitilin. ");
INSERT INTO hrw_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Biing usi kemem ka la tingwa, kemem ka la u fatatu e bit ri fotngi ini Kios. Ma lo biing wimi, kemem ka la masa ulo bit Samos. Ma lo biing usi, kemem ka la puek ulo taon Miletus. ");
INSERT INTO hrw_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Pol e sau fagati e sinangu ini i eu la kosnge male na Efeses, una fakale lo, usi ini eu tibi la borong ilo prowins ina Eisia, le i e sausaupe una la ina Jerusalem. Le ini ku fasi, i eu la puek lo biing na Pentekos. ");
INSERT INTO hrw_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Kemem ka la puek una Miletus, ma Pol ka fauun usi re tongge na famu ine sios ina Efeses ini ri ku sa pari. ");
INSERT INTO hrw_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Biing ri sam sa fespuek i ka war singri, “Gau parfat ini are ya melmel tura gam lo biing kiruur gii, tofnge tinglo biing baba tikii ya puek wagii lo prowins gii na Eisia ");
INSERT INTO hrw_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Gau parfat ini fan Juda ri fagati e fan warwar keri una bero i yau, ri tow e mafet tif yau. Ya teng fuunfuun sak, sakle ya fapor yau tikin ma ya ka gow e mus ke Taufi. ");
INSERT INTO hrw_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Ma gau parfat ini ya tibi finufu e ti sunwar gii ka fasi una ules gam, sakle ya fabenge sing gam na matfuun ma ilo bala fam fel kemi. ");
INSERT INTO hrw_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Ya sau peteng ten tifre fan Juda ma fang Grik ini ri samusu iksi e balbalri usi e Deo, lo sinang una sangikis, ma ri ku titinge lo Taufi kiar Yesus. ");
INSERT INTO hrw_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","“Ma gii, Tangwa Riis e famtete e balang ini ya samusu la ina Jerusalem, ya tibi parfat ini sa eu la fuut lo yau waleii. ");
INSERT INTO hrw_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Ya su parfat ini ilo fan mara siti, Tangwa Riis e sagisu petpeteng fate yau ini safle rerek ma mafet e nene yau. ");
INSERT INTO hrw_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Safle ya tibi sang ini ninliu kiang e ta mok bakir usi yau. Safle ya su bura ini yau ropo e filau ma faim bakir gii Taufi Yesus ka tow tif yau ini yau sesuupuek ten ine konona sunwar lo fatengis ke Deo. ");
INSERT INTO hrw_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Gii ya parfat ini e tek tikas lo gam lewa ya ka fesfes falifu i gam una sesngeni e sunwar lo kepmale ke Deo, e mu pari mil e matang. ");
INSERT INTO hrw_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Iya ya ka peteng ten tif gam, le tikas lo gam ku tibi titinge ma ku ti ilo anganggon, e tibi ta ini anwarow lo yau. ");
INSERT INTO hrw_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Anwarow ya tibi sokeni e tikas una sesngeni e fan mara sangsang ke Deo tif gam. ");
INSERT INTO hrw_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Gam samusu efe kausi lo gam tibom ma lo re tongge nano tinglo sios ke Deo are Tangwa Riis e sam gau gam ka ta tongge na famfamu ine sios. Gam samusu ta konona efefe lo sios ke Deo, i e fiil familri ine andaku e Sikow tibom. ");
INSERT INTO hrw_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Ya parfat ini, wimi ine biing ya sam la kosing gam, fam puul rokai saksak sekit riu sa la ilo falifu lo gam, ma ri ku bero i gam. ");
INSERT INTO hrw_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Ma ming fa lo gam tibom riu matet, ri ku gow e fan warwar gurgurum una fufteni e tongge ke Deo una mi nami ri. ");
INSERT INTO hrw_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Iya, gam u ate! Sangsangfi ini lo ampanambiing ma ansiat, ya tibi manau una tow e war ate tif gam nano lo e tuul e matamfaim, tura darun matang e riring. ");
INSERT INTO hrw_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Gii ya tauf gam tife Deo ma sunwar lo warfakausi kia. Sunwar a kia, e fasi una farawasnge gam ma una fen gam ine mara mok Deo e sagisu towtow tifre tongge a i kabuk fatarawennge ri. ");
INSERT INTO hrw_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Ya tifik mer usi ti silwa, tam ti gol, tam use ti kolos ke tikas. ");
INSERT INTO hrw_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Gam sau parfat ini un limang gii, e sam ules yau tibom lo fam fabur kiang ma e sam ules re fan taltalung ming lo fam fabur keri. ");
INSERT INTO hrw_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Ilo fan mara mok ya sam gow, ya fanangsi ini lo fan matmatan mus gii, kiar samusu faim rawas ma kiar ku ules re fa a, ri ka tibi fasi una ules ri tibom, sangsangfi e fan warwar ke Taufi Yesus, i tibom e sau peteng ini: ‘Le o ku fafen ou kepe warfakausi bakir. Le o ku su awawit, o su kepe e warfakausi eu su balik.’” ");
INSERT INTO hrw_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Biing i e sam war aregii, i e pukungkek tura ri nano ma i ka nining. ");
INSERT INTO hrw_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Ri tiin fatengse biing ri ofeng famti e Pol ma ri ka osngi. ");
INSERT INTO hrw_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Sa tikin e gau ri, ri ka fatengis, sunwar lewa Pol ka war ini, aregii ini ri amu tibi pari mil e mata. Kala ri ka la tafu e Pol ulo sip. ");
INSERT INTO hrw_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Kemem la kosing ri ma kemem ka kau ulo sip, wimi ini kemem kaupaket riis, sip ka la masa ulo bit ri fotngi ini Kos. Biing usi kemeu puek una Rodes, ma tingwa kemem ka la sekit una Patara. ");
INSERT INTO hrw_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Uwa kemem tongeni e sip e bala la wina Fonisia. Kem ka kau ulo ma kemem kabuk la. ");
INSERT INTO hrw_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Kemem ka manngeni e bit Saiprus, kem ka filau ulo galu miil lo wina Siria kemem ka masa una Tair, una la fasowfu e fan inwit wilo male a. ");
INSERT INTO hrw_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Uwa kemem siksik ire tongge na titinge, wimi kemem ka la melmel tura ri, lo tikii wik. Lo rawas ke Tangwa Riis ri peteng tife Pol ini eu tibi la ina Jerusalem. ");
INSERT INTO hrw_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Sakle biing tikii wik kemem melmel unais ri e rop, kemeu matet una la kosingri. Ri nano ri matet tura kemem, tura fan wok keri ma siksikwari, ri fatalnge lo kemem tinglo siti wina kiin. Kemem ka la kiis pukungkek ma kemem ka la nining. ");
INSERT INTO hrw_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Ma lo biing kemeu fatule, kemem ka kau mil ulo sip, ma iri, ri ka la mil wilo fan male keri. ");
INSERT INTO hrw_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Kemem ka posmi e fines lo sip tingna Tair wina Tolemes. Ulo male a, kemem are re tongge na titinge, ma kemem ka melmel tura ri lo tikii biing. ");
INSERT INTO hrw_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Lo biing usi kemeu matet kem ka la puek una Sisaria. Uwa kemeu melmel ulo fel ke Filip, i e ta iwengelis, neng lo re baba fis na kaltu, ri sam siik ri una fafaules una titi ine fan tuan tifre fan wok makos ina Jerusalem. ");
INSERT INTO hrw_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","I e mel e e fet e polsom kia, ri sesesngeni e sunwar are fam profet ma ri tibi tinaule. ");
INSERT INTO hrw_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Kemem sam ta uwa lo tanga biing, ma neng e profet asow gii Agabus, ka sa la tingna Judia. ");
INSERT INTO hrw_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","I e sa la sekit usi kemem ka sa kepe e aneueu ke Pol, ka deti e unlimow ma ungkekow ini, ma ka war, “Tangwa Riis e peteng aregii, ‘Lo tikii sinang gii ya ka gow gii, ya pete pinsa-i ini fan Juda tingna Jerusalem, ri amu gow lo kaltu gii ine aneueu kia gii, ma ri ku tow tifre fan Jentael.’” ");
INSERT INTO hrw_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Biing kemem ong lo mok a, kemem tura tongge uwa, kemem war rawas singe Pol, ini eu tibi la ina Jerusalem. ");
INSERT INTO hrw_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Safle i e koso aregii, “Gam tamu gam ka tengteng, gam ka pete kuuluung ine balang? Ya nene e tibi ta ini una su la ilo rerek, safle una met ming ina Jerusalem, fapakti e asow e Taufi Yesus.” ");
INSERT INTO hrw_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Kemem tibi fasi una iksi e sinangu e Pol, iya kemem kabuk su war aregii, “Tafu e fabur ke Taufi ku fuut.” ");
INSERT INTO hrw_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Wimi ine tanga biing e sam la, kemeu fagati kemem ma kemem ka tofnge una fes wina Jerusalem. ");
INSERT INTO hrw_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Fa lo re fan disaipel tingna Sisaria, ri la ming tura kemem. Ma ri ka uun kemem una la melmel ulo fel ke Nason, i e ta kaltu tingna Saiprus, ma e sam ta disaipel ting nangen. ");
INSERT INTO hrw_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Ma biing kemeu fespuek una Jerusalem, fan tualikmem ri fefeal una are kemem. ");
INSERT INTO hrw_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Lo biing usi Pol e la tiim tura kemem una la pari e Jeims. Ma tongge na famu ine sios ri puek ming. ");
INSERT INTO hrw_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Pol e are ri ma ka sesngeni e mara faim Deo e sau musngeni tinglo limow, ulo falifu lo re fan Jentael. ");
INSERT INTO hrw_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Ma biing ri sam ongni e sinseng ke Pol, ri tofnge una katfarsi e Deo. Ma ri ka peteng tifi, “Tualikmem, o sau pari, e fis sekit e mar na Juda gii, ri sam titinge ma ri nano ri sau fafen kiruurnge ri una usi e fafanau. ");
INSERT INTO hrw_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Ri sam ong ini o fabenge singre fan Juda nano gii ri ka mel ilo falifu lo re fan Jentael, ini riu tibi usi e fafanau ke Moses una talsi e pinpinumfore anrimberat fan tamat keri, ma ini riu tibi usi e ninis kere tumtumlarer. ");
INSERT INTO hrw_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Ma le ri ku ong ini o sau puek, aregii kemem ku gorot? ");
INSERT INTO hrw_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Igii e faim kemeu bura ini ou musngeni. E mel e fet e kaltu gii ri sam limlim na mata e Deo. ");
INSERT INTO hrw_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","O samusu uun ri, gam ku tiin tiim una fakalkaliisnge gam ususi e fafanau ke Moses. Ma ming o samusu feli e ti ton mok una la tow are finafen una fakalkaliisnge ri ma wimi ri kamu kiufu e olol ri una fanangsi ini ri sam kulfi e limlim keri, ma tongge nano ri ku parfat ini fan warwar ri oteng o ini e tibi tikin, safle ini o tibom o melmel ususi e fafanau. ");
INSERT INTO hrw_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Kemem sam tuleni e pas tifre fa lo re fan Jentael a ri ka titinge, ma kemem ka peteng tifri ini riu tibi eni e fan tuan ri fafen ini tifre fan deo gurgurum, riu tibi eni e fang gemgem e mel e andadak ilo, tam ti man ri pulmi ma ini riu tibi gow e ansinang na faet falek.” ");
INSERT INTO hrw_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Lo biing wimi Pol e onu e fet e kaltu a, ri ka tiin la fakalkaliisnge ri. Wimi i ka la kaulek ulo bala Felun Nining Bakir ka la fate re fam pris ini e su ta e fis e biing uwa ma ku rop e fam biing una fakalkaliisnge ri, usi fam pris riu fafen ine fam finafen ke tikii, tikii neng lo ri. ");
INSERT INTO hrw_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Fatat ma baba fis na biing ku rop, fa lo re fan Juda tinglo prowins ina Eisia, ri pari e Pol ulo bala Felun Nining Bakir. Ri ka war ta na balre tongge nano, ma ri ka bingfamti e Pol ");
INSERT INTO hrw_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","ma ri ka tautau aregii, “Tongge tingna Israel, gaman ules kemem. Kaltu gii e fafabenge lala singre tongge ilo fang galgalu nano ma e tatfe ri una fotpuris kerer na fan Juda ma fam fafanau kerer ma Felun Nining Bakir. Ma ming, i e uun kaulek ire fang Grik wilo bala Felun Nining Bakir, ri kabuk sa pete du ini na mata e Deo.” ");
INSERT INTO hrw_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Ri war aiya, anwarow famu ri sau pari e Trofimus tingna Efeses tura Pol ulo siti, ri ka sangfi ini Pol e onu ka la kaulek ulo bala Felun Nining Bakir. ");
INSERT INTO hrw_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Tongge nano ulo siti a ri ongni e sunwar a, ma ri ka sangfuunfuun. Ma tongge nano ri ka fafilaunge ri ka la bingfamti e Pol ma ri ka tatfe suu ini tinglo bala Felun Nining Bakir. Ma saupesak fan matmatangkon lo Felun Nining Bakir ka babat. ");
INSERT INTO hrw_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Tongge ri tofo una paketmet ine Pol. Sumbiing a, warwar e sam la tife kaltu bakir lo re fan soldia tingna Rom, ini tongge nano tingna Jerusalem ri balasak, ri ka fapaket falek. ");
INSERT INTO hrw_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Saupesak kaltu bakir a ka uunre fan ofisa ma fan soldia ri ka filau usi re tongge a. Sumbiing tongge a ri pari e fespuek tura fan soldia, ri manau sekit una pakti e Pol. ");
INSERT INTO hrw_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Kaltu bakir kere fan soldia a ka puek ka bingfamti e Pol, ma ka peteng tifre fan soldia una kawi famti ine e u e sen, ma ka gatom re fan Juda aregii, “Kaltu gii e ta se, ma e gow e sa?” ");
INSERT INTO hrw_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Fa lo re galung kaltu a ri tautau kuriik, ma fa ri ka tautau kuriik, gii kaltu bakir kere fan soldia ka tibi fasi una ongen ten ine fan warwar keri, anwarow ri fagalo. Iya i ka fauun ini fan soldia riu onu e Pol ku la wilo pakanmale keri. ");
INSERT INTO hrw_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Biing Pol e la puek fatat ulo male a, balasak kere tongge uwa, e la bakir tikin, iya fan soldia ri ka kepe kosing ri. ");
INSERT INTO hrw_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Tongge fuunfuun ri mimi lala nami ri, ri ka tautau lala aregii, “Paketmet ini!” ");
INSERT INTO hrw_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Biing fan soldia ri bala uun kau ini wilo male a, Pol ka gatmo e kaltu bakir, “E fasi ini yau bi gon sing o?” Ma kaltu bakir ka koso singi, “O parfat ming lo warwar Grik, be? ");
INSERT INTO hrw_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","E sam ta o na kaltu tingna Ijip, lewa nangen o ka tofngeni e fapaket una bero ine gapman ma o ka famu ine e fet e mar na kaltu na fafapaket ine fan ringgot, ma o ka uun ri kala ulo male mas?” ");
INSERT INTO hrw_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Pol ka koso aregii, “Ya na sikin Juda ma ya fuut ulo siti Tarsus ilo prowins Silisia. Ya na sikin tuman tinglo siti Tarsus, ma siti gii asow e bakir tikin. Kiskam, e fasi ini ou a-uu i yau, ya ku gon singre tongge gii?” ");
INSERT INTO hrw_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Biing Pol e sam kepe war a-uu, i ka ti uiyat ma ka war famanaunge re tongge a ine limow. Biing e la tet borong lo ri, i ka gon singri lo kinen Ibru. ");
INSERT INTO hrw_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Tanga tuaklik ma tanga tabuung gam ong, gii yau peteng malal i yau tif gam. E tek ti tubiil kiang.” ");
INSERT INTO hrw_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Biing ri ongni e gongon singri lo kinen Ibru, e la tet borong sok lo ri, ma Pol ka war, ");
INSERT INTO hrw_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Ya na sikin Juda, ya fuut ulo bala siti Tarsus ilo prowins Silisia, safle ya la bakir ulo siti ina Jerusalem. Ya na boroner na fabenge ke Gamaliel, ma i e fabenge kausi sak sing yau lo mara fafanau kere tumtumlarer. Ma ya faim tuntun una faraungeni e sinang Deo e bura, e su ngo are gam gii. ");
INSERT INTO hrw_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Ya bero ire tongge a ri kabuk usi e Sal Taufi e fabenge ini ma fa lo ri ya gow e sal keri una met. Ma ming ya bing famfamti re antamat ma gelefin, ya ka touf ri ulo rerek. ");
INSERT INTO hrw_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Paklure fam pris ma fang kaonsiil nano kere fan tongge ri parfat lo sinang ya gow, ri fasi una peteng ten tif gam. Ri sam tow e fam pas tif yau ri seti tifre tanga tualikrer ri melmel ina Damaskus. Ya kabuk fes wina Damaskus una la kawi famti ri ma uun ri wina Jerusalem ini tongge lamlam ri ku sa tow e mafet tifri. ");
INSERT INTO hrw_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Fatfatat lo siat tuntun ya fespuek fatat una Damaskus, saupesak neng e anten e ten tikin e sosok tinglo balambat ka furat liflifit yau. ");
INSERT INTO hrw_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Ya luut ulo nal, ma ya ka ongni e angkiimkiim e gon sing yau. ‘Sol! Sol! Anwarow lo sa gii o ka bero sok i yau?’ ");
INSERT INTO hrw_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","“Ya ka gatmo, ‘Kaltu bakir, o se?’ “I ka koso, ‘Yau Yesus tingna Nasaret, iya o ka berbero i yau.’ ");
INSERT INTO hrw_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Tanga taltalung ri pari e anten, sakle ri tibi ongen failmi e angkiimkiim a ka gongon sing yau. ");
INSERT INTO hrw_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","“Ya ka gatmo, ‘Taufi, sese mok yau gow?’ “I ka koso sing yau, ‘Matet, o ku la kau ina Damaskus. Ri mu la peteng tifo waleii ine sese mok ya sau fagatiufu tifo una gow.’ ");
INSERT INTO hrw_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Fa ri talnge yau ri puse lo limang ri ka sas kau i yau una Damaskus le ansinsokow e anten e pete baf sekit i yau. ");
INSERT INTO hrw_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Nenge kaltu asow gii, Ananaiyas ka fespuek una sa par yau. I e ta kaltu e fafen ini tife Deo, ma e usi fakausi tikin e fam fafanau, ma fan Juda nano ri melmel ina Damaskus ri natkeni tikin. ");
INSERT INTO hrw_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Ma i ka sa ti unais yau ma ka war, ‘Tuaklik Sol, par mil!’ Ma lo sumbiing sekit a, anmatang e la par mil, ya ka fasi una pari. ");
INSERT INTO hrw_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","“I e war, ‘Deo kere fan tuptuprer e sam wel o una parfat lo fabur kia, una pari e Kaltu e Riis sekit ma una ongni e angkiimkiim aiya tibom. ");
INSERT INTO hrw_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Usi ou ta kaltu una peteng tifre tongge nano, ine sa o sau pari, ma sa o sam ongni. ");
INSERT INTO hrw_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Ma gii, o nene i e sa? Matet ong kepe e amfagu tarawen, ma o ku nining singe Yesus una tii ine fan tubiil kiam.’ ");
INSERT INTO hrw_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Biing ya la mil una Jerusalem ma biing ya nining ulo bala e Felun Nining Bakir ya pari e mok e ngo are numbiil. ");
INSERT INTO hrw_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Ya ka pari e Taufi e war sing yau, ‘Matet o ku la saupe kosnge male ina Jerusalem. Le o ku sesngeni e fan warwar lo yau wagii ri tibi fasi una titinge lo.’ ");
INSERT INTO hrw_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","“Ya ka koso aregii, ‘Taufi, tongge gii ri parfat ini ya la ulo fan mara felun nining una paket re tongge ri titinge lo o ma una sele re fa talo rerek. ");
INSERT INTO hrw_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Ma biing ri paketmet ine Stiwen, kaltu e sesesngeni lala e sunwar lo o, ya titi uwa ya ka a-uu lo ma ya ka efe lo fan kolos kere tongge gii ri ka paketmet ini.’ ");
INSERT INTO hrw_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","“Taufi ka war sing yau, ‘Ou la, yau tule o, o ku la i tapak use re fan Jentael.’” ");
INSERT INTO hrw_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Fan Juda ri ongong singe Pol ka muut lo biing ri ongni e war foteng re fan Jentael, iya ri kam tautau bakir, “Tii ini tinglo nal! Matang kaltu aiya e tibi fasi una liu!” ");
INSERT INTO hrw_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Ri ka fafakaunge bakir, ma ri ka bas ine fang kolos keri ma ri ka sabel ine ambaukif uiyat. ");
INSERT INTO hrw_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Kaltu bakir kere fan soldia ka fauun ini riu uun kaulek mil ine Pol wilo bala pakanmale keri. Ma ka peteng tifri ini, ri samusu napsi ma ri ku gatmo ini e tamu tikin gii tongge gii ri ka fafakaunge aiya talo. ");
INSERT INTO hrw_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Safle sumbiing ri kawi famti una napsi, Pol e pari e ofisa e titi fatat ka gatmo, “E fasi lo fafanau kemi ini gam u napsi e ti sikin Rom torngon, ma gam ka tifik sikseni e ti tubiil kia?” ");
INSERT INTO hrw_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Biing ofisa e ongni e sunwar gii, e la sekit ka la puek talo Kaltu Bakir ka la peteng tifi ini ma ka gatmo “Sa gii o ku gow? Kaltu gii e ta sikin Rom torngon.” ");
INSERT INTO hrw_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Iya Kaltu Bakir ka fes use Pol ka la gatmo, “O na sikin Rom torngon?” Ma Pol ka koso, “Yow.” ");
INSERT INTO hrw_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Wimi Kaltu Bakir a ka war, “Yau, ya fifiil bakir una ta sikin Rom tuman.” Safle Pol e koso, “Yau, ya fuut are sikin Rom torngon.” ");
INSERT INTO hrw_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Saupe sak, fa a ri ka bala gatom fafalek ini, ri tii kosngi. Kaltu Bakir a, i tibom e la kuufsak biing e la par failmi ini i e sam tafu e Pol sikin Rom torngon, ri ka kawi famti. ");
INSERT INTO hrw_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Lo biing usi, anwarow Kaltu Bakir e bur sikseni sekit ini sese mok tikin fan Juda ri anganggon singe Pol tura, i ka pikufu e Pol ma ka fauun fam pris lamlam ma mara Kaonsiil ri ka tiim lo ri. Wimi kam uunpuek ine Pol ka sa fetiufu u famu iri. ");
INSERT INTO hrw_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pol ka par riis use re fang Kaonsiil ma ka war, “Tanga tuaklik, melmel kiang na mata e Deo e riis ka la muut gii. Ya tibi ongni ini yak sam gow e ti tubiil.” ");
INSERT INTO hrw_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Ma anwarow lo sunwar a, Ananaiyas Paklure fam Pris ka tungen re fa, ri titi unaisa e Pol ini riu posi e ngusu. ");
INSERT INTO hrw_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Pol e war singi, “Deo eu paket o, anwarow o ina male o par kausi safle ilo balam e du. O kiiskiis a una ikse yau ilo pikliu e fafanau, sakle o tibom o bom bero ine fafanau, anwarow, o tow e rawas tifre tongge una pose yau!” ");
INSERT INTO hrw_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Tongge ri titi fatat ri ongni e sunwar ke Pol, ma ri ka gatmo, “E tamu o ka fotpursi e Paklure fam Pris ke Deo?” ");
INSERT INTO hrw_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Ma Pol ka koso aregii, “Tanga tuaklik, ya tibi parfat ini i e ta Paklure fam Pris. Sunwar ke Deo e peteng aregii, ‘Gam u tibi fotpursi e kaltu bakir kere tongge kemi.’” ");
INSERT INTO hrw_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Biing Pol e pari ini fa lo ri, ri ta fan Sediusi ma fa ri ta fam Farasi, i ka tau singre fang Kaonsiil aregii, “Tanga tuaklik, ya na Farasi ma ya na sikuan Farasi. Ya titinge ini e mel e matmatet mil tinglo minet, i mung gii ri ka tauf yau ilo anganggon.” ");
INSERT INTO hrw_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Biing i e gow e sunwar a, fatinge e fespuek falifu ine fam Farasi ma fan Sediusi, ma tiim lo ri ka tapot. ");
INSERT INTO hrw_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","(Fan Sediusi ri titinge ini, e tek ti matet mil kosnge minet, tam ti anggelo, tam ti tangwa, sakle fam Farasi ri parfailmi e fan mok gii.) ");
INSERT INTO hrw_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Fagorot a e la fespuek bakir tikin ma fan titsa lo fafanau a ri ka ta fam Farasi, ri ka matet ri ka ting rawas tikin aregii, “Kemem tibi sikseni e ti tubiil ilo kaltu gii. Kuuf ma ku ta ti tangwa tam ti anggelo ka tow e sunwar gii tifi.” ");
INSERT INTO hrw_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Fatinge e puek ka la sak sekit gii Kaltu Bakir ka soke tura Pol are ri ka pakti ma ri ka farages ini, iya i ka uunre fan soldia ri ka la onu kosing ri ka la ulo pakanmale keri. ");
INSERT INTO hrw_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Ma lo panambiing, Taufi ka puek talo Pol ma ka sa war singi, “Ti rawas! O sam sesuupuek i yau una Jerusalem, o samusu la sesuupuek i yau ming waleii na Rom.” ");
INSERT INTO hrw_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Lo biingbiing e mok usi, fan Juda ri puek tiim tura neng e sangsang, una paketmet ine Pol, ma ri ka warkale ri tibom ini riu tibi en, tam in ku muut riu paketmet ine Pol. ");
INSERT INTO hrw_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","E fuun iyat ine e fet e sangful na kaltu ri tiim tura sangsang a. ");
INSERT INTO hrw_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Ri la usi re fam pris lamlam ma tongge lamlam, ri ka la peteng tifri aregii, “Kemem sam gow e warkale rawas ini kemem u tibi en ti mok ku muut kemem u paketmet ine Pol. ");
INSERT INTO hrw_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Ma gii, o tura re fang Kaonsiil, gam u gatmo e Kaltu Bakir una uunpuek ine Pol ku sa ti famu i gam ilo poktow e angurum ini gau bur ong kausi lo mok ri anganggon lo tura. Kemem sau fagati ini kemem u paketmet ini, famu ini ma kamu sa puek wagii.” ");
INSERT INTO hrw_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Sakle biing kawalik e Pol e ong lo mok ri bala gow, i ka la ulo pakanmale kere fan soldia ma ka la peteng tife Pol. ");
INSERT INTO hrw_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Wimi Pol ka tau ine neng lo re fan ofisa ma ka peteng tifi, “Onu e guam gii use Kaltu Bakir. E mel e mok i e bala peteng tifi ini.” ");
INSERT INTO hrw_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Ofisa ka onu ru ka la use Kaltu Bakir ma ofisa ka war, “Pol kaltu ilo rerek e fauun usi yau ma ka gatom yau una onu e guam gii usi o, anwarow e mel e mok i e bala peteng tifo ini.” ");
INSERT INTO hrw_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Lo biing a, Kaltu Bakir e puse lo limow ma ka la tura u tapak balik ma ka gatmo, “O bala peteng ine sa tif yau?” ");
INSERT INTO hrw_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","I ka koso, “Fan Juda ri sam a-uu una sa gatom o una onu e Pol usi re fang Kaonsiil na biingbiing, tura anggurum ini ri bura ini riu sikseni e ti mok e tikin lo i. ");
INSERT INTO hrw_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Sakle ou tibi ong singri, anwarow e fuun iyat ine e fet e sangful na kaltu riu keskum nene i. Ri sam warkale ri tibom ini riu tibi en ma in ku muut riu paketmet ini. Gii ri sau fagati ri ma ri ka su nene ilo war a-uu kiam.” ");
INSERT INTO hrw_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Kaltu Bakir ka onu e guam a ka la ma ka fanow aregii, “Ou tibi la seseng tife tikas ini o sam sa peteng tif yau ine fan mok gii.” ");
INSERT INTO hrw_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Kala i ka tau ine e u e ofisa kia ma ka war, “Fagatiufu e u e ti atis na soldia, e fis e sangful na kiiskiis lo fan os, ma e u e atis na fafapaket ine fan iu, una la ina Sisaria lo anmatam pisii baba e siu gii na panambiing. ");
INSERT INTO hrw_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Terngeufu ming e ti ton os tife Pol, usi gam u efe kausi lo, ku la usi e Gawana Feliks.” ");
INSERT INTO hrw_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","I e siisiit aregii ulo pas: ");
INSERT INTO hrw_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Klaodius Lisias, ");
INSERT INTO hrw_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Kaltu gii, fan Juda ri bingfamti ri ka bala paketmet ini, sakle lo biing ya sam la parfat ini i e ta sikin Rom tuman, ya puek tura fan soldia kiang, ya ka kepe kosing ri. ");
INSERT INTO hrw_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Ya bur parfat ini sese anwarow gii ri ka bero ini, gii ya ka onu tifre fang Kaonsiil keri. ");
INSERT INTO hrw_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Ya ka sikseni ini mok ri otngi ini, e su ta fang gatgatom ulo fafanau keri, sakle ri tibi otngi ine ti tubiil gii ka fasi lo ini riu paketmet ini, tam riu tafu ilo rerek. ");
INSERT INTO hrw_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Biing ya su ong ini ri gow e fagati borong una paketmet ine kaltu gii, ya tuleni saupesak usi o. Ya onu ming e tongge gii ri ka anganggon lo ini riu bom la seseng tifo, usi ini o ku parfat lo mok ri bala anganggon lo i tura. ");
INSERT INTO hrw_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Iya fan soldia ri ka usi e fam fagati aregii ri kabuk tow tifri, ri ka onu e Pol, ri ka la tura lo panambiing, ri ka la sekit ulo taon ina Antipatris. ");
INSERT INTO hrw_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Ma lo biing usi fan soldia na kiiskiis lo fan os ri la sekit ulo taon Sisaria una la towfu e Pol, ma fanenger fan soldia ri ka la mil ulo pakanmale keri una Jerusalem. ");
INSERT INTO hrw_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Biing ri la puek tura Pol una Sisaria, ri tow e pas tife gawana ma ri kam tafu e Pol tifi. ");
INSERT INTO hrw_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Gawana ka wese e pas ma ka gatmo e Pol ini i tinglo sese prowins. Biing gawana e la parfat ini Pol tingna Silisia, ");
INSERT INTO hrw_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","i ka war, “Ya mu ong lo mafet kiam, biing tongge ri oteng o, riu puek.” Wimi kau fauun ini riu tafu e Pol ilo bala fel ke Erot ma ri ku efe rawas lo. ");
INSERT INTO hrw_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","E lim e biing wimi Ananaiyas Paklure fam Pris e la ding una Sisaria tura tongge lamlam ma neng ming neng e kaltu parfat lo fafanau ke gapman, ri fotngi ini Tertulus, ma ri ka la tow e fan warwar ri gow talo Pol tife gawana Feliks. ");
INSERT INTO hrw_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Biing ri tau kaulek ine Pol, Tertulus e tofnge una peteng ine faoteng keri talo Pol tife Feliks ma ka war aregii, “O sam ules kemem lo konona kiiskiis ma e tek ti fapaket. Lo konona parpar kiam o ules re tongge kemem una fariisu e fan mara mok, usi eu tek ti mok e sak eu bero ine male. ");
INSERT INTO hrw_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Ilo mara sal ma ilo mara mok kemem parfailmi e mok gii tura fefeal, ma kemem ka katfariis o. ");
INSERT INTO hrw_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Safle ya tibi bura una pete main ine fom, ya su bala gatom ini ou tengis kemem, o ku ongne boron sunwar kemem. ");
INSERT INTO hrw_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","“Kemem sau parfailmi ini kaltu gii, e gow e fan tubiil fuunfuun sak. Ma i e fanfanwaru e fam balasak gii lo nal kiruur ilo falifu lo re fan Juda. Ma i e ta paklure galung kaltu ri tii kosing kemem ri ka foteng ri ini ri na fan Nasarin. ");
INSERT INTO hrw_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Kemeu bingfamti le i e tofo ming una bero ine Felun Nining Bakir. ");
INSERT INTO hrw_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Ou gatom fakausi e Pol, usi o mu kepe e ti sangsang tinglo ngusu use fan mara warwar kemem gow talo.” ");
INSERT INTO hrw_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Fan Juda ming ri ulsi e Tertulus una gow e fan warwar talo Pol, ri peteng ini fan warwar gii e tikin. ");
INSERT INTO hrw_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Biing gawana e ares mata usi una war, ma Pol kabuk su koso aregii, “Ya parfat ini fan matamfaim fuunfuun o melmel are kaltu na ikikse re tongge gii, ma balang e fefeal tikin una fakale lo yau. ");
INSERT INTO hrw_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","O tibom, o fasi una mu bom sikseni ini e tek ti biing wimi ine tikii sangful ma e u na biing, ya la una Jerusalem ya ka la una la nining. ");
INSERT INTO hrw_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Ma fan Juda ri tibi par yau tura tikas gii ini kamau fatinge ulo bala Felun Nining Bakir, tam ini yau famtete e ti balasak tura ti galung kaltu ilo bala fam Felun Nining, tam ilo sese neng e galu ming ilo bala siti. ");
INSERT INTO hrw_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Ma sunwar gii ri ka tauf yau tura ilo anganggon, e tibi tikin. E tek ti sal keri una fanangsi o aregii ini sunwar a e tikin. ");
INSERT INTO hrw_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Safle ya bur sesuupuek ine boron sunwar tifo. Ya peteng tikin ini ya nining lo Deo kere fan tamtamrer are kaltu e ususi e Sal, gii tongge ri ka peteng ini e ta neng e sios, ya titinge ming lo mara mok gii ri ka a-uu lo ususi e fafanau ma ri ka siitufu ilo buk kere fam profet. ");
INSERT INTO hrw_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Ma ya mel e fanene tura titinge kiang ilo Deo are ri tibou ming e mel ilo ri, e mel e matmatet mil kosnge minet kere tongge nano, fa ri riis ma fa ri sak. ");
INSERT INTO hrw_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Gii ya ka faim rawas una gow e ansinang na balang ku ten na mata e Deo ma tongge nano. ");
INSERT INTO hrw_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Wimi ini ya sam la borong lo tanga matamfaim, ya ka sa mil una Jerusalem una sa tow e fam finafen tifre tongge kiang se a ri ka sasngal ma una fafen ine fam finafen kiang tife Deo. ");
INSERT INTO hrw_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Lo biing ya sam faropo e faim una fakalkaliisnge yau, ulo bala Felun Nining Bakir tongge ri kau par yau. Ma e tek ti tongge fuunfuun una isang, tam rik selfau faliu. ");
INSERT INTO hrw_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Sakle e mel e fan Juda tinglo prowins Eisia, e tam iri gii. Ri tibom ri samusu sa puek wagii famu i o ri ku sa peteng ine fam faoteng keri, le ku mel e ti sunwar iyai wa i singri usi yau. ");
INSERT INTO hrw_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Tam fa gii ri ka ta iri gii, riu samusu peteng ine sese tubiil ri sikseni lo yau, lo biing gii ya ka ti na matre fang Kaonsiil. ");
INSERT INTO hrw_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Le ku ta tikii mok gii, lo biing ya titi una isri ma ya ka tau bakir ini, ‘Ya ti lo anganggon geinggii famu i o nafow ini e mel e matmatet mil tinglo minet.’” ");
INSERT INTO hrw_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Feliks se e sam ten balik lo Sal Taufi e fabenge ini, i e sumiufu e anganggon. I e war aregii, “Biing Lisias Kaltu Bakir kere fan soldia eu puek, ya kamu ikseni e keu mafet.” ");
INSERT INTO hrw_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Ma ka tungni e Ofisa gii ka efe lo Pol ini eu parpar kausi lo. Sakle eu tafu ku fesfes ma ku a-uu lo re fan taltalu una tow e sese mok eu bura. ");
INSERT INTO hrw_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Fam biing wimi, Feliks ka puek tura ke wok Darusila, e ta fefnan Juda. Feliks ka sa fauun use Pol, i ka fespuek ka sa sesngeni e sunwar lo titinge ilo bala Yesus Kristus ma Feliks ka ongne lo. ");
INSERT INTO hrw_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Biing Pol e sesngeni lala e sinang e riis, sinang una efe kausi lo ninliu, ma anganggon una puek, Feliks ka soke ma ka war, “E buk muut wa, ma o ku la. Le ku tek ti niil lo yau, ya kamu fauun mil usi o.” ");
INSERT INTO hrw_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Lo sumbiing a, i e sangsangfi ming ini Pol eu fiil salu ini ti mani are sal una falimufu. I lea anwarow gii i kau fauun sok usi ka sa warwar singi. ");
INSERT INTO hrw_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Wimi ini e u e matamfaim e rop, Posius Festus ka pilsi e Feliks are gawana. Safle Feliks e bura ini eu usi e fabur kere fan Juda, iya, i ka toufsok lo Pol ulo rerek. ");
INSERT INTO hrw_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Festus e la fespuek ulo prowins Judia ma wimi ini e tuul e biing, i kau matet tingna Sisaria ka la kanek una Jerusalem. ");
INSERT INTO hrw_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Ma uwa, fam pris lamlam, ma tongge na famfamu kere fan Juda, ri sa fespuek talo Festus ma ka seseng tifi ine fan tubiil ke Pol. ");
INSERT INTO hrw_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Ri gatom tikin ini Festus e samusu fabonti e fabur keri, ku tuleni e Pol ku la wina Jerusalem. Le, e sau mel e fagati ini riu keskum ma ri ku paketmeteni e Pol ulo sal. ");
INSERT INTO hrw_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Ma Festus ka koso aregii, “Pol ilo rerek ina Sisaria. Ma e tibi fuun e biing ma yau tibom ya ku la mil ina Sisaria. ");
INSERT INTO hrw_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Tafu e ti ton tongge na famfamu kemi ri ku mi nami yau. Ma le ku mel e ti tubiil ke kaltu gii, gam kamu la tafu ilo anganggon waleii.” ");
INSERT INTO hrw_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Biing Festus e sam la melmel tura ri lo e wal tam e tikii sangful na biing, i e la mil una Sisaria. Ma lo biing usi, Festus ka kiis ulo felun anganggon, ma ka tungen ri ini riu la onu e Pol. ");
INSERT INTO hrw_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Biing Pol e la puek, fan Juda gii ri ka ding tingna Jerusalem ri fatie liflifti, ma ri ka gow e fan warwar e mafet sak talo. Sakle e tek ti mok una fanangsi ini fan warwar keri e tikin. ");
INSERT INTO hrw_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Ma Pol e war fakale aregii, “Ya tibi gow e ti tubiil lo fafanau kere fan Juda, tam lo Felun Nining Bakir, tam lo Sisa.” ");
INSERT INTO hrw_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Sakle Festus e bura ini i eu fawetu e fabur kere fan Juda. Iya, ka gatmo e Pol, “Are ini, o bura ini yau la anganggon sing o ususi e fan warwar gii waleii ina Jerusalem?” ");
INSERT INTO hrw_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Sakle Pol e koso e sunwar kia aregii, “Gii ya titi ilo pikliu e fafanau ke Sisa. Ma e riis ini ou anganggon sing yau wagii. Ma o sau parfat kausi tikin ini ya tifik gow e ti tubiil lo re fan Juda. ");
INSERT INTO hrw_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Le ka mel e ti tubiil ya gow, ma ya kabuk gow e ti mok e fasi ini yau met fapakti, e kausi ini riu paketmet i yau. Sakle, le sunwar gii ri ka anganggon sing yau tura ka tibi tikin, e tek tikas e fasi una ta yau ilo limlimri. Ya bura ini Sisa tibom eu ongni e anganggon kiang.” ");
INSERT INTO hrw_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Festus e gongon famu singre fang kaonsiil kia ma ka war, “O bura sak ini Sisa, eu anganggon sing o arik, ou la usi e Sisa.” ");
INSERT INTO hrw_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Fam biing wimi king Agripa ma fefnelik Benis ru ka la fespuek una Sisaria, una la fanangsi e ninatke ke ru tife Festus. ");
INSERT INTO hrw_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Le ru melmel wa lo fam biing fuunfuun, Festus kau peteng tife king ine sunwar lo anganggon lo Pol, e war aregii, “E mel e neng e kaltu i gii wagii, Feliks e taufsok lo ilo rerek. ");
INSERT INTO hrw_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Biing ya la una Jerusalem, fam pris lamlam, ma tongge lamlam kere fan Juda, ri gow e fan warwar talo ma ri ka gatom yau una fabu-i aiya. ");
INSERT INTO hrw_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Ma ya ka koso singri aregii, ‘Lo ninis kemem na fan Rom e tibi fasi ini riu tow e ti mafet fofoes tife tikas. Kaltu eu bi ti famu na matre tongge gii ri ka tafu ilo anganggon, kubuk gow e ti sunwar una fakale lo ususi e fan warwar keri.’ ");
INSERT INTO hrw_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Biing fan Juda ri sa tiim tura yau, ya am tibi nene, safle lo biing usi ya la kiis ulo felun anganggon ma ya ka fauun ini riu la onu e kaltu a usi yau. ");
INSERT INTO hrw_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Biing tongge gii ri ka gow e fan warwar talo, ri fatie una gon, ri tibi otngi ine ti tubiil are fan tubiil gii ya ka sangsang usi. ");
INSERT INTO hrw_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","I mung la, ri su fatinge tura fan ninis lo fan sios keri ma tura neng e kaltu e sau met asow gii Yesus se Pol e peteng ini i e liuliu gii wa. ");
INSERT INTO hrw_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Ya bura ini yau sikseni e anwarow e sunwar gii, sakle ya tibi ten tibom; iya, ya kam gatmo ini le ku fasi ini i eu la ina Jerusalem ma ya kamu la anganggon singi waleii ususi e fan warwar gii. ");
INSERT INTO hrw_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Sakle Pol e peteng ini riu towfu ku melmel ilo rerek nene-i e Sisa e mu ongni e anganggon kia. Iya, ya kau fauun ini e sau melmel ilo rerek ku muut yau tuleni tife Sisa.” ");
INSERT INTO hrw_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Wimi Agripa ka peteng tife Festus aregii, “Ya bura ini yau tibom yau ong singi e kaltu a.” Festus ka koso aregii, “Arik, o mu sa ongni e fan warwar kia na biingbiing.” ");
INSERT INTO hrw_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Lo biing usi Agripa ma Benis ru los lo konona fam finaswen ke ru ma ru ka la kaulek ulo bala fel na fafagati tiim tura fan ofisa ma tongge lamlam tinglo siti a. Wimi Festus ka fauun ini riu la uun kaulek ine Pol. ");
INSERT INTO hrw_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Ma Festus ka war, “King Agripa ma tongge nano gii gam ka tiim tura kemem, gam sau pari e kaltu gii! Fan Juda nano ri sa gatom yau usi, una Jerusalem ma wagii na Sisaria, ma ri ka tautau ini, i e tibi fasi una bi melmel, e samusu met. ");
INSERT INTO hrw_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Ya tibi sikseni e ti mok e gow gii ka fasi ini eu met somu, safle anwarow i tibom e gow e gatgatom kia ini Sisa eu ikseni, iya, ya kam sangsang ini yau tuleni ku la ina Rom. ");
INSERT INTO hrw_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Safle e tek ti sunwar ek ten i sing yau ini ya ku seti tife Sisa. Ma gii ya ka tow e kaltu gii tifo king Agripa, ma tif gam nano, usi eu mel e ti sunwar una seti ilo pas, ususi e faikse gii. ");
INSERT INTO hrw_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Ya pari ini e tibi riis, le ya ku tuleni e ti kaltu rerek, ma ya ka tibi tuleni ming e ti sunwar una peteng ten ine mok ri ikseni tura.” ");
INSERT INTO hrw_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Kala Agripa ka war singe Pol, “Ya a-uu lo o una war lo o tibom.” Pol e akteni e limow tifri ma ka tofnge una war fakale lo i tibom, ");
INSERT INTO hrw_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“King Agripa, ya bur fakale lo sunwar gii fan Juda ri ka gow talo yau, ma ya sang ini e kausi tikin ini yau sesuupuek ine sunwar kiang tifo. ");
INSERT INTO hrw_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Ma eu ngo aiya anwarow o parfat pauti e fan ninis ma fang gatgatom kere fan Juda gii ri ka tapot ka u lo ri lo, aregii, ya ka gatom o ini e fasi ini ou ong kausi sing yau? ");
INSERT INTO hrw_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Fan mara Juda ri parfat lo melmel kiang tinglo biing ya ta ya na bo-i uwa, tinglo tofnge lo melmel kiang ulo keng kaontri tibom ma una Jerusalem ming. ");
INSERT INTO hrw_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Ri sau parfat lo yau tingwa ma le ring gi bura, ri fasi una sesuupuek i yau, ini ya melmel are Farasi tikin, ususi e fan ninis rawas kemem, safle ri guuluung. ");
INSERT INTO hrw_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Ma gii ya ka ti ilo anganggon anwarow lo titinge ya mel lo, ilo warkale gii Deo e sam gow tife fan tumtumlamem. ");
INSERT INTO hrw_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Warkale gii tikii sangful ma e u na matambia kerer, ri ka nene i ini eu fasef lo biing ri nining lo fan siat ma fam panambiing singe Deo. King, titinge mung gii, iya fan Juda ri ka ikse yau tura. ");
INSERT INTO hrw_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Anwarow lo sa gii, ka tuntun tibom sing gam una titinge ini Deo e fasi una famtete kaltu tinglo minet? ");
INSERT INTO hrw_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“E tikin, yau tibou ming ya sangfi ini ya samusu gow e fan mok fuunfuun una bero ine asow e Yesus, tingna Nasaret. ");
INSERT INTO hrw_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Ma i e mok mung gii ya gow una Jerusalem. Ya kepe war a-uu singre fam pris lamlam ma ya ka tauf re tongge ke Deo ulo rerek. Ma ya ka a-uu lo re tongge una paketmet iri. ");
INSERT INTO hrw_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Fam biing fuunfuun, ya la ulo bala fam felun nining una tow e mafet tifri ma ya ka tofo una tungen ri una fotpursi e Yesus. Ya sik iri ulo fan taon i tapak ming una bero iri, anwarow lo balasak kiang. ");
INSERT INTO hrw_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Lo neng lo re fam fines gii, fam pris lamlam ri tow e war a-uu tif yau ma ri ka tule yau una la ulo taon Damaskus. ");
INSERT INTO hrw_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Fatfatat lo siat tuntun, king, lo biing ya fes lala ulo sal, ya pari e anten e sosok ten tikin ine pisii e la tinglo balambat, ka sa furat liflifit yau tura fan taltalung. ");
INSERT INTO hrw_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Kemem nano kem tiin luut ulo nal ma ya ka ongni e angkiimkiim e gon sing yau lo kinen Ibru, ‘Sol, Sol, e tamu o ka berbero i yau? O bou pete ongker i o una kik mil ine kek sung kalut.’ ");
INSERT INTO hrw_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","“Wimi ya ka gatom, ‘Kaltu Bakir, o se?’ “Taufi ka koso, ‘Yau, Yesus a o ka berbero ini. ");
INSERT INTO hrw_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Safle gii, matet o ku ti ine ung kekem, ya sau puek talo o una siik o are kaltu na mus kiang ma are kaltu una sesuupuek ine sa o sau pari lo yau ma sa ya amu fanangsi o ini. ");
INSERT INTO hrw_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Yau faliunge o tinglo lim re tongge lo o tibom ma singre fan Jentael. Yau tule o usi ri, ");
INSERT INTO hrw_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","una ipki e matmat ri ma kep ri tinglo anor use anten ma tinglo rawas ke satan, use Deo, usi ini ya ku fasi una sangintafngi e fan tubiil keri ma ri ku kepe e as bakir tura re tongge a ya kabuk fatarawennge ri tikin lo titinge keri lo yau.’ ");
INSERT INTO hrw_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“I lea king Agripa, ya tibi onguf singe mok e ngo are numbiil tinglo balambat. ");
INSERT INTO hrw_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Baba tikii, ya sesngeni e sunwar tifre fa tingna Damaskus, kala tifre fa tingna Jerusalem ma una Judia kiruur, ma ming, tifre fan Jentael. Ya fabenge ini ri samusu iksi e sinsinangu ri kosnge fan sinang saksak, ma ri ku mil use Deo, ma ri ku fanangsi ini ri sam sangikis lo konona fan sinang riu gow. ");
INSERT INTO hrw_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Sunwar gii, e ta anwarow a, fan Juda ri ka bingfamti yau ulo bala pakanmale lo Felun Nining bakir ma ri ka bala paketmet i yau. ");
INSERT INTO hrw_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Safle ya sam kepe e faules ke Deo ka la muut geinggii, iya ya ka ti gii una peteng suupuek tifre tongge e tek ti asri ma fa e mel e asasri ming. Ya tibi sesngeni e ti sunwar kuriik, ya su sesngeni e sunwar fam profet ma Moses ri sau peteng ini eu fespuek. ");
INSERT INTO hrw_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Sunwar a, e peteng aregii, Kristus eu kepe ongker ma ku ta kaltu baba tikii una matet mil kosnge minet. I eu sesngeni e anten tifre tongge kia tibom ma tifre fan Jentael.” ");
INSERT INTO hrw_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Lo sumbiing a sekit, Festus e barang singi aregii, “Pol! O lomba, o ropo e mara fabenge lamlam ma parfat kiam ka gorot o, o ka lomba.” ");
INSERT INTO hrw_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Ma Pol ka war aregii, “Kaltu Bakir Festus, ya tibi lomba, sa ya peteng ini e tikin ma e mel e anwarow. ");
INSERT INTO hrw_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","O ten use fan mok gii, iya ya ka tibi soke una sa seseng tifo ini. Ya parfat ini e tek ti mok sekit ek fifinuf iyo, anwarow ri tibi gow e fan mok gii ulo ti am pitpitam balo. ");
INSERT INTO hrw_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","King Agripa, o titinge ming lo re fam profet? Ya parfat ini o titinge.” ");
INSERT INTO hrw_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Kala Agripa ka gatmo e Pol aregii, “O sangfi ini lo sumbiing pospos gii, o fasi una gau yau, ya ku puek are ti kristien?” ");
INSERT INTO hrw_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Ma Pol ka koso e sunwar kia aregii, “Le biing ka pospos tam ka tapak, ya nining singe Deo ini eu tibi ta o tibom safle ini eu ta o tiim tura tongge nano gii ri ka ongni e fan warwar kiang geinggii, una puek are yau, safle ya tibi bura ini riu rekfamti gam ine fan sen.” ");
INSERT INTO hrw_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Ma king ka matet tiim tura gawana ma Benis ma tongge a, ri ka kiiskiis tura ri. ");
INSERT INTO hrw_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Biing ri la tinglo keptim fel a, ri ka fafagon falifu iri, ri ka war, “Kaltu gii e tibi gow e ti mok a ka fasi ini riu paketmet ini, tam riu taufu ilo rerek.” ");
INSERT INTO hrw_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Ma Agripa ka war singe Festus aregii, “Kaltu gii e fasi ini ong gi sam taufu ek la. Safle i tibom e bou bura ini Sisa eu ong lo anganggon kia.” ");
INSERT INTO hrw_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Biing ri sau fagati ini e ta biing kemem una la wina Itali, ri tow e Pol tura fa lo re tongge tinglo rerek ka la tife neng e ofisa, asow gii Julius. I e ta tinglo galun soldia ke Sisa. ");
INSERT INTO hrw_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Kemem ka kau lo neng e sip tingna Adrimatia e rong una la masa lala ulo fan taon ilo prowins ina Eisia. Aristakus, se e ta kaltu tingna Teselonaika ilo prowins Masedonia, i ming tura kemem. ");
INSERT INTO hrw_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Biing usi, kemeu masa una Saidon ma Julius ka gow e konona sinang lo Pol. I e a-uu lo una la pari e fan taltalu usi ini ri ku la fawetu e fam fabur kia. ");
INSERT INTO hrw_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Ting wa, kemem ka matet mil kemem ka la ma kif bakir ka tonge kemem, iya sip ka filau ka la ulo mok e patep una Saiprus. ");
INSERT INTO hrw_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Biing kemem sam kaupakti e sung kasap tinglo prowins Silisia ma Pamfilia, kemem sa masa una Mira ilo prowins Lisia. ");
INSERT INTO hrw_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Uwa, ofisa e pari e sip tingna Aleksendria e rong una la una Itali, i ka uun kemem, kem ka kau ulo. ");
INSERT INTO hrw_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Kemeu filau fatatu e taon ina Kinidus, safle e ta tanga biing i kemem una su filfilau balbalik lala, anwarow kif e bakir tikin. Rawas lo kif a e gow gii kemem ka tibi fasi una usi e sal ke sip, iya kemem ka su filau paket una Salmon una la patep lo galu e malmal lo bit ina Krit. ");
INSERT INTO hrw_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Kemem su babet lala kala ka muut kemem la puek ulo male ri fotngi ini, Konona Mok una Patpatep, fatatu e taon Lasi, le e mel e angkif ma panaf bakir. ");
INSERT INTO hrw_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Fam biing fuunfuun tikin e sam la, ma balang kasap kabuk la sak sekit, anwarow gii, e sam ta wimi ine Biing na Fel. Iya, Pol ka war singri aregii, ");
INSERT INTO hrw_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Tanga kaltu, tinuut kiar ting wagii, e par areini kiar u tupngeni e biingsak, eu bero ine fan inwit ma sip ma eu bero ming ine fan ninliu kiar.” ");
INSERT INTO hrw_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Safle ofisa e am tibi usi e fabur ma parpar ke Pol, e su usi e fabur ke kepten lo sip ma tamow e sip. ");
INSERT INTO hrw_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Anwarow Konona Mok una Patpatep e tibi patep le e ta biing lo anmair lo biing angkif e ikis. Iya, tongge fuunfuun ulo sip ri fawar tiim ini kemem samusu la tingwa, ri titinge ini kemem u la patep ine anmair ina Finiks. E ta pakanimbui ilo galu isuu lo bit ina Krit ma e parpar wisif. ");
INSERT INTO hrw_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Biing borong kif e la ting isuu e puek, ri ka sangfi ini ri fasi una kulfi e sinangu ri. Iya, ri ka tatfe kanek ine angga ma ri ka babet lala tingna Krit. ");
INSERT INTO hrw_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Safle e tibi su baf ma ka kif bakir. Kif a ri fotngi ini taube, e kif pu tinglo galu isuu lo bit ina Krit. ");
INSERT INTO hrw_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Sip ka tongeni e kirai bakir tikin ma e am tibi fasi una filau sangeni, iya sip kabuk su tata singi ka la. ");
INSERT INTO hrw_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Biing kemem sam la filau ulo mok e patep ulo neng e boron bit asow gii Kauda, kemem tibi fasi una kawe famti e borom buut tinglo sip. ");
INSERT INTO hrw_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Biing fam boskuru lo sip ri sam sek kanek ini talo bala sip, ri lifti ming e sip ine fam finfinau una kawe famti e sip ku rawas. Ri soke ming are ri ka filau ma ri ka la kiis sok ilo poktow e pos fatatu e Afrika. Ri ka tatfe pu ine sel ma ri ka towfu e angkif ka basbas lala ine sip. ");
INSERT INTO hrw_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Kirai a e pose falek sekit ine sip, iya biing usi ri ka tofnge una rarang pu ini e fan inwit tinglo sip. ");
INSERT INTO hrw_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Ma lo biing baba e tuul ri tibom ri rarang pu ine fan sel ma mas tinglo sip. ");
INSERT INTO hrw_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Lo fam biing fuunfuun kemem tibi pari e pisii ma fang keltot, ma kif ka su bakbakir lala, iya kemem kam tibi la titinge ini kemem u liu. ");
INSERT INTO hrw_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Wimi ire tongge ri sau biis tapak, Pol ka ti u famu iri ma ka war, “Tanga kaltu, le gam gi sam su ong sing yau una tibi tuut tingna Krit, gam gi am tibi tupngeni e mafet gii ma ini sip ku maut tura fan mok. ");
INSERT INTO hrw_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Safle gii, yau peteng tif gam ini gam u balamas, anwarow e tek tikas lo gam eu tam ini, sakle sip eu maut. ");
INSERT INTO hrw_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Lo panambiing neng e anggelo ke Deo, se a ya ka nining lo e sa ti unais yau, ");
INSERT INTO hrw_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","ma ka war, ‘Pol ou tibi soke, o samusu la ti lo anganggon na mata e Sisa. Deo e sam tafu tifo e tongge nano a ka ta tura o ilo sip.’ ");
INSERT INTO hrw_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Ilea, gam u tibi soke, anwarow ya titinge lo Deo ini fan mok gii eu fuut mung aregii i kabuk peteng tif yau. ");
INSERT INTO hrw_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Safle kiar u su towfu e sip, kif ku kepe ku la bas masa ini ilo ti bit.” ");
INSERT INTO hrw_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Lo panambiing baba tikii sangful ma e fet, kemeu bokbok lala uwa ulo sung kasap Adria. E ngo are palim e biing ma ka bas na fo re fam boskuru ini kem sau puek fatat una kiin. ");
INSERT INTO hrw_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Ri baspu ini e amfinau una ngafu e maut lo kasap ma ri ka sikseni ini maut lo e ta e tuul e sangful ma e fis na ngaf. Kala babaf balik ri ka tofo mil, safle e maut uwa. E ta e u e sangful ma e fis na ngaf. ");
INSERT INTO hrw_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Anwarow ri soke ini sip eu la tuke papaki ulo fatfat, ri ka baspu ine e fet e angga tinglo miu, ma ri ka nining singe Deo ini eu siat. ");
INSERT INTO hrw_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Fam boskuru ri ka sik ine ti sal una fin kosnge sip. Ri ka fauli e buut tinglo sip ka ding una kasap ma ri ka sorom ini ri bala baspu ine ton angga tinglo matow. ");
INSERT INTO hrw_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Kala Pol ka war singe ofisa ma fan soldia kia aregii, “Le fam boskuru gii ri ku tam iri tinglo sip, gam u tibi fasi una liu.” ");
INSERT INTO hrw_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Iya, fan soldia ri ka tese pakti e finfinau ri kawe famti e buut ini ma ri ka towfu ka luut ka la. ");
INSERT INTO hrw_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Famu ma pisii kamu fen, Pol ka faraungeri una en, ma ka war aregii, “Lo tikii sangful ma e fet na biing gam su sangsang fuunfuun lala, anwarow gam tibi parfat ini sa eu fuut lo gam. Gam tibi en ti tuan sekit, gam su melmel lala. ");
INSERT INTO hrw_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Gii ya bura ini gam u en ti tuan una farawasnge gam. Eu tek ti ansian olow e tikas lo gam eu tam ini tinglo paklu.” ");
INSERT INTO hrw_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Wimi ini e war aregii, i e kepe e beret ma ka aro singe Deo u famu iri nano. Ka paek paki e beret ma kam tofnge una en. ");
INSERT INTO hrw_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Tongge nano ri ka balamas ma ri ka tiin en fan tuan una ules ri. ");
INSERT INTO hrw_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Kemem na tongge nano ulo bala sip a, e ta e u e atis ma e fis e sangful ma e on na kaltu nano. ");
INSERT INTO hrw_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Biing ri sam en ri kabuk la sut, ri kam rarang nano a ine fan wit una kasap usi sip eu baof. ");
INSERT INTO hrw_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Biing e la siat, ri tibi ilmi e male, safle ri pari e pakanimbui e mel e angkiin ulo. Iya, ri ka sangsang una filaungeni e sip ku masa ulo, le ri ku fasi. ");
INSERT INTO hrw_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Ri tese pakti e fan angga ka ngo sok una kasap ma ri ka pikufu e fam finau tinglo sitia ma ri ka fafenngeni e sel tife kif ma ri ka filau masa wina kiin. ");
INSERT INTO hrw_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Sakle sip e la kiis sok ulo pokta pos. Matow e la kiis tuke ulo angkiin ka tibi fasi una se ma panaf ka pose papaki e miu ka la bereng falek. ");
INSERT INTO hrw_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Fan soldia ri fagati una paketmet ire tongge ilo rerek una fakale lo ri, are ri ka kakes masa ma ri ka fin. ");
INSERT INTO hrw_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Sakle ofisa kere fan soldia e bura ini eu faliungeni e Pol, ka fakale lo ri una fawetu e fagati keri. I ka un re fa a ri ka fasi una kakes ini riu of pu famu ri ku kakes masa wina kiin. ");
INSERT INTO hrw_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Ma fa riu tem lo fan susum palang ma fan susu lo sip ri ku kakes masa lo. Ri usi e sunwar ke ofisa ma ri nano ka la masa kausi una kiin. ");
INSERT INTO hrw_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Kemem am la parfat ini bit a ri fotngi ini Malta lo biing kemem sam la masa kausi una kiin. ");
INSERT INTO hrw_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Tongge tinglo male a ri fatfenngo kausi tikin lo kemem. Ri ka gow e iif ma ri ka uun kemem nano una mingii, anwarow bat e luut ma ka mair e male. ");
INSERT INTO hrw_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Pol ka sele tiim ini e fan susung kalut ma biing e tow ulo iif, sii ka ongni e antuntun, ka of suu ka kita e limow e Pol. ");
INSERT INTO hrw_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Biing tongge tinglo male ri pari e sii e kita e limow e Pol, ri ka fawar faliu iri, “Kaltu gii ngan, e ta kaltu na pakpaketmet ire tongge. E tikin ini e tibi met una kasap, safle gii i eu kepe e fimfiil lo sa e sam gow ma ku tibi liu.” ");
INSERT INTO hrw_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Safle Pol e sageufu e sii a talo bala iif, ma e tek ti mok ek fuut lo. ");
INSERT INTO hrw_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Ri parpar ini fow e Pol eu ing tam ini enggi luut ek met, safle biing ri sam nene winangen ma ri ka tibi par ti mok ek fuut lo Pol, ri iksi e sinsinangu ri ma ri ka peteng ini i, e ta neng e deo ming. ");
INSERT INTO hrw_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","E mel e neng e sunal kemem sa masa u fatatu, e ta ke Pabilius, kaltu bakir tinglo bit a. I e are kemem ma ka uun kemem, ka la efe kausi tikin lo kemem ka muut lo e tuul e biing. ");
INSERT INTO hrw_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Tamow e Pabilius e ngongo ulo ngiin. I e mase, e bokor ma e balsel ine dadak. Pol ka kau usi ka nining, ma ka tow e limow ulo, ka faliungeni. ");
INSERT INTO hrw_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Biing mok gii e fuut, tongge nano ri mase ulo bit a, ri puek ma Pol ka faliunge ri. ");
INSERT INTO hrw_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Ri matlawen matmem lo mara galgalun sal, ma biing kemeu bala la kosing ri, ri sengi e bala sip ine mara mok kemeu pospos usi. ");
INSERT INTO hrw_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Wimi ine e tuul e funiil, kemem kepe e sip tingna Aleksendria kemem ka la lo. Sip a, ri poksenge e deo kasang, Kasta ma Poluks ulo matow. I e patep lo kif bakir ulo e bit a. ");
INSERT INTO hrw_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Kemeu masa ulo taon Sirakus, kemem ka melmel wa lo e tuul e biing. ");
INSERT INTO hrw_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Ting wa kemem ka matet kemem ka la puek ulo taon Rejium. Biing usi famang ka matet ma lo biing e tuul kem ka la masa ulo taon Puteoli. ");
INSERT INTO hrw_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Ulo bala taon a, kemem tonge re fa lo re tongge na titinge, ma ri ka gatom kemem una melmel tura ri lo tikii wik ma wimi kemem kam la una Rom. ");
INSERT INTO hrw_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Tongge na titinge uwa, ri sam ong ini kemem bala puek, ma ri ka fes tapak tingna Rom ka sa muut ulo male na umat Apius ma una Tri Tawens una sa tonge kemem. Biing Pol e pari e tongge gii, i e katfarsi e Deo ma ka kepe mil e rawas. ");
INSERT INTO hrw_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Biing kemem la puek una Rom, gawana e a-uu ini Pol eu bom la melmel ma eu su tikii ti soldia eu efefe lo. ");
INSERT INTO hrw_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","E tuul e biing wimi, Pol ka tau tiim ine ge lamlam kere fan Juda. Biing ri sam sa tiim, Pol e war singri, “Tanga tuaklik, ya tibi gow e ti tubiil lo re tongge kiar, tam lo ninis kere tumtumlarer, sakle ri bingfamti yau una Jerusalem ma ri ka ta yau tifre tongge tingna Rom. ");
INSERT INTO hrw_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Ri ka ikse yau ma ri ka bur falimuf yau, anwarow ya tibi tubiil lo ti mok ku fasi ini yau met. ");
INSERT INTO hrw_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Sakle biing fan Juda ri tibi bura ini riu falimuf yau, e am tek ti sal kiang ming, gii ya ka gatom ini Sisa eu ongni e anganggon kiang. E tibi ta ini ya bur touf re tongge kiang ilo anganggon. ");
INSERT INTO hrw_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Iye fan sangsang gii, e ta anwarow gii ya ka gatom una par gam ma una gongon tiim tura gam. Ma anwarow gii ri ka rek famti yau ine sen, e ta nafow e se gii fan Israel ri ka fanene lo.” ");
INSERT INTO hrw_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Ri ka koso aregii, “Kemem tibi kepe ti pas tingna Judia ini rik peteng fate iyo, ma e tek tikas lo re fan tualikmem ting waleii ek sa peteng, tam ek sa seseng ine ti mok e sak o gow, tif kemem. ");
INSERT INTO hrw_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Sakle keu bur ong lo fam parpar kiam, le kemeu parfat ini tongge nano ri ngos lo fotpursi e galung kaltu fuu a, kam su puek falifu i kiar na fan Juda.” ");
INSERT INTO hrw_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Ri fagati e neng e biing tura ini riu sa tupngeni e Pol ulo male e melmel ilo. Singmat na galung kaltu ri puek usi. Tinglo biingbiing ka la muut lo efef, i e ti ulo fafanau ke Moses ma fan warwar kere fam profet, ka fabenge ma ka peteng ten tifri ine sunwar lo Kepmale ke Deo, ma ka tofo una tatfeni e sinsinangu ri use Yesus. ");
INSERT INTO hrw_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Fa lo ri, ri titinge lo sunwar kia, safle fa ri tibi titinge. ");
INSERT INTO hrw_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Ri fasonge faliu iri ma ri ka tofnge una fes falek, wimi ine Pol e sam war aregii singri, “Tangwa Riis e peteng tikin tifre tuptup mi, biing i e war ulo ngusu e profet Aisaiya: ");
INSERT INTO hrw_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","‘La usi re tongge gii, o ku la peteng tifri aregii, “Gam u la met na ongongni e sunwar, safle gam u tibi ten usi. Gam u la met na parpari, safle gam u tibi parfailmi” ");
INSERT INTO hrw_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Anwarow tongge gii, balbalri e kut, ri am tibi fasi una ong ine balbaluri, ma ri sau fakuta e matmat ri, ma le enggi tam, ring gi par ine matmat ri, ma rik ong ine balbaluri, ma sinsinangu ri ek ten ma rik ikis mil usi yau, ma ya ku faliungeri.’ ");
INSERT INTO hrw_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","“Iya ya ka bura ini gam u parfat ini faliunge ke Deo, ri sam tuleni usi re fan Jentael, anwarow ri, riu ong.” ");
INSERT INTO hrw_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Biing i e war ine sunwar gii, fan Juda ri bes falek tura singmat na fatinge una balri tibom. ");
INSERT INTO hrw_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Lo e u e matamfaim kiruur, Pol e melmel ulo neng e fel ma ka towtow e fimfiil lo tife tamow e fel a, usi ini i eu fasi una melmel ilo. I e arare re tongge nano a ri ka pupuek una sa pari. ");
INSERT INTO hrw_vpl VALUES ("AC28_31","074_28_31","ACT","28","31