﻿USE sofia;
DROP TABLE IF EXISTS sofia.hrvbib_vpl;
CREATE TABLE hrvbib_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES hrvbib_vpl WRITE;
INSERT INTO hrvbib_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ovo je rodoslovlje Isusa Krista, potomka kralja Davida koji je bio Abrahamov potomak. ");
INSERT INTO hrvbib_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abrahamu se rodio Izak. Izaku se rodio Jakov. Jakovu su se rodili Juda i njegova braća. ");
INSERT INTO hrvbib_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judi je Tamara rodila Peresa i Zeraha. Peresu se rodio Hesron, a Hesronu Ram. ");
INSERT INTO hrvbib_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ramu se rodi Aminadab. Aminadabu se rodi Nahšon, a Nahšonu Salma. ");
INSERT INTO hrvbib_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmi je Rahaba rodila Boaza. Boazu je Ruta rodila Obeda. Obedu se rodio Jišaj. ");
INSERT INTO hrvbib_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jišaju se rodio kralj David. Davidu je bivša Urijina žena rodila Salomona. ");
INSERT INTO hrvbib_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomonu se rodio Roboam. Roboamu se rodio Abija. Abiji se rodio Asa. ");
INSERT INTO hrvbib_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asi se rodio Jozafat. Jozafatu se rodio Joram, a Joramu Ahazja. ");
INSERT INTO hrvbib_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ahazji se rodio Jotam, Jotamu Ahaz, a Ahazu Ezekija. ");
INSERT INTO hrvbib_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezekiji se rodio Manaše, Manašeu Amon. Amonu se rodio Jošija. ");
INSERT INTO hrvbib_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Jošiji su se, u vrijeme progonstva u Babilon, rodili Jehonija i njegova braća. ");
INSERT INTO hrvbib_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Poslije progonstva u Babilon Jehoniji se rodio Šealtiel. Šealtielu se rodio Zerubabel. ");
INSERT INTO hrvbib_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubabelu se rodio Abiud. Abiudu se rodio Elijakim, a Elijakimu Azor. ");
INSERT INTO hrvbib_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azoru se rodio Sadok. Sadoku se rodio Akim, a Akimu Elijud. ");
INSERT INTO hrvbib_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Elijudu se rodio Eleazar. Eleazaru Matan, a Matanu Jakov. ");
INSERT INTO hrvbib_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jakovu se rodio Josip, muž Marije koja je rodila Isusa zvanoga Krist. ");
INSERT INTO hrvbib_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","To je, dakle, ukupno četrnaest naraštaja od Abrahama do kralja Davida, četrnaest naraštaja od kralja Davida do progonstva u Babilon i četrnaest naraštaja od progonstva do Krista. ");
INSERT INTO hrvbib_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Evo kako se zbilo rođenje Isusa Krista: Njegova majka Marija bila je zaručena s Josipom. Ali dok je još bila djevica, začela je po Svetome Duhu. ");
INSERT INTO hrvbib_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Kako je njezin muž Josip bio pravedan čovjek i kako ju nije htio javno osramotiti, naumi ju potajice napustiti. ");
INSERT INTO hrvbib_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Razmišljajući o tome, zaspao je te mu se u snu ukaže Božji glasnik. “Josipe, sine Davidov,” reče mu on, “ne oklijevaj uzeti Mariju za ženu! Jer dijete koje nosi začeto je po Svetome Duhu. ");
INSERT INTO hrvbib_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ona će roditi sina i nazvat ćeš ga Isus (što znači: ‘Gospodin spasava’) jer će spasiti svoj narod od njegovih grijeha.” ");
INSERT INTO hrvbib_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Sve se to dogodilo da bi se obistinilo što je Gospodin rekao po proroku: ");
INSERT INTO hrvbib_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Slušajte! Djevica će zanijeti! Rodit će sina koji će se zvati Emanuel”, (što znači: “Bog je s nama”). ");
INSERT INTO hrvbib_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Kad se Josip probudio, učini kako mu je Božji glasnik zapovjedio—dovede Mariju svojoj kući da mu bude žena. ");
INSERT INTO hrvbib_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Nije joj prišao kao muškarac dok nije rodila sina. A onda mu nadjene ime Isus. ");
INSERT INTO hrvbib_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Isus se rodio u gradu Betlehemu u Judeji za vladavine kralja Heroda. U to vrijeme neki mudraci s Istoka stignu u Jeruzalem ");
INSERT INTO hrvbib_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","i stanu se raspitivati: “Gdje je taj novorođeni kralj Židova? Vidjeli smo njegovu zvijezdu na istoku pa smo mu se došli pokloniti.” ");
INSERT INTO hrvbib_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","To veoma uznemiri kralja Heroda, a i sav Jeruzalem. ");
INSERT INTO hrvbib_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Kralj sazove svećeničke poglavare i pismoznance da se raspita gdje se Krist treba roditi. ");
INSERT INTO hrvbib_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","“U Betlehemu u Judeji”, odgovore mu, “jer je prorok napisao: ");
INSERT INTO hrvbib_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Betleheme, ti nisi samo nevažno judejsko selo, jer će iz tebe poteći vladar koji će voditi moj narod, Izrael.’” ");
INSERT INTO hrvbib_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Tada Herod potajno pošalje po mudrace da od njih dozna vrijeme pojavka zvijezde. ");
INSERT INTO hrvbib_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Zatim ih pošalje u Betlehem: “Pođite i pomnjivo se raspitajte za dijete. Kad ga pronađete, vratite se i javite mi da mu se i ja pođem pokloniti.” ");
INSERT INTO hrvbib_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Poslušali su kralja i pošli. I gle! Zvijezda koju su vidjeli da izlazi išla je pred njima sve dok se nije zaustavila iznad mjesta gdje se nalazilo dijete. ");
INSERT INTO hrvbib_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Kad su ju ugledali, silno su se razveselili. ");
INSERT INTO hrvbib_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Uđu u kuću i ugledaju dijete s njegovom majkom Marijom te padnu ničice i poklone mu se. Zatim otvore škrinje s blagom i daruju mu zlato, tamjan i smirnu. ");
INSERT INTO hrvbib_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Poslije toga su u snu dobili upute da se ne vraćaju k Herodu, te su se u svoju zemlju vratili drugim putem. ");
INSERT INTO hrvbib_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Kad su otišli, anđeo se Gospodnji ukaže u snu Josipu. “Ustani i bježi u Egipat s djetetom i s njegovom majkom”, reče anđeo, “i ostani ondje sve dok ti ne kažem da se vratiš jer će kralj Herod tražiti dijete da ga ubije.” ");
INSERT INTO hrvbib_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Josip ustane i još se iste noći zaputi u Egipat s Marijom i djetetom. ");
INSERT INTO hrvbib_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ostao je ondje sve do Herodove smrti. Time se ispunilo što je Gospodin rekao preko proroka: “Pozvao sam svojega sina iz Egipta.” ");
INSERT INTO hrvbib_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Kad uvidi da su ga mudraci izigrali, Herod se silno razgnjevi i pošalje vojnike da u Betlehemu i po svoj okolici pobiju sve dječake od dvije godine i mlađe, prema vremenu izlaska zvijezde za koje se raspitao u mudraca. ");
INSERT INTO hrvbib_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Tada se ispunilo ono što je rekao prorok Jeremija: ");
INSERT INTO hrvbib_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“U Rami se čuje glas, zapomaganje i gorak plač; to Rahela oplakuje svoju djecu i ne dade se utješiti jer ih više nema.” ");
INSERT INTO hrvbib_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Kad je Herod umro, u Egiptu se anđeo Gospodnji ukaže Josipu u snu ");
INSERT INTO hrvbib_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","i reče mu: “Ustani i povedi dijete i njegovu majku natrag u izraelsku zemlju, jer su oni koji su ga pokušavali ubiti mrtvi.” ");
INSERT INTO hrvbib_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","On ustane, uzme dijete i majku i vrati se u Izrael. ");
INSERT INTO hrvbib_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Putem dozna da je novim kraljem postao Arhelaj, Herodov sin, pa se prestraši. Tada i u snu dobije upozorenje da ne ide u Judeju, te umjesto toga ode u Galileju ");
INSERT INTO hrvbib_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","i nastani se u Nazaretu. Time se ispunilo što su o Mesiji napisali proroci: “Zvat će se Nazarećanin.” ");
INSERT INTO hrvbib_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","U to vrijeme Ivan Krstitelj počne propovijedati u judejskoj pustinji: ");
INSERT INTO hrvbib_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Pokajte se za grijehe i obratite se Bogu jer je nebesko kraljevstvo blizu!” ");
INSERT INTO hrvbib_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Prorok Izaija govorio je o Ivanu kad je prorokovao: “On je glas koji viče u pustinji: ‘Pripremite put za Gospodnji dolazak! Poravnajte za njega staze!’” ");
INSERT INTO hrvbib_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ivanova odjeća bila je istkana od devine dlake, a bio je opasan kožnim pojasom. Hranio se skakavcima i divljim medom. ");
INSERT INTO hrvbib_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ljudi su k njemu dolazili iz Jeruzalema i iz cijele jordanske okolice. ");
INSERT INTO hrvbib_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ispovijedali su mu svoje grijehe, a on ih je krstio u rijeci Jordanu. ");
INSERT INTO hrvbib_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ali kad ugleda mnoge farizeje i saduceje da se dolaze krstiti, reče im: “Zmijska legla! Tko li vas je samo upozorio da pobjegnete Božjemu gnjevu koji stiže? ");
INSERT INTO hrvbib_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Dokažite svojim životom i djelima da ste se odvratili od grijeha i obratili Bogu. ");
INSERT INTO hrvbib_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ne zavaravajte se da vam je dovoljno reći: ‘Mi smo Abrahamovi potomci!’ jer vam kažem da Bog može i od ovoga kamenja podignuti Abrahamovu djecu! ");
INSERT INTO hrvbib_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Sjekira Božjeg suda već je uzdignuta da u korijenu sasiječe stabla. Svako stablo koje ne daje dobrog roda bit će posječeno i bačeno u vatru. ");
INSERT INTO hrvbib_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ja vodom krstim one koji se pokaju od svojih grijeha; no dolazi netko veći od mene, toliko velik da mu ja nisam dostojan ni robom biti. On će vas krstiti Svetim Duhom i ognjem. ");
INSERT INTO hrvbib_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Očistit će svoje gumno i odvojiti pljevu od pšenice; pšenicu će spremiti u svoju žitnicu, a pljevu sažeći neugasivim ognjem.” ");
INSERT INTO hrvbib_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Tada Isus dođe iz Galileje na Jordan da ga Ivan krsti. ");
INSERT INTO hrvbib_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ivan ga je odvraćao. “Zar da ti dođeš k meni,” reče mu, “a zapravo bi ti mene trebao krstiti!” ");
INSERT INTO hrvbib_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ali Isus mu odgovori: “Pusti to, jer nam valja ispuniti pravednu Božju volju.” Tada ga je Ivan krstio. ");
INSERT INTO hrvbib_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Nakon krštenja Isus iziđe iz vode. I gle! Nebesa se otvore i on ugleda Božjega Duha kako silazi kao golub i spušta se na njega. ");
INSERT INTO hrvbib_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Začuje se glas:: “Ovo je moj ljubljeni Sin. On je moja radost!” ");
INSERT INTO hrvbib_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Zatim Sveti Duh odvede Isusa u pustinju da ga ondje kuša đavao. ");
INSERT INTO hrvbib_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ništa nije jeo četrdeset dana i četrdeset noći pa je nakon toga vrlo ogladnio. ");
INSERT INTO hrvbib_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Tada mu pristupi napasnik i reče mu: “Ako si Božji Sin, reci da ovo kamenje postane kruhom.” ");
INSERT INTO hrvbib_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ali Isus mu odgovori: “U Svetome pismu piše: ‘Ne živi čovjek samo o kruhu, već i o svakoj riječi što izlazi iz Božjih usta.’” ");
INSERT INTO hrvbib_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Tada ga đavao odvede u Sveti grad, na vrh Hrama ");
INSERT INTO hrvbib_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","i reče: “Ako si Božji Sin, skoči! Jer Sveto pismo kaže: ‘On zapovijeda svojim anđelima za tebe’ i ‘oni će te svojim rukama zadržati da ni nogom o kamen ne udariš.’” ");
INSERT INTO hrvbib_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Isus mu odgovori: “Sveto pismo također kaže: ‘Ne iskušavaj Gospodina Boga svojega!’” ");
INSERT INTO hrvbib_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Đavao ga zatim povede na vrh vrlo visoke gore te mu pokaže sve narode svijeta i svu njihovu slavu. ");
INSERT INTO hrvbib_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","“Sve ću ti ovo dati”, reče mu, “ako mi se ničice pokloniš!” ");
INSERT INTO hrvbib_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","“Odlazi, Sotono!” reče mu Isus. “U Svetome pismu piše: ‘Klanjaj se samo Bogu i njemu jedinome služi!’” ");
INSERT INTO hrvbib_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Tada đavao ode, a dođu mu služiti anđeli. ");
INSERT INTO hrvbib_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Kad je Isus čuo da su Ivana zatvorili, povuče se u Galileju. ");
INSERT INTO hrvbib_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ode iz Nazareta te se nastani u Kafarnaumu, uz more, na Zebulunovu i Naftalijevu području. ");
INSERT INTO hrvbib_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Tako se ispunilo Izaijino proročanstvo: ");
INSERT INTO hrvbib_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“U zemlji Zebulunovoj i Naftalijevoj, uz more, s one strane Jordana, u poganskoj Galileji, ");
INSERT INTO hrvbib_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","narod koji je u tmini živio ugleda veliku svjetlost; onima što su prebivali u mračnom predjelu smrti zasjalo je jarko svjetlo.” ");
INSERT INTO hrvbib_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Otada Isus počne propovijedati: “Pokajte se za grijehe i obratite se Bogu jer je nebesko kraljevstvo blizu!” ");
INSERT INTO hrvbib_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Prolazeći jednom obalom uz Galilejsko jezero, Isus opazi dvojicu braće—Šimuna, zvanoga još i Petar, i Andriju—kako bacaju mrežu u more. Bili su, naime, ribari. ");
INSERT INTO hrvbib_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Reče im: “Pođite za mnom i ja ću vas učiniti ribarima ljudi!” ");
INSERT INTO hrvbib_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Oni smjesta ostave svoje mreže te pođu za njim. ");
INSERT INTO hrvbib_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Malo dalje ugleda drugu dvojicu braće, Jakova i Ivana, kako sjede u lađici sa svojim ocem Zebedejem i krpaju mreže. Pozove i njih. ");
INSERT INTO hrvbib_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Oni smjesta ostave lađicu i oca te pođu za njim. ");
INSERT INTO hrvbib_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Isus je putovao cijelom Galilejom poučavajući u židovskim sinagogama, propovijedajući Radosnu vijest o nebeskom kraljevstvu te iscjeljujući svaku vrstu bolesti i nemoći u narodu. ");
INSERT INTO hrvbib_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Glas o njemu pronese se po svoj Siriji, pa su mu ljudi čak i odande dovodili sve koje je mučila kakva bolest i patnja: opsjednute, mjesečare i uzete, a on ih je ozdravljao. ");
INSERT INTO hrvbib_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Za njim je nagrnulo silno mnoštvo iz Galileje, Dekapolisa, Jeruzalema i cijele Judeje, pa čak i s druge strane Jordana. ");
INSERT INTO hrvbib_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Kad Isus ugleda da se okupilo mnoštvo, popne se na goru i sjedne. Nato mu priđu njegovi učenici. ");
INSERT INTO hrvbib_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","On počne poučavati. ");
INSERT INTO hrvbib_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Blago onima koji shvaćaju da im je Bog potreban jer je njihovo nebesko kraljevstvo! ");
INSERT INTO hrvbib_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Blago onima koji tuguju, jer će ih Bog utješiti! ");
INSERT INTO hrvbib_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Blago krotkima, jer će baštiniti zemlju! ");
INSERT INTO hrvbib_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Blago onima koji su gladni i žedni pravednosti, jer će je se nasititi! ");
INSERT INTO hrvbib_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Blago milosrdnima, jer će se i njima iskazati milosrđe! ");
INSERT INTO hrvbib_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Blago ljudima čista srca, jer će gledati Boga! ");
INSERT INTO hrvbib_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Blago mirotvorcima, jer će se nazivati Božjom djecom! ");
INSERT INTO hrvbib_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Blago onima koje progone zato što su pravedni pred Bogom, jer je njihovo nebesko kraljevstvo! ");
INSERT INTO hrvbib_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Blago vama kad vas zbog mene budu grdili i progonili i lažno vam pripisivali kojekakva zla! ");
INSERT INTO hrvbib_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Radujte se zbog toga, silno se radujte! Jer velika vas nagrada čeka na nebesima. Tako su progonili i proroke prije vas!” ");
INSERT INTO hrvbib_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Vi ste sol čovječanstvu. Ali kakva je korist od soli ako obljutavi? Za što se može uporabiti? Ni za što, osim da se izbaci van, da ju ljudi pogaze. ");
INSERT INTO hrvbib_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Vi ste svjetlost svijetu—grad na gori koji noću sjaji da ga svi vide. ");
INSERT INTO hrvbib_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Svjetiljku ne palite da biste ju pokrili pod košaru, nego da biste ju postavili tako da svijetli svima u kući. ");
INSERT INTO hrvbib_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Neka vaša svjetlost svijetli pred ljudima tako da vide vaša dobra djela i da slave vašega Oca koji je na nebesima.” ");
INSERT INTO hrvbib_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Nemojte pogrešno shvatiti da sam došao ukinuti Zakon i zapise proroka. Nisam ih došao ukinuti, nego ispuniti. ");
INSERT INTO hrvbib_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Zaista vam kažem: sve dok postoji nebo i zemlja, nijedno slovce, nijedan potez pera u Zakonu neće nestati dok se sve ne ostvari. ");
INSERT INTO hrvbib_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Prekrši li zato tko i najmanju zapovijed i druge tome pouči, bit će najmanji u nebeskom kraljevstvu. Ali oni koji poučavaju Božjim zakonima i pokoravaju im se bit će veliki u nebeskom kraljevstvu. ");
INSERT INTO hrvbib_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Kažem vam, ne bude li vaša pravednost veća od pravednosti pismoznanaca i farizeja, nipošto nećete ući u nebesko kraljevstvo!” ");
INSERT INTO hrvbib_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Čuli ste da je starima rečeno u Zakonu: ‘Ne ubij! Tko ubije, mora biti izveden pred sud.’ ");
INSERT INTO hrvbib_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","A ja vam kažem: tko se rasrdi na svojeg brata, odgovarat će pred sudom! Nazove li ga glupanom, odgovarat će pred najvišim sudom. A nazove li ga luđakom, odgovarat će za to u paklenome ognju! ");
INSERT INTO hrvbib_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Stojiš li, dakle, pred žrtvenikom u Hramu prinoseći žrtvu Bogu pa se iznenada sjetiš da neki tvoj brat ima što protiv tebe, ");
INSERT INTO hrvbib_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ostavi žrtvu pred žrtvenikom pa se najprije pomiri s njime, a tek onda dođi i prinesi žrtvu Bogu. ");
INSERT INTO hrvbib_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Brzo se nagodi s protivnikom, prije nego što bude kasno, dok te nije izveo pred sud, a sudac bacio u tamnicu. ");
INSERT INTO hrvbib_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Zaista ti kažem, odande nećeš izići sve dok ne isplatiš sve do posljednjeg novčića!” ");
INSERT INTO hrvbib_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Čuli ste da u Zakonu piše: ‘Ne čini preljuba!’ ");
INSERT INTO hrvbib_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","A ja vam kažem: Tko samo i pogleda ženu s požudom, već je u svojem srcu s njom počinio preljub. ");
INSERT INTO hrvbib_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ako te tvoje desno oko navodi na grijeh, iskopaj ga i baci. Bolje ti je da samo jedan dio tvojeg tijela bude uništen nego da sav budeš bačen u pakao. ");
INSERT INTO hrvbib_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Pa makar te i tvoja desna ruka navodila na grijeh, odsijeci ju i baci od sebe. Bolje da ostaneš bez jednoga od udova nego da ti cijelo tijelo ode u pakao.” ");
INSERT INTO hrvbib_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Također ste čuli: ‘Tko otpusti svoju ženu, neka joj dade otpusnicu.’ ");
INSERT INTO hrvbib_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ali ja vam kažem: Tko god se razvede od svoje žene, osim zbog njezina bluda, navodi ju na preljub. I tko god se oženi razvedenom ženom, čini preljub.” ");
INSERT INTO hrvbib_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Čuli ste da u Zakonu piše: ‘Ne krši zakletve, nego izvrši ono na što si se Gospodinu zakleo.’ ");
INSERT INTO hrvbib_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","A ja vam kažem: Ne kunite se nikako! Ni nebom, jer je Božje prijestolje, ");
INSERT INTO hrvbib_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ni zemljom, jer je podnožje njegovim nogama, ni Jeruzalemom, jer je to grad velikoga kralja. ");
INSERT INTO hrvbib_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ne kunite se ni svojom glavom, jer ni jednu jedinu vlas niste u stanju učiniti bijelom ili crnom. ");
INSERT INTO hrvbib_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Kad kažete: ‘Da’, neka to znači ‘da’, kad kažete: ‘Ne’, neka znači ‘ne’; sve što je više, dolazi od Zloga.” ");
INSERT INTO hrvbib_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Čuli ste da u Zakonu piše: ‘Oko za oko, zub za zub!’ ");
INSERT INTO hrvbib_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","A ja vam kažem: Ne opirite se zlotvoru! Pljusne li vas, naprotiv, tko po jednom obrazu, okrenite mu i drugi! ");
INSERT INTO hrvbib_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ako bi se tko htio s tobom parničiti da ti otme košulju, daj mu i svoj ogrtač. ");
INSERT INTO hrvbib_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Primoraju li te rimski vojnici da im poneseš opremu jednu milju, ponesi ju dvije. ");
INSERT INTO hrvbib_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Zatraži li tko nešto od tebe, daj mu, i nemoj okrenuti leđa onome tko te zamoli da mu posudiš.” ");
INSERT INTO hrvbib_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Čuli ste da u Zakonu piše: ‘Ljubi svojega bližnjega, a mrzi neprijatelje!’ ");
INSERT INTO hrvbib_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","A ja vam kažem: Ljubite i svoje neprijatelje i molite se za one koji vas progone! ");
INSERT INTO hrvbib_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Tako ćete se ponijeti kao prava djeca svojega nebeskog Oca, koji daje da njegovo sunce izlazi i nad zlima i nad dobrima te da kiša pada i pravednicima i nepravednicima. ");
INSERT INTO hrvbib_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Jer ako volite samo one koji vas vole, kakvu nagradu možete očekivati? Ne čine li tako i ubirači poreza? ");
INSERT INTO hrvbib_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ako ste ljubazni samo prema svojoj braći, po čemu se razlikujete od drugih? To čine i neznabošci. ");
INSERT INTO hrvbib_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Budite, dakle, savršeni kao što je savršen vaš nebeski Otac.” ");
INSERT INTO hrvbib_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Pazite! Nemojte svoja dobra djela činiti javno da vam se drugi dive jer onda nećete primiti plaću od svojega nebeskog Oca. ");
INSERT INTO hrvbib_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Zato kada daješ milodar, ne trubi pred sobom kao što to u sinagogama i na ulicama čine licemjeri da ih ljudi hvale. Zaista vam kažem, drugu nagradu osim te neće dobiti. ");
INSERT INTO hrvbib_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Naprotiv, kada daješ milodar, neka tvoja ljevica ne zna što radi desnica. ");
INSERT INTO hrvbib_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Udijeli svoj milodar potajno pa će te tvoj Otac, koji vidi i u tajnosti, nagraditi.” ");
INSERT INTO hrvbib_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“I kada se molite, ne budite poput licemjera koji se vole moliti u sinagogama i po uličnim raskrižjima da ih ljudi vide. Zaista vam kažem, drugu nagradu osim te neće dobiti. ");
INSERT INTO hrvbib_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ti, naprotiv, kada se moliš, uđi nekamo gdje ćeš biti sam, zatvori za sobom vrata te se pomoli Ocu u tajnosti, a tvoj će te Otac, koji vidi u tajnosti, nagraditi. ");
INSERT INTO hrvbib_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Kad se molite, ne nabrajajte isprazne riječi kao pogani, koji misle da će biti uslišani zbog svojega nabrajanja. ");
INSERT INTO hrvbib_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ne činite kao oni jer vaš Otac dobro zna što vam je potrebno i prije nego što ga zamolite. ");
INSERT INTO hrvbib_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Zato se vi molite ovako: ‘Oče naš na nebu, neka se štuje tvoje sveto ime. ");
INSERT INTO hrvbib_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Neka dođe tvoje kraljevstvo. Neka se tvoja volja provodi na zemlji kao i na nebu. ");
INSERT INTO hrvbib_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Kruh naš svagdašnji daj nam danas ");
INSERT INTO hrvbib_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","i oprosti nam naše grijehe kao što i mi opraštamo onima koji griješe protiv nas. ");
INSERT INTO hrvbib_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","I ne dopusti da podlegnemo kušnji, nego nas izbavi od Zloga.’ ");
INSERT INTO hrvbib_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Jer ako oprostite ljudima njihove pogreške, i vaš će nebeski Otac vama oprostiti. ");
INSERT INTO hrvbib_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ali ne oprostite li vi drugima njihovih pogrešaka, ni vaš Otac neće vama oprostiti vaše grijehe. ");
INSERT INTO hrvbib_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Kad postite, ne mrštite se kao licemjeri, koji izobliče lice kako bi ljudi opazili da poste. Zaista vam kažem, drugu nagradu osim te neće dobiti. ");
INSERT INTO hrvbib_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ali ti se, kada postiš, lijepo uredi ");
INSERT INTO hrvbib_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","da tvoj post ne zapaze ljudi, nego samo tvoj Otac koji je u tajnosti. I tvoj će ti Otac, koji vidi u tajnosti, uzvratiti.” ");
INSERT INTO hrvbib_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Ne zgrćite sebi blago ovdje na zemlji, gdje ga mogu izgristi moljci ili može zahrđati, gdje lopovi provaljuju i kradu. ");
INSERT INTO hrvbib_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Stječite sebi blago na nebu, gdje ga ne mogu izgristi moljci ni hrđa, gdje lopovi ne provaljuju i ne kradu. ");
INSERT INTO hrvbib_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Jer gdje ti je blago, ondje će ti biti i srce. ");
INSERT INTO hrvbib_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Oko je poput svjetiljke tijelu. Ne budete li odviše brinuli za materijalna dobra jasno ćete vidjeti u životu, ");
INSERT INTO hrvbib_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","ali ako za njih budete previše brinuli vid će vam biti zasjenjen i duboka će vam tama ispuniti život. ");
INSERT INTO hrvbib_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Nitko ne može služiti dvojici gospodara. Ili će jednoga mrziti, a drugoga voljeti ili će jednome biti odan, a drugoga prezirati. Ne možete služiti i Bogu i bogatstvu. ");
INSERT INTO hrvbib_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Zato vam kažem: Ne brinite se tjeskobno kako ćete preživjeti, što ćete jesti ili piti, ni u što ćete obući svoje tijelo! Nije li život vredniji od hrane, a tijelo od odjeće? ");
INSERT INTO hrvbib_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Pogledajte ptice nebeske! Niti siju, niti žanju, niti sabiru u žitnice jer ih hrani vaš nebeski Otac. A niste li vi mnogo vredniji od njih? ");
INSERT INTO hrvbib_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Može li tko od vas sebi brigama produžiti život barem i za jedan dan? ");
INSERT INTO hrvbib_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Zašto se onda brinuti za odjeću? Pogledajte samo poljske ljiljane! Niti se muče niti predu. ");
INSERT INTO hrvbib_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","A kažem vam da se ni kralj Salomon u svoj svojoj raskoši nije zaodjenuo kao jedan od njih. ");
INSERT INTO hrvbib_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Pa ako Bog tako odijeva poljsku travu koja danas jest, a već se sutra baca u peć, zar se neće još i više brinuti za vas, malovjerni? ");
INSERT INTO hrvbib_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ne brinite se tjeskobno i ne govorite: ‘Što ćemo jesti?’, ‘Što ćemo piti?’ ili ‘U što ćemo se obući?’ ");
INSERT INTO hrvbib_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","jer tako čine nevjernici. Vaš nebeski Otac zna da vam je sve to potrebno. ");
INSERT INTO hrvbib_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Stoga najprije tražite Božje kraljevstvo i njegovu pravednost, pa će vam se i to nadodati. ");
INSERT INTO hrvbib_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ne brinite se zato tjeskobno za sutra jer će ono donijeti nove brige. Današnja vam je muka dovoljna za danas.” ");
INSERT INTO hrvbib_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Ne osuđujte, da ne budete osuđeni. ");
INSERT INTO hrvbib_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Jer kako vi sudite druge, tako će se i vama suditi. Kako mjerite drugima, i vama će se mjeriti. ");
INSERT INTO hrvbib_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Što imaš gledati trun u oku svojega brata kad u vlastitome oku ni brvna ne opažaš? ");
INSERT INTO hrvbib_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Kako ti, koji u vlastitome oku ne vidiš ni brvna, možeš reći bratu: ‘Daj da ti izvadim trun iz oka’? ");
INSERT INTO hrvbib_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Licemjeru! Izvadi najprije brvno iz vlastitog oka, pa ćeš onda dobro vidjeti kako da izvadiš trun iz bratova!. ");
INSERT INTO hrvbib_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Ne dajte svetinje psima! Ne bacajte biserje pred svinje! Jer svinje će ga pogaziti, a psi se okrenuti te vas rastrgati.” ");
INSERT INTO hrvbib_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Molite i dat će vam se! Tražite i naći ćete! Kucajte i otvorit će vam se! ");
INSERT INTO hrvbib_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Jer tko god moli, prima. Tko god traži, nalazi. Tko kuca, otvara mu se. ");
INSERT INTO hrvbib_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Bi li itko od vas svojemu djetetu, kad bi ga zamolilo kruha, dao kamen? ");
INSERT INTO hrvbib_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ili bi mu tko dao zmiju kad ga zamoli ribu? ");
INSERT INTO hrvbib_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Pa ako vi, grešni ljudi, znate davati dobre darove svojoj djeci, koliko će više vaš nebeski Otac darovati dobra onima koji ga mole?” ");
INSERT INTO hrvbib_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Činite drugima ono što biste htjeli da drugi čine vama. To je bit učenja cijeloga Zakona i Proroka.” ");
INSERT INTO hrvbib_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Uđite na uska vrata! Jer široka vrata i prostran put vode u propast i mnogi njime idu. ");
INSERT INTO hrvbib_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Kako su uska vrata i tijesan put koji vodi u Život! Malo ih je koji ga nalaze.” ");
INSERT INTO hrvbib_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Čuvajte se lažnih proroka koji dolaze u ovčjem runu, a iznutra su grabežljivi vukovi. ");
INSERT INTO hrvbib_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Prepoznat ćete ih po njihovim plodovima. Bere li se s trnja grožđe ili s bodljike smokve? ");
INSERT INTO hrvbib_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Tako svako dobro stablo rađa dobrim, a nevaljalo stablo nevaljalim plodovima. ");
INSERT INTO hrvbib_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Niti dobro stablo može roditi nevaljalim plodom, niti nevaljalo stablo dobrim plodom. ");
INSERT INTO hrvbib_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Svako stablo koje ne rađa dobrim rodom siječe se i baca u oganj. ");
INSERT INTO hrvbib_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Prepoznat ćete ih, dakle, po njihovim plodovima.” ");
INSERT INTO hrvbib_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“U nebesko kraljevstvo neće ući svi koji me nazivaju Gospodinom, već samo koji slušaju mojega nebeskog Oca. ");
INSERT INTO hrvbib_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Na sudu će mi mnogi reći: ‘Gospodine, Gospodine! Nismo li u tvoje ime prorokovali? Nismo li se služili tvojim imenom da istjerujemo zle duhove i da činimo mnoga druga čudesa?’ ");
INSERT INTO hrvbib_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ali odgovorit ću im: ‘Nikad vas nisam poznavao. Odlazite od mene, zlotvori!’” ");
INSERT INTO hrvbib_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Tko god sluša ove moje riječi i tako čini, mudar je kao i čovjek koji gradi kuću na čvrstoj stijeni. ");
INSERT INTO hrvbib_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Zapljušti kiša, navale bujice, zapušu vjetrovi i stanu šibati kuću, ali se ona ne sruši jer je izgrađena na stijeni. ");
INSERT INTO hrvbib_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Naprotiv, tko čuje ove moje riječi, a ne čini tako, jest poput luda čovjeka koji sebi gradi kuću na pijesku. ");
INSERT INTO hrvbib_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Zapljušti kiša, navale bujice, zapušu vjetrovi i stanu šibati kuću, i ona se sruši. I velika bijaše njezina ruševina.” ");
INSERT INTO hrvbib_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Kad je Isus završio govor, mnoštvo je bilo zaneseno njegovim učenjem ");
INSERT INTO hrvbib_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","jer ih je poučavao kao onaj koji ima vlast, a ne kao njihovi pismoznanci. ");
INSERT INTO hrvbib_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Veliko je mnoštvo pohrlilo za Isusom dok je silazio s gore. ");
INSERT INTO hrvbib_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Odjednom mu pristupi neki gubavac, pokloni mu se do zemlje i zamoli ga: “Gospodine, ako hoćeš, možeš me iscijeliti!” ");
INSERT INTO hrvbib_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Isus ispruži ruku i dotakne čovjeka. “Hoću! Budi čist!” reče mu. I guba odmah nestane. ");
INSERT INTO hrvbib_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Isus mu reče: “Nikome o tomu ne govori, već idi ravno svećeniku te sa sobom ponesi žrtveni dar prema Mojsijevu zakonu kao javno svjedočanstvo svojeg ozdravljenja.” ");
INSERT INTO hrvbib_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Kad Isus dođe u Kafarnaum, pristupi mu neki stotnik ");
INSERT INTO hrvbib_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","i reče: “Gospodine, sluga mi kod kuće leži uzet i u teškim mukama!” ");
INSERT INTO hrvbib_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","“Doći ću ga iscijeliti”, odgovori mu Isus. ");
INSERT INTO hrvbib_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Stotnik odgovori: “Gospodine, nisam dostojan da uđeš u moju kuću. Samo reci da moj sluga ozdravi i on će ozdraviti! ");
INSERT INTO hrvbib_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Jer i ja moram slušati svoje nadređene. A podređenom vojniku kažem: ‘Idi!’ i on ode, te drugome: ‘Dođi!’ i dođe; a sluzi kažem: ‘Učini to!’ i on učini.” ");
INSERT INTO hrvbib_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Kad je to čuo, Isus se zadivi. Okrene se mnoštvu, pa reče: “Zaista vam kažem, takve vjere nisam vidio ni u koga u cijelom Izraelu. ");
INSERT INTO hrvbib_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Kažem vam da će mnogi s istoka i zapada sjesti u nebeskom kraljevstvu s Abrahamom, Izakom i Jakovom, ");
INSERT INTO hrvbib_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","a mnogi Izraelci biti izbačeni u mrklu tamu gdje će biti plač i škrgut zuba.” ");
INSERT INTO hrvbib_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Zatim reče rimskome stotniku: “Idi! Neka ti bude kako si vjerovao!” I sluga mu istog trena ozdravi. ");
INSERT INTO hrvbib_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Kad je Isus došao u Petrovu kuću, Petrova punica ležala je bolesna, u vrućici. ");
INSERT INTO hrvbib_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Isus joj dotakne ruku i vrućica nestane. Žena ustane i počne ga posluživati. ");
INSERT INTO hrvbib_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Te mu večeri dovedu mnoge opsjednute. Na njegovu riječ svi su zli duhovi izlazili, a svi bolesnici ozdravljali. ");
INSERT INTO hrvbib_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Tako se ispunilo što je napisao prorok Izaija: “On slabosti naše uze i ponese naše bolesti.” ");
INSERT INTO hrvbib_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Kad je Isus vidio koliko se mnoštvo okuplja, zapovjedi da otplove na drugu stranu jezera. ");
INSERT INTO hrvbib_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Tada mu priđe neki pismoznanac i reče: “Učitelju, slijedit ću te kamo god ti pošao.” ");
INSERT INTO hrvbib_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Isus mu odgovori: “Lisice imaju jame i ptice imaju gnijezda, a Sin Čovječji nema gdje ni glavu nasloniti.” ");
INSERT INTO hrvbib_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Drugi mu od učenika reče: “Gospodine, dopusti mi da najprije pokopam svojeg oca.” ");
INSERT INTO hrvbib_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ali Isus mu odgovori: “Pođi za mnom i pusti da mrtvi pokapaju svoje mrtvace!” ");
INSERT INTO hrvbib_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Isus se ukrca u lađu, a za njim uđu i njegovi učenici. ");
INSERT INTO hrvbib_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Odjednom nastane tako silna oluja da su se valovi prelijevali preko lađice. Isus je spavao. ");
INSERT INTO hrvbib_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Učenici dođu k njemu i probude ga: “Gospodine, spasi nas! Izginut ćemo!” ");
INSERT INTO hrvbib_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Isus im reče: “Malovjerni! Što se toliko strašite?” Ustane zatim i zaprijeti vjetru i valovima, a oluja se stiša i nastane velika tišina. ");
INSERT INTO hrvbib_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ljudi su se u čudu pitali: “Pa tko je on da mu se i vjetrovi i more pokoravaju?” ");
INSERT INTO hrvbib_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Kad su stigli na drugu stranu jezera, u gadarski kraj, susretnu ga dvojica opsjednutih koji su dolazili iz grobnica i bili tako goropadni da zaradi njih nitko nije mogao proći tim putem. ");
INSERT INTO hrvbib_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Odjednom poviču: “Što hoćeš od nas, Sine Božji? Došao si nas ovdje mučiti prije vremena?” ");
INSERT INTO hrvbib_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Nedaleko je paslo veliko krdo svinja. ");
INSERT INTO hrvbib_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Zli duhovi zamole Isusa: “Ako nas istjeraš, pošalji nas u ono krdo svinja.” ");
INSERT INTO hrvbib_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","“Idite!” reče im Isus. Oni iziđu iz opsjednutih i uđu u svinje. Nato cijelo krdo jurne niz strminu u more i podavi se u vodi. ");
INSERT INTO hrvbib_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Svinjari pobjegnu u grad te razglase što se dogodilo s opsjednutima. ");
INSERT INTO hrvbib_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Tada sav grad iziđe u susret Isusu. Kad su ga ugledali, zamole da ode iz njihova kraja. ");
INSERT INTO hrvbib_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Tako Isus uđe u lađicu i preplovi do svojega grada. ");
INSERT INTO hrvbib_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ondje mu donesu uzetog čovjeka na nosilima. Kad Isus vidje njihovu vjeru, reče bolesniku: “Hrabro, sinko, oprošteni su ti grijesi!” ");
INSERT INTO hrvbib_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","A neki od pismoznanaca pomisle: “Ovaj huli!” ");
INSERT INTO hrvbib_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Isus je prozreo što misle, pa ih upita: “Zašto mislite zlo u srcu? ");
INSERT INTO hrvbib_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Što je lakše reći uzetom čovjeku: ‘Grijesi su ti oprošteni’ ili ‘Ustani i idi’? ");
INSERT INTO hrvbib_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Dokazat ću vam da ja, Sin Čovječji, imam vlast na zemlji opraštati grijehe.” Okrene se zatim prema uzetome i reče: “Ustani, uzmi nosila i idi kući!” ");
INSERT INTO hrvbib_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","On ustane i ode kući. ");
INSERT INTO hrvbib_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Kad je mnoštvo to vidjelo, zaprepaste se i počnu slaviti Boga što je ljudima dao takvu vlast. ");
INSERT INTO hrvbib_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Odlazeći odande, Isus ugleda čovjeka imenom Matej kako ubire porez te ga pozove: “Pođi za mnom!” Matej ustane i pođe za njim. ");
INSERT INTO hrvbib_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Dok je Isus poslije bio u kući za stolom, došli su brojni ubirači poreza i grešnici i pridružili se njemu i njegovim učenicima. ");
INSERT INTO hrvbib_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Pošto su to vidjeli, farizeji upitaju njegove učenike: “Zašto vaš učitelj jede s ubiračima poreza i drugim grešnicima?” ");
INSERT INTO hrvbib_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Isus je to čuo, pa reče: “Ne treba liječnik zdravima, nego bolesnima. ");
INSERT INTO hrvbib_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Proučite što znači: ‘Draže mi je da ste milosrdni nego da mi prinosite žrtve.’ Jer nisam došao zvati pravednike, već grešnike.” ");
INSERT INTO hrvbib_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Jednom dođu k Isusu učenici Ivana Krstitelja te ga upitaju: “Zašto tvoji učenici ne poste kao što postimo mi i farizeji?” ");
INSERT INTO hrvbib_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Isus im odgovori: “Mogu li uzvanici na svadbenoj večeri tugovati dok je mladoženja s njima? Ali doći će dani kada će im ugrabiti mladoženju. Tada će postiti. ");
INSERT INTO hrvbib_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Nitko ne krpa rupe na staroj odjeći zakrpom od još nesmočena platna. Zakrpa bi se skupila, razvukla tkaninu i napravila još veću rupu. ");
INSERT INTO hrvbib_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ne ulijeva se novo vino u stare mjehove jer bi se raspuknuli. Vino bi se prolilo, a mjehovi uništili. Novo se vino lijeva u nove mjehove. Tako se sačuva i jedno i drugo.” ");
INSERT INTO hrvbib_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Dok je još govorio, pristupi mu neki poglavar i padne pred njega ničice klanjajući se. “Kćerka mi je umrla”, reče. “Ali ti dođi i stavi ruku na nju, pa će oživjeti.” ");
INSERT INTO hrvbib_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Isus pođe s učenicima njegovu domu. ");
INSERT INTO hrvbib_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Neka žena koja je već dvanaest godina bolovala od krvarenja priđe mu otraga i dotakne skut njegova ogrtača ");
INSERT INTO hrvbib_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","jer je pomislila: “Dodirnem li samo njegovu odjeću, ozdravit ću!” ");
INSERT INTO hrvbib_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Isus se okrene i spazi ju te joj reče: “Samo hrabro, kćeri! Tvoja te vjera iscijelila.” I žena istoga trena ozdravi. ");
INSERT INTO hrvbib_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Kad je Isus stigao do poglavarova doma, ugleda bučno mnoštvo i svirače. ");
INSERT INTO hrvbib_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","“Odstupite! Djevojčica nije umrla, nego samo spava!” A oni ga počnu ismijavati. ");
INSERT INTO hrvbib_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Kad ih je istjerao, Isus uđe k djevojčici i uzme ju za ruku, a ona ustane. ");
INSERT INTO hrvbib_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Glas o tome proširio se cijelim krajem. ");
INSERT INTO hrvbib_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Kad je Isus odande odlazio, dva slijepca pođu za njime vičući: “Smiluj nam se, sine Davidov!” ");
INSERT INTO hrvbib_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Pođu za njim ravno u kuću u kojoj je odsjeo, a Isus ih upita: “Vjerujete li da to mogu učiniti?” “Vjerujemo, Gospodine”, odgovore mu. ");
INSERT INTO hrvbib_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Tada im dotakne oči i reče: “Neka vam bude prema vašoj vjeri!” ");
INSERT INTO hrvbib_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","I oči im se otvore. Isus ih strogo upozori: “Nikome o tomu ne pričajte!” ");
INSERT INTO hrvbib_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ali oni, kad iziđu, prošire glas o njemu po cijelome kraju. ");
INSERT INTO hrvbib_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Tek što su oni izišli, dovedu mu nijema i opsjednuta čovjeka. ");
INSERT INTO hrvbib_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Isus istjera zlog duha, a njemak progovori. Mnoštvo se silno čudilo. “Takvo što u Izraelu još nikada nismo vidjeli!” ");
INSERT INTO hrvbib_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ali farizeji su govorili: “On izgoni zle duhove pomoću poglavice zlih duhova.” ");
INSERT INTO hrvbib_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Isus je putovao po svim gradovima i selima poučavajući u židovskim sinagogama, navješćujući Radosnu vijest o kraljevstvu te iscjeljujući ljude od svake bolesti i nemoći. ");
INSERT INTO hrvbib_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Sažalilo mu se mnoštvo koje je dolazilo jer su ljudi bili izmučeni i zapušteni poput ovaca bez pastira. ");
INSERT INTO hrvbib_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","“Žetva je vrlo velika, a radnika je tako malo”, reče on svojim učenicima. ");
INSERT INTO hrvbib_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","“Zato molite gospodara da pošalje radnike u svoju žetvu.” ");
INSERT INTO hrvbib_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Isus pozvao je sebi dvanaestoricu učenika te ih ovlasti da izgone zle duhove i da iscjeljuju svakovrsne bolesti i slabosti. ");
INSERT INTO hrvbib_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Evo imena dvanaestorice apostola: Šimun (zvan i Petar), Andrija (Petrov brat), Jakov (Zebedejev sin), Ivan (Jakovljev brat), ");
INSERT INTO hrvbib_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filip, Bartolomej, Toma, Matej (ubirač poreza), Jakov (Alfejev sin), Tadej, ");
INSERT INTO hrvbib_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Šimun Kananaj i Juda Iškariotski (koji je izdao Isusa). ");
INSERT INTO hrvbib_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Isus ih je poslao i uputio ih: “Ne idite poganima ni Samarijancima, ");
INSERT INTO hrvbib_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","već samo izraelskom narodu—Božjim izgubljenim ovcama. ");
INSERT INTO hrvbib_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Idite i propovijedajte im da je blizu nebesko kraljevstvo. ");
INSERT INTO hrvbib_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Iscjeljujte bolesnike i gubavce, uskrisujte mrtve i istjerujte zloduhe. Besplatno ste primili, besplatno i dajte. ");
INSERT INTO hrvbib_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ne uzimajte sa sobom zlata, ni srebra, ni mjedi u pojase, ");
INSERT INTO hrvbib_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ni torbu s odjećom i obućom za put, ni štap, jer radnik zaslužuje svoje uzdržavanje. ");
INSERT INTO hrvbib_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Kad god uđete u grad ili selo, potražite dostojna čovjeka pa ostanite kod njega sve dok ne pođete u drugi grad. ");
INSERT INTO hrvbib_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Kad uđete u neku kuću, blagoslovite ju. ");
INSERT INTO hrvbib_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Bude li kuća toga dostojna, neka se na nju spusti vaš mir. Ne pokaže li se dostojnom, neka se vaš mir vrati vama. ");
INSERT INTO hrvbib_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Gdje vas ne prihvate i ne poslušaju što im govorite, otresite s nogu i prašinu iz toga mjesta kad budete odlazili. ");
INSERT INTO hrvbib_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Zaista vam kažem, na Sudnji će dan Sodomi i Gomori biti lakše nego tomu mjestu! ");
INSERT INTO hrvbib_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Šaljem vas, evo, kao ovce među vukove. Stoga budite mudri kao zmije, a bezazleni kao golubovi. ");
INSERT INTO hrvbib_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Čuvajte se jer će vas predavati sudu i bičevati po sinagogama. ");
INSERT INTO hrvbib_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Zbog mene će vas izvoditi pred vladare i kraljeve, da biste njima i poganima mogli posvjedočiti o meni. ");
INSERT INTO hrvbib_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ne brinite se što ćete govoriti kad vas predaju sudu jer će vam tada biti dano što da kažete. ");
INSERT INTO hrvbib_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Nećete govoriti vi—kroz vas će govoriti Duh vašega nebeskog Oca. ");
INSERT INTO hrvbib_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Brat će brata i otac dijete predavati na smrt. Djeca će se dizati protiv roditelja i predavati ih da ih ubiju. ");
INSERT INTO hrvbib_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Svi će vas zamrziti zbog mene, ali tko ustraje do kraja, spasit će se. ");
INSERT INTO hrvbib_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Kad vas počnu progoniti u jednom gradu, bježite u drugi! Ja, Sin Čovječji, vratit ću se prije nego što obiđete sve izraelske gradove. ");
INSERT INTO hrvbib_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Učenik nije veći od svojega učitelja, niti je sluga iznad svojega gospodara. ");
INSERT INTO hrvbib_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Dosta je da učenik dijeli učiteljevu, a sluga gospodarovu sudbinu. Ako su dakle mene, domaćina, nazvali ‘Beelzebulom’, koliko li će onda više vas, moje ukućane? ");
INSERT INTO hrvbib_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Ali ne bojte se onih koji vam prijete. Jer dolazi vrijeme kad će sve što je skriveno biti otkriveno; sve što je tajno čut će se pred svima. ");
INSERT INTO hrvbib_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Što vam sad govorim u tami, vičite po ulicama kad svane dan. Što vam šapćem na uho, vičite s krovova da svi čuju! ");
INSERT INTO hrvbib_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ne bojte se onih koji mogu ubiti samo tijelo, ali dušu ne mogu! Bojte se Boga koji i dušu i tijelo može uništiti u paklu. ");
INSERT INTO hrvbib_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ne prodaju li se dva vrapca za novčić, a ipak nijedan od njih ne padne na zemlju bez dopuštenja vašega Oca. ");
INSERT INTO hrvbib_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","A vama su izbrojene i vlasi na glavi. ");
INSERT INTO hrvbib_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Stoga se ne bojte! Vi ste mu mnogo vredniji od mnoštva vrabaca. ");
INSERT INTO hrvbib_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Tko ovdje na zemlji pred ljudima prizna da pripada meni, za njega ću ja, pred svojim Ocem na nebu, priznati da mu pripadam. ");
INSERT INTO hrvbib_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ali onoga koji mene zaniječe na zemlji odreći ću se pred svojim Ocem na nebu. ");
INSERT INTO hrvbib_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Nemojte misliti da sam na zemlju došao donijeti mir! Nisam došao donijeti mir, nego mač. ");
INSERT INTO hrvbib_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Došao sam rastaviti: ‘sina od oca, kćerku od majke i snahu od svekrve. ");
INSERT INTO hrvbib_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Čovjeku će neprijatelji biti vlastiti ukućani.’ ");
INSERT INTO hrvbib_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Tko voli svojega oca ili svoju majku više nego mene, nije me dostojan. Tko voli sina ili kćerku više nego mene, nije me dostojan. ");
INSERT INTO hrvbib_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Tko ne uzme svoj križ i ne pođe za mnom, nije me dostojan. ");
INSERT INTO hrvbib_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Tko za sebe čuva svoj život, izgubit će ga; a tko dade svoj život za mene, naći će ga. ");
INSERT INTO hrvbib_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Tko prihvati vas, mene prihvaća. A tko mene prihvati, prihvaća Boga koji me je poslao. ");
INSERT INTO hrvbib_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Tko prihvati proroka zato što je prorok, dobit će proročku plaću; tko prihvati pravednika zato što je pravednik, dobit će pravedničku plaću. ");
INSERT INTO hrvbib_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Tko napoji jednoga od ovih najmanjih čašom hladne vode, zato što je moj učenik, sigurno neće mu propasti nagrada.” ");
INSERT INTO hrvbib_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Kad je završio s uputama dvanaestorici učenika, Isus ode poučavati i propovijedati po gradovima. ");
INSERT INTO hrvbib_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ivan Krstitelj je u tamnici čuo o Kristovim čudesnim djelima, pa pošalje svoje učenike da upitaju Isusa: ");
INSERT INTO hrvbib_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“Jesi li ti zaista onaj koji treba doći ili da čekamo drugoga?” ");
INSERT INTO hrvbib_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Zatim odgovori Ivanovim učenicima: “Idite Ivanu i ispričajte što čujete i vidite: ");
INSERT INTO hrvbib_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","slijepcima se vraća vid, hromi hodaju, gubavci ozdravljaju, gluhi čuju, mrtvi ustaju i Radosna vijest se propovijeda siromasima. ");
INSERT INTO hrvbib_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Recite mu i ovo: ‘Blago onome tko se zbog mene ne sablazni!’” ");
INSERT INTO hrvbib_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Kad su otišli, Isus počne govoriti mnoštvu o Ivanu. “Kad ste izišli u pustinju, što ste išli gledati? Samo trsku kako se povija na vjetru? ");
INSERT INTO hrvbib_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ili ste išli vidjeti raskošno odjevena čovjeka? Ali takvi žive u kraljevskim palačama. ");
INSERT INTO hrvbib_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ili ste išli vidjeti Božjeg proroka? Da, on je i više od proroka. ");
INSERT INTO hrvbib_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Jer Ivan je čovjek o kojemu u Svetome pismu piše: ‘Gledajte, šaljem pred vas svojega glasnika i on će vam pripraviti put.’ ");
INSERT INTO hrvbib_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Zaista vam kažem: Od svih ljudi koji su ikada rođeni nije bilo većega od Ivana Krstitelja. Pa ipak, i najmanji u kraljevstvu nebeskomu veći je od njega! ");
INSERT INTO hrvbib_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","A od vremena kad je Ivan Krstitelj počeo propovijedati i krstiti pa sve do sada, navala je na kraljevstvo nebesko i siloviti ga prisvajaju. ");
INSERT INTO hrvbib_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Jer svi su proroci i Zakon proricali o Ivanu. ");
INSERT INTO hrvbib_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","I, ako ste mi to spremni povjerovati, on je taj drugi Ilija koji je trebao doći. ");
INSERT INTO hrvbib_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Slušajte, kad već imate uši! ");
INSERT INTO hrvbib_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","A s kime da usporedim ovaj naraštaj? On je poput djece koja sjede i igraju se na gradskome trgu, pa jedna drugoj dovikuju: ");
INSERT INTO hrvbib_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Veselo smo vam zasvirali, ali niste htjeli zaplesati. Onda smo vam zapjevali tužaljke, ali ni plakati niste htjeli.’ ");
INSERT INTO hrvbib_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Jer, došao je Ivan koji je postio i nije pio vino, a oni kažu: ‘Ima zloduha.’ ");
INSERT INTO hrvbib_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Onda sam došao ja, Sin Čovječji. Jedem i pijem, pa sada govore: ‘Izjelica je i pijanac, prijatelj je ubiračima poreza i drugim grešnicima!’ Ali Božja će se mudrost opravdati svojim djelima.” ");
INSERT INTO hrvbib_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Tada počne koriti gradove u kojima se zbilo najviše njegovih čudesnih djela zato što se nisu obratili Bogu. ");
INSERT INTO hrvbib_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Teško tebi, Korozaine! Teško tebi, Betsaido! Jer da su se čudesa koja su se kod vas dogodila zbila u pokvarenima Tiru i Sidonu, oni bi se već odavno obratili u kostrijeti i pepelu. ");
INSERT INTO hrvbib_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Kažem vam da će Tiru i Sidonu na Sudnji dan biti lakše nego vama! ");
INSERT INTO hrvbib_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","A ti, Kafarnaume, zar ćeš se do neba uzdignuti? Strovalit ćeš se u pakao. Da su se čudesa koja su se u tebi zbila dogodila u Sodomi, ona bi zaista ostala do danas. ");
INSERT INTO hrvbib_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Kažem vam da će Sodomi biti lakše na Sudnji dan nego vama!” ");
INSERT INTO hrvbib_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Tada Isus reče: “Oče, gospodaru neba i zemlje, slavim te što si to skrio od mudrih i umnih, a objavio malenima. ");
INSERT INTO hrvbib_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Da, Oče, tebi se to svidjelo tako učiniti. ");
INSERT INTO hrvbib_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Moj mi je Otac sve predao. Nitko ne poznaje Sina nego Otac i nitko ne poznaje Oca nego Sin i oni kojima se Sin hoće objaviti. ");
INSERT INTO hrvbib_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Dođite k meni svi koji ste umorni i opterećeni i ja ću vas odmoriti. ");
INSERT INTO hrvbib_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Uzmite na sebe moj jaram i učite od mene jer sam krotka i ponizna srca. Tako ćete naći spokoj svojim dušama. ");
INSERT INTO hrvbib_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Moj je jaram sladak, a moje breme lako.” ");
INSERT INTO hrvbib_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","U ono je vrijeme neke subote Isus s učenicima prolazio žitnim poljima. Učenici su ogladnjeli te počeli trgati klasje i jesti ga. ");
INSERT INTO hrvbib_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Opaze to neki farizeji pa rekoše: “Ne bi to smjeli činiti! Zakonom je zabranjeno skupljati usjev subotom!” ");
INSERT INTO hrvbib_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ali Isus im odgovori: “Niste li u Pismu čitali o tomu što je učinio kralj David kad su on i njegovi pratitelji ogladnjeli? ");
INSERT INTO hrvbib_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ušao je u Dom Božji te su pojeli prinesen kruh koji nije bilo dopušteno jesti ni njemu ni njegovim pratiocima, nego samo svećenicima. ");
INSERT INTO hrvbib_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Niste li u Zakonu pročitali da svećenici služeći subotom u Hramu krše Zakon, a ipak nemaju krivnje? ");
INSERT INTO hrvbib_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","A ja vam kažem da je ovdje nešto veće od Hrama! ");
INSERT INTO hrvbib_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Kad biste zaista razumjeli što znači: ‘Draže mi je da ste milosrdni nego da mi prinosite žrtve’, ne biste osuđivali ove nedužne. ");
INSERT INTO hrvbib_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ja, Sin Čovječji, gospodar sam subote.” ");
INSERT INTO hrvbib_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Zatim ode u sinagogu ");
INSERT INTO hrvbib_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","i ondje spazi čovjeka usahnule ruke. Da bi ga mogli optužiti zbog potvrdnog odgovora, farizeji upitaju Isusa: “Je li dopušteno subotom iscijeliti?” ");
INSERT INTO hrvbib_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","On odgovori: “Tko to od vas ne bi svoju jedinu ovcu ako bi u subotu upala u jamu iz nje izvadio? ");
INSERT INTO hrvbib_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","A koliko je čovjek vredniji od ovce! Subotom je, dakle, slobodno činiti dobro.” ");
INSERT INTO hrvbib_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Onome čovjeku zatim reče: “Ispruži ruku!” On ju ispruži, a ruka mu postane zdrava kao i druga. ");
INSERT INTO hrvbib_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","A farizeji se, čim su izišli iz sinagoge, okupe na vijećanje da se dogovore kako da ga smaknu. ");
INSERT INTO hrvbib_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ali Isus je to znao pa je otišao iz sinagoge s mnogima koji su ga slijedili. Sve je bolesne među njima iscijelio, ");
INSERT INTO hrvbib_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","a on im je oštro zabranjivao da ga očituju. ");
INSERT INTO hrvbib_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Time se ispunilo Izaijino proročanstvo: ");
INSERT INTO hrvbib_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ovo je moj ljubljeni Sluga, kojega sam izabrao. On je moja radost. Duh svoj stavit ću na njega. On će navješćivati pravdu narodima. ");
INSERT INTO hrvbib_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Neće se prepirati ni vikati, ulicama mu se neće čuti glasa. ");
INSERT INTO hrvbib_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ni zgažene trske neće slomiti, ni ugasit žiška što tek tinja sve dok ne ostvari pobjedu pravde. ");
INSERT INTO hrvbib_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","U njegovo će se ime uzdati narodi.” ");
INSERT INTO hrvbib_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Tada Isusu dovedu zloduhom opsjednuta, slijepa i nijema čovjeka. Isus ga iscijeli te on progovori i progleda. ");
INSERT INTO hrvbib_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Mnoštvo je osupnuto pitalo: “Da on nije Mesija, Sin Davidov?” ");
INSERT INTO hrvbib_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Kad su za to čuli farizeji, rekoše: “Taj izgoni zle duhove pomoću Beelzebula, poglavice zlih duhova.” ");
INSERT INTO hrvbib_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Znajući što misle, Isus im reče: “Svako podijeljeno kraljevstvo propada. Grad ili dom ne može opstati ako je iznutra razjedinjen. ");
INSERT INTO hrvbib_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ako dakle Sotona izgoni Sotonu, njegovo je kraljevstvo razjedinjeno. Kako će se onda održati? ");
INSERT INTO hrvbib_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ako ja zaista izgonim zle duhove uz pomoć Beelzebula, čijom ih pomoći istjeruju vaši sljedbenici? Zato će vas oni osuditi. ");
INSERT INTO hrvbib_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ali ako ja izgonim zloduhe pomoću Božjega Duha, onda je k vama stiglo Božje kraljevstvo. ");
INSERT INTO hrvbib_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Ne možete ući u kuću snažnog čovjeka i opljačkati ga a da ga najprije ne svežete. Tek tada ga možete orobiti. ");
INSERT INTO hrvbib_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Tko nije na mojoj strani, zapravo je protiv mene; i svatko tko sa mnom ne skuplja, zapravo rastjeruje. ");
INSERT INTO hrvbib_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Zato će se, kažem vam, ljudima oprostiti svaki grijeh i bogohulstvo, ali hula na Svetoga Duha neće se oprostiti. ");
INSERT INTO hrvbib_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ipak, onome koji što kaže protiv Sina Čovječjega oprostit će se, ali kaže li što protiv Svetoga Duha, neće mu se oprostiti ni na ovome ni u budućemu svijetu. ");
INSERT INTO hrvbib_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Odlučite se dakle: ili je stablo dobro i donosi dobar rod ili je nevaljalo i donosi zao rod. Pa drvo se poznaje po plodovima. ");
INSERT INTO hrvbib_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Zmijski rode! Kako biste i mogli govoriti dobro kad ste zli? Jer usta govore ono čega je srce prepuno. ");
INSERT INTO hrvbib_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Dobar čovjek iz riznice svojega srca iznosi dobro, a zao čovjek zlo. ");
INSERT INTO hrvbib_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","A ja vam kažem da će ljudi za svaku bezrazložnu riječ koju izgovore položiti račun na Sudnji dan. ");
INSERT INTO hrvbib_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Vlastite će te riječi opravdati ili osuditi.” ");
INSERT INTO hrvbib_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Zatim mu neki pismoznanci i farizeji rekoše: “Učitelju, htjeli bismo da nam pokažeš neki znak.” ");
INSERT INTO hrvbib_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","On im odgovori: “Samo zao i nevjernički naraštaj traži znak, ali neće mu se dati drugoga osim znaka proroka Jone. ");
INSERT INTO hrvbib_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Kao što je Jona tri dana i tri noći proveo u utrobi morske nemani, tako ću i ja, Sin Čovječji, provesti u krilu zemlje tri dana i tri noći. ");
INSERT INTO hrvbib_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Stanovnici Ninive ustat će protiv ovoga naraštaja na Sudu i osuditi ga jer su se oni obratili na Jonino propovijedanje. S vama je ovdje i veći od Jone! ");
INSERT INTO hrvbib_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Kraljica Juga ustat će protiv ovoga naraštaja na Sudu i osuditi ga jer je izdaleka došla čuti Salomonovu mudrost; s vama je ovdje i veći od Salomona. ");
INSERT INTO hrvbib_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Kad nečisti duh iziđe iz čovjeka, luta bezvodnim mjestima tražeći odmora, ali ga ne nalazi. ");
INSERT INTO hrvbib_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Tada kaže: ‘Vratit ću se u kuću iz koje sam izišao.’ Vrati se i svoj stari dom zatekne prazan, pometen i čist. ");
INSERT INTO hrvbib_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Zatim ode pronaći drugih sedam duhova još gorih od sebe te svi oni uđu u čovjeka i u njemu se nastane. Na kraju tako čovjeku bude i gore nego prije. Tako će biti i ovome zlom naraštaju.” ");
INSERT INTO hrvbib_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Dok je Isus još govorio mnoštvu, vani su stajali njegova majka i braća želeći s njime razgovarati. ");
INSERT INTO hrvbib_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Netko mu je rekao: “Evo, tu su ti majka i braća. Žele s tobom razgovarati.” ");
INSERT INTO hrvbib_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","On odgovori: “Tko mi je majka? Tko su mi braća?” ");
INSERT INTO hrvbib_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Pokaže zatim prema svojim učenicima. “Evo,” reče, “to su mi majka i braća! ");
INSERT INTO hrvbib_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Zaista, tko god čini volju mojega nebeskog oca, taj mi je i brat, i sestra, i majka!” ");
INSERT INTO hrvbib_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Istoga dana Isus iziđe iz kuće i ode sjesti uz jezero. ");
INSERT INTO hrvbib_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","K njemu nagrne silno mnoštvo, tako da je morao ući u lađicu. Sjeo je u nju, a mnoštvo je stajalo na obali. ");
INSERT INTO hrvbib_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Mnogo im je govorio u prispodobama: “Neki je ratar sijao sjeme. ");
INSERT INTO hrvbib_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Dok je sijao po polju, dio zrnja padne na stazu pa dođu ptice i pozobaju ga. ");
INSERT INTO hrvbib_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Dio sjemena padne na kamenito tlo gdje je zemlja bila plitka, pa odmah nikne. ");
INSERT INTO hrvbib_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ali kad je granulo sunce, izgori i osuši se jer nije imalo duboka korijena. ");
INSERT INTO hrvbib_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Dio sjemena padne u trnje pa ono poraste i uguši ga. ");
INSERT INTO hrvbib_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Dio ga, napokon, padne na dobru zemlju i donese plod: jedno stostruk, drugo šezdeseterostruk, treće trideseterostruk. ");
INSERT INTO hrvbib_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Slušajte, kad već imate uši!” ");
INSERT INTO hrvbib_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Priđu mu učenici i upitaju: “Zašto ljudima uvijek govoriš u prispodobama?” ");
INSERT INTO hrvbib_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","On im odgovori: “Zato što je vama dano da razumijete tajne nebeskoga kraljevstva, a drugima nije. ");
INSERT INTO hrvbib_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Onima koji žive po Božjoj mudrosti”, reče im, “Bog će dati još više mudrosti. A oni koji ne postupaju prema njegovoj mudrosti izgubit će i ono malo od nje što imaju. ");
INSERT INTO hrvbib_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","U prispodobama im govorim zato što ljudi gledaju što radim, a zapravo ne vide; zato što slušaju što im govorim, a zapravo ne čuju i ne razumiju. ");
INSERT INTO hrvbib_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Tako se ispunja Izaijino proročanstvo: ‘Slušat ćete moje riječi, ali nećete ih razumjeti; gledat ćete moja djela, ali nećete dokučiti njihova značenja. ");
INSERT INTO hrvbib_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Jer srca su se ovoga naroda usalila, uši njihove ne čuju, a oči su zatvorili— tako njihove oči ne vide i njihove uši ne čuju, a srca im ne mogu razumjeti. Zato se ne mogu obratiti k meni da ih iscijelim.’ ");
INSERT INTO hrvbib_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ali blago vašim očima zato što vide i blago vašim ušima zato što slušaju. ");
INSERT INTO hrvbib_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Zaista vam kažem, mnogi su proroci i pravednici željeli vidjeti to što vi gledate, ali nisu vidjeli; željeli su čuti što vi čujete, ali nisu čuli. ");
INSERT INTO hrvbib_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Da vam objasnim priču o sijaču. ");
INSERT INTO hrvbib_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Svakomu tko čuje riječ o kraljevstvu, a ne razumije ju, dođe Zli i otme mu ono što mu je u srcu posijano. To je sjeme zasijano pokraj puta. ");
INSERT INTO hrvbib_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Kamenito tlo su oni koji čuju Riječ i odmah ju radosno prihvate, ");
INSERT INTO hrvbib_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","ali nemaju korijena i nestalni su. Čim ih zbog Riječi snađe nevolja ili progonstvo, odmah podlegnu. ");
INSERT INTO hrvbib_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","U trnje zasijano sjeme su oni koji čuju Riječ, ali ju životne brige i zavodljivost bogatstva uguše u njima te ona ne donese roda. ");
INSERT INTO hrvbib_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Dobro tlo je srce čovjeka koji čuje Riječ i razumije ju te ona donese rod—stostruko, šezdeseterostruko ili trideseterostruko veći od posijanoga.” ");
INSERT INTO hrvbib_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Iznese im još jednu prispodobu: “S nebeskim je kraljevstvom kao s čovjekom koji je na svoju njivu posijao dobro sjeme. ");
INSERT INTO hrvbib_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ali dok su svi spavali, došao je njegov neprijatelj, posijao među žito kukolj i otišao. ");
INSERT INTO hrvbib_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Kad je usjev porastao i urodio klasom, pokazao se i kukolj. ");
INSERT INTO hrvbib_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Rataru dođu njegovi sluge i upitaju: ‘Gospodaru, nisi li ti na svojoj njivi posijao dobro sjeme? Odakle onda kukolj?’ ");
INSERT INTO hrvbib_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","‘Neprijatelj je to učinio’, odgovori on. ‘Hoćeš li da počupamo kukolj?’ upitaju. ");
INSERT INTO hrvbib_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","‘Nemojte’, reče im. ‘Čupajući kukolj, mogli biste iščupati i pšenicu. ");
INSERT INTO hrvbib_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Pustite neka oboje raste do žetve. U vrijeme žetve reći ću žeteocima: Pokupite najprije kukolj i svežite ga u snopove da se spali, a žito skupite u moju žitnicu.’” ");
INSERT INTO hrvbib_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Iznese im još jednu prispodobu: “S kraljevstvom je nebeskim kao s gorušičinim sjemenom koje netko posije na svojoj njivi. ");
INSERT INTO hrvbib_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ono je zaista najsitnije od svega sjemenja, ali izraste veće od svake druge biljke u vrtu, razvije se u stablo te se ptice nebeske dolaze gnijezditi u njegovim granama.” ");
INSERT INTO hrvbib_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Zatim im ispriča sljedeću prispodobu: “Nebesko je kraljevstvo poput kvasca koji žena umijesi u golemu količinu brašna, a on ipak sve ukvasi.” ");
INSERT INTO hrvbib_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Isus je sve to govorio narodu u prispodobama. Zapravo im bez prispodoba ništa i nije govorio ");
INSERT INTO hrvbib_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","da bi se ispunilo proročanstvo: “Progovorit ću u prispodobama; otkrit ću ono što je skriveno od postanka svijeta.” ");
INSERT INTO hrvbib_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Isus otpusti mnoštvo i uđe u kuću. Učenici dođu k njemu i zamole ga: “Objasni nam prispodobu o kukolju na njivi.” ");
INSERT INTO hrvbib_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","“Dobro”, reče on. “Sijač dobroga sjemena je Sin Čovječji. ");
INSERT INTO hrvbib_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Njiva je svijet, a dobro sjeme su ljudi koji pripadaju Božjemu kraljevstvu. Kukolj su ljudi koji pripadaju Zlome. ");
INSERT INTO hrvbib_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Neprijatelj koji ga je posijao jest đavao; žetva je svršetak svijeta, a žeteoci su anđeli. ");
INSERT INTO hrvbib_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Kao što se kukolj spaljuje, tako će biti i na svršetku svijeta. ");
INSERT INTO hrvbib_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Sin Čovječji poslat će svoje anđele da iz kraljevstva izdvoje sve koji mame na grijeh i sve koji čine zlo ");
INSERT INTO hrvbib_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","te će ih oni baciti u ognjenu peć. Ondje će biti plač i škrgut zuba. ");
INSERT INTO hrvbib_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Tada će pravednici u kraljevstvu svojega Oca zasjati poput sunca. Slušajte, kad već imate uši!” ");
INSERT INTO hrvbib_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“S nebeskim je kraljevstvom kao s blagom skrivenim u polju. Kad ga pronađe, čovjek ga sakrije pa sav radostan ode prodati sve što ima da kupi to polje.” ");
INSERT INTO hrvbib_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Nadalje, s nebeskim je kraljevstvom kao s trgovcem koji traga za lijepim biserima. ");
INSERT INTO hrvbib_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Kad pronađe dragocjeni biser, ode prodati sve što ima i kupi ga.” ");
INSERT INTO hrvbib_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Nadalje, s nebeskim je kraljevstvom kao s mrežom koja, bačena u more, zahvati svakovrsne ribe. ");
INSERT INTO hrvbib_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Kad se napuni, ribari ju izvuku pa sjednu i pokupe dobre ribe u posude, a loše izbace. ");
INSERT INTO hrvbib_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Tako će biti i o svršetku svijeta. Izići će anđeli, odijeliti zle od pravednika ");
INSERT INTO hrvbib_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","i baciti ih u ognjenu peć gdje će biti plač i škrgut zuba. ");
INSERT INTO hrvbib_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jeste li razumjeli?” upita ih. “Jesmo”, odgovore. ");
INSERT INTO hrvbib_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","On nato reče: “Zato je svaki pismoznanac koji postane učenikom nebeskoga kraljevstva poput domaćina koji iz svoje riznice iznosi i novo i staro.” ");
INSERT INTO hrvbib_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Pošto je ispričao sve te prispodobe, Isus ode odande. ");
INSERT INTO hrvbib_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Otišao je u svoj zavičaj te je u tamošnjoj sinagogi tako poučavao da su ljudi zadivljeni pitali: “Odakle ovomu ta mudrost i sila da čini takva čudesa? ");
INSERT INTO hrvbib_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Nije li ovo drvodjeljin sin? Nije li mu majka Marija, a braća Jakov, Josip, Šimun i Juda? ");
INSERT INTO hrvbib_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Nisu li mu i sve sestre ovdje među nama? Odakle mu onda sve to?” ");
INSERT INTO hrvbib_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","I sablaznili su se zbog njega. Tada im Isus reče: “Proroku ne iskazuju čast jedino u njegovu zavičaju i u njegovu domu.” ");
INSERT INTO hrvbib_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Zbog njihove nevjere ondje nije učinio mnogo čudesa. ");
INSERT INTO hrvbib_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Kad je Herod tetrarh čuo o Isusu, ");
INSERT INTO hrvbib_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","reče svojim slugama: “To je od mrtvih uskrsnuo Ivan Krstitelj pa sad u njemu djeluju čudesne sile.” ");
INSERT INTO hrvbib_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Herod je, naime, Ivana dao uhititi, svezati i baciti u tamnicu na zahtjev Herodijade, žene svojega brata Filipa, ");
INSERT INTO hrvbib_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","jer mu je Ivan govorio: “Ti nemaš prava da je imaš za ženu!” ");
INSERT INTO hrvbib_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Htio je ubiti Ivana, ali se bojao naroda jer su ga smatrali prorokom. ");
INSERT INTO hrvbib_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ali na proslavi Herodova rođendana pred uzvanicima je plesala Herodijadina kćerka i tako se svidjela Herodu ");
INSERT INTO hrvbib_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","da se zakleo dati joj sve što zatraži. ");
INSERT INTO hrvbib_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ona na majčin nagovor reče: “Zapovjedi da mi na pladnju donesu glavu Ivana Krstitelja!” ");
INSERT INTO hrvbib_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Kralj se ražalosti, ali zbog toga što se zakleo i zbog uzvanika zapovjedi da joj učine po volji. ");
INSERT INTO hrvbib_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Pošalje ljude da Ivanu u tamnici odrube glavu. ");
INSERT INTO hrvbib_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Donesu djevojci glavu na pladnju, a ona je pak odnese majci. ");
INSERT INTO hrvbib_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Potom dođu Ivanovi učenici, uzmu njegovo tijelo i pokopaju ga te odu javiti Isusu. ");
INSERT INTO hrvbib_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Kad je Isus to čuo, otplovi odande lađicom na pusto mjesto da se povuče u osamu. Ali narod je to doznao pa su pješice krenuli iz gradova za njim. ");
INSERT INTO hrvbib_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Kad je izišao iz lađice, ugleda silan narod pa se sažali nad njima i izliječi im bolesnike. ");
INSERT INTO hrvbib_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Uvečer mu priđu učenici i kazaše. “Pust je ovo kraj a već je i kasno. Otpusti ljude da mogu otići u sela kupiti hrane!” ");
INSERT INTO hrvbib_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ali Isus odgovori: “Nije potrebno da idu; vi ih nahranite!” ");
INSERT INTO hrvbib_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","“Pa ovdje imamo samo pet kruhova i dvije ribe!” ");
INSERT INTO hrvbib_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","“Donesite ih!” reče. ");
INSERT INTO hrvbib_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Zapovjedi zatim mnoštvu da sjednu na travu. Uzme pet kruhova i dvije ribe, pogleda u nebo te blagoslovi hranu. Razlomi kruh i dade ga učenicima, a učenici su ga dijelili mnoštvu. ");
INSERT INTO hrvbib_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","I svi su jeli dok se nisu nasitili. Zatim pokupe ostatke. Bilo ih je dvanaest punih košara. ");
INSERT INTO hrvbib_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","A nahranilo se pet tisuća muškaraca te žene i djeca koji su bili s njima. ");
INSERT INTO hrvbib_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Odmah zatim Isus natjera učenike da uđu u lađu i da preplove na drugu obalu, dok on otpusti mnoštvo. ");
INSERT INTO hrvbib_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Kad ih je otpustio, popne se u goru da se pomoli u osami. Kasno navečer još je bio sam ondje. ");
INSERT INTO hrvbib_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","U međuvremenu je lađa već bila daleko od obale. Zapuhao je jak protivan vjetar, pa se borila s velikim valovima. ");
INSERT INTO hrvbib_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Oko tri sata ujutro Isus dođe k učenicima hodajući po vodi. ");
INSERT INTO hrvbib_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Kad ugledaju kako hoda po vodi prema njima, vrisnu od straha misleći da je sablast. ");
INSERT INTO hrvbib_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ali Isus im odmah reče: “Samo hrabro! Ja sam! Ne bojte se!” ");
INSERT INTO hrvbib_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Nato mu Petar reče: “Gospodine, ako si ti, zapovjedi da dođem k tebi po vodi!” ");
INSERT INTO hrvbib_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","“Dođi!” odgovori Isus. Petar iziđe iz lađe te hodajući po vodi pođe prema Isusu. ");
INSERT INTO hrvbib_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ali kad je osjetio silinu vjetra, prestraši se i počne tonuti. “Spasi me, Gospodine!” poviče. ");
INSERT INTO hrvbib_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Isus mu odmah pruži ruku i uhvati ga. “Slaba je tvoja vjera”, reče mu. “Zašto si posumnjao?” ");
INSERT INTO hrvbib_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Kad su ušli u lađu, vjetar prestane. ");
INSERT INTO hrvbib_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Učenici u lađi poklone mu se ničice i uzviknu: “Ti si zaista Božji Sin!” ");
INSERT INTO hrvbib_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Preplove jezero i pristanu u Genezaretu. ");
INSERT INTO hrvbib_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ondašnji žitelji ga prepoznaju i po svoj okolici razglase da je došao, pa mu svi počnu dovoditi bolesnike. ");
INSERT INTO hrvbib_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Molili su ga da im dopusti dotaknuti barem skut njegove haljine i svi koji su ga dotaknuli ozdravljali su. ");
INSERT INTO hrvbib_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Isusu pristupe neki farizeji i pismoznanci iz Jeruzalema te ga upitaju: ");
INSERT INTO hrvbib_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Zašto tvoji učenici krše stare židovske predaje? Ne drže se obrednoga pranja ruku prije jela!” ");
INSERT INTO hrvbib_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","On im odgovori: “A zašto vi zbog svoje predaje kršite Božje zapovijedi? ");
INSERT INTO hrvbib_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Bog je rekao: ‘Poštuj oca i majku!’ i ‘Tko prokune oca ili majku, neka se kazni smrću!’ ");
INSERT INTO hrvbib_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ali vi velite: ‘Kaže li tko ocu ili majci: pomoć koju biste od mene dobili darovat ću Bogu’, ");
INSERT INTO hrvbib_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","nije im dužan iskazati poštovanje brinući se o njihovim potrebama. Tako kršite Božju zapovijed zbog svoje predaje. ");
INSERT INTO hrvbib_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Licemjeri! Lijepo je o vama prorokovao Izaija: ");
INSERT INTO hrvbib_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Ovaj me narod štuje samo usnama, ali srce im je daleko od mene. ");
INSERT INTO hrvbib_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Uzalud me štuju jer kao moje učenje poučavaju ljudske zapovijedi.’” ");
INSERT INTO hrvbib_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Dozove tada mnoštvo pa im reče: “Slušajte i pokušajte razumjeti! ");
INSERT INTO hrvbib_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ne onečišćuje čovjeka ono što na usta ulazi, nego ono što izlazi iz njih!” ");
INSERT INTO hrvbib_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Tada mu priđu učenici. “Znaš li da su se farizeji sablaznili na to što si rekao?” upitaju. ");
INSERT INTO hrvbib_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","“Svaka biljka koju nije posadio moj nebeski otac iščupat će se skupa s korijenom. ");
INSERT INTO hrvbib_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Pustite ih! To su slijepi vođe slijepaca! A kad slijepac vodi slijepca, obojica završe u jarku.” ");
INSERT INTO hrvbib_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Petar ga zamoli: “Protumači nam tu prispodobu!” ");
INSERT INTO hrvbib_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","“Zar još ne razumijete?” reče Isus. ");
INSERT INTO hrvbib_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","“Ne shvaćate li: sve što uđe na usta ode u trbuh i izbacuje se u zahod. ");
INSERT INTO hrvbib_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ali zle riječi izlaze iz srca i onečišćuju čovjeka. ");
INSERT INTO hrvbib_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Jer iz srca izviru zle misli, ubojstva, preljubi, blud, krađe, klevete, laži i kletve. ");
INSERT INTO hrvbib_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","To onečišćuje čovjeka! Neće čovjek biti nečist pred Bogom ako jede a da prije toga nije obavio obredno pranje ruku.” ");
INSERT INTO hrvbib_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Isus zatim ode iz Galileje na sjever, u tirski i sidonski kraj. ");
INSERT INTO hrvbib_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Neka žena, Kanaanka, koja je ondje živjela, dođe k njemu i poviče: “Smiluj mi se, Gospodine, Sine Davidov! Kćerka mi je teško opsjednuta!” ");
INSERT INTO hrvbib_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ali Isus joj ne odgovori ni riječi. Nato dođu učenici i zamole ga: “Reci joj da ode jer viče za nama!” ");
INSERT INTO hrvbib_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","On reče: “Poslan sam da pomognem Židovima, izgubljenim ovcama Izraela.” ");
INSERT INTO hrvbib_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ali ona priđe, ničice mu se pokloni i reče: “Gospodine, pomozi mi!” ");
INSERT INTO hrvbib_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","“Nije pravo oduzeti kruh djeci i baciti ga psima”, reče joj. ");
INSERT INTO hrvbib_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","“Nije, Gospodine”, odgovori ona. “Ali i psi pojedu ostatke koji padnu s gospodarova stola!” ");
INSERT INTO hrvbib_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","“Velika je tvoja vjera, ženo!” reče joj Isus. “Neka ti bude što želiš!” I njezina kćerka odmah ozdravi. ");
INSERT INTO hrvbib_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Isus ode odande do Galilejskog jezera, popne se na goru i sjedne. ");
INSERT INTO hrvbib_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","K njemu nagrne silno mnoštvo vodeći sa sobom hrome, kljaste, slijepe, nijeme i druge bolesnike te mu ih polože do nogu, a on ih iscijeli. ");
INSERT INTO hrvbib_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Zadivljeno time što nijemi govore, kljasti ozdravljaju, hromi hodaju a slijepi vide, mnoštvo je slavilo Izraelova Boga. ");
INSERT INTO hrvbib_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Isus pozove učenike i reče im: “Žao mi je ljudi. Već su tri dana sa mnom, a nemaju što jesti. Neću ih otpustiti gladne jer će putem klonuti.” ");
INSERT INTO hrvbib_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Učenici odgovore: “Odakle da u pustinji nabavimo dovoljno hrane za toliko mnoštvo?” ");
INSERT INTO hrvbib_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","“Koliko hrane imate?” upita Isus. “Sedam kruhova i nekoliko ribica”, rekoše. ");
INSERT INTO hrvbib_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Isus zapovjedi mnoštvu da posjeda na zemlju ");
INSERT INTO hrvbib_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","te uzme sedam kruhova i ribe, zahvali Bogu, razlomi ih i dade učenicima. Oni ih razdijele mnoštvu. ");
INSERT INTO hrvbib_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Svi su se do sita najeli i još su ostacima napunili sedam košara. ");
INSERT INTO hrvbib_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","A blagovalo je četiri tisuće muškaraca te žene i djeca koji su bili s njima. ");
INSERT INTO hrvbib_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Isus otpusti narod, uđe u lađu i ode u magadanski kraj. ");
INSERT INTO hrvbib_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","K Isusu dođu farizeji i saduceji. Da bi ga iskušali, zatraže da im pokaže kakav znak s neba. ");
INSERT INTO hrvbib_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","On odgovori: “Vi znate uvečer reći: Bit će lijepo vrijeme jer je nebo crveno. ");
INSERT INTO hrvbib_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","A ujutro kažete: Nebo je mutno i crveno—danas će nevrijeme. Izgled neba znate protumačiti, a znake vremena ne znate! ");
INSERT INTO hrvbib_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Znak traži pokvaren i preljubnički naraštaj, ali neće dobiti drugoga znaka osim Jonina.” Zatim ih ostavi i ode. ");
INSERT INTO hrvbib_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Prelazeći na drugu stranu jezera, učenici zaborave ponijeti kruha. ");
INSERT INTO hrvbib_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","“Budite oprezni!” upozorio ih je Isus. “Čuvajte se farizejskog i saducejskog kvasca!” ");
INSERT INTO hrvbib_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Oni su mislili da im to govori zato što su zaboravili ponijeti kruh. ");
INSERT INTO hrvbib_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Isus je to opazio, pa im reče: “Slaba je vaša vjera! Što ste se zabrinuli jer nemate kruha? ");
INSERT INTO hrvbib_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Zar još ne razumijete? Zar ste zaboravili onih pet kruhova na pet tisuća ljudi i koliko ste još košara skupili? ");
INSERT INTO hrvbib_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","I onih sedam kruhova na četiri tisuće ljudi i košare koje ste nakupili? ");
INSERT INTO hrvbib_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Kako još ne shvaćate da vam ne govorim o kruhu kad kažem: ‘Čuvajte se kvasca farizejskoga i saducejskoga!’?” ");
INSERT INTO hrvbib_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Oni tada shvate da im nije govorio o krušnome kvascu, već o farizejskome i saducejskome učenju. ");
INSERT INTO hrvbib_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Kad je Isus došao u krajeve Filipove Cezareje, upita učenike: “Što ljudi kažu, tko je Sin Čovječji?” ");
INSERT INTO hrvbib_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","“Neki kažu da je Ivan Krstitelj,” odgovore oni, “neki da je Ilija, a neki opet da je Jeremija ili koji drugi prorok.” ");
INSERT INTO hrvbib_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Tada ih upita: “A za koga me vi držite?” ");
INSERT INTO hrvbib_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Šimun Petar odgovori: “Ti si Krist, Mesija, Sin živoga Boga!” ");
INSERT INTO hrvbib_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","“Blago tebi, Šimune, sine Jonin”, reče mu Isus, “jer ti to nije objavio čovjek, nego moj Otac nebeski. ");
INSERT INTO hrvbib_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","A ja tebi kažem: ti si Petar; na toj stijeni izgradit ću svoju Crkvu i vrata paklenai sve sile pakla neće ju nadvladati. ");
INSERT INTO hrvbib_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","I dat ću ti ključeve nebeskog kraljevstva; što god svežeš na zemlji, bit će svezano na nebesima, i što god odriješiš na zemlji, bit će odriješeno na nebesima.” ");
INSERT INTO hrvbib_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Tada strogo zapovjedi učenicima da nikome ne kazuju kako je on Krist. ");
INSERT INTO hrvbib_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Otada Isus počne učenicima otvoreno govoriti o tome kako mora otići u Jeruzalem i ondje mnogo pretrpjeti od starješina, svećeničkih poglavara i pismoznanaca, te kako će ga ubiti i kako će on treći dan uskrsnuti. ");
INSERT INTO hrvbib_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Petar ga nato povede na stranu i počne ga od toga odgovarati: “Ne daj Bože, Gospodine! Ne smije ti se takvo što dogoditi!” ");
INSERT INTO hrvbib_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Isus se okrene prema Petru i reče: “Odlazi od mene, Sotono! Ti si mi zamka jer ne razmišljaš na Božji način, nego ljudski!” ");
INSERT INTO hrvbib_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Tada Isus reče svojim učenicima: “Želi li tko biti mojim sljedbenikom, neka se odrekne samoga sebe, neka uzme svoj križ i neka ide za mnom. ");
INSERT INTO hrvbib_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Jer svatko tko želi sačuvati svoj život izgubit će ga; a tko dade svoj život za mene, naći će ga. ");
INSERT INTO hrvbib_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Kakva ti je korist ako stekneš sav svijet, a izgubiš vječni život? Što se može mjeriti s vrijednošću života? ");
INSERT INTO hrvbib_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Jer ću ja, Sin Čovječji, zaista doći u slavi svojega Oca s anđelima i tada ću suditi svakome prema njegovim djelima. ");
INSERT INTO hrvbib_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Zaista vam kažem, neki među vama koji ste ovdje neće umrijeti prije nego što vide mene, Sina Čovječjega, kako dolazim u kraljevskoj vlasti.” ");
INSERT INTO hrvbib_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Nakon šest dana povede Isus sa sobom Petra, Jakova i njegova brata Ivana visoko u goru, u osamu. ");
INSERT INTO hrvbib_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Tu se pred njima preobrazi: lice mu zasja poput sunca, a haljine mu postanu bijele poput svjetlosti. ");
INSERT INTO hrvbib_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Uto se pojave Mojsije i Ilija i počnu razgovarati s Isusom. ");
INSERT INTO hrvbib_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Petar reče: “Gospodine, dobro je što smo ovdje! Ako hoćeš, napravit ću ovdje tri sjenice: jednu za tebe, jednu za Mojsija i jednu za Iliju.” ");
INSERT INTO hrvbib_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Dok je to još govorio, prekrije ih svijetao oblak, a iz njega se začuje glas: “Ovo je moj ljubljeni Sin, moja radost! Njega slušajte!” ");
INSERT INTO hrvbib_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Silno prestrašeni, učenici popadaju licem prema zemlji. ");
INSERT INTO hrvbib_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Isus im priđe, dotakne ih i reče: “Ustanite! Ne bojte se!” ");
INSERT INTO hrvbib_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Oni podignu pogled, ali nisu vidjeli nikoga osim Isusa. ");
INSERT INTO hrvbib_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Dok su silazili s gore, Isus im zapovjedi da nikome ne govore što su vidjeli sve dok Sin Čovječji ne uskrsne od mrtvih. ");
INSERT INTO hrvbib_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Učenici ga upitaju: “Zašto pismoznanci tvrde da prije Mesije mora doći Ilija?” ");
INSERT INTO hrvbib_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Isus odgovori: “Ilija nesumnjivo najprije mora doći i sve opet staviti na svoje mjesto. ");
INSERT INTO hrvbib_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ali vam kažem da je Ilija već došao, ali ga nisu prepoznali pa su s njim postupili kako im se prohtjelo. I Sin Čovječji će također trpjeti od njihovih ruku.” ");
INSERT INTO hrvbib_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Učenici tada shvate da im je to govorio o Ivanu Krstitelju. ");
INSERT INTO hrvbib_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Kad su stigli do mnoštva, Isusu pristupi neki čovjek, padne pred njim na koljena ");
INSERT INTO hrvbib_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","i reče: “Gospodine, smiluj se mojemu sinu jer je padavičar i teško trpi. Često padne u vatru ili u vodu. ");
INSERT INTO hrvbib_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Doveo sam ga tvojim učenicima, ali ga oni nisu mogli izliječiti.” ");
INSERT INTO hrvbib_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","“Nevjerni i opaki rode!” reče Isus. “Koliko dugo još moram biti s vama? Dokle vas moram podnositi? Dovedite mi ga!” ");
INSERT INTO hrvbib_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Tada zaprijeti zloduhu te on iziđe iz dječaka koji istog časa ozdravi. ");
INSERT INTO hrvbib_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Zatim učenici nasamo upitaju Isusa: “Zašto mi nismo mogli istjerati tog zloduha?” ");
INSERT INTO hrvbib_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","“Zbog svoje nevjere”, reče im on. “Zaista vam kažem, da imate vjere kao je sitno gorušičino zrno i da kažete ovoj gori: Premjesti se onamo!—ona bi se premjestila. Ništa vam ne bi bilo nemoguće.” ");
INSERT INTO hrvbib_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Kad su se skupili u Galileji, Isus im reče: “Sin Čovječji bit će predan ljudima u ruke. ");
INSERT INTO hrvbib_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ubit će ga, ali on će treći dan uskrsnuti.” Učenici se silno ražaloste. ");
INSERT INTO hrvbib_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Kad su stigli u Kafarnaum, pristupe Petru ubirači hramskoga poreza i upitaju ga: “Zar vaš učitelj ne plaća porez?” ");
INSERT INTO hrvbib_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","“Plaća!” odgovori Petar. Zatim uđe u kuću, a Isus ga presretne pitanjem: “Što misliš, Šimune, ubiru li zemaljski kraljevi porez ili carinu od svojih ili od tuđih sinova?” ");
INSERT INTO hrvbib_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Kad on odgovori: “Od tuđih”, Isus mu reče: “Sinovi su, dakle, oslobođeni. ");
INSERT INTO hrvbib_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ali da ih ne sablaznimo, pođi k moru i baci udicu. Prvoj ribi koju uhvatiš otvori usta, pa ćeš unutra naći novčić. Uzmi ga pa im njime plati za mene i za sebe.” ");
INSERT INTO hrvbib_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","U taj čas dođu k Isusu učenici te ga zapitaju: “Tko je najveći u nebeskom kraljevstvu?” ");
INSERT INTO hrvbib_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Isus pozove malo dijete pa ga postavi u sredinu između njih ");
INSERT INTO hrvbib_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","i reče: “Zaista vam kažem, ako se ne obratite i ne postanete poput male djece, nećete ući u nebesko kraljevstvo! ");
INSERT INTO hrvbib_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","U nebeskome je kraljevstvu, dakle, najveći onaj tko se ponizi kao ovo malo dijete. ");
INSERT INTO hrvbib_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Tko zaradi mene prihvati ovakvo dijete, mene prihvaća. ");
INSERT INTO hrvbib_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ali tko jednoga od ovih malenih koji vjeruju u mene navede da posrne u vjeri, bilo bi mu bolje da mu o vrat objese mlinski kamen i da potone u morsku dubinu. ");
INSERT INTO hrvbib_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Teško svijetu jer navodi ljude na grijeh! Napast na zlo je neizbježna, ali teško čovjeku kroz kojega dolazi napast. ");
INSERT INTO hrvbib_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Navodi li te na grijeh vlastita ruka ili noga, odsijeci ju i baci. Bolje da u život uđeš kljast ili hrom nego da s objema rukama i s objema nogama budeš bačen u vječni oganj. ");
INSERT INTO hrvbib_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Navodi li te na grijeh vlastito oko, iskopaj ga i baci! Bolje da jednook uđeš u život nego da s oba oka budeš bačen u ognjeni pakao. ");
INSERT INTO hrvbib_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Pazite da ne prezrete nijednoga od ovih malenih. Jer kažem vam da njihovi anđeli na nebu neprestano gledaju lice mojega Oca, koji je na nebesima. ( ");
INSERT INTO hrvbib_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","A ja, Sin Čovječji, došao sam spasiti izgubljene.)” ");
INSERT INTO hrvbib_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Što mislite, da netko ima sto ovaca i da jedna od njih zaluta, neće li ostaviti onih devedeset devet u gorama i poći potražiti zalutalu? ");
INSERT INTO hrvbib_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Zaista vam kažem, ako ju uspije naći, više će se radovati što je pronašao tu jednu ovcu nego što ih devedeset devet nije zalutalo. ");
INSERT INTO hrvbib_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Tako ni vaš nebeski Otac ne želi da se izgubi i propadne ijedan od ovih malenih.” ");
INSERT INTO hrvbib_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Ako ti brat zgriješi, ukori ga nasamo. Posluša li te, zadobio si brata. ");
INSERT INTO hrvbib_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ako te ne posluša, povedi sa sobom još jednoga ili dvojicu braće da se kazna za svaki prekršaj mora temeljiti na iskazu dvojice ili trojice svjedoka. ");
INSERT INTO hrvbib_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ne posluša li ni njih, reci Crkvi. Ako ne posluša ni Crkvu, smatraj ga poganinom i ubiračem poreza. ");
INSERT INTO hrvbib_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Zaista vam kažem, što god svežete na zemlji, bit će svezano na nebu i što god odriješite na zemlji, bit će odriješeno na nebu. ");
INSERT INTO hrvbib_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Također vam kažem: ako dvojica od vas na zemlji jednodušno zamole bilo što, moj će im nebeski Otac to dati. ");
INSERT INTO hrvbib_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Jer gdje se dvojica ili trojica sastanu zaradi mene, tu sam i ja s njima.” ");
INSERT INTO hrvbib_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Tada mu priđe Petar i upita: “Gospodine, koliko puta da oprostim bratu koji je zgriješio protiv mene? Do sedam puta?” ");
INSERT INTO hrvbib_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","“Ne sedam puta,” odgovori mu Isus, “već sedamdeset puta sedam! ");
INSERT INTO hrvbib_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Nebesko je kraljevstvo kao kad kralj odluči izravnati račune sa slugama. ");
INSERT INTO hrvbib_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Kad su počeli obračunavati, dovedu mu jednoga koji mu je dugovao tristo tona zlata. ");
INSERT INTO hrvbib_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Kako nije mogao vratiti, kralj zapovjedi da se prodaju on, žena, djeca i sve što imaju te da se tako podmiri dug. ");
INSERT INTO hrvbib_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Sluga nato padne ničice pred njim i zamoli: ‘Imaj strpljenja sa mnom i sve ću ti vratiti!’ ");
INSERT INTO hrvbib_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Kralj se sažali nad njim, oslobodi ga i oprosti mu dug. ");
INSERT INTO hrvbib_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ali kad taj sluga iziđe, susretne prijatelja koji je njemu dugovao malo novca. Ščepa ga za vrat i počne ga daviti govoreći: ‘Vrati što si dužan!’ ");
INSERT INTO hrvbib_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Prijatelj klekne pred njega i zamoli: ‘Imaj sa mnom strpljenja i vratit ću ti!’ ");
INSERT INTO hrvbib_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ali njegov vjerovnik nije htio pričekati, nego ode i baci ga u tamnicu dok ne vrati dug. ");
INSERT INTO hrvbib_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Kad su njegovi prijatelji vidjeli što se dogodilo, silno se ražaloste te odu sve ispričati kralju. ");
INSERT INTO hrvbib_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Nato ga kralj pozove i reče mu: ‘Zli slugo! Ja sam tebi oprostio sav dug jer si me zamolio! ");
INSERT INTO hrvbib_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Nisi li se i ti trebao smilovati svojemu prijatelju kao što sam se ja tebi smilovao?’ ");
INSERT INTO hrvbib_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","I gnjevni ga kralj preda mučiteljima dok ne vrati sav dug. ");
INSERT INTO hrvbib_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Tako će i moj nebeski Otac postupiti s vama ne oprostite li svojemu bratu od sveg srca.” ");
INSERT INTO hrvbib_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Kad je Isus završio s govorom, ode iz Galileje u Judeju s istočne strane rijeke Jordana. ");
INSERT INTO hrvbib_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Za njim je pošlo silno mnoštvo te ih je on ondje iscjeljivao. ");
INSERT INTO hrvbib_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Priđu mu neki farizeji pa ga upitaju pokušavajući ga zaskočiti: “Smije li se muž razvesti od žene zbog bilo kojeg razloga?” ");
INSERT INTO hrvbib_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","On odgovori: “Niste li u Pismu čitali da ih je Stvoritelj na početku stvorio ‘muškim i ženskim’ ");
INSERT INTO hrvbib_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","i da je rekao: ‘Čovjek će ostaviti oca i majku da bi se sjedinio sa svojom ženom, i njih će dvoje biti jedno tijelo’? ");
INSERT INTO hrvbib_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Njih dvoje, prema tome, nisu više dva, nego jedno. Neka dakle nijedan čovjek ne rastavlja one koje je Bog sjedinio!” ");
INSERT INTO hrvbib_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","“Zašto je onda Mojsije rekao da muž treba ženi samo napisati otpusnicu pa se može razvesti?” upitaju. ");
INSERT INTO hrvbib_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Isus im odgovori: “Mojsije je učinio taj ustupak da možete otpustiti svoju ženu zbog vaših tvrdih srca, ali u početku nije bilo tako. ");
INSERT INTO hrvbib_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ali ja vam kažem: Tko god se razvede od svoje žene, osim zbog njezina bluda—pa se oženi drugom, čini preljub.” ");
INSERT INTO hrvbib_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Nato će Isusovi učenici: “Ako je između muža i žene tako, onda je bolje ne ženiti se!” ");
INSERT INTO hrvbib_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","“Ne mogu to razumjeti svi, nego samo oni kojima je dano”, reče im Isus. ");
INSERT INTO hrvbib_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","“Ima ljudi koji su od rođenja nesposobni za ženidbu, ima ih koje su ljudi za to onesposobili, a neki se dragovoljno odriču ženidbe zaradi nebeskoga kraljevstva. Tko može shvatiti, neka shvati!” ");
INSERT INTO hrvbib_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Tada mu dovodili djecu da na njih stavi ruke i da se pomoli. Učenici su im to priječili. ");
INSERT INTO hrvbib_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Isus im nato reče: “Pustite dječicu k meni i ne tjerajte ih jer takvima pripada nebesko kraljevstvo!” ");
INSERT INTO hrvbib_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Položi na njih ruke, a zatim ode odande. ");
INSERT INTO hrvbib_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Priđe mu neki čovjek i upita: “Učitelju, koje dobro moram činiti da bih zadobio vječni život?” ");
INSERT INTO hrvbib_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Isus mu reče: “Zašto me pitaš o dobrome? Samo je jedan dobar—Bog! Ali ako želiš ući u život, ispunjaj zapovijedi!” ");
INSERT INTO hrvbib_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","“Koje?” upita on. Isus odgovori: “Ne ubij”, “Ne čini preljub”, “Ne ukradi”, “Ne svjedoči lažno”, ");
INSERT INTO hrvbib_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","“Poštuj oca i majku i ljubi bližnjega svoga kao samoga sebe!” ");
INSERT INTO hrvbib_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","“Sve sam to činio”, reče mu mladić. “Što mi još nedostaje?” ");
INSERT INTO hrvbib_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","“Želiš li biti savršenim,” odgovori Isus, “idi i prodaj sve što imaš, a novac razdijeli siromasima pa ćeš imati blago na nebu. Onda dođi i slijedi me!” ");
INSERT INTO hrvbib_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Kad je mladić to čuo, se ražalosti i ode jer je imao veliki imetak. ");
INSERT INTO hrvbib_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Isus nato reče učenicima: “Zaista vam kažem, teško je bogatašu ući u nebesko kraljevstvo! ");
INSERT INTO hrvbib_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","I opet vam kažem: Lakše bi devi bilo provući se kroz iglenu ušicu nego bogatašu ući u Božje kraljevstvo!” ");
INSERT INTO hrvbib_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Učenici se zaprepaste. “Pa tko se onda uopće može spasiti?” pitali su. ");
INSERT INTO hrvbib_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Isus ih pozorno pogleda pa reče: “Ljudima je to potpuno nemoguće, ali ne i Bogu. Ali Bogu je sve moguće!” ");
INSERT INTO hrvbib_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Tada mu Petar reče: “Evo, mi smo sve ostavili da te slijedimo. Što ćemo za to dobiti?” ");
INSERT INTO hrvbib_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Isus odgovori: “Zaista vam kažem, kada ja, Sin Čovječji, sjednem o obnovi svijeta na svoje slavno prijestolje, vi ćete sjesti na dvanaest prijestolja i suditi dvanaest Izraelovih plemena. ");
INSERT INTO hrvbib_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","A svatko tko zaradi mene ostavi kuću, ili braću, ili sestre, ili oca, ili majku, ili ženu, ili djecu, ili njive, primit će stostruko i baštiniti vječni život. ");
INSERT INTO hrvbib_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ali mnogi koji su sada prvi tada će biti na zadnjemu mjestu, a mnogi koje ovdje smatraju zadnjima ondje će biti najveći.” ");
INSERT INTO hrvbib_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Jer s nebeskim je kraljevstvom kao s vinogradarom koji rano ujutro iziđe unajmiti radnike za vinograd. ");
INSERT INTO hrvbib_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Pogodi se s radnicima za uobičajenu nadnicu i pošalje ih u vinograd. ");
INSERT INTO hrvbib_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Oko devet sati ponovno prođe trgom i ugleda druge da stoje besposleni ");
INSERT INTO hrvbib_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","te i njima reče: ‘Idite i vi raditi u moj vinograd pa ću vam platiti koliko bude pravedno.’ ");
INSERT INTO hrvbib_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","U podne i oko tri sata učini isto. ");
INSERT INTO hrvbib_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","A kad je opet izišao na trg u pet sati popodne, ondje nađe još radnika. ‘Zašto stojite i besposličarite?’ upita ih. ");
INSERT INTO hrvbib_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","‘Jer nas nitko nije unajmio’, odgovore mu. ‘Idite onda i vi raditi u moj vinograd’, reče im. ");
INSERT INTO hrvbib_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Uvečer reče predradniku: ‘Pozovi radnike i plati im: najprije onima koji su zadnji došli, a onda onima koji su prvi počeli raditi.’ ");
INSERT INTO hrvbib_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Radnici unajmljeni u pet sati dobili su punu nadnicu. ");
INSERT INTO hrvbib_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Nato oni koji su prvi došli raditi pomisle da će dobiti više, ali i oni prime jednako. ");
INSERT INTO hrvbib_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Odmah počnu prigovarati vinogradaru: ");
INSERT INTO hrvbib_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Ovi zadnji radili su samo uru vremena, a ti si im platio jednako kao nama koji smo cijeli dan teško radili i trpjeli žegu!’ ");
INSERT INTO hrvbib_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Jednome od njih on odgovori: ‘Prijatelju, nisam nepravedan prema tebi. Nisi li se pogodio sa mnom za toliko? ");
INSERT INTO hrvbib_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Uzmi svoje i odlazi. A ja želim ovomu zadnjemu dati koliko i tebi. ");
INSERT INTO hrvbib_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Nemam li pravo s vlastitim novcem činiti što me volja? Ili si zavidan što sam dobar prema njima?’ ");
INSERT INTO hrvbib_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Oni koji su sada prvi tada će biti na zadnjemu mjestu, a oni koje ovdje smatraju zadnjima ondje će biti najveći.” ");
INSERT INTO hrvbib_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Putujući prema Jeruzalemu, Isus povede Dvanaestoricu nasamo te im reče: ");
INSERT INTO hrvbib_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Evo, ulazimo u Jeruzalem. Tamo će Sina Čovječjega predati svećeničkim glavarima i pismoznancima, koji će ga osuditi na smrt ");
INSERT INTO hrvbib_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","i predati Rimljanima da mu se izruguju, da ga bičuju i da ga raspnu. Ali treći dan će uskrsnuti.” ");
INSERT INTO hrvbib_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Tada dođe majka Zebedejevih sinova Jakova i Ivana skupa sa sinovima te mu se ničice pokloni da ga nešto zamoli. ");
INSERT INTO hrvbib_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","“Što želiš?” upita ju Isus. Ona reče: “Zapovjedi da moji sinovi u tvojemu kraljevstvu sjednu pokraj tebe, jedan zdesna, a drugi slijeva.” ");
INSERT INTO hrvbib_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Isus odgovori: “Ne znate što tražite. Možete li vi ispiti gorku čašu iz koje ću ja piti?” “Možemo!” odgovore oni. ");
INSERT INTO hrvbib_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","A on reče: “Zaista ćete piti iz moje čaše, ali nije na meni da odredim tko će sjediti meni slijeva ili zdesna. Ta su mjesta za one kojima ih je pripravio moj Otac.” ");
INSERT INTO hrvbib_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Kad su to čula ostala desetorica učenika, naljute se na braću. ");
INSERT INTO hrvbib_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Zato ih Isus dozove k sebi i reče: “Vi znate da vladari svijeta okrutno postupaju s narodom i da moćnici nad njim vladaju stegom. ");
INSERT INTO hrvbib_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Neće tako biti među vama! Naprotiv, tko želi biti najveći među vama, neka vam bude sluga. ");
INSERT INTO hrvbib_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Tko želi biti najveći od svih, neka vam bude robom. ");
INSERT INTO hrvbib_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Jer ni Sin Čovječji nije došao da mu služe, već da on služi drugima i dade svoj život kao otkupninu za mnoge.” ");
INSERT INTO hrvbib_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Kad su Isus i učenici izlazili iz grada Jerihona, za njim je pošlo silno mnoštvo. ");
INSERT INTO hrvbib_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Kraj puta su sjedila dvojica slijepaca. Kad su čuli da Isus prolazi, povikali su: “Gospodine, sine Davidov, smiluj nam se!” ");
INSERT INTO hrvbib_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ljudi su ih stišavali, ali oni poviču još glasnije: “Gospodine, sine Davidov, smiluj nam se!” ");
INSERT INTO hrvbib_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Kad Isus to začuje, zaustavi se, pozove ih i upita: “Što hoćete da vam učinim?” ");
INSERT INTO hrvbib_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","“Da progledamo, Gospodine!” rekoše. ");
INSERT INTO hrvbib_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Isus se sažali nad njima i dotakne im oči. Oni smjesta progledaju i krenu za Isusom. ");
INSERT INTO hrvbib_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Kad su se Isus i učenici približili Jeruzalemu te stigli pred Betfagu na Maslinskoj gori, Isus pošalje naprijed dvojicu učenika. ");
INSERT INTO hrvbib_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“Idite u selo pred vama”, reče im, “i čim u njega uđete, ugledat ćete vezanu magaricu i magare. Odvežite ih i dovedite k meni. ");
INSERT INTO hrvbib_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Upita li vas tko zbog toga, recite samo: ‘Gospodinu trebaju’ pa će ih odmah pustiti.” ");
INSERT INTO hrvbib_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","To se dogodilo da se ispuni proročanstvo: ");
INSERT INTO hrvbib_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Recite izraelskomu narodu: Evo, dolazi tvoj Kralj, ponizan jaše na magarcu, na magaretu, mladomu magaričinu.” ");
INSERT INTO hrvbib_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Učenici odu i učine kako ih je Isus uputio. ");
INSERT INTO hrvbib_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Dovedu magaricu i magare, prekriju ih svojim ogrtačima, pa Isus sjedne na njih. ");
INSERT INTO hrvbib_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Silno je mnoštvo prostiralo svoje ogrtače po putu, a neki su trgali grane s drveća i prostirali ih putem. ");
INSERT INTO hrvbib_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ljudi koji su išli pred njim i za njim klicali su: “Slava Sinu Davidovu! Blagoslovljen koji dolazi u ime Gospodnje! Slava Bogu na nebu!” ");
INSERT INTO hrvbib_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Kad je ušao u Jeruzalem, cijeli se grad uskomešao. “Tko je taj?” pitali su. ");
INSERT INTO hrvbib_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Mnoštvo je odgovaralo: “To je Isus, prorok iz Nazareta u Galileji.” ");
INSERT INTO hrvbib_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Isus uđe u Hram i počne iz njega izgoniti sve trgovce i njihove kupce, prevrne stolove mjenjačima novca i klupe prodavačima goluba. ");
INSERT INTO hrvbib_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","“U Svetome pismu piše: ‘Moj Hram treba biti molitveni dom’, a vi ste ga pretvorili u razbojničku špilju!” ");
INSERT INTO hrvbib_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","U Hramu mu priđu slijepi i hromi te ih on iscijeli. ");
INSERT INTO hrvbib_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Kad su svećenički poglavari i pismoznanci vidjeli čudesa koja je učinio i čuli djecu u Hramu kako kliču: “Slava Sinu Davidovu!” razgnjeve se ");
INSERT INTO hrvbib_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","i upitaju ga: “Čuješ li ti što govore?” “Čujem”, odgovori im Isus. “A niste li nikad u Pismu pročitali: ‘Pripravio si sebi hvalu iz usta djece i dojenčadi’?” ");
INSERT INTO hrvbib_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Zatim se vrati u Betaniju da ondje prespava. ");
INSERT INTO hrvbib_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Vraćajući se ujutro u Jeruzalem, Isus ogladni. ");
INSERT INTO hrvbib_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Opazi pokraj puta smokvu i priđe joj, ali na njoj ne nađe ničega osim lišća. Nato joj reče: “Ne bilo više nikada na tebi roda!” I smokva se smjesta osuši. ");
INSERT INTO hrvbib_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Učenici se zaprepaste. “Kako se smokva tako brzo sasušila?” pitali su. ");
INSERT INTO hrvbib_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","“Zaista vam kažem,” odgovori im Isus, “budete li imali vjere i ne budete li sumnjali, činit ćete ne samo to što sam ja učinio sa smokvom nego kažete li ovoj planini: ‘Digni se i baci se u more!’—to će se i dogoditi. ");
INSERT INTO hrvbib_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Sve što s vjerom zamolite, primit ćete.” ");
INSERT INTO hrvbib_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Isus ode u Hram. Dok je ondje poučavao, priđu mu svećenički poglavari i narodni starješine pa ga upitaju: “Tko ti je dao pravo da to činiš? Tko te je ovlastio za to?” ");
INSERT INTO hrvbib_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Isus im odgovori: “Reći ću vam tko ako najprije vi meni odgovorite na pitanje: ");
INSERT INTO hrvbib_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Je li Ivanovo krštenje bilo s neba ili od ljudi?” Oni počnu umovati i međusobno raspravljati: “Ako kažemo da je s neba, pitat će nas zašto mu onda nismo vjerovali. ");
INSERT INTO hrvbib_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","A od mnoštva nas je strah reći da je bilo od ljudi jer Ivana svi drže za proroka.” ");
INSERT INTO hrvbib_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Zato Isusu odgovore: “Ne znamo.” A Isus im reče: “Onda ni ja vama neću reći otkuda mi vlast!” ");
INSERT INTO hrvbib_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Što mislite o ovomu: Neki je čovjek imao dva sina. Reče prvomu: ‘Sine, idi danas raditi u vinogradu!’ ");
INSERT INTO hrvbib_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","‘Neću!’ odgovori on, ali se poslije predomisli i ode. ");
INSERT INTO hrvbib_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Otac i drugome sinu reče isto. ‘Idem, oče!’ odgovori sin, ali se zatim predomisli i odustane. ");
INSERT INTO hrvbib_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Koji je od njih dvojice ispunio očevu volju?” “Onaj prvi”, odgovore. Isus im nato reče: “Zaista vam kažem, bludnice i ubirači poreza ući će prije vas u Božje kraljevstvo! ");
INSERT INTO hrvbib_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Jer Ivan Krstitelj došao vam je pokazati put pravednosti, ali mu niste povjerovali, a bludnice i ubirači poreza jesu. Pa čak ni kad ste to vidjeli, niste se pokajali i vjerovali mu.” ");
INSERT INTO hrvbib_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Poslušajte još jednu prispodobu. Neki čovjek posadi vinograd i ogradi ga, iskopa tijesak za grožđe i izgradi kulu. Zatim ga iznajmi vinogradarima i otputuje. ");
INSERT INTO hrvbib_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Kad dođe vrijeme berbe, pošalje sluge da uzmu njegov dio uroda. ");
INSERT INTO hrvbib_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ali vinogradari ih pograbe te jednoga pretuku, drugoga ubiju, a trećega kamenuju. ");
INSERT INTO hrvbib_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","On zatim pošalje više slugu nego prvi put, ali vinogradari i s njima jednako postupe. ");
INSERT INTO hrvbib_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Naposljetku pošalje k njima svojega sina misleći: ‘Prema mojem sinu sigurno će se odnositi s poštovanjem.’ ");
INSERT INTO hrvbib_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ali kad vinogradari ugledaju sina, rekoše: ‘Ovaj će naslijediti imanje. Ubijmo ga pa ćemo se domognuti imanja umjesto njega!’ ");
INSERT INTO hrvbib_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Pograbe ga, izbace iz vinograda i ubiju.” ");
INSERT INTO hrvbib_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Isus ih upita: “Što mislite, kako će vlasnik imanja postupiti s tim vinogradarima kada se vrati?” ");
INSERT INTO hrvbib_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Oni mu odgovorili: “Te će zlikovce bez smilovanja pogubiti, a vinograd iznajmiti drugima koji će mu davati urod kad za to dođe vrijeme.” ");
INSERT INTO hrvbib_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Isus ih upita: “Niste li nikada čitali u Svetom pismu: ‘Kamen koji su graditelji odbacili postane ugaonim kamenom. To je Gospodnje djelo, čudesno u našim očima.’? ");
INSERT INTO hrvbib_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Zato vam kažem, oduzet će vam se Božje kraljevstvo i dat će se narodu koji će davati njegove plodove. ");
INSERT INTO hrvbib_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Padne li tko na taj kamen, smrskat će se, i padne li kamen na koga, satrt će ga.” ");
INSERT INTO hrvbib_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Kad su svećenički poglavari i farizeji čuli te prispodobe i shvatili da govori o njima, ");
INSERT INTO hrvbib_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","htjeli su ga uhvatiti, ali bojali su se mnoštva koje je Isusa smatralo prorokom. ");
INSERT INTO hrvbib_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Isus im opet počne govoriti u prispodobama. ");
INSERT INTO hrvbib_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“S nebeskim je kraljevstvom kao kad neki kralj pripravi svadbu svojemu sinu. ");
INSERT INTO hrvbib_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Pošalje sluge da pozovu uzvanike na svadbu, ali oni odbiju poziv. ");
INSERT INTO hrvbib_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Pošalje druge sluge i reče: ‘Recite uzvanicima: Pripremio sam vam gozbu. Ispekli smo najslasnije meso. Sve je spremno. Dođite na svadbu!’ ");
INSERT INTO hrvbib_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ali oni nisu marili te odu svaki za svojim poslom—jedni na svoju njivu, drugi u trgovinu. ");
INSERT INTO hrvbib_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ostali uhvate sluge, premlate ih i ubiju. ");
INSERT INTO hrvbib_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Nato se kralj razgnjevi, pošalje vojsku i smakne ubojice te im zapali grad. ");
INSERT INTO hrvbib_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","A slugama reče: ‘Svadbena je gozba, eto, spremna, ali uzvanici je nisu bili dostojni. ");
INSERT INTO hrvbib_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Idite zato na putove i raskrižja i pozovite na svadbu koga god nađete!’ ");
INSERT INTO hrvbib_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Sluge iziđu na putove i dovedu sve koje su mogli naći: i zle i dobre. I svadbena se dvorana napuni gostima. ");
INSERT INTO hrvbib_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Ali kad kralj uđe pogledati goste, spazi ondje čovjeka koji nije bio odjeven u prikladnu odjeću za svadbu. ");
INSERT INTO hrvbib_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","‘Prijatelju,’ upita ga, ‘kako si ušao ovamo bez svadbenog ruha?’ Čovjek je samo šutio. ");
INSERT INTO hrvbib_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Tada kralj zapovjedi poslužiteljima: ‘Svežite mu ruke i noge i izbacite ga u tamu gdje će biti plač i škrgut zuba. ");
INSERT INTO hrvbib_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Jer mnogi su pozvani, ali je malo izabranih.’” ");
INSERT INTO hrvbib_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Tada se farizeji sastanu zaradi dogovora kako da Isusa uhvate u riječi. ");
INSERT INTO hrvbib_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Odluče mu poslati neke svoje učenike skupa s herodovcima da ga upitaju: “Učitelju, znamo da govoriš istinu i da si nepristran jer ne gledaš tko je tko, nego prema istini poučavaš putu Božjemu. ");
INSERT INTO hrvbib_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Reci nam je li dopušteno plaćati porez caru ili nije.” ");
INSERT INTO hrvbib_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Isus prozre njihovu opakost pa reče: “Zašto me kušate, licemjeri? ");
INSERT INTO hrvbib_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Pokažite mi kovani novac pa ću vam reći.” Donesu mu novčić, ");
INSERT INTO hrvbib_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","a on upita: “Čiji su ovo lik i natpis na kovanici?” ");
INSERT INTO hrvbib_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","“Carevi”, odgovore. “Onda dajte caru carevo, ali Bogu valja dati Božje”, reče im. ");
INSERT INTO hrvbib_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Kad su to čuli, zadive se pa ga ostave i odu. ");
INSERT INTO hrvbib_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Toga dana dođu k njemu saduceji, koji tvrde da nema uskrsnuća, i upitaju ga: ");
INSERT INTO hrvbib_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Gospodine, Mojsije nam je dao zakon prema kojemu, umre li oženjen muškarac bez djece, njegov brat mora oženiti njegovom udovicom kako bi ona rodila sina koji će naslijediti posjed umrloga i nositi njegovo ime. ");
INSERT INTO hrvbib_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Bila su tako u nas sedmorica braće. Prvi od njih se oženio i umro a da nije imao djece, pa je njegova udovica postala ženom drugoga brata. ");
INSERT INTO hrvbib_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Drugi i treći također su umrli, i tako sva sedmorica. ");
INSERT INTO hrvbib_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Na posljetku umre i žena. ");
INSERT INTO hrvbib_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Čija će onda ona biti žena o uskrsnuću kad je bila udana za svu sedmoricu?” ");
INSERT INTO hrvbib_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Isus im odgovori: “U zabludi ste jer ne razumijete Sveto pismo ni Božju silu! ");
INSERT INTO hrvbib_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Jer o uskrsnuću se neće ni ženiti ni udavati, već će biti kao anđeli na nebu. ");
INSERT INTO hrvbib_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","A glede uskrsnuća, niste li u Pismu pročitali da je Bog rekao: ");
INSERT INTO hrvbib_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Ja sam Bog Abrahamov, Izakov i Jakovljev’ dugo nakon što su oni poumirali? A Bog nije Bog mrtvih, već Bog živih!” ");
INSERT INTO hrvbib_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Kad je mnoštvo to čulo, ostalo je zadivljeno njegovim učenjem. ");
INSERT INTO hrvbib_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Kad su farizeji čuli kako je Isus ušutkao saduceje, pođu skupa k njemu ");
INSERT INTO hrvbib_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","te ga jedan od njih, zakonoznanac, upita da ga iskuša: ");
INSERT INTO hrvbib_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Učitelju, koja je najveća zapovijed u Zakonu?” ");
INSERT INTO hrvbib_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","“‘Ljubi Gospodina Boga svojega svim srcem svojim, svom dušom svojom i svom pameti svojom!’ ");
INSERT INTO hrvbib_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","To je prva i najveća zapovijed. ");
INSERT INTO hrvbib_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Druga, jednako važna, glasi: ‘Ljubi svojega bližnjega kao samoga sebe!’ ");
INSERT INTO hrvbib_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Sve druge zapovijedi i svi zahtjevi proroka proizlaze iz tih dviju zapovijedi.” ");
INSERT INTO hrvbib_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Kad su se okupili farizeji, Isus ih upita: ");
INSERT INTO hrvbib_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Što mislite o Kristu? Čiji je on sin?” “Davidov”, odgovore. ");
INSERT INTO hrvbib_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","On ih upita: “A zašto ga onda David, nadahnut Svetim Duhom, naziva Gospodinom kad kaže: ");
INSERT INTO hrvbib_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Gospodin je rekao mojem Gospodinu: Sjedni mi s desne strane dok ti ne bacim pod noge tvoje neprijatelje’? ");
INSERT INTO hrvbib_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Dakle, ako ga sâm David je nazvao Gospodinom, kako bi mu onda mogao biti sin?” ");
INSERT INTO hrvbib_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Nitko mu nije znao odgovoriti ni riječi. Od toga dana nitko ga se više nije usudio išta pitati. ");
INSERT INTO hrvbib_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Tada Isus reče mnoštvu i svojim učenicima: ");
INSERT INTO hrvbib_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Pismoznanci i farizeji službeni su tumači Svetoga pisma. ");
INSERT INTO hrvbib_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Zato činite i slušajte sve što vam kažu, ali nemojte slijediti njihov primjer jer oni sami ne čine ono što druge poučavaju. ");
INSERT INTO hrvbib_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Tlače vas teškim teretom vjerskih zahtjeva, a ni prstom ne žele maknuti da vam taj teret pomognu nositi. ");
INSERT INTO hrvbib_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Sve što čine, čine zato da ih ljudi vide. Trude se da ono što na sebi nose u znak pobožnosti—kutijice sa stihovima iz Svetoga pisma na čelu ili oko ruke te rese na odjeći—bude što veće i što duže. ");
INSERT INTO hrvbib_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Na gozbama vole sjediti na pročelju stola, a u sinagogama na počasnome mjestu. ");
INSERT INTO hrvbib_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Godi im kad ih ljudi pozdravljaju na javnim mjestima i kad ih zovu ‘Učitelju’. ");
INSERT INTO hrvbib_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Vi nikome nemojte dopustiti da vas zove učiteljem jer imate samo jednoga učitelja, a svi ste vi ravnopravna braća i sestre. ");
INSERT INTO hrvbib_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","I ne zovite nikoga ovdje na zemlji Ocem jer imate samo jednoga Oca—onoga na nebesima. ");
INSERT INTO hrvbib_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","I ne dajte da vas tko naziva vođom jer imate samo jednoga vođu: Krista. ");
INSERT INTO hrvbib_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Tko je najveći među vama, neka vam bude sluga! ");
INSERT INTO hrvbib_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Tko sebe uzvisuje, bit će ponižen, a ponizni će biti uzvišeni. ");
INSERT INTO hrvbib_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Teško vama, pismoznanci i farizeji! Licemjeri! Zatvarate pred ljudima vrata u nebesko kraljevstvo. Sami ne ulazite u njega, a ne dopuštate da uđu ni oni koji bi htjeli. ");
INSERT INTO hrvbib_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Teško vama, pismoznanci i farizeji! Licemjeri! Obilazite morem i kopnom da biste pridobili jednog sljedbenika, a kad vam postane sljedbenikom, učinite od njega sina paklenoga dvostruko gorega nego što ste i sami! ");
INSERT INTO hrvbib_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Teško vama! Slijepi vođe! Tvrdite: ‘Zakune li se tko Hramom, to ne vrijedi. Ali zakune li se hramskim zlatom, onda ga zakletva obvezuje.’ ");
INSERT INTO hrvbib_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Slijepe budale! Pa što je veće—zlato ili Hram koji posvećuje zlato? ");
INSERT INTO hrvbib_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","I još kažete: ‘Zakune li se tko žrtvenikom, to ne vrijedi. Ali zakune li se darom koji je na njemu, zakletva ga obvezuje.’ ");
INSERT INTO hrvbib_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Slijepci! Što je veće? Žrtveni dar ili žrtvenik koji ga posvećuje? ");
INSERT INTO hrvbib_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Tko se zakune žrtvenikom, kune se njime i svime što je na njemu. ");
INSERT INTO hrvbib_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","A tko se zakune Hramom, kune se njime i Onime koji u njemu prebiva. ");
INSERT INTO hrvbib_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Tko se zakune nebom, kune se Božjim prijestoljem i Bogom koji na njemu sjedi. ");
INSERT INTO hrvbib_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Teško vama, pismoznanci i farizeji! Licemjeri! Jer revno namirujete čak i desetinu metvice, i kopra, i kima, a zanemarujete ono najvažnije u Zakonu: pravednost, milosrđe i vjernost. Treba davati desetinu, ali ne smijete zanemarivati važnije stvari. ");
INSERT INTO hrvbib_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Slijepi vođe! Procjeđujete vodu da ne biste s njom popili i komarca, a kadri ste, ne opazivši, progutati i cijelu devu! ");
INSERT INTO hrvbib_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Teško vama, pismoznanci i farizeji! Licemjeri! Toliko se trudite očistiti svoju čašu i zdjelu izvana, a napunili ste ih svojim grabežom i pohlepom. ");
INSERT INTO hrvbib_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Slijepi farizeju! Očisti najprije ono što je u čaši, pa će i izvana biti čista. ");
INSERT INTO hrvbib_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Teško vama, pismoznanci i farizeji! Vi ste poput obijeljenih grobova. Izvana izgledaju lijepo, a iznutra su prepuni mrtvačkih kostiju i svakojake prljavštine! ");
INSERT INTO hrvbib_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Tako i vi ljudima izvana izgledate pravednima, a iznutra ste prepuni licemjerja i bezakonja. ");
INSERT INTO hrvbib_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Teško vama, pismoznanci i farizeji! Licemjeri! Vi prorocima gradite grobnice i pravednicima kitite spomenike ");
INSERT INTO hrvbib_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","pa kažete: ‘Da smo živjeli u doba svojih otaca, ne bismo sudjelovali u prolijevanju proročke krvi.’ ");
INSERT INTO hrvbib_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Tako sami protiv sebe svjedočite da ste sinovi onih koji su ubijali proroke. ");
INSERT INTO hrvbib_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Dovršite, dakle, to što su oni započeli! ");
INSERT INTO hrvbib_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Zmije! Leglo zmijsko! Kako ćete izbjeći osudi pakla? ");
INSERT INTO hrvbib_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Šaljem vam, evo, proroke, mudrace i pismoznance. Neke ćete od njih ubiti i raspeti, druge bičevati po sinagogama i progoniti od grada do grada ");
INSERT INTO hrvbib_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","tako da na vas padne sva pravedna krv prolivena na zemlji, od krvi pravednog Abela pa do krvi Zaharije, sina Barahijina, kojega ste ubili između Hrama i žrtvenika. ");
INSERT INTO hrvbib_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Zaista vam kažem, sva će ta krv pasti na ovaj naraštaj!” ");
INSERT INTO hrvbib_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Jeruzaleme, Jeruzaleme, koji ubijaš proroke i kamenuješ Božje poslanike! Koliko sam puta htio okupiti tvoju djecu kao što kvočka skuplja piliće pod krila, ali niste htjeli! ");
INSERT INTO hrvbib_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","A sada će ti, eto, kuća biti napuštena. ");
INSERT INTO hrvbib_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","I kažem vam, nećete me više vidjeti sve dok ne uzviknete: ‘Blagoslovljen koji dolazi u ime Gospodnje!’” ");
INSERT INTO hrvbib_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Kad je Isus izišao ih Hrama i pošao dalje, priđu mu učenici da mu pokažu hramsko zdanje. ");
INSERT INTO hrvbib_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","A on im reče: “Vidite li sve to? Zaista vam kažem, neće od ovoga ostati ni kamen na kamenu. Svaki će biti razvaljen.” ");
INSERT INTO hrvbib_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Kad je poslije sjedio na Maslinskoj gori, učenici mu priđu i nasamo kažu: “Reci nam kada će se to dogoditi. Koji će znak najaviti tvoj dolazak i svršetak svijeta?” ");
INSERT INTO hrvbib_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","“Pazite da vas tko ne zavede!” odgovori im Isus. ");
INSERT INTO hrvbib_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","“Mnogi će doći pod mojim imenom, proglašujući se Mesijom, i mnoge će zavesti. ");
INSERT INTO hrvbib_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Kad čujete da blizu vas izbijaju ratovi i vijesti o dalekim ratovima, ne uznemirujte se. Sve se to mora dogoditi, ali svršetak još neće doći. ");
INSERT INTO hrvbib_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Zaratit će narod protiv naroda i kraljevstvo protiv kraljevstva. Bit će potresa u mnogim dijelovima svijeta i zavladat će glad. ");
INSERT INTO hrvbib_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Sve je to samo početak strašnih muka. ");
INSERT INTO hrvbib_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Tada će vas mučiti i ubijati. Svi će vas narodi zamrziti zato što ste moji. ");
INSERT INTO hrvbib_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Mnogi će tada posrnuti u vjeri, izdavat će jedan drugoga i mrziti se. ");
INSERT INTO hrvbib_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Pojavit će se brojni lažni proroci i mnoge će zavesti. ");
INSERT INTO hrvbib_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Bezakonje će uzeti velikog maha, a ljubav mnogih će ohladnjeti. ");
INSERT INTO hrvbib_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ali tko ustraje do kraja, spasit će se. ");
INSERT INTO hrvbib_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Radosna vijest o kraljevstvu propovijedat će se po cijelome svijetu da čuju svi narodi, a onda će konačno doći svršetak. ");
INSERT INTO hrvbib_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Tako kada vidite ‘svetogrđe’ o kojemu je pisao prorok Daniel gdje stoji na svetomu mjestu (čitatelju, shvati o čemu je riječ!), ");
INSERT INTO hrvbib_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","neka oni koji se zateknu u Judeji bježe u goru. ");
INSERT INTO hrvbib_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Tko se zatekne na krovu, neka ne silazi u kuću što uzeti! ");
INSERT INTO hrvbib_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Tko se zatekne u polju, neka se ne vraća po ogrtač! ");
INSERT INTO hrvbib_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Teško trudnicama i dojiljama u to vrijeme! ");
INSERT INTO hrvbib_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Molite se da ne morate bježati zimi ili u subotu ");
INSERT INTO hrvbib_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","jer će to biti dani tako strašnih nevolja kakvih nije bilo od postanka svijeta niti će biti ikad poslije. ");
INSERT INTO hrvbib_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","I da Gospodin ne skrati to vrijeme nevolja, nitko se ne bi spasio. Ali zaradi svojih izabranika ti će se dani skratiti. ");
INSERT INTO hrvbib_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Kaže li vam tada tko: ‘Evo Mesije!’ ili ‘Eno ga ondje!’ ne vjerujte ");
INSERT INTO hrvbib_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","jer će ustati brojni lažni mesije i lažni proroci te činiti znamenja i velika čudesa ne bi li, bude li moguće, zaveli i Božje izabranike. ");
INSERT INTO hrvbib_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Eto, unaprijed sam vas upozorio! ");
INSERT INTO hrvbib_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Kaže li vam dakle tko: ‘Eno ga, u pustinji je’, ne idite onamo, kaže li ‘U tajnim je odajama’, ne vjerujte. ");
INSERT INTO hrvbib_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Jer dolazak Sina Čovječjega vidjet će se poput munje koja sijevne na istoku i rasvijetli cijelo nebo, sve do zapada. ");
INSERT INTO hrvbib_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Gdje bude strvine, skupljat će se strvinari. ");
INSERT INTO hrvbib_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","U vrijeme kad prođu sve te strahote ‘Sunce će potamnjeti i mjesec neće sjati, zvijezde će s neba padati i nebeske će se sile potresti.’ ");
INSERT INTO hrvbib_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Tada će se na nebu pojaviti znak Sina Čovječjega. Proplakat će tada svi narodi na zemlji i ugledati Sina Čovječjega kako dolazi na oblacima s velikom moći i slavom. ");
INSERT INTO hrvbib_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","On će poslati anđele na zov velike trublje da saberu njegove izabranike sa svih strana, sa svih četiriju vjetrova, od kraja zemlje do kraja neba. ");
INSERT INTO hrvbib_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Učite iz prispodobe o smokvi. Kad joj na granama izbiju nježni pupovi i kad potjera lišće, znate da je ljeto blizu. ");
INSERT INTO hrvbib_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Također, kad vidite da se zbiva sve o čemu sam vam govorio, možete biti sigurni da je Gospodinov povratak blizu, na samim vratima. ");
INSERT INTO hrvbib_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Zaista vam kažem, ovaj naraštaj neće proći dok se sve to ne dogodi. ");
INSERT INTO hrvbib_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Nebo i zemlja će proći, ali moje riječi ostaju zauvijek! ");
INSERT INTO hrvbib_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Nitko, međutim, ne zna dana ni ure kada će se to dogoditi. Ne znaju ni anđeli na nebu, pa čak ni Sin. Zna samo Otac. ");
INSERT INTO hrvbib_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Za dolaska Sina Čovječjega bit će kao i u Noino doba. ");
INSERT INTO hrvbib_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Kao što su u to vrijeme prije potopa ljudi jeli i pili, ženili se i udavali sve do dana kada je Noa ušao u korablju ");
INSERT INTO hrvbib_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","i ništa nisu slutili dok nije došao potop i sve ih odnio, tako će biti i za dolaska Sina Čovječjega. ");
INSERT INTO hrvbib_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Od dvojice koji tada budu skupa radili u polju jedan će se uzeti, a drugi ostaviti. ");
INSERT INTO hrvbib_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Od dviju žena koje budu skupa mljele u mlinu jedna će se uzeti, a druga ostaviti. ");
INSERT INTO hrvbib_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Bdijte, dakle, jer ne znate kada će vaš Gospodin doći! ");
INSERT INTO hrvbib_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Znajte: kad bi vlasnik kuće znao kada će doći lopov, bdio bi i ne bi mu dopustio da provali u kuću. ");
INSERT INTO hrvbib_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Budite zato i vi stalno pripravni jer će Sin Čovječji doći kad mu se i ne nadate. ");
INSERT INTO hrvbib_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Tko je dakle onaj vjerni i razumni sluga kojega je gospodar postavio da upravlja ukućanima i da im daje hranu u pravo vrijeme? ");
INSERT INTO hrvbib_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Blago onome koga gospodar, kada dođe, nađe da tako čini! ");
INSERT INTO hrvbib_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Zaista vam kažem, povjerit će mu da upravlja svim njegovim imanjem. ");
INSERT INTO hrvbib_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ali ako zli sluga pomisli: ‘Gospodar se još neće vratiti’ ");
INSERT INTO hrvbib_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","pa počne tući svoje sudrugove te jesti i piti s pijancima, ");
INSERT INTO hrvbib_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","gospodar će doći u dan kad mu se ne nada i u čas u koji neće ni slutiti. ");
INSERT INTO hrvbib_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Nemilosrdno će ga kazniti i odrediti mu usud među licemjerima, gdje će biti plač i škrgut zuba.” ");
INSERT INTO hrvbib_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Tada će s nebeskim kraljevstvom biti kao kad je deset djevica uzelo svjetiljke i pošlo u susret zaručniku. ");
INSERT INTO hrvbib_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Pet ih je bilo budalastih, a pet mudrih. ");
INSERT INTO hrvbib_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Budalaste djevice ponesu svjetiljke, ali ne i ulja. ");
INSERT INTO hrvbib_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","A mudre su skupa sa svjetiljkama ponijele i posude s uljem. ");
INSERT INTO hrvbib_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Kako je zaručnik kasnio, sve one poliježu i zaspu. ");
INSERT INTO hrvbib_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","U ponoć se začula vika: ‘Zaručnik stiže! Iziđite pred njega!’ ");
INSERT INTO hrvbib_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Sve djevice ustanu da prirede svjetiljke. ");
INSERT INTO hrvbib_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Budalaste tada zamole mudre: ‘Dajte nam od svojega ulja jer nam svjetiljke trnu.’ ");
INSERT INTO hrvbib_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ali one im odgovore: ‘Nipošto! Sigurno nema dovoljno i za vas i za nas. Pođite ga radije kupiti.’ ");
INSERT INTO hrvbib_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Kad su ga otišle kupiti, dođe zaručnik te one koje su bile pripravne uđu s njim na svadbu i vrata se zatvore. ");
INSERT INTO hrvbib_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Poslije dođu i ostale djevice i stanu dozivati: ‘Gospodine! Gospodine, otvori nam!’ ");
INSERT INTO hrvbib_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","ali on će odgovoriti: ‘Zaista vam kažem: Ne poznajem vas.’ ");
INSERT INTO hrvbib_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Stoga bdijte jer ne znate dan ni čas mojega dolaska! ");
INSERT INTO hrvbib_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Tada će s nebeskim kraljevstvom biti kao s čovjekom koji je, polazeći na put, pozvao sluge i povjerio im svoj imetak. ");
INSERT INTO hrvbib_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Jednomu je dao pet vreća zlatnika, drugomu dvije, a trećemu jednu—svakome prema sposobnostima. Zatim je otputovao. ");
INSERT INTO hrvbib_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Sluga koji je primio pet vreća zlatnika odmah ode, uloži ih i zaradi još pet vreća. ");
INSERT INTO hrvbib_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Sluga s dvjema vrećama zlatnika također zaradi još dvije. ");
INSERT INTO hrvbib_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Sluga koji je dobio samo jednu, naprotiv, iskopa rupu u zemlji i u nju skrije gospodarov novac. ");
INSERT INTO hrvbib_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Poslije dugog vremena gospodar se vrati i zatraži od slugu da mu polože račun. ");
INSERT INTO hrvbib_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Onaj kojemu je povjerio pet vreća zlatnika donese i drugih pet. ‘Gospodaru, dao si mi pet vreća zlatnika. Zaradio sam, eto, još pet.’ ");
INSERT INTO hrvbib_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Gospodar mu nato reče: ‘Odlično, dobri i vjerni slugo! Bio si vjeran nad malim i zato ću te postaviti nad velikim. Dođi se radovati sa svojim gospodarom!’ ");
INSERT INTO hrvbib_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Zatim priđe sluga koji je primio dvije vreće zlatnika i reče: ‘Gospodaru, meni si dao dvije vreće. Zaradio sam još dvije.’ ");
INSERT INTO hrvbib_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Gospodar mu reče: ‘Odlično, dobri i vjerni slugo! Bio si vjeran nad malim i zato ću te postaviti nad velikim. Dođi se radovati sa svojim gospodarom!’ ");
INSERT INTO hrvbib_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Priđe zatim sluga koji je primio jednu vreću te reče: ‘Gospodaru! Znao sam da si strog čovjek, da žanješ gdje nisi sijao i kupiš gdje nisi vijao. ");
INSERT INTO hrvbib_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Zato sam se prestrašio i skrio tvoju vreću u zemlju. Evo, uzmi ju!’ ");
INSERT INTO hrvbib_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ali gospodar mu reče: ‘Zli i lijeni slugo! Znao si da žanjem gdje nisam sijao i kupim gdje nisam vijao? ");
INSERT INTO hrvbib_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Trebao si onda barem uložiti moj novac u banku pa bih nakon povratka dobio kamate. ");
INSERT INTO hrvbib_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Oduzmite mu novac i dajte ga onome koji ima deset vreća zlatnika! ");
INSERT INTO hrvbib_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Tko ima, dat će mu se još pa će obilovati, a onome tko nema oduzet će se i ono što ima. ");
INSERT INTO hrvbib_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Bacite beskorisnoga slugu van u tamu. Ondje će biti plač i škrgut zuba.’” ");
INSERT INTO hrvbib_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Kad Sin Čovječji dođe u slavi i sa svim svojim anđelima, sjest će na prijestolje svoje slave. ");
INSERT INTO hrvbib_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Tada će se svi narodi okupiti pred njime, a on će, kao što pastir odvaja ovce od koza, ");
INSERT INTO hrvbib_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","pravednike postaviti sebi zdesna, a ostale s lijeve strane. ");
INSERT INTO hrvbib_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Tada će kralj reći onima koji mu budu zdesna: ‘Vi, koje je Otac blagoslovio, dođite primiti u baštinu kraljevstvo pripravljeno za vas od postanka svijeta! ");
INSERT INTO hrvbib_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Jer ste me nahranili kad sam bio gladan, napojili kad sam bio žedan, primili ste me kad sam bio tuđinac ");
INSERT INTO hrvbib_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","i obukli me kad sam bio gol; posjećivali ste me dok sam bio bolestan i u zatvoru.’ ");
INSERT INTO hrvbib_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Pravednici će ga tada upitati: ‘Gospodine, kada smo te vidjeli gladna i nahranili, kada smo te vidjeli žedna i napojili te? ");
INSERT INTO hrvbib_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Kada smo ti pružili dobrodošlicu kao tuđincu i obukli te gola? ");
INSERT INTO hrvbib_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Kada smo te posjetili bolesna ili u tamnici?’ ");
INSERT INTO hrvbib_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","A kralj će odgovoriti: ‘Zaista vam kažem, sve što ste učinili jednomu od moje najmanje braće, meni ste učinili!’ ");
INSERT INTO hrvbib_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Zatim će reći onima slijeva: ‘Odlazite od mene, prokleti, u vječni oganj pripravljen za đavla i njegove anđele! ");
INSERT INTO hrvbib_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Jer bio sam gladan, a niste mi dali jesti; bio sam žedan, a niste mi dali piti; ");
INSERT INTO hrvbib_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","bio sam tuđinac, a vi me niste primili; gol sam bio i niste me obukli; bio sam bolestan i u zatvoru, a niste me posjetili.’ ");
INSERT INTO hrvbib_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Oni će pitati: ‘Gospodine, kad smo te to vidjeli gladna ili žedna, ili kao tuđinca, ili gola, ili bolesna, ili u zatvoru i nismo ti pomogli?’ ");
INSERT INTO hrvbib_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","A on će im odgovoriti: ‘Zaista vam kažem, sve što niste učinili jednomu od ovih najmanjih, meni niste učinili!’ ");
INSERT INTO hrvbib_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Tako će oni otići u vječnu patnju, a pravednici u vječni život.” ");
INSERT INTO hrvbib_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Kad je Isus sve to ispripovjedio, reče učenicima: ");
INSERT INTO hrvbib_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Znate da je za dva dana Pasha i da će mene, Sina Čovječjega, izdati da me raspnu.” ");
INSERT INTO hrvbib_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Tada se svećenički poglavari i narodne starješine okupe u dvoru velikog svećenika imenom Kajfa ");
INSERT INTO hrvbib_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","te se dogovore da Isusa na prijevaru uhvate i ubiju. ");
INSERT INTO hrvbib_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","“Nećemo na blagdansku svetkovinu”, rekli su, “da se narod ne pobuni.” ");
INSERT INTO hrvbib_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Dok je Isus bio u Betaniji za stolom u kući Šimuna gubavca, ");
INSERT INTO hrvbib_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","dođe k njemu neka žena s alabasternom posudom skupocjene pomasti i izlije mu je na glavu. ");
INSERT INTO hrvbib_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Videći to, učenici počnu negodovati: “Čemu takva rastrošnost! ");
INSERT INTO hrvbib_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Mogla se ta pomast skupo prodati, a novac dati siromasima.” ");
INSERT INTO hrvbib_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Isus to opazi pa im reče: “Zašto joj dodijavate? Učinila mi je dobro djelo! ");
INSERT INTO hrvbib_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Uvijek će biti siromaha, a ja neću uvijek biti s vama. ");
INSERT INTO hrvbib_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Izlila je tu pomast na mene da pripravi moje tijelo za ukop. ");
INSERT INTO hrvbib_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Zaista vam kažem, gdje god se diljem svijeta bude propovijedala ova Radosna vijest, spominjat će se i ovo njezino djelo, njoj na uspomenu.” ");
INSERT INTO hrvbib_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Tada Juda Iškariotski, jedan od Dvanaestorice, ode svećeničkim poglavarima ");
INSERT INTO hrvbib_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","te ih upita: “Koliko ćete mi platiti da vam izdam Isusa?” Oni mu obećaju trideset srebrnjaka. ");
INSERT INTO hrvbib_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Od tada Juda počne tražiti prigodu da ga izda. ");
INSERT INTO hrvbib_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Na prvi dan Blagdana beskvasnih kruhova učenici upitaju Isusa: “Gdje želiš da ti pripravimo pashalnu večeru?” ");
INSERT INTO hrvbib_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","“Idite u grad tom i tom čovjeku”, odgovori on, “pa mu recite: ‘Naš učitelj poručuje: Moje je vrijeme blizu. Kod tebe ću blagovati Pashu sa svojim učenicima.’” ");
INSERT INTO hrvbib_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Učenici učine kako ih je Isus uputio te ondje pripreme pashalnu večeru. ");
INSERT INTO hrvbib_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Uvečer je Isus bio za stolom s Dvanaestoricom. ");
INSERT INTO hrvbib_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Dok su blagovali, on reče: “Zaista vam kažem, jedan od vas će me izdati!” ");
INSERT INTO hrvbib_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Oni se silno ražaloste pa ga jedan za drugim počnu pitati: “Nisam valjda ja taj, Gospodine?” ");
INSERT INTO hrvbib_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","On odgovori: “Izdat će me onaj koji sa mnom umače kruh u istu zdjelu. ");
INSERT INTO hrvbib_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Jer ja, Sin Čovječji, moram umrijeti kao što piše u Svetome pismu. Ali teško onome koji izda Sina Čovječjega! Bilo bi mu bolje da se nije ni rodio!” ");
INSERT INTO hrvbib_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","I izdajnik Juda ga upita: “Učitelju, da nisam ja taj?” A Isus mu reče: “Sam si kazao.” ");
INSERT INTO hrvbib_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Dok su blagovali, Isus uzme kruh, blagoslovi ga, razlomi te podijeli učenicima govoreći: “Uzmite i jedite! To je moje tijelo.” ");
INSERT INTO hrvbib_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Zatim uzme čašu vina, zahvali Bogu i pruži njima govoreći: “Svi pijte iz nje! ");
INSERT INTO hrvbib_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ovo je moja krv, krv novoga Saveza, koja se prolijeva za oproštenje grijeha mnogih ljudi. ");
INSERT INTO hrvbib_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","I kažem vam: Neću više piti vina sve do onoga dana kada ću piti s vama novo vino u kraljevstvu svojega Oca.” ");
INSERT INTO hrvbib_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Otpjevaju zatim psalme i zapute se prema Maslinskoj gori. ");
INSERT INTO hrvbib_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Tada im Isus reče: “Noćas ćete me svi napustiti, jer u Svetome pismu piše: ‘Udarit ću pastira i ovce će se razbježati.’ ");
INSERT INTO hrvbib_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ali kada uskrsnem, ići ću pred vama u Galileju.” ");
INSERT INTO hrvbib_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Petar mu reče: “Napuste li te svi ostali, ja te neću napustiti!” ");
INSERT INTO hrvbib_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","“Zaista ti kažem,” reče mu Isus, “još ove noći, prije nego što pijetao zakukuriče, triput ćeš me se odreći.” ");
INSERT INTO hrvbib_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","“Neću!” odvrati Petar. “Makar morao s tobom i umrijeti, neću te se odreći!” Tako su se zaklinjali i svi ostali. ");
INSERT INTO hrvbib_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Isus dođe s učenicima u maslinik nazvan Getsemani te reče učenicima: “Sjednite ovdje dok se ja odem pomoliti!” ");
INSERT INTO hrvbib_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Povede sa sobom Petra i obojicu Zebedejevih sinova. Obuzmu ga žalost i tjeskoba. ");
INSERT INTO hrvbib_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Tada im reče: “Duša mi je nasmrt shrvana tugom. Ostanite ovdje i bdijte sa mnom.” ");
INSERT INTO hrvbib_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ode malo dalje i padne ničice moleći se: “Oče moj! Ako je moguće, poštedi me ove čaše! Ipak, neka bude po tvojoj, a ne po mojoj volji.” ");
INSERT INTO hrvbib_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Zatim se vrati trojici učenika i nađe ih spavati te reče Petru: “Niste li mogli ni ure probdjeti sa mnom? ");
INSERT INTO hrvbib_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ostanite budni i molite se da vas ne bi svladala kušnja! Jer duh je spreman, ali je tijelo slabo.” ");
INSERT INTO hrvbib_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ode još jedanput i pomoli se: “Oče moj! Ako nije moguće da me poštediš te čaše, neka bude po tvojoj, a ne po mojoj volji.” ");
INSERT INTO hrvbib_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","I opet ih po povratku nađe spavati jer su im oči otežale. ");
INSERT INTO hrvbib_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Opet ih ostavi i ode se treći put pomoliti istim riječima. ");
INSERT INTO hrvbib_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Zatim se vrati k učenicima i reče im: “Još spavate i odmarate se? Kucnuo je čas! Sin Čovječji, predan je grešnicima u ruke. ");
INSERT INTO hrvbib_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ustanite! Hajdemo! Evo, moj je izdajnik već tu!” ");
INSERT INTO hrvbib_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Dok je još govorio, stigne Juda, jedan od Dvanaestorice, a s njime i svjetina naoružana mačevima i toljagama, koju su poslali svećenički poglavari i narodni starješine. ");
INSERT INTO hrvbib_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Izdajica im je dao znak: “To je onaj kojega poljubim. Uhvatite ga.” ");
INSERT INTO hrvbib_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","On odmah priđe Isusu i reče: “Zdravo, Učitelju!” i poljubi ga. ");
INSERT INTO hrvbib_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","“Zašto si došao ovamo, prijatelju?” ukori ga Isus. Zatim podignu ruke na Isusa i uhvate ga. ");
INSERT INTO hrvbib_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","A jedan od onih koji su bili s Isusom maši se rukom te izvuče mač i njime odsiječe uho sluzi velikoga svećenika. ");
INSERT INTO hrvbib_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","“Vrati mač u korice”, reče mu Isus, “jer tko se mača laća, od mača će i poginuti. ");
INSERT INTO hrvbib_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Zar ne shvaćaš da mogu tražiti od Oca više od dvanaest legija anđela da nas zaštite i on bi ih odmah poslao? ");
INSERT INTO hrvbib_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ali da to učinim, kako bi se ispunilo Sveto pismo?” ");
INSERT INTO hrvbib_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Zatim reče svjetini: “Pošli ste na mene mačevima i toljagama kao na prevratnika! A svaki dan sam sjedio u Hramu i poučavao, pa me ipak niste uhvatili. ");
INSERT INTO hrvbib_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ali sve se ovo događa zato da bi se ispunilo ono što su o meni u Pismu napisali proroci.” Nato ga svi učenici napuste i pobjegnu. ");
INSERT INTO hrvbib_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Isusa uhvate i odvedu ga velikomu svećeniku Kajfi kod kojega su se okupili pismoznanci i starješine. ");
INSERT INTO hrvbib_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Petar je izdaleka slijedio Isusa do dvorišta palače velikog svećenika. On uđe u dvorište te sjedne sa slugama da vidi kako će sve to završiti. ");
INSERT INTO hrvbib_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Unutra su svećenički poglavari i cijelo Veliko vijeće tražili su protiv Isusa kakvo lažno svjedočanstvo na temelju kojega bi ga mogli smaknuti. ");
INSERT INTO hrvbib_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ali nisu ga mogli pronaći iako su se javili mnogi lažni svjedoci. Napokon dođu dvojica ");
INSERT INTO hrvbib_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","i izjave: “Ovaj je rekao: ‘Mogu srušiti Božji hram i za tri dana ga opet izgraditi!’” ");
INSERT INTO hrvbib_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Veliki svećenik zatim stane i upita Isusa: “Zar ništa ne odgovaraš na ove optužbe protiv tebe?” ");
INSERT INTO hrvbib_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Isus je šutio. “Zakuni se živim Bogom i reci jesi li ti Krist, Božji Sin”, reče veliki svećenik. ");
INSERT INTO hrvbib_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","“Sam si rekao”, odgovori Isus. “A ja vam kažem da ćete gledati Sina Čovječjega kako sjedi zdesna Svemogućemu i kako dolazi na nebeskim oblacima.” ");
INSERT INTO hrvbib_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Nato veliki svećenik razdere svoju odjeću i reče: “Hulio je na Boga! Što će nam još svjedoci? ");
INSERT INTO hrvbib_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Što kažete?” A oni odgovore: “Zaslužio je smrt!” ");
INSERT INTO hrvbib_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Zatim su Isusu pljuvali u lice i tukli ga. Neki su ga pljuskali ");
INSERT INTO hrvbib_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","govoreći: “Proreci nam tko te je udario, Kriste!” ");
INSERT INTO hrvbib_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Dok je Petar sjedio vani u dvorištu, priđe mu neka sluškinja i reče: “I ti si bio s Isusom Galilejcem!” ");
INSERT INTO hrvbib_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Petar to pred svima zaniječe: “Ne znam o čemu govoriš!” ");
INSERT INTO hrvbib_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Kad je izišao u predvorje, spazi ga druga sluškinja i reče nazočnima: “Ovaj je bio s Isusom Nazarećaninom!” ");
INSERT INTO hrvbib_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","On opet zaniječe i još se zakune: “Ne poznajem tog čovjeka!” ");
INSERT INTO hrvbib_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ali ubrzo mu priđu ljudi koji su bili ondje. “Pa ti si doista jedan od njih! Odaje te galilejski naglasak.” ");
INSERT INTO hrvbib_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Petar se stane kleti i zaklinjati: “Ja ne poznajem tog čovjeka!” I pijetao odmah zakukuriče. ");
INSERT INTO hrvbib_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","On se tada sjeti što mu je Isus rekao: “Zaista ti kažem, prije nego što pijetao zakukuriče, triput ćeš me se odreći.” Iziđe iz dvorišta i gorko zaplače. ");
INSERT INTO hrvbib_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Rano ujutro sastanu se na vijećanje svi svećenički poglavari i narodne starješine da se dogovore kako da ubiju Isusa. ");
INSERT INTO hrvbib_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Svežu ga i odvedu rimskome upravitelju Pilatu. ");
INSERT INTO hrvbib_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Kada je Juda, njegov izdajica, vidio da su Isusa osudili na smrt, pokaje se i odnese trideset srebrnjaka natrag svećeničkim poglavarima i starješinama ");
INSERT INTO hrvbib_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","te im reče: “Zgriješio sam! Izdao sam nedužna čovjeka!” “Što se to nas tiče?” odgovore mu oni. “To je tvoja stvar!” ");
INSERT INTO hrvbib_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Juda nato baci srebrnjake u Hram, a zatim ode i objesi se. ");
INSERT INTO hrvbib_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Svećenički poglavari pokupe srebrnjake. “Ne smijemo ih staviti u hramsku blagajnu”, rekoše, “jer su isplaćeni za krvavo djelo.” ");
INSERT INTO hrvbib_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Zato se dogovore te za njih kupe lončarovu njivu da posluži kao groblje za ukop tuđinaca. ");
INSERT INTO hrvbib_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Zato se ta njiva još zove “Krvava njiva”. ");
INSERT INTO hrvbib_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Tako se ispunilo Jeremijino proročanstvo: “Uzeli su trideset srebrnjaka— na toliko su ga procijenili Izraelci— ");
INSERT INTO hrvbib_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","i kupili su lončarovu njivu, kako je Gospodin zapovjedio.” ");
INSERT INTO hrvbib_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Isusa dovedu pred rimskoga upravitelja Pilata. On ga upita: “Jesi li ti kralj Židova?” “Ti to kažeš”, odgovori mu Isus. ");
INSERT INTO hrvbib_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Svećenički ga poglavari optuže za mnoge zločine, ali Isus nije odgovarao. ");
INSERT INTO hrvbib_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pilat ga stoga upita: “Zar ne čuješ kako te teško optužuju?” ");
INSERT INTO hrvbib_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ali Isus ne odgovori ni na jedno pitanje, što je Pilata veoma začudilo. ");
INSERT INTO hrvbib_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Bio je, međutim, običaj da rimski upravitelj svake godine o blagdanu Pashe pusti na slobodu jednoga židovskog zatvorenika kojega narod zatraži. ");
INSERT INTO hrvbib_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","U to je vrijeme jedan od zatvorenika bio zloglasni Baraba. ");
INSERT INTO hrvbib_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Kad se mnoštvo okupilo da zatraži da se pusti jedan zatvorenik, Pilat ih upita: “Koga hoćete da vam pustim? Barabu ili Isusa kojega nazivaju Mesijom?” ");
INSERT INTO hrvbib_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Znao je, naime, da su ga predali sudu iz zavisti. ");
INSERT INTO hrvbib_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Dok je Pilat sjedio na sudačkom stolcu, stigne mu poruka od njegove žene: “Okani se tog pravednika jer sam se noćas u snu namučila zbog njega!” ");
INSERT INTO hrvbib_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Svećenički poglavari i starješine, međutim, nagovore svjetinu da zatraži slobodu za Barabu, a smrt za Isusa. ");
INSERT INTO hrvbib_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Kad ih je zatim upravitelj upitao: “Koga od njih dvojice želite da vam pustim?” oni odgovore: “Barabu!” ");
INSERT INTO hrvbib_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","“A što ću onda s Isusom kojega zovete Mesijom?” upita. “Raspni ga!” poviču oni. ");
INSERT INTO hrvbib_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","“Zbog čega? Kakvo je zlo učinio?” upita Pilat. Ali oni su samo još glasnije vikali: “Raspni ga!” ");
INSERT INTO hrvbib_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Kad je Pilat vidio da ništa ne koristi i da metež postaje sve gori, uzme vodu i pred svjetinom opere ruke govoreći: “Ja sam nevin od krvi ovoga čovjeka! Vi ćete za nju snositi odgovornost!” ");
INSERT INTO hrvbib_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Nato sva svjetina poviče: “Neka njegova krv padne na nas i na našu djecu!” ");
INSERT INTO hrvbib_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Pilat im tada pusti Barabu, a Isusa dade izbičevati, pa raspeti. ");
INSERT INTO hrvbib_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Upraviteljevi vojnici odvedu Isusa u pretorij i sazovu oko njega cijelu četu. ");
INSERT INTO hrvbib_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Svuku ga i zaogrnu grimiznim plaštem. ");
INSERT INTO hrvbib_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Spletu zatim krunu od trnja i stave mu je na glavu, a u ruku mu stave trsku kao žezlo. “Živio kralj Židova!” rugali su mu se i prigibali pred njim koljena. ");
INSERT INTO hrvbib_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Pljuvali su po njemu i udarali ga trskom po glavi. ");
INSERT INTO hrvbib_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Kad su mu se izrugali, skinu s njega plašt, odjenu ga u njegovu odjeću i odvedu da ga raspnu. ");
INSERT INTO hrvbib_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Vodeći ga, sretnu nekoga Šimuna iz Cirene te ga primoraju da ponese Isusov križ. ");
INSERT INTO hrvbib_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Dođu do mjesta zvanoga Golgota (što znači: “lubanja”). ");
INSERT INTO hrvbib_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Vojnici mu pruže vino sa žuči, ali kad ga okusi, nije htio piti. ");
INSERT INTO hrvbib_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Kad su ga raspeli, bace kocku te tako razdijele među sobom njegovu odjeću. ");
INSERT INTO hrvbib_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Zatim su ondje sjedili i čuvali ga. ");
INSERT INTO hrvbib_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Iznad glave su mu postavili natpis o njegovoj krivnji: “ovo je isus, kralj Židova.” ");
INSERT INTO hrvbib_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","S njime su raspeli i dvojicu prevratnika, jednoga njemu zdesna, a drugoga slijeva. ");
INSERT INTO hrvbib_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","A prolaznici su ga ružili i odmahivali glavom ");
INSERT INTO hrvbib_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","govoreći: “Možeš srušiti Hram i sam ga opet izgraditi u tri dana, je li? Spasi onda sebe! Ako si Božji Sin, siđi s križa!” ");
INSERT INTO hrvbib_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Slično su mu se rugali i svećenički poglavari, pismoznanci i starješine: ");
INSERT INTO hrvbib_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Spasio je druge, a sebe ne može spasiti! Kralj Izraelov! Neka sada siđe s križa pa ćemo povjerovati u njega! ");
INSERT INTO hrvbib_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Uzdao se u Boga! Neka ga Bog sada izbavi ako mu je on uistinu po volji! Tvrdio je: ‘Ja sam Božji Sin.’” ");
INSERT INTO hrvbib_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Vrijeđali su ga čak i prevratnici raspeti skupa s njim. ");
INSERT INTO hrvbib_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","O podnevu po svoj zemlji nastane tama i potraje do tri ure. ");
INSERT INTO hrvbib_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","U tri sata Isus glasno poviče: “Eli, Eli, lema sabahtani!” (što znači: “Bože moj, Bože moj, zašto si me ostavio?”) ");
INSERT INTO hrvbib_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","“Zove Iliju!” rekoše neki od nazočnih kad su to čuli. ");
INSERT INTO hrvbib_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Jedan od njih odmah pritrči, uzme spužvu, umoči ju u ocat i natakne na trsku te mu pruži piti. ");
INSERT INTO hrvbib_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","“Čekaj da vidimo hoće li doći Ilija da ga spasi”, kazaše ostali. ");
INSERT INTO hrvbib_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","A Isus još jedanput glasno krikne i izdahne. ");
INSERT INTO hrvbib_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Nato se zastor u Hramu razdere napola od vrha do dna. Zemlja se potrese, špilje se raspuknu, ");
INSERT INTO hrvbib_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","grobovi se otvore, a tijela mnogih umrlih pravednika uskrsnu. ");
INSERT INTO hrvbib_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Nakon Isusova uskrsnuća oni iziđu iz grobova te odu u sveti grad i pokažu se mnogima. ");
INSERT INTO hrvbib_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Kad su rimski stotnik i oni koji su s njime čuvali Isusa vidjeli potres i sve što se zbivalo, rekoše: “Ovaj je čovjek zaista bio Božji Sin!” ");
INSERT INTO hrvbib_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Bile su tu i mnoge žene koje su promatrale izdaleka. Došle su iz Galileje za Isusom služeći mu. ");
INSERT INTO hrvbib_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Među njima su bile Marija Magdalena, Marija, majka Jakova mlađega i Josipa, te majka Zebedejevih sinova. ");
INSERT INTO hrvbib_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Uvečer dođe neki bogat čovjek iz Arimateje imenom Josip, koji je i sam bio Isusov učenik. ");
INSERT INTO hrvbib_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","On ode k Pilatu i zatraži da mu daju Isusovo tijelo. Pilat zapovjedi da tako učine. ");
INSERT INTO hrvbib_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Josip uzme tijelo, umota ga u čisto platno ");
INSERT INTO hrvbib_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","i položi ga u svoj novi grob isklesan u stijeni. Navali na ulaz velik kamen i ode. ");
INSERT INTO hrvbib_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Bile su ondje Marija iz Magdale i druga Marija i sjedile gledajući prema grobu. ");
INSERT INTO hrvbib_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Sutradan, to je dan nakon Priprave, okupe se svećenički poglavari i farizeji kod Pilata ");
INSERT INTO hrvbib_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","te mu rekoše: “Gospodine, sjetili smo se da je onaj varalica za života rekao: ‘Nakon tri dana ću uskrsnuti.’ ");
INSERT INTO hrvbib_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Zapovjedi zato da grob bude pod stražom sve do trećega dana da ne dođu njegovi učenici, ukradu tijelo i kažu narodu: ‘Uskrsnuo je od mrtvih!’ Ako se to dogodi, ta će prijevara biti još gora od prve!” ");
INSERT INTO hrvbib_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilat im udovolji. “Postavite stražu”, reče. “Idite i osigurajte grob kako znate.” ");
INSERT INTO hrvbib_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Zatim odu i osiguraju grob—zapečate kamen i postave stražu. ");
INSERT INTO hrvbib_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","U nedjelju rano ujutro Marija Magdalena i druga Marija dođu pogledati grob. ");
INSERT INTO hrvbib_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Odjednom nastane silan potres: anđeo Gospodnji siđe s neba, odvali kamen s ulaza u grob i sjedne na njega. ");
INSERT INTO hrvbib_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Lice mu je bilo sjajno poput munje, a odjeća bijela poput snijega. ");
INSERT INTO hrvbib_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Stražari se pred njim počnu tresti od straha i onesvijeste se. ");
INSERT INTO hrvbib_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Tada anđeo reče ženama: “Ne bojte se! Znam da tražite raspetoga Isusa. ");
INSERT INTO hrvbib_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ali on nije ovdje; uskrsnuo je kako vam je i rekao! Dođite vidjeti mjesto gdje je ležao ");
INSERT INTO hrvbib_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","pa brzo idite javiti njegovim učenicima da je uskrsnuo od mrtvih. Ide, eto, pred vama u Galileju. Ondje ćete ga vidjeti. Pamtite što sam vam rekao.” ");
INSERT INTO hrvbib_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Silno uplašene ali presretne, žene žurno krenu s groba i otrče to javiti njegovim učenicima. ");
INSERT INTO hrvbib_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Odjednom im u susret dođe Isus! “Zdravo!” reče im. One mu pritrče, obujme mu noge i ničice mu se poklone. ");
INSERT INTO hrvbib_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","“Ne bojte se”, reče im Isus. “Idite javiti mojoj braći da pođu u Galileju. Ondje ćemo se vidjeti.” ");
INSERT INTO hrvbib_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Dok su žene odlazile, neki od stražara dođu u grad i jave svećeničkim poglavarima sve što se dogodilo. ");
INSERT INTO hrvbib_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Oni se sastanu sa starješinama na vijećanje, a zatim uzmu mnogo novca i dadu ga vojnicima. ");
INSERT INTO hrvbib_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","“Recite: ‘Noću dok smo spavali došli su njegovi učenici i ukrali ga.’ ");
INSERT INTO hrvbib_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ako za to čuje upravitelj, mi ćemo ga već uvjeriti i pobrinuti se da nemate problema.” ");
INSERT INTO hrvbib_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Oni uzmu novac i postupe kako su ih uputili. To se pričanje razglasilo među Židovima i zadržalo sve do danas. ");
INSERT INTO hrvbib_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Jedanaestorica pođu u Galileju, na goru, kamo im je zapovjedio Isus. ");
INSERT INTO hrvbib_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Kad su ga ugledali, padnu pred njim ničice, ali neki su ipak posumnjali. ");
INSERT INTO hrvbib_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Isus im priđe i reče im: “Dana mi je sva vlast na nebu i na zemlji. ");
INSERT INTO hrvbib_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Idite zato i učinite sve narode mojim učenicima krsteći ih u ime Oca i Sina i Svetoga Duha. ");
INSERT INTO hrvbib_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Učite ih da ispunjavaju sve što sam vam zapovjedio! Ja sam s vama u sve dane do svršetka svijeta.”");
INSERT INTO hrvbib_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ovo je početak Radosne vijesti o Božjemu Sinu Isusu Kristu. ");
INSERT INTO hrvbib_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","U Knjizi proroka Izaije Bog je rekao: “Gledajte, šaljem pred vas svojega glasnika i on će vam pripraviti put. ");
INSERT INTO hrvbib_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","On je glas koji viče u pustinji: ‘Pripremite put za Gospodnji dolazak! Poravnajte za njega staze!’” ");
INSERT INTO hrvbib_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Taj glasnik bio je Ivan Krstitelj. Živio je u pustinji i propovijedao kako se ljudi trebaju krstiti da pokažu kako su se odvratili od svojih grijeha i obratili se Bogu da im oprosti. ");
INSERT INTO hrvbib_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ljudi iz Jeruzalema i iz cijele Judeje putovali su k njemu u pustinju da ga vide i čuju. Ispovijedali su svoje grijehe, a on ih je krstio u rijeci Jordanu. ");
INSERT INTO hrvbib_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ivanova odjeća bila je istkana od devine dlake, a bio je opasan kožnim pojasom. Hranio se skakavcima i divljim medom. ");
INSERT INTO hrvbib_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Propovijedao je: “Uskoro dolazi netko veći od mene, toliko velik da mu ja nisam dostojan ni robom biti. ");
INSERT INTO hrvbib_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ja vas krstim vodom, ali on će vas krstiti Svetim Duhom.” ");
INSERT INTO hrvbib_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Jednog dana dođe Isus iz Nazareta u Galileji i Ivan ga krsti u rijeci Jordanu. ");
INSERT INTO hrvbib_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Čim Isus iziđe iz vode, ugleda kako se otvaraju nebesa i kako Duh u obliku goluba silazi na njega. ");
INSERT INTO hrvbib_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Začuje se glas: “Ti si moj ljubljeni Sin! Ti si moja radost!” ");
INSERT INTO hrvbib_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Odmah nakon toga Duh nagna Isusa da ode u pustinju. ");
INSERT INTO hrvbib_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Tamo je ostao četrdeset dana i Sotona ga je kušao. Boravio je među divljim životinjama, a služili su mu anđeli. ");
INSERT INTO hrvbib_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Pošto je kralj Herod zatvorio Ivana, Isus ode u Galileju propovijedati Božju Radosnu vijest. ");
INSERT INTO hrvbib_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Napokon je došlo vrijeme,” naviještao je, “blizu je Božje kraljevstvo! Odvratite se od svojih grijeha i povjerujte Radosnoj vijesti!” ");
INSERT INTO hrvbib_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jednoga dana, prolazeći obalom Galilejskog jezera, opazi Šimuna i njegova brata Andriju kako mrežama hvataju ribu jer su po zanimanju bili ribari. ");
INSERT INTO hrvbib_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Reče im: “Pođite za mnom i ja ću vas učiniti ribarima ljudi!”. ");
INSERT INTO hrvbib_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Oni smjesta ostave svoje mreže te pođu za njim. ");
INSERT INTO hrvbib_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Malo dalje uz obalu ugleda Zebedejeve sinove Jakova i Ivana kako u lađici krpaju mreže. ");
INSERT INTO hrvbib_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Pozove i njih, a oni odmah ostave svojeg oca Zebedeja u lađi s nadničarima i pođu za njim. ");
INSERT INTO hrvbib_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Isus i njegovi sljedbenici stigoše u grad Kafarnaum. Odmah u subotu odu u sinagogu te je Isus ondje poučavao. ");
INSERT INTO hrvbib_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Svi okupljeni bili su zadivljeni njegovim učenjem jer ih je poučavao kao onaj koji ima vlast, a ne kao pismoznanci. ");
INSERT INTO hrvbib_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Tu se zatekao čovjek opsjednut nečistim duhom, koji počne vikati: ");
INSERT INTO hrvbib_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Zašto nas uznemiruješ, Isuse Nazarećanine? Zar si nas došao uništiti? Znam tko si: ti si Svetac Božji!” ");
INSERT INTO hrvbib_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Isus mu zaprijeti: “Umukni i iziđi iz njega!” ");
INSERT INTO hrvbib_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Nato on krikne, žestoko protrese čovjeka i iziđe iz njega. ");
INSERT INTO hrvbib_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Svi nazočni silno se zaprepaste i počnu raspravljati o tome što se dogodilo. “Kakvo je to novo učenje?” uzbuđeno su pitali. “Ima takvu silnu vlast! Čak se i nečisti duhovi pokoravaju njegovim zapovijedima!” ");
INSERT INTO hrvbib_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Vijest o tome što je učinio brzo se pronijela cijelom pokrajinom Galilejom. ");
INSERT INTO hrvbib_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Pošto iziđe iz sinagoge, Isus s Jakovom i Ivanom pođe u Šimunovu i Andrijinu kuću. ");
INSERT INTO hrvbib_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ondje je Šimunova punica ležala u velikoj vrućici te to odmah kazaše Isusu. ");
INSERT INTO hrvbib_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","On joj priđe, uhvati ju za ruku i podigne, a vrućica prestane. Žena stane ih posluživati. ");
INSERT INTO hrvbib_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Uvečer, kad je sunce zašlo, dovedu mu sve bolesnike i opsjednute, ");
INSERT INTO hrvbib_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","pa se sav grad skupio pred vratima. ");
INSERT INTO hrvbib_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Isus je iscijelio brojne bolesnike od najrazličitijih bolesti i brojnim zlodusima zapovjedio da iziđu iz svojih žrtava. Ali nije dopustio zlodusima da govore jer su znali tko je on. ");
INSERT INTO hrvbib_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Drugog jutra ustao je prije zore, povukao se na pusto mjesto i ondje se molio. ");
INSERT INTO hrvbib_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Šimun i ostali krenu ga potražiti. ");
INSERT INTO hrvbib_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Kad ga pronađu, rekoše mu: “Svi te traže!” ");
INSERT INTO hrvbib_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","On im odgovori: “Hajdemo i dalje, u druga mjesta. I njima moram propovijedati poruku. Zbog toga sam došao!” ");
INSERT INTO hrvbib_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Tako je proputovao cijelu Galileju propovijedajući po sinagogama i istjerujući zloduhe. ");
INSERT INTO hrvbib_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Jednom dođe k njemu neki gubavac, klekne pred njega i zamoli ga: “Ako hoćeš, možeš me iscijeliti!” ");
INSERT INTO hrvbib_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Isus se sažali, ispruži ruku, dotakne ga i reče: “Hoću! Budi čist!” ");
INSERT INTO hrvbib_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Gube odmah nestane i čovjek postane čist. ");
INSERT INTO hrvbib_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Otpravljajući ga, Isus ga strogo upozori: ");
INSERT INTO hrvbib_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Nikome o tomu ne govori, već idi ravno svećeniku te sa sobom ponesi žrtveni dar prema Mojsijevu zakonu kao javno svjedočanstvo svojeg ozdravljenja.” ");
INSERT INTO hrvbib_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ali čovjek ode i počne svima govoriti što mu se dogodilo; zbog toga Isusa opkoli toliko mnoštvo da više nije mogao javno ući u bilo koji grad, već se morao zadržavati vani, na samotnim mjestima. A ljudi su stizali sa svih strana. ");
INSERT INTO hrvbib_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Nekoliko dana nakon toga vrati se u Kafarnaum, a vijest o njegovu dolasku brzo se pročuje gradom. ");
INSERT INTO hrvbib_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","U kući u kojoj je boravio okupilo se toliko ljudi da više nije bilo mjesta ni za koga, čak ni pred vratima. A on im je propovijedao Riječ. ");
INSERT INTO hrvbib_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Uto dođu četvorica noseći uzetog čovjeka na nosilima. ");
INSERT INTO hrvbib_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Kako nisu mogli kroz mnoštvo doći do Isusa, načine rupu u glinenom krovu nad njegovom glavom i spuste bolesnika na nosilima ravno pred Isusa. ");
INSERT INTO hrvbib_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Kad Isus vidje njihovu vjeru, reče bolesniku: “Sinko, oprošteni su ti grijesi!” ");
INSERT INTO hrvbib_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ali neki židovski vjerski vođe koji su ondje sjedili rekoše u sebi: ");
INSERT INTO hrvbib_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Kako ovaj može tako govoriti! On huli! Tko može opraštati grijehe osim jedinoga Boga!” ");
INSERT INTO hrvbib_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Isus duhom prozre njihove misli pa ih upita: “Zašto to smatrate hulom? ");
INSERT INTO hrvbib_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Što je lakše reći uzetom čovjeku: ‘Grijesi su ti oprošteni’ ili ‘Ustani, uzmi svoja nosila i idi’? ");
INSERT INTO hrvbib_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Dokazat ću vam da ja, Sin Čovječji, imam vlast na zemlji opraštati grijehe.” Okrene se zatim prema uzetome i reče: ");
INSERT INTO hrvbib_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Zapovijedam ti: ustani, uzmi nosila i idi kući!” ");
INSERT INTO hrvbib_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Čovjek smjesta ustane, uzme nosila i iziđe naočigled mnoštvu. Svi su se divili i slavili Boga govoreći: “Takvo što još nikad nismo vidjeli!” ");
INSERT INTO hrvbib_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Isus ponovno ode na obalu jezera. Poučavao je mnoštvo koje se okupilo oko njega. ");
INSERT INTO hrvbib_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Prolazeći tuda, opazi Levija, Alfejeva sina, kako ubire porez te ga pozove: “Pođi sa mnom!” Levi ustane i pođe za njim. ");
INSERT INTO hrvbib_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Dok je Isus poslije bio u kući za stolom, došli su brojni ubirači poreza i grešnici i pridružili se njemu i njegovim učenicima. Mnogo takvih bilo je među onima koji su išli za Isusom. ");
INSERT INTO hrvbib_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","No kad neki pismoznanci, farizeji, ugledaju Isusa kako jede s tim ozloglašenim ljudima, kazaše njegovim učenicima: “Zašto vaš učitelj jede s ubiračima poreza i drugim grešnicima?” ");
INSERT INTO hrvbib_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Kad je Isus to čuo, reče im: “Ne treba liječnik zdravima, nego bolesnima. Nisam došao zvati pravednike, već grešnike.” ");
INSERT INTO hrvbib_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ivanovi učenici i farizeji povremeno su postili. Jednoga dana neki ljudi dođu Isusu i upitaju ga: “Zašto Ivanovi učenici i farizeji poste, a tvoji učenici ne poste?” ");
INSERT INTO hrvbib_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Isus im odgovori: “Mogu li uzvanici na svadbenoj večeri postiti dok su s mladoženjom? Ne mogu postiti dok je mladoženja s njima. ");
INSERT INTO hrvbib_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ali doći će dani kada će im ugrabiti mladoženju. Tada će postiti. ");
INSERT INTO hrvbib_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Nitko ne krpa rupe na staroj odjeći zakrpom od još nesmočena platna. Zakrpa bi se skupila, razvukla tkaninu i napravila još veću rupu. ");
INSERT INTO hrvbib_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Nitko ne ulijeva novo vino u stare mjehove jer bi se raspuknuli. Vino bi se prolilo, a mjehovi uništili. Novo se vino lijeva u nove mjehove.” ");
INSERT INTO hrvbib_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Jedne su subote Isus i njegovi učenici prolazili poljem usjeva. Učenici počnu putem trgati klasje. ");
INSERT INTO hrvbib_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Farizeji rekoše Isusu: “Zašto čine ono što je subotom zabranjeno? Zakonom je zabranjeno skupljati usjev subotom!” ");
INSERT INTO hrvbib_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ali Isus im odgovori: “Niste li nikada u Pismu čitali o tomu što je učinio kralj David kad su on i njegovi pratioci u nevolji ogladnjeli? ");
INSERT INTO hrvbib_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ušao je u Dom Božji (u to je doba veliki svećenik bio Ebijatar) i jeo prineseni kruh koji je dopušteno jesti samo svećenicima te ga je dao jesti i svojim pratiocima. ");
INSERT INTO hrvbib_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Subota je stvorena radi čovjeka, a ne čovjek radi subote. ");
INSERT INTO hrvbib_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ja, Sin Čovječji, gospodar sam čak i subote.” ");
INSERT INTO hrvbib_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Isus ponovno ode u tamošnju sinagogu. Ondje je bio neki čovjek usahnule ruke. ");
INSERT INTO hrvbib_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Isusovi neprijatelji budno su pazili hoće li mu iscijeliti ruku u subotu da ga mogu optužiti. ");
INSERT INTO hrvbib_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Isus reče čovjeku usahnule ruke: “Ustani i dođi ovamo na sredinu!” ");
INSERT INTO hrvbib_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Zatim ih upita: “Je li subotom dopušteno činiti dobro ili zlo, život spasiti ili pogubiti?” Šutjeli su. ");
INSERT INTO hrvbib_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Srdito ih pogleda duboko ožalošćen tvrdoćom njihovih srca te reče čovjeku: “Ispruži ruku!” On ju ispruži, a ruka mu postane zdrava. ");
INSERT INTO hrvbib_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Farizeji se smjesta odu dogovoriti s herodovcima da ga smaknu. ");
INSERT INTO hrvbib_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Isus i njegovi učenici odu na jezero, a za njima krene veliko mnoštvo iz cijele Galileje, Judeje, ");
INSERT INTO hrvbib_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jeruzalema, Idumeje, s istočne strane Jordana, čak i iz okolice Tira i Sidona. Vijest o čudima koje je činio nadaleko se pročula, pa su ga dolazili osobno vidjeti. ");
INSERT INTO hrvbib_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Isus reče učenicima da mu dovezu čamac koji će biti spreman ako se mnoštvo previše natisne oko njega. ");
INSERT INTO hrvbib_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Toga je dana mnoge iscijelio pa je na njega nahrupilo golemo mnoštvo bolesnika pokušavajući ga dotaknuti. ");
INSERT INTO hrvbib_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Kad bi ga vidjeli ljudi opsjednuti nečistim duhom, pali bi pred njim ničice i vikali: “Ti si Božji Sin!” ");
INSERT INTO hrvbib_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","A on im je oštro zabranjivao da ga očituju. ");
INSERT INTO hrvbib_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Zatim ode u goru i pozove one koje je izabrao da mu se ondje pridruže te oni dođu. ");
INSERT INTO hrvbib_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Od njih odabere dvanaestoricu da ga prate i imenuje ih apostolima. Njih je poslao da propovijedau ");
INSERT INTO hrvbib_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","i da imaju vlast istjerivati zloduhe. ");
INSERT INTO hrvbib_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Evo imena Dvanaestorice što ih je izabrao: Šimun (kojemu je nadjenuo ime Petar), ");
INSERT INTO hrvbib_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jakov i Ivan (Zebedejevi sinovi, kojima je Isus dao nadimak Boanerges, to jest “Sinovi groma”), ");
INSERT INTO hrvbib_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrija, Filip, Bartolomej, Matej, Toma, Jakov (Alfejev sin), Tadej, Šimun (član političke stranke koja se zalagala za nasilno svrgavanje rimske vlasti) i ");
INSERT INTO hrvbib_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Juda Iškariotski (koji ga je poslije izdao). ");
INSERT INTO hrvbib_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Kad se vratio u dom gdje je boravio, opet je nagrnulo toliko mnoštvo da nisu stigli ni jesti. ");
INSERT INTO hrvbib_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Kad su za to čuli njegovi, dođu ga odvesti jer su govorili da je izvan sebe. ");
INSERT INTO hrvbib_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ali pismoznanci što su došli iz Jeruzalema rekoše da ga je opsjeo Beelzebub, poglavica zlih duhova, pa da uz njegovu pomoć izgoni zloduhe. ");
INSERT INTO hrvbib_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Isus dozove ljude i počne im govoriti u prispodobama: “Kako može Sotona izgoniti Sotonu? ");
INSERT INTO hrvbib_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Kraljevstvo koje je u sebi podvojeno propast će. ");
INSERT INTO hrvbib_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Dom u kojemu vlada nesloga ne može opstati. ");
INSERT INTO hrvbib_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ako se dakle Sotona bori sam protiv sebe, kako će se onda održati? Ne bi uspio u tome. ");
INSERT INTO hrvbib_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ne možete ući u kuću snažnog čovjeka i opljačkati ga a da ga najprije ne svežete. Tek tada ga možete orobiti. ");
INSERT INTO hrvbib_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Zaista vam kažem da se svaki ljudski grijeh može oprostiti, pa čak i hula. ");
INSERT INTO hrvbib_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ali hula na Svetoga Duha nikad se ne može oprostiti. To je vječni grijeh.” ");
INSERT INTO hrvbib_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","To im reče jer su govorili da ima nečistog duha. ");
INSERT INTO hrvbib_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Stigli su onamo njegova majka i braća, stajali vani te mu po nekim ljudima poručili da iziđe razgovarati s njima. ");
INSERT INTO hrvbib_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Oko njega je sjedilo mnoštvo kad mu rekoše: “Vani su ti majka, braća i sestre, žele te vidjeti.” ");
INSERT INTO hrvbib_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","On im odgovori: “Tko mi je majka? Tko su mi braća?” ");
INSERT INTO hrvbib_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Pogleda ljude koji su sjedili u krugu oko njega, pa reče: “Ovo su mi majka i braća! ");
INSERT INTO hrvbib_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Zaista, tko god čini Božju volju, taj mi je i brat, i sestra i majka.” ");
INSERT INTO hrvbib_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Isus opet počne poučavati na obali jezera. K njemu nagrne toliko ljudi da je ušao u lađicu na jezeru, sjeo u nju i odande propovijedao, a sve je mnoštvo ostalo na obali. ");
INSERT INTO hrvbib_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Zatim stane poučavati ljude brojnim prispodobama. Evo jedne od njih: ");
INSERT INTO hrvbib_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Slušajte! Neki je ratar sijao sjeme. ");
INSERT INTO hrvbib_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Dok ga je sijao po polju, nešto sjemena padne na stazu. Dođu ptice i pozobaju ga. ");
INSERT INTO hrvbib_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Dio sjemena padne na kamenito tlo gdje je zemlja bila plitka, pa odmah nikne. ");
INSERT INTO hrvbib_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ali kad je granulo sunce, izgori i osuši se jer nije imalo duboka korijena. ");
INSERT INTO hrvbib_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Dio sjemena padne u trnje pa ono poraste i uguši ga, tako da nije donijelo roda. ");
INSERT INTO hrvbib_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Dio ga, napokon, padne na dobru zemlju i donese trideseterostruk, šezdeseterostruk, a neka čak i stostruk urod. ");
INSERT INTO hrvbib_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Slušajte, kad već imate uši!” ");
INSERT INTO hrvbib_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Kad je Isus poslije ostao sam s Dvanaestoricom i s drugima koji su ga slijedili, upitaju ga o značenju te prispodobe. ");
INSERT INTO hrvbib_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","On im odgovori: “Vama je dopušteno razumjeti tajnu o Božjemu kraljevstvu. A ostalima, koji su vani, govorim u prispodobama. ");
INSERT INTO hrvbib_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Kao što piše u Svetome pismu: ‘Gledat će moja djela, ali neće dokučiti njihova značenja; slušat će moje riječi, ali ih neće razumjeti. Neće se odvratiti od svojih grijeha niti će im biti oprošteno.’ ");
INSERT INTO hrvbib_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ali ako ne možete razumjeti tu jednostavnu priču, kako ćete uopće razumjeti prispodobe? ");
INSERT INTO hrvbib_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Sijač o kojemu sam govorio svatko je onaj tko u ljudska srca sije Božju riječ. ");
INSERT INTO hrvbib_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Sjeme na tvrdu tlu jesu oni koji čuju Riječ, ali odmah dođe Sotona i odnese tu Riječ u njih posijanu. ");
INSERT INTO hrvbib_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Kamenito tlo su oni koji čuju Riječ i odmah ju radosno prihvate, ");
INSERT INTO hrvbib_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","ali nemaju korijena i nestalni su. Čim ih zbog Riječi snađe nevolja ili progonstvo, odmah podlegnu. ");
INSERT INTO hrvbib_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Trnovito tlo srca su ljudi koji čuju Riječ i prihvate ju, ");
INSERT INTO hrvbib_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ali tjeskobne brige ovoga svijeta, varavo bogatstvo i požuda za svime ostalime uguše sjeme i ono ostane bez roda. ");
INSERT INTO hrvbib_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Dobro tlo je srce čovjeka koji čuje Riječ, razumije ju i donosi rod—trideseterostruko, šezdeseterostruko ili čak stostruko veći od posijanoga.” ");
INSERT INTO hrvbib_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Zatim ih upita: “Kada upalite svjetiljku, stavljate li ju pod košaru ili pod postelju da prigušite svjetlost? Nipošto! Stavljate ju na svijećnjak. ");
INSERT INTO hrvbib_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Sve ono što je sada skriveno i što je u potaji učinjeno, jednom će izići na vidjelo. ");
INSERT INTO hrvbib_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Slušajte, kad već imate uši! ");
INSERT INTO hrvbib_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","I nastojte svakako pozorno slušati! Kad budete tako činili, bolje ćete razumjeti što vam govorim. ");
INSERT INTO hrvbib_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Onima koji žive po Božjoj mudrosti”, reče im, “Bog će dati još više mudrosti. A oni koji ne postupaju prema njegovoj mudrosti, izgubit će ubrzo i ono malo od nje što imaju.” ");
INSERT INTO hrvbib_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Isus nastavi: “Božje je kraljevstvo poput ovoga: ratar baci sjeme na zemlju, ");
INSERT INTO hrvbib_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","a zatim ode dalje za svojim poslom. Lijegao je noću i ustajao danju, a sjeme je niknulo i izraslo a da on to nije ni znao. ");
INSERT INTO hrvbib_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Zemlja sama od sebe donese rod: najprije izraste stabljika, zatim klas, pa se popuni zrelim zrnima. ");
INSERT INTO hrvbib_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Čim zrno sazre, dođe ratar i požanje ga srpom.” ");
INSERT INTO hrvbib_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Isus upita: “Kako da vam još opišem Božje kraljevstvo? S čime da ga usporedim? ");
INSERT INTO hrvbib_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ono je poput sitna gorušičina zrna, najmanjega od svakog sjemena koje se sije u zemlju. ");
INSERT INTO hrvbib_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ali kad se posije, izraste veće od svake biljke u povrtnjaku, s velikim granama u kojih se sjenu mogu skloniti ptice nebeske.” ");
INSERT INTO hrvbib_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Isus je govorio takve prispodobe da pouči narod Riječi onoliko koliko su mogli shvatiti. ");
INSERT INTO hrvbib_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Javno je poučavao samo u prispodobama, a nasamo je svojim učenicima sve tumačio. ");
INSERT INTO hrvbib_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Kad se spustila večer, Isus reče učenicima: “Prijeđimo na drugu stranu jezera.” ");
INSERT INTO hrvbib_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Oni otpustiše narod i povezoše ga u lađici iz koje je propovijedao. Za njima se otisnu i druge lađice. ");
INSERT INTO hrvbib_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Odjednom se podiže silna oluja. Visoki valovi počnu se prelijevati u lađicu tako da se gotovo posve napunila vodom. ");
INSERT INTO hrvbib_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Isus je spavao na krmi s glavom na jastuku. U panici su ga probudili vičući: “Učitelju! Zar ti uopće ne mariš što ćemo izginuti?” ");
INSERT INTO hrvbib_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Isus se probudi, zaprijeti vjetru te reče moru: “Utišaj se! Umukni!” Vjetar prestane i nastane velika tišina. ");
INSERT INTO hrvbib_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","On upita učenike: “Što ste se toliko prestrašili? Zar još nemate vjere?” ");
INSERT INTO hrvbib_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Oni su bili silno prestrašeni. Pitali su jedan drugoga: “Pa tko je on da mu se i vjetar i more pokoravaju?” ");
INSERT INTO hrvbib_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Doploviše na drugu obalu jezera, u geraski kraj. ");
INSERT INTO hrvbib_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Tek što je Isus izišao iz lađice, istrćao je pred njega s groblja neki čovjek opsjednut nečistim duhom. ");
INSERT INTO hrvbib_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Stanovao je u grobnicama, a nitko ga više nije mogao svezati, čak ni lancem. ");
INSERT INTO hrvbib_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Često su ga okivali u lance, ali on bi uvijek rastrgao lance i smrskao okove u komadiće. Nitko ga nije mogao ukrotiti. ");
INSERT INTO hrvbib_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Danju i noću bez prestanka je lutao grobljima i gorom vrišteći i udarajući sebe kamenjem. ");
INSERT INTO hrvbib_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ugledavši Isusa izdaleka, pritrči mu i padne ničice pred njim. ");
INSERT INTO hrvbib_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Zavrišti i prodorno vikne: “Što hoćeš od mene, Isuse, Sine najuzvišenijeg Boga? Zaklinjem te Bogom, ne muči me!” ");
INSERT INTO hrvbib_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Isus mu, naime, bijaše zapovjedio: “Izlazi iz toga čovjeka, nečisti duše!” ");
INSERT INTO hrvbib_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Zatim ga upita: “Kako se zoveš?” “Zovem se Legija”, odgovori on, “jer nas je mnogo u ovom čovjeku.” ");
INSERT INTO hrvbib_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Preklinjao ga je da ih ne potjera iz onoga kraja. ");
INSERT INTO hrvbib_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","A ondje je na obronku paslo veliko krdo svinja. ");
INSERT INTO hrvbib_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","“Pošalji nas onim svinjama da uđemo u njih”, zamole ga nečisti duhovi. ");
INSERT INTO hrvbib_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","On im to dopusti. Nečisti duhovi iziđu i uđu u svinje, na što cijelo krdo od kojih dvije tisuće svinja jurne niz strmi obronak i utopi se u jezeru. ");
INSERT INTO hrvbib_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Svinjari pobjegnu u obližnje gradove i sela i razglase putem novost, pa ljudi pođu vidjeti što se dogodilo. ");
INSERT INTO hrvbib_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Dođu Isusu i ugledaju čovjeka koji bijaše opsjednut cijelom legijom kako sjedi obučen i pri zdravoj pameti te se uplaše. ");
INSERT INTO hrvbib_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","A kad su očevici ispričali što se dogodilo s opsjednutim i sa svinjama, ");
INSERT INTO hrvbib_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","ljudi počnu zaklinjati Isusa da ode iz njihova kraja. ");
INSERT INTO hrvbib_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","On se vrati u lađu, a čovjek koji je bio opsjednut zamoli ga da mu dopusti poći s njime. ");
INSERT INTO hrvbib_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ali mu Isus to nije dopustio. “Idi kući svojima”, reče mu on, “i ispričaj im koliko ti je milosrđe Bog iskazao.” ");
INSERT INTO hrvbib_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Čovjek se zaputi u Dekapolis toga kraja govoreći ljudima o svemu što mu je Isus učinio. I svi su se divili. ");
INSERT INTO hrvbib_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Kad je Isus doplovio na drugu stranu jezera, okupi se oko njega na obali silno mnoštvo. On je stajao uz more. ");
INSERT INTO hrvbib_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Pristupi mu jedan od nadstojnika mjesne sinagoge, imenom Jair, te padne pred njim ničice ");
INSERT INTO hrvbib_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","preklinjući ga da mu iscijeli kćerkicu. “Na samrti je”, reče on. “Molim te, dođi i položi na nju ruke da ozdravi i da živi.” ");
INSERT INTO hrvbib_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Isus pođe s njim, ali se oko njega natisnulo mnoštvo. ");
INSERT INTO hrvbib_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Među ljudima bila je žena koja je bolovala od krvarenja već dvanaest godina. ");
INSERT INTO hrvbib_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Mnogo je pretrpjela od brojnih liječnika i potrošila je na njih sve što je imala, ali nije ozdravila. Stanje joj se, naprotiv, pogoršalo. ");
INSERT INTO hrvbib_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Slušala je o Isusu pa mu se približi straga kroz mnoštvo i dotakne njegov ogrtač. ");
INSERT INTO hrvbib_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Mislila je: “Dodirnem li samo njegovu odjeću, ozdravit ću!” ");
INSERT INTO hrvbib_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","I zaista, krv joj smjesta prestane teći i ona na svojemu tijelu osjeti da je ozdravila. ");
INSERT INTO hrvbib_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Isus je odmah osjetio da je iz njega izišla sila pa se okrenu prema mnoštvu i upita: “Tko mi je dotaknuo odjeću?” ");
INSERT INTO hrvbib_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Učenici mu rekoše: “Toliko se mnoštvo tiska oko tebe, a ti pitaš tko te je dotaknuo!” ");
INSERT INTO hrvbib_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ali Isus je pogledom tražio onu koja je to učinila. ");
INSERT INTO hrvbib_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","A žena, uplašena i dršćući jer je znala što joj se dogodilo, priđe mu i padne pred njim ničice te mu sve po istini ispriča. ");
INSERT INTO hrvbib_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","On joj reče: “Kćeri, tvoja te vjera iscijelila. Pođi u miru i budi iscijeljena od svoje bolesti!” ");
INSERT INTO hrvbib_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Dok je Isus još to govorio, stigli su iz Jairova doma s viješću. “Kći ti je umrla. Nema smisla da dalje mučiš Učitelja.” ");
INSERT INTO hrvbib_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ali Isus se nije obazirao na to što su rekli, već se obrati Jairu: “Ne boj se! Samo vjeruj!” ");
INSERT INTO hrvbib_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Isus ne dopusti nikome da ga prati osim Petru, Jakovu i Ivanu. ");
INSERT INTO hrvbib_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Kad su stigli do kuće nadstojnika sinagoge, Isus vidje da ljudi viču, plaču i nariču u sav glas. ");
INSERT INTO hrvbib_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","On uđe i reče im: “Što toliko naričete i plačete? Dijete nije umrlo, nego samo spava!” ");
INSERT INTO hrvbib_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Mnoštvo ga počne ismijavati, ali on ih sve potjera van. Povede samo djetetova oca i majku te trojicu svojih učenika, pa uđe u prostoriju u kojoj je ležala djevojčica. ");
INSERT INTO hrvbib_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Uhvati ju za ruku i reče joj: “Talita kum!” (što znači: “Ustani, djevojčice!”). ");
INSERT INTO hrvbib_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Djevojčica je imala dvanaest godina. Ona smjesta ustane i počne hodati. Roditelji ostanu zapanjeni. ");
INSERT INTO hrvbib_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Isus im zapovjedi da nikome ne govore što se dogodilo i reče im da joj daju jesti. ");
INSERT INTO hrvbib_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Isus ode odande i vrati se s učenicima u svoj zavičaj, u Nazaret. ");
INSERT INTO hrvbib_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sljedeće subote ode u sinagogu i počne poučavati. Mnogi ljudi su se divili i govorili: “Odakle mu ta mudrost i sila kojom čini takva čudesa? ");
INSERT INTO hrvbib_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Nije li on drvodjelja, Marijin sin, Jakovljev, Josijin, Judin i Šimunov brat? Nisu li mu sestre tu među nama?” I sablaznili su se zbog njega. ");
INSERT INTO hrvbib_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Isus im reče: “Proroku ne iskazuju čast jedino u njegovu zavičaju, među rodbinom i u njegovu domu.” ");
INSERT INTO hrvbib_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Zbog njihove nevjere nije mogao ondje učiniti nikakva čuda, samo je iscijelio nekoliko bolesnika položivši na njih ruke. ");
INSERT INTO hrvbib_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Čudio se njihovoj nevjeri. Išao je po selima i poučavao. ");
INSERT INTO hrvbib_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Pozvao je sebi Dvanaestoricu te ih počeo slati po dvojicu dajući im vlast da izgone nečiste duhove. ");
INSERT INTO hrvbib_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Zapovjedio im je da na put ne ponesu ništa osim štapa—ni kruha, ni torbu, ni bakrena novca koji se običavao nositi u pojasu. ");
INSERT INTO hrvbib_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Reče im da obuju sandale, ali da ne ponesu ni ogrtača. ");
INSERT INTO hrvbib_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Kazao je: “Kad boravite u nekome mjestu, stanujte u jednoj kući i ne mijenjajte smještaj. ");
INSERT INTO hrvbib_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ako vas u nekome mjestu ne prihvate ili ne poslušaju, stresite i prašinu s nogu kad odlazite. To će biti znak da ste ga prepustili njegovoj sudbini.” ");
INSERT INTO hrvbib_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Tako su učenici otišli i propovijedali o pokajanju. ");
INSERT INTO hrvbib_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Mnoge su zloduhe istjerali i mnogo bolesnika pomazali uljem i iscijelili. ");
INSERT INTO hrvbib_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ubrzo je i kralj Herod Antipa čuo za Isusa jer se o njemu posvuda govorilo. Neki su govorili: “To je od mrtvih uskrsnuo Ivan Krstitelj pa sad u njemu djeluju čudesne sile.” ");
INSERT INTO hrvbib_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Drugi su pak govorili da je Isus starodrevni prorok Ilija. Treći su tvrdili da je on novi prorok poput onih iz prošlosti. ");
INSERT INTO hrvbib_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Herod na to reče: “To je Ivan komu sam dao odrubiti glavu. Uskrsnuo je!” ");
INSERT INTO hrvbib_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Herod je, naime, zapovjedio da Ivana okuju u lance i bace u tamnicu zbog Herodijade, žene Herodova brata Filipa. ");
INSERT INTO hrvbib_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Herod ju je uzeo za ženu, a Ivan ga je opominjao: “Nije se dopušteno ženiti ženom vlastitog brata!” ");
INSERT INTO hrvbib_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Herodijada je zato zamrzila Ivana i htjela ga je ubiti, ali to nije mogla učiniti ");
INSERT INTO hrvbib_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","jer je Herod poštivao Ivana. Znao je da je svet i dobar čovjek i zato ga je štitio. Iako bi se uvijek uznemirio kad bi razgovarao s Ivanom, Herod ga je rado slušao. ");
INSERT INTO hrvbib_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Na posljetku se Herodijadi pružila prigoda. Herodu je bio rođendan te je priredio gozbu za svoje dvorane, visoke časnike i najuglednije građane Galileje. ");
INSERT INTO hrvbib_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Herodijadina kći plesala za Heroda i njegove uzvanike i svima se svidjela. “Traži od mene što ti drago,” reče kralj djevojci, ");
INSERT INTO hrvbib_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","“pa bila to i polovica mojega kraljevstva, i dat ću ti što zatražiš!” ");
INSERT INTO hrvbib_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Djevojka iziđe i upita majku: “Što da tražim?” A ona odgovori: “Traži glavu Ivana Krstitelja!” ");
INSERT INTO hrvbib_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Djevojka požuri natrag kralju te mu reče: “Zapovjedi da mi na pladnju donesu glavu Ivana Krstitelja, i to odmah!” ");
INSERT INTO hrvbib_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Kralj se ražalosti, ali zbog toga što se zakleo i zbog uzvanika ne htjede ju odbiti. ");
INSERT INTO hrvbib_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Odmah naredi krvniku da donese Ivanovu glavu. Krvnik ode u tamnicu, odrubi Ivanu glavu ");
INSERT INTO hrvbib_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","te je na pladnju dade djevojci, a ona ju odnese majci. ");
INSERT INTO hrvbib_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Kad za to doznaše Ivanovi učenici, dođu uzeti njegovo tijelo da ga polože u grob. ");
INSERT INTO hrvbib_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Apostoli se s putovanja vrate Isusu te ga izvijeste o svemu što su činili i što su poučavali. ");
INSERT INTO hrvbib_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Isus im predloži: “Sklonimo se malo u osamu da se odmorimo.” Jer je dolazilo i odlazilo toliko ljudi da nisu imali vremena ni jesti. ");
INSERT INTO hrvbib_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Otisnu se tako lađom prema mirnijemu mjestu. ");
INSERT INTO hrvbib_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","No mnogi su ih opazili kako odlaze pa su ljudi iz mnogih mjesta potrčali onamo obalom i stigli prije njih. ");
INSERT INTO hrvbib_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Kad je izišao iz lađice, ugleda silan narod pa se sažali nad njima jer su bili kao ovce bez pastira pa ih je dugo poučavao. ");
INSERT INTO hrvbib_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Kad je dan poodmaknuo, pristupe mu njegovi učenici i kazaše: “Pust je ovo kraj a već je i kasno. ");
INSERT INTO hrvbib_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Otpusti ljude da mogu otići na okolna imanja i sela te si kupiti što za jelo!” ");
INSERT INTO hrvbib_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","“Vi ih nahranite!” odgovori im Isus. “Čime?” upitaju. “Trebalo bi nam cijelo bogatstvo da se kupi hrana za toliko mnoštvo!” ");
INSERT INTO hrvbib_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","“Pogledajte koliko hrane imate”, reče im. Vrate se i kažu da imaju pet kruhova i dvije ribe. ");
INSERT INTO hrvbib_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Isus im zapovjedi da posjedaju u skupine po zelenoj travi. ");
INSERT INTO hrvbib_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Posjedali su u skupine od stotinu i od pedeset ljudi. ");
INSERT INTO hrvbib_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Isus uzme pet kruhova i dvije ribe, pogleda u nebo i blagoslovi hranu te razlomi kruhove. Dade ih zatim učenicima da podijele ljudima. Također svima podijeli i one dvije ribe. ");
INSERT INTO hrvbib_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Svi su jeli dok se nisu nasitili ");
INSERT INTO hrvbib_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","i još poslije pokupe punih dvanaest košara preostalih ulomaka te ostatak riba. ");
INSERT INTO hrvbib_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","A nahranilo se pet tisuća muškaraca. ");
INSERT INTO hrvbib_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Odmah zatim Isus natjera učenike da uđu u lađu i da preplove na drugu obalu, prema Betsaidi, dok on otpusti mnoštvo. ");
INSERT INTO hrvbib_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Pošto se rastao s ljudima, otišao je u goru da se moli. ");
INSERT INTO hrvbib_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Bila je noć, učenici su bili u lađi nasred jezera, a on sam na kopnu. ");
INSERT INTO hrvbib_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Opazi da jedva veslaju boreći se s nasuprotnim vjetrom te oko tri ure ujutro krene prema njima hodajući po vodi. Htio im je prići, ");
INSERT INTO hrvbib_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","ali kad ga ugledaju kako hoda po vodi prema njima, vrisnu od straha misleći da je sablast. ");
INSERT INTO hrvbib_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Svi su ga vidjeli i prestrašili se. Ali on im odmah reče: “Samo hrabro! Ja sam! Ne bojte se!” ");
INSERT INTO hrvbib_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Tada su ušli u lađu i vjetar prestane. Učenike je zaprepastilo to što su vidjeli. ");
INSERT INTO hrvbib_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Još nisu shvaćali značenje čuda s umnoženim kruhom jer su im srca bila tvrda i nisu vjerovali. ");
INSERT INTO hrvbib_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Preplove jezero i pristanu u Genezaretu te privežu lađu ");
INSERT INTO hrvbib_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","i iziđu. Ljudi ga odmah prepoznaju ");
INSERT INTO hrvbib_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","i rastrče se po cijelomu kraju da razglase vijest o njegovu dolasku te mu počnu donositi bolesnike na nosilima. ");
INSERT INTO hrvbib_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","I u koji god bi grad, selo ili zaselak ušao, polijegali bi bolesnike na trgove i ulice te ga molili da im dopusti dotaknuti barem skut njegove haljine—i svi koji bi ga dotaknuli ozdravljali su. ");
INSERT INTO hrvbib_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Jednom se okupe oko Isusa neki farizeji i pismoznanci koji su došli iz Jeruzalema ");
INSERT INTO hrvbib_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","te opaze da neki od njegovih učenika jedu “nečistim”, neopranim rukama. ");
INSERT INTO hrvbib_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Židovi, a osobito farizeji, nikada ne jedu a da obredno ne operu ruke jer to zahtijeva njihova starodrevna predaja. ");
INSERT INTO hrvbib_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Kad dođu doma s tržnice, uvijek se operu prije nego što dotaknu hranu. To je tek jedna od brojnih odredba kojih se drže, kao što je i obred pranja čaša, vrčeva i bakrenog posuđa. ");
INSERT INTO hrvbib_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Zato ga vjerski vođe upitaju: “Zašto tvoji učenici ne slijede stare židovske predaje? Jedu nečistim rukama.” ");
INSERT INTO hrvbib_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Isus im odgovori: “Licemjeri! Lijepo je o vama prorokovao Izaija kad je rekao: Ovaj me narod štuje samo usnama, ali srce im je daleko od mene. ");
INSERT INTO hrvbib_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Uzalud me štuju jer kao moje učenje poučavaju ljudske zapovijedi. ");
INSERT INTO hrvbib_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Vi zanemarujete Božje zapovijedi i zamjenjujete ih ljudskim predajama. ");
INSERT INTO hrvbib_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Lijepo! Odbacujete Božje zapovijedi zbog svoje predaje! ");
INSERT INTO hrvbib_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mojsije vam je, primjerice, dao Božju zapovijed: ‘Poštuj oca i majku!’ i ‘Tko prokune oca ili majku, neka se kazni smrću!’ ");
INSERT INTO hrvbib_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ali vi kažete da je roditeljima opravdano reći: ‘Žao mi je, ne mogu vam pomoći jer sam se Bogu zakleo dati ono što sam mogao dati vama.’ ");
INSERT INTO hrvbib_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Tako ljudima dopuštate da zanemare roditelje koji su u potrebi ");
INSERT INTO hrvbib_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","i kršite Božju zapovijed da zaštitite vlastitu predaju. To je tek jedan od brojnih primjera.” ");
INSERT INTO hrvbib_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Tada Isus pozove mnoštvo i reče im: “Slušajte me svi i nastojte shvatiti! ");
INSERT INTO hrvbib_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ništa što izvana ulazi u čovjeka ne može ga onečistiti, ali onečišćuje ga ono što iz njega izlazi. ");
INSERT INTO hrvbib_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Slušajte, kad već imate uši!” ");
INSERT INTO hrvbib_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Zatim ode od mnoštva u kuću, a učenici ga zamole da im objasni prispodobu. ");
INSERT INTO hrvbib_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","“Zar ni vi ne razumijete?” upita ih on. “Ne shvaćate li da čovjeka ne može onečistiti ono što u njega uđe izvana ");
INSERT INTO hrvbib_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","jer ne ide u srce, već odlazi u trbuh, a zatim se izbacuje u zahod!” Tim je riječima sve vrste hrane proglasio čistima. ");
INSERT INTO hrvbib_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Zatim još reče: “Čovjeka onečišćuje ono što izlazi iz njegove nutrine. ");
INSERT INTO hrvbib_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Jer iz nutrine, iz ljudskoga srca, dolaze zle misli, bludnost, krađa, ubojstvo, ");
INSERT INTO hrvbib_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","preljub, pohlepa, zloća, prijevara, razvrat, zavist, kleveta, oholost i glupost. ");
INSERT INTO hrvbib_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Sva ta zla izlaze iznutra, ona čovjeka prljaju i čine ga nečistim pred Bogom.” ");
INSERT INTO hrvbib_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Nakon toga Isus iz Galileje ode u tirski kraj te uđe u neku kuću ne želeći da itko sazna da je ondje. Ali nije se mogao skriti. ");
INSERT INTO hrvbib_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Odmah mu dođe neka žena koje je djevojčicu opsjeo nečist duh i padne ničice pred njim. ");
INSERT INTO hrvbib_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Bila je ona poganka, rodom Sirofeničanka. Preklinjala ga je da istjera nečistog duha iz njezine kćeri. ");
INSERT INTO hrvbib_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Isus joj reče: “Prije bih trebao pomoći vlastitom rodu—Židovima. Nepravedno je uzeti kruh djeci i baciti ga psima.” ");
INSERT INTO hrvbib_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ona odgovori: “Istina je, Gospodine, ali čak i psi ispod stola jedu mrvice koje padnu djeci.” ");
INSERT INTO hrvbib_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","“Zbog toga što si rekla,” reče joj Isus, “možeš ići. Zli je duh izišao iz tvoje kćeri.” ");
INSERT INTO hrvbib_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Kad je žena stigla doma, našla je djevojčicu kako leži u postelji. Zli duh bijaše izišao. ");
INSERT INTO hrvbib_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Iz Tira Isus ode u Sidon, a zatim natrag do Galilejskog jezera, usred područja Dekapolisa. ");
INSERT INTO hrvbib_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Donesu mu gluhonijemog čovjeka i preklinjahu ga da na njega položi ruke i iscijeli ga. ");
INSERT INTO hrvbib_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","On ga izvede iz mnoštva na mjesto gdje su mogli biti nasamo, stavi prste u njegove uši, a zatim pljune i svojom mu slinom dotakne jezik. ");
INSERT INTO hrvbib_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Pogleda u nebo, uzdahne i zapovjedi: “Otvori se!” ");
INSERT INTO hrvbib_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Sluh mu se odmah vrati, a jezik razriješi tako da je mogao razgovijetno govoriti. ");
INSERT INTO hrvbib_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Isus zabrani ljudima o tome govoriti, ali što im je on više branio, to su više pripovijedali. ");
INSERT INTO hrvbib_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Silno su se divili. Neprekidno su ponavljali: “On čini divne stvari—čak vraća sluh gluhima i čini da nijemi progovore!” ");
INSERT INTO hrvbib_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","U to se vrijeme opet okupi veliko mnoštvo, a ljudi nisu imali što jesti. Isus pozove učenike te im reče: ");
INSERT INTO hrvbib_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Žao mi je tih ljudi. Već su tri dana ovdje sa mnom i više nemaju što jesti. ");
INSERT INTO hrvbib_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ako ih pošaljem gladne kućama, klonut će na putu. Neki su došli izdaleka.” ");
INSERT INTO hrvbib_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","“Pa kako da im u ovoj pustoši nabavimo dovoljno hrane?” upitaju učenici. ");
INSERT INTO hrvbib_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","“Koliko kruhova imate?” upita ih. “Sedam”, odgovore. ");
INSERT INTO hrvbib_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Nato on reče mnoštvu da posjeda po zemlji. Zatim uzme sedam kruhova, zahvali za njih Bogu, razlomi ih na komade i dade svojim učenicima. A učenici ih podijele mnoštvu. ");
INSERT INTO hrvbib_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Nađe se i nekoliko ribica. Isus ih blagoslovi pa reče učenicima da i njih podijele. ");
INSERT INTO hrvbib_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Svi se nasitiše, a zatim pokupe sedam košara preostale hrane. ");
INSERT INTO hrvbib_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ondje je bilo oko četiri tisuće muškaraca. Pošto su jeli, on ih otpusti kućama. ");
INSERT INTO hrvbib_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Odmah zatim uđe s učenicima u lađu i doplovi u okolicu Dalmanute. ");
INSERT INTO hrvbib_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Kad farizeji doznaju da je stigao, dođu s njime raspravljati. Tražili su od njega da im pokaže znak s neba kao potvrdu. ");
INSERT INTO hrvbib_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Kad je to čuo, on uzdahne i reče: “Zašto ovaj naraštaj neprestano traži znakove? Zaista vam kažem, ovaj ih naraštaj neće dobiti.” ");
INSERT INTO hrvbib_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Zatim se vrati u lađicu, ostavi ih i preplovi na drugu stranu jezera. ");
INSERT INTO hrvbib_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","No učenici su zaboravili ponijeti hrane prije polaska te su sa sobom u lađi imali samo jedan kruh. ");
INSERT INTO hrvbib_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Isus ih strogo opomene: “Čuvajte se farizejskoga kvasca i kvasca kralja Heroda!” ");
INSERT INTO hrvbib_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","“Nemamo kruha”, govorili su međusobno jer mišljahu da im je zato to rekao. ");
INSERT INTO hrvbib_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Isus je čuo o čemu govore pa reče: “Zašto govorite o tomu da nemate kruha? Zar još niste razumjeli, zar ne shvaćate? Zar su vam srca tako otvrdnula? ");
INSERT INTO hrvbib_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Imate oči, a ne vidite! Imate uši, a ne čujete! Zar ništa ne možete upamtiti? ");
INSERT INTO hrvbib_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","A onih pet tisuća muškaraca koje sam nahranio razlomivši pet kruhova? Koliko ste punih košara ostataka skupili nakon toga?” “Dvanaest”, odgovore. ");
INSERT INTO hrvbib_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“A koliko je košara hrane preostalo kad sam razlomio sedam kruhova i njima nahranio četiri tisuće muškaraca?” “Sedam punih košara”, rekoše. ");
INSERT INTO hrvbib_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","“Pa zar još ne razumijete?” upita ih. ");
INSERT INTO hrvbib_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Kad stignu u Betsaidu, dovedu mu slijepca i zamole ga da ga dotakne i iscijeli. ");
INSERT INTO hrvbib_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Isus uzme slijepca za ruku i povede ga izvan sela, pljune mu u oči te na njih položi ruke. “Vidiš li što?” upita ga. ");
INSERT INTO hrvbib_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Čovjek podiže pogled. “Vidim ljude,” reče, “ali nejasno, poput stabala koja hodaju!” ");
INSERT INTO hrvbib_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Tada mu Isus ponovno stavi ruke na oči i čovjeku se taj put posve vrati vid, tako da je vidio sasvim jasno. ");
INSERT INTO hrvbib_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Isus ga pošalje kući. “Ne svraćaj putem u selo”, reče mu. ");
INSERT INTO hrvbib_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Isus i njegovi učenici odu iz Galileje u sela Filipove Cezareje. On ih putem upita: “Što ljudi kažu, tko sam ja?” ");
INSERT INTO hrvbib_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","“Neki kažu da si Ivan Krstitelj,” odgovore učenici, “drugi kažu da si Ilija, a treći da si jedan od proroka.” ");
INSERT INTO hrvbib_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Tada ih upita: “A za koga me vi držite?” Petar odgovori: “Ti si Krist!” ");
INSERT INTO hrvbib_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Isus im zabrani da ikomu o njemu govore. ");
INSERT INTO hrvbib_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Zatim im počne objašnjavati kako će on, Sin Čovječji, morati mnogo pretrpjeti od starješina, svećeničkih poglavara i pismoznanaca, koji će ga odbaciti, te da će biti ubijen i nakon tri dana uskrsnuti. ");
INSERT INTO hrvbib_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Govorio im je o tome posve otvoreno. Petar ga nato povede na stranu i počne ga od toga odgovarati. ");
INSERT INTO hrvbib_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Isus se okrene, pogleda učenike te strogo ukori Petra: “Odstupi od mene, Sotono, jer ti ne razmišljaš na Božji način, nego ljudski!” ");
INSERT INTO hrvbib_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Tada pozove učenike i mnoštvo da priđu i slušaju. Zatim reče im: “Želi li tko biti mojim sljedbenikom, neka se odrekne samoga sebe, neka uzme svoj križ i neka ide za mnom. ");
INSERT INTO hrvbib_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Jer svatko tko želi sačuvati svoj život izgubit će ga; a tko dade svoj život za mene i za Radosnu vijest, imat će istinski život. ");
INSERT INTO hrvbib_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Kakva ti je korist ako stekneš sav svijet, a izgubiš vječni život? ");
INSERT INTO hrvbib_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Što se može mjeriti s vrijednošću života? ");
INSERT INTO hrvbib_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Posrami li se tko mene i mojih riječi pred ovim preljubničkim i grešnim naraštajem, njega ću se i ja, Sin Čovječji, posramiti kada dođem u svojoj i Očevoj slavi i u slavi svetih anđela.” ");
INSERT INTO hrvbib_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Nadalje reče: “Zaista vam kažem, neki među vama koji ste ovdje neće umrijeti prije nego što vide Božje kraljevstvo kako dolazi sa silom!” ");
INSERT INTO hrvbib_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Nakon šest dana povede Isus sa sobom Petra, Jakova i Ivana visoko u goru, u osamu. Tu se pred njima preobrazi. ");
INSERT INTO hrvbib_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Haljine mu postanu tako blještavo bijele kako ih ne bi mogao izbijeliti nijedan bjelilac na zemlji. ");
INSERT INTO hrvbib_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Tada se pojave Ilija i Mojsije te počnu razgovarati s Isusom. ");
INSERT INTO hrvbib_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","“Učitelju, dobro je što smo ovdje!” reče mu Petar. “Napravit ćemo tu tri sjenice: jednu za tebe, jednu za Mojsija i jednu za Iliju.” ");
INSERT INTO hrvbib_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Nije, naime, znao što da kaže jer su se silno prestrašili. ");
INSERT INTO hrvbib_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Dok je to još govorio, prekrije ih oblak, a iz njega se začuje glas: “Ovo je moj ljubljeni Sin! Njega slušajte!” ");
INSERT INTO hrvbib_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Oni smjesta pogledaju uokolo. Mojsije i Ilija bijahu nestali i samo je Isus bio s njima. ");
INSERT INTO hrvbib_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Dok su silazili s gore, Isus im zapovjedi da nikome ne govore što su vidjeli sve dok Sin Čovječji ne ustane od mrtvih. ");
INSERT INTO hrvbib_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Zadržali su to za sebe, ali su o tome razgovarali i pitali se na što je mislio kad je rekao da će “ustati od mrtvih”. ");
INSERT INTO hrvbib_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Upitaju ga: “Zašto pismoznanci tvrde da prije Mesije mora doći Ilija?” ");
INSERT INTO hrvbib_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","“Nesumnjivo najprije mora doći Ilija”, reče on, “da sve opet stavi na svoje mjesto. Kako onda u Svetomu pismu piše da će Sin Čovječji mnogo trpjeti te da će biti prezren? ");
INSERT INTO hrvbib_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ali vam kažem da je Ilija već došao i su s njim postupili kako im se prohtjelo, baš kao je u Pismu i pretkazano.” ");
INSERT INTO hrvbib_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Kad su se vratili ostalim učenicima, opaze da se ondje okupilo mnoštvo ljudi i pismoznanci te da se prepiru. ");
INSERT INTO hrvbib_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Mnoštvo je sa strahopoštovanjem promatralo Isusa dok im je prilazio, a onda mu potrčalo u susret da ga pozdravi. ");
INSERT INTO hrvbib_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","“Oko čega se prepirete?” upita ih. ");
INSERT INTO hrvbib_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Neki čovjek iz mnoštva mu reče: “Učitelju, doveo sam svojeg sina da ga iscijeliš—ne može govoriti jer je opsjednut nijemim duhom. ");
INSERT INTO hrvbib_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kad ga uhvati, baci ga na zemlju, na usta mu ide pjena, škripi zubima i koči se. Zato sam zamolio tvoje učenike da ga istjeraju, ali nisu mogli.” ");
INSERT INTO hrvbib_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","“O nevjerni rode!” reče Isus učenicima. “Koliko dugo još moram biti s vama? Dokle vas moram podnositi? Dovedite mi ga!” ");
INSERT INTO hrvbib_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Dovedu ga. Kad je ugledao Isusa, duh silno zgrči ga. On padne na tlo previjajući se, a na usta mu udari pjena. ");
INSERT INTO hrvbib_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","“Otkad mu je tako?” upita Isus oca. “Još odmalena”, odgovori. ");
INSERT INTO hrvbib_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","“Duh ga ćesto baci u vatru ili u vodu da ga ubije. Smiluj nam se i učini što ako možeš!” ");
INSERT INTO hrvbib_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","“Ako mogu?” zapita ga Isus. “Sve je moguće onomu koji vjeruje!” ");
INSERT INTO hrvbib_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Dječakov otac smjesta poviče: “Vjerujem! Pomozi mi da ne sumnjam!” ");
INSERT INTO hrvbib_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Kad Isus opazi da im prilazi sve više ljudi, zaprijeti nečistome duhu: “Nijemi i gluhi duše! Zapovijedam ti da iziđeš iz njega i da se više ne vraćaš!” ");
INSERT INTO hrvbib_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Zli duh vrisne, silno zgrči dječaka, pa iziđe iz njega. Dječak ostane beživotno ležati, pa mnogi rekoše: “Mrtav je!” ");
INSERT INTO hrvbib_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ali Isus ga uzme za ruku i pomogne mu ustati te se on osovi na noge. ");
INSERT INTO hrvbib_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Kad uđe u kuću i ostane nasamo s učenicima, oni ga upitaju: “Zašto mi nismo mogli istjerati tog zloduha?” ");
INSERT INTO hrvbib_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Isus im reče: “Ta se vrsta može istjerati samo molitvom.” ");
INSERT INTO hrvbib_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Odlazeći iz toga kraja, putovali su Galilejom. Isus nije htio da ljudi saznaju da su ondje. ");
INSERT INTO hrvbib_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Poučavao je, naime, učenike i reče im: “Sin Čovječji bit će predan ljudima u ruke. Ubit će ga, ali on će nakon tri dana uskrsnuti.” ");
INSERT INTO hrvbib_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ali oni nisu razumjeli što im kazuje, a bojali su se pitati ga da im objasni. ");
INSERT INTO hrvbib_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Stignu tako u Kafarnaum. Kad su se smjestili u kući u kojoj su kanili boraviti, Isus ih upita: “O čemu ste to putem raspravljali?” ");
INSERT INTO hrvbib_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ali oni su samo šutjeli jer su se prepirali oko toga tko je od njih najveći. ");
INSERT INTO hrvbib_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Isus sjedne i pozove ih bliže te im reče: “Tko želi biti prvi, taj sebe mora staviti na zadnje mjesto i biti sluga svima!” ");
INSERT INTO hrvbib_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Zatim uzme dijete, postavi ga u sredinu između njih, zagrli ga te im reče: ");
INSERT INTO hrvbib_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Tko prihvati takvo malo dijete radi mene, mene prihvaća. A tko mene prihvati, prihvaća Boga koji me je poslao.” ");
INSERT INTO hrvbib_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ivan mu reče: “Učitelju, vidjeli smo nekog čovjeka da se koristi tvojim imenom izgoneći zle duhove; rekli smo mu da to ne radi jer nije iz naše skupine.” ");
INSERT INTO hrvbib_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","“Ne branite mu!” reče im Isus. “Jer nema toga tko bi mogao činiti čudesa u moje ime, a onda ubrzo govoriti zlo o meni. ");
INSERT INTO hrvbib_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Tko nije protiv nas, za nas je! ");
INSERT INTO hrvbib_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Tko vas napoji čašom vode, zato što meni pripadate, sigurno neće mu propasti nagrada. ");
INSERT INTO hrvbib_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ali tko jednoga od ovih malenih koji vjeruju u mene navede da posrne u vjeri, bilo bi mu bolje da mu o vrat objese mlinski kamen i bacili ga u more. ");
INSERT INTO hrvbib_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Navodi li te vlastita ruka na grijeh, odsijeci ju. Bolje ti je kljastu ući u vječni život nego s objema rukama biti bačen u neugasivi oganj pakla, ");
INSERT INTO hrvbib_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","gdje crv ne umire i gdje se oganj ne gasi. ");
INSERT INTO hrvbib_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Navodi li te na grijeh vlastita noga, odsijeci ju! Bolje ti je hromu ući u vječni život nego s objema nogama biti bačen u pakao, ");
INSERT INTO hrvbib_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","gdje crv ne umire i gdje se oganj ne gasi. ");
INSERT INTO hrvbib_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Navodi li te i vlastito oko na grijeh, iskopaj ga i baci! Bolje ti je bez jednog oka ući u kraljevstvo Božje nego s oba oka biti bačen u pakao, ");
INSERT INTO hrvbib_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","gdje crv ne umire i gdje se oganj ne gasi. ");
INSERT INTO hrvbib_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Svatko će biti vatrom zasoljen. ");
INSERT INTO hrvbib_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Sol je dobra. Ali ako ona obljutavi, čime ćete ju opet osoliti? Zato ne gubite svoju slanost! Živite u miru jedni s drugima!” ");
INSERT INTO hrvbib_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Isus ode iz Kafarnauma južnije, u judejski kraj te istočno od rijeke Jordana. I opet nagrne k njemu mnoštvo naroda te ih je po svojemu običaju poučavao. ");
INSERT INTO hrvbib_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Priđu mu neki farizeji pa ga upitaju pokušavajući ga zaskočiti: “Smije li se muž razvesti od žene?” ");
INSERT INTO hrvbib_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","“Što vam je o tome zapovjedio Mojsije?” upita ih Isus. ");
INSERT INTO hrvbib_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","“On je to dopustio”, odgovore mu. “Rekao je da muž mora ženi samo napisati otpusnicu i može ju otpustiti.” ");
INSERT INTO hrvbib_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","“Mojsije vam je napisao ovu zapovijed zbog vaših tvrdih srca! ");
INSERT INTO hrvbib_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Jer Bog ih je još na početku stvorenja stvorio ‘muškim i ženskim’. ");
INSERT INTO hrvbib_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Čovjek će ostaviti oca i majku da bi se sjedinio sa svojom ženom, ");
INSERT INTO hrvbib_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","i njih će dvoje biti jedno tijelo.’ Njih dvoje, prema tome, nisu više dva, nego jedno. ");
INSERT INTO hrvbib_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Neka dakle nijedan čovjek ne rastavlja one koje je Bog sjedinio!” ");
INSERT INTO hrvbib_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Kad su bili u kući, učenici ga ponovno o tomu upitaju. ");
INSERT INTO hrvbib_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","On im reče: “Tko god se razvede od svoje žene da bi se oženio drugom, čini preljub prema prvoj ženi. ");
INSERT INTO hrvbib_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Rastavi li se žena od muža i preuda, ona također čini preljub.” ");
INSERT INTO hrvbib_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Isusu su dovodili djecu da ih dotakne i blagoslovi. Učenici su im to priječili. ");
INSERT INTO hrvbib_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Kad je Isus to vidio, razljutio se te im reče: “Pustite dječicu k meni i ne tjerajte ih jer takvima pripada Božje kraljevstvo! ");
INSERT INTO hrvbib_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Zaista vam kažem, tko kraljevstvo Božje ne prihvati poput te dječice, nikada neće u njega ući!” ");
INSERT INTO hrvbib_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Tada izgrli djecu i blagoslovi ih polažući na njih ruke. ");
INSERT INTO hrvbib_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Dok se spremao na put, pritrči mu neki čovjek, klekne pred njega i upita ga: “Dobri učitelju, što moram učiniti da dobijem vječni život?” ");
INSERT INTO hrvbib_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","“Zašto me zoveš dobrim?” upita ga Isus. “Dobar je samo Bog. ");
INSERT INTO hrvbib_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","A zapovijedi znaš: ‘Ne ubij’, ‘Ne čini preljub’, ‘Ne ukradi’, ‘Ne svjedoči lažno’, ‘Ne varaj’, ‘Poštuj oca i majku!’” ");
INSERT INTO hrvbib_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","“Gospodine, sve te zapovijedi držim još od mladosti”, odgovori čovjek. ");
INSERT INTO hrvbib_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Isus ga promotri i zavoli ga. “Još ti jedno nedostaje”, reče mu, “idi i prodaj sve što imaš, a novac razdijeli siromasima pa ćeš imati blago na nebu. A onda dođi i slijedi me!” ");
INSERT INTO hrvbib_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Čovjek se na te riječi snuždi i žalosno ode jer je imao veliki imetak. ");
INSERT INTO hrvbib_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Isus pogleda uokolo i reče učenicima: “Kako je teško bogatašima ući u kraljevstvo Božje!” ");
INSERT INTO hrvbib_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Oni se na to silno iznenade. Isus nastavi: “Djeco draga, kako je teško ući u kraljevstvo Božje! ");
INSERT INTO hrvbib_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Lakše bi devi bilo provući se kroz iglenu ušicu nego bogatašu ući u Božje kraljevstvo!” ");
INSERT INTO hrvbib_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Učenici se zaprepaste. “Pa tko se onda uopće može spasiti?” pitali su. ");
INSERT INTO hrvbib_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Isus ih pozorno pogleda pa reče: “Ljudima je to potpuno nemoguće, ali ne i Bogu. Jer Bogu je sve moguće!” ");
INSERT INTO hrvbib_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Petar mu reče: “Evo, mi smo sve ostavili da te slijedimo.” ");
INSERT INTO hrvbib_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Isus odgovori: “Zaista vam kažem, nema takvoga tko se radi mene i radi Radosne vijesti odrekao kuće, braće, sestara, majke, oca, djece ili imanja, ");
INSERT INTO hrvbib_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","a da uz progonstvo neće već u ovome svijetu dobiti natrag stostruko: kuće, braću, sestre, majku, oca, djecu i imanja, a u budućemu svijetu i vječni život. ");
INSERT INTO hrvbib_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ali mnogi koji su sada prvi tada će biti na zadnjemu mjestu, a mnogi koje ovdje smatraju zadnjima ondje će biti najveći.” ");
INSERT INTO hrvbib_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Uspinjali su se prema Jeruzalemu. Isus je išao pred zaprepaštenim učenicima. Ljudi koji su ga slijedili bili su prestrašeni. Isus povede Dvanaestoricu na stranu i počne im još jedanput govoriti o onomu što mu se imalo dogoditi: ");
INSERT INTO hrvbib_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Evo, ulazimo u Jeruzalem. Tamo će Sina Čovječjega predati svećeničkim glavarima i pismoznancima, koji će ga osuditi na smrt i predati Rimljanima. ");
INSERT INTO hrvbib_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Rugat će mu se, popljuvati ga, bičevati i ubiti. Ali on će nakon tri dana uskrsnuti.” ");
INSERT INTO hrvbib_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Zatim mu priđu Jakov i Ivan, Zebedejevi sinovi, i mu rekoše: “Učitelju, htjeli bismo da nam nešto učiniš.” ");
INSERT INTO hrvbib_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","“A što?” upita ih Isus. ");
INSERT INTO hrvbib_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","“Dopusti nam, kad uđeš u svoju slavu, da sjedimo na počasnim mjestima do tebe, jedan s desne, a drugi s lijeve strane.” ");
INSERT INTO hrvbib_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Isus odgovori: “Ne znate što tražite. Možete li vi ispiti gorku čašu iz koje ću ja piti? Ili se krstiti krštenjem trpljenja kojim se ja moram krstiti?” ");
INSERT INTO hrvbib_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","“Možemo!” odgovore oni. A on reče: “Zaista ćete piti iz moje čaše i krstit ćete se mojim krštenjem, ");
INSERT INTO hrvbib_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","ali nije na meni da odredim tko će sjediti zdesna ili slijeva do mene. Ta mjesta pripadaju onima za koje su određena.” ");
INSERT INTO hrvbib_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Kad su to čula ostala desetorica učenika, naljute se na Jakova i Ivana. ");
INSERT INTO hrvbib_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Zato ih Isus dozove k sebi i reče: “Vi znate da oni koji se smatraju vladarima svijeta okrutno postupaju s narodom i da moćnici nad njim vladaju stegom. ");
INSERT INTO hrvbib_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ali nije tako među vama! Naprotiv, tko želi biti najveći među vama, neka vam bude sluga. ");
INSERT INTO hrvbib_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Tko želi biti najveći od svih, neka svima bude robom. ");
INSERT INTO hrvbib_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Jer ni Sin Čovječji nije došao da mu služe, već da on služi drugima i dade svoj život kao otkupninu za mnoge.” ");
INSERT INTO hrvbib_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Stigli su tako u Jerihon. Kad je Isus izlazio iz Jerihona u pratnji učenika i velikog mnoštva, pokraj puta sjedio je slijepi prosjak Bartimej, Timejev sin. ");
INSERT INTO hrvbib_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Kad je čuo da je stigao Isus iz Nazareta, počeo je vikati: “Isuse, sine Davidov, smiluj mi se!” ");
INSERT INTO hrvbib_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Mnogi su ga korili i opominjali ga da ušuti, ali on počne još jače vikati: “Sine Davidov, smiluj mi se!” ");
INSERT INTO hrvbib_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Kad Isus to začuje, zaustavi se i reče: “Recite mu da priđe.” Oni pozovu slijepca. “Samo hrabro!” kazaše mu. “Hajde, zove te!” ");
INSERT INTO hrvbib_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Bartimej zbaci sa sebe ogrtač, skoči i pritrči Isusu. ");
INSERT INTO hrvbib_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","“Što želiš da ti učinim?” upita ga Isus. “Da progledam, Gospodine!,” zamoli slijepac. ");
INSERT INTO hrvbib_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","“Hajde!”, odgovori mu Isus. “Tvoja te je vjera iscijelila!” Slijepac smjesta progleda i krene cestom za Isusom. ");
INSERT INTO hrvbib_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Kad su se Isus i učenici približili Jeruzalemu te stigli pred Betfagu i Betaniju na Maslinskoj gori, Isus pošalje naprijed dvojicu učenika. ");
INSERT INTO hrvbib_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“Idite u ono selo pred vama”, reče im, “i čim uđete, vidjet ćete privezano magare koje još nitko nije jahao. Odvežite ga i dovedite ovamo. ");
INSERT INTO hrvbib_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Upita li vas tko: ‘Što to radite?’ recite samo: ‘Treba Gospodinu. Brzo će ga vratiti.’” ");
INSERT INTO hrvbib_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Oni odu i nađu magare zavezano na ulici, pokraj vrata neke kuće, te ga odvežu. ");
INSERT INTO hrvbib_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Neki ih ljudi upitaju: “Zašto ste odvezali magare?” ");
INSERT INTO hrvbib_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Oni im odgovore kako ih je Isus uputio te ih ljudi ostave na miru. ");
INSERT INTO hrvbib_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Dovedu magare Isusu i prebace preko njega svoje ogrtače te ga Isus uzjaha. ");
INSERT INTO hrvbib_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Mnogi iz mnoštva razastru po cesti pred njim svoje ogrtače, drugi opet zelene grane koje su natrgali u polju. ");
INSERT INTO hrvbib_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","I pred njim i iza njega išlo je mnoštvo i klicalo: “Slava Bogu! Blagoslovljen koji dolazi u ime Gospodnje! ");
INSERT INTO hrvbib_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Blagoslovljeno kraljevstvo koje on donosi, kraljevstvo našega oca Davida! Slava Bogu na nebu!” ");
INSERT INTO hrvbib_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Tako uđe u Jeruzalem, u Hram. Pomnjivo sve razgleda te, jer je već bilo kasno, ode s Dvanaestoricom u Betaniju. ");
INSERT INTO hrvbib_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Sljedećeg jutra krenu iz Betanije, a Isus ogladni. ");
INSERT INTO hrvbib_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Izdaleka opazi razlistalu smokvu pa joj priđe da vidi ima li na njoj koja smokva. Ali nije bilo ničega osim lišća jer još nije bilo vrijeme da smokva donese rod. ");
INSERT INTO hrvbib_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Isus reče stablu: “Nikada više nitko s tebe ploda ne jeo!” Čuli su to i učenici. ");
INSERT INTO hrvbib_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Kad opet stignu u Jeruzalem, on ode u Hram i počne izgoniti iz njega trgovce i njihove kupce, prevrne stolove mjenjačima novca i klupe prodavačima goluba. ");
INSERT INTO hrvbib_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Svima zabrani da prolaze Hram noseći stvari. ");
INSERT INTO hrvbib_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Pouči ih: “Nije li napisano u Svetome pismu: ‘Moj Hram treba biti molitveni dom za sve narode’?, a vi ste ga pretvorili u razbojničku špilju!” ");
INSERT INTO hrvbib_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Kad su to čuli svećenički poglavari i pismoznanci, počnu smišljati kako da ga ubiju. Bojali su ga se jer je narod bio oduševljen Isusovim učenjem. ");
INSERT INTO hrvbib_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Uvečer Isus i učenici odu iz grada. ");
INSERT INTO hrvbib_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Prolazeći ujutro pokraj smokve koju je Isus prokleo, opaze da se iz korijena osušila. ");
INSERT INTO hrvbib_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Petar se sjeti Isusovih riječi i uzvikne: “Učitelju, pogledaj! Smokva koju si prokleo osušila se!” ");
INSERT INTO hrvbib_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","“Imajte vjeru u Boga!” odgovori im Isus. ");
INSERT INTO hrvbib_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","“Zaista vam kažem, kada bi tko rekao ovoj planini: ‘Digni se i baci se u more’ i pritom ne bi posumnjao u srcu, nego vjerovao da će se to i dogoditi, to bi se zaista zbilo. ");
INSERT INTO hrvbib_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Zato vam kažem: što god da u molitvi tražite, vjerujte da ste to već dobili, pa ćete i dobiti. ");
INSERT INTO hrvbib_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ali kad god ustanete moliti, najprije oprostite svima onima kojima što zamjerate da bi i vama nebeski Otac oprostio vaše grijehe.” ");
INSERT INTO hrvbib_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ali ne oprostite li vi drugima njihovih pogrešaka, ni vaš nebeski Otac neće vama oprostiti vaše grijehe. ");
INSERT INTO hrvbib_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Stignu opet u Jeruzalem. Dok je Isus prolazio Hramom, pristupe mu svećenički poglavari, pismoznanci i starješine ");
INSERT INTO hrvbib_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","te ga upitaju: “Tko ti je dao pravo da to činiš? Tko te je ovlastio za to?” ");
INSERT INTO hrvbib_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Isus im odgovori: “Reći ću vam tko ako najprije vi meni odgovorite na pitanje: ");
INSERT INTO hrvbib_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Je li Ivanovo krštenje bilo s neba ili od ljudi? Odgovorite mi!” ");
INSERT INTO hrvbib_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Oni počnu umovati i međusobno raspravljati: “Ako kažemo da je s neba, pitat će nas zašto mu onda nismo vjerovali. ");
INSERT INTO hrvbib_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","A da kažemo da je od ljudi?” Bojali su se, međutim, naroda jer su Ivana svi držali za pravog proroka. ");
INSERT INTO hrvbib_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Zato Isusu odgovore: “Ne znamo.” A Isus im reče: “Onda ni ja vama neću reći otkuda mi vlast!” ");
INSERT INTO hrvbib_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Tada im počne govoriti u prispodobama: “Neki čovjek posadi vinograd i ogradi ga, iskopa tijesak za grožđe i izgradi kulu. Zatim ga iznajmi vinogradarima i otputuje. ");
INSERT INTO hrvbib_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Kad dođe vrijeme berbe, pošalje slugu da ubere njegov dio uroda. ");
INSERT INTO hrvbib_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ali vinogradari ga dograbe, pretuku i pošalju natrag praznih ruku. ");
INSERT INTO hrvbib_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Vlasnik vinograda im zatim pošalje drugog slugu. Zakupci mu razbiju glavu i osramote ga. ");
INSERT INTO hrvbib_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Trećega kojeg im je poslao ubiju. Poslao im je i mnoge druge, ali oni ih sve premlate ili ubiju. ");
INSERT INTO hrvbib_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Preostao mu je samo još jedan: njegov ljubljeni sin. Pošalje napokon i njega misleći: ‘Prema mojem sinu sigurno će se odnositi s poštovanjem.’ ");
INSERT INTO hrvbib_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ali kad vinogradari opaze da dolazi, rekoše: ‘Ovaj će naslijediti imanje. Ubijmo ga pa ćemo se domognuti imanja umjesto njega!’ ");
INSERT INTO hrvbib_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Pa ga pograbe, ubiju i izbace tijelo iz vinograda. ");
INSERT INTO hrvbib_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Što mislite da će učiniti vlasnik kad čuje što se dogodilo? Doći će i pobiti te vinogradare, a vinograd dati u najam drugima. ");
INSERT INTO hrvbib_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ne sjećate li se ulomka iz Svetog pisma: ‘Kamen koji su graditelji odbacili postane ugaonim kamenom. ");
INSERT INTO hrvbib_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","To je Gospodnje djelo, čudesno u našim očima.’?” ");
INSERT INTO hrvbib_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Židovski su ga vođe već tada htjeli uhvatiti jer su dobro znali da se ta prispodoba odnosi na njih, ali bojali su se mnoštva. Zato odu i ostave ga. ");
INSERT INTO hrvbib_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Vjerski mu vođe pošalju neke farizeje i Herodove sljedbenike da ga uhvate u riječi. ");
INSERT INTO hrvbib_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Oni dođu i rekoše mu: “Učitelju, znamo da govoriš istinu i da si nepristran jer ne gledaš tko je tko, nego prema istini poučavaš putu Božjemu. Reci nam je li dopušteno plaćati porez caru ili nije.” ");
INSERT INTO hrvbib_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Isus prozre njihovo licemjerje pa reče: “Zašto me kušate? Pokažite mi kovani novac pa ću vam reći.” ");
INSERT INTO hrvbib_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Donesu mu novčić, a on upita: “Čiji su ovo lik i natpis na kovanici?” “Carevi”, odgovore. ");
INSERT INTO hrvbib_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","“Onda dajte caru carevo, ali Bogu valja dati Božje”, reče im. Bili su zadivljeni. ");
INSERT INTO hrvbib_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Tada dođu k njemu saduceji, koji tvrde da nema uskrsnuća, i upitaju ga: ");
INSERT INTO hrvbib_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Gospodine, Mojsije nam je dao zakon prema kojemu, umre li oženjen muškarac bez djece, njegov se brat mora oženiti njegovom udovicom kako bi ona rodila sina koji će naslijediti posjed umrloga i nositi njegovo ime. ");
INSERT INTO hrvbib_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Bilo je sedmero braće. Prvi se brat oženi i umre a da nije imao sina. ");
INSERT INTO hrvbib_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Drugi se brat oženi njegovom udovicom, ali također umre a da nije ostavio sina. S trećim se dogodi isto. ");
INSERT INTO hrvbib_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Tako nijedan od sedmorice ne ostavi potomstva. Na posljetku umre i žena. ");
INSERT INTO hrvbib_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Čija će onda ona biti žena o uskrsnuću kad je bila udana za svu sedmoricu?” ");
INSERT INTO hrvbib_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Isus im odgovori: “Niste li vi u zabludi zato što ne razumijete Sveto pismo ni Božju silu? ");
INSERT INTO hrvbib_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Jer kad ljudi uskrsnu od mrtvih, neće se ženiti ni udavati, već će biti kao anđeli na nebu. ");
INSERT INTO hrvbib_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","A glede uskrsnuća, niste li u Knjizi Izlaska, ondje gdje piše kako je Mojsije ugledao gorući grm, pročitali da mu je Bog rekao: ‘Ja sam Bog Abrahamov, Izakov i Jakovljev’ dugo nakon što su oni poumirali? ");
INSERT INTO hrvbib_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","A Bog nije Bog mrtvih, već Bog živih! Vi ste, prema tome, u velikoj zabludi!” ");
INSERT INTO hrvbib_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Neki pismoznanac koji je ondje stajao shvatio je, slušajući raspravu, da je Isus dobro odgovorio pa ga upita: “Koja je najvažnija od svih zapovijedi?” ");
INSERT INTO hrvbib_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Isus odgovori: “Najvažnija glasi: ‘Čuj, o Izraele! Naš Gospodin Bog jest jedini Bog. ");
INSERT INTO hrvbib_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ljubi Gospodina Boga svojega svim srcem svojim, svom dušom svojom, svom pameti svojom i svom snagom svojom!’ ");
INSERT INTO hrvbib_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Druga glasi: ‘Ljubi svojega bližnjega kao samoga sebe!’ Nema zapovijedi koja bi bila veća od tih dviju.” ");
INSERT INTO hrvbib_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Pismoznanac odgovori: “Učitelju, pravo si rekao da je Bog jedini i da nema drugih osim njega. ");
INSERT INTO hrvbib_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Voljeti ga svim srcem, svim razumom i svom snagom, a bližnjega voljeti kao samoga sebe vrijedi više nego sve paljenice i ostale žrtve.” ");
INSERT INTO hrvbib_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Videći da pametno govori, Isus mu reče: “Nisi daleko od Božjeg kraljevstva.” I nitko ga se više nije usudio išta pitati. ");
INSERT INTO hrvbib_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Poučavajući u Hramu, Isus upita: “Kako pismoznanci mogu tvrditi da je Mesija Davidov sin? ");
INSERT INTO hrvbib_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Pa sâm je David, nadahnut Svetim Duhom, rekao: ‘Gospodin je rekao mojem Gospodinu: Sjedni mi s desne strane dok ti ne bacim pod noge tvoje neprijatelje.’ ");
INSERT INTO hrvbib_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Sâm ga je David nazvao svojim Gospodinom. Kako bi mu onda mogao biti sin?” Mnoštvo ga je oduševljeno slušalo. ");
INSERT INTO hrvbib_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Poučavajući ih dalje, reče: “Čuvajte se pismoznanaca! Vole se šetati u dugim haljinama i da ih ljudi pozdravljaju na trgovima. ");
INSERT INTO hrvbib_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","U sinagogama vole sjediti na počasnim mjestima, a na gozbama na pročelju stola. ");
INSERT INTO hrvbib_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Besramno troše udovička dobra, a prikrivaju se dugačkim molitvama u javnosti. Oni će biti strože kažnjeni.” ");
INSERT INTO hrvbib_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Zatim ode sjesti do kutije za milodare te je promatrao mnoštvo kako ubacuje bakreni novac. Mnogi su bogataši ubacivali velike iznose. ");
INSERT INTO hrvbib_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Dođe i neka siromašna udovica te ubaci samo dva novčića. ");
INSERT INTO hrvbib_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Isus dozove učenike i reče im: “Zaista vam kažem, ta je siromašna udovica ubacila više nego svi ostali skupa! ");
INSERT INTO hrvbib_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Jer svi su oni dali od svojeg viška, a ona je, tako siromašna, dala sve što je imala.” ");
INSERT INTO hrvbib_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Kad je Isus izlazio iz Hrama, jedan od učenika mu reče: “Učitelju, pogledaj! Kakva li kamenja! Kakve li građevine!” ");
INSERT INTO hrvbib_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","“Vidiš li kako je velika?” odgovori mu Isus. “A bit će porušena tako da od nje neće ostati ni kamen na kamenu.” ");
INSERT INTO hrvbib_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Dok je sjedio na Maslinskoj gori nasuprot Hramu, Petar, Jakov, Ivan i Andrija nasamo ga upitaju: ");
INSERT INTO hrvbib_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Kada će se sve to dogoditi? Kojim će se znakom najaviti ispunjenje svega toga?” ");
INSERT INTO hrvbib_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Isus im odgovori: “Pazite da vas tko ne zavede! ");
INSERT INTO hrvbib_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Mnogi će doći pod mojim imenom proglašujući se Mesijom i mnoge će zavesti. ");
INSERT INTO hrvbib_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Kad čujete da blizu vas izbijaju ratovi i vijesti o dalekim ratovima, ne uznemirujte se. Sve se to mora dogoditi, ali svršetak još neće doći. ");
INSERT INTO hrvbib_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Zaratit će narod protiv naroda i kraljevstvo protiv kraljevstva. Bit će potresa u mnogim dijelovima svijeta i zavladat će glad. Sve je to samo početak strašnih muka. ");
INSERT INTO hrvbib_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Kad se to počne događati, budite na oprezu! Predavat će vas sudovima i bičevati u sinagogama. Izvodit će vas pred upravitelje i kraljeve zato što ste moji sljedbenici. To će biti prigoda da im svjedočite o meni. ");
INSERT INTO hrvbib_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Radosna vijest mora se najprije navijestiti svim narodima. ");
INSERT INTO hrvbib_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Kad vas uhite i predaju sudu, ne brinite se unaprijed što ćete govoriti jer će vam tada biti dano što da kažete. Nećete govoriti vi, nego Sveti Duh. ");
INSERT INTO hrvbib_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Brat će brata i otac dijete predavati na smrt. Djeca će se dizati protiv roditelja i predavati ih da ih ubiju. ");
INSERT INTO hrvbib_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Svi će vas zamrziti zbog mene, ali tko ustraje do kraja, spasit će se. ");
INSERT INTO hrvbib_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Kad vidite ‘svetogrđe’ da stoji ondje gdje ne smije stajati (čitatelju, shvati o čemu je riječ!), neka oni koji se zateknu u Judeji bježe u goru. ");
INSERT INTO hrvbib_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Tko se zatekne na krovu, neka ne silazi u kuću što uzeti! ");
INSERT INTO hrvbib_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Tko se zatekne u polju, neka se ne vraća po ogrtač! ");
INSERT INTO hrvbib_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Teško trudnicama i dojiljama u to vrijeme! ");
INSERT INTO hrvbib_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Molite se da ne morate bježati zimi ");
INSERT INTO hrvbib_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","jer će to biti dani tako strašnih nevolja kakvih nije bilo otkako je Bog stvorio svijet niti će ih biti ikad poslije. ");
INSERT INTO hrvbib_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","I da Gospodin ne skrati to vrijeme nevolja, nitko se ne bi spasio. Ali on je skratio te dane zaradi svojih izabranika. ");
INSERT INTO hrvbib_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Kaže li vam tada tko: ‘Evo Mesije!’ ili ‘Eno ga ondje!’ ne vjerujte ");
INSERT INTO hrvbib_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","jer će ustati brojni lažni mesije i lažni proroci te činiti čudesa ne bi li, bude li moguće, zaveli i Božje izabranike. ");
INSERT INTO hrvbib_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Budite oprezni! Unaprijed sam vas upozorio! ");
INSERT INTO hrvbib_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","U vrijeme kad prođu sve te strahote, Sunce će potamnjeti i mjesec neće sjati, ");
INSERT INTO hrvbib_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","zvijezde će s neba padati i nebeske će se sile potresti. ");
INSERT INTO hrvbib_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Tada će ugledati Sina Čovječjega kako dolazi na oblacima s velikom moći i slavom. ");
INSERT INTO hrvbib_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","On će poslati anđele da saberu njegove izabranike sa svih strana, sa svih četiriju vjetrova od kraja zemlje do kraja neba. ");
INSERT INTO hrvbib_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Učite iz prispodobe o smokvi. Kad joj na granama izbiju nježni pupovi i kad potjera lišće, znate da je ljeto blizu. ");
INSERT INTO hrvbib_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Također kad vidite da se zbiva sve o čemu sam vam govorio, možete biti sigurni da je Gospodinov povratak blizu, na samim vratima. ");
INSERT INTO hrvbib_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Zaista vam kažem, ovaj naraštaj neće proći dok se sve to ne dogodi. ");
INSERT INTO hrvbib_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Nebo i zemlja će proći, ali moje riječi ostaju zauvijek! ");
INSERT INTO hrvbib_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Nitko, međutim, ne zna dana ni ure kada će se to dogoditi. Ne znaju ni anđeli na nebu, pa čak ni Sin. Zna samo Otac. ");
INSERT INTO hrvbib_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Bdijte, dakle, i stražite jer ne znate kada će se to zbiti! ");
INSERT INTO hrvbib_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Dolazak Sina Čovječjega može se usporediti s odlaskom čovjeka koji je otputovao u drugu zemlju. Prije polaska kuću je povjerio na brigu slugama. Svakome je zadao posao, a vrataru zapovjedio da budno čeka njegov povratak. ");
INSERT INTO hrvbib_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Bdijte, dakle, jer ne znate kada će se gospodar vratiti—uvečer, u ponoć, u ranu zoru kad pjevaju pijetli ili ujutro— ");
INSERT INTO hrvbib_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","da ne dođe iznenada i nađe vas kako spavate. ");
INSERT INTO hrvbib_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Što kažem vama, kažem svima: Budno iščekujte njegov dolazak!” ");
INSERT INTO hrvbib_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Bila su dva dana do Pashe i do Blagdana beskvasnih kruhova. Svećenički poglavari i pismoznanci još su čekali prigodu da Isusa na prijevaru uhvate i ubiju. ");
INSERT INTO hrvbib_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","“Nećemo na blagdanskoj svetkovini”, rekli su, “da se narod ne pobuni.” ");
INSERT INTO hrvbib_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Dok je Isus u međuvremenu bio u Betaniji u kući Šimuna gubavca, uđe neka žena s alabasternom posudom skupocjenoga nardova mirisnog ulja. Razbije grlo posude i izlije ulje Isusu na glavu. ");
INSERT INTO hrvbib_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Neki se zbog toga naljute: “Čemu tako rasipati skupocjenu pomast! ");
INSERT INTO hrvbib_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Mogla se skupo prodati, a novac dati siromasima.” ");
INSERT INTO hrvbib_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ali Isus im reče: “Pustite ju na miru! Zašto joj dodijavate? Učinila mi je dobro djelo. ");
INSERT INTO hrvbib_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Siromaha će uvijek biti da im pomažete kad god budete htjeli, a ja neću uvijek biti s vama. ");
INSERT INTO hrvbib_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ona je učinila što je mogla. Unaprijed je pomazala moje tijelo za ukop. ");
INSERT INTO hrvbib_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Zaista vam kažem, gdje god se diljem svijeta bude propovijedala Radosna vijest, spominjat će se i ovo njezino djelo, njoj na uspomenu.” ");
INSERT INTO hrvbib_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Tada Juda Iškariotski, jedan od Dvanaestorice, ode svećeničkim poglavarima da se dogovori kako će izdati Isusa. ");
INSERT INTO hrvbib_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Oni se obraduju i obećaju mu dati novca. Tako Juda počne tražiti prigodu da izda Isusa. ");
INSERT INTO hrvbib_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Na prvi dan Blagdana beskvasnih kruhova, kad je bio običaj žrtvovati pashalno janje, učenici upitaju Isusa: “Gdje želiš da ti pripravimo pashalnu večeru?” ");
INSERT INTO hrvbib_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","On pošalje dvojicu u Jeruzalem: “Idite u grad. Tamo ćete sresti čovjeka koji nosi vodu u vrču. Pođite za njim. ");
INSERT INTO hrvbib_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","U kući u koju uđe potražite domaćina pa mu recite: ‘Učitelj pita u kojoj sobi može blagovati pashalnu večeru sa svojim učenicima.’ ");
INSERT INTO hrvbib_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","On će vam pokazati veliku sobu na katu, posve pripremljenu. Ondje nam pripravite večeru.” ");
INSERT INTO hrvbib_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Učenici odu u grad i nađu sve kako im je Isus rekao te ondje pripreme pashalnu večeru. ");
INSERT INTO hrvbib_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Uvečer Isus dođe s Dvanaestoricom. ");
INSERT INTO hrvbib_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Dok su jeli za stolom, reče im: “Zaista vam kažem, jedan od vas koji sa mnom jedete izdat će me!” ");
INSERT INTO hrvbib_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Oni se silno ražaloste pa ga jedan za drugim počnu pitati: “Nisam valjda ja taj?” ");
INSERT INTO hrvbib_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","On odgovori: “To je jedan od vas Dvanaestorice, koji sa mnom umače kruh u istu zdjelu. ");
INSERT INTO hrvbib_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Jer ja, Sin Čovječji, moram umrijeti kao što piše u Svetome pismu. Ali teško onome koji izda Sina Čovječjega! Bilo bi mu bolje da se nije ni rodio!” ");
INSERT INTO hrvbib_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Dok su blagovali, Isus uzme kruh, blagoslovi ga i razlomi ga i podijeli im govoreći: “Uzmite! Ovo je moje tijelo.” ");
INSERT INTO hrvbib_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Zatim uzme čašu vina, zahvali Bogu i pruži njima. Svi su iz nje pili. ");
INSERT INTO hrvbib_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","A on im reče: “Ovo je moja krv, krv Saveza, koja se za mnoge prolijeva. ");
INSERT INTO hrvbib_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Zaista vam kažem: Neću više piti vina sve do onoga dana kada ću piti novo vino u Božjemu kraljevstvu.” ");
INSERT INTO hrvbib_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Otpjevaju zatim psalme i zapute se prema Maslinskoj gori. ");
INSERT INTO hrvbib_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","“Svi ćete me napustiti”, reče im Isus, “jer u Svetome pismu piše: ‘Udarit ću pastira i ovce će se razbježati.’ ");
INSERT INTO hrvbib_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ali kada uskrsnem, ići ću pred vama u Galileju.” ");
INSERT INTO hrvbib_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Petar mu reče: “Napuste li te i svi ostali, ja te neću napustiti!” ");
INSERT INTO hrvbib_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","“Zaista ti kažem,” reče mu Isus, “još ove noći, prije nego što se pijetao drugi put oglasi, triput ćeš me se odreći.” ");
INSERT INTO hrvbib_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","“Neću!” stane ga uvjeravati Petar. “Makar morao s tobom i umrijeti, neću te se odreći!” Tako su se zaklinjali i svi ostali. ");
INSERT INTO hrvbib_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Dođu tako u maslinik nazvan Getsemani, a Isus reče učenicima: “Sjednite ovdje dok se ja pomolim!” ");
INSERT INTO hrvbib_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Povede sa sobom Petra, Jakova i Ivana. Obuzmu ga tjeskoba i duboka žalost. ");
INSERT INTO hrvbib_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Tada im reče: “Duša mi je nasmrt shrvana tugom. Ostanite ovdje i bdijte.” ");
INSERT INTO hrvbib_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ode malo dalje i padne ničice. Molio se da ga, ako je moguće, mimoiđe strašni trenutak koji ga čeka. ");
INSERT INTO hrvbib_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","“Abba! Oče!” molio je, “tebi je sve moguće. Otkloni ovu čašu od mene! Ipak, neka bude po tvojoj, a ne po mojoj volji.” ");
INSERT INTO hrvbib_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Zatim se vrati trojici učenika i nađe ih spavati te reče Petru: “Šimune! Zar spavaš? Nisi mogao ni ure probdjeti? ");
INSERT INTO hrvbib_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ostanite budni i molite da vas ne bi svladala kušnja! Jer duh je spreman, ali je tijelo slabo.” ");
INSERT INTO hrvbib_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ode još jedanput i pomoli se istim riječima. ");
INSERT INTO hrvbib_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","I opet ih po povratku nađe spavati jer su im oči otežale. Nisu znali što bi mu rekli. ");
INSERT INTO hrvbib_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Kad se treći put vratio, reče im: “Još spavate i odmarate se? Dosta je bilo! Kucnuo je čas! Ja, Sin Čovječji, predan sam grešnicima u ruke. ");
INSERT INTO hrvbib_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ustanite! Hajdemo! Evo, moj je izdajnik već tu!” ");
INSERT INTO hrvbib_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Upravo tada stigne Juda, jedan od Dvanaestorice, a s njime i svjetina naoružana mačevima i toljagama, koju su poslali svećenički poglavari, pismoznanci i drugi starješine. ");
INSERT INTO hrvbib_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Izdajica im je dao znak: “To je onaj kojega poljubim. Uhvatite ga i odvedite pod stražom.” ");
INSERT INTO hrvbib_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","On odmah priđe Isusu i reče: “Učitelju!” i poljubi ga. ");
INSERT INTO hrvbib_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Zatim podignu ruke na Isusa i uhvate ga. ");
INSERT INTO hrvbib_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Jedan od nazočnih nato izvuče mač i njime odsiječe uho sluzi velikoga svećenika. ");
INSERT INTO hrvbib_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Isus reče: “Pošli ste na mene mačevima i toljagama kao na prevratnika! ");
INSERT INTO hrvbib_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","A svaki dan sam u Hramu poučavao, pa me ipak niste uhvatili. Ali sve se ovo događa zato da bi se ispunilo ono što o meni piše u Pismu.” ");
INSERT INTO hrvbib_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Nato ga svi učenici napuste i pobjegnu. ");
INSERT INTO hrvbib_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Slijedio ga je samo neki mladić u noćnoj košulji od gruba platna na golom tijelu. Kad su ga pokušali uhvatiti, ");
INSERT INTO hrvbib_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","on ostavi košulju koju su mu strgnuli i gol pobjegne od njih. ");
INSERT INTO hrvbib_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Isusa odvedu velikomu svećeniku i se ubrzo okupe ostali svećenički poglavari, pismoznanci i starješine. ");
INSERT INTO hrvbib_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Petar ga je izdaleka slijedio i ušao u dvorište palače velikog svećenika. Sjeo je sa slugama uz vatru da se zagrije. ");
INSERT INTO hrvbib_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Unutra su svećenički poglavari i cijelo Veliko vijeće tražili svjedočanstvo protiv Isusa na temelju kojega bi ga mogli smaknuti. Ali nisu ga mogli pronaći. ");
INSERT INTO hrvbib_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Mnogi su lažno svjedočili, ali im se iskazi nisu podudarali. ");
INSERT INTO hrvbib_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Zatim su neki o njemu lagali: ");
INSERT INTO hrvbib_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Čuli smo ga kad je rekao: ‘Srušit ću ovaj Hram izgrađen ljudskim rukama i za tri dana ću izgraditi drugi, bez ljudskih ruku!’” ");
INSERT INTO hrvbib_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ali ni tada im se svjedočanstvo nije podudaralo. ");
INSERT INTO hrvbib_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Veliki svećenik zatim stane pred sud i upita Isusa: “Zar ništa ne odgovaraš na ove optužbe protiv tebe?” ");
INSERT INTO hrvbib_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Isus ne odgovori. Tada ga veliki svećenik upita: “Jesi li ti Mesija, Sin Preslavnoga Boga?” ");
INSERT INTO hrvbib_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Isus odgovori: “Jesam. I gledat ćete Sina Čovječjega kako sjedi zdesna Svemogućemu i kako dolazi na nebeskim oblacima.” ");
INSERT INTO hrvbib_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Nato veliki svećenik razdere svoju odjeću i reče: “Što će nam još svjedoci? ");
INSERT INTO hrvbib_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Čuli ste ga kako huli! Što kažete?” I svi ga osude na smrt. ");
INSERT INTO hrvbib_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Neki počnu pljuvati po njemu. Pokrili su mu oči i onda ga udarali šakama rugajući se: “Pogodi tko te udario, proroče!” Čak su ga i sluge udarali. ");
INSERT INTO hrvbib_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Dok je Petar bio u dvorištu, dođe sluškinja velikog svećenika. ");
INSERT INTO hrvbib_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Kad ugleda Petra da se grije pokraj vatre, pobliže ga promotri i reče: “I ti si bio s Isusom Nazarećaninom!” ");
INSERT INTO hrvbib_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Petar zaniječe: “Niti znam niti razumijem o čemu govoriš!” I iziđe u predvorje. Upravo tada zakukuriče pijetao. ");
INSERT INTO hrvbib_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Sluškinja ga opazi da ondje stoji pa opet počne govoriti ostalima: “Onaj je čovjek jedan od njih!” ");
INSERT INTO hrvbib_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Petar ponovno zaniječe. Poslije i ostali koji su se ondje našli počnu Petru govoriti: “Pa ti si doista jedan od njih, a i Galilejac si!” ");
INSERT INTO hrvbib_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Petar se stane kleti i zaklinjati: “Ja i ne poznajem tog čovjeka o kojemu vi govorite!” ");
INSERT INTO hrvbib_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","I pijetao odmah drugi put zakukuriče. Petar se tada sjeti što mu je Isus rekao: “Prije nego što se pijetao drugi put oglasi, triput ćeš me se odreći.” I brizne u plač. ");
INSERT INTO hrvbib_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Već rano ujutro sastanu se svećenički poglavari, starješine i pismoznanci—cijelo Veliko vijeće—te Isusa svežu i odvedu rimskome upravitelju Pilatu. ");
INSERT INTO hrvbib_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilat ga upita: “Jesi li ti kralj Židova?” “Ti to kažeš”, odgovori mu Isus. ");
INSERT INTO hrvbib_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Svećenički ga poglavari optuže za mnoge zločine. ");
INSERT INTO hrvbib_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilat ga ponovno upita: “Zar nemaš ništa na to reći? Gledaj kako te optužuju!” ");
INSERT INTO hrvbib_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Isus mu više ništa ne odgovori, što je Pilata veoma začudilo. ");
INSERT INTO hrvbib_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Bio je, međutim, običaj da rimski upravitelj svake godine o blagdanu Pashe pusti na slobodu jednoga židovskog zatvorenika kojega narod zatraži. ");
INSERT INTO hrvbib_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","U to je vrijeme jedan od zatvorenika bio Baraba, osuđen s drugim prevratnicima za ubojstvo u pobuni. ");
INSERT INTO hrvbib_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Svjetina se počne okupljati pred Pilatom tražeći da, prema običaju, oslobodi jednog zatvorenika. ");
INSERT INTO hrvbib_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","“Hoćete li da oslobodim židovskoga kralja?” upita Pilat. ");
INSERT INTO hrvbib_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Znao je, naime, da su ga svećenički poglavari predali sudu iz zavisti. ");
INSERT INTO hrvbib_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ali svećenički poglavari podjare svjetinu da zatraži slobodu za Barabu. ");
INSERT INTO hrvbib_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","“A što da onda učinim s ovim kojega nazivate kraljem Židova?” ");
INSERT INTO hrvbib_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","A oni opet poviču: “Raspni ga!” ");
INSERT INTO hrvbib_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","“Zbog čega?” upita Pilat. “Kakvo je zlo učinio?” Ali oni su samo još glasnije vikali: “Raspni ga!” ");
INSERT INTO hrvbib_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","I tako Pilat, želeći ugoditi svjetini, oslobodi Barabu, a Isusa izbičuje i preda da ga raspnu. ");
INSERT INTO hrvbib_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Vojnici ga odvedu u palaču, u takozvani pretorij, i sazovu cijelu četu. ");
INSERT INTO hrvbib_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Obuku ga u grimiz i ispletu krunu od trnja te mu stave na glavu. ");
INSERT INTO hrvbib_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Pozdravljali su ga povicima: “Živio kralj Židova!” ");
INSERT INTO hrvbib_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Udarali su ga štapom po glavi, pljuvali po njemu i padali na koljena da mu se “klanjaju”. ");
INSERT INTO hrvbib_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Kad su mu se izrugali, skinu s njega grimiz, odjenu ga u njegovu odjeću i odvedu da ga raspnu. ");
INSERT INTO hrvbib_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Natjeraju nekog prolaznika, Šimuna iz Cirene, koji se baš tada vraćao iz polja, da ponese Isusov križ (Šimun bijaše Aleksandrov i Rufov otac). ");
INSERT INTO hrvbib_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Dovedu tako Isusa do mjesta zvanoga Golgota (što znači: “Lubanjsko mjesto”). ");
INSERT INTO hrvbib_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ponude mu vino s opojnim gorkim travama, ali on nije htio piti. ");
INSERT INTO hrvbib_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Kad su ga raspeli, bace kocku te tako razdijele među sobom njegovu odjeću. ");
INSERT INTO hrvbib_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Raspeli su ga u devet sati ujutro. ");
INSERT INTO hrvbib_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Iznad njega je stajao natpis o njegovoj krivnji: “kralj Židova”. ");
INSERT INTO hrvbib_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","S njime su raspeli i dvojicu prevratnika, jednoga njemu zdesna, a drugoga slijeva. ");
INSERT INTO hrvbib_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Prolaznici su ga ružili i odmahivali glavom govoreći: “Možeš srušiti Hram i sam ga opet izgraditi u tri dana, je li? ");
INSERT INTO hrvbib_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Spasi onda sebe i siđi s križa!” ");
INSERT INTO hrvbib_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Slično su mu se rugali i svećenički poglavari i pismoznanci: “Spasio je druge, a sebe ne može spasiti! ");
INSERT INTO hrvbib_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Mesija! Kralj Izraelov! Neka sada siđe s križa da vidimo, pa da vjerujemo!” Vrijeđali su ga čak i prevratnici raspeti skupa s njim. ");
INSERT INTO hrvbib_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","O podnevu po svoj zemlji nastane tama i potraje do tri ure. ");
INSERT INTO hrvbib_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","U tri sata Isus glasno poviče: “Eloi, Eloi, lema sabahtani!”, (što znači: “Bože moj, Bože moj, zašto si me ostavio?”) ");
INSERT INTO hrvbib_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","“Zove Iliju!” rekoše neki od nazočnih kad su to čuli. ");
INSERT INTO hrvbib_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","A neki čovjek otrči uzeti spužvu te ju namoči u ocat i natakne na trsku te mu pruži piti. “Da vidimo hoće li doći Ilija i skinuti ga”, reče. ");
INSERT INTO hrvbib_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","A Isus još jedanput glasno krikne i izdahne. ");
INSERT INTO hrvbib_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Nato se zastor u Hramu razdere napola od vrha do dna. ");
INSERT INTO hrvbib_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Kad je rimski stotnik koji je stajao nasuprot Isusu vidio kako je izdahnuo, reče: “Ovaj je čovjek zaista bio Božji Sin!” ");
INSERT INTO hrvbib_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Bile su tu i žene koje su promatrale izdaleka—Marija iz Magdale, Marija, majka Jakova mlađega i Josije, te Saloma, ");
INSERT INTO hrvbib_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","koje su ga pratile i služile mu dok je bio u Galileji. S njim su došle u Jeruzalem. ");
INSERT INTO hrvbib_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Sve se to događalo u petak, na dan Priprave, dan uoči Subote. Kad je pala večer, ");
INSERT INTO hrvbib_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Josip iz Arimateje, ugledan član Velikoga vijeća koji je također iščekivao Božje kraljevstvo, odvaži se te uđe k Pilatu zatražiti Isusovo tijelo. ");
INSERT INTO hrvbib_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilat se veoma začudi da je Isus već umro, pa pozove dežurnoga rimskog stotnika da ga upita je li mrtav. ");
INSERT INTO hrvbib_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Stotnik odgovori da jest, pa Pilat preda Josipu Isusovo mrtvo tijelo. ");
INSERT INTO hrvbib_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Josip kupi platna, skine Isusovo tijelo s križa, umota ga u platno i položi u grob isklesan u stijeni te na ulaz navali kamen. ");
INSERT INTO hrvbib_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Marija iz Magdale i Marija majka Josijina gledale su kamo ga polažu. ");
INSERT INTO hrvbib_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Kad prođe subota, Marija Magdalena, Saloma i Marija majka Jakovljeva odu kupiti mirisne pomasti da pomažu Isusovo tijelo. ");
INSERT INTO hrvbib_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","I u nedjelju vrlo rano ujutro, još za izlaska sunca, pođu na grob. ");
INSERT INTO hrvbib_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Putem su se pitale: “Tko će nam odmaknuti kamen s ulaza u grob?” ");
INSERT INTO hrvbib_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ali kad stignu, ugledaju da je kamen već odmaknut. Bio je to uistinu velik kamen. ");
INSERT INTO hrvbib_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Uđu u grob i zdesna ugledaju mladića u dugoj bijeloj haljini kako sjedi. Žene se zaprepaste. ");
INSERT INTO hrvbib_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","On im reče: “Ne bojte se! Što se toliko čudite? Vi tražite raspetoga Isusa Nazarećanina. Nije ovdje; uskrsnuo je! Evo, tu su mu položili tijelo. ");
INSERT INTO hrvbib_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Idite javiti njegovim učenicima i Petru: Isus ide pred vama u Galileju. Ondje ćete ga vidjeti, kako vam je i rekao.” ");
INSERT INTO hrvbib_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Žene pobjegnu s groba dršćući i zaprepaštene. Od straha nikome nisu ništa kazale. Poslije su o tim uputama ukratko izvijestile Petra i ostale učenike. Isus ih je poslije osobno poslao da od istoka do zapada naviještaju svetu i pouzdanu poruku o spasenju koje daje vječni život. Amen. ");
INSERT INTO hrvbib_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Isus je uskrsnuo rano ujutro u nedjelju. Najprije se ukazao Mariji iz Magdale, iz koje bijaše istjerao sedam zlih duhova. ");
INSERT INTO hrvbib_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ona to ode javiti njegovim sljedbenicima koji su tugovali i plakali. ");
INSERT INTO hrvbib_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ali kad im je rekla da je živ i da ga je vidjela, nisu joj povjerovali. ");
INSERT INTO hrvbib_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Nakon toga Isus se ukazao u drugom obličju dvojici svojih sljedbenika koji su išli putem iz Jeruzalema na selo. ");
INSERT INTO hrvbib_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Oni su to javili ostalima, ali ni njima nisu vjerovali. ");
INSERT INTO hrvbib_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Zatim se ukaže jedanaestorici učenika dok su skupa jeli. Prekori ih zbog nevjere i tvrdoglavog odbijanja da povjeruju onima koji su ga vidjeli poslije uskrsnuća. ");
INSERT INTO hrvbib_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Usto im reče: “Idite po cijelome svijetu i propovijedajte Radosnu vijest svakome, svakom stvorenju. ");
INSERT INTO hrvbib_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Tko povjeruje i krsti se, bit će spašen. Tko ne povjeruje, bit će osuđen. ");
INSERT INTO hrvbib_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","One koji budu vjerovali pratit će čudesni znaci: izgonit će zle duhove u moje ime, govorit će novim jezicima, ");
INSERT INTO hrvbib_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","moći će bez opasnosti uzimati zmije u ruke, a popiju li što otrovno, neće im nauditi; na bolesnike će stavljati ruke i oni će ozdravljati.” ");
INSERT INTO hrvbib_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Kada im je Gospodin Isus to rekao, uznesen je na nebo i sjeo je zdesna Bogu. ");
INSERT INTO hrvbib_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Učenici su otišli posvuda propovijedati, a Gospodin je s njima djelovao i čudesnim znacima potvrđivao Riječ koju su propovijedali.");
INSERT INTO hrvbib_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Mnogi su već pokušali srediti pripovijedanja o događajima koji su se ispunili među nama, ");
INSERT INTO hrvbib_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","prema predaji onih koji su od početka bili očevici i sluge Riječi. ");
INSERT INTO hrvbib_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Odlučio sam stoga i ja, vrli Teofile, tebi napisati sve po redu, pošto sam sve od početka pomno ispitao, ");
INSERT INTO hrvbib_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","da se tako osvjedočiš u pouzdanost učenja koje si primio. ");
INSERT INTO hrvbib_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Za vladavine judejskoga kralja Heroda bio je neki svećenik imenom Zaharija iz Abijina reda hramskih službenika. Žena mu je također bila iz Aronova svećeničkog plemena. Zvala se Elizabeta. ");
INSERT INTO hrvbib_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Oboje su bili pravedni pred Bogom jer su besprijekorno bili poslušni svim zapovijedima i odredbama Gospodnjim. ");
INSERT INTO hrvbib_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Nisu imali djece jer je Elizabeta bila nerotkinja, a oboje su već bili u poodmakloj dobi. ");
INSERT INTO hrvbib_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Jednoga je dana Zaharija služio Bogu u Hramu jer je na dužnosti bio njegov red. ");
INSERT INTO hrvbib_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Prema svećeničkome običaju ždrijebom ga zapadne da uđe u Svetište Gospodnje i da prinese kâd. ");
INSERT INTO hrvbib_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Za vrijeme kađenja sve se mnoštvo naroda vani molilo. ");
INSERT INTO hrvbib_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","A Zahariji se ukaže Gospodnji anđeo. Stajao je s desne strane kadionog žrtvenika. ");
INSERT INTO hrvbib_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Kad ga ugleda, Zaharija se veoma prestraši. ");
INSERT INTO hrvbib_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ali anđeo mu reče: “Ne boj se, Zaharija! Jer uslišana ti je molitva: tvoja će ti žena Elizabeta roditi sina. Nadjenut ćeš mu ime Ivan. ");
INSERT INTO hrvbib_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Bit ćeš radostan i veseo, i mnogi će se veseliti njegovu rođenju. ");
INSERT INTO hrvbib_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Bit će on doista velik u očima Gospodnjim. Neće piti vina ni drugoga opojnog pića. Bit će ispunjen Svetim Duhom još od majčine utrobe. ");
INSERT INTO hrvbib_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Navest će mnoge Izraelce da se obrate Gospodinu, svojemu Bogu. ");
INSERT INTO hrvbib_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ići će pred Gospodinom pun duha i sile kao drevni prorok Ilija. Obratit će srce otaca k sinovima, a nepokorne umove promijeniti tako da prihvate razumnost pravednika. Pripremit će narod za dolazak Gospodnji.” ");
INSERT INTO hrvbib_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zaharija reče anđelu: “Po čemu ću znati da će se to dogoditi? Već sam star, a i žena mi je u poodmakloj dobi.” ");
INSERT INTO hrvbib_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Anđeo mu odgovori: “Ja sam Gabrijel, koji stojim pred samim Bogom. Poslan sam da govorim s tobom i da ti donesem radosnu vijest. ");
INSERT INTO hrvbib_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","A sada ćeš zanijemiti i nećeš moći govoriti do dana kada za to dođe vrijeme i moje se riječi ispune zato što im nisi povjerovao.” ");
INSERT INTO hrvbib_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Narod je za to vrijeme čekao Zahariju i čudio se što se on toliko zadržao u Svetištu. ");
INSERT INTO hrvbib_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Kad je napokon izišao, nije im mogao ništa reći. Oni shvate da je u Svetištu imao viđenje. Pokušao im je govoriti znacima, ali je ostao nijem. ");
INSERT INTO hrvbib_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ostao je u Hramu dok nisu istekli dani njegove službe, a zatim se vratio doma. ");
INSERT INTO hrvbib_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ubrzo zatim njegova žena Elizabeta zanese. Pet mjeseci se krila. Govorila je: ");
INSERT INTO hrvbib_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Gospodin mi je to učinio! Skinuo je s mene sramotu pred ljudima.” ");
INSERT INTO hrvbib_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Nakon šest mjeseci Bog pošalje anđela Gabrijela u galilejski grad Nazaret ");
INSERT INTO hrvbib_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","k djevici Mariji, zaručenoj za čovjeka imenom Josip, iz Davidove loze. ");
INSERT INTO hrvbib_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Gabrijel joj se ukazao i rekao: “Zdravo, milosti puna! Gospodin s tobom!” ");
INSERT INTO hrvbib_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Nato se Marija uznemiri te se počne domišljati što bi taj pozdrav mogao značiti. ");
INSERT INTO hrvbib_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","“Ne boj se, Marijo!” reče joj anđeo. “Bog ti je odlučio dati milost. ");
INSERT INTO hrvbib_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Zanijet ćeš i roditi sina. Nadjenut ćeš mu ime Isus. ");
INSERT INTO hrvbib_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","On će biti vrlo velik i zvat će se Sin Svevišnjega. Gospodin Bog dat će mu prijestolje njegova pretka Davida. ");
INSERT INTO hrvbib_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Vladat će domom Jakovljevim zauvijek; njegovu kraljevstvu neće biti kraja.” ");
INSERT INTO hrvbib_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Marija upita anđela: “Ali kako? Ja još nisam upoznala muškarca.” ");
INSERT INTO hrvbib_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Anđeo joj odgovori: “Sveti Duh će sići na tebe i sila Svevišnjega će te zakriliti. Zato će dijete koje rodiš biti sveto i zvat će se Božji Sin. ");
INSERT INTO hrvbib_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Eto, tvoja je sestrična Elizabeta u starosti začela sina. Zvali su ju nerotkinjom, a trudna je već šest mjeseci. ");
INSERT INTO hrvbib_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Jer Bogu nije ništa nemoguće!” ");
INSERT INTO hrvbib_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Marija mu reče: “Evo, Božja sam sluškinja. Neka mi bude kao što si rekao!” Anđeo tada ode. ");
INSERT INTO hrvbib_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Nekoliko dana poslije Marija požuri u gorski predjel Judeje, ");
INSERT INTO hrvbib_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","k Zahariji. Uđe u kuću i pozdravi Elizabetu. ");
INSERT INTO hrvbib_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Na Marijin pozdrav Elizabeti poskoči dijete u utrobi, a ona se napuni Svetim Duhom ");
INSERT INTO hrvbib_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","te glasno poviče: “Najblagoslovljenija si od svih žena i blagoslovljen je plod tvoje utrobe! ");
INSERT INTO hrvbib_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Kakve li časti da me posjeti majka mojega Gospodina! ");
INSERT INTO hrvbib_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Jer onog časa kad je tvoj pozdrav dopro do mojih ušiju, na tvoj je glas čedo u meni poskočilo od radosti! ");
INSERT INTO hrvbib_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Blago tebi jer si povjerovala da će se ispuniti što ti je rekao Gospodin!” ");
INSERT INTO hrvbib_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Marija tada reče: “Slavi duša moja Gospodina! ");
INSERT INTO hrvbib_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Duh se moj raduje u Bogu, mojemu Spasitelju, ");
INSERT INTO hrvbib_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","jer spomenuo se milostivo svoje neznatne sluškinje! Svi će me naraštaji odsad nazivati blaženom ");
INSERT INTO hrvbib_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","jer mi je Svesilni, čije je ime sveto, učinio velika djela. ");
INSERT INTO hrvbib_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Njegova je milost od naraštaja do naraštaja nad onima koji ga štuju. ");
INSERT INTO hrvbib_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Moćnom rukom čini silna djela, rastjeruje ohole i umišljene. ");
INSERT INTO hrvbib_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Zbacio je s prijestolja vladare, a uzvisio neznatne. ");
INSERT INTO hrvbib_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Gladne je nasitio dobrima, a bogataše otpustio praznih ruku. ");
INSERT INTO hrvbib_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Priskočio je u pomoć svojemu sluzi Izraelu sjećajući se milosti ");
INSERT INTO hrvbib_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","koju je obećao našim precima: da će Abrahamu i njegovu potomku uvijek biti milostiv.” ");
INSERT INTO hrvbib_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Marija je s Elizabetom ostala otprilike tri mjeseca, a zatim se vratila doma. ");
INSERT INTO hrvbib_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elizabeti je došlo vrijeme da rodi te ona rodi sina. ");
INSERT INTO hrvbib_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Kad se među njezinim susjedima i rodbinom pročulo da joj je Bog iskazao veliku milost, veselili su se skupa s njom. ");
INSERT INTO hrvbib_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Kad je dijete navršilo osam dana, okupe se na obredu obrezanja. Htjeli su dječaka nazvati Zaharijom po ocu, ");
INSERT INTO hrvbib_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","ali se Elizabeta usprotivi: “Nipošto! Mora se zvati Ivan!” ");
INSERT INTO hrvbib_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","“Pa u cijeloj se tvojoj obitelji nitko tako ne zove!” ");
INSERT INTO hrvbib_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Zato znacima upitaju dječakova oca kako ga želi nazvati. ");
INSERT INTO hrvbib_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","On zatraži da mu daju pločicu i napiše: “Zove se Ivan.” Svi se začude, ");
INSERT INTO hrvbib_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","a Zahariji se odriješi jezik te on smjesta progovori i počne slaviti Boga. ");
INSERT INTO hrvbib_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Strah Božji obuzme sve žitelje toga kraja. Po cijelome judejskom gorju prepričavali su se ti događaji. ");
INSERT INTO hrvbib_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","I tko god bi o njima čuo, razmišljao je o njima i pitao se: “Što će biti od toga djeteta? Zaista je nad njim ruka Gospodnja.” ");
INSERT INTO hrvbib_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Tada njegova oca Zahariju ispuni Sveti Duh te on izrekne proročanstvo: ");
INSERT INTO hrvbib_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Slava Gospodinu Bogu Izraelovu jer je pohodio svoj narod i otkupio ga! ");
INSERT INTO hrvbib_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Podiže nam silnog Spasitelja iz potomstva svojega sluge Davida, ");
INSERT INTO hrvbib_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","kao što je od davnine obećao kroz riječi svojih svetih proroka: ");
INSERT INTO hrvbib_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","spasiti nas od neprijatelja i od ruku svih naših mrzitelja. ");
INSERT INTO hrvbib_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Bio je milosrdan našim precima i spomenuo se svojega svetog Saveza, ");
INSERT INTO hrvbib_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","zavjeta koji je dao našemu ocu Abrahamu. ");
INSERT INTO hrvbib_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Izbavio nas je od neprijatelja da mu možemo služiti bez straha ");
INSERT INTO hrvbib_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","u svetosti i pravednosti u sve svoje dane. ");
INSERT INTO hrvbib_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","A ti ćeš se, sine moj, zvati prorokom Svevišnjega jer ćeš ići ispred Gospodina da mu pripraviš put. ");
INSERT INTO hrvbib_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Poučit ćeš njegov narod kako da spozna spasenje kroz oproštenje svojih grijeha, ");
INSERT INTO hrvbib_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","po milosrdnom srcu našega Boga po kojemu će nas pohoditi zora s visine ");
INSERT INTO hrvbib_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","da donese svjetlo onima koji prebivaju u tmini i u smrtnoj sjeni te da naše korake povede putem mira.” ");
INSERT INTO hrvbib_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Dječak je rastao i duhovno jačao. Kad je odrastao, živio je u pustinji sve dok nije započeo javnu službu pred Izraelom. ");
INSERT INTO hrvbib_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","U to vrijeme rimski car August zapovjedi da se svi žitelji Carstva popišu. ");
INSERT INTO hrvbib_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Bio je to prvi popis stanovništva proveden za Kvirinijeva upravljanja Sirijom. ");
INSERT INTO hrvbib_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Svatko je putovao u svoj grad da se ondje upiše. ");
INSERT INTO hrvbib_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Tako je i Josip iz gradića Nazareta u Galileji, jer je bio iz loze kralja Davida, pošao u Davidov grad zvani Betlehem ");
INSERT INTO hrvbib_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","da se upiše skupa sa svojom zaručnicom Marijom koja je već bila trudna. ");
INSERT INTO hrvbib_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Dok su bili ondje, dođe joj vrijeme da rodi ");
INSERT INTO hrvbib_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","te ona rodi sina, svojeg prvorođenca. Povila ga je i položila u jasle jer u seoskome svratištu nije za njih bilo mjesta. ");
INSERT INTO hrvbib_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","U tome su kraju boravili pastiri. Noću su pod vedrim nebom čuvali stada ovaca. ");
INSERT INTO hrvbib_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Odjednom se pokraj njih pojavi anđeo Gospodnji i obasja ih Gospodnja slava. Oni se silno prestraše, ");
INSERT INTO hrvbib_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","ali anđeo im reče: “Ne bojte se! Donosim vam, evo, radosnu vijest, na veliko veselje svemu narodu! ");
INSERT INTO hrvbib_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Spasitelj—Krist, Gospodin rodio vam se danas u Davidovu gradu! ");
INSERT INTO hrvbib_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Evo znaka po kojemu ćete ga prepoznati: naći ćete povijeno novorođenče da leži u jaslama.” ");
INSERT INTO hrvbib_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Anđelu se odjednom pridruži silna nebeska vojska slaveći Boga: ");
INSERT INTO hrvbib_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Slava Bogu na visini, a na zemlji mir ljudima, njegovim miljenicima.” ");
INSERT INTO hrvbib_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Čim su se anđeli vratili na nebo, pastiri stanu poticati jedni druge: “Hajdemo u Betlehem! Hajdemo vidjeti taj događaj koji nam je Gospodin objavio!” ");
INSERT INTO hrvbib_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Pohitaju do sela i ondje pronađu Mariju i Josipa s novorođenčetom koje je ležalo u jaslama. ");
INSERT INTO hrvbib_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Kad su ga vidjeli, svima su ispričali što im je anđeo rekao o djetetu. ");
INSERT INTO hrvbib_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","A svi koji su pastire slušali divili su se. ");
INSERT INTO hrvbib_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Marija je pomnjivo pamtila sve što su govorili i razmišljala je o tome. ");
INSERT INTO hrvbib_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Pastiri se zatim vrate slaveći i hvaleći Boga za sve što su čuli i vidjeli te što se dogodilo onako kako im je anđeo rekao. ");
INSERT INTO hrvbib_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Osam dana poslije, kad je dječaka trebalo obrezati, nadjenuli su mu ime Isus koje mu je anđeo dao još prije začeća. ");
INSERT INTO hrvbib_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Kad je došlo vrijeme za obred očišćenja koji je prema Mojsijevu zakonu trebalo obaviti nakon djetetova rođenja, donijeli su ga u Jeruzalem da ga prikažu Gospodinu, ");
INSERT INTO hrvbib_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","kako piše u Zakonu Gospodnjemu: “Svako muško prvorođenče neka se posveti Gospodinu”, ");
INSERT INTO hrvbib_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","te su prinijeli i žrtvu prema zakonskoj odredbi: “dvije grlice ili dva golubića”. ");
INSERT INTO hrvbib_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Živio je tada u Jeruzalemu neki čovjek imenom Šimun. Bio je to vrlo pravedan i pobožan čovjek; Sveti je Duh bio na njemu te je iščekivao da dođe Mesija i izbavi Izrael. ");
INSERT INTO hrvbib_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Sveti mu je Duh otkrio da neće umrijeti dok ne vidi Mesiju Gospodnjega. ");
INSERT INTO hrvbib_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Potaknut Svetim Duhom, on ode u Hram. Kad su roditelji unijeli Isusa da obave obred propisan Zakonom, ");
INSERT INTO hrvbib_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Šimun uzme dijete u naručje te stane slaviti Boga: ");
INSERT INTO hrvbib_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Sada možeš pustiti svojega slugu, Gospodine, da ode u miru, kao što si mi rekao. ");
INSERT INTO hrvbib_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Jer oči su mi vidjele tvoje spasenje ");
INSERT INTO hrvbib_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","koje si pripravio za sve narode, ");
INSERT INTO hrvbib_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","svjetlo da prosvijetli pogane, slavu tvojega izraelskog naroda.” ");
INSERT INTO hrvbib_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Isusovi roditelji divili su se riječima izgovorenima o njemu. ");
INSERT INTO hrvbib_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Šimun ih zatim blagoslovi i reče Mariji: “Određen je za to da mnogima u Izraelu bude na propast i mnogima na uskrsnuće, za osporavani znak. ");
INSERT INTO hrvbib_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","A tebi će mač probosti dušu da se razotkriju namisli mnogih srca!” ");
INSERT INTO hrvbib_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Bila je ondje i neka proročica Ana, Penuelova kći iz Ašerova plemena, vrlo stara žena. Poslije djevojaštva živjela je u braku sedam godina, ");
INSERT INTO hrvbib_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","a zatim sama, kao udovica do osamdeset četvrte godine. Nije napuštala Hram, već je postom i molitvom danonoćno služila Bogu. ");
INSERT INTO hrvbib_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ona baš tada naiđe te počne zahvaljivati Bogu i govoriti o Isusu svima koji su iščekivali obećanog Mesiju i otkupljenje Jeruzalema. ");
INSERT INTO hrvbib_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Kad Isusovi roditelji ispune sve odredbe Gospodnjeg zakona, vrate se u Nazaret, u Galileju. ");
INSERT INTO hrvbib_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Dijete je raslo i jačalo. Punilo se mudrošću i Božja je milost bila s njim. ");
INSERT INTO hrvbib_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Isusovi su roditelji svake godine o blagdanu Pashe išli u Jeruzalem. ");
INSERT INTO hrvbib_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Kad mu je bilo dvanaest godina, pošli su kao obično na svetkovinu. ");
INSERT INTO hrvbib_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Nakon svetkovine dječak Isus ostao je u Jeruzalemu, a njegovi roditelji to nisu znali. ");
INSERT INTO hrvbib_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Pretpostavljali su da je među ostalim suputnicima. Odmaknuli su tako dan hoda, a onda ga počeli tražiti među rodbinom i znancima, ");
INSERT INTO hrvbib_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","ali ga nisu našli. Vrate se stoga u Jeruzalem ondje ga potražiti. ");
INSERT INTO hrvbib_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Nakon tri dana pronađu ga u Hramu među vjerskim učiteljima kako ih sluša i postavlja im pitanja. ");
INSERT INTO hrvbib_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Svi koji su ga slušali divili su se njegovoj oštroumnosti i odgovorima. ");
INSERT INTO hrvbib_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Roditelji nisu znali što da misle. “Sine!” reče mu majka. “Zašto si nam to učinio? Tvoj otac i ja silno smo se zabrinuli i posvuda smo te tražili!” ");
INSERT INTO hrvbib_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","“Zašto ste me tražili?” odgovori on. “Zar niste znali da ja moram biti u onomu što je mojega Oca?” ");
INSERT INTO hrvbib_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ali oni nisu razumjeli što im je htio kazati. ");
INSERT INTO hrvbib_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Vratio se zatim s njima u Nazaret i bio im je poslušan, a njegova je majka sve to brižno čuvala u svojemu srcu. ");
INSERT INTO hrvbib_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","A Isus je napredovao u mudrosti, rastu i milosti kod Boga i ljudi. ");
INSERT INTO hrvbib_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Bila je petnaesta godina vladavine cara Tiberija. Poncije Pilat bio je upravitelj Judeje, Herod je vladao Galilejom, a njegov brat Filip Iturejom i Trahonitidom. Lizanije je vladao Abilenom. ");
INSERT INTO hrvbib_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Veliki svećenici bili su Ana i Kajfa. Bog tada progovori Ivanu, sinu Zaharijinu, u pustinji. ");
INSERT INTO hrvbib_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","On zatim obiđe svu jordansku okolicu propovijedajući ljudima da se ljudi trebaju krstiti da pokažu kako su se odvratili od svojih grijeha i obratili se Bogu da im oprosti. ");
INSERT INTO hrvbib_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Kao što je napisao prorok Izaija, Ivan je bio “glas koji viče u pustinji: ‘Pripremite put za Gospodnji dolazak! Poravnajte za njega staze!’ ");
INSERT INTO hrvbib_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Neka se svaka udolina popuni, a svaka gora i brijeg neka se slegne! Neka se iskrivljeni putovi isprave, a neravni izglade! ");
INSERT INTO hrvbib_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Tada će svi ljudi vidjeti Božje spasenje!” ");
INSERT INTO hrvbib_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ivan je govorio mnoštvu koje se dolazilo krstiti: “Zmijska legla! Tko li vas je samo upozorio da pobjegnete Božjemu gnjevu koji stiže? ");
INSERT INTO hrvbib_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Dokažite svojim životom i djelima da ste se odvratili od grijeha i obratili Bogu! Ne zavaravajte se da vam je dovoljno reći: ‘Mi smo Abrahamovi potomci!’ jer vam kažem da Bog može i od ovoga kamenja Abrahamu podignuti djecu! ");
INSERT INTO hrvbib_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Sjekira Božjeg suda već je uzdignuta da u korijenu sasiječe stabla. Svako stablo koje ne daje dobrog roda bit će posječeno i bačeno u vatru.” ");
INSERT INTO hrvbib_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Mnoštvo ga nato počne pitati: “Što trebamo činiti?” ");
INSERT INTO hrvbib_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","“Tko ima dvije haljine, neka podijeli s onim tko nema nijednu. A tko ima hrane, neka je podijeli s onima koji nemaju.” ");
INSERT INTO hrvbib_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Došli su se krstiti čak i ubirači poreza i upitali: “Učitelju, što mi moramo činiti?” ");
INSERT INTO hrvbib_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ivan im odgovori: “Ne utjerujte više nego što vam određuje vlast.” ");
INSERT INTO hrvbib_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","“A što mi trebamo činiti?” pitali su ga vojnici. “Ne postupajte ni s kim nasilno,” odgovori on, “ne optužujte lažno nedužne i budite zadovoljni svojom plaćom.” ");
INSERT INTO hrvbib_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Narod je iščekivao Mesiju i svi su se u srcu pitali nije li možda Ivan taj. ");
INSERT INTO hrvbib_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Zato im Ivan svima reče: “Ja vas krstim vodom, no dolazi netko veći od mene, toliko velik da mu ja nisam dostojan biti ni robom. On će vas krstiti Svetim Duhom i ognjem. ");
INSERT INTO hrvbib_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Očistit će svoje gumno i odvojiti pljevu od pšenice; pšenicu će spremiti u svoju žitnicu, a pljevu sažeći neugasivim ognjem.” ");
INSERT INTO hrvbib_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Mnoge je takve opomene Ivan izrekao navješćujući ljudima Radosnu vijest. ");
INSERT INTO hrvbib_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","A Heroda tetrarha Ivan je prekorio zbog toga što je živio sa ženom svojega brata, Herodijadom, te zbog brojnih drugih zlodjela ");
INSERT INTO hrvbib_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","kojima Herod zatim pridoda još i ovo: baci Ivana u tamnicu. ");
INSERT INTO hrvbib_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Dok je Ivan krstio sav narod, krstio se i Isus. Kad se on molio, nebesa se otvore, ");
INSERT INTO hrvbib_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","a Sveti se Duh u tjelesnome obličju goluba spusti na njega. S neba se začuje glas: “Ti si moj ljubljeni Sin! Ti si moja radost!” ");
INSERT INTO hrvbib_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Kad je započeo s javnom službom, Isusu je bilo otprilike trideset godina. Držalo se da je Isus Josipov sin. Josip je bio Elijev sin, ");
INSERT INTO hrvbib_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli je bio Matatov sin, Matat je bio Levijev sin, Levi je bio Malkijev sin, Malki je bio Janajev sin, Janaj je bio Josipov sin, ");
INSERT INTO hrvbib_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josip je bio Matatijin sin, Matatija je bio Amosov sin, Amos je bio Naumov sin, Naum je bio Heslijev sin, Hesli je bio Nagajev sin, ");
INSERT INTO hrvbib_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagaj je bio Mahatov sin, Mahat je bio Matatijin sin, Matatija je bio Šimijev sin, Šimij je bio Josehov sin, Joseh je bio Jodin sin, ");
INSERT INTO hrvbib_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda je bio Johananov sin, Johanan je bio Resin sin, Resa je bio Zerubabelov sin, Zerubabel je bio Šealtielov sin, Šealtiel je bio Nerijev sin, ");
INSERT INTO hrvbib_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri je bio Malkijev sin, Malki je bio Adijev sin, Adi je bio Kosamov sin, Kosam je bio Elmadamov sin, Elmadam je bio Erov sin ");
INSERT INTO hrvbib_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er je bio Jošuin sin, Jošua je bio Eliezerov sin, Eliezer je bio Jorimov sin, Jorim je bio Matatov sin, Matat je bio Levijev sin, ");
INSERT INTO hrvbib_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Levi je bio Šimunov sin, Šimun je bio Judin sin, Juda je bio Josipov sin, Josip je bio Jonamov sin, Jonam je bio Elijakimov sin, ");
INSERT INTO hrvbib_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Elijakim je bio Melejin sin, Meleja je bio Menin sin, Mena je bio Matatin sin, Matata je bio Natanov sin, Natan je bio Davidov sin, ");
INSERT INTO hrvbib_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","David je bio Jišajev sin, Jišaj je bio Obedov sin, Obed je bio Boazov sin, Boaz je bio Salin sin, Sala je bio Nahšonov sin, ");
INSERT INTO hrvbib_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nahšon je bio Aminadabov sin, Aminadab je bio Adminov sin, Admin je bio Arnijev sin, Arni je bio Hesronov sin, Hesron je bio Peresov sin, Peres je bio Judin sin, ");
INSERT INTO hrvbib_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda je bio Jakovljev sin, Jakov je bio Izakov sin, Izak je bio Abrahamov sin, Abraham je bio Terahov sin, Terah je bio Nahorov sin, ");
INSERT INTO hrvbib_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor je bio Serugov sin, Serug je bio Reuov sin, Reu je bio Pelegov sin, Peleg je bio Eberov sin, Eber je bio Šelahov sin, ");
INSERT INTO hrvbib_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Šelah je bio Kenanov sin, Kenan je bio Arpakšadov sin, Arpakšad je bio Šemov sin, Šem je bio Noin sin, Noa je bio Lamekov sin, ");
INSERT INTO hrvbib_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek je bio Metušalahov sin, Metušalah je bio Henokov sin, Henok je bio Jeredov sin, Jered je bio Mahalalelov sin, Mahalalel je bio Kenanov sin, ");
INSERT INTO hrvbib_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan je bio Enošev sin, Enoš je bio Šetov sin, Šet je bio Adamov sin, Adam je bio Božji sin. ");
INSERT INTO hrvbib_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Isus je pun Svetoga Duha otišao s Jordana. Duh ga odvede u pustinju, ");
INSERT INTO hrvbib_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","gdje ga je četrdeset dana kušao đavao. Sve te dane nije ništa jeo pa je po njihovu isteku bio vrlo gladan. ");
INSERT INTO hrvbib_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Đavao mu reče: “Ako si Božji Sin, reci ovom kamenju da postane kruhom.” ");
INSERT INTO hrvbib_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ali Isus mu odgovori: “U Svetome pismu piše: ‘Ne živi čovjek samo o kruhu.’” ");
INSERT INTO hrvbib_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Đavao ga zatim povede visoko te mu odjednom pokaže sva kraljevstva svijeta. ");
INSERT INTO hrvbib_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Reče mu: “Dat ću ti vlast nad njima i njihovu slavu jer su moja i mogu ih dati kome hoću. ");
INSERT INTO hrvbib_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Pokloni se preda mnom i sve je tvoje!” ");
INSERT INTO hrvbib_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Isus mu odgovori: “U Svetome pismu piše: ‘Klanjaj se samo Bogu i njemu jedinome služi!’” ");
INSERT INTO hrvbib_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Tada ga đavao odvede u Jeruzalem, na vrh Hrama i reče: “Ako si Božji Sin, skoči odavde! ");
INSERT INTO hrvbib_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Jer Sveto pismo kaže: ‘On zapovijeda svojim anđelima da te čuvaju’ ");
INSERT INTO hrvbib_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","i ‘oni će te svojim rukama zadržati da ni nogom o kamen ne udariš.’” ");
INSERT INTO hrvbib_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Isus mu odgovori: “Sveto pismo također kaže: ‘Ne iskušavaj Gospodina Boga svojega!’” ");
INSERT INTO hrvbib_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Pošto je đavao iscrpio sve kušnje, udalji se od njega do druge prigode. ");
INSERT INTO hrvbib_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Isus se zatim vrati u Galileju pun sile Svetoga Duha. Glas o njemu brzo se pronio cijelim krajem. ");
INSERT INTO hrvbib_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Poučavao je u tamošnjim sinagogama i svi su ga slavili. ");
INSERT INTO hrvbib_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Dođe tako i u Nazaret, u kojemu je odrastao. U subotu kao i obično ode u sinagogu i ustane da čita iz Svetoga pisma. ");
INSERT INTO hrvbib_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Pruže mu svitak proroka Izaije, a on ga odmota te pronađe mjesto gdje piše: ");
INSERT INTO hrvbib_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Duh Gospodnji je na meni jer me je pomazao i poslao da donesem Radosnu vijest siromasima, da navijestim: sužnji će se osloboditi, slijepci će vidjeti, potlačeni će biti slobodni; ");
INSERT INTO hrvbib_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","da navijestim godinu milosti Gospodnje.” ");
INSERT INTO hrvbib_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Smota zatim svitak, vrati ga poslužitelju i sjedne. Oči svih u sinagogi bile su uprte u njega. ");
INSERT INTO hrvbib_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","On im reče: “Ovaj se navod iz Svetog pisma, koji vam još odzvanja u ušima, danas obistinio!” ");
INSERT INTO hrvbib_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Svi su mu povlađivali. Divili su se milini riječi koje su tekle s njegovih usana. “Nije li on Josipov sin?” pitali su. ");
INSERT INTO hrvbib_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","A on im reče: “Zacijelo ćete mi navesti onu poslovicu: ‘Liječniče, izliječi samoga sebe!’ Učini ovdje, u svojem zavičaju, ono što smo čuli da si učinio u Kafarnaumu. ");
INSERT INTO hrvbib_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ali uistinu, nijedan prorok nije prihvaćen u svojem zavičaju. ");
INSERT INTO hrvbib_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Zaista vam kažem, u Ilijino doba, kad je nebo ostalo zatvoreno tri i pol godine i kad je po svoj zemlji zavladala silna glad, u Izraelu je bilo mnogo udovica. ");
INSERT INTO hrvbib_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ali Ilija nije poslan nijednoj od njih, već nekoj udovici u Sarfati, u sidonskome kraju. ");
INSERT INTO hrvbib_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","U Elizejevo je doba u Izraelu bilo mnogo gubavaca, ali od gube nije ozdravio nijedan od njih, već Sirijac Naaman.” ");
INSERT INTO hrvbib_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Na te se riječi svi u sinagogi razgnjeve, ");
INSERT INTO hrvbib_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","ustanu i istjeraju ga iz grada te ga odvedu na liticu brijega na kojemu je bio izgrađen grad s nakanom da ga bace niz nju. ");
INSERT INTO hrvbib_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ali on samo prođe kroz mnoštvo i ode svojim putem. ");
INSERT INTO hrvbib_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ode zatim u galilejski grad Kafarnaum te je ondje subotom poučavao. ");
INSERT INTO hrvbib_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ljudi su bili zadivljeni njegovim učenjem jer je govorio kao onaj koji ima vlast. ");
INSERT INTO hrvbib_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","U sinagogi se zatekao čovjek opsjednut nečistim duhom koji počne vikati na sav glas: ");
INSERT INTO hrvbib_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Zašto nas uznemiruješ, Isuse Nazarećanine? Zar si nas došao uništiti? Znam tko si: ti si Svetac Božji!” ");
INSERT INTO hrvbib_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Isus mu zaprijeti: “Umukni i iziđi iz njega!” Nato zloduh obori čovjeka ondje među ljudima na zemlju, ali zatim iziđe iz njega i ne naudi mu više. ");
INSERT INTO hrvbib_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Svi nazočni silno se zaprepaste. “Kakve li riječi! Takvom vlašću i silom zapovijeda nečistim duhovima da mu se pokoravaju i oni izlaze!” ");
INSERT INTO hrvbib_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","I glas o njemu pronese se po svoj okolici. ");
INSERT INTO hrvbib_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Iz sinagoge Isus ode u Šimunovu kuću. A Šimunova je punica bila u velikoj vrućici te ga oni odmah zamole da joj pomogne. ");
INSERT INTO hrvbib_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Isus se nagne nad nju te zaprijeti vrućici, a ona nestane. Žena odmah ustane i počne ih posluživati. ");
INSERT INTO hrvbib_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Kad je sunce uvečer zašlo, svi koji su imali bolesnike s najrazličitijim bolestima doveli su ih k njemu. On je na sve polagao ruke i ozdravljao ih. ");
INSERT INTO hrvbib_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Iz mnogih su opsjednutih izlazili zlodusi i vikali: “Ti si Božji Sin!” Ali on im je zabranjivao da govore zato što su znali da je on Mesija. ");
INSERT INTO hrvbib_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","U zoru sljedećeg jutra Isus ode na pusto mjesto, a mnoštvo ga je tražilo. Kad su ga pronašli, nisu ga htjeli pustiti da ode od njih, ");
INSERT INTO hrvbib_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","ali on im reče: “Moram ići i drugim gradovima navijestiti Radosnu vijest o Božjem kraljevstvu jer sam poslan da to činim.” ");
INSERT INTO hrvbib_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Propovijedao je tako po judejskim sinagogama. ");
INSERT INTO hrvbib_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Dok je jednom stajao na obali Genezaretskoga jezera a mnoštvo je nagrnulo k njemu da sluša Božju riječ, ");
INSERT INTO hrvbib_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Isus ugleda dvije lađice koje su ribari ostavili uz obalu jer su ispirali mreže. ");
INSERT INTO hrvbib_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Uđe u jednu od njih te zamoli Šimuna, kojemu je pripadala, da ju malo odgurne od obale. Zatim sjedne i počne iz lađice poučavati narod. ");
INSERT INTO hrvbib_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Kad je završio s govorom, reče Šimunu: “Izvezi natrag na pučinu, pa bacite mreže za lov!” ");
INSERT INTO hrvbib_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","“Gospodine,” reče mu Šimun, “cijelu smo noć teško radili i ništa nismo uhvatili, ali kad ti tako kažeš, bacit ću mreže.” ");
INSERT INTO hrvbib_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Kad su ih bacili, u njih se uhvati toliko riba da su se razdirale. ");
INSERT INTO hrvbib_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ribari stanu mahati svojim drugovima u drugoj lađici da im priskoče u pomoć. Oni dođu, pa napune obje lađice ribom tako da su gotovo tonule. ");
INSERT INTO hrvbib_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Kad je to vidio Šimun Petar, padne na koljena pred Isusom i reče mu: “Gospodine, udalji se od mene jer sam odviše grešan da bih ti bio blizu!” ");
INSERT INTO hrvbib_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Silna lovina riba zaprepastila je njega i sve koji su bili s njime, ");
INSERT INTO hrvbib_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","pa tako i Šimunove drugove Jakova i Ivana, Zebedejeve sinove. Isus odgovori Šimunu: “Ne boj se! Od sada ćeš loviti ljude!” ");
INSERT INTO hrvbib_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Oni izvuku lađice na kopno, a zatim sve ostave i pođu za njim. ");
INSERT INTO hrvbib_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","U nekome mjestu gdje je Isus boravio pojavi se iznenada pred njim čovjek pun gube. Čim spazi Isusa, baci se pred njega ničice, licem prema zemlji, i zamoli ga: “Gospodine, ako hoćeš, možeš me iscijeliti!” ");
INSERT INTO hrvbib_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Isus ispruži ruku i dotakne ga. “Hoću!” reče. “Budi čist!” I guba odmah nestane. ");
INSERT INTO hrvbib_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Isus mu zapovjedi: “Nikome o tomu ne govori, već idi ravno svećeniku te sa sobom ponesi žrtveni dar prema Mojsijevu zakonu kao javno svjedočanstvo svojeg ozdravljenja.” ");
INSERT INTO hrvbib_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ali glas o Isusu pronosio se sve dalje, pa je golemo mnoštvo naroda nahrupilo da ga sluša i da ozdravi od bolesti. ");
INSERT INTO hrvbib_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","A on je odlazio moliti se na samotna mjesta. ");
INSERT INTO hrvbib_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Jednoga dana dok je Isus poučavao, ondje su sjedili farizeji i pismoznanci koji su došli iz svih galilejskih i judejskih sela i iz Jeruzalema, a njega je sila Gospodnja poticala da iscjeljuje. ");
INSERT INTO hrvbib_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Neki ljudi donijeli su uzetog čovjeka na nosilima. Htjeli su ga unijeti unutra i položiti pred Isusa, ");
INSERT INTO hrvbib_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","ali nisu se kroz mnoštvo uspjeli probiti do njega. Zato se popnu na krov, načine otvor među crepovima te ga s nosilima spuste među mnoštvo pred Isusa. ");
INSERT INTO hrvbib_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Kad Isus vidje njihovu vjeru, reče bolesniku: “Čovječe, oprošteni su ti grijesi!” ");
INSERT INTO hrvbib_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Pismoznanci i farizeji nato počnu umovati: “Tko je ovaj da tako huli? Tko može opraštati grijehe osim jedinoga Boga!” ");
INSERT INTO hrvbib_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Isus prozre njihovo umovanje, pa ih upita: “Zašto to smatrate hulom? ");
INSERT INTO hrvbib_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Što je lakše reći: ‘Grijesi su ti oprošteni’ ili ‘Ustani i idi’? ");
INSERT INTO hrvbib_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Dokazat ću vam da ja, Sin Čovječji, imam vlast na zemlji opraštati grijehe.” Okrene se zatim prema uzetome i reče: “Zapovijedam ti: ustani, uzmi nosila i idi kući!” ");
INSERT INTO hrvbib_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Čovjek smjesta ustane te naočigled svih uzme nosila i ode slaveći Boga. ");
INSERT INTO hrvbib_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Nato sve obuzme zanos, pa su slavili Boga i silno prestrašeni govorili: “Ovo što smo danas vidjeli je čudesno!” ");
INSERT INTO hrvbib_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Izlazeći nakon toga, Isus ugleda ubirača poreza imenom Levi kako sjedi u svojemu uredu te ga pozove: “Pođi za mnom!” ");
INSERT INTO hrvbib_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Levi nato ustane, ostavi sve te pođe za njim. ");
INSERT INTO hrvbib_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Poslije Levi u svojemu domu priredi veliku gozbu u čast Isusu. S njima je za stolom sjedilo mnogo ubirača poreza i drugih uzvanika. ");
INSERT INTO hrvbib_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","A farizeji i pismoznanci negodovali su i govorili učenicima: “Zašto jedete i pijete s ubiračima poreza i drugim grešnicima?” ");
INSERT INTO hrvbib_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Isus im odgovori: “Ne treba liječnik zdravima, nego bolesnima. ");
INSERT INTO hrvbib_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nisam došao zvati pravednike na obraćenje, već grešnike.” ");
INSERT INTO hrvbib_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Oni mu nato prigovore: “Ivanovi i farizejski učenici često poste i mole se, a tvoji jedu i piju!” ");
INSERT INTO hrvbib_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Isus im odgovori: “Zar možete siliti svatove da poste dok je mladoženja s njima? ");
INSERT INTO hrvbib_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ali doći će dani kada će im ugrabiti mladoženju. Tada će postiti.” ");
INSERT INTO hrvbib_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Zatim im Isus to objasni prispodobom: “Nitko neće rupu na starome odijelu zakrpati tkaninom koju je otparao s novoga jer bi tako poderao i novo odijelo, a starome odijelu krpa s novoga ionako ne bi pristajala. ");
INSERT INTO hrvbib_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","I nitko ne ulijeva novo vino u stare mjehove jer bi se od njega raspuknuli. Tako bi se i vino prolilo i mjehovi uništili. ");
INSERT INTO hrvbib_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Zato novo vino mora se ulijevati u nove mješine. ");
INSERT INTO hrvbib_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","I nitko pijući staro vino ne poželi piti novo. ‘Staro je bolje’, kažu.” ");
INSERT INTO hrvbib_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Neke su subote, dok je Isus prolazio poljem usjeva, učenici počeli trgati klasje, trti ga rukama i jesti. ");
INSERT INTO hrvbib_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","A neki farizeji rekoše: “Zašto činite ono što je subotom zabranjeno? Zakonom je zabranjeno skupljati usjev subotom!” ");
INSERT INTO hrvbib_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Isus im odgovori: “Niste li u Pismu čitali o tomu što je učinio kralj David kad su on i njegovi pratitelji ogladnjeli? ");
INSERT INTO hrvbib_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ušao je u Dom Božji i jeo prineseni kruh koji je dopušteno jesti samo svećenicima te ga je dao jesti i svojim pratiocima. ");
INSERT INTO hrvbib_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ja, Sin Čovječji, gospodar sam subote.” ");
INSERT INTO hrvbib_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Druge subote Isus uđe u sinagogu i počne poučavati. Ondje je bio neki čovjek usahnule desne ruke. ");
INSERT INTO hrvbib_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Pismoznanci i farizeji budno su pazili hoće li Isus u subotu iscijeliti, da ga mogu optužiti. ");
INSERT INTO hrvbib_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ali Isus je znao za njihovu nakanu pa reče čovjeku usahnule ruke: “Ustani i dođi ovamo na sredinu!” Čovjek ustane i stane ispred svih. ");
INSERT INTO hrvbib_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Tada Isus reče farizejima i pismoznancima: “Pitam vas: Je li subotom dopušteno činiti dobro ili zlo, život spasiti ili uništiti?” ");
INSERT INTO hrvbib_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Pogleda ih sve uokolo pa reče čovjeku: “Ispruži ruku!” On ju ispruži, a ruka mu postane zdrava. ");
INSERT INTO hrvbib_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Isusovi se neprijatelji nato silno razgnjeve te se počnu dogovarati što da poduzmu protiv njega. ");
INSERT INTO hrvbib_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Nedugo zatim Isus ode u goru moliti se. Cijelu se noć molio Bogu. ");
INSERT INTO hrvbib_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Kad se razdanilo, dozove učenike te od njih izabere dvanaestoricu i imenuje ih apostolima: ");
INSERT INTO hrvbib_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Šimuna (kojega je prozvao Petrom), Andriju (Šimunova brata), Jakova, Ivana, Filipa, Bartolomeja, ");
INSERT INTO hrvbib_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateja, Tomu, Jakova (Alfejeva sina), Šimuna (zvanoga Revnitelj), ");
INSERT INTO hrvbib_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judu (Jakovljeva sina) i Judu Iškariotskoga, koji ga je poslije izdao. ");
INSERT INTO hrvbib_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Isus s njima siđe s gore i zaustavi se na nekoj visoravni. Mnoštvo njegovih učenika te silno mnoštvo naroda iz cijele Judeje, Jeruzalema te iz tirskog i sidonskog primorja ");
INSERT INTO hrvbib_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","nagrnulo je da ga sluša i izliječi se od bolesti. Ozdravljali su i ljudi koje su mučili nečisti duhovi. ");
INSERT INTO hrvbib_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Svi su ga pokušavali dotaknuti jer je iz njega izlazila sila koja je sve iscjeljivala. ");
INSERT INTO hrvbib_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Isus se okrene prema učenicima i reče: “Blago vama, siromasi, jer imate kraljevstvo Božje! ");
INSERT INTO hrvbib_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Blago vama koji ste sada gladni, jer ćete se nasititi! Blago vama koji sada plačete, jer ćete se smijati! ");
INSERT INTO hrvbib_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Blago vama kad vas ljudi zamrze, kad vas izopće i pogrde i prezru vaše ime kao zločinačko zbog Sina Čovječjega! ");
INSERT INTO hrvbib_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Kad se to dogodi, radujte se u poskakujte! Jer velika vas nagrada čeka na nebu. Tako su i njihovi očevi postupali prema prorocima.” ");
INSERT INTO hrvbib_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Teško vama, bogataši, jer ste već primili svoju utjehu! ");
INSERT INTO hrvbib_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Teško vama koji ste sada siti, jer ćete gladovati! Teško vama koji se sada smijete, jer ćete tugovati i plakati! ");
INSERT INTO hrvbib_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Teško vama kad vas svi budu hvalili, jer su tako i lažne proroke hvalili njihovi!” ");
INSERT INTO hrvbib_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Želite li me poslušati, kažem vam: Ljubite svoje neprijatelje! Činite dobro onima koji vas mrze. ");
INSERT INTO hrvbib_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Blagoslivljajte one koji vas proklinju i molite se za one koji vas zlostavljaju. ");
INSERT INTO hrvbib_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Udari li vas tko po obrazu, pružite mu i drugi. Uzima li vam tko ogrtač, dajte mu i košulju. ");
INSERT INTO hrvbib_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Tko god vas što zamoli, dajte mu, a od onoga tko vam otima ne tražite svoje natrag. ");
INSERT INTO hrvbib_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Činite drugima ono što biste htjeli da drugi čine vama! ");
INSERT INTO hrvbib_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Mislite li da zaslužujete nagradu ako volite one koji vas vole? Ta i grešnici tako čine. ");
INSERT INTO hrvbib_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","I ako dobro činite onima koji vama čine dobro, zar ste zaslužili nagradu? To čine i grešnici! ");
INSERT INTO hrvbib_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ako posuđujete samo onima od kojih se nadate povratu, kakvu ste nagradu zaslužili? I grešnici posuđuju grešnicima da jednako prime natrag. ");
INSERT INTO hrvbib_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ali vi volite svoje neprijatelje. Činite dobro i posuđujte ne nadajući se ničemu zauzvrat. Tako će vam plaća biti velika i bit ćete djeca Svevišnjega koji je dobrostiv i prema nezahvalnicima i prema opakima. ");
INSERT INTO hrvbib_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Budite milosrdni kao što je milosrdan vaš Otac.” ");
INSERT INTO hrvbib_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Ne sudite i nećete biti suđeni. Ne osuđujte, da ne budete osuđeni. Praštajte i oprostit će vam se. ");
INSERT INTO hrvbib_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Dajte, pa ćete i vi dobiti. Vaš će vam se dar vratiti u punoj i prepunoj mjeri, dobro nabijenoj, natresenoj, preobilnoj. Jer kakvom mjerom dajete, takvom će se i vama davati.” ");
INSERT INTO hrvbib_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Zatim im Isus ispriča prispodobe: “Može li slijepac slijepca voditi? Obojica završe u jarku. ");
INSERT INTO hrvbib_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Učenik nije veći od svojega učitelja, a tko je potpuno poučen, ravan je svojem učitelju. ");
INSERT INTO hrvbib_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Što imaš gledati trun u oku svojega brata kad u vlastitome oku ni brvna ne opažaš? ");
INSERT INTO hrvbib_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Kako ti, koji u vlastitome oku ne vidiš ni brvna, možeš reći bratu: ‘Daj da ti izvadim trun iz oka’? Licemjeru! Izvadi najprije brvno iz vlastitog oka, pa ćeš onda dobro vidjeti kako da izvadiš trun iz bratova!” ");
INSERT INTO hrvbib_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Dobro stablo ne može roditi nevaljalim plodom niti nevaljalo stablo može roditi dobrim plodom. ");
INSERT INTO hrvbib_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Svako se stablo po plodu poznaje. Ne beru se s trnja smokve niti s gloga grožđe. ");
INSERT INTO hrvbib_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Dobar čovjek iz svojega srca iznosi dobra djela, a zao iz svojega zlog srca zla djela. Jer usta govore ono čega je srce prepuno.” ");
INSERT INTO hrvbib_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Zašto me dakle nazivate Gospodinom, a ne činite što vam zapovijedam? ");
INSERT INTO hrvbib_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Reći ću vam kakav je svaki koji dolazi k meni, sluša što govorim i čini tako: ");
INSERT INTO hrvbib_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","on je poput čovjeka koji gradi kuću te iskopa dubok temelj i izgradi kuću na stijeni. Kad dođe poplava i navale bujice, ona ostane čvrsto stajati jer je dobro izgrađena. ");
INSERT INTO hrvbib_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","A onaj tko sluša riječi i ne čini tako jest poput čovjeka koji kuću izgradi na tlu, bez temelja. Kad na nju navali bujica, ona se brzo sruši i od nje ostane velika razvalina.” ");
INSERT INTO hrvbib_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Kad je završio s govorom pred ljudima, Isus ode u Kafarnaum. ");
INSERT INTO hrvbib_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ondje je nekom stotniku bio nasmrt bolestan sluga kojega je veoma cijenio,. ");
INSERT INTO hrvbib_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Kad je stotnik čuo za Isusa, pošalje k njemu židovske starješine s molbom da mu dođe iscijeliti slugu. ");
INSERT INTO hrvbib_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Oni usrdno zamole Isusa: “On zaslužuje da mu to učiniš ");
INSERT INTO hrvbib_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","jer voli naš narod. Čak nam je i sinagogu izgradio.” ");
INSERT INTO hrvbib_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Isus tako pođe s njima. Kad su već stigli nadomak kući, stotnik pošalje prijatelje s porukom: “Gospodine, ne muči se. Nisam dostojan da uđeš u moju kuću. ");
INSERT INTO hrvbib_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Nisam dostojan ni da dođem k tebi, nego samo reci da moj sluga ozdravi i on će ozdraviti! ");
INSERT INTO hrvbib_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Jer i ja moram slušati svoje nadređene. A podređenom vojniku kažem: ‘Idi!’ i on ode, te drugome: ‘Dođi!’ i dođe; a sluzi kažem: ‘Učini to!’ i on učini.” ");
INSERT INTO hrvbib_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Kad je to čuo, Isus se zadivi. Okrene se mnoštvu koje je išlo za njim te reče: “Kažem vam, takve vjere nisam vidio ni u koga u cijelom Izraelu!” ");
INSERT INTO hrvbib_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Kad su se stotnikovi prijatelji vratili kući, našli su slugu posve zdrava. ");
INSERT INTO hrvbib_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Nakon toga Isus ode u gradić zvan Nain. Pratili su ga učenici i silno mnoštvo ljudi. ");
INSERT INTO hrvbib_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Kad su se približili gradskim vratima, naiđe pogrebna povorka. Pokapali su sina jedinca majke udovice. Majku je pratilo mnogo ljudi iz grada. ");
INSERT INTO hrvbib_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Kad ju je Gospodin opazio, sažali se nad njom te joj reče: “Ne plači!” ");
INSERT INTO hrvbib_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Priđe zatim nosilima i dotakne ih. Nosioci zastanu, a on reče: “Mladiću, tebi govorim, ustani!” ");
INSERT INTO hrvbib_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Mrtvi mladić ustane i progovori, a Isus ga dade majci. ");
INSERT INTO hrvbib_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Sve obuzme silan strah te su slavili Boga govoreći: “Velik je prorok ustao među nama. Bog pohodi svoj narod!” ");
INSERT INTO hrvbib_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","I glas o tome Isusovu djelu pronese se svom Judejom i okolicom. ");
INSERT INTO hrvbib_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Učenici Ivana Krstitelja javili su Ivanu o Isusovim djelima. Ivan pozove dvojicu svojih učenika ");
INSERT INTO hrvbib_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","i pošalje ih Gospodinu da ga upitaju: “Jesi li ti zaista onaj koji treba doći ili da čekamo drugoga?” ");
INSERT INTO hrvbib_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Oni dođu k Isusu. “Ivan Krstitelj poslao nas je da te upitamo: ‘Jesi li ti zaista onaj koji treba doći ili da čekamo drugoga?’” ");
INSERT INTO hrvbib_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Upravo tada Isus mnoge iscijeli od bolesti, oslobodi zloduha i mnogim slijepcima vrati vid. ");
INSERT INTO hrvbib_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Zatim odgovori Ivanovim učenicima: “Idite Ivanu i ispričajte što ste čuli i vidjeli: slijepcima se vraća vid, hromi hodaju, gubavci ozdravljaju, gluhi čuju, mrtvi ustaju i Radosna vijest se propovijeda siromasima. ");
INSERT INTO hrvbib_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Recite mu i ovo: ‘Blago onome tko se zbog mene ne sablazni!’” ");
INSERT INTO hrvbib_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Kad su Ivanovi glasnici otišli, Isus počne govoriti mnoštvu o Ivanu. “Kad ste izišli u pustinju, što ste išli gledati? Samo trsku kako se povija na vjetru? ");
INSERT INTO hrvbib_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ili ste išli vidjeti raskošno odjevena čovjeka? Ali takvi žive u kraljevskim palačama. ");
INSERT INTO hrvbib_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ili ste išli vidjeti proroka? Da, on je i više od proroka. ");
INSERT INTO hrvbib_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Jer Ivan je čovjek o kojemu u Svetome pismu piše: ‘Gledajte, šaljem pred vas svojega glasnika i on će vam pripraviti put.’ ");
INSERT INTO hrvbib_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Zaista vam kažem, od svih ljudi koji su ikada rođeni nije bilo većega od Ivana. Pa ipak, i najmanji u kraljevstvu Božjemu veći je od njega!” ");
INSERT INTO hrvbib_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Sav narod koji ga je slušao, pa čak i pokvareni ubirači poreza, uvide nato Božju pravednost i krste se Ivanovim krštenjem. ");
INSERT INTO hrvbib_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Farizeji i zakonoznanci, naprotiv, ne dopuste da ih Ivan krsti te tako onemoguće Božju nakanu za njih. ");
INSERT INTO hrvbib_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","“S kime dakle da usporedim ovaj naraštaj? Kome li su slični? ");
INSERT INTO hrvbib_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","On je poput djece koja sjede i igraju se na gradskome trgu, pa jedna drugoj dovikuju: ‘Veselo smo vam zasvirali, ali niste htjeli zaplesati. Onda smo vam zapjevali tužaljke, ali ni plakati niste htjeli.’ ");
INSERT INTO hrvbib_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Jer, došao je Ivan Krstitelj. Nije kruha jeo ni vina pio, a vi kažete: ‘Ima zloduha.’ ");
INSERT INTO hrvbib_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Onda sam došao ja, Sin Čovječji. Jedem i pijem, pa sada kažete: ‘Izjelica je i pijanac, prijatelj je ubiračima poreza i drugim grešnicima!’ ");
INSERT INTO hrvbib_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ali Božja će se mudrost opravdati djelima pred svom svojom djecom.” ");
INSERT INTO hrvbib_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Neki farizej pozove Isusa k sebi na objed te Isus dođe i zauzme mjesto za stolom. ");
INSERT INTO hrvbib_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Uto dođe neka žena koja je bila javna grešnica. Doznala je da je Isus u gradu pa je donijela alabasternu posudu mirisne pomasti. ");
INSERT INTO hrvbib_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Plačući, klekne otraga do njegovih nogu. Suze su joj kapale po njegovim nogama pa ih je otirala svojom kosom. Zatim mu je cjelivala noge i mazala ih mirisnom pomašću. ");
INSERT INTO hrvbib_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Kad je Isusov domaćin farizej to vidio, pomisli: “Kad bi on zaista bio prorok, znao bi kakva je ta žena koja ga dotiče. Pa ona je grešnica!” ");
INSERT INTO hrvbib_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","“Šimune, imam ti nešto reći”, nato će Isus. “Reci, učitelju”, odgovori Šimun. ");
INSERT INTO hrvbib_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","“Neki je vjerovnik imao dvojicu dužnika. Jedan mu je dugovao petsto, a drugi pedeset srebrnjaka. ");
INSERT INTO hrvbib_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Nisu mu imali odakle vratiti dug, pa ga on obojici oprosti. Što misliš, tko će ga od njih dvojice zato više voljeti?” ");
INSERT INTO hrvbib_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","“Vjerojatno onaj kojemu je više oprostio”, odgovori Šimun. “Dobro si zaključio”, reče mu Isus. ");
INSERT INTO hrvbib_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Okrene se zatim prema ženi i reče mu: “Pogledaj ovu ženu! Kad sam ti ušao u kuću, ti mi nisi ponudio ni vode da operem noge, a ona mi ih je oprala suzama i otrla svojom kosom. ");
INSERT INTO hrvbib_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ti me nisi ni pozdravio poljupcem, a ona mi nije prestala cjelivati noge otkad je došla. ");
INSERT INTO hrvbib_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Nisi mi u znak dobrodošlice ni glavu pomazao maslinovim uljem, a ona mi je skupocjenom pomašću pomazala noge. ");
INSERT INTO hrvbib_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ako mi iskazuje mnogo ljubavi, to je zato što su joj oprošteni mnogi grijesi; no komu je malo oprošteno, pokazuje malo ljubavi.” ");
INSERT INTO hrvbib_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Zatim reče ženi: “Grijesi su ti oprošteni!” ");
INSERT INTO hrvbib_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ljudi za stolom počnu međusobno govoriti: “Tko je ovaj da i grijehe oprašta?” ");
INSERT INTO hrvbib_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","A Isus reče ženi: “Spasila te tvoja vjera. Idi u miru.” ");
INSERT INTO hrvbib_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Nedugo zatim Isus počne obilaziti gradove i sela propovijedajući i naviještajući Radosnu vijest o Božjemu kraljevstvu. S njim su išla Dvanaestorica ");
INSERT INTO hrvbib_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","i neke žene koje je oslobodio zloduha i izliječio od bolesti: Marija zvana Magdalena, iz koje je istjerao sedam zlih duhova, ");
INSERT INTO hrvbib_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","zatim Ivana, žena Herodova upravitelja Kuza, te Suzana i još mnoge. One su im služile svojim dobrima. ");
INSERT INTO hrvbib_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Jednoć kad je nagrnulo silno mnoštvo iz svih gradova, on im ispriča prispodobu: ");
INSERT INTO hrvbib_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Neki je ratar sijao sjeme. Dok je sijao, nešto sjemena padne na stazu pa ga pogaze. Dođu i ptice nebeske te ga pozobaju. ");
INSERT INTO hrvbib_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Drugo padne na kamenito tlo, ali tek što je niknulo, osuši se jer nije imalo vlage. ");
INSERT INTO hrvbib_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Dio sjemena padne u trnje pa ono poraste i uguši ga. ");
INSERT INTO hrvbib_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Nešto ga, napokon, padne u dobru zemlju te donese stostruk plod.” Kad je to rekao, poviče: “Slušajte, kad već imate uši!” ");
INSERT INTO hrvbib_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Učenici ga upitaju o značenju te prispodobe. ");
INSERT INTO hrvbib_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","On im reče: “Vama je dopušteno razumjeti tajne o Božjemu kraljevstvu. A ostalima govorim u prispodobama da se ispuni Sveto pismo: ‘Gledat će moja djela, ali neće dokučiti njihova značenja; slušat će moje riječi, ali ih neće razumjeti.’ ");
INSERT INTO hrvbib_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Evo značenja prispodobe: Sjeme je Božja riječ. ");
INSERT INTO hrvbib_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Sjeme na tvrdu tlu oni su koji čuju Božju riječ, ali zatim dolazi đavao i odnosi Riječ iz njihova srca te oni ne povjeruju i ne spase se. ");
INSERT INTO hrvbib_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Kamenito tlo su oni koji čuju Riječ i radosno ju prihvate, ali nemaju korijena. Neko vrijeme vjeruju, ali kada dođe kušnja otpadnu. ");
INSERT INTO hrvbib_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","U trnje zasijano sjeme su oni koji čuju Riječ, ali ju uguše životne brige, bogatstvo i užici te zato ne donesu roda. ");
INSERT INTO hrvbib_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Dobro tlo su plemenita i dobra srca koja slušaju Riječ, ustrajno ju čuvaju i donose plod.” ");
INSERT INTO hrvbib_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Nitko ne pali svjetiljku da ju pokrije ili stavi pod postelju, već zato da ju stavi na svijećnjak kako bi svi koji uđu vidjeli svjetlost. ");
INSERT INTO hrvbib_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Sve što je sada skriveno i što je u potaji učinjeno, jednom će izići na vidjelo. ");
INSERT INTO hrvbib_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Zato pazite kako slušate. Onima koji žive po Božjoj mudrosti Bog će dati još više mudrosti. A oni koji ne postupaju prema njegovoj mudrosti, izgubit će ubrzo i ono malo od nje što misle da imaju.” ");
INSERT INTO hrvbib_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Isusu su došli majka i braća, ali nisu mogli do njega od mnoštva naroda. ");
INSERT INTO hrvbib_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Netko mu je javio: “Vani su ti majka i braća, žele te vidjeti.” ");
INSERT INTO hrvbib_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Isus odgovori: “Moja majka i moja braća su oni koji slušaju Božju riječ i tvore ju.” ");
INSERT INTO hrvbib_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Isus i učenici jednog su dana ušli u lađicu. Isus im reče: “Prijeđimo na drugu stranu jezera.” I otisnu se od obale. ");
INSERT INTO hrvbib_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Dok su plovili, Isus je zaspao. Na jezeru se podigne oluja. Voda se stane prelijevati u lađicu tako da se gotovo posve napunila vodom. Bili su u pogibli. ");
INSERT INTO hrvbib_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Učenici probude Isusa vičući: “Učitelju! Učitelju, izginut ćemo!” Isus se probudi te zaprijeti vjetru i uzburkanim valovima. Oni se umire i nastane tišina. ");
INSERT INTO hrvbib_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","“Gdje vam je vjera?” upita ih. A učenici su prestrašeni i začuđeni pitali: “Tko je on da zapovijeda vjetrovima i vodi i da mu se oni pokoravaju?” ");
INSERT INTO hrvbib_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Doplove tako u gergezenski kraj nasuprot Galileji. ");
INSERT INTO hrvbib_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Tek što je Isus izišao na kopno, dođe mu iz grada u susret neki čovjek opsjednut zlodusima. Već dugo nije nosio odjeću ni stanovao u kući, nego po grobnicama. ");
INSERT INTO hrvbib_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Čim je ugledao Isusa, on zaviče, baci se ničice pred njega i na sav glas poviče: “Što hoćeš od mene, Isuse, Sine najuzvišenijega Boga? Molim te, ne muči me!” ");
INSERT INTO hrvbib_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Jer Isus je zapovjedio nečistom duhu da iziđe iz čovjeka kojega je već dugo držao u vlasti. Čak i kad su ga vezali lancima i okovima, čovjek ih je raskinuo jer ga je zloduh gonio u pustinju. ");
INSERT INTO hrvbib_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","“Kako se zoveš?” upita ga Isus. “Legija”, odgovori on jer su u njega ušli mnogi zlodusi. ");
INSERT INTO hrvbib_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Zaklinjali su Isusa da im ne zapovjedi da odu u Bezdan. ");
INSERT INTO hrvbib_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","A ondje je u gori paslo veliko krdo svinja. Zlodusi zamole Isusa da im dopusti ući u svinje. On im dopusti. ");
INSERT INTO hrvbib_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Zlodusi iziđu iz čovjeka i uđu u svinje. Nato cijelo krdo jurne niz obronak u jezero i podavi se. ");
INSERT INTO hrvbib_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Kad su svinjari vidjeli što se dogodilo, pobjegnu i razglase to po gradiću i selima ");
INSERT INTO hrvbib_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","te ljudi dođu vidjeti što se dogodilo. Kad su došli Isusu, nađu čovjeka iz kojega su izišli zlodusi kako obučen i zdrave pameti sjedi do Isusovih nogu te se prestraše. ");
INSERT INTO hrvbib_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Očevici im ispričaju kako je opsjednuti spašen. ");
INSERT INTO hrvbib_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Svo mnoštvo iz gergezenskoga kraja obuzme silan strah pa zamole Isusa da ode od njih. Isus uđe u lađicu i vrati se. ");
INSERT INTO hrvbib_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","A čovjek, iz koga su bili izišli zli dusi, zamolio ga je da ostane s njim, ali Isus mu reče: ");
INSERT INTO hrvbib_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Ne, vrati se doma i reci svima što ti je Bog učinio.” Čovjek ode i po svem gradu razglasi što mu je Isus učinio. ");
INSERT INTO hrvbib_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Kad se Isus vratio na drugu stranu jezera, mnoštvo ga je dočekalo s dobrodošlicom jer su ga svi željno iščekivali. ");
INSERT INTO hrvbib_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Dođe tada neki čovjek imenom Jair, predstojnik sinagoge, te se baci Isusu pred noge moleći ga da pođe njegovu domu. ");
INSERT INTO hrvbib_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Dvanaestogodišnja kći jedinica bila mu je na samrti. Isus pođe za njim dok se mnoštvo natiskivalo oko njega. ");
INSERT INTO hrvbib_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Među ljudima je bila i neka žena koja je već dvanaest godina bolovala od krvarenja. Sve što je imala potrošila je na liječnike, ali ju nitko nije mogao izliječiti. ");
INSERT INTO hrvbib_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ona priđe Isusu otraga i dotakne skut njegova ogrtača. Krvarenje joj odmah prestane. ");
INSERT INTO hrvbib_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","“Tko me je dotaknuo?” upita Isus. Svi su to nijekali, a Petar reče: “Učitelju, pa toliko se mnoštvo gura oko tebe!” ");
INSERT INTO hrvbib_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Isus odgovori: “Ne, netko me je namjerno dotaknuo. Osjetio sam kako sila izlazi iz mene.” ");
INSERT INTO hrvbib_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Videći da se ne može skriti, žena mu sva uplašena priđe, padne ničice i pred svima ispriča zašto ga je dotaknula i kako je smjesta ozdravila. ");
INSERT INTO hrvbib_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","On joj reče: “Kćeri, tvoja te vjera iscijelila. Pođi u miru.” ");
INSERT INTO hrvbib_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Dok je Isus još to govorio, stigao je netko iz Jairova doma s viješću: “Kći ti je umrla. Nema smisla da dalje mučiš Učitelja!” ");
INSERT INTO hrvbib_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Isus je to čuo pa reče Jairu: “Ne boj se! Samo vjeruj i ona će se spasiti!” ");
INSERT INTO hrvbib_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Kad je došao u kuću, ne dopusti nikomu da uđe s njim osim Petru, Ivanu, Jakovu te djetetovu ocu i majci. ");
INSERT INTO hrvbib_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Svi su ondje plakali i naricali za djevojčicom. Isus im reče: “Ne plačite! Nije umrla, nego samo spava!” ");
INSERT INTO hrvbib_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ali oni su ga ismijavali znajući da je umrla. ");
INSERT INTO hrvbib_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Isus ju uhvati za ruku i poviče: “Ustani, djevojčice!” ");
INSERT INTO hrvbib_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","U nju se odmah vrati duh te ustane. Isus zapovjedi da joj daju jesti. ");
INSERT INTO hrvbib_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Roditelji se zaprepaste. A Isus im zapovjedi da nikome ne govore o tome što se dogodilo. ");
INSERT INTO hrvbib_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Isus pozove Dvanaestoricu te im dade vlast i moć nad svim zlodusima i moć da liječe bolesti. ");
INSERT INTO hrvbib_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Pošalje ih zatim da propovijedaju o Božjemu kraljevstvu i da iscjeljuju bolesnike. ");
INSERT INTO hrvbib_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","“Ništa ne nosite sa sobom na put”, reče im. “Ni štap, ni torbu, ni kruh, ni novac. Nemojte imati ni više od dviju haljina. ");
INSERT INTO hrvbib_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Kad boravite u nekome mjestu, stanujte u jednoj kući i ne mijenjajte smještaj. ");
INSERT INTO hrvbib_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ako vas u nekome mjestu ne poslušaju, otiđite iz njega te na odlasku stresite i prašinu s nogu. To će biti znak da ste ga prepustili njegovoj sudbini.” ");
INSERT INTO hrvbib_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","I učenici pođu. Obilazili su sela navješćujući Radosnu vijest i iscjeljujući bolesnike posvuda. ");
INSERT INTO hrvbib_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Kad je Herod tetrarh čuo o svemu što se događalo, uznemirio se i zbunio jer su neki govorili: “To je Ivan uskrsnuo od mrtvih.” ");
INSERT INTO hrvbib_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Drugi su rekli: “Pojavio se Ilija”, a treći: “Ustao je neki od drevnih proroka.” ");
INSERT INTO hrvbib_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","“Ivanu sam ja odrubio glavu”, reče Herod. “Tko je onda ovaj o kojemu toliko govore?” I tražio je prigodu da ga vidi. ");
INSERT INTO hrvbib_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Kad su se apostoli vratili, ispripovjede Isusu sve što su učinili. Isus ih povede sa sobom i povuče se s njima u osamu u grad zvani Betsaida. ");
INSERT INTO hrvbib_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ali mnoštvo je to saznalo i krenulo za njima. Isus ih je primio. Poučavao ih je o Božjemu kraljevstvu i iscjeljivao bolesnike. ");
INSERT INTO hrvbib_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Kasno popodne prišla su mu dvanaestorica učenika. “Otpusti ljude”, rekli su. “Neka odu u okolna sela i zaseoke pronaći smještaj i jelo jer smo ovdje u pustoši.” ");
INSERT INTO hrvbib_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ali Isus im reče: “Vi ih nahranite.” “Imamo samo pet kruhova i dvije ribe”, prosvjedovali su. “Zar da mi idemo kupiti hranu za sav ovaj narod?” ");
INSERT INTO hrvbib_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Samo muškaraca ondje je bilo otprilike pet tisuća. “Recite im da posjedaju u skupine po pedesetero”, odgovori Isus. ");
INSERT INTO hrvbib_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","I svi posjedaju. ");
INSERT INTO hrvbib_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Isus uzme pet kruhova i dvije ribe, pogleda u nebo i blagoslovi hranu te razlomi kruhove. Dade ih zatim učenicima da podijele ljudima. ");
INSERT INTO hrvbib_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Svi su jeli dok se nisu nasitili i još su dvanaest košara napunili ostacima preostalima mnoštvu. ");
INSERT INTO hrvbib_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Dok se Isus jednom u osami molio, s njim su bili samo učenici. On ih upita: “Što ljudi kažu, tko sam ja?” ");
INSERT INTO hrvbib_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Oni odgovore: “Neki kažu da si Ivan Krstitelj, drugi da si Ilija, a treći da si neki drevni prorok koji je ustao od mrtvih.” ");
INSERT INTO hrvbib_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","“A za koga me vi držite?” upita ih. Petar reče: “Ti si Krist, Pomazanik Božji!” ");
INSERT INTO hrvbib_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Isus im zabrani da ikomu o tomu govore. ");
INSERT INTO hrvbib_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","“Jer ja, Sin Čovječji, moram mnogo pretrpjeti. Starješine, svećenički poglavari i pismoznanci će me odbaciti. Ubit će me, a ja ću treći dan uskrsnuti.” ");
INSERT INTO hrvbib_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Zatim reče svima: “Želi li tko biti mojim sljedbenikom, neka se odrekne samoga sebe, neka danomice uzima svoj križ i neka ide za mnom. ");
INSERT INTO hrvbib_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Jer svatko tko želi sačuvati svoj život izgubit će ga; a tko dade svoj život za mene, imat će istinski život. ");
INSERT INTO hrvbib_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Kakva ti je korist ako stekneš sav svijet, a izgubiš samoga sebe ili sebi naudi? ");
INSERT INTO hrvbib_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Posrami li se tko mene i mojih riječi, njega ću se i ja, Sin Čovječji, posramiti kada dođem u svojoj i Očevoj slavi i u slavi svetih anđela. ");
INSERT INTO hrvbib_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Zaista vam kažem, neki među vama koji ste ovdje neće umrijeti prije nego što vide Božje kraljevstvo.” ");
INSERT INTO hrvbib_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Otprilike osam dana nakon toga povede Isus Petra, Ivana i Jakova u goru da se pomoli. ");
INSERT INTO hrvbib_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Dok se molio, lice mu se preobrazi a odjeća zablista bijelim sjajem. ");
INSERT INTO hrvbib_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Uto se pojave dvojica ljudi i počnu razgovarati s Isusom. Bili su to Mojsije i Ilija. ");
INSERT INTO hrvbib_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Pojavili su se u slavi i razgovarali su s njim o smrti koju je trebao podnijeti u Jeruzalemu da se ispuni Pismo. ");
INSERT INTO hrvbib_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Petra i njegove drugove svladao je san. Kad su se probudili, ugledali su Isusa u slavi i dvojicu ljudi kako stoje s njim. ");
INSERT INTO hrvbib_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Dok su ta dvojica odlazili, Petar reče Isusu: “Učitelju, dobro je što smo ovdje! Napravit ćemo tu tri sjenice: jednu za tebe, jednu za Mojsija i jednu za Iliju.” Nije, naime, znao što da kaže. ");
INSERT INTO hrvbib_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Još dok je govorio, pojavi se oblak i prekrije ih. Kad su se našli u oblaku, silno se prestraše. ");
INSERT INTO hrvbib_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Iz oblaka se začuje glas: “Ovo je moj Sin kojega sam izabrao! Njega slušajte!” ");
INSERT INTO hrvbib_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Baš kad se začuo glas, Isus ostane sam. Učenici su šutjeli i tada još nikome nisu ništa govorili o onome što su vidjeli. ");
INSERT INTO hrvbib_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Kad su sutradan sišli s gore, Isusu dođe u susret silno mnoštvo. ");
INSERT INTO hrvbib_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Neki čovjek iz mnoštva poviče: “Učitelju, molim te, pogledaj mi sina! Jedinac mi je! ");
INSERT INTO hrvbib_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Opsjeda ga duh pa odjednom počne vrištati, bacati se i ide mu pjena na usta. Jedva ga ostavi kad ga sveg izmrcvari. ");
INSERT INTO hrvbib_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Molio sam tvoje učenike da ga istjeraju, ali nisu mogli.” ");
INSERT INTO hrvbib_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","“Nevjerni i opaki rode!” reče Isus. “Koliko dugo još moram biti s vama? Dokle vas moram podnositi? Dovedi sina!” ");
INSERT INTO hrvbib_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Dok je dječak prilazio, zloduh ga baci na tlo i počne ga grčiti. A Isus zaprijeti nečistome duhu, iscijeli dječaka i preda ga njegovu ocu. ");
INSERT INTO hrvbib_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Svi su bili osupnuti Božjim veličanstvom. Dok su sve divili svemu što je učinio, Isus reče učenicima: ");
INSERT INTO hrvbib_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Zapamtite dobro što vam govorim: Sin Čovječji bit će predan ljudima u ruke.” ");
INSERT INTO hrvbib_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ali oni nisu razumjeli što im kazuje. Značenje im je bilo skriveno, a bojali su se pitati ga da im objasni. ");
INSERT INTO hrvbib_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Učenici počnu razmišljati o tomu tko bi od njih mogao biti najveći. ");
INSERT INTO hrvbib_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Znajući što im je na srcu, Isus uzme dijete, postavi ga uza se ");
INSERT INTO hrvbib_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","i reče: “Tko prihvati ovo malo dijete radi mene, mene prihvaća. A tko mene prihvati, prihvaća Boga koji me je poslao. Tko je najmanji među vama, taj je najveći.” ");
INSERT INTO hrvbib_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ivan mu reče: “Učitelju, vidjeli smo nekog čovjeka da se koristi tvojim imenom izgoneći zle duhove; rekli smo mu da to ne radi jer nije iz naše skupine.” ");
INSERT INTO hrvbib_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","“Ne branite mu!” reče im Isus. “Tko nije protiv vas, za vas je!” ");
INSERT INTO hrvbib_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Kad se približilo vrijeme njegova povratka u nebo, Isus odlučno krene u Jeruzalem ");
INSERT INTO hrvbib_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","i pošalje pred sobom glasnike. Oni odu u neko samarijsko selo da mu priprave smještaj. ");
INSERT INTO hrvbib_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ali ondje ga ljudi nisu htjeli primiti jer je putovao u Jeruzalem. ");
INSERT INTO hrvbib_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Kad su to vidjeli učenici Jakov i Ivan, upitaju Isusa: “Gospodine, hoćeš li da zapovjedimo da ih spali oganj s neba?” ");
INSERT INTO hrvbib_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ali on se okrene i prekori ih. ");
INSERT INTO hrvbib_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Zatim odu u drugo selo. ");
INSERT INTO hrvbib_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Dok su išli putem, neki čovjek reče Isusu: “Slijedit ću te kamo god ti pošao!” ");
INSERT INTO hrvbib_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ali Isus mu odgovori: “Lisice imaju jame i ptice imaju gnijezda, a Sin Čovječji nema gdje ni glavu nasloniti.” ");
INSERT INTO hrvbib_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Nekome drugome reče: “Slijedi me!” Čovjek odgovori: “Gospodine, dopusti mi da najprije odem pokopati oca.” ");
INSERT INTO hrvbib_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ali Isus mu odgovori: “Pusti da mrtvi pokapaju svoje mrtvace, a ti idi naviještati Božje kraljevstvo!” ");
INSERT INTO hrvbib_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Još netko reče: “Gospodine, slijedit ću te, ali mi najprije dopusti da se oprostim sa svojim ukućanima.” ");
INSERT INTO hrvbib_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ali Isus mu odgovori: “Tko stavi ruku na plug, a zatim se okreće natrag, nije prikladan za Božje kraljevstvo.” ");
INSERT INTO hrvbib_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Gospodin nakon toga izabere još sedamdesetdvojicu učenika i pošalje ih po dvojicu da idu pred njim u svaki grad i mjesto kamo je kanio ići. ");
INSERT INTO hrvbib_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Govorio im je: “Žetva je velika, ali je radnika malo. Molite zato gospodara žetve da pošalje žeteoce. ");
INSERT INTO hrvbib_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Idite! Šaljem vas, evo, kao janjad među vukove. ");
INSERT INTO hrvbib_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ne nosite sa sobom ni novac, ni torbu, ni obuću. Putem ne gubite vrijeme pozdravljajući ljude i razgovarajući s njima. ");
INSERT INTO hrvbib_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Kad uđete u neku kuću, najprije ju blagoslovite: ‘Mir ovoj kući!’ ");
INSERT INTO hrvbib_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Bude li ondje tko dostojan mira, vaš će mir sići na njega. Ne bude li takvoga, vaš će se mir vratiti vama. ");
INSERT INTO hrvbib_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Kad dođete u neku kuću, ne prelazite više iz jedne u drugu. Ostanite na jednomu mjestu te jedite i pijte što vam daju jer radnik zaslužuje plaću. ");
INSERT INTO hrvbib_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Kad uđete u neki grad i ondje vas prime, jedite što vam ponude. ");
INSERT INTO hrvbib_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Iscjeljujte ondje bolesnike i kazujte im: ‘Približilo vam se Božje kraljevstvo!’ ");
INSERT INTO hrvbib_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ali kad uđete u neki grad pa vas ne prime, iziđite na njegove ulice pa recite: ");
INSERT INTO hrvbib_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Čak i prašinu iz vašega grada što nam se uhvatila za noge otresamo sa sebe za svjedočanstvo protiv vas. Ali znajte da je Božje kraljevstvo blizu!’ ");
INSERT INTO hrvbib_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Kažem vam da će i Sodomi na Sudnji dan biti lakše nego tomu mjestu! ");
INSERT INTO hrvbib_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Teško tebi, Korozaine! Teško tebi, Betsaido! Jer da su se čudesa koja su se kod vas dogodila zbila u pokvarenima Tiru i Sidonu, oni bi se već odavno obratili te sjedili u kostrijeti i pepelu. ");
INSERT INTO hrvbib_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ali Tiru i Sidonu bit će lakše na Sudnji dan nego vama! ");
INSERT INTO hrvbib_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","A ti, Kafarnaume, zar ćeš se do neba uzdignuti? Strovalit ćeš se u pakao.” ");
INSERT INTO hrvbib_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Zatim reče učenicima: “Tko vas sluša, mene sluša, a tko vas odbaci, mene je odbacio. Tko odbacuje mene, odbacuje Boga koji me je poslao.” ");
INSERT INTO hrvbib_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Kad su se sedamdesetdvojica učenika vratili, radosno su kazali: “Gospodine, čak nam se i zlodusi pokoravaju u tvoje ime.” ");
INSERT INTO hrvbib_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","“Da,” reče im on, “vidio sam Sotonu kako poput munje pada s neba. ");
INSERT INTO hrvbib_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Dao sam vam, eto, vlast nad svakom neprijateljskom silom da gazite zmije i štipavce. Ništa vam neće moći nauditi. ");
INSERT INTO hrvbib_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ali nemojte se radovati tomu što vam se zlodusi pokoravaju. Radujte se što su vaša imena zapisana na nebesima.” ");
INSERT INTO hrvbib_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Isusa zatim ispuni radost u Svetome Duhu te reče: “Slavim te, Oče, Gospodaru neba i zemlje, što si to skrio od mudrih i umnih, a objavio malenima. Da, Oče, tebi se to svidjelo tako učiniti. ");
INSERT INTO hrvbib_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Moj mi je Otac sve predao. Nitko ne poznaje Sina nego Otac i nitko ne poznaje Oca nego Sin i oni kojima se Sin hoće objaviti.” ");
INSERT INTO hrvbib_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Okrene se zatim prema učenicima te im nasamo reče: “Blago vama jer vam to oči gledaju. ");
INSERT INTO hrvbib_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Kažem vam, mnogi su proroci i kraljevi željeli vidjeti to što vi gledate, ali nisu vidjeli; željeli su čuti što vi čujete, ali nisu čuli.” ");
INSERT INTO hrvbib_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Jednom neki zakonoznanac ustane i upita Isusa da ga iskuša: “Učitelju, što moram učiniti da dobijem vječni život?” ");
INSERT INTO hrvbib_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","“Što piše u Mojsijevu zakonu? Što ondje čitaš?” ");
INSERT INTO hrvbib_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","“‘Ljubi Gospodina Boga svojega svim srcem svojim, svom dušom svojom i svom pameti svojom, a svojega bližnjega kao samoga sebe’”, odgovori čovjek. ");
INSERT INTO hrvbib_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","“Tako je”, reče Isus. “Čini tako pa ćeš živjeti.” ");
INSERT INTO hrvbib_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ali hoteći se opravdati, on upita Isusa: “A tko mi je bližnji?” ");
INSERT INTO hrvbib_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Isus mu odgovori prispodobom: “Nekog su čovjeka koji je putovao iz Jeruzalema u Jerihon napali razbojnici te ga svukli, pretukli i ostavili polumrtva uz cestu. ");
INSERT INTO hrvbib_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Onuda je slučajno prolazio židovski svećenik. Kad ugleda polumrtvog čovjeka, zaobiđe ga i ode. ");
INSERT INTO hrvbib_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Naiđe zatim i levit, svećenički pomoćnik. Kad ga ugleda, također ga zaobiđe i ode. ");
INSERT INTO hrvbib_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Zatim dođe i prezreni Samarijanac, koji je onuda putovao. Kad ugleda čovjeka, sažali se nad njim. ");
INSERT INTO hrvbib_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Priđe mu, opere mu rane maslinovim uljem i vinom te ih previje. Podigne ga zatim na magarca i odvede u gostionicu te ga je ondje njegovao. ");
INSERT INTO hrvbib_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Sutradan gostioničaru dade dva srebrnjaka i reče mu: ‘Brini se za njega. Potrošiš li više, platit ću ti na povratku.’ ");
INSERT INTO hrvbib_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Što kažeš, koji je od te trojice bio bližnji čovjeku kojega su napali razbojnici?” ");
INSERT INTO hrvbib_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","“Onaj koji mu je iskazao milosrđe”, reče čovjek. Isus mu reče: “Idi pa i ti čini tako.” ");
INSERT INTO hrvbib_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Putujući dalje prema Jeruzalemu, Isus i učenici uđu u neko selo. Tu ga neka žena, imenom Marta, primi u svoj dom. ");
INSERT INTO hrvbib_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Njezina je sestra Marija sjedila do Gospodinovih nogu i slušala što govori. ");
INSERT INTO hrvbib_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","A Marta je bila tako zauzeta pripremanjem i posluživanjem da mu se došla požaliti: “Gospodine, zar ti uopće ne mariš što me je sestra ostavila da sama poslužujem? Reci joj da mi pomogne!” ");
INSERT INTO hrvbib_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ali Gospodin joj odgovori: “Marta, Marta! Brineš se i uznemiruješ oko svih tih sitnica. ");
INSERT INTO hrvbib_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","A zapravo se vrijedi brinuti samo o jednome. Marija je to shvatila—i neću joj to oduzeti.” ");
INSERT INTO hrvbib_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Kad je Isus završio s molitvom, priđe mu jedan od učenika i reče: “Gospodine, nauči nas moliti kao što je i Ivan naučio svoje učenike.” ");
INSERT INTO hrvbib_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Isus reče: “Kad se molite, recite: ‘Oče naš na nebu, neka se štuje tvoje sveto ime. Neka dođe tvoje kraljevstvo. ");
INSERT INTO hrvbib_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Kruh naš svagdašnji daj nam danas ");
INSERT INTO hrvbib_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","i oprosti nam naše grijehe, kao što i mi opraštamo onima koji griješe protiv nas. I ne dopusti da podlegnemo kušnji, nego nas izbavi od Zloga.’” ");
INSERT INTO hrvbib_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Reče im zatim: “Zamislite da u ponoć odete svojem prijatelju želeći posuditi tri kruha i kažete mu: ");
INSERT INTO hrvbib_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","‘Stigao mi je u goste prijatelj, a nemam mu što dati za jelo.’ ");
INSERT INTO hrvbib_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","On bi vam iznutra doviknuo: ‘Ne uznemiruj me! Vrata su već zaključana, a djeca su u postelji. Ne mogu sada ustajati da ti to dadem.’ ");
INSERT INTO hrvbib_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ali kažem vam, ne učini li to zbog prijateljstva, učinit će to da se ne osramoti. ");
INSERT INTO hrvbib_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Kažem vam: Molite i dat će vam se! Tražite i naći ćete! Kucajte i otvorit će vam se! ");
INSERT INTO hrvbib_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Jer tko god moli, prima. Tko god traži, nalazi. Tko kuca, otvara mu se. ");
INSERT INTO hrvbib_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Bi li ijedan otac svojemu djetetu, kad bi ga zaiskalo ribu, dao zmiju? ");
INSERT INTO hrvbib_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ili bi mu tko dao štipavca kad ga zaište jaje? ");
INSERT INTO hrvbib_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Pa ako vi, grešni ljudi, znate davati dobre darove svojoj djeci, koliko će više vaš nebeski Otac darovati Svetoga Duha onima koji ga mole?” ");
INSERT INTO hrvbib_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Isus jednom istjera nijemog zloduha iz nekog njemaka. Kad je zloduh izišao, njemak progovori. Mnoštvo se divilo. ");
INSERT INTO hrvbib_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ali neki rekoše: “Taj zloduhe izgoni s pomoću Beelzebula, poglavice zlih duhova.” ");
INSERT INTO hrvbib_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","A drugi su ga iskušavali ištući da im dade kakav znak s neba kao dokaz da ga je Bog poslao. ");
INSERT INTO hrvbib_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Znajući što misle, Isus im reče: “Svako podijeljeno kraljevstvo propada. Dom u kojemu vlada nesloga će se raspasti. ");
INSERT INTO hrvbib_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Kažete da ja s pomoću Beelzebula izgonim zloduhe. Sotonino je kraljevstvo, dakle, razjedinjeno. Kako će se onda održati? ");
INSERT INTO hrvbib_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ako ja zaista izgonim zle duhove uz pomoć Beelzebula, čijom ih pomoći istjeruju vaši sljedbenici? Zato će vas oni osuditi. ");
INSERT INTO hrvbib_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ali ako ja zloduhe izgonim Božjim prstom, onda je k vama stiglo Božje kraljevstvo. ");
INSERT INTO hrvbib_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Dok snažni i dobro naoružani čuva svoj dom, njegov je posjed osiguran. ");
INSERT INTO hrvbib_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ali kada dođe jači od njega, svlada ga i otme mu sve oružje u koje se uzdao te podijeli plijen. ");
INSERT INTO hrvbib_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Tko nije na mojoj strani, zapravo je protiv mene; i svatko tko sa mnom ne skuplja, zapravo rastjeruje. ");
INSERT INTO hrvbib_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Kad nečisti duh iziđe iz čovjeka, luta bezvodnim mjestima tražeći odmora, ali ga ne nalazi. Tada kaže: ‘Vratit ću se u kuću iz koje sam izišao.’ ");
INSERT INTO hrvbib_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Vrati se i svoj stari dom zatekne pometen i čist. ");
INSERT INTO hrvbib_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Zatim ode pronaći drugih sedam duhova još gorih od sebe te svi oni uđu u čovjeka i u njemu se nastane. Na koncu tako čovjeku bude i gore nego prije.” ");
INSERT INTO hrvbib_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Dok je još govorio, neka žena iz mnoštva poviče: “Blagoslovljena utroba koje te je nosila i prsa koja si sisao!” ");
INSERT INTO hrvbib_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","“Još su blagoslovljeniji oni koji slušaju Božju riječ i tvore ju”, odgovori joj Isus. ");
INSERT INTO hrvbib_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Kad je mnoštvo nagrnulo k Isusu, on reče: “Zao je ovo naraštaj. Traži znak, ali neće mu se dati drugoga osim znaka proroka Jone. ");
INSERT INTO hrvbib_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Što se dogodilo Joni, bilo je Ninivljanima znak da ga je Bog poslao. Što će se sa mnom dogoditi, bit će znak da je mene, Sina Čovječjega, Bog poslao ovom narodu. ");
INSERT INTO hrvbib_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Kraljica Juga ustat će protiv ovoga naraštaja na Sudu i osuditi ga jer je izdaleka došla čuti Salomonovu mudrost, a s vama je ovdje i veći od Salomona. ");
INSERT INTO hrvbib_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Stanovnici Ninive ustat će protiv ovoga naraštaja na Sudu i osuditi ga jer su se oni obratili na Jonino propovijedanje. S vama je ovdje i veći od Jone!” ");
INSERT INTO hrvbib_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Nitko ne pali svjetiljku da ju pokrije ili stavi pod košaru, već zato da ju stavi na svijećnjak kako bi svi koji uđu vidjeli svjetlost. ");
INSERT INTO hrvbib_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Oko je poput svjetiljke tijelu. Ne budete li odviše brinuli za materijalna dobra, jasno ćete vidjeti u životu, ali ako se za njih previše brinete, vid će vam biti zasjenjen i tama će vam ispuniti život. ");
INSERT INTO hrvbib_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Pazite dakle da se svjetlost koja je u vama ne zamrači. ");
INSERT INTO hrvbib_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ako dakle sve vaše biće bude svijetlo bez djelića tame, cijelo će biti rasvijetljeno kao da ga je obasjala svjetiljka.” ");
INSERT INTO hrvbib_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Dok je Isus još govorio, neki ga farizej pozove k sebi na objed. Isus uđe i zauzme mjesto za stolom. ");
INSERT INTO hrvbib_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Kad je farizej to vidio, začudi se što Isus prije objeda nije, prema židovskome običaju, obavio obredno pranje ruku. ");
INSERT INTO hrvbib_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","A Gospodin mu reče: “Vi farizeji toliko se trudite očistiti svoju čašu i zdjelu izvana, a napunili ste ih svojim grabežom i pakošću. ");
INSERT INTO hrvbib_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Bezumnici! Nije li Bog taj koji je načinio i nutrinu, a ne samo vanjštinu? ");
INSERT INTO hrvbib_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Dajte zato to iznutra, što grabežljivo čuvate, kao milostinju onima kojima je potrebna pa ćete cijeli biti čisti. ");
INSERT INTO hrvbib_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Teško vama, farizeji! Jer revno namirujete čak i desetinu metvice, rutvice i svake vrste povrća, a ne marite za Božju pravednost i ljubav. Treba davati desetinu, ali ne smijete zanemarivati važnije stvari. ");
INSERT INTO hrvbib_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Teško vama, farizeji! Volite sjediti na počasnome mjestu u sinagogama i godi vam kad vas ljudi pozdravljaju na javnim mjestima. ");
INSERT INTO hrvbib_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Teško vama! Vi ste poput neprimjetnih grobova po kojima ljudi hodaju ne opažajući trulež u njima.” ");
INSERT INTO hrvbib_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","“Učitelju, vrijeđaš nas govoreći tako!” reče neki zakonoznanac. ");
INSERT INTO hrvbib_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Isus mu odgovori: “Jao i vama, zakonoznanci! Tlačite ljude teškim teretom vjerskih zahtjeva, a ni prst ne želite pomaknuti da im taj teret pomognete nositi. ");
INSERT INTO hrvbib_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Teško vama! Gradite spomenike onim istim prorocima koje su poubijali vaši vlastiti preci. ");
INSERT INTO hrvbib_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Time svjedočite da odobravate djela svojih predaka: oni su ih pobili, a vi im dižete spomenike! ");
INSERT INTO hrvbib_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Evo što Božja mudrost kaže o vama: ‘Poslat ću k njima proroke i apostole, a oni će neke od njih ubiti, a druge protjerati.’ ");
INSERT INTO hrvbib_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Vaš će se naraštaj smatrati odgovornim za krv svih proroka prolivenu od postanka svijeta, ");
INSERT INTO hrvbib_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","od Abelove krvi do krvi Zaharije, koji je ubijen između žrtvenika i svetišta. Kažem vam, vaš će naraštaj odgovarati za tu prolivenu krv! ");
INSERT INTO hrvbib_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Teško vama, zakonoznanci! Skrili ste ključ znanja od naroda. Sami ne ulazite u kraljevstvo, a druge sprečavate da uđu.” ");
INSERT INTO hrvbib_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Kad je Isus odande otišao, pismoznanci i farizeji počnu gnjevno na njega navaljivati i postavljati mu kojekakva pitanja ");
INSERT INTO hrvbib_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","vrebajući hoće li reći što da ga mogu optužiti. ");
INSERT INTO hrvbib_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Kad se okupilo tisuće ljudi tako da su već gazili jedni po drugima, Isus najprije počne govoriti svojim učenicima: “Farizejsko se licemjerje širi poput kvasca koji prožme sve tijesto. Čuvajte se da ne budete licemjerni kao oni. ");
INSERT INTO hrvbib_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Jer dolazi vrijeme kad će sve što je skriveno biti otkriveno; sve što je tajno čut će se pred svima. ");
INSERT INTO hrvbib_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Što ste god rekli u tami, čut će se na svjetlu i što ste šaptali u zatvorenim sobama, razglasit će se s krovova da svi čuju! ");
INSERT INTO hrvbib_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Prijatelji moji, kažem vam, ne bojte se onih koji mogu ubiti samo tijelo, ali vam ne mogu ništa gore učiniti! ");
INSERT INTO hrvbib_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ali reći ću vam koga se treba bojati. Bojte se Boga koji može ubiti, a zatim baciti u pakao. Njega se bojte! ");
INSERT INTO hrvbib_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ne prodaje li se pet vrapčića za dva novčića? A Bog ipak ne zaboravi nijednoga od njih. ");
INSERT INTO hrvbib_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","A vama su izbrojene i vlasi na glavi. Stoga se ne bojte! Vi ste mu mnogo vredniji od mnoštva vrabaca. ");
INSERT INTO hrvbib_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Tko ovdje na zemlji pred ljudima prizna da pripada meni, za njega ću ja, Sin Čovječji, pred anđelima Božjim priznati da mu pripadam. ");
INSERT INTO hrvbib_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ali onoga koji mene zaniječe na zemlji odreći ću se pred Božjim anđelima. ");
INSERT INTO hrvbib_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ipak, onome koji što kaže protiv Sina Čovječjega oprostit će se. Ali onome tko pohuli protiv Svetoga Duha neće se oprostiti. ");
INSERT INTO hrvbib_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","A kad vas budu dovodili pred sud u sinagogama, pred poglavare i vlasti, ne brinite se što reći sebi u obranu ");
INSERT INTO hrvbib_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","jer će vas Sveti Duh tada poučiti što da kažete.” ");
INSERT INTO hrvbib_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Netko iz mnoštva poviče: “Učitelju, molim te, reci mojemu bratu da podijeli sa mnom imanje koje smo dobili u baštinu.” ");
INSERT INTO hrvbib_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Isus mu odgovori: “Čovječe, tko je mene postavio da sudim i dijelim između vas?” ");
INSERT INTO hrvbib_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Onda se obratio svima: “Klonite se svake pohlepe. Ma koliko da obilujete, život se ne sastoji u onomu što posjedujete.” ");
INSERT INTO hrvbib_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ispriča im zatim prispodobu: “Nekomu je bogatašu zemlja urodila tako obilnom žetvom ");
INSERT INTO hrvbib_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","da je razmišljao: ‘Što da radim? Nemam u što skupiti toliku ljetinu. ");
INSERT INTO hrvbib_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Znam! Srušit ću stare žitnice i izgraditi veće pa ću ondje zgrnuti i žito i sva svoja dobra. ");
INSERT INTO hrvbib_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Onda ću svojoj duši reći: Evo, imaš u zalihi obilje za još mnogo godina. Dušo moja, počivaj, jedi, pij i veseli se!’ ");
INSERT INTO hrvbib_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ali Bog mu reče: ‘Neumniče! Još ćeš noćas umrijeti. Komu će onda pripasti sve što si skupio?’ ");
INSERT INTO hrvbib_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Neumnik je onaj tko zgrće zemaljsko blago, a ne stječe bogatstvo koje je vrijedno u Božjim očima.” ");
INSERT INTO hrvbib_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Zatim Isus reče učenicima: “Zato vam kažem: Ne brinite se tjeskobno kako ćete preživjeti, što ćete jesti, ni u što ćete obući svoje tijelo! ");
INSERT INTO hrvbib_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Pa život je vredniji od hrane, a tijelo od odjeće. ");
INSERT INTO hrvbib_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Pogledajte gavrane! Niti siju, niti žanju, niti imaju spremišta i žitnice, a Bog ih ipak hrani. A vi ste toliko vredniji od ptica! ");
INSERT INTO hrvbib_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Može li tko od vas sebi brigama produžiti život barem i za jedan dan? ");
INSERT INTO hrvbib_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Pa ako ni to malo ne možete, zašto ste stalno zabrinuti? ");
INSERT INTO hrvbib_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Pogledajte samo poljske ljiljane! Niti se muče niti predu. A kažem vam da se ni kralj Salomon u svoj svojoj raskoši nije zaodjenuo kao jedan od njih. ");
INSERT INTO hrvbib_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Pa ako Bog tako odijeva poljsku travu koja danas jest, a već se sutra baca u peć, zar se neće još i više brinuti za vas, malovjerni? ");
INSERT INTO hrvbib_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Zato i vi: ne brinite se i ne uznemirujte oko toga što ćete jesti i piti ");
INSERT INTO hrvbib_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","jer tako čine nevjernici ovoga svijeta. Vaš Otac zna da vam je sve to potrebno. ");
INSERT INTO hrvbib_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Stoga najprije tražite kraljevstvo njegovo pa će vam se i to nadodati. ");
INSERT INTO hrvbib_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Ne boj se, malo stado. Vašemu se Ocu svidjelo da vam dade kraljevstvo. ");
INSERT INTO hrvbib_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Prodajte svoju imovinu i dajte je kao milostinju! Tako ćete sebi spremiti blago na nebesima, kamo lopovi ne dolaze i gdje ga moljci neće izgristi. ");
INSERT INTO hrvbib_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Jer gdje vam je blago, ondje će vam biti i srce.” ");
INSERT INTO hrvbib_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Budite pripravni, posve obučeni i neka vam svjetiljka gori ");
INSERT INTO hrvbib_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","kao da čekate povratak svojega gospodara sa svadbene gozbe da budete spremni otvoriti mu vrata čim stigne i pokuca. ");
INSERT INTO hrvbib_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Blago onim slugama koje gospodar na povratku nađe bdjeti. Zaista vam kažem, on će privezati pregaču, reći im da sjednu za stol i sam ih poslužiti da jedu. ");
INSERT INTO hrvbib_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Možda će doći usred noći ili pred zoru. Blago onima koje nađe bdjeti. ");
INSERT INTO hrvbib_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Znajte: kad bi vlasnik kuće znao kada će doći lopov, ne bi mu dopustio da u nju provali. ");
INSERT INTO hrvbib_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Budite i vi stalno pripravni jer će Sin Čovječji doći kad mu se i ne nadate.” ");
INSERT INTO hrvbib_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","“Gospodine, jesi li tu prispodobu ispričao samo nama ili svima?” upita Petar. ");
INSERT INTO hrvbib_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Isus mu reče: “Tko je dakle onaj vjerni i razumni upravitelj kojega će gospodar postaviti da upravlja ukućanima i da im daje hranu u pravo vrijeme? ");
INSERT INTO hrvbib_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Blago onome koga gospodar, kada dođe, nađe da tako čini! ");
INSERT INTO hrvbib_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Zaista vam kažem, povjerit će mu da upravlja svim njegovim imanjem. ");
INSERT INTO hrvbib_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ali ako sluga pomisli: ‘Gospodar se još neće vratiti’ pa počne tući sluge i sluškinje te jesti, piti i opijati se, ");
INSERT INTO hrvbib_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","gospodar će doći u dan kad mu se ne nada i u čas u koji neće ni slutiti. Nemilosrdno će ga kazniti i odrediti mu usud među nevjernicima. ");
INSERT INTO hrvbib_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Onaj koji je znao volju svojega gospodara, ali nije tako činio i nije bdio, bit će strogo kažnjen. ");
INSERT INTO hrvbib_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ali tko nije znao da to što čini zaslužuje kaznu, bit će kažnjen blaže. Kome je mnogo dano, od njega će se mnogo i tražiti. Od onoga kojemu je mnogo povjereno više će se tražiti.” ");
INSERT INTO hrvbib_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Došao sam baciti oganj suda na zemlju. Kako bih želio da je već planuo! ");
INSERT INTO hrvbib_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ali valja mi se krstiti trpljenjem i tako sam tjeskoban dok se to ne završi! ");
INSERT INTO hrvbib_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Mislite li da sam na zemlju došao donijeti mir? Nipošto. Došao sam donijeti razdor. ");
INSERT INTO hrvbib_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Jer odsad će nastajati razdori u obitelji: troje će ljudi biti na mojoj strani, a protiv drugih dvoje i obrnuto. ");
INSERT INTO hrvbib_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Otac će biti protiv sina i sin protiv oca, majka protiv kćeri i kći protiv majke, svekrva protiv snahe i snaha protiv svekrve.” ");
INSERT INTO hrvbib_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Reče zatim mnoštvu: “Kad opazite da se na zapadu gomilaju oblaci, znate reći: Kiša će! ");
INSERT INTO hrvbib_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","A kad zapuše južnjak, kažete: Bit će vruće! I bude vrućina. ");
INSERT INTO hrvbib_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Licemjeri! Izgled zemlje i neba znate protumačiti. Kako onda ne znate protumačiti znake vremena? ");
INSERT INTO hrvbib_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Zašto sami ne želite uvidjeti što je pravo? ");
INSERT INTO hrvbib_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Kad s protivnikom ideš na sud, pokušaj se s njim nagoditi da spor ne završi na sudu jer te sudac može osuditi i predati izvršitelju da te baci u tamnicu. ");
INSERT INTO hrvbib_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","A onda, kažem ti, nećeš odande izići dok ne isplatiš sve do posljednjeg novčića.” ");
INSERT INTO hrvbib_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Tada Isusa obavijeste da je Pilat dao smaknuti neke Galilejce dok su prinosili žrtve u jeruzalemskome Hramu. ");
INSERT INTO hrvbib_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","“Mislite li da su ti Galilejci koji su nastradali bili veći grešnici od ostalih Galilejaca? ");
INSERT INTO hrvbib_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nipošto! Kažem vam, i vi ćete tako izginuti ako se ne obratite! ");
INSERT INTO hrvbib_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ili onih osamnaest na koje se srušila kula u Siloamu i ubila ih, zar mislite da su oni bili grešniji od svih stanovnika Jeruzalema? ");
INSERT INTO hrvbib_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nipošto. Kažem vam, svi ćete tako izginuti ako se ne obratite.” ");
INSERT INTO hrvbib_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ispriča im zatim prispodobu: “Imao neki čovjek u vinogradu zasađenu smokvu. Dolazio je vidjeti je li rodila, ali nije na njoj našao roda. ");
INSERT INTO hrvbib_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Reče zato vinogradaru: ‘Već tri godine dolazim tražiti roda na ovoj smokvi, ali ga ne nalazim. Posijeci ju. Zašto da iscrpljuje zemlju!’ ");
INSERT INTO hrvbib_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Vinogradar odgovori: ‘Gospodaru, ostavi ju još ove godine, a ja ću ju okopati i pognojiti. ");
INSERT INTO hrvbib_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Možda će nagodinu ipak roditi. Ako ne, posjeći ćeš ju.’” ");
INSERT INTO hrvbib_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Dok je Isus u subotu poučavao u sinagogi, ");
INSERT INTO hrvbib_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","bila je ondje žena koja je osamnaest godina bila zgrbljena i nije se mogla uspraviti. Bila je, naime, opsjednuta duhom. ");
INSERT INTO hrvbib_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Kad ju Isus opazi, pozove ju i reče joj: “Ženo, oslobođena si od svoje bolesti!” ");
INSERT INTO hrvbib_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","te položi na nju ruke. Žena se smjesta uspravi i počne slaviti Boga. ");
INSERT INTO hrvbib_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ali nadstojnik sinagoge, srdit što ju je Isus izliječio u subotu, reče narodu: “Šest dana u tjednu treba raditi. U te se dane dakle dolazite liječiti, a ne subotom!” ");
INSERT INTO hrvbib_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Isus mu odgovori: “Licemjeri! I vi radite subotom. Ne odveže li subotom svatko od vas svojega vola ili magarca od jasala i ne odvede li ga na vodu piti? ");
INSERT INTO hrvbib_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Nije li onda trebalo, iako je subota, odriješiti ovu kćer Abrahamovu spona kojima ju je Sotona držao vezanu osamnaest godina?” ");
INSERT INTO hrvbib_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Nato se njegovi neprijatelji posrame, a sav narod radovao se čudesima koja je Isus učinio. ");
INSERT INTO hrvbib_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","“Kako da vam još opišem Božje kraljevstvo? S čime da ga usporedim?” reče Isus. ");
INSERT INTO hrvbib_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","“S njim je kao s gorušičinim sjemenom koje čovjek baci u svoj vrt. Ono izraste i razvije se u stablo te se ptice nebeske dolaze gnijezditi u njegovim granama.” ");
INSERT INTO hrvbib_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Upita opet: “Kako da vam još opišem Božje kraljevstvo? ");
INSERT INTO hrvbib_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ono je poput kvasca koji žena umijesi u golemu količinu brašna, a on ipak sve ukvasi.” ");
INSERT INTO hrvbib_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Putujući u Jeruzalem, Isus je prolazio gradovima i selima i putem poučavao. ");
INSERT INTO hrvbib_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Netko ga upita: “Gospodine, je li malo onih koji se spašavaju?” ");
INSERT INTO hrvbib_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Vrata neba su uska”, odgovori Isus. “Trudite se da uđete kroz njih jer će mnogi željeti ući, ali neće moći. ");
INSERT INTO hrvbib_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Kad gospodar kuće zaključa vrata, bit će prekasno. Tada ćete stajati vani i kucati ištući: ‘Gospodine, otvori nam!’ ali on će odgovoriti: ‘Ne znam vas odakle ste.’ ");
INSERT INTO hrvbib_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Onda ćete početi govoriti: ‘Ali mi smo s tobom jeli i pili, poučavao si po našim trgovima!’ ");
INSERT INTO hrvbib_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","A on će vam odgovoriti: ‘Kažem vam da vas ne poznajem. Odlazite od mene, svi zlotvori!’ ");
INSERT INTO hrvbib_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Bit će velikog plača i škrguta zubi kad ugledate Abrahama, Izaka i Jakova i sve proroke u kraljevstvu Božjemu, a vi ćete biti izbačeni. ");
INSERT INTO hrvbib_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Tada će ljudi odasvud, s istoka i zapada, sa sjevera i juga, doći sjesti u Božjemu kraljevstvu. ");
INSERT INTO hrvbib_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Oni koji su sada prvi tada će biti na zadnjemu mjestu, a oni koje ovdje smatraju zadnjima ondje će biti najveći.” ");
INSERT INTO hrvbib_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Odmah zatim neki mu farizeji dođu reći: “Otiđi odavde jer te Herod hoće ubiti!” ");
INSERT INTO hrvbib_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","On im reče: “Idite i recite toj lisici da ću ja izgoniti zloduhe i iscjeljivati danas i sutra, a trećega ću dana završiti što imam. ");
INSERT INTO hrvbib_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Danas, sutra i prekosutra valja mi nastaviti put jer ne priliči da prorok bude ubijen izvan Jeruzalema. ");
INSERT INTO hrvbib_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Jeruzaleme, Jeruzaleme, koji ubijaš proroke i kamenuješ Božje poslanike! Koliko sam puta htio okupiti tvoju djecu kao što kvočka skuplja piliće pod krila, ali niste htjeli! ");
INSERT INTO hrvbib_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","A sada će ti, eto, kuća biti napuštena. I kažem vam, nećete me više vidjeti sve dok ne uzviknete: ‘Blagoslovljen koji dolazi u ime Gospodnje!’” ");
INSERT INTO hrvbib_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Jedne je subote Isus bio na objedu pri nekome farizejskom vođi. Budno su pratili što će učiniti ");
INSERT INTO hrvbib_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","jer je ondje bio čovjek koji je imao vodenu bolest. ");
INSERT INTO hrvbib_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","“Je li prema Zakonu dopušteno liječiti ljude subotom ili nije?” upita Isus zakonoznance i farizeje. ");
INSERT INTO hrvbib_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Šutjeli su. On dotakne bolesnog čovjeka, iscijeli ga i reče mu da može ići. ");
INSERT INTO hrvbib_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","A njima reče: “Tko od vas subotom ne radi? Ako vam sin ili vol padne u zdenac, nećete li ga smjesta izvaditi?” ");
INSERT INTO hrvbib_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Nisu na to imali što odgovoriti. ");
INSERT INTO hrvbib_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Opazivši da uzvanici biraju mjesta bliže pročelju stola, reče im: ");
INSERT INTO hrvbib_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Kad te pozovu na svadbu, ne zauzimaj odmah počasno mjesto za stolom. Što ako je pozvan tko ugledniji od tebe? ");
INSERT INTO hrvbib_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Domaćin će ti tada reći: ‘Ustupi mjesto ovome uzvaniku!’ Tada ćeš, postiđen, morati zauzeti bilo kakvo preostalo mjesto u dnu stola. ");
INSERT INTO hrvbib_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Nego kad te tko pozove, zauzmi posljednje mjesto za stolom. Kada te domaćin vidi, prići će ti i reći: ‘Prijatelju, pripremili smo ti bolje mjesto.’ Tako ćeš biti počašćen pred svim uzvanicima. ");
INSERT INTO hrvbib_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Tko sebe uzvisuje, bit će ponižen, a ponizni će biti uzvišeni.” ");
INSERT INTO hrvbib_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Zatim se okrene domaćinu i reče mu: “Kad priređuješ objed ili večeru, ne pozivaj svoje prijatelje, braću, rodbinu ni bogate susjede. Jer oni će ti se odužiti uzvraćajući poziv. ");
INSERT INTO hrvbib_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Nego pozovi siromahe, bogalje, hrome i slijepe. ");
INSERT INTO hrvbib_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Oni ti nemaju čime uzvratiti. Tako ćeš biti blagoslovljen jer će Bog te za to nagraditi o uskrsnuću pravednika.” ");
INSERT INTO hrvbib_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Kad je to čuo jedan od ljudi za stolom, uzvikne: “Blago onome koji bude blagovao u kraljevstvu Božjemu!” ");
INSERT INTO hrvbib_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Isus mu odgovori prispodobom: “Neki je čovjek priredio veliku gozbu i pozvao mnogo ljudi. ");
INSERT INTO hrvbib_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Kad je večera bila spremna, pošalje slugu da uzvanicima poruči: ‘Sve je spremno. Dođite!’ ");
INSERT INTO hrvbib_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ali svi se oni počnu izgovarati. Jedan reče: ‘Kupio sam neku njivu pa ju moram otići pogledati. Molim te, ispričaj me.’ ");
INSERT INTO hrvbib_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Drugi reče: ‘Kupio sam upravo pet jarmova volova pa ih moram iskušati. Molim te, ispričaj me.’ ");
INSERT INTO hrvbib_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Treći reče: ‘Upravo sam se oženio pa ne mogu doći.’ ");
INSERT INTO hrvbib_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Sluga se vrati i ispriča gospodaru što su mu rekli. Domaćin se nato razgnjevi pa reče sluzi: ‘Idi na gradske ulice i trgove pa dovedi prosjake, bogalje, hrome i slijepce.’ ");
INSERT INTO hrvbib_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Kad je tako učinio, sluga javi: ‘Gospodaru, doveo sam ih, ali ima još mjesta.’ ");
INSERT INTO hrvbib_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","‘Kreni tražiti po puteljcima i iza ograda te ih natjeraj da dođu da mi se napuni kuća’, reče mu gospodar, ");
INSERT INTO hrvbib_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","‘jer vam kažem da nijedan od onih prvih koje sam pozvao neće okusiti ni zalogaja od onoga što sam za njih pripravio.’” ");
INSERT INTO hrvbib_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","S Isusom je putovalo silno mnoštvo. Isus se okrenuo i rekao im: ");
INSERT INTO hrvbib_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Želite li biti mojim sljedbenicima, morate me voljeti više nego svojega oca i majku, ženu i djecu, braću i sestre, više nego vlastiti život. Inače ne možete biti mojim učenicima. ");
INSERT INTO hrvbib_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Tko ne uzme svoj križ i ne pođe za mnom, ne može biti mojim učenikom. ");
INSERT INTO hrvbib_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ali ne krećite dok niste utvrdili cijenu. Jer nitko od vas ne bi počeo graditi kulu a da prije toga ne sjedne i ne izračuna troškove da vidi hoće li ju imati čime dovršiti. ");
INSERT INTO hrvbib_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Inače bi mu se moglo dogoditi da uspije izgraditi samo temelj, a onda bi mu se svi koji to vide podsmjehivali: ");
INSERT INTO hrvbib_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Ovaj je počeo graditi, a ne može dovršiti!’ ");
INSERT INTO hrvbib_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ili koji bi kralj krenuo ratovati s drugim kraljem a da najprije ne sjedne i ne promisli može li sa svojih deset tisuća vojnika presresti i svladati onoga koji na njega dolazi s dvadeset tisuća? ");
INSERT INTO hrvbib_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ako ne može, poslat će izaslanstvo da zaište mir dok je neprijatelj još daleko. ");
INSERT INTO hrvbib_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Zato nitko ne može postati mojim učenikom a da se prije toga zbog mene nije svega odrekao. ");
INSERT INTO hrvbib_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Sol je dobra. Ali ako ona obljutavi, čime će se ona zasoliti? ");
INSERT INTO hrvbib_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Bljutava sol nije dobra ni za tlo, ni za gnojište, nego se baca. Slušajte, kad već imate uši!” ");
INSERT INTO hrvbib_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Oko Isusa su se okupljali svi ubirači poreza i ostali zloglasni grešnici da ga slušaju dok poučava. ");
INSERT INTO hrvbib_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Zato su farizeji i pismoznanci prigovarali: “Druži se s grešnicima i još s njima jede!” ");
INSERT INTO hrvbib_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Isus im stoga ispriča prispodobu: ");
INSERT INTO hrvbib_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Tko od vas ne bi, da ima sto ovaca i da se jedna od njih izgubi u pustinji, otišao tražiti tu jednu dok ju ne nađe? ");
INSERT INTO hrvbib_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","A onda bi ju, sav sretan, na ramenima odnio doma ");
INSERT INTO hrvbib_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","te pozvao prijatelje i susjede da im kaže: ‘Radujte se sa mnom! Našao sam izgubljenu ovcu!’ ");
INSERT INTO hrvbib_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Kažem vam da će na nebu također biti veća radost zbog jednoga jedinoga grešnika koji se obrati Bogu nego zbog devedeset devet pravednika kojima obraćenje ne treba.” ");
INSERT INTO hrvbib_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Koja to žena, da ima deset srebrnih novčića i jedan izgubi, ne bi upalila svjetlo, pomela kuću i pomnjivo ju pretražila da ga pronađe? ");
INSERT INTO hrvbib_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","A kad ga nađe, pozvala bi prijateljice i susjede i rekla: ‘Radujte se sa mnom! Našla sam izgubljeni novac!’ ");
INSERT INTO hrvbib_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Kažem vam da silnu radost u nebu gledaju i anđeli Božji zbog samo jednoga jedinoga grešnika koji se obrati Bogu.” ");
INSERT INTO hrvbib_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Isus nastavi: “Neki je čovjek imao dvojicu sinova. ");
INSERT INTO hrvbib_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Mlađi mu reče: ‘Oče, daj mi sada dio baštine koji mi pripada.’ I otac podijeli imanje. ");
INSERT INTO hrvbib_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Nakon nekoliko dana mlađi sin pokupi sve, otputuje u daleku zemlju i ondje potroši sav novac živeći raspušteno. ");
INSERT INTO hrvbib_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Kad je potratio sav novac, u toj zemlji zavlada velika glad te on počne oskudijevati. ");
INSERT INTO hrvbib_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Zaposli se kao najamnik pri nekom seljaku te mu je pasao svinje. ");
INSERT INTO hrvbib_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Mladić je bio tako gladan da bi rado jeo i ljuske od mahuna što su ih jele svinje, ali nitko mu ih nije davao. ");
INSERT INTO hrvbib_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Kad je napokon došao k sebi, reče: ‘Pri mojemu ocu i najamnici imaju hrane napretek, a ja ovdje umirem od gladi! ");
INSERT INTO hrvbib_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Idem doma, ocu, i reći ću mu: “Oče, zgriješio sam i tebi i Bogu. ");
INSERT INTO hrvbib_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Nisam više dostojan zvati se tvojim sinom. Molim te, primi me da radim pri tebi kao najamnik.”’ ");
INSERT INTO hrvbib_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","I vrati se doma ocu. Dok je još bio daleko, otac ga ugleda pa ganut potrči pred njega, zagrli ga i izljubi. ");
INSERT INTO hrvbib_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","‘Oče! Zgriješio sam i tebi i Bogu! Nisam više dostojan zvati se tvojim sinom’, reče sin. ");
INSERT INTO hrvbib_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ali otac reče slugama: ‘Brzo donesite haljinu, onu najljepšu, i obucite ga! Stavite mu prsten na ruku, obujte mu sandale! ");
INSERT INTO hrvbib_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","I zakoljite ono ugojeno tele da se pogostimo i proslavimo ");
INSERT INTO hrvbib_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","što mi je sin bio mrtav, a sada je živ, bio je izgubljen, a sada je nađen!’ I započne veselje. ");
INSERT INTO hrvbib_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Stariji je sin radio u polju. Kad se na povratku približio kući, začuje da se unutra svira i pleše. ");
INSERT INTO hrvbib_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Dozove nekog slugu da ga upita što se događa. ");
INSERT INTO hrvbib_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","‘Vratio ti se brat, pa je otac zaklao ugojeno tele da proslavi što mu se sin vratio živ i zdrav.’ ");
INSERT INTO hrvbib_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Stariji se brat nato rasrdi i nije htio ući. Otac ga iziđe moliti da uđe. ");
INSERT INTO hrvbib_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","‘Ja ti tolike godine služim i nikada nisam odbio učiniti što mi kažeš, ali meni nikad nisi ni jare dao da se proveselim s prijateljima. ");
INSERT INTO hrvbib_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ali tvoj je sin s bludnicama potratio imanje, a ti mu zakolješ najbolje ugojeno tele!’ reče mu sin. ");
INSERT INTO hrvbib_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","‘Sinko,’ reče otac, ‘pa ti si stalno sa mnom. Sve što imam pripada tebi. ");
INSERT INTO hrvbib_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ali trebalo je proslaviti i radovati se jer tvoj je brat bio mrtav, a sada je živ, bio je izgubljen, a sada je nađen.’” ");
INSERT INTO hrvbib_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Isus ispriča učenicima ovu pripovijest: “Imao neki bogataš upravitelja kojega su optužili da mu rasipa imanje. ");
INSERT INTO hrvbib_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Bogataš ga pozove i reče mu: ‘Što to čujem o tebi? Položi račun o svojem upravljanju jer više ne možeš biti upraviteljem.’ ");
INSERT INTO hrvbib_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Upravitelj nato pomisli: ‘Što da radim kad me gospodar otpusti? Da kopam? Nisam dovoljno snažan za to. Da prosjačim? Sramio bih se toga. ");
INSERT INTO hrvbib_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Znam što ću! Kad tako učinim, bit ću dobrodošao u domovima ljudi kad me otpusti.’ ");
INSERT INTO hrvbib_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Pozove zatim jednoga po jednoga gospodarova dužnika. Prvoga upita: ‘Koliko duguješ mojemu gospodaru?’ ‘Sto bata ulja’, odgovori on. ");
INSERT INTO hrvbib_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","‘Uzmi brzo zadužnicu pa ispravi na pedeset’, reče upravitelj. ");
INSERT INTO hrvbib_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","I drugoga upita: ‘Koliko duguješ?’ ‘Sto kora pšenice’, odgovori. ‘Uzmi svoju zadužnicu pa ispravi na osamdeset’, reče mu upravitelj. ");
INSERT INTO hrvbib_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","I gospodar se morao diviti dovitljivosti nepoštenoga upravitelja. Ljudi ovoga svijeta snalažljiviji su u postupanju prema sebi sličnima nego narod svjetlosti. ");
INSERT INTO hrvbib_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Kažem vam: uporabite ovozemaljsko bogatstvo za stjecanje prijatelja pa ćete biti, kad ga ponestane, bit ćete primljeni u vječne stanove. ");
INSERT INTO hrvbib_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Tko je vjeran u sitnicama, bit će vjeran i u najvećemu, a tko je nepošten u sitnicama, bit će nepošten i u najvećemu. ");
INSERT INTO hrvbib_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ako dakle niste vjerni u ovozemaljskom bogatstvu, tko će vam povjeriti istinsko nebesko bogatstvo? ");
INSERT INTO hrvbib_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ako niste bili vjerni u postupanju s tuđim, tko će vam dati vaše vlastito? ");
INSERT INTO hrvbib_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Nijedan sluga ne može služiti dvojici gospodara. Ili će jednoga mrziti, a drugoga voljeti ili će jednome biti odan, a drugoga prezirati. Ne možete služiti i Bogu i bogatstvu.” ");
INSERT INTO hrvbib_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Farizeji, koji su voljeli novac, sve su to slušali i rugali se. ");
INSERT INTO hrvbib_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Isus im reče: “Vi se pred ljudima pretvarate da ste pravedni, ali Bog poznaje vaša srca. Jer što ljudi uzvisuju, Bogu je gnusno. ");
INSERT INTO hrvbib_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Zakon i Proroci važili su do dolaska Ivana Krstitelja, a od tada se navješćuje Božje kraljevstvo i navala je na njega. ");
INSERT INTO hrvbib_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ali to ne znači da Zakon više ne vrijedi jer će lakše propasti nebo i zemlja nego ijedan potez pera u Zakonu. ");
INSERT INTO hrvbib_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Tko god se razvede od žene pa se oženi drugom, čini preljub. I tko se oženi razvedenom ženom, čini preljub. ");
INSERT INTO hrvbib_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Bio je neki bogataš koji se odijevao u najfinije tkanine, u grimiz i tanki lan, i svakoga se dana obilno gostio. ");
INSERT INTO hrvbib_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Pred njegovim je vratima sav u čirovima ležao siromah Lazar ");
INSERT INTO hrvbib_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","čeznući da se najede ostataka s bogataševa stola. Dok je tako ležao, psi su dolazili i lizali mu čirove. ");
INSERT INTO hrvbib_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Siromah napokon umre te ga anđeli odnesu k Abrahamu. Umre zatim i bogataš te ga pokopaju, ");
INSERT INTO hrvbib_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","a duša mu ode u pakao. Dok je bio u teškim mukama, ugleda u daljini Lazara s Abrahamom. ");
INSERT INTO hrvbib_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","‘Oče Abrahame!’ zavapi on, ‘smiluj mi se pa pošalji Lazara da umoči vršak prsta u vodu i da mi rashladi jezik jer se strašno mučim u ovome plamenu!’ ");
INSERT INTO hrvbib_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","‘Sinko moj,’ odgovori mu Abraham, ‘sjeti se da si ti za života primio svoja dobra, a Lazar zla. Sada se on ovdje tješi, a ti se mučiš. ");
INSERT INTO hrvbib_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Osim toga, između nas je golemi bezdan, tako da oni koji bi odavde htjeli prijeći k vama ne mogu to učiniti, a ni s vaše strane nema prijelaza ovamo.’ ");
INSERT INTO hrvbib_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Bogataš nato reče: ‘Molim te, oče Abrahame, pošalji onda Lazara u dom mojega oca. ");
INSERT INTO hrvbib_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Imam petoricu braće. Neka ih opomene da i oni ne dospiju u ovo mjesto muka.’ ");
INSERT INTO hrvbib_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ali Abraham reče: ‘Opominju ih Mojsije i proroci u svojim zapisima. Neka njih čitaju i poslušaju ih.’ ");
INSERT INTO hrvbib_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","‘Neće, oče Abrahame! Ali ako im dođe tko od mrtvih, obratit će se od grijeha’, reče bogataš. ");
INSERT INTO hrvbib_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ali Abraham reče: ‘Ako ne slušaju Mojsija i proroke, neće poslušati čak ni ako tko ustane od mrtvih.’” ");
INSERT INTO hrvbib_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Isus reče učenicima: “Napast na zlo je neizbježna, ali teško čovjeku kroz kojega dolazi napast. ");
INSERT INTO hrvbib_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Takvome bi bilo bolje da se strovali u more s mlinskim kamenom oko vrata nego da navede na grijeh jednoga od ovih malenih. ");
INSERT INTO hrvbib_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Upozoravam vas! Ako ti brat vjernik zgriješi, ukori ga pa mu oprosti ako se pokaje. ");
INSERT INTO hrvbib_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Pa ako se i sedam puta na dan ogriješi o tebe i sedam puta ti kaže: ‘Žao mi je’, oprosti mu!” ");
INSERT INTO hrvbib_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","“Treba nam više vjere”, kazaše apostoli Gospodinu. “Reci nam kako da je dobijemo.” ");
INSERT INTO hrvbib_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","“Da imate vjere kao je gorušičino zrno, rekli biste ovoj murvi: ‘Iščupaj se s korijenom i presadi se u more!’ i poslušala bi vas. ");
INSERT INTO hrvbib_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Kad sluga uđe u kuću pošto je orao ili čuvao ovce, neće odmah sjesti i jesti. ");
INSERT INTO hrvbib_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Najprije mora pripraviti jelo gospodaru i poslužiti mu večeru pa tek onda može i sam jesti. ");
INSERT INTO hrvbib_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Sluzi za to i ne zahvale jer samo radi svoj posao. ");
INSERT INTO hrvbib_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Tako i vi kad ste poslušni Bogu recite: ‘Nismo vrijedni hvale. Samo smo sluge koji obavljaju svoju dužnost.’” ");
INSERT INTO hrvbib_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Putujući dalje prema Jeruzalemu, Isus je išao granicom između Samarije i Galileje. ");
INSERT INTO hrvbib_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Dok je ulazio u neko selo, dođu mu u susret desetorica gubavaca. Zaustave se podalje ");
INSERT INTO hrvbib_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","i počnu vikati: “Isuse, Učitelju, smiluj nam se!” ");
INSERT INTO hrvbib_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Kad ih opazi, Isus im reče: “Idite i pokažite se svećenicima!” Oni krenu i putem ozdrave od gube. ");
INSERT INTO hrvbib_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Videći da je ozdravio, jedan od njih vrati se slaveći Boga na sav glas. ");
INSERT INTO hrvbib_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Padne ničice na zemlju, Isusu pred noge, zahvaljujući mu. Bio je to neki Samarijanac. ");
INSERT INTO hrvbib_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Isus upita: “Zar nisu desetorica ozdravila? Gdje su ona devetorica? ");
INSERT INTO hrvbib_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Zar se nijedan od njih nije vratio da dade slavu Bogu osim ovoga tuđinca?” ");
INSERT INTO hrvbib_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Čovjeku zatim reče: “Ustani i idi. Tvoja te je vjera spasila.” ");
INSERT INTO hrvbib_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Farizeji upitaju Isusa: “Kada će doći Božje kraljevstvo?” “Ono ne dolazi tako da se može vidjeti. ");
INSERT INTO hrvbib_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Neće se moći kazati: ‘Evo ga, ovdje je!’ ili ‘Ondje je!’ Božje kraljevstvo je među vama.” ");
INSERT INTO hrvbib_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Poslije je opet o tome razgovarao s učenicima. “Dolazi vrijeme kada ćete zaželjeti vidjeti Sina Čovječjega barem na jedan dan, ali nećete moći. ");
INSERT INTO hrvbib_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Tada će vam govoriti: ‘Eno ga ondje!’ i ‘Evo, ovdje je!’ ali ne idite i nikamo ne jurite tražeći me. ");
INSERT INTO hrvbib_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Jer dolazak Sina Čovječjega u njegov dan vidjet će se poput munje koja sijevne na jednom kraju obzora, a odbljesne na drugome. ");
INSERT INTO hrvbib_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ali najprije moram mnogo pretrpjeti i ovaj me naraštaj mora odbaciti. ");
INSERT INTO hrvbib_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Za dolaska Sina Čovječjega bit će kao i u Noino doba. ");
INSERT INTO hrvbib_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ljudi su jeli i pili, ženili se i udavali sve do dana kada je Noa ušao u korablju. A tada je došao potop i sve ih uništio. ");
INSERT INTO hrvbib_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Bit će slično kao i u Lotovo doba: jeli su i pili, kupovali i prodavali, obrađivali zemlju i gradili ");
INSERT INTO hrvbib_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","sve do jutra kada je Lot otišao iz Sodome. A tada su s neba zapljuštali oganj i sumpor i sve ih uništili. ");
INSERT INTO hrvbib_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Jednako tako ljudi neće ništa slutiti do dana kad će se pojaviti Sin Čovječji. ");
INSERT INTO hrvbib_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Tko se toga dana nađe na krovu, a stvari su mu unutra, neka ne silazi u kuću što uzeti! Tko se zatekne u polju, neka se ne vraća prema gradu! ");
INSERT INTO hrvbib_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Sjetite se Lotove žene! ");
INSERT INTO hrvbib_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Tko bude nastojao sačuvati svoj život, izgubit će ga, a tko ga izgubi, sačuvat će ga. ");
INSERT INTO hrvbib_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Kažem vam, od dvoje ljudi koji te noći budu spavali u istoj postelji jedan će se uzeti, a drugi ostaviti. ");
INSERT INTO hrvbib_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Od dviju žena koje budu skupa mljele u mlinu jedna će se uzeti, a druga ostaviti. ");
INSERT INTO hrvbib_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Dvojica će biti u polju; jedan će biti uzet, drugi će ostati.” ");
INSERT INTO hrvbib_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","“A gdje to, Gospodine?” upitaju učenici. Isus odgovori poslovicom: “Gdje bude strvine, skupljat će se strvinari.” ");
INSERT INTO hrvbib_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Isus ispriča učenicima prispodobu da ih pouči kako se uvijek treba moliti i nikada odustajati: ");
INSERT INTO hrvbib_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Bio je u nekome gradu sudac. Niti se bojao Boga niti je mario što misle ljudi. ");
INSERT INTO hrvbib_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","A u tomu je gradu bila i neka udovica koja je stalno dolazila k njemu i molila ga: ‘Obrani me od mojega tužitelja!’ ");
INSERT INTO hrvbib_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Sudac dugo nije mario za to, ali napokon reče: ‘Iako se ne bojim Boga i ne marim za ljude, ");
INSERT INTO hrvbib_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","obranit ću tu udovicu jer mi stalno dodijava, da me ne dolazi vječno gnjaviti!’ ");
INSERT INTO hrvbib_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Čujte što govori nepravedni sudac!” reče Gospodin. ");
INSERT INTO hrvbib_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","“Neće li Bog onda obraniti svoje izabranike koji danonoćno vape k njemu? Hoće li odgađati da im pomogne? ");
INSERT INTO hrvbib_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Kažem vam, žurno će im stati u obranu. Ali kad se ja, Sin Čovječji, vratim, hoću li naći vjere na zemlji?” ");
INSERT INTO hrvbib_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ispriča zatim prispodobu nekima koji su bili uvjereni u svoju pravednost, a druge su prezirali: ");
INSERT INTO hrvbib_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Dva su se čovjeka došla u Hram pomoliti. Jedan je bio farizej, a drugi grešni ubirač poreza. ");
INSERT INTO hrvbib_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ponosni se farizej u sebi molio: ‘Bože, hvala ti što nisam kao ostali ljudi: grabežljiv, nepravedan, preljubnik ili kao ovaj ubirač poreza. ");
INSERT INTO hrvbib_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Dvaput u tjednu postim i dajem desetinu svojeg prihoda.’ ");
INSERT INTO hrvbib_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","A ubirač poreza ostao je daleko i nije se usudio čak ni pogledati u nebo dok je molio. Udarao se u prsa i govorio: ‘Bože, smiluj se meni grešniku!’ ");
INSERT INTO hrvbib_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Kažem vam: on je otišao doma opravdan pred Bogom, a ne farizej! Jer tko sebe uzvisuje, bit će ponižen, a ponizni će biti uzvišeni.” ");
INSERT INTO hrvbib_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Isusu su dovodili i vrlo malu djecu da ih dotakne i blagoslovi. Kad su to opazili, učenici su im to priječili. ");
INSERT INTO hrvbib_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ali Isus ih dozove i reče: “Pustite dječicu k meni i ne tjerajte ih jer takvima pripada Božje kraljevstvo! ");
INSERT INTO hrvbib_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Zaista vam kažem, tko ne prihvati kraljevstvo Božje poput te dječice, nikada neće u njega ući!” ");
INSERT INTO hrvbib_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Neki uglednik upita Isusa: “Dobri učitelju, što moram učiniti da dobijem vječni život?” ");
INSERT INTO hrvbib_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","“Zašto me zoveš dobrim?” upita ga Isus. “Dobar je samo Bog. ");
INSERT INTO hrvbib_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","A zapovijedi znaš: ‘Ne čini preljub’, ‘Ne ubij’, ‘Ne ukradi’, ‘Ne svjedoči lažno’, ‘Poštuj oca i majku!’” ");
INSERT INTO hrvbib_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","“Svih tih zapovijedi držim se još od mladosti”, odgovori čovjek. ");
INSERT INTO hrvbib_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","“Još ti jedno nedostaje”, reče mu nato Isus. “Idi i prodaj sve što imaš, a novac razdijeli siromasima pa ćeš imati blago na nebu. A onda dođi i slijedi me!” ");
INSERT INTO hrvbib_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Kad je to čuo, čovjek se ražalosti jer je bio vrlo bogat. ");
INSERT INTO hrvbib_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Videći to, Isus reče: “Kako je teško bogatašima ući u kraljevstvo Božje! ");
INSERT INTO hrvbib_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Lakše bi devi bilo provući se kroz iglenu ušicu nego bogatašu ući u Božje kraljevstvo!” ");
INSERT INTO hrvbib_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Koji su to čuli, pitali su: “Pa tko se onda uopće može spasiti?” ");
INSERT INTO hrvbib_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","“Što je nemoguće ljudima, moguće je Bogu!”, odgovori im Isus. ");
INSERT INTO hrvbib_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Petar reče: “Evo, mi smo sve svoje ostavili da te slijedimo.” ");
INSERT INTO hrvbib_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","“Zaista vam kažem, nema toga tko je ostavio kuću, ili ženu, ili braću, ili roditelje, ili djecu zaradi Božjega kraljevstva ");
INSERT INTO hrvbib_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","a da neće već na ovome svijetu primiti mnogo više, a u budućemu svijetu i vječni život.” ");
INSERT INTO hrvbib_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Isus okupi Dvanaestoricu i reče im: “Evo, ulazimo u Jeruzalem. Ondje će se na Sinu Čovječjemu ispuniti sve što su napisali proroci. ");
INSERT INTO hrvbib_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Predat će ga poganima, izrugivat će mu se, zlostavljati ga i popljuvati. ");
INSERT INTO hrvbib_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Izbičevat će ga i ubiti, ali on će treći dan uskrsnuti.” ");
INSERT INTO hrvbib_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ali oni nisu ništa od toga razumjeli. Značenje tih riječi bilo im skriveno pa nisu mogli razumjeti o čemu govori. ");
INSERT INTO hrvbib_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Kad se Isus približio Jerihonu, pokraj puta sjedio neki slijepac i prosio. ");
INSERT INTO hrvbib_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Čuo je žamor mnoštva koje je prolazilo pa se raspitao što je to. ");
INSERT INTO hrvbib_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","“Prolazi Isus Nazarećanin”, kazaše mu. ");
INSERT INTO hrvbib_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","On nato poviče: “Isuse, Sine Davidov, smiluj mi se!” ");
INSERT INTO hrvbib_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ljudi iz mnoštva koje je išlo pred Isusom ušutkivali su ga, ali on je samo još jače vikao: “Sine Davidov, smiluj mi se!” ");
INSERT INTO hrvbib_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Kad ga Isus začuje, zaustavi se i zapovjedi da ga dovedu. Kad se približio, upita ga: ");
INSERT INTO hrvbib_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Što želiš da ti učinim?” “Da progledam, Gospodine!” zamoli on. ");
INSERT INTO hrvbib_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","A Isus mu reče: “Progledaj! Tvoja te je vjera iscijelila.” ");
INSERT INTO hrvbib_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Slijepac smjesta progleda i krene cestom za Isusom slaveći Boga. I sav narod koji je to vidio zahvali Bogu. ");
INSERT INTO hrvbib_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Isus uđe u Jerihon. Dok je prolazio gradom, ");
INSERT INTO hrvbib_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","dođe čovjek imenom Zakej, utjecajan Židov koji je radio za rimsku poreznu upravu i vrlo se obogatio. ");
INSERT INTO hrvbib_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Želio je vidjeti Isusa, ali je bio prenizak rastom da bi ga mogao vidjeti preko mnoštva. ");
INSERT INTO hrvbib_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","On zato potrči naprijed te se popne na smokvu pokraj koje je Isus trebao proći da s nje promatra. ");
INSERT INTO hrvbib_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Kad je Isus stigao do njega, pogleda gore i reče mu: “Zakeju, brzo siđi! Danas moram k tebi u goste.” ");
INSERT INTO hrvbib_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zakej žurno siđe s drveta i primi ga u goste sav radostan. ");
INSERT INTO hrvbib_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ali mnoštvo koje je to promatralo počne prigovarati: “Otišao je takvom grešniku u goste!” ");
INSERT INTO hrvbib_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","A Zakej ustane i reče Gospodinu: “Gospodine, polovicu svojega imanja dat ću siromasima, a svakome koga sam prevario četverostruko ću vratiti.” ");
INSERT INTO hrvbib_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","“Danas je u ovu kuću došlo spasenje jer je i ovaj čovjek Abrahamov sin! ");
INSERT INTO hrvbib_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ja, Sin Čovječji, došao sam tražiti i spasiti izgubljene.” ");
INSERT INTO hrvbib_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Mnoštvo je sve to slušalo. Kako je već bio nadomak Jeruzalemu, mislili su da će se kraljevstvo Božje odmah pojaviti. Isus im zato ispriča prispodobu: ");
INSERT INTO hrvbib_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","“Neki je ugledan čovjek trebao otputovati u daleku zemlju da ga ondje okrune za kralja, a zatim se vratiti. ");
INSERT INTO hrvbib_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Pozove zato desetoricu svojih slugu, dade svakomu pola kilograma srebra te im reče: ‘Trgujte s njime dok ne dođem.’ ");
INSERT INTO hrvbib_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ali njegovi su ga građani mrzili i poslali su za njim poslanike s porukom: ‘Ne želimo da on kraljuje nad nama.’ ");
INSERT INTO hrvbib_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Kad se vratio kao kralj, zapovjedi da mu pozovu sluge kojima je dao novac. Htio je znati koliko je koji zaradio. ");
INSERT INTO hrvbib_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Prvi sluga dođe i reče: ‘Gospodaru, udeseterostručio sam iznos koji si mi dao.’ ");
INSERT INTO hrvbib_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","‘Odlično! Dobar si sluga’, reče mu on. ‘Zato što si bio vjeran u najmanjemu, dajem ti da vladaš nad deset gradova.’ ");
INSERT INTO hrvbib_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Drugi sluga dođe i reče: ‘Upeterostručio sam iznos, gospodaru.’ ");
INSERT INTO hrvbib_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","‘Dobro! Vladaj nad pet gradova’, reče i njemu. ");
INSERT INTO hrvbib_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ali treći sluga dođe bez zarade i reče: ‘Gospodaru, evo ti srebra. Držao sam ga skrivenoga u rupcu. ");
INSERT INTO hrvbib_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Bojao sam te se zato što si strog čovjek. Uzimaš što nije tvoje i žanješ što nisi posijao.’ ");
INSERT INTO hrvbib_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","‘Zli slugo!’ odgovori mu on. ‘Sudit ću ti prema tvojim vlastitim riječima. Znao si da sam strog, da uzimam što nije moje i da žanjem što nisam posijao? ");
INSERT INTO hrvbib_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Zašto onda nisi moj novac uložio u banku? Tako bih barem dobio kamate.’ ");
INSERT INTO hrvbib_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Zatim kralj reče: ‘Oduzmite mu to srebro i dajte ga onome koji ima deset!’ ");
INSERT INTO hrvbib_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","‘Ali, gospodaru, pa on već ima pet kilograma srebra!’ kazali su. ");
INSERT INTO hrvbib_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","‘Velim vam,’ odgovori im kralj, ‘onome tko ima dat će se još, a onome tko nema oduzet će se i ono što ima. ");
INSERT INTO hrvbib_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","A moje neprijatelje, koji me nisu htjeli za kralja, dovedite ovamo i smaknite ih preda mnom.’” ");
INSERT INTO hrvbib_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Pošto im je to ispričao, Isus krene dalje prema Jeruzalemu. ");
INSERT INTO hrvbib_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Kad se približio mjestima Betfagi i Betaniji na Maslinskoj gori, pošalje naprijed dvojicu učenika. ");
INSERT INTO hrvbib_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Idite u ono selo pred vama”, reče im, “i čim uđete, vidjet ćete privezano magare koje još nitko nije jahao. Odvežite ga i dovedite ovamo. ");
INSERT INTO hrvbib_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Upita li vas tko: ‘Što to radite?’ recite samo: ‘Treba Gospodinu.’” ");
INSERT INTO hrvbib_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Oni odu i nađu magare kako im je rekao. ");
INSERT INTO hrvbib_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Dok su ga odvezivali, neki ih ljudi upitaju: “Zašto odvezujete magare?” ");
INSERT INTO hrvbib_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","“Gospodinu treba”, odgovore oni. ");
INSERT INTO hrvbib_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Dovedu magare Isusu i prebace preko njega svoje ogrtače te posjednu Isusa na njega. ");
INSERT INTO hrvbib_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Mnoštvo je pred Isusom prostiralo svoje ogrtače po putu. ");
INSERT INTO hrvbib_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Kad se već približio obronku Maslinske gore, mnoštvo njegovih sljedbenika počne na sav glas zahvaljivati Bogu za sva slavna djela što su ih vidjeli: ");
INSERT INTO hrvbib_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Blagoslovljen kralj koji dolazi u ime Gospodnje! Na nebu mir! Slava Bogu na nebu!” ");
INSERT INTO hrvbib_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ali neki farizeji među njime kazaše: “Učitelju, opomeni svoje učenike da to ne govore!” ");
INSERT INTO hrvbib_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","“Kažem vam,” reče im Isus, “ako oni ušute, klicat će kamenje na cesti!” ");
INSERT INTO hrvbib_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Kad se približio Jeruzalemu i ugledao grad, Isus zaplače nad njim: ");
INSERT INTO hrvbib_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","“Kako bih volio da si danas pronašao put mira! Ali sada je prekasno i mir je skriven od tebe. ");
INSERT INTO hrvbib_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Doći će dani kada će neprijatelj zauzeti tvoje zidine, opkoliti te i pritisnuti sa svih strana. ");
INSERT INTO hrvbib_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Sravnit će sa zemljom i tebe i tvoju djecu u tebi. Neće od tebe ostati ni kamena na kamenu jer nisi prepoznao da te je Bog pohodio.” ");
INSERT INTO hrvbib_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Kad je ušao u Hram, Isus počne iz njega izgoniti trgovce. ");
INSERT INTO hrvbib_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","“U Svetome pismu piše: ‘Moj Hram treba biti molitveni dom’, a vi ste ga pretvorili u razbojničku špilju!”, reče im. ");
INSERT INTO hrvbib_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Nakon toga Isus je danomice poučavao u Hramu, a svećenički poglavari i pismoznanci smišljali su skupa s narodnim starješinama kako da ga ubiju, ");
INSERT INTO hrvbib_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","ali im to nije polazilo za rukom jer je narod upijao svaku njegovu riječ. ");
INSERT INTO hrvbib_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Dok je poučavao i naviještao Radosnu vijest u Hramu, priđu mu svećenički poglavari, pismoznanci i starješine ");
INSERT INTO hrvbib_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","pa ga upitaju: “Tko ti je dao pravo da to činiš? Tko te je ovlastio za to?” ");
INSERT INTO hrvbib_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","On im odgovori: “Upitat ću i ja vas. Recite mi: ");
INSERT INTO hrvbib_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","je li Ivanovo krštenje bilo s neba ili od ljudi?” ");
INSERT INTO hrvbib_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Oni počnu umovati i međusobno raspravljati: “Ako kažemo da je s neba, pitat će nas zašto mu onda nismo vjerovali. ");
INSERT INTO hrvbib_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","A ako kažemo da je od ljudi, narod će nas kamenovati jer su uvjereni da je Ivan prorok.” ");
INSERT INTO hrvbib_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Zato odgovore Isusu da ne znaju odakle je. ");
INSERT INTO hrvbib_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","A Isus im reče: “Onda ni ja vama neću reći otkuda mi vlast!” ");
INSERT INTO hrvbib_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Isus zatim narodu ispriča prispodobu: “Neki čovjek posadi vinograd i iznajmi ga vinogradarima. Zatim otputovao na mnogo godina. ");
INSERT INTO hrvbib_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Kad dođe vrijeme berbe, pošalje slugu da ubere njegov dio uroda. Ali vinogradari ga pretuku i pošalju natrag praznih ruku. ");
INSERT INTO hrvbib_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Pošalje im zatim drugog slugu, ali oni i njega pretuku, izgrde i pošalju natrag praznih ruku. ");
INSERT INTO hrvbib_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Pošalje im i trećega, ali oni ga rane i otjeraju ga. ");
INSERT INTO hrvbib_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","‘Što da učinim?’ pitao se vlasnik vinograda. ‘Poslat ću im svojega ljubljenog sina. Prema njemu će se valjda odnositi s poštovanjem.’ ");
INSERT INTO hrvbib_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ali kad vinogradari ugledaju sina, počnu umovati: ‘Ovaj će naslijediti imanje. Ubijmo ga pa ćemo se domognuti imanja umjesto njega!’ ");
INSERT INTO hrvbib_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Izbace ga iz vinograda i ubiju. Što mislite da će učiniti vlasnik kad čuje što se dogodilo? ");
INSERT INTO hrvbib_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Doći će i pobiti te vinogradare, a vinograd dati u najam drugima.” “Ne daj Bože da se takvo što dogodi!” rekoše Isusovi slušatelji. ");
INSERT INTO hrvbib_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ali Isus ih dobro promotri i reče: “A što onda znači onaj ulomak iz Svetoga pisma: ‘Kamen koji su graditelji odbacili postane ugaonim kamenom’? ");
INSERT INTO hrvbib_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Padne li tko na taj kamen, smrskat će se, i padne li kamen na koga, satrt će ga.” ");
INSERT INTO hrvbib_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Pismoznanci i svećenički poglavari htjeli su ga uhvatiti jer su dobro znali da se ta prispodoba odnosi na njih, ali bojali su se naroda. ");
INSERT INTO hrvbib_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Vrebajući ga, pošalju mu uhode koji su se izdavali za pravednike da ga uhvate u riječi pa da ga mogu predati upraviteljevoj vlasti. ");
INSERT INTO hrvbib_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","“Učitelju,” kazaše Isusu, “znamo da govoriš istinu i da si nepristran jer ne gledaš tko je tko, nego prema istini poučavaš putu Božjemu. ");
INSERT INTO hrvbib_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Reci nam je li dopušteno plaćati porez caru ili nije.” ");
INSERT INTO hrvbib_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Isus prozre njihovo lukavstvo pa reče: ");
INSERT INTO hrvbib_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Pokažite mi kovani novac. Čiji su ovo lik i natpis na kovanici?” “Carevi”, odgovore. ");
INSERT INTO hrvbib_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","“Onda dajte caru carevo, ali Bogu valja dati Božje”, reče im. ");
INSERT INTO hrvbib_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Tako ga nisu uspjeli uhvatiti u riječi pred narodom, već su ušutjeli zadivljeni odgovorom. ");
INSERT INTO hrvbib_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Tada dođu k njemu neki od saduceja, koji tvrde da nema uskrsnuća, i upitaju ga: ");
INSERT INTO hrvbib_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Gospodine, Mojsije nam je dao zakon prema kojemu, umre li oženjen muškarac bez djece, njegov se brat mora oženiti njegovom udovicom kako bi ona rodila sina koji će naslijediti posjed umrloga i nositi njegovo ime. ");
INSERT INTO hrvbib_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Bilo je sedmero braće. Prvi se brat oženi i umre a da nije imao djece. ");
INSERT INTO hrvbib_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Drugi se brat oženi njegovom udovicom, ali također umre, ");
INSERT INTO hrvbib_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","treći i sva ostala braća također. Tako nijedan od sedmorice ne ostavi potomstva. ");
INSERT INTO hrvbib_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Na posljetku umre i žena. ");
INSERT INTO hrvbib_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Čija će onda ona biti žena o uskrsnuću kad je bila udana za svu sedmoricu?” ");
INSERT INTO hrvbib_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","“Ljudi ovoga svijeta žene se i udaju,” odgovori im Isus, ");
INSERT INTO hrvbib_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","“ali oni koji budu dostojni biti dionicima onoga svijeta i uskrsnuća od mrtvih, neće se ni ženiti ni udavati. ");
INSERT INTO hrvbib_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Neće više moći ni umrijeti: bit će poput anđela. Oni su Božja djeca, djeca uskrsnuća. ");
INSERT INTO hrvbib_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","A da će mrtvi uskrsnuti, čak je i Mojsije potvrdio u ulomku o gorućem grmu gdje Gospodina naziva ‘Bogom Abrahamovim, Izakovim i Jakovljevim’ dugo nakon što su oni poumirali. ");
INSERT INTO hrvbib_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","A Bog nije Bog mrtvih, već Bog živih! Svi su oni za Boga živi.” ");
INSERT INTO hrvbib_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","“Dobro si rekao, Učitelju!” rekoše neki pismoznanci. ");
INSERT INTO hrvbib_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","I više se nisu usuđivali išta ga upitati. ");
INSERT INTO hrvbib_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Tada Isus upita njih: “Kako mogu tvrditi da je Mesija Davidov sin? ");
INSERT INTO hrvbib_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Pa sâm je David u Knjizi psalama napisao: ‘Gospodin je rekao mojem Gospodinu: Sjedni mi s desne strane ");
INSERT INTO hrvbib_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","dok ti ne bacim pod noge tvoje neprijatelje.’ ");
INSERT INTO hrvbib_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Sâm ga je David nazvao svojim Gospodinom. Kako bi mu onda mogao biti sin?” ");
INSERT INTO hrvbib_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Zatim pred svim narodom reče učenicima: ");
INSERT INTO hrvbib_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Čuvajte se pismoznanaca! Vole se šetati u dugim haljinama i da ih ljudi pozdravljaju na trgovima. U sinagogama vole sjediti na počasnim mjestima, a na gozbama na pročelju stola. ");
INSERT INTO hrvbib_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Besramno troše udovička dobra, a prikrivaju se dugačkim molitvama u javnosti. Oni će biti strože kažnjeni.” ");
INSERT INTO hrvbib_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Isus je u Hramu promatrao bogataše kako ubacuju milostinju u kutiju. ");
INSERT INTO hrvbib_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ugleda tako i neku udovicu kako ubacuje samo dva novčića. ");
INSERT INTO hrvbib_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","“Zaista vam kažem, ta je siromašna udovica ubacila više nego svi ostali skupa! ");
INSERT INTO hrvbib_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Jer svi su oni dali od svojeg viška, a ona je, tako siromašna, dala sve što je imala.” ");
INSERT INTO hrvbib_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Dok su neki učenici razgovarali o tome kako je Hram urešen lijepim kamenjem i zavjetnim darovima, Isus reče: ");
INSERT INTO hrvbib_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Doći će vrijeme kada od ovoga što gledate neće ostati ni kamen na kamenu. Svaki će biti razvaljen.” ");
INSERT INTO hrvbib_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Upitaju ga: “Učitelju, kada će se sve to dogoditi? Kojim će se znakom najaviti ispunjenje svega toga?” ");
INSERT INTO hrvbib_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","“Pazite da vas tko ne zavede!” odgovori im on. “Mnogi će doći pod mojim imenom proglašujući se Mesijom i govoreći: ‘Kucnuo je čas!’ Ne idite za takvima. ");
INSERT INTO hrvbib_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Kad čujete za ratove i pobune, nemojte se bojati. Sve se to mora dogoditi, ali svršetak još neće doći.” ");
INSERT INTO hrvbib_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Reče još: “Narod će zaratiti protiv naroda i kraljevstvo protiv kraljevstva. ");
INSERT INTO hrvbib_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Bit će velikih potresa, bit će gladi i pošasti na raznim mjestima. Bit će strahota i velikih znakova s neba. ");
INSERT INTO hrvbib_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ali prije svega toga podignut će na vas ruke i progoniti vas, predavat će vas u sinagoge i tamnice, vući će vas pred kraljeve i upravitelje zato što ste moji sljedbenici. ");
INSERT INTO hrvbib_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","To će vas snaći da im možete svjedočiti o meni. ");
INSERT INTO hrvbib_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Zato upamtite: ne morate unaprijed smišljati što reći sebi u obranu. ");
INSERT INTO hrvbib_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ja ću vam dati rječitost i takvu mudrost kakvoj neće moći proturječiti ni oduprijeti se nijedan vaš protivnik. ");
INSERT INTO hrvbib_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","A izdavat će vas čak i vlastiti roditelji, braća, rođaci i prijatelji. Neke će od vas i ubiti. ");
INSERT INTO hrvbib_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Svi će vas zamrziti zato što ste moji. ");
INSERT INTO hrvbib_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ali neće vam pasti ni vlas s glave. ");
INSERT INTO hrvbib_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Duše će vam se spasiti zbog vaše postojanosti. ");
INSERT INTO hrvbib_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Kad vidite da vojska opkoljuje Jeruzalem, znajte da će on ubrzo biti opustošen. ");
INSERT INTO hrvbib_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Neka oni koji se zateknu u Judeji bježe u goru. Tko je u gradu, neka bježi iz njega, a ni oni koji su u polju neka se ne vraćaju u grad. ");
INSERT INTO hrvbib_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Jer to će biti dani Božje kazne kojom će se ispuniti sve što piše u Svetome pismu. ");
INSERT INTO hrvbib_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Teško trudnicama i dojiljama u to vrijeme jer će ovu zemlju pritisnuti velika nevolja i velik će se gnjev izliti na ovaj narod. ");
INSERT INTO hrvbib_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Kosit će ih oštrica mača i odvodit će ih u ropstvo među sve narode. A Jeruzalem će gaziti pogani sve dok ne istekne vrijeme pogana. ");
INSERT INTO hrvbib_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Pojavit će se znaci na suncu, mjesecu i zvijezdama, a na zemlji će narode pritiskati tjeskoba zbog huke i stihije valovlja. ");
INSERT INTO hrvbib_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ljudi će umirati od straha i iščekivanja sudbe ovoga svijeta jer će se i sile nebeske potresti. ");
INSERT INTO hrvbib_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Tada će ugledati Sina Čovječjega kako dolazi na oblaku s velikom moći i slavom. ");
INSERT INTO hrvbib_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Kad se sve to počne zbivati, uspravite se i podignite glavu jer je vaše otkupljenje blizu.” ");
INSERT INTO hrvbib_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Zatim im ispriča prispodobu: “Pogledajte smokvu ili bilo koje stablo. ");
INSERT INTO hrvbib_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Kad propupa, i sami znate da je ljeto blizu. ");
INSERT INTO hrvbib_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Također kad vidite da se zbiva sve o čemu sam vam govorio, možete biti sigurni da je blizu Božje kraljevstvo. ");
INSERT INTO hrvbib_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Zaista vam kažem, ovaj naraštaj neće proći dok se sve to ne dogodi. ");
INSERT INTO hrvbib_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Nebo i zemlja će proći, ali moje riječi ostaju zauvijek! ");
INSERT INTO hrvbib_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Pazite da vam srca ne otvrdnu u proždrljivosti i pijanstvu ili u životnim brigama te da vas taj dan ne iznenadi ");
INSERT INTO hrvbib_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","kao zamka. Jer on će snaći sve žitelje na zemlji. ");
INSERT INTO hrvbib_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Bdijte dakle i stalno se molite da umaknete svim strahotama koje će se događati i da stanete pred Sina Čovječjega.” ");
INSERT INTO hrvbib_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Isus je svaki dan poučavao u Hramu, a noći je provodio na Maslinskoj gori. ");
INSERT INTO hrvbib_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","A sav je narod već od ranog jutra hrlio k njemu u Hram da ga sluša. ");
INSERT INTO hrvbib_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Bližio se Blagdan beskvasnih kruhova, Pasha. ");
INSERT INTO hrvbib_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Svećenički poglavari i pismoznanci dogovarali su se kako da ubiju Isusa, ali bojali su se da se narod ne pobuni. ");
INSERT INTO hrvbib_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Tada Sotona uđe u Judu Iškariotskoga, jednoga od Dvanaestorice. ");
INSERT INTO hrvbib_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","On ode i dogovori se sa svećeničkim poglavarima i s vojnim zapovjednicima kako će im izdati Isusa. ");
INSERT INTO hrvbib_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Oni se obraduju i obećaju mu dati novca. ");
INSERT INTO hrvbib_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Juda pristane. Tako on počne tražiti prigodu da izda Isusa kad mnoštva ne bude u blizini. ");
INSERT INTO hrvbib_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Prvog dana Blagdana beskvasnih kruhova, kad je bio običaj žrtvovati pashalno janje, ");
INSERT INTO hrvbib_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Isus pošalje Petra i Ivana: “Idite nam pripraviti večeru da skupa blagujemo.” ");
INSERT INTO hrvbib_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","“Gdje želiš da ju pripravimo?” upitaju. ");
INSERT INTO hrvbib_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","“Čim uđete u grad”, reče im, “srest ćete čovjeka koji nosi vodu u vrču. Pođite za njim. U kući u koju uđe ");
INSERT INTO hrvbib_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","potražite domaćina pa mu recite: ‘Učitelj pita u kojoj sobi može blagovati pashalnu večeru sa svojim učenicima.’ ");
INSERT INTO hrvbib_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","On će vam pokazati veliku sobu na katu, posve pripremljenu. Ondje nam pripravite večeru.” ");
INSERT INTO hrvbib_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Učenici odu u grad i nađu sve kako im je Isus rekao te ondje pripreme pashalnu večeru. ");
INSERT INTO hrvbib_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Kad je za to došlo vrijeme, Isus sjedne za stol s apostolima. ");
INSERT INTO hrvbib_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","“Čeznuo sam svom dušom da blagujem s vama ovu pashalnu večeru prije svoje muke. ");
INSERT INTO hrvbib_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Jer ju, kažem vam, neću više blagovati dok se ona ne ispuni u kraljevstvu Božjemu.” ");
INSERT INTO hrvbib_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Uzme čašu, zahvali i reče: “Uzmite i razdijelite među sobom. ");
INSERT INTO hrvbib_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Kažem vam, od sada više neću piti vina dok ne dođe Božje kraljevstvo.” ");
INSERT INTO hrvbib_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Uzme zatim kruh, zahvalio za njega, razlomi ga i podijeli im govoreći: “Ovo je moje tijelo koje se za vas predaje. Ovo činite meni na spomen.” ");
INSERT INTO hrvbib_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Kad su povečerali, uzme čašu i reče: “Ovo je moja krv, krv Novoga saveza, koja se prolijeva za vas. ");
INSERT INTO hrvbib_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ali evo, moj izdajnik sjedi sa mnom za stolom. ");
INSERT INTO hrvbib_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ja, Sin Čovječji, moram umrijeti kako je određeno, ali teško onome koji ga izda!” ");
INSERT INTO hrvbib_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Učenici se nato počnu međusobno pitati tko bi od njih mogao takvo što učiniti. ");
INSERT INTO hrvbib_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Počnu se zatim prepirati oko toga tko bi od njih bio najveći. ");
INSERT INTO hrvbib_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Isus im reče: “Kraljevi ovoga svijeta vladaju svojim narodima i provodeći vlast nad njima nazivaju se dobrotvorima. ");
INSERT INTO hrvbib_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ali vi nemojte tako! Naprotiv, najveći među vama neka bude kao najneznatniji, a starješina kao poslužitelj. ");
INSERT INTO hrvbib_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Jer tko je veći, onaj koji sjedi za stolom ili onaj koji ga poslužuje? Onaj za stolom, zar ne? A ja, evo, poslužujem vas. ");
INSERT INTO hrvbib_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ostali ste mi vjerni u mojim kušnjama. ");
INSERT INTO hrvbib_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Zato vam u baštinu dajem kraljevsku čast što ju je meni predao moj Otac ");
INSERT INTO hrvbib_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","da jedete i pijete za mojim stolom u mojemu kraljevstvu te da sjedite na prijestoljima i sudite dvanaest Izraelovih plemena.” ");
INSERT INTO hrvbib_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Šimune, Šimune, Sotona je zatražio da vas može rešetati kao pšenicu. ");
INSERT INTO hrvbib_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ali molio sam se za tebe da ti vjera ne malakše. Zato, kad se ponovno obratiš k meni, učvrsti svoju braću!” ");
INSERT INTO hrvbib_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","“Gospodine,” reče mu Petar, “spreman sam s tobom poći i u tamnicu i u smrt!” ");
INSERT INTO hrvbib_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","“Kažem ti, Petre,” reče Isus, “prije nego što pijetao zakukuriče, triput ćeš zanijekati da me uopće poznaješ. ");
INSERT INTO hrvbib_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Kad sam vas poslao na put bez novca, bez torbe i sandala, je li vam što nedostajalo?” upita ih Isus. “Nije”, odgovore. ");
INSERT INTO hrvbib_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","“Ali sada,” reče, “tko ima novca, neka ga ponese! Torbu također. Tko nema mač, neka proda odjeću i kupi ga za sebe ");
INSERT INTO hrvbib_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","jer se, kažem vam, mora ispuniti ono što o meni piše u Svetome pismu: ‘Ubrojen je među zločince.’ Sve što su proroci o meni napisali obistinit će se.” ");
INSERT INTO hrvbib_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","“Gospodine,” rekoše, “imamo tu dva mača!” “Dovoljno je”, odgovori Isus. ");
INSERT INTO hrvbib_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Zatim ode odande te se, po običaju, zaputi na Maslinsku goru. Učenici pođu s njim. ");
INSERT INTO hrvbib_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Kad su stigli, reče im: “Molite se da vas ne svlada kušnja!” ");
INSERT INTO hrvbib_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Udalji se zatim od njih koliko se može baciti kamen, padne na koljena i pomoli se: ");
INSERT INTO hrvbib_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Oče, otkloni ovu čašu od mene ako želiš. Ipak, neka bude po tvojoj, a ne po mojoj volji.” ");
INSERT INTO hrvbib_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Tada mu se s neba ukaže anđeo da ga ohrabri. ");
INSERT INTO hrvbib_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Sve je žarče molio, u smrtnoj muci, a znoj mu postane poput kaplja krvi što su padale na zemlju. ");
INSERT INTO hrvbib_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Napokon ustane, priđe učenicima i nađe ih kako spavaju iscrpljeni od žalosti. ");
INSERT INTO hrvbib_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","“Zašto spavate?” upita. “Ustanite i molite se da vas ne svlada kušnja!” ");
INSERT INTO hrvbib_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Dok je još govorio, stigne svjetina, a pred njom Juda, jedan od Dvanaestorice. Približi se Isusu i poljubi ga. ");
INSERT INTO hrvbib_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","“Juda, zar poljupcem izdaješ Sina Čovječjega?” reče Isus. ");
INSERT INTO hrvbib_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Kad su ostali učenici vidjeli što se zbiva, upitaju: “Gospodine, da ih napadnemo mačem?” ");
INSERT INTO hrvbib_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","te jedan od njih zamahne na slugu velikog svećenika i odsiječe mu desno uho. ");
INSERT INTO hrvbib_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ali Isus reče: “Pustite! Ne opirite se više!” Dotakne zatim sluzi uho i iscijeli ga. ");
INSERT INTO hrvbib_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Zatim reče ljudima koji su pošli na njega, svećeničkim poglavarima, vojnim zapovjednicima i starješinama: “Pošli ste na mene mačevima i toljagama kao na prevratnika! ");
INSERT INTO hrvbib_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Zašto me niste u Hramu uhitili? Svaki sam dan bio ondje. Ali ovo je vaš čas i vlada tama.” ");
INSERT INTO hrvbib_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Isusa uhite i odvedu u dom velikog svećenika. Petar ga je izdaleka slijedio. ");
INSERT INTO hrvbib_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Usred dvorišta stražari su naložili vatru i grijali se oko nje. Petar sjedne među njih. ");
INSERT INTO hrvbib_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Neka sluškinja ugleda ga kako sjedi pokraj vatre, promotri ga i reče: “I ovaj je bio s Isusom!” ");
INSERT INTO hrvbib_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Petar zaniječe. “Pa ja ga ni ne poznajem, ženo!” ");
INSERT INTO hrvbib_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Nedugo zatim još ga netko opazi i reče: “Ti si jedan od njih!” “Nisam, čovječe!” odgovori Petar. ");
INSERT INTO hrvbib_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Nakon otprilike jedne ure, netko opet reče: “Ovaj je zaista bio s njim! Pa Galilejac je!” ");
INSERT INTO hrvbib_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","“Ne znam o čemu govorite, čovječe!” reče Petar. Istoga časa, dok je još govorio, oglasi se pijetao. ");
INSERT INTO hrvbib_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Tada se Gospodin okrene i pogleda Petra, a Petar se sjeti kako mu je rekao: “Zaista ti kažem, još ove noći, prije nego što pijetao zakukuriče, triput ćeš me se odreći.” ");
INSERT INTO hrvbib_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Iziđe iz dvorišta i gorko zaplače. ");
INSERT INTO hrvbib_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Čuvari počnu Isusa tući i rugati mu se. ");
INSERT INTO hrvbib_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Pokrili su mu oči i zapitkivali: “Proreci tko te je udario!” ");
INSERT INTO hrvbib_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","I obasipali su ga najrazličitijim uvredama. ");
INSERT INTO hrvbib_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","U osvit dana okupe se narodni starješine, svećenički poglavari i pismoznanci te izvedu Isusa pred Veliko vijeće. ");
INSERT INTO hrvbib_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Ako si ti Krist, reci nam to!” kazali su mu. “Ako vam kažem, nećete mi vjerovati ");
INSERT INTO hrvbib_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","a ako vas što upitam, nećete odgovoriti”, reče im Isus. ");
INSERT INTO hrvbib_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","“Ali odsad će Sin Čovječji sjediti zdesna Svemogućemu Bogu.” ");
INSERT INTO hrvbib_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","“Ti, znači, tvrdiš da si Božji Sin!” poviču svi. “Sami ste pravo rekli; jesam”, odgovori im. ");
INSERT INTO hrvbib_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","“Što će nam više svjedoci?” kazali su. “Sami smo čuli, iz njegovih usta!” ");
INSERT INTO hrvbib_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Sve mnoštvo ustane te odvedu Isusa Pilatu ");
INSERT INTO hrvbib_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","i optuže ga: “Uhvatili smo ga da obmanjuje narod i govori im da ne plaćaju porez caru, a za sebe tvrdi da je Krist, kralj.” ");
INSERT INTO hrvbib_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilat ga upita: “Jesi li ti kralj Židova?” “Ti to kažeš”, odgovori mu Isus. ");
INSERT INTO hrvbib_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilat tada reče svećeničkim poglavarima i svjetini: “Ja na njemu ne nalazim nikakve krivnje.” ");
INSERT INTO hrvbib_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ali oni počnu još jače navaljivati: “Potiče narod na pobunu! Poučava po svoj Judeji, od Galileje do Jeruzalema!” ");
INSERT INTO hrvbib_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","“Pa zar je on Galilejac?” upita Pilat. ");
INSERT INTO hrvbib_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Kad su potvrdno odgovorili, Pilat pošalje Isusa Herodu, koji je vladao Galilejom. Herod se tada baš našao u Jeruzalemu. ");
INSERT INTO hrvbib_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Kad je Herod ugledao Isusa, silno se razveselio jer je o njemu dugo slušao i odavna ga je želio vidjeti nadajući se da će on pred njim učiniti i kakvo čudo. ");
INSERT INTO hrvbib_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Postavljao je Isusu pitanje za pitanjem, ali Isus ni na jedno nije odgovarao. ");
INSERT INTO hrvbib_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Svećenički poglavari i pismoznanci stajali su ondje i vikali žestoko ga optužujući. ");
INSERT INTO hrvbib_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herod i njegovi vojnici Isusa ponize i ismiju: obuku ga opet u kraljevsku odjeću i pošalju natrag Pilatu. ");
INSERT INTO hrvbib_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Herod i Pilat, koji su bili neprijatelji, toga su se dana sprijateljili. ");
INSERT INTO hrvbib_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilat sazove svećeničke poglavare, vijećnike i narod ");
INSERT INTO hrvbib_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","te im reče: “Doveli ste mi ovoga čovjeka optužujući ga da potiče narod na bunu. Ispitao sam ga pred vama, ali nisam utvrdio krivnju za koju ga optužujete. ");
INSERT INTO hrvbib_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Nije ju utvrdio ni Herod jer ga je poslao natrag nama. Nije učinio ništa čime bi zaslužio smrtnu kaznu. ");
INSERT INTO hrvbib_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Išibat ću ga, a zatim pustiti.” ");
INSERT INTO hrvbib_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Nato svi uglas poviču: “Njega smakni, a pusti nam Barabu!” ");
INSERT INTO hrvbib_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Baraba je bio u tamnici zbog ubojstva i zbog prevratničke pobune u Jeruzalemu. ");
INSERT INTO hrvbib_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilat ih pokuša odgovoriti jer je želio pustiti Isusa. ");
INSERT INTO hrvbib_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ali oni su vikali: “Raspni ga! Raspni ga!” ");
INSERT INTO hrvbib_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","“Ali kakav je zločin počinio?” upita Pilat i treći put. “Nisam utvrdio da je učinio išta što bi zasluživalo smrtnu kaznu. Išibat ću ga dakle i pustiti.” ");
INSERT INTO hrvbib_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ali svjetina je vikala navaljujući da se Isus raspne. Vikali su sve glasnije i glasnije. ");
INSERT INTO hrvbib_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pilat presudi tako da im udovolji ");
INSERT INTO hrvbib_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","te pusti čovjeka utamničenoga zbog pobune i ubojstva, a Isusa preda njima na volju. ");
INSERT INTO hrvbib_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Dok su odvodili Isusa, uhvate nekoga Šimuna iz Cirene koji se vraćao s polja te na njega stave križ da ga nosi za Isusom. ");
INSERT INTO hrvbib_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Za njim je išlo silno mnoštvo i mnoge žene koje su plakale i naricale. ");
INSERT INTO hrvbib_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ali Isus se okrene prema njima i reče im: “Kćeri jeruzalemske, ne plačite nada mnom, nego nad sobom i nad svojom djecom. ");
INSERT INTO hrvbib_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Jer stižu dani kad će se govoriti: ‘Blago nerotkinjama, blago utrobama koje nisu rodile i prsima koja nisu dojila!’ ");
INSERT INTO hrvbib_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Tada će ljudi moliti gore da na njih padnu i brežuljke da ih pokriju. ");
INSERT INTO hrvbib_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Jer ako se ovako postupa sa zelenim stablom, što će tek biti sa suhim?” ");
INSERT INTO hrvbib_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","S Isusom su na smaknuće vodili i dvojicu zločinaca. ");
INSERT INTO hrvbib_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Kad su došli do mjesta zvanoga Lubanja, raspnu ga, a s njim i zločince: jednoga zdesna, a drugog slijeva. ");
INSERT INTO hrvbib_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","“Oprosti im, Oče, jer ne znaju što čine!” reče Isus. Vojnici zatim bace kocku te tako razdijele među sobom njegovu odjeću. ");
INSERT INTO hrvbib_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Mnoštvo je stajalo i promatralo, a svećenički su se poglavari rugali: “Spasio je druge, pa neka sad spasi sebe ako je zaista Krist, Božji izabranik!” ");
INSERT INTO hrvbib_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Rugali su mu se i vojnici. Prilazili su i nudili mu ocat ");
INSERT INTO hrvbib_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","govoreći: “Spasi sebe ako si kralj Židova!” ");
INSERT INTO hrvbib_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Iznad njega je stajao natpis: “ovo je kralj Židova.” ");
INSERT INTO hrvbib_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Jedan od raspetih zločinaca vrijeđao ga je: “Ti si Krist, je li? Spasi onda i sebe i nas!” ");
INSERT INTO hrvbib_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ali drugi ga ukori: “Zar se ne bojiš Boga? Trpiš istu kaznu kao i on. ");
INSERT INTO hrvbib_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ali pravedno je da mi trpimo jer je to zaslužena plaća za naša djela. A ovaj čovjek nije učinio nikakvo zlo.” ");
INSERT INTO hrvbib_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Reče zatim: “Isuse, sjeti me se kad dođeš u svoje kraljevstvo!” ");
INSERT INTO hrvbib_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","“Zaista ti kažem,” odgovori mu Isus, “danas ćeš biti sa mnom u raju.” ");
INSERT INTO hrvbib_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Kad je već došlo podne, po svoj zemlji nastane tama i potraje do tri ure. ");
INSERT INTO hrvbib_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Sunce se pomrači, a hramski se zastor razdere po sredini. ");
INSERT INTO hrvbib_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","A Isus još jedanput glasno krikne: “Oče, predajem svoj duh u tvoje ruke!”, i izdahne. ");
INSERT INTO hrvbib_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Kad je rimski stotnik vidio što se zbilo, počne slaviti Boga. “Ovaj je čovjek zaista bio pravednik!”, reče. ");
INSERT INTO hrvbib_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Nakon toga se mnoštvo koje je nagrnulo vidjeti što se zbiva vraćalo doma udarajući se u prsa od žalosti. ");
INSERT INTO hrvbib_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ali svi Isusovi znanci i žene koje su za njim došle iz Galileje stajali su podalje i promatrali. ");
INSERT INTO hrvbib_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Bio je neki čovjek imenom Josip, vijećnik, dobar i pravedan čovjek ");
INSERT INTO hrvbib_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","iz Arimateje. Nije se slagao s odlukom i postupkom drugih prema Isusu, već je iščekivao Božje kraljevstvo. ");
INSERT INTO hrvbib_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","On ode k Pilatu i zatraži da mu daju Isusovo tijelo. ");
INSERT INTO hrvbib_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Zatim ga skine s križa, umota u platno i položi u grob isklesan u stijeni, u kojega još nitko nije bio položen. ");
INSERT INTO hrvbib_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Učinio je to na dan Priprave, pred subotu, u osvit dana. ");
INSERT INTO hrvbib_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Žene koje su došle s Isusom iz Galileje pratile su sve to i vidjele kako su njegovo tijelo položili u grob. ");
INSERT INTO hrvbib_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Vrate se doma te pripreme miomirise i pomasti za tijelo. Ali kad su to dovršile, već je bila subota pa cijeli dan nisu ništa radile poštujući odredbu iz Zakona. ");
INSERT INTO hrvbib_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","U osvit dana u nedjelju dođu na grob s miomirisima što su ih pripravile ");
INSERT INTO hrvbib_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","i nađu kamen s ulaza u grob odmaknut. ");
INSERT INTO hrvbib_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ušle su unutra, ali nisu našle tijelo Gospodina Isusa. ");
INSERT INTO hrvbib_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Dok su tako zbunjene stajale, uz njih se pojave dva čovjeka u blistavoj odjeći. ");
INSERT INTO hrvbib_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Žene se prestraše i poniknu licem prema zemlji. “Zašto tražite živoga među mrtvima?” upitaju ih dvojica. ");
INSERT INTO hrvbib_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","“Nije ovdje, uskrsnuo je! Sjetite se što vam je govorio još u Galileji: ");
INSERT INTO hrvbib_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Sina Čovječjega predat će u ruke grešnicima i raspet će ga, ali on će treći dan uskrsnuti.’” ");
INSERT INTO hrvbib_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","One se sjete da je Isus to rekao. ");
INSERT INTO hrvbib_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Požure zato s groba to javiti jedanaestorici učenika i ostalima. ");
INSERT INTO hrvbib_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Bile su to Marija Magdalena, Ivana i Marija, majka Jakovljeva, i još neke žene. Sve su one to ispričale apostolima, ");
INSERT INTO hrvbib_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","ali njima se činilo da je sve to izmišljotina. I nisu im vjerovali. ");
INSERT INTO hrvbib_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ipak, Petar potrči do groba. Kad je stigao, proviri unutra i spazi samo povoje od lanena platna. Vrati se zatim čudeći se onomu što se dogodilo. ");
INSERT INTO hrvbib_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Toga su dana dvojica Isusovih sljedbenika putovala u selo Emaus, udaljeno od Jeruzalema jedanaest kilometara. ");
INSERT INTO hrvbib_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Putem su razgovarali o svemu što se dogodilo. ");
INSERT INTO hrvbib_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Dok su tako razgovarali i raspravljali, pristupi im Isus i pođe s njima. ");
INSERT INTO hrvbib_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ali njihovim je očima bilo uskraćeno da ga prepoznaju. ");
INSERT INTO hrvbib_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","“O čemu to raspravljate putujući?” upita ih. Oni zastanu, shrvani tugom. ");
INSERT INTO hrvbib_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Jedan od njih, imenom Kleofa, odgovori mu: “Ti si, čini se, jedini tuđinac u Jeruzalemu koji ne zna što se ondje dogodilo ovih dana.” ");
INSERT INTO hrvbib_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","“Što se dogodilo?” upita Isus. “Pa to s Isusom Nazarećaninom”, rekli su. “On je bio prorok silan i na riječi i na djelima pred Bogom i pred svim narodom. ");
INSERT INTO hrvbib_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ali naši svećenički poglavari i članovi Velikog vijeća predali su ga da bude osuđen na smrt te su ga raspeli. ");
INSERT INTO hrvbib_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","A mi smo se nadali da je on Otkupitelj koji će spasiti Izrael. Osim toga, već je treći dan otkako se to dogodilo. ");
INSERT INTO hrvbib_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Još su nas i neke žene, koju su ga s nama slijedile, zbunile: čim je svanulo otišle su na grob, ");
INSERT INTO hrvbib_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ali ondje nisu našle njegovo tijelo. Došle su i rekle da su im se ukazali anđeli i kazali im da je živ. ");
INSERT INTO hrvbib_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Neki od nas pojurili su na grob i našli su sve kao što su žene ispričale, ali njega nisu vidjeli.” ");
INSERT INTO hrvbib_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","“Neumnici!” reče im nato Isus. “Nikako da povjerujete sve što su proroci navijestili. ");
INSERT INTO hrvbib_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Nisu li oni prorekli da će Krist morati sve to pretrpjeti prije nego što uđe u svoju slavu?” ");
INSERT INTO hrvbib_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Zatim im, započevši od Mojsija, protumači što su svi proroci o njemu zapisali u Svetome pismu. ");
INSERT INTO hrvbib_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Približili su se već selu kamo su išli, a Isus se pričini da će nastaviti put. ");
INSERT INTO hrvbib_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ali oni su ga nagovarali: “Ostani s nama! Već je večer; dan je na izmaku!” On ostane i uđe s njima u kuću. ");
INSERT INTO hrvbib_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Dok je sjedio s njima za stolom, Isus uzme kruh, blagoslovi ga i razlomi te im ga dade. ");
INSERT INTO hrvbib_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Uto se njima otvore oči pa ga prepoznaju, a on nestane. ");
INSERT INTO hrvbib_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","“Nije li nam srce usplamtjelo kad nam je putem pričao i tumačio Pisma?” upitaju oni jedan drugoga. ");
INSERT INTO hrvbib_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Smjesta se spreme i vrate u Jeruzalem. Ondje nađu na okupu Jedanaestoricu i ostale Isusove sljedbenike. ");
INSERT INTO hrvbib_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","“Gospodin je zaista uskrsnuo!” kazaše im. “Zaista se ukazao Šimunu!” ");
INSERT INTO hrvbib_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ispripovijedaju im zatim susret s Gospodinom na putu u Emaus te kako su ga prepoznali kad je razlomio kruh. ");
INSERT INTO hrvbib_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Dok su oni o tome razgovarali, Isus odjednom stane među njih. “Mir vama!” reče im. ");
INSERT INTO hrvbib_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Zbunjeni i prestrašeni, mislili su da vide duha. ");
INSERT INTO hrvbib_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ali Isus im reče: “Zašto se bojite? Zašto vam se sumnja rađa u srcu? ");
INSERT INTO hrvbib_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Pogledajte mi ruke i noge! Ja sam to! Opipajte me pa ćete vidjeti! Duhovi nemaju kostiju i mesa kao ja!” ");
INSERT INTO hrvbib_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Pokaže im svoje ruke i noge. ");
INSERT INTO hrvbib_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Od čuđenja i veselja nisu mogli vjerovati. On upita: “Imate li što za jelo?” ");
INSERT INTO hrvbib_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Pruže mu komad pečene ribe, ");
INSERT INTO hrvbib_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","a on ga uzme i pojede pred njima. ");
INSERT INTO hrvbib_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Reče zatim: “O ovome sam vam govorio dok sam prije bio s vama: Trebalo se ispuniti sve što u Mojsijevu zakonu, proročkim knjigama i psalmima piše o meni.” ");
INSERT INTO hrvbib_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Otvori im zatim um da razumiju Sveto pismo ");
INSERT INTO hrvbib_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","pa reče: “Piše da će Krist trpjeti i treći dan ustati od mrtvih. ");
INSERT INTO hrvbib_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","U njegovo ime propovijedajte obraćenje i oproštenje grijeha svim narodima počevši od Jeruzalema. ");
INSERT INTO hrvbib_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Vi ste svjedoci toga. ");
INSERT INTO hrvbib_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","A ja ću vam poslati Svetoga Duha, baš kao što je Otac obećao. Ostanite u gradu dok vas Sveti Duh ne ispuni silom odozgora!” ");
INSERT INTO hrvbib_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Isus ih zatim povede u blizinu Betanije. Ondje podigne ruke i blagoslovi ih. ");
INSERT INTO hrvbib_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Tako se, blagoslivljajući ih, i rastane od njih: uznesen je na nebo. ");
INSERT INTO hrvbib_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Oni mu se ničice poklone, a zatim se silno radosni vrate u Jeruzalem. ");
INSERT INTO hrvbib_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ondje su u Hramu neprestano slavili Boga.");
INSERT INTO hrvbib_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","U početku je postojao On koji bijaše Riječ. On je bio s Bogom i bio je Bog. ");
INSERT INTO hrvbib_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","U početku je bio kod Boga. ");
INSERT INTO hrvbib_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Stvorio je sve što postoji, i ne postoji ništa što nije On stvorio. ");
INSERT INTO hrvbib_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","U njemu bijaše Život i taj je Život svjetlo ljudima. ");
INSERT INTO hrvbib_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","To svjetlo prodire kroz tamu i tama ga nikada ne može ugasiti. ");
INSERT INTO hrvbib_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Bog je poslao Ivana Krstitelja ");
INSERT INTO hrvbib_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","da svima govori o svjetlu kako bi svatko mogao povjerovati na temelju njegova svjedočanstva. ");
INSERT INTO hrvbib_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Sam Ivan nije bio svjetlo; on je bio tek svjedok koji je trebao govoriti o svjetlu. ");
INSERT INTO hrvbib_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Onaj koji je istinito svjetlo što prosvjetljuje svakog čovjeka došao je na svijet. ");
INSERT INTO hrvbib_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Iako je stvorio svijet, kad je došao, svijet ga nije prepoznao. ");
INSERT INTO hrvbib_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Došao je vlastitom narodu i nisu ga prihvatili. ");
INSERT INTO hrvbib_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ali svima onima koji su povjerovali u njega i prihvatili ga dao je pravo da postanu Božjom djecom jer su se pouzdali u njegovo ime da ih spasi. ");
INSERT INTO hrvbib_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Svi koji povjeruju u njega ponovno se rađaju, ali ne tjelesnim rođenjem koje dolazi od ljudske strasti ili od čovjekove volje, nego od Boga. ");
INSERT INTO hrvbib_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Tako je On, koji bijaše Riječ, postao čovjekom i živio je ovdje na zemlji, među nama. Bio je pun milosti i istine. A mi smo vidjeli njegovu slavu, slavu Očeva Sina jedinca. ");
INSERT INTO hrvbib_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ivan je za njega svjedočio vičući: “To je onaj za kojega sam vam govorio: Dolazi za mnom netko mnogo veći od mene jer je postojao prije mene.” ");
INSERT INTO hrvbib_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Svi smo primali od njegove punine, milost za milošću. ");
INSERT INTO hrvbib_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Mojsije je donio Zakon, dok su po Kristu došle istina i milost. ");
INSERT INTO hrvbib_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Boga, zapravo, nitko nikad nije vidio osim njegova jedinorođenoga Sina—Boga—jer je on iz Očevih njedara i govorio nam je o Ocu. ");
INSERT INTO hrvbib_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ovo je Ivanovo svjedočanstvo: Židovi poslaše svećenike i njihove pomoćnike iz Jeruzalema da upitaju Ivana tko je on. ");
INSERT INTO hrvbib_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","On je otvoreno priznao: “Ja nisam Krist.” ");
INSERT INTO hrvbib_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","“A tko si onda?” pitali su ga. “Jesi li Ilija?” “Nisam”, odgovori on. “Jesi li Prorok?” “Nisam.” ");
INSERT INTO hrvbib_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","“Pa tko si onda? Reci nam da možemo odgovoriti onima koji su nas poslali. Što imaš reći o sebi?” ");
INSERT INTO hrvbib_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","On im odgovori: “Ja sam glas koji viče u pustinji: ‘Pripremite put za Gospodnji dolazak!’ kako je prorokovao Izaija.” ");
INSERT INTO hrvbib_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Izaslanici bijahu farizeji. ");
INSERT INTO hrvbib_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Upitaju ga: “Ako nisi Krist, ni Ilija, ni Prorok, odakle ti pravo da krstiš?” ");
INSERT INTO hrvbib_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","“Ja krstim vodom”, rekao im je Ivan, “ali ovdje među vama nalazi se netko koga još niste upoznali. ");
INSERT INTO hrvbib_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","On će uskoro započeti svoju službu među vama, a ja mu nisam dostojan ni robom biti.” ");
INSERT INTO hrvbib_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","To se dogodilo u Betaniji, s one strane Jordana na kojoj je Ivan krstio narod. ");
INSERT INTO hrvbib_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Sutradan Ivan ugleda Isusa kako mu prilazi, pa reče: “Pogledajte! Evo Jaganjca Božjega koji odnosi grijeh svijeta! ");
INSERT INTO hrvbib_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ovo je taj za kojega sam rekao: ‘Dolazi za mnom čovjek koji je mnogo veći od mene jer je postojao prije mene.’ ");
INSERT INTO hrvbib_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Nisam znao da je on taj, ali ovdje sam i krstim vodom zato da bih ga objavio izraelskom narodu.” ");
INSERT INTO hrvbib_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Zatim Ivan posvjedoči: “Vidio sam Svetog Duha gdje silazi u obliku goluba i ostaje na njemu. ");
INSERT INTO hrvbib_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Nisam znao da je on taj”, ponovi on, “ali kad me je Bog poslao da krstim, rekao mi je: ‘Kad vidiš čovjeka na kojega silazi Sveti Duh i ostaje na njemu—znaj da je to onaj kojega tražiš. To je onaj koji krsti Svetim Duhom.’ ");
INSERT INTO hrvbib_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Vidio sam da se to dogodilo ovomu čovjeku i zato svjedočim da je on Božji Sin.” ");
INSERT INTO hrvbib_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Sutradan je Ivan stajao s dvojicom svojih učenika, ");
INSERT INTO hrvbib_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","a Isus je onuda prolazio. Ivan ga ugleda i reče: “Pogledajte! Evo Jaganjca Božjega!” ");
INSERT INTO hrvbib_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Kad su to čula dvojica njegovih učenika, okrenu se i pođu za Isusom. ");
INSERT INTO hrvbib_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Isus se okrene i spazi ih kako ga slijede. “Što hoćete?” upita ih. “Rabbi (to znači: Učitelju), gdje stanuješ?” odgovore oni pitanjem. ");
INSERT INTO hrvbib_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","“Dođite i vidjet ćete”, reče im. I tako pođu s njime do mjesta gdje je stanovao i ostanu ondje od četiri sata poslijepodne do večeri. ");
INSERT INTO hrvbib_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Jedan od dvojice koji su čuli što je Ivan rekao i pošli za Isusom bio je Andrija, brat Šimuna Petra. ");
INSERT INTO hrvbib_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andrija najprije ode potražiti brata i kaza mu: “Našli smo Mesiju (to znači: Krista)!” ");
INSERT INTO hrvbib_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","I dovede Petra da upozna Isusa. Isus ga pomnjivo pogleda i reče mu: “Ti si Šimun, Ivanov sin, ali zvat ćeš se Kefa (to znači: Petar)!” ");
INSERT INTO hrvbib_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Sutradan Isus odluči poći u Galileju. Susretne Filipa i reče mu: “Pođi za mnom!” ");
INSERT INTO hrvbib_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filip bijaše iz Betsaide, iz Petrova i Andrijina rodnoga grada. ");
INSERT INTO hrvbib_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filip pak potraži Natanaela i reče mu: “Našli smo Mesiju, onoga o kojemu su pisali Mojsije i Proroci. To je Isus, Josipov sin, iz Nazareta.” ");
INSERT INTO hrvbib_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","“Iz Nazareta!” poviče Natanael. “Može li odande doći što dobro?” “Samo dođi i uvjeri se”, reče mu Filip. ");
INSERT INTO hrvbib_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Dok su se približavali, Isus ga ugleda i reče: “Evo poštenoga čovjeka, pravog Izraelca.” ");
INSERT INTO hrvbib_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","“Otkud znaš kakav sam?” upita Natanael. Isus mu odgovori: “Vidio sam te pod smokvom prije nego te je Filip našao.” ");
INSERT INTO hrvbib_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nato mu Natanael odgovori: “Učitelju, ti si Božji Sin! Ti si kralj Izraela!” ");
INSERT INTO hrvbib_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","“Zar vjeruješ samo zato što sam ti rekao da sam te vidio pod smokvom?” upita Isus. “Vidjet ćeš i više od toga. ");
INSERT INTO hrvbib_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Gledat ćete, zaista vam kažem, kako se otvara nebo i kako anđeli Božji uzlaze i silaze nad Sinom Čovječjim.” ");
INSERT INTO hrvbib_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Dva dana poslije bila je svadba u Kani Galilejskoj, a ondje bijaše i Isusova majka. ");
INSERT INTO hrvbib_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Isus i njegovi učenici također su bili pozvani. ");
INSERT INTO hrvbib_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Za vrijeme slavlja potrošila se sva zaliha vina, pa majka reče Isusu: “Nemaju vina.” ");
INSERT INTO hrvbib_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","“A što bi ti od mene htjela?” odgovori joj Isus. “Moje vrijeme još nije došlo.” ");
INSERT INTO hrvbib_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Njegova majka reče slugama: “Učinite sve što vam kaže!” ");
INSERT INTO hrvbib_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Bilo je ondje šest kamenih posuda. Njih su Židovi rabili za obredno pranje, a u svaku je stalo stotinjak litara. ");
INSERT INTO hrvbib_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Isus reče slugama da posude do vrha napune vodom. ");
INSERT INTO hrvbib_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Kad su to učinili, reče im: “Sada zahvatite i odnesite ravnatelju stola.” I oni odnesu vino. ");
INSERT INTO hrvbib_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ravnatelj stola nije znao odakle je vino, ali sluge jesu. Ravnatelj okusi vodu pretvorenu u vino i pozove mladoženju. ");
INSERT INTO hrvbib_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“Vino je izvrsno”, reče. “Ti nisi kao drugi. Domaćin obično najprije nudi najbolje vino, a poslije, kad se svi napiju, daje im lošije. Ali ti si čuvao najbolje vino za kraj!” ");
INSERT INTO hrvbib_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","To čudo u Kani Galilejskoj bilo je prvo javno očitovanje Isusove slave i božanske sile. I njegovi učenici povjeruju da je on zaista Mesija. ");
INSERT INTO hrvbib_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Nakon svadbe Isus ode na nekoliko dana u Kafarnaum sa svojom majkom, braćom i učenicima. ");
INSERT INTO hrvbib_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Približila se godišnja svetkovina, židovska Pasha, pa Isus ode u Jeruzalem. ");
INSERT INTO hrvbib_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","U dvorištu Hrama zatekne trgovce kako prodaju žrtvene volove, ovce i golubove te mjenjače novca kako sjede za stolovima. ");
INSERT INTO hrvbib_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Isus zasuče uže u bič te ih sve istjera iz Hrama, istjera ovce i volove, mjenjačima prospe sav novac po podu, a stolove im prevrne. ");
INSERT INTO hrvbib_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Prodavačima golubova reče: “Nosite to odavde! Ne pravite sajmište od kuće mojega Oca!” ");
INSERT INTO hrvbib_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Njegovi se učenici tada prisjete proročanstva iz Svetog pisma: “Izjeda me revnost za tvoj dom.” ");
INSERT INTO hrvbib_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","“Kojim ih pravom tjeraš van?” pitali su ga Židovi. “Ako imaš ovlast za to, pokaži nam neko čudo kao dokaz.” ");
INSERT INTO hrvbib_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Isus im odgovori: “Srušite ovaj Hram, a ja ću ga za tri dana podignuti.” ");
INSERT INTO hrvbib_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","“Što?!” poviču oni. “Taj se Hram gradio četrdeset šest godina, a ti ćeš ga podignuti u tri dana?” ");
INSERT INTO hrvbib_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ali Isus je govorio o hramu svojega tijela. ");
INSERT INTO hrvbib_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Kad je uskrsnuo, njegovi su se učenici sjetili da je to htio reći, pa su shvatili da se ono što je naveo iz Svetog pisma zaista odnosilo na njega i da se sve obistinilo. ");
INSERT INTO hrvbib_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Mnogi su povjerovali da je on zaista Mesija jer su vidjeli čuda koja je učinio u Jeruzalemu u vrijeme Pashe. ");
INSERT INTO hrvbib_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ali Isus u njih nije imao povjerenja jer ih je dobro poznavao. ");
INSERT INTO hrvbib_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Nitko mu nije trebao govoriti kakav je čovjek jer je dobro poznavao ljudsku nutrinu. ");
INSERT INTO hrvbib_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Bio je ugledni židovski vjerski vođa po imenu Nikodem, farizej. ");
INSERT INTO hrvbib_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Jedne noćidođe razgovarati s Isusom. “Učitelju”, reče on, “mii znamo da te je Bog poslao da nas poučiš. Tvoja su čuda dovoljan dokaz za to jer nitko ne može činiti takva djela ako Bog nije s njim.” ");
INSERT INTO hrvbib_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Isus mu odgovori: “Zaista ti kažem—tko se nanovo ne rodi odozgor, nikada neće vidjeti Božjega kraljevstva!” ");
INSERT INTO hrvbib_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","“Pa kako se čovjek može nanovo roditi kad je već star? Ne može se odrastao čovjek vratiti u majčinu utrobu i nanovo se roditi!” reče mu Nikodem. ");
INSERT INTO hrvbib_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Isus odgovori: “Zaista ti kažem: Ne rodi li se čovjek iz vode i Duha, ne može ući u Božje kraljevstvo! ");
INSERT INTO hrvbib_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ljudi mogu dati samo ljudski život, ali Sveti Duh rađa novi život s neba; ");
INSERT INTO hrvbib_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","nemoj se zato čuditi što ti kažem da se morate nanovo roditi odozgora. ");
INSERT INTO hrvbib_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Kao što čuješ vjetar a ne znaš odakle dolazi ni kamo ide, tako je sa svakim tko je rođen od Duha.” ");
INSERT INTO hrvbib_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","“Kako je to moguće?” upita Nikodem. ");
INSERT INTO hrvbib_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Isus mu odgovori: “Pa ti si židovski učitelj, a to ne razumiješ! ");
INSERT INTO hrvbib_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Zaista ti kažem: Govorimo ono što znamo i svjedočimo o onome što smo vidjeli, a ipak nam ne vjerujete. ");
INSERT INTO hrvbib_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ako mi ne vjerujete kad vam govorim o onome što se događa ovdje na zemlji, kako ćete mi vjerovati budem li vam govorio što se zbiva na nebu? ");
INSERT INTO hrvbib_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Jer nitko nije uzišao na nebo osim Sina Čovječjega, koji je s neba sišao. ");
INSERT INTO hrvbib_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","I kao što je Mojsije u pustinji podignuo zmiju od mjedi, tako i ja, Sin Čovječji, moram biti uzdignut ");
INSERT INTO hrvbib_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","da svatko tko povjeruje u mene ima vječni život. ");
INSERT INTO hrvbib_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Bog je toliko volio svijet da je dao svojega jedinorođenog Sina da nijedan koji u njega vjeruje ne pogine, nego da ima vječni život. ");
INSERT INTO hrvbib_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Jer Bog nije poslao svojega Sina na svijet da svijet osudi, nego da se svijet spasi po njemu. ");
INSERT INTO hrvbib_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Neće biti suda za one koji vjeruju u njega. Ali oni koji u njega ne vjeruju već su osuđeni jer nisu vjerovali u jedinoga Božjeg Sina. ");
INSERT INTO hrvbib_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Osuđeni su zbog ovoga: svjetlo je došlo s neba na svijet, ali su ljudi više voljeli tamu nego svjetlo jer su im djela bila zla. ");
INSERT INTO hrvbib_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Oni mrze svjetlo jer žele griješiti u tami. Klone se svjetla da se njihovi grijesi ne razotkriju i da ne budu kažnjeni. ");
INSERT INTO hrvbib_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ali oni koji čine istinu rado dolaze k svjetlu da se vidi kako čine ono što Bog od njih traži.” ");
INSERT INTO hrvbib_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Nakon toga Isus sa svojim učenicima ode u pokrajinu Judeju. Tu se s njima zadržao neko vrijeme i krstio. ");
INSERT INTO hrvbib_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","U to je vrijeme Ivan Krstitelj krstio ljude u Enonu, blizu Salima, jer ondje bijaše mnogo vode, a ljudi su dolazili k njemu da ih krsti. ");
INSERT INTO hrvbib_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Bilo je to prije nego što su Ivana bacili u tamnicu. ");
INSERT INTO hrvbib_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Neki se Židov počne s Ivanovim učenicima prepirati oko krštenja. ");
INSERT INTO hrvbib_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Oni zato dođu k Ivanu te mu rekoše: “Učitelju, onaj kojega si susreo na drugoj strani Jordana—onaj za kojega si rekao da je Krist—također krsti pa svi odlaze onamo umjesto k nama.” ");
INSERT INTO hrvbib_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ivan odgovori: “Nitko ne može ništa činiti ako mu to s neba nije dopušteno. ");
INSERT INTO hrvbib_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Moj je posao pripraviti put tom čovjeku, tako da svi idu k njemu. Znate da sam vam otvoreno rekao da ja nisam Krist i da sam tu samo da mu pripravim put. ");
INSERT INTO hrvbib_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Mnoštvo ide za onime što ga najviše privlači—mladenka će ondje gdje joj je mladoženja. Njegovi prijatelji, koji su uz njega, s njime se vesele. Ja sam mladoženjin prijatelj i moja je radost upravo postala potpunom. ");
INSERT INTO hrvbib_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","On treba sve više rasti, a ja se sve više umanjivati. ");
INSERT INTO hrvbib_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","On je došao s neba i veći je od sviju. Ja sam sa zemlje, pa je moje shvaćanje ograničeno na zemaljske stvari. Jer tko dolazi s neba, on je iznad svih. ");
INSERT INTO hrvbib_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","On svjedoči o onome što je vidio i čuo, a tako malo ih vjeruje što im govori. ");
INSERT INTO hrvbib_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Oni pak koji su povjerovali njegovu svjedočanstvu, potvrđuju da je Bog istinit. ");
INSERT INTO hrvbib_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","On je poslan od Boga, govori Božje riječi, jer je Božji Duh na njemu bez mjere. ");
INSERT INTO hrvbib_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Otac voli svojeg Sina i predao mu je vlast nad svime. ");
INSERT INTO hrvbib_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Svi koji se pouzdaju u Božjega Sina da ih spasi imaju vječni život, a oni koji ga ne slušaju neće nikada imati vječni život, već gnjev Božji ostaje na njima.” ");
INSERT INTO hrvbib_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Kad je Gospodin saznao da su farizeji čuli kako on, Isus, krsti više učenika nego Ivan, ");
INSERT INTO hrvbib_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","iako ih nije on osobno krstio, nego učenici, ");
INSERT INTO hrvbib_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","ode iz Judeje i vrati se u pokrajinu Galileju. ");
INSERT INTO hrvbib_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Na putu je morao proći kroz Samariju. ");
INSERT INTO hrvbib_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Došao je do samarijskoga sela Sihara, blizu zemljišta koje je Jakov dao svojemu sinu Josipu. ");
INSERT INTO hrvbib_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Tu se nalazio Jakovljev zdenac. Umoran od dugotrajnog hodanja, Isus je tako sjedio pokraj zdenca. Bilo je to oko podneva. ");
INSERT INTO hrvbib_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ubrzo zatim dođe po vodu neka Samarijanka i Isus ju zamoli: “Daj mi da se napijem!” ");
INSERT INTO hrvbib_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Bio je sam jer su njegovi učenici otišli u grad kupiti hrane. ");
INSERT INTO hrvbib_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","“Ti si Židov, a ja Samarijanka. Kako to da od mene tražiš vode?” upita žena. Židovi se, naime, nisu družili sa Samarijancima. ");
INSERT INTO hrvbib_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Isus odgovori: “Kad bi ti samo znala kakav ti dar nudi Bog i tko sam ja koji te tražim piti, tražila bi od mene žive vode i ja bih ti je dao.” ");
INSERT INTO hrvbib_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","“Gospodine, pa ti nemaš ni kabla ni užeta”, reče mu ona, “a zdenac je vrlo dubok. Odakle živa voda? ");
INSERT INTO hrvbib_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Osim toga, zar si veći od našeg praoca Jakova, koji nam je dao ovaj zdenac? Kako možeš nuditi bolju vodu od ove koju su pili on i njegovi sinovi i kojom su napajali stoku?” ");
INSERT INTO hrvbib_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Isus odgovori: “Tko god pije tu vodu, opet će ožednjeti. ");
INSERT INTO hrvbib_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","A tko pije vodu koju ću mu ja dati, nikada više neće ožednjeti. Štoviše, ta će voda u njemu postati nepresušnim izvorom koji struji u vječni život.” ");
INSERT INTO hrvbib_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","“Gospodine, molim te”, reče žena, “daj mi te vode da više nikad ne ožednim i da ne moram više ovamo dolaziti po vodu!” ");
INSERT INTO hrvbib_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","“Idi i dovedi svojeg muža, pa se vrati ovamo!” reče joj Isus. ");
INSERT INTO hrvbib_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","“Ali ja nemam muža”, odgovori žena. “Dobro si kazala: nemaš muža!” reče Isus. ");
INSERT INTO hrvbib_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","“Jer si imala pet muževa, a nisi vjenčana ni s ovim s kojim sada živiš. Istinu si rekla.” ");
INSERT INTO hrvbib_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","“Gospodine,” reče žena, “vidim da si prorok. ");
INSERT INTO hrvbib_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Zašto vi Židovi tvrdite da se Bogu treba klanjati jedino u Jeruzalemu, kad su mu se naši preci klanjali na ovoj gori?” ");
INSERT INTO hrvbib_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Isus joj odgovori: “Vjeruj mi, ženo, dolazi vrijeme kad više neće biti potrebno štovati Oca ni na ovoj planini ni u Jeruzalemu. ");
INSERT INTO hrvbib_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Vi Samarijanci ne znate onoga kojemu se klanjate, a mi Židovi ga znamo jer spasenje dolazi od Židova. ");
INSERT INTO hrvbib_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ali dolazi vrijeme—već je stiglo—kad će se pravi klanjatelji klanjati Ocu u duhu i istini. Bog želi takve klanjatelje. ");
INSERT INTO hrvbib_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Bog je Duh i oni koji mu se klanjaju moraju mu se klanjati u duhu i istini.” ");
INSERT INTO hrvbib_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","“Znam da će jednoga dana doći Mesija, zvani Krist—Pomazanik”, reče žena. “Kada on dođe, sve će nam objasniti.” ");
INSERT INTO hrvbib_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Tada joj Isus reče: “Ja, koji govorim s tobom, sam Mesija.” ");
INSERT INTO hrvbib_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Nato stignu njegovi učenici. Začude se što razgovara sa ženom, ali ga nitko ne upita: “O čemu govoriš?”, ili: “Zašto razgovaraš s njom?” ");
INSERT INTO hrvbib_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Žena tada ostavi svoju posudu kraj zdenca pa ode u grad i svima reče: ");
INSERT INTO hrvbib_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Dođite vidjeti čovjeka koji mi je rekao sve što sam dosad učinila! Da to nije Krist?” ");
INSERT INTO hrvbib_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","I ljudi su dolazili iz grada da ga vide. ");
INSERT INTO hrvbib_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","U međuvremenu su ga učenici nudili: “Rabbi, jedi!” ");
INSERT INTO hrvbib_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","“Neću,” odgovarao im je, “ja imam hrane za koju vi i ne znate.” ");
INSERT INTO hrvbib_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","“Zar mu je netko već donio jelo?” pitali su učenici jedan drugoga. ");
INSERT INTO hrvbib_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Isus im tada objasni: “Moja je hrana činiti volju onoga koji me poslao i dovršiti njegovo djelo. ");
INSERT INTO hrvbib_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Vi kažete da rad na žetvi neće početi dok ne mine ljeto, a to je tek za četiri mjeseca. No pogledajte oko sebe! Prostrana polja bjelasaju se svuda i već su spremna za žetvu. ");
INSERT INTO hrvbib_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Žeteoci će biti dobro plaćeni, a plod njihove žetve su ljudi koji su dobili vječni život. Kakve li radosti i za sijače i za žeteoce! ");
INSERT INTO hrvbib_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Istinita je izreka da jedan sije, a drugi žanje. ");
INSERT INTO hrvbib_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ja sam vas poslao da žanjete ondje gdje se niste trudili—drugi su naporno radili, a vi ste dobili plod njihova truda.” ");
INSERT INTO hrvbib_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Mnogi Samarijanci iz toga grada povjerovali su u njega zbog ženina svjedočanstva: “Rekao mi je sve što sam dosad činila!” ");
INSERT INTO hrvbib_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Kad su Samarijanci došli k njemu, zamolili su ga da ostane kod njih. I ostao je ondje dva dana. ");
INSERT INTO hrvbib_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Tada ih je još mnogo više povjerovalo kad su ga čuli govoriti. ");
INSERT INTO hrvbib_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","A ženi su kazali: “Sada vjerujemo jer smo ga i sami čuli, a ne zbog onoga što si nam ti ispričala. On je zaista Spasitelj svijeta!” ");
INSERT INTO hrvbib_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Dva dana nakon toga Isus ode odande u Galileju. ");
INSERT INTO hrvbib_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Sam Isus bijaše rekao da prorok nema časti u vlastitom zavičaju. ");
INSERT INTO hrvbib_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ali Galilejci su ga lijepo primili jer su za svetkovanja Pashe bili u Jeruzalemu i vidjeli njegova čudesna djela. ");
INSERT INTO hrvbib_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Putujući Galilejom, stigao je u grad Kanu, gdje bijaše pretvorio vodu u vino. U gradu Kafarnaumu bio je neki kraljevski činovnik čiji je sin bio bolestan. ");
INSERT INTO hrvbib_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Kad je čuo da je Isus došao iz Judeje i da putuje kroz Galileju, ode u Kanu te zamoli Isusa da dođe u Kafarnaum i iscijeli mu sina na samrti. ");
INSERT INTO hrvbib_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Isus reče: “Vi zaista nećete vjerovati ne vidite li znakove i čudesa.” ");
INSERT INTO hrvbib_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Kraljevski ga je činovnik preklinjao: “Gospodine, molim te, dođi dok mi dijete nije umrlo!” ");
INSERT INTO hrvbib_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","“Idi kući,” reče mu Isus, “sin ti je živ.” Čovjek povjeruje Isusovim riječima i uputi se doma. ");
INSERT INTO hrvbib_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Dok je još bio na putu, susretne svoje sluge koji su nosili vijest da mu je dijete živo. ");
INSERT INTO hrvbib_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Upita ih kada se dječak počeo osjećati bolje, a oni mu rekoše: “Jučer poslijepodne oko jedan sat groznica mu je naglo minula.” ");
INSERT INTO hrvbib_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Otac shvati da je to bilo upravo onda kad mu je Isus rekao: “Sin ti je živ.” Činovnik i svi njegovi ukućani povjeruju u Isusa. ");
INSERT INTO hrvbib_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Bilo je to drugo čudo koje je Isus učinio u Galileji vraćajući se iz Judeje. ");
INSERT INTO hrvbib_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Nakon toga Isus se vrati u Jeruzalem na židovski vjerski blagdan. ");
INSERT INTO hrvbib_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","U gradu se, blizu Ovčjih vrata, nalazio ribnjak s pet natkrivenih trijemova, koji se na hebrejskome zove Bethesda. ");
INSERT INTO hrvbib_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Pod trijemovima je ležalo mnoštvo bolesnika—sakatih, slijepih i uzetih—čekajući da se uzbiba voda ");
INSERT INTO hrvbib_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","jer je anđeo Gospodnji silazio s vremena na vrijeme i gibao vodu, a onaj tko bi nakon toga prvi ušao u vodu ozdravio bi ma od čega bolovao. ");
INSERT INTO hrvbib_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Tu je ležao neki bogalj, bolestan već trideset osam godina. ");
INSERT INTO hrvbib_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Kad ga Isus spazi i dozna kako dugo boluje, upita ga: “Želiš li ozdraviti?” ");
INSERT INTO hrvbib_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","“Ne mogu ozdraviti, Gospodine,” reče čovjek, “jer nemam nikoga da mi pomogne ući u ribnjak kad se voda uzburka. Dok ja pokušavam sići do nje, uvijek me netko pretekne.” ");
INSERT INTO hrvbib_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Isus mu reče: “Ustani, uzmi nosila i idi kući!” ");
INSERT INTO hrvbib_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Čovjek tog trenutka ozdravi. Uzme svoj ležaj i počne hodati uokolo. Toga je dana, međutim, bila subota. ");
INSERT INTO hrvbib_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Židovski vođe stoga prigovoriše iscijeljenom čovjeku: “Ne smiješ raditi u subotu! Noseći taj ležaj, kršiš zakon!” ");
INSERT INTO hrvbib_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","“Onaj koji me ozdravio reče mi: ‘Uzmi svoj ležaj i idi!’” odgovori čovjek. ");
INSERT INTO hrvbib_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","“Tko je taj koji ti je takvo što rekao?” pitali su. ");
INSERT INTO hrvbib_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Iscijeljeni čovjek to nije znao. Isus je nestao u mnoštvu jer je ondje bilo mnogo svijeta. ");
INSERT INTO hrvbib_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Poslije ga Isus pronađe u Hramu i reče mu: “Ozdravio si; ne griješi više da te ne bi i što gore snašlo!” ");
INSERT INTO hrvbib_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Čovjek tada ode i reče židovskim vođama da je Isus taj koji ga je iscijelio. ");
INSERT INTO hrvbib_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Zbog toga Židovi počeše optuživati Isusa da krši zakon o suboti. ");
INSERT INTO hrvbib_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Isus im odgovori: “Moj Otac neprestano radi, a ja slijedim njegov primjer.” ");
INSERT INTO hrvbib_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Od tada su ga židovski vođe još revnije nastojali smaknuti jer ne samo da je kršio njihov zakon o suboti nego je i o Bogu govorio kao o svojem Ocu izjednačujući se tako s njime. ");
INSERT INTO hrvbib_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Isus im reče: “Zaista vam kažem: Sin sam od sebe ne može učiniti ništa. Radi samo ono što vidi da radi i Otac, i to na jednak način. ");
INSERT INTO hrvbib_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Jer Otac voli Sina i pokazuje mu sve što sam čini. Sin će učiniti još mnogo veća čuda nego što je ozdravljenje ovoga čovjeka; čudom ćete se čuditi. ");
INSERT INTO hrvbib_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Od mrtvih će podignuti one koje zaželi, upravo kao što i Otac uskrisuje mrtve i oživljuje ih. ");
INSERT INTO hrvbib_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","A Otac prepušta Sinu svaku osudu. ");
INSERT INTO hrvbib_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Tako će svi slaviti Sina, baš kao što slave i Oca. Tko ne iskazuje čast Božjemu Sinu, kojega je on poslao, sigurno ne proslavlja ni Oca. ");
INSERT INTO hrvbib_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Zaista vam kažem, svatko tko sluša moju poruku i tko vjeruje onome koji me poslao ima vječni život i nikada neće biti osuđen za svoje grijehe jer je već prešao iz smrti u život. ");
INSERT INTO hrvbib_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","I zaista vam kažem da dolazi vrijeme, zapravo je već došlo, kad će mrtvi čuti glas Božjega Sina i oni koji ga poslušaju, živjet će. ");
INSERT INTO hrvbib_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Otac ima život u sebi i svojem je Sinu dao da ima život u sebi. ");
INSERT INTO hrvbib_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Dao mu je i vlast da sudi jer je on Sin Čovječji. ");
INSERT INTO hrvbib_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ne čudite se tomu! Uistinu dolazi vrijeme kad će svi mrtvi u grobovima čuti glas Božjega Sina ");
INSERT INTO hrvbib_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","i ponovno će ustati—oni koji su činili dobro, na uskrsnuće u život, a koji su činili zlo, na uskrsnuće u propast. ");
INSERT INTO hrvbib_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ali ja ne mogu učiniti ništa a da ne upitam Oca. Sudim kako mi je rečeno i moj je sud savršeno pravedan jer ne tražim vlastitu volju, nego sudim prema volji onoga koji me je poslao.” ");
INSERT INTO hrvbib_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Kad bih ja sam za sebe svjedočio, moje svjedočanstvo ne bi bilo vjerodostojno, ");
INSERT INTO hrvbib_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","ali netko drugi svjedoči za mene i uvjeravam vas da je to što on o meni kaže istinito. ");
INSERT INTO hrvbib_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Poslali ste izaslanike da slušaju propovijedi Ivana Krstitelja; sve što je kazao o meni istina je. ");
INSERT INTO hrvbib_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ali najtočnije svjedočanstvo o meni ne dolazi od čovjeka, iako sam vas podsjetio na Ivanovo svjedočanstvo kako biste povjerovali u mene i spasili se. ");
INSERT INTO hrvbib_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ivan je bio svjetiljka koja je gorjela i svijetlila, a vi ste htjeli neko vrijeme uživati u njegovoj svjetlosti. ");
INSERT INTO hrvbib_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ja, međutim, imam veće svjedočanstvo od Ivanova: djela koja činim. Otac mi je dao da ih činim i ona svjedoče o tomu da me je Otac poslao. ");
INSERT INTO hrvbib_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","I sam je Otac svjedočio za mene. Vi niste nikada čuli njegov glas ni vidjeli njegovo lice. ");
INSERT INTO hrvbib_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Njegova riječ ne prebiva u vama jer ne vjerujete meni, koga vam je poslao. ");
INSERT INTO hrvbib_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Vi proučavate Sveto pismo jer mislite da će vam ono dati vječni život. Ono upućuje na mene. ");
INSERT INTO hrvbib_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","A vi ipak nećete doći k meni da biste primili vječni život. ");
INSERT INTO hrvbib_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Ne primam slave od ljudi ");
INSERT INTO hrvbib_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","jer znam da u sebi nemate Božje ljubavi. ");
INSERT INTO hrvbib_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Znam to jer sam vam došao u Očevo ime, a vi me odbijate primiti iako vrlo spremno prihvaćate one koji dolaze samo u vlastito ime. ");
INSERT INTO hrvbib_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Kako biste i mogli vjerovati kad rado primate časti jedni od drugih, a ne marite za to da steknete čast od jedinoga Boga? ");
INSERT INTO hrvbib_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Neću, međutim, ja biti taj koji će vas zbog toga optužiti pred Ocem. Optužit će vas Mojsije. Da, Mojsije u koga se uzdate. ");
INSERT INTO hrvbib_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Jer kad biste vjerovali Mojsiju, koji je pisao o meni, vjerovali biste i meni. ");
INSERT INTO hrvbib_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","A kako ne vjerujete onomu što je on napisao, nije čudno da ne vjerujete ni mojim riječima!” ");
INSERT INTO hrvbib_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Nakon toga Isus prijeđe na drugu stranu Galilejskog jezera (to jest, Tiberijadskog mora). ");
INSERT INTO hrvbib_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Golemo ga je mnoštvo posvuda slijedilo jer su gledali čuda koja je činio iscjeljujući bolesnike. ");
INSERT INTO hrvbib_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Isus se popne na goru i sjedne sa svojim učenicima. ");
INSERT INTO hrvbib_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Bližio se židovski blagdan Pashe. ");
INSERT INTO hrvbib_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Podignuvši pogled, Isus ugleda silno mnoštvo ljudi kako se penje prema njemu. On upita Filipa: “Čime ćemo, Filipe, kupiti kruha da nahranimo sav taj narod?” ");
INSERT INTO hrvbib_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Kušao ga je jer je već znao što će učiniti. ");
INSERT INTO hrvbib_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filip mu odgovori: “Trebalo bi nam cijelo bogatstvo da svatko dobije samo malo hrane!” ");
INSERT INTO hrvbib_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Tada Andrija, brat Šimuna Petra, reče: ");
INSERT INTO hrvbib_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Ovdje je neki dječak s pet ječmenih kruhova i dvije ribice. Ali što je to za toliki narod?” ");
INSERT INTO hrvbib_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","“Neka ljudi sjednu!” zapovjedi Isus. I cijelo mnoštvo—samo je muškaraca bilo oko pet tisuća—posjeda na prostranu livadu. ");
INSERT INTO hrvbib_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Zatim Isus uzme kruhove, zahvali Bogu pa ih razdijeli ljudima koji su sjedili. Potom to učini i s ribama. I svi su se do sita najeli. ");
INSERT INTO hrvbib_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","“A sad pokupite ostatke,” reče Isus učenicima, “tako da ništa ne propadne.” ");
INSERT INTO hrvbib_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Dvanaest su košara napunili ostacima preostalih mnoštvu koje se nahranilo s pet ječmenih kruhova. ");
INSERT INTO hrvbib_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Kad su ljudi shvatili kakvo je silno čudo Isus učinio, povikali su: “On je zaista Prorok koga očekujemo!” ");
INSERT INTO hrvbib_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Kad je Isus znao da su ga spremni pograbiti i učiniti svojim kraljem, ode ponovno u goru, posve sam. ");
INSERT INTO hrvbib_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Uvečer siđu njegovi učenici na obalu da ga pričekaju. ");
INSERT INTO hrvbib_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","No kako je već pao mrak, a Isus se još nije vratio, ukrcaju se u lađu i upute na drugu stranu jezera, prema Kafarnaumu. ");
INSERT INTO hrvbib_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","More je bilo uzburkano jakim vjetrom. ");
INSERT INTO hrvbib_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Kad su otplovili kojih pet kilometara od obale, iznenada opaze Isusa kako hoda po vodi prema lađi. Prestraše se, ");
INSERT INTO hrvbib_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","no on im reče: “Ne bojte se! Ja sam!” ");
INSERT INTO hrvbib_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Htjeli su ga uzeti na lađu, ali lađa se odmah nađe na obali prema kojoj su plovili. ");
INSERT INTO hrvbib_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Drugoga se jutra na obali s druge strane jezera počelo okupljati mnoštvo iščekujući da vidi Isusa. Ljudi su znali da se Isus nije ukrcao s učenicima u lađu i da su oni isplovili bez njega. ");
INSERT INTO hrvbib_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","U blizinu onog mjesta na kojemu su jeli kruh pošto je Gospodin zahvalio Bogu stiglo je nekoliko lađica iz Tiberijade. ");
INSERT INTO hrvbib_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Kad su ljudi vidjeli da ondje nema ni Isusa ni njegovih učenika, ukrcali su se u lađe i otplovili na drugu stranu jezera, u Kafarnaum, ne bi li pronašli Isusa. ");
INSERT INTO hrvbib_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Kad su stigli onamo, pronašli su ga i upitali: “Učitelju, kad si došao ovamo?” ");
INSERT INTO hrvbib_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Isus im odgovori: “Vi uistinu želite biti sa mnom jer ste se nasitili onih kruhova, a ne zato što ste razumjeli značenje čuda koja sam činio. ");
INSERT INTO hrvbib_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Radite, ali ne za propadljivu hranu, već za hranu koja ostaje za vječni život što će vam ga dati Sin Čovječji. Jer ga je Bog Otac za to ovlastio.” ");
INSERT INTO hrvbib_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","“Što nam je činiti da bismo radili djela koja Bog traži?” pitali su. ");
INSERT INTO hrvbib_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","“Djelo je Božje da vjerujte u onoga koga je on poslao”, odgovori Isus. ");
INSERT INTO hrvbib_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","“Kakav ćeš nam znak dati”, pitali su, “da bismo ga vidjeli i povjerovali ti? Kakvo ćeš djelo učiniti? ");
INSERT INTO hrvbib_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Uostalom, naši su preci jeli manu dok su putovali pustinjom! U Svetom pismu stoji: ‘Dao im je za jelo kruh s neba.’” ");
INSERT INTO hrvbib_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Isus im reče: “Zaista vam kažem, nije vam Mojsije dao kruh s neba, nego Otac moj daje vam istinski kruh s neba. ");
INSERT INTO hrvbib_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Pravi je Božji kruh onaj koga je Bog poslao s neba i koji svijetu daje život.” ");
INSERT INTO hrvbib_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","“Gospodine,” kazaše, “daj nam uvijek toga kruha.” ");
INSERT INTO hrvbib_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Isus im odgovori: “Ja sam kruh života. Tko dolazi k meni, neće nikad više ogladnjeti. Koji vjeruju u mene, neće ožednjeti nikada. ");
INSERT INTO hrvbib_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ali, kao što vam rekoh, gledali ste me, a ipak ne vjerujete. ");
INSERT INTO hrvbib_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ali svi oni koje mi je Otac dao, doći će k meni a takve sigurno neću odbaciti. ");
INSERT INTO hrvbib_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Jer ja sam sišao s neba da vršim volju Boga koji me poslao, a ne svoju volju. ");
INSERT INTO hrvbib_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","A Božja je volja da ne izgubim nijednoga od onih koje mi je on dao, nego da ih u posljednji dan uskrisim u vječni život. ");
INSERT INTO hrvbib_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Jer je volja mojeg Oca da svatko tko vidi njegova Sina i tko vjeruje u njega ima vječni život te da ga ja uskrisim u posljednji dan.” ");
INSERT INTO hrvbib_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Židovi su počeli mrmljati protiv njega zato što je o sebi rekao: “Ja sam kruh koji je sišao s neba.” ");
INSERT INTO hrvbib_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","“Pa to je Isus, Josipov sin”, govorili su. “Znamo mu i oca i majku. Kako sad može reći: ‘Sišao sam s neba?’” ");
INSERT INTO hrvbib_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ali Isus im odgovori: “Ne prigovarajte međusobno! ");
INSERT INTO hrvbib_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Nitko ne može doći k meni ako ga ne privuče Otac koji me je poslao, a ja ću sve takve oživjeti u posljednji dan. ");
INSERT INTO hrvbib_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Kao što je zapisano u Svetome pismu: ‘Svi će biti učenici Božji.’ Kojima Otac govori i koji primaju njegovu pouku, doći će k meni. ");
INSERT INTO hrvbib_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","To ne znači da je netko vidio Oca, jer sam ga jedini vidio ja koji od njega dolazim. ");
INSERT INTO hrvbib_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Zaista vam kažem, tko vjeruje u mene, ima vječni život. ");
INSERT INTO hrvbib_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ja sam kruh života. ");
INSERT INTO hrvbib_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Vaši su preci jeli manu u pustinji, ali svi su poumirali. ");
INSERT INTO hrvbib_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ovaj kruh s neba, međutim, svakomu tko ga jede daje vječni život. ");
INSERT INTO hrvbib_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ja sam živi kruh koji je sišao s neba. Jede li tko ovaj kruh, živjet će zauvijek. Kruh koji ću ja dati jest moje tijelo što ću ga predati za život svijeta.” ");
INSERT INTO hrvbib_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Nato se Židovi počnu međusobno prepirati govoreći: “Kako nam ovaj može dati svoje tijelo za jelo?” ");
INSERT INTO hrvbib_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Isus im zato ponovno reče: “Zaista vam kažem, ne jedete li tijela Sina Čovječjega i ne pijete li njegove krvi, ne možete u sebi imati vječni život! ");
INSERT INTO hrvbib_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ali tko god jede moje tijelo i pije moju krv, ima vječni život i ja ću ga uskrisiti u posljednji dan. ");
INSERT INTO hrvbib_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Jer je moje tijelo prava hrana, a moja krv pravo piće. ");
INSERT INTO hrvbib_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Tko jede moje tijelo i tko pije moju krv, ostaje u meni i ja ostajem u njemu. ");
INSERT INTO hrvbib_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Kao što me je poslao živi Otac i kao što ja živim zaradi Oca, tako će i oni koji mene blaguju živjeti zaradi mene. ");
INSERT INTO hrvbib_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ja sam pravi kruh koji je sišao s neba, a ne onakav kakav su jeli vaši oci i svejedno pomrli. Tko jede ovaj kruh, živjet će zauvijek.” ");
INSERT INTO hrvbib_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","To je rekao poučavajući u sinagogi u Kafarnaumu. ");
INSERT INTO hrvbib_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Mnogi njegovi učenici kazaše: “To su vrlo teške riječi. Tko bi razumio što je htio reći?” ");
INSERT INTO hrvbib_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Isus je znao da njegovi učenici prigovaraju pa im reče: “Zar vas to sablažnjava? ");
INSERT INTO hrvbib_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","A što ćete pomisliti ako vidite Sina Čovječjega kako se vraća u nebo? ");
INSERT INTO hrvbib_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Sveti Duh je taj koji daje vječni život. Ljudskim naporima ne može se ništa postignuti. A same riječi koje sam vam rekao jesu Duh i život. ");
INSERT INTO hrvbib_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Pa ipak, neki od vas mi ne vjeruju.” Jer je Isus od početka znao tko u njega ne vjeruje i tko je onaj koji će ga izdati. ");
INSERT INTO hrvbib_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","I još reče: “Na to sam mislio kad sam vam rekao da nitko ne može doći k meni ako ga Otac ne privuče.” ");
INSERT INTO hrvbib_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Mnogi se učenici tada povuku i nisu ga više slijedili. ");
INSERT INTO hrvbib_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Tada se Isus okrene Dvanaestorici i upita ih: “Hoćete li i vi otići?” ");
INSERT INTO hrvbib_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Šimun Petar mu odgovori: “Gospodine, kome da odemo? Samo ti imaš riječi koje daju vječni život, ");
INSERT INTO hrvbib_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","a mi vjerujemo i znamo da si ti Svetac Božji!” ");
INSERT INTO hrvbib_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Zatim im Isus reče: “Sâm izabrah vas Dvanaestoricu, a ipak je jedan od vas đavao.” ");
INSERT INTO hrvbib_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Govorio je o Judi, sinu Šimuna Iškariotskoga, jednome od Dvanaestorice koji ga je poslije izdao. ");
INSERT INTO hrvbib_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Nakon toga je Isus obilazio Galileju. Htio je izbjegnuti Judeju, gdje su ga židovski vođe kanili ubiti. ");
INSERT INTO hrvbib_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Približavao se Blagdan sjenica, jedan od židovskih godišnjih blagdana, ");
INSERT INTO hrvbib_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","pa su ga njegova braća nagovarala da ode u Judeju na svetkovinu. “Otiđi odavde u Judeju, tako da tvoji učenici mogu vidjeti čudesa koja činiš”, rekoše mu. ");
INSERT INTO hrvbib_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","“Ne možeš postati slavnim kad se ovako skrivaš. Ako si tako velik, dokaži to svijetu!” ");
INSERT INTO hrvbib_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Jer mu ni njegova braća nisu vjerovala. ");
INSERT INTO hrvbib_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","“Moje vrijeme još nije došlo,” odgovori im Isus, “ali vi možete otići kad god zaželite jer je za vas vrijeme uvijek pogodno. ");
INSERT INTO hrvbib_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Svijet vas ne mrzi, ali mene mrzi jer svjedočim o njemu da su mu djela zla. ");
INSERT INTO hrvbib_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Samo vi idite, a ja ću doći poslije jer se još nije ispunilo moje vrijeme.” ");
INSERT INTO hrvbib_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Tako im reče i ostane u Galileji. ");
INSERT INTO hrvbib_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ali pošto su njegova braća otišla na proslavu, pođe i on, samo kradomice. ");
INSERT INTO hrvbib_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Židovski vjerski vođe pokušali su ga pronaći na svetkovini i neprestano su zapitkivali je li ga tko vidio. ");
INSERT INTO hrvbib_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","O njemu se u narodu mnogo raspravljalo. Jedni su govorili: “On je divan!” dok su drugi tvrdili: “Nije; obmanjuje narod!” ");
INSERT INTO hrvbib_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ali nitko ga se nije usudio javno zagovarati jer su se ljudi bojali židovskih vjerskih vođa. ");
INSERT INTO hrvbib_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","A Isus usred svetkovine ode u Hram i počne javno propovijedati. ");
INSERT INTO hrvbib_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Kad su ga čuli, židovski se vođe iznenade. “Kako on tako dobro poznaje Sveto pismo, a nikada nije pohađao naše škole?” pitali su se. ");
INSERT INTO hrvbib_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Nato im Isus reče: “Moja pouka nije od mene, nego od onoga koji me je poslao. ");
INSERT INTO hrvbib_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Želi li tko činiti njegovu volju, znat će je li moje učenje od Boga ili govorim sam od sebe. ");
INSERT INTO hrvbib_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Tko iznosi vlastite zamisli, traži slavu za sebe, ali tko želi iskazati čast onome koji ga je poslao, taj je istinit i u njemu nema nepravednosti. ");
INSERT INTO hrvbib_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Nije li vam Mojsije dao Zakon? Pa ipak nitko se od vas ne drži Zakona! Štoviše, pokušavate me ubiti!” ");
INSERT INTO hrvbib_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","“Opsjeo te zloduh!” odgovori mu svjetina. “Tko bi te htio ubiti?” ");
INSERT INTO hrvbib_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Isus im odvrati: “U subotu sam iscijelio čovjeka i to vas je zaprepastilo. ");
INSERT INTO hrvbib_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ali i vi radite subotom kad provodite Mojsijev zakon o obrezanju. Taj je običaj, zapravo, stariji od Mojsijeva zakona; on potječe od praotaca. ");
INSERT INTO hrvbib_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ako dakle pravi trenutak za obrezanje vaših sinova padne u subotu, obavit ćete ga da ne biste prekršili Mojsijev zakon. Zašto onda mene osuđujete što sam u subotu posve iscijelio onoga čovjeka? ");
INSERT INTO hrvbib_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ne sudite prema onome što vidite, već pravedno prosuđujte.” ");
INSERT INTO hrvbib_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Neki su Jeruzalemci međusobno govorili: “Nije li to onaj kojega žele ubiti? ");
INSERT INTO hrvbib_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","A evo, ovdje javno propovijeda i ništa mu ne kažu. Ne znači li to možda da su naši poglavari ipak shvatili kako je on uistinu Krist? ");
INSERT INTO hrvbib_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ali ipak, kako bi to bilo moguće? Jer za ovoga znamo gdje je rođen, a kad se pojavi Krist, nitko neće znati odakle dolazi.” ");
INSERT INTO hrvbib_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Nato Isus, koji je poučavao u Hramu, poviče: “Vi me dakle poznajete i znate odakle dolazim? Nisam ja došao sâm od sebe, nego od Istinitoga koji me je poslao, i njega vi ne poznajete. ");
INSERT INTO hrvbib_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Poznajem ga jer sam bio s njime i on me je poslao k vama.” ");
INSERT INTO hrvbib_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Od tada su židovski poglavari vrebali da ga uhvate, ali ga ipak nitko nije ni taknuo jer još nije došlo njegovo vrijeme. ");
INSERT INTO hrvbib_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ipak, mnogi iz mnoštva povjerovali su u njega. “Kakva bi još čuda trebalo očekivati od Krista kad dođe a da ih ovaj već nije učinio?” govorili su. ");
INSERT INTO hrvbib_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Kad su farizeji čuli kakvo je raspoloženje u mnoštvu, skupa sa svećeničkim poglavarima pošalju stražare da uhvate Isusa. ");
INSERT INTO hrvbib_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ali Isus im reče: “Još ću neko vrijeme biti ovdje s vama, a onda ću se vratiti onome koji me je poslao. ");
INSERT INTO hrvbib_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Tražit ćete me, ali me nećete naći, i nećete moći onamo gdje ću ja biti.” ");
INSERT INTO hrvbib_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ta je izjava zbunila židovske vođe. “Kamo ovaj kani otići a da mi onamo ne možemo?” pitali su se. “Možda misli otići iz zemlje među rasijane Židove i poučavati Grke? ");
INSERT INTO hrvbib_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Na što misli kad kaže da ćemo ga tražiti, a da ga nećemo naći i: ‘Nećete moći onamo gdje ću ja biti’?” ");
INSERT INTO hrvbib_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Na posljednji, veliki dan blagdana Isus poviče mnoštvu: “Ako je tko žedan, neka dođe k meni i neka pije! ");
INSERT INTO hrvbib_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Jer Sveto pismo kaže da će iz nutrine svakoga tko u mene vjeruje poteći rijeke žive vode.” ");
INSERT INTO hrvbib_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Govorio je o Svetom Duhu koji će biti dan svima koji vjeruju u njega. Ali Sveti Duh još nije bio dan jer se Isus još nije vratio u svoju slavu. ");
INSERT INTO hrvbib_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Kad je mnoštvo to čulo, neki su kazali: “Ovaj je čovjek sigurno Prorok.” ");
INSERT INTO hrvbib_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Drugi su rekli: “On je zaista Krist!” A bilo ih je koji su mislili: “Ne, on ne može biti Krist! Zar će Krist doći iz Galileje? ");
INSERT INTO hrvbib_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Ne kaže li Sveto pismo da će se Krist roditi od kraljevske Davidove loze, u Betlehemu, gdje se i David rodio?” ");
INSERT INTO hrvbib_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Tako u mnoštvu zbog njega nasta podjela. ");
INSERT INTO hrvbib_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Neki su ga pokušali uhvatiti, ali ga nitko nije ni dirnuo. ");
INSERT INTO hrvbib_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Stražari iz Hrama, poslani da ga uhvate, vrate se svećeničkim poglavarima i farizejima, a oni ih upitaju: “Zašto ga niste doveli?” ");
INSERT INTO hrvbib_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","“Još nitko nikada nije govorio kao taj čovjek”, odgovore im oni. ");
INSERT INTO hrvbib_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","“Pa nije valjda i vas zaveo?” okome se na njih farizeji. ");
INSERT INTO hrvbib_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","“Je li itko od nas židovskih poglavara ili farizeja povjerovao da je on Krist? ");
INSERT INTO hrvbib_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ali vjeruje mu glupa svjetina koja ne poznaje Zakon. Oni su ionako prokleti!” ");
INSERT INTO hrvbib_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Tada progovori Nikodem, židovski vođa koji je jednom došao Isusu na razgovor: ");
INSERT INTO hrvbib_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Zar naš Zakon sudi čovjeku prije nego što se sasluša i ne ustanovi što je učinio?” upita on. ");
INSERT INTO hrvbib_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","“Zar si i ti bijedni Galilejac? Pogledaj u Sveto pismo i sam se uvjeri da iz Galileje ne dolazi nikakav prorok!” odgovore mu. ");
INSERT INTO hrvbib_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Sastanak je tada prekinut i svi su se razišli domovima. ");
INSERT INTO hrvbib_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Isus se vrati na Maslinsku goru, ");
INSERT INTO hrvbib_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","no rano sljedećeg jutra opet dođe u Hram. Mnoštvo se ubrzo okupi oko njega, a on sjedne i počne ih poučavati. ");
INSERT INTO hrvbib_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Dok je govorio, židovski poglavari i farizeji dovedu mu neku ženu uhvaćenu u preljubu. Postave ju ispred radoznaloga mnoštva. ");
INSERT INTO hrvbib_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","“Učitelju,” rekoše Isusu, “ova je žena zatečena u sâmome činu preljuba. ");
INSERT INTO hrvbib_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Mojsijev nam zakon kaže da bismo ju trebali kamenovati. Što ti na to kažeš?” ");
INSERT INTO hrvbib_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Htjeli su ga navesti da kaže nešto zbog čega bi ga mogli optužiti, ali Isus se samo sagnuo i počeo pisati prstom po prašini. ");
INSERT INTO hrvbib_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Kako su i dalje zahtijevali da im odgovori, on se uspravi i reče im: “Pa dobro, kamenujte ju—ali neka prvi baci kamen na nju onaj od vas koji još nikada nije zgriješio!” ");
INSERT INTO hrvbib_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Zatim se ponovno sagne i nastavi pisati po tlu. ");
INSERT INTO hrvbib_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","A vjerski se poglavari krišom raziđu jedan po jedan, počevši od najstarijega. Isus ostane ispred mnoštva sam sa ženom. ");
INSERT INTO hrvbib_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Opet se uspravi i reče joj: “Gdje su tvoji tužitelji, ženo? Zar te nijedan nije osudio?” ");
INSERT INTO hrvbib_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","“Nijedan, Gospodine”, odgovori žena. A Isus joj reče: “Ni ja te ne osuđujem. Idi i ne griješi više!” ");
INSERT INTO hrvbib_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Isus ponovno reče narodu: “Ja sam svjetlo svijeta. Tko me slijedi, neće se spoticati u tami, već će imati svjetlo koje vodi u život.” ");
INSERT INTO hrvbib_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Farizeji mu odgovore: “Ti svjedočiš sam o sebi i zato što govoriš nije istina!” ");
INSERT INTO hrvbib_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Isus reče: “Govorim istinu, iako svjedočim sam o sebi, jer znam odakle sam došao i kamo idem. A vi to ne znate. ");
INSERT INTO hrvbib_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Vi o meni sudite prema ljudskim mjerilima, ali ja nikoga ne osuđujem. ");
INSERT INTO hrvbib_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","A i kad bih sudio, bio bi to potpuno pravedan sud jer nisam sâm—uza me je Otac koji me poslao. ");
INSERT INTO hrvbib_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Vaš Zakon kaže da svjedočanstvo dvojice, ako je istovjetno, valja prihvatiti kao istinito. ");
INSERT INTO hrvbib_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Evo, ja svjedočim za sebe, a moj je Otac koji me je poslao drugi svjedok.” ");
INSERT INTO hrvbib_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","“Gdje ti je Otac?” upitaju ga. Isus im odgovori: “Ne znate tko sam ja, pa ne znate ni tko mi je Otac. Kad biste mene poznavali, znali biste i njega.” ");
INSERT INTO hrvbib_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Isus je sve to rekao u riznici dok je poučavao u Hramu. Pa ipak, nisu ga uhitili jer još nije došlo njegovo vrijeme. ");
INSERT INTO hrvbib_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Poslije im Isus ponovno reče: “Ja odlazim, a vi ćete me tražiti i umrijet ćete u svojem grijehu. Kamo ja idem, vi ne možete doći.” ");
INSERT INTO hrvbib_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Židovi se nato stanu pitati: “Da se možda ne kani ubiti? Na što je mislio kad je rekao: ‘Kamo ja idem, vi ne možete doći’?” ");
INSERT INTO hrvbib_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","On im tada reče: “Vi ste odozdol, a ja sam odozgor. Vi ste od ovoga svijeta, a ja nisam. ");
INSERT INTO hrvbib_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Eto, zato sam rekao da ćete umrijeti u svojim grijesima. Jer ne povjerujete li da sam onaj koji kažem da jesam, umrijet ćete u svojim grijesima.” ");
INSERT INTO hrvbib_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","“Reci nam tko si”, tražili su. On odgovori: “Ja sam onaj koji vam od početka i tvrdim da jesam. ");
INSERT INTO hrvbib_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Imao bih mnogo toga za vas kazati i osuditi vas za mnogošto, ali neću jer govorim samo ono što mi kaže onaj koji me poslao, a on je Istiniti.” ");
INSERT INTO hrvbib_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Oni, međutim, nisu razumjeli da im govori o Ocu. ");
INSERT INTO hrvbib_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Stoga Isus reče: “Kad podignete Sina Čovječjega na križ, shvatit ćete da sam ja taj i da vam nisam govorio vlastite misli, nego samo ono što me je Otac naučio. ");
INSERT INTO hrvbib_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Onaj koji me je poslao sa mnom je. Ne ostavlja me samoga zato što uvijek činim ono što je njemu ugodno.” ");
INSERT INTO hrvbib_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Mnogi koji su ga čuli da to govori povjeruju u njega. ");
INSERT INTO hrvbib_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Tada Isus reče Židovima koji su mu povjerovali: “Uistinu ste moji učenici ako živite onako kako vam kažem. ");
INSERT INTO hrvbib_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Upoznat ćete istinu, a istina će vas osloboditi.” ");
INSERT INTO hrvbib_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","“Ali mi smo Abrahamovi potomci”, kazaše oni. “Nikad nismo nikome robovali. Kako to misliš—‘oslobodit će vas’?” ");
INSERT INTO hrvbib_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Isus im odgovori: “Svi ste vi robovi grijeha. ");
INSERT INTO hrvbib_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Rob nema stalnog mjesta u obitelji, ali sin joj zauvijek pripada. ");
INSERT INTO hrvbib_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ako vas, dakle, Sin oslobodi, zaista ćete biti slobodni. ");
INSERT INTO hrvbib_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Znam da ste Abrahamovi potomci, ali ipak me neki od vas žele ubiti jer moja riječ ne nalazi odjeka u vašim srcima. ");
INSERT INTO hrvbib_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Govorim vam ono što sam vidio kad sam bio kod Oca. Ali vi ipak slijedite savjet svojega oca.” ");
INSERT INTO hrvbib_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","“Naš je otac Abraham”, odgovore oni. “Da vam je Abraham otac,” reče im Isus, “slijedili biste njegov dobar primjer. ");
INSERT INTO hrvbib_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Umjesto toga, pokušavate me ubiti—samo zato što sam vam govorio istinu koju sam čuo od Boga. Takvo što Abraham nikad nije učinio! ");
INSERT INTO hrvbib_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ne; kad tako postupate, slušate svojega pravog oca.” “Nismo mi rođeni iz preljuba—naš pravi otac je sâm Bog”, odgovore mu. ");
INSERT INTO hrvbib_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Isus im reče: “Kad bi bilo tako, voljeli biste i mene jer sam od Boga izišao i došao k vama. Nisam sâm došao, nego me je on poslao. ");
INSERT INTO hrvbib_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Zašto ne možete shvatiti što vam govorim? Zato što niste kadri slušati moju riječ. ");
INSERT INTO hrvbib_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Jer vam je otac đavao, pa volite činiti zlo koje on čini. On je od početka ubojica i mrzi istinu, jer u njemu nema ni trunka istine. Kad laže, govori što je njegovo jer je lažac i otac laži. ");
INSERT INTO hrvbib_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Zato meni ne vjerujete kad vam govorim istinu. ");
INSERT INTO hrvbib_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Koji mi od vas može dokazati i jedan jedini grijeh? Ako vam govorim istinu, zašto mi ne vjerujete? ");
INSERT INTO hrvbib_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Komu je Otac Bog, rado sluša Božje riječi. Vi ih ne slušate zato što niste njegova djeca.” ");
INSERT INTO hrvbib_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","“Nismo li mi dobro rekli da si Samarijanac i da si opsjednut zloduhom?” ");
INSERT INTO hrvbib_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Isus reče: “Nisam ja opsjednut zloduhom, već poštujem svojeg Oca, a vi me prezirete. ");
INSERT INTO hrvbib_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ionako ne tražim da sebe proslavim. Bog tako želi i On je sudac. ");
INSERT INTO hrvbib_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Zaista vam kažem, tko sluša moje riječi, nikada neće vidjeti smrti.” ");
INSERT INTO hrvbib_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","“Sad znamo da te opsjeo zloduh”, rekoše mu židovski vođe. “Abraham je umro kao i proroci, a ti pak tvrdiš da onaj koji sluša tvoje riječi neće vidjeti smrti! ");
INSERT INTO hrvbib_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Zar si ti veći od našeg oca Abrahama, koji je umro? I od proroka, koji su pomrli? Pa kime se ti praviš?” ");
INSERT INTO hrvbib_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Isus im tada reče: “Hvalim li sâm sebe, to ništa ne vrijedi—no mene proslavlja moj Otac. Za njega vi tvrdite da je vaš Bog, ");
INSERT INTO hrvbib_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","a uopće ga ne poznajete. Ali ja ga poznajem. Kad bih rekao da ga ne poznajem, bio bih lažac kao i vi. No istina je da ga poznajem i da slušam njegove riječi. ");
INSERT INTO hrvbib_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Vaš se otac Abraham radovao mojemu dolasku. Vidio ga je i jako se razveselio.” ");
INSERT INTO hrvbib_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Židovski poglavari rekoše: “Nemaš još ni pedeset godina, a kažeš da si vidio Abrahama!” ");
INSERT INTO hrvbib_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Isus im odvrati: “Zaista vam kažem, Ja jesam, još prije nego što je Abraham i rođen.” ");
INSERT INTO hrvbib_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Nato židovski poglavari pograbe kamenje da ga ubiju, ali Isus kradomice iziđe iz Hrama. ");
INSERT INTO hrvbib_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Prolazeći onuda, ugleda čovjeka slijepoga od rođenja. ");
INSERT INTO hrvbib_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Učenici ga zapitaju: “Učitelju, zašto se ovaj čovjek rodio slijep? Zbog svojih grijeha ili zbog grijeha svojih roditelja?” ");
INSERT INTO hrvbib_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","“Ni zbog svojih, ni zbog roditeljskih grijeha,” odgovori Isus, “već zato da se na njemu očituju Božja djela. ");
INSERT INTO hrvbib_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Dok je dan, treba da radimo djela onoga koji me je poslao. Bliži se tama u kojoj prestaje svako djelo. ");
INSERT INTO hrvbib_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ali dok sam na svijetu, svjetlo sam svijeta.” ");
INSERT INTO hrvbib_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Zatim pljune na zemlju, od pljuvačke načini blato, premaže njime slijepčeve oči ");
INSERT INTO hrvbib_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","i reče mu: “Idi i operi se u ribnjaku Siloamu.” (Siloam znači “Poslan”.) Čovjek ode kamo ga je poslao, umije se i vrati se gledajući. ");
INSERT INTO hrvbib_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Susjedi i svi oni koji su ga prije poznavali kao slijepog prosjaka pitali su jedni druge: “Zar je to onaj slijepi prosjak?” ");
INSERT INTO hrvbib_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Jedni su govorili: “Jest”, a drugi opet: “Nije; to ne može biti isti čovjek, ali neobično mu je sličan.” Prosjak je pak tvrdio: “Ja sam taj isti čovjek.” ");
INSERT INTO hrvbib_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Nato ga zapitaše kako to da vidi. “Što ti se dogodilo?” ");
INSERT INTO hrvbib_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","“Neki je čovjek, imenom Isus, načinio blato, premazao mi njime oči i rekao da odem do ribnjaka Siloama i da sperem blato. Učinio sam tako i sad vidim!” ispriča im čovjek. ");
INSERT INTO hrvbib_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","“Gdje je sada taj čovjek?” zapitaju ga. “Ne znam”, odgovori. ");
INSERT INTO hrvbib_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Tada bivšega slijepca odvedu farizejima. ");
INSERT INTO hrvbib_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Toga je dana, kad je Isus napravio blato i vratio mu vid, bila subota. ");
INSERT INTO hrvbib_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Farizeji su ga iznova o svemu ispitali. On im opet reče: “Premazao mi je oči blatom, a onda sam se umio i progledao!” ");
INSERT INTO hrvbib_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Neki farizeji kazaše: “Onda taj Isus nije od Boga jer krši subotu.” Drugi su pak rekli: “Ali kako bi običan grešnik mogao činiti takva čuda?” I tako među njima nastane velik razdor. ");
INSERT INTO hrvbib_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Nakon toga farizeji opet upitaju nekadašnjeg slijepca: “Što ti kažeš o tom čovjeku koji ti je vratio vid?” “On je prorok”, odgovori čovjek. ");
INSERT INTO hrvbib_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Židovski poglavari nisu vjerovali da je on zaista bio slijep i da je progledao sve dok nisu dozvali njegove roditelje ");
INSERT INTO hrvbib_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","i zapitali ih: “Je li ovo vaš sin za kojega tvrdite da se slijep rodio? Kako to da sada vidi?” ");
INSERT INTO hrvbib_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Roditelji odgovore: “Znamo da je ovo naš sin i da se rodio slijep. ");
INSERT INTO hrvbib_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ali ne znamo što mu se dogodilo da je odjednom progledao ni tko mu je to učinio. Dovoljno je star da sam govori. Njega upitajte!” ");
INSERT INTO hrvbib_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Tako su rekli zbog straha od židovskih poglavara koji su objavili da će svatko tko prizna Isusa za Mesiju biti izopćen. ");
INSERT INTO hrvbib_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Zato odgovore: “Dovoljno je star da sam govori. Njega upitajte!” ");
INSERT INTO hrvbib_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Farizeji tada drugi put pozovu bivšega slijepca: “Odaj slavu Bogu, a ne Isusu jer znamo da je on grešnik.” ");
INSERT INTO hrvbib_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","“Je li grešnik, ne znam,” odgovori čovjek, “ali jedno znam: bio sam slijep, a sada vidim!” ");
INSERT INTO hrvbib_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","“Ali što ti je učinio?” upitaju ga. “Kako ti je vratio vid?” ");
INSERT INTO hrvbib_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","“Već sam vam jedanput rekao, ali me niste slušali. Zašto želite opet čuti? Zar i vi kanite postati njegovim učenicima?” ");
INSERT INTO hrvbib_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Tada ga počnu vrijeđati: “Ti si njegov učenik, a mi smo Mojsijevi učenici. ");
INSERT INTO hrvbib_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Znamo da je Bog govorio Mojsiju, a za ovoga ne znamo ništa, pa čak ni odakle je!” ");
INSERT INTO hrvbib_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","“To i jest čudno”, odgovori čovjek. “Vratio mi je vid, a vi još ne znate ni odakle je! ");
INSERT INTO hrvbib_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Znamo da Bog ne sluša grešnike, ali sluša one koji ga poštuju i vrše njegovu volju. ");
INSERT INTO hrvbib_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Nikada se još nije čulo da je tko vratio vid slijepcu od rođenja. ");
INSERT INTO hrvbib_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Da taj čovjek nije od Boga, ne bi mogao takvo što učiniti.” ");
INSERT INTO hrvbib_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","“Zar ćeš nas ti učiti, koji si rođen u grijehu?” poviču oni i izbace ga iz sinagoge. ");
INSERT INTO hrvbib_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Kad je Isus čuo što se dogodilo, pronađe čovjeka i reče mu: “Vjeruješ li u Sina Čovječjega?” ");
INSERT INTO hrvbib_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Čovjek odgovori: “A tko je on, gospodine, da u njega vjerujem?” ");
INSERT INTO hrvbib_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","“Vidio si ga već”, reče mu Isus. “Upravo razgovara s tobom.” ");
INSERT INTO hrvbib_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","A čovjek reče: “Da, Gospodine, vjerujem!” i padne ničice pred Isusom. ");
INSERT INTO hrvbib_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Isus tada reče: “Došao sam na osudu svijetu: da progledaju oni koji ne vide te da oslijepe oni koji vide.” ");
INSERT INTO hrvbib_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Farizeji koji su ondje stajali zapitaju ga: “Tvrdiš li ti to da smo mi slijepi?” ");
INSERT INTO hrvbib_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","“Da ste slijepi, ne biste imali grijeha”, odgovori im Isus. “Ali vaš grijeh ostaje jer tvrdite da vidite.” ");
INSERT INTO hrvbib_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“Zaista vam kažem, svatko tko u ovčinjak ne ulazi na vrata, nego se šulja preko zida, sigurno je lopov i razbojnik. ");
INSERT INTO hrvbib_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Jer pastir ulazi na vrata. ");
INSERT INTO hrvbib_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Njemu vratar otvara vrata, a ovce slušaju njegov glas i dolaze mu. On svoje ovce zove imenom te ih izvodi van. ");
INSERT INTO hrvbib_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ide pred njima, a one ga slijede jer mu poznaju glas. ");
INSERT INTO hrvbib_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Za strancem neće poći, već će od njega pobjeći jer ne poznaju glas tuđinca.” ");
INSERT INTO hrvbib_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Oni koji su čuli tu Isusovu prispodobu nisu shvatili što je njome htio reći. ");
INSERT INTO hrvbib_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Zato im ju on objasni: “Zaista vam kažem, ja sam vrata ovcama. ");
INSERT INTO hrvbib_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Svi koji su došli prije mene bili su lopovi i razbojnici. Ali prave ih ovce nisu poslušale. ");
INSERT INTO hrvbib_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ja sam vrata. Koji su ušli kroz vrata, bit će spašeni, ulazit će i izlaziti te nalaziti zelenu pašu. ");
INSERT INTO hrvbib_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Nakana je lopova da ukrade, zakolje i uništi. Ja sam došao da dadem vječni život, i to da ga imaju u izobilju. ");
INSERT INTO hrvbib_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ja sam dobri pastir. Dobri pastir daje svoj život za ovce. ");
INSERT INTO hrvbib_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Najamnik će pobjeći i napustiti ovce kad vidi da dolazi vuk jer nisu njegove i jer on nije njihov pastir. Vuk ih onda grabi i razgoni stado. ");
INSERT INTO hrvbib_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Najamnik bježi jer je unajmljen i ne mari za ovce. ");
INSERT INTO hrvbib_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Ja sam dobri pastir. Poznajem svoje ovce i one poznaju mene, ");
INSERT INTO hrvbib_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","kao što Otac poznaje mene i kao što ja poznajem Oca. Ja dajem svoj život za ovce. ");
INSERT INTO hrvbib_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Imam i drugih ovaca, koje nisu iz ovog ovčinjaka. I njih mi valja dovesti. One će čuti moj glas, pa će tako biti jedno stado s jednim pastirom. ");
INSERT INTO hrvbib_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Otac me voli jer dajem svoj život da bih ga opet mogao uzeti. ");
INSERT INTO hrvbib_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Nitko mi ga ne može oduzeti bez mojega pristanka; dobrovoljno dajem svoj život. Imam vlast dati ga i uzeti ga natrag. Tu mi je zapovijed dao Otac.” ");
INSERT INTO hrvbib_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Kad to reče, Židovi opet ostanu podijeljenih mišljenja. ");
INSERT INTO hrvbib_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Neki su govorili: “Opsjednut je zloduhom i luduje. Čemu slušati takvog čovjeka?” ");
INSERT INTO hrvbib_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","“Ne govori kao da je opsjednut”, govorili su drugi. “Zar bi zloduh mogao slijepcu vratiti vid?” ");
INSERT INTO hrvbib_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","U Jeruzalemu bijaše zima. Svetkovao se blagdan Posvete Hrama. ");
INSERT INTO hrvbib_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Isus je prolazio Salomonovim trijemom u Hramu. ");
INSERT INTO hrvbib_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Opkole ga židovski vođe i upitaju ga: “Dokle ćeš nas držati u nedoumici? Ako si ti Krist, otvoreno nam to reci!” ");
INSERT INTO hrvbib_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","“Već sam vam rekao pa mi niste vjerovali”, odgovori im Isus. “Dokaz su djela koja činim u ime svojeg Oca. ");
INSERT INTO hrvbib_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ali vi mi ne vjerujete jer niste od mojega stada. ");
INSERT INTO hrvbib_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Moje ovce slušaju moj glas, ja ih poznajem i one me slijede. ");
INSERT INTO hrvbib_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Dajem im vječni život te neće nikad propasti. Nitko ih neće oteti iz moje ruke. ");
INSERT INTO hrvbib_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Otac moj, koji mi ih je dao, je jači od svih. Zato ih nitko ne može ugrabiti iz Očeve ruke. ");
INSERT INTO hrvbib_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ja i Otac jedno smo.” ");
INSERT INTO hrvbib_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Tada židovski vođe opet pograbe kamenje da ga kamenuju. ");
INSERT INTO hrvbib_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Isus im reče: “Po Božjemu sam nalogu učinio mnoga dobra djela da pomognem narodu. Za koje me od tih djela želite kamenovati?” ");
INSERT INTO hrvbib_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","“Ne činimo to zbog dobrih djela,” odgovore oni, “već zbog svetogrđa. Običan si čovjek, a praviš se Bogom!” ");
INSERT INTO hrvbib_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","“Ne piše li u vašem Zakonu: ‘Ja rekoh, vi ste bogovi!’” odgovori on. ");
INSERT INTO hrvbib_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","“Ako dakle Sveto pismo, koje se ne može promijeniti, bogovima naziva ljude kojima je upućena Božja riječ, ");
INSERT INTO hrvbib_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","zašto meni, koga je Otac poslao u svijet i posvetio, kažete da hulim zato što kažem: ‘Sin sam Božji’? ");
INSERT INTO hrvbib_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Nemojte mi vjerovati ako ne činim djela svojega Oca. ");
INSERT INTO hrvbib_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ali ako ih činim, vjerujte barem tim djelima kad već meni ne vjerujete. Uvjerite se da je Otac u meni i ja u njemu.” ");
INSERT INTO hrvbib_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Tada ga opet pokušaju uhvatiti, no on im umakne. ");
INSERT INTO hrvbib_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Prijeđe na drugu stranu Jordana, na mjesto gdje je prije Ivan krstio, i ondje ostane. ");
INSERT INTO hrvbib_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Mnogi pođu za njim. “Ivan nije činio čudesa,” govorili su ljudi među sobom, “ali sve što je prorekao za ovog čovjeka bila je istina.” ");
INSERT INTO hrvbib_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","I mnogi ondje povjeruju u njega. ");
INSERT INTO hrvbib_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Neki se čovjek imenom Lazar razbolio. Živio je u Betaniji sa sestrama Marijom i Martom. ");
INSERT INTO hrvbib_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Bila je to ona Marija koja je izlila dragocjenu miomirisnu pomast na Gospodinove noge i otrla ih svojom kosom. Kako im je brat Lazar bio bolestan, ");
INSERT INTO hrvbib_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","sestre pošalju Isusu poruku: “Gospodine, tvoj je voljeni prijatelj teško bolestan.” ");
INSERT INTO hrvbib_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Kad je Isus to čuo, reče: “Njegova bolest nije na smrt, nego na Božju slavu. Božji Sin će se ovom prigodom proslaviti.” ");
INSERT INTO hrvbib_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Iako je Isus žarko volio Martu, Mariju i Lazara, ");
INSERT INTO hrvbib_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","nije odmah krenuo, nego je ostao još dva dana u mjestu u kojemu se nalazio. ");
INSERT INTO hrvbib_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Nakon dva dana napokon reče učenicima: “Hajdemo natrag u Judeju!” ");
INSERT INTO hrvbib_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ali učenici se usprotive. “Učitelju,” rekoše mu, “zar te nisu prije nekoliko dana židovski vođe u Judeji htjeli ubiti, a ti hoćeš onamo?” ");
INSERT INTO hrvbib_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Isus odgovori: “Dvanaest ura traje dan i oni koji hodaju u svjetlu neće se spotaknuti jer vide svjetlo ovoga svijeta. ");
INSERT INTO hrvbib_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Koji hodaju u mraku, spotiču se jer u sebi nemaju svjetla.” ");
INSERT INTO hrvbib_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Zatim reče: “Naš prijatelj spava, ali idem ga probuditi.” ");
INSERT INTO hrvbib_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Učenici su rekli: “Gospodine, ako spava, znači da ozdravit će!” ");
INSERT INTO hrvbib_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Mislili su da Isus želi reći kako Lazar zaista spava, ali Isus je htio kazati da je umro. ");
INSERT INTO hrvbib_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Tada im posve otvoreno reče: “Lazar je umro. ");
INSERT INTO hrvbib_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Radi vas se radujem što nisam bio ondje jer će vam ovo biti nova prilika da vjerujete u mene. Hajdemo k njemu!” ");
INSERT INTO hrvbib_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Nato Toma, zvani Blizanac, reče drugim učenicima: “Hajdemo i mi s njime umrijeti!” ");
INSERT INTO hrvbib_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Kad je Isus došao u Betaniju, rekoše mu da Lazar već četiri dana leži u grobu. ");
INSERT INTO hrvbib_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betanija je od Jeruzalema bila udaljena otprilike tri kilometra, ");
INSERT INTO hrvbib_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","pa je mnogo Židova došlo izraziti sućut i utješiti Martu i Mariju zbog gubitka brata. ");
INSERT INTO hrvbib_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Kad je Marta čula da Isus stiže, pođe mu u susret, a Marija ostane u kući. ");
INSERT INTO hrvbib_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta reče Isusu: “Gospodine, da si ti bio ovdje, moj brat ne bi umro! ");
INSERT INTO hrvbib_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ali ipak znam da će ti Bog dati sve što od njega zatražiš.” ");
INSERT INTO hrvbib_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","“Tvoj će brat uskrsnuti!” reče joj Isus. ");
INSERT INTO hrvbib_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","“Hoće”, reče Marta, “kad i svi drugi, o uskrsnuću u posljednji dan.” ");
INSERT INTO hrvbib_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","“Ja sam uskrsnuće i život”, reče joj Isus. “Tko u mene vjeruje, ako i umre, živjet će. ");
INSERT INTO hrvbib_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Tko god je živ i vjeruje u mene, neće nikada umrijeti. Vjeruješ li u to, Marta?” ");
INSERT INTO hrvbib_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","“Da, Gospodine,” odgovori ona, “vjerujem da si ti Krist, Božji Sin koji treba da dođe na svijet.” ");
INSERT INTO hrvbib_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Zatim ode natrag Mariji i krišom joj reče: “Stigao je Učitelj i želi te vidjeti.” ");
INSERT INTO hrvbib_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Kada je Marija to čula, brzo ustane i odmah pođe k njemu. ");
INSERT INTO hrvbib_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Isus je još bio izvan sela, na mjestu gdje ga je susrela Marta. ");
INSERT INTO hrvbib_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Kada su Židovi koji su bili u Marijinoj kući i tješili je vidjeli da tako žurno odlazi, pođu za njom. Mislili su, naime, da ide na grob oplakivati brata. ");
INSERT INTO hrvbib_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Kad je Marija stigla do Isusa, padne pred njim ničice i reče: “Gospodine, da si ti bio ovdje, moj brat ne bi umro!” ");
INSERT INTO hrvbib_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Kad Isus ugleda nju i Židove koji su došli s njom kako plaču, ostane duboko dirnut i potresen. ");
INSERT INTO hrvbib_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","“Kamo ste ga položili?” upita ih. “Dođi i pogledaj”, odgovore. ");
INSERT INTO hrvbib_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Isus zaplače. ");
INSERT INTO hrvbib_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","“Gledajte kako ga je volio!”, govorili su Židovi. ");
INSERT INTO hrvbib_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","A neki rekoše: “Zar taj koji je slijepcu vratio vid nije mogao spriječiti Lazarovu smrt?” ");
INSERT INTO hrvbib_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Isus opet ostane duboko dirnut. Uto stignu do groba. Bila je to špilja s teškim kamenom navaljenim na otvor. ");
INSERT INTO hrvbib_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","“Odmaknite kamen!” zapovjedi Isus. Ali pokojnikova sestra Marta reče: “Gospodine, mora da je vonj već strašan jer je prošlo četiri dana otkako je umro!” ");
INSERT INTO hrvbib_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","“Nisam li ti rekao da ćeš, budeš li vjerovala, vidjeti Božju slavu?” upita ju Isus. ");
INSERT INTO hrvbib_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","I tako odmaknu kamen s groba. Isus pogleda u nebo i reče: “Hvala ti, Oče, što si me uslišao. ");
INSERT INTO hrvbib_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Znam da me ti uvijek uslišavaš, ali to sam rekao zbog ovih ljudi, kako bi vjerovali da si me ti poslao.” ");
INSERT INTO hrvbib_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Zatim glasno vikne: “Lazare, iziđi!” ");
INSERT INTO hrvbib_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","I Lazar iziđe—sav u povojima i lica zamotana u ručnik. Isus im reče: “Odvežite ga i pustite ga da ide!” ");
INSERT INTO hrvbib_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Kad brojni Židovi koji su bili s Marijom ugledali što se dogodilo, napokon povjeruju u njega. ");
INSERT INTO hrvbib_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ali neki odu javiti farizejima što je Isus učinio. ");
INSERT INTO hrvbib_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Stoga svećenički glavari i farizeji sazovu Veliko vijeće da se dogovore što učiniti. “Što da radimo?” pitali su jedan drugoga. “Jer ovaj čovjek zaista čini čudesa. ");
INSERT INTO hrvbib_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ako ga pustimo na miru, sav će ga narod slijediti i povjerovati u njega, a onda će doći rimska vojska, pobiti nas i preuzeti vlast.” ");
INSERT INTO hrvbib_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","A jedan od njih, Kajfa, koji je te godine bio veliki svećenik, reče: “Ništa vi ne znate! ");
INSERT INTO hrvbib_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ne razumijete da je za vas bolje da jedan čovjek umre za narod, umjesto da sav narod izgine?” ");
INSERT INTO hrvbib_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kajfa to nije rekao po vlastitoj pameti. On je te godine bio veliki svećenik te je tako prorekao da će Isus umrijeti za sav narod, ");
INSERT INTO hrvbib_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","i to ne samo za izraelski narod već da bi okupio svu Božju djecu rasutu po svijetu. ");
INSERT INTO hrvbib_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Toga dana istaknuti židovski vođe odluče ubiti Isusa. ");
INSERT INTO hrvbib_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Zbog toga se Isus više nije javno kretao među Židovima, već ode u blizinu pustinje, u Efrajim, i ondje ostane s učenicima. ");
INSERT INTO hrvbib_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Bližio se židovski blagdan Pasha, pa su mnogi ljudi dolazili u Jeruzalem nekoliko dana prije kako bi prije početka svetkovine obavili obred očišćenja. ");
INSERT INTO hrvbib_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Željeli su vidjeti Isusa. Razgovarajući u Hramu, pitali su jedni druge: “Što mislite, hoće li doći na Pashu?” ");
INSERT INTO hrvbib_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","U međuvremenu su glavni svećenici i farizeji zapovjedili da svatko tko dozna gdje je Isus mora to odmah prijaviti kako bi ga uhvatili. ");
INSERT INTO hrvbib_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Šest dana prije početka svetkovine Pashe Isus je stigao u Betaniju, gdje je živio Lazar kojega je uskrisio od mrtvih. ");
INSERT INTO hrvbib_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","U Isusovu čast prirede gozbu. Marta je posluživala, a Lazar je sjedio s njim za stolom. ");
INSERT INTO hrvbib_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Tada Marija uzme litru skupocjena nardova mirisna ulja, pomaže Isusu noge i otre ih svojom kosom. Sva se kuća napuni mirisom. ");
INSERT INTO hrvbib_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ali Juda Iškariotski—jedan od Isusovih učenika, koji ga je poslije izdao, reče: ");
INSERT INTO hrvbib_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Zašto se ta pomast nije prodala za trista denara i razdala siromasima?” ");
INSERT INTO hrvbib_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Nije to rekao zato što je mario za siromahe, nego zato što bijaše kradljivac koji je uzimao novac učenika za koji je bio zadužen. ");
INSERT INTO hrvbib_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Isus mu odgovori: “Pusti ju na miru! To je učinila da me pripremi za ukop. ");
INSERT INTO hrvbib_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Uvijek će biti siromaha, a ja neću uvijek biti s vama.” ");
INSERT INTO hrvbib_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Kad su mnogi iz Jeruzalema čuli da je Isus ondje, sjate se da bi vidjeli ne samo njega nego i Lazara kojega je Isus uskrisio od mrtvih. ");
INSERT INTO hrvbib_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Tada svećenički glavari odluče ubiti i Lazara ");
INSERT INTO hrvbib_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","jer su zbog njega mnogi Židovi napuštali njih i vjerovali u Isusa. ");
INSERT INTO hrvbib_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Sutradan se mjestom pročulo da Isus putuje prema Jeruzalemu, pa veliko mnoštvo, okupljeno zbog Pashe, ");
INSERT INTO hrvbib_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","uzme palmine grane i pođe mu u susret ulicom kličući: “Slava Bogu! Blagoslovljen koji dolazi u ime Gospodnje! Živio kralj Izraelov!” ");
INSERT INTO hrvbib_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Isus pronađe mlado magare i sjedne na njega kako bi se ispunilo proročanstvo: ");
INSERT INTO hrvbib_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Ne boj se, narode izraelski! Evo, dolazi tvoj Kralj sjedeći na magaretu.” ");
INSERT INTO hrvbib_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Njegovi učenici tada još nisu shvatili da se tako ispunjuje proročanstvo. Ali kada se Isus poslije vratio u svoju slavu, u nebo, sjetili su se da se to proročanstvo iz Svetoga pisma obistinilo pred njihovim očima. ");
INSERT INTO hrvbib_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","A ljudi iz mnoštva koji su vidjeli kako je Isus prizvao Lazara natrag u život svjedočili su o tome drugima. ");
INSERT INTO hrvbib_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","U susret mu iziđe silno mnoštvo ljudi jer su čuli za to nevjerojatno čudo. ");
INSERT INTO hrvbib_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Tada farizeji rekoše: “Ništa nismo postignuli! Pogledajte, svi odlaze za njim!” ");
INSERT INTO hrvbib_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Neki Grci koji su došli u Jeruzalem na svetkovinu Pashe ");
INSERT INTO hrvbib_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","priđu Filipu, koji je bio iz Betsaide u Galileji, pa mu rekoše: “Gospodine, htjeli bismo vidjeti Isusa.” ");
INSERT INTO hrvbib_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filip je to prenio Andriji, pa su onda skupa otišli kazati Isusu. ");
INSERT INTO hrvbib_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Isus reče: “Došlo je vrijeme da se otkrije slava Sina Čovječjega. ");
INSERT INTO hrvbib_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Zaista vam kažem, ne padne li pšenično zrno u tlo i ne umre li, ostaje samo. Umre li, naprotiv, donijet će mnogo roda. ");
INSERT INTO hrvbib_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Tko voli svoj život, izgubit će ga, a tko prezre život u ovome svijetu, sačuvat će ga za vječni život. ");
INSERT INTO hrvbib_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Svi koji žele biti mojim učenicima moraju doći i slijediti me jer moje sluge moraju biti ondje gdje sam ja. A budu li me slijedili, moj će ih Otac poštivati. ");
INSERT INTO hrvbib_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Sad mi je duša duboko potresena. Zar da Oca molim: ‘Oče, spasi me od ovoga što me čeka’? A zbog toga sam i došao! ");
INSERT INTO hrvbib_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Oče, proslavi svoje ime!” Tada se začuje glas s neba: “Već sam ga proslavio i opet ću ga proslaviti!” ");
INSERT INTO hrvbib_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Kad je to čulo mnoštvo, neki pomisle da je zagrmjelo, dok su drugi kazali da je Isusu progovorio anđeo. ");
INSERT INTO hrvbib_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Tada im Isus reče: “Glas je govorio radi vas, a ne radi mene. ");
INSERT INTO hrvbib_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Sad je vrijeme suda ovome svijetu! Sada će knez ovoga svijeta biti izbačen! ");
INSERT INTO hrvbib_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","A kad ja budem uzdignut sa zemlje, sve ću ljude privući k sebi.” ");
INSERT INTO hrvbib_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","To je rekao da istakne kakvom će smrću umrijeti. ");
INSERT INTO hrvbib_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","“Uzdignut?” zaprepastilo se mnoštvo. “Iz Svetoga pisma smo učili da će Krist zauvijek živjeti. Zašto govoriš da Sin Čovječji mora biti uzdignut? Tko je taj Sin Čovječji o kojemu govoriš?” ");
INSERT INTO hrvbib_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Isus im odgovori: “Moje će vam svjetlo još samo malo svijetliti. Hodajte u svjetlu dok još možete da vas ne preplavi tama. U mraku čovjek ne vidi kamo ide. ");
INSERT INTO hrvbib_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Vjerujte u svjetlo, dok ga još imate, da budete djecom svjetla!” Nakon toga Isus ode i skrije se od njih. ");
INSERT INTO hrvbib_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Pa ipak, unatoč svim čudima koja je pred njima učinio, većina ih ipak nije vjerovala u njega. ");
INSERT INTO hrvbib_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","A upravo je to pretkazao prorok Izaija: “Gospodine, tko je povjerovao našoj poruci? Kome se objavila snaga Gospodnja?” ");
INSERT INTO hrvbib_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Nisu mogli vjerovati jer je Izaija također rekao: ");
INSERT INTO hrvbib_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Bog im je zaslijepio oči i otvrdnuo srca tako da očima ne vide, srcem ne razumiju, niti se meni obraćaju da ih ozdravim.” ");
INSERT INTO hrvbib_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","To je rekao Izaija, koji je vidio njegovu slavu i o njemu govorio. ");
INSERT INTO hrvbib_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ipak su i mnogi židovski vođe vjerovali da je Isus Mesija, ali to nisu htjeli priznati zbog straha da će ih farizeji izopćiti iz sinagoge. ");
INSERT INTO hrvbib_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ljudska im je slava bila draža od Božja. ");
INSERT INTO hrvbib_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Isus poviče mnoštvu: “Tko vjeruje u mene, vjeruje u onoga koji me poslao. ");
INSERT INTO hrvbib_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Jer kad mene gledate, vidite onoga koji me je poslao. ");
INSERT INTO hrvbib_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ja, svjetlo, došao sam na svijet da svi koji u mene vjeruju više ne ostanu u tami. ");
INSERT INTO hrvbib_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Čuje li tko moje riječi, a ne posluša ih, neću mu ja suditi—jer sam došao spasiti svijet, a ne osuditi ga. ");
INSERT INTO hrvbib_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Tko me prezre i ne primi mojih riječi, imat će svojeg suca. U posljednji će mu dan suditi riječ koju sam vam navješćivao. ");
INSERT INTO hrvbib_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Jer ja nisam govorio sam od sebe, nego vam kazujem ono što mi je Otac zapovjedio. ");
INSERT INTO hrvbib_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Znam da je njegova zapovijed vječni život i kad vam govorim, govorim vam ono što je meni rekao Otac.” ");
INSERT INTO hrvbib_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Večer uoči Pashe, znajući da je došao trenutak da ode sa zemlje svojemu Ocu i voleći svoje koji su na svijetu, Isus je vokio svoje učenike do samoga kraja. ");
INSERT INTO hrvbib_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Za vrijeme večere đavao je već dao mig Judi Iškariotskomu, Šimunovu sinu, da je to noć u kojoj će izdati Isusa. ");
INSERT INTO hrvbib_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","A Isus, svjestan da mu je Otac predao sve u ruke, da je od Boga došao i da mu se vraća, ");
INSERT INTO hrvbib_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","ustane od stola, skine gornju odjeću, opaše se ručnikom, ");
INSERT INTO hrvbib_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","nalije vode te počne učenicima prati noge i brisati ih ručnikom kojim se opasao. ");
INSERT INTO hrvbib_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Kad je došao do Šimuna Petra, on mu reče: “Učitelju, nećeš valjda ti meni prati noge!” ");
INSERT INTO hrvbib_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Isus mu odgovori: “Sada još ne razumiješ zašto to radim, ali jednog ćeš dana shvatiti.” ");
INSERT INTO hrvbib_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","“Ne,” prosvjedovao je Petar, “nikad ti nećeš meni prati noge!” “Ali ako te ne operem, ne možeš biti jedan od mojih”, odgovori mu Isus. ");
INSERT INTO hrvbib_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Šimun Petar nato poviče: “Gospodine, operi mi onda i ruke i glavu, a ne samo noge!” ");
INSERT INTO hrvbib_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Isus odgovori: “Tko je sav okupan, ne treba mu prati drugo osim nogu da bude posve čist. Sada ste čisti, ali ipak ne svi.” ");
INSERT INTO hrvbib_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Isus je, naime, znao tko će ga izdati. Zato je i rekao: “Niste svi čisti.” ");
INSERT INTO hrvbib_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Kad im opere noge, ponovno se obuče, sjedne i upita: “Razumijete li što sam vam učinio? ");
INSERT INTO hrvbib_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Vi me zovete ‘Učiteljem’ i ‘Gospodinom’. Imate pravo! To i jesam. ");
INSERT INTO hrvbib_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","I zato, ako sam ja, Gospodin i Učitelj, vama oprao noge, trebate i vi prati noge jedni drugima. ");
INSERT INTO hrvbib_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Dao sam vam primjer, činite kao što sam i ja učinio. ");
INSERT INTO hrvbib_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Zaista vam kažem, nije sluga veći od svojega gospodara niti je poslanik veći od onoga koji ga šalje. ");
INSERT INTO hrvbib_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","To znate, a blago vama budete li tako i činili!” ");
INSERT INTO hrvbib_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Ne govorim o svima vama, iako dobro poznajem vas koje sam odabrao. Sveto pismo kaže: ‘Onaj koji je sa mnom blagovao, podiže se na me.’ ");
INSERT INTO hrvbib_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Velim vam ovo već sada, prije nego što se dogodi, da kad se dogodi, vjerujete da Ja jesam. ");
INSERT INTO hrvbib_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Zaista vam kažem, tko lijepo primi onoga koga ja šaljem, prima mene. A primi li tko mene, znači da je primio Oca koji me je poslao.” ");
INSERT INTO hrvbib_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Rekavši to, duboko potresen u duhu, Isus im otvoreno reče: “Zaista vam kažem, jedan od vas će me izdati!” ");
INSERT INTO hrvbib_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Učenici pogledaju jedan drugoga pitajući se na koga bi se to moglo odnositi. ");
INSERT INTO hrvbib_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Jedan od Isusovih učenika, onaj kojega je Isus osobito volio, sjedio je za stolom odmah uz Isusa. ");
INSERT INTO hrvbib_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Šimun Petar mu dade znak da upita Isusa tko bi mogao učiniti takvo strašno djelo. ");
INSERT INTO hrvbib_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","On se nagne prema Isusu i upita ga: “Tko je taj, Gospodine?” ");
INSERT INTO hrvbib_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Isus odgovori: “Kojemu dâm umočen kruh.” Umoči zatim kruh i dade ga Judi, sinu Šimuna Iškariotskoga. ");
INSERT INTO hrvbib_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Čim Juda pojede kruh, u njega uđe Sotona. Tada mu Isus reče: “Brzo čini to što kaniš učiniti!” ");
INSERT INTO hrvbib_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Nitko od nazočnih za stolom nije razumio zašto je Isus to rekao. ");
INSERT INTO hrvbib_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Kako im je Juda bio blagajnik, neki pomisle da ga Isus šalje kupiti hrane za blagdane ili podijeliti novac siromašnima. ");
INSERT INTO hrvbib_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Čim je uzeo kruh, Juda iziđe u noć. ");
INSERT INTO hrvbib_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Čim je Juda izišao, Isus reče: “Sada je vrijeme da ja, Sin Čovječji, uđem u svoju slavu, a Bog će biti proslavljen svime što će se meni dogoditi. ");
INSERT INTO hrvbib_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Bog će me proslaviti u sebi, i to odmah. ");
INSERT INTO hrvbib_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Draga moja djeco, kako su kratki ovi trenuci prije nego što ću morati otići i ostaviti vas! A onda, budete li me i tražili, i kao što sam rekao i Židovima: ‘Kamo ja idem, vi ne možete doći.’ ");
INSERT INTO hrvbib_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Dajem vam novu zapovijed: da volite jedni druge. Volite se međusobno onako kako sam ja volio vas. ");
INSERT INTO hrvbib_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Budete li imali ljubavi jedni prema drugima, po tomu će svi znati da ste moji učenici.” ");
INSERT INTO hrvbib_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","“Kamo ideš, učitelju?” upita ga Šimun Petar. Isus mu odgovori: “Sada ne možeš poći sa mnom, ali poslije ćeš me slijediti.” ");
INSERT INTO hrvbib_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Petar upita: “Zašto sada ne mogu s tobom? Ja sam za tebe spreman i umrijeti!” ");
INSERT INTO hrvbib_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Isus mu odgovori: “Umrijeti za mene? Zaista ti kažem, prije nego što pijetao zakukuriče, triput ćeš zanijekati da me uopće poznaješ.” ");
INSERT INTO hrvbib_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Neka se ne uznemiruje vaše srce! Pouzdajte se u Boga i u mene! ");
INSERT INTO hrvbib_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","U kući mojega Oca mnogo je stanova. Da nije tako, zar bih vam rekao: ‘Idem vam pripraviti mjesto’? ");
INSERT INTO hrvbib_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Kad odem i pripremim vam mjesto, opet ću se vratiti da vas uzmem k sebi da biste bili gdje sam ja. ");
INSERT INTO hrvbib_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","A vi već znate put onamo kamo idem.” ");
INSERT INTO hrvbib_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","“Ne znamo, Gospodine, ni kamo ideš”, reče Toma. “Kako bismo onda znali put onamo?” ");
INSERT INTO hrvbib_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Isus mu reče: “Ja sam put, istina i život. Nitko ne može doći Ocu osim po meni. ");
INSERT INTO hrvbib_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Kad biste mene poznavali, poznavali biste i mojeg Otca. Odsad ga poznajete i vidjeli ste ga.” ");
INSERT INTO hrvbib_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filip mu reče: “Gospodine, pokaži nam Oca i bit ćemo zadovoljni!” ");
INSERT INTO hrvbib_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Isus odgovori: “Zar ti, Filipe, još ne znaš tko sam ja, čak ni pošto sam toliko vremena proveo s vama? Tko je vidio mene, vidio je i Oca. Zašto onda tražiš da ga vidiš? ");
INSERT INTO hrvbib_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Zar ne vjeruješ da sam ja u Ocu i Otac u meni? Riječi koje govorim nisu moje, nego Otac koji živi u meni čini svoja djela kroza me. ");
INSERT INTO hrvbib_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Vjerujte mi da sam ja u Ocu i da je Otac u meni. Vjerujte barem zbog samih djela koja ste vidjeli da činim. ");
INSERT INTO hrvbib_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Zaista vam kažem, tko vjeruje u mene, činit će djela kakva sam i ja činim, pa čak i veća, jer ja odlazim Ocu. ");
INSERT INTO hrvbib_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ma što zamolili u moje ime, ja ću to učiniti da bi se Otac proslavio u Sinu. ");
INSERT INTO hrvbib_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ma što zamolili u moje ime, ja ću to učiniti. ");
INSERT INTO hrvbib_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Ako me volite, slušajte moje zapovijedi, ");
INSERT INTO hrvbib_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","a ja ću moliti Oca i on će vam poslati drugog Utješitelja koji vas nikad neće ostaviti: ");
INSERT INTO hrvbib_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Svetoga Duha, Duha Istine, kojega svijet ne može primiti jer ga ne vidi niti ga poznaje. No vi ga poznajete jer je sada uz vas i prebivat će u vama. ");
INSERT INTO hrvbib_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Neću vas ostaviti kao siročad. Opet ću vam doći. ");
INSERT INTO hrvbib_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Još samo malo i svijet me više neće vidjeti, ali vi ćete me ponovno vidjeti jer ja živim i jer ćete i vi živjeti. ");
INSERT INTO hrvbib_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","U taj ćete dan spoznati da sam ja u Ocu, da ste vi u meni i ja u vama. ");
INSERT INTO hrvbib_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Tko sluša moje zapovijedi, taj me voli; i zato što me voli, moj će ga Otac voljeti, i ja ću ga voljeti i objaviti mu se.” ");
INSERT INTO hrvbib_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","“Gospodine, zašto ćeš se objaviti samo nama, a ne i cijelom svijetu?” upita ga Juda (ne Iškariotski, već drugi učenik istog imena). ");
INSERT INTO hrvbib_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Isus mu odgovori: “Oni koji me vole, činit će što im kažem. Moj će ih Otac zato voljeti pa ćemo doći i živjeti s njima. ");
INSERT INTO hrvbib_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","A tko me ne voli, taj me i ne sluša. Riječi koje vam govorim nisu moje, nego od Oca koji me je poslao. ");
INSERT INTO hrvbib_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","To sam vam govorio dok sam još bio s vama. ");
INSERT INTO hrvbib_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","A kad Otac pošalje Utješitelja, Svetoga Duha, da me zastupa, on će vas mnogočemu naučiti i podsjetiti vas na sve što sam vam govorio. ");
INSERT INTO hrvbib_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Ostavljam vam mir—i to svoj mir—a mir koji vam ja dajem nije mir kakav daje svijet. Zato se ne uznemirujte i ne plašite. ");
INSERT INTO hrvbib_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Sjetite se što sam vam rekao: ‘Odlazim, ali ću vam opet doći.’ Ako me zaista volite, bit ćete sretni što idem k Ocu jer je on veći od mene. ");
INSERT INTO hrvbib_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Rekao sam vam sve to prije nego što se dogodilo da vjerujete u mene kad se dogodi. ");
INSERT INTO hrvbib_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Nemam više mnogo vremena govoriti vam jer se približava zli knez ovoga svijeta. On nada mnom nema vlast, ");
INSERT INTO hrvbib_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ali ja ću dragovoljno učiniti ono što Otac od mene traži kako bi svijet spoznao da ja volim Oca. Ustanite! Hajdemo odavde!” ");
INSERT INTO hrvbib_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Ja sam pravi trs, a moj je Otac vinogradar. ");
INSERT INTO hrvbib_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","On siječe svaku mladicu na meni koja ne rađa rodom. Pročišćuje mladice koje donose rod kako bi dale još više roda. ");
INSERT INTO hrvbib_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Vi ste već očišćeni kroz riječ koju sam vam govorio. ");
INSERT INTO hrvbib_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ostanite u meni i ja ću ostati u vama! Jer mladica ne može donijeti rod sama od sebe, otkinuta od trsa. Tako ni vi ne možete biti plodonosni ako ste odvojeni od mene. ");
INSERT INTO hrvbib_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Ja sam trs, a vi ste mladice. Tko ostane u meni i ja u njemu, donijet će velik rod. Jer bez mene ne možete ništa učiniti. ");
INSERT INTO hrvbib_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ne ostane li tko u meni, bit će izbačen kao beskorisna mladica i osušiti se. A takve se mladice bacaju u oganj da izgore. ");
INSERT INTO hrvbib_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ali ostanete li u meni i slušate moje zapovijedi, možete tražiti što god hoćete i dat će vam se. ");
INSERT INTO hrvbib_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Moj će se Otac proslaviti time što ćete donijeti mnogo roda i što ćete biti moji učenici. ");
INSERT INTO hrvbib_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Kao što je Otac volio mene, tako sam i ja volio vas. Ostanite u mojoj ljubavi. ");
INSERT INTO hrvbib_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Vršite li moje zapovijedi, ostajete u mojoj ljubavi, kao što sam ja vršio zapovijedi svojeg Oca i ostajem u njegovoj ljubavi. ");
INSERT INTO hrvbib_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","To vam kažem da biste u sebi imali moju radost i da vaša radost bude potpuna. ");
INSERT INTO hrvbib_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Moja je zapovijed da volite jedni druge kao što sam ja volio vas. ");
INSERT INTO hrvbib_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","A veće ljubavi nitko ne može iskazati nego da život dade za svoje prijatelje. ");
INSERT INTO hrvbib_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Prijatelji ste mi ako činite što vam zapovijedam. ");
INSERT INTO hrvbib_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ne zovem vas više slugama jer sluga ne zna gospodarove nakane. Sada ste mi prijatelji jer sam vam kazao sve što mi je Otac rekao. ");
INSERT INTO hrvbib_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Niste vi mene izabrali. Ja sam izabrao vas! Odredio sam vas da idete i da rodite trajnim rodom, tako da vam moj Otac dade sve što god zatražite u moje ime. ");
INSERT INTO hrvbib_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Zapovijedam vam da volite jedni druge!” ");
INSERT INTO hrvbib_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Mrzi li vas svijet, znajte da je mene mrzio prije vas. ");
INSERT INTO hrvbib_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Svijet bi vas volio kad biste pripadali njemu, ali ne pripadate mu jer sam vas ja izabrao iz svijeta. Zato vas svijet mrzi. ");
INSERT INTO hrvbib_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Sjećate li se što sam vam rekao, da nije sluga veći od svojega gospodara? Pa ako su mene progonili, naravno da će i vas progoniti. Ako su slušali mene, slušat će i vas! ");
INSERT INTO hrvbib_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Svijet će vas progoniti zbog mojega imena jer ne poznaju Oca koji me je poslao. ");
INSERT INTO hrvbib_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Da nisam došao i govorio im, oni ne bi bili krivi, ali ovako nemaju isprike za svoj grijeh. ");
INSERT INTO hrvbib_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Tko mene mrzi, mrzi i mojeg Oca. ");
INSERT INTO hrvbib_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Da nisam među njima činio djela koja nitko drugi nije učinio, ne bi bili krivi. A oni su sve to vidjeli, a ipak su zamrzili i mene i mojeg Oca. ");
INSERT INTO hrvbib_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Time se ispunilo napisano u njihovu Zakonu: ‘Mrzili su me bez razloga.’ ");
INSERT INTO hrvbib_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Ali poslat ću vam Savjetnika, Duha Istine, koji dolazi od Oca i svjedočit će o meni. ");
INSERT INTO hrvbib_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","I vi ćete govoriti o meni jer ste bili sa mnom od početka. ");
INSERT INTO hrvbib_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","To sam vam rekao da ne biste otpali od vjere. ");
INSERT INTO hrvbib_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Jer će vas izopćivati iz sinagoga i doći će vrijeme kad će svatko tko vas bude ubijao misliti da služi Bogu. ");
INSERT INTO hrvbib_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","A to će činiti zato što nikada nisu upoznali ni Oca ni mene. ");
INSERT INTO hrvbib_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","To vam govorim sada da biste se, kad se to dogodi, sjetili kako sam vas upozorio. Nisam vam govorio prije jer sam znao da ću biti s vama još neko vrijeme.” ");
INSERT INTO hrvbib_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Ali sad odlazim onomu koji me je poslao, a nitko od vas nije me ni upitao kamo idem. ");
INSERT INTO hrvbib_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Umjesto toga se žalostite zato što sam vam to rekao. ");
INSERT INTO hrvbib_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","No za vas je uistinu bolje da ja odem jer ako ja ne odem, neće vam doći Utješitelj. Ako pak odem, poslat ću ga k vama. ");
INSERT INTO hrvbib_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Kad dođe, on će dokazati svijetu zabludu s obzirom na grijeh, pravednost i sud. ");
INSERT INTO hrvbib_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ljudi svijeta su u grijehu jer ne vjeruju u mene. ");
INSERT INTO hrvbib_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Moju će pravednost potvrditi Otac tako što će me uzdignuti na mjesto slave, gdje me više nećete vidjeti; ");
INSERT INTO hrvbib_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","sud dolazi zato što je knez ovoga svijeta već osuđen. ");
INSERT INTO hrvbib_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Toliko toga bih vam još imao reći, ali sada to ne biste mogli podnijeti. ");
INSERT INTO hrvbib_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Kad dođe Duh Istine, uputit će vas u cjelokupnu istinu. On neće iznositi vlastite misli, nego će vam prenijeti ono što je čuo. Objavit će vam i ono što će se dogoditi. ");
INSERT INTO hrvbib_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","On će me proslaviti otkrivajući vam ono što primi od mene. ");
INSERT INTO hrvbib_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Sve što ima Otac, moje je. Zato kažem da će vam otkriti ono što primi od mene.” ");
INSERT INTO hrvbib_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Još samo malo pa ću otići i više me nećete vidjeti. No malo zatim ponovno ćete me vidjeti.” ");
INSERT INTO hrvbib_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Učenici su pitali jedni druge: “Kako on to misli: ‘Nećete me vidjeti, a onda ćete me opet vidjeti’? I što želi reći kad kaže: ‘Odlazim Ocu’? ");
INSERT INTO hrvbib_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Što znači: ‘Još samo malo’? Ne razumijemo to.” ");
INSERT INTO hrvbib_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Isus je shvatio da ga žele to pitati, pa reče: “Pitate se među sobom na što sam mislio kad sam rekao: ‘Još samo malo pa ću otići i više me nećete vidjeti, no malo zatim vidjet ćete me ponovno’? ");
INSERT INTO hrvbib_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Zaista vam kažem, svijet će se veseliti zbog onoga što će mi se dogoditi, a vi ćete plakati i jadikovati. Ali vaša će se žalost preokrenuti u radost. ");
INSERT INTO hrvbib_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Bit će to kao i sa ženom u trudovima—žalosna je dok rađa, ali kad se dijete rodi, radosna je što je donijela novu osobu na svijet pa zaboravlja bolove koje je pretrpjela. ");
INSERT INTO hrvbib_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Tako je i s vama, sad se žalostite, ali ću vas opet vidjeti i razveselit ćete mi se; te vam radosti nitko neće moći uskratiti. ");
INSERT INTO hrvbib_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","U taj dan ništa me nećete tražiti. Zaista vam kažem, zamolite li što Oca u moje ime, dat će vam. ");
INSERT INTO hrvbib_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Dosad niste ništa molili u moje ime. Molite i primit ćete, da vaša radost bude potpuna. ");
INSERT INTO hrvbib_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","O tomu sam vrlo oprezno govorio, u prispodobama, ali će doći vrijeme kad to više neće biti potrebno i kada ću vam otvoreno govoriti o Ocu. ");
INSERT INTO hrvbib_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Tada ćete njemu iznijeti svoje molbe u moje ime. Ne kažem da ću ja moliti za vas ");
INSERT INTO hrvbib_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","jer vas sâm Otac žarko voli zato što ste vi mene voljeli i vjerovali da sam došao od Oca. ");
INSERT INTO hrvbib_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Da, izišao sam od Oca i došao na svijet, a otići ću s ovoga svijeta i vratiti se Ocu.” ");
INSERT INTO hrvbib_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","“Sada otvoreno govoriš,” rekoše njegovi učenici, “a ne u zagonetkama. ");
INSERT INTO hrvbib_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Sada shvaćamo da sve znaš i da ti nitko ne mora ništa reći. Zato vjerujemo da si izišao od Boga.” ");
INSERT INTO hrvbib_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","“Vjerujete li zaista?” odgovori im Isus. ");
INSERT INTO hrvbib_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","“No dolazi vrijeme, i već je tu, kad ćete se razbježati svaki na svoju stranu, a mene ćete ostaviti samoga. Ipak neću biti sam jer Otac je sa mnom. ");
INSERT INTO hrvbib_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Sve sam vam to rekao da u meni imate mir. Ovdje na zemlji imat ćete nevolje, ali ohrabrite se, ja sam pobijedio svijet!” ");
INSERT INTO hrvbib_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Pošto je Isus sve to rekao, pogleda prema nebu i nastavi: “Oče, došao je čas! Proslavi svojeg Sina da on može proslaviti tebe. ");
INSERT INTO hrvbib_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Jer ti si mu dao vlast nad svim ljudima na zemlji. On daje vječni život svakomu koga si mu ti dao. ");
INSERT INTO hrvbib_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","A vječni život jest spoznati tebe, jedinoga, istinitoga Boga, i Isusa Krista, koga si ti poslao. ");
INSERT INTO hrvbib_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Pronio sam tvoju slavu ovdje na zemlji čineći sve što si mi rekao da učinim. ");
INSERT INTO hrvbib_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","A sada ti mene, Oče, proslavi slavom koju sam dijelio s tobom prije postanka svijeta. ");
INSERT INTO hrvbib_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Ovim sam ljudima rekao sve o tebi. Bili su u svijetu, ali ti si mi ih dao. Zapravo su oduvijek i bili tvoji, ali dao si ih meni i poslušali su tvoje riječi. ");
INSERT INTO hrvbib_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Sad su spoznali da je sve što imam od tebe ");
INSERT INTO hrvbib_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","jer sam im prenio riječi koje si mi dao. Prihvatili su ih, pa tako sigurno znaju da sam izišao od tebe i vjeruju da si me ti poslao. ");
INSERT INTO hrvbib_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Moja molitva nije za svijet, već za one koje si mi dao jer tebi pripadaju. ");
INSERT INTO hrvbib_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Svi oni koji su moji pripadaju tebi, i svi koji su tvoji pripadaju meni. U njima sam se proslavio. ");
INSERT INTO hrvbib_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Sad odlazim s ovog svijeta, ostavljam ih i idem tebi. Sveti Oče, brini se za njih i dalje, očuvaj sve one koje si mi dao u svojem imenu da budu sjedinjeni baš kao i mi. ");
INSERT INTO hrvbib_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Dok sam bio s njima, očuvao sam u tvojem imenu sve one koje si mi dao. Čuvao sam ih da nijedan osim sina pogibli ne propadne da se obistini proročanstvo iz Svetoga pisma. ");
INSERT INTO hrvbib_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","A sada idem tebi. Ovo govorim dok sam u svijetu kako bi oni u sebi imali moju radost u svoj punini. ");
INSERT INTO hrvbib_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Dao sam im tvoju riječ, a svijet ih je zamrzio jer ne pripadaju svijetu, baš kao ni ja. ");
INSERT INTO hrvbib_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ne molim te da ih uzmeš sa svijeta, već da ih očuvaš od zla. ");
INSERT INTO hrvbib_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Nisu više od ovoga svijeta, kao što ni ja nisam od svijeta. ");
INSERT INTO hrvbib_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Posveti ih istinom; tvoje su riječi istina. ");
INSERT INTO hrvbib_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Kao što si mene poslao u svijet, tako i ja njih šaljem. ");
INSERT INTO hrvbib_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","I ja se posvećujem za njih da i oni budu posvećeni istinom. ");
INSERT INTO hrvbib_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Ne molim te samo za ove nego i za sve koji će povjerovati u mene zbog njihova svjedočanstva. ");
INSERT INTO hrvbib_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Moja je molitva za sve njih da budu jedno, baš kao što smo ti i ja, Oče, ti u meni i ja u tebi, neka tako i oni budu jedno u nama da svijet povjeruje da si me ti poslao. ");
INSERT INTO hrvbib_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ja sam im dao slavu koju si mi ti dao; da budu jedno kao što smo i mi— ");
INSERT INTO hrvbib_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","ja u njima, a ti u meni, da budu savršeno jedno. Tako će svijet spoznati da si me ti poslao i shvatiti da ih voliš kao što voliš mene. ");
INSERT INTO hrvbib_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Oče, želim da budu sa mnom—svi koje si mi dao—neka gledaju moju slavu koju si mi dao jer si me volio još prije postanka svijeta! ");
INSERT INTO hrvbib_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Pravedni Oče, svijet te ne poznaje, ali ja te poznajem. I ovi su učenici spoznali da si me ti poslao. ");
INSERT INTO hrvbib_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Njima sam otkrio tebe i dalje ću te objavljivati da žarka ljubav kojom mene voliš bude u njima i da ja budem u njima!” ");
INSERT INTO hrvbib_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Rekavši to, Isus sa svojim učenicima prijeđe na drugu stranu potoka Kedrona te uđe s njima u maslinik. ");
INSERT INTO hrvbib_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","A izdajnik Juda poznavao je to mjesto jer je Isus često onamo odlazio sa svojim učenicima. ");
INSERT INTO hrvbib_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Svećenički poglavari i farizeji dali su Judi četu vojnika i stražare da odu onamo. Oni stignu do maslinika sa zapaljenim bakljama, svjetiljkama i oružjem. ");
INSERT INTO hrvbib_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Isus je znao što će se sve dogoditi. On istupi pred njih i upita: “Koga tražite?” ");
INSERT INTO hrvbib_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","“Isusa iz Nazareta!” odgovore oni. “Ja sam”, reče Isus. S njima je stajao i njegov izdajnik Juda. ");
INSERT INTO hrvbib_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Kad im je rekao “Ja sam”, svi ustuknu i popadaju na zemlju. ");
INSERT INTO hrvbib_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ponovno ih upita: “Koga tražite?” Opet odgovore: “Isusa iz Nazareta!” ");
INSERT INTO hrvbib_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","“Rekao sam vam: ja sam”, odgovori Isus. “Ja sam taj kojega tražite. Pustite druge neka idu.” ");
INSERT INTO hrvbib_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Rekao je to da bi se ispunilo proročanstvo koje je upravo spomenuo: “Nisam izgubio nijednoga od ovih koje si mi dao.” ");
INSERT INTO hrvbib_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Tada Šimun Petar potegne mač i odsiječe desno uho sluzi velikog svećenika, koji se zvao Malko. ");
INSERT INTO hrvbib_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ali Isus reče Petru: “Spremi mač u korice! Zar da ne ispijem čašu koju mi je Otac dao?” ");
INSERT INTO hrvbib_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Tako židovski stražari s četom vojnika i njihovim zapovjednikom uhvate Isusa i svežu ga. ");
INSERT INTO hrvbib_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Odvedu ga najprije Ani, tastu Kajfe, koji je te godine bio veliki svećenik. ");
INSERT INTO hrvbib_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kajfa je bio taj koji je savjetovao židovskim vođama: “Bolje da jedan čovjek umre za narod.” ");
INSERT INTO hrvbib_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Šimun Petar i još jedan učenik koji je poznavao velikog svećenika izdaleka su ih slijedili. Tako je taj drugi učenik mogao ući u dvorište velikog svećenika skupa s Isusom, ");
INSERT INTO hrvbib_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","a Petar je ostao vani, pred vratima. Drugi učenik tada porazgovara sa sluškinjom koja je pazila kraj vrata pa ona uvede i Petra. ");
INSERT INTO hrvbib_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ta sluškinja, vratarica, upita Petra: “Nisi li i ti jedan od Isusovih učenika?” “Nisam”, odvrati Petar. ");
INSERT INTO hrvbib_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Stražari i služinčad stajali su pokraj vatre koju su naložili i grijali se jer je bilo hladno. I Petar je stajao ondje s njima grijući se. ");
INSERT INTO hrvbib_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Unutra veliki svećenik počne ispitivati Isusa o njegovim učenicima i o onome što ih je poučavao. ");
INSERT INTO hrvbib_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Isus odgovori: “Što sam poučavao, naširoko je poznato jer sam redovito poučavao u sinagogi i u Hramu. Čuli su me svi Židovi i ništa nisam poučavao tajno a da to nisam i javno rekao. ");
INSERT INTO hrvbib_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Zašto to mene pitaš? Pitaj one koji su me slušali. Oni znaju što sam govorio!” ");
INSERT INTO hrvbib_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Jedan od vojnika koji je ondje stajao šakom udari Isusa po licu. “Zar se tako odgovara velikom svećeniku?” upita. ");
INSERT INTO hrvbib_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","“Ako sam pogrešno rekao, dokaži da je pogrešno”, odgovori Isus. “Zar ćeš udarati čovjeka samo zato što govori istinu?” ");
INSERT INTO hrvbib_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Tada Ana pošalje svezanoga Isusa velikome svećeniku Kajfi. ");
INSERT INTO hrvbib_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","U međuvremenu, dok se Šimun Petar grijao kraj vatre, ponovno ga upitaju: “Da nisi i ti jedan od njegovih učenika?” “Nisam!” odgovori on. ");
INSERT INTO hrvbib_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ali jedan od slugu velikoga svećenika, rođak onoga kojemu je Petar odsjekao uho, upita ga: “Zar te nisam vidio ondje u masliniku skupa s Isusom?” ");
INSERT INTO hrvbib_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Petar opet zaniječe. A pijetao odmah zakukuriče. ");
INSERT INTO hrvbib_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Isusovo preslušanje pred Kajfom završilo je u rane jutarnje ure. Zatim ga odvedu u palaču rimskoga upravitelja. Njegovi tužitelji nisu sâmi onamo ulazili jer bi ih ulazak onečistio pa ne bi smjeli jesti pashalnu večeru. ");
INSERT INTO hrvbib_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Zato Pilat, upravitelj, iziđe k njima te ih upita: “Za što optužujete ovog čovjeka?” ");
INSERT INTO hrvbib_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","“Ne bismo ga predali tebi da nije zločinac!” odgovore oni. ");
INSERT INTO hrvbib_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","“Onda ga odvedite i sami mu sudite po svojim zakonima”, reče Pilat. “Ali nama nije dopušteno ubiti čovjeka!”—kazaše. ");
INSERT INTO hrvbib_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Time se ispunilo Isusovo proročanstvo o njegovu smaknuću. ");
INSERT INTO hrvbib_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Tada se Pilat vrati u palaču i naredi da mu dovedu Isusa. “Jesi li ti kralj Židova?” upita ga. ");
INSERT INTO hrvbib_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","“Jesi li se tog pitanja dosjetio sam ili su ti drugi govorili o meni?” upita ga Isus. ");
INSERT INTO hrvbib_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","“Zar sam ja Židov?” odgovori Pilat. “Tvoj vlastiti narod i svećenički poglavari predali su te meni. Zašto? Što si učinio?” ");
INSERT INTO hrvbib_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Isus odgovori: “Moje kraljevstvo ne pripada ovomu svijetu. Kad bi mu pripadalo, moji bi se podanici borili da ne budem predan Židovima. Ali moje kraljevstvo nije od ovoga svijeta!” ");
INSERT INTO hrvbib_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilat upita: “Ti dakle jesi kralj?” “Ti to kažeš”, odgovori Isus. “Da, ja sam kralj; rodio sam se da bih svjedočio za istinu. Svaki onaj koji voli istinu poslušat će moj glas.” ");
INSERT INTO hrvbib_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilat upita: “A što je istina?” Tada ponovno iziđe pred židovski narod i reče im: “Ja na njemu nisam našao nikakve krivnje. ");
INSERT INTO hrvbib_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","A vi svake godine u vrijeme Pashe imate običaj tražiti da vam pustim nekoga iz zatvora. Hoćete li da oslobodim židovskoga kralja?” ");
INSERT INTO hrvbib_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ali oni nato poviču: “Ne! Ne njega, nego Barabu!” A Baraba je bio prevratnik. ");
INSERT INTO hrvbib_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Pilat tada dade Isusa izbičevati. ");
INSERT INTO hrvbib_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Vojnici spletu krunu od trnja, stave mu je na glavu i odjenu ga u grimizni plašt. ");
INSERT INTO hrvbib_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","“Živio kralj Židova!” rugali su mu i udarali ga po licu. ");
INSERT INTO hrvbib_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilat ponovno iziđe i reče Židovima: “Evo, sad ću vam ga izvesti, ali znajte da ga ja ne smatram krivim.” ");
INSERT INTO hrvbib_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Isus iziđe noseći trnovu krunu i grimizni plašt, a Pilat reče narodu: “Evo čovjeka!” ");
INSERT INTO hrvbib_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Kada su ga svećenički poglavari i židovski stražari ugledali, stanu vikati: “Raspni ga! Raspni ga!” “Raspnite ga sami!” reče im Pilat. “Ja ne držim da je kriv.” ");
INSERT INTO hrvbib_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Židovi odgovore: “Prema našemu Zakonu mora umrijeti jer se pravio Božjim Sinom.” ");
INSERT INTO hrvbib_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Kad je to čuo, Pilat se još više uplaši. ");
INSERT INTO hrvbib_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Povede Isusa natrag u palaču i upita ga: “Odakle si?” Ali Isus mu na to ne odgovori. ");
INSERT INTO hrvbib_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","“Nećeš mi odgovoriti?” upita Pilat. “Ne shvaćaš li da imam vlast osloboditi te ili te raspeti?” ");
INSERT INTO hrvbib_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Isus mu reče: “Ne bi ti imao nikakve vlasti nada mnom da ti nije dana odozgor. Zato je još veći grijeh onoga koji me je tebi predao.” ");
INSERT INTO hrvbib_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pilat ga je tada nastojao osloboditi, ali su mu židovski vođe rekli: “Oslobodiš li tog čovjeka, neprijatelj si caru! Tko se god izdaje za kralja, prevratnik je protiv cara.” ");
INSERT INTO hrvbib_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Na te im riječi Pilat opet izvede Isusa pa sjedne na sudačku stolicu na kamenom popločenu postolju. ");
INSERT INTO hrvbib_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Bilo je oko podneva, dan priprave za Pashu. Pilat reče Židovima: “Evo vašega kralja!” ");
INSERT INTO hrvbib_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","“Smakni ga!” vikali su. “Smakni ga! Raspni ga!” “Što?! Da raspnem vašega kralja?” upita Pilat. “Mi nemamo kralja osim cara!” odvrate svećenički poglavari. ");
INSERT INTO hrvbib_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Tada im Pilat preda Isusa da se raspne. Isusa odvedu. ");
INSERT INTO hrvbib_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Noseći križ, otišao je do mjesta zvanoga Lubanja, ili hebrejski: Golgota. ");
INSERT INTO hrvbib_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ondje ga raspnu s još dvojicom, svakim s jedne strane, tako da je Isus bio u sredini. ");
INSERT INTO hrvbib_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilat iznad njega dade postaviti natpis: “isus nazarećanin, kralj Židova.” ");
INSERT INTO hrvbib_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Mnogi su Židovi pročitali taj natpis jer se mjesto na kojemu je Isus raspet nalazilo blizu grada; natpis je bio na hebrejskomu, latinskomu i grčkomu. ");
INSERT INTO hrvbib_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Svećenički poglavari rekli su Pilatu: “Neka umjesto ‘kralj Židova’ stoji: ‘Za sebe je tvrdio: “Ja sam kralj Židova.”’” ");
INSERT INTO hrvbib_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","“Neka ostane kako sam napisao!” odgovori im Pilat. ");
INSERT INTO hrvbib_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Pošto su vojnici raspeli Isusa, razdijele njegovu odjeću na četiri dijela, svakomu po jedan. Uzmu mu i košulju. Kako nije imala šava, već je bila otkana u jednome komadu, ");
INSERT INTO hrvbib_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","kazaše: “Nemojmo ju parati. Bacimo za nju kocku pa komu dopadne.” Time se ispunila riječ iz Svetoga pisma: “Razdijeliše među sobom moju odjeću, a za haljinu baciše kocku.” Tako su i učinili. ");
INSERT INTO hrvbib_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Nedaleko od križa stajale su Isusova majka Marija, njegova teta Marija Kleofina i Marija Magdalena. ");
INSERT INTO hrvbib_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Kad Isus opazi svoju majku gdje stoji pokraj učenika kojega je osobito volio, reče joj: “Ženo, evo ti sina!” ");
INSERT INTO hrvbib_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","A učeniku reče: “Evo ti majke.” I od toga časa uzme ju taj učenik u svoj dom. ");
INSERT INTO hrvbib_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Znajući da je sve svršeno, Isus reče: “Žedan sam” da bi se ispunilo Sveto pismo. ");
INSERT INTO hrvbib_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ondje je stajala posuda s octom pa u ocat namoče spužvu, stave ju na izopovu trsku i primaknu Isusovim ustima. ");
INSERT INTO hrvbib_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Kad Isus okusi ocat, reče: “Svršeno je!” Glava mu klone i on preda svoj duh. ");
INSERT INTO hrvbib_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Kako je bilo vrijeme Priprave, židovski vođe nisu htjeli da tijela raspetih ostanu na križevima i tijekom subote koja je bila velik blagdan, Pasha. Stoga zamole Pilata da zapovjedi da se raspetima prebiju noge da brže umru kako bi ih mogli skinuti s križa. ");
INSERT INTO hrvbib_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Vojnici dođu i prebiju noge dvojici raspetih s Isusom. ");
INSERT INTO hrvbib_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Kad su došli do Isusa, vidjeli su da je već mrtav, pa mu nisu prebili noge, ");
INSERT INTO hrvbib_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","nego mu jedan od vojnika kopljem probode bok iz kojega odmah poteku krv i voda. ");
INSERT INTO hrvbib_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","To je izvještaj očevica koji točno opisuje što je vidio da i vi možete vjerovati. ");
INSERT INTO hrvbib_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Sve se to dogodilo da bi se obistinile riječi Svetoga pisma: “Nijedna mu se kost neće slomiti” ");
INSERT INTO hrvbib_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","i “Gledat će onoga koga su proboli.” ");
INSERT INTO hrvbib_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Nakon toga Josip iz Arimateje, koji je bio Isusov učenik, ali je to tajio zbog straha od židovskih vođa, zamoli Pilata da mu dopusti uzeti Isusovo tijelo. Pilat mu dopusti pa Josip dođe i skine Isusovo tijelo. ");
INSERT INTO hrvbib_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Došao je i Nikodem, koji je posjetio Isusa noću, i donio trideset litara ulja od smirne i aloje za pomazanje tijela. ");
INSERT INTO hrvbib_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Umotali su Isusovo tijelo u dugačko platno natopljeno mirisima, kako je već u Židova bio običaj pri ukopu. ");
INSERT INTO hrvbib_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","U blizini mjesta na kojemu je Isus bio raspet nalazio se vrt s posve novim grobom u kojega još nitko nije bio položen. ");
INSERT INTO hrvbib_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Kako je grob bio blizu, a valjalo je žuriti zbog Priprave, ondje polože Isusa. ");
INSERT INTO hrvbib_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","U nedjelju rano ujutro, još za mraka, dođe na grob Marija Magdalena i opazi da je odvaljen kamen s ulaza u grob. ");
INSERT INTO hrvbib_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Otrči stoga pronaći Šimuna Petra i još jednog učenika, koga je Isus osobito volio, pa im reče: “Uzeli su Gospodinovo tijelo iz groba i ne znam kamo su ga stavili!” ");
INSERT INTO hrvbib_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Petar tada iziđe s drugim učenikom te potrče prema grobu. ");
INSERT INTO hrvbib_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Drugi učenik prestigne Petra i stigne onamo prvi, ");
INSERT INTO hrvbib_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","sagne se, zaviri unutra te spazi povoje od lanena platna gdje leže, ali ne uđe. ");
INSERT INTO hrvbib_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Tada pristigne i Šimun Petar pa uđe u grob. I on ugleda povoje gdje leže ");
INSERT INTO hrvbib_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","i platno u koje je bila umotana Isusova glava kako presavijeno leži sa strane. ");
INSERT INTO hrvbib_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Tada je ušao i drugi učenik, vidio i povjerovao— ");
INSERT INTO hrvbib_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","jer sve do tada nisu shvatili da Sveto pismo govori kako će Isus ustati od mrtvih. ");
INSERT INTO hrvbib_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Vrate se kući. ");
INSERT INTO hrvbib_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Marija se vratila na grob i stajala vani plačući. Zaplakana se sagne i zaviri u grob ");
INSERT INTO hrvbib_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","te ugleda dva anđela obučena u bijelo kako sjede, jedan do glave, a drugi do nogu na mjestu gdje je ležalo Isusovo tijelo. ");
INSERT INTO hrvbib_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","“Zašto plačeš?” upitaju anđeli. “Zato što su mi uzeli Gospodina,” odgovori ona, “a ne znam kamo su ga stavili!” ");
INSERT INTO hrvbib_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Obazre se i ugleda da netko stoji iza nje. Bio je to Isus, ali ga nije prepoznala. ");
INSERT INTO hrvbib_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","“Zašto plačeš?” upita on. “Koga tražiš?” Ona pomisli da je to vrtlar. “Gospodine,” reče, “ako ste ga vi odnijeli, recite mi kamo ste ga stavili pa ću otići i uzeti ga.” ");
INSERT INTO hrvbib_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","“Marijo!” reče joj Isus. Ona se okrene prema njemu i uzvikne na hebrejskome: “Rabbuni!” (što znači: “Učitelju!”) ");
INSERT INTO hrvbib_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","“Nemoj me dulje zadržavati”, upozori ju, “jer još nisam uzišao k Ocu. Idi, nađi moju braću i javi im da uzlazim svojemu Ocu i vašemu Ocu, svojemu Bogu i vašemu Bogu.” ");
INSERT INTO hrvbib_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Marija Magdalena ode javiti učenicima da je vidjela Gospodina i prenese im njegovu poruku. ");
INSERT INTO hrvbib_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Te su se večeri prvoga dana u tjednu učenici sastali iza zaključanih vrata zbog straha od židovskih vođa kad odjednom među njih stane Isus. Pozdravi ih: “Mir vama!” ");
INSERT INTO hrvbib_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Kad im je to rekao, pokaže im svoje ruke i bok. Učenici se razvesele kad ugledaju svojega Gospodina. ");
INSERT INTO hrvbib_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Isus im opet reče: “Mir vama! Kao što je mene poslao Otac, tako i ja šaljem vas.” ");
INSERT INTO hrvbib_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Zatim dahne u njih i reče: “Primite Svetoga Duha! ");
INSERT INTO hrvbib_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Kojima oprostite grijehe, oprošteni su im. Kojima ne oprostite grijehe, nisu im oprošteni.” ");
INSERT INTO hrvbib_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Jedan od Dvanaestorice, Toma zvani Blizanac, nije tada bio s drugima. ");
INSERT INTO hrvbib_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","“Vidjeli smo Gospodina”, rekli su mu, a on odgovori: “Ne vjerujem sve dok ne vidim rane od čavala na njegovim rukama, dok u njih ne stavim prste i dok ne stavim ruku u ranu na njegovu boku.” ");
INSERT INTO hrvbib_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Nakon osam dana učenici su ponovno bili skupa. Taj je put s njima bio i Toma. Iako su vrata bila zatvorena, Isus stane među njih i pozdravi ih: “Mir vama!” ");
INSERT INTO hrvbib_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Zatim reče Tomi: “Daj ovamo prst; evo mojih ruku! Stavi ruku u moj bok. Ne budi više nevjernik. Vjeruj!” ");
INSERT INTO hrvbib_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","“Moj Gospodin i moj Bog!” uzvikne Toma. ");
INSERT INTO hrvbib_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Isus mu reče: “Ti vjeruješ jer si me vidio. Ali blago onima koji me nisu vidjeli, a vjeruju.” ");
INSERT INTO hrvbib_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Isusovi učenici vidjeli su kako Isus čini i mnoga druga čuda osim zapisanih u ovoj knjizi. ");
INSERT INTO hrvbib_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ova su zapisana da vjerujete da je Isus Mesija, Božji Sin, te da vjerujući u njega imate život. ");
INSERT INTO hrvbib_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Poslije se Isus opet javio učenicima uz Tiberijsko jezero. Evo kako se to dogodilo: ");
INSERT INTO hrvbib_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Ondje ih je bila nekolicina: Šimun Petar, Toma zvani Blizanac, Natanael iz Kane Galilejske, Zebedejevi sinovi te još dvojica učenika. ");
INSERT INTO hrvbib_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","“Idem loviti ribu”, reče Šimun Petar. “Idemo i mi”, rekli su oni i pošli s njim, ali cijele noći nisu ništa ulovili. ");
INSERT INTO hrvbib_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","U zoru je Isus stajao na obali, ali učenici ga nisu prepoznali. ");
INSERT INTO hrvbib_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","“Zar nemate ribe, djeco?” dovikne im on. “Nemamo!” odgovore. ");
INSERT INTO hrvbib_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","On reče: “Bacite mrežu s desne strane lađe i uhvatit ćete ih!” Tako su i učinili. Nisu mogli izvući mrežu zbog mnoštva riba koje su uhvatili. ");
INSERT INTO hrvbib_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Učenik kojega je Isus osobito volio reče Petru: “To je Gospodin!” Nato Šimun Petar opaše gornju haljinu jer je bio slabo obučen, skoči u vodu i otpliva do obale. ");
INSERT INTO hrvbib_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Drugi su ostali u lađi. Dovuku mrežu punu riba do obale udaljene stotinjak metara. ");
INSERT INTO hrvbib_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Kad su izišli na obalu, ugledaju ribu kako se peče na razgorjelu žaru i kruh. ");
INSERT INTO hrvbib_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","“Donesite malo riba koje ste uhvatili”, reče im Isus. ");
INSERT INTO hrvbib_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Šimun Petar ode i izvuče mrežu punu velikih riba na obalu: sto pedeset i tri velike ribe. Mreža se ipak nije rastrgala. ");
INSERT INTO hrvbib_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","“Dođite doručkovati!” reče im Isus. Nitko se od njih nije usuđivao pitati ga je li on uistinu Gospodin jer su znali da jest. ");
INSERT INTO hrvbib_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Isus uzme kruh, pa im ga dade. To učini i s ribom. ");
INSERT INTO hrvbib_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","To je bilo već treći put Isus da se javio učenicima otkad je uskrsnuo od mrtvih. ");
INSERT INTO hrvbib_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Nakon doručka Isus upita Šimuna Petra: “Šimune, Ivanov sine, ljubiš li me više nego ovi?” “Da”, odgovori Petar. “Ti znaš da te volim.” “Onda pasi moje jaganjce”, reče mu Isus. ");
INSERT INTO hrvbib_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ponovno ga upita: “Šimune, Ivanov sine, ljubiš li me?” “Da, Gospodine,” reče Petar “znaš da te volim.” “Onda pasi moje ovce”, reče mu Isus. ");
INSERT INTO hrvbib_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Još ga jedanput upita: “Šimune, Ivanov sine, voliš li me?” Petar se ražalosti što ga Isus i treći put pita voli li ga. “Gospodine, ti sve znaš; znaš da te volim”, reče. “Onda pasi moje ovce”, reče mu Isus. ");
INSERT INTO hrvbib_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","“Zaista ti kažem, kad si bio mlad, mogao si činiti što si htio i ići kamo si želio; ali kad ostariš, raširit ćeš ruke i drugi će te opasati i voditi onamo kamo ne želiš ići.” ");
INSERT INTO hrvbib_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Isus mu je to rekao da bi mu navijestio kakvom će smrću proslaviti Boga. Zatim mu reče: “Slijedi me!” ");
INSERT INTO hrvbib_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Petar se okrene i opazi da učenik kojega je Isus osobito volio, onaj koji se pri večeri nagnuo i upitao Isusa: “Učitelju, koji će te od nas izdati?” ide za njim. ");
INSERT INTO hrvbib_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Petar upita Isusa: “A što će biti s njime, Gospodine?” ");
INSERT INTO hrvbib_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Isus mu odgovori: “Ako hoću da on ostane dok ja ne dođem, što se to tebe tiče? Ti me slijedi!” ");
INSERT INTO hrvbib_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Tako se među braćom raširio glas da onaj učenik neće umrijeti. Ali Isus nije rekao da on neće umrijeti, već samo: “Ako hoću da on ostane dok ja ne dođem, što se to tebe tiče!” ");
INSERT INTO hrvbib_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ovo je taj učenik koji je vidio te događaje i ovdje ih zabilježio. A svi mi znamo da je zapis tih događaja točan i istinit. ");
INSERT INTO hrvbib_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Isus je učinio još mnogo toga i kad bi se sve redom zapisalo, mislim da sve te knjige ne bi stale ni u cijeli svijet!");
INSERT INTO hrvbib_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Dragi Teofile, u prvoj knjizi koju sam ti napisao iznio sam sve što je Isus počeo da djeluje i poučava ");
INSERT INTO hrvbib_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","do dana kad je uznesen na nebo, pošto je odabranim apostolima dao upute Svetoga Duha. ");
INSERT INTO hrvbib_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Još četrdeset dana nakon raspeća ukazivao se apostolima i na mnoge im načine dokazao da je živ. Govorio im je o Božjemu kraljevstvu. ");
INSERT INTO hrvbib_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Dok je tako s njima blagovao, reče im: “Ne idite iz Jeruzalema, nego ostanite ondje dok vam Otac ne pošalje što je obećao. Sjetite se, već sam vam o tomu govorio. ");
INSERT INTO hrvbib_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Ivan je krstio vodom, ali vi ćete uskoro biti kršteni Svetim Duhom.” ");
INSERT INTO hrvbib_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Apostoli koji su bili s njim upitaju ga: “Gospodine, hoćeš li sada obnoviti izraelsko kraljevstvo?” ");
INSERT INTO hrvbib_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","“Ta vremena i prigode određuje Otac svojom vlasti”, odgovori im on, “i nije na vama da ih znate. ");
INSERT INTO hrvbib_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ali kad na vas siđe Sveti Duh, primit ćete snagu da o meni svjedočite ljudima posvuda—u Jeruzalemu, po svoj Judeji i Samariji i do kraja zemlje.” ");
INSERT INTO hrvbib_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Tek što je to rekao, uznesen je na nebo pred njihovim očima i nestao u oblaku. ");
INSERT INTO hrvbib_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Dok su očiju uprtih u nebo gledali kako odlazi, odjednom se među njima pojave dvojica ljudi u bijeloj odjeći. ");
INSERT INTO hrvbib_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","“Galilejci, što tu stojite i gledate u nebo?” rekli su. “Isus je od vas uznesen na nebo, ali jednoga dana će se vratiti jednako tako kao što ste ga vidjeli da odlazi!” ");
INSERT INTO hrvbib_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Bilo je to na Maslinskoj gori. Vrate se zatim do Jeruzalema udaljenoga otprilike kilometar. ");
INSERT INTO hrvbib_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Čim uđu u grad, odu u kuću u kojoj su boravili, u sobu na katu. Bili su ondje Petar, Ivan, Jakov, Andrija, Filip, Toma, Bartolomej, Matej, Jakov (Alfejev sin), Šimun (zelot) i Juda (Jakovljev sin). ");
INSERT INTO hrvbib_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Svi su se ustrajno i jednodušno sastajali na molitvu s Isusovom majkom Marijom, još nekoliko drugih žena i s Isusovom braćom. ");
INSERT INTO hrvbib_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Kad ih je jednom tako bilo okupljeno sto dvadeset, Petar ustane i reče: ");
INSERT INTO hrvbib_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Braćo, moralo se ispuniti ono što piše u Svetome pismu za Judu, koji je doveo hramsku policiju da uhiti Isusa. To je odavno, kroz Davida, pretkazao Sveti Duh. ");
INSERT INTO hrvbib_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Juda je bio jedan od nas, dionik naše službe. ");
INSERT INTO hrvbib_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Novcem koji je dobio za svoje zlodjelo Juda je kupio polje. Ondje je pao i rasprsnuo se tako da mu se prosula sva utroba. ");
INSERT INTO hrvbib_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Vijest o njegovoj smrti brzo se pronijela među stanovnicima Jeruzalema pa su to polje prozvali Akeldama, što na aramejskome znači ‘Krvavo polje’. ");
INSERT INTO hrvbib_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","To je pretkazano u Knjizi psalama. Ondje piše: ‘Neka njegov dom opusti, neka nitko u njemu ne stanuje!’ i ‘Neka njegovu službu dobije drugi!’ ");
INSERT INTO hrvbib_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Moramo zato odabrati nekoga da zamijeni Judu—nekoga tko je bio s nama cijelo vrijeme dok smo bili s Gospodinom Isusom ");
INSERT INTO hrvbib_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","otkad ga je Ivan krstio pa do uznesenja u nebo. Taj će s nama biti svjedokom Isusova uskrsnuća.” ");
INSERT INTO hrvbib_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Predlože dvojicu: Josipa Barsabu (kojega su zvali i Just) i Matiju. ");
INSERT INTO hrvbib_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Svi se pomole: “Gospodine, ti poznaješ svako srce. Pokaži nam kojega si od ove dvojice izabrao ");
INSERT INTO hrvbib_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","da kao apostol zamijeni izdajnika Judu koji nas je napustio i otišao onamo kamo pripada.” ");
INSERT INTO hrvbib_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Zatim bace kocke i kocka padne na Matiju. Tako je on postao dvanaestim apostolom. ");
INSERT INTO hrvbib_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Na Pedesetnicu, sedam tjedana nakon Isusova uskrsnuća, svi su bili okupljeni na istomu mjestu. ");
INSERT INTO hrvbib_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Odjednom se začuje šum s neba, poput silnoga vihora, te ispuni kuću u kojoj su bili. ");
INSERT INTO hrvbib_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Pojave se zatim plameni jezici te se razdijele i siđu na njih—na svakoga po jedan. ");
INSERT INTO hrvbib_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Svi nazočni napune se Svetoga Duha i počnu govoriti drugim jezicima, kako je komu Duh davao govoriti. ");
INSERT INTO hrvbib_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","A u Jeruzalemu su u to doba boravili pobožni Židovi koji su došli iz svakog naroda pod nebom. ");
INSERT INTO hrvbib_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Kad začuju huk vjetra, dotrče vidjeti što se zbiva i zaprepaste se—jer svatko od njih čuo je vjernike kako govore na njegovu jeziku. ");
INSERT INTO hrvbib_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Iznenađeni i zadivljeni, pitali su: “Nisu li svi ti ljudi što govore Galilejci? ");
INSERT INTO hrvbib_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Kako ih onda svatko od nas čuje na svojemu materinskom jeziku? ");
INSERT INTO hrvbib_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ima nas ovdje Parta, Međana, Elamljana, žitelja Mezopotamije, Judeje i Kapadocije, Ponta i Male Azije, ");
INSERT INTO hrvbib_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frigije i Pamfilije, Egipta i libijskih krajeva oko Cirene. Ima Rimljana koji su u prolazu, ");
INSERT INTO hrvbib_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Židova i obraćenika na židovsku vjeru, Krećana i Arapa, a svi mi čujemo te ljude kako na našim jezicima govore o veličanstvenim Božjim djelima!” ");
INSERT INTO hrvbib_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Stajali su zaprepašteni i pitali jedni druge: “Što bi to moglo značiti?” ");
INSERT INTO hrvbib_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Drugi su se pak rugali: “Pijani su od slatkoga vina!” ");
INSERT INTO hrvbib_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Tada istupi Petar s jedanaestoricom apostola i glasno reče mnoštvu: “Poslušajte me, Židovi i svi što boravite u Jeruzalemu! Znajte: ");
INSERT INTO hrvbib_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","nisu ovi ljudi pijani kao što mislite. Pa tko se još opija u devet sati ujutro? ");
INSERT INTO hrvbib_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","To što vidite ostvarenje je proročanstva proroka Joela: ");
INSERT INTO hrvbib_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘U posljednje ću vrijeme’, veli Gospodin, ‘izliti svojega Duha na sve ljude. Vaši sinovi i kćeri će proricati, vaši mladići će imati viđenja, a starci sne. ");
INSERT INTO hrvbib_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","U te ću dane izliti svojega Duha na svoje sluge i sluškinje te će oni proricati. ");
INSERT INTO hrvbib_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Dat ću čudesa na nebesima i znakove na zemlji: krv, oganj i sukljanje dima. ");
INSERT INTO hrvbib_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Sunce će se pretvoriti u tamu, a mjesec postati krvavocrven prije nego što dođe velik i slavan Dan Gospodnji. ");
INSERT INTO hrvbib_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","I tko god zazove Gospodnje ime, bit će spašen.’ ");
INSERT INTO hrvbib_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Čujte me, Izraelci! Bog je pred vama potvrdio Isusa Nazarećanina silnim djelima i čudesnim znacima koje je, kao što znate, činio. ");
INSERT INTO hrvbib_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Vi ste ipak postupili prema unaprijed odlučenomu Božjem naumu: bezbožničkom ste ga rukom raspeli na križ i pogubili. ");
INSERT INTO hrvbib_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ali Bog ga je oslobodio grozote smrti i uskrisio ga u život jer smrt nije mogla njime vladati. ");
INSERT INTO hrvbib_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Kralj David za njega je rekao: ‘Znam da je Gospodin uvijek sa mnom jer uvijek stoji pokraj mene da ne posrnem. ");
INSERT INTO hrvbib_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Stoga mi se srce raduje, a jezik kliče od veselja. Tijelo mi spokojno počiva. ");
INSERT INTO hrvbib_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Jer nećeš ostaviti moju dušu među mrtvima ni dopustiti da tvoj svetac istrune. ");
INSERT INTO hrvbib_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Pokazao si mi put života. Tvoja će me nazočnost ispuniti radošću.’ ");
INSERT INTO hrvbib_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Braćo draga, s punim pouzdanjem tvrdim: David time nije mislio na sebe—jer on je odavno umro, pokopan je i grob mu je do danas ovdje. ");
INSERT INTO hrvbib_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ali David je bio prorok i znao je da se Bog zakleo jednoga od njegovih potomaka posaditi na njegovo prijestolje kao Mesiju. ");
INSERT INTO hrvbib_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","On je to unaprijed vidio i pretkazao Mesijino uskrsnuće. Rekao je da mu ‘duša neće ostati među mrtvima’ i da mu tijelo neće ‘istrunuti’. ");
INSERT INTO hrvbib_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","To proročanstvo govori o Isusu. Njega je Bog uskrisio—svi smo tomu svjedoci. ");
INSERT INTO hrvbib_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","On sada sjedi na najuzvišenijemu mjestu u nebu, Bogu zdesna. I Otac mu je, kao što je i obećao, dao Svetoga Duha da ga izlije na nas. Danas to čujete i vidite. ");
INSERT INTO hrvbib_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Jer David nikada nije uznesen u nebo, a ipak je rekao: ‘Gospodin je rekao mojem Gospodinu: Sjedni mi s desne strane ");
INSERT INTO hrvbib_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","dok ti ne bacim pod noge tvoje neprijatelje.’ ");
INSERT INTO hrvbib_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Neka dakle pouzdano znade sav Izrael da je Bog tog Isusa kojega ste raspeli učinio i Gospodinom i Mesijom!” ");
INSERT INTO hrvbib_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Te su ih riječi duboko potresle. Upitaju zato Petra i ostale apostole: “Braćo, što da učinimo?” ");
INSERT INTO hrvbib_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Petar im odgovori: “Obratite se Bogu i krstite se u ime Isusa Krista da vam grijesi budu oprošteni pa ćete primiti dar Svetoga Duha. ");
INSERT INTO hrvbib_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","To je obećanje vama i vašoj djeci, pa čak i onima izdaleka koje naš Gospodin Bog pozove.” ");
INSERT INTO hrvbib_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Zatim je još dugo propovijedao zaklinjući i opominjući ih: “Spasite se od ovoga pokvarenog naraštaja!” ");
INSERT INTO hrvbib_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Oni povjeruju njegovim riječima i krste se. Tako se u taj dan Crkvi pridružilo oko tri tisuće duša. ");
INSERT INTO hrvbib_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Bili su postojani u apostolskome učenju, zajedništvu, lomljenju kruha i molitvi. ");
INSERT INTO hrvbib_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Sve je zahvatilo strahopoštovanje jer su apostoli činili mnoga čudesa i znakove. ");
INSERT INTO hrvbib_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Koji su prigrlili vjeru, živjeli su u zajedništvu i sve su dijelili. ");
INSERT INTO hrvbib_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Prodavali su imanja i dijelili svakome prema potrebi. ");
INSERT INTO hrvbib_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Svaki su dan jednodušno i postojano hrlili u Hram na bogoštovlje te se sastajali po kućama da lome kruh radosno i prostodušno, ");
INSERT INTO hrvbib_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","hvaleći Boga i uživajući naklonost svega naroda. A Bog je svednevice zajednici pripajao nove spasenike. ");
INSERT INTO hrvbib_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Dok su Petar i Ivan jednoga popodneva išli u Hram na molitveni sastanak koji se održavao u tri ure, ");
INSERT INTO hrvbib_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","naiđu neki ljudi noseći čovjeka hroma od rođenja, kojega su svaki dan donosili pred hramska vrata zvana Divna da prosi milostinju od ljudi koji ulaze u Hram. ");
INSERT INTO hrvbib_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Kad ugleda Petra i Ivana kako ulaze u Hram, zamoli ih za milostinju. ");
INSERT INTO hrvbib_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Petar i Ivan prodorno ga pogledaju. “Pogledaj nas!” reče mu Petar. ");
INSERT INTO hrvbib_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Hromi ih je čovjek molećivo gledao očekujući milostinju. ");
INSERT INTO hrvbib_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ali Petar mu reče: “Nemam novca, ni srebrna ni zlatna. Ali dajem ti što imam: u ime Isusa Krista Nazarećanina, ustani i hodaj!” ");
INSERT INTO hrvbib_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Uhvati čovjeka za desnu ruku i podigne ga. Čovjeku smjesta ojačaju noge i gležnjevi. ");
INSERT INTO hrvbib_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","On skoči, uspravi se i počne hodati. Uđe s njima u Hram hodajući, poskakujući i slaveći Boga. ");
INSERT INTO hrvbib_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Svi su ga vidjeli kako hoda i slavi Boga. ");
INSERT INTO hrvbib_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Shvatili su da je to isti čovjek koji je na Divnim vratima prosio milostinju i zaprepastili su se, gotovo izbezumili zbog toga što se s njim dogodilo. ");
INSERT INTO hrvbib_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","On se pak držao Petra i Ivana koji su bili u Salomonovu trijemu. Zato svi nagrnu onamo. ");
INSERT INTO hrvbib_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Kad je to vidio Petar, reče ljudima: “Što se čudite ovomu, Izraelci? I što gledate u nas, kao da smo mi svojom snagom ili pobožnošću učinili da ovaj čovjek prohoda! ");
INSERT INTO hrvbib_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Učinio je to Abrahamov, Izakov i Jakovljev Bog, Bog naših predaka, i tako proslavio svojega slugu Isusa. A vi ste toga Isusa predali da ga uhite i odrekli ste ga se pred Pilatom kad ga je već odlučio osloboditi. ");
INSERT INTO hrvbib_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Odrekli ste se Sveca i Pravednika, a namolili ste da vam oslobode ubojicu. ");
INSERT INTO hrvbib_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ubili ste začetnika života, ali Bog ga je uskrisio od mrtvih. Mi smo tomu svjedoci. ");
INSERT INTO hrvbib_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Isusovo je ime iscijelilo ovoga čovjeka, a znate da je bio hrom. Vjera u Isusovo ime vratila mu je potpuno zdravlje naočigled svih vas. ");
INSERT INTO hrvbib_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Braćo, znam da ste s Isusom tako postupili zbog neznanja, kao i vaši poglavari. ");
INSERT INTO hrvbib_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ali Bog je tako ispunio ono što su proroci prorekli o Mesiji: da će pretrpjeti sve to. ");
INSERT INTO hrvbib_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Pokajte se dakle za grijehe i obratite se Bogu pa će vam on izbrisati grijehe ");
INSERT INTO hrvbib_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","i poslati vam vrijeme okrepe: unaprijed vam namijenjenoga Mesiju Isusa. ");
INSERT INTO hrvbib_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","On mora ostati u nebu sve dok ne dođe vrijeme svekolike obnove koju je Bog odavno obećao kroz svete proroke. ");
INSERT INTO hrvbib_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Mojsije je rekao: ‘Gospodin, vaš Bog, podignut će vam proroka poput mene iz vašega vlastitog naroda. Dobro slušajte sve što vam on kaže! ");
INSERT INTO hrvbib_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","A tko god ne bude slušao tog proroka, neka se iskorijeni iz naroda!’ ");
INSERT INTO hrvbib_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Još od Samuela, svi su proroci navijestili ovo što se sada događa. ");
INSERT INTO hrvbib_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Vi ste djeca tih proroka i Saveza koji je Bog sklopio s vašim precima. Bog je rekao Abrahamu: ‘Tvoje će potomstvo biti na blagoslov svim narodima na zemlji.’ ");
INSERT INTO hrvbib_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Bog je podignuo svojega slugu i najprije ga je poslao da vas blagoslovi—da se svatko od vas obrati od svojih opačina.” ");
INSERT INTO hrvbib_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Dok su Petar i Ivan još govorili narodu, priđu im svećenici, zapovjednik hramske straže i neki saduceji. ");
INSERT INTO hrvbib_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Uznemirilo ih je što su, na Isusovu primjeru, navješćivali uskrsnuće od mrtvih. ");
INSERT INTO hrvbib_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Uhite ih zato i, kako je već bila večer, bace u tamnicu do jutra. ");
INSERT INTO hrvbib_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ali mnogi koji su ih čuli kako propovijedaju Riječ povjerovali su i broj vjernika uvećao se na otprilike pet tisuća, ne brojeći žene i djecu. ");
INSERT INTO hrvbib_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Sutradan se u Jeruzalemu sastanu poglavari, starješine i pismoznanci. ");
INSERT INTO hrvbib_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Bio je ondje veliki svećenik Ana s Kaifom, Ivanom, Aleksandrom i drugima iz velikosvećeničke loze. ");
INSERT INTO hrvbib_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Dozovu pred sebe apostole i upitaju ih: “Kakvom silom i u čije ime ste to učinili?” ");
INSERT INTO hrvbib_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Petar im, pun Svetoga Duha, reče: “Narodni poglavari i starješine! ");
INSERT INTO hrvbib_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Odgovaramo li mi to zbog dobroga djela koje smo učinili bolesnu čovjeku? Želite li znati kako je iscijeljen? ");
INSERT INTO hrvbib_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Znajte i vi, i cijeli izraelski narod, da taj čovjek stoji pred vama zdrav jer je iscijeljen po imenu Isusa Krista iz Nazareta, kojega ste vi raspeli, ali ga je Bog uskrisio od mrtvih! ");
INSERT INTO hrvbib_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jer Isus je taj ‘kamen’ koji ste vi ‘graditelji’ odbacili, a koji je ‘postao ugaonim kamenom’. ");
INSERT INTO hrvbib_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ni po kome drugome nema spasenja! Nema drugoga imena pod nebom po kojemu se ljudi mogu spasiti.” ");
INSERT INTO hrvbib_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Članove Vijeća zaprepastila je Petrova i Ivanova neustrašivost jer su mogli jasno vidjeti da su neizobraženi i neuki ljudi. Znali su da su bili sa Isusom, ");
INSERT INTO hrvbib_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","ali kako je iscijeljeni čovjek stajao pred njima, nisu im mogli proturječiti. ");
INSERT INTO hrvbib_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Zato narede Petru i Ivanu da iziđu iz vijećnice te počnu raspravljati: ");
INSERT INTO hrvbib_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Što da radimo s tim ljudima? Ne možemo zanijekati da su učinili čudesni znak—za to znaju svi u Jeruzalemu. ");
INSERT INTO hrvbib_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ali možda možemo spriječiti da se to još više ne razglasi. Zabranimo im da ikomu opet govore o Isusovu imenu.” ");
INSERT INTO hrvbib_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Pozovu zato apostole i zapovjede im da nipošto ne govore o Isusovu imenu i ne poučavaju o njemu. ");
INSERT INTO hrvbib_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ali Petar i Ivan im odgovore: “Zar smatrate da je pred Bogom pravo da slušamo vas, a ne njega? ");
INSERT INTO hrvbib_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ne možemo a da ne govorimo o onomu što smo čuli i vidjeli.” ");
INSERT INTO hrvbib_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Vijećnici im opet zaprijete ali ih na koncu puste zato što nisu znali kako ih kazniti a da se narod ne pobuni. Jer svi su slavili Boga zbog toga što se dogodilo: ");
INSERT INTO hrvbib_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","čudesno je iscijeljen čovjek koji je bio hrom više od četrdeset godina. ");
INSERT INTO hrvbib_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Čim su ih oslobodili, Petar i Ivan jave se drugim vjernicima i ispričaju im što su im rekli veliki svećenici i starješine. ");
INSERT INTO hrvbib_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Kad su to čuli, svi podignu glas i jednodušno se pomole Bogu: “Gospodine, ti si stvorio nebo, zemlju, more i sve što je u njima! ");
INSERT INTO hrvbib_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Po Svetome Duhu kroz svojega slugu Davida odavno si rekao: ‘Zašto se narodi bune? Zašto puci snuju ispraznosti? ");
INSERT INTO hrvbib_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Zemaljski se kraljevi spremaju na bitku protiv Gospodina i protiv njegova Mesije.’ ");
INSERT INTO hrvbib_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","To se dogodilo u ovomu gradu! Herod Antipa, Poncije Pilat, zajedno s narodima, urotili su se s izraelskim narodom protiv tvojega svetog Sluge Isusa, tvojega Pomazanika. ");
INSERT INTO hrvbib_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Učinili su ono što si predodredio svojom snagom i voljom. ");
INSERT INTO hrvbib_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Gospodine, čuj njihove prijetnje i daj svojim slugama hrabrosti da navješćuju tvoju Riječ! ");
INSERT INTO hrvbib_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Pruži svoju moćnu ruku da se događaju iscjeljenja, čudesa i znamenje u imenu tvojega svetog Sluge Isusa.” ");
INSERT INTO hrvbib_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Kad su se tako pomolili, potrese se zgrada u kojoj su bili. Svi se napune Svetoga Duha te su smjelo navješćivali Božju riječ. ");
INSERT INTO hrvbib_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Mnoštvo vjernika bilo je jednoga srca i duše: nitko nije ono što je imao zadržavao za sebe, nego su sve međusobno dijelili. ");
INSERT INTO hrvbib_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","A apostoli su s velikom silom svjedočili o uskrsnuću Gospodina Isusa. Velika je milost bila nad njima. ");
INSERT INTO hrvbib_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Nitko od njih nije oskudijevao jer su oni koji su posjedovali zemljišta i kuće prodavali svoju imovinu ");
INSERT INTO hrvbib_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","i novac donosili apostolima da njime raspolažu. Oni su ga dijelili svakomu prema potrebama. ");
INSERT INTO hrvbib_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Tako je Josip kojega su apostoli zvali Barnaba (što znači: “Sin utjehe”), levit, rodom s Cipra, ");
INSERT INTO hrvbib_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","imao njivu. Prodao ju je i donio novac apostolima da njime raspolažu. ");
INSERT INTO hrvbib_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Neki pak čovjek imenom Ananija proda skupa sa svojom ženom Safirom imanje. ");
INSERT INTO hrvbib_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","U dogovoru sa ženom odvoji dio novca i zadrži ga, a ostatak donese apostolima na raspolaganje. ");
INSERT INTO hrvbib_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Petar mu reče: “Ananija! Zašto ti je Sotona ispunio srce? Lagao si Svetome Duhu i zadržao dio novca za sebe. ");
INSERT INTO hrvbib_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Nisi morao prodati imanje i ostalo bi tvoje. A i kad si ga prodao, novac je bio tvoj. Mogao si odlučiti da ga dadeš ili da ga zadržiš. Zašto si takvo što učinio? Nisi slagao ljudima, nego Bogu!” ");
INSERT INTO hrvbib_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Čim je Ananija to čuo, sruši se i izdahne. Silan strah spopadne sve koji su za to čuli. ");
INSERT INTO hrvbib_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Priđu neki mladići, poviju ga u plahte te iznesu i pokopaju. ");
INSERT INTO hrvbib_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Nakon otprilike tri sata dođe njegova žena ne znajući što se dogodilo. ");
INSERT INTO hrvbib_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Petar ju upita: “Reci mi, jeste li za ovoliko novca prodali zemljište?” “Jesmo”, odgovori žena. “Za toliko.” ");
INSERT INTO hrvbib_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","“Pa što vam je bilo da ste se tako urotili kušati Duha Gospodnjega? Ondje su na vratima mladići koji su ti pokopali muža. I tebe će iznijeti!” reče Petar. ");
INSERT INTO hrvbib_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ona se smjesta sruši na pod i umre. Mladići uđu i videći da je mrtva, iznesu ju i pokopaju pokraj muža. ");
INSERT INTO hrvbib_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Cijelu Crkvu i sve koji su za to čuli spopadne silan strah. ");
INSERT INTO hrvbib_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Preko ruku apostola događala su se mnoga čudesa i znamenja među narodom. Svi su se vjernici jednodušno okupljali u Salomonovu trijemu. ");
INSERT INTO hrvbib_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Nitko im se nije usuđivao pridružiti, ali narod ih je veličao. ");
INSERT INTO hrvbib_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Sve je više i više muškaraca i žena vjerovalo u Gospodina. ");
INSERT INTO hrvbib_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ljudi su na ulice iznosili bolesnike na ležajevima i nosiljkama ne bi li na njih u prolazu pala barem Petrova sjena. ");
INSERT INTO hrvbib_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Mnoštvo je nagrnulo iz sela oko Jeruzalema. Donosili su bolesnike i opsjednute nečistim duhovima. I svi su ozdravljali. ");
INSERT INTO hrvbib_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Veliki svećenik i njegovi pristaše iz saducejske sljedbe razjare se od zavisti. ");
INSERT INTO hrvbib_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Uhite apostole i bace ih u javni zatvor. ");
INSERT INTO hrvbib_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ali kad je pala noć, dođe anđeo Gospodnji te otvori vrata zatvora i izvede ih. Reče im: ");
INSERT INTO hrvbib_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Idite samo i nastavite ljudima u Hramu govoriti sve o Životu!” ");
INSERT INTO hrvbib_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Apostoli tako u svanuće uđu u Hram i odmah počnu poučavati. U međuvremenu stignu veliki svećenik i njegove pristaše te sazovu Vijeće i izraelske starješine. Pošalju zatim u zatvor po apostole da ih izvedu pred sud. ");
INSERT INTO hrvbib_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ali kad stražari stignu onamo, ne nađu ih u tamnici. Vrate se i jave: ");
INSERT INTO hrvbib_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Zatvor je zaključan i stražari su pred vratima, ali kad smo ih otvorili i ušli, unutra nije bilo nikoga!” ");
INSERT INTO hrvbib_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Kad su zapovjednik hramske straže i veliki svećenici to čuli, zbunjeno su se pitali što sve to znači. ");
INSERT INTO hrvbib_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Uto im netko dođe javiti da su zatvorenici u Hramu te da ondje poučavaju narod. ");
INSERT INTO hrvbib_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Zapovjednik ode sa stražarima i uhiti ih, ali ne na silu jer se bojao da ih narod ne kamenuje. ");
INSERT INTO hrvbib_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Izvedu tako apostole pred Vijeće. ");
INSERT INTO hrvbib_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Nismo li vam strogo zabranili poučavati u ime toga čovjeka?” upita ih veliki svećenik. “A vi ste napunili Jeruzalem učenjem o Isusu i još nas optužujete za njegovu smrt!” ");
INSERT INTO hrvbib_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ali Petar i apostoli odgovore: “Valja nam se pokoravati Bogu, a ne ljudima. ");
INSERT INTO hrvbib_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Bog naših predaka uskrisio je Isusa, kojega ste smaknuli pribivši ga na križ. ");
INSERT INTO hrvbib_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Uzvisio ga je svojom desnicom da bude Vođa i Spasitelj, da izraelskomu narodu omogući da se obrati i da im oprosti grijehe. ");
INSERT INTO hrvbib_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Svjedoci svega toga smo mi i Sveti Duh kojega je Bog dao onima što mu se pokoravaju.” ");
INSERT INTO hrvbib_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Nato se vijećnici razgnjeve. Htjeli su ih smaknuti. ");
INSERT INTO hrvbib_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ali ustane neki farizej, član Vijeća, imenom Gamaliel. Bio je to zakonoznanac kojega je narod vrlo cijenio. Zapovjedi da apostole načas izvedu. ");
INSERT INTO hrvbib_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Onda reče vijećnicima: “Izraelci, dobro razmislite što ćete učiniti s tim ljudima! ");
INSERT INTO hrvbib_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Podigao se tako prije i neki Teuda tvrdeći da je netko velik. Stekao je oko četiri stotine pristaša, ali je ubijen i svi su se razbježali. ");
INSERT INTO hrvbib_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Poslije se u vrijeme popisa stanovništva podigao Juda Galilejac i poveo narod za sobom. I on je ubijen i sljedbenici su mu se razbježali. ");
INSERT INTO hrvbib_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Savjetujem zato: ne dirajte te ljude i pustite ih. Potječu li njihovo poučavanje i njihova djela od čovjeka, propast će. ");
INSERT INTO hrvbib_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","A ako su od Boga, nećete ih moći uništiti. Pazite da ne zaratite s Bogom.” Vijeće prihvati njegov savjet. ");
INSERT INTO hrvbib_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Pozovu apostole, išibaju ih, zabrane im da govore u Isusovo ime te ih puste. ");
INSERT INTO hrvbib_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Apostoli odu radosni iz Vijeća što ih je Bog smatrao dostojnima da trpe pogrdu zbog Isusova imena. ");
INSERT INTO hrvbib_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","I svaki dan su u Hramu i po kućama navješćivali da je Isus Mesija. ");
INSERT INTO hrvbib_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ali kako je broj vjernika naglo rastao, neki se počnu žaliti. Židovi koji su govorili grčki prigovarali su Židovima koji su govorili hebrejski da zanemaruju njihove udovice u svagdanjem dijeljenju pomoći. ");
INSERT INTO hrvbib_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Dvanaestorica zato sazovu vjernike. “Mi apostoli ne bismo trebali služiti pri stolovima umjesto da propovijedamo i poučavamo Riječ. ");
INSERT INTO hrvbib_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Pronađite, braćo, među sobom sedam ljudi na dobrome glasu, punih Svetoga Duha i mudrosti. Njih ćemo za to zadužiti, ");
INSERT INTO hrvbib_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","a mi ćemo se posvetiti molitvi te propovijedanju i poučavanju Riječi.” ");
INSERT INTO hrvbib_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Prijedlog se svima svidio. Izaberu Stjepana, čovjeka punog vjere i Svetoga Duha, te Filipa, Prohora, Nikanora, Timona, Parmenu i Nikolu koji je došao iz Antiohije. On se kao poganin obratio na židovsku vjeru, a sada je postao kršćaninom. ");
INSERT INTO hrvbib_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Postave njih sedmoricu pred apostole, a oni polože na njih ruke i pomole se. ");
INSERT INTO hrvbib_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Božja riječ sve se više širila. Broj vjernika u Jeruzalemu naglo je rastao, a i mnogi su židovski svećenici prihvaćali vjeru. ");
INSERT INTO hrvbib_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stjepan je bio pun Božje milosti i sile. Činio je među narodom silna čudesa i znamenje. ");
INSERT INTO hrvbib_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ali pobune se neki iz takozvane sinagoge Slobodnjaka, Židovi iz Cirene, Aleksandrije, Cilicije i Male Azije, pa počnu s njime raspravljati. ");
INSERT INTO hrvbib_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Nitko od njih nije se mogao nositi s mudrošću i Duhom kojim je Stjepan govorio. ");
INSERT INTO hrvbib_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Nagovore zato neke ljude da za njega kažu: “Čuli smo ga da govori pogrdne riječi protiv Mojsija i protiv Boga.” ");
INSERT INTO hrvbib_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Podjarili su i narod i starješine i pismoznance. Oni dođu po njega, ščepaju ga i odvuku u Vijeće. ");
INSERT INTO hrvbib_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Dovedu onamo krivokletnike koji izjave: “Ovaj čovjek uvijek govori protiv Hrama i protiv Mojsijeva zakona. ");
INSERT INTO hrvbib_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Čuli smo da kaže kako će taj Isus iz Nazareta uništiti Hram i promijeniti običaje koje nam je Mojsije predao.” ");
INSERT INTO hrvbib_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Svi koji su sjedili u Vijeću pogledaju u Stjepana i opaze da mu je lice poput anđeoskog. ");
INSERT INTO hrvbib_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Veliki svećenik ga upita: “Je li to istina?” ");
INSERT INTO hrvbib_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Stjepan odgovori: “Braćo i časni oci, poslušajte me! Naš se slavni Bog ukazao našemu ocu Abrahamu u Mezopotamiji, prije nego što se nastanio u Haranu. ");
INSERT INTO hrvbib_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Rekao mu je: ‘Idi iz svoje zemlje, iz svojega zavičaja, u zemlju koju ću ti pokazati.’ ");
INSERT INTO hrvbib_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Abraham tako napusti kaldejsku zemlju i nastani se u Haranu. Odande ga je Bog, nakon smrti njegova oca, preselio u ovu zemlju u kojoj vi sada živite. ");
INSERT INTO hrvbib_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ali nije mu u njoj dao nikakvu baštinu, ni stopu zemlje, nego ju je obećao dati njemu i njegovim potomcima iako Abraham još nije imao djece. ");
INSERT INTO hrvbib_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Bog mu je također rekao da će njegovi potomci živjeti u tuđoj zemlji kao robovi i da će ih ondje tlačiti četiri stotine godina. ");
INSERT INTO hrvbib_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ali rekao je: ‘Narodu kojemu će robovati ja ću suditi. A zatim će izići i klanjati mi se na ovomu mjestu.’ ");
INSERT INTO hrvbib_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Zatim je Bog s Abrahamom sklopio savez obrezanja. Tako je Izak, Abrahamov sin, obrezan kad mu je bilo osam dana. Izak je tako učinio sa svojim sinom Jakovom, a Jakov s dvanaestoricom sinova, patrijarsima židovskoga naroda. ");
INSERT INTO hrvbib_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","A Jakovljevi sinovi, patrijarsi, bili su ljubomorni na svojega brata, Josipa, pa su ga prodali kao roba u Egipat. Ali Bog je bio s njim ");
INSERT INTO hrvbib_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","i izbavljao ga iz svih nevolja. Darivao ga je svojom naklonošću i mudrošću pred egipatskim kraljem, faraonom, te ga je on postavio za upravitelja Egipta i cijeloga svojeg dvora. ");
INSERT INTO hrvbib_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Poslije je zavladala glad u cijelome Egiptu i Kanaanu. Naši su preci bili u velikoj nevolji: nisu mogli naći hrane. ");
INSERT INTO hrvbib_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Jakov je čuo da u Egiptu ima žita pa je onamo poslao svoje sinove, naše pretke. ");
INSERT INTO hrvbib_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Kad su drugi put otišli onamo, Josip je otkrio braći tko je, pa je faraon upoznao njegovu obitelj. ");
INSERT INTO hrvbib_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Zatim je Josip poslao po svojega oca Jakova i svu svoju rodbinu da dođu u Egipat. Bilo ih je sedamdeset pet. ");
INSERT INTO hrvbib_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Tako je Jakov došao u Egipat. Ondje su umrli on i njegovi sinovi, naši preci. ");
INSERT INTO hrvbib_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Prenijeli su ih u Sihem i položili u grob koji je Abraham za srebro kupio od Hamorovih sinova. ");
INSERT INTO hrvbib_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Kako se bližilo vrijeme ispunjenja obećanja koje je Bog dao Abrahamu, u Egiptu je naš narod rastao i množio se. ");
INSERT INTO hrvbib_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ali na egipatsko prijestolje dođe novi kralj, koji nije poznavao Josipa. ");
INSERT INTO hrvbib_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Zlostavljao je naše pretke i primoravao roditelje da ostavljaju svoju novorođenčad da pomre. ");
INSERT INTO hrvbib_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","U to se doba rodio Mojsije. Bio je prelijepo dijete. Roditelji su se o njemu brinuli tri mjeseca. ");
INSERT INTO hrvbib_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Kad su ga na koncu morali ostaviti, pronašla ga je faraonova kći i odgojila kao vlastitoga sina. ");
INSERT INTO hrvbib_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Mojsije je poučen svoj egipatskoj mudrosti. Postao je silnim i u riječima i na djelima. ");
INSERT INTO hrvbib_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Kad mu je bilo četrdeset godina, srce ga ponuka da posjeti svoje rođake, izraelski narod. ");
INSERT INTO hrvbib_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ondje ugleda kako neki Egipćanin zlostavlja Izraelca. Braneći zlostavljanog Izraelca, suprotstavi se Egipćaninu te se osveti i ubije ga. ");
INSERT INTO hrvbib_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Mislio je da će njegova braća shvatiti kako ga je Bog poslao da ih spasi, ali oni nisu razumjeli. ");
INSERT INTO hrvbib_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Sutradan opet ode k njima i ugleda kako se tuku dva Izraelca. Počne ih nagovarati da se pomire: ‘Ljudi!’ reče im. ‘Braća ste! Zašto zlostavljate jedni druge?!’ ");
INSERT INTO hrvbib_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ali onaj koji je zlostavljao bližnjega odgurne Mojsija i reče: ‘Tko je tebe postavio poglavarom i sucem nad nama? ");
INSERT INTO hrvbib_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Kaniš li i mene ubiti kao onoga Egipćanina jučer?’ ");
INSERT INTO hrvbib_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Kad je to čuo, Mojsije pobjegne i skloni se u midjansku zemlju. Ondje su mu se rodila dva sina. ");
INSERT INTO hrvbib_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Četrdeset godina nakon toga ukazao mu se anđeo u pustinji blizu gore Sinaja, u plamtećoj vatri gorućega grma. ");
INSERT INTO hrvbib_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Mojsije je opazio gorući grm i zadivljen se pitao što je to. Dok je prilazio da bolje pogleda, začuje Gospodnji glas: ");
INSERT INTO hrvbib_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Ja sam Abrahamov, Izakov i Jakovljev Bog.’ Mojsije se silno preplaši. Nije se usuđivao gledati. ");
INSERT INTO hrvbib_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Gospodin mu reče: ‘Izuj sandale s nogu jer stojiš na svetoj zemlji. ");
INSERT INTO hrvbib_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Dobro sam vidio nevolju svojega naroda u Egiptu i čuo njegove uzdahe. Sišao sam da ga izbavim. Idi sada! Šaljem te u Egipat!’ ");
INSERT INTO hrvbib_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Toga istog Mojsija kojega su se odrekli pitajući ga: ‘Tko je tebe postavio poglavarom i sucem nad nama?’ Bog im je poslao kao poglavara i otkupitelja da ih izbavi, preko anđela koji mu se ukazao u gorućem grmu. ");
INSERT INTO hrvbib_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","On ih je izveo iz Egipta čineći čudesa i znakovlje. Vodio ih je kroz Crveno more i kroz pustinju četrdeset godina. ");
INSERT INTO hrvbib_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Taj je isti Mojsije rekao izraelskome narodu: ‘Bog će vam podignuti proroka poput mene iz vašega vlastitog naroda.’ ");
INSERT INTO hrvbib_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Isti je Mojsije bio posrednikom između izraelskoga naroda i anđela koji mu je dao riječi života na gori Sinaju da ih preda nama. ");
INSERT INTO hrvbib_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Naši preci nisu mu se htjeli pokoriti, nego su ga odbili i srcima se opet okrenuli prema Egiptu. ");
INSERT INTO hrvbib_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Rekli su Aronu: ‘Napravi nam bogove koji će ići pred nama jer ne znamo što se dogodilo s Mojsijem koji nas je izveo iz Egipta!’ ");
INSERT INTO hrvbib_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Načinili su idola u obliku teleta, prinijeli mu žrtve i veselili se tomu što su učinili. ");
INSERT INTO hrvbib_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","A Bog se okrenuo od njih i pustio ih da se klanjaju suncu, mjesecu i zvijezdama kao svojim bogovima. U proročkoj je knjizi zapisano: ‘Zar ste meni prinosili žrtve za četrdeset godina u pustinji, Izraele? ");
INSERT INTO hrvbib_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ne; okrenuli ste se poganskim bogovima— Molohovu svetištu i zvijezdi boga Refana, likovima koje ste načinili da biste im se klanjali. Zato ću vas odvesti u progonstvo dalje od Babilona!’ ");
INSERT INTO hrvbib_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Naši su preci sa sobom kroz pustinju nosili Šator svjedočanstva. Bio je načinjen točno prema predlošku koji je Mojsiju pokazao Bog. ");
INSERT INTO hrvbib_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Mnogo godina zatim, kad je Jošua ratovao protiv poganskih naroda koje je Bog istjerao iz te zemlje, Šator su unijeli sa sobom u novu zemlju. Ondje je ostao sve do vremena kralja Davida. ");
INSERT INTO hrvbib_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Davidu je Bog bio milostiv, te ga je zamolio za dopuštenje da izgradi Hram Jakovljevu Bogu. ");
INSERT INTO hrvbib_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ali izgradio ga je tek Salomon. ");
INSERT INTO hrvbib_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Ipak, Svevišnji ne prebiva u hramovima koje su izgradile ljudske ruke. Kao što kaže prorok: ");
INSERT INTO hrvbib_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Nebo mi je prijestolje, a zemlja podnožje mojim nogama. Kakav mi vi dom možete izgraditi? Gdje da počivam? ");
INSERT INTO hrvbib_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Zar nije moja ruka stvorila sve u nebu i na zemlji?’ ");
INSERT INTO hrvbib_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Tvrdoglavi ste! Pogani ste u srcima i gluhi za istinu! Uvijek se opirete Svetome Duhu, baš kao i vaši preci! ");
INSERT INTO hrvbib_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ima li ijedan prorok kojega vaši oci nisu progonili? Pobili su one koji su pretkazali dolazak Pravednika—kojega ste vi izdali i smaknuli. ");
INSERT INTO hrvbib_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Preko anđela ste dobili Zakon, a niste ga se držali!” ");
INSERT INTO hrvbib_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Kad su to čuli, židovski se vođe toliko razgnjeve na Stjepana da na njega počnu škripati zubima. ");
INSERT INTO hrvbib_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ali Stjepan, pun Svetoga Duha, upre pogled u nebo i ugleda Božju slavu i Isusa kako stoji na počasnome mjestu, Bogu zdesna. ");
INSERT INTO hrvbib_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","“Vidim otvorena nebesa”, reče, “i Sina Čovječjega kako stoji zdesna Bogu.” ");
INSERT INTO hrvbib_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Oni nato rukama poklope uši i vičući iz svega glasa složno navale na njega. ");
INSERT INTO hrvbib_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Izvuku ga iz grada i počnu kamenovati. Svjedoci odlože ogrtače do nogu mladića Savla. ");
INSERT INTO hrvbib_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Dok su ga kamenovali, Stjepan je zazivao: “Gospodine Isuse, primi moj duh!” ");
INSERT INTO hrvbib_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Zatim se baci na koljena i poviče iz sve snage: “Gospodine, ne uzmi im ovo za grijeh!” Pošto to izgovori, izdahne. ");
INSERT INTO hrvbib_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Savao je odobravao Stjepanovo smaknuće. Tog je dana započeo veliki val progona Crkve u Jeruzalemu pa su se svi osim apostola razbježali po Judeji i Samariji. ");
INSERT INTO hrvbib_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Neki pobožni ljudi pokopali su Stjepana i održali veliko žalovanje za njim. ");
INSERT INTO hrvbib_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Savao je pak pustošio Crkvu. Išao je od kuće do kuće te muškarce i žene odvlačio i predavao u tamnicu. ");
INSERT INTO hrvbib_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ali vjernici koji su pobjegli iz Jeruzalema posvuda su išli navješćujući Radosnu vijest o Isusu. ");
INSERT INTO hrvbib_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filip je, primjerice, otišao u Samariju i ondje ljudima propovijedao o Kristu. ");
INSERT INTO hrvbib_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Mnoštvo je jednodušno prihvaćalo Filipove riječi slušajući ga i gledajući čudesa koja je činio. ");
INSERT INTO hrvbib_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Izgonio je mnoge nečiste duhove koji su vrišteći izlazili iz opsjednutih. Iscijelio je mnoge uzete i hrome. ");
INSERT INTO hrvbib_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","U tomu je gradu tako zavladala velika radost. ");
INSERT INTO hrvbib_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Neki čovjek imenom Šimun već se dugo ondje bavio čarobnjaštvom. Opčaravao je narod i izdavao se za velikog čovjeka. ");
INSERT INTO hrvbib_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Samarijanci su mu se, od najmanjega do najvećega, priklanjali i nazivali ga “velikim” i “Božjom silom”. ");
INSERT INTO hrvbib_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Činili su to zato što ih je dugo opčaravao svojim vradžbinama. ");
INSERT INTO hrvbib_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ali tada su povjerovali Filipu koji je navješćivao Radosnu vijest o Božjemu kraljevstvu i imenu Isusa Krista. Krstili su se muškarci i žene. ");
INSERT INTO hrvbib_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","I sam je Šimun povjerovao i krstio se te slijedio Filipa kuda god je išao. Zadivljeno je promatrao čudesa i znamenje koje je Filip činio. ");
INSERT INTO hrvbib_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Kad su apostoli u Jeruzalemu čuli da su u Samariji prihvatili Božju riječ, pošalju onamo Petra i Ivana. ");
INSERT INTO hrvbib_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Oni dođu i pomole se za obraćenike da prime Svetoga Duha. ");
INSERT INTO hrvbib_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Jer Sveti Duh još nije sišao ni na koga od njih. Bili su samo kršteni u ime Gospodina Isusa. ");
INSERT INTO hrvbib_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Polagali su ruke na njih te su primali Svetoga Duha. ");
INSERT INTO hrvbib_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Kad je Šimun vidio da ljudi primaju Svetoga Duha kad apostoli na njih polože ruke, ponudi apostolima novac: ");
INSERT INTO hrvbib_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Dajte i meni tu moć da svatko na koga položim ruke primi Svetoga Duha!” ");
INSERT INTO hrvbib_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ali Petar mu odgovori: “Propao i taj novac i ti skupa s njim! Misliš li da Božji dar možeš kupiti novcem? ");
INSERT INTO hrvbib_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ti na ovo nemaš pravo jer ti srce nije pravo pred Bogom! ");
INSERT INTO hrvbib_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Obrati se od svoje zloće i moli se Gospodinu pa će ti možda oprostiti nakane zlog srca. ");
INSERT INTO hrvbib_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Vidim da si pun gorčine i okovan grijehom.” ");
INSERT INTO hrvbib_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","“Vi se za mene molite Gospodinu da me ne snađe to što ste rekli!” odgovori Šimun. ");
INSERT INTO hrvbib_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Pošto su svjedočili i propovijedali Božju riječ u Samariji, Petar i Ivan vratili su se u Jeruzalem. Putem su se zaustavljali u samarijskim selima navješćujući Radosnu vijest. ");
INSERT INTO hrvbib_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","A Filipu reče anđeo Gospodnji: “Kreni na jug pustom cestom što iz Jeruzalema vodi u Gazu.” ");
INSERT INTO hrvbib_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","I Filip pođe. Susretne nekog Etiopljanina, dvorskog rizničara, visokog dostojanstvenika etiopske kraljice, kandake. On je išao u Jeruzalem da se pokloni Bogu. ");
INSERT INTO hrvbib_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Vraćajući se iz Jeruzalema sjedio je u kočiji i čitao naglas iz Knjige proroka Izaije. ");
INSERT INTO hrvbib_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Sveti Duh reče Filipu: “Priđi i hodaj uz kočiju!” ");
INSERT INTO hrvbib_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filip pritrči. Začuje kako čovjek čita Izaiju pa upita: “Razumijete li to što čitate?” ");
INSERT INTO hrvbib_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","“A kako da razumijem ako me tko ne pouči?” odgovori čovjek. Zamoli Filipa da se popne u kočiju i sjedne do njega. ");
INSERT INTO hrvbib_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Čitao je ovaj ulomak: “Odveli su ga kao ovcu na klanje. Kao janje nijemo pred onima što ga strižu, ni usta nije otvorio. ");
INSERT INTO hrvbib_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ponižen je i lišen pravde. Tko da opiše njegov naraštaj? Jer život je njegov uzet sa zemlje.” ");
INSERT INTO hrvbib_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Dostojanstvenik zatim upita Filipa: “Reci mi, molim te, govori li to prorok o sebi ili o kome drugome?” ");
INSERT INTO hrvbib_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Filip mu, počevši od toga ulomka, objasni evanđelje i navijesti Isusa. ");
INSERT INTO hrvbib_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Vozeći se tako naiđu na neku vodu, a dostojanstvenik upita: “Evo vode! Što me priječi da se krstim?” ");
INSERT INTO hrvbib_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Zapovjedi da kočija stane pa obojica siđu do vode. Filip ga ondje krsti. ");
INSERT INTO hrvbib_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Kad su izišli iz vode, Sveti Duh ponese Filipa i dostojanstvenik ga više nije vidio. On radosno nastavi svojim putem, ");
INSERT INTO hrvbib_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","a Filip se nađe u gradu Azotu. Kud god je išao, putem je po gradovima propovijedao Radosnu vijest sve dok nije stigao u Cezareju. ");
INSERT INTO hrvbib_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","A Savao, neprestano dišući prijetnjom ubojstva prema Gospodinovim učenicima, ode k velikom svećeniku. ");
INSERT INTO hrvbib_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Zatraži od njega pisma za sinagoge u Damasku da može sve sljedbenike Puta, i muškarce i žene, na koje ondje naiđe, dovesti okovane u Jeruzalem. ");
INSERT INTO hrvbib_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Kad se približio Damasku, odjednom ga obasja svjetlost s neba. ");
INSERT INTO hrvbib_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Padne na zemlju. Začuje nato glas kako mu govori: “Savle, Savle! Zašto me progoniš?” ");
INSERT INTO hrvbib_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","“Tko si ti, Gospodine?” upita Savao. “Ja sam Isus kojega ti progoniš”, odgovori glas. ");
INSERT INTO hrvbib_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","“Ustani i pođi u grad! Ondje će ti se reći što da činiš.” ");
INSERT INTO hrvbib_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Savlovi su suputnici ostali bez riječi. Čuli su glas, ali nikoga nisu vidjeli. ");
INSERT INTO hrvbib_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Savao ustane sa zemlje. Oči su mu bile otvorene, ali ništa nije vidio. Povedu ga zato za ruku i uvedu u Damask. ");
INSERT INTO hrvbib_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Tri dana nije ništa vidio niti je jeo i pio. ");
INSERT INTO hrvbib_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","A u Damasku je živio vjernik imenom Ananija. Njemu Gospodin reče u viđenju: “Ananija!” “Molim, Gospodine?” odazove se on. ");
INSERT INTO hrvbib_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Gospodin mu reče: “Idi u Ravnu ulicu, u Judinu kuću, i ondje potraži Savla iz Tarza. Eno ga ondje; moli se. ");
INSERT INTO hrvbib_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","U viđenju koje sam mu dao vidio je čovjeka imenom Ananija kako ulazi i polaže na njega ruke da progleda.” ");
INSERT INTO hrvbib_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","“Ali, Gospodine,” odgovori Ananija, “od tolikih sam čuo da je mnogo zla učinio tvojim svetima u Jeruzalemu! ");
INSERT INTO hrvbib_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ima punomoć od velikog svećenika da okuje u lance sve koji prizivaju tvoje ime.” ");
INSERT INTO hrvbib_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Gospodin mu odgovori: “Idi i učini što ti kažem. Izabrao sam Savla da ponese moje ime poganima i kraljevima i izraelskome narodu. ");
INSERT INTO hrvbib_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Pokazat ću mu koliko mora pretrpjeti zbog mojega imena.” ");
INSERT INTO hrvbib_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ananija ode onamo, položi ruke na Savla i reče: “Brate Savle, Gospodin Isus koji ti se ukazao na putu poslao me je da progledaš i da se napuniš Svetoga Duha.” ");
INSERT INTO hrvbib_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Savlu s očiju odmah spadne nešto poput ljuski te progleda. Ustane zatim i krsti se. ");
INSERT INTO hrvbib_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Onda nešto pojede i okrijepi se. Savao je nekoliko dana ostao s vjernicima u Damasku. ");
INSERT INTO hrvbib_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Smjesta je po sinagogama počeo propovijedati da je Isus Božji Sin. ");
INSERT INTO hrvbib_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Svi koji su ga slušali bili su zaprepašteni. “Pa nije li ovo onaj isti koji je u Jeruzalemu istrebljivao Isusove sljedbenike?” pitali su. “Zar on nije došao ovamo zato da ih uhiti i okovane odvede pred velike svećenike?” ");
INSERT INTO hrvbib_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Savlovo je propovijedanje bivalo sve silnije. Zbunjivao je Židove u Damasku dokazujući im da je Isus Mesija. ");
INSERT INTO hrvbib_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Nakon podosta vremena, židovski ga vođe odluče pogubiti, ");
INSERT INTO hrvbib_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","ali Savao dozna za njihovu nakanu. Danonoćno su nadzirali gradska vrata ne bi li ga ubili. ");
INSERT INTO hrvbib_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Zato ga vjernici noću spuste preko gradskoga zida u košari. ");
INSERT INTO hrvbib_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Kad je Savao stigao u Jeruzalem, pokušao se sastati s vjernicima, ali svi su ga se bojali. Nisu vjerovali da je zaista vjernik. ");
INSERT INTO hrvbib_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Tada ga Barnaba povede k apostolima te im ispriča da je Savao na putu u Damask vidio Gospodina i što mu je Gospodin rekao te kako je u Damasku hrabro propovijedao u Isusovo ime. ");
INSERT INTO hrvbib_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Od tada se s njima slobodno družio po Jeruzalemu i hrabro je propovijedao u Gospodnje ime. ");
INSERT INTO hrvbib_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Raspravljao je s nekim Židovima koji su govorili grčki pa ga oni nakane ubiti. ");
INSERT INTO hrvbib_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Kad su vjernici za to čuli, odvedu ga u Cezareju i pošalju doma u Tarz. ");
INSERT INTO hrvbib_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Crkva je u cijeloj Judeji, Galileji i Samariji živjela u miru. Izgrađivala se i napredovala. Vjernici su hodili u strahu Gospodnjemu i u utješeni Svetim Duhom. ");
INSERT INTO hrvbib_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Obilazeći svete posvuda, Petar je došao i k Božjemu narodu u gradu Lidi. ");
INSERT INTO hrvbib_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ondje upozna nekog čovjeka imenom Eneja, koji je osam godina ležao uzet u postelji. ");
INSERT INTO hrvbib_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Petar mu reče: “Eneja, ozdravlja te Isus Krist! Ustani i namjesti postelju!” Čovjek smjesta ustane. ");
INSERT INTO hrvbib_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Kad su to vidjeli svi žitelji Lide i Šarona, obrate se Gospodinu. ");
INSERT INTO hrvbib_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","U Jopi je živjela i vjernica imenom Tabita (što znači: “Košuta”). Život joj se sastojao u tomu da čini dobra i milosrdna djela. ");
INSERT INTO hrvbib_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Upravo se tada ona razboli i umre. Pripremili su ju za pokop i položili ju u sobi na katu. ");
INSERT INTO hrvbib_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Ali kad su čuli da je Petar blizu, u Lidi, pošalju k njemu dvojicu i zamole ga: “Odmah dođi k nama!” ");
INSERT INTO hrvbib_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Petar zato odmah pođe s njima. Čim je stigao povedu ga u sobu na katu. Ondje ga okruže udovice plačući i pokazujući mu ogrtače i drugu odjeću koju im je Košuta izradila dok je bila s njima. ");
INSERT INTO hrvbib_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Ali Petar ih sve pošalje iz sobe. Klekne i pomoli se, a zatim se okrene prema tijelu i reče: “Tabita, ustani!” Ona otvori oči, pogleda Petra i sjedne. ");
INSERT INTO hrvbib_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","On joj pruži ruku i pridigne ju. Zatim pozove udovice i svete pa im pokaže da je oživjela. ");
INSERT INTO hrvbib_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Vijest se pronese cijelim gradom te mnogi povjeruju u Gospodina. ");
INSERT INTO hrvbib_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Petar je neko vrijeme ostao u Jopi, u kući nekoga kožara Šimuna. ");
INSERT INTO hrvbib_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","U Cezareji je živio čovjek imenom Kornelije, stotnik takozvane italske čete. ");
INSERT INTO hrvbib_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","I on i njegovi ukućani bili su pobožni i bojali su se Izraelova Boga. Velikodušno je dijelio narodu milodare i stalno se molio Bogu. ");
INSERT INTO hrvbib_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","On oko tri ure popodne u viđenju jasno ugleda kako mu prilazi Božji anđeo. “Kornelije!” pozove ga anđeo. ");
INSERT INTO hrvbib_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Kornelije se prestrašeno zagleda u njega. “Tko si ti, gospodine?” upita anđela. Anđeo odgovori: “Tvoje su molitve i milodari siromašnima uzišli pred Boga kao podsjetnik. ");
INSERT INTO hrvbib_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Pošalji zato ljude u Jopu po Šimuna nazvanoga Petar. ");
INSERT INTO hrvbib_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","On je gost u kući kožara Šimuna, koja se nalazi uz more.” ");
INSERT INTO hrvbib_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Čim je anđeo otišao, Kornelije pošalje dvojicu slugu i pobožnoga, odanog vojnika ");
INSERT INTO hrvbib_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","i sve im ispriča te ih pošalje u Jopu. ");
INSERT INTO hrvbib_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Sutradan oko podneva, dok su se Kornelijevi ljudi približavali gradu, Petar se popne na krov da se moli. ");
INSERT INTO hrvbib_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Bio je gladan. Dok su mu pripremali jelo, on padne u zanos. ");
INSERT INTO hrvbib_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Vidio je kako se nebo otvara i kako se na zemlju spušta nešto poput velikog platna zavezanoga na četiri kraja. ");
INSERT INTO hrvbib_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","U njemu je bilo svakakvih četveronožnih životinja, gmazova i ptica nebeskih. ");
INSERT INTO hrvbib_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Neki mu glas reče: “Ustani, Petre! Zakolji i jedi!” ");
INSERT INTO hrvbib_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","“Nipošto, Gospodine”, odgovori Petar. “Nikad još nisam okusio ništa zabranjeno židovskim zakonom.” ");
INSERT INTO hrvbib_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","“Ne nazivaj nečistim ono što Bog proglasi čistim!” opet se javi glas. ");
INSERT INTO hrvbib_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","To se triput ponovilo, a platno se zatim uzdigne u nebo. ");
INSERT INTO hrvbib_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Dok se Petar dvoumio što bi to viđenje moglo značiti, dođu Kornelijevi ljudi. Raspitali su se gdje je Šimunova kuća i pojavili se na vratima. ");
INSERT INTO hrvbib_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Upitaju je li ondje u gostima neki Šimun Petar. ");
INSERT INTO hrvbib_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Dok je Petar još razmišljao o viđenju, Sveti Duh mu reče: “Traže te trojica ljudi. ");
INSERT INTO hrvbib_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Ustani i pođi s njima ne dvoumeći se jer sam ih ja poslao.” ");
INSERT INTO hrvbib_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Petar siđe k njima i reče: “Evo me. Ja sam taj kojega tražite. Zašto ste došli?” ");
INSERT INTO hrvbib_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","“Poslao nas je rimski stotnik Kornelije, pravedan čovjek koji se boji Boga Izraelova”, odgovore oni. “Svi ga Židovi cijene. Njemu je anđeo rekao da pošalje po tebe, da mu dođeš govoriti.” ");
INSERT INTO hrvbib_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Petar ih tada pozove da uđu i ugosti ih. Sutradan ustane i pođe s njima. Pratila su ga još neka braća iz Jope. ");
INSERT INTO hrvbib_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Drugoga dana stignu u Cezareju. Kornelije ih je čekao okupivši rodbinu i prisne prijatelje. ");
INSERT INTO hrvbib_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Kad je Petar kročio u kuću, Kornelije mu pohrli u susret i padne mu pred noge klanjajući mu se. ");
INSERT INTO hrvbib_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","“Ustani! I ja sam samo čovjek!” reče mu Petar ");
INSERT INTO hrvbib_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","te razgovarajući s njim uđe u kuću gdje je bilo okupljeno mnogo ljudi. ");
INSERT INTO hrvbib_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Petar im reče: “Znate da Zakon Židovima zabranjuje družiti se s poganima ili ulaziti k njima u kuću. Ali meni je Bog pokazao da nikoga ne smatram nečistim. ");
INSERT INTO hrvbib_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Zato sam bez pogovora došao kad ste me pozvali. Sada mi dakle recite zašto ste me zvali.” ");
INSERT INTO hrvbib_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kornelije odgovori: “Prije četiri dana molio sam se u svojem domu baš u ovo doba, u tri ure poslije podne. Odjednom se preda mnom pojavi neki čovjek u sjajnoj odjeći ");
INSERT INTO hrvbib_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","i reče mi: ‘Kornelije, molitve su ti uslišane i Bog je vidio tvoje milodare siromašnima. ");
INSERT INTO hrvbib_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Pošalji ljude u Jopu da dovedu Šimuna Petra. On je gost u kući kožara Šimuna, koja se nalazi uz more.’ ");
INSERT INTO hrvbib_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Zato sam smjesta poslao po tebe i dobro je da si došao. Evo nas dakle ovdje pred Bogom, da čujemo što ti je Gospodin zapovjedio da nam kažeš!” ");
INSERT INTO hrvbib_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Petar reče: “Sada uistinu shvaćam: Bog nije pristran. ");
INSERT INTO hrvbib_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","U svakomu narodu prihvaća one koji ga se boje i koji čine što je pravedno. ");
INSERT INTO hrvbib_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Izraelskome je narodu poslao svoju Riječ, navijestio im evanđelje: mir s Bogom po Isusu Kristu koji je Gospodar svih. ");
INSERT INTO hrvbib_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Znate što se događalo po svoj Judeji. Sve je to započelo u Galileji, otkad je Ivan propovijedao krštenje. ");
INSERT INTO hrvbib_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Znate da je Bog pomazao Isusa iz Nazareta svojim Svetim Duhom i silom. Isus je, zato što je Bog bio s njim, hodio čineći dobro i iscjeljujući sve koje je đavao držao u svojoj vlasti. ");
INSERT INTO hrvbib_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Mi apostoli svjedoci smo svega što je činio u Izraelu i u Jeruzalemu. Smaknuli su ga i raspeli, ");
INSERT INTO hrvbib_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","ali ga je Bog treći dan podignuo od mrtvih i dopustio mu da se pokaže— ");
INSERT INTO hrvbib_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","ne svemu narodu nego nama koje je još prije izabrao da budemo njegovim svjedocima. Jeli smo i pili s njim pošto je uskrsnuo od mrtvih. ");
INSERT INTO hrvbib_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Zapovjedio nam je da posvuda propovijedamo i svjedočimo da je Bog Isusa postavio sucem svima: i živima i mrtvima. ");
INSERT INTO hrvbib_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","On je taj o kojemu su svjedočili proroci kad su rekli da svatko tko u njega vjeruje u njegovu imenu prima oproštenje grijeha.” ");
INSERT INTO hrvbib_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Dok je Petar još govorio, Sveti Duh siđe na sve koji su slušali. ");
INSERT INTO hrvbib_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Židovski vjernici koji su došli s Petrom čudili su se daru Svetoga Duha koji se izlio i na pogane ");
INSERT INTO hrvbib_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","jer su ih čuli kako govore u drugim jezicima i slave Boga. Petar tada reče: ");
INSERT INTO hrvbib_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Može li tko uskratiti krštenje ovima koji su primili Svetoga Duha baš kao i mi?” ");
INSERT INTO hrvbib_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Zapovjedi zato da se krste u ime Isusa Krista. Zamole ga zatim da pri Korneliju ostane još nekoliko dana. ");
INSERT INTO hrvbib_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Apostoli i braća u Judeji doznali su da su pogani prihvatili Božju riječ. ");
INSERT INTO hrvbib_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Kad je Petar došao u Jeruzalem, neki su mu židovski vjernici počeli prigovarati: ");
INSERT INTO hrvbib_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Ušao si u poganski dom! Čak si i jeo s njima!” ");
INSERT INTO hrvbib_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Petar im ispriča kako se to dogodilo: ");
INSERT INTO hrvbib_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“U Jopi sam se molio i u zanosu imao viđenje: nešto poput velikog platna zavezanoga na četiri kraja kako se s neba spušta do mene. ");
INSERT INTO hrvbib_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Pogledam unutra i vidim svakakve četveronošce, zvijeri i gmazove te ptice nebeske. ");
INSERT INTO hrvbib_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Začujem glas koji mi govori: ‘Ustani, Petre! Zakolji i jedi!’ ");
INSERT INTO hrvbib_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","‘Nipošto, Gospodine’, odgovorim. ‘Nikad još nisam okusio ništa zabranjeno Zakonom.’ ");
INSERT INTO hrvbib_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","‘Ne nazivaj nečistim ono što Bog proglasi čistim!’ opet se javi glas s neba. ");
INSERT INTO hrvbib_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","To se triput ponovilo, a onda se sve uzdignulo u nebo. ");
INSERT INTO hrvbib_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Upravo tada pojave se pred kućom trojica ljudi iz Cezareje koji su došli po mene. ");
INSERT INTO hrvbib_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Sveti Duh rekao mi je da idem s njima ne oklijevajući. Sa mnom su pošla i ova šestorica braće i ubrzo smo stigli u dom čovjeka koji je poslao po nas. ");
INSERT INTO hrvbib_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ispripovjedio nam je kako mu se doma ukazao anđeo i rekao mu: ‘Pošalji ljude u Jopu po Šimuna nazvanoga Petar. ");
INSERT INTO hrvbib_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","On će ti reći kako da se spasiš i ti i svi tvoji ukućani.’ ");
INSERT INTO hrvbib_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Počeo sam im propovijedati Radosnu vijest, ali tek što sam počeo siđe na njih Sveti Duh, baš kao što je u početku na nas sišao. ");
INSERT INTO hrvbib_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Tada sam se sjetio što nam je rekao Gospodin: ‘Ivan je krstio vodom, ali vi ćete biti kršteni Svetim Duhom.’ ");
INSERT INTO hrvbib_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Kad je već Bog dao tim poganima isti dar kao i nama koji smo povjerovali u Gospodina Isusa Krista, tko sam ja da mu se protivim?” ");
INSERT INTO hrvbib_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Kad su to čuli, umire se i počnu slaviti Boga. “Bog je i poganima dao da se obrate i da imaju vječni život!” govorili su. ");
INSERT INTO hrvbib_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Vjernici, koji su se u međuvremenu razbježali zbog nevolje koja ih je snašla zbog Stjepana, došli su do Fenicije, Cipra i sirijske Antiohije. Radosnu vijest propovijedali su samo Židovima. ");
INSERT INTO hrvbib_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ali neki od vjernika koji su u Antiohiju došli s Cipra i Cirene počnu i poganima propovijedati o Gospodinu Isusu. ");
INSERT INTO hrvbib_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ruka Gospodnja bila je s njima te velik broj pogana povjeruje i obrati se Gospodinu. ");
INSERT INTO hrvbib_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ta je vijest doprla do Crkve u Jeruzalemu pa oni pošalju Barnabu u Antiohiju. ");
INSERT INTO hrvbib_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Kad je vidio kakvu im je milost Bog ukazao, razveseli se te je ohrabrivao vjernike da ostanu vjerni Gospodinu. ");
INSERT INTO hrvbib_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnaba je bio čestit čovjek, pun Svetoga Duha i čvrste vjere. I veliko mnoštvo ljudi obrati se Gospodinu. ");
INSERT INTO hrvbib_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Barnaba zatim ode u Tarz potražiti Savla. ");
INSERT INTO hrvbib_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Pronađe ga i odvede u Antiohiju. Obojica su ondje ostali godinu dana i na crkvenim sastancima poučavali veliko mnoštvo ljudi. Ondje su se vjernici prvi put prozvali kršćanima. ");
INSERT INTO hrvbib_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","U to doba dođu u Antiohiju neki proroci iz Jeruzalema. ");
INSERT INTO hrvbib_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Jedan od njih, imenom Agab, pretkaže po Duhu da će u cijelomu Rimskom Carstvu zavladati velika glad. To se i dogodi za Klaudijeve vladavine. ");
INSERT INTO hrvbib_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Vjernici iz Antiohije zato odluče da svatko od njih pošalje pomoć koliku može braći u Judeji. ");
INSERT INTO hrvbib_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Učine tako te pošalju pomoć starješinama po Barnabi i Savlu. ");
INSERT INTO hrvbib_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Tada kralj Herod Agripa počne zlostavljati neke vjernike iz Crkve. ");
INSERT INTO hrvbib_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ivanova brata Jakova pogubi mačem. ");
INSERT INTO hrvbib_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Kad je vidio da je to drago židovskim vođama, uhiti i Petra za Blagdana beskvasnih kruhova. ");
INSERT INTO hrvbib_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Uhiti ga i baci u tamnicu te zapovjedi da ga čuvaju četiri vojničke straže. Kanio ga je poslije Pashe izvesti pred narod da mu sude. ");
INSERT INTO hrvbib_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Dok je Petar bio u tamnici, Crkva se žarko molila Bogu za njega. ");
INSERT INTO hrvbib_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Noć prije nego što ga je Herod kanio izvesti pred sud Petar je spavao okovan između dvojice vojnika, a pred vratima su stražarili vojnici. ");
INSERT INTO hrvbib_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ali odjednom ćeliju obasja svjetlost: pojavi se anđeo Gospodnji. Udari Petra po rebrima i reče “Brzo ustani!” I lanci mu spadnu s ruku. ");
INSERT INTO hrvbib_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Zatim mu anđeo reče: “Opaši se i obuj sandale.” Petar posluša. “Obuci sada ogrtač i pođi za mnom!” zapovjedi anđeo. ");
INSERT INTO hrvbib_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Petar iziđe i pođe za njim, ali nije znao da se to zaista događa. Mislio je da ima viđenje. ");
INSERT INTO hrvbib_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Prošli su pokraj prve i druge straže te došli do željeznih vrata na izlazu iz zatvora. Ona se sama otvore te iziđu na ulicu. Kad su prošli jednu ulicu, anđeo odjednom ode od njega. ");
INSERT INTO hrvbib_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Petar napokon shvati što se dogodilo: “Gospodin je zaista poslao anđela da me izbavi od Heroda i od onoga što su mi Židovi htjeli učiniti!” reče on. ");
INSERT INTO hrvbib_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Kad je to shvatio, uputi se domu Marije, majke Ivana zvanoga Marko. Ondje su mnogi bili okupljeni na molitvi. ");
INSERT INTO hrvbib_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Zakuca na dvorišna vrata. Sluškinja imenom Ruža dođe poslušati tko kuca. ");
INSERT INTO hrvbib_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Kad je prepoznala Petrov glas, od veselja zaboravi otvoriti vrata. Utrči u kuću i javi im da je pred vratima Petar. ");
INSERT INTO hrvbib_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","“Poludjela si”, odgovore joj, ali ona je to i dalje uporno tvrdila. “Vjerojatno je to njegov anđeo”, zaključe zatim. ");
INSERT INTO hrvbib_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Petar je i dalje kucao. Kad su na koncu otvorili i ugledali ga, zaprepaste se. ");
INSERT INTO hrvbib_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","On im rukom pokaže da šute te ispriča kako ga je sam Gospodin izveo iz tamnice. “Javite Jakovu i drugoj braći što se dogodilo!” reče. Zatim ode na drugo mjesto. ");
INSERT INTO hrvbib_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Kad se razdanilo, među vojnicima nastane uzbuna zbog Petrova nestanka. ");
INSERT INTO hrvbib_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herod Agripa pošalje potragu za njim, a kad ga ne nađu, sasluša stražare i zapovjedi da se smaknu. Ode zatim iz Judeje u Cezareju te ondje ostane neko vrijeme. ");
INSERT INTO hrvbib_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herod je bio u žestoku sukobu sa žiteljima Tira i Sidona. Pošalju mu stoga izaslanike da s pomoću kraljevskoga komornika Blasta, kojega su pridobili, zaiskaju mir jer su hranu nabavljali iz Herodove zemlje. ");
INSERT INTO hrvbib_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Na dan sastanka Herod obuče kraljevsko ruho te sjedne na prijestolje i počne im govoriti. ");
INSERT INTO hrvbib_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Narod je vikao: “Božji je to glas, a ne ljudski!” ");
INSERT INTO hrvbib_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ali zato što je prihvatio da mu se ljudi klanjaju i što nije dao slavu Bogu, udari ga anđeo Gospodnji te ga izjedu crvi i umre. ");
INSERT INTO hrvbib_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ali Božja riječ brzo se širila i stjecala nove vjernike. ");
INSERT INTO hrvbib_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Kad su Barnaba i Savao završili sa služenjem u Jeruzalemu, vrate se u Antiohiju i povedu sa sobom Ivana zvanog Marko. ");
INSERT INTO hrvbib_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Među prorocima i učiteljima u sirijskoj Antiohiji bili su Barnaba, Šimun zvani Niger, Lucije Cirenac, Manahen, koji je kao dijete othranjen s Herodom Antipom, i Savao. ");
INSERT INTO hrvbib_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Dok su jednom obavljali Božju službu i postili, Sveti Duh im reče: “Pošaljite Barnabu i Savla na djelo na koje sam ih pozvao.” ");
INSERT INTO hrvbib_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Postili su i dalje i molili. Zatim na njih polože ruke i pošalju ih na put. ");
INSERT INTO hrvbib_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Savla i Barnabu Sveti je Duh poslao u Seleuciju, a odande jedrenjakom na Cipar. ");
INSERT INTO hrvbib_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Kad su došli u grad Salaminu, navješćivali su Božju riječ po židovskim sinagogama. Ivan Marko pratio ih je i pomagao im. ");
INSERT INTO hrvbib_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Kad su tako prešli sav otok i stigli do grada Pafa, naiđu na nekog vračara, samozvanog proroka, Židova, imenom Barjesus. ");
INSERT INTO hrvbib_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Bio je iz kruga namjesnika Sergija Pavla, razborita čovjeka. Sergije pozove Barnabu i Savla pa ih zamoli da mu kazuju Božju riječ, ");
INSERT INTO hrvbib_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","ali usprotivi im se vračar Elim (tako mu ime glasi na grčkome) i namjesnika počne odvraćati od vjere. ");
INSERT INTO hrvbib_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Tada ga Savao, kojega su zvali i Pavao, pun Svetoga Duha, ošine pogledom ");
INSERT INTO hrvbib_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","i reče: “Sine đavolski pun lukavštine i pakosti, neprijatelju svake pravednosti, dokle ćeš iskrivljavati ispravne putove Gospodnje? ");
INSERT INTO hrvbib_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Udarit će te sada ruka Gospodnja! Oslijepit ćeš na neko vrijeme i nećeš gledati sunca!” Na vračara smjesta padne tama te on počne glavinjati uokolo tražeći tko će ga voditi. ");
INSERT INTO hrvbib_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Kad je namjesnik vidio što se dogodilo, povjeruje i zadivi se učenju Gospodnjem. ");
INSERT INTO hrvbib_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pavao i njegovi pratitelji otisnu se lađom iz Pafa te stignu u luku Pergu u Pamfiliji. Ondje ih napusti Ivan Marko i vrati se u Jeruzalem. ");
INSERT INTO hrvbib_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Barnaba i Pavao iz Perge odu u pizidijsku Antiohiju. U subotu odu u sinagogu i sjednu. ");
INSERT INTO hrvbib_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Nakon uobičajenog čitanja Mojsijeva zakona i Proroka nadstojnici sinagoge im poruče: “Braćo, imate li koju riječ utjehe za narod, govorite!” ");
INSERT INTO hrvbib_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Nato Pavao ustane, podigne ruku i reče: “Izraelci i svi koji se bojite izraelskoga Boga, čujte: ");
INSERT INTO hrvbib_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Bog ovoga, izraelskog naroda izabrao je naše pretke i učinio da napreduju u Egiptu. Zatim ih je svojom silnom rukom izveo iz te zemlje u kojoj su robovali. ");
INSERT INTO hrvbib_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Četrdesetak godina ih je u pustinji strpljivo podnosio. ");
INSERT INTO hrvbib_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Zatro je sedam naroda u kanaanskoj zemlji da bi im njihovu zemlju dao u naslijeđe. ");
INSERT INTO hrvbib_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Sve je to trajalo kojih četiristo pedeset godina. Potom im je dao suce da vladaju njima—sve do proroka Samuela. ");
INSERT INTO hrvbib_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Tada su ljudi zaiskali kralja pa im je Bog dao Šaula, Kišova sina iz Benjaminova plemena, da vlada četrdeset godina. ");
INSERT INTO hrvbib_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Ali njega je svrgnuo i postavio im za kralja Davida, za kojega je sam rekao: ‘Jišajev sin David čovjek je po mojemu srcu jer će učiniti sve što želim.’ ");
INSERT INTO hrvbib_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Iz Davidova je potomstva Bog po svojemu obećanju Izraelu izveo Spasitelja Isusa. ");
INSERT INTO hrvbib_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Prije Isusova dolaska Ivan Krstitelj propovijedao je svem izraelskom narodu da se mora obratiti Bogu i krstiti. ");
INSERT INTO hrvbib_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Kad je Ivan završavao sa svojoj službom, govorio je: ‘Nisam onaj za kojega me smatrate. Nisam Mesija. Ali on dolazi za mnom. Ja mu nisam dostojan ni biti robom.’ ");
INSERT INTO hrvbib_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Braćo moja, sinovi Abrahamovi i svi koji se bojite Izraelova Boga, ta je riječ spasenja nama namijenjena! ");
INSERT INTO hrvbib_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Žitelji Jeruzalema i njihovi vođe ispunili su proročanstvo osudivši Isusa na smrt. Nisu ga prepoznali ni shvatili da je on taj o kojemu su pisali proroci iako svake subote čitaju iz proročkih knjiga. ");
INSERT INTO hrvbib_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Tražili su od Pilata da ga smakne iako za to nisu imali nikakav razlog. ");
INSERT INTO hrvbib_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Kad su tako ispunili proročanstva o njegovoj smrti, skinuli su ga s križa i položili u grob. ");
INSERT INTO hrvbib_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ali Bog ga je uskrisio od mrtvih. ");
INSERT INTO hrvbib_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Mnogo dana ukazivao se onima koji su s njim išli iz Galileje u Jeruzalem. Oni sad o njemu svjedoče narodu. ");
INSERT INTO hrvbib_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","A mi vam navješćujemo Radosnu vijest. Bog je ispunio obećanje koje je dao našim precima ");
INSERT INTO hrvbib_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","za života nas, njihove djece, uskrisivši Isusa od mrtvih. O tomu govori Drugi psalam: ‘Ti si moj Sin, danas sam ti postao Ocem.’ ");
INSERT INTO hrvbib_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Jer Bog je obećao da će ga podignuti od mrtvih i da nikada više neće umrijeti. Rekao je: ‘Vama ću dati svete blagoslove koje sam pouzdano obećao Davidu.’ ");
INSERT INTO hrvbib_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Na drugome mjestu kaže: ‘Nećeš dopustiti da tvoj svetac istrune.’ ");
INSERT INTO hrvbib_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","To se ne odnosi na Davida jer je on služio svojemu naraštaju po Božjoj volji i zatim preminuo i bio pokopan, a tijelo mu je istrunulo. ");
INSERT INTO hrvbib_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Riječ je o nekomu drugome—kojega je Bog podignuo od mrtvih i čije tijelo nije istrunulo. ");
INSERT INTO hrvbib_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Čujte me, braćo! U tome čovjeku, Isusu, imate oproštenje svojih grijeha. ");
INSERT INTO hrvbib_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Tko god povjeruje u njega, oslobađa se krivnje i opravdan je pred Bogom za sve za što vas Mojsijev zakon nije mogao opravdati. ");
INSERT INTO hrvbib_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Pazite! Nemojte da vas snađe ono što piše u Prorocima: ");
INSERT INTO hrvbib_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Gledajte, vi preziratelji, snebivajte se i umrite! Jer u vaše dane činim djelo u koje ne biste vjerovali da vam tko o njemu ispriča.’” ");
INSERT INTO hrvbib_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Kad su Pavao i Barnaba izlazili iz sinagoge, ljudi ih zamole da im iduće subote dođu govoriti o tomu. ");
INSERT INTO hrvbib_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Mnogi Židovi i pobožni obraćenici na judaizam su nakon sastanka u sinagogi išli za Pavlom i Barnabom. Poticali su ih: “Božjom milošću, ostanite vjerni!”. ");
INSERT INTO hrvbib_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Sljedeće subote gotovo je sav grad nagrnuo da čuje riječ Gospodnju. ");
INSERT INTO hrvbib_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Kad su židovski vođe ugledali mnoštvo, spopadne ih zavist. Vrijeđali su Pavla i suprotstavljali se onomu što je govorio. ");
INSERT INTO hrvbib_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Na to su im Pavao i Barnaba hrabro rekli: “Božju riječ najprije je trebalo navijestiti vama Židovima. Ali kako je vi odbacujete i sami sebe smatrate nedostojnima vječnoga života, navijestit ćemo ju poganima. ");
INSERT INTO hrvbib_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Jer to nam je zapovjedio Gospodin rekavši: ‘Postavio sam te za svjetlost poganima, da doneseš spasenje u sve krajeve zemlje.’” ");
INSERT INTO hrvbib_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Kad su pogani to čuli, počnu se radovati i zahvaljivati Gospodinu na njegovoj Riječi. I svi koji su bili određeni za vječni život, povjeruju. ");
INSERT INTO hrvbib_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","A Riječ Gospodnja pronijela se cijelim tim krajem. ");
INSERT INTO hrvbib_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ali židovski vođe nagovore neke utjecajne bogobojazne žene i gradske dužnosnike te oni pokrenu progon protiv Pavla i Barnabe i istjeraju ih iz grada. ");
INSERT INTO hrvbib_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Njih dvojica stresu prašinu s nogu protiv njih i odu u grad Ikonij. ");
INSERT INTO hrvbib_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","A vjernici su bili puni radosti i Svetoga Duha. ");
INSERT INTO hrvbib_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","U Ikoniju Pavao i Barnaba također uđu u židovsku sinagogu te su propovijedali s takvom silom da je povjerovalo veliko mnoštvo Židova i pogana. ");
INSERT INTO hrvbib_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ali Židovi koji nisu htjeli poslušati podjare pogane protiv Pavla i Barnabe klevećući ih. ");
INSERT INTO hrvbib_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Apostoli su ipak ondje dugo ostali i hrabro propovijedali o Božjoj milosti. A Bog je potvrđivao njihove riječi dajući da im da čine čudesa i znamenja. ");
INSERT INTO hrvbib_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Žitelji grada podijelili su se. Neki su bili za Židove, drugi za apostole. ");
INSERT INTO hrvbib_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Na koncu pogani i Židovi sa svojim poglavarima navale na njih da ih kamenuju. ");
INSERT INTO hrvbib_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Kad su to doznali, pobjegnu u likaonske gradove Listru i Derbu ");
INSERT INTO hrvbib_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","te su ondje navješćivali Radosnu vijest. ");
INSERT INTO hrvbib_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","U Listri Pavao i Barnaba naiđu na čovjeka hroma od rođenja. Nikada nije hodao. ");
INSERT INTO hrvbib_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Slušao je Pavlovo propovijedanje i Pavao je vidio da vjeruje u iscjeljenje ");
INSERT INTO hrvbib_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","pa mu glasno reče: “Ustani!” Čovjek skoči i prohoda. ");
INSERT INTO hrvbib_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Kad je mnoštvo vidjelo što je Pavao učinio, poviče na svojemu likaonskom narječju: “Bogovi u ljudskom obličju sišli su k nama!” ");
INSERT INTO hrvbib_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Zaključili su da je Barnaba grčki bog Zeus, a Pavao Hermes jer je vodio glavnu riječ. ");
INSERT INTO hrvbib_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Iz Zeusova hrama u predgrađu dođe svećenik s bikovima i cvjetnim vijencima te su ih on inarod htjeli žrtvovati apostolima pred gradskim vratima. ");
INSERT INTO hrvbib_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Kad su za to čuli Barnaba i Pavao, razderu svoju odjeću i potrče među narod vičući: ");
INSERT INTO hrvbib_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Ljudi, što to radite? Mi smo samo smrtnici, jednako kao i vi! Došli smo vam navijestiti Radosnu vijest, da se od tih ispraznosti obratite živomu Bogu koji je stvorio nebo, zemlju, more i sve što je u njima! ");
INSERT INTO hrvbib_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Prije je puštao da svaki narod ide svojim putem, ");
INSERT INTO hrvbib_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","ali nikada vas nije ostavljao bez svjedočanstva o sebi. Uvijek je slao dobročinstva s neba: kišu, dobru žetvu, hranu i radost u srca.” ");
INSERT INTO hrvbib_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Ali svejedno su jedva spriječili mnoštvo da im prinese žrtvu. ");
INSERT INTO hrvbib_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Neki Židovi iz Antiohije i Ikonija dođu i podjare svjetinu da kamenuje Pavla. Zatim ga odvuku izvan grada misleći da je mrtav. ");
INSERT INTO hrvbib_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ali kad su ga okružili vjernici, Pavao ustane i vrati se u grad. Sutradan ode s Barnabom u Derbu. ");
INSERT INTO hrvbib_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Kad su u Derbi navijestili Radosnu vijest i stekli brojne učenike, vrate se u Listru, Ikonij i Antiohiju. ");
INSERT INTO hrvbib_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Ondje su snažili vjernike i ohrabrivali ih da ustraju u vjeri podsjećajući ih da u Božje kraljevstvo treba ući kroz mnoge nevolje. ");
INSERT INTO hrvbib_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Po crkvama su postavljali starješine te su ih, pošto su za njih postili i molili, predavali na brigu Gospodinu u kojega su povjerovali. ");
INSERT INTO hrvbib_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Zatim kroz Pizidiju opet dođu u Pamfiliju. ");
INSERT INTO hrvbib_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","U Pergi su opet propovijedali Riječ, a zatim odu u Ataliju. ");
INSERT INTO hrvbib_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Odande na koncu odjedre u sirijsku Antiohiju odakle su i započeli putovanje, povjereni Božjoj milosti za djelo koje su dovršili. ");
INSERT INTO hrvbib_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Kad stignu u Antiohiju, sazovu Crkvu i ispripovijedaju što je Bog sve kroz njih učinio na putu: kako je i poganima otvorio vrata vjere. ");
INSERT INTO hrvbib_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","I dugo su ondje ostali s vjernicima. ");
INSERT INTO hrvbib_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Dok su Pavao i Barnaba bili u sirijskoj Antiohiji, dođu neki ljudi iz Judeje te počnu poučavati kršćane: “Ako se ne obrežete prema starome židovskom običaju kojemu vas je poučio Mojsije, ne možete se spasiti.” ");
INSERT INTO hrvbib_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pavao i Barnaba suprotstave se te nastane velika prepirka i uvelike se raspravljalo. Na koncu Pavao i Barnaba s nekolicinom tamošnjih vjernika odu u Jeruzalem da o tomu razgovaraju s apostolima i starješinama. ");
INSERT INTO hrvbib_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Crkva ih dakle pošalje na put. Prolazeći kroz Feniciju i Samariju, braći su, na njihovu veliku radost, pripovijedali o obraćenju pogana. ");
INSERT INTO hrvbib_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Kad su stigli u Jeruzalem, Crkva, apostoli i starješine lijepo ih dočekaju. Oni im ispripovijedaju što je sve Bog kroz njih učinio. ");
INSERT INTO hrvbib_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Ali ustanu neki koji su prije obraćenja bili u farizejskoj sljedbi i kažu: “Treba ih obrezati i zapovjediti im da se drže Mojsijeva zakona!” ");
INSERT INTO hrvbib_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Sastanu se dakle apostoli i starješine da to razmotre. ");
INSERT INTO hrvbib_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Nakon dugačke rasprave Petar ustane i reče im: “Braćo, vi znate da me je Bog prije mnogo vremena izabrao između vas da propovijedam poganima Radosnu vijest i da oni uzvjeruju. ");
INSERT INTO hrvbib_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Bog koji zna ljudska srca potvrdio je da prihvaća pogane darujući im Svetoga Duha, baš kao što ga je i nama dao. ");
INSERT INTO hrvbib_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Nikakve razlike nije pravio između nas i njih—i njihova je srca očistio vjerom. ");
INSERT INTO hrvbib_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Zašto onda sad iskušavate Boga tovareći na vjernike poganskoga podrijetla jaram koji ni mi ni naši preci nismo mogli nositi? ");
INSERT INTO hrvbib_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Vjerujemo, naprotiv, da se svi spašavamo milošću našega Gospodina Isusa Krista.” ");
INSERT INTO hrvbib_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Nato svi ušute. Slušali su Barnabu i Pavla koji su pripovijedali o čudesima i znacima koje je Bog kroz njih učinio među poganima. ");
INSERT INTO hrvbib_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Kad su sve ispričali, Jakov reče: “Braćo, poslušajte me! ");
INSERT INTO hrvbib_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Petar vam je ispričao kako je Bog prvi put pohodio pogane da neke od njih pripoji svojemu narodu. ");
INSERT INTO hrvbib_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","A obraćenje pogana u skladu je s proroštvima. U Svetome pismu piše: ");
INSERT INTO hrvbib_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Poslije ću se vratiti i obnoviti Davidov srušeni šator. Podignut ću ga iz ruševina i obnoviti ");
INSERT INTO hrvbib_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","da i ostali ljudi potraže Gospodina— i pogani koje sam pozvao da budu moji. Tako govori Gospodin, ");
INSERT INTO hrvbib_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","koji je to odavna obznanio.’ ");
INSERT INTO hrvbib_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Zato smatram da ne treba dodijavati poganima koji se obrate Bogu, ");
INSERT INTO hrvbib_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","nego im reći da ne jedu meso žrtvovano idolima, meso udavljenih životinja i krv te da se suzdržavaju od bluda. ");
INSERT INTO hrvbib_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Jer ti se Mojsijevi zakoni odavna propovijedaju u židovskim sinagogama po svim gradovima svake subote.” ");
INSERT INTO hrvbib_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Zatim apostoli i starješine skupa s cijelom Crkvom odluče između sebe izabrati nekolicinu i poslati ih s Pavlom i Barnabom u sirijsku Antiohiju da izvijeste o toj odluci. Izaberu za to crkvene starješine: Judu zvanog Barsaba i Silu. ");
INSERT INTO hrvbib_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Po njima pošalju ovo pismo: Ovo je pismo od apostola i starješina, vaše braće iz Jeruzalema. Upućeno je vjernicima poganskoga podrijetla u Antiohiji, Siriji i Ciliciji. Pozdravljamo vas! ");
INSERT INTO hrvbib_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Čujemo da su vas neki ljudi zbunili i uznemirili svojim učenjem. Ali to su učinili bez našega naloga. ");
INSERT INTO hrvbib_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Odlučili smo zato jednodušno izabrati nekolicinu ljudi i poslati ih k vama skupa s ljubljenom braćom Barnabom i Pavlom, ");
INSERT INTO hrvbib_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","koji su svoje živote izložili pogibli zbog imena našega Gospodina Isusa Krista. ");
INSERT INTO hrvbib_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Šaljemo vam zato Judu i Silu da vam kažu što smo odlučili. ");
INSERT INTO hrvbib_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Sveti Duh i mi odlučili smo ne nametati vam nikakav nepotreban teret. Trebate se samo ");
INSERT INTO hrvbib_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","uzdržavati od mesa žrtvovanoga idolima, mesa udavljenih životinja i krvi te od bluda. Budete li tako činili, bit će dobro. Pozdravljamo vas. ");
INSERT INTO hrvbib_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Četvorica glasnika pozdrave se dakle s njima i odu u Antiohiju. Ondje sazovu svu Crkvu i predaju im pismo. ");
INSERT INTO hrvbib_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Kad su ga pročitali, svi se ohrabre i razvesele. ");
INSERT INTO hrvbib_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Juda i Sila, i sami proroci, mnogo su govorili braći ohrabrujući ih i utvrđujući njihovu vjeru. ");
INSERT INTO hrvbib_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Ostali su ondje neko vrijeme, a onda se s mirom vratili onima koji su ih poslali. ");
INSERT INTO hrvbib_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","A Pavao i Barnaba ostanu u Antiohiji te su s mnogim drugima navješćivali i poučavali riječ Gospodnju. ");
INSERT INTO hrvbib_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Nakon nekog vremena Pavao predloži Barnabi: “Vratimo se posjetiti braću u svim gradovima u kojima smo navješćivali Riječ Gospodnju da vidimo kako su novi obraćenici.” ");
INSERT INTO hrvbib_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnaba pristane. Htio je povesti i Ivana Marka. ");
INSERT INTO hrvbib_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Ali Pavao nije smatrao da bi bilo dobro povesti sa sobom Ivana Marka, koji ih je u Pamfiliji napustio i nije dovršio započeto djelo. ");
INSERT INTO hrvbib_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Njihovo je neslaganje bilo tako žestoko da su se razdvojili. Barnaba je s Ivanom Markom otplovio na Cipar, ");
INSERT INTO hrvbib_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","a Pavao sebi za suputnika izabrao Silu te su ih braća ispratila povjerivši ih milosti Gospodnjoj. ");
INSERT INTO hrvbib_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Proputovali su Siriju i Ciliciju utvrđujući crkve. ");
INSERT INTO hrvbib_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pavao i Sila odu najprije u Derbu, a zatim u Listru. Ondje upoznaju Timoteja, učenika kojemu je majka bila kršćanka židovskog podrijetla, a otac Grk. ");
INSERT INTO hrvbib_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Timotej je bio na dobrome glasu među braćom u Listri i Ikoniji. ");
INSERT INTO hrvbib_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pavao je htio da im se on pridruži na putovanju. Zato ga obreže radi tamošnjih Židova jer su svi znali da mu je otac Grk. ");
INSERT INTO hrvbib_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Išli su od grada do grada i poučavali ljude o odredbama koje su utvrdili apostoli i starješine u Jeruzalemu. ");
INSERT INTO hrvbib_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Tako su se crkve učvršćivale u vjeri i danomice stjecale sve više članova. ");
INSERT INTO hrvbib_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Putovali su Frigiijom I Galacijom jer im Sveti Duh nije dopustio da odu propovijedati Riječ u Maloj Aziji. ");
INSERT INTO hrvbib_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Kad su stigli do Mizije, htjeli su u Bitiniju, ali im ni to ne dopusti Isusov Duh. ");
INSERT INTO hrvbib_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Odu umjesto toga preko Mizije u Troadu. ");
INSERT INTO hrvbib_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Noću je Pavao imao viđenje. Vidio je nekoga Makedonca kako stoji i preklinje ga: “Dođi ovamo i pomozi nam!” ");
INSERT INTO hrvbib_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Zato smo odlučili smjesta otići u Makedoniju, uvjereni da nas Bog zove onamo navješćivati Radosnu vijest. ");
INSERT INTO hrvbib_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Otplovili smo iz Troade ravno na otok Samotraku. Sutradan smo pristali u Neapolu, ");
INSERT INTO hrvbib_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","a odande otišli u Filipe, velik grad u Makedoniji. Ondje smo ostali nekoliko dana. ");
INSERT INTO hrvbib_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","U subotu smo izišli iz grada i otišli do rijeke misleći da se ondje ljudi okupljaju na molitvu. Sjeli smo i počeli razgovarati s okupljenim ženama. ");
INSERT INTO hrvbib_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Jedna od njih bila je pobožna žena imenom Lidija, prodavačica grimizna platna iz grada Tijatire. Dok je slušala Pavla, Gospodin joj otvori srce te ona prihvati njegove riječi. ");
INSERT INTO hrvbib_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Krstila se i ona i svi njezini ukućani. Zatim nas zamoli: “Ako smatrate da sam vjerna Gospodinu, dođite boraviti u mojemu domu.” I primora nas na to. ");
INSERT INTO hrvbib_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Jednog dana dok smo išli na molitvu, susretne nas neka ropkinja opsjednuta vračarskim duhom. Gatala je i tako zarađivala mnogo novca svojim gospodarima. ");
INSERT INTO hrvbib_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Ona pođe za Pavlom i za nama vičući: “Ovi su ljudi sluge Svevišnjega Boga! Došli su vam navijestiti put spasenja!” ");
INSERT INTO hrvbib_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Činila je tako dan za danom. Pavlu to na koncu tako dodija da se okrene i reče duhu u njoj: “Zapovijedam ti u ime Isusa Krista: iziđi iz nje!” I duh smjesta iziđe. ");
INSERT INTO hrvbib_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Kad su njezini gospodari vidjeli da se više ne mogu nadati zaradi, pograbe Pavla i Silu te ih odvuku na trg, pred poglavare. ");
INSERT INTO hrvbib_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","“Ovi su ljudi uznemirili sav grad!” rekli su kad su ih priveli pred pretore. ");
INSERT INTO hrvbib_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","“Šire običaje koje mi Rimljani ne smijemo prihvatiti ni držati ih se.” ");
INSERT INTO hrvbib_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Na njih odmah navali svjetina, a pretori im strgnu odjeću i zapovjede da se izbatinaju. ");
INSERT INTO hrvbib_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Izudaraju ih i bace u tamnicu, a tamničaru zapovjede da ih dobro čuva. ");
INSERT INTO hrvbib_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Zato ih on baci u nutarnju tamnicu, a noge im stavi u klade. ");
INSERT INTO hrvbib_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Oko ponoći Pavao i Sila molili su se i pjevajući slavili Boga, a drugi su ih zatvorenici slušali. ");
INSERT INTO hrvbib_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Odjednom nastane snažan potres i uzdrmaju se zatvorski temelji. Vrata se pootvaraju, a okovi spadnu svim zatvorenicima! ");
INSERT INTO hrvbib_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Tamničar se prene iz sna. Kad je vidio da su tamnička vrata otvorena, trgne mač da se ubije misleći da su zatvorenici pobjegli. ");
INSERT INTO hrvbib_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Ali Pavao mu poviče: “Ne čini to! Svi smo ovdje!” ");
INSERT INTO hrvbib_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Dršćući od straha, tamničar zatraži da mu donesu svjetiljku te dotrči i baci se pred noge Pavlu i Sili. ");
INSERT INTO hrvbib_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Izvede ih van i upita: “Gospodo, što mi je činiti da se spasim?” ");
INSERT INTO hrvbib_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","“Vjeruj u Gospodina Isusa”, odgovore mu, “pa ćeš se spasiti i ti i svi tvoji ukućani.” ");
INSERT INTO hrvbib_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Navijeste zatim Riječ Gospodnju njemu i svima u njegovu domu. ");
INSERT INTO hrvbib_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Te iste ure on im opere rane te se odmah krsti, skupa sa svima svojima. ");
INSERT INTO hrvbib_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Uvede ih zatim u svoj dom i prostre im da jedu. Radovao se sa svim svojim ukućanima što je povjerovao Bogu. ");
INSERT INTO hrvbib_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Sljedećeg jutra gradski poglavari pošalju policajce da poruče tamničaru: “Pusti te ljude!” ");
INSERT INTO hrvbib_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Tamničar o tomu obavijesti Pavla: “Pretori su mi poručili da vas pustim. Idite dakle u miru!” ");
INSERT INTO hrvbib_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Ali Pavao odgovori: “Javno su nas izbatinali a da nam nisu ni sudili i bacili su u tamnicu nas, rimske građane, a sad bi nas htjeli potajno izbaciti? Nipošto! Neka sami dođu i izvedu nas!” ");
INSERT INTO hrvbib_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Kad su policajci to javili gradskim poglavarima i kad su ovi doznali da su Pavao i Sila rimski građani, preplaše se. ");
INSERT INTO hrvbib_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Zato im se dođu ispričati te ih zamole da odu iz grada. ");
INSERT INTO hrvbib_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Pavao i Sila vrate se u Lidijin dom da obiđu i ohrabre braću, pa odu iz grada. ");
INSERT INTO hrvbib_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pavao i Sila proputovali su kroz gradove Amfipol i Apoloniju te stigli u Solun, gdje je bila židovska sinagoga. ");
INSERT INTO hrvbib_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pavao po običaju uđe onamo. Tri je subote zaredom tumačio narodu Pisma. ");
INSERT INTO hrvbib_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Objašnjavao je i dokazivao navodeći proročanstva da je Mesija trebao trpjeti i uskrsnuti od mrtvih. “Taj je Mesija Isus kojega vam navješćujem”, govorio je. ");
INSERT INTO hrvbib_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Neki su povjerovali pa su se pridružili Pavlu i Sili. Obratilo se i mnogo pobožnih Grka te uglednih žena. ");
INSERT INTO hrvbib_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Židove zbog toga spopadne zavist pa nagovore neke opake uličare da pobune građane. Oni upadnu u Jasonov dom zahtijevajući da se Pavao i Sila izvedu pred narod. ");
INSERT INTO hrvbib_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Kako ih ondje nisu našli, odvuku Jasona i još neku braću pred gradske poglavare vičući: “Pavao i Sila uzbunili su sav svijet, a sada i naš grad uznemiruju! ");
INSERT INTO hrvbib_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","A Jason ih je primio u svoj dom. Krivi su za izdaju Cezara jer su odani drugome kralju: Isusu.” ");
INSERT INTO hrvbib_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Uzbune tako svjetinu i poglavare, ");
INSERT INTO hrvbib_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","koji od Jasona i ostale braće uzmu jamčevinu pa ih puste. ");
INSERT INTO hrvbib_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Te noći braća pošalju Pavla i Silu u Bereju. Kad stignu onamo, odu u židovsku sinagogu. ");
INSERT INTO hrvbib_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Ti su Židovi bili plemenitiji od solunskih. Spremno su primili Riječ i dan za danom revno proučavali Sveto pismo da provjere ima li Pavao pravo. ");
INSERT INTO hrvbib_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Zato su mnogi od njih povjerovali, kao i mnogi ugledni Grci i Grkinje. ");
INSERT INTO hrvbib_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Ali neki Židovi u Solunu doznali su da Pavao propovijeda Božju riječ u Bereji. Odu onamo i podjare svjetinu. ");
INSERT INTO hrvbib_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Braća smjesta pošalju Pavla na obalu, a Sila i Timotej ostanu ondje. ");
INSERT INTO hrvbib_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Pratitelji odvedu Pavla do Atene te se vrate u Bereju noseći Sili i Timoteju zapovijed da se požure k njemu. ");
INSERT INTO hrvbib_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Dok ih je Pavao čekao u Ateni, silno se uznemiri videći kako je grad prepun idola. ");
INSERT INTO hrvbib_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Raspravljao je u sinagogi sa Židovima i s pobožnim ljudima, a i na trgu s ljudima koji bi se svaki dan ondje zatekli. ");
INSERT INTO hrvbib_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Raspravljao je i s nekim epikurejskim i stoičkim filozofima. Kad im je kazao za Isusa i za njegovo uskrsnuće, oni rekoše: “Što ovaj brblja?” “Čini se da navješćuje neke tuđe bogove”, odgovore drugi. ");
INSERT INTO hrvbib_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Odvedu ga zatim na Areopag i upitaju: “Kakvo to novo učenje poučavaš? ");
INSERT INTO hrvbib_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Govoriš čudne stvari. Željeli bismo čuti više o tomu.” ");
INSERT INTO hrvbib_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Jer ondje ni Atenjani ni tuđinci po cijele dane kao da nisu radili ništa drugo do raspravljali o novostima. ");
INSERT INTO hrvbib_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Pavao zato stane posred Areopaga i reče: “Atenjani! Vidim da ste vrlo pobožni. ");
INSERT INTO hrvbib_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Prolazeći gradom, promatrao sam vaše brojne žrtvenike. Na jednome od njih pisalo je: Nepoznatome Bogu. Želim vam dakle navijestiti tog Boga kojega štujete, ali ga ne poznajete. ");
INSERT INTO hrvbib_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","On je stvorio svijet i sve što je na njemu. Gospodar je neba i zemlje i ne prebiva u hramovima koje je načinila ljudska ruka. ");
INSERT INTO hrvbib_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Ne poslužuju ga ljudske ruke. On je taj koji svima daje život, dah i sve što je potrebno. ");
INSERT INTO hrvbib_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Od jednoga je čovjeka stvorio cijeli ljudski rod da živi na cijeloj zemlji. Odredio je vrijeme i granice njihova prebivanja. ");
INSERT INTO hrvbib_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","On želi da svi traže Boga ne bi li ga nekako napipali i našli. Nije daleko ni od koga od nas. ");
INSERT INTO hrvbib_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Jer u njemu živimo, krećemo se i jesmo. Kao što je rekao i jedan od vaših pjesnika: ‘Njegova smo djeca.’ ");
INSERT INTO hrvbib_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Ako je dakle tako, Boga ne smijemo smatrati idolom, likom od zlata, srebra ili kamena, isklesanim ljudskom vještinom i maštom. ");
INSERT INTO hrvbib_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Bog se ne obazire na neznanje u kojemu su ljudi živjeli, nego sada svakomu nudi da se obrati od idola k njemu. ");
INSERT INTO hrvbib_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Jer odredio je dan kad će pravedno suditi svijetu po Čovjeku kojega je za to odredio i pred svima ga potvrdio uskrisivši ga od mrtvih.” ");
INSERT INTO hrvbib_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Kad su čuli kako spominje uskrsnuće od mrtvih, neki se počnu smijati, a drugi rekoše: “Još ćemo te o tome slušati!” ");
INSERT INTO hrvbib_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Tako Pavao prestane s njima raspravljati. ");
INSERT INTO hrvbib_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Neki su mu se ipak pridružili i povjerovali. Među njima su bili Dionizije Areopagit te neka žena Damara, i drugi. ");
INSERT INTO hrvbib_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Pavao zatim iz Atene ode u Korint. ");
INSERT INTO hrvbib_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Ondje upozna nekoga Židova Akvilu, rodom iz Ponta, koji je sa svojom ženom Priscilom tek došao iz Italije jer je Klaudije zapovjedio da svi Židovi napuste Rim. ");
INSERT INTO hrvbib_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Kako su izrađivali šatore kao i on, Pavao je s njima stanovao i radio. ");
INSERT INTO hrvbib_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Svake je subote u sinagogi raspravljao uvjeravajući Židove i Grke. ");
INSERT INTO hrvbib_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Kad su se iz Makedonije vratili Sila i Timotej, Pavao se potpuno posveti propovijedanju i svjedočenju Židovima da je Isus Mesija. ");
INSERT INTO hrvbib_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Ali kad su mu se oni počeli suprotstavljati i vrijeđati ga, Pavao otrese prašinu sa svoje odjeće te im reče: “Vaša će krv pasti na vaše glave. Ja sam nedužan. Od sada idem poganima.” ");
INSERT INTO hrvbib_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Ode odande u kuću pobožnog čovjeka Ticija Justa, čija je kuća bila odmah do sinagoge. ");
INSERT INTO hrvbib_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Nadstojnik sinagoge Krisp i svi njegovi ukućani povjeruju u Gospodina. I još mnogi Korinćani koji su to čuli povjeruju i krste se. ");
INSERT INTO hrvbib_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Jedne noći Gospodin progovori Pavlu i viđenju: “Ne boj se! Govori i ne daj se ušutkati! ");
INSERT INTO hrvbib_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Ja sam s tobom i nitko se neće usuditi da ti učini što nažao. Jer u ovomu je gradu mnogo mojega naroda.” ");
INSERT INTO hrvbib_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Tako je ondje ostao godinu i šest mjeseci poučavajući Božju riječ. ");
INSERT INTO hrvbib_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Dok je Galion bio prokonzul Ahaje, Židovi složno navale na Pavla te ga dovuku u sudnicu. ");
INSERT INTO hrvbib_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Optuže ga: “Potiče ljude da štuju Boga protuzakonito.” ");
INSERT INTO hrvbib_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pavao zausti da nešto kaže, ali Galion uto reče: “Židovi, da je riječ o kakvu zločinu ili nedjelu, saslušao bih vas. ");
INSERT INTO hrvbib_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Ali kako je nesporazum o nekim vašim riječima, imenima i židovskome Zakonu, uredite to sami. Ja u tomu ne želim biti sucem.” ");
INSERT INTO hrvbib_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","I otpremi ih iz sudnice. ");
INSERT INTO hrvbib_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Svjetina pograbi nadstojnika sinagoge Sostena te ga izbatinaju ondje, u sudnici. Ali Galion nije mario. ");
INSERT INTO hrvbib_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pavao ostane u Korintu još neko vrijeme, a onda se oprosti s braćom. U Kenhreji se prema židovskomu običaju ošiša jer je imao zavjet. Zatim s Priscilom i Akvilom isplovi prema Siriji. ");
INSERT INTO hrvbib_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Stignu u Efez. Ondje ih ostavi, a on uđe u sinagogu raspravljati sa Židovima. ");
INSERT INTO hrvbib_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Oni ga zamole da dulje ostane, ali on to odbije. ");
INSERT INTO hrvbib_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Pozdravi se s njima i obeća: “Vratit ću se k vama, bude li Božja volja.” I otplovi iz Efeza. ");
INSERT INTO hrvbib_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Ode zatim pozdraviti crkvu u Cezareji, a zatim u Antiohiju. ");
INSERT INTO hrvbib_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Pošto je proveo nešto vremena u Antiohiji ode na put po Galaciji i Frigiji obilazeći vjernike i pomažući im da jačaju u vjeri. ");
INSERT INTO hrvbib_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Tada neki Židov Apolon, rječit govornik i dobar poznavatelj Svetoga pisma, dođe iz Aleksandrije u Egipat. ");
INSERT INTO hrvbib_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Bio je upućen u Put Gospodnji pa je gorljivo i točno poučavao o Isusu. Znao je, međutim, samo za Ivanovo krštenje. ");
INSERT INTO hrvbib_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Počne on tako jednom hrabro govoriti u sinagogi. To čuju Priscila i Akvila pa ga pozovu k sebi i podrobnije mu izlože Put Božji. ");
INSERT INTO hrvbib_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Kad je nakanio otići u Ahaju, braća ga ohrabre i napišu vjernicima u Efezu da ga lijepo prime. U Ahaji je po Božjoj milosti mnogo koristio vjernicima. ");
INSERT INTO hrvbib_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Uvjerljivo je pobijao tvrdnje Židova javno dokazujući iz Svetoga pisma da je Isus Mesija. ");
INSERT INTO hrvbib_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Dok je Apolon bio u Korintu, Pavao proputuje gornje krajeve i dođe u Efez. Ondje nađe nekoliko vjernika. ");
INSERT INTO hrvbib_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Jeste li primili Svetoga Duha kad ste povjerovali? upita ih. “Nismo”, odgovore. “Nismo čuli ni da Sveti Duh postoji.” ");
INSERT INTO hrvbib_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","“Kako ste se onda krstili?” upita on. “Ivanovim krštenjem”, odgovore. ");
INSERT INTO hrvbib_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pavao im reče: “Ivanovo je krštenje bilo u znak obraćenja, volje da se čovjek odvrati od grijeha i da se obrati Bogu. Sam je Ivan govorio narodu da vjeruju u onoga koji za njim dolazi, u Isusa.” ");
INSERT INTO hrvbib_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Kad su to čuli, krste se u ime Gospodina Isusa. ");
INSERT INTO hrvbib_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Pavao položi na njih ruke pa na njih siđe Sveti Duh te počnu govoriti drugim jezicima i prorokovati. ");
INSERT INTO hrvbib_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Bilo ih je svega dvanaestak. ");
INSERT INTO hrvbib_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Pavao zatim ode u sinagogu i tri je mjeseca hrabro i uvjerljivo raspravljao o Božjemu kraljevstvu. ");
INSERT INTO hrvbib_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Ali neki okorjeli i nepokorni ljudi klevetali su Put pred mnoštvom. Pavao zato ode iz sinagoge i povede vjernike sa sobom. Počne zatim poučavati u školi nekoga Tirana. ");
INSERT INTO hrvbib_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","To je trajalo dvije godine, dok svi azijski žitelji, i Židovi i Grci, nisu čuli Božju riječ. ");
INSERT INTO hrvbib_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Bog je Pavlu dao moć da čini neobična čudesa. ");
INSERT INTO hrvbib_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Ljudi su na bolesnike stavljali rupce ili rublje koje se doticalo Pavlove kože, a njihovi su bolesti nestajale i zlodusi su izlazili iz njih. ");
INSERT INTO hrvbib_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Zato su neki Židovi koji su putovali od mjesta do mjesta istjerujući zloduhe pokušali zazvati ime Gospodina Isusa. Govorili su: “Izlazite! Zaklinjem vas Isusom kojega Pavao propovijeda!” ");
INSERT INTO hrvbib_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Činila su to sedmorica sinova židovskoga velikog svećenika Skeve. ");
INSERT INTO hrvbib_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Ali zloduh im odgovori: “Isusa i Pavla poznajem, ali tko ste vi?” ");
INSERT INTO hrvbib_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","I čovjek kojega je opsjedao nasrne na njih te ih tako silovito nadjača da su goli i izranjeni pobjegli doma. ");
INSERT INTO hrvbib_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Za to su doznali svi žitelji Efeza, i Židovi i Grci. Obuzme ih strah te počnu veličati ime Gospodina Isusa. ");
INSERT INTO hrvbib_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Mnogi koji su postali vjernicima ispovijedali su svoja zla djela. ");
INSERT INTO hrvbib_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Bilo ih je mnogo koji su se bavili čarobnjaštvom. Oni donesu knjige koje su uporabljali za to i pred svima ih spale. Procijenjeno je da je spaljeno knjiga u vrijednosti pedeset tisuća srebrnjaka. ");
INSERT INTO hrvbib_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Tako se Gospodnja riječ širila i jačala. ");
INSERT INTO hrvbib_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Zatim Pavao nakani vratiti se u Jeruzalem preko Makedonije i Ahaje. “Nakon toga će valjati da odem i u Rim”, reče on. ");
INSERT INTO hrvbib_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Pošalje u Makedoniju dvojicu svojih poslužitelja, Timoteja i Erasta, a on se još neko vrijeme zadrži u Maloj Aziji. ");
INSERT INTO hrvbib_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Ali u to vrijeme u Efezu nastane velika pobuna protiv Puta. ");
INSERT INTO hrvbib_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Potaknuo ju je neki srebrnar Demetrije koji je mnogo zarađivao izrađujući Artemidine hramiće od srebra. Mnogi su obrtnici na tomu zarađivali. ");
INSERT INTO hrvbib_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","On okupi sve obrtnike koji su se time bavili i reče im: “Ljudi, znate da naše blagostanje ovisi o ovomu poslu. ");
INSERT INTO hrvbib_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","A vidite i čujete da je taj Pavao, ne samo u Efezu nego i u svoj Maloj Aziji, pobunio veliko mnoštvo tvrdeći da bogovi načinjeni rukama nisu bogovi. ");
INSERT INTO hrvbib_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Ne govorim, dakako, samo o tomu da će naš posao doći na zao glas. Brinem se i da će obezvrijediti hram naše velike božice Artemide te da će nestati veličanstva te velike božice koju štuje cijela Mala Azija i sav svijet!” ");
INSERT INTO hrvbib_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Oni se na to razgnjeve i poviču: “Velika je efeška Artemida!” ");
INSERT INTO hrvbib_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Sav se grad uzbuni. Složno jurnu prema kazalištu vukući za sobom Pavlove suputnike, Makedonce Gaja i Aristarha. ");
INSERT INTO hrvbib_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pavao htjede ući među narod, ali mu vjernici ne dopuste. ");
INSERT INTO hrvbib_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Neki njegovi prijatelji, dužnosnici u tom kraju, pošalju mu poruku moleći ga da se ne izlaže pogibelji ulazeći u kazalište. ");
INSERT INTO hrvbib_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Unutra su svi vikali: jedni jedno, drugi drugo. Vladala je opća zbrka pa mnogi nisu ni znali zašto su ondje. ");
INSERT INTO hrvbib_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Svjetina izgura naprijed nekog Aleksandra jer su ga Židovi onamo gurali. On podigne ruku i pokuša se obratiti narodu. ");
INSERT INTO hrvbib_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Ali kad su shvatili da je Židov, opet jednoglasno udare vikati dvije ure: “Velika je efeška Artemida! Velika je efeška Artemida!” ");
INSERT INTO hrvbib_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Na koncu gradski poglavar umiri svjetinu i reče: “Efežani! Svatko zna da je grad Efez čuvar hrama velike Artemide, koje nam je kip pao s neba. ");
INSERT INTO hrvbib_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","To je neporecivo. Umirite se stoga. Ne činite ništa nepromišljeno! ");
INSERT INTO hrvbib_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Doveli ste ovamo te ljude, a niti su ukrali što iz hrama niti su hulili našu božicu. ");
INSERT INTO hrvbib_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Imaju li pak Demetrije i obrtnici protiv njih kakvu tužbu, sudovi zasjedaju, a tu su i suci. Neka podnesu tužbu! ");
INSERT INTO hrvbib_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ima li još kakvih pritužbi, neka se riješe zakonitim putem. ");
INSERT INTO hrvbib_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Bojim se da će nas ovako rimska vlada optužiti za pobunu jer za sav ovaj metež nema nikakva opravdanog razloga.” ");
INSERT INTO hrvbib_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Zatim raspusti skup. ");
INSERT INTO hrvbib_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Kad je sva strka prošla, Pavao pošalje po vjernike. Ohrabri ih, pozdravi se s njima i otputuje u Makedoniju. ");
INSERT INTO hrvbib_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Putem je hrabrio braću u mjestima kuda je prolazio. Stigne tako u Grčku ");
INSERT INTO hrvbib_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","i ostane ondje tri mjeseca. Baš kad se spremao otploviti natrag u Siriju, dozna da su mu Židovi postavili zasjedu pa se odluči vratiti preko Makedonije. ");
INSERT INTO hrvbib_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Pratili su ga Pirov sin Sopater iz Bereje, Solunjani Aristarh i Sekund, Gaj iz Derbe, Timotej i Azijci Tihik i Trofim. ");
INSERT INTO hrvbib_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Otišli su prije nas i sačekali nas u Troadi. ");
INSERT INTO hrvbib_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","A mi smo poslije Blagdana beskvasnih kruhova krenuli brodom iz Filipa i za pet dana stigli k njima u Troadu, gdje smo ostali sedam dana. ");
INSERT INTO hrvbib_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Prvoga dana u tjednu sastali smo se da lomimo kruh. Pavao je propovijedao. Kako je sutradan kanio otputovati, govorio je sve do ponoći. ");
INSERT INTO hrvbib_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","U sobi na katu gdje smo se okupili bilo je mnogo svjetiljki. ");
INSERT INTO hrvbib_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Na prozoru je sjedio mladić Eutih. Kako je Pavao dugo govorio, on duboko zaspi i svladan snom padne s trećega kata na zemlju. Kad su ga podignuli, bio je mrtav. ");
INSERT INTO hrvbib_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Pavao siđe, legne na dječaka i zagrli ga. “Ne uznemirujte se!” reče. “Živ je!” ");
INSERT INTO hrvbib_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Popne se zatim na kat, razlomi kruh i blaguje s njima. Zatim je govorio još dugo, sve do svanuća. Onda otputuje. ");
INSERT INTO hrvbib_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","A mladića su odveli živa, neizmjerno utješeni. ");
INSERT INTO hrvbib_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Mi smo prije Pavla krenuli lađom u As. On je tamo trebao doći pješice, a dalje smo ga trebali povesti. ");
INSERT INTO hrvbib_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Kad nam se u Asu pridružio, skupa smo otplovili u Mitilenu. ");
INSERT INTO hrvbib_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Onande smo sutradan projedrili nadomak Hija, dan poslije krenuli u Sam te sutradan stigli u Milet. ");
INSERT INTO hrvbib_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Pavao je, naime, odlučio izbjegnuti Efez da se ne zadrži u Maloj Aziji. Žurio se da, ako bude mogao, stigne u Jeruzalem do Pedesetnice. ");
INSERT INTO hrvbib_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Ali iz Mileta pošalje u Efez po crkvene starješine. ");
INSERT INTO hrvbib_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Kad su došli, reče im: “Znate kako sam postupao od prvog dana kad sam nogom kročio u Malu Aziju. ");
INSERT INTO hrvbib_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Služio sam Gospodinu ponizno, u suzama i kušnjama koje su me snašle zbog židovskih urota. ");
INSERT INTO hrvbib_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Ipak se nikada nisam sustezao propovijedati, u javnosti ili po kućama, sve što bi vam moglo biti korisno. ");
INSERT INTO hrvbib_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Upozoravao sam i Židove i pogane da se odvrate od grijeha i obrate Bogu te da povjeruju u našega Gospodina Isusa. ");
INSERT INTO hrvbib_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Sada idem u Jeruzalem, neodoljivo vođen Svetim Duhom, ne znajući što me čeka, ");
INSERT INTO hrvbib_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","osim što mi Sveti Duh u svakome gradu potvrđuje da me čekaju tamnica i nevolje. ");
INSERT INTO hrvbib_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Ali nije mi stalo hoću li živjeti ili ne, već hoću li dovršiti svoju trku, djelo koje sam primio od Gospodina Isusa: svjedočiti o Radosnoj vijesti i Božjoj milosti. ");
INSERT INTO hrvbib_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Sada znam da me vi, kojima sam propovijedao o Kraljevstvu, nećete više vidjeti. ");
INSERT INTO hrvbib_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Zato vam danas jasno kažem: čist sam od krvi svih vas. Nisam kriv propadne li tko od vas ");
INSERT INTO hrvbib_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","jer se nisam sustezao navijestiti vam u potpunosti Božju nakanu. ");
INSERT INTO hrvbib_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Pazite na sebe i na Božje stado—na njegovu Crkvu otkupljenu njegovom krvlju, u kojoj vas je Sveti Duh postavio za starješine. ");
INSERT INTO hrvbib_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Znam da će se, kad odem, među vas uvući okrutni vuci koji ne štede stada. ");
INSERT INTO hrvbib_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Čak će i neki od nas neki iskrivljavati učenje ne bi li odvukli učenike za sobom. ");
INSERT INTO hrvbib_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Zato bdijte! Ne zaboravite da sam tri godine bio s vama i danonoćno vas bez prestanka opominjao lijući suze. ");
INSERT INTO hrvbib_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","A sada vas povjeravam Bogu i Riječi njegove milosti, koja vas može izgraditi i dati vam baštinu kao i svima posvećenima. ");
INSERT INTO hrvbib_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Nikada nisam želio tuđe srebro, zlato ili odjeću. ");
INSERT INTO hrvbib_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Znate da sam vlastitim rukama radio za svoje potrebe i potrebe svojih pratitelja. ");
INSERT INTO hrvbib_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","U svemu sam vam bio primjerom kako se treba truditi, pomagati nevoljnima i pamtiti riječi Gospodina Isusa: ‘Blaženije je davati nego primati.’” ");
INSERT INTO hrvbib_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Kad je to rekao, klekne i pomoli se s njima. ");
INSERT INTO hrvbib_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Glasno su plakali, grlili Pavla i cjelivali ga ");
INSERT INTO hrvbib_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","ražalošćeni posebice što je rekao da ga nikada više neće vidjeti. Zatim ga isprate na lađu. ");
INSERT INTO hrvbib_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Pošto smo se od njih oprostili, otplovili smo jedrenjakom do otoka Kosa, a sutradan do Roa, pa u Pataru. ");
INSERT INTO hrvbib_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Ondje smo se ukrcali na lađu za sirijsku pokrajinu Feniciju. ");
INSERT INTO hrvbib_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Kad smo ugledali Cipar, prošli smo pokraj njega s desne strane jedreći prema Siriji. Pristali smo u Tiru da lađa iskrca teret. ");
INSERT INTO hrvbib_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Sišli smo na kopno te ondje našli vjernike. Kako im je Sveti Duh otkrio da će Pavao u Jeruzalemu imati nevolja, rekli su mu da ne ide onamo. ");
INSERT INTO hrvbib_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Ali kad je prošlo tjedan dana, ipak smo otputovali. Oni su nas svi ispratili do izvan grada, skupa sa ženama i djecom. Na obali smo kleknuli i pomolili se. ");
INSERT INTO hrvbib_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Pozdravili smo se i ukrcali na lađu, a oni su se vratili doma. ");
INSERT INTO hrvbib_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Otplovili smo tako iz Tira u Ptolemaidu. Pozdravili smo ondje braću i ostali s njima jedan dan. ");
INSERT INTO hrvbib_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Zatim smo otišli u Cezareju i boravili u domu Filipa evanđelista, jednoga od sedmorice koji su dijelili hranu. ");
INSERT INTO hrvbib_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","On je imao četiri neudane kćeri koje su imale dar prorokovanja. ");
INSERT INTO hrvbib_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Kad smo ondje bili već nekoliko dana, dođe neki Agab koji je također imao dar prorokovanja, ");
INSERT INTO hrvbib_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","uzme Pavlov pojas te njime sebi zaveže noge i ruke. “Ovo govori Sveti Duh”, reče. “Vlasnika ovog pojasa ovako će svezati židovski vođe u Jeruzalemu i predati ga Rimljanima.” ");
INSERT INTO hrvbib_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Kad smo to čuli, i mi koji smo s njime putovali i mještani počnemo preklinjati Pavla da ne ide u Jeruzalem. ");
INSERT INTO hrvbib_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Ali on reče: “Što plačete? Slamate mi srce! Spreman sam ne samo da me svežu nego i umrijeti za Gospodina Isusa.” ");
INSERT INTO hrvbib_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Kad je bilo jasno da se ne daje nagovoriti, odustali smo i rekli: “Neka bude volja Gospodnja!” ");
INSERT INTO hrvbib_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Ubrzo nakon toga spremili smo se i otišli u Jeruzalem. ");
INSERT INTO hrvbib_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Neki vjernici iz Cezareje koji su pošli s nama odvedu nas nekome Mnasonu s Cipra, jednomu od prvih učenika, da ondje odsjednemo. ");
INSERT INTO hrvbib_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Svi su nas vjernici u Jeruzalemu srdačno dočekali. ");
INSERT INTO hrvbib_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Sutradan Pavao pođe s nama k Jakovu. Ondje su bili i svi starješine jeruzalemske Crkve. ");
INSERT INTO hrvbib_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","On ih pozdravi te im podrobno izloži što je Bog učinio među poganima kroz njegovu službu. ");
INSERT INTO hrvbib_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Kad su to čuli, dadu slavu Bogu. Zatim mu rekoše: “Dragi brate, deseci tisuća Židova također su povjerovali. Oni se revno drže Mojsijeva zakona, ");
INSERT INTO hrvbib_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","a za tebe su im rekli da Židove koje žive među poganima učiš da ne poštuju Mojsijev zakon. Kažu da ih poučavaš da ne obrezuju djecu i da se ne drže židovskih običaja. ");
INSERT INTO hrvbib_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Što da učinimo? Sigurno će čuti da si došao. ");
INSERT INTO hrvbib_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Učini zato kako ti kažemo. Među nama su četvorica koji su se zavjetovali i sad se spremaju obrijati glavu. ");
INSERT INTO hrvbib_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Idi s njima u Hram i pridruži im se u obredu posvećenja te plati da im obriju glave. Tako će svi znati da su te glasine lažne, da si na pravome putu i da poštuješ židovski Zakon. ");
INSERT INTO hrvbib_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","A glede pogana koji su povjerovali, od njih tražimo što smo im napisali u pismu: da ne jedu meso žrtvovano idolima, krv ni meso udavljenih životinja te da se klone bluda.” ");
INSERT INTO hrvbib_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Pavao dakle pristane na njihov zahtjev te sljedećeg dana obavi s njima obred očišćenja te ode u Hram. Ondje oglasi da je njihov zavjet istekao i da će za svakoga od njih prinijeti žrtvu. ");
INSERT INTO hrvbib_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Upravo se navršavalo sedam dana kad neki Židovi iz Male Azije opaze Pavla u Hramu i podjare narod protiv njega. Ščepaju ga ");
INSERT INTO hrvbib_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","vičući: “Izraelci! U pomoć! Evo čovjeka koji poučava protiv naroda, protiv našega Zakona i protiv Hrama! Čak ga je oskvrnuo dovodeći Grke u njega!” ");
INSERT INTO hrvbib_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Prije su, naime, u gradu s njime vidjeli Trofima iz Efeza pa su mislili da je Pavao njega doveo u Hram. ");
INSERT INTO hrvbib_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Sav se grad uzbuni te nastane metež. Ščepaju Pavla i odvuku ga iz Hrama te odmah zatvore za njim vrata. ");
INSERT INTO hrvbib_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Dok su ga nastojali ubiti, zapovjedniku rimske čete dojave da je u Jeruzalemu pobuna. ");
INSERT INTO hrvbib_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","On odmah s vojnicima i stotnicima potrči prema pobunjenicima. Kad je svjetina vidjela zapovjednika s vojnicima, prestanu udarati Pavla. ");
INSERT INTO hrvbib_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Zapovjednik priđe, uhiti ga i zapovjedi da ga okuju dvostrukim lancima. Onda počne ispitivati tko je on i što je učinio. ");
INSERT INTO hrvbib_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Iz svjetine su jedni vikali jedno, a drugi drugo. Zbog graje nije mogao pouzdano saznati razlog pa zato Pavla povede u vojarnu. ");
INSERT INTO hrvbib_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Kad su došli do stuba, svjetina se tako razjarila da su ga vojnici morali nositi kako bi ga zaštitili. ");
INSERT INTO hrvbib_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Mnoštvo je išlo za njima i vikalo: “Smakni ga!” ");
INSERT INTO hrvbib_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Na ulazu u vojarnu Pavao reče zapovjedniku: “Smijem li što reći?” “Zar ti znaš grčki?” upita ga ovaj iznenađeno. ");
INSERT INTO hrvbib_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","“Ti dakle nisi onaj Egipćanin koji je nedavno digao pobunu i poveo u pustinju četiri tisuće prevratnika?” ");
INSERT INTO hrvbib_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","“Nisam”, odgovori Pavao. “Ja sam Židov iz Tarza, znamenitoga grada u Ciliciji. Molim te, dopusti mi da se obratim narodu.” ");
INSERT INTO hrvbib_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Zapovjednik mu dopusti. Pavao stane na stube i mahne rukom narodu. Nastane velika tišina. Prozbori im na hebrejskome. ");
INSERT INTO hrvbib_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Braćo i oci,” reče Pavao, “poslušajte što ću reći u svoju obranu.” ");
INSERT INTO hrvbib_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Kad su čuli da govori na njihovu vlastitome, hebrejskom jeziku, još su više utihnuli. ");
INSERT INTO hrvbib_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Židov sam, rođen u Tarzu u Ciliciji, ali odrastao ovdje u Jeruzalemu uz Gamaliela. Do njegovih sam nogu odgajan da u svemu poštujem Zakon naših otaca. Gorljivo sam se trudio za Boga, kao i vi danas. ");
INSERT INTO hrvbib_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Progonio sam nasmrt sljedbenike Puta, okivao ih te i muškarce i žene bacao u tamnicu. ");
INSERT INTO hrvbib_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","O tomu mogu posvjedočiti i veliki svećenik i sve starješine. Od njih sam za židovsku braću u Damasku dobio pisma s ovlaštenjem da i kršćane koji su ondje dovedem okovane u Jeruzalem da se kazne. ");
INSERT INTO hrvbib_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Dok sam putovao cestom prema Damasku, oko podneva me s neba odjednom obasjala jaka svjetlost. ");
INSERT INTO hrvbib_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Srušio sam se na tlo. Čuo sam glas koji mi je rekao: ‘Savle, Savle! Zašto me progoniš?’ ");
INSERT INTO hrvbib_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","‘Tko si ti, Gospodine?’ upitao sam. ‘Ja sam Isus Nazarećanin kojega ti progoniš’, odgovori mi Gospodin. ");
INSERT INTO hrvbib_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Ljudi koji su bili sa mnom vidjeli su svjetlost, ali nisu čuli glas. ");
INSERT INTO hrvbib_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Rekao sam: ‘Što mi je činiti, Gospodine?’ A Gospodin mi odgovori: ‘Pođi u Damask. Ondje će ti se reći što da činiš.’ ");
INSERT INTO hrvbib_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Od jake sam svjetlosti oslijepio pa su me moji pratitelji morali za ruku odvesti u Damask. ");
INSERT INTO hrvbib_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Ondje mi je došao neki Ananija, pobožan čovjek koji je poštivao Zakon i bio na dobru glasu među Židovima u Damasku. ");
INSERT INTO hrvbib_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","On mi priđe i reče: ‘Brate Savle, progledaj!’ I istog časa sam ga mogao vidjeti. ");
INSERT INTO hrvbib_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Reče mi zatim: ‘Bog naših predaka odabrao te je da spoznaš njegovu volju, da vidiš Pravednika i da mu čuješ glas. ");
INSERT INTO hrvbib_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Pred svima ćeš o njemu svjedočiti o tomu što si vidio i čuo. ");
INSERT INTO hrvbib_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Što čekaš? Ustani, krsti se i operi se od grijeha prizivajući njegovo ime.’ ");
INSERT INTO hrvbib_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Po povratku u Jeruzalem jednog sam se dana molio u Hramu i pao u zanos. ");
INSERT INTO hrvbib_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Vidio sam Isusa kako mi govori: ‘Brzo otiđi iz Jeruzalema jer ti ljudi ovdje neće vjerovati kad im budeš svjedočio o meni!’ ");
INSERT INTO hrvbib_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","‘Ali, Gospodine,’ rekao sam, ‘pa znaju da sam one koji u tebe vjeruju bacao u tamnice i bičevao po sinagogama. ");
INSERT INTO hrvbib_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","A kad su ubili Stjepana, stajao sam ondje odobravajući. Čuvao sam ogrtače onima koji su ga kamenovali.’ ");
INSERT INTO hrvbib_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Ali Gospodin mi reče: ‘Idi iz Jeruzalema jer te šaljem daleko, k poganima!’” ");
INSERT INTO hrvbib_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Mnoštvo je slušalo sve dok Pavao nije izgovorio tu riječ. Nato složno poviču: “Zbrišite ga s lica zemlje! Nije pravo da takav živi!” ");
INSERT INTO hrvbib_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Vikali su, bacali sa sebe ogrtače i vitlali prašinu u zrak. ");
INSERT INTO hrvbib_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Zapovjednik zato uvede Pavla u vojarnu i zapovjedi da ga izbičuju kako bi priznao zločin. Htio je znati zašto mnoštvo tako viče na njega. ");
INSERT INTO hrvbib_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Kad su ga zavezali remenjem da ga bičuju, Pavao upita stotnika koji je bio ondje: “Zar smijete bičevati rimskoga građanina, a ni sudili mu niste?” ");
INSERT INTO hrvbib_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Stotnik nato ode zapovjedniku i reče: “Što radiš? Taj je čovjek rimski građanin!” ");
INSERT INTO hrvbib_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Zapovjednik ode k Pavlu i upita: “Jesi li ti Rimljanin?” “Jesam”, odgovori Pavao. ");
INSERT INTO hrvbib_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","“I ja sam”, reče zapovjednik. “Mnogo sam novca dao da steknem taj naziv!” “A ja sam se s njim rodio”, odgovori mu Pavao. ");
INSERT INTO hrvbib_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Svi vojnici koji su ga trebali ispitivati odmah odstupe od njega. Zapovjednik se prestrašio doznavši da je Pavao Rimljanin jer ga je on okovao. ");
INSERT INTO hrvbib_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Sutradan zapovjednik skine Pavlu okove te zapovjedi da se sastanu veliki svećenici i Vijeće. Htio je doznati za što ga Židovi optužuju. Zato ga izvede pred njih. ");
INSERT INTO hrvbib_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pavao se zagleda u vijećnike i reče: “Braćo, sve do danas sam pred Bogom živio posve mirne savjesti.” ");
INSERT INTO hrvbib_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Nato veliki svećenik Ananija zapovjedi onima do Pavla da ga udare po ustima. ");
INSERT INTO hrvbib_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","“Udarit će tebe Bog, zidu obijeljeni! Sjediš tu da me sudiš po Zakonu, a sam ga kršiš i zapovijedaš da me tuku!” ");
INSERT INTO hrvbib_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Nazočni rekoše Pavlu: “Zar tako grdiš Božjega velikog svećenika?” ");
INSERT INTO hrvbib_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","“Nisam znao, braćo, da je veliki svećenik”, odvrati Pavao. “Jer u Svetome pismu piše: ‘Ne psuj poglavara svojega naroda.’” ");
INSERT INTO hrvbib_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Pavao je znao da su neki članovi Velikoga vijeća saduceji, a neki farizeji, pa poviče: “Braćo, ja sam farizej i preci su mi farizeji! Sudi mi se zbog nade u uskrsnuće mrtvih!” ");
INSERT INTO hrvbib_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Nato izbije svađa među farizejima i saducejima i mnoštvo se podijeli. ");
INSERT INTO hrvbib_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Saduceji, naime, kažu da nema ni uskrsnuća, ni anđela, ni duhova, a farizeji u sve to vjeruju. ");
INSERT INTO hrvbib_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Nastane silna graja. Neki pismoznanci iz farizejske sljedbe ustanu u Pavlovu obranu žestoko prosvjedujući: “Ne nalazimo da je taj čovjek počinio ikakvo zlo! A što ako mu je govorio duh ili anđeo?” ");
INSERT INTO hrvbib_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Nastane tako velika svađa da se zapovjednik prestrašio da Pavla ne rastrgaju. Zapovjedi zato da vojnici siđu po njega. Oni ga otrgnu iz svjetine i odvedu natrag u vojarnu. ");
INSERT INTO hrvbib_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Te noći Gospodin pristupi Pavlu i reče mu: “Samo hrabro, Pavle! Kao što si za mene posvjedočio ovdje u Jeruzalemu, tako trebaš svjedočiti i u Rimu.” ");
INSERT INTO hrvbib_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Kad se razdanilo, Židovi skuju urotu i zakunu se da neće ni jesti ni piti dok ne ubiju Pavla. ");
INSERT INTO hrvbib_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Bilo ih je više od četrdesetorice. ");
INSERT INTO hrvbib_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Odu zatim kazati velikim svećenicima i starješinama: “Zakleli smo se da nećemo jesti ni piti dok ne ubijemo Pavla. ");
INSERT INTO hrvbib_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Zato vi sada skupa s Vijećem zamolite zapovjednika da ga opet dovedu u Vijeće. Recite da želite pobliže razmotriti njegov slučaj. A mi ćemo ga pogubiti na putu ovamo.” ");
INSERT INTO hrvbib_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Ali Pavlov nećak, sin njegove sestre, dočuje za tu zavjeru pa ode u vojarnu dojaviti Pavlu. ");
INSERT INTO hrvbib_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Pavao pozove nekog stotnika i reče mu: “Odvedi ovoga mladića k zapovjedniku. Ima mu nešto važno reći.” ");
INSERT INTO hrvbib_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Stotnik ga odvede i reče zapovjedniku: “Zatvorenik Pavao pozvao me i zamolio da ovoga mladića dovedem k tebi jer ti ima nešto reći.” ");
INSERT INTO hrvbib_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Zapovjednik ga uhvati za ruku i povede u stranu te ga upita: “Što mi želiš reći?” ");
INSERT INTO hrvbib_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","“Neki su se Židovi dogovorili da te sutra zamole da dovedeš Pavla u Vijeće pretvarajući se da žele pomnjivije ispitati njegov slučaj. ");
INSERT INTO hrvbib_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Ne čini to! Čekat će ga u zasjedi više od četrdesetero ljudi koji su se zakleli da neće ni jesti ni piti dok ga ne ubiju. Već su spremni i samo čekaju tvoj pristanak.” ");
INSERT INTO hrvbib_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Zapovjednik otpusti mladića i zapovjedi mu: “Nikomu ne reci da si mi to javio.” ");
INSERT INTO hrvbib_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Dozove zatim dva stotnika i reče im: “Priredite dvjesto vojnika, sedamdeset konjanika i dvjesto strijelaca da večeras po devetoj uri pođu u Cezareju. ");
INSERT INTO hrvbib_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Pripravite Pavlu konje za jahanje te ga živa i zdrava odvedite upravitelju Feliksu.” ");
INSERT INTO hrvbib_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Napiše zatim pismo upravitelju: ");
INSERT INTO hrvbib_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Od Klaudija Lizijavrlome upravitelju Feliksu. Pozdravljam vas! ");
INSERT INTO hrvbib_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Ovoga su čovjeka uhvatili Židovi i umalo ga ubili, kad sam pritrčao s vojnicima. Doznavši da je rimski građanin, sklonio sam ga od njih na sigurno. ");
INSERT INTO hrvbib_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Odveo sam ga zatim pred njihovo Vijeće da doznam što je skrivio. ");
INSERT INTO hrvbib_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Utvrdio sam da ga optužuju za nešto prijeporno glede njihova vjerskoga zakona—ali nije skrivio ništa što bi zasluživalo da ga se kazni smrću ili zatvorom. ");
INSERT INTO hrvbib_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Javili su mi da su protiv njega skovali urotu. Šaljem ga zato tebi, a njegove tužitelje uputio sam da tužbu iznesu pred tobom. ");
INSERT INTO hrvbib_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Te noći vojnici, prema zapovijedi, povedu Pavla u Antipatridu. ");
INSERT INTO hrvbib_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Sutradan se vrate u vojarnu ostavivši konjanike da ga odvedu dalje. ");
INSERT INTO hrvbib_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Kad su oni pak s njim stigli u Cezareju, uruče upravitelju pismo i privedu Pavla pred njega. ");
INSERT INTO hrvbib_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Upravitelj pročita pismo te zapita Pavla iz koje je pokrajine. “Iz Cilicije”, odgovori Pavao. ");
INSERT INTO hrvbib_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","“Saslušat ću te kad stignu tvoji tužitelji”, reče mu i zapovjedi da ga čuvaju u Herodovoj palači. ");
INSERT INTO hrvbib_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Nakon pet dana dođe židovski veliki svećenik Ananija sa starješinama i odvjetnikom Tertulom. Iznesu upravitelju tužbu protiv Pavla. ");
INSERT INTO hrvbib_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Pošto su pozvali Pavla da dođe, Tertulijan ga počne optuživati pred upraviteljem: “Preuzvišeni Felikse, mi Židovi uživamo velik mir i boljitak korisnih promjena u narodu zahvaljujući tvojoj providnosti. ");
INSERT INTO hrvbib_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Na svemu tome smo duboko zahvalni. ");
INSERT INTO hrvbib_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Da ti dugo ne dodijavam, molim te da nas blagonaklono poslušaš samo nakratko. ");
INSERT INTO hrvbib_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Utvrdili smo da je taj čovjek prava kuga, da neprekidno podjaruje Židove po cijelomu svijetu i da je kolovođa nazaretske sljedbe. ");
INSERT INTO hrvbib_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Čak je i Hram pokušao oskvrnuti pa smo ga uhitili. ");
INSERT INTO hrvbib_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Ispitaš li ga sam, utvrdit ćeš da su naše optužbe opravdane.” ");
INSERT INTO hrvbib_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Potvrde to i drugi Židovi podupirući ga. ");
INSERT INTO hrvbib_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Upravitelj glavom dade Pavlu znak da govori te on reče: “Znam da već mnogo godina sudiš ovomu narodu i zato se mirne duše branim. ");
INSERT INTO hrvbib_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Sam se možeš osvjedočiti da nije prošlo više od dvanaest dana otkako sam se otišao pokloniti Bogu u jeruzalemski Hram. ");
INSERT INTO hrvbib_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Nisam ni s kim raspravljao niti dizao bunu ni ondje, ni u sinagogama, ni po gradu. ");
INSERT INTO hrvbib_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Ovi ljudi ne mogu dokazati to za što me optužuju. ");
INSERT INTO hrvbib_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Ali priznajem da sam sljedbenik Puta, koji oni nazivaju sljedbom, te služim Bogu svojih predaka vjerujući u sve što piše u židovskome Zakonu i u proročkim knjigama. ");
INSERT INTO hrvbib_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Jednako se, kao i oni, pouzdajem u Boga da će uskrsnuti i pravednici i nepravednici. ");
INSERT INTO hrvbib_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Zato se uvijek trudim imati čistu savjest i pred Bogom i pred ljudima. ");
INSERT INTO hrvbib_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Nakon nekoliko godina vratio sam se u Jeruzalem donijeti milodare svojemu narodu i prinijeti žrtvu Bogu. ");
INSERT INTO hrvbib_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Moji su me tužitelji vidjeli u Hramu kad sam dovršavao obred posvećenja, a ne sa svjetinom ni u metežu. ");
INSERT INTO hrvbib_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Ali ondje su bili neki Židovi iz Male Azije—oni bi me, zapravo, trebali doći optužiti pred tobom ako imaju što protiv mene. ");
INSERT INTO hrvbib_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Ili upitaj ove ovdje kakvu su krivnju na meni našli članovi Vijeća ");
INSERT INTO hrvbib_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","osim možda jedne jedine riječi što sam ju viknuo stojeći među njima: ‘Danas mi se pred vama sudi jer vjerujem u uskrsnuće mrtvih!’” ");
INSERT INTO hrvbib_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Feliks, koji je mnogo znao o Putu, odgodi preslušanje i reče: “Pričekat ćete da dođe zapovjednik Lizija. On će riješiti vaš spor.” ");
INSERT INTO hrvbib_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Zapovjedi stotniku da i dalje čuva Pavla u zatvoru, ali da mu odobri olakšice i da nikomu od njegovih ne brani da ga poslužuje. ");
INSERT INTO hrvbib_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Nekoliko dana zatim Feliks dođe sa svojom ženom Druzilom koja je bila Židovka. Pošalje po Pavla te ga je slušao kako govori o vjeri u Isusa Krista. ");
INSERT INTO hrvbib_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Kad je Pavao počeo govoriti o pravednosti, uzdržljivosti i sudu što dolazi, Feliks se prestraši. “Idi sada”, reče. “Pozvat ću te kad nađem vremena.” ");
INSERT INTO hrvbib_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Nadao se, osim toga, da će mu Pavao dati novca. Zato ga je često pozivao i razgovarao s njim. ");
INSERT INTO hrvbib_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Tako su prošle dvije godine. Feliksa zatim zamijeni Porcije Fest. Želeći ugoditi Židovima, Feliks ostavi Pavla u zatvoru. ");
INSERT INTO hrvbib_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Tri dana pošto je preuzeo vlast nad pokrajinom, Fest iz Cezareje ode u Jeruzalem. ");
INSERT INTO hrvbib_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Ondje mu veliki svećenici i drugi židovski uglednici iznesu tužbu protiv Pavla. Preklinjali su ga da se smiluje ");
INSERT INTO hrvbib_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","i pošalje Pavla u Jeruzalem jer su spremali zasjedu da ga putem smaknu. ");
INSERT INTO hrvbib_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Ali Fest odgovori da je Pavao u zatvoru u Cezareji te da će i on uskoro onamo. ");
INSERT INTO hrvbib_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","“Ovlastite nekolicinu da pođu sa mnom”, reče stoga. “Ako je taj čovjek što skrivio, neka ga optuže.” ");
INSERT INTO hrvbib_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Osam ili deset dana potom vrati se u Cezareju. Sutradan sjedne na sudački stolac i zapovjedi da dovedu Pavla. ");
INSERT INTO hrvbib_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Kad uđe Pavao, židovski vođe iz Jeruzalema okruže ga i iznesu protiv njega mnoge teške optužbe koje nisu mogli dokazati. ");
INSERT INTO hrvbib_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Pavao se branio: “Nisam zgriješio ni protiv židovskoga Zakona, ni protiv Hrama, ni protiv cara.” ");
INSERT INTO hrvbib_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","A Festus ga, želeći ugoditi Židovima, upita: “Jesi li voljan poći u Jeruzalem da ti se ondje za to sudi u mojoj nazočnosti?” ");
INSERT INTO hrvbib_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Pavao odgovori: “Ne. Stojim pred carevim sudom, gdje mi se i treba suditi. Dobro znaš da tim Židovima nisam ništa skrivio. ");
INSERT INTO hrvbib_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Ako sam pak zaista skrivio što zaslužuje smrt, ne bježim od toga. Ali ako me ovi ovdje neopravdano tuže, nitko me ne može njima izručiti. Prizivam se na cara!” ");
INSERT INTO hrvbib_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Fest se na to posavjetuje s Vijećem pa odgovori: “Na cara si se prizvao, pred cara ćeš ići!” ");
INSERT INTO hrvbib_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Nakon nekoliko dana dođu kralj Agripa i njegova sestra Berenika u Cezareju pozdraviti Festa. ");
INSERT INTO hrvbib_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Kako su se ondje zadržali nekoliko dana, Fest ispriča kralju o Pavlu. “Tu je neki čovjek što ga je Feliks ostavio u zatvoru”, reče. ");
INSERT INTO hrvbib_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","“Dok sam bio u Jeruzalemu, veliki svećenici i starješine optužili su ga i zatražili da ga osudim. ");
INSERT INTO hrvbib_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Odgovorio sam im da Rimljani ne običavaju kazniti čovjeka a da mu ne sude. Prije toga valja optuženika suočiti s tužiteljima i dati mu prigodu da se brani od optužbe. ");
INSERT INTO hrvbib_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Kad su dakle skupa sa mnom doputovali ovamo, odmah sam sutradan, bez odgađanja, sjeo na sudački stolac i zapovjedio da dovedu tog čovjeka. ");
INSERT INTO hrvbib_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Ali tužitelji koji su stajali oko njega nisu ga optužili ni za što od onoga što sam ja pretpostavljao. ");
INSERT INTO hrvbib_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Riječ je bila o nečemu prijepornom glede njihove vjere, o nekakvome Isusu koji je umro, a Pavao tvrdi da je živ. ");
INSERT INTO hrvbib_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Ne snalazeći se u takvoj raspravi, upitao sam ga bi li htio poći u Jeruzalem da mu ondje za to sude. ");
INSERT INTO hrvbib_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Ali prizivom je zatražio da se podloži presudi njegova Veličanstva. Zato sam zapovjedio da ga čuvaju u zatvoru dok ga ne pošaljem caru.” ");
INSERT INTO hrvbib_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","“Htio bih i ja čuti tog čovjeka”, reče Agripa. “Čut ćeš ga sutra”, odgovori Fest. ");
INSERT INTO hrvbib_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Sutradan tako Agripa i Berenika uđu u dvoranu s velikim sjajem, praćeni vojnim zapovjednicima i najvećim gradskim uglednicima. Na Festovu zapovijed dovedu Pavla. ");
INSERT INTO hrvbib_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Fest tada reče: “Kralju Agripa i svi nazočni, evo čovjeka zbog kojega me svi ovdašnji i jeruzalemski Židovi salijeću vičući da ga smaknem. ");
INSERT INTO hrvbib_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Ali nisam utvrdio da je učinio išta zbog čega bi zaslužio smrt. Kako se on sam prizvao na cara, odlučio sam ga caru i poslati. ");
INSERT INTO hrvbib_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Ali nemam o njemu što pouzdano napisati caru. Zato sam ga izveo pred vas, posebice pred tebe, kralju Agripa, da bih nakon ove istrage znao što napisati. ");
INSERT INTO hrvbib_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Jer doista je besmisleno poslati zatvorenika caru a ne navesti za što se optužuje!” ");
INSERT INTO hrvbib_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Agripa nato reče Pavlu: “Dopušta ti se da se braniš.” Pavao zato ispruži ruku i počne se braniti: ");
INSERT INTO hrvbib_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Kralju Agripa, smatram se sretnim da se od svega za što me Židovi optužuju mogu, evo, danas braniti pred tobom ");
INSERT INTO hrvbib_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","jer ti najbolje poznaješ židovske običaje i razmirice. Molim te zato, strpljivo me poslušaj! ");
INSERT INTO hrvbib_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Židovski vođe dobro znaju kako sam od najranije mladosti živio među svojim narodom, u Jeruzalemu. ");
INSERT INTO hrvbib_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Odavno me poznaju i mogli bi, da samo hoće, posvjedočiti da sam bio farizej, član najstrože sljedbe u našoj vjeri. ");
INSERT INTO hrvbib_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Sada mi sude jer se nadam da će Bog ispuniti obećanje koje je dao našim precima. ");
INSERT INTO hrvbib_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Ispunjenju toga obećanja nadaju se i dvanaest izraelskih plemena koja postojano dan i noć služe Bogu. Za tu me nadu, kralju, tuže Židovi! ");
INSERT INTO hrvbib_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Zašto smatrate nevjerojatnim da Bog uskrisuje mrtve? ");
INSERT INTO hrvbib_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","I ja sam nekoć smatrao da se svim silama moram boriti protiv sljedbenika Isusa Nazarećanina. ");
INSERT INTO hrvbib_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Pošto sam dobio ovlasti od velikih svećenika u Jeruzalemu, mnoge sam svete zatvorio u tamnicu. Glasovao sam da ih osuđuju na smrt. ");
INSERT INTO hrvbib_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Po svim sam ih sinagogama primoravao, često mučenjem, da govore pogrde protiv Boga. Prekomjerno gnjevan na njih, progonio sam ih čak i u tuđim gradovima. ");
INSERT INTO hrvbib_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Dok sam tako po istoj zadaći išao u Damask s punomoći i ovlaštenjem velikih svećenika, ");
INSERT INTO hrvbib_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","u pol bijela dana vidio sam, kralju, kako je mene i moje suputnike obasjala svjetlost s neba sjajnija od sunca. ");
INSERT INTO hrvbib_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Popadali smo na zemlju. Zatim sam začuo glas kako mi na hebrejskome govori: ‘Savle, Savle! Zašto me progoniš? Teško je boriti se protiv moje volje.’ ");
INSERT INTO hrvbib_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","‘Tko si ti, Gospodine?’ upitao sam. A Gospodin odgovori: ‘Ja sam Isus kojega ti progoniš. ");
INSERT INTO hrvbib_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Ustani sada! Ukazao sam ti se da te postavim za poslužitelja i svjedoka onoga što si vidio i što ću ti još pokazati. ");
INSERT INTO hrvbib_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Izbavit ću te i od tvojega naroda i od pogana kojima te šaljem ");
INSERT INTO hrvbib_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","da im otvoriš oči, da se obrate od tame k svjetlosti, od Sotonine vlasti k Bogu. Tako će po vjeri u mene primiti oproštenje grijeha i mjesto među mojim svetim narodom.’ ");
INSERT INTO hrvbib_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Kralju Agripa, nisam bio neposlušan tome nebeskom viđenju. ");
INSERT INTO hrvbib_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Najprije sam propovijedao ljudima u Damasku pa u Jeruzalemu, a zatim svoj Judeji i poganima—da se pokaju od svojih grijeha i da se obrate Bogu te da čine djela dostojna obraćenja. ");
INSERT INTO hrvbib_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Židovi su me zato uhvatili u Hramu i pokušali ubiti. ");
INSERT INTO hrvbib_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Ali Bog me, eto, sačuvao da do današnjeg dana svjedočim svima, od najmanjega do najvećega, upravo ono što su pretkazivali proroci i Mojsije: ");
INSERT INTO hrvbib_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","da će Mesija trpjeti i da će prvi ustati od mrtvih te navješćivati svjetlost Židovima i poganima.” ");
INSERT INTO hrvbib_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Dok je još govorio u svoju obranu, Fest poviče: “Luduješ, Pavle! Preveliko ti je znanje pomutilo um!” ");
INSERT INTO hrvbib_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Ali Pavao odgovori: “Ne ludujem, preuzvišeni Feste. Govorim istinito i razumno. ");
INSERT INTO hrvbib_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Kralj Agripa zna za sve to i zato mu otvoreno govorim. Siguran sam da mu ništa od toga nije nepoznato jer se nije događalo u kakvu zakutku. ");
INSERT INTO hrvbib_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Kralju Agripa, vjeruješ li prorocima? Znam da im vjeruješ.” ");
INSERT INTO hrvbib_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Agripa reče: “Zamalo si me uvjerio da na brzinu postanem kršćaninom!” ");
INSERT INTO hrvbib_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","“Na brzinu ili ne,” odgovori mu Pavao, “dao Bog da ne samo ti nego i svi koji me ovdje slušaju postanu poput mene, izuzevši ove okove!” ");
INSERT INTO hrvbib_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Nato kralj, upravitelj, Berenika i njihovi pratitelji ustanu i odu. ");
INSERT INTO hrvbib_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Dok su odlazili, međusobno su razgovarali: “Taj čovjek nije učinio ništa čime bi zaslužio smrt ili zatvor.” ");
INSERT INTO hrvbib_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agripa reče Festu: “Da se nije prizvao na Cezara, mogli bismo ga osloboditi!” ");
INSERT INTO hrvbib_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Odlučeno je da odjedrimo u Italiju. Pavla i nekolicinu drugih zatvorenika predali su stotniku carske čete Juliju. ");
INSERT INTO hrvbib_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Ukrcali smo se na neku adramitsku lađu koja je plovila u azijska mjesta te otplovili. S nama je bio i neki Makedonac, Aristarh iz Soluna. ");
INSERT INTO hrvbib_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Sutradan smo doplovili u Sidon. Julije je s Pavlom vrlo ljubazno postupao. Dopustio mu je posjetiti prijatelje, da se pobrinu za njegove potrebe. ");
INSERT INTO hrvbib_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Otplovili smo dalje jedreći sjeverno uz Cipar između otoka i kopna jer su puhali suprotni vjetrovi. ");
INSERT INTO hrvbib_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Prošli smo uz cilicijsku i pamfilijsku obalu te stigli u grad Miru u Liciji. ");
INSERT INTO hrvbib_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Ondje stotnik pronađe neku lađu što je iz Aleksandrije plovila u Italiju, pa nas ukrca na nju. ");
INSERT INTO hrvbib_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Nekoliko smo dana sporo plovili i jedva došli do Knida. Kako od vjetra nismo mogli pristati, otplovili smo pod Kretu, do Salmone, ");
INSERT INTO hrvbib_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","pa na jedvite jade uz nju do nekoga mjesta zvanog Dobra pristaništa, blizu grada Laseje. ");
INSERT INTO hrvbib_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Mnogo smo vremena izgubili. Plovidba je postala vrlo opasnom jer je već bila jesen, a Pavao upozori: ");
INSERT INTO hrvbib_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Ljudi, vidim da će plovidba biti pogibeljna i da ćemo pretrpjeti veliku štetu—ne samo u teretu nego i u našim životima.” ");
INSERT INTO hrvbib_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Ali stotnik je više vjerovao kormilaru i vlasniku broda nego Pavlu. ");
INSERT INTO hrvbib_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Kako luka nije bila prikladna za zimovanje, većina je ljudi predlagala da otplove i pokušaju doći do luke Feniks na Kreti, otvorenoj prema jugozapadu i sjeverozapadu, te da ondje prezimimo. ");
INSERT INTO hrvbib_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Tada puhne blagi južnjak te oni, misleći da bi mogli uspjeti u toj nakani, dignu sidro i zaplove uz samu obalu Krete. ");
INSERT INTO hrvbib_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Ali ubrzo zatim silovito zapuše žestok vjetar zvani sjeveroistočnjak. ");
INSERT INTO hrvbib_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Zahvati lađu tako da mu se nije mogla oteti, pa smo se prepustili da nas nosi. ");
INSERT INTO hrvbib_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Kad smo prolazili uz neki otočić zvan Kauda, jedva smo na brod podignuli čamac za spašavanje koji smo vukli za sobom. ");
INSERT INTO hrvbib_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Podignuli su ga da uporabe opremu za spašavanje i da konopcima potpašu lađu. Bojeći se da se ne nasuču na Sirtu uz afričku obalu, spuste plivajuće sidro te smo tako plovili dalje nošeni vjetrom. ");
INSERT INTO hrvbib_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Kako nas je oluja silovito bacala, sutradan izbace s broda teret, ");
INSERT INTO hrvbib_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","a treći dan brodsku opremu i sve čega su se domogli. ");
INSERT INTO hrvbib_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Strašna je oluja bjesnjela mnogo dana te se nisu mogli vidjeti ni sunce ni zvijezde. Gubili smo svaku nadu da ćemo se spasiti. ");
INSERT INTO hrvbib_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Dugo već nismo ništa jeli. Pavao stane pred posadu i reče: “Trebali ste me, ljudi, poslušati i ne odlaziti s Krete pa biste izbjegli svu ovu nevolju i štetu. ");
INSERT INTO hrvbib_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Ali sada vam kažem: budite odvažni jer nitko od nas neće stradati iako će lađa potonuti. ");
INSERT INTO hrvbib_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Noćas mi se ukazao anđeo Boga kojemu pripadam i služim ");
INSERT INTO hrvbib_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","te mi rekao: ‘Ne boj se, Pavle, jer ćeš sigurno stići pred cara! A Bog ti daruje i da svi tvoji suputnici sigurno doputuju.’ ");
INSERT INTO hrvbib_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Zato se, ljudi, razvedrite! Vjerujem Bogu. Bit će kako mi je rekao. ");
INSERT INTO hrvbib_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Ali nasukat ćemo se na neki otok.” ");
INSERT INTO hrvbib_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Četrnaeste noći oluje, oko ponoći, vjetar nas je gonio amo-tamo po Jadranu. Mornari naslute da se približava nekakvo kopno. ");
INSERT INTO hrvbib_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Bace olovnicu i izmjere dvadeset hvati dubine. Malo zatim opet ju bace i izmjere petnaest hvati. ");
INSERT INTO hrvbib_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Prestraše se da ne nalete na grebene pa bace s krme četiri sidra i počnu se moliti da se brzo razdani. ");
INSERT INTO hrvbib_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Mornari su kanili pobjeći s lađe pa počnu spuštati čamac u more pod izlikom da kane spustiti sidra s pramca. ");
INSERT INTO hrvbib_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Ali Pavao reče stotniku i vojnicima: “Ne ostanu li oni na lađi, nećete se spasiti!” ");
INSERT INTO hrvbib_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Vojnici prerežu užad i puste da čamac padne u more. ");
INSERT INTO hrvbib_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Sve do svanuća Pavao je molio ljude da jedu. “Četrnaest dana niste ni taknuli jelo”, reče. ");
INSERT INTO hrvbib_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","“Molim vas, pojedite što za vlastito dobro. Jer neće vam pasti ni vlas s glave.” ");
INSERT INTO hrvbib_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Kad je to rekao, uzme kruh te pred svima zahvali Bogu, razlomi ga i počne jesti. ");
INSERT INTO hrvbib_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Svi se razvedre i uzmu hranu. ");
INSERT INTO hrvbib_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","U lađi nas je bilo dvjesto sedamdeset šest duša. ");
INSERT INTO hrvbib_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Kad su se najeli, počnu rasterećivati lađu bacajući žito u more. ");
INSERT INTO hrvbib_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Kad se razdanilo, mornari nisu prepoznali obalu, ali opazili su neki zaljev ravne obale te odluče pokušati onamo zavesti lađu. ");
INSERT INTO hrvbib_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Odvežu zato sidra i puste da padnu u more. Popuste konopce na kormilima i razviju prednje jedro prema vjetru te se usmjere prema obali. ");
INSERT INTO hrvbib_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Ali nalete na plićak i brod se nasuče. Pramac nasjedne i ostane nepomičan, a krmu su razbijali žestoki valovi. ");
INSERT INTO hrvbib_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Vojnici nakane poubijati zatvorenike da koji ne otpliva i ne pobjegne, ");
INSERT INTO hrvbib_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","ali im stotnik, želeći poštedjeti Pavla, ne dopusti da to učine. Zapovjedi da oni koji znaju plivati prvi skoče u more i otplivaju do obale, ");
INSERT INTO hrvbib_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","a ostalima reče da doplivaju na daskama i olupinama lađe. Tako su svi živi i zdravi dospjeli na kopno. ");
INSERT INTO hrvbib_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Kad smo dospjeli na sigurno, doznali smo da se otok zove Malta. ");
INSERT INTO hrvbib_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Njegovi su žitelji bili neobično ljubazni prema nama. Bilo je hladno i kišilo je pa su zapalili vatru i okupili nas oko nje da se ugrijemo. ");
INSERT INTO hrvbib_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Pavao nakupi naramak granja i baci ga na vatru, ali zbog vrućine iz njega iziđe zmija i uhvati mu se za ruku. ");
INSERT INTO hrvbib_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Kad su žitelji otoka vidjeli da mu ta životinja visi na ruci, rekli su: “Taj je čovjek zacijelo ubojica. Umaknuo je moru, ali Pravda mu ne dopušta živjeti.” ");
INSERT INTO hrvbib_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Ali on otrese zmiju u vatru, neozlijeđen. ");
INSERT INTO hrvbib_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Ljudi su čekali da otekne i da se sruši mrtav. Ali pošto su dugo čekali, a nije se dogodilo ništa, predomisle se i zaključe da je bog. ");
INSERT INTO hrvbib_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Nedaleko odande nalazilo se imanje poglavara tog otoka, Publija. On nas primi i tri nas je dana ljubazno gostio. ");
INSERT INTO hrvbib_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Publijeva su oca mučile vrućica i srdobolja pa je ležao. Pavao uđe k njemu, položi na njega ruke i pomoli se—i iscijeli ga. ");
INSERT INTO hrvbib_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Nakon toga dolazili su još mnogi bolesnici s otoka te su ozdravljali. ");
INSERT INTO hrvbib_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Iskazali su nam zato mnoge počasti, a kad smo odlazili, stavili su nam u lađu sve što nam je trebalo. ");
INSERT INTO hrvbib_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Tri mjeseca nakon brodoloma otplovili smo nekom aleksandrijskom lađom koja je prezimila na otoku. Na pramcu je imala kip Dioskura. ");
INSERT INTO hrvbib_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Doplovili smo najprije u Sirakuzu i ondje ostali tri dana. ");
INSERT INTO hrvbib_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Odande smo, ploveći uz obalu, stigli u Regij. Dan poslije počne puhati južnjak pa smo za dva dana stigli u Puteole. ");
INSERT INTO hrvbib_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Ondje smo naišli na braću koja su nas zamolila da ostanemo sedam dana. Tako smo stigli u Rim. ");
INSERT INTO hrvbib_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Kad su braća u Rimu čula da dolazimo, iziđu nam u susret do Apijeva trga i Triju gostionica. Kad ih je spazio, Pavao zahvali Bogu i ohrabri se. ");
INSERT INTO hrvbib_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Kad smo ušli u Rim, Pavlu dopuste da stanuje posebno, s vojnikom koji ga je čuvao. ");
INSERT INTO hrvbib_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Tri dana nakon što je došao Pavao sazove židovske uglednike te im reče: “Braćo, ništa nisam učinio protiv našega naroda ni protiv običaja naših predaka, ali ipak su me u Jeruzalemu uhitili i predali u ruke Rimljanima. ");
INSERT INTO hrvbib_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Rimljani su me nakon istrage htjeli pustiti jer su zaključili da ničim nisam zaslužio da umrem. ");
INSERT INTO hrvbib_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Židovi su se tome usprotivili pa sam se zato morao prizvati na cara—a ne zato što bih htio tužiti vlastiti narod. ");
INSERT INTO hrvbib_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Zato sam, eto, zamolio da vas vidim i da vam govorim: zbog Izraelove nade, Mesije.” ");
INSERT INTO hrvbib_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","“Mi nismo čuli ništa protiv tebe”, odgovore mu oni. “Niti smo dobili kakvo pismo iz Judeje, niti nam je tko od braće koja su došla ovamo što rekao. ");
INSERT INTO hrvbib_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Ali htjeli bismo čuti što ti misliš jer o toj kršćanskoj sljedbi znamo samo da joj se posvuda protive.” ");
INSERT INTO hrvbib_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Dogovore se te jednog dana mnogi dođu u njegov stan. Govorio im je o Božjemu kraljevstvu i od jutra do večeri ih poučavao o Isusu iz Mojsijeva zakona i proročkih knjiga. ");
INSERT INTO hrvbib_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Neki su povjerovali, a neki nisu. ");
INSERT INTO hrvbib_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Kad su se tako u neslozi počeli razilaziti, Pavao ih isprati riječima: “Dobro je Sveti Duh rekao vašim precima po proroku Izaiji: ");
INSERT INTO hrvbib_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","‘Slušat ćete moje riječi, ali nećete ih razumjeti; gledat ćete moja djela, ali nećete dokučiti njihova značenja. ");
INSERT INTO hrvbib_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Jer srca su se ovoga naroda usalila, uši njihove ne čuju, a oči su zatvorili— tako njihove oči ne vide i njihove uši ne čuju, a srca im ne mogu razumjeti. Zato se ne mogu obratiti k meni da ih iscijelim.’ ");
INSERT INTO hrvbib_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Hoću dakle da znate: Bog je svoje spasenje poslao poganima i oni će ga prihvatiti.” ");
INSERT INTO hrvbib_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Sljedeće dvije godine Pavao je živio u unajmljenom stanu. Primao je sve koji su dolazili. ");
INSERT INTO hrvbib_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Hrabro je propovijedao o Božjemu kraljevstvu i otvoreno poučavao o Gospodinu Isusu Kristu. I nitko ga nije pokušavao spriječiti.");
INSERT INTO hrvbib_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Ovo je pismo od Pavla, sluge Isusa Krista, koji je izabran za apostola, poslan propovijedati Božju Radosnu vijest. ");
INSERT INTO hrvbib_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Tu je Radosnu vijest Bog već odavno obećao po svojim prorocima u Svetome pismu. ");
INSERT INTO hrvbib_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Ta je Radosna vijest o njegovu Sinu Isusu Kristu, našemu Gospodinu, koji je postao čovjekom rodivši se kao potomak kralja Davida. ");
INSERT INTO hrvbib_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Isus Krist, naš Gospodin, pokazao je da je Božji Sin kad ga je Bog silnom moći podignuo od mrtvih Duhom svetosti. ");
INSERT INTO hrvbib_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Kroz Krista nam je Bog iskazao milost i dao apostolstvo da naviještamo svim narodima što je Bog učinio za njih, tako da uzvjeruju i poslušaju ga te donesu slavu njegovu imenu. ");
INSERT INTO hrvbib_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","I vi ste među onima koji su pozvani pripadati Isusu Kristu. ");
INSERT INTO hrvbib_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Svima vama u Rimu, koje on istinski ljubi: pozvani ste po Isusu Kristu da budete njegovi, njegov sveti narod. Neka vam je milost i mir od našega Boga Oca i Gospodina Isusa Krista. ");
INSERT INTO hrvbib_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Najprije zahvaljujem svojemu Bogu po Isusu Kristu za sve vas, što vaša vjera postaje poznata po svemu svijetu. ");
INSERT INTO hrvbib_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Bog mi je svjedok koliko se često molim za vas. Neprekidno se molim za vas onomu kojemu služim svim srcem navješćujući drugima Radosnu vijest o njegovu Sinu. ");
INSERT INTO hrvbib_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Stalno se molim i za priliku, ako bude Božja volja, da vas napokon uspijem posjetiti. ");
INSERT INTO hrvbib_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Čeznem vas vidjeti da podijelim s vama darove Svetoga Duha, da se osnažite u Gospodinu, ");
INSERT INTO hrvbib_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","te da vas ohrabrim u vjeri, ali i da se ja ohrabrim vašom vjerom. ");
INSERT INTO hrvbib_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Htio bih da znate, draga braćo, da sam više puta kanio doći da djelujem među vama i vidim dobre rezultate, baš kao što sam vidio i među drugim narodima, ali dosad sam bio spriječen. ");
INSERT INTO hrvbib_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Dužan sam služiti i civiliziranim i barbarskim narodima, učenima jednako kao i neukima. ");
INSERT INTO hrvbib_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Zato i vama u Rimu želim propovijedati Radosnu vijest. ");
INSERT INTO hrvbib_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Zaista, ne stidim se Radosne vijesti o Isusu Kristu jer je ona Božja sila koja spašava svakoga tko vjeruje—ponajprije Židove, ali i druge narode. ");
INSERT INTO hrvbib_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Ta nam Radosna vijest govori na koji nas način Bog čini pravednima u svojim očima: od početka do svršetka samo vjerom. Kao što piše u Svetome pismu: “Pravednik će živjeti po vjeri.” ");
INSERT INTO hrvbib_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Ali s neba se zaista očituje Božji gnjev na svaku bezbožnost i nepravednost ljudi koji bezbožnim životom sprečavaju da istina o Bogu iziđe na vidjelo. ");
INSERT INTO hrvbib_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Jer što se o Bogu može znati, zapravo im je već poznato. On im je to obznanio: ");
INSERT INTO hrvbib_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","njegova nevidljiva svojstva—vječna sila i božanstvo još se od stvaranja svijeta mogu umom razabrati po njegovim djelima. Zato nemaju isprike. ");
INSERT INTO hrvbib_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Jer iako su znali da Bog postoji, nisu mu kao Bogu iskazali ni slavu ni zahvalnost, nego su im misli postale ispraznima, a nerazumno im je srce potamnjelo. ");
INSERT INTO hrvbib_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Tvrdeći za sebe da su mudri, postali su bezumnima ");
INSERT INTO hrvbib_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","te su se, umjesto slavnome i besmrtnome Bogu, počeli klanjati raspadljivim obličjima, kipovima i slikama čovjeka, ptica, četveronožaca i gmazova. ");
INSERT INTO hrvbib_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Zato ih je Bog prepustio nečistoći njihova pohotnog srca pa sami obeščašćuju svoja tijela. ");
INSERT INTO hrvbib_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Jer oni su umjesto Božje istine odabrali laž. Klanjali su se i služili stvorenju umjesto Stvoritelju kojemu pripada slava uvijeke. Amen. ");
INSERT INTO hrvbib_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Bog ih je zato predao njihovim sramotnim strastima: umjesto da imaju prirodne spolne odnose, žene opće međusobno, što je protunaravno, ");
INSERT INTO hrvbib_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","a muškarci također nemaju naravne odnose sa ženama, već su usplamtjeli pohotom jedni za drugima. Muškarci s muškarcima čine sramotne stvari te na sebi primaju zasluženu kaznu za svoje zastranjenje. ");
INSERT INTO hrvbib_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Zato što nisu držali vrijednim spoznati Boga, Bog ih je predao pokvarenu načinu razmišljanja da čine ono što ne dolikuje. ");
INSERT INTO hrvbib_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Žive u kojekakvim grijesima, pokvarenosti, lakomosti i pakosti; puni su zavisti, ubojstva, svađe, lukavštine i podmuklosti; ogovaraju, ");
INSERT INTO hrvbib_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","klevetnici su, mrze Boga, nasilnici su, oholi, umišljeni. Stalno smišljaju nova zla, neposlušni su roditeljima, ");
INSERT INTO hrvbib_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","nerazumni, nevjerni, bešćutni i nemilosrdni. ");
INSERT INTO hrvbib_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Znaju da prema Božjoj odredbi ljudi koji tako čine zaslužuju smrt, ali svejedno tako postupaju. Štoviše, i drugima odobravaju takve postupke te ih tako na njih potiču. ");
INSERT INTO hrvbib_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Ali ti koji zbog toga sudiš druge nemaš za to isprike, ma tko bio. Sudeći druge, osuđuješ samoga sebe jer i ti činiš isto što i oni. ");
INSERT INTO hrvbib_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","A znamo da će Bog po istini suditi onima koji takvo što čine. ");
INSERT INTO hrvbib_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Misliš li ti, čovječe, koji i sam tako činiš, a osuđuješ druge, da ćeš izbjegnuti Božji sud? ");
INSERT INTO hrvbib_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Prezireš li izobilje Božje dobrote, velikodušnosti i strpljivosti prema tebi? Ne razumiješ li da te Bog dobrotom želi dovesti do obraćenja? ");
INSERT INTO hrvbib_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Ali ti svojom tvrdokornošću i srcem koje ne želi pokajanje sam na sebe navlačiš gnjev. A doći će Dan Božjega gnjeva kad će se Božja pravda očitovati u pravednome Božjem sudu ");
INSERT INTO hrvbib_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","koji će svakome dosuditi prema njegovim djelima: ");
INSERT INTO hrvbib_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","onima koji postojano čine dobra djela i tako teže slavi, časti i besmrtnosti—vječni život, ");
INSERT INTO hrvbib_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","a samovoljnicima, koji se opiru istini i priklanjaju nepravdi—gnjev i srdžbu. ");
INSERT INTO hrvbib_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Nevolja i tjeskoba snaći će dušu svakoga čovjeka koji čini zlo—posebice Židova, ali i pripadnika drugih naroda, ");
INSERT INTO hrvbib_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","a slava, čast i mir bit će svima koji čine dobro, i Židovima i pripadnicima drugih naroda. ");
INSERT INTO hrvbib_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Jer Bog nije pristran. ");
INSERT INTO hrvbib_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Kaznit će pripadnike drugih naroda za grijeh iako nikad nisu imali pisani Božji zakon, a Židovima će suditi po Zakonu jer su pod Zakonom i zgriješili. ");
INSERT INTO hrvbib_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Pred Bogom, naime, nisu pravedni oni koji Zakon poznaju, nego oni koji se drže njegovih odredbi. ");
INSERT INTO hrvbib_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Jer pripadnici naroda koji nemaju Zakona naravno razabiru što je dobro i tako se drže zakonskih odredbi iako im one nisu zadane. Tako su oni sami sebi Zakonom, ");
INSERT INTO hrvbib_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","što pokazuje da je to što Zakon nalaže upisano u njihovim srcima. O tome svjedoče njihova savjest i prosuđivanja na temelju kojih se optužuju ili brane. ");
INSERT INTO hrvbib_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Sve će se to očitovati na Dan kada će Bog po Isusu Kristu suditi ono što je skriveno u ljudima. To je evanđelje koje navješćujem. ");
INSERT INTO hrvbib_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Ali ti koji se nazivaš Židovom pouzdaješ se u Zakon i ponosiš svojim dobrim odnosom s Bogom, ");
INSERT INTO hrvbib_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","poznaješ Božju volju i znaš prepoznati što je bolje jer te tomu uči Zakon. ");
INSERT INTO hrvbib_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Uvjeren si da si vođa slijepcima i svjetlo ljudima u tami, ");
INSERT INTO hrvbib_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","da možeš odgajati nerazumne i poučavati neuke zato što u Zakonu imaš oličenje znanja i istine. ");
INSERT INTO hrvbib_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Ali ti koji poučavaš druge, ne poučavaš samoga sebe! Propovijedaš da se ne krade, a kradeš! ");
INSERT INTO hrvbib_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Zabranjuješ preljub, a počinjaš ga! Idoli su ti gnusni, ali pljačkaš njihove hramove! ");
INSERT INTO hrvbib_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Ponosiš se time što imaš Zakon, a sramotiš Boga kršeći ga! ");
INSERT INTO hrvbib_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Nije stoga ni čudno da u Svetom pismu piše: “Božje ime se vašom krivnjom huli među narodima.” ");
INSERT INTO hrvbib_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Obrezanje ti kao Židovu koristi samo ako poštuješ Zakon, ali ako Zakon kršiš, onda kao da i nisi obrezan: ono te ne čini ništa boljim od neobrezanog poganina. ");
INSERT INTO hrvbib_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Ako se dakle neobrezan čovjek drži odredbi Zakona, neće li mu se to uračunati kao obrezanje? ");
INSERT INTO hrvbib_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Oni koji su podrijetlom neobrezanici, a drže se Zakona, bit će na osudu vama koji ste, iako imate pisani Zakon i obrezanje, prijestupnici prema Zakonu. ");
INSERT INTO hrvbib_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Pravi Židov nije onaj tko je Židov izvana, niti je pravo obrezanje vidljivo obrezanje tijela, ");
INSERT INTO hrvbib_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","već je Židov Židov po onome iznutra, a pravo je obrezanje promjena srca koju čini Božji Duh, a ne pisani zakon. Koji su primili takvo obrezanje, primit će pohvalu od Boga, a ne od ljudi. ");
INSERT INTO hrvbib_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Kakva je onda prednost biti Židovom? I kakva je korist od obrezanja? ");
INSERT INTO hrvbib_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Velika u svakom pogledu! Ponajprije: Židovima su povjerena Božje riječi. ");
INSERT INTO hrvbib_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Neki su od njih, doduše, bili nevjerni, ali zar će njihova nevjera obeskrijepiti Božju vjernost? ");
INSERT INTO hrvbib_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Nipošto! Iako je “svaki čovjek lažac”, Bog je istinit. Zato u Svetome pismu za njega piše: “Dokazat će se da je istinito sve što kažeš, i dobit ćeš parnicu na sudu.” ");
INSERT INTO hrvbib_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Što pak ako naša nepravednost samo ističe Božju pravednost? Ako je tako, što na to reći? Je li nepravedan Bog koji zbog nje daje maha svojemu gnjevu? To bi, naime, ljudi rekli. ");
INSERT INTO hrvbib_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Nipošto! Jer da Bog nije pravedan, kako bi sudio svijet? ");
INSERT INTO hrvbib_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Ali neki će pitati: “Ako moje nepoštenje samo ističe Božju istinu i donosi Bogu još više slave, kako me Bog može osuditi i kazniti zato što sam grešnik?” ");
INSERT INTO hrvbib_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Razmišljate li tako, međutim, mogli biste isto tako reći: “Što više griješimo, to bolje!” Koji tako govore, zaslužuju kaznu, a neki me čak kleveću da ja to propovijedam! ");
INSERT INTO hrvbib_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Jesmo li mi Židovi, dakle, bolji od drugih? Nismo. Jer upravo smo optužili sve ljude, i Židove i pogane, da su pod vlašću grijeha. ");
INSERT INTO hrvbib_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Kao što Sveto pismo kaže: “Nema ni jednoga jedinog pravednika, ");
INSERT INTO hrvbib_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","nikoga razumnoga, nikoga tko traži Boga. ");
INSERT INTO hrvbib_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Svi su zastranili, svi se skupa pokvarili, nema ni jednoga jedinoga da čini dobro.” ");
INSERT INTO hrvbib_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","“Njihovo je grlo otvoren grob, a jezik im je prijevaran. Zmijski im je otrov na usnama.” ");
INSERT INTO hrvbib_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","“Usta su im puna kletve i gorčine.” ");
INSERT INTO hrvbib_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","“Noge im hitaju na prolijevanje krvi, ");
INSERT INTO hrvbib_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","kud prolaze, siju pustoš i bijedu. ");
INSERT INTO hrvbib_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Oni ne poznaju put mira.” ");
INSERT INTO hrvbib_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","“Nema Božjeg straha pred njihovim očima.” ");
INSERT INTO hrvbib_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Zakon se, znamo, odnosi na one kojima je dan jer mu je svrha da svaka usta zanijeme bez isprike i da sav svijet stane pred Božji sud. ");
INSERT INTO hrvbib_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Jer nitko se ne može u Božjim očima opravdati izvršavanjem zakonskih zapovijedi. Što bolje poznajemo Božji zakon, jasnije nam je da smo mu neposlušni, da smo grešnici. ");
INSERT INTO hrvbib_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Ali Bog nam je pokazao drukčiji način da postanemo pravednima u njegovim očima—ne poštovanjem Zakona, već onako kako je to odavno obećao u Svetome pismu. ");
INSERT INTO hrvbib_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Pred Bogom smo opravdani vjerom u Isusa Krista. Tako se spašavaju svi koji vjeruju, bez razlike. ");
INSERT INTO hrvbib_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Jer svi smo zgriješili i lišeni smo Božje slave. ");
INSERT INTO hrvbib_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","A Bog nam ipak milostivo daruje opravdanje kroz Isusa Krista, koji nas je otkupio uzimajući na sebe naše grijehe. ");
INSERT INTO hrvbib_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Jer Bog je poslao Isusa da svojom krvlju bude Pomirilište po vjeri—da preuzme kaznu za naše grijehe i da ugasi Božji gnjev na nas. Pred Bogom smo opravdani ako vjerujemo da je Isus prolio svoju krv i da je za naše spasenje žrtvovao svoj život. Bog je ranije počinjene grijehe u svojoj strpljivosti ostavio nekažnjenima kako bi pokazao svoju pravednost. ");
INSERT INTO hrvbib_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","On je potpuno pravedan u ovo vrijeme kada grešnike proglašuje nedužnima zbog vjere u Isusa. ");
INSERT INTO hrvbib_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Možemo li se dakle hvaliti da smo ičim zaradili Božje opravdanje? Ne možemo, jer se ono ne temelji na dobrim djelima, već na našoj vjeri. ");
INSERT INTO hrvbib_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Pred Bogom smo opravdani vjerom, a ne izvršavanjem Zakona. ");
INSERT INTO hrvbib_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Zar je Bog samo Bog Židova? Nije li i Bog pogana? Razumije se da jest. ");
INSERT INTO hrvbib_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Samo je jedan Bog i samo je jedan način da nas on prihvati. On nas pred sobom opravdava samo našom vjerom, bili mi Židovi ili pogani. ");
INSERT INTO hrvbib_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Ukidamo li tako vjerom Božji zakon? Nipošto! Jer tek kad imamo vjeru, zaista ispunjamo Zakon. ");
INSERT INTO hrvbib_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Abraham je bio naš otac. Kakvo je njegovo iskustvo glede spasenja po vjeri? ");
INSERT INTO hrvbib_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Je li ga Bog smatrao opravdanim zbog njegovih dobrih djela? Da je bilo tako, imao bi se čime hvaliti. Ali u Božjim očima Abraham se nije imao čime ponositi. ");
INSERT INTO hrvbib_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Jer Sveto pismo kaže: “Abraham je povjerovao Bogu, i Bog ga je proglasio pravednim zbog njegove vjere.” ");
INSERT INTO hrvbib_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Kad čovjek radi, plaća koju dobije nije dar. Radnici zarade ono što dobiju. ");
INSERT INTO hrvbib_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Ali ljudi su opravdani zbog svoje vjere u Onoga koji opravdava bezbožnike, a ne zbog svojih djela. ");
INSERT INTO hrvbib_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Kralj David je o tome govorio opisujući sreću nezaslužna čovjeka kojega je Bog proglasio pravednim. ");
INSERT INTO hrvbib_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","“Blago onima kojima su grijesi oprošteni i zločin uklonjen. ");
INSERT INTO hrvbib_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Blago onomu kojemu Gospodin neće uračunati grijehe.” ");
INSERT INTO hrvbib_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Je li to blaženstvo samo za obrezane, za Židove, ili također i za pogane? Rekli smo da ga je Bog proglasio pravednim zbog njegove vjere. ");
INSERT INTO hrvbib_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Ali kako mu je ta vjera pomogla? Je li proglašen pravednim prije ili poslije obrezanja? Bog ga je najprije prihvatio, a zatim je bio obrezan! ");
INSERT INTO hrvbib_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Obrezanje je bilo znak da Abraham već vjeruje i da ga je Bog prihvatio i proglasio pravednim i prije obrezanja. Zato je Abraham duhovni otac onih koji vjeruju, a nisu obrezani. Oni su pred Bogom opravdani po vjeri. ");
INSERT INTO hrvbib_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Abraham je također duhovni otac obrezanih, ali samo onih koji imaju vjeru kakvu je Abraham imao prije obrezanja. ");
INSERT INTO hrvbib_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Jasno je dakle kako se Božje obećanje da će Abrahamu i njegovim potomcima dati u baštinu cijelu zemlju nije temeljilo na poslušnosti Božjemu zakonu, nego na novome odnosu s Bogom koji dolazi kroz vjeru. ");
INSERT INTO hrvbib_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Tvrdite li da je Božje obećanje za one koji ispunjavaju Božji zakon i stoga misle da su “dovoljno dobri” u Božjim očima, onda zapravo govorite da je vjera nepotrebna. A tada bi i to obećanje bilo besmisleno. ");
INSERT INTO hrvbib_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Ali Zakon donosi kaznu onima koji ga pokušavaju ispunjavati. (Izbjegnuti kršenje zakona moguće je samo ako ne postoji zakon koji bi se kršio!) ");
INSERT INTO hrvbib_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Zato je važna vjera. Božje smo obećanje dobili na dar. I sigurni smo da ćemo ga primiti, držali se židovskih običaja ili ne, budemo li samo imali vjeru poput Abrahamove. Jer Abraham je otac svih koji vjeruju. ");
INSERT INTO hrvbib_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","U Svetome pismu o tome piše: “Postavljam te za oca mnogih naroda.” Jer Abraham je povjerovao u Boga koji oživljuje mrtve i na čiju zapovijed nastaje ono čega prije nije bilo. ");
INSERT INTO hrvbib_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Kad je Bog obećao Abrahamu da će postati ocem mnogih naroda i rekao: “Tvoji će potomci biti brojni poput zvijezda”, Abraham mu je povjerovao iako se to obećanje činilo neostvarivim. ");
INSERT INTO hrvbib_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Abraham se nije pokolebao u vjeri iako je znao kako je u dobi od stotinu godina i kako njegova žena Sara ne može imati djecu. ");
INSERT INTO hrvbib_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Abraham nikada nije posumnjao u Božje obećanje. Njegova je vjera jačala i njome je proslavio Boga. ");
INSERT INTO hrvbib_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Bio je posve uvjeren da Bog može učiniti sve što obeća. ");
INSERT INTO hrvbib_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Tako je Bog Abrahama zbog vjere proglasio pravednim. ");
INSERT INTO hrvbib_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Ta divna istina da ga je Bog proglasio pravednim nije bila na dobrobit samo Abrahamu ");
INSERT INTO hrvbib_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","već i nama. Bog će također nas proglasiti pravednima vjerujemo li u Boga koji je našega Gospodina Isusa uskrsnuo od mrtvih. ");
INSERT INTO hrvbib_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","On je predan da umre za naše grijehe i podignut je od mrtvih da nas opravda pred Bogom. ");
INSERT INTO hrvbib_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Opravdani smo dakle u Božjim očima vjerom te pomireni s Bogom zbog onoga što je naš Gospodin Isus Krist za nas učinio. ");
INSERT INTO hrvbib_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Zbog vjere u njega možemo pristupiti najvećoj milosti i radujemo se nadi Božje slave. ");
INSERT INTO hrvbib_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Možemo se radovati i kad smo u nevolji jer znamo da je to za naše dobro—jača našu strpljivost. ");
INSERT INTO hrvbib_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","Strpljivost donosi prokušanost, a prokušanost nadu. ");
INSERT INTO hrvbib_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Zbog tog se očekivanja nećemo postidjeti. Jer znamo da nas Bog silno ljubi—ulio je tu ljubav u naša srca po Svetom Duhu. ");
INSERT INTO hrvbib_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Kad smo bili potpuno bespomoćni, Krist je došao u pravo vrijeme i umro za nas grešnike. ");
INSERT INTO hrvbib_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Za dobra čovjeka malo bi tko bio voljan umrijeti, iako bi se za izvanredno dobra čovjeka možda i našao tko da za njega dade život. ");
INSERT INTO hrvbib_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","No Bog je pokazao svoju veliku ljubav prema nama time što je poslao Krista da umre za nas dok smo još bili grešnici. ");
INSERT INTO hrvbib_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","A kako smo mi u Božjim očima opravdani Kristovom krvlju, on će nas sigurno spasiti od Božjega suda. ");
INSERT INTO hrvbib_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Jer kako nas je, dok smo još bili Božji neprijatelji, s njime pomirila smrt njegova Sina, tako će nas život njegova Sina sigurno osloboditi vječne kazne. ");
INSERT INTO hrvbib_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Zato se sada možemo radovati svojemu novom odnosu prema Bogu—zato što nas je naš Gospodin Isus Krist pomirio s Bogom. ");
INSERT INTO hrvbib_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Kad je Adam zgriješio, grijeh je ušao u sav ljudski rod. A budući da je taj Adamov grijeh donio smrt, smrt je prešla na sve ljude jer su svi zgriješili. ");
INSERT INTO hrvbib_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Doista, ljudi su griješili i prije nego što su dobili Zakon. Ali iako još nije bilo Zakona koji bi kršili, ");
INSERT INTO hrvbib_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","svi su oni—od Adama do Mojsija—umrli iako nisu prekršili jasnu Božju zapovijed kao što je to Adam učinio. Kakve li razlike između Adama i Krista koji je tek trebao doći! ");
INSERT INTO hrvbib_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Kako su različiti naši grijesi od Božjega milostivog dara! Jer taj jedan čovjek, Adam, svojim je grijehom mnogima donio smrt. Ali zato se na mnoge obilno izlila Božja milost oproštenja grijeha, darovana po jednome čovjeku—Isusu Kristu. ");
INSERT INTO hrvbib_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","S darom Božje milosti nije kao s posljedicama grijeha jednoga čovjeka—jer presuda nad Adamovim grijehom postala je osudom nad svima, a dar Božjega oproštenja nam je—nakon mnogih grijeha koje smo počinili—postao opravdanjem. ");
INSERT INTO hrvbib_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Jer Adamovim je grijehom kroz jednog čovjeka nad nama zakraljila smrt, ali koji prime izobilni milosni dar pravednosti, živjet će u pobjedi nad grijehom i smrću—po jednome Čovjeku, Isusu Kristu. ");
INSERT INTO hrvbib_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Prema tome, kao što je grijehom jednoga došla osuda na sve ljude, tako su pravednošću Jednoga na sve došli opravdanje i život. ");
INSERT INTO hrvbib_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Baš kao što su zbog neposluha jednoga čovjeka mnogi postali grešnicima, tako će i zbog poslušnosti Jednoga mnogi postati pravednicima u Božjim očima. ");
INSERT INTO hrvbib_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Božji je Zakon dan ljudima da se umnoži grijeh. Ali kako su ljudi sve više i više griješili, Božja divna milost sve se obilnije izlijevala. ");
INSERT INTO hrvbib_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Baš kao što je grijeh nekada vladao nad svim ljudima i vodio ih u smrt, tako sada nad njima kraljuje Božja milost i opravdava ih pred Bogom da bi mogli imati vječni život po našemu Gospodinu Isusu Kristu. ");
INSERT INTO hrvbib_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Što reći? Zar da i dalje griješimo kako bi nam Bog mogao iskazivati sve više milosti praštanja? ");
INSERT INTO hrvbib_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Nipošto! Umrli smo grijehu, pa kako da onda i dalje živimo u njemu? ");
INSERT INTO hrvbib_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Ili ne znate da smo mi, koji smo krštenjem postali jedno s Kristom Isusom, i umrli skupa s njim? ");
INSERT INTO hrvbib_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Jer umrli smo i pokopani s Kristom u krštenju. I kao što je Krist ustao od mrtvih slavnom Očevom moći, tako i mi sada možemo živjeti novim životom. ");
INSERT INTO hrvbib_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Kao što smo s njim ujedinjeni u njegovoj smrti, također ćemo i uskrsnuti poput njega. ");
INSERT INTO hrvbib_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Naš je stari čovjek raspet s Isusom kako bi grijeh izgubio vlast nad našim životom. Više ne robujemo grijehu ");
INSERT INTO hrvbib_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","jer smo, umrijevši s Kristom, od grijeha opravdani. ");
INSERT INTO hrvbib_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","A budući da smo s Kristom umrli, znamo da ćemo s njime i živjeti, ");
INSERT INTO hrvbib_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","jer Krist je ustao od mrtvih i više nikad neće umrijeti. Nad njime smrt više nema nikakve moći. ");
INSERT INTO hrvbib_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Umro je jednom zauvijek da slomi moć grijeha, ali sada zauvijek živi Bogu na slavu. ");
INSERT INTO hrvbib_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Tako i vi sebe smatrajte mrtvima za grijeh, a živima Bogu na slavu kroz Isusa Krista. ");
INSERT INTO hrvbib_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Tako i vi: ne dopustite da grijeh i dalje gospodari vašim smrtnim tijelom i ne popuštajte grešnim željama. ");
INSERT INTO hrvbib_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Nemojte da koji ud vašega tijela postane oruđem zla tako što ćete ga uporabiti za grijeh. Umjesto toga se posve predajte Bogu jer ste dobili novi život. Neka cijelo vaše tijelo bude oruđe koje će činiti dobro Bogu na slavu. ");
INSERT INTO hrvbib_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Grijeh više neće nad vama gospodariti jer više niste podložni Zakonu koji vas čini robovima grijeha. Oslobođeni ste Božjom milošću! ");
INSERT INTO hrvbib_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Ako nas je Božja milost oslobodila Zakona, znači li to da i dalje možemo griješiti? Nipošto! ");
INSERT INTO hrvbib_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Ne shvaćate li da sami birate sebi gospodara? Možete izabrati grijeh, koji vodi u smrt, ili možete izabrati poslušnost Bogu i da vas on prihvati kao pravedne. ");
INSERT INTO hrvbib_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Hvala Bogu! Nekoć ste bili robovi grijehu, ali sada ste svim srcem prihvatili novo učenje koje vam je Bog dao. ");
INSERT INTO hrvbib_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Slobodni ste od grijeha kojemu ste prije služili i postali ste robovima pravednosti. ");
INSERT INTO hrvbib_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Govorim vam služeći se prispodobom o robovima i gospodarima jer je to lako razumjeti. Prije ste bili robovi nečistoće i bezakonja. Sada budite robovi pravednosti da biste bili sveti. ");
INSERT INTO hrvbib_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Dok ste bili robovi grijeha, bili ste slobodni od pravednosti. ");
INSERT INTO hrvbib_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","A čime je to urodilo? Ne dobrim, jer se sada sramite onoga što ste činili, što vodi u vječnu smrt. ");
INSERT INTO hrvbib_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Ali sada ste oslobođeni od snage grijeha i postali ste Božjim robovima te činite ono što vodi svetosti i vječnome životu. ");
INSERT INTO hrvbib_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Jer plaća za grijeh je smrt, a Božji je dar vječni život u našemu Gospodinu Isusu Kristu. ");
INSERT INTO hrvbib_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Ne znate li, braćo—govorim poznavateljima Zakona—da je čovjek podložan zakonskim odredbama samo za života? ");
INSERT INTO hrvbib_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Da pojasnim: udanu ženu Zakon veže za muža dok je on živ. Ali ako on umre, zakon o braku više se na nju ne odnosi. ");
INSERT INTO hrvbib_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Kad bi se udala za drugoga za muževa života, počinila bi preljub. Ali ako joj muž umre, taj ju zakon više ne obvezuje i ne čini preljub ako se uda. ");
INSERT INTO hrvbib_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Tako ni vas, draga braćo, Zakon više ne obvezuje jer ste umrli njegovoj vlasti kad ste s Kristom umrli na križu. Sada ste ujedinjeni s njim koji je uskrsnuo od mrtvih. Zato možete roditi dobrim rodom, to jest dobrim djelima za Boga. ");
INSERT INTO hrvbib_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Dok je nama još vladala naša stara narav, Zakon je u nama budio grešne želje koje su rodile zlim djelima i donosile smrt. ");
INSERT INTO hrvbib_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Ali sada smo oslobođeni Zakona jer smo umrli s Kristom i nismo više pod zakonskom stegom. Sada zaista možemo služiti Bogu—ne više na stari način, držeći se slova Zakona, nego na novi način—po Duhu. ");
INSERT INTO hrvbib_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Znači li to da je Zakon grešan? Nipošto! Nije grešan, nego me je upozorio na moj grijeh. Nikada ne bih spoznao da je požuda zlo da Zakon nije rekao: “Ne poželi!” ");
INSERT INTO hrvbib_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Ali grijeh je iskoristio priliku zbog Zakona i pobudio u meni svakovrsne zabranjene želje. A bez Zakona grijeh ne bi imao takvu moć. ");
INSERT INTO hrvbib_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Nekoć nisam razumio što Zakon zahtijeva. Ali kad sam spoznao istinu, grijeh oživje ");
INSERT INTO hrvbib_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","i znao sam da sam bio grešnik osuđen na smrt. Tako me je dobar Zakon, koji mi je trebao pokazati put života, umjesto toga osudio na smrt. ");
INSERT INTO hrvbib_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Grijeh je iskoristio Zakon da me prevari; poslužio se dobrim Zakonom da me učini osuđenikom na smrt. ");
INSERT INTO hrvbib_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Pa ipak, Zakon je svet, pravedan i dobar. ");
INSERT INTO hrvbib_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Kako je to moguće? Zar me je dobri Zakon natjerao u smrt? Nipošto! Grijeh je iskoristio to što je dobro da na mene navuče smrtnu osudu. Grijeh je dakle najveće zlo: koristi dobre Božje zapovijedi u zle svrhe. ");
INSERT INTO hrvbib_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Zakon je dakle dobar, duhovan. Problem nije u Zakonu, nego u meni jer robujem tjelesnim željama—prodan sam grijehu kao gospodaru. ");
INSERT INTO hrvbib_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Ne mogu sebe razumjeti: zaista želim činiti dobro, ali ne činim ga. Umjesto toga činim baš ono što mrzim. ");
INSERT INTO hrvbib_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","A to što jako dobro znam da je ono što činim loše, samo pokazuje kako priznajem da je Zakon dobar. ");
INSERT INTO hrvbib_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Ali ne mogu sebi pomoći jer me grijeh u meni tjera da činim zlo. ");
INSERT INTO hrvbib_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Znam da nema dobra u meni, to jest u mojoj grešnoj ljudskoj naravi. Sposoban sam htjeti dobro, ali ne i činiti ga. ");
INSERT INTO hrvbib_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Dobro koje bih htio činiti ne činim, a zlo koje ne bih htio činiti ipak činim. ");
INSERT INTO hrvbib_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Ali ako činim ono što ne želim, onda to zapravo i ne činim ja, nego grijeh koji je u meni. ");
INSERT INTO hrvbib_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Zaključujem dakle da vrijedi pravilo: kad želim činiti dobro, nameće mi se zlo. ");
INSERT INTO hrvbib_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Svim svojim nutarnjim bićem uživam u poslušnosti Božjemu Zakonu. ");
INSERT INTO hrvbib_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","Ali još jedan zakon, koji se bori protiv mojega uma, djeluje u mojim udovima i zarobljuje me grijehom koji je još u njima. ");
INSERT INTO hrvbib_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Bijedna li mene! Tko će me osloboditi od ovoga smrtonosnog tijela, od života u vlasti grijeha? ");
INSERT INTO hrvbib_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Hvala Bogu! To čini Isus Krist, naš Gospodin. Umom dakle želim služiti Božjemu Zakonu, ali zbog grešne naravi svojega tijela robujem zakonu grijeha. ");
INSERT INTO hrvbib_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Nema dakle nikakve osude za one koji pripadaju Kristu Isusu. ");
INSERT INTO hrvbib_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Jer zakon Duha, koji daje život, oslobodio nas je zakona grijeha, koji vodi u smrt. ");
INSERT INTO hrvbib_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Jer ono što Zakon, oslabljen grešnim tijelom, nije mogao učiniti, učinio je Bog poslavši svojeg Sina u obličju tjelesnog čovjeka da bude žrtva za grijehe. Tako je osudio grijeh u tijelu. ");
INSERT INTO hrvbib_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Učinio je to zato da bi se pravednost Zakona potpuno ispunila u nama koji više ne živimo po staroj grešnoj naravi, nego po Duhu. ");
INSERT INTO hrvbib_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Oni kojima vlada grešna narav razmišljaju o onomu što je grešno, ali oni koji su pod nadzorom Božjega Duha razmišljaju o onomu što je ugodno Duhu. ");
INSERT INTO hrvbib_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Nadzire li vaša grešna narav vaš um, vodi vas u smrt. Ali ako vaš um nadzire Sveti Duh, imat ćete život i mir. ");
INSERT INTO hrvbib_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Jer grešna tjelesna narav u nama protivi se Bogu. Nikada nije bila pokorna Božjemu Zakonu niti će to ikada biti. ");
INSERT INTO hrvbib_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Zato oni kojima još vlada njihova grešna narav ne mogu ugoditi Bogu. ");
INSERT INTO hrvbib_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Ali vama više ne vlada grešna narav. Pod nadzorom ste Svetoga Duha ako Božji Duh zaista prebiva u vama. A u kome ne prebiva Kristov Duh, taj i nije Kristov. ");
INSERT INTO hrvbib_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Ako je Krist u vama, tijelo vam je mrtvo za grijeh, ali Duh živi u vama zato što vas je Bog opravdao. ");
INSERT INTO hrvbib_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Živi li u vama Božji Duh koji je Isusa uskrsnuo od mrtvih, Bog koji je Isusa podignuo od mrtvih oživjet će i vaša smrtna tijela tim istim Duhom koji u vama živi. ");
INSERT INTO hrvbib_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Zato, draga braćo, nismo dužni činiti ono na što nas tjera naša grešna narav. ");
INSERT INTO hrvbib_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Jer ako živite slušajući tu svoju tjelesnu narav, propast ćete. Ako pak silom Duha usmrćujete nju i njezina zla djela, živjet ćete. ");
INSERT INTO hrvbib_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Svi koje vodi Božji Duh Božja su djeca. ");
INSERT INTO hrvbib_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Ne budite zato poput strašljivih robova te svoje naravi. Budite prava Božja djeca jer vas je Bog svojim Duhom posinio te mu sada možete radosno klicati: “Abba! Oče!” ");
INSERT INTO hrvbib_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Sveti Duh govori nam duboko u srcima da smo Božja djeca. ");
INSERT INTO hrvbib_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","A kako smo njegova djeca, njegovi smo baštinici—jer sve što Bog daje svojemu Sinu, Kristu, to i nama pripada. Kao što s njim trpimo, s njim ćemo se i proslaviti. ");
INSERT INTO hrvbib_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Ali naše sadašnje patnje nisu ništa prema budućoj slavi koja će se očitovati u nama. ");
INSERT INTO hrvbib_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Jer sve stvorenje sa žudnjom iščekuje da dođe dan kad će Bog pokazati tko su zaista njegova djeca. ");
INSERT INTO hrvbib_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Sve što je na zemlji stvoreno postalo je jalovim, ne vlastitom, nego Božjom voljom—ali u nadi ");
INSERT INTO hrvbib_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","da će biti oslobođeno od robovanja pokvarljivosti, da sudjeluje u slobodi i u slavi Božje djece. ");
INSERT INTO hrvbib_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Jer znamo da cjelokupno stvorenje sve dosad uzdiše i muči se u porođajnim bolima. ");
INSERT INTO hrvbib_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Čak i mi kršćani, iako je u nama Sveti Duh kao predukus buduće slave, također stenjemo čekajući posinjenje, otkupljenje našega tijela. ");
INSERT INTO hrvbib_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Tom smo nadom spašeni. Ako nešto već imamo, onda se tomu više ne trebamo nadati. ");
INSERT INTO hrvbib_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Ali ako se nadamo nečemu što još nemamo, valja čekati strpljivo i postojano. ");
INSERT INTO hrvbib_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Isto tako, Sveti Duh nam pomaže u našoj slabosti. Jer mi ne znamo ni kako ni što bismo trebali moliti, ali Sveti Duh moli se za nas uzdasima koji se ne mogu riječima izraziti. ");
INSERT INTO hrvbib_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","A Onaj, koji poznaje svačije srce, poznaje naum Duha, jer on se moli za nas u skladu s Božjom voljom. ");
INSERT INTO hrvbib_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Znamo kako Bog čini da sve pridonosi dobru onih koji njega vole i koje je on pozvao prema svojoj nakani. ");
INSERT INTO hrvbib_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Jer Bog je svoj narod unaprijed poznavao i odabrao ih je da budu poput njegova Sina, tako da bi njegov Sin mogao biti prvorođenac s brojnom braćom i sestrama. ");
INSERT INTO hrvbib_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","A kad ih je odabrao, pozvao ih je k sebi. Zatim ih je opravdao i obećao im svoju slavu. ");
INSERT INTO hrvbib_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Što na sve to reći? Ako je Bog za nas, tko će biti protiv nas? ");
INSERT INTO hrvbib_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Kad već nije poštedio ni vlastitoga Sina, nego ga je predao za nas, neće li nam Bog, koji nam je dao Krista, s njime dati i sve drugo? ");
INSERT INTO hrvbib_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Tko će optužiti Božje izabranike? Nas Bog opravdava. ");
INSERT INTO hrvbib_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Tko će nas onda optužiti? Isus Krist je umro, štoviše, i uskrsnuo; on sjedi na počasnome mjestu, Bogu zdesna, i posreduje za nas. ");
INSERT INTO hrvbib_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Tko će nas odvojiti od Kristove ljubavi? Može li u tome uspjeti nevolja? Tjeskoba? Progonstvo? Glad? Golotinja? Pogibao? Mač? ");
INSERT INTO hrvbib_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","U Svetome pismu piše: “Zbog tebe nas ubijaju dan za danom; mi smo im kao ovce za klanje.” ");
INSERT INTO hrvbib_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Nadmoćno pobjeđujemo sve što nas snađe u Kristu koji nas voli. ");
INSERT INTO hrvbib_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Čvrsto vjerujem da nas ni smrt, ni život, ni anđeli ni demoni, ni sadašnjost ni budućnost, ni sile, ");
INSERT INTO hrvbib_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","ni visina, ni dubina, ni bilo koje stvorenje neće moći rastaviti od ljubavi Božje objavljene u našemu Gospodinu Kristu Isusu. ");
INSERT INTO hrvbib_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","U nazočnosti Kristovoj govorim istinu—ne lažem—a moja savjest i Sveti Duh potvrđuju da je ovo što govorim istina. ");
INSERT INTO hrvbib_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","Srce mi je ispunjeno silnom tugom i beskrajnom boli ");
INSERT INTO hrvbib_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","zbog mojeg naroda, zbog moje židovske braće i sestara. Pristao bih biti zauvijek proklet—odsječen od Krista!—kad bi to njih moglo spasiti. ");
INSERT INTO hrvbib_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Oni su izabrani izraelski narod, izabrani da budu posebna Božja djeca. Bog im je objavio svoju slavu. Sklopio je s njima savez i dao im svoj Zakon. Imaju povlasticu da ga štuju i da primaju njegova divna obećanja. ");
INSERT INTO hrvbib_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Njihovi su preci bili veliki Božji ljudi, a i sam je Krist bio Židov po tjelesnom podrijetlu. A on je Bog koji vlada nad svime i dostojan je vječne slave! Amen. ");
INSERT INTO hrvbib_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Zar je Bog prekršio svoja obećanja? Nije. Jer nisu Izrael svi koji potječu od Izraela. ");
INSERT INTO hrvbib_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","Sama činjenica da potječu od Abrahama ne čini ih pravom Abrahamovom djecom. Jer u Svetome pismu piše: “Po Izaku će ti se nazivati potomstvo” —iako je Abraham imao još djece. ");
INSERT INTO hrvbib_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","To znači da nisu svi Abrahamovi tjelesni potomci ujedno i Božja djeca. Samo djeca obećanja su Božja djeca. ");
INSERT INTO hrvbib_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Jer Bog je obećao: “Nagodinu ću opet doći i Sara će imati sina.” ");
INSERT INTO hrvbib_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Taj je sin bio naš predak Izak. Njegova žena Rebeka nosila je blizance. ");
INSERT INTO hrvbib_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","Ali prije nego što su rođeni, prije nego što su učinili išta dobro ili zlo, primila je poruku od Boga. Ta je poruka dokaz da Bog bira prema vlastitom naumu, a ne prema našim dobrim ili lošim djelima. ");
INSERT INTO hrvbib_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","Rekao joj je: “Potomci tvojega starijeg sina služit će potomcima mlađega.” ");
INSERT INTO hrvbib_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","Ili, riječima Svetoga pisma: “Jakova sam zavolio, a Ezav mi omrznu.” ");
INSERT INTO hrvbib_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Zar je Bog bio nepravedan? Nipošto. ");
INSERT INTO hrvbib_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Jer Mojsiju je rekao: “Smilovat ću se komu se želim smilovati i sažalit ću se nad kime se želim sažaliti.” ");
INSERT INTO hrvbib_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Zato ne ovisi o nama hoćemo li primiti Božje obećanje. Ne možemo ga dobiti svojom voljom ili teškim trudom. Bog će se smilovati kome bude htio. ");
INSERT INTO hrvbib_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","U Svetome pismu piše da je Bog kazao faraonu: “Postavio sam te za vladara zato da na tebi pokažem svoju moć i da se moje ime razglasi po svoj zemlji.” ");
INSERT INTO hrvbib_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Bog se dakle nekima smiluje samo zato što tako želi, a čini i da nekima srce otvrdne. ");
INSERT INTO hrvbib_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Mogli biste pitati: “Zašto onda Bog okrivljuje ljude da nisu poslušni? Ne postupaju li oni samo kako im je on odredio?” ");
INSERT INTO hrvbib_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","No nemojte tako govoriti. Tko ste vi, obični ljudi, da prigovarate Bogu? Zar da stvorenje pita stvoritelja: “Zašto si me učinio ovakvim?”? ");
INSERT INTO hrvbib_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Kada lončar od istoga grumena gline načini vrčeve, nema li pravo jedan od njih namijeniti plemenitoj, a drugi neplemenitoj uporabi? ");
INSERT INTO hrvbib_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","Pa što ako je Bog, odabravši pokazati svoj gnjev i moć, s velikim strpljenjem podnosio one koji su izazvali njegov gnjev i bili spremni za uništenje? ");
INSERT INTO hrvbib_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","Što ako je to učinio kako bi onima kojima iskazuje milost i koje je unaprijed pripremio za slavu, pokazao bogatstvo svoje slave— ");
INSERT INTO hrvbib_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","pa tako i nama, koje je pozvao ne samo od Židova već i od pogana. ");
INSERT INTO hrvbib_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Kao što piše u Knjizi proroka Hošee: “One koji nisu moj narod prozvat ću svojim narodom i voljet ću one koje prije nisam volio.” ");
INSERT INTO hrvbib_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","I još: “Jednom im je rečeno: ‘Vi niste moj narod.’ Ali sada će im se reći: ‘Vi ste djeca živoga Boga.’” ");
INSERT INTO hrvbib_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Za Izrael, opet, Izaija kaže: “Iako je izraelski narod brojan kao zrnca morskog pijeska, samo će se mali broj spasiti. ");
INSERT INTO hrvbib_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","Jer Gospodin Bog će potpuno i brzo ostvariti svoju riječ i kaznom poharati zemlju.” ");
INSERT INTO hrvbib_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Na drugome mjestu Izaija kaže: “Da Svemogući Gospodin nije poštedio nas nekolicinu, bili bismo posve zatrti, poput Sodome i Gomore.” ");
INSERT INTO hrvbib_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Što reći o svemu tome? Pogani su pred Bogom opravdani po vjeri iako nisu iskali pravednost. ");
INSERT INTO hrvbib_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","A Izraelci koji su se toliko trudili opravdati pred Bogom ispunjavanjem Zakona nisu u tome uspjeli. ");
INSERT INTO hrvbib_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Zašto? Zato što su pokušavali pred Bogom postignuti pravednost ispunjavajući zakonske odredbe i čineći dobra djela, a ne vjerom. Spotaknuli su se o “kamen spoticanja”. ");
INSERT INTO hrvbib_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","A Bog ih je opomenuo u Svetome pismu: “Evo, postavljam na Sionu kamen spoticanja i stijenu posrtanja. Ali tko u njega vjeruje, neće se postidjeti.” ");
INSERT INTO hrvbib_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Draga braćo, želja je mojega srca i moja molitva Bogu da se svi Židovi spase. ");
INSERT INTO hrvbib_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Svjedok sam njihova revnovanja za Boga, ali ono se ne temelji na pravom razumijevanju ");
INSERT INTO hrvbib_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","jer ne shvaćaju na koji način Bog opravdava ljude. Umjesto toga drže se vlastitih običaja i nastoje se pred Bogom opravdati vršeći Zakon—te se tako odbijaju podložiti Božjoj volji. ");
INSERT INTO hrvbib_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Jer Krist je u potpunosti ispunio svrhu Zakona. Tko vjeruje u njega, opravdan je pred Bogom. ");
INSERT INTO hrvbib_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","O pravednosti koja dolazi po Zakonu Mojsije piše: “Tko je vrši, u njoj će naći život.” ");
INSERT INTO hrvbib_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","A o pravednosti koja dolazi po vjeri kaže: “Nemoj se u srcu upitati: ‘Tko će uzići na nebo’” (da dovede Krista), ");
INSERT INTO hrvbib_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","“niti: ‘Tko će sići u bezdan’” (da dovede Krista od mrtvih)? ");
INSERT INTO hrvbib_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Što to zapravo znači? “Riječ je sasvim blizu tebe, u tvojim ustima i u tvojem srcu.” To je riječ vjere koju propovijedamo. ");
INSERT INTO hrvbib_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","Jer ako ustima priznaješ da je Isus Krist Gospodin i ako u srcu vjeruješ da ga je Bog uskrisio od mrtvih, bit ćeš spašen. ");
INSERT INTO hrvbib_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Naime, vjera u srcu nas opravdava, a priznanje usnama spašava. ");
INSERT INTO hrvbib_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Jer u Svetome pismu piše: “Tko u njega vjeruje, neće se postidjeti.” ");
INSERT INTO hrvbib_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","To vrijedi za Židove, kao i za ostale ljude: svi imaju istoga Gospodina, koji izobilno daje svoja bogatstva svima koji ga zazivaju. ");
INSERT INTO hrvbib_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","Jer “Tko god zazove ime Gospodnje, bit će spašen.” ");
INSERT INTO hrvbib_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Ali kako će ga zazvati da ih spasi ako u njega ne vjeruju? A kako će u njega vjerovati ako nikada nisu za njega čuli? A kako će čuti za njega ako im nitko o njemu ne propovijeda? ");
INSERT INTO hrvbib_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","A kako će im tko propovijedati ako nije poslan da propovijeda? O tomu Sveto pismo kaže: “Kako su divne noge onih koji donose Radosnu vijest!” ");
INSERT INTO hrvbib_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Ali svatko tko čuje Radosnu vijest neće ju i prihvatiti. Izaija je o tome rekao: “Gospodine, tko je povjerovao našoj poruci?” ");
INSERT INTO hrvbib_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Vjera dakle dolazi upravo slušanjem Radosne vijesti o Kristu. ");
INSERT INTO hrvbib_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Ali što je sa Židovima? Jesu li oni zapravo čuli tu poruku? Jesu: “Poruka o Božjemu stvaranju raširila se po svoj zemlji, a njezine riječi sežu do kraja svijeta.” ");
INSERT INTO hrvbib_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Ali, ja pitam: Jesu li Izraelci zaista razumjeli? Jesu, jer je još u Mojsijevo vrijeme Bog rekao: “Učinit ću vas ljubomornima blagoslivljajući druge narode. Razgnjevit ću vas blagoslivljajući nerazumne pogane.” ");
INSERT INTO hrvbib_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Poslije je Izaija u Božje ime hrabro rekao: “Našli su me oni koji me nisu tražili. Objavio sam se onima koji me to nisu molili.” ");
INSERT INTO hrvbib_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","A za Izrael je Bog rekao: “Svagda sam pružao ruke nepokornom i buntovnom narodu.” ");
INSERT INTO hrvbib_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Pitam, dakle, nije li Bog odbacio svoj narod? Nipošto! Sjetite se da sam i ja Izraelac, Abrahamov potomak, iz Benjaminova plemena. ");
INSERT INTO hrvbib_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Nije Bog odbacio svoj narod koji je unaprijed izabrao. Zar se ne sjećate što o tome kaže Sveto pismo? Prorok Ilija žalio se Bogu na Izraelce: ");
INSERT INTO hrvbib_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","“Gospodine, poubijali su tvoje proroke i srušili tvoje oltare. Samo sam ja ostao, a sada i mene pokušavaju ubiti.” ");
INSERT INTO hrvbib_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Sjećate li se što mu je Bog odgovorio? “Nisi ti jedini ostao. Imam ih još sedam tisuća koji se nikada nisu poklonili Baalu.” ");
INSERT INTO hrvbib_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","I danas je tako. Nisu svi Židovi otišli od Boga. Nekolicina ih je spašena po Božjoj milosti jer ih je odabrao. ");
INSERT INTO hrvbib_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","A ako su spašeni Božjom milošću, onda nisu spašeni zbog svojih dobrih djela. Inače Božja milost ne bi bila to što jest—darovana i nezaslužena. ");
INSERT INTO hrvbib_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Većina Izraelaca dakle nije postignula Božju naklonost koju je tražila. Nekolicina koju je izabrao dobila ju je, a ostali su pak otvrdnuli. ");
INSERT INTO hrvbib_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","Kao što kaže Sveto pismo: “Bog je učinio da obamru. Do današnjeg dana zatvorio im je oči da ne vide i zatvorio im je uši da ne čuju.” ");
INSERT INTO hrvbib_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","Kralj David o tomu je također rekao: “Neka padnu u zamku, u mrežu i stupicu svoje obilne gozbe i neka ih tako stigne njihova plaća. ");
INSERT INTO hrvbib_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Neka im oči potamne da obnevide; zauvijek im pogni leđa!” ");
INSERT INTO hrvbib_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Jesu li dakle tako posrnuli da će neizbježno otići u propast? Nipošto! Božja je nakana bila da spasenje učini dostupno poganima kako bi Židove učinio ljubomornima i naveo ih da ga požele za sebe. ");
INSERT INTO hrvbib_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Pa ako su Židovi, posrnuvši i odbivši spasenje, donijeli drugim narodima toliko bogatstvo, pomislite samo koliki će tek blagoslov svijet podijeliti s njima kada jednog dana prihvate spasenje! ");
INSERT INTO hrvbib_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Govorim to posebice zaradi vas pogana. Bog me je imenovao apostolom poganima i to uvijek ističem ");
INSERT INTO hrvbib_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","ne bih li svoj narod naveo da požele to što imate vi pogani i ne bi li se neki od njih tako spasili. ");
INSERT INTO hrvbib_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Jer ako je Bog, kad su Židovi odbili spasenje, ponudio to spasenje cijelome svijetu, kako li će tek divno biti kad ga oni prihvate! Mrtvi će oživjeti! ");
INSERT INTO hrvbib_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","Abraham i ostali patrijarsi bili su sveti, pa će i njihovi potomci biti sveti. Jer ako je korijen stabla svet, svete su i grane. ");
INSERT INTO hrvbib_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Ali neki Židovi, Abrahamove grane, odlomljeni su. A vi pogani, nekoć grane divlje masline, pricijepljeni ste. Tako sada primate blagoslov koji je Bog obećao Abrahamu i njegovim potomcima i hranite se sokovima Božje masline. ");
INSERT INTO hrvbib_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","Ali pazite da se ne hvalite kako ste pricijepljeni umjesto odlomljenih grana. Upamtite da ste samo grane, a ne korijenje. ");
INSERT INTO hrvbib_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","“Ali te su grane odlomljene da bi bilo mjesta za mene”, reći ćete. ");
INSERT INTO hrvbib_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Jesu, ali upamtite: te su grane, Židovi, odlomljene zato što nisu vjerovali Bogu, a vi ste pricijepljeni zato što vjerujete. Nemojte se uznositi, već se bojte onoga što bi se moglo dogoditi. ");
INSERT INTO hrvbib_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","Jer ako Bog nije poštedio one prve grane, neće ni tebe poštedjeti. ");
INSERT INTO hrvbib_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Vidite li kako je Bog dobar i strog? Strog prema neposlušnima, a dobar prema vama koji se pouzdajete u njegovu dobrotu. Ali prestanete li se u nju pouzdavati, i vi ćete biti odsječeni. ");
INSERT INTO hrvbib_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","A odustanu li Židovi od svoje nevjere, Bog će i njih ponovno pricijepiti. On ima moć da to učini. ");
INSERT INTO hrvbib_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Jer ako je Bog htio uzeti vas, koji ste po svojoj naravi grane divlje masline, i pricijepiti vas na dobro drvo, koliko će radije pricijepiti Židove na drvo kojemu pripadaju! ");
INSERT INTO hrvbib_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Želio bih, draga braćo, da razumijete ovu tajnu kako se ne biste uzoholili i počeli se hvastati. Neki su Židovi tvrda srca, ali to će trajati samo dok Krista ne prihvati puni broj pogana. ");
INSERT INTO hrvbib_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","Nakon toga će se spasiti sav Izrael. Sjećate li se što su o tomu rekli proroci: “Sa Siona će doći Izbavitelj; odvratit će od bezbožnosti sve Židove. ");
INSERT INTO hrvbib_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","A ja ću ispuniti svoj savez s njima kad uklonim njihove grijehe.” ");
INSERT INTO hrvbib_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","Mnogi su Židovi sada protivnici evanđelja. Ali to je vama na dobrobit jer je Bog dao svoje darove vama poganima. Pa ipak, Židovi su još izabrani narod zbog Božjih obećanja danih Abrahamu, Izaku i Jakovu. ");
INSERT INTO hrvbib_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Jer Božji darovi i pozvanje ne mogu se opozvati. ");
INSERT INTO hrvbib_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Nekoć ste vi pogani bili buntovnici protiv Boga, ali kad su Židovi odbacili njegovu milost, Bog ju je umjesto njima darovao vama. ");
INSERT INTO hrvbib_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","Sada su pak tako Židovi buntovnici, a vi imate Božju milost. Ali jednog će dana i oni biti dionicima Božje milosti. ");
INSERT INTO hrvbib_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Jer Bog je sve ljude zatvorio u njihovoj neposlušnosti da se svima smiluje. ");
INSERT INTO hrvbib_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","Kakvoga divnog Boga imamo! Kako su veliki njegovo bogatstvo, mudrost i znanje! Nedokučivi su nam njegovi sudovi i neistraživi njegovi putovi! ");
INSERT INTO hrvbib_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","Zaista, “tko poznaje Gospodnje misli, tko mu je bio savjetnikom?” ");
INSERT INTO hrvbib_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","Ili, “tko je njemu prvi nešto dao da bi mu morao uzvratiti?” ");
INSERT INTO hrvbib_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Jer sve dolazi od njega, sve postoji po njemu i za njega. Neka mu je vječna slava! Amen. ");
INSERT INTO hrvbib_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","Zaklinjem vas, draga braćo, milosrđem Božjim da predate svoja tijela Bogu. Neka ona budu živa, sveta žrtva—njemu ugodna—da to bude vaša duhovna služba Bogu. ");
INSERT INTO hrvbib_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","Ne oponašajte ponašanje i običaje ovoga svijeta, već dopustite da vas Bog promijeni u novu osobu mijenjajući vaš način razmišljanja. Tada ćete znati što Bog želi da činite, što je njemu dobro, ugodno i savršeno. ");
INSERT INTO hrvbib_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","Kao Božji poslanik upozoravam svakoga od vas: ne precjenjujte se! Cijenite sebe razborito, prema mjeri vjere koju vam je Bog dao. ");
INSERT INTO hrvbib_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","Baš kao što naša tijela imaju mnogo udova, a svaki od njih svoju zadaću, ");
INSERT INTO hrvbib_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","tako je i s Kristovim tijelom. Svi smo mi udovi njegova tijela i svatko treba obavljati različitu zadaću. A kako smo u Kristu jedno tijelo, pripadamo jedni drugima i svatko od nas treba sve druge. ");
INSERT INTO hrvbib_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","Bog je svakome od nas dao sposobnost da neke zadaće dobro obavljamo. Zato, ako vam je Bog dao dar prorokovanja, govorite kada vjerujete da Bog govori kroz vas. ");
INSERT INTO hrvbib_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","Ako imate dar služiti drugima, svesrdno im služite. Ako ste učitelj, dobro poučavajte. ");
INSERT INTO hrvbib_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","Imate li dara da hrabrite druge, činite tako! Imate li novca, velikodušno ga dijelite. Ako vam je Bog dao sposobnost vodstva, ozbiljno shvaćajte svoju odgovornost. Imate li dar milosrđa, radosno ga iskazujte! ");
INSERT INTO hrvbib_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","Nemojte se samo pretvarati da volite ljude. Iskreno ih volite. Mrzite zlo. Zalažite se za dobro! ");
INSERT INTO hrvbib_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","Iskreno se volite i neka vam bude ugodno da jedni drugima iskazujete poštovanje. ");
INSERT INTO hrvbib_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","Ne budite lijeni, već revno i gorljivo služite Gospodinu! ");
INSERT INTO hrvbib_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","Radosno se nadajte svemu što vam je Bog namijenio. U nevolji budite strpljivi, u molitvi ustrajni. ");
INSERT INTO hrvbib_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","Pritječite u pomoć svetima koji su u potrebi i uvijek budite gostoljubivi! ");
INSERT INTO hrvbib_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","Progone li vas zato što ste Kristovi, ne proklinjite ih, nego se molite da ih Bog blagoslovi. ");
INSERT INTO hrvbib_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","Radujte se sa sretnima i plačite s ožalošćenima. ");
INSERT INTO hrvbib_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","Živite u slozi. Ne težite za visokim, nego budite skromni. Ne umišljajte sebi da ste mudri. ");
INSERT INTO hrvbib_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","Nikada nikome ne vraćajte zlo za zlo. Sve što činite, činite zalažući se za dobro. ");
INSERT INTO hrvbib_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","Trudite se da, ako je moguće, živite u miru sa svima. ");
INSERT INTO hrvbib_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","Dragi moji, nikada se ne osvećujte. Prepustite to Bogu jer u Svetome pismu piše: “‘Osveta je moja; ja ću vratiti onima koji to zaslužuju’, veli Gospodin.” ");
INSERT INTO hrvbib_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","Naprotiv, “Ako ti je neprijatelj gladan, nahrani ga. ako je žedan, daj mu piti. Postupajući tako, zgrnut ćeš goruću žeravicu na njegovu glavu.” ");
INSERT INTO hrvbib_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","Ne daj te svlada zlo, nego zlo svladavaj dobrim. ");
INSERT INTO hrvbib_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","Budite poslušni vlastima jer ih je Bog postavio. Nema te vlasti koju nije Bog postavio. ");
INSERT INTO hrvbib_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","Zato tko se suprotstavlja zakonima neke zemlje, suprotstavlja se Božjoj odredbi te sam na sebe navlači osudu. ");
INSERT INTO hrvbib_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","Jer vlasti se ne boje ljudi koji čine dobro, nego oni koji čine zlo. Ako se ne želiš bojati vlasti, čini dobro pa ćeš od njih dobiti i pohvalu. ");
INSERT INTO hrvbib_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","Vlasti nam je Bog dao da nam budu od pomoći. Zato se boj ako činiš zlo jer one služe da kazne ljude koji gnjeve Boga time što čine zlo. ");
INSERT INTO hrvbib_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","Zato im budi poslušan da ne budeš kažnjen i da ti savjest bude čista. ");
INSERT INTO hrvbib_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","Zato i poreze plaćajte jer službenici vlasti obavljaju posao koji im je Bog namijenio. ");
INSERT INTO hrvbib_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","Svakome dajte što mu dugujete: poreznicima porez, carinicima carinu, a poštovanje i čast ljudima kojima ih dugujete. ");
INSERT INTO hrvbib_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","Ne ostajte nikome dužni osim da volite jedni druge. Taj dug nikada ne možete potpuno isplatiti. Volite li bližnje, ispunit ćete sve odredbe Zakona. ");
INSERT INTO hrvbib_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","Zaista, “Ne učini preljub”, “Ne ubij”, “Ne ukradi”, “Ne poželi” i ima li još koja zapovijed, sadržana je u ovim riječima: “Ljubi svojega bližnjega kao samoga sebe!” ");
INSERT INTO hrvbib_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","Ljubav prema bližnjemu ne čini zla. Ona potpuno ispunjava sve Božje odredbe. ");
INSERT INTO hrvbib_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","Još jedan razlog da živite kako valja je taj što znate da vrijeme istječe. Probudimo se jer nam je čas spasenja bliže nego kad smo uzvjerovali. ");
INSERT INTO hrvbib_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","Noć je gotovo na izmaku, dan spasenja se približio. Nemojmo zato živjeti u tami i ne činimo zla djela! Svucimo ih kao prljavu odjeću i odjenimo se u oklop pravednog života, živeći u svjetlosti. ");
INSERT INTO hrvbib_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","Živimo pristojno kao ljudi koji žive na svjetlu dana—bez razuzdanih zabava i opijanja, bez preljuba i razvrata, bez svađe i ljubomore! ");
INSERT INTO hrvbib_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","Obucite se radije u Gospodina Isusa Krista i ne ugađajte požudama brinući se za tijelo. ");
INSERT INTO hrvbib_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","Prigrlite slaboga u vjeri i ne osuđujte ga zbog različitog mišljenja. ");
INSERT INTO hrvbib_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","Netko, primjerice, vjeruje da se smije jesti sve. Ali drugi će vjernik, osjetljive savjesti, jesti samo povrće. ");
INSERT INTO hrvbib_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","Oni koji smatraju da se smije jesti sve ne smiju svisoka gledati na one druge. A oni koji ne jedu neke vrste hrane ne smiju osuđivati one koji jedu jer je njih Bog prigrlio. ");
INSERT INTO hrvbib_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","Tko si ti da osuđuješ tuđega slugu? On je odgovoran svojemu gospodaru, koji mu jedini može reći što smije, a što ne. I Gospodin će mu pomoći da čini kako valja. ");
INSERT INTO hrvbib_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","Slično tomu, neki ljudi smatraju neke dane svetijima od drugih, dok drugi sve dane drže jednakima. O tomu svatko treba imati svoje uvjerenje. ");
INSERT INTO hrvbib_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","Koji imaju poseban dan za bogoslužje, iskazuju čast Gospodinu. Koji jedu sve vrste hrane, čine tako da bi iskazali čast Gospodinu jer zahvaljuju Bogu prije jela. A oni koji ne jedu sve, također žele ugoditi Gospodinu i također zahvaljuju Bogu. ");
INSERT INTO hrvbib_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","Nismo mi sebi gospodarima ni dok živimo ni kad umiremo. ");
INSERT INTO hrvbib_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","Dok živimo, živimo za Gospodina, a kad umiremo, umiremo za Gospodina. Zato i u životu i u smrti pripadamo Gospodinu. ");
INSERT INTO hrvbib_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","Krist je umro i uskrsnuo upravo zato—da bude Gospodin i živima i mrtvima. ");
INSERT INTO hrvbib_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","Zašto osuđuješ svojeg brata? Ili zašto prezireš svojeg brata? Ta svi ćemo stati pred Božji sud ");
INSERT INTO hrvbib_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","jer u Svetome pismu piše: “‘Života mi mojega’, kaže Gospodin, ‘svako će se koljeno pognuti preda mnom i svaki će jezik priznati Boga.’” ");
INSERT INTO hrvbib_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","Svatko od nas će dakle za sebe položiti račun Bogu. ");
INSERT INTO hrvbib_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","Nemojmo stoga jedni druge osuđivati, nego živite tako da se braća zbog vas ne spotiču u vjeri. ");
INSERT INTO hrvbib_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","Znam i uvjeren sam u Gospodinu Isusu da nikakva hrana po sebi nije nečista. Ali vjeruje li tko da mu što nije dopušteno, onda nije dobro da to čini. ");
INSERT INTO hrvbib_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","Ako žalostiš svojega brata time što nešto jedeš, ne postupaš u ljubavi. Ne upropaštavaj zbog hrane onoga za koga je Krist umro ");
INSERT INTO hrvbib_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","da te ne pogrđuju što činiš ono za što znaš da je dobro. ");
INSERT INTO hrvbib_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","Jer Božje kraljevstvo nije u jelu i pilu, nego u pravednosti, miru i radosti u Svetome Duhu. ");
INSERT INTO hrvbib_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","Budete li tako služili Kristu, ugodit ćete Bogu, a i ljudi će vas cijeniti. ");
INSERT INTO hrvbib_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","Nastojmo živjeti u slozi i uzajamno se izgrađivati. ");
INSERT INTO hrvbib_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","Ne razarajte Božje djelo zbog hrane! Nije ona po sebi nečista, ali je zlo da ju jedete ako to koga tjera na spoticanje u vjeri. ");
INSERT INTO hrvbib_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","Dobro je ne jesti meso ili ne piti vino, ili ne činiti bilo što zbog čega bi se tvoj brat mogao spotaknuti. ");
INSERT INTO hrvbib_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","Ako si uvjeren da u tome što činiš nema ničega lošega, neka to ostane između tebe i Boga. Blago onomu koji sebe ne osuđuje zbog onoga na što se odlučio. ");
INSERT INTO hrvbib_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","Ali jede li tko a da nije siguran čini li grijeh, sam je sebe osudio jer ne postupa prema uvjerenju. Čini li tko ono za što nije siguran je li grijeh, griješi. ");
INSERT INTO hrvbib_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","Zato mi koji smo jaki u vjeri i čvrsta uvjerenja moramo nositi slabosti slabih i biti obzirni prema njima. Ne smijemo ih sablažnjavati onime što je nama slobodno samo zato da bismo sebi ugodili. ");
INSERT INTO hrvbib_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","Svatko od nas neka ugađa bližnjima na dobro, izgrađujući ih. ");
INSERT INTO hrvbib_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","Jer ni Krist nije sebi ugađao. Kao što piše u Svetome pismu: “Pogrde onih koji tebe ruže pale su na mene.” ");
INSERT INTO hrvbib_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","To je nekoć zapisano nama za pouku, da nas utješi i ohrabri u nadi. ");
INSERT INTO hrvbib_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","Neka vam Bog, koji daje strpljenje i ohrabrenje, pomogne da međusobno živite u potpunoj slozi i da jedni prema drugima postupate prema Kristovu uzoru. ");
INSERT INTO hrvbib_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","Tada ćete jednodušno moći slaviti Boga, Oca našega Gospodina Isusa Krista. ");
INSERT INTO hrvbib_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","Srdačno prigrlite jedni druge kao što je Krist vas prigrlio, Bogu na slavu. ");
INSERT INTO hrvbib_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","Jer, kažem vam da je Krist postao slugom Židovima da pokaže kako je Bog vjeran obećanjima koja je dao njihovim praocima. ");
INSERT INTO hrvbib_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","Došao je da također i pogani mogu proslaviti Boga zbog njegova milosrđa prema njima. Na to je psalmist mislio kad je napisao: “Slavit ću te među poganima i pjevati hvalospjeve tvojem imenu.” ");
INSERT INTO hrvbib_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","Na drugom pak mjestu kaže: “Radujte se, narodi, skupa s njegovim narodom!” ");
INSERT INTO hrvbib_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","I još: “Slavite Gospodina, svi puci; slavite ga, svi narodi na zemlji!” ");
INSERT INTO hrvbib_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","Prorok Izaija je napisao: “Pojavit će se Davidov nasljednik da vlada nad poganima. U njega će polagati svoje nade.” ");
INSERT INTO hrvbib_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","Neka vas Bog, koji daje nadu, ispuni radošću i mirom po vjeri u njega, da obilujete u nadi silom Svetoga Duha. ");
INSERT INTO hrvbib_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","Uvjeren sam, draga braćo, da ste puni čestitosti. Sve ovo vrlo dobro znate i sposobni ste jedni druge urazumljivati. ");
INSERT INTO hrvbib_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","Pa ipak sam uzeo tu slobodu da vas podsjetim na to što već znate. Jer Božjom milošću ");
INSERT INTO hrvbib_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","služim Isusu Kristu među poganima. Donosim Božje evanđelje kako bi pogani postali ugodnom žrtvom Bogu, posvećeni Svetim Duhom. ");
INSERT INTO hrvbib_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","Mogu se zato pohvaliti onime što je Isus Krist učinio kroz moju službu Gospodinu. ");
INSERT INTO hrvbib_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","Ničim se drugim ne usuđujem hvaliti osim onime što je Krist kroz moje propovijedanje i djela učinio za obraćenje pogana ");
INSERT INTO hrvbib_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","snagom čudesnih znakova, silom Božjega Duha. Tako sam potpuno ispunio svoju dužnost propovijedanja Radosne vijesti od Jeruzalema pa uokolo sve do Ilirika. ");
INSERT INTO hrvbib_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","Uvijek sam se trudio propovijedati Radosnu vijest gdje se Krist još nije spominjao, a ne gdje su već drugi položili temelj propovijedanju ");
INSERT INTO hrvbib_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","da se ostvari što piše u Svetome pismu: “Vidjet će ga oni kojima nije naviješten, razumjet će ga oni koji nikada nisu za njega čuli.” ");
INSERT INTO hrvbib_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","Zbog toga što sam ondje propovijedao, i nisam dosad mogao doći k vama. ");
INSERT INTO hrvbib_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","Ali sad sam završio s radom u tim krajevima, a već godinama žarko želim doći k vama. ");
INSERT INTO hrvbib_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","Kanim otići u Španjolsku, pa ću se na putu zaustaviti u Rimu. Pošto barem malo vremena provedem s vama, možete me opet otpraviti na put. ");
INSERT INTO hrvbib_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","Ali prije toga moram do Jeruzalema da svetima odnesem milodar ");
INSERT INTO hrvbib_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","jer su vjernici u Makedoniji i u Ahaji skupili pomoć za siromašne svete u Jeruzalemu. ");
INSERT INTO hrvbib_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","To su rado učinili jer se osjećaju njihovim dužnicima. Jer ako su pogani postali dionicima njihovih duhovnih dobara, onda su im dužni poslužiti i u tjelesnim dobrima. ");
INSERT INTO hrvbib_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","Čim im predam taj novac te tako dovršim njihovo dobro djelo, krenut ću u Španjolsku i usput doći k vama. ");
INSERT INTO hrvbib_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","Siguran sam da ću k vama stići s puninom Kristova blagoslova. ");
INSERT INTO hrvbib_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","Draga braćo, zaklinjem vas u imenu našega Gospodina Isusa Krista da mi se pridružite u borbi moleći se Bogu za mene, zbog ljubavi prema meni koju vam je dao Sveti Duh. ");
INSERT INTO hrvbib_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","Molite se da u Judeji umaknem nevjernicima i da svetima u Jeruzalemu bude po volji pomoć koju im nosim ");
INSERT INTO hrvbib_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","kako bih, po Božjoj volji, mogao radosno doći k vama i tu se odmoriti. ");
INSERT INTO hrvbib_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","Neka Bog, izvor mira, bude sa svima vama. Amen. ");
INSERT INTO hrvbib_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","Preporučam vam našu sestru Febu, koja služi Crkvi u Kenhreji, i ona će uskoro doći k vama. ");
INSERT INTO hrvbib_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","Primite ju u Gospodinu kako dolikuje svetima i pomozite joj u svemu što od vas zatreba jer je i ona pomogla mnogima, pa i meni. ");
INSERT INTO hrvbib_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","Pozdravite Prisku i Akvilu. Radili su sa mnom na Kristovu djelu. ");
INSERT INTO hrvbib_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","Izložili su pogibelji vlastiti život za mene. Nisam im zato zahvalan samo ja već i sve crkve pogana. ");
INSERT INTO hrvbib_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","Pozdravite Crkvu koja se sastaje u njihovu domu. Pozdravite mi dragoga prijatelja Epeneta, koji je prvi postao kršćaninom u Aziji. ");
INSERT INTO hrvbib_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","Pozdravite i Mariju, koja se toliko trudila za vas. ");
INSERT INTO hrvbib_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","Pozdravite moje sunarodnjake Andronika i Junija, koji su sa mnom bili u zatvoru. Ugledni su među apostolima i prije mene su postali kršćanima. ");
INSERT INTO hrvbib_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","Pozdravite Amplijata, dragoga brata u Gospodinu. ");
INSERT INTO hrvbib_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","Pozdravite Urbana, mojega suradnika u Kristu, i dragoga Staha. ");
INSERT INTO hrvbib_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","Pozdravite Apela, prokušanoga u Kristu. Pozdravite Aristobulove ukućane. ");
INSERT INTO hrvbib_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","Pozdravite mojega sunarodnjaka Herodiona. Pozdravite sve kršćane u Narcisovu domu. ");
INSERT INTO hrvbib_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","Pozdravite Trifenu i Trifozu, koje marljivo rade za Gospodina. Pozdravite dragu Persidu, koja se mnogo trudila u Gospodinu. ");
INSERT INTO hrvbib_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","Pozdravite Rufa, kojega je Gospodin odabrao da bude njegov, i Rufovu majku, koja je i meni bila poput majke. ");
INSERT INTO hrvbib_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","Pozdravite Asinkrita, Flegonta, Herma, Patrobu, Hermu i ostalu braću koja su s njima. ");
INSERT INTO hrvbib_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","Pozdravite Filologa, Juliju, Nereja i njegovu sestru, te Olimpu i sve svete koji su s njima. ");
INSERT INTO hrvbib_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","Pozdravite jedni druge svetim cjelovom. Sve Kristove crkve šalju vam pozdrave. ");
INSERT INTO hrvbib_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","Čuvajte se, braćo i sestre, onih koji potiču razdore i sablažnjuju ljude šireći učenje suprotno onomu koje ste prihvatili. Klonite se takvih. ");
INSERT INTO hrvbib_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","Takvi ne služe našemu Gospodinu Kristu, već vlastitom probitku. Ugodnim i laskavim riječima zavode srca nedužnih ljudi. ");
INSERT INTO hrvbib_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","Ali svi znaju da ste vi poslušni Gospodinu. To me silno raduje. Zato hoću da budete mudri i prepoznate dobro te da ostanete nedužni od zla. ");
INSERT INTO hrvbib_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","Bog mira će uskoro satrti Sotonu pod vašim nogama. Neka je milost našega Gospodina Isusa Krista s vama! ");
INSERT INTO hrvbib_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","Pozdravljaju vas moj suradnik Timotej te moji sunarodnjaci Lucije, Jason i Sosipater. ");
INSERT INTO hrvbib_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","Pozdravljam vas i ja, Tercije, koji vam pišem ovo pismo umjesto Pavla. ");
INSERT INTO hrvbib_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","Pozdravlja vas Gaj, koji je u svoj dom primio i mene i cijelu Crkvu. Pozdravljaju vas gradski blagajnik Erast i brat Kvart. ");
INSERT INTO hrvbib_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","Bog vas može ojačati, baš kao što kaže Radosna vijest. To je poruka o Isusu Kristu i o njegovu naumu, koja je bila otajstvom od početka vremena. ");
INSERT INTO hrvbib_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","Ali sada je ta poruka, kao što je pretkazano u zapisima proroka i kao što je Bog zapovjedio, posvuda obznanjena svim narodima da mogu povjerovati u Krista i biti mu poslušni. ");
INSERT INTO hrvbib_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","Bogu, koji je jedini mudar, neka je slava uvijeke po Kristu Isusu. Amen.");
INSERT INTO hrvbib_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","Od Pavla, pozvanoga po Božjoj volji za apostola Isusa Krista, i od brata Sostena, ");
INSERT INTO hrvbib_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","Božjoj crkvi u Korintu, vama koje je Bog pozvao da budete njegov sveti narod. Posvetio vas je u Kristu Isusu, kao i sve ostale koji bilo gdje prizivlju ime njihova i našega Gospodina Isusa Krista. ");
INSERT INTO hrvbib_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","Neka vam je milost i mir od našega Boga Oca i Gospodina Isusa Krista. ");
INSERT INTO hrvbib_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","Uvijek zahvaljujem Bogu na milosti kojom vas je obdario sada kad pripadate Kristu Isusu. ");
INSERT INTO hrvbib_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","U njemu ste obogaćeni u svemu—u svakovrsnoj riječi i spoznaji. ");
INSERT INTO hrvbib_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","Svjedočanstvo o Kristu utvrdilo se među vama ");
INSERT INTO hrvbib_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","pa sada ne oskudijevate ni u jednome duhovnom daru iščekujući povratak našega Gospodina Isusa Krista. ");
INSERT INTO hrvbib_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","On će vas učiniti postojanima sve do konca i sačuvat će vas neporočnima sve do svojega povratka, ");
INSERT INTO hrvbib_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","jer Bog vjerno ispunjava obećanja, a on vas je sam pozvao da imate zajedništvo s našim Gospodinom Isusom Kristom. ");
INSERT INTO hrvbib_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","Draga braćo i sestre, zaklinjem vas imenom našega Gospodina Isusa Krista da se prestanete međusobno prepirati. Neka među vama vlada sloga i neka ne bude razdora u Crkvi. Molim vas da budete jedinstveni u mislima iu osjećajima. ");
INSERT INTO hrvbib_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","Klojini su mi ukućani rekli da se međusobno prepirete. ");
INSERT INTO hrvbib_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","Neki od vas, naime, kažu: “Ja sam Pavlov sljedbenik”, a drugi: “Ja sam Apolonov”, ili “Ja sam Petrov”, ili “Ja slijedim samo Krista.” ");
INSERT INTO hrvbib_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","Zar je Krist razdijeljen? Jesam li ja, Pavao, raspet za vas? Je li tko od vas kršten u Pavlovo ime? ");
INSERT INTO hrvbib_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","Hvala Bogu što ja nisam krstio nikoga od vas osim Krispa i Gaja ");
INSERT INTO hrvbib_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","da sada nitko ne može reći kako je kršten u moje ime. ");
INSERT INTO hrvbib_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","A da, krstio sam i Stefanine ukućane. Ne sjećam se da sam osim njih ikoga više krstio. ");
INSERT INTO hrvbib_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","Jer Krist me nije poslao krstiti, nego propovijedati Radosnu vijest, i to ne mudrim riječima da Kristov križ ne izgubi snagu. ");
INSERT INTO hrvbib_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","Govor o križu zvuči kao ludost onima koji su na putu propasti, ali mi koji smo spašeni prepoznajemo u toj poruci Božju silu. ");
INSERT INTO hrvbib_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","U Svetome pismu stoji da je Bog rekao: “Učinit ću da propadne mudrost mudraca i da se pomrači umnost umnika.” ");
INSERT INTO hrvbib_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","Ali što je s učenim glavama, s ljudima vičnim raspravama, znanstvenicima? Bog je učinio da se njihova mudrost čini beskorisnom ludošću. ");
INSERT INTO hrvbib_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","Bog je u svojoj mudrosti znao da ga svijet nikada neće pronaći ljudskom mudrošću, pa je odlučio one koji vjeruju spasiti ludošću propovijedanja. ");
INSERT INTO hrvbib_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","U taj Božji način spasenja Židovi odbijaju povjerovati jer za dokaz traže znak s neba, a Grci zato što vjeruju samo u ono što ne proturječi njihovoj vlastitoj mudrosti. ");
INSERT INTO hrvbib_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","Zato naše propovijedanje raspetoga Krista Židove sablažnjava, a pogani ga smatraju ludošću. ");
INSERT INTO hrvbib_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","Ali onima koje je Bog pozvao na spasenje, i Židovima i poganima, Krist je Božja sila i Božja mudrost. ");
INSERT INTO hrvbib_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","Taj “budalast” Božji plan mnogo je mudriji od najmudrijih ljudskih planova, a Božja je “slabost” mnogo jača od najjače ljudske snage. ");
INSERT INTO hrvbib_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","Možete vidjeti, draga braćo, kako među vama koji ste izabrani nema mnogo onih koji ste po tjelesnom podrijetlu mudri, moćni ili plemenita roda. ");
INSERT INTO hrvbib_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","Bog je, naprotiv, izabrao one koje svijet smatra budalastima da posrami njegove mudrace, i slabe u očima svijeta da posrami njegove moćnike. ");
INSERT INTO hrvbib_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","Ono što je neplemenito i prezreno u očima svijeta, pa čak i ono čega nema, Bog je izabrao da obezvrijedi ono što svijet smatra vrijednim, ");
INSERT INTO hrvbib_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","zato da se nijedan smrtnik ne može hvaliti pred Bogom. ");
INSERT INTO hrvbib_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","Sam vam je Bog omogućio da budete u Kristu Isusu. Za našu je dobrobit Bog učinio Krista mudrošću. On nas opravdava pred Bogom. Čini nas svetima. Otkupio nas je. ");
INSERT INTO hrvbib_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","Kao što piše u Svetome pismu: “Ako se tko hvali, neka se hvali jedino time što je Gospodin učinio.” ");
INSERT INTO hrvbib_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","Draga braćo i sestre, kad sam prvi put došao k vama, nisam se služio uzvišenim ni dubokoumnim riječima da vam navijestim Božju poruku. ");
INSERT INTO hrvbib_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","Jer odlučio sam među vama ne znati ništa drugo osim Isusa Krista, i to raspetoga. ");
INSERT INTO hrvbib_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","Došao sam k vama slab—bojažljivo i drhteći. ");
INSERT INTO hrvbib_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","Moj govor i propovijedanje nisu se zasnivali na mudrim i uvjerljivim riječima, nego na djelovanju Svetoga Duha među vama, ");
INSERT INTO hrvbib_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","zato da svoju vjeru ne temeljite na ljudskoj mudrosti, nego na Božjoj sili. ");
INSERT INTO hrvbib_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","Doduše, kad smo sa zrelim kršćanima, navješćujemo mudrost—ali ne mudrost ovoga svijeta ni takvu mudrost koja bi se svidjela vladarima ovoga svijeta koji su ionako osuđeni na propast. ");
INSERT INTO hrvbib_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","Navješćujemo tajnu, skrivenu Božju mudrost koju je Bog namijenio našoj dobrobiti još prije postanka svijeta. ");
INSERT INTO hrvbib_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","Vladari ovoga svijeta nisu ju razumjeli—jer da jesu, ne bi raspeli našega Gospodina slave. ");
INSERT INTO hrvbib_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","Upravo je to značenje ulomka iz Svetoga pisma: “Ono što oko još nije vidjelo, što uho još nije čulo niti um može zamisliti, to je Bog pripravio onima koji ga ljube.” ");
INSERT INTO hrvbib_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","Ali mi to znamo jer nam je Bog otkrio svojim Duhom koji proniče sve, pa tako i Božje dubine. ");
INSERT INTO hrvbib_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","Tko može znati misli nekog čovjeka osim njegova vlastitoga čovječjeg duha u njemu? Tako ni Božje misli ne može znati nitko osim Božjega Duha. ");
INSERT INTO hrvbib_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","I tog nam je Božjeg Duha (a ne duha svijeta) Bog dao da bismo mogli znati čime nas je obdario. ");
INSERT INTO hrvbib_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","Govoreći vam o tomu, ne služimo se riječima ljudske mudrosti, nego riječima koje nam daje Sveti Duh—služeći se riječima Duha da bismo objasnili duhovne istine. ");
INSERT INTO hrvbib_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","Ali čovjek tjelesne naravi ne može razumjeti spoznaje koje daje Božji Duh. Njemu se one čine ludošću jer ih valja prosuđivati Duhom. ");
INSERT INTO hrvbib_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","Čovjek koji ima Duha može sve prosuđivati, ali drugi nisu kadri prosuđivati njega. ");
INSERT INTO hrvbib_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","“Jer tko poznaje Gospodnje misli? Tko će njemu dati savjet?” Ali mi imamo Kristov um. ");
INSERT INTO hrvbib_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","Draga braćo i sestre, dok sam bio s vama, nisam s vama mogao razgovarati kao s duhovnim, zrelim kršćanima, nego kao s tjelesnima koji pripadaju ovome svijetu, kao s nejačadi u Kristu. ");
INSERT INTO hrvbib_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","Morao sam vas hraniti mlijekom, a ne čvrstom hranom jer ju niste mogli podnositi. A ne možete ni sada ");
INSERT INTO hrvbib_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","jer vama još vlada tjelesna, grešna narav. Zavidite jedni drugima i prepirete se. Ne dokazuje li to da ste još tjelesni? ");
INSERT INTO hrvbib_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","Kad jedan od vas kaže: “Ja sam Pavlov sljedbenik”, a drugi: “Ja sam Apolonov”, ne ponašate li se kao ljudi koji ne pripadaju Gospodinu? ");
INSERT INTO hrvbib_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","A tko je Apolon i tko je Pavao da biste se zbog nas prepirali? Ta mi samo služimo Gospodinu kako nam je dao—da kroz nas povjerujete u njega. ");
INSERT INTO hrvbib_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","Ja sam u vaša srca posijao sjeme, Apolon ga je zalio, ali Bog je dao da poraste. ");
INSERT INTO hrvbib_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","Nije važan ni onaj tko sije ni onaj tko zalijeva, već Bog koji daje rasti. ");
INSERT INTO hrvbib_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","Tko sije i tko zalijeva, jedno su, ali svaki će primiti plaću prema vlastitom trudu. ");
INSERT INTO hrvbib_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","Jer mi smo samo Božji suradnici, a vi niste naša, već Božja njiva, Božja građevina. ");
INSERT INTO hrvbib_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","Po Božjoj sam milosti položio temelj kao mudar graditelj. Drugi nadoziđuju. Ali svatko mora paziti kako nadoziđuje! ");
INSERT INTO hrvbib_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","Jer nitko ne može postaviti neki drugi temelj osim onoga koji je već postavljen—a to je Isus Krist. ");
INSERT INTO hrvbib_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","Na njega se može nadozidati zlatom, srebrom, dragim kamenjem, drvom, sijenom ili slamom. ");
INSERT INTO hrvbib_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","Ali svačije će djelo izići na vidjelo na Dan suda kad bude iskušano ognjem. Tada će se pokazati kakvo je čije djelo. ");
INSERT INTO hrvbib_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","Graditelj čije djelo ostane, primit će nagradu. ");
INSERT INTO hrvbib_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","Ali kome djelo izgori, pretrpjet će veliku štetu. On sam spasit će se, ali kao kroz vatru. ");
INSERT INTO hrvbib_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","Ne shvaćate li da ste vi Božji hram i da Božji Duh prebiva u vama? ");
INSERT INTO hrvbib_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","Razara li tko Božji hram, njega će Bog razoriti. Jer Božji hram je svet—a to ste vi, kršćani. ");
INSERT INTO hrvbib_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","Nemojte se zavaravati! Drži li tko od vas sebe pametnim prema mjerilima ovoga svijeta, morat će postati ludim da bi bio mudar prema Božjim mjerilima. ");
INSERT INTO hrvbib_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","Jer mudrost ovoga svijeta pred Bogom je ludost. U Svetome pismu piše: “On hvata mudre u zamku njihova vlastita lukavstva.” ");
INSERT INTO hrvbib_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","I još: “Gospodin poznaje umovanje mudrih; ono je isprazno.” ");
INSERT INTO hrvbib_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","Zato se nemojte ponositi time što slijedite nekog vođu. Sve je vaše: ");
INSERT INTO hrvbib_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","i Pavao i Apolon i Petar, i cijeli svijet, i život i smrt, i sadašnjost i budućnost. Sve to pripada vama, ");
INSERT INTO hrvbib_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","vi pripadate Kristu, a Krist Bogu. ");
INSERT INTO hrvbib_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","Zato Apolona i mene smatrajte samo Kristovim slugama zaduženima da objašnjavamo Božje tajne. ");
INSERT INTO hrvbib_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","Kada je tko za što zadužen, od njega se očekuje da to vjerno obavlja. ");
INSERT INTO hrvbib_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","A jesam li ja tako činio? Nimalo mi nije do toga da o tome prosuđujete vi ili bilo tko drugi. Čak ni sam sebe ne prosuđujem. ");
INSERT INTO hrvbib_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","Savjest mi je čista, ali čak me ni to ne opravdava. Jer sudac mi je samo Gospodin. ");
INSERT INTO hrvbib_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","Zato ne donosite preuranjene zaključke o tomu tko je vjeran, a tko nije prije nego što se Gospodin vrati. Kad on dođe, iznijet će na vidjelo tajne skrivene u tami i razotkriti nakane svačijeg srca. Tada će svatko primiti pohvalu od Boga. ");
INSERT INTO hrvbib_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","Draga braćo, Apolona i sebe uzeo sam za primjer da biste od nas naučili što znači: “Ne preko onoga što stoji pisano!” te da se ne nadimate što pristajete uz jednog učitelja protiv drugoga. ");
INSERT INTO hrvbib_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","Po čemu si ti bolji od koga drugoga? Što imaš a da ti Bog to nije dao? A ako ti je sve dao Bog, zašto se hvališ kao da si to sam postignuo? ");
INSERT INTO hrvbib_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","Vi mislite da već imate sve što trebate! Već ste bogati! I bez nas ste postali kraljevima! Kamo sreće da ste se zaista već zakraljili jer bismo onda i mi kraljevali s vama. ");
INSERT INTO hrvbib_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","Čini mi se da je Bog nas apostole stavio na posljednje mjesto, poput ratnih zarobljenika osuđenih na smrt na kraju pobjedničke povorke, da nas tako gleda cijeli svijet, i anđeli i ljudi. ");
INSERT INTO hrvbib_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","Zbog svoje odanosti Kristu činimo se glupima, no vi ste, dakako, vrlo mudri kršćani! Mi smo slabi, a vi jaki! O vama ljudi lijepo govore, a nama se smiju. ");
INSERT INTO hrvbib_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","Sve do ovoga trenutka podnosimo glad, žeđu i golotinju, primamo batine i beskućnici smo. ");
INSERT INTO hrvbib_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","Mukotrpno radimo vlastitim rukama da zaradimo za život. Blagoslivljamo one koji nas vrijeđaju, strpljivo podnosimo one koji nas zlostavljaju. ");
INSERT INTO hrvbib_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","Blago uzvraćamo onima koji nas ocrnjuju. Postali smo kao smeće svijeta, kao svačiji izmet—sve do sada. ");
INSERT INTO hrvbib_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","Ne pišem vam to da vas posramim, nego da vas upozorim kao svoju ljubljenu djecu. ");
INSERT INTO hrvbib_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","Jer da imate i bezbroj učitelja o Kristu, ipak imate samo jednoga duhovnog oca. Ja sam vam postao ocem u Kristu Isusu kad sam vam propovijedao Radosnu vijest. ");
INSERT INTO hrvbib_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","Zato vas zaklinjem: činite kao i ja. ");
INSERT INTO hrvbib_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","Šaljem vam zato i Timoteja, svojega voljenog i vjernog sina u Gospodinu. On će vas podsjetiti na moje naputke o vladanju u Kristu, koje poučavam u svakoj crkvi. ");
INSERT INTO hrvbib_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","Znam da su se neki od vas uznijeli kao da više neću doći k vama. ");
INSERT INTO hrvbib_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","Ali doći ću, i to uskoro, bude li Gospodin htio, ne zato da vidim što ti umišljeni ljudi govore, nego da vidim što mogu u Gospodinu. ");
INSERT INTO hrvbib_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","Jer Božje kraljevstvo nije u riječima, nego u Božjoj sili. ");
INSERT INTO hrvbib_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","Što vam je draže, da k vama dođem s kaznama i prijekorima ili s ljubavlju i blagošću? ");
INSERT INTO hrvbib_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","Pročulo se o takvom bludu među vama, o takvom zlu kakvo čak ni pogani ne čine. Kažu mi da neki čovjek iz vaše crkve živi u grijehu sa ženom svojega oca. ");
INSERT INTO hrvbib_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","A vi ste se još umislili. Zašto niste u žalosti? Uklonite iz svojega zajedništva počinitelja tog nedjela. ");
INSERT INTO hrvbib_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","Iako nisam nazočan tijelom, nazočan sam duhom te sam presudio, kao da sam s vama, čovjeku koji je takvo što počinio: ");
INSERT INTO hrvbib_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","okupite Crkvu u ime našega Gospodina Isusa Krista. Ja ću biti s vama duhom, kao i sila Gospodina Isusa. ");
INSERT INTO hrvbib_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","Predajte toga čovjeka Sotoni u ruke: isključite ga iz Crkve da trpi u tijelu kako bi se on spasio na dan Gospodina Isusa. ");
INSERT INTO hrvbib_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","Kako se još možete hvaliti! Kao da ne znate da malo kvasca ukvasi sve tijesto! Dopustite li jednomu da griješi, ubrzo će se grijeh proširiti. ");
INSERT INTO hrvbib_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","Očistite se od staroga kvasca da budete novo tijesto, kao što i jeste beskvasni, jer je naše pashalno janje—Krist—već žrtvovano. ");
INSERT INTO hrvbib_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","Svetkujmo zato blagdan, ne sa starim kvascem niti s kvascem zloće i pokvarenosti, već s beskvasnim kruhom čistoće i čestitosti. ");
INSERT INTO hrvbib_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","U prijašnjoj sam vam poslanici napisao da se ne družite s bludnicima. ");
INSERT INTO hrvbib_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","Nisam pri tome mislio na bludnike općenito, na nevjernike iz svijeta koji su bludnici, ili lakomci, ili varalice, ili idolopoklonici—jer inače biste morali izići iz svijeta. ");
INSERT INTO hrvbib_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","Mislio sam da se ne družite s ljudima koji sebe nazivaju kršćanima, a bludnici su, ili lakomci, ili idolopoklonici, ili klevetnici, ili pijanci, ili varalice. ");
INSERT INTO hrvbib_vpl VALUES ("C15_12","076_5_12","1CO","5","12","12","Nije na meni da sudim one koji su vani. Ali onima u Crkvi koji tako griješe trebate suditi. ");
INSERT INTO hrvbib_vpl VALUES ("C15_13","076_5_13","1CO","5","13","13","Onima koji su vani sudit će Bog. Ali u Svetome pismu piše: “Isključite opakoga iz svoje sredine.” ");
INSERT INTO hrvbib_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","Kako se neki od vas usuđuju s drugim kršćanima parničiti na svjetovnome sudu tražeći pravdu od nepravednih umjesto od svetih? ");
INSERT INTO hrvbib_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","Zar ne znate da ćemo mi sveti jednoga dana suditi svijet? Pa ako ćete suditi svijetu, ne možete li sami presuđivati i o tim sitnicama? ");
INSERT INTO hrvbib_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","Ne znate li da ćemo suditi anđelima? Morali biste stoga biti u stanju riješiti svagdašnje razmirice ovdje na zemlji. ");
INSERT INTO hrvbib_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","A vi za svoje svagdašnje sporove uzimate suce izvana! Zašto ne uzmete za suca nekoga od najmanje cijenjenih u Crkvi?. ");
INSERT INTO hrvbib_vpl VALUES ("C16_5","076_6_5","1CO","6","5","5","Kažem to da biste se postidjeli. Nema li u cijeloj Crkvi nikoga tko bi bio dovoljno mudar da presudi među braćom? ");
INSERT INTO hrvbib_vpl VALUES ("C16_6","076_6_6","1CO","6","6","6","Umjesto toga jedan kršćanin tuži drugoga—i to pred nevjernicima! ");
INSERT INTO hrvbib_vpl VALUES ("C16_7","076_6_7","1CO","6","7","7","Nedostatak vam je već to što se uopće parničite. Zašto radije ne pretrpite nepravdu? Zašto radije ne pregorite štetu? ");
INSERT INTO hrvbib_vpl VALUES ("C16_8","076_6_8","1CO","6","8","8","Umjesto toga vi i sami nanosite nepravdu i varate—čak i vlastitu braću u Kristu! ");
INSERT INTO hrvbib_vpl VALUES ("C16_9","076_6_9","1CO","6","9","9","Ne znate li da oni koji čine zlo neće baštiniti Božje kraljevstvo? Nemojte se zavaravati! Ni bludnici, ni idolopoklonici, ni preljubnici, ni homoseksualci, ");
INSERT INTO hrvbib_vpl VALUES ("C16_10","076_6_10","1CO","6","10","10","ni lopovi, ni lakomci, ni pijanci, ni psovači, ni varalice neće baštiniti Božjeg kraljevstva. ");
INSERT INTO hrvbib_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","I neki od vas bili su takvi, ali sada ste oprani od grijeha i posvećeni. Opravdani ste pred Bogom zbog onoga što su Gospodin Isus Krist i Duh našega Boga učinili za vas. ");
INSERT INTO hrvbib_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","Kaže se: “Sve mi je dopušteno…”—ali sve mi ne služi na korist. “Sve mi je dopušteno…”—ali ničemu neću robovati. ");
INSERT INTO hrvbib_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","Kažete: “Hrana je za trbuh, a trbuh za hranu.” Tako je, ali Bog će jednog dana i jedno i drugo uništiti. Naša tijela nisu stvorena za blud, nego za Gospodina, i Gospodin za tijela. ");
INSERT INTO hrvbib_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","Bog će uskrisiti naša tijela od mrtvih svojom veličanstvenom silom, baš kao što je i našega Gospodina podignuo od mrtvih. ");
INSERT INTO hrvbib_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","Ne shvaćate li da su vaša tijela Kristovi udovi? Zar ćete dakle svoje tijelo, koje pripada Kristu, sjediniti s bludničinim? Nipošto! ");
INSERT INTO hrvbib_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","Zar ne znate da muškarac koji se druži s bludnicom postaje s njom jedno tijelo? Jer u Svetome pismu piše: “Njih će dvoje biti jedno tijelo.” ");
INSERT INTO hrvbib_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","A tko se združi s Gospodinom, postaje s njime jedan duh. ");
INSERT INTO hrvbib_vpl VALUES ("C16_18","076_6_18","1CO","6","18","18","Bježite od bluda! Svaki drugi grijeh čovjek čini izvan tijela, a bludnik griješi protiv vlastitog tijela. ");
INSERT INTO hrvbib_vpl VALUES ("C16_19","076_6_19","1CO","6","19","19","Ne shvaćate li da je vaše tijelo hram Svetoga Duha kojega vam je Bog dao i da on prebiva u vama? Vi ne pripadate sebi ");
INSERT INTO hrvbib_vpl VALUES ("C16_20","076_6_20","1CO","6","20","20","jer je Bog za vas platio otkupninu. Zato svojim tijelom trebate proslavljati Boga. ");
INSERT INTO hrvbib_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","A sada odgovor na ono o čemu ste mi pisali: “Dobro je da čovjek živi uzdržavajući se od dodira sa ženom.” ");
INSERT INTO hrvbib_vpl VALUES ("C17_2","076_7_2","1CO","7","2","2","Ali zbog pogibli od bluda dobro je da svaki muškarac održava bračne odnose sa ženom, a tako i žena sa svojim mužem. ");
INSERT INTO hrvbib_vpl VALUES ("C17_3","076_7_3","1CO","7","3","3","Muž neka ženi ne uskraćuje tjelesnu bliskost na koju ona ima pravo, a isto tako ni žena mužu. ");
INSERT INTO hrvbib_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","Jer ženinim tijelom gospodari muž, a on nije gospodar vlastitog tijela, već njime gospodari njegova žena. ");
INSERT INTO hrvbib_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","Nemojte se uskraćivati jedno drugome, osim ako to želite učiniti privremeno da biste se potpunije posvetili molitvi. Zatim se opet združite da vas Sotona ne bi napastovao zbog suzdržavanja. ");
INSERT INTO hrvbib_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","Ali to vam kažem kao dopuštenje, a ne kao zapovijed. ");
INSERT INTO hrvbib_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","Želio bih da svi budu neženje, kao ja. Ali svakome od nas Bog je dao drukčiji dar—nekome da bude oženjen, nekome da bude samac. ");
INSERT INTO hrvbib_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","Što se tiče neoženjenih i udovica—bolje im je da ostanu samci kao i ja. ");
INSERT INTO hrvbib_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","Ako se pak ne mogu uzdržati, neka se žene. Jer je bolje ženiti se nego izgarati od žudnje. ");
INSERT INTO hrvbib_vpl VALUES ("C17_10","076_7_10","1CO","7","10","10","A za one u braku imam zapovijed—ne od sebe, već od Gospodina: neka se žena ne rastaje od muža. ");
INSERT INTO hrvbib_vpl VALUES ("C17_11","076_7_11","1CO","7","11","11","Ako se ipak rastane, neka se više ne udaje ili neka se pomiri s mužem. Ni muž ne smije ostaviti ženu. ");
INSERT INTO hrvbib_vpl VALUES ("C17_12","076_7_12","1CO","7","12","12","A ostalima pak kažem, iako Gospodin to nije izravno zapovjedio: ima li kršćanin ženu nevjernicu koja pristaje živjeti s njim, ne smije ju ostaviti. ");
INSERT INTO hrvbib_vpl VALUES ("C17_13","076_7_13","1CO","7","13","13","Ima li kršćanka muža nevjernika koji pristaje s njom živjeti, ne smije ga napustiti. ");
INSERT INTO hrvbib_vpl VALUES ("C17_14","076_7_14","1CO","7","14","14","Jer žena kršćanka unosi svetost u brak, a muž kršćanin također. Inače će vam djeca biti poput pogana, ali ovako su posvećena za Boga. ");
INSERT INTO hrvbib_vpl VALUES ("C17_15","076_7_15","1CO","7","15","15","Ali ako se supružnik koji nije vjernik želi rastaviti, neka to učini. Vjerni muž ili žena nisu primorani s njima ostati jer Bog želi da njegova djeca žive u miru. ");
INSERT INTO hrvbib_vpl VALUES ("C17_16","076_7_16","1CO","7","16","16","Jer tko zna hoće li žena kršćanka spasiti muža nevjernika, ili muž kršćanin ženu koja nije vjernica? ");
INSERT INTO hrvbib_vpl VALUES ("C17_17","076_7_17","1CO","7","17","17","Inače neka svatko živi kako mu je Gospodin dodijelio, kao kad ga je Bog pozvao. Tako naređujem po svim crkvama. ");
INSERT INTO hrvbib_vpl VALUES ("C17_18","076_7_18","1CO","7","18","18","Ako je tko bio obrezan prije nego što je postao vjernikom, to ne bi trebao skrivati. A tko se obratio kao neobrezan, ne bi se sada trebao obrezivati. ");
INSERT INTO hrvbib_vpl VALUES ("C17_19","076_7_19","1CO","7","19","19","Jer nije važno je li tko obrezan ili neobrezan, već držati se Božjih zapovijedi. ");
INSERT INTO hrvbib_vpl VALUES ("C17_20","076_7_20","1CO","7","20","20","Svatko neka ostane u onome zvanju u kojemu ga je zatekao Božji poziv. ");
INSERT INTO hrvbib_vpl VALUES ("C17_21","076_7_21","1CO","7","21","21","Jesi li pozvan kao rob? Ne brini se! Ali, ako možeš postati slobodan, iskoristi priliku. ");
INSERT INTO hrvbib_vpl VALUES ("C17_22","076_7_22","1CO","7","22","22","Ako si i bio rob kad te je Gospodin pozvao, on te je oslobodio od robovanja grijehu. A ako te je pozvao kao slobodnog čovjeka, sada si Kristov rob. ");
INSERT INTO hrvbib_vpl VALUES ("C17_23","076_7_23","1CO","7","23","23","Bog je za vas platio otkupninu. Nemojte zato robovati ljudima. ");
INSERT INTO hrvbib_vpl VALUES ("C17_24","076_7_24","1CO","7","24","24","Zato, braćo, neka svatko u svojemu zajedništvu s Bogom ostane u onomu u čemu ga je on pozvao. ");
INSERT INTO hrvbib_vpl VALUES ("C17_25","076_7_25","1CO","7","25","25","Glede neudanih djevojaka nemam zapovijedi od Gospodina. Mogu vam samo savjetovati kao čovjek koji je, po Božjemu milosrđu, vrijedan povjerenja. ");
INSERT INTO hrvbib_vpl VALUES ("C17_26","076_7_26","1CO","7","26","26","Zbog sadašnje nevolje smatram da je najbolje da ostanete tako kako jeste. ");
INSERT INTO hrvbib_vpl VALUES ("C17_27","076_7_27","1CO","7","27","27","Imaš li ženu, ne traži rastave. Nisi li oženjen, nemoj se ni ženiti. ");
INSERT INTO hrvbib_vpl VALUES ("C17_28","076_7_28","1CO","7","28","28","Ako se i oženite, nije to grijeh. Ako se djevojka uda, ne griješi. Htio bih vas samo sačuvati od tjelesne patnje koja dolazi s brakom. ");
INSERT INTO hrvbib_vpl VALUES ("C17_29","076_7_29","1CO","7","29","29","Braćo i sestre, želim, naime, reći da nam je još kratko vrijeme preostalo. Zato oženjeni ne smiju dopustiti da im brak bude prva briga. ");
INSERT INTO hrvbib_vpl VALUES ("C17_30","076_7_30","1CO","7","30","30","Žalosni ne smiju zanemariti Božji posao zbog svoje žalosti, ni sretni zbog svoje radosti, ni imućni zbog svojega bogatstva, ");
INSERT INTO hrvbib_vpl VALUES ("C17_31","076_7_31","1CO","7","31","31","ni oni koji uživaju u ovome svijetu zbog svojega užitka, jer obličje ovoga svijeta prolazi. ");
INSERT INTO hrvbib_vpl VALUES ("C17_32","076_7_32","1CO","7","32","32","Želio bih da budete bezbrižni. Neženja se brine o Božjemu poslu i kako da ugodi Gospodinu. ");
INSERT INTO hrvbib_vpl VALUES ("C17_33","076_7_33","1CO","7","33","33","A oženjen se čovjek uz to mora brinuti i o svjetovnomu—kako da ugodi ženi— ");
INSERT INTO hrvbib_vpl VALUES ("C17_34","076_7_34","1CO","7","34","34","pa je podijeljen. Neudana žena ili djevojka isto se tako može više brinuti za Gospodnje, da bude sveta i tijelom i duhom. A udana se mora brinuti i za svjetovno—kako da ugodi mužu. ");
INSERT INTO hrvbib_vpl VALUES ("C17_35","076_7_35","1CO","7","35","35","Ne govorim to da vam postavljam zabrane, nego da vam pomognem da uzmognete primjereno i neometano služiti Gospodinu. ");
INSERT INTO hrvbib_vpl VALUES ("C17_36","076_7_36","1CO","7","36","36","Ako tko smatra da nedolično postupa prema svojoj zaručnici, i ako ona više nije u prvoj mladosti te stoga drži da se treba oženiti, neka se oženi. Neće zgriješiti. Neka se vjenčaju! ");
INSERT INTO hrvbib_vpl VALUES ("C17_37","076_7_37","1CO","7","37","37","Ali ako je tko čvrsto odlučio ne ženiti se, a nema hitnje i može vladati sobom, dobro čini ne ženeći se. ");
INSERT INTO hrvbib_vpl VALUES ("C17_38","076_7_38","1CO","7","38","38","Tko se dakle oženi, dobro čini, a tko se ne oženi, čini još bolje. ");
INSERT INTO hrvbib_vpl VALUES ("C17_39","076_7_39","1CO","7","39","39","Žena je vezana za svojega muža dokle god on živi; ako joj muž umre, može se opet udati, ali samo za kršćanina. ");
INSERT INTO hrvbib_vpl VALUES ("C17_40","076_7_40","1CO","7","40","40","Ali smatram da će biti blaženija ako se ne uda ponovno te da vam govoreći to dajem savjet od Svetoga Duha. ");
INSERT INTO hrvbib_vpl VALUES ("C18_1","076_8_1","1CO","8","1","1","Što se tiče mesa žrtvovanog idolima, o tomu svi posjedujemo znanje. Ali znanje čovjeka čini umišljenim, a ljubav izgrađuje. ");
INSERT INTO hrvbib_vpl VALUES ("C18_2","076_8_2","1CO","8","2","2","Misli li tko da mnogo zna, taj ne zna kako treba znati. ");
INSERT INTO hrvbib_vpl VALUES ("C18_3","076_8_3","1CO","8","3","3","A Bog poznaje čovjeka koji ga uistinu ljubi. ");
INSERT INTO hrvbib_vpl VALUES ("C18_4","076_8_4","1CO","8","4","4","Smijemo li, dakle, jesti meso žrtvovano idolima? Svi znamo da idol zapravo nije Bog i da postoji samo jedan Bog. ");
INSERT INTO hrvbib_vpl VALUES ("C18_5","076_8_5","1CO","8","5","5","Neki vjeruju da ima mnogo bogova na nebu i na zemlji—jer zaista ima mnogo takozvanih bogova i gospodara. ");
INSERT INTO hrvbib_vpl VALUES ("C18_6","076_8_6","1CO","8","6","6","Ali mi znamo da postoji samo jedan Bog Otac koji je sve stvorio i za kojega postojimo. I jedan je Isus Krist po kojemu je sve stvoreno i po kojemu imamo život. ");
INSERT INTO hrvbib_vpl VALUES ("C18_7","076_8_7","1CO","8","7","7","Ali to ne znaju svi. Neki ljudi toliko su naviknuti na idole da jedući žrtvovano meso o njemu razmišljaju kao o mesu žrtvovanom pravim bogovima te tako kaljaju svoju slabu savjest. ");
INSERT INTO hrvbib_vpl VALUES ("C18_8","076_8_8","1CO","8","8","8","Zapamtite da jelom nećemo steći Božju naklonost. Niti što gubimo ako takvo meso ne jedemo, niti što dobivamo jedemo li ga. ");
INSERT INTO hrvbib_vpl VALUES ("C18_9","076_8_9","1CO","8","9","9","Ali pazite da zbog te vaše slobode ne posrne slabiji brat ili sestra. ");
INSERT INTO hrvbib_vpl VALUES ("C18_10","076_8_10","1CO","8","10","10","Jer tko smatra da je grijeh jesti tu hranu, može te vidjeti kako jedeš u idolskome hramu. Ti znaš da u tome nema ničega lošega, ali on će jedući meso žrtvovano idolima naučiti da kalja svoju savjest čineći ono što smatra grijehom. ");
INSERT INTO hrvbib_vpl VALUES ("C18_11","076_8_11","1CO","8","11","11","Tako zbog tvojega znanja može propasti nejaki kršćanin za kojega je Krist umro. ");
INSERT INTO hrvbib_vpl VALUES ("C18_12","076_8_12","1CO","8","12","12","Griješeći tako protiv braće i ranjavajući njihovu nejaku savjest, griješite protiv Krista. ");
INSERT INTO hrvbib_vpl VALUES ("C18_13","076_8_13","1CO","8","13","13","Ako će moje jelo navesti na grijeh mojeg brata, neću više jesti mesa dok živim da moj brat zbog mene ne posrne. ");
INSERT INTO hrvbib_vpl VALUES ("C19_1","076_9_1","1CO","9","1","1","Nisam li ja slobodan? Nisam li apostol? Nisam li vidio našega Gospodina Isusa vlastitim očima? Niste li vi u Gospodinu zbog mojega truda? ");
INSERT INTO hrvbib_vpl VALUES ("C19_2","076_9_2","1CO","9","2","2","Ako me drugi i ne smatraju apostolom, vama to sigurno jesam jer ste vi živ dokaz za to. ");
INSERT INTO hrvbib_vpl VALUES ("C19_3","076_9_3","1CO","9","3","3","To je odgovor onima koji osporavaju moje apostolstvo. ");
INSERT INTO hrvbib_vpl VALUES ("C19_4","076_9_4","1CO","9","4","4","Nemamo li pravo jesti za vašim stolom? ");
INSERT INTO hrvbib_vpl VALUES ("C19_5","076_9_5","1CO","9","5","5","Nemamo li pravo dovesti sa sobom ženu kršćanku, kao što čine i drugi učenici, Gospodinova braća i Petar? ");
INSERT INTO hrvbib_vpl VALUES ("C19_6","076_9_6","1CO","9","6","6","Ili se samo Barnaba i ja moramo uzdržavati vlastitim radom? ");
INSERT INTO hrvbib_vpl VALUES ("C19_7","076_9_7","1CO","9","7","7","Koji to vojnik vojuje o svojemu trošku? Tko sadi vinograd a da ne smije jesti njegova roda? Koji to pastir napasa stado a da ne smije piti mlijeka? ");
INSERT INTO hrvbib_vpl VALUES ("C19_8","076_9_8","1CO","9","8","8","Ne govorim vam to samo po ljudsku, nego tako kaže i Božji zakon. ");
INSERT INTO hrvbib_vpl VALUES ("C19_9","076_9_9","1CO","9","9","9","Jer u Mojsijevu zakonu piše: “Ne zavezuj usta volu koji vrši žito.” Mislite li da je Bog to rekao samo za volove? ");
INSERT INTO hrvbib_vpl VALUES ("C19_10","076_9_10","1CO","9","10","10","Nije li to rekao i za nas? Naravno da jest. Kao što žeteoci i vršioci rade u nadi da će imati udjela u žetvi, tako i duhovne radnike trebaju namiriti oni kojima služe. ");
INSERT INTO hrvbib_vpl VALUES ("C19_11","076_9_11","1CO","9","11","11","Zar je previše da mi, koji smo u vas sijali duhovna dobra, očekujemo požeti vaša tjelesna dobra? ");
INSERT INTO hrvbib_vpl VALUES ("C19_12","076_9_12","1CO","9","12","12","Ako drugi na to imaju pravo, nemamo li mi i veće pravo? Ipak, nismo se njime koristili, nego sve podnosimo da ne postavimo kakvu zapreku Kristovoj Radosnoj vijesti. ");
INSERT INTO hrvbib_vpl VALUES ("C19_13","076_9_13","1CO","9","13","13","Ne znate li da oni koji rade u Hramu dobiju od hrane koju ljudi donose u svetište i da oni koji služe pri žrtveniku dobiju dio žrtvenih prinosa? ");
INSERT INTO hrvbib_vpl VALUES ("C19_14","076_9_14","1CO","9","14","14","Jednako je tako Gospodin naredio da oni koji navješćuju Radosnu vijest od nje i žive. ");
INSERT INTO hrvbib_vpl VALUES ("C19_15","076_9_15","1CO","9","15","15","Ali ja se nikad nisam koristio tim pravom. I ne pišem vam to zato da bih to od sada činio. Radije bih umro nego se odrekao te odlike da propovijedam bez naplate. ");
INSERT INTO hrvbib_vpl VALUES ("C19_16","076_9_16","1CO","9","16","16","Propovijedanjem Radosne vijesti ne mogu se hvaliti jer mi je to dužnost. Teško meni ako ju ne propovijedam! ");
INSERT INTO hrvbib_vpl VALUES ("C19_17","076_9_17","1CO","9","17","17","Da to činim iz vlastite pobude, imao bih pravo na plaću. Ali ja samo vršim službu koju mi je Bog povjerio. ");
INSERT INTO hrvbib_vpl VALUES ("C19_18","076_9_18","1CO","9","18","18","Što mi je dakle plaća? Zadovoljstvo da propovijedam Radosnu vijest besplatno ne iskorišćujući svoje propovjedničko pravo. ");
INSERT INTO hrvbib_vpl VALUES ("C19_19","076_9_19","1CO","9","19","19","Iako sam slobodan i ne pripadam nikome, ipak sam svima postao robom, samo da ih što više pridobijem za Krista. ");
INSERT INTO hrvbib_vpl VALUES ("C19_20","076_9_20","1CO","9","20","20","Kad sam bio sa Židovima, bio sam Židov da ih mogu dovesti Kristu. Kad sam bio s onima koji se drže Zakona, i ja sam to činio, iako nisam vezan Zakonom, da ih mogu dovesti Kristu. ");
INSERT INTO hrvbib_vpl VALUES ("C19_21","076_9_21","1CO","9","21","21","Kad sam bio s poganima koji nemaju Zakona, bio sam poput njih koliko sam god mogao. Tako sam stekao njihovo povjerenje i mogao ih dovesti Kristu, ali nisam zanemario Božji zakon, nego sam bio poslušan Kristovu zakonu. ");
INSERT INTO hrvbib_vpl VALUES ("C19_22","076_9_22","1CO","9","22","22","S nejakima sam bio nejak da ih pridobijem za Krista. Svima njima bio sam sve ne bih li neke spasio. ");
INSERT INTO hrvbib_vpl VALUES ("C19_23","076_9_23","1CO","9","23","23","A sve to činim zbog Radosne vijesti, da i ja budem njezinim dionikom. ");
INSERT INTO hrvbib_vpl VALUES ("C19_24","076_9_24","1CO","9","24","24","Ne znate li da u trci svi trkači trče, a samo jedan osvoji prvu nagradu? I vi trčite tako da ju osvojite. ");
INSERT INTO hrvbib_vpl VALUES ("C19_25","076_9_25","1CO","9","25","25","Svaki natjecatelj živi suzdržljivo. Oni to čine da dobiju vijenac koji će istrunuti, a mi da dobijemo nagradu koja će vječno trajati. ");
INSERT INTO hrvbib_vpl VALUES ("C19_26","076_9_26","1CO","9","26","26","Trčim zato, ali uvijek prema cilju, a ne besciljno i uzaludno poput nekoga tko šakom udara vjetar. ");
INSERT INTO hrvbib_vpl VALUES ("C19_27","076_9_27","1CO","9","27","27","Stegom morim svoje tijelo i tjeram ga poput roba da ne bih, pošto sam drugima propovijedao, sam bio odbačen. ");
INSERT INTO hrvbib_vpl VALUES ("C110_1","076_10_1","1CO","10","1","1","Htio bih, braćo i sestre, da znate što se našim precima davno dogodilo u pustinji. Bog ih je sve vodio oblakom koji se kretao pred njima i sve ih je sigurno preveo preko mora po suhome dnu. ");
INSERT INTO hrvbib_vpl VALUES ("C110_2","076_10_2","1CO","10","2","2","Svi su oni kršteni u oblaku i u moru kao Mosijevi sljedbenici. ");
INSERT INTO hrvbib_vpl VALUES ("C110_3","076_10_3","1CO","10","3","3","Svi su jeli istu čudesnu hranu i svi su pili istu čudesnu vodu. ");
INSERT INTO hrvbib_vpl VALUES ("C110_4","076_10_4","1CO","10","4","4","Pili su iz duhovne stijene koja ih je pratila, a ta je stijena bio Krist. ");
INSERT INTO hrvbib_vpl VALUES ("C110_5","076_10_5","1CO","10","5","5","Unatoč svemu, većina ih nije bila po volji Bogu te su poubijani u pustinji. ");
INSERT INTO hrvbib_vpl VALUES ("C110_6","076_10_6","1CO","10","6","6","To se dogodilo nama za opomenu: da ne žudimo za zlim poput njih ");
INSERT INTO hrvbib_vpl VALUES ("C110_7","076_10_7","1CO","10","7","7","i da se ne klanjamo idolima kao oni. U Svetome pismu piše: “Narod posjeda da jede i pije, a zatim ustanu plesati” u čast zlatnome teletu. ");
INSERT INTO hrvbib_vpl VALUES ("C110_8","076_10_8","1CO","10","8","8","Ne odajmo se bludu kao što su mu se oni odali te ih je zbog toga dvadeset tri tisuće palo u jednome danu. ");
INSERT INTO hrvbib_vpl VALUES ("C110_9","076_10_9","1CO","10","9","9","Ne izazivajmo Gospodina kao što su ga izazivali neki od njih pa su poginuli od zmija. ");
INSERT INTO hrvbib_vpl VALUES ("C110_10","076_10_10","1CO","10","10","10","Ne prigovarajte kao što su neki od njih prigovarali pa je Bog poslao anđela Zatornika da ih pobije. ");
INSERT INTO hrvbib_vpl VALUES ("C110_11","076_10_11","1CO","10","11","11","Sve se to događalo nama za primjer, a zapisano je kao opomena nama koji živimo u posljednjim vremenima. ");
INSERT INTO hrvbib_vpl VALUES ("C110_12","076_10_12","1CO","10","12","12","Misli li dakle tko da dobro stoji, neka pazi da ne zapadne u isti grijeh. ");
INSERT INTO hrvbib_vpl VALUES ("C110_13","076_10_13","1CO","10","13","13","Znajte da vas ne snalaze kušnje koje i drugi ljudi nemaju. Bog je vjeran. Neće dopustiti da vas kušnja nadvlada, nego će vam pokazati i izlaz iz nje da možete izdržati. ");
INSERT INTO hrvbib_vpl VALUES ("C110_14","076_10_14","1CO","10","14","14","Zato se, dragi moji, klonite idolopoklonstva. ");
INSERT INTO hrvbib_vpl VALUES ("C110_15","076_10_15","1CO","10","15","15","Razumni ste vi ljudi. Prosudite dakle sami je li istina što ću vam reći. ");
INSERT INTO hrvbib_vpl VALUES ("C110_16","076_10_16","1CO","10","16","16","Nije li čaša koju posvećujemo za stolom Gospodnjim zajedništvo Kristove krvi? Nije li kruh koji lomimo zajedništvo Kristova tijela? ");
INSERT INTO hrvbib_vpl VALUES ("C110_17","076_10_17","1CO","10","17","17","Time što svi jedemo od jednoga kruha pokazujemo da smo jedno tijelo. ");
INSERT INTO hrvbib_vpl VALUES ("C110_18","076_10_18","1CO","10","18","18","Pogledajte Izraelce po tijelu! Svi koji blaguju žrtve dionici su žrtvenika. ");
INSERT INTO hrvbib_vpl VALUES ("C110_19","076_10_19","1CO","10","19","19","Što želim reći? Da su žrtve idolima vrijedne ili da su idoli pravi bogovi? ");
INSERT INTO hrvbib_vpl VALUES ("C110_20","076_10_20","1CO","10","20","20","Naprotiv! Kažem da pogani te žrtve prinose demonima, a ne Bogu. A ja ne želim da vi imate išta s demonima. ");
INSERT INTO hrvbib_vpl VALUES ("C110_21","076_10_21","1CO","10","21","21","Ne možete piti i iz Gospodnjeg i iz vražjeg kaleža. Ne možete jesti i za Gospodnjim i za vražjim stolom. ");
INSERT INTO hrvbib_vpl VALUES ("C110_22","076_10_22","1CO","10","22","22","Zar da izazivamo Gospodinovu ljubomoru? Mislite li da smo jači od njega? ");
INSERT INTO hrvbib_vpl VALUES ("C110_23","076_10_23","1CO","10","23","23","Kaže se: “Sve mi je dopušteno…”—ali ne služi mi sve na korist. “Sve mi je dopušteno…”—ali sve ne izgrađuje. ");
INSERT INTO hrvbib_vpl VALUES ("C110_24","076_10_24","1CO","10","24","24","Ne mislite samo na vlastito dobro. Brinite se o tome što je dobro za drugoga. ");
INSERT INTO hrvbib_vpl VALUES ("C110_25","076_10_25","1CO","10","25","25","Jedite sve što se prodaje na tržnici i nemojte se zbog savjesti raspitivati je li žrtvovano idolima ili nije. ");
INSERT INTO hrvbib_vpl VALUES ("C110_26","076_10_26","1CO","10","26","26","Jer “Gospodinova je zemlja i sve na njoj.” ");
INSERT INTO hrvbib_vpl VALUES ("C110_27","076_10_27","1CO","10","27","27","Pozove li vas na objed nevjernik i želite li se odazvati, jedite sve što se pred vas stavi ne ispitujući ništa zaradi savjesti. ");
INSERT INTO hrvbib_vpl VALUES ("C110_28","076_10_28","1CO","10","28","28","Ako vas tko upozori da je meso bilo žrtvovano idolima, nemojte ga jesti zaradi onoga koji vas je upozorio i zaradi savjesti. ");
INSERT INTO hrvbib_vpl VALUES ("C110_29","076_10_29","1CO","10","29","29","Ne zaradi svoje, nego zaradi njegove savjesti. “Zašto bi moju slobodu ograničavala tuđa savjest?” pitat ćete. ");
INSERT INTO hrvbib_vpl VALUES ("C110_30","076_10_30","1CO","10","30","30","“Ako zahvaljujem Bogu za hranu koju jedem, zašto da me osuđuju zbog onoga što jedem?” ");
INSERT INTO hrvbib_vpl VALUES ("C110_31","076_10_31","1CO","10","31","31","Jer bilo da jedete, pijete ili činite što drugo, sve činite Bogu na slavu! ");
INSERT INTO hrvbib_vpl VALUES ("C110_32","076_10_32","1CO","10","32","32","Ne budite na sablazan nikome—ni Židovima, ni poganima, ni Božjoj crkvi. ");
INSERT INTO hrvbib_vpl VALUES ("C110_33","076_10_33","1CO","10","33","33","Tako se i ja trudim svima u svemu ugoditi ne čineći ono što je najbolje za mene, već što je najbolje za njihovo spasenje. ");
INSERT INTO hrvbib_vpl VALUES ("C111_1","076_11_1","1CO","11","1","1","A vi biste trebali slijediti moj primjer, kao što ja slijedim Kristov. ");
INSERT INTO hrvbib_vpl VALUES ("C111_2","076_11_2","1CO","11","2","2","Pohvaljujem vas što me se u svemu sjećate i što se držite kršćanskoga učenja koje sam vam predao. ");
INSERT INTO hrvbib_vpl VALUES ("C111_3","076_11_3","1CO","11","3","3","Ali hoću da nešto znate: svaki je čovjek odgovoran Kristu, žena je odgovorna mužu, a Krist je odgovoran Bogu. ");
INSERT INTO hrvbib_vpl VALUES ("C111_4","076_11_4","1CO","11","4","4","Muškarac sramoti Krista ako pokriva glavu dok se moli ili prorokuje. ");
INSERT INTO hrvbib_vpl VALUES ("C111_5","076_11_5","1CO","11","5","5","A žena sramoti svojega muža ako se moli ili prorokuje gologlava. To je isto kao da je obrijala glavu. ");
INSERT INTO hrvbib_vpl VALUES ("C111_6","076_11_6","1CO","11","6","6","Ako odbije na glavi nositi pokrivalo, neka ošiša svu kosu. A kako je sramota da žena bude kratke kose ili obrijane glave, treba nositi pokrivalo. ");
INSERT INTO hrvbib_vpl VALUES ("C111_7","076_11_7","1CO","11","7","7","Muškarac ne treba pokrivati glavu jer je na sliku i slavu Božju, a muškarcu je slava žena. ");
INSERT INTO hrvbib_vpl VALUES ("C111_8","076_11_8","1CO","11","8","8","Prvi čovjek nije nastao od žene, nego je ona nastala od njega. ");
INSERT INTO hrvbib_vpl VALUES ("C111_9","076_11_9","1CO","11","9","9","Nije, osim toga, muškarac stvoren zaradi žene, nego žena zaradi muškarca. ");
INSERT INTO hrvbib_vpl VALUES ("C111_10","076_11_10","1CO","11","10","10","Zato žena treba uvijek imati pokrivenu glavu kao znak vlasti, zbog anđela. ");
INSERT INTO hrvbib_vpl VALUES ("C111_11","076_11_11","1CO","11","11","11","Ali u odnosima između Gospodinove djece žena nije neovisna o mužu niti je muž neovisan o ženi. ");
INSERT INTO hrvbib_vpl VALUES ("C111_12","076_11_12","1CO","11","12","12","Jer iako je prva žena nastala od muškarca, od tada su svi muškarci rođeni od žene, a sve to dolazi od Boga. ");
INSERT INTO hrvbib_vpl VALUES ("C111_13","076_11_13","1CO","11","13","13","Prosudite sami dolikuje li da se žena moli Bogu gologlava. ");
INSERT INTO hrvbib_vpl VALUES ("C111_14","076_11_14","1CO","11","14","14","Nije li očito da je muškarcu sramota imati dugu kosu? ");
INSERT INTO hrvbib_vpl VALUES ("C111_15","076_11_15","1CO","11","15","15","I nije li očito da je duga kosa ženi na ponos? Jer dana joj je kao pokrivalo. ");
INSERT INTO hrvbib_vpl VALUES ("C111_16","076_11_16","1CO","11","16","16","A želi li se tko oko toga prepirati, mogu samo reći da u nas nije takav običaj te da tako drže i u drugim crkvama Božjim. ");
INSERT INTO hrvbib_vpl VALUES ("C111_17","076_11_17","1CO","11","17","17","Ima još nešto u čemu vas ne mogu pohvaliti. Čini mi se da vaši zajednički sastanci donose više štete nego koristi. ");
INSERT INTO hrvbib_vpl VALUES ("C111_18","076_11_18","1CO","11","18","18","Prije svega, čujem, a donekle i vjerujem da kad se okupite u zajednici, među vama nastaje razdor. ");
INSERT INTO hrvbib_vpl VALUES ("C111_19","076_11_19","1CO","11","19","19","Takvih podjela, nesumnjivo, mora biti da se pokaže tko je Bogu po volji. ");
INSERT INTO hrvbib_vpl VALUES ("C111_20","076_11_20","1CO","11","20","20","Kad se dakle sastajete, to više nije blagovanje Gospodnje večere ");
INSERT INTO hrvbib_vpl VALUES ("C111_21","076_11_21","1CO","11","21","21","jer pohlepno jedete vlastitu hranu ne dijeleći ju s drugima. Tako jedni gladuju, dok se drugi opijaju. ");
INSERT INTO hrvbib_vpl VALUES ("C111_22","076_11_22","1CO","11","22","22","Ne možete li doma jesti i piti? Ili zaista prezirete Božju crkvu i sramotite siromahe? Što da vam na to kažem? Da vas pohvalim? Ne mogu vas u tome pohvaliti. ");
INSERT INTO hrvbib_vpl VALUES ("C111_23","076_11_23","1CO","11","23","23","Prenosim vam što je Gospodin rekao. One noći kad je izdan, uzeo je kruh, ");
INSERT INTO hrvbib_vpl VALUES ("C111_24","076_11_24","1CO","11","24","24","zahvalio Bogu za njega, razlomio ga i rekao: “Ovo je moje tijelo—za vas. Ovo činite meni na spomen.” ");
INSERT INTO hrvbib_vpl VALUES ("C111_25","076_11_25","1CO","11","25","25","Tako je nakon večere uzeo i čašu te rekao: “Ovo je čaša Novoga saveza, zapečaćenoga mojom prolivenom krvlju. Činite to meni na spomen svaki put kad ga pijete!” ");
INSERT INTO hrvbib_vpl VALUES ("C111_26","076_11_26","1CO","11","26","26","Svaki put kad jedete taj kruh ili pijete tu čašu, navješćujete Gospodinovu smrt dok opet ne dođe. ");
INSERT INTO hrvbib_vpl VALUES ("C111_27","076_11_27","1CO","11","27","27","Jede li dakle tko taj kruh ili pije tu čašu nedostojno Gospodina, kriv je jer griješi protiv tijela i krvi Gospodnje. ");
INSERT INTO hrvbib_vpl VALUES ("C111_28","076_11_28","1CO","11","28","28","Zato neka se svatko preispita prije nego što jede kruh i pije iz čaše. ");
INSERT INTO hrvbib_vpl VALUES ("C111_29","076_11_29","1CO","11","29","29","Jer tko jede kruh ili pije iz čaše nedostojno, ne iskazujući čast Kristovu tijelu, jede i pije Božju osudu nad sobom. ");
INSERT INTO hrvbib_vpl VALUES ("C111_30","076_11_30","1CO","11","30","30","Zato među vama ima mnogo slabih i bolesnih i mnogo vas umire. ");
INSERT INTO hrvbib_vpl VALUES ("C111_31","076_11_31","1CO","11","31","31","Preispitujemo li se, Bog nas neće tako kažnjavati. ");
INSERT INTO hrvbib_vpl VALUES ("C111_32","076_11_32","1CO","11","32","32","Ali zato što nas Gospodin prosuđuje i kažnjava, nećemo biti osuđeni sa svijetom. ");
INSERT INTO hrvbib_vpl VALUES ("C111_33","076_11_33","1CO","11","33","33","I zato, draga braćo, kad se sastajete na večeru Gospodnju, čekajte jedni druge. ");
INSERT INTO hrvbib_vpl VALUES ("C111_34","076_11_34","1CO","11","34","34","Ako ste zaista gladni, jedite doma da vam sastanak ne bude na osudu. O drugome ću vas uputiti kad dođem. ");
INSERT INTO hrvbib_vpl VALUES ("C112_1","076_12_1","1CO","12","1","1","A sad ću vam, draga braćo i sestre, nešto napisati o darovima koje daje Sveti Duh, da ne ostanete u neznanju. ");
INSERT INTO hrvbib_vpl VALUES ("C112_2","076_12_2","1CO","12","2","2","Znate da ste, dok ste još bili pogani, bili zavedeni i da ste se zanosili nijemim idolima. ");
INSERT INTO hrvbib_vpl VALUES ("C112_3","076_12_3","1CO","12","3","3","Zato želim da znate kako možete razaznati dolazi li što od Božjega Duha: Nitko pod djelovanjem Svetoga Duha ne može prokleti Isusa niti tko može reći: “Isus je Gospodin” ako nije pod djelovanjem Svetoga Duha. ");
INSERT INTO hrvbib_vpl VALUES ("C112_4","076_12_4","1CO","12","4","4","Duhovnih darova ima različitih, ali Sveti Duh koji sve njih daje isti je. ");
INSERT INTO hrvbib_vpl VALUES ("C112_5","076_12_5","1CO","12","5","5","Služba ima različitih, ali Gospodin kojemu služimo je isti. ");
INSERT INTO hrvbib_vpl VALUES ("C112_6","076_12_6","1CO","12","6","6","Iako djeluje na različite načine, isti je Bog koji čini sve u svima. ");
INSERT INTO hrvbib_vpl VALUES ("C112_7","076_12_7","1CO","12","7","7","Tko dobije objavu Svetoga Duha, dobio ju je za dobrobit cijele Crkve. ");
INSERT INTO hrvbib_vpl VALUES ("C112_8","076_12_8","1CO","12","8","8","Zaista, jednome Sveti Duh daje da govori riječi mudrosti, a drugome taj isti Duh daje govoriti riječ znanja. ");
INSERT INTO hrvbib_vpl VALUES ("C112_9","076_12_9","1CO","12","9","9","Jednima je u istome Duhu dana osobita vjera, a drugima moć da liječe bolesne. ");
INSERT INTO hrvbib_vpl VALUES ("C112_10","076_12_10","1CO","12","10","10","Nekima se daje moć da čine čudesa, drugima da prorokuju. Nekima je opet dana sposobnost da razlikuju djeluje li Božji Duh ili koji drugi duh. Neki imaju sposobnost govoriti jezike koje ne poznaju, a neki dobivaju tumačenje tih poruka. ");
INSERT INTO hrvbib_vpl VALUES ("C112_11","076_12_11","1CO","12","11","11","Samo je jedan Sveti Duh koji dijeli te darove. On jedini odlučuje koji će dar komu dati. ");
INSERT INTO hrvbib_vpl VALUES ("C112_12","076_12_12","1CO","12","12","12","Kao što se ljudsko tijelo sastoji od mnogo dijelova, ali svi oni tvore cjelinu, tako je i s Kristovim tijelom. ");
INSERT INTO hrvbib_vpl VALUES ("C112_13","076_12_13","1CO","12","13","13","Neki od nas su Židovi, neki pogani, neki robovi, a neki slobodni ljudi. Ali svi smo kršteni u Kristovo tijelo jednim Duhom i svi smo napojeni tim istim Duhom. ");
INSERT INTO hrvbib_vpl VALUES ("C112_14","076_12_14","1CO","12","14","14","Tijelo nema samo jedan ud, već mnogo udova. ");
INSERT INTO hrvbib_vpl VALUES ("C112_15","076_12_15","1CO","12","15","15","Ako noga kaže: “Ne pripadam tijelu jer nisam ruka”, hoće li zbog toga prestati biti dijelom tijela? ");
INSERT INTO hrvbib_vpl VALUES ("C112_16","076_12_16","1CO","12","16","16","I ako uho kaže: “Ne pripadam tijelu jer nisam oko”, hoće li zbog toga prestati biti dijelom tijela? ");
INSERT INTO hrvbib_vpl VALUES ("C112_17","076_12_17","1CO","12","17","17","Kad bi nam se tijelo sastojalo samo od oka, kako bismo čuli? Da nam je cijelo tijelo samo uho, kako bismo imali njuh? ");
INSERT INTO hrvbib_vpl VALUES ("C112_18","076_12_18","1CO","12","18","18","Ali Bog je naša tijela načinio s mnogim udovima i sve ih je na tijelu razmjestio kako je htio. ");
INSERT INTO hrvbib_vpl VALUES ("C112_19","076_12_19","1CO","12","19","19","Kad bi svi oni bili jedan ud, kakvo bi to bilo tijelo? ");
INSERT INTO hrvbib_vpl VALUES ("C112_20","076_12_20","1CO","12","20","20","Ali udova je mnogo, a tijelo je jedno. ");
INSERT INTO hrvbib_vpl VALUES ("C112_21","076_12_21","1CO","12","21","21","Ne može oko ruci, ili glava nogama, reći: “Ne trebam te!” ");
INSERT INTO hrvbib_vpl VALUES ("C112_22","076_12_22","1CO","12","22","22","Naprotiv, neki udovi koji se čine najslabijima zapravo su najpotrebniji. ");
INSERT INTO hrvbib_vpl VALUES ("C112_23","076_12_23","1CO","12","23","23","One udove tijela koji nam se čine najnečasnijima okružujemo većim poštovanjem. Manje pristojne udove prikrivamo većom pristojnošću, ");
INSERT INTO hrvbib_vpl VALUES ("C112_24","076_12_24","1CO","12","24","24","dok s pristojnima nije potrebno tako činiti. Ali Bog je sastavio naše tijelo tako da je posljednjem udu dao najviše časti ");
INSERT INTO hrvbib_vpl VALUES ("C112_25","076_12_25","1CO","12","25","25","da u tijelu ne bude razdora, nego da se udovi brinu jedni za druge. ");
INSERT INTO hrvbib_vpl VALUES ("C112_26","076_12_26","1CO","12","26","26","Ako jedan ud pati, trpe i ostali udovi; ako se jednomu iskazuje čast, svi se udovi tomu raduju. ");
INSERT INTO hrvbib_vpl VALUES ("C112_27","076_12_27","1CO","12","27","27","Svi ste vi skupa Kristovo tijelo, a svatko je od vas zaseban i nuždan ud na njemu. ");
INSERT INTO hrvbib_vpl VALUES ("C112_28","076_12_28","1CO","12","28","28","U Crkvi je Bog jedne postavio za apostole, druge za proroke, treće za učitelje, zatim neke da čine čudesa, nekima je dao dar iscjeljivanja, nekima dar pomaganja drugima, nekima dar upravljanja, a nekima da govore jezike koje nisu učili. ");
INSERT INTO hrvbib_vpl VALUES ("C112_29","076_12_29","1CO","12","29","29","Zar su svi apostoli? Jesu li svi proroci? Jesu li svi učitelji? Zar su svi čudotvorci? ");
INSERT INTO hrvbib_vpl VALUES ("C112_30","076_12_30","1CO","12","30","30","Ima li svatko dar iscjeljivanja? A dar govorenja jezicima koje nije učio? Može li svatko tumačiti poruke u tim jezicima? ");
INSERT INTO hrvbib_vpl VALUES ("C112_31","076_12_31","1CO","12","31","31","Čeznite za višim darovima. A pokazat ću vam još uzvišeniji put. ");
INSERT INTO hrvbib_vpl VALUES ("C113_1","076_13_1","1CO","13","1","1","Kad bih sve ljudske i anđeoske jezike govorio, a ljubavi ne bih imao, bio bih poput mjedi što ječi ili cimbala što zveči. ");
INSERT INTO hrvbib_vpl VALUES ("C113_2","076_13_2","1CO","13","2","2","Kad bih imao dar prorokovanja, kad bih razumio sva otajstva i imao sve znanje te takvu vjeru da bih i gore premještao, a ljubavi ne bih imao, bio bih—ništa. ");
INSERT INTO hrvbib_vpl VALUES ("C113_3","076_13_3","1CO","13","3","3","Kad bih siromasima razdao sav svoj imetak, kad bih i tijelo svoje predao da se sažeže, a ljubavi ne bih imao—ništa mi koristilo ne bi. ");
INSERT INTO hrvbib_vpl VALUES ("C113_4","076_13_4","1CO","13","4","4","Ljubav je strpljiva, ljubav je dobrostiva; ona ne zavidi, ne hvasta se, ne oholi se. ");
INSERT INTO hrvbib_vpl VALUES ("C113_5","076_13_5","1CO","13","5","5","Nije nepristojna, ne traži svoje pravo, nije razdražljiva, ne pamti zlo; ");
INSERT INTO hrvbib_vpl VALUES ("C113_6","076_13_6","1CO","13","6","6","ne raduje se nepravdi, nego istini. ");
INSERT INTO hrvbib_vpl VALUES ("C113_7","076_13_7","1CO","13","7","7","Sve izdržava, nikad ne gubi vjeru, uvijek se nada, sve podnosi. ");
INSERT INTO hrvbib_vpl VALUES ("C113_8","076_13_8","1CO","13","8","8","Ljubav nikad neće uminuti. Prorokovanje? Iščeznut će. Jezici? Zamuknut će. Znanje? Nestat će. ");
INSERT INTO hrvbib_vpl VALUES ("C113_9","076_13_9","1CO","13","9","9","Jer nepotpuno je naše znanje, nepotpuno naše prorokovanje. ");
INSERT INTO hrvbib_vpl VALUES ("C113_10","076_13_10","1CO","13","10","10","A kada dođe ono što je savršeno, uminut će ovo što je nepotpuno. ");
INSERT INTO hrvbib_vpl VALUES ("C113_11","076_13_11","1CO","13","11","11","Kad sam bio dijete, govorio sam kao dijete, razmišljao sam kao dijete, rasuđivao sam kao dijete. Kad sam postao zrelim čovjekom, odbacio sam što je djetinje. ");
INSERT INTO hrvbib_vpl VALUES ("C113_12","076_13_12","1CO","13","12","12","Sad vidimo u zrcalu, nejasno, a tada ćemo gledati licem u lice. Sada spoznajem nepotpuno, a tada ću spoznati savršeno, kao što sam i sam spoznan. ");
INSERT INTO hrvbib_vpl VALUES ("C113_13","076_13_13","1CO","13","13","13","A sada ostaje troje: vjera, nada i ljubav, ali najveća je među njima ljubav. ");
INSERT INTO hrvbib_vpl VALUES ("C114_1","076_14_1","1CO","14","1","1","Težite za ljubavlju! Žarko čeznite za duhovnim darovima, posebice za prorokovanjem! ");
INSERT INTO hrvbib_vpl VALUES ("C114_2","076_14_2","1CO","14","2","2","Jer tko govori u jezicima, Bogu govori; nitko ga, naime, ne razumije jer Duhom govori tajanstvene stvari. ");
INSERT INTO hrvbib_vpl VALUES ("C114_3","076_14_3","1CO","14","3","3","Tko prorokuje, međutim, govori ljudima: pomaže im da se izgrađuju u Gospodinu, hrabri ih i tješi. ");
INSERT INTO hrvbib_vpl VALUES ("C114_4","076_14_4","1CO","14","4","4","Tko govori u jezicima, izgrađuje sebe u Gospodinu, ali tko prorokuje, izgrađuje Crkvu. ");
INSERT INTO hrvbib_vpl VALUES ("C114_5","076_14_5","1CO","14","5","5","Želio bih da svi govorite u jezicima, ali još više da prorokujete. Jer tko prorokuje, veći je od onoga tko govori u drugim jezicima, osim ako to protumači za izgradnju Crkve. ");
INSERT INTO hrvbib_vpl VALUES ("C114_6","076_14_6","1CO","14","6","6","Draga braćo, kad bih došao i govorio vam drugim jezicima, od kakve bi vam to bilo koristi ako vam ne bih priopćio ni kakvo otkrivenje, ni znanje, ni proroštvo, ni pouku? ");
INSERT INTO hrvbib_vpl VALUES ("C114_7","076_14_7","1CO","14","7","7","Čak i ako beživotna glazbala—flauta ili lira—ne daju od sebe razgovijetna glasa, kako ćete razabrati što izvode? ");
INSERT INTO hrvbib_vpl VALUES ("C114_8","076_14_8","1CO","14","8","8","Ili ako trublja ne dade jasna glasa, kako će vojnici znati da se treba spremiti za boj? ");
INSERT INTO hrvbib_vpl VALUES ("C114_9","076_14_9","1CO","14","9","9","Također, govorite li tuđim jezikom, nerazumljivo, tko će razabrati što govorite? Bit će kao da govorite u vjetar. ");
INSERT INTO hrvbib_vpl VALUES ("C114_10","076_14_10","1CO","14","10","10","Na svijetu ima toliko različitih jezika i oni koji ih razumiju odlično se na njima sporazumijevaju. ");
INSERT INTO hrvbib_vpl VALUES ("C114_11","076_14_11","1CO","14","11","11","Ali meni ne znače ništa. Neću razumjeti ljude koji mi tim jezicima govore niti će oni razumjeti mene. ");
INSERT INTO hrvbib_vpl VALUES ("C114_12","076_14_12","1CO","14","12","12","Kad već tako silno čeznete za duhovnim darovima, molite Boga da vam dade one koji će biti na izgradnju cijeloj Crkvi. ");
INSERT INTO hrvbib_vpl VALUES ("C114_13","076_14_13","1CO","14","13","13","Zato onaj koji govori jezike, neka moli i za dar tumačenja kako bi ljudima mogao reći i značenje poruke koju je u jezicima dobio. ");
INSERT INTO hrvbib_vpl VALUES ("C114_14","076_14_14","1CO","14","14","14","Jer ako se molim na jeziku koji ne razumijem, moj se duh moli, ali moj um u tome ne sudjeluje. ");
INSERT INTO hrvbib_vpl VALUES ("C114_15","076_14_15","1CO","14","15","15","Što mi je dakle činiti? Molit ću se duhom, ali također i umom, riječima koje razumijem. Pjevat ću hvalospjeve duhom, ali i umom. ");
INSERT INTO hrvbib_vpl VALUES ("C114_16","076_14_16","1CO","14","16","16","Jer ako se moliš Bogu samo duhom, kako će oni koji ne razumiju što govoriš s tobom slaviti Boga te reći “Amen” na tvoju molitvu? ");
INSERT INTO hrvbib_vpl VALUES ("C114_17","076_14_17","1CO","14","17","17","Izricat ćeš divne hvalospjeve, ali oni drugima neće biti na izgradnju. ");
INSERT INTO hrvbib_vpl VALUES ("C114_18","076_14_18","1CO","14","18","18","Ja, hvala Bogu, govorim u drugim jezicima više od svih vas. ");
INSERT INTO hrvbib_vpl VALUES ("C114_19","076_14_19","1CO","14","19","19","Ali na crkvenome sastanku draže mi je izgovoriti pet razumljivih riječi, da i druge poučim, nego izreći bezbroj riječi na drugim jezicima. ");
INSERT INTO hrvbib_vpl VALUES ("C114_20","076_14_20","1CO","14","20","20","Ne budite, draga braćo i sestre, poput djece u razboritosti glede toga, nego budite djeca po zloći, a zreli pameću. ");
INSERT INTO hrvbib_vpl VALUES ("C114_21","076_14_21","1CO","14","21","21","U Svetome pismu piše da je Gospodin rekao: “Govorit ću svom narodu nepoznatim jezicima i kroz usne tuđinaca. Ali čak me ni tada neće poslušati.” ");
INSERT INTO hrvbib_vpl VALUES ("C114_22","076_14_22","1CO","14","22","22","Drugi jezici dakle nisu znak zbog kojega će nevjerni povjerovati nego ih ostavlja u nezanju. Ali proroštvo navodi nevjernike da vjeruju. ");
INSERT INTO hrvbib_vpl VALUES ("C114_23","076_14_23","1CO","14","23","23","Govore li, primjerice, na crkvenome sastanku svi u drugim jezicima, a uđu nevjernici ili tko neupućen u te stvari, pomislit će da ste poludjeli. ");
INSERT INTO hrvbib_vpl VALUES ("C114_24","076_14_24","1CO","14","24","24","Ali ako svi prorokujete, a uđe koji nevjernik ili neupućen čovjek, shvatit će da je grešnik i vaše će ga riječi osuditi. ");
INSERT INTO hrvbib_vpl VALUES ("C114_25","076_14_25","1CO","14","25","25","Dok bude slušao, tajne njegova srca bit će razotkrivene te će pasti na koljena i pokloniti se Bogu i priznati: “Bog je zaista među vama!” ");
INSERT INTO hrvbib_vpl VALUES ("C114_26","076_14_26","1CO","14","26","26","Braćo i sestre, kad se dakle sastanete, netko će imati hvalospjev, netko pouku, netko otkrivenje koje mu je Bog dao, netko će govoriti nepoznatim jezikom, a netko će to tumačiti. Ali sve što činite mora svima biti na izgradnju u Gospodinu. ");
INSERT INTO hrvbib_vpl VALUES ("C114_27","076_14_27","1CO","14","27","27","Neka nepoznatim jezikom govore samo dvoje ili troje, i to jedan po jedan, a netko neka tumači što govore. ");
INSERT INTO hrvbib_vpl VALUES ("C114_28","076_14_28","1CO","14","28","28","Ako pak nema nikoga tko bi to znao protumačiti, neka taj šuti u Crkvi i govori samo sebi i Bogu. ");
INSERT INTO hrvbib_vpl VALUES ("C114_29","076_14_29","1CO","14","29","29","Neka prorokuje samo dvoje ili troje, a zatim neka drugi prosuđuju njihovu poruku. ");
INSERT INTO hrvbib_vpl VALUES ("C114_30","076_14_30","1CO","14","30","30","Ali ako za čijeg prorokovanja tko drugi dobije objavu od Boga, prvi neka ušuti. ");
INSERT INTO hrvbib_vpl VALUES ("C114_31","076_14_31","1CO","14","31","31","Tako ćete, jedan po jedan, svi moći prorokovati, da svi budu poučeni i ohrabreni. ");
INSERT INTO hrvbib_vpl VALUES ("C114_32","076_14_32","1CO","14","32","32","Upamtite da oni koji prorokuju vladaju svojim proročkim duhovima te mogu čekati svoj red. ");
INSERT INTO hrvbib_vpl VALUES ("C114_33","076_14_33","1CO","14","33","33","Jer Bog nije Bog nereda, nego Bog mira. Kao i u svim ostalim crkvama, ");
INSERT INTO hrvbib_vpl VALUES ("C114_34","076_14_34","1CO","14","34","34","žene neka šute na sastancima. Nije im dopušteno govoriti. Neka se u svezi s tim pokore odredbama Zakona. ");
INSERT INTO hrvbib_vpl VALUES ("C114_35","076_14_35","1CO","14","35","35","Imaju li pitanja, neka doma pitaju svoje muževe jer nije primjereno da žene govore na crkvenim sastancima. ");
INSERT INTO hrvbib_vpl VALUES ("C114_36","076_14_36","1CO","14","36","36","Mislite li da spoznaja Božje riječi počinje i završava s vama Korinćanima? Jako se varate. ");
INSERT INTO hrvbib_vpl VALUES ("C114_37","076_14_37","1CO","14","37","37","Tvrdi li tko od vas da je prorok ili da je obdaren duhom, treba znati da je ovo što vam pišem zapovijed samoga Gospodina. ");
INSERT INTO hrvbib_vpl VALUES ("C114_38","076_14_38","1CO","14","38","38","Tko to ne priznaje, ni Gospodin njega neće priznati. ");
INSERT INTO hrvbib_vpl VALUES ("C114_39","076_14_39","1CO","14","39","39","Zato, braćo i sestre, čeznite za darom prorokovanja i ne branite govoriti drugim jezicima. ");
INSERT INTO hrvbib_vpl VALUES ("C114_40","076_14_40","1CO","14","40","40","Ali neka sve bude primjereno i uredno. ");
INSERT INTO hrvbib_vpl VALUES ("C115_1","076_15_1","1CO","15","1","1","Želim vas, draga braćo i sestre, podsjetiti na evanđelje koje sam vam propovijedao, koje ste prihvatili i u kojemu ste još postojani. ");
INSERT INTO hrvbib_vpl VALUES ("C115_2","076_15_2","1CO","15","2","2","Po tome se evanđelju spašavate ako ga se držite onako kako sam vam navijestio. Inače ste uzalud povjerovali. ");
INSERT INTO hrvbib_vpl VALUES ("C115_3","076_15_3","1CO","15","3","3","Prenio sam vam najprije ono što mi je rečeno—da je Krist umro za naše grijehe, baš kao što piše u Svetome pismu, ");
INSERT INTO hrvbib_vpl VALUES ("C115_4","076_15_4","1CO","15","4","4","da je pokopan i da je treći dan uskrsnuo od mrtvih, također prema Svetome pismu. ");
INSERT INTO hrvbib_vpl VALUES ("C115_5","076_15_5","1CO","15","5","5","Ukazao se Petru, a zatim i svoj dvanaestorici apostola. ");
INSERT INTO hrvbib_vpl VALUES ("C115_6","076_15_6","1CO","15","6","6","Zatim se ukazao braći kojih je bilo više od pet stotina. Većina njih još je živa, a neki su i umrli. ");
INSERT INTO hrvbib_vpl VALUES ("C115_7","076_15_7","1CO","15","7","7","Ukazao se poslije Jakovu, pa opet svim apostolima. ");
INSERT INTO hrvbib_vpl VALUES ("C115_8","076_15_8","1CO","15","8","8","Napokon se ukazao i meni, mnogo kasnije, kao nedonoščetu. ");
INSERT INTO hrvbib_vpl VALUES ("C115_9","076_15_9","1CO","15","9","9","Jer ja sam najmanji od apostola. Nisam dostojan ni nazvati se apostolom jer sam progonio Božju crkvu. ");
INSERT INTO hrvbib_vpl VALUES ("C115_10","076_15_10","1CO","15","10","10","Ali što god da sada jesam, to sam zato što mi je Bog iskazao milost—i to nije bilo uzalud. Naprotiv, trudio sam se više nego svi ostali apostoli, ali to nije moja zasluga, već Božja milost. ");
INSERT INTO hrvbib_vpl VALUES ("C115_11","076_15_11","1CO","15","11","11","Zato nije važno propovijedam li ja ili oni. Važno je da ste zbog našega propovijedanja povjerovali. ");
INSERT INTO hrvbib_vpl VALUES ("C115_12","076_15_12","1CO","15","12","12","Ali ako propovijedamo da je Krist uskrsnuo od mrtvih, zašto neki od vas govore da uskrsnuća nema? ");
INSERT INTO hrvbib_vpl VALUES ("C115_13","076_15_13","1CO","15","13","13","Jer ako nema uskrsnuća od mrtvih, onda ni Krist nije uskrsnuo. ");
INSERT INTO hrvbib_vpl VALUES ("C115_14","076_15_14","1CO","15","14","14","A ako Krist nije uskrsnuo, naše je propovijedanje, kao i vaša vjera, uzaludno. ");
INSERT INTO hrvbib_vpl VALUES ("C115_15","076_15_15","1CO","15","15","15","Ako mrtvi zaista ne uskrsavaju, onda smo mi apostoli lažni Božji svjedoci zato što smo posvjedočili da je on uskrisio Krista, kojega nije uskrisio. ");
INSERT INTO hrvbib_vpl VALUES ("C115_16","076_15_16","1CO","15","16","16","Jer ako mrtvi neće uskrsnuti, onda ni Krist nije uskrsnuo. ");
INSERT INTO hrvbib_vpl VALUES ("C115_17","076_15_17","1CO","15","17","17","A ako Krist nije uskrsnuo, onda je vaša vjera uzaludna jer ste još uvijek pod osudom svojih grijeha. ");
INSERT INTO hrvbib_vpl VALUES ("C115_18","076_15_18","1CO","15","18","18","Ako je tako, svi umrli koji su vjerovali u Krista izginut će! ");
INSERT INTO hrvbib_vpl VALUES ("C115_19","076_15_19","1CO","15","19","19","Pouzdajemo li se u Krista samo za ovaj život, najbjedniji smo od svih ljudi. ");
INSERT INTO hrvbib_vpl VALUES ("C115_20","076_15_20","1CO","15","20","20","Ali činjenica je da je Krist uskrsnuo od mrtvih. Prvi je od svih umrlih koji će ponovno ustati u život. ");
INSERT INTO hrvbib_vpl VALUES ("C115_21","076_15_21","1CO","15","21","21","Smrt je ušla u svijet zbog onoga što je učinio prvi čovjek, a zbog onoga što je učinio jedan drugi Čovjek, Krist, mrtvi će uskrsnuti. ");
INSERT INTO hrvbib_vpl VALUES ("C115_22","076_15_22","1CO","15","22","22","Jer kao što svi umiremo zato što smo Adamovi potomci, tako ćemo i u Kristu svi biti oživljeni. ");
INSERT INTO hrvbib_vpl VALUES ("C115_23","076_15_23","1CO","15","23","23","Ali uskrsnuće se zbiva redom: najprije je uskrsnuo Krist, a kad on opet dođe, uskrsnut će i svi koji njemu pripadaju. ");
INSERT INTO hrvbib_vpl VALUES ("C115_24","076_15_24","1CO","15","24","24","Zatim će doći svršetak—kad on, pobijedivši svako neprijateljsko poglavarstvo, vlast i silu—preda Kraljevstvo Bogu Ocu. ");
INSERT INTO hrvbib_vpl VALUES ("C115_25","076_15_25","1CO","15","25","25","Jer će Krist biti kralj tako dugo dok mu svi njegovi neprijatelji ne budu bačeni pod noge. ");
INSERT INTO hrvbib_vpl VALUES ("C115_26","076_15_26","1CO","15","26","26","Posljednji neprijatelj kojega će uništiti bit će smrt. ");
INSERT INTO hrvbib_vpl VALUES ("C115_27","076_15_27","1CO","15","27","27","Jer Sveto pismo kaže: “Bog je sve podložio njegovoj vlasti.” “Sve”, razumije se, ne znači i samoga Boga jer je on Kristu i dao vlast. ");
INSERT INTO hrvbib_vpl VALUES ("C115_28","076_15_28","1CO","15","28","28","Kad sve pobijedi, Sin će i samoga sebe podložiti Bogu, koji je sve podložio njegovoj vlasti, da Bog bude sve u svemu. ");
INSERT INTO hrvbib_vpl VALUES ("C115_29","076_15_29","1CO","15","29","29","Ako mrtvi neće uskrsnuti, što misle postignuti oni koji se krste umjesto mrtvih? Čemu to čine ako mrtvi jednog dana neće uskrsnuti? ");
INSERT INTO hrvbib_vpl VALUES ("C115_30","076_15_30","1CO","15","30","30","I zašto bismo se mi neprestano izlagali pogiblima? ");
INSERT INTO hrvbib_vpl VALUES ("C115_31","076_15_31","1CO","15","31","31","Braćo draga, svednevice se suočavam sa smrću—tako mi vas, koji ste moj ponos u našemu Gospodinu Isusu Kristu. ");
INSERT INTO hrvbib_vpl VALUES ("C115_32","076_15_32","1CO","15","32","32","Kakva je onda smisla imalo boriti se s divljim zvijerima—s onim ljudima u Efezu? Ako nema uskrsnuća, “jedimo i pijmo jer sutra ćemo umrijeti!” ");
INSERT INTO hrvbib_vpl VALUES ("C115_33","076_15_33","1CO","15","33","33","Ne dajte se zavesti; “Loše društvo kvari dobre običaje.” ");
INSERT INTO hrvbib_vpl VALUES ("C115_34","076_15_34","1CO","15","34","34","Opametite se i prestanite griješiti. Jer, na vašu sramotu, neki od vas i ne poznaju Boga. ");
INSERT INTO hrvbib_vpl VALUES ("C115_35","076_15_35","1CO","15","35","35","Ali netko će upitati: “Kako će mrtvi uskrsnuti? Kakva će tijela imati?” ");
INSERT INTO hrvbib_vpl VALUES ("C115_36","076_15_36","1CO","15","36","36","Nerazumna li pitanja! Kad zasijete sjeme u zemlju, ono neće oživjeti i porasti u biljku ako najprije ne umre. ");
INSERT INTO hrvbib_vpl VALUES ("C115_37","076_15_37","1CO","15","37","37","Ne siješ u zemlju biljku kakva će porasti, već golo sjeme pšenice—ili čega drugoga. ");
INSERT INTO hrvbib_vpl VALUES ("C115_38","076_15_38","1CO","15","38","38","Bog mu zatim daje novo tijelo kakvo hoće, i to različita oblika raznim vrstama sjemenja. ");
INSERT INTO hrvbib_vpl VALUES ("C115_39","076_15_39","1CO","15","39","39","Kao što ima različitih vrsta sjemenja i biljaka, tako se razlikuju i tijela—ljudska, životinjska, ptičja ili riblja. ");
INSERT INTO hrvbib_vpl VALUES ("C115_40","076_15_40","1CO","15","40","40","Ima nebeskih tijela i zemaljskih tijela. Sjaj se nebeskih tijela razlikuje od sjaja zemaljskih. ");
INSERT INTO hrvbib_vpl VALUES ("C115_41","076_15_41","1CO","15","41","41","Drukčiji je sjaj sunca, mjeseca ili zvijezda. Zvijezde se čak i međusobno razlikuju po sjaju. ");
INSERT INTO hrvbib_vpl VALUES ("C115_42","076_15_42","1CO","15","42","42","Tako je i s uskrsnućem mrtvih: sije se u raspadljivosti, uskrsava u neraspadljivosti, ");
INSERT INTO hrvbib_vpl VALUES ("C115_43","076_15_43","1CO","15","43","43","sije se u sramoti, a uskrsava u slavi; sije se u slabosti, uskrsava u snazi; ");
INSERT INTO hrvbib_vpl VALUES ("C115_44","076_15_44","1CO","15","44","44","naša su tijela zasijana kao zemaljska, a uskrsnut će kao duhovna. Ako, naime, postoji naravno tijelo, postoji i ono duhovno. ");
INSERT INTO hrvbib_vpl VALUES ("C115_45","076_15_45","1CO","15","45","45","U Svetome pismu piše: “Prvi čovjek, Adam, postade živa duša.” Ali drugi Adam, to jest Krist, jest životvorni Duh. ");
INSERT INTO hrvbib_vpl VALUES ("C115_46","076_15_46","1CO","15","46","46","Ali najprije je bilo naravno, a tek poslije dolazi duhovno tijelo. ");
INSERT INTO hrvbib_vpl VALUES ("C115_47","076_15_47","1CO","15","47","47","Prvi je čovjek—Adam—načinjen od zemlje, a drugi je čovjek—Krist—došao s neba. ");
INSERT INTO hrvbib_vpl VALUES ("C115_48","076_15_48","1CO","15","48","48","Svi ljudi imaju zemaljsko tijelo poput Adamova, ali naša će nebeska tijela biti poput Kristova. ");
INSERT INTO hrvbib_vpl VALUES ("C115_49","076_15_49","1CO","15","49","49","Kao što smo sada poput zemljanog čovjeka Adama, tako ćemo jednog dana biti poput Krista koji je došao s neba. ");
INSERT INTO hrvbib_vpl VALUES ("C115_50","076_15_50","1CO","15","50","50","Tvrdim vam, braćo i sestre: tijelo i krv ne mogu baštiniti Božje kraljevstvo. Naša raspadljiva tijela ne mogu baštiniti neraspadljivost. ");
INSERT INTO hrvbib_vpl VALUES ("C115_51","076_15_51","1CO","15","51","51","Ali reći ću vam tajnu koju je Bog otkrio: nećemo svi umrijeti, ali svi ćemo se preobraziti. ");
INSERT INTO hrvbib_vpl VALUES ("C115_52","076_15_52","1CO","15","52","52","To će se dogoditi u tren oka, na zvuk posljednje trublje. Kad se ona oglasi, umrli će kršćani biti podignuti preobraženih tijela. A mi živi preobrazit ćemo se i nećemo umrijeti. ");
INSERT INTO hrvbib_vpl VALUES ("C115_53","076_15_53","1CO","15","53","53","Jer naša raspadljiva, smrtna zemaljska tijela moraju se preobraziti u neraspadljiva i besmrtna nebeska tijela. ");
INSERT INTO hrvbib_vpl VALUES ("C115_54","076_15_54","1CO","15","54","54","Kad se to dogodi, kad se naša raspadljiva zemaljska tijela preobraze u besmrtna nebeska tijela, napokon će se ostvariti ono što piše u Svetom pismu: “Pobjeda je progutala smrt. ");
INSERT INTO hrvbib_vpl VALUES ("C115_55","076_15_55","1CO","15","55","55","Smrti, gdje ti je pobjeda? Smrti, gdje ti je žalac?” ");
INSERT INTO hrvbib_vpl VALUES ("C115_56","076_15_56","1CO","15","56","56","Žalac smrti je grijeh, a snaga je grijeha u Zakonu. ");
INSERT INTO hrvbib_vpl VALUES ("C115_57","076_15_57","1CO","15","57","57","Hvala Bogu koji nam daje pobjedu nad grijehom i smrću kroz našega Gospodina Isusa Krista! ");
INSERT INTO hrvbib_vpl VALUES ("C115_58","076_15_58","1CO","15","58","58","Zato, voljena braćo i sestre, budite postojani i nepokolebljivi, revni u Gospodnjem djelu jer znate da nijedan vaš trud u Gospodinu nije uzaludan. ");
INSERT INTO hrvbib_vpl VALUES ("C116_1","076_16_1","1CO","16","1","1","Glede novca koji prikupljate za kršćane u Jeruzalemu, ravnajte se prema uputama koje sam dao crkvama u Galaciji. ");
INSERT INTO hrvbib_vpl VALUES ("C116_2","076_16_2","1CO","16","2","2","Svakoga prvog dana u tjednu neka svatko od vas odvoji novca, koliko može, da ne sabirete kad ja dođem. ");
INSERT INTO hrvbib_vpl VALUES ("C116_3","076_16_3","1CO","16","3","3","Kad dođem, napisat ću pisma preporuke onima koje odaberete da isporuče vaš milodar Jeruzalemu. ");
INSERT INTO hrvbib_vpl VALUES ("C116_4","076_16_4","1CO","16","4","4","Bude li prikladno da i ja pođem, možemo skupa putovati. ");
INSERT INTO hrvbib_vpl VALUES ("C116_5","076_16_5","1CO","16","5","5","Doći ću k vama kad proputujem Makedoniju. Njome, naime, kanim samo proći. ");
INSERT INTO hrvbib_vpl VALUES ("C116_6","076_16_6","1CO","16","6","6","A kod vas ću se možda i zadržati ili čak zimovati, da me otpremite prema sljedećem odredištu. ");
INSERT INTO hrvbib_vpl VALUES ("C116_7","076_16_7","1CO","16","7","7","Ne bih htio da vas i ovaj put vidim samo u prolazu. Želim malo ostati kod vas ako mi to Gospodin dopusti. ");
INSERT INTO hrvbib_vpl VALUES ("C116_8","076_16_8","1CO","16","8","8","Do tada ću ovdje u Efezu ostati do blagdana Pedesetnice ");
INSERT INTO hrvbib_vpl VALUES ("C116_9","076_16_9","1CO","16","9","9","jer mi se pružila dobra prilika za uspješan rad, ali i protivnika je mnogo. ");
INSERT INTO hrvbib_vpl VALUES ("C116_10","076_16_10","1CO","16","10","10","Dođe li Timotej, pobrinite se da se radeći među vama ne mora ničega bojati jer, kao i ja, radi na Gospodnjem djelu. ");
INSERT INTO hrvbib_vpl VALUES ("C116_11","076_16_11","1CO","16","11","11","Nemojte da ga tko prezre. Pošaljite ga natrag k meni u miru jer ga iščekujem s ostalom braćom. ");
INSERT INTO hrvbib_vpl VALUES ("C116_12","076_16_12","1CO","16","12","12","A što se tiče brata Apolona, silno sam ga nagovarao da vas s drugom braćom posjeti, ali nikako mu sada nije bilo po volji ići. No posjetit će vas kad mu se pruži prigoda. ");
INSERT INTO hrvbib_vpl VALUES ("C116_13","076_16_13","1CO","16","13","13","Bdijte! Budite postojani u vjeri! Budite hrabri i jaki! ");
INSERT INTO hrvbib_vpl VALUES ("C116_14","076_16_14","1CO","16","14","14","Što god činili, činite u ljubavi. ");
INSERT INTO hrvbib_vpl VALUES ("C116_15","076_16_15","1CO","16","15","15","Znate Stefanine ukućane i znate da su oni prvi u Ahaji postali kršćanima te da su se posvetili posluživanju drugih kršćana. Zaklinjem vas, braćo i sestre, ");
INSERT INTO hrvbib_vpl VALUES ("C116_16","076_16_16","1CO","16","16","16","da ih poštujete i budete im poslušni—kao i svima koji s njima surađuju i trude se. ");
INSERT INTO hrvbib_vpl VALUES ("C116_17","076_16_17","1CO","16","17","17","Veseli me Stefanina, Fortunatova i Ahajikova posjeta. Nadomjestili su mi vas koji niste ovdje. ");
INSERT INTO hrvbib_vpl VALUES ("C116_18","076_16_18","1CO","16","18","18","I mene su, kao i vas, umirili. Cijenite stoga takve ljude. ");
INSERT INTO hrvbib_vpl VALUES ("C116_19","076_16_19","1CO","16","19","19","Pozdravljaju vas azijske crkve. Mnogo vas u Gospodinu pozdravljaju Akvila i Priska te Crkva koja se sastaje u njihovu domu. ");
INSERT INTO hrvbib_vpl VALUES ("C116_20","076_16_20","1CO","16","20","20","Pozdravljaju vas svi vjernici. Pozdravite jedni druge svetim cjelovom. ");
INSERT INTO hrvbib_vpl VALUES ("C116_21","076_16_21","1CO","16","21","21","Pozdrav ću napisati vlastitom, Pavlovom rukom: ");
INSERT INTO hrvbib_vpl VALUES ("C116_22","076_16_22","1CO","16","22","22","Ako tko ne ljubi Gospodina, neka je proklet! Marana tha! ");
INSERT INTO hrvbib_vpl VALUES ("C116_23","076_16_23","1CO","16","23","23","Neka milost Gospodina Isusa bude s vama. ");
INSERT INTO hrvbib_vpl VALUES ("C116_24","076_16_24","1CO","16","24","24","Sve vas volim u Isusu Kristu.");
INSERT INTO hrvbib_vpl VALUES ("C21_1","077_1_1","2CO","1","1","1","Pišu vam Pavao, apostol Krista Isusa Božjom voljom, i brat Timotej. Pišemo Božjoj crkvi u Korintu i svima svetima u cijeloj Ahaji. ");
INSERT INTO hrvbib_vpl VALUES ("C21_2","077_1_2","2CO","1","2","2","Neka vam je milost i mir od našega Boga Oca i Gospodina Isusa Krista. ");
INSERT INTO hrvbib_vpl VALUES ("C21_3","077_1_3","2CO","1","3","3","Slava Bogu, Ocu našega Gospodina Isusa Krista. On je izvor svakog milosrđa i Bog koji nas tješi. ");
INSERT INTO hrvbib_vpl VALUES ("C21_4","077_1_4","2CO","1","4","4","On nas tješi u svim nevoljama, da bismo i mi mogli druge tješiti u nevoljama istom utjehom kojom Bog tješi nas. ");
INSERT INTO hrvbib_vpl VALUES ("C21_5","077_1_5","2CO","1","5","5","Koliko se obilno patnje za Krista izlijevaju na nas, toliko je preobilna i naša utjeha u Kristu. ");
INSERT INTO hrvbib_vpl VALUES ("C21_6","077_1_6","2CO","1","6","6","Podnosimo li nevolje, to je zaradi vaše utjehe i spasenja. Primamo li utjehu, to je zato da bismo vas mogli hrabriti kako biste strpljivo mogli podnositi iste patnje koje i mi podnosimo. ");
INSERT INTO hrvbib_vpl VALUES ("C21_7","077_1_7","2CO","1","7","7","Čvrsto vjerujemo da ćete, kao što s nama dijelite patnje, također dijeliti s nama i Božju utjehu. ");
INSERT INTO hrvbib_vpl VALUES ("C21_8","077_1_8","2CO","1","8","8","Željeli bismo da znate, braćo, kakve su nas nevolje zapale u Aziji. Opteretile su nas preko svake mjere, toliko preko naše snage da smo već bili izgubili nadu da ćemo preživjeti. ");
INSERT INTO hrvbib_vpl VALUES ("C21_9","077_1_9","2CO","1","9","9","Smatrali smo se već osuđenima na smrt, ali sve se to zbilo zato da se ne bismo uzdali u sebe, već u Boga koji uskrisuje mrtve. ");
INSERT INTO hrvbib_vpl VALUES ("C21_10","077_1_10","2CO","1","10","10","Od tolike nas je smrtne pogibli izbavio onaj u kojega se uzdamo da će nas i dalje izbavljati! ");
INSERT INTO hrvbib_vpl VALUES ("C21_11","077_1_11"